﻿USE sofia;
DROP TABLE IF EXISTS sofia.hltthb_vpl;
CREATE TABLE hltthb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hltthb_vpl WRITE;
INSERT INTO hltthb_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Thlak che a cuihnaak awh amak cet man, thlak thawlhkhqi a ceh lam awh amak dyi man, huhsit qaihsaikhqi ang ngawihnaak awh amak ngawi man thlang taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","A awmhlynaak taw Bawipa a cawngpyinaak awi awh awm nawh, ce cawngpyinaak awi ce than dai poek poepa hy. ");
INSERT INTO hltthb_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Anih taw tui keng awhkaw thing ling, qah tym awh ak qah, a hah amak reu man ing lo qu nawh, a ik-oeih sainaak a hoei awh laang poepa hy. ");
INSERT INTO hltthb_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Thlak chekhqi taw cemyihna am awm kawm uh! A mingmih taw canghi zilh ing a zawn amyihna ni ami awm. ");
INSERT INTO hltthb_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Cedawngawh thlak chekhqi taw awidengnaak awh am dyi thai kawm u saw, thlak thawlhkhqi awm thlakdyngkhqi ang cunnaak awh am dyi thai ti kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Bawipa ing thlakdyngkhqi a lam ce sim hy, cehlai thlak chekhqi a lam taw plawci kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Ikawtih, pilnam ing za qu unawh thlang boeih ing a hqawng a hqap mai awh aming hqum qu hy voei? ");
INSERT INTO hltthb_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Khawmdek sangpahrangkhqi ing Bawipa ingkaw Situi a syp thlang ce qaal na thawh sih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","A mingmih a thiqui ce boet pe unawh taw, amik khawceh bynkhqi awm khawng pe valh u sih”, ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Khan awh BOI na ak ngawi ce qaai nawh; Bawipa ing cekkhqi ce qaih am qin nak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Cekcoengawh a mingmih ce ak kawsonaak ing toel khqi nawh, ak kawtawknaak ing ly a lap sak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Kamah qoe ing ka tlang ciim Zion awh ka sangpahrang ce ngawih sak hawh nyng”, tinawh kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Bawipa ak awipeek ce khypyi kawng. “Nang taw ka capa na awm hyk ti; tuhngawi awhkawng na capa na awm nyng” ni tina hy. ");
INSERT INTO hltthb_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Thoeh law lah cawhtaw pilnam ce qo na ni pe kawng, khawmdek a dytnaak dy na koena awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Thicung ing a mingmih ce nang ing uk khqi kawp ti, dek-am ami deep kqek kqek amyihna cekkhqi ce deep khqi kqek kqek kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Cedawngawh nangmih sangpahrangkhqi, cyi unawh taw, Aw nangmih khawmdek ukkungkhqi ngaihtaak ing awm hlah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Kqih doena Bawipa bi ce bi unawh awmhly doena thyn lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Cakpa ce mawk lah uh, cekaa awhtaw ak kaw so kawmsaw na lam awh plawci hau kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Aw Bawipa, ka qaalkhqi doem soeih mah hy! Kai qaal na anik thawh sihkhqi doem soeih hy! ");
INSERT INTO hltthb_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Khawsa ing am hul tang” tinawh thlang khawzah ing ni tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Bawipa, nang taw kai anik hlipkung phuhqa na awm hyk ti, kak khanawh boeimangnaak ce ni pe nawh ka luu ni zoek pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Bawipa venawh khawteh na khy nyng saw, anih ing a hun ciim awhkawng nim hlat pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Nung zaih nawh ip nyng; Bawipa ing a nimtu khak a dawngawh hang hqyng law tlaih bai nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Qaal thonghqa ing hu hai na nik en khoep bai seiawm ap kqih qoe kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Aw Bawipa tho lah! ka Khawsa nang ing ni hul lah! Ka qaalkhqi a kapkhe quh ce vyk pek khqi nawhtaw, thlak chekhqi a haa ce khoeng pek khqi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Hulnaak taw Bawipa ven awhkawng law hy. Nak thlangkhqik khanawh na zosennaak awm seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Aw ka dyngnaak Khawsa, ka nik khy awh ce oei lah. Ngaih kyi ing ka awm awh ngaihqepnak ni pe lah; nim qeen nawh kak cykcah awi ning ngai pe lah. ");
INSERT INTO hltthb_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Aw thlangkhqi, ka boeimangnaak ve han dy awh nu chahqai na naming coeng hly sak hy voei? Han dy awh nu oek thawlhnaak ce lungna unawh, amak thym khawsa ce nami sui khak kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Bawipa ing amah ben awh ak ypawm thlangkhqi ce amah aham hoep hawh hy ti sim lah uh; kak khy awh Bawipa ing kak awi za kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Namik kaw a sonaak awh koeh thawlh uh; ihkhun awh naming zaih awh namik kaw poek hqeet unawh awm dym uh. ");
INSERT INTO hltthb_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Ak thym bulnaak ce nawn nawh Bawipa ce ypna lah. ");
INSERT INTO hltthb_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","U ing nu them leek a nim huh lah voei?” thlang khawzah ing ti uhy. Aw Bawipa na haai vangnaak ce kak khanawh be sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Caang ingkaw misur thaih ami zen awhkaw zeelnaak anglakawh, kak kawlung ve zeelnaak ak bau soeih ing be sak khqpet hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Zaih nyng saw ngaihding cana ip hly hawh nyng; Aw Bawipa ka loetnaak taw nang doek khoeih ni. ");
INSERT INTO hltthb_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Aw Bawipa kak awi ce ning ngai pe nawh, kak khy awi ce poek lah. ");
INSERT INTO hltthb_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Ka sangpahrang ingkaw ka Khawsa kak khy awi ce ngai lah; na venawh nik cykcah law nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Bawipa, mymcang awh kak awi ve ngai tiksaw; mymcang awh na haiawh qeennaak thoeh doena ngaih-unaak ing qeh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Nang taw thawlhnaak awh ak zeel Khawsa na am awm hyk ti; na venawh thlak chekhqi am awm thai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Thlak oek qu soeih ing na haiawh am dyi thai ti kawmsaw; ik-oeih ak sai palhkhqi ce nang ing sawh na hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","A qaai ak kqawnkhqi ce nang ing hqe hyk ti; thlang a thi ak ngaihkhqi ingkaw a qaai ak kqawnkhqi ce Bawipa ing tyih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Cehlai kai taw na lungnaak ak caming na ip khuina law kawng; kqihchahnaak ing na bawk im ciim benna koep kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Aw Bawipa ka qaalkhqi a awm dawngawh na dyngnaak benna ni hqui lah; ka haiawh na lampyi ce dyng sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Cekkhqi am khak khui awhkaw awi taw lungoet awm cangnaak kawina am awm hy; kawtih, amik kawlungkhqi seetnaak ing be uhy. Amik awihqawngkhqi ce phyi ak awng qu hyt amyihna awm nawh, a mim lai ing ami qaai kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Aw Khawsa, cekkhqi ce thlak thawlh na kqawn khqi hlah! Aming cainaak ce a mimah ang tluknaak na awm lat seh nyng. Thawlhnaak khawzah ami sai hawh a dawngawh hqek khqi bang hlah, cekkhqi ing nang ni oelh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Cehlai, nang awh thuknaak ak suikhqi taw zeel u seh. Zeel doena laa sa u seh, cekkhqi ce chung khqi khoep lah. Cawhtaw nang ming ak lungnaak thlangkhqi ce nang awh zeel kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Aw Bawipa thlakdyngkhqi taw nang ing zosennaak pe kawm tiksaw; nam qeennaak ing cekkhqi ce chung khqi khoep kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Aw Bawipa, kawso doena koeh ni zyi nawhtaw kaw tawknaak ing koeh ni toel. ");
INSERT INTO hltthb_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Bawipa kak tha am awm saw nang ing nim qeen lah; Aw Bawipa ka quhkhqi tlo boeih hawh nawh, ni qoei sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Ka hqingnaak ak tha hoet hawh hy. Aw Bawipa iqyt dy hly nu ve? ");
INSERT INTO hltthb_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Hlat law nawhtaw aw Bawipa kai ni hul lah; amak dyt thai na lungnaak ing ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","U ingawm a thih coeng awhtaw nang ce amni sim voel hy. U ing phyi khui awhkawng nang ce a nim kyihcah kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Kang ko aih awh hoet hawh nyng, than zung kang kqang aih awh ka ih hun plym sak hawh nyng, ka ihkhun awm ka mikphli tui ing plym hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Kawset aih awh ka mik awm ak tha hoet khing nawh, ka qaalkhqi dawngawh ka mik awm am dai voel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Nangmih them che ak saikhqi, ka ven awhkawng cet hlah uh, kawtih Bawipa ing kang kqangnaak awi za hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Qeennaak thoeh nawh kak khynaak awi ce Bawipa ing za nawh; kak cykcahnaak awi ce Bawipa ing do hy. ");
INSERT INTO hltthb_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Ka qaalkhqi boeih ing a mingngaih kyi kawmsaw chah phyi kawm uh; chah phyih doena ami huna hlat tlaih kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Aw Bawipa ka Khawsa, nang awh kai thuk nyng; kai anik hquutkhqi kut khui awhkawng ni hul lah; ");
INSERT INTO hltthb_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","U ingawm ama ni hul awhtaw samthyyn amyihna cekkhqi ing ni phu vit vit kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Aw Bawipa ka Khawsa, ve a them sai nawh ka kut ve a thawlh vek awhtaw - ");
INSERT INTO hltthb_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Kai ingqawi kang qoep pyi thlang venawh them che ka sai, am awhtaw a sawhqat na ka qaal a them ce ka muk peek awhtaw; ");
INSERT INTO hltthb_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","ka qaal ing ni hquut pha seitaw; ka hqingnaak ce dek awh leh nawh dekvai lak awh ni ih sak seh. ");
INSERT INTO hltthb_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","AW Bawipa, kawso doena tho nawhtaw; ka qaalkhqi ak kawsonaak ce tuk lah. Ka Khawsa hqyng nawhtaw awih thym kqawn lah. ");
INSERT INTO hltthb_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Thlangkqeng ak cunkyng ing nang ce nik chung khoep lah seh. Hun sang nakawng cekkhqi ce uk lah; ");
INSERT INTO hltthb_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Bawipa ing thlangkhqi ce awi deng lah seh. Aw Bawipa sawsang soeih, ka dyngnaak ingkaw ka leeknaak amyihna, nang ing awi ni deng lah. ");
INSERT INTO hltthb_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Aw ak dyng Khawsa, thlang ak kawlung kawpoek ak chingkung, thlak che khawboe seetnaak ce dyt sak nawhtaw thlakdyng ce loet sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Kai a phuhqa taw sawsang soeih Khawsa ni, anih ingtaw kawlung ak dyngkhqi ce hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Khawsa taw ak dyng awidengkung na awm nawh, myngawi kawsonaak ak dang sakkung Khawsa na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Anih ing a mang hloet qu mai mantaw, zawzi ce ak hqaat na taak kawmsaw; a licung ce a hawi coengawh hlah kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Thihnaak kawi lungpawk ce tlaih oepchoeh nawh; maina ak kqawng thai la ce met hyt hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Seetnaak ing phyihsu nawh kyinaak ak hu ingtaw seetnaak ce thang sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Lawk-kqawng ak co ing amah a lawk-kqawng nawn awh tla hy. ");
INSERT INTO hltthb_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Thawlhnaak ak sai ce amah a pum awh tla lat kawmsaw, boeseetnaak ak sai ce amah a luk khan awh tla kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","A dyngnaak awh ce Bawipa venawh zeelnaak awi kqawn nyng saw, sawsang soeih Bawipang ming kyihcahnaak laa ce sa kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Aw Bawipa, kaimih a Bawipa, khawmdek khan boeih awh na boeimangnaak be soeih mah hy! Na boeimangnaak ce khankhqik khanawh ta hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Qaalkhqi ingkaw lu ak lokhqi sit sak aham ingkaw na qaalkhqi awh, naasenkhqi ingkaw naacakhqi a hui awhkawng kyihcahnaak ce caksak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Khan nakaw ak awm na kut sai pihla ingkaw aihchikhqi, amah a awmnaak hun boeih awh na taakkhqi ce kak poek awh, ");
INSERT INTO hltthb_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Thlanghqing ve ikawpna a awm aih awh, na qeetnaak khaak nawh, thlanghqing capa awm na kqip loet hy voei? ");
INSERT INTO hltthb_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Anih ce khan khaw na ak awm anglakawh ak nem bet na sai nawh boeimang thangleeknaak ing sing hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Na kut saikhqi boeih ukkung na ta nawh, a khawk kaiawh ik-oeihkhqi boeih ce taak pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Tui a nga ingkaw kqawng nakaw qamsa boeih, ");
INSERT INTO hltthb_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","khawnghi nakaw chukphakhqi, tuih khui nakaw lum a nga boeih ingkaw tuicunli awhkaw ak cawlhtat boeih ce a khawk kaiawh taak pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Aw Bawipa, kaimih a Bawipa, khawmdek pum awh nang ming qypawm soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Aw Bawipa, kak kawlung boeih ing nang nim kyih vang; kawpoek kyi ik-oeih na sai boeih ce khypyi vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Namah awh ce kaw zeel nawh, awm kawng. Aw, sawsang soeih, nang ming kyihcahnaak laa sa vang. ");
INSERT INTO hltthb_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Ka qaalkhqi taw na haiawh bah unawh; seet doena ami huna hlat tlaih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Kak cangnaak awhtaw nang ing ning dyih pyi nawh; na ngawihdoelh awh ngawi nawh, ak dyng cana awi deng hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Pilnam thlangkhqi ce toel nawh, thlak chekhqi ce milh sak khqi hyk ti; cekkhqi ang ming ce kumqui dyna khawng pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Amak dyt thai seetnaak ing qaalkhqi ce zawl nawh, cekkhqi a khawk bau ce hqe pe pheng hawh hyk ti; ami sim loetnaak awm hqe pek khqi boeih hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Bawipa taw kumqui dyna boei na awm hy; awidengnaak aham a boei ngawihdoelh ce caksak hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Khawmdek ve ak dyng cana awi deng kawmsaw; thlangkhqi ce ak thym cana uk kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Bawipa taw thekha na ak awmkhqi ang dymnaak na awm nawh, kyinaak a awm tym awh ce vawng cak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Nang ming ak simkhqi ing nang ce ni ypna uhy. Bawipa, nang ingtaw nang anik suikhqi ce am qoeng hyt hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Zion awh boei na ak ngawi Bawipa venawh kyihnaak laa sa unawh, a ik-oeih sai ce pilnam thlangkhqi venawh khypyi lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Ikawtih, thlang thi a lawng sak ce sim loet nawh; khawdeng khuikha khqi ing kqangnaak awi ce ang zaak peek kaana am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Aw Bawipa, ka qaalkhqi ing ani thekhanaak khqi ve toek lah! Nim qeen nawh thihnaak chawmkeng khui awhkawng ni hqui lah. ");
INSERT INTO hltthb_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Cawhtaw na kyihcahnaak laa ce Zion canu ak chawmkeng awh khypyi thai kawng nyng saw, na hulnaak awh ce zeelnaak awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Pilnam thlangkhqi ing amik cawh lawk-kqawng khuiawh tla boeih uhy; a mimah ing ami zan hyt lawk awh aawk boeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Am dyngnaak awh ce Bawipa taw sim lah uh; cehlai thlak chekhqi taw a mimah a kut sai awh ce aawk nawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Khawsa ak hilh pilnam thlangkhqi ingkaw thlak chekhqi ingtaw phyi na ce cet kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Ak voethlauh thlangkhqi ce am hilh kawmsaw, khawdeng thlangkhqi ang ngaih-unaak awm am reng tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Aw Bawipa, tho lah, thlanghqing ing koeh ni noeng seh; na haiawh pilnam thlang awideng na awm u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Aw Bawipa, cekkhqi ce kqihnaak ing ly a lap sak khqi lah; pilnam boeih ve thlanghqing mai ni ti sim sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Aw Bawipa, kawtih ak hla na nang dyih? Kyinaak a awm huiawh kawtih nang thuh qu valh? ");
INSERT INTO hltthb_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Ak oek qu soeih thlak che ing tha amak awm thlangkhqi, amah ing teng nawh am tu thlangkhqi ce hquut hy. ");
INSERT INTO hltthb_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Ak kawlung hymnaak awh oek qu nawh; ak lawn na ak ngaih ce zoeksang nawh Bawipa taw hlah phlam hy. ");
INSERT INTO hltthb_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Ak oek qu thlak che ingtaw amah ingkaw amah am sui qu nawh; Ak poeknaak boeih awh Khawsa ham hun qoe am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","A lamkhqi boeih awh a zo awm hy. Anaa a hqam aih awh nang a cawngpyinaak awi ing hla qu hy nih; a qaalkhqi boeih ce huhsitnaak ing qaih na hy. ");
INSERT INTO hltthb_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Amah ingtaw, Ikaw ingawm am ning tah sak tikaw; zeel loet nyng saw kyinaak am hu tang tikawng” tinawh poek hy. ");
INSERT INTO hltthb_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Anih am kha taw seet lawhnaak, qaainaak ingkaw kqih am hqinnaak ing be hy, am lai awh awm kyinaak ingkaw seetnaak doek khoeih ni. ");
INSERT INTO hltthb_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Khawkeng imceng khqi awh ngawi nawh, ak awm poek poek khqi ce mam nawh him hy. ");
INSERT INTO hltthb_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Sendeih ing ak kawk khui awhkawng a qeh dym amyihna, a hlip naak awh qeh hy, hulkung amak awm thlang ce tu aham qeh nawh; bawmkung amak awmkhqi ce lawk ing sing hy. ");
INSERT INTO hltthb_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","A thekhanaak thlangkhqi ce kqih am hqin hy; cekkhqi ce ak thaawmnaak khuiawh tlaak sak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Amah ingtaw Khawsa ing hilh hawh hy; a hai sing khoep nawh am hu thai voel hy” tina poek hy. ");
INSERT INTO hltthb_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Aw Bawipa, tho hlah! Aw Khawsa na kut thlek hlah, hulkung amak ta thlangkhqi ce koeh hilh. ");
INSERT INTO hltthb_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Thlak che ing kawtih Bawipa a thekha naak? Ikawtih amah ingkaw amah, “Ikaw am ni tina tang”, tina ak poek hy voei? ");
INSERT INTO hltthb_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Cehlai aw Khawsa, kyinaak ingkaw ko kqangnaak ve toek nawhtaw; na kut khuiawh lawh aham poek lah. Kyinaak ak hukhqi ing nang a venawh pe qu unawh, pa amak takhqi ak hulkung na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Thlak chekhqi ingkaw thlak thawlh a baan ce hqem pe nawh; huh thai na ama awm hlan dy awh a thawlhnaak ce tlet pe lah. ");
INSERT INTO hltthb_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Bawipa taw kumqui awhkawng kumqui dy sangpahrang na awm hy; pilnam thlangkhqi taw a kut awhkawng kqeng bang kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Aw Bawipa, khuikha ak hukhqi a ngaihnaak ce zaak penawh; tha na peek coengawh, cekkhqi ang kqangnaak awi ce ngai pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Pa amak takhqi ingkaw a thenaak khqi ce dyih pyi nawh, khawmdek thlangkhqi ing cekkhqi ce am huhsit hqa voel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Bawipa awh thuk loet nyng. Kaw amyihna nang ing na ti; Pha amyihna na tlang awh ding hlah. ");
INSERT INTO hltthb_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Toek mai lah, thlak che ing licung hawi nawh; than a hypnaak awhkawng thlakdyng ce a lingbyi awh kah aham a licung qui awh laa met hyt hy. ");
INSERT INTO hltthb_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","A lungsym ce ni hqe peek hoek awhtaw, thlakdyng ing ikaw asai thai hly tang,” na ti? ");
INSERT INTO hltthb_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Bawipa taw bawkim ciim khuina awm nawh; Bawipa taw ak khan ngawihdoelh awh awm hy. Thlanghqing capakhqi ce khoem nawh; amik ing cekkhqi ce nym anai poepa hy. ");
INSERT INTO hltthb_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Bawipa ing thlakdyng nym anai nawh; thlak chekhqi ingkaw kawpoek sekhqi taw ang myihla ing sawh na hy. ");
INSERT INTO hltthb_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Thlak chekhqi ak khanawh mai-eh ingkaw katmai tlan sak kaw; ak hlawk soeih khawhli ce a mingmih a pang kawi na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Bawipa taw a dyng a dawngawh, ak thym ik-oeih ce lungna hy; kawlung ak dyngkhqi ingtaw a haai ce hu kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Bawipa ni bawm lah, Khawsa ak kqih thlang am awm voel hy. Thlanghqingkhqi anglakawh thlang ypawm qeeng kang hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Thlang boeih ing a imceng venawh qaih awi kqawn unawh; awih haal kqawnnaak hui ing ami qaai kqawn boeih hawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Bawipa ing awih haal kqawn nawh huikhqi ce qeet pek khqi seitaw, oek qunaak lai awm qeet pe seh. ");
INSERT INTO hltthb_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Lai ing ni noeng khqi ngai bit kaw; hui ni ta u saw kaw ningnih a boei na u nu ak awm bai?” ak tikhqi ce. ");
INSERT INTO hltthb_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Tha amak awm khawdeng thlangkhqi ingkaw, kaw amak ta thlanghqing konaak awi awh, tuh taw tho hawh kawng nyng. Cekkhqi ak kqawn seetkungkhqi ven awhkawng chung a hlip khqi kawng,” tinawh Bawipa ing tihy. ");
INSERT INTO hltthb_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","BawipaK awikhqi taw coet am kap qoe nawh, deknawng maih hlawk awh voei khqih dy ngun a tui tle ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Aw Bawipa, nang ing ni loet sak kawm tiksaw, cemyih, thlangkhqi anglakawhkawng ni hlip nik chung kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Thlangkhqi anglakawh chahnak hly kawi ik-oeih zoeksangnaak a awm awh, thlak chekhqi taw ami ngaih ngaih na chah phyih doena cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Aw Bawipa, handy hly nu? Kai na nim hilh hly loet hawh nawh nu? Handy nu na haai na thuh kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Handy awh kawpoek ingqawi kqak qu nih nawh myngawi kawseet ing ka awm loet kaw? Handy nu ka qaalkhqi ing kai ami noeng kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Aw Bawipa ka Khawsa, ni toek nawhtaw nim hlat lah. Kamik ve dai law sak lah, cek kaa mantaw thihnaak ing ip loet hawh kawng nyng; ");
INSERT INTO hltthb_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Cawhtaw ka qaalkhqi ing, “Noeng hawh nyng,” ni tina kawm usaw, kang tluk awh ce ka qaalkhqi zeel hawh kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Cehlai, amak dyt thai na lungnaak ce cangna nyng; na hulnaak awh kak kawlung zeel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Kak khan awh leek saw, Bawipa venawh laa sa vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Thlak qaw ingtaw ak kawk khuiawh, “Khawsa am awm hy,” ti. Kawna amak awm, amak thym ik-oeih ce sai hy; ik-oeih leek ak sai thlang pynoet ca awm am awm qoe hy. ");
INSERT INTO hltthb_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Ak zasim thai awm nawh, Khawsa ak sui thlang ak awm khoem hy voei nu, tinawh khan nakawng Khawsa ing thlanghqing capakhqi ce nuk toek law hy. ");
INSERT INTO hltthb_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Ak chang na pleng boeih unawh, plawci kang hawh uhy; ik-oeih leek ak sai thalng pynoet awm am awm nawh, pynoet ca awm am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Ik-oeih che ak saikhqi - thlang ing phaihpi a ai amyihna kak thlang ak daihkhqi, Bawipa amak khy man thlangkhqi ing a sim kaana awm hly u nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Thlakdyngkhqi ing cunnaak awh Bawipa taw a awm dawngawh, a mingmih ing kqihnaak ing be uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Nangmih thlak chekhqi khawdengkhqi ing cainaak kang pe u tik seiawm, Bawipa taw a mingmih ang thuknaak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Aw Israelkhqi thaawngnaak ce Zion awhkawng law lah voei! Bawipa ing ak thlangkhqi zoseennaak a peek tlaih awh, Jakob ing zeel seitaw Israel ing ak kaw zeel poe seh! ");
INSERT INTO hltthb_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Bawipa, na awmnaak hun ciim awh u nu ak awm kaw? Na tlang ciim awh u nu ak awm lah kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Coet kap kaana cet nawh ik-oeih dyng ak sai thlangkhqi, kawlung khui awhkawng ak thym awi ak kqawnkhqi. ");
INSERT INTO hltthb_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Am lai ing thlang amak theet man, a imceng venawh thawlhnaak ik-oeih am sai man nawh, a pilnam ang ming seetnaak amak sai man thlang, ");
INSERT INTO hltthb_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","thlak che husit nawh Bawipa ak kqih thlangkhqi ak zoeksangkhqi, amah aham tlo seiawm awitaak ak cak thlang, ");
INSERT INTO hltthb_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","A ca khawzah aih na tangka amak pu thlang ingkaw ak awm poek poek, thlang a venna ve mih ik-oeih ak sai thlangkhqi taw ityk awh awm am tat tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Aw Khawsa, ni loet sak lah, namah a venawh ni kang thuk law. ");
INSERT INTO hltthb_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Bawipa venawh, Nang taw ka Bawipa na awm hyk ti; nang kaa taw leeknaak tehca awm am ta nyng,” ka ti. ");
INSERT INTO hltthb_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Qam khuiawh ak awm thlang ciimkhqi ce, Boeimangnaak ing ak be kai a zeelnaak kungkhqi na awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Ak chang khawsakhqi venna ak cenkhqi ak kawseetnaak taw pung khqoet kaw. A mingmih a thi ce khawsakhqi hamna am hawk pe kawng nyng saw, a mingmih ang ming awm ka hui awh ap kqawn qoe kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Bawipa, ka huh hly kawi ingkaw ka boet ce ni taak pe hyt hawh tiksaw; ka huh hly kawi ce ni taak pe khak hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Khawqi ing a leeknaak soeih awh kai aham khan qu nawh; ka qo pang hly kawi awh ce zeel soeih nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Khaw anik poek peekkung Bawipa ce kyihcah vang; khawmthan awh awm kak kawlung ing ni cawngpyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Bawipa ce ka haiawh awm sak poepa nyng. Anih ce kak tang ben awh a awm dawngawh, am thyn qoe ti kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Cedawngawh kak kawlung zeel nawh kam lai ak kaw zeel hy; ka pum awm a sa loet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Ikawtih, nang ing phyi awh am ni cehta hyt kawm tiksaw, nak Thlang Ciim ce am thu sak kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Hqingnaak lam ce nani sim sak hawh a dawngawh; na haiawh zeelnaak, nak tang ben awhkaw kumqui zeelnaak ing ni be sak kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Aw Bawipa, dyngnaak ing ka thoeh law ve za nawhtaw, kak khynaak awi ve ngai law lah. Kak cykcahnaak benna nang haa keeng lah-qaai kqawnnaak hui awhkawng ak law awi amni. ");
INSERT INTO hltthb_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Nang a ven awhkawng kak khanawh awi tlyhnaak law seitaw ak thym ik-oeih ce namik ing hu lah seh. ");
INSERT INTO hltthb_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Kak kawlung ve nik ching nawh than awh ni hqip lah, ni nai ni nawng hlai hyk ti, kaw awm am hu kawp ti; kam kha ing am thlawlh tikaw ti hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Thlanghqing a ik-oeih sai amyihna - na hui awhkaw awi ing thlak chekhqi cehnaak lam awh am ka paanaak aham khoem qu hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Ka khawkham ing na lam hquut nawh; ka khaw ing am bah man hy. ");
INSERT INTO hltthb_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Aw Khawsa nang ce nik khy nyng, nang ing nim hlat kawm tiksaw; nang haa keng law nawh kak cykcahnaak awi ve za lah. ");
INSERT INTO hltthb_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Qaal anglakawhkawng nang awh thuknaak sui nawh tang kut ing ak hulkung, na lungnaak ak bau soeih ce dang sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Na mik thlang amyihna ni qym nawh, nang hla khuiawh ning thuk sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Kai cem a qaal na anik thawh sihkhqi ingkaw kai anik chung khoep ka pumsa qaal anglakawhkawng. ");
INSERT INTO hltthb_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Am thin ak sah thlang na awm unawh, am kha ing cawngcah qunaak awi kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Ka hu thuih law unawh nik chung khoep hawh uhy, Deklai khawngnaak aham ni mik lyl na hawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Mehsa buh na cawi khit nawh, ak plup nakawng qamsa cuuk sih aham ak cai samthyyn amyihna awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Aw Bawipa, tho lah, a mingmih ce mam khqi nawh, tluk sak khqi lah; nak zawzi ing thlak che kut khui awhkawng ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Aw Bawipa, na kut ing ce mih thlangkhqi, ve khawmdek hqing khui doeng awhkaw laksawng ak takhqi a kut khui awhkawng ni hlam lah. Thlangkhqi amik phoen ce kawn ing be sak khqi nawh, a canaakhqi awm kqeng nawh ami cakhqi aham khawhthem ce cun pek khqi uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Kai ingtaw dyngnaak ing na myi ce hu kawng; ka hang hqyng law awh, na myi ak lo na ka awm ce hu nyng saw kang ngaih tlyp tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Kak thaawmnaak na ak awm, Aw Bawipa, nang ce ni lungna nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Bawipa taw ka lungnu, ka vawngcak ingkaw ka hulkung na awm hy: Khawsa taw kang thuknaak lungnu na awm hy. Amah taw ka phuhqa ingkaw ka hulnaak kii, vawngcak boeih na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Kyihcah tyng Bawipa ce khy nyng saw, anih ing ka qaalkhqi anglakawhkawng ni hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Thihnaak quikhqi ing ni pin nawh seetnaak tuiphu ing ni zawl khup hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Ceikhui quikhqi ing ni pin qap nawh; thihnaak dawng ing ni mam khoep hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Kang ngaih a kyi awh Bawipa ce khy nyng; bawmnaak thoeh doena Khawsa venawh khy nyng. Anih ingtaw a bawkim awhkawng kak awi ning zaak pe nawh; kak khy awi ing a haiawh pha saw, ang haa khuiawh kun hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Khawmdek ing tyn nawh thyn hy, ak kawsonaak awh tlangkhqi awm am cei dyna tyn boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Am haqawng khui awhkawng maikhu cawn nawh; mai kqawng ce am khak khui awhkawng cawn hy; cawhkawng mai ce alh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Myi ak than tit tit ce a khawk kai awh ta nawh; khan khawnghi ce hawi nawh kqum law hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Chequbim ak khanawh ngawi nawh ang ding doena; zilh ang hla awhkawng hak pawm qu hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","A sing qunaak na than sai nawh, a ceng a cawi awh ak chung qunaak aham khan rawhnu pui tlan sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Ak vang soeih haai awhkawng myi ak sah soeih ingkaw khawkphla ce thai sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Khan nakawng Bawipa hum khawmrang nawh; sawsang soeih awh ak awi hum dur dur hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","La ing kap nawh a qaalkhqi ce a thek a zak na kqeng sak khqi khawnghak nawh, khaw khawteh na phla sak tiksaw hquut khqi khawnghak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Aw Bawipa tuicunli ang lawngnaak ce sai pe nawh, khawmdek ang dyihnaak hun ce nam haqawng awhkaw nang hqi ing zyi nawh kaa na tiksaw, pho sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Anih ing khan ben nakawng a baan thla nawh; a nimtu coengawh tuili dung awhkawng nik dawk hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Tha ak awm soeih qaal, am ka noeng thai khing ka thunkha khqi kut khui awhkawng ni hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Ka seetnaak khawnghyp awh ni mam khoep u seiawm, Bawipa taw tha anik pekung na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Anih ing a hoel a poeng na awmnaak hun na ni ceh pyi hy; kak khanawh ak kaw a law a dawngawh ni hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Bawipa ing ka dyngnaak lawt amyihna khaw nik poek pehy; ka kut qawi a ciim lawt amyihna laksawng ce ni pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Bawipa a lampyi ce ka hquut a dawngawh Khawsa cehta nawh thawlhnaak ce am sai nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Amah a cawngpyinaak awikhqi boeih ce ka haiawh awm nawh; ak awi tlypnaak ce am pleng taak man nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","A haiawh coet kap kaana awm nawh, thawlhnaak ce hqe nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Ka dyngnaak ingkaw amik huh awh ka kut qawi a ciim amyihna Bawipa ing laksawng ni pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Ueppawm thlang venawh ypawm na dang pe tiksaw, coet amak kap thlang venawh coet a kap kaana dang pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Ak zawziih thlang venawh ak zawziih na dang pe nawh, kawpoek ak kawi thlang venawh taw cyihnaak ce dang sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Dungvoeng na ak awmkhqi ce hul nawh ak thym na mik ak daikhqi ce ak nem na thla hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Aw Bawipa, nang ing ka mai-im ve vang law sak loet nawh; ka Khawsa ing thannaak ce vangnaak na coeng law sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Nang ak pyinaak ak caming ni ka qaal hquut nawh, ka Khawsa ing ni vawng ka lyn thai. ");
INSERT INTO hltthb_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Khawsa lampyi taw soep nawh Bawipa awi taw caih soeih hy. Amah awh ak thukkhqi boeih aham anih taw phuhqa na awm pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Bawipa coengawh u Khawsa nu ak awm bai? Ningmih a Khawsa am kaa taw u mih lungnu nu ak awm bai? ");
INSERT INTO hltthb_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Khawsa ing a bantha awm sak nawh ka lampyi soep sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Ka khaw ce saksuk khaw amyihna ni sai pe nawh hun sang na ning dyih sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Ka kutqawi ve qaal kahnaak ham ni cawng sak nawh, ka baan qawi ing qawhum la ce oi thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Noengnaak phuhqa ce nang ing ni pe nawh, nak tang kut ing nim tu hyk ti; dungvoeng na na awmnaak ing kai ni sang sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Ka khawk kai awhkaw lampyi ce kau law sak tiksaw, ka khaw am pleng thai voel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Ka qaalkhqi ce hquut nawh khai khqi nyng, ama ming qeng hlan dy taw am hlat kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","A mami thawh hqa kaana chawm khqi nyng, ka khawk kai na tlu boeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Qaal tuk aham thamahnaak ing ni thoeihcam nawh, ka qaalkhqi ce ka khawk kai na koep sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Nang ing ka qaalkhqi hu benna cen sak khqi hyk ti, cawh kai ing him khqi pheng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Khy laawt hlai uhy, cehlai a mingmih ak hul hly kawi pynoet awm am awm hy - Bawipa ing cekkhqi ak khynaak awi ce am hlat pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Zilh ing a zawn dekvai amyihna vyk khqi nyng saw, lam awhkaw nawngtui amyihna hawk khqi nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Kai anik tukkungkhqi kut khui awhkawng ni hul nawh; pilnam a lu na ni sai hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Kai a thang aming zaak awh, kak awi ngai unawh; qapchang thlangkhqi ing ka haiawh pe qu law uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Amik kaw boet nawh; a mimah a vawng kulh khui nakawng thyn doena law uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Bawipa taw hqing hy; ka lungnu venawh kyihcahnaak awm seh nyng! Ka hulkung Khawsa taw zoeksang na awm seh! ");
INSERT INTO hltthb_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Anih taw kai aham kut anik thung peekkung Khawsa na awm nawh, pilnam thlang anik noeng sakkung na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Ka qaalkhqi ven awhkawng anik hulkung na awm hy. Nang ing ka qaalkhqik khanawh ni zoeksang nawh, khawboek chekhqi kut khui awhkawng ni hul hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Cedawngawh aw Bawipa, nang ce pilnam thlangkhqing lak awh nim kyihcah vang; nang ming kyihcahnaak laa sa vang. ");
INSERT INTO hltthb_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Anih ing a sangpahqang venawh noengnaak ak bau soeih pe nawh; a caksak thlang venawh amak dyt thai qeennaak ce dang sak hy. David ingkaw a cadil naakhqi venawh kumqui dyna am qeennaak dang sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Khan khawkhqi ing Khawsa boeimangnaak khypyi unawh, khawnghi khqi ing a kut sai bibi ce khypyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Hypoet coeng hypoet cekkhqi ing awi kqawn unawh, than oet coeng than oet cyihnaak ce dang sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Han a hun awh awm am ning zaak hly kawi awih kqawn ingkaw awi am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Cekkhqi ak awi ing khawmdek pum pha nawh, khawmdek a dytnaak dyna thang khawnghak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Cadawng zu ak lo iptung khui awhkawng ak thoeng law ingkaw, ang tah ak ly thlang dawng loehlangnaak awh awmhly doena ak dawng ing myih qu hy. ");
INSERT INTO hltthb_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Khan a dytnaak awhkawng thoeng law nawh a dytnaak bai dyna vil hy; a hlawknaak awh ikaw awm thuh thai na am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Bawipa a cawngpyinaak awi taw soep nawh, myihla caih sak pan hy. Bawipa ak awipeek taw ypnaak awm nawh, thlang mailaikhqi awm cyi sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Bawipa am cukkiknaak awi taw dyng nawh, kawlung zeel sak hy. Bawipa ak awipeekkhqi taw caih nawh mik dai sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Bawipa kqihnaak taw caih nawh, kumqui dyna cak hy. Bawipa ak awitlyhnaak taw thym nawh dyng boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Sui anglakawh a phu tlo nawh, sui a tuicil anglakawh a phu tlo khqoet hy; khawitui anglakawh awi nawh, khawi a lutui anglakawh awm awi khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Cekkhqi ingkaw tyihzawihkhqi ce ngaihtaaknaak pe nawh; ak ngai ak thlangkhqi taw laksawng ak bau soeih pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","A u ing amah a thawlhnaak ce a sim? Ang hyp ka sai thawlhnaak awh qeenkhaw ngai law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Thawlh am ka sainaak ngah ngah aham na tyihzawih ve ni khoem lah; cekkhqi ing koeh ni uk u seh. Cawhtaw coet a kap kaana awm kawng nyng saw, thawlhnaak khawteh anglakawh awm poek poek hawh kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Aw Bawipa ka lungnu ingkaw ka hulkung, kam kha awhkaw awi ingkaw kak kawlung khui awhkaw poeknaak ve namik huh awh ym kawina awm seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Ngaihkyi kawbing na na awm huiawh Bawipa ing nim hlat seitaw; Jacob a Khawsa ang ming ing ni hlip nik chung seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Ahun caih awhkawng na ham bawmnaak tyi law seitaw Zion awhkawng dylnaak ce ni pe seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Lucik na sainaak boeih ce sim loet seitaw na hyihphumnaak ce zeel doena do seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Nak kawlung ngaihnaak ce ni pe seitaw nang cainaakkhqi boeih ce coeng sak seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Noengnaak na huh awh zeel doena khy kawng unyng saw ni Khawsa ang ming ing hizan ce hak zoek kawng unyng. Bawipa ing na thoehnaak boeih ce ni pe seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Bawipa ing ak thlang tyh ce hul hy ti sim hawh nyng; ak tang ben awhkaw hulnaak tha ing ak khan caih nakawng anih ce hlat hy. ");
INSERT INTO hltthb_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Thlang pynoet ing meqang phleng ypna unawh pynoet ing meqangkhqi ypna uhy, cehlai ningnih ingtaw Bawipa ni khawsa ang ming ce ni ypna uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Cekkhqi ing amim khuk tawk et nawh tlu hlai uhy, ningnih taw ni hang tho unawh ak cak na ning dyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Aw Bawipa, sangpahqang ve hul lah! Kaimih ing kamik khy awh nim hlat khqi lah! ");
INSERT INTO hltthb_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Aw Bawipa, sangpahrang ing nang ak tha awmnaak awh zeel hy. Noengnaak na peek dawngawh anih ing a zeelnaak ikawmyih aih na a bau! ");
INSERT INTO hltthb_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Ak kawlung ing a ngaih ce pe tiksaw, a hui ing a thoeh ik-oeih ce am hlawh na hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Anih ce zosennaak ak bau soeih ing do nawh a lu awh sui tuici lumyk ce myk sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Anih ing hqingnaak a thoeh law awh ce, nang ing pe hyk ti - khawkdai sangkhqi kumqui coeng kumqui dyna pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Noengnaak na peek ak caming, a boeimangnaak ce bau khqoet hy; thangleeknaak ingkaw qyp awmnaak ce ak khanawh taak pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Kumqui zoseennaak ce na peek hawh a dawngawh na haai zeelnaak ing be sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Cedawngawh sangpahrang ing Bawipa ypna nawh, sawsang soeih awh amak dyt thai qoe lungnaak caming anih taw am tat qoe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Na qaalkhqi boeih ce na kut ing tu kawmsaw; na thunkhakhqi ce nak tangkut ing tu kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Nang, nang dang law awhtaw a mingmih ce mai awhkaw ak alh tap amyihna sai kawp ti. Bawipa ing ak kaw a so dawngawh cekkhqi ce daih kanglak kawmsaw, a mai kqawng ing cekkhqi ce uih sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Khawmdek awhkawng cekkhqi a cadilkhqi ce nang ing hqe boeih kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Nang ce ak che na khaw ni khan sih unawh, kawpoek che ing nik kqawn hlai uhy, ikaw na am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Nang ing cekkhqi ce licung hawi nawh nam hyt khqi awh ce ami hu benna cen kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Aw Bawipa, nak thaawmnaak awh hak zoeksang qu lah; nak thaawmnaak laa sa unyng saw nim kyihcah lah vang unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Ka Khawsa, ka Khawsa, kawtih nani ceh taak vik? Ikawtih a hul kaana ak hla na awm hoe nawh, kak khy awi awhkawng ak hla na na awm hy voei? ");
INSERT INTO hltthb_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Aw Bawipa, dai awh khy nyng, cehlai am nim hlat tiksaw than awh awm am sit thai nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Cehlai nang taw thlak ciim na boei ngawihdoelh awh ngawi nawh; Isarelkhqi a zoeksang na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Ami pakhqi ing nang ce ni ypna unawh; a mingmih ing ami ypnaak a dawngawh nang ing cekkhqi ce hul hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Na venawh amik khy awh ce hul na awm uhy, nang ce ami ni ypnaak dawngawh amik kaw am boet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Kai taw thlanghqing na am awm voel nyng, ceilaak nani ka awm hawh, thlang ak kqawnseet ingkaw thekhanaak na awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Kai amik hukhqi boeih ing ni qaih na uhy; a hui ni mele sih unawh, ami luu ni hyl sih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Bawipa ypna saw; Bawipa ing hul thaw voei. Anih ing hul thaw voei, anih ak khanawh ak kaw a law soeih koenoek,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Cehlai nang ing zenbu ak khui awhkawng nik plawk nawh; ka nu suk ka awk hui awh awm namah ce ni ypna sak hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Ka thang cyk ca awhkawng namah awh peek na awm hawh nyng saw, ka nu puk khuiawh ka awm awhkawng nang taw ka Khawsa na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Ak hla na koeh ni awm taak hoe, kyinak ing ni zoe law nawh anik hulkung u awm am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Vaitaw am caikhqi ing nik chung unawh, Bashan a vaitaw am cai ak tha ak awm awmkhqi ing nik chung khoep uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","A kawk doena a ai kawi qamsa ak phu pat pat samthyyn ing am kha ang khara nawh ning hawi sih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Tui amyihna hawk na awm nyng saw, ka quh cawngkhqi pet hoh hoh boeih hy. Kam thin ve khawi-ut amyihna paan nawh kak khuiawh a tui na tle boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Kak thaawmnaak awm am keek amyihna qum boeih nawh, kam lai awm kak dangkhyl na bet qap hawh hy; nang ing thihnaak dekvai awh ni tloeng hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Uikhqi ing nik chung khoep unawh; thlakche tloek ing nik chung khoep uhy, ka kut qawi ingkaw ka khaw qawi ve ni hen pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Ka quhkhqi ve a cuna noet thai nyng, thlanghqing ing kawqep doena nim dai sih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Ka sui ka bai ce qek qu unawh ka angki ce taicung zyk sih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Cehlai Bawipa ak hla na koeh ni awm taak; Aw kak thaawmnaak, kai hul aham ang tawnna law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Zawzi awhkawng ka hqingnaak ve hul nawh, uikhqi ak thaawmnaak awhkawng a phu ak tlo ka hqingnaak ve hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Sendeihkhqi am khak khui awhkawng ni hul nawh; cungkhqi ak kii awhkawng ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Ka koeinaakhqi venawh nang ming ce khypyi nyng saw; thlangkqeng anglakawh nang ce nim kyih vang. ");
INSERT INTO hltthb_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Nangmih Bawipa ak kqihkhqi, kyihcah lah uh! Nangmih Jacob a cadil boeih, amah ce zoeksang lah uh! Nangmih Isarel cadilkhqi boeih, amah ce kqihchah lah uh! ");
INSERT INTO hltthb_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Khuikha nawh kyinaak ak hu thlang ce husit nawh am tyih hy; a haai awm am thuh pe nawh hul aham ak khynaak awi ce ngai pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Thlangkqeng anglak cunnaak awh nang ka nim kyihnaak awi ve namah a ven awhkawng ni a law; kak awikamnaak ve nang anik kqihkhqi haiawh soep sak vang. ");
INSERT INTO hltthb_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Khawdengkhqi ing ai kawi hu unawh amik phoen phyi kaw; Bawipa ak suikhqi ing amah ce kyih u seitaw- nak kawlung ce kumqui dyna hqing seh. ");
INSERT INTO hltthb_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Khawmdek a dytnaak boeih ing sim kawm usaw Bawipa venna hlat kawm uh, qam pum awhkaw cakaw paqeng boeih ing na haiawh koep kawm uh- ");
INSERT INTO hltthb_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Uknaak taw Bawipa koena a awm dawngawh pilnam thlang boeih ce amah ing uk hy. ");
INSERT INTO hltthb_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Khawmdek awhkaw boeikhqi boeih ing poei sai unawh bawk kawm uh; dekvai khuina ak cetkhqi boeih- amah poek awh a mak hqing thaikhqi ing a haiawh khawkhlu sym kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Cadilkhqi ing bibi pe kawm usaw; hai ben awhkaw ak law hly cadilkhqi venawh Bawipa kawng ce kqawn pe kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Cekkhqi ing ak thang hlan thlangkhqi venawh anih a dyngnaak ce kqawn pe kawm uh. Anih ing ce ce asai hawh a dawngawh. ");
INSERT INTO hltthb_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Bawipa taw ka tuudoenkung na a awm dawngawh, am syt voel kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Qam a sainaak hun awh ni ih sak nawh, tui ang bymnaak hun na ni hqui hy. ");
INSERT INTO hltthb_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Ka hqingnaak ve ni tlaih pe nawh ang ming ak caming dyngnaak lam benna ce ni sawi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Thihnaak lawk-kqawng hqaw nyng seiawm, ap kqih tikawng; kawtih na thingboeng ingkaw na sawnghqawl ing kang ngaih ni qep sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Ka qaalkhqi haiawh kai aham caboei ni tloeng pe hyk ti, ka lu ve situi ing ni syp pe nawh; kak boet awh be ngen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Leeknaak ingkaw lungnaak ing ka hqing khui pyt awh ni hquut kawmsaw, Bawipa im awh kumqui dyna awm hawh kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Khawmdek ve Bawipa koena awm nawh, ak khui awhkaw ik-oeihkhqi boeih, khawmdek ingkaw ak khui awh ak awm boeih awm a koe na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Anih ing tuicunli ak khan awh dyih sak nawh tuikhqi ak khan awh caksak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Bawipa tlang awh ce a u nu ak kai kaw? A hun caih awh ce u nu ak dyi kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Kut ak caihkhqi ingkaw kawlung ak caihkhqi, a hqingnaak myiqawl bawknaak benna amak awm man ingkaw amak thym ik-oeih awh awi amak kam mankhqi doeng ing kai kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Bawipa ven awhkawng zoseennaak hu kawmsaw, ak hulkung Khawsa ven awhkaw ngaihqepnaak ce hu kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Amah ak sui cadilkhqi taw cemyihna awm kawm uh, Aw Jacob Khawsa, nang a haai ak sui thlangkhqi ce. ");
INSERT INTO hltthb_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Aw chawmkengkhqi aw, na luukhqi ce thawh lah; boeimang sangpahrang a kunnaak thai aham, nangmih syn awhkaw chawmkengkhqi aw zoeksang qu lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Boeimang sangpahrang ve a u nu? Boeimang Bawipa qaal tuknaak awh tha ak awm soeih Bawipa ce ni. ");
INSERT INTO hltthb_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Aw chawmkengkhqi aw, na luukhqi ce thawh lah; boeimang sangpahrang a kunnaak thai aham, nangmih syn awhkaw chawmkengkhqi aw zoeksang qu lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Boeimang sangpahrang ve a u nu? Boeimang Bawipa thak awm soeih Bawipa - Boeimang sangpahrang ce anih hawh ni. ");
INSERT INTO hltthb_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Aw Bawipa, na venawh ka hqingnaak zoek law nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Aw ka Khawsa, nang ni ka ni ypnaak. Chah koeh ni phyih sak nawh, ka qaalkhqi ingawm koeh ni noeng sak. ");
INSERT INTO hltthb_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Nang awh ngaih-unaak ak takhqi boeih taw chah am phyi tikaw, cehlai ikaw am maiawh ypawm thlang na amak awmkhqi taw chah phyihnaak hu kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Aw Bawipa, nang ing na lamkhqi ce nim huh nawh na cehnaak lamkhqi ce ni cawng sak lah; ");
INSERT INTO hltthb_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Nang taw ka hulkung Khawsa na na awm dawngawh nak awitak khuiawh ni sawi nawh ni cawngpyi lah, myngawi kang ngaih-unaak taw nang ni. ");
INSERT INTO hltthb_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Aw Bawipa, syn awhkawng ak awm nam qeennaak ingkaw na lungnaak bau soeih ce sim poe lah. ");
INSERT INTO hltthb_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Ka taai hui awhkaw ka thawlhnaakkhqi ingkaw hatlauh na ka awmnaak khawboe qamlangkhqi ce koeh sim poe lah, na lungnaak awh ce ni sim poe lah, Bawipa nang taw leek hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Leeknaak ingkaw dyngnaak ve Bawipa koe ni; Cedawngawh thlak thawlhkhqi ce amah a lamkhqi cawngpyi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Dungvoeng na ak awm thlangkhqi ce a thymnaak benna sawi nawh amah a lam ce cawngpyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Ak awipeek paipi ak thin tlawhnaak khqi taw lungnaak kap nawh a ypawm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Aw Bawipa, ka sai thawlhkhqi ve bau soeih mai seiawm, nang ming ak caming qeenkhaw ngai law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Cawhtaw, Bawipa ak kqih thlang ce a u hy voei nu? Lam ak tyk peek naak amyihna anih ce cuk am kik kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Anih ing khawnghyp boeih ce zo awmnaak ing hawna kawmsaw, a cadilkhqi ing qam ce pang kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Bawipa ing amah ak kqihkhqi venawh a paipi ce ang hyp na sim sak dym hy. ");
INSERT INTO hltthb_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Kamik qawi ing Bawipa ben doeng ni a toek, amah doeng ing ni ka khaw qawi ve thang awhkawng a hlam law hly. ");
INSERT INTO hltthb_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Kai benna mang law nawh nim qeen lah, khuikha ing kamah doeng ca ka awm a dawngawh. ");
INSERT INTO hltthb_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Kak kawlung khuikhanaak ve kqawn kaw am hut voel hy, ngaihang kawbin na ka awmnaak awhkawng ni loet sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Ka khuikhanaak ingkaw kang ngaih a kyinaak toek nawhtaw ka thawlhnaak boeih ve khoe law bang lah. ");
INSERT INTO hltthb_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Ka qaalkhqi pung khawnghak nawh kai a mini sawhnaak ve toek lah! ");
INSERT INTO hltthb_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Ka hqingnaak ve qym nawhtaw kai ve ni hul lah; nang ak khuiawh kang thuk a dawngawh chahqai na koeh ni awm sak. ");
INSERT INTO hltthb_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Kawlung thymnaak ingkaw dyngnaak ing nik chung lah seh, kang ngaih-unaak taw nang awh a awm dawngawh. ");
INSERT INTO hltthb_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Aw Khawsa, a kyinaak awhkawng Isarel ve hul lah! ");
INSERT INTO hltthb_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Aw Bawipa, ak thym na awi ni deng lah; coet a kap kaana khaw ka sak a dawngawh; kaw cak doena ni Bawipa ce ka ypnaak. ");
INSERT INTO hltthb_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Aw Bawipa, ni noekdak nawh, ni nai plak plak lah, kam thin ka kyl ve ni silh pe lah. ");
INSERT INTO hltthb_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Na lungnaak ve ka haiawh awm poepa nawh, nak awitak awh ka ceh poepa a dawngawh. ");
INSERT INTO hltthb_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Qaai ak kqawn thlang mi am ngawi haih man nyng saw, ak hoel qu thlangkhqi ing am pyi qu man nih nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Ik-oeih che ak saikhqi ang cunnaak ce tyih nyng saw thlak chekhqi ing ngawih haih aham awm tha na nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Coet kap kaana kut ve sil nyng saw, Bawipa na bawkthang a kengsam awh cet vang. ");
INSERT INTO hltthb_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Namah kyihcahnaak ce khawteh na khypyi nyng saw kawpoek kyi ik-oeih na saikhqi boeih ce kqawn vang. ");
INSERT INTO hltthb_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Aw Bawipa, na awmnaak im, na boeimang a awmnaak hun ce thin tlawh na nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Ka hqingnaak ve, thlak thawlhkhqi, thlang a thi ak ngaihkhqi mi koeh lawh sih. ");
INSERT INTO hltthb_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Ami kut awh ce ak che cainaak awm nawh amik tang ben kutkhqi awm ang hyp ik-oeih peeknaak ing be uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Cehlai, kai taw coet kap kaana khaw ka sak dawngawh, ni hul nawh nim qeen lah. ");
INSERT INTO hltthb_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Ka khaw ve hun a nepnaak awh dyi nawh; thlangkqeng ang cunnaak awh Bawipa ce kyihcah kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Bawipa taw ka maihchoei ingkaw ka hulnaak na awm hy - u nu kak kqih bai kaw? Bawipa taw ka hqingnaak vawngcak na awm hy - u nu kak kqih re bai kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Ka sa daih aham thlak chekhqi ing ni pan unawh ka qaalkhqi ingkaw ka thunkhakhqi ing amim tu awh ce bah kawm usaw tlu kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Qalkap ing nik chung khoep seiawm, kak kawlung am thyn qoe tikaw; tangboek ing ni boeng qoe seiawm kak kawlung yp khak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Bawipa venawh ik-oeih pynoet doeng thoeh nyng, ka thoeh taw veni; ka hqing khui pyt Bawipa im awh awm aham ingkaw Bawipa a myi daw soeih ce toek doena a bawkim khuiawh amah sui ve doeng ni. ");
INSERT INTO hltthb_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Ikawtih kyinaak ka um awh ce a awmnaak hun awh kai ce ngaihding cana ni awm sak kaw; a hizan im awmnaak khuiawh ni thuh kawmsaw lungnu awh ce ak sang na nim hawih kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Cawhtaw kai anik chung khoep ka qaalkhqik khanawh ka luu ve zoeksang kaw; a hizan im awh zeel doena khy nawh lucik nawn nyng saw; Bawipa kyihcah ing laa sa hawh kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Aw Bawipa, ka nik khy awh ce kak awi ngai law lah; nim qeen nawhtaw nim hlat lah. ");
INSERT INTO hltthb_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Kak kawlung ing “A haai sui lah!” ni tina hy. Bawipa nang haai ni ka sui hly. ");
INSERT INTO hltthb_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Na haai ce koeh thuh valh nawh, na tyihzawih ve koeh mang taak; nang taw kai anik bawmkung ni. Aw Khawsa ka hulkung, koeh ni qoeng nawhtaw koeh ni cen taak. ");
INSERT INTO hltthb_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Ka pa ingkaw ka nu ing ni cehta seiawm, Bawipa ing ni do ngai kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Aw Bawipa, na lam ce ni cawng sak nawh; kai anik thekhanaakkhqi awh na lap dyng awh ni sawi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Ka qaalkhqi ngaihnaak awh kai ce koeh ni pe, amak thym dyihthingkhqi ing ni thawh sih unawh, amak leek ben awi ce amik kqawn a dawngawh. ");
INSERT INTO hltthb_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Ka hqingnaak qam awh ve Bawipa a leeknaak hu ngai kawng tinawh yp qu na mang kang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Bawipa mah qeh lah; kawlung cak doena nak tha awm sak nawh, Bawipa mah qeh lah. ");
INSERT INTO hltthb_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Aw Bawipa ka lungnu, namah ni ka nik khy; am hlat kaana koeh ni awm taak. Nang ing am na ning ngainaak awhtaw lawk-kqawng khuiawh ak tlakhqi amyihna ni ka awm hly. ");
INSERT INTO hltthb_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Nam qeennaak huh aham ni doet nyng, na hun caih soeih benna ka kut qawi ka soeng law awh qeennaak thoeh doena kak khynaak awi ve ngai law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Thlak chekhqi, ik-oeih amak leek ak sai thlangkhqi mi koeh nik dawh sih qen, cekkhqi ing a pilnamkhqi venawh zeelnaak awi taw kqawn kaa lawt hlai uhy, ak kawlung khui awhtaw ak che khqoet ni a awm. ");
INSERT INTO hltthb_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Ak che ik-oeih ami sainaak amyihna thung pek khqi tloep lawt lah; a mimah ing ak tyng na amah a kut sainaak ce thung pe lah. ");
INSERT INTO hltthb_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Bawipa a bibinaakkhqi ingkaw a kut saikhqi ce kaw na awm a maming ngaih dawngawh, cekkhqi ce khqai poet poet kawmsaw ityk awh awm am thawh khqi voel tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Qeennaak ka thoehnaak khqi ve a ning zaak peek a dawngawh, Bawipa venawh zoeksangnaak awm seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Bawipa taw kak thaawmnaak ingkaw ka phuhqa na awm hy; kak kawlung ing amah ce ka ypnaak a dawngawh ni bawm hy. Kak kaw zeel soeih nawh amah venawh zeelnaak awi kqawn doena laa sa vang. ");
INSERT INTO hltthb_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Bawipa taw ak thlangkhqi ham thaawmnaak na awm nawh, amah ing a caksak thlangkhqi ham hulnaak vawngcak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Nak thlangkhqi ce hul nawhtaw na qo ak pangkhqi ce zosennaak pe lah; a mingmih a tuudoenkung na awm nawh kumqui dyna khai khqi loet lah. ");
INSERT INTO hltthb_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Aw nangmih boeimang thak awm tloek, Bawipa taw boeimang soeih hy tinawh dawk lo lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Ang ming a boeimang a dawngawh Bawipa venawh pe u nawhtaw; a zawziihnaak ing thoeihcam qu doena Bawipa ce bawk lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Bawipak awi taw tuikhqi ak khan awh pau nawh; Khawsa a boeimangnaak taw khaw na hum hy, tui ak doem soeih ak khan awh Bawipa taw khaw na hum hy. ");
INSERT INTO hltthb_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Bawipak awi taw ak tha awm nawh; Bawipak awi taw a qym awm soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Bawipak awi ing sidar thingkhqi ek sak nawh; Lebanon awhkaw sidar thingkhqi ce Bawipa ing kqai poet poet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Vaitaw camyihna Lebanon ce peh sak doep doep nawh, vaitaw am cai camyihna Sirion ce awm sak hy - ");
INSERT INTO hltthb_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Bawipak awi taw khawphlamyihna phla hlap hlap hy. ");
INSERT INTO hltthb_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Bawipak awi ing qamkoh khqi tyn sak nawh; Bawipa ing Kadesh qamkoh khqi awm tlai sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Bawipak awi ing ther thingkhqi kqai poet poet nawh thinghahkhqi reu pheng pheng hy. A bawkim khuiawh thlang boeih ing “boeimang soeih hy” tinawh khy uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Bawipa taw tuiliu ak khan awh boei na ngawi nawh; kumqui sangpahrang na Bawipa taw ngawi loet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Bawipa ing ak thlangkhqi venawh thaawmnaak pe nawh; Bawipa ing ak thlangkhqi ce ngaihqepnaak ingkaw zosennaak pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Aw Bawipa, nang ce ni zoeksang vang nyng, nang ing a dungnaak hun awhkawng nik dawk nawh ka qaalkhqi kak khan awh amik kaw am qep sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Aw Bawipa ka Khawsa, qeenaak thoeh doena kak khy awh ce nang ing ni qoei sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Aw Bawipa, phyi ak khui awhkawng nik dawk tiksaw; lawk-kqawng khuina ceh sak kaana nim hlyn hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Nangmih ak thlangciimkhqi aw, Bawipa venawh laa sa lah uh: ang ming caih ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Ak kawsonaak taw kawlkalh ca doeng awh ni, cehlai a zeelnaak taw hqing khui dy aham awm hy; cimthan awh ning kqang hly mai hlai hy, mymcang awh zeelnaak law tlaih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Kang ngaih a ding tloek awh ce “am tat qoe tikawng” ti nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Aw Bawipa, kak khan awh nak kaw a zeel awh, ka tlang ce ak cak na dyih sak hyk ti; cehlai na haai na thuh awhtaw ngaihang tum na awm hqoeng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Aw Bawipa, nang ni ka nik khy; Bawipa venawh qeennaak thoeh doena khy nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Ka seetnaak ingkaw lawk-kqawng khuina ka cehnaak ve nang aham hawihkhangnaak ikaw a awm? Dekvai ing nang ce anik kyih hly nu? ");
INSERT INTO hltthb_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Aw Bawipa ngai law nawhtaw, nim qeen lah; Aw Bawipa kai anik bawmkung na awm law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Kang kqangnaak ve lamnaak na coeng law sak hyk ti; nang ing dipche kang byng ve ni khoe pe nawh zeelnaak ing ni sing hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Kak kawlung ing a awm dym kaana laa sa kaw, Aw Bawipa ka Khawsa, na venawh kumqui dyna zeelnaak awi kqawn kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Aw Bawipa, nang awh ni kang thuk hy, chah koeh ni phyih sak; na dyngnaak awh ce ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Nang haa keng law nawhtaw, kai hul aham ang tawnna law lah; kang thuknaak lungnu na awm nawh, ka hulkung vawngcak na awm lah. ");
INSERT INTO hltthb_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Nang taw kang thuknaak ingkaw ka vawngnu na, na awm a dawngawh nang ming ak caming ni ceh pyi nawhtaw ni hqui lah. ");
INSERT INTO hltthb_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Ka haiawh a dun qu thang awhkawng ni loet sak lah, nang taw kang thuknaak kung na na awm a dawngawh. ");
INSERT INTO hltthb_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Na kut awh kang myihla ni pe nyng; Aw Bawipa awitak Khawsa ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Kawna amak awm myiqawl ak bawkkhqi ce sawh na nyng saw; Bawipa ce ypna nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Na lungnaak awh ce zeelmang ing awm vang, kawtih nang ing ka kyinaak ce hu law tiksaw kang myihla ing a khuikhanaak ce sim hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Ka qaal a venawh amni pe nawh ka khaw qawi ve hun nepnaak awh ning dyih sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Aw Bawipa ngaihang kawbin na ka awm a dawngawh, kai ve nim qeen lah; kak kawseet aih awh mik awm am dai hqa voel nyng; kang myihla ingkaw ka pum awm kawseet lungnat zawk hy. ");
INSERT INTO hltthb_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Ka hqingnaak ve kawsetnaak ing daih nawh ka kumkhqi awm ko ang kqangnaak ing khaw kum boeih hy; ka khuikha aih awh kak tha awm boet hqoeng nawh, ka quh awm ak tha am awm voel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Ka qaalkhqi dawngawh, ka pilnamkhqi ing ni hep unawh; ka pyikhqi ing nik kqih uhy - lam awh kai anik hukhqi ing ni centaak boeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Ak thi hawh amyihna cekkhqi ing nim hilh boeih uhy; dek-am ak kqek zak amyihna ni ka awm hqoeng hawh. ");
INSERT INTO hltthb_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Thlang khawzah ing a mini tengnaak awi doeng za nyng; voei a vang awh kqihnaak hqoeng na awm hy; kai ing am ka ngaihnaak ben awh ce za qu unawh ka hqingnaak him aham cai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Cehlai, Bawipa nang ni ka ni ypnaak; “nang taw ka Khawsa ni” ti nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Ka tymkhqi ve nang a kut khuiawh ni a awm; ka qaalkhqi ingkaw kai anik hqutkhqi kut khui awhkawng ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Na tyihzawih ak khan awh na haai hlangpan sak nawh; amak dyt thai na lungnaak ing ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Aw Bawipa, chah koeh ni phyih sak, nang a venawh ni kak khy law; cehlai thlak chekhqi taw chah phyih sak nawh phyi khuiawh awimyh na zaih sak khing lah. ");
INSERT INTO hltthb_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Cekkhqi ing qaai awi amik kqawnnaak hui ce sit sak lah, oek qunaak ingkaw hepnaak ing thlakdyngkhqi ce amik kaa naak a dawngawh. ");
INSERT INTO hltthb_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Nang anik kqihkhqi aham cun pe nawh, thlanghqingkhqi haiawh nang awh ak thukkhqi aham na taak zoseennaak taw bau soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Ang hyp na ak tengkungkhqi ven awhkawng na haai awhkaw awmnaak hun awh ak mawng na ta hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Khawk bau cak awh ka awm awh kawpoek kyi qeennaak ce ang dang law sak a dawngawh, Bawipa venawh thangleeknaak awm seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Ka ly aih awh, “ning hawi taak valh hawh amih hyk ti!” ti nyng. Cehlai, qeennaak ka thoeh law awh ce qeennaak ing kak khynaak awi ce ngai law hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","A thlakciimkhqi boeih aw, Bawipa ce lungna lah uh! Bawipa ing ypawm thlangkhqi ce hqui a sawi nawh ak oek qu thlangkhqi taw a khawboe amyihna thung pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Nangmih Bawipa awh ngaih-unaak ak takhqi boeih namik tha awm sak unawh na mim thin caksak lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","A sai thawlhnaakkhqi ak khan awh qeenkhaw ngai pe nawh, a thawlhnaakkhqi ak dah peek ak thlang taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Bawipa ing a thawlhnaak ce kawna awm am poek pe nawh myihla hqingnaak awh qaai kqawn na amak awm thlang taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Awimyh na khawnghi zung kang konaak awh ka quhkhqi awm hawn boeih hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Khawmthan khawdai kak khan awh na kut ve qih soeih hy; khawhqai awhkaw khawkhlawk ing a eng amyihna kak tha awm reu hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Ka thawlhnaak awh ce na venawh dawk hul nyng saw ka awm tloeinaak awm ap thuh phah nyng. “Bawipa venawh ka sai thawlhnaakkhqi ve khypyi vang” ti nyng - cawhtaw nang ing ka thawlhnaak awh ce qeenkhaw ngai law hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Cedawngawh nang ve huh thai na, na awm law awh Khawsa ak kqih thlangkhqi boeih ing cykcah awi kqawn u seh; cawh ni tuiliu a law awh awm cekkhqi ce ama pha hly thai. ");
INSERT INTO hltthb_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Nang taw kang thuknaak hun na awm tiksaw; kyinaak anglakawhkawng nik chung nawh hulnaak laakhqi ing nik chung khoep kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Na cehnaak hly kawi lam ce nim huh kawng nyng saw ni cawngpyi bit kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Zaaksimnaak amak ta meqang ingkaw laa amyihna koeh awm, cekkhqi ing haa aming zaaknaak thai aham am kha awh thiqui ing a kyng ngaih hy; cemyih am kaana am sawi thai ti kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Qaal ingkaw thalk che khawzah awm thai hy, namah anik ypnaak thlang taw Bawipa lungnaak amak dyt thai ing chung poepa hy. ");
INSERT INTO hltthb_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Nangmih thlakdyngkhqi aw, Bawipa awh zeel unawh namik kaw zeel sak lah uh; kawlung ak dyng thlangkhqi boeih aw, laa sa lah uh! ");
INSERT INTO hltthb_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Nangmih thlakdyngkhqi aw, Bawipa venawh zeelnaak laa sa lah uh; thlakdyng ham taw amah kyihcah ve tyng qoe hy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Tingtoeng ing amah ce kyihcah unawh taw; a qui pahqa ak law qaw tingtoeng ing tum sih bai lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","A venawh lak thai sa unawh; zeelnaak ing khy am kqang doena tum lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Ikawtih, Bawipa ak awi taw thym nawh dyng hy; a ik-oeih sainaak boeih awh ypawm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Ak dyng ingkaw ak thym ve Bawipa ing lungna nawh; khawmdek ve amak dyt thai a lungnaak ing be hy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Bawipa ak awi ing khankhqi ce sai na awm nawh, ang hqi ing aihchikhqi awm sai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Tuicunli awhkaw tuikhqi ce cun kang nawh; tuidungnaak hun ce am cunnaak im na tahy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Khawmdek boeih ing Bawipa kqih seitaw; khawmdek thlangkhqi boeih ing amah ce kqihchah seh. ");
INSERT INTO hltthb_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Ikawtih, anih ingtaw kqawn nawh coeng sak hy; awi pe nawh ak cak na dyih sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Pilnamkhqi ang cainaak ce Bawipa ing plal sak hy; thlangkhqi boeih ang cai sihnaakkhqi awm hqe pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Cehlai, Bawipa ang cainaak taw kumqui dyna cak hy, ak kawlung ing ang cainaakkhqi boeih awm cadil dyna cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","A qo pang aham amah ing tyk nawh, Bawipa ce a Khawsa na ak ta qam taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Khan nakawng Bawipa ing anuk toek awh thlanghqing boeih ce hu hy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","A awmnaak hun awhkawng khawmdek awhkaw ak awm thlangkhqi boeih ce qeh hy- ");
INSERT INTO hltthb_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Thlang boeih ak kawlung ak saikung ing, a ik-oeih sainaakkhqi boeih awm poek pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Kawmih a sangpahrang awm a qalkap ing am hul hy, ikawmyihna a qaal ak leek soeih awm ak thaawmnaak ing am loet sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Hul thainaak aham meqang pynoet doeng ce kawna am coeng hy; ak tha awm seiawm am hul thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Amak dyt thai a lungnaak awh ngaih-unaak ak ta thlangkhqi ingkaw amah ak kqihkhqi ak khan awh Bawipa amik taw awm hy, ");
INSERT INTO hltthb_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","thihnaak khui awhkawng cekkhqi ce hul aham ingkaw khawset khawkha a pha law awh cekkhqi ce hul aham. ");
INSERT INTO hltthb_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Bawipa ce ngaih-unaak ing ni qeh uhy; amah taw ningnih a hulkung ingkaw ningnih a phuhqa na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Ang ming ciim ce ni ypnaak a dawngawh, ningnih ak kawlung taw zeel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Aw Bawipa namah awh kaimih ang ngaih-unaak taw a awm dawngawh, amak dyt thai na lungnaak ce kaimih ak khan awh awm seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Kawmih a tym awh awm Bawipa taw zoeksang kawng nyng; amah kyihcahnaak ce ka hui kam lai awh awm quiqah kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Ka hqingnaak ve Bawipa awh ak tha awm kaw; ak khuikhakhqi ing za seitaw zeel u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Bawipa ce nim kyihcah pyi unawh; ang ming ce kut oet cana zoeksang lah u sih. ");
INSERT INTO hltthb_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Bawipa ce sui nyng, amah ing nim hlat hy; kak kqihnaak boeih awhkawng amah ing ni hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Amah ak toek thlangkhqi boeih taw vang unawh; ami haaikhqi ce chahnaak ing am dah pe qoe hy. ");
INSERT INTO hltthb_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Khawdeng thlang ing ak khy awh ce, Bawipa ing zaak pe nawh, a khuikhanaak khqi boeih awhkawng anih ce hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Amah ak kqih thlangkhqi taw BawipaK khan ceityihkhqi ing chung unawh anih ce hul uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Bawipa a leeknaak ce tan unawh taw hu lah uh; amah awh ak thukkhqi taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Nangmih amah ak thlangciimkhqi, Bawipa ce kqih lah uh, kawtih amah ak kqihkhqi taw ikaw awm am deng ti kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Sendeih taw ak tha boeih nawh ak phoen cawi thai hy, cehlai Bawipa ak sui thlangkhqi taw ik-oeih leek am deng qoe uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Ka cakhqi law unawh taw ngai lah uh; Bawipa kqihnaak ce ni cawngpyi vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Nangmih hqingnaak ak lungnaakkhqi ingkaw khawnghik leek khawzah huh aham ak ngaihkhqi, ");
INSERT INTO hltthb_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","awihche am nak kqawnnaak aham nam lai ce cyt unawh na hui ing qaai awi amak kqawnnaak aham cyt lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Ik-oeih che ce cehta unawh ik-oeih leek ce sai lah uh; qoepnaak ce sui unawh hquut lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Thlakdyng ak khan awh Bawipa amik taw awm nawh ak khynaak awi ce ang haa ing ngai pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Cehlai, ik-oeih amak leek ak sai thlangkhqi ce Bawipa ing hawi taak nawh, khawmdek awh a mingmih ami awm ce am sim loet voel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Thlakdyng ak khynaak ce Bawipa ing zaak pe nawh; cekkhqi ce kyinaak ak khui awhkawng hul khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Kawlung ak kqekkhqi venawh Bawipa taw zoe penawh lingbyi ak kqekkhqi ce hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Thlakdyng taw kyinaak khawzah hu seiawm, cekkhqi boeih ak khui awhkawng Bawipa ing anih ce hul hy; ");
INSERT INTO hltthb_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","a quhkhqi boeih ce ak chung a hlip peek a dawngawh, pynoet ca awm am ek tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Cehlai, thlak che taw leeknaak ing him kawmsaw; thlakdyng a qaal ce thawlh sak na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Bawipa ing a tyihzawihkhqi ce hul nawh; amah awh ak thukkhqi boeih taw am thawlh qoe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Aw Bawipa, kai anik eek thlangkhqi ce nang ing mele sih nawhtaw; kai anik tukkhqi ce nang ing tuk lah. ");
INSERT INTO hltthb_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Phura ingkaw kqang dahnaak ce lo lah; tho nawh kai bawm aham law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Kai anik hquutkhqi haiawh cai thlek pek khqi nawh mam khqi khoep lah, Ka hqingnaak venawh, “Kai taw nang a hulnaak ni,” tina lah. ");
INSERT INTO hltthb_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Ka hqingnaak hqe aham ak suikhqi ce amik kaw boet seitaw chah phyi u seh; kai plawci sak aham amik za qukhqi ce kqih doe ing huna voei tlaih u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Zilh ing a zawn canghi amyihna awm u seitaw, Bawipa a khan ceityih khqi ing cekkhqi ce ak chang na hquut u seh; ");
INSERT INTO hltthb_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","A cehnaak lam ce hyp pe seitaw hal pe seh, Bawipa ak khan ceityihkhqi ing cekkhqi ce hquut seh. ");
INSERT INTO hltthb_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Ikaw am mai awh kang awhnaak aham lawk zan unawh kai aham lawk-kqawng co law uhy, ");
INSERT INTO hltthb_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","poek kaana cekkhqik khan awh seetnaak ing pha tawk qat seh a mimah ing ami zan lawk awh a mimah awk nawn u seh, a seetnaak aham a mimah a lawk-kqawng awh tla nawn u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Cawh Bawipa awh ka hqingnaak zeel kawmsaw a hulnaak awh ce kak kaw zeel kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Cawh kang coengnaak boeih boeih ing, “Bawipa, nang amyihna u nu ak awm bai? Tha ak awm soeihkhqi anglakawhkawng khawdengkhqi ce nang ing hul hyk ti, a mingmih ak mukkung a kut khui awhkawng khawdengkhqi ingkaw thlang ak voethlauhkhqi ce hul hyk ti,” tinawh kqawn kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Qeennaak amak ta dyihthing qawlkhqi haina thoeih unawh; am ka sim ik-oeihkhqi ing ni deng uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Ik-oeih leek ce ik-oeih che ing ni thung unawh ka hqingnaak ve a sungnaak aham cehta uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Cehlai, cekkhqi ami tlawh awhtaw, kai ingtaw tlamhi byng nawh buh zehnaak ing chung na awm nyng. Kak cykcahnaak hlat na ama awm awh ce, ");
INSERT INTO hltthb_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","ka pyi ingkaw ka koeina amih koep na kqah sih nyng. Ka nu ak thi amyihna kawseet aih awh koep nawh kqap nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Cehlai kangbah awhtaw, cekkhqi ce zeel unawh cun uhy, am ka simkhqi ing ni sawi loet uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Khawsa kawna amak hu thlang qaihna amik kqawn amyihna, ami ha ni tah sih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Aw Bawipa, ityk dy nu nani toek hly hqoeng? Ka hqingnaak hqe aham ak caikhqi kut khui awhkawng ni hul lah, a phuk tlo soeih ka hqingnaak ve samthyynkhqi kut khui awhkawng ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Thlangkqeng ang cunnaak awh nang ce ni ym kawng nyng saw; thlangkqeng khawzah anglakawh nang ce ni zoeksang kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Kaw am mai awh ka qaalkhqi ing kawqep doena koeh ni toek u seh; ikaw am mai awh kai anik sawhnaakkhqi ing mik koeh ni hqip sih u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Cekkhqi ing qoepnaak awi kqawn kaana, qam khuiawh a ding a syk na ak awmkhqi ce thainaak aham qaai puk uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Ni aang sih unawh, “A ha! A ha! Ni mik qoe ing ni hu hawh saw ve,” ni tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Bawipa vekkhqi ve na huh hawh dawngawh; koeh ni awm taak poek poek lah. Bawipa ak hla na koeh ni awmtaak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Kai hul aham hqyng nawhtaw, dyi lah! Ka Khawsa ingkaw Bawipa, kang zyng na cekkhqi mi noek qu lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Aw Bawipa ka Khawsa, na dyngnaak ak caming awi tlyk law lah; cekkhqi mi koeh ni kqep sih seh. ");
INSERT INTO hltthb_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Cekkhqi ce, ce pai seh, vemyihna maw ni ngaih qoe pai,” ce am awhtaw, “Amah taw nik daih koe noek,” tinawh koeh poek sak. ");
INSERT INTO hltthb_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Kak kawseetnaak awh kaw anik qep sihkhqi ce chah phyi u seitaw ngaih kyinaak hu u seh; kak khan awh ak zoeksang qu plakkhqi ce chahnaak ingkaw ngaih kyinaak ing sing khoep seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Ka dyngnaak awh ak zeel thlangkhqi taw awmhly doena khy useh; cekkhqi ing, “A tyihzawih a ik-oeih leek ak ym, Bawipa taw zoeksang na awm seh,” ti phat u seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Kam lai ing nang a dyngnaak awi kqawn kawmsaw hypoet pyr awh na kyihcahnaak awi kqawn kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Thlak che a thawlhnaak ing kak kawlung khuiawh awi kqawn law hy; Amik awh ce Khawsa kqihnaak qoe qoe am tahy. ");
INSERT INTO hltthb_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Amah amik huh nawn awh cainaak huh amak ngaih ingkaw ak sawhnaak amyihna kyih am cah quhy. ");
INSERT INTO hltthb_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Am kha awhkaw awikhqi ve se nawh qaai kqawnnaak hqoeng na awm hy; thlakcyi na am awm voel nawh ik-oeih lek sai aham qoeng uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Ang zaihnaak kung awhkawng ak che doeng poek poepa hy; ik-oeih che sai aham cai qoe nawh amak thym ik-oeih ce am qoeng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Aw Bawipa nang a leeknaak ingtaw khawk khan hak pha nawh, na ypawmnaak ing khawnghi hak pha hy. ");
INSERT INTO hltthb_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Na dyngnaak taw khawmcung bau soeih amyihna awm nawh, na thymnaak taw dungnaak bau soeih amyihna awm hy. Aw Bawipa, nang ing thlanghqing ingkaw qamsakhqi boeih khoem hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Na lungnaak amak dyt thai ve a phu am kqawn thai pai hy! Thlanghqing ak nem ak sang ing nang ang thlak khuiawh thuknaak hu boeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Na ipkhui awhkaw ik-oeih khawzah papa ce aw a ai unawh; na awmhlynaak lawngnu awhkawng aawk hly kawi ce pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Ikawtih nang a venawh hqingnaak tuibym ce awm nawh; na vangnaak awhkawng vangnaak ce hu unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Nang anik sim thlangkhqi venawh na lungnaak awm, na dyngnaak awm awm sak loet lah. ");
INSERT INTO hltthb_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Ak oek qu thlang a khaw ce ka ven benna koeh law sak nawh, thlak che a kut ingawm koeh ni hqek seh. ");
INSERT INTO hltthb_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Ik-oeih che ak saikhqi ikawmyihna aming tluk tice toek lah- khaawng na awm unawh, am tho hqa voel uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Ik-oeih che ak saikhqi awh ce nak kaw koeh seet sak nawhtaw ik-oeih amak thym ak sai thlangkhqi awm koeh nai. ");
INSERT INTO hltthb_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Cekkhqi taw qam amyihna reu naai kawm usaw qam saihqing amyihna thi naai bit kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Bawipa ypna nawhtaw ik-oeih leek ce sai lah; ve qam khuiawh awm nawh qamhqing ve ngaihding ing awm sih lah. ");
INSERT INTO hltthb_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Bawipa awh zeelnaak ta lah, nak kawlung hym ngaihnaakkhqi ce amah ing ni pe bit kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Na cehnaak lam ce Bawipa awh hal lah; amah ce ypna lah amah ing sai law bit kaw: ");
INSERT INTO hltthb_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Anih ing na dyngnaak ce mymcang khaw amyihna bee law sak kaw, ak thym ik-oeih na sainaak awm khawnghyp khawmik amyihna bee law sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Bawipa haiawh awm poek poek nawhtaw kaw dungnaak ing amah ce qeh lah; thlangkhqi ing a ik-oeih sai awh nak kaw koeh tlawh sak. ");
INSERT INTO hltthb_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Kawsonaak ce re nawhtaw kaw tawknaak awhkawng hlat lah; nam thim koeh tlawh sak - ce ing ce ak che ben doek khoeih awh ni ani hquisawi hly. ");
INSERT INTO hltthb_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Ikawtih, thlak chekhqi taw moelh a moeng kawm uh, cehlai Bawipa awh ngaih-unaak ak takhqi ingtaw qam ce pang kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Kawlhkalh awh, thlak chekhqi taw am awm voel tikaw; cekkhqi ce sui tik seiawm, am hu voel kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Cehlai kaw ak daw thlangkhqi ingtaw qam ce pang kawmsaw ak bau qoep ang quinaak ing nawm kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Thlak che ingtaw thlak leek ce teng nawh a ha tah sih hy; ");
INSERT INTO hltthb_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Cehlai Bawipa ing thlak che ce qaih na hy, cekkhqi a tym ce law huili hawh hy ti a sim dawngawh. ");
INSERT INTO hltthb_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Thlakche ing khawdengkhqi ingkaw ak voethlauh khqi ce tluk sak aham ingkaw lap dyng awh ak cetkhqi ce him aham zawzi ce phlawng nawh licung ce hawi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Cehlai a mimah ak zawzi ing a mimah a lingbyi nawn ce sun pek khqi kawmsaw ami licungkhqi awm ek pek khqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Thlak che a boeinaak anglakawh thlakdyng ing a khoeh ca a taak ce nep bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Cehlai thlak che ak thaawmnaak taw ek kawmsaw, thlakdyng cetaw Bawipa ing tu kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Coet amak kap qoe thlangkhqi a khawnyn ce Bawipa ing sim pehy, a qopang hly kawi awm kumqui dyna cak loet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Plawcinaak atym a pha awh ce am zai kawm uh; khawseet khawkha awh awm khawzah ta kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Cehlai thlak chekhqi taw qeeng kawm uh; Bawipa a qaalkhqi taw qam a leeknaak amyihna ni ami awm hly, qeng bang kawm usaw mai khu amyihna ding bang kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Thlak che ingtaw pu hlai hy am thung voel hy, cehlai thlakdyng ingtaw khawboe cawnnaak ing pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Bawipa ing zosennaak a peek khqi ing qam ce pang kawm uh, cehlai kawsi ak hawi thlangkhqi taw milh a moeng kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","A cehnaak awh BawipaK kaw ak law sak thlang taw, a khaw kan cak pe sak hy; ");
INSERT INTO hltthb_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Bah seiawm, am tlu tikaw, Bawipa ing a kut ing tu hy. ");
INSERT INTO hltthb_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Thak awm hui na hang awm hawh nyng saw tuh taw pacawng hawh nyng, thlakdyng cehtaak na ak awm am hu khawi hlan nyng saw a cakhqi ing buh ami thoeh awm am hu khawi hlan nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Khawboe cawnnaak ing thlang amik pu poepa dawngawh a cakhqi ing zosennaak hu kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Ik-oeih che cehta nawh ik-oeih leek sai lah; cawhtaw qam khuiawh kumqui dyna awm kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Bawipa ing thlakdyng ce a lungnaak dawngawh amah a ypawm thlangkhqi a cadilkhqi taw moelh sak kaw; ");
INSERT INTO hltthb_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Thlakdyng ingtaw qam ce pang kawmsaw, ak khuiawh kumqui dyna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Thlakdyng am kha ingtaw cyihnaak awi sa nawh, am lai ing awih thym ce kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","A Khawsak a cawngpyinaak awi ce ak kawlung khuiawh khoem nawh; a khaw am bah hy. ");
INSERT INTO hltthb_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Thlak che ingtaw thlakdyngkhqi ce him aham ngawih sih poepa hy; ");
INSERT INTO hltthb_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Cehlai Bawipa ing cekkhqi kut awh am cehta hyt ti kawmsaw awidengnaak a awm awh awm am thawlh sak tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Bawipa ce qeh nawhtaw a lam ce hquut loet lah. Qam pang sak aham nang ce ni zoeksang kaw; thlak chekhqi moelh sak na ami awm ce hu kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Ang lai boet na nawh a hqing sup na ak hlul thing amyihna ak awm thlak che ingkaw, thlang qeenkhaw amak ngai thlang ce hu nyng, ");
INSERT INTO hltthb_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Cehlai kawlhkalh awh anih ce khum bang kawmsaw am awm voel tikaw; sui nyng awm, huh thai na am awm voel kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Coet amak kap thlangkhqi ce poek nawhtaw, thlakdyngkhqi ce hat lah; qoepnaak ak sai thlangkhqi ingtaw cadil ta kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Thlak thawlhkhqi taw hqe na awm kawm usaw; thlak chekhqi a cadilkhqi awm moelh kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Thlakdyng hulnaak taw Bawipa ven awhkawng law nawh; kyinaak ami huh awh anih taw cekkhqi ham vawngnu na awm pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Bawipa ing cekkhqi ce hul nawh thaawng hy; amah awh ang thuk dawngawh, thlak chekhqi anglakawhkawng hul nawh thaawng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Aw Bawipa, kawso doena koeh ni zyi nawh thin tawinaak ing koeh ni phep. ");
INSERT INTO hltthb_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Ikawtih, na lakhqi ing ni sun nawh, na kut ing kak khan awh ni nam khak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Nam thin tawinaak ka pum awh sadip na qoe am awm tlaih hy; ka thlawlhnaak awh ka quhkhqi awm a sa am dip voel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Ka thlawlhnaak ing ni vyih khoep nawh phyihqih naa tloei hak amyihna ni nam hy. ");
INSERT INTO hltthb_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Ka thawlh ka qawnaakkhqi ve thu nawh tyih awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Nung koep nawh am cei qeet awh balak nyng; khawnghi zung ko doena pla nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Kam ting kawng plih kang hawh nawh; ka pum awh sadipnaak qoe am awm voel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Kak tha boeih hqoeng nawh sawp qu plawk hawh nyng; kawlung khuikha doena ko hqoeng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Aw Bawipa, ik-oeih ka hym ka dawng soepkep na haiawh awng qu pheng nawh; kang konaak awi ve awm thuh thai na am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Ka bawng tlai lawp lawp nawh, kak tha am awm voel hy; kamik dainaak awm khum hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Phoei am lit hqoeng na ka awm dawngawh ka pyikhqi ing ni qee uhy; ka imcengkhqi ingawm ak hla na ni awm ta uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Ka hqingnaak hqe aham ak suikhqi ing thang ni dun sih uhy, nganbawh peek aham ak caikhqi ing ka seetnaak hly doek khoeih ce kqawn uhy; Khawnghi zung awh qaai kqawnnaak awi doeng ce kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Awi amak za ang hakpang amyihna awm nyng saw; kha amak ang thai awimyh amyihna awm hqoeng nyng; ");
INSERT INTO hltthb_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Awi am za thai qoe nawh hlatnaak awi amak kqawn thai qoe amyihna awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Aw Bawipa, nang ni ka ni qeh; Aw Bawipa ka Khawsa, namah ing nim hlat kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Kai ingtaw, Cekkhqi ing kaw koeh ni qep sih seitaw kang bah awh kak khan awh koeh zoeksang qu u seh,” ti nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Ikawtih, tlu tawm ca nawh, ka tlawhnaak ing amni hlah qoe hy. ");
INSERT INTO hltthb_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Ka sai thawlhnaak ce kqawn nyng; ka thawlhnaak ing kyinaak ni pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Tha ak awm ka qaalkhqi kqeng soeih uhy; ikaw am mai awh anik sawhnaak thlangkhqi khawzah ni. ");
INSERT INTO hltthb_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Ka leeknaak ce seetnaak ing anik thungkhqi ing ak leek ik-oeih ka hquut awh ak che na nik kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Aw Bawipa, nang ing koeh ni hlah hyt; Aw ka Khawsa, ak hla na koeh ni awm taak. ");
INSERT INTO hltthb_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Ka Bawipa ingkaw ka hulkung, kai hul aham ang tawnna law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Ka cehnaak lam awh ce kang ngaih ta nawh kam lai awm thlawlhnaak awhkawng khoem vang; thlakchekhqi ka haiawh a awm khui awhtaw kam kha ve cyp vang,” ti nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Cehlai awimyh na awm poek poek nawh, ik-oeih leek kqawn kaana ka awm awh zani, kak kawseetnaak ing pung hy. ");
INSERT INTO hltthb_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Kak kawk khuiawh kak kawlung hlawk nawh, poek typ typ nyng saw, mai ce kqawng hy; cawhtaw kam lai ing awi ce kqawn nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Aw Bawipa, ka hqing dytnaak ce nim huh nawhtaw khawnyn iqyt nu ka hqing kaw tice nim huh lah; ka hqingnaak ve choet ca mai ni ti ni sim sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Ka hqing khui khawsaknaak ve kut pha teh doeng ni sai tiksaw; ka hqingnaak ve na haiawh ik choet awm am law hy. Thlang boeih a hqingnaak ve hqi doek khoeih mai ni. ");
INSERT INTO hltthb_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Thlanghqing ve huhai na ak cet myihlip ing myih hy; amah poek awhtaw tamtaw soeih lawt hlai hy, a zap mai ni; them awm cun hlai hy, u ing a pang kaw tice am sim hy. ");
INSERT INTO hltthb_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Cehlai tuh Bawipa, kai ing u nu ka sui? Kang ngaih-u-naak taw nang awh ni a awm. ");
INSERT INTO hltthb_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Ka sai thawlhnaak ak khui awhkawng ni hul nawhtaw; thlakqawkhqi ak kqawnseet na koeh ni sai. ");
INSERT INTO hltthb_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Awimyh na awm nyng saw; kam kha am awng nyng, kawtih, ve ve nang ing na sai hawh ni. ");
INSERT INTO hltthb_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Na ni vyknaak ve ka ven awhkawng khoe hlah; na kut zawk hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","A thawlhnaak awh thlangkhqi ce zyi nawh toel hyk ti; thlang boeih ve hqi doek khoeih mai ni. ");
INSERT INTO hltthb_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Aw Bawipa, kak cykcahnaak ve ngai law lah, qeennaak thoeh doena kak khynaak awi ve ngai lah; kang kqangnaak ve nang haa koeh kqek sih lah. Ikawtih, na venawh khin amyihna awm nyng saw, ka pakhqi amyihna thlak chang na awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Cet nawh am ka awm voel naak tym apha hlan awh ka zeelnaak tlaih aham, ak chang na ning mang tak mai. ");
INSERT INTO hltthb_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Bawipa ce kawdungnaak ing ka qeh dawngawh; kai benna mang law nawh kang kqangnaak awi ce za hy. ");
INSERT INTO hltthb_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Lawk-kqawng dek nawng ak plai ak khui awhkawng nik dawk nawh, lungnu awh ka khaw ce ni leh sak hy, kang dyihnaak na hun nep ce ni pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Ningmih a Khawsa kyihcahnaak lak thai ce kam kha awh ta law hy. Thlang khawzah ing ami huh awh ce kqih kawm usaw Bawipa ce ypna kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Bawipa ak ypnaak thlang, amak thym khawsakhqi benna hawi unawh ak oek qu thlang amak toek taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Aw Bawipa ka Khawsa, kawpoek kyi na saikhqi doem soeih hy. Kaimih aham ik-oeih na qaalkhqi ve a doem soeih a dawngawh u ingawm am dang sak thai noeng hy, cemyihkhqi ce kqawn qoe nyng seiawm, noet noeng kaa ingkaw kqawn noeng kaana doem soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Bulnaak lucik nawn ce am hy tiksaw, kang haa ni vyh pe hawh hyk ti; hyih phumnaak ingkaw thawlh bulnaak ce am ngoe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Cawhtaw kai ing, “Vena awm nyng, law hawh nyng cahawn khuiawh ka kawng qee na awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Aw ka Khawsa, nak kawngaih ce sai aham hy nawh; na anaa awi ce kak kawlung awh khoem khak nyng,” ka ti. ");
INSERT INTO hltthb_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Dyngnaak ce thlangkqeng anglakawh kqawn nawh; AW Bawipa na sim hawh amyihna ka hui am khyp nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Na dyngnaak ce kak kawk khuiawh am thuh nyng saw; na ypawmnaak ingkaw na hulnaak khqi ce kqawn nyng. Thlangkqeng khawzah anglakawh na lungnaak awitak ce am phah nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Aw Bawipa, nam qeennaak ce ka hamna koeh hlawh lah; na lungnaak ingkaw nak awitak ing nik chung poepa seh. ");
INSERT INTO hltthb_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Ikawtih, noet boeih kaa kyinaakkhqi ing nik chung khoep nawh; ka thawlhnaak ing anik chung hawh dawngawh, ka mik am dang voel hy. Ka lu awhkaw ka lusam anglakawh doem khqoet unawh, kak kaw boet hqoeng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Aw Bawipa, kai hul aham nak kaw zeel sak lah; Aw Bawipa, kai hul aham ang tawnna law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Ka hqingnaak hqe aham ak tengkhqi ce chah qai phyi kawt na awm u seitaw ngai hangtum na awm lah u seh; kai plawci sak aham ak ngaihkhqi ce kawboet doena hlat u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","A ha! kai anik tinaakkhqi ce amik chah aih awh cat lyt lyt u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Cehlai, nang anik suikhqi boeih taw zeel u seitaw nang ak khan awh ce amik kaw zeel seh; ang quina, “Bawipa taw zoeksang na awm seh!” ti u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Cehlai, kai taw khawdeng thlang ingkaw ak syt thlang na awm nyng; Bawipa ing nik poek seh. Nang taw ka hulkung ingkaw anik hulkung na awm hyk ti; Aw ka Khawsa, koeh yih. ");
INSERT INTO hltthb_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Tha amak awm khawdeng thlang ak husim thlang taw a zoseen hy; kyinaak a huh awh anih ce Bawipa ing loet sak lawt kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Bawipa ing anih ce hloep kawmsaw a hqingnaak ce loet pe sak kaw; qam khuiawh anih ce zoseennaak pe kawmsaw a qaalkhqi ak kawngaihnaak a soepnaak aham anih ce am pe tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","A tlawh awh awm Bawipa ing awm pyi kawmsaw a tlawhnaak ihkhun awhkawng thawh tlaih kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Kai ing, Aw Bawipa, kai ve nim qeen lah; ni qoei sak lah, nak khan awh thawlh vik nyng,” ti nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Ka qaalkhqi ing kai ve “ityk awh nu thi nawh a plaltham kaw?” ni tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","kai huh aham ak law poh ing, amak thym hqoeng kqawn hy, ak kawk khuiawh thetnaak awi hqoeng awm hy; a ceh coengawh ak doem khqoet na kqawn hyn bai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Ka qaalkhqi boeih ing kai ve thlak che na ni hu unawh, ak che doek khoeih ka ham poek uhy, ");
INSERT INTO hltthb_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Tlawhche ing pha hawh nawh, ang zaihnaak hun awhkawng am tho voel tikaw,” ni tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Ka pyihleek soeih, ka ypnaak soeih ingkaw phaihpi anik veel pyi nawn ing, a khawdil nik thlek sih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Cehlai, Aw Bawipa, nang ing nim qeen lah; cekkhqi kut ka thungnaak aham, nim thawh cang lah. ");
INSERT INTO hltthb_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Ka qaalkhqi ing a mami noeng dawngawh, kak khan awh nak kaw zeel hy ti sim nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Ak thym kawlung ka taak dawngawh nang ing nim tu khak nawh na haai awh kumqui dyna ni awm sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Israel Khawsa, Bawipa venawh thangleeknaak awm seh nyng, kumqui awhkawng kumqui dyna Amen ingkaw Amen. ");
INSERT INTO hltthb_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Saksuk ing sihtui ang ngai amyihna, Aw Khawsa, kang myihla ing nang ning ngai soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Ka hqingnaak ing Khawsa, ak hqing Khawsa ce tui na ngaih hy. Ityk awh nu ka ceh nawh Khawsa ing ka ning hqum lah voei? ");
INSERT INTO hltthb_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Khawmthan khawdai mikphli tui ve buh na ai nyng saw, thlangkhqi ing khawnghi zung awh, “Na Khawsa hana a awm? ni tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Khawty khaw ning awh thlangkqeng ing Khawsa im na ceh buk buk doena khy ang kqang ing awmhly zeelnaak awi ak kqawn khqi ce kak poek awh, ka hqingnaak ve khuikha hy. ");
INSERT INTO hltthb_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Aw ka hqingnaak kawtih nang ngam khak vik hy voei? Ikawtih kak kaw khuiawh ngaihang tum na a awm? Bawipa awh ngaih-unaak ce ta lah, ka hulkung ingkaw ka Khawsa ce kyihcah hyn ngai kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Kak kawk khuiawh ka hqingnaak ve ang ngam khak hawh dawngawh; Jordan qam, Herman tlang sang. Mizar mawl awhkawng namah ce ni sim loet kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Chawihawng tuih awi awh tuihdung ingkaw tuihdung ce khy qu nih nawh na tuiphu ingkaw tui sambakkhqi ing ni liu mylh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Khawkdai awh Bawipa ing a lungnaak ce hlat law nawh, khawmthan awh a laa ce ka venawh awm sak hy. Ka hqingnaak Khawsa venawh kak cykcahnaak ce awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Lungnu ka Khawsa venawh, “Ikawtih na nim hilh hyt vik? Ikawtih ka qaal ing ani penelt qap awh kawboet ing ko doena kang pla khing kaw?” tina nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Ka qaalkhqi zakdam kawi awi awh ka quhkhqi awm thih pit dyna khuikha hy; myngawi, “Hana na Khawsa a awm?” ni tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Aw ka hqingnaak, kawtih nang ngam khak vik? Khawtih kak kawk khuiawh ngaihang tum na na awm? Bawipa awh ngaih-unaak ce ta lah, anih taw kam kyihcah hly dawngawh, ka hulkung ingkaw ka Khawsa ce. ");
INSERT INTO hltthb_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Aw Khawsa, ka thymnaak ve dang sak lah, Khawsa amak sim pilnam anglakawh ka thymnaak ve nik kqawn pyi lah; qaai ak kqawnkhqi ingkaw thlakche kut khui awhkawng ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Nang taw Khawsa ka vawngcak na awm hyk ti. Ikawtih na ni qoek vik? Ikawtih ka qaalkhqi ing ni nam qap nawh ngaihkyi ing ko doena kang pla khing kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Na vangnaak ingkaw nak awitak ce tyi nawhtaw, cekqawi ing ni sawi lah seh; cekqawi ing na awmnaak tlang ciim na ni ceh pyi lah seh. ");
INSERT INTO hltthb_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Cawhtaw Khawsa a bawkthang a awmnaak, ka awmhlynaak ingkaw ka zeelnaak Khawsa venna cet kawng. Aw Khawsa, ka Khawsa nang ce tingtoeng ing nim kyihcah vang. ");
INSERT INTO hltthb_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Aw ka hqingnaak ikaw tinawh nu nang ngam hqoeng vik? Ikawtih kak kawk khuiawh ngaihang tum na na awm? Bawipa awh ngaih-unaak ce ta lah, anih taw kam kyihcah hly dawngawh, ka hulkung ingkaw ka Khawsa ce. ");
INSERT INTO hltthb_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Aw Khawsa ka ming haa ing zahawh unyng; ka pakhqi ami hqing tloek awh ak kqym awh nang ing na sai peekkhqi ce kaimih a venawh kqawn hawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Na kut ing nang ngawh thlangphyn khqi thlak khqi pheng nawh ka pakhqi ce dyih sak hyk ti; thlangkhqi ce hqe nawh ka pakhqi ce kqeng sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Zawzi ing cekkhqi a qam ce am noeng unawh, ami bantha ingawm am noeng uhy; nang ak tang ben, nang a baan, ak vang nang a haai ing ni, kawtih cekkhqi ce nang ing lungna hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Nang taw ka sangpahrang ingkaw ka Khawsa na awm hyk ti, Jacob aham na noengnaak awi ak pekung na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Namah ak caming kaimih ing ka qaalkhqi huna nawn sak unyng; namah ang ming ing ka qaalkhqi ce leh unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Ka licung ve am ypna nyng saw, kak zawzi ingawm amni noeng sak hy; ");
INSERT INTO hltthb_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Cehlai, ka qaalkhqik khan awh noengnaak ce ni pe nawh, ka thunkhakhqi ce chah phyih sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Myngawi Khawsa awh oek qu kang nyng saw, nang ming ce kumqui dyna kyihcah kawng unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Cehlai tuh taw ni qoek nawh ak kai dyt na ni ta hawh hyk ti; ka qaalkapkhqi ingawm am cet haih voel hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Ka qaal a haiawh hu na ning thoeih sak nawh, ka thunkhakhqi ing ni him khqi pheng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Tuu amyihna daih aham ni hlah hyt tiksaw pilnam thlang venawh ni thek ni zak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Nak thlangkhqi ce a phu ak zawi cana zawi hlai hyk ti, zawih phu awm am awm lawk a he hy. ");
INSERT INTO hltthb_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Ka imcengkhqi am theet hly hqoeng na ni sai tiksaw, ka keng thlangkhqi a thekha qaihnaak ni phyih sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Pilnam anglakawh thlang ak kqawn hly kqoeng na ni sai tiksaw; thlang ing a lu nik kqek sih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Na haiawh myngawi kang ming se nawh, ka haai ve chahnaak ing sing khoep hy, ");
INSERT INTO hltthb_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","ak che na nik kqawn seet nawh, lu lawh aham ak caika qaalkhqi a dawngawh ni. ");
INSERT INTO hltthb_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Nang ce am nim hilh unyng saw na paipi awm a sawhqat na am sai thai unyng; vemyihkhqi boeih ve kaimih a venawh pha law hy. ");
INSERT INTO hltthb_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Kamik kawlungkhqi huna am thoeih nawh; kami khawkhqi awm na lam awhkawng am pleng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Cehlai kqawng uikhqi a hqip thek thyk aham nang ing ni nam qap nawh thannaak ing ni sing khoep hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Ka Khawsa ang ming ce hilh unawh qapchang khawsa a venawh kut kami phyl mantaw, ");
INSERT INTO hltthb_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","kawlung ak hyp zani ak simkung, Khawsa ing am hu kawm nu? ");
INSERT INTO hltthb_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Cehlai, nang awh myngawi thihnaak hu unyng; him ham kawina ak awm tuu amyihna ning ngai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Aw Bawipa, hqyng lah! Ikawtih, na ih hy voei? Kqoek qu lah! Kaimih ve kumqui dyna koeh ni hqek khqi. ");
INSERT INTO hltthb_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Ikawtih, na haai thuh nawh kaimih a kyinaak ingkaw khuikhanaak ve nam hilh hy voei? ");
INSERT INTO hltthb_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Dekvai awh nung tla unawh; dek awh kami pum ve bet qu qap hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Tho nawhtaw kaimih ve nik pyi khqi lah; amak dyt thai na lungnaak awh kaimih ve ni hul khqi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Sangpahrang aham ka phawh peek awi ce kak kqawn awh ak leek cainaak ing kak kawlung phyl hy; kam lai ve caqee ak thai thlang a cacung na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Nang taw thlangkhqi anglakawh leek soeih hyk ti. Khawsa ing kumqui dyna zoseennaak ani peek hawh a dawngawh, na hui nam lai ce qeennaak ing caksak na awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Aw thak awm thlang, nak zawzi ce bah lah; qypawmnaak ing thoeihcam qu lah. ");
INSERT INTO hltthb_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Awitak, kawdungnaak ingkaw dyngnaak ak caming haina noengnaak ingkaw qypawm doena cet nawh; nak tang kut ing kqih ak awm ik-oeih ce dang sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Ak sum na la ing sangpahrang a qaalkhqi lingbyi ce kah pe poelh seitaw; pilnam thlang ing na khawk kaina tlu seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Aw Khawsa, na boei ngawihdoelh cetaw kumqui dyna cak loet kaw; awideng thymnaak sawnghqawl ce na qam sawnghqawl na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Dyngnaak ce lungna nawh ak che ce sawh na hyk ti; cedawngawh Khawsa, na Khawsa ing na thawn pyikhqik khan awh ni ta nawh zeelnaak situi ing ni syp hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Na suibaikhqi ce mura ingkaw thiing baw na hqim nawh; vyi a ha ing thoeihcam na ak awm sangpahrang a im awhkaw tumding awi ing nak kaw zeel sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Sangpahrang a canukhqi awm kqihchah ak kap nukhqi anglakawh awm uhy; nak tang benawh taw ophir sui ing ak thoeihcam qu sangpahrang a zu ce dyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Aw canu, ngai lah, poek nawhtaw nang haa keng lah; nak thlangkhqi ingkaw na pa im ce hilh hlah. ");
INSERT INTO hltthb_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Nak thlang dawnaak ing sangpahrang ce zeel sak hy; zoeksang lah, anih cetaw na boeipa na awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Tura canu ing laksawng hawlaw nawh law kaw, thlang boeikhqi ing nak kawngaih sai aham thoeh law kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Sangpahrang canu ce a awmnaak ip khuiawh boeibau soeih na awm nawh a suisak taw sui ing tak haih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","A boe ak leek soeih suisak ing thoeihcam qu doena sangpahrang venna ceh pyi uhy; a pyi nulak cym tloek ing bawng law unawh na venna law pyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Cekkhqi ce awmhly doena law pyi unawh; sangpahrang a awmnaak ip khuina kun uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Na cakhqi ing na pakhqi a hun ce hu tloep kawm usaw; cekkhqi ce na qam khuiawh boeina ta kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Na sim poenaak ve chawn khawzah ing ama hilhnaak aham sai kawng nyng saw; pilnam ing nang ce kumqui ingkaw kumqui dyna nim kyihcah kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Khawsa taw ningnih ang thuknaak ingkaw thaawmnaak na awm nawh, kyinaak anglakawhkawng anik bawngkung na awm loet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Cedawngawh khawmdek ing lawha nawh thlangkhqi ing tuicunli dung ak khuina tlu mai seiawm am nik kqih tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Tuinu tho nawh phyl pung pung mai nawh, tuinu ang tyn awh tlangkhqi tat nyk nyk mai seiawm am nik kqih tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Khawsa a khawk bau, sawsang soeih a awmnaak hun ciim ak zeel mang sak lawngnu pynoet awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Ce khawk bau khuiawh Khawsa taw awm hy, cedawngawh am tlu tikaw; khaw a dai awh Khawsa ing bawng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Penglum ing tyn nawh, qamkhqi ing zawk hy; awi a hak sa awh, khawmdek a tui na zut hy. ");
INSERT INTO hltthb_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Thak awm Bawipa taw ningnih a venawh awm nawh; Jacob a Khawsa taw ningnih a vawngcak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Law nawhtaw Bawipa a ik-oeih sai ve toek lah, khawmdek awh seetnaak ce hawlaw hy. ");
INSERT INTO hltthb_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Khawmdek a dytnaak dyna qaal ding sak hy; licung ce hqem pe nawh caikhqi ce ek pe sak hy, phuhqakhqi ce mai awh phum pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Awm poek poek unawh taw, kai ve Khawsa ni tice sim lah uh; pilnam anglak li awh zoeksang na awm kawng nyng saw; khawmdek awh zoeksang na awm kawng”. ");
INSERT INTO hltthb_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Thak awm Bawipa taw ningnih a venawh awm nawh; Jacob a Khawsa taw ningnih a vawngcak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Pilnam thlangkhqi boeih aw, nami kut bei unawh taw; zeel doena Khawsa venawh khy lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Sawsang soeih Bawipa taw kqih awm nawh, khawmdek boeih ak khan awh sangpahrang bau soeih na awm hy! ");
INSERT INTO hltthb_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Pilnam thlangkhqi ce ningnih ak kaina ta law nawh, ningnih a khawk kaina ta law hy. ");
INSERT INTO hltthb_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Amah ing a lungnaak, Jacob ing a zoeksang qunaak qam ce ningnih a khawk kaina ta law hy. ");
INSERT INTO hltthb_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Awmhly zeelmang ing khynaak anglak li awh Khawsa ce hang kai nawh, uut awi anglak li awh Khawsa taw hang kai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Khawsa venawh kyihcahnaak laa sa lah uh, kyihcahnaak laa sa lah uh; ningnih sangpahrang a venawh kyihcahnaak laa sa lah uh, kyihcahnaak laa sa lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Ikawtih Khawsa taw Khawmdek boeih a Khawsa na awm hy saam kyihcah naak laa ce a venawh sa lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Pilnam ak khan awh Khawsa taw boei na awm hy; a boei ngawihdoelh ciim awh ce Khawsa taw ngawi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Abraham Khawsa ak thlang na ami awm dawngawh pilnam thlang boeikhqi ing cun uhy; kawtih, aw khawmdek awhkaw sangpahrang khqi awm Khawsa koe ni; anih taw khawteh na zoeksang na awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Bawipa taw Boeimang na a awm dawngawh, ningnih a kyihcah tyng na awm qoe hy. ");
INSERT INTO hltthb_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","A sangnaak awh ak leek soeih, khawmdek awmhlynaak na awm hy. Boeimang soeih sangpahrang a khawk bau taw Zaphon tlang a sangnaak soeih Zion tlang amyihna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Khawsa taw amah a im awh awm nawh, amah ce vawngnu na chung qu hy. ");
INSERT INTO hltthb_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Sangpahrangkhqi ing za qu unawh, cem a qaal na ami ceh haih awh, ");
INSERT INTO hltthb_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Anih ce hu tawk qat unawh cat uhy, kyih doena cen bang uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Cawh ce thyn ngawng ngawng unawh, nu ca awm tlawh ing a kee amyihna awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Khawlaw ben nakaw khawhli ing Tarshish awhkaw lawngkhqi a khup phlet peek amyihna cekkhqi ce hqe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Ningmih ing ning zaak amyihna, Boeimang Bawipa ningnih a Khawsa khawk bau khuiawh ni huh hawh amyihna; Khawsa ing khawk bau ce kumqui dyna loet sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Aw Khawsa, na bawkim khuiawh, amak dyt thai na lungnaak ce poek unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Aw Khawsa, namah ang ming amyihna nam kyihnaak ing khawmdek a dytnaak pha nawh, nak tang ben kut ce dyngnaak ing be loet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Nak awidengnaak awh ce, Zion tlang ing zeel nawh, Juda khawkhqi ing amik kaw zeel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Zion kqang cet lah, a keng kqang cet nawhtaw, qaltoeng imkhqi ce noet lah, ");
INSERT INTO hltthb_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Na cadilkhqi venawh nak kqawn peek na qaal a qeh awh dek ak cawhkhqi ingkaw a khawk bau ce toek lah. ");
INSERT INTO hltthb_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Ve Khawsa ve ningnih a kumqui Khawsa na awm nawh; a dyt dyna ningnih anik sawi khqi kung na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Nangmih thlangkhqi boeih aw, ve ve za unawh taw; ve khawmdek awh ak awmkhqi boeih aw ngai lah uh, ");
INSERT INTO hltthb_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Ak nem ak sang, boei khawdengkhqi boeih: ");
INSERT INTO hltthb_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Kam kha ing cyihnaak awi kqawn kawmsaw; kak kawlung khuiawh kaw awi ing zaksimnaak ni pe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Awicyih benna kang haa keng kawng nyng saw; tingtoeng ing kak awi rylh ce kqawncaih kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Khawnghi amak leek a pha law awh kawtih kqih nawh, qaai ak kqawn thlakche khqi – ");
INSERT INTO hltthb_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","a mimah a boeinaak ak ypnaak thlangkhqi ingkaw a boeinaak awh ak oek qu thlangkhqi ing anik chung khoep awh kawtih kak kqih kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","U ingawm thlang a hqingnaak am hul thai nawh anih aham Khawsa venawh hulnaak a phu awm am pe thai hy- ");
INSERT INTO hltthb_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","hqing thaawngnaak a phu ve tlo soeih nawh, ikawmyih a phu pek ingawm am khoek nawh- ");
INSERT INTO hltthb_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","thlang ing kumqui dy hqing nawh ama thu naak aham. ");
INSERT INTO hltthb_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Thlakcyi a thih awm thlang boeih ing hu hy; thlak qaw ikaw amak sim thlang ing ang amyihna qeeng haih unawh thlang aham nani kawn ce ami ceh taak uh. ");
INSERT INTO hltthb_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","A mimah ingtaw a mimah ang ming ing qamkhqi ce ta lawt hlai uhy, ami phyikhqi ni kumqui dy ami awmnaak imkhqi na awm nawh, amak dyt qoe ami cadil dyna ami awmnaak hun na awm loet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Thlanghqing ve, boei seiawm, am cak loet hy; qamsa ak qeeng ing ni a ming myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Amah ingkaw amah ak yp qunaak khqi taw cemyihna awm kawm uh, anih ak awi cangna nawh anih a hu awh ak bat thlangkhqi awm cemyihna awm kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Tuu amyihna cekkhqi a dytnaak taw phyi mai ni, thihnaak ing a mingmih ce hqin khqi kaw. Thlak dyngkhqi ing cekkhqi ce mymcang hqit awh uk kawm usaw; cekkhqi a myi ce phyi awh ni a thu hly, a boeinaak im nu awhkawng hla hawh kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Cehlai, Khawsa ing ka hqingnaak ve phyi khui awhkawng thaawng kawmsaw; amah a venna ni ceh pyi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Thlang ce khawhthem zen nawh, a ip khuiawh ik-oeih a taai law awh ce koeh kqih paqap; ");
INSERT INTO hltthb_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","A thih awhkaw pynoet ca awm khyn vang am ti a he hy, a taak khawhthem ing am nuk hqut tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","A hqing tloek awhtaw a zoseen soeih na ngai qu nawh – na boei tloek awhtaw thlang ing nim kyih hlai hy- ");
INSERT INTO hltthb_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","a pakhqi a cadil ce ni ak bawng hly lawt hy, hqing vangnaak am hu voel qoe tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Zaaksimnaak taak kaana ak boei thlang taw qamsa ak qeeng ing ni a ning myih. ");
INSERT INTO hltthb_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Boeimang thak awm, Khawsa, Bawipa ing, khaw a lawnaak awhkawng a nung tlak dyna khawmdek ve khy nawh awi kqawn pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Thlang dawnaak soepbiit ing Zion awhkawng Khawsa ce vang law theng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Ningmih a Khawsa ce law kawmsaw am awm dym kaw; a haaiawh mai kqawng kawmsaw, a kengsam awh khawhli ing chung kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Khan ingkaw Khawmdek ce khy kawmsaw, ak thlangkhqi ce awi deng kaw: ");
INSERT INTO hltthb_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Bulnaak ing kai ingkaw paipi ak sai haih thlak ciim ka hoep tloek ce cawi law lah uh,” ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Khawsa amah ce a thym a dawngawh, khankhqi ing a dyngnaak ce kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Ngai lah uh, Aw ak thlangkhqi, awi kqawn law vang nyng, aw Israel, am ka ni ngaihnaak ve ni sim sak khqi lah vang: kai taw Khawsa, na Khawsa na awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Ka haiawh ak awm loet bulnaak ingkaw hyih phumnaak awh am ni zyi hlyk khqi nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Na ip kai awhkaw vaitawm cai am ngoe nyng nak khqin im awhkaw mem-cai awm am ngoe nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Ikawtih, kqawng nakaw qamsa boeih boeih ce kai a koe ni, tlang thong oet awhkaw khqin ak taikhqi boeih awm kai a koe ni. ");
INSERT INTO hltthb_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Tlang awh ak awm pha boeih boeih ce sim nyng saw, qam khuiawh kaw ik-oeih sai boeih boeih awm kai a koe ni. ");
INSERT INTO hltthb_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Buh cawi nyng seiawm kak kqawn re am ngoe hy, kawtih, Khawmdek ingkaw ak khuiawh ak awm ik-oeih boeih ve kai a koe ni. ");
INSERT INTO hltthb_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Vaitawm cai a sa ka ai nawh mee a thi ka aw nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Khawsa venawh ymnaak bulnaak sai nawh sawsang soeih a venawh nak awikamnaak ce soep sak lah, ");
INSERT INTO hltthb_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Kyinaak na huh nyn awh ce nik khy lah; kai ing ni loet sak kawng nyng saw, cawhtaw kai ce ni zoeksang kawp ti.” ");
INSERT INTO hltthb_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Cehlai, thlakche venawh, Khawsa ing: “Ka cawngpyinaak awi kqawn thainaak ikaw ta nawh, ka paipi na huiawh pha thainaak ikaw na taak? ");
INSERT INTO hltthb_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Ka ni cawngpyinaak sawh na nawh na huna kak awi khawng hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Thlang quk-ai na huh awh, bawk pyi hyk ti; samphaihkhqi mi zawk qu haih uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Nam kha ce awih che kqawnnaak na hawna nawh nam lai ce qaai kqawnnaak ing sing hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Na koeinaa ce a dyt kaana kqawn seet nawh na nuca nawn ce ak che na kqawn hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Vemyihkhqi boeih ve sai hlai hyk ti, ni awm taak dym nyng; nang amyihna ni ka awm lawt namih hy tinawh poek hyk ti. Cehlai, ni toel nyng saw na mik huh qoe awh dang sak lah vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Nangmih Khawsa ak kqih tloek, ve ve poek lah uh, am awhtaw hulkung taak kaana ni phukkhqi vyt vyt kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Uepmnaak lucik ak sai ing kai ni zoeksang nawh, Khawsa a hulnaak kam huhnaak thai aham anih ing lam qoek a bah hy. ");
INSERT INTO hltthb_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Aw Khawsa, na lungnaak amak dyt thai ak caming kai ve nim qeen cang lah; na thintlawhnaak ak bau soeih ing ka sai thawlhnaak ve caih law sak cang lah. ");
INSERT INTO hltthb_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Kang plawng thawlhnaak ve sil law nawhtaw ka thawlhnaak awhkawng ni ciim sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Ikawtih, ka sai thawlhnaak ve sim nyng saw, ka thawlhnaak ve ka haiawh awm loet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Nang ing ak kalh na, nang aven doengawh, thawlh hawh nawh namik huh awh ak che ik-oeih ce sai hawh vik nyng, cedawngawh awi nak kqawn awh na thymnaak ce dang nawh awi na ceknaak awh thym hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Ka thang plek awhkawng thawlh qoe hawh nawh, ka nu puk khuiawh thawlh doena ni anik bah qoe hawh. ");
INSERT INTO hltthb_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Nang ingtaw ak khui ben awitak doeng ngaih nawh; kawlung am cei dyt awh nang ing cyihnaak ni cawngpyi hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Hyssop ing ni ciim sak nawhtaw, cawhtaw ciim hawh kawng nyng; ni sil nawhtaw, cawhtaw vyl anglakawh bawk hawh kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Awmhly kaw zeelnaak awi ce ning zaak sak lah; na ek sak ka quhkhqi ve zeel lah seh. ");
INSERT INTO hltthb_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Ka thawlhnaak awh na haai thuh nawh kang plawng thawlhnaak ve caih law sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Aw Khawsa, kak khuiawh kawlung ciim sai law lah, kang myihla ve thai law sak pang lah. ");
INSERT INTO hltthb_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Na ven awhkawng koeh nik khawng valh nawh nang Ciim Myihla awm koeh lo law valh cang. ");
INSERT INTO hltthb_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Na hulnaak zeelnaak ce ni pe tlaih nawhtaw na nim tunaak qap aham boe ak ngai myihla ce ni pe lah. ");
INSERT INTO hltthb_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Cawhtaw ik-oeih ak sai thawlh thlangkhqi ce na lam cawngpyi kawng nyng saw, thlak thawlhkhqi ing na venna hlat law tlaih kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Aw Khawsa, kai anik hulkung Khawsa, thi lawng sak thawlhnaak awhkawng ni hul cang lah, cawhtaw kam lai ing na dyngnaak laa ce sa kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Aw Bawipa, ka hui ve awng law lah, cawhtaw kam kha ing nam kyihnaak ce kqawn kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Bulnaak awh nak kaw am zeel hy, cek kaa mantaw hawlaw hawh kawng nyng; hyih phumnaak awh awm am zeel bai hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Khawsa a bulnaak khqi taw myihlak kqek ve ni; kawlung kqek nawh kawseetnaak ve ni, Aw Khawsa ve ve nang ing am sit ti kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Na ngaihnaak amyihna Zion ce hang leek sak nawh; Jerusalem vawng ce thawh tlaih lah. ");
INSERT INTO hltthb_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Cawhtaw dyngnaak bulnaak ce awm kawmsaw nang ak khawzeelnaak a cuna hyih phumnaak ce awm hawh kaw; cekcoengawh taw na bawkthang awh vaitawm caikhqi ce nawn law hawh kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Nang tha ak awm soeih, kawtih ik-oeih amak leek awh nang oek qu hy voei? Khawsa mik huh awh chah qai na ak awm nang, kawtih myngawi nang oek qu paqap? ");
INSERT INTO hltthb_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Nam lai ing seetnaak doeng cai sih nawh; zawzi ak hqat thak bat amyihna awm hy, qaai kqawnnaak doeng ce sai hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Ik-oeih leek anglakawh ik-oeh che ce lungna lat tiksaw, awitak kqawn anglakawh amak thym awih kqawn ce ngaih bet hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Aw qaai kqawnnaak ing ak be lai! Awih tlo kqawn ce lungna hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Khawsa ing kumqui plamnaak na ni nuk thla kaw; nang ce ni qawt kawmsaw na khawnghi im awhkawng nik dawk plawk kaw; na awmnaak qam awhkawng nak kqa mah na ni phu kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Thlakdyngkhqi ing hu kawm usaw kqih kawm uh; a mingmih ing qaih na kawm usaw, vemyihna, ");
INSERT INTO hltthb_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","Khawsa ce vawngcak na taak kaana amah a boeinaak ypna lat nawh thlang hqenaak ben awh tha ak awm thyk thlang vawh awm hy ve!” tina kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Cehlai, kai taw Khawsa ip khuiawh ak qah olive thing amyihna awm nyng; amak dyt thai Khawsa lungnaak ce ni kumqui ingkaw kumqui dyna ka ypnaak. ");
INSERT INTO hltthb_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Na ik-oeih sai awh kumqui dyna ni zoeksang kawng nyng saw; namah ang ming awh ngaih-unaak ce ta kawng nyng, kawtih namah ang ming taw leek hy. Nak thlang ciimkhqi haiawh nang ce nim kyih kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Thlak qaw ingtaw ak kawk khuiawh, “Khawsa am awm hy,” tihy. Vemih thlangkhqi taw ak plawcikhqi na awm unawh, a khawboe qamlang awm tyih ak awm thlangkhqi na awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Zaaksimnaak ta nawh Khawsa ak sui, ak awm khoem hy voei nu tinawh, Khawsa ing khawk khan nakawng thlanghqing capakhqi ce nuk dan hy. ");
INSERT INTO hltthb_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Thlang boeih ing lam awhkawng pleng unawh, a cu boeih na plawci kang hawh uhy; ik-oeih leek ak sai u awm am awm hy, u pynoet ca awm am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Thlang ing phaihpi a ai amyihna kak thlangkhqi daih nawh Khawsa awm amak khy man ik-oeih che ak saikhqi ing a sim kaana awm kawm u nu? ");
INSERT INTO hltthb_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Kqih hly kawi ama awmnaak awh kqih awmnaak ing sing khqi hawh hy. Nang anik tukkhqi a quhkhqi ce Khawsa ing hqek phang tlang hawh hy; cekkhqi ce chahqai phyih sak khqi hawh hyk ti, kawtih, cekkhqi ce Khawsa ing kawna am sui voel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Aw, cawhkaw Israelkhqi hulnaak ce Zion awhkawng law lah voei! Khawsa ing ak thlangkhqi zo a seen law sak tlaih awhtaw, Jacob ing zeel seitaw Israel ing ak kaw zeel sak seh. ");
INSERT INTO hltthb_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Aw Khawsa, nang ming ing kai ve ni hul lah; nak thaawmnaak ing ak thym na awi kqawn law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Aw Khawsa, kak cykcahnaak ve za law nawhtaw; kam kha awhkaw awi ve ngai law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Thlak changkhqi ing ni tuk unawh; qeennaak amak ta thlangkhqi Khawsa kawna amak sui thlangkhqi ing ka hqingnaak doen law uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Khawsa taw anik hulkung na awm tak tak nawh; Bawipa taw kai anik dylkung na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Kai anik kqawn seetkhqi ce seetnaak ing zeen khoep seitaw; na ypawmnaak ing cekkhqi ce hqe seh. ");
INSERT INTO hltthb_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Na venawh kamah ak kaw sim ing bulnaak sai vang nyng; Aw Bawipa, nang ming kyihcah ve a leek dawngawh nim kyihcah vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Ikawtih, anih ing ka kyinaak boeih ak khui awhkawng nik dawk nawh, ka mik ing ka qaalkhqi ce noengnaak ing toek hy. ");
INSERT INTO hltthb_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Aw Khawsa, kak cykcahnaak ve ngai law lah, qeennaak ka thoeh lawnaak ve kawna a sui kaana koeh awm; ");
INSERT INTO hltthb_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Ngai law nawhtaw hlat law lah. Kawpoek ing ngaih kyinaak ni pe nawh, ");
INSERT INTO hltthb_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","ka qaal ak awi ingkaw, thlakchekhqi amik dai sihnaak awh ly a lap na awm hqoeng nyng; kak khan awh khuikhanaak pha sak unawh khawso doena ka qaalkhqi ing ni zyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Kak kawlung khuiawh ka lingbyi ve khuikha zawk nawh; thih kqihnaak ing ni sing khoep hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Kqihnaak ingkaw thynnaak ing nik chung nawh; kqih awmnaak ing ni myk khoep hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Cawh, Aw, kqukkqu amyihna kang hla ta lah voei nyng! Ak hla na ding nyng saw awm oeih oeih lah voei nyng – ");
INSERT INTO hltthb_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Ak hla na cen nyng saw qamkoh awh awm lah voei nyng; ");
INSERT INTO hltthb_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Hlinu ingkaw khawhli ing a phanaak voet ka awmnaak hun na ang tawnna cet lah voei nyng,” ti nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Aw Bawipa, thlak chekhqi ce lungcing haven na ta nawh, ak awih kqawnkhqi awm chum hang sak lah, khawk bau khuiawh awipungnaak ingkaw hqo ang hqitnaak hu nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Khawmthan khawdai vawng awhkawng thlang qym uhy; ak khuiawh amak leek ingkaw amak thym poeknaak awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Plawcinaak ing khawk bau khuiawh bibi nawh; thekhanaak ingkaw qaai awikhqi lamkhqi awh am poet qoe hy. ");
INSERT INTO hltthb_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Qaal ing ani thekhanaak mantaw, yh thai kawng nyng; qaal ing cem ni thawh sih mai seiawm, thuk taak thai kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Cehlai, kamah amyihna thlang ak awm, ka pyi, ak zoe khyt ka pyi taw nang ni. ");
INSERT INTO hltthb_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Khawsa im na thlangkqeng mi ceh haih awh awmhly zeel doena ka pawlneng haih ceni. ");
INSERT INTO hltthb_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Thihnaak ing ka qaalkhqi ve tu qut sang mai nawh; phyi khuina a hqing a saina ceh pyi mai thaw voei uh, kawtih seetnaak ing a mingmih anglakawh awmnaak hun tahy. ");
INSERT INTO hltthb_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Cehlai, Khawsa ce khy nyng saw, Bawipa ing ni hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Myncang, khawmy ingkaw khawnghyp awh ce ngaih kyi doena khy nyng saw, anih ing kak awi ce za law hy. ");
INSERT INTO hltthb_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Ka qaal ce doem soeih bai seiawm, kai anik tukkhqi anglak khui awhkawng a tlawh ang zak kaana ni hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Kumqui dy boei ngawihdoelh awh ak ngawi, Khawsa ing cekkhqi ce za kawmsaw a tlawh zaak sak khqi kaw. A khawboe amak chawt man thlangkhqi ingkaw Khawsa amak kqih thlangkhqi na awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Ka pyi nawn ing a pyi ce tuk nawh; a paipi ce a sawhqat na awm sak nawn paqap hy. ");
INSERT INTO hltthb_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Ak awih kqawn taw sithau amyihna haal hlai saw, ak kawk khuiawh qaal tuknaak doeng awm hy; cehlai zawzikhqi ak phlawng na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Na phyihqih ce Bawipa awh hal lah anih ing tha ni awm sak kaw; ak thlang dyng ce ityk awh awm am tluk sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Cehlai, Aw Khawsa, nang ing thlak che ce seetnaak lawk-kqawng khuina nuk thla bit kawp ti; thlang thi ak hoetkhqi ingkaw qaai awi ak kqawnkhqi taw a hqingnaak pyng thym awm am hqing kaw. Cehlai kai ingtaw, nang ni ka ni ypnaak. ");
INSERT INTO hltthb_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Aw Khawsa, nim qeen cang lah, thlak chekhqi ing nik thla khqek khqek unawh; ang qui na ni tuk khqoet khqoet uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Kai anik kqawn seetkhqi ing ang loet na ni hquut unawh: thlang khawzah ing oek qu doena kai ni tuk uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Kai ing kak kqih awh, namah ce ni ypna vang. ");
INSERT INTO hltthb_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Ak awi kam kyih peek ce, Khawsa ni, Khawsa ni ka ypnaak; ap kqih tikawng. Ak thi thai thlanghqing ing ikaw ani tinaak tang kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Myngawi kak awi ni hawi pe unawh; kai tlawh peek aham doeng na ni teng uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Ka hqingnaak him aham za qu unawh, ni mah unawh ka khaw kan qym halal uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Cekkhqi ce ikawmyih na awm koeh loet sak khqi; Aw Khawsa, nak kawsonaak ing pilnam thlang zawk sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Ka lungnat ve khoem lah; na cak-chawi awh ka mikphli tui ve qee lah - na khoemnaak cauk awh cekkhqi ce ak awm nu? ");
INSERT INTO hltthb_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Qeennaak thoeh doena nang ka nik khy awh ka qaalkhqi ce hlat kawm uh. Cawhtaw Khawsa taw kai a koe ni tice sim hawh kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Ak awi kam kyih peek ce Khawsa, ak awi kam kyihcah peek ce Bawipa ni. ");
INSERT INTO hltthb_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Khawsa ce ka ypnaak dawngawh; ap kqih kawng. Thlanghqing ing kai ikaw ani tinaak tang kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Aw Khawsa, na venawh awi kam law nyng; ymnaak ik-oeih ce na venawh nawn law kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Ikawtih, thihnaak awhkawng ni loet sak hyk ti, hqing vangnaak Khawsa haaiawh ka cehnaak thai aham ka khaw ve am bah sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Aw Khawsa, nim qeen lah, nim qeen lah, kawtih nang awh ni ka hqingnaak ang thuk. Plawcinaak ang khum hlan dy nang hlak khuiawh thuk vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Kai aham ang cainaak ak soep sak Khawsa, sawsang soeih Khawsa venawh khy nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Anih ing khan nakawng tyi nawh kai ce ni hul hy, kai anik hquut khqek khqekkhqi ce toel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Kai taw samthyyn anglak li awh awm nyng saw; qamsak tlung anglakawh zaih nyng – ce thlangkhqi a ha taw ak hqat soeih zawzi na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Aw Khawsa, khan poeng voelh dyna hak zoeksang qu lah; na boeimangnaak ve khawmdek boeih ak khan awh awm lah seh. ");
INSERT INTO hltthb_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Ka khaw ang awhnaak aham lawk zan law unawh kawboet doena ngam hqoeng nyng. Ka cehnaak lam awh lawk-kqawng co law hlai hy – a mimah ce lawk-kqawng awh tla lat uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Kam thin taw cak hy, Aw Bawipa kam thin ce cak hy; tingtoeng tum nawh laa sa vang. ");
INSERT INTO hltthb_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Ka hqingnaak, hqyng lah! Tingtoeng ingkaw qaw tingtoeng nang, hqyng lah! Kai taw mymcang hqit awh hqyng hawh kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Pilnam thlang anglak li awh, Aw Bawipa, nang ce nim kyihcah vang. Thlanghqing lak awh nang ce laa na ni sa vang. ");
INSERT INTO hltthb_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Ikawtih, na lungnaak taw bau nawh, khan hak pha hy; na ypawmnaak ing khan hak pha hy. ");
INSERT INTO hltthb_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Aw Khawsa, khan poe voelh dyna hak zoeksang qu lah; na boeimangnaak ve khawmdek boeih ak khan awh awm lah seh. ");
INSERT INTO hltthb_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Nangmih ukkungkhqi ak thym na nu awi namik kqawn ce? Thlangkhqi anglakawh ak thym na nu awi nami deng? ");
INSERT INTO hltthb_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Nak kawk khuiawh taw amak thym poek u tiksaw, nami kutkhqi ing ak che ik-oeih ni naming thoeng sak uh. ");
INSERT INTO hltthb_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Thlakche taw a thang plek awhkawng lam pleng qoe hawh hy; a nu a puk khui awhkawng qaai awi kqawn doena thoek hy qoe hawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Cekkhqi a chy taw khqui a chy amyihna awm nawh, ngentau a haa ak pangkhqi amyihna awm uhy, ");
INSERT INTO hltthb_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Kawmih aih dyna thoemnaak ing mawk mai seiawm, ");
INSERT INTO hltthb_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Aw Khawsa, cekkhqi am kha awhkaw ami haakhqi ce khoeng pe lah; Aw Bawipa, samthyyn a haakhqi ve ek sak kang lah. ");
INSERT INTO hltthb_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Qam na ak lawng tui amyihna qeng sak bang nawhtaw; licung ami hawi awh ce ami lakhqi rem pe kang seh. ");
INSERT INTO hltthb_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Kawlawk taw ang thoeih awh tui a zut noe noe amyihna, naasen ak qawk amyihna, khawmik qoe koeh hu u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Nak amkhqi ing hling maih hlawk ang zaak hlan awh - a hqing awm ak koh awm- thlak che taw qeng bang kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Lu lawh na awm nawh thlak chekhqi a thi ing khaw ami silh awh ce thlakdyngkhqi taw zeel kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Cawhtaw thlangkhqi ing; “thlakdyng khqi taw laksawng huk cang unawh; Khawmdek awi ak dengkung awm awm cang ti maw ve” ti kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Aw Khawsa, ka qaal kut khui awhkawng ni loet sak lah, kai anik qaalnaak thlangkhqi ven awhkawng nik chung lah. ");
INSERT INTO hltthb_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Ik-oeih amak leek ak sai thlangkhqi kut khui awhkawng ni loet sak nawh thlang a thi tui na ak ngaihkhqi kut khui awhkawng ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Kaw amyihna kai ami ni mah ce toek lah! Aw Bawipa, kaw thawlhnaak awm am ka sai mai awh, thlak tlungkhqi ing kai ni teng uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Ka sai thawlh ikaw awm am awm hlai hy, kai tuk aham oepchoeh na awm uhy. Kai hul aham tho lah; ka lynaak ve toek lah! ");
INSERT INTO hltthb_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Aw Bawipa Boeimang Khawsa, Israel Khawsa pilnam thlang boeih toel aham tho lah; Thlak chekhqi ce koeh qeen qoe qoe. ");
INSERT INTO hltthb_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Khawmy awh hlat law unawh, uikhqi amyihna thlang oh doena, khawk bau khuiawh thoek uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Am khak khui awhkawng a sa ce toek lah - ami hui awhkawng zawzi sa unawh, “U ing nik chah hly paqap?” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Cehlai, Bawipa, nang ing cekkhqi ce qaih na lah; ce pilnam thlangkhqi ce qaih na hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Aw kak tha awmnaak, nang ni ka ni qeh; Aw Khawsa, nang taw kai a vawngcak na awm tiksaw, ");
INSERT INTO hltthb_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Ka lungnaak Khawsa na awm hyk ti. Khawsa taw ka hai benawh cet kawmsaw kai ak che na anik kqawnkhqi ce kawqepnaak ing ni toek sak kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Cehlai, kaimih a phuhqa na ak awm, Aw Bawipa, cekkhqi ce koeh him lah, kak thlangkhqi ing cekkhqi ce qoe sak khqi nawhtaw, zawk sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Am kha awhkaw thawlhnaak, a huikhqi awhkaw awi awh, a mimah ang oek qunaak awh tu sak nawn lah. Ami seet lawhnaak ingkaw qaai amik kqawnnaak dawngawh, ");
INSERT INTO hltthb_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Nak kawsonaak ing cekkhqi ce milh sak nawhtaw, a mami awmnaak tlaih qoe dy awh milh sak phang tlang lah. Cawhtaw khawmdek a dytnaak dyna Khawsa ing Jacob uk hy tice sim kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Khawmy benawh hlat law unawh, uikhqi amyihna thlang oh doena, khawk bau khuiawh thoek uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Buh sui unawh thoek uhy, amik phoen ama phyi awhtaw khy uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Cehlai, kai ingtaw nak thaawmnaak ce laa na sa kawng nyng saw, mymcang awh na lungnaak ce laa na sa vang; kawtih nang taw ka vawngcak, kyinaak ka huh awh kang thuknaak na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Aw kak thaawmnaak, nang kyihcah Khawsa, ka vawngnu na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Aw Khawssa, kaimih ve ni qoek khqi hawh tiksaw, kaimih ak khan awh nak kaw so hawh hy; nak kaw so hawh nawh - nim thawh tlaih lah! ");
INSERT INTO hltthb_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Nang ing qam ce thloek tiksaw can sak thulh hawh hyk ti; ak kqek khqi ve cawng tlaih lah, tlai nyk nyk hy. ");
INSERT INTO hltthb_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Nak thlangkhqi ce kawboet kyinaak ni huh sak khqi tiksaw; misur tui ni awk sak khqi nawh kami ceh am thym voel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Cehlai, nang anik kqihkhqi aham taw, hizan ce hak zoek tiksaw li ce dan khoep hy. ");
INSERT INTO hltthb_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Nak tang kut ing ni hul khqi nawhtaw ni thaawng khqi lah, na lungnaak thlangkhqi loet na u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Khawsa ing a hun ciim awhkawng: “Noengnaak ing Shechem ce cun kawng nyng saw Succoth tuikaw ce tah vang. ");
INSERT INTO hltthb_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Gilead ve kai a koe ni, Monasseh awm kai a koe ni; Ephraim ve ka thi lumyk na awm nawh, Judah ve ka sawnghqawl na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Moab ve kang silh qunaak beihthuk na awm nawh, Edom ak khan awh ka khawmyk khawng nyng saw; Philistia qam khan awh noengnaak ing khy nyng,” tihy. ");
INSERT INTO hltthb_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","U ing nu khawk bau cak na anik ceh pyi kaw? U ing nu Edom na ani sawi kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Aw Khawsa, nang ing ni qoek khqi nawh ka qaalkapkhqi mi am cet haih voel hyk ti ka ti my? ");
INSERT INTO hltthb_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Qalkap tuknaak thai aham bawngnaak ni pe lah, kawtih thlanghqing ak bawngnaak taw a phi am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Khawsa ing ni noengnaak ce ka mi huh hly, anih ing ni qaalkhqi ce a khaw ing a leh hly. ");
INSERT INTO hltthb_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Aw Khawsa, kang kqangnaak awi ve za nawh taw; kak cykcahnaak awi ve ngai lah. ");
INSERT INTO hltthb_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Ikawtih, khawmdek a dytnaak nakawng nik khy nyng, kak kawlung a haal doena nik khy nyng; kai anglakawh ak sang khqoet lungnu venna ni ceh pyi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Ikawtih, nang taw ka ning thuknaak na awm tiksaw, ka qaalkhqi a qaltoeng ipsang na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Na hizan im awh kumqui dy awm ce ngaih nyng saw nang hlak khuiawh thuk ce ngaih nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Aw Khawsa, nang ing awi ka kam ve za hawh hyk ti; nang ming ak kqih thlangkhqi a qo ce ni pang sak hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Sangpahrang a hqing khui khawnghi ve sap pe nawh a cadil dyna a kum sang sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Khawsa haiawh kumqui dy boei na ngawi lah seh; na lungnaak ingkaw ypawmnaak ing anih ce hlip ak chung lah. ");
INSERT INTO hltthb_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Cawhtaw nang ming kyihcahnaak laa ce sa poepa kawng nyng saw hypoet coeng hypoet kak awikam ce soep sak kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Ka hqingnaak ing Khawsa doek khoeih awh dymnaak hu hy: ka hulnaak awm anih aven awhkawng ni a law. ");
INSERT INTO hltthb_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Anih doeng ve ka lungnu ingkaw ka hulnaak na awm hy; ahih taw ka vawngnu na a awm dawngawh, ityk awh awm am tat ti kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Thlang pynoet ce iqyt dy nu na thekhanaak kaw? Anih ce ak kai na, nami det hly nawh nu vawhkaw ak tlu tawm vawng, a khanaak ak dyi tloei ve? ");
INSERT INTO hltthb_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","A awmnaak hun sang awhkawng ak kaina tlaak sak aham cai unawh; qaai awi kqawn ce lungna uhy. amim kha ingtaw zoseennaak pe hlai uhy, amik kawk khui awhtaw seet lawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Aw ka hqingnaak, Khawsa doeng awh dymnaak sui lah: kang ngaih-unaak taw anih a ven doeng awhkawng ni a law. ");
INSERT INTO hltthb_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Anih doeng ce ka lungnu ingkaw ka hulnaak na awm hy; anih taw ka vawngnu na a awm dawngawh ityk awh awm am tat kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Ka hulnaak ingkaw ka kqihchahnaak taw Khawsa awh ni ang hang hy; anih taw ka lungnu bau, kang thuknaak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Aw thlangkhqi aw, ikawmyih awh awm amah ce ypna lah uh; amah venawh namik kawlungkhqi ce pe lah uh, kawtih Khawsa taw ningnih ang thuknaak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Ak nem na ak thangkhqi taw zilh hqoeng na awm nawh, ak sang na ak thangkhqi awm a qaai mai ni; a khingnaak awh ni khing awh ce a hqawng na awm bawk hy nih; pak khih bawk na zilh mai ni. ");
INSERT INTO hltthb_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Huhsitnaak ce koeh ypna nawh quk ik-oeih awh awm koeh oek qu; na boeinaak hang taai hqui seiawm, cawh ce nak kawlung koeh ta. ");
INSERT INTO hltthb_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Khawsa ing awi pynoet doeng kqawn nawh, ik-oeih pak khih doeng ni kang zaak; cetaw Aw Khawsa, nang taw nak tha awm hy tice, ");
INSERT INTO hltthb_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Cawh Aw Bawipa, nang taw lungnaak na awm bai hyk ti. Nang ing thlang boeih a mimah a sainaak boeih amyihna laksawng pe qip kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Aw Khawsa, nang taw ka Khawsa na na awm dawngawh nang ce ni sui khak nyng; tui a khanaak qamkoh khuiawh, ka hqingnaak ing tui na ni ngaih nawh, ka pum ing na myi kyng na hy. ");
INSERT INTO hltthb_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Hun cim awh nang ce ni hu hawh nyng saw nak thaawmnaak ingkaw na boeimangnaak ce toek nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Na lungnaak ce hqingnaak anglakawh awm a leek khqoet a dawngawh, ka hui ing nang ce nim kyihcah kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Ka hqing khuiawh nang ce nim kyihcah kawng nyng saw, nang ming awh ka kut ve phyl kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Buh ak tui soeih ka phyi amyihna ka hqingnaak ing ak phoen phyi kawmsaw; ka hui ing laa sak doena kam kha ing nang nim kyihcah kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Ka ihkhun awhkawng nang ce ni sim loet kawng nyng saw; than zung namah ce ning ngai kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Nang taw ka hulkung na na awm dawngawh, nang hla hlip awh namah kyihcah doena laa sa kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Ka hqingnaak ing namah awh hawi nawh; namah ing nak tangkut ing nim tu hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Kai him aham ak caikhqi ce plawci bit kawm uh; dek a dungnaak khuina nu kun bit kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Zawzi ce zawk kawm usaw kqawng ui a buh na coeng bit kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Cehlai, sangpahrang taw Khawsa awh zeel kaw; Khawsa ang ming phuk doena awi ak kamkhqi ing anih ce kyihcah kawm uh, Cehlai qaai awi ak kqawnkhqi am kha taw sit kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Aw Khawsa, kang ngaih kyinaak awi ka sa awh ve, ngai law lah; kqih awm qaal anglakawhkawng ka hqingnaak ve hlip chung lah. ");
INSERT INTO hltthb_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Thlakchekhqi a tengnaak awhkawng ni thuh nawhtaw, khawboek chekhqi awipungkhqi ven awhkawng ni thuh lah. ");
INSERT INTO hltthb_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Amim laikhqi ce zawzi amyihna taak pat la unawh, ak chy ak ngan la amyihna amik awi ing thlang hyt uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Ak awm dym thlang ce mah unawh kaap uhy, kqihnaak taak kaana, anih ce kaap zap uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Ak che ik-oeih poeknaak awh tha pe qu unawh, ang hypna ami dun thang akawng ce kqawn uhy; “U ing a huh tang kaw?” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Amak thym ik-oeih awh za qu unawh, “sai ham hly nik poek hloem lauh hy aa!” ti uhy. Thlanghqing ak kawlung ve qaai kqawn thai pai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Cehlai, cekkhqi ce Khawsa ing la ing kaap kaw; kawlkalh awh cekkhqi ce kaap hawh kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","A mimah am lai ha ce hawi pek khqi khup phlet kawmsaw plawci sak khqi kaw; ak hukhqi boeih ing thekhanaak ing a lu thlek sih kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Thlanghqing boeih ing kqih hawh kawm uh; Khawsa bibi ce kqawn kawm usaw a ik-oeih sai ce poek kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Thlakdyng ingtaw Khawsa awh zeel seitaw amah awh ce thuk seh; kawlung ak dyngkhqi boeih ing amah kyihcah seh! ");
INSERT INTO hltthb_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Aw Khawsa, Zion awh kyihcahnaak ing nang ce ni qeh hy; nang a venawh kaimih ak awi taaknaak ce soep kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Aw nang cykcahnaak awi ak za venawh, thlangkhqi boeih law kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Thawlhnaak ing kaimih a ni sing khqi khoep awh, kaimih a ik-oeih sai thawlhnaak awh qeenkhaw ngai hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Na vawngup khuiawh ak zoena awm aham ak tykkhqi taw a zoseen hy! Na im awhkaw, na bawkim ciim awhkaw ik-oeih leekkhqi ing be unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Nang ing dyngnaak kqih awm ik-oeih sai ing kaimih nim hlat hyk ti. Aw Khawsa kaimih hulkung, Khawmdek a dytnaak boeih awhkaw ngaih-unaak ingkaw ak hla soeih tuicunli awhkaw ngaih-unaak; ");
INSERT INTO hltthb_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Nak thaawmnaak ing mawlkhqi ak saikung, namah ingkaw namah ce tha awmnaak ing thoeih ang cam qu hyk ti, ");
INSERT INTO hltthb_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Tuicunnli awhkaw tuiphu ingkaw tuilet thawh ak awi ak sit sakkung, pilnam thlangkhqi ak khy am kqangnaak awi ak sit sakkung na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Ak hla na ak awm thlangkhqi ing nak kawpoek kyi ik-oeih sai ce kqih uhy; mymcang khawkdai ingkaw khawmy ben khawtlak awh nang ing zeelnaak laa sak sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Khawk kqawng ve qeet a kawt na nawh tui ing syp hyk ti; khawzah papa na pung a tai sak hyk ti. Khawsa a lawngca lawngnukhqi awm thlanghqing a ai kawi, am ci ak ui awm sak hamna nang ing tui ing be sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Dek nawk a qytnaak ngaw boeih ce tui bym pe sak nawh; Khawk-aa ing na syp coengawh tawi a an leek sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Kum ce thai taknaak ing myk nawh na phyihnaak vawh awm be ngen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Qamkoh awm qam no saihim sak nawh; tlangkhqi ce awmhly zeelnaak ing sing hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Khawkpawi ce tuu kqeng ing sing khoep tiksaw lawng khui cengkhqi ce kym a cang ing khuk hyk ti; cekkhqi ing zeelmang laa sak ing khy uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Dek lunglai boeih aw, zeel doena Khawsa venawh khy lah uh! ");
INSERT INTO hltthb_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Ang ming boeimangnaak laa ce sa unawh taw; boeimang soeih na kyihcah lah uh! ");
INSERT INTO hltthb_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Khawsa venawh, “Na ik-oeih saikhqi ve myi kqih tamzim hawh ni! Nak tha awmnaak ve a bau aih dawngawh na qaalkhqi awm na haiawh tum qu hqoeng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Dek lunglai boeih na haiawh koep doena; na kyihcahnaak laa sa uhy, namah ang ming kyihcahnaak laa sa uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Khawsa a ik-oeih sai ve law nawhtaw toek lah uh, thlanghqing anglakawh a ik-oeih sai ve myikqih tamzin hawh ni! ");
INSERT INTO hltthb_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Tuicunli ce khawk kqawng na coeng sak nawh, a khaw ing tui awh cet poe uhy – law lah uh amah awh zeel lah u sih. ");
INSERT INTO hltthb_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Kumqui dy ak thaawmnaak ing uk nawh, amik ing pilnam thlang boeih khoem hy – ak oelh khqi taw koeh tho qoe voel u sih. ");
INSERT INTO hltthb_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Aw thlangkhqi aw, ningnih a Khawsa ve kyihcah lah uh, a kyihcahnaak awi ve zaak na awm lah seh; ");
INSERT INTO hltthb_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Ningmih a hqingnaak ve khoem nawh ni khawkhqi awm am bah sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Aw Khawsa, kaimih ve ni nym ni nai khqi hawh tiksaw; tangkamyihna atui na ni hloei hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Thawngim khuina nik thla nawh phyihqih ce kamim ting awh ni phyih sak khqi hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Ka lu awh thlang ngawih law sak nawh; mai ingkaw tui awh ni ceh sak hyk ti, Cehlai khawbuh qam sainaak hun na ni ceh pyi hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Hyih phum nawnnaak ing na bawkim na law nyng saw, na venawh awi ka kam ce soep sak kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Kyinaak ka huh awh ka hui ing awi a kam amyihna kam kha ing awikam caksak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Ak plan ak tha tuu ing bulnaak lucik nawn law kawng nyng saw; vaitawm cai ingkaw mem cai ce nawn kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Nangmih Khawsa ak kqihkhqi boeih aw, law unawh taw ngai lah uh; kai aham ik-oeih a sai law ce kqawn law lah vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Kam kha ing anih a venawh khy nyng saw: kam lai awh amah kyihcahnaak ce awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Kak kawlung khuiawh thlawlhnaak ka taak khak mantaw, Bawipa ing kak awi am ngai tikaw; ");
INSERT INTO hltthb_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Cehlai, Khawsa ing kak awi ngai law nawh kak cykcahnaak awi ce za hy. ");
INSERT INTO hltthb_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Kak cykcahnaak amak zyng sak nawh kai aham a lungnaak amak hai, khawsa venawh thangleeknaak awm seh nyng! ");
INSERT INTO hltthb_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Khawsa ing nim qeen seitaw zoseennaak ni pe seh nyng, a haai ce ningnih ak khan awh vang sak seh nyng, ");
INSERT INTO hltthb_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Na lamkhqi ce khawmdek awh sim na awm seitaw, na hulnaak ce pilnam thlang ing sim seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Aw Khawsa, thlangkhqi ing nang ce nim kyihcah u seh nyng; thlang boeih ing nang ce nim kyihcah u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Pilnamkhqi ak thym na uk tiksaw, khawmdek awhkaw thlangkhqi ce sawi hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Aw Khawsa, thlangkhqi ing nang nim kyihcah u seitaw; thlang boeih ing nang ce nim kyihcah u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Cawhtaw khawmdek ing ak thaih thawt sak kawmsaw, Khawsa, ningnih a Khawsa ing zoseennaak ni pe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Khawsa ing ningnih ce zoseennaak ni pe kawmsaw, khawmdek a dytnaak awh ak awm thlangkhqi boeih ing anih ce kqih hawh kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Khawsa tho seitaw, a qaalkhqi ce a tik a zak na awm sak seitaw; Khawsa ak sawhnaakkhqi ce a ven awhkawng cen u seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Maikhu zilh ing a zawn bang amyihna, nang ing cekkhqi ce zawn bang lah; mai awh khawi-ut a tle amyihna, thlakchekhqi taw Khawsa haiawh plawci u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Cehlai, thlakdyngkhqi taw Khawsa haiawh zeel u seh; amik kaw awm hqa seitaw zeel u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Khawsa venawh laa sa lah uh, ang ming kyihcahnaak laa sa lah uh, myi khan awh ak ngawi ce zoeksang uh - anih ang ming taw Bawipa ni – a haiawh zeel lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Pa amak takhqi aham pa na awm nawh, nuhaikhqi ak dyih pyikung na awm hy, Khawsa taw a awmnaak hun ciim awh awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Amah doengca ak awmkhqi ce cakaw ak kqeng na coeng sak hy, thawng ak tlakhqi ce laa sak doena ceh pyi hy; Cehlai, ak oelh ak taih ak thlangkhqi taw khawk hlawk ing a engnaak qam awh awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Aw Khawsa nak thlangkhqi haiawh na ceh awh, qam qamkoh awh nang ing na ceh pyi phaat awh, ");
INSERT INTO hltthb_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","khan nakawng khaw ce aa hy, Khawsa haiawh, Sinai tlang awhkaw ce, Khawsa, Israelkhqi Khawsa haiawh kawmdek tyn hy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Aw Khawsa, nang ing khaw khawzah aa sak hyk ti; nang ing ak hoet na qo ak pangkhqi ce caih sak pang hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Nak thlangkhqi ing ce ak khuiawh awm unawh, Aw Khawsa, na khawhthem khawzah ak khui awhkawng khawdengkhqi hqin hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Bawipa ing awi sa nawh, ce ak awi ak khypyi thlangkhqi ce kqeng soeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Sangpahrangkhqi ingkaw qalkapkhqi ce ang tawnna cen uhy; qeh-im khui awhkaw thlangkhqi ing qaalkhqi khawhthem ce qek qu uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Nang ing qeh-im kawt hai a venawh na ih awh ce, kai a kqukkqu ang hlakhqi ce ngun ing zawl nawh, ang hlakhqi ce sui na phla hlap hlap hy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Boeimang thak awm ing sangpahrangkhqi ce qam khuiawh a thek a zaak awh ce, Zalmon awh qawhnu ak tlamyihna awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Basham tlangkhqi taw qypawm tlangkhqi na awm nawh; lunkqawng ingkaw hqeng ang hqah hqoeng na Bashan tlang taw awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Aw lunkqawng hqoeng na ak awm tlangkhqi, uknaak aham Khawsa ing ak tyh tlang, kumqui dyna Bawipa a awmnaak hly kawi tlang ce kawtih tlai seet doena nami toek uh? ");
INSERT INTO hltthb_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Khawsa a qaal tuknaak rangleng taw thong thongoet ingkaw thong zakhat dyna doem hy; Bawipa taw Sinai awhkawng amah a hun ciim na law hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Hun sang na na hang kai awh ce, khawh na ak awm tamnaakhqi ce hak khyn nawh; thlangkhqi ven awhkawng laksawng ce do hyk ti, ak oelhkhqi ven awhkawng zani – Aw Bawipa Khawsa, nang taw cawh ce awmnaak thai aham ni. ");
INSERT INTO hltthb_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Khawsa ningnih a hulkung, ningnih a phyihqih ak phyi loet Bawipa venawh thangleeknaak awm seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Ningmih a Khawsa taw anik hulkung Khawsa na awm hy; Rypawm Khawsa ven awhkawng thihnaak awhkawng loetnaak ce law hy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Khawsa ing a qaalkhqi a lukhqi, thawlhnaak a nawn kaana a saikhqi tloek a lu ce neet pe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Bawipa ing, “Bashan awhkawng a mingmih ce law pyi kawng nyng saw; tuncunli dung awhkawng a mingmih ce law pyi kawng, ");
INSERT INTO hltthb_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Na qaalkhqi thi ce na khaw ing leh kawm tiksaw, na uikhqi ingawm leek pe kawm uh,” tinawh Bawipa ing kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Aw Khawsa, a ciimnaak hun na a law ingkaw ka Khawsa ka Sangpahrang a law ce hu hawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Haiben na laa ak sakhqi ce cet unawh, cekkhqi hu awh tingtoeng ak tumkhqi cet uhy; cekkhqi anglak li awh nulaakhqi ing poeng ak beei ce bei uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Thlangkqeng ang cunnaak awh Khawsa ce kyihcah lah uh; Israelkhqi ang cunnaak awh Khawsa ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Benjamin phun vezit ca ing cekkhqi ce sawi nawh, Judah sangpahrangkhqi, Zebulun ingkaw Nephtali sangpahrangkhqi ing hquut uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Aw Khawsa, nak thaawmnaak ce khy lah; Aw Bawipa ak kqym awh na sai amyihna, nak thaawmnaak ce nim huh khqi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Jerusalem awh na bawkim a awm dawngawh sangpahrangkhqi ing laksawng hawlaw kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Paipoeng a ding awhkaw qam saktlung ce toel nawhtaw, pilnam anglakawhkaw vaitawkhqi anglakawhkaw vaitawmcai ce phep lah. Ak kai na ta lah, ngun awm hawlaw na lah u seh. Qaal tuk ak ngaih soeih qaalkhqi ce thek a zak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Izip qam nakawng dyihthingkhqi law kawm uh; Kush ing amah ingkaw amah Khawsa venawh pe qu kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Khawmdek awhkaw qamkhqi aw, Khawsa venawh laa sa unawh, Bawipa kyihcahnaak laa sa lah uh, ");
INSERT INTO hltthb_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Syn awhkaw khan khawnghi poeng awh ak ngawi a venawh, khawhum qawdeh laa awi ak sakung a venawh kyihcahnaak laa sa lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","A qypawmnaak Isreal khqik khan awh ak awm, khan khawnghi awh thaawmnaak ak ta, Khawsa ak thaawmnaak ce khypyi lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Aw Khawsa, na hun ciim awh nang taw kqih awm na awm hyk ti: Israel Khawsa ing thaawmnaak ingkaw sai thainaak ce ak thlangkhqi venawh pehy. Khawsa venawh thangleeknaak awm seh nyng! ");
INSERT INTO hltthb_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Aw Khawsa, ni hul lah, tui ing ka hawng dy pha law hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Khaw lehnaak coet amak awm dizui ak khuina tla hawh nyng. Tuidung na nung tla nyng saw; tui ing ni zawl malh hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Bawmnaak thoeh doena kak khy aih awh; kak awiqawng koh hawh hy. Khawsa ka toeknaak awh kamik awm am dang voel hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Kaw am maiawh, kai anik sawhnaak thlangkhqi ve ka lu awhkaw lusam anglakawh doem khqoet uhy; amak awm qoe ikaw am maiawh kai hqe aham anik sui ka qaalkhqi kqeng soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Aw Khawsa, ka qawnaak ve nang ing sim hyk ti, ka sai thawlhnaak ve na hai awhkawng thuh thai na am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Aw Bawipa, Boeimang Bawipa, nang awh ngaih-unaak ak ta thlangkhqi ce kai awh kawboetnaak koeh ta u seh; Aw Israelkhqi a Khawsa, nang anik suikhqi ce kai awh chahqai koeh hu u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Ikawtih, nang awh ce kqawn setnaak kung na nawh chahnaak ing ka haai ni dah khoep hy. ");
INSERT INTO hltthb_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Ka koeinakhqi venawh khin na awm nyng saw, ka nucakhqi venawh thlak ha na awm nyng; ");
INSERT INTO hltthb_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Na im awh kak tha thawhnaak ing ni ai zip nawh, nang anik kqawnsetkhqi ak kqawn setnaak ce kak khan awh tla hy. ");
INSERT INTO hltthb_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Buh zeih ing kqang doena kak cykcah awhtaw, kqawn setnaak ce yh thai bit kawng nyng; ");
INSERT INTO hltthb_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Dip che kang byng awh ce, thlangkhqi ing lym hangnaak na ni sai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Vawng chawmkeng awhkaw ak ngawikhqi ing ni qaih na unawh, zuk quikhqi a qenglung taila na awm kqoeng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Nang nak kaw a zeel tym awh, Aw Bawipa, na venawh cykcah law nyng; Aw Khawsa, cawh ce na lungnaak awh, na hulnaak tak ing nim hlat lah. ");
INSERT INTO hltthb_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Nawng khui awhkawng ni hul nawhtaw, koeh ning cum sak; kai anik sawhnaakkhqi kut khui awhkawng ni hul nawhtaw tui dung khui awhkawng ni thaawng lah. ");
INSERT INTO hltthb_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Tui doem ing koeh ni sing seitaw tui dung ingawm koeh nik daih seh. Lawk-kqawng ingawm am kha koeh ni khyp sih seh. ");
INSERT INTO hltthb_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Aw Bawipa, na lungnaak leeknaak ing nim hlat lah; nam qeennaak bau soeih ak caming kai benna hawi qu law cang lah. ");
INSERT INTO hltthb_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Na tyihzawih a ven awhkawng na haai ce koeh thuh nawhtaw; kyinaak hu vik hawh nyng, nang ing ang tawnna nim hlat lah. ");
INSERT INTO hltthb_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Ka venawh zoe law nawh ni hul lah; ka qaalkhqi awhkawng nang ing ni thaawng lah. ");
INSERT INTO hltthb_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Kawamyihna nik kqawn seet unawh, kaw boetnaak ingkaw chahqai na ni ta uhy tice nang ing sim hyk ti; ka qaalkhqi boeih ve na haiawh ni ami awm. ");
INSERT INTO hltthb_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","kqawn setnaak ing kak kawlung kqek sak unawh hulkung ak taal na ni ta hyt uhy; hlang qeenkhaw ak ngai sui moe nyng, u awm am hu nyng saw, ak hloepkung sui moe nyng, u awm am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Ka buh awh a hyt kha ni taak law pe unawh ka tui ngaih a sitnaak na misur tui ak thui ni pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","A mingmih a haiawh caboei dawn peek na ak awm ce thang na dun pe u sei taw; Khawboe set phu zawk naak ing pel na phawk pe u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Ami mikkhqi a mang dangnaak aham hyp pesak khqi seitaw, amim tingkhqi awm khun pek khqi loet seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Cek khqik khan awh nak kawsonaak ce hawk pe lah; nak kawsonaak ak eih ing cekkhqi ce kee seh. ");
INSERT INTO hltthb_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","A mingmih a awmnaak ce pawng seitaw; cekkhqi a im awhkaw a u awm koeh awm voel seh. ");
INSERT INTO hltthb_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Ikawtih, nang ing ngawha na ai sak thlangkhqi ce the a kha na unawh nang ing tlawh na peek thlangkhqi kawng ce kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","A sai thawlhnaak ce sai thawlhnaak ing sap pe lah; nang a hulnaak ce koeh huh sak. ");
INSERT INTO hltthb_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Hqingnaak cauk awhkawng cekkhqi ce caih sak bang nawh thlakdyngkhqi mi koeh noet sih haih. ");
INSERT INTO hltthb_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Thawlhnaak ing khuikha hawh nyng; Aw Khawsa, na hulnaak ing nik chung seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Laa ing Khawsa ang ming ce kyihcah nyng saw zeelnaak awi kqawnnaak ing zoeksang kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Vaitawm cai anglakawh Bawipa zeel sak khqoet kawmsaw, ki ingkaw khawme ak ta vaitawm cai anglakawh Bawipa zeel sak khqoet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Khawdengkhqi ing hu kawm usaw zeel kawm uh. Nangmih Khawsa ak suikhqi, namik kawlung hqing seh! ");
INSERT INTO hltthb_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Bawipa ing ak voethlauh thlangkhqik awi ce zaak pek khqi nawh tamnaa na ak awm thlangkhqi awm am hep hy. ");
INSERT INTO hltthb_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Khan ingkaw dek ing amah kyihcah seitaw, tuicunli ingkaw ak khui awhkaw ak cawlhtat khqi boeih ingawm, ");
INSERT INTO hltthb_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Ikawtih, Khawsa ing Zion ce hul kawmsaw Judah khawk baukhqi ce thawh tlaih kaw. Cawhtaw thlangkhqi ce ak khuiawh awm kawm usaw pang pahoei kawm uh; ");
INSERT INTO hltthb_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","A tyihzawihkhqi a cadilkhqi ing pang kawm usaw, ang ming ak lungnaak thlangkhqi ce a khawk khuiawh awm hawh kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Aw Khawsa, kai hul aham nang hqi tawn sak lah; Aw Bawipa kai hul aham ang tawnna law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Kai him aham anik tengkhqi ce chahqai phyi u seitaw ngai hangtum na awm u seh nyng; kai plawci sak aham ak ngaihkhqi boeih kawboet doena awm u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Ka venawh, Aha! Ak tikhqi ce chah doena hlat tlaih u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Cehlai nang anik sui thlangkhqi taw zeel u seitaw zoeksang na awm seh nyng!” ti u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Cehlai, kai taw khawdeng ingkaw ak voethlauh thlang na awm nyng; Aw Khawsa, ka venawh ang tawnna law lah. Nang taw kai anik hulkung ingkaw kai anik hulkung na awm hyk ti; Aw Bawipa, koeh di lah. ");
INSERT INTO hltthb_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Aw Bawipa, nang awh ni kang thuk; ityk awh awm chah qai koeh ni huh sak. ");
INSERT INTO hltthb_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Na dyngnaak ing ni boem nawhtaw ni hul lah; kai benna nang haa hawi law nawhtaw ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Ka cehnaak loet aham kang thuknaak lungnu na awm nawh; kai hul aham awi pe lah, kawtih nang taw ka lungnu ingkaw kang thuknaak na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","AW ka Khawsa, thlak thawlhkhqi kut khui awhkawng ni hul lah, thlak chekhqi ingkaw thlak tlung am tunaak awhkawng ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Aw Boeimang Bawipa, nang taw kang ngaih-unaak kung na awm hyk ti, ka tawng plang awhkawng ka ypnaak na awm hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Ka thang plek ca awhkawng ni nang awh kang hang qu hawh hy; nang ing ka nu puk khui awhkawng nik dawk hyk ti. Nang ve ang loet na nim kyihcah vang. ");
INSERT INTO hltthb_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Thlang khawzah ang ngaihkyi naak na awm nyng. Cehlai, nang taw kang thuknaak na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Kam kha ve nang kyihcahnaak ing be nawh, khawnghi zung na boeimangnaak ce kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Ka pacawng awh ce nang ing koeh ni qoek sut; kak tha a boeih awh ce koeh ni qoeng sut. ");
INSERT INTO hltthb_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Ikawtih, ka qaalkhqi ing kai ama ni ngaihnaak awi kqawn unawh; kai him aham anik qehkhqi mi kut oet na hqui qu uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Cekkhqi ing, Khawsa ing qoek hawh hy; hquut u nawhtaw tu uh, u ingawm am hul tang ti kaw,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Aw Khawsa, ak hla na koeh ni awmtaak: Aw ka Khawsa, kai hul aham ang tawnna law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Kai thawlh anik pukkhqi ce chahqai phyi u seitaw, kai a thawlh peek aham ak ngaihkhqi ce kqawn setnaak ingkaw kaw boetnaak ing sing khqi khoep seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Cehlai, kai ingtaw ngaih-unaak ta loet nyng; nang ce nim kyihcah khqoet khqoet kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Kam kha ing nang a dyngnaak ce kqawn kawmsaw, a nyhtahnaak am sim hqawh bai nyng seiawm, na hulnaak ce myngawi na kqawn kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Aw Boeimang Khawsa, law nyng saw nang ak thaawm ik-oeih saikhqi ce khypyi kawng nyng; nang a koe, nang doeng a dyngnaak ce kqawn kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Aw Khawsa, ka tawng plang awhkawng nang ing ni cawngpyi tiksaw, tuhngawi dy awh nang a kawpoek kyi ik-oeih saikhqi ce kqawn nyng, ");
INSERT INTO hltthb_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Hang pacawng nawh ka lusam kqawk hawh seiawm, Aw Khawsa, nak thaawmnaak ce ak law hly cadilkhqi ingkaw ak law hly thlangkhqi venawh kak kqawn hlan dy, nang ing koeh ni qoek sut. ");
INSERT INTO hltthb_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Aw Khawsa, ik-oeih bau soeih ak saikung, na dyngnaak ing khawnghi hak pha hy, nang amyihna u nu ak awm bai? ");
INSERT INTO hltthb_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Kyinaak khawzah papa ingkaw ak kha soeih khawzah na ni huh sak hawh hlai hyk ti, ka hqingnaak ve ni pe tlaih kawp ti, dek a dungnaak a hun awhkawng ni hak dawk tlaih kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Ka thangleeknaak pung law sak kawm tiksaw ni ngaih ding law sak tlaih bai kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Aw ka Khawsa, na ypawmnaak awh nang ce tingtoeng ing nim kyihcah kawng nyng saw; Aw Israel a thlak ciim, qaw tingtoeng tum doena nang kyihcahnaak laa ce sa vang. ");
INSERT INTO hltthb_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Nang kyihcahnaak laa ka sak awh ce ka hui ve zeel doena khy kaw. Kai ve nang ing ni, nani hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Kam lai ing nang a ik-oeih sai ak dyng ce khawnghi zung kqawn kaw, kawtih kai tlawh peek aham ak ngaihkhqi ce chahqai phyi unawh ngaihang tumna awm hawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Aw Khawsa, sangpahrang ve na thymnaak ing sing nawhtaw, sangpahrang capa ce na dyngnaak ing dah lah. ");
INSERT INTO hltthb_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Anih ing nak thlangkhqi ce dyngnaak ing awi deng kawmsaw, nang a khawdeng thlangkhqi ce ak thym na awi deng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Tlangkhqi ing nak thlangkhqi venawh kam awmnaak hawlaw pe kawm usaw, khawmcungkhqi ing dyngnaak thaih ce hawlaw pe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Thlangkhqi anglakawhkawng khawdengkhqi ce hul khqi kawmsaw ak voethlauh a cakhqi ce hul kaw; thlang ak thekhanaak khqi ve ak kai na neet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Khawmik ingkaw pihla a awm khui, cadil dy ing nang ce nik kqih kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Taitin ami vawk ak khan awh khaw ak aa amyihna anih taw awm kawmsaw, dek ak syp khawk aa amyihna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Anih a awm khui taw thlakdyngkhqi ami zo awm kawmsaw; pihla ama awm am ka dy taw khaw buh qam sai hawh kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Anih ing caqai ben tuicunli awhkawng vang a caqai ben tuicunli dy lawngtui awhkawng khawmdek a dytnaak dyna uk kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Qamkoh awhkaw thlangkhqi ing koep kawm usaw a qaalkhqi ing dekvai ce leek kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Tarshish ingkaw khawk hla tuikeng awhkaw sangpahrangkhqi ing ik-oeih hawlaw pe kawm uh; Sheba ingkaw Seba sangpahrang qawi ing kutdokhqi pe law kawm nih. ");
INSERT INTO hltthb_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Sangpahrang boeih ing a haiawh koep kawm usaw pilnam ing bibi pe kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Ak voethlauh ak kqangkhqi, khawdeng hulkung amak ta thlangkhqi ce hul kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Tha amak takhqi ingkaw ak voethlauhkhqi ce qeen kawmsaw a voethlauhkhqi ce thihnaak awhkawng hul kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Anih ing cekkhqi ce thekhanaak ingkaw hepnaak awhkawng thaawng kaw, kawtih amik huh awh cekkhqi a thi ce a phu tlo hy. ");
INSERT INTO hltthb_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","A hqinglu sang seh! Shehba a sui ce anih a venawh pe u seh. Thlangkhqi ing cykcah pe loet u seitaw a poepa na zoseennaak pe u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Qam khuiawh khaw buh qam sai seitaw, mawl ingkaw tlang boeih ce cangvui hqoeng na awm seh. Lebanon amyihna ak thaih qah seitaw; zawi khaw awhkaw taitin amyihna tai u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Ang ming ve kumqui dyna awm poepa seitaw; khawmik a awm khuiawh awm loet seh nyng. Pilnam thlang ing anih ak caming zoseennaak hu kawm usaw, kam ak awm tloek tinawh khy kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Israel Khawsa, Bawipa Khawsa venawh thangleeknaak awm seh nyng, anih doeng ing kawpoek kyi ik-oeih sai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","A boeimangnaak kumqui dyna thangleeknaak awm seh nyng; Khawmdek boeih ve a boeimangnaak ing be seh nyng. Amen coengawh Amen. ");
INSERT INTO hltthb_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Jessea capa David ak cykcahnaak taw vawh dyt hy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Kawlung ak ciim, Israelkhqi venawh Khawsa taw leek tak tak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Cehlai, kai aham taw, ka khaw ve bah tawm ca nawh; dyih hun hlauh tawm na awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Ikawtih, thlak chekhqi ami kam ak awm ce ka huh awh ak oek qukhqi ce nai haunyng. ");
INSERT INTO hltthb_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Ami thih awh ce khuikha am sim voel hy; ami pumqawkhqi ami sa dip pyng pyng nawh amik tha awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Thlak changkhqi amyihna phyihqih am za tlaih uhy; thlanghqing tlawhnaak ing am khuikha sak khqi tlaih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Cedawngawh oek qunaak ce aawi na awi unawh; khawboe seetnaak ing thoeih ang cam qu uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Thin hqamnaak awhkawng thawlhnaak ce law hy; qaai kqawnnaak kawpoek ing a qi am ta qoe hy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Kawpoek seetnaak ing thlang qaih na unawh; oek qunaak ing thang the a kha na uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Amim khakhqi ce khanna ak awm na ngai unawh, amim laikhqi ing khawmdek ik-oeih ce lo uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Cedawngawh ak thlangkhqi ing a mimah a venna hlai unawh tui hqawng ce aw thu hqut uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Cekkhqi ing, Ikawmyihna Khawsa ing ani sim naak kaw? Sawsang Soeih awh ak awm ce ak cyi hy voei nu?” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Thalk chekhqi taw vemyihna awm uhy – ikawmyih poeknaak awm am ta voel uhy, a boeina boei khqoet khqoet uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Kawlung ak caihna ka taak ve a hoeina awm nawh kut sil nyng ka awm dym awm a hoeina awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Khawnghi zung khuikha za nyng saw; mymcang qoek awh phepnaak hu nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Kai ing, Cemyih na sai u vang,” ka ti mantaw, na cakhqi ana zawi hawh kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Vemyihkhqi boeih ve zaaksim aham tha ka lawh awh, ka ham quh soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Khawsa a hun ciim ka pha deng awh ni, a dytnaak ce kang zaksim hly hyn. ");
INSERT INTO hltthb_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","A plainaak a hun awh cekkhqi ce nang ing ta tiksaw; plawci aham cekkhqi ce nuk khawng hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Ikawmyihna cekkhqi ce ami plawci bat paqap, kqih awmnaak ing cekkhqi ce nawi phang tlang pai hy! ");
INSERT INTO hltthb_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Thlang ing a hang hqyng awh ang mang kawna awm a mang ngaih amyihna, Aw Bawipa, nang awm na hang thawh awh, cekkhqi poeknaak mailai amyihna nang ing kawna awm am ngai kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Kak kawlung ko nawh kang myihla ak khuikha awh, ");
INSERT INTO hltthb_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","kaw awm a sim kaana a khat qat na awm hqoeng nyng; na haiawh qamsa myihna awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Cehlai, nang a venawh awm loet nyng; nang ing ka kut kak tang benawh nim tu hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Nak poek na lahnaak ing ni sawi kawm tiksaw, cek coeng awhtaw boeimangnaak khuiawh ni ceh pyi kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Nang kaa taw a u nu khawk khan awh ka taak bai kaw? Nang coeng awhtaw ka ngaih ve khawmdek ing am tahy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Ka pumsa ingkaw kak kawlung ve tlu mai seiawm, Khawsa taw kak kawlung thaawmnaak ingkaw ka kumqui taham na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Nang a ven awhkawng ak hlakhqi boeih ce qeeng kawm usaw; na venawh ypawm na amak awm thlangkhqi ce nang ing hqe kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Cehlai, kai aham taw, Khawsa ing ak zoena awm ve nep hy. Boeimang Khawsa ce kang thuknaak hun na ta hawh nyng; na ik-oeih saikhqi boeih ce khypyi kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Aw Khawsa, kawtih kumqui dyna nani qoek khqi? Ikawtih na qamno a sainaak awhkaw tuukhqik khan awh nak kaw a so aih. ");
INSERT INTO hltthb_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Ak kqym awhkaw thlang nak thlaihkhqi, namah ing tlan hyk ti, nang a qo ak pang thlangkhqi na awmnaak Zion tlang ce poek cang lah thoeih ti. ");
INSERT INTO hltthb_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Vawhkaw kumqui dy ak plawcikhqi, na hun ciim awh na qaalkhqi ing a hawlaw vawhkaw seetnaak boeih benna nak kaw hawi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Nang ing kaimih na ning hqumnaak hun awh na qaalkhqi ing khy am kqang unawh; a mimah ang dyih hun simhatnaak ce ling uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Kqawng thing ak ding khyng ce hqaica ing a hlam sih amyihna awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Kut ing ami suk biit biit ik-oeihkhqi boeih hqaica ing deh pheng uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Na hun ciim ce dawi unawh tluk sak uhy; Nang ming a awmnaak hun ce tyih awm sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Ak kawk khuiawh, “A cuna nawi hoem u sih!” ti uhy. Qam khui awhkaw Khawsa bawknaak imkhqi boeih ce dawi uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Kawpoek kyi hatnaak kaimih a venawh ikawmyih awm am awm hy; tawnghakhqi awm am awm voel hawh nawh, handy nu vemyihna a awm khing kaw tice u ingawm am sim hy. ");
INSERT INTO hltthb_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Aw Khawsa, handy awh nu na qaalkhqi ing anik kqawn set kaw? anik qaalnaak ing nang ming ce kqawn seet hly let hawh unawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Ikawtih nak tang kut ben ce nak dawh tlaih? Na hibai ak khui awhkawng na kut ce soeng nawhtaw cekkhqi ce him hlah. ");
INSERT INTO hltthb_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Cehlai, Aw Khawsa nang taw ak kqym awhkawng kai a sangpahrang na awm hyk ti; nang ing khawmdek awh hulnaak hawlaw hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Nang ing ni tuicunli ce nak thaawmnaak ing pek a bo nawh, tui khuiawh ak awm qaihkhqui a lukhqi ce kqek pe sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Nang ing ni Leviathan a lukhqi ve vyk pe kqek kqek nawh qamkoh awhkaw qamsa ham buh na be hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Nang ing ni tui bym ingkaw lawngca tuikhqi phyt sak nawh; lawngnu tuipakhqi awm kak sak qup qup hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Khawkdai ve nang a koena awm nawh, khawmthan awm nang a koe ni; nang ing khawmik ingkaw pihla ce sai hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Nang ing ni khawmdek awhkaw a qi a mawngkhqi boeih na syn hy; khawhqai ingkaw chikca awm sai hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Aw Bawipa, na qaal ing ikawmyihna ani thenaak tice sim loet lah, thlakqawkhqi ing nang ming ami seet ami bat ce. ");
INSERT INTO hltthb_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Na kqukkqu a hqingnaak ce qam sak tlungkhqi venawh koeh pe; namah a khawdeng khuikha thlangkhqi a hqingnaak kumqui dyna koeh hilh. ");
INSERT INTO hltthb_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Na paipi ce sim lah, kawtih khawboe seetnaak ing qam khui awhkaw thannaak boeih ce sing hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Ak khuikha thlangkhqi ak kawboet ce sing hawh hy, khawdengkhqi ingkaw ak voethlauhkhqi ing nang ming ce kyihcah lah u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Aw Khawsa, hang dyi nawhtaw na ik-oeih sai ce hul lah; thlakqawkhqi ing a poepa na ani thenaak ce sim loet lah. ");
INSERT INTO hltthb_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Na qaalkhqi a tym awi ce ang ngai ngak kana koeh awm, a boet kana ak khy ak kqang na qaalkhqi ak awi ce. ");
INSERT INTO hltthb_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Aw Khawsa, na venawh zeelnaak awi kqawn unyng, nang ming a zoe dawngawh, zeelnaak awi kqawn unyng; thlangkhqi ing nak kawpoek kyi ik-oeih sai ce kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Nang ing, A tym ka hoep ce tyk nyng saw; kai ing ni ak thym na awi ka deng. ");
INSERT INTO hltthb_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Khawmdek ingkaw thlang boeih aming thyn awh, tungkhqi ak cak na ak tu ce kai ni. ");
INSERT INTO hltthb_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Ak oek qu venawh, ‘Koeh oek qu voel,’ tina nyng saw, thlakche venawh, nak ki koeh thawh. ");
INSERT INTO hltthb_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Khan benna nak ki koeh thawh, na hawng zyng nawhtaw awi koeh kqawn,” ti hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Khawlaw ben nakawng ing aw khawtlak ben nakawng awh aw ce am awhtaw qamkoh nakawng ing aw u ingawm thalng pynoet am zoeksang thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Cehlai, Khawsa ing ni awi a deng: pynoet ce tlaak sak nawh pynoet ce zoeksang hy. ");
INSERT INTO hltthb_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Bawipa a kut awh misur tui ak hawm cawt cawt a bawk tui ing ak kqit ce awm hy; anih ing ce a boet ce nuk hawk hy, cawh khawmdek awhkaw thlakchekhqi boeih ing a dik a hawi mahna aw boeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Kai ingtaw ve ve kumqui dyna kqawn vang; Jacob Khawsa kyihcahnaak laa ce sa vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Thlakchekhqi ak ki ce hlyng pe kawng nyng saw, thlakdyngkhqi ak ki taw zoeksang pekawng. ");
INSERT INTO hltthb_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Judah qam awh Khawsa ce sim unawh; Israel qam awh ang ming bau soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Salem awh a hibai im ce awm nawh, Zion awh awmnaak hun ce awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Amah cawh lakhqi, phuhqa ingkaw zawzikhqi, qaal tuknaak liva sapangkhqi ce hqe pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Nang taw vangnaak ing na qym awm soeih hy, chukpha ing ak be tlang anglakawh na qyp awm khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Am thin ak awm thlangkhqi aming zaih awh muk nawh, ih a dytnaak ing ip poe uhy; qaal tuk tha ak awmkhqi pynoet ca ingawm a kut am phyl hqa uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Aw Jacob a Khawsa, nang ing na phep dawngawh meqang ingkaw meqang sen awm zaih hqoeng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Nang doeng ni kqih aham na awm. Nak kaw a so awh ce na haiawh a u nu ak dyi thai kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Khan nakawng awi dengnaak ce kqawn tiksaw, qam ing ak kqih aih awh awm dym hy. ");
INSERT INTO hltthb_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Aw Khawsa, awi deng aham na hang dyih awh ce, qam khui awhkaw khawdeng thlangkhqi hul aham cawh nang dyih awh. ");
INSERT INTO hltthb_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Thlanghqingkhqik khan awh nak kawsonaak ing nam kyihcahnaak ce hawlaw nawh, nak kawsonaak nak qoeng thoemkhqi ing thoeihcam qu hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Bawipa na Khawsa venawh awi na kam ce soepkep boeih ing kqih aham ak awm thlang a venawh laksawng ce khyn law pe u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Anih ing ukkungkhqi ang myihla hqe pehy; Khawmdek awhkaw sangpahrang khqi ing anih ce kqih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Khawsa venawh bawmnaak thoeh doena khy nyng saw; kak awi ngaih aham Khawsa ce khy nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Kak kawpoek a kyi awh, Bawipa ce sui nyng; khawmthan awh awm ka kut qawi ve thlak kana phyl loet nyng saw ka hqingnaak ing ngaihqep cana awm aham tha na hy. ");
INSERT INTO hltthb_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Aw Khawsa, nang ce ni sim khak nyng saw, kang ko; ka poek qu hqet awh ce, kang myihhla ak tha hoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Kamik ve ni tang sak khak tiksaw: awi ka pau kaw a ma lawnaak dyt awh kyi nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Ak kqymkqawkhqi poek a vat sam nyng saw, ni hu ben awhkaw kumkhqi ce ka poek vat sam lah awh; ");
INSERT INTO hltthb_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Khawmthan awhkaw laa ka sakkhqi ce poek hqoet nyng. Kak kawlung ing kak poek hqet awh ce kang myihla ing awi doet hy; ");
INSERT INTO hltthb_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","Bawipa ing kumqui dyna nik qeng hly nu? Kak khan awh ak kaw am law hly voel nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Amak dyt thai a lungnaak ce ang loet na qeng hly hawh nawh nu? Ak awikam awm plal hly poe hawh nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Khawsa ing qeennaak taak aham hilh hly hau hawh nawh hy voei nu? Ak kawsonaak ing a lungqeennaak ce byp hly pe khoep hawh nawh hy voei nu?” ti nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Cawhtaw, Vemyihna qeennaak thoeh kawng; Sawsang Soeih awh ak awm tangkut ben awhkaw kumkhqi ce,” tinawh poek nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Bawipa a ik-oeih saikhqi ce sim loet kawng nyng saw; oeih, ma nakaw kawpoek kyi ik-oeih na saikhqi ce sim loet vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Na bibinaak khqi ce poek nyng saw nak thaawm ik-oeih sai ce ak nep na poek kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Aw Khawsa, nang a lawnglamkhqi taw zawziih hy. Ningmih a Khawsamyihna ak awm ikawmyih khawsa nu a awm bai? ");
INSERT INTO hltthb_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Nang Khawsa ing ni kawpoek kyi ik-oeihkhqi na sai nawh; thlangkhqi venawh nak thaawmnaak ce ang dang sak. ");
INSERT INTO hltthb_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Nak thaawm ban ing nak thlangkhqi, Jacob ingkaw Joseph cadilkhqi ce hul hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Aw Khawsa, tuikhqi ing ni hu uhy, tuikhqi ing ni hu unawh chawi qu kawlh kawlh uhy; tuihdungkhqi awm thyn hqoeng uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Cingmaikhqi ing tui hawk unawh, khawnghi ing hum hy; na lakhqi ing huna haina phla hlap hlap hy. ");
INSERT INTO hltthb_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Khawhum awi ce khaw na phla nawh, khawkphla ing khawmdek ce vang sak hy; Khawmdek ing tyn nawh thyn hy. ");
INSERT INTO hltthb_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Na lam ce tuicunli dyna awm nawh, na khawleh am dang hlai hy, na cehnaak ce tuinu thingpa anglakawh awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Nang ing Mosi ingkaw Aaron a kut hawna nawh nak thlangkhqi ce tuu kqeng amyihna sawi hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Aw kak thlangkhqi aw, ka ni cawngpyinaak ve ngai lah uh; kam kha awhkaw awi ve ngai lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Nyhtahnaak ing kam kha awng kawng nyng saw, syn awhkaw ik-oeih, ang hyp ik-oeihkhqi ce kqawn law kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Ningmih ing ning za nawh ni huhkhqi ve, ni pakhqi ing amik kqawn law ce ni. ");
INSERT INTO hltthb_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","A cakhqi venawh am nik phah pe hlyk khqi hy, ak law hly kawi cadilkhqi venawh Bawipa am kyihcah hly kawi ik-oeih saikhqi, amah ak tha awmnaak, kawpoek kyi ik-oeih a saikhqi ce nik kqawn pe patoe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Jacob aham a hquut hly kawi awi ce pe nawh Israelkhqi anglakawh anaa awi ce caksak hy, cawhkaw anaa awi ce ningnih a pa venawh a cakhqi ami cawng sak patoe aham pehy, ");
INSERT INTO hltthb_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","ak law hly kawi cadil naasenkhqi ing, ak thang hly kawi naasenkhqi ingawm sim unawh, a cadilkhqi venawh ak kqawn pek patoe aham pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Cawhtaw Khawsa ce ypna kawm usaw a ik-oeih saikhqi ce am hilh voel ti kawm uh, ak awi peekkhqi ce hquut hawh kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Cekkhqi taw ami pahqamkhqi amyihna am awm kawm uh - kaw ak tiing ingkaw ak oelh taih, Khawsa venawh kawlung amak cak thlangkhqi ingkaw aming myihlakhqi awm a venawh ypawm na am awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Ephraim thlangkhqi ce, li pawm mai u seiawm, qaltuknaak nyn awhtaw a huna hlat tlaih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Khawsa a paipi ce am ha na unawh a anaa awi a peek amyihna awm am sai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Kawpoek kyi ik-oeih a mingmih a venawh ang dang peek sak ce hilh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Izip qam zan khaw awh ami pahqamkhqi mik huh awh kawpoek kyi ik-oeih ce sai pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Tuncunli ce pak khih na hqe phuk nawh lan hqawng awh cekkhqi ce sawi hy; tui ce ip bang amyihna dyih sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Dai awh cingmai ing sawi nawh than zung awh maivang ing sawi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Qamkoh awh lungnu ce can sak nawh tuicunli zah tui ce khawzah pehy; ");
INSERT INTO hltthb_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Lungnu ak kqek awhkawng tui phyt sak nawh lawngnu amyihna lawng sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Cehlai cekkhqi ing ak khan awh thawlh bak bak hyn uhy, Sawsang Soeih ce qamkoh awh oelh sih hyn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","A mimah ak phoen cawih a sitnaak qungna Khawsa ce noek a dak uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Khawsa oelh doena, “Qamkoh awh Khawsa ing caboei dawn law hly tang nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Lungnu a vyk awh, tui cawn law nawh tui khawzah lawngca tuina lawng hy. Buh awm ni pe hly thai bai nawh nu? Ak thlangkhqi meh ak ai hly sak thai tang lawt nu?” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Bawipa ing ce ak awi ce ang zaak awh, ak kaw so hy; Jacob ak khan awh mai kqawng sak nawh, Israel ak khan awh ak kawsonaak ce pha hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Cekkhqi ing Khawsa ce ap cang na unawh a hulnaak awm ap cangna uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Cehlai khan khawnghi ce awi pe nawh khan chawmkeng ce awng sak hy; ");
INSERT INTO hltthb_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","cekkhqi ing ami ai ham manna ce khaw na aa sak hy, khan nakawng buh ce pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Khan ceityih a muk ce ai unawh; ami ai thai khuina buh ce pek khqi boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Khan nakawng khawlaw ben khawhli ce hlah pe nawh ak thaawmnaak ing a hawt ben nakaw khaw ce hli pe sak bai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Dekvai amyihna meh ce khaw na tlan pe sak hy, tuicunli a keng awhkaw dizui amyihna pha ce ding pe sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Ami awmnaak hi ipkhuikhqi na tlak pe sak nawh, hi im a ceng a awm awh awm pe sak kyng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Ami hym ami ngaih ce a peek khqi hawh a dawngawh, a mingmih ing ami phyi aawk dyna ai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Cehlai ami hym buh zani ami cehtaak hlanawh, amim kha awh ami pem hui awh; ");
INSERT INTO hltthb_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Khawsak kawsonaak ce cekkhqik khan awh pha hy; cekkhqik khuiawh tha ak awm soeih khqi ce thih pe sak nawh Israel cadawngkhqi ce him pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Vemyihna awm bai seiawm thawlh bak bak hyn uhy; kawpoek kyi ik-oeih a sai pek khqi awh awm ap cang na bak bak hyn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Cedawngawh cekkhqi a khawnghi ce a sawhqat na boeih pe sak khqi nawh kum khqi ce kqih awmnaak ing boeih pe sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Khawsa ing cekkhqi ce ahim qit awh amah ce sui uhy; cawhtaw amah a venna hlat tlaih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Khawsa taw a mimah a Lungnu ni tice sim unawh Sawsang soeih Khawsa taw a mingmih a hulkung ni tice sim uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Cehlai amim kha hqoeng ing amah ce kyihcah unawh, amim lai ing a venawh ami qaai kqawn uhy; ");
INSERT INTO hltthb_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","a venawh amik kawlung am cak hy, a paipi sai awh ypawm na am awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Cehlai anih taw qeennaak ing a be a dawngawh; cekkhqi a thawlh ce qeenkhaw ngai pe nawh cekkhqi ce am hqe hy. Ak kawsonaak ce yh ngahngah nawh ak kawso a benaak amyihna am dang sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Cekkhqi taw pumsa, amak hlat voel hawh zilh mai ni, tice amah ing sim hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Qamkoh awh iqyt dy nu oelh unawh kqawnghu awh iqyt nu ak kaw ami seet sak ce! ");
INSERT INTO hltthb_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Khawsa ce noek a dak khawthai uhy; Israelkhqi a thlakciim ce yng sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Ak thaawmnaak ce am sim qoe uhy – a mingmih ak thekhanaak thlangkhqi kut khui awhkawng a hulnaak ce. ");
INSERT INTO hltthb_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Izip qam awhkaw poek kyi hatnaak ang dang sak khqi ingkaw zoan hun awhkaw ngaihkyi ik-oeih a saikhqi ce. ");
INSERT INTO hltthb_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Lawngnukhqi ce thi na ang coeng sak a dawngawh; lawngca tuikhqi ce am aw thai voel uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","A mingmih ak cuui aham pi hlah pek khqi khawng hak nawh, a mingmih hqe aham uphyihkhqi tyih pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Ami locangkhqi ce khamkhokkhqi venawh pe nawh, ami bibinaak khqi ce khamkhawk peek pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Misur a thingkhqi ce qeel ing him pe nawh thaikungkhqi awm qawhnu ing him pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Amik khqintaikhqi awm qeel ing him pe nawh, vawk a ai amim cahkhqi awm kqek mai a venawh peek pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Cekhqik khan awh ak kaw a hlawknaak ce am dawk qoe voel hy, ak kawsonaak, yh thai na amak awm voel kawsonaak ingkaw ak kaw ama lawnaak awh - a mingmih him aham khan ceityih hloep oet ce tyih pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","A kawsonaak ham a lam ce qoek a bah nawh; cekkhqi ce thihnaak awhkawng am hlyn kana tlawh che a venawh cekkhqi ce pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Izipkhqi ak caming boeih him pehy, Ham ipkhui awh ak awm thlanghqing ak thaih cyk khqi ce him pe boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Cehlai, ak thlangkhqi cetaw tuuk kqeng amyihna khai nawh; qamkoh awhkaw tuu amyihna sawi poe hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Syngyp cana a sawi dawngawh cekkhqi ing ap kqih uhy; Cehlai a qalkhqi cetaw tuicunli ing sing pe malh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Cemyihna cekkhqi ce qam ciim a khawqi dyna sawi khqi nawh, ak tangkut ing a lawh tlang qam dyna sawi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Cekkhqi haiawh pilnam thlangkhqi ce hqek pek khqi nawh ce a qam ce cekkhqi venawh qo na pang sak khqi nawh: cekhqi a im awh Israelkhqi ce pah sak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Cehlai cekhqi ing Khawsa ce noek a dak unawh Sawsang Soeih ce oelh unawh; ak awipeek ce am hquut uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Ami pakhqi mih baina ypawm na ami awm kaana cangnaak awm am ta uhy, ypnaak amak cu la amyihna hlat uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Hun sangkhqi sai unawh ak kaw so sak unawh; myi bawknaak ing tlai seet sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Cekhqi ce Khawsa ing ang zaak awh, ak kaw so soeih hy; cedawngawh Israel ce qoeng bang tlang hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Shiloh awh thlang khqing lak awh ang dyih sak hi im awm cehta hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Ak tha awmnaak bawm ce tamna na khum sak nawh, a boeimangnaak ce qaal a kut awh pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Ak thlangkhqi ce zawzi ing him aham pe nawh; a qo ak pang hly khqik khan awh ak kawso soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","A tawngpalangkhqi ce mai ing daih pek khqi boeih nawh a nulakhqi ing zulawh vataaknaak a laa am sa voel uhy; ");
INSERT INTO hltthb_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","A khawsoeihkhqi awm zawzi ing thi unawh, nulakhqi awm am kqang hqa voel uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Cawhtaw zu ak qui a caih amyihna, Bawipa ce a ihnaak awhkawng hqyng law hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","A qaalkhqi ce tuk pe pheng nawh; kumqui dy awh chah qai phyikawt na tahy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Cek cong awhtaw Joseph a hi im ce qoeng nawh, Epharaim a phun awm ap tyk voel hy; ");
INSERT INTO hltthb_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Cehlai Judah phun, Zion tlang, amah ing a lungnaak ce tyk hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Amah ing khawmdek kumqui dy a caksak amyihna, amah cawh hun ciim ce ak sang soeih na sa hy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","A tyihzawih David ce tyk nawh tuu a ip khui awhkawng dawk hy; ");
INSERT INTO hltthb_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Tuu ak khainaak kung awhkawng hawlaw nawh ak thlang Jacob, a qo pang Israel ce tuu ak khaikung na tahy. ");
INSERT INTO hltthb_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","David ing cekhqi ce kawlung dyngnaak ing qym hy; a kut suinaak ing cekhqi ce khai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Aw Khawsa, pilnam thlangkhqi ing na qo ak pangkhqi tuk hawh uhy; na bawkim ciim ce tyih kap sak unawh, Jerusalem ce qawp sak hawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Na tyihzawih thlangkhqi qawk ce khan nakaw phakhqi a buh na pe uhy; nak thlang ciimkhqi a sa ce khawmdek qamsakhqi a buh na pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Jerusalem a kengsam awh tui amyihna thi ce hawk uhy, qawk ak pup hly kawi u pynoet awm am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Kami kengsam awhkaw thlangkhqi a qaihbu nani kami awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Iqyt dy nu, Aw Bawipa? Kumqui dyna nak kaw so hly hawh nawh nu? Iqyt dy nu nak thatlainaak ce mai amyihna a uih kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Nang ama nik sim pilnam ak khan awh nak kawsonaak ce hawk lah, nang ming amak khy pilnam ak khan awh nak kawsonaak ce hawk lah; ");
INSERT INTO hltthb_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","kawtih cekhqi ing Jacob ce daih unawh a im a lokhqi ce hqe pe pheng hawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Ami pakhqi a thawlhnaak ce kaimih koeh nik kawqut nak khqi; nam qeennaak ing kaimih hqum aham ang tawnna law hlah seh, voet a hlauh na awm hqoeng hawh unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Aw Khawsa kaimih a hulkung, kaimih ve ni hul khqi lah, nang ming thangleeknaak aham; namah ang ming ak caming kaimih ve ni hul khqi nawhtaw ni thaawng khqi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Ikawtih pilnam thlangkhqi ing, “Hana a Khawsa a awm?” ami ti hly paqap? Kaimih amik huh awh pilnam thlangkhqi a sim na kqawn unawh, na tyihzawih thlangkhqi a thi phu nang ing lo hy tice sim lah u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Thawng ak tlakhqi ak khynaak awi ing na haai pha law seitaw; na bantha ing thih aham ami thawlh sak ce dem sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Ka kengsam awhkaw thlangkhqi namah a nik thekhanaakkhqi ce a phai awh pyh ak khqih dy awh Bawipa nang ing thung lah. ");
INSERT INTO hltthb_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Cawhtaw nang ak thlangkhqi, na qamno a sainaak awhkaw tuukhqi ing nang ce kumqui dyna nim kyihcah hawh kawm uh; cadil dyna nang kyihcahnaak ce kqawn kawng unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Aw Israel tuudoenkung, tukkqeng amyihna Joseph ak sawikung ngai law lah, nang cherubim anglak li awh ngawi nawh, vang law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Ephraim, Benjamin ingkaw Manoseh a haiawh. Nak thaawmnaak y lah; law nawhtaw kaimih ve ni hul khqi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Aw Khawsa, kaimih ve ni thaw khqi tlaih nawh; na haai ce kaimih ak khan awh vang sak lah, cawhtaw hulna awm kawng unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Aw Bawipa Boeimang Khawsa, ityk dy nu nak thlangkhqi ak cykcahnaak awh nak kaw a seet hly. ");
INSERT INTO hltthb_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Cekhqi ce nang ing mikphli ing buh ai sak khqi hawh tiksaw; boet awh ak bena mikphli tui ce awk sak hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Ka kengsam awhkaw thlangkhqi ak kawqepnaak na ni sai tiksaw, ka qaalkhqi a qaihbu na ni sai hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Aw Boeimang thakawm Khawsa, kaimih ve ni thaw khqi tlaih nawh; na haai ce kaimih ak khan awh vang sak lah, cawhtaw hulna awm kawng unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Izip qam awhkawng nang ing misurkung hawlaw tiksaw; pilnam thlangkhqi na hqek boeih congawh ling hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Ce nang lingnaak aham dek chei hqeet hyk ti, ak kqa thla nawh qam khuiawh zam tikzak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Thlangkhqi ce a hliip ing dah nawh, a paangkhqi ing sidor thing tha ak awm soeih khqi awm dah tlyp hy. ");
INSERT INTO hltthb_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","A paangkhqi ing tuicunli pha nawh, ak kqakhqi ing lawngnu tui pha hy. ");
INSERT INTO hltthb_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Ak thoek cawnkhqi ing misur thaih amik bihnaak ham ikaw hamna vawng na hqe peek? ");
INSERT INTO hltthb_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Kqawng nakaw vawmngaikhqi ing naawk unawh kqawng nakaw chukphakhqi ing ai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Aw Boeimang Khawsa, kaimih benna hlat law lah! Khan nakawng ni nuk toek law nawhtaw ni hu lah! ");
INSERT INTO hltthb_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Nak tangkut ing nang ling ak kqa, namah aham nam thawh ca pa ve. ");
INSERT INTO hltthb_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Na misur ve chawm unawh, mai awh phum uhy; nang a toelnaak awh nak thlangkhqi plawci kang uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Na kut ce nak tang benawh ak ngawi thlang ak khan awh tloeng pe, namah aham nang ing nam thawh thlanghqing capa ak khan awh. ");
INSERT INTO hltthb_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Cawhtaw nang ce am ning hlat taak voel kawng unyng; kaimih ve ni caih sak khqi tlaih lah, cawhtaw nang ming ce nik khy hly hawh unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Aw Bawipa Boeimang Khawsa, ak cyk awhkaw amyihna kaimih ve ni awm sak khqi tlaih lah; hulna kami awmnaak thai aham na haai ce kaimih ak khan awh vang law sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Ningmih a Khawsa thak awm soeih a venawh zeel doena laa sa lah uh; Jacob a Khawsa venawh khawteh na khy lah uh! ");
INSERT INTO hltthb_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Tumding tum unawh, poeng ak beei khoek lah uh, ak awi ak ding tingtoeng ingkaw qaw tingtoeng ing kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Pihla a thei nyn awh tuu’m cai ak ki yng unawh pihla a lum awh ce, ningnih a khawnghig nyn awh; ");
INSERT INTO hltthb_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Ve ve Israelkhqi ham awipeek na awm hy, Jacob a Khawsa bawknaak awipeek na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Ningmih ing am ning zaak sim awi ningzak naak Izip qam na a ceh awh, Joseph aham awipeek amyihna cak pe sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Anih ing ak phleng awhkaw phyihqih ce khoe pe nawh; ami kutkhqi ing vaihqang awm am nen sak voel nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Ngaihkyi doena nik khy tiksaw nim hlat nyng, khawhum ak khui awhkawng nim hlat khqi nyng saw, Meribah tui awhkawng ni noekdak khqi nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Aw kak thlangkhqi, ngai lah uh, ngaihtaaknaak awi nik kqawn pek khqi vang – Aw Israel, kak awi ve ngai lah thaw voei uk ti! ");
INSERT INTO hltthb_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Qap chang a khawsa ce nangmih anglak li awh koeh ta kawm u tiksaw; thalk chang a khawsa a venawh koeh ta kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Kai taw Izip qam awhkawng nangmih ak hquikung, Bawipa na Khawsa na awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Cehlai kak thlangkhqi ing kak awi am ngai uhy; Israel ing ka venawh am ap qu uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","A mimah am thinsahnaak amyihna a mimah a ngaihnaak hqut aham hlah khqi hyt nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Kak thlangkhqi ing kak awi mah aming ngai mantaw, Israel ing ka lam ve mah a hqut mantaw, ");
INSERT INTO hltthb_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","a qaalkhqi ce ang tawnna noeng pe nyng saw a qaalkhqi benna ka kut ve hlah pe voei nyng! ");
INSERT INTO hltthb_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Bawipa ak sawhnaak thlangkhqi ce a haiawh kqih doena kyn hqoeng kawm uh, a mingmih a toelnaak ce kumqui dyna awm hawh kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Cehlai nang ingtaw buh ak tui soeih ai kawm tiksaw, lungkaw awhkaw khawitui ing nak phoen ni phyi sak kawng nyng,” tihy. ");
INSERT INTO hltthb_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Khawsa ing ak thlangkqeng ak cun ce hqui a sawi nawh; “Khawsa” khqi anglak li awh awi deng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Amak thym ce ityk dy awh nu naming dyih pyi nawh thlakchekhqi a haai ce iqyt dy nu nami toek kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Tha amak awm ingkaw pa amak ta thlangkhqi ce qeet na unawh; khawdengkhqi ingkaw ak khuikhakhqi a huh tyng ce huh sak uh. ");
INSERT INTO hltthb_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Tha amak awmkhqi ingkaw ak voethlauhkhqi ce hul unawh; thlakche a kut khui awhkawng hul lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Kaw awm am sim uhy, zaaksimnaak awm am ta uhy. Than khuiawh qoe unawh; deklai ang dyih naak ing thyn nawh tlai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Kai ing, nang taw khawsakhqi na awm uhyk ti.” Nangmih taw sawsang soeih a cakhqi na awm uhyk ti.” ");
INSERT INTO hltthb_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Cehlai thlanghqing amyihna ni na thih hly lawt hy; ukkung changkhqi amyihna ni naming tluk hly lawt hy, ");
INSERT INTO hltthb_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Aw Khawsa, tho nawh khawmdek ve awi deng lah, kawtih pilnam thlangkhqi ve nang a qo ak pangkhqi na ni ami awm. ");
INSERT INTO hltthb_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Aw Khawsa, awi myhna koeh awm nawhtaw; Aw Khawsa, koeh awm hqoeng nawh koeh awm dym lah. ");
INSERT INTO hltthb_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Na qaalkhqi ikawmyihna tlawk lum lum unawh; na qaalkhqi ing ikawmyihna ami lukhqi ami thawh tice toek lah. ");
INSERT INTO hltthb_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Nak thlangkhqi tuk aham thai latnaak ing za qu unawh; nang anik thin tlawhnaak thlangkhqi ce kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Cekhqi ing, law lah uh, a phyn amilhnaak aham him usih, Israel ang ming ve u ingawm koeh zaak na voel seh,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Kawlung pynoet na awng unawh za qu uhy; nang tuk aham pynoet na hqui qu uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Edom a hi imkhqi, Ishamael thlangkhqi, Moab ingkaw Hagar thlangkhqi; ");
INSERT INTO hltthb_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Gebal, Ammon ingkaw Amelek, Philistia thlangkhqi ingkaw Tura khaw awhkaw thlangkhqi. ");
INSERT INTO hltthb_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Assyria thlangkhqi ingawm bawng unawh lot a cadilkhqi ce tha awmnaak vat uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Midian thlangkhqik khan awh na sai amyihna, Kishon lawngnu awh Sisera thlangkhqi ingkaw Jabin thlangkhqi venawh na sai amyihna, ");
INSERT INTO hltthb_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Cekhqi ce Endor awh plawci kang unawh Khawmdek awh boeih a bai na awm kqoeng uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Ak thlangkhqi ce Oreb ingkaw Zeeb amyihna sai nawh, a sengpahrang a cakhqi ce Zebah ingkaw Zalmunna na coeng sak, ");
INSERT INTO hltthb_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Cekhqi ing, Khawsa qamno a sainaak ce hul pe usih,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Aw ka Khawsa, cekhqi ce zilh ing a khyn boeih amyihna sai nawh, zilh ing a zaawn canghi amyihna sai lah. ");
INSERT INTO hltthb_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Kqawng mai ing kqawng sak nawh, tlangkhqi mai ing a uih amyihna sai lah, ");
INSERT INTO hltthb_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","na khawhli ing cekkhqi ce hqut nawh na khawhli ing cekkhqi ce ly a lap sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Aw Bawipa, thlangkhqi ing nang ming ami suinaak thai aham cekkhqi a haai ce chahnaak ing dah pelah. ");
INSERT INTO hltthb_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Cekkhqi ing chak u seitaw kqih phat u seh; mingseet doena qeng u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Bawipa ak mingnaak nang ce, sim sak nawhtaw - nang doeng ni khawmdek awh Sawsang soeih na nak awm tice sim na lah u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Aw Boeimang Bawipa, na awmnaak hun taw lungnaak cu soeih mah hy! ");
INSERT INTO hltthb_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Ka hqingnaak ing Bawipa a ipkhui kawng ce ang ngai aih awh zai hqoeng nawh, kak kawlung ingkaw ka thi ka sa ing ak hqing Khawsa ce khy hy. ");
INSERT INTO hltthb_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Aw Boeimang Bawipa, ka Sangpahrang ingkaw ka Khawsa, na bawkthang a kengawh hqiitca ing za a awmnaak hu nawh, a ca a taaknaak aham pingpir ingawm ang bu sawn hy. ");
INSERT INTO hltthb_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Nang ang loet na nim kyihcah nawh, na im awh ak awmkhqi taw ami zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Nang awh thaawmnaak ak takhqi ingkaw nang bawknaak lam benna kawlung ak takhqi taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Baca lawng khui ami hqaw awh awm, tuibym a awmnaak hun na ai uhy; Khawcui qawhnu ing tuili na coeng sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Zion awh Khawsa haiawh ami pha qip halndy thaawmnaak awhkawng thaawmnaak khqoet na cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Aw Bawipa Boeimang Khawsa, kak cykcahnaak ve ngai lah; Aw Jacob a Khawsa, nang haa keng law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Aw Khawsa, kaimih a phuhqa, namah ing na caksak thlang ve kawhymnaak ing toek lah. ");
INSERT INTO hltthb_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Ak chang awh kum thongoet awm anglakawh na bawkim khuiawh nynoet awm ve nep khqoet hy. Thlakchekhqi a hi im awh awm anglakawh BOIA im awhkaw chawmkeng ak qeh kungna ka awm ve nep khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Ikawtih, Bawipa Khawsa taw khawmik ingkaw phuhqa na awm nawh; Bawipa ing kawhymnaaki ngkaw thangleek naak pe kawmsaw; coet a kap kaana ak cet thlangkhqi aham ik-oeih leek qoe qoe am hlawh na kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Aw Boeimang Bawipa, nang anik ypnaak thlangkhqi taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Aw Bawipa, na qam khan awh nak kaw law nawh; Jacob ak khan awh kam awmnaak ce pe tlaih hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Nak thlangkhqi a sai palhnaak awh qeenkhaw ngai nawh a thawlhnaakkhqi boeih ce myk a dah pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Nak kawsonaakkhqi boeih ce khoe tiksaw nak kaw tawinaak ce hawi taak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Aw Khawsa kaimih a Hulkung, kaimih ve ning dyih sak khqi tlaih nawh, kaimih ak khan awh nak kaw ama lawnaak ce ak chang na ta mai cang. ");
INSERT INTO hltthb_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Kaimih ak khan awh nak kawso hly loet hawh nawh nu? Cadil dyna nak kawsonaak ce na sang hly sak nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Namah awh nak thlangkhqi ing zeelnaak ami huhnaak thai tlaih aham, kaimih ve am nani do hlyk khqi voel hawh nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Aw Bawipa, amak dyt thai na lungnaak ce dang law sak cang nawh, na hulnaak ce ni pek khqi cang. ");
INSERT INTO hltthb_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Bawipa Khawsa ing ak kqawn hly kawi ce ngai kawng nyng, amah ing ak thlangkhqi, thlakcimkhqi venawh ngaihqepnaak awi kam hy – cemyihkhqi ce qawnaak benna koeh mangsak voel. ");
INSERT INTO hltthb_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Amah a boeimangnaak ce ni qam khuiawh thlangkhqi venawh amah a hulnaak ce zoe pe sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Lungnaak ingkaw ypawmnaak ce hu qu nih nawh; dyngnaak ingkaw qoepnaak ce mawk qu hy nih. ");
INSERT INTO hltthb_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Khawmdek awhkawng ypawmnaak ce hak cawn nawh, khan nakawng dyngnaak ing nuk toek hy. ");
INSERT INTO hltthb_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Bawipa ing ik-oeih nep ce ni pe kawmsaw, ni qam ing ak thaih ce hawlaw kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Dyngnaak ce a haiawh cet nawh a khaw kan aham a cehnaak lam ce qoek a bah pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Aw Bawipa, ngai law nawhtaw, hlat law lah, khawdeng na awm nyng thlang voet na awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Nang ni ka ni ypnaak, ka hqingnaak ve khoem law lah. Nang taw ka Khawsa na awm hyk ti; nang anik ypnaak na tyihzawih ve hul cang lah. ");
INSERT INTO hltthb_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Aw Bawipa, nim qeen cang lah, khawnghi zung nang nik khy nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Na tyihzawih ve zeel sak cang lah. Aw Bawipa, na venawh ka hqingnaak hak soeng law nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Aw Bawipa, nang taw qeenkhaw ngai thai nawh leek hyk ti, nang anik khykhqi boeih a venawh na lungnaak khawzah na dang sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Aw Bawipa, kak cykcahnaak ve ngai law lah; qeennaak thoeh doena kang kqangnaak awi ve ngai law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Kyinaak ka huh nyn awh ce nik khy kawng nyng saw, nang ing nim hlah law kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Aw Bawipa, khawsakhqi anglak li awh nang amyihna ak awm pynoet awm am awm hy; nang a ik-oeih sai ing kqawn nyt hly kawi pynoet awm am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Nang ing na sai pilnam thlangkhqi ce law kawm usaw na haiawh ni bawk kawm uh, Aw Bawipa; nang ming ce thangleek sak kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Ikawtih, nang taw bau soeih tiksaw kawpoek kyi ik-oeihkhqi ce sai hyk ti; nang doeng ni Khawsa na nak awm. ");
INSERT INTO hltthb_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Aw Bawipa, na lam ce ni cawng sak lah, nak awitak awh cet vang nyng; nang ming kak kqihnaak thai aham a plawk a plak na ak awm kawlung koeh ni pe. ");
INSERT INTO hltthb_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Aw Bawipa ka Khawsa, kak kawlung boeih ing nang ce nim kyihcah vang; nang ming ce kumqui dyna ni zoeksang kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Ikawtih, ka venawh na lungnaak ve bau soeih hy; nang ing hlan a dungnaak awhkawng ni hul hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Aw Khawsa, ak oek qukhqi ing kai ni tuk uhy; qeennaak amak ta thlangkhqi, nang kawna ama nik hu thlangkhqi ing kai him aham ni sui uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Cehlai, Aw Bawipa, nang taw qeennaak ing ak be Khawsa na awm hyk ti, ak hengna kaw ak so, lungnaak ypawmnaak ing ak be na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Kai ben na mang law nawh nim qeen cang lah; na tyihzawih nu a capa ve hul cang lah. ");
INSERT INTO hltthb_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Ka qaalkhqi ing hu unawh amik chahnaak aham na leeknaak man ce ni pe lah, Aw Bawipa, nang ing nik pyi nawh kang ngaih qep law sak hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Anih ing a tlang ciim awh dyih hun sai hy; ");
INSERT INTO hltthb_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Jacob a awmnaak hunkhqi boeih anglakawh Zion chawmkeng ce BAWPA ing lungnak khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Nang a boeimangnaak ce kqawn uhy, Aw Khawsa a Khawk bau; ");
INSERT INTO hltthb_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Kai anik simkhqi anglakawh Rahab ingkaw Babylon ce khoem kawng nyng – Philistia awm, Tura ingkaw Kush ing haih awh - Ve ak thalng taw Zion awh thang hy,” ti kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Zion awh vemyihna a nak kqawn kawm uh, “Vawhkaw ingkaw cawhkaw ce anih ing cuun nawh, Sawsang Soeih ing anih ce caksak kaw,” tinawh. ");
INSERT INTO hltthb_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Thlang boeih ang ming khoemnaak cauk awh Bawipa ing “Ve ak thlang taw Zion awh thang hy,” tinawh qee kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Tumding tum kawm usaw, “Ka zeelnaak tui bym boeih taw nang awh ni a awm,” tinawh laa sa kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Aw Bawipa, kai anik hulkung Khawsa, khawmthan khawdai na haiawh khy nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Kak cykcahnaak ve na haiawh pha seitaw; kak khynaak benna nang haa keng law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Ka hqingnaak ve kyinaak ing be nawh ka hqingnaak ve hlan ing ni a ning zoe qu hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Lawk-kqawng na a nuk cetkhqi ing nik dawh sih haih uhy; kai vemyih tha amak awm thlang ve. ");
INSERT INTO hltthb_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Thlak thikhqi anglakawh ni hoep unawh, thlang him unawh hlan awh ami soei amyihna, nang a khoemnaak ak khuiawh amak awm voel hawh thlangkhqi amyihna, nang ing anih ce am sim qoe voel hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Lawk-kqawng ak kai dyt ak hypnaak tit tit na ni ta hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Nak kawsonaak ce kak khan awh ak qih soeih na ta tiksaw; hlipui ing ce ni sing malh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Ka pyikhqi awm ni lawh pe tiksaw cekkhqi am tyih kawi na ni sai hyk ti. Nik kqyp khak tiksaw ap cawn thai nyng; ");
INSERT INTO hltthb_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Kak kaw a seet aih awh ka mik qawi awm hyp khoep hawh hy. Aw Bawipa, nang ce khawnghi zung nik khy nyng saw, nang a venawh ka kut qawi ve phyl nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Thlak thi a venawh kawpoek kyi ik-oeih nak dang sak nu? Ak thikhqi ing tho unawh nang nim kyihcah unawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Phyi awh nang a lungnaak ce amik kqawn nu; seetnaak a hunawh nang a ypawmnaak ce amik kqawn nu? ");
INSERT INTO hltthb_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Thannaak awh nang ak kawpoek kyi ik-oeih sai ce sim na ak awm nu, am awhtaw lunghilhnaak qam awh nang a dyngnaak ik-oieh ai ce a mik sim nu? ");
INSERT INTO hltthb_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Cehlai Aw Bawipa, qeennaak thoeh doena na venawh khy nyng, mymcang hqit awh kak cykcahnaak ing na hai pha law hy. ");
INSERT INTO hltthb_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Ikawtih Aw Bawipa, ni qoeng nawh, na haai na thuh hy voei? ");
INSERT INTO hltthb_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Ka naasen ca awhkawng khuikha sim nyng saw thih pit dyna awm nyng; nak kqih awmnaak zawk nyng saw kawboet ing awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Nak kawsonaak ing ni sing khyng nawh; nak kqih awmnaak ing ni plawci sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Khawnghi zung tuinu amyihna nik chung khoep uhy; cekkhqi ing nik chawi malh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Ka pyikhqi ingkaw ka lungnaak thlangkhqi ce lo tiksaw; thannaak ve ni ak zoe khyt pyi na a awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Bawipa a lungnaak ak bau soeih ce kumqui dyna laa na sa kawng nyng; kam kha ingkaw cadil dyna nang a ypawmnaak ce sim sak kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Nang a lungnaak taw kumqui dyna cak hy tice kqawn nyng saw, namah a ypawmnaak ce khawk khan awh caksak hawh hyk ti tice kqawn kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Nang ing Kak tyh thlang ing paipi aw nih nyng saw, ka tyihzawih a venawh awi kam hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Na cahlah qui ce kumqui dyna caksak kawng nyng saw cadil dyna na ngawihdoelh ce caksak kawng,” ti hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Aw Bawipa, kawpoek kyi ik-oeih na saikhqi ce khankhqi ing kyihcah unawh, thlakcimkhqing cunnaak awh, nang a ypawmnaak awm kyihcah uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Khawnghik khan awh Bawipa ing nyhtah hly kawi u nu ak awm? Khan ik-oeih sai anglakawh Bawipamyihna u nu ak awm? ");
INSERT INTO hltthb_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Thlakcimkhqing cunnaak awh khawsa ve kqih soeih uhy; amah ak chungkhqi anglakawh amah ve kqih awm khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Aw Bawipa Boeimang thak awm Khawsa, nang amih u nu ak awm bai? Aw Bawipa, nang taw bau nawh na ypawmnaak ing nik chung hy. ");
INSERT INTO hltthb_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Nang ing tuicunlikhqi ce uk tiksaw, a hak tho ce dym sak hyk ti; na baan thak awm ing, na qaalkhqi ce hqe khqi hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Nang ing him na ak awm amyihna Rahab ce neet hyk ti; na baan thak awm ing, na qaalkhqi ce hqe khqi hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Khan ce nang a koena awm nawh, khawmdek awm nang a koena awm hy; khawmdek ingkaw ak khuiawh ak awm ik-oeihkhqi boeih ce nang ing syn hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","A sip ingkaw a hawt ce nang ing sai tiksaw; Tabor ingkaw Hermon ing namah ang ming awh zeelnaak laa sa hy. ");
INSERT INTO hltthb_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Na ban taw thaawmnaak ing be nawh; na kut ce ak tha awm hy, nak tang kut ben ce zoeksang na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Dyngnaak ingkaw thymnaak ce na ngawihdoelh ang dyih hunna awm nawh; lungnaak ingkaw ypawmnaak ce na haiawh cet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Nang a venawh zeel awi kqawn aham ak cawngkhqi taw a zoseen hy, Aw Bawipa, na haiawh vangnaak ing ak cetkhqi taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Cekkhqi cetaw nang ming awh nynnoet pyt zeel uhy; ");
INSERT INTO hltthb_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Ikawtih, nang taw cekkhqi a thangleeknaak ingkaw thaawmnaak na awm nawh, nak kawzeelnaak ak caming kaimih ak ki ve zoeksang hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Kaimih a phuhqa taw Bawipa a koe tak tak ni; kaimih a sangpahrang awm Israelkhqi ak thlangcim soeih na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Namah a ypawm thlangkhqi venawh huh saknaak ing hypboet kqawn hyk ti: “Qalkap ak tlung pynoet a venawh thaawmnaak pe nyng; thlangkhqi anglakawhkawng tawngplang pynoet ce zoeksang hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Ka tyihzawih David ce hu hawh nyng; ka situi caih ing anih ce syp hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Ka kut ing dawm kawng nyng saw; ka baan ing tha awm sak kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Han a qal ingawm am kham pe sak kawmsaw; ikawmyih a thlakche ingawm am thekha na ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","A haiawh a qaalkhqi ce hqawi a neet pek khqi kawng nyng saw, a thunkhakhqi ce him pe kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Ka lungnaak ve ak khan awh ypawm na ta kawng nyng saw, kang ming ak caming ak ki ce zoeksang hqui na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Tuicunli ak khan awh a kut ce taak pe kawng nyng saw, pe kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Anih ing “Nang taw Ka pa, ka Khawsa, anik hulkung lungnu,” tinawh nik khy kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Kai ing anih ce cakcyk na sai kawng nyng saw, khawmdek awh sangpahrangkhqi anglak li awh zoeksang kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","A venawh lungnaak ce kumqui dyna cak pe sak kawng, a venawh paipi ka sai awm am plal tham tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Anih a cahlah qui ce kumqui dyna cak pe sak kawng nyng saw, khan a awm khui a ngawihdoelh ce cak pe sak kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","A cakhqi ing ka cawng saknaak awi ve cehta unawh kak awipeek ve a mami hqut awhtaw; ");
INSERT INTO hltthb_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","Ka awi tloepnaakkhqi ve eek unawh kak awipeekkhqi ve a mami khoem awhtaw, ");
INSERT INTO hltthb_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","Thingboeng ing a thawlhnaakkhqi ce toel kawng nyng, a sai thawlhnaakkhqi ce qawkkek ing toel kawng; ");
INSERT INTO hltthb_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Cehlai ka lungnaak ce a ven awhkawng am lawh pe kawng nyng saw, ka ypawmnaak ve ityk awh awm am zawi valh ti kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Ka paipi ve am eek kawng nyng saw ka hui ing ak kqawn hawh taw ap chawt ti kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Ka ciimnaak ing hypboet ak khoek na awi kam hawh nyng – David a venawh qai ap kqawn ti kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Anih a cahlah qui ce awm phaat kawmsaw ka haiawh khawmik amyihna ngawihdoelh ce awm loet kaw; ");
INSERT INTO hltthb_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Khanhi awh ypawm na ak awm pihla amyihna anih ce caksak loet kawng nyng.” ");
INSERT INTO hltthb_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Cehlai nang ing qoek tiksaw kawna awm am ngai hyk ti; situi na syp ak khan awh nak kawso sak soeih hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Na tyihzawih ing paipi na sai ce qoek pe valh nawh a boei lumyk awm dekvai awh hqit pe sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","A vawngkhqi hqe pe boeih nawh a vawng cakkhqi awm plawci sak boeih hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Ak thoekkhqi ing ik-oeih qawt pe unawh; a kengsam awhkaw thlangkhqi ak kqawnseet na awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","A qaalkhqi ak tang kut ben ce zoeksang pe tiksaw; a qaalkhqi boeih ce zeel sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Zawzi ak h qaat ben ce hawi pe khup phlet tiksaw qaal tuknaak kung awh awm am dyih pyi voel hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","A boeimangnaak ce dyt pe sak nawh a bi ngawihdoelh ce khawmdek na khawng pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","A tai pyngthym hui awhkaw khawnghi ce tawi pe sak nawh, chah phyihnaak hi ing zawl malh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Aw Bawipa, ityk dy aw? Na haai ce na thuh hly loet hawh nawh nu? Nak kawsonaak ce mai amyihna iqyt dy a uih kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Ka hqingnaak ve ikawmyih dyna ang khum a zoe tive sim lawt lah. Nang ing na sai thlanghqing ve a hqawng a h qap mai ni. ");
INSERT INTO hltthb_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Thihnaak amak hu thlanghqing a u mih ak thlang nu awm nawh, hlan a sai thainaak awhkawng amah ingkaw amah ak hul qu thai u nu ak awm? ");
INSERT INTO hltthb_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Aw Bawipa, ma nakaw na lungnaak ak bau soeih ce hana a awm, na ypawmnaak ing a tyihzawih David a venawh awi na kam ce ti? ");
INSERT INTO hltthb_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Bawipa, na tyihzawih qaibu na a awm ce sim poe nawhtaw, pilnam thlangkhqi a thekhanaak awikhqi ikawmyih dyna kak kawlung ing ang yh tice sim law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Aw Bawipa, na qaalkhqi ing thekhanaak ingkaw qaihbu na ami ni sai ve, ve ing nang ing na caksak thlang ce a khaw kan boeih awh qaihbu na sai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Bawipa venawh thangleek naak kumqui dyna awm seh nyng! Amen coeng awh Amen. ");
INSERT INTO hltthb_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Bawipa, nang taw cadil dyna kaimih a awmnaak hun na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Thlangkhqi a awm hlanawh lungdek ingkaw khawmdek na syn hlan awh, kumqui ingkaw kumqui dyna nang taw Khawsa na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Thlanghqing ce dekvai na hlat sak tlaih tiksaw, “thlanghqing cakhqi aw, dekvai na hlat tlaih hlah uh,” tina hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Kum thongoet awm nang a huh awhtaw ak khum bang khaw nynoet amyihna ni a awm, am awhtaw thanoet amyihna ni a awm. ");
INSERT INTO hltthb_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Thlanghqing ve thihnaak awh ihnaak ing khawl bang tiksaw; mymcang awhkaw qam ak cawn thai amyihna ni a awm. ");
INSERT INTO hltthb_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Myncang hqit awhtaw sai pai hlai uhy, khawmy ben awhtaw zai nawh reu hy. ");
INSERT INTO hltthb_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Nak kawsonaak ing kaimih ve ni ai nawh nam thin tawinaak ce kaimih aham kqih awm soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Kaimih a sai thawlhnaakkhqi ce na haiawh ta nawh, kaimih anghyp thawlhnaakkhqi ce na hai awhkaw vangnaak ing coei pheng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Kaimih a khawnghi boeih ve nak kawso ak kaiawh khum boeih hy; kumkhqi boeih ve ko ang kqangnaak ing dyt sak unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Kaimih a khawnghi a sang taw kum khqihkip - tha a awm awhtaw kup kqetkip pha thai mai hy; Cehlai ce ak khuiawh ak leek soeih zani kyinaak ingkaw kawseetnaak hqoeng ni, ang tawnna khum bang nawh, ding bang unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Nang ak kawso thaawmnaak ce u ing a sim? Ikawtih nang ak kawsonaak ve kqih hly kawi dyna bau soeih ky. ");
INSERT INTO hltthb_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","kawlung cyihnaak kami huhnaak thai aham, hqingkhui khawnghi ak thym na noet thainaak ce ni cawngpyi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Aw Bawipa, ngai qu dawm cang! Ikchoet nu nak kaw a so hyn kaw? Na tyihzawihkhqi ak khan awh qeennaak ta cang. ");
INSERT INTO hltthb_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Na lungnaak amak dyt thai ing mymcang awh ni phyi sak khqi nawh, cawhtaw zeelnaak laa sa kawng unyng saw ka hqing khui pyt kamik kaw zeel kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Khawnghi khawqyt nani khuikha sak khqi hawh amyihna kawzeelnaak ni pek khqi lawt lah, kawtih kum khawqyt awh kyinaak hu hawh unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Na ik-oeih sai ce na tyihzawihkhqi venawh dang sak nawh, na boeimangnaak ce na cakhqi venawh dang sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Ningmih a Bawipa Khawsa ak kawzeelnaak ce ningnih ak khan awh awm seh nyng; kaimih a kut bibi ve cak law sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Sawsang soeih a awmnaak hun awh ak awm taw Boeimang thak awm a hlip awh dym kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Bawipa, Anih taw kang thuknaak ingkaw ka vawngcak, ka ypnaak Khawsa na awm hy,” ti kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Anih ing pha aham dawng dun peek a kut khui ingkaw thihnaak tlawhnu khui awhkawng ni loet sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Anih ing ang hla ing ni hlip kawmsaw, ang hlak kep awh dymnaak hu kawm uk ti; anih a ypawmnaak ce nang a phuhqa ingkaw kqangdan na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Than kqih awm awm ap kqih kawp ti, dai awh ak ding thai awm ap kqih kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Khawmthan awh ak thoek tlawhpui awm ap kqih voel ti kawp ti, khawnghyp awh ak law thihnaak awm ap kqih ti kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Na venawh thlang thawnghqa tlu u seiawm, nang a ven am pha qoe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Namik doeng ing toek hqoeng kawm tiksaw thlakchekhqi phepnaak ce hu kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Sawsang Soeih ce na awmnaak hun na na taak awhtaw – kai kang thuknaak, Bawipa ce – ");
INSERT INTO hltthb_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Tlawhnaak qoe qoe ing am ni pha tikaw, ikawmyih a seetnaak ingawm na hi im am pha law ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Ikawtih na cehnaak a hoeiawh anik awmpyi aham ak khan na cehnaak a hoeiawh anik awm pyi aham ak khan ceityihkhqi ce awi pe kaw; ");
INSERT INTO hltthb_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Lung awh na khaw am na suknaak aham cekkhqi ing na kut awh ni hak pawm kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Sendeih ingkaw ngentau ce leh kawm tiksaw; samthyyn ak bau soeih ingkaw khquih bau ce nawi kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Ikawtih Bawipa, Kai ani lungnaak dawngawh, hul kawng nyng; kang ming ce a sim dawngawh, hlip a chung kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Kai ce nik khy kawmsaw, kai ing hlat kawng kyinaak a hu awh ce awmpyi kawng nyng saw, ka hul coengawh zoeksang kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Hqinglung sangnaak ing ngaihqep sak kawng nyng saw ka hulnaak ce huh sak kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Bawipa kyihcah ve nep nawh, Aw sawsang soeih, tumding ing nang ming kyihcah ve leek hy, ");
INSERT INTO hltthb_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","mymcang awh na lungnaak kqawn nawh than awh na ypawmnaak kqawn ve nep hy, ");
INSERT INTO hltthb_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","A qui pahqa ak law tingtoeng ingkaw qaw tingtoeng ing nang ming kyihcah ve nep hy. ");
INSERT INTO hltthb_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Aw Bawipa, na ik-oeih sai ing ni zeel sak hyk ti; na kut sai awh zeelnaak laa sa nyng ");
INSERT INTO hltthb_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Aw Bawipa, na ik-oeih sai ve bau soeih nawh, nak poeknaak awm dung soeih hy! ");
INSERT INTO hltthb_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Poeknaak amak takhqi ing ce ce am sim uhy, thlakqawkhqi ing am zasim bai uhy, ");
INSERT INTO hltthb_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","thlakchekhqi taw qam amyihna cawn nawh ik-oeih amak leek ak saikhqi ing qoeng a taai mai u seiawm, kumqui dyna plawci kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Cehlai Bawipa, nang taw kumqui dy zoeksang na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Aw Bawipa, na qaalkhqi, na qaalkhqi bai taw plal a tham ngai kawm uh; ik-oeih che ak saikhqi boeih taw a kqeng a zang na awm ngai bit kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Vaitawm cai ak ki amyihna kak ki ve zoeksang tiksaw; situi leek ing ni syp hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Ka thunkhakhqi noeng na ami awm ce ka mik ing hu nawh; ka qaal thlakchekhqi ing cen khawng hak uhy tice kang haa ing za hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Thlakdyng taw thut thing amyihna taai kawmsaw. Lebanon awhkaw sidar thing amyihna a taai nep kaw; ");
INSERT INTO hltthb_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Bawipa a ipkhuiawh ling na ak awm taw, ningnih a Khawsa a vawngup khuiawh taai hqui kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Pacawng nawh kum a sang coengawh awm qah bak bak kaw, a hqing sup na awm loet kaw, ");
INSERT INTO hltthb_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Bawipa taw thlakdyng ni; anih taw ka lungnu na awm nawh, anih awh seetnaak ve tehca awm am awm hy,” tinawh kqawn kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Bawipa taw boei na ngawi nawh, qypawmnaak ing thoeihcam quhy; Bawipa taw qypawmnaak ing thoeihcam qu nawh thaawmnaak ing myk ang dah qu hy. Khawmdek ve ak cak na dyih sak nawh; am thoeih qoe hy. ");
INSERT INTO hltthb_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Na boei ngawihdoelh ce ak kqym awhkawng caksak cena awm hawh hy; nang taw kumqui awhkawng awm hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Aw Bawipa, tuicunlikhqi hak zoek qu hy, tuicunlikhqi ing ak awi y uhy; tuicunlikhqi ing tuibak awi y uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Tui ak awi ak hum anglakawh awm khan ben nakaw Bawipa taw ak tha awm khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Nak awipeekkhqi ce ak cak na dyi nawh; Aw Bawipa, cimnaak ing na im ce a dyt ka qoena thoeihcam loet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Aw Bawipa, lu ak lokung Khawsa, lu ak lokung Aw Khawsa, vang pheng lah. ");
INSERT INTO hltthb_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Aw Khawmdek awi ak dengkung, tho lah; ak oek qukhqi ce a nai a koem na thung lah. ");
INSERT INTO hltthb_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Thlakchekhqi iqyt dy, Aw Bawipa, thlakche khqi iqyt dy ami hoel poeng kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Oek qunaak ak awi sa unawh; thlakchekhqi ing oek qunaak ak awi ing be uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Aw Bawipa, nak thlangkhqi ce phep a re unawh; na qo ak pangkhqi ce the a kha na uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Nuhaikhqi ingkaw khinkhqi ce him unawh, pa ak naikhqi ce him uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Bawipa ing am hu hy; Jacob a Khawsa ing kawna am sui hy,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Nangmih thlang khqing lak awh poeknaak amak takhqi aw, poek hqeet lah thaw voei uk ti; nangmih thlakqaw tloek aw, ityk awh nami cyih kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Haa ak saikung ing am za hly nawh nu? Mik ak saikung ing am hu hly nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Pilnam thlang ak cawngpyikung ing am toel hly nawh nu? Thlang ak cawngpyikung ce cyihnaak voet nawh hy voei nu? ");
INSERT INTO hltthb_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Thlanghqing ak kawpoek Bawipa ing sim nawh; cekkhqi taw zilh mai ni tice sim hy. ");
INSERT INTO hltthb_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Aw Bawipa, nang ing nam cuuk thlangkhqi taw a zoseen hy, nang a anaa awi ak cawngkhqi taw a zoseen hy; ");
INSERT INTO hltthb_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","thlakche aham lawk-kqawng ak co na a awm hlan dy kyinaak khawnghi ak khui awhkawng cekhqi ce hawih khangnaak pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Ikawtih, Bawipa ing ak thlangkhqi cetaw am qoek tang; a qo ak pang hly tyng thlangkhqi ce am hlah tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Awidengnaak ce dyngnaak awh awm kawmsaw, kawlung ak dyng thlangkhqi boeih ing ce ce hquut kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Thlakche ak tuk aham ka ham u nu ak dyi kaw? Ik-oeih che ak saikhqi ce u ing nu a oelh law lah voei? ");
INSERT INTO hltthb_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Bawipa ing ama nik pyi mantaw, thihnaak dek khuiawh ni ka awm hly hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Kai ing, Ka khaw bah hy,” ka ti awh ce, Aw Bawipa, na lungnaak ing nim thawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Ka kawpoek a kyi soeih awh, nang ngaihqepnaak ing ka hqingnaak zeel sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Ak awi tlyhnaak ing kyinaak pe nawh, ak plawci thai boei ngawihdoelh ingkaw nang anglakawh phaqunaak ak awm hly thai aw? ");
INSERT INTO hltthb_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Cekhqi ing za qu unawh thlakdyng ce tuk uhy, ak awm dym ce thih ham dyna dawk sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Cehlai Bawipa taw kai a vawngbau cak na awm nawh, kai kang thuknaak lungnu taw Khawsa ni. ");
INSERT INTO hltthb_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Cekkhqi a thawlhnaak ce thung pe kawmsaw ak che sainaak awh cekkhqi ce hqe kaw; Bawipa ningnih a Khawsa ing cekkhqi ce hqe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Law lah uh, Bawipa venawh zeelnaak laa sa lah usih; ningnih a hulnaak lungnu venawh khawteh na khy lah usih. ");
INSERT INTO hltthb_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Zeelnaak awi kqawn doena a venawh cet unawh taw tumding ing laa sak doena zoeksang lah usih. ");
INSERT INTO hltthb_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Ikawtih Bawipa taw boeimang soeih Khawsa na awm nawh, khawsa boeih ak khan awh Sangpahrang ak bau soeih na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","A kut awh dek ak dung soeih khqi ce awm nawh, tlangsawmkhqi awm amah a koena awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Tuicunlikhqi awm amah ing a sai dawngawh, amah a koena awm hy, a kut ing kawngceng awm sai bai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Law lah uh, amah bawk doena koep lah usih, ningnih anik saikung Bawipa haiawh khuk sym lah usih, ");
INSERT INTO hltthb_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","anih taw ningnih a Khawsa na awm nawh, ningnih taw a qamno a sainaak awhkaw thlangkhqi na ni awm uhy, amah ing ak khai tukkqeng na ni awm uhy. Tuhngawi awh ak awi naming zaak awhtaw, ");
INSERT INTO hltthb_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Meribaha awh na mik kaw ting sak unawh, Massah khawnghi awh qamkoh awhkaw nami sai amyihna na mik kaw koeh ting sak voel uh, ");
INSERT INTO hltthb_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Ka ik-oeih sai hu hawh hlai uhy, cawh ce na pakhqi ing ni noekdak uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Ikawtih kum phlikip khuiawh cekkhqik khan awh kak kaw so hy; “Ve ak thlangkhqi ve kawlung ak plengkhqi, ka lam amak sim thlangkhqi ni,” ti nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Cedawngawh kawso doena “Vekkhqi ing ityk awh awm kang dymnaak awh am kun hly thai uhy,” tinawh awi kam nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Bawipa venawh lak thai sa unawh; khawmdek thlangkhqi boeih aw, Bawipa venawh laa sa lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Bawipa venawh laa sa unawh, ang ming ce kyihcah lah uh; nynnoet coeng nynoet awh a hulnaak ce kqawn lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Pilnam thlang anglakawh a boeimangnaak ce khypyi unawh, thlang boeih a venawh kawpoek kyi ik-oeih a sai ce kqawn lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Ikawtih Bawipa taw a mang soeih a dawngawh kyihcah aham tyng hy; khawsa boeih anglakawh kqih aham awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Ikawtih pilnam thlangkhqi a Khawsa taw myi sai mai ni, Cehlai Bawipa ingtaw khan ce sai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Boeimangnaak ingkaw qypawmnaak ce a haiawh awm nawh; a hun ciim awh thaawmnaak ingkaw boeimangnaak ce awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Aw pilnam cakawkhqi boeih aw, Bawipa ce sim unawh, Bawipa venawh boeimang thaawmnaak ce pe lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Bawipa venawh ang ming boeimangnaak pe unawh; ik-oeih nawn hly kawi khyn doena a bawkim vawngup khuiawh law lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Ak ciim ik-oeih ing thoeihcam qu unawh Bawipa ce bawk lah uh; Khawmdek thlangkhqi boeih aw, a haiawh thym lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Pilnam thlang anglakawh, “Bawipa taw boei na ngawi hy,” tinawh kqawn uh. Khawmdek ve ak cak na ang dyih sak dawngawh am thoeih qoe voel hy; anih ing Khawmdek thlangkhqi ce ang myihlip na awi deng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Khan zeel seitaw, Khawmdek ak kaw law seh tuicunli ingkaw ak khuiawh ak awmkhqi boeih ing awi sa useh; ");
INSERT INTO hltthb_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Lokhqi ingkaw lo ak khuiawh awh ak awmkhqi boeih ing zeelnaak laa sa u seh. Cawhtaw kqawng awhkaw thingkhqi boeih ing zeelnaak laa sa kawm usaw; ");
INSERT INTO hltthb_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Bawipa haiawh laa sa kawm uh, Khawmdek awideng aham law hawh kaw, anih ing Khawmdek ve am dyng na awideng kawmsaw thlangkhqi ce awitak ing awi deng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Bawipa taw boei na ang ngawih dawngawh, Khawmdek zeel seh; ak hla na ak awm tuisang lak khqi awm zeel u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Myi ingkaw than ing zawl nawh; dyngnaak ingkaw thymnaak ce a boei ngawihdoelh hawihnaak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","A haiawh mai cet nawh a kengsam awhkaw a thunkhakhqi ce uih sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","A Khawk phla ing Khawmdek ve coei hlap hlap nawh; Khawmdek ing a huh awh thyn hy. ");
INSERT INTO hltthb_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Tlangkhqi awm Khawmdek a Bawipa haiawh khawiut amyihna tle uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Khankhqi ing a dyngnaak khypyi unawh, thlang boeih ing a boeimangnaak ce hu uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Myihlip ak bawkkhqi boeih taw chahphyi uhy, myihlip awh ak oek qu thlangkhqi ce nangmih khawsakhqi boeih ing amah ce bawk lah uh! ");
INSERT INTO hltthb_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Zion ing ang zaak awh ce zeel nawh Judah qam awhkaw vangcakhqi awm Bawipa, nang ak awidengnaakkhqi awh amik kaw zeel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Nang taw, Bawipa, Khawmdek boeih ak khan awh Sawsang Soeih na awm hyk ti; khawsakhqi boeih ak khan awh zoeksang na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Bawipa ak lungnaak thlangkhqi ingtaw ak che ce sawh na u seh, amah a ypawm thlangkhqi ce awm pyi nawh thlakche a kut khui awhkawng hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Thlakdyng ak khan awh vangnaak awm nawh kawlung ak dyngkhqi venawh zeelnaak awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Nangmih thlakdyngkhqi aw, Bawipa awh zeel unawh taw, ang ming ciim ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Bawipa venawh lak thai sa lah uh, kawtih amah ing kawpoek kyi ik-oeihkhqi ce sai hy; tang kut ben a ban caih ing hulnaak ce amah aham sai hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Bawipa ing a thaawngnaak ingkaw a dyngnaak ce pilnam thlangkhqi venawh sim sak nawh dang pe sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Israel ipkhuikaw venawh amah ak lungnaak ingkaw a ypawmnaak ce sim khak hy; khawdyt nakaw thlang boeih ing ningnih Khawsa thaawngnaak ce hu hawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Khawmdek thlangkhqi boeih aw, zeel doena Bawipa venawh khy lah uh; tumding tum doena zeelnaak laa sa lah uh; ");
INSERT INTO hltthb_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","tingtoeng ing Bawipa venawh tum unawh, tingtoeng tum doena laa sa lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Uut awi ingkaw tuu’m cai ak ki yng doena, Bawipa sangpahrang haiawh zeel doena khy lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Tuicunli ingkaw ak khuiawh ak awmkhqi boeih, Khawmdek ingkaw ak khuiawh ak awmkhqi boeih ing awi sa u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Lawngnukhqi ing kut bei u seitaw, tlangkhqi ing zeelnaak laa kutoet na sa u seh; ");
INSERT INTO hltthb_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Bawipa haiawh laa sa u seh, kawtih anih taw Khawmdek awideng aham law hy. Anih ing dyngnaak ing Khawmdek deng kawmsaw thlangkhqi ce ang myih pil na awi deng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Bawipa taw boei na ngawi hy, pilnam thlang boeih thyn u seh nyng; anih taw cherubim anglakawh boei ngawihdoelh awh ngawi hy, deklung deklai ing thyn seh. ");
INSERT INTO hltthb_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Zion awh Bawipa taw boeimang na awm nawh; pilnam boeih ak khan awh zoeksang na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Nang ming boeimang ingkaw kqih awm ve kyihcah u seh – anih taw ak ciim ni. ");
INSERT INTO hltthb_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Sangpahrang taw thak awm thlang na awm hy, ak thym ce lungna hy – nang ing ang myih pil na caksak hyk ti; Jacob awh ak dyng ak thym ce sai hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Bawipa ningnih a Khawsa ce zoeksang unawh taw a khawkung awh bawk lah uh; anih taw ak ciim ni. ");
INSERT INTO hltthb_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Mosi ingkaw Aaron ve a khawsoeih anglakawh awm nih nawh, ang ming ak khykhqi anglak li awh Samyl taw awm hy; cekkhqi ing Bawipa ce khy unawh anih ing hlat pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Anih ing myi ak dyi awhkawng awi kqawn pe nawh, amah ing a peek awipeek ingkaw ak awi ak kqawn peekkhqi ce ngai pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Aw Bawipa kaimih a Khawsa, cekkhqi ce nang ing hlat hyk ti; a sai thawlhnaakkhqi awh nang ing toel hlai hyk ti, Israelkhqi aham qeenkhaw ak ngaikung Khawsa na awm pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Bawipa ningnih a Khawsa ce zoeksang unawh a tlakang ciim awh bawk lah uh, kawtih ningnih a Bawipa Khawsa taw ciim hy. ");
INSERT INTO hltthb_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Khawmdek thlangkhqi boeih aw, awmhly doena Bawipa venawh khy lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Zeel doena Bawipa ce bawk unawh taw; zeelnaak laa sak doena a haiawh law lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Bawipa taw Khawsa ni tice sim uh. Amah ing ningnih ve ani sai khqi a dawngawh, amah a koena ni awm uhy; ak thlang na ni awm unawh, qam a sainaak awhkaw tukkqeng na ni awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Zeel awi kqawn doena ak chawmkeng awh kun unawh, amah kyihcah doena a bawkim ipkhui awh kun lah uh; a venawh zeel awi kqawn unawh ang ming ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Ikawtih, Bawipa taw leek nawh a lungnaak ce kumqui dyna cak hy; a ypawmnaak awm cadil dyna cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Aw Bawipa, na lungnaak ingkaw na thymnaak awh laa sa nyng saw, nam kyihnaak laa sa vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Coet a kap kaana khaw ka saknaak aham ngaihta vang nyng – ityk awh ka venna na law kaw? Coet amak kap kawlung ing ka ipkhui na cet vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Amak leek ik-oeih ce ka mik huh awh am awm sak kawng. Cangnaak amak ta thlangkhqi a ik-oeih saikhqi ce sawh na nyng; cekkhqi ing kai am nim tu kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Kawlung amak dyng thlangkhqi taw ka venawh kawng ak hla na awm kawm uh; ak che ik-oeih qoe qoe ce ap kqip ti kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","U awm a kengsam awhkaw thlang ang hypna ak kqawnseetkhqi taw, hqe kawng nyng; u awm oek qunaak mik dai nawh kawlung ak oek qu taw, am dun khing ti kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Kai ing ami awm haih thainaak aham, qam khuiawh kaw ypawm thlangkhqi ce toek kawng nyng; coet a kap kaana ak cet thlangkhqi ing ka bibi kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Thlak thaikhqi ka ipkhui awh am awm thai kawm uh; amak thym awi ak paukhqi ka haiawh am dyi thai kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Qam khuiawh kaw thlakchekhqi ce mymcang qoek awh hqe khqi kawng; ik-oeih che ak saikhqi boeih ce Bawipa khawk bau khuiawh kawng milh sak kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Aw Bawipa, kak cykcahnaak awi ve ngai law lah; bawm aham kang kqang awi ve na ven pha seh. ");
INSERT INTO hltthb_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Ka khuikha awh ve na haai koeh thuh. Kai benna nang haa keng law nawhtaw; ka nik khy awh ang tawnna nim hlat lah. ");
INSERT INTO hltthb_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Ka hqing khui khawnghikhqi ve maikhu amyihna ding bang nawh; ka quhkhqi ve maialh amyihna alh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Kak kawlung ve koh aai nawh qam amyihna reu hy; buh ai aham awm hilh qu hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Kang ko awh ka quh ingkaw ka vyn hqawng ni ak awm hqoeng hawh. ");
INSERT INTO hltthb_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Qamkoh awhkaw bukbu amyihna ngawi hqoeng nyng saw, ak plawci anglakawhkaw bukbu amyihna awm hqoeng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Ihmyh lonai na awm nyng saw; iptih khanna amah doeng ak ngawi hqoeng pha amyihna awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Khawnghi zung ka qaalkhqi ing nik kqawnset unawh, kai anik huhqytkhqi ing kang ming ve kqawn setnaak na hawna uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Maivytkhqi ce buh na ai nyng saw ka awk hly kawi awm mikphli tuikhqi ing kqit uhy, ");
INSERT INTO hltthb_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","nak kaw a so aih awh, ni lo hqoet nawh nik khawng hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Ka hqingnaak khawnghikhqi ve khawmy benna kaw khawngkawn amyihna awm nawh; qam amyihna reu hy. ");
INSERT INTO hltthb_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Cehlai, Bawipa, nang taw kumqui dy boei ngawihdoelh awh ngawi hyk ti; nang ming awm cadil naa dyna cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Nang tho kawm tiksaw Zion ce qeen kawp ti, anih a venawh zeelnaak tym qoe hawh ni; a tym a taak ce pha law hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Na ceityihkhqi ing anih a lung ce lungna unawh; a dekvai ing cekkhqi ce am thin tlawh sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Phynlumkhqi ing Bawipang ming kqih kawm usaw, khawmdek awhkaw sangpahrangkhqi boeih ing na boeimangnaak ce kqihchah kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Ikawtih Bawipa ing Zion ce sa tlaih kawmsaw a boeimangnaak ing dang tlaih kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Khawdeng ak voethlauhkhqi ak cykcahnaak ce hlat pe kaw; cekkhqi a qeen thoehnaak ce am huhsit pek khqi tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Ve ve ak law hly kawi cadil naakhqi ham qee na awm seh; saina ak awm hlankhqi ing Bawipa ce kyihcah na seh. ");
INSERT INTO hltthb_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Bawipa ing a hun ciim sang soeih awhkawng nuk toek hy, khan nakawng khawmdek ve nuk toek hy, ");
INSERT INTO hltthb_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","thawng ak tlakhqi a ko kqangnaak awi ce ngai peek aham ingkaw thih aham ami palh sak thlangkhqi ce loet sak aham.” ");
INSERT INTO hltthb_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Bawipang ming ce Zion awh kqawn na awm kawmsaw am kyihnaak ce Jerusalem awh awm kaw, ");
INSERT INTO hltthb_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","thlangkhqi ingkaw qamkhqi ing Bawipa bawk aham cawn kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Khaw ka sak pyngthym mai awh kak tha ni boek pe nawh; ka hqinglung ni tawi pe sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Cedawngawh kai ing, Aw ka Khawsa, ka hqing huili awh koeh ni lo valh; nang a kumkhqi taw cadil naa dyna ak awm ni. ");
INSERT INTO hltthb_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Ak cykca awh nang ing khawmdek pengnelhnaak sai tiksaw, khankhqi ce na kut ing sai na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Ceekhqi taw qeng hlai voei uh, nang taw awm poe kawp ti; cekkhqi taw hi amyihna se kawm uh. Bainaak amyihna thaw kawm tiksaw lawha boeih kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Cehlai nang taw amah toeng na awm poe kawp ti, nang a kumkhqi ingtaw a dytnaak awm am ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","A tyihzawihkhqi a cakhqi ce na haiawh awm kawm usaw; a cadilkhqi awm na haiawh cak poe hawh kawm uh.” ");
INSERT INTO hltthb_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Aw ka hqingnaak, Bawipa kyihcah lah; kak kawk khuiawh ak awmkhqi boeih aw, ang ming ciim ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Aw ka hqingnaak, Bawipa ce kyihcah lah, a zoseennaak ani peekkhqi boeih ce koeh hilh – ");
INSERT INTO hltthb_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","na thawlhnaakkhqi awh qeenkhaw ngai law nawh na tlawhnaakkhqi boeih ce qoei law sak hy, ");
INSERT INTO hltthb_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","lawk-kqawng khuina kawng na hqingnaak ce hul law nawh lungnaak, qeennaak ing ni sing hy, ");
INSERT INTO hltthb_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","na taithymnaak ce hu amyihna thai sak pan aham ik-oeih leek ingkaw na ngaihnaak ce sit law sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","thekhanaak ak hukhqi ham Bawipa ing dyngnaak ingkaw thymnaak ce sai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Mosi venawh a lamkhqi ce sim sak nawh, Israel thlangkhqi venawh a ik-oeih sai ce sim sak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Bawipa taw thlang qeenkhaw ak ngai ingkaw lungnaakkung na awm hy, kaw amak so nai, lungnaak ing ak be na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Anih thawlh ap puk khing kawmsaw, ak kawlung kumqui dy am so khing kaw; ");
INSERT INTO hltthb_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","ningnih a thawlhnaak ing ak tyng na nik khan awh ik-oeih am sai nawh sai thawlhnaak amyihna amni thung khqi bai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Khawmdek awhkawng khawnghi ce a sang soeih amyihna, amah ak kqihkhqi ham lungnaak taw bau soeih hy; ");
INSERT INTO hltthb_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","khawlaw ben ingkaw khawtlak ben a hla soeih amyihna, ningnih a thawlhnaakkhqi ce ak hla na ni khoe pek khqi valh hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Pa ing a cakhqi a lungnaak amyihna, amah ak kqihkhqi ce Bawipa ing lungna hy; ");
INSERT INTO hltthb_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","kawtih ikawmyihna ningnih ve sai na ni awm tice amah ing sim hy, dekvai nani ni awm uh tice amah ing sim loet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Thlanghqing aham taw, a hqing khui khawnghi ve qam amyihna ni a awm, qam a pai amyihna ni a awm; ");
INSERT INTO hltthb_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","khaw a hli awhtaw zawn bang nawh am awm voel hy, a awmnaak hun zani am sim voel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Cehlai Bawipa ak kqih thlangkhqi venawh taw a lungnaak ce kumqui coengawh kumqui dy awm poepa nawh, a dyngnaak ce a cakhqi a cakhqi petoe dyna awm pe hy – ");
INSERT INTO hltthb_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","a paipi amak hlepkhqi ingkaw ak awipeek ak sim loetkhqi taw cemyihna awm kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Bawipa ing a boei ngawihdoelh ce khan na caksak nawh, a qam ing khan boeih ce uk hy. ");
INSERT INTO hltthb_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Tha awm nawh ak awi ngai doena ak kawngaih ik-oeih ak sai peek, nangmih khan ceityihkhqi aw, Bawipa ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Amah ak kawngaih ak sai nangmih a tyihzawihkhqi ingkaw khan qalkapkhqi boeih aw, Bawipa ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","A uknaak hun boeih awhkaw a ik-oeih saikhqi aw, Bawipa ce kyihcah lah uh. Aw ka hqingnaak, Bawipa ce kyihcah lah. ");
INSERT INTO hltthb_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Aw ka hqingnaak, Bawipa kyihcah lah. Aw Bawipa ka Khawsa, nang taw bau soeih hyk ti; boeimang ypawmnaak ing thoeihcam qu hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Vangnaak ce hi amyihna bai nawh; khankhqi ce hi im amyihna phyl hy, ");
INSERT INTO hltthb_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","a awmnaak ak khan ipkaikhqi ce tuikhqik khan awh zilh ang hlakhqi awh ce ngawi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Zilh ce a ceityihkhqi na sai nawh; maikqawng ing mai ce a tyihzawih na sai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Khawmdek ve ang hangnaak hun awh hawih nawh, am thoeih qoe hy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Tuihdung ingkaw hi amyihna zawl malh nawh; tlangkhqi ak khan awh tui pha sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Cehlai nang ing na zyih a dawngawh tuikhqi cen nawh, nang a khawhum awi awh ang tawnna cen hy; ");
INSERT INTO hltthb_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","tlangkhqik khanna lawng unawh tuikawkhqi awh awm nung lawng uhy, a mingmih aham hun na qoek na bah peeknaak hun awh lawng uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Cekkhqi amang lawngnaak thai aham qamqi taak pe hyk ti; ityk awh awm khawmdek ve am leu voel tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Lawngsip awm sak nawh lawnghawi dung awh lawng sak hy; tlangkhqi anglakawh ce lawng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Qam awhkaw chukphakhqi boeih ce awk sak nawh; kqawng meqangkhqi ami tui ngaih sit hy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Khan nakaw phakhqi ing tuikeng awh bu sawn unawh; thingpangkhqi awh laa sa uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","A awmnaak aham im awhkawng tlangkhqi ce tui ing syp nawh; a bibinaak ak thaih ing khawmdek ve phoen phyi sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Khqin aham qam cawn sak nawh, thlanghqing aham tawihah anhah cawt sak hy – khawmdek awhkawng buh a an taak law pehy: ");
INSERT INTO hltthb_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","thlang ak kawlung ak zeel sak misur tui, haai a plangnaak aham situi, ak kawlung tha ak awm sak phaihpi ce pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Bawipa a thingkhqi, Lebanon awh amah ing ang lingkhqi ce khaw ing ak qui na syp hy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Cawh phakhqi ing bu sawn unawh, sidar a thing awh phungawkhqi ing im ta uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Tlang sangkhqi cetaw sangza sithai awmnaak hun na awm nawh; minpoengkhqi cetaw phihkhqi a awmnaak hun na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Hla ing khawcan sim nawh, khawmik ing a nung tlaak tym sim hy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Nang ing thannaak haw law tiksaw, khawmthan na coeng hy, cawh khqinkhqi lym ang hang uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Sendeihkhqi ing khqin a ai kawi tu aham ami ngaih awh kawk unawh, Khawsa venawh kawng ai sui uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Khawmik ang thoeng law awhtaw qeng sap uhy; a awmnaak lukkawk khuina voei unawh zaih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Cawh thlang ing bibi aham cet nawh, khawmy dy bi sai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Aw Bawipa, na bibi ve kqeng soeih mah hy! Cyihnaak ing vemyihkhqi boeih ve sai hyk ti; khawmdek ve na sai ik-oeih ing bengen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Ak kau soeih tuicunli awm awm nawh, noet noeng kaana a sai lumngakhqi ak zawi ak bau awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Cawh lawk baukhqi hu hai na cet unawh, cawh nang ing tuinga ang lymnaak khoek hun ce sai pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","A tym can awh nang ing buh na peek hly ce lamtoen doena nang ce ni toek uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Cekkhqi ce buh na peek awh, a mingmih ing cung hloep uhy, nang ing na kut nak thlek awh cekkhqi ing ik-oeik leek ing be uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Cehlai haai na thuh awh, mawn uhy; cekkhqi ang hqi ce na lawh peek valh awh, thi unawh dekvai na hlat uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Nang Myihla ce na tyih awh, a mingmih ce sai na awm unawh, nang ing khawmdek ce tlaih pan hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Bawipa a boeimangnaak taw kumqui dy awm poe seh; a bibinaak awh Bawipa taw zeel seh – ");
INSERT INTO hltthb_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","khawmdek toek nawh, tyn sak hy, tlangkhqi bi nawh khu sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Ka hqing khui pyt Bawipa venawh laa sa kawng nyng; ka hqing khui ka Khawsa kyihcahnaak laa sa vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Bawipa awh ka zeel lawt amyihna, kak kawpoeknaak ve a venawh zeelnaak na awm seh. ");
INSERT INTO hltthb_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Cehlai thlak thawlhkhqi taw khawmdek awhkawng cing baat u seitaw thlakchekhqi awm koeh awm voel u seh. Aw ka hqingnaak, Bawipa ce kyihcah lah. ");
INSERT INTO hltthb_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Bawipa venawh zeelnaak awi kqawn unawh taw, ang ming ce khy lah uh; a ik-oeih sai ce thlangphyn a venawh sim sak lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","A venawh laa sa unawh taw, am kyihcahnaak laa sa lah uh; kawpoek kyi ik-oeih a sai ce kqawn uh. ");
INSERT INTO hltthb_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Ang ming ciim boeimang seitaw; Bawipa ak suikhqi ak kawlung taw zeel seh. ");
INSERT INTO hltthb_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Bawipa ingkaw ak thaawmnaak ce sui u nawhtaw; a haai ce a poepa na sui lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","Kawpoek kyi ngaihak ik-oeih a saikhqi ingkaw awidengnaak ak kqawn ce sim poe lah uh, ");
INSERT INTO hltthb_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","a tyihzawih Abaraham a cadilkhqi aw, amah ing ak tyh Jakob cakhqi aw sim poe lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Anih taw Bawipa ningnih a Khawsa na awm hy; a awidengnaak taw khawmdek boeih ak khan awh awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","A paipi ce kumqui dyna sim poe nawh, ak awipeek ce, cadil naa thong oet dyna sim poe hy, ");
INSERT INTO hltthb_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Abraham ing ani awk haih paipi ing Isak a venawh awi a taak ce sim khak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Ce ak awi ce awitlyh a myihna Jakob a venawh caksak nawh, Israel a venawh kumqui paipi na tahy: ");
INSERT INTO hltthb_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","Kanan qam ce ni pe kawng nyng saw na taham qo amyihna pang kawp ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Thlangmi ami zawica awh, ak zawica tloek ce, qam khuiawh khin na awm hy, ");
INSERT INTO hltthb_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","phyn pynoet ingkaw pynoet a venawh, qam pynoet ingkaw pynoet a venawh pla khing uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","U ingawm cekkhqi ce am thekha nak khqi uhy; a mingmih awh sangpahrangkhqi ce toel hy: ");
INSERT INTO hltthb_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Situi ak sypkhqi ve koeh bi kawm uk ti; ka tawnghakhqi awm nganbawh koeh pe qoe qoe kawm uk ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Ram khuiawh khawseet khawkha pha sak nawh cekkhqi a buh boeih ce hqe pehy; ");
INSERT INTO hltthb_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","cekkhqi haiawh thlang pynoet – tamnaa na ami zawih Joseph ce tyih pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","A khaw awh khawcehkhqi byn pe unawh, a hawng awh thi quikhqi ing khit uhy, ");
INSERT INTO hltthb_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","amah ing ak kqawn oepchoeh ce a soep hlan khui, Bawipak awi ing ak thym ce a sim sak hlan dy cemyihna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Sangpahrang ing thlang tyi nawh loet sak hy, thlang kqeng ak ukkung ing anih ce loet sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Anih ce ipkhui awh boei na ta nawh, a taak ik-oeihkhqi boeih ak khan awh ukkung na tahy, ");
INSERT INTO hltthb_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","boei capakhqi ce a ngaih amyihna cawngpyi aham ingkaw, a hqamcakhqi cyihnaak cawngpyi aham cemyihna awm sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Cekcoengawh Israelkhqi ce Izip ram na kun hy; Ham ram awh khin na Jakob ce awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Bawipa ing ak thlangkhqi ce ak thaih qah sak hy; a qaalkhqi ham khawzah na coeng sak hy, ");
INSERT INTO hltthb_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","amah ak thlangkhqi sawhnaak aham cekkhqi ak kawlung ce hawi pe nawh, a tyihzawihkhqi ce huhqyt sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","A tyihzoeih Mosi ingkaw ak thlang tyk Aaqon ce tyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Cekkqawi ing cekkhqing lak awh kawpoek kyi hatnaak ingkaw ngaihak ik-oeih ce Ham qam awh sai pe hy nih. ");
INSERT INTO hltthb_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Thannaak ce tyi pe nawh rampum awh khaw than sak hy – kawtih ak awi ce cekkhqi ing am eek pehy na ti nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Tuikhqi ce thi na thoeng sak nawh, ngakhqi thih pe sak kang hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","A ram khuiawh ta-ukhqi da pe sak nawh a boeikhqi a ihkhunkhqi dyna awm pe sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Awi kqawn pe tlaih bai nawh, pikhqi law pe khung bai hy, a rampum awh hlip hqoeng na be sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Khawtlan ce qeel na thoeng sak nawh, a rampum awh khaw phla pe sak hy; ");
INSERT INTO hltthb_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","misurkungkhqi ingkaw thaikungkhqi deh pe kanglak nawh a qam khuiawh kaw thingkhqi tluk pe sak boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Awi kqawn tlaih bai nawh, cawh boeikhqi ce law uhy, noet noeng kaana khamkhawkkhqi ce doem hy; ");
INSERT INTO hltthb_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","a qam khuiawh kaw thinghah ai pe kanglak nawh dek awh ak cawt tawi a an ai pe kang hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Cekcoengawh a ram khui awhkaw cakcyk boeih ce him pehy, thlanghqing ak thaihcykkhqi boeih ce him pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Sui ingkaw ngun phyih sak nawh, Isarel ce cawn sak hy, a pilnam khuiawh tha amak awm pynoet awm am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Israel a dawngawh cekkhqi ak khan awh kqihnaak a pha a dawngawh, cekkhqi ami ceh awh Izipkhqi amik kaw zeel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Cekkhqi ak dah aham myi zam sak hy, than awh vangnaak ak pe na mai pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Cekkhqi ing ami thoeh awh, tytyt pe nawh khan nakaw phaihpi ing ak phoenkhqi phyi pe sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Lungnu awng nawh tui thoeh pe sak hy; kqawng qamkoh awh tuiva a myihna lawng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","A tyihzawih Abaraham a venawh a peek a awitaak ciim ce sim khak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Zeel doena ak thlangkhqi ce ceh pyi nawh, ak tyh thlangkhqi ce awmhly khynaak ing hqui a sawi hy; ");
INSERT INTO hltthb_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","thlangphyn khqi a ram ce cekkhqi venawh pehy, thlak chang ing a bi a lawh ce ram ce qo na pang uhy – ");
INSERT INTO hltthb_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","a mingmih ing ak awipeekkhqi ce hquut unawh a cawngpyinaak awikhqi ce ami hquutnaak thai aham cekkhqi ce sai pehy. Bawipa taw kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Bawipa taw kyihcah lah uh. Bawipa taw a leek a dawngawh, a venawh zeelnaak awi kqawn lah uh; a lungnaak awm kumqui dyna cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","U ing Bawipa ak thaawm ik-oeih sai ce kqawn thai nawh a kyihcahnaak ce ak kqawn thai boeih kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Ik-oeih thym ce sai phat nawh, ik-oeih thym ce ak sai phatkhqi taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Aw Bawipa nak thlangkhqi venawh nak kaw a law awh kai awm koeh nim hilh, cekkhqi ce na hul awh kai anik hulkung law lawt seh, ");
INSERT INTO hltthb_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","nak tyh thlangkhqi a zo awmnaak ce pang lawt kawng nyng saw, na pilnamkhqi a zeelnaak ce ka bawm coengawh namah kyihcah doena ka qo ce pang thai lawt kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Ka pakhqi ami thawlh amyihna, kaimih awm thawlh unyng; ik-oeih sai thawlh unyng ak che soeih na sai unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Ka pakhqi Izip qam awh ami awm awh, nang ak kawpoek kyi ik-oeih saikhqi ce ikaw na awm am poek unawh; nam qeennaak khawzah ce am sim voel uhy, tuicunli keng awh, Tuicunli Sen awh oelh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Cehlai amah ak thaawm ik-oeih sai thainaak ce ang dang thainaak aham ang ming ak caming cekkhqi ce hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Tuicunli Sen ce zyi nawh kak qup hy; cekkhqi ce qamkoh awhkaw amyihna tuihdung khuiawh kawng hquisawi poe hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","A thunkhakhqi kut awhkawng hul nawh; a qaalkhqi kut awhkawng thaawng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Tui ing a qaalkhqi ce sing khup nawh; pynoet awm am loet uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Cawh ak awikamnaak ce cangna unawh amah kyihcahnaak laa ce sa uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Cehlai iqyt awm a dii hlanawh ik-oeih a sai peekkhqi ce hilh nawn bai unawh am cuk kiknaak awm am sim voel bai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Qamkoh awh a mimah a ngaihnaak awh pe qu unawh; khawkpawng awh Khawsa ce noek a dak uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Cedawngawh cekkhqi ing a thoeh ce pehy, cehlai pimqep tlawhnaak ce pha pe sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Hi im awh Mosi ingkaw Bawipa venawh nawn na ak awm Aaron ce yt uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Khawmdek ing ang nawh Dathan ce daih hy; Abiqam a pyikhqi ce pup malh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","A hubatkhqing lak awh mai kqawng pung nawh, maikqawng ing thlakchekhqi ce ui boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Horeb awh vaitaw ca sai unawh cawhkaw myi thi ing ami hloi ce bawk uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","A mimah a boeimangnaak ce qam ak ai vaitaw myi ing thung uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Izip qam awh ik-oeih ak bau soeih sai nawh a mingmih ak hulkung Khawsa ce hilh uhy; ");
INSERT INTO hltthb_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","anih ing Ham qam awh kawpoek kyi ik-oeihkhqi sai nawh Tuicunli Sen keng awh kqih awm ik-oeih ce sai pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Ce a dawngawh a mingmih ama seetnaak aham ak kawsonaak sit sak aham, amah ak thlang tyh Mosi mah a kunnaak hly kawi awh ama nang dyih khoep mantaw cekkhqi ce plawci sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Qam leek soeih mai ikaw na am hu unawh; ak awikamnaak awm ap cangna uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","A mimah a hi imkhqi awh kawso unawh Bawipak awi ce am ngai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Cedawngawh cekkhqi ce qamkoh awh tluk sak aham a kut phyl nawh tuui khyn hy, ");
INSERT INTO hltthb_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","a cadil naakhqi ing phynlum kut awh tlu unawh qampum awh a thek a zak na ami awmnaak aham tuui khyn sih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Peor awhkaw Baal benna hawi qu lat nawh, hqingnaak amak ta khawsakhqi venawh ami nawn lucik buh a ankhqi ce ai uhy; ");
INSERT INTO hltthb_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","ik-oeih che sainaak ingkaw Khawsak kawsonaak ce ami sai a dawngawh, a mingmih anglakawh tlawhnaak ce tlung pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Cehlai Phinehas ce tho nawh cekkhqing lak awh ang dyih a dawngawh tlawh khap qu dup hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Vawhkaw ik-oeih a sai awh anih ak law hly kawi amak dyt qoe cadil naa dy ing thlakdyng na kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Meribah a tuihkawng awh Bawipa kawso sak unawh, cekkhqi dawngawh Mosi a venawh kyinaak pha pehy; ");
INSERT INTO hltthb_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Khawsa Myihla ce amim tu a dawngawh, Mosi a hui awhkawng poek kaana awi thoeng tara hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Bawipa ing awi a peeknaak amyihna, cekkhqi ing thlangkhqi cetaw am plawci sak uhy, ");
INSERT INTO hltthb_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","cehlai phyn chang thlangkhqi mi kqit qu unawh cekkhqi a singzoe ce oet uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","A mimah aham dawng na amik dun qu, thlakchang a myiqawl ce bawk uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Qaai a venawh a capakhqi ingkaw a canukhqi ce lucik bulnaak na pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Thawlhnaak amak awm a capakhqi ingkaw a canukhqi a thi ce Kanankhqi a myiqawl ami bawknaak awh thoeh sak unawh, thi ingkaw qam ce tyih ak awm na sai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","A mimah ingawm ik-oeih sai ing tyih awm sak uhy; a ik-oeih sainaak ing pup zawi na coeng uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Cedawngawh Bawipa taw ak thlangkhqik khan awh ak kawso nawh ak qo ak pang hly kawikhqi ce tyih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Cedawngawh cekkhqi ce thlangphyn khqi kut awh pe nawh, a qaalkhqi ing uk khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","A qaalkhqi ing thekha nak khqi nawh a saithainaak ak kaiawh tak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Cekkhqi ce hul khqi khing hawh hlai hy, amah ce ami tuk lat lat a dawngawh a mimah a thawlhnaak awh cum uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Cehlai cekkhqi ang kqangnaak awi ce ang zaak awh ami khuikhanaak ce ngai na bai hy; ");
INSERT INTO hltthb_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","cekkhqi ce ak poek awh a paipi sai ce poek tlaih nawh a lungnaak bau soeih awh hul qu tlaih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","A mingmih tamnaa na ak sawikungkhqi ce qeen sak khqi nawn hy. ");
INSERT INTO hltthb_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Nang ming ciim awh zeelnaak awi ka mik kqawn thainaak aham, Aw Bawipa kaimih a Khawsa, kaimih ve ni hul khqi nawhtaw, qampum awhkawng ni cunboem khqi tlaih lah. ");
INSERT INTO hltthb_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Bawipa, Israelkhqi a Khawsa venawh kumqui coeng kumqui dy kyihcahnaak awm seh. Thlang boeih ing, “Amen!” ti seh. ");
INSERT INTO hltthb_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Bawipa taw a leek a dawngawh a venawh zeelnaak awi kqawn lah uh; a lungnaak awm kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Bawipa a hul thlangkhqi ing ve ve kqawn seh – qaal a kut khuiawh kawng a hul thlangkhqi, ");
INSERT INTO hltthb_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","qampum awhkawng a cunboem thlangkhqi, khawlaw khawtlak, a sip a hawt awhkaw thlangkhqi boeih ing kqawn seh. ");
INSERT INTO hltthb_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Thlang vang taw khawkpawng qamkoh awh pla unawh, ami awmnaak hly kawi awm am hu uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Phoen cawi tui ngaih unawh zai doek doek hqoeng uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Cemyihna ami khuikha awh Bawipa venawh kqang uhy, anih ing cekkhqi ce ami khuikhanaak awhkawng hul khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Anih ing cekkhqi awmnaak hly kawi khawk bau lam dyng awh ce hqui a sawi phat hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","A lungnaak amak dyt thai ing thlangkhqi ham kawpoek kyi a ik-oeih sainaak awh cekkhqi ing Bawipa venawh zeelnaak awi kqawn u seh, ");
INSERT INTO hltthb_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","kawtih tui ak ngaih ce tui ngaih sit sak nawh phoen ak cawi ce ik-oeih leek buh ing phoen phyi sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Thlang vang taw thannaak a hyp tit khuiawh ngawi unawh, kenqui qui ing thawng tla uhy, ");
INSERT INTO hltthb_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Ikawtih cekkhqi ing Khawsak awikhqi ce hilh unawh Sawsang soeih ak awi ynaak ce ikaw na am hu uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Cedawngawh cekkhqi ce bik tlo bi sak khqi hy; bah hlai uhy, ak leng hly kawi u am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Kyinaak ami huhnaak khui awhkawng Bawipa venawh khy uhy, cawh anih ing khuikhnaak khui awhkawng cekkhqi ce hul khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Cekkhqi ce than a hypnaak awhkawng sawi law nawh kenquikhqi ce hlam pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","A lungnaak amak dyt thai ing thlangkhqi ham kawpoek kyi ik-oeih a sainaak awh cekkhqi ing Bawipa venawh zeelnaak awi kqawn u seh, ");
INSERT INTO hltthb_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","kawtih anih ing qawhum chawh ce hqe nawh a kalhnaak thiboeng awm ek pe sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","A mimah ang hqohqitnaak awh a vang taw qaw unawh, awm tloei tlawhnaak awh khuikha boeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Buh a an boeih tyih unawh thihnaak chawmkeng benna thoeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Kyinaak ami huh awh Bawipa venawh kqang unawh khuikhanaak khui awhkawng cekkhqi ce hul khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Ak awi ce tyi nawh cekkhqi ce qoei sak hy; phyi ak khui awhkawng cekkhqi ce hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","A lungnaak amak dyt thai ing thlangkhqi ham ik-oeih leek a sai a dawngawh Bawipa venawh zeelnaak awi kqawn u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Zeelnaak ik-oeih ce nawn u seitaw zeelnaak laakhqi ing a ik-oeih sainaak ce kqawn u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Ak changkhqi taw tuicun awh lawng ing cet uhy; tuibau awh ik-oeih ak zawikhqi na awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Cekkhqi ing Bawipa a sai ik-oeih, tuihdung khuiawh ak sai ik-oeihkhqi ce hu uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Ikawtih awi kqawn nawh khaw hli sak hy, ce ing tuinu ak sang na thawh sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Khawnghi dyna hang tho nawh tuihdung khuina nung tla tlaih hy; kqih a awm aih a dawngawh a qaal leeknaak ce sauh pung hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Zukquikhqi amyihna a kenghal na cet unawh; a cyihnaak a dytnaak awh plal pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Kyinaak ami huh awhtaw Bawipa venawh kqang unawh, khuikhanaak khui awhkawng cekkhqi ce hqui a sawi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Khawhli ce zilh na sit sak nawh; tuicunli awhkaw tuinu ce dym sap uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","A ming dym sap awh zeel uhy, cawh ang cainaak tuikeng na cekkhqi ce sawi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","A lungnaak amak dyt thai ing cekkhqi ce, thlangkhqi hamna kawpoek kyi ik-oeih a saikhqi awh Bawipa a venawh zeelnaak awi kqawn u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Thlang kqeng a cunnaak awh anih ce zoeksang unawh taw a hqamcakhqi amim cunnaak awh kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Anih ing longkhqi ce qamkoh na coeng sak nawh, lawngca awhkawng ce cengdek na coeng sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Ce hun awh ak awm thlangkhqi a seetnaak awh, lunglai ak leek soeih ce sihtui cidek na coeng sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Qamkoh ce tui ing be sak hamna ak koh hun awhkawng tui thoeng sak bai hy; ");
INSERT INTO hltthb_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","cawh phoen ak cawikhqi ce awm sak khqi nawh, cekkhqi ami awmnaak hly khaw ce syn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Lokhqi toen unawh misur thingkhqi ling uhy, ak thaihkhqi qah pehy; ");
INSERT INTO hltthb_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","cekkhqi ce zoseennaak pe nawh, pung a tai uhy, ak khqinkhqi awm am zawitlak pe sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Cekcoengawh taw huhsitnaak, khuikhanaak ingkaw kawseetnaak awh thlangmi ce zawi hqui voe voe unawh, ak kaidyt na awm bai uhy; ");
INSERT INTO hltthb_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","thlakbaukhqik khan awh khawsi ak qawnkung ing cekkhqi ce khawkpawng lam ama awmnaak awh pla sak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Cehlai anih ing khawdeng thlangkhqi ce hak zoeksang nawh tukkqeng amyihna a ipkhui cakawkhqi ce kqeng sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Thlakdyng ingtaw hu nawh zeel hlai hy, thlakchekhqi ingtaw amim kha mym khoep uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","U awm ak cyi ingtaw, ve ik-oeihkhqi ce poek seitaw Bawipa a lungnaak bau soeih ve poek seh. ");
INSERT INTO hltthb_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Aw Khawsa, kak kawlung ve cak hy; ka hqingnaak boeih ing tingtoeng tum doena laa sa kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Tingtoeng ingkaw qaw tingtoeng nang hqak lah nih! Myncang hi awh thawh na lah vang! ");
INSERT INTO hltthb_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Phynlum thlangkhqing lak awh, Aw Bawipa, nang ce nim kyihcah vang; thlangkhqing lak awh nang laa na ni sa vang. ");
INSERT INTO hltthb_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Ikawtih na lungnaak taw bau nawh, khan anglakawh sang khqoet hy; na ypawmnaak ing khawnghi hak pha hy. ");
INSERT INTO hltthb_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Aw Khawsa, khankhqi ak khan na hak zoeksang qu lah, khawmdek boeih ak khan awh na boeimangnaak awm lah seh. ");
INSERT INTO hltthb_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Na lungnaak thlangkhqi hul na a awmnaak thai aham nak tang kut ing kaimih ve ni hul khqi nawh ni bawm khqi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Khawsa ing a hun ciim awhkawng awi kqawn hawh hy: “Noengnaak ingkaw Shqekem ce qek ang ra kawng nyng saw Sukoth Tuikawk ce tah vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Gilead ve kai a koe ni; Ephraim ve ka thi lumyk na awm nawh Judah ve ka cawnghqawl na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Moab khaw ka silhnaak beihdung na awm nawh, Edom qam khawmyk ka suhnaak; Philistia qam khan awh noengnaak ing khy nyng.” ");
INSERT INTO hltthb_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Vawngcak ingkaw thingtung khawk bau khui na u ing nu kai a ni kun pyi kaw? U ing Edom qam na ani ceh pyi kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Aw Khawsa, kaimih ni qoeng khqi tiksaw kaimih a qalkapkhqi mi amak cet haih qoe voel ce nang am nu? ");
INSERT INTO hltthb_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Qaal ka mi tuk awh nang ing ni bawm lah, thlanghqing a bawmnaak taw phu am tahy. ");
INSERT INTO hltthb_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Khawsa ingqawi taw ni noeng mare kaw, amah ing ni qaalkhqi ce leh law kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Kai ing kam kyih, Aw Khawsa, awi myhna koeh awm hqoeng, ");
INSERT INTO hltthb_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","kawtih thlakchekhqi ingkaw thlak thaikhqi ing amim kha ni ang sih khqi nawh; ami qaai ce kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Sawhnaak awi ing nik chung khqi nawh, akawng a awm kaana ni tuk khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Ka pyi na ka taaknaak ce thawlh puknaak na haw law na uhy, cehlai kai taw ak cykcah thlang na awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","A leek ce ak che ing thung law unawh, pyi na ka taaknaak cesawhnaak ing thung law uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Anih ak oelh aham thlakche ce taak pe tloep; thawlh a pukkung ce ak tang ben awh pha seh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Awideng na a awm awh, dawk lo seitaw, ak cykcahnaak ing dawk sak seh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","A hqinglu tawi pe seitaw; thlakchang ing hquikung dyih hun ce qawt pe tloep seh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","A cakhqi cadah na awm u seitaw a zukhqi nuhai na awm u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","A cakhqi ing kut dun doena van u seitaw; a imqawk awhkawng hqek na awm u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Ik-oeih a capung na ak pukhqi ing a khawhthemkhqi ce lawh pe boeih u seitaw; a bibinaak phu ce khinkhqi ing muk pe bang seh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","U ingawm koeh qeen seitaw pa amak ta naasenkhqi awm koeh qeen u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","A cadil naa ce law boet seitaw, ak law hly kawi chawn awhkaw ming khui awhkawng qeng u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Ami pakhqi thawlhnaak ce Bawipa hai awh sim loet na awm seitaw ami nu a thawlhnaak ce koeh qeng voel seh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Cekkhqi sim loetnaak ce khawmdek awh a law boetnaak aham a mingmih a thawlhnaak ce Bawipa haiawh awm loet seh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Ikawtih qeennaak tive poek awm ap poek qoe qoe hy, khawdeng ak voet hlauhkhqi ingkaw kawlung ak kqekkhqi ce him aham hqut hy. ");
INSERT INTO hltthb_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Lihoei ce lungna hy – amah ak khan awh tla tloep seh; thlang a zoseennaak awh ak kaw am law hy – zoseennaak ce anih a venawh kawng ak hla na awm lawt seh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Lihoei ce hi na bai nawh; a pum khuiawh tui amyihna kun pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Ce ing angki amyihna zawl khak seitaw cawi pinnaak amyihna kumqui dy pin seh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Kai thawlh anik puk khqi ingkaw, kai ak che na anik kqawnkhqi a venawh Bawipa ing ve ve thaphu na pe seh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Cehlai, Aw Boeimang Khawsa, nang ing nang ming ak caming ak leek na ni sai nawh; na lungnaak ak leek ak caming ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Khawdeng ingkaw voethlauh thlang na awm nyng saw, kak kawk khuiawh ak lingbyi ing ngawha ai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Khawmy ben awhkaw khawngkawn amyihna nung thoeih hawh nyng saw; khamkhawk amyihna tlai let let nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Buh ka hyhnaak awh kam khawkhlu qawi am cak voel hy; kang sak boeih qep qep nawh a tankqat na awm hqoeng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Thawlh anik puk khqi ak kqawnseet aham awm kqoeng nyng saw; a mini huh awh ami lu hil uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Aw Bawipa ka Khawsa, ni hul lah; na lungnaak ak caming ni hul cang lah. ");
INSERT INTO hltthb_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Ve ve nang a kut ni tice sim sak nawh, Aw Bawipa, nang ing ni na sai tice sim sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Cekkhqi ing khawseet hly hlai uhy, nang ingtaw zoseen pe hyk ti; cekkhqi ing ami tuk awh chah phyi kawm uh, cehlai nang a tyihzawih taw zeel kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Kai thawlh anik puk khqi taw ming seetnaak ce hi amyihna bai kawm u saw chahnaak ing angki amyihna zawl qu khoep kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Kam kha ing Bawipa ce khawzah na zoeksang kawng nyng saw; thlang kqeng khawzah anglakawh amah kyihcah kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Ikawtih anik palh sak khqi a venawh kawng anih a hqingnaak ce hul peek aham anih taw ak voethlauhkhqi ak tang ben awh dyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Bawipa ing Ka Bawipa a venawh: “Na qaalkhqi ce na khaw tloengnaak na ka sai hlan dy kak tang benawh ngawi lah,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Bawipa ing nang a sawnghqawl thakawm ce Zion awhkawng hul law kawmsaw, na qaalkhqing lak awh nang ing uk kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Na qalkapkhqi ing na qaal tuknaak khawnghi ce ngaih kawm uh. Ak ciim qypawmnaak ing thoeihcam qu nawh; mymcang phoen khui awhkawng ak thoeng law dam tui amyihna thak awm thym ce hu kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Bawipa ing awi a sa hawh a dawngawh am thaw voel kaw: “Melkhizadek amyihna nang taw kumqui khawsoeih na awm hyk ti,” tihy. ");
INSERT INTO hltthb_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Bawipa taw nak tang ben awh awm nawh; ak kaw a sonaak nyn awh sangpahrangkhqi ce tun kqai khqi boeih kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Anih ing phynlum awideng kawmsaw, thlang a qawk ce a qawn kyng coengawh khawmdek pum awhkaw a lukhqi ce phep khqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Lamkeng awhkaw lawngca tui ce aw kawmsaw, a lu ce hak zoek kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Bawipa taw kyihcah lah uh. Thlak dyng cunnaak ingkaw thlang kqeng cunnaak awh Bawipa ce kak kawlung boeih ing zoeksang kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Bawipa a ik-oeih saikhqi taw bau soeih hy; ce mihkhqi ce ak ngaih boeih ing poek hqeet uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Boeimangnaak ingkaw qypawmnaak boeih ve amah a sai boeih na awm nawh, a dyngnaak awm kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Sim loet aham kawpoek kyi ik-oeihkhqi ce awm sak hy; Bawipa taw thlang qeenkhaw ak ngai ingkaw qeennaak kawpoek ing be hy. ");
INSERT INTO hltthb_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Amah ak kqihkhqi venawh ai kawi pe nawh; a paipi ce sim poepa hy. ");
INSERT INTO hltthb_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","A ik-oeih sainaak ce ak thlangkhqi venawh dang sak nawh, thlakchang qam ce cekkhqi venawh pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","A kut sai ik-oeihkhqi ce a ypawm nawh dyng hy; awipeekkhqi awm yp a awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Ueppawmnaak dyngnaak ing a sai a dawngawh, cekkhqi taw kumqui ing kumqui dy cak poe hy, ");
INSERT INTO hltthb_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Ak thlangkhqi ham hulnaak ce pe nawh; a paipi ce kumqui dy caksak hy – ang ming taw ciimcaih nawh kqih awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Bawipa kqihnaak taw cyihnaak a kung na awm hy; ak awipeek ak hqutkhqi boeih taw zaksimnaak leek ta uhy. Khaw kum khaw hqai kyihcahnaak taw amah a koe ni. ");
INSERT INTO hltthb_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Bawipa taw kyihcah lah uh. Bawipa kqih nawh ak awipeekkhqi awh zeelnaak ak takhqi taw ami zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","A cakhqi qam khuiawh thlak bau na awm kawm usaw; thlakdyngkhqi a cadil taw ami zoseen kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Boeinaak ingkaw mangnaak taw a ipkhui awh awm kawmsaw, a dyngnaak ce kumqui dy awm loet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Thlang qeenkhaw ak ngai lungnaak ak ta thlak dyngkhqi ham taw, thannaak awh zani vangnaak awm pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Boecawn naak ing a zoena thlang pu nawh ak thym na khaw ak sakhqik khan awh ik-oeih leek pha law kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Anih ce ityk awh awm am tat tikaw; thlak dyng taw kumqui dy u ing am hilh tikaw. ");
INSERT INTO hltthb_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Awithang che awh kqihnaak am ta kaw; ak kaw cak nawh, Bawipa ce ypna hy. ");
INSERT INTO hltthb_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Ak kawlung yp nawh, kqihnaak am tahy; a dytnaak awhtaw a qaalkhqi ce noengnaak ing toek kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Khawdeng hahqahkhqi venawh kutdo a qek a ra a dawngawh, a dyngnaak ce kumqui dy cak hy; ak ki ce zoeksangnaak ing kyih na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Thlakche ing a huh awh ak kaw am zeel kaw; a ha taak kawmsaw plal a tham pahoei kaw; thlakchekhqi a ngaihnaak taw dyt hqoeng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Bawipa taw kyihcah lah uh. Aw Bawipa a tyihzawihkhqi aw, kyihcah lah uh, Bawipang ming ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Tuh kawng kumqui dyna Bawipang ming taw kyihcah na awm seh. ");
INSERT INTO hltthb_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Khaw a law cyk awhkawng a nung tlak dy na, Bawipang ming taw kyihcah aham awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Bawipa taw qamtawm ak khan awh a boeimangnaak ce awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Hun sang na boei ngawihdoelh awh ak ngawi Bawipa ningnih a Khawsa amyihna u nu awm nawh, ");
INSERT INTO hltthb_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","khankhqi ingkaw khawmdek dan aham anih amyihna anuk balak law u nu ak awm? ");
INSERT INTO hltthb_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Khawdeng thlang ce dekvai awhkawng thawh nawh ak voet hlauhkhqi ce maivyt awhkawng thawh hy; ");
INSERT INTO hltthb_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","cekkhqi ce sangpahrang a cakhqi, a mimah ak thlangkhqi a sangpahrang a cakhqi ing ngawih sak haih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Ca ak qeng nu ce cakhqi ak ta ak awmhly nu na tahy. Bawipa taw kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Izip qam awhkawng Israel a law awh, qapchang amsim awi ak paukhqi a venawh kawng Jakob ipkhuikaw a law awh, ");
INSERT INTO hltthb_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Judah ce Khawsa hun ciim na coeng nawh, Israel ce amah a ukkung na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Tuicun ing toek nawh cen hy, Jordan tui a hu na hlat tlaih hy; ");
INSERT INTO hltthb_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","tlangkhqi ing tumcaikhqi amyihna, tlangkhqi ing tuucakhqi amyihna pet doep doep uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Aw tuicun nang, kawtih cen nawh, Aw Jordan long nang, kawtih hu na nang hlat tlaih, ");
INSERT INTO hltthb_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","nangmih thlangkhqi, kawtih tumcaikhqi amyihna, nangmih tlangkhqi, kawtih tuu cakhqi amyihna naming pet doep doep? ");
INSERT INTO hltthb_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Aw khawmdek, Bawipa haiawh, Jakob Khawsa haiawh thyn lah, ");
INSERT INTO hltthb_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","anih ing lungnu ce tui im na coeng sak nawh, lunkqil ce lawngca tui na lawng sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Kaimih a venawh kaana, Aw Bawipa, kaimih a venawh kaana, na lungnaak ingkaw na yp awmnaak awh namah ang ming a venawh boeimangnaak awm seh. ");
INSERT INTO hltthb_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Ikawtih thlangphyn khqi ing, “A mingmih a Khawsa hana a awm?” a mi ti. ");
INSERT INTO hltthb_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Ningmih a Khawsa taw khawk khan na awm nawh, amah ak kaw ak zeel sak boeih ce sai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Cehlai a mingmih a myiqawlkhqi taw thlanghqing a kut ing sai na ak awm sui ingkaw ngun khqi mai ni. ");
INSERT INTO hltthb_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","A mim kha taw ta lawt hlai uhy, am pau thai uhy; mik awm ta lawt hlai uhy, am hu thai uhy; ");
INSERT INTO hltthb_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","haa ta lawt hlai uhy, am za thai unawh, haqawng awm ta lawt hlai uhy, a baw am za uhy; ");
INSERT INTO hltthb_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","kutkhqi ta hlai uhy, am bi thai uhy, khaw awm ta hlai uhy, am cet thai uhy; amik awiqawng ing ikaw awm ap kqawn thai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Vemih ak saikhqi taw vemyih khqi amyihna awm lawt kawm uh, vemyih ak ypnaak thlangkhqi boeih awm vemyih khqi amyihna awm lawt kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Aw Israel ipkhuikaw, Bawipa ypna lah, anih taw cekkhqi ak hulkung ingkaw – cekkhqi a phuhqa na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Aaron ipkhuikaw aw, Bawipa ypna lah – anih taw cekkhqi a hulkung ingkaw phuhqa na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Amah ak kqihkhqi aw, Bawipa ypna lah, anih taw cekkhqi ak hulkung ingkaw cekkhqi a phuhqa na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Bawipa ing ningnih ani sim khqi loet a dawngawh zoseennaak ni pe kaw: Israel ipkhuikaw ce zoseennaak pe kaw, ");
INSERT INTO hltthb_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","anih ing Bawipa ak kqihkhqi ce zoseennaak pe kaw – ak zawi awm ak bau awm. ");
INSERT INTO hltthb_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Bawipa ing namah ingkaw na cakhqi ce pung a tai sak seh. ");
INSERT INTO hltthb_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Khan ingkaw dek ak saikung Bawipa ing zoseennaak ni pek khqi seh. ");
INSERT INTO hltthb_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Ak sang soeih khankhqi ce Bawipa koe na awm nawh, khawmdek ve thlanghqing a kut awh pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Ak thi khqi dek khui ihnaak na anuk cet khqi ing Bawipa am kyihcah uhy; ");
INSERT INTO hltthb_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","ningnih ing ni tuhngawi awhkawng kumqui dyna Bawipa ve ni zoeksang uh. Bawipa taw kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Kak awi ang zaak a dawngawh, Bawipa lungna nyng; qeennaak thoeh doena kang kqangnaak awi za hy. ");
INSERT INTO hltthb_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Ang haa ce kai benna ang keng law a dawngawh, ka hqing khui pyt amah ce khy vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Thihnaak qui ing ni zen nawh, phyi khuikhanaak ce kak khan awh law hy; kyinaak ingkaw kawseetnaak ing ni noeng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Cawh Bawipang ming ce khy nyng: “Aw Bawipa ni hul cang lah!” ti nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Bawipa taw qeennaak ing be nawh dyng hy; ningnih a Khawsa taw lungnaak ing ak be na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Bawipa ing thlankqawng ce chung ak dah nawh; ka ngoe awh kai ce ni hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Aw ka hqingnaak vai awh dyi tlaih bai cang lah, kawtih Bawipa taw na venawh leek hy. ");
INSERT INTO hltthb_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Aw Bawipa, nang ing ka hqingnaak ve thihnaak awhkawng, ka mik qawi ve mikphli awhkawng, ka khaw qawi ve bahnaak awhkawng hul hawh hyk ti, ");
INSERT INTO hltthb_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","cawhtaw ak hqingkhqi qam na Bawipa haiawh cet hawh kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Cangna nyng; ce a dawngawh, “A boena khuikha nyng,” ti nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Lylap nyng kqih doena, “Thlangkhqi boeih ve qaai ak kqawn khqi boeih ni,” ti nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Ka venawh a leeknaak boeih awh vawh Bawipa ve ikawmyihna ka peek tloep lawt lah voei? ");
INSERT INTO hltthb_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Thaawngnaak boet ve hak soeng nyng saw Bawipang ming ce khy kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Ak thlangkhqi boeih a haiawh Bawipa venawh awi ka sa ce soep sak vang. ");
INSERT INTO hltthb_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Bawipa mik huh awh a phu ak tlo soeih taw ak thlang ciimkhqi thih ve ni. ");
INSERT INTO hltthb_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Aw Bawipa, kai ve na tyihzawih tang tang ni; kai taw na tyihzawih, na tyihzawih nu a ca na awm nyng; nang ing kenqui qui ce hlam law hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Zeelnaak awi kqawn lucik bulnaak ce na venawh nawn nyng saw Bawipang ming ce khy kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Ak thlangkhqi boeih a haiawh Bawipa venawh awi ka sa ce soep sak vang. ");
INSERT INTO hltthb_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Bawipa ipkhui kawngma awh – Aw Jerusalem, nang lak lung awh soep sak vang nyng. Bawipa taw kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Nangmih thlangphyn boeih aw, Bawipa ce kyihcah lah uh; nangmih thlangkhqi boeih aw, amah ce zoeksang lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Ikawtih ningnih ani lungnaak taw bau soeih nawh, Bawipa a ypawmnaak taw kumqui dy cak hy. Bawipa taw kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Bawipa taw a leek a dawngawh, a venawh zeelnaak awi kqawn lah uh; a lungnaak awm kumqui dyna cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Israel ing, A lungnaak taw kumqui dyna cak hy,” ti seh. ");
INSERT INTO hltthb_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Aaron ipkhuikaw ing: A lungnaak taw kumqui dy cak hy,” ti seh. ");
INSERT INTO hltthb_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Bawipa ak kqihkhqi boeih ing, A lungnaak taw kumqui dy cak hy,” ti seh. ");
INSERT INTO hltthb_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Ka khuikha awh Bawipa venawh khy nyng saw, amah ing hoelpoeng na awmnaak ing nim hlat hy. ");
INSERT INTO hltthb_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Bawipa taw ka venawh a awm a dawngawh, ap kqih ti kawng. Thlanghqing ing ikaw ni tina hly nawh nu. ");
INSERT INTO hltthb_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Bawipa taw ka venawh awm nawh, kai anik bawmkung na awm hy. Ka qaalkhqi ce noengnaak ing toek kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Thlanghqing ypnaak anglakawh Bawipa awh thuk ve nep khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Boeikhqi ypnaak anglakawh Bawipa awh thuk ve nep khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Qamtawm thlang ing nik chung khoep hlai hy, Bawipang ming ing cekkhqi ce noeng boeih nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Hu haina ni mam hlai uhy, Bawipang ming ing cekkhqi ce noeng boeih nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Khawimi amyihna ni bawl khoep hlai uhy, a hling ak ui bang amyihna qeng bang uhy; Bawipang ming ing cekkhqi ce noeng boeih nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Kang tluk hlo dyna ka hu nakawng ni buuk hlai uhy, Bawipa ing ni hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Bawipa taw kak thaawmnaak ingkaw ka laa na awm hy; anih taw anik hulkung na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Zeelnaak ingkaw noengnaak ing khy lah uh, thlakdyngkhqi a hi imkhqi awh khy lah uh: “Bawipa ak tang ben kut ing ik-oeih ak bau soeih khqi sai hawh hy!” tinawh. ");
INSERT INTO hltthb_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Bawipa awh tang ben kut ce pawm qu nawh: “Bawipa ak tang ben kut ing ik-oeih ak bau soeih khqi sai hawh hy!” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Am thi kawng nyng saw hqing hyn kawng, Bawipa a ik-oeih sai ce khypyi kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Bawipa ing khawteh na ni phep hawh hlai hy, thihnaak a venna taw amni pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Dyngnaak chawh ce kai aham awng law lah; kun nyng saw Bawipa a venawh zeelnaak awi kqawn lah vang. ");
INSERT INTO hltthb_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Vetaw thlakdyngkhqi a kunnaak Bawipa ak chawh na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Nang ing na nim hlat a dawngawh, na venawh zeelnaak awi kqawn kawng; nang taw ka hulkung na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Ip sakungkhqi ing ami qoeng lung ce a kil awhkaw lung ak khoeng soeih na awm hawh hy; ");
INSERT INTO hltthb_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","ve ve Bawipa ing sai nawh, ningnih a mik huh awh kawpoek kyi na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Ve a khawnghi ve Bawipa ing a sai na awm nawh zeel lah u sih. ");
INSERT INTO hltthb_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Aw Bawipa, kaimih ve ni hul khqi lah; Aw Bawipa, zoseen kam awmnaak ce ni pe lah. ");
INSERT INTO hltthb_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Bawipang ming ing ak law taw a zoseen hy. Bawipa im awhkawng zoseennaak ni pek khqi nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Bawipa Khawsa na awm nawh, ningnih awh vangnaak ce hlah law hy, lucik tloeng aham qamsa ce bawkthang ki awh qui ing khit lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Nang taw ka Khawsa na awm hyk ti, na venawh zeelnaak awi kqawn kawng nyng; Nang taw ka Khawsa na awm hyk ti, nang ce ni zoeksang kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Bawipa taw a leek a dawngawh a venawh zeelnaak awi kqawn lah uh; a lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","A cehnaak lam coet amak kapkhqi ingkaw, Bawipa a cawngpyinaak amyihna ak cetkhqi taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Ak awipeek khoem nawh kawlung boeih ing amah ak suikhqi taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Cekkhqi ing am sai thawlh unawh; anih a lam awh ce cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Hqut boeih aham ak awm am cukkiknaak awi ce nang ing cekkhqi ham taak pe hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Aw nang ak awipeek khqi ce ka hqutnaak thai aham ka lamkhqi ve cak seh! ");
INSERT INTO hltthb_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Nang ak awipeek khqi boeih ce kak poek awh chahqai na am awm ti kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Nang a koe ak dyng cawngpyinaak awikhqi ka cawng amyihna kawlung dyngnaak ing namah ce nim kyihcah vang. ");
INSERT INTO hltthb_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Nak awipeek khqi ce hqut bit kawng; koeh ni qoeng hyt cang. ");
INSERT INTO hltthb_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Ikawmyihna taithym ing a lam ce a ciimcaih sak thainaak kaw? Nak awi amyihna khaw a saknaak amyihna a ciimcaih sak thai kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Kak kawlung boeih ing nang ce ni sui nyng, nak awipeek awhkawng koeh ning pleng sak. ");
INSERT INTO hltthb_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Nang oelh nawh am ka thawlhnaak aham kam thin kak kawk khuiawh nak awi ve thuh hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Aw Bawipa, nang a venawh thangleeknaak awm seh; nak awipeekkhqi ce ni cawngpyi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Nam khak khui awhkawng ak cawn cawngpyinaak boeih ce ka hui ing kqawn nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Bawipa awh ak zeel soeih thlang amyihna nam cuk kiknaak awipeek ka hqut awh zeel nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Nak awipeek khqi ce poek typ typ nyng na lamkhqi ce poek nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Nak awipeek khqi awh zeel nyng saw; nak awi ce ak poek kaana am awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Na tyihzawih a venawh ak leek sai law cang, cawhtaw hqing kawng nyng; nak awi ce ngai kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Na cawngpyinaak awi awhkaw kawpoek kyi ik-oeih khqi am ka huh thainaak aham koeh thuh law. ");
INSERT INTO hltthb_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Khawmdek awh khin na ni ka awm; nak awipeek ce kai aham koeh thuh law. ");
INSERT INTO hltthb_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Nang ak awipeek ang ngai aih awh ka hqingnaak ve ityk awh awm am rem thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Oek qu nawh seet ak hu khqi, nak awipeek ak pleng taak thlangkhqi ce nang ing toel hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Nak awipeek khqi ce ka hqut a dawngawh, kqawn seetnaak ingkaw huh sitnaak khqi ve khoe law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Ukkungkhqi ing ngawicun unawh nik kqawn seet u seiawm, na tyihzawih ingtaw nak awipeek khqi ve ni ak poek hly tit tit hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Nam cuk kiknaak awipeek khqi ve ka zeelnaak na awm hy; cekkhqi ing kawpoek leeknaak ni pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Dekvai awh helh hyt na awm nyng; nak awi amyihna ka hqingnaak ve khoem law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Ka lamkhqi ce kak kqawn tlaih awh nang ing nim hlat hyk ti; namah ak awipeek khqi ce ni cawngpyi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Nang ing nani cawngpyi awipeek khqi ce ning zaksim sak lah; cawhtaw nak kawpoek kyi ik-oeih khqi ce poek typ typ kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Ka hqingnaak ve kawseet doena ak tha hoet hy, nak awi amyihna kak tha awm law sak tlaih lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Qaainaak lam awh am ka cehnaak aham ni hoep lah; na cawngpyinaak awi ing nim qeen cang. ");
INSERT INTO hltthb_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Awitak lam ce tyk hawh nyng; Na cawngpyinaak awi awh kak kawlung ling hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Aw Bawipa, nam cuk kiknaak awipeek ce tu qap hawh nyng, chah koeh ni phyih sak. ");
INSERT INTO hltthb_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Nang ing kak kawlung na loet sak hawh a dawngawh, nak awipeek naak lam awh dawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Aw Bawipa, nak awitlyhnaak ce ka hqutnaak thai aham ni cawngpyi lah; cawhtaw a dyt dyna hqut kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Zaksim thainaak ni pe lah, cawhtaw na cawngpyinaak awi ce khoem kawng nyng saw kak kawlung boeih ing hqut kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Nak awipeeknaak lam awh ni hqui ni sawi lah; ce a dawngawh ni zeelnaak ka huh. ");
INSERT INTO hltthb_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Ak lawn ngaihnaak ben am nawh nam cuk kiknaak benna kak kawlung ve hawi law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Aphu amak awm ik-oeih benna ka mik qawi ve koeh dai sak nawh; nak awi amyihna ka hqingnaak ve khoem law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Kqih na na awm thainaak aham, na tyihzawih a venawh ve nak awipeek ve soep sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Kak kqih soeih ming leeknaak ve lo law valh lah, kawtih nang a cawngpyinaak awi taw nep hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Nak awipeek khqi ce ngai mah nyng! Na dyngnaak awh ka hqingnaak ve khoem law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Aw Bawipa, amak dyt thai na lungnaak ingkaw nak awi taaknaak amyihna na hulnaak ce ka venna law seh; ");
INSERT INTO hltthb_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","nak awi ce ka ypnaak a dawngawh, kai anik kqawnsekung ce hlat kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Kam khak khui awhkawng nak awitak ce koeh lo law voel, kawtih nang a cawngpyinaak awi awh ni kang ngaih-unaak a awm. ");
INSERT INTO hltthb_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Na cawngpyinaak awi ce ngai loet kawng nyng, kumqui ingkaw kumqui dyna. ");
INSERT INTO hltthb_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Ngaihding na cet a cawn vang nyng, kawtih nak awipeek ce hu hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Sangpahrangkhqi haiawh nak awipeekkhqi ce kqawn kawng nyng saw, chahqai na am awm ti kawng, ");
INSERT INTO hltthb_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","nak awipeekkhqi ce ka lungnaak a dawngawh zeelnaak ta nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Ka lungnaak awi peek benna ka kut ve hak phyl nyng saw nak awitlyhnaak awipeekkhqi ce poek typ typ nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Na tyihzawih a venawh awi na peek ce sim loet lah, nang ing ni ngaih-unaak ce nani peek. ");
INSERT INTO hltthb_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Ka khuikha awh kang ngaihqepnaak taw ve ni: Nak awikamnaak ing ka hqingnaak khoem law hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Uephnaak taak kaana ak oek qukhqi ing ni qaih na uhy, cehlai na cawngpyinaak awi ce am pleng taak nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Aw Bawipa, syn awhkaw na cawngpyinaak awi khqi ce sim loet nyng saw, cekkhqi awh ngaihqepnaak hu nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Thlakche khqi nang a cawngpyinaak awi ak qoeng khqi awh ngaih seetnaak ing nim tu khak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Ka awm ihnaak boeih awh nang ak awitlyhnaak awipeekkhqi ve ka laa ak leek soeih na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Aw Bawipa, khawmthan awh nang ming ce poek nyng, na cawngpyinaak awi khqi ce khoem kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Nak awipeek khqi hquut ve: Ka sai khawi na awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Aw Bawipa, nang taw ka taham na awm hyk ti; nak awikhqi ce hqut aham awi ta hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Kak kawlung boeih ing na haai ce sui hawh nyng; nak awitaak amyihna nim qeen lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Ka cehnaak lamkhqi ve poek nyng saw nak awipeeknaak benna khaw khan law hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Nak awipeek khqi ce yih kaana ang tawnna hqut hlah vang. ");
INSERT INTO hltthb_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Thlakchekhqi ing qui ing ni pin u seiawm, nang a cawngpyinaak awi ce am hilh ti kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Na cawngpyinaak awihdyngkhqi awh thanlung awh na venawh zeelnaak awi kqawn aham tho nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Kai taw nang ak kqihkhqi boeih ingkaw nang ak awipeek ak hqutkhqi boeih a pyi na awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Aw Bawipa, khawmdek ve na lungnaak ing bengen hy; nak awitlyh awipeekkhqi ce ni cawngpyi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Aw Bawipa, nak awi amyihna na tyihzawih a venawh ik-oeih leek sai lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Cyihnaak ingkaw awideng thainaak ce ni pe lah, kawtih nak awipeekkhqi ce ni kak cangnaak. ");
INSERT INTO hltthb_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Ka khuikha hlan awh lam pleng hlai nyng, tuh taw nak awi ngai hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Nang taw leek hyk ti, ik-oeih na sai awm leek hy; nak awitlyhnaak awipeekkhqi ce ni cawngpyi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Ak oek qukhqi ing qaai kqawn ing ni zan hlai uhy, kak kawlung boeih ing nak awipeekkhqi ce hqut nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Cekkhqi ak kawlung taw qil soeih hy, cehlai kai taw nang a cawngpyinaak awi awh ni ka zeel hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Ka khuikha ve kai aham leek hy, cawh ni nang ak awitlyhnaak awipeekkhqi ce ka cawng hly thai. ");
INSERT INTO hltthb_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Sui ngun thong sang anglakawh nam kha awhkaw cawngpyinaak awi ce ni kai aham a phu a tlawh khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Na kut qawi ing ni sai nawh ani syn ni; nak awipeekkhqi ce ka cawng thainaak aham zaksimnaak ni pe lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Nang anik kqihkhqi ing kai ami huh awh zeel u seh, kai ing nang ak awi awh ni ngaih-unaak ka taak. ");
INSERT INTO hltthb_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Aw Bawipa, nang a cawngpyinaak awikhqi taw dyng nawh, na ypawmnaak ing kai ni khuikha sak hy tice sim nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Na tyihzawih a venawh awi na taak amyihna, amak dyt thai na lungnaak ve kang ngaihqepnaak na awm lah seh. ");
INSERT INTO hltthb_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Ka hqingnaak aham nam qeennaak ce ka venna law lah seh, na cawngpyinaak awi taw ka zeelnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Akawng a awm kaana kak khan awh ik-oeih che ak sai ak oek qukhqi ce chah phyi u seh; cehlai kai ingtaw nak awipeekkhqi ce poek typ typ vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Nang nik kqih nawh nang ak awipeek ak zasimkhqi taw kai benna mang u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Chah am ka phyihnaak aham, nak awitlyhnaak awipeek benna kak kawlung ce coet a kap kaana awm seh. ");
INSERT INTO hltthb_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Ka hqingnaak ing na hulnaak ang ngai aih awh zai hqoeng hy; cehlai nak awi awh ngaih-unaak ce ta nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Ka mik qawi ing nak awikamnaak ce dan hlai hy, am huhy; “Ityk awh ngaih nani qep sak kaw?” ti nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Maikhu anglakawhkaw mehvyn um amyihna awm nyng seiawm, nak awitlyhnaak awipeekkhqi ce am hilh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Na tyihzawih ing ve iqyt nu ani qeh kaw? Kai anik thekhanaak thlangkhqi ce ityk awh na toel kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Nang a cawngpyinaak awi ing ak kalh na, ak oek qukhqi ing kai aham lawk-kqawng co law uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Nak awipeekkhqi boeih ve a ypawm hy; ni hul lah, kawtih thlangkhqi ing akawng a awm kaana ni the ni kha na uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Khawmdek awhkawng ni khoe hlo uhy, cehlai nak awipeekkhqi ce am qoeng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Na lungnaak ing ka hqingnaak ve khoem law lah, cawh ni kam kha awhkaw cuk kiknaak awipeekkhqi ce kang ngai hly. ");
INSERT INTO hltthb_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Aw Bawipa, nak awi taw kum qui dy cak hy; khawk khan awh ak cak na dyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Na yp awmnaak ce cadil naa dyna cak hy; nang ing khawmdek ve caksak nawh, awm poe hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Tuh dy na cawngpyinaak awi ve cak hy, soepkep boeih ing na bi ve bi uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Na cawngpyinaak awi ce ka zeelnaak na ama na awm mantaw, khuikha doena ana thi hawh kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Nak awipeekkhqi ce ityk awh awm am hilh ti kawng, cekkhqi ing ni ka hqingnaak ve na khoem law. ");
INSERT INTO hltthb_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Ni hul lah nang a koe na ni ka awm; nak awipeekkhqi ce sui nyng hu hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Thlakchekhqi ing kai plawci sak aham ni qeh uhy, cehlai nang am cuk kiknaak awipeekkhqi ce ni kak poek hly. ");
INSERT INTO hltthb_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Ik-oeih boeih a soepnaak a dawng ce hu hawh nyng; cehlai nang ak awipeekkhqi taw a dytnaak am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Aw, na cawngpyinaak awi ce lungna mah nyng! Khawnghi zung poek typ typ khing nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Ka qaal khqing lak awh nang ak awipeekkhqi ing ni cyih sak khqoet hy; kawtih cekkhqi ce ka venawh awm poe uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Nam cuk kiknaak awipeekkhqi ce kak poek typ typ a dawngawh, ka cawngpyikungkhqi boeih anglakawh poek thainaak tak khqoet nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Nak awipeekkhqi ce ka hquut a dawngawh, a hqamcakhqi anglakawh poek thainaak tak khqoet nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Nak awi ka hquut thainaak aham lap che saqui awh khaw am poek nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Namah qoe ing nani cawngpyi hawh a dawngawh, na cawngpyinaak awi awhkawng am pleng qunyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Nak awikhqi ce kam tan awh awi soeih nawh, kam kha awh khawi anglakawh awi soeih mah hy! ");
INSERT INTO hltthb_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Nak awipeekkhqi awhkawng cyihnaak hu nyng; ce a dawngawh amak thym lam boeih ce sawh na nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Nak awi taw ka khaw aham maihchoei na awm nawh ka lam aham vangnaak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Nang a koe ak dyng cawngpyinaakkhqi ce ka hquut thainaak aham, awi sa nyng saw caksak hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Khuikha soeih nyng; Aw Bawipa, nak awi amyihna ka hqingnaak ve khoem law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Aw Bawipa, kam kha ing ngaihnaak ing a nim kyihcah ve, do law nawh na cawngpyinaak awikhqi ce ni cawngpyi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Ka hqingnaak ve ka kut awh tu qap hlai nyng, na cawngpyinaak awi ce am hilh ti kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Thlakchekhqi ing thang dun law hlai uhy, nak awipeeknaak awhkawng am pleng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Nam cuk kiknaak awipeekkhqi ve ka kumqui qo na awm nawh; kak kawlung zeelnaak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","A dyt dyna nak awitlyh awipeekkhqi hquut aham kak kawlung qawn hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Kawlung pakkhih na ak ta thlang ce sawh na nyng, cehlai nani cawngsak awi ce lungna nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Nang taw kang thuknaak ingkaw ka phuhqa na awm hyk ti; nak awi awh ngaih-unaak ta nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Nangmih ik-oeih che ak saikhqi, ka ven awhkawng cet lah uh, ka Khawsak awipeekkhqi ngai na lah vang! ");
INSERT INTO hltthb_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Nak awikamnaak amyihna caksak lah, cawhtaw hqing kawng nyng; kang ngaih-unaak akawng awhkawng chah koeh ni phyih sak. ");
INSERT INTO hltthb_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Nim tu khak lah, cawhtaw hulna awm kawng; nak awitlyhnaak awipeekkhqi ce poek quiqah kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Nak awitlyhnaak awipeek awhkawng ak pleng khqi boeih ce nang ing qoeng hyk ti, a mingmih a qaai kqawnnaak ce a hqawng a h qap mai ni. ");
INSERT INTO hltthb_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Khawmdek awh thlak chekhqi boeih ce nang ing thi-eek tui amyihna na hui ban awh; nam cuk kiknaak awipeekkhqi ce lungna nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Nang anik kqih aih awh ka sa ve tyn hy; na cawngpyinaak awi kqih doena dyi hqoeng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Ak thym ingkaw ak dyng ce sai hawh nyng; kai ani husit thlangkhqi kut awh koeh ni hal hyt. ");
INSERT INTO hltthb_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Na tyihzawih leeknaak aham ak khoeng na sai law cang lah; ak oek qukhqi ing koeh ni husit khqi seh. ");
INSERT INTO hltthb_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Nang a hulnaak ingkaw ak dyng awikamnaak ce sui vang nyng, ka mik awm hyp hqoeng hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Na lungnaak ing na tyihzawih ve ngai cang nawh, nak awitlyhnaak awipeekkhqi ce cawngpyi cang. ");
INSERT INTO hltthb_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Na tyihzawih na ni ka awm; nam cuk kiknaak awipeek kang zaksimnaak thai aham phekbo thainaak kawlung ni pe lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Aw Bawipa, tuh ve sai tym hawh ni; na cawngpyinaak awi hqe huili na awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Sui anglakawh, sui tuici anglakawh nang ak awipeekkhqi ce ka lungnaak a dawngawh; ");
INSERT INTO hltthb_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","nak awipeekkhqi ce thym hy ka ti a dawngawh, amak thym lam boeih ce sawh na nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Nam cuk kiknaak awikhqi ve kawpoek kyi na awm hy; ce a dawngawh hquut nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Ak dai qu nak awi ing vangnaak ce ni pehy; thlang mailaikhqi venawh zaksimnaak ce pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Nak awipeekkhqi ce kang ngai a dawngawh, kam kha ang nyng saw kang hqi hawp hqoeng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Nang ming ak lungnaak thlangkhqi venawh na sai khawi amyihna, kai benna hawi nawh nim qeen cang lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Nak awi amyihna ka khaw khamkhqi ve hawi law lah; thawlhnaak ing koeh ni uk seh. ");
INSERT INTO hltthb_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Nak awipeekkhqi ka hquut thainaak aham, thlangkhqi a huhsitnaak ak khui awhkawng ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Na tyihzawih khan awh na haai vang sak nawh nak awitlyhnaak awipeekkhqi ce ni cawngpyi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Na cawngsak naak awikhqi a mami hquut a dawngawh, ka mik qawi awhkawng ka mikphli tuikhqi ve lawngca tui amyihna lawng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Aw Bawipa, nang taw dyng tiksaw, na cawngpyinaak awikhqi awm thym hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Cuk kiknaak awipeek na taakhqi ve dyng nawh; a ypawm soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Ka qaalkhqi ing nak awi ce ami hilh a dawngawh ka ypawmnaak ing ni hawn sak zip hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Nak awikamnaak khqi ce ak nep cana noek a dak na awm hawh nawh, ce ce na tyihzawih ing ve lungna hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Ak nem na awm nyng thlang a huhsit na awm nyng seiawm, nak awipeekkhqi ce am hilh qoe nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Na dyngnaak taw kumqui dyna awm nawh nak caksaknaak awikhqi ce thym hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Kyinaak ingkaw khuikhanaak ing ni sing bai seiawm, nak awipeekkhqi ce ka zeelnaak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Nam cuk kiknaak awipeekkhqi ce kumqui dy thym hy; ka hqingnaak aham zaksimnaak ce ni pe lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Aw Bawipa, kak kawlung boeih ing nik khy nyng, nang ing nim hlat lah, cawhtaw nawl peeknaak awitlyhkhqi boeih ce hquut kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Nang ni ka nik khy; ni hul lah cawhtaw nam cuk kiknaak awipeekkhqi ce hquut kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Khaw a dai hlan awh tho nyng saw bawmnaak thoeh doena kqang nyng; nak awi awh ngaih-unaak ce ta nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Na awitaak ce kak poeknaak typ typ aham, thanlung a poeng hlan dy ka mik dai phat hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Na lungnaak amyihna kak khynaak awi ce ngai law lah; Aw Bawipa na cawngpyinaak awi amyihna ka hqingnaak ve khoem law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Ak che ik-oeih ingkaw kai anik tengkhqi zoe lawk khqoet uhy, cehlai nang a cawngpyinaak awi ingtaw hla quhy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Cehlai, Aw Bawipa, nang taw zoe hyk ti, nak awipeekkhqi boeih awm thym hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Ce mihkhqi ce kumqui dyna nang ing caksak hawh hyk ti, tice nam cuk kiknaak awipeek awhkawng sim hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Kak khuikhanaak ve toek law nawhtaw ni hul lah, kawtih na cawngpyinaak awi ce am hilh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Kai akawng a dawngawh ni hul nawhtaw ni thaawng lah; na awikamnaak amyihna ka hqingnaak ve khoem law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Hulnaak ve thlakchekhqi hamna taw hla hy, kawtih cekkhqi ing nang a awitlyhnaak awipeek ce am sui uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Aw Bawipa, na lungnaak taw bau soeih hy; na cawngpyinaak awi amyihna ka hqingnaak ve khoem law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Kai anik thekhanaak qaalkhqi ve kqeng soeih uhy, cehlai nang am cuk kiknaak awipeek awhkawng am pleng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Cangnaak amak ta thlangkhqi ce tyih doena toek nyng, kawtih cekkhqi ing nak awi ce am hquut uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Nak awipeekkhqi izah dy ka lungnaak tive toek lah; Aw Bawipa, na lungnaak amyihna ka hqingnaak ve khoem law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Nang ak awipeekkhqi boeih ve thym hy; nang a koe ak dyng cawngpyinaak awikhqi taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Akawng a awm kaana ukkungkhqi ing ni thekha na uhy, cehlai kak kawlung taw nang ak awi awh thyn hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Kawnthem ak hu moek thlang amyihna nak awikamnaak awh zeel nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Amak thym ce sawh na nyng saw tyih nyng, cehlai na cawngpyinaak awi taw lungna nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Ak thym nang a cawngpyinaak awikhqi awh hypoet awh voei khqih nang nim kyihcah nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Nang a cawngpyinaak awi ak lungnaak thlangkhqi ingtaw ngaihqepnaak bau soeih ta uhy; ikaw ingawm a mingmih ce am bah sak khqi thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Aw Bawipa nang a hulnaak ce lamtoen nyng saw, nang ak awipeekkhqi ce hquut nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Nang ak awipeekkhqi ce ka lungnaak a dawngawh hquut nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Nang ak awipeekkhqi ingkaw cuk kiknaak awipeekkhqi ce hquut nyng, kawtih ka lam boeih ce nang ing sim hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Aw Bawipa, kang kqangnaak awi ve na hai pha law seh; nak awi amyihna zaksimnaak ce ni pe lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Qeennaak ka thoeh law ve na hai pha law seh; na awikamnaak amyihna nang ing ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Ka hui ve kyihcahnaak ing bengen seh, kawtih namah ing namah a awitlyhnaak awipeekkhqi ce ni cawngpyi hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Kam lai ing nak awi ce laa na sa seh, kawtih nak awipeekkhqi taw dyng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Na kut ce kai bawmnaak aham a oepchoeh na awm lah seh, kawtih nang ak awipeek ce ni kak tyh hawh. ");
INSERT INTO hltthb_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Aw Bawipa, nang a hulnaak ce ngai soeih nyng, nang a cawngpyinaak awi taw ka zeelnaak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Ka nim kyihcah thainaak aham, ni hqing sak lah, na cawngpyinaak awi ing ning dyihpyi lah seh. ");
INSERT INTO hltthb_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Tuu ak qeng amyihna lam hang hqoeng hawh nyng. Na tyihzawih ve sui lah, kawtih nak awipeekkhqi ce am hilh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Ka khuikha awh Bawipa ce khy nyng saw, anih ing nim hlat law hy. ");
INSERT INTO hltthb_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Aw Bawipa, qaai ak kqawn huikhqi ingkaw qaai kqawn na ak nget laikhqi anglakawhkawng ni hul lah. ");
INSERT INTO hltthb_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Aw qaai kqawn na ak nget hui lai nang, nang ak khan awh anih ing ikaw a sai kaw, cekcoengawh ikaw ak awm bai? ");
INSERT INTO hltthb_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Kaw ak awmkhqi a la sumkhqi ing nang ce ni toel kawmsaw, imnawt thing mai alh ing ni toel kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Kedar awhkaw hi im anglakawh awm nawh, Meshqek awh ak awm ve kai aham khaw map mah hy! ");
INSERT INTO hltthb_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Roepnaak ak sawhnaak thlang anglakawh ka awm ve sang soeih hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Kai taw qoepnaak ak ngaih thlang na awm nyng; cehlai awi kak kqawn awh, qaal thawh aham ngaih lat uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Hana kawng nu kai anik bawmkung a law lah kaw? Ti nyng tlang benna mik hak dai nyng – ");
INSERT INTO hltthb_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Kai anik bawmkung taw dek ingkaw khan ak saikung, Bawipa venna kawng ni a law. ");
INSERT INTO hltthb_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Anih ing na khaw ce am ning bah sak kawmsaw – nang anik khoemkung ce am ngam tikaw; ");
INSERT INTO hltthb_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","oeih, Israel ak khoemkung ce am ngam kawmsaw ip awm am ip kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Bawipa ing nang ce ni qeh hy – Bawipa taw nak tang ben awh nang anik chungkung na awm hy; ");
INSERT INTO hltthb_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","khawnghyp awh khawmik ing amni eng kawmsaw, khawmthan awh pihla ing amni eng bai kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Bawipa ing nganbawh soepkep khui awhkawng ni khoem kawmsaw – na hqingnaak ce khoem law kaw; ");
INSERT INTO hltthb_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Bawipa ing na lawnaak ingkaw na cehnaak boeih awh tuh kawng kumqui dy ni qeh loet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Bawipa a im na cet u sih,” tinawh amik kqawn law awh zeel soeih nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Aw Jerusalem, kaimih a khaw khqi ve vawng chawmkeng awh dyi hawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Jerusalem taw khawk bau ak zoei cana ami sak amyihna sak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Israel a venawh cuk kiknaak awipeek peek na a awm amyihna, Bawipang ming kyihcah ham, cawh ce thlang pilnamkhqi, Bawipa a pilnam khqi hang cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Cawh ce awidengnaak boei ngawihdoelh khqi, David ipkhui awhkaw boei ngawihdoelh khqi awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Jerusalem ngaihqepnaak aham cykcah lah uh: “Nang anik lungnaak thlangkhqi ce qalmawng na awm u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Na vawng khuiawh ngaihqepnaak awm seitaw, na boei awmnaak im kqang ngaihqepnaak awm seh.” ");
INSERT INTO hltthb_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Ka koeinaa ingkaw pyikhqi awh, “Nang ak khuiawh ngaihqepnaak awm seh,” ti kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Bawipa ningnih Khawsa im awh, nang a boeimangnaak ce sui kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Nang a venawh khan na boei ngawihdoelh ak awm nang a venawh, ka mik hak dai law nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Tamnaakhqi mik ing ami boei a kut ami toek amyihna, tyihzawih nukhqi ing ami boei nu a kut ami toek amyihna, am qeennaak ce ningnih a venawh ang dang sak hlan dy, kaimih a mik ing Bawipa ningnih a Khawsa ce toek hy. ");
INSERT INTO hltthb_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Kaimih ve nim qeen khqi cang, Aw Bawipa, kaimih ve nim qeen khqi cang, thlang a huhsitnaak yh khing hawh unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Ak oek qukhqi a qaihsai zawk khing hawh unyng saw, ak oek qukhqi a huhsitnaak awm zawk khing hawh aih unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Bawipa mah ningnih benna ama awm mai mantaw – Israelkhqi ing kqawn seh – ");
INSERT INTO hltthb_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","Bawipa mah ningnih benna ama awm mai mantaw, thlangkhqi ing ningnih ani tuk khqi awh, ");
INSERT INTO hltthb_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","cekkhqi ing ningnih ak khan awh amik kaw a so awh; ningnih ce a hqing na nik daih khqi hawh kaw; ");
INSERT INTO hltthb_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","tuibau ing ningnih ce ni sing malh kawmsaw, tuibak ce ningnih ak khan na tho hawh kaw, ");
INSERT INTO hltthb_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","tuibau tha ak awm ing ningnih ce ni zawn khqi hawh kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Cekkhqi a ha ing ningnih am choek nawh, Bawipa venawh thangleeknaak awm seh. ");
INSERT INTO hltthb_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Pha a ham dawng ak dunkung ak dawng awhkawng a hlawng pha amyihna ningnih taw ni awm uhy; dawnkhqui ce boet nawh, ningnih ce ni loet uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Ningmih bawmnaak taw dek ingkaw khan ak saikung, Bawipang ming awh ni a awm. ");
INSERT INTO hltthb_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Bawipa ak ypnaak thlangkhqi taw amak tyn qoe kumqui dyna ak cak Zion tlang ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Tlang ing Jerusalem ak chung khoep amyihna, Bawipa ing tuh kawng kumqui dyna ak thlangkhqi ce chung sih khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Thlakche a boei sawnghqawl ing thlak dyngkhqi a qam khuiawh am awm loet thai ti kaw, cemyih mantaw thlak dyngkhqi ing ami kut ce ik-oeih che sainaak aham hawna hau kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Aw Bawipa, thlakchekhqi, kawlung ak dyng thlangkhqi venawh ak leek ik-oeih sai lah. ");
INSERT INTO hltthb_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Cehlai lap kawi awh ak pleng thlangkhqi cetaw amak leek ik-oeih ak saikhqi mi Bawipa ing hqek baat kaw. Israel ak khan awh ngaihqepnaak awm seh. ");
INSERT INTO hltthb_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Qaal ing am tukhqi ce Bawipa ing Zion na a sawi law khqi tlaih awh, kaimih taw mang ak hukhqi amyihna awm unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Ningmih am khakhqi taw qaihnaak ing be nawh, nim laikhqi taw zeelnaak laa khqi ing be uhy. Cawh thlangphyn khqi anglakawh, “Bawipa ing ik-oeih bau soeih cekkhqi hamna sai pehy,” tinawh kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Bawipa ing ik-oeih bau soeih ningnih aham sai law hawh hy, cedawngawh ningnih taw zeelnaak ing ni be uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Aw Bawipa, ni hu awhkaw zoseennaak ce ni pe tlaih lah, Negev a lawngcakhqi amyihna ak awm ce. ");
INSERT INTO hltthb_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Mikphli ing ak sawkhqi ing zeelnaak laa sak doena aat kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Grang doena camci saw aham ak cet khqi ing, cangvui pawm doena zeelnaak laa sak ing hlat law tlaih kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Bawipa ing im ama sak awhtaw, ip sakungkhqi ing a hoei nani bi ami sai. Bawipa ing khawk bau ama qeh awhtaw, qaltoeng khqi ing a hoei nani ami qeh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","A hoei na mymcang hqit awh tho unawh buh ai thainaak aham khawmy ben than dy bi sai uhyk ti – anih ingkaw a lungnaak thlangkhqi venawh ihnaak ce pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Cakpa khqi ve Bawipa venawh kaw qo nik pangkhqi ni, canaa khqi ve amah a venawh kaw kutdo peek khqi ni. ");
INSERT INTO hltthb_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Tha awm hui awhkaw cakpa cun khqi ve qalkap kawk awm kut awhkaw la khqi ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","A lacung ce ce mihkhqi ing ak be hyp na ak ta thlang taw a zoseen hy. Vawkchawh awh a qaalkhqi mi aming noek qu awh chah am phyi kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Bawipa kqih nawh, a lam awh ak cet thlangkhqi boeih taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Na bibinaak phu ak thaih ce ai kawp ti; zoseennaak ingkaw boeimangnaak ce nang aham awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Na zu ce na ipkhui awh misur thaih ak qah soeih amyihna awm kawmsaw; na capakhqi ce beihdung kung awh olive dil amyihna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Bawipa ak kqih ak thlangkhqi taw cemyihna ce awm kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Bawipa ing Zion awhkawng ka hqing khui pyt zoseennaak ni pekaw; Jerusalem awhkaw boeimangnaak ce hu kawp ti, ");
INSERT INTO hltthb_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","na hqinglung sang kawmsaw na cakhqi a cakhqi patoe ce hu kawp ti. Israel ak khan awh ngaihqepnaak awm seh. ");
INSERT INTO hltthb_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Ka naasen awhkawng cekkhqi ing ni husit hawh uhy, tina – Israelkhqi ing amik kqawnnaak taw – ");
INSERT INTO hltthb_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","cekkhqi ing ka naasen awhkawng ni husit hlai uhy, amni noeng khawi uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Lai ak nawkkhqi ing kam tingkawng awh lai nawk unawh, a qytnaak a ngaw sim hqa hy. ");
INSERT INTO hltthb_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Cehlai Bawipa taw dyng hy; anih ing thlakchekhqi a qui ce boet law nawh ni loet sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Zion ak sawhnaak thlangkhqi boeih taw chah doena hlat u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Iptih na sai ak cawt, a tai hlan awh ak zai nawn amyihna awm u seh; ");
INSERT INTO hltthb_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","cemyih cetaw ak aatkung ing a kut awh ap pawm nawh, ak cawikung ingawm a ban awh ak be na ap tawm bai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Ce a hun awh ak cet saqui ing, “Bawipa a zoseennaak nak khan awh awm seh; Bawipang ming ing zoseennaak ni pe nyng,” am tina kawn. ");
INSERT INTO hltthb_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Aw Bawipa, a dungnaak hun awhkawng nang a venawh khy nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Aw Bawipa, kak awi ve ngai law lah. Qeennaak thoeh doena na venawh kak khynaak benna nang haa keng law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Aw Bawipa, nang ing thawlhnaak khqi ve na khoem mai mantaw, Aw Bawipa, u nu ak dyi thai kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Cehlai namah a venawh qeenkhaw ngainaak awm hy; cedawngawh kqih awm na awm hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Bawipa ce qeh nyng, ka hqingnaak ing qeh hy, ak awi awh kang ngaih-unaak ce awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Qaltoengkhqi ing mymcang ami qehdam anglakawh, ka hqingnaak ing Bawipa lamtoen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Aw Israel Bawipa awh nang ngaih-unaak ce ta lah, kawtih Bawipa awh amak dyt thai lungnaak ing thaawngnaak soep ce awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Amah ing Israelkhqi ce a thawlhnaakkhqi boeih awhkawng hul kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Aw Bawipa, kak kawlung ve am oek qu nawh, ka mikdai awm am sang hy, kamah ingkaw kamah ak bau soeih ik-oeih awh am pe qunyng saw kawpoek kyi soeih khqi awh awm am paa nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Ka hqingnaak ve oei nyng saw awm sak poek poek nyng; naaca ing a nu suk a nawn amyihna, suk awk ak nawn naacamyihna kak khuiawh ka hqingnaak ve awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Aw Israel, tuh kawng kumqui dyna nang ngaih-unaak ce Bawipa awh ta lah. ");
INSERT INTO hltthb_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Aw Bawipa, David a khuikha ce sim loet lah. ");
INSERT INTO hltthb_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Anih ing Bawipa venawh awi sa nawh Jakob a Thak awm Thlang a venawh awikamnaak ta hawh hy: ");
INSERT INTO hltthb_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","Ka ipkhui awh am kun kawng nyng saw ih hun awm am pan kawng nyng – ");
INSERT INTO hltthb_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","ka mik qawi ve am ih sak kawng nyng saw, ka mik khu qawi awm am ngam tikaw, ");
INSERT INTO hltthb_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","Bawipa ham hun ka huh hlan dy,” tinawh awi ta hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Ce ce Ephrathah awh ning za unawh, Jaar hun awh ce ak khan na ni cet hawh uhy: ");
INSERT INTO hltthb_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Anih a awmnaak hun cet u seitaw; a khawkung awh anih ce bawk lah u sih, ");
INSERT INTO hltthb_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Aw Bawipa, tho nawhtaw nang dymnaak hun na law lah, namah ingkaw nak thaawmnaak bawm ingqawi law nih. ");
INSERT INTO hltthb_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Na khawsoeihkhqi ing dyngnaak ing thoeihcam qu u seitaw; na thlakciimkhqi ing awmhly laa sa u seh.” ");
INSERT INTO hltthb_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Na tyihzawih David ak caming, situi na syp thlang koeh qoeng. ");
INSERT INTO hltthb_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Bawipa ing David a venawh awi sa nawh, awikamnaak ak cak ce ityk awh awm huna am hlat taak tikaw: “Na caksak anglakawhkaw thlang pynoet ce na boei ngawihdoelh awh ngawih sak kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Na cakhqi ing ka paipi ve khoem unawh cuk kiknaak awipeek ak cawngpyi khqi ce ami hqut awhtaw, cekkhqi a cakhqi ing na boei ngawihdoelh awh kumqui ingkaw kumqui dy ngawi kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Ikawtih Zion ce Bawipa ing tyk nawh; a awmnaak aham ce a hun ce a ngoe a dawngawh tyk hy: ");
INSERT INTO hltthb_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Ve ve kumqui ingkaw kumqui kang dymnaak hun na awm kaw; ve ve kak kawlung ing a ngoe a dawngawh, vawh boei na ngawi loet hawh kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Anih ce awk a ai khawzah ing zoseennaak pe kawng nyng saw; anih a khawdeng thlangkhqi ce ak phoen phyi sak kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","A khawsoeihkhqi ve hulnaak ing chung ak dah khqi kawng nyng saw, a thlakciimkhqi ing zeelnaak laa ang qui na sa kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Vawh David aham kii cawn sak kawng nyng saw situi ka syp thlang aham maivang taak pe kawng. ");
INSERT INTO hltthb_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","A qaalkhqi ce chah phyih ing sing pek khqi kawng nyng, cehlai anih a lu awhkaw boei lumyk cetaw vang kaw.” ");
INSERT INTO hltthb_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Cingnahqui hui oet na ak awm taw leek nawh ngaih awm mah hy! ");
INSERT INTO hltthb_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Lu awh situi phuk tlo ing syp nawh, khapkho dyna ak lawng, Aaron am khakkho dyna ak lawng, a angki hawng dyna anuk lawng amyihna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Hermon awhkaw dam tui Zion Tlang na anuk lawng amyihna awm hy. Cawh Bawipa ing kumqui dy hqingnaak zoseennaak ce pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Nangmih khawmthan awh Bawipa im na bi ak saikhqi, Bawipa ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","A hun ciim awh nami kut ce phyl unawh taw Bawipa ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Khan ingkaw dek ak saikung, Bawipa ing Zion awhkawng nangmih ce zoseennaak ni pek khqi seh. ");
INSERT INTO hltthb_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Bawipa taw kyihcah lah uh. Bawipang ming ce kyihcah lah uh; nangmih Bawipa a tyihzawihkhqi aw, amah ce kyihcah lah uh, ");
INSERT INTO hltthb_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","nangmih Bawipa ipkhui awh bi ak saikhqi, ningnih Khawsa ipkhui kawngma awh bi ak saikhqi, Bawipa ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Bawipa taw a leek a dawngawh, Bawipa ce kyihcah lah uh; ang ming kyihcahnaak laa sa lah uh, kawtih ce ce ngaih awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Ikawtih Bawipa ing Jakob ce amah aham tyk nawh, Israel ce amah aham kawk bawm phuk tlo na tahy. ");
INSERT INTO hltthb_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Bawipa taw bau nawh, khawsa boeih anglakawh bau hy tice sim nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Khan ingkaw dek, tuicunli ingkaw tuihdungkhqi boeih awh amah ak zeel sak boeih Bawipa ing sai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Khawmdek a dytnaak awhkawng myi zaam sak nawh; khawkphla ingkaw khawtlan tui ce tyi law haih hy, ik-oeih a taaknaak im awhkawng zilh ce hlah law hy. ");
INSERT INTO hltthb_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Izip qam awhkaw cadil boeih ce him pehy, thlanghqing caming ingkaw qamsa ak thang cyk khqi ce him pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Aw Izip, Pharaoh ingkaw a tyihzawih khqi boeih tuk aham, nang ak khuiawh hatnaakkhqi ing kawpoek kyi ik-oeihkhqi ce anih ing tyi law hy. ");
INSERT INTO hltthb_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Phynlum thlang khawzah papa ce anih ing him nawh tha ak awm sangpahrangkhqi ce him hy – ");
INSERT INTO hltthb_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Amorkhqi sangpahrang Sihon, Bashan sangpahrang Og ingkaw Kanan qam awhkaw sangpahrangkhqi boeih – ");
INSERT INTO hltthb_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","cekkhqi a qam ce qo na ak thlang Israelkhqi venawh pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Aw Bawipa nang ming taw kumqui dy cak nawh, namah simpoenaak awm, Aw Bawipa, chawn khawzah dyna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Ikawtih Bawipa ing ak thlangkhqi ak thym na awi deng kawmsaw a tyihzawih khqik khan awh qeennaak ta kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Phynlum thlangkhqi a myiqawl taw sui ingkaw ngun mai ni, thlanghqing kut ing ni a sai. ");
INSERT INTO hltthb_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Kha taw ta lawt hlai uhy, am pau thai uhy, mik awm ta hlai uhy am hu thai uhy; ");
INSERT INTO hltthb_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","haa ta hlai uhy, am za thai uhy, amim kha awh hqi awm am hqi thai bai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Vemih ak sai thlangkhqi taw vekkhqi amyihna awm lawt kawm uh, vekkhqi ak ypnaak thlangkhqi awm vekkhqi amyihna awm lawt kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Aw Israel ipkhuikawkhqi aw, Bawipa ce kyihcah lah uh; Aw Aaron ipkhui kawkhqi aw, Bawipa ce kyihcah lah uh; ");
INSERT INTO hltthb_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Aw Levi ipkhuikawkhqi aw, Bawipa ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Zion awhkawng Jerusalem khawk khuiawh ak awm Bawipa venawh kyihcahnaak awm seh. Bawipa taw kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Bawipa taw a leek a dawngawh a venawh zeelnaak awi kqawn lah uh. A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Khawsakhqi a Khawsa venawh zeelnaak awi kqawn lah uh. A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Boeikhqi a Bawipa a venawh zeelnaak awi kqawn lah uh. A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Kawpoek kyi soeih ik-oeih ak sai amah doeng a venawh, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","a cyihnaak ing khankhqi ak saikung a venawh, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","tuikhqik khan awh dek ak phaihkung a venawh, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","vangnaak bau soeih ak saikung a venawh, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","khawdai ak uk aham khawmik, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","khawmthan ak uk aham pihla ingkaw aihchikhqi, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Izipkhqi a caming dan ak tatkung a venawh, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","cekkhqi anglakawhkawng Israel ce sawi hy, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","kut thak awm soeih ingkaw ban ak phylkung, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Tuicun Sen ak kqek phuk a venawh, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","ce anglak li awh Israelkhqi ce sawi hy, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","cehlai Pharaoh ingkaw a qalkapkhqi ce Tuicun Sen ing liu malh hy, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","qamkoh awhkawng ak thlangkhqi ak sawikung a venawh, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","sangpahrang bau khqi dan ak tatkung a venawh, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","tha ak awm sangpahrangkhqi ak himkung – A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Amorkhqi a sangpahrang Sihon, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Bashan sangpahrang Og – A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","cekkhqi qam ce lo na pehy, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","amah a tyihzawih Israel a venawh qo na pehy; A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","ningnih ak kai dyt na ni awm awh anik sim loetkung, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","qaal kut khuiawh kawng ni loet sak hy, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","a sai ik-oeih boeih a venawh ai kawi ak pekung, A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Khan Khawsa venawh zeel awi kqawn lah uh. A lungnaak taw kumqui dy cak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Babylon long keng awh ngawi unyng saw Zion ce ka mik poek awh kqang unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Cawh tuiqi awh tingtoeng ce hoei unyng, ");
INSERT INTO hltthb_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","cawh kaimih anik tukhqi ing laa sak aham ni ceei khqi hy, kaimih anik thekhanaak thlangkhqi ing zeelnaak laa sak aham ni ngaih hy, “Zion a laa pynoet awh sa law lah uh ee!” ni tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Ikawmyihna thlang a qam na Bawipa a laa ce ka mi sak thai kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Aw Jerusalem, nang ce ka ni hilh awhtaw kak tang ben kut ing a simnaak hilh poe lawt seh. ");
INSERT INTO hltthb_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Nang amni sim voel nyng saw, ka zeelnaak soeih Jerusalem, nang ce am ka nik poek voel hawh awhtaw, kam lai ing dangkhyl na bet qu qap seh. ");
INSERT INTO hltthb_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Aw Bawipa, Jerusalem a zawk nyn awhkaw Edomkhqi ing ik-oeih ami sai ce, sim loet lah. “Hre bang tlang, tung nang lingnaak dyna phu bang tlang uh!” tinawh amik khy ce. ");
INSERT INTO hltthb_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Aw Babylon canu, ak plawci hly kawi, kaimih ak khan awh ik-oeih na sainaak amyihna, nang ak khan awh ik-oeih ak thung lawkhqi zeel kawm uh – ");
INSERT INTO hltthb_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","na naacakhqi ce amim tu law coengawh lung khawng na kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Aw Bawipa, kak kawlung boeih ing nang ce nim kyihcah vang; “khawsakhqi” haiawh nang kyihcahnaak laa sa vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Nang a bawkim ciim benna koep nyng seitaw, na lungnaak ingkaw na ypawmnaak awh nang ming ce kyihcah vang, kawtih ing nang ming ing na lungnaak ce ik-oeih boeih ak khan awh zoeksang hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Kai ing ka nik khy awh, nang ing nim hlat hyk ti; ka qaal ni leek sak nawh kak kaw awm sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Aw Bawipa, khawmdek awhkaw sangpahrangkhqi boeih ing, nam kha awhkaw awi a ming zaak awh nang ce nim kyih u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Bawipa a boeimangnaak taw a bau soeih a dawngawh, a lamkhqi ce laa na sa u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Bawipa taw hun sang na awm hlai hy, kaw ak dungkhqi ce toek hy, cehlai ak oek qu ak thlang taw ak hla na awm taak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Kyinaak anglak li awh cet nyng awm, nang ing ka hqingnaak khoem law hyk ti; ak kaw ak so ka qaal benna kut zyng law nawh, nak tang ben kut ing ni hul hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Bawipa ing kai aham cainaak a taak ce soep law sak kaw; Aw Bawipa; na lungnaak taw kumqui dy cak hy – na kut sai ce koeh qoeng hyt. ");
INSERT INTO hltthb_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Aw Bawipa, nang ing ni sui nawh ni sim hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Ngawi nyng kang dyih awh awm nang ing ni sim hyk ti; kak poeknaak ve ak hla nakawng sim hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Cet nyng kang zaih awh awm nang ing ni sim hyk ti; lam boeih ce nang ing sim hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Kam lai awh awi khangoet pateng za a awm hlan awh, Aw Bawipa, nang ing ni sim pheng hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Nang ing huhai na ni hawi ni le nawh, kak khan awh na kut ce tloeng law hyk hy. ");
INSERT INTO hltthb_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Cemyih cyihnaak ce kai aham kawpoek kyi soeih na awm hy, sang aih nawh pha voet hqoeng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Nang ang myihla a ven awhkawng hana ka ceh thai kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Khan na hang cet mai nyng seiawm, cena nang awm hyk ti; dek kai a dungnaak khuina zaih nyng seiawm, cena nang awm bai hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Myncang khawkdai awhkaw ang hla awh tho nyng, tuicunli vang ben caqai a hlanaak na awm mai nyng seiawm, ");
INSERT INTO hltthb_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","cena awm nang a kut ing ni sawi bai kawp ti, nak tang ben kut ing ak cak cana nim tu kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Thannaak ing ni hlip kawmsaw vangnaak ce ka ven tloek awh thannaak na coeng kaw,” ti mai nyng seiawm, ");
INSERT INTO hltthb_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","thannaak ing nang ce amni sing noeng tikaw; khawmthan ce dai amyihna vang kaw, thannaak ce nang aham vangnaak na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Ikawtih nang ing kak kawlung khui boeih ve sai hyk ti; ka nu ak phoen khui awh nang ing ni sing boeih hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Kqih awm ingkaw kawpoek kyi na nani sai a dawngawh nang ce nim kyihcah nyng; nang a ik-oeih saikhqi ve poek kyi na awm hy tice ak leek cana sim pheng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Ang hyp na sai na ka awm awh, ka pumqaw sainaak ve nang a venawh kawng thuh thai na am awm hy. Khawmdek a dungnaak awh kutoet na bawl na ka awm awh, ");
INSERT INTO hltthb_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","na mik ing ak bawl qu hlan ka pum ve hu hawh hy. Kai a khawnghi caksak na ak awmkhqi boeih ce pynoet awm ang coeng hlan awh, na cauk awh qee na awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Aw Khawsa, nak poeknaakkhqi ve kai aham a phu tlo soeih mah hy! ");
INSERT INTO hltthb_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Ka toek aham a awm mai mantaw, dizui dek anglakawh doem khqoet kaw. Kang hqyng law awh, na venawh awm hyn bak bak bai nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Aw Bawipa, nang ing thlakche khqi doeng mah na him mai mantaw! Nangmih thlang a thin a mik ngaih tloek, ka venawh kawng ak hla na awm hoer uh! ");
INSERT INTO hltthb_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Vekkhqi ing nang ce ak che na nik kqawn ngah ngah unawh; na qaalkhqi ing nang ming ce amak thym na hawna uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Aw Bawipa, nang anik sawhnaakkhqi ce sawh na nyng saw, nang qaal na anik thawh sihkhqi ce am ka tyih nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Cekkhqi sawhnaak doeng ni ka taak; cekkhqi ce ka qaal nani kak poek. ");
INSERT INTO hltthb_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Aw Khawsa, nang ing ni sek nawhtaw, kak kawlung ve sim law lah; ni noek ni dak nawhtaw kak kawpoekkhqi ve sim law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Kai awh boeseetnaak khqi ak awm hy voei nu, toek nawhtaw, kumqui lam awh ni sawi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Aw Bawipa, thlakchekhqi kut khuiawh kawng ni hul lah; boeksekhqi a kut khui awhkawng nang ing nik chung lah, ");
INSERT INTO hltthb_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","ak kawlung khuiawh ak che poeknaak doeng ta unawh myngawi qaal na tho loet uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","A mim laikhqi ce khqui am lai amyihna hqat sak unawh; khquihse a chy ce ami hui kqang awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Aw Bawipa, thlakchekhqi kut khui awhkawng nang ing ni khoem lah; kai a khawkham lawlh sak aham ak cai thlakchekhqi anglakawhkawng ni hlip lah. ");
INSERT INTO hltthb_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Ak oek qukhqi ing kai aham ang hyp na dawng dun law unawh; lawk qui ce zan law uhy, ka cehnaak lam boeih awh dun law uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Aw Bawipa, nang a venawh, “Nang taw ka Khawsa ni,” ti nyng. Aw Bawipa, qeennaak thoeh doena kang kqangnaak awi ve ngai law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Aw Boeimang Khawsa, kai anik hulkung thakawm, qal tuknaak kung awh ka lu ak dah lawkung – ");
INSERT INTO hltthb_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Aw Bawipa, thlakchekhqi a ngaihnaak ce koeh soep law pe sak; a ming cainaak awm koeh coeng sak, cemyih am mantaw oek qu hau kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Kai anik chungkhqi a lukhqi taw a mimah a hui ing ang coeng sak kyinaak ing sing pe seh. ");
INSERT INTO hltthb_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Maikqawng ce a mingmih ak khan awh tlaak pe seitaw; a mami thawh thai voel aham mai awh, lawk-kqawng khuina khawng u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Qam khuiawh thlang kqawnseet na ak nget khqi ce koeh awm seh; boeksekhqi taw seetnaak ing a hu awh hquut seh. ");
INSERT INTO hltthb_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Bawipa ing thymnaak ce khawdengkhqi ham taak pe nawh ak voethlauhkhqi ce dawm a hlai hy tice sim nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Thlakdyngkhqi ing nang ang ming ce kyihcah kawm usaw thlak leek khqi ce na haiawh awm kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Aw Bawipa, nang ni ka nik khy; ka venawh ang tawnna law cang. Ka nik khy awh kak awi ve ngai cang lah. ");
INSERT INTO hltthb_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Kak cykcahnaak ve na haiawh bawktui na awm seitaw; ka kutphyl ve khawmy ben awhkaw lucik nawn amyihna awm seh. ");
INSERT INTO hltthb_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Aw Bawipa, kam kha awh khoemkung ta law nawhtaw; ka hui chawmkeng ve qeh law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Kak kawlung ve ik-oeih che benna, thlakchekhqi a ik-oeih sainaak ing amak leek ik-oeih ak sai thlangkhqi benna koeh hawi law; a mingmih a buh a an tui awm koeh ni ai sak. ");
INSERT INTO hltthb_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Thlak dyng ingtaw ni vyk mai seh – qeennaak dawngawh ni; ni zyi awm ni zyi seh – ka lu awhkaw situi nani a awm. Ka lu ing ap tha na tikaw. Cehlai kak cykcahnaak ing thlakchekhqi a ik-oeih sai ce oelh poepa hy; ");
INSERT INTO hltthb_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","a ningnih ak ukkungkhqi ce minpoeng na khawng kawm uh, kak awih kqawnkhqi ve ak leek ni ka kqawn tice thlakchekhqi ing sim kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Cekkhqi ing, “Thlang ing dek a nawk awh deklai a ah amyihna, kaimih a quhkhqi taw phyi a keng awh theh qu kang hy,” ti kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Cehlai, Aw Boeimang Bawipa, ka mik qawi ing nang ni ani dan; nang awh ni kang thuk – thihnaak benna nang ing koeh ni pe. ");
INSERT INTO hltthb_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Kai aham ami dun law dawng awhkawng ni loet sak nawhtaw; thlakchekhqi ing ami dun law dawng awhkawng ni loet sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Kai taw ngaihding na ka ceh awh, thlakchekhqi taw a mimah a lawk awh awk nawn u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Bawipa venawh khawteh na khy nyng; qeennaak thoeh doena Bawipa venawh awi y nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","A haiawh ka ngaihnaak awi kqawn pe nyng saw; ka kyinaak ce a haiawh kqawn pe nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Kak khuina kang myihla ve a zai awh, nang ing ni ka lam ve na sim law. Ka cehnaak lam awh thlangkhqi ing ang hyp na dawng dun law uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Kak tang ben ve toek mai lah; kai anik ngainaak u pynoet awm am awm hy. Thuknaak am ta nyng saw; kai ka hqingnaak ve u ingawm ikaw na am huhy. ");
INSERT INTO hltthb_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Aw Bawipa, nang a venawh khy nyng, “Nang taw kang thuknaak na awm hyk ti, ak hqingkhqi qam awh ka taham na awm hyk ti,” ti nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Kak khynaak awi ve ngai lah, ni ngoe soeih nyng; kai anik hquutkhqi kut khuiawh kawng ni hul lah, kai aham taw amik tha awm soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Nang ming kam kyihcah thainaak aham, thawngim khui awhkawng ni loet sak lah. Cawhtaw kak khan awh na leeknaak awh ve thlak dyngkhqi ing nik chung khqi khoep kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Aw Bawipa, kak cykcahnaak awi ve ngai law nawhtaw, nam qeennaak thoeh doena kak khynaak awi ve ngai law lah; na ypawmnaak ingkaw na dyngnaak ce kai aham hoeihkhangnaak na awm lah seh. ");
INSERT INTO hltthb_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Na tyihzawih ve awi koeh deng cang, kawtih na haiawh ak dyng thlang pynoet awm am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Ka qaal ing ni hquut nawh dek nik khawng na hy; ak thi ce thlangkhqi amyihna thannaak khuiawh ni ta hyt hy. ");
INSERT INTO hltthb_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Cedawngawh ka kawk khuiawh kang myihla zai hqoeng nawh; kak kawlung kqihnaak ing be hy. ");
INSERT INTO hltthb_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Ak kqym a tym khqi poek nyng; na ik-oeih saikhqi boeih ce poek typ typ nyng saw na kut saikhqi ce poek nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Nang benna kut phyl law nyng; qamkoh ing tui a ngaih amyihna ka hqingnaak ing nang ce tui amyihna ni ngaih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Aw Bawipa, ang tawnna nim hlat lah; kang myihla zai hqoeng hawh hy. Ka venawh na haai koeh thuh law, cemyih am mantaw lawk-kqawng khuina khaw ak sakhqi amyihna awm hau lawt kawng unyng. ");
INSERT INTO hltthb_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Amak dyt thai nang a lungnaak ce mymcang ing haw law seh, kawtih nang ni ka ni ypnaak. Ka ceh hly kawi lam nim huh lah, nang benna ka hqingnaak ve hak zoek law nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Aw Bawipa, ka qaal khqing lak awhkawng ni hul lah, nang ak khuiawh ni kang thuh qu hy. ");
INSERT INTO hltthb_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Ka Khawsa na na awm a dawngawh, nak kawngaih sai thainaak aham ni cawng sak lah; nang a koe ak leek Myihla ing lamtlang awh ni sawi lah seh. ");
INSERT INTO hltthb_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Aw Bawipa, nang ming ak caming ka hqingnaak ve khoem law lah; na dyngnaak ak caming kyinaak anglak li awhkawng ni loet sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Amak dyt thai na lungnaak ing, ka qaalkhqi sit sak lah; na tyihzawih na ka awm a dawngawh, ka qaalkhqi boeih ve hqe law lah. ");
INSERT INTO hltthb_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Qaal tuknaak aham ka kut qawi cawngpyi nawh qaal kahnaak aham ka kut dawnkhqi ak cawngpyi Bawipa ka lungnu venawh kyihcahnaak awm seh. ");
INSERT INTO hltthb_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Anih taw ka lungnaak Khawsa ingkaw ka vawngcak, ka qaltoeng vawng khoeng ingkaw anik hulkung, kang thuknaak phuhqa, ka hui awh thlangkhqi ak kun sak kung na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Aw Bawipa, thlanghqing ve ikawmyihna nu tinawh nang ngainaak khak, thlanghqing capa awm nak poek loet? ");
INSERT INTO hltthb_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Thlanghqing taw hqi amyihna ni a awm; a hqing khui khawnghi awm myihlip ak khum bang amyihna ni a awm. ");
INSERT INTO hltthb_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Aw Bawipa, nak khankhqi ce nung ngam sak nawh nu law lah, tlangkhqi ce a khunaak aham bi lah. ");
INSERT INTO hltthb_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Khawpha tyi nawhtaw qaalkhqi ce kqeng a zang na ta kang lah; na la ce kap nawhtaw dawng lam hang sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Hun sang nakawng na kut ce nuk thla law nawh; ni hul nawh tuih tha ak awm ing, thlakchangkhqi kut khui awhkawng ni hul cang lah, ");
INSERT INTO hltthb_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","cekkhqi am kha taw qaai kqawn thai unawh, amik tang ben kutkhqi awm qaai ak kqawn kut na awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Aw Khawsa, nang a venawh lak thai sa vang nyng; a qui pahqa ak law tingtoeng ing nang a venawh tumding tum kawng nyng, ");
INSERT INTO hltthb_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","sangpahrangkhqi venawh noengnaak ak pekung, thihnaak kawi zawzi awhkawng a tyihzawih David ak loet sakkung a venawh ce. ");
INSERT INTO hltthb_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Qaai ing ak be khakhqi ingkaw qaai kqawn ak nget tang ben kut ak ta qap chang thlangkhqi kut khuiawh kawng ni hul nawhtaw ni thaawng cang lah. ");
INSERT INTO hltthb_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Cawhtaw ka capa thak awm hui khqi awm a dawn ak sai thingkung amyihna awm kawm usaw, ka canukhqi awm sangpahrang a im awhkaw a thoeihcam hqeet tungkhqi amyihna awm kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Kaimih ak khaikhqi awm ai kawi soepkep ing bengen kaw. Kaimih a tuukhqi awm thong sang dyna pung a tai kawmsaw ka mimah a lo khuiawh lym kawm uh; ");
INSERT INTO hltthb_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","vaitawm caikhqi ing phyihqih phyi kawm uh. Cawhtaw vawng hqe awi am ning za voel kaw, thlang a tamnaa na amni khum voel kawmsaw, lam awh kawseet kqangnaak awi am ning za voel ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Ve ak awi ve ak thym thlangkhqi ham taw a zoseen hy; Bawipa ce Khawsa na ak takhqi taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Ka Khawsa ingkaw sangpahrang, nang ce ni zoeksang vang nyng, nang ming ce kumqui ingkaw kumqui dy nim kyihcah vang. ");
INSERT INTO hltthb_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Myngawi nang ce nim kyihcah nyng saw, nang ming ce kumqui ingkaw kumqui dyna zoeksang vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Bawipa taw a bau soeih a dawngawh kyihcah ham tyng hy; a baunaak ce u ingawm am lam noeng thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Chawn oet ing na ik-oeih sai ce ak chang a venna kqawn pe patoe kaw; nang ak thaawm ik-oeih sai ce kqawn kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Nang a boeimang qypawmnaak ingkaw kqih awmnaak ce cekkhqi ing kqawn kawm uh, kai ingtaw nang ak kawpoek kyi ik-oeih sai ce poek typ typ kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Cekkhqi ing nang ak kawpoek kyi kqih awm ik-oeih sai ce kqawn kawm uh, kai ing nang a ik-oeih sai bau soeih khqi ce kqawn kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Nang a koe ak doem soeih leeknaak ce ym kawm usaw na dyngnaak laa ce zeel doena sa kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Bawipa taw thlang qeenkhaw ak ngaikung ingkaw lungnaak kung na awm hy, ak kaw am so hqet nawh lungnaak ing ak be na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Bawipa taw thlang boeih a venawh leek hy; a sai ik-oeih boeih ak khan awh lungnaak tahy. ");
INSERT INTO hltthb_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Aw Bawipa, nang a sai ik-oeih boeih ing nang ce nim kyihcah kawm uh, nak thlangciimkhqi ing nang ce ni zoeksang kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Na qam boeimangnaak ingkaw nak thaawmnaak ce cekkhqi ing kqawn kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Cawhtaw thlang boeih ing nang ak thaawm ik-oeih sai ingkaw na qam boeimangnaak ce sim kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Nang a qam taw kumqui qam na awm nawh, na uknaak awm cadil naa dyna cak hy. Bawipa taw ak awikamnaak awh a ypawm nawh a sai ik-oeih boeih ak khan awh lungnaak tahy. ");
INSERT INTO hltthb_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Bawipa ing ak tlukhqi boeih ce thawh nawh a sai ik-oeih khqik khan awh lungnaak tahy. Bawipa taw ak awikamnaak awh a ypawm nawh a sai ik-oeih boeih ak khan awh lungnaak tahy. ");
INSERT INTO hltthb_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Thlang boeih a mik ing nang ni ami toek uh, cekkhqi ce amah a tym awh nang ing buh pe boeih hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Na kut phyl nawh khqin hqing boeih a hym ngaihnaak ce soep pe sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Bawipa a sainaak lam boeih taw dyng nawh a sai ik-oeih boeih ak khan awh lungnaak tahy. ");
INSERT INTO hltthb_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Bawipa ak takhqi boeih, awitak na amah ak takhqi boeih a venawh zoe pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Amah ak kqih thlangkhqi boeih a ngaihnaak ce soep pe sak hy; cekkhqi ak khy awi ce zaak pe nawh hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Amah ak lungnaak thlangkhqi ce Bawipa ing qeh hy, cehlai thlakchekhqi ce hqe bang kaw. ");
INSERT INTO hltthb_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Kam kha ing Bawipa kyihcahnaak ce kqawn kaw. A sai ik-oeih boeih ing amah ce kumqui ingkaw kumqui dy kyihcah seh. ");
INSERT INTO hltthb_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Bawipa taw kyihcah lah. Aw ka hqingnaak Bawipa kyihcah lah. ");
INSERT INTO hltthb_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Ka hqing khui pyt Bawipa ce kyihcah kawng nyng saw; ka mik a hqing khui ka Khawsa kyihcahnaak laa ce sa vang nyng. ");
INSERT INTO hltthb_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Boeikhqi ce koeh ypna, amak cak thlanghqing awm koeh ypna; cekkhqi ing amni hul thai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","A ming myihlakhqi ing a ceh taak khqi awhtaw, deklai nani a ming hlat tlaih hy; ce nyn qoe awh a ming cainaakkhqi boeih awm plal boeih hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Jakob Khawsa ce bawmkung na ta nawh, ang ngaih-unaak ce Bawipa a Khawsa venawh ak ta thlang taw a zoseen hy, ");
INSERT INTO hltthb_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","khan ingkaw dek, tuicunli ingkaw ak khuiawh ak awm ik-oeihkhqi boeih ak saikung – Bawipa taw, kumqui dy ypawm na awm poepa hy. ");
INSERT INTO hltthb_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Thlang ing a thekhanaak thlangkhqi ce thawh nawh phoen ak cawikhqi ce buh pehy. Bawipa ing thawng ak tlakhqi ce loet sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Bawipa ing mikhypkhqi ce mik huh sak nawh, ak ngamkhqi ce Bawipa ing toeqoek sak hy, Bawipa ing thlakdyng ce lungna hy. ");
INSERT INTO hltthb_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Khin ce Bawipa ing khoem nawh pa ak naikhqi ingkaw nuhaikhqi ce hqin hy, cehlai thlakchekhqi a lam cetaw mam pe khoep hy. ");
INSERT INTO hltthb_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Bawipa taw kumqui dy boei na ngawi hy, Aw Zion, cadil naa dyna na Khawsa ce awm hy. Bawipa taw kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Bawipa taw kyihcah lah uh. Ningmih Khawsa venawh kyihcahnaak laa sak ve leek nawh amah zoeksang doena kyihcah ve zeel aham awm mah hy! ");
INSERT INTO hltthb_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Bawipa ing Jerusalem ce thawh tlaih nawh; thlang a qam na ak pla Israelkhqi ce cawi tlaih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Kawlung ak kqek khqi ce qoei sak nawh a ngawha khqi ce zeen pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Aihchikhqi boeih ce noet nawh ang ming ing khy boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Bawipa taw bau soeih nawh, ak tha awm soeih hy; a simnaak ing dytnaak am tahy. ");
INSERT INTO hltthb_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Dung voeng na ak awm thlangkhqi ce Bawipa ing dawm a hlai hy, cehlai thlakchekhqi cetaw dek na khawng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Zeel awi kqawn doena Bawipa venawh laa sa lah uh; tingtoeng ningnih Khawsa venawh tumding tum lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Khawnghi ce myi ing zawl hy; khawmdek awh khaw tlan sak nawh tlangkhqi awh sai cawt sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Khqin ce buh pe nawh vangaak ca ak khy khqi awm buh pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Anih a zeelnaak taw meqang ak thaawmnaak awh amni, ak kawzeelnaak awm thlanghqing a khawkhqi awh amni; ");
INSERT INTO hltthb_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Bawipa a zeelnaak taw amah ak kqihkhqi ingkaw amak dyt thai a lungnaak ak ngaih-ukhqi ak khan awh ni a awm. ");
INSERT INTO hltthb_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Aw Jerusalem, Bawipa ce zoeksang lah; Aw Zion, na Khawsa ce kyihcah lah, ");
INSERT INTO hltthb_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","anih ing na vawk chawh tlangkhqi ce zoseennaak pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Na qamqi ak khan awh qoepnaak sai nawh buh ak tui soeih ing nak phoen phyi law sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Ak awipeek ce khawmdek awh nuk tyi law nawh; ak awi ce ang tawnna dawng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Vyl ce tuu myi amyihna theh nawh maikhu amyihna vyl pai bawk ding sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Reel ce lunkqel amyihna hlah hy. Tuikhal a dingnaak awh u nu ak dyi thai kaw? ");
INSERT INTO hltthb_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Ak awi ce tyi nawh tui na zut sak hy; zilhding law sak nawh, tui ce lawng hy. ");
INSERT INTO hltthb_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Jakob a venawh ak awi ce dang pe sak nawh a cawngpyinaak awi ingkaw ak awitlyhnaak ce Israel a venawh dang sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Qapchang thlang a hamna ve ve am sai pehy, cekkhqi ing a cawngpyinaak awi ce am sim uhy. Bawipa taw kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Bawipa taw kyihcah lah uh. Khan nakawng Bawipa ce kyihcah unawh, sawsang soeih awh Bawipa ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Ak khan ceityihkhqi boeih aw, amah ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Khawmik ingkaw pihla aw, amah ce kyihcah lah, nangmih aihchi ak ngaihkhqi boeih aw, amah ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Nangmih khan ak sangkhqi aw, amah ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Bawipang ming ce kyihcah lah u seh, kawtih amah ing awi pe nawh ik-oeih a sai na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Cekkhqi ce amah a hun boeih awh kumqui dyna tahy, amak khum thai awipeek ce cekkhqi venawh pehy. ");
INSERT INTO hltthb_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Khawmdek awhkawng Bawipa ce kyihcah lah uh, nangmih tuicunli khui awhkaw a sai ik-oeih ak bau soeih khqi ingkaw tuihdungkhqi aw, ");
INSERT INTO hltthb_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","khawkphla ingkaw kqeek khqi, vyl ingkaw cingmaikhqi, ak awipeek ak ngai khawhli, ");
INSERT INTO hltthb_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","nangmih tlangkhqi ingkaw cungkhqi, ak thaih kawi thingkhqi ingkaw sidar thingkhqi, ");
INSERT INTO hltthb_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","kqawng qamsakhqi ingkaw khqinkhqi, qamsa ak zawikhqi ingkaw ak ding phakhqi, ");
INSERT INTO hltthb_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","khawmdek awhkaw sangpahrangkhqi ingkaw phynlum boeih, nangmih boei a cakhqi ingkaw khawmdek ak ukkungkhqi boeih, ");
INSERT INTO hltthb_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","cadawngkhqi ingkaw nulakhqi, pacawngkhqi ingkaw naasenkhqi boeih aw, Bawipa ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Cekkhqi ing Bawipang ming ce kyihcah u seh, kawtih anih ang ming doeng ni zoeksang aham a awm; a boeimangnaak taw dek ingkaw khan ak khan awh awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Anih ing ak thlangkhqi ham kii hak thawh pehy, ak thlangciimkhqi am kyihcahnaak ing, ak kawlung ing ak zoe khet Israelkhqi kyihcahnaak awm sai pehy. Bawipa taw kyihcah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Bawipa taw kyihcah lah uh. Bawipa venawh lak thai sa unawh, thlakciimkhqi cunnaak awh am kyihcahnaak laa ce sa lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Israel ing amah ak saikung awh zeel seitaw; Zion thlangkhqi ing a mimah a Sangpahrang awh zeel u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Ang ming ce lam doena kyihcah u seitaw, qaica ingkaw tingtoeng tumding ce tum pe u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Bawipa taw ak thlang khqik khan awh zeel nawh, dungvoeng na ak awm thlangkhqi ce hulnaak myk sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Ve kqihchahnaak awh thlakciimkhqi ing zeel u seitaw a ih hun awhkawng zeelnaak laa sa u seh. ");
INSERT INTO hltthb_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Cekkhqi am kha awh kyihcahnaak ce awm seitaw, ami kut awh a hu a hai ak hqat zawzi ce pawm u seh, ");
INSERT INTO hltthb_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","thlangphyn a venawh lu lawh aham ingkaw thlangkhqi ce toel aham, ");
INSERT INTO hltthb_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","a sangpahrangkhqi ce khawceh byn nawh, ak thlang bau khqi ce thi khawceh byn aham, ");
INSERT INTO hltthb_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","a mingmih awidengnaak qee ce canhah ce khyn peek aham awm hy. Ve ve ak thlangciim khqi boeih a thangleeknaak na awm hy. Bawipa taw kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Bawipa taw kyihcah lah uh. A hun ciim awh Khawsa ce kyihcah u nawhtaw; ak khan thaawm hun awh amah ce kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","A boeimang thaawm saithainaak awh kyihcah unawh; a baunaak kqawn noeng am awh kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Uut awi ing kyihcah unawh, tingtoeng ingkaw qaw tingtoeng ing amah ce kyihcah lah uh, ");
INSERT INTO hltthb_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","qaica khoek doena lamnaak ing kyihcah unawh, a qui ak awm phungding ing kyihcah lah uh, ");
INSERT INTO hltthb_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","tlaklak khoek doena amah ce kyihcah unawh, tlaklak awi ing kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Soepkep ak hqi thai poh ing Bawipa ce kyihcah seh. Bawipa taw kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","Israel sangpahrang David a capa Solomon ak awicyih taw; ");
INSERT INTO hltthb_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","Cyihnaak ingkaw cawngpyinaak, zaaksimnaak thaikhqi siimsak ham, ");
INSERT INTO hltthb_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","Dyngnaak, awitlyknaak, pekbonaak a awm kaana hawnaak thai ham ingkaw cawngpyinaak ak thym pawmnaak thai ham; ");
INSERT INTO hltthb_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","Khawk hangkhqi khawsimnaak taaksak ham ingkaw, cacoenkhqi khawkpoek thainaak taaksak ham; ");
INSERT INTO hltthb_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","5","Thlakcyikhqi ing siim unawh a mi cyihnaak a pungnaak khqoet nawh, khawkpoek thaikhqi ing khawkpoeknaak thai a mi taaknaak khqoet hamna, ");
INSERT INTO hltthb_vpl VALUES ("PR1_6","021_1_6","PRO","1","6","6","Awicyih ingkaw ak kqawncaihnaakkhqi, thlakcyi ak awi ingkaw a mik awih kqawn zaaksimnaak thai nace awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Bawipa kqihchahnaak taw cyihnaak a kungpyina awm nawh; Cehlai, thlakqawkhqi ingtaw cyihnaak ingkaw cawngpyinaak husit uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Ka capa, na pa cawngpyinaak ce ngai nawh, na nu cawngpyinaak ce koeh hoet. ");
INSERT INTO hltthb_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","Na lu hamna khqaipai leek soeihna awm nawh, na hawng hamna aawi hun leek soeihna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR1_10","021_1_10","PRO","1","10","10","Ka capa, thlakchekhqi ing a ni zoek awh koeh ngai kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR1_11","021_1_11","PRO","1","11","11","“Kami venna law lah, thlang a thi lawng sak lah usih, thlakche ak qeenkhqi ce qym khqi lah usih; ");
INSERT INTO hltthb_vpl VALUES ("PR1_12","021_1_12","PRO","1","12","12","Ceikhui amyihna a hqingpumna daih khqi lah usih, phyi khui amyihna. ");
INSERT INTO hltthb_vpl VALUES ("PR1_13","021_1_13","PRO","1","13","13","A phuk tlotlokhqi ni ham kawm saw, thlang a theem ni qawtkhqi ing ni im ce nik bee kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR1_14","021_1_14","PRO","1","14","14","“Kami venawh bang lawlawt nawh taw, tangka bawm ni qup haih kawm uh,” a mi ti awh, ");
INSERT INTO hltthb_vpl VALUES ("PR1_15","021_1_15","PRO","1","15","15","Ka capa, a ming lakawh koeh boei nawh, a mi lam awhkawng phleng qu kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR1_16","021_1_16","PRO","1","16","16","A mi khaw ce thawlhnaak lam benna kaan unawh, thi ak lawngsak hamna a ming hqii tawn sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR1_17","021_1_17","PRO","1","17","17","Lawk ce ak chaap maina zan ni, kawmyih phaa a haiawh awm. ");
INSERT INTO hltthb_vpl VALUES ("PR1_18","021_1_18","PRO","1","18","18","Cekkhqi taw a mimah thi ce lawngsak unawh a mi hqingnaak ak plamsakkhqi ni. ");
INSERT INTO hltthb_vpl VALUES ("PR1_19","021_1_19","PRO","1","19","19","Ceamyihna ni, a mak thymna ak kamvaakhqi lam taw; ami boei a hqingnaak ce lawh pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR1_20","021_1_20","PRO","1","20","20","Chawmkeeng awh cyihnaak ce khawteh na khyy nawh, Chawmkeeng tung keengawh ce khyy hy; ");
INSERT INTO hltthb_vpl VALUES ("PR1_21","021_1_21","PRO","1","21","21","Thlang khawzah ang cunnaak ang lungkil awh ce khyy nawh, khawkkhui lutnaak vawng chawmkeeng awhce khyy hy. ");
INSERT INTO hltthb_vpl VALUES ("PR1_22","021_1_22","PRO","1","22","22","Nangmih khawk hangkhqi aw, i qyt dy nu khaw na mi hang hly? I qyt dy nu a nik husit khqi huhsitnaak khuiawh na mi awm hly, thlakqawkhqi ing cyihnaak na mi maa hly? ");
INSERT INTO hltthb_vpl VALUES ("PR1_23","021_1_23","PRO","1","23","23","Ka ni toelnaakkhqi benna voei law uh: Ngai lah uh, na mik khanawh kang myihla theeh kawng nyng saw, kak awi zaaksimnaak ni pekkhqi kawng. ");
INSERT INTO hltthb_vpl VALUES ("PR1_24","021_1_24","PRO","1","24","24","Nik khykhqi nyng, ni maa uhyk ti, ka kut soeng nyng, uca ingawm am do uhyk ti; ");
INSERT INTO hltthb_vpl VALUES ("PR1_25","021_1_25","PRO","1","25","25","Ka khawkhannaakkhqi boeih ikawna am ngai unawh, ka ni toelnaakkhqi boeih ce hooet uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PR1_26","021_1_26","PRO","1","26","26","Ceamyihna awmsaw, kai ingawm na mi zoseet nyn awh ni qaih nak khqi kawng nyng saw, kyinaak na mi sawng lawawh ni qaih nak khqi kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR1_27","021_1_27","PRO","1","27","27","Na mi lynak hlinu amyihna a thoeng law nawh, na mi zoseetnaak tym ing a pha lawawh, kyinaak ingkaw ngaihangnaak namik khanawh a pha law awh. ");
INSERT INTO hltthb_vpl VALUES ("PR1_28","021_1_28","PRO","1","28","28","Chawh ce, nik khy kawm uh tik saw, cesei-awm am nim hlat khqi kawng: mymcang hii awh ni sui kawm uk tik saw, ceseiawm am ni hu kawm uk ti; ");
INSERT INTO hltthb_vpl VALUES ("PR1_29","021_1_29","PRO","1","29","29","Cyihnaak maa unawh, Bawipa kqihchahnaak ce ama mik tyhnaak ak caming. ");
INSERT INTO hltthb_vpl VALUES ("PR1_30","021_1_30","PRO","1","30","30","Ka khawkhannaak pynoet ca mai awm am ngaih unawh, ka toelthamnaak boeih ce a mi huhsit caming. ");
INSERT INTO hltthb_vpl VALUES ("PR1_31","021_1_31","PRO","1","31","31","Ceamyihna awmsaw a mi khawsak ak thaih qah ce aii kawm usaw, a mik poeknaak ing qoh kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR1_32","021_1_32","PRO","1","32","32","Thlakchekhqi hu benna nawngnaak ing a mimah him khqi kawm saw, ak qawkhqi ang ngaihdingnaak ing amimah moeng sak khqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR1_33","021_1_33","PRO","1","33","33","Kak awi ak haanaak taw ak ding cana khaw sa kawm usaw, zoseetnaak khuiawh awm ngaiqeep cana khawsa kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR2_1","021_2_1","PRO","2","1","1","Ka capa, kak awi ve do nawh kak awipek ve nak khuiawh na kym awhtaw, ");
INSERT INTO hltthb_vpl VALUES ("PR2_2","021_2_2","PRO","2","2","2","Cyihnaak ce nang haa ing ngai nawh, nak kawlung ing cyihnaak lam benna ang hawi awh- taw; ");
INSERT INTO hltthb_vpl VALUES ("PR2_3","021_2_3","PRO","2","3","3","Zaaksimnaak ce khy nawh, simthainaak ce nak khy awhtaw, ");
INSERT INTO hltthb_vpl VALUES ("PR2_4","021_2_4","PRO","2","4","4","Tangka amyihna sui nawh, khawh amyihna na sui awhtaw, ");
INSERT INTO hltthb_vpl VALUES ("PR2_5","021_2_5","PRO","2","5","5","Khawsa kqihchah lawthai kawm tik saw, Khawsa simthainaak ce ta kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR2_6","021_2_6","PRO","2","6","6","Khawsa ingtaw cyihnaak pe thai nawh, am khaa awhkawng cyihnaak ingkaw zaaksimthainaak ce cawn sak thai hy: ");
INSERT INTO hltthb_vpl VALUES ("PR2_7","021_2_7","PRO","2","7","7","Ak thym thlangkhqi ham cyihnaak ak thym ce khoem nawh, ypawm ing ak khawsakhqi ce doen khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR2_8","021_2_8","PRO","2","8","8","Ak thlangciimkhqi ing ak thymna khaw a mi sak naak ham a mi lam ce doen pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR2_9","021_2_9","PRO","2","9","9","Cawhce dyngnaak ingkaw ak thym awitlyknaak ce sim thai kawm tik saw, pekbonaak a taak kaana, lam leek boeih awm. ");
INSERT INTO hltthb_vpl VALUES ("PR2_10","021_2_10","PRO","2","10","10","Nak kawlung khuiawh cyihnaak ce lut kawm saw, na hqingnaak hamna simthainaak ce ak aawi soeihna awm kaw; ");
INSERT INTO hltthb_vpl VALUES ("PR2_11","021_2_11","PRO","2","11","11","Khawsimnaak ing ni khoemdoen kawm saw, khawsimthainaak ing ni hqin kaw; ");
INSERT INTO hltthb_vpl VALUES ("PR2_12","021_2_12","PRO","2","12","12","Thawlhnaak lam awhkawng a ni loet sak ham ingkaw amak thym awi ak kqawnkhqi lakawh kawng a nik loet sak hamna; ");
INSERT INTO hltthb_vpl VALUES ("PR2_13","021_2_13","PRO","2","13","13","Cekkhqi ing taw seetnaak lamawh ceh ham lamdyng ce ceh taak unawh; ");
INSERT INTO hltthb_vpl VALUES ("PR2_14","021_2_14","PRO","2","14","14","Theem amak leek sai ce ami ngaih kawina awm kawm saw, thawlh sainaak awh ce awmhly kawm uh; ");
INSERT INTO hltthb_vpl VALUES ("PR2_15","021_2_15","PRO","2","15","15","A mi lam taw kaawi nawh, ypnaak am cu hy. ");
INSERT INTO hltthb_vpl VALUES ("PR2_16","021_2_16","PRO","2","16","16","Nukche awhkawng ni loet sak nawh, a nik zoek ang lak awhkawng; ");
INSERT INTO hltthb_vpl VALUES ("PR2_17","021_2_17","PRO","2","17","17","A cacoen hui awhkaw pyi ceh ta nawh, A Khawsa awikam ak hilh ak thlang awhkawng ce. ");
INSERT INTO hltthb_vpl VALUES ("PR2_18","021_2_18","PRO","2","18","18","A im ing thihnaak lam ben mang nawh, a lam cehnaak ing thihnaak lam benna ce, ");
INSERT INTO hltthb_vpl VALUES ("PR2_19","021_2_19","PRO","2","19","19","A ven ak pha thlang boeih ing am voei voel ti kaw, hqingnaak lam ce am pan voel ti kawm uh; ");
INSERT INTO hltthb_vpl VALUES ("PR2_20","021_2_20","PRO","2","20","20","Thlakleek ceehnaak lamawh bang nawh, thlakdyng ceehnaak lamawh na ceeh naak thai ham. ");
INSERT INTO hltthb_vpl VALUES ("PR2_21","021_2_21","PRO","2","21","21","Ak dyngna khawksa thlangkhqi taw ve khawmdek awh khawsa thai kawm usaw, thlakleek khqi taw ce hyn awh ce khawsa poe kawm uh; ");
INSERT INTO hltthb_vpl VALUES ("PR2_22","021_2_22","PRO","2","22","22","Cehlai ak halang ak thlangkhqi taw khawmdek awhkawng qeeng sakna awm kawm saw amak thymna khaw ak sakhqi ce qeengsak na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","Ka capa, kak awipek ve koeh hilh nawh, nak kawlung awh kym lah. ");
INSERT INTO hltthb_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","Na hqingnaak khawnghii khawkum ingkaw ngaiqeepnaakkhqi ing ni tawmsap kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","Qeennaak ingkaw awitak ing nang ce koeh ni hooet seh. ");
INSERT INTO hltthb_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","Cawhtaw, Khawsa ingkaw thlanghqing mik huh awh mikhaileek ingkaw mingleeknaak ce pang kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Nak kawlung boeih ing Bawipa ce caang na nawh, Na siimnaak awh koeh hang qu; ");
INSERT INTO hltthb_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","Na lam hoeiawh amah ce siim poe nawh, na lam ce nim huh kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","Namah ngaih awh ak cyina koeh ngai qu nawh; Bawipa ce kqih nawh, thawlhnaak ce cehtaak. ");
INSERT INTO hltthb_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","Nak thangqui ham sadingnaak na awm nawh, na quh ham ak thlikna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","Na khawhkham ing Khawsa ce kyihcah lah. Na them ak pung law lammacyk boeih ing awm; ");
INSERT INTO hltthb_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","Cawhtaw nak khai baawp ing bee ngen kawm saw, na misur um ing bee poeng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","Ka capa, Bawipa a toelnaak ce koeh husit nawh, A ni toelzyihnaak ce koeh zadam kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","Bawipa ing a lungnak cekhqi ce toel khawi nawh, Pa ing ca a lungnak awh a toelzyih khawi a myihna. ");
INSERT INTO hltthb_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","13","Cyihnaak ak hu ak thlang ingkaw kawcyihnaak ak hu ak thlang taw a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("PR3_14","021_3_14","PRO","3","14","14","Cetaw ngun a phu tlo ingkaw sui a phu tlo ang lakawh a phu tlo ngai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","Suilung a phu tlo lakawh a phu tlo ngai nawh ngaihnaak ing awm am pha thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","Ak tangkut benawh hqinglung sangnaak awm nawh, ak cawngkut benawh khawhthem ingkaw boeimangnaak ce awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","A lam ce awmhlynaak lampyina awm nawh, a lam boeihboeih ce ngaiqeepnaak ing bee hy. ");
INSERT INTO hltthb_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","Ak tuu thlang boeih ham hqingnaak thingkungna awm nawh, ak kym thlang boeih ham zoseennaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR3_19","021_3_19","PRO","3","19","19","Bawipa ing a cyihnaak ing khawmdek ve syyn nawh, ak kawcyih ing khan ce caksak hy; ");
INSERT INTO hltthb_vpl VALUES ("PR3_20","021_3_20","PRO","3","20","20","A thoemnaak ing tuinu ce hqaa sak nawh, cingmai ing daamtui baw sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR3_21","021_3_21","PRO","3","21","21","Ka capa, na mik ing khaw koeh hang seh, cyihnaak ingkaw khawkpoek thainaak ce ak cakna tu; ");
INSERT INTO hltthb_vpl VALUES ("PR3_22","021_3_22","PRO","3","22","22","Na hqingnaak ham hqingnaakna awm nawh, na haawng ham mikhaileek na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR3_23","021_3_23","PRO","3","23","23","Cawhce na lamawh ak dingna cet kawm tik saw, na khaw am tawngtawh kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR3_24","021_3_24","PRO","3","24","24","Na ih awm am kqih kawm tik saw, nang zaih nawh na ih awhawm na ih tui kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR3_25","021_3_25","PRO","3","25","25","Kqihlyynaak bawtbet awh ak dang law ce koeh kqih nawh, thlang ak mukkhqi a pha law awhawm koeh kqih kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR3_26","021_3_26","PRO","3","26","26","Bawipa taw na loetnaak na awm nawh, na khaw thang awhkawng ni doen kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR3_27","021_3_27","PRO","3","27","27","Themleek ak hu tyngkhqi a do hly kawi themleek koeh haimah, na kutawh dangsak ham na taak khui taw. ");
INSERT INTO hltthb_vpl VALUES ("PR3_28","021_3_28","PRO","3","28","28","Na imceng venawh, “Ceh nawh ak changna va sui cang nawh voei law tlaih khawngawi ni pe kawng nyng,” koeh ti, na taak a loeiawh. ");
INSERT INTO hltthb_vpl VALUES ("PR3_29","021_3_29","PRO","3","29","29","Na imceng ak khanawh khawboeseet koeh toen, ni yp na nawh na venawh khawksa ni ti na sim loei. ");
INSERT INTO hltthb_vpl VALUES ("PR3_30","021_3_30","PRO","3","30","30","Khawboeseetnaak nak khanawh a ma toen awhtaw leehcaihnaak a awm kaana na kut koeh thlak. ");
INSERT INTO hltthb_vpl VALUES ("PR3_31","021_3_31","PRO","3","31","31","Khawboeseet ak toen ak thlang koeh ooet nawh a lampyi awh koeh hquut. ");
INSERT INTO hltthb_vpl VALUES ("PR3_32","021_3_32","PRO","3","32","32","Ak thymna khaw amak sa taw Bawipa mikhuh awh tyih kawina awm nawh thlakleekkhqi taw pyi nak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR3_33","021_3_33","PRO","3","33","33","Bawipa a khawsii taw thlakche khqi imawh awm nawh, thlakdyng khqi cunnaak taw zoseenaak ing bee hy. ");
INSERT INTO hltthb_vpl VALUES ("PR3_34","021_3_34","PRO","3","34","34","Thlang ak husitkhqi ce husitkhqi nawh, kawkneemkhqi ce qeennaak ham sak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR3_35","021_3_35","PRO","3","35","35","Kyihcahnaak taw thlakcyi ing ham nawh chahpyihnaak taw thlakqaw ing ham kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR4_1","021_4_1","PRO","4","1","1","Ka capakhqi aw, pa a cawngpyinaak ce ngai unawh, zaaksimthainaak na mi taaknaak ham ngai lah uh; ");
INSERT INTO hltthb_vpl VALUES ("PR4_2","021_4_2","PRO","4","2","2","Nami venawh ak leek soeih cawngpyinaak ka ni pekkhqi; ka cawngpyinaak koeh mangtak uh. ");
INSERT INTO hltthb_vpl VALUES ("PR4_3","021_4_3","PRO","4","3","3","Ka pa capa na awm nyng, Ka nu a ca, capa a lungnak soeih na awm nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR4_4","021_4_4","PRO","4","4","4","Ni cawngpyi nawh, ka venawh, “Nak kawlung ing kak awikhqi ve kym poe sei taw; kak awipekkhqi ce haana nawh hqing pyi,” ti hy. ");
INSERT INTO hltthb_vpl VALUES ("PR4_5","021_4_5","PRO","4","5","5","Cyihnaak thlai nawh, zaaksimnaak awm thlai. Koeh hilh nawh, kam kha awhkawng ak cawn law awiyynnaakkhqi ce seetnaak lam benna koeh mang taak. ");
INSERT INTO hltthb_vpl VALUES ("PR4_6","021_4_6","PRO","4","6","6","Koeh hawi taak nawh, nik chungkhoep kaw; lung na nawh, ni khoemdoen kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR4_7","021_4_7","PRO","4","7","7","Cyihnaak veni a kungpyi soeih hy; cemyihna awmsaw cyihnaak ce thlai; na khawhkhamkhqi boeih ingawm cyihnaak ce thlai. ");
INSERT INTO hltthb_vpl VALUES ("PR4_8","021_4_8","PRO","4","8","8","Zoeksang nawh, anih ing ni zoeksang lawt kaw; na ym na lam awhtaw kqihchah kawi thlangna ning coeng sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR4_9","021_4_9","PRO","4","9","9","Na luu-awh mikhaileek lumyk ning byng sak kawm saw, dawnaak boei lumyk ni pe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR4_10","021_4_10","PRO","4","10","10","Ka capa, kak awi ngai nawh kym lah; Cawhtaw na hqing kum pung khqoet khqoet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR4_11","021_4_11","PRO","4","11","11","Cyihnaak lamawh ni cawngpyi nyng, dyngnaak lamawh ni sawi nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR4_12","021_4_12","PRO","4","12","12","Na ceh huiawh nak khawkan ing zaang nawh, nang dawngawh awm am tawngtawh kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR4_13","021_4_13","PRO","4","13","13","Cawngpyinaak awh ak cakna tu nawh, koeh hlah; ak cakna tu, na hqingnaak ham ni. ");
INSERT INTO hltthb_vpl VALUES ("PR4_14","021_4_14","PRO","4","14","14","Thlakchekhqi cehnaak awh koeh plaa nawh, thlakhalangkhqi a cehnaak awh koeh cet. ");
INSERT INTO hltthb_vpl VALUES ("PR4_15","021_4_15","PRO","4","15","15","Qei nawh taw, a vena koeh cet; mangtaak nawh loen taak. ");
INSERT INTO hltthb_vpl VALUES ("PR4_16","021_4_16","PRO","4","16","16","Kut a mamik thlak khui taw am ip thai kawm usaw, thlang ak khanawh seetnaak a mi sai hlan khui taw mik am kuu kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR4_17","021_4_17","PRO","4","17","17","Seetnaak phaipi ce ai unawh, them amak leek sainaak misurtui ce aw uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","18","Thlakdyngkhqi a cehnaak lam taw khawkbee ang lakawh bee khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR4_19","021_4_19","PRO","4","19","19","Thlakchekhqi a cehnaak lam taw khawmthan amyihna ikawh a ming tawh am sim uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR4_20","021_4_20","PRO","4","20","20","Ka capa, kak awi ngai nawh, kak awipek awh nang haa dun lah. ");
INSERT INTO hltthb_vpl VALUES ("PR4_21","021_4_21","PRO","4","21","21","Namik huh awhkawng koeh thoeng; nak kawlung khuiawh khoem. ");
INSERT INTO hltthb_vpl VALUES ("PR4_22","021_4_22","PRO","4","22","22","Ak hukhqi ham hqingnaak na awm nawh, a mi pumsa ham sadingnaak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR4_23","021_4_23","PRO","4","23","23","Ak chang boeih ang lakawh nak kawlung ce doen, hqingnaak ak cawnnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR4_24","021_4_24","PRO","4","24","24","Nam khaawh awihche koeh cawn sak nawh, thlang koeh thailat na. ");
INSERT INTO hltthb_vpl VALUES ("PR4_25","021_4_25","PRO","4","25","25","Na mik ing hailam dan nawh, ak leekna na hai lam toek. ");
INSERT INTO hltthb_vpl VALUES ("PR4_26","021_4_26","PRO","4","26","26","Na khaw ham lamtlak ce chei nawh, na lampyi boeih ce cak sak. ");
INSERT INTO hltthb_vpl VALUES ("PR4_27","021_4_27","PRO","4","27","27","Nak tang ben mai aw, nak cawng ben mai awi koeh pleng; seetnaak awhkawng na khaw ce thoeih. ");
INSERT INTO hltthb_vpl VALUES ("PR5_1","021_5_1","PRO","5","1","1","Ka capa, ka cyihnaak ngai nawh, kak kawcyihnaak awh nang haa keng lah. ");
INSERT INTO hltthb_vpl VALUES ("PR5_2","021_5_2","PRO","5","2","2","Khawkpoek thainaak ce khoem nawh, na hui nam lai ing simthainaak nam tu naak hamna. ");
INSERT INTO hltthb_vpl VALUES ("PR5_3","021_5_3","PRO","5","3","3","Nukche a hui awhkawng khawitui cip nawh, am lai ce situi anglakawh plai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR5_4","021_5_4","PRO","5","4","4","A dytnaakna ankhamyihna kha nawh, pinhai amyihna hqaat hy. ");
INSERT INTO hltthb_vpl VALUES ("PR5_5","021_5_5","PRO","5","5","5","A khaw ing thihnaak lam pan nawh, a khawngkham ing ceikhui lam pan hy. ");
INSERT INTO hltthb_vpl VALUES ("PR5_6","021_5_6","PRO","5","6","6","Hqingnaak lam am huthai nawh, a cehnaak lam a mam dyng ce am huthai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR5_7","021_5_7","PRO","5","7","7","Ceamyihna awmsaw ka cakhqi aw, kak awi ngai unawh, kam kha awhkaw awi ak cawn law ve koeh mang tak. ");
INSERT INTO hltthb_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Na lam ce anih awhkawng lak hla sak nawh, ak chawmkeng koeh va hem. ");
INSERT INTO hltthb_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","Cemyih kaataw na dawnaak ce thlang chang ven pe kawm saw, na kum ce khawsak amak leek thlang ven pe kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR5_10","021_5_10","PRO","5","10","10","Thlak changkhqi ce nak thaqui phu ham sak khqi nawh, na bibi phu ce am na siim imlangna pha kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR5_11","021_5_11","PRO","5","11","11","Na haikhaw a dyt lawawh na pum na saana hawn nawh kqaang kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR5_12","021_5_12","PRO","5","12","12","Cawhce, “Kawhamna cawngpyinaak ak thym ce hoet nawh, kak kawlung ing toelnaak ce kak husit qoe nu, ");
INSERT INTO hltthb_vpl VALUES ("PR5_13","021_5_13","PRO","5","13","13","A nik cawngpyikungkhqi ak awi am haana nyng, a nik cawngpyikungkhqi venna kang haa am na keng nyng; ");
INSERT INTO hltthb_vpl VALUES ("PR5_14","021_5_14","PRO","5","14","14","Thlang kqeeng ingkaw thlanghoei anglak-awh ka thih hlo hy,” ti kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","Na tui im awhkaw tui na tuipum ing thaan nawh aw. ");
INSERT INTO hltthb_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","Na tuihaa ce doem sak nawh lam keng awhkaw ak lawng hawk hawk tuinu amyihna coeng sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","Namah ham doengna awm seitaw thlak-chang ing koeh ni qup pyi seh. ");
INSERT INTO hltthb_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","Na tui im awh zoseennaak awm seitaw, nak thaawm huiawh kaw na zuuawh ce nak kaw zeel sak. ");
INSERT INTO hltthb_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","A nih ce lungnak ak kap saksuk ingkaw ak daw soeih sakkhi amyihna, kawmyih a tym awhawm a lungnak ing nang ce ni zeel sak poe seh. ");
INSERT INTO hltthb_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","Ikaw hamnanu nang, ka capa ing nukche awh na zeel hly nawh ak kqang awh nang kooep hly? ");
INSERT INTO hltthb_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Thlanghqing a cehnaak lam boeih ce Bawipa mik huhawh awm boeih nawh, a cehnaak lamkhqi boeih ce kawng sak boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Amah a awmseetnaak ing thlakche ce tu kawm saw, a seetnaak qui ingawh amah ce pinzen kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Cawngpyinaak a khawdeng caming thi kawm saw, a qawnak caming plam kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR6_1","021_6_1","PRO","6","1","1","Ka capa, na pyi ham qii khoeng nawh khawlawng thlang khanawh na kut nak thlak awhtaw, ");
INSERT INTO hltthb_vpl VALUES ("PR6_2","021_6_2","PRO","6","2","2","Nak awiawh namah awk nawh, nak awi kqawn ing namah ni pin nawh ni. ");
INSERT INTO hltthb_vpl VALUES ("PR6_3","021_6_3","PRO","6","3","3","Ka capa, na pyi a kutawh taang vit hynyng ti nang simqu awhtaw na loetnaak hamna vemyihna sai kawp ti, na pyi venna cet, nak kawlung ce ak kaina phaih nawh qeennaak thoeh kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR6_4","021_6_4","PRO","6","4","4","Koeh ip, namik koeh kuu sak qoe kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR6_5","021_6_5","PRO","6","5","5","Sakzyym a kut awhkawng sakkhi a cen amyih ingkaw phak zym a kut awhkawng pha ang ding valh amyihna namah ce hul qu kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR6_6","021_6_6","PRO","6","6","6","Nang, thakdam pa, liing avena cet nawh, a khawsak ce toek nawh na cyih ta lah; ");
INSERT INTO hltthb_vpl VALUES ("PR6_7","021_6_7","PRO","6","7","7","Anih ing boei, ak sawikung, khawkkhan kung am ta na. ");
INSERT INTO hltthb_vpl VALUES ("PR6_8","021_6_8","PRO","6","8","8","Khawhqai awh a buh cun nawh cangmaa awh a ai sui hy. ");
INSERT INTO hltthb_vpl VALUES ("PR6_9","021_6_9","PRO","6","9","9","Aw, thakdam pa, iqyt dy nu na ih hly? Ityk awh nu na ihnaak awhkawng na thawh hly? ");
INSERT INTO hltthb_vpl VALUES ("PR6_10","021_6_10","PRO","6","10","10","Na ngaih awhtaw ip, ngam, kut boem nawh zaih, ");
INSERT INTO hltthb_vpl VALUES ("PR6_11","021_6_11","PRO","6","11","11","Na ih hlanawh khawdengnaak ing khit cet amyihna ni pha kawm saw, awk voet ai vainaak ing ak tlung amyihna thoeng law kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR6_12","021_6_12","PRO","6","12","12","Thlakche ingkaw khawboeche thlang taw am khaaawh awioelhnaak ing ni a plam thaam hy. ");
INSERT INTO hltthb_vpl VALUES ("PR6_13","021_6_13","PRO","6","13","13","Amik ing mikhqih, a khaw ing awi kqawn a kut dawn ing pho sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR6_14","021_6_14","PRO","6","14","14","Ak kawlung am dyng nawh, seetnaak sai ham poeknaak ta poepa nawh, hqeehnaak sai poepa hy. ");
INSERT INTO hltthb_vpl VALUES ("PR6_15","021_6_15","PRO","6","15","15","Cedawngawh ak poek kaana kyinaak ing thoeng law nawh bawtbetawh seetnaak ing pha kawm saw qoeinaak a huh voel kaana. ");
INSERT INTO hltthb_vpl VALUES ("PR6_16","021_6_16","PRO","6","16","16","Khawsa ing a sawhnaak khquk awm nawh am tuih soeih khqeet awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR6_17","021_6_17","PRO","6","17","17","Ak oe qu mikhai, thailatnaak ing ak be lai, thlakdyng a hqingnak ak lo kut, ");
INSERT INTO hltthb_vpl VALUES ("PR6_18","021_6_18","PRO","6","18","18","amak leek them ak poek kawlung, thawlh sainaak benna hqingtawn ing ak dawng khaw, ");
INSERT INTO hltthb_vpl VALUES ("PR6_19","021_6_19","PRO","6","19","19","a qaai kqawn nawh thailatnaak ing ak bee, ciingnapaca lakawh hqehnaak ak sai. ");
INSERT INTO hltthb_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Ka capa, na pa awipek ve ngai nawh, na nu cawngpyinaak ce koeh mang taak. ");
INSERT INTO hltthb_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Na kawlungawh khoemnawh, na hawngawh aawi poe lah. ");
INSERT INTO hltthb_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","Na cehnaak hoeiawh ni hqui nawh, na ih hui awhawm ni doen kawm saw, na thawh lawawh ni tym pau pyi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Awipek taw maihchoei na awm nawh, cawngpyinaak taw vaangnak ni, toelthamnaak taw hqingnaak lampyi ni. ");
INSERT INTO hltthb_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","Nu amak leek ingkaw awih tui ing thlang ak zoek thlangthai nu ang laak awhkawng a nik doen hamna; ");
INSERT INTO hltthb_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Nak kawlung ing a dawnaak koeh nai nawh, a mikkhu ing koeh ni zoek seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR6_26","021_6_26","PRO","6","26","26","Pum ak zawi nu ak caming pa ing phaipi cunoet doeng ham nawh, samphaih nu ing hqinglung phutlo ce khoem thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR6_27","021_6_27","PRO","6","27","27","Thlang ing a hii a uih kaana mai ce pawm hly thai nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PR6_28","021_6_28","PRO","6","28","28","Thlang ing a khaw a uih kaana maihling leeh hly thai nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("PR6_29","021_6_29","PRO","6","29","29","A pyi a zuu venna cet nawh ak hei taw a uu pynoet awm kut thlak kaana am voei ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR6_30","021_6_30","PRO","6","30","30","Ak phoencawih dipnaak ham ak quu thlang awm am loet ti kaw; ");
INSERT INTO hltthb_vpl VALUES ("PR6_31","021_6_31","PRO","6","31","31","A mi huh awhtaw a pyh khqihna sah seitaw a im awhkaw a them a long boeih ing sah kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR6_32","021_6_32","PRO","6","32","32","Kawlung ak talh nu taw samphaih, a hqinglu a seetnaak ham bi ak sai ni. ");
INSERT INTO hltthb_vpl VALUES ("PR6_33","021_6_33","PRO","6","33","33","Tlohnat ingkaw chah phyi kawm saw ming seetnaak ce ham kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR6_34","021_6_34","PRO","6","34","34","Yytnaak kawlung taw pa khqi kawsonaak na awm nawh phu sui nynawh am loet ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR6_35","021_6_35","PRO","6","35","35","A mikhuh awh tlansum pynoet awm am khyn kawm saw them khawzah pek ingawm kaw am zeel sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR7_1","021_7_1","PRO","7","1","1","Ka capa, kak awi kqawn ve ngai nawh, kak awipek khqi boeih ve kym lah. ");
INSERT INTO hltthb_vpl VALUES ("PR7_2","021_7_2","PRO","7","2","2","Kak awipek khqi ce haana nawh hqing pyi; kak awipek boeih ve mik amyihna qeetna. ");
INSERT INTO hltthb_vpl VALUES ("PR7_3","021_7_3","PRO","7","3","3","Na kutawh byn nawh nak lingbyi catlap awh qee. ");
INSERT INTO hltthb_vpl VALUES ("PR7_4","021_7_4","PRO","7","4","4","Cyihnaak venawh, “Ka nanu nang ni,” ti nawh, zaaksimnaak ce nam cawtnu na khy. ");
INSERT INTO hltthb_vpl VALUES ("PR7_5","021_7_5","PRO","7","5","5","Nuk chee lakawh ni doen nawh khawsak amak leek nu a sykzoeknaak awhkawng a ni doen naak ham. ");
INSERT INTO hltthb_vpl VALUES ("PR7_6","021_7_6","PRO","7","6","6","Ka im chawhhlep ak poek awhkawng qyym nyng, ");
INSERT INTO hltthb_vpl VALUES ("PR7_7","021_7_7","PRO","7","7","7","Kawlung amak soep cadawng khqi ang lak awh cadawng poekthainaak amak ta ce hu nyng saw, ");
INSERT INTO hltthb_vpl VALUES ("PR7_8","021_7_8","PRO","7","8","8","Nula a awmnaak lamkil benna ce cet nawh a im lam ce pan hy. ");
INSERT INTO hltthb_vpl VALUES ("PR7_9","021_7_9","PRO","7","9","9","Khawmy nawh khawmthan, thanlung khuiawh ce nula im lam ce pan hy. ");
INSERT INTO hltthb_vpl VALUES ("PR7_10","021_7_10","PRO","7","10","10","Ce nula taw pum ak zawi suihsak ing hlawihhlan qu nawh thailatnaak ing ak khawsa ni. ");
INSERT INTO hltthb_vpl VALUES ("PR7_11","021_7_11","PRO","7","11","11","A hyy tho nawh imawh awm poekpoek ham am ngaih nawh a khawphaa ing dym am ngaih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR7_12","021_7_12","PRO","7","12","12","Tuhqoe awm imkawt awh, imkil awh, lamkil a hoeiawh van nawh sui hy. ");
INSERT INTO hltthb_vpl VALUES ("PR7_13","021_7_13","PRO","7","13","13","A huh cadawng ce tunawh mawk hy, a hat thlang amyihna a venawh, ");
INSERT INTO hltthb_vpl VALUES ("PR7_14","021_7_14","PRO","7","14","14","“Kaiawh qoepnaak hyih phum ham ka taak ce, tuhngawi kak awikam amyihna pha hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("PR7_15","021_7_15","PRO","7","15","15","Ceamyihna awm saw nang ak do ham ingkaw ak sui hamna law nyng, nang nihuk khoem nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR7_16","021_7_16","PRO","7","16","16","Ka ihkhunawh hiphaih ak leek soeih, Egypt hiphaih ce phaih nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR7_17","021_7_17","PRO","7","17","17","Ka ihkhun ce myrrah, aloe ingkaw thikuii ing hloen boeih hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR7_18","021_7_18","PRO","7","18","18","Law lah, mymcang khaw a thaih hlan dy lungnaak ing nawm haih lah sih, lungnak ingawh ngaihsoep sak lah sih nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR7_19","021_7_19","PRO","7","19","19","Imawh ka vaa am awm hy, khawlawnk hla na khinna dii hy. ");
INSERT INTO hltthb_vpl VALUES ("PR7_20","021_7_20","PRO","7","20","20","Tangka bawm khyn nawh, pihla a lum hlan dy am voei law hly hy,” ti na hy. ");
INSERT INTO hltthb_vpl VALUES ("PR7_21","021_7_21","PRO","7","21","21","Ak awitui ing sykzoek nawh, am kyihcah qunaak ing lam hang pyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR7_22","021_7_22","PRO","7","22","22","Cedawngawh him hamna a mi sawi vaitaw, ak qaw ami phepnaak qui aawi hamna ak cet, ");
INSERT INTO hltthb_vpl VALUES ("PR7_23","021_7_23","PRO","7","23","23","Pha ing a thih hly a siim kaana ang hlaa ing ding nawh dawng lam a pan amyihna nula hu nace baang pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("PR7_24","021_7_24","PRO","7","24","24","Cedawngawh ka capa khqi aw, kak awi ve ngai unawh, kam khaa awhkaw awi ak cawn law ve haana lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PR7_25","021_7_25","PRO","7","25","25","Nak kawlung ing a lamawh koeh hquut sei taw, a lampyi awhkawng ce pleeng seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR7_26","021_7_26","PRO","7","26","26","Anih ing thlang khawzah leembai sak nawh, a him khqi awm thlang khawzah ni. ");
INSERT INTO hltthb_vpl VALUES ("PR7_27","021_7_27","PRO","7","27","27","A im taw Ceeikhui cehnaak lamna awm nawh, thihnaak imkhui na ak sawikung ni. ");
INSERT INTO hltthb_vpl VALUES ("PR8_1","021_8_1","PRO","8","1","1","Cyihnaak ing khyy nawh, zaaksimnaak ing ak awi am yy nawh aw? ");
INSERT INTO hltthb_vpl VALUES ("PR8_2","021_8_2","PRO","8","2","2","Lampyi hoeiawh, lampyi kengsam hoeiawh ce dyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR8_3","021_8_3","PRO","8","3","3","Khawk khui lutnak vawng kengawh, vawngkawt kengawh ce dyi nawh thayy ing khyy hy. ");
INSERT INTO hltthb_vpl VALUES ("PR8_4","021_8_4","PRO","8","4","4","Aw nangmih thlanghqing khqi, nik khy khqi nyng, kak awi ve thlanghqing khqi ham ni. ");
INSERT INTO hltthb_vpl VALUES ("PR8_5","021_8_5","PRO","8","5","5","Aw nangmih thlangzap khqi, khingaihnaak ve toen lah uh; nangmih thlakqaw khqi aw, cyihnaak kawlung toen lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PR8_6","021_8_6","PRO","8","6","6","Ngaih lah uh, nangmih ham awileek soeih kqawn hly nyng, kak awi kqawn boeih ve ak thyym boeih ni. ");
INSERT INTO hltthb_vpl VALUES ("PR8_7","021_8_7","PRO","8","7","7","Ka huui ing awihthyym saa nawh, kam lai ing them amak leek ce maa hy. ");
INSERT INTO hltthb_vpl VALUES ("PR8_8","021_8_8","PRO","8","8","8","Kam khaa awhkaw awilung boeih ve amak thyym ingkaw hoet ham kawi am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR8_9","021_8_9","PRO","8","9","9","Ak zaasiim ham dang pheng nawh, cyihnaak ak taa khqi ham a hqeenaak pynoet awm am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR8_10","021_8_10","PRO","8","10","10","Ngun lakawh toelthamnaak ce tyk nawh, sui lakawh cyihnaak ce tyk lah. ");
INSERT INTO hltthb_vpl VALUES ("PR8_11","021_8_11","PRO","8","11","11","Cyihnaak taw suilung ang lakawh a phu tlo ngai nawh anih ingqawi myihteh ham kawi ak chang am awm voel hy. ");
INSERT INTO hltthb_vpl VALUES ("PR8_12","021_8_12","PRO","8","12","12","Kai, cyihnak taw, ngaihtaaknaak ing awm haih nih nyng, cyihnaak ingkaw ngaihtaaknaak ce ta nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR8_13","021_8_13","PRO","8","13","13","Bawipa kqihchah taw amak leek them sawhnaak ni; oequnaak, hoelqunaak, khawboe seetnaak ingkaw amak thyym awikqawnnaak khqi ce sawh na nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR8_14","021_8_14","PRO","8","14","14","Khawkhannaak ak thyym ingkaw siimnaak ak thyym ce ka koe ni; simthainaak ingkaw saithainaak awm ka koe ni. ");
INSERT INTO hltthb_vpl VALUES ("PR8_15","021_8_15","PRO","8","15","15","Kaih caming boeikhqi ing boei ngawihnaak awh ngawi unawh, ukkungkhqi ing ak thyymna awitlyk uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR8_16","021_8_16","PRO","8","16","16","Kaih caming sangpahrangkhqi ing awitlyk unawh, kyiqangkhqi ingkaw khawmdek ukkungkhqi boeih ing awm. ");
INSERT INTO hltthb_vpl VALUES ("PR8_17","021_8_17","PRO","8","17","17","Kai a nik lungnaak thlangkhqi ce lungnak khqi nyng, kai a nik sui thlangkhqi ing ni hu kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR8_18","021_8_18","PRO","8","18","18","Khawhthem ingkaw boeimangnaak khqi ka venawh awm nawh, kyihcahnaak ingkaw dyngnaak khqi boeih awm ka venawh awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR8_19","021_8_19","PRO","8","19","19","Kak thaih taw sui lakawh a phu tlo nawh ngun ak leek soeih lakawh awm a phu tlo ngai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR8_20","021_8_20","PRO","8","20","20","Dyngnaak lampyi awh cet nyng, ak thyym lampyi ce tut nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR8_21","021_8_21","PRO","8","21","21","Kai a nik lungnak thlangkhqi venawh khawh ing bee khqi nawh ami qo bawm ce kak bee nak pek khqi hamna. ");
INSERT INTO hltthb_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","Bawipa ing a theem syyn lammaacyk amyihna kai ni ta nawh, syynawh a them seh cyk awhkawng ce. ");
INSERT INTO hltthb_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","Kumqui hamna, ak cyk soeihna syynna awm nyng, khawmdek a syyn hlan awh. ");
INSERT INTO hltthb_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Tuicunlii a syyn hlannawh lawngcatui ang lawng hlanawh syynna awm hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","Tlang khqi a awm hlannawh khawmcung khqi a awm hlanawh kai syyn hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","Khawmdek ingkaw khawhyn khawqaam khqi a syyn hlannawh dekvaai awm a awm hlanawh kai syyn hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Khan ce amah a hyynawh a taak nawh tuidung haaiawh lawnglam a sai hlanawh syyn hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","A saangnak khan hyynawh ciingmaikhqi a sah sak nawh tuicunlii khuina ak lawng tuihawk khqi a sai huiawh, ");
INSERT INTO hltthb_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","Tui ing ak awipek ama poengnaak thai ham tuicunlii awhkaw langhak khqi, lawngca ang lawngnaak khawqii khqi a sai huiawh syyn awh nyngp ");
INSERT INTO hltthb_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","Kutthoem thlang amyihna avenawh awm pe nyng, a awmhlynaakna awm nyng, a venawh awmhlynaak ing bee poepa lawt nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","A khawmdek saiawh awmhlynaak ta nyng saw thlanghqing khqi khanawh zeelmangnaak ta nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR8_32","021_8_32","PRO","8","32","32","Cedawngawh, ka ca khqi, kak awi ngai lah uh, ka lam ak tut khqi taw a zoseen thlang khqi ni. ");
INSERT INTO hltthb_vpl VALUES ("PR8_33","021_8_33","PRO","8","33","33","Ka cawngpyinaak ve haana unawh cyi unawh koeh maa uh. ");
INSERT INTO hltthb_vpl VALUES ("PR8_34","021_8_34","PRO","8","34","34","Kak chawmkeng awh qeh nawh, ka ipkhui kawtawh qeh nawh kak awi ak ngai ak zaa thlang taw a zoseen thlang ni. ");
INSERT INTO hltthb_vpl VALUES ("PR8_35","021_8_35","PRO","8","35","35","Anik hu ak thlang boeih ing hqingnaak hu unawh, Khawsa huhhlynaak ce ham kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR8_36","021_8_36","PRO","8","36","36","Cehlai, kai anik hang ak thlang taw a hqingnaak ak khanawh kut ak thlaana awm kawm saw, kai anik sawhnaak ak thlang taw thihnaak ak lungnaak ak thlangna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Cyihnaak ing a im sa nawh, ak tung khqih ling hy. ");
INSERT INTO hltthb_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","Ak khqin ce him nawh misurtui ce tloeih nawh ak caboei ce phaih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","A bibikung nula khqi ce tyi khqi nawh, khawkkhui a sangnaak hynna cet unawh kyy uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","“Cyihnaak amak ta khqi boeih vebenna law lah uh,” tinawh siimnaak amak ta khqi ce khyy khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","“Law unawh taw, ka buh ai unawh kak tloeih cee misurtui ce aw lah uh. ");
INSERT INTO hltthb_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Aw nangmih thlakqawkhqi aw qaawnaak lam ce cehtaak unawh hqing lah uh; siimnak lamawh ce cet lah uh,” ti hy. ");
INSERT INTO hltthb_vpl VALUES ("PR9_7","021_9_7","PRO","9","7","7","Thlaktlai ak toel kung ing chah pyi lat nawh, thlakche ak ho kung ing kut zaawk lat hy. ");
INSERT INTO hltthb_vpl VALUES ("PR9_8","021_9_8","PRO","9","8","8","Thlaktlai ce koeh toel, ni sawh na kaw, thlakcyi mah toel, anih ing ni lung na kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR9_9","021_9_9","PRO","9","9","9","Thlakcyi ce toel lah, a cyihnaak pung khqoet kaw; thlakcyi ce cawngpyi lah, a simnaak ing pung khqoet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","Bawipa kqihchahnaak taw cyihnaak a kungpyina awm nawh, ak ciim siimnaak cetaw zaaksimnaakna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR9_11","021_9_11","PRO","9","11","11","Kaih caming na khawkum pung khqoet kawm saw, na hqingnak khawnghii ing sau khqoet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR9_12","021_9_12","PRO","9","12","12","Na cyih awhtaw, namah ham nak cyina awm kawm saw, thlaktlaina na awm awhtaw namah ing zaawk kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR9_13","021_9_13","PRO","9","13","13","Nukche ing akut am khoem poek nawh, a khawboe see nawh, am cyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR9_14","021_9_14","PRO","9","14","14","A im chawmkengawh ngawi nawh, khawkkhui hynsang ngawihnaak awhce ngawi nawh, ");
INSERT INTO hltthb_vpl VALUES ("PR9_15","021_9_15","PRO","9","15","15","A mimah lamawh ak cet khqi ce khy khqi nawh, ");
INSERT INTO hltthb_vpl VALUES ("PR9_16","021_9_16","PRO","9","16","16","“Khaw amak simkhqi boeih vena law seh,” ti nawh khyy hy. Siimthainaak amak ta khqi venawh bai, ");
INSERT INTO hltthb_vpl VALUES ("PR9_17","021_9_17","PRO","9","17","17","“Quuk tui taw aawi dikdik nawh, quuk buh ai taw aawp hy,” ti hy ");
INSERT INTO hltthb_vpl VALUES ("PR9_18","021_9_18","PRO","9","18","18","Cehlai cawhce thihnaak awm nawh a cei ak thlangkhqi ing Ceeikhui dung soeihna amik awm ni ti am sim uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_1","021_10_1","PRO","10","1","1","Solomon ak awicyih taw: capa ak cyi ing pa ak kaw zeel sak nawh, capa ak qaw ing nu ak kaw seet sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_2","021_10_2","PRO","10","2","2","Amak thyymna khawhtheem huh ing phu am ta nawh, dyyngnaak ingtaw thihnaak awhkawng hul hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_3","021_10_3","PRO","10","3","3","Thlakdyng ce Bawipa ing buh am lum sak nawh, amak dyng thlang ang sytnaak ce plaltham sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR10_4","021_10_4","PRO","10","4","4","Thakdam kut ing thlang khawdeng sak nawh, thlangmeet kut ing thlang boei sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_5","021_10_5","PRO","10","5","5","Cangah huiawh aawk ai ak cun ak thlang taw capa ak cyina awm nawh, cangah huiawh ak ip dutdut ak thlang taw thangseet ak pe capa ni. ");
INSERT INTO hltthb_vpl VALUES ("PR10_6","021_10_6","PRO","10","6","6","Thlakdyng a luawh zoseennaak awm nawh, thlakche am khaaawh boeseetnaak ing bee hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_7","021_10_7","PRO","10","7","7","Thlakdyng siimnaak taw zoseennaakna awm nawh, thlakche ming taw tlawihzip kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR10_8","021_10_8","PRO","10","8","8","Thlakcyi ingtaw ak kawlung ing awipek khqi ce do nawh, thlakqaw ingtaw plamtham sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_9","021_10_9","PRO","10","9","9","Dyng nawh ak thyy lamawh ak cet thlang taw a lam cet dyng nawh, cehlai, lam ak kaawiawh ak cet thlang taw pholang ngai kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR10_10","021_10_10","PRO","10","10","10","Mik ingawh ak mikhqihkhqi ing seetnaak pha sak nawh, thlakqaw awihpungkhqi ing tlu kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR10_11","021_10_11","PRO","10","11","11","Thlakdyng am laaiawh hqingnaak tui lawng nawh, cehlai thlakche am khaaawh amak leek them ing bee hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_12","021_10_12","PRO","10","12","12","Sawhnaak ing kqeengnaak pha sak nawh, lungnaak ingtaw seetnaak boeih ce hlipdah khoep hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_13","021_10_13","PRO","10","13","13","Ak che ak leek ak hqimhqaa thai am khaaawh cyihnaak ce dang nawh; cehlai ak che ak leek amak hqimhqaa thai am tingawh cumcik awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_14","021_10_14","PRO","10","14","14","Thlakcyikhqi ing cyihnaak ce cun nawh; thlakqaw am khaa ing thihnaak zoe sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_15","021_10_15","PRO","10","15","15","Mangpa a khawhkham taw a khawkkhui chungnaak vawng na awm hy, cehlai khawdengnaak taw ak khawdeng khqi hamna patangnaak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_16","021_10_16","PRO","10","16","16","Thlakdyng a bibi phu ing hqingnaak pha sak nawh, amak dyng thlang ingtaw toelthamnaak pha sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_17","021_10_17","PRO","10","17","17","Toelthamnaak awi ak ngai ing hqingnaak lamawh cet nawh, toelthamnaak awi amak ngai ingtaw lam hang hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_18","021_10_18","PRO","10","18","18","Thlang sawhnaak ak thuhphah ing thailatnaak ak awi kqawnnaak hui toen nawh thlang lakawh thlang ak theet thlang taw thlakqaw ni. ");
INSERT INTO hltthb_vpl VALUES ("PR10_19","021_10_19","PRO","10","19","19","Awi a doem naak awh hqo tho nawh, ak awi ak cyyp ak thlang taw thakcyi ni. ");
INSERT INTO hltthb_vpl VALUES ("PR10_20","021_10_20","PRO","10","20","20","Thlakdyng ak awi taw ak tlo soeih ngun ing myih nawh, thlakche ak kawlung taw huham amak taa ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_21","021_10_21","PRO","10","21","21","Thlakdyng a hui am lai ing thlang khawzah cawmcah nawh, thlakqaw ingtaw simthainaak khawdeng nawh thi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_22","021_10_22","PRO","10","22","22","Bawipa a zoseennaak ing boeimang sak nawh, patangnaak am tawmsap hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_23","021_10_23","PRO","10","23","23","Thlakqaw ingtaw theem amak leek sainaak awh awmhly nawh, thlakcyi ingtaw cyihnaak awh awmhly hy. ");
INSERT INTO hltthb_vpl VALUES ("PR10_24","021_10_24","PRO","10","24","24","Thlakqaw taw kqihnaak ing zawlkhoep kawm saw, thlankdyng taw ang syt boeih pekna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR10_25","021_10_25","PRO","10","25","25","Amak dyng thlang khqi taw khawhlii ing zaawn khqi saw qeeng boeih kawm uh. Thlakdyng taw kumqui ak cak lungnu amyihna dyi poepa kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR10_26","021_10_26","PRO","10","26","26","Thlang thakdam taw haa ak zaa sak misur tui ak thui ingkaw mik ak thiip sak maikhu amyihna, ak tyi khqi hamna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR10_27","021_10_27","PRO","10","27","27","Bawipa kqihchahnaak ing khawkum sang sak kawm saw, cehlai thlang amak leek khqi khawkum taw tawi sakna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR10_28","021_10_28","PRO","10","28","28","Thlakdyngkhqi a ngaih-uunaak taw awmhlynaak na awm nawh, amak dyng thlangkhqi ang ngaih-uunaak taw a hqawngna coeng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR10_29","021_10_29","PRO","10","29","29","Bawipa a lampyi taw thlakdyngkhqi ham thukzingnaak na awm nawh, theem amak leek ak saikhqi ham taw thihnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR10_30","021_10_30","PRO","10","30","30","thlakdyngkhqi taw thoengna am awm kawm usaw, amak dyng thlangkhqi taw khawmdek awh am khawsa kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR10_31","021_10_31","PRO","10","31","31","Thlakdyng am khak khui awhkawng cyihnaak thoeng law nawh, amak leek theem ak saikhqi am lai taw qeet pekna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR10_32","021_10_32","PRO","10","32","32","Thlakdyngkhqi am khaaawh ai kawi cawn nawh, khawsak amak leek am khaaawh amak leek them doeng cawn poepa hy. ");
INSERT INTO hltthb_vpl VALUES ("PR11_1","021_11_1","PRO","11","1","1","Bawipa ing amak thyym cawi tahnak ce tuih nawh ak thyym cawi tahnaak ce ym hy. ");
INSERT INTO hltthb_vpl VALUES ("PR11_2","021_11_2","PRO","11","2","2","Oequnaak a awm naak awh chahphyihnaak awm nawh, thlakkaina kaw ak phaihkhqi venawh cyihnaak awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR11_3","021_11_3","PRO","11","3","3","Thlakdyngkhqi kawlung leeknaak ing leek-naak lamawh amimah sawi khqi kawm saw, thlang amak ypawmkhqi am ypawmnaak ing amimah plam sak khqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_4","021_11_4","PRO","11","4","4","Kawsonaak a awm khui taw khawhthem ing phu am ta kaw. Dyngnaak ingtaw thihnaak awhkawng loet sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_5","021_11_5","PRO","11","5","5","Thlakleek a dyngnaak ing lam huh kawm saw; khawsak amak leek thlang taw a seetnaak ing tluk sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_6","021_11_6","PRO","11","6","6","Thlakdyngkhqi taw ami dyngnaak ing ami-mah hul khqi kawm saw, amak dyng thlangkhqi taw seetnaak a mi sai ing amimah bin khqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_7","021_11_7","PRO","11","7","7","Ak thyymna khaw amak saa thlang taw a thihawh ang ngaih-uunaak awm boet pahoei nawh, ak thamahnaak ingkaw ang ngaih-uunaakkhqi boeih awm qeeng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_8","021_11_8","PRO","11","8","8","Thlakdyng taw kyyinaak a sawngawh loet sakna awm kawm saw, amak leek thlang ing a hyn pang tloep kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_9","021_11_9","PRO","11","9","9","Khawsa amak siim thlang am khaa ing a imceng lovai hqee nawh, thlakdyng ingtaw ak leek khawpoeknaak ing loet sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR11_10","021_11_10","PRO","11","10","10","Thlakdyngkhqi khawsak a vaanawh a tui a khaw ing awmhly nawh, thlakche a thihawh awmhlynaak ing thlakkhqi khyy uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR11_11","021_11_11","PRO","11","11","11","Thlakdyngkhqi a zoseennaak ing khawkkhui kyihcahna awm nawh, thlakchekhqi am khaa ing thangseet sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR11_12","021_11_12","PRO","11","12","12","A imceng ak husit thlang ing cyihnaak khawdeng nawh, kawcyih ak ta ingtaw am khaa cyyp sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR11_13","021_11_13","PRO","11","13","13","Awih doem ing awihhyp pho sak nawh, thlang ypawm ing awihhyp thuh phah khawi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR11_14","021_11_14","PRO","11","14","14","Sawikaainaak ak leek ama awm naak awh tluuknaak awm nawh, poeknaak ak leek a doemnaak awh noengnaak awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR11_15","021_11_15","PRO","11","15","15","Khawlawng thlang ham qii ak khoeng taw amah ham seetnaak ak saina awm nawh, qiik khoengkung ak toel thlang taw ding kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_16","021_11_16","PRO","11","16","16","Nukleek ing kyihcahnaak ham kawm saw, pakleek ing khawhthem ham kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_17","021_11_17","PRO","11","17","17","Thlangqeen khaw ak ngai ing amah ham theemleek ham nawh khawsak amak leek ingtaw a pumsa ham kyinaak ham kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_18","021_11_18","PRO","11","18","18","Thlakche ing thlang a thailatnaak phu hu nawh dyngnaak ak saw ingtaw laksawng do kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_19","021_11_19","PRO","11","19","19","Dyngnaak awh ak ypawm thlang ing hqingnaak ham nawh, seetnaak ak hquut ing thihnaak ham kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_20","021_11_20","PRO","11","20","20","Kawpoek amak leek thlang ce Khawsa ing tuih nawh, thlakdyng taw ym hy. ");
INSERT INTO hltthb_vpl VALUES ("PR11_21","021_11_21","PRO","11","21","21","Beqoep usei awm, khawsak amak leek thlangkhqi taw toeltham kaana am hlah khqi kawm uh. Cehlai, thlakdyng taw ak dingna cet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_22","021_11_22","PRO","11","22","22","Ak thlang daw mai seiawm, amak cyyp nula taw vawk a huiawh sui kutcyh byn pek ing myih kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_23","021_11_23","PRO","11","23","23","Thlakdyng a ngaihnaak taw themleek awh dyt nawh, thlakche ang ngaihypnaak taw kawsonaak ing boet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_24","021_11_24","PRO","11","24","24","Theem pek taw pungnak khqoet ni, khawboe seet taw khawdengnaak khqoet ni. ");
INSERT INTO hltthb_vpl VALUES ("PR11_25","021_11_25","PRO","11","25","25","Khawboe ak leek thlang taw boei kawm saw, tui ing thlang ak syyp thlang taw amah awm syymna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_26","021_11_26","PRO","11","26","26","Caang ak hlawh thlang taw kawseet na awm kawm saw, ak zaawi ak thlang taw zoseennaak ing bee kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_27","021_11_27","PRO","11","27","27","Themleek ak sui ing kawpeok leek moe qhum kawm nih saw, amak leek theem ak sui ingtaw amak leek theem mi hqum kawm nih. ");
INSERT INTO hltthb_vpl VALUES ("PR11_28","021_11_28","PRO","11","28","28","A them ak ypnaak thlang taw tlu kawm saw, thlakdyng taw thing a no amyihna hlultawi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_29","021_11_29","PRO","11","29","29","A imkhuiawh seetnaak ak saikung ing khawhlii qona pang kawm saw, thlakqaw ing thlakcyi a tamnaa na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR11_30","021_11_30","PRO","11","30","30","Thlakdyng ak thaihqah taw hqingnaak thingna awm nawh, thlakcyi ing thlang kawlung noeng hy. ");
INSERT INTO hltthb_vpl VALUES ("PR11_31","021_11_31","PRO","11","31","31","Ngai lah, thlakdyng pateng khawmdek awh thungna a awm awhtaw thlakche ingkaw thlak-thawlh khqoet taw ikawmyihana nu thungna a awm pai kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR12_1","021_12_1","PRO","12","1","1","Toelthamnaak ak lungnaak ing simnaak ce lungna nawh, zyihtoelnaak ak sawhnaak taw qamsa ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR12_2","021_12_2","PRO","12","2","2","Thlakdyng ing Bawipa kawzeelnaak hu nawh, theem amak leek ak sai ing Bawipa kawsonaak zaawk kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR12_3","021_12_3","PRO","12","3","3","Thlanghqing ve seet sainaak ing am cak sak nawh, thlakdyng ang dyih hyn taw cak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR12_4","021_12_4","PRO","12","4","4","Khawsak ak leek nu taw a vaa ham boei lumykna awm nawh, chahnaak kawi theem ak saipyi taw a vaa quh ak haawn sak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR12_5","021_12_5","PRO","12","5","5","Thlakdyng ak khawpoeknaak taw leek nawh, thlakche ak khawpoeknaak taw thailatnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR12_6","021_12_6","PRO","12","6","6","Thlakche ak awi ing thlang thi ang lawng hly qeh nawh, thlakdyng ak awi ingtaw amah loet sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR12_7","021_12_7","PRO","12","7","7","Khawsak amak leekkhqi taw khaawngna awm kawm saw qeeng kawm uh, thlakdyng a ipkhui taw ak cakna dyi poe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR12_8","021_12_8","PRO","12","8","8","Thlang a cyihtaak amyihna kyihcahna awm kawm saw, kawpoek amak leek thlang taw thlang ing hep kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR12_9","021_12_9","PRO","12","9","9","Kawpoek saang toen nawh aikawi amak ta ang lakawh, kawpoek neem nawh ikawm amak ta tamnaa taak ve leek ngai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","Thladyng ingtaw a qamsaa ai kawi ce poek nawh, cehlai, thlakqaw am qeennaak ak saang soeih taw thekhanaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR12_11","021_12_11","PRO","12","11","11","A lo awh bi ak bii thlang ingtaw ai kawi khawzah ta nawh, a naawmnaak ak sui thlang ingtaw cyihnaak am ta hy. ");
INSERT INTO hltthb_vpl VALUES ("PR12_12","021_12_12","PRO","12","12","12","Khawsak amak leekkhqi ing thlakchekhqi a lawk nai unawh, thlakdyngkhqi a zung taw cak poepa hy. ");
INSERT INTO hltthb_vpl VALUES ("PR12_13","021_12_13","PRO","12","13","13","Thlangthawlh taw amah ak awi awh aawk nawh, thlakdyng taw kyinaak awhkawng loet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR12_14","021_12_14","PRO","12","14","14","Thlang am lai thaih ing themleek bee sak nawh, amah a bii phu ing ak tingna pekna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR12_15","021_12_15","PRO","12","15","15","Thlakqaw ing amah mik huhawh a lam thyym sak hy, cehlai thlakcyi ingtaw thlak awi ngai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR12_16","021_12_16","PRO","12","16","16","Thlakqaw ing ak kawsonaak pho sak pahoei nawh, thlakcyi ingtaw chah kawi ce thuhphah hy. ");
INSERT INTO hltthb_vpl VALUES ("PR12_17","021_12_17","PRO","12","17","17","Awihthyym ak kqawn ing ypawmnaak dang sak nawh, amak thyym dyihthingna ak dyi taw thlangthai palat ni. ");
INSERT INTO hltthb_vpl VALUES ("PR12_18","021_12_18","PRO","12","18","18","Poek kaana awi tinaak ing cimcamyihna thlang sun nawh, thlakcyi ak awi ing thlang qoei sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR12_19","021_12_19","PRO","12","19","19","Hui ak thyym taw kumquina cak sakna awm kawm saw, qaai awi kqawn taw kawlhkalh ca ham ni. ");
INSERT INTO hltthb_vpl VALUES ("PR12_20","021_12_20","PRO","12","20","20","Them amak leek ak poekkhqi kawlungawh thailatnaak awm nawh, qoepnaak ak sai khqi hamna taw zeelmangnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR12_21","021_12_21","PRO","12","21","21","Thlakdyng ak khanawh amak leek them ing am pha kawm saw, khawsak amak leekkhqi cetaw amak leek them ingawh bee kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR12_22","021_12_22","PRO","12","22","22","Qaai ak kqawn am lai taw Bawipa ing sawh na nawh, ak thyymna ak khawsakhqi taw Bawipa ing ym khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR12_23","021_12_23","PRO","12","23","23","Thlakcyi ing cyihnaak thuh nawh. Thlakqaw kawlung ingtaw qawnaak dang sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR12_24","021_12_24","PRO","12","24","24","Thlak meetkhqi kut ing thlang uk kawm saw, thlang thakdamkhqi taw tamnaa bibinaak ing dyt kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR12_25","021_12_25","PRO","12","25","25","Lyynaak kawlung ing thlang patang sak nawh, awih leek ing thlang awmhly sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR12_26","021_12_26","PRO","12","26","26","Thlakdyng taw a imceng ham hquikungna awm nawh, khawsak amak leekkhqi ing kqeeng-naak pha sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR12_27","021_12_27","PRO","12","27","27","Thaa ak ngak ing a qamsaa kah saa am keuh hy, cehlai thaa ak meet ing a taak khawh khui awhkaw lo nawh thlang pe hy. ");
INSERT INTO hltthb_vpl VALUES ("PR12_28","021_12_28","PRO","12","28","28","Dyngnaak lamawh hqingnaak awm nawh, ce lamawh thihnaak am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Capak cyi ing a pa ak awiyyn ngai nawh, thlang ak husit ingtaw toelthamnaak awi maa hy. ");
INSERT INTO hltthb_vpl VALUES ("PR13_2","021_13_2","PRO","13","2","2","A huui awhkaw ak thaih leek awhkawng thlang ing ak thaih qah hu nawh, cehlai amak ypawm thlang ingtaw boeseet sai ce ngaih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR13_3","021_13_3","PRO","13","3","3","A hui am lai ak ngaihtaak thlang taw a hqingnaak khanawh ak ngaihtaak thlangna awm nawh, cehlai ak poek kaana awi ak saa paqaap qaap thlang taw plamtham kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","Thlang thakdam kawpoek ing a hoei ngaihnaak ta lawt hy, cehlai ikaw am ta hy. Thlakmeet ingtaw a ngaih boeih ce hu hy. ");
INSERT INTO hltthb_vpl VALUES ("PR13_5","021_13_5","PRO","13","5","5","Thlakdyng ingtaw amak thyym awi kqawn sawh na nawh, cehlai khawsak amak dyng thlang ingtaw chahnaak ing ming che phyih sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR13_6","021_13_6","PRO","13","6","6","Dyngnaak ing ak thyymna khawksaakhqi ce khoemdoenkhqi nawh, thawlhnaak ing thlakthawlhkhqi ce tluuk sak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR13_7","021_13_7","PRO","13","7","7","Boeina ak saa qu ikawm amak ta awm nawh, khawdengna ak saa qu ing khawhthem khawzah ak ta awm hy, ");
INSERT INTO hltthb_vpl VALUES ("PR13_8","021_13_8","PRO","13","8","8","Khawh ing ak taakung hqingnaak thawng thai nawh, cehlai khawdeng thlang ing thlang a theet vutnaak awi am za hy. ");
INSERT INTO hltthb_vpl VALUES ("PR13_9","021_13_9","PRO","13","9","9","Thlakdyng a vaangnaak taw angqungtheng nawh, thlakchekhqi a maihchoei taw him pekna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR13_10","021_13_10","PRO","13","10","10","Ooekqunaak ing hqo thawhsak nawh, awi ak ngai venawh cyihnaak awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR13_11","021_13_11","PRO","13","11","11","Amak thyymna khawh huh taw phu amak tana qeeng zip kawm saw, bibi phu huh khawh taw pung khqoet khqoet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR13_12","021_13_12","PRO","13","12","12","Ngaih-uunaak a plam awh kawlung tlo nawh, cehlai ngaih-uunaak a soepnaak taw hqingnaak thingsii ni. ");
INSERT INTO hltthb_vpl VALUES ("PR13_13","021_13_13","PRO","13","13","13","Awi amak ngaikhqi ham thihnaak pha kawm saw, awipek ak kqihchah ak thlang taw kutdo pekna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR13_14","021_13_14","PRO","13","14","14","Thlakcyikhqi cawngpyinaak taw hqingnaak tuikuk amyihna awm nawh, thihnaak thaang awhkawng thlang loet sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR13_15","021_13_15","PRO","13","15","15","Zaaksiimnaak leek ing thlang mikhaileeknaak pe nawh; cehlai amak ypawm thlang a cehnaak lam taw kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR13_16","021_13_16","PRO","13","16","16","Khawksiim thlang ingtaw cyihnaak ing bi sai nawh, thlakqaw ing a qawnaak zaan hy. ");
INSERT INTO hltthb_vpl VALUES ("PR13_17","021_13_17","PRO","13","17","17","Amak leek tamnaa taw zoseetnaak awh tlu thai nawh, ak ypawm dyihthing taw sadingnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR13_18","021_13_18","PRO","13","18","18","Toelnaak amak ngai ing khawdeng chah phyi nawh, cehlai toelnaak ak haanaaking kyihcahnaak ham kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR13_19","021_13_19","PRO","13","19","19","Ngaih-uunaak ak soepnaak taw kawlung ham aawi nawh, thlakche hamna seet sainaak awhkawng hu nawng ve sawhnaak kawi ni. ");
INSERT INTO hltthb_vpl VALUES ("PR13_20","021_13_20","PRO","13","20","20","Thlakcyi pyinaak taw cyihnaakna awm nawh, thlakche pyinaak taw seetnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR13_21","021_13_21","PRO","13","21","21","Thawlhnaak ing thlangthawlh hu hquut nawh, thlakdyng taw themleek ing thungna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR13_22","021_13_22","PRO","13","22","22","Thlakleek ing a tu a ca khqi hamna khawh taak pek khqi nawh, thlakche a khawh taw thlakdyngkhqi ham cun pekna ak awm ni. ");
INSERT INTO hltthb_vpl VALUES ("PR13_23","021_13_23","PRO","13","23","23","Khawdeng a loma awh caang daw soeih moe, amak thyymna bibinaak ing phu amak tana zip boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","A ca ak sawhnaak thlang ing cumcik am hawna nawh, ak lungnaak thlang ing a ca ce toelna hy. ");
INSERT INTO hltthb_vpl VALUES ("PR13_25","021_13_25","PRO","13","25","25","Thlakdyng ing taw buh ak phyina ai nawh, cehlai thlakche taw buh cawih ing awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR14_1","021_14_1","PRO","14","1","1","Nuk leek ing a im sa nawh, nuk che ingtaw a kut qoe ing hqee hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_2","021_14_2","PRO","14","2","2","Ak thyymna khaw ak sa ing Khawsa kqihchah nawh, thlakqaw ingtaw husit hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_3","021_14_3","PRO","14","3","3","Thlakqaw am khaaawh oequnaak cumcik awm nawh, thlakcyikhqi am khaa ing a mimah hul khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_4","021_14_4","PRO","14","4","4","Vaitaw amcai a ma awmnaak awh aihkawng caih nawh; cehlai vaitaw amcai ak tha awhkawng cangvui cangpai thaawt hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_5","021_14_5","PRO","14","5","5","Dyihthing ak thyym ing qaai am kqawn nawh, dyihthing amak thyym ing a qaai kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_6","021_14_6","PRO","14","6","6","Thlang ak husit ing cyihnaak sui nawh, cehlai am hu hy; simthainaak ak ta khqi ham taw cyihnaak zoe ca hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_7","021_14_7","PRO","14","7","7","Thlakqaw venawh koeh awm, anih a venawh cyihnaak am hu ti kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR14_8","021_14_8","PRO","14","8","8","Khawkpoekthai cyihnaak taw nimah khawsak sim qunaak ni. Thlakqawkhqi a qawnaak taw thailatnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR14_9","021_14_9","PRO","14","9","9","Thlakqaw ingtaw thawlhnaak tlaihvawng pek ce ikawna am ngai nawh, cehlai thlakdyngkhqi venawh kawpoek leeknaak awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_10","021_14_10","PRO","14","10","10","Nik kawseetnaak ce nimah doeng ing ni simthai nawh, ni zeelnaak awm thlakchang ing am ni siim pyih khqi na. ");
INSERT INTO hltthb_vpl VALUES ("PR14_11","021_14_11","PRO","14","11","11","Khawsak amak leek a im taw hqee pekna awm kawm saw, thlakdyng a imca taw kau khqoet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","Thlang ak poeknaak awh ak thyymna ak dang thihnaak ing ak dyt lam awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_13","021_14_13","PRO","14","13","13","Qaihnaak awh awm kawseetnaak awm thai nawh, zeelmangnaak awm kokqangnaak ing dyt thai ny. ");
INSERT INTO hltthb_vpl VALUES ("PR14_14","021_14_14","PRO","14","14","14","Kawlung khuiawh hu ak nawng taw amah ngaihnaak ing bee nawh; thlak leek taw amah ingkaw amah kaw zeel qu sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR14_15","021_14_15","PRO","14","15","15","Thlakqaw ing awi a hoei cangna nawh, thlang khawksiim ingtaw a lam ceh ak ceetna toek hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_16","021_14_16","PRO","14","16","16","Thlakcyi ing thawlh kqih nawh cehtaak hy; thlakqaw ingtaw lep nawh amah yp qu na hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_17","021_14_17","PRO","14","17","17","Kaw ak so ing khawkpoek kaana bi sai kawm saw, seetnaak ak poek ak thlang taw sawh na kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR14_18","021_14_18","PRO","14","18","18","Thlakqaw ing qawnaak a qo pang kawm saw, khawksimthai thlang ingtaw cyihnaak lumyk pang kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR14_19","021_14_19","PRO","14","19","19","Thlakche taw thlakleek haiawh lut kawm saw, khawsak amak leek thlang taw thlakdyng ak chawmkeng awh dyi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR14_20","021_14_20","PRO","14","20","20","Thlak khawdeng a imceng ing sawh na nawh, thlang ak boei ing pyi khawzah ta hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_21","021_14_21","PRO","14","21","21","U awm a imceng ak husit taw thawlh ak sai ni; khawdeng ak lungnaak taw thlang zoseen ni. ");
INSERT INTO hltthb_vpl VALUES ("PR14_22","021_14_22","PRO","14","22","22","Theem amak leek ak poekkhqi ing lam am hang unawh aw? theemleek ak poekkhqi ingtaw lungnaak ingkaw ypawmnaak ce pang kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR14_23","021_14_23","PRO","14","23","23","Bibinaak ing a phu ta nawh, cehlai hui am lai doeng awhkaw awi ing khawdengnaak pe hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_24","021_14_24","PRO","14","24","24","Thlakcyi a boei lumyk taw a khawhkham ni, thlakqaw a qawnaak taw qawnaak doeng awh ni. ");
INSERT INTO hltthb_vpl VALUES ("PR14_25","021_14_25","PRO","14","25","25","Dyihthing ak thyym ing thlang loet sak nawh, qaai ak kqawn ing thailatnaak cawn sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_26","021_14_26","PRO","14","26","26","Khawsa ak kqihchahnaak ing ziingnaak ak cak ta nawh, a cakhqi hamna awm thukzingnaak hynna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_27","021_14_27","PRO","14","27","27","Khawsa kqihchahnaak taw hqingnaak tui a phytnaakna awm nawh, thihnaak dawng khui awhkawng thlang ak loet sakkungna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_28","021_14_28","PRO","14","28","28","Pilnam thlang a doemnaak awh boei a boeimangnaak awm nawh, pilnam thlang a zawinaak awhtaw boei capa amangnaak qeeng hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_29","021_14_29","PRO","14","29","29","Kawso ak yh thai thlang taw zaaksimnaak ak dung soeih ak ta thai ak thlangna awm nawh, cehlai kawk tawi ak thlang ingtaw qawnaak ni ang dang sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_30","021_14_30","PRO","14","30","30","Kawlung sadingnaak taw pumsa hqingnaak na awm nawh, thlang yytnaak taw quh hawnnaak mai ni. ");
INSERT INTO hltthb_vpl VALUES ("PR14_31","021_14_31","PRO","14","31","31","Khawdeng ak thekhanaak taw amah ak Synkung a thekhanaak na awm nawh, cehlai khawdeng ak qeen ingtaw ak kyihcah thlang ni. ");
INSERT INTO hltthb_vpl VALUES ("PR14_32","021_14_32","PRO","14","32","32","Thlakche taw a boe seetnaak awh tlu nawh, ak dyngna khawksaa thlang taw thihnaak khui awhkawng zingnak ta kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR14_33","021_14_33","PRO","14","33","33","Khawkpoekthai ak takhqi kawlungawh cyihnaak awm nawh thlakqawkhqi ang lakawh pho pe hy. ");
INSERT INTO hltthb_vpl VALUES ("PR14_34","021_14_34","PRO","14","34","34","Dyngnaak ing khawqam zoeksang nawh, cehlai thawlhnaak ing thlang boeih ham mingseet naak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR14_35","021_14_35","PRO","14","35","35","Sangpahrang a lungnaak taw tamnaa cyi ak khanawh awm nawh, ak kawsonaak taw chah ak phyih sak ak khanawh awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_1","021_15_1","PRO","15","1","1","Awih neem ing kawso qeem sak nawh, awih tlo ing kaw so sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_2","021_15_2","PRO","15","2","2","Thlakcyi am lai ing cyihnaak awitak cawn sak nawh, thlakqaw am kha ing qawnaak dang sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_3","021_15_3","PRO","15","3","3","Boepa mik taw hyn boeih awh awm nawh, theem leek ingkaw theem che toek poepa hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_4","021_15_4","PRO","15","4","4","Thlang ak qoei sak lai taw hqingnaak thingna awm nawh, thailatnaak ing ak bee lai taw kawlung patang sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_5","021_15_5","PRO","15","5","5","Thlakqaw ingtaw a pa ak toelnaak husit nawh, cehlai toelnaak ak haanaak taw ngaihtaak ing khawksaa thlang ni. ");
INSERT INTO hltthb_vpl VALUES ("PR15_6","021_15_6","PRO","15","6","6","Thlakdyng imawh khawh khawzah awm nawh, thlakche khawboe phu taw kawpoek kyinaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR15_7","021_15_7","PRO","15","7","7","Thlakcyi a huui ing siimnaak pungtai sak nawh, thlakqaw kawlung ingtaw cemyih am sai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_8","021_15_8","PRO","15","8","8","Thlakche a hyih phum taw Khawsa ham tuih kawina awm nawh; thlakleek a hlacamnaak taw Khawsa ham kawzeelnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR15_9","021_15_9","PRO","15","9","9","Thlakchekhqi lam taw Khawsa ham tuih kawina awm nawh, dyngnaak lamawh ak cetkhqi cetaw lungna khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_10","021_15_10","PRO","15","10","10","Lamawh amak cetkhqi taw ak tlo soeih toelnaak ing qeeh nawh; toelthamnaak ak sawhnaak thlang taw thi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR15_11","021_15_11","PRO","15","11","11","Ceikhui ingkaw Abaddon ce Khawsa ing a huh pheng awhtaw thlang kawlung taw ikawmyih na nu ang dang hly pheng? ");
INSERT INTO hltthb_vpl VALUES ("PR15_12","021_15_12","PRO","15","12","12","Thlang ak thekha naak ing toelnaak am lungna nawh, thlakcyi venna awm am cet ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR15_13","021_15_13","PRO","15","13","13","Kawlung awmhlynaak ing mikhai hlampan sak nawh, kawlung tlohnaak ing myihla kawseet sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_14","021_15_14","PRO","15","14","14","Khawkpoek thainaak kawlung ak ta ing cyinaak sui nawh, thlakqaw am kha ingtaw qawnaak doengawh awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_15","021_15_15","PRO","15","15","15","Kyinaak ak sawng ham khawnghii boeih ve se boeih nawh, kawlung ak nawmkhqi ham taw zeelnaak poei ing bee poepa hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_16","021_15_16","PRO","15","16","16","Patang doena theem khawzah taak ang lakawh Khawsa kqihnaak ing theem a khoeh taak ve leek bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_17","021_15_17","PRO","15","17","17","Sawhnaak kawlung ing vaitaw ak tha him nawh buh vel anglakawh lungnak a awmnaak awh an hah ing buh vel haih leek bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_18","021_15_18","PRO","15","18","18","Thlang am thin ak see ing hqehnaak coeng sak nawh, yhnaak ak ta thlang ingtaw kawso qeem sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_19","021_15_19","PRO","15","19","19","Thlang thakdam a lamawh hling bee nawh, thlakmeet a lam taw kau nawh dyng hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_20","021_15_20","PRO","15","20","20","Capak cyi ing pa ak kaw zeel sak nawh, thlakqaw ingtaw a nu thee na hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_21","021_15_21","PRO","15","21","21","Cyihnaak amak ta khqi ham taw qawnaak ve a mi awmhlynaak na awm nawh, khawksiim thlang ingtaw a lam dyng sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_22","021_15_22","PRO","15","22","22","Awi doet qu kaana bi sai ing am phu mah nawh, cehlai awi doet qunaak a kuum awh bibi coeng hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_23","021_15_23","PRO","15","23","23","Amah a tym canawh awi doet hlatnaak ak thyym zaak taw ym ham kawi soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_24","021_15_24","PRO","15","24","24","Thlakcyi ham hqingnaak lam taw a baang benna kawng nawh, kham lam Ceikhui lamawh ama ceh naak ham. ");
INSERT INTO hltthb_vpl VALUES ("PR15_25","021_15_25","PRO","15","25","25","Bawipa ing thlak oekqu a im ce khaai khoep kawm saw, nuhai a im khoeng taw cak sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR15_26","021_15_26","PRO","15","26","26","Kawpoek amak leek taw Khawsa am tyih kawina awm nawh, kawpoek ak ciimkhqi kawpoek cetaw ym pekkhqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_27","021_15_27","PRO","15","27","27","Thlak kamvaa ing a imkhui patang pe hy, cehlai ang hyp kutdo ak sawhnaak thlang taw hqing kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR15_28","021_15_28","PRO","15","28","28","Thlakdyng kawlung ing awi khin ngai hy, cehlai thlakche ingtaw awihche hlah sawqhat hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_29","021_15_29","PRO","15","29","29","Khawsa ing thlakche khqi ce lak hla khqi nawh thlakdyng khqi a cykcahnaak taw zaak pekkhqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_30","021_15_30","PRO","15","30","30","Mikhai hlampannaak ingawh kawlung awmhly sak nawh, awithangleek ing quhqawng cang sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR15_31","021_15_31","PRO","15","31","31","Hqingnaak pek toelthamnaak ak haanaak taw thlakcyikhqi a imkhui cakawna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR15_32","021_15_32","PRO","15","32","32","Toelthamnaak amak haanaak taw ang myihla ak thekhanaak ni, zyihtoelnaak ak haanaak ingtaw zaaksimnaak hu kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR15_33","021_15_33","PRO","15","33","33","Khawsa kqihchahnaak taw cyihnaak ak cawngpyikungna awm nawh; dungvoengnaak taw kyihcahna awmnaak hly ni. ");
INSERT INTO hltthb_vpl VALUES ("PR16_1","021_16_1","PRO","16","1","1","Kawpoek ing khawkhaannaak taw thlanghqing a hutna awm nawh, awi hlatnaak taw Bawipa venna kaw ni. ");
INSERT INTO hltthb_vpl VALUES ("PR16_2","021_16_2","PRO","16","2","2","Thlang ing amah poeknaak awh a lam boeih boeih thyym sak hy, cehlai Khawsa ingtaw kawlung ni a toek. ");
INSERT INTO hltthb_vpl VALUES ("PR16_3","021_16_3","PRO","16","3","3","Na bibi boeih Bawipa kutawh hal lah. Cawhtaw na ngaihnaak boeih ni soep pe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR16_4","021_16_4","PRO","16","4","4","Khawsa ing a hoei soepkep boeih ce Amah kawngaih amyihna a sai boeih ni, khawsak amak leekkhqi a zoseetnaak khawnghii awm sai pe hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_5","021_16_5","PRO","16","5","5","Ak oek qu kawlungkhqi boeih Bawipa ing tuih nawh, kawlung kutoet mai seiawm, a toel kaana am hlah ti kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR16_6","021_16_6","PRO","16","6","6","Qeennaak ingkaw awitak ing thawlhnaak dip sak thai nawh, Khawsa kqihchahnaak ing thlang ngawh thawlh ceh taak thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_7","021_16_7","PRO","16","7","7","Khawsa ym kawina thlang ing khaw a sak awhtaw, a qaalkhqi mi qoepqui cana awm haih thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_8","021_16_8","PRO","16","8","8","Amak thyymna theem khawzah huh anglakawh ak thyymna theem a khoeh huh leek hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_9","021_16_9","PRO","16","9","9","Thlang, ak kawlung ing a sai ham kawi khawkhan moe, a khawngkham khqi boeih cetaw Khawsa ing a sawi ni. ");
INSERT INTO hltthb_vpl VALUES ("PR16_10","021_16_10","PRO","16","10","10","Sangpahrang am hui lai awh ak thyym awitlyknaak awm nawh, am khakhui awhkawng amak thyym awi ap cawn ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR16_11","021_16_11","PRO","16","11","11","Ak thyym tahnaak ingkaw tehnaak taw Bawipa a koena awm nawh, tahnaak sawngsa khui awhkaw ak qih boeih awm Amah a sai ni. ");
INSERT INTO hltthb_vpl VALUES ("PR16_12","021_16_12","PRO","16","12","12","Sangpahrangkhqi ing amak thyymna bibi tuih uhy, ngawlhdoelh ce dyngnaak ingawh cak sak ham ami ngaih awh. ");
INSERT INTO hltthb_vpl VALUES ("PR16_13","021_16_13","PRO","16","13","13","Ak thyym hui am lai ce Sangpahrangkhqi ing ym unawh, awithyym kqawn ce lungna uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_14","021_16_14","PRO","16","14","14","Sangpahrang kawsonaak taw thihnaak a dyihthingna awm nawh, cehlai thlakcyi ingtaw ak kawsonaak dip sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_15","021_16_15","PRO","16","15","15","Sangpahrang a mikhai a hlampannaak awh hqingnaak awm nawh, ak kawzeelnaak taw khawtlan coeng a hu awhkaw cingmai amyih na ni. ");
INSERT INTO hltthb_vpl VALUES ("PR16_16","021_16_16","PRO","16","16","16","Sui anglakawh cyihnaak taak ve leek soeih mah hy! Oeih, ngun lakawh zaaksimnaak tyk ve leek soeih mah hy! ");
INSERT INTO hltthb_vpl VALUES ("PR16_17","021_16_17","PRO","16","17","17","Thlakdyng a cehnaak lam ing thawlh qei hy; a lam ak ngaihtaak thlang taw a hqingnaak ak ngaihtaak thlangna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_18","021_16_18","PRO","16","18","18","Oek qunaak taw plamthamnaak a hai benna cet nawh, soekloeknaak awm tluuknaak a hai benna ak cet ni. ");
INSERT INTO hltthb_vpl VALUES ("PR16_19","021_16_19","PRO","16","19","19","Thlak oek qu ingqawi thlang a khawh quk tei ak lakawh thlak khawdeng ingqawi thlak kaina phaih qu nawh awm leek ngai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_20","021_16_20","PRO","16","20","20","Toelnaak awi ak ngai thlang taw a khawsak vaan kawm saw, Khawsa ak ypnaak thlang taw a zoseen thlang ni. ");
INSERT INTO hltthb_vpl VALUES ("PR16_21","021_16_21","PRO","16","21","21","Kawlung ak cyi taw khawksiim thlangna awm kawm saw, awih tui ing simnaak pung sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_22","021_16_22","PRO","16","22","22","Zaaksimnaak ve ak takkhqi ham taw hqingnak tui a phytnaak na awm nawh, thlakqawkhqi ham toelnaak ve qawnaak na coeng hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_23","021_16_23","PRO","16","23","23","Thlakcyi ak kawlung ing a huui cawngpyi nawh, am lai simnaak ing tawmsap pe hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_24","021_16_24","PRO","16","24","24","Awih leek taw khaawi amyihna, hqingnaak hamna aawi dikdik nawh, quh ham sadingnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR16_25","021_16_25","PRO","16","25","25","Thlang kawpoek awh lam ak thyymna ak dang a boetnaak awh thihnaak lamna ak awm lam awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_26","021_16_26","PRO","16","26","26","Bi ak bi ing awk ai ngaihnaak camawh bi sai nawh, phoen phyinaak hamna bibi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_27","021_16_27","PRO","16","27","27","Thlak so soek ing theem amak leek sai ham poek nawh, am khaawh maih ling awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_28","021_16_28","PRO","16","28","28","Kawpoek amak leek ing hqehnaak syn nawh, thlang theetnaak ing beqoepkhqi kqeng sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_29","021_16_29","PRO","16","29","29","Khawsak amak leek ing a imcengkhqi sykzoek nawh seetnaak lam panpyih khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_30","021_16_30","PRO","16","30","30","A mik ak hiim ing theem amak leek poeknaak ham hiim nawh, a huui ak cymbyp ing seetnaak pha sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_31","021_16_31","PRO","16","31","31","Lukqawk sampai taw boeimangnaak lumyk ni; dyngnaak ing ni huh thaina a awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_32","021_16_32","PRO","16","32","32","Kawkdung thlang taw thlang thakawm lakawh leek ngaih nawh, kawso ak yhthai thlang taw khaw ak tlyk lakawh leek ngai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR16_33","021_16_33","PRO","16","33","33","Taicung taw phai khanawh hlamna awm seiawm ak thyym laitlyknaak taw Bawipa koe ni. ");
INSERT INTO hltthb_vpl VALUES ("PR17_1","021_17_1","PRO","17","1","1","Khqah qu doena imkhuiawh poei ak beena ai anglakawh, qoepquinaak ing buhkak khangoet bai leek bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_2","021_17_2","PRO","17","2","2","Tamnaa ak cyi ing ming ak seet sakkung capa ce uk nawh, ciingnaakhqi a qo ce pang pyi khqi lawt kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR17_3","021_17_3","PRO","17","3","3","Cak ciimnaak ham cak am, sui ciimnaak ham maih ling ing ciimna awm nawh, lingbyi taw Bawipa ing ni am ciim. ");
INSERT INTO hltthb_vpl VALUES ("PR17_4","021_17_4","PRO","17","4","4","Theem amak leek ak saikung ing thailatnaak ak awi ngai nawh, thlak thailat ing thlakche ak awi ce ngai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_5","021_17_5","PRO","17","5","5","Khawdeng ak thekhanaak taw anih ak Synkung ak thekhanaak ni, thlang kyinaak a sawng awh ak awmhly ak thlang taw a toel kaana am awm ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR17_6","021_17_6","PRO","17","6","6","Tucakhqi ve pacawngkhqi a boei lumyk na awm nawh, pakhqi taw cakhqi a boeimangnaak na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_7","021_17_7","PRO","17","7","7","Awih kqawn thai ve thlakqaw ingqawi am qoepqui na nawh, qai awi kqawn ve Sangpahrang ingqawi am qoepqui khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_8","021_17_8","PRO","17","8","8","Kutdo ve ak dokung mikawh suilung amyihna awm nawh, a haai ang mangnaak ben hoeiawh saithainaak ce ta hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_9","021_17_9","PRO","17","9","9","Thlang a thawlhnaak ak thuhphah ing lungnaak dang sak nawh, cehlai thlang a thawlhnaak ak phokung ing beqoep qawi hqeh sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_10","021_17_10","PRO","17","10","10","Thlakqaw a voei siim vyk lakawh thlakcyi hykpoet zyihtoel ing phu ta bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_11","021_17_11","PRO","17","11","11","Thlang amak leek ing awi am ngaihnaak ben doengna mang nawh, cemyih thlang cetaw thlangqeen khaw amak ngai boei venna tyihna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR17_12","021_17_12","PRO","17","12","12","Thlakqaw ak qaw huui ingqawi qhum anglakawh a ca a mi lawh pek phawm ingqawi qum ngaih awm bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_13","021_17_13","PRO","17","13","13","Theem leek ce theem amak leek ing ak thung ak thlang taw seetnaak kaana a im am cawn taak ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR17_14","021_17_14","PRO","17","14","14","Oelh ngawngnaak ve tuile ak poek ing myih hy, cedawngawh khqah qunaak a awm hlanawh oelh ngawngnaak ce hu nawng taak. ");
INSERT INTO hltthb_vpl VALUES ("PR17_15","021_17_15","PRO","17","15","15","Thlakthawlh cang lu ak phyih sak ingkaw thlakdyng thawlh ak phyih sak ak thlang ce Bawipa ing am tyih qawi ni. ");
INSERT INTO hltthb_vpl VALUES ("PR17_16","021_17_16","PRO","17","16","16","Cyihnaak amak ta thlakqaw kutawh ikaw ham nu cyihnaak thlaihnaak ham tangka pekna a awm kaw? ");
INSERT INTO hltthb_vpl VALUES ("PR17_17","021_17_17","PRO","17","17","17","Pyi leek ingtaw lungnaak ta poepa nawh, cawt taw kyinaak sawngawh a nik pyi ham ak thang law ni. ");
INSERT INTO hltthb_vpl VALUES ("PR17_18","021_17_18","PRO","17","18","18","Khawkpoeknaak thai amak ta ing a kut bei nawh, a imceng ham qii ak khoengkungna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_19","021_17_19","PRO","17","19","19","Boekoek ak lungnak ing thawlh lungna nawm, ak chawmkeng ak sang sak ing seetnaak ce sui hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_20","021_17_20","PRO","17","20","20","Kawlung amak leek thlang a khawsak am vaan nawh; am kha ing thailatnaak awi ak kqawn poepa taw kyinaak sawng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Thlakqaw ak ca naak taw amah ingkaw amah kawseetnaak ak pe quna awm nawh, thlakqaw ak ca naak pa ing kawzeelnaak am ta kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR17_22","021_17_22","PRO","17","22","22","Kawlung zeelnaak taw sadingnaak na awm nawh, kawlung kawseetnaak taw quhqawng hawnnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR17_23","021_17_23","PRO","17","23","23","Thlakche ing ak dyng awitlyknaak kawi sak hamna ak hyp kutdo lo hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_24","021_17_24","PRO","17","24","24","Cyihnaak taw simthainaak ak takhqi haiawh awm nawh, cyihnaak amak ta a mik ing khawdek a kelcawng dyna sui hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_25","021_17_25","PRO","17","25","25","Capa ak qaw ing a pa kawseetnaak pe nawh, ak canaak nu ham ngaihkyinaak pe hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_26","021_17_26","PRO","17","26","26","Thlangdyng toelnaak kut thlak am leek nawh, ak thyymna awihtlykkumg vyyk am leek hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_27","021_17_27","PRO","17","27","27","Awih kqawn ak ngaihtaak ing cyihnaak ta nawh, zaaksimnaak ak ta ing awm mylh mylh hy. ");
INSERT INTO hltthb_vpl VALUES ("PR17_28","021_17_28","PRO","17","28","28","Thlakqaw awm a awm mylh mylh awhtaw thlang ing thlakcyi na ngai nawh, a huui a cymbyp awhtaw thlang ing khawksimna ngai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_1","021_18_1","PRO","18","1","1","Thlang mi haiben ham ak maa ak thlang ing amah ak kawngaih kawi sui nawh, cyihnaak ak thyym boeih ce thaih boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_2","021_18_2","PRO","18","2","2","Thlakcyi ing cyihnaak awh am zeel nawh, amah kawpoek ngaihnaak doengawh awmhly hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_3","021_18_3","PRO","18","3","3","Thekhanaak a awmnaak awh hepnaak awm nawh, ming seetnaak a awmnawh awh chahphyinaak awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_4","021_18_4","PRO","18","4","4","Thlang am kha awhkawng ak cawn awi taw tui amyihna dung nawh, cehlai cyihnaak taw tuihamyihna phyt hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_5","021_18_5","PRO","18","5","5","Laitlyknaak awh thlakdyng thawlh lu khqoeh sak hamna, ak bo mikhai toek am leek hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_6","021_18_6","PRO","18","6","6","Thlakqaw am kha ing thlang hqo pe nawh, am lai ing khqah qunaak khy hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_7","021_18_7","PRO","18","7","7","Thlakqaw am kha taw a qeengnaak kawina awm nawh, a huui taw a hqingnaak ham thaangna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_8","021_18_8","PRO","18","8","8","Theet awi ve buh tui ant tui amyihna thlang kawlung a dungnaak dy lut hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_9","021_18_9","PRO","18","9","9","Bibi ak vaatsam thlang taw ak hqeekung ciingnapaca na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_10","021_18_10","PRO","18","10","10","Bawipa ming taw zingnaak vawngchung na awm nawh, thlakdyng ing zing na nawh a loetnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR18_11","021_18_11","PRO","18","11","11","Mangpa ham a khawhkham taw ang zingnaak na awm nawh, amah ak poeknaak awh vawngchung ak sang soeih na ngai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_12","021_18_12","PRO","18","12","12","Thlang kawlung ak oe qu ing thihnaak lam benna mang nawh, kawlung neemnaak ingtaw kyihcahnaak benna ni. ");
INSERT INTO hltthb_vpl VALUES ("PR18_13","021_18_13","PRO","18","13","13","Ngaih zaak qu kaana thlak awi thuung maa taw qawnaak ingkaw chahphyihnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR18_14","021_18_14","PRO","18","14","14","Thlang a tloh awh kawlung ing am thin cak sak hy, cehlai kawlung ak tlo ingtaw ikawmyihna ang yh hly thai pai? ");
INSERT INTO hltthb_vpl VALUES ("PR18_15","021_18_15","PRO","18","15","15","Ak zaaksimthai lingbyi ing zaaksimnaak thai ta nawh, thlakcyi ang haa ing simthainaak sui khawi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_16","021_18_16","PRO","18","16","16","Thlang a kutdo ing a lam khui sak nawh, boei a haina ceh pyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_17","021_18_17","PRO","18","17","17","Ak cangnaak lammaana ak kqawn ing thlakdyng amyihna dang seiawm, a imceng ing law nawh, awi suu tlaih nawh pho khawi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_18","021_18_18","PRO","18","18","18","Cung zyknaak ing awi dip sak nawh, ak tlung qawi awm hqaa sak qawi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_19","021_18_19","PRO","18","19","19","Amamik qoep cingnapaca taw khawk chungnaak vawng ak cak lakawh kyi ngai nawh, awipungnaak taw qal tlung a awmnaak vawng chawh ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_20","021_18_20","PRO","18","20","20","Thlang ing am lai thaih ai nawh ak phyn phyi sak nawh; a hui am lai phu ing ak kaw qeep sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_21","021_18_21","PRO","18","21","21","Thlang am laiawh thihnaak ingkaw hqingnaak awm nawh, ak lungnaak thlang ing ak thaih qah ce ai kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR18_22","021_18_22","PRO","18","22","22","Zu ak lo taw theem leek ak hu thlang ni, Khawsa venna kaw kawzeelnaak hu hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_23","021_18_23","PRO","18","23","23","Thlang khawdeng ing qeennaak thoeh nawh, mang ingtaw a tlung doena thlang voem hy. ");
INSERT INTO hltthb_vpl VALUES ("PR18_24","021_18_24","PRO","18","24","24","Pyi khawzah taak taw plam thamnaak ni, cehlai cingna anglakawh lungnaak ak tlo ngai pyi awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR19_1","021_19_1","PRO","19","1","1","Thailatnaak awi ak kqawn thlakqawna awm anglakawh thlak khawdeng, kawpoek leek ak toen na awm leek bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR19_2","021_19_2","PRO","19","2","2","Simnaak kaana ngaihnaak doeng awm am leek nawh, khawng khaam tawn aih awm tlunknaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR19_3","021_19_3","PRO","19","3","3","Thlakqaw a qawnaak ing a lam seet sak nawh, Khawsa awh ak kaw vuung sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR19_4","021_19_4","PRO","19","4","4","Khawh taak ing pyi khawzah ta nawh, khawdeng thlang taw a pyi ing centak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR19_5","021_19_5","PRO","19","5","5","Amak thyym dyihthingna ak dyi taw a toel kaana am awm kawm saw, qaai ak kqawn awm am loet ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR19_6","021_19_6","PRO","19","6","6","Thlang khawzah ing ukkung kawzeelnaak sai thai nawh, kutdo ak pe thlang ing pyi khawzah ta thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR19_7","021_19_7","PRO","19","7","7","Ak khawdeng cingnakhqi ing a mim cawt ce a mi sawhnaak awhtaw a pyikhqi ingtaw ikawmyihna nu a mi sawhnaak pai kaw! hquut nawh khy khqi seiawm qeeng taak boeih kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR19_8","021_19_8","PRO","19","8","8","Cyihnaak ak ta ing a hqingnaak lungna nawh, simnaak ak ta ing theemleek hu kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR19_9","021_19_9","PRO","19","9","9","Amak thyym dyihthingna ak dyi taw a toel kaana am awm kawm saw, qaai ak kqawn taw plam kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR19_10","021_19_10","PRO","19","10","10","Khawsak nawmnaak ve thlakqawi ingqawi am qoepqui nih nawh tamnaa ing a boei a uk awm am kawihvaih nak khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR19_11","021_19_11","PRO","19","11","11","Cyihnaak ingawh thlang yh thainaak pe nawh, thlang a thawlh qeennaak taw a boeimang-naak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR19_12","021_19_12","PRO","19","12","12","Sangpahrang ak kawsonaak taw samthyn a kaawk ing myih nawh, cehlai ak kawzeelnaak taw saaitlim ak khan awhkaw daamtui ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR19_13","021_19_13","PRO","19","13","13","Capa ak qaw taw a pa ham zoseetnaak na awm nawh, zuu, hqo ak lo poepa taw tuih poek ben tloei ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","Im lo ingkaw khawhkham taw pa venna kaw qona awm nawh, zuu ak cyi taw Bawipa venna kaw qo ni. ");
INSERT INTO hltthb_vpl VALUES ("PR19_15","021_19_15","PRO","19","15","15","Ngaknaak ing ih tui sak nawh, thlang thak-dam taw buh cawi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR19_16","021_19_16","PRO","19","16","16","Awi pek ak ngai ing a hqingnaak ngaihthyn nawh, a khawsak amak ngaihthyn taw thi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR19_17","021_19_17","PRO","19","17","17","Khawdeng ak lungnaak taw Khawsa kut ak zoe sak na awm nawh, theemleek a sai phu ce thung kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR19_18","021_19_18","PRO","19","18","18","Ngaih-uunaak a awm tloek awh na capa ce toel lah, a hamna tlo kaw ti nawh koek poek. ");
INSERT INTO hltthb_vpl VALUES ("PR19_19","021_19_19","PRO","19","19","19","Kawkso thlang ing am thin tawi phu zaawk kaw, a nih ce hul tik seiawm na hul tlaih tlaih ngaih kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR19_20","021_19_20","PRO","19","20","20","Thlang ing awi ak kqawn ce ngai nawh toelnaak ak awi ce do lah, a dytnaak ben nataw cyi kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR19_21","021_19_21","PRO","19","21","21","Thlang ing khawkpoeknaak khawzah ta hy, ceseiawm Khawsa a khawkhannaak awh ni a soep hy. ");
INSERT INTO hltthb_vpl VALUES ("PR19_22","021_19_22","PRO","19","22","22","Amak boet thai lungnaak ni thlang ing a ngaih; qaai kqawn lakawh khawdengna awm leek bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR19_23","021_19_23","PRO","19","23","23","Khawsa kqihchahnaak ing hqingnaak pe nawh, ak ta boeih khawzeel ing awm kawm usaw, zoseetnaak ing am phakhqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR19_24","021_19_24","PRO","19","24","24","Thlang thakdawh ing am khuiawh a kut tuun nawh am kha a thak hly awm ngak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR19_25","021_19_25","PRO","19","25","25","Thlang ak thekhanaak ce vyyk lah, cawhtaw cyihnaak amak takhqi ing cyihnaak ta bet kawm uh, khaw ak poek thai thlang ce toel lah, cyi khqoet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR19_26","021_19_26","PRO","19","26","26","A pa khawdeng sak nawh, a nu im awhkawng ak thlaa taw capa, thlang chah ak phyih sak, ming seetnaak ak pekung ni. ");
INSERT INTO hltthb_vpl VALUES ("PR19_27","021_19_27","PRO","19","27","27","Ka capa, toelnaak awi am nang ngaihnaak hamna a nik cawngpyi ak awi ce koeh ngai. ");
INSERT INTO hltthb_vpl VALUES ("PR19_28","021_19_28","PRO","19","28","28","Cemyih ak thlang ing ak thyym ce husit nawh amak leek theem ce am kha ing daih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR19_29","021_19_29","PRO","19","29","29","Toelnaak taw thlang ak thekhanaakkhqi ham saina awm nawh, thlaqaw am ting taw vyyknaak hamna ak awm ni. ");
INSERT INTO hltthb_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","Misurtui ing thlang thekhanaak pe nawh, zuu ing awipungnaak coeng sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR20_2","021_20_2","PRO","20","2","2","Sangpahrang ak kawsonaak taw samthyn a kaawk ing myih nawh, kaw ak so sak taw amah a hqingnaak ak khawng ni. ");
INSERT INTO hltthb_vpl VALUES ("PR20_3","021_20_3","PRO","20","3","3","Kawsonaak ak qei thlang ing kyihcahnaak hu kawm saw, cehlai thlakqaw ingtaw hqo hu hy. ");
INSERT INTO hltthb_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Thlang thakdam ing khaw a dingawh lai a thawl ngak nawh; cedawngawh caang ah huiawh ai thoeh kawm saw, ikawawm am ta kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR20_5","021_20_5","PRO","20","5","5","Kawlung khuiawh cainaak taw tui amyihna dung hlai hy, simnaak ak ta thlang ing ni ik-oeih a coeng sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR20_6","021_20_6","PRO","20","6","6","Thlak ypawmna kqawn qu mai kawm uh, ak ypawm tang unu ak awm? ");
INSERT INTO hltthb_vpl VALUES ("PR20_7","021_20_7","PRO","20","7","7","Thlakdyng, khawkpoek khawkhan thainaak ak ta a cakhqi taw thlang zoseenkhqi ni. ");
INSERT INTO hltthb_vpl VALUES ("PR20_8","021_20_8","PRO","20","8","8","Awitlyknaak awh Sangpahrang ing awi ak tlyk awh, a mik ing theem amak leek boeih ce khqaa ing zah amyihna zaap boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR20_9","021_20_9","PRO","20","9","9","“Kak kawlung ciim sak nyng, thawlhnaak awhkawng ciimcaih nyng,” tinawh uing ak kqawn thai? ");
INSERT INTO hltthb_vpl VALUES ("PR20_10","021_20_10","PRO","20","10","10","Tahnaak amak thym ingkaw tehnaak amak thym boeih Bawipa ing tyih qawi haih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR20_11","021_20_11","PRO","20","11","11","Nasen awm a bibi ing ak thym ak thawlh dang sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR20_12","021_20_12","PRO","20","12","12","Zaaknaak haa ingkaw huhnaak mik ve Bawipa ing ni a sai qawi haih. ");
INSERT INTO hltthb_vpl VALUES ("PR20_13","021_20_13","PRO","20","13","13","Ih koeh lungna khawdeng kawp ti; hqak nawh meet lah awklek ainaa ta kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR20_14","021_20_14","PRO","20","14","14","Them ak thlaikung ing them ak thlaihawh “Am leek hy, am leek hy,” tinawh, ang voei huna a them thlaihawh oequ hy. ");
INSERT INTO hltthb_vpl VALUES ("PR20_15","021_20_15","PRO","20","15","15","Sui awm nawh, cak phu tlo awm awm moe, cyihnaak awi ak kqawn hui taw lung phu tlo soeih ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR20_16","021_20_16","PRO","20","16","16","Thlangchang asyng naak ham ak dyihpyi-kung ingkaw nukche ak dyihpyikung ing a hii ce hawlh seh. ");
INSERT INTO hltthb_vpl VALUES ("PR20_17","021_20_17","PRO","20","17","17","Quuk buh ang hypna ai ve thlang ing tui sak hy, cehlai a huna am kha ce lungqiit ing be kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR20_18","021_20_18","PRO","20","18","18","Thlang doet nawh ik-oeih cainaak ta. Ak leekna cai hqeet nawh ceemqal ce tlyk. ");
INSERT INTO hltthb_vpl VALUES ("PR20_19","021_20_19","PRO","20","19","19","Thlang awihpung khawlakawh ak van ing awihyp ce pho sak hy; Ceamyihna awmsaw awi ak pung thlang ce koeh pyi na. ");
INSERT INTO hltthb_vpl VALUES ("PR20_20","021_20_20","PRO","20","20","20","A nu mai aw, a pa mai aw qun ak khy pek taw, thanlung ak hyp huiawh a maihchoei him pekna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR20_21","021_20_21","PRO","20","21","21","Ak cykawh ang tawnna huh qo cetaw a huna zoseetnaak na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR20_22","021_20_22","PRO","20","22","22","“Thawlh thung lah vang,” koeh ti, Khawsa ce qeh cang nawh, anih ing ni loet sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR20_23","021_20_23","PRO","20","23","23","Tahnaak amak thym taw Bawipa mikhuhawh tuih kawi ni, amak thym tehnaak awm am leek hy. ");
INSERT INTO hltthb_vpl VALUES ("PR20_24","021_20_24","PRO","20","24","24","Thlanghqing a khawkhannaak Bawipa ing a hqui ni, cekkaana thlanghqing ing ikawmyihna a sim hly thai? ");
INSERT INTO hltthb_vpl VALUES ("PR20_25","021_20_25","PRO","20","25","25","Poek kaana hqingtawnnaak ing Khawsa them pek ingkaw awikam coengawh hu ak nawng tlaih taw amah ham thang ak dun khoeng ak thlang ni. ");
INSERT INTO hltthb_vpl VALUES ("PR20_26","021_20_26","PRO","20","26","26","Sangpahrang ak cyi ing thlakche ce hqimqa nawh awideng hy. ");
INSERT INTO hltthb_vpl VALUES ("PR20_27","021_20_27","PRO","20","27","27","Thlanghqing kak kawlung taw Bawipa a maihchoeina awm nawh, kawlung khui a dungnaak dy coei pheng thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR20_28","021_20_28","PRO","20","28","28","Lungnaak ingkaw awitak ing sangpahrang ce syng sak nawh; lungnaak ingawh ang ngawih-naak ce cak sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR20_29","021_20_29","PRO","20","29","29","Cacoen a boeimangnaak taw ak thamahnaak ni, Pacawng a dawnaak taw a lumkqawk sampainaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR20_30","021_20_30","PRO","20","30","30","Mynmaa kawlawknaak ing boeibaai caih sak nawh, vyyknaak ing kawlung ak khui dy ciim sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_1","021_21_1","PRO","21","1","1","Sangpahrang ak kawlung taw Bawipa kutawh awm nawh, tui ang lawngnaak amyihna a ngaih ngaihnaak awh sawi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_2","021_21_2","PRO","21","2","2","Thlang boeih ing amimah khawsak boeih thym sak hy; cehlai Bawipa ing kawlung ni a thoek. ");
INSERT INTO hltthb_vpl VALUES ("PR21_3","021_21_3","PRO","21","3","3","Hyih phum anglakawh ak thym ingkaw ak dyngna them sai ce Bawipa haiawh do kawina awm bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_4","021_21_4","PRO","21","4","4","Chah ak deng mikdai ingkaw ak oequ kawlung, thlakche a maihchoei taw thawlhnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR21_5","021_21_5","PRO","21","5","5","Kawdung ing bi ak bi boei nawh, thin-tawnoekna bi ak bi khawdeng hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_6","021_21_6","PRO","21","6","6","Thailatnaak ing them huhnaak taw cingmai ingkaw thihnaak thang ak dyn ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_7","021_21_7","PRO","21","7","7","Thlakchekhqi taw a mi seetnaak ing amimah thoeng khqi kaw, themleek sai ami maa ak caming. ");
INSERT INTO hltthb_vpl VALUES ("PR21_8","021_21_8","PRO","21","8","8","Thawlh ak saikung a lam taw kawi nawh, themleek ak saikung bi bi taw laang hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_9","021_21_9","PRO","21","9","9","Hqo ak hu poepa nu ingqawi im khuioet awh awm haih anglakawh im hlepawh awm leek bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_10","021_21_10","PRO","21","10","10","Thlakche ak kawlung ing them amak leek lungna nawh, imceng thlang ing anih venawh qeennaak am hu thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_11","021_21_11","PRO","21","11","11","Thlang ak thekhanaak toelna a awm awh, thlang zapkhqi ing cyihnaak taakna unawh; thlakcyi cawngpyina a awm awh a simnaak pung khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_12","021_21_12","PRO","21","12","12","Thlakdyng ing thlakche imkhui ce khawsimnaak ing toek nawh, thlakche taw a sai seetnaak caming plamtham hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_13","021_21_13","PRO","21","13","13","Khawdeng ak khyy awh ang haa ak bym taw amah ak khyy lawtawh haa bym pekna awm lawt kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR21_14","021_21_14","PRO","21","14","14","Ang hypna kutdo ing kawso qeem sak nawh, hibai khui awhkaw ang hyp kutdo ing ak tlo soeih kawso dip sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_15","021_21_15","PRO","21","15","15","Ak dyng awitlyknaak taw thlakdyng ham zeelnaakna awm nawh, thlakche ham thihnaak kawina awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_16","021_21_16","PRO","21","16","16","Cyihnaak lam awhkawng ak pleng taw thlakthikhqi venawh cun kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR21_17","021_21_17","PRO","21","17","17","Nawmnaak ak hlahdam ing khawdeng nawh, zu ingkaw situi ak lungnaak ing am boei kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR21_18","021_21_18","PRO","21","18","18","Thlakche taw thlakdyng ham, thlang amak ypawm taw thlang ypawm ham tlannaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR21_19","021_21_19","PRO","21","19","19","Kaw boen nawh hqo ak hu poepa nu ingqawi kutoetna awm haih anglakawh kqawng-qamna awm leek bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_20","021_21_20","PRO","21","20","20","Thlakcyi a awmnaak imkhui taw qo ingkaw situi a phuk tlo tlo ing bee nawh, thlakqaw a awmnaak imkhui taw awtoem aitoem kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR21_21","021_21_21","PRO","21","21","21","Dyngnaak ingkaw lungnaak ak sui ing hqingnaak, dyngnaak ingkaw kyihcahnaakkhqi ce hu kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR21_22","021_21_22","PRO","21","22","22","Thlakcyi ing thlang ak thamah soeih a khaw ce tlyk nawh a ypnaak vawng awm hqee pe hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_23","021_21_23","PRO","21","23","23","A hui am lai ak syyp sak thlang taw kyinaak awhkawng loet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR21_24","021_21_24","PRO","21","24","24","Thlak oequ ingkaw ak hoel qu thlang taw “thlakche” mingna nawh oequnaak ing a khawboe bee hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_25","021_21_25","PRO","21","25","25","Thakdam thlang a ngaihnaak taw amah a thihnaakna awm kaw, a kut ing bibi a ngak caming. ");
INSERT INTO hltthb_vpl VALUES ("PR21_26","021_21_26","PRO","21","26","26","Khawnghyyp khui kamvaanaak ing them ak nai awm nawh; thlakdyng ingtaw pe nawh, ikawm am hai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_27","021_21_27","PRO","21","27","27","Thlangthawlh hyih phum taw tuih leh kap nawh, amak leek cainaak ing a lawpyi khqoet taw kawmyih nanu tuih ang cuuk khqoet kaw! ");
INSERT INTO hltthb_vpl VALUES ("PR21_28","021_21_28","PRO","21","28","28","Amak thym simpyikung taw qeeng kawm saw; cehlai ak thym awi ak zaa ing awih thym ce kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_29","021_21_29","PRO","21","29","29","Thlakche ing qalleek mikhai toen qu sak nawh, thlakdyng ingtaw a cehnaak lamawh poek-ngaihnaak ta hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_30","021_21_30","PRO","21","30","30","Bawipa ingqawi ak kalh qu cyihnaak, simnaak, khawkhannaak am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR21_31","021_21_31","PRO","21","31","31","Meqang taw qal tuknaak hamna toenna awm moe, noengnaak taw Bawipa koe ni. ");
INSERT INTO hltthb_vpl VALUES ("PR22_1","021_22_1","PRO","22","1","1","Khawhthem khawzah anglakawh mingleek naak tyk, Sui ingkaw tangka anglakawh mikhaileeknaak ce tyk. ");
INSERT INTO hltthb_vpl VALUES ("PR22_2","021_22_2","PRO","22","2","2","Kuiqang ingkaw khawdeng awm haih nih nawh, ak synkung taw Khawsa ni. ");
INSERT INTO hltthb_vpl VALUES ("PR22_3","021_22_3","PRO","22","3","3","Khawkpoekthai ing them amak leek a huawh thuk ta nawh, Khawk hang ingtaw pan nawh kyinaak sawng hy. ");
INSERT INTO hltthb_vpl VALUES ("PR22_4","021_22_4","PRO","22","4","4","Kawdungnaak ingkaw Khawsa kqihchahnaak taw khawhthem, kyihcahnaak ingkaw hqingnaakna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR22_5","021_22_5","PRO","22","5","5","Thlakche a cehnaak lamawh hling ingkaw thang awm nawh, a hqingnaak ak ngaihthyn ingtaw cece qei hy. ");
INSERT INTO hltthb_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Nasen a cehnaak hly lamawh cawngpyi lah, a pacawngnaak dy am hilh kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR22_7","021_22_7","PRO","22","7","7","Boei ing khawdeng uk nawh, them ak pu taw ak pu pek a tamnaa ni. ");
INSERT INTO hltthb_vpl VALUES ("PR22_8","021_22_8","PRO","22","8","8","Them amak leek ak saw ing kyinaak ce hu kaw, ak kawsonaak ing a saithainaak awm hqeena awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR22_9","021_22_9","PRO","22","9","9","Khawboe ak leek ing zoseennaak hu kaw, thlak khawdeng am cahnaak ak caming. ");
INSERT INTO hltthb_vpl VALUES ("PR22_10","021_22_10","PRO","22","10","10","Thlang ak thekhanaak ce hek nawh, hqo dip sak lah, khqah qunaak ingkaw hqonaak dip kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR22_11","021_22_11","PRO","22","11","11","Kawlung ciimnaak lungna nawh awihneem ing awi ak kqawn taw sangpahrang ce pyina kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR22_12","021_22_12","PRO","22","12","12","Bawipa mik ing simthainaak ak ta thlang ce khoemdoen nawh, cehlai amak ypawm thlang ak awi ce am ngai zaak na kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR22_13","021_22_13","PRO","22","13","13","Thlak thadam ing, “Im lengawh samthyn awm nawh, a leng kak cawn awhtaw ni cui saw thi hly nyng,” ti hy. ");
INSERT INTO hltthb_vpl VALUES ("PR22_14","021_22_14","PRO","22","14","14","Nukche am kha taw lawkkhqawng ak dung soeih ing myih nawh, Bawipa ing a sawhnaakkhqi taw cek khuina tla kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR22_15","021_22_15","PRO","22","15","15","Nasen kawlung taw qawnaak ing pin nawh, ceseiawm toelthamnaak cumcik ing ak hlana thoeng pe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR22_16","021_22_16","PRO","22","16","16","A boeinaak hamna khawdeng thekhana nawh boei venna ang hyp kutdo ak pe thlang taw khawdeng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR22_17","021_22_17","PRO","22","17","17","Thlakcyi ak awi ve nang haa keng nawh ngai lah; nak kawlung ce ka cyihnaak donaakna hawna lah. ");
INSERT INTO hltthb_vpl VALUES ("PR22_18","021_22_18","PRO","22","18","18","Nak kawlung khuiawh kym nawh, nam khaawh ak soepna cak sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PR22_19","021_22_19","PRO","22","19","19","Nak cangnaak ce Bawipa a venawh a awm-naak hamna tuhngawi qoe naven qoeawh ning zak sak nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR22_20","021_22_20","PRO","22","20","20","Na hamna awicyih sawmthum kawpoek leek pheknaak awi ingkaw simnaak awicyihkhqi ning zak sak nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR22_21","021_22_21","PRO","22","21","21","Nang anik tyikung venawh ak thym awi nak kqawnnaak pe thai ham, ak thym ingkaw ypnaak ak cu awikhqi ce am ka ni cawngpyi nawh aw? ");
INSERT INTO hltthb_vpl VALUES ("PR22_22","021_22_22","PRO","22","22","22","Ak khawdeng koeh thekhana nawh, ak voet vai thlang ce vawng kawtawh koeh phep. ");
INSERT INTO hltthb_vpl VALUES ("PR22_23","021_22_23","PRO","22","23","23","Bawipa ing amingmih ham awideng kawm saw amingmih ak thekhanaakkhqi ce thung khqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","24","Kawso ak nget thlang koeh heem nawh, kawpoekche ak toen koeh pyina. ");
INSERT INTO hltthb_vpl VALUES ("PR22_25","021_22_25","PRO","22","25","25","A khawboe oet kawm tik saw, na hqingnaak ham thang nak dunna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR22_26","021_22_26","PRO","22","26","26","Kut beih ing awi ak kamkhqi venawh koeh boei. ");
INSERT INTO hltthb_vpl VALUES ("PR22_27","021_22_27","PRO","22","27","27","Ikawawm pek kawi am na tak awhtaw ikaw ham nanu na ihkhun ce pek ham nang cai? ");
INSERT INTO hltthb_vpl VALUES ("PR22_28","021_22_28","PRO","22","28","28","Nukdam pakdamkhqi ing syn awhkawng ami sym hawh qiilung ce koeh thoeih. ");
INSERT INTO hltthb_vpl VALUES ("PR22_29","021_22_29","PRO","22","29","29","A bibinaak awh ak ypawm thlang nak hu aw? anih taw thlang zap a bi ak bi am nawh, sangpahrang bi ak bi ni. ");
INSERT INTO hltthb_vpl VALUES ("PR23_1","021_23_1","PRO","23","1","1","Ukkung ingqawi buh ai haih hamna nang ngawih awh, namik huh awhkaw ak awm ce ak leekna toek. ");
INSERT INTO hltthb_vpl VALUES ("PR23_2","021_23_2","PRO","23","2","2","Awk ai awh ak kamvana na awm awhtaw na hawngawh cimca toen. ");
INSERT INTO hltthb_vpl VALUES ("PR23_3","021_23_3","PRO","23","3","3","Thailatnaak buh ni ti sim nawh a tuinaak doeng koeh nai. ");
INSERT INTO hltthb_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","4","Boei na ngaih yyt awh lynaak koeh toen, yh thai hamna na cyih ta. ");
INSERT INTO hltthb_vpl VALUES ("PR23_5","021_23_5","PRO","23","5","5","Ak qeeng thai khawhawh koeh ly, ang hlaa tawi nawh ding valh kaw, Huu khanna ang ding amyihna. ");
INSERT INTO hltthb_vpl VALUES ("PR23_6","021_23_6","PRO","23","6","6","Thlak yyt a buh koeh ai nawh, a buh tui ant tui koeh nai. ");
INSERT INTO hltthb_vpl VALUES ("PR23_7","021_23_7","PRO","23","7","7","Ak poek amyih koep nani a awmna, “Ai hlah, aw hlah,” ti kawm saw; cehlai ak kawlung ing am ti tang kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR23_8","021_23_8","PRO","23","8","8","Na buh ai ce laawk kawm tik saw, nak awihleek ce plak kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR23_9","021_23_9","PRO","23","9","9","Thlakqaw ang zaakna awi koeh kqawn, nak awicyihkhqi ce husit kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR23_10","021_23_10","PRO","23","10","10","Syn awhkawng qii lung ami khoeng koeh thoeih nawh, cadah a khawhyn koeh cuh pyi. ");
INSERT INTO hltthb_vpl VALUES ("PR23_11","021_23_11","PRO","23","11","11","Amingmih ak dyihpyikung taw ak thamah ni, anih ing na venawh awi kqawn law kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR23_12","021_23_12","PRO","23","12","12","Cawngpyinaak benna nak kawlung pe nawh, nang haa ing zaaknaak benna hawi. ");
INSERT INTO hltthb_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Nasen toel koeh hqeh, cumcik ing vyk tik seiawm am thi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","Cumcik ing na vyk awhtaw a hqingnaak cei khui awhkawng plawk kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR23_15","021_23_15","PRO","23","15","15","Ka capa, nak kaw a cyih awhtaw kak kaw zeel soeih soeih kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR23_16","021_23_16","PRO","23","16","16","Oeih, nam kha awhkawng awihthym ak cawnawh kak kaw awmhly soeih kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR23_17","021_23_17","PRO","23","17","17","Nak kawlung ing thlakche koeh oet seitaw, Khawsa kqihchahnaak doeng mah nak kawlung ing poek lah. ");
INSERT INTO hltthb_vpl VALUES ("PR23_18","021_23_18","PRO","23","18","18","Kutdo awm law ngai kawm saw, nang ngaihuunaak ing am qeeng ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","19","Ka capa, ngai nawh, cyi lah, lam ak thym awh nak kawlung sawi lah. ");
INSERT INTO hltthb_vpl VALUES ("PR23_20","021_23_20","PRO","23","20","20","Zuuk awkhqi ven ingkaw buh meh ak sawkkhqi venawh koeh boei; ");
INSERT INTO hltthb_vpl VALUES ("PR23_21","021_23_21","PRO","23","21","21","Zuuk quikhqi ingkaw buh meh ak sawkkhqi taw khawdeng kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR23_22","021_23_22","PRO","23","22","22","Na pa, anik canaak ak awi ce pawm nawh, na nu ce a nucawng lawawh koeh thekha na. ");
INSERT INTO hltthb_vpl VALUES ("PR23_23","021_23_23","PRO","23","23","23","Awihthym ce thlai nawh koeh zawi voel; cyihnaak, cawngpyinaak, zaaksimnaakkhqi awm. ");
INSERT INTO hltthb_vpl VALUES ("PR23_24","021_23_24","PRO","23","24","24","Thlakdyng a pa taw awmhlynaak ak sang soeih ta kawm saw, capak cyi ak canaak ing ak khanawh zeelnaak ta kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR23_25","021_23_25","PRO","23","25","25","Na nu ingkaw na pa kawzeel sak lah, nang anik canaak kung awmhlynaak ing awm seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR23_26","021_23_26","PRO","23","26","26","Ka capa, nak kawlung ni pe lah, ka khawsak na mik ing hat lah seh. ");
INSERT INTO hltthb_vpl VALUES ("PR23_27","021_23_27","PRO","23","27","27","A pum ak zawi nu taw lawkkhqawng dung amyihna, samphaih nu taw ak ceek lawkkhqawng amyihna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR23_28","021_23_28","PRO","23","28","28","Qukai amyihna thlang qym nawh, pakhqi ce amak ypawm thlangna coeng sak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","29","Unu khaw ak map? Unu kaw ak see? Unu hqo ak hu? Unu ak patang? Unu ak leem? Unu amik ak ling? ");
INSERT INTO hltthb_vpl VALUES ("PR23_30","021_23_30","PRO","23","30","30","Zuukung thawh ta dam nawh, zuu ing ak thoek qu ak aw thlangkhqi ni. ");
INSERT INTO hltthb_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","Ak ling zuu, boengloeng khanawh phyl nawh, plaiplek ing awiqawng khui ak kun koeh toek. ");
INSERT INTO hltthb_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","A dytnaak benawh khqui amyihna thlang cuk nawh khqui sy ak ngaan ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","Na mik ak changchangna dai nawh, nak kaw khawhang sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR23_34","021_23_34","PRO","23","34","34","Tuicunli sawawh ak ip amyihna awm kawm tik saw, laawng hizannaak tung lingawh ak ip amyihna awm kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","Ni vyk u seiawm am tlo nawh, ni phawp useiawm am za nyng! Kang hqyng law tlaih awhtaw ka aawk hamkawi ak chang hu tlaih bit kawng,” ti kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR24_1","021_24_1","PRO","24","1","1","Thlakchekhqi koeh oet nawh, aming lakawh ngawih koeh nai. ");
INSERT INTO hltthb_vpl VALUES ("PR24_2","021_24_2","PRO","24","2","2","Amik kawlungawh amak leek poeknaak doeng cawng unawh, amim kha ing thawlh sainaak doeng teng uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR24_3","021_24_3","PRO","24","3","3","Cyihnaak im taw sakna awm nawh, simnaak ing cak sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR24_4","021_24_4","PRO","24","4","4","Simnaak ing imkhui awh khawh a phuk tlo tlo bee sakna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR24_5","021_24_5","PRO","24","5","5","Cyihnaak ak ta thlang taw a qym awm nawh, simnaak ak ta thlang taw ak thaawmnaak pung hy. ");
INSERT INTO hltthb_vpl VALUES ("PR24_6","021_24_6","PRO","24","6","6","Ceem tlyk hlanawh ak leek soeih khawkhannaak taak leek nawh, cainaak ak leek taak ing qaal noeng sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR24_7","021_24_7","PRO","24","7","7","Thlakqaw ham cyihnaak sang aih nawh, thlang kqeng haiawh ak kqawn kawi awi am ta hy. ");
INSERT INTO hltthb_vpl VALUES ("PR24_8","021_24_8","PRO","24","8","8","Them amak leek sai ham khawkpoeknaak ak ta taw thlang ing seet ak saikung tina kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR24_9","021_24_9","PRO","24","9","9","Thlakqaw poeknaak taw thawlh ni, thlang husit taw thlang ham sawhnaak kawi ni. ");
INSERT INTO hltthb_vpl VALUES ("PR24_10","021_24_10","PRO","24","10","10","Kyinaak na huhawh nang ngaam awhtaw tha amak ta thlang ni. ");
INSERT INTO hltthb_vpl VALUES ("PR24_11","021_24_11","PRO","24","11","11","Him ham a mi sawikhqi ce hul lah. Himna ak awm hly khqi ce ang tawnna thawng. ");
INSERT INTO hltthb_vpl VALUES ("PR24_12","021_24_12","PRO","24","12","12","“Ngai lah vetaw am sim nyng” na ti awhtaw, kawlung ak khinkung ing am sim hly nawh aw? Na hqingnaak ak doenkung ing am sim hly nawh aw? Thlang boeih, ami bibi amyihna thungna am awm hly nawh aw? ");
INSERT INTO hltthb_vpl VALUES ("PR24_13","021_24_13","PRO","24","13","13","Ka capa, khawitui ak leek soeih aw lah; khawilutui na hamna ak aawi dikdik ce aw. ");
INSERT INTO hltthb_vpl VALUES ("PR24_14","021_24_14","PRO","24","14","14","Cawhce na hqingnaak ham cyihnaak taw cemyih nani ti sim nawh; na huhawh, na hamna hai ben ngaih-uunaak awm nawh, nang ngaih-uunaak ing am boet tlaih kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR24_15","021_24_15","PRO","24","15","15","Aw, thlakche pa, thlakdyng a im koeh muk, a awmnaak koeh hqee pe. ");
INSERT INTO hltthb_vpl VALUES ("PR24_16","021_24_16","PRO","24","16","16","Thlakdyng taw voei khqih tlu seiawm tho tlaih kaw; thlakche ang tluuk awhtaw am tho thai voel kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR24_17","021_24_17","PRO","24","17","17","Na qaal ang tluuk awh koeh zeel nawh, bo sakna a awmawh nak kaw koeh zeel sak; ");
INSERT INTO hltthb_vpl VALUES ("PR24_18","021_24_18","PRO","24","18","18","Cekkaataw Bawipa ing ni hu kawm saw, am zeel kawm saw, ak khan awh ak kawsonaak ce qeem kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR24_19","021_24_19","PRO","24","19","19","Thlakchekhqi caming koeh ly nawh, thlang thawlh koeh oet. ");
INSERT INTO hltthb_vpl VALUES ("PR24_20","021_24_20","PRO","24","20","20","Thlangthawlh ham kutdo am awm kawm saw, thlakche a maihchoei cetaw him pekna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR24_21","021_24_21","PRO","24","21","21","Ka capa, Bawipa ingkaw sangpahrang ce kqih nawh, kawhaa ak toenkhqi ce koeh pyi na; ");
INSERT INTO hltthb_vpl VALUES ("PR24_22","021_24_22","PRO","24","22","22","Ami ham seetnaak thoeng law tawk kawm saw, a mi qeengnaak hly kum uing nu a sim hly? ");
INSERT INTO hltthb_vpl VALUES ("PR24_23","021_24_23","PRO","24","23","23","Ve tloek awm thlakcyi ak awi kqawn ni, awi tlyk awh thlang hai toek am leek hy. ");
INSERT INTO hltthb_vpl VALUES ("PR24_24","021_24_24","PRO","24","24","24","Ak bo thlang venawh, “Na thawlhnaak am awm hy,” ak ti naak taw thlang boeih ing tamlawh kawm usaw, khawqam ing hoet kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR24_25","021_24_25","PRO","24","25","25","Ak toeltham ak thlangkhqi taw zeel kawm usaw, amik khanawh zoseennaak pha law kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR24_26","021_24_26","PRO","24","26","26","Awih thym ing ak hlatkung taw pyi leek ni. ");
INSERT INTO hltthb_vpl VALUES ("PR24_27","021_24_27","PRO","24","27","27","Kawngmaa awh bi na sai ham toen boeih nawh, na lo maa awh toen nawh, cecoengawh na im ce sa. ");
INSERT INTO hltthb_vpl VALUES ("PR24_28","021_24_28","PRO","24","28","28","Lehcainaak a awm kaana na imcengkhqi a kawnglamawh simpyikungna koeh awm nawh, nam kha ingawm koeh thalat na. ");
INSERT INTO hltthb_vpl VALUES ("PR24_29","021_24_29","PRO","24","29","29","“Kak khanawh a sai amyihna ak khanawh sai lawt kawng nyng saw, a bi sai amyihna pe kawng nyng,” koeh ti. ");
INSERT INTO hltthb_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Thlak thakdam lona cet nyng, simnaak amak ta misur dumna awm; ");
INSERT INTO hltthb_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","Ngai lah, hling hqoengna awm nawh, dek awm bei hqoengna be nawh, a vawng chungnak lung khoeng awm tlu boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Ka huh awh, ak dungna poek qunyng, a ni cawngpyinaak ce hu nyng saw pawm thai nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","Na ngaih awhtaw zaih, ip nawh, na kut khooem nawh dym poek poek, ");
INSERT INTO hltthb_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","Na ih hlanawh khawdeng kawm ti saw, voetvainaak ing ceemqal amyihna thoeng law tawk kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR25_1","021_25_1","PRO","25","1","1","Ve awm Solomon ak awicyih, Juda sangpahrang Hezekiah ak thlangkhqi ing a mi qee tlaih ni. ");
INSERT INTO hltthb_vpl VALUES ("PR25_2","021_25_2","PRO","25","2","2","Ik-oeih thuh taw Khawsa a boeimangnaakna awm nawh, sangpahrang a boeimangnaak taw ce ak thuh qu sui nawh pho sak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR25_3","021_25_3","PRO","25","3","3","Khan ve saang soeih nawh, dek awm dung soeih nawh, sangpahrangkhqi kawlung awm sim boeih hly kawi am ni. ");
INSERT INTO hltthb_vpl VALUES ("PR25_4","021_25_4","PRO","25","4","4","Ngun eek ce meet lah, cawhtaw ngun ak sepkung hamna them ak leek soeihna coeng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR25_5","021_25_5","PRO","25","5","5","Sangpahrang haiawh thlak thawlh ce thoeng unawh, a sangpahrang ngawihdoelh ce dyngnaak ing cak sakna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR25_6","021_25_6","PRO","25","6","6","Sangpahrang haiawh namah ingkaw namah koeh kyihcah qu nawh, boeikhqi a haiawh hyn koeh lo. ");
INSERT INTO hltthb_vpl VALUES ("PR25_7","021_25_7","PRO","25","7","7","Na huh khawi boei a haiawh chah na phyih anglakawh “ngawihnaak ak leekawh ngawi lah,” a mi nitinaak ce leek bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR25_8","021_25_8","PRO","25","8","8","Khqah qu ham hqii koeh tawn sak, a huna na imcengkhqi ing chah a mini phyih sak awhtaw, ikaw na sai hly am sim kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR25_9","021_25_9","PRO","25","9","9","Na kawnglam ce na imceng ingqawi kqawn haih nih nawh, thlakchang ak awihyp mah koeh pho kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR25_10","021_25_10","PRO","25","10","10","A nik sim ing ni zyi kawm saw, nang ming seetnaak am qeeng thai kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR25_11","021_25_11","PRO","25","11","11","Ak thymna awi kqawn balh taw ngun bawm awhkaw sui thaih ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR25_12","021_25_12","PRO","25","12","12","Ak ngaikung ang haawh thlakcyi ak awi kqawn taw sui hathen ing sui ak leek soeih aawi ingqawi myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR25_13","021_25_13","PRO","25","13","13","Ak tyikungkhqi ham dyihthing ypawm taw caang ah tym awhkaw daam tui ing myih nawh, a boei ak kaw caih sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR25_14","021_25_14","PRO","25","14","14","A mapek ak pena ak kqawn qu nawh, ak oe qu taw amak aa cingmai ingkaw khawhli ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR25_15","021_25_15","PRO","25","15","15","Kawdungnaak ing ukkung kaw dawm sak thai nawh, awih neem ing quh awm ek sak thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR25_16","021_25_16","PRO","25","16","16","Khawitui na hu lek? Khoek neh sak nawh aw, a ni lawnnaak dy na ai awhtaw laawk kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR25_17","021_25_17","PRO","25","17","17","Na imceng venna koeh plam aih, ning huuna nawh ni sawhna lat kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR25_18","021_25_18","PRO","25","18","18","A imceng ak khanawh ak thym simpyikung na amak dyi taw thingboeng, cimca ingkaw pala ak hqaat ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR25_19","021_25_19","PRO","25","19","19","Kyinaak huhawh amak ypawm thlang ak yp naak taw haa ak ek ingkaw khaw ak khoem ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR25_20","021_25_20","PRO","25","20","20","Thlang ak kawsee venna hla ak sakung taw chikca awh thlang angki suh pek ingkaw thui hqoep awh kuuk sak ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR25_21","021_25_21","PRO","25","21","21","Na qaal phoen a cawih awh buh pe nawh tui a hoet awh aawk kawi tui pe lah, ");
INSERT INTO hltthb_vpl VALUES ("PR25_22","021_25_22","PRO","25","22","22","Ceamyihna na sai awhtaw a lukhanawh maih eh ling na tloeng pek ing myih kawm saw, Bawipa ing zoseennaak ni pe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR25_23","021_25_23","PRO","25","23","23","Asiip ben nakaw zilh ing khawkaa a lawpyi amyihna thlang ak theet ing kawsonaak lawpyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR25_24","021_25_24","PRO","25","24","24","Nu, hqo ak lo poepa ingqawi imkhui oet awh awm haih anglakawh iptih kilawh awm leek bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR25_25","021_25_25","PRO","25","25","25","Khawkhla nakaw awithang leek taw thlang tui ak hoet ham tuiding ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR25_26","021_25_26","PRO","25","26","26","Thlakdyng, thlakche lam ak pleeng taw khawcui awhkaw deknaawng ingkaw tuih nuu ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR25_27","021_25_27","PRO","25","27","27","Khawitui khawzah aawk am leek nawh, cemyih koepna thlang amah ham kyihcahnaak ak sui taw thlang leek am ni. ");
INSERT INTO hltthb_vpl VALUES ("PR25_28","021_25_28","PRO","25","28","28","Thlang amah ak kawlung amak doen noeng taw vawngchungnaak ak tlu khaw ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_1","021_26_1","PRO","26","1","1","Khawhqai awh damtui a baw ingkaw caang ah tym awh khaw a aa a mang kawihvaihnaak amyihna thlakqaw kyihcah am kawihvaih na hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_2","021_26_2","PRO","26","2","2","Hqitca ak ding hy hy ingkaw cinghin pha ak ding amyihna lehcainaak a awm kaana khaw khy ing phu am ta hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_3","021_26_3","PRO","26","3","3","Meqang ham vyknaak qui awmnawh, laa ham hathawng qui a awm amyihna, thlakqaw hamna cumcik awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_4","021_26_4","PRO","26","4","4","Thlakqaw ce a qawnaak amyihna koeh thung, amah myih pyi kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR26_5","021_26_5","PRO","26","5","5","Thlakqaw ce a qawnaak amyihna thung lah, cekkaataw ak cyina ngai qu hau kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR26_6","021_26_6","PRO","26","6","6","Thlakqaw awi ak yyn taw amah a khaw ak tlyk ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_7","021_26_7","PRO","26","7","7","Khawkhem khaw a bat hqoeng amyihna thlakqaw am khaawh cyihnaak ce awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_8","021_26_8","PRO","26","8","8","Thlakqaw kyihcah taw pehzaai awh pehlung mawp ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_9","021_26_9","PRO","26","9","9","Thlakqaw am khaa awhkaw cyihnaak awi taw zukqui kut awhkaw hling ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_10","021_26_10","PRO","26","10","10","Thlakqaw ingkaw thlakche ak pyinaak taw lii ak kaap thai ak leem hoeih hoeih ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_11","021_26_11","PRO","26","11","11","Thlakqaw a qawnaak ak dang sak tlaih tlaih taw Ui am lawh ak ai tlaih ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_12","021_26_12","PRO","26","12","12","Amah ingkaw amah thlakcyina ak ngaiqu nak hu aw? Anih anglakawh thlakqaw awh ngaih-uu kawi khawzah awm lat hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","Thlak thakdam ing, “Lamawh samthyn awm nawh, kawngma awh samthyn awm hy,” ti khawi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_14","021_26_14","PRO","26","14","14","A batnaak quiawh chawh ang bat amyihna thlak thakdam ing ihkhun awh bat khaak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","Thlak thakdam taw a kut ing beei pui hlai hy, am kha tuh tlaih ham awm ngak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_16","021_26_16","PRO","26","16","16","Khaw ak poek thai thlang khqih ak awi kqawn lakawh thakdam ing ak cyi betna ngai qu hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_17","021_26_17","PRO","26","17","17","A kawnglam a awm kaana lam a ceh doena a ming hqonaak awh ak boei pahoei taw Uiang haa ak tu ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_18","021_26_18","PRO","26","18","18","Imceng thailat na nawh, “Ka ni citi naak ni? ak tikung taw ");
INSERT INTO hltthb_vpl VALUES ("PR26_19","021_26_19","PRO","26","19","19","Thlakqaw, maitawn, laa, thihnaak ing ak khawng ak kap ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_20","021_26_20","PRO","26","20","20","Thing a tlawi awh mai a thih amyihna, theet-naak ama awmnaak awh lai dip hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_21","021_26_21","PRO","26","21","21","Maih eh cak nawh thing ang kqawng amyihna hqo ak hu ak thlang taw khqah qu ak thawh sak kung ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_22","021_26_22","PRO","26","22","22","Theetnaak awi ak kqawnkhqi awi taw buh tui ant tui amyihna thlak khqik phoen dy lut hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_23","021_26_23","PRO","26","23","23","Ak awi kqawn leek moe kawlung ak see thlang taw dek am ak khanawh cak tui a mim hluk ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_24","021_26_24","PRO","26","24","24","Thlang theet ak nget ak thlang taw am kha ing thuh phah nawh, ak kawlung awh thailatnaak ing bee hy. ");
INSERT INTO hltthb_vpl VALUES ("PR26_25","021_26_25","PRO","26","25","25","Awi leek soeih kqawn seiawm koeh cangna, tuih ak cu khqih awm hy ak kawlung khuiawh. ");
INSERT INTO hltthb_vpl VALUES ("PR26_26","021_26_26","PRO","26","26","26","Ak thlang theetnaak ce thailatnaak ing thuh seiawm, ak kawpoek a seetnaak taw thlang haiawh phona awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR26_27","021_26_27","PRO","26","27","27","Vaam ak co taw amah a vaamawh tla kawm saw, lung ak hlih taw amah ak khanawh ce a lung hlih law tlaih kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR26_28","021_26_28","PRO","26","28","28","Qaai ak kqawn am lai ing a tloh sak thlangkhqi ce sawhnaak khqi nawh, thlang ak kyihcah phawk am kha ing seetnaak pha sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_1","021_27_1","PRO","27","1","1","Khawngawi a ham koeh oe qu, ce khawnghii ing ikaw a thoeng law hly pyi am sim hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("PR27_2","021_27_2","PRO","27","2","2","Namah ingkaw namah koeh kyihcah qu nawh thlang ing mah nim kyihcah seh. Na hui am, am na sim thlang a hui ing nim kyihcah seh. ");
INSERT INTO hltthb_vpl VALUES ("PR27_3","021_27_3","PRO","27","3","3","Lung taw qih soeih nawh, dizui ing qih hlai moe, ceseiawm thlakqaw ing thlak kaw a so sak ve qih bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_4","021_27_4","PRO","27","4","4","Kawtawinaak ing phyl nawh, kawsonaak ing tlung hy; cehlai yytnaak ve uing nu ang yh noeng kaw? ");
INSERT INTO hltthb_vpl VALUES ("PR27_5","021_27_5","PRO","27","5","5","Lungnaak ing thuh phah anglakawh ak dangna toeltham qu leek bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_6","021_27_6","PRO","27","6","6","Pyi ingtaw lungnak ing ni lambai na nawh, na qaal ingtaw thailatnaak ing ni mawk kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR27_7","021_27_7","PRO","27","7","7","Phoet phyi ham taw khawilu awm tuih kawina awm nawh, phoet cawi ham taw ant kha awm ak aawi ni. ");
INSERT INTO hltthb_vpl VALUES ("PR27_8","021_27_8","PRO","27","8","8","Thlang a im ak vantaak taw, pha ang bu ak poengtaak ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_9","021_27_9","PRO","27","9","9","Bawktui ingkaw bawktui khu ing kawlung a awmhly sak amyihna, kawlung tak awhkawng ak cawn law pyi ak khawsimnaak ing kawlung nawm sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_10","021_27_10","PRO","27","10","10","Na pyi ingkaw na pa a pyi ce koeh hlah; kyi-naak na huhawh nam cawt imna koeh ceh; na imceng taw khawlawng hla nakaw nam cawt anglakawh leek bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_11","021_27_11","PRO","27","11","11","Ka capa, cyi nawh, kak kaw ni zeel sak lah; Anik thekhanaakkhqi kam hlat naak thai ham. ");
INSERT INTO hltthb_vpl VALUES ("PR27_12","021_27_12","PRO","27","12","12","Thlakcyi ing amak leek them a huhawh thuk taak nawh, thlakqaw ingtaw pan nawh amah ing zaawk na hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_13","021_27_13","PRO","27","13","13","Am sim thlang ham ingkaw khawsak amak leek nu ham dyihthingna ak dyi thlang taw a hibai mai aw, a khawhkham pynoet oet mai aw hawih seh. ");
INSERT INTO hltthb_vpl VALUES ("PR27_14","021_27_14","PRO","27","14","14","Mymcang hii tho nawh, a imceng ce khaw-tehna khy nawh zoseennaak ak pe taw, quun ak khy pek ing myih kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR27_15","021_27_15","PRO","27","15","15","Hqo ak sai poepa zu taw khawcui awhkaw iptih ak cei ben tloei ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_16","021_27_16","PRO","27","16","16","Cemyih a nu ak khoem taw khawhlii ak khoem ing myih nawh kut khanawh situi thloen ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_17","021_27_17","PRO","27","17","17","Thii ing thii a hqaat sak amyihna thlang ing thlang hqaat sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_18","021_27_18","PRO","27","18","18","Thai thing ak lingkung ing thai thaih ai kawm saw, a boei ak khuut taw kyihcahna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR27_19","021_27_19","PRO","27","19","19","Tuiawh mikhai ang dang amyihna thlang ak kawlung thlangawh dang hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_20","021_27_20","PRO","27","20","20","Ceikhui ingkaw Abaddon ing a khoek sak ama awm amyihna thlanghqing mik ing a khoek sak qoe am ta hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_21","021_27_21","PRO","27","21","21","Cak am ing a caknaak dang sak nawh, mai ing a suinaak dang sak hy; Cemyih lawtna kyihcah-naak ing ak thlangnaak dang sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_22","021_27_22","PRO","27","22","22","Thlaqaw taw supkhai ing sumawh ni deeng seiawm ak qawnaak ce am khawng ti kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR27_23","021_27_23","PRO","27","23","23","Na tuukhqi ce ak leekna sim ham cai nawh nak khqinkhqi ce ak leekna khoem. ");
INSERT INTO hltthb_vpl VALUES ("PR27_24","021_27_24","PRO","27","24","24","Khawhkhamkhqi ve kumqui ham am nawh, boei lumyk taw na cadil ham dyna cak poepa kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR27_25","021_27_25","PRO","27","25","25","Saitlim aat usaw amah ing tawi tlaih tlaih nawh, tlang nakaw saitlim cun kawi uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_26","021_27_26","PRO","27","26","26","Na tuukhqi ce na suisak a ham, meekhqi ce na khawhyn phu hamna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR27_27","021_27_27","PRO","27","27","27","Na imkhui cakaw ai a ham, na tamnaa nukhqi nam cahnaak ham mee suktui ing be ngen poepa kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR28_1","021_28_1","PRO","28","1","1","Thlakche taw ahu am hqut u seiawm cen kaw. Thlakdyng taw samthyn amyihna am thin awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR28_2","021_28_2","PRO","28","2","2","Qam khuiawh qaal a thawhawh, ukkung khawzah awm hy, cehlai khaw ak poek thai ingkaw cyihnaak ak taa thlang ingtaw ak dingna qam uk hy. ");
INSERT INTO hltthb_vpl VALUES ("PR28_3","021_28_3","PRO","28","3","3","Khawdengkhqi ak thekhanaak ukkung taw tawi an amak tawi sak qawh tui ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR28_4","021_28_4","PRO","28","4","4","A lawngim ak cehtaakkhqi ing thlakche kyihcah unawh, cehlai a lawngim amyihna khaw ak sakhqi ingtaw oelh uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR28_5","021_28_5","PRO","28","5","5","Thlang amak leek ing ik-oeih ak dyng am sim thai uhy, cehlai Bawipa ak sui thlangkhqi ingtaw ak soep cana sim thai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR28_6","021_28_6","PRO","28","6","6","Amak thymna khaw ak sa kuiqang lakawh caawt kawi amak awmna khawksa khawdeng leek bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR28_7","021_28_7","PRO","28","7","7","A lawngim amyihna khaw ak sa thai thlang taw khaw ak poek thai capak cyihna awm hy, cehlai aawk ai ak kamva ak pyinaak capa ingtaw a pa chah pyih sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR28_8","021_28_8","PRO","28","8","8","A pung khawzah lawhnaak ing boei nawh thlang hamna them khawzah ak cun thlang taw, khawdengkhqi ak qeenkung na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR28_9","021_28_9","PRO","28","9","9","U awm a lawngim benna haa amak keeng thlang taw, ak cykcahnaak awm tuih ak cu ni. ");
INSERT INTO hltthb_vpl VALUES ("PR28_10","021_28_10","PRO","28","10","10","Thlakdyng, lam amak leekawh ak ceh pyi taw amah a vaam cawh nawn awh tla kaw, cehlai thlak soep coet amak kap ingtaw qo leek pang kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR28_11","021_28_11","PRO","28","11","11","Kuiqang thlang ing amah ngaih awh thlakcyi na ngai qu mai seiawm, thlak khawdeng khawkpoek thai ingtaw ak ceetna huh pe hy. ");
INSERT INTO hltthb_vpl VALUES ("PR28_12","021_28_12","PRO","28","12","12","Thlakdyng ing noengnaak a huhawh kyihcahnaak ak sang soeih pe uhy; cehlai thlakche a boei awh thlangkhqi ing thuk taak uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR28_13","021_28_13","PRO","28","13","13","A thawlh ak thuhphah ak thlang ing qeennaak am ham kawm saw, a thawlhnaak pho sak nawh qeennaak ak thoeh ing qeennaak hu kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR28_14","021_28_14","PRO","28","14","14","Bawipa ak kqihcah poe taw thlang zoseen ni, am thin ak sah ak thlang taw kyinaak sawng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR28_15","021_28_15","PRO","28","15","15","Khawdeng ak thekhanaak ukkung taw samthyyn ak kaawk ingkaw phawm ak tlung ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR28_16","021_28_16","PRO","28","16","16","Khawkpoek thainaak amak ta ukkung taw thlang ak phep qeekung ni, amak thymna them huh ak sawhnaak thlang taw a hqinglung saang kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR28_17","021_28_17","PRO","28","17","17","A kutawh thlang thi ak lawng lawkkhqawng dungawh tla kawm saw, u ingawm koeh hul seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR28_18","021_28_18","PRO","28","18","18","U awm ak thymna khawksa taw loet sakna awm kawm saw, amak thymna khawksa taw tlu poe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR28_19","021_28_19","PRO","28","19","19","A loawh bi ak bi ing aawk ai khawzah hu kaw, cehlai a nawmnaak doeng ak sui thlang taw khawdeng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR28_20","021_28_20","PRO","28","20","20","Thlak ypawm ing zoseennaak hu kawm saw, cehlai boei ak ngaih aih taw a phep kaana am hlah kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR28_21","021_28_21","PRO","28","21","21","Thlang mikhai toek am leek hy, cehlai phaipi cun oet mai ing thlang ing thawlh sai thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR28_22","021_28_22","PRO","28","22","22","Thlakqu ing them hu hquut nawh, ak khan-awh khawdengnaak a pha law hly am sim hy. ");
INSERT INTO hltthb_vpl VALUES ("PR28_23","021_28_23","PRO","28","23","23","Awih leek ing anik kyihcahna ak saa qu thlang lakawh anik toelthamkung ing a huna kyihcahnaak hu kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR28_24","021_28_24","PRO","28","24","24","A nu pa a them muk nawh, “Am poei hy,” ak ti taw thlang ak plam sakkung ni. ");
INSERT INTO hltthb_vpl VALUES ("PR28_25","021_28_25","PRO","28","25","25","Ak kamvaa a awmnaak awh phekbonaak awm nawh, Bawipa ak ypnaak taw thlang zoseen ni. ");
INSERT INTO hltthb_vpl VALUES ("PR28_26","021_28_26","PRO","28","26","26","Ak poeknaak awh ak hanng ak thlang taw thlakqaw na awm nawh, cehlai cyihnaak awh ak cet taw thlang zoseen ni. ");
INSERT INTO hltthb_vpl VALUES ("PR28_27","021_28_27","PRO","28","27","27","Khawdeng them ak pe taw am khawdeng kawm saw, ak hawimang taak taw quun khy pekna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR28_28","021_28_28","PRO","28","28","28","Thlakche a boei awh thlak boei ing thuk taak nawh, cehlai thlakche a thih awh thlakdyngkhqi pung uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_1","021_29_1","PRO","29","1","1","Thlang ing a toelzyih coeng awhawm kaw ak ting thlang taw amak voei thai voelna plam kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR29_2","021_29_2","PRO","29","2","2","Thlakdyng a awm awh pilnam ak kawzeel nawh, thlakche ing a uk awh pilnam kaw vung hy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","Cyinaak ak lungnaak ing a pak kaw zeel sak nawh, a pum ak zawi nu ak ih pyi taw a khawh plam kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR29_4","021_29_4","PRO","29","4","4","Ak thymna ak uk sangpahrang ing khawqam cak sak nawh, cehlai ang hyp kutdo ak lungnaak ing khawqam seet sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR29_5","021_29_5","PRO","29","5","5","A imceng ak kyihcah phawk taw a khaw ham thang ak duun ni. ");
INSERT INTO hltthb_vpl VALUES ("PR29_6","021_29_6","PRO","29","6","6","Thlakche taw amah thawlhnaak awh aawk nawh, thlakdyng taw awmhly nawh laa sa hy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_7","021_29_7","PRO","29","7","7","Thlakdyng ingtaw khawdengkhqi hamna lam ak leek poek pek khqi nawh, thlakche ingtaw ak poeknaak ham kawlung am pe hy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_8","021_29_8","PRO","29","8","8","Thlang ak thekhanaak ing khawkkhui awi pung sak nawh, thlakdyng ingtaw kawsonaak qeem sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_9","021_29_9","PRO","29","9","9","Thlakcyi ing thlakqaw a oelh awhtaw qoepquinaak am awm thai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_10","021_29_10","PRO","29","10","10","Thi lawng sak ak lungnakkhqi ing thlakleek hudam unawh, thlakdyng ingtaw a hqingnaak hul ham cai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_11","021_29_11","PRO","29","11","11","Thlakqaw ing ak kawsonaak kqawn boeih nawh thlakcyi ingtaw thuh phah nawh ngawih pyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_12","021_29_12","PRO","29","12","12","Ukkung ing qai kqawn awi ang ngaih awhtaw a tamnaakhqi boeih thlakche na awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_13","021_29_13","PRO","29","13","13","Khawdeng thlang ingkaw thlang ak hep qawi kutoetna khaw sa haih nih nawh, Bawipa ing a ni mik daih sak qawi haih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_14","021_29_14","PRO","29","14","14","Khawdeng cakhqi ypawm cana ak ukkung sangpahrang taw a boei ngaihnaak ce kumqui cak sakna awm poepa kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Cumcik ingkaw toelzyihnaak ing nasen cyi sak nawh, hlahphlam awhtaw a nu chah pyih sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR29_16","021_29_16","PRO","29","16","16","Thlache a pung awh thawlhnaak pung nawh, cekkhqi a ming tluk thlakdyngkhqi ing hu kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Na capa ce ak leekna toel nawh, dymnaak ni pe kawm saw kawpoek nawmnaak ni pe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR29_18","021_29_18","PRO","29","18","18","Hailam khaw huh thainaak ama awm awh pilnam hlahphlam nawh, cehlai aanaa awi ak ngai thlang taw a zoseen kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR29_19","021_29_19","PRO","29","19","19","Tamnaa taw awi mai ing tlaihvawng thai am ni; zasim seiawm am sai kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR29_20","021_29_20","PRO","29","20","20","Awi ak kqawn pyn pyn ak awm aw? A nih anglakawh thlakqaw awh ngaih-uunaak awm bet hy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_21","021_29_21","PRO","29","21","21","A nasen awhkawng awm pyi tamnaa ing ca a qo qup pyi kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR29_22","021_29_22","PRO","29","22","22","Thlak kawktawi ing khqah qu coeng sak nawh, thlak kawsonaak ing thawlhnaak sai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_23","021_29_23","PRO","29","23","23","Ak oek qu thlang ak kaina awm nawh, kaw ak daw ing kyihcahnaak hu hy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_24","021_29_24","PRO","29","24","24","Thlakqu ak pyinaak taw amah a hqingnaak ak sawhnaak ni; qun khy awi za moe seinu ak kqawn hly kqih hy. ");
INSERT INTO hltthb_vpl VALUES ("PR29_25","021_29_25","PRO","29","25","25","Thlang kqih nawh awi ak ngai hqoeh hqoeh taw a ham thang ak duun ing myih nawh, Bawipa ak ypnaak thlang taw a sa syng kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR29_26","021_29_26","PRO","29","26","26","Thlang khawzah ing ukkung haiawh mikhai-leek huh ham sui uhy, cehlai Bawipa ven na kawng ni thlang ing mikhaileek a huh hly thai. ");
INSERT INTO hltthb_vpl VALUES ("PR29_27","021_29_27","PRO","29","27","27","Thlakdyng ing amak thym them ce tuih nawh, thlakche ing thlakdyng ce tuih lawt hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_1","021_30_1","PRO","30","1","1","Jakeh a capa Agur ak awicyih taw vemyih na ni. Thlang ing Ethiel a venawh, Ethiel ingkaw Ukal a venawh vemyih na ce kqawn hy, ");
INSERT INTO hltthb_vpl VALUES ("PR30_2","021_30_2","PRO","30","2","2","“Thlangkhqi anglakawh ka sim kang zak awm am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_3","021_30_3","PRO","30","3","3","Cyihnaak am cawng nyng saw, thlakciim kawng awm am sim nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR30_4","021_30_4","PRO","30","4","4","Unu khanna kai nawh ak kqum law tlaih? Unu a kutawh khawhlii ak bym thai? Unu hibai ing tui ak cun? Unu khawmdek a dytnaak ak cak sak? Unu ang ming, a capa ming nak sim aw? ");
INSERT INTO hltthb_vpl VALUES ("PR30_5","021_30_5","PRO","30","5","5","Bawipa ak awikhqi boeih taw caawtbauh kawi am awm na, Amah ak cangnaakkhqi boeih ham ziingnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("PR30_6","021_30_6","PRO","30","6","6","Ak awikhqi ce koeh sap, cekkaataw nik coet kawm saw a qai ak kqawn thlangna awm kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR30_7","021_30_7","PRO","30","7","7","Aw Bawipa, them pakkhih ni thoeh nyng; ka thih hlanawh ni soep pe sak lah. ");
INSERT INTO hltthb_vpl VALUES ("PR30_8","021_30_8","PRO","30","8","8","Amak thym ingkaw qai kqawn ka venawh koeh awm sak; khawdengnaak ingkaw boeinaak awm koen ni pe, my ngawi ai tat buh mah ni pe. ");
INSERT INTO hltthb_vpl VALUES ("PR30_9","021_30_9","PRO","30","9","9","Cekkataw boei nyng saw nang nim hilh kawng nyng saw 'Bawipa taw a u nu?' ti hau kawng nyng. Amawh ka kawdeng awhawm qu kawng nyng saw na thang nim ceh hau kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("PR30_10","021_30_10","PRO","30","10","10","Tamnaa ce a boei venna koeh theet, quun nik khy pe kawm saw, nak khanawh thawlhnaak tla kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR30_11","021_30_11","PRO","30","11","11","A pa quun khy pe nawh, a nu amak kyihcah thlang awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_12","021_30_12","PRO","30","12","12","Amah poeknaak awh ak ciimna ak ngai qu thlang awm nawh; cehlai a thawlhnaak caihsakna am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_13","021_30_13","PRO","30","13","13","Khawpoek saang sak nawh hepnaak ing thlang ak toek awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_14","021_30_14","PRO","30","14","14","A haa cimsum amyihna awm nawh, khawmdek awhkaw khawngdengkhqi ingkaw ak voetvaikhqi daih hamna cimca ing ak be thlang awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_15","021_30_15","PRO","30","15","15","“Ni pe hlah, ni pe hlah,” tinawh ak khyy canu pakkhih ak ta litno awm hy. Amak phyi thai tlaih them pakthum awm hy, “Khoek hawh ny,” amak ti tlaih them puphli awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_16","021_30_16","PRO","30","16","16","Phyi, ca ak qeeng phoen, tui amak phyi thai deklai ingkaw “khoek hy,” amak ti man mai awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_17","021_30_17","PRO","30","17","17","A pa ak thekhanaak ingkaw a nuk awi ak hep mik taw lamawh ak ding vangaak ing cuk kawm saw; huu ing a sa ai pe kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR30_18","021_30_18","PRO","30","18","18","Kawpoek ak kyi sak ik-oeih pakthum awm nawh am kang zaaksim ik-oeih pupthli awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_19","021_30_19","PRO","30","19","19","Khanna kaw huu ang dingnaak lam, Luk khan awhkaw khqui a cehnaak lam, tuicunli awhkaw lawng a cehnaak lam ingkaw tangpa ing nula a pannaak lam tloek ce ni. ");
INSERT INTO hltthb_vpl VALUES ("PR30_20","021_30_20","PRO","30","20","20","Cemyih ceni samphaih nu a cehnaak lam taw; Ce nula ing ai nawh am kha a huih coengawh, “Them amak thum am sai nyng,” ti hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_21","021_30_21","PRO","30","21","21","Ve them pakthum ak caming khawmdek thyyn nawh ve them pupthli awh yh thainaak am ta hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_22","021_30_22","PRO","30","22","22","Tamnaa ce sangpahrangna coeng nawh, thlakqaw ing aawk ai ak bena ta hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_23","021_30_23","PRO","30","23","23","A mi hoet nula ing vaa ta nawh tamnaa nu ing a boei nu a qo pang hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_24","021_30_24","PRO","30","24","24","Khawmdek khanawh ik-oeih ak zawi soeih pupthli awm nawh, cehlai cekkhqi taw ak cyi soeih na awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_25","021_30_25","PRO","30","25","25","Liing ve ak tha ak zawi soeihna bi ak sai na awm moe, khawhqai awh aawk ai cun hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_26","021_30_26","PRO","30","26","26","Sathel ing tha a khoehca ni a taak hlai, lungnu thelpang khuiawh a im ta hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_27","021_30_27","PRO","30","27","27","Khamkhawkkhqi ing sangpahrang am ta uhy; cehlai kawoet cana cet haih thai uhy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_28","021_30_28","PRO","30","28","28","Satuiqai ing kuting tuuk thaina awm moe, sangpahrang imawh awmnaak hyn ta hy. ");
INSERT INTO hltthb_vpl VALUES ("PR30_29","021_30_29","PRO","30","29","29","Qypawmnaak ing ak saangna khaw ak kham ik-oeih pakthum awm nawh ypawm cana ak cet ik-oeih pupthli awm hy: ");
INSERT INTO hltthb_vpl VALUES ("PR30_30","021_30_30","PRO","30","30","30","Samthyn taw qamsa chunglak awh ak thamah soeih na awm nawh, ikawmyih ing awm a hu am voei sak khawi, ");
INSERT INTO hltthb_vpl VALUES ("PR30_31","021_30_31","PRO","30","31","31","Ak thamah aihlyi kit, memcai sing ingkaw qalkap ing ak chungkoep sangpahrang ce ni. ");
INSERT INTO hltthb_vpl VALUES ("PR30_32","021_30_32","PRO","30","32","32","Namah ingkaw namah thangsaknaak ham amak leek them na sai mai awh aw, amak leek ik-oeih poeknaak na taak mai awhtaw, nam kha cyyp sak. ");
INSERT INTO hltthb_vpl VALUES ("PR30_33","021_30_33","PRO","30","33","33","Suktui hqoet khingnaak ing suktui khal sak nawh ni hmaqawng nawi khingnaak ing thi ak cawn sak amyihna kawsonaak ing hqo hqitnaak cawn sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_1","021_31_1","PRO","31","1","1","Lemyl sangpahrang ak awicyih a nu ing a cawngpyinaak awi taw vemyihna ni; ");
INSERT INTO hltthb_vpl VALUES ("PR31_2","021_31_2","PRO","31","2","2","Aw ka capa, aw ka thi ka sa awhkawng ka canaak ka capa, aw kak awikam awhkawng ka canaak ka capa, ngai lah, ");
INSERT INTO hltthb_vpl VALUES ("PR31_3","021_31_3","PRO","31","3","3","Nak thamahnaak ce nu a hamna koeh pe, sangpahrang him ham ak caikhqi venawh na hqingnaak koeh pe kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("PR31_4","021_31_4","PRO","31","4","4","Aw Lemyl, Sangpahrangkhqi ing misurtui a mi aawk hly am ni, ukkungkhqi ing zuu ami aawk hly am ni. ");
INSERT INTO hltthb_vpl VALUES ("PR31_5","021_31_5","PRO","31","5","5","A mi aawk awhtaw aanaa awi ce hilh kawm usaw, thlak khawdengkhqi khanawh amak thymna uknaak ta kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("PR31_6","021_31_6","PRO","31","6","6","Ak thi tawm ce zuu pe unawh, ak kawseekhqi ce misurtui pe uh. ");
INSERT INTO hltthb_vpl VALUES ("PR31_7","021_31_7","PRO","31","7","7","Aw seitaw a khawdengnaak ce hilh seitaw a patangnaak ce hilh seh. ");
INSERT INTO hltthb_vpl VALUES ("PR31_8","021_31_8","PRO","31","8","8","Awi amak kqawn thai thlangkhqi hamna awi kqawn pe nawh, dyihpyikung amak ta khqi ing a mi ham kawi ce ham sak khqi. ");
INSERT INTO hltthb_vpl VALUES ("PR31_9","021_31_9","PRO","31","9","9","Ak thymna awi kqawn nawh awi deng lah; kawdengkhqi ingkaw ak voetvaikhqi a mi ham hly kawi ham sak khqi lah. ");
INSERT INTO hltthb_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","U nu khawsak ak leek nu ak hu? A phu taw suilung a phuk tlo lakawh a phu tlo ngai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","A vaa ing anih ce yp na nawh them a voetnaak am ta hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","A vaa hamna a hqing khui them leek ing bee sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Tuumyi ingkaw hla sui nawh, a kut ing kawzeel cana sai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","A nih cetaw them ak zawi lawng ing myih nawh, khawkhla nakawng ai kawi law pyi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","Khaw a dai hlanawh tho nawh; a imkhui khaw ingkaw a tamnaa nukhqi ham ai kawi toen hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","Khawhyn ce nainawng hqeet nawh thlai hy; a bibinaak khui awhkawng misur ce ling hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","Thamahnaak ing ak cawi zeen nawh, a baan thamah sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","Them a zawihnaak awh a phu awm nawh, khawmthan awh awm a mai im am thih man hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","A kut ingawh bu pawm nawh a kutply ingawh tahplem qawlh hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","A kut ce thlak khawdengkhqi benna soeng nawh, ak voetvaikhqi ven dyna pha sak hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","Daamtui baw nawh khaw a ding canawh a imkhui khaw ce hibai ak awih ing khuk khqi nawh lynaak am ta hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","Hiphaih leek soeih amah ham tak nawh, suisak leek ing hlawihhlam qu hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","Khawkkhui cunnaak chawmkeng kuun nawh a hqaamcakhqi ven ang ngawih awh a vaa ce thlang ing kqihchah na hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","Hla qui ak leek leek ing suibai tak nawh zawi hy, them ak thlaikhqi vena chawmqui ce thak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","A suisak taw thamahnaak ingkaw qypawmnaak na awm nawh, khawnghi ak pha law hly hamna awmhly hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","Cyihnaak ing am kha aang nawh, am khaaawh ypawmna toelthamnaak ce awm hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","A imkhui khawsak ak leekna toek nawh thakdam a buh am ai hy. ");
INSERT INTO hltthb_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","A cakhqi ing tho unawh, thlang zoseen nu ti kawm usaw, a vaa ingawm kyihcah kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","“Nu khawsak ak leek khawzah awm uhy. Cehlai nang ing pyh khqi boeih hyk ti,” ti nawh. ");
INSERT INTO hltthb_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Mikhaileek awm zoeknaak mai ni, dawnaak bai thailatnaak ni. Bawipa ak kqihchah a nu taw kyihcah tyngna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Ce a nu ce a bi thaphu pe unawh, khawkkhui lutnaak chawmkeng awh a bibinaak ing kyihcah lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abraham capa David, David capa Jesu Khrih a lawnaak cadil thuihnaak cauk taw vemyihna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ing Isaak ca na nawh; Isaak ing Jakob ca na hy; Jakob ing Judah cingnahqui ca na hy. ");
INSERT INTO hltthb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah ingkaw Tamar a ven awhkawng Perez ingkaw Zerah cana nawh; Perez ing Herezon cana hy, Herezon ing Qam cana hy. ");
INSERT INTO hltthb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Qam ing Amminadab ca na nawh, Aminadab ing Nahshon ca na hy; Nahshon ing Salmon ca na hy. ");
INSERT INTO hltthb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ingkaw Rahab a ven awhkawng Boaz ca na hy, Boaz ing Ruth a ven awhkawng Obed ca na hy; Obed ing Jesee ca na hy. ");
INSERT INTO hltthb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesee ing David sangpahrang ca na nawh; David sangpahrang ing Uria a zu ven awhkawng solomon ca na hy; ");
INSERT INTO hltthb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ing Rehoboam ca na hy; Rehobam ing Abijah ca na hy; Abijah ing Asa ca na hy; ");
INSERT INTO hltthb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ing Jehoshaphat ca na hy; Jehoshaphat ing Uzziah ca na hy; ");
INSERT INTO hltthb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah ing Jotham ca na hy; Jotham ing Ahaz ca na hy; Ahaz ing Hezekiah ca na hy; ");
INSERT INTO hltthb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah ing Manasseh ca na hy; Manasseh ing Amon ca na hy; Amon ing Josiah ca na hy; ");
INSERT INTO hltthb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Babylon khaw awh tamnaa na ami khyn tloek awh, Josiah ing Jekoniah ingkaw a mik cingnakhqi ca na hy; ");
INSERT INTO hltthb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babylon awh tamnaa na ami khyn coengawh; Jekoniah ing shealtiel ca na hy; Shealtel ing Zerubbabel ca na hy; ");
INSERT INTO hltthb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel ing Abiud ca na hy; A biud ing Azor ca na hy; ");
INSERT INTO hltthb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ing Zadok ca na hy; Akim ing Eliud ca na hy; ");
INSERT INTO hltthb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ing Eleazar ca na hy; Eleazar ing Matthan ca na hy; ");
INSERT INTO hltthb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob ing Meri va Joseph ca na hy; cawhkawng khrih ami ti uh, Jesu ce thang hy. ");
INSERT INTO hltthb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham awhkawng David dy khuk hlaihphli law hy; David awhkawng Babylon awh tamnaa na ami khyn dy khuk hlaihphli law hy; Babylon na ami khyn coeng awhkawng Khrih dy khuk hlaihphli law bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesu Khrih a thangnaak taw ve myihna awm hy: anu Meri ce Joseph ing a zu na kang nawh, kut oet na ani awm haih hlanawh, Meri ing Ciim Myihla ak caming naasen syn hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ava Joseph taw thlak dyng na a awm dawngawh, thlang ing a sim hlanawh, ang hyp na nawn dym aham cai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Cemyihna ak poek huili awh, Bawipa ak khan ceityih ce ang mang awh dang pe nawh, a venawh, “David capa Joseph na zu Meri ce lawh aham koeh kqih: a phyihsu taw Ciim Myihla ak caming ni tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Anih ing cakpa ta kawmsaw, ak thlangkhqi ce thawlhnaak khui awhkawng hul aham a awm dawngawh, ang ming taw JESU tinawh sui kawp ti, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bawipa ing a tawngha hawnaak ing anak kqawn ce a soepnaak aham ve myihkhqi boeih ve ana hang awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ngai lah, nulak cym ce phyihsu kawmsaw, cakpa ta kaw, ang ming taw Emmanuel tinawh khy kawm uh, ningnih a venawh Khawsa awm hy tinaak ni”. ");
INSERT INTO hltthb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph ing ang hqyng law awh Bawipa a ceityih ing awi a peek amyihna, Meri ce zu na hy: ");
INSERT INTO hltthb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","a ca a cuun hlan dy taw am heei hy; cekcoengawh a cakcyk ce cuun nawh JESU tinawh ming sui hy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herod ce sangpahrang na a awm awh Judah qam Bethlehem awh Jesu taw thang hy, cawh Khawlaw ben nakaw thlakcyikhqi ce Jerusalem na law uhy, ");
INSERT INTO hltthb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Judah thlangkhqi a sangpahrang ak thang ce hana a awm? Anih a aihchi ce khawlaw benna ka mi huh a dawngawh, anih bawk aham ka mik law ni” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ce ak awi ce Herod sangpahrang ing ang zaak awh ak kawpoek kyi hy, Jerusalem awh amik awm thlangkhqi boeih awm amik kawpoek kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Khawsoeih boeikhqi ingkaw ca qeekungkhqi boeih ce khy khqi nawh Khrih a thangnaak kawi hyn ce sui sak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Cekkhqi ing a venawh, “Judah qam Bethlehem khaw awh thang kaw: kawtih tawngha ing vemyihna ana qee hyt hawh hy; ");
INSERT INTO hltthb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nang Bethlehem, Judah qam khuiawh Judah ukkungkhqi anglakawh ak zawi soeih na am awm hyk ti. Ikawtih nak khui awhkawng ukkung law kawmsaw, anih ing kak thlang Israelkhqi ce uk kaw, tinawh qee hy,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Cekcoengawh Herod ing thlakcyikhqi ce ang hyp na khy nawh aihchi dang pehy tice ak nep caana doet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Cekcoengawh cekkhqi ce Bethlehem na tyi khqi hy; “Cet unawh naasen ce ak nep na sui law uh; nami huh awhtaw ning zaak law sak uh, kai ingawm cet nyng saw anih bawk lawt vang.” tina khi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Sangpahrang awi ce aming zaak coengawh cet uhy; cawh, khawlaw ben nakaw aihchi ce hu tlaih uhy, naasen a awmnaak hyn pha nawh ang dym hlan dy cekkhqi haiawh aihchi ce cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","A mingmih ing aihchi ami huh awh zeel soeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ipkhui na lut unawh naasen ingkaw anu Meri ce ami huh awh koep unawh bawk uhy. Ami a khawhbawm ce awng unawh; sui, frankinsen bawktui ingkaw mura ce pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Herod a venna a maming hlatnaak voel aham Khawsa ing a ming mang awh awi ak kqawn peek khqi a dawngawh ak chang lam ben nakawng voei uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","A mingmih ami ceh coengawh Bawipa ak khan ceityih ing Joseph ang mang awh dang pe nawh, “Tho nawhtaw, naasen ingkaw anu ce Egypt qam na cen pyi hlah, awi kak kqawn law hlan dy taw cawh ana awm uh; Herod ing naasen ce him aham sui li hawh hy” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Cawh anih ing tho nawh naasen ingkaw anu ce thawh nawh khawmthan awh Izip qam na cen pyi hy; ");
INSERT INTO hltthb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Herod a thih hlan dy taw cawh awm uhy: cetaw “Izip qam awhkawng ka capa ce khy nyng,” tinawh Bawipa ing a tawngha hawnaak ing ak kqawn ce a soepnaak aham ni. ");
INSERT INTO hltthb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Thlakcyikhqi ing ni qaai na hawh pai moe uh, tice Herod ing a sim awhtaw, ak kaw so soeih hy, thlang tyi nawh Bethlehem khaw awh ak awm naasen boeih boeih ingkaw a khawceng awhkaw ak awm naasenkhqi boeih thlakcyikhqi a doetnaak nyn dy awhkaw kum hih awhkawng ak kai boeih ce him sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Cawh ce Jeremiah ak awih kqawn soep hy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Qamah khawk khuiawh lungnat zaaknaak, kqahnaak ingkaw khy ang kqangnaak ce awm hy, Rachel ing a cakhqi ce kqah hy, a cakhqi ama awm voel hawh a dawngawh, ang ngaihqepnaak am awm voel hy”. ");
INSERT INTO hltthb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Cehlai Herod ce a thih coengawh Izip qam awh ak awm Joseph ang mang awh Bawipa ak khan ceityih ce dang pe nawh; a venawh, ");
INSERT INTO hltthb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Tho lah, naaca ce lo nawh Israel qam na cehpyi hlah: naaca him aham ak suikung ce thi hawh hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tho nawh naaca ingkaw a nu ce a lawh coengawh, Israel qam na hlat pyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Cehlai Arkhelaus ing a pa Herod ang zyng na, Judah qam awh boei na awm hy tice ang zaak awh, ce benna ceh aham kqih hy, ang mang awh Khawsa ing qalqiingnaak awi ak kqawn peek amyihna, Kalili qam benna ce cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nazareth ami ti khaw pynoet na ce cet nawh cawh ce awm hy. “Nazareth thlang tinawh khy kawm uh,” tinawh tawnghakhqi ing ami nak kqawn awi ce a soepnaak aham ce amyihna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ce tloek awh Baptisma ak pekung Johan ce law nawh, Judah qamkoh awh awi kqawn hy, ");
INSERT INTO hltthb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Zut lah uh khawk khan ram taw zoe hawh hy”, tinawh kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Veni tawngha Isaiah ing anak kqawn paicai hy: “Ramkoh awh ak khy awi ing, 'Bawipa lam ce qoek abah unawh, a lamkhqi ce dyng sak lah uh', tinawh anak kqawn ce. ");
INSERT INTO hltthb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johan ing kala-uk myi hi ce bai nawh, ak cawi ce savyn taisawm ing zen nawh, khamkhawk ingkaw khawitui ce buh a an na ai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Anih a venawh Jerusalem khawk thlangkhqi, Judah qam awhkaw thlangkhqi boeih ce cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ami thawlhnaakkhqi ce kqawn unawh, anih a baptisma ce hu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Cehlai, baptisma a peeknaak kung awh Farasikhqi ingkaw Sadusikhqi thlang khawzah amik law ce a huh awh, ami venawh, “Aw khqui a cadilkhqi, kawsonaak ak law hly ce centaak aham u ing nu anik kqawn peek khqi? ");
INSERT INTO hltthb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Zut doena qah phaat lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ka mi pa Abaraham ta u nyng kaw, tinawh koeh poek uh; ka nik kqawn peek khqi, Khawsa ing vawhkaw lungkhqi ve Abaraham a cakhqi na coeng sak thai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Thingkung boeih awh hqaica toen hyt na awm hawh nawh; ak thaih leek amak qah thingkungkhqi boeih taw hlu kawmsaw, mai awh phum kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kai ing tui ngawh zutnaak baptisma ce ni pek khqi nyng; cehlai kai a huawh ak law cetaw kai anglakawh bau khqoet hy, kai taw anih a khawmyk ak pawm peek aham za am tyng nyng; anih ingtaw Ciim Myihla ingkaw mai ing baptisma ce ni pek khqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A kut awh cang zahnaak khqa ce pawm kawmsaw, caang ce ak caih cana zap kaw, ang tak ce tep khuiawh chan kawmsaw ang hi taw amak thi thai qoe mai awh phum kaw tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Cawh Jesu taw Kalili qam awhkawng Johan a baptisma huh aham Jordan long na law hy. ");
INSERT INTO hltthb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Cehlai Johan ing tha na hy, “kai ing ni nang a baptisma huh aham ka ngaih hlai, kawtih kai a venna na law lat?” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesu ing a venawh, “Tuh sai mai, cawh ni ningnih aham dyngnaak boeih boeih a cup hly”, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesu ing Baptisma a huh coengawh, tui awhkawng cet hy. Cawh khawk khan ce anih aham awng qu nawh, Khawsa Myihla ce khqukkhqu amyihna ak khan awh ang cuk peek ce huhy. ");
INSERT INTO hltthb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Cawhtaw khan nakawng, “ve ve ka lungnaak ka Capa, ka ym soeih soeih ni”, tinawh awi ce law hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Cekcoengawh Jesu taw qaai a sykzoeknaak huh aham, Myihla ing qamkoh na hqui hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Dai phlikip ingkaw than phlikip buh ang hyh coengawh, ak phoen ce cawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ak sykkung ce a venna law nawh, “Nang ve Khawsa Capa na na awm awhtaw, vawhkaw lungkhqi ve phaihpi na coeng sak lah”, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Cehlai, Jesu ing ve myihna hlat pehy, “Thlang ve phaihpi doeng ing am hqing nawh, Khawsa am khak khui awhkawng ak cawn law saqui awi ing ni a hqing hy, tinawh qee ce na awm hy”, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Cekcoengawh qaai ing anih ce khawk bau ciim na ceh pyi nawh, bawkim iptih asaw cilin ca awh tahy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","A venawh, “Khawsa Capa na na awm awhtaw, nuk cawn lah; kawtih, vemyihna qee na awm hy; “Ak khan ceityihkhqi ce awi pe kawmsaw, na khawkhqi lung awh am nak chuknaak aham, a kut ing nang ce ni dawm kaw”, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesu ing a venawh, “Na Bawipa Khawsa ce koeh noek koeh dak tinawh qee na awm bai hy”, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Cekcoengawh, qaai ing anih ce cung ak sang soeih na van pyi nawh, khawmdek awhkaw qamkhqi boeih boeih ingkaw a mangnaak khqi boeih ce huh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","A venawh, “koep nawh kai ve nani beek awhtaw vawhkaw ik-oeihkhqi boeih ve ni pe kawng”, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesu ing a venawh, “Setan ak chang na cet, Bawipa na Khawsa doeng ce beek kawm tiksaw, anih a bi doeng ce bi tinawh qee na awm hy”, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Cekcoengawh qaai ing anih ce cehta hy, cawh khan ceityihkhqi ce law unawh anih ce khut a hlep uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Johan thawngim awh thla uhy, tice Jesu ing ang zaak awh Kalili ram benna ce hlat hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazareth khaw ce cehta nawh tuili keng Zebulun ingkaw Nophtali khawqi awh ak awm Kapernaum khaw na cet nawh cawh ce awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tawngha Isaiah ing anak khypyi oepchoeh: ");
INSERT INTO hltthb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zebulun ram ingkaw Naphtali ram tuili na cehnaak lam, Jordan long caqai, Gentelkhqi a Kalili; ");
INSERT INTO hltthb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","thannaak khuiawh ak ngawikhqi ing vangnaak ak bau soeih ce hu uhy; thihnaak hlip ak kaiawh ak ngawikhqi venawh vangnaak ce pha law hy”, tinawh anak khypyi ce a cupnaak aham ni. ");
INSERT INTO hltthb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Cawhkawng awh Jesu ing awi kqawn cyk hy, “Zut lah uh, kawtih khan ram taw zoe hawh hy,” tinawh kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesu ing Kalili tuili keng na a ceh awh cingna qawi thlang pakhih, Piter ami ti uh Simon ingkaw a naa Andrew, lawk ak khawng ce hu hy; cekqawi taw ngak hawikung na awm hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Cekkqawi a venawh “Ka hu awh bat lah nih, thlang ak tukung na ni sai qawi vang”, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Cekkqawi ing lawk ce cehta nih nawh ahu awh bat hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ce hyn awhkawng Jesu ce cet bai nawh, Zebdi a ca qawi Jacob ingkaw a naa Johan ce a nipa Zebedi mi lawng khuiawh lawk amik bu ce hu nawh khy hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Cekkqawi cingna ingawm ani pa ingkaw lawng ce cehta nih nawh, Jesu a hu awh ce bat pahoei hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesu ing Kalili ram khui boeih awh cet nawh, sinakawk awh thlangkhqi ce cawngpyi hy, ram awithang leek ce khypyi hy, sa amak dip thlangkhqi ingkaw tlohnat soepkep ak ta thlangkhqi ce qoei sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesu akawng ce Syria qam pum awh thang hy: tlohnatnaak soepkep ingkaw khuikhanaak soepkep ak hu thlangkhqi, sa amak dip thlangkhqi, thlakqawkhqi, ak kawk khuiawh qaai ak bekhqi, ak khawnkhqi boeih ce a venna law pyi unawh, anih ing cekkhqi ce qoei sak khqi boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","A hu awh Kalili, Dekapoli, Jerusalem, Judah qam ingkaw Jordan long caqai nakaw thlang khawzah bat uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Thlang kqeng ce a huh awh, tlang na kai nawh ngawi hy, cawh a hubatkhqi ce a venna law uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Cekcoengawh a hubatkhqi ce vemyihna cawngpyi khqi hy: ");
INSERT INTO hltthb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Kawlung ak khawdeng thlangkhqi taw ami zoseen hy, kawtih khan qam taw a mingmih a koe ni. ");
INSERT INTO hltthb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kawset ing ak kokhqi taw ami zoseen hy, kawtih a mingngaih qep kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kaw ak dungkhqi taw ami zoseen hy, kawtih khawmdek qo pang kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Dyngnaak ce buh a myihna cawi nawh tui a myihna ak hoetkhqi taw ami zoseen hy, kawtih amik phoen phyi kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Thlang qeenkhaw ak ngaikhqi taw ami zoseen hy, kawtih qeennaak ce hu lawt kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kawlung ak ciimkhqi taw ami zoseen hy, kawtih Khawsa ce hu kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Qoepnaak ak saikhqi taw ami zoseen hy, kawtih Khawsa cakhqi tinawh khy kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dyngnaak awh thekhanaak ak zawkkhqi taw ami zoseen hy, kawtih khawk khan taw a mingmih a koe ni. ");
INSERT INTO hltthb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Thlangkhqi ing kai ak camawh ni phep khqi uhy, ni thekha nak khqi uhy, amak thym na awihche soepkep ing ani zyih khqi awh ce nami zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ym u nawhtaw namik kawzeel sak uh, Ikawtih nangmih aham khawkkhan awh kutdo ak bau soeih awm hy, cemyihna ni nangmih nami awm hlan awhkaw tawnghakhqi awm a mina thekhanaak hawhy. ");
INSERT INTO hltthb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nangmih taw khawmdek ci na awm u hyk ti. Cehlai ci ing a paih hawh awhtaw ikawmyihna a alnaak voel kaw? khawng nawh thlang ngawh khaw ing leh aham doeng kaataw, kawna awm phu am ta voel hy. ");
INSERT INTO hltthb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nangmih taw khawmdek vangnaak na awm uhyk ti. Tlang awhkhaw ak awm taw ikaw ingawm am chungdah thai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Thlang ing mai a vang awh, dawn ing am myk nawh, maihvang ami taaknaak khawi awh ni ami taak, cawh ni ipkhui awhkaw ak awmkhqi boeih ce ak coei. ");
INSERT INTO hltthb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Cemih lawtna, nangmih a them leek sai ce thlang ing a huh awh khawkkhan nakaw ak awm nangmih a Pa ce ami kyihcahnaak thai kaw, nami vangnaak ce thlang amik huh awh vang lah seh. ");
INSERT INTO hltthb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Anaa awi aw am awh tawnghakhqik awi hqe aham kai ve law hy tinawh koeh poek uh; hqe aham am law nyng ak soep sak hamna ni ka law. ");
INSERT INTO hltthb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Awitak ka nik kqawn peek khqi, khawmdek ingkaw khan ang khum hlan dy, anaa awi awhkaw a dek pynoet ca awm, calung pynoet ca awm ik-oeih soepkep a cup hlan dy taw am qeng tikaw. ");
INSERT INTO hltthb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","A u ingawm vawhkaw awipeek ak zawi cakhqi ak khui awhkaw pynoet ce eek nawh thlak chang awm eek lawt aham am cuuk awhtaw anih ce khawkkhan awh ak zawi soeih na awm kaw, cehlai a u ingawm vemyihkhqi boeih ve hquut nawh thlak chang awm a cawngpyi awhtaw anih ce khawk khan awh ak bau soeih na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ka nik kqawn peek khqi, nangmih ama dyngnaak ing Farasikhqi ingkaw caqeekungkhqi a dyngnaak ce ama poe voelh awhtaw khawkkhan awh am lut thai ti kawp uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Syn awh, thlang koeh him, u awm thlang ak him taw awidengnaak kqih awm ce hu kaw,” tinawh ami nak kqawn ce za hawh u hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Cehlai, ka nik kqawn peek khqi, a u awm a koeinaaa ak khan awh kaw ak so taw awidengnaak ce hu kaw. A u awm a koeinaa ce “Thlak zoe” ak tinaak taw Sanhedrin awh awidengna awm kaw. A u awm thlang ce, 'thlak qaw!' ak tinaak taw hell mai kqih awm ce zawk kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Cedawngawh bawkthang awh ik-oeih pek aham nami law pyi awh na koeinaa ing nak khan awh ak kaw am law hy tice na sim awhtaw, ");
INSERT INTO hltthb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bawkthang a haiawh na themkhqi ce cehta nawh hlat cang. Na koeinaa ingqawi qoepnaak ce na sai coengawh cet nawhtaw na them ce pe kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Awidengnaak awh taza anik cawikung na qaal ingqawi lam nani ceh haih tloek awh ang tawnnna qoepnaak sai. Cemyih am awhtaw na qaal ing nang ce awidengnaak kung na a ni khyn coengawh awidengkung ing nang ce boei a venawh ni pe patoe kaw, anih ing nang ce thawngim na nik thla kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Awitak ka nik kqawn peek khqi, laiba a boeih dy na sah hlan khui taw thawngim awhkawng am loet kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Na samphaih aham am awm hy”, tinawh amik kqawn awi ce za hawh uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Cehlai, ka nik kqawn peek khqi, u ingawm nu pynoet ce hyynaak mik ing a toek awhtaw, ak kawlung khuiawh cawhkaw nu ak khan awh ce samphaih hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nak tang mik ing a ni thawlh sak awhtaw, koeih nawh khawng; na pum boeih ing hell khuina nang tlaak anglakawh na pum awh ik-oeih pynoet na taal ce nep bet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nak tangkut ing a ni thawlh sak awhtaw tlyk boet nawh khawng. Na pum awhkaw ik-oeih pynoet na taal ce nep bet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“U ingawm a zu ce a ma awhtaw, zu manaak ca ce pe seh” tinawh amik kqawn awi ce a na awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Cehlai ka nik kqawn peek khqi, a va ak khan awh a thawlh awh ti kaana, u ingawm a zu ce a ma awhtaw a zu ce samphaih sak hy, cekcoengawh u ingawm thlang a zu ma ak zu naak taw samphaih na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Cekcoeng bai awh, 'nak awisa ce koeh hqe, Bawipa venawh nak awisa ce cup sak lah', tinawh syn awh ami nak kqawn awm za hawh u hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Cehlai, ka nik kqawn peek khqi, awi koeh sa qoe qoe uh: khawkkhan phoei nawh awi koeh sa, kawtih khawkkhan taw Khawsa a ngawihdoelh ni; ");
INSERT INTO hltthb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","khawmdek awm phoei unawh awi koeh sa uh, kawtih khawmdek awm a khaw a soengnaak ni; Jerusalem awm phoei unawh awi koeh sa uh, kawtih Jerusalem taw sangpahrang boei a khawk bau ni. ");
INSERT INTO hltthb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nami lu phoei unawh awi koeh sa uh, kawtih na lu awhkaw na lumsam pynoet ca awm am baawk, am lee sak thai hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ak thym ce 'thym hy' ti unawh taw amak thym ce 'am thym hy' ti mai uh; ve ak khan awh awi ak law bai taw them amak leek hawh ni. ");
INSERT INTO hltthb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","'Mik ang zyng awh mik, haa ang zyng awh haa', tinawh awi amik nak kqawn awm za hawh u hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Cehlai ka nik kqawn peek khqi, thlakche ce koeh oelh uh. Nak tang ben na beeng awh thlang ing anik beih awhtaw ak chang ben na beeng ce awm dun pe. ");
INSERT INTO hltthb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Thlang ing na angki ce lawh aham a ngaih a dawngawh awi a ni oelh awhtaw, hi awm peek sih mai. ");
INSERT INTO hltthb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Thlang ing meng oet a ni qyt ngah ngah awhtaw meng hih dy awh thak. ");
INSERT INTO hltthb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Thlang ing ik-oeih a thoeh awhtaw pe mai, na venawh ik-oeih pu aham ak law ce koeh hawi taak. ");
INSERT INTO hltthb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Na imceng ce lungna nawhtaw na qaal cetaw sawh na,” tinawh qee hyt awi ak awm ce zahawh u hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Cehlai ka nik kqawn peek khqi, nami qaal ce lung law na uh, nangmih awihche ing anik zyi thlangkhqi ce zoseenaak pe law uh; nangmih anik sawhnaakkhqi aham them leek sai law pe uh, ");
INSERT INTO hltthb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","cawh ni khawk khan awh ak awm nangmih a Pa a cakhqi na nami awm hly. Anih ingtaw thlakche ingkaw thlakleek ak khan awh khaw ang myih na law sak nawh, thlakdyng ingkaw thlakthawlh ak khan awh awm khaw ang myih na aa sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nangmih anik lungnaakkhqi doeng nami lungnaak mantaw ikaw kutdo nu nami huh kaw? Mangmu ak cawikhqi ingza cemyihce am sai lawt uhy na ti nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na koeinaa doeng na ym mantaw, thlak chang anglakawh na leeknaak bet ikaw a awm? Lukih thlangkhqi ingza cemyih ce am sai uhy na ti nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Khawkkhan nakaw ak awm nangmih a Pa a soep lawt a myihna nangmih awm soep lawt lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Thlang ing a huhnaak aham, 'them leek sainaak' thlang a haiawh am nami sainaak aham ngaihta lah uh. Cemyihna nami sai mantaw, khawk khan na ak awm nangmih a Pa ven nakaw kutdo am hu kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cedawngawh ak voet ak hlauh thlangkhqi ik-oeih na dodan awh thlang am kyihcah ngaih awh qaai kqawnkhqi ing sinakawk ingkaw lam suttungkhqi awh a mi sai amyihna uut yng nawh koeh kqawn qu uh. Awitak ka nik kqawn peek khqi, kutdo ce a mimah ing boet nawn hawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Cehlai, nangmih ingtaw thlang ik-oeih nami dodan awh nak tangkut ing a sai ce nak cawng ben kut ing koeh sim seh, ");
INSERT INTO hltthb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","cawh ni na kutdo ce ang hyp na a awm hly. Cawh ni ang hyp ik-oeih sai ak hukung nangmih a Pa ing samphang na kutdo ce a ni peek hly khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Na mik cykcah awh, thlak qaai kqawnkhqi amyihna koeh cykcah uh; a mingmih ingtaw thlang ing ni huh na seh a mi ti awh, sinakawk ingkaw lam suttungkhqi awh dyi unawh, amik cykcah ce lungna uhy. Awitak ka nik kqawn peek khqi, a mimah ing kutdo ce boet nawn hawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Cehlai, nangmih taw na mik cykcah awh nami ipkhui na lut unawh, chawh nami khaih coengawh, anghyp na ak awm nami Pa a venawh cykcah uh. Cawh ni ang hyp ik-oeih sai ak hukung nangmih a Pa ing samphang awh kutdo ce ni pek khqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Na mik cykcah awh lawkihkhqi cykcah amyihna awi koeh nawlh tlaih tlaih uh, a mingmih ingtaw awi khawzah nik kqawn awh ni ang zaak hly tinawh poek uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Cekkhqi amyihna koeh awm uh, kawtih nangmih ing nami thoeh hlanawh nami ngaih ik-oeihkhqi ce nami Pa ing sim oepchoeh hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Cedawngawh vemyihna cykcah uh; Khawkkhan nakaw ak awm kaimih a Pa, nang ming kqihchahnaak awm seh, ");
INSERT INTO hltthb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na qam pha law seh, Khawkkhan awh nak kawngaih sai amyihna khawmdek awh nak kawngaihnaak saina awm seh. ");
INSERT INTO hltthb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tuhngawi awh myngawi buh ni pek khqi lah. ");
INSERT INTO hltthb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ik-oeih ak pukhqik khan awh qeenkhaw ka ming ngai amyihna, kaimih a ik-oeih pu ak khan awh qeenkhaw ngai law lah. ");
INSERT INTO hltthb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sykzoeknaak awh koeh ni sawi khqi nawh, thlakchekhqi anglakawhkawng ni hul khqi lah” ");
INSERT INTO hltthb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Thlang ing nangmih ak khan awh ik-oeih a sai palh awh qeenkhaw na ming ngai awhtaw, khawk khan nakaw ak awm nangmih a Pa ingawm nangmih ak khan awh qeenkhaw ngai law lawt kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Cehlai, thlang a thawlhnaak ak khan awh qeenkhaw amna ming ngaih awhtaw, nangmih a Pa ingawm nangmih ak khan awh qeenkhaw am ngai tikaw. ");
INSERT INTO hltthb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Buh nami zeih awh, thlak qaaikqawnkhqi amyihna kawset myi koeh dang sak uh, cekkhqi ingtaw thlang ing buh zeih hy tina seh, ti unawh thlang a mik huh awh ami haai ce a muqu na ta uhy. Awitak ka nik kqawn peek khqi, a mi kutdo hly ce hu boeih hawh u hyk tice. ");
INSERT INTO hltthb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Cehlai nangmih ingtaw buh nami zeih awh nami lusam thiik unawh, nami haai hla uh, ");
INSERT INTO hltthb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","thlanghqing a venawh buh zeih hy tice ang dang naak aham am nawh, mik huh am awh ak awm nami Pa venawh ni buh na zeih, tice ang dang naak aham ni; cawh ni ang hyp ik-oeih sai ak hukung nami Pa ing kutdo a ni peek hly khqi. ");
INSERT INTO hltthb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Laihqa ingkaw thieek ing ama ainaak thai, quk-aikhqi ing muk nawh a mam quuknaak thai, ve khawmdek awh nami them koeh cun law uh. ");
INSERT INTO hltthb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Laihqa ingkaw thieek ing ama ainaak thai, khawk khan na nami them ce cun law lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ikawtih nami them a awmnaak awh na mik kawlung awm awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mik taw pum a maivang na awm hy. Na mik a leek awhtaw, na pum ce vang boeih kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Cehlai na mik ama leek mantaw, na pum boeih boeih ce than kaw. Na pum awhkaw vangnaak ce a than mai mantaw, ikawpna na pum boeih ce a thannaak kaw! ");
INSERT INTO hltthb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","U ingawm boei pakkhih a bi ce am kqep thai hy. Pynoet ce sawh na kawmsaw pynoet taw lungna kaw, am awhtaw pynoet ce kqihchah na nawh pynoet taw husit kaw. Cemyih lawt na Khawsa ingkaw tangka bi am kqep thai hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Cedawngawh ka nik kqawn peek khqi, kawnu ka ai nawh kawnu ka aawk kaw, tinawh nami hqingnaak aham koeh ly unawh; kawnu ka bai ka naak lah kaw, tinawh nami pum aham awm koeh ly uh. Aawk-ai anglakawh hqingnaak, suibai anglakawh pum ve awihtung bet am nu? ");
INSERT INTO hltthb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Khan nakaw phakhqi ce toek lah uh; quk am saw uhy, caang awm am aat unawh, teep ak khui awh awm am thla uhy, cehlai khawk khan nakaw ak awm nangmih a Pa ing cekkhqi ce hqin hy. Cekkhqi anglakawh nangmih ve nami phu am tlo khqoet nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nangmih ak khuiawh u ingawm a mawnnaak ak caming a hqingnaak khawnoek pynoet ca ing awm a sap bet thai? ");
INSERT INTO hltthb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ikawtih nami pum dahnaak awh nami ly? Lo awhkaw lili khqaipai ce toek lah uh. Bi am bi unawh, hla awm am bi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Cehlai ka nik kqawn peek khqi, vawhkaw lili khqaipai amyihna, Solomon ing a boeimangnaak boeih ing thoeihcam na am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ceamyihna lo awhkaw khuut, tuh-ngawi awh hqing thai moe a ngawi awhtaw qeu nawh mai awh phum aham ak awm za Khawsa ing ak chungdah awhtaw, Aw cangnaak ak zawikhqi, nangmih ak khqoet taw khawzah khqoet na am nik chungdah hlyk khqi nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Cedawngawh kawnu ka ai kaw? am awhtaw kawnu ka aawk kaw? Am awhtaw kawnu ka bai ka naak kaw? tinawh koeh ly uh. ");
INSERT INTO hltthb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Lawkih thlangkhqi ing ni ve myihkhqi ve a mi sui hy, vemyih ik-oeihkhqi ve ngoe u hyk ti tice khawk khan nakaw nangmih a Pa ing sim hy. ");
INSERT INTO hltthb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","A qam ingkaw a dyngnaak ce sui lamma lah uh, cekcoengawh vawhkaw ik-oeihkhqi boeih ve awm ni peek sih khqi bit kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Cedawngawh khawngawi awhkaw aham koeh ly uh, khawngawi ing amah aham ik-oeih ce poek lawt bit kaw. Hypoet aham hypoet awhkaw kyinaak ce khoek hy. ");
INSERT INTO hltthb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Thlang awi koeh deng, namah awm awideng na awm lawt kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kawtih thlang awi na deng myihna nang awm awi dengnaak hu lawt kawp ti, thlang nyhtahnaak ing nang awm nyhtah na awm lawt kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Namah a mik awhkaw myn ak awm ce ak poek kaana, ikaw hamna na koeinaa a mik awhkaw myn veteh ca ak awm ce na toek? ");
INSERT INTO hltthb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Namah a mik awhkaw myn a awm hyn awh, ikawmyihna na koeinaa a venawh, 'na mik awhkaw myn a dik ve tehca ce lo law vang nyng', na ti naak? ");
INSERT INTO hltthb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nang thlang qaai kqawn, namik awhkaw myn ce khoe cang, cawh ni na mik ce ak caih na dang nawh, na koeinaa a mik awhkaw myn tehca ce na lawh hly thai. ");
INSERT INTO hltthb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ak caih ik-oeihkhqi ce ui koeh pe uh; na pale lung awm vawkkhqi haiawh koeh khawng uh. Nak khawng mantaw a khaw ing a leh coengawh namah awm ning hawi sih nawh ni cui khup phlet kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Thoeh lah ni pe kaw; sui lah hu kawp ti; khoeng lah nim awng kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","U awm ak thoeh ingtaw hu nawh; ak khoeng taw awng peek na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Na ca ing phaihpi a thoeh awh lung ak pe nangmih ak khuiawh na mik awm nu? ");
INSERT INTO hltthb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nga a thoeh awh khqui ak pe hly na mik awm nu? ");
INSERT INTO hltthb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nangmih thlak thawlh khqi ing za nami cakhqi ik-oeih leek peek aham nami sim awhtaw, khawk khan na ak awm nangmih a Pa ing ak thoehkhqi venawh ik-oeih leek izah ak doem nu a peek khqoet kaw? ");
INSERT INTO hltthb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Thlang ing nak khan awh ik-oeih leek sai sak aham na ngaih lawt a myihna, thlang ak khan awh ik-oeih leek sai lawt lah, ve ing anaa awi ingkaw tawnghakhqik awi ce cun boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Chawmkeng ak ceek ca khuiawh lut lah uh; kawtih chawmkeng kau nawh lam ak kau taw seetnaak benna ak sawikung ni, ce benna ce thlang khawzah cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Cehlai chawmkeng ceek nawh lam ak ceek cetaw hqingnaak benna ak sawikung na awm nawh, ce ben ce thlang a khoeh ca doeng ing hu hy. ");
INSERT INTO hltthb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tawngha qaaikqawnkhqi ce qalqiing uh. Ak khan awh tuvyn bai hlai uhy, ak khuina taw thailatnaak ing ak be ngentang na awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","A mingmih ce ak thaih awh hat bit kawm uk ti. U ing nu hling a thing awhkawng misur ak thaih bit khawi nawh, hling dum khui awhkawng thaih qah ak bih khawi? ");
INSERT INTO hltthb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Thing ak leek awh-kawng thaih leek qah nawh, thing ak che awh-kawng ak thaih che qah lawt hy. ");
INSERT INTO hltthb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Thing ak leek awhkawng thaih ak che am qah nawh, thing ak che awhkawng thaih leek am qah bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Thaih leek amak qah thing taw hlu unawh mai awh phum uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ce myihna ak thaih awhkawng a mingmih ce hat thai bit kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ka venawh Bawipa, Bawipa ak ti boeih ing khawk khan am pha kaw, cehlai khawk khan na ak awm ka Pa ak kawngaih ak saikhqi doeng ing ni a pha hly. ");
INSERT INTO hltthb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ce a khawnyn awhtaw thlang khawzah ing ka venawh, Bawipa, Bawipa nang ming ing awi kqawn unyng saw, nang ming ing qaaikhqi hqek unyng, kawpoek kyi ik-oeihkhqi am ka mi sai nawh nu? ti kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Cawh kai ing cekkhqi venawh, 'Am ni sim khqi nyng. Thawlhnaak ak saikhqi, ka ven awhkawng ak chang na cet uh!' tinak khqi kawng. ");
INSERT INTO hltthb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Cedawngawh u ingawm vawhkaw kak awih kqawnkhqi ve za nawh a sai awhtaw anih taw lungnu awhkaw im ak sa thlakcyi ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Khaw tlan nawh, tuinu tho, khaw hli nawh im ce buuk seiawm; lungnu awh tung ce ang ling a dawngawh, am tlu hy. ");
INSERT INTO hltthb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Cehlai u ingawm vawhkaw kak awih kqawnkhqi ve za hlai hy amak sai thlang taw dizui awh im ak sa thlakhqaw ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Khaw aa, tuinu tho nawh khawhli ing im ce a buuk awh, tlu qup hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesu ing ve ak awikhqi ak kqawn boeih coengawh, a cawngpyinaak awh ce thlang kqeng ing amik kawpoek kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Caqeekung khqi a cawngpyinaak amyihna am cawngpyi nawh, saithainaak ak ta thlang ing a cawngpyi amyihna anih ingtaw cawngpyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tlang awhkawng ak kqum awh, thlang kqeng khawzah ing a hu awh hquut uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Cawh mynqaai ak tlo thlang pynoet law nawh a haiawh khuk sym doena, “Bawipa, na ngaih awhtaw ni qoei sak thai hyk ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesu ing a kut a zyng coengawh anih ce bi hy. “Ngaih nyng, ciimcaih hlah!” tina hy. Kawlhkalh awh a mynqaai ce qoei tlang hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Cawh Jesu ing a venawh, “U a venna awm koeh kqawn moe, ami simnaak aham cet nawh khawsoeih a venawh na pum ce nam huh coengawh, Mosi ak awipeeknaak a myihna ik-oeih nawnnaak ce sai,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesu ing Kapernaum khawk khui na a lut awh, qaal boei pynoet ce a venna law nawh, qeennaak thoeh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Bawipa, ka tyihzawih khawn nawh im awh zaih hy, a tlawh nauh hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesu ing, “Law nawh qoei sak bit kawng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Qaal boei ing a venawh, “Bawipa ka im awh law aham am tyng nyng. Awi doengmah kqawn nawhtaw, ka tyihzawih ce qoei bit kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kai awm uknaak ak kai awh awm lawt nyng. Cedawngawh pynoet na ce, 'Ceh,' ka tinaak awh cet nawh, thlang chang awm, 'Law,' ka tinaak awh law hy; ka tamnaa awm, 'Ve sai ka tinaak awh,' ka ti awh sai lawt hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Cek awi ce Jesu ing ang zaak awh, ak kawpoek kyi nawh, ahu awh ak bangkhqi venawh, “Awitak ka nik kqawn peek khqi, Israel khqing lak awh vemyihna cangnaak ak bau am hu nyng. ");
INSERT INTO hltthb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ka nik kqawn peek khqi, khaw law khaw tlak ben nakawng thlang khawzah law kawm usaw, Abraham, Isak, Jacob mi khawk khan awh buh poei kung awh kutoet na ngawi haih kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Cehlai ram cakhqi taw kqangnaak ingkaw hatahnaak a awmnaak, a leng ben khawmthannaak awh khawng kawm uh,” tina khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Cekcoengawh Jesu ing qaal boei a venawh, “Cet hlah! nak cangnaak amyihna na venawh saina awm seh,” tina hy. Ce a tym qoe awh ce a tyihzawih awm qoei tlang hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Piter a im na Jesu a ceh awh, Piter a senu ce a sa tlo nawh zaih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesu ing anih ce a kut awh tu hy, cawh anih ce a satlawh ing hlah pahoei hy, tho nawh a mingmih ce do a dan hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Khawmy benawh ak kawk khuiawh qaai ak bekhqi ce law pyi uhy, anih ing qaaikhqi ce hqek nawh thlak tlokhqi boeih ce qoei sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tawngha Isaiah ing: “Amah ing ningnih tha amak awmkhqi ce lo law nawh, ningnih a tlawhnatnaakkhqi ce phyi law hy,” tinawh ak kqawn ce a cupnaak aham na ni. ");
INSERT INTO hltthb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","A ven awhkaw thlang kqeng ce Jesu ing a huh awh, tuili caqai sa benna ceh aham awi pehy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Cawh anaa awi cawngpyikung thlang pynoet ce a venawh law nawh, “Cawngpyikung na cehnaak hoei awh bat lawt vang nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu ing a venawh, “Ngentangkhqi ingawm ak khuikawk ta unawh, khan nakaw phakhqi ingawm bu ta uhy, cehlai thlanghqing Capa ingtaw a lutloengnaak awm am tahy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ahu awh ak bat thlak chang pynoet ing, “Bawipa cet nyngsaw ka pa pup cang vang nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Cehlai Jesu ing a venawh, “Ka hu awh bat law mai, thlak thi ce thlak thi lawt ing pup mai seh,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Cekcoengawh lawng khuina ce lut nawh a hubatkhqi awm lut pahoei lawt uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Cawh poek kaana khawhli khungdeng nawh tuibak ing lawng ce kup phlet hlo hlo hy. Cehlai Jesu taw ip dut dut hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","A hubatkhqi ing thawh unawh, “Bawipa ni hul khqi lah! Tui awh cum hawh kawng u nyng! tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A mingmih a venawh, “Cangnaak ak zawikhqi, kawtih namik kqih?” tinak khqi hy. Cekcoengawh tho nawh khawhli ingkaw tuiphu ce zyi saw, cawhtaw khawhli ingkaw tuiphu ce dym pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Cekkhqi ce amik kawpoek kyi nawh, “Kawmih ak thlang hy voei nu ve? khawhli ingkaw tuiphu ingawm ak awi ngai pe uhy! ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tui caqai ben awh ak awm Gadarin qam ce a pha awh, ak kawk khuiawh qaai ak be thlang pak khih ce phyi awhkawng a venna law hy nih. Cekkqawi ce a ni tlung soeih a dawngawh ce a lam awh u awm am cet thai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Cekkqawi ing anik khy doena, “Khawsa Capa kainih ve ikaw ni ti nak kqawi vang na ti? A tym a khoek hlanawh kainih khuikha sak aham na law nawh nu? tina hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Cekkhqi ami awmnaak hyn awhkawng a hlanaak bet awh ce vawk khawzah cah uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Qaaikhqi ing a venawh, “kaimih ve nani hqek khqi awhtaw vawkkhqi ak kawk khuiawh ni ceh sak khqi mai,” tinawh qeennaak thoeh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesu ing cekkhqi venawh, “Cet uh!” tina hy. Cedawngawh cekkhqi ce cawn unawh vawkkhqi ak kawk khuina lut uhy, cawh vawkkhqi boeih ce tuili na hqang awhkawng cawn unawh thi boeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Vawk ak khoem thlangkhqi ce khawk khuina dawng unawh cawhkaw ik-oeih ami huhkhqi ingkaw ak kawk khuiawh qaai ak be thlang pakkhih akawng ce thlangkhqi venna kqawn pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Cawh khawk khui awhkaw thlangkhqi boeih ce Jesu huh aham cet uhy. Jesu ce ami huh awh, ce a qam ce cehtaak aham a venawh qeennaak thoeh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesu ing lawng ak khuina a lut coengawh, tui ce kat nawh amah a khaw nace cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Cawh ak khawn thlak tlo pynoet hiphaih awh kawt law uhy. Jesu ing a mingmih ak cangnaak ce a huh awh, ak khawn thlang a venawh, “Ka capa, nang ngaih qep sak, na thawlhnaakkhqi boeih ak khan awh qeenkhaw ngai na awm hawh hy, “tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Cawh anaa awi ak qeekung thlang vang ing amik kawk khuiawh, “Ve ak thlang ing Khawsa thekha na hy ve!” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Cekkhqi ak kawpoek ce Jesu ing sim nawh, “kawtih namik kawlung khuiawh kawpoek amak leek namik poek? ");
INSERT INTO hltthb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Hannu ak zoe bet: 'na thawlhnaakkhqi boeih ak khanawh qeenkhaw ngai na awm hawh hy ti,' tive nu? ");
INSERT INTO hltthb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Cehlai thlanghqing capa ing thawlhnaakkhqi ak khan awh qeenkhaw ngainaak tahy tice nami sim thainaak aham, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Cawh anih ce tho nawh a im na cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Thlang kqeng ing cawhkaw ik-oeih ce ami huh awh amik kawpoek kyi nawh; thlanghqing a venawh vemyihna saithainaak ak pekung Khawsa ce kyihcah uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ce a hyn awhkawng Jesu taw cet phaat nawh, mangmu cawinaak hyn awh ak ngawi, Mathai ak mingnaak thlang pynoet ce hu hy. A venawh, “Ka hu awh bat law,” tina hy. Anih ce tho nawh ahu awh bat pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mathai a im awh Jesu ing buh a ai awh, mangmu ak cawi thlangkhqi ingkaw thlak thawlhkhqi khawzah ce law unawh a venawh a hubatkhqi mi kutoet na buh veel haih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farasikhqi ing ami huh awh, a hubatkhqi venawh, “Kawtih nangmih a cawngpyikung ing mangmu ak cawikhqi, thlak thawlhkhqi mi buh kutoet na ami ai?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ce ak awi ce Jesu ing ang zaak awh, “Sakdip ing Siboei am ngoe nawh, thlak tlo ing ni siboei a ngoe hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cehlai cet unawh, bulnaak kaana qeennaak ni ka ngaih, ti awi ve cawng law lah uh. Kawtih thlak dyng khy aham am law nyng, thlak thawlh khy aham nani ka law” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Cawh Johan a hubatkhqi ce a venawh law unawh, “Kawmyihna kaimih ingkaw Farasikhqi ingtaw buh zeih u nyngsaw, nang a hubatkhqi ingtaw buh a mami zeih?” ");
INSERT INTO hltthb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesu ing a mingmih a venawh, “Zuk lokung a awm khui awhtaw, zulawh ak ym pyikungkhqi ce amik kaw ak se hly nu? Cehlai cekkhqi ven awhkawng zuk lokung ak chang na ceh pyinaak khawnghyp ce pha law kaw, cawh ce zeih dam bit kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","U ingawm angki khqym ce ak thai ing am bu khawi hy, ak bunaak mai mantaw hi ak thai ing ak khqym ce dawk kawmsaw sek khqoet kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Cemyih lawtna, u ingawm misur tui ak thai ce cikthlyng khqym awh am thun khawi hy. A thun mai mantaw, cikthlyng ce paawk kawmsaw misur tui ce zuut kaw, cikthlyng awm see pahoei kaw. Cedawngawh misur tui ak thai taw cikthlyng thai awh thun uhy, cawhtaw pakkhih bawk na ciimcaih hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ve myihna awi ak kqawn huiawh, ukkung thlang pynoet ce a venna law nawh a haiawh khuk sym doena, “Ka canu tuhca phoeih awh thi hy. Cehlai law nawhtaw ak khan awh na kut tloeng pe cang lah, cawhtaw hqing tlaih kaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesu ing tho nawh anih a hu awh cet pahoei hy, a hubatkhqi awm bat lawt uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Cawh ce kum hqa hlai hih a thi ak tla nu pynoet ce a hu awh law nawh Jesu a hihawi ce bi pe hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“A hi mah ka bi mantaw qoei ngai voei nyng,” tinawh poek hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesu ing hawi ket nawh nu ce toek hy. “Ka canu, nang ngaih qep sak hlah, nak cangnaak ing ni qoei sak hawh hy,” tina hy. Cawh nu ce qoei pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ukkung a ipkhui na Jesu ing a lut awh khqung ak tumkhqi ingkaw halum habee na ak awm thlang kqeng ce hu hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","A mingmih a venawh, “Thoeih lah uh. Nuca ve am thi hy, ak ip ni,” tina hy. Cehlai cekkhqi ing qaih na uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Thlang kqeng ce a leng na a ceh sak coengawh, ak khuina lut nawh nuca ce a kut awh tu hy, cawh nu ca ce tho hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Cawhkaw awithang ce rampum awh thang khawnghak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ce a hyn awhkawng Jesu ce ak chang na a ceh awh, mikhyp thlang pakkhih ing, “David capa, kainih ve nim qeen lah,” tinawh khy doena a hu awh hquut hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ipkhui na a lut awh, mikhyp qawi ce a venawh law nih nawh, Jesu ing cekqawi a venawh, “Kai ing ve ve sai thai kawng, tinawh nanik cangnaak aw?” tina hy. Cekkqawi ing, “Oeih, Bawipa,” tina hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Cawh cekqawi a mik ce bi penawh, “Na nik cangnaak a myihna na nik khan awh awm seh nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Cawh a ni mik ce dang pe qawi pahoei hy. Jesu ing, “U a venawh awm koeh kqawn qoe qoe nih moe,” tinawh yn qawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Cehlai cekqawi ing cet nih nawh anih akawng qam pum awh kqawn khawnghak hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","A khoeh a va ceh awh, ak kawk khuiawh qaai be nawh awi amak pau thai thlang pynoet ce Jesu a venna law pyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ak kawk khui awhkaw qaai ce Jesu ing a hqek peek coeng awhtaw, ce ak thlang ce awi pau thai tlaih hy. Cawhkaw ak awm thlang kqeng ce amik kawpoek kyi nawh, “Israel ram khuiawh ve mih ve am awm man hy,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Cehlai Farasikhqi ing, “Qaaikhqi boei ak caming ni qaaikhqi a hqek hy,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Khawk bau ingkaw vangcakhqi awh Jesu ing cet nawh Sinakawk awh thlangkhqi ce cawngpyi hy, ram awithang leek ce ak kqawn coengawh, tlawhnaak soepkep ingkaw sa amak dip thlangkhqi ce qoei sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Thlang kqeng ce a huh awh, khoemkung amak awm, amah a ngaih ngaih na ak plam, tha amak awm tuukhqi myihna a mi awm a dawngawh qeen khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Cawh ve ak awi ve a hubatkhqi venawh, “Cang ah aham khawzah awm hlai hy, bibikung zawi ca hy. ");
INSERT INTO hltthb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Cedawngawh lo ak takung ing cang ak aat aham bibikung khawzah a lo khuiawh a tyihnaak aham thoeh lah uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","A venawh thlanghqa hlai hih tloek ce khy nawh qaih chekhqi hqek thainaak ingkaw tlawhnat soepkep qoei sak thainaak ce pehy. ");
INSERT INTO hltthb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ceityih thlanghqa hlaihih tloek ang mingkhqi taw; Lamma cyk awh, (Piter tinawh amik khy) Simon ingkaw ana Andrew; Zebedi a caqawi Jakop ingkaw ana Johan; ");
INSERT INTO hltthb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip ingkaw Batholomu; Thomas ingkaw mangmu ak cawi Mathai; Alfai capa Jakob ingkaw Thaddai, ");
INSERT INTO hltthb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Zealot ami ti Simon ingkaw amah thlang a kut awh ak pekung Judah Isakariot vetloek ve khy hy. ");
INSERT INTO hltthb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Vawhkaw thlanghqa hlaihih tloek ve Jesu ing tyi nawh vemyihna yn khqi hy: Gentelkhqi venawh koeh cet unawh Samaria khaw khuiawh awm koeh lut uh. ");
INSERT INTO hltthb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tuu ak qeeng Isarelkhqi venawh cet uh. ");
INSERT INTO hltthb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nami ceh awh, khawkkhan taw zoe hawh hy, tinawh kqawn uh. ");
INSERT INTO hltthb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Thlak tlokhqi qoei sak uh, thlak thikhqi thawh uh, mynqaaikhqi caih sak uh. A zoe na nami huh ce, a zoe na pe lawt uh. ");
INSERT INTO hltthb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Sui awm tangka awm am awhtaw qawhum awm cawi zennaak awh koeh khyn uh; ");
INSERT INTO hltthb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Khin cehnaak aham sawngsa, angki pakkhih, khawmyk ingkaw sawnghqawl awm koeh khyn uh; kawtih bi ak bi ingtaw amah ang khuut qunaak ce huh aham tyng hy. ");
INSERT INTO hltthb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Khawk bau awh am awhtaw vangca awh aw nami kunnaak hoei awh, nami pahnaak aham ak tyng im ce sui unawh cawh ce pah uh, ak chang na nami ceh hlan khui awhtaw cawh ce awm poe uh. ");
INSERT INTO hltthb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ipkhui pynoet oet awh nami lut awh ce, awih leek ing voem law uh. ");
INSERT INTO hltthb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ce a im awh ngaihqepnaak a awm aham a tyng awhtaw ngaihqepnaak ce pe law uh; cehlai ama tyng awhtaw ngaihqepnaak ce lat tlaih uh. ");
INSERT INTO hltthb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","U ingawm amni ym unawh namik awi awm ama ming ngai awhtaw, cawhkaw im am awhtaw ce a khaw ce nami cehtaak awh, thlak thawlh na awm unawh awidengnaak a mi huh aham awm hy tice huhsaknaak aham nami khaw awhkaw dekpli ce khqoek sih uh. ");
INSERT INTO hltthb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Awitak kak nik kqawn peek khqi, awidengnaak nyn awh Sodom ingkaw Gamorah khaw taw ce a khaw anglakawh ana boe bet kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ngentangkhqi anglakawh tuu myihna ni tyi khqi nyng. Cedawngawh khqui a myihna nami cyih ta unawh khqukkhqu a myihna awm moel moel uh. ");
INSERT INTO hltthb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Thlang awh ce naming ngaih ta uh; awidengnaak kung awh ni khyn khqi kawm usaw Sinakawk khqi awh ni vyk khqi kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kai a simpyikung na a mingmih ingkaw Gentelkhqi venawh ami awm naak thai aham qam ukkungkhqi ingkaw sangpahqang khqi venawh nangmih ce ni sawi khqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Cehlai nangmih ce a mim tu khqi awh, kawk awi nu kqawn nawh ikawmyihna kak kqawnnaak kaw, tice koeh mawn uh. Namik kqawn hly kawi ce amah cawh qoe awh ni pek khqi bit kaw, ");
INSERT INTO hltthb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","kawtih nangmih ing am kqawn kawm u tiksaw, nangmih a Pa ang Myihla ing ni nangmih awhkawng ak kqawn hly. ");
INSERT INTO hltthb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Koeinaa ing a koeinaa, ami pakhqi ing a cakhqi thih sak aham thlang a kut awh pe kawm uh; cakhqi ing nu a pakhqi qaal na kawm usaw thih sak aham thlang a kut awh pe kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kai a dawngawh thlang boeih ing ni sawh nak khqi kaw, cehlai a dytnak dy ak yh ak thlang taw hul na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Hun pynoet awh a ni thekhanaak khqi awhtaw ak chang na centa patoe uh. Awitak ka nik kqawn peek khqi, thlanghqing Capa a law hlanawh Isarel khawk baukhqi am hqil boeih kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ak cawngkung ing cawngpyikung ak khan awh am awm hy, tyihzoeih awm a boei ak khan awh am awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ak cawngkung ing cawngpyikung myihna, tyihzoeih ing a boei myihna a awm ce khoek hy. Im ak takung za Belzabub tinawh amik khy awhtaw, a cakawkhqi khqoet ikawmyihna amik khy paikaw! ");
INSERT INTO hltthb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Cedawngawh cekkhqi ve koeh kqih uh. Kawtih ikaw awm a mang dang naak aham dah khoep ingkaw ama sim naak aham thuh thai am awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Than awh ka nik kqawn peek khqi ve dai awh kqawn lah uh; nami haakung awh ang hyp na ka nik kqawn peek khqi ve, iptih nakawng kqawn uh. ");
INSERT INTO hltthb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Pum taw him thai hlai uhy, Myihla amak him thai khqi ce koeh kqih uh. Cehlai Myihla ingkaw pum pakkhih na hell khuina ak qeeng sak thai ce kqih khqoet lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Hqitca pakkhih ce qawhum tangka pekhat na zawi unawh nu? Cehlai khawk khan awhkaw nangmih a Pa kawngaih am awhtaw pynoet ca awm dek na am tla hy. ");
INSERT INTO hltthb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nangmih a lu awhkaw lusam awm noet boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Cedawngawh koeh kqih uh; nangmihtaw hqitca anglakawh nami phu tlo khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Thlang a haiawh kai anik dyih pyi taw khawk khan na ka Pa haiawh dyih pyi lawt kawng. ");
INSERT INTO hltthb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Cehlai u awm thlang a haiawh anik qoeng taw, khawk khan na ka Pa haiawh qoeng lawt kawng. ");
INSERT INTO hltthb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Khawmdek awh qoepnaak awm sak aham kai ve law hy, tinawh koeh poek uh. Qoepnaak am haw law nyng saw, cimca ni ka haw law. ");
INSERT INTO hltthb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kawtih kai a dawngawh “thlang ing a pa ce qaal nakaw, canu ing a nu ce qaal na nawh, langa ing a ci ce qaal nakaw- ");
INSERT INTO hltthb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","a ipkhui nawn awhkaw thlang ce amah a qaal na awm sak aham nani,” ka law. ");
INSERT INTO hltthb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","U awm kai anglakawh a pa aw a nu aw ak lungnaak ak thlang taw kai ak thlang na am kawih hy; u awm a canu aw a capa aw kai anglakawh ak lungnaak thlang taw kai ak thlang na am kawih hy; ");
INSERT INTO hltthb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","u awm amah a thinglam kawh doena kai a hu awh amak bat ak thlang taw kai ak thlang na am kawih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","U awm a hqingnaak ak hul ak thlang taw a hqingnaak ce hlawng kawmsaw, u awm kai a dawngawh a hqingnaak ce ak hlawng ak thlang ingtaw hu kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","”Nangmih anik do thlang taw kai a nik do thlang na awm nawh, kai anik do thlang taw kai anik tyikung ak do thlang na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","U awm tawngha ce tawngha na a awm dawngawh ak do thlang taw tawngha a kutdo hu kaw. U awm thlak dyng ce thlak dyng na a awm dawngawh ak do ak thlang taw thlak dyng a kutdo ce hu lawt kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","U ingawm vawhkaw thlak zawicakhqi khui awhkaw thlang pynoet a venawh kai a hubat na a awm dawngawh tuihding boet oet awm a peek awhtaw, awitak ka nik kqawn peek khqi, kutdo ce am myh tikaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesu ing a hubat thlanghqa hlaihih a venawh awi ak kqawn coengawh, ce a hyn awhkawng Kalili khawkhqi awh thlang cawngpyi aham ingkaw awi kqawn aham cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Johan ing Jesu a bibinaak ce thawngim nakawng ang zaak awh, a hubatkhqi ce tyi nawh doet sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Nang ve ak law hly kawi a ming ngaih-u thlang ce hawh nu, am awhtaw thlak chang ka mik ngaih-u hly hyn nu?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesu ing, “Voei unawh na ming zaak ingkaw nami huhkhqi ce Johan a venawh kqawn pe uh: ");
INSERT INTO hltthb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mikhypkhqi mik dai nawh, khawk khemkhqi cet uhy, mynqaaikhqi awm ciim nawh, hakpangkhqi haa khui hy, thlak thikhqi tho unawh, hahqahkhqi ing awithang leek ce za hawh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","U awm kai ak camawh amak tlu thlangkhqi taw ami zoseen hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Johan a hubatkhqi ce ami ceh coengawh, Jesu ing thlang kqeng a venawh Johan akawng ce kqawn pehy; “Ikaw huh nami ngaih awh nu qamkoh na nami ceh? Paipoeng zilh ing a zawn huh nami ngaih awh nu? ");
INSERT INTO hltthb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Am awhtaw, ikaw huh nami ngaih awh nu nami ceh? Suibai ak nep nep ing ak thoeihcam qu thlang huh nami ngaih awh nu? Amni, suibai ak nep nep ing ak thoeihcam qu taw sangpahrang a im awh ni a awm. ");
INSERT INTO hltthb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Cawhtaw ikaw huh nami ngaih awh nu nami ceh? Tawngha aw? Oeih, ka nik kqawn peek khqi, tawngha anglakawh tawngha khqoet ce ni. ");
INSERT INTO hltthb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Anih akawng ce ve myihna ana qee hyt hawh hy: “Nangmih a haiawh ka dyihthing laipai ce tyi law kawng nyngsaw, anih ing a haiawh lam qoek abah law kaw,” tinawh qee hyt na awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Awitak ka nik kqawn peek khqi: nu ing a canaak thlang anglakawh Baptisma ak pekung Johan anglakawh ak bau khqoet thlang am awm hlan hy; cehlai khawk khan awh ak zawi khyt na ak awm ce Johan anglakawh bau khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Baptisma ak pekung Johan a awm awhkawng tuh dy awh, khawk khan ing thekhanaak ce ana hu hy, tha ak awm thlangkhqi ing a thama na hul uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ikawtih tawnghakhqi boeih ingkaw anaa awi ing Johan dy ni awi ami nak kqawn. ");
INSERT INTO hltthb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Do aham nami ngaih mai mantaw, anih cetaw ak law hly kawi Elijah hawh ni. ");
INSERT INTO hltthb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","U awm zaaknaak haa ak ta ingtaw za seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Vawhkaw cadilkhqi ve ikaw ing nu ka nyhtah lah voei? Ik-oeih ami zawihnaak hyn awh ak ngawi naasenkhqi ing ak chang naasenkhqi venawh: ");
INSERT INTO hltthb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Kqung ka mi tum awh awm, am lam u hyk ti; kqahlung ka mik chat law awh awm, am ko am kqang u hyk ti,” tinawh amik khy ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Johan ce law nawh am aw am ai hlai hy, “Qaai tahy,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Thlanghqing Capa law nawh nu a ai hy, cawh, aimaw aawk maw, misur tui ak sawk, mangmu ak cawikhqi ingkaw thlak thawlhkhqi a pyi, tina uhy. Cehlai cyihnaak ingtaw a sainaak awh dang sak hy, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Cekcoengawh kawpoek kyi ik-oeih khawzah a sainaak khawkhqi ce a maming zut a dawngawh zyi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Korazin khaw map hyk ti! Bethesaida khaw map hyk ti! Nangnih ak khuiawh sai na ak awm kawpoek kyi ik-oeihkhqi ve Tura ingkaw Sidon khaw awh sai na a awm mantaw, maa deng awh dipche byng unawh, vyt awh ang zeet doena zut hawh voei uh. ");
INSERT INTO hltthb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Cehlai ka nik kqawn peek khqi, awidengnaak nyn awh Tura ingkaw Sidon khaw ce nangnih anglakawh ana boe bet kawm nih. ");
INSERT INTO hltthb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Cekcoengawh nang, Kapernuam, khawnghi dyna nak zoek qu hly tang nu? Hell na man na nung tlaak kaw. Nak khuiawh saina ak awm kawpoek kyi ik-oeihkhqi ce Sodom khaw awh saina ana awm mantaw, tuhngawi dy awh ak awm hly awm ni hlai hy voei. ");
INSERT INTO hltthb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Cehlai ka nik kqawn peek khqi, awidengnaak nyn awh Sodom khaw ce nang anglakawh ana boe bet kaw tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Cekcoengawh Jesu ing, “Aw ka pa, khan ingkaw khawmdek Bawipa, nang ce nim kyihcah nyng, nang ing ik-oeihkhqi ve thlak cyikhqi ingkaw thlak thoemkhqi a ven awhkawng thuh nawh naasenkhqi venawh dang sak hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oeih, ka pa, ve ve nak kawngaih ik-oeih ni. ");
INSERT INTO hltthb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ka pa ing ik-oeih boeih boeih ce ka venawh ni pe hawh hy. Pa am kaa taw u ingawm capa ce am sim nawh, Pa ce sim aham Capa ing ak tyh thlang am kaataw u ingawm Pa ce am sim hy. ");
INSERT INTO hltthb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nangmih phyihqih ak phyikhqi ingkaw ak khuikhakhqi aw, ka venna law lah uh, dymnaak ni pek khqi vang. ");
INSERT INTO hltthb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kai a phyih ve phyi unawh, ka venawh cawng law lah uh, kawdaw ingkaw kawdung thlang na ka awm dawngawh, nami lingbyi dymnaak ce hu kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ikawtih ka phyih ve nep nawh ka phyihqih ve awm zang hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Cawh Jesu taw Sabath nyn awh lo awhkawng cet hy. A hubatkhqi ing amik phoen cawi nawh caangvui ce dy unawh ai uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farasikhqi ing ami huh awh, a venawh “Toek lah, Sabath nyn awh sai aham amak ciim ce na hubatkhqi ing sai uhy,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Cehlai, a mingmih a venawh, “David ing a pyikhqi mi amik phoen a cawih awhkaw ik-oeih ami sai ce namik noet khawi nu? ");
INSERT INTO hltthb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Anih ing Khawsa ipkhui na lut nawh, khawsoeihkhqi doeng ing ami ai khawi phaihpi ce, amah ingkaw a pyikhqi ing a mami ai hly kawi phaihpi ami ai ce? ");
INSERT INTO hltthb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sabath nyn awh tempul khuiawh khawsoeihkhqi ing Sabath am zeih hlai uhy, coet akap kaana ami awm ce, anaa cabu khuiawh am nami noet khawi nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ka nik kqawn peek khqi bawkim anglakawh ak bau khqoet ce vawh awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bulnaak anglakawh qeennaak ni ka ngaih,' ti ak awi ve naming zaaksim mantaw, ak awm moel moel ak thlang ce am thawlh sak hlai voei uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kawtih thlanghqing Capa taw Sabath Bawi na awm hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ce a hyn ce cehta nawh, a mingmih a Sinakawk khuina ce cet hy, ");
INSERT INTO hltthb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","cawh kut ak kheem thlang pynoet ce ana awm hy. Jesu ce thawlh amik puk thainaak aham, “Sabath nyn awh thlak tlo qoei sak ve ak caih nu?” tinawh doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A mingmih venawh, “Nangmih ak khuiawh thlang pynoet ing tuu pynoet ta mai lah seh, cawhkaw a tuu ce Sabath nyn awh lawkkhqawng na ang tlaak mantaw am na mik dawk hly aw? ");
INSERT INTO hltthb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Cawhtaw thlanghqing ve tuu anglakawh izah nu a phu a awm khqoet! Cedawngawh Sabath nyn awh ik-oeih leek sai ve thym hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Cawhkaw thlang venawh, “Na baan ce zyng lah,” tina hy. Anih ing a baan ce a zyng awh a kut ce akut langben amyihna leek pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Cehlai Farasikhqi taw cawn unawh ikawmyihna nu amah ve ni him naak thai lah voei, tinawh doet qu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesu ing ce ce a sim dym a dawngawh, ce a hyn ce cehta hy. Thlang kqeng khawzah ing ahu awh bat uhy, anih ing cekkhqi a tlawhnaakkhqi boeih ce qoei sak hy, ");
INSERT INTO hltthb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","anih a u nu tice a mamik kqawnnaak aham yn khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tawngha Isaiah ing anak kqawn awi ce a cupnaak thai aham vemyihna awm hy: ");
INSERT INTO hltthb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ve ve ka tyihzoeih thlak tyh, lungna nawh ka ym soeih ni; kang Myihla ce ak khan awh ta kawng nyngsaw, anih ing thymnaak ram tawm awh kqawn kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Anih taw am tlaai kawmsaw khy awm am khy kaw; lam awh anih ak awi ce u ingawm am za kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Anih ing thymnaak ing a noeng hlandy, paipoeng akawng ak pleep ce ap kqai poet kawmsaw, thut awhkaw maikhu awm am thi zip kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ang ming awh qam tawm thlang ing ngaih-unaak ta kawm uh, a ti ceni. ");
INSERT INTO hltthb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Cawh ak kawk khuiawh qaai be nawh mik ak hyp awi awm ak myh thlang pynoet ce, a venawh law pyi uhy, Jesu ing anih ce qoei sak nawh awi awm a pau thai pahoei coengawh amik awm dang pe pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Cawhkaw ak awm thlang kqeng ce a ming ngaih kyi nawh, “Ve ak thlang ve David a capa hy voei nu?” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Cehlai Farasikhqi ing ce ak awi a ming zaak awh, “Ve ak thlang ing ve qaai boei Belzabub ak caming ni qaaikhqi a hqek,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","A mingmih ak kawpoek ce Jesu ing sim nawh a mingmih a venawh, “Kawmih a qam awm ak khuiawh a ming phekbo qu awhtaw am dyi thai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Setan ing Setan ce a hqek mantaw, amah ingkaw amah qaal qu nawn kawm nih saw ikawpna a qam ang dyih thai kaw? ");
INSERT INTO hltthb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kai ing Belzabub ak caming qaaikhqi ka hqek awhtaw, namik thlangkhqi ing u ak caming nu qaaikhqi ami hqek lawt? ");
INSERT INTO hltthb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kai ing Khawsa Myihla ing qaaikhqi ce ka hqek awhtaw Khawsa qam taw nangmih ak khan awh pha hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ikawmyihna thlang ing ip takung thak awm soeih ce a pin hlan awh a im ce muk penawh a ik-oeihkhqi ce a lawh naak peek thai kaw? A pin coengawh man a im ce a muk peek thai kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kai ama nik bawng taw kai anik qaalnaak thlang na awm nawh, kai ama nik cawipyi taw ak thehkung na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Cedawngawh ka nik kqawn peek khqi, thawlhnaak soepkep ingkaw Khawsa ak kqawnseet thlangkhqik khan awh qeenkhaw ngainaak awm kaw, cehlai Ciim Myihla ak kqawnseet thlang ak khan awh qeenkhaw ngainaak am awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","U awm thlanghqing Capa ak kqawnseet taw qeenkhaw ngai na awm hlai moe, Ciim Myihla ak kqawnseet taw tuh awm, ak law hly kawi a tym awh awm qeenkhaw ngainaak am awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","”Thing ak leek awhkawng thaih leek qah nawh, thing ak che awhkawng thaih che qah lawt hy, ak thaih awhkawng thing ce sim uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nangmih khqui a cadilkhqi, nangmih thlak chekhqi ing ikawmyihna ik-oeih leek namik kqawnnaak qoe kaw? Kawlung ak khui awhkaw ak awm ik-oeih ceni nim kha ingawm ak kqawn. ");
INSERT INTO hltthb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Thlak leek ing a ik-oeih leek ak khui awhkawng a ik-oeih leek ce hawlaw nawh, thlak che ing a ik-oeih che ak khui awhkawng ik-oeih amak leek ce hawlaw lawt hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Cehlai ka nik kqawn peek khqi, thlangkhqi ing awi ak poek ceet kaana amik kqawnnaak awh ce awidengnaak nyn awh kqawn caih sak tlaih na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nak awi ak caming cang kawm tiksaw nak awi ak caming dawk kawp ti,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Cekcoengawh Farasikhqi ingkaw anaa awi ak qeekungkhqi ing a venawh, “Cawngpyikung, nang ak kawpoek kyi ik-oeih sai huh aham,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Cehlai a mingmih a venawh, “Thlak leek am ingkaw samphaih cadilkhqi ingtaw kawpoek kyi hatnaakkhqi ce thoeh uhy! Tawngha Jonah ak kawpoek kyi hatnaak am taw ak chang hatnaak peek na am awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kawtih Jonah taw ngak bau ak phoen khuiawh hyp thym ingkaw than thum awm hy, cemih lawtna thlanghqing Capa awm dek khuiawh awm lawt kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nenivi khaw awhkaw thlangkhqi ce vawhkaw cadilkhqi mi awidengnaak khawnyn awh dyi haih kawm usaw cekkhqi ing dawk sak kawm uh; kawtih cekkhqi taw Jonah ak awih kqawnnaak awh zut uhy, ngai lah uh, Jonah anglakawh ak bau khqoet ce vawh awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Khan ben nakaw Sangpahrang nu ce ve canukhqi mi awidengnaak nyn awh dyi haih kawm usaw anih ing vekkhqi ve dawk sak khqi kaw; kawtih anih taw Solomon a cyihnaak awi ak ngai na khawmdek a dytnaak nakawng law hy; ngai lah uh, Solomon anglakawh ak bau khqoet ce vawh awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Thlang ak kawk khui awhkawng qaih che ce ak cawn coengawh, tui ama awmnaak hunkhqi na cet nawh dymnaak ce sui hy, cehlai am hu hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Cedawngawh vemyihna tihy, 'ka cehtaak im na hlat tlaih vang nyng,' ti hy. Ang hlat tlaih awh im ak caihping ak hoeng ce hu hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Amah anglakawh ak che khqoet qaaikhqi ce kun pyi nawh, cawh awm uhy. Cawhtaw ce ak thlang ce ak cyk awh kawng lak awh nauh khqoet hy. Cemyihna vawhkaw thlak che cadilkhqi venawh awm lawt kaw,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesu ing thlang kqeng a venawh awi ak kqawn huiawh a nu ingkaw a koeinaakhqi ce a venawh awi kqawn aham a leng na dyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Thlang pynoet ing a venawh, “Na nu ingkaw na koeinaakhqi ing na venawh awi kqawn aham a leng na dyi uhy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Cehlai awi ak kqawn peekkung a venawh, “Ka nu ingkaw ka koeinaakhqi ce ukhqi nu? tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A hubatkhqi ce a kut ing khi nawh, “Vekkhqi ve ka nu ingkaw ka koeinaakhqi hawh ni! ");
INSERT INTO hltthb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","U awm khawk khan awhkaw ka Pa ak kawngaih ak sai boeih taw ka koeinaakhqi ingkaw ka nu na awm hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ce nyn awh Jesu taw im awhkawng cet nawh tuili kengawh ngawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Cawh thlang khawzah a venawh cun uhy, cedawngawh lawng khuina cet nawh ngawi hy, thlang kqeng taw tuili kengawh dyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A mingmih a venawh nyttahawi ing awi khawzah kqawn pek khqi hy; “Lo toenkung pynoet taw camci ak theh na cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Camci ce ak theh awh a vang taw lam awh tla nawh, phakhqi ing cung boeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A vang taw lungpeei ak khan awh tla hy; dek a pam a dawngawh cawt pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Cehlai khawling a hlawk law awhtaw, ak kqa ama cak a dawngawh khawk hlawk ing a hut awh qeu pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","A vang taw hlik plup awh tla hy, hling ce saang law nawh caang ce eek hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Camci a vang taw laitak awh tla nawh, vui hy - zakhat, khqukkip ingkaw thumkip dy na pung hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Haa ak ta ingtaw za seh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","A hubatkhqi venawh law unawh, “kawtih thlang kqeng a venawh nyttahawi ing awi nak kqawn peek khqi? tinawh doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A mingmih a venawh, “Khan qam awihyp sim thainaak cyihnaak ce nangmih a venawh peek na awm hawh hy, cehlai a mingmih a ven awhtaw am pe hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","U awm khan qam awihyp cyihnaak ak ta taw sap pe tanoel kawmsaw khawzah papa ta kaw. Cehlai u awm amak ta taw ataak chyn awm lawh pekawng. ");
INSERT INTO hltthb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Cawhmaw a mingmih a venawh taw nyttahawi awi ing kak kqawn peek khqi: “Hu hlai uhy, am hat uhy; za hlai uhy, am za thai unawh ang zaak na awm am zasim uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","A mingmih a dawngawh tawngha Isaiah ing: “Ang zaak nataw za hlai voei uk ti, am zasim kawm uk ti; hu taw hu hlai voei uk ti, am hat kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ikawtih ve ak thlangkhqi kawlung ve mawh hqoeng hy; a ming haakhqi ing za kaa hlai uhy, ami mik ce hiim uhy. Ce ap kaa mantaw ami mik ing hu kawm usaw, a ming haa ing za hau kawm uh, kawlung ing zasim kawm usaw huna a ming voei coengawh, qoei sak khqi hau kawng, tinawh anak kqawn ceni. ");
INSERT INTO hltthb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Cehlai nangmih a mik taw ami huh thai a dawngawh a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Awitak ka nik kqawn peek khqi, nangmih ing nami huh ve tawngha khawzah ingkaw thlak dyng khawzah ing huh aham ana ngaih hlai uhy, naming zaak ve zaak ana ngaih hlai uhy, am za uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Cawhtaw camci theh nyttahawi ing ak kqawn ngaihnaak awi ve ngai lah uh: ");
INSERT INTO hltthb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","U ingawm khawk khan awithang ce za hlai uhy am zasim uhy, cawh ak kawlung khuiawh theh na ak awm awithang leek ce qaai ing qawt pe valh hy. Vetaw lam awh ak tla camci ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lungpeei awh ak tla camci taw, thlang ing awi ce ang zaak awh zeel doena do pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Cehlai ak kqa ama taak a dawngawh, kawlhkalh ca doeng awm hy. Ce ak awi dawngawh kyinaak ingkaw thekhanaakkhqi a pha law awh ce tlu pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Hlik plup awhkaw ak tla camci taw, awi ce za hlai hy, ve khawmdek khan hqingnaak awh mawn atang nawh qaai kqawnnaak ingkaw boei a mangnaak ing awi ce a eek a dawngawh thaih am qah thai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Laitak awhkaw ak tla camci taw awi ce ang zaak awhkawng ak zasim ak thlang na awm hy; ak thaih qah nawh a vang taw a let zakhat, a vang khqukkip, a vang taw thumkip dyna pung hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesu ing ak chang nyhtahnaak awi ce a mingmih a venawh kqawn bai hy: “Khawk khan taw thlang pynoet ing a lo awh camci a saw ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Cehlai a mi ih tloek awh ami qaal ce law nawh cang anglakawh beei ak ui ce theh awh cehtaak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Caang ce cawt nawh a vui ak thaih law awhtaw, beei awm cawt law lawt hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Cawh lokung a tyihzawihkhqi ce a venawh law unawh, 'Bawipa, ak leek ni na lo awh nak theh hlai. Hanakaw beeikhqi nu ak cawt hy voei?' tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“A mingmih a venawh, 'Qaal ing ni a sai hawh hy ce,' tina hy. A tyihzawihkhqi ing, 'cawhtaw cet unyng seitaw phu mai vang unyng aw? tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Cehlai lokung ing, “amni, beei ce nami phuk mantaw cang awm phuk sih hau kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Caang ah hlan dy taw cawt haih mai cang seh. Cang ah awhtaw cang aatkhqi venawh, 'Beeikhqi ce phu ma unawh, mai awh phum aham ak nep na tum uh, cang taw teep ak khuiawh chan uh, tina bit kawng,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Cekcoengawh a mingmih a venawh nyhtahnaak awi ak chang ce kqawn pek khqi bai hy: “Khan qam taw antlam cii ce thlang ing lo nawh a lo awh ak theh ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ce antlam cii taw ak ui boeih boeih anglakawh ak zawi soeih na awm hlai hy, a cawt law awhtaw beei ak chang boeihkhqi anglakawh ak bau soeih na awm hy, khan nakaw phakhqi ce law unawh a paangkhqi awh cu uhy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A mingmih a venawh nyhtahnaak awi ak chang kqawn pe bai hy: “Khan qam taw nu pynoet ing hen lo nawh vaidam dawn khui thum a zamnaak boeih aham vaidam awh a phul ing myih hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Vawhkaw ik-oeihkhqi boeih ve Jesu ing nyhtahnaak awi ing thlang kqeng a venawh kqawn pehy; nyhtahnaak awi kaana a mingmih a venawh ikaw pynoet awm ap kqawn pehy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Cedawngawh tawngha ing: “Nyhtahnaak awikhqi ing, khawmdek a syn cyk awhkawng thuh na ak awmkhqi ce kqawn kawng,” tinawh anak kqawn ce cup sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Cekcoengawh thlang kqeng ce cehta nawh ipkhui na lut hy. Cawh a hubatkhqi ce a venna law unawh, “Lo awhkaw beei nyhtahnaak awi nak kqawn ce kaimih aham kqawn caih lah,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A mingmih a venawh, “Camcik leek ak thehkung taw thlanghqing Capa ni. ");
INSERT INTO hltthb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Lo taw ve khawmdek ni, camcik leek taw a qam cakhqi ak kqawnnaak ni. Beeikhqi taw thlak thawlh a cakhqi ni, ");
INSERT INTO hltthb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","a mingmih ak thehkung cetaw qaai ni. Cang ah cetaw khawmdek a dytnaak, cang ak aatkungkhqi cetaw khan ceityihkhqi ni. ");
INSERT INTO hltthb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Beeikhqi ce phu boeih nawh mai awh amik phum amyihna khawmdek a dyt awh ce amyihna ce awm lawt kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Thlanghqing Capa ing ak khan ceityihkhqi ce tyi kawmsaw, thawlhnaak ak saikhqi ingkaw ik-oeih amak leek ak saikhqi ce a qam khui awhkawng caawi kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Thii a tui na ami hloeinaak mai khuiawh a mingmih ce khaawng khqi kaw, cawh ce kqangnaak ingkaw hatahnaak ce awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Cekcoengawh thlak dyngkhqi taw a mi pa a qam awh khawmik amyihna vang hawh kawm uh. Haa ak takhqi ingtaw za seh nyng. ");
INSERT INTO hltthb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Khan qam taw lo awhkaw qo thuh ing myih hy. Cawhkaw qo ce thlang pynoet ing a huh awh thuh tlaih nawh, cekcoengawh zeel doena cet nawh a taak ik-oeihkhqi boeih ce zawi nawh cawhkaw lo ce thlai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Cekcoeng baiawh, khan qam taw phuk tlo pale ak suikung them ak zaawi ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Anih ing pale lung phu ak tlo soeih ce a huh awh, cet nawh a taakkhqi boeih ce zawi nawh thlai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Cek coeng bai awh, khan qam taw tuili awh lawk khawng nawh nga soepkep ak kaawi ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lawk awh nga a be awh ce peem awh chan unawh nga ak che taw khaawng uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Khawmdek a dyt awhtaw ce amyihna ce awm lawt kaw. Khan ceityihkhqi law kawm usaw thlak dyngkhqi anglakawhkawng thlak thawlhkhqi ce hoep khqi kaw; ");
INSERT INTO hltthb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","cekkhqi ce a tui hloeinaak maih khuina khaawng kaw, ce a hyn awh kqangnaak ingkaw haatahnaak ce awm kaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesu ing a mingmih a venawh, “Vawhkaw ik-oeihkhqi boeih ve namik zasim nu?” tinawh doet khqi hy. Cekkhqi ing, “Oeih, Bawipa,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A mingmih a venawh, “Cedawngawh khan qam akawng kqawn peek na ak awm cawng saknaak awi ak qeekungkhqi boeih taw iptakung ing a ipkhui awhkawng a khawhthem ak khqym ak thai ak chet pheng ing myih hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesu ing vawhkaw nyhtahnaak awikhqi ak kqawn boeih coengawh, ce a hyn ce cehta hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Amah a khaw na ce law nawh Sinakawk awh ce thlang cawngpyi hy, cawh a mingmih ce a ming ngaih kyi hy.” Ve ak thlang ing hana kaw vemyih cyihnaak ingkaw kawpoek kyi ik-oeih saithainaakkhqi a taak hy voei?” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Anih ve thing aatkung a capa am nu? Anu awm Meri am nu ve, a koeinaakhqi Jakop, Joseph, Simon ingkaw Juda am nu ve? ");
INSERT INTO hltthb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A koeinukhqi awm ningnih a venawh amik awm haih lawt am nu ve? Ve ak thlang ing vawhkaw ik-oeihkhqi hana kaw a huh hy voei?” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ak khan awh amik kaw am zeel hy. Cehlai Jesu ing cekkhqi venawh, “Tawngha taw amah a khaw ingkaw amah a im am awhtaw zoeksangna am awm man hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Cangnaak a mami taak a dawngawh ce a hyn awh kawpoek kyi ik-oeih khawzah am sai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Cawh Herod sangpahrang ing Jesu akawng ce za hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Cedawngawh a tyihzoeih a venawh, “Anih ce thihnaak awhkawng ak tho tlaih Baptisma ak pekung Johan hawh ni! Cawh ni kawpoek kyi ik-oeih saithainaakkhqi anih awh a awm hy,” tihy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod ing a na Philip a zu Herodi akawng awh Johan ce tu nawh ak khih coengawh thawngim na thla hy, ");
INSERT INTO hltthb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Johan ing “Na na a zu na zuna na lawh ce am thym hy,” a tinaak dawngawh ce myihna ce sai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Thlang kqeng ing Johan ce tawngha tinawh amik poek a dawngawh, Johan ce him aham ngaih hlai uhy, thlang kqeng ce kqih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Cehlai Herod a thangnaak khawnyn a pha awh, Herod a canu ce a mingmih a haiawh lam sak nawh Herod ce ak kaw zeel sak hy, ");
INSERT INTO hltthb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Cedawngawh cawhkaw nuca ing a ngaih saqui ce peek aham awikamnaak tahy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nuca ing a nu a cuih amyihna, “Baptisma ak pekung Johan a lu ce beihdung awh ni pe,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Cawh taw sangpahrang ce ak kaw se hy, cehlai mybuh amik veel haih khinkhqi haiawh awi ana kam hawh a dawngawh nuca ing a ngaih amyihna peek aham awi pehy, ");
INSERT INTO hltthb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","thlang tyi nawh thawngim khui awhkaw Johan a lu ce hlyng sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A lu ce beihdung awh hawlaw pe unawh nuca ce pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Johan a hubatkhqi ce law unawh a qawk ce a mi khyn coengawh pup uhy. Cekcoengawh cet unawh Jesu a ven awh kqawn pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ce ak awi ce Jesu ing ang zaak awh, thlang a dingnaak na lawng ing cet valh hy. Thlangkhqi ing a ming zaak awh, khawk khui awhkawng khaw ing cet unawh hquut uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesu ing kawngceng a pha awhtaw thlang kqeng ce hu hy, cawh a mingmih ce am qeen khqi soeih a dawngawh, thlak tlokhqi ce qoei sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Khaw a my law awhtaw, a hubatkhqi ce a venna law unawh, “Ve ve kqawng lak na awm nawh, khaw awm my hawh hy. Cedawngawh thlang kqeng ve ceh sak hlah, khawk khuina cet u seitaw a mimah ing buh a an awm thlai useh,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Cehlai Jesu ing, “A mingmih a mi ceh am ngaih hy. Nangmih ing ai kawi pe uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Cekkhqi ing a venawh, “Phaihpi cun nga ingkaw nga lunghih doeng ni ka mi taak,” tina uhy, ");
INSERT INTO hltthb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Cekkhqi venawh, “Ka venna hawlaw lah uh,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Taaitin awh thlang kqeng ce ngawih sak aham awi pehy. Phaihpi cun nga ingkaw nga lunghih ce a lawh coengawh khan benna mang nawh, zeelnaak awi ak kqawn coengawh phaihpi ce ek hy. Cekcoengawh phaihpi ce a hubatkhqi venawh pehy, a hubatkhqi ing thlang kqeng a venawh teei patoeng uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Cekkhqi ing ami ai awhtaw phyi boeih uhy, ami ai ngenkhqi ce a hubatkhqi ing ami kawih awh vawh hqa hlaihih law hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Cawhkaw ak aikhqi ce nu ingkaw naasen a noet kaana, pa hqoeng thawngnga law uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesu ing thlang kqeng ce a tyih khqi huili awh, a hubatkhqi awm lawng awh luh sak khqi nawh caqai benna ana cet uh tinawh awi pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Thlang kqeng ce a ceh sak coengawh, cykcah aham amah doeng tlang na kaai hy. Khaw a my law awhtaw, ce a hyn awh amah doeng awm hy, ");
INSERT INTO hltthb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Cehlai lawng taw caqai ing a hlanaak na tuibak ing mam khoep hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Than cinghy khawnoek pali awh, Jesu taw a mingmih a venna tui awh ce cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tuili awh a ceh ce a hubatkhqi ing ami huh awh kqih uhy. “Ce ce myihla ni,” ti unawh amik kqih awh khyy uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Cehlai Jesu ing a mingmih a venawh: “Koeh ly uh, kai ni, koeh kqih uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piter ing a venawh, “Bawipa, nang awhtaw na venna tui awh ce ni law sak lawt lah,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesu ing, “Law,” tina hy. Cawh Piter ce lawng awhkawng kqum nawh, tui awh Jesu a venna ce va cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Cehlai khawhli ce a huh awh kqih nawh tuih khuina ce nung tla hy, “Bawipa, ni hul lah! tinawh khy hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesu ing a kut soeng nawh tu hy, “Cangnaak ak zawi aw, kawtih upvoetnaak na taak?,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Lawng khuina a ni kaai coengawh, khawhli ce sit hy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Lawng khui awhkaw ak awm thlangkhqi ing anih ce beek uhy, “Nang ve Khawsa Capa tang tang ni,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Caqai benna ce cet phat unawh Gennesaret qam ce pha uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ce a hyn awhkaw ak awm thlangkhqi ing anih ce ami sim awhkawng ami qam pum awh awi ce pha sak boeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","A venawh tlawhnaak ak takhqi boeih ce hawlaw unawh a himai awm ami binaak thai aham a venawh qeennaak thoeh uhy, ak bi thlangkhqi boeih taw qoei uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Cawh Jerusalem khaw awhkawng Farasi khqi ingkaw anaa awi cawngpyikung khqi thlang vang ce Jesu a venna law unawh doet uhy, ");
INSERT INTO hltthb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","kawtih na hubatkhqi ing a hqamcakhqik awi qoe ce ami hqe? Buh ami ai law hly awh ami kut khaw am sil uhy!, tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesu ing a mingmih a venawh, “Cawhtaw kawtih nangmih ing na mimah ak awi qoe ingkaw Khawsa ak awipeek ce nami hqe lawt? ");
INSERT INTO hltthb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Khawsa ak awipeek ingtaw, na nu ingkaw na pa zoeksang lah, anu apa awih che ak hlah sih taw thih sak aham awm hy, tinawh ak kqawn ce. ");
INSERT INTO hltthb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Cehlai nangmih ingtaw thlang ing anu apa venawh, 'kai a ven awhkawng na ngaih ik-oeih boeih boeih ce Khawsa venawh awm hawh hy,' a tinaak mantaw, ");
INSERT INTO hltthb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","'anih ingtaw apa ce a zoeksang aham am awm hy,' ti u hyk ti. Cemyihna na mimah ak awi qoe ingkaw Khawsak awipeek ce kawna awm ap poek uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nangmih thlang qaai kqawnkhqi! Isaiah ing nangmih akawng anak kqawn hyt: ");
INSERT INTO hltthb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","”Ve ak thlangkhqi ing a mim kha hqawng ingtaw kai ve ni zoeksang kaa hlai uhy, amik kawlungkhqi taw ak chang na ta uhy; ");
INSERT INTO hltthb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","A hoeina ni kai ve ami ni beek hy; ami cawngpyinaak ce awm thlanghqing a cawngpyinaak mai ni, a tive thym hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesu ing thlang kqeng ce a venna khy nawh, “Ngai unawh zasim lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nim khak khuiawh anuk lut awk-ai ing thlang tuih am awm sak nawh, nim khak khui awhkawng ak cawn law awih che ing ni thlang tuih a awm sak,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Cekcoengawh a hubatkhqi ce a venna law unawh doet uhy, “Farasikhqi ing ve ak awi ve aming zaak awh amik kaw am law hy, tice nak sim nu?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Cehlai anih ing, “Khawk khan nakaw Pa ing a mang ling thingkungkhqi boeih taw ak kqa mah na phu kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Awm taak dym uh; sawikung mikhypkhqi ni. Mikhyp ing mikhyp a sawi mantaw, lawkkhqawng na tla qen kawm nih,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piter ing a venawh, “Vawhkaw nyhtahnaak awi ve kaimih a venawh kqawn caih lah,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesu ing, “Nangmih ingawm am nami zasim nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nim khak khuiawh a nuk lut boeih boeih taw phoen ak khuina cet nawh cawh kawng ce naat na cawn hy, tice am nami sim nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Cehlai nim kha awhkawng ahak cawn law boeih taw kawlung khui awhkawng ni a law, cekkhqi ing ce thlang tyih am leh kap sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kawlung khui awhkawng ni kawpoek amak leekkhqi, thlang himnaak, samphaihnaak, nu pa thawlhnaak, quuknaak, amak thym dyihthing na dyihnaak, Khawsa thekhanaak khqi ce a law hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ve myihkhqi ing thlang tuih am leh kap sak hy; cehlai kut silh kaana buh ainaak ing thlang tuih am leh am kap sak hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ce hyn awhkawng Jesu taw Tura ingkaw Sidon khaw khqang ce cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Cawh, Kanaan nu pynoet taw a qam khui awhkawng law nawh, a venawh, “Bawipa, David Capa, kai ve nim qeen lah! Ka canu qaai ing tu nawh khuikha soeih hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Cehlai awi khang oet awm am hlat pehy. Cedawngawh a hubatkhqi ce a venna law unawh, “Ak chang na ceh sak hlah, ni hu awh khy khing hy,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesu ing, “Isarel tuu ak qengkhqi aham doeng nani ani tyih,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Cawh nu ce law nawh, “a haiawh khuk sym doena, “Bawipa ni bawm lah!” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Anih ing, “Cakhqi phaihpi ce lawh pe nawh uikhqi ni peek lat ce am thym hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Cawhkaw nu ing, “Oeih, Bawipa, thym hy, cehlai ui ingawm a boeikhqi a caboei awhkaw buh baw ak tlakhqi ce lym lawt saw, tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Cawh Jesu ing a venawh, “Nang nu nak cangnaak dung soeih hy! Na thoehnaak ce peek na awm hawh hy,” tina hy. Cawhkawng a canu ce qoei tlang hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ce a hyn ce Jesu ing cehta nawh Kalili tuili benna cet hy. Cekcoengawh tlang na ce kaai nawh ngawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Cawh thlang kqeng khawzah ce a venna law uhy, khawk khem, mikhyp, awimyh, ak khawnkhqi ingkaw thlak tlokhqi ce a khawkung awh soei pe unawh; anih ing cekkhqi boeih ce qoei sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Awimyh ing pau thai nawh ak khawnkhqi ing leek hy, khaw ak khemkhqi ingawm cet thai unawh mikhypkhqi ing hu thai uhy; ce mihkhqi ce thlang boeih ing ami huh awh amik kawpoek kyi unawh, Isarel Khawsa ce kyihcah uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Cekcoengawh Jesu ing a hubatkhqi ce a venna khy nawh, “Vawhkaw thlang kqeng ve qeen khqi soeih nyng, vekkhqi ve ka venawh ikaw awm a ai kaana khaw thum voei awm hawh uhy. Buh cawih doena ceh sak aham am ngaih nyng, ka ceh sak man lam lak awh lum hau kawm uh,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","A hubatkhqi ing a venawh, “Thlang ve zah a ai tat phaihpi ce ve kqawng khuiawh hana kaw ka mi huh kaw?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesu ing a mingmih a venawh, “Phaihpi izah nu nami taak?” tinak khqi hy. A mingmih ing, “Phaihpi khqih ingkaw nga a khoeh ca taw awm hy,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Thlang kqeng ce dek awh ngawih sak aham kqawn pehy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Phaihpi khqih ingkaw nga ce lo nawh zeelnaak awi ak kqawn coengawh thek nawh a hubatkhqi ce pehy. A hubatkhqi ing thlang kqeng a venawh tei pek khqi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","A mingmih ing ak phyi na ai boeih uhy. Ami ai ngenkhqi ce a hubatkhqi ing ami cawi awh vawh khqih na kawi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Cawhkaw ak aikhqi boeih taw naasenkhqi ingkaw nukhqi ak kqawn kaana thlang thawngli law uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Thlang kqeng ce a ceh sak coengawh, lawng khuina lut nawh Magadan khaw benna ce cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farasi ingkaw Sadusikhqi ce Jesu a venna law unawh, khan ben nakaw hatnaak dang sak aham noek adak uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A mingmih a venawh, “Khawmy ben awh cingmai a thiim awhtaw khaw seen kaw ti uhyk ti, ");
INSERT INTO hltthb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","mymcang ben awh, khawmai a sah awhtaw, “khaw am seen tikaw,” ti uhyk ti. Nangmih ingawm khaw taw nai a nawng thai hlai uhyk ti, a tym hatnaak taw am nainawng thai uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Thlak che ingkaw samphaih cadilkhqi ingtaw hatnaak sui uhy, tawngha Jonah a hatnaak doeng am kaa taw ikaw awm peekna am awm kaw,” tina hy. Cekcoengawh cekkhqi ce ak chang na cehta hy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tuili caqai benna ami haih kat awh a hubatkhqi ing phaihpi ami khyn hly ce hilh valh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesu ing a mingmih a venawh, “Farasikhqi ingkaw Sadusikhqi venawh ce nami cyih ta unawh qalqiing lah uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","“Phaihpi am ni taak awh va ni kaw,” ti unawh a mimah ingkaw a mimah ce doet qu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesu ing cekkhqi ak awih kqawn ce zasim nawh, “Cangnaak ak zawikhqi, kawtih phaihpi am nami taak akawng ce namik kqawn? ");
INSERT INTO hltthb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Am nami zasim hlan nawh nu? Thlang thawngnga ing phaihpi ingkaw nga ami ai ce namim hilh hawh nawh nu?, Vawh izah nami kawih ce? ");
INSERT INTO hltthb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Thlang thawngli ing phaihpi khqih a mi ai awh vawh izah nu ami kawih bai ce? ");
INSERT INTO hltthb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Phaihpi akawng name venawh kak kqawn am ni tice ikawtih am naming zaaksim? Farasikhqi ingkaw sadusikhqi henawh ngaihthyn uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Phaihpi awh ak awm hen akawng qalqiing aham am kqawn nawh Farasikhqi ingkaw Sadusikhqi a cawngpyinaak awh ngaihtaak aham ni ak kqawn hy tice zasim uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesu ing kaisary Philipi peng khuina a law awh a hubatkhqi ce doet hy, “Thlangkhqi ing thlanghqing Capa ve u nu a mi ti? tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Cekkhqi ing, “Thlang vang ingtaw nang ve, Baptisma pekung Johan ni, ti uhy, thlang vang ing 'Elijah' ti uhy; thlang vang bai ingtaw, 'Jeremiah' am awhtaw tawngha pynoet oet,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Cawh a mingmih a venawh, “Cawhtaw nangmih ingtaw kai ve u nu nami ti?” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Piter ing, “Nang taw Khrih, ak hqing Khawsa Capa ni,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesu ing a venawh, “Nang Jonah capa, na zoseen hy, kawtih thlanghqing ing amni sim sak nawh khawk khan nakaw ka Pa ing ni a ni sim sak. ");
INSERT INTO hltthb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na venawh ka nik kqawn peek, nang taw Piter ni, ve lungnu awh ka thlangboel dyih sak kawng; hell chawmkeng ing ce ce am noeng qoe tikaw. ");
INSERT INTO hltthb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Khan ram cabi ce na venawh ni pe kawng; khawmdek awh nang ing na pinkhqi boeih ce khawk khan na awm pin na awm lawt kaw, khawmdek awh nang ing na hlam boeih ce khawk khan na awm hlam na awm lawt kaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Amah ce Khrih ni tice a u venawh awm ama mik kqawn aham a hubatkhqi venawh awi pehy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Amah cawhkawng taw Jesu ing Jerusalem na cet kawmsaw a hqamcakhqi khawsoeih boeikhqi ingkaw anaa awi cawngpyikungkhqi ing khuikhanaak a sim sak hly khqi ingkaw him na awm kawmsaw am thum nyn awh thawh tlaih na a awm hly khqi ce a hubatkhqi venawh kqawn caih pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piter ing amah ce ak chang na cehpyi nawh kaa na hy. “Bawipa, cemih ik-oeih nang ak khan awh koeh pha qoe seh, vemyihkhqi ve nang a venawh koeh awm seh,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Cehlai Jesu ing Piter ce hawi sih nawh, “Setan, ka huna thoeih lah! Nang ve kang tluuknaak ahamna awm hyk ti; Khawsa a ik-oeihkhqi ve poek kaana thlanghqing a ik-oeihkhqi ce poek hyk ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Cekcoengawh Jesu ing a hubatkhqi venawh, “U ingawm kai a hu awh law aham a ngaih awhtaw, amah ingkaw amah ce hoet qu seitaw, amah a thinglam ak kawh doena ka hu awh bat seh. ");
INSERT INTO hltthb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","U awm a hqingnaak ce thaawng aham ak ngaih ingtaw hlawng kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Thlang ing khawmdek pum ve ham mai seiawm a hqingnaak ce a hlawng awhtaw ikaw nu phu a tak? A hqingnaak ce ikaw ing nu ang thung thai kaw? ");
INSERT INTO hltthb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Thlanghqing Capa ing Pa a boeimangnaak ingkaw ak khan ceityihkhqi mi law kaw, thlang boeih a venawh a mi them sainaak boeih ve myihna kutdo ce pek khqi boeih kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Awitak ka nik kqawn peek khqi, thlanghqing Capa ing a qam na a law ce a huh hlan khui awhtaw, vawhkaw thlang vang ak dyikhqi ak khuiawh thihnaak amak tan hly kawi thlang awm hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Khaw khquk nyn a awm coengawh Jesu ing Piter, Jakob ingkaw a na Johan ce khy nawh a mimah doeng tlang ak sang na ce kaai pyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Cawh ce a mingmih a haiawh a myi ce thaw pehy. A hai ce khawmik amyihna vang nawh, a hi awm khawkdai amyihna baawk hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Cawh cekkhqi a haiawh Mosi ingkaw Elijah ce dang pe nawh Jesu mi ce pau uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Cawh Piter ing Jesu a venawh, “Bawipa, vawh awm aham nep soeih hy. Na ngaih awhtaw buk pakthum heen law vang - nang aham pynoet, Mosi aham pynoet, Elijah aham pynoet seh,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Awi ak kqawn huili awh, myi ak vang thlang ing a mingmih ce zawl khqi khoep nawh, myi ak khui awhkaw awi ing, “Vetaw ka lungnaak ka Capa ni; ak khan awh zeel soeih nyng; ak awi ngai pe uh!” tihy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","A hubatkhqi ing a ming zaak awh kqih soeih unawh a bukhup na koep uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Cehlai Jesu ing law nawh cekkhqi ce bi hy, “Koeh kqih uh, tho hlah uh,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","A mingmih ing ami toek awhtaw, Jesu doeng am kaana taw u awm ak chang am hu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tlang nakawng ami nuk kqum awh, Jesu ing cekkhqi ce awi yn hy, “Thlanghqing Capa ve thihnaak awhkawng a thawh hlan dy taw, vawhkaw ik-oeih nami huh ve u a venawh awm koeh kqawn uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A hubatkhqi ing doet uhy, “kawtih anaa cawngpyikung khqi ing Elijah lamma na law kaw, a mi ti?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesu ing cekkhqi venawh, “Elijah ve lamma na law tak kawmsaw ik-oeihkhqi boeih ce ak nep na sai tlaih kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Cehlai ka nik kqawn peek khqi, Elijah taw law hawh hlai hy, a mingmih ing am hat uhy, ami ngaih saqui ce ak khan awh sai pe uhy, cemih lawt na thlanghqing Capa ingawm a mingmih a kut awh khuikha kaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Baptisma ak pekung Johan akawng ni a mingmih a venawh ak kqawn peek, tice a hubatkhqi ing zasim uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Thlang kqeng a venna a mi law awh, thlang pynoet ce a venawh law nawh ak khawkung awh khuk sym pehy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Bawipa ka capa ak khan awh qeennaak ta law cang lah, qaw nawh khuikha khing hawh hy. Mai awh tlu poepa hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na hubatkhqi venawh khyn hlai nyng, am qoei sak thai uhy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Cawh Jesu ing, “Aw cangnaak amak ta thlangkhqi ingkaw kawlung ak hqamkhqi, nangmih ve iqyt nu ka ni awm pyi khqi kaw? Iqyt nu ka ning yh pyi khqi kaw? Ka venna hawlaw lah uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesu ing qaai ce zyi nawh, qaai ing cawhkaw naasen ce cehta hy, cawh anih ce qoei tlang hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Cekcoengawh a hubatkhqi ing aha cana Jesu a venna law unawh, “kawtih kaimih ingtaw am ka mi hqek thai?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesu ing a mingmih a venawh, “Namik cangnaak a zawi a dawngawh ni. Awtak ka nik kqawn peek khqi, antlam ak ui teh mah cangnaak nami taak mantaw, vawhkaw tlang a venawh, 'vawhkawng cena thoeih lah,' nami tinaak awh thoeih kaw. Nangmih aham amak coeng thai ikaw awm am awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Cehlai vemih ve cykcahnaak ingkaw buh zeihnaak doeng am ingtaw am cet thai hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kalili qam na ami law awh, Jesu ing a mingmih a venawh, “Thlanghqing Capa ve thlangkhqi kut awh pe kawm usaw tu sak kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Him kawm usaw, am thum nyn awh tho tlaih kaw,” tina hy. Ce ak awi ce a ming zaak awh a hubatkhqi taw amik kaw map hqoeng hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kapernaum khaw ami pha law awh mangmu ak cawikhqi ce Piter a venna law unawh, “Nangmih a cawngpyikung ing pumim tangka am cawi nawh aw?” tinawh doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Anih ing, “Cawi hy,” tinawh hlat hy. Imna a mi luh awh Jesu ing khai nawh, “Simon, ikawmyihna nak poek? Khawmdek sangpahrangkhqi ing u venna nu mangmu ami cawi? Ami cakhqi venna nu, thlak chang vena?” tinawh doet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piter ing a venawh, “Thlak chang a venawh,” tina hy. Jesu ing, “Cawhtaw a cakhqi taw loet timaw ce. ");
INSERT INTO hltthb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Cehlai amik kaw a zeelnaak aham, tuili na cet nawh cikkoeih vak thla. Ngam nam tu ma ce lo nawh am kha ce phen pe, tangka hu kawp ti. Lo nawh kai ingkaw namimah hamna cawi,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Cawh a hubatkhqi ce Jesu a venna law unawh, “Khan qam awh u nu ak bau kaw?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesu ing naasen ca ce lo nawh a ming lak lung awh dyih sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","A mingmih a venawh: “Awitak ka nik kqawn peek khqi, nangmih ing namik kaw am hloet unawh naasenkhqi amyihna am nami awm awhtaw, khan qam khuiawh ityk awh awm am lut ti kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Cedawngawh, u awm vawhkaw naasen amyihna thlang ak kai awh dungvoeng na ak awm taw khan qam awh ak bau soeih na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“U awm vemyih naasen ca ce kai ang ming ing ak do ak thlang taw kai anik do thlang na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Cehlai u ingawm vawhkaw naasen, kai anik cangnaakkhqi ak khuiawh pynoet awm ang tluk sak awhtaw, cang neetnaak lung ak bau ce a hawng awh aawi sak nawh lidung ak khuina nik thlak man a hamna nep bet kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Thlang thawlhnaak ak sai sak ik-oeihkhqi awh khawmdek ve khaw na bin hy! Ce mih ik-oeihkhqi ce ak law hly qoe ni, cehlai thawlhnaak ak law sakkung thlang ce khaw na bin hy! ");
INSERT INTO hltthb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Na kut am awhtaw na khaw ing a ni thawlh sak awhtaw tlyk boet nawh khawng. Kut pakhih ingkaw khaw pakhih ak soep na kumqui mai khuina nang tlaak anglakawh, pum amak soep doena hqingnaak ak khuiawh na lut ce nep bet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na mik ing a ni thawlh sak awhtaw koeih doek nawh khawng. Mik pakhih ing hell mai khuina nang tlaak anglakawh, miklang ing hqingnaak khuina na lut ce na hamna nep bet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Vawhkaw naasenkhqi ak khuiawh pynoet awm am nami hepnaak aham qalqiing lah uh. Ikawtih ka nik kqawn peek khqi, a mingmih ak khan ceityihkhqi ing khawk khan nakaw ka Pa a haai ce hu poepa uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ak qengkhqi thaawng aham ni thlanghqing Capa ve a law. ");
INSERT INTO hltthb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ikawmyihna namik poek? Thlang pynoet ing tuu zakhat ce ta hlai hy, pynoet ce ak chang na a ceh valh mai mantaw, sawmkow pakow tloek ce tlang na cehta nawh ak chang ak qeng tuu pynoet ce am sui hly nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tuu ce a huh tlaih awhtaw, awitak ka nik kqawn peek khqi, ak chang na amak cet valh tuu sawm kow pakow anglakawh cawhkaw tuu ak cet valh ce ym bet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Cemyih lawtna khawk khan awh ak awm nangmih a Pa ing vawhkaw naasenkhqi ak khuiawh pynoet ca awm qeng aham am ngaih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","”Na koeinaa ing nak khan awh, ik-oeih a sai thawlh awhtaw cet nawh a thawlhnaak ce na mimah anglak doeng awh kqawn pe. Nak awi ce ang ngai awhtaw anih ce na noeng na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Cehlai a mang ngai awhtaw, thlang pakhih thum a simpyinaak awh awi ce a caknaak aham, thlang pynoet mai aw am awhtaw pakhih awh ceh pyi. ");
INSERT INTO hltthb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Cekkhqi ak awi awm a mang ngai bai awhtaw thlangboel a venawh kqawn uh; thlangboel ak awi awm a mang ngai awhtaw, lawkih am awhtaw mangmu ak cawikung na ngai law uh. ");
INSERT INTO hltthb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Awitak ka nik kqawn peek khqi, khawmdek awh nami pinkhqi boeih ce khawk khan na awm pin na awm lawt kawmsaw, khawmdek awhkaw nami hlam khqi boeih ce khawk khan na awm hlam na awm lawt kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Cekcoengawh nik kqawn pek khqi tlaih nyng, khawmdek awh thlang pakhih ing kawpoek pynoet na taak doena ik-oeih a ni thoeh awhtaw khawk khan nakaw ka Pa ing nangmih aham sai pekna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Thlang pakhih awm pakthum awm kang ming ing a ming cunnaak awh, a mingmih a venawh kai awm nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Cekcoengawh Piter ing Jesu a venna law nawh doet hy, “Bawipa, ka koeinaa ing kak khan awh ik-oeih a sai thawlh awh, iqyt dy nu qeenkhaw kang ngai kaw? Ak khqih dy nu?” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu ing, “Ka nik kqawn peek khqi, ak khqih dy doeng amni, ak khqih a pyh khqihkip dy ti nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Cedawngawh khan qam taw sangpahrang pynoet ing a tyihzawihkhqi venawh a tangka lai ak kqawn ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tangka ce a soep awh tangka thonghqa ak pu peek thlang ce law pyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Anih ing tangka ce ama peek thai voel hawh a dawngawh, a zuca ingkaw a toentaak khawhthemkhqi boeih ce zawi nawh a laiba ce sah aham awi pehy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Cawh ce cawhkaw tyihzawih thlang ing a haiawh khuk sym nawh qeennaak thoeh hy, 'Bawipa nim qeen mai cang, ni pe boeih lawt bit kawng,' tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","A boei ing anih ce qeen nawh a laiba boeih ce zoe pe sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Cehlai cawhkaw tyihzawih thlang ce cet hy, cawh tangka denari zakhat ak pu peek a pyi tyihzawih pynoet ce hu hy. Anih ce a hawng awh tu nawh khak hy, “Tangka nak pu ce ni pe hlah,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Cawhkaw tyihzawih pyi ing a haiawh khuk sym doena qeennaak thoeh hy, 'Nim qeen cang, ni pe boeih lawt bit kawng,' tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Cehlai anih ing am hlah hy. A tangka pu ce a ni sam boeih hlan dy anih ce thawngim na thla hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cawhkaw ik-oeih ce tyihzawih pyi ak changkhqi ing ami huh awh, amik kaw se hy, cet unawh cawhkaw ik-oeihkhqi boeih ce a pa a venawh kqawn pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Cawh a boei ing cawhkaw tyihzawih ce a venna khy hy. Nang tyihzawih thlak che, kai a venawh qeennaak na thoeh a dawngawh kai ing na laibakhqi boeih ce ni zoe pe sak nyng. ");
INSERT INTO hltthb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kai ing nak khan awh qeennaak ka taak lawt amyihna nang ingawm thlang ak khan awh qeennaak na taak aham awm lawt hy,' tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Cawhkaw boei ce ak kaw so nawh laiba a sam boeih hlan dy cawhkaw tyihzawih ce phep aham thawng ak thlakungkhqi kut awh pehy. ");
INSERT INTO hltthb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Nangmih ingawm nami koeinaa khqik khan awh qeenkhaw amna ming ngai awhtaw, khawk khan nakaw Pa ing nangmih ak khan awh ce amyihna sai lawt kaw,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesu ing vawhkaw awikhqi ak kqawn boet coengawh, Kalili qam ce cehta nawh Judah qam Jordan long caqai benna ce cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Thlang kqeng khawzah ing a hu awh hquut uhy, anih ing cekkhqi ce qoei sak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Amah ce noek adak ham Farasi thlang a vang ce a venna law uhy. “Thlang ing ikaw mai awh awm a zu ak thlaak aham ak thym hly nu?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Anih ing, “Ak cyk ca awh saikung ing pa ingkaw nu ce sai nawh, ");
INSERT INTO hltthb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","”Ve dawngawh pa ing a pa ingkaw a nu ce cehta nawh a zu ce tawm kaw, pakhih ce pynoet na awm hawh kawm nih,” a tice am nami noet khawi nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Cedawngawh cekqawi ce pakhih na am awm voel nawh, pynoet nani a awm hawh. Cedawngawh Khawsa ing pynoet na am khoep coeng hloeih taw thlanghqing ing koeh kqeng seh,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","A mingmih ing, “Cawhtaw kawtih Mosi ing zu thlaaknaak ca pe nawh zu ce ceh sak aham awi a peek bai hy voei?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Cawh Jesu ing, “Na mim thin a sah soeih a dawngawh ni Mosi ing zu thlaaknaak ham anik kqawn peek khqi. ");
INSERT INTO hltthb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ka nik kqawn peek khqi, a va ak khan awh a samphaih a dawngawh ti kaana, u ingawm a zu thla nawh nuk chang a zunaak awhtaw anih ce samphaih na awm hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","A hubatkhqi ing a venawh, “Zu lawh va taak naak awh ce myihna a awm mantaw, zu ama taak aham nep bet hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesu ing, “U ingawm vawhkaw awih kqawn ve am do thai ti kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Thlang pynoet taw a nu ak phoen khui awhkawng tiktleh cena thang nawh, thlang pynoet taw thlang ing tleh pehy; thlang a vang taw khan qam akawng awh zu amak ta thlang awm awm bai hy. Ak do thai saqui ing ve ve do seh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Naasenkhqik khan awh kut tloeng nawh cykcah peek aham, naasenkhqi ce Jesu a venna law pyi uhy. Cawh a hubatkhqi ing ak law pyikungkhqi ce zyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesu ing, “Naasenkhqi ce ka venawh law sak lah uh, koeh kham pe uh, kawtih khan qam taw vemyihna ak awm khqi aham nani,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Cekkhqi ak khan awh kut a tloeng coengawh, cawhkawng cet phaat hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Cawh thlang pynoet Jesu a venna law nawh, “cawngpyikung, kumqui hqingnaak ka huhnaak aham ikaw ka sai kaw?” tinawh doet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesu ing, “Ikaw hamna ik-oeih leek akawng ce nani doet? Ak leek pynoet doeng ni a awm. Hqingnaak ak khuiawh lut aham na ngaih awhtaw, awipeekkhqi ce sai thoeih ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Cawhkaw cadawng ing, “Ikawmih awipeekkhqi?” tina hy. Jesu ing, “Thlang koeh him, koeh samphaih, koeh qu, amak thym dyihthing na koeh awm, ");
INSERT INTO hltthb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Na nu ingkaw na pa zoeksang lah, na imceng ce namah na lung qunaak a myihna lungna lawt lah, a tice,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Cawhkaw cadawng ing, “Vekkhqi boeih taw ka naasen awhkawng sai boeih hawh nyng. Ikaw ka voet hyn bai?” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Cawh Jesu ing, “Thlak soep na awm aham na ngaih awhtaw, cet nawh na khawhthem khqi boeih na zawih coengawh hahqahkhqi ce pe law, cawhtaw khawk khan awh kawn them ta kawp ti. Cekcoengawh law nawh ka hu awh bat lah,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ce ak awi ce cadawng ing ang zaak awh, khawhthem khawzah a taak dawngawh kawseet doena cen valh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Cekcoengawh Jesu ing a hubatkhqi venawh, “Awitak ka nik kqawn peek khqi, boei ing khan qam na a lutnaak aham kyi soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kqawn law tlaih bai vang, boei ing Khawsa ram khuiawh a lut anglakawh, kalauk ing kqym ak khuiawh a lut zoei bet hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ce ak awi ce a hubatkhqi ing a ming zaak awh amik kawpoek kyi nawh, “Cawhtaw u nu thaawng na ak awm hly?” tinawh doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesu ing a mingmih ce toek nawh, “Ve ve thlanghqing a hamna taw am coeng thai hy, Khawsa a hamna taw ik-oeih boeih boeih ve coeng thai hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piter ing a venawh, “Toek lah, kaimih ingtaw ik-oeihkhqi boeih cehta u nyngsaw na hu awh bat u nyng! Cawhtaw ikaw ka mi huh kaw?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesu ing a mingmih a venawh, “Awitak ka nik kqawn peek khqi, ik-oeih boeih ak thai na awm nawh, thlanghqing Capa ing a boeimang ngawihdoelh awh ang ngawih awh, nangmih awm ngawihdoelh pahqa hlaihih awh ngawi kawm u tiksaw, Isarel phyn pahqa hlaihih ce awi deng kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","U awm kai ang ming awh, a imkhqi, a koeinaakhqi, a pa, a nu a cakhqi ingkaw a lokhqi ce ak cehtaakkhqi taw alet zakhat hlei leeknaak ingkaw kumqui hqingnaak ce pang kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Cehlai ak maa ce hu kawmsaw ak hu ce maa lat kaw.” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Khan qam taw dum ak takung thlang pynoet ing a dum khuiawh bi ak bi aham thlang ak sui na mymcang hqit awh ak cet ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bibikungkhqi mi hypoet kutphu denari pynoet peek aham awi ta unawh, cekkhqi ce misur dum na tyi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Khawnoek pathum tluk awh cet nawh, ik-oeih ami zawihnaak hyn awh ikaw awm amak sai thlangkhqi ce hu hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A mingmih a venawh, nangmih awm cet unawh kai a misur dum awh bibi lah uh, a ting a tawk taw ni pek khqi bit kawng, tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Cedawngawh a mingmih ce cet uhy.” Cekcoengawh khawnoek paquk ingkaw pakow tluk awh cet tlaih bai nawh, ce amyihna tina tlaih bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Khawnoek pahqa hlaioet tluk awh cet bai nawh, ak dyi mailai thlangkhqi ce hu bai hy. A mingmih a venawh, 'kawtih ikaw awm a sai kaana vawh khawnghi zung naming dyih?' tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Cekkhqi ing a venawh, 'u ingawm kaimih ve amni ceei khqi nawh ni,' tina uhy. Anih ing cekkhqi venawh, 'Nangmih awm cet unawh kai a misur dum awh bibi law lah uh,' tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","”Khaw a my awhtaw, misur dum ak takung ing, tangka ak khoemkungkhqi venawh, 'A hu dyt awhkawng ak lamma dy awh bibikungkhqi ce khy nawh amik thaphu ce pe lah uh,' tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Khawnoek hlaioet awhkawng bi ak bikhqi ce law unawh amik thaphu denari pynoet ce hu qip uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lamma na bi ak bikhqi ce law unawh ak doem bet hu kawng unyng, tina poek uhy. Cehlai cekkhqi awm denari pynoet qip ni ami huh lawt hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tangka ami huh boeih coeng awhtaw, dum ak takung ak khan awh saai bi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ahu na na law pyikhqi ing khawnoek pynoet khui doeng ni bi ami bi hy, hypoet khui khawk hlawk anglakawh bi ka mik bi kaimih mi ang amyihna na taak paqap,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Cehlai anih ing a mingmih ak khui awhkaw thlang pynoet a venawh, 'ka pyi, amak thym na nak khan awh ik-oeih am sai nyng, Denari pynoet nani awi ni taak ka ti my? ");
INSERT INTO hltthb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Namah a bibi phu ce lo nawhtaw cet hlah. Nang a venawh ka ni peek lawt amyihna ahu na bi ak bi thlang a venawh awm pe lawt kawng nyng. ");
INSERT INTO hltthb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ka tangka ak khan awh ka ngaihnaak amyihna saithainaak am ka ta hly nawh nu? Kai ka khawboe a leek awh nang ing nani yt nawh nu? tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Cedawngawh ak hukhqi ce ma kawm usaw ak maakhqi ce hu kawm uh. Ak khy taw doem kawmsaw ak tyk taw zawi kaw,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesu ing Jerusalem na a hang ceh awh, a hubat thlang pahqa hlaihih ce cehpyi nawh a mingmih a venawh, ");
INSERT INTO hltthb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tuh Jerusalem na ni hang cet kawm uh, thlanghqing Capa taw khawsoeih boeikhqi ingkaw anaa awi cawngpyikungkhqi venawh pe kawm uh, a mingmih ing thih sak aham thawlh sak kawm uh, ");
INSERT INTO hltthb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","qaihnaak na sai aham Gentelkhqi kut awh pe kawm uh. Am thum nyn awh tho tlaih kaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Cawh Zebedi a cakhqi a nu ing a ca qawi ce Jesu a venna law pyi nawh, khuk sym doena ak kawngaih pynoet sai sak aham qeennaak thoeh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesu ing a venawh, “Ikaw na ngaih?” tina hy. Cawhkaw nu ing, “vawhkaw ka capa qawi pakhih ve na ram khuiawh pynoet ve nak tang ben awh pynoet ce nak cawng ben awh ngawih law sak lah,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Cehlai Jesu ing a venawh, “Na thoeh ve am sim hy nik ti. Kai ing ka aawk hly kawi khuikha huhnaak boet ve na nik aw hly thai lawt nu? Baptisma ka huh hly kawi ve na nik hu hly thai lawt nu?” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesu ing cekqawi a venawh, “Kai a khuikha huhnaak boet ve aw hly thai tang tang nih nawh Baptisma ka huh hly kawi ve awm hu thai kawm nik ti, cehlai kai ak tang ben awh ngawih sak thainaak ingkaw cawng ben awh ngawih sak thainaak taw, kai a peek kawi am ni. Ka pa ing a hoep peek ce thlangkhqi venawh pe kaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ce ak awi ce thlang pahqa tloek ing a ming zaak awh, cekqawi cingna ak khan awh amik kaw so hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Cehlai Jesu ing cekkhqi ce a venna khy khqi boeih nawh, “Gentelkhqi ingtaw a mimah khqik khan awh uknaak ce ta unawh, ukkungkhqi ing a mingmih ak khan awh uk thainaak ce ta uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Cehlai nangmih anglakawhtaw ce myihna am awm kaw. Nangmih ak khuiawh ak bau soeih na awm ak ngaih ingtaw nangmih a bi ak bikung na awm seh, ");
INSERT INTO hltthb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","u awm nangmih anglakawh lamma cyk na awm ak ngaih taw nangmih a tamnaa na awm seh; ");
INSERT INTO hltthb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Thlanghqing Capa ing thlang bibi sak aham am law nawh, thlang a bibi peek aham nani a law, thlang khawzah thaawngnaak aham a hqingnaak ak pe hamna ni a law,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesu ingkaw a hubatkhqi ing Jeriko khaw ce ami cehtaak awh thlang kqeng ing ahu awh hquut uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Cawh mikhyp thlang pakhih ce lam keng awh ngawi hy nih, Jesu a ceh awi ce a ning zaak awh, “Bawipa, David Capa, kainih ve nim qeen qawi lah!” tinawh khy hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Thlang kqeng ing cekqawi ce a ni awmnaak dym aham zyi uhy, cehlai cekqawi ing khawteh khqoet na, “Bawipa, David Capa, kainih ve nim qeen qawi lah!” tinawh khy khqoet hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Cawh Jesu ce dyi nawh cekqawi ce khy hy. “Ikaw sai sak aham nu nani ngaih?” tinawh doet qawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Cekkqawi ing, “Bawipa, mik dai aham ngaih nih nyng,” tina hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesu ing cekqawi ce qeen nawh cekqawi a mik ce bi pehy. Cawh cekqawi ce ani mik dai pahoei nawh ahu awh bat pahoei hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalem pha tawm unawh Olive tlang awhkaw Bethphage khaw ami pha awh, Jesu ing a hubat thlang pakhih ce haina tyi hy, ");
INSERT INTO hltthb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Cekkqawi a venawh, “Nani haiawh ak awm khawk khuina cet nih nawhtaw meqang ca ingkaw a nu ami king ce hu kawm nik ti. A qui ce hlam nih nawh ka venna sawi law nih. ");
INSERT INTO hltthb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","U ingawm anik kaanaak qawi awhtaw, Bawipa ing ngoe hy, thak law tlaih bit kaw, tina nih,” tinak qawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Vawhkaw ik-oeihkhqi boeih taw tawngha ing anak kqawn hyt ce a soepnaak a hamna ni: ");
INSERT INTO hltthb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zion canu ce kqawn pe, 'Na sangpahrang kawdaw ing meqang awh, meqang noca awh ngawi kawmsaw law kaw,” a tice. ");
INSERT INTO hltthb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A hubat qawi ce cet nih nawh Jesu ing awi a peek qawi amyihna sai hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Cekkqawi ing meqang a nu ingkaw ak noca ce hawlaw hy nih, meqang ak khan awh hi phaih pe nih nawh, ak khan awh Jesu ce ngawih sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Thlang kqeng khawzah ing hikhqi ce lam awh phaih pe uhy, thlang vang ing thingbupkhqi ce chawm unawh lam awh phaih pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Haina ak cetkhqi ingkaw hu nakaw ak law thlang kqeng ing, “David capa venawh Hosanna! Bawipang ming ing ak law taw a zoseen seh!” “Sawsang soeih awh Honsanna!” tinawh khy uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusalem khawk khui na Jesu a lut awh, khawk bau ce tyn nawh, “Ve ak thlang ve u nu ti?” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Thlang kqeng ing, “Ve ak thlang taw Kalili qam Nazareth khaw awhkaw tawngha Jesu ni,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesu ing bawkim khuina lut nawh bawkim khuiawh ik-oeih ak zawi ingkaw ak thlai thlangkhqi ce hqek hy. Tangka ak hlengkhqi a caboeikhqi awm khup phlet pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","A mingmih a venawh, “Ka im ve cykcahnaak im ni, ti kawm uh,” tinawh a qee hyt awm hlai hy, nangmih ingtaw quk-aikhqi awmnaak hyn na sai u hyk ti,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mikhypkhqi ingkaw khawkhemkhqi ce a venawh bawkim na law unawh, anih ing cekkhqi ce qoei sak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Cehlai khawsoeih boeikhqi ingkaw anaa awi cawngpyikungkhqi ing kawpoek kyi ik-oeih a saikhqi ingkaw naasenkhqi ing bawkim a keng awh, “David capa venawh Hosanna,” tinawh amik khy ce ami huh awh amik kaw am law hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","”Naasenkhqi ing amik kqawn ce nak za nu?” tinawh Jesu ce doet uhy. Jesu ing, “Oeih, 'Naasenkhqi ingkaw naasenkhqi am kha awhkawng zoeksangnaak ce ta hawh hyk ti,' a tice am nami noet khawi nawh nu?” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","A mingmih ce a cehtaak coengawh, Bethany khaw na cet nawh, cawh ce ip hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","A khawngawi mymcang hqit awh khawk bau na ang hlat tlaih awh ak phoen cawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Lam a keng awhkaw thai thing ce hu nawh, a hang ceh awh ahah doeng kaa taw ikaw awm am hu hy. Thai thing na ce, “Koeh qah qoe voel,” tina hy. Cawh thai thing ce khawng pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","A hubatkhqi ing ami huh awh amik kawpoek kyi hy, “Ikawmyihna thai thing ak khawng paqap hy voei?” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesu ing a mingmih a venawh, “Awitak ka nik kqawn peek khqi, ypvoetnaak a taak kaana cangnaak nami taak awhtaw, thai thing awhkaw sai na ak awm doeng ve am sai thai kawm uk tik saw, vawhkaw tlang a venawh awm, 'Cet nawh tuicunli na thoeih lah,' nami tinaak awhtaw thoeih kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Namik cangnaak awhtaw cykcahnaak ing nami thoeh ce hu kawm uk ti, “tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesu ing bawkim khuina lut nawh thlang a cawngpyi huili awh, khawsoeih boeikhqi ingkaw a hqamcakhqi a venawh law unawh doet uhy, “Hanakaw saithainaak ing vawhkaw ik-oeihkhqi ve na sai? Vawhkaw saithainaakkhqi ve u ing ani peek?,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesu ing, “Awi pynoet ni doet khqi cang vang. Nami nim hlat awhtaw, hanakaw saithainaak ing vemyih ik-oeihkhqi ka sai tice nik kqawn pek khqi kawng. ");
INSERT INTO hltthb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Johan a Baptisma ce hana kaw nu ce? Hana kawng a law, khawk khan nakaw nu am awhtaw thlang a ven awhkawng nu?” tinak khqi hy. Cawh a mimah ingkaw a mimah ce doet qu unawh, “Khawk khan benna kaw niti naak man, 'cawhtaw kawtih amna mik cangnaak,' niti nak khqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Thlang a ven awhkawng ni, niti bai man thlang nik kqih koek bai, thlang kqeng ing Johan ce tawngha ni a mi ti a dawngawh,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Cedawngawh, “Am sim nyng,” tina uhy. Cawh Jesu ing, “Cawhtaw hana kaw saithainaak ing vemyih ik-oeihkhqi ka sai, tice ap kqawn hly lawt nyng,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ikawmyihna nangmih ing namik poek? Cakpa pakhih ak ta ak thlang pynoet awm hy. A capa a hqam a venawh cet nawh, 'Ka capa, tuhngawi awh misur dum na cet nawh bibi lah,' tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Am cet tikawng,' tina hlai hy ahu na ak kaw hlat nawh cet tlaih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Cekcoengawh a pa ce a capa ak chang a venna cet bai nawh ce amyihna tina bai hy. Anih ingtaw, 'cet bit kawng,' tina hy, cehlai am cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Ce pakhih ak khuiawh u ing nu a pa ak kawngaih a sai?” tinak khqi hy. Cekkhqi ing, “Lamma awhkawng,” tina uhy. Jesu ing a mingmih a venawh, “Awitak ka nik kqawn peek khqi, mangmu ak cawikungkhqi ingkaw pum ak zawikhqi ing nangmih ve Khawsa qam khuina ni cehtaak khqi kaw ve. ");
INSERT INTO hltthb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ikawtih Johan ce nangmih dyngnaak lam ak huh na law hy, cehlai nangmih ing am cangna uhyk ti, mangmu ak cawikhqi ingkaw a pum ak zawikhqi ing cangna uhy. Ve ve hu hawh utik seiawm, am zut utik saw anih ce am cangna u hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nyhtahnaak awi ak chang pynoet ve ngai bai lah uh: Dum ak takung thlang pynoet awm nawh anih ing misur ce ling hy. Dum ce chung hqeet nawh, misur suinaak ce co nawh a qehnaak ipsang ce sa hy. Cekcoengawh loh phlo thlangkhqi ce dum awh bibi sak aham a ceei coengawh amah ce khawk hla na cet valh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Misur qah bih tym a pha awh, misur qah ak bit aham a tyihzawih thlangkhqi ce dum qehkungkhqi venna tyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Dum awh bi ak bikhqi ing cawhkaw tyihzawihkhqi ce tu unawh pynoet ce vyk uhy, pynoet ce him uhy, pynoet bai ce lung ing khaawng uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Cawh dum ak takung ing lamma awhkawng lak awh tyihzawih ak chang khawzah ce tyi bai hy, cehlai dum awhkaw bi ak bikhqi ing ak cyk awhkaw amyihna sai tlaih bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","A hukhit nataw cekkhqi venawh amah a capa ce tyi hy. 'Ka capa taw kqihchah na bit kawm uh,' tina poek hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Cehlai cekkhqi ing, 'Vetaw qo ak pangkung ni ve. Law lah uh, him unawh a qo lawh pe usih,' ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Anih ce tu unawh ami him coengawh vawng ak kep na khaawng uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Cedawngawh, misur dum ak takung ce law nawh, cawhkaw dum awh bi ak bikhqi ce ikawmyihna a sai kaw? tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Cekkhqi ing, “Cawhkaw thlak thawlhkhqi ce ak tlo soeih na him kawmsaw, cawhkaw misur dum ce a qah tym a pha awh ak thaih ak pe hly thai kawi thlak chang a venawh ceei kaw,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesu ing cekkhqi venawh: “Im ak sakungkhqi ing ami qoeng lung ce, a kil awhkaw ak khoeng soeih na awm hawh hy; ve ve Bawipa ing sai nawh, ningnih amik huh awh kawpoek kyi na awm hy, 'tinawh Awihciim awh ak awm ce am nami noet khawi nawh nu?' ");
INSERT INTO hltthb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Cedawngawh ka nik kqawn peek khqi, cemyih lawtna nangmih a ven awhkawng Khawsa qam ve lawh na awm kawmsaw ak thaih ak qah sakkungkhqi venawh pe kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Vawhkaw lung awh ak bahkhqi taw kqek kawm usaw, lung ing ang tluuk khqi ce a dik a huina neet kaw,' tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Khawsoih boeikhqi ingkaw Farasikhqi ing Jesu a nyhtahnaak awi ce a ming zaak awh cekkhqi akawng ni ak kqawn hy tice sim uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Anih a mim tunaak thai aham lam ce sui uhy, cehlai thlang kqeng ing anih ce tawngha ni, a mi ti a dawngawh thlang kqeng ce kqih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesu ing cekkhqi venawh nyhtahnaak awi kqawn pek khqi tlaih hy: ");
INSERT INTO hltthb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Khan qam taw sangpahrang pynoet ing a capa aham zulawh poeoi a sai ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Zulawh poei awh buh veel aham a tyihzawihkhqi ce tyi nawh thlang khy sak hlai hy, u awm law aham am ngaih uhy: ");
INSERT INTO hltthb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Cekcoengawh ak chang tyihzawihkhqi awm tyi tlaih bai nawh, 'ka ceei thlangkhqi venawh, buh veel aham qoek abah oepchoeh hawh nyng. Zulawh poei buh veel aham law uh tina uh, tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Cehlai kawna awm am ngai pe unawh, a mimah a ngaih ngaih na cehta uhy. Pynoet ing lo na cehta nawh, pynoet ing ak chang bibinaak na cehta hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ak chang ak awm tloek ing cawhkaw tyihzawihkhqi ce tu unawh, thekhanaak ing chah phyih sak unawh him uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Sangpahrang ing ce ce ang zaak awh ak kaw so hy. A qalkapkhqi ce tyi nawh thlang ak himkhqi ce a him sak coengawh, cekkhqi a khaw ce mai ing dawi sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Cekcoengawh a tyihzawihkhqi venawh, zulawh poei buh taw oepchoeh na awm hawh hy, cehlai ka ceei thlangkhqi ce buh veel aham am kawih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cedawngawh lamkilkhqi awh cet unawh thlang nami huh saqui ce buh veel aham ceei law uh, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Cedawngawh tyihzawihkhqi ce lam saqui awh cet unawh ami huh saqui thlangkhqi ce cawi uhy, thlak che awm thlak leek awm, zulawh poei buh ce ak behyp na veel uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Cehlai sangpahrang ing khinkhqi toek aham a law awh, zulawhnaak hi amak bai thlang pynoet ce hu hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","A venawh, 'ka pyi, ikawmyihna zulawhnaak hik kaana vawh na lut law?' tina hy. Cawh anih ce awi am pau qoe hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sangpahrang ing a tyihzawihkhqi venawh, vawhkaw thlang ve a kut a khaw pin pe unawh, kqangnaak ingkaw hatahnaak a awmnaak a leng ben khawmthannaak na ce khaawng uh, tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ikawtih khawzah khy hlai hy, ak tyh taw a khoehca ni, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Cawh Farasikhqi ce cet unawh anih ak awih kqawnnaak awh a thawlhnaak tu peek aham doet qu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","A mimah a hubatkhqi ingkaw Herod a hubatkhqi ce Jesu a venna tyi uhy. Cekkhqi ing, 'Cawngpyi kung', nang taw ak thym kqawn nawh Khawsa lam ce awitak ing cawngpyi hyk ti tice sim unyng. Thlang ak kawngaih awm am qoei tiksaw, a u a haai awm am toek hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ikawmyihna nak poeknaak kqawn law lah? Kaisar a venawh mangmu peek ve ak thym nu? tina u hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Cehlai Jesu ing a mingmih ang cainaak amak leek ce sim nawh, “Nangmih thlang qaai kqawnkhqi', kaw hamna kai a thawlhnaak tu aham nami sui? ");
INSERT INTO hltthb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mangmu na nami peek tangka ce nim huh lah uh,”, tinak khqi hy. A mingmih ing denari pynoet ce khyn pe uhy, ");
INSERT INTO hltthb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","cawh anih ing, “U ang myihlip nu ve? U ang ming nu a mi qee ve?” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Cekkhqi ing, “Kaisar,” tina uhy. Cawh anih ing, “Kaisar a them ce Kaisar a venawh pe unawh, Khawsa a them ce Khawsa venawh pe uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ce ak awi ce a ming zaak awh, amik kawpoek kyi hy. Cedawngawh anih ce cehta unawh ak chang na cen uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ce nyn awh ce thlak thi thawh tlaihnaak am awm hy amik ti Sadusikhqi ce a venna law unawh awi doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Cawngpyikung, thlang pynoet ing a ca ataak kaana a thih man a naa ing anih a zu ce zu na kawmsaw anih aham ca taak pekaw, tinawh Mosi ing nik kqawn pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kaimih anglakawh cingnahqui thlang khqih awm hy. Lamma cyk ing a zu lo moe ca taak kaana thih tahy, cedawngawh a zu ce a naa ing pang hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Cemyihna a voei hihnaak, am thumnaak ingkaw ak khqihnaak dyna awm hqui hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ahu na taw cawhkaw nu ce awm thi lawt hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Cawhtaw thawh tlaih nyn awh cawhkaw nu ce khqih ak khuiawh a u a zu na nu a awm kaw, zu na boeih u saw? tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesu ing, “Khawsa a cak ciim ingkaw Khawsa a saithainaak am nami sim a dawngawh, nangmih ing poek thawlh hawh u hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Thawh tlaihnaak nyn awh chungvanaak ingkaw zulawhnaak awm am awm voel kaw; khawk khan awhkaw khan ceityihkhqi amyihna va awm hawh kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Thlak thikhqi thawh tlaihnaak awh, Khawsa ing nangmih a venawh ak kqawn law ce am nami noet nawh nu. ");
INSERT INTO hltthb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Kai taw Abraham Khawsa, Isaak Khawsa, Jakob Khawsa na awm nyng, a tice? Anih cetaw thlak thikhqi a Khawsa am nawh ak hqingkhqi a Khawsa ni,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Thlang kqeng ing anih ak awi ce a ming zaak awh a cawngpyinaak awh amik kawpoek kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesu ing Sadusikhqi awi am pau sak khqi qoe hy, tice Farasikhqi ing a ming zaak awh, pynoet na cun uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","A mingmih ak khuiawh anaa awi ak thoem thlang pynoet ing anih ce noek adak nawh doet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Cawngpyikung, anaa awi ak khuiawh ikawmyih awipeek nu ak bau soeih?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesu ing, “Bawipa na Khawsa ce nak kawlung boeih, na hqingnaak boeih, na lingbyi boeih ing lungna kawp ti”. ");
INSERT INTO hltthb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ve ve awipeek lamma cyk ingkaw ak bau soeih na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A pakhihnaak taw vemyihna awm hy: 'Na imceng ce namah a pum amyihna lungna lawt kawp ti,' tive ni. ");
INSERT INTO hltthb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Anaa awi boeih ingkaw tawnghakhqi ak awi boeih vawhkaw awipeek pakhih awh cui boeih hawh hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farasikhqi ce pynoet na a ming cun awh, Jesu ing doet khqi hy, ");
INSERT INTO hltthb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Khrih akawng ve ikawmyihna namik poek?” tinak khqi hy. A mingmih ing, “David capa,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesu ing a mingmih a venawh, “Cawhtaw ikawmyihna David ing, Myihla ak caming anih ce, “Bawipa,” a ti bai hy voei? Anih ing, ");
INSERT INTO hltthb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Bawipa ing ka Bawipa a venawh: Na qaalkhqi ce ka khawk kaina ka taak hlan dy, kak tang ben awh ngawi lah, a tice. ");
INSERT INTO hltthb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David ing anih ce 'Bawipa' tinawh ak khy awhtaw, ikawmyihna anih ce a capa na a awm hly thai hy voei? tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","U ingawm anih a doetnaak ce khang oet awm am hlat pe thai uhy, ce nyn awhkawng taw u ingawm awi am doet hqa voel hy. ");
INSERT INTO hltthb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Cekcoengawh Jesu ing thlang kqeng ingkaw a hubatkhqi venawh awi kqawn pehy. ");
INSERT INTO hltthb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Vemyihna tina hy, “Anaa awi cawngpyikungkhqi ingkaw Farasikhqi ing Mosi a ngawihdoelh awh ngawi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Cedawngawh a mingmih ing amik kqawn saqui ce ngai pe kawm utik saw sai pe kawm uk ti. Cehlai a mingmih amyihna ik-oeih koeh sai law uh, a mingmih ingtaw a mimah ing amik kqawn ce am sai uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","A mimah a phyihqih ak qih soeih ce thlang ak phleng awh tloeng pe uhy, cehlai a mimah ingtaw ami kutply kangnaa ingawm cawhkaw ik-oeihkhqi ce thoeih aham am ngaih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ik-oeih soepkep ami sai ce thlang a huh aham doeng ni ami sai hy: Ami talqi ingkaw ami baan awhkaw a bawm taw ak tla soeih na sai unawh ami hibai ce a vawkthawk na tlaak sak uhy; ");
INSERT INTO hltthb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","poei buhkungkhqi awh thlang a zoeksang ngaih unawh Sinakawk khqang awh ngawihnaak ak nep nep ingkaw; ");
INSERT INTO hltthb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ik-oeih zawihnaak hyn awh thlang ing kqihchahnaak a peek khqi, 'Cawngpyikung' tinawh amik khykhqi ce lungna uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nangmih taw Boei pynoet doeng ni nami taak hy, nangmih taw cingnahqui na awm u hyk ti, cedawngawh nangmih ce, 'Cawngpyikung' tinawh am nik khy khqi tikaw. ");
INSERT INTO hltthb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Cekcoengawh khawmdek awh 'ka pa' tinawh koeh khy law uh, kawtih nangmih taw khawk khan na ak awm Pa pynoet doeng ni nami taak. ");
INSERT INTO hltthb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","'Cawngpyikung' am ti kawm uk ti, cawngpyikung pynoet doeng ni nami taak, anih taw Khrih ni. ");
INSERT INTO hltthb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nangmih ak khuiawh ak bau soeih taw nangmih a tyihzawih na awm seh. ");
INSERT INTO hltthb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","U awm amah ingkaw amah ak zoeksang qu taw ak kaina thlaak na awm kawmsaw, u awm ak kaina ak awm taw zoeksang na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nangmih qaai kqawn Farasikhqi ingkaw anaa awi cawngpyikung khqi, khaw map uhyk ti! Nangmih ing thlang a haiawh khan qam ce khaih pe uhyk ti. Na mimah awm am kun uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nangmih qaai kqawn anaa awi cawngpyikungkhqi ingkaw Farasikhqi khaw map uhyk ti! Nuhai cakhqi imkhqi ce qawt pe unawh, thlang a huh awh ak dung soeih na cykcah uhyk ti. Cedawngawh nangmih ve khawzah khqoet thawlh kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Nangmih qaai kqawn anaa awi cawngpyikungkhqi ingkaw Farasikhqi khaw map uhyk ti! Thlang pynoet qung nami huhnaak thai aham tuicunli ingkaw khawmdekkhqi leh plep unawh cet uhyk ti, thlang ce nami huh awhtaw na mimah let hih hell aca na sai uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nangmih sawikung mikhyp tloek, khaw map uhyk ti! U ingawm bawkim ang ming phoei nawh awi a kam awhtaw ikawna awm am coeng lawk hy; cehlai u ingawm bawkim awhkaw sui ang ming phoei nawh awi a kam awhtaw, ak awi ngaan hy, ti uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nangmih mikhyp thlakhqawkhqi! Hannu ak bau khqoet: sui nu, am awhtaw sui ak ciimcaih sak bawkim nu? ");
INSERT INTO hltthb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Bawkthang ang ming phoei nawh awi a kam awhtaw kawna am coeng hy; cehlai ce bawkthang ak khan awhkaw zoepeek ik-oeih ang ming phoei ing awi a kam awhtaw, ak awi ce ngaan hy ti bai uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nangmih mikhypkhqi! Hannu ak bau khqoet: Ak khan awhkaw zoepeek ik-oeih nu, am awhtaw ak khan awhkaw ak ciimcaih sak bawkthang ce nu? ");
INSERT INTO hltthb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Cedawngawh, u ingawm bawkthang ang ming phoei nawh awi a kam awhtaw bawkthang ingkaw ak khan awhkaw ak awm them pek ang ming phoei ing awi kam haih hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","U ingawm bawkim ang ming phoei nawh awi a kam awhtaw bawkim ingkaw ak khuiawh ak awm ingqawi ang ming phoei nawh awi kam haih hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","U awm khan ang ming phoei nawh awi a kam awhtaw Khawsa a ngawihdoelh ingkaw ak khan awhkaw ak ngawi ang ming phoei ing awi kam haih hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nangmih qaai kqawnkhqi ingkaw anaa awi cawngpyikungkhqi ingkaw Farasikhqi, khaw map uhyk ti! Nangmih ing sawngsingkhqi, cynqykkhqi ingkaw paipoengkhqi dyna pahqa awh pynoet ce pe uhyk ti. Cehlai anaa awi awhkaw awihtung na ak awm - thymnaak, qeennaak ingkaw ypawmnaakkhqi ce kawna am ngai uhyk ti. Lamma awhkawk khqi ce dalqa naak kaana ahu awhkawk khqi ve awm nami sai aham awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nangmih sawikung mikhypkhqi! Pica taw ciit hlai uhyk ti kalauk ce daih lat hawh uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nangmih anaa awi cawngpyikungkhqi ingkaw Farasi thlak qaai kqawnkhqi khaw map uhyk ti! Caboei ingkaw beei ce ak khan ben taw sil hawh hlai uhyk ti, ak khui ben taw qaai kqawnnaak ingkaw a pyh ngaihnaak ing be uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farasi mikhypkhqi! Caboei ingkaw beei ak khui ben ce sil ma cang uh, cawhtaw ak khan ben ce awm ciimcaih kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nangmih anaa awi cawngpyikungkhqi ingkaw Farasi thlak qaai kqawnkhqi khaw map uhyk ti! Phyi, ak khan awh a baawk ing thuut nawh ak khan awh ni toek awhtaw nep soeih hlai hy, ak khui awhtaw thlak thi a quh ingkaw amak caih a soep a hoei ing ak be ing myih uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Cemyih lawtna nangmih ve ak khan ben awhtaw thlak dyng amyihna awm hlai uhyk ti, ak khui ben awhtaw qaai kqawnnaak, thawlhnaak ing be uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nangmih anaa awi cawngpyikungkhqi ingkaw Farasi thlak qaai kqawnkhqi khaw map uhyk ti! Tawngha khqik phyi ce sa u tiksaw thlak dyngkhqik phyi taw thawi a cam uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nukdam pakdamkhqi khuk awh ana awm mai nyng seiawm, tawnghakhqi thisen lawng saknaak awh amna paa ti kawng, ti uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tawnghakhqi ak himkung a cadil na nami awmnaak ce na mimah ing dyih pyi nawn hawh uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nami pakdamkhqi thawlh ang lawngnaak ce be sak ngala hlah uh. ");
INSERT INTO hltthb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nangmih khquikhqi! Kqui a cadilkhqi! Ikawmyihna hell khui awhkawng nami loet pai kaw? ");
INSERT INTO hltthb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Cedawngawh tawnghakhqi, thlak cyikhqi ingkaw cawngpyikungkhqi ce tyi law kawng. A vang ce him kawm u tiksaw thinglam awh taai kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Cedawngawh nangmih ak khan awh thlak dyng Abel awhkawng bawkim ingkaw bawkthang anglakawh nami him Berekiah a capa Zekariah dyna khawmdek awh ak lawng thlak dyngkhqi boeih a thi ce nangmih ak khan awh awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Awitak ka nik kqawn peek khqi, vemyihkhqi boeih ve vawhkaw cadilkhqik khan awh law kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Aw Jerusalem, Jerusalem, nang tawnghakhqi ak himkung ingkaw na venawh tyih na ak awmkhqi lung ing ak deepkung, aainu ing a cakhqi ang hlak khuiawh a khawl a cui amyihna, na cadil izah nu khawl a cui aham ang hlah ce, cehlai nang ingtaw am ngaih hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Toek lah na im ve a hqawng nani cehtaak hyt na a awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ikawtih ka nik kqawn peek khqi, ‘Bawipa ming ing ak law taw a zoseen hy,’ tinawh nak kqawn hlan dy taw kai ve amni hu voel kawm uk ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesu ing bawkim ce cehta nawh ak chang na cet hy, cawh a hubatkhqi ing bawkim huh aham a venna law uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Cekkhqi na ce, “Vawhkaw ik-oeihkhqi boeih ve nak hu nu? Awitak ka nik kqawn peek khqi, vawhkaw lung ak phoeng qu ve pynoet awm am awm kaw, khaawng boeh boeh kawm uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesu ing Olive tlang awh ang ngawih awh, a hubatkhqi ce a venna law dym uhy. “Vawhkaw ik-oeih ce ityk awh nu a awm kaw, nang na lawnaak ingkaw tym a dyt hatnaak ce kawmyihna a awm kaw, kqawn law lah,” tinawh doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesu ing, “Thlang ing ama ni thainaak khqi aham nami cyih ta lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ikawtih kai ang ming ing thlang khawzah law kawm usaw, 'Kai ni Khrih,' ti kawm uh, thlang khawzah ce thai na kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Qaal tuknaak ingkaw cem a qaal awithang ce za hlai kawm uk ti koeh ly uh. Cemyih ik-oeihkhqi ce ak awm hly qoe ni, cehlai a dytnaak ce law hyn kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Thlang phyn ingkaw thlang phyn tuk qu kawm usaw, qam ingkaw qam awm tuk qu kawm uh. Penglum awh khaw se kawmsaw lipi tlaai kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Vemyihkhqi taw naa a awm hly awhkaw tlawh ak kqannaak hyn mai ni. ");
INSERT INTO hltthb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Thlangkhqi ing thekhanaak aham ingkaw thih sak aham thlang a kut awh ni pek khqi kawm uh, kai a dawngawh thlang phyn boeih ing nangmih ce ni sawh nak khqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Cawh thlang khawzah ing cangnaak ce a mi cehtaak coengawh a mimah ingkaw a mimah nawn ce thak qu kawm usaw sawh qu na kawm uh, ");
INSERT INTO hltthb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","tawngha qawl khawzah awm kawmsaw thlang khawzah ce thai na kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Thawlhnaak a pung hqui hawh a dawngawh, lungnaak awm sit hawh kaw, ");
INSERT INTO hltthb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","cehlai ang dyt dyna ak dyi phat khqi taw thaawng na awm kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ce qam awithang leek ve thlang phyn boeih a venawh simpyikung na a awmnaak thai aham, khawmdek penglum awh khypyi na awm kaw, cekcoengawh a dytnaak ce law kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Cedawngawh nangmih ing hyn caih khuiawh, Daniel ing anak kqawn amyihna - ak noetkung ing zasim seh - 'qam ak sit sak tuih ak awm ik-oeih,' ce nami huh awh, ");
INSERT INTO hltthb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Judah qam khuiawh ak awmkhqi ce tlang na cen u seh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Iptih na ak awmkhqi ing ik-oeih ak lo na koeh kqum voel seh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Lo na ak awm thlang ing a hi ak lo na koeh hlat qoe voel seh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Cawh ak phyihsukhqi ingkaw naa ak pawm nukhqi aham ikawmyih aih nanu a kyi kaw! ");
INSERT INTO hltthb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Cawhkaw nangmih nami cennaak hly a tym ce chikca ingkaw sabath nyn awh ama pha law naak aham cykcah uh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ikawtih khawmdek a awm cyk awhkawng amak awm man ingkaw ityk awh awm amak awm hly voel kyinaak ce am law kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Cawhkaw khawnyn ce ama tawi sak awhtaw, u awm am syng tikaw, cehlai ak tyh thlangkhqi ak caming a khawnyn ce tawi sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Cawh u ingawm, 'Vawh ni Khrih a awm,' am awhtaw 'cawh ni a awm,' ani tinaak khqi awhtaw koeh cangna uh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Khrih na ak sa qukhqi ingkaw tawngha qawl khqi awm kawmsaw, ang coeng thai mantaw ak tyh thlangkhqi za thainaak aham hatnaak ak bau soeihkhqi ingkaw kawpoek kyi ik-oeihkhqi ce sai kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ngai lah uh, oepchoeh cana kqawn law hawh nyng ve. ");
INSERT INTO hltthb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Thlang ing, 'kqawng na ni, anih a awm,' ani tinaak khqi awhtaw, koeh cawn uh; cemyih am awhtaw, 'Ipkhui awh ni anih a awm,' ami ti awh awm koeh cangna uh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Khawlaw benna khaw a phla awh khawng tlaak dyna ni huh amyihna thlanghqing Capa a law awh ce amyihna awm lawt kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sa qaawk a awmnaak hoei awh, langtahkhqi ce awm kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kyinaak khawnynkhqi ce a awm coengawh, 'khawmik ce than kawmsaw khan sai thainaakkhqi ce thloek kaw'. ");
INSERT INTO hltthb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Cawh thlanghqing Capa a hatnaak ce khawk khan awh dang kaw, khawmdek awhkaw thlang phynkhqi boeih ce khy am kqang kawm uh. Thlanghqing Capa ing boeimang saithainaak ing khawk khan myi awhkawng a law ce hu kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Anih ing ak khan ceityihkhqi ce uut ak awi ing tyi kawmsaw, khawk khan pynoet ben a dytnaak awhkawng pynoet ben dyna, ak tyh thlangkhqi ce khawmdek kili awhkawng caawi kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Thai thing awhkawng ve ve cawng lah uh: a paang awh keh nawh a hahno ak cawn awhtaw, khawhqai tym zoe hawh hy ti sim uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Cemyih lawtna, nangmih ing vawhkaw ik-oeihkhqi boeih ve nami huh awh, anih taw zoe hawh hy, chawmkeng awh dyi hawh hy, tice sim uh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Awitak ka nik kqawn peek khqi, vawhkaw ik-oeihkhqi a awm hlan dy taw ve a khuk awhkaw thlangkhqi ve am khum kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Khawk khan ingkaw khawmdek taw khum hlai voei, kak awi taw am khum qoe qoe tikaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Cawhkaw khawnyn ingkaw a tym ce u ingawm am sim hy, khawk khan nakaw khan ceityihkhqi ingawm, Capa ingawm am sim hy, Pa doeng ing ni a sim. ");
INSERT INTO hltthb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noah a khuk awhkaw amyihna, thlanghqing Capa a law awh awm lawt kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tuiliu a law hlanawh thlangkhqi ing ai unawh aw uhy, chungva qu unawh zulawh poeikhqi sai uhy, Noah ing lawng khuina a lut dy ce amyihna awm uhy; ");
INSERT INTO hltthb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","tuiliu a law hlan dy awhtaw ikaw ak law kaw, tice am sim uhy, cawh tuiliu ing a mingmih ce khyn khqi boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Thlang pakhih lo awh awm kawm nih; pynoet ce lo kawmsaw pynoet ce cehta kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nu pakhih sum deeng kawm nih; pynoet ce lo kawmsaw pynoet ce cehta kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Cedawngawh ityk awh na Bawipa a law kaw tice am nami sim a dawngawh qalqiing ing awm lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Cehlai ve ve sim lah uh: ip takung ing ityk awh quk-ai a law kaw tice a sim oet oet mantaw, ak nep na ana qeh kawmsaw a im ce am muk sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Cedawngawh nangmih awm qalqiing na awm lah uh, nangmih ing am namik poek tym awh thlanghqing Capa ce law kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Cawhtaw tyihzawih ypawm thlak cyi, a boeipa ing a ipkhui awhkaw a tyihzawihkhqi boeih ak khan awh ukkung na ta nawh a tym a khoek awh a mingmih buh a an peek aham a taak thlang ce u hy voei nu ce? ");
INSERT INTO hltthb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Cemyihna ik-oeih ak sai, boeipa ing ang voei awh a huh tyihzawih cetaw a zoseen kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Awitak ka nik kqawn peek khqi, a khawhthem ik-oeihkhqi boeih ak khan awh anih ce ukkung na ta kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Cehlai cawhkaw tyihzawih ce thlak che na awm nawh, 'Ka boeipa taw ak hla nani a awm,' ");
INSERT INTO hltthb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","tinawh tyihzawih ak changkhqi ce a vyk coengawh zukhqui thlangkhqi mi zu ce aw mai lah seh. ");
INSERT INTO hltthb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","A boeipa ce amak poek a khawnyn ingkaw ama sim a tym awh ce law plak kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","A boeipa ing anih ce chawm kawmsaw thlang qaai kqawnkhqi a huh hly kawi ce huh sak lawt kaw, ce a hyn awh kqangnaak ingkaw haatahnaak ce awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Cawh khan qam taw nulak cym thlang pahqa ing zuk lokung do aham mai-im pawm unawh ak cetkhqi ing myih qu kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cekkhqi ak khuiawh pumha tloek taw qaw unawh pumha tloek taw cyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ak qaw tloek ingtaw mai-im ce khyn lawt hlai uhy maitui am khyn uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Cehlai ak cyi tloek ingtaw maitui ingkaw a uum ce mai-im ingqawi khyn qen uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Zuk lokung ama law hqet a dawngawh, a mingmih boeih ce ami mik ku nawh ip uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Thanlung law awhtaw, zuk lokung law hawh hy,! Ak do na cet hlah uh! tinawh khy na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Cawh nulak cyikhqi boeih ce tho unawh mai-im ce dawi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nulak qaw tloek ing ak cyikhqi venna, maitui ni pe thoem lah uh, mai-im thi hawh kaw ve, tinak khqi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ak cyi tloek ing, 'Amni, nangmih ingkaw kaimih aham am khoek tikaw. Maitui ak zawikhqi venna cet unawh nami ham thlai cang uh,' tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Cehlai maitui ak thlai na ami ceh tloek awh, zuk lokung ce law hy. Oepchoeh na ak awm nulak cyikhqi taw zulawh poei khuina zuk lokung mi lut haih uhy. Cekcoengawh chawh ce khaai uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ahu na ak changkhqi ce law lawt uhy, 'Bawipa! Bawipa! kaimih chawh nim awng khqi lah! tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Cehlai anih ing, 'Awitak ka nik kqawn peek khqi, amni sim khqi nyng,' tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Cedawngawh khawnghi ingkaw a tym ce am nami sim a dawngawh qalqiing na awm lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Cek coeng bai awh khan qam taw thlang pynoet ing qam ak hla soeih na cet nawh, a tyihzawihkhqi ce ak khy coengawh cekkhqi venawh khawhthem a khoem sak ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A mimah a saithainaak qip amyihna, thlang pynoet a venawh tangka talen pumha pehy, thlang pynoet a venawh tangka talen pakhih pe nawh ak chang pynoet a venawh talen pynoet pehy, cekcoengawh khawlawng na cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tangka talen pumha ak hu ing cet nawh cawhkaw tangka ing bi a binaak coengawh a meek pumha huh sih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Cemyih lawtna, tangka talen pakhih ak hu ingawm a meek pakhih huh sih bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Cehlai tangka talen pynoet ak hu thlang ingtaw cet nawh, dek co nawh a boeipa a tangka ce thuh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Khawnghi khawqyt a di coeng awhtaw a mingmih a boeipa ce law nawh a tangka kawng ce kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Cawh tangka talen pumha ak lo ing a meek pumha ce hawlaw nawh law hy. 'Bawipa talen pumha ni khoem sak hyk ti, toek lah a meek pumha huh sih nyng ve,' tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","'A boeipa ing, nep hy, tyihzawih leek ingkaw ypawm! Ik-oeih a khoehca awh ypawm na na awm a dawngawh, ik-oeih khawzah ak khan awh ukkung na ni ta kawng. Na boeipa zeelnaak ak khuiawh kan lah! tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Cekcoengawh tangka talen pakhih ak hu ce awm law nawh, 'Bawipa tangka talen pakhih ni khoem sak hyk ti; toek lah, a meek pakhih huh sih nyng ve!' tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Bawipa ing, nep hy, tyihzawih leek ingkaw ypawm! Ik-oeih a khoehca awh ypawm na na awm a dawngawh, ik-oeih khawzah ak khan awh ukkung na ni ta kawng. Na boeipa zeelnaak ak khuiawh kan lah! tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Cekcoengawh tangka talen pynoet doeng ak hu thlang ce law hy. 'Bawipa, nang taw thlak cyyp na awm hyk ti, am na sawnaak awh awm aat tiksaw, camci am nak thehnaak awh awm cawi hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ka nik kqih dawngawh cet nyng saw nang a tangka ce dek khuina thuh nyng. Toek lah, na koe ve, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","A boeipa ing, 'Nang thlak che tyihzawih thakdam! Kai ing am ka sawnaak awh aat nawh am kak thehnaak awh ka cawi ce sim zawk hyk ti my? ");
INSERT INTO hltthb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Cawh man tangka ak thungkhqi kut awh ka tangka ve ta tiksaw ka law tlaih awh ka tangka ce a ca ingqawi ka huhnaak voei. ");
INSERT INTO hltthb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","A ven awhkaw talen ce lawh pe unawh talen pahqa ak ta a venawh pe uh. ");
INSERT INTO hltthb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ikawtih ak ta thlang a venawh sap pek khqoet kawmsaw khawzah ta kaw. Amak ta thlang cetaw, a taak ang cang awm lawh pe kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kawna awm amak nyt tyihzawih thlang ce a leng ben thannaak na khawng uh, cawh ce kqangnaak ingkaw hatahnaak awm kaw, tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Thlanghqing Capa ing amah a boeimangnaak ingkaw khan ceityihkhqi boeih mi a law awh, khan boeimangnaak ngawihdoelh awh ngawi kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Thlang phynkhqi boeih a haaiawh cun kawm usaw, tuukhaikung ing mee ak khui awhkawng tuukhqi a hoep amyihna anih ing thlangkhqi ce pek a qee kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tuukhqi ce ak tang benawh ta kawmsaw meekhqi ce ak cawng benawh ta kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Cekcoengawh sangpahrang ing ak tang ben awhkaw thlangkhqi venawh, 'Law lah uh, nangmih ka Pa ing zoseennaak a peek thlangkhqi, khawmdek a syn cyk awhkawng nangmih aham a sai cee qam ce pang lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kak phoen a cawih awh buh ni pe hyk ti, tui ka ngaih awh tui ni pe hyk ti, khin na ka awm awh ni pah sak hyk ti, ");
INSERT INTO hltthb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","hi ka ngaih awh hi ni bai sak hyk ti, ka tlawh awh ni hqip ni toek hyk ti, thawngim kang tlaak awh ni hqip hyk ti, tina kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Cawh thlak dyng ing a venawh, Bawipa, ityk awh nak phoen a cawih awh buh ka mi ni peek? Tui na ngaih awh tui ka mi ni peek? ");
INSERT INTO hltthb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ityk awh khin na awm nawh ka mi ni pah sak? Hik kaana na awm awh hi ka mi ni peek? ");
INSERT INTO hltthb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ityk awh na tlawh awh ka mi ni hqip? ti kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Cawh sangpahrang ing a mingmih a venawh, 'Awitak ka nik kqawn peek khqi, vawhkaw koeinaa ak zawi khytkhqi ak khuiawh pynoet a venawh ik-oeih nami saikhqi boeih ce kai a venawh nami sai hawh ni,' tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Cekcoengawh ak cawng benawh ak awmkhqi venawh, nangmih khawsi ak hawikhqi ka ven awhkawng cet uh, qaai ingkaw ak khan ceityihkhqi aham a sai peek hyt kumqui mai khuina cet uh. ");
INSERT INTO hltthb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ikawtih kak phoen a cawih awh buh amni pe uhyk ti, tui ka ngaih awh tui amni pe uhyk ti, ");
INSERT INTO hltthb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","khin na ka awm awh am ni pah sak uhyk ti, hi ka ngaih awh hi amni pe uhyk ti, tlo nawh thawngim kang tlaak awh am ni hqip uhyk ti, tinak khqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Cawh cekkhqi ing, 'Bawipa, ityk awh nang nak phoen a cawih, tui na ngaih, khin na na awm, hi kaana na awm, na tlawh, thawngim tla nawh am ka mi bawm thai? tina kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Cawh anih ing, 'Awitak ka nik kqawn peek khqi, vawhkaw ak zawi khyt koeinakhqi aham am na sai ce kai aham am na sai hawh ni,' tinak khqi kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Cek coeng awhtaw a mingmih ce kumqui khuikhanaak a hyn na cet kawm usaw, thlak dyngkhqi taw kumqui hqingnaak ak khuina cet kawm uh,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesu ing ve ak awikhqi ak kqawn coengawh, a hubatkhqi venawh, ");
INSERT INTO hltthb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","”Nami sim a myihna, Loentaak poei taw khaw hih voei doeng ni a ngaih hawh hy. Cawh thlanghqing Capa taw thinglam awh taai aham thlang a kut awh pe kawm uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Cawh khawsoeih boeikhqi ingkaw a hqamcakhqi ce khawsoeih boei soeih Kaiapha a im awh cun uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jesu ce zoek nawh am tu coengawh him aham kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Cehlai poei khui awhtaw koeh sai usih, thlang kqeng anglakawh awipungnaak awm hau kaw, ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesu taw Bethany khaw awhkaw mynqai ak neh Simon a im na a awm awh, ");
INSERT INTO hltthb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","a venawh nu pynoet ing alabaster um awh bawktui a phu ak tlo soeih ce hawlaw nawh, caboei awh buh a veel huili awh syp na hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","A hubatkhqi ing a mi huh awh, amik kaw so hy. Ikaw hamna vemyihna ak plak? ");
INSERT INTO hltthb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","A phu khawzah na zawi nawh tangka ce hahqahkhqi pe thaw voei, ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesu ing ce amyihna a mi ti ce a sim awh, 'Ikaw hamna vawhkaw nu ve nami lawl plak? Anih ing them ak leek soeih ce kak khan awh sai hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Hahqahkhqi taw nangmih a venawh awm quiqah kawm uh, cehlai kai taw nangmih a venawh am awm phat tikawng. ");
INSERT INTO hltthb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Vawhkaw nu ing bawktui ing ka pum a ni sypnaak vetaw ka qawk vyinaak aham a sai hawh ni. ");
INSERT INTO hltthb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Awitak ka nik kqawn peek khqi, khawmdek pum awh vawhkaw awithang leek amik kqawnnaak hoei awh, anih ing kak khan awh a sai law ve amah simpoenaak aham kqawn kawm uh,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Cawh a hubat thlanghqa hlaihih ak khui awhkaw thlang pynoet - Judah Iskariot ing, khawsoeih boei soeih a venna cet nawh ");
INSERT INTO hltthb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","doet hy, nangmih a kut awh anih ce ka ni peek khqi awhtaw ikaw nami ni peek kaw? tina hy. Cekkhqi ing tangka sawmthum peek aham awi ta uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Cekcoengawh Juda ing anih ce am tunaak thai aham a tym leek ce sui hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hen amak pa phaihpi poei a hyp oet naak nyn awh, a hubatkhqi ce Jesu a venna law unawh doet uhy, “Loentaak poei buh ainaak aham han awh nu sai sak aham na ngaih?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Anih ing, “Khawk bau khui awhkaw thlang pynoet a venawh cet nawh cawngpyikung ing: ka tym taw zoeca hawh hy. Ka hubatkhqi mi loentaak poei buh na im na veel kawng u nyng, tihy tina,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Cedawngawh Jesu ing ak kqawn peek amyihna a hubatkhqi ing loentaak poei ce sai pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Khaw a my law awhtaw, a hubat thlanghqa hlaihih tloek mi buh veel uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Buh a mi ai huili awh, a mingmih a venawh, “Awitak ka nik kqawn peek khqi, nangmih ak khui awhkaw thlang pynoet ing kai ve thlang a kut awh ni thak kaw,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Cawh a mingmih ce amik kaw se nawh a venawh, “Bawipa, kai aw?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesu ing, “Kai ingqawi beei ak zoep haih ing kai ve thlang nim tu sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Thlanghqing Capa taw amah akawng qee hyt na a awm hawh amyihna cet kaw. Cehlai thlanghqing Capa thlang a kut awh ak thakkung ce khaw na map hy! Anih ce ama thang mantaw nep bet hlai voei,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Cawh amah ce thlang a kut awh ak pe hly Juda ing, “Kai aw cawngpyikung?” tina hy. Jesu ing “Oeih, nang hawh ni,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Buh ami vel huili awh, Jesu ing phaihpi lo nawh, zeelawi ak kqawn coengawh thek hy, a hubatkhqi venawh pe nawh, “Lo unawh, ai lah uh, ve ve ka sa ni,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Cekcoengawh boet awm lo bai nawh, zeelawi ak kqawn coengawh a mingmih a venawh pehy, “Aw boeih lah uh; ");
INSERT INTO hltthb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Vetaw awikamnaak ka thi, thlang khawzah a thawlh qeenkhaw ngainaak aham ka hawk ni. ");
INSERT INTO hltthb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ka nik kqawn peek khqi, ce nyn awh ka Pa qam awh ak thai na nangmih mi amni aawk hlan dy taw vawhkaw misur tui ve tuh awhkawng am aw voel tikawng nyng,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Laa pynoet ami sak coengawh, Olive tlang na cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Cawh Jesu ing a mingmih a venawh, “Tawh than awh kai ak camawh nangmih boeih tlu kawm uk ti, “Tuukhaikung ve vyk kawng nyngsaw, tuukhqi boeih a mi ngaih ngaih naak na kqeng kang kawm uh,” tinawh a qee hyt hawh a myihna. ");
INSERT INTO hltthb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Cehlai ka thawh tlaih coengawh, nangmih a haaiawh Kalili na ana cet kawng,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piter ing, “Nang ak camawh ak changkhqi boeih tlu u seiawm kai ingtaw am ning tluuk taak qoe qoe kawng nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu ing, “Awitak ka nik kqawn peek khqi, tawh than qoe awh, ai ang khawng hlanawh thum voei nik khawng kawp ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Cehlai Piter ing, “Na thihnaak awh thih aham awm mai nyng seiawm, ityk awh awm am nik khawng qoe qoe tikawng,” tina hy. A hubatkhqi boeih ingawm ce amyihna ti lawt uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Cekcoengawh Jesu taw Gethsemane a mi ti hyn na a hubatkhqi mi cet uhy; a hubatkhqi venawh, “Cena cykcah aham cet hly nyng, vawh a nang ngawi uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Piter ingkaw Zebedi a caqawi ce ceh pyi hy, ak kaw se nawh ang ngaih kyi soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A mingmih a venawh, “Thihnaak khqawh kawseetnaak ing ka hqingnaak ni vui malh hawh hy. Vawh awm unawh ni qeh pyi lawt lah uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A hlanaak benna va cet nawh dek awh a koep coengawh cykcah hy, “Ka Pa, ang coeng thai awhtaw, vawhkaw boet ing ni qei seh nyng; cehlai kai ak kawngaih na koeh awm seitaw nang ak kawngaih myihna awm seh nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A hubatkhqi venna a law awh a mingmih ce ip boeh boeh uhy. Piter a venawh, “Khawnoek pakhat khui kangna awm am nami qeh pyi thai nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Syknaak ak khuiawh am naming tluuknaak thai aham qeh unawh qalqiing doena cykcah lah uh. Myihla ingtaw ngaih hlai hy, pumsa ingtaw zai hqoeng hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ahih voeinaak cet nawh cykcah bai hy, “Ka Pa, vawhkaw boet ing a ni qei ham am coeng thai voel nawh aawk aham a awm vik awhtaw namah ak cam seh,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A law tlaih bai awhtaw, a mingmih ce mikku ing a noeng khqi a dawngawh ana ip tlaih bai uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Cedawngawh a mingmih ce cehta nawh a thum voeinaak na ak cykcah khawi amyihna cykcah bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Cekcoengawh a hubatkhqi venna law nawh a mingmih a venawh, “Ip unawh dym bak bak uhyk ti my? Toek lah uh, a tym khoek hawh hy, thlanghqing Capa taw tu sak aham thlak thawlhkhqi kut pe hawh uhy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","“Tho uh, cet hlah usih! Kai thlang anik tu sakkung taw vawh awm hawh hy ve!” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Awi ak kqawn hui awh, thlanghqa hlaihih ak khui awhkaw thlang pynoet, Juda ce pha law hy. Khawsoih boeikhqi ingkaw a hqamcakhqi ven awhkaw tangboek cimca ingkaw thingboeng amik pawm thlang kqeng ce law pyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Thlang a kut awh ak thakkung ing huhsimnaak ce sai pe hy: “Kai ing ka mawk thlang cetaw anih hawh ni, anih ce tu uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jesu a venna cet pahoei nawh, Juda ing, “Cawngpyikung na sa dip seh!” a tinaak coengawh mawk hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesu ing, “Ka pyi, nani law sihnaak ce sai,” tina hy. Cawh thlangkhqi ce haina thoeih unawh, Jesu ce tu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Cawh Jesu ing anik awm haih thlang pynoet ing ak cimca ce phlawng nawh, khawsoeih boei a tyihzawih ang haa ce zek pe hlak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesu ing a venawh, “Nak cimca ce sapangkawp awh chan tlaih lah, u awm cimca ak phlawng taw cimca ing thi lawt kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Khan ceityih qalkap bu pahqa hlaihih ce tuh qoe awh tyih law aham, ka Pa a venawh am thoeh thai tikaw, tinawh namik poek nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ce myihna a awm mantaw ikawmyihna Bible awi ing ak kqawn hyt ce a soepnaak kaw? tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Cawh Jesu ing thlang kqeng a venawh, “Nangmih ing kai ve quk-ai a myihna, cimca ingkaw thingboeng ing kai tu aham nami law nawh nu? Myngawi tempul khuiawh thlang cawngpyi nyng, cawh am nim tu uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Cehlai tawnghakhqi ak caqee a soepnaak aham ve ik-oeih ve a awm aham awm hy,” tinak khqi hy. Cawh a hubatkhqi boeih ing amah ce ta hyt unawh cen ta uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Amah ak tukhqi ing Jesu ce anaa awi cawngpyikungkhqi ingkaw a hqamcakhqi ang cunnaak, khawsoeih boei soeih Kaiapha im na khyn uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Cawh Piter ing khawsoeih boei soeih a im dyna ak hla nakawng a huhu awh qym hy. Ikawmyihna nu a mi sai law kaw tice sim a ngaih a dawngawh ak khuina ce lut nawh cawhkaw im ak qehkungkhqi venna ngawi lawt hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Khawsoih boeikhqi ingkaw Sanhedrinkhqi ing Jesu a thawlhnaak ce tu pe nawh thih sak thainaak aham awi ce deng uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Amak thym thawlh puknaakkhqi ce khawzah awm hlai hy, a thawlh ce am tu pe thai uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","A hukhit na taw thlang pakhih ce haina law nih nawh ve ak thlang ing, 'Kai ing Khawsa a tempul ce hqe nyngsaw khaw thum voei khuiawh sa tlaih kawng nyng tinawh kqawn hy,' tina hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Cawh khawsoeih boei soeih ce hang dyi nawh Jesu a venawh, “Am nam hlat hly nawh nu? Vekkqawi ing nang thawlh anik puk ve ikawmyihna a awm?,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Cehlai Jesu ing awmtaak dik dik hy. Khawsoih boei soeih ing, “Ak hqing Khawsa ming phoei doena ni doet nyng: Nang ve Khrih, Khawsa Capa tang nu?” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesu ing, “Oeih, nak kqawn a myihna awm nyng, Nangmih boeih a venawh kqawn law nyng: Tuhkawng awh thlanghqing Capa ing boeimang soeih ak tang benawh ngawi kawmsaw khan myi awhkawng a law ce hu bit kawp ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Cawh khawsoeih boei soeih ing a hibai ce theek nawh, “Khawsa the a kha na hawh saw kaw ve! Kaw hamna simpyikung ni ngoe hly bai? Khawsa a thekhanaak awi ning za hawh saw kaw. ");
INSERT INTO hltthb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ikawmyihna na mik poek? tinak khqi hy. Cawh a mingmih ing, “A thih aham awm hy,”, tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","A haiawh sawh unawh kuthlym ing thawng uhy. Thlang vang ing bei uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“U nu anik bei, nang Khrih, kqawn lah?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piter ing kawngma awh ang ngawih awh tyihzawih nuca ce law nawh a venawh, “Nang awm Kalili thlang Jesu a venawh nak awm lawt ni,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Cehlai Piter ing cekkhqi boeih a haiawh oelh hy. “Nak kqawn ce am sim nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Vawng chawmkeng benna a ceh awh nu pynoet ing hu bai nawh, cawhkaw ak awmkhqi venawh, Ve ak thlang ve Nazareth Jesu ingqawi awm haih lawt hy nih,” tina bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Cawh seet awi lawh doena: “Ve ak thlang ve am sim nyng,” tinak khqi bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Cawh a khoeh a awm coengawh a keng awhkaw ak dyikhqi ing, Piter a venna, “Nang awm amingmihkhqi lakawhkaw thlang lawt ni, nak awi pau awh sim hqa hawh hy,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Anih ing, “Ce ak thlang am sim nyng.” tinawh seet awi am saa awhkawng ai khawng pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Cawh, Piter ing Jesu ak awikqawn, “Ai ang khawng hlanawh nang ing thum voei nik khawng kawp ti,” a ti ak awi ce sim law hy. Cekcoengawh a lengna cet nawh kqang hlawp hlawp hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","A khawngawi mymcang hqiit awh, khawsoeih boeikhqi boeih ingkaw a hqamcakhqi boeih ce law unawh Jesu ce him aham awi kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jesu ce ami pin coengawh sawi unawh, qam ukkung boei Pilat a venna khyn uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Amah thlang a kut awh ak thakkung, Juda ing Jesu a mi thawlh sak ce a huh awh, zut nawh tangka sawmthum ce khawsoeih boeikhqi ingkaw a hqamcakhqi venawh bal tlaih hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Thawlh soeih hawh nyng, thawlhnaak amak ta a thi ce kai ing thlang a kut awh pe hau hawh nyng,” tinak khqi hy. Cekkhqi ing, “Kaimih ingtaw kaw ka mi tinaak hly nu? Namah ak cam hawh ni,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Cedawngawh Juda ing tangka ce bawkim ak khuina khawng nawh cehta hy. Cekcoengawh cet nawh kaiaawk hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Khawsoih boeikhqi ing tangka ce lo unawh, “Ve a tangka taw thi phu na a awm a dawngawh, tangka bawm khuiawh chan aham am caih hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Cedawngawh cawhkaw tangka ing khin ak thikhqi pupnaak aham am ak sepkung a lo ce thlaih na uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Cedawngawh cawhkaw lo ce tuh dyna “Thi hyn” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Cedawngawh tawngha Jeremiah ing anak kqawn ce soep hawh hy: “Isarel thlangkhqi ing anih a phu ak ting na amik poek tangka sawmthum ce lo unawh, ");
INSERT INTO hltthb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bawipa ing awi a ni peeknaak amyihna, a mingmih ing am ak sepkung a lo ce amik thlaihnaak aham haw na uhy,” a ti ce. ");
INSERT INTO hltthb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Qam ukkung boei a haaina Jesu ang dyih awh, qam ukkung ing doet hy, “Nang ve Judakhqi a sangpahrang aw?” tina hy. Jesu ing, “Nak kqawn amyihna awm nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Khawsoih boeikhqi ingkaw a hqamcakhqi ing thawlh amik puk awh, awi khangoet awm am hlat hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Cawh Pilat ing a venawh, “Nangawh thawlh ami nik puk am nang za nawh aw? tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Cehlai anih ing awi khangoet awm am hlat qoe qoe hy, cedawngawh qam ukkung taw ak kawpoek kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Poei awh thlang kqeng ing ak tyh thawk tla thlang pynoet ce qam ukkung ing a hlah peek khawi na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Cawh ang ming ak thang thawk tla thlang pynoet, Barabbas a mi tice thawngim khuiawh awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Thlang kqeng kutoet na aming cun awh, “U nu hlah sak aham nami ni ngaih: Barabbas nu, am awhtaw Khrih a mi ti Jesu ve nu?” tinawh Pilat ing doet khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jesu ce ami yt a dawngawh ni a venna ami law pyi, tice a sim a dawngawh. ");
INSERT INTO hltthb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilat ce awidengnaak ngawihdoelh awh ang ngawih awh a zu ing vawhkaw awi ve a venawh pat pehy: “Cawhkaw thawlhnaak amak ta thlang ce kaw awm koeh ti law na, anih a dawngawh cimthan kang mang awh khuikha nyng,” tinawh awi cah hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Cehlai khawsoeih boeikhqi ingkaw a hqamcakhqi ing, Barabbas ce hlah nawh Jesu ce him sak aham thlang kqeng ce zoek khqi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ram ukkung boei ing, “Thlang pakhih ak khuiawh u nu ka ni hlah peek khqi kaw tinawh doet hy. A mingmih ing, “Barabbas,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Cawhtaw Khrih a mi ti Jesu vetaw ikawmyihna ka tinaak kaw?” tinawh Pilat ing doet khqi hy. Cekkhqi boeih ing, “Thinglam awh taai!” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilat ing, “Kawtinawh nu? Ikaw thawlhnaak a sai a dawngawh nu?” tinawh doet khqi hy. Cehlai cekkhqi ing khawteh khqoet na, “Thinglam awh taai! Thinglam awh taai!” tinawh khy khqoet khqoet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kawmyihna awm saithainaak am awm voel hawh nawh, thlang kqeng ing saai hlyk khqoet khqoet uhy, tice Pilat ing a huh awh, tui lo nawh thlang kqeng a haaiawh a kut ce sil hy. “Ve thlak dyng a thi awhkawng kai taw caih nyng. Na mimah a hut hawh ni, nami ngaihnaak a myihna sai uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Cawhkaw amik awm thlangkhqi boeih ing, “Anih a thi ce ka mimah ingkaw ka mi cakhqi ing hawi mai bit kawng unyng,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Cedawngawh Barabbas ce hlah pek khqi hy. Cehlai Jesu taw a vyk coengawh, thinglam awh taai aham a mingmih a kut awh pehy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Cekcoengawh qam ukkungkhqi a qalkapkhqi ing Jesu boei a ipkhuina khyn uhy, cawh qalkapkhqi boeih boeih ce anih a venawh cun uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ahi ce suh pe unawh hik thim ce bai sak uhy, ");
INSERT INTO hltthb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","hling ing ami tah lumyk ce a lu awh myk sak uhy. Sawnghqawl ce ak tang benawh amik pawm sak coengawh a haaiawh khuk sym pe unawh thekha na uhy. “Juda sangpahrang na hqinglung kyi seh!” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Cimtui ing sawh, a sawnghqawl ce lawh pe unawh a lu awh vyk uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","A mi thekhanaak coengawh, hi ce suh pe tlaih bai unawh amah a hi ce bai sak tlaih bai uhy. Cekcoengawh thinglam awh taai aham cehpyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","A mi ceh awh, Cyqene khaw awhkaw Simon ak mingnaak thlang pynoet ce hu unawh, thinglam ce anaa na kawh sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Golgotha a mi ti hyn ce pha uhy (luqawng hyn tinaak ni). ");
INSERT INTO hltthb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Misur tui ak thui ce ik-oeih ak kha ing kqiit unawh aawk sak uhy; am tan coengawh aawk aham tha na hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Thinglam awh ami taai coengawh a hi ce taicung zyk unawh tei uhy. Cetaw “Ka hi ce taicung zyk unawh qek kawm uh,” tinawh tawngha ing anak kqawn hyt awi ce a soepnaak aham ni. ");
INSERT INTO hltthb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ngawi unawh anih ce qeh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A luk khan awh: VE TAW JUDA SANGPAHRANG JESU NI, tinawh thawlh amik puknaak ca ce qee unawh taai pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Quk-ai pakhih awm, pynoet ce ak tang benawh pynoet ce ak cawng benawh anih ingqawi thinglam awh taai qen uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Cawhkaw ak cetkhqi ing anih ce kaa na unawh the a kha na uhy, ami lu khyp sih unawh ");
INSERT INTO hltthb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","”Nang tempul hqe nawh khawnghi thum voei khuiawh ak sa tlaih, namah ingkaw namah ce hul qu lah thoeih ti! Khawsa Capa na na awm awhtaw thinglam awhkawng nuk kqum law lah thoeih ti!” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Cemyih lawtna, khawsoeih boeikhqi anaa awi cawngpyikungkhqi ingkaw a hqamcakhqi ingawm the a kha na uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Thlak chang taw hul hlai hy, amah ingkaw amah taw am hul qu thai hy! Isarel sangpahrang na awm hlai hy! Tuh thinglam awhkawng nuk kqum law lah seh, cawhtaw anih ce cangna kawng unyng. ");
INSERT INTO hltthb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Khawsa ce a ypnaak koenoek; Khawsa ing a ngaih awhtaw tuh hul lah seh nyng, 'Khawsa Capa na awm nyng,' a ti koenoek,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Cemyih lawtna amah ingqawi thinglam awh a mi taai haih quk-ai qawi ingawm kaa na hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Khawnoek paquk awhkawng pakow dy dek awh khaw than hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Khawnoek pakow tluk awh Jesu ing khawteh na, “Eloi, Eloi, Lama sabachthani” tinawh khy hy. (Cetaw, “Ka Khawsa, ka Khawsa, kawtih nani cehtaak?” tinaak ni.) ");
INSERT INTO hltthb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Cawhkaw amik dyi thlang vangkhqi ing a ming zaak awh, “Elijah ni ak khy hy,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","A mingmih anglakawhkaw thlang pynoet ing tui ak dawp thai ik-oeih ce lo nawh misur tui ak thuui awh ce a nawk coengawh cungkui awh tlet nawh Jesu ce awk sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Cawhkaw amik awm thlangkhqi ing, “Amah poek awh awm na lah seh. Elijah law nawh ak hul hly nu, toek lah usih, tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Cawh Jesu ce khawteh na khy nawh kawn zip hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Amah cek phoeih awh ce tempul ak khuina kaw hizan ce a saw awhkawng ak kai dy pakhih na teek qu hy. Khawmdek tlai nawh lungkhqi ce kqek hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Phyikhqi awng qu nawh thlak ciim ak thikhqi pum awm khawzah tho hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Phyi khui awhkawng tho unawh, Jesu a thawh tlaih coengawh khawk bau ciim khuina ce lut unawh thlang khawzah a venawh dang pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Qalkap zakhat ak ukkung ingkaw a venawh ak awm phyi ak qehkhqi ing liipi ang tlaai ingkaw cawhkaw ik-oeihkhqi boeih ce a mi huh awh kqih unawh, “Anih ve Khawsa Capa tang tang ni, ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Cawh ce Kalili nakawng Jesu a hu awh bat nawh ak dodan nukhqi khawzah awm lawt uhy, khawsang nakawng anih ce qeh unawh dan uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Cekkhqi taw Meri Magdalene, Jakob ingkaw Joses a nu Meri ingkaw Zebedi a cakhqi nu tloek ce awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Khawmy ben a pha awhtaw Arimathai khaw awhkaw thlang boei pynoet, Jesu a hubat pynoet na ak awm Joseph ce law hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilat a venna cet nawh, Jesu a qawk ce thoeh hy, Pilat ing Jesu a qawk ce peek aham awi pehy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joseph ing Jesu a qawk ce a lawh coengawh, hi ak caihca ing zawl hy, ");
INSERT INTO hltthb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","a phyi ak thai, thel a suk hqeet ak khuiawh ce ta hy. Phyi chawmkeng ce lung ak bau soeih ing tleng nawh cehta hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri Magdalene ingkaw ak chang Meri ce phyi a haai benawh ngawi hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A khawngawi, coek qoeknaak khawnghi a boeih coeng, awh khawsoeih boeikhqi ingkaw Farasikhqi kutoet na Pilat a venna cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","”Bawipa amah a hqing tloek awh, thlang qaai kqawnkhqi ing, 'Am thum nyn awh tho tlaih kawng,' a ti amik kqawn ce za u nyng. ");
INSERT INTO hltthb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Cedawngawh am thum nyn dy awh phyi ce ak leek na a mi qehnaak aham awi pe lah. Cemih am awhtaw, cimthan awh a hubatkhqi law unawh a qawk ce a mim quuk coengawh, thlangkhqi venna anih taw thihnaak awhkawng tho tlaih hawh hy, tinawh kqawn kawm uh. Cawhtaw ahu nakaw thainaak awi ce ak cyk awhkawng lak awh nauh khqoet kaw,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat ing, “Ak qeh hly kawi qalkapkhqi ta u tiksaw kaw. Cet unawh phyi ce nami saithainaak khuiawh ak khoeng na qeh law sak khqi uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Cekkhqi ce cet unawh lung awh hatnaak a mi deeng coengawh, phyi ce ak khoeng na qalkapkhqi qeh sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabath nyn boeih nawh, khaw khqih nyn ak khuiawh lamma cyk khaw a dai tawm ca awh, Meri Magdalene ingkaw ak chang Meri ce phyi ak toek na cet hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Cawh liipi khawteh na tlaai nawh, Bawipa khan ceityih pynoet ce khawk khan nakawng kqum law nawh, phyi na ce cet hy, lung ce thoeng nawh ak khan awh ce ngawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A myi taw khawkphlamyihna awm nawh, a hi taw vyl amyihna baawk hy. ");
INSERT INTO hltthb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Phyi ak qehkhqi ing a mik kqih aih awh thyn unawh thlak thi amyihna awm hqoeng uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Khan ceityih ing nu qawi a venawh, “Koeh kqih nih, thinglam awhkaw ami taai, Jesu sui hy nihk ti tice sim nyng. ");
INSERT INTO hltthb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Vawh am awm voel hy; ak kqawn amyihna tho hawh hy. Law nih nawh ang zaihnaak a hyn ce toek lah nih. ");
INSERT INTO hltthb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ang tawnna cet nih nawh a hubatkhqi venawh kqawn pe nih: 'thihnaak awhkawng anih taw tho hawh nawh nangmih a haaiawh Kalili na cet hawh hy. Cawh anih ce hu kawm uk ti,' tina nih. Nik kqawn pek kqawi hawh nyng,” tina qawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Cawhkaw nu qawi ing anik kqih doena zeelnaak ing a hubatkhqi venawh kqawn peek aham dawng hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Cawh Jesu ing cekqawi ce hqum qawi pahoei hy. “Nani sa dip seh,” tina qawi hy. A venna cet nih nawh, a khaw awh a ni kaawp coengawh bawk hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Cekcoengawh Jesu ing cekqawi a venawh, “Koeh kqih nih, ka koeinaakhqi ce Kalili awh ceh aham kqawn law pe nih; cawh ce kai ni hu kawm uh,” tina qawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Cawhkaw nu qawi ce a ni ceh hui tloek awh, phyi amik qeh thlang vang tloek ce khawk bau khuina cet unawh khawsoeih boeikhqi venawh cawhkaw ik-oeihkhqi ce kqawn pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Khawsoih boeikhqi ing a hqamcakhqi mi kutoet na ngawi unawh doet qu uhy, cekcoengawh qalkapkhqi ce tangka khawzah pe uhy, ");
INSERT INTO hltthb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","““A hubatkhqi cimthan awh law unawh ka mi ih tloek awh a nam qu uhy, tinawh kqawn uh. ");
INSERT INTO hltthb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ve ak awi ve qam ukkung ing ang zaak hau awhtaw, kaimih ing hloep kawng unyng saw nangmih ce loet bit kawm uk ti,” tinak khqi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Cedawngawh qalkapkhqi ing tangka ce do unawh cekkhqi ak awi yn amyihna kqawn uhy. Ce ak awi ce tuhdy awh Juda khqing lak awh kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Cekcoengawh hubat thlanghqa hlaioet tloek ce Kalili qam awhkaw, Jesu ing ak kqawn peek khqi tlang na ce cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Amah ce hu unawh bawk uhy; cehlai thlang vang ingtaw upvoet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesu ing a mingmih a venna cet nawh, “Khawk khan ingkaw khawmdek awh saithainaak boeih boeih ce ka venawh peek na awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Cedawngawh cet unawh thlang phyn boeih ce ka hubat na sai law unawh, Pa, Capa ingkaw Ciim Myihla ang ming awh Baptisma pe law uh. ");
INSERT INTO hltthb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kai ing awi ka ni peek khqi boeih ve a mi hquutnaak aham cawng law pyi uh. Ngai lah uh, khawmdek a dyt dyna, nangmih a venawh awm loet kawng nyng,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Khawsa Capa, Jesu Khrih awithang leek ak kqannaak taw ve myihna awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tawngha Isaiah ing: “Ka ceityih ce na haiawh tyi law kawng nyngsaw, anih ing na lam ce qoek abah law kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ramkoh awh ak khy awi ing, 'Bawipa a lam ce qoek abah unawh, a lamkhqi ce dyng sak lah uh, a tice. ");
INSERT INTO hltthb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Johan ce law nawh thawlh qeenkhaw ngainaak aham zutnaak baptisma akawng ce kqawn nawh qamkoh awh baptisma ce pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judah qam awhkaw thlangkhqi boeih ingkaw Jerusalem awhkaw thlangkhqi boeih ce anih a venna cet uhy. Ami thawlhnaakkhqi ce kqawn unawh, cekkhqi ce Johan ing Jordan long awh baptisma pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johan ing kalauk myi hina bai nawh, ak cawi ce savyn ing zeen hy, khamkhawk ingkaw khawitui ce buh a an na ai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Anih ing vemyihna kqawn hy: “Kai ahu na kai anglakawh ak bau khqoet thlang law hyn kaw, kai taw koep doena anih a khawmyk qui ak hlam peek aham awm am kawih nyng. ");
INSERT INTO hltthb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kai ing nangmih ve tui ing baptisma ni pek khqi nyng, cehlai anih ingtaw Ciim Myihla ing baptisma ni pek khqi kaw,” tinawh kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Cawh Jesu taw Kalili qam Nazareth khaw awhkawng law nawh Johan ing Jordan tui awh baptisma pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesu tui awhkawng a hang law awh, khan ce awng qu nawh Myihla ce ak khan awh kqukkqu amyihna ak khan awh cuuk pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","”Khan nakaw ing: “Nang taw ka ni lungnaak ka Capa ni, nak khan awh zeel soeih nyng,” tinawh awi ce law hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","A khoeh phoeih awh Myihla ing anih ce qamkoh na tyi pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Qamkoh awh ce khawnghi sawmli awm nawh, Setan ing sykzoek hy. Qamsakhqi mi awm haih unawh khan ceityihkhqi ing anih ce cuncah uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Johan ce thawng na amik thlak coengawh, Jesu taw Kalili qam na cet nawh, Khawsak awithang leek ce kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","”A tym khoek hawh hy, Khawsa ram taw zoe hawh hy, zut unawh awithang leek ve cangna lah uh!” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesu ing Kalili tui keng na a ceh awh, Simon ingkaw ana Andrew lawk anik khawng ce hu qawi hy, cekqawi taw ngakhawikung na awm hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Cekqawi a venawh, “Ka hu awh bat law lah nih, thlang ak tukung na ni tak qawi vang,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Cekkqawi ing lawkkhqi ce cehta nih nawh anih a hu awh bat pahoei hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Cawhkawng va cet kqoep saw, Zebadi a caqawi Jakop ingkaw ana Johan, lawng ak khuiawh lawk anik bu ce hu hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Cekkqawi ce khy saw, a ningnih ingawm a ni pa ingkaw anik thlang ceeikhqi ce lawng khuiawh cehta nih nawh anih a hu awh bat pehoei hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kaperanaum khaw na cet unawh, Sabbath nyn awh sinakawk khuina thlang cawngpyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Anih ingtaw anaa awi cawngpyikungkhqi a cawngpyinaak a myihna a cawngpyi kaana saithainaak ak ta thlang a cawngpyinaak a myihna a cawngpyi a dawngawh a cawngpyinaak awh thlangkhqi ce a ming ngaih kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Cawh sinakawk khuina qaih che ak ta thlang pynoet ing ak khy doena, ");
INSERT INTO hltthb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nazareth Jesu, kaimih ve ikaw ni ti nak khqi vang na ti? Kaimih hqe aham nak law nu? Nang ve Khawsa ak thlang ciim ni tice ni sim nyng!” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Cawh Jesu ing, “Sit nawh! Thlang ak kawk khui awhkawng cawn lah,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Qaaiche ing ce ak thlang ce khawteh na thyn sak nawh ak kawk khui awhkawng khy doena cawn hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Cawh ce cawhkaw ak awm thlangkhqi boeih boeih ce amik kawpoek kyi hy, “A u mih nu ve? Saithainaak ingkaw cawngpyinaak ak thaai vam haw ve! Qaaichekhqi awm awi pe saw ngai pe u tik maw ve,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kawlkalh awh anih akawng ce Kalili ram pum awh thang khawnghak hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sinakawk ce ami cehtaak coengawh, Simon ingkaw Andrew a im awh Jakop ingkaw Johan ce ceh pyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Cawh Simon a senu ce a sa tlo nawh zaih hy, ce akawng ce Jesu a venawh kqawn pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesu ing cet nawh a kut awh tu nawh thawh hy. Cawh anih ce a sa tlawh ing hlah pahoei nawh cekkhqi ce dodan hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Khawmy ben khaw angtlaak coengawh, tlawhnaak soepkep ak ta thlangkhqi ing qaai ing amtu thlangkhqi ce a venawh law pyi uhy, ");
INSERT INTO hltthb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","chawmkeng awh vangpum na ngawi kyng uhy, ");
INSERT INTO hltthb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","cawh tlawhnaak soepkep ak takhqi ce Jesu ing qoei sak hy. Qaaikhqi awm khawzah hqek hy, anih ce u nu ti ami sim a dawngawh, qaaikhqi ce awi khangoet awm ap kqawn sak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","A ngawi mymcang hqiit khaw a dai hlanawh Jesu taw tho nawh, a dingypnaak a hun na cet nawh cykcah hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon ingkaw a pyikhqi ing anih ce sui uhy, ");
INSERT INTO hltthb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ami huh awhtaw, “Thlangkhqi ing nang ni sui uhy!” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesu ing, “Ak chang na khawceng khawcawi na cet hlah usih, cawh ni awi kak kqawn hly thai. Ve aham ni ka law,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Cedawngawh Kalili ram pum awh cet nawh, sinakawkkhqi awh awi ce kqawn hy, qaaikhqi ce hqek hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mynrai ak neh thlang pynoet ce a venawh law nawh khuk sym doena qeennaak thoeh hy, “Na ngaih awhtaw ni qoei sak thai hyk ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Anih ing am qeen soeih a dawngawh, a baan ce zyng nawh bi hy. “Ngaih nyng ciimcaih hlah!” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kawlkalh phoeih awh mynqaai ce ciimcaih nawh qoei tlang hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Awi yn ceet ceet nawh tyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","”U a venawh awm koeh kqawn qoe qoe. Cehlai cet nawh a mingmih a venawh dyihthing na na awmnaak aham khawsoeih a venawh namah ingkaw namah ce vam huh qu lah, nang silh qunaak aham Mosi ak awipeek myihna ik-oeih ce suum lah,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Cehlai anih ing cet nawh kqawn lat hy, cedawngawh ce ak awi ce thang khawnghak hy. Cedawngawh Jesu taw khawk khuiawh ang dang pyng na am cet thai voel nawh khawcengkhqi awh thlang a sitnaak kqang ce awm hy. Cehlai hun chang chang nakawng thlangkhqi ce a venna law uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Khawnghi iqyt nu a di coengawh Kaperanaum a pha law tlaih awh, imawh anih awm hy tice thlangkhqi ing za uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Imawh chawmkeng dyna awmnaak amak hoengna be law khoep usaw, cawhce ami venawh awi kqawn pekkhqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Cawh thlang pupthli ing, ak khawn thlang pynoet ce lawpyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Thlang a thet aih awh Jesu venna am law pyi thai usaw anih a awmnaak tawng awh iptih phen unawh thlang ak khawn ce amik kawhnaak hiphaih mahna nuk thla uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesu ing amik cangnaak ce a huh awh, thlak tlo ak khawn a venna, “Ka capa, na thawlh qeenna awm hawh hyk ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Cawh cawngpyikungkhqi thlang vang awm cawhce ngawi lawt unawh amik kawk khuiawh, ");
INSERT INTO hltthb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ikawtih ve ak thlang ing vemyihna awi ak kqawn hy voei? Khawsa ni ak kqawnseet haw! Khawsa doeng kaa taw u ing nu thawlh am qeen thai?” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Amik kawlung awh cemyihna poek uhy ti Jesu ing sim nawh, ami venawh, “Ikawtih cemyihna kaw namik poek? ");
INSERT INTO hltthb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ak khawn a venawh, 'Na thawlhnaak qeenna awm hawh hy,' ti aw, 'Na ihphak lo nawh na khaw ing cet hlah,' ti han nu kqawn ak zoei bet? ");
INSERT INTO hltthb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Cehlai thlanghqing capa ing ve khawmdek awh thawlh qeennaak tathai hy tice nami sim naak ham, tinawh, ak khawn thlang venawh, ");
INSERT INTO hltthb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Tho nawh, na ihphak lo nawh, na im na cet, ni tina nyng, ”tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Anih ce tho nawh, a ihphak ce lo nawh, thlang khawzah mik huh na cet saw; thlang boeih a ming ngaih a kyi doena, “Vemyih ve amni hu man hy,” ti unawh Khawsa ce kyihcah uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesu taw cawn nawh tuili kengna cet tlaih bai hy. Cawh thlang khawzah ing a ven pan usaw, cawngpyi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A ceh doena mangmu cawinaak hynawh ak awm Alphai capa, Levi ce hu nawh, a venawh, “Ka hu awh bat lah,” tina hy. Tho nawh a hu awh bat pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesu ing Levi a im awh buh vel unawh, mangmu ak cawi thlang khawzah ingkaw a hubatkhqi mi buh vel haih uhy. A hu ak batkhqi awm thlang khawzah ni. ");
INSERT INTO hltthb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Thlak thawlhkhqi ingkaw mangmu ak cawikhqi venawh buh a vel ce Farasikhqi ing ami huh awh, a hubatkhqi venawh, “Ikawtih mangmu ak cawikhqi ingkaw thlak thawlhkhqi venawh buh a vel?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Cek awi ce Jesu ing ang zaak awh, “Sak dip thlang ing siboei am ngoe nawh thlak tlo ing ni siboei a ngoe. Thlak dyngkhqi khy ham am law nyng, thlak thawlhkhqi khy ham ni ka law,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Johan a hubatkhqi ingkaw Farasikhqi ingtaw buh zeih uhy. Cedawngawh cet unawh Jesu venna, “Ikawtih Johan a hubatkhqi ingkaw Farasikhqi ingtaw buh zeih usaw na hubatkhqi ingtaw ama mi zeih,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu ing, “ikawmyihna zuk lokung a awm hyn awh zulawh poei ak pankhqi ing buh ami zeih kaw? Anih a awm khui awhtaw buh am zeih kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Cehlai zuk lokung ce a mingmih a ven awhkawng ak chang na khyn valhnaak a tym ce pha law kaw, cawh buh zeih dam bit kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“U ingawm hi ak kqym ce hi ak thai ing am bu man na. A bunaak mantaw, hi ak thai ing hi ak kqym ce dawk kawmsaw sek khqoet kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","U ingawm misur tui ak thai ce cikthlyng ak kqym khuiawh am than khawi hy. A than mantaw misur tui ing cikthlyng ce seet kawmsaw misur tui ingkaw cikthlyng ce se haih kaw. Amni, misur tui ak thai taw cikthlyng ak thai awh ni ami than,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabbath nyn khaw hypoet awh, Jesu taw lo awhkawng cet hy, a hubatkhqi ing ami ceh awh cang a vui ce dy uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farasikhqi ing a venawh, “Toek lah, kawtih Sabbath nyn awh sai aham amak thym ce na hubatkhqi ing ami sai?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Anih ing, “David ing a pyikhqi mi amik phoen a cawih awh a ngoe dawngawh ik-oeih a sai ce am nami noet khawi nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiathar khawsoeih boeikhyt na a awm awh, David ing Khawsa im khuina kun nawh, khawsoeihkhqi doeng ing ai aham ak tyng phaihpi ami nawn a ai ce ti. A pyikhqi awm pe sawkaw,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Cekcoengawh a mingmih a venawh, “Thlang aham ni Sabbath ve a sai, Sabbath aham thlang am sai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Cedawngawh thlanghqing Capa ve Sabbath a boei na awm awm hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sinakawk na ce cet bai nawh, cawhce a kut ak khem thlang pynoet a na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Amah thawlh amik puknaak hamna Sabbath nyn awh thlang a qoei ingkaw ama qoei sak hly qym uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu ing kut khem venawh, “Thlang boeih a haiawh dyi lah,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","A mingmih a venawh, “Sabbath nyn awh them leek sai nu a leek, them amak leek sai nu, hqingnaak thaawng nu a leek, him nu?” tinak khqi hy. Cehlai a ming hqi phah uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Amim thin a sah awh ak kaw am law nawh, kawso doena a mingmih ce toek khqi nawh, cawhkaw thlang a venawh, “Na kut ce zyng lah,” tina hy. Anih ing a kut ce zyng saw, a kut ce leek pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Cawh Farasikhqi ce cawn unawh Jesu ce ikawmyihna ni him thai lah voei, ti unawh Herod ak thlangkhqi mi doet qu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesu taw a hubatkhqi mi tuili benna ce cet uhy, cawh Kalili ben nakaw thlang khawzah ing a hu hquut law uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","A them saikhqi boeih ce aming zaak awh Judah nakaw, Jerusalem nakaw, Idumea nakaw, Jordan long caqai benna kaw thlangkhqi, Tura ingkaw Sidon khaw keng awhkaw thlangkhqi ce a venna law uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Thlang doem aih nawh Amah ama mi netnaak hamna a hubatkhqi ce lawng pynoet taak pek ham tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Thlang khawzah a qoei sak hawh a dawngawh, thlak tlokhqi ing Amah a mi bi ngaih awh den qu boeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Qaihchekhqi ing anih ce ami huh awh a haaina koep unawh, “Nang ve Khawsa Capa ni,” tinawh khy uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Cehlai anih u aw tice ama mik kqawn aham cekkkhqi ce awi pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesu ing tlang na kaai nawh amah ing a ngaih thlangkhqi ce khy hy, cekkhqi ce a venna law uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A venawh ami awmnaak thai ham ingkaw awi kqawn ham, ");
INSERT INTO hltthb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sungqaikhqi hqek hamna a tyih khqi hamna, pahqa hlaihih ce tyk khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Cekkqhi taw: Simon (Piter tinawh ming sui); ");
INSERT INTO hltthb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedi a caqawi Jakop ingkaw ana Johan (vekkqawi ve Boaneges tinawh ming sui, khawhuum capa qawi tinaak); ");
INSERT INTO hltthb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Philip, Bartholomu, Mathai, Thomas, Alphaeus capa Jakop, Thadaeus, Zealot ami ti Simon ingkaw ");
INSERT INTO hltthb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","amah ak zawikung Judah Isakariot vetloek ve tyk hy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Cekcoengawh Jesu taw ipkhui na lut hy, cawh thlang khawzah cun law tlaih bai unawh, cedawngawh buh kangna awm am ai thai uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","A cakawkhqi ing ce ak awi aming zaak awh, “A cyih am awm voel hy,” ami tinaak dawngawh anih ce tu aham cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalem nakawng a nuk law anaa awi cawngpyikungkhqi ing, “Beelzebub ta ti maw ve! Qaai sangpahrang capa ak caming ni qaaikhqi a hqek,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Cedawngawh Jesu ing cekkhqi ce khy nawh nyhtahnaak awi kqawn pehy: “ikawmyihna Setan ing Setan ce a hqeknaak thai kaw? ");
INSERT INTO hltthb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Qam awm aming pek qu mantaw am dyi thai tikaw. ");
INSERT INTO hltthb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ipkhuikaw awm aming pek qu awhtaw am dyi thai ti kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Setan awm amah ingkaw amah pek qu unawh aming tuk qu mantaw, am dyi thai ti kawm uh; plal hqoeng hawh kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","U ingawm ip takung thak awm soeih ce ama pin lamma awhtaw, a ipkhui na kun nawh a ik-oeihkhqi ce am lawh pe thai tikaw. A pin coengawh ni a im ce a muk hly peek thai. ");
INSERT INTO hltthb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Awitak ka nik kqawn peek khqi, thlangkhqi a thawlhnaak boeih ingkaw Khawsa thekhanaak awh ce qeenkhaw ngainaak awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Cehlai u awm Ciim Myihla ce a thekhanaak awhtaw ityk awh awm qeenkhaw ngainaak am awm tikaw; kumqui thawlhnaak ce sai hawh hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","A mingmih ing, “Qaaiche tahy,” ami tinaak dawngawh ve ak awi ve kqawn pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Cawh Jesu anu ingkaw a koeinaakhqi ce law uhy. A leng na dyi unawh anih ce khy sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Thlang kqeng ing ak chung khoep awh a venna, “Na nu ingkaw na koeinaakhqi ing a leng na ni sui uhy,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesu ing, “Ka nu ingkaw ka koeinaakhqi ce a u nu?” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A venawh ak ngawi thlangkhqi ce toek nawh, “Ka nu ingkaw ka koeinaakhqi taw vekkhqi hawh ni! ");
INSERT INTO hltthb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","U awm Khawsa ak kawngaih ak saikhqi taw kai a koeinu koeinaa ingkaw ka nu na awm hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Cekcoengawh Jesu ing tuili kengawh thlang cawngpyi tlaih bai hy. A venawh ak cun thlang kqeng ce a kqeng soeih a dawngawh lawng khuina kun nawh ngawi hy, cawh thlangkqeng taw tuili kengawh awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nyhtahnaak awi ing cekkhqi ce ik-oeih khawzah cawngpyi khqi hy, a cawngpyinaak awh ce a mingmih a venawh: ");
INSERT INTO hltthb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ngai lah uh! lo ak toenkung thlang pynoet taw camci ak saw na cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Camci ce a saw awh a vang taw lam awh tla nawh phakhqi ing cung hloep uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","A vang taw deklai khawzah ama awmnaak lung ak khan awh tla hy. Deklai a pam a dawngawh, kawlhkalh awh cawt tlang hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Cehlai khaw a thoeng law awhtaw ak kqa ama cak a dawngawh khawkbe ing tau nawh reu hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Camci a vang taw hling anglakawh tla nawh, hling a thing ce a bau law awhtaw cang ce zawl malh hy, cedawngawh am vui thai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Camci a vang taw deklai ak leek awh tla hy. Cawt law, taai law nawh, vui hy, a pyh thumkip, kqukkip, zakhat dyna ak thaih vui hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Cekcoengawh Jesu ing, “Zaaknaak haa ak ta ingtaw za seh nyng,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Amah doeng a awm awh, thlanghqa hlaihih tloek ingkaw thlak changkhqi ce a venna law unawh nyhtahnaak awi ce doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A mingmih a venawh, “Khawk khan nakaw awihyp ce nangmih a venawh ni pek khqi hawh hy. Cehlai a ceng na ak awmkhqi aham ik-oeih soepkep ce nyhtahnaak awi ing kqawn pe nyng, ");
INSERT INTO hltthb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","cawh ni, “'hu taw hu hlai kawm uh, am toek thai ti kawm uh, za taw za hlai kawm uh, am zasim thai qoe kawm uh, cemih am mantaw hlat tlaih kawm usaw, qeenkhaw ngai na awm hau kawm uh!' a ti myihna,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Cekcoengawh Jesu ing a mingmih a venawh, “Vawhkaw nyhtahnaak awi ve amna ming zasim nawh nu? Cawhtaw ikawmyihna nyhtahnaak awikhqi boeih ce naming zaak sim hly pai? ");
INSERT INTO hltthb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Lo ak takung ing awi ce theh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Thlang vang taw awi ce ak theh awh, camci ang tlaaknaak lam amyihna awm uhy. Awi ce aming zaak awh Setan ce law nawh a mingmih ak khuiawh theh na ak awm awi ce lo valh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ak changkhqi bai taw, lunghqawng awh ak tla camci amyihna awm bai hy, awi ce aming zaak awh zeel doena do pahoei uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Cehlai ak kqa ama cak a dawngawh, kawlhkalh ca doeng awm hy. Awi awh kyinaak ingkaw thekhanaakkhqi a law awh, ang tawnna tluk tlang uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ak changkhqi bai taw hling anglakawhkaw ak tla camci ing myih uhy, awi ce za hy; ");
INSERT INTO hltthb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","cehlai ve khawmdek hqing khawsaknaak awh lynaakkhqi, boeinaak, qaai kqawnnaak khqi ingkaw ak chang ik-oeih ngaihnaakkhqi law nawh awi ce zawl malh uhy, cedawngawh a vui am qah thai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ak chang bai taw, laitak awh ak tla camci ing myih hy, awi ce ang zaak awh, do hy, a vui qah nawh - a pyh thumkip, kqukkip ingkaw zakhat dyna ak thaih vui hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","A mingmih a venawh, “Maiim ce dawn ing myk unawh, am awhtaw caboei ak kaina ta khawi unawh nu? Maiim amim hawihnaak khawi awh ni amim hawih ka ti my? ");
INSERT INTO hltthb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Cawh ni amak dangkhqi boeih awm dang kawmsaw ang hyp na ak awmkhqi awm aming dang hly boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Zaaknaak haa ak ta ingtaw za seh. ");
INSERT INTO hltthb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Na ming zaak ve ak leek na poek lah uh. Thlang aham na loeknaak awh ce nang aham awm loek law lawt kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","U awm ak ta ce sap pek khqoet kawmsaw; u awm amak ta cetaw, a taak ang cang awm lawh pe kaw,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","A mingmih a venawh, “Khawsa qam taw vemyihna awm hy. Thlang pynoet ing camci ce a lo awh theh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Khawmthan ingkaw khawkdai ip nawh hang tho law seiawm camci ce pawk nawh cawt law hy. Ikawmyihna a hang cawt law tice am sim hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Amah poek awh deklai ing vui a qah sak hy - a kung hak cawt law hy, cekcoengawh vui nawh ak thaih qah law hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Cang ce a hin awhtaw, cang ah aham a khoek hawh a dawngawh, vin ce lo nawh aat hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Cawhtaw, “Khawk khan qam ve kaw ing nu ka nyhtah lah voei, am awhtaw i ikawmyih nyhtahnaak awi nu ka hawnaak lah voei? ");
INSERT INTO hltthb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Khan qam taw khawmdek awh ak zawi soeih antlam cii ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Cehlai antlam cii ce cawt nawh a hang taai law awhtaw dum khui awhkaw a thing boeih boeih anglakawh bau khqoet hy, a baai ak bau na cawn nawh khan nakaw phakhqi ing a hlip awh cu uhy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","A mingmih ing aming zaak simnaak thai aham, cemyih nyhtahnaak awikhqi ing awi kqawn pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nyhtahnaak awi hawnaak kaana ikawmyih awi awm ap kqawn pek khqi hy. Cehlai a hubatkhqi mi amah doeng ami awm awh, cawhkaw ik-oeihkhqi ce kqawncaih pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Amah ce nyn khawmy ben awh a hubatkhqi venawh, “Vang ben caqai na cet usih,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Thlang kqeng ce cehta unawh, anih ce lawng khuiawh a awmnaak man na ceh pyi pahoei uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Cawh khaw hli khung nawh tuibak ce lawng khuina kun saw lawng ce cum hlo hlo hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesu taw lawng ang mai benna a lu doelh nawh ip hy. A hubatkhqi ing thawh unawh, a venawh, “Cawngpyikung kaimih tui awh ka ming cum hly ve kawna am nak poek nawh nu?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tho nawh, khawhli ce, “Sit nawh dym hlah!” tina hy. Cawh khawhli ce sit nawh a sitdik na awm boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","A hubatkhqi venawh, “Ikawtih vemyihna namik kqih lawnha aih? Cangnaak am nami ta hlan nawh nu?” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Cawh kqih unawh, “Ve ve a u nu ti ve? Khawhli ingkaw tuibak ingawm ak awi ngai pe zap hy!” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Cecoengawh, tuili caqai benna kaw Gerasin khawna ce cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Lawng khui awhkawng Jesu ak cawn lawawh, ak kawk khuina qaai ak be thlang pynoet ing phyi nakawng anih ce hqum ham law hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Anih taw phyi awh awm nawh, u ingawm anih ce am pin thai qoe uhy. Thiqui ingawm am pin thai uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","A kut a khaw thiqui ing khit hlai uhy, thiquikhqi awm phu kyk kyk hy. U ingawm anih ce am noeng hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Khawmthan khawdai phyi ingkaw tlang kqang khy nawh amah ingkaw amah ce lung ing aat qu hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ak hla nakawng Jesu a huh awh, dawng nawh a haina khuk sym pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Khawteh na khy nawh, “Kai ve ikaw ni tina vang na ti, Jesu sawsang soeih Khawsa Capa? Qeennaak ing kai ve kyinaak koeh ni huh sak mai!” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesu ing, “Nang qaihche! Ve thlang ak kawk khui awhkawng cawn hlah,” ana tinaak hawh a dawngawh. ");
INSERT INTO hltthb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","“Nang ming u nu?” tinawh Jesu ing doet hy. Anih ing, “Khawzah kami law a dawngawh, Legion ming na nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ak hla soeih na cekkhqi ce ama tyihnaak aham Jesu a venawh anih ing qeennaak thoeh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ce a hun awhkawng a zoenaak baang kqoep awh vawk cahnaak awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Qaaikhqi ing Jesu a venawh, “Vawk a venna ni tyi khqi mai, vawk khqik khuina kun mai vang u nyng,” tinawh qeennaak thoeh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Anih ing kun sak hy, cedawngawh qaaikhqi ce cawn unawh vawk ak kawk khuina kun uhy. Cawhkaw vawk taw thawnghih tluk law hy, vawkkhqi boeih ce tuili a awmnaak ben kqang cen unawh tui awh amik cawn coengawh thi boeh boeh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Vawk ak cahkhqi ce dawng unawh khawk bau ingkaw vangcakhqi awh cawhkaw ik-oeihkhqi ce kqawn uhy, cedawngawh cawhkaw ik-oeih ce ak toek na thlangkhqi ce cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesu a ven ami pha law awh, qaai ing am tu ak thlang ce hu uhy, anih ce ak leek caana a nang ngawi hy; cawhkaw thlangkhqi ing ce kqih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Qaai ing am tu thlang ingkaw vawk ak khan awhkaw ik-oeih ak awm law ce ak hukhqi ing thlangkhqi venawh kqawn pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Cedawngawh thlangkhqi ing ce a qam ce cehtaak aham Jesu a venawh qeennaak thoeh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesu ing lawng khuina kun vang a ti awh, qaai ing amtu a qoei sak thlang ing a hu awh bat lawt aham qeennaak thoeh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Cehlai Jesu ing am bat sak hy, “Na cakawkhqi venna im na cet nawh Bawipa ing nak khan awh kawmih dyna ik-oeih a sai law nawh qeennaak a taak law tice kqawn pek khqi,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Cedawngawh ce ak thlang ing cet nawh Jesu ing ak khan awh ikawmyih ik-oeih a sai peek tice Dekapolis awh kqawn hy. Cedawngawh thlang boeih amik kawpoek kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesu taw tuili caqai na lawng ing cet nawh, tui kengawh a awm awh thlang kqeng khawzah ce a venna cun uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Cawh sinakawk ukkung thlang pynoet, Jairu ak mingnaak ce law hy. Jesu ce a huh awh a khawkung awh koep doena qeennaak thoeh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Ka canu ca thi tawm hawh hy. Qeennaak ing law nawh ak khan awh na kut tloeng pe cang, cawhtaw qoei nawh hqing tlaih kaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Cedawngawh Jesu taw anih a hu awh cet hy. Thlang kqeng khawzah ce a hu awh bat unawh ang net na net qu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Cawh kumhqa hlaihih a thi na ak tla nu pynoet ce awm lawt hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Siboei khawzah a venawh a ceh hawh a dawngawh tangka awm khawk hawh hy, cehlai am hawih khang nawh nauh khqoet khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesu a thang ce ang zaak awh thlang kqeng mi Jesu a hu awh bat lawt hy, ");
INSERT INTO hltthb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","A hi mah ka bi man qoei ngai voei nyng, tinawh ak poek dawngawh a hi ce bi pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Cawh a thi ce dym nawh a pum awh a tlawhnaak qoei hawh hy tice sim pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Cawh a pum awhkawng saithainaak cawn hy tice Jesu ing sim pahoei hy. Thlang kqeng benna ce mang nawh, “U nu ka hi ak bi?” tinawh doet khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","A hubatkhqi ing, “Thlang kqeng ing ni net usaw na huh a loei awh, 'U ing a ni bi? ce nak ti nu,' tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Cehlai Jesu ing amah ak bikung benna mang nawh toek hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Cawh cawhkaw nu ing ak khan awh ik-oeih ak awm law ce a sim doena, a khawkung awh koep nawh kqih thyn doena ak thym caana kqawn pe boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesu ing a venawh, “Ka canu nak cangnaak ing ni qoei sak hawh hy. Ngaihding caana cet hlah, na tlawhnaak qoei hlah seh,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ce myihna Jesu ing awi ak kqawn huiawh, sinakawk ukkung Jairu a im awhkawng thlang vang ce law uhy. “Na canu thi hawh hy, kaw hamna cawngpyikung ce na toeh na oeih khing kaw?” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","A mingmih ak awih kqawn ce kawna awm am ngai nawh, sinakawk ukkung a venawh,“ Koeh kqih, ak cang namah cangna lah,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Piter, Jakob ingkaw Jakob a na Johan doeng ce khy nawh cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sinakawk ukkung a im ami pha awh ak khy ak kokhqi ingkaw ak kqangkhqi ce Jesu ing hu hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ipkhui na cet nawh a mingmih a venawh, “Kawtih ve myihna khy a ko unawh naming kqang aih? Naasen ve am thi hy, ak ip ni,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Cawh a mingmih ing qaih na uhy. Cawhkaw ak awm thlangkhqi ce a leng na cawn sak khqi nawh naasen a nu a pa ingkaw a hubat a ven awhkaw ak awmkhqi ce naasen ami soeinaak na ceh pyi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Naasen ce a kut awh tu nawh, “Talitha kumi!” tina hy, (cece, “Nulaa ca, ka nik kqawn peek, tho lah!” tinak ni). ");
INSERT INTO hltthb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Cawh nuca ce tho pahoei nawh cet hyhy hy (cawhkaw nuca taw kumhqa hlaihih law hy). Cawh cawhkaw amik awm thlangkhqi boeih ce amik kawpoek kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Cawhkaw ik-oeih ce u a venawh awm amak kqawn aham cekkhqi ce awi yn khqi ceet ceet hy, cekcoengawh nuca ce ai kawi pynoet oet peek aham kqawn pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ce hun awhkawng Jesu taw cawn nawh amah a awmnaak khaw ce pha hy; a hubatkhqi ing a hu awh hquut uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabbath nyn a pha awh, sinakawk khuiawh thlang cawngpyi hy, a cawngpyinaak ak zakhqi boeih ing aming ngaihna kyi sak uhy. “Ve ak thlang ing hana kaw nu ve ak awikhqi ve a huh hy voei? Hana kaw cyihnaak nu hu nawh vemyih kawpoek kyi ik-oeihkhqi a sai hy voei! ");
INSERT INTO hltthb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","A nih ve Meri capa, Jakob, Joseph, Juda ingkaw Simon ak taipa, letama awm am nu?” ti uhy. Cedawngawh ak khan awh amik kaw am law hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesu ing a mingmih a venawh, “Tawngha taw amah a khaw, amah a cakawkhqi ingkaw amah a im awh kyihcahna am awm khawi na,” ti hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Thlak tlo a khoeh ca doeng ak khanawh kut tloeng nawh a tloei sak ti kaana taw ce a hun awh kawpoek kyi ik-oeih am sai thai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","A mamik cangnaak a dawngawh ang ngaih kyi hy. Cekcoengawh Jesu ing cet nawh khaw pynoet coeng awh pynoet cawngpyi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Thlanghqa hlaihih tloek ce khy nawh, thlang pakhih pakhih awh a tyih coengawh qaaiche khqi ak khanawh saithainaak ce pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Cecoengawh khawlawng nami ceh naak awh sawnghqawl doeng am kaa taw - phaihpi awm, sawngsa awm, taisawm awh tangka awm koeh kel hamna ti nak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Khawmyk taw myk sak khqi nawh,” angki pakkhih koeh khyn uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Cekcoengawh ami venawh, “Nami pahnaak im hawh taw cawhkawng namik cawn hla dy ak changna koeh cawn ta uh. ");
INSERT INTO hltthb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Han a khaw ingawm nangmih ce am ni do khqi nawh namik awi awm ama ming ngai awhtaw, ce a khaw ce nami cehtaak awh ami simnaak aham nami khaw awhkaw dekvai ce khawk sih uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Thlangkhqi ing thawlh aming zutnaak aham a mingmih ing cet unawh awi ce khypyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Qaaikhqi khawzah ami hqek coengawh thlak tlo khawzah ce situi hluk unawh qoei sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesu ang ming ce thang hawh nawh, Herod sangpahrang ingawm awithang ce za hy. Thlang vang ing, “Baptisma ak pekung Johan ce thihnaak awhkawng tho tlaih hy, cawhni anih awh kawpoek kyi them saithainaakkhqi a awm hy,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Thlang vang ingtaw, “Elijah ni,” ti uhy. Thlang vang ingtaw, “Anih ce tawngha pynoet lawt ni, syn awhkaw tawngha pynoet myihna ni a awm lawt,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Cehlai Herod ing ang zaak awh, “Kai ing a haawng ka hlyng peek Johan ni thihnaak awhkawng a thawh tlaih hawh hy ce!” tihy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod amah ing Johan ce tu sak nawh ak khih coengawh thawngim na thla hy. A na Philip a zu Herodi a zunaak a dawngawh cemyihna ce sai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Johan ing Herod na ce, “Na naa a zu na lawh ce am thym hy,” a tinaak a dawngawh. ");
INSERT INTO hltthb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Cedawngawh Herodi ing Johan ce myihqyt na nawh him aham ngaih hy, cehlai am him thai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod ing Johan ce thlak dyng thlak ciimcaih ni tice a sim a dawngawh kqih nawh hlip a dah hy. Herod ing Johan ak awi ang zaak awh ak kawpoekna kyi sak hy; cehlai zeel doena ak awi ce ngai pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","A hukhit nataw a tym leek ce pha law hy. Amah a thangnaak nyn awh Herod ing a boeikhqi, a qaal boeikhqi ing Kalili qam ukkungkhqi aham poei buh veelnaak sai pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Cawh Herodi a canu ce law nawh laam hy, anih ing Herod ingkaw ak khinkhqi boeih ce amik kaw zeel sak hy. Sangpahrang ing nuca venawh, “Na ngaih boeih thoeh lah, ni pe vang nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nuca venawh ce awi kam hy, “Na thoeh boeih ni pe vang nyng, ka qam ak keek vang dy awm” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Cawh nuca ing a nu a venna cet nawh, “Ikaw nu ka thoeh kaw?” tina hy. A nu ing, “Baptisma ak pekung Johan a lu,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Cawh nuca ce sangpahrang a venna ang tawnna dawng nawh, “Tuh Baptisma ak pekung Johan a lu ce beihdung awh nani peek aham ngaih nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Cawhtaw sangpahrang ak kaw se hy, cehlai ak khinkhqi haiawh awi a kam hawh a dawngawh, nuca a thoehnaak ce am oelh pe voel hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Cedawngawh thlang ak himkung ce ang tawnna tyi nawh Johan a lu ce khyn peek aham awi pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ce ak thlang ing thawngim khuina cet nawh, Johan a hawng ce a hlyng coeng awh, a lu ce beihdung awh tloeng nawh pehy. Anih ing nuca venawh pehy, nuca ing a nu pe patoe hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ce ak awi ce aming zaak awh Johan a hubatkhqi ce law unawh a pum ce lo unawh phyina thak uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ceityihkhqi ing Jesu vena cun law unawh ik-oeih ami saikhqi ingkaw thlang ami cawngpyinaak akawng khqi boeih ce kqawn pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Thlang ak law ingkaw ak voeikhqi a kqeng aih a dawngawh buh a an awm am ai thai uhy, cedawngawh a hubatkhqi venawh, “Na mimah doeng ka hu awh law unawh thlang a sitnaak hun awh dym cang uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Cedawngawh thlang a sitnaak hunna lawng ing a mimah doeng cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","A mingmih a ceh ce thlangkhqi ing ami huh awh khaw boeih boeih awhkawng dawng unawh a mingmih a haina ana pha ma uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesu ing kawngceng a pha awh thlang kqeng khawzah ce hu hy, khoemkung amak awm tuukhqi myihna ami awm a dawngawh a mingmih ce qeen khqi hy. Cedawngawh a mingmih ce awi khawzah cawngpyi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Khaw a my hawh a dawngawh a hubatkhqi ce a venna law unawh, “Ve a hun ve kqawng na awm nawh, khaw awm my hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Thlang kqeng ve ceh sak hlah, khawceng khaw cawi hqang cet u seitaw a mimah ing buh a ankhqi sui useh,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Cehlai a mingmih a venawh, “Nangmih ing ai kawi pe uh,” tinak khqi hy. Cekkhqi ing, “A mingmih boeih a ai tat ham taw thlang pynoet a hlak kqeet thaphu man ni a khoek kaw! Tangka ce zah ing phaihpi thlai unawh a mingmih kami pe hly nawh nu?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Anih ing, “Phaihpi izah nami taak? Cet unawh toek lah uh,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Cawh Jesu ing thlang kqeng ce taitin awh aming ngawih ham awi pek khqi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Cedawngawh thlang kqeng ce zakhat zakhat ingkaw hakip hakip na ngawih sak khqi hloep hloep hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesu ing phaihpi cun nga ingkaw nga lunghih ce lo nawh khan benna mang ing zoseennaak a pek coengawh phaihpi ce thek nawh, thlangkhqi haiawh toen peek ham a hubatkhqi venawh pek khqi hy. Nga lunghih awm a mingmih boeih a venawh qek sak khqi bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","A micu boeih ing ai unawh phyi boeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Phaihpi ingkaw nga ak ngenkhqi ce a hubatkhqi ing ami cawi awh vawh hqa hlaihih law hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cawhkaw buh ak aikhqi ce pa thak awm hqoeng thongnga law hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesu ing a hubatkhqi ce lawng khuina kun sak khqi pahoei nawh Bethsaida khaw na tyi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","A mingmih ce a cehtaak khqi coengawh cykcah aham tlang na cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Khaw a my law awh, lawng ce tui ang lung na awm nawh, amah doeng ce kawngceng na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Khawhli ing lawng ce mam khoep nawh a hubatkhqi ing lawng ce kaih tloei uhy. Khawmthan khawnoek pali tluk awh a mingmih a venna Jesu taw tui ak khan awh cet nawh cekkhqi venna ceh aham cai hy, ");
INSERT INTO hltthb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","cehlai tui ak khan awh a ceh ce ami huh awh, Myihla ni ti unawh poek uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","A mingmih ing ami huh awh kqih unawh khy uhy. Cawh a mingmih a venawh, “Na ming ngaih qep sak uh! Kai ni koeh kqih uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Cekcoengawh a mingmih a venna lawng awh ce hang kaai hy, cawhtaw khawhli ce dym hy. Cekkhqi amik kawpoekna kyi hy, ");
INSERT INTO hltthb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","amik kaw a tiing soeih a dawngawh, phaihpi akawng awm am zasim qoe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Vang ben caqai sa na cet unawh, Genesaret ce pha unawh, cawh ce dym uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Lawng khui awhkawng amik cawn awh, thlangkhqi ing Jesu ce hat uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ce a qam khui awhkaw thlangkhqi boeih ce dawng unawh phak awh thlak tlokhqi ce anih a awmnaak hun a hoei awh kawt law uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Anih a cehnaak hoei awh vangca vangnu ingkaw lokhqi na awm, ik-oeih ami zawihnaak hunkhqi na awm thlak tlokhqi ce law pyi uhy. A himawng ca awm bi thainaak aham a venawh qeennaak thoeh uhy, ak bikhqi boeih ing qoeinaak hu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farasikhqi ingkaw Jerusalem awhkawng ak law caqeekung thlang pynoet ce Jesu a venawh cun uhy, ");
INSERT INTO hltthb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Cawh a hubatkhqi ing kut silh kaana buh ami ai ce hu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Farasikhqi ingkaw Judahkhqi boeih ingtaw a mimah a phung amyihna kut a mami silh awhtaw buh am ai uhy. A hqamcakhqi ak awi ce tu khak uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ik-oeih ami zawihnaak hun awhkaw ik-oeihkhqi ce a mami silh ma awhtaw am ai uhy. Ak chang awi a mik pawm khawzah awm nawh boet silh khqi, um am silh khqi ingkaw qawhum silh khqi awm sai uhy.) ");
INSERT INTO hltthb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Cedawngawh Farasikhqi ingkaw anaa awi cawngpyikungkhqi ing doet uhy, “Kawtih na hubatkhqi ing a hqamcakhqi ak awi hquut kaana, kut 'myn' na buh ami ai uh?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesu ing, “Isaiah ing nangmih qaai kqawnkhqi akawng anak kqawn ce thym zawk hy ve: 'Ve ak thlangkhqi ing a mim kha ingtaw ni zoeksang hlai uhy, amik kawlung ing ni lak hla uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Phu amak tana ni bawk unawh; ami cawng pyinaak awm thlanghqing a cawng pyinaak mailai na awm hy,' tinawh anak kqawn ce. ");
INSERT INTO hltthb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Khawsa awipeekkhqi ce qoek unawh thlanghqing ak awipekkhqi ce ak cak na tu lat uhyk ti,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Cekcoengawh a mingmih a venawh: Na mimah ak awipekkhqi nami sainaak thai ham Khawsak awipeek qoek unawh khaw sim khoem uhyk ti! ");
INSERT INTO hltthb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosi ing, 'Na nu ingkaw na pa zoeksang lah, u awm a nu am awh a pa ham seet ak phoei sih taw thih sak aham awm hy; tinawh anak kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Cehlai nangmih ingtaw, u ingawm a nu venawh am awhtaw a pa venawh; 'Kai a ven awhkawng ikawmyih bawmnaak awm na huh cetaw Korban ni' (cece 'Khawsa venawh pek,' tinaak ni), tina uhy, ");
INSERT INTO hltthb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","a nu aham am awhtaw a pa ham bi am bi sak qoe uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Cemyihna na mimah ak awipek ing Khawsa ak awi ce hqe uhyk ti. Vemih ik-oeih ak chang khawzah sai uhyk ti,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesu ing thlang kqeng ce a venna khy nawh a mingmih a venawh, “Nangmih boeih ing ngai unawh zasim lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Thlang ak kawk khuina anuk lut ik-oeih ikawmyih aawk-ai ingawm thlang tuih am cuk sak hy. Cehlai thlang ak kawk khuina kawng ak cawn law ing ni thlang tuih ang cuk sak. ");
INSERT INTO hltthb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","U awm zaksimnaak haa ak ta ingtaw za seh nyng,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Thlang kqeng ce a cehtaak coengawh ipkhui na lut nawh, cawh a hubatkhqi ing cawhkaw nyhtahnaak awi ce doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","A mingmih a venawh, “Nangmih ingawm am naming zasim nawh nu? A leng nakawng thlang ak kawk khuina ak lut ikawmyih awk-ai ingawm thlang 'tyih' am cuk sak hy, tice am nami sim nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ce ik-oeih ce thlang ak kawlung khuina am lut nawh ak phoen khuina ni a luh, cawhkawng awh naat na cawn tlaih hy,” tinak khqi hy. (Ve ak awi ak kqawnnaak awh ve, awk-ai boeih ve “ciimcaih hy” tinawh Jesu ing kqawn hy.) ");
INSERT INTO hltthb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Cekcoengawh, “Thlang ak kawlung khui awhkawng ak cawn law ing ni thlang tuih ang cuk sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Cehlai kawlung khui nakaw, thlanghqing kawlung nakawng poeknaak amak thymkhqi cawn hy; kawpoek sangnaak, quuknaak, thlang himnaak, ");
INSERT INTO hltthb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","samphaihnaak, yytnaak, thawlhnaak, thailatnaak, yy thawhnaak, nainaak, tengkamnaak, oequnaak ingkaw qawnaakkhqi ce law hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Vawhkaw thawlhnaakkhqi boeih boeih ve thlang ak kawlung khui nakawng law nawh thlang ce tuih cuk sak hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesu ing ce a hun ce cehta nawh Tura khaw benna cet hy. Thlang ing ni hu kaw a ti awh im pynoet ak khuina lut hy; cehlai am thuh qu thai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Cawh a canu qaai ing am tu peek nu pynoet ing, anih law hy tice ang zaak awh, law nawh a haiawh khuk sym doena qeennaak thoeh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Cawhkaw nu cetaw Syria Phonicia awh ak thang Greek nu na awm hy. A canu ak kawkhui awhkawng qaai hqek peek aham Jesu a venawh qeenaak thoeh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Cawh Jesuh ing, “Naasenkhqi ing ak phyi na ai cang useh, naasenkhqi buh ce lawh penawh uikhqi ni peek peek am nep hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Cawhkaw nu ing, “Oeih, Bawipa, thym hy, cehlai naasenkhqi a ai hawi caboei ak kaina ak baw ce uikhqi ingawm lym lawt u sawkaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Cawh cawhkaw nu a venawh, “Cemyihna kak awi na nim hlat a dawngawh, voei hlah, qaai ing na canu cawn ta hawh hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Im na ang voei awhtaw ihkhun awhkaw ak zaih a canu ce hu hy, qaai ing anih ce cawn ta hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesu ing Tura qam ce cehta nawh Sidon khaw awhkawng Kalili tuili ingkaw Dekapolis qam na ce nu cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ce a hun awh ang ha pang nawh awi amak pau thai thlang pynoet ce law pyi uhy, ak khan awh kut tloeng peek aham qeennaak thoeh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesu ing anih ce thlang kqeng anglakawhkawng ak chang na a cehpyi coengawh, ang ha ce a kut ing pyih pehy. Cimtui a sa coengawh am lai ce bi pe bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Khan benna mang nawh a hyi coengawh, “Ephphata!” (”Awng qu hlah” tinaak) tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Cawh thlang ang ha ce khui nawh am lai awm zai hy, ak leek caana awi pau thai pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","U a venawh awm amak kqawn aham cekkhqi ce awi yn khqi hy. Cehlai cekkhqi ing kqawn khqoet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Anih ing ik-oeih boeih ak leekna sai nawh, hakpangkhqi haa khui sak nawh, pau aakhqi awm pau sak khqi hy,” ti unawh, amik kawpoekna kyi sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ce khawnghi awh thlang khawzah cun law bai unawh ai kawi ikawawm ama mi taak awh bubatkhqi ce khy khqi nawh, a mi venawh, ");
INSERT INTO hltthb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Vawhkaw thlang kqengkhqi ve khaw thum voei ni venawh awm hawh unawh, buh ai hly ikawiawm am ta usaw qeen khqi hy nyng; ");
INSERT INTO hltthb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","buh hyh na imna a ming voei awhtaw lamna nawk kawm uh, thlang vang khqoet taw khawk hla nakawng a mik lawna awm bai nawh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A hubatkhqi ing, “Thlang ing vemyih kqawng lakna ami ai khoek buh ni huh thai kaw?” ti unawh amah awihlat uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesu ing, “Phaihpi izah nami taak?” tinawh doet khqi hy. A mingmih ing, “Cun khqih” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Cawh anih ing thlang kqengkhqi ce dek awh ngawih ham awi pek khqi hy. Phaihpi cun khqih ce lo nawh zeel awi ak kqawn coengawh thek nawh thlangkhqi venawh tei peek ahamna a hubatkhqi pekkhqi hy, a hubatkhqi ing thlang kqengkhqi ce tei pek khqi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nga a khoeh ca ami taak ce awm bai nawh, zeel awi ak kqawn coengawh, thlang kqeng a venawh tei aham a hubatkhqi venawh kqawn pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Thlangkhqi ing ami ai awh phyi boeih uhy. Ami ai ngenkhqi ce a hubatkhqi ing vawh khqih na kawi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Cawhkaw buh ak aikhqi taw pa thak awm hqoeng thlang thawngli law uhy. Thlang kqeng ce a ceh sak coengawh, ");
INSERT INTO hltthb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","a hubatkhqi mi lawng khuina lut unawh Dalmanutha khaw benna ce cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farasikhqi law unawh Jesu ce awi doet uhy. Noek adak ham ngaih unawh khan ben nakaw hatnaak ce doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Cehlai ak kawlung ing ak tlona hyi nawh a mingmih a venawh, “Kawtih vawhkaw cadilkhqi ing kawpoek kyi hatnaak ce ami sui hy voei? Awitak ka nik kqawn peek khqi, kawmih hatnaak awm peek na am awm kaw,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A mingmih ce cehta nawh lawng khuina a luh coengawh vang ben caqai na ce cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A hubatkhqi ing phaihpi khyn aham hilh uhy, phaihpi pynoet doeng ce lawng khuina ta uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesu ing, “Ralriing lah uh, Farasikhqi ingkaw Herod a venawh ce nami cyih ta uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A mimah ingtaw, “Phaihpi amni taak a dawngawh ni,” tina poek uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Cekkhqi ak awih kqawn ce Jesu ing za nawh doet khqi hy: “Ikaw hamna phaihpi am nami taak akawng ce namik kqawn? Tuh dy namik kawlung awh am na ming zasim bak bak nawh nu? Namik kawlung na mi tiing sak hyn nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mik ta loei unawh am na ming hu nawh nu? Haa ta loei unawh am na ming za nawh nu? Na mim hilh hawh nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Thlang thongnga aham phaihpi cun nga kang tei awh, ak ngen vawh izah nu nami kawih ce? tinak khqi hy. Cekkhqi ing, “Vawh hqa hlaihih,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Thlang thongli aham phaihpi cun khqih kang tei awh, ak ngen vawh izah nu nami kawih ce? tinak khqi bai hy. Cekkhqi ing, “Vawh khqih,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","A mingmih a venawh, “Am na ming zasim hlan bak bak nawh nu?” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bethsaida khaw ce ami pha awh thlang vang ing mikhyp pynoet ce lawpyi unawh, anih ce bi aham Jesu a venawh qeennaak thoeh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mikhyp ce tu nawh khawceng na ceh pyi hy. Amik awh cimtui sa pe nawh ak khan awh a kut tloeng pehy, cekcoengawh, “Nak hu thai hawh aw? tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hang mang law nawh, “Thlangkhqi ce thingkhqi ak cet myihna hu nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Cekcoengawh ce ak thlang amik awh Jesu ing a kut tloeng pe tlaih bai hy. Cawh amik ce dai tlaih nawh ik-oeihkhqi ce ak caih pheng na hu hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","“Khawk khuina koeh cet moe,” tina nawh im na tyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kaiserea Philipi khaw ceng khaw cawikhqi awh Jesu ingkaw a hubatkhqi taw cet uhy. Cawh lam awh a mingmih ce doet khqi hy, “Kai ve thlangkhqi ing u nu ami ti?” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A mingmih ing, “Thlang vang ing Baptisma ak pekung Johan; thlang vang ing Elijah; thlang vang bai ingtaw tawngha pynoet oet ni ti uhy,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Nangmih ingtaw kai ve u nu nami ti?” tinak khqi hy. Cawh Piter ing, “Nang taw Khrih ni,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesu ing amah akawng ce u venawh awm amak kqawn aham cekkhqi ce yn khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Thlanghqing Capa ing khuikha hu kawmsaw, a hqamcakhqi, khawsoeih boeikhqi ingkaw anaa awi cawngpyikungkhqi ing hoet kawm uh, anih ce him kawm usaw am thum nyn awh tho tlaih kaw, tinawh cekkhqi ce cawngpyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ve akawng ve ak caih caana kqawn pehy, cedawngawh Piter ing ak changna khy nawh kaa na hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Cehlai Jesu ing a hubatkhqi benna mang nawh Piter ce zyi hy. “Setan! Ka huna thoeih lah, Khawsa a kawnglam ak poek kaana, thlanghqing a kawnglam doeng ni nak poek hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Cekcoengawh thlang kqeng ce a hubatkhqi mi a venna khy nawh: “U ingawm ka hu awh bat law ham a ngaih awhtaw amah ingkaw amah ce hoet qu seh, amah a thinglam ce kawh doena ka hu awh bat seh. ");
INSERT INTO hltthb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","U awm a hqingnaak thaawng ham ak ngaih ingtaw a hqingnaak ce hlawng kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Thlang ing khawmdek ve a pum boeih na ham mai seiawm, a hqingnaak a hlawng awhtaw anih ham ikaw phu ak taak? ");
INSERT INTO hltthb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Thlang ing a hqingnaak lakawh ikaw a pek thai kaw? ");
INSERT INTO hltthb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","U ingawm ve samphaih ingkaw thawlh dung khuiawh kai ingkaw kak awi ak chahn pyi thlang taw, thlanghqing Capa ing Pa boeimangnaak ing ak khan ceityihkhqi mi a law awh anih ce chah pyi lawt kaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Cekcoengawh a mingmih a venawh, “Awitak ka nik kqawn peek khqi, thaawmnaak ing Khawsa qam a law ce ami huh hlandy vawh amik dyi thlang vangkhqi lakawh thihnaak amak tan hly kawi thlang awm hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ak kquk nyn coengawh Jesu ing Piter, Jakob ingkaw Johan ce khy nawh tlang sang na kaai pyi khqi hy, cawh ce a mimah doeng awm uhy. Cawh a mimah a haiawh a myi thaw pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A hi ce a baawk phung na vang hy, khawmdek awh ce anglakawh ak baawk am awm hy ti tluk na baawk hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Cekkhqi haiawh Elijah ingkaw Mosi awm dang pe nawh Jesu mi awi kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piter ing Jesu a venawh, “Cawngpyikung vawh awm ve nep soeih hy. Buk pakthum awh chuh usih - pynoet ce nang aham, pynoet ce Mosi aham seitaw pynoet ce Elijah aham seh,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Amik kqih aih awh ikaw amik kqawn hly awm am sim lat uhy.) ");
INSERT INTO hltthb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Cawh cingmai ing zawl khqi khoep nawh, khawk khan nakawng: “Vetaw ka lungnaak ka Capa ni. Ak awi ngaih pe uh,” tinawh awi ce law hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kawlhkalh awh, mang usaw Jesu doeng am taw ak chang u am hu qoe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tlang nakawng ami nuk kqum awh, Thlanghqing Capa thihnaak awhkawng a thawh hlan dy cawhkaw ik-oeih ami huhkhqi ce u a venawh awm amak kqawn aham cekkhqi ce awi pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Cawh a mimah ingkaw a mimah ce, “Thihnaak awhkawng thawh tlaihnaak” tive ikawmyih nu?” tinawh doet qu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","”Kawtih anaa awi cawngpyikungkhqi ing Eliajah ve lamma na law kaw, ami ti bai hy voei?” tinawh doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesu ing, “Elijah ve lamma na law tang hy, anih ing ik-oeihkhqi boeih qoek abah kaw. Cawhtaw kawtih thlanghqing Capa ing khuikha zaawk kawmsaw hoet kawm uh, tinawh a na qee hyt hy voei? ");
INSERT INTO hltthb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Cehlai ka nik kqawn peek khqi, Elijah taw law hawh nawh akawnglam ami qee hawh a myihna ak khanawh ami ngaih ngaih amyihna sai hawh uhy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","A hubatkhqi ven a nuk pha awh, thlang kqeng khawzah anglakawh anaa awi cawngpyikungkhqi mi ami nang oelh qu ce hu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Thlang kqengkhqi ing Jesu ami huh awh, amik kawpoekna kyi nawh anih ak do na ce dawng uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Cawh anih ing a mi venawh, “A mingmih mi ikaw nu naming oelh qu?,” tinawh doet khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Cawh thlang kqeng ak khui awhkaw thlang pynoet ing, “Cawngpyikung, ka capa, qaai ing am tu nawh awi amak pau thai law pyi nyng. ");
INSERT INTO hltthb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","A pha pha awh dek na tlu hoeih hoeih hy. Am kha awh a cimtui pem nawh, a ha ak taak nawh ak thang ing dawk poepa hy. Na hubatkhqi venawh qaai ce hqek aham kqawn pek khqi hlai nyng, am sai thai uhy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesu ing, “Aw cangnaak amak ta cadil tloek, nangmih a venawh iqyt dy nu ka awm kaw? I qyt dy nu kang yh hly bak bak? Naasen ce ka venna law pyi lah uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Naasen ce a venna law pyi uhy. Qaai ing Jesu ce a huh awh, cawhkaw naasen ce phep khqoet nawh am kha awh cimtui pem nawh dek awh zeet khoeng khoeng hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“Ve myihna iqyt nu a awm hawh?” tinawh naasen a pa ce doet hy. Anih ing, “A naasen ca awhkawng hawh ni,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Mai awh awm tui awh awm a thihnaak aham buuk poepa hy. Nang ing na sai thai awhtaw nim qeen nawh nik pyi lah,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Na sai thai awhtaw e! ak cangnaak ham taw ik-oeih boeih boeih coeng thai hy,” tinawh Jesu ing tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Cawh naasen a pa ing, “Cang na nyng, am kak cangnaak ka noengnaak ham nik pyi lah!” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Cawhkaw ik-oeih ak toek na thlangkhqi amik law ce Jesu ing a huh awh, qaihche ce zyi nawh a venawh, “Nang qaai pau aa ingkaw hak pang, awi ni pe nyng, ak khui awhkawng cawn nawh, koeh lut qoe voel,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Cawh qaai ing cawhkaw naasen ce thyn sak nawh dek awh ang zeet sak tlyp tlyp coengawh khy nawh cawn hy. Cawhkaw naasen taw thlak thi amyihna awm hqoeng nawh thlangkhqi ingtaw, “Thi hawh hy,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Cehlai Jesu ing anih ce a kut awh tu nawh thawh saw anih ce dyi pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ipkhui na a lut awh a hubatkhqi ing, “Ikawtih kaimih ingtaw am kami hqek thai hy voei? ti unawh ang hyp na doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesu ing, “Vemih taw cykcahnaak doeng ing ni ak cawn thai,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ce a hun ce cehta unawh Kalili qam awhkawng cet phat unawh thlang ing a mi awmnaak a sim ham Jesu ing am ngaih hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","A hubatkhqi ce a cawngpyi khqi a dawngawh, ami venawh, “Thlanghqing Capa ve thlang a kut awh tu sakna awm kawm saw, himna awm kawm usaw, cawh a mi him am thum nyn awh tho tlaih kaw,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Cehlai ak awih kqawn a konglam ce am zaak pe sim thai qoe uhy, ami doet hly nu kqih koek uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kaperanuam khaw ce pha law uhy. Ipkhui na ami awm awh, a hubatkhqi ce doet hy. “Lam awh kawmih akawng nu a ming oelh qu?” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","”U nu ak bau khyt,” tice lam awh a ming oelh qu a dawngawh a ming hqi phah uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nung ngawi nawh a hubat thlanghqa hlaihih tloek ce ak khy coengawh, “U awm maa ham ak ngaih ingtaw thlang boeih a hukhit na awm seitaw thlang boeih a tyihzoeih na awm seh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Naasen pynoet ce lo nawh cekkhqi anglakawh dyih sak hy. Cawhkaw naasen ce pawm nawh, a mingmih a venawh, ");
INSERT INTO hltthb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“U awm vawhkaw naasen khqik khuiawh pynoet awm kang ming ing ak do thlang taw kai anik do na awm hy; U awm kai a nik do thlang taw kai amni do nawh kai anik tyikung ni a do,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Johan ing, “Cawngpyikung, thlang pynoet ing nang ang ming ing qaai a hqek ce hu u nyngsaw, ningnih ak khui awhkaw thlang na ama awm a dawngawh kham pe u nyng,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesu ing, “Koeh kham pe uh, kai ang ming ing kawpoek kyi ik-oeih ak sai ing kai a seetnaak ap kqawn tikaw, ");
INSERT INTO hltthb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ningnih ama nik oelh thlang taw ningnih ben thlang ni. ");
INSERT INTO hltthb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Awitak ka nik kqawn pek khqi, Khrih a koe na nami awm a dawngawh kai ang ming ing tui boet oet awm ak pe taw ityk awh awm kutdo ce am zyng tikaw. ");
INSERT INTO hltthb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“U ingawm kai anik cangnaak ve naasen khqik khuiawh pynoet awm a thawlh sak mantaw, anih ce a hawng awh cang neetnaak lung ak bau ce awi sak nawh tui na nik khawng man anih aham nep bet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na kut ing a ni thawlh sak awhtaw tlyk boet mai. Na kut pakkhih ak soep na amak thi qoe hell mai khuina ang tlaak anglakawhtaw kut amak soep na hqingnaak khuiawh na lut ce nang ham nep bet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Cawhkaw hell mai khui awhtaw mehkqit awm am thi thai nawh mai awm am thi thai qoe hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na khaw ing a ni thawlh sak awhtaw, tlyk boet mai, khaw pakkhih ak soep na hell khuina nang tlaak anglakawhtaw khaw ngun na hqingnaak ak khuiawh na lut ce nang ham nep bet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Cawhkaw hell mai khuiawh taw mehkqit awm am thi thai nawh mai awm am thi thai qoe hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na mik ing a ni thawlh sak awhtaw, koeih mai. Mik pakhih ak soep na hell khuina tlaak anglakawhtaw mik lang doeng ing Khawsa ram khuiawh a lut ce nep bet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Cawhkaw hell khui awhtaw 'mehkqit awm am thi thai nawh mai awm am thi thai qoe hy'. ");
INSERT INTO hltthb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Thlang boeih mai awh ci ing alna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","”Ci ve nep hy, cehlai a alnaak ve a paih mantaw, ikawmyihna na al sak thai tlaih kaw? Ci a myihna al unawh, thlang boeih mi qoep ang qui na awm lah uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Cekcoengawh Jesu ing ce a hun ce cehta nawh Jordan long caqai Judah qam benna cet hy. Cawh thlang kqeng ing a ven pan law tlaih bai uhy, a sai khawi amyihna cekkhqi ce cawngpyi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farasi thlang vangkhqi ce law unawh noek a dak naakna awi doet uhy, “Thlang ing zu ak thlak ham ak thym hly nu?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Anih ing, “Mosi ing ikawk awi nu a na peek khqi?” tinawh doet khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Cekkhqi ing, “Mosi ingtaw zu thlak thainaak caa qee nawh zu thlak thainaak pehy,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesu ing, “Na mik kawlung a hqam soeih a dawngawh cemyihna anaa awi a na qee mai ni. ");
INSERT INTO hltthb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Cehlai ak cyk caawh Khawsa ing pa ingkaw nu a na sai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ve akawngawh pa ing a nu ingkaw a pa ce cehta nawh a zu tu lawm saw; ");
INSERT INTO hltthb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","pakhih ce pum pynoet na awm kawm nih,' tina hy. Cedawngawh pakkhih na am awm voel nih nawh, pumoet na awm hawh hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Cedawngawh Khawsa ing a tawm ce hawh taw thlanghqing ing koeh hqe seh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ipkhui na ami awm awh, ve akawng ve a hubatkhqi ing doet tlaih bai uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A mingmih a venawh, “U ingawm a zu ce thla nawh nuk chang ce a zu naak tlaih awhtaw a zu ak khanawh sam ak phaih ni. ");
INSERT INTO hltthb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nu ingawm a va ma nawh thlak chang a va naak awhtaw anih awm sam ak phaih ni,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jesu ing a bi hamna naasen cakhqi ce law pyi khqi uhy, cehlai a hubatkhqi ing kaa nak khqi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Cehlai Jesu ing cece a huh awh, ak kaw am law nawh, a hubatkhqi venawh, “Naasen cakhqi ce ka venna law pyi khqi lah unawh, koeh hqek khqi uh, kawtih khan qam taw vemyihna ak awm thlangkhqi aham na ni. ");
INSERT INTO hltthb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Awitak ka nik kqawn peek khqi, u awm Khawsa ram ce naasen ca myihna amak do taw ityk awh awm ak khuina am lut tikaw,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Naasenkhqi ce lo nawh ak pawn coengawh, a mingmih ak khan awh a kut tloeng nawh zoseennaak pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lam na a ceh awh, thlang pynoet ce a venna dawng law nawh a haiawh khuk sym doena, “Cawngpyikung leek, kumqui hqingnaak ka huhnaak thai ham ikaw ka sai hly?” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu ing, “Ikawtih 'leek hy' tinawh na nik khy? Khawsa doeng tikaa taw u awm am leek hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Awipeekkhqi sim tik sawkaw: 'Thlang koeh him, koeh samphaih, koeh qu, amak thym dyihthing na koeh dyi, thlang koeh qaai na, na nu ingkaw na pa kqihchah lah,' a tice,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Anih ing, “Cawngpyikung, vekkhqi boeih ve ka naasen awhkawng ni ka sai hawh hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu ing anih ce toek nawh lungna soeih nawh, “Ik-oeih pynoet voet hyn hy,” tina hy. “Cet nawh na kawhthemkhqi boeih ce zawi nawh khawdeng hahqahkhqi ce pe, cawhtaw khawk khanna qo ta kawp ti; cekcoengawh law nawh ka hu awh bat law,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cehlai a hai ta malh nawh, ik-oeih khawzah a taak a dawngawh kawseet doena valh tlaih hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesu ing hawi ang mang nawh, a hubatkhqi venawh “Bawikhqi ing Khawsa ram awh a luhnaak aham kyi soeih mah hy!” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ak awih kqawnnaak awh a hubatkhqi taw aming ngaih na kyi hy. Cehlai Jesu ing, “Naasenkhqi, boei ak ypnaak thlangkhqi ham Khawsa qam khuiawh lut ve kyi soeih mah hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bawi ak thlang ing Khawsa ram khuiawh a lut anglakawh Kalauk ing kqym ak khuiawh a lut zoei bet hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A hubatkhqi ce amik kawpoek kyi khqoet nawh, “Cawhtaw u nu hul na ak awm hly hy voei?” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu ing a mingmih ce toek khqi nawh, “Thlanghqing aham taw am coeng thai hy, cehlai Khawsa ham taw ik-oeih boeih boeih ve coeng thai hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piter ing, “Kaimih ing ik-oeih boeih boeih cehta unawh na hu ka ming bat law ve!” tinawh doet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu ing, “Awitak ka nik kqawn peek khqi, u ingawm kai ingkaw awithang leek ak caming a im a lo, a koeinaa, a koeinanu, a nu apa, a canaakhqi ingkaw a lokhqi a cehtaak awhtaw ");
INSERT INTO hltthb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tuh a khuk qoe awh a pyh zakhat dyna (imkhqi, a koeinaakhqi, a koeinukhqi, a nu a pakhqi, a canaakhqi ingkaw a lokhqi - cekkhqi ingkaw thekhanaakkhqi) ingkaw ak law hly a khuk awh, kumqui hqingnaak ce hu kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Cehlai ak maakhqi ce huu khyng kawm usaw huu ak khyngkhqi ce maa lat kawm uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalem benna ami hang ceh awh, Jesu taw a mingmih a haiawh lamma na cet hy, cawh a hubatkhqi taw amik kawpoek kyi hy. Thlanghqa hlaihih tloek ce ak chang na cehpyi nawh ak khan awh ik-oeih ak pha law hly ce kqawn pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Tuh Jerusalem na ni hang cet kawm usaw, thlanghqing Capa ve khawsawih boeikhqi ingkaw anaa awi cawngpyikungkhqi kut awh peekna awm kaw. A mingmih ing thih hamna ak khanawh awi tluuk sak kawm usaw Gentelkhqi kut awh pe kawm uh, ");
INSERT INTO hltthb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Cekkhqi ing anih ce the a kha na kawm usaw him kawm uh. Cehlai am thum nyn awh tho tlaih kaw,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedi a caqawi, Jakob ingkaw Johan ce a venna law hy nih. Cekkqawi ing, “Cawngpyikung, ka ni thoeh law a hoei boeih ve na sai hamna ngaih hlai nih nyng,” tina hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Anih ing, “Ikaw sai sak ham nu nani ngaih?” tinak kqawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Cekkqawi ing, “Na boeimangnaak khuina na awm awh pynoet tang benna pynoet cawng benna na ning ngawih sak qawi aham ngaih nih nyng,” tina hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Cawh Jesu ing, “Ik-oeih nani thoeh ve am sim hy nik ti. Ka aawk hly kawi boet ve nami aw hly thai nawh nu? Baptisma ka huh hly kawi ve nani hu hly thai nawh nu?” tina qawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Cekkqawi ing, “Oeih, hu thai lawt kawng nih nyng,” tina hy nih. Jesu ing, “Kai ing ka aawk hly kawi boet ce aw thai kawm nih tiksaw ka huh hly kawi baptisma awm hu thai kawm nik ti, ");
INSERT INTO hltthb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Cehlai kak tang ben ingkaw kak cawng benawh ngawih thainaak taw kai ak cam amni, a hoep peek ak thlangkhqi ham ni,” tina qawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ce ak awi ce thlanghqa tloek ing aming zaak awh Jakob ingkaw Johan ak khan awh amik kaw am law hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesu ing a mingmih ce kutoet na khy khqi nawh, “Gentel ukkungkhqi ing a mimah Gentelkhqi ak khan awh boeina ami awm ce sim u hyk ti, dyih hun ak sang na ak awmkhqi ing a mingmih ce a ngaihnaak a myihna uk uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Cehlai nangmih taw cemyihna am awm kawm uk ti. Nangmih anglakawh u ingawm ak bau khyt na awm a ngaih awhtaw nangmih a tyihzoeih na awm seh. ");
INSERT INTO hltthb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","U awm lamma na awm ak ngaih ingtaw nangmih boeih a tamnaa na awm seh. ");
INSERT INTO hltthb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ikawtih thlanghqing Capa ing za thlang bibi sak aham am law nawh, thlang a bi ak bi ham ni a law, thlang khawzah hulnaak aham a hqingnaak ak pe aham nani a law,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Cekcoengawh Jeriko khaw na ce pha uhy. Jesu ing a hubatkhqi, thlang kqeng mi khawk bau awhkawng ami ceh hui awh, mikhyp pynoet, Timai a capa, Bertimai ak mingnaak, taw lam keng awh ngawi nawh a kut dun hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nazareth khaw awhkaw Jesu ni ak cet tice ang zaak awh, “David Capa, Jesu, kai nim qeen lah!” tinawh khy hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Thlangkhqi ing awm dym aham zyi uhy, cehlai anih ing,, “David Capa kai nim qeen lah!” tinawh khy hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu ing dyi nawh, “Anih ce khy lah uh,” tinak khqi hy. Cedawngawh cawhkaw mikhyp ce khy uhy, “Nang ngaih qep sak nawh dyi lah, nik khy nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Anih ing a hi ce khawng nawh ang peh doena Jesu a venna cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu ing, “Nak khanawh ikaw sai pek ham na ngaih?” tina hy. Cawh, mikhyp ing a venawh, “Rabboni, huh thai ngaih hy nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesu ing a venawh, “Cet hlah, nak cangnaak ing ni qoei sak hawh hy,” tina hy. Bawtbet awh amik ce dai nawh Jesu a hu awh bat pahoei hy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalem ce pha law tawm unawh Bethphage ingkaw Bethani khaw awhkaw Olive tlang ce ami pha law awh, a hubat thlang pakhih ce haina tyi nawh, ");
INSERT INTO hltthb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ani venawh, “Nani haai awhkaw khaw ak awmna cet nih nawh khawk khuina nani lut awh, u ingawm a mang ngawihnaak hlan, laa ca amik pai ce hu kawm nik ti. Suut nih nawh sawi law nih. ");
INSERT INTO hltthb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","U ingawm, 'Ikaw hamna nani sai?' a ti awhtaw, 'Bawipa ing ngoe hy, thak law sak tlaih bit kaw,' tina nih,” tina qawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Cekkqawi ce cet nih nawh vawng chawmkeng a venna, laa ca amik pai ce hu hy nih. Laa ca ce a ni hlan awh, ");
INSERT INTO hltthb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","cawhkaw ak dyikhqi ing, “ikaw hamna laa ce nani hlam?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesu ing a yn amyihna kqawn pe nih nawh cekkhqi ing ceh sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Laa ca ce Jesu venna sawi hy nih, cawh hikhqi ce laa ca ak khan awh phaih unawh, ak khanawh ngawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Thlangkhqi ing hi ce lam awh phaih pe uhy, thlang vang ing thingbupkhqi ce chawm unawh lam awh phaih pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Haina ak cetkhqi ingkaw hu benna ak lawkhqi ing, “Hosanna!” “Bawipang ming ing ak law taw a zoseen seh!” ");
INSERT INTO hltthb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Ak law hly kawi ni pa David a qam taw zoeksang na awm seh!” “Sawsang soeih awh Hosanna!” tinawh khy uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusalem khawk khuina Jesu taw cet nawh bawkim ak khuina lut hy. Ik-oeihkhqi ce toek nawh khaw a my hawh a dawngawh, thlanghqa hlaihih tloek mi Bathani khaw na cet tlaih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","A khawngawi awh Bathani khaw awhkawng ami law tlaih awh, Jesu taw ak phoen cawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ak hla nakawng a hah hqoeng na ak awm thai thing ce hu hy, ak thaih ak awm hy voei nu tinawh a kung na pan hy. Cehlai a pha awh, thai a qahnaak tym na ama awm dawngawh a hah hqoeng ce hu hy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Cawh thai thing na ce, “Itykawm nak thaih ve u ingawm koeh ai voel seh,” tina hy. Ce ak awi ce a hubatkhqi ingawm za lawt uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalem ami pha awh Jesu ing bawkim khuina lut nawh ik-oeih ak zawikhqi ingkaw ak thlaikhqi ce hqek khqi hy. Tangka ak thungkhqi a caboeikhqi ce khuphlet pe nawh kqukqu ak zawikhqi ang ngawihnaak khqi awm khuphlet pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ik-oeihkhqi ce bawkim khui awhkawng am khyn sak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ami venawh: 'Ka im ve pilnam thlangkhqi a cykcahnaak im na awm kaw,' tinawh qeena am awm nawh nu? Nangmih ingtaw quk-aikhqi ak khui ak kawk' na nami sai,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Khawsawih boeikhqi ingkaw anaa awi cawngpyikungkhqi ing ce akawng aming zaak awh amah ami himnaak thai ham lam ce sui uhy, anih a cawngpyinaak awh thlang kqeng ak kawpoek a kyi a dawngawh, anih ce kqih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Khaw a my law awhtaw khawk bau ce cehta uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","A khawngawi mymcang ami ceh tlaih awhtaw, thai thing ak kqa dyna a koh ce hu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piter ing poek hqoet nawh Jesu a venawh, “Cawngpyikung, toek lah! thai thing nang ing na zyih ce thi hawh hy ce!” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu ing, “Khawsa awh ce cangnaak ta lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Awitak ka nik kqawn peek khqi, u ingawm vawhkaw tlang na ce 'Thoeih nawh tuili na khawng qu lah' tinawh upvoetnaak taak kaana ak kqawn ce coeng ngai ngai kaw, tinawh ak cangnaak awhtaw, a ti amyihna awm pekaw. ");
INSERT INTO hltthb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Cedawngawh ka nik kqawn peek khqi, nangmih ing cykcahnaak ing ik-oeih nami thoeh awh hu hawh nyng tinawh cangna uh, cawhtaw hu kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Cykcah aham naming dyih awh nak khan awh ik-oeih ak sai thawlh a awm awhtaw qeen lamma cang uh, cawh ni khawk khan nakaw ak awm nangmih a Pa ing nangmih a thawlhnaakkhqi a nim qeen hly khqi lawt. ");
INSERT INTO hltthb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Cehlai am namim qeen awhtaw khawk khan nakaw ak awm nami Pa ingawm nangmih a thawlhnaakkhqi ce am nim qeenkhqi lawt kaw,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusalem pha law unawh, Jesu ing bawkim khuina a ceh awh, khawsoeih boeikhqi, anaa awi cawngpyikungkhqi ingkaw a hqamcakhqi ce a venna law uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Hanakaw saithainaak ing vawhkaw ik-oeihkhqi ve na sai? U ing vemyih ik-oeihkhqi ve a ni sai sak?” tinawh doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu ing, “Awi pynoet awh ni doet khqi cang vang. Nim hlat lah uh, cawh ni hanakaw saithainaak ing kai ing vawhkaw ik-oeihkhqi ka sai, tice kak kqawn hly lawt hy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Johan a Baptisma ve - khan benna kaw nu, am awhtaw thlanghqing benna kaw nu? Kqawn law lah uh!” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Cawh a mimah ingkaw a mimah ce doet qu uhy,” Khan benna kaw ni tinaak mantaw, 'Cawhtaw kawtih amna mik cangnaak? niti nak khqi kawh. ");
INSERT INTO hltthb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","'Thlanghqing benna kaw ni,' ni tinaak bai mantaw,” ti uhy. Cehlai thlang kqeng ce kqih khqi bai uhy, thlang boeih ing Johan taw tawngha ni, ami ti a dawngawh. ");
INSERT INTO hltthb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Cedawngawh Jesu a venawh ce, “Am sim unyng,” tina uhy. Cawh Jesu ing, “Cawhtaw hanakaw saithainaak ing kai ing vawhkaw ik-oeihkhqi ka sai, tice ap kqawn lawt kawng,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","A mingmih a venawh nyhtahnaak ing awi kqawn pek khqi tlaih bai hy:“ Thlang pynoet ing misur dum ta hy. Vawng a sung boeih coengawh, misur suinaak aham dek co nawh a qehnaak im sa hy. Cekcoengawh misur dum khuiawh bi ak bi aham thlang vat nawh amah ce khawk hla na cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Misur qah bih tym a pha awhtaw a dum khuiawh kaw misur qah bih aham a tamnaa thlang pynoet dum khuiawh kaw bibikungkhqi venna tyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Cehlai cekkhqi ing tu unawh ami vyk coengawh kut hqawng na tyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Cekcoeng bai awh tamnaa ak chang pynoet ce cekkhqi venna tyi bai hy; anih ce a lu awh vyk unawh chahqai na sai uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ak chang tamnaa ce tyi tlaih bai hy, cehlai cekkhqi ing anih ce him uhy. Cekcoengawh tamnaa khawzah tyi hlai hy, cekkhqi ing a vang ce vyk unawh a vang ce him uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Cawhtaw tyih aham a lungnaak soeih a capa pynoet doeng ni a awm hawh. A hukhit nataw a capa ce tyi hy, 'Ka capa taw kqihchah na kawm uh,' tinawh poek hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Cehlai dum bibikungkhqi ing, 'Anih ce qo ak pangkung ni ve. Law uh, him unawh a qokhqi ce ningnih aham awm seh,' ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Cedawngawh anih ce tu unawh ami him coengawh vawng ak ceng na khawng uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Cawhtaw misur dum ak takung ing cekkhqi ce ikawmyihna a tinaak khqi kaw? Law kawm usaw dum bibikungkhqi boeih ce a him coengawh misur dum ce thlak chang kut awh pe kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Vawhkaw khaw cabu awi ve am nami noet nawh nu? “Im ak sakungkhqi ing ami qoeng lung ce, a kil awhkaw phu ak awm soeih na awm hawh hy; ");
INSERT INTO hltthb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ve ve Bawipa ing a sai ni, nimik huh awh kawpoek kyi na awm hy, a tive,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","A mingmih ni ak kqawn sih khqi tice ami sim awh amah ce tu thai aham a tym leek ce sui uhy. Cehlai thlang kqeng ce amik kqih a dawngawh anih ce cehta uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Cekcoengawh ak awih kqawn awh a thawlhnaak tu peek aham Farasikhqi ingkaw Herod ak thlang pynoet ce Jesu a venna tyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Cekkhqi ing a venawh. “Cawngpyikung, nang ing ak thym ni nak kqawn tice ni sim unyng. U a haai awm am toek hyk ti, thlang pek a bonaak am na toek a dawngawh; Khawsa alam ce awitak na thlang cawngpyi hyk ti. Kaisar a venawh mangmu peek aham ak thum nu? amak thym nu? ");
INSERT INTO hltthb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ka nik pe hly nu, am ka nik pe hly nu? tina uhy. Cehlai Jesu ing a mingmih a qaai kqawn ce sim hqet nawh, “Ikaw hamna kai a thawlhnaak ce nami sui uh? Denari ce hawlaw lah uh, toek lah vang,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","A mingmih ing Denari ce pe uhy, cawh, “Vawhkaw myihlip ve u ang myihlip nu ve? U ang ming nu ve?” tinak khqi hy. Cekkhqi ing, “Kaisar,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesu ing a mingmih a venawh, “Kaisar a them ce Kaisar a venawh pe uh, Khawsa a them taw Khawsa venawh pe uh,” tinak khqi hy. Cawh anih ak khan awh amik kawpoek kyi soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Cawh thawh tlaihnaak am awm hy, amik ti Sadusikhqi ing awi doet aham a venna law uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","”Cawngpyikung, Mosi ingtaw, thlang ing a zu lo hlai hy, ca a taak kaana a thih taak awhtaw a naa ing a zu ce pang kawmsaw ak taipa aham ca taak pekaw, tinawh qee law hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Cingnahqui thlang khqih awm uhy. A hqamkhit ing a zu lo moe ca taak kaana a zu ce thih tahy, ");
INSERT INTO hltthb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A pakkhih naak ing cawhkaw nu ce pang hy, ca taak kaana thih ta bai hy. Ceamyihna a pakthum naak ingawm zu ce thih ta bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Cingnahqui thlang khqih tloek ing cawhkaw nu ce zu na boeih hlai uhy, ca taak kaana thih ta boeih uhy. A hukhit na taw nu ce awm thi lawt hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Thawh tlaihnaak khawnghi awh cawhkaw nu ce a u a zu na a awm kaw, thlang khqih ing zu na boeih bai usaw?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu ing ami venawh, “Ve ak caming ni ka ti naming poeknaak a hqee hy, Khawsa cauk ciim ingkaw Khawsa ak thaawmnaak am nami sim ak camawh? ");
INSERT INTO hltthb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Thlak thikhqi ami thawh tlaih awhtaw nupa chungvaanaak am awm voel kawm saw, khan nakaw khan thlangkhqi amyihna awm hawh kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Thlak thi thawh tlaihnaak awh - Mosi ak cabu khuiawh, thingbup akawng caqee ce am nami noet khawi nawh nu? Khawsa ing Mosi a venawh, 'Kai taw Abraham Khawsa, Isak Khawsa ingkaw Jakob Khawsa na awm nyng,' a ti ce? ");
INSERT INTO hltthb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Anih cetaw thlak thikhqi a Khawsa na am awm nawh, thlak hqingkhqi a Khawsa nani a awm. Nangmih ing poek thawlh soeih uhyk ti,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Caqeekung thlang pynoet ce law nawh awi aming oelh qu ce hu hy. Jesu ing awi ak leek caana hlat pehy tice a huh awh, “Awipeek boeih boeih ak khuiawh han ak awipeek nu awihtung soeih? tinawh doet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu ing, “Awipeek awihtung soeih taw veni: 'Ngai lah uh, Aw Isaraelkhqi, ningnih a Bawipa Khawsa taw pynoet doeng ni. ");
INSERT INTO hltthb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bawipa na Khawsa ce nak kawlung boeih ing, na hqingnaak boeih ing, na myihla boeih ing, nak kawpoek boeih ing, nak thaawmnaak boeih ing lungna. ");
INSERT INTO hltthb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A pakhih naak taw veni: 'Na imceng ce namah a pum myihna lungna lawt kawp ti, a tive. Vekkqawi anglakawh ak bau khqoet awipeek am awm voel hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ce ak thlang ing, “Cawngpyikung, nak kqawn ce nep hy. Khawsa pynoet doeng ni a awm, na tice thym hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nak kawlung boeih, nang zaaksimnaak boeih ingkaw nak thaawmnaak boeih ing lungna nawh, imceng awm nimah a pum myihna lungnaak ve hyih phumnaak boeih ingkaw bulnaak sainaak boeih boeih anglakawh awm awihtung khqoet ni,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Anih ing cyihnaak ing awi hlat pehy tice Jesu ing a huh awh ce a venawh, “Nang ve Khawsa ram ing hla hyk ti,” tina hy. Cawhkaw ingtaw u ingawm am doet hqa voel hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Bawkim khuiawh Jesu ing a cawngpyi awh, vemyihna awi doet hy, “ikawmyihna anaa awi cawngpyikungkhqi ing Khrih ve David capa ami ti hy voei? ");
INSERT INTO hltthb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David amah ing Ciim Myihla ak caming: “Bawipa ing a boeipa a venawh: “Na qaalkhqi ce na khawk kaina ka taak hlan dy kak tang ben awh ngawi lah,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David amah qoe ing, 'Bawipa' tinawh khy hy. Cawhtaw ikawmyihna a capa na a awmnaak bai hy voei?” tinawh doet khqi hy. Thlang kqeng khawzah ing ak awi ce zeel doena ngai pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A cawngpyinaak awh Jesu ing, “Anaa awi cawngpyikungkhqi awh ce nami cyih ta lah uh. Amingmih ing hikdung a nawinawk na bai ngaih unawh ik-oeih zawihnaak hqang thlang ing kqihchahnaak a peek ce ngaih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sinakawk na ngawih hun ak nep nep awh aming ngawih ce lungna unawh buh veelnaak kung awh a qyp ak awm ngawihnaakkhqi awh aming ngawih ce lungna uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nuhaikhqi a im ce qawt pe unawh thlang a huh awh ak dung soeih na cykcah uhy. Vemih ak thlangkhqi ve ak tlo soeih na toelnaak hu kawm uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tangka amik channaak bawm a haihkep awh Jesu ce ngawi nawh thlangkhqi ing bawkim tangka bawm khuiawh tangka amik chan ce toek hy. Boei thlang khawzah ing tangka khawzah zah chan uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Cawh nuhai hahqah ca pynoet ce law nawh qawhum tangka pakkhih ce chan lawt hy, cetaw penny pynoet ing myih hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","A hubatkhqi ce a venna khy nawh a mingmih a venawh, “Awitak ka nik kqawn peek khqi, vawhkaw nuhai hahqah ca ing thlang boeih anglakawh bawkim awhkaw tangka bawm khuiawh khawzah khqoet chan hy. ");
INSERT INTO hltthb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Cekkhqi ingtaw ami taak ngen ce pe uhy; cehlai anih ingtaw a haqahnaak ak khui awhkawng - a hqingnaak aham a taak dyyt ce pe boeih hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bawkim awhkawng ak cawn awh, a hubat thlang pynoet ing a venna, “Cawngpyikung, toek lah! Lung ingkaw im a leek aih awm!” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesu ing, “Vawhkaw im ak bau soeih soeih khqi my? Cehlai vawhkaw lung ami khoengkhqi pynoet ca awm a sim kaana ak awm pynoet awm am awm kaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bawkim a dan awh Olive tlang awh ang ngawih awh, Piter, Jakob, Johan ingkaw Andru mihkhqi ing ang hyp na doet uhy, ");
INSERT INTO hltthb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Vawhkaw ve ityk awh a awm kaw? Cekkhqi boeih a cup tawm awh ikawmyih hatnaakkhqi nu a awm kaw? tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesu ing a mingmih a venawh: “Thlang ing a mami thailatnaak khqi ham ngaih ta lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kai ang ming ing thlang khawzah law kawm usaw, 'Kai ve anih hawh ni,' tinawh thlang khawzah thailat na kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Qaal tuknaak ingkaw qaal tuknaak awithang na ming zaak awh, koeh cat uh. Cemyihkhqi ce ak awm hly kawi qoe ni, cehlai a dytnaak ce law hyn kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Peng ingkaw peng tuk qu kawm nih saw qam ingkaw qam tuk qu kawm nih. Hun ak chang chang kqang lipii tlai kaw, khaw se kaw. Vemyihkhqi ve naa awm tlawh ak kqannaak hyn ni. ");
INSERT INTO hltthb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Cedawngawh ngaihta lah uh. Nangmih ce awih kqawnnaak a hun awh ni tukkhqi kawm usaw, sinakawk awh ni vyk nik paai khqi kaw. Kai a dawngawh qam ukkungkhqi ingkaw sangpahrangkhqi haiawh simpyikung na nami awmnaak thai aham dyi kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Awithang leek ve penglum thlang a venawh kqawn lamma na awm hyn kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Thlang ing nim tuk khqi nawh awidengnaak a ni khyn khqi awh, “Ikawnu kak kqawn hly? tinawh ngaih koeh kyi sak uh; cawh a ni sim sakkhqi ce kqawn kawm uk ti; ak kqawnkung taw nangmih am nawh, Ciim Myihla ni. ");
INSERT INTO hltthb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Him qu hamna a koeinaa pa ing a koeinaa pa nawn, a pa ing a ca nawn ce thlang a kut awh pe kawm uh, cakhqi ing ami nu ingkaw ami pakhqi ce qaal na kawm usaw thih sak aham thlang a kut awh pe kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kang ming ak camawh thlang boeih ing ni sawh nak khqi kaw, cehlai a dytnaak dy ak yh ing thaawngnaak hu kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Amang dyihnaak man awh ak dyi, 'Tuih ak cu, thlang ak hqe,' ce nami huh awh - ca ak noetkung ing zasim seh - Judah awh ak awm thlangkhqi ce tlang na cen useh. ");
INSERT INTO hltthb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Iptih na ak awm ing ipkhui nakaw ik-oeih lawh aham koeh nuk kqum seh. ");
INSERT INTO hltthb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Lo na ak awm ing hi ak lo na imna koeh hlat voel seh. ");
INSERT INTO hltthb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ak phyihsukhqi ingkaw naaca ak takhqi ham ce a tym ce ikawmyihna nu a kyi hly hy voei! ");
INSERT INTO hltthb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ce a tym ce chikca awh ama pha lawnaak aham cykcah lah uh, ");
INSERT INTO hltthb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ikawtih cetloek awhkaw kyinaak ce ak cyk ca awhkawng tuhdy amak awm man kyinaak na awm kaw - cemyih ce ityk awh awm am awm hly voel qoe bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bawipa ing ce a khawnghi ce ama tawi sak mantaw, u awm am loet tikaw. Cehlai ak tyhkhqi, amah ak tyhkhqi ak caming ce a khawnghi ce tawi sak hy. ");
INSERT INTO hltthb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Cawh u ingawm nangmih a venawh, 'Toek lah uh, vawh ni Khrih a awm hy!' am awhtaw, 'Toek lah cawh ni a awm hy ce!' a ni tinaak khqi awh ce koeh cangna uh. ");
INSERT INTO hltthb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ikawtih Khrih-na ak sa qu ingkaw tawngha qawlkhqi ce awm kawmsaw kawpoek kyi ik-oeihkhqi ingkaw hatnaakkhqi ce sai kawm uh, ang coeng thai man, ak tyh thlangkhqi awm qaai na kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Cedawngawh nami cyih ta lah uh; a soep a kep nik kqawn pek khqi oet oet hawh nyng. ");
INSERT INTO hltthb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Cehlai cemyih kyinaakkhqi ce a law coengawh, “Khawmik ce than kawmsaw, pihla ingawm am vang voel kaw; ");
INSERT INTO hltthb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","aihchikhqi ce khan nakawng tla kawm usaw, khan nakaw saithainaakkhqi ce tyyn kaw,”. ");
INSERT INTO hltthb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","”Cawh thlanghqing Capa ing boeimang thaawmnaak ing myi ak khan awh a law ce thlangkhqi ing hu kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Anih ing ak khan ceityihkhqi ce tyi kawmsaw khawmdek kili awhkaw ak tyh thlangkhqi ce khawmdek a dytnaak awhkawng khawk khan a dytnaak dyna cawi sak kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Thai thing awhkaw nyhtahnaak ve cawng lah uh: a baai keh nawh a hahno ang cawn law awhtaw, khawhqai tym zoe hawh hy, tice sim uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Cemyih lawtna, ve ik-oeihkhqi ve a awm law awh ce, anih a lawnaak taw zoe hawh nawh, chawmkeng awh dyi hawh hy tinawh sim uh. ");
INSERT INTO hltthb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Awitak ka nik kqawn peek khqi, Vawhkaw ik-oeihkhqi a pha hlan dy taw, ve a khuk awhkaw thlangkhqi ve am khum tikaw. ");
INSERT INTO hltthb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Khawk khan ingkaw khawmdek taw khum hly hlai hy, kak awi taw ityk awh awm am qeng tikaw. ");
INSERT INTO hltthb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ce khawnghi ce u ingawm am sim hy, khawk khan nakaw khan ceityihkhqi ingawm, Capa ingawm am sim hy, Pa doeng ing ni a sim. ");
INSERT INTO hltthb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","A tym ce am nami sim a dawngawh, naming ngaih ta unawh a hylthyl na awm lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ce a tym taw thlang pynoet khaw lawng hla na ak cet ing myih kaw: Anih ing a im ce a tyihzawihkhqi venawh cehta nawh, thlang pynoet boeih a venawh ami sai hly kawi ce pek khqi qip qip hy, cekcoengawh chawmkeng ak qehkung a venawh ang ngaih ta nawh qeh phaat aham kqawn pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Imkung ityk awh a law kaw, tice am nami sim a dawngawh ngaihtaak doena qeh lah uh - khawmy ben awh nu, thanlung awh nu, aaikhawng awh nu, khawdai tawm awh nu a law kaw, tice am sim uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Anih ce a pha law awh, nangmih nami ih ce koeh hu seh. ");
INSERT INTO hltthb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nangmih a venawh kak kqawn law ve, thlang boeih a venawh kak kqawn hawh ni: 'ngaihtaak doena qeh lah uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ak law hly khawnghi a hihvoeinaak awh loentaak poei ingkaw hen amak boei phaihpi poei ce awm hly nawh, khawsoeih boeikhqi ingkaw anaa awi cawngpyikungkhqi ing Jesu ce tu unawh him aham a tym leek ce sui uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Cehlai, “poei a awm khui awhtaw am seh, thlang kqeng awipungnaak awm hau kaw,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Bethani khaw awhkaw mynqai ak neh Simon a im awh buh ami ai awh, nu pynoet ing a phu ak tlo soeih bawktui ce a uum mahna lawpyi nawh law hy. A uum ce khoeng kqek nawh Jesu a lu ce syp pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Cawhkaw ak awm thlangkhqi ing amik kaw ama law doena, 'Ikaw hamna bawktui cemyihna ak plak? ");
INSERT INTO hltthb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tangka denari zathum na awm zawi nawh khawdeng hahqahkhqi pe mai thaw voei? ti uhy. Cawhkaw nu ak khan awh ce vung uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Cawh Jesu ing, “Sai seh nyng. Ikaw hamna nami lawlh plak? Anih ing kai aham ik-oeih leek sai law saw. ");
INSERT INTO hltthb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Khawdeng hahqahkhqi taw nangmih a venawh awm quiqah kawm uh, cedawngawh nami ngaihnaak awh a mingmih ce do a dan thai uhyk ti. ");
INSERT INTO hltthb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Vawhkaw nu ing a sai thai ang cang ca ce sai hawh hy. Ka qawk a khoemnaak aham anih ing bawktui ing ni syp oepchoeh hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Awitak ka nik kqawn peek khqi, ve khawmdek awh awithang leek amik kqawnnaak a hoei awh anih a ik-oeih sai ve amah simpoenaak aham kqawn kawm uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Cawh thlanghqa hlaihih ak khui awhkaw thlang pynoet, Juda Iskariot ce Jesu tu sak aham khawsoeih boeikhqi venna cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Anih ak awi ce khawsoeih boeikhqi ing aming zaak awh ym unawh tangka peek aham awi ta uhy. Cedawngawh anih ing tu sak thainaak aham a tym leek ce sui hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hen amak boei Phaihpi poei ak cyk nyn, loentaak poei tuuca nawnnaak khawnghi awh, a hubatkhqi ing a hu awh, “Loentaak poei buh veelnaak aham han a hun awh nu sai sak ham na ngaih?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Cedawngawh a hubat thlang pakkhih ce tyi hy, “Khawk bau khuina cet nih nawh, tuiam awh tui ak doeng ce hu kawm nik ti. Anih a hu ce hquut nih. ");
INSERT INTO hltthb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ipkhui na a lut awh imkung a venawh, “Cawngpyikung ing, 'ka hubatkhqi mi loentaak poei buh veelnaak aham ka pahnaak hly im ce hana a awm? tihy,' tina nih. ");
INSERT INTO hltthb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Anih ing ipkhan ak kau soeih, a qoek abah hqeet ce nim huh qawi bit kaw. Amah cawh mybuh ce sai kawm nik ti,” tina qawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","A hubat qawi ce khawk bau khuina cet nih nawh Jesu ing ak kqawn peek a myihna hu hy nih. Amah cawh loentaak poei buh veelnaak ce toen hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Khaw a my law awhtaw a hubat thlanghqa hlaihih ingkaw Jesu ce law uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Caboei awh buh ami veel awh, a mingmih a venawh, “Awitak ka nik kqawn peek khqi, nangmih ak khui awhkaw thlang pynoet, kai mi buh ak vel haih ing - kai ve ni zawi kaw,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Cawh a mingmih ing kawseet doena pynoet coeng pynoet a venawh, “Kai amni my?” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A mingmih a venawh, “Thlanghqa hlaihih ak khui awhkaw thlang pynoet, kai ingqawi buh beei ak zoep haih ceni. ");
INSERT INTO hltthb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Thlanghqing Capa ve amah akawng ami na qee hyt amyihna a awm aham awm hy. Cehlai thlanghqing Capa thlang a kut awh ak pekung ce khaw na map hy! Anih ce ama thang mantaw nep bet hlai voei, ”tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Buh ami vel huiawh Jesu ing phaihpi ce lo nawh, zeelnaak awi ak kqawn coengawh ek nawh, a hubatkhqi ce pehy, “Lo lah uh, ve ve ka sa ni,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Cekcoengawh boet ce lo bai nawh, zeelnaak awi ak kqawn coengawh a mingmih a venawh pekkhqi bai hy, a mingmih ing aw bai uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A mingmih a venawh, “Ve ve ka thi thlang khawzah aham ka hawk awikamnaak ni. ");
INSERT INTO hltthb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ka nik kqawn peek khqi, misur tui ve Khawsa ram khuiawh ak thai na nangmih mi ni aawk hlan dy taw am aw voel tikawng,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Laa ami sak coengawh Olive tlang na cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesu ing a mingmih a venawh “'Tuudoenkung ce vyk kawm usaw, tuukhqi ce kqeng sak zak zak kawm uh,' tinawh qee sut a myihna nangmih boeih tlu kawm uk ti. ");
INSERT INTO hltthb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Cehlai ka thawh tlaih coengawh nangmih a haiawh Kalili na ana cet kawng,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piter ing, “Thlangkhqi boeih ing tlu bai u seiawm, kai taw cemyihna am awm tikawng. ");
INSERT INTO hltthb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu ing, “Awitak ka nik kqawn peek khqi, tuhngawi awh, oeih, tuhngawi am than awh, aai hihvoei ang khawng hlanawh namah qoe qoe ing thumvoei nik khawng kawp ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Cehlai Piter ing ak tlo khqoet na, “Nang ing thih haih aham awm nyng seiawm, am nik khawng qoe qoe tikawng,” tina hy. Ak changkhqi ingawm cemyihna tina lawt uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Cekcoengawh Gethsemane ami ti a hun na ce cet uhy, cawh Jesu ing a hubatkhqi venawh, “Kak cykcah huiawh vawh a nang ngawi uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Piter, Jakob ingkaw Johan ce ceh pyi nawh, amah ce ly soeih nawh ngaih kyi doena awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A mingmih a venawh, “Kak kawlung ve thihnaak khoek dy awh kak kaw se soeih hy. Vawh awm unawh qalqing caana awm kawm uk ti,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ak hla bet awh va cet nawh, ang coeng thai awhtaw a tym ing ang khum taak naak thai aham dek awh koep doena cykcah hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Abba, Kapa, nang aham taw ik-oeih boeih boeih ve coeng thai hy. Vawhkaw boet ve ka venawh kawng khoe law lah. Cehlai kai ak kawngaih na koeh awm seitaw nang ak kawngaih myihna awm seh nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","A hubatkhqi venna ang voei awh a mingmih ami na ih ce hu hy. Piter a venawh, “Simon nami ip nawh nu? khawnoek pakhat khui kangna awm am nami qeh thai nawh nu? ");
INSERT INTO hltthb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Syknaak ak khuiawh amna ming tluuknaak thai aham qeh unawh cykcah lah uh. Myihla ingtaw ngaih hlai hy, pumsa ingtaw zai hqoeng hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Cekcoengawh cet tlaih bai nawh ak kqawn hawh amyihna cykcah tlaih bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ang voei tlaih bai awhtaw mikuu ing a naa khqi a dawngawh, ami na ih tlaih ce huk khqi bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A thumvoei naak awh ang voei tlaih bai awhtaw, a mingmih a venawh, “Tuhdy awh ip unawh naming dym hyn nawh nu? Khoek hawh hy! A tym pha law hawh hy. Toek lah uh, thlanghqing Capa taw thlak thawlhkhqi kut awh peek na awm hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tho uh! Cet hlah usih! Thlang a kut awh kai anik pekung ve vawh awm hawh hy!,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Cemyihna awi ak kqawn huili awh, thlanghqa hlaihih ak khui awhkaw thlang pynoet, Juda ce law hy. Anih ing thingboeng ingkaw zawzi ak pawm thlang kqeng ce khawsoeih boeikhqi, anaa awi cawngpyikungkhqi ingkaw a hqamcakhqi venawh kawng law pyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Thlang a kut awh amah ak pekung ing cekkhqi venawh huh simnaak ce sai pehy: “Kai ing ka mawk thlang ce hawh ni; tu unawh ak leek caana khy uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Cekcoengawh Jesu a venna cet pahoei nawh, “Cawngpyikung” a tinaak coengawh mawk hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Cawh thlangkhqi ing Jesu ce tu unawh khyn uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","A mingmih a venawh ak dyi thlang pynoet ing zawzi ce phlawng nawh, khawsoeih boei a tyihzawih ang haa ce zek pe hlak hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","“Kai ve quk-ai na ka awm nawh nu, zawzi ing thingboeng ing kai tu aham nami law? ");
INSERT INTO hltthb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Myngawi nangmih a venawh awm nawh, tempul khuiawh ka ni cawngpyi khqi awh, am na mim tu. Cehlai Ca ciim awi ve a soep aham awm hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Cawh a hubatkhqi ing hlah hyt unawh cehta boeh boeh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hi doeng ak bai cadawng pynoet ing Jesu ce a huhu awh qym hy. Anih ce tu uhy, ");
INSERT INTO hltthb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Cehlai a hi bang nawh, ak pum kawlawng na cen valh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesu ce khawsoeih boei khyt a venna khyn uhy, cawh khawsoeih boei khyt, a hqamcakhqi ingkaw anaa awi cawngpyikungkhqi boeih boeih ce kutoet na cun kyng uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piter ing ak hla nakawng khawsoeih boei khyt a vawng dyna qym hy. Cawh im ak qehkhqi mi ngawi haih lawt nawh mai awm lawt hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Khawsoih boeikhqi ingkaw Sanhedrin awi kqawnkung khqi boeih ing Jesu ce ami thih sak naak thai aham a thawlhnaak ce sui pe uhy, cehlai ikaw awm am huh pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Thlang khawzah ing amak thym na thawlh puk uhy, cehlai thawlh amik puknaak awm am myih qu hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Cawh thlang pynoet ing dyi unawh vawhkaw amak thym sausi ce deng uhy: ");
INSERT INTO hltthb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","”Thlang a kut ing a sak vawhkaw tempul ve hqe nyng khaw thumvoei khuiawh kut ing ama sak ak chang tempul sa tlaih kawng nyng, tinawh kqawn hy,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Cehlai a mimah a dyihthing awm am myih qu hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Cawh a mimah boeih a haiawh khawsoeih boei khyt ce dyi nawh Jesu ce doet hy, “A mingmih ak kqawn ve am nam hlat hly nawh nu? Vekkhqi ing nang thawlh amik puk ve ikaw myihna a awmnaak?” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Cehlai Jesu ing awm taak dym nawh kaw awm ap kqawn hy. Cawh khawsoeih boei khyt ing, “Nang ve Khrih, Zoseennaak Capa nu?” tinawh doet tlaih bai hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu ing, “Oeih, thlanghqing Capa ing Bawimang thak awm tang ben awh ngawi nawh khan myi ak khan awh a law awh hu bit kawp ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Cawh khawsoeih boei khyt ing a hi ce phleuh nawh, “Ikaw hamna dyihthing ak chang ni ngoe hly qee? ");
INSERT INTO hltthb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Khawsa ak thekhanaak awi za hawh u tiksaw kaw: Kawmyihna namik poek? tinak khqi hy. Cekkhqi ing thih aham tyng na thawlh sak boeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Cawh thlang vang ing sawh uhy; amik ce zeen pe unawh, ami kuthlym ing thawng uhy, “Kqawn lah!” tina uhy. Qaltoengkhqi ing sawi unawh vyk uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piter ce ipkai kawngma na a awm awh, khawsoeih boei khyt a tyihzawih nuca pynoet ce law hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Piter mai ak awm ce hu nawh, toek ceet hy. “Nang awm Nazareth Jesu ing awm haih lawt hy nihk ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Cehlai anih ing ciim hy. “Na ti ce am sim nyng ang zaak na awm am zasim nyng” a tinaak coengawh chawmkeng benna ce cet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Anih ce tyihzoeih nu ing amah cawh hu tlaih bai nawh, cawhkaw ak dyikhqi venawh, “Anih ve awm a mingmih khqing lak awh paa lawt hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Cawh Piter ing hoet tlaih bai hy. A khoeh a awm coengawh, cawhkaw ak dyikhqi ing Piter a venawh, “Nang ve a mingmih ak khui awhkaw thlang qoe qoe lawt ni Kalili thlang na awm awm bai hyk ti,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Amah ing amah seet lo nawh, a mingmih a venawh, “Ve ak thlang namik kqawn ve am sim qoe qoe nyng,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Cawh aai ce a hihvoeinaak khawng hy. Cawh Piter ing, Jesu ing a venawh, “Ai hihvoei ang khawng hlanawh thumvoei nik khawng kawp ti,” a tinaak awi ce sim hqoet hy. Cedawngawh ak ak kaw se nawh kqang hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","A ngawi mymcang hqit awh, khawsoeih boeikhqi, a hqamcakhqi, anaa awi qeekungkhqi ingkaw Sanhedrin awi ak kqawnkungkhqi boeih ing awi ce tlyk uhy. Jesuh ce pin unawh, Pilat a venna khyn uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat ing, “Nang ve Judakhqi a sangpahrang aw?” tinawh doet hy. Jesu ing, Oeih, nak kqawn a myihna awm hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Khawsoih boeikhqi ing thawlh khawzah puk uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Cedawngawh Pilat ing doet tlaih hy, “Am nam hlat hly nawh nu? Ve zah thawlh ami nik puk ve toek lah,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Cehlai Jesu ing awi am am hlat hy, cedawngawh Pilat taw ak kawpoekna kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Poei a awm hoei awh thawk tla pynoet ce ana hlah man uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Cawh quk-ai thlang ak him Barabbas ak mingnaak thlang pynoet ce thawngim na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Thlang kqeng ing Pilat a venawh a sai khawi amyihna sai peek aham thoeh uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat ing, “Juda sangpahrang ve hlah namik ngaih nu?” tinawh doet khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Khawsoih boeikhqi ing ami yyt a dawngawh a venna law pyi uhy tice anih ing sim hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Cehlai Pilat ing Barabbas ce a hlah thainaak aham khawsoeih boeikhqi ing thlang kqeng ce syk uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","“Cawhtaw Judah sangpahrang, ami ti vetaw ikawmyihna ka sai kaw?” tinawh Pilat ing doet khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Cekkhqi ing, “Thinglam awh taai!” tinawh khy uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat ing, “Kawti nawh nu? Ikaw thawlhnaak a sai awh nu? tinawh doet khqi hy. Cehlai cekkhqi ing khawteh khqoet na, “Thinglam awh taai!,” tinawh khy bai uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Thlang kqeng kawzeel sak a ngaih awh, Pilat ing Barabbas ce hlah pek khqi hy. Jesu taw a vyk coengawh, thinglam awh taai aham cekkhqi kut awh pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Qalkapkhqi ing Jesu ce praetorium ami ti boei a ipkhui na sawi uhy; qaalkapkhqi boeih ce kutoet na khy uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Hik thim ce bai sak uhy, hling ce lumyk na sai pe unawh myk sak uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Cekcoengawh, “Juda sangpahrang a hqinglu kyi seh!” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A lu awh sawnghqawl ing vyk unawh sawh a phih uhy. A haiawh khuk sym doena koep pe unawh bawk uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ami thekhanaak coengawh, hik thim ce suh pe unawh amah a hi ce bai sak tlaih uhy. Cekcoengawh thinglam awh taai aham cehpyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cyqene khaw awhkaw thlang pynoet, Alexander ingkaw Rufus a pa Simon, kqawng nakaw ak law ce tu unawh, thinglam ce kawh sak ngah ngah uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesu ce Golgotha ami ti hun benna ceh pyi uhy (cece “luquh hun,” tinaak ni). ");
INSERT INTO hltthb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Murra ing amik kqit misur tui ce pe uhy, cehlai am aw hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Cekcoengawh thinglam awh taai uhy. Taicung zyk unawh a hi ce tei uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Khawnoek pakthum awh thinglam awh taai uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Thawlh amik puknaak ca ce: JUDA KHRIH SANGPAHRANG, tinawh qee pe uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Thlak thawlh qawi pakkhih awm thinglam awh pynoet ce ak tang ben awh pynoet ce ak cawng ben awh taai haih uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Thlak thawlhkhqi ingqawi noet sih haih uhy,” ti ak awi ce soep hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Cawhkaw ak thoek cawnkhqi ing ami lu khyp sih unawh, “Aw za! Nang tempul hqe nawh am thum nyn awh ak sa tlaih, ");
INSERT INTO hltthb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","thinglam awhkawng kqum nawh namah ingkaw namah hul qu lah thaw voeih ti!” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Cemyih lawtna khawsoeih boeikhqi ingkaw anaa awi cawngpyikung khqi ingawm a mimah ingkaw a mimah anglakawh anih ce, “Thlak chang taw thaawng hlai hy, amah ingkaw amah taw am thaawng qu thai hy! ");
INSERT INTO hltthb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Khrih Israelkhqi a sangpahrang, ti unawh kami nik cangnaak aham, tuh thinglam awhkawng nuk kqum law lah thoeih ti,” tina uhy. Amah ingqawi thinglam awh ami taai thlang pynoet ingawm anih ce the kha na hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Khawnoek paquk awhkawng pakow dy dek pum awh khaw than hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Khawnoek pakow awh ce Jesu ing khawteh na, “Eloi, Eloi, Lama sabachthani” tinawh khy hy, (cece “Ka Khawsa, ka Khawsa, kawtih nani cehtaak?” tinaak ni.) ");
INSERT INTO hltthb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Cawhkaw amik dyikhqi ing aming zaak awh, “Ngai lah uh, Elijah khy hy ce,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Thlang pynoet ce dawng nawh hlapawt ce misur tui ak thui awh a hluk coengawh cungkui awh tlet nawh Jesu ce awk sak hy, “Toek poek poek lah usih nyng. Elijah law nawh ak lo law hly nu?” anih ing tihy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Cawh Jesu taw khawteh na khy nawh kawn zip hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tempul awhkaw hizan ce a saw nakawng ak kai dy pakkhih na teek hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Cawh Jesu a haiawh ak dyi, qalkap zakhat ak ukkung ing ak khy doena Jesu a thih ce a huh awh, “Ve ak thlang ve Khawsa Capa tak ni!” tinawh kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nukhqi ingawm ak hla nakawng qeh lawt uhy. Cawhkaw nukhqi taw Meri Magdalene, ang no Jakob ingkaw Joses anu Meri ingkaw Salome, vetloek ve. ");
INSERT INTO hltthb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kalili qam na vawhkaw nukhqi ve a hu awh bat unawh a ngaihnaak awh ak dodankungkhqi na awm uhy. Amah ingqawi Jerusalem na amik law haih nukhqi awm khawzah awm uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ce nyn taw coekqoeknaak nyn (Sabbath than khawnghi) na awm hy. Khawmy ben a pha awh, ");
INSERT INTO hltthb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimathai khaw awhkaw khawksimkung kqihchah kap thlang pynoet, Khawsa qam ak qeh Joseph ce Pilat a venna qaal leeknaak ing cet nawh, Jesu a qawk ce thoeh hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Anih thi hawh hy, tice Pilat ing ang zaak awh ak kawpoek na kyi hy. Qalkap zakhat ak ukkung ce khy nawh, Jesu ak thi hawh tang nu, tinawh doet hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Qalkap zakhat ukkung a ven awhkawng thi tang hawh hy tice ang zaak awh, Jesu a qawk ce Joseph a venawh pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph ing hi thlai nawh qawk ce lo hy, a zawl coengawh thel ak cawh hqeet phyi khuina pup hy. Cekcoengawh phyi chawmkeng ce lungpei ak bau soeih hlum nawh tleng hy. ");
INSERT INTO hltthb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri Magdalene ingkaw Joses a nu Meri ingawm ak pupnaak a hun ce sim lawt hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabbath nyn a boeih coengawh, Meri Madalene, Jakob a nu Meri ingkaw Salome ing bawktui thlai nih nawh Jesu hluk hamna cet hy nih. ");
INSERT INTO hltthb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Khaw khqih nyn khui awhkaw khawnghi lamma cyk mymcang hqit khaw a law kqoeng awh, phyi na ce cet uhy, ");
INSERT INTO hltthb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","cawh, “U ing nu lung a hlum law lah voei?” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Cehlai ami toek awh, cawhkaw lung ak bau soeih ak thoeih quce na hu uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Phyi ak khuina ce lut nawh, cawh cadawng pynoet hik bawk bai nawh tang ben awh ak ngawi ce hu unawh cat uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Anih ing, “Koeh ly uh. Thinglam awh ami taai, Nazareth Jesu ni nami sui hy, tho tlaih hawh hy! Vawh am awm voel hy. Ami tloengnaak ve toek lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cehlai cet unawh a hubatkhqi ingkaw Piter a venawh kqawn pe uh, 'Nangmih a haina Kalili awh cet hawh hy. Amah ing ak kqawn a myihna amah cawh ce hu kawm uk ti,' tina uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Thyn unawh kawpoek kyi doena, cawhkaw nukhqi ce phyi awhkawng dawng uhy. Amik kqih a dawngawh u a venawh awm ap kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Khaw khqih nyn khui awhkaw khawnghi lamma cyk awh Jesu ing a thawh coengawh, lamma cyk awh ak kawk khui awhkaw qaaikhqi a hqek peek Meri Madalene a venawh dang pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Anih ce cet nawh Jesu ingqawi kutoet na amik awm khawikhqi ingkaw lungnat za nawh ak kqangkhqi venawh kqawn pehy. ");
INSERT INTO hltthb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jesu taw hqing nawh Meri Madalene ing hu hawh hy tice a mingmih ing a ming zaak awh ap cangna uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cekcoengawh amingmih khuiawh thlang pakkhih ani khaw benna a ni ceh huiawh myime ak lawhana dang pe qawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Cekkqawi ing awm a hubat ak changkhqi venna kqawn pe hy nih, cehlai a ningnih ak awi awm ap cangna uhy. ");
INSERT INTO hltthb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Cekcoengawh thlanghqa hlaioet a venna buh ami ai huiawh dang pek khqi bai hy, a thawh tlaih coengawh amah ak hu khqik awi ce upvoet unawh ama mik cangnaak qoe qoe a dawngawh a mingmih ce zyi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A mingmih a venawh, “Khawmdek penglum awh cet unawh a sai ik-oeih boeih a venawh awithang leek ve kqawn law lah uh. ");
INSERT INTO hltthb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","U ingawm cangna nawh Baptisma ak hu ingtaw thaawngnaak hu kaw, cehlai amak cangnaak ak thlang taw thawlh sak na awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ak cangnaak thlangkhqi taw vawhkaw hatnaakkhqi ing hquut phaat kaw: kang ming ing qaaikhqi hqek kawm uh; awih thai ing pau kawm uh, ");
INSERT INTO hltthb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ami kut ing khquikhqi ce tu kawm uh; thihnaak sykhqi ce aw mai useiawm, ikaw am tikaw; thlak tlo ak khan awh kut tloeng kawm usaw qoei kawm uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bawipa Jesu ing a mingmih a venawh awi ak kqawn coengawh, khawk khan na zoek qu hqui nawh Khawsa ak tang ben awh ce ngawi hy. ");
INSERT INTO hltthb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Cekcoengawh a hubatkhqi ce cet unawh penglum awh awithang leek ce kqawn uhy, Bawipa ing a mingmih hawnaak ing bibi nawh, ik-oeih saithainaakkhqi ing ak awi ce caksak hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Cawhkaw ik-oeih ningnih anglakawh ak soep ce thlang khawzah ing qee aham hlah hawh uhy, ");
INSERT INTO hltthb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ak cyk ca awhkaw ing dyihthing na awm nawh ce ak awi dawngawh bi ak bikhqi ing nangmih a venawh amik kqawn law patoe lawt amyihna. ");
INSERT INTO hltthb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Cedawngawh cawhkaw ik-oeih ce akung awhkawng kamah qoe ing ak nep na nym a nai nawh, ka qee law patoe mantaw nep voei tinawh poek nyng, ak leek soeih Theolophila, ");
INSERT INTO hltthb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","cawh ni thlang ing a ni pyinaak awi ce ak nep caana nami sim hly thai. ");
INSERT INTO hltthb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea sangpahrang Herod chan awh, Abijiah cakaw khawsoeih pynoet, ang mingna Zekarih ce awm nawh Elizabeth ak mingnaak Aaron cahlah ce zu na hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Khawsa mik huh awh thlak dyng na awm nih nawh, Bawipa ak awipeekhqi ingkaw sai hly kawi boeih boeih ce coet amak kapna sai hy nih. ");
INSERT INTO hltthb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Cehlai Elizabeth taw ciing nawh ca am ta hy nih; ani kum awm pacawng hawh hy nih. ");
INSERT INTO hltthb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zekariah a poek ben ing Khawsa haiawh Khawsa bibinaak tym a pha a dawngawh, ");
INSERT INTO hltthb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","anih ing khawsoeihkhqi a sai khawi amyihna, Bawipa a bawkim khuiawh bawktui phum aham a tym ing pha hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Bawktui phumnaak a tym a pha awh, Khawsa ak bawkkhqi boeih boeih ce a lengna cykcah uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Cawh Bawipa ak khan ceityih ce bawktui phumnaak bawkthang tang benawh dyih pehy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zekariah ing a huh awh ang ngaih kyi nawh ak kqih na awm kqih hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Cehlai khan ceityih ing a venawh: “Zekariah, koeh kqih; nak cykcahnaak ce Khawsa ing za hawh hy. Na zu Elizabeth ing cakpa ni taak pe kawmsaw, Johan tinawh ang ming sui kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nang kaw anik zeel sak ingkaw a nik awmhly sak na awm kaw, anih a thang awh thlang khawzah zeel kawm uh, ");
INSERT INTO hltthb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","kawtih anih taw Bawipa a mik huh awh thlak bau na awm kaw. Misur tui, am awhtaw ak chang qui kawi ik-oeih qoe am aw kaw, a thang awhkawng anih taw Ciim Myihla ing be kaw. ");
INSERT INTO hltthb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Anih ing Israel thlang khawzah ce a mimah a Bawipa Khawsa venna sawi tlaih kaw. ");
INSERT INTO hltthb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Pakhqi ak kawlung ce cakhqi benna hawi sak ham, awi amak zakhqi ce thlak dyngkhqi cyihnaak benna mang sak ham, Bawipa ham lammana thlang ak toen hamna Elijah ang myihla ingkaw ak thaawmnaak taak ing Bawipa haiawh a na cet kaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zekariah ing khan ceityih a venawh, “Ve ve ikawmyihna ka simnaak kaw? Kamah awm pacawng nyng ka zu awm nucawng hawh hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Khan ceityih ing a venawh, “Kai ve Khawsa haiawh ak dyi Gabriel ni, nang a venawh awi kqawn aham ingkaw vawhkaw awithang leek kqawn aham tyihna kak awm ni. ");
INSERT INTO hltthb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Cehlai nang ing, a tym a khoek awh ak pha law hly kawi kak kqawn law ve am nak cangnaak a dawngawh, cawhkaw ik-oeih a pha hlan dy awimyh kawp ti,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Cawh thlangkhqi ingtaw a leng nakawng Zekariah ce qeh uhy, kawtih bawkim khuiawh a awm khing hy voei, ti unawh a ming ngaih kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Anih ce a law awhtaw, awi am pau thai voel hy. Awi ak kqawn kaana a kut ing a vaih a dawngawh, a mingmih ing bawkim ak khuina mik hatnaak hu pakaa hy ti uhy. Cedawngawh Zekariah ing amingmih venawh kut ing zavaih nawh awimyh na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","A bibinaak tym a boeih coengawh taw im na hlat hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Cekcoengawh taw a zu Elizabeth ce phyihsu nawh hla nga khui thlang a venawh am dang hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elizabeth ing, “Thlang venna kang ming seetnaak thoeng hamna Bawipa ing thlang huh awh vemyihna ni sai pe hy,” tihy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth a pumqihnaak hlak kquk a law awh, Khawsa ing khan ceityih Gabriel ce, Kalili qam Nazareth khaw awhkaw, ");
INSERT INTO hltthb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","David cadil na ak awm, Josepth ak mingnaak ing zunaak aham am kang nulak cym a venna tyi hy. Cawhkaw nulak cym taw Meri ming na hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Khan ceityih ing a venawh, “Na zoseen hy, nang, Khawsak kaw ak tawng! Bawipa taw na venawh awm hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ce ak awi awh Meri taw ak ngaihna kyi nawh, “ikawmyih ak awi hy voei nu,” tinawh poek qu hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Cehlai, khan ceityih ing a venawh, “Meri, koeh kqih, Khawsa ak kawngaihnaak hu hawh hyk ti. ");
INSERT INTO hltthb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Phyihsu kawm tiksaw cakpa ta kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Anih taw thlak bau na awm kawmsaw, Sawsang soeih Cakpa ti kawm uh; Bawipa Khawsa ing a pa David a ngawihdoelh ce pe kawmsaw, ");
INSERT INTO hltthb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jakob cadil lakawh kumqui dyna boei loet kawsaw, a ram ing am dyt voel tikaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Cawh Meri ing khan ceityih a venawh,” Cece ikawmyihna ang coeng naak thai kaw? Pa am ka taak ak kaa?” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Khan ceityih ing, “Ciim Myihla ce nak khan awh awm kawmsaw, sawsang soeih a saithainaak ing ni siing khoep kaw; cedawngawh thlak ciim ak thang law hly ce Khawsa Capa tinawh khy kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na cakaw Elizabeth awm a nucawng huna phyihsu nawh; tuhawh hlak kquk law hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kawtih Khawsak awi ak cawn boeih ing them a saithai kaana am awm kaw,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Cawh Meri ing, “Kai taw Bawipa a tamnaa ni, nak kqawn amyihna kak khan awh awm seh nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Cawh Meri ce tho nawh Judah qam tlang na ak awm khaw pynoet awh ce ang tawnna cet hy, ");
INSERT INTO hltthb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zekariah a ipkhui na ce lut nawh Elizabeth ce voem hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeth ing Meri ak awi ce ang zaak awh, ak phoen khui nakaw naaca ce tat hy, cawh Elizah ce Ciim Myihla ing be hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Anih ing khawteh na: “Nang taw nukhqi boeih anglakawh thlang zoseen nu ni, nak khui awhkaw na ca awm a zoseen hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ka Bawipa a nu, ka venna na law ve ikawmyihna hy voei? ");
INSERT INTO hltthb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ngai lah, Nani voemnaak awi kang zaak awhkawng kak phoen khui nakaw naaca ve a zeel aih awh tat hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Cedawngawh a venawh Bawipa ing ak kqawn peek ce soep kaw, tinawh ak cangnaak nu taw a zoseen hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meri ing: “Ka hqingnaak ing Bawipa kyihcah nawh, ");
INSERT INTO hltthb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","kang myihla awm ak hulkung Khawsa venawh zeel soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","A tamnaa nu a dungvoengnaak qeen nawh; Ngaih lah, tuhawhkawng cadil boeih ing thlang zoseen nu tinawh nik khy kawm uh. ");
INSERT INTO hltthb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kawtih tha ak awm soeih ing kak khan awh ik-oeih ak bau soeih sai hawh hy, ang ming awm cimcaih soeih hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Amah ak kqihchahkhqi cetaw cadil dyna awm qeen khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A baan ing ak thaawmnaak ce dang sak nawh, thlak oek qu khqi taw a mik poek qunaak ing theeh khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ukkungkhqi ce a mi ngawihdoelh awhkawng kqum sak khqi nawh dungvoeng na ak awmkhqi ce zoeksang khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ak phoen ak cawi khqi ce them leek ing phyi sak khqi nawh, boeikhqi ce kut hqawng na tyi khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A lungqeennaak ce poek khak nawh a tyihzoeih Israelkhqi ce bawm hamna, ");
INSERT INTO hltthb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Abraham ingkaw a cadil a venawh qeennaak ce ta poepa hy,” tihy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri ce Elizabeth a venawh hla thum tluk a awm coengawh a im na hlat hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Naa a thangnaak tym a pha awh, Elizabeth ing cakpa ce ta hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A imcengkhqi ingkaw a cakaw paqengkhqi ing Bawipa ing anih ak khan awh qeennaak soep sak hy tice a ming sim awh, zeel pyi uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ak kqeet nyn awh chahhui qeet aham naaca ce khyn hy nih, cawh a pa ang ming Zekariah ce sui aham cai hlai uhy, ");
INSERT INTO hltthb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","a nu ing, “Amni! Johan tinawh ni sui aham awm hy, tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Cekkhqi ing, “Cemyih ang ming ce na cakaw paqeng ak khuiawh am awm man hy,” tina uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Naa ang ming ce ikawmyihna nu a sui law kaw ti unawh, a pa a venawh a mi kut vaih unawh doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Anih ing caa qeenaak aham calung ce thoeh nawh, “Ang ming taw Johan,” tinawh qee saw thlang boeih a mik kawpoek kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Cawh am kha ce awng qu pahoei nawh am lai awm zai law pahoei hy, awi kqawn nawh Khawsa ce kyihcah hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A imcengkhqi taw amik kawpoek kyi hy. Judah qam khawmcung pum awh thlangkhqi ing cawhkaw ce kqawn uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bawipa a kut ce anih ak khan awh a awm a dawngawh, ce ak awi ak zakhqi boeih ing amik kawpoek kyi nawh, “Cawhtaw cawhkaw naasen ce ikawmyihna nu a awm law kaw?” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","A pa Zekariah ce Ciim Myihla ing be nawh awi kqawn hy: ");
INSERT INTO hltthb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israelkhqi a Khawsa, Bawipa venawh thangleeknaak awm seh nyng, kawtih ak thlangkhqi ce hqip nawh tlan hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A tyihzawih David a ipkhui awh, nangmih thaawngnaak kii pynoet cawn sak hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Syn awh amah a tawngha ciimkhqi venawh anak kqawn amyihna), ");
INSERT INTO hltthb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Qaalkhqi ven awhkawng thaawngnaak, ningnih anik sawhnaakkhqi qam ak khui awhkawng ");
INSERT INTO hltthb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","pakdamkhqi venawh am qeennaak dang sak aham ingkaw amah a paipi ciim a sai ce sim poe aham, ");
INSERT INTO hltthb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ni pa Abraham a venawh awi a na kam ce: ");
INSERT INTO hltthb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ni qaalkhqi kut khui awhkawng ni loet sak aham ingkaw kqih kaana amah a bi ce ni binaak thai aham ");
INSERT INTO hltthb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ni hqing khui amah a haiawh ni ciim ingkaw ni dyngnaak ham ni. ");
INSERT INTO hltthb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ce, nang ka ca, sawsang soeih a tawngha pynoet tinawh nik khy kawm uh; kawtih Bawipa haiawh a lam qoek abah peek aham na ceh hly awh; ");
INSERT INTO hltthb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ni Khawsa a thawlh qeennaak ak caming nak thlangkhqi venawh thaawngnaak sim sak aham, ");
INSERT INTO hltthb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","kawtih nangmih a Khawsa am qeennaak ak caming, khawk khan nakawng ningnih a venawh, ");
INSERT INTO hltthb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","than khuiawh ak awmkhqi ingkaw thihnaak ak kaiawh ak ngawikhqi ceei aham, ningnih a khawkhqi ce qoepnaak lam benna hqui aham khawkdai ce law kaw,” tinawh laa ce sa hy. ");
INSERT INTO hltthb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Naasen ce bau law hqui nawh Myihla ben awh ak tha awm hqui hy; Israelkhqi venawh ang dang hlan dy kqawng na ce awm hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ce tloek awh Rom qam khui boeih boeih awhkaw thlanghqing thlangmi noet aham Kaisar Augustus ing awi pehy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Vetaw Siria qam awh Quirinius ce qam ukkung boei na a awm awh thlangmi noetnaak lamma cyk na awm hy.) ");
INSERT INTO hltthb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Cedawngawh thlang boeih ing ming cazin peek aham a mimah a khaw na cet boeih boeih uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Cedawngawh Joseph awm David cahlah na a awm a dawngawh, Kalili qam Nazareth awhkawng Judah qam David a khaw Bethlehem na cet hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ming cazin pek a hamna a zu am kang, phyihsu nawh naa ak awm tawm Meri ingqawi cet hy nih. ");
INSERT INTO hltthb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Cawh a ni awm awh, naa a thangnaak hly khawnghi ce nawh, ");
INSERT INTO hltthb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Cehlai a cakcyk pa ca ce ta nawh, khin pahnaak im ama hoeng a dawngawh hi ing zawl nawh vaitaw aihkawng awh soei hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Cawh a qam khuiawh tuu ak khaikhqi ce kqawng na awm unawh, khawmthan awh tuukhqi ce qeh uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bawipa ak khan ceityih phynoet ce a mingmih a venawh dang pe nawh, Bawipa a boeimangnaak ing a mingmih a kengsam ce coei qungtheng saw, cedawngawh a mingmih ing kqih uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Cehlai khan ceityih ing a mingmih a venawh, “Koeh kqih uh. Nangmih a venawh thlang boeih aham ym ak awm soeih awithang leek ka kqawn law ni. ");
INSERT INTO hltthb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tuhngawi David a khawk khuiawh thawngkung ce nangmih aham thang hawh hy; anih cetaw Khrih Bawipa ni. ");
INSERT INTO hltthb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ve ve nangmih aham hatnaak na awm kaw: Naasen hi ing zawl unawh aihkawng awh ami soei ce hu kawm uk ti,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kawlhkalh ca awh khan benna kaw thlang kqeng ce khan ceityihkhqi mi dang law unawh, Khawsa ce kyihcah uhy, ");
INSERT INTO hltthb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Sawsang soeih awh Khawsa boeimang seitaw, khawmdek awh amah kaw ak tawng khqik khan awh qoepnaak awm seh,” tinawh kyihcah uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Khan ceityihkhqi ing a mingmih ce cehta khqi nawh khawk khan na a mi ceh coengawh, tuukhaikhqi ing, “Bethlehem na cet unawh Bawipa ing ak kqawn law ce toek lah usih,” ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Cedawngawh ang tawnna cet unawh, Meri, Joseph ingkaw aihkawng awhkaw ami soei naaca ce hu uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Naaca ce a mi huh awh, ve naaca akawng cekkhqi venawh kqawn peek na ak awm ce thlangkhqi venawh kqawn pe uhy, ");
INSERT INTO hltthb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","tuukhaikhqi ing amik kqawn peek awi ak zakhqi boeih ing amik kawpoek kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Cehlai Meri ingtaw cawhkaw ik-oeihkhqi boeih ce ak kawlung khuiawh khoem nawh poek hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A mingmih a venawh ak kqawn peek amyihna ik-oeihkhqi boeih ce hu unawh a ming zaak a dawngawh Khawsa ang ming zoeksang nawh kyihcah doena tuukhaikhqi ce voei uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ak kqeet nyn, chahhui qeetnaak tym a pha awh, a nu ing a phyihsu hlanawh khan ceityih ing ak kqawn peek amyihna Jesu tinawh ang ming sui hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mosi a anaa awi amyihna ciimcaih sak naak khawnghi ce a pha awh, Joseph ingkaw Meri ing Jesu ce Bawipa venawh suum aham Jerusalem na ceh pyi hy nih, ");
INSERT INTO hltthb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Bawipa a anaa awi awh, “Ak cykcah capa taw Bawipa aham hoep a hamna awm hy,” tinawh qee na a awm a dawngawh), ");
INSERT INTO hltthb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bawipa a anaa awi awh ak kqawn amyihna: kqawng kqukkqu phqek hih am awhtaw im kqukkqu phqek hih ce bulnaak sainaak aham khyn hy nih. ");
INSERT INTO hltthb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Cawh Jerusalem khawk khuiawh Simon ak mingnaak thlang pynoet ce awm hy, anih cetaw thlak dyng ingkaw Khawsa ak kqihchah thlang na awm hy. Anih ing Israel thlangkhqi ngaihding sakkung ce a na qeh nawh, Ciim Myihla ing awm pyi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bawipa a Khrih ce a huh hlan dy am thi kawp ti, tinawh Ciim Myihla ing a na sim sak hawh hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ciim Myihla a hqui sawinaak ak caming bawkim khuina ce cet hy. Anaa awi ing a ngoe amyihna naaca Jesu ak khan awh sai hly kawi sai sak aham a nu ingkaw a pa ing a ni law pyi awh, ");
INSERT INTO hltthb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simon ing lo nawh a kut awh ak pawm coengawh Khawsa ce kyihcah hy: ");
INSERT INTO hltthb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Boeimang Bawipa, nak awitaak amyihna, na tyihzawih ve ngaihqep na ceh sak hawh kawp ti. ");
INSERT INTO hltthb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ikawtih na hulnaak awi ce ka mik ing hu hawh nyng, ");
INSERT INTO hltthb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","thlang boeih a mik huh awh nang ing nang dang sak ce, ");
INSERT INTO hltthb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Gentelkhqi venawh vangnaak ak dang hly kawi ingkaw nak thlang Israelkhqi boeimangnaak hly kawi ce,” tinawh kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Naasen awh anih ing cemyihna awi ak kqawn ce a nu ingkaw a pa ing a ning zaak awh a ning ngaih na kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Cekcoengawh cekkhqi ce Simeon ing zoseennaak a peek coengawh a nu Meri a venawh: “Vawhkaw naasen ve Israel khqik khuiawh thlang khawzah ang tluuknaak ingkaw a thawhnaak na awm kaw, thlang ing amak nep na ak kqawnnaak aham hatnaak ingkaw, ");
INSERT INTO hltthb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","thlang khawzah a lingbyi poeknaak ce ang dang thainaak hamna awm kaw. Na lingbyi awm zawzi ing sun law poelh hyn kawm uh,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Cawh Asher pilnam ak khui awhkaw Phanuel a canu Anna ak mingnaak nu tawngha pynoet ce awm lawt hy. Anih cetaw nucawng hawh hy; a va ingqawi kum khqih doeng ni anik chungvaa, ");
INSERT INTO hltthb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","cekcoengawh a kum kqeetkip hlaihphli dy nuhai na awm hy. Bawkim ce a cehtaak kaa qoe na buh zeih cykcahnaak ing khawthan khawdai Khawsa ce bawk hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Cawh anih ce cekkhqi venna cet nawh, Khawsa venawh zeelnaak awi ak kqawn coengawh Jerusalem hulnaak ak ngaih-ukhqi boeih a venawh cawhkaw naasen akawng ce kqawn pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bawipa a anaa awi ing a kykkhqi boeih ce Joseph ingkaw Meri ing a ni sai boeih coengawh, Kalili qam awhkaw a nimah a khaw Nazareth na ce voei hy nih. ");
INSERT INTO hltthb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Naasen ce bau law hqui nawh ak tha awm law hy; cyihnaak ing be law nawh, Khawsa am qeennaak ce ak khan awh awm hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Loentaak poei pan aham Jerusalem na a nu ingkaw a pa taw kum qoek awh cet poepa hy nih. ");
INSERT INTO hltthb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","A kum hlaihih a law awh, a mi ceh khawi amyihna, cawhkaw poei ak pan na cet uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Poei ang poeng coeng khawna a ming voei awh naasen Jesu taw awm hyt saw a nu ingkaw a pa ing am sim hy nih. ");
INSERT INTO hltthb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Thlang ak voeikhqi anglakawh awm lawt hy voei tinawh poek nih nawh, khawnghi hypoet a ni ceh coengawh, ami cakawkhqi ingkaw ami pyikhqi venawh sui hy nih. ");
INSERT INTO hltthb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","A mani huh law voel awhtaw, anih ak sui na Jerusalem na hlat tlaih hy nih. ");
INSERT INTO hltthb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Khaw thum voei a ni sui coengawh bawkim khuina hu hy nih, cawngpyikung khqing lak awh ngawi nawh a mingmih ak awih kqawnkhqi ce ngai nawh awikhqi a na doet khqi hui awh hu hy nih. ");
INSERT INTO hltthb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Anih a simnaak ingkaw am hlatnaak awi ak zakhqi boeih ce amik kawpoek kyi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","A nu ingkaw a pa ing a ni huh awh, a nik kawpoek kyi hy. A nu ing, “Ka capa, kawtih vemyihna nani sai hy? Na pa ingkaw kai ingtaw ly doena ni sui nih nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Anih ing, “Ikaw hamna nani sui nih? Ka pa im awh awm kaw ti amna ni sim nawh nu?” tina qawi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Cehlai a ningnih a venawh ak kqawn peek awi ce am zasim hy nih. ");
INSERT INTO hltthb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","A ningnih a hu awh Nazareth khaw na cet nawh anik awi ce ngaih pe qawi hy. Cehlai a nu ingtaw cawhkaw ik-oeihkhqi boeih ce ak kawlung khuiawh koem hy. ");
INSERT INTO hltthb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesu taw cyihnaak ing taai khqoet khqoet nawh, Khawsa ingkaw thlanghqing a mik cuuk kawtlaak na awm khqoet khqoet hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberius Kaisar a boeinaak kum hlainga a law awh (Pontius Pilat taw Judah qam ukkung boei na awm hy, a na Philip ce Iturea ingkaw Tracinitis qam ukkung na awm nawh, Lysinias taw Abilene qam ukkung na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anna ingkaw Kaiapha khawsoeih boei khyt na a ni awm awh,) kqawng na ak awm Zekariah capa Johan a venawh Khawsak awi ce law hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Anih ing ce Jordan long keng qam boeih awh cet nawh thawlh qeennaak ham zutnaak baptisma awi ce kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tawngha Isaiah ak awi cabu awh a na qee hyt myihna: “Ramkoh awhkaw ak khy awi ing, 'Bawipa a lam ce qoek a bah unawh, a lamkhqi ce qui sak lah uh, ");
INSERT INTO hltthb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Lawk-kqawngkhqi ce be kawm usaw, tlangkhqi ce neem sak kawm uh; Lam ak kawikhqi ce dyng kawm usaw, lam ak kawkkhqi ce qui sakna awm kaw. ");
INSERT INTO hltthb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Cawhtaw thlang boeih ing Khawsa a hulnaak ce hu kawm uh' tinawh,” kqawn hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A venawh baptisma huh aham ak law thlang kqeng a venawh, “Nangmih khqui a cadilkhqi! Ak law hly kawi kawsonaak ce cehtaak aham u ing a nik kqawn peek khqi? ");
INSERT INTO hltthb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Zutnaak ing ak tingna thaih qah lah uh. Na mimah ingkaw na mimah, “Abraham cahlah ni,” koeh ti uh. Ka nik kqawn peek khqi, vawhkaw lungkhqi za Khawsa ing Abraham a cakhqi na dyih sak thai hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tuhkawng taw thing kung boeih awh hqaica toen na awm hawh hy, thing ikawmih awm ak thaih leek amak qah taw hlu unawh mai awh phum khawi uhy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Cawh thlang kqeng ing, “Cawhtaw ikaw ka mi sai kaw?” tinawh doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Johan ing, “Angki zunghih ak ta ing amak ta ce pe seitaw, awk-ai ak ta ing amak ta a venawh cemyihna sai lawt seh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mangmu ak cawikungkhqi awm baptisma huh aham law lawt unawh a venawh, “Cawngpyikung ikaw ka mi sai kaw?” tinawh doet uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Cek khqi venawh, “A ngoe anglakawh ak doem na koeh cawi law uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Qalkap a vangkhqi ce law unawh a venawh, “Kaimih taw ikaw ka mi sai kaw?” tina uhy. A mingmih a venawh, “Amak thym na tangka koeh lo unawh, amak thym na thlang thawlh koeh puk uh; nami huh namik thaphu ing naming ngaih qep sak uh,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Thlangkhqi ing amik kawlung na Johan ve Khrih hawh mai hy voei aw? tinawh poek uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Cehlai Johan ing cekkhqi boeih a venawh, “Kai ingtaw tui ing baptisma ni pek khqi nyng. Cehlai kai anglakawh ak bau khqoet thlang law hyn kaw, kai taw anih a khawmyk qui ak suh peek aham naza am kawih nyng. ");
INSERT INTO hltthb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Cang zahnaak ce a kut awh pawm nawh cangtakkhqi ce tep ak khuina thlak aham zaap kaw, cehlai ang hi cetaw amak thi thai qoe maih khuina phum kaw,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Awih chang khawzah ing cekkhqi ce a yn coengawh awithang leek ce kqawn pek khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Cehlai ram ukkung boei Herod ing ik-oeih che a saikhqi boeih ingkaw, a na a zu Herodi ce a zunaak a dawngawh, Johan ing ak kaanaak awh, ");
INSERT INTO hltthb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herod ing ce mihkhqi boeih ce cun nawh: Johan ce am tu coengawh thawng khuina thla hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cawhce, vemyihna awm hy, thlangkhqi boeih baptisma a mi huh awh, Jesu awm hu lawt hy. Ak cykcah huiawh, khan ce awng qu nawh ");
INSERT INTO hltthb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ciim Myihla ce kqukkqu myihna ak khan awh cuuk hy. Khawk khan nakawng awi ing: Nang taw ka lungnaak ka Capa ni; nak khan awh zeel soeih soeih nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu ing bibinaak ak kqawn awh a kum sawmthum tluk law hawh hy. Thlanghqing ak poeknaak awhtaw anih ce Joseph a capa na awm hy, Joseph taw Heli a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli taw Matthat a capa, Matthat taw Levi a capa, Levi taw Melki a capa, Melki taw Jannai a capa, Jannai taw Joseph a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph taw Mattathias a capa, Mattathias taw Amos a capa, Amos taw Nahum a capa, Nahum taw taw Esli a capa, Esli taw Naggai a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai taw Maath a capa, Maath taw Mattathias a capa, Mattathias taw Semein a capa, Semein taw Joseeh a capa, Joseeh taw Joda a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda taw Joanan a capa, Joanan taw Rhesa a capa, Rhesa taw Zerubbabel a capa, Zerubbabel taw Shealtiel a capa, Shealtiel taw Neri a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri taw Melki a capa, Melki taw Addi a capa, Addi taw Kosam a capa, Kosam taw Elmadam a capa, Elmadam taw Er a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er taw Josua a capa, Josua taw Eliezer a capa, Eliezer taw Jorim a capa, Jorim taw Maathat a capa, Matthat taw Levi a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi taw Simeon a capa, Simeon taw Judah a capa, Judah taw Joseph a capa, Joseph taw Jonam a capa, Jonam taw Eliakim a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim taw Melea a capa, Melea taw Menna a capa, Menna taw Mattatha a capa, Mattatha taw Nathan a capa, Nathan taw David a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David taw Jesse a capa, Jesse taw Obed a capa, Obed taw Boaz a capa, Boaz taw Salmon a capa, Salmon taw Nahshon a capa. ");
INSERT INTO hltthb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshon taw Amminadab a capa, Amminadab taw Qam a capa, Qam taw Hezqon a capa, Hezqon taw Perez a capa, Perez taw Judah a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah taw Jakob a capa, Jakob taw Isaak a capa, Isaak taw Abraham a capa, Abraham taw Terah a capa, Terah taw Nahor a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor taw Serug a capa, Serug taw Reu a capa, Reu taw Peleg a capa, Peleg taw Eber capa, Eber taw Shelah a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah taw Kainan a capa, Kainan taw Arphaxad a capa, Arphaxad taw Shem a capa, Shem taw Noah a capa, Noah taw Lamech a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech taw taw Methuselah a capa, Methuselah taw Enoch a capa, Enoch taw Jared a capa, Jared taw Mahalalel a capa, Mahalalel taw Kenan a capa, ");
INSERT INTO hltthb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan taw Enosh a capa, Enosh taw Seth a capa, Seth taw Adam a capa, Adam taw Khawsa capa na awm hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu taw Ciim Myihla ing be doena, Jordan awhkawng hlat law nawh sykzoeknaak huh aham Myihla ing qamkoh na hqui hy, ");
INSERT INTO hltthb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ce a hun awh khawnghi phlikip khuiawh qaai ing sykzoek hy. Ce a khawnghi khuiawh ikaw ca awm am ai hy, cedawngawh a hukhit na taw ak phoen cawi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Qaai ing a venawh, “Khawsa Capa na na awm awhtaw, vawhkaw lung ve phaihpi na coeng sak lah,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesu ing, “Thlang ve phaihpi doeng ing ak hqing am ni, tinawh qee na awm hy,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Qaai ing hun a sangnaak na ceh pyi nawh khawmdek awhkaw qam boeih boeih ce huh hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Cekcoengawh a venawh, “Vawhkaw saithainaak ingkaw boeimangnaak boeih boeih ve ni pe vang nyng, vekkhqi boeih ve ka venawh peekna ak awm ni, kai ing ka ngaih ak thlang venawh pe thai nyng. ");
INSERT INTO hltthb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kai ve ni beek nawh, a cu boeih ve nang aham seh nyng,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesu ing, “Bawipa na Khawsa doeng ce beek nawh anih a bi doeng ce bi lah, tinawh qeena ak awm ni,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Qaai ing Jerusalem na ceh pyi nawh bawkim iptih a sangnaak awh dyih sak hy. “Khawsa Capa na na awm awhtaw vawhkawng nuk cawn lah. ");
INSERT INTO hltthb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kawtih ve myihna qeena a awm myihna: “Nang anik khoem ham ak khan ceityihkhqi ce awi pe kawmsaw; ");
INSERT INTO hltthb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","a mingmih ing nang ce ami kut ing ni dawm kawm uh, lung awh am nak khoeng qunaak aham,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesu ing, “Bawipa na Khawsa ce koeh noek koeh dak,” tinawh ak awm ni,” tina hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Qaai ing a sykzoek coengawh, a tym leek a awm hlan dy cehta hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesu taw Myihla thaawmnaak ing Kalili na hlat hy, cawh anih ak awithang ce ce a qam ak khuiawh thang boeih hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sinakawk kqang cawngpyi poe nawh, thlang boeih ing kyihcah uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","A baunaak khaw Nazareth ce pha nawh, Sabbath nyn awh a ceh khawi amyihna sinakawk na ce cet nawh, cawh cauk noet a hamna dyi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tawngha Isaiah ak cazawl ce pe uhy. Hlam nawh vemyihna a qee ce hu hy: ");
INSERT INTO hltthb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","”Khawsa ang Myihla taw kak khan awh awm nawh, khawdengkhqi venawh awithang leek kqawn aham kai ve ni caksak hawh hy. Thawng ak tlakhqi venawh loetnaak awi ingkaw mikhypkhqi venawh mik dainaak awi khypyi aham, phep qeena ak awmkhqi loet sak ham ingkaw, ");
INSERT INTO hltthb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bawi awmhly kum awi kqawn aham kai ve ni tyi hy,” a ti ce. ");
INSERT INTO hltthb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Cekcoengawh cazawl ce zawl tlaih nawh cawhkaw bibikung a venawh a peek coengawh ngawi hy. Sinakawk khuiawh amik awm thlangkhqi boeih a mik ce anih awh cun boeih hy, ");
INSERT INTO hltthb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","cawh a mingmih a venawh, “Tuhngawi nangmih ang zaak awh ve cabu awi ve soep hawh hy,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Am kha awhkawng ak cawn law am qeennaak awi awh thlang boeih ing anih ce kyihcah uhy. “Anih ce Joseph a capa am nu ve? ti uhy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesu ing a mingmih a venawh, “Vawhkaw Awicyih awi ve kqawn hlai hy voei uk ti: 'Siboei, namah ingkaw namah qoei qu sak lah! Kaperanuam khaw awh na sai ka ming zaak ce namah a khaw vawh awm sai lawt lah,' a mi tice,” tinak khqi hy. ");
INSERT INTO hltthb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Awitak ka nik kqaw