﻿USE sofia;
DROP TABLE IF EXISTS sofia.hlt_vpl;
CREATE TABLE hlt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hlt_vpl WRITE;
INSERT INTO hlt_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","A cuekca vaengah Pathen loh vaan neh diklai a suen. ");
INSERT INTO hlt_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Te vaengah diklai te a hinghong la om tih hoeng. Tuidung hman khaw a hmuep loh a dah. Te vaengah Pathen Mueihla tah tui hman ah lam. ");
INSERT INTO hlt_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tedae Pathen loh, “Vangnah om saeh,” a ti dongah vangnah om. ");
INSERT INTO hlt_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Te vaengah Pathen loh vangnah te then tila a hmuh. Te dongah Pathen loh vangnah neh a hmuep te a laklo ah a phih. ");
INSERT INTO hlt_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Te phoeiah Pathen loh vangnah te khothaih la a khue tih a hmuep te khoyin la a khue. Te vaengah hlaem neh mincang om tih khohnin lamhmacuek la om. ");
INSERT INTO hlt_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Te phoeiah Pathen loh tui laklo ah bangyai om saeh lamtah tui neh tui laklo ah phih la om saeh a ti. ");
INSERT INTO hlt_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Te dongah Pathen loh bangyai te a saii tih, bangyai hmui lamkah tui neh bangyai hman kah tui te a laklo ah aka phih la om tangloeng. ");
INSERT INTO hlt_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Pathen loh bangyai te vaan la a khue. Te vaengah hlaem neh mincang om tih khohnin pabae la om. ");
INSERT INTO hlt_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Te phoeiah Pathen loh vaan hmui kah tui rhoek te hmuen pakhat la tingtun uh saeh lamtah laiphuei tueng saeh,” a ti. Te dongah om tangloeng. ");
INSERT INTO hlt_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Pathen loh laiphuei te lan la a khue tih, tui rhoek a tungnah te tuitunli la a khue. Te dongah Pathen loh then tila a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Te phoeiah Pathen loh, “Diklai loh toian, baelhing, a muu aka om ham a thaih te amah hui la a thaih aka saii thing te poe sak saeh. Diklai ah a tii te om saeh,” a ti.Te dongah om tangloeng coeng. ");
INSERT INTO hlt_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Te dongah amah hui la a tii a muu aka om toian, baelhing khaw, amah hui vanbangla amah ah a muu a thaih aka saii thing khaw diklai loh a poe sak. Te dongah Pathen loh then tila a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Te vaengah hlaem neh mincang om tih a thum khohnin la om. ");
INSERT INTO hlt_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Te phoeiah Pathen loh, “Khothaih neh khoyin te a laklo ah phih ham neh khoning ham khaw, khohnin ham khaw, kum tue ham khaw miknoek la om sak ham vaan bangyai ah vangnah om saeh. ");
INSERT INTO hlt_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Vaan bangyai ah khaw, diklai hman aka tue ham khaw, vangnah om saeh,” a ti. Te dongah om tangloeng coeng. ");
INSERT INTO hlt_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Te phoeiah Pathen loh vangnah a len panit te, khothaih kah khohung la vangnah a len pakhat neh khoyin kah khohung la vangnah a yit neh aisi rhoek te khaw a saii. ");
INSERT INTO hlt_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Te phoeiah Pathen loh khothaih neh khoyin aka taemrhai khaw, vangnah neh a hmuep te aka phih ham khaw, ");
INSERT INTO hlt_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Diklai hman aka tue ham khaw, vaan bangyai ah amih te a khueh vaengah Pathen loh then tila a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Te vaengah hlaem neh mincang om tih a li khohnin la om. ");
INSERT INTO hlt_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Te phoeiah Pathen loh, “Rhulcai mulhing hinglu te tui loh luem puei saeh lamtah diklai hman boeih vaan bangyai hmai ah vaa ding saeh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Te dongah Pathen loh, tuihnam a len rhoek neh aka colh aka tat mulhing, hinglu boeih khaw, a suen. Te te amah hui la tui loh a luem sak tih phae aka khueh vaa cungkuem khaw amah hui la om. Te dongah Pathen loh then tila a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Amih khaw Pathen loh yoethen a paek tih, “Pungtai uh lamtah ping uh. Tuitunli kah tui dongah khaw baetawt uh. Vaa long khaw diklai ah pungtai saeh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Te vaengah hlaem neh mincang aka om te a nga khohnin la om. ");
INSERT INTO hlt_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Te phoeiah Pathen loh, “Diklai loh mulhing hinglu te amah hui la, rhamsa khaw, rhulcai khaw, diklai mulhing khaw amah hui la thoeng sak saeh,” a ti. Te dongah thoeng tangloeng. ");
INSERT INTO hlt_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Te dongah Pathen loh diklai mulhing te amah hui la, rhamsa te khaw amah hui la, diklai rhulcai boeih khaw amah hui la a saii. Te te Pathen loh a then la a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Te phoeiah Pathen loh, “Mamih mueiloh la mamih muei neh hlang saii uh sih lamtah tuitunli kah nga soah khaw, vaan kah vaa soah khaw, rhamsa soah khaw, diklai kah a cungkuem soah khaw, diklai ah aka colh rhulcai cungkuem soah khaw, taemrhai uh saeh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Te dongah Pathen loh, amah muei la hlang a suen. Pathen kah muei la tongpa khaw a suen tih huta khaw a suen. ");
INSERT INTO hlt_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Te phoeiah Pathen loh amih rhoi te yoethen a paek tih Pathen loh amih rhoi taengah, “Pungtai uh lamtah ping uh. Diklai khaw khulae uh lamtah tuitunli kah nga khaw, vaan kah vaa khaw, diklai kah aka yuel mulhing boeih khaw, khoem rhoi,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Te phoeiah Pathen loh, “Diklai hman boeih kah a tii aka om baelhing boeih neh a thaih ah a muu aka om thing neh, thing boeih khaw nangmih ham ka khueh coeng ne, nangmih ham cakok la om ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Te phoeiah, “Diklai kah mulhing boeih khaw, vaan kah vaa boeih khaw, diklai ah aka tat tih amah dongah hingnah hinglu aka khueh boeih khaw, baelhing hingsuep boeih te cakok la om saeh,” a ti nah. Te dongah om tangloeng coeng. ");
INSERT INTO hlt_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Pathen loh a saii boeih te a sawt vaengah bahoeng then coeng ne. Te vaengah hlaem neh mincang om tih a rhuk hnin la om. ");
INSERT INTO hlt_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Te tlam te vaan rhoek khaw, diklai khaw, amih kah caempuei boeih khaw a coeng. ");
INSERT INTO hlt_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Pathen loh amah kah a bi saii te hnin rhih neh a coeng tih a hnin rhih vaengah a bibi saii boeih te a duem tak. ");
INSERT INTO hlt_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Te phoeiah Pathen loh a rhih khohnin te yoethen a paek tih te te a ciim. Te vaengah Pathen tah saii ham a suen a bibi boeih lamloh duem. ");
INSERT INTO hlt_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","He tah BOEIPA Pathen loh diklai neh vaan a saii tue ah a suen vaan neh diklai kah a rhuirhong ni. ");
INSERT INTO hlt_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Te vaengah BOEIPA Pathen loh diklai la kho a tlan sak hlan dongah kohong kah tangpuem boeih khaw diklai ah poe hlan. Te dongah lohma kah baelhing boeih daih hlan tih lo tawn ham hlang ana om pawh. ");
INSERT INTO hlt_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tedae diklai lamkah tuihu ha thoeng tih diklai hman boeih a suep. ");
INSERT INTO hlt_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Te phoeiah BOEIPA Pathen loh diklai lamkah laipi te hlang la a hlinsai. Te phoeiah hingnah hiil te a hnarhong ah a ueng pah tih aka hing tongpa hinglu la coeng. ");
INSERT INTO hlt_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Te dongah BOEIPA Pathen loh khothoeng kah Eden ah dum a hlo tih a hlang saii te a khueh. ");
INSERT INTO hlt_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","BOEIPA Pathen loh diklai lamkah thing mueimae then neh caak then boeih te a poe sak tih dum kah laklung ah hingnah thing neh a thae a then mingnah thing om. ");
INSERT INTO hlt_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Te vaengah dum aka suep ham Eden lamkah tuiva long tih te lamkah a phih uh vaengah tuisae pali la coeng. ");
INSERT INTO hlt_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Lamhma kah a ming tah Pishon tih sui aka om Havilah khohmuen tom la a ken. ");
INSERT INTO hlt_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Te khohmuen kah sui tah then tih thingpi neh oitha lungto khaw pahoi om. ");
INSERT INTO hlt_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Te phoeiah tuiva pabae kah a ming tah Khusah khohmuen boeih aka hil Gihon ni. ");
INSERT INTO hlt_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Te phoeiah tuiva a pathum kah ming tah khothoeng Assyria la aka long Khiddekel ni. Tuiva a pali nah tetah Perath ni. ");
INSERT INTO hlt_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Te phoeiah BOEIPA Pathen loh hlang te a loh tih Eden dum ah thotat ham neh dum aka hung ham a khueh. ");
INSERT INTO hlt_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Te dongah BOEIPA Pathen loh hlang taengah a uen tih, “Dum kah thingkung boeih te caak la ca. ");
INSERT INTO hlt_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Tedae a then neh a thae mingnah thingkung lamkah te ca boeh. Te te na caak hnin vaeng lamloh na duek rhoe na duek ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Te vaengah BOEIPA Pathen loh, “Hlang he amah bueng tah om ham then pawh anih ham amah neh a naii uh la bomkung ka saii ni,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Te dongah BOEIPA Pathen loh diklai lamkah, a hlin a sai kohong mulhing boeih neh vaan kah vaa boeih soah metla a khue te hmuh ham khaw, hlang loh a khue boeih te tah mulhing hinglu ming la om sak ham khaw, hlang taengla a khuen. ");
INSERT INTO hlt_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Te dongah hlang loh rhamsa boeih khaw, vaan kah vaa te khaw, kohong kah mulhing khaw, ming a paek dae Adam neh aka tiing la bomkung hmu pawh. ");
INSERT INTO hlt_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Te dongah BOEIPA Pathen loh tongpa te muelh a ih sak. A ih vaengah a vaerhuh pakhat te a loh pah phoeiah a pumsa kah a hma te tloep a saibawn sak. ");
INSERT INTO hlt_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Te phoeiah BOEIPA Pathen loh tongpa lamkah a loh vaerhuh te huta la a saii tih tongpa taengla a khuen. ");
INSERT INTO hlt_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Te vaengah tongpa loh, “Tahae kah he ka rhuh lamkah ka rhuh, ka saa lamkah ka saa ni. Anih he tongpa lamkah a loh dongah huta tila ka khue ni,” a ti ");
INSERT INTO hlt_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Te dongah tongpa loh a napa neh a manu te a toeng ni. Te phoeiah a yuu taengla khoem uh vetih pumsa pakhat la om rhoi ni. ");
INSERT INTO hlt_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Te vaengah tongpa neh a yuu tah pumtling la om rhoi dae yak rhoi pawh. ");
INSERT INTO hlt_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Te vaengah BOEIPA Pathen loh a saii kohong mulhing boeih lakah rhul te tah thaai tih, huta taengah, “Pathen loh , ‘Dum kah thingkung te khat khaw na ca rhoi mahpawh,’ a ti tatak ngawn a?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Te dongah huta loh rhul taengah, “Dum thing thaih te ka caak rhoi thai. ");
INSERT INTO hlt_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Tedae Pathen loh, 'Dum laklung kah thing thaih te ca rhoi boeh, taek rhoi boeh, te dongah na duek rhoi ve,’ a ti,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tedae rhul loh huta taengah, “Na duek rhoe na duek rhoi mahpawh. ");
INSERT INTO hlt_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Te te na caak rhoi khohnin ah na mik khaw tueng vetih a thae a then ming nah khaw Pathen bangla na om rhoi ni tila Pathen loh a ming dongah ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Huta long khaw caak ham koi thing then la, mik ham khaw hoehhamnah koi la a hmuh. Te vaengah a lungming la om ham thing te a nai. Te dongah a thaih te a loh tih a caak. Te phoeiah a taengkah a va te khaw a paek tih a caak. ");
INSERT INTO hlt_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Te phoeiah amih rhoi kah mik te bok tueng tih pumtling la a om rhoi te a ming rhoi. Te dongah thaibu hawn te a hui rhoi tih amamih rhoi ham hni la a saii rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","BOEIPA Pathen kah ol tah te khohnin kah khohli neh dum khuiah a caeh te a yaak rhoi. Te dongah Adam neh a yuu tah BOEIPA Pathen mikhmuh kah, dum lamloh thingkung lakli ah thuh uh rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tedae BOEIPA Pathen loh hlang tongpa te a khue tih a taengah, “Melam na om,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tongpa loh, “Dum ah na ol ka yaak dae kai pumtling dongah ni ka rhih tih ka thuh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Te dongah Boeipa loh, “Nang pumtling ni tila nang taengah ulae aka puen?Caak ham moenih tila nang kan uen thingkung te na caak nama?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Te vaengah tongpa loh, “Huta te kai taengah nan paek coeng ta, anih loh thing te kai taengah m'paek dongah ni ka caak,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Te dongah BOEIPA Pathen loh huta te, “Hekah he metlam na saii,” a ti nah hatah huta loh, “Rhul loh kai n'rhaithi tih ka caak,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Te dongah BOEIPA Pathen loh rhul taengah, “Hetla na saii dongah nang tah rhamsa boeih lakah khaw, kohong kah mulhing boeih lakah khaw, thaephoei thil la na om coeng. Na bung neh na colh vetih na hing tue khuiah laipi na caak ni. ");
INSERT INTO hlt_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nang laklo neh huta laklo ah khaw, nang kah tiingan laklo neh anih kah tiingan laklo ah khaw, thunkha thunhling ka khueh vetih anih loh na lu ham phop ni. Nang long khaw anih kah khomik te na tuk pah ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Pathen loh huta taengah, “Na thatlohnah neh na rhumpum te ka pungtai rhoela ka pungtai sak ni. Patangnah neh camoe na cun ni. Na lungdueknah te na va ham vetih anih loh nang soah n'taemrhai ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Adam te khaw, “Na yuu ol te na hnatang nah. Te dongah, 'Ca boeh ka ti, ' tih nang kan uen lalah, thingkung lamkah te na caak. Te dongah diklai he nang kong ah thae ka phoei thil coeng. Na hing tue khuiah thatlohnah nen ni buh na caak eh. ");
INSERT INTO hlt_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Hling neh lota khaw nang ham daih vetih kohong kah baelhing te na caak ni. ");
INSERT INTO hlt_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Na talung kah hlantui loh diklai la na bo sak daengah ni buh na caak eh. Laipi lamkah nang n'loh dongah laipi la na bal van ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Te phoeiah Adam yuu te aka hing boeih kah a manu la a om ham dongah a ming te Eve tila a sui. ");
INSERT INTO hlt_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Te daengah BOEIPA Pathen loh Adam ham neh a yuu ham maehpho angkidung te a saii pah tih amih rhoi te a bai sak. ");
INSERT INTO hlt_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Te phoeiah BOEIPA Pathen loh, “Hlang he a then khaw a thae khaw ming ham mamih khuikah pakhat phek la ha om coeng he. Tahae ah a kut a yueng tih hingnah thing khaw a loh dongah kumhal hing ham ca lah ve,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Te dongah BOEIPA Pathen loh anih te Eden dum lamkah a tueih. Te lamkah ni khohmuen aka tawn ham a loh. ");
INSERT INTO hlt_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Hlang te khaw a haek coeng tih hingnah thingkung longpuei aka hung ham cherubim neh hmaitak cunghang aka tinghil te Eden dum kah khothoeng ah a khueh. ");
INSERT INTO hlt_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Te phoeiah Adam loh a yuu Eve te a ming. A yuu khaw vawn tih Kain te a cun hatah, “BOEIPA taengkah hlang ka dang coeng,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Te phoeiah Kain kah a mana Abel te pahoi a cun. Te vaengah Abel tah boiva aka dawn la om tih Kain tah lo tawn la om. ");
INSERT INTO hlt_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","A bawtnah khohnin ah BOEIPA taengah khosaa la diklai kah a thaih te Kain loh a khuen. ");
INSERT INTO hlt_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Tedae Abel long tah amah kah boiva cacuek neh aka tha te a Khuen van. Te dongah BOEIPA loh Abel so neh anih kah khosaa te a uem pah. ");
INSERT INTO hlt_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Tedae Kain neh anih kah khosaa te a uem pah pawt dongah Kain te mat sai tih a maelhmai khaw tal. ");
INSERT INTO hlt_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Te dongah BOEIPA loh Kain taengah “Nang te balae tih na sai? Te phoeiah balae tih na maelhmai a tal? ");
INSERT INTO hlt_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Doe hamla a then mai moenih a? Na then pawt dongah ni thohka ah tholhnah a kol mai. Tedae a lungdueknah te nang ham om mai cakhaw namah loh a soah taemrhai saw ,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Tedae Kain loh a mana Abel te kohong la a khue tih a om rhoi vaengah Kain loh a mana Abel te a hnueih tih a ngawn. ");
INSERT INTO hlt_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Te dongah BOEIPA loh Kain taengah, “Na mana Abel ta?” a ti nah hatah Kain loh, “Ka ming pawh. Kai loh ka mana ka dawn a? ” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Te vaengah BOEIPA loh, “Balae na saii?na mana thii ol loh diklai lamkah kai taengla ha pang coeng. ");
INSERT INTO hlt_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Te dongah nang kut lamkah na manuca kah thii aka duen ham a ka aka ang diklai lamloh nang tah thae m'phoei thil coeng. ");
INSERT INTO hlt_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Khohmuen te na tawn vaengah nang taengah a thadueng paek ham koei mahpawh. Diklai ah aka hinghuen tih aka rhaehba la na om ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Tedae Kain loh BOEIPA taengah, “Kai kathaesainah te phueih ham lakah len aih. ");
INSERT INTO hlt_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Tihnin ah kai he diklai hman neh namah hmuh lamkah nan haek dongah ka thuh uh ni. Tedae aka poeng aka doe ka om phoeiah diklai ah ka pamdah cakhaw kai aka hmu boeih loh kai n'ngawn pawn ni he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tedae BOEIPA loh anih taengah, “Kain aka ngawn boeih te tah voei rhih due phulo saeh,” a ti nah. Te dongah anih aka hmu boeih loh anih te ngawn pawt ham Kain soah BOEIPA loh miknoek a paek. ");
INSERT INTO hlt_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Te dongah Kain tah BOEIPA mikhmuh lamkah cet tih Eden kah khothoeng ben Nodi khohmuen ah kho a sak. ");
INSERT INTO hlt_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Te vaengah Kain loh a yuu te a ming. Te dongah pumrhih tih Enok te a cun. Te vaengkah khopuei a thoong tih khopuei ming te a capa ming Enok kho la a khue. ");
INSERT INTO hlt_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Te phoeiah Enok loh Irad a sak tih Irad loh Mahujael a sak. Mahujael loh Methusael te a sak. Methusael loh Lamek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Te phoeiah Lamek loh amah ham yuu panit a loh tih pakhat kah a ming tah Adah tih a pabae kah a ming tah Zillah ni. ");
INSERT INTO hlt_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Te vaengah Adah loh Jabal te a cun tih anih te dap ah kho aka sa tih boiva aka toi rhoek kah pa la om. ");
INSERT INTO hlt_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Tedae a mana, a ming tah Jubal tih anih te rhotoeng neh phavi aka tum boeih kah a napa la om. ");
INSERT INTO hlt_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillah long khaw rhohum neh thi tubael boeih aka hnaa Tubalkain neh Tubalkain kah a ngannu Naamah te khaw a cun. ");
INSERT INTO hlt_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Te vaengah Lamek loh a yuu rhoi Adah neh Zillah taengah, “Lamek yuu rhoi, kai ol he ya rhoi lamtah kai kah olthui he hnakaeng rhoi lah. Kai tloh kong neh ka boengha kongah camoe, hlang pakhat ka ngawn coeng. ");
INSERT INTO hlt_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kain ham voei rhih la phu a loh atah Lamek ham khaw voei sawmrhih neh parhih la phuloh pah saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Te phoeiah Adam loh a yuu te koep a ming tih, capa a cun hatah Abel te Kain loh a ngawn coeng dae a yueng la Pathen loh tiingan a tloe kai ham a khueh coeng' a ti dongah anih ming te Seth la a khue. ");
INSERT INTO hlt_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Te phoeiah Seth long khaw capa a sak tih a ming te Enosh a sui. Te vaengah Yahweh ming te phoei ham a tong. ");
INSERT INTO hlt_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Hekah he Pathen loh hlang a suen tue vaengkah Pathen amah mueiloh la a saii Adam kah rhuirhong cabu ni. ");
INSERT INTO hlt_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","tongpa neh huta a suen phoeiah amih rhoi te yoethen a paek tih amih rhoi a suen khohnin ah amih kah ming te hlang a sui. ");
INSERT INTO hlt_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam tah kum yakhat phoeiah sawmthum hing. Te vaengah amah muei la amah mueiloh la te a sak tih a ming te Seth a sui. ");
INSERT INTO hlt_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seth te a sak phoeiah Adam kah a tue khaw kum ya rhet lo coeng dae ca tongpa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Te dongah Adam kah a hing tue te a pum la kum ya ko neh kum sawmthum a lo phoeiah duek. ");
INSERT INTO hlt_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth khaw kum ya neh kum nga a lo vaengah Enosh te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enosh te a sak phoeiah Seth khaw kum ya rhet neh kum rhih hing tih a canu a capa rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seth tah a khohnin boeih kum ya ko neh kum hlai nit a lo phoeiah duek. ");
INSERT INTO hlt_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosh khaw kum sawmko a lo vaengah Kenan te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosh khaw Kenan te a sak phoeiah kum ya rhet neh kum hlai nga hing tih capa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Te dongah Enosh kah a tue boeih he kum ya ko neh kum nga a lo phoeiah duek. ");
INSERT INTO hlt_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan kum sawmrhih a lo vaengah Mahalalel te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan loh Mahalalel te a sak tih kum ya rhet neh kum likip a lo phoeiah capa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Te dongah Kenan kah a tue boeih he kum ya ko neh kum rha a lo phoeiah duek. ");
INSERT INTO hlt_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel kum sawmrhuk neh kum nga a lo vaengah Jared te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel loh Jared a sak phoeikah kum ya rhet neh kum sawmthum a lo vaengah canu rhoek neh capa rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Te dongah Mahalalel kah a hing tue boeih tah kum ya rhet neh kum sawmko panga a lo phoeiah duek. ");
INSERT INTO hlt_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared te kum ya neh kum sawmrhuk neh kum hnih a lo vaengah Enok te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jared loh Enok a sak phoeikah kum ya rhet a lo vaengah canu rhoek neh capa rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Te dongah Jared kah khohnin tah a pum boeih la kum ya ko neh kum sawmruk neh kum hnih a lo phoeiah duek. ");
INSERT INTO hlt_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enok te kum sawmrhuk neh kum nga a lo vaengah Methuselah te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enok loh Methuselah te a sak phoeiah Pathen neh kum ya thum hmaih a pongpa rhoi phoeiah capa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enok kah khohnin tah a pum boeih la kum ya thum neh kum sawmruk neh kum nga lo. ");
INSERT INTO hlt_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok tah Pathen neh a pongpa dongah Pathen loh a loh tih vik om pawh. ");
INSERT INTO hlt_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methuselah kum ya neh kum sawmrhet kum rhih a lo vaengah Lamek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Methuselah loh Lamek a sak phoeikah kum ya rhih neh kum sawmrhet kum nit a lo vaengah capa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Te dongah Methuselah kah khohnin tah a pum la kum ya ko neh kum sawmruk neh kum ko a lo phoeiah duek. ");
INSERT INTO hlt_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek khaw kum ya neh kum sawmrhet neh kum nit a lo vaengah capa pakhat a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Anih ming te Noah la a khue. Anih he tah BOEIPA loh thae a phoei thil diklai ah mamih kut kah thatlohnah neh bibi dongah mamih aka hloep ham ni,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamek khaw Noah a sak phoeikah kum ya nga neh kum sawmko kum nga a lo vaengah capa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Te dongah Lamek kah khohnin he a pum la kum ya rhih neh kum sawmrhih neh kum rhih a lo phoeiah duek. ");
INSERT INTO hlt_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","A capa Noah khaw kum ya nga a lo vaengah, Noah loh Shem, Hem, neh Japheth te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Te vaengkah hlang loh diklai hman ah pungtai pahoi tih amamih ham canu a cun uh hatah, ");
INSERT INTO hlt_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Pathen capa rhoek loh hlang canu rhoek te then tila a hmuh uh. Te dongah amih te amamih yuu la boeih a coelh tih a loh uh. ");
INSERT INTO hlt_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Te dongah BOEIPA loh, “Hlang ngawn tah pumsa la om tih kai kah mueihla loh hlang taengah kumhal ah ka naep eh a ti pawt dongah hlang kah khohnin he kum ya neh kum kul mah om saeh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Te vaeng tue ah Nephilim rhoek tah diklai ah om uh. A hnukah khaw Pathen capa rhoek te hlang canu rhoek taengah kun uh tih amih ham ca a cun pa uh. Amih te khosuen kah hlangrhalh la ming aka om hlang rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","BOEIPA loh diklai hmanah hlang kah boethae he yet tih a lungbuei kopoek neh benbonah loh boeih khaw hnin takuem a thae bueng ni tila a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Te dongah BOEIPA loh diklai hmankah hlang a saii te hal coeng tih a lungbuei te tlo. ");
INSERT INTO hlt_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Te dongah BOEIPA loh, “Ka suen hlang te diklai hman lamkah ka khoe pawn ni. Hlang khaw, rhamsa khaw, rhulcai khaw, vaan kah vaa khaw amih ka saii dongah te ka hal coeng,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tedae Noah tah BOEIPA mik ah mikdaithen la om. ");
INSERT INTO hlt_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Hekah he tah Noah kah rhuirhong ni. Noah he amah kah thawnpuei khuiah hlang duengneh a cuemthuek la om. Pathen nen khaw Noah tah pongpa hmaih. ");
INSERT INTO hlt_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah loh capa pathum Shem, Ham neh Japheth te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Te vaengah diklai te Pathen mikhmuh ah poci tih diklai te kuthlahnah loh a khulae. ");
INSERT INTO hlt_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Te dongah Pathen loh a sawt vaengah diklai hmanah pumsa boeih tah a longpuei te poci tih diklai khaw poci coeng ne. ");
INSERT INTO hlt_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Te dongah Pathen loh Noah taengah, “Pumsa boeih kah a bawtnah tah ka mikhmuh ah pai coeng. Amih mikhmuh lamkah kuthlahnah te diklai hah. Te dongah ni diklai neh amih te ka phae ne. ");
INSERT INTO hlt_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Namah ham gopher thing neh lawng te saii lamtah lawng te a bu saii pah. Te phoeiah a khui ah khaw, poeng ah khaw aang neh hnil. ");
INSERT INTO hlt_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Tekah lawng te metlam na saii eh tikoinih, lawng kah a yun te dong ya thum, a daang dong sawmnga, a sang dong thukip lo ni. ");
INSERT INTO hlt_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Lawng te imphu na saii vetih tlungyun te tah dong khat cup sak. Te phoeiah lawng kah a kaep ah thohka khueh lamtah a cuek, pabae neh pathum la saii. ");
INSERT INTO hlt_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kai khaw kamah loh pumsa boeih te phae hamla diklai ah tuilii tui kang khuen coeng ne. A khuiah vaan hmui lamkah hingnah mueihla khaw, diklai dongkah a cungkuem he pal ni. ");
INSERT INTO hlt_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Tedae nang taengah kai kah paipi te ka thoh vetih nang khaw, na ca rhoek khaw, na yuu khaw, na langa rhoek khaw, namah neh lawng khuila na khuen ni. ");
INSERT INTO hlt_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Te vaengah mulhing boeih lamkah khaw, pumsa boeih lamkah khaw a hluei neh a la te panit ah khueh lamtah namah taengah hing sak ham lawng te boeih paan puei. ");
INSERT INTO hlt_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Vaa te khaw amah hui la, rhamsa lamkah khaw amah hui la, diklai ah rhulcai boeih lamkah amah hui la, boeih khuikah panit tah hlun ham nang taengah ham paan saeh. ");
INSERT INTO hlt_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Te phoeiah na caak ham buh boeih te namah taengah khuen lamtah namah ham tung. Namah ham neh amih ham cakok la om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Te dongah Noah loh a saii tih Pathen loh anih a uen boeih te a saii van. ");
INSERT INTO hlt_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Te phoeiah BOEIPA loh Noah taengah, tahae kah thawnpuei khuiah nang he kai hmai ah hlang dueng la kan hmuh coeng dongah namah neh na imkhui boeih loh lawng khui la kun laeh. ");
INSERT INTO hlt_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Aka caih rhamsa boeih lamkah a tal neh a la parhih, parhih neh aka caih mueh rhamsa khuikah te tongpa neh a yal panit ah, ");
INSERT INTO hlt_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Vaan kah vaa khaw diklai hman boeih ah a tii la hlun ham a hluei neh a la panit, panit ah namah taengla lo. ");
INSERT INTO hlt_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Tahae lamkah hnin rhih phoeiah tah diklai ah khothaih hnin likip neh khoyin hnin likip te kho ka tlan sak vetih diklai hman kah ka saii mulhing boeih te ka khoe ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Te dongah BOEIPA loh anih a uen vanbangla a cungkuem te Noah loh a saii. ");
INSERT INTO hlt_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Diklai ah tuilii tui halo vaengah Noah tah kum ya rhuk lo. ");
INSERT INTO hlt_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tuilii tui kongah Noah loh a ca rhoek khaw, a yuu khaw, a langa rhoek khaw, amah taengah aka om rhoek khaw, lawng khuila a khuen. ");
INSERT INTO hlt_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Aka caih rhamsa lamkah khaw, aka caih pawh rhamsa lamkah khaw, vaa khaw, diklai ah aka yuel boeih khaw, ");
INSERT INTO hlt_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Pathen loh Noah a uen vanbangla a hluei neh a la panit panit loh Noah taengkah lawng te a paan uh. ");
INSERT INTO hlt_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Hnin rhih a om phoeiah tuilii tui te khaw diklai ah halo. ");
INSERT INTO hlt_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noah kah a hingnah te kum ya rhuk kum, a hla bae, hla kah hnin hlai rhih khohnin ah tuisih laedil puei boeih te phuet tih vaan rhoek kah bangbuet khaw ong uh. ");
INSERT INTO hlt_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Te phoeiah khonal te diklai ah khothaih hnin likip neh khoyin hnin likip ah tlan. ");
INSERT INTO hlt_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Amah tekah khohnin van vaengah Noah neh Noah kah a ca rhoek Shem, Ham, Japheth neh Noah yuu neh a langa pathum tah amah neh lawng khuila kun uh. ");
INSERT INTO hlt_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Amih neh mulhing boeih khaw amah hui la, rhamsa boeih khaw amah hui la, diklai ah aka yuel rhulcai boeih khaw amah hui la, vaa boeih khaw amah hui la, vathawt boeih neh phae aka khueh boeih khaw, ");
INSERT INTO hlt_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","pumsa ah hingnah hil aka om boeih khuikah loh a bok bok la Noah taengkah lawng khuila kun uh. ");
INSERT INTO hlt_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Te dongah Pathen kah a uen vanbangla pumsa boeih khuikah a hluei neh a la loh ham paan uh tih a kun uh phoeiah BOEIPA loh lawng te a khaih. ");
INSERT INTO hlt_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Tuilii te khaw diklai ah khohnin likip lo tih tui khaw yet. Te dongah lawng te a phoh hang tih diklai dong lamloh a pom. ");
INSERT INTO hlt_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Tui khaw len khungdaeng tih diklai ah muep a yet dongah lawng te tui hman soah cet. ");
INSERT INTO hlt_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Te phoeiah tui te diklai ah bahoeng len tih vaan hmui boeih kah tlang sang rhoek boeih te a khuk. ");
INSERT INTO hlt_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Tui te a so ben la dong hlai nga a sang dongah tlang rhoek te boeih a khuk. ");
INSERT INTO hlt_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Te dongah diklai ah aka yuel saa boeih neh vaa boeih, rhamsa khaw, mulhing khaw, diklai dongkah aka luem rhulcai boeih khaw, hlang khaw boeih pal. ");
INSERT INTO hlt_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","A hnarhong khuiah hingnah mueihla hiil aka khueh boeih te khaw, lanhak ah aka om boeih te khaw duek uh. ");
INSERT INTO hlt_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Te vaengah diklai hman kah mulhing boeih, hlang lamloh rhamsa due, rhulcai neh vaan kah vaa due, a khoe dongah diklai ah hmata uh. Tedae Noah neh lawng khuiah amah neh aka om rhoek bueng te sueng. ");
INSERT INTO hlt_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tui te khaw diklai ah khohnin ya neh sawmnga khuiah len. ");
INSERT INTO hlt_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tedae Pathen loh Noah khaw, mulhing boeih khaw, amah neh lawng khuikah aka om hmaih rhamsa boeih khaw a ngaidam. Te dongah Pathen loh diklai ah khohli a tueih tih tui khaw hnop uh. ");
INSERT INTO hlt_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Te phoeiah tuisih laedil neh vaan bangbuet a biing tih vaan lamkah khonal te a paa sak. ");
INSERT INTO hlt_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Diklai hman kah tui te khaw rhaeng. Tui te tla tih, rhaeng tih, khohnin ya sawmnga a boeih vaengah kak. ");
INSERT INTO hlt_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Te phoeikah a hla rhih hla hnin hlai rhih vaengah lawng te Ararat tlang ah duem. ");
INSERT INTO hlt_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Tui aka om rhoek te khaw hla rha khuiah voehvoeh kak tih a hla rha vaengkah lamhmacuek khohnin ah tlang som rhoek te tueng. ");
INSERT INTO hlt_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Te phoeiah om tih hnin likip a boeih vaengah Noah loh lawng kah bangbuet a saii te a ong. ");
INSERT INTO hlt_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Te phoeiah vangak te a tueih hatah diklai ah tui a haang due dong, cet tih voei bal. ");
INSERT INTO hlt_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Te phoeiah diklai hman kah tui kak te aka so ham amah taengkah vahui te a tueih. ");
INSERT INTO hlt_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tedae diklai hman boeih te tui loh a khuk dongah vahui kho kah a khopha ham ngolbuel hmu pawt tih Noah taengah lawng khuila bal. Te vaengah a kut a yueng pah tih vahu te a loh phoeiah lawng khuila a khuen. ");
INSERT INTO hlt_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Te phoeiah hnin rhih koep a rhing tih lawng khui lamkah vahui te koep a tueih. ");
INSERT INTO hlt_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Hlaem vaengah vahui te amah taengla ham paan hatah a hmui dongah olive hnah thingsuep pueng ne. Te dongah diklai kah tui kak coeng tila Noah loh a ming. ");
INSERT INTO hlt_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Te phoeiah hnin rhih a rhing bal tih vahui te a tueih dae anih taengla koep bal voel pawh. ");
INSERT INTO hlt_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Kum ya rhuk neh kum khat, hla lamhmacuek, lamhmacuek khohnin ah diklai hmankah tui te kak. Te dongah Noah loh lawng kah imphu te a khoe tih a sawt vaengah diklai hman te phueihuet la a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Te dongah a hla bae hnin kul neh hnin rhih nen tah diklai phuei coeng. ");
INSERT INTO hlt_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Te phoeiah Pathen loh Noah te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Namah khaw, na yuu khaw, na ca rhoek khaw, namah taengkah na langa rhoek khaw, lawng khui lamkah halo laeh. ");
INSERT INTO hlt_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Pumsa boeih khuiah namah taengkah aka om mulhing boeih neh vaa boeih khaw, rhamsa neh diklai ah rhuicai aka yuel boeih khaw diklai ah luem tih a pungtai vaengah diklai ah ping sak ham namah taengah khuen rhoe khuen,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Te dongah Noah neh a ca rhoek khaw, a yuu neh a langa rhoek khaw, hmaih halo uh. ");
INSERT INTO hlt_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","mulhing boeih neh rhulcai boeih khaw, vaa boeih neh diklai ah aka colh boeih lawng dong lamloh amah huiko neh pawk uh. ");
INSERT INTO hlt_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Te phoeiah Noah loh BOEIPA taengah hmueihtuk a suem. Rhamsa boeih khuikah aka caih neh vaa boeih khuikah aka caih te a loh tih hmueihtuk dongah hmueihhlutnah la a nawn. ");
INSERT INTO hlt_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","BOEIPA loh a hmuehmuei te a huep vaengah a botui. Te dongah BOEIPA loh a lungbuei ah, “Hlang kah lungbuei benbonah he a camoe lamkah thae cakhaw hlang kong ah diklai te thaephoei thil ham ka khoep voel mahpawh. Te dongah mulhing boeih ka saii vanbangla ngawn ham ka khoep voel mahpawh. ");
INSERT INTO hlt_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Diklai a tue boeih a om khuiah cangti tue neh cangah tue khaw, khosik neh khobae khaw, khohal neh sikca khaw, khoyin neh khothaih khaw paa uh mahpawh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Te vaengah Pathen loh Noah neh a ca rhoek te yoethen a paek tih amih taengah, “Pungtai uh lamtah na ping uh vaengah diklai te khulae uh. ");
INSERT INTO hlt_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nangmih kah rhimomnah neh na paepnah tah diklai mulhing boeih so neh vaan kah vaa boeih soah, diklai ah aka colh boeih soah, tuitunli kah nga boeih soah om ni. Nangmih kut ah kam paek coeng. ");
INSERT INTO hlt_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","A cungkuem he nangmih taengah kan paek tih mulhing rhulcai boeih khaw baelhing hingsuep bangla nangmih ham cakok la om ni. ");
INSERT INTO hlt_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tedae maeh kah a hinglu a thii te na ca uh mahpawh. ");
INSERT INTO hlt_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Te phoeiah nangmih kah hinglu ham nangmih kah thii te hmantang la ka suk ni. Mulhing boeih kah kut lamkah khaw ka suk vetih Hlang kut lamkah khaw, a manuca kut lamkah khaw, hlang kah hinglu te ka suk ni. ");
INSERT INTO hlt_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Hlang he Pathen kah muei la a saii dongah hlang kah thii aka long sak hlang tetah amah thii long van ni. ");
INSERT INTO hlt_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Tedae nangmih tah pungtai uh lamtah ping uh. Diklai hmanah luem uh lamtah ping uh. ");
INSERT INTO hlt_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Te phoeiah Pathen loh Noah neh amah taengkah a ca rhoek te a voek. ");
INSERT INTO hlt_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Te vaengah, “Kamah loh ka paipi he, nang taeng neh nang phoeikah na tiingan taengah, ");
INSERT INTO hlt_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","nang taengkah aka hing hinglu boeih taengah, vaa taengah, rhamsa taengah khaw, diklai mulhing boeih taengah khaw, nangmih taeng neh lawng khui lamkah aka lo boeih taengah khaw, diklai mulhing boeih taengah khaw, ka cak sak coeng ne. ");
INSERT INTO hlt_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nangmih taengah ka paipi te ka ling coeng dongah pumsa boeih te tuilii tui neh koep ka huih voel mahpawh. Diklai he phae ham tuilii khaw koep om voel mahpawh he,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Te phoeiah Pathen loh, “Kai loh kamah laklo neh nang laklo ah, khaw aka hing hinglu boeih laklo neh kumhal ham nangmih kah thawnpuei taengah ka paek paipi kah miknoek tah he ni. ");
INSERT INTO hlt_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Kai kah pampacung te cingmai dongah ka khueh vetih kai laklo neh diklai laklo ah paipi kah miknoek la om ni. ");
INSERT INTO hlt_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Diklai hmanah cingmai ka om sak vaengah pampacung te khaw cingmai dongah tueng ni. ");
INSERT INTO hlt_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Te vaengah pumsa boeih phae ham tuilii tui koep halo voel boel saeh tila kai laklo neh nangmih laklo ah khaw, aka hing hinglu boeih neh pumsa boeih taengah ka khueh ka paipi te ka poek ni. ");
INSERT INTO hlt_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Cingmai dongah pampacung te a om vaengah ka sawt vetih Pathen laklo neh diklai hmankah aka hing hinglu boeih, pumsa boeih neh ka khueh dungyan paipi te ka poek ni. ");
INSERT INTO hlt_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Te dongah Pathen loh Noah taengah, “Hekah he tah kai laklo neh diklai hmanah pumsa boeih laklo ah ka ling paipi kah miknoek ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Lawng khui lamkah halo uh vaengah Noah ca rhoek Shem, Ham, Japheth, om uh tih Ham tah Kanaan kah a napa la om. ");
INSERT INTO hlt_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Amih pathum tah Noah kah a ca rhoek tih amih lamkah ni diklai pum ah a hae uh. ");
INSERT INTO hlt_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Te vaengah Noah te lo tawn hlang la om tih misur a tue. ");
INSERT INTO hlt_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Te dongah misurtui te a ok tih a rhuihmil dongah a dap khui ah rha uh. ");
INSERT INTO hlt_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kanaan napa Ham loh a napa kah a yah te a hmuh vaengah kawtpoeng kah a maya rhoi taengah puen. ");
INSERT INTO hlt_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Tedae Shem neh Japheth long tah himbai te a loh rhoi tih amamih rhoi kah a nam ah a khueh rhoi. Te phoeiah a hnuk long caehnawt rhoi tih a napa kah a yah te a khuk pah rhoi. Tedae a hmai khoep a hoi rhoi dongah a napa kah a yah te hmu rhoi pawh. ");
INSERT INTO hlt_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noah te misurtui a lamloh a haenghang vaengah a capa a noi loh anih soah a saii te a ming. ");
INSERT INTO hlt_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Te dongah Kanaan taengah thae a phoei tih, “A maya rhoi taengah sal rhoek khuikah sal la om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Te phoeiah, “Shem kah BOEIPA Pathen te a yoethen saeh lamtah anih ham sal la Kanaan om saeh. ");
INSERT INTO hlt_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Pathen loh Japheth te yoek saeh lamtah Shem kah dap khuiah rhaehrhong saeh. Kanaan tah anih ham sal la om saeh. ");
INSERT INTO hlt_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Tuilii phoei lamkah Noah te kum ya thum neh kum sawmnga hing coeng. ");
INSERT INTO hlt_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Te dongah Noah kah khohnin he a pum la kum ya ko neh kum sawmnga a lo phoeiah duek. ");
INSERT INTO hlt_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Te phoeiah hekah he tah Noah ca rhoek Shem, Ham, neh Japheth neh tuilii phoeiah amih loh a sak a ca rhoek kah rhuirhong ni. ");
INSERT INTO hlt_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Japheth ca rhoek la Gomer, Magog, Madai, Javan, Tubal, Meshek, neh Tiras om. ");
INSERT INTO hlt_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Te phoeiah Gomer ca rhoek la Ashkenaz, Riphath neh Togarmah om. ");
INSERT INTO hlt_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Te phoeiah Javan ca rhoek la Elishah, Tarshish, Kittim, neh Dodanim om. ");
INSERT INTO hlt_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Amih lamkah ni sanglak kah namtom loh amah khohmuen la amah ol neh amah huiko loh amah namtu khuiah rhip a caeh uh. ");
INSERT INTO hlt_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Te phoeiah Ham ca rhoek la Khusah, Mizraim, Put neh Kanaan om. ");
INSERT INTO hlt_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Te phoeiah Kusah ca rhoek la Seba, Havilah, Sabtah, Raamah neh Sabteka om tih Raamah ca rhoi la Sheba neh Dedan om. ");
INSERT INTO hlt_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Te phoeiah Kusah loh Nimrod te a sak tih anih te diklai hmankah hlangrhalh lamhmacuek la om. ");
INSERT INTO hlt_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Anih te BOEIPA mikhmuh ah sayuep hlangrhalh la a om van dongah, “BOEIPA hmai ah sayuep hlangrhalh Nimrod van ni,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Te dongah anih kah khohmuen a tongnah tah Babylon, Erek, Akkad neh Shinar ram Kalneh ni. ");
INSERT INTO hlt_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Te khohmuen lamkah Assyria la cet tih Nineveh, Rehobothir, neh Kalah te a thoh. ");
INSERT INTO hlt_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Te phoeiah Nineveh laklo neh Kalah laklo kah Resen te tah khopuei len la om. ");
INSERT INTO hlt_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Te phoeiah Mizraim loh Ludim khaw, Anamim khaw, Lehabim neh Naptuhim khaw, ");
INSERT INTO hlt_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrusim neh Philisti lamkah aka lo Kasluhim neh Kapthorim khaw a sak. ");
INSERT INTO hlt_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan loh a caming la Sidon phoeiah Kheth, ");
INSERT INTO hlt_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jebusi, Amori, Girhashi, ");
INSERT INTO hlt_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Khivee, Arkit, Sinih, ");
INSERT INTO hlt_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvadi, Zemari, neh Hamathiti te a sak tih a hnukah Kanaan koca la taekyak uh. ");
INSERT INTO hlt_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Te phoeiah Kanaani kah khorhi aka om te Sidon lamkah Gerar benkah Gaza due na cet ni. Sodom taengkah Gomorrah, Admah, Zeboim neh Lasha due na cet ni. ");
INSERT INTO hlt_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hekah he amah khohmuen ah amah namtu kah ol, amah huiko neh aka om Ham ca rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","A ham Japheth mana, Eber ca rhoek boeih kah a napa Shem long khaw, ca a sak. ");
INSERT INTO hlt_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shem koca ah Elam neh Assyria, Arpaxad, Lud neh Aram om. ");
INSERT INTO hlt_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram ca rhoek la Uz, Huul, Gether neh Mash om. ");
INSERT INTO hlt_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphashad long khaw Shelah a sak tih Shelah loh Eber te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber te ca panit a sak dae anih tue vaengah khohmuen a tael dongah pakhat kah a ming te Palak la om tih a mana ming te Yoktawn la om. ");
INSERT INTO hlt_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktawn loh Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO hlt_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO hlt_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO hlt_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, neh Jobab a sak. Te rhoek te Yawktawn kah a ca boeih ni. ");
INSERT INTO hlt_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Te dongah Mesha lamkah Sephar khothoeng tlang due na caeh vaengah amih kah tolrhum la om. ");
INSERT INTO hlt_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Hekah rhoek he amah namtu neh amah khorhi ah amah ol la amah huiko neh aka om Shem ca rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","He tah amah namtu ah amamih kah rhuirhong la aka om Noah ca rhoek kah a huiko rhoek ni. Te dongah tuilii phoeiah he lamkah ni namtom rhoek loh diklai hmanah a yaal uh. ");
INSERT INTO hlt_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Te vaengah diklai pum ah ol pakhat neh olka thikat laom. ");
INSERT INTO hlt_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Tedae amih te khothoeng la a puen uh hatah Shinar khohmuen ah kolbawn a hmuh uh tih teah te kho a sak uh. ");
INSERT INTO hlt_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Te vaengah hlang loh a hui taengah, “Halo, laiboeng sai uh sih lamtah hmai neh tik uh sih,” a ti uh. Te dongah lungto yueng la laiboeng te a khueh tih taplai yueng la lungpaat a khueh uh. ");
INSERT INTO hlt_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Te vaengah, “Lo lah, mamih ham khopuei neh rhaltoengim khaw, a soi te vaan duela sa uh sih. Te dongah mamih ham ming khueh sih, diklai pum kah mikhmuh ah vik n'taekyak uh ve,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Tedae khopuei te hmuh ham BOEIPA ha pawk vaengah hlang ca rhoek loh rhaltoengim te ana sak uh. ");
INSERT INTO hlt_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","BOEIPA loh amih he pilnam pakhat neh ol pakhat la boeih a om uh dongah saii ham a mangtaeng uh khaw saii ham a tong uh hatah amih ham lol tlaih pawt la he! ");
INSERT INTO hlt_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ceh, suntla uh sih lamtah amih ol te thoek pah sih. Te daengah ni hlang loh a hui kah hmuilai te a yaak pawt eh?,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Te dongah BOEIPA loh amih te diklai hman boeih ah a taekyak tih khopuei thoh ham khaw a toeng uh. ");
INSERT INTO hlt_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","He kongah BOEIPA loh diklai pum kah ol he pahoi a thoek pah tih a ming te Babylon a sui. Te lamlong tah BOEIPA loh amih te diklai hman boeih ah a taekyak. ");
INSERT INTO hlt_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Hekah he Shem kah rhuirhong ni. Shem te kum yakhat lo ca coeng tih tuilii kum phoeiah Arpaxad te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arpaxad te a sak phoeiah Shem khaw kum ya nga hing tih capa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaxad khaw kum sawmthum neh kum nga a lo vaengah Shelah te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Shelah te a sak phoeiah Arpaxad khaw kum ya li neh kum thum hing tih a capa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shelah khaw kum sawmthum a lo vaengah Eber te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eber te a sak phoeiah Shelah khaw kum ya li neh kum thum hing tih capa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber khaw kum sawmthum neh kum li a lo vaengah Palak te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Palak te a sak phoeiah Eber khaw kum ya li neh kum sawmthum hing tih capa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Palak khaw kum sawmthum a lo vaengah Reu te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu te a sak phoeiah Palak khaw kum yahnih neh kum ko hing tih capa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu khaw kum sawmthum neh kum nit a lo vaengah Seruk te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seruk te a sak phoeiah Reu khaw kum ya neh kum rhih hing tih capa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk khaw kum sawmthum a lo vaengah Nakhaw te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nakhaw te a sak phoeiah Seruk khaw kum yahnih hing tih capa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nakhaw khaw kum kul neh kum ko a lo vaengah Terah te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Terah te a sak phoeiah Nakhaw khaw kum ya neh kum hlai ko hing tih capa rhoek neh canu rhoek te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah khaw kum sawmrhih a lo vaengah Abram, Nakhaw, neh Haran te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Te phoeiah hekah he Terah kah rhuirhong ni. Terah loh Abram, Nakhaw neh Haran te a sak tih Haran loh Lot te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tedae Haran te a napa Terah mikhmuh ah a pacaboeina khohmuen Khalden kho Ur ah duek. ");
INSERT INTO hlt_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Te phoeiah Abram neh Nakhaw loh yuu a loh rhoi. Abram yuu ming tah Sarai tih Nakhaw yuu ming tah Haran canu Milkah ni. Haran tah Milkah neh Iskah kah a napa ni. ");
INSERT INTO hlt_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Te vaengah Sarai te yaa la om tih camoe khueh pawh. ");
INSERT INTO hlt_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tedae Terah loh a capa Abram neh a capa Haran kah capa Lot khaw, a capa Abram yuu a langa Sarai khaw, a khuen tih Khalden kho Ur lamkah Kanaan khohmuen la caeh ham tun hlah uh dae Haran te a pha uh vaengah teah te kho vik a sak uh. ");
INSERT INTO hlt_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah kah a tue khohnin he kum yahnih neh kum nga lo. Terah khaw Haran ah duek. ");
INSERT INTO hlt_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","BOEIPA loh Abram taengah, “Nang te na khohmuen taeng lamloh, na pacaboeina taeng lamloh, na pa im lamloh cet laeh. Te khohmuen te nang kan tueng bitni. ");
INSERT INTO hlt_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Tedae nang te pilnu la kan saii vetih nang yoethen kan paek ni. Na ming ka rhoeng sak vetih yoethennah om ni. ");
INSERT INTO hlt_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Te phoeiah nang yoe aka then sak rhoek te a yoe ka then sak vetih nang aka kosinah te khaw thae ka phoei ni. Nang kong ah diklai huiko boeih a yoethen uh ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Te dongah BOEIPA loh anih taengah a thui bangla Abram a caeh hatah Lot khaw anih taengah cet van. Tedae Abram Haran lamkah a caeh vaengah kum sawmrhih neh kum nga lo ca coeng. ");
INSERT INTO hlt_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram loh a yuu Sarai te khaw, a maya capa Lot te khaw, khuehtawn a dang uh boeih te khaw, Haran ah a dang hinglu te khaw a khuen. Te phoeiah Kanaan khohmuen la caeh ham hlah uh tih Kanaan khohmuen te a paan uh. ");
INSERT INTO hlt_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Te dongah Abram te khohmuen kah Shekhem hmuen Moreh thingnu due a pha. Tedae te vaengah Kanaan te khohmuen ah ana om uh coeng. ");
INSERT INTO hlt_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Tedae Abram taengah BOEIPA a phoe pah tih, “Hekah khohmuen he na tiingan taengah ka paek ni,” a ti nah. Te dongah amah taengah aka phoe BOEIPA ham hmueihtuk pahoi a suem pah. ");
INSERT INTO hlt_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Te phoeiah te lamkah khothoeng tlang Bethel la puen uh tih tuitunli benkah Bethel neh Ai khothoeng laklo ah amah kah dap a tuk. Te phoeiah BOEIPA ham hmueihtuk a suem tih BOEIPA ming te a phoei. ");
INSERT INTO hlt_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Te phoeiah Abram te aka puen uh ham cet tih Negev la puen uh. ");
INSERT INTO hlt_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tedae khohmuen ah khokha a om dongah Abram te Egypt la cet. Te la a bakuep akhaw khohmuen ah khokha te a nah dongah ni. ");
INSERT INTO hlt_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Tedae Egypt la kun ham a yoei vaengah a yuu Sarai taengah, “Na mueimae sakthen nu tila ka ming coeng ne. ");
INSERT INTO hlt_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Te dongah Egypt rhoek loh nang te m'hmuh uh vaengah, 'Anih yuu ni he,’ a ti uh ni. Te vaengah kai n'ngawn uh vetih nang te n'hing sak uh ni he. ");
INSERT INTO hlt_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Namah te kai ngannu la thui mai. Te daengah ni nang kong neh kai ham khaw thuem vetih nang kong ah ka hinglu khaw a hing eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram Egypt la kun tih Egypt loh a hmuh uh vaengah a yuu te a sakthen tangkik. ");
INSERT INTO hlt_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Pharaoh kah mangpa rhoek loh anih te a hmuh uh vaengah Pharaoh ham anih te a thangthen uh. Te dongah huta te Pharaoh im la a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Anih rhang neh Abram ham khaw then tih tu khaw saelhung khaw, laak khaw, salpa khaw, salnu khaw, laak tal khaw, kalauk khaw Abram taengla boeih kun. ");
INSERT INTO hlt_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tedae Abram yuu Sarai kah dumlai kongah Pharaoh neh anih imkhui te BOEIPA loh a nah la lucik neh a vuek. ");
INSERT INTO hlt_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Te dongah Pharaoh loh Abram te a khue tih, “Hekah he ba ham lae kai taengah na saii. Balae tih anih he namah yuu tila kai taengah na puen pawh? ");
INSERT INTO hlt_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Balae tih, anih he ka ngannu na ti. Te dongah ni anih he ka yuu la kamah taengah ka loh. Tedae na yuu he lo lamtah cet laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Te dongah anih ham Pharaoh loh a hlang rhoek te a uen tih, Abram khaw, a yuu khaw, a taengkah aka om boeih te khaw a tueih uh. ");
INSERT INTO hlt_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Te dongah Abram loh a yuu khaw, anih taengah aka om boeih te khaw, amah taengkah Lot khaw Egypt lamkah Negev la a khuen. ");
INSERT INTO hlt_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Te daengah te Abram loh boiva neh, ngun neh, sui nen khaw lutlut boei. ");
INSERT INTO hlt_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Te dongah Negev lamkah a longpueng vaengah amah kah dap a om nah hmuen Bethel la cet. A moecuek vaengah anih kah dap te Bethel neh Ai laklo ah om. ");
INSERT INTO hlt_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Lamhma ah hmueihtuk hmuen la pahoi a khueh coeng dongah Abram loh BOEIPA ming pahoi a phoei. ");
INSERT INTO hlt_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Te vaengah Lot khaw Abram neh puei uh tih boiva saelhung khaw, dap khaw, rhen a puen. ");
INSERT INTO hlt_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Tedae tun khosak ham te khohmuen amih te noeng voel pawh. Amih rhoi kah khuehtawn khaw muep lo coeng tih tun khosak ham coeng pawh. ");
INSERT INTO hlt_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Te dongah Abram kah boiva aka dawn rhoek neh Lot kah boiva aka dawn rhoek laklo ah khaw, te vaengah khohmuen kah kho aka sa Kanaan rhoek, Perizzi rhoek nen khaw tuituknah vik om. ");
INSERT INTO hlt_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Te dongah Abram loh Lot te, “Kai laklo neh nang laklo ah, ka boiva aka dawn laklo neh na boiva aka dawn laklo ah khaw tohhaemnah om mai boel saeh. Mamih boeina he tongpa rhoi ni. ");
INSERT INTO hlt_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Na hmai ah khohmuen a pum la a om pawt moenih a? Kai taeng lamloh hoep uh laeh. Banvoei te na loh atah bantang la ka cet vetih bantang te na loh atah ka banvoei bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Tedae Lot loh a mik te a huel vaengah Jordan vannaem boeih te tuisuep tangtae bangla boeih a om pah. Yahovah loh a phae hlankah Sodom neh Gomorrah khaw BOEIPA dum bangla, Zoar la a caeh vaengkah Egypt kho bangla a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Te dongah Lot loh amah ham te Jordan vannaem boeih te a tuek. Te dongah Lot te khothoeng la puen uh tih a manuca taeng lakah khat neh khat paek uh rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram tah Kanaan kho ah kho a sak dae Lot tah vannaem kah khopuei rhoek ah kho a sak tih Sodom la puen uh. ");
INSERT INTO hlt_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tedae Sodom hlang rhoek tah thae uh tih BOEIPA taengah hlangtholh koek la om uh. ");
INSERT INTO hlt_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Tedae Lot a nong phoeiah BOEIPA loh Abram te, “Na mik huel lamtah na hmuen lamkah tlangpuei neh tuithim khaw, khothoeng neh tuitunli khaw so laeh. ");
INSERT INTO hlt_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tekah khohmuen na hmuh boeih te kumhal duela nang taeng neh na tiingan taengah kam paek ni. ");
INSERT INTO hlt_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Te dongah na tiingan te diklai kah laipi bangla ka khueh ni. Diklai laipi te hlang loh tae ham a noeng atah nang kah tiingan te a tae thai van ni. ");
INSERT INTO hlt_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Khohmuen te nang kan paek ham coeng dongah thoo lamtah khohmuen te a yun long khaw, a daang long khaw, hil lah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Te dongah Abram te puen uh tih a caeh vaengah Mamre thingnu ah kho a sak. Tekah thingnu te Hebron ah om tih tekah Hebron ah BOEIPA ham hmueihtuk a suem. ");
INSERT INTO hlt_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Te vaeng tue kah aka om Shinar manghai Amraphel, Ellasar manghai Ariyawk, Elam manghai Kedorlaomer neh Goiim manghai Tidal loh; ");
INSERT INTO hlt_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Sodom manghai Bera, Gomorrah manghai Birsha, Admah manghai Shinab, Zeboiim manghai Shemeber neh Zoar manghai Bela taengah caemtloeknah a saii uh. ");
INSERT INTO hlt_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Te rhoek boeih te Lungkaeh tuitunli kah Siddim kol ah cingcui uh. ");
INSERT INTO hlt_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kedorlaomer taengah kum hlai nit thotat uh dae kum a hlai thum vaengah a tloelh uh coeng. ");
INSERT INTO hlt_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kum hlai li vaengah Kedorlaomer khaw amah taengkah manghai rhoek neh cet tih Ashterothkarnaim kah Rephaim neh Ham kah Zuzim khaw, Shaveh Kiriathaim kah Emim khaw, ");
INSERT INTO hlt_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Seir tlang kah Khori neh khosoek taengkah Elparan duela a tloek. ");
INSERT INTO hlt_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Te phoeiah bal uh tih Kadesh kah Enmishpat te a paan uh vaengah Amalek khohmuen boeih neh Hazezontamar ah kho aka sa Amori te khaw a tloek uh. ");
INSERT INTO hlt_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Te phoeiah Sodom manghai khaw, Gomorrah manghai khaw, Admah manghai khaw, Zeboiim kah manghai Zeboiin khaw, Zoar manghai Bela khaw, amih neh aka thoo hmaih Siddim kol kah caemtloeknah te khaw, ");
INSERT INTO hlt_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elam manghai Kedorlaomer khaw, Goiim manghai Tidal khaw, Shinar manghai Amraphel khaw, Ellasar manghai Aryawk khaw manghai rhoek pali panga te a muk. ");
INSERT INTO hlt_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Te vaengah Sodom neh Gomorrah manghai te rhaelrham uh dae Siddim kol kah aka om tuito, lungpaat tuito ah cungku rhoi tih aka sueng rhoek te tlang la rhaelrham uh. ");
INSERT INTO hlt_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Te dongah Sodom neh Gomorrah kah khuehtawn boeih khaw cakok boeih a loh uh tih cet uh. ");
INSERT INTO hlt_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Te vaengah Abram maya capa Lot khaw Sodom ah kho a sak van dongah amah neh a khuehtawn te rhen a khuen uh tih a caeh puei uh. ");
INSERT INTO hlt_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Te vaengah hlangyong te Mamre thingnu rhoek taengah aka cu Amori hoel Eshkol neh Aner kah a manuca tah halo tih Hebrew hoel Abram taengah puen. Amih te Abram kah a tai kung ni. ");
INSERT INTO hlt_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","A manuca a sol pah te Abram loh a yaak van neh amah kah a hlangphaep neh a im kah a cahlah ya thum neh hlai rhet te a hui tih Dan duela a hloem. ");
INSERT INTO hlt_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Tedae khoyin ah amah loh a sal rhoek te hloephloep a tael tih caem a tloek. Te phoeiah amih te Damasku kah banvoei ben Hobah duela a hloem. ");
INSERT INTO hlt_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Te dongah khuehtawn boeih neh a manuca Lot khaw a lat tih anih kah khuehtawn khaw huta rhoek khaw pilnam khaw ham bal puei bal. ");
INSERT INTO hlt_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Te vaengah Kedorlaomer neh anih taengkah manghai rhoek te a tloek phoei lamkah Abram a bal vaengah anih aka doe ham Sodom manghai loh Shaveh kol manghai tuikol la cet. ");
INSERT INTO hlt_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Te vaengah Pathen Pathen taengkah khosoih, Salem manghai Melkhizedek loh vaidam neh misurtui a khuen. ");
INSERT INTO hlt_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Te phoeiah Abram te yoethen a paek tih, “Vaan neh diklai aka men Pathen Pathen loh Abram yoe a then sak. ");
INSERT INTO hlt_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Na rhal rhoek te nang kut ah aka tloeng Pathen Pathen khaw a yoethen pai,” a ti nah. Te dongah Abram loh a cungkuem khui lamkah parha pakhat te anih taengla a paek. ");
INSERT INTO hlt_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Tedae Sodom manghai long tah Abram taengah, “Hinglu te kai ham khueh lamtah khuehtawn te namah ham khuen,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Te dongah Abram loh Sodom manghai taengah, “Vaan neh diklai aka men Khohni Pathen Yahweh taengah ka kut ka phuel coeng. ");
INSERT INTO hlt_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Nang taengkah boeih tah rhuihet neh khokhom rhui pataeng ka doe mahpawh. Te daengah ni, 'Kai loh Abram ka boei sak,’ na ti pawt eh. ");
INSERT INTO hlt_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kai te rhaemaih. Tedae camoe rhoek kah a caak neh Aner Eshkol neh Mamre ah kamah taengla aka lo hlang rhoek kah hamsum te tah amamih kah hamsum la lo uh saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Hekah olka phoeiah tah BOEIPA kah olka te mikhlam ah Abram taengla thoeng tih, “Abram rhih boeh. Kai he nang kah photling la ka om, na thapang bahoeng yet ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Tedae Abram loh, “Ka Boeipa Yahovah aw, kai ham balae na khueh? Kai loh cakol la ka van tih kamah im kah Damasaku hoel Eliezer ni ca la ka pang “a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Te phoeiah Abram loh, “Kai taengah tiingan nan paek moenih he. Te dongah ka im kah camoe ni ka pang coeng he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Te vaengah BOEIPA kah olka loh Abram la, “Anih na pang pawt vetih namah ko khui lamkah aka thoeng te tloep na pang eh ne,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Te phoeiah Abram te poeng la a khuen tih, “Vaan ke paelki lamtah aisi ke tae mai lah. Amih te na tae thai atah a thui vanbangla nang kah tiingan la om van ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Te daengah BOEIPA te a tangnah tih anih kah tangnah te duengnah la a nawt pah. ");
INSERT INTO hlt_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Te dongah ni anih taengah, “Hekah khohmuen he nang taengah paek ham neh pang sak ham Khalden Ur lamkah nang aka khuen te BOEIPA kamah ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Tedae anih loh, “Ka Boeipa Yahovah aw, anih ka pang ni tila metlamlae ka ming eh?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Te dongah Abram la, “Kai taengah vaitola kum thum neh maae a la kum thum, tutal kum thum, vahu, vahuica hang khuen,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Te rhoek boeih te a taengla a khuen pah phoeiah a laklung ah a saek. Te phoeiah a kaekvang te a hui taengah a hmaitoh sak tih a tloeng pah. Tedae vathawt te tah saek pawh. ");
INSERT INTO hlt_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Te vaengah vatlung loh maehrhok te a cuk thil tih Abram loh a hawt. ");
INSERT INTO hlt_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Tedae khomik tla tih Abram khaw ih ham a yalh thuk vaengah a soah mueirhih tamyin loh khuk a tlak thil tarha. ");
INSERT INTO hlt_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Te phoeiah Abram te, “Na tiingan loh amah khohmuen mueh ah yinlai la om ni. Te vaengah amih te thotat uh vetih kum ya li a phaep uh ni tila ming rhoe ming laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tedae a thotat pah namtom te khaw kai loh lai ka tloek vetih a hnukah nang kah tiingan tah khuehtawn a yet neh ha pawk uh ni. ");
INSERT INTO hlt_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Te vaengah nang tah a then la na sampok neh na pa rhoek taengah na cet vetih sading la n'up uh ni. ");
INSERT INTO hlt_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Tedae tahae due Amori kathaesainah a rhoeh pawt dongah tahae lamkah a khong li vaengah ha bal uh ni. ");
INSERT INTO hlt_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Khomik tla tih a hmuep a pha vaengah hmaipom hmaikhu neh hmaithoi hmai te maehpoel laklo ah a pak. ");
INSERT INTO hlt_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Tekah khohnin ah BOEIPA loh Abram taengah moi a boh tih, “Tahae kah khohmuen he Egypt tuiva lamkah tuiva puei Perath tuiva duela, ");
INSERT INTO hlt_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Keni te khaw, Kenizzi te khaw, Kadmoni khaw, ");
INSERT INTO hlt_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Khitti khaw, Perizzi khaw, Rapha khaw, ");
INSERT INTO hlt_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori khaw, Kanaani khaw, Girgashi khaw, Jebusi khaw, nang kah tiingan taengah ka paek coeng,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram yuu Sarai loh anih ham ca cun pah pawh. Tedae amah taengah salnu, a ming ah Hagar, Egypt nu om. ");
INSERT INTO hlt_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Te dongah Sarai loh Abram la, “Ca cun ham khaw BOEIPA loh kai n'khaih coeng he. Ka salnu taengla kun mai lamtah, anih lamloh ka thoh khaming,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Te dongah Sarai ol te Abram loh a ngai. Te dongah Kanaan kho ah Abram loh kho a sak te kum kumrha a thok vaengah Abram yuu Sarai loh a sal Egypt nu Hagar te a loh tih a va Abram taengah a yuu la a paek. ");
INSERT INTO hlt_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Te phoeiah Hagar te a kun thil hatah pahoi pumrhih. Tedae a pumrhih te a ming vaengah a mik neh a boeinu te hnaep. ");
INSERT INTO hlt_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Te dongah Sarai loh Abram taengah, “Kai sokah kuthlahnah te nang pum dongah tla saeh. Kai loh na rhang dongah ka salnu kam paek dae a pumrhih te a hmuh vaengah a mik neh n'hnaep he kai laklo neh nang laklo ah BOEIPA loh laitloek mai saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Tedae Abram loh Sarai la, “Na salnu te namah kut ah om ne. Na mikhmuh ah then ti bangla anih te saii saw,” a ti nah. Te dongah anih te Sarai loh a phaep tih anih khaw Sarai mikhmuh lamloh yong. ");
INSERT INTO hlt_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Tedae Shur long taengkah tuiphuet kaep, khosoek tuiphuet tui taengah BOEIPA kah puencawn a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Te vaengah, “Sarai kah salnu Hagar me lamkah lae na lo tih melam na caeh eh?” a ti nah. Te dongah Hagar loh, “Ka boeinu Sarai hmuh lamloh ka yong coeng,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Tedae BOEIPA kah puencawn loh, “Na boeinu taengah mael lamtah anih kut hmuiah yalh mai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Te phoeiah BOEIPA kah puencawn loh Hagar taengah, “Nang kah tiingan te pungtai rhoela ka pungtai sak vetih a khawk uet ah n'tae lek mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Te phoeiah BOEIPA kah puencawn loh anih te, “Nang kah phacipphabaem te BOEIPA loh a yaak coeng dongah nang na vawn tih camoe a om vaengah a ming te Ishmael la na khue ni. ");
INSERT INTO hlt_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tedae anih he hlang kah kohong marhang la om ni. A kut loh hlang tom a veet vetih hlang boeih kah kut loh anih veet cakhaw a manuca boeih kah mikhmuh ah kho a sak ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Te vaengah, “Kai aka hmu kah a hnuk te hela koep ka hmuh,” a ti dongah anih taengah aka cal BOEIPA ming te, “Nang tah Mueihmuh Pathen,” tila a khue. ");
INSERT INTO hlt_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Te dongah Kadesh laklo neh Bered laklo kah tuito ke Beerlahairoi a sui. ");
INSERT INTO hlt_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Te phoeiah Hagar loh Abram ham capa a cun pah. Hagar loh a cun a capa te Abram loh a ming Ishmael tila a sui. ");
INSERT INTO hlt_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hagar loh Abram ham Ishmael a cun pah vaengah Abram khaw kum sawmrhet kum rhuk lo ca pueng. ");
INSERT INTO hlt_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram kum sawmko neh kum ko a lo ca vaengah Abram taengla BOEIPA phoe tih, “Kai tah Tlungthang Pathen ni. Kai mikhmuh ah pongpa lamtah cuemthuek la om lah. ");
INSERT INTO hlt_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ka paipi he kamah laklo neh nang laklo ah ka khueh vetih nang te muep muep kam ping sak ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Te dongah Abram loh a hmai la a bakop hatah Pathen loh, ");
INSERT INTO hlt_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Kai khaw he, nang taengah ka paipi a om vanbangla namtom hlangping kah a napa la na om ni. ");
INSERT INTO hlt_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nang he namtom hlangping kah a napa la kan khueh coeng dongah na ming khaw Abram la n'khue voel mahpawh. Tedae nang ming te Abraham la om pawn ni. ");
INSERT INTO hlt_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nang te muep muep kan pungtai sak vetih namtom rhoek la kan khueh ni. Te vaengah nang taeng lamkah manghai rhoek ha thoeng ni. ");
INSERT INTO hlt_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Te vaengah ka paipi he kamah laklo neh nang laklo ah khaw, nang phoeikah na tiingan, amih kah cadilcahma laklo ah kumhal paipi la ka thoh ni. Nang ham neh nang phoeikah na tiingan ham Pathen la ka om ni. ");
INSERT INTO hlt_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Te vaengah na lampahnah khohmuen Kanaan kho pum te kumhal khohut la nang neh nang phoeikah na tiingan taengah kam paek vetih amih taengah Pathen la ka om ni “a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Te phoeiah Pathen loh Abraham taengah, “Te dongah ka paipi he nang namah ham khaw, nang phoeikah na tiingan ham khaw, amih kah cadilcahma ham khaw ngaithuen. ");
INSERT INTO hlt_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ka paipi he kamah laklo neh nang laklo ah khaw, nang phoeikah na tiingan laklo ah ngaithuen vetih nangmih khuikah tongpa boeih te yahhmui rhet pah. ");
INSERT INTO hlt_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Te dongah yahhmui na rhet vaengkah na yahhmui saa te kai laklo neh nang laklo kah paipi miknoek la om ni. ");
INSERT INTO hlt_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Te phoeiah nangmih khuikah neh na cadilcahma, im kah cahlah, neh namah tiingan lamkah pawt tih tangka neh na lai kholong ca boeih khuikah tongpa boeih loh hnin rhet a lo ca vaengah yahhmui rhet saeh. ");
INSERT INTO hlt_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Na im kah cahlah long khaw, na tangka neh na lai long khaw, yahhmui a rhet rhoela a rhet daengah ni ka paipi loh na pumsa dongah kumhal paipi la a om eh. ");
INSERT INTO hlt_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Tedae amah kah yahhmui saa aka rhet mueh tongpa pumdul te tah ka paipi a kak sak dongah a pilnam khui lamkah tekah hinglu te khoe saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Te phoeiah Pathen loh Abraham taengah, “Na yuu Sarai amah ming neh na khue mahpawh. Anih ming Sarah te Sarai yuengla om coeng. ");
INSERT INTO hlt_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Anih khaw yoethen ka paek vetih anih rhang neh nang ham capa khaw kan paek ni. Anih yoethen ka paek vetih namtom la coeng ni. Pilnam rhoek kah manghai rhoek khaw anih khui lamkah ha thoeng uh ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Te vaengah Abraham tah a maelhmai neh bakop tih a nueih doela a lungbuei khuiah , “Kum yakhat pa loh a sak vetih kum sawmko nu Sarah loh ca a cun koinih?” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Te dongah Abraham loh Pathen taengah, “Na hmai ah Ishmael mah hing mai koinih,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tedae Pathen loh, “Thuem ngawn dae na yuu Sarah loh nang ham capa han cun vetih a ming te Isaak na sui ni. Ka paipi khaw anih neh anih phoeikah a tiingan ham dungyan paipi la ka thoh ni. ");
INSERT INTO hlt_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Tedae Ishmael ham khaw ka yaak ngawn ne. Anih khaw yoethen ka paek vetih ka pungtai sak ni. Muep muep ka ping sak phoeiah khoboei hlai nit a sak vetih pilnu la ka khueh ni. ");
INSERT INTO hlt_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tedae ka paipi he Isaak taengah ni ka thoh eh. Anih te hmai kum kah tahae khoning vaengah Sarah loh nang hamla a cun ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Anih taengah thui ham te a khah van neh Pathen khaw Abraham taeng lamkah nong. ");
INSERT INTO hlt_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Te dongah Abraham loh a capa Ishmael khaw, a im kah cahlah boeih khaw, Abraham imkhui tongpa rhoek khuikah a tangka neh a lai tongpa boeih te a khuen tih Pathen loh a thui bangla amah khohnin van ah amih kah yahhmui saa te a rhet pah. ");
INSERT INTO hlt_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Te dongah Abraham loh a yahhmui saa a rhet vaengah kum sawmko neh kum ko lo ca coeng. ");
INSERT INTO hlt_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","A capa Ishmael khaw kum hlai thum a lo ca vaengah a yahhmui saa te a rhet pah. ");
INSERT INTO hlt_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Tekah khohnin van ah Abraham neh a capa Ishmael te yahhmui rhet pah la om. ");
INSERT INTO hlt_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Te phoeiah a im kah hlang boeih, im kah cahlah neh kholong ca tangka neh a lai te khaw amah neh yahhmui a rhet uh. ");
INSERT INTO hlt_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abraham te khothaih khobae vaengah Mamre thingnu rhoek kaepkah dap thohka ah ngol dae anih taengla BOEIPA a phoe pah. ");
INSERT INTO hlt_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Te dongah a mik a huel tih a sawt hatah a taengah hlang pathum a pai te lawt a hmuh. Te dongah amih te doe ham dap thohka lamkah yong tih diklai la bakop. ");
INSERT INTO hlt_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Te phoeiah, “Ka Boeipa na mikhmuh ah mikdaithen ni ka dang mai atah na sal taeng lamkah he khumpael mai boeh. ");
INSERT INTO hlt_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Tui bet han khuen mai saeh lamtah na kho silh uh mai. Te dongah thing hmuiah ana hangdang uh mai dae. ");
INSERT INTO hlt_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Tedae na sal taengah na pawk rhoi to vaengah buh kamat khaw ka loh dae vetih na lungbuei a duel phoeiah na cet rhoi mako,” a ti nah. Te vaengah, “Na thui bangla na saii pai,” a ti rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Te dongah Abraham te Sarah taengah dap khuila koe kun tih, “Vaidam buh sum thum te a loe la nook lamtah buh thong laeh” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Te phoeiah Abraham te saelhung taengla yong tih vaito ca a mongkawt neh a then te a loh. Te phoeiah cadong taengah a paek tih a loe la a saii sak. ");
INSERT INTO hlt_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Te phoeiah suknaeng neh suktui khaw, vaito ca a hmoel te khaw han khuen tih amih hmai ah a tawn pah. Tedae a caak uh vaengah amah te amih taengkah thing hmuiah pai. ");
INSERT INTO hlt_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Te vaengah, “Na yuu Sarah ta?,” a ti na uh hatah, “Dap khuiah om ke,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Te phoeiah, “Lomai tue ah nang taengla ka lo rhoe ka lo ni. Te vaengah na yuu Sarah te camoe om pawn ni te,” a ti nah. Te vaengah dap thohka kah anih hnukah aka om Sarah loh a hnatun van. ");
INSERT INTO hlt_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Tedae Abraham neh Sarah kah a kum patong la om rhoi coeng. Huta vanbangla Sarah taengkah khosing om ham khaw bawt coeng. ");
INSERT INTO hlt_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Te dongah Sarah loh amah ko khuiah, “Kai taengah omthennah a om ham ka hal tih ka boeipa khaw patong coeng,” a ti tih nuei. ");
INSERT INTO hlt_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tedae BOEIPA loh Abraham taengah, “Balae tih Sarah loh, 'Kai patong khaw ca ka cun tang venim,’ a ti tih, a nueih he. ");
INSERT INTO hlt_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Hno pakhat he BOEIPA ham rhaisang a? Lomai tue kah khoning vaengah nang taengla ka mael ni. Te vaengah Sarah taengah capa om ni?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Tedae Sarah loh a rhih dongah, “Ka nuei pawh,” a ti tih a basa dae, “Pawh na nueih lalah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Te daengah hlang rhoek loh thoo uh tih Sodom ben la a dan uh hatah amih aka thak ham Abraham khaw amih taengah cet. ");
INSERT INTO hlt_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Tedae BOEIPA loh, “Kai loh ka saii te Abraham taengah ka phah a?,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham khaw namtu len neh pilnu la om rhoe om ni. Anih lamloh diklai namtom boeih a yoethen ni. ");
INSERT INTO hlt_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Anih ka ming daengah ni anih phoeikah a ca rhoek neh a imkhui te a uen vetih duengnah neh tiktamnah saii ham BOEIPA kah longpuei a ngaithuen uh eh. Te daengah ni BOEIPA loh Abraham ham a taengah a thui pah te a thoeng eh. ");
INSERT INTO hlt_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Tedae BOEIPA loh Sodom neh Gomorrah a doek vaengah amih kah tholhnah khaw pungtai tih bahoeng nah coeng. ");
INSERT INTO hlt_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ka suntla laeh vetih a pangngawlnah te ka hmuh mako. Kai taengla aka pawk te boeih a saii uh neh a saii uh pawt khaw ka ming mako,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Te dongah hlang rhoek loh te lamkah hooi uh tih Sodom la a caeh uh vaengah Abraham tah BOEIPA hmai kah pai pueng. ");
INSERT INTO hlt_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Te phoeiah Abraham te thoeih tih, “Hlang dueng neh halang te na khoengvoep sak tang aya? ");
INSERT INTO hlt_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kho khui ah aka dueng sawmnga om khaming, na khoengvoep kuekluek aya? Amih khui kah hlang dueng sawmnga ham hmuen te na hlun mahpawt a? ");
INSERT INTO hlt_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Halang taengah aka dueng duek sak ham hno he saii ham tah nang lamloh savisava. A dueng la, halang la a om khaw, nang lamloh savisava saeh. Diklai pum lai aka tloek loh tiktamnah saii mahpawt nim?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Tedae BOEIPA loh, “Sodom ah sawmnga ka hmuh tih khopuei khui ah hlang dueng om koinih amih kong ah hmuen takuem la ka khuen ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Tedae Abraham loh a doo tih, “Kai he laipi neh hmaiphu la ka om dae Boeipa taengah cal ham ka mulmet coeng he. ");
INSERT INTO hlt_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Aka dueng sawmnga te panga loh a vaitah khaming, panga kongah khopuei pum te na phae aya?” a ti nah hatah, “Sawmli panga te ka hmuh koinih ka phae mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Tedae anih te voek hamla koep a koei tih, “Likip te a hmuh uh khaming,” a ti nah vaengah, “Likip kong ah ka saii mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Te phoeiah, “Boeipa, saii boel mai lamtah ka thui mai eh. Sawmthum khaw a hmuh uh khaming,” a ti nah. Tedae, “Sawmthum te ka hmu koinih ka saii mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Tedae Abaraham loh, “Boeipa taengah cal ham ka mulmet coeng he. Teah te pakul khaw a hmuh uh khaming,” a ti nah vaengah pakul kong ah ka phae mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Te phoeiah khaw, “Sai boel mai dae Boeipa vai bueng mah ka thui mai eh. Hlang rha khaw a hmu uh khaming,” a ti nah vaengah, “Hlang rha kong ah ka phae mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","BOEIPA loh Abraham neh cal ham te a khah van neh vik nong tih Abraham khaw amah hmuen la bal. ");
INSERT INTO hlt_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Hlaem pakhat vaengah puencawn rhoi loh Sodom a pha rhoi. Te vaengah Lot te Sodom vongka ah ngol. Lot loh a hmuh vaengah amih rhoi doe ham thoo tih a mikhmai neh lai la bakop thuk. ");
INSERT INTO hlt_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Te phoeiah, “Ka boei aw, na sal im la ha phael mai dae ne. Rhaeh lamtah na kho sil rhoi dae. Na thoo vetih na longpuei ah na cet dam bitni,” a ti nah. Tedae, “Pawh, toltung ah ka rhaeh rhoi bitni,” a ti rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tedae amih rhoi te tlal a hloep dongah anih taengla hoii uh tih a im ah kun uh. Amih rhoi ham buhkoknah a saii vaengah vaidamding te a kaeng pah tih a caak uh. ");
INSERT INTO hlt_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Tedae a yalh uh hlan ah khopuei hlang Sodom rhoek ca neh camoe patong la pilnam boeih loh a dik a noi duela im a vael uh. ");
INSERT INTO hlt_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Te phoeiah Lot te a khue uh tih, “Khoyin ah nang taengla aka lo hlang rhoi te ta? Amih rhoi te ka ming uh van ham kaimih taengla han khuen,” a ti na uh. ");
INSERT INTO hlt_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Tedae Lot te thohka la cet tih a hnukkah thohkhaih te a khaih. ");
INSERT INTO hlt_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Te phoeiah, “Ka manuca rhoek thaehuet uh boel mai. ");
INSERT INTO hlt_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ka taengah canu panit om pueng he, te rhoi loh tongpa a ming rhoi moenih. Amih rhoi te nangmih taengla kang khuen pawn eh. Te vaengah amih rhoi te na mik loh then a ti bangla saii uh. Tedae hekah hlang rhoi taengah tah hno saii uh boeh. Ka tungpum hlipkhup la ha kun dongah he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tedae, “Thoeih lah,” a ti uh. Te phoeiah, “Bakuep hamla hlang pakhat te halo tih lai a tloek tarha aya? Amih rhoi lakah namah te kan talh uh ve ne,” a ti uh. Te vaengah hlang te khaw, Lot te khaw khak a aep uh tih thohkhaih te boh ham thoeih uh. ");
INSERT INTO hlt_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Te vaengah im khuikah hlang rhoi loh kut a yueng uh tih Lot te amih taeng lamkah im khuila a doek rhoi phoeiah thohkhaih te tlup a khaih rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Te vaengah im thohka kah hlang rhoek te tanoe kangham due mikdael neh a ngawn tih thohka hmuh ham khaw khobing uh. ");
INSERT INTO hlt_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Te phoeiah hlang rhoi loh Lot taengah, “Nang taengah ulae aka om pueng? Na cava neh na capa rhoek khaw, na canu rhoek neh khopuei khuikah namah hut boeih te he hmuen lamkah khuen laeh. ");
INSERT INTO hlt_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","BOEIPA mikhmuh ah amih kah pangngawlnah loh rhoeng coeng tih hekah hmuen he phae ham BOEIPA loh kaimih n'tueih dongah khopuei he ka phae rhoi pawn ni,” a ti rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Te dongah Lot te cet tih a canu rhoek kah a loh a cava rhoek taengah a thui pah vaengah, “Khopuei he BOEIPA loh a phae dongah hekah hmuen lamkah thoo uh lamtah cet uh laeh,” a ti nah. Tedae a cava rhoek kah mikhmuh ah nueihbu bangla a om pah. ");
INSERT INTO hlt_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Tedae mincang a pha vaengah puencawn rhoi loh Lot te a tanolh rhoi tih, “Thoo lamtah na yuu khaw, na canu aka om rhoi he khuen laeh. Khopuei kathaesainah dongah na khoengvoep ve,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Te vaengah uelh tih hlang rhoek te amah kut, a yuu kut neh a canu rhoi kah kut khaw a hlaengtang uh. BOEIPA kah thinphatnah he anih soah a om dongah anih te a khuen tih khopuei vongvoel ah duem uh. ");
INSERT INTO hlt_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Amih te poeng la a khuen neh amih taengah, “Na hinglu te yong puei laeh. Na hnuk paelki boeh. Vannaem takuem ah pai boeh, tlang la yong laeh, na khoengvoep ve,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Tedae Lot loh amih rhoi taengah, “Pawh ka Boeipa bet ca mah. ");
INSERT INTO hlt_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Na sal he na mikhmuh ah mikdaithen ka dang tih na sitlohnah te na rhoengsak dongah ka hinglu hing sak ham kai taengah nan saii coeng. Tedae kai he tlang daengla yong ham tah ka coeng oeh pawh. Yoethae loh kai m'puei vetih ka duek ve. ");
INSERT INTO hlt_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tahae ah ke kah khopuei la rhaelrham ham yoei ta ke. Te dongah anih ke yiit cakhaw pahoi ka yong mai eh. Anih te ka hinglu aka hing sak ham yiit pawt maco?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Te dongah anih te, “Hekah olka ham khaw na mikhmuhah kan paek vetih na thui khopuei te ka palet mahpawh. ");
INSERT INTO hlt_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","A loe la yong pahoi laeh, ke la na pawk hil pakhat khaw saii ham ka coeng thai moenih,” a ti nah. Te dongah khopuei ming khaw Zoar a sui. ");
INSERT INTO hlt_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lot loh Zoar a pha vaengah khomik loh khohmuen ah thoeng coeng. ");
INSERT INTO hlt_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Te vaengah BOEIPA loh BOEIPA taengkah kat hmai te Sodom neh Gomorrah ah vaan lamkah a tlan sak. ");
INSERT INTO hlt_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Te dongah tekah khopuei rhoek neh vannaem boeih khaw, khopuei kah khosa kho boeih neh diklai toian khaw a palet. ");
INSERT INTO hlt_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Tedae Lot yuu loh a hnuk a paelki dongah lungkaeh tung la poeh. ");
INSERT INTO hlt_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham tah mincang ah BOEIPA mikhmuh kah a pai nah hmuen la pahoi hlah uh. ");
INSERT INTO hlt_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Sodom neh Gomorrah ben kah, vannaem khohmuen phai boeih te a dan thuk vaengah hmailing hmaikhu bangla diklai hmaikhu a thoeng te lawt a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Tedae Pathen loh vannaem kah khopuei a phae vaengah Pathen loh Abraham te a poek. Te dongah Lot te a paletnah khui lamloh a khuen. Te phoeiah Lot loh kho a sak nah khopuei te a palet. ");
INSERT INTO hlt_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Te dongah Lot te Zoar lamkah nong tih tlang ah kho a sak. Te vaengah a canu panit te khaw amah taengah om. Zoar ah khosak ham a rhih dongah a canu rhoi khaw lungko khuiah om uh. ");
INSERT INTO hlt_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Te vaengah a caming loh canoi la, “A pa he patong coeng tih diklai pum kah khosing la mamih rhoi taengah aka kun ham hlang khaw diklai ah om voelpawh. ");
INSERT INTO hlt_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Halo, a pa ke misurtui tul sih lamtah a taengah yalh sih. Te phoeiah a pa neh tiingan hing sak sih,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Te dongah a napa te amah tekah khoyin ah misurtui a tul rhoi. Te vaengah a caming kun tih a napa taengah yalh dae me vaengah yalh tih me vaengah a thoh khaw ming pawh. ");
INSERT INTO hlt_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Tekah a vuen ah khaw caming loh canoi taengah, “Hlaemyin ah a pa taengla ka yalh coeng. Tihnin hlaem ah misurtui tul bal sih. Paan lamtah a taengah yalh van. A pa neh tiingan khaw hing sak sih,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Amah tekah hlaem ah khaw a napa te misurtui koep a tul rhoi tih canoi loh a kun thil. A taengah yalh dae me vaengah yalh tih me vaengah a thoh khaw ming pawh. ");
INSERT INTO hlt_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Te dongah Lot canu rhoi te a napa loh a vawn sak. ");
INSERT INTO hlt_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Te phoeiah caming loh capa a cun tih a ming te Moab a sui dongah tihnin due Moab rhoek kah a napa la om. ");
INSERT INTO hlt_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Canoi long khaw capa a cun van tih a ming te Benammi a sui dongah tihnin due Ammon ca rhoek kah a napa la om. ");
INSERT INTO hlt_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Te phoeiah Abraham loh Negev kho la puen uh tih Kadesh neh Shur laklo ah kho a sak vaengkah Gerar ah bakuep. ");
INSERT INTO hlt_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Te vaengah Abraham loh a yuu Sarah te ka ngannu ni a ti dongah Gerar manghai Abimelek a tah tih Sarah te a loh. ");
INSERT INTO hlt_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Tedae Abimelek te khoyin a mang ah Pathen loh a paan tih a taengah, “Rhukom tangtae hlang yuu te na rhawt dongah na duek coeng ne,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Te dongah Abimelek loh anih te ben pawh. Tedae, “Boeipa namtom loh dueng cakhaw na ngawn aya? ");
INSERT INTO hlt_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Amah loh kai taengah, 'Anih ka ngannu a ti tih he long khaw ka nganpa ni, ' a ti moenih a? Ka thinko thincaknah neh, ka kut cimcaihnah nen ni he khaw ka saii,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Te dongah anih te a mang ah Pathen loh, “Ue hekah he nang loh thinko thincaknah neh na saii tila ka ming. Tedae anih taek sak ham nang kam paek pawt dongah kai taengah tholh khui lamloh nang te kan tuem kan soem. ");
INSERT INTO hlt_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tahae ah hlang yuu te mael laeh. Anih te tonghma tih nang ham a thangthui daengah ni na hing eh. Na mael pawt atah na taengkah boeih neh namah khaw na duek rhoe na duek ni tila ming laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Te dongah Abimelek te mincang ah thoo tih a sal boeih te a khue. Te phoeiah hekah olka boeih he amih hna ah a thui hatah hlang boeih loh a rhih uh. ");
INSERT INTO hlt_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelek loh Abraham te a khue tih, “Kaimih ham balae na saii, nang taengah metlam ka tholh tih kamah so neh ka ram ah tholh muep nan khuen. Kai taengah na saii bibi te a saii uh noek moenih,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Te dongah Abimelek loh Abraham te, “Hekah dumlai he na saii vaengah balae na hmuh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Tedae Abraham loh, “Hekah hmuen ah Pathen hinyahnah om pawt tih ka yuu kah olka ah kai n'ngawn uh ve ka ti dongah ni. ");
INSERT INTO hlt_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tedae anih te a pa canu ka ngannu rhep ni. A nu canu pawt dae ka yuu lam khaw om ngawn. ");
INSERT INTO hlt_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Te dongah a pa im lamkah Pathen loh kai kho m'hmang sak vaengah anih taengah, 'Nang kah sitlohnah he kai taengah na saii ham atah mekah hmuen boeih ah m'pha cakhaw, 'Anih he ka nganpa ni, 'ti ne tila kamah loh pahoi ka ti nah coeng,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Te vaengah Abimelek loh tu neh saelhung khaw, sal tongpa neh salnu khaw a loh tih Abraham te a paek. A yuu Sarah te khaw amah taengah a mael. ");
INSERT INTO hlt_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Te phoeiah Abimelek loh, “Na mikhmuh kah ka khohmuen aka om he namah mik ah then na ti bangla khosa ngawn ne,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Sarah taengah khaw, “Na nganpa taengah tangka thawngkhat nang ham hmaithennah ka paek coeng tih namah taengkah aka om boeih neh hlang boeih hmaiah na tang uh coeng he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Tedae Abraham te Pathen taengah thangthui. Pathen loh Abimelek khaw, a yuu khaw, a salnu rhoek khaw a hoeih sak dongah ca a sak uh. ");
INSERT INTO hlt_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Abraham yuu Sarah kah lai ah Abimelek im kah hlang bung boeih te BOEIPA loh a khaih rhoela a khaih pah. ");
INSERT INTO hlt_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","BOEIPA loh a ti bangla Sarah te a hip tih a thui bangla Sarah ham BOEIPA loh a saii. ");
INSERT INTO hlt_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Pathen loh anih a uen bangla Sarah te vawn tih khoning vaengah tah a patong soi ah Abraham ham capa a cun pah. ");
INSERT INTO hlt_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Te phoeiah anih ham Sarah loh a sak pah amah ca sak, a capa ming te Abraham loh Isaak sui. ");
INSERT INTO hlt_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Pathen kah a uen vanbangla Abraham loh a capa Isaak te hnin rhet a lo ca vaengah yahhmui a rhet pah. ");
INSERT INTO hlt_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Te dongah Abraham kum ya a lo ca vaengah a capa Isaak te amah taengah a cun. ");
INSERT INTO hlt_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Tedae Sarah loh, “Pathen loh kai taengah nueihcil han saii he aka ya boeih loh kai taengah nuei van ni,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Te phoeiah, “Sarah loh camoe a khut ni tila Abraham taengah unim aka thui tih a patong daengah capa ka cun he,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Camoe te khaw puel tih suk a kan coeng dongah Abraham loh Isaak kah sukkan khohnin ah buhkoknah muep a saii. ");
INSERT INTO hlt_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Tedae Abraham ham Egypt nu Hagar loh a cun a capa loh a nueih thil te Sarah loh a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Te dongah Abraham taengah, “Salnu kah capa he ka capa Isaak taengah rho a pang thai pawt dongah salnu neh a capa te haek laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Tedae a capa kongmai dongah olka he, Abraham mik ah bahoeng lolh. ");
INSERT INTO hlt_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tedae Pathen loh Abraham taengah, “Camoe ham neh na salnu ham te na mik dongah lolh sak boeh. Isaak rhang neh nang ham tiingan thuep ham coeng dongah Sarah loh nang taengah a thui bangla, anih ol boeih hnatangnah. ");
INSERT INTO hlt_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Tedae salnu capa te khaw na tiingan coeng dongah anih te namtom la ka khueh ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Te dongah Abraham loh mincang ah thoo tih buh neh tuitang tui te a loh. Te phoeiah Hagar a paek tih a laengpang ah a vah. Te phoeiah camoe neh a tueih tih a caeh vaengah Beersheba khosoek ah kho a hmang. ");
INSERT INTO hlt_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tedae tuitang khuikah tui te a khawk vaengah camoe te tangpuem pakhat hmuiah sut a voeih. ");
INSERT INTO hlt_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Camoe kah dueknah te ka hmuh boel mai eh a ti dongah Cet tih li thikat kah tluk a lakhla la amah te ngol. Tedae a yoei la koep ngol tih a ol a huel doeah rhap. ");
INSERT INTO hlt_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Te vaengah Pathen loh camoe kah a rhah ol te a yaak. Te dongah Pathen kah puencawn loh Hagar te vaan lamkah a khue tih, “Hagar, nang taengkah te balae? Ke lamkah camoe ol te Pathen loh a yaak coeng dongah rhih boeh. ");
INSERT INTO hlt_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Thoo, camoe te poeh lamtah anih te namah kut neh talong lah. Anih pilnu la ka khueh ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Te vaengah Pathen loh a mik a tueng sak tih tuito tui a hmuh. Te dongah cet tih tuitang dongah tui a than phoeiah camoe te a tul. ");
INSERT INTO hlt_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Tedae camoe taengah Pathen a om dongah pantai tih khosoek ah kho a sak hatah liva aka kap la coeng. ");
INSERT INTO hlt_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Te phoeiah Paran khosoek ah kho a sak vaengah a yuu te a manu loh Egypt kho lamkah a loh pah. ");
INSERT INTO hlt_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Te vaengkah tue ah aka om olka te tah Abimelek neh amah kah caempuei mangpa Phikhol loh Abraham te, “Nang kah na saii boeih dongah nang taengah Pathen om taktak. ");
INSERT INTO hlt_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Te dongah na bakuep nah khohmuen ah nang ham sitlohnah ka saii vanbangla kai taengah na saii van tih, kamah neh ka ca taengah, ka cadil taengah khaw rhilat pawt ham Pathen hmaiah kai hamla toemngam laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Te dongah Abraham loh, “Kamah loh ka toemngam coeng,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Tedae Abimelek kah sal rhoek loh tuito tui a rhawth pa kongmai dongah Abimelek te Abraham loh a tluung. ");
INSERT INTO hlt_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Tedae Abimelek loh, “Hekah dumlai he u loh a saii khaw ka ming pawt tih nang long khaw kai taengah na puen pawt dongah kai khaw tihnin due ka yaak moenih,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Te dongah Abraham loh boiva neh saelhung a khuen tih Abimelek te a paek phoeiah amamih rhoi kah moi a boh rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Te phoeiah Abraham loh boiva khuikah tumanu pumrhih te a pai sak. ");
INSERT INTO hlt_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Te dongah Abimelek loh Abraham te, “Hekah tumanu pumrhih he metlae amamih bueng na hoep,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Tedae Abraham loh, “Ka kut lamkah tumanu pumrhih he na doe coeng atah tahae kah tuito ka too dongah kai ham laipai la rhep na om ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tekah hmuen te amih rhoi loh a toemngam rhoi dongah Beersheba tila a sui. ");
INSERT INTO hlt_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Te dongah Beersheba ah moi a boh uh phoeiah Abimelek neh amah kah caempuei mangpa Phikhol khaw thoo uh tih Philisti kho la voei uh. ");
INSERT INTO hlt_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Beersheba ah kolanhlaeng a phung tih kumhal Pathen BOEIPA ming te pahoi a khue. ");
INSERT INTO hlt_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Te dongah Abraham he Philisti kho ah kum a yet bakuep. ");
INSERT INTO hlt_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Hekah olka a om phoeiah Pathen loh Abraham te a noemcai tih, “Abraham,” a ti nah hatah “Kai ni he ue,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Te phoeiah, “Tahae ah na capa, na oingaih cangloeng, na lungnah Isaak te khuen lamtah Moriah khohmuen la namah cet laeh. Te phoeiah nang taengah ka thui bangla, tlang pakhat ah hmueihhlutnah la anih te pahoi nawn,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Te dongah Abraham te mincang ah thoo tih laak te a khih. Amah taengkah cadong panit neh a capa Isaak te a khuen tih hmueihhlutnah thing te a aeh. Te phoeiah thoo tih Pathen loh anih taengah a thuinuet nah hmuen la cet. ");
INSERT INTO hlt_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","A hnin thum dongah Abraham loh a mik a huel hatah khohla kah hmuen te a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Te dongah Abraham loh cadong rhoi taengah, “Hiah laak neh namah poekah ana om uh dae . Kai neh camoe he kela ka cet rhoi vetih tho ka thueng rhoi phoeiah nangmih taengla ka bal rhoi ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Te vaengah Abraham loh hmueihhlutnah thing te a loh tih a capa Isaak a koh sak. Te phoeiah a kut dongah hmai neh tumcaca a khuen tih amamih rhoi te hmaih cet rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Te vaengah Isaak loh a napa Abraham te a voek tih, “A pa,” a ti nah. Te vaengah, “Ka ca kai ka om he,” a ti nah hatah, hmai neh thing om dae hmueihhlutnah ham tu ta he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Tedae Abraham loh, “Ka ca hmueihhlutnah ham tu te Pathen amah loh a hmuh bitni,” a ti nah tih amamih rhoi tah hmaih cet rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Te phoeiah Pathen loh anih taengah a uen nah hmuen te a pha rhoi. Te dongah Abraham loh hmueihtuk pahoi a suem tih thing a hong thil phoeiah a capa Isaak te a pin tih hmueihtuk sokah thing so ah a tloeng. ");
INSERT INTO hlt_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Te phoeiah a capa te ngawn ham Abraham loh a kut a yueng tih tumcaca a yueh. ");
INSERT INTO hlt_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Tedae vaan lamkah BOEIPA puencawn loh anih te a khue tih, “Abraham, Abraham,” a ti nah vaengah “Kai ni he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Te vaengah, “Kai taeng lamkah na capa na oingaih cangloeng te na hloh pawt dongah na Pathen na rhih tila ka ming coeng. Te dongah camoe soah na kut hlah boel lamtah anih taengah ba khaw saii boeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Te dongah Abraham loh a mik a huel hatah a hnukkah kocak khuiah tutal a ki aka man te lawt a hmuh. Te dongah Abraham khaw cet tih tutal te a loh phoeiah a capa yueng ah hmueihhlutnah la a nawn. ");
INSERT INTO hlt_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Te dongah Abraham loh a hmuen ming te, “BOEIPA phoe,” tila a sui. “Tihnin ah BOEIPA loh tlang ah a phoe sak bitni,” a ti rhoe pai. ");
INSERT INTO hlt_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Te phoeiah BOEIPA kah puencawn loh Abraham te vaan lamkah a pabae la a khue tih, ");
INSERT INTO hlt_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Hekah hno na saii vaengah na capa, na oingaih cangloeng te na hloh pawt dongah, ");
INSERT INTO hlt_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","nang yoethen khuikah yoethen rhep kan paek tih na tiingan te vaan kah aisi neh tuitunli palang laivin bangla ka pungtai rhoe ka pungtai sak ni. Te vaengah na tiingan loh a thunkha vongka te a pang ni. ");
INSERT INTO hlt_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Te phoeiah kai ol te na ngai dongah nang kah tiingan rhang neh diklai namtom boeih loh a yoethen uh ni tila BOEIPA olphong neh kamah loh ka toemngam coeng,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Tedae cadong rhoi taengla Abraham a bal phoeikah aka thoo uh te Beersheba la tun a pawk uh dongah Abraham loh Beersheba ah kho a sak. ");
INSERT INTO hlt_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Tahae kah olka a om phoeiah Abraham taengah,” Na manuca Nakhaw ham Milkah loh ca tongpa, ");
INSERT INTO hlt_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","A caming la Uz tih a mana Buz neh Aram napa Kemuel khaw, ");
INSERT INTO hlt_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed khaw, Hazo khaw, Pildash khaw, Jidlap neh Bethuel te khaw a sak van ne,” a ti nah uh tih a thui pah. ");
INSERT INTO hlt_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Te dongah Milkah loh Abraham kah a manuca Nakhaw ham tongpa parhet a sak pah. Rebekah he Bethuel loh a sak. ");
INSERT INTO hlt_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Te phoeiah a yula, a ming ah Reumah loh Tebah, Gaham, Tahash neh Maakah a sak pah bal. ");
INSERT INTO hlt_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah kah a hingnah khaw kum ya kum kul kum rhih lo. Sarah kah a hingnah kum tah amah he coeng ni. ");
INSERT INTO hlt_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarah te Kanaan kho Hebron kah Kiriatharba ah duek. Te dongah Sarah rhaengsae ham Abraham cet tih a rhah thil. ");
INSERT INTO hlt_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Te phoeiah Abraham te duek kung lamkah thoo tih Kheth ca rhoek te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Kai tah nangmih taengah yinlai neh lampah ni, nangmih kah khohut phuel te kai taengah m'pae mai, ka mikhmuh lamkah ka hlang duek ka up thai ham khaw,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Tedae Kheth ca rhoek loh Abraham a doo uh tih amah taengah, ");
INSERT INTO hlt_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ka boeipa kaimih ol he hnatun lah . Kaimih khui ah namah ni Pathen khoboei. Kaimih kah phuel saelh khuiah na rhok te up ngawn . Na duek vaengah up ham tah kaimih kah hlang loh a phuel te nang taengah hloh mahpawh,” a ti nauh. ");
INSERT INTO hlt_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Te dongah Abraham te thoo tih tolrhum kah pilnam hmai neh Kheth ca rhoek hmaiah bakop. ");
INSERT INTO hlt_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Amih te koep a voek tih, “Ka mikhmuh kah aka duek he up ham nangmih hinglu ah ni a om atah kai ol hnatang uh lamtah kai yueng la Zohar capa Ephron te hloep uh. ");
INSERT INTO hlt_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Anih kah lohma bawt ah aka om amah hut Makpelah kah lungko te kai taengah m'pae mai saeh. Tangka a ting yet la m'pae saeh lamtah nang lakli ah kamah kah phuel khohut la om saeh ,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Te vaengah Kheth ca rhoek lakli ah Ephron ngol. Te dongah Khitti hoel Ephron loh khopuei vongka la aka lo Kheth ca rhoek boeih kah a hna ah Abraham te a doo tih, ");
INSERT INTO hlt_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Pawh, ka boeipa, kai ol hnatun lah, khohmuen te nang kan paek coeng dongah a khuikah lungko khaw ka pilnam koca rhoek kah mikhmuh ah nang kan paek vanbangla nang kan paek phuel ah na rhok khaw up,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Te dongah Abraham te tolrhum pilnam hmai ah bakop tih, ");
INSERT INTO hlt_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","tolrhum pilnam kah hna yaak ah Ephron te, “Nang khaw kai ol he hnatun mai. Kai lamkah khohmuen phu tangka kan paek vetih na doe koinih ka rhok khaw pahoi ka up sue,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Tedae Ephron loh Abraham te a doo tih amah taengah, ");
INSERT INTO hlt_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ka boeipa, kai ol hnatun lah . Khohmuen phu tangka shekel ya li te kai neh nang laklo ah bahamnim ca?Tahae ah khaw na rhok te up ngawn ,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham loh Ephron te a rhoi. Te dongah thimpom taengkah vanbangla tangka shekel ya li te Kheth ca rhoek kah hna yaak ah a tae tih Abraham loh Ephron ham tangka a thuek pah. ");
INSERT INTO hlt_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Te dongah Mamre khohmuen kaep, Makpelah kah Ephron lo neh a khuikah lungko te khaw, lohma li neh a kaepvai rhi boeih kah thing boeih khaw, ");
INSERT INTO hlt_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","khopuei vongka la aka lo boeih hmai neh Kheth ca rhoek kah mikhmuh ah Abraham kah kho lai la a saii. ");
INSERT INTO hlt_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Te phoei daengah Kanaan kho Hebron Mamre kaep, Makpelah lo kah lungko ah a yuu Sarah te Abraham loh a up. ");
INSERT INTO hlt_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Te dongah lohma neh a khuikah lungko te Kheth ca rhoek taeng lamkah Abraham phuel khohut la a hlaih. ");
INSERT INTO hlt_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham khaw a tue loh patong ben a paan coeng dae a cungkuem dongah BOEIPA loh Abraham te yoethen a paek . ");
INSERT INTO hlt_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Te dongah Abraham loh a im kah a koe boeih aka taem sal a ham taengah, “Na kut te ka phai hmuiah tloeng laeh. ");
INSERT INTO hlt_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Kai loh amih lakli ah kho ka sak dae Kanaan nu rhoek te ka capa kah a yuu la lo boeh. ");
INSERT INTO hlt_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Tedae ka khohmuen neh ka pacaboeina taengah cet lamtah ka ca Isaak ham yuu loh pah tila vaan Pathen, diklai Pathen BOEIPA ming neh nang kan toemngam sak,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Te dongah a sal loh Abraham te , “Hekah khohmuen la kai hnukah vai ham huta loh a huem pawt khaming, na poenah kho la na capa te ka bal khaw ka bal puei aya?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Tedae Abraham loh anih taengah, “Nang te ngaithuen, ka capa te ke la na khuen ve ne. ");
INSERT INTO hlt_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","A pa im neh ka pacaboeina khohmuen lamkah kai aka khuen tih ka taengah a thui vaengah, 'Hekah khohmuen he nang tiingan ham ka khueh ni, ' tila aka toemngam, vaan kah Pathen BOEIPA loh nang hmai ah amah kah puencawn te a tueih vetih ka capa ham a yuu te ke lamkah nan loh pah bitni. ");
INSERT INTO hlt_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Tedae huta loh nang taengah lo ham a huem pawt atah ka olhlo dong lamloh m'hmil saeh. Tedae ka capa te ke la khuen boeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Te dongah salpa loh a kut te a boei Abraham kah a phai hmuiah a khueh tih hekah olka ham amah taengah a toem a ngam . ");
INSERT INTO hlt_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Te phoeiah salpa loh a boei kah kalauk pumrha a loh tih a kut ah a boei kah thennah cungkuem neh cet. Te vaengah thoo tih Nakhaw kah khopuei Aramnaharaim la cet. ");
INSERT INTO hlt_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Tedae hlaem tue vaengkah tuithan rhoek a caeh tue vaengah kalauk te khopuei voel kah tuito tui taengah a kol sak tih, ");
INSERT INTO hlt_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","“Ka boei Abraham kah BOEIPA Pathen aw, ka boei Abraham taengah sitlohnah han saii lamtah tihnin ah kai he m'phu sak laeh. ");
INSERT INTO hlt_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tuiphuet tui kah ka pai vaengah tui than la khopuei hlang kah tanu aka lo rhoek khuikah, ");
INSERT INTO hlt_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Hula aka om te, 'Na amrhaeng hal dae lamtah tui ka o eh?,’ ka ti nah vaengah, 'O lamtah na kalauk rhoek khaw tui kan tul eh?,’ aka ti te na sal Isaak ham na hmoel pah. Anih dongah ka boei taengah sitlohnah nan saii tila ka ming ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tedae a thui te a khah hlanah Abraham kah a manuca Nakhaw yuu Milkah capa Bethuel loh a sak Rebekah te a laengpang ah amrhaeng neh pakcak ha pawk. ");
INSERT INTO hlt_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","A mueimae bahoeng aka then huta oila la om tih anih tetongpa loh ming hlan. Tuiphuet la suntla tih amrhaeng te a than tih yoeng. ");
INSERT INTO hlt_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Te dongah anih doe ham salpa te yong. Te phoeiah, “Nang kah amrhaeng tui bet n'coih ne,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Te dongah, “Ka boeipa o mai saw,” a ti nah tih a kut kah a amrhaeng te khaw koe a hal pah. Te phoeiah anih te a tul. ");
INSERT INTO hlt_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Anih te bawt a tul phoeiah, “Na kalauk rhoek ham khaw a ok rhoeh hil kan than dae eh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Te phoeiah a amrhaeng te tuisoi dongah koe a kingling tih tui than hamla tuito la koep yong. Te phoeiah a kalauk boeih ham tui a than. ");
INSERT INTO hlt_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","BOEIPA loh a longpuei a thaihtak sak neh a thaihtak sak pawt khaw ming hamla tongpa loh huta te duem a boelh. ");
INSERT INTO hlt_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Te dongah kalauk loh bawt a ok nen tah tongpa loh sui hnaii a khiing beka khat neh a kut dongkah ham sui khungpak panit, a khiing parha te a loh. ");
INSERT INTO hlt_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Te phoeiah, “Nang ukah canu lae?Kai taengah thui lah. Na pa im ah pah ham a hmuen kaimih ham om aya?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Te dongah anih taengah, “Kai tah Milkah loh Nakhaw ham a cun a capa Bethuel canu ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Te phoeiah anih te, “Kaimih taengah cangkong khaw, kamvuelh khaw, coih tih rhaeh hmuen khaw om,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Te dongah tekah hlang te buluk tih BOEIPA te a bawk. ");
INSERT INTO hlt_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Te phoeiah, “Ka boei Abraham kah Pathen BOEIPA tah a yoethen pai. A sitlohnah neh uepomnah loh ka boei te hnoo pawh. Kai khaw ka boei kah a manuca im duela longpuei ah BOEIPA loh m'mawt coeng,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Hula te khaw yong tih hekah olka te a manu cako ham a thui pah. ");
INSERT INTO hlt_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Te vaengah Rebekah te a nganpa, a ming ah Laban khaw om. Te dongah Laban te tollong la yong tih tuiphuet kah hlang taengla cet. ");
INSERT INTO hlt_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Tedae hnaii neh a ngannu kut kah khungpak te lawt a hmuh tih a ngannu Rebekah loh, “Tekah hlang loh kai taengah a thui,” a ti nah, ol a yaak. Hlang te a paan vaengah tah, tuiphuet kah kalauk taengah sut ana pai pah. ");
INSERT INTO hlt_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Te dongah, “BOEIPA kah yoethen a paek tah halo pai. Balae tih vongvoel ah na pai?Kai khaw im neh kalauk ham hmuen ka rhoekbah coeng ta,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Te daengah tekah hlang loh im la cet tih kalauk te a hlam. Te phoeiah kalauk ham cangkong neh kamvuelh khaw, anih kho neh a taengkah hlang rhoek kho silh nah hamla tui khaw a paek. ");
INSERT INTO hlt_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Te phoeiah caak te amih hmai ah a tawn pah hatah, “Kamah kah olka ka thui hlanah ka ca mahpawh,” a ti nah. Te dongah, “Thui,” a ti nah hatah, ");
INSERT INTO hlt_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","“Kai tah Abraham kah sal ni. ");
INSERT INTO hlt_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Tahae ah BOEIPA loh ka boeipa te yoethen muep a paek dongah boei coeng. Te phoeiah anih te boiva khaw, saelhung khaw, cak neh sui khaw, salpa neh salnu khaw, kalauk neh laak khaw a paek. ");
INSERT INTO hlt_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ka boeipa kah a yuu Sarah khaw a patong soiah ka boeipa ham ca a sak pah tih a taengkah koe boeih te anih ham a khueh pah. ");
INSERT INTO hlt_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tedae ka boeipa loh kai te, 'Ka capa yuu ham tah kai loh kho ka sak thil khohmuen kah Kanaan nu te loh pah boeh. ");
INSERT INTO hlt_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Tedae a pa im la lat cet lamtah kamah huiko te ka ca yuu la loh pah,’ a ti tih a toem a ngam . ");
INSERT INTO hlt_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Tedae ka boeipa te, 'Kai hnukah huta te halo pawt khaming,’ ka ti nah hatah, ");
INSERT INTO hlt_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","'BOEIPA amah mikhmuh ah ni kai ka caeh. Nang taengah amah kah puencawn te han tueih vetih na longpuei a thaihtak sak vaengah ka capa yuu khaw kamah huiko neh a pa im lamkah te na loh thai ni. ");
INSERT INTO hlt_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kamah huiko taengla na pawk mak atah kai kah thaephoeinah lamkah m'hmil bitni. Nang taengah a canu te m'paek uh pawt akhaw kai kah thaephoeinah lamkah ommongsitoe la na om ngawn ni, ' a ti. ");
INSERT INTO hlt_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Tedae tihnin ah tuiphuet te kam pha tih, 'Ka boei Abraham kah Pathen BOEIPA aw, namah na om atah he la ka pongpa vaengah ka longpuei han thaihtak sak laeh. ");
INSERT INTO hlt_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Kai loh tuiphuet kah tui taengah he ka pai vaengah tuithan la aka lo hula te om mai tih anih te, “Na amrhaeng dongkah tui te kai bet n'tul laem,’ ka ti nah vetih, ");
INSERT INTO hlt_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Te vaengah kai taengah, 'Namah o ngawn lamtah na kalauk rhoek ham khaw kan than eh?,’ ti saeh. Tekah huta te ka boeipa kah a capa ham BOEIPA loh hmoel saeh,” ka ti. ");
INSERT INTO hlt_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Kai loh ka lungbuei ah ka thangthui te ka khah hlanah mah Rebekah loh a laengpang sokah amrhaeng neh tarha ha pawk tih tuiphuet la suntla thuk. Tui a than phoeiah anih te, 'Kai n'tul laem,’ ka ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Te vaengah amah pum dongkah amrhaeng te koe a hal tih, 'O lamtah na kalauk rhoek khaw ka tul eh?,” a ti. Te dongah ka ok tih kalauk rhoek te khaw tui a tul. ");
INSERT INTO hlt_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Te phoeiah anih te ka dawt tih, 'Nang u canu lae?' ka ti nah vaengah Milkah loh Nakhaw ham a sak pah a capa Bethuel canu ni, ' a ti. Te dongah a hnarhong ah hnaii ka bang pah tih a kut ah khungpak ka buen sak. ");
INSERT INTO hlt_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Te phoeiah ka buluk tih BOEIPA te ka bawk vaengah, “Ka boei kah a manuca canu te a capa ham aka lo la oltak longpuei ah kai aka mawt ka boei Abraham kah BOEIPA Pathen te ka uem. ");
INSERT INTO hlt_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tedae tahae ah ka boeipa ham sitlohnah neh uepomnah tueng ham na huem atah kai taengah thui lah. Kai taengah na thui uh pawt bal atah banvoei bantang la ka mael mai eh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Te dongah Laban neh Bethuel loh a doo tih, “BOEIPA lamkah olka aka thoeng te a thae then khaw nang taengah ka thui rhoi thai pawh. ");
INSERT INTO hlt_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Na mikhmuh ah Rebekah aka om he lo lamtah caeh puei . BOEIPA kah a thui vanbangla na boeipa capa kah a yuu la om saeh,” a ti rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Amih rhoi kah olka te Abraham kah sal loh a yaak vaengah BOEIPA taengah diklai la bakop tih a bawk. ");
INSERT INTO hlt_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Te phoeiah salpa loh cak hnopai neh sui hnopai khaw, himbai khaw a sat tih Rebekah te a paek. A nganpa neh a manu te khaw kawnthen a paek pah. ");
INSERT INTO hlt_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Te daengah amah neh amah taengkah hlang rhoek khaw a caak a ok uh tih rhaeh uh. Mincang a thoh uh vaengah, “Ka boeipa taengah kai n'tueih mai laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tedae a nganpa neh a manu loh, “Hula he kaimih taengah khohnin hninrha tluk om dae vetih na cet mako,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Te dongah Abraham kah salpa loh amih taengah, “BOEIPA loh ka longpuei han thaihtak sak vanbangla kai he n'hloh uh boel mai. Ka boeipa taengah n'tueih mai lamtah kai ka cet mai eh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Te dongah, “Hula te khue uh sih lamtah amah olthui te dawt uh dae sih,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rebekah te a khue uh phoeiah, “Hekah hlang taengah na cet aya?” a ti nah uh vaengah, “Ka cet ni ta,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Te dongah a ngannu Rebekah neh anih kah cakhoem te khaw, Abraham kah sal neh a hlang rhoek te khaw a tueih uh. ");
INSERT INTO hlt_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Te vaengah Rebekah te yoethen a paek uh tih amah taengah, “Ka ngannu nang tah a thawng thawngrha la coeng lamtah, na tiingan loh a lunguet kah vongka te huul saeh,” a ti nahuh. ");
INSERT INTO hlt_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Te phoeiah Rebekah neh hula rhoek te thoo uh tih kalauk soah ngol uh. tongpa hnukah a caeh uh ham coeng dongah Rebekah te Abraham kah sal loh a loh tih a caeh puei . ");
INSERT INTO hlt_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Te vaengah Negev kho ah khosak ham Beerlahairoi lamkah aka lo Isaak khaw ha pawk. ");
INSERT INTO hlt_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Hlaem a pha vaengah Isaak te lohma la cet tih kho a poek . Te vaengah a mik a huel tih a sawt hatah kalauk tarha ha khong pah. ");
INSERT INTO hlt_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah long khaw a mik a huel hatah Isaak te a hmuh tih kalauk so lamloh rhum thuk. ");
INSERT INTO hlt_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Te phoeiah salpa taengah, “Mamih doe ham lohma li ah tongpa aka lo ke ulae?,” a ti nah vaengah a salpa loh, “Ka boeipa ni,” a ti nah dongah hnii te a loh tih a yil. ");
INSERT INTO hlt_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Te phoeiah salpa loh a saii hno boeih te Isaak taengah a thui. ");
INSERT INTO hlt_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaak loh hula te dap khuikah a manu Sarah taengla akhuen. Te phoeiah Rebekah te a loh tih anih yuu la coeng. Te dongah anih te a lungnah tih a manu hnukah Isaak khaw hal van. ");
INSERT INTO hlt_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Te phoeiah Abraham loh yuu koep a loh tih anih ming tah Keturah ni. ");
INSERT INTO hlt_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Abraham ham Zimran neh Jokshan khaw, Medan khaw, Midian khaw, Ishbak khaw, Shuah khaw a sak pah. ");
INSERT INTO hlt_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan loh Sheba neh Dedan te a sak tih Dedan ca rhoek la Asshurim, Lethushim neh Leummim om. ");
INSERT INTO hlt_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian ca rhoek la Ephah khaw, Epher khaw, Hanok khaw, Abidah neh Eldaah khaw om tih amih boeih he Keturah ko rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham loh amah kah a cungkuem te Isaak taengah a paek. ");
INSERT INTO hlt_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Tedae Abraham yula rhoek kah a ca rhoek te Abraham loh amah a hing vaengah kutdoe a paek tih a capa Isaak taeng lamkah khothoeng ben khothoeng kho la vik a tueih. ");
INSERT INTO hlt_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Te dongah Abraham kah a hingnah kum tue he kum ya neh kum sawmrhih kum nga hing. ");
INSERT INTO hlt_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Tedae Abraham he pal tih a duek vaengah khaw patong sampok then neh ngaikhuek la a pilnam taengah khoem uh. ");
INSERT INTO hlt_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Te vaengah anih te a ca rhoi Isaak neh Ishmael loh Mamre kaep Khitti hoel Zohar capa Ephron lo kah Makpelah lungko ah a up rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Tekah lo te Abraham loh Kheth ca rhoek taeng lamkah a lai dongah, Abraham loh a yuu Sarah te pahoi khaw a up. ");
INSERT INTO hlt_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Tedae Abraham a dueknah hnutah aka om tah, a capa Isaak te Pathen loh yoethen a paek. Te dongah Isaak loh Beerlahairoi taengah kho a sak. ");
INSERT INTO hlt_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Te phoeiah hekah he Abraham capa Ishmael, Abraham taengah Sarah loh a paek a sal Egypt nu Hagar loh a cun kah rhuirhong ni. ");
INSERT INTO hlt_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","He tah amamih ming bangla Ishmael ca rhoek kah a ming ni. Amih kah rhuirhong dongah Ishmael kah caming tah Nebaioth tih Kedar neh Adbeel, Mibsam, ");
INSERT INTO hlt_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO hlt_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish, Kedemah om. ");
INSERT INTO hlt_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Amih Ishmael ca rhoek he khaw amah ming, amah vongtung, amah lumim neh amah namtu kah khoboei he hlai nit om uh. ");
INSERT INTO hlt_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Tedae Ishmael kah a hingnah kum he kum ya neh kum sawmthum kum rhih a lo vaengah pal tih a duek dongah a pilnam taengla khoem uh. ");
INSERT INTO hlt_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Amih khaw Havilah lamkah Assyria la aka pawk Egypt khorhi Shur duela kho a sak uh tih a manuca rhoek boeih kah imdan ah pakuep uh. ");
INSERT INTO hlt_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Te phoeiah hekah he Abraham capa Isaak kah a rhuirhong ni. Abraham loh Isaak a sak tih, ");
INSERT INTO hlt_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaak kum sawmli a lo ca vaengah a yuu te Paddanaram kah Arammi Bethuel canu, Arammi Laban ngannu, Rebekah te a loh. ");
INSERT INTO hlt_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Tedae anih te a yaa dongah Isaak loh BOEIPA taengah a yuu yueng la thangthui. Te dongah anih te BOEIPA loh a rhoi tih a yuu Rebekah pahoi pumrhih. ");
INSERT INTO hlt_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Tedae a ko khuikah camoe rhoi te phop uh rhoi. Te dongah, “Balae tih hetla ka om mai,” a ti. Te dongah BOEIPA te dawt ham cet. ");
INSERT INTO hlt_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Te dongah BOEIPA loh anih taengah, “Nang bung khuiah namtu neh namtu om rhoi tih na ko lamkah namtu te panit la paek uh rhoi ni. Te vaengah namtu pakhat te namtu pakhat lakah te tlung vetih a ham loh a noe taengah thotat ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Tedae a tue a tuemtuen vaengah a bung ah caphae la tarha a cun. ");
INSERT INTO hlt_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Te vaengah aka thoeng lamhma te a pum boeih lingphung tih a mul khaw himbai bangla a om dongah anih ming te Esau a sui. ");
INSERT INTO hlt_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","A hnukah a mana om tih a kut neh Esau kah khodil te a tuuk. Te dongah a ming te Jakob a sui. Amih rhoi a sak vaengah Isaak khaw kum sawmrhuk lo ca coeng. ");
INSERT INTO hlt_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Tedae camoe rhoi te a pantai vaengah Esau te pongcet hlang, sakap thai la hlang coeng tih Jakob he dap ah duem aka om hlang la coeng. ");
INSERT INTO hlt_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Te vaengah Esau kah sakah te a ka dongah a tui pah dongah Isaak loh a lungnah dae Rebekah long tah Jakob a lungnah. ");
INSERT INTO hlt_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Tedae Jakob loh andam a thong vaengah Esau buhmueh rhathih la pong lamkah ha pawk. ");
INSERT INTO hlt_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Te dongah Esau loh Jakob la, “Kai he bumueh rhathih la ka om dongah tekah a thim a thim te kai n'cah mai,” a ti nah. Te dongah anih ming te Edom a sui. ");
INSERT INTO hlt_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Tedae Jakob loh, “Tihnin ah nang kah caminghamsum te kai taengah han yoi,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Te dongah Esau loh, “Hekah caminghamsum khaw kai ham te balam nim. Kai duek ham ka cet coeng he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Tedae Jakob loh, “Tihnin ah kai ham toemngam laeh,” a ti nah vaengah a toemngam tih a caminghamsum te Jakob taengla a yoih. ");
INSERT INTO hlt_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Te daengah Jakob loh buh neh rhacik andam te Esau a paek. Tedae a caak a ok phoeiah thoo tih vik cet. Te dongah Esau loh caminghamsum te a sawtsit coeng. ");
INSERT INTO hlt_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Abraham tue vaengkah aka om khokha lamhma bangla khohmuen ah khokha hlawt a om dongah Gerar kah Philisti manghai Abimelek taengla Isaak cet. ");
INSERT INTO hlt_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Te vaengah anih taengah BOEIPA phoe tih, “Egypt la cet boeh. Nang taengah kan thui khohmuen ah rhaehrhong mai. ");
INSERT INTO hlt_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Hekah kho ah na bakuep cakhaw, 'Hekah khohmuen pum he nang neh nang kah tiingan taengah ka paek ni, ' tila na pa Abraham taengah ka toemngam sut olhlo te ka thoh ham coeng dongah nang taengah ka om vetih nang yoethen kan paek ni. ");
INSERT INTO hlt_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Na tiingan khaw vaan aisi bangla ka pungtai sak vetih na tiingan taengah hekah khohmuen boeih ka paek vaengah nang kah tiingan rhang neh diklai namtom boeih a yoethen uh ni. ");
INSERT INTO hlt_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Te dongah ni Abraham loh ka ol a hnatun tih ka kueknah, ka olpaek, ka khosing neh ka olkhueng te a ngaithuen,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaak loh Gerar ah kho a sak. ");
INSERT INTO hlt_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Te vaengah te hmuen kah hlang loh a yuu kawng a dawt uh. Te vaengah, “Rebekah he a mueimae then tih anih kongah te hmuen kah hlang rhoek loh kai n'ngawn uh ve,” a ti. “Ka yuu ni,” ti ham a rhih tih, “Ka ngannu ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Teah te kum a sen a om phoeiah Philisti manghai Abimelek loh bangbuet lamkah a dan hatah Isaak loh a yuu Rebekah a law te lawt a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Te dongah Abimelek loh Isaak te a khue tih, “Anih he na yuu taktak a? Tedae bahamlae, 'Anih he ka ngannu ni, ' na ti,” a ti nah. Te dongah Isaak loh, “Anih kongah ka duek ve,” ka ti dongah ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Te dongah Abimelek loh, “Kaimih taengah balae na saii he?Pilnam khuikah pakhat loh na yuu taengah yalh koinih kaimih soah tholhnah nan pup hloe mai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Te dongah Abimelek loh pilnam boeih te a uen tih, “Hekah hlang neh a yuu te aka ben tah duek rhoe duek saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaak loh khohmuen a tawn tih BOEIPA loh yoethen a paek dongah amah kum ah a pueh yakhat a dang. ");
INSERT INTO hlt_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Tekah hlang khaw pantai tih thoeih la thoeih coeng. Te dongah a khawk nah hil boeilen tih rhoeng. ");
INSERT INTO hlt_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Te vaengah anih kah tuping boiva neh saelhung boiva khaw, imkhut khaw muep a khueh. Te dongah Philisti rhoek te anih taengah thatlai uh. ");
INSERT INTO hlt_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Te dongah a napa Abraham tue vaengah a napa kah sal rhoek loh a too uh tuito boeih te Philisti rhoek loh a toeng sak uh tih laipi neh a et pa uh. ");
INSERT INTO hlt_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Te dongah Abimelek loh Isaak te, “Nang he kaimih lakah bahoeng na tahoeng dongah kaimih taeng lamloh nong laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaak loh te lamkah nong phoeiah Gerar soklong ah rhaeh tih pahoi kho a sak. ");
INSERT INTO hlt_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Te vaengah a napa Abraham tue vaengah a too uh dae Abraham a duek phoeiah Philisti rhoek loh a toeng sak tuito tui te Isaak loh koep a too. Te dongah tuito ming te a napa kah ming sui phek la a sui. ");
INSERT INTO hlt_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Tedae Isaak kah sal rhoek loh soklong ah a too uh hatah hingnah tui tuito te a hmuh uh. ");
INSERT INTO hlt_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tedae Gerar kah boiva aka dawn rhoek neh Isaak kah boiva aka dawn rhoek toh uh thae tih, “Kaimih kah tui ni,” a ti uh. Te dongah amih neh a tukvat uh thae vanbangla Esek tuito tila a ming a sui. ");
INSERT INTO hlt_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Te phoeiah tuito a tloe a too uh hatah te dongah khaw toh uh thae bal tih a ming te Sitnah a sui. ");
INSERT INTO hlt_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Te lamloh puen uh tih tuito a tloe a too vaengah toh uh thae voel pawh. Te dongah, “BOEIPA loh mamih ham hmuen han saelh tih khohmuen ah m'pungtai uh ni he,” a ti. Te phoeiah a ming te Rehoboth a sui. ");
INSERT INTO hlt_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Te phoeiah te lamloh Beersheba la cet. ");
INSERT INTO hlt_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Tedae tekah hlaem ah anih taengla BOEIPA phoe tih, “Kai he na pa Abraham kah Pathen ni. Nang taengah ka om tih ka sal Abraham kong ah nang yoethen kan paek phoeiah na tiingan te ka ping sak ham dongah rhih boeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Te dongah hmueihtuk pahoi a suem tih BOEIPA ming te a phoei. Te phoeiah amah kah dap khaw pahoi a tuk tih Isaak kah sal rhoek loh tuito pahoi a vueh uh. ");
INSERT INTO hlt_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Te vaengah Gerar lamkah Abimelek neh amah kah baerhoep Ahuzzath khaw, amah kah caempuei mangpa Phikol te Isaak taengla halo uh. ");
INSERT INTO hlt_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Te dongah Isaak loh amih te, “Nangmih loh kai nan hmuhuet uh tih na taeng lamkah kai na haek uh phoeiah kai taengla balae nan loh uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Te vaengah amih loh, “BOEIPA tah nang taengah om tila ka hmuh rhoe ka hmuh uh coeng. Te dongah kaimih laklo ah khaw, kaimih laklo neh nang laklo ah olcaeng om saeh lamtah nang taengah moi bop sih ka ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Nang te kam ben uh pawt tih nang taengah a then bueng ni ka saii uh. Te dongah nang khaw sading la kan tueih uh. BOEIPA loh yoethen m'paek vanbangla kaimih taengah a thae na saii pawt mako,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Te dongah amih ham buhkoknah a saii tih a caak a ok uh. ");
INSERT INTO hlt_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Te phoeiah mincang ah thoo uh tih hlang khat neh khat te toemngam uh rhoi tih amih te a tueih phoeiah Isaak khaw ngaimong la voei. ");
INSERT INTO hlt_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Tedae tekah khohnin ah Isaak kah sal rhoek halo uh tih a taengah a too uh tuito kongmai kawng te puen uh. Te vaengah a taengah, “Tui ka hmuh uh coeng, ” a ti nauh. ");
INSERT INTO hlt_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Te vaengah tekah hmuen te Sheba a sui dongah khopuei ming khaw tahae khohnin due Beersheba la om. ");
INSERT INTO hlt_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau khaw kum sawmli a lo ca vaengah a yuu te Khitti Beeri canu Judith neh Khitti Elon canu Basemath te a loh. ");
INSERT INTO hlt_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Te dongah Isaak neh Rebekah taengah mueihla khahingnah om. ");
INSERT INTO hlt_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Tedae Isaak te a patong vaengah a mik hmang tih tueng pa pawh. Te vaengah a capa a ham Esau te a khue tih, “Ka capa,” a ti nah hatah a taengah, “Kai ni he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Te phoeiah, “Ka patong coeng tih ka dueknah khohnin khaw ka ming moenih he. ");
INSERT INTO hlt_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Te dongah na hnopai, na liva neh na lii te lo laeh. Te phoeiah pong ah cet lamtah kai ham lampu sakah han yuep laeh. ");
INSERT INTO hlt_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Te phoeiah ka ngaih vanbangla kai ham antui saii lamtah ka taengla han khuen. Ka ca saeh lamtah ka hinglu loh ka duek hlan ah nang te yoethen kan pae eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isaak loh a capa Esau taengah a thui vaengah Rebekah loh a yaak. Te dongah Esau tah pong ah maeh loh ham saa yuep la cet. ");
INSERT INTO hlt_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Te vaengah Rebekah loh a capa Jakob te a uen tih, “Na pa loh na maya Esau te a voek coeng ne. ");
INSERT INTO hlt_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'Sakah te kai taengah han khuen lamtah kai ham antui saii laeh. Te phoeiah ka ca saeh lamtah ka duek hlan ah BOEIPA hmuh ah nang yoethen kan pae eh,’ a ti nah te ka yaak coeng he. ");
INSERT INTO hlt_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Te dongah ka ca, kai loh nang kan uen bangla ka ol he ngai laeh. ");
INSERT INTO hlt_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Boiva taengla cet lamtah maae ca a then panit te kamah taengla han khuen laeh. Te phoeiah na pa ham a ngaih bangla antui ka saii eh. ");
INSERT INTO hlt_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Te phoeiah na pa taengla khuen lamtah ca saeh. Te nen te a duek hlan ah nang te yoethen m'paesaeh ,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Tedae Jakob loh a manu Rebekah taengah, “Ka maya Esau tah mulsui hlang tih kai tah sahnal hlang ni he. ");
INSERT INTO hlt_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","A pa loh kai te m'phatuem khaming, a mik ah laithae la ka om vetih kai soah rhunkhuennah thoeng koinih yoethennah moenih,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Tedae a manu loh anih taengah, “Ka capa nang sokah rhunkhuennah te kai soah tla saeh. Kai ol he duem ngai laeh. Te dongah cet lamtah kamah taengla hang khuen,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Te dongah cet tih a loh phoeiah a manu taengla a khuen. Te vaengah a manu loh a napa kah a ngaih bangla antui a saii pah. ");
INSERT INTO hlt_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Te phoeiah Rebekah loh a capa a ham Esau kah himbai then te, im ah a loh tih a ca noe Jakob te a bai sak. ");
INSERT INTO hlt_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Te phoeiah maae ca kah a vin te a kut neh a rhawn kah a sahnal soah a dah pah. ");
INSERT INTO hlt_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Te phoeiah antui neh buh a saii te a capa Jakob kut ah a doe. ");
INSERT INTO hlt_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Te phoeiah a napa taengla cet tih, “A pa,” a ti nah hatah, “Kai ni he, ka ca nang he unim?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Tedae Jakob loh a napa taengah, “Kai he na caming Esau ni. Kai taengah nan thui bangla ka saii coeng. Thoo lamtah, ngol laeh. Ka sakah he ca lamtah na hinglu loh kai he yoethen paek saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Tedae Isaak loh a capa te, “Ka ca metlam lae hekah he koe na hmuh lah,” a ti nah. Te dongah, “Na Pathen BOEIPA loh kai ham a thoeng sak dongah ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Te dongah Isaak loh Jakob te, “Bet ha thoeih lamtah ka ca nang te, ka ca Esau taktak neh taktak pawt a khaw kan yam lah eh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Te dongah Jakob loh a napa Isaak taengla thoeih tih a phatuem vaengah, “Ol tah Jakob ol dae a kut tah Esau kut,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Tedae a kut te a maya Esau kut phek, mulsui la a om dongah anih te hmat pawt tih yoethen a paek. ");
INSERT INTO hlt_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Te vaengah, “Nang he ka ca Esau taktak a?” a ti nah hatah, “Kai ni ue,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Te dongah, “Kai taengla han thoeih lamtah ka ca kah sakah te ka ca eh. Ka hinglu loh nang yoethen m'pae saeh,” a ti nah. Te phoeiah a taengla a thoeih pah. Te vaengah a caak phoeiah misurtui khaw a khuen pah tih a ok. ");
INSERT INTO hlt_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Te phoeiah a napa Isaak loh anih te, “Ka ca bet ha thoeih lamtah kai m'mok,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Te dongah thoeih tih a mok. Te vaengah a himbai bo te a him pah tih yoethen a paek. Te phoeiah, “So lah, ka capa bo he, BOEIPA loh yoethen a paek khohmuen bo bangla om. ");
INSERT INTO hlt_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Te dongah Pathen loh nang taengah vaan lamkah buemtui khaw, diklai khuehtawn khaw, cangpai cungkuem neh misur thai khaw m'pae saeh. ");
INSERT INTO hlt_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Pilnam rhoek loh nang taengah thotat uh saeh lamtah, namtu loh nang taengah bakuep khaw bakuep saeh. Na pacaboeina rhoek taengah boei la om lamtah na manu ca rhoek loh nang taengah bakop uh saeh. Nang thae aka phoei thil tah thaephoei thil saeh. Nang yoethen aka pae te yoethen pae saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Tedae Isaak loh Jakob yoethen a paek te a khah van neh Jakob tah a napa Isaak mikhmuh lamloh nong tih vawl cet. Te phoeiah a maya Esau te a sakah nah lamkah tloep pai. ");
INSERT INTO hlt_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Anih long khaw antui a saii van tih a napa taengla a khuen. Te phoeiah a napa te, “A pa thoo lamtah na capa kah sakah he ca laeh. Na hinglu loh kai yoethen m'pae saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tedae anih te a napa Isaak loh, “Nang ulae?” a ti nah hatah, “Kai, na capa na caming Esau ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Te dongah Isaak tah thuennah neh a nah la mat lakueng tih, “Saa a yuep phoeiah kai taengla aka khuen te ulae? Na lo hlan ah boeih ka caak tih anih te yoethen ka paek dongah a yoethen ngawn coeng,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau loh a napa kah olka te a yaak tih a len la pangngawlnah neh hluthlut mat pang. A napa taengah, “A pa, kai khaw yoethen m'pae,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Tedae, “Na mana te thailatnah neh halo tih nang kah yoethennah a loh coeng,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Te dongah Esau loh, “A ming khaw Jakob la a khue pai. Te dongah ni a pabae la kai n'rhim tih kai kah caminghamsum te a loh. Te phoeiah kai kah yoethennah a loh coeng he,” a ti. Te phoeiah, “Kai ham tah yoethennah na paih pawt nim?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Tedae Isaak loh Esau te a doo tih, “Anih te nang soah boei la ka khueh coeng ne. Te dongah a pacaboeina boeih te a taengah sal la ka paek. Te phoeiah cangpai neh misur thai khaw anih ka pang sak coeng. Te dongah ka ca nang ham balae ka saii bal eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Tedae Esau loh a napa taengah, “a pa na taengkah yoethennah te pakhat khaw ta? Kai khaw yoethen m'pae van saw a pa,” a ti nah. Te vaengah Esau loh a ol te a huel tih rhap. ");
INSERT INTO hlt_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Te dongah a napa Isaak loh anih te a doo tih, “Diklai kah khuehtawn neh vaan dong sosang lamkah buemtui loh namah tolrhum ah om bitni ne. ");
INSERT INTO hlt_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Na cunghang neh na hing vetih na mana taengah na thotat ni. Tedae na van van neh na rhawn dongkah a hnamkun te na bawt bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Tedae a napa kah yoethennah te anih te yoethen a paek dongah Esau loh Jakob taengah a konaeh. Te dongah Esau loh a lungbuei khuiah,” A pa kah nguekcoinah tue yoei, ka mana Jakob te ka ngawn ni,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Tedae a capa a ham Esau kah olka te Rebekah taengah a puen pah. Te dongah a capa a noe Jakob te a tah tih a khue sak. Te phoeiah amah taengah, “Na maya Esau loh nang ngawn daengah ni nang ham dam a ti eh ne. ");
INSERT INTO hlt_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Te dongah ka ca, kai ol he ngai laeh. Thoo lamtah Haran ah ka nganpa Laban taengla namah yong laeh. ");
INSERT INTO hlt_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Na maya kah kosi a mael hil hnin at khaw anih taengla khosa mai. ");
INSERT INTO hlt_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Na maya loh nang taengkah thintoek te mael tih anih taengah na saii te a hnilh phoeiah kan tah vetih te lamkah nang kan loh bitni. Balae tih nangmih rhoi khaw hnin at ah kan hlong eh?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Te dongah Rebekah loh Isaak taengah, “Kheth nu mikhmuh ah ka hingnah loh a mueipuel. Amih Kheth nu bang tolrhum kah huta te Jakob loh a yuu la lo koinih kai kah hingnah he metlam a om eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Te dongah Isaak loh Jakob te a khue phoeiah yoethen a paek tih a uen vaengah, “Kanaan nu te na yuu la lo boeh. ");
INSERT INTO hlt_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Thoo, Padanaram kah na nu kah a napa Bethuel im la cet lamtah na nupu Laban canu te na yuu la lo. ");
INSERT INTO hlt_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Pathen Tlungthang loh nang te yoethen m'paek vetih na pungtai uh phoeiah na ping uh vaengah pilnam hlangping la na om bitni. ");
INSERT INTO hlt_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Tedae Pathen loh Abraham taengah a paek tangtae Abraham kah yoethennah, na lampahnah kho he nang neh na tiingan loh na pang ham m'pae saeh” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Te phoeiah Isaak loh Jakob te a tueih tih Jakob neh Esau kah a manu Rebekah kah nganpa Laban, Paddanaram Arammi Bethuel capa taengla cet. ");
INSERT INTO hlt_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Tedae Isaak loh Jakob yoethen a paek tih a yuu aka lo ham Paddanaram la a tueih te khaw, Jakob te yoethen a paek vaengah Kanaan nu te na yuu la lo boeh a ti nah tih a uen te khaw Esau loh a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Jakob long khaw a napa neh a manu ol a ngai tih Paddanaram la cet. ");
INSERT INTO hlt_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau long khaw a napa Isaak kah mik ah Kanaan nu te thae tila a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Te dongah Esau loh Ishmael taengla cet tih a yuu rhoek hmanah Abraham capa Ishmael canu Mahalath, Nebaioth ngannu te a yuu la a loh. ");
INSERT INTO hlt_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Te vaengah Jakob loh Beersheba lamloh cet tih Haran la pawk. ");
INSERT INTO hlt_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Tedae hmuen pakhat te a pha vaengah khomik vik tla tih pahoi rhaeh. Te vaengah te hmuen kah lungto a loh tih a lu a tloeng. Te phoeiah tekah hmuen ah yalh. ");
INSERT INTO hlt_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Te vaengah mang a man hatah diklai ah kuihlak tarha doh uh tih a soi loh vaan duela a pha. A soah Pathen kah puencawn rhoek te tarha luei uh tih suntla uh. ");
INSERT INTO hlt_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Te vaengah anih taengah BOEIPA te lawt pai tih, “Kai na pa Abraham kah BOEIPA Pathen neh Isaak kah Pathen loh na yalh nah diklai he nang neh nang kah tiingan taengah kan paek ni. ");
INSERT INTO hlt_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nang kah tiingan tah diklai laipi bangla om vetih khothoeng tuitunli neh tuithim tlangpuei la na pungtai uh phoeiah nang neh nang tiingan rhang neh diklai huiko boeih loh a yoethen uh ni. ");
INSERT INTO hlt_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Kai he nang taengah ka om tih na caeh nah boeih ah nang kan ngaithuen. Te dongah nang te he khohmuen la kam mael puei bitni. Nang taengah ka thui te ka saii hlan vaengah nang kan hnoo mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Te dongah Jakob loh a ih lamkah a haenghang vaengah, “Hekah hmuen ah BOEIPA loh rhep om dae kai loh ka ming pawh “a ti. ");
INSERT INTO hlt_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Tedae a rhih tih, “Hekah hmuen he rhih ham om tih Pathen kah im neh vaan vongka pawt atah a tloe moenih he “a ti. ");
INSERT INTO hlt_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jakob loh mincang a thoh vaengah a lu kah a khueh lungto te a loh tih kaam a ling phoeiah a so ah situi a bueih. ");
INSERT INTO hlt_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Te dongah tekah khopuei ming te lamhma ah Luz la om dae hatah tekah hmuen ming te Bethel la a khue. ");
INSERT INTO hlt_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Te phoeiah Jakob loh olcaeng neh a caeng tih, “Pathen loh kai taengah om tih he longpuei ah ka caeh vanbangla, kai n'dawndah phoeiah caak ham buh neh bai ham himbai te kai m'paek bal tih, ");
INSERT INTO hlt_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","a pa im ah sading la ka bal atah BOEIPA te kai kah Pathen la om ni. ");
INSERT INTO hlt_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Te phoeiah hekah lungto kaam la ka ling he Pathen kah im la poeh vetih kai nan paek boeih te namah ham parha pakhat la kan paek ni,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Te phoeiah Jakob loh a kho a kan tih khothoeng ca rhoek kah khohmuen la cet. ");
INSERT INTO hlt_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Te vaengah a sawt hatah lohma kah tuito khaw, tekah tuito lamkah tui te tuping a tul dongah tuping loh a kaep ah pathum la a kol uh khaw, tuito kah a rhai kah lungrhang te khaw lawt a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Te la tuping boeih a tingtun vaengah tuito rhai kah lungto te a paluet uh tih boiva te a tul uh. Te phoeiah lungto te tuito kah a rhai ah amah hmuen la a khueh uh. ");
INSERT INTO hlt_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Te dongah Jakob loh amih te, “Ka manuca rhoek nangmih he me lamkah rhoek lae,” a ti nah hatah, “Kaimih he Haran lamkah ni,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Te phoeiah amih te, “Nakhaw capa Laban te na ming uh a? a ti nah hatah, “Ka ming uh ta,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Te dongah Jakob loh amih taengah, “Anih te a sading ngawn a? a ti nah hatah, “A sading tih a canu Rakhel khaw boiva neh halo ke,” a ti na uh. ");
INSERT INTO hlt_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Te vaengah, “Kho muep om pueng ta he, boiva a tingtun tue moenih. Boiva te tuitul, te phoeiah hlah lamtah luem sak,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Tedae amih loh, “Tuping rhoek boeih tingtun tih tuito rhai lamkah lungto te ka paluet uh daengah ni boiva khaw tui ka tul uh. Ka paluet thai uh pawt atah ka tul uh thai pawh,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Amih te a voek li vaengah Rakhel loh a napa kah tu dawn ham tu neh ha puei uh. ");
INSERT INTO hlt_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tedae Jakob loh a nupu Laban canu Rakhel te khaw, a nupu Laban kah boiva te khaw a hmuh vanbangla Jakob te thoeih tih tuito rhai lamkah lungto te a paluet. Te phoeiah a nupu Laban kah boiva te tui a tul pah. ");
INSERT INTO hlt_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Te phoeiah Jakob loh Rakhel te a mok dae a ol a huel tih rhap. ");
INSERT INTO hlt_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Tedae Jakob loh Rakhel taengah amah te a napa kah huiko neh Rebekah capa ni tila a puen dongah Rakhel te yong tih a napa taengah puen. ");
INSERT INTO hlt_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban long khaw a ngannu capa Jakob kah olthang te a yaak van neh anih doe ham yong tih a kop phoeiah a mok tih amah im la a khuen vaengah hekah olka boeih te Laban taengah a tae pah. ");
INSERT INTO hlt_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Te dongah Laban loh Jakob taengah, “Nang tah kamah rhuh neh saa pai ni,” a ti nah. Tedae anih taengah a khohnin hla la puet kho a sak. ");
INSERT INTO hlt_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Te vaengah Laban loh Jakob taengah, “Nang he kamah huiko la na om dongah a hoeihae lam a kai taengah na thohtat eh? Kai taengah na thapang te thui,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Te vaengkah Laban canu rhoi tah, a ham ming te Leah tih, a noe ming te Rakhel la om. ");
INSERT INTO hlt_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Te vaengah Leah kah a mik te mongkawt dae Rakhel tah a suisak sakthen neh mueimae sakthen la om. ");
INSERT INTO hlt_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Tedae Jakob loh Rakhel te a lungnah dongah, “Na canu a noe Rakhel ham nang taengah kum rhih ka tho ka tat ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Te dongah Laban loh, “Hlang tloe te ka paek lakah nang taengah anih kan paek te then ngai tih kamah taengah khosa mai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Te vaengah Jakob loh Rakhel ham kum rhih thotat dae anih te a lungnah dongah a mik ah hnin at bangla om. ");
INSERT INTO hlt_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Te phoeiah Jakob loh Laban te, “Ka khohnin khaw cup coeng tih ka yuu te m'pae lamtah anih taengah ka yalh pawn ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Te dongah Laban loh te hmuen kah hlang boeih te a coi tih buhkoknah a saii. ");
INSERT INTO hlt_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tedae hlaem a pha vaengah tah a canu Leah te a khuen tih a paek dongah anih taengah Jakob yalh. ");
INSERT INTO hlt_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Te phoeiah Laban loh a canu Leah taengah amah kah taengom Zilpah te taengom la a paek. ");
INSERT INTO hlt_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Tedae mincang ah tah Leah te tarha a om pah. Te dongah Laban te, “Kai taengah balae na saii he? Rakhel ham nang taengah ka thoh ka tat moenih a? Tedae balae tih kai nan phok,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Te vaengah Laban loh, “Kaimih kho ah caming hlanah a noe a paek ham te a saii noek moenih. ");
INSERT INTO hlt_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tahae yalh he a boeih phoeiah kai ham kum rhih koep na thohtat atah tekah thohtatnah yuengla anih te nang taengah kan paek bal ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Te dongah Jakob loh a saii van tih tekah yalh a boeih phoeiah a canu Rakhel te anih yuu la amah taengah a paek. ");
INSERT INTO hlt_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Te phoeiah Laban loh a canu Rakhel taengah amah kah taengom Bilhah te taengom la a paek. ");
INSERT INTO hlt_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Te vaengah Rakhel taengah a yalh bal hatah Rakhel te Leah lakah a lungnah ngai dongah anih ham kum rhih koep thotat. ");
INSERT INTO hlt_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Leah te a hnoel te BOEIPA loh a hmuh dongah a bung tah a ong. Tedae Rakhel te a yaa sak. ");
INSERT INTO hlt_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Te dongah Leah te pumrhih tih capa a cun hatah, “BOEIPA loh kai kah phacipphabaem te a hmuh tih ka va loh kai n'lungnah taktak pawn ni,” a ti. Te dongah a ming te Reuben a sui. ");
INSERT INTO hlt_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Te phoeiah koep pumrhih tih capa a cun hatah, “Kai n'hnoel te BOEIPA loh a yaak dongah he khaw kai m'paek,” a ti. Te dongah anih ming te Simeon a sui. ");
INSERT INTO hlt_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Te phoeiah koep pumrhih tih capa a cun hatah, “Anih ham capa voei thum ka cun pah dongah ka va loh kai taengah naep pawn ni,” a ti. Te dongah anih ming te Levi a sui. ");
INSERT INTO hlt_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Te phoeiah koep pumrhih tih capa a cun hatah, “BOEIPA te voei vai khaw ka uem eh?,” a ti. Te dongah anih ming te Judah a sui. Te phoeiah a ca cun te duem. ");
INSERT INTO hlt_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Tedae Rakhel loh Jakob ham ca cun pawh tila a hmuh vaengah Rakhel te a maya taengah thatlai. Te dongah Jakob la, “Kai he capa m'pae lah, te pawt koinih ka duek ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Te dongah Jakob kah a thintoek te Rakhel taengah sai tih, “Kai he nang bung kah a thaih aka hloh Pathen yueng la ka om a?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Tedae, “Ka taengom Bilhah taengah kun mai saw he. Te daengah ni ka khuklu ah ca han sak vetih anih lamloh kai khaw ka thoh eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Te dongah a taengom Bilhah te a yuu la a paek tih Jakob loh anih taengah ip. ");
INSERT INTO hlt_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah khaw pumrhih tih Jakob ham ca a cun pah. ");
INSERT INTO hlt_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Te vaengah Rakhel loh, “Pathen loh kai n'yan cakhaw ka ol te a yaak bal tih kai he ca tongpa m'paek coeng,” a ti. Te dongah anih ming te Dan a sui. ");
INSERT INTO hlt_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Te phoeiah koep pumrhih tih Rakhel kah taengom Bilhah loh Jakob ham capa pabae te a cun pah. ");
INSERT INTO hlt_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Te vaengah Rakhel loh, “Pathen kah rhaknah dongah ka maya te ka hnueih tih ka na coeng,” a ti. Te dongah anih ming te Naphtali a sui. ");
INSERT INTO hlt_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Tedae Leah loh ca cun ham bawt coeng tila a hmuh dongah a taengom Zilpah te a khuen tih Jakob taengah a yuu la a paek. ");
INSERT INTO hlt_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Te dongah Leah kah taengom Zilpah loh Jakob ham capa a cun pah. ");
INSERT INTO hlt_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Te vaengah Leah loh, “Yoekam loh a loh,” a ti dongah anih ming te Gad a sui. ");
INSERT INTO hlt_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Te phoeiah Leah kah taengom Zilpah loh Jakob ham capa pabae a cun pah hatah, ");
INSERT INTO hlt_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah loh, “Kai bahoeng ka omngaih, te dongah tanu rhoek loh kai he n'uem uh ni,” a ti tih anih ming te Asher a sak. ");
INSERT INTO hlt_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Cang ah tue vaengah Reuben te a caeh hantah lohma ah hloih a hmuh tih a manu Leah taengla a khuen. Te vaengah Rakhel loh Leah taengah, “Na capa kah hloih te kai hamla khueh mai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Tedae Leah loh anih la, “Ka va te nan rhawt tih rhoeh dae ka ca kah hloih te khaw na lo a ya? a ti nah hatah Rakhel loh, “Then, na capa kah hloih yueng la khoyin ah nang taengla yalh saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Te dongah pong lamkah Jakob halo hlaem ah anih aka doe la Leah te cet tih, “Ka capa kah hloih neh nang a paang la kan paang coeng dongah kai taengah na ip ni,” a ti nah. Te dongah tekah khoyin ah anih taengla yalh. ");
INSERT INTO hlt_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Tedae Pathen loh Leah te a yaak dongah pumrhih tih Jakob ham a panga nah capa a cun pah. ");
INSERT INTO hlt_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Te vaengah Leah loh, “Ka va taengah kamah taengom ka paek dongah kai khaw Pathen loh thapang m'paek,” a ti tih anih ming te Issakhar a sui. ");
INSERT INTO hlt_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Te phoeiah Leah te koep pumrhih tih Jakob ham parhuk nah capa a cun. ");
INSERT INTO hlt_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Te vaengah Leah loh, “Pathen loh kai he kutdoe then koep m'paek tih anih ham capa parhuk ka cun pah. Te dongah ka va loh kai n'hmaiben pawn ni,” a ti tih a ming te Zebulun a sui. ");
INSERT INTO hlt_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Te phoeiah a hnuk la canu a cun tih a ming te Dinah a sui. ");
INSERT INTO hlt_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Tedae Pathen loh Rakhel te a poek. Te dongah Pathen loh anih ol te a hnatun tih a bung te a ong pah. ");
INSERT INTO hlt_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Te dongah pumrhih tih capa a cun hatah, “Kai kah kokhahnah he Pathen loh a coi sak,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","“BOEIPA loh kai ham capa a tloe han thap saeh,” a ti tih anih ming te Joseph a sui. ");
INSERT INTO hlt_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Tedae Rakhel loh Joseph a sak phoeiah tah Jakob loh Laban taengah, “Kai he kamah hmuen la, kamah khohmuen ah pongpa ham n'tueih laeh. ");
INSERT INTO hlt_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ka yuu rhoek neh ka ca rhoek te m'pae. Amih ham nang taengah ka thotat tih ka thohtatnah khaw nang ham ni ka thohtat tila na ming coeng dongah ka cet pawn ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Tedae anih te Laban loh, “Nang kong ah BOEIPA loh ka yoe han then sak tila ka hmuhming. Nang mikhmuh ah mikdaithen la ka om atah bet om mai dae,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Te phoeiah, “Kai taengkah na thapang te mingpha sak lamtah kan paek bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Te dongah Jakob loh Laban te, “Nang taengah ka thohtat te khaw, na boiva loh kai taengah a om te khaw na ming. ");
INSERT INTO hlt_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ka mikhmuh ah nang kah a yol ni a om dae a cungkuem te pungtai coeng. Te dongah BOEIPA loh nang te ka kho kung ah yoethen m'paek. Tedae me vaengah lae kai loh ka imkhui ham khaw ka saii coeng?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Te vaengah, “Nang te balae kan paek eh?,” a ti nah. Jakob loh, “Kai he pakhat khaw m'pae boeh, he ol he kai hamla nan khueh atah, ka mael neh na boiva te ka luem puei vetih ka dawn mai bitni. ");
INSERT INTO hlt_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Tihnin ah nang kah boiva boeih taengla ka cet eh. Te lamkah tu boeih te rhikrhak neh a tairhi khaw, tuca khuikah tu pol boeih khaw, maae khuiah a tairhi neh rhikrhak khaw ka khoe saeh lamtah ka thapang la om saeh. ");
INSERT INTO hlt_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Na mikhmuh ah maae khui lamkah a rhikrhak neh a tairhi pawt boeih, tu khui lamkah a pol pawt te ka taengla a huen khaw, thangvuen khohnin kah ka thapang dongah na pai vaengah, kai yueng la ka duengnah thui nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Te dongah Laban loh, “Namah olka bangla a om saeh ne,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Te dongah amah khohnin ah maaetal a rhangcam neh a tairhi te khaw, maae nu rhikrhak neh a tairhi boeih te khaw, a soah aka bok boeih neh tuca khuikah aka pol boeih te a khoe tih a capa kut ah a tloeng pah. ");
INSERT INTO hlt_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Te phoeiah hnin thum longcaeh te amah neh Jakob laklo ah hnalak a khueh. Te daengah Jakob loh Laban kah boiva la aka sueng rhoek te a luem sak. ");
INSERT INTO hlt_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Tedae Jakob loh amah ham khabok neh yungkha neh hlimbok kah a hlaeng te thingsup la a loh. Te phoeiah a dakda aka bok te a hlih tih cungkui dongah a bok la a tai. ");
INSERT INTO hlt_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Te phoeiah thing hlaeng a baeh te tuilong ah khaw, tuisoi tui taengah khaw, tui ok hamla boiva a kun nah ah khaw, boiva hmai ah khaw a khueh pah. Te dongah tui o la a caeh uh vaengah a pacu uh. ");
INSERT INTO hlt_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Boiva te cungkui taengah a pacu tih boiva khaw a rhangcam, rhikrhak la thang tih a tairhi pah. ");
INSERT INTO hlt_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Te vaengah Jakob loh tuca rhoek te a hoep tih Laban kah boiva khuikah a rhangcam neh aka pol boeih taengla boiva kah a hmai a khueh. Te phoeiah amah loh amah kah tuping te amah la hloep a khueh. Tedae te rhoek te Laban kah boiva taengah khueh pawh. ");
INSERT INTO hlt_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Te phoeiah om tih boiva loh a pa a cuk takuem vaengah a tanglue te tah cungkui taengah a pa a cuk sak ham Jakob loh cungkui te tuilong kah boiva hmuh ah a khueh. ");
INSERT INTO hlt_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tedae boiva te a rhae ngai atah a khueh pah pawt dongah a rhae rhoek te Laban ham om tih a tanglue te Jakob ham vik om. ");
INSERT INTO hlt_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Te dongah tekah hlang tah lut lut boei tih anih taengah boiva khaw, taengom neh sal khaw, kalauk neh laak khaw muep om. ");
INSERT INTO hlt_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Tedae Laban ca rhoek kah olka la, “Jakob loh a pa koe te boeih a loh dongah hekah thangpomnah boeih he khaw a pa koe ni hlawp a bawn,” a ti uh te a yaak. ");
INSERT INTO hlt_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Te phoeiah Laban kah maelhmai te Jakob loh a hmuh vaengah hlaem hlaemvai kah bangla anih taengah om pawh. ");
INSERT INTO hlt_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Tedae BOEIPA loh Jakob te, “Na pa rhoek kah khohmuen neh na pacaboeina taengla bal ngawn lamtah nang taengah ka om bit ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Te dongah Jakob loh Rakhel neh Leah te a tah tih kohong kah a boiva te a khue. ");
INSERT INTO hlt_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Te phoeiah amih te, “Na pa maelhmai te ka hmuh vaengah, hlaem hlaemvai vaengkah bangla kai taengah anih om pawt cakhaw a pa kah Pathen loh kai taengah om. ");
INSERT INTO hlt_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Tahae ah ka thadueng boeih neh na pa taengah ka thohtat te na ming uh. ");
INSERT INTO hlt_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Na pa khaw kai taengah omsaa tih ka thapang te voei rha la a hoilae. Tedae kai he thae sak ham tah Pathen loh anih a paek moenih. ");
INSERT INTO hlt_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Rhikrhak te nang kah thapang la om saeh a ti van hatah boiva te khaw rhikrhak la boeih thang tih a rhangcam te nang kah thapang la om saeh a ti van hatah boiva te a rhangcam la boeih thang. ");
INSERT INTO hlt_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Tedae na pa kah boiva te Pathen long ni a lat tih kai taengah m'paek. ");
INSERT INTO hlt_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Boiva te a pa a cuk tue a pha coeng tih ka mik te ka huel. Mueimang ah ka hmuh tih kikong loh a caeh thil boiva tah rhangcam, rhikrhak neh dikdek la om he. ");
INSERT INTO hlt_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Te phoeiah Pathen kah puencawn loh kai te ka mang ah, 'Jakob,” a ti tih, “Kai ni he,” ka ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Te dongah, “Na mik huel lamtah tahae kah boiva a rhangcam, rhikrhak neh dikdek taengah aka cu kikong rhoek boeih ke so lah. Laban loh nang taengah a saii boeih te ka hmuh coeng. ");
INSERT INTO hlt_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Kai tah kaam te na koelh tih kai taengah olcaeng neh na caeng vaengkah te Bethel Pathen ni. Hekah khohmuen lamloh thoo laeh, cet lamtah na pacaboeina kah khohmuen la mael laeh,’ a ti,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Te dongah Rakhel neh Leah loh a doo vaengah, “A pa im kah hamsum neh rho te mamih ham om voel a? ");
INSERT INTO hlt_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Anih loh kholong hlang la m'poek uh dongah mamih he n'yoih phoeiah mamih kah tangka te a caak khaw a caak moenih a? ");
INSERT INTO hlt_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Hmantang ah Pathen loh a pa taengkah a lat khuehtawn boeih te mah koe neh n'ca rhoek kah ni. Te dongah Pathen loh nang taengah a thui boeih te tah saii laeh,” a ti rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Te dongah Jakob loh thoo tih a ca rhoek neh a yuu rhoek te kalauk rhoek dongla a ngol sak. ");
INSERT INTO hlt_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Te phoeiah a napa Isaak kah khohmuen Kanaan la caeh ham a boiva neh a kawn a dang boeih te khaw, Paddanaram ah a dang amah kah hnopai, boiva te khaw baat a thawn. ");
INSERT INTO hlt_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Tedae Laban loh amah kah tu te a mul vok pah ham a caeh vaengah Rakhel loh a napa kah sithui te a huen. ");
INSERT INTO hlt_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Anih a yong te a puen mueh la Jakob loh Arammi Laban kah lungbuei te a namnah. ");
INSERT INTO hlt_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Anih a yong dongah a taengkah boeih te khaw a thoh puei tih, tuiva a poeng phoeikah Gilead tlang dan la a hooi puei. ");
INSERT INTO hlt_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Tedae Jakob a yong te a hnin thum daengah Laban taengah a puen pah. ");
INSERT INTO hlt_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Te dongah Laban loh amah manuca rhoek te a khuen tih hnin rhih longcaeh due anih hnuk te a hloem phoeiah Jakob te Gilead tlang ah a tuuk. ");
INSERT INTO hlt_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Tedae Arammi hoel Laban te Khoyin a mang ah Pathen loh a paan tih, “Namah te ngaithuen, Jakob taengah a then khaw a thae la na thui ve,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Tedae Laban loh Jakob a tuuk vaengah Jakob loh amah kah dap te tlang ah a tuk coeng dongah Laban neh a manuca rhoek long khaw Gilead tlang ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Te vaengah Laban loh Jakob la, “Balae na saii he. Ka thinko he na liim tih ka tanu rhoek te cunghang kah a sol bangla na hmaithawn. ");
INSERT INTO hlt_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Yong ham te balae tih na phah, kai taengah na puen mueh la kai nan liim. Nang te kohoenah neh, laa neh, kamrhing neh, rhotoeng nen khaw kan tueih van mako. ");
INSERT INTO hlt_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ka ca rhoek so neh ka canu rhoek soah te mok ham kai nan paek pawt khaw na pavai coeng tih ni na saii. ");
INSERT INTO hlt_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nangmih te a thae la saii ham ka thaa om ngawn dae hlaem yin ah na pa kah Pathen loh kai m'voek tih, 'Jakob te a thae neh a then khaw thui te namah ngaithuen,’ a ti. ");
INSERT INTO hlt_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Tedae na pa im te ngaidam la na ngaidam coeng dongah na cet khaw na cet mai ni. Balae tih kai kah pathen na huen,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Tedae Jakob loh a doo tih Laban te, “Na canu rhoek he kai taeng lamloh na doek ve ka ti tih ka rhih dongah ni. ");
INSERT INTO hlt_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","A taengah na khohni na hmuh te tah kaimih kah pacaboeina hmaiah hing boel saeh. Kai taengkah he namah loh hmat lamtah namah kah atah lo,” a ti nah. Tedae Rakhel loh a huen te Jakob loh ming pawh. ");
INSERT INTO hlt_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Te dongah Laban loh Jakob kah dap khaw, Leah kah dap neh taengom rhoi kah dap khuila cet dae a hmuh pawt dongah Leah kah dap lamkah halo tih Rakhel kah dap khuila kun. ");
INSERT INTO hlt_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Tedae Rakhel loh sithui te a loh tih kalauk kah ngoldoelh khuiah a khueh tih a ngol thil dongah dap te Laban loh boeih a phatuem dae hmu pawh. ");
INSERT INTO hlt_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Te vaengah Rakhel loh a napa taengah, “Ka boeipa mik ah sai boel mai. Kai taengah huta kah khosing om tih nang hmuh ah thoh ham ka coeng moenih,” a ti nah. Te dongah a sat akhaw sithui te hmu pawh. ");
INSERT INTO hlt_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Tedae Jakob te sai tih Laban te a ho. Te vaengah Jakob loh Laban te a doo tih, “Kai kah mebang dumlai neh mebang tholhnah dongah lae kai hnukah nan hlak. ");
INSERT INTO hlt_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Tahae ah kai kah hnopai boeih te na phatuem tih na im kah hnopai khat khaw na hmuh te kai kah pacaboeina neh nang kah paca boeina hmuh ah n'rha phoeiah man mamih rhoi laklo ah n'tluung uh rhoi sue. ");
INSERT INTO hlt_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Kum kul khuiah he nang taengah ka om coeng dae na tumanu neh na maae rhoek loh thangyah vai pawt tih na boiva khuikah a tal rhoek khaw ka ca vai pawh. ");
INSERT INTO hlt_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Saha te na taengla kan khuen pawh. Khoyin loh a huen khaw, khothaih loh a huen khaw nan suk dongah kai loh kamah kut lamkah neh ka kawn. ");
INSERT INTO hlt_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Khothaih ah kholing loh n'do tih khoyin ah rhaelnu loh m'boh phoeiah ka mik loh ih ham a hlavawt tih ka om. ");
INSERT INTO hlt_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tahae ah kai loh nang im ah kum kul ka om khuiah na canu rhoi ham kum hlai li neh na boiva ham kum rhuk te nang taengah ka tho ka tat dae ka thapang te voei rha la na hoi na lae. ");
INSERT INTO hlt_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","A pa kah Pathen, Abraham kah Pathen neh Isaak kah birhihnah te kai taengah om pawt koinih kuttling la kai nan tueih tarha mai veh. Kai kah phacip phabaem neh ka kut kah a thatloh te Pathen loh a hmuh dongah ni hlaem yin ah a tluung,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban long khaw Jakob te a doo vaengah, “Huta rhoek te kai canu rhoek tih tongpa rhoek te khaw kai ca rhoek ni. Boiva te khaw kai kah boiva tih namah loh na hmuh boeih te kai koe ni. Tedae tihnin ah ka canu rhoek, amih ham neh amih loh a sak camoe rhoek ham balae ka saii thai voel. ");
INSERT INTO hlt_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Te dongah halo laeh! Kai neh nang paipi sai sih lamtah kai laklo nang laklo ah laipai la om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Te dongah Jakob loh lungto a rhuh tih kaam la a ling. ");
INSERT INTO hlt_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Te phoeiah Jakob loh amah kah paca boeina rhoek la, “Lungto rhut uh,” a ti nah. Lungto te a rhuh uh tih lungkuk la a saii uh phoeiah tah lungkuk taengah buh pahoi a caak uh. ");
INSERT INTO hlt_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Te dongah tekah lungkuk te Laban loh Jegarsahdutha a sui tih Jakob loh Galeed la a khue. ");
INSERT INTO hlt_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Te phoeiah Laban loh, “Tihnin ah hekah lungkuk loh kai laklo neh nang laklo ah laipai la om coeng,” a ti dongah a ming te Galeed a sui. ");
INSERT INTO hlt_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Te phoeiah, “Hlang hui taeng lamloh n'thuh vaengah kai laklo neh nang laklo ah BOEIPA loh n'tawt saeh,” a ti dongah Mizpah a sui. ");
INSERT INTO hlt_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ka ca huta rhoek te khoem na phaep tih ka ca rhoek hmanah yuu na loh atah mamih taengah hlang om pawt dae kai neh nang laklo kah laipai tah Pathen ni tila hmu sih. ");
INSERT INTO hlt_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Te phoeiah Laban loh Jakob te, “Lungkuk he khaw kaam he khaw ne, te ni kai laklo neh nang laklo ah kan thuinuet. ");
INSERT INTO hlt_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Boethae ham khaw hekah lungkuk neh kaam he tah kai loh nang taengla hekah lungkuk kan poeng pawt ham neh nang khaw kai taengla na poe pawt ham hekah lungkuk neh kaam he laipai la om saeh. ");
INSERT INTO hlt_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abraham kah Pathen neh Nakhaw kah Pathen, a napa kah Pathen loh mamih laklo ah laitloek uh saeh,” a ti nah. Te phoeiah Jakob loh a napa Isaak kah birhihnah neh a toemngam. ");
INSERT INTO hlt_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Te dongah Jakob loh tlang ah hmueih a nawn phoeiah buh ca la amah huiko te a khue. Buh a caak uh phoeiah tlang ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laban te mincang ah thoo tih a ca rhoek neh a canu rhoek te a mok. Te phoeiah amih te yoethen a paek. Te phoeiah cet tih Laban khaw amah hmuen la mael. ");
INSERT INTO hlt_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Tedae Jakob loh amah longpuei ah a caeh hatah anih te Pathen kah puencawn rhoek a doe uh. ");
INSERT INTO hlt_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Tedae Jakob loh amih te a hmuh vaengah, “Hekah he Pathen kah rhaehhmuen ni,” a ti tih tekah hmuen ming te Mahanaim a sui. ");
INSERT INTO hlt_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Te phoeiah Jakob loh Edom kho, Seir khohmuen la a maya Esau taengah a hmai la puencawn rhoek te a tueih. ");
INSERT INTO hlt_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Te vaengah amih te a uen tih, “Ka boei Esau taengah he he thui pah. Na sal Jakob tah Laban taengah ka bakuep tih tahae duela ka uelh. ");
INSERT INTO hlt_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Te phoeiah kai taengah vaito neh laak boiva khaw, sal neh salnu khaw om. Na mikhmuh ah mikdaithen dang hamla ka boeipa taengah aka puen la kai n'tueih,’ ti nah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Tedae puencawn rhoek te Jakob taengla mael uh tih, “Na maya Esau taengla ka cet uh coeng, te nang te doe ham a taengkah hlang ya li neh halo coeng,” a ti na uh. ");
INSERT INTO hlt_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Te vaengah Jakob loh bahoeng a rhih tih amah te a te daengdaeh uh. Te dongah a taengkah pilnam te khaw, boiva khaw, saelhung khaw, kalauk rhoek khaw rhoi nit la a tael. ");
INSERT INTO hlt_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Te khaw Esau loh rhoi at te a paan tih a ngawn atah rhoi at aka om te khaw rhalyong la om saeh a ti dongah ni. ");
INSERT INTO hlt_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Te phoeiah Jakob loh, “Kai taengah namah khohmuen neh na pacaboeina taengla bal lamtah nang te kan hoeikhang sak ni,” aka ti a pa Abraham kah Pathen neh a pa Isaak kah BOEIPA Pathen, ");
INSERT INTO hlt_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Sitlohnah cungkuem neh uepomnah cungkuem te na salpa taengah nan saii ham tah rhaidaeng. Ka cunghol neh Jordan he ka kat ngawn dae rhoi nit la ka lo coeng. ");
INSERT INTO hlt_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ka maya kut lamloh, Esau kut lamkah kai n'huul mai dae. Anih te ka rhih, halo vetih camoe rhoek neh a manu rhoek khaw, kamah khaw n'ngawn ve. ");
INSERT INTO hlt_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Tedae namah loh, 'Hoeikhang ham khaw nang te kan hoeikhang sak vetih nang kah tiingan te tuitunli kah laivin bangla ka khueh vetih tae thai mahpawh,’ na ti,” tila thangthui. ");
INSERT INTO hlt_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Te dongah teah te khoyin puet rhaeh. A kut ah a khuen te khaw a maya Esau ham khosaa la, ");
INSERT INTO hlt_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Maae a la yahnih neh maaetal pumkul, tumanu yahnih neh tutal pumkul. ");
INSERT INTO hlt_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Kalauk cacun te a ca rhoek hmaihneh thumkip, vaito a la likip neh vaitotal pumrha, laak a la pumkul neh laaktal pumrha,” a paek. ");
INSERT INTO hlt_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Te phoeiah tuping, tuping te amah loh a sal rhoek kut ah a tloeng tih a sal rhoek te,” Kai hmai ah cet lamtah tuping laklo neh tuping laklo te hnalak khueh uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Te phoeiah lamhma taengah, “Ka maya Esau te na hum uh tih, 'Nang ulae? Melam na caeh eh? Na hmaikah rhoek he u kah lae a ti tih n'dawt vaengah, ");
INSERT INTO hlt_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","'Na sal Jakob kah ni. Hekah he ka boeipa Esau taengah khosaa la ham pat tih amah khaw kaimih hnukkah halo ke,’ ti nah,” a ti tih a uen. ");
INSERT INTO hlt_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Te phoeiah a pabae te khaw, a pathum te khaw, tuping hnukah aka cet boeih te khaw, “Nangmih khaw Esau neh na hum uh vaengah hekah olka he thikat la thui uh lamtah, ");
INSERT INTO hlt_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","nang kah sal Jakob khaw kaimih hnukah om ke,’ na ti uh ni,” a ti tih a uen. Ba dongah tikoinih ka mikhmuh kah aka pongpa khosaa neh a hmai ka saak pah vetih, te phoeiah tah a maelhmai ka hmuh vaengah kai maelhmai khaw a hlam khaming a ti. ");
INSERT INTO hlt_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Te dongah khosaa te a hmai la a caeh sak. Tedae amah tah rhaehhmuen ah hlaem at rhaeh pueng. ");
INSERT INTO hlt_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Tedae tekah khoyin ah thoo tih a yuu rhoi neh a salnu rhoi khaw, a ca rhoek hlai at te khaw a loh tih Jabbok lamkai ah a kat puei. ");
INSERT INTO hlt_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Amih te khaw a khuen tih a thak phoeiah amah taengah aka om rhoek te khaw soklong la a tueih. ");
INSERT INTO hlt_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Te vaengah Jakob te amah bueng la a cul coeng dongah anih te hlang pakhat loh khothaih tom due a hnueih. ");
INSERT INTO hlt_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Tedae anih te ka na pawh tila a hmuh vaengah Jakob kah a hlit te a koi pah tih anih te a hnueih pangthuem Jakob kah a hlit te voeng nong. ");
INSERT INTO hlt_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Te vaengah, “Khothaih loh n'kae coeng tih kai n'hlah laeh,” a ti nah hatah Jakob loh, “Kai he yoethen nan paek hlan atah nang khaw kan hlah mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Te dongah amah la, “Nang ming te balae,” a ti nah hatah, “Jakob,” a ti nah dae, ");
INSERT INTO hlt_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","“Na ming te Jakob ti voel boel lamtah Pathen neh hlang rhoek te na hnueih tih na na coeng dongah Israel ti laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Te phoeiah Jakob loh a dawt tih, “Na ming te thui lah,” a ti nah hatah, “Ka ming he ba ham lae nan dawt,” a ti nah tih anih te yoethen pahoi a paek. ");
INSERT INTO hlt_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Te dongah Jakob loh, “Pathen maelhmai te a hmai lamloh hmuh coeng dae ka hinglu huul uh,” a ti dongah tekah hmuen ming te Peniel a sui. ");
INSERT INTO hlt_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Tedae Penuel te a poeng vanneh a soah khomik thoeng. Anih khaw a hlit dongah cungdo phai. ");
INSERT INTO hlt_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Te dongah Israel ca rhoek loh a hlit dongkah tharhui thanal te tihnin due ca uh pawh. Jakob kah tharhui thanal ah aka om a hlit te a koi pah coeng. ");
INSERT INTO hlt_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Te vaengah Jakob loh a mik huel tih a sawt hatah Esau neh a taengkah hlang ya li te tarha a pawk pah. Te dongah camoe rhoek te Leah taengah khaw, Rakhel taengah khaw, a imom rhoi taengah a rhek. ");
INSERT INTO hlt_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Te phoeiah salnu rhoek neh amih kah a ca rhoek a lamhma sak tih Leah neh a rhoek loh a hmaithawn. Rakhel neh Joseph te lamhnuk la a khueh. ");
INSERT INTO hlt_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Te phoeiah amah te amih hmai la cet tih a maya taeng a pha due diklai la voei rhih bakop. ");
INSERT INTO hlt_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tedae anih te doe ham Esau yong tih a rhawn ah a kop uh rhoi, mok uh rhoi tih rhap rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Te vaengah a dan hatah huta rhoek neh camoe rhoek te a hmuh tih, “Nang taengkah rhoek he u rhoek lae?” a ti nah dae, “Pathen loh na sal taengah n'rhen nah camoe rhoek ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Te vaengah a salnu rhoek neh a ca rhoek te thoeih uh tih bakop uh. ");
INSERT INTO hlt_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Te phoeiah Leah neh a ca rhoek khaw thoeih uh tih a bakop uh vaengah Joseph neh Rakhel khaw thoeih tih bakop rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Te dongah Esau loh, “Lambong boeih ka hum he, metlam na om te,” a ti nah. Te dongah, “Ka boeipa mik ah mikdaithen dang ham ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tedae Esau loh, “Ka mana, kamah taengah muep om ta; namah taengkah te namah ham om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakob loh, “Pawh, na mikhmuh ah mikdaithen la ka tueng mai khaming. Na maelhmai he Pathen maelhmai a hmuh bangla kam hmuh. Kai nan moeithen banghui la ka kut lamkah ka khosaa he lo mai. ");
INSERT INTO hlt_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Pathen loh kai n'rhen tih kai ham a cungkuem a khueh dongah kai kah yoethennah nang taengla kang khuen te doe mai,” a ti nah tih amh te a hloep daengah a doe pah. ");
INSERT INTO hlt_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Te phoeiah, “Ceh, cet uh pawn sih lamtah nang hnuk ah ka lo eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Tedae Jakob loh, “Ka boeipa camoe rhoek te mongkawt uh pueng tih ka taengah boiva neh saelhung cacun khaw om tila na ming. Amih te hnin at ah rhenten kam vai koinih boiva loh boeih duek uh ni. ");
INSERT INTO hlt_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ka boeipa te a sal hmai ah ana cet mai saeh. Kai tah ka mikhmuh kah bitat dongkah khokan neh, camoe rhoek kah khokan neh, vawlhvawlh kang khool vetih Seir kah ka boeipa taeng hil ka lo eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Te dongah Esau loh, “Ka pilnam he nang taengah ka khueh mai eh ne,” a ti nah. Tedae, “Balae tih, ka boeipa kah mikhmuh ah mikdaithen ka dang mai mako,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Te dongah Esau khaw amah tekah khohnin ah amah longpuei ah Seir la bal. ");
INSERT INTO hlt_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Tedae Jakob loh Sukkoth la cet tih amah ham im a sak phoeiah a boiva ham pohlip a saii. Te dongah te hmuen ming te Sukkoth la a khue. ");
INSERT INTO hlt_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Te phoeiah Jakob loh Paddanaram lamloh hlah uh. Kanaan diklai Shekhem khopuei te sading la a pha tih khopuei imdan ah rhaeh. ");
INSERT INTO hlt_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Te vaengah a dap tuk hmuen te Shekhem napa Hamor ca rhoek kut lamkah khamyai rhoek te tangka yakhat neh a lai. ");
INSERT INTO hlt_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Te dongah hmueihtuk pahoi a suem tih El Elohim Israel a sui. ");
INSERT INTO hlt_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Leah canu Dinah, Jakob ham a cun pah te tolrhum kah tanu rhoek te sawt hamla cet. ");
INSERT INTO hlt_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Tedae khohmuen kah khoboei Khivee Hamor capa Shekhem loh anih te a hmuh dongah a loh tih a yalh puei phoeiah a tholh puei. ");
INSERT INTO hlt_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Te phoeiah Jakob canu Dinah taengah a hinglu tlun tih hula te a lungnah dongah hula kah lungbuei te doelh a voek. ");
INSERT INTO hlt_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Te dongah Shekhem loh a napa Hamor la, “Hekah hutaca he kai ham ka yuu la han lo,” a ti nah tih a thui pah. ");
INSERT INTO hlt_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","A canu Dinah a poeih pah te Jakob loh a yaak dae kohong ah a ca rhoek neh boiva te a om pueng dongah amih halo uh due Jakob loh hil a phah. ");
INSERT INTO hlt_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Jakob te voekhlak ham Shekhem napa Hamor te cet. ");
INSERT INTO hlt_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jakob ca rhoek khaw pong lamkah a pai uh vaengah a yaak uh. Tongpa tongpa rhoek te a kothae uh tih amih te muep sai uh. Jakob canu taengah a yalh te Israel taengah boethaehalang ni a saii. Tedae he he a saii tueng moenih. ");
INSERT INTO hlt_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Tedae Hamor loh amih taengah, “Ka capa Shekhem loh nang canu soah a hinglu loh a ven oeh tih a yuu la m'pae mai. ");
INSERT INTO hlt_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Te phoeiah nangmih nu te kaimih taengah vasak sak ham kaimih m'pae lamtah namamih ham kaimih nu na loh uh mako. ");
INSERT INTO hlt_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kaimih taengah khosa uh mai. Na mikhmuh ah khohmuen om coeng. Khosa uh lamtah thimpom neh a khuikah te bawn uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Te vaengah Shekhem loh Dinah kah a napa neh a nganpa rhoek taengah, “Nangmih mikhmuh ah mikdaithen ka dang atah kai taengah na kuek uh vanbangla kan paek uh bitni. ");
INSERT INTO hlt_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Kai soah maan neh kutdoe muep na kuek uh akhaw kai taengah na kuek uh te tah kan paek bitni. Tedae hula te ka yuu la kai taengah paek uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tedae a ngannu Dinah te a poeih pah dongah Jakob ca rhoek loh Shekhem neh a napa Hamor te a doo uh vaengah thailatnah neh a voek uh. ");
INSERT INTO hlt_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Amih rhoi te, “Hlang yanghli taengah ka ngannu paek ham hno saii he kaimih ham kokhahnah la om tih coeng pawh. ");
INSERT INTO hlt_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nangmih taengkah tongpa boeih te yahhmui a rhet tih kaimih bangla na om uh atah he nen bueng ni nangmih te kan rhoi uh eh. ");
INSERT INTO hlt_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Te daengah ni kaimih nu rhoek te nangmih kan paek uh phoeiah kamamih ham nangmih nu rhoek te ka loh uh vetih nangmih taengah kho ka sak uh vaengah pilnam pakhat la n'coeng uh eh. ");
INSERT INTO hlt_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tedae yahhmui rhet ham kaimih neh nan rhoi uh pawt atah ka canu he ka loh uh vetih ka bal uh ni,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Te dongah amih kah olka te Hamor mikhmuh ah khaw, Harmor capa Shekhem mikhmuh ah khaw then. ");
INSERT INTO hlt_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tedae cadong loh Jakob canu te a ngaih coeng dongah hno saii ham te uelh pawh. Te dongah anih te a napa imkhui boeih soah a thangpom. ");
INSERT INTO hlt_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Te dongah Hamor neh a capa Shekhem loh amah khopuei vongka la cet tih amah khopuei kah hlang rhoek taengah, ");
INSERT INTO hlt_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Hekah hlang rhoek he mamih neh baerhoep la tolrhum ah khaw khosa uh saeh. Te phoeiah amih kah nongcen rhoeh la khotuk khaw amih ham a dang ka mungkung mai. Mamih kah yuu la amih nu rhoek te lo sih lamtah mah nu te amih pae uh sih. ");
INSERT INTO hlt_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Tedae tongpa boeih loh yahvin a rhet uh vanbangla mamih ah pilnam pakhat la om ham atah ning taengkah aka om tongpa rhoek kah yahhmui a rhet nen bueng he ni mamih te n'rhoi uh eh. ");
INSERT INTO hlt_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Amih kah boiva neh hnopai, rhamsa boeih khaw mamih ham moenih a? Te dongah amih te rhoi uh mai sih lamtah mamih taengah khosa uh saeh,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Te dongah a khopuei kah vongka ah aka cet boeih loh Hamor neh a capa Shekhem te a ngai uh tih tongpa boeih khukah a khopuei vongka aka pha boeih loh yahhmui a rhet uh. ");
INSERT INTO hlt_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tedae hnin thum a lo vaengah amih te a tlohpah . Te dongah Dinah nganpa Simeon neh Levi, Jakob ca rhoi loh cunghang rhirha a muk rhoi tih ngaikhuek la khopuei te a paan rhoi. Te vaengah tongpa boeih te a ngawn rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamor neh a capa Shekhem te cunghang ha neh a ngawn rhoi. Dinah te khaw Shekhem im lamloh a lat rhoi tih bal rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","A ngannu a poeih pa uh dongah Jakob ca rhoek loh rhok te a paan uh tih khopuei te a poelyoe uh. ");
INSERT INTO hlt_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Amih kah boiva neh saelhung khaw, laak khaw, khopuei khui neh lohma kah te a mawt pa uh. ");
INSERT INTO hlt_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Amih kah tatthai boeih neh a yuu, a ca boeih te a sol pa uh tih im kah aka om boeih te khaw a poelyoe uh. ");
INSERT INTO hlt_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Te dongah Jakob loh Simeon neh Levi taengah, “Khohmuen kah kho aka sa Kanaan neh Perizzi rhoek taengah ka bo nan rhim sak rhoi tih kai nan lawn rhoi coeng. Tahae ah kai hlang sii taengah tingtun uh tih kai he n'ngawn uh koinih kamah neh ka imko loh ka mit uh ni ta he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tedae, “Ka ngannu te pumyoi bangla a saii ham om a?” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Tedae Pathen loh Jakob la, “Thoo, Bethel la cet lamtah pahoi khosa. Te phoeiah na maya Esau mikhmuh lamkah na yong vaengah nang taengah aka phoe Pathen ham hmueihtuk khaw pahoi saii,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Te dongah Jakob loh amah imkhuikho neh a taengkah aka om boeih taengah, “Nangmih lakli kah kholong pathen rhoek te voei uh. Te phoeiah caihcil uh lamtah na himbai te tho uh laeh. ");
INSERT INTO hlt_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Thoo uh sih lamtah Bethel la cet uh sih. Ka citcai tue vaengah kai aka doo tih ka caeh long ah kai taengah aka om Pathen ham hmueihtuk pahoi ka saii ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Te dongah amih kut kah kholong pathen rhoek boeih neh a hna dongkah hnaii te Jakob taengah a paek uh tih Jakob loh Shekhem taengkah rhokael hmuiah a up. ");
INSERT INTO hlt_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Tedae a caeh uh neh Pathen kah mueirhih loh khopuei kaepvai ah yaal tih Jakob ca te hloem uh pawh. ");
INSERT INTO hlt_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Te phoeiah Jakob neh amah taengkah a pilnam boeih loh Kanaan kho kah Luz Bethel te a pha uh. ");
INSERT INTO hlt_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Te vaengah hmueihtuk pahoi a suem tih a hmuen te El Bethel a sui. A maya mikhmuh lamloh a yong vaengah khaw te rhoek ah ni anih ham Pathen a phoe pah dongah ni. ");
INSERT INTO hlt_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Rebekah kah cakhoem Deborah a duek vaengah khaw Bethel kungdak kah thingnu hmuiah a up tih a ming te Allon Bakuth la a khue. ");
INSERT INTO hlt_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Paddanaram lamkah koep a mael vaengah khaw Jakob taengah Pathen a phoe pah tih yoethen a paek. ");
INSERT INTO hlt_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Te vaengah Pathen loh anih te, “Na ming he Jakob dae na ming te Jakob la n'khue voel pawt vetih Israel ni nang ming la aka om eh?,” a ti nah. Te dongah a ming te Israel la a khue bal. ");
INSERT INTO hlt_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Te phoeiah anih te Pathen loh, “Kai he Pathen Tlungthang ni. Pungtai lamtah namtom ah ping uh. Namtom hlangping khaw nang lamkah ha thoeng vetih na pumpu lamloh manghai thoeng uh ni. ");
INSERT INTO hlt_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Abraham neh Isaak taengah ka paek hmuen te nang taengah kan paek vetih nang phoeikah na tiingan taengah khaw khohmuen te ka paek ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Tekah hmuen ah Jakob neh a cal rhoi pangthuem Pathen te anih taeng lamloh vik cet. ");
INSERT INTO hlt_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Te dongah amah neh a voek nah hmuen ah Jakob loh kaam a ling tih kaam lung te tuisi a suep tih situi a bueih. ");
INSERT INTO hlt_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Te phoeiah Pathen loh amah a voek nah hmuen ming te Jakob loh Bethel la pahoi a khue. ");
INSERT INTO hlt_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Te phoeiah Bethel lamkah puen uh tih Epharath la caeh ham kho te a lak om pueng dae Rakhel te camoe om tih a ca om bahoeng kuel. ");
INSERT INTO hlt_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Tedae a ca om a a tloh vaengah anih te ca aka om sak loh, “Tahae kah khaw nang ham tongpa la koep a om dongah rhih boeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","A duek tom kah a hinglu a pat thuk vaengah camoe ming te Benoni la a khue. Tedae a napa long tah anih te Benjamin la a khue. ");
INSERT INTO hlt_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Te vaengah Rakhel duek tih Epharath Bethlehem long ah te a up. ");
INSERT INTO hlt_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Rakhel kah hlan soah Jakob loh kaam a ling te tihnin due Rakhel phuel kah kaam la om. ");
INSERT INTO hlt_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Te phoeiah Israel te cet tih Mikdaleder kah a voel ah dap a tuk. ");
INSERT INTO hlt_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Tedae tekah kho ah khosa la Israel a om vaengah Reuben te cet tih a napa kah yula Bilhah taengah a yalh te Israel loh a yaak. Te vaengah Jakob ca rhoek hlang hlai nit om uh. ");
INSERT INTO hlt_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leah ca rhoek ah Reuben te Jakob caming la om tih Simeon, Levi, Judah, Issakhar neh Zebulun om uh. ");
INSERT INTO hlt_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rakhel ca rhoi la Joseph neh Benjamin om. ");
INSERT INTO hlt_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rakhel imom Bilhah ca rhoi la Dan neh Naphtali om. ");
INSERT INTO hlt_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leah salnu Zilpah ca la Gad neh Asher he om tih Paddanaram ah Jakob ca tongpa la a cun pah. ");
INSERT INTO hlt_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Te phoeiah Jakob loh Mamre Kiriatharba Hebron kah a napa Isaak taengla a pha. Teah te Abraham khaw Isaak khaw bakuep. ");
INSERT INTO hlt_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Te vaengah Isaak kah khohnin loh kum ya neh kum sawmrhet lo coeng. ");
INSERT INTO hlt_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaak khaw pal tih a duek vaengah patong kum soep la a pilnam taengah khoem uh coeng. Anih te a ca rhoi Esau neh Jakob loh a up. ");
INSERT INTO hlt_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Tahae kah he Esau Edom te kah rhuirhong rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau loh Kanaan nu khuikah, Khitti Elon canu Adah neh Khivee hoel Zibeon kah a ca Anah canu Oholibamah, ");
INSERT INTO hlt_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ishmael nu Basemath, Nebaioth ngannu te a yuu la a loh. ");
INSERT INTO hlt_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Te vaengah Esau ham Adah loh Eliphaz a sak pah tih Basemath loh Reuel te a sak. ");
INSERT INTO hlt_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamah long khaw Jeush, Jalam, neh Korah te a sak. Amih he tah Kanaan kho ah a cun Esau ca rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Te phoeiah Esau loh a yuu rhoek khaw, a ca tongpa rhoek khaw, a ca huta rhoek khaw, a im kah hinglu boeih neh boiva khaw, rhamsa boeih khaw, Kanaan kho ah a dang hnopai boeih khaw a khuen tih a mana Jakob mikhmuh lamloh kho tloe la cet. ");
INSERT INTO hlt_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Amih kah khuehtawn aka om te a yet hang atah tun khosak ham khaw, a lampahnah khohmuen loh amih kah boiva hman ah amih te khuut ham a noeng moenih. ");
INSERT INTO hlt_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Te dongah Esau loh Seir tlang ah kho a sak. Esau te tah Edom ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Tahae kah rhoek he Seir tlang kah Edom napa Esau kah rhuirhong rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau ca rhoek kah a ming he, a yuu Adah capa te Eliphaz, a yuu Basemath capa te Reuel tih, ");
INSERT INTO hlt_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Eliphaz ca rhoek la Teman, Omar, Zepho, Gatam neh Kenaz tila om uh. ");
INSERT INTO hlt_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna khaw Esau capa Eliphaz kah a yula la om tih Eliphaz ham Amalek a sak pah. Amih te Esau yuu Adah koca rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Te phoeiah Reuel ca rhoek he Nahath, Zerah, Shammah, Mizzah om tih, amih he Esau yuu Basemath ko la om uh. ");
INSERT INTO hlt_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau yuu, Zibeon nu Anah canu Oholibamah ca rhoek he khaw om uh tih, Esau ham Jeush, Jalam, Korah a sak pah. ");
INSERT INTO hlt_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esau cadil khuikah khoboei rhoek he tah, Esau caming Eliphaz koca ah khoboei Teman, khoboei Omar, khoboei Zepho, khoboei Kenaz, ");
INSERT INTO hlt_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","khoboei Korah, khoboei Gatam, khoboei Amalek om tih amih te tah Edom kho kah Eliphaz khoboei, Adah ko rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau capa Reuel koca rhoek he khaw, khoboei Nahath, khoboei Zerah, khoboei Shammah, khoboei Mizzah om tih amih he Edom kho kah Esau yuu Basemath ko Reuel khoboei rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau yuu Oholibamah kah ca rhoek khaw khoboei Jeush, khoboei Jalam, khoboei Korah om tih amih he Esau yuu, Anah nu, Oholibamah ko kah khoboei rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","He rhoek he tah Esau Edom ca rhoek neh amamih kah khoboei rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Hekah rhoek he tah Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO hlt_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, Dishan paengpang kah kho aka sa Khori hoel Seir ca rhoek tih Edom kho kah Seir koca, Khori khoboei rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan ca rhoi khaw Khori neh Hemam om tih Timna he Lotan ngannu ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobal ca rhoek he khaw Alvan, Manahath, Ebal, Shepho, Onam om. ");
INSERT INTO hlt_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon ca rhoek khaw Aiah neh Anah om tih Anah loh he a napa Zibeon kah laak a luem vaengah khosoek ah tuibae sih a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anah ca rhoek khaw Dishon neh Anah canu Oholibamah te om. ");
INSERT INTO hlt_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Te phoeiah Dishon koca rhoek he Hemdan, Eshban, Ithran neh Keran om. ");
INSERT INTO hlt_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer koca rhoek he Bilhan, Zaavan neh Akan om. ");
INSERT INTO hlt_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishan koca he Uz neh Aran. ");
INSERT INTO hlt_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Khori khoboei rhoek la khoboei Lotan, khoboei Shobal, khoboei Zibeon, khoboei Anah. ");
INSERT INTO hlt_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","khoboei Dishon, khoboei Ezer, khoboei Dishan om tih amih he tah Seir kho ah khoboei la aka om Khori khoboei rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Tedae phoeiah Israel ca khuikah manghai la pakhat khaw a manghai uh hlanah Edom kho ah manghai la aka ngol manghai rhoek te tah Esau ko rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor capa Bela loh Edom ah a manghai vaengkah a khopuei ming te tah Dinnabah ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela a duek phoeiah anih hnukthoi la Bozrah kah Zerah capa Jobab te pahoi manghai van. ");
INSERT INTO hlt_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab a duek phoeiah a yuengla Temani kho kah Husham te manghai la om. ");
INSERT INTO hlt_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husham a duek phoeiah anih yuengla Moab kho kah Midian aka tloek Bedad capa Hadad te manghai la om. Te vaengkah a khopuei ming te Avith ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad a duek phoeiah anih yuengla Masrekah lamkah Samlah te manghai la om. ");
INSERT INTO hlt_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlah a duek phoeiah anih yuengla tuiva kaeng, Rehoboth lamkah Saul loh manghai a bi. ");
INSERT INTO hlt_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul a duek phoeiah anih yuengla Akbor capa Baalhanan loh manghai a bi. ");
INSERT INTO hlt_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akbor capa Baalhanan a duek phoeiah anih yuengla Hadad te manghai. Te vaengkah a khopuei ming te Pau ni. Te phoeiah a yuu ming te tah Mehetebel, Mezahab nu Matred canu ni. ");
INSERT INTO hlt_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Te phoeiah amah hmuen ah amah huiko, amah ming neh aka boei Esau ko kah khoboei rhoek ming te tah, khoboei Timna, khoboei Alva, khoboei Jetheth, ");
INSERT INTO hlt_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","khoboei Oholibamah, khoboei Elah, khoboei Pinon, ");
INSERT INTO hlt_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","khoboei Kenaz, khoboei Teman, khoboei Mibzar, ");
INSERT INTO hlt_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","khoboei Magdiel, khoboei Iram om. Amih he amamih kah a khohut khohmuen kah a tolrhum ah aka boei Edom khoboei rhoek ni. Esau he Edom kah a napa ni. ");
INSERT INTO hlt_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakob ngawn tah a napa kah lampahnah khohmuen Kanaan kho ah kho a sak. ");
INSERT INTO hlt_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Jakob kah a rhuirhong he tah, Joseph kum hlai rhih a lo ca vaengah a maya rhoek taengah boiva a luem puei. Te vaengah anih te a napa yuu Bilhah ca rhoek nen khaw, Zilpah ca rhoek nen khaw cadong hmaih van. Tedae Joseph loh amih kah theetnah te a napa taengah a thae la a puen pah. ");
INSERT INTO hlt_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Tedae Joseph te tah a patong soi kah a ca van oeh dongah a ca rhoek boeih lakah anih te Israel loh a lungnah tih pendum angkidung khaw a saii pah. ");
INSERT INTO hlt_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Tedae a maya rhoek boeih lakah a napa loh anih a lungnah te a maya rhoek loh a hmuh uh vaengah amah a hmuhuet uh. Te dongah anih rhoepnah neh voek ham khaw coeng uh pawh. ");
INSERT INTO hlt_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Te vaengah Joseph loh mang a man tih a maya rhoek taengla a puen hatah a maya rhoek kah a hmuhuet uh te koep a khoep. ");
INSERT INTO hlt_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Te vaengah a maya rhoek la, “Hnatun uh laeh, he tlam he mang ka man. ");
INSERT INTO hlt_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Lohma li kah cangpa te mamih loh n'tum uh hatah kai kah cangpa te thoo tih pai. Te vaengah nangmih kah cangpa loh a vael uh tih kai kah cangpa taengah bakop uh,” a ti nah ");
INSERT INTO hlt_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Te dongah anih te a maya rhoek loh, “Kaimih soah manghai la na manghai vetih kaimih soah na boei khaw na boei tang venim?,” a ti na uh. Anih a hmuhuet uh te a mang, a olka neh koep a khoep. ");
INSERT INTO hlt_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Te phoeiah mang a tloe koep a man tih a maya rhoek taengah, “Mang koep ka man hatah khomik neh hla neh aisi hlai at loh kai taengah tarha bakop uh,” a ti nah tih a doek. ");
INSERT INTO hlt_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","A napa neh a maya rhoek taengah a doek bal dongah amah vik te a napa loh, “Mang na man te ba ham lae? Nang hmaiah diklai la bakop ham kai neh na nu neh na maya rhoek loh ka lo khaw ka lo uh a ya?,” a ti nah tih a ho. ");
INSERT INTO hlt_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Te dongah anih te a maya rhoek thatlai uh. Tedae a napa long tah olka te a kuem. ");
INSERT INTO hlt_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Tedae a maya rhoek tah Shekhem ah a napa kah boiva luem sak ham a caeh cet. ");
INSERT INTO hlt_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Te vaengah Israel loh Joseph la, “Na maya rhoek, te Shekhem ah luem uh pawt nim? Halo lamtah nang man amih taengla kan tueih pawn ve,” a ti nah. Te dongah amah te, “Ka om ngawn he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Te dongah Joseph la,” Tahae ah cet lamtah, na maya rhoek kah sading sathal neh boiva kah sading sathal khaw na hmuh phoeiah kai taengah ol koep ham voei,” a ti nah. Te phoeiah Hebron kol lamkah Shekhem la a tueih tih Joseph khaw cet van. ");
INSERT INTO hlt_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Te vaengah lohma ah aka khohmang hlang te lawt a hmuh hatah tekah hlang loh, “Balae na tlap dae? a ti nah tih a dawt. ");
INSERT INTO hlt_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Te vaengah Joseph loh, “Ka maya rhoek ni ka tlap. Mela a luem uh khaw han thui lah saw,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Te dongah tekah hlang long te, “He lamloh puen uh, “Dothan la cet sih,” a ti uh khaw ka yaak ta,” a ti nah. Te dongah Joseph loh a maya rhoek hnukah cet tih amih te Dothan ah a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Tedae anih te a hla lamkah a hmuh uh tih amih taeng a pha hlan ah mah ngawn ham anih te a rhaithi uh. ");
INSERT INTO hlt_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Te dongah a maya rhoek loh khat neh khat taengah, “Mang boei halo ke! ");
INSERT INTO hlt_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Halo uh laeh, anih ke ngawn uh sih lamtah tangrhom pakhat khuila voei uh sih. 'Boethae mulhing loh a ngaeh coeng,’ ti na uh sih. A mang te metlam nim a om ve so uh sih,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Tedae Reuben loh a yaak vaengah amih kut lamkah Joseph te a huul tih, “A kah hinglu he ngawn uh boel sih,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Reuben loh amih taengah, “Anih te thii long sak boeh, khosoek kah tangrhom khuila voei uh mai, anih soah kut hlah uh boel mai,” a ti nah. Te vaengah anih te amih kut lamloh huul ham neh a napa taengla mael puei ham a ngaih. ");
INSERT INTO hlt_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Te dongah Joseph loh a maya rhoek taengla apha vaengah Joseph kah angkidung neh a pum dongkah pendum angkidung te a pit pa uh. ");
INSERT INTO hlt_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Te phoeiah Joseph te a khuen uh tih tangrhom khuiah a voeih uh. Tangrhom te khaw hoeng tih tui om pawh. ");
INSERT INTO hlt_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Tedae buh ca la a ngol uh vaengah a dan uh hatah Gilead lamkah Ishmael lambong aka lo te lawt a hmuh uh. Te vaengah Ishmael rhoek loh Egypt la suntlak puei ham kalauk dongah anhoi, thingpi neh myrrh a phueih uh tih cet uh. ");
INSERT INTO hlt_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Tedae Judah loh a manuca rhoek la, “Mah manuca te mueluemnah neh n'ngawn uh mai cakhaw a thii loh m'bueih ni. ");
INSERT INTO hlt_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Halo uh, anih he Ishmael taengah yoi uh sih. Ning kah a saa, manuca oeh dongah anih soah kut hlah thil boel sih,” a ti nah hatah a manuca rhoek long khaw a rhoi uh. ");
INSERT INTO hlt_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Te dongah Median hlang, thimpom rhoek halo neh Joseph te a doek uh tih tangrhom lamloh a khuen uh. Te phoeiah Joseph te Ishmael taengah tangka baelthong la a yoih uh. Te dongah Joseph te Egypt la a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Tedae Reuben loh tangrhom taengla a bal vaengah tangrhom khuikah Joseph te hah a sawt dongah a himbai te a phen. ");
INSERT INTO hlt_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Te phoeiah a manuca rhoek te a paan tih, “Camoe te a om pawt dongah kai melam ka mael eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Te phoeiah Joseph kah angkidung te a loh uh. Maae tal a ngawn uh kah thii dongah angkidung te a nuem uh. ");
INSERT INTO hlt_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Pendum angkidung te khaw a loh uh tih a napa taengla a khuen uh phoeiah, “Hekah angkidung ka hmuh uh he na capa kah himbai neh himbai pawt khaw hmat lah,” a ti na uh. ");
INSERT INTO hlt_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Te vaengah himbai te a hmat tih, “Ka capa kah angkidung la he, Joseph te mulhing boethae loh pat pat a ngaeh coini,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jakob loh a himbai te a phen, a cinghen ah tlamhni a naak tih a capa ham hnin takuem puet nguekcoi. ");
INSERT INTO hlt_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Te phoeiah anih aka hloep la a ca tongpa rhoek boeih neh a ca huta rhoek boeih khaw halo uh dae a hloep ham khaw a aal. “Ka capa taengah saelkhui la rhahdoe cangpoem neh ka suntla ni,” a ti nah tih Joseph kah a napa te rhap. ");
INSERT INTO hlt_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Median hoel long khaw Joseph te Egypt kah imtawt mangpa Pharaoh imkhoem Potiphar taengla a yoih uh. ");
INSERT INTO hlt_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Hnin at vaengah tah Judah te a manuca rhoek taeng lamkah suntla tih Adullami hlang, a ming te Hirah taengah pah. ");
INSERT INTO hlt_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Te vaengah Judah loh Kanaan hoel nu, a ming ah Shua a hmuh hatah pahoi a loh tih a ih puei. ");
INSERT INTO hlt_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Te dongah pumrhih tih capa a cun vaengah a ming te Er a sak. ");
INSERT INTO hlt_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Te phoeiah koep pumrhih tih ca a cun hatah a ming te Onan a sak. ");
INSERT INTO hlt_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Te phoeiah a rhaep bal tih capa a cun hatah a ming te Shelah a sak. Tedae Shelah a cun vaengah Kezib ah om. ");
INSERT INTO hlt_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Te phoeiah Judah loh a caming Er ham yuu a loh pah tih anih ming tahTamar ni. ");
INSERT INTO hlt_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tedae Judah kah a caming Er tah BOEIPA kah mikhmuh ah boethae la a om dongah anih te BOEIPA loh a duek sak. ");
INSERT INTO hlt_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Te dongah Judah loh Onan la, “Na maya yuu taengah kun lamtah anih te yucanah. Te phoeiah na maya ham a tii a ngan thoh pah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Tedae a tii a ngan te amah ham om hae mahpawh tila Onan loh a ming dongah, a maya yurho taengah a ih vaengah khaw diklai ah vik a san tih a maya ham tiingan khueh pah pawh. ");
INSERT INTO hlt_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Anih kah a saii te BOEIPA mikhmuh ah a lolh bal dongah anih khaw BOEIPA loh a duek sak. ");
INSERT INTO hlt_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Te vaengah Shelah khaw a maya rhoi bangla duek ve a ti. Te dongah Judah loh a langa Tamar la, “Ka capa Shelah a pantai hil tah na pa im ah nuhmai la khosa mai ,” a ti nah. Te dongah Tamar khaw cet tih a napa im ah kho a sak. ");
INSERT INTO hlt_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Tedae kum a yet phoeiah tah Judah yuu Shua nute duek. Te dongah Judah khaw hal tih a tu mul aka vo neh a hui Adullami Hirah taengah Timnah la cet. ");
INSERT INTO hlt_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Te dongah, “Tu mul vok ham Timnah la na marhang cet hang ke,” a ti na tih Tamar taengla a puen pah. ");
INSERT INTO hlt_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Te vaengah Shelah khaw ham coeng dae anih yuu la n'khueh moenih tila Tamar loh a hmuh dongah amah dongkah nuhmai himbai te a dul. Te phoeiah hnii a yil, muei a thuh tih Timnah long kah Enaim thohka ah ngol. ");
INSERT INTO hlt_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Tedae anih te Judah loh a hmuh vaengah a hmai a dah dongah pumyoi ni tila a poek. ");
INSERT INTO hlt_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Anih te amah langa la a ming pawt dongah long taengla anih taengah pah tih, “Halo, nang taengah ka ip ni ne,” a ti nah hatah, “Kai taengah na kun te kai ham balae na khueh eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Te vaengah Judah loh, “Kamah loh boiva khuikah maae ca kan pat bit ni,” a ti nah. Tedae Tamar loh, “Nan pat hlanah hnohol han khueh dae,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Te dongah, “Hnohol te balae nang taengah kan paek eh?,” a ti nah. Te vaengah, “Na kutbuen mai khaw, hamnak khaw, na kut kah conghol mai te khaw,” a ti nah. Te dongah anih te a paek tih a kun thil dongah Judah loh Tamar a vawn sak. ");
INSERT INTO hlt_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Te phoeiah thoo tih, cet tih a pum dongkah hnii te a dul phoeiah nuhmai himbai tloep a bai. ");
INSERT INTO hlt_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Te dongah huta kut kah hnohol te tlan ham Judah loh a hui Adullami hoel kut ah maae ca te a pat van hatah rhawp hmu pawh. ");
INSERT INTO hlt_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Te dongah te hmuen kah hlang rhoek te a dawt “Enaim long taengkah hlanghalh te melae?,” a ti nah vaengah he rhoek ah hlanghalh om pawh,” a ti na uh. ");
INSERT INTO hlt_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Te dongah Judah taengla koep bal tih, “Anih te ka hmuh moenih. Te phoeiah he hmuen kah hlang rhoek long khaw, 'He rhoek ah hlanghalh a om moenih,’ a ti uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Te dongah Judah loh, “Amah neh amah te khoem uh saeh, nueihbu la n'om uh ve. Maae ca n'thak he khaw anih te na hmuh voel pawt tih he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Tedae hla thum tluk a lo vaengah Judah taengah,” Nang langa Tamar te cukhalh tih pumyoihnah neh vawn lah ko te,” a ti nah tih a puen pa uh hatah Judah loh, “Anih te khuen uh lamtah hoeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Anih te a mawt uh van hatah, “He rhoek he u hlang kah nim. Kai khaw tekah hlang hut la ka vawn dongah hekah kutnoek, hamnak neh conghol, ukah nim tila hmat lah saeh,” a ti nah tih a marhang taengla Tamar loh a pat. ");
INSERT INTO hlt_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Tedae Judah loh a hmat vaengah, “Ka capa Shelah te anih ka paek pawt dongah te kai lakah anih tang coeng,” a ti. Te dongah anih ming ham koep khoep voel pawh. ");
INSERT INTO hlt_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tedae ca-om tue vaengah tah a bung khuiah caphae rhoi la tarha om. ");
INSERT INTO hlt_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Te dongah camoe a om vaengah kut pakhat te han thawt dongah ca-om loh a tuuk tih, a kut dongah a lingdik a cin pah tih, “Lamhma la om coeng he,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tedae a kut vik a yueh tih a mana lat ha thoeng dongah, “Namah loh a puut Metlamlae nam va,” a ti nah dongah a ming te Perez a sak. ");
INSERT INTO hlt_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Te phoeiah a kut dongah a lingdik aka om a maya te ha pawk tih a ming te Zerah a sak. ");
INSERT INTO hlt_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joseph te Egypt la a suntlak puei ngawn dae, anih aka suntlak puei Ishmael kut lamkah te Egypt hlang, imtawt mangpa, Pharaoh imkhoem, Potiphar loh pahoi a lai. ");
INSERT INTO hlt_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Tedae BOEIPA te Joseph taengah a om dongah hlang thaihtak la coeng tih a boei Egypt hoel kah im ah om. ");
INSERT INTO hlt_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","A boei long khaw, BOEIPA te Joseph taengah tih a saii boeih te a kut dongah BOEIPA loh a thaihtak sak tila a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Joseph te a mikhmuh ah mikdaithen la a hmuh tih a taengah thotat. Te vaengah Potiphar loh a im te Joseph pum dongah a hlah pah. Te phoeiah a koe boeih te a kut ah a tloeng pah. ");
INSERT INTO hlt_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Tedae a im neh a koe boeih te a hlah pah vaeng lamloh om tih, Joseph kong ah Egypt cako te BOEIPA loh yoethen a paek. BOEIPA kah yoethennah te a koe neh im, lo boeih dongla cet. ");
INSERT INTO hlt_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","A koe boeih te Joseph kut ah a hnoo pah van neh Egypt hoel loh buh caak bueng te a ming tih ba khaw amah loh ming pawh. Joseph ngawn tah a suisak sakthen tih mueimae sakthen la om. ");
INSERT INTO hlt_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Tedae hekah olka he a om phoeiah a boei kah a yuu loh a dan vaengah Joseph te a mik neh a nai tih, “Kai taengah yalh mai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tedae a boei yuu te a aal tih, “Ka boeipa loh im kah aka om te kai taengah ngaiyak mueh la a khuehtawn boeih te ka kut ah a tloeng coeng. ");
INSERT INTO hlt_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Hekah im ah kai lakah aka len a om moenih. Tedae nang tah a yuu la na om dongah nang mueh atah ba khaw kai ham a hloh moenih. Te dongah metlam lae boethae aka len he ka saii vetih Pathen taengah ka tholh sui dae,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Joseph taengah, khohnin khohnin a thui pah van dae a taengah yalh ham neh om hmaih ham te Joseph lohngaiyaknah pawh. ");
INSERT INTO hlt_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Tedae hnin at ah Joseph te amah kah bi saii ham im khuila a caeh van hatah, tekah im ah im om hlang te khat khaw om pawh. ");
INSERT INTO hlt_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Te dongah Potiphar yuu loh Joseph te a himbai ah a tuuk tih, “Kai taengah yalh mai,” a ti nah. Tedae Joseph loh a himbai te anih kut ah a caehtak phoeiah rhaelrham tih poeng la cet. ");
INSERT INTO hlt_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Tedae a kut dongah a himbai a caehtak pa tih poeng la a rhaelrham vaengah te boeinu loh a hmu. ");
INSERT INTO hlt_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Te dongah a im kah tongpa rhoek te a khue tih, “So uh lah, mamih aka lawn la Hebrew hlang te mamih taengla han khuen. Kai taengah yalh ham kamah taengla m'paan dongah ol ue neh ka pang. ");
INSERT INTO hlt_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Tedae ka ol ka huel tih ka pang te a yaak hatah kai taegah a himbai a caehtak phoeiah rhaelrham tih poeng la cet,” a ti nah tih a thui pah. ");
INSERT INTO hlt_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Te phoeiah a boei loh a im a paan duela a kah himbai te amah taengah a khoem. ");
INSERT INTO hlt_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","A taengah hekah olka bangla a thui pah tih, “Kai aka lawn ham ning taengah na det Hebrew sal loh ka taengah m'paan. ");
INSERT INTO hlt_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Te dongah ka ol ka huel tih ka pang hatah a himbai te kai taengah a hnoo tih poeng la rhaelrham,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","“Na sal loh kai hekah hno he a saii,” a ti nah tih a taengah a thui a yuu kah olka te a boei loh a yaak vaengah ngawn tah a thintoek ah pahoi sai. ");
INSERT INTO hlt_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Te dongah Joseph te a boei loh a khuen tih manghai loh a khoh thongtla rhoek kah a hmuen, thong im ah a khueh dongah thong im ah pahoi om. ");
INSERT INTO hlt_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tedae BOEIPA loh Joseph a om puei tih sitlohnah a tueng sak dongah thong im kah mangpa mikhmuh ah anih te mikdaithen la a khueh. ");
INSERT INTO hlt_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Te dongah thong im kah mangpa loh thong im kah thongtla boeih te Joseph kut ah a paek tih saii ham koi boeih te aka saii la Joseph khaw pahoi om. ");
INSERT INTO hlt_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","BOEIPA tah anih taengah om tih a saii te BOEIPA loh a thaihtak sak. Te dongah thong im mangpa a om pawt akhaw a kut hmuikah tah pakhat hilah boeih a sawt. ");
INSERT INTO hlt_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Hekah olka a om phoeiah Egypt manghai kah tuitul neh buh thong loh a boei Egypt manghai taengah lai a hmuh rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Te dongah Pharaoh tah a imkhoem tuitul rhoi kah mangpa neh buh thong rhoek kah mangpa taengah a thintoek. ");
INSERT INTO hlt_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Te dongah amih rhoi te imtawt mangpa im kah thongim ah a khueh. Te im kah thong hmuen ah Joseph te a khoh. ");
INSERT INTO hlt_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Te dongah imtawt mangpa loh thongtla rhoek taengah Joseph te a hlah tih amih taengah thotat. Te tlam te thongim ah vuenhlaem om uh. ");
INSERT INTO hlt_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Tedae Egypt manghai loh thong im kah a khoh tuitul boei neh buh thong boei loh khoyin pakhat ah mang a man rhoi. A mang rhoi te khaw, a mang thuingaihnah khaw bok om. ");
INSERT INTO hlt_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mincang ah amih taengla Joseph kun tih amih rhoi te a sawt hatah a hmai vik tal rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Te dongah a boei im kah thongim ah amah neh aka om Pharaoh imkhoem te a dawt tih, “Tihnin atah balae tih na hmai a thae rhoi,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Te vaengah Joseph la mang ka man rhoi van dae aka thuicaih om pawh,” a ti nah rhoi. Te dongah Joseph loh amih rhoi te, “Thuingaihnah he Pathen hut moenih a? Kai taengah thui rhoi mai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Te dongah tuitul rhoek kah mangpa loh a mang te Joseph taengah a thui tih, “Ka mang ah misur kung te ka hmai ah lawt om. ");
INSERT INTO hlt_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Misur dongah a baek pathum neh a muem, a pai khaw cuen, misur kah a su khaw hmin. ");
INSERT INTO hlt_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Te vaengah Pharaoh kah boengloeng te ka kut ah om. Te phoeiah misur thaih te ka loh tih Pharaoh boengloeng dongah ka sui phoeiah boengloeng te Pharaoh kut ah ka paek,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph loh anih te, “A thuingaihnah he, misur baek pathum te khohnin hnin thum ni. ");
INSERT INTO hlt_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Hnin thum khuiah Pharaoh loh na lu te a dangrhoek vetih nang te namah hmuen la m'mael sak ni. Hnukbuet ah a tuitul la na om vaengkah khosing bangla Pharaoh te a kut dongah boengloeng na doe ni. ");
INSERT INTO hlt_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tedae namah taengkah kai nan poek mai atah namah ham a voelphoeng vaengah kai taengah sitlohnah tueng sak mai. Pharaoh taengah kai n'thoelh lamtah kai he, he im lamloh n'khuen ne. ");
INSERT INTO hlt_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Hebrew kho lamkah a huen la n'huen phoeiah hiah khaw ba ka saii pawt maiah tangrhom la kai n'hlak uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","A then la a thuicaih te buh thong rhoek kah mangpa long khaw a hmuh vaengah Joseph la, “Kai khaw ka mang vaengah vaidam te kodawn pathum neh ka lu ah ka doeng. ");
INSERT INTO hlt_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Te vaengah Pharaoh kah cakok ka thong boeih te a so kah kodawn dongah om. Tedae ka lu sokah kodawn te vaa loh a caak,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Te dongah Joseph loh a doo tih, “A thuingaihnah he tah kodawn pathum khohnin hnin thum ni. ");
INSERT INTO hlt_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Hnin thum khuiah Pharaoh loh na lu te na pumdong lamkah a phil vetih thing dongla n'kuiok sak phoeiah na saa te vaa loh a caak ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Te phoeikah a thum khohnin dongah Pharaoh cun nah khohnin om tih a sal boeih ham buhkoknah a saii. Te vaengah tuitul rhoek kah mangpa lu neh buh thong rhoek kah mangpa lu te a sal lakli ah a dangrhoek. ");
INSERT INTO hlt_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Te vaengah tuitul rhoek kah mangpa te amah kah tuitul la koep a khueh tih Pharaoh kut ah boengloeng a doe. ");
INSERT INTO hlt_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Tedae buh thong mangpa te tah Joseph kah a thuicaih van bangla a kuiok sak. ");
INSERT INTO hlt_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tedae tuitul mangpa loh Joseph te a poek mueh la a hnilh ");
INSERT INTO hlt_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Te phoeiah om tih kum a thok tue vaengah Pharaoh loh mang a man tih sokko taengah ana pai. ");
INSERT INTO hlt_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Te vaengah vaito pumrhih, a mueimae sakthen neh a pum aka toitup te sokko lamkah lawt halo tih capu ding ah luem uh. ");
INSERT INTO hlt_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Amih hnukah a mueimae thae tih a pum aka cangkhawk vaito pumrhih te khaw sokko lamkah lawt ha thoeng bal tih sokko kaeng kah vaito kaepah pai uh. ");
INSERT INTO hlt_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Tedae a mueimae thae tih a pum aka cangkhawk vaito pumrhih loh a mueimae sakthen neh aka toitup vaito te a caak uh, vaengah Pharaoh haenghang. ");
INSERT INTO hlt_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Te phoeiah ip tih a pabae la mang a man hatah cangvuei thamkom neh aka then parhih te a cangkong pakhat dongah tarha vuei. ");
INSERT INTO hlt_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Te phoeiah aka om cangvuei thamyit parhih te tah a hnukah kanghawn loh a yah tih a hum sak. ");
INSERT INTO hlt_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Tedae cangvuei thamyit parhih loh cangvuei thamkom neh cangtak te a yoop vaengah Pharaoh haenghang hatah a mang la pawk. ");
INSERT INTO hlt_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Te dongah mincang a pha vaengah tah a mueihla a cahoeh. Egypt hmayuep boeih neh aka cueih boeih te khaw a tah tih a khue. Tedae Pharaoh loh amih taengah a mang te a thui hatah Pharaoh ham aka thuicaih thai om pawh. ");
INSERT INTO hlt_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Te daengah tuitul mangpa loh Pharaoh taengah, “Tihnin ah ni kamah tholh te ka poek. ");
INSERT INTO hlt_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharaoh loh a sal rhoek taengah a thintoek tih kai neh buh thong mangpa te imtawt mangpa kah im thongim la n'khoh. ");
INSERT INTO hlt_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Tedae hlaem pakhat ah kai khaw anih khaw mang ka man rhoi hatah mang thuingaihnah te rhirha aka om te ka man rhoi. ");
INSERT INTO hlt_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Te vaengah imtawt mangpa kah sal, Hebrew cadong te kaimih taengah om. Te dongah anih ham ka thui pah rhoi dongah kaimih rhoi kah mang te kaimih rhoi ham a thuicaih. Hlang kah a mang khaw a thuicaih. ");
INSERT INTO hlt_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Kaimih rhoi taengah a thuicaih vanbangla om tih a thoeng dongah kai he ka hmuen koep han khueh vaengah anih te a kuiok sak,” a ti nah tih a thui pah. ");
INSERT INTO hlt_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Te dongah Pharaoh loh Joseph te a tah tih khue sak vanbangla anih te tangrhom khui lamkah koe a doek uh tih sam a vok, himbai a tho phoeiah Pharaoh taengla cet. ");
INSERT INTO hlt_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Te vaengah Pharaoh loh Joseph la, “Mang ka man tih aka thuicaih a om pawt vaengah aka thuicaih ham nang loh mang na yakming a ti tih nang kawng te ka yaak,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Tedae Joseph loh Pharaoh te a doo tih, “Kai moenih, Pharaoh te Pathen loh ngaimongnah neh doo bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Te dongah Pharaoh loh Joseph te, “Ka mang ah sokko kaeng la ka pai. dae, ");
INSERT INTO hlt_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Tedae vaito a pumsa aka toitup tih a suisak sakthen pumrhih te sokko lamkah lawt halo tih capu ding ah luem uh. ");
INSERT INTO hlt_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Amih hnukah vaito a tloe pumrhih halo bal dae tattloel la a suisak khaw bahoeng thae tih a pum pim. Tetla thaenah tah Egypt kho tom ah ka hmu pawh. ");
INSERT INTO hlt_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Te vaengah vaito aka pim neh a thae pumrhih loh lamhma kah vaito aka tha rhoek te a caak uh. ");
INSERT INTO hlt_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tedae amih ko khuila a kun uh thuk lalah a moecuek vaengkah bangla a mueimae a thae dongah amih ko khuila a kun uh te thui la a hut pawt vaengah ka haenghang. ");
INSERT INTO hlt_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Te phoeikah ka mang ah khaw cangvuei thamkom neh a then thamrhih te a cangkong pakhat dongah ha thoeng te lawt ka hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Amih hnukkah cangvuei parih thamyit neh aka rhae, kanghawn loh a yah tih aka hum te tarha halo van. ");
INSERT INTO hlt_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Te vaengah cangvuei aka yit rhoek loh cangvuei a then thamrhih te a dolh dongah hmayuep rhoek ham ka thui pah dae kai taengah aka puen om pawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Te dongah Joseph loh Pharaoh la, “Pharaoh kah a mang he pakhat ni. Pathen loh a saii te Pharaoh taengah a phoe coeng. ");
INSERT INTO hlt_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Vaito aka then pumrhih khaw kum rhih la om tih cangvuei a then parhih kum rih la om tih a mang te pakhat ni. ");
INSERT INTO hlt_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Amih hnukah aka thoeng vaito pumrhih aka pim tih aka thae te khaw kum rhih la om tih, cangvuei aka hi tih kanghawn loh a hum sak parhih te khokha kum rhih ni. ");
INSERT INTO hlt_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Pharaoh taengah kan thui vanbangla Pathen loh a saii hno he Pharaoh a tueng coeng. ");
INSERT INTO hlt_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Aka lo ham kum rhih te Egypt kho tom ah khobuh khungdaeng ni te. ");
INSERT INTO hlt_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Tedae a hnukah khokha kum rhih pai vetih Egypt kho kah khobuh te boeih a hnilh. Te vaengah khohmuen khaw khokha loh a khah ni. ");
INSERT INTO hlt_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Te dongah a hnuk lamtah khokha bahoeng nah tih khobuh te vang khui loh ming mahpawh. ");
INSERT INTO hlt_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Pharaoh taengah a pabalae la mang a rhaep he khaw Pathen taeng lamloh olka a cikngae sak dongah Pathen loh tlek a saii ni. ");
INSERT INTO hlt_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Te dongah Pharaoh loh, aka yakming tih aka cueih hlang te so lamtah anih te Egypt kho ah khueh laeh saeh. ");
INSERT INTO hlt_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Khohmuen ah hlangtawt rhoek te Pharaoh loh tuek saeh lamtah khobuh kum kumrhih khuiah Egypt kho kah panga pakhat aka coi la om saeh. ");
INSERT INTO hlt_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Te daengah ni kum then a pai vaengkah caak boeih te a coi uh eh. Te phoeiah Pharaoh kut hmuiah cangpai a tung uh vetih khopuei ah caak khaw a cuem eh. ");
INSERT INTO hlt_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Kho kah hnokhueh dongah caak a om daengah ni khokha loh Egypt khokhui la kum kumrhih a om halo vaengah khohmuen te khokha loh a tulnoi pawt eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Tekah olka ngawn tah Pharaoh mik neh a sal rhoek boeih kah mik ah a thuem sak. ");
INSERT INTO hlt_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Te dongah Pharaoh loh a sal rhoek la, “Hekah hlang bangla a khuiah Pathen mueihla aka om te m'hmuh noek nim?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Te dongah Pharaoh loh Joseph la, “Hekah boeih he Pathen loh nang m'ming sak dongah nang bangla aka thuep neh aka cueih he om pawh. ");
INSERT INTO hlt_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kai im ah nang om lamtah nang kah olpaek te ka pilnam boeih loh ngai saeh. Ka ngolkhoel bueng nen mah nang lakah ka ham mai eh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Te phoeiah Pharaoh loh Joseph la, “So lah, Egypt kho pum kah a soah nang ni kan hut sak coeng,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Pharaoh loh a kut dongkah a kutcaeng te a dul tih Joseph kah kut ah a buen pah. Hnitang himbai neh a khuk phoeiah a rhawn ah sui oi a oi sak. ");
INSERT INTO hlt_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Leng dongah khaw a hnukthoi la a ngol sak tih, “Anih hmai ah cungkueng uh,” hlo a phoek uh tih Egypt kho boeih kah a soah Joseph te a khueh. ");
INSERT INTO hlt_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Te phoeiah Pharaoh loh Joseph la, “Kai he Pharaoh coeng dae nang muehah hlang loh a kut khaw a kho khaw Egypt kho tom ah thueng boel saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Joseph ming khaw Pharaoh loh Zephenathpaneah la a khue tih a yuu la Oni khosoih Potiphera canu Asenath te a paek. Te phoeiah Joseph loh Egypt kho tom a hil. ");
INSERT INTO hlt_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Egypt manghai Pharaoh taengla a kun vaengah Joseph te kum sawmthum lo ca pueng. Tedae Pharaoh mikhmuh lamloh Joseph nong tih Egypt kho tom boeih a hil. ");
INSERT INTO hlt_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Te phoeiah khobuhnah kum rhih khuiah tah khohmuen te kutvang long khaw a thaih sak. ");
INSERT INTO hlt_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Te dongah Egypt kho kah aka thoeng kho kum rhih kah caak boeih te a coi tih khopuei boeih ah caak a tung. Khopuei kaepvai kah khohmuen cang khaw a khui ah a khueh. ");
INSERT INTO hlt_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph loh cang a tung vaengah tuitunli kah laivin bangla muep a yet dongah a loeng tloel tih a tae ham khaw a toeng. ");
INSERT INTO hlt_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Khokha kum halo hlanah Oni khosoih Potiphera canu Asenath loh ca a cun pah tih Joseph loh capa panit a sak. ");
INSERT INTO hlt_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Te vaengah Joseph loh, “Ka thakthaenah boeih neh a pa cako boeih te Pathen loh kai n'hnilh sak,” a ti dongah a caming te a ming Manasseh a sui. ");
INSERT INTO hlt_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A ca pabae ming te khaw, “Kai kah phacip phabaem kho ah Pathen loh kai m'pungtai sak,” a ti dongah Ephraim a sui. ");
INSERT INTO hlt_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Tedae Egypt kho ah khobuh kum rhih aka om te bawt. ");
INSERT INTO hlt_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Joseph loh a thui vanbangla aka lo ham khokha kum rhih a tong dongah paeng tom ah khokha om coeng dae Egypt kho pum ah caak om pueng. ");
INSERT INTO hlt_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Tedae Egypt kho kho boeih loh a lamlum van vaengah tah pilnam loh caak ham ham te Pharaoh taengla pang uh. Te dongah Pharaoh loh Egypt rhoek boeih te, “Joseph taengla cet uh lamtah nangmih taengah a thui bangla saii uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Khokha loh diklai hman boeih te a pha vaengah a kho khuikah aka om cangpai boeih te Joseph loh a hlah tih Egypt rhoek ham a yoih pah dongah Egypt kho kah khokha te a noeng. ");
INSERT INTO hlt_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Paeng tom long khaw koivawn ham Egypt kah Joseph te a paan uh dongah paeng tom kah khokha khaw a talong. ");
INSERT INTO hlt_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Egypt ah cangtham a om te Jakob loh a hmuh vaengah a ca rhoek te Jakob loh, “Ba dongah lae sut na sawt uh thae? a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","phoeiah, “Egypt ah cangtham om tila ka yaak dongah he, n'duek uh pawt tih n'hing uh mak atah te lam khaw cet uh lamtah mah hamla koivawn uh saw,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Te dongah Joseph kah a maya hlang rha rhoek loh Egypt kah cang lai ham suntla uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Tedae Joseph mana Benjamin te tah nganboh yook ve a ti dongah a maya rhoek taengah Jakob loh tueih pawh. ");
INSERT INTO hlt_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kanaan kho te khokha a om dongah koivawn ham aka cet rhoek lakli ah Israel ca rhoek khaw cet uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Te vaengah Joseph tah a kho kah boei neh diklai pilnam boeih ham cang a yoih. Te dongah Joseph kah a maya rhoek te a caeh uh vaengah anih taengah a maelhmai neh diklai la bakop uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","A hmuh vaengah Joseph loh a maya rhoek te a hmat ngawn dae amih taengah muet uh tih rhaprhap a voek phoeiah, “Me lamkah lae na lo uh,” a ti nah hatah, “Caak lai ham Kanaan kho lamkah ka lo,” a ti na uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph loh a maya rhoek te a hmat ngawn dae amih loh Joseph te hmat uh pawh. ");
INSERT INTO hlt_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Te vaengah Joseph loh amih kawng a man vaengkah mueimang te a poek. Te dongah amih te, “Nangmih he rhalyuep ni, khohmuen kah a yah te sawt ham ni na lo uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Tedae amah taengah “Pawh, ka boeipa, na salpa rhoek halo he caak lai ham ngawn ni. ");
INSERT INTO hlt_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kaimih he hlang pakhat kah a ca rhoek boeih ni. Kaimih hmantang rhoek ni, na sal kaimih ah he longyam a om moenih,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Tedae amih te Joseph loh khohmuen kah a yah dongah sawt ham na lo uh pawt het nim,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Na sal rhoek kaimih boeinaphung he hlang pakhat kah a ca rhoek la Kanaan kho ah hlai nit ka lo uh tih a poeih tah tahae ah a pa neh om rhoi dae pakhat te om voelpawh,” a ti na uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Tedae amih te Joseph loh, “Nangmih taengah ka thui bangla nangmih he longyam ni ka ti, ");
INSERT INTO hlt_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Pharaoh kah a hingnah vanbangla he nen he kan noem ni. Na mana a poeih te he la halo pawt atah he lamloh na voei uh mahpawh. ");
INSERT INTO hlt_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Nangmih khuikah pakhat te tueih uh lamtah na mana te lo saeh. Nangmih ngawntah kang khoh uh vetih nangmih kah olka te na khuikah oltak la a om atah kan nuemnai pueng ni. Te pawt koinih Pharaoh kah a hingnah vanbangla nangmih he longyam ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Te dongah amih te thongim ah hnin thum a khoh. ");
INSERT INTO hlt_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Tedae a thum khohnin ah Joseph loh a maya rhoek la he tlam he ka saii dae, kai khaw aka hing Pathen te ka rhih van. ");
INSERT INTO hlt_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Na thuem uh atah na manuca khat te im kah thongim khuiah khoh saeh. Te vaengah nangmih te cet uh lamtah na im kah aka lamlum ham cang khuen pa uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Tedae na mana a poeih te kai taengah nan khuen uh vaengah nangmih kah olka te khaw cak vetih na duek uh van mahpawh,” a ti nah dongah te tlam te a rhoi uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Te vaengah amah boeinaphung te khat khat ah, “Manuca a hinglu kah citcai te hmuh uh tih mamih taengah calcal a pang lalah n'yaak pah uh pawt dongah tekah citcai loh m'mah taengla ha thoeng tih mamih he rheprhep n'rhaem coeng,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Te vaengah Reuben loh amih te a doo tih, “Nangmih taengah ka thui moenih a? Camoe te veet uh boeh ka ti lalah na ya uh pawt tih a thii han suk coeng he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Tedae amih laklo ah oldoe a om dongah Joseph loh a yakming te amih loh ming uh pawh. ");
INSERT INTO hlt_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Te dongah Joseph loh amih taeng lamkah mael tih a rhah phoeiah amih taengla koep halo. Tedae amih te a voek phoeiah amih khui kah Simeon te a loh tih amamih kah mikhmuh ah a khoh pah. ");
INSERT INTO hlt_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Tedae Joseph loh a uen coeng dongah amih kah hnopai te cang a sang thil uh. Te vaengah a tangka te khaw a tolkhui khuiah rhip a khueh ham khaw, amih ham te longpueng kah lampu khaw paek ham khaw, a saii pah. ");
INSERT INTO hlt_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Te dongah amamih kah cang te laak dongla a pom hang uh tih pahoi cet uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Tedae rhaehim ah tah pakhat loh laak rhamcak loh ham a tolkhui te a hlam hatah a tangka te sungkoi kah a rhai ah lawt a hmuh tarha. ");
INSERT INTO hlt_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Te dongah a manuca rhoek taengah, “Kai kah sungkoi dongah kamah kah tangka koep ham mael bal he,” a ti nah hatah amih lungbuei khaw mawt sut dongah lakueng uh tih a boeinaphung khat rhip loh, “Pathen loh mamih ham balae a saii he,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Te dongah Kanaan kho kah a napa Jakob taengla a pha uh vaengah amih taengah aka thoeng boeih te amah taengah puen uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Tekah hlang, a kho kah boei te kaimih taengah rhaprhap cal tih kaimih te a kho kah longyam bangla n'khueh. ");
INSERT INTO hlt_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tedae anih taengah, 'hmantang ah kaimih he longyam la ka om moenih. ");
INSERT INTO hlt_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","A pa kah a ca rhoek la ka boeinaphung ah hlai nit ka lo uh dae pakhat om voelpawt tih a poeih ngawn tah tihnin ah khaw a pa neh Kanaan kho ah hmaih om,’ ka ti na uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Tedae tekah hlang, a kho kah boei loh kaimih te, 'boeinaphung kah pakhat te kai taengah na caehtak uh tih te nen te nangmih na thuem ka ming phoeiah na im kah aka lamlum ham caak khuen uh lamtah cet uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Tedae na mana a poeih te kai taengah han khuen uh. Te daengah ni nangmih te longyam rhoek pawt tih na hmantang tila ka ming eh. Na manuca te nangmih taengla kan paek vetih khohmuen ah na thenpom uh bitni,’ a ti,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Te dongah amamih kah tolkhui te a kong uh hatah a tangka cun te tolkhui dongah rhip tarha om tih tangka cun a hmuh uh vaengah amamih long khaw a napa long khaw a rhih uh. ");
INSERT INTO hlt_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Te vaengah a napa Jakob loh amih te, “Kai taengah, Joseph na hlong uh tih om voelpawh. Simeon khaw om voelpawh. Tahae ah Benjamin bal atah kai taengkah aka om boeih te lo loh ne,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Te dongah Reuben loh a napa taengah, “Anih te namah taengla kan khuen pawt atah kai ca rhoi khaw ngawn mai. Ka kut dongah han tloeng lamtah kamah loh nang taengla kang khuen bit ni,” a ti nah tih a thui pah. ");
INSERT INTO hlt_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tedae anih loh, “Ka ca te a maya duek tih amah bueng a sueng dongah nangmih taengla ha suntla boel saeh. Longpueng na caeh uh vaengah yoethae puei vetih kai sampok he saelkhui ah kothae la nan hla uh ve,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tedae diklai ah khokha a nah pueng dongah, ");
INSERT INTO hlt_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Egypt lamkah a khuen cang te khaw bawt a khawk uh. Te dongah a napa Jakob loh a ca rhoek la, “Cet lamtah mah caak ham bet vawn uh dae,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Te vaengah Judah loh a napa te, “Hlang loh kaimih taengah, 'Na mana te namah neh na pawk pawt atah kai maelhmai na hmuh uh mahpawh,’ a ti tih n'hih la n'hih. ");
INSERT INTO hlt_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ka mana te nan tueih mai koinih ka cet uh vetih namah ham man caak ka lai uh ve. ");
INSERT INTO hlt_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Nan tueih van pawt atah hlang loh kaimih taengah, 'Na mana te namah neh na pawk pawt atah kai maelhmai hmu uh mahpawh,’ a ti oeh dongah ka cet uh mahpawh, a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Te dongah Israel loh, “Na mana khat te khaw ba ham lae hlang taengla na puen uh tih kai he nan talh uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Te dongah a ca rhoek loh, “Hlang loh mamih kawng neh pacaboeina kawng te n'dawt n'dawt tih, 'Na pa hing pueng a? Na mana om a? a ti dongah a ka dongkah olka te ni ka doo uh dae, 'Na mana han khuen,’ a ti ni tila ka ming khaw ka ming uh huek a,” a ti na uh. ");
INSERT INTO hlt_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Tedae Judah loh a napa Israel la, “Camoe te kamah neh n'tueih lamtah caeh hamla ka hlah uh pawn ni. Te daengah ni n'hing uh vetih kaimih khaw, namah khaw, camoe rhoek khaw n'duek pawt eh. ");
INSERT INTO hlt_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Anih te kamah loh ka kaem. Nang taengla kam bal puei tih kamah kut lamkah nang hmai ah kan khueh pawt atah han suk. Khohnin takuem nang taengah tholh ka phueih bit ni. ");
INSERT INTO hlt_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Tedae ka uelh uh pawt koinih he la koep ka voei uh pawn ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Te daengah a napa Israel loh, “He tlam he saii laeh, tolrhum kah thaihthen, thingpi khaw, khoitui khaw, anhoi khaw, myrrh khaw yungkha mu khaw, noepai mu khaw, a yol a yol tah na hno dongah rhip sang uh lamtah hlang ham te khosaa la khuen uh. ");
INSERT INTO hlt_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Na kut dongah tangka rhaepnit la khuen uh lamtah na sungkoi so kah tangka te khaw mael puei uh. Na kut dongah na loh tholh khaming. ");
INSERT INTO hlt_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Na mana khaw khuen uh. Hlah uh lamtah hlang taengla ha cet uh laeh. ");
INSERT INTO hlt_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Hlang hmai ah khaw Pathen Tlungthang loh nangmih taengah haidamnah han khueh saeh lamtah na mana neh Benjamin te han hlah saeh. Ka loh cakol khaw ka cakol mai eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Te dongah tekah hlang rhoek loh khosaa te a khuen uh. Te phoeiah a kut dongkah tangka te rhaepnit la a khuen uh tih aka thoo uh te Benjamin khaw Egypt la a suntlak puei uh tih Joseph hmai ah pai uh. ");
INSERT INTO hlt_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Joseph loh amih neh Benjamin te a hmuh vaengah a im aka khut taengah, “Hlang rhoek te im la khuen. Te phoeiah maeh ngawn lamtah kamah neh khothun buh caak ham sai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Tekah hlang long khaw Joseph kah a thui bangla a saii van tih hlang rhoek te Joseph im la a khuen. ");
INSERT INTO hlt_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Tedae Joseph im la a khuen uh vaengah hlang rhoek loh a rhih uh. Te dongah, “A moecuek ah mamih kah sungkoi khuiah koep a khueh tangka kawng dongah mamih palet ham neh mamih aka cungku sak ham ni. Te dongah mamih khaw laak rhoek khaw sal la tuuk ham n'khuen coeng,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Te dongah Joseph im kah hlang taengla thoeih uh tih im kah thohka ah a voek uh. ");
INSERT INTO hlt_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Te phoeiah, “Ka boeipa aw, a moecuek vaengah ni caak lai ham ka suntlak khaw ka suntlak uh coeng. ");
INSERT INTO hlt_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Tedae rhaehim ka pha uh vaengah kamamih kah sungkoi te ka hlam uh hatah sungkoi kah a rhai ah tangka te rhip a om tarha dongah amah tarhing la ka kut dongah ka tangka te kan khuen uh. ");
INSERT INTO hlt_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Te phoeiah caak lai ham te ka kut dongah tangka a hloeh la kang khuen uh ngawn. Unim kaimih kah sungkoi dongah tangka a khueh dae ka ming uh pawh,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Tedae Joseph im om loh, “Nangmih taengah rhoepnah om saeh, rhih uh boeh. Na Pathen neh na pa kah Pathen loh na sungkoi dongah nangmih ham kawn a khueh tih na tangka loh kai taeng ham pha coeng,” a ti nah tih Simeon te amih taengla a mawt pah. ");
INSERT INTO hlt_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Tekah hlang loh hlang rhoek te Joseph im la a khuen. Tui a paek tih a kho a yuh phoeiah laak ham rhamcak khaw a tloeng pah. ");
INSERT INTO hlt_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Tedae khothun buh caak pahoi ham Joseph ha pawk ni tila a yaak uh dongah a khosaa te a soepboe uh. ");
INSERT INTO hlt_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Te dongah im la Joseph halo van neh a kut dongkah khosaa te im khuila a khuen uh tih a hmaiah diklai la bakop uh. ");
INSERT INTO hlt_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Te phoeiah amih te sading kawng a dawt tih, “Na pa patong na ti uh te sading la hing pueng a?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Te vaengah, “Na sal rhoek khaw ka sading uh tih a pa khaw hing pueng,” a ti nah uh phoeiah buluk uh tih a bawk la a bawk uh coeng. ");
INSERT INTO hlt_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Te vaengah a mik a huel hatah a manu ca, a mana Benjamin te a hmuh tih, “Na mana a poeih na ti uh te anih a?,” a ti nah tih, “Ka ca Pathen loh nang n'rhen saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Tedae Joseph loh a manuca rhoek taengah a haidamnah pahoi tloo tih a rhah thaa la huut. Te dongah imkhui la cet tih pahoi rhap. ");
INSERT INTO hlt_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Tedae a hmai a hlak phoeiah halo tih thiim uh. Te phoeiah, “Buh poep laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Te dongah Joseph khaw amah loh, a manuca te khaw amah amah loh, Joseph taengkah aka ca Egypt rhoek long khaw amah amah loh a poep uh. Te Egypt ham tueilaehkoi la a om dongah Hebrew taengah buh caak ham Egypt ham tah coeng pawh. ");
INSERT INTO hlt_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Te vaengah caming tah amah caminghamsum bangla, a capoeih khaw a capoeih hamsum bangla a mikhmuh ah ngol uh. Te dongah hlang rhoek tah pakhat loh a hui taengah a ngaihmang uh. ");
INSERT INTO hlt_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Te vaengah Joseph loh amah hmai kah buham te amih ham a poep pa thil hatah Benjamin kah buham ngawtah amih boeih kah buham lakah a pueh panga la yet. A ok uh tih a taengah rhuihmil uh. ");
INSERT INTO hlt_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Te phoeiah a im kah te a uen tih, “Hlang rhoek kah sungkoi te cang a phueih rhoeh ah sang pa lamtah tangka te sungkoi kah a rhai ah rhip khueh pah. ");
INSERT INTO hlt_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Tedae kai kah bunang khuikah ngun bunang te a poeih kah sungkoi khui ah khueh pah lamtah amah kah cang neh tangka khaw hmaih sang pah,” a ti nah dongah Joseph kah ol a thui bangla a saii van. ");
INSERT INTO hlt_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mincang khothaih nen tah hlang rhoek te amamih kah laak neh khaw vawl a tueih uh. ");
INSERT INTO hlt_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Amih loh khopuei te a hla lamkah hawt a khum vaengah Joseph loh a im om te, “Thoo, hlang rhoek te a hnukah hloem lamtah na kae vaengah amih te, 'Balae tih a then te boethae neh na thuung uh? ");
INSERT INTO hlt_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ka boeipa kah a tui ok te he moenih a? Te lamkah la anih a hma khaw a hma dae. Anih taengkah na saii uh te na lolh uh coeng, 'ti nah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Te dongah amih te a kae vanneh hekah olka he a thui pah. ");
INSERT INTO hlt_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Tedae amih loh, “Ka boeipa tebang olka te ba ham lae a thui. Na sal rhoek loh tebang hno a saii ham khaw savisava la. ");
INSERT INTO hlt_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Kaimih loh sungkoi so kah tangka ka hmuh uh te Kanaan kho lamkah nang taengla kam bal puei uh atah metlamlae na boei im kah ngun neh sui te tarha ka huen uh eh. ");
INSERT INTO hlt_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Na sal rhoek khuiah u taeng mai ah khaw a om atah duek saeh lamtah kaimih khaw ka boeipa taengah sal la ka om uh eh,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Te dongah Joseph im om loh, “Then, nangmih kah olthui vanbangla u khaw a taengah aka om hlang van te tah kai taengah sal la om saeh lamtah nangmih te ommongsitoe la na om uh ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Te dongah sungkoi te a loe la diklai ah rhip a hal uh tih rhip a ong uh. ");
INSERT INTO hlt_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Te dongah a ham taeng lamkah a tong tih a tlap te a poeih taengla a khah vaengah bunang te Benjamin kah sungkoi dongah a hmuh. ");
INSERT INTO hlt_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Te vaengah a himbai te a phen uh tih laak dongah hno rhip a tloeng uh tih khopuei la koep bal uh. ");
INSERT INTO hlt_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Tedae Judah neh amah boeinaphung loh im a pha vaengah Joseph khaw a om pueng dongah a hmai ah diklai la bakop uh. ");
INSERT INTO hlt_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Te vaengah Joseph loh ba bibi lae na saii uh he. Kai bang hlang he hma khaw hma tila, na ming uh moenih a?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Te vaengah Judah loh, “Ka boeipa taengah mebang ka thui tih metla ka cal vaengah lae ka tang uh eh. Na sal rhoek kathaesainah khaw Pathen loh a yan oeh coeng dongah kaimih khaw, a kut dongkah bunang a hmuh pah hlang nen te ka boeipa taengah sal ka bi uh van mai pawn ni ta,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Tedae Joseph loh, “Hekah he kai loh ka saii ham te savisava, a kut dongah bunang a hmuh hlang te kai taengah sal la om ngawn saeh lamtah nangmih te na pa taengah ngaimong la bal uh ngawn,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Tedae Judah te anih taengla thoeih tih, “Aw ka boeipa kai aih he, na salpa khaw ka boeipa kah hna kaep ah olka bet ka thui dae ni. Tedae nang tah Pharaoh banghui la na om dongah na salpa taengah na thintoek te sai sak boel mai. ");
INSERT INTO hlt_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ka boeipa loh a sal rhoek he, 'Na pa neh na mana om a?,” a ti tih n'dawt. ");
INSERT INTO hlt_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Te dongah, “Ka boeipa la a pa khaw patong coeng tih a patong soi kah a cun capa a poeih te om. Tedae a manu pakhat kah a cun hmaih khuiah a maya te duek tih anih amah bueng la te a cul dongah a napa loh a lungnah,’ ka ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Te vaengah na sal rhoek he, 'Anih te ka mik ah ka khueh van ham khaw kai taengla han khuen thuk,’ na ti. ");
INSERT INTO hlt_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Te vaengah ka boeipa la, 'Camoe loh a napa a caehtak ham tah coeng pawh. Caehtak koinih a napa te duek ni, ' ka ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tedae na sal rhoek la, 'Na mana a poeih te nan suntlak puei pawt atah kai maelhmai hmuh ham khoep uh boeh,’ na ti. ");
INSERT INTO hlt_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Te dongah na sal rhoek he a pa taengla ka pawk uh vanneh ka boeipa kah olka te anih taengla ka puen uh. ");
INSERT INTO hlt_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Te dongah a pa loh, 'Mah ham khaw caak bet vawn uh bal dae,’ a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Te vaengah, “Kaimih taengah ka mana a poeih om pawt koinih hlang maelhmai hmuh ham a coeng pawt dongah, 'Ka mana a poeih loh kaimih taengah a om pawt mai ah ka caeh uh ham coeng pawh tedae halo atah ka cet uh ni,’ ka ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Te vaengah na sal rhoek he a pa loh, 'Ka yuu loh kai ham panit han sak te nangmih long khaw na ming uh. ");
INSERT INTO hlt_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Tedae pakhat he kai taeng lamloh cet coeng. Te dongah, 'A ngaeh ngawn a ngaeh tang coeng,’ ka ti. Te dongah ni tahae due anih te ka hmu pawh. ");
INSERT INTO hlt_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Anih he khaw ka mikhmuh lamkah na khuen uh tih anih loh yoethae puei bal koinih kai sampok he saelkhui ah a thae la nan hla uh ve,’ a ti. ");
INSERT INTO hlt_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Te dongah na sal kai loh a pa taeng ka pha tih kaimih taengah camoe amah te om pawt koinih a hinglu neh a hinglu te a hlaengtang uh rhoi dongah, ");
INSERT INTO hlt_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","camoe te hah a sawt vaengah duek koinih na sal rhoek loh a pa sampok na sal te saelkhui ah kothae la ka hlak uh la vik poeh ni. ");
INSERT INTO hlt_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Na salpa loh camoe te a pa taengah rhi ka khang tih, 'Anih he nang taengla kam pawk puei pawt atah a pa taengah hnin takuem ka tholh ka phueih bitni,’ ka ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Te dongah na salpa he camoe yueng ah ka boeipa kah sal la ka om mai saeh lamtah camoe te a maya rhoek neh bal sak mai. ");
INSERT INTO hlt_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Camoe kamah nen pawt koinih a pa taengah metlam caeh eh? A pa taengah yoethae a hmuh man ka hmuh lah ve,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Joseph long khaw amah taengkah aka pai boeih taengah thiim uh ham a coeng voelpawt vaengah, “Hlang boeih loh kai taeng lamkah nong uh,” tila pang. Te dongah a taengkah hlang tloe aka pai te a om pawt vaengah Joseph loh a manuca rhoek taengah amah kawng te a phoe. ");
INSERT INTO hlt_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Te vaengah rhahnah neh a ol a huel. Te dongah Egypt rhoek loh a yaak uh tih Pharaoh im long khaw a yaak. ");
INSERT INTO hlt_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Te vaengah Joseph loh a manuca rhoek la, “Kai he Joseph ni. A pa hing pueng a?,” a ti nah. Tedae anih hmuh ah a manuca rhoek te let uh tih doo uh thai pawh. ");
INSERT INTO hlt_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Te vaengah Joseph loh a manuca rhoek la, “Kai taengla bet ha thoeih uh lah,” a ti nah tih a thoeih uh hatah, “Kai Joseph he na manuca ni. Kai he Egypt la nan yoih uh. ");
INSERT INTO hlt_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tedae hinglu hlawtnah ham Pathen loh nangmih hmai ah kai n'tueih coeng dongah kai nan yoih uh te namamih kah mik dongah na ngaihlih sak uh boel lamtah sai boeh. ");
INSERT INTO hlt_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Tahae lamkah khokha kum loh kho khui ah om vetih kum nga ngawn tah lotawn cangah mueh la om pueng ni. ");
INSERT INTO hlt_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Tedae diklai ah a meet la nangmih te n'hoep phoeiah loeihnah tanglue neh nangmih te hing sak ham ni nangmih hmai ah Pathen loh kai n'tueih. ");
INSERT INTO hlt_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Te dongah nangmih loh hela kai nan tueih uh moenih. Tedae Pathen loh kai he Pharaoh napa lam khaw, amah im pum kah boei lam khaw, Egypt kho tom aka taemrhai ham khaw, n'khueh. ");
INSERT INTO hlt_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","A pa taengah a loe la cet uh lamtah, 'Na capa Joseph te Pathen loh Egypt pum kah boei la a khueh coeng,'. Uelh mueh la kai taengah na suntla uh tih, ");
INSERT INTO hlt_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","kamah neh a yoei la om ham Goshen kho ah a pa namah khaw, na ca rhoek khaw, na ca rhoek kah a ca rhoek patoeng khaw, na boiva khaw, na saelhung neh na taengkah aka om boeih te khaw kho na sak uh bitni. ");
INSERT INTO hlt_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Khokha he kum nga a om pueng dongah nangmih te kan cangbam bitni. Namah khaw, na im khaw na taengkah aka om boeih khaw tal ve,’ a ti,’ ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Tahae ah kamah ka neh nangmih taengah ka thui he nangmih mik neh ka mana Benjamin mik loh rhep a hmuh he. ");
INSERT INTO hlt_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Egypt ah kai, thangpomnah cungkuem neh nan hmuh uh boeih te a pa taengah puen uh lamtah a pa te pahoi tlek han khuen uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Te phoeiah a mana Benjamin te a rhawn ah a kop tih rhap. Benjamin long khaw a rhawn ah a kop tih rhap van. ");
INSERT INTO hlt_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","A manuca rhoek te rhip a mok tih a rhah thil. Te phoei daengah a manuca rhoek loh anih taengah cal uh. ");
INSERT INTO hlt_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Tedae Joseph kah a manuca rhoek halo uh a ti te Pharaoh im loh olthang a yaak vaengah Pharaoh mik ah khaw, a sal rhoek mik ah khaw cop. ");
INSERT INTO hlt_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Te dongah Pharaoh loh Joseph taengah, “He tlam he saii mai. Na manuca rhoek la, 'Na rhamsa neh sawn uh lamtah Kanaan kho la bal uh ngawn. ");
INSERT INTO hlt_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Na pa te khaw, na imkhui khaw, lo uh lamtah kai taengla han khuen uh. Nangmih te Egypt khohmuen kah a thennah kam paek vetih lai men te na caak uh bitni. ");
INSERT INTO hlt_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Te phoeiah namah loh uen lamtah saii. Na ca rhoek ham khaw, na yuu rhoek ham khaw, na pa te khaw lo uh. Te phoeiah na bal uh vaengkah ham leng te Egypt kho lamloh namah neh puei uh. ");
INSERT INTO hlt_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Egypt khohmuen kah a thennah boeih he nangmih ham coeng dongah na hnopai khaw na mik dongah rhen boeh,’ ti nah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Te dongah Isreal ca rhoek loh a saii uh tih Pharaoh kah olpaek vanbangla amih te Joseph loh leng a paek. Te phoeiah amih te longpueng ham lampu khaw a paek. ");
INSERT INTO hlt_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Amih ham thovaelnah himbai te khat khat rhip a paek tih Benjamin te tah tangka ya thum neh himbai thovaelnah ham yung nga a paek. ");
INSERT INTO hlt_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A napa ham khaw Egypt kah a thennah aka phuei laak pumrha, cang, caak neh a napa ham longpueng kah lampu aka phuei laaknu pumrha te a pat pah. ");
INSERT INTO hlt_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Tedae a manuca rhoek te a tueih tih a hlah uh vaengah amih te, “Longpueng ah tlai uh boeh ne,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Te phoeiah Egypt lamkah Kanaan kho la cet uh tih a napa Jakob te a paan uh. ");
INSERT INTO hlt_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Te phoeiah Jakob taengah, “Joseph hing pueng tih anih loh Egypt kho boeih a taem a rhai,” tila a puen pa uh. Tedae a lungbuei a lungmit coeng tih amih te tangnah pawh. ");
INSERT INTO hlt_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tedae Joseph loh amih taengah a thui olka boeih te Jakob taengah a thui pa uh tih amah aka phuei ham Joseph kah a pat leng te a hmuh vaengah a napa Jakob kah a mueihla koep hing. ");
INSERT INTO hlt_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Te daengah Israel loh, “Rhoek saeh, ka ca Joseph a hing pueng te ka duek hlanah ka cet vetih a muei ka hmu dae ni,” a ti. ");
INSERT INTO hlt_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Te dongah Israel loh a taengkah aka om boeih neh cet uh tih Beersheba a pha vaengah a napa Isaak kah Pathen ham hmueih a ngawn pah. ");
INSERT INTO hlt_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Te dongah amah tekah khoyin ah Isreal te Pathen loh mangthuinah neh a voek tih, “Jakob, Jakob,” a ti nah hatah, “Kai ka om he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Te vaengah kai Pathen he, na pa kah Pathen ni. Egypt la na suntlak thuk te rhih boeh. Nang te pilnu la pahoi kan khueh bitni. ");
INSERT INTO hlt_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Egypt lam khaw nang taengah kan suntlak puei vetih nang te koep kam bal puei bal ni. Joseph long khaw na mik dongah a kut a tloeng ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Beersheba lamkah Jakob koep a thoh vaengah Israel ca rhoek loh a napa Jakob neh a ca rhoek khaw, a yuu rhoek khaw, anih aka phuei ham Pharaoh loh a pat leng nen te a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Te phoeiah amamih kah boiva neh Kanaan kho kah a dang uh khuehtawn te khaw a khuen uh tih Jakob neh amah taengkah a tiingan boeih loh Egypt la cet uh. ");
INSERT INTO hlt_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","A ca tongpa rhoek neh a ca kah ca rhoek, amah taengkah a canu rhoek neh a ca rhoek kah canu rhoek khaw, a tiingan boeih te amah neh Egypt la a khuen. ");
INSERT INTO hlt_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Jakob neh a ca rhoek loh Egypt la a caeh uh vaengkah Israel ca rhoek kah a ming tah, Jakob kah a caming Reuben, ");
INSERT INTO hlt_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Reuben ca rhoek la Enok, Pallu, Khetsron neh, Karmee ");
INSERT INTO hlt_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon ca rhoek la Jemuel, Jamin, Ohad, Jakhin, Zohar neh Kanaan nu kah a capa Saul, ");
INSERT INTO hlt_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi ca rhoek la Gershon, Kohath neh, Merari ");
INSERT INTO hlt_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judah koca rhoek la Er, Onan, Shelah, Perez, Zerah om daea Er neh Onan te Kanaan kho ah duek tih Perez ca rhoi la Khetsron neh Hamul om. ");
INSERT INTO hlt_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issakhar ca rhoek la Tola, Puvah, Jashub neh Shimron, ");
INSERT INTO hlt_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulun ca rhoek la Sered, Elon neh Jaheel, ");
INSERT INTO hlt_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Paddanaram ah Jakob ham a sak pah Leah koca rhoek te a canu Dinah nen tah a pum la huta tongpa hinglu thumkip pathum lo. ");
INSERT INTO hlt_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad ca rhoek la Ziphion, Hakki, Shuni, Ezbon, Eri, Arodi neh Areli, ");
INSERT INTO hlt_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asher ca rhoek la Imnah, Ishua, Ishee, Beriah neh a ngannu Serah om tih Beriah ca la Heber neh Malkhiel om. ");
INSERT INTO hlt_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Amih he Laban loh a canu Leah taengah a paek Zilpah koca rhoek ni. Te dongah anih loh Jakob ham a sak pah he hinglu la hlai rhuk lo. ");
INSERT INTO hlt_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jakob yuu Rakhel ca rhoi la Joseph neh Benjamin om. ");
INSERT INTO hlt_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Joseph loh Egypt kho ah a om vaengkah a ca sak la Oni khosoih Potiphera canu Asenath loh Manasseh neh Ephraim a sak pah. ");
INSERT INTO hlt_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamin ca rhoek khaw Bela, Bekher, Ashbel Gera, Naaman Ehi, Rosh Muppin, Huppim neh Ard om. ");
INSERT INTO hlt_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Jakob ham a sak pah Rakhel koca rhoek kah hinglu boeih he hlai li lo. ");
INSERT INTO hlt_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan ca la Hushim om. ");
INSERT INTO hlt_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naphtali ca rhoek la Jahzeel, Guni, Jezer neh Shillem om. ");
INSERT INTO hlt_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Laban loh a canu Rakhel a paek tih Jakob ham ca aka sak pah Bilhah koca kah hinglu boeih te parhih lo. ");
INSERT INTO hlt_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Te dongah Jakob ca rhoek kah a yuu rhoek te a hoep phoeiah Jakob amah pum dongkah aka poe tih Egypt la a caeh puei hinglu boeih he hinglu sawmrhuk parhuk boeih lo uh. ");
INSERT INTO hlt_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Joseph loh Egypt kah a cun a ca rhoi hinglu panit nen ngawn tah a pum boeih la Egypt aka paan Jakob imkhui he hinglu sawmrhih lo. ");
INSERT INTO hlt_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Te vaengah Judah te Goshen hil a hmai ah thuinuet ham Joseph taengah a hmai la a tueih tih Goshen khohmuen te a pha uh. ");
INSERT INTO hlt_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph khaw amah kah leng te a khih tih a napa Israel doe ham Goshen la cet. Te dongah a napa te a hmuh neh a rhawn ah a kop tih a rhawn dongah puet rhap. ");
INSERT INTO hlt_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Te vaengah Israel loh Joseph la, “Na hing pueng tih na maelhmai ka hmuh coeng dongah ka duek thai pawn ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Te phoeiah Joseph loh a manuca rhoek taeng neh a napa cako taengah, “Pharaoh yaak sak ham ka cet vetih, 'Kanaan kho kah ka manuca rhoek neh a pa cako te kai taengla ha pawk uh coeng. ");
INSERT INTO hlt_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Tedae tekah hlang rhoek te boiva aka dawn hlang la om uh oeh tih boiva khaw a dawn uh dongah amamih kah boiva neh saelhung a khueh uh boeih te han khuen uh,’ ka ti nah ni. ");
INSERT INTO hlt_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Te vaengah Pharaoh loh nangmih n'uen tih, 'Na bibi balae,’ a ti ni. ");
INSERT INTO hlt_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Te vaengah, 'Na sal rhoek ngawn tah, a pa rhoek khaw, kamamih khaw ka camoe uh lamkah tahae due boiva hlang la om uh. Te dongah boiva aka dawn boeih he Egypt rhoek kah tueilaehkoi la a coeng dongah Goshen kho ah kho nan sak sak mai mako,'ti na uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Te phoeiah Joseph cet tih Pharaoh taengah, “A pa neh ka manuca rhoek khaw, a boiva khaw, a saelhung khaw, amah taengkah aka om boeih te Kanaan kho lamkah halo uh tih Goshen kho ah om uh ke,” a ti nah tih a puen pah. ");
INSERT INTO hlt_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Te phoeiah a manuca khui kah hlang panga a khuen tih Pharaoh hmai ah a khueh. ");
INSERT INTO hlt_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Te vaengah Pharaoh loh Joseph kah a manuca rhoek te, “Nangmih kah bibi te balae,” a ti nah hatah amih loh Pharaoh la, “Na sal rhoek he kamamih khaw, a pa rhoek long khaw boiva ni ka dawn uh,” a ti na uh. ");
INSERT INTO hlt_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Te phoeiah Pharaoh la, “Kanaan kho ah khokha tlung tih na sal rhoek kah boiva ham a luemnah a om pawt dongah hekah khohmuen ah bakuep ham ka lo uh. Te dongah na sal rhoek he Goshen kho ah kho n'sak sak uh mai,” a ti na uh. ");
INSERT INTO hlt_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Te dongah Pharaoh loh Joseph la, “Na pa neh na manuca rhoek nang taengah aka lo rhoek te, ");
INSERT INTO hlt_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","'Na hmai kah Egypt kho khuikah khohmuen then Goshen kho ah na pa neh na manuca rhoek te khosak sak. Te phoeiah amih khuikah tatthai hlang rhoek te na ming atah amih te kai kah boiva mangpa la khueh,” a ti nah tih a uen. ");
INSERT INTO hlt_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Te phoeiah Joseph loh a napa Jakob te a khuen tih Pharaoh hmai ah a pai sak hatah Jakob loh Pharaoh te yoethen a paek. ");
INSERT INTO hlt_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Te vaengah Pharaoh loh Jakob la, “Nang kah hingnah a kum khohnin loh meyet a lo van coeng,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Te dongah Jakob loh Pharaoh la, “Ka lampahnah kum khohnin he kum pasoi neh thumkip vel a pha coeng. Tedae ka hingnah kum khohnin he yoethae yoehu la om tih a pa rhoek a lampahnah tue vaengkah a hingnah kum khohnin te a pha moenih,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Te phoeiah Jakob loh Pharaoh te yoethen a paek tih Pharaoh taeng lamkah pahoi nong. ");
INSERT INTO hlt_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Te phoeiah Pharaoh kah a uen vanbangla Joseph loh a napa neh a manuca rhoek te Egypt kho ah khohut pakhat a paek tih khohmuen then Raameses kho ah kho a sak sak. ");
INSERT INTO hlt_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Te dongah Joseph loh a napa neh a manuca rhoek khaw, a napa imkhui boeih neh camoe ka dongkah caak ham khaw a cangbam pah. ");
INSERT INTO hlt_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Tedae khokha bahoeng tlung tih Egypt kho neh Kanaan kho te khokha loh a khah dongah kho takuem ah caak om pawh. ");
INSERT INTO hlt_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Te vaengah Joseph loh Egypt khohmuen neh Kanaan kho ah cangtham a lai ham rhoek kah tangka a hmuh te boeih a coi. Te phoeiah Joseph loh tangka te Pharaoh im la a khuen. ");
INSERT INTO hlt_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Tedae Egypt kho neh Kanaan kho kah tangka te a khawk uh vaengah Egypt rhoek loh Joseph te boeih a paan uh tih, “Kaimih he caak m'pae laeh. Tangka ka khawk uh cakhaw ba ham lae nang hmaiah ka duek uh eh?,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Tedae Joseph loh, “Tangka a boeih oeh atah na boiva te m'pae uh lamtah nangmih kah boiva te kan khueh mako,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Te dongah amamih kah boiva te Joseph taengla a khuen uh tih Joseph loh marhang khaw, boiva tuping khaw, saelhung boiva khaw, laak ham khaw caak a paek pah tih tekah kum ah ngawn tah amih kah boiva boeih te khaw caak neh a khool. ");
INSERT INTO hlt_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Tedae tekah kum thok tih a kum bae atah Egypt rhoek loh Joseph taengla halo uh tih, “Ka boeipa taengah ka phah uh moenih. Tangka khaw boeih coeng tih boiva neh rhamsa loh ka boeipa taeng a pha coeng dongah kaimih pum neh ka khohmuen pawt atah ka boeipa hmai ah a paih om voelpawh. ");
INSERT INTO hlt_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ba ham lae nang mikhmuh ah ka duek uh eh. Kaimih he khaw, ka khohmuen he khaw n'lai uh. Kaimih khaw ka khohmuen khaw caak neh ka thung coeng atah kamamih neh ka khohmuen loh Pharaoh sal la ka om uh bitni. Tedae cangti nan paek tih ka hing uh daengah man ka duek uh pawt sui tih tolrhum loh a pong pawt sue,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Tedae khokha te amih taengah a tlung pah vaengah Egypt rhoek loh a khohmuen rhip a yoih uh tih Egypt kho pum te Pharaoh ham Joseph loh a lai pah coeng dongah Pharaoh kah khohmuen la poeh. ");
INSERT INTO hlt_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Te dongah Egypt khorhi a bawt neh a khat ben lamkah pilnam te amah loh khopuei khuila a puen. ");
INSERT INTO hlt_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Tedae khosoih rhoek kah khohmuen ngawn tah Pharaoh loh khosoih rhoek ham a paek khotlueh la a om dongah lai van pawh. Te vaengah khosoih rhoek loh Pharaoh kah a paek khotlueh te a caak uh tih a khohmuen te yoi uh pawh. ");
INSERT INTO hlt_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Te phoeiah Joseph loh a pilnam la, “Tihnin ah namamih khaw, na khohmuen khaw Pharaoh ham ka lai coeng he. Tedae cangti he namamih ham lo uh lamtah khohmuen te tawn uh ngawn. ");
INSERT INTO hlt_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","A vuei a thaih a om vaengah panga te Pharaoh taengah pae uh lamtah pali te namamih ham neh lohma kah cangti la, namah cako a caak ham neh na ca rhoek loh a caak ham khaw om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Te vaengah, “Ka boeipa kah mikhmuh ah mikdaithen la m'hmuh uh tih mamih n'hlun atah Pharaoh taengah sal la ka om uh bitni,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Te dongah Joseph loh a khueh oltlueh vanbangla tahae khohnin duela Egypt kho ah hlopnga te Pharaoh hut la om. Khosoih rhoek kah khohmuen bueng te amamih loh a hutnah tih Pharaoh hut la om pawh. ");
INSERT INTO hlt_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Te vaengah Israel loh Egypt kho kah Goshen khohmuen ah kho a sak tih a kawt la a kawt dongah pungtai uh tih muep ping uh. ");
INSERT INTO hlt_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakob khaw Egypt kho ah kum hlai rhih hing tih Jakob kah a hingnah kum khohnin long khaw kum pasoi likip neh kum rhih lo coeng. ");
INSERT INTO hlt_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Te vaengah Isreal kah a duek ham khohnin loh a yoei coeng dongah a capa Joseph te a khue tih, “Nang mikhmuh ah mikdaithen ni ka dang atah ka phai hmuiah na kut tloeng laeh. Sitlohnah neh uepomnah khaw Kai ham na saii atah kai he Egypt kho n'up boel mai. ");
INSERT INTO hlt_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Te phoeiah a pa rhoek taengah ka yalh atah kai he Egypt lamkah nan khuen vetih amih kah phuel ah nan up ni,” a ti nah hatah, “Na ol bangla kamah loh ka saii bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Te vaengah, “Kamah taengah toemngam dae,” a ti nah hatah a toemngam tih Israel te baiphaih dongkah a lu taengah bakop. ");
INSERT INTO hlt_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Tedae hekah olka a om phoeiah Joseph la, “Na pa te nue coeng ne,” a ti na uh hatah a ca rhoi Manasseh neh Ephraim te a caeh puei . ");
INSERT INTO hlt_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Te vaengah Jakob la, “Na capa Joseph nang taengla ha pawk ke,” a ti nah tih a puen pah vaengah Isreal khaw thaa a huel tih baiphaih dongah ngol. ");
INSERT INTO hlt_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Te phoeiah Jakob loh Joseph la, “Pathen Tlungthang loh Kanaan kho kah Luz ah kai taengla ha phoe tih kai yoethen m'paek vaengah, ");
INSERT INTO hlt_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","kai taengah, “Kamah loh nang kam pungtai sak vetih kam ping sak vaengah pilnam hlangping la kan khueh ni. Khohmuen he khaw nang hnukah na tiingan taengah kumhal khohut la ka paek ni, ' a ti. ");
INSERT INTO hlt_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Te dongah nang taengah Egypt la ka pawk hlankah, nang loh Egypt kho kah na cun, na ca rhoi te, kai kah ni. Ephraim neh Manasseh khaw Reuben neh Simeon bangla kamah ca boeiloeih ni. ");
INSERT INTO hlt_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tedae amih rhoi phoeikah na sak na pacaboeina te tah namah ham om saeh lamtah a maya rhoi kah a ming neh a rho te thui thil saeh. ");
INSERT INTO hlt_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kai khaw Paddan lamkah ka bal vaengah kamah taengkah Rakhel loh Kanaan kho kah longpueng ah duek. Te vaengah Epharath la caeh ham khaw kho te a lak om pueng. Te dongah anih te Bethlehem Epharath long ah pahoi ka up,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Te phoeiah Israel loh Joseph ca rhoi te a sawt tih, “Amih rhoi he ulae?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Te dongah Joseph loh a napa te, “Amih rhoi he Pathen loh he rhoek ah kai ham a khueh ka ca rhoi ni,” a ti nah. Te dongah, “Kai taengla han khuen rhoi lamtah yoethen ka pae rhoi pawn ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israel mik khaw kum loh a talh tih a hmuh hamla noeng voel pawh. Te dongah camoe rhoi te a taengla a thoeih pah. Te vaengah amih rhoi te a mok tih a kop. ");
INSERT INTO hlt_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Te vaengah Israel loh Joseph te, “Nang kah maelhmai hmuh ham pataeng ka thangthui voel pawt dae na ca rhoek khaw Pathen loh kai n'tueng coeng he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Te phoeiah Joseph loh a napa khuklu dong kah a ca rhoi te a loh tih a tal neh diklai la bakop. ");
INSERT INTO hlt_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Tedae Joseph loh camoe rhoi te a khuen. Isreal kah banvoei benla khueh ham amah kah bantang kut dongah Ephraim, Isreal kah bantang benla a banvoei kut dongah Manasseh a mawt tih thoeih phai. ");
INSERT INTO hlt_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tedae Israel taengah a pha vaengah a noe Ephraim kah a lu vik te bantang kut a tloeng thil. Manasseh te a caming daeta a kut a cungvaeh tih Manasseh kah lu dongah banvoei kut a tloeng. ");
INSERT INTO hlt_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Te phoeiah Joseph te yoethen a paek tih, “A pa rhoek Abraham neh Isaak hmai ah aka caeh puei Pathen, tahae khohnin due ka hingnah boeih neh kai aka dawn Pathen, ");
INSERT INTO hlt_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Yoethaenah cungkuem lamkah kai aka tlan puencawn loh camoe rhoi he yoethenpae saeh lamtah, kai ming khaw, a pa Abraham neh Isaak ming khaw amih rhoi dongah phuk thil saeh. Diklai hman ah pungtai rhoi saeh lamtah ping rhoi saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Tedae Ephraim kah a lu ah a napa loh bantang kut a tloeng te Joseph loh a hmuh vaengah a mik lolh tih Ephraim lu dong lamkah Manasseh kah lu dong la thoeih ham a napa kut te a doek pah tih, ");
INSERT INTO hlt_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Joseph loh a napa la, “A pa tlam moenih, anih caming kah a lu dongah na bantang kut tloeng saw ,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tedae a napa loh a aal tih, “Ka ca ka ming, anih he pilnam la a om khaw ka ming. Te dongah anih khaw rhoeng ni. Tedae a mana a noe he anih lakah rhoeng vetih a tiingan te namtom hlangping la om ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tekah khohnin ah amih rhoi te yoethen a paek hatah, “Nang rhang neh Pathen loh Isreal te a yoethen sak saeh, nang he Ephraim neh Manasseh bangla khueh saeh,” a ti nah tih Manasseh hmai ah Ephraim a khueh. ");
INSERT INTO hlt_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Te phoeiah Israel loh Joseph la, “Kai ka duek cakhaw nang taengah Pathen om vetih na pa kho la nang n'khuen bit ni ne. ");
INSERT INTO hlt_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Te dongah kamah loh Amori kut lamkah cunghang palaa neh ka lat khokong pakhat te na manuca rhoek kah a soah nang kan paek thil,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Te phoeiah Jakob loh a ca rhoek te a khue tih, “Tun ngol uh lamtah, vuenvai ah nangmih taengah aka thoeng ham te nangmih taengah ka puen pawn ni, ");
INSERT INTO hlt_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Jakob ca rhoek loh a yaak uh tih a coi uh thae vaengah, “Na pa Israel kah ol te ya uh van lah. ");
INSERT INTO hlt_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben nang he ka caming tih, ka thadueng neh, ka thahuem cuek, hlangrhuel boeimang, hlangtlung hlangrhuel la na om dae, ");
INSERT INTO hlt_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Na pa kah tih thingkong sola na yoeng tih, ka rhaenghmuen te na poeih phoeiah, tui bangla na soetaenah dongah caknoi khaw na khueh mahpawh. ");
INSERT INTO hlt_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon neh Levi boeina, amih rhoi kah tubael tah kuthlahnah tumca ni. ");
INSERT INTO hlt_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Amih rhoi kah tingtunnah dongah ka hinglu naepkhap pawh. Amah rhoi kah thintoek dongah hlang a ngawn rhoi tih vaito kaprhui haih ham te amih rhoi kah kolonah la a om dongah, kai kah thangpomnah loh amih rhoi a hlangping te bulbo boel saeh. ");
INSERT INTO hlt_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Amih rhoi kah a thinpom khaw a tlung dongah a thintoek te thae a phoei thil. Te dongah a mangkhak te Jakob taengah ka tael vetih Israel taengah khaw ka taekyak ni. ");
INSERT INTO hlt_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judah nang he na manuca rhoek loh nang n'uem uh ni. Na kut te na thunkha a rhawn dongla cu ni. Na pacaboeina te nang taengah bakop uh ni. ");
INSERT INTO hlt_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah he sathueng ca ni. Ka ca loh maeh kung lamkah na bal phoeiah, sathueng neh sathuengnu bangla aka yuel tih, aka kol te ulong anih a haeng eh. ");
INSERT INTO hlt_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Judah lamkah mancai tah nong boel lamtah, a kho laklo lamloh taem saeh. Shiloh a pha duela anih taengah, pilnam kah boengainah om saeh. ");
INSERT INTO hlt_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","A laaktal, laaktal te misur dongah, a laak ca te cangsawt misur dongah pael saeh. A pueinak te misurtui dongah, a hnipup, hnipup te misur thii dongah til saeh. ");
INSERT INTO hlt_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Na mik khaw musurtui lakah ling vetih, na no te suktui lakah bok ni. ");
INSERT INTO hlt_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun he tuitunli kah langkaeng ah khosa saeh lamtah, langkaeng kah sangpho rhoek bangla a bawtnah loh Sidon due pha saeh. ");
INSERT INTO hlt_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issakhar he laak songrhuh bangla saelvong laklo ah na kol. ");
INSERT INTO hlt_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Duemnah then neh khohmuen hlahmae te khaw a hmuh dae, phueih te a laengpang ah a thueng tih aka thotat saldong la om ni. ");
INSERT INTO hlt_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan he Israel koca pakhat vanbangla a pilnam kah lai a thui pah ni. ");
INSERT INTO hlt_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan he long taengkah rhul neh marhang dongkah aka ngol te a hnuk la bung saeh tila marhang khomik aka maeng tih, caehlong rhulthae bangla om ni. ");
INSERT INTO hlt_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","BOEIPA nang kah khangnah ham ni ka lamtawn he. ");
INSERT INTO hlt_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad he caem loh tloek cakhaw anih loh a khomik a tloek pah ni. ");
INSERT INTO hlt_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asher ham caak bae vetih, manghai buhmong a tael ni. ");
INSERT INTO hlt_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali tah sayukrhuinu bangla khocaeh dangka vetih, ol then a thui ni. ");
INSERT INTO hlt_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph tah a ca loh thaihsu tih, a ca loh tuiphuet taengkah pungtai. Ngannu ngankhong loh pangbueng dongla luei. ");
INSERT INTO hlt_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Thaltang boei rhoek a konaeh uh dongah, a phaep uh tih a kah uh. ");
INSERT INTO hlt_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tedae Jakob kah samrhang kut rhang neh, Israel aka dawn lungnu rhang neh, ");
INSERT INTO hlt_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Na pa kah Pathen loh nang m'bom tih Tlungthang loh nang te vaan a sosang kah yoethennah, a laedil kah aka kol yoethennah nen khaw, a rhangsuk dongkah yoethennah nen khaw, a bung khuikah nen khaw yoethen m'paek dongah, a li khaw tangkuek la om tih, a kut bantha khaw caang. ");
INSERT INTO hlt_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Na pa kah yoethennah he kai aka yom kah yoethennah lakah len. Khosuen som ah a saelongnah hil Joseph lu so neh a manuca hlangcoelh luki soah om saeh. ");
INSERT INTO hlt_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin, uithang laihat loh, mincang ah maeh a ngaeh, hlaem ah kutbuem a tael,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","A pum boeih la Israel koca he hlai nit dongah a napa loh amih taengah a thui vaengah amah kah yoethennah neh amih te yoethen rhip a paek. ");
INSERT INTO hlt_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Te phoeiah amih te a uen tih, “Kai he ka pilnam taengla ka khum atah a pa rhoek neh Khitti Ephron lo kah lungko ah n'up uh. ");
INSERT INTO hlt_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Kanaan kho Mamre hmai, Makpelah lo kah lungko te phuel khohut la Khitti Ephron taeng lamkah Abraham loh a lai khohmuen ni. ");
INSERT INTO hlt_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ti ah te Abraham neh a yuu Sarah a up uh tih Isaak neh a yuu Rebekah te pahoi a up uh coeng. Leah khaw pahoi ka up coeng. ");
INSERT INTO hlt_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Te dongah Kheth ca rhoek taeng lamkah te khohmuen boiva neh a khuikah lungko te,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jakob loh a ca rhoek a uen te a khah phoeiah baiphaih dongla a kho a yueh. Te phoeiah pal tih a pilnam taengla khoem uh. ");
INSERT INTO hlt_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Te vaengah Joseph loh a napa maelhmai a bakop thil tih a soah a rhah neh a mok. ");
INSERT INTO hlt_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Te phoeiah Joseph loh a napa te sihluk ham a sal siboei rhoek te a uen tih siboei rhoek loh Isreal te si a hluk uh. ");
INSERT INTO hlt_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Sihluknah khohnin te khohnin lipkip a di ham a om dongah khohnin a soep vanneh rhok te Egypt rhoek loh khohnin sawmrhih a rhah uh. ");
INSERT INTO hlt_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Rhahnah khohnin a poeng vaengah Joseph loh Pharaoh im la, “Na mikhmuh ah mikdaithen ni ka dang atah Pharaoh kah hna kaep ah bet ka thui mai eh. ");
INSERT INTO hlt_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","A pa loh, 'Ka duek atah Kanaan kho ah kamah ham ka vueh tangtae phuel ah pahoi nan up ni, ' a ti tih kai he n'toemngam sak oeh dongah bet ka cet saeh lamtah a pa te ka up phoeiah ka bal mai eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pharaoh long khaw, “Na toemngam vanbangla cet lamtah na pa te up dae,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Te dongah Joseph te a napa up ham a caeh hatah Pharaoh kah sal boeih neh a im kah a hamca rhoek long khaw, Egypt kho kah a hamca boeih long khaw, ");
INSERT INTO hlt_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Joseph cako boeih neh a manuca rhoek long khaw, a napa cako long khaw a thak puei uh. Camoe neh a boiva, saelhung bueng te Goshen kho ah a caehtak uh. ");
INSERT INTO hlt_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Te dongah anih taengah aka cet te leng khaw, marhang caem khaw lambong yet la muep om. ");
INSERT INTO hlt_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tedae Jordan rhalvangan kah Atad te a pha uh vaengah rhaengsaelung neh bungbung mat a rhaengsae uh tih a napa ham nguekcoinah te hnin rhih a yaeh uh. ");
INSERT INTO hlt_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Tedae Atad ah a nguekcoinah te Kanaan kho kah khosa rhoek loh a hmuh uh vaengah, “Hekah he Egypt rhoek loh mat a nguekcoinah ni,” a ti uh dongah Jordan rhalvangan kah a ming te Abelmizaim la a khue. ");
INSERT INTO hlt_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Te dongah a uen vanbangla Isreal ham a ca rhoek loh a saii uh tih, ");
INSERT INTO hlt_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Kanaan kho la a khuen uh. Te phoeiah Abraham loh phuel khohut la Khitti Ephron kah khohmuen Mamre ah a lai Makpelah lo kah lungko ah a up uh. ");
INSERT INTO hlt_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Joseph neh a manuca rhoek khaw, a napa up ham anih taengah aka cet boeih long khaw a napa te aup phoeiah Egypt la bal uh. ");
INSERT INTO hlt_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Tedae a napa a duek coeng dongah Joseph te a manuca rhoek loh a hmuh uh vaengah, “Joseph he mamih taengah a konaeh koinih anih taengah boethae n'saii uh boeih te n'thuung rhoe n'thuung ni,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Te dongah Joseph taengla ol a uen uh tih, “Na pa loh a duek hlan ah, ");
INSERT INTO hlt_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","'Joseph te, 'Na manuca rhoek kah dumlai khaw, nang a thae la n'saii uh vaengakah tholhnah te khaw phueih mai ti nah,’ a ti tih n'uen dongah na pa Pathen sal rhoek kah boekoeknah te phuei mai,” a ti nah uh tih a thui uh vaengah Joseph rhap. ");
INSERT INTO hlt_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Te dongah a manuca rhoek khaw cet uh tih a hmai ah bakop uh tih kaimih he nang kah sal ni he a ti uh. ");
INSERT INTO hlt_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tedae Joseph loh, “kai he Pathen hnukthoi a? Rhih uh boeh saw. ");
INSERT INTO hlt_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Nangmih loh kai taengah boethae la nan taeng uh cakhaw Pathen loh tahae khohnin kah bangla pilnam muep hing sak ham te a then la a moeh coeng. ");
INSERT INTO hlt_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Te dongah rhih uh boeh. Nangmih khaw, na ca rhoek khaw kan cangbam bitni,” a ti nah tih amih lungbuei te hloep ol a thui pah. ");
INSERT INTO hlt_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph khaw Egypt ah a napa kah a cako neh kho a sak. Te vaengah Joseph te kum pasoi neh kum rha hing. ");
INSERT INTO hlt_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Te dongah Joseph loh Ephraim ca rhoek a khongthum duela a hmuh. Manasseh capa Makir ca rhoek khaw Joseph khuklu dongah a cun uh. ");
INSERT INTO hlt_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Te vaengah Joseph loh a manuca rhoek la, “Kai ka duek cakhaw Pathen loh nangmih n'hip khaw n'hip vetih nangmih te tahae kah kho lamkah Abraham, Isaak neh Jakob ham a toemngam tangtae khohmuen la khuen bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Te dongah Joseph loh Israel ca rhoek te a toemngam sak tih, “Nangmih te Pathen loh n'hip rhoe la n'hip vaengah he lamkah ka rhuh na khuen uh ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Joseph he kum pasoi neh a lang a lo ca vaengah duek tih a rhok te si a hluk uh phoeiah Egypt kah thingkawng dongah a khueh uh. ");
INSERT INTO hlt_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","He rhoek he Egypt la aka kun Israel ca a ming ni. Te vaengah Jakob neh a imkhui kah hlang neh, ");
INSERT INTO hlt_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi neh Judah, ");
INSERT INTO hlt_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issakhar, Zebulun neh Benjamin, ");
INSERT INTO hlt_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naphtali, Gad neh Asher te ha pawk. ");
INSERT INTO hlt_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Te vaengah Jacob hlit lamkah aka thoeng hinglu boeih he hinglu sawmrhih lo coeng tih Joseph khaw Egypt ah om coeng. ");
INSERT INTO hlt_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Te phoeiah Joseph neh a manuca boeih neh te kah cadilcahma tah boeih duek. ");
INSERT INTO hlt_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Tedae Israel ca rhoek tah pungtai uh tih luem uh , ping uh tih yet uh. Te dongah amih te khohmuen ah mawk mawk bae uh. ");
INSERT INTO hlt_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Te vaengah Egypt ah manghai a thai phoe tih te long te Joseph ming pawh. ");
INSERT INTO hlt_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Te dongah a pilnam te, 'Pilnam he, Israel ca rhoek he mamih lakah muep pilnu coeng. ");
INSERT INTO hlt_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Anih te cueih pae pawn sih ping aih ve. Caemtloek ha thoeng tih anih neh koei uh koinih mamih m'hmuhuet ni. Te vaengah mamih m'vathoh thil vetih khohmuen lamloh cet hae ni. ");
INSERT INTO hlt_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Te dongah amih bitloh neh phaep sak ham saldong mangpa a khueh thil uh. Te vaengah Pharaoh kah rhuengim khopuei la Pithom neh Raamses te a thoh pah. ");
INSERT INTO hlt_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Anih a phaep uh vanbangla ping van tih pungtai van. Te dongah Israel ca rhoek kah mikhmuh ah a mueipuel uh. ");
INSERT INTO hlt_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Te dongah Egypt loh Israel ca rhoek te mangkhak la a thohtat sak. ");
INSERT INTO hlt_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Amih kah hingnah te amlai dong neh laiboeng dongah thohtatnah nen khaw, lohma kah thohtatnah cungkuem nen khaw, mat a phaep uh. Amih kah thohtatnah cungkuem dongah Israel ca te mangkhak la a thohtat sak uh. ");
INSERT INTO hlt_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Te phoeiah Egypt manghai loh Hebrew ca-om rhoi, a ming la pakhat ah Shiphrah neh a pabae ah a ming la Puah te a uen. ");
INSERT INTO hlt_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Te vaengah, “Hebrew nu te na om sak vaengah a omnah te so rhoi. tongpa atah ngawn rhoi lamtah huta atah hing saeh. ");
INSERT INTO hlt_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Tedae ca-om rhoi loh Pathen te a rhih rhoi. Te dongah Egypt manghai loh amih rhoi taengkah a thui bangla saii rhoi pawt tih camoe te a hing sak rhoi. ");
INSERT INTO hlt_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Te dongah Egypt manghai loh ca-om rhoek te a khue tih amamih taengah, “Balae tih he kah hno he na saii uh tih camoe na hing sak uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Te vaengah ca-om rhoek loh Pharaoh te, “Hebrew nu he Egypt nu bang moenih. Amih tah rhaang uh tih amih taengla ca-om a pawk hlan ah khaw om uh coeng, ” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Te dongah Pathen loh ca-om rhoek te a voelphoeng sak tih pilnam a ping dongah muep rhoeng uh. ");
INSERT INTO hlt_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ca-om rhoek loh Pathen te a rhih uh dongah amih ham im khaw a thoh pah. ");
INSERT INTO hlt_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Te dongah Pharaoh loh a pilnam boeih te a uen tih, “tongpa la aka thaang boeih tah sokko la voei uh kuekluek lamtah huta tah boeih hing sak uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Te vaengah Levi imkhui lamkah tongpa pakhat te cet tih Levi nu te a loh. ");
INSERT INTO hlt_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","A yuu te vawn tih capa a cun hatah anih tea then la a sawt tih hla thum a thuh. ");
INSERT INTO hlt_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Anih te koep thuh ham a coeng pawt vaengah tah anih ham talik lawng a loh pah tih lungpaat kunhnai neh a hluk. Te phoeiah a khuiah camoe te a khueh tih sokko tuikaeng kah carhaek ding ah a khueh. ");
INSERT INTO hlt_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Anih taengah metla a om khaw ming hamla a ngannu loh a hla lamkah a pai thil. ");
INSERT INTO hlt_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Te vaengah Pharaoh canu te tui hlu la sokko ah cet tih a hula puei neh sokko lihmoi ah pongpa uh. Tedae carhaek ding kah lawng te a hmuh vaengah a salnu te a tueih tih a loh pah. ");
INSERT INTO hlt_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","A ong vaengah camoe te a hmuh tih camoe khaw tarha ana rhap. Te dongah anih ham a thinphat tih, “Hebrew camoe la he,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Te vaengah a ngannu loh Pharaoh canu te, “Ka cet vetih nang ham Hebrew nu te, cakhoem la ka khue eh. Te daengah ni nang ham camoe hang khoem eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Anih te Pharaoh canu loh, “Cet saw,” a ti nah dongah hula te cet tih camoe manu te a khue pah. ");
INSERT INTO hlt_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Pharaoh canu loh anih te, “Camoe he caeh puei lamtah kai ham han cun, kamah loh na thapang kam paek bitni,” a ti nah. Te dongah manu loh camoe te a khuen tih a cun. ");
INSERT INTO hlt_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Camoe te a pantai phoeiah Pharaoh canu taengla a khuen. Te vaengah a capa la om tih a ming te Moses a sui tih, “Anih he tui dong lamlong ni ka doek,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","A khohnin loh a pha tih Moses khaw pantai coeng. Te dongah a manuca rhoek taengla pawk tih amih kah bitloh te a hmuh. Te vaengah a manuca Hebrew hlang mai Egypt hlang loh a ngawn pah te a hmuh. ");
INSERT INTO hlt_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Tedae heben hebang la a mael akhaw hlang te hmu pawh. Te dongah Egypt te a ngawn tih laivin khuiah a up. ");
INSERT INTO hlt_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","A hnin bae dongkah a mop vaengah tah Hebrew hlang rhoi te tarha ana hnuei uh rhoi. Te dongah aka halang te, “Balae tih na hui na ngawn?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Te vaengah, “Hlang khaw, Kaimih sokah mangpa neh laitloek la ulong nang ng'khueh, Egypt na ngawn bangla kai ngawn ham na cai nama?” a ti nah. Te dongah Moses loh a rhih coeng tih, “Dumlai khaw phoe taktak coeng,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Te ol te Pharaoh loh a yaak vaengah Moses te ngawn ham a mae. Tedae Moses tah Pharaoh mikhmuh lamloh yong tih Midian khohmuen ah kho a sak. Te vaengah tuito ah ngol hatah, ");
INSERT INTO hlt_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midian khosoih kah a canu parhih te ha pawk uh tih tui a dueh uh. Te phoeiah a napa kah boiva te tul ham tuisoi dongah a loei uh. ");
INSERT INTO hlt_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Te vaengah boiva aka dawn rhoek te ha pawk uh tih huta rhoek te a haek uh. Tedae Moses te thoo tih huta rhoek a rhun tih a boiva te tui a tul pah. ");
INSERT INTO hlt_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","A napa Reuel taengla a pawk uh vaengah, “Tihnin ah tah balae tih yue na pawk uh ,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Te vaengah, “Egypt hlang loh kaimih he boiva aka dawn rhoek kut lamloh n'huul. Te phoeiah tui pataeng kaimih ham han dueh han dueh tih boiva te a tul,” a ti nauh. ");
INSERT INTO hlt_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Te dongah a ca rhoek te, “Melae anih? Balae tih hlang te na hnoo uh? Anih te khue uh lamtah buh ca dae saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Hlang neh khosak ham khaw Moses loh a ueh van coeng dongah a canu Zipporah te Moses taengah a paek. ");
INSERT INTO hlt_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Te vaengah capa a cun pah hatah kholong kho ah yinlai la ka om a ti tih a ming te Gershom a sui. ");
INSERT INTO hlt_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","A tue muep a khum phoeiah tah Egypt manghai khaw duek. Te vaengah Israel ca rhoek te thohtatnah khui lamloh huei uh tih pang uh. Thohtatnah lamloh a pang uh te Pathen taengla cet. ");
INSERT INTO hlt_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Tedae Pathen loh amih kah nguekcoinah te a yaak tih Abraham taengkah, Isaak taengkah, Jakob taengkah a paipi te Pathen loh a poek. ");
INSERT INTO hlt_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Te dongah Pathen loh Israel ca rhoek te a hmuh tih amih te Pathen loh a ming. ");
INSERT INTO hlt_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moses tah a masae, Midian khosoih Jethro kah boiva aka luem puei la om. Te vaengah boiva te khosoek hael la a hmaithawn hatah Pathen kah tlang Horeb la pawk. ");
INSERT INTO hlt_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Te vaengah BOEIPA kah puencawn te anih taengah tangpuem khui lamkah hmairhong hmai neh a phoe pah. A sawt vaengah tangpuem te hmai loh a dom dae tangpuem te tlum pawh. ");
INSERT INTO hlt_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Te dongah Moses loh, “Ka nong vetih a hmuethma tanglue he ka hmu lah eh. Balae tih tangpuem ke a ung pawh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Hmuh hamla a nong te BOEIPA loh a hmuh. Te dongah Pathen loh anih te tangpuem khui lamkah a khue tih, “Moses, Moses,” a ti nah hatah, “Kai ni he ue ,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Te vaengah, “Hela ha mop boeh. Na khokhom te na kho dong lamloh dul dae, a soah na pai thil hmuen he hmuencim khohmuen ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Te phoeiah, “Kai tah na pa Pathen, Abraham Pathen, Isaak Pathen neh Jakob kah Pathen ni,” a ti nah. Te vaengah Moses loh a maelhmai a thuh tih Pathen te paelki ham khaw a rhih. ");
INSERT INTO hlt_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Te vaengah BOEIPA loh, “Egypt ah ka pilnam kah phacipphabaem te ka hmuh rhoe ka hmuh coeng tih anih aka tueihno mikhmuh kah a pangngawlnah te ka yaak. Te phoeiah a nganboh te ka ming coeng. ");
INSERT INTO hlt_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Egypt kut lamloh anih huul ham neh te khohmuen lamloh khohmuen then neh hubung khuila, suktui neh khoitui aka long khohmuen la, Kanaan neh Khitti, Amori neh Perizzi, Khivee neh Jebusi hmuen la thak ham ka suntla coeng. ");
INSERT INTO hlt_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Israel ca rhoek pangngawlnah loh kai taengla ha pawk coeng tih amih aka nen Egypt kah nennah khaw ka hmuh coeng he. ");
INSERT INTO hlt_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Pharaoh taengla nang kan tueih coeng dongah cet lamtah ka pilnam Israel ca rhoek te Egypt lamloh khuen laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Tedae Moses loh Pathen te, “Pharaoh taengla ka caeh ham neh Egypt lamloh Israel ca rhoek khuen ham khaw kai tah unim?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Te vaengah, “Nang taengah rhep ka om vetih he he nang ham miknoek coeng ni. Kai loh nang kan tueih coeng tih pilnam te Egypt lamloh na khuen vaengah he tlang ah Pathen te thothueng thil uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Tedae Moses loh Pathen taengah, “Israel ca rhoek taengla ka pawk tih amih te, 'Na pa rhoek kah Pathen loh nangmih taengla kai n'tueih,’ ka ti nah vaengah kai te, 'A ming ta?' ti uh koinih amih taengah balae ka thui eh? ' a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Pathen loh Moses taengah, “Ka om bangla ka om coeng,” a ti nah. Te phoeiah, “He Israel ca rhoek te, 'Akaom long ni nangmih taengla kai n'tueih,’ ti nah,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Te phoeiah Pathen loh Moses te, “He he Israel ca rhoek taengah, 'Na pa rhoek kah Pathen, Abraham kah Pathen, Isaak Pathen, Jakob Pathen BOEIPA loh kai he nangmih taengla n'tueih,’ ti nah. He tah kumhal kah kai ming ham neh Cadilcahma kah cadilcahma taengah kai poekkoepnah ni. ");
INSERT INTO hlt_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Cet lamtah Israel kah patong rhoek te coi laeh. Te phoeiah amih te, “Na pa rhoek kah Pathen BOEIPA te kai taengah phoe coeng. Abraham, Isaak neh Jakob kah Pathen loh, 'Nangmih neh nangmih taengah Egypt kah a saii te ka hip rhoe ka hip coeng. ");
INSERT INTO hlt_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Te dongah ni nangmih te Egypt kah phacipphabaem lamloh Kanaan neh Khitti, Amori neh Perizzi, Khivee neh Jebusi khohmuen la, suktui neh khoitui aka long khohmuen la kang khuen eh ka ti coeng. ");
INSERT INTO hlt_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Te vaengah na ol te a hnatun uh bitni. Namah neh Israel kah a hamca rhoek te Egypt manghai taengla cet uh. Te phoeiah anih te, 'Hebrew kah Pathen BOEIPA loh kaimih he m'mah coeng. Te dongah hnin thum long caeh kah khosoek ah BOEIPA ka Pathen te ka nawn mai pawn eh?,’ ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Tedae a tlungluen kut nen pawt atah na caeh ham khaw Egypt manghai loh nangmih m'pae mahpawh tila ka ming. ");
INSERT INTO hlt_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Te dongah ka kut he ka hlah vetih Egypt te ka ngawn ni. Kamah kah khobaerhambae cungkuem neh a khui ah ka saii daengah ni nangmih te n'tueih pueng eh. ");
INSERT INTO hlt_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Pilnam he Egypt mikhmuh ah mikdaithen la ka khueh vetih na caeh uh vaengah khaw kuttling la na cet uh mahpawh. ");
INSERT INTO hlt_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Te dongah huta loh a imben taeng neh a im kah aka bakuep taengah ngun hnopai neh sui hnopai khaw, himbai khaw hoe saeh. Te phoeiah tah na capa rhoek so neh na canu rhoek pum dongla khueh uh lamtah Egypt kah te huul pa uh,’ ti nah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Tedae Moses loh a doo tih, “Kai he n'tangnah uh pawt koinih kai ol he hnatun pawt vetih, 'Nang taengah BOEIPA a phoe moenih,’ a ti uh ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Te dongah amah te BOEIPA loh, “Na kut dongkah te balae?” a ti nah hatah, “Conghol,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Te phoeiah, “Te te diklai la voei lah,” a ti nah tih diklai la a voeih. Te vaengah rhul la a poeh pah dongah Moses khaw a taeng lamloh rhaelrham. ");
INSERT INTO hlt_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Tedae BOEIPA loh Moses te, “Na kut yueng lamtah a mai ah tu,” a ti nah. A kut a yueng tangloeng tih a tuuk vaengah tah a kut dongah conghol la poeh. ");
INSERT INTO hlt_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Te dongah a napa rhoek kah Pathen BOEIPA, Abraham Pathen, Isaak Pathen, Jakob Pathen tah nang taengah phoe tila a tangnah uh bitni. ");
INSERT INTO hlt_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Te phoeiah BOEIPA loh anih te, “Na kut te na rhang ah puei bal dae,” a ti nah. A kut te a rhang ah a puei tangloeng tih a yueh vaengah tah a kut te vuelsong bangla a pahuk pah. ");
INSERT INTO hlt_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Te phoeiah, “Na kut te na rhang ah koep puei lah,” a ti nah. A kut te a rhang ah a puei tangloeng tih a rhang lamloh a yueh vaengah tah a saa thim la tarha a om pah. ");
INSERT INTO hlt_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Nang te n'tangnah uh pawt akhaw ana om ngawn saeh. Lamhma kah miknoek ol te a yaak pawt atah a pabae kah miknoek ol te tangnah uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Tedae miknoek rhoi dongkah he khaw tangnah uh pawt tih na ol te a yaak uh pawt akhaw ana om saeh. Sokko lamkah tui te lo lamtah laiphuei te bueih pah. Sokko lamkah na loh tui te poehlip vetih laikoeng dongah thii la poeh ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Te vaengah Moses loh BOEIPA te, “Aw ka Boeipa, hlaem ah khaw, hlaemvai ah khaw na sal taengah na thui vaeng lamlong mah kai he olka dongah ka hlang voel moenih. Te dongah ka ka tonga tih ka ol khol,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Tedae BOEIPA loh amah te, “Hlang ham ka aka khueh pah te unim? Olmueh neh hnapang, miktueng neh mikdael aka khueh te unim? BOEIPA kamah moenih a? ");
INSERT INTO hlt_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Te dongah cet laeh lamtah nang kah hmuilai dongah kamah ka om vetih na thui ham te kan thuinuet bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Tedae, “Aw ka Boeipa, na tueih akhaw kuttoem mah tueih laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Te vaengah BOEIPA kah thintoek te Moses taengah sai tih, “Na manuca Aron te Levi moenih a? Ka ming ta, thui ham koi te anih loh a thui ta. Te dongah anih khaw nang doe ham ha lo coeng. Te vaengah nang m'hmuh vetih a lungbuei ah a kohoe bitni. ");
INSERT INTO hlt_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Anih te voek tangloeng lamtah olka he a hmuilai ah khueh pah. Kai he nang kah hmuilai dongah khaw anih kah hmuilai dongah khaw ka om vetih na saii ham te nang kan thuinuet bitni. ");
INSERT INTO hlt_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Te phoeiah anih te pilnam taengah nang yueng la cal saeh lamtah nang kah hmuilai la om rhoe om saeh. Nang ngawn tah anih taengah Pathen bangla na om ni. ");
INSERT INTO hlt_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Tedae he conghol he na kut dongah pom lamtah te nen te miknoek saii,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Te daengah Moses te cet tih a masae Jether taengla mael. Te phoeiah a masae taengah, “Ka cet pawn saeh lamtah Egypt kah ka manuca rhoek taengah ka mael mai eh. Amih kah hingnah khaw ka hmuh pueng khaming,” a ti nah. Te vaengah Jethro loh Moses te, “Sading la cet ne,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Te vaengah BOEIPA loh Midian kah Moses te, “Cet lamtah Egypt la mael laeh, nang kah hinglu aka mae hlang khaw boeih duek uh coeng,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Te dongah Moses loh a yuu neh a ca rhoek te a loh tih laak dongah a ngol sak. Tedae Egypt kho la a mael vaengah Moses loh Pathen kah conghol ni a kut dongah a pom. ");
INSERT INTO hlt_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Te vaengah BOEIPA loh Moses te, “Na caeh vaengah Egypt la mael. Na kut dongah kopoekrhai cungkuem kam paek te tueng. Te te Pharaoh mikhmuh ah saii pah. Tedae kai loh a lungbuei ka moem vetih pilnam te hlah mahpawh. ");
INSERT INTO hlt_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Tedae Pharaoh te thui pah. BOEIPA loh he ni a thui. Israel tah ka capa neh ka caming ni. ");
INSERT INTO hlt_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Te dongah namah taengah khaw ka thui coeng. Ka ca te tueih lamtah kai ham thothueng saeh. Tedae anih hlah ham na aal atah kai loh na capa khuikah na caming te ka ngawn ne,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Longpuei kah rhaehim ah a om vaengah anih te BOEIPA neh hum uh tih ngawn la cai. ");
INSERT INTO hlt_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Te vaengah Zipporah loh hmailung a loh tih a capa kah hmuicue te a hlueng pah. Te phoeiah a kho ah a net tih, “Nang tah kai ham thii dongkah yulokung ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Te daengah BOEIPA te Moses taeng lamloh nong. Te vaengah hmuicuerhetnah te ni thii dongkah yulokung la a thui. ");
INSERT INTO hlt_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Te phoeiah BOEIPA loh Aron taengah, “Khosoek la cet lamtah Moses te doe laeh,” a ti nah. A caeh tangloeng vaengah tah amah neh Pathen kah tlang ah hum uh tih a mok. ");
INSERT INTO hlt_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Te phoeiah Moses loh amah tueih tih miknoek cungkuem neh amah a uen bangla BOEIPA ol boeih boeih te Aaron hma te a thui pah. ");
INSERT INTO hlt_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moses neh Aaron te cet tih Israel ca a ham boeih te a coi rhoi. ");
INSERT INTO hlt_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Te phoeiah BOEIPA loh Moses taengkah a thui ol boeih te Aaron loh a thui pah tih pilnam mikhmuh ah miknoek khaw a tueng sak. ");
INSERT INTO hlt_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Pilnam loh a tangnah vaengah tah BOEIPA loh Israel ca a hip tih, amih kah phacipphabaem a hmuh pah te khaw a yaak uh dongah buluk uh tih a bawk uh. ");
INSERT INTO hlt_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Te phoeiah Moses neh Aaron te cet rhoi tih Pharaoh te, “Israel Pathen BOEIPA loh, 'Ka pilnam he hlah lamtah khosoek kah kamah taengah lam uh saeh,’ a ti,” a ti nah rhoi. ");
INSERT INTO hlt_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Tedae Pharaoh loh, “U BOEIPA nim a ol te ngai vetih Israel te ka hlah eh? BOEIPA te ka ming pawt dongah Israel te ka hlah mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Te phoeiah, “Hebrew rhoek kah Pathen loh kaimih te n'doe. Longpuei hnin thum caeh kah khosoek ah ka cet uh mai eh. BOEIPA ka Pathen te ka nawn uh pawn eh. Kaimih he duektahaw neh, cunghang neh n'cuuk tarha ve,” a ti nah rhoi. ");
INSERT INTO hlt_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Tedae Egypt manghai loh amih rhoi te, “Moses neh Aaron, balae tih pilnam te a bitat na hlahpham sak, namah bi la cet,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Te vaengah Pharaoh loh, “Khohmuen pilnam loh yet coeng tih amamih khaw a bitloh lamkah na kangkuen sak ke,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Te khohnin ah tah Pharaoh loh pilnam sokah aka tueihno rhoek neh a rhoiboei rhoek te a uen. ");
INSERT INTO hlt_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Hlaem hlaemvai kah bangla laiboeng aka saii pilnam te cangkong paek ham vaengah koei pa uh boeh. Amamih cet uh saeh lamtah amamih ham cangkong te coi uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Tedae laiboeng kah a lan a tang tah amih taengah hlaem hlaemvai kah, a saii bangla khueh uh lamtah yueh pah boeh. A duem uh ham tangloeng ni pang uh tangkhuet tih, 'Ka Pathen te nawn ham ka cet ni, ' a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Hlang rhoek ham thohtatnah loh a nan daengah ni te te a saii uh vetih laithae ol taengla a mang uh pawt eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Te phoeiah pilnam aka tueihno neh a rhoiboei rhoek te cet uh tih pilnam te a voek uh. Te vaengah, “Pharaoh loh, “Nangmih te cangkong kam pae mahpawh,’ a ti. ");
INSERT INTO hlt_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Namamih cet uh lamtah me lamkah a hmuh uh akhaw cangkong te namamih loh vawthaih uh. Tedae ol vanbangla na thohtatnah te hnop boeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Te vaengah pilnam te cangkong yueng la divawt coi ham Egypt kho tom ah taekyak uh. ");
INSERT INTO hlt_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Te vaengah aka tueihno rhoek loh a tanolh uh tih, “Cangkong a om vaengkah bangla hnin at kah na bi tueng hno te amah khohnin ah coeng uh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Amih sokah a khueh Pharaoh kah a tueihno rhoek loh Israel ca rhoek kah rhoiboei te a ngawn uh tih, “Hlaem hlavai kah bangla saii ham khaw hlaem neh tihnin kah khaw balae tih na oltlueh te na coeng uh pawh,” a ti na uh. ");
INSERT INTO hlt_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Te dongah Israel ca rhoek kah rhoiboei rhoek te cet uh tih Pharaoh taengah pang uh tih, “Balae tih na sal rhoek taengah he he na saii. ");
INSERT INTO hlt_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Na sal rhoek he cangkong m'paek pawt ah kaimih taengah laiboeng saii ham a thui uh. Na pilnam a tholh akhaw na sal rhoek ni n'ngawn uh coeng he,” a ti na uh. ");
INSERT INTO hlt_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Tedae, “Nangmih aka duem la aka duem rhoek, nangmih loh BOEIPA taengah hmueih nawn la caeh ham na thui tangkhuet. ");
INSERT INTO hlt_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Te dongah lcet uh lamtah thotat uh laeh. Nangmih te cangkong m'paek pawt akhaw laiboeng tah a rhimong hil pae uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","“Amah khohnin ah hnin at kah olka bangla na laiboeng te hnop boeh,” a ti coeng dongah amih loh a yoethae a puei te Israel ca kah rhoiboei rhoek loh a hmuh uh. ");
INSERT INTO hlt_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Pharaoh taeng lamloh a nong vaengah amih rhoi doe ham aka pai rhoek te Moses neh Aaron te a doo uh. ");
INSERT INTO hlt_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Te vaengah amih rhoi te, “BOEIPA loh nangmih te m'hmu lamtah laitloek nawn saeh. Mamih kah hmuehmuei te Pharaoh mik ah bo a rhim sak tih a sal rhoek mikhmuh ah mamih ngawn ham a kut ah cunghang a paek,” a ti rhoi. ");
INSERT INTO hlt_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Te dongah Moses te BOEIPA taengla mael tih, “Ka Boeipa aw, balae tih pilnam soah thae na huet? Balae tih he la kai nan tueih? ");
INSERT INTO hlt_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Na ming neh thui ham Pharaoh taengla ka pawk lamkah te pilnam he ni thae a huet thil tih na pilnam te na huul khaw na huul hae moenih,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","BOEIPA loh Moses te, “Pharaoh taengah ka saii ham te na hmuh pawn ni. Tlungluen kut he amih taengah a tueih vetih tlungluen kutloh amih te a khohmuen lamloh a haek ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Pathen loh Moses te a voek bal tih a taengah, “Kai tah Yahweh ni. ");
INSERT INTO hlt_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Abraham taengah, Isaak taeng neh Jakob taengah Tlungthang Pathen la ka phoe coeng dae ka ming te amih taengah Yahweh la ka ming sak moenih. ");
INSERT INTO hlt_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Te dongah Kanaan khohmuen te amih taengah paek hamla amih taengah ka paipi te ka thoh bal. A khuiah ana bakuep nah te a lampahnah khohmuen ni. ");
INSERT INTO hlt_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Kai loh Israel ca rhoek kah nguekcoinah te khaw ka yaak coeng. Egypt loh amih thohtat sak cakhaw ka paipi te ka poek. ");
INSERT INTO hlt_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Te dongah Israel ca rhoek te thui pah. Kai BOEIPA loh nangmih te Egypt bitloh hmui lamkah kan loh vetih amih kah thohtatnah lamloh nangmih te kang huul ni. Nangmih te ban ka yueng vetih tholhphu tanglue neh kan tlan ni. ");
INSERT INTO hlt_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nangmih te kamah taengah pilnam la kan loh vetih nangmih taengah Pathen la ka om ni. Te vaengah Egypt bitloh hmui lamloh nangmih aka khuen BOEIPA na Pathen kamah he nan ming uh bitni. ");
INSERT INTO hlt_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nangmih khaw te khohmuen la kang khuen ni. Te te paek ham ni ka kut he Abraham taeng neh Isaak taeng neh Jakob taengah ka thueng. Te dongah te te BOEIPA kamah loh khoh la nangmih taengah kam paek ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moses loh Israel loh ca rhoek taengah a thui dae mangkhak la thohtatnah neh mueihla kobawtnah dongah Moses ol te hnatun uh pawh. ");
INSERT INTO hlt_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Te vaengah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Paan lamtah Egypt manghai Pharaoh te thui, Israel ca rhoek te a khohmuen lamloh hlah laeh saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Tedae Moses loh BOEIPA mikhmuh ah rhep a thui tih, “Israel ca rhoek long pataeng kai ol he a hnatun uh moenih he. Te dongah kai tah ka hmuilai aka ngun he Pharaoh loh metlam kai ol a hnatun eh?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Te phoeiah BOEIPA loh Moses neh Aaron te a voek tih Israel ca kawng neh Egypt manghai Pharaoh kawng khaw, Egypt khohmuen lamloh Israel ca rhoek a khuen ham te khaw a uen. ");
INSERT INTO hlt_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Israel kah caming Reuben koca kah a napa imkhui kah a lu rhoek la Enok neh Khetsron Pallu neh Karmee tih, te rhoek te Reuben huiko la om. ");
INSERT INTO hlt_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeon koca ah Jemuel neh Jamin, Ohad neh Jakhin, Zohar neh Kanaan nu kah a capa Saul khaw om. He rhoek he Simeon kah huiko la om. ");
INSERT INTO hlt_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Amah rhuirhong dongah Levi koca rhoek a ming tah Gershon, Kohath neh Merari om. Levi kah a hingnah kum he kum ya sawmthum kum rhih lo. ");
INSERT INTO hlt_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershon koca ah Libni neh Shimei he amah huiko la om van. ");
INSERT INTO hlt_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohath koca ah Amram, Izhar, Hebron neh Uzziel om. Kohath kah a hingnah kum he kum ya sawmthum kum thum lo. ");
INSERT INTO hlt_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari koca rhoek la Mahli neh Mushi om tih Amah rhuirhong ah tah te rhoi khaw Levi kah huiko la om. ");
INSERT INTO hlt_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram loh a napi Jokhebed te a yuu la a loh tih Aaron neh Moses a cun pah. Amram a hingnah kum he kum ya sawmthum kum rhih lo. ");
INSERT INTO hlt_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izhar koca ah Korah, Nepheg neh Zikhri. ");
INSERT INTO hlt_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzziel koca Mishael, Elizaphan neh Sithri. ");
INSERT INTO hlt_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron loh Amminadab canu, Nahshon ngannu Elisheba te a yuu la a loh tih Nadab, Abihu, Eleazar neh Ithamar a sak pah. ");
INSERT INTO hlt_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Korah kah koca ah Assir, Elkanah neh Abiasaph tih, te rhoek te Korah kah cako la om uh. ");
INSERT INTO hlt_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaron capa Eleazar loh Putiel nu te a yuu la a loh tih Phinekha te a sak. Te rhoek te amah huiko ah Levi napa kah patuel la om. ");
INSERT INTO hlt_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","BOEIPA loh Aaron neh Moses te, “Israel ca rhoek te Egypt kho lamloh a caempuei la khuen laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Israel ca te Egypt lamloh khuen ham Egypt manghai Pharaoh taengah aka thui khaw amih rhoi Moses neh Aaron ni. ");
INSERT INTO hlt_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","BOEIPA loh Moses a voek hnin ah Egypt kho ah om coeng. ");
INSERT INTO hlt_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Te vaengah BOEIPA loh Moses te a voek tih, “Kai tah Yahweh ni, kai loh nang taengah ka thui boeih te Egypt manghai Pharaoh taengah thui pah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Tedae Moses loh BOEIPA mikhmuh ah, “Kai hmuilai aka ngun he Pharaoh loh kai ol te metlam a hnatun pai eh?,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","BOEIPA loh Moses te, “So lah, nang te Pharaoh taengah Pathen la kang khueh tih na maya Aaron te nang kah tonghma la om coeng. ");
INSERT INTO hlt_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Nang kang uen boeih te namah loh thui lamtah na maya Aaron loh Pharaoh taengah thui saeh. Te vaengah Israel ca rhoek te a khohmuen lamloh a hlah bitni. ");
INSERT INTO hlt_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Tedae kai loh Pharaoh kah lungbuei te ka mangkhak sak vetih ka miknoek neh kai kah kopoekrhai he Egypt khohmuen ah ka ping sak ni. ");
INSERT INTO hlt_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Te lalah nang ol te Pharaoh loh hnatun pawt cakhaw ka kut he Egypt soah ka hlah ni. Te vaengah tholhphu tanglue a paek rhangneh ka pilnam Israel ca Egypt khohmuen lamloh ka caempuei la ka khuen ni. ");
INSERT INTO hlt_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Egypt te ka kut ka hlah thil tih Israel ca te amih khui lamloh ka khuen vaengah Egypt loh kai he BOEIPA la a ming uh bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","A saii vaengah khaw BOEIPA kah a uen banglam ni Moses neh Aaron loh amih taengah a saii rhoi. ");
INSERT INTO hlt_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Pharaoh taengah a voek rhoi vaengah he Moses te kum sawmrhet lo ca tih Aaron te kum sawmrhet kum thum lo ca coeng. ");
INSERT INTO hlt_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","BOEIPA loh Moses neh Aaron te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Pharaoh loh nangmih te m'voek tih, 'Nangmih kah kopoekrhai tueng sak,’ a ti. Te vaengah Aaron te,’ Na conghol te khuen laeh. Te phoeiah Pharaoh mikhmuh ah tloeng lamtah tuihnam la poeh bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Te dongah Moses neh Aaron te Pharaoh taengah cet rhoi tih BOEIPA loh a uen vanbangla a saii rhoi. Te vaengah Aaron loh a conghol te Pharaoh mikhmuh neh a sal rhoek mikhmuh ah a voeih pah tih tuihnam la poeh. ");
INSERT INTO hlt_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Pharaoh long khaw hlangcueih neh hlangbi rhoek te a khue. Amih Egypt hmayuep rhoek long khaw amamih kah hmaitak neh phek a saii uh. ");
INSERT INTO hlt_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Hlang loh a conghol tah a voeih uh tih tuihnam la poeh ngawn dae Aaron kah conghol loh amih kah conghol te a dolh pah. ");
INSERT INTO hlt_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Te phoeiah Pharaoh kah lungbuei tah mangkhak pueng tih BOEIPA kah a thui bangla amih rhoi ol te hnatun pawh. ");
INSERT INTO hlt_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Te phoeiah BOEIPA loh Moses te, “Pharaoh kah lungbuei tah thah tih pilnam te hlah ham a aal. ");
INSERT INTO hlt_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Pharaoh te mincang ah a paan rhoi. Tui taengla a pawk vaengah sokko soktaeng ah anih tong ham ana pai rhoi ne. Te vaengah rhul la aka poeh conghol te na kut dongah khuen rhoi. ");
INSERT INTO hlt_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Te phoeiah anih te , 'Hebrew kah Pathen Yahweh loh nang taengah kai he n'tueih tih, 'Ka pilnam te tueih lamtah khosoek ah kai ham thothueng uh saeh,’ a ti. Tedae tahae duela na hnatun moenih ko he. ");
INSERT INTO hlt_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","BOEIPA loh he ni a thui. He nen ni kai he BOEIPA la na ming eh. Ka kut dongkah conghol neh sokko kah tui te ka boh vetih thii la poeh pawn ni he. ");
INSERT INTO hlt_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Sokko kah nga te duek vetih sokko te rhim ni. Sokko lamkah tui a ok ham vaengah Egypt rhoek te khobing uh ni,’ ti nah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","BOEIPA loh Moses taengah, “Aaron te, 'Na conghol khuen lamtah Egypt tui so neh a tuiva soah, a sokko so neh a tuibap ah, a tui tungnah boeih soah na kut thueng pah. Te vaengah thii la poeh vetih Egypt khohmuen tom ah thing khuikah neh lungto khuikah khaw thii la poeh ni, 'ti nah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moses neh Aaron loh BOEIPA kah a uen bangla a saii rhoi. Conghol te a thueng tih Pharaoh mikhmuh neh a sal rhoek mikhmuh ah sokko kah tui te a boh. Te vaengah sokko kah tui boeih te thii la poeh. ");
INSERT INTO hlt_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Te vaengah sokko kah nga khaw duek tih sokko te rhim coeng. Te dongah Egypt rhoek loh sokko lamkah tui ok ham coeng voel pawh. Egypt khohmuen tom ah thii om. ");
INSERT INTO hlt_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Tedae Egypt hmayuep rhoek long khaw a tuisiduei neh a saii uh van. Te dongah Pharaoh kah lungbuei mangkhak tih BOEIPA kah a thui bangla amih rhoi ol te hnatun pawh. ");
INSERT INTO hlt_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pharaoh te mael tih amah im la a pawk phoeiah tah he he a lungbuei ah dueh pawh. ");
INSERT INTO hlt_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Sokko tui te ok ham a coeng pawt dongah, ok ham tui te Egypt pum loh sokko kaepvai ah a too. ");
INSERT INTO hlt_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","BOEIPA loh sokko a ngawn te ahnukah hnin rhih a cup sak. ");
INSERT INTO hlt_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Te phoeiah BOEIPA loh Moses te, “Pharaoh taengah cet lamtah anih te, 'BOEIPA loh ka pilnam te hlah lamtah kai taengah thothueng saeh,’ a ti. ");
INSERT INTO hlt_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Tedae hlah ham na aal atah na khorhi boeih ah bukak kan yok sak coeng ne. ");
INSERT INTO hlt_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Bukak te sokko ah kah vetih ha luei ni. Te vaengah na im khui neh imhman kah na thingkong dongah, na baiphaih dongah, na sal im khui neh na pilnam soah, na tapkhuel khui neh na vaidambael khuila kun ni. ");
INSERT INTO hlt_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Namah so neh na pilnam soah khaw na sal boeih soah khaw bukak luei ni, 'ti nah,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Te phoeiah BOEIPA loh Moses te, “Aaron te na kut thueng lamtah na conghol neh tuiva soah khaw, sokko soah khaw, tuibap soah khi laeh,'ti nah. Te vaengah bukak te Egypt khohmuen ah ha luei saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Te dongah Aaron loh a kut te Egypt tui soah a thueng. Te vaengah bukak ha luei tih Egypt khohmuen te a khuk. ");
INSERT INTO hlt_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Tedae hmayuep loh a tuisiduei neh phek a saii uh tih bukak te Egypt kho la luei van. ");
INSERT INTO hlt_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Te vaengah Pharaoh loh Moses neh Aaron te a khue tih, “BOEIPA taengah thangthui lamtah bukak he kai lamkah neh ka pilnam taeng lamlong khaw nong sak saeh. Te vaengah pilnam te ka tueih vetih BOEIPA taengah hmueih a nawn uh bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Te phoeiah Moses loh Pharaoh te, “Kai ham mah hoep dae. Nang ham neh na sal rhoek ham, na pilnam ham khaw, bukak te namah neh na im lamloh a hnawt tih sokko ah dawk a om ham me vaengah lae thangthui eh?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","“Thangvuen ah,” a ti nah dongah, “Na ol bangla kaimih kah Pathen Yahweh bang a om pawt khaw na ming van bitni. ");
INSERT INTO hlt_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Te vaengah bukak te nang lamkah neh na im lamlong khaw, na sal rhoek taeng lamkah neh na pilnam taeng lamloh nong vetih sokko ah ni dawk a om eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Te phoeiah Moses neh Aaron te Pharaoh taeng lamloh nong tih Pharaoh sokah a khueh olka, bukak kawng te Moses loh BOEIPA taengah a pang pah. ");
INSERT INTO hlt_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Moses kah ol bangla BOEIPA loh a saii dongah bukak te im ah khaw, vongup ah khaw, lohma ah khaw duek. ");
INSERT INTO hlt_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Te te a hlom a hlom la a hmoek uh tih khohmuen tom ah rhim. ");
INSERT INTO hlt_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","A hmuh daengah Pharaoh te hilhoemnah a om pah. Tedae a lungbuei a thangpom tih BOEIPA kah a thui bangla amih rhoi ol te hnatun pawh. ");
INSERT INTO hlt_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Te phoeiah BOEIPA loh Moses taengah, “Aaron te, 'Na conghol thueng lamtah diklai kah laipi te taam. Te vaengah Egypt khohmuen boeih ah pilhlip la om ni, 'ti nah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","A saii rhoi tangloeng tih Aaron loh a kut te a thueng. A conghol neh diklai dongkah laipi te a taam vaengah pilhlip te hlang pum dong neh rhamsa dongah om. Diklai laipi boeih te Egypt kho tom ah pilhlip la poeh. ");
INSERT INTO hlt_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Tedae hmayuep rhoek long khaw pilhlip om sak ham a thaai neh a saii uh van tangloeng. Tedae pilhlip te hlang dong neh rhamsa dongah khaw om thai pawh. ");
INSERT INTO hlt_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Te vaengah ah hmayuep rhoek loh Pharaoh taengah, “Pathen kah kutdawn la he,” a ti uh. Tedae Pharaoh lungbuei tah ning tih BOEIPA kah a thui bangla amih rhoi ol te hnatun pawh. ");
INSERT INTO hlt_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Te phoeiah BOEIPA loh Moses te, “Mincang ah thoo lamtah Pharaoh mikhmuh ah pai pah. Tui taengla a pawk vaengah amah te, 'BOEIPA loh, 'Ka pilnam he hlah lamtah kai ham thothueng uh saeh,’ a ti coeng he. ");
INSERT INTO hlt_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Tedae ka pilnam te nan hlah pawt atah namah so neh na sal rhoek soah khaw, na pilnam so neh na im ah khaw pil ka tueih coeng ne. Te dongah pil te Egypt imkhui neh amih kah a diklai dongah khaw bae ni. ");
INSERT INTO hlt_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Tedae te khohnin ah Goshen khohmuen kah ka pilnam te ka hoep vetih a khuikah aka om te pil om pah mahpawh. Te daegah ni diklai hman ah kai he BOEIPA la nan ming eh. ");
INSERT INTO hlt_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ka pilnam laklo neh na pilnam laklo ah tlannah ka khueh vetih miknoek he thangvuen ah thoeng bitni,’ ti nah,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","BOEIPA loh a saii tangkhuet tih Pharaoh im khui neh a sal im neh Egypt khohmuen boeih ah pil tlung ha pawk. Pil dongah mah khohmuen khaw poci. ");
INSERT INTO hlt_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Te phoeiah Pharaoh loh Moses neh Aaron te a khue tih, “Cet uh lamtah khohmuen ah na Pathen te nawn uh laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Tedae Moses loh, “Egypt kah tueilaehkoi dongah he he saii ham a thuem moenih. Kaimih kah Pathen BOEIPA ham ka nawn uh vaengah Egypt lamkah tueilaehkoi te ka nawn uh koinih amih mikhmuh ah kaimih n'dae uh mahpawt nim? ");
INSERT INTO hlt_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kaimih n'uen bangla hnin thum long caeh kah khosoek ah kaimih kah Pathen BOEIPA te ka nawn uh eh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Te phoeiah Pharaoh loh, “Kai loh nangmih kan hlah bitni , khosoek ah na Pathen BOEIPA te nawn tangloeng. Tedae a hla, hla la cet uh boel lamtah kai ham khaw thangthui uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Te vaengah Moses loh, “Nang taeng lamloh ka nong vetih BOEIPA taengah ka thangthui bitni. Pil khaw Pharaoh neh a sal rhoek taeng lamloh, a pilnam taeng lamloh thangvuen ah nong bitni ne. Tedae Pharaoh te omsaa ham koei boel saeh, pilnam te BOEIPA taengah nawn hamla tueih pawt ve,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Te phoeiah Moses te Pharaoh taeng lamloh nong tih BOEIPA taengah thangthui. ");
INSERT INTO hlt_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Moses kah ol bangla BOEIPA loh a saii dongah pil te Pharaoh taeng lamkah neh a sal rhoek taeng lamloh, a pilnam taeng lamloh nong tih pakhat khaw om pawh. ");
INSERT INTO hlt_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Tedae tahae tue ah khaw Pharaoh te a lungbuei a thangpom tih pilnam te tueih pawh. ");
INSERT INTO hlt_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","BOEIPA loh Moses te, “Pharaoh taengah cet lamtah anih te thui pah. Hebrew kah Pathen Yahweh loh he ni a thui. Ka pilnam te hlah lamtah kai ham thothueng uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Tedae hlah ham na aal tih amih te na yuengyet pueng atah, ");
INSERT INTO hlt_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","BOEIPA kut te lohma kah na boiva soah, marhang soah, laak soah, kalauk soah, saelhung soah tla vetih boiva dongah duektahaw la muep tlung ne. ");
INSERT INTO hlt_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Tedae BOEIPA loh Israel kah boiva laklo neh Egypt kah boiva laklo ah a hoep vetih Israel ca rhoek kah boeih tah ol nen pataeng duek pah mahpawh. ");
INSERT INTO hlt_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","BOEIPA loh thangvuen ah thui hamla khoning a khueh coeng. He kah hno he BOEIPA loh khohmuen ah a saii ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Tekah BOEIPA loh ol te a vuen ah a thoeng sak. Te dongah Egypt kah boiva tah boeih duek. Tedae Israel ca rhoek kah boiva tah pakhat khaw duek pawh. ");
INSERT INTO hlt_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Te vaengah Pharaoh loh hlang a tueih akhaw Israel kah boiva tah pakhat pataeng a duek moenih ne. Tedae Pharaoh lungbuei te a thangpom pueng tih pilnam te hlah pawh. ");
INSERT INTO hlt_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Te phoeiah BOEIPA loh Moses neh Aaron te, “Hmailing khangvai te namamih rhoi ham na kutnarhum a bae lo rhoi lamtah Moses loh Pharaoh mikhmuh ah vaan la haeh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Te vaengah Egypt kho tom ah laipi la poeh vetih, Egypt khohmuen boeih kah hlang so neh rhamsa dongah buhlut la om a hnai neh phuem ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Te dongah hmailing khangvai te a loh rhoi tih Pharaoh mikhmuh ah pai rhoi. Te te Moses loh vaan la a haeh tih buhlut la poeh tih hlang pum dong neh rhamsa dongah a hnai a coe pah. ");
INSERT INTO hlt_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Te vaengah hmayuep rhoek tah buhlut dongah Moses mikhmuh la pai ham noeng uh pawh. Buhlut te hmayuep rhoek so neh Egypt pum soah a om pah. ");
INSERT INTO hlt_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Tedae BOEIPA loh Pharaoh kah lungbuei te a moem pah dongah BOEIPA loh Moses taengah a thui bangla amih rhoi ol te hnatun pawh. ");
INSERT INTO hlt_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Te phoeiah BOEIPA loh Moses taengah, “Mincang ah thoo lamtah Pharaoh mikhmuh ah pai pah. Te vaengah anih te thui pah. Hebrew kah Pathen Yahweh loh he ni a thui. Ka pilnam he hlah lamtah kai ham thothueng saeh. ");
INSERT INTO hlt_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Tahae voei khat la kai kah lucik cungkuem te na lungbuei neh na sal rhoek taengah, na pilnam taengah kan tueih. Te nen ni diklai pum ah kamah bang a om pawt te na ming eh. ");
INSERT INTO hlt_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ka kut he ka hlah tih namah neh na pilnam te duektahaw neh kang ngawn coeng dongah diklai lamloh na pat pawn ni. ");
INSERT INTO hlt_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","He kong dongah ka thadueng na phoe ham ni nang kam pai sak. Te dongah ka ming he diklai pum ah thui ham om. ");
INSERT INTO hlt_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Amih hlah pawt ham te ka pilnam taengah na picai uh pueng. ");
INSERT INTO hlt_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Thangvuen a tue vai khat tah rhael muep kan tlan sak khungdaeng pueng ni he. Te bang te a suen khohnin lamloh tahae hil khaw Egypt ah a om moenih. ");
INSERT INTO hlt_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Te dongah tueih lamtah na boiva neh na taengkah boeih te khaw, khohmuen kah hlang boeih neh lohma kah a hmuh rhamsa khaw bakuep sak laeh. Im la a coi pawt te rhael loh a tlak thil vetih duek ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Pharaoh sal rhoek khuikah BOEIPA ol aka rhih long tah a sal rhoek neh a boiva khaw im la a rhaelrham puei. ");
INSERT INTO hlt_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Tedae BOEIPA ol te a lungbuei ah aka khueh pawt long tah a sal neh a boiva te lohma ah a hnoo. ");
INSERT INTO hlt_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","BOEIPA loh Moses taengah, “Na kut te vaan la thueng lamtah Egypt khohmuen boeih ah hlang so neh rhamsa soah khaw, Egypt diklai kah khohmuen baelhing boeih soah rhael tla bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moses loh a conghol te vaan la a thueng tangloeng vaengah BOEIPA loh a ol neh rhael neh a tueih tih hmai khaw diklai la cet. Te vaengah BOEIPA loh Egypt khohmuen ah rhael a tlan sak. ");
INSERT INTO hlt_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Rhael a tlak vaengah rhael lakli ah hmai khaw muep hli khungdaeng. Namtom taengah aka om parhi te Egypt khohmuen tom ah te bang a om noek moenih. ");
INSERT INTO hlt_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Egypt kho tom ah rhael loh lohma kah boeih, hlang lamloh rhamsa hil khaw a ngawn. Khohmuen baelhing boeih te rhael loh a ngawn tih khohmuen thingkung boeih a khong. ");
INSERT INTO hlt_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Israel ca rhoek kah Goshen khohmuen bueng ah ni rhael a tlak pawh. ");
INSERT INTO hlt_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Te vaengah Pharaoh loh ol a tah tih Moses neh Aaron te a khue. Te phoeiah amih rhoi te, “Ka tholh bal coeng, BOEIPA he dueng ngawn dae kamah neh ka pilnam ni aka halang coeng. ");
INSERT INTO hlt_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","BOEIPA taengah thangthui rhoi laeh. Pathen kah ol neh rhael a tlak khaw yet coeng. Nangmih te kan tueih daengah nan pai thil ham te na khoep pawt eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Te vaengah Moses loh anih te, “Khopuei he ka nong tak tih BOEIPA taengah ka kut ka phuel ni. Ol khaw paa tih rhael koep a bo pawt daengah ni diklai he BOEIPA ham ni tila na ming eh. ");
INSERT INTO hlt_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Tedae namah neh na sal rhoek loh BOEIPA Pathen mikhmuh ah na rhih uh hlan tila ka ming. ");
INSERT INTO hlt_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Thut neh cangtun neh khaw cangtun vueilue neh thut muem khaw a ngawn coeng. ");
INSERT INTO hlt_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Tedae cang neh cangkuem tah a hnong pueng dongah ngawn pawh. ");
INSERT INTO hlt_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moses loh Pharaoh taeng lamkah khopuei a nong tak tih BOEIPA taengah a kut a phuel. Te daengah rhaek ol neh rhael khaw paa tih khotlan loh khohmuen ah bo pawh. ");
INSERT INTO hlt_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Khotlan neh rhael neh ol paa coeng tila Pharaoh loh a hmuh van neh tholh te a khoep tih amah neh a sal rhoek loh a lungbuei a thangpom. ");
INSERT INTO hlt_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Te dongah Pharaoh lungbuei tah ning tih BOEIPA loh Moses kut ah a uen bangla Israel ca hlah pawh. ");
INSERT INTO hlt_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","BOEIPA loh Moses te, “Pharaoh te paan laeh, a khui ah ka miknoek ka khueh ham dongah ni amah lungbuei neh a sal rhoek kah lungbuei khaw ka thangpom sak. ");
INSERT INTO hlt_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Te daengah ni na ca rhoek neh na ca kah a ca hna dongah Egypt te ka poelyoe tih amih taengah ka miknoek ka khueh te na tae uh vetih tite kai he Yahweh la nan ming uh eh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Te dongah Moses neh Aaron te Pharaoh taengah cet tih anih te, “Hebrew kah Pathen BOEIPA loh he ni a thui. Me hil nim ka mikhmuh ah yalh ham na aal ve, ka pilnam te hlah lamtah kai ham thothueng uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Tedae ka pilnam te hlah ham na aal atah na khorhi la thangvuen ah kaisih kang khuen ni ne. ");
INSERT INTO hlt_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Te vaengah diklai hman he a thing vetih lai he tueng thai mahpawh. Rhael lamloh nangmih taengah aka sueng rhalyong hlangrhuel han caak vetih khohmuen ah nangmih ham aka duei thingkung boeih khaw a caak ni. ");
INSERT INTO hlt_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Namah im neh na sal boeih kah im ah khaw, Egypt pum kah im ah khaw bae ni. Diklai ah a om uh hnin lamloh tahae khohnin duela na pa rhoek neh na pa kah a napa rhoek loh a hmuh uh noek moenih,” a ti nah rhoi. Te phoeiah mael rhoi tih Pharaoh taeng lamloh nong rhoi. ");
INSERT INTO hlt_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Te vaengah Pharaoh kah sal rhoek loh a taengah, “Me hil nim mamih taengah hlaeh la a om ve he. tongpa rhoek te tueih mai lamtah a Pathen Yaweh taengah thothueng uh saeh, Egypt a rhawp coeng he na ming hlan nim?” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Te dongah Moses neh Aaron te Pharaoh taengla a mael puei uh tih amih rhoi te, “Cet uh lamtah na Pathen Yahweh taengah thothueng uh. Tedae ubang ubang lae a caeh eh?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Te phoeiah Moses loh, “Camoe neh patong khaw ka cet uh vetih, ka capa neh ka canu khaw, ka boiva neh ka saelhung neh ka BOEIPA kah khotue te ka paan uh ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Te phoeiah amih rhoi te, “BOEIPA te nangmih taengah om tangloeng saeh. Nangmih neh na camoe rhoek te kan hlah sitoe cakhaw na maelhmai ah boethae phaeng tueng. ");
INSERT INTO hlt_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Te tlam moenih. Te te na hoe uh dongah tongpa rhoek te cet uh lamtah BOEIPA taengah thothueng uh laeh,” a ti nah tih amih rhoi te Pharaoh mikhmuh lamloh a haek. ");
INSERT INTO hlt_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Te phoeiah BOEIPA loh Moses te, “Kaisih ham te Egypt khohmuen ah na kut thueng laeh. Te vaengah Egypt Khohmuen ah pongpa vetih rhael loh a hlun boeih neh khohmuen baelhing boeih te a caak bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Te dongah Moses loh a conghol te Egypt khohmuen la a thueng. Te vaengah BOEIPA loh khothoeng yilh te khohmuen sola khohnin yung neh khoyin puet ah a thawn pah. Mincang a pha vaengah kanghawn yilh loh kaisih a khuen pah. ");
INSERT INTO hlt_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Kaisih khaw Egypt khohmuen tom ah van tih Egypt khorhi boeih ah bop. A mikhmuh ah tlung khungdaeng coeng tih te bang kaisih te ana om noek pawt tih te hnukah khaw om bal mahpawh. ");
INSERT INTO hlt_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Diklai hman te boeih a thing tih diklai khaw hmuep. Diklai baelhing boeih neh rhael loh a hlun thing thaih boeih te a caak. Te dongah thing hing neh lohma baelhing boeih tah Egypt khohmuen tom ah sueng voel pawh. ");
INSERT INTO hlt_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Te vaengah Pharaoh tah Moses neh Aaron te khue hamla tokthuet tih, “Na Pathen Yahweh teang neh nangmih taengah ka tholh coeng. ");
INSERT INTO hlt_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Te dongah ka tholhnah he phuei mai laeh. Na Pathen BOEIPA taengah vai mah thangthui rhoi lamtah dueknah he khaw kai taeng lamloh nong sak saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Te dongah Pharaoh taeng lamloh nong rhoi tih BOEIPA taengah a thangthui pah. ");
INSERT INTO hlt_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Te vaengah BOEIPA loh khotlak yilh te bahoeng a tlungluen la a maelh tih kaisih te a khuen. Carhaek tuipuei la a yawn tih Egypt khorhi tom ah kaisih pakhat khaw hlun pawh. ");
INSERT INTO hlt_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Tedae BOEIPA loh Pharaoh lungbuei te te a moem pah dongah Israel ca rhoek te hlah pawh. ");
INSERT INTO hlt_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Te vaengah BOEIPA loh Moses te, “Vaan la na kut thueng lamtah a hmuep loh Egypt khohmuen a tlak thil vaengah a hmuep te phatuem saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Te dongah Moses loh a kut te vaan la a thueng tih Egypt khohmuen boeih te khohmuep hmaisuep loh hnin thum a khuk. ");
INSERT INTO hlt_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Hlang loh a manuca khaw hmu pawt tih hlang he amah lamloh hnin thum khuiah thoo uh voel pawh. Tedae Israel ca boeih ham tah a tolrhum ah vangnah om. ");
INSERT INTO hlt_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Te phoeiah Pharaoh loh Moses te a khue tih, “Cet uh lamtah BOEIPA taengah thothueng uh. Tedae na boiva neh na saelhung te khueh lamtah na ca rhoek khaw namamih neh cet uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Tedae Moses loh, “Namah long khaw kaimih kut ah hmueih neh hmueihhlutnah te nam paek uh daengah man ka Pathen Yahweh te ka nawn uh thai ve. ");
INSERT INTO hlt_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Te dongah ka boiva khaw kamamih neh ka puei uh vetih a khomae pataeng hlun mahpawh. Kaimih kah Pathen Yahweh taengah thothueng ham vaengah te khui lamkah ni ka loh uh eh. Tedae te la ka pawk uh hlan atah BOEIPA taengah metla thothueng ham khaw ka ming uh moenih,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","BOEIPA loh Pharaoh lungbuei te a moem pah dongah amih te hlah ham huem pawh. ");
INSERT INTO hlt_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Te dongah anih te Pharaoh loh, “Kai taeng lamloh nong laeh, nang te ngaithuen, ka maelhmai hmuh ham koei voel boeh, ka maelhmai na hmuh hnin ah na duek ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Te dongah Moses loh, “Na thui bangla na maelhmai hmuh ham koep ka khoep mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","BOEIPA loh Moses te, “Pharaoh so neh Egypt soah tloh pakhat ka khuen pueng ni. Te phoeiah nangmih te he lamloh n'hlah vetih n'tueih vaengah khaw a boeih hil nangmih te he lamloh m'haek rhoe n'haek ni. ");
INSERT INTO hlt_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Pilnam hna ah thui pah laeh. Te daengah ni ngun hnopai neh sui hnopai he tongpa loh a hui taengah, huta long khaw amah hui taengah a hoe thai eh. ");
INSERT INTO hlt_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","BOEIPA loh pilnam te Egypt mikhmuh ah mikdaithen la a khueh. Moses khaw Egypt kho kah Pharaoh sal mikhmuh neh pilnam mikhmuh ah hlang tanglue la bahoeng a poek. ");
INSERT INTO hlt_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Te dongah Moses loh, “BOEIPA loh he ni a thui. Khoyin pathung ah Egypt khui la ka pawk ni. ");
INSERT INTO hlt_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Te vaengah Egypt Egypt kho kah caming boeih tah, a ngolkhoel dongah aka ngol Pharaoh caming lamloh kuelhsum taengah aka ngol salnu caming neh rhamsa caming boeih te duek ni. ");
INSERT INTO hlt_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Egypt kho tom ah pangngawlnah bahoeng om ni. Te bang te om vai pawt tih te bang te koep khoep mahpawh. ");
INSERT INTO hlt_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Tedae Israel ca boeih taengah tah ui long pataeng hlang neh rhamsa te a ol neh naak mahpawh. Te daengah ni BOEIPA loh Egypt laklo neh Israel laklo ah a hoep tila na ming uh eh. ");
INSERT INTO hlt_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Na sal rhoek boeih he kai taengah ha suntla uh vetih, 'Namah neh na kho kung kah pilnam boeih te khuen,” aka ti ham ka taengah a bakop uh daengah ni ka nong eh?,” a ti nah tih Pharaoh taeng lamloh thintoek thinling neh nong. ");
INSERT INTO hlt_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Te phoeiah BOEIPA loh Moses te, “Egypt kho ah kai kah kopoekrhai te ping sak ham ni Pharaoh loh nangmih rhoi ol a hnatun pawt eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moses neh Aaron loh kopoekrhai cungkuem he Pharaoh mikhmuh ah a saii rhoi tangloeng dae Pharaoh lungbuei te BOEIPA loh a moem pah pueng dongah Israel ca te a khohmuen lamloh hlah pawh. ");
INSERT INTO hlt_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","BOEIPA loh Moses neh Aaron te Egypt kho ah a voek. ");
INSERT INTO hlt_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Tahae hla he nangmih ham hla kungpuei neh kum dongkah hla khuiah khaw nangmih ham lamhmala om ni. ");
INSERT INTO hlt_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Israel rhaengpuei boeih taengah thui lamtah, 'Tahae kah hla rha dongah tah hlang long he a napa im ham tu pakhat, te pawt atah im pakhat ham tu pakhat tah amamih taengla lo uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Tu aka om lakah imkhui a vaitah atah a im neh aka yoei a imben taengah lo saeh. Hlang kah hinglu tarhing neh aka ca tarhing ah tu te boesoep pah. ");
INSERT INTO hlt_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Boiva te a tal a hmabuet, kum khat aka lo ca te tah tuca khaw maae khaw namamih taengla lo uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Te phoeiah tahae hla hnin hlai li hil tuemkoi la nangmih taengah om vetih kholaeh ah Israel rhaengpuei hlangping boeih loh te te ngawn uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Te phoeiah a thii te lo uh saeh lamtah rhungsut so rhoi neh im kah danglo dongah pae uh saeh. A pum te a khuiah ca uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Maeh te khoyin ah hmai dongkah maehkaeh la ca uh saeh lamtah vaidamding neh ankhaa caak thil uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","A haeng lam khaw, tui neh a thong tih a hmin te lamkhaw ca uh boeh. Tedae a lu neh a kho, a kotak khaw hmai a kaeh ni na caak eh. ");
INSERT INTO hlt_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Te te mincang hil paih boeh, mincang hil aka coih pueng te tah hmai neh hoeh uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Te te he tlam he ca uh. Na cinghen yen uh lamtah na khokhom te na kho dongah buen uh. Na conghol te na kut dongah pom uh. BOEIPA kah Yoom he thintawn la ca uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Te khoyin ah Egypt khohmuen long ka pah vetih, Egypt kho kah caming boeih tah hlang lamloh rhamsa hil pataeng ka ngawn ni. Te vaengah BOEIPA kamah loh Egypt pathen boeih soah tholhphu ka thung ni. ");
INSERT INTO hlt_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Thii he nangmih ham im dongah miknoek la om ni. Nangmih taengah thii te ka hmuh vaengah nangmih te kang kang vetih Egypt khohmuen ka ngawn vaengah khaw kutcaihnah tlohthae te nangmih ah om mahpawh. ");
INSERT INTO hlt_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Te phoeiah he khohnin he nangmih ham poekkoepnah la om saeh. Te vaengah BOEIPA taengah khotue neh lam uh. Na lam uh te na cadilcahma ham kumhal khosingla om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Hnin rhih khuiah vaidamding ca uh. A cuek hnin ah tolrhu te na im lamloh toeng uh. Tolrhu aka ca boeih tah a hinglu te a cuek hnin lamloh a rhih hnin due Israel lamloh khoe saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","A cuek khohnin kah a cim tingtunnah neh a rhih hnin kah a cim tingtunnah te nangmih ham om ni. Te vaengah bitat boeih he saii boel saeh. Tedae nangmih khuikah hinglu boeih loh a caak nawn te amah loh saii mai saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Te khohnin kuelhuelh ah nangmih caempuei te Egypt kho lamloh kang khuen dongah vaidamding te ngaithuen. Te dongah na cadilcahma kah kumhal khosing dongah khaw he khohnin he ngaithuen uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Lamhma ah hla sae hnin hlai li hlaem vaeng lamloh tekah hla hnin kul hnin khat hlaem duela vaidamding mah ca uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Hnin rhih hil na im ah tolrhu hmu boel saeh. tolrhu aka ca boeih tah yinlai khaw, khohmuen mupoe khaw Israel rhaengpuei lamloh hinglu hnawt pah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Tolrhu aka nuen boeih tah ca uh boel lamtah na tolrhum boeih ah vaidamding mah ca uh ,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Te phoeiah Moses loh Israel kah a hamca boeih te a khue tih amih te dangrhoek uh laeh, namah huiko ham boiva te namamih loh lo uh lamtah Yoom maeh te ngawn uh laeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Te phoeiah pumpiding bong at lo uh lamtah baeldung dongkah thii khuiah nuem uh. Baeldung khuikah thii te danglo so neh rhungsut rhoi dongah hluk uh. Nangmih te hlang pakhat khaw mincang hil a im thohka lamloh moe uh boeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Egypt vuek ham BOEIPA loh a pah vaengah danglo dongkah neh rhungsut rhoi dongkah thii te a hmuh vetih a kan ni. Aka vuek te na im thohka la kun ham khaw BOEIPA loh nang te kutcaihnah la n'khueh mahpawh. ");
INSERT INTO hlt_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","He ol he namah ham neh na ca ham khaw kumhal kah oltlueh la ngaithuen laeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Nangmih taengah a thui vanbangla BOEIPA loh m'paek ham khohmuen la na pawk uh tue om bitni. Te vaengah he kah thothuengnah he ngaithuen uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Na ca rhoek loh nangmih taengah, “Nangmih kah he mebang thothuengnah nim? aka ti khaw om ni. ");
INSERT INTO hlt_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Te vaengah, “He tah BOEIPA kah Yoom hmueih ni. Amah loh Egypt kah Israel ca imkhui te a kan dongah Egypt te a vuek tih mamih imkhui te n'huul,’ ti nah,” a ti nah. Te phoeiah pilnam te buluk tih a bawk uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","A caeh uh phoeiah khaw BOEIPA loh Moses neh Aaron a uen a saii rhoi vanbangla Israel ca rhoek long khaw a saii uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Te phoeiah khoyin boengli a pha vaengah BOEIPA loh a ngolkhoel dongah aka ngol Pharaoh caming lamloh tangrhom im kah tamna caming neh rhamsa caming boeih, Egypt khohmuen kah caming boeih te a ngawn. ");
INSERT INTO hlt_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Te dongah Pharaoh amah neh a sal boeih neh Egypt boeih tah khoyin ah thoo uh. Te vaengah aka duek pawh imkhui a om pawt dongah Egypt ah pangngawlnah muep om. ");
INSERT INTO hlt_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Amah khoyin ah Moses neh Aaron te a khue tih, “Thoo lamtah ka pilnam lakli lamloh namah neh Israel ca rhoek khaw nong uh laeh. Na thui bangla cet uh lamtah Yahweh te thothueng uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Na boiva khaw, na saelhung khaw na thui uh bangla khuen uh. Cet uh lamtah kai khaw yoethen m'pae uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Egypt loh, “Kaimih boeih ka duek uh coeng, ” a ti uh. Te dongah amih te khohmuen lamloh tueih paitok ham te pilnam te a cahawh. ");
INSERT INTO hlt_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Te dongah pilnam loh a vaidambael dongkah tol a phul hlan a vaidamtlam te a himbai neh a boep uh tih a laengpang dongah a koh uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Israel ca rhoek long khaw Moses ol bangla a saii tih Egypt rhoek taengah cak hnopai neh sui hnopai neh himbai te a hoe uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","BOEIPA loh pilnam te Egypt mikhmuh ah mikdaithen la a khueh coeng dongah a hoe uh bangla Egypt kah te a huul pa uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Te vaengah Sukkoth Raamses lamloh Israel ca rhoek aka cet te camoe a hoep phoeiah tongpa rhalkap thawng ya rhuk tluk lo uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Namcom khaw amih taengah muep cet uh tih boiva neh saelhung boiva neh bahoeng yet uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Egypt lamloh a khuen vaidamtlam te tol a phul pawt dongah vaidamding buh la a kaeng uh. Egypt lamloh a haek uh vaengah uelh ham a coeng pawt dongah amamih ham lampu khaw a saii uh moenih. ");
INSERT INTO hlt_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israel ca rhoek loh a tolrhum nah tih Egypt ah kho a sak uh te kum ya li neh kum sawmthum lo coeng. ");
INSERT INTO hlt_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Kum ya li neh kum sawmthum a bawtnah te a pha coeng. Te khohnin kuelhuelh te a pha vaengah tah BOEIPA kah caempuei boeih te Egypt kho lamloh khoe uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Tekah haknah hlaem ah BOEIPA loh amih te Egypt kho lamkah a khuen. He khoyin he Israel ca boeih a cadilcahma ham BOEIPA taengkah haknah la om. ");
INSERT INTO hlt_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Te phoeiah BOEIPA loh Moses neh Aaron te, “Yoom kah khosing he tah, kholong ca boeih long tah te te ca boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Tedae sal boeih khaw tangka neh a lai hlang te na rhet pah coeng atah tah te te ca saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Lampah neh kutloh long khaw te te ca boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Im pakhat ah ca saeh. Maeh te imkhui lamloh tol la khuen boel saeh. A rhuh khaw a khuiah paep sak boeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Israel rhaengpuei boeih loh te te saii saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Na taengah yinlai bakuep tih BOEIPA taengkah Yoom ka saii eh a ti atah tongpa boeih te rhet pah saeh. Te daengah ni te te a saii vaengah nuen van vetih khohmuen mupoe bangla a om eh. Tedae pumdul boeih tah te te ca boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Olkhueng he mupoe taeng neh nangmih lakli kah aka bakuep yinlai taengah pakhat la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Te dongah BOEIPA loh a uen tih Moses neh Aaron loh a saii bangla Israel ca rhoek loh boeih a saii uh. ");
INSERT INTO hlt_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Te khohnin kuelhuelh ah ni BOEIPA loh Israel ca rhoek te Egypt kho lamloh a caempuei neh a khuen. ");
INSERT INTO hlt_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Israel ca bung boeih kah cacuek caming boeih tah kamah ham ciim laeh. Hlang dongkah khaw, rhamsa dongkah khaw cacuek he kamah ham ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Te phoeiah Moses loh pilnam te, “Egypt lamkah na coe khohnin he poek ham om. Sal imkhui lamkah nangmih te BOEIPA kut thaa neh n'doek coeng dongah tolrhu ca uh boeh. ");
INSERT INTO hlt_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Tihnin Abib hla ah na khoe uh coeng. ");
INSERT INTO hlt_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","BOEIPA loh nang te Kanaan neh Khitti, Amori neh Khivee neh Jebusi khohmuen la n'thak. Suktui neh khoitui aka long khohmuen he nang taengah paek ham khaw na pa rhoek taengah a toemngam coeng. Te dongah tahae hla dongah he thothuengnah neh thothueng uh. ");
INSERT INTO hlt_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Hnin rhih khuiah vaidamding ca lamtah a hnin rhih dongah tah BOEIPA kah khotue la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Vaidamding te hnin rhih ca saeh lamtah na khuiah tolrhu hmu boel saeh. Na khui neh na khorhi boeih ah tol hmu boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Te hnin ah tah na ca taengah puen lamtah, “Egypt lamkah ka thoh vaengah BOEIPA loh kai ham he he a saii dongah ni, “ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Nang ham Na kut dongah miknoek la, na mik laklo ah poekkoepnah la om ni. A tlungluen kut neh BOEIPA loh nang Egypt lamloh n'khuen coeng dongah BOEIPA kah olkhueng he na ka dongah om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","A khohnin lamloh a khohnin patoeng duela amah khoning vaengah he khosing he tuem uh. ");
INSERT INTO hlt_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Kanaan khohmuen hil nang aka khuen la BOEIPA ha om bitni. Namah taeng neh na pa rhoek taengah a caeng bangla te te nang taengah m'paek coeng. ");
INSERT INTO hlt_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Bung dongkah cacuek boeih te BOEIPA taengla paan puei. Rhamsa saelca cacuek boeih neh na taengkah tongpa rhoek te BOEIPA kah ni. ");
INSERT INTO hlt_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Tedae laak cacuek boeih te tu neh koep lat. Na lat pawt atah pahoi at laeh. Na ca rhoek khuiah tongpa caming boeih na lat ni. ");
INSERT INTO hlt_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Na ca loh nang n'dawt tih, “Balae he?” aka ti khaw om ni. Te vaengah anih te, “BOEIPA loh Egypt sal im lamkah Mamih he a ban thaa neh n'khuen. ");
INSERT INTO hlt_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Mamih hlah ham te Pharaoh mangkhak la a om vaengah Egypt khohmuen kah caming boeih tah hlang caming lamloh rhamsa caming hil khaw BOEIPA loh a ngawn. Te dongah ni bung dongkah cacuek a tal boeih tah BOEIPA ham boeih ka nawn tih ka ca caming boeih tah ka lat,’ ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","BOEIPA loh mamih he Egypt lamloh a ban thaa neh n'khuen coeng dongah na kut dongah miknoek la, na mik laklo samtoelrhui la om ni. ");
INSERT INTO hlt_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Pharaoh loh pilnam te a hlah coeng dae Pathen loh, “Pilnam he caemtloeknah a hmuh vaengah hal vetih Egypt la mael ve,” a ti. Te dongah amih te Pathen loh Philisti kho kah longpuei longah pat mawt pawh. ");
INSERT INTO hlt_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Te dongah Pathen loh pilnam te carhaek tuili kah khosoek longpuei a lan puei tih Israel ca rhoek te Egypt kho lamloh caem la khong uh. ");
INSERT INTO hlt_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Te vaengah Israel ca rhoek te a caeng, a caeng tih, “Na Pathen loh a hip khaw n'hip bitni. Te vaengah ka rhuh he, he lamloh namamih neh puei uh ,” a ti nah vanbangla Moses loh Joseph rhuh te amah taengla a loh. ");
INSERT INTO hlt_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Sukkoth lamloh cet uh tangloeng tih khosoek hmatoeng kah Etham ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","BOEIPA te amih hmai ah cet. Khoyin khothaih a caeh ham vaengah tah amih longpuei mawt ham khothaih ah cingmai tung la, khoyin ah amih te tue ham hmai tung la a caeh pah. ");
INSERT INTO hlt_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Khothaih kah cingmai tung neh khoyin kah hmai tung he pilnam mikhmuh lamloh nong sak pawh. ");
INSERT INTO hlt_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Israel ca rhoek te thui pah lamtah mael uh saeh. Te dongah Pihahiroth dan kah Migdol laklo neh Baalzephon dan kah tuipuei laklo ah rhaeh uh saeh. Te kah a dan tuipuei taengah khaw rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Te vaengah Pharaoh loh, “Israel ca rhoek tah khohmuen ah amamih a lukil uh tih khosoek ah a det,” ti saeh. ");
INSERT INTO hlt_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Te vaengah Pharaoh lungbuei te ka moem pah vetih amih te a hloem ni. Tedae Pharaoh neha thadueng cungkuem rhangneh kamah ka thangpom vetih Egypt rhoek loh kai he Yahweh la a ming uh ni,” a ti nah tih a saii uh tangloeng. ");
INSERT INTO hlt_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Tedae pilnam yong te Egypt manghai taengla a puen pah vaengah tah Pharaoh neh a sal rhoek loh pilnam taengah thinko a maelh uh tih, “Israel he mamih ham a thotat khui lamloh n'hlah coeng dongah balae n'saii uh he,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Te dongaha leng te a khih tih amah pilnam te amah taengla a loh. ");
INSERT INTO hlt_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Te phoeiah leng a coelh ya rhuk neh Egypt leng boeiha boeilu boeih te khaw a loh. ");
INSERT INTO hlt_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","BOEIPA loh Egypt manghai Pharaoh kah lungbuei te a moem pah dongah Israel ca rhoek te a hloem. Tedae Israel ca rhoek kut thoh nen ni a khong uh. ");
INSERT INTO hlt_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Amih hnuk te Egypt rhoek loh a hloem uh tangloeng tih tuipuei taengah a rhaeh vaengah amih te a kae uh. Pharaoh kah marhang leng boeih neha marhang caem khaw, anih kah caem khaw, Baalzephon dan kah Pihahiroth la pawk. ");
INSERT INTO hlt_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Pharaoh loh a paan vaengah Israel ca rhoek loh a mik te a huel uh. Egypt rhoek te a hnukah tarha a caeh pah vaengah tah bahoeng a rhih dongah Israel ca rhoek te BOEIPA taengah pang uh. ");
INSERT INTO hlt_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Moses taengah khaw, “Egypt ah phuel om voel pawt tih nim khosoek ah duek sak ham kaimih nang khuen, Egypt lamloh kaimih nang khuen neh kaimih ham banim na saii he? ");
INSERT INTO hlt_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Egypt ah nang hma kan thui uh te ol pawt nim. Kaimih he tamah laeh saeh ka ti. Egypt taengah thotat palueng sih, khosoek kah duek lakah Egypt taengah thohtat he kaimih ham then ngai,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Tedae Moses loh pilnam te, “Rhih uh boeh, pai uh lamtah hmu uh. BOEIPA kah khangnah nangmih ham tihnin ah a saii bitni. Tihnin kah na hmuh Egypt rhoek he koep hmuh ham kumhal duela na khoep uh voel mahpawh. ");
INSERT INTO hlt_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","BOEIPA loh nangmih ham a vathoh bitni, nangmih duem om uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Te dongah BOEIPA loh Moses te, “Balae tih kai taengah na pang, Israel ca rhoek te thui pah lamtah ana cet uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Nang te na conghol thoh lamtah tuipuei soah na kut thueng laeh. Tuipuei te a phih daengah ni Israel ca te tuipuei khui kah laiphuei dongah a caeh uh eh. ");
INSERT INTO hlt_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Kai kamah long ni Egypt lungbuei te ka moem pah. Amih te a hloem vaengah ni Pharaoh so neha caem boeih so lamloh, a leng so neha marhang caem so lamloh kamah ka thangpom uh eh. ");
INSERT INTO hlt_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Pharaoh so neh a leng soaha marhang caem soah kamah ka thangpom uh vaengah kai Yahweh he Egypt loh a ming bitni ,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Te phoeiah Israel lambong hmai ah aka cet Pathen puencawn khoe uh tih amih hnuk la cet. Cingmai tung khaw amih hmai lamloh thoeih tih amih hnuk ah pai. ");
INSERT INTO hlt_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Te vaengah Egypt lambong laklo neh Israel lambong laklo la pawk. Cingmai khaw a hmuep la om dae khoyin ah sae. Te dongah khoyin khing a taengla pha thai pawh. ");
INSERT INTO hlt_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Te vaengah Moses loh a kut te tuipuei soah a thueng tih BOEIPA loh tuipuei te khoyin puet khothoeng yilh tlung neh a yah pah. Te dongah tuipuei te lanhak la poeh tih tui te phik uh. ");
INSERT INTO hlt_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Te vaengah Israel ca rhoek te tuipuei laklung kah laiphuei dongah cet uh tih tui khaw amih ham a banvoei neh a bantang ah vongtung la a om pah. ");
INSERT INTO hlt_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Egypt rhoek a hloem uh vaengah Pharaoh kah marhang leng boeih neha marhang caem khaw amih hnukah tuipuei tuilung la kun uh. ");
INSERT INTO hlt_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Mincang khopo a pha vaengah BOEIPA loh hmai tung neh cingmai dong lamloh Egypt lambong te a dan tih Egypt lambong te a khawkkhek. ");
INSERT INTO hlt_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","A leng dongkah lengkho te a tling pah tih hnorhih laa hmaithawn. Te dongah Egypt loh, “Israel mikhmuh lamloh rhaelrham pawn sih, BOEIPA loh amih ham Egypt a vathoh thil,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Te vaengah BOEIPA loh Moses te, “Tuipuei soah na kut te thueng lamtah tui loh Egypt neh a leng neha marhang caem soah et saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moses loh a kut te tuipuei soah a thueng tangloeng tih mincang vikvak ah tuipuei khaw amah thim la mael. Te long te amah coeng dongah Egypt rhoek khaw rhaelrham uh dae BOEIPA loh Egypt rhoek te tuipuei khui la a khoek. ");
INSERT INTO hlt_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Tui a mael vaengah leng neh marhang caem te a et pah. Amih hnuk ah tuipuei la aka pawk Pharaoh caem boeih te pakhat pataeng sueng pawh. ");
INSERT INTO hlt_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Tedae Israel ca rhoek tah tuipuei tuilung kah laiphuei dongah cet uh tih tui te amih kah a banvoei, a bantang ah vongtung la pah. ");
INSERT INTO hlt_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Tekah khohnin ah BOEIPA loh Israel te Egypt kut lamkah a khang tangloeng tih Israel loh tuipuei tuikaeng ah Egypt a duek te a hmuh. ");
INSERT INTO hlt_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","BOEIPA tanglue kut neh Egypt soah a saii te Israel loh a hmuh. Te daengah pilnam loh BOEIPA te a rhih tih BOEIPA neha sal Moses te a tangnah uh. ");
INSERT INTO hlt_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Moses neh Israel ca rhoek loh BOEIPA taengah he laa he a sak uh. Te vaengah,” A phul la aka phul marhang neh a soah aka ngol khaw tuipuei khuila a phok coeng dongah BOEIPA te ka hlai eh. ");
INSERT INTO hlt_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ka Pathen he kai ham ka sarhi neh BOEIPA laa neh khangnah la om. A pa Pathen amah te ka uem vetih amah te ka pomsang ni. ");
INSERT INTO hlt_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","BOEIPA tah caemtloek hlang coeng tih, a ming tah Yahweh ni. ");
INSERT INTO hlt_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Pharaoh kah leng neh a caem te tuipuei la a dong pah tih a boeilu hlangrhoei te carhaek tuipuei ah a buek sak. ");
INSERT INTO hlt_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Tuidung loh amih te a thing tih a laedil ah lungto bangla suntla. ");
INSERT INTO hlt_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","BOEIPA nang kah bantang kut tah thadueng neh thangpom uh tih, BOEIPA nang kah bantang kut loh thunkha khaw a noi. ");
INSERT INTO hlt_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Na hoemdamnah cangpai lamloh nang aka thoh thil khaw, na koengloeng tih na thinsa na tueih vaengah, amih te divawt bangla a hlawp. ");
INSERT INTO hlt_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Na hnarhong dongkah yilh lamloh tui hol uh tih, tuipuei tuilung ah tuidung aka dok uh tuisih khaw som bangla pai. ");
INSERT INTO hlt_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Thunkha long tah ka hloem vetih ka kae vaengah ka hinglu a cung hil amih te kutbuem la ka tael ni. Ka cunghang te ka yueh vetih ka kut loh amih a pang bitni. ");
INSERT INTO hlt_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Na hil neh na hmuh tih tuipuei loh amih a khuk vaengah tah tui khuet khuiah kawnlawk bangla buek. ");
INSERT INTO hlt_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Namah bangla pathen rhoek lakli ah unim aka om?BOEIPA aw, namah bangla hmuencim ah unim a thangpom?Khobaerhambae a saii bangla koehnah khaw rhih om pai. ");
INSERT INTO hlt_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Na bantang kut na thueng vaengah amih te diklai loh a dolh. ");
INSERT INTO hlt_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Pilnam na tlan te na sitlohnah neh na mawt vetih na tolkhoeng cim la na sahri neh na khool ni. ");
INSERT INTO hlt_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Pilnam loh a yaak vetih tlai uh ni. Philistia khosa rhoek te bungtloh loh a kawlek ni. ");
INSERT INTO hlt_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edom khoboei rhoek te let uh vetih Moab ngalhatung rhoek te thuennah loh a tuuk ni. Kanaan khosa rhoek khaw boeih paci uh ni. ");
INSERT INTO hlt_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Na ban tanglue lamloh amih soah mueirhih neh birhihnah khaw tla ni. BOEIPA namah kah pilnam a khum hil, na lai pilnam a khum hil lungto bangla kuemsuem uh bitni. ");
INSERT INTO hlt_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Amih te na khuen vetih na rho tlang dongah na phung ni. BOEIPA aw te hmuen ah khosak ham na saii tih ka Boeipa kah rhokso khaw namah kut long ni a saii. ");
INSERT INTO hlt_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","BOEIPA ni kumhal ham a manghai yoeyah eh?,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Te vaengah Pharaoh kah marhang tah amah kah leng neh a marhang caem te khaw tuili khuila kun uh. Te dongah BOEIPA loh amih soah tuipuei tui te a mael sak. Tedae Israel ca rhoek tah tuipuei tuilung kah laiphuei dongah cet uh. ");
INSERT INTO hlt_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Te vaengah Aaron ngannu, tonghmanu Miriam loh a kut dongah kamrhing a muk. A hnukah manu boeih khaw kamrhing neh lamnah neh ha pawk uh. ");
INSERT INTO hlt_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Te vaengah amih te Miriam loh, “Marhang te phul la phul cakhaw a sokah aka ngol te tuili khuila a phok coeng dongah lah BOEIPA te hlai uh pai,” tila a doo. ");
INSERT INTO hlt_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Te phoeiah Moses loh Israel te carhaek tuipuei lamloh a khuen tih Shur khosoek la pawk uh. Tedae hnin thum caeh kah khosoek ah tah tui hmu uh voel pawh. ");
INSERT INTO hlt_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Marah la a pawk vaengah khaw Marah tui te khahing tih ok la lo pawh. Te dongah a ming khaw Marah a sui uh. ");
INSERT INTO hlt_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Te vaengah pilnam te Moses taengah nul uh tih, “Balae n'ok eh?” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Tedae BOEIPA taengah pang tih BOEIPA loh a thuinuet thing te tui khuila a voeih daengah tui khaw tui. Anih ham oltlueh neh laitloeknah ni pahoi a khueh pah tih pahoi a noemcai coeng. ");
INSERT INTO hlt_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Te vaengah, “BOEIPA na Pathen ol te na yaak rhoe na yaak tih a mikhmuh ah a thuem la na saii atah a olpaek te hnakaeng lamtah a oltlueh te boeih tuem. Nang aka hoeih sak he BOEIPA kamah. Te dongah Egypt soah tlohtat cungkuem ka khuen te nang soah ka khueh mahpawh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Te phoeiah Elim la pawk uh tih tuiphuet tui hlai nit neh rhophoe sawmrhih ana om. Te dongah tui taengah pahoi rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Te phoeiah Elim lamloh cet uh tih Israel ca rhaengpuei boeih tah Sin khosoek la pawk uh. Elim laklo neh Sinai laklo te Egypt kho lamloh a thoh uh phoeikah a hla bae hnin hlai nga dongah a pha uh. ");
INSERT INTO hlt_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Te vaengah Israel ca rhaengpuei boeih te khosoek kah Moses taeng neh Aaron taengah nul khaw nul uh. ");
INSERT INTO hlt_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Israel ca rhoek loh amih rhoi te, “BOEIPA kut ah kaimih duek sak ham n'khueh pawt nim ca? Egypt kho ah maeh am dongah mamih n'ngol uh tih kodam la buh ka caak uh vaengah hlangping boeih he khokha neh duek sak ham maco he khosoek la kaimih nang khuen,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Te vaengah BOEIPA loh Moses te, “Kai loh nangmih ham vaan lamkah buh kan tlan sak ne. Pilnam te cet saeh lamtah hnin at ka a rhoeh te amah khohnin ah yoep uh saeh. Ka olkhueng dongah a pongpa neh a pongpa pawt khaw amah ka noem dae eh. ");
INSERT INTO hlt_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","A rhuk hnin dongla a pha vaengah hang khuen te soepsoei uh saeh. Te vaengah tah a hnin, hnin kah a yoep lakah rhaepnit lo saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Te phoeiah Moses neh Aaron loh Israel ca boeih te, “BOEIPA loh nangmih Egypt kho lamkah n'khuen te hlaemhmah vaengah na ming uh bitni. ");
INSERT INTO hlt_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Mincang ah BOEIPA kah thangpomnah te na hmuh uh bal bitni. BOEIPA soah nangmih kah kohuetnah te amah loh a yaak. Tedae kaimih rhoi taengah na nul la na nul uh te kaimih rhoi tah ulae?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Te phoeiah Moses loh, “BOEIPA loh nangmih he hlaem kah caak ham maeh neh mincang ah buh kodam la m'paek ham vaengah na kohuetnah neh amah taengah na nul te BOEIPA loh a yaak coeng. Te dongah kaimih rhoi he ulae? Nangmih kah kohuetnah te kaimih rhoi taengah pawt tih BOEIPA taengah ni na kohuet uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Te phoeiah Moses loh Aaron taengah, “Israel ca rhaengpuei boeih te, 'Nangmih kah kohuetnah te a yaak coeng dongah BOEIPA mikhmuh la na tawn uh laeh,’ ti nah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aaron loh Israel ca rhaengpuei boeih te a voek vaengah khosoek la a mael uh hatah BOEIPA thangpomnah te cingmai khuiah tarha tueng uh. ");
INSERT INTO hlt_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Te phoeiah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Israel ca rhoek kah kohuetnah te ka yaak. Amih te thui pah. 'Hlaem ah maeh na caak uh tih, mincang ah buh na hah uh ni,’ ti nah. Te vaengah kai Yahweh he na Pathen la nan ming uh bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Hlaem a pha tangloeng vaengah tah tanghuem ha pawk tih rhaehhmuen te a thing. Mincang ah rhaehhmuen kaepvai kah buemtui te a khaan a om pah. ");
INSERT INTO hlt_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Tedae buemtui kah a khaan a cing nen tah khosoek cirhong ah a kueluek a tham aka yit tarha om tih diklai ah vueltling bangla om. ");
INSERT INTO hlt_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Te vaengah Israel ca rhoek loh a hmuh uh. Te dongah hlang loh a manuca taengah,” Manna la he,” a ti uh. Te te balae ti a ming uh pawt dongah Moses loh amih te, “He kah buh he BOEIPA loh nangmih taengah cakkoi la m'paek coeng. ");
INSERT INTO hlt_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","He ham he BOEIPA loh ol n'uen coeng. Hlang loh amah caak rhoeh ah rhut saeh. Na hinglu tarhing ah hlangmi pakhat ham kosai pakhat van saeh. Hlang he amah dap ah aka om tarhing ah khuen sak uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Te te Israel ca rhoek loh a ngai uh van tih baeko baepet lam khaw a rhuh uh. ");
INSERT INTO hlt_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Kosai dongah a loeng uh tih baepet hoei pawt tih baeko lam khaw vaitah pawh. Hlang loh amah caak rhoeh ah a coi uh. ");
INSERT INTO hlt_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Te phoeiah Moses loh amih te, “Hlang khat long khaw te te mincang hil la paih boel saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Tedae Moses ol te hnatun uh pawt tih hlang rhoek loh te te mincang hil a paih uh. Te vaengah a rhiit a poem pah tih a rhim dongah amih taengah Moses a thintoek. ");
INSERT INTO hlt_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Te phoeiah tah mincang, mincang bueng ah te te a rhuh uh. Hlang takuem loh amah caak rhoeh ah a rhuh dae khomik a bae vaengah a yut pah. ");
INSERT INTO hlt_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Hnin rhuk a lo vaengah tah buh te hlang pakhat ham kosai panit a rhaep la a rhuh uh. Te dongah rhaengpuei khoboei boeih tah cet uh tih Moses taengah puen uh. ");
INSERT INTO hlt_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Te vaengah amih te, “He he BOEIPA loh a thui coeng. Thangvuen tah BOEIPA ham koiyaeh Sabbath cim la om. Te dongah hai koi te hai uh lamtah thong koi te thong uh. A coih boeih te namamih ham rhoe uh lamtah mincang hil tuemkoi la om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Moses loh a uen bangla mincang hil a rhoe uh tangloeng vaengah rhim pawt tih a khuiah a rhit khaw om pawh. ");
INSERT INTO hlt_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Te phoeiah Moses loh, “Tihnin ah te te ca uh, Sabbath he BOEIPA kah khohnin ni. Tihnin ah ngawn tah diklai ah te te na hmu uh mahpawh. ");
INSERT INTO hlt_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Hnin rhuk khuiah ni te te na rhuh uh eh. Tedae a rhih hnin tah Sabbath coeng tih te vaengah om mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Te dongah a rhih hnin a pha vaengah rhuh hamla pilnam te mop uh dae hmu uh pawh. ");
INSERT INTO hlt_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Te vaengah BOEIPA loh Moses te, “Ka olpaek neh ka olkhueng tuem ham he me hil nim na aal ve? ");
INSERT INTO hlt_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","BOEIPA loh nangmih taengah Sabbath m'paek te hmu uh. Te dongah a rhuk hnin ah nangmih te hnin hnih caak te m'paek. A rhih hnin ah tah hlang he amah hmuen ah khosa saeh lamtah hlang pakhat khaw amah hmuen lamloh cet boel saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Te dongah pilnam khaw a rhih hnin ah duem van. ");
INSERT INTO hlt_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Te kah ming te Israel imkhui loh manna la a khue. Te te sungsin tii bangla bok tih a tuihlim tah khoitui buhrhawm bangla om. ");
INSERT INTO hlt_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Te phoeiah Moses loh, “He ol he BOEIPA long ni n'uen. Te te kosai a bae la na cadilcahma ham tuemkoi la om saeh. Te daengah ni Egypt kho lamloh nangmih kang khuen vaengkah khosoek ah nangmih buh kan cah te a hmu uh eh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Te phoeiah Moses loh Aaron te, “Am pakhat lo lamtah manna kosai a bae la pahoi sang. Te te na cadilcahma duela tuemkoi la BOEIPA mikhmuh ah tawn pah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","BOEIPA loh Moses taengah a uen bangla tuemkoi ham Aaron te laipainah hmai ah a khueh. ");
INSERT INTO hlt_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Khosak nah khohmuen la a pawk uh hil kum sawmli khuiah Israel ca rhoek manna te a caak uh. Kanaan khohmuen a bawtnah la a pawk uh hil manna te a caak uh. ");
INSERT INTO hlt_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Kosai parha te cangnoek khat lo ni. ");
INSERT INTO hlt_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Te phoeiah Israel ca rhaengpuei boeih tah BOEIPA olka bangla a longpueng kah Sin khosoek lamloh hlah uh tih Rephidim ah rhaeh uh. Te vaengah pilnam kah a ok ham tui om pawh. ");
INSERT INTO hlt_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Te dongah pilnam te Moses neh toh uh thae tih, “Kaimih he tui m'pae lamtah ka o pawn eh,” a ti uh. Te vaengah amih te Moses loh, “Balae tih kai te nan toe uh?Balae tih BOEIPA na noemcai? a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Tedae pilnam tah tui hal oeh. Te dongah pilnam te Moses taengah nul uh tih, “Balae tih Egypt lamloh kaimih nang khuen. Kamah neh ka ca rhoek neh ka tuihalh neh duek sak ham maco,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Te vaengah Moses te BOEIPA taengah pang tih, “Pilnam ham he balae ka saii eh ? Bet ca koinih kai n'dae uh hloe,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Te phoeiah BOEIPA loh Moses te, “Pilnam hmai ah lamhma lamtah Israel kah a ham rhoek te namah neh puei uh. Sokko na boh nah na conghol te na kut dongah pom lamtah cet. ");
INSERT INTO hlt_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Kamah he na mikhmuh kah Horeb lungpang soah ka pai ne. Lungpang te taam lamtah te lamloh tui ha phuet vaengah pilnam loh o saeh,” a ti nah. Te te Moses loh Israel a ham rhoek mikhmuh ah a saii pah. ");
INSERT INTO hlt_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Te vaengah Israel ca rhoek kah tuituknah neh BOEIPA te a noemcai uh tih, “BOEIPA he mamih lakli ah om nim, om pawt nim?” a ti uh dongah a hmuen ming te Massah neh Meribah a sui. ");
INSERT INTO hlt_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Tedae Rephidim ah tah Amalek ha pawk tih Israel a vathoh thil. ");
INSERT INTO hlt_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Te dongah Moses loh Joshua taengah, “Mamih ham hlang coelh laeh, khuen lamtah Amalek te tloek laeh. Thangvuen ah kai he som lu ah ka pai ni, ka kut ah Pathen kah conghol om ngawn,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Amalek te vathoh thil ham Moses loh amah a ti nah bangla Joshua loha saii tangloeng. Moses, Aaron neh Hur tahtlangsom lu la luei uh. ");
INSERT INTO hlt_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Moses loh a kut a thoh rhuet vaengah tah Israel loh a na dae a kut a hlak rhuet vaengah tah Amalek a na. ");
INSERT INTO hlt_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Tedae Moses kut a kha vaengah tah lungto a loh uh tih a dangah a phaih pauh. Te phoeiah a soah ngol tih a kut te Aaron neh Hur loh khatben ah pakhat, khatben ah pakhat loh a moem pah. Te daengah a kut rhoi te khomik a tlak hil khuek om. ");
INSERT INTO hlt_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Te dongah Joshua loh Amalek neh a pilnam te cunghang ha neh a rhaa. ");
INSERT INTO hlt_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Te phoeiah BOEIPA loh Moses te, “Poekkoepnah he cabu dongah daek lamtah Joshua hna ah dueh pah. Amalek poekkoepnah te vaan hmui lamloh ka khoe rhoe ka khoe ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Te dongah Moses loh hmueihtuk a suem tih a ming te BOEIPA tah ka rholik la a khue. ");
INSERT INTO hlt_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Te vaengah, “Caemtloek BOEIPA kah ngolkhoel dongah kut ka phuel dongah BOEIPA loh Amalek te cadilcahma lamloh cadilcahma duela vathoh thil saeh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Pathen loh Moses ham neh a pilnam Israel ham a cungkuem a saii pah tih BOEIPA loh Israel Egypt lamkah a khuen te Moses masae, Midian khosoih Jethro loh a yaak. ");
INSERT INTO hlt_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","A maan hnukah Moses yuu Zipporah loh Moses masae Jethro te a doe. ");
INSERT INTO hlt_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Te vaengah a ca rhoi te a khuen tih, kholong kho ah yinlai la ka om a ti dongah pakhat te a ming Gershom a sui. ");
INSERT INTO hlt_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Pakhat te tah a pa Pathen he kai bomkung la om tih Pharaoh cunghang lamloh kai n'huul a ti tih a ming Eliezer a sui. ");
INSERT INTO hlt_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Te phoeiah Moses yuu, ca rhoek te a masae Jethro neh Pathen kah tlang khosoek ah aka rhaeh Moses taengla ha pawk. ");
INSERT INTO hlt_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Te dongah Moses te, “Na masae kai Jethro he nang taengla na yuu neh a taengkah a ca rhoi khaw, kam pawk puei coeng,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moses te a masae doe ham cet tih bakop tih a mok. Te vaengah hlang te a hui neh sadingnah khaw a dawt uh rhoi phoeiah dap khuila kun uh. ");
INSERT INTO hlt_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Te phoeiah Israel kongmai dongah BOEIPA loh Pharaoh taeng neh Egypt taengah a saii boeih, longpueng ah amih aka mah bongboepnah cungkuem neh BOEIPA loh amih a huul te khaw Moses loh a masae taengah a thui pah. ");
INSERT INTO hlt_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Egypt kut lamloh a huul vaengah BOEIPA loh Israel ham a then boeih a saii pah dongah Jethro a kohoe. ");
INSERT INTO hlt_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Te phoeiah Jethro loh, “Egypt kut lamkah neh Pharaoh kut lamloh nangmih aka huul tih Egypt kut hmui lamloh pilnam aka huul BOEIPA tah a yoethen pai saeh. ");
INSERT INTO hlt_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Amih taengah ol a lokhak pah coeng dongah pathen boeih lakah BOEIPA he tanglue tila ka ming coeng,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Te phoeiah Moses masae Jethro loh hmueihhlutnah neh hmueih te Pathen taengah a khuen. Te vaengah Aaron neh Israel kah a hamca boeih tah Pathen mikhmuh ah Moses masae neh buh ca la ha pawk. ");
INSERT INTO hlt_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","A vuen ah pilnam te laitloek ham Moses ngol tih pilnam te Moses taengah mincang lamloh kholaeh hil pai uh. ");
INSERT INTO hlt_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Pilnam ham a saii boeih te Moses masae loh a hmuh tih, “Pilnam ham na saii hno he mebang lae?Nang namah bueng na ngol vaengah pilnam pum he balae tih na taengah mincang lamloh kholaeh hil a pai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Te vaengah Moses loh a masae te, “Pathen dawtlet ham ni pilnam loh kai taengla ha pawk. ");
INSERT INTO hlt_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Amih taengah te olka a om vaengah kai taengah ha pawk. Te vaengah hlang pakhat neh a hui laklo ah lai ka tloek tih Pathen kah oltlueh neh a olkhueng te ka ming sak,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Te vaengah a masae loh Moses te, “Hno na saii te then pawh. ");
INSERT INTO hlt_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Namah neh na taengkah pilnam he khaw na tawn la na tawn uh coeng. Namah ham rhih aih tih dumlai khaw namah bueng loh na rhoe thai moenih. ");
INSERT INTO hlt_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ka ol he ngai laeh, nang kang uen lah eh. Pathen he nang taengah om saeh. Namah te Pathen hmai ah pilnam yueng om lamtah olka te namah loh Pathen taengla khuen saw. ");
INSERT INTO hlt_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Te vaengah amih te oltlueh neh olkhueng khaw thuituen lamtah a pongpa ham longpuei neh a saii ham bibi te amih tueng saw. ");
INSERT INTO hlt_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Te phoeiah namah loh pilnam pum khui lamloh Pathen aka rhih tatthai hlang, mueluemnah aka thiinah oltak kah hlang rhoek te so. Amih te thawng khat kah mangpa, yakhat kah mangpa, sawmnga kah mangpa neh parha kah mangpa la khueh. ");
INSERT INTO hlt_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","A tue boeih dongah pilnam te laitloek pah saeh. Dumlai aka om boeih khaw a puei mah nang taengla ham pawk puei saeh. Olka a phoeng boeih tah amih loh laitloek pah saeh. Te vaengah nang ham yanghoep saeh lamtah nang te n'yingyawn uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ol he na ngai daengah ni Pathen loh nang uen bangla na pai thai vetih pilnam boeih he khaw a hmuen te ngaimong la a paan eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moses loh a masae ol te a hnatun tih a thui te boeih a saii. ");
INSERT INTO hlt_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Te dongah Moses loh Israel boeih khuiah hlang tatthai rhoek te a coelh tih amih te pilnam soah a lu, thawngkhat kah mangpa, yakhat kah mangpa, sawmnga mangpa neh parha kah mangpa te a paek. ");
INSERT INTO hlt_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","A tue boeih ah pilnam te a lai a tloek uh tih dumlai aka kuel te Moses taengla a khuen uh. Ol phoeng boeih tah amih loh lai a tloek uh. ");
INSERT INTO hlt_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Te phoeiah Moses loh a masae te a phih tih anih te amah kho la voei. ");
INSERT INTO hlt_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Israel ca rhoek Egypt kho lamloh a nong phoeikah hla thum dongah a om khohnin ah Sinai khosoek la pawk uh. ");
INSERT INTO hlt_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Te phoeiah Rephidim lamloh hlah uh tih Sinai khosoek la pawk uh. Khosoek kah a rhaeh uh vaengah Israel tah tlang dan ah pahoi rhaeh. ");
INSERT INTO hlt_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Te vaengah Moses tah Pathen taengla cet. Te dongah BOEIPA loh anih te tlang lamloh a khue tih, “He he Jakob imkhui te thui pah lamtah Israel ca taengah puen pah. ");
INSERT INTO hlt_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Egypt taengah ka saii te na hmuh uh coeng. Nangmih te atha phae dongah kam phueih tih kamah taengla nangmih kang khuen. ");
INSERT INTO hlt_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Te dongah ka ol he na ngai rhoe na ngai tih ka paipi na tuem atah pilnam cungkuem khui lamloh kamah taengah lungthen la na om uh ni. Diklai pum khaw kamah kah ni. ");
INSERT INTO hlt_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Te phoeiah nangmih te kamah taengah khosoih ram neh hlangcim namtu la na om uh ni. He ol he Israel ca taengah thui pah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Te phoeiah Moses te mael tih pilnam kah a hamca rhoek te a khue. Te vaengah BOEIPA loh amah ol a uen boeih te amih mikhmuh ah a phoe pah. ");
INSERT INTO hlt_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Te vaengah pilnam pum loh huek a doo tih, “BOEIPA kah a thui te boeih ka saii uh ni,” a ti uh. Te dongah Moses loh pilnam kah ol te BOEIPA taengla a mael puei. ");
INSERT INTO hlt_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Te phoeiah BOEIPA loh Moses taengah, “Kai tah nangmih taengah cingmai khomai neh ka pawk coeng he. He kong nen ni kai neh nang m'voek uh vaengah pilnam loh a yaak eh. Te vaengah nang soah khaw kumhal duela n'tangnah uh bitni,” a ti nah. Te vaengah Moses loh pilnam kah ol te BOEIPA taengla a puen pah. ");
INSERT INTO hlt_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Te phoeiah BOEIPA loh Moses te, “Pilnam taengah cet lamtah tihnin neh thangvuen ah amih te ciim lamtah a himbai te til uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","A thum khohnin ah tah sikim la om uh saeh. A thum hnin ah BOEIPA tah pilnam pum mikhmuh ah Sinai tlang la ha rhum ni. ");
INSERT INTO hlt_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Pilnam te a kaepvai ah rhi suem pah lamtah, “Nangmih te tlang la luei neh a rhi te ben ham khaw ngaithuen uh, tlang aka ben boeih tah duek rhoe duek ni. ");
INSERT INTO hlt_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","A soah kut loh taek boel saeh. Tedae dae la dae saeh lamtah kap khaw kap saeh. Jubilee la a sol vaengah tlang la aka cet te tah rhamsa khaw hlang khaw hing boel saeh,’ ti nah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Te dongah Moses te tlang lamloh pilnam taengla suntla tih pilnam te a ciim phoeiah a himbai te a til uh. ");
INSERT INTO hlt_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Te vaengah pilnam te, “A thum hnin ah sikim la om uh lamtah huta taengla mop uh boeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","A thum hnin kah mincang a pha tangloeng vaengah rhaek ol neh cingmai a thah loh tlang soah om. Te vaengah tuki ol te bahoeng tlungluen tih rhaehhmuen kah pilnam khaw boeih lakueng. ");
INSERT INTO hlt_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Pathen doe ham Moses loh pilnam te rhaehhmuen lamkah a khuen tih tlang yung ah pai uh. ");
INSERT INTO hlt_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","BOEIPA te hmai neh a rhum dongah Sinai tlang khaw a pum la khuu. A hmaikhu te hmailing hmaikhu bangla luei tih tlang a pum la muep lakueng. ");
INSERT INTO hlt_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Tuki ol khaw ha thoeih tih bahoeng len. Moses loh a voek vaengah Pathen loh a ol neh a doo. ");
INSERT INTO hlt_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Te vaengah BOEIPA tah Sinai tlang kah tlang soi la ha rhum. Te phoeiah BOEIPA loh Moses te tlang soi la a khue tih Moses khaw cet hang. ");
INSERT INTO hlt_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Tedae BOEIPA loh Moses te, “Suntla lamtah pilnam te rhalrhing sak, BOEIPA hmuh ham koengloeng uh vetih amih te cungku uh khungdaeng ve. ");
INSERT INTO hlt_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Khosoih rhoek pataeng khaw BOEIPA taengla aka mop rhoek ciim uh saeh. Amih taengah BOEIPA pung ve,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Te phoeiah Moses loh BOEIPA taengah, “Namah loh kai he na rhalrhing sak tih, 'Tlang te suem lamtah ciim laeh,” na ti coeng dongah Sinai tlang la pilnam a yoeng ham a coeng moenih,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Te dongah BOEIPA loh amah te, “Cet laeh, suntla lamtah namah khaw Aaron khaw namah neh ha puei uh. Tedae khosoih rhoek neh pilnam tah BOEIPA taengla caeh ham koengloeng uh boel saeh. Amih taengah pung ve,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Moses te pilnam taengla suntla tangloeng tih amih te a thui pah. ");
INSERT INTO hlt_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Pathen loh ol cungkuem he a thui tih, ");
INSERT INTO hlt_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Kai na Pathen Yahweh loh nang te Egypt kho kah sal im lamloh kang khuen. ");
INSERT INTO hlt_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ka mikhmuh ah a tloe pathen te nang ham om boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Namah ham mueithuk neh vaan so lamkah khaw, diklai hman neh a dang lamkah khaw, tui khui neh a dang lamkah muei cungkuem te diklai ah saii boeh. ");
INSERT INTO hlt_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Te rhoek taengah bakop boel lamtah amih taengah thothueng boeh. Kai Yahweh, nang kah Pathen, thatlai Pathen loh kai aka hmuhuet taengah tah, pa rhoek kathaesainah te ca rhoek soah khongthum neh khongli hil ka cawh. ");
INSERT INTO hlt_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Kai aka lungnah tih ka olpaek aka tuem taengah tah a thawng thawng la sitlohnah tueng. ");
INSERT INTO hlt_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Na Pathen Yahweh ming te a poeyoek la muk boeh. A ming a poeyoek la aka muk te BOEIPA loh a hmil moenih. ");
INSERT INTO hlt_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Sabbath hnin te ciim hamla poek. ");
INSERT INTO hlt_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Hnin rhuk thotat lamtah na bitat te boeih saii. ");
INSERT INTO hlt_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Tedae a rhih hnin tah na BOEIPA Pathen ham Sabbath ni. Na bitat cungkuem dongah, na capa khaw, na canu khaw, na salpa khaw, na salnu khaw, na rhamsa khaw, na vongka kah yinlai khaw tueih boeh. ");
INSERT INTO hlt_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","BOEIPA loh vaan neh diklai, tuitunli neh a cungkuem he hnin rhuk ah a saii dae a rhih hnin ah duem. Te dongah BOEIPA loh Sabbath hnin te yoethen a paek tih a ciim. ");
INSERT INTO hlt_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Na nu neh na pa te thangpom. Te daengah ni na Pathen Yahweh loh nang taengah m'paek diklai ah na hinglung a vang eh. ");
INSERT INTO hlt_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Hlang ngawn boeh. ");
INSERT INTO hlt_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Samphaih boeh. ");
INSERT INTO hlt_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Huen boeh. ");
INSERT INTO hlt_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Na hui te laithae laipai neh doo boeh. ");
INSERT INTO hlt_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Na hui kah im te nai boeh. Na hui kah a yuu, a sal neh a salnu khaw, a vaito neh a laak khaw, na hui kah boeih te nai boeh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Te vaengah pilnam boeih loh olthang neh hmaithoi, tuki ol neh tlang kah a khuu te a hmuh uh. Pilnam loh a hmuh vaegah hinghuen uh tih a hla la pai uh. ");
INSERT INTO hlt_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Te phoeiah Moses taengah, “Namah loh kaimih taengah thui lamtah ka hnatun uh bitni. Pathen loh kaimih taengah thui boel saeh, ka duek uh ve,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Te dongah Moses loh pilnam te, “Nangmih noemcai ham Pathen ha pawk kong ah rhih uh boeh. Te kong nen ni na maelhmai ah amah hinyahnah om vetih na tholh uh pawt eh. ");
INSERT INTO hlt_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Te vaengah pilnam a hla la pai tih Moses tah Pathen om nah yinnah taengla thoeih. ");
INSERT INTO hlt_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Te phoeiah BOEIPA loh Moses te, “He he Israel ca rhoek taengah thui pah, vaan lamloh nangmih taengah ka thui te na hmuh uh. ");
INSERT INTO hlt_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kai neh thuidoek ham te saii uh boeh. Cakben pathen neh sui pathen khaw namamih ham saii uh boeh. ");
INSERT INTO hlt_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Kai hamla diklai hmueihtuk saii lamtah a soah na hmueihhlutnah neh na rhoepnah khaw, na boiva neh na saelhung khaw nawn uh. Hmuen cungkuem ah ka ming ka thoelh vaengah nang taengla ka pawk vetih nang yoethen kam paek ni. ");
INSERT INTO hlt_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kai hamla lungto hmueihtuk na saii atah a soah lungrhaih khoeng boeh. A soah na cunghang na hnonah koinih hmueihtuk ni na poeih eh. ");
INSERT INTO hlt_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ka hmueihtuk kah tangtlaeng soah yoeng boeh. A soah na yah te poelyoe boeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Te phoeiah laitloeknah he amih mikhmuh ah khueh pah. ");
INSERT INTO hlt_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Hebrew sal te na lai atah kum rhuk thotat saeh lamtah kum rhih hlang dongah tah sayalh la cet yungyi saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Amah bueng hoengpoek la ha pawk atah amah bueng hoengpoek la cet saeh. A yuu a va a om atah a yuu khaw amah neh cet saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","A boei loh anih te yuu a paek tih anih ham canu capa a sak atah a yuu neh a ca tah a boei kah ni. Tedae amah te amah bueng hoengpoek la cet saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Tedae sal loh, “Ka boei ka lungnah tih ka yuu neh ka ca he sayalh la ka coe tak mahpawh a ti khaw a ti khaming. ");
INSERT INTO hlt_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Te vaengah anih te a boei loh Pathen mikhmuh la khuen saeh lamtah thohkhaih taeng neh rhungsut taengla thoeih saeh. Te vaengah a boei loh a hna te ciphuem neh vueh pah saeh kumhal ham anih taengah thotat saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Te phoeiah hlang loh a canu te sal la a yoih atah, sal tongpa a caeh bangla cet mahpawh. ");
INSERT INTO hlt_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","A boei mik ah a thae atah anih te amah ham tuentah saeh lamtah lat saeh. Salnu taengah a hnukpoh coeng dongah salnu te kholong pilnam taengla yoih ham taemrhai boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Salnu te a capa ham a tuentah coeng atah anih te amah canu kah hamsum bangla saii pah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Amah ham te a tloe a loh atah, salnu kah a maeh, a himbai neh a hutakoe te hnop pah boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","He pathum he anih ham a saii pah pawt atah, tangka mueh la cet yungyi pawn saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Hlang a boh tih a duek atah amah khaw duek rhoe duek saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Anih loh rhaem ngawn pawt dae Pathen loh anih kut ah a rhul sak oeh atah nang ham hmuen ka khueh vetih te lam te rhaelrham bitni. ");
INSERT INTO hlt_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Tedae hlang loh a hui te ngawn ham taengnah neh a lokhak atah anih te ka hmueihtuk dong lamloh khuen lamtah duek saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","A manu a napa aka taam khaw duek rhoe duek saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Hlang aka huen neh te te a yoih vaengah a kut ah a hmuh pah khaw duek rhoe duek saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","A manu a napa aka tap khaw duek rhoe duek saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Hlang rhoi te oelh uh rhoi tih hlang pakhat loh a hui te lungto neh, kuthluem neh a thuk dae duek pawt tih thingkong dongah a yalh atah, ");
INSERT INTO hlt_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","thoo tih poeng ah a conghol neh a pongpa atah anih aka ngawn te hmil mai saeh. A bipoei phu tah pae saeh lamtah hoeih rhoe hoeih sak saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Hlang loh a salpa neh a salnu te conghol neh a taam tih a kut hmuiah a duek atah a phuloh ham te a phulo kuekluek saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Tedae hnin hnih hnin at neh a thoh atah anih te amah tangka coeng dongah phulo boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Hlang a hnueih vaengah huta bungvawn te a si tih a ca te thoeng mai ni. Tedae yoethae puei pawt cakhaw huta kah a va amah lamloh a hoe te tah sah rhoe sah saeh. Tedae rhokhan tarhing la pae saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Tedae yoethae a puei atah hinglu ham te hinglu na paek van ni. ");
INSERT INTO hlt_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Mik yueng mik, no yueng no, kut yueng kut, kho yueng ah kho, ");
INSERT INTO hlt_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Hmai-ung yueng hmai-ung, tloh yueng tloh, boengha yueng boengha van saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Hlang loh a salpa mik a salnu mik te a ngawn pah tih a rhawp sak atah a mik yueng te sayalh la hlah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","A salpa no neh a salnu no te a hom sak atah a no yueng anih te sayalh la hlah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Vaito loh tongpa khaw, huta khaw a thoeh tih a duek atah vaito te dae rhoe dae saeh lamtah a saa te ca boel saeh. Tedae vaito kungmah tah ommongsitoe ngawn saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Tedae vaito te hlaem hlavai ah khaw a toh noek dongah a kungmah te a rhalrhing sak lalah ngaithuen pawt tih tongpa khaw huta khaw a duek sak atah vaito te dae saeh lamtah a kungmah khaw duek saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Anih taengah tlansum a suk atah te lamloh a hoe boeih te a hinglu kah tlansum pae van saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Capa a thoeh akhaw canu khaw a thoeh akhaw hekah laitloeknah bangla a taengah saii saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Vaito loh salpa khaw, sal huta khaw a thoeh atah a boei te tangka shekel sawmthum pae saeh lamtah vaito te dae saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Hlang loh tangrhom khaw a ong tih hlang loh rhom khaw a vueh vaengah te te muek pawt tih vaito khaw laak khaw a cungku atah, ");
INSERT INTO hlt_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Tangrhom kungmah loh thuung saeh lamtah a boei te tangka la mael saeh. Tedae aka duek te anih hut la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Hlang pakhat kah vaito loh a hui kah vaito te a si tih a duek atah vaito hing te yoi rhoi saeh lamtah a tangka te tael uh rhoi saeh. Te phoeiah aka duek te khaw tael uh rhoi saeh. ");
INSERT INTO hlt_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Tedae hlaem hlavai ah khaw vaito kah a toh noek te a ming lalah a kungmah loh te te a khoem pawt atah vaito yueng te vaito neh thuung rhoe thuung saeh lamtah aka duek te anih hut la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Hlang loh vaito khaw, tu khaw a huen tih a ngawn akhaw, a yoih akhaw vaito ham te saelhung panga neh tu ham boiva pumli neh thuung saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Umlawt ah hlanghuen a hmuh tih a boh vaengah a duek atah a taengah thii kap boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Khomik a thoeng atah a soah thii kap saeh lamtah aka huen loh sah rhoe sah saeh. A khueh pawt atah a huen dongah amah khaw yoi uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","A huen te a kut dongah a hmuh la a hmuh atah vaito khaw, laak khaw, tu khaw a hing neh rhaepnit la sah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Hlang loh lohma neh misurdum a laem sak vaengah a rhamsa te a hlah tih a rhamsa loh a tloe lohma li te a laem pa atah a khohmuen lamkah a then, a misurdum kah aka then neh thuung saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Hmai puek tih hling a dom vaengah canghlom neh canghli khaw, lohma khaw, a hlawp atah hmai aka hlong loh sah rhoe sah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Hlang loh a hui te tangka khaw hnopai khaw khoembael sak ham a paek. Tedae im lamkah te hlang loh a huen tih hlanghuen te a hmuh atah a rhaep la thuung saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Hlanghuen te a hmuh pawt atah a hui kah hno dongah a kut hlah pawt cakhaw im kung te Pathen taengla kun saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Boekoeknah olka cungkuem dongah vaito khaw, laak khaw, tu khaw, himbai khaw, he hnohma ni a ti boeih tah a panit la Pathen mikhmuh ah ol hang khuen saeh. Pathen kah a boe sak long te tah a hui te a rhaep la sah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Hlang loh a hui taengah laak neh vaito, tu neh rhamsa cungkuem khaw dawn ham a paek dae, duek mai tih tlawt mai ni, a hmuh pawt vaengah khaw a mawt pah khaming. ");
INSERT INTO hlt_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Te vaengah a hui kah hnopai soah a kut hlah pawt ham amih rhoi laklo aBOEIPA kah olhlo om saeh. A kungmah long khaw doe saeh lamtah sah boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Tedae anih taeng lamloh a huen la a huen atah a kungmah te sah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Te te a ngaeh rhoe a ngaeh tila laipai hang khuen atah saha te sah boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Hlang loh a hui taeng lamkah a vat dae a taengah a kungmah a om pawt vaengah a khaem sak tih a duek atah sah rhoe sah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","A kungmah te a taengah a om atah sah boel saeh. Te te a kutloh coeng atah a thapang neh mael saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","tongpa loh oila a bae mueh te a yoek tih a taengah a yalh atah a yuu la oei rhoe oei saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","A napa loh hula te anih taengah paek ham a aal la a aal atah oila kah maan bangla tangka thuek pah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Hlangbi khaw hing sak boeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Rhamsa taengkah aka yalh boeih tah duek rhoe duek saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Yahweh amah bueng taeng pawt ah pathen tloe rhoek taengah aka nawn tah thup saeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Yinlai khaw vuelvaek boeh, Egypt kho ah yinlai la na om uh coeng dongah nen boeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Nuhmai neh cadah boeih tah phaep boeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Na phaep la na phaep tih kai taengah a pang la a pang atah a pangngawlnah te ka hnatun rhoe ka hnatun pah ni. ");
INSERT INTO hlt_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Te vaengah ka thintoek sai vetih nangmih te cunghang neh kang ngawn ni. Na yuu rhoek te nuhmai la, na ca rhoek khaw cadah la om uh ni. ");
INSERT INTO hlt_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Nangmih taengkah ka pilnam mangdaeng te tangka na hlah pah atah a taengah puhlah bangla om boeh. Anih te a casai khueh pah boeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Na hui kah himbai te na laikoi la na laikoi atah khomik a khum hlan ah amah taengla mael laeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","A himbai khaw te kah himbai bueng ni a vin sokah a himbai dongah metlam a yalh eh ? Ka lungvatnah oeh dongah ka taengla a pang vaengah ka hnatun pah ni ta. ");
INSERT INTO hlt_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Pathen te thaephoei boeh, na pilnam sokah khoboei khaw thaephoei thil boeh. ");
INSERT INTO hlt_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Na thaihhmin neh na tuihuem khaw hloh thil boeh, na ca caming khaw kamah taengla m'pae. ");
INSERT INTO hlt_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Na vaito taeng neh na boiva taengah khaw saii tangloeng. Hnin rhih khuiah a manu neh om saeh lamtah hnin rhet dongah tah kamah taengla m'pae. ");
INSERT INTO hlt_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Kamah taengah hlang cim la om uh laeh. Khohmuen kah saha saa khaw ca uh boeh. Te te ui ham voeih pah. ");
INSERT INTO hlt_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","A poeyoek kah olthang khuen boeh. Kuthlahnah kah laipai la om ham halang neh na kut hlaengtang boeh. ");
INSERT INTO hlt_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Boethae dongah tah hlangping hnuk khaw om boeh. Kaengyai taengah hlangping neh kaengyai ham tuituknah dongah doo boeh. ");
INSERT INTO hlt_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Tattloel long khaw a tuituknah dongah n'hiin boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Na thunkha kah vaito khaw, a laak khaw a kho a hmaang te na hmuh atah amah taengla mael rhoe mael puei. ");
INSERT INTO hlt_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","A taengah na tlo-oeng la na tlo-oeng mai cakhaw na lunguet kah laak te a hnorhih dangah a kol te na hmuh atah anih taengah na tlo-oenng te khaw toeng laeh. ");
INSERT INTO hlt_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Na taengkah khodaeng te a tuituknah dongah a laitloeknah phaelh pah boeh. ");
INSERT INTO hlt_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","A honghi olka lamloh lakhla lamtah halang he ka tang sak pawt dongah ommongsitoe neh aka dueng khaw ngawn boeh. ");
INSERT INTO hlt_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Kapbaih khaw lo boeh, kapbaih loh miktueng khaw a dael sak tih a dueng ol khaw a paimaelh. ");
INSERT INTO hlt_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Yinlai khaw nen boeh, Egypt kho ah yinlai la na om van dongah yinlai kah hinglu te namah dongah ming puei. ");
INSERT INTO hlt_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Na khohmuen te kum rhuk tawn lamtah a vueithaih khaw coi. ");
INSERT INTO hlt_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Tedae a kum rhih te hmil lamtah haai sak. Te daengah ni na pilnam khodaeng loh a caak vetih a noi te khohmuen mulhing loh a caak. Na misurdum ham na olive ham khaw te te saii. ");
INSERT INTO hlt_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Hnin rhuk khuiah na bibi te saii lamtah a rhih hnin ah duem dae. Na vaito neh na laak khaw duem vetih na salnu kah a ca neh yinlai khaw a thasai ni. ");
INSERT INTO hlt_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Nangmih taengah a cungkuem la ka thui te ngaithuen uh. Pathen tloe rhoek ming khaw phoei uh boeh, Na ka dongah ya uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Kum khat ah kai ham khotue voei thum lam uh. ");
INSERT INTO hlt_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Nang kan uen bangla vaidamding khotue te tuem uh lamtah hnin rhih khuiah vaidamding ca uh. Egypt lamloh na hlah uh vaengkah Abib hla te khoning la om vetih ka mikhmuh ah kuttling la ha phoe boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Khohmuen na tawn te na bibi dongkah thaihcuek, cangah khotue neh kum boeih kah khohmuen lamloh na bibi na khoem vaengah cangyom khotue om ni. ");
INSERT INTO hlt_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Na khuikah tongpaca boeih tah kum khat ah voei thum Boeipa Yahovah mikhmuh ah phoe saeh. ");
INSERT INTO hlt_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Kai kah hmueih thii te tolrhu neh nawn boeh. Ka khotue kah maehtha khaw mincang duela rhaeh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Na khohmuen kah thaihcuek tanglue te na BOEIPA Pathen kah im la khuen. Ma-ae ca te a manu suktui neh thong boeh. ");
INSERT INTO hlt_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Longpuei ah nang aka ngaithuen ham neh ka hmoel hmuen hil nang aka khuen ham na mikhmuh ah puencawn kan tueih coeng ne. ");
INSERT INTO hlt_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","A mikhmuh ah ngaithuen lamtah a ol te hnatun. Anih te veet boeh, kai ming he a khui ah om coeng tih nangmih kah boekoeknah te duen mahpawh. ");
INSERT INTO hlt_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","A ol te na hnatun rhoela na hnatun tih ka thui te boeih na ngai atah na thunkha te ka thunkha nah vetih nang aka daengdaeh te ka dum van ni. ");
INSERT INTO hlt_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ka puencawn he nang hmai ah pongpa vetih nang te Amori neh Khitti taengla, Perizzi neh Kanaan taengla, Khivee neh Jebusi taengla n'thak vetih amih te ka thup ni. ");
INSERT INTO hlt_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Amih kah pathen taengah bakop boel lamtah amih taengah thothueng boeh. Amih kah khoboe bangla saii boeh. Te rhoek te koengloeng rhoe koengloeng lamtah a kaam te phaek la phaek pah. ");
INSERT INTO hlt_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","BOEIPA na Pathen taengah tho na thueng daengah ni na buh neh na tui khaw a yoethen vetih na khui lamkah tlohtat te kang khoe eh. ");
INSERT INTO hlt_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Na khohmuen ah thangyah neh caya khaw om pawt vetih na khohnin kah a tarhing te ka cup sak ni. ");
INSERT INTO hlt_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Kai taengkah mueirhih te na hmai ah ka tueih vetih a taengla na thoeng thil pilnam boeih te ka khawkkhek ni. Na thunkha boeih te nang taengah a rhawn ka duen sak. ");
INSERT INTO hlt_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nang mikhmuh ah khoingal te ka tueih vetih Khivee, Kanaan neh Khitti te na mikhmuh lamloh ka haek ni. ");
INSERT INTO hlt_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Kum khat nen tah na mikhmuh lamloh anih te ka haek mahpawh. Khohmuen te khopong la om vetih na taengah kohong mulhing pung aih ve. ");
INSERT INTO hlt_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Na pungtai hil na mikhmuh lamloh bet bet ka haek daengah ni khohmuen te na pang eh. ");
INSERT INTO hlt_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Na khorhi te carhaek tuipuei lamloh Philisti tuipuei duela, khosoek lamloh tuiva duela kan suem bitni. Khohmuen kah khosa rhoek te na kut ah kam paek vetih amih te na mikhmuh lamloh ka haek ni. ");
INSERT INTO hlt_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Amih taeng neh amih kah pathen taengah paipi saii boeh. ");
INSERT INTO hlt_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Na khohmuen ah khosa uh boel saeh, kai taengah na tholh ve. A pathen taengah tho na thueng atah na taengah hlaeh la poeh van ni. ");
INSERT INTO hlt_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Moses taengah, “Namah neh Aaron, Nadab, Abihu neh Israel khuikah a ham rhoek sawmrhih te BOEIPA taengah ha mop lamtah lakhla la bakop uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Tedae Moses amah bueng te BOEIPA taengah mop saeh. Amih te mop uh boel saeh lamtah pilnam khaw a taengla cet uh boel saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Te phoeiah Moses te cet tih BOEIPA ol boeih neh laitloeknah boeih te pilnam taengah a thui pah. Pilnam pum loh ol pakhat la a doo uh tih, “BOEIPA loh a thui ol te boeih ngai uh sih,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moses loh BOEIPA ol te boeih a daek. Mincang ah thoo tih tlang hmuiah hmueihtuk neh Israel koca hlai nit kah kaam hlai nit a suem. ");
INSERT INTO hlt_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Te phoeiah Israel ca cadong te a tueih tih hmueihhlutnah te a khuen uh. Te vaengah BOEIPA taengah rhoepnah hmueih la vaito a nawn uh. ");
INSERT INTO hlt_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moses loh thii rhakthuem te a loh tih baeldung dongah a khueh tih thii rhakthuem te hmueihtuk a haeh thil. ");
INSERT INTO hlt_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Te phoeiah paipi cabu a loh tih pilnam kah hna ah a tae. Te dongah, “BOEIPA kah a thui boeih te ka saii uh vetih ka hnatun uh bitni,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Te phoeiah Moses loh thii te a loh tih pilnam a haeh thil. Te vaengah, “Paipi thii he BOEIPA loh he ol cungkuem neh nangmih taengah a saii coeng ne,” a ti. ");
INSERT INTO hlt_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Te phoeiah Moses neh Aaron, Nadab neh Abihu neh Israel kah a hamca sawmrhih rhoek te koep cet uh. ");
INSERT INTO hlt_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Te vaengah Israel Pathen kah a kho hmui te minhum laiboeng kutngo bangla, vaan khocil phek la a hmuh uh. ");
INSERT INTO hlt_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Tedae Israel ca hlangcong rhoek te a kut thueng thil pawh. Te dongah Pathen a hmuh uh lalah a caak uh tih a ok uh bal pueng. ");
INSERT INTO hlt_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Te phoeiah BOEIPA loh Moses te, “Tlang soah kamah taengla ha luei lamtah pahoi om laeh. Amih thuinuet ham olkhueng neh olpaek ka daek thil lungto cabael te nang taengah kam pae eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Te dongah Moses neh a taengah aka thotat Joshua tah thoo tih Moses te Pathen kah tlang dongla luei. ");
INSERT INTO hlt_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","A hamca rhoek te khaw, “Nangmih taengla ka mael hil he ah he kai n'rhing uh. Aaron neh Hur khaw nangmih taengah om ngawn he ne. U khaw Olka dongah laikung long tah amih rhoi taengla mop saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moses te tlang la a luei van neh cingmai loh tlang te a thing. ");
INSERT INTO hlt_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","BOEIPA kah thangpomnah tah Sinai tlang ah pai tih cingmai loh hnin rhuk a dah. A hnin rhih dongah tah Moses te cingmai khui lamloh a khue. ");
INSERT INTO hlt_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","BOEIPA thangpomnah mueimae khaw Israel ca rhoek kah mik ah tah tlang som aka hlawp hmai bangla tueng. ");
INSERT INTO hlt_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Te vaengah Moses te cingmai khui la kun tih tlang la luei. Moses te tlang ah khothaih sawmli neh khoyin sawmli om. ");
INSERT INTO hlt_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Israel ca rhoek te thui pah lamtah hlang boeih lamkah khosaa te kai taengla hang khuen uh saeh. A lungbuei kah a puhlu bangla kai kah khosaa te doe pah. ");
INSERT INTO hlt_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Khosaa he amih taeng lamkah sui neh cak neh rhohum khaw, ");
INSERT INTO hlt_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Hlampai a thim, daidi, a lingdik khaw, hnitang neh maae mul khaw, ");
INSERT INTO hlt_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Tutal pho thimyum neh saham pho khaw rhining thing khaw, ");
INSERT INTO hlt_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Botui hmaivang ham neh koelhnah situi ham neh botui bo-ul ham situi khaw. ");
INSERT INTO hlt_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Hnisui neh rhangpho dongkah ham oitha lung neh saboi lung khaw coi laeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Te phoeiah kai ham rhokso saii uh lamtah a khui ah ka om eh. ");
INSERT INTO hlt_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Kai loh nang boeih kan tueng vanbangla dungtlungim muei neh a hnopai boeih kah muei te khaw saii tangloeng. ");
INSERT INTO hlt_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Rhining thing te thingkawng a yun dong nit neh tintan, a daang dong khat neh a tintan, a sang dong khat neh tintan ah saii uh. ");
INSERT INTO hlt_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Te phoeiah a khui ah sui cilh ben lamtah a hman ah khaw ben. A sokah a kong te a kaep ah sui neh saii pah. ");
INSERT INTO hlt_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Te phoeiah sui te a kutcaeng pali la hlawn lamtah a kho pali te buen pah. Te vaengah khat ben kah a vae dongah kutcaeng panit, pabae kah a vae dongah kutcaeng panit buen pah. ");
INSERT INTO hlt_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Te phoeiah rhining thing te a cung la saii lamtah sui ben thil. ");
INSERT INTO hlt_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","A cung te thingkawng vae kah a kutcaeng khuila rholh lamtah te nen te thingkawng kawt saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Thingkawng kutcaeng dongah a cung om saeh lamtah te lamloh dul boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Te phoeiah nang taengah kam paek ham laipainah te thingkawng khuiah khueh. ");
INSERT INTO hlt_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","A tlaeng khaw sui cilh neh a yun dong nit tintan neh a daang dong khat tintan ah saii. ");
INSERT INTO hlt_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Sui cakhli te cherubim rhoi la saii bal lamtah te rhoi te thingkawng tlaeng kah a hmoi rhoi ah khueh. ");
INSERT INTO hlt_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Cherub pakhat te he kah a hmoi ah, cherub pakhat tekhat ben kah a hmoi ah khueh lamtah a tlaeng te a hmoi rhoi ah cherubim te saii pah. ");
INSERT INTO hlt_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Cherubim aka om rhoi loh a phae te a so la phuel saeh lamah a phae neh thingkawng tlaeng soah khu rhoi saeh. Te vaengah pakhat loh a manuca taengah a maelhmai hmaitoh saeh lamtah cherubim maelhmai te tingkawng tlaeng taengah mael saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","A tlaeng te thingkawng soah a so la tloeng lamtah nang taengah olphong kam paek te thingkawng khuiah khueh. ");
INSERT INTO hlt_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Teah te nang kan tuentah vetih Israel ca rhoek ham nang kang uen olphong cungkuem te thingkawng tlaeng so lamkah cherubim rhoi laklo lamloh nang taengah kan thui ni. ");
INSERT INTO hlt_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Rhining thing te caboei a yun dong nit, a daang dong khat, a sang dong khat tintan la saii. ");
INSERT INTO hlt_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Te te sui cilh neh ben thil lamtah te ham te a kaepvai kah a kong te sui neh saii pah. ");
INSERT INTO hlt_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","A kae ham te a kaep ah kutsom pakhat khueh lamtah a kae dongkah a kaep ah a kong te sui neh saii. ");
INSERT INTO hlt_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Te ham te sui kutcaeng pali saii lamtah kutcaeng te a kho pali dongkah a kil pali ah bang pah. ");
INSERT INTO hlt_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Kutcaeng rhoek te a kae voeivang ah caboei aka kawt ham a cung rholhnah la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","A cung te rhining thing saii bal lamtah sui ben thil. Te nen te caboei kawt saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Bael neh yakbu neh tui-um neh tuisi-am khaw saii. Sui cilh neh te rhoek te saii lamtah te rhoek nen te tuisi doeng saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ka mikhmuh kah a hmai buh te caboei soah khueh yoeyah. ");
INSERT INTO hlt_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Hmaitung te sui cilh cakben neh saii bal. Hmaitung kah a hlit neh, a kong, a bunang, a paimuem khaw saii pah lamtah te lamloh a rhaiphuelh te om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Hmaitung te a kaep lamloh a kong parhuk cawn saeh. A vae khat lamloh hmaitung kong pathum neh a vae pabae lamloh hmaitung a kong pathum cawn saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","A kong pakhat dongah rhaimuem rhaiphuelh neh noepai bunang pathum, a kong pakhat dongah khaw rhaimuem rhaiphuelh neh noepai bunang pathum om saeh lamtah hmaitung lamkah aka cawn aka kong parhuk dongah khaw om tangloeng saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Te dongah hmaitung dongkah rhaimuem rhaiphuelh neh noepai bunang he pali lo saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Hmaitung lamloh a kong parhu a thoeng dongah te lamkah a kong rhoi hmuiah rhaimuem pakhat, a kong panit hmui bal ah rhaimuem pakhat, a kong panit hmuiah khaw rhaimuem pakhat om bal saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Te lamkah a rhaimuem neh a kong te a pum la sui cilh cakben neh pakhat la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Hmaithoi parhih saii bal lamtah hmaithoi te tok pah. Te vaengah a hmai rhalvang ah khaw tue saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","A paitaeh neh a baelphaih khaw sui cilh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","He hnopai boeih he amah sui cilh talent khat he saii saeh. ");
INSERT INTO hlt_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Tedae so lamtah tlang ah nang a muei kan tueng bangla saii,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Te phoeiah dungtlungim te hlampai lingdik, daidi neh a thim neh a tah hnitang himbaiyan yung rha neh saii. Bibi te moeh lamtah cherubim te saii. ");
INSERT INTO hlt_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Himbaiyan pakhat a yun te dong kul dong rhet saeh lamtah a daang dong li saeh. Himbaiyan boeih ham himbaiyan pakhat kah cungnueh pakhat dongah om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Himbaiyan panga te khat neh khat cong uh saeh lamtah, himbaiyan panga bal khat neh khat cong uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Himbaiyan pakhat kah buenyang a bawt hil te a hmoi ah rhuikawl a thim la vaeh pah. A pabae rhui at dongkah himbaiyan a hmoi dongah khaw a bawt hil te tlam te saii bal. ");
INSERT INTO hlt_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Himbaiyan pakhat dongah rhuikawl sawmnga saii lamtah a pabae rhui at dongkah himbaiyan hmoi ah pumpi sawmnga khaw saii pah. Rhuikawl te khat loh khat te doe saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Te phoeiah sui rhuithu sawmnga saii lamtah himbaiyan pakhat te pakhat dongla rhuithu neh phaai sak. Te dongah dungtlungim te pakhat la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Dungtlungim sokah tamkui ham te maae mul himbaiyan saii. Himbaiyan te hlai khat ah saii. ");
INSERT INTO hlt_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Himbaiyan pakhat te a yun dong sawmthum neh a daang te dong li lo ni. Himbaiyan hlai khat ham te himbaiyan pakhat kah cungnueh pakhat dongah om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Himbaiyan panga te amah ah cong lamtah himbaiyan parhuk te amah ah cong bal. Te phoeiah a parhuk kah himbaiyan te dap hmai kah imdan ah rhaep pah. ");
INSERT INTO hlt_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Himbaiyan pakhat kah a hmoi ah buenyang a bawt hil rhuikawl sawmnga saii lamtah a pabae kah himbaiyan a hmoi ah buenyang te rhuikawl sawmnga khueh pah. ");
INSERT INTO hlt_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Te phoeiah rhohum rhuithu sawmnga saii lamtah rhuithu te rhuikawl neh ban pah. Dap te phaai uh saeh lamtah pakhat la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Dap kah himbaiyan lamloh a hoei saa la aka hoei himbaiyan ngancawn te dungtlungim kah imthael ah dingkoei saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Te vaengah dap kah himbaiyan a yun aka hoei te he ben ah dong khat neh ke ben ah dong khat tah dungtlungim kah a vae ah a hup om saeh lamtah khat ben ah khaw khat ben ah khaw khuk saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Te phoeiah dap kah imphu te tutal pho thimyum neh a so kah imphu la saham pho te saii thil. ");
INSERT INTO hlt_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Dungtlungim kah a longlaeng la rhining thing aka pai te saii. ");
INSERT INTO hlt_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","A yun kah a longlaeng te dong rha neh a daang kah a longlaeng pakhat he dong khat tintan lo saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","A longlaeng dongkah dangkam rhoi khaw pakhat te a pakhat dongah kiba uh saeh. Dungtlungim a longlaeng boeih ham khaw te tlam te saii tangloeng. ");
INSERT INTO hlt_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Dungtlungim ham a longlaeng te tuithim ben la tuithim kah a ngong ham tah a longlaeng pakul saii. ");
INSERT INTO hlt_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","A longlaeng pakul dangah cak buenhol sawmli saii pah. A longlaeng pakhat ka a lo panit ham a dangah buenhol panit om vetih a longlaeng pakhat a lo rhoi ham a dangah buenhol panit om ni. ");
INSERT INTO hlt_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Dungtlungim kah impalai ham khaw a pabae la tlangpuei saa ah a longlaeng pakul om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","A buenhol sawmli te khaw cakla om saeh. A longlaeng pakhat dangah buenhol panit, a longlaeng pakhat dang van ah khaw buenhol panit om van saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Dungtlungim kah a bawtnah ham te tuipuei ben ah a longlaeng parhuk caeh sak. ");
INSERT INTO hlt_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Imthael ben ah dungtlungim kah a hmuidong ham a longlaeng panit khueh pah. ");
INSERT INTO hlt_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Te vaengah a dang lamloh tungbok la om saeh. Tedae a soi ah hmabuet la rhen om saeh lamtah kutcaeng pakhat khuila kun saeh. Te rhoi kah a om bangla imki rhoi dongah khaw om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Te dongah a longlaeng parhet neh a buenhol te cak buenhol la hlai rhuk lo ni. A tlonglaeng pakhat kah dongah buenhol panit, a longlaeng pakhat van donngah khaw buenhol panit tlip om ni. ");
INSERT INTO hlt_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Dungtlungim kah impalai pakhat dongkah a longlaeng ham thohkalh la rhining thing panga khueh pah. ");
INSERT INTO hlt_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Dungtlungim pabae ben impalai kah a longlaeng ham thohkalh panga, khotlak imthael ah khaw dungtlungim kaep a longlaeng ham khaw thohkalh panga lo saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","A longlaeng laklung kah thohkalh tah a hmoi khat lamloh a hmoi hil a bangli ah rholh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","A longlaeng te khaw sui ben thil. Thohkalh rholhnah a kutcaeng te khaw sui neh saii. Te phoeiah thohkalh rhoek te sui ben thil. ");
INSERT INTO hlt_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Tlang ah a rhimong n'tueng bangla dungtlungim te thoh pah. ");
INSERT INTO hlt_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Hniyan khaw hlampai a thim, daidi neh a lingdik neh loeih pah. Hnitang na tah khaw bibi te moeh lamtah cherubim te saii pah. ");
INSERT INTO hlt_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Te te ngun buenhol pali sokah sui a ben thil rhining tung pali dongkah sui voei dongah pae. ");
INSERT INTO hlt_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Hniyan te rhuithu dangah na ban phoeiah tah hniyan khui ah olphong thingkawng te pahoi kun puei . Te vaengah hniyan loh nangmih ham te hmuencim laklo neh hmuencim kah hmuencim koek laklo te phih saeh. ");
INSERT INTO hlt_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","A tlaeng te khaw hmuencim lakah hmuencim kah olphong thingkawng soah khueh pah. ");
INSERT INTO hlt_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Hniyan kah kawtpoeng ah caboei te hol pah. Dungtlungim kaep tuithim kah caboei danah hmaitung om saeh lamtah tlangpuei ben ah caboei te khueh bal. ");
INSERT INTO hlt_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Dap Thohka ham himbaiyan khaw hlampai a thim, daidi, a lingdik neh tak lamtah hnitang na tah khaw na kutci neh en thil. ");
INSERT INTO hlt_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Himbaiyan ham rhining tung panga ah saii lamtah te te sui ben thil. Te sui voei ham khaw rhohum buenhol panga hlawn pah. ");
INSERT INTO hlt_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Rhining thing hmueihtuk a yun dong nga neh a daang dong nga ah saii. Hmueihtuk te hniboeng la om saeh lamtah a sang te dong thum lo saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Te phoeiah a ki te a kil pali ah saii pah. Te lamkah a ki aka om khaw rhohum ben thil. ");
INSERT INTO hlt_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","A duen ham a am neh a hmaisoh khaw, a baelcak neh a ciksum khaw, a baelphaih khaw saii, a hnopai boeih te rhohum mah saii. ");
INSERT INTO hlt_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Rhohum vairhuek dongkah kutngo la pahak saii lamtah vairhuek dongkah a hmoi pali ah rhohum kutcaeng pali saii pah. ");
INSERT INTO hlt_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Te te hmueihtuk kong dangah a laedil la khueh lamtah vairhuek te hmueihtuk boengli hil om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Te phoeiah rhining thing thingpang te hmueihtuk ham a cung la saii lamtah te te rhohum ben thil. ");
INSERT INTO hlt_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","A cung te kutcaeng khuila rholh lamtah hmueihtuk a koh vaengah a cung a vae rhoi ah om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Te te thingphael aka khui neh saii lamtah tlang ah nang n'tueng bangla saii tangloeng. ");
INSERT INTO hlt_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Tuithim ben ah dungtlungim vongup ham tuithim thoh te thung pah. Te vaengah vongtung hamla hnitang te a yun dong yakhat ah a hmoi pakhat la rhuih tah pah. ");
INSERT INTO hlt_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","A tung pakul neh a buenhol pakul te rhohum saeh lamtah tung dongkah voei neh a yaeltlang te ngun saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Tlangpuei ben ah khaw thoh te a yun la a yun yakhat lo van saeh. A tung bal khaw a tung pakul neh a buenhol pakul tah rhohum vetih tung dongkah voei neh a yaeltlang te ngun saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Khotlak ben kah vongtung la thoh a daang dong sawmnga lo saeh. A tung parha neh a buenhol khaw parha lo saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Vongtung kah a daang te khocuk khothoeng ben ah dong sawmnga lo saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","A hlaep kah thoh te dong hlai nga vetih a tung pathum neh a buenhol khaw pathum saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","A pabae a hlaep ah khaw thoh dong hlai nga neh a tung pathum, a buenhol pathum om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Vongtung vongka kah himbaiyan ham te dong kul ah a thim, daidi neh hlampai lingdik neh hnitang la tah pah. Kutci neh en thil lamtah a tung pali neh a buenhol pali lo saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Vongup kaepvai kah tung boeih te cak neh cen saeh. A voei khaw cak saeh lamtah a buenhol te rhohum saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Vongtung kah a yun te dong yakhat vetih a daang dong sawmnga, sawmnga lo ni. Te vaengah a sang dong nga ah hnitang la tak saeh lamtah a buenhol tah rhohum saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Dungtlungim kah hnopai boeih neh a thothuengnah boeih dongkah khaw, a ciphuem boeih neh vongtung hlingcong boeih te rhohum saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Namah loh Israel ca rhoek te uen lamtah hmaithoi dongah hmaivang la phat tok ham olive situi cil a sui te nang taengla hang khuen uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Laipainah hmai, hniyan vongvoel kah tingtunnah dap ah te Aaron neh anih koca rhoek loh BOEIPA mikhmuh ah hlaem lamloh mincang hil te te tael uh saeh. He he Israel ca taengkah a cadilcahma ham kumhal kah khosing ni. ");
INSERT INTO hlt_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Namah loh Israel ca rhoek khui lamkah na maya Aaron neh a taengkah anih ca rhoek te namah taengah khueh laeh. Aaron amah neh Aaron ca rhoek Nadab, Abihu, Eleazar neh Ithamar tah kamah taengah khosoih saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Na maya Aaron ham himbai cim te thangpomnah neh boeimangnah la khueh pah. ");
INSERT INTO hlt_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Namah loh cueihnah mueihla ka cung sak tih lungbuei kah aka cueih boeih te thui pah. Te vaengah kai taengkah khosoih la aka ciim uh Aaron kah himbai te hui uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Te himbai dongah rhangpho neh hnisui, hnikul neh kutthun angkidung, lupong neh lamko te saii uh saeh. Te vaengah kai taengah aka khosoih ham na manuca Aaron ham neh anih koca rhoek ham himbai cim saii uh. ");
INSERT INTO hlt_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Amih loh sui neh a thim neh, daidi neh hlampai a lingdik neh hnitang khaw doe uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Hnisui te sui, a thim neh daidi, hlampai a lingdik neh kutci la a moeh tih a tah hnitang neh saii uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Te dongkah a hmoi rhoi ah aka om te holhnam rhoi ah hlin saeh lamtah phaai uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","A pholip dongah cihin khaw a kutngo bangla amah dongah om saeh lamtah sui, a thim, daidi, hlampai a lingdik neh hnitang la tak saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Te phoeiah oitha lung panit te lo lamtah a soah Israel ca ming tarhit pah. ");
INSERT INTO hlt_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","A ming parhuk te lungto pakhat dongah ming parhuk vetih aka coih te lungto pabae dongah amamih kah rhuirhong bangla tarhit pah. ");
INSERT INTO hlt_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Kutthai kutnaep, thingthuk lung kah kutbuen bangla lungto rhoi te tarhit. Te te Israel ca ming neh vael lamtah sui oibom dongah hol. ");
INSERT INTO hlt_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Lungto rhoi te hnisui dongkah holhnam dongla Israel ca rhoek kah poekkoepnah lungto la hulh pah. Te vaengah Aaron loh amih ming te BOEIPA mikhmuh kah poekkoepnah la a laengpang rhoi ah vah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Te phoeiah sui oibom saii. ");
INSERT INTO hlt_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Sui cilh neh cangtui-rhaica te rhuinit hulh lamtah te te kutci neh rhuivaeh la khueh. Te phoeiah rhuivaeh cangtui-rhaica te oibom dongah khit. ");
INSERT INTO hlt_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Hnisui dongkah kutngo bangla laitloeknah rhangpho na saii khaw bibi la moeh. Te te sui neh hlampai, thim, daidi, a lingdik neh saii. Te phoeiah hnitang a tah neh te te saii thil. ");
INSERT INTO hlt_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Te te yaep lamtah a yun khap at neh a daang khap at ah hniboeng la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Te soah lungto hulhnah te a than pali la dueh. Than cuek te lungling, vaya neh tamkuei he lungto than at vetih, ");
INSERT INTO hlt_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","A than bae dongah khocillung, minhum neh lungmik. ");
INSERT INTO hlt_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","A than thum dongah oithii, khopang lung neh kemden, ");
INSERT INTO hlt_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","A than li dongah timsuih, oitha neh maihae te sui cueh thil lamtah a hulhnah neh om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Lungto rhoek khaw Israel ca hlai nit ming la sum uh saeh. Kutbuen thingthuk dongkah a ming bangla hlang boeih he koca hlai nit dongah amah ming neh om uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Rhangpho soah cangtui-rhaica cuehnah te sui cilh rhuivaeh neh kutnaep la saii. ");
INSERT INTO hlt_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Rhangpho dongkah sui kutcaeng panit saii lamtah rhangpho kah a hmoi rhoi ah kutcaeng nit la buen. ");
INSERT INTO hlt_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Sui rhuivaeh rhoi te rhangpho hmoi kah kutcaeng rhoi dongla khih pah. ");
INSERT INTO hlt_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Te phoeiah rhuivaeh rhoi kah a hmoi rhoi te oibom rhoi dongla hlin lamtah a maelhmai hmai a hnisui dongah holhnam dongla khih pah. ");
INSERT INTO hlt_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Te phoeiah sui kutcaeng panit saii lamtah te te rhangpho kah a hmoi rhoi la khit. A hmuidong te hnisui saa dongah a khui la det. ");
INSERT INTO hlt_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Te phoeiah sui kutcaeng panit saii lamtah te te a hmai kah a dang, hnisui cihin sokah a rhui voeivang ah hnisui dongkah holhnam rhoi dongla khih pah. ");
INSERT INTO hlt_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Rhangpho kah a kutcaeng lamloh hnisui kah kutcaeng duela a kutcaeng te pin saeh lamtah hnisui kah cihin duela hamnak thim neh om saeh. Te daengah ni hnisui dong lamkah rhangpho te khaw a hawl pawt eh. ");
INSERT INTO hlt_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Te dongah Aaron Israel ca ming te a lungbuei dongkah laitloeknah rhangpho dongah vah saeh lamtah hmuencim la a kun vaengah BOEIPA mikhmuh kah poekkoepnah la om yoeyah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Laitloeknah rhangpho khuiah Urim neh Thummim khueh pah lamtah BOEIPA mikhmuh la a kun vaengah Aaron kah lungbuei ah om. Te vaengah Aaron loh Israel ca kah laitloeknah te BOEIPA mikhmuh ah a lungbuei ah phuei yoeyah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Hnisui hnikul te a thim la boeih saii. ");
INSERT INTO hlt_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","A hmoi a laklung ah a lu ham a rhai om saeh. A rhai kaepvai te rhawnmoep rhai a om bangla kutnaep la a yen neh om saeh. Te daengah ni a pawn pawt eh. ");
INSERT INTO hlt_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","A hnihmoi ah tale a thim, daidi neh hlampai a lingdik neh saii. A hmoi kaepvai te a laklo ah sui hling neh pin thalh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Hnikul kah hnihmoi dongah sui hling neh tale thaih, sui hling neh tale thaih pin bang pah. ");
INSERT INTO hlt_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaron soah thohtat ham om tih BOEIPA mikhmuh kah hmuencim la a kun vaengah a ol pa saeh. Te daengah ni a vuenva vaengah a duek pawt eh. ");
INSERT INTO hlt_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Te phoeiah sui cilh tamlaep te saii lamtah a sokah kutbuen thingthuk te, “BOEIPA ham Cim,” tila thuk pah. ");
INSERT INTO hlt_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Te te hamrhui thim dongah khih pah lamtah lupong dongah om saeh. Lupong hmai ah ah om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Te vaengah Aaron tal ah om vetih cimcaihnah dongah a ciim Israel ca rhoek kathaesainah te amih kah cimcaihnah kutdoe boeih te Aaron loh phuei saeh. Te daengah ni amih ham khaw a tal dongah BOEIPA mikhmuh kah kolonah la phat a om eh. ");
INSERT INTO hlt_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Hnitang angkidung te cueh lamtah hnitang lupong khaw saii. Te phoeiah lamko saii lamtah kutnaep la en. ");
INSERT INTO hlt_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aaron koca rhoek ham khaw angkidung khueh pah lamtah amih ham lamko saii pah. Samkhuem khaw amih thangpomnah ham neh boeimangnah ham saii pah. ");
INSERT INTO hlt_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Te te na maya Aaron neh a taengkah anih koca rhoek te bai sak lamtah amih te koelh. Amih kut te cung sak lamtah amih te ciim. Te phoeiah kai taengla khosoih uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Amih ham a yah saa aka dah la takhlawk hnii saii pah lamtah a chinghen lamloh a phai duela dah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron neh anih koca loh tingtunnah dap khuila a kun uh vaengah khaw, hmuencim ah thohtat ham hmueihtuk la a mop uh vaengah puei uh saeh. Te daengah ni thaesainah a phueih vaengah a duek uh pawt eh. He he anih ham neh anih phoeikah a tiingan ham kumhal kah khosing coeng ni. ");
INSERT INTO hlt_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Kamah taengah khosoih sak ham a ciim uh vaengah amih taengah he ol bangla saii. Te vaengah saelhung ca khuikah vaito pakhat neh tutal panit a hmabuet te khuen pah. ");
INSERT INTO hlt_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Te vaengah vaidamding buh, situi neh a nom vaidamding laep, situi neh a koelh vaidamding rhawm te cangtang vaidam neh saii. ");
INSERT INTO hlt_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Te rhoek te kodawn pakhat dongah sang lamtah kodawn khaw, vaito khaw, tutal rhoi khaw rhen khuen. ");
INSERT INTO hlt_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Te phoeiah Aaron neh anih koca rhoek te tingtunnah dap thohka la khuen lamtah amih te tui neh sil. ");
INSERT INTO hlt_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Te phoeiah himbai te lo lamtah Aaron te angkidung neh hnisui hnikul khaw, hnisui neh rhangpho te bai sak lamtah hnisui dongkah cihin neh a pum dongah nan pah. ");
INSERT INTO hlt_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","A lu soah lupong muei sak lamtah lupong te cimcaihnah rhuisam khuem sak. ");
INSERT INTO hlt_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Te phoeiah koelhnah situi lo lamtah a lu ah suep lamtah anih te koelh. ");
INSERT INTO hlt_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Anih koca rhoek te khaw hang kuen lamtah angkidung bai sak. ");
INSERT INTO hlt_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Aaron neh a ca rhoek te lamko vah sak lamtah amih te samkhuem khuem sak. Te te khosoihbi dongah kumhal khosing la om saeh lamtah Aaron kut neh anih koca kah kut te cung sak. ");
INSERT INTO hlt_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Vaitotal te tingtunnah dap hmai la khuen lamtah Aaron neh anih koca rhoek loh a kut te vaitotal lu soah tloeng saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Te phoeiah vaitotal te tingtunnah dap thohka kah BOEIPA mikhmuh ah ngawn. ");
INSERT INTO hlt_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Vaito thii te lo lamtah na kutdawn neh hmueihtuk ki dongah pae. Te phoeikah thii boeih te hmueihtuk kah khoengim taengah hawk. ");
INSERT INTO hlt_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Te phoeiah a kotak aka thing a tha boeih neh, a thin dongkah a thinhnun khaw, a kuel rhoi neh te dongkah a tha khaw lo lamtah hmueihtuk ah phum. ");
INSERT INTO hlt_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Tedae vaito saa neh a pho khaw, a aek khaw, boirhaem rhaehhmuen voel ah hmai neh hoeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Tutal pakhat te khuen bal lamtah Aaron neh anih koca rhoek loh a kut te tutal lu soah tloeng uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Tutal te na ngawn phoeiah a thii te lo lamtah hmueihtuk kaepvai ah haeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Te phoeiah tu te maehpoel la sah. Tedae a kotak neh a kho te sil lamtah maehpoel neh a lu te khueh. ");
INSERT INTO hlt_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Tu a pum te hmueihtuk soah BOEIPA kah hmueihhlutnah la phum. Te te BOEIPA taengah hmuehmuei botui hmaihlutnah la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","A pabae kah tutal te khuen bal lamtah Aaron neh anih koca rhoek loh a kut te tutal kah a lu soah tloeng saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Tu te na ngawn phoeiah a thii te lo lamtah Aaron hna kah hnapae so neh a ca rhoek hna kah a bantang hnapae dongah khaw, kut kah bantang kutnu dongah khaw, a bantang kho kah khopuei dongah pae. Te phoeiah a thii te hmueihtuk kaepvai ah haeh thil. ");
INSERT INTO hlt_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Te phoeiah hmueihtuk sokah thii neh koelhnah situi te lo lamtah Aaron so neh a himbai soah khaw, amah taengkah anih koca rhoek so neh anih koca kah himbai soah khaw haeh pah. Te vaengah amah neh a himbai khaw, a taengkah amah koca rhoek neh anih koca rhoek kah himbai te ciim saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Te phoeiah tu tha neh a kawl, a kotak aka dah a tha neh a thin dongkah thinhnun khaw, a kuel rhoi neh te rhoi dongkah a tha khaw, bantang laeng he khaw tutal dongkah saboi la lo. ");
INSERT INTO hlt_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Kodawn lamkah buh hluem at neh buh tha laep khat neh vaidamrhawm pakhat te BOEIPA mikhmuh ah vaidamding la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","A cungkuem te Aaron kut dong neh anih koca rhoek kut ah tloeng lamtah te te BOEIPA mikhmuh ah thueng hmueih la thueng. ");
INSERT INTO hlt_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Te phoeiah amih kut lamkah te lo lamtah BOEIPA mikhmuh kah hmueihtuk ah hmueihhlutnah neh hmuehmuei botui la phum. Te tah BOEIPA taengah hmaihlutnah la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Saboi tu kah a rhang te Aaron ham loh pah lamtah BOEIPA mikhmuh ah thueng hmueih la thueng pah. Te phoeiah nang ham maehvae la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Thueng hmueih kah a rhang te a ciim phoeiah tah khosaa kah a laeng te thueng pah. Te te Aaron ham neh anih koca rhoek ham ni saboi tu lamloh a ludoeng pah. ");
INSERT INTO hlt_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","He tah Israel ca rhoek taeng lamloh Aaron ham neh anih koca rhoek ham kumhal khosaa kah oltlueh la om saeh. Te khosaa tah Israel ca rhoek lamloh BOEIPA taengah amih kah khosaa la a nawn rhoepnah hmueih la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Aaron kah cimcaihnah himbai khaw anih phoeikah amah koca rhoek ham om pah saeh. Te dongah amih te koelh saeh lamtah amih kut te khaw amamih ah cung saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","A ca rhoek khui lamloh anih yueng hmuencim ah thotat ham tingtunnah dap khuila aka kun khosoih loh hnin rhih khuiah te te bai saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Saboi tu te lo lamtah a saa te hmuen cim ah thong. ");
INSERT INTO hlt_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron neh anih koca rhoek loh tingtunnah dap thohka kah tu saa neh kodawn dongkah kah buh te ca saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Te dongah te te amih a dawth tangtae tih ciim hamla a kut aka cung long tah ca saeh. Tedae te te a cim dongah kholong loh ca boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Tedae saboi maeh neh buh te mincang duela a coih atah a coih te hmai neh hoeh laeh. Te tah a cim dongah ca uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Te dongah nang kang uen boeih te Aaron ham neh anih koca rhoek ham saii lamtah amih kut te hnin rhih khuiah cung sak laeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Dawthnah ham hnin at ham boirhaem vaito nawn lamtah te ham na dawth nen te hmueihtuk dongah ciim sak. Te phoeiah hmueihtuk te ciim hamla koelh. ");
INSERT INTO hlt_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Hmueihtuk ham hnin rhih khuiah dawth pah lamtah ciim. Te daengah hmueihtuk te a cim kah a cim koek la om vetih hmueihtuk neh aka ben uh boeih khaw a ciim eh. ");
INSERT INTO hlt_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Hmueihtuk soah na nawn te tah kum khat tu ca vetih hnin at ham pumnit yoeyah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Tuca pakhat te mincang ah nawn lamtah tuca pabae te kholaeh ah nawn. ");
INSERT INTO hlt_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Bunang pali la a sui situi neh a thoek vaidam doh, misurtui bunang pali neh tuca pakhat te tuisi la doeng. ");
INSERT INTO hlt_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Tuca pabae te tah kholaeh ah mincang khosaa neh tuisi la nawn. Te nen te BOEIPA taengah hmuehmuei botui hmaihlutnah la saii. ");
INSERT INTO hlt_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Na cadilcahma ham khaw tingtunnah dap thohka kah BOEIPA mikhmuh ah hmueihhlutnah la om yoeyah saeh. Te ah nang te pahoi voek ham namah pahoi kan tuentah bitni. ");
INSERT INTO hlt_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Israel ca te khaw pahoi ka tuentah bal vetih ka thangpomnah loh a ciim ni. ");
INSERT INTO hlt_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Tingtunnah dap neh hmueihtuk te ka ciim tangloeng vetih Aaron neh anih koca rhoek te kamah taengah khosoih sak ham ka ciim ni. ");
INSERT INTO hlt_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Israel ca rhoek lakli ah kho ka sak vetih amih taengah Pathen la ka om ni. ");
INSERT INTO hlt_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Te vaengah Egypt kho lamloh amih aka khuen, amih kah Pathen Yahweh kamah he a ming uh bitni. Amih lakli ah kai Yahweh ni amih kah Pathen la ka om eh. ");
INSERT INTO hlt_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Bo-ul hlupnah hmueihtuk na saii vaengah rhining thing mah saii. ");
INSERT INTO hlt_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Hmueihtuk te a yun dong khat neh a daang dong khat saeh lamtah hniboeng la om saeh. Amah lamloh a ki hil a sang dong nit lo saeh. ");
INSERT INTO hlt_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Te te a imphu khaw, a pangbueng neh a ki khaw, sui cilh neh pin ben thil. Te te a khopnah khaw sui neh pin saii. ");
INSERT INTO hlt_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","A vae rhoi kah a khopnah hmui ah sui kutcaeng panit saii pah. A vae rhoi kah na saii phoeiah tah te kah te hmueihtuk aka kawt ham thingpang rholhnah la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Thingpang te rhining thing saii lamtah sui neh ben thil. ");
INSERT INTO hlt_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Hmueihtuk te olphong sokah a tlaeng hmai, olphong thingkawng taengkah hniyan hmai ah khueh. Te ah ni nang te pahoi kan tuentah eh. ");
INSERT INTO hlt_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Te dongah te Aaron loh mincang, mincang ah bo-ul botui phum saeh. Te te a rhoekbah vaengah khaw hmaithoi te tok saeh. ");
INSERT INTO hlt_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Aaron loh hlaemhmah kah hmaithoi a vang vaengah khaw bo-ul te phum saeh. Te te na cadilcahma ham khaw BOEIPA mikhmuh ah saii yoeyah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Te soah te kholong kah bo-ul neh hmueihhlutnah khaw khocang khaw khuen boeh. Te soah tuisi khaw doeng boeh. ");
INSERT INTO hlt_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaron loh kum khat ah vai tah hmueihtuk ki dongah boirhaem thii neh dawth saeh. Kum khat ah vai tah hmueihtuk dongah na cadilcahma ham dawthnah neh dawth pah saeh. Te tah BOEIPA ham a cim kah a cim koek ni. ");
INSERT INTO hlt_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Te phoeiah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Israel ca rhoek kah hlangmi te tae lamtah amih te soep. Te vaengah hlang boeih loh a hinglu kah tlansum te BOEIPA taengah pae uh saeh. Amih te ming a soep daengah ni a soep vanbangla tlohthae loh amih soah a om pawt eh. ");
INSERT INTO hlt_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ming soep ham aka paan boeih loh gerah pakul neh aka tluk hmuencim shekel te shekel ngancawn ah pae uh saeh. Shekel khat dong shekel rhakthuem he BOEIPA kah khosaa ni. ");
INSERT INTO hlt_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ming soep ham aka paan kum kul ca neh a so boeih long tah BOEIPA taengah khosaa pae saeh. ");
INSERT INTO hlt_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Na hinglu dawth ham BOEIPA kah khosaa na khueh te shekel pakhat kah rhakthuem lakah hlanglen long khaw pueh boel saeh lamtah tattloel long khaw hnop boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Israel ca rhoek taeng lamkah dawthnah tangka na doe te tingtunnah dap ah thothuengnah ham pae. Na hinglu aka dawth ham te BOEIPA mikhmuh ah Israel ca rhoek kah poekkoepnah la om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Te phoeiah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Silh vaengkah ham rhohum baeldung khaw saii lamtah a kho khaw rhohum saeh. Te te tingtunnah dap laklo neh hmueihtuk laklo ah hol lamtah tui pahoi tawn thil. ");
INSERT INTO hlt_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Te lamlong te Aaron neh anih koca rhoek loh a kut, a kho sil uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Tingtunnah dap im khuila a kun uh vaengah tui hlu uh saeh. Te daengah ni BOEIPA taengah hmaihlutnah phum ham neh thohtat ham hmueihtuk la a thoeih vaengah a duek uh pawt eh. ");
INSERT INTO hlt_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","A kut a kho te a silh uh daengah ni a duek uh pawt eh. Te dongah amah ham neh a tiingan ham khaw, a cadilcahma ham khaw kumhal kah oltlueh la amih taengah om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","BOEIPA loh Moses te a voek bal tih, ");
INSERT INTO hlt_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Namah bal loh namah ham boeilu botui murrah pi ya nga, thingsa botui yahnih sawmnga ngancawn, canhnam botui yahnih sawmnga, ");
INSERT INTO hlt_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","valaeng khaw hmuencim kah shekel dongah ya nga neh olive situi bunang khat ah lo laeh. ");
INSERT INTO hlt_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Te phoeiah aka thungnom bibi kah yuhnah si bangla hmuencim koelhnah situi he saii lamtah hmuencim kah koelhnah situi la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Te nen te tingtunnah dap neh olphong thingkawng khaw, ");
INSERT INTO hlt_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","caboei neh a tubael boeih khaw, hmaitung neh a tubael khaw, bo-ul hmueihtuk khaw, ");
INSERT INTO hlt_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","hmueihhlutnah hmueihtuk neh a hnopai boeih khaw, baeldung neh a kho te koelh pah. ");
INSERT INTO hlt_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Te rhoek te na ciim tangloeng daengah ni a cim kah a cim la a om tih te te aka ben boeih khaw a cimcaih eh. ");
INSERT INTO hlt_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Aaron neh anih koca rhoek khaw koelh lamtah kamah taengah khosoih sak ham amih te ciim laeh. ");
INSERT INTO hlt_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Israel ca te khaw thui pah lamtah , “Hmuencim kah koelhnah situi he tah na cadilcahma duela kamah taengah om saeh,”ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Hlang pum dongah yuh nah boel saeh lamtah te kah a lantang neh te bang te saii boeh. Te kah a cim te nangmih taengah khaw a cim la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Te bang aka thungnom tih kholong taengah te aka pae hlang te tah a pilnam lamloh hnawt saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Te phoeiah BOEIPA loh Moses te, “Namah ham botui aangpi neh khawphlawp khaw, botui tlangsungsing neh hmueihtui cil lo lamtah amah, amah om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Te te thungnom kutci loh cilrhik la a thoek, yuhnah bo-ul cim la saii. ");
INSERT INTO hlt_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Te te a tip la neet lamtah tingtunnah dap khuikah olphong hmai ah khueh. Te ah te nang kan tuentah vetih nangmih ham hmuencim kah hmuencim koek la om ni. ");
INSERT INTO hlt_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Te bo-ul na saii vaengkah a lan a tang neh namah ham saii boeh. BOEIPA ham namah taengah a cim om. ");
INSERT INTO hlt_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Te te him ham te bang aka saii hlang te a pilnam lamloh hnawt saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Judah koca lamloh Hur capa Uri kah a ca, a ming ah Bezalel la ka khue he hmu ne. ");
INSERT INTO hlt_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Anih te Pathen mueihla lamloh cueihnah neh, lungcuei neh, mingnah neh bitat cungkuem ka kum sak. ");
INSERT INTO hlt_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Sui neh ngun neh rhohum neh a saii te kopoek neh moeh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Lungto kutthaibibi neh cung sak ham neh thing kutthaibibi dongah khaw bitat cungkuem dongah saii ham ka khue. ");
INSERT INTO hlt_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Kai loh anih neh Dan koca kah Ahisamak capa Oholiab ka tuek coeng he ne. A lungbuei ah lungbuei kah a cueih cungkuem te cueihnah la ka paek tih nang kang uen te boeih saii uh saeh. ");
INSERT INTO hlt_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Tingtunnah dap neh olphong thingkawng khaw, a sokah a tlaeng neh dap dongkah hnopai boeih, ");
INSERT INTO hlt_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Caboei neh a tubael khaw, hmaitung tang neh a tubael boeih neh bo-ul hmueihtuk, ");
INSERT INTO hlt_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Hmueihhlutnah hmueihtuk neh a tubael boeih, baeldung neh a kho khaw, ");
INSERT INTO hlt_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Hnithun himbai neh khosoih Aaron kah hmuencim himbai khaw, aka khosoih ham a ca rhoek himbai khaw, ");
INSERT INTO hlt_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","koelhnah situi neh hmuencim kah bo-ul botui khaw nang kang uen bangla boeih a saii uh bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Namah loh Israel ca rhoek te voek lamtah, 'Ka Sabbath he kai laklo neh nang laklo kah miknoek la tuem. Na cadilcahma ham khaw nangmih aka ciim tah Yahweh kamah ni tila aka ming sak la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Nangmih ham a cim dongah Sabbath te tuem uh. Te te aka poeih tah duek rhoe duek saeh. Te vaengah bitat aka saii boeih khaw a hinglu te a pilnam khui lamloh hnawt pah saeh. ");
INSERT INTO hlt_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Hnin rhuk khuiah bitat te saii saeh. Tedae hnin rhih dongkah koiyaeh Sabbath tah BOEIPA ham khaw cim saeh. Sabbath hnin ah bitat aka saii boeih tah duek rhoe duek saeh. ");
INSERT INTO hlt_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Te dongah Israel ca rhoek loh Sabbath te tuem saeh. Sabbath a saii te a cadilcahma ham khaw kumhal kah paipila om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Kai laklo neh Israel ca rhoek laklo ah kumhal kah miknoekla om ni. BOEIPA loh hnin rhuk ah vaan neh diklai a saii. Tedae hnin rhih dongah a toeng tih tha a sai sak ta,'ti nah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Anih taengah a thui te a khah nen tah Sinai tlang ah Pathen kah kutdawn loh lungto cabael a daek tih olphong cabael panit la Moses taengah a paek. ");
INSERT INTO hlt_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Pilnam loh tlang lamkah Moses a suntlak ham yak coeng tila a hmuh. Te dongah pilnam te Aaron taengla tingtun uh tih a taengah, “Thoo lamtah kaimih ham pathen saii laeh. Te te mamih hmai ah cet saeh. Egypt kho lamloh mamih aka khuen Moses he, hlang khaw a taengah mebang a om khaw m'ming uh moenih,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Te dongah Aaron loh amih te, “Na yuu rhoek, na canu, na capa hna dongkah sui hnaii te dul uh lamtah kai taengah hang khuen uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Pilnam pumloh a hna dongkah sui hnaii te a dul uh tih Aaron taengla a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Amih kut lamkah a loh phoeiah tah te te cacung neh a dum tih vaito mueihlawn la a saii. Te phoeiah, “Israel nang kah pathen la he, he long ni Egypt kho lamloh nang ng'khuen he,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaron loh a hmuh vaengah a hmai ah hmueihtuk a suem. Te phoeiah Aaron loh a hoe tih, “Thangvuen ah BOEIPA taengah khotue om ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","A vuen ah thoo uh tih hmueihhlutnah a khuen uh. Rhoepnah a tawn phoeiah tah pilnam te ngol tih a caak a ok neh thoo uh tih nuei uh. ");
INSERT INTO hlt_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Te vaengah BOEIPA loh Moses te, “Egypt kho lamkah na khuen na pilnam he a poci coeng dongah cet lamtah suntla laeh. ");
INSERT INTO hlt_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Amih ka uen longpuei lamloh vilvak taengphael uh tih amamih ham mueihlawn vaito a saii uh. Te te a bawk uh tih te te a nawn uh. Te phoeiah, “Namah pathen long ni Israel khaw Egypt kho lamloh na khuen,” a ti uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Te phoeiah BOEIPA loh Moses te, “Pilnam he ka hmuh vaengah pilnam kah a rhawn khaw mangkhak rhoe he. ");
INSERT INTO hlt_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Te dongah kai he n'rhoe laeh. Ka thintoek he amih taengah sai vetih amih ka khap lah ve. Tedae nang te namtom taengah pilnu la kang khueh bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Te vaengah Moses tah a Pathen BOEIPA neh a maelhmai te thae coeng. Tedae, “BOEIPA aw balae tih Egypt kho lamloh tanglue thadueng neh, tlungluen kut neh na khuen na pilnam taengah na thintoek khaw a sai eh? ");
INSERT INTO hlt_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Balae tih Egypt rhoek loh a thui mai eh? A thae la, “Amih te tlang ah ngawn ham neh amih te diklai hman lamloh khah ham ni amih a khuen,” ti ve. Na thintoek thinsa lamloh mael lamtah na pilnam sokah boethae khaw kohlawt mai. ");
INSERT INTO hlt_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Abraham te khaw, Isaak te khaw, na sal Israel te khaw poek mai. Namah loh amih taengah na toemngam tih amih te, 'Na tiingan te vaan aisi bangla, ka ping sak vetih khohmuen pum he na tiingan taengah ka paek vetih kumhal ham a pang uh ni,’ ka ti nah,” na ti,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Te vaengah a pilnam soah boethae saii ham a thui tangtae te BOEIPA loh ko a hlawt. ");
INSERT INTO hlt_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Te daengah Moses te mael tih a kut dongkah olphong cabael panit neh tlang lamloh suntla thuk. Cabael rhoi te a vae rhoi ah a daek pah tih khatben ah khaw khatben ah khaw a daek. ");
INSERT INTO hlt_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Te rhoi tah Pathen kah kutngo cabael coeng tih, Pathen kah a cadaek a cadaek te amah loh cabael dongah a daek. ");
INSERT INTO hlt_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Pilnam kah a o ol te Joshua loh a yaak van vaengah Moses te, “Rhaehhmuen kah caemtloek ol te,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Tedae, “Thayung thamal aka doo ham ol pawt tih yawknah aka doo kah ol bal moenih. A doo ol ka yaak ngawn dae,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Rhaehhmuen la a moe vaengah vaitoca neh a lam te a hmuh. Te dongah Moses kah thintoek te sai tih a kut te a voeih. Te dongah a kut lamkah cabael rhoi khaw tlang yung ah bok rhek. ");
INSERT INTO hlt_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Te phoeiah vaitoca a saii uh te a loh tih hmai neh a hoeh. A tip la a neet phoeiah tui soah a phul tih Israel ca rhoek te a tul. ");
INSERT INTO hlt_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Te phoeiah Moses loh Aaron te, “A taengah tholh len na khuen pah ham he pilnam loh nang taengah balae a saii?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Te vaengah Aaron loh, “Ka boeipa kah thintoek khaw sai boel mai dae saeh. Pilnam a thae aih khaw namah loh na ming. ");
INSERT INTO hlt_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Kai taengah, “Kaimih ham pathen saii lamtah te te mamih hmai ah cet bitni. Egypt kho lamloh mamih aka mawt hlang, Moses he a taengah metla a om khaw m'ming moenih,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Te dongah amih te, “U khaw sui aka tah dul uh,” ka ti nah. Te vaengah kamah taengla m'paek uh tih hmai dongah ka pup hatah he vaitoca la poeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Te vaengah pilnam te a hlahpham coeng tila Moses loh a hmuh. Amih aka tlai thil taengah Aaron loh nueih thaboep la a hlahpham dong ni. ");
INSERT INTO hlt_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Te dongah Moses tah rhaehhmuen vongka ah pai tih, “BOEIPA kah te tah kai taengla,” a ti nah hatah Levi koca boeih te anih taengla tingtun uh. ");
INSERT INTO hlt_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Te phoeiah amih te, “Israel Pathen BOEIPA loh he ni a thui. Hlang loh a cunghang te a phai ah kaelh saeh. Cet saeh lamtah vongka lamloh vongka patoeng hil rhaehhmuen te hil saeh. Te vaengah a manuca hlang te khaw, a hui kah hlang khaw, a hmaiben hlang khaw ngawn saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Te dongah Moses ol bangla Levi koca rhoek loh a saii uh tih te hnin ah pilnam khuikah hlang thawng thum tluk cungku. ");
INSERT INTO hlt_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Te daengah Moses loh, “Tihnin ah BOEIPA ham na kut han cung sak coeng. Hlang he a ca taengah khaw a manuca taengah khaw, tihnin ah nangmih te yoethennah m'paek pawn ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","A vuen ah tah Moses loh pilnam te, “Nangmih he tholh len neh na tholh uh coeng dae BOEIPA taengah ka cet pawn vetih nangmih kah tholhnah ham ka dawth thai khaming,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Te phoeiah Moses te BOEIPA taengla mael tih, “Pilnam he aw, amamih ham sui pathen a saii uh dongah tholh len neh tholh coeng. ");
INSERT INTO hlt_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Tedae amih kah tholhnah phuei mai laeh. Te pawt atah kai he na daek tangtae na cabu lamloh n'khoe mai laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Tedae BOEIPA loh Moses taengah, “Kai taengah aka tholh te unim? Anih te ka cabu lamloh ka khoe bitni. ");
INSERT INTO hlt_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Te dongah cet lamtah nang taengah kan thui bangla pilnam te mawt laeh. Ka puencawn loh na hmai ah cet bitni ne. Ka cawh khohnin ah ngawn tah amamih kah tholhnah bangla amamih soah ka cawh van bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Aaron kah a saii bangla vaitoca te a saii uh dongah BOEIPA loh pilnam te a vuek. ");
INSERT INTO hlt_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","BOEIPA loh Moses taengah, “He lamloh namah cet lamtah nong laeh. Egypt khohmuen lamkah na khuen pilnam te khohmuen la khuen laeh. Te te Abraham taengah, Isaak taeng neh Jakob taengah ka toemngam tih, “Na tiingan taengah ka paek ni,” ka ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nang mikhmuh ah puencawn kan tueih vetih Kanaan neh Amori khaw, Khitti neh Perizzi, Khivee neh Jebusi khaw ka haek bitni. ");
INSERT INTO hlt_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Suktui neh khoitui aka long khohmuen lam khaw na khui ah ka pongpa mahpawh. Pilnam he na rhawn mangkhak aih tih longpueng ah nang kang khap lah ve,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Pilnam loh ol thae he a yaak vaengah nguekcoi uh tih hlang loh a pum dongkah a cangen khaw oi uh pawh. ");
INSERT INTO hlt_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Te dongah BOEIPA loh Moses taengah, “Israel ca rhoek te thui pah. Nangmih he rhawn thah pilnam ni. Na khui ah mikhaptok ah vai ka pongpa vetih nang kan thup ve. Na cangen khaw na pum dong lamloh pit laeh. Na taengah mebang ka saii ham khaw ka ming ngawn,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Te dongah Israel ca rhoek loh a cangen te Horeb tlang ah a dul uh. ");
INSERT INTO hlt_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moses loh dap te a puen tih rhaehhmuen lamkah a lakhla la rhaehhmuen vongvoel ah amah la a tuk. Te te tingtunnah dap la a khue tih BOEIPA aka dawt boeih loh rhaehhmuen vongvoel kah tingtunnah dap te a paan. ");
INSERT INTO hlt_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Moses te dap la a caeh vaengah pilnam pum khaw thoo uh tih hlang he amah kah dap thohka ah pai uh. Te vaengah dap khuila a kun hil Moses hnuk te a paelki uh. ");
INSERT INTO hlt_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Dap khuila Moses a kun van neh cingmai tung ha suntla. Te vaengah dap thohka ah pai tih Moses te a voek. ");
INSERT INTO hlt_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Dap thohka kah aka pai cingmai tung te pilnam loh boeih a hmuh. Te dongah pilnam te boeih thoo tih hlang he amah kah dap thohka ah ni a bakop uh coeng. ");
INSERT INTO hlt_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Te vaengah hlang loh a hui a voek bangla BOEIPA loh Moses te a hmai, hmai ah a voek. Te phoeiah rhaehhmuen la mael. Tedae anih kah tueihyoeih Nun capa cadong Joshua tah dap khui lamloh nong pawh. ");
INSERT INTO hlt_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Te phoeiah Moses loh BOEIPA te, “Namah loh kai taengah pilnam he khuen laeh,” na ti ne. Tedae kai taengah nan tueih ham te khaw kai nan ming sak moenih. Te vaengah namah loh, 'Na ming neh kan ming tih ka mik dongkah mikdaithen khaw na hmuh,’ na ti. ");
INSERT INTO hlt_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Na mikhmuh ah mikdaithen ka hmuh van coeng atah na longpuei te kai m'ming sak laeh. Namah kan ming daengah man na mikhmuh ah mikdaithen khaw ka hmuh ve. Namtom he na pilnam la hmuh mai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Tedae, “Ka mikhmuh kah he a caeh uh daengah ni nang te kan duem sak eh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Te phoeiah amah te, “Na mikhmuh kah te a caeh pawt atah he lamloh kaimih nan khuen pawt mako. ");
INSERT INTO hlt_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Kai neh na pilnam loh na mikhmuh ah mikdaithen ka hmuh te me nen nim a ming eh. Kaimih taengkah na pongpa nen pawt nim kai neh na pilnam tah diklai hman kah pilnam cungkuem lamloh ka hoep uh tangloeng he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Te dongah BOEIPA loh Moses te, “Ka mikhmuh ah mikdaithen na hmuh tih na ming neh kam ming dongah ol he na thui bangla ka saii bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Te vaengah, “Na thangpomnah te kai m'hmuh sak laem,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Te dongah BOEIPA loh, “Ka thennah boeih he na mikhmuh ah ka phoe vetih na mikhmuh ah Yahweh ming he ka doek ni. Ka rhen tueng ni ka rhen vetih ka haidam tueng ni ka haidam eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Tedae, “Ka maelhmai hmuh ham na coeng moenih, hlang loh kai m'hmu mai cakhaw a hing hae moenih,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Te phoeiah BOEIPA loh, “Kamah taengkah hmuen ah he lungpang soah khaw pai mai. ");
INSERT INTO hlt_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Tedae ka thangpomnah loh a pah phai vaengah lungpang rhaep ah nang kang khueh ni. Te vaengah ka khum hil nang soah ka kut kang khuk bitni. ");
INSERT INTO hlt_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ka kut ka khoe van neh ka nam na hmuh ni. Tedae ka maelhmai tah tueng mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","BOEIPA loh Moses taengah, “Namah loh lamhma kah bangla lungto cabael panit saek lamtah te cabael dongah lamhma kah aka rhek cabael dongah aka om ol te ka daek eh. ");
INSERT INTO hlt_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Mincang ah sikim la om lamtah mincang neh Sinai tlang la ha luei. Te phoeiah tlang lu ah kamah taengla pahoi pai. ");
INSERT INTO hlt_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tedae na taengah hlang ha luei boel saeh lamtah hlang pakhat pataeng tlang tom ah phoe boel saeh. Boiva neh saelhung khaw tlang dan ah he luem uh boel saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Te dongah lungto cabael rhoi te lamhma kah bangla a saek. Mincang ah Moses te thoo tih BOEIPA loh amah a uen bangla Sinai tlang ah yoeng. Te vaengah lungto cabael rhoi te a kut dongah a pom. ");
INSERT INTO hlt_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Te phoeiah BOEIPA te cingmai neh ha rhum tih a taengah pahoi pai. Te vaengah BOEIPA ming neh a doek. ");
INSERT INTO hlt_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","BOEIPA te a hmai ah a pah pah vaengah tah, “Yahweh, Yahweh, thinphoei neh lungvatnah Pathen, thintoek a ueh tih sitlohnah neh oltak dongah boeiping coeng. ");
INSERT INTO hlt_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Sitlohnah he thawngkhat ham khaw a kueinah dongathaesainah, boekoeknah neh dumlai khaw a phueih pah. Tedae pa rhoek kathaesainah a cawh pah te ca rhoek so neh ca kah ca rhoek soah khongthum khongli hil a hmil rhoe a hmil moenih,” tila tamhoe. ");
INSERT INTO hlt_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Te vaengah Moses tah diklai la koe buluk tih bakop. ");
INSERT INTO hlt_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Tedae Moses loh, “Ka Boeipa aw na mik dongah mikdaithen la ka tueng mai khaming. Ka Boeipa kaimih khui ah pongpa laeh. Pilnam he a rhawn mangkhak sitoe cakhaw kaimih kathaesainah neh kaimih kah tholhnah te khodawkngai lamtah kaimih he m'pang mai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Boeipa loh, “Kai loh na pilnam pum hmai ah paipi ka saii ne. Diklai pum neh namtom boeih taengah a suen pawh khobaerhambae te ka saii ni. Te vaengah a khui kah na pilnam boeih loh BOEIPA kah khoboe te hmuh saeh. Nang taengah ka saii te rhih pai saeh. ");
INSERT INTO hlt_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tihnin ah nang kang uen te namah ham ngaithuen. Na mikhmuh lamloh, Amori neh Kanaan khaw, Khitti neh Perizzi khaw, Khivee neh Jebusi ka haek ne. ");
INSERT INTO hlt_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Namah khaw ngaithuen, khohmuen khosa rhoek neh paipi na saii ve ne. Namah khaw a khuila na kun vetih namah khui ah hlaeh la poeh ve. ");
INSERT INTO hlt_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","A hmueihtuk te palet pah lamtah a kaam te phaek pah. Anih kah Asherah khaw vung pah. ");
INSERT INTO hlt_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","A ming mah thatlai Yahweh coeng tih Pathen tah a thatlai thai dongah pathen tloe taengah bakop boeh. ");
INSERT INTO hlt_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","A pathen taengkah a cukhalh neh a pathen te a nawn uh dongah a hmueih te caak ham nang n'khue akhaw khohmuen kah khosa taengah moi na bop ve. ");
INSERT INTO hlt_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","A canu te na capa ham na lo cakhaw a canu khaw a pathen hnukah cukhalh uh. Te dongah na ca rhoek te amih kah pathen taengah cukhalh hae ni. ");
INSERT INTO hlt_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Mueihlawn pathen khaw namah ham saii boeh. ");
INSERT INTO hlt_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Nang kang uen bangla vaidamding khotue te hnin rhih yaeh lamtah vaidamding mah ca. Egypt lamloh Abib hla dongah na thoh dongah Abib hla ah tingtunnah om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Bung lamkah cacuek boeih, na boiva dongkah vaito neh tu cacuek a tal boeih he kamah kah ni. ");
INSERT INTO hlt_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Tedae laak cacuek tah tu neh lat. Na lat pawt bal atah pahoi at laeh. Na capa caming boeih tah lat lamtah ka mikhmuh ah kuttling la phoe boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Hnin rhuk khuiah thotat lamtah hnin rhih dongah tah lophoh vaengah khaw duem lamtah cangah vaengah khaw nduem. ");
INSERT INTO hlt_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Cang dongkah cangah vaengkah thaihcuek khotue yalh neh kum thoknah cangyom khotue te namah ham saii. ");
INSERT INTO hlt_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Namah khuikah tongpaca boeih tah kum khat ah voei thum Israel Pathen, Boeipa Yahovah mikhmuh ah phoe saeh. ");
INSERT INTO hlt_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Namtom te na mikhmuh lamloh ka haek vetih na khorhi khaw kang aeh ni. BOEIPA na Pathen mikhmuh la kum khat ah voei thum phoe ham na caeh daengah ni na khohmuen te hlang loh ham veet pawt eh. ");
INSERT INTO hlt_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Kai kah hmueih thii te tolrhu neh ngawn boeh. Yoom khotue kah hmueih loh mincang duela rhaeh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Na khohmuen kah tanglue thaihcuek te BOEIPA na Pathen im la khuen. Maae ca te a manu suktui neh thong boeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Te phoeiah BOEIPA loh Moses te, “He ol he namah ham daek laeh. Kamah ka dongkah ol nen he nang taeng neh Israel taengah paipi ka saii,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","BOEIPA neh a om vaengah khothaih hni sawmli, khoyin hnin sawmli buh khaw ca pawh, tui khaw o pawh. Te vaengah paipi ol te cabael rhoi dongah ol lung rha la a daek. ");
INSERT INTO hlt_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Moses te Sinai tlang lamloh a suntlak vaengah Moses kut dongah olphong cabael rhoi khaw om. Tlang lamloh a suntlak neh amah te a voek pueng dongah a maelhmai vin a phii te khaw Moses loh ming pawh. ");
INSERT INTO hlt_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaron neh Israel ca boeih loh Moses te a hmuh uh vaengah a maelhmai vin tarha a phii coeng dongah a taengla mop ham a rhih uh. ");
INSERT INTO hlt_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Tedae Moses loh amih te a khue dongah Aaron neh rhaengpuei kah khoboei boeih tah anih taengla mael uh tih Moses loh amih te a voek. ");
INSERT INTO hlt_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Te phoeiah Israel ca rhoek boeih te mop uh. Te vaengah Sinai tlang ah BOEIPA anih taengkah a thui boeih te amih a uen. ");
INSERT INTO hlt_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Moses loh amih taengah a thui te a khah van neh a maelhmai te a lumuekhni neh a dah. ");
INSERT INTO hlt_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Tedae BOEIPA amah te voek ham a mikhmuh la kun tih amah ha pawk daengah lumuekhni a lim pueng. Ha pawk phoeiah tah amah a uen te Israel ca rhoek ham a thui pah. ");
INSERT INTO hlt_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Israel ca rhoek loh Moses maelhmai te a hmuh vaengah Moses kah maelhmai vin a phii pah. Tedae Boeipa amah te voek ham a kun hil Moses loh lumuekhni neh a maelhmai te a dah. ");
INSERT INTO hlt_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Te phoeiah Moses loh Israel ca rhaengpuei te boeih a tingtun tih amih ham ol he a thui pah. Te te amih saii sak ham ni BOEIPA loh a uen. ");
INSERT INTO hlt_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","“Hnin rhuk khuiah bitat saii saeh lamtah hnin rhih dongah tah nang ham Sabbath cim neh BOEIPA ham koiyaeh la om saeh. Te vaengah bitat aka saii boeih tah duek saeh. ");
INSERT INTO hlt_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Sabbath hnin ah tah na tolrhum tom ah hmai toih uh boeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moses loh Israel ca rhaengpuei boeih te, “He ol he thui hamla BOEIPA loh n'uen coeng. ");
INSERT INTO hlt_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Nangmih taeng lamloh BOEIPA ham khosaa khuen uh. A lungbuei aka hlangcong boeih loh BOEIPA kah khosaa te sui neh cak neh rhohum khaw, ");
INSERT INTO hlt_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","a thim neh daidi neh hlampai a lingdik neh hnitang neh maae, ");
INSERT INTO hlt_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","tutal pho a thimyum neh saham pho khaw, rhining thing khaw, ");
INSERT INTO hlt_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","hmaivang ham situi neh koelhnah situi botui khaw, botui bo-ul ham khaw, ");
INSERT INTO hlt_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Hnisui neh rhangpho dongkah ham oitha lung neh saboi lung khaw khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Nangmih ah lungbuei aka cueih boeih khaw ha pawk uh saeh lamtah BOEIPA kah a uen boeih te, ");
INSERT INTO hlt_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","A dap kah dungtlungim neh a imphu te khaw, a rhuithu neh a longlaeng khaw, a thohkalh, a tung neh a buenhol, ");
INSERT INTO hlt_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","thingkawng neh a thingpang, thingkawng tlaeng neh himbaiyan dongkah hniyan, ");
INSERT INTO hlt_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","caboei neh a longlaeng khaw, a hnopai boeih neh a mikhmuh kah buh khaw, ");
INSERT INTO hlt_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","hmaivang ham hmaitung neh a hnopai, a hmaithoi neh hmaivang situi khaw, ");
INSERT INTO hlt_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","bo-ul hmueihtuk neh a thingpang, koelhnah situi neh botui bo-ul, dungtlungim thohka kah thohka himbaiyan, ");
INSERT INTO hlt_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","hmueihhlutnah hmueihtuk neh rhohum pahak ham khaw, a thingpang neh a hnopai boeih, baeldung neh a kho khaw, ");
INSERT INTO hlt_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","vongtung imbang khaw, a tung neh a buenhol khaw, vongtung vongka kah himbaiyai, ");
INSERT INTO hlt_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","dungtlungim hlingcong neh vongtung hlingcong, a liva khaw, ");
INSERT INTO hlt_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","hmuencim kah aka thotat ham hnithun himbai, khosoih Aaron ham hmuencim himbai neh aka khosoih ham koi anih koca rhoek kah himbai khaw saii uh saeh,’ a ti,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Te phoeiah Israel ca rhaengpuei boeih te Moses mikhmuh lamloh khoe uh. ");
INSERT INTO hlt_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Te vaengah a lungbuei aka tueng hlang boeih neh a mueihla aka puhlu boeih loh tingtunnah dap kah bitat ham neh a thothuengnah cungkuem ham khaw hmuencim himbai ham khaw BOEIPA kah khosaa te a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Lungbuei ah aka hlangcong boeih tah a yuu a va la kun uh tih tlaeloh neh hnaii khaw, kutcaeng neh oilung khaw, sui hnopai boeih a khuen uh tih hlang boeih loh BOEIPA taengah sui thueng hmueih la a thueng uh. ");
INSERT INTO hlt_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Hlang boeih loh te te a hmuh vaengah a thim neh daidi khaw, hlampai a lingdik neh hnitang khaw, maea neh tutal pho a thimyum khaw saham pho khaw a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Khosaa aka ludoeng boeih loh cak neh rhohum te BOEIPA kah khosaa la a khuen uh. Te te aka hmu boeih loh rhining thing te thothuengnah bitat cungkuem ham a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Lungbuei aka cueih nu boeih loh a kut neh a hnuh uh tih hnitah te a thim neh daidi, hlampai a lingdik neh hnitang la a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Amih a lungbuei a cahoeh pah nu boeih loh cueihnah neh a hnuh maae mul khaw a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Khoboei rhoek loh oitha lungto neh hnisui rhangpho ham saboi lungto a khuen uh bal. ");
INSERT INTO hlt_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Botui neh hmaivang ham situi khaw, koelhnah situi ham neh botui bo-ul khaw, ");
INSERT INTO hlt_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Huta tongpa a lungbuei aka puhlu boeih, te rhoek te BOEIPA kah a uen bangla bitat cungkuem ham a khuen uh. Moses kut neh saii ham Israel ca rhoek loh BOEIPA taengah kothoh a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Te phoeiah Moses loh Israel ca rhoek te, “So lah BOEIPA loh Judah koca lamkah Hur capa Uri kah a ca, a ming ah Bezalel te a khue coeng. ");
INSERT INTO hlt_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Anih te Pathen kah mueihla neh, cueihnah neh, lungcuei neh, mingnah neh, bitat cungkuem neh cung. ");
INSERT INTO hlt_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Te phoeiah sui neh ngun dongah khaw, rhohum dongah khaw kopoek neh a moeh tih a saii. ");
INSERT INTO hlt_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Lungto kutthaibibi nen khaw a cung sak tih thing kutthaibibi dongah khaw kopoek kah bitat boeih neh a saii ham, ");
INSERT INTO hlt_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","amah a lungbuei kah te thuinuet ham Dan koca lamkah Ahisamak capa Oholiab te a paek. ");
INSERT INTO hlt_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Amih te kutthai kah bitat cungkuem khaw moehnah neh saii ham lungbuei kah cueihnah a cung sak. Te dongah a thim neh, daidi neh hlampai a lingdik neh hnitang dongah a en. Te phoeiah hni aka tak long khaw kopoek kah bitat moehnah cungkuem neh a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Te dongah Bezalel, Oholiab neh lungbuei aka cueih hlang boeih loh saii saeh. Amih taengah BOEIPA kah a uen boeih tah hmuencim kah thothuengnah bitat cungkuem te ming sak ham neh saii sak ham BOEIPA loh cueihnah neh lungcuei la a khueh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Te phoeiah Moses loh Bazelel, Oholiab neh lungbuei aka cueih hlang boeih te a khue. Te rhoek te BOEIPA loh a lungbuei ah cueihnah paek tih amih boeih tah bitat la caeh ham neh saii ham khaw a lungbuei a cahoeh. ");
INSERT INTO hlt_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Te phoeiah hmuencim thothuengnah bitat la saii ham Israel ca rhoek loh a khuen khosaa cungkuem te Moses mikhmuh lamloh a doe uh. Amih loh te te mincang, mincang ah moeihoeihnah a khuen uh pueng. ");
INSERT INTO hlt_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Te phoeiah hmuencim kah bitat boeih aka saii hlang cueih boeih neh hlang boeih khaw amah kah bitat a saii lamloh ha pawk uh. ");
INSERT INTO hlt_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Te phoeiah Moses te a voek uh tih, “Te bitat te saii ham BOEIPA loh a uen coeng dongah thothuengnah kah a ngoe lakah pilnam loh a khuen he yet,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Te phoeiah Moses loh a uen bangla rhaehhmuen ah ol a thak uh tih, “Huta khaw tongpa khaw hmuencim kah khosaa ham bitat saii voel boel saeh,” a ti uh. Te dongah pilnam loh hno a khuen te paa uh. ");
INSERT INTO hlt_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Bitat ham a rhoeh la a om phoeiah bitat cungkuem dongah te te hnonah ham khaw coih coeng. ");
INSERT INTO hlt_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Bitat aka saii khuiah lungbuei aka cueih boeih loh dungtlungim te a saii uh. Himbaiyan yungrha te hnitang la a tah tih a thim, daidi neh hlampai a lingdik la a en. Cherubim dongkah bibi khaw moehnah neh a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Himbaiyan pakhat kah a yun he dong kul dong rhet, a daang dong li lo tih himbaiyan boeih ham te himbaiyan pakhat neh cungnueh pakhat la cet. ");
INSERT INTO hlt_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Himbaiyan yung nga te pakhat neh pakhat a cong tih himbaiyan yung nga te khaw khat neh khat cong uh. ");
INSERT INTO hlt_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Himbaiyan pakhat kah a hmoi phai ah rhuikawl a thim te rhui at a bawt hil a buen pah. Te tlam te a tloe himbaiyan hmoi kah rhui at a bawt hil a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Himbaiyan yung khat dongah rhuikawl sawmnga a saii tih himbaiyan a pabae khaw rhui at la a hmoi ah rhuikawl sawmnga a saii. Te dongah khat neh khat rhuikawl neh a doe sak. ");
INSERT INTO hlt_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Te phoeiah sui rhuithu sawmnga a saii tih rhuithu lamloh himbaiyan khat neh khat te a hlinghlui dongah dungtlungim khaw pakhat la om. ");
INSERT INTO hlt_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Dungtlungim kah dap ham himbaiyan te maae mul neh a saii tih himbaiyan yung hlai khat a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Himbaiyan yungat te a yun dong sawmthum, a daang dong li lo tih himbaiyan hlai khat ham te himbaiyan pakhat cungnueh dongah pakhat la cet. ");
INSERT INTO hlt_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Himbaiyan yung nga te hloep a cong tih himbaiyan yung rhuk te pakhat la a cong. ");
INSERT INTO hlt_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Himbaiyan pakhat kah a hmoi ah a bawt due rhuikawl sawmnga te rhui at la a saii tih a pabae himbaiyan kah a hmoi ah rhuikawl sawmnga ham buenyang a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Te dongah rhohum rhuithu sawmnga a saii dap te a hlinghlui tih pakhat la a om sak. ");
INSERT INTO hlt_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Dap imphu te tutal pho a thimyum neh a sokah imphu la saham pho neh a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Te phoeiah dungtlungim ham a longlaeng te rhining thing aka pai te a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","A longlaeng pakhat te a yun dong rha neh a daang dong khat phoeiah dong kaek lo tih a longlaeng te rhip vai uh. ");
INSERT INTO hlt_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","A longlaeng pakhat dongah dangkam rhoi khaw khat neh khat kiba uh. Te tlam te dungtlungim kah a longlaeng te boeih a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Dungtlungim kah a longlaeng te tuithim ah tuithim saa kah a longlaeng te yung kul a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","A longlaeng pakhat dangah dangkam rhoi ham buenhol panit neh a longlaeng yung kul ham cakben buenhol sawmli a saii. Te dongah a longlaeng pakhat dangah buenhol panit neh dangkam panit om. ");
INSERT INTO hlt_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Dungtlungim khat ben tlangpuei saa ah a longlaeng pakul a khueh. ");
INSERT INTO hlt_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","A longlaeng pakhat dangah buenhol panit, a longlaeng pakhat dangkah buenhol panit neh cakben buenhol sawmli te a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Dungtlungim kah imthael khotlak sa ham tah a longlaeng yung rhuk a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Imthael ah dungtlungim kah a ngong ham khaw a longlaeng panit a khueh. ");
INSERT INTO hlt_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Te te a hmui lamloh tungbok la om vetih a soi ah tah kutcaeng pakhat khuiah pakhat la rhenten ben uh. Te rhoi dongkah bangla imki rhoi kah ham khaw a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Te dongah a longlaeng parhet vaengah a longlaeng pakhat hmuikah buenhol panit, panit neh buenhol he cakben buenhol hlai rhuk om. ");
INSERT INTO hlt_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Dungtlungim impalai kah a longlaeng pakhat ham thohkalh panga te rhining thing a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Dungtlungim khat ben impalai kah a longlaeng dongah khaw thohkalh panga tih dungtlungim khotlak imthael kah a longlaeng dongkah ham thohkalh panga om. ");
INSERT INTO hlt_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Tedae a bangli kah thohkalh a saii long tah a longlaeng te a hmoi lamloh a bawt hil a bangli ah yong phai. ");
INSERT INTO hlt_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","A longlaeng te khaw sui a ben thil tih thohkalh rholhnah ham a kutcaeng te sui ni a saii. Thohkalh te khaw sui a ben thil. ");
INSERT INTO hlt_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Te phoeiah hniyan te a thim, daidi, hlampai a lingdik neh a saii. Bibi moehnah neh hnitang la a tah tih cherubim khaw a saii. ");
INSERT INTO hlt_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Te ham te rhining tung pali a saii tih sui a ben thil. A voei te sui tih te dongkah buenhol pali ham te cak a hlawn. ");
INSERT INTO hlt_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Dap thohka kah himbaiyan te a saii vaengah a thim, daidi, hlampai a lingdik neh hnitang la a tah tih kutnaep la a en. ");
INSERT INTO hlt_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","A tung panga neh a voei rhoek te khaw a soi ah a ben pah tih a yaeltlang te sui, a buenhol panga te rhohum a saii. ");
INSERT INTO hlt_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel loh rhining thing te thingkawng a yun dong nit ngancawn, a daang dong khat neh tintan, a sang dong khat neh tintan la a saii. ");
INSERT INTO hlt_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Te phoeiah a khui a hman ah sui cilh a ben thil tih a kaep, a kong khaw, sui neh a saii. ");
INSERT INTO hlt_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","A kho pali dongah sui kutcaeng pali a hlawn. A vae khat ben ah kutcaeng panit, a vae khat ben ah kutcaeng panit om. ");
INSERT INTO hlt_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Rhining thing thingpang la a suih tih sui a ben thil. ");
INSERT INTO hlt_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Thingpang te thingkawng aka kawt ham thingkawng vae kah kutcaeng dongah a rholh. ");
INSERT INTO hlt_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","A tlaeng te sui cilh neh a yun dong nit tintan neh a daang dong at tintan la a saii. ");
INSERT INTO hlt_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Sui cakben cherubim panit te a saii tih te rhoi te a tlaeng kah a hmoi rhoi ah a ben. ");
INSERT INTO hlt_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Thingkawng tlaeng lamloh khat ben a hmoi ah cherubim pakhat neh khat ben a hmoi ah cherubim pakhat tih cherubim te a hmoi ah a hmuicue panit a saii. ");
INSERT INTO hlt_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Cherubim aka om rhoi loh a phae a phuel hang rhoi tih a phae neh thingkawng tlaeng te a khu rhoi. A maelhmai rhoi khaw pakhat loh a manuca taengla mael. Te dongah cherubim kah maelhmai te thingkawng tlaeng soah hum uh. ");
INSERT INTO hlt_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Te phoeiah rhining thing te caboei a yun dong nit neh a daang dong khat, a sang dong khat tintan la a saii. ");
INSERT INTO hlt_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Te te sui cilh a ben thil tih a kaep kah a khopnah khaw sui ni a saii. ");
INSERT INTO hlt_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Te ham te a kae a kaep ah kutsom pakhat a khueh tih a kae soah a khopnah te sui neh pin a saii. ");
INSERT INTO hlt_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Te ham te sui kutcaeng pali a hlawn tih kutcaeng te a kho pali kah a kil pali ah a buen. ");
INSERT INTO hlt_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","A kae kah voeivang ah caboei aka kawt ham thingpang rholhnah kutcaeng om. ");
INSERT INTO hlt_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Caboei aka kawt ham thingpang te rhining thing a suih tih sui a ben thil. ");
INSERT INTO hlt_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Te phoeiah caboei dongkah hnopai la a bael neh a yakbu khaw, tuisi a doeng vaengah kah a tuisi-am neh tui-um khaw sui cilh lamloh a saii. ");
INSERT INTO hlt_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Hmaitung la sui cilh cakben neh a saii tih hmaitung kah a kho neh a bunang kong khaw a saii. Te lamloh a paimuem neh a rhaiphuelh om. ");
INSERT INTO hlt_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","A vae khat ben lamloh hmaitung kah a kong pathum, a vae khat hmaitung kah a kong pathum neh a kaep lamloh a kong parhuk cawn. ");
INSERT INTO hlt_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","A kong pakhat dongah rhaimuem rhaiphuelh neh noepai bunang pathum, a kong pakhat dongah khaw rhaimuem rhaiphuelh neh noepai bunang pathum a saii. Hmaitung lamkah aka cawn a kong parhuk dongah te tlam te a saii. ");
INSERT INTO hlt_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Hmaitung dongah noepai bunang pali khaw rhaimuem rhaiphuelh neh a khueh. ");
INSERT INTO hlt_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","A kong panit hmuiah rhaimuem pakhat neh, a kong panit hmuiah rhaimuem pakhat tih a kong parhuk a cawn dongah a kong panit hmui ah rhaimuem pakhat om bal. ");
INSERT INTO hlt_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Te lamkah a rhaimuem neh a kong te sui cilh a boh neh pakhat la boeih om. ");
INSERT INTO hlt_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Hmaithoi parhih neh a paitaeh khaw a baelphaih khaw sui cilh ni a saii. ");
INSERT INTO hlt_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Te hmaithoi a hnopai boeih te sui cilh talent khat neh a saii. ");
INSERT INTO hlt_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Te phoeiah rhining thing te bo-ul hmueihtuk a yun dong khat, a daang dong khat neh hniboeng la om tih a sang dong nit a ki khaw om. ");
INSERT INTO hlt_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Te te sui cilh neh a imphu khaw, a pangbueng phai khaw, a ki khaw a ben thil tih a kaep kah a khopnah te sui a saii. ");
INSERT INTO hlt_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Te ham te a khopnah hmui ah sui kutcaeng panit a saii. Te te hmueihtuk aka kawt ham thingpang rholhnah la a vae rhoi ah a buen. ");
INSERT INTO hlt_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Rhining thing te thingpang la a suih tih sui a ben thil. ");
INSERT INTO hlt_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Hmuencim kah koelhnah situi neh aka thungnom kutci bangla botui bo-ul cil khaw a saii. ");
INSERT INTO hlt_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Rhining thing te hmueihhlutnah hmueihtuk, a yun dong nga neh a daang dong nga ah hniboeng la om tih a sang te dong thum la a saii. ");
INSERT INTO hlt_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","A kil pali ah a ki a saii pah tih a ki aka om rhoek te rhohum a ben thil. ");
INSERT INTO hlt_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Te phoeiah hmueihtuk dongkah hnopai cungkuem, am neh hmaisoh khaw, baelcak ciksum neh baelphaih khaw a saii. A hnopai boeih te rhohum ni a saii. ");
INSERT INTO hlt_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Hmueihtuk ham a loengboeng hmui lamloh a kong hmui hil rhohum vairhuek dongkah bibi bangla pahak a saii. ");
INSERT INTO hlt_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Thingpang rholhnah ham rhohum pahak kah a hmuicue pali ah kutcaeng pali a hlawn. ");
INSERT INTO hlt_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Rhining thing te thingpang la a suih tih rhohum a ben thil. ");
INSERT INTO hlt_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Te aka kawt ham te hmueihtuk vae kah kutcaeng khuiah thingpang a rholh tih hmueihtuk te thingphael aka khui rhoi neh a khop. ");
INSERT INTO hlt_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Aka thotat nu kah mangthuinah lamloh rhohum baeldung neh rhohum kho khaw a saii. Amih te tingtunnah dap thohka ah thotat uh. ");
INSERT INTO hlt_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Tuithim ben kah ah vongtung a saii tih, vongtung imbang te hnitang dong yakhat a tah thil. ");
INSERT INTO hlt_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","A tung pakul neh a buenhol pakul te rhohum tih tung dongkah voei neh a yaeltlang tah cak a saii. ");
INSERT INTO hlt_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Tlangpuei saa kah dong yakhat ham khaw tung pakul neh a buenhol pakul te rhohum tih, tung dongkah voei neh a yaeltlang tah cak a saii. ");
INSERT INTO hlt_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Khotlak ben kah imbang khaw dong sawmnga lo. A tung parha neh a buenhol parha lo. Tung dongkah voei neh a yaeltlang te cak a ben. ");
INSERT INTO hlt_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Khothoeng ben ah khaw dong sawmnga lo. ");
INSERT INTO hlt_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","A kaep kah imbang te dong hlai nga lo. A tung pathum neh a buenhol pathum om. ");
INSERT INTO hlt_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","A Vongup vongka hlaep kah imbang pabae te he ben ah khaw ke ben ah khaw dong hlai nga lo. A tung pathum neh a buenhol khaw pathum om. ");
INSERT INTO hlt_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Vongup kaepvai kah imbang boeih te hnitang a tah thil. ");
INSERT INTO hlt_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Te vaengah tung dongkah buenhol tah rhohum tih tung dongkah voei neh a yaeltlang tah cak neh a saii. Te dongah vongup kah tung boeih te a soi kah cak ben phoeiah cak neh a cen uh. ");
INSERT INTO hlt_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Vongup vongka kah himbaiyan khaw kutci neh a thim, daidi, hlampai a lingdik la a en tih hnitang la a tah. Te vaengah vongup kah imbang voeivang kah bangla a yun dong kul neh a daang a sang tah dong nga lo. ");
INSERT INTO hlt_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","A tung pali neh a buenhol pali tah rhohum a saii. A voei tah cak tih a soi neh a yaeltlang khaw cak ben la om. ");
INSERT INTO hlt_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Dungtlungim ham neh a kaepvai vongtung ham khaw rhohum hlingcong boeih a saii. ");
INSERT INTO hlt_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","He dungtlungim la a hlum he khosoih Aaron koca Ithamar kut dongkah Levi thohtatnah, Moses ol bangla olphong kah dungtlungim la a soep. ");
INSERT INTO hlt_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Te vaengah BOEIPA loh Moses a uen vabangla Judah koca lamkah Hur capa Uri kah a ca Bezalel loh a cungkuem te a saii. ");
INSERT INTO hlt_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Tedae a taengah moehnah neh a thim la, daidi la, hlampai a lingdik neh hnitang la aka en kutthai, Dan koca lamkah Ahisamak capa Oholiab khaw om. ");
INSERT INTO hlt_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Hmuencim bitat cungkuem dongah sui khaw bitat la boeih a saii. Te vaengah thueng hmueih dongkah sui mah hmuencim kah shekel ah talent pakul pako phoeiah shekel ya rhih sawmthum om coeng. ");
INSERT INTO hlt_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Rhaengpuei kah a soep cak he khaw talent yakhat neh hmuencim kah shekel ah shekel thawngkhat ya rhih sawmrhih panga lo. ");
INSERT INTO hlt_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Hlangmi pakhat dongah beka pakhat, hmuencim shekel ah shekel rhakthuem a paek. Soep hamla aka kat boeih te kum kul ca lamloh a so hang te thawng ya rhuk thawng thum neh ya nga sawmnga lo. ");
INSERT INTO hlt_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Te vaengah hmuencim buenhol neh hniyan buenhol la a hlawn ham cak te talent yakhat lo coeng. Buenhol pakhat dongah talent khat van tih talent yakhat lamloh buenhol yakhat rhoeh. ");
INSERT INTO hlt_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Te dongah thawngkhat ya rhih neh sawmrhih panga te tung dongkah voei la a saii. Te phoeiah a soi ah a ben tih a cen. ");
INSERT INTO hlt_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Te phoeiah thueng hmueih rhohum talent sawmrhih neh shekel thawng nit ya li lo. ");
INSERT INTO hlt_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Te nen te tingtunnah dap thohka kah buenhol neh rhohum dapim hmueihtuk khaw, rhohum pahak khaw hmueihtuk kah hnopai cungkuem khaw, ");
INSERT INTO hlt_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","vongtung phai kah buenhol khaw, vongtung vongka kah buenhol khaw, dungtlungim kah hlingcong boeih neh, vongtung phai kah hlingcong boeih a saii. ");
INSERT INTO hlt_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Hmuencim ah aka thotat kah hnithun himbai khaw a thim, daidi, hlampai a lingdik neh a saii. Te phoeiah BOEIPA loh Moses a uen vanbangla Aaron ham khaw hmuencim himbai a hui uh. ");
INSERT INTO hlt_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Te phoeiah sui hnisui te a thim, daidi, hlampai a lingdik la a en tih hnitang la a tah. ");
INSERT INTO hlt_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Sui phaldaep te a daep tih hamrhui khaw a thim la, daidi la, hlampai a lingdik la, bibi moehnah neh hnitang la saii ham a ah. ");
INSERT INTO hlt_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Holhnam te a hmuicue rhoi ah hlinghlui ham a saii uh tih a hmoi te a hlinghlui. ");
INSERT INTO hlt_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","A pholip dongkah cihin khaw a bibi bangla a soah sui, a thim, daidi, hlampai a lingdik neh BOEIPA loh Moses a uen vanbangla hnitang la a tah. ");
INSERT INTO hlt_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Sui oibom dongkah a det oitha lungto te a saii tih kutbuen thingthuk te Israel ca rhoek kah ming la a thuk. ");
INSERT INTO hlt_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Te te BOEIPA loh Moses a uen vanbangla Israel ca rhoek ham poekkoepnah lungto la hnisui kah holhnam dongah a bang. ");
INSERT INTO hlt_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Rhangpho te khaw sui hnisui dongkah kutngo bangla bibi moehnah neh a thim, daidi, hlampai a lingdik a en tih hnitang la a tah. ");
INSERT INTO hlt_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Rhangpho a saii te hniboeng la om tih a yaep, a yun khap at neh a daang khap at la a yaep. ");
INSERT INTO hlt_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","A soah lungto a than, than li a hulh tih a than cuek te lungling, vaya neh tamkuei, ");
INSERT INTO hlt_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","A than bae dongah ah khocillung, minhum neh lungmik, ");
INSERT INTO hlt_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","a than thum dongah tamsenlung, khopang lung neh kemden, ");
INSERT INTO hlt_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","A than li dongah timsuih, oitha, maihae te a hulhnah neh sui oibom dongah a bom. ");
INSERT INTO hlt_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Lungto te khaw Israel ca hlai nit ming neh a khueh. Lungto ming tarhing ah koca hlai nit ham khaw a ming te kutbuen thingthuk la rhip a khueh pah. ");
INSERT INTO hlt_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Rhangpho dongkah cuehnah cangtui-rhaica khaw sui cilh rhuivaeh dongkah kutngo la a saii. ");
INSERT INTO hlt_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Sui oibom panit neh sui kutcaeng panit a saii tih kutcaeng rhoi te rhangpho kah a hmoi rhoi ah a bang. ");
INSERT INTO hlt_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Sui rhuivaeh rhoi te rhangpho hmoi kah kutcaeng rhoi dongah a khih uh. ");
INSERT INTO hlt_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Rhuivaeh rhoi kah a hmoi rhoi te oibom rhoi dongla a hlinghlui. Te rhoek te a hmai kah hnisui holhnam dongla a khih uh. ");
INSERT INTO hlt_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Te phoeiah sui kutcaeng panit te a saii uh tih hnisui a khui, a hmai a hmoi dongah rhangpho hmoi rhoi dongah a khih uh. ");
INSERT INTO hlt_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Sui kutcaeng rhoi a saii uh tih te rhoi te hnisui cihin sokah a rhui voeivang taeng, a hmai ah a dang kah hnisui holhnam rhoi dongla a hlin. ");
INSERT INTO hlt_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Rhangpho dongkah a kutcaeng rhoi neh te hnisui dongkah kutcaeng rhoi te hamrhui a thim neh a pin. BOEIPA loh Moses a uen bangla hnisui kah cihin soah a om daengah ni rhangpho hnisui dong lamloh a hawl pawt eh. ");
INSERT INTO hlt_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Te phoeiah hnikul te hnisui dongkah kutngo bangla a saii tih a thim la boeih a tah. ");
INSERT INTO hlt_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Hnikul kah a rhai te a laklung ah rhawnmoep kah a rhai bangla om tih a rhai ham a kongnah khaw pin a om dongah pawn mahpawh. ");
INSERT INTO hlt_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Hnikul dongkah hnihmoi ah tale thaih a saii tih a thim, daidi, hlampai a lingdik neh a tah. ");
INSERT INTO hlt_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Sui cilh te hling la a saii tih hling te hnikul hnihmoi kah tale laklo, tale laklo ah pin a bang. ");
INSERT INTO hlt_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","BOEIPA loh Moses a uen vanbangla aka thotat ham kah hnikul hmoi ah te hling neh tale thaih, hling neh tale thaih tila pin a bang. ");
INSERT INTO hlt_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Te phoeiah Aaron ham neh anih koca rhoek ham hnitang kutngo a tah angkidung te a hui uh. ");
INSERT INTO hlt_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Hnitang lupong neh lukhuem khaw, hnitang samkhuem neh takhlawk hnii khaw hnitang la a tah. ");
INSERT INTO hlt_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Lamko te khaw hnitang la a tah tih BOEIPA loh Moses a uen vanbangla a kutngo te a thim, daidi, hlampai a lingdik neh a en. ");
INSERT INTO hlt_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Rhuisam tamlaep cim te khaw sui cilh neh a saii tih a soah kutbuen dongkah thingthuk cadaek te BOEIPA ham Cim tila a daek. ");
INSERT INTO hlt_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Te phoeiah BOEIPA loh Moses a uen bangla te te a so ah lupong dongah khih ham hamrhui a thim neh a hlinghlui. ");
INSERT INTO hlt_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Tingtunnah dap ah dungtlungim kah thothuengnah boeih a coeng tangloeng coeng. Israel ca rhoek loh a saii uh vaengah a cungkuem dongah BOEIPA loh Moses a uen te ni a saii uh van. ");
INSERT INTO hlt_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Te phoeiah dungtlungim te Moses taengah dap neh a hnopai boeih, a rhuithu neh a longlaeng a thohkalh khaw, a thohkalh neh a tung a buenhol khaw. ");
INSERT INTO hlt_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Imphu, tutal pho a thimyum neh imphu, saham pho te khaw himbaiyan hniyan khaw, ");
INSERT INTO hlt_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Olphong thingkawng neh a thingpang khaw a tlaeng khaw, ");
INSERT INTO hlt_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Caboei neh a hnopai boeih neh a hmai kah buh, ");
INSERT INTO hlt_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","A hmaithoi cim kah hmaitung neh hmaithoi bong khaw, a hnopai cungkuem neh hmaivang situi khaw, ");
INSERT INTO hlt_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Sui hmueihtuk neh koelhnah situi khaw, botui bo-ul neh dap thohka kah himbaiyan khaw, ");
INSERT INTO hlt_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","rhohum hmueihtuk neh rhohum pahak khaw, a thingpang neh a hnopai boeih, baeldung neh a kho khaw, ");
INSERT INTO hlt_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","vongtung imbang kah a tung neh a buenhol khaw, vongup vongka dongkah himbaiyan khaw, a liva neh te a hlingcong khaw, dungtlungim kah thothuengnah hnopai cungkuem neh tingtunnah dap ham khaw, ");
INSERT INTO hlt_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Hmuencim ah aka thotat ham hnithun himbai te khaw, khosoih Aaron kah hmuencim himbai neh aka khosoih ham koi anih koca rhoek kah himbai te khaw a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","BOEIPA loh Moses taengah boeih a uen vanbangla Israel ca rhoek loh thothuengnah cungkuem te a saii uh. ");
INSERT INTO hlt_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moses loh bitat cungkuem te a hmuh vaengah BOEIPA kah a uen bangla buelh a saii uh. A saii tangloeng dongah amih te Moses loh a uem. ");
INSERT INTO hlt_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Hla lamhmacuek kah hlasae lamhmacuek khohnin ah tingtunnah dap kah dungtlungim te thoh. ");
INSERT INTO hlt_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Te vaengah olphong thingkawng te pahoi khueh lamtah thingkawng soah hniyan neh khuk thil. ");
INSERT INTO hlt_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Caboei te khaw khuen lamtah a phu te tael pah. Hmaitung te khuen bal lamtah a hmaithoi te tok pah. ");
INSERT INTO hlt_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Olphong thingkawng hmai ah bo-ul ham sui hmueihtuk te hol lamtah dungtlungim ham thohka kah himbaiyan te yan pah. ");
INSERT INTO hlt_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Te phoeiah hmueihhlutnah hmueihtuk te tingtunnah dap kah dungtlungim thohka hmai ah hol. ");
INSERT INTO hlt_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Baeldung te tingtunnah dap laklo neh hmueihtuk laklo ah hol lamtah tui pahoi loei pah. ");
INSERT INTO hlt_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Vongtung te pin thoh lamtah vongtung vongka kah himbaiyan te yan pah vetih, akhui la kun nah thohka ah himbai te yan uh. ");
INSERT INTO hlt_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Koelhnah situi te lo lamtah dungtlungim neh a khuikah a cungkuem te koelh. Te neh a hnopai cungkuem te na ciim daengah ni a cim la a om eh. ");
INSERT INTO hlt_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Te phoeiah hmueihhlutnah hmueihtuk neh a hnopai boeih te koelh. Hmueihtuk te ciim lamtah hmueihtuk te a cim a cim koek la om saeh. ");
INSERT INTO hlt_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Baeldung neh a kho te khaw koelh lamtah ciim. ");
INSERT INTO hlt_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Te phoeiah Aaron neh anih koca rhoek te tingtunnah dap thohka la khuen lamtah amih te tui hluk. ");
INSERT INTO hlt_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Aaron te a cim himbai bai sak lamtah koelh. Anih te ciim lamtah kamah taengah khosoih saeh. ");
INSERT INTO hlt_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","A ca rhoek te khaw khuen lamtah amih te angkidung puei sak. ");
INSERT INTO hlt_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","A napa na koelh bangla amih te koelh lamtah kamah taengah khosoih saeh. Khosoihbi he a cadilcahma ham kumhal due amih koelhnah la om rhoe om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","BOEIPA loh anih saii sak ham a uen boeih te Moses loh a saii. ");
INSERT INTO hlt_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Te dongah a kum bae dongkah lamhma cuek hla a pha neh hlasae dongkah lamhma cuek hnin ah dungtlungim te a pai sak. ");
INSERT INTO hlt_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moses loh dungtlungim te a thoh vaengah a buenhol a buen tih a longlaeng te a paek. A thohkalh te a rholh tih a tung te khaw a ling. ");
INSERT INTO hlt_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Dungtlungim sokah dap te a dih tih BOEIPA loh Moses a uen bangla dap imphu te a so, so lamloh a khueh. ");
INSERT INTO hlt_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Te phoeiah olphong te a khuen tih thingkawng khuiah a khueh. Thingpang te thingkawng dongah a rholh phoeiah tah a tlaeng te thingkawng soah a so lamloh a tloeng. ");
INSERT INTO hlt_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Te phoeiah thingkawng te dungtlungim khuila a khuen tih himbaiyan dongkah hniyan te a yan thil. Te vaengah BOEIPA loh Moses a uen vanbangla olphong thingkawng te a khuk. ");
INSERT INTO hlt_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Caboei te tah tingtunnah dap khuikah dungtlungim kaep, tlangpuei hniyan kah kawtpoeng ah a khueh. ");
INSERT INTO hlt_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","A soah BOEIPA hmai kah buh te, BOEIPA loh Moses a uen bangla buelh a tawn. ");
INSERT INTO hlt_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Hmaitung te tah tingtunnah dap khuikah caboei dan, dungtlungim kaep kah tuithim ah a khueh. ");
INSERT INTO hlt_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Hmaithoi te BOEIPA loh Moses a uen vanbangla BOEIPA mikhmuh ah a tok. ");
INSERT INTO hlt_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Sui hmueihtuk te tingtunnah dap khuikah hniyan hmai ah a khueh. ");
INSERT INTO hlt_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","A soah BOEIPA loh Moses a uen vanbangla botui bo-ul khaw a phum. ");
INSERT INTO hlt_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Te phoeiah dungtlungim thohka kah himbaiyan te a bang. ");
INSERT INTO hlt_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Hmueihhlutnah hmueihtuk te tingtunnah dap kah dungtlungim thohka ah a khueh tih te soah te hmueihhlutnah neh khocang khaw BOEIPA loh Moses a uen vanbangla a nawn. ");
INSERT INTO hlt_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Baeldung te tingtunnah dap laklo neh hmueihtuk laklo ah a hol tih hluk ham tui khaw pahoi a khueh. ");
INSERT INTO hlt_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Te nen te Moses neh Aaron neh anih koca rhoek loh a kut a kho a silh uh. ");
INSERT INTO hlt_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Tingtunnah dap khuila a kun ham vaengah khaw, hmueihtuk la a caeh uh vaengah khaw BOEIPA loh Moses a uen vanbangla a silh uh. ");
INSERT INTO hlt_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Dungtlungim ham neh hmueihtuk ham vongtung pin a tung tih vongup vongka kah himbaiyan a yan daengah Moses loh bitat a coeng. ");
INSERT INTO hlt_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Te vaengah tingtunnah dap te cingmai loh a thing tih BOEIPA thangpomnah loh dungtlungim ah bae. ");
INSERT INTO hlt_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","A soah cingmai yaal tih BOEIPA kah thangpomnah loh dungtlungim ah a bae dongah Moses loh tingtunnah dap khuila kun ham coeng pah pawh. ");
INSERT INTO hlt_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","A longpueng khing ah dungtlungim dong lamloh cingmai a caeh van vaengah ni Israel ca rhoek khaw a caeh uh. ");
INSERT INTO hlt_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Tedae cingmai a caeh pawt atah a caeh hnin duela cet uh van pawh. ");
INSERT INTO hlt_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","A longpueng khing Israel imkhui pum kah mikhmuh ah tah khothaih ah dungtlungim sokah BOEIPA cingmai neh khoyin ah hmai a om pah. ");
INSERT INTO hlt_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","BOEIPA loh Moses te a khue tih tingtunnah dap lamkah a voek vaengah, ");
INSERT INTO hlt_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Israel ca rhoek te voek lamtah amih te thui pah., 'Nangmih khuikah hlang loh BOEIPA taengah nawnnah a khuen vaengah rhamsa, saelhung, boiva khui lamkah khaw namamih kah nawnnah la khuen. ");
INSERT INTO hlt_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Nawnnah ham hmueihhlutnah te saelhung mai koinih a tal aka cuem te tingtunnah dap thohka ah nawn saeh lamtah BOEIPA mikhmuh ah a kolonah ham nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Te vaengah hmueihhlutnah kah a lu soah a kut tloeng saeh lamtah anih ham a dawth te doe saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","BOEIPA mikhmuh ah saelhung ca te ngawn saeh lamtah khosoih Aaron ca rhoek loh a thii te khuen saeh. Te vaengah thii te tingtunnah dap thohka kah hmueihtuk so neh a kaepvai ah haeh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Hmueihhlutnah te hlaih saeh lamtah maehpoel la tloek saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Aaron koca khosoih rhoek loh hmueihtuk ah hmai toih uh saeh lamtah hmai soah thing hueng uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Maehpoel, a lu, neh a tha te hmueihtuk sokah thing toih hmai soah Aaron koca khosoih rhoek loh tloeng uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","A kotak neh a kho te tui neh sil saeh lamtah khosoih loh BOEIPA taengah hmuehmuei botui hmueihhlutnah hmaihlutnah la hmueihtuk ah boeih phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Tedae anih kah nawnnah te boiva khui lamkah koinih hmueihhlutnah ham tah tu khaw, maae tal aka cuem te khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Tekah te BOEIPA mikhmuh kah hmueihtuk kaep kah tlangpuei ben ah ngawn saeh lamtah Aaron koca khosoih rhoek loh a thii te hmueihtuk so neh a kaepvai ah haeh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","A pum te maehpoel la tloek saeh lamtah a lu neh a tha te khosoih loh hmueihtuk sokah thing toih hmai dongah tloeng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Tedae a kotak neh a kho rhoek te tui neh sil saeh. Te phoeiah khosoih loh khuen saeh lamtah BOEIPA taengah hmuehmuei botui hmueihhlutnah hmaihlutnah la hmueihtuk ah boeih phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","BOEIPA taengah anih kah nawnnah ham hmueihhlutnah te vaa khui lamkah koinih vahu mai khaw, vahui ca mai khaw amah kah nawnnah ham khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Te vaengah khosoih loh hmueihtuk la khuen saeh. A lu te a paimaelh pah phoeiah hmueihtuk ah phum saeh. A thii te hmueihtuk pangbueng dongah ci saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Tedae a tukpoe neh a dii te poelh saeh lamtah hmueihtuk khothoeng kah maehhloi hmuen ah voei saeh. ");
INSERT INTO hlt_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Vaa te a phae let pah saeh lamtah boe boel saeh. Te phoeiah khosoih loh BOEIPA taengah hmuehmuei botui hmueihhlutnah hmaihlutnah la hmueihtuk sokah thing toih hmai dongah phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Hlinglu loh BOEIPA taengla khocang a khuen vaengah vaidam te anih kah nawnnah la om saeh. Te vaengah vaidam te situi suep saeh lamtah hmueihtui te a soah phul saeh. ");
INSERT INTO hlt_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Te phoeiah Aaron koca khosoih rhoek taengla khuen saeh. Vaidam te kutvang ah mawk paco saeh lamtah situi hmueihtui boeih neh BOEIPA ham hmueihtuk kah hmaihlutnah soah khosoih loh kamhoeinah hmuehmuei botui la phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Khocang khui lamkah a coih te tah Aaron ham neh anih koca rhoek ham om tih BOEIPA kah hmaihlutnah khuiah aka cim khuikah aka cim koek la om. ");
INSERT INTO hlt_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Hmaiulh dongkah cangrhoh khocang nawnnah na khuen atah vaidam, situi a piit vaidamding vaidam laep mai khaw, situi neh a koelh vaidamding te vaidam rhawmla om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Nang kah nawnnah khocang te thiphael dongkah koinih vaidam te situi neh thoek lamtah vaidamding la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Buhkam te aek lamtah a khocang la a soah situi suep thil. ");
INSERT INTO hlt_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Tedae nang kah nawnnah khocang te thi-am dongkah koinih vaidam te situi neh saii saeh. ");
INSERT INTO hlt_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Te rhoek khui lamkah a saii khocang te BOEIPA taengla na khuen vaengah khosoih te a kamhoei phoeiah hmueihtuk la thoeih saeh. ");
INSERT INTO hlt_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Khocang khuikah kamhoeinah te khosoih loh ludoeng saeh lamtah hmueihtuk kah hmaihlutnah soah BOEIPA ham hmuehmuei botui la phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Tedae khocang kah a coih te Aaron ham neh anih koca rhoek ham om saeh. BOEIPA hmaihlutnah khuiah aka cim khuikah aka cim koek ni. ");
INSERT INTO hlt_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","BOEIPA taengah na khuen khocang boeih te tolrhu nuen boel saeh. Tolrhu mai khaw, khoitui mai khaw BOEIPA taengkah hmaihlutnah dongah phum thil boeh. ");
INSERT INTO hlt_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Thaihcuek nawnnah te BOEIPA taengla na khuen vaengah hmueihtuk soah hmuehmuei botui bangla nawn uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Na khocang nawnnah boeih te lungkaeh neh thoek lamtah na Pathen kah lungkaeh moi toeng boeh. Na khocang khui lamkah na nawnnah boeih te lungkaeh nawn thil. ");
INSERT INTO hlt_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","BOEIPA taengah thaihcuek khocang na khuen atah a vueilue te hmai neh rhoh lamtah cangthai yenkip te namah kah thaihcuek khocang la nawn. ");
INSERT INTO hlt_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Te te situi suep thil lamtah khocang te hmueihtui la tloeng thil. ");
INSERT INTO hlt_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Te phoeiah yenkip khui lamkah neh situi lamkah kamhoeinah, hmaihlutnah hmueihtui boeih te khosoih loh BOEIPA taengah phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Anih kah nawnnah tah rhoepnah hmueih te a saelhung khui lamkah a tal mai khaw a la mai khaw a nawn atah BOEIPA mikhmuh ah a cuemthuek te nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Te vaengah a nawnnah saelhung kah a lu dongah a kut tloeng saeh lamtah tingtunnah dap thohka ah ngawn saeh. Te phoeiah thii te Aaron koca khuikah khosoih rhoek loh hmueihtuk kaepvai ah haeh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Rhoepnah hmueih khui lamkah a kotak aka dah maehtha neh a kotak dongkah maehtha boeih te BOEIPA taengah hmaihlutnah hamla khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","A kuel rhoi neh a uen dongkah a tha khaw, a thin neh a kuel dongkah a thinhnun te khaw rhoe saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Te phoeiah Aaron koca rhoek loh hmueihtuk dongah hmueihhlutnah thing hmai soah BOEIPA ham hmuehmuei botui hmaihlutnah la phum uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Tedae a nawnnah boiva te BOEIPA taengah rhoepnah hmueih la a nawn atah a tal mai khaw, a la mai khaw a cuemthuek te nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Anih kah nawnnah te tuca neh a nawn atah BOEIPA kah mikhmuh ah nawn van saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Te vaengah anih kah nawnnah tu kah a lu soah a kut tloeng saeh lamtah tingtunnah dap hmai ah ngawn saeh. Te phoeiah a thii te Aaron koca rhoek loh hmueihtuk kaepvai ah haeh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Te phoeiah a songrhuh voeivang kah a kawl tha a hmabuet neh, a kotak aka dah a tha khaw, a kotak dongkah a tha boeih khaw hluep saeh lamtah BOEIPA taengah rhoepnah hmaihlutnah hmueih la nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Te phoeiah a kuel rhoi neh a uen dongkah a tha khaw, a thin neh a kuel dongkah a thinhnun te khaw hluep saeh lamtah, ");
INSERT INTO hlt_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","BOEIPA taengkah hmaihlutnah buh la hmueihtuk soah khosoih loh phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Tedae anih kah nawnnah te maae mai khaw BOEIPA mikhmuh ah a nawn atah, ");
INSERT INTO hlt_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","maae lu soah a kut tloeng saeh lamtah tingtunnah dap hmai ah ngawn saeh. Te phoeiah a thii te Aaron koca rhoek loh hmueihtuk kaepvai ah haeh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Te phoeiah hmaihlutnah nawnnah khui lamkah a kotak aka dah a tha neh a kotak dongkah a tha boeih te BOEIPA taengah nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Te phoeiah a kuel rhoi neh a uen dongkah a tha khaw, a thin neh a kuel dongkah a thinhnun khaw hluep saeh lamtah, ");
INSERT INTO hlt_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","a tha boeih te khosoih loh hmueihtuk kah hmaihlutnah buh soah BOEIPA ham hmuehmuei botui la phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Na tolrhum boeih kah na cadilcahma ham kumhal khosing la aka om, maehtha boeih neh thii boeih tah ca uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Te phoeiah BOEIPA loh Moses a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Israel ca rhoek te voek lamtah thui pah. Hinglu pakhat loh tohtamaeh ah BOEIPA kah olpaek boeih soah tholh mai ni. A saii tueng pawt khaw a lamkah pakhat khaw a saii mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","A koelh tangtae khosoih loh pilnam kah dumlai khuila lai a hmuh atah tekah tholhnah a laihmuh dongah boirhaem la saelhung khuikah vaitotal ca cuemthuek te BOEIPA taengah nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Te vaengah vaitotal te tingtunnah dap thohka kah BOEIPA mikhmuh la khuen saeh. Te phoeiah a kut te vaito kah a lu soah tloeng saeh lamtah BOEIPA mikhmuh ah vaito te ngawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","A koelh tangtae khosoih loh vaito thii te lo saeh lamtah tingtunnah dap khuila khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Te phoeiah khosoih loh a kutdawn te thii khuila nuem saeh lamtah thii te hmuencim hniyan hmai kah BOEIPA mikhmuh ah voei rhih haeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Te phoeiah thii te tingtunnah dap khuikah BOEIPA mikhmuh ah botui bo-ul la hmueihtuk ki dongah khosoih loh pae saeh. Tedae vaito thii aka coih boeih te tah tingtunnah dap thohka kah hmueihhlutnah hmueihtuk kah khoengim taengah hawk saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Boirhaem vaito tha boeih neh a kotak soah khoep aka dah maehtha te khaw, a kotak dongkah a tha boeih te khaw hluep saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","A kuel rhoi neh a uen kaep dongkah a tha te khaw, a thin neh a kuel dongkah a thinhnun te khaw hluep saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Rhoepnah hmueih vaito kah a tha vanbangla khosoih loh ludoeng saeh lamtah hmueihhlutnah hmueihtuk dongah phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Tedae vaito pho neh a saa boeih khaw, a lu neh a kho rhoek khaw, a kotak neh a aek khaw, ");
INSERT INTO hlt_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","vaito pum te rhaehhmuen vongvoel kah maehhloi a lunnah hmuen tlaai la khuen saeh lamtah hoeh saeh. Maehhloi lunnah kah thing hmai dongah hoeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Te dongah Israel rhaengpuei pum loh palang uh tih hlangping mikhmuh lamkah olka a rhael vaengah BOEIPA olpaek boeih khuikah mai khaw saii pawt koi pakhat te a saii uh atah boe uh coeng. ");
INSERT INTO hlt_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Tholh uh tih a tholhnah te amah loh a ming coeng atah saelhung khuikah vaitotal ca te hlangping loh boirhaem la khuen uh saeh lamtah tingtunnah dap hmai ah tloeng uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Te vaengah rhaengpuei khuikah patong rhoek loh BOEIPA mikhmuh kah vaito lu soah a kut tloeng uh saeh. Te phoeiah vaito te BOEIPA mikhmuh ah ngawn uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Te phoeiah a koelh tangtae khosoih loh vaito thii te tingtunnah dap khuila khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Te phoeiah khosoih loh a kutdawn te thii khuila nuem saeh lamtah hniyan hmai kah BOEIPA mikhmuh ah voei rhih haeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","thii te khaw tingtunnah dap ah BOEIPA mikhmuh kah hmueihtuk ki dongah pae saeh. Tedae thii aka coih te tingtunnah dap thohka kah hmueihhlutnah hmueihtuk kah khoengim taengah hawk saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Te vaengah maehtha boeih te ludoeng saeh lamtah hmueihtuk dongah phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","A saii vaengah boirhaem vaito a saii vanbangla rhoepnah vaito te saii saeh. Te daengah ni khosoih loh amih ham a dawth pah vetih amih te khodawk a ngai eh. ");
INSERT INTO hlt_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Te phoeiah vaito te rhaehhmuen vongvoel la khuen saeh lamtah lamhma kah hlangping kah boirhaem vaito a hoeh bangla hoeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Khoboei khaw tholh tih a BOEIPA Pathen kah olpaek khat khat khui lamkah saii pawt koi te tohtamaeh ah a saii vaengah boe coeng. ");
INSERT INTO hlt_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Tedae tholhnah dongah a tholh te amah loh a ming van neh nawnnah ham maae a tal ca a cuemthuek te khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Maae tal lu soah a kut tloeng saeh. BOEIPA mikhmuh ah hmueihhlutnah a ngawn nah hmuen ah boirhaem te ngawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Te phoeiah boirhaem thii te khosoih loh a kutdawn neh lo saeh lamtah hmueihhlutnah hmueihtuk ki dongah pae saeh. Te phoeikah thii te hmueihhlutnah hmueihtuk kah khoengim taengah hawk saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Tedae a tha boeih te rhoepnah hmueih tha bangla hmueihtuk ah phum saeh. Te daengah ni anih kah tholhnah kongah khosoih loh anih ham a dawth pah vetih khodawk a ngai eh. ");
INSERT INTO hlt_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","BOEIPA olpaek dongkah saii pawt koi khat khat te tolrhum pilnam lamkah hinglu pakhat mai loh tohtamaeh ah a saii tholh tih boe coeng. ");
INSERT INTO hlt_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Tedae a tholhnah neh a tholh te amah loh aming atah a tholhnah neh a tholh kongah a nawnnah ham te maae a la ca a cuemthuek te khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Te vaengah boirhaem lu soah a kut tloeng saeh lamtah hmueihhlutnah hmuen ah boirhaem te ngawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Te phoeiah thii te khosoih loh a kutdawn neh lo saeh lamtah hmueihhlutnah hmueihtuk ki dongah pae saeh. Tedae thii kah a coih boeih te hmueihtuk kah khoengim taengah hawk saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","A tha boeih te rhoepnah hmueih tha a hluep vanbangla hluep saeh lamtah BOEIPA taengkah hmuehmuei botui la hmueihtuk dongah khosoih loh phum saeh. Te daengah ni anih ham te khosoih loh a dawth pah vetih anih te khodawk a ngai eh. ");
INSERT INTO hlt_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Tedae a nawnnah ham te tuca ni a khuen atah a la a cuemthuek te boirhaem la khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Te vaengah boirhaem lu soah a kut tloeng saeh lamtah hmueihhlutnah a ngawn nah hmuen ah boirhaem la ngawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Te phoeiah boirhaem thii te khosoih loh a kutdawn neh lo saeh lamtah hmueihhlutnah hmueihtuk ki dongah koelh saeh. Te phoeikah thii aka coih boeih te hmueihtuk kah khoengim taengah hawk saeh. ");
INSERT INTO hlt_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Tedae a tha boeih te rhoepnah hmueih dongkah tuca tha a hluep vanbangla hluep saeh lamtah BOEIPA kah hmaihlutnah hmueihtuk dongah khosoih loh phum saeh. Te daengah ni anih kah tholhnah kongah khosoih loh a dawth pah vetih a tholh te khodawk a ngai eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Hinglu pakhat te tholh tih thaephoeinah ol a yaak. Te vaengah amah te laipai la a om dongah a hmuh tih a ming. Tedae a puen pawt atah anih kathaesainah te phuei saeh. ");
INSERT INTO hlt_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Hinglu pakhat loh rhalawt hno khaw, rhalawt mulhing rhok mai khaw cuem pawh rhamsa rhok mai khaw, rhalawt rhulcai rhok khat khat mai khaw buengrhuet a ben vaengah tah rhalawt la boe mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Hlang kah a tihnai dongkah khaw, a tihnai boeih dongah khaw a ben mai atah te nen te poeih uh coeng. Te te a phah akhaw a ming akhaw anih boe saeh. ");
INSERT INTO hlt_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Hinglu pakhat loh a cungkuem dongah thaehuet ham neh voelphoeng ham a hmuilai neh khungrhap la a toemngam mai ni. Hlang he olhlo neh a khungrhap coeng dongah te te a phah a khaw a ming akhaw te pakhat dongah anih boe saeh. ");
INSERT INTO hlt_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Tedae he rhoek khuikah khat nen khaw a boe mai akhaw te kah a tholh te loh phoe saeh. ");
INSERT INTO hlt_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Te vaengah a tholhnah neh a tholh bangla BOEIPA taengah a hmaithennah khuen saeh. Boirhaem la boiva khuikah tu a la mai khaw, maae la ca mai khaw om saeh. Te daengah ni a tholhnah dongah khosoih loh anih ham a dawth pa eh. ");
INSERT INTO hlt_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Tedae boiva kangna khaw a kut loh a na pawt atah a tholh bangla a hmaithennah te vahu phiknit mai khaw, vahui ca phiknit mai khaw, pakhat te boirhaem la, pakhat te hmueihhlutnah la BOEIPA taengah khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Te phoeiah khosoih taengla khuen saeh lamtah boirhaem ham te nawn lamhma saeh. A lu te a rhawn lamloh paimaelh pah saeh lamtah boe boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Te phoeiah boirhaem thii te hmueihtuk pangbueng dongah haeh saeh lamtah thii aka coih te boirhaem hmueihtuk kah khoengim taengah ci saeh. ");
INSERT INTO hlt_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Tedae a pabae te tah laitloeknah vanbangla hmueihhlutnah saii saeh. Te vaengah, a tholhnah neh a tholh dongah khosoih loh anih ham dawth pah saeh lamtah anih te khodawkngai saeh. ");
INSERT INTO hlt_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Tedae vahu phiknit mai khaw, vahui ca phiknit mai khaw a kut loh a na pawt oeh atah, a tholh bangla a boirhaem ham nawnnah te vaidam cangnoek parha khuen saeh. Te tah boirhaem la a om dongah a soah situi bueih boel saeh lamtah hmueihtui khaw tloeng thil boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Te vaengah khosoih taengla khuen saeh lamtah kamhoeinah te khosoih loh a kut dongah a bae mawk la paco saeh. Te phoeiah boirhaem te BOEIPA hmueihtuk kah hmaihlutnah soah phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Te daengah ni te khuikah pakhat nen khaw a tholh vanbangla a tholhnah dongah khosoih loh anih ham a dawth pah vetih anih te khodawk a ngai eh. Tedae khosaa bangla khosoih hamla om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","BOEIPA loh Moses a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Hinglu pakhat loh tholh tih BOEIPA taengah boekoeknah la boe a koek mai ni. Te vaengah hnokhueh neh kut khoom kawng dongah a imben taengah a basa atah, huencannah neh a imben te a hnaemtaek atah, ");
INSERT INTO hlt_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Hmuencim dongah lai a hmuh te a sah phoeiah panga neh thap saeh lamtah khosoih taengla thak saeh. Te daengah ni khosoih loh anih kah hmaithennah ham te tutal neh a dawth pah vetih anih te khodawk a ngai eh. ");
INSERT INTO hlt_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Hinglu pakhat loh BOEIPA olpaek khat khat khuikah saii pawt koi te pakhat khaw a saii tholh coeng dae a boe te khaw a ming pawt atah amah kathaesainah te phuei van saeh. ");
INSERT INTO hlt_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Te vaengah a phu aka ting boiva khuikah tutal a cuemthuek te khosoih taengah hmaithennah la khuen saeh. Te daengah ni anih loh ming pawt tih tohtamaeh la a taengphael te khosoih loh anih ham a dawth pah vetih anih te khodawk a ngai eh. ");
INSERT INTO hlt_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","He tah a boe, a boe vaengah BOEIPA taengkah a saii hmaithennah ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Te phoeiah Moses te BOEIPA loh a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Hinglu pakhat loh tholh tih BOEIPA taengah boekoeknah la boe a koek mai ni. Te vaengah, hnokhueh neh hnohol kawng dongah a imben taengah a basa atah, huencannah neh amah imben a hnaemtaek atah, ");
INSERT INTO hlt_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","hnohma khaw a hmuh lalah basa tih hlang taengkah a saii boeih khuikah pakhat mai neh a honghi la a toemngam dongah tholh mai thai ");
INSERT INTO hlt_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","anih laihmu la om vetih a boe coeng dongah a huenkoe a rhawth te khaw, hnaemtaeknah neh a hnaemtaek hno te khaw, anih taengah a hlah hnokhueh te khaw, hnohma a hmuh te khaw, mael saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","A honghi neh a toemngam tih a dang boeih te khaw dumlai sahnah khohnin vaengah tah a kungmah te a muel la koep sah saeh. Te te a kungmah ham panga neh thap saeh lamtah pae saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Te vaengah hmaithennah ham tutal a hmabut te BOEIPA taengah khuen saeh lamtah tekah tutal neh a phu aka tluk boiva te khosoih taengla hmaithennah ham thak saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Te daengah ni BOEIPA mikhmuh ah khosoih loh anih ham a dawth pah vetih anih khaw dumlai a saii boeih dong lamloh khodawk a ngai eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Aaron neh anih koca rhoek te uen lamtah hmueihhlutnah olkhueng he thui pah. Hmueihtuk sokah hmaikol hmuen ah hmueihhlutnah loh khoyin puet neh mincang due om saeh lamtah a soah hmueihtuk hmai loh rhong saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Te vaengah khosoih loh amah kah takhlawk himbai te bai saeh lamtah takhlawk hnii te a pum dongah na saeh. Te phoeiah hmueihtuk sokah hmueihhlutnah hmai ah aka tlum maehhloi te kol saeh lamtah hmueihtuk taengah khueh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Te phoeiah a himbai te pit saeh lamtah himbai a tloe bai saeh. Maehhloi te rhaehhmuen vongvoel kah hmuen saelh la thak saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Hmueihtuk dongkah hmai te khaw phat rhong saeh lamtah thi boel saeh. Te dongah mincang mincang vaengah khosoih loh thing toih thil saeh. Te phoeiah hmueihhlutnah te tloeng thil saeh lamtah rhoepnah maehtha soah phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Hmai te hmueihtuk soah phat rhong saeh lamtah thi boel saeh.” ");
INSERT INTO hlt_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Tahae kah he tah Aaron koca rhoek loh BOEIPA mikhmuh kah hmueihtuk hmai la khocang a khuen vaengkah olkhueng ni. ");
INSERT INTO hlt_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Khocang vaidam te a kutvang neh lo saeh lamtah situi neh hmueihtui boeih te khocang soah khueh saeh. Te phoeiah BOEIPA taengah kamhoeinah hmuehmuei botui la hmueihtuk ah phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Tedae a coih te tah Aaron neh anih koca rhoek loh ca uh saeh lamtah a caak vaengah tingtunnah dap vongup kah hmuen cim ah vaidamding neh ca uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ka hmaihlutnah lamloh amih kah hamsum ka paek te tolrhu neh thong boel saeh. Te tah boirhaem bangla, hmaithennah bangla a cim khuikah a cim koek ni. ");
INSERT INTO hlt_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","BOEIPA kah hmaihlutnah lamloh na cadilcahma rhoek ham kumhal buhvae coeng ni. Aaron koca khui lamkah tongpa boeih long tah ca saeh lamtah te te aka ben boeih long tah amah te ciim uh saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Tahae kah nawnnah dongah Aaron neh anih koca rhoek loh khocang vaidam, cangnoek parha te a koelh khohnin vaengah BOEIPA taengla khuen uh saeh lamtah mincang ah a ngancawn, hlaem vaengah a ngancawn nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Tekah khocang te thiphael dongah situi neh saiisaeh. A kae phoeiah a nuei kamat te khuen lamtah BOEIPA taengah hmuehmuei botui la nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Te vaengah a koelh tangtae khosoih neh amah koca rhoek khuikah a hnukthoi loh saii saeh. BOEIPA ham kumhal kah buhvae la boeih phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Tedae khocang boeih he rhuemtuet la om saeh lamtah khosoih loh ca boel saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Boirhaem tah BOEIPA mikhmuh ah a cim tih a cim tangkik dongah Aaron neh anih koca rhoek te voek lamtah hmueihhlutnah a ngawn nah hmuen ah boirhaem a ngawn vaengkah olkhueng he thui pah. ");
INSERT INTO hlt_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Laihmuh saa he khosoih loh hmuen cim ah ca saeh lamtah tingtunnah dap vongup ah ca saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Tekah a saa aka ben boeih loh ciim uh saeh lamtah himbai khaw a thii loh a haeh atah a haeh boeih te hmuen cim ah til uh. ");
INSERT INTO hlt_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Te vaengah lai am dongah a thong atah te te bop saeh. Tedae rhohum am dongah a thong atah met saeh lamtah tui neh lae saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Te tah cim tih a cim tangkik oeh dongah khosoih tongpa boeih loh ca saeh. ");
INSERT INTO hlt_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Tedae tholh dawth ham vaengah tingtunnah dap khuikah hmuencim la a thii a khuen boirhaem boeih te ca boel saeh lamtah hmai neh hoeh saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Te dongah hmaithennah olkhueng he a cim khuikah a cim koek la om. ");
INSERT INTO hlt_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Hmueihhlutnah a ngawn uh hmuen ah hmaithennah te ngawn uh saeh lamtah a thii te hmueihtuk kaepvai ah haeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Te vaengah a kawl dongkah a tha boeih neh a kotak aka dah maehtha te nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","A kuel rhoi neh a uen kaep dongkah maehtha khaw, a thin dongkah a thinhnun te khaw a kuel neh rhen hluep saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Te phoeiah hmaithennah te BOEIPA taengkah hmueihtuk sokah hmaihlutnah dongah khosoih loh phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Hmueihlutnah maeh te khosoih tongpa boeih loh hmuen cim ah ca uh saeh lamtah a cim khuikah a cim koek la ca saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Boirhaem khaw hmaithennah khaw a olkhueng pakhat la a om dongah dawth ham koi te khosoih hut la om. ");
INSERT INTO hlt_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Te dongah khosoih loh hlang khat khat kah hmueihhlutnah te a nawn pah vaengah a nawn hmueihhlutnah kah a pho khaw khosoih amah hut la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Tapkhuel dongkah a thong khocang boeih, thi-am dongkah neh thiphael dongkah a saii boeih khaw khocang aka nawn khosoih amah hut la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Situi neh a thoek khaw, a kaksap akhaw khocang boeih tah Aaron koca rhoek boeih neh amih boeinaphung ham rhip om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Tedae tahae kah he tah BOEIPA taengah rhoepnah hmueih a nawn vaengkah olkhueng ni. ");
INSERT INTO hlt_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Uemonah ham a nawn atah uemonah hmueih la situi neh a thoek vaidamding vaidam laep khaw, situi neh a koelh vaidamding kah vaidam rhawm khaw, situi neh a thoek tih a kae vaidam laep khaw nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Te vaengkah tolrhu buhham vaidam laep te uemonah, rhoepnah hmueih neh nawnnah la nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Te vaengkah BOEIPA taengla a nawn, nawnnah boeih khui lamkah pakhat te tah rhoepnah thii aka haeh khosoih kah khocang la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Rhoepnah dongkah uemonah hmueih saa te tah amah nawnnah hnin ah ca saeh lamtah mincang duela paih boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Tedae olcaeng neh kothoh nawnnah hmueih tah a nawn khohnin vaengah hmueih te ca saeh lamtah a caknoi te a vuen ah ca saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Hmueih saa khui lamkah a coih te a thum hnin ah hmai neh hoeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Amah kah rhoepnah hmueih saa te a thum hnin dongah a caak la a caak atah anih kah a nawn te doe pah mahpawh. Anih te a nawt a na pawt atah dikyik dikyak la om ni. Te te aka ca hinglu tah amah kathaesainah te amah loh phuei saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Rhalawt hno boeih dongah a ben maeh te ca boel saeh lamtah hmai neh hoeh saeh. Tedae aka caih maeh saa boeih tah ca saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Hinglu pakhat loh BOEIPA taengkah rhoepnah hmueih saa a caak vaengah amah te amah dongah a ti a hnai a om atah tekah hinglu te a pilnam khui lamloh hnawt saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Hinglu te rhalawt cungkuem dongah, hlang kah a tihnai dongah khaw, rhalawt rhamsa dongah khaw, konawhnah boeih dongah a rhalawt te a ben atah. BOEIPA taengkah rhoepnah hmueih saa te a caak atah tekah hinglu te pilnam lamloh hnawt saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Israel ca rhoek te voek lamtah thui pah. Vaito, tu, maae kah a tha boeih ca uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Te dongah maehrhok tha neh saha tha tah bibi khat khat dongah hnonah mai cakhaw ca rhoe ca uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Khat khat long ni BOEIPA taengkah hmaihlutnah ham a nawn rhamsa tha te a caak atah, aka ca hinglu te pilnam lamloh hnawt saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Na tolrhum boeih ah vaa lamkah khaw, rhamsa lamkah khaw thii boeih te ca uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Hinglu khat khat loh thii khat khat ni a caak atah tekah hinglu te pilnam lamloh hnawt saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Israel ca rhoek te voek lamtah thui pah. BOEIPA taengah rhoepnah hmueih aka khuen long tah rhoepnah hmueih khui lamkah a nawnnah te BOEIPA taengla pawk puei saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","BOEIPA taengkah hmaihlutnah ham te a kut loh a khuen vaengah a tha neh a rhang te khuen saeh. A rhang te BOEIPA mikhmuh ah thueng hmueih la thueng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Maehtha te khosoih loh hmueihtuk soah phum saeh. Tedae a rhang te Aaron ham neh anih koca rhoek hamla om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Te dongah nangmih kah rhoepnah hmueih khui lamkah bantang benkah a laeng te tah khosoih taengah khosaa la pae uh. ");
INSERT INTO hlt_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Aaron koca rhoek khui lamkah rhoepnah thii neh maehtha aka nawn ham maehvae la bantang laeng te om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Rhoepnah hmueih khuiah thueng hmueih kah a rhang neh a laeng he Israel ca rhoek taeng lamkah khosa la ka loh tih Israel ca rhoek taengkah kumhal maehvae la khosoih Aaron neh anih koca rhoek taengah ka paek coeng. ");
INSERT INTO hlt_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","He tah BOEIPA taengah khosoih la a nuen hnin vaengah BOEIPA hmaihlutnah khui lamkah Aaron kah maeham neh anih koca rhoek kah maeham ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Anih a koelh hnin van vaengah Israel ca rhoek loh khosoih rhoek taengah paek ham koi te tah cadilcahma due kumhal khosing la khueh ham BOEIPA loh a uen coeng. ");
INSERT INTO hlt_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Hekah olkhueng dongkah hmueihhlutnah ham, khosaa ham khaw, boirhaem ham khaw, hmaithennah ham khaw, saboi ham khaw, rhoepnah hmueih ham khaw, ");
INSERT INTO hlt_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","BOEIPA loh Sinai tlang ah Moses a uen vanbangla amah a uen khohnin vaengah Israel ca rhoek amamih kah nawnnah te Sinai khosoek kah BOEIPA taengah a nawn uh. ");
INSERT INTO hlt_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Aaron neh anih koca rhoek te amah neh himbai khaw, a koelhnah situi, boirhaem ham vaito neh tutal pumnit, vaidamding voh at te hang khuen. ");
INSERT INTO hlt_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Te phoeiah rhaengpuei boeih loh tingtunnah dap thohka ah tingtun uh saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Te dongah BOEIPA kah a uen vanbangla Moses loh a saii tih rhaengpuei loh tingtunnah dap thohka ah tingtun uh. ");
INSERT INTO hlt_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Te phoeiah Moses loh rhaengpuei taengah saii ham koi BOEIPA loh a uen te a thui pah. ");
INSERT INTO hlt_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Te phoeiah Moses loh Aaron neh anih koca rhoek te a pai sak tih tui neh a silh. ");
INSERT INTO hlt_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Aaron te angkidung a paek tih lamko a vah sak. Hnikul te a bai sak tih hnisui te a sui pah. Cihin neh a yen phoeiah hnisui khaw a hlin pah. ");
INSERT INTO hlt_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Rhangpho te a buen pah vaengah Urim neh Thummim te rhangpho khuiah a det pah. ");
INSERT INTO hlt_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","A lu ah lupong a muei sak bal tih BOEIPA loh Moses a uen vanbangla sui tamlaep neh rhuisam cim te a hmai kah lupong soah a khuem sak. ");
INSERT INTO hlt_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Te phoeiah Moses loh a koelhnah situi te a loh tih dungtlungim neh a khuikah aka om boeih te a koelh tih a ciim. ");
INSERT INTO hlt_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Te phoeiah situi te hmueihtuk soah voei rhih a haeh tih hmueihtuk neh a tubael boeih, baeldung neh hmueihtuk kho te khaw a koelh tih a ciim. ");
INSERT INTO hlt_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Te phoeiah a koelhnah situi te Aaron lu soah a suep tih anih te ciim ham a koelh. ");
INSERT INTO hlt_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Te phoeiah Moses loh Aaron koca rhoek te a pai sak tih amih te angkidung a bai sak. BOEIPA loh Moses a uen vanbangla amih te lamko a vah sak tih amih te samkhuem a khuem sak. ");
INSERT INTO hlt_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Boirhaem vaito te a khuen vaengah boirhaem vaito lu soah Aaron neh anih koca rhoek loh a kut a tloeng uh. ");
INSERT INTO hlt_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Vaito te a ngawn phoeiah a thii te Moses loh a khuen tih hmueihtuk ki neh a kaepvai ah a kutdawn neh a koelh. Te phoeiah hmueihtuk te a caih sak tih thii te hmueihtuk kah khoengim taengah a hawk. Te daengah te anih dongah a dawth ham koi te a ciim pah. ");
INSERT INTO hlt_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","A kotak dongkah maehtha boeih neh a thin dongkah a thinhnun khaw, a kuel rhoi neh a kuel dongkah a tha khaw a loh bal tih Moses loh hmueihtuk soah a phum. ");
INSERT INTO hlt_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Tedae vaito pho neh a saa khaw, a aek khaw Moses taengkah BOEIPA kah a uen vanbangla rhaehhmuen vongvoel kah hmai dongah a hoeh. ");
INSERT INTO hlt_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Hmueihhlutnah tutal te khaw a khuen tih tutal a lu soah Aaron neh anih koca rhoek loh a kut a tloeng thil uh. ");
INSERT INTO hlt_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Te phoeiah a ngawn tih a thii te hmueihtuk so neh a kaepvai ah Moses loh a haeh. ");
INSERT INTO hlt_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Tu te khaw maehpoel la a sah tih a lu neh maehpoel khaw, a tha khaw Moses loh a phum. ");
INSERT INTO hlt_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Tedae a kotak neh a kho te tui neh a silh. Te phoeiah BOEIPA loh Moses a uen vanbangla tutal pum boeih te BOEIPA ham hmuehmuei botui hmaihlutnah la hmueihhlutnah hmueihtuk soah Moses loh a phum. ");
INSERT INTO hlt_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","A pabae kah tutal te saboi la a nawn. Te phoeiah tutal kah a lu soah Aaron neh anih koca rhoek loh a kut a tloeng uh. ");
INSERT INTO hlt_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Tu te a ngawn phoeiah a thii te Moses loh a loh tih Aaron bantang a hnapae neh bantang kut kah kutpuei dongah khaw, bantang kho kah khopuei dongah khaw a koelh pah. ");
INSERT INTO hlt_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Te phoeiah Moses loh Aaron koca rhoek te a pai sak tih amih kah bantang hna kah hnapae neh bantang kut kah kutpuei dongah khaw, bantang kho kah khopuei dongah khaw thii te a koelh pah. Te phoeiah thii te hmueihtuk kaepvai ah Moses loh a haeh. ");
INSERT INTO hlt_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Te phoeiah maehtha neh a kawl khaw, a kotak dongkah a tha boeih neh a thin, a kuel rhoi dongkah a thinhnun neh a tha khaw, bantang ben kah a laeng khaw a loh tih, ");
INSERT INTO hlt_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","BOEIPA mikhmuh kah vaidamding kodawn dongkah vaidamding vaidam laep pakhat, situi buh vaidam laep pakhat neh vaidam rhawm pakhat te a loh tih maehtha neh bantang laeng soah a khueh. ");
INSERT INTO hlt_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Te phoeiah Aaron kut neh anih koca rhoek kah kut ah boeih a tloeng tih BOEIPA mikhmuh ah thueng hmueih te a thueng. ");
INSERT INTO hlt_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Te phoeiah amih kut dong lamkah saboi te Moses loh a loh tih BOEIPA taengah hmuehmuei botui hmaihlutnah la hmueihtuk sokah hmueihhlutnah dongah saboi te a phum. ");
INSERT INTO hlt_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Te phoeiah a rhang te Moses loh a loh tih BOEIPA mikhmuh ah thueng hmueih la a thueng. Saboi tutal te tah BOEIPA loh Moses a uen vanbangla Moses amah kah maehvae la a khueh. ");
INSERT INTO hlt_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Te phoeiah Moses loh a koelhnah situi neh hmueihtuk sokah thii te a loh tih Aaron neh anih kah himbai dongah khaw, anih koca rhoek neh anih koca rhoek kah himbai dongah khaw a haeh thil tih Aaron neh a himbai khaw, anih koca rhoek neh, anih koca rhoek kah himbai khaw a ciim pah. ");
INSERT INTO hlt_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Te phoeiah Aaron neh anih koca rhoek taengah Moses loh, “Maeh te tingtunnah dap thohka ah thong uh lamtah saboi kodawn dongkah buh te, Aaron neh anih koca rhoek loh ca uh saeh,’ ka ti tih ka uen vanbangla pahoi ca uh. ");
INSERT INTO hlt_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Tedae maeh neh buhham aka coih te hmai neh hoeh uh. ");
INSERT INTO hlt_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Te phoeiah nangmih kah koiyaeh hnin tah na kut dongah hnin rhih cum saeh. Khohnin hnin rhih a cup hil tingtunnah dap thohka lamloh moe uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Tihnin ah a saii vanbangla nangmih kah te saii ham neh dawth ham khaw BOEIPA loh ng'uen coeng. ");
INSERT INTO hlt_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Te vaengah khoyin khothaih hnin rhih tah tingtunnah dap thohka ah om uh. BOEIPA kah a kuek te kang uen bangla na tuem uh daengah ni na duek uh pawt eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Te dongah BOEIPA loh Moses kut ah a uen hno boeih te Aaron neh anih koca rhoek loh a saii. ");
INSERT INTO hlt_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Hnin rhet a lo vaengah Moses loh Aaron, anih koca rhoek neh Israel kah a hamca rhoek te a khue. ");
INSERT INTO hlt_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Te vaengah Aaron taengah, “Namah ham boirhaem la saelhung khuikah vaito ca neh hmueihhlutnah ham tutal a cuemthuek te lo lamtah BOEIPA mikhmuh ah nawn laeh. ");
INSERT INTO hlt_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Te phoeiah Israel ca rhoek te voek lamtah, 'Boirhaem la maae ca, hmueihhlutnah ham vaitoca neh tuca kum khat ca a cuemthuek te lo uh,’ ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","BOEIPA tah tihnin ah nangmih taengla a phoe ham coeng dongah vaito khaw, tu khaw, situi neh a thoek khocang khaw, BOEIPA mikhmuh ah rhoepnah hmueih la nawn uh laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Te dongah Moses kah a uen te tingtunnah dap hmai la a khuen uh. Te phoeiah rhaengpuei boeih loh mop uh tih BOEIPA mikhmuh ah pai uh. ");
INSERT INTO hlt_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Te vaengah Moses loh, “BOEIPA loh ol ng'uen he na vai uh daengah ni nangmih taengah BOEIPA kah thangpomnah a tueng eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Te phoeiah Moses loh Aaron taengah, “Hmueihtuk la halo phai. Namah kah boirhaem neh hmueihhlutnah te saii lamtah namah ham neh pilnam ham dawth pah laeh. Te phoeiah pilnam kah nawnnah te saii pah lamtah BOEIPA a uen vanbangla amih ham khaw dawth pah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Te dongah hmueihtuk te Aaron loh a paan tih amah ham boirhaem la vaitoca te a ngawn. ");
INSERT INTO hlt_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Te phoeiah thii te Aaron koca rhoek loh Aaron taengla a khuen pa uh. Te dongah a kutdawn te thii khuila a nuem tih hmueihtuk ki dongah a koelh phoeiah thii te hmueihtuk kah khoengim taengah a bueih. ");
INSERT INTO hlt_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Te phoeiah BOEIPA loh Moses taengkah a uen vanbangla boirhaem kah a tha, a kuel neh a thin dongkah a thinhnun te hmueihtuk dongah a phum. ");
INSERT INTO hlt_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Te phoeiah a saa neh a pho te rhaehhmuen vongvoel ah hmai neh a hoeh. ");
INSERT INTO hlt_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Hmueihhlutnah te a ngawn phoeiah thii te Aaron koca rhoek loh a pom uh tih hmueihtuk kaepvai ah a haeh. ");
INSERT INTO hlt_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Te phoeiah hmueihhlutnah te a taengah maehpoel la a pom pa uh tih a lu neh hmueihtuk dongah a phum. ");
INSERT INTO hlt_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Te phoeiah a kotak neh a kho rhoek te a silh tih hmueihtuk dongkah hmueihhlutnah soah a phum. ");
INSERT INTO hlt_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Te phoeiah pilnam kah nawnnah te a nawn. Te vaengah pilnam kah boirhaem maae te a loh tih a ngawn phoeiah lamhma kah bangla a hlup pah. ");
INSERT INTO hlt_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Te phoeiah hmueihhlutnah te a khuen tih laitloeknah vanbangla a saii. ");
INSERT INTO hlt_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Te phoeiah khocang te a khuen tih a kut dongkah a bae neh hmueihtuk sokah mincang hmueihhlutnah dongah a phum thil. ");
INSERT INTO hlt_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Te phoeiah pilnam kah rhoepnah hmueih la vaitotal neh tutal te a ngawn. thii te Aaron koca rhoek loh a thueng uh tih hmueihtuk kaepvai ah a haeh. ");
INSERT INTO hlt_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Tedae vaito neh tu kah a tha khaw, a kawl neh a dakda, a kuel neh a thin dongkah a thinhnun khaw, ");
INSERT INTO hlt_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","a rhang dongkah a tha khaw a tloeng uh tih a tha te hmueihtuk dongah a phum. ");
INSERT INTO hlt_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Tedae a rhang rhoek neh bantang laeng te tah Moses loh a uen vanbangla BOEIPA mikhmuh kah Aaron loh thueng hmueih la a thueng. ");
INSERT INTO hlt_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Te phoeiah Aaron loh a kut te pilnam taengla a phuel tih yoethen a paek. Te daengah boirhaem, hmueihhlutnah neh rhoepnah a saii lamloh suntla thuk. ");
INSERT INTO hlt_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Te phoeiah Moses neh Aaron loh tingtunnah dap khuikla kun rhoi. Te dongah ha moe rhoi tih pilnam te yoethen a paek rhoi vaengah BOEIPA kah thangpomnah loh pilnam cungkuem taengah a tueng pah. ");
INSERT INTO hlt_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Te vaengah BOEIPA maelhmai lamloh hmai ha thoeng tih hmueihtuk dongkah hmueihhlutnah neh maehtha te a hlawp. Pilnam boeih loh a hmuh vaengah tamhoe uh tih a hmai a buluk uh. ");
INSERT INTO hlt_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aaron ca rhoi Nadab neh Abihu loh amah amah baelphaih te a loh rhoi tih hmai soah a tloeng rhoi. Te phoeiah bo-ul te a khueh thil rhoi tih hmai hloeh neh BOEIPA mikhmuh ah a khueh rhoi. Te te amih rhoi taengah a uen dae moenih. ");
INSERT INTO hlt_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Te vaengah BOEIPA hmai lamkah hmai ha thoeng tih amih rhoi te a hlawp dongah BOEIPA mikhmuh ah duek rhoi. ");
INSERT INTO hlt_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Te dongah Moses loh Aaron taengah, “BOEIPA loh, 'Kai neh aka yoei taengah ka ciim uh vetih pilnam boeih kah mikhmuh ah ka thangpom uh ni,’ a ti te a thui coeng he,” a ti nah. Te vaengah Aaron khaw kuemsuem sut. ");
INSERT INTO hlt_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Te phoeiah Moses loh Aaron kah a napa noe Uzziel ca rhoi Mishael neh Elizaphan te a khue tih, “Halo rhoi lah. Na manuca rhoi he hmuencim hmai lamloh rhaehhmuen vongvoel la kawt uh ,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Te dongah Moses kah olpaek vanbangla halo uh tih amih rhoi te a angkidung dongah rhaehhmuen vongvoel la a koh uh. ");
INSERT INTO hlt_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Te phoeiah Moses loh Aaron, a ca rhoi Eleazar neh Ithamar taengah, “Na lu te lim uh boeh, na himbai khaw phen uh boeh. Te daengah ni a thintoek ah rhaengpuei pum loh na duek uh pawt eh. Tedae Israel imkhui boeih ah BOEIPA loh hmai neh a hoeh na manuca rhoek te tah rhah uh mai saeh. ");
INSERT INTO hlt_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Te dongah tingtunnah dap thohka lamkah moe uh boeh. Na soah BOEIPA kah koelhnah situi dongah na duek uh ve,” a ti nah. Te dongah Moses kah olthui bangla a saii uh. ");
INSERT INTO hlt_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","BOEIPA loh Aaron te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Namah neh namah taengkah na ca rhoek loh tingtunnah dap khuila na kun uh vaengah misurtui khaw, yu khaw o boeh. Te daengah ni na cadilcahma ham khaw kumhal khosing vanbangla na duek uh pawt eh. ");
INSERT INTO hlt_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Cimcaihnah laklo neh rhongingnah laklo ah, rhalawt laklo neh aka cil laklo ah paekboe ham om,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Israel ca rhoek thuinuet ham oltlueh cungkuem te khaw BOEIPA loh amih ham Moses kut ah a thui pah. ");
INSERT INTO hlt_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Te dongah Moses loh Aaron, Eleazar neh Ithamar koca aka sueng rhoek te, “BOEIPA hmaihlutnah dong lamkah khocang aka coih te lo uh. Tedae te tah a cim kah a cim dongah hmueihtuk taengah vaidamding la ca uh. ");
INSERT INTO hlt_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Kai ng'uen van coeng dongah BOEIPA hmaihlutnah khui lamkah khocang te namah kah buhvae neh namah koca rhoek kah buhvae la hmuen cim ah ca uh. ");
INSERT INTO hlt_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Tedae Israel ca rhoek kah rhoepnah hmueih khuiah thueng hmueih kah a rhang neh khosaa kah a laeng tah namah kah maehvae neh, na ca rhoek kah maehvae coeng ni. Na capa rhoek, na canu rhoek neh namah kah hmuen saelh ah ca uh. ");
INSERT INTO hlt_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Khosaa kah a laeng neh thueng hmueih kah a rhang khaw maehtha hmaihlutnah khaw BOEIPA mikhmuh kah thueng hmueih la thueng ham khuen uh. BOEIPA kah a uen vanbangla namah ham neh na ca rhoek ham kumhal ah maehvae la om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Te phoeiah boirhaem maae te Moses loh a tlap a tlap hatah vawl ana hai pauh. Te dongah Aaron koca rhoek khuiah aka sueng Eleazar neh Ithamar taengah a thintoek tih, ");
INSERT INTO hlt_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“A cim kah a cim boirhaem he balae tih hmuencim hmuen ah na caak uh pawh He khaw rhaengpuei kathaesainah aka phuei tih BOEIPA mikhmuh ah amih kah tholh aka dawth hamla nangmih taengah m'paek dae. ");
INSERT INTO hlt_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","A thii te hmuencim la a khuen moenih ko he. Kang uen bangla hmuencim ah ca khaw ca uh yap mai saw,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Te vaengah Aaron loh Moses taengah, “Tihnin ah a boirhaem neh hmueihhlutnah te khaw BOEIPA mikhmuh ah a nawn uh coeng dae tahae kah bangla kai taengah thoeng coeng he. Tihnin ah boirhaem he ka ca koinih BOEIPA mikhmuh ah then aya?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Tedae Moses loh a yaak vaengah a mikhmuh ah a thuem sak. ");
INSERT INTO hlt_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","BOEIPA loh Moses neh Aaron te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Israel ca rhoek te voek rhoi lamtah, diklai hmankah rhamsa boeih khuiah na caak uh ham mulhing he thui pah. ");
INSERT INTO hlt_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Rhamsa khuiah a khomae rhak tih a khomae dongkah a khorhaek aka thal neh caknaih aka naih boeih te tah ca uh. ");
INSERT INTO hlt_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Tedae caknaih aka naih neh khomae aka rhak khuiah Kalauk he ca uh boeh. Caknaih a naih dae a khomae a rhak pawt dongah nangmih ham rhalawt. ");
INSERT INTO hlt_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Saphih he khaw caknaih a naih dae a khomae a rhak pawt dongah nangmih ham rhalawt. ");
INSERT INTO hlt_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Saveh khaw caknaih a naih dae a khomae a rhak pawt dongah nangmih ham rhalawt. ");
INSERT INTO hlt_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ok he a khomae rhak tih a khomae dongkah a khorhaek thal dae caknaih a naih pawt dongah nangmih ham rhalawt. ");
INSERT INTO hlt_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","A saa te ca uh boeh. A rhok khaw ben uh boeh. Te rhoek te nangmih ham rhalawt. ");
INSERT INTO hlt_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Tui dongkah aka om boeih khuiah he ca uh. tui dongkah khaw, tuitunli dongkah khaw, soklong kah khaw a phae neh a lip aka om boeih tah ca uh. ");
INSERT INTO hlt_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Tedae tuitunli dongkah khaw, soklong kah khaw, tui dongkah rhulcai boeih neh tui khuikah aka hing hinglu boeih khuiah a phae neh a lip aka om pawt boeih te nangmih ham konawhnah ni. ");
INSERT INTO hlt_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Nangmih ham konawhnah la a om uh dongah a saa te ca uh boeh. A rhok te khaw tuei uh. ");
INSERT INTO hlt_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","A phae khaw, a lip khaw a khueh mueh la tui dongah aka om boeih te nangmih ham konawhnah ni. ");
INSERT INTO hlt_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Vaa khuiah he rhoek tah tuei uh, caak ham moenih. atha khaw, langta khaw, thamuk khaw konawhnah ni. ");
INSERT INTO hlt_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","murhung neh maisi hui khaw, ");
INSERT INTO hlt_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","vangak neh anih hui boeih, ");
INSERT INTO hlt_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Tuirhuk khaw, kirhoeng, khangkhoe, mutlo neh anih hui boeih, ");
INSERT INTO hlt_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","thathawt, tuiliim, saelbu, ");
INSERT INTO hlt_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","abuu, khosoek saelbu, tamcu, ");
INSERT INTO hlt_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","bungrho, kaikoi neh anih hui, thongpanai neh pumphak. ");
INSERT INTO hlt_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Vaa bangla om tih a kho pali neh aka yuel rhulcai boeih khaw nangmih ham konawhnah ni. ");
INSERT INTO hlt_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Tedae vaa bangla om tih a kho pali neh yuel cakhaw diklai dongah cungpet nah ham a kho phoeiah a kho aka khueh rhulcai boeih tah ca uh. ");
INSERT INTO hlt_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Kaisih neh a hui, tangboeng neh a hui khaw, tungrhit neh a hui khaw, tangku neh anih hui khaw ca uh. ");
INSERT INTO hlt_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Tedae vaa bangla om tih a kho pali aka khueh rhulcai boeih tah nangmih ham konawhnah ni. ");
INSERT INTO hlt_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","A rhok aka ben boeih tah te nen te na poeih uh ni. Amih te kholaeh duela a poeih ni. ");
INSERT INTO hlt_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","A rhok aka phuei boeih long khaw a himbai te til saeh. Anih te kholaeh duela poeih uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Rhamsa boeih khaw a khomae rhak tih a khorhaek aka thal pawt neh caknaih aka naih pawt tah nangmih ham rhalawt. Te te aka ben boeih tah poeih uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","A kho pali neh aka yuel mulhing boeih khuiah a kut neh aka yuel boeih khaw nangmih ham rhalawt. A rhok aka ben boeih tah kholaeh duela a poeih ni. ");
INSERT INTO hlt_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","A rhok aka phuei long tah a himbai te til saeh. Hlaem duela a poeih uh vaengah tah amih te nangmih ham rhalawt. ");
INSERT INTO hlt_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Diklai kah aka luem rhulcai khuiah saham, su, imrhai neh anih hui boeih, ");
INSERT INTO hlt_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","tawkke, tangkong, cangdawl, lainaat, hambo he khaw nangmih ham rhalawt. ");
INSERT INTO hlt_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Rhulcai boeih khuiah nangmih ham aka rhalawt rhoek te a duek vaengah aka ben boeih khaw kholaeh duela poeih uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","A duek vaengah anih soah aka cungku boeih tah poeih uh ni. Te dongah thing hnopai boeih neh himbai khaw, maehpho mai khaw, tolkhui mai khaw, te rhoek neh bitat la a saii hnopai boeih te tah tui dongah duung saeh. Hlaem due poeih uh saeh lamtah caihcil saeh. ");
INSERT INTO hlt_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Tedae amih khuikah te lai umam khat khat khuila a tlak atah a khui neh a khui kah boeih khaw a poeih dongah rhek dae uh laeh. ");
INSERT INTO hlt_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Caak ham cakok khat khat te tekah am tui loh a pha thil atah a poeih coeng. Te dongah umam khat khat khui lamkah ok ham koi tui khaw boeih a poeih coeng. ");
INSERT INTO hlt_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Amih rhok loh a cuhu thil boeih tah tapkhuel khaw, lungthu khaw a poeih coeng. Te rhoek rhalawt rhoek te tah palet saeh. Nangmih ham khaw rhalawt la om. ");
INSERT INTO hlt_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Tedae tuisih neh tangrhom tui tungnah a tlak thil atah tuicil la om mai cakhaw a rhok aka ben te a poeih. ");
INSERT INTO hlt_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Tedae te cangti ballung boeih tah a rhok loh tlak thil cakhaw cuem ngawn dongah tue ngawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Tedae cangti te tui dongah a khueh vaengah a rhok loh a cuhu thil atah nangmih ham rhalawt. ");
INSERT INTO hlt_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Na caak ham koi rhamsa a duek vaengah khaw a rhok aka ben tah hlaem duela poeih uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","A rhok aka ca tah a himbai te til saeh. Anih khaw hlaem duela poeih uh ni. A rhok aka phuei te khaw a himbai te til saeh. Hlaem due la poeih uh ni. Diklai ");
INSERT INTO hlt_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","ah aka luem rhulcai boeih khaw konawhnah, caak koi moenih. ");
INSERT INTO hlt_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","A bung neh aka colh boeih, a kho pali neh aka van boeih khaw, a kho aka ping boeih khaw, diklai ah aka luem rhulcai boeih he tah konawhnah ni ca uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Aka luem rhulcai boeih neh na hinglu te rhun uh boeh. Amih nen khaw poeih uh boel lamtah amih long khaw nang m'poeih uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Kai tah nangmih Pathen BOEIPA ni. Te dongah ciim uh lamtah ka cim bangla a cim la om uh. Te dongah diklai kah aka colh rhulcai boeih dongah na hinglu te poeih uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Nangmih kah Pathen la om ham Egypt khohmuen lamloh nangmih aka khuen khaw BOEIPA kamah ni. Te dongah kai ka cim bangla a cim la om uh. ");
INSERT INTO hlt_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","He tah rhamsa neh vaa, tui dongkah aka hing tih aka colh hinglu boeih neh diklai dongkah aka luem hinglu boeih ham, ");
INSERT INTO hlt_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","rhalawt laklo neh cuemcaih laklo ah, caak ham mulhing laklo neh caak koi pawh mulhing laklo ah paekboe ham olkhueng ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Israel ca rhoek te voek lamtah thui pah. Huta he vawn tih capa a cun atah pumom tue vaengah a poeih uh bangla hnin rhih khuiah poeih uh. ");
INSERT INTO hlt_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Tedae hnin rhet vaengah camoe kah yahhmui saa te rhet pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Te phoeiah ciimnah thii dongah khohnin sawmthum hnin thum khosa saeh. A caihcilnah khohnin a cum hlan atah aka cim boeih te ben boel saeh lamtah rhokso lam khaw cet boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Tedae huta a cun atah pumom vaengkah bangla yalh khat khuiah poeih uh la om saeh. Te dongah ciimnah thii dongah khohnin sawmrhuk hnin rhuk khosa saeh. ");
INSERT INTO hlt_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","A caihcilnah khohnin a cup vaengah atah capa canu kah hmueihhlutnah ham tu kum khat ca neh boirhaem la vahui ca neh vahu mai khaw tingtunnah dap thohka kah khosoih taengla khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Te phoeiah anih ham te BOEIPA mikhmuh ah nawn pah saeh lamtah dawth pah saeh. Te daengah ni anih kah pumthim thii te a caihcil eh. He tah huta tongpa aka cun ham olkhueng ni. ");
INSERT INTO hlt_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Tedae a kut loh boiva kangna khaw a hmuh pawt atah vahu phiknit mai khaw, vahui ca phiknit mai khaw hmueihhlutnah ham pakhat, boirhaem ham pakhat te khuen saeh. Te daengah ni anih ham te khosoih loh a dawth pah vetih a caihcil eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","BOEIPA loh Moses neh Aaron te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Hlang a vin a saa dongah a phuem mai khaw, a vinhna mai khaw, a dikdak la om tih a vin a saa dongah hmaibae tloh la om mai ni. Te vaengah khosoih Aaron taengah khaw, khosoih koca rhoek khuikah pakhat taengah khaw khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","A vin saa dongkah a tloh te khosoih loh a sawt vaengah a hma dongkah a mul te a bok la om tih a tloh kah a hmuethma khaw a vin saa khuila dawp a dung atah hmaibae tloh coeng ni. Tedae khosoih loh so saeh lamtah anih poeih uh ti saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Te vaengah a vin saa dongkah dikdak la bok dae a hmuethma loh a vin khuila dung pawt tih a mul khaw a bok la a om pawt atah hlang tlo te khosoih loh hnin rhih khoh dae saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","A rhih hnin vaengah khosoih loh so saeh. Tedae tloh te a mikhmuh hmuen la om tih a vin khuila tloh rhoeng mai mahpawh. Te vaengah anih te khosoih loh pabae la hnin rhih parhaeng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","A hnin rhih dongah anih te khosoih loh pabae la so bal saeh. Te vaengah a hma te maat tih a vin dongkah a hma khaw a rhoeng pawt atah khosoih loh caihcil coeng ti saeh. Phai la a om dongah a himbai te a suk vetih caihcil bitni. ");
INSERT INTO hlt_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Tedae a ciimnah ham khosoih taengla a tueng phoeiah a vin dongkah phai a rhoeng la a rhoeng atah khosoih taengah pabae la tueng bal saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Khosoih loh a sawt vaengah a vin dongkah phai te a rhoeng atah anih te khosoih loh poeih uh coeng ti saeh. Te te hmaibae ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Hmaibae tloh he hlang dongah a om van neh khosoih taengla khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Khosoih loh a sawt vaengah a vin te a bok la phuem tih, a phuem dongkah a mul te a bok la a poeh phoeiah a saa te thingsup la a thing mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","A vin a saa dongkah hmaibae he rhung coeng tih a poeih uh coeng. Anih te rhalawt coeng tih khosoih loh anih parhaeng voel boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Tedae a vin dongah hmaibae te hnai khaw hnai mai ni. Te vaengah khosoih mik kah hmuhnah boeih ah hlangtlo kah a vin boeih te hmaibae loh a lu lamkah a kho duela a thing mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Te vaengah khosoih loh so saeh lamtah a pumsa tom te hmaibae loh a thing tih tloh te a bok la boeih a om atah anih te caihcil coeng ti saeh. Anih te cim ngawn. ");
INSERT INTO hlt_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Tedae a pum dongah a saa thing a phoe tue vaengah tah aka poeih uh la om ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Tedae a saa te khosoih loh a haeng la a hmuh saeh daengah ni poeih uh a ti eh. A saa a haeng atah hmaibae coeng tih anih rhalawt om. ");
INSERT INTO hlt_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Tedae a saa thing te hoilae uh tih a bok la a poeh atah khosoih taengla koep khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Khosoih loh a sawt tih a tloh te a bok la a poeh atah khosoih loh anih caihcil coeng ti saeh. A tloh te cim ngawn. ");
INSERT INTO hlt_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","A pumsa kah a vin dongkah buhlut om tih hoeih mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","Te buhlut hmuen ah a bok la aka phuem mai khaw, dikdak la a ling a bok te a om atah khosoih taengla tueng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Khosoih loh a sawt vaengah a hmuethma loh a vin khuila dung tih a mul khaw a bok la a poeh atah khosoih loh anih poeih uh coeng ti saeh. Buhlut dongkah aka puek hmaibae tloh ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Tedae te te khosoih loh so saeh lamtah a mul te a khuiah bok mai pawt nim? Te te a vin lakah dung pawt tih nuk mai ni. Te vaengah anih te khosoih loh hnin rhih parhaeng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Tedae a vin dongah ni a rhoeng la a rhoeng atah khosoih loh anih te poeih uh coeng ti saeh. Te te tloh coeng ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Tedae dikdak te amah hmuen la om tih buhlut kah vinhnahlo khaw a rhoeng pawt atah anih te khosoih loh caihcil coeng ti saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","A vin a saa khaw hmai ung bangla om tih dikdak aka bok te khaw aka ung thai a ling a bok la a om atah, khosoih loh koep so saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Te vaengah dikdak dongkah a mul te a bok la poeh tih a hmuethma loh a vin khuila a dung atah hmai ung dongkah aka phoe hmaibae coeng ni. Te dongah khosoih loh anih poeih uh coeng ti saeh. Te te hmaibae tloh coeng ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Tedae khosoih loh a sawt vaengah dikdak dongkah a mul khaw bok voel pawt tih a vin khuila dung pawt dae a nuk atah anih te khosoih loh hnin rhih parhaeng bal saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","A hnin rhih dongah khosoih loh koep so saeh lamtah a vin dongah ni a rhoeng la a rhoeng atah khosoih loh anih poeih uh coeng ti saeh. Te te hmaibae tloh coeng ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Tedae dikdak te amah hmuen la om tih a vin dongah khaw rhoeng pawt tih a ung kah a phuem te a nukyum mai ni.A ung kah vinhnahlo la a om dongah anih te khosoih loh caihcil coeng ti saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","tongpa khaw huta mai khaw, a lu neh a baengpae dongah tloh om mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Tloh te khosoih loh a sawt vaengah a hmuethma loh a vin khuila dung tih a mul khaw huephuep a ae atah khosoih loh anih poeih uh coeng ti saeh.A lu neh a baengpae kah a thak te hmaibae ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Tedae thak tloh te khosoih loh a sawt vaengah a hmuethma te a vin khuila dung pawt tih a sam muem mai mahpawh. Te vaengah khosoih loh thak tloh kongah hnin rhih parhaeng dae saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","A hnin rhih dongah a tloh te khosoih loh koep so saeh. Te vaengah thak te rhoeng pawh, a mul dongah a ae om pawh, thak hmuethma khaw a vin khuila dung mahpawh. ");
INSERT INTO hlt_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Te vaengah vo saeh lamtah a thak te tah vo boel saeh. Te phoeiah aka thak te khosoih loh a pabae la hnin rhih parhaeng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","A hnin rhih dongah a thak te khosoih loh koep so saeh. Te vaengah a vin dongkah a thak te rhoeng pawt tih a hmuethma khaw a vin khuila a dung pawt atah khosoih loh anih caihcil coeng ti saeh. Te phoeiah a himbai suk saeh lamtah caihcil saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Tedae a ciimnah hnukah a thak te a vin dongah a rhoeng la rhoeng mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Te vaengah khosoih loh so saeh lamtah a vin dongkah a thak te a rhoeng atah a mul aka ae te khaw khosoih loh rhae hnukdawn boel saeh. Anih te rhalawt coeng ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Tedae thak te a mikhmuh hmuen la om tih a sam muem a cawn atah a thak te hoeih tih caih coeng. Te dongah anih te khosoih loh caihcil coeng ti saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Tongpa khaw, huta khaw a vin saa dongah dikdak dikdak la a bok om mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Te vaengah khosoih loh so saeh lamtah a vin saa dongkah dikdak la nuk tih a bok te a vin dongah bungsap bangla a cuen atah anih te cim ngawn . ");
INSERT INTO hlt_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Hlang he a lu poel tih lukoelh la om cakhaw cuemcaih ngawn . ");
INSERT INTO hlt_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","A baengpae neh a hmai lamloh a lu te tlaai tih talkoelh la om cakhaw cim ngawn . ");
INSERT INTO hlt_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Tedae lukoelh dongah khaw, talkoelh dongah khaw a tloh a bok a ling la om tih a lukoelh neh a talkoelh dongla hmaibae loh a phoei mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Te vaengah anih te khosoih loh so saeh. Tloh aka phuem te a lukoelh soah khaw, a talkoelh soah khaw a vin a saa dongah hmaibae mueimae bangla a bok a ling la om mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Hlang te a pahuk atah anih te rhalawt coeng tih amah te poeih uh coeng. A lu ah a tloh a om dongah khosoih loh anih poeih uh coeng ti saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","A pum dongah tloh neh aka pahuk tah himbai pawn neh om uh saeh lamtah a lu khaw a pham la om saeh. Te phoeiah a hmui te buem saeh lamtah rhalawt coeng, rhalawt tila pang saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","A pum dongah tloh neh rhalawt la a poeih uh tue khuiah tah anih te tolrhum rhaehhmuen vongvoel ah amah bueng khosa saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Hmaibae tloh te a pum dongkah himbai, tumul himbai dongah khaw, hlamik himbai dongah khaw, ");
INSERT INTO hlt_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","hnitah dongah khaw, hlamik hnithun dongah khaw, tumul, maehpho, maehpho neh bitat boeih dongah khaw om mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Tloh te himbai dongah khaw, a maehpho dongah khaw, hnitah dongah khaw, hnithun dongah khaw, maehpho hnopai khat khat dongah khaw a hing neh a ling la a om atah te te hmaibae tloh coeng ni. Te dongah khosoih taengla tueng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Te vaengah tloh te khosoih loh so saeh lamtah hlangtlo te hnin rhih parhaeng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","A hnin rhih dongah a tloh te koep sawt pah saeh. Tloh te himbai dongah khaw, hnitah dongah khaw, hnithun dongah khaw, maehpho dongah khaw, maehpho neh a saii boeih dongah a phoei atah tloh loh a dom hmaibae kah bitat te rhalawt coeng. ");
INSERT INTO hlt_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Te dongah tloh aka om himbai neh hnitah khaw, tumul hnithun khaw, hlamik khaw, maehpho neh a saii hnopai khaw boeih hoeh saeh. Hmaibae loh a dom coeng dongah hmai neh hoeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Tedae khosoih loh a sawt vaengah a tloh te himbai dongah khaw, hnitah dongah khaw, hnithun dongah khaw, maehpho hnopai khat khat dongah khaw phoei pawt mai thai. ");
INSERT INTO hlt_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Te vaengah khosoih loh uen saeh lamtah a pum dongkah tloh te sil saeh. Te phoeiah anih te a pabae la hnin rhih parhaeng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Tedae a tloh te a silh phoeiah khosoih loh so saeh. Te vaengah a tloh te rhoeng pawt cakhaw tloh te a hmuethma loh a lang pawt atah anih te rhalawt coeng ni. A hnuk a hmai ah impap om tih hmai neh hoeh laeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Tedae khosoih loh so saeh lamtah a silh phoeiah a tloh a maat atah a himbai neh maehpho khaw, hnitah neh hnithun khaw phen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Tedae himbai neh hnitah dongah khaw, hnithun neh maehpho hnopai khat khat dongah khaw koep cuen tih koep a phoe atah tloh aka om hnopai te tah hmai neh hoeh laeh. ");
INSERT INTO hlt_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Tedae himbai neh hnitah khaw, hnithun neh maehpho hnopai boeih te khaw na suk vetih tloh a nong atah pabae na suk vetih caihcil bitni. ");
INSERT INTO hlt_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","He tah tumul neh hlamik himbai khaw, hnitah neh hnithun, maehpho hnopai cungkuem dongah hmaibae tloh caihcil nah ham neh poeih uh coeng ti ham koi vaengkah olkhueng ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“He tah aka pahuk te ciimnah khohnin ah khosoih taengla a khuen vaengkah olkhueng ni. ");
INSERT INTO hlt_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Te dongah khosoih te rhaehhmuen vongvoel la cet saeh. Te phoeiah khosoih loh so saeh lamtah aka pahuk kah hmaibae tloh te a hoeih atah, ");
INSERT INTO hlt_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","khosoih loh uen saeh lamtah caihcil sak ham aka hing vathawt phiknit a cimbit neh lamphai thing, hlampai lingdik neh pumpiding te khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Te phoeiah khosoih loh uen saeh lamtah vathawt pakhat te lai am khuikah tui hing soah ngawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Vathawt pakhat te a hing la khuen saeh lamtah lamphai thing neh, hlampai a lingdik khaw, pumpiding khaw, vathawt aka hing te khaw tui hing sokah a ngawn vathawt thii khuila nuem saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Te phoeiah hmaibae aka caihcil soah voei rhih haeh thil saeh lamtah caihcil coeng ti saeh. Te phoeiah vaa hing te khohmuen hoeng la tueih saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Te phoeiah aka caihcil coeng long te a himbai suk saeh lamtah a sam boeih vo saeh. Te phoeiah tui hlu saeh lamtah caihcil uh saeh. Te phoeiah rhaehhmuen khuila ha kun saeh. Tedae dap tol ah hnin rhih khosa saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Tedae hnin rhih a lo vaengah a lu neh a baengpae dongkah a sam boeih, a mik kong khaw vo saeh. A mul te boeih vo saeh lamtah a himbai te suk saeh. A pumsa te tui neh sil saeh lamtah caihcil saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","A hnin rhet dongah tutal a hmabut pumnit neh tumanu kum khat ca a hmabut pumat, situi neh a thoek khocang vaidam doh thum, situi khap at khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Te phoeiah khosoih taengah nawn saeh lamtah aka caihcil hlang te tingtunnah dap thohka kah BOEIPA mikhmuh ah caihcil saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Te vaengah tutal pakhat te khosoih loh lo saeh lamtah situi khap at neh hmaithennah la rhen nawn saeh. Te phoeiah thueng hmueih te BOEIPA mikhmuh ah thueng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Tuca te hmaithennah boirhaem bangla khosoih ham cim tih a cim koek coeng dongah boirhaem neh hmuen cim dongkah hmueihhlutnah a ngawn nah hmuen ah ngawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Te vaengah hmaithennah thii te khosoih loh lo saeh. Te phoeiah aka caihcil hlang kah bantang hna, a hnapae neh bantang kut kah kutnu dongah khaw, bantang kho kah khopuei dongah khaw khosoih loh koelh pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Khap dongkah situi te khaw khosoih loh lo saeh lamtah khosoih kah banvoei kutpha dongah bueih saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Te phoeiah khosoih loh a banvoei kutpha dongkah situi khuila bantang kutdawn te nuem saeh lamtah situi te BOEIPA mikhmuh ah a kutdawn neh voei rhih haeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","A kutpha dongkah situi aka coih te khosoih loh aka caihcil kah bantang hna hnapae dongah khaw, a bantang kut kah kutnu dongah khaw, a bantang kho kah khonu dongah khaw, hmaithennah thii soah khaw koelh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Khosoih kutpha dongah situi aka coih te aka caihcil kah a lu dongah hluk pah saeh lamtah anih ham te khosoih loh BOEIPA mikhmuh ah dawth pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Te vaengah boirhaem te khosoih loh nawn saeh lamtah hmueihhlutnah te a ngawn phoeiah a tihnai lamkah aka caihcil ham dawth pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Hmueihtuk dongkah hmueihhlutnah neh khocang te khaw khosoih loh nawn saeh. Te phoeiah anih ham te khosoih loh dawth pah saeh lamtah caihcil saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Tedae anih te tattloel oeh tih a kut loh a na pawt atah anih ham a dawth pah vaengkah thueng hmueih la hmaithennah tuca pakhat, khocang ham situi neh a thoek vaidam doh at neh situi khap at, ");
INSERT INTO hlt_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","vahu phiknit mai khaw, vahui ca phiknit mai khaw a kut loh a na thai te tah khuen van saeh lamtah pakhat te boirhaem la, pakhat te hmueihhlutnah la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Te te a rhet hnin dongah tah amah kah a ciimnah ham te tingtunnah dap thohka kah BOEIPA mikhmuh ah khosoih taengla khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Te vaengah hmaithennah tuca neh situi khap at te khosoih loh lo saeh lamtah BOEIPA mikhmuh ah thueng hmueih la khosoih loh thueng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Hmaithennah tuca te khaw ngawn saeh. Te phoeiah hmaithennah thii te khosoih loh lo saeh lamtah aka caihcil kah bantang hna hnapae neh bantang kut kah kutnu dongah khaw, bantang kho kah khonu dongah khaw koelh pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Situi te khaw khosoih loh khosoih kah banvoei kutpha dongah bueih saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","banvoei kutpha dongkah situi te BOEIPA mikhmuh ah khosoih loh a bantang kutdawn neh voei rhih haeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","A kutpha dongkah situi te khosoih loh a caihcil sak hlang kah bantang hna hnapae dongah, bantang kut kah kutnu dongah khaw, bantang kho kah khonu dongah khaw, hmaithennah thii hmuen ah khaw koelh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Khosoih kutpha dongkah situi aka coih te a caihcil sak kah a lu soah hluk pah saeh lamtah anih ham te BOEIPA mikhmuh ah dawth pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Te phoeiah amah kut loh a na van te vahu neh vahui ca khuikah khat khat te nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","A kut loh a na dong kah pakhat te boirhaem la, pakhat te hmueihhlutnah la khocang neh rhen khueh saeh. Te phoeiah BOEIPA mikhmuh ah a caihcil sak hlang ham te khosoih loh dawth pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","He tah a pum dongah hmaibae tloh om dae a ciimnah ham a kut loh aka na pawt ham olkhueng ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","BOEIPA loh Moses neh Aaron te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Kai loh nangmih taengah khohut la kam paek Kanaan kho la na kun uh vaengah na khohut, im lo ah hmaibae tloh ka khueh atah, ");
INSERT INTO hlt_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Im kung amah te cet saeh lamtah khosoih taengah puen saeh. Te vaengah, 'Ka im khuiah tloh bangla puek coeng,’ ti nah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Te vaengah khosoih loh uen saeh lamtah tloh te sawt ham khosoih a kun hlan ah a im te saekboe saeh. Te daengah ni im khuikah boeih te a poeih uh pawt eh. Te phoeiah im te sawt ham khosoih kun saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Te phoeiah tloh te so saeh. Tloh te im pangbueng dongah a hma a hing neh a ling la om tih a hmuethma khaw pangbueng khuila dung mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Te phoeiah khosoih te imkhui lamkah im thohka la cet saeh lamtah im te hnin rhih parhaeng pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","A hnin rhih dongah khosoih loh koep mael saeh lamtah so saeh. Te vaengah a tloh te im pangbueng dongah a phoei mai thai. ");
INSERT INTO hlt_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Tedae khosoih loh uen saeh lamtah tloh aka om lungto te phil uh saeh. Te phoeiah khopuei vongvoel kah rhalawt hmuen la voei uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Te phoeiah im te a khui khaw, a kaepvai khaw kuet saeh lamtah a kuet dongkah a laipi te khopuei vongvoel kah rhalawt hmuen ah hawk uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Te phoeiah lungto a thai lo uh saeh lamtah lamhma lungto yuneg la khueh uh saeh. Dikpo khaw a thai lo saeh lamtah im te bol saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Lungto te a phil tih im a kuet phoeikah a bol hnukah khaw tloh te puek im dongla a phoei mai thai. ");
INSERT INTO hlt_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Tedae khosoih te cet lamtah so saeh. Te vaengah tloh te im khuiah a pung atah hmaibae loh a dom im khui te rhalawt coeng. ");
INSERT INTO hlt_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Te dongah im dongkah lungto neh thing khaw, im dongkah laipi boeih te khaw palet saeh lamtah khopuei vongvoel kah rhalawt hmuen la thak saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Te te parhaeng hnin khuiah a im khuila aka kun tah kholaeh due poeih uhla om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Im khuiah aka yalh tah a himbai te suk saeh. Im khuiah caak aka ca long khaw a himbai te suk saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Tedae khosoih ha pawk la ha pawk tih a sawt vaengah a im ah tloh a pung voel pawt atah im te koep bol saeh. Tloh a hoeih coeng dongah im te khaw khosoih loh caihcil coeng ti saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Te dongah im ciim ham vaa phiknit, lamphai thing, hlampai a lingdik neh pumpiding te khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Te phoeiah vaa pakhat te lai am dongkah tui hing soah ngawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Lamphai thing neh pumpiding te khaw, hlampai a lingdik te khaw, vaa hing te khaw lo bal saeh lamtah tui hing soah a ngawn vaa thii khuiah nuem saeh. Te phoeiah im dongla voei rhih haeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Im te khaw vaa thii, tui hing, vaa hing, lamphai thing, pumpiding, hlampai a lingdik neh ciim saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Tedae vaa hing te khopuei vongvoel kah khohmuen hoeng la a hlah phoeiah im ham dawth pah saeh lamtah caihcil sak saeh. ");
INSERT INTO hlt_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","He tah hmaibae tloh neh thak cungkuem ham khaw, ");
INSERT INTO hlt_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","himbai neh im khuikah hmaibae ham khaw, ");
INSERT INTO hlt_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","a phuem, vinhna, a dikdak ham khaw, ");
INSERT INTO hlt_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","He hmaibae olkhueng he rhalawt hnin neh cuemcaih hnin ah khaw aka thuinuet ham olkhueng ni, ' a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","BOEIPA loh Moses neh Aaron te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Israel ca rhoek te voek rhoi lamtah thui pah rhoi. Hlang pakhat te a pumsa dong lamkah pumthim om tih a buk pah vaengah anih te rhalawt coeng. ");
INSERT INTO hlt_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Anih kah pumthim te a ti a hnai la om tih a pumsa dongkah aka long pumthim mai khaw, a saa dongah aka kap pumthim mai khaw a ti a hnai la om. ");
INSERT INTO hlt_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","A hnai loh a hnai thil thingkong khat khat dongah aka yalh khaw aka poeih uh la om vetih anih loh a hnai thil hnopai khat khat dongkah aka ngol khaw aka poeih uh la om. ");
INSERT INTO hlt_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Anih kah thingkong aka ben boeih long tah a himbai te suk saeh lamtah tui neh sil uh saeh. Anih te khaw kholaeh due aka poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","A pum aka hnai loh a ngol thil hnopai dongah aka ngol long khaw a himbai te suk saeh lamtah tui hlu saeh. Anih te khaw kholaeh due aka poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Aka hnai kah a pumsa aka ben long khaw a himbai suk saeh lamtah tui hlu saeh. Anih te khaw kholaeh due aka poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","A cuem te a hnai loh a phuh atah a himbai suk saeh lamtah tui hlu saeh. Anih te khaw kholaeh due aka poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","A pum aka hnai loh a ngol thil ngoldoelh boeih khaw aka poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Anih dangkah aka om boeih te aka ben boeih khaw kholaeh due aka poeih uh la om saeh. Tekah hno aka phuei long tah a himbai te suk saeh lamtah tui hlu saeh. Anih te khaw kholaeh due aka poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","A pum dongah aka hnai hlang aka taek boeih khaw a kut te tui neh a lae pawt atah a himbai suk saeh lamtah tui hlu saeh. Anih te khaw kholaeh duela aka poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Lai am khaw a pum buk loh a ben atah rhek dae saeh. Tedae thing baelyak boeih te tah tui neh lae saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","A pumthim aka buk te a caihcil van atah a ciimnah ham hnin rhih due tae saeh. Te phoeiah a himbai te suk saeh lamtah a pumsa te tui hing neh sil saeh lamtah caihcil saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","A hnin rhet dongah vahu phiknit mai khaw, vahui ca phiknit mai khaw amah ham lo saeh. Te phoeiah tingtunnah dap thohka kah BOEIPA mikhmuh la khuen saeh lamtah khosoih taengah pae saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Te vaengah pakhat te boirhaem la, pakhat te hmueihhlutnah la khosoih loh nawn pah saeh. Te phoeiah anih kah pumthim kongah te khosoih loh BOEIPA mikhmuh ah dawth pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Hlang te a yangtui a yae atah a pumsa tom te tui neh sil saeh. Anih te khaw kholaeh due aka poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Himbai khat khat mai khaw, maehpho khat khat mai khaw yangtui aka om atah tui neh sil saeh. Anih te khaw kholaeh due aka poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Huta tongpa a yalh hmaih vaengkah yangtui te khaw tui neh sil rhoi saeh. Amih rhoi khaw kholaeh due aka poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Huta khaw a pumsa pumthim om tih thii a buk vaengah pumom bangla hnin rhih om saeh. Te vaengah anih aka ben boeih tah kholaeh due aka poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Pumom vaengkah a yalh thil hnopai boeih khaw aka poeih uh la om tih a ngol thil hnopai boeih te a poeih uh. ");
INSERT INTO hlt_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Anih kah thingkong aka ben boeih loh a himbai te suk saeh lamtah tui hlu saeh. Anih khaw kholaeh due aka poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","A ngol thil hnopai khat khat aka ben boeih long khaw a himbai te suk saeh lamtah tui hlu saeh. Anih khaw kholaeh due poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","A thingkong khaw, anih loh a ngol thil hnopai mai khaw aka ben tah kholaeh due poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Hlang loh a yalh a yalh puei tih pum a om atah hnin rhih khuiah poeih uh la om saeh. Te vaengah a yalh thil thingkong boeih khaw aka poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Huta he khohnin a sen pumthim la a thii buk tih a pumom tue pawt ah khaw, pumom tue a poeng phoeiah khaw pumthim la a ti a hnai neh hnin takuem a buk atah pumom tue bangla anih te rhalawt la om. ");
INSERT INTO hlt_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Pumthim a om tue khuiah a yalh thil thingkong boeih khaw pumom vaengkah thingkong vanbangla om. A ngol thil hnopai boeih khaw pumom tue vaengkah a tihnai vanbangla anih te rhalawt la om ni. ");
INSERT INTO hlt_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Tekah hnopai aka ben boeih khaw a poeih coeng dongah a himbai te suk saeh lamtah tui hlu saeh. Anit khaw kholaeh due poeih uh la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Tedae a pumthim te a caihcil phoeiah hnin rhih hil tae saeh lamtah caihcil saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","A rhet hnin dongah vahu phiknit mai khaw vahui ca phiknit mai khaw amah ham lo saeh lamtah tingtunnah dap thohka kah khosoih taengla khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Te vaengah pakhat te boirhaem la, pakhat te hmueihhlutnah la khosoih loh nawn saeh. Te phoeiah anih kah a ti a hnai pumthim kongah khosoih loh BOEIPA mikhmuh ah dawth pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Israel ca rhoek loh a tihnai khui lamkah cue uh saeh. Te daengah ni amih khui kah ka dungtlungim te a poeih vaengkah amamih kah a tihnai dongah a duek uh pawt eh. ");
INSERT INTO hlt_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","He tah a pum lamloh a hnai neh yangtui aka coe loh a poeih ham, ");
INSERT INTO hlt_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","a pumom vaengkah hainakthak neh pumthim aka buk ham khaw, tongpa ham neh huta ham khaw, rhalawt taengah aka yalh hlang ham olkhueng ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Aaron ca rhoi loh BOEIPA mikhmuh la a moe rhoi hatah duek rhoi. Amih rhoi a duek phoeiah Moses te BOEIPA loh a voek. ");
INSERT INTO hlt_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Te vaengah Moses taengah BOEIPA loh, “Na maya Aaron te thui pah. Thingkawng tlaeng sokah cingmai dongah ka phoe coeng. Te dongah thingkawng tlaeng hmai, imkhui hniyan khuikah hmuencim khuila a tue takuem ah kun mailai boel saeh. Te daengah ni a duek pawt eh. ");
INSERT INTO hlt_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aaron te hmuencim la a kun atah boirhaem la saelhung khuikah vaito ca neh hmueihhlutnah la tutal te khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","A pumsa dongah takhlawk angkidung cim te bai saeh lamtah takhlawk hnii te na saeh. Te phoeiah takhlawk lamko te vah saeh lamtah takhlawk lupong te muei saeh. He rhoek he himbai cim ni. Te dongah a pumsa te tui neh a silh phoeiah te te bai saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Te phoeiah Israel ca rhaengpuei taeng lamkah boirhaem la maae ca pumnit neh hmueihhlutnah la tutal pakhat te lo saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Te vaengah boirhaem vaito te Aaron loh amah ham nawn saeh lamtah amah ham neh a imkhui ham dawth saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Maae rhoi te khaw lo saeh lamtah tingtunnah dap thohka kah BOEIPA mikhmuh ah tloeng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Te phoeiah Aaron loh maae rhoi ham hmulung naan saeh lamtah hmulung pakhat te BOEIPA ham, hmulung pakhat te sombawknah la khueh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","BOEIPA kah hmulung loh a nan maae te Aaron loh khuen saeh lamtah boirhaem la nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Tedae sombawknah ham hmulung loh a nan maae te BOEIPA mikhmuh ah a hing la pai sak saeh. Te phoeiah sombawknah te khosoek la hlah saeh lamtah amah tholh te dawth saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Te phoeiah boirhaem vaito te Aaron loh amah ham khuen saeh lamtah amah ham neh a imkhuikho ham dawth saeh. Te phoeiah boirhaem vaito te amah ham ngawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Te vaengah BOEIPA mikhmuh kah hmueihtuk dongkah hmai alh te baelphaih a bae neh botui bo-ul kah a vai a kutnarhum a bae pom saeh lamtah im khuikah hniyan khuila khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Te phoeiah bo-ul te BOEIPA mikhmuh kah hmai dongah tloeng saeh. Te vaengah bo-ul kah a hu loh olphong sokah a tlaeng te a khuk daengah ni a duek pawt eh. ");
INSERT INTO hlt_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Vaito thii te khaw lo saeh lamtah thingkawng tlaeng kah a hmai khothoeng benla a kutdawn neh haeh saeh. Thingkawng tlaeng kah a hmai ah khaw thii te a kutdawn neh voei rhih haeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Te phoeiah pilnam kah boirhaem maae te ngawn saeh lamtah a thii te im khuikah hniyan khuila khuen saeh. Tekah thii te khaw vaito thii a saii bangla saii saeh lamtah thingkawng tlaeng dongah khaw, thingkawng tlaeng kah a hmai ah khaw haeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Te tlam te hmuencim ham khaw, Israel ca rhoek kah a ti a hnai neh boekoek kongah khaw, amih kah tholhnah cungkuem ham khaw dawth pah saeh lamtah amih khuiah a ti a hnai neh aka om tingtunnah dap ham khaw saii pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Tholh dawth ham hmuencim la kun tih koep ha pawk hlandue hlang pakhat khaw tingtunnah dap khuiah om boel saeh. Te vaengah amah ham neh a imkhui ham khaw, Israel hlangping boeih ham khaw dawth pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Te phoeiah BOEIPA mikhmuh kah hmueihtuk la cet saeh lamtah amah ham koep dawth bal saeh. Te vaengah vaito thii neh maae thii te lo saeh lamtah hmueihtuk ki dongkah a kaepvai ah koelh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","thii te khaw a kutdawn neh voei rhih haeh saeh lamtah amah a caihcil phoeiah Israel ca rhoek a ti a hnai lamkah ciim ");
INSERT INTO hlt_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Hmuencim, tingtunnah dap neh hmueihtuk ham a dawth te a coeng phoeiah maae te a hing la nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Te vaengah Aaron loh a kut te kut bok la maae hing kah a lu dongah tloeng saeh. Te phoeiah Israel ca rhoek kathaesainah boeih neh amih kah boekoek boeih, amih kah tholhnah boeih te khaw phoe thil saeh lamtah maae lu dongah phueih sak saeh. Te phoeiah sikim hlang kah kut dongah khosoek la thak saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Te vaengah amih kathaesainah boeih te maae loh khohmuen hoeng la phuei saeh lamtah maae te khosoek ah hlah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Te phoeiah Aaron te tingtunnah dap khuila kun saeh. Hmuencim la a kun vaengkah a bai takhlawk himbai te pit saeh lamtah pahoi khoem saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","A pum te khaw hmuen cim kah tui neh sil saeh lamtah a himbai te bai saeh. Te phoeiah halo saeh lamtah amah kah hmueihhlutnah neh pilnam kah hmueihhlutnah te nawn saeh. Te phoeiah amah ham neh pilnam ham te dawth saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Boirhaem kah a tha te khaw hmueihtuk dongah phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Sombawknah maae aka hlah long khaw a himbai te suk saeh lamtah a pum te tui neh sil saeh. Te phoeiah rhaehhmuen la kun saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Tholh dawth nah ham hmuencim koek la a thii a khuen boirhaem vaito neh boirhaem maae te khaw rhaehhmuen vongvoel la thak saeh lamtah a vin khaw, a saa khaw, a aek khaw hmai neh hoeh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Te te aka hoeh long khaw a himbai suk saeh lamtah a pum te tui neh a silh phoeiah rhaehhmuen khuila koep kun saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Te dongah hla rha dongkah a hla rhih vaengah tah na hinglu te phaep uh. Nangmih khui kah mupoe neh nangmih taengah aka bakuep yinlai loh bitat pakhat khaw na saii uh pawt ham te nangmih taengah kumhal khosing la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Tekah khohnin dongah nangmih te na tholhnah cungkuem khui lamkah caihcil sak ham BOEIPA mikhmuh ah nangmih ham a dawth vetih na caihcil uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Sabbath khaw nangmih ham koiyaeh la om tih na hinglu na phaep ham te kumhal khosing la om coeng. ");
INSERT INTO hlt_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Te vaengah a napa hnukthoi ah khosoih ham a koelh tih a kut tloeng thil tangtae khosoih loh takhlawk himbai neh himbai cim te bai saeh lamtah dawth van saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Te phoeiah hmuencim kah rhokso neh tingtunnah dap ham dawth pah saeh. Hmueihtuk ham khaw dawth saeh lamtah khosoih rhoek ham neh pilnam hlangping boeih ham khaw dawth bal saeh. ");
INSERT INTO hlt_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Te dongah tahae kah he BOEIPA loh Moses a uen vanbangla amamih kah tholhnah cungkuem dongah kum khat ah voeikhat a saii tih Israel ca rhoek ham tholh a dawth vaengkah ham nangmih taengah kumhal khosing la om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Moses te BOEIPA loh a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Aaron, anih koca rhoek neh Israel ca rhoek boeih te voek lamtah thui ham koi tah, BOEIPA kah a uen bangla olka he amih taengah thui pah. ");
INSERT INTO hlt_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Israel imkhui lamkah hlang khat khat loh vaito mai khaw, tuca mai khaw, maae mai khaw rhaehhmuen ah a ngawn tih rhaehhmuen vongvoel ah khaw a ngawn mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Te vaengah BOEIPA dungtlungim hmai kah BOEIPA taengah nawnnah la nawn ham tingtunnah dap thohka ah khuen boel saeh. Tekah hlang te thii aka long sak la poek saeh. Thii a long sak coeng dongah tekah hlang te a pilnam khui lamkah hnawt saeh. ");
INSERT INTO hlt_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Kohong khaepdan ah a nawn hmueih te khaw Israel ca rhoek loh hang khuen ngawn saeh. Te vaengah tingtunnah dap thohka kah BOEIPA taeng neh khosoih taengah khuen uh saeh lamtah BOEIPA taengah rhoepnah hmueih la nawn uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Te vaengah thii te tingtunnah dap thohka kah BOEIPA hmueihtuk dongah khosoih loh haeh saeh. Te phoeiah maehtha te BOEIPA taengah hmuehmuei botui la phum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Tedae amih loh a taengah a cukhalh puei uh maae taengah amamih kah hmueih koep nawn uh boel saeh. He tah amamih ham neh a cadilcahma ham khaw kumhal khosing la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Te phoeiah Israel imkhui kah hlang boeih neh amih lakli kah aka bakuep tih hmueihhlutnah hmueih aka nawn yinlai khaw thui pah. ");
INSERT INTO hlt_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","BOEIPA taengah nawn ham kangna khaw tingtunnah dap thohka la a khuen pawt atah tekah hlang te a pilnam lamkah hnawt saeh. ");
INSERT INTO hlt_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Israel imkhui lamkah hlang khat khat long khaw, amih lakli kah aka bakuep yinlai lamkah long khaw thii khat khat ni a caak atah ka hmai ka khueh thil ni. Thii aka ca hinglu te pilnam khui lamloh ka hnawt ni. ");
INSERT INTO hlt_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ba dongah tikoinih pumsa kah hinglu he thii dongah om. Te dongah nangmih kah hinglu ham hmueihtuk soah na dawth uh vaengah hinglu thii la dawth ham ni kai loh nangmih taengah kam paek. ");
INSERT INTO hlt_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Te dongah, 'Israel ca rhoek nangmih lamkah hinglu boeih loh thii ca uh boel lamtah, nangmih lakli kah aka bakuep yinlai long khaw thii te ca boel saeh,’ ka ti. ");
INSERT INTO hlt_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Tedae Israel ca rhoek khui lamkah hlang khat khat long mai khaw, amih lakli kah aka bakuep yinlai long mai mulhing saa neh vaa te a yuep tih a caak oeh atah a thii te ci saeh lamtah laipi neh vuei saeh. ");
INSERT INTO hlt_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Pumsa boeih kah hinglu tah a thii dongah om tih a thii khaw a hinglu dongah om. Te dongah, 'Pumsa khat khat kah a thii tah ca uh boeh. Pumsa boeih kah hinglu a thii aka ca boeih tah hnawt saeh,’ tila Israel ca rhoek taengah ka thui. ");
INSERT INTO hlt_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Te phoeiah tolrhum mupoe neh yinlai khuikah hinglu boeih loh maehrhok neh saha te a caak atah a himbai te suk saeh lamtah tui hlu saeh. Kholaeh due aka poeih uh la om saeh lamtah caihcil saeh. ");
INSERT INTO hlt_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Tedae himbai te suk pawt tih a pum te a silh pawt atah amah kathaesainah te amah loh phuei van saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Moses te BOEIPA loh a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Israel ca rhoek te voek lamtah thui pah. Kai tah BOEIPA na Pathen ni. ");
INSERT INTO hlt_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Egypt kho ah na om uh vaengkah bibi bangla saii uh boeh. Te phoeiah kai loh nangmih kam pha sak Kanaan kho kah khoboe bangla om uh boel lamtah amih kah khosing te awt uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Kai kah laitloeknah he ngai uh lamtah ka khosing te vai ham ngaithuen uh. Kai tah nangmih kah Pathen Yahweh ni. ");
INSERT INTO hlt_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Te dongah kai kah khosing aka ngaithuen tih ka laitloeknah aka ngai hlang te tah tekah khosing dongah hing van ni. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Hlang la aka om hlang long tah amah kah a pum a saa boeih te ayah hliphen ham paan boel saeh. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Na pa kah a yah khaw, na nu kah a yah khaw, na manu khaw hliphen boeh. A yah khaw hliphen pah boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Na pa yuu kah a yah, na pa kah a yah te hliphen pah boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Na ngannu, na pa kah a ngannu, na nu kah a tanu kah a yah khaw, im kah pacaboeina neh kholong kah pacaboeina yah khaw hliphen boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Na capa canu neh na canu canu kah a yah khaw namah kah a yah la a om boeiloeih dongah amih kah a yah te hliphen boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Na pa yuu canu kah a yah khaw, na pa kah pacaboeina, na ngannu kah a yah khaw hliphen boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Na pa ngannu kah , na pa huiko kah a yah khaw hliphen pah boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Na nu kah a tanu, na nu huiko kah a yah khaw hliphen pah boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Na pa manuca kah a yah khaw hliphen boeh. Anih yuu neh na pi khaw paan pah boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Na langa kah a yah te hliphen pah boeh. Na ca yuu kah a yah khaw hliphen pah boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Na manuca yuu kah a yah, na manuca kah a yah te hliphen pah boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Na yuu neh a canu, a capa canu neh a canu canu kah a yah te hliphen pah boeh. Na thii na saa kah a yah hliphen pah ham lo boeh. Te bang te khonuen rhamtat ni. ");
INSERT INTO hlt_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Na yuu amah a hing lalah a yah hliphen pah ham neh daengdaeh ham a tanu te lo boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Te phoeiah huta te a ti a hnai neh pumom tue vaengah a yah hliphen pah ham paan boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Na imben kah a yuu aka poeih ham khaw na tamtah tii te khueh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Na tiingan te Molek taengah khumpael sak ham pae boeh. Te dongah na Pathen ming te poeih boeh. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","tongpa puei khaw huta thingkong bangla yalh puei boeh. Te ta tueilaehkoi ni. ");
INSERT INTO hlt_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Rhamsa khat khat neh aka poeih uh ham khaw na tamtah khueh boeh. Huta long khaw rhamsa neh pitpom tih, anih kui hamla duen boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","He boeih nen he poeih uh boeh. Namtom rhoek khaw he boeih nen he a poeih uh dongah ni nangmih mikhmuh ah ka haek. ");
INSERT INTO hlt_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Khohmuen pataeng a poeih uh dongah amah kathaesainah te ka cawh pah tih, khohmuen kah khosa rhoek khaw a lok thil. ");
INSERT INTO hlt_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Tedae nangmih loh ka khosing neh ka laitloeknah he ngaithuen uh. Te dongah te bang tueilaehkoi boeih te tolrhum mupoe long khaw, nangmih taengah aka bakuep yinlai long khaw saii boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Nangmih mikhmuh kah tolrhum hlang rhoek loh he rhoek kah tueilaehkoi boeih he a saii uh dongah khohmuen khaw a poeih uh. ");
INSERT INTO hlt_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Te dongah nangmih mikhmuh kah namtom a tha bangla na khohmuen na poeih uh van tih nangmih khaw khohmuen loh n'tha boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","U hlang khaw he rhoek kah tueilaehkoi hno khat khat a saii atah aka saii hlanghing boeih te pilnam lamkah hnawt saeh. ");
INSERT INTO hlt_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Te dongah nangmih mikhmuh kah tueilaehkoi khosing aka saii rhoek te vai pawt ham kamah loh ka kuek te ngaithuen uh. Te daengah ni amih taengah pum te na poeih uh pawt eh. Kai tah nangmih kah Pathen BOEIPA ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Moses te BOEIPA loh a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Israel ca rhoek rhaengpuei boeih te voek lamtah thui pah. Na Pathen BOEIPA kamah he ka cim dongah a cim la om uh. ");
INSERT INTO hlt_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Hlang boeih loh a manu neh a napa te rhih lamtah ka Sabbath khaw tuem uh. Kai tah na BOEIPA Pathen. ");
INSERT INTO hlt_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Mueirhol rhoek taengla hooi uh boeh. Mueihlawn pathen rhoek khaw namamih ham saii uh boeh. Kai tah na Pathen BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","BOEIPA taengah rhoepnah hmueih na nawn vaengah khaw nangmih taengah kolonah la nawn uh. ");
INSERT INTO hlt_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Na hmueih te amah khohnin neh a vuen ah ca. Tedae a thum hnin duela a coih atah hmai neh hoeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","A thum hnin ah dikyik dikyak te koep a caak la a caak atah anih te moeithen mahpawh. ");
INSERT INTO hlt_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Te te aka ca loh BOEIPA kah a cimcaihnah te a poeih dongah amah kathaesainah te phuei saeh. Tekah hlanghing te a pilnam lamloh hnawt saeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Na khohmuen kah cang na ah uh vaengah khaw na lo saa te boeih at boel lamtah na cangvuei kah a mo khaw boeih yoep boeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Na misur khaw boeih yun boel lamtah na misur mo te koep rhut boeh. Te tah mangdaeng ham neh yinlai ham hnoo pah. Kai tah nangmih kah BOEIPA Pathen ni. ");
INSERT INTO hlt_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Huen uh boeh. Basa uh boeh. Hlang khat neh khat loh a imben taengah rhilat uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Kai ming neh a honghi te toemngam uh boeh kai BOEIPA na Pathen ming he na poeih uh ve. ");
INSERT INTO hlt_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Na hui te hnaemtaek boeh, rheth khaw rheth boeh. Kutloh kah thaphu te namah taengah mincang duela rhaeh sak boeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Hnapang te tap boeh, mikdael hmai ah hmuitoel khueh boeh. Na Pathen te rhih lah. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Tiktamnah te dumlai la saii uh boeh. tattloel maelhmai khaw dan uh boeh, hlanglen maelhmai khaw hiin uh boeh. Na imben kah lai te duengnah neh tloek uh. ");
INSERT INTO hlt_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Na pilnam taengah caemtuh ham dongpoeng boeh, na hui kah a thii te pai thil boeh. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Na manuca te na thin neh hmuhuet boeh. Na tluung tueng atah na imben khaw tluung lamtah anih kah tholhnah te tah rhooi boeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Na pilnam koca taengah phulo boel lamtah lunguen boeh. Tedae na hui te namah pum bangla lungnah. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Ka khosing he ngaithuen uh, na rhamsa khaw a coom neh kui sak boeh. Na lo ah cangti aka coom tuh boeh. Himbai khaw a coom la a yaep te na pum dongah khueh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Hlang khat khat loh huta taengah yalh tih yangtui a hlah phoeiah hlang kah salnu te a veet mai ni. Te vaengah a lat ham dae lat uh pawt tih poenghalnah a paek pawt atah huta te lai la om cakhaw hlang hoeng la a om pawt dongah duek sak uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Tedae tongpa loh hmaithennah tutal te tingtunnah dap thohka kah BOEIPA taengah hmaithennah la khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Tongpa khaw tholhnah neh lai a hmuh coeng dongah amah ham hmaithennah tutal neh BOEIPA mikhmuh ah khosoih loh dawth pah saeh. Te vaengah anih te tholhnah neh a laihmuh khui lamloh khodawkngai saeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Khohmuen la na kun uh tih caak ok kung khat khat na ling uh vaengah a thaih te yahhmui rhet banghui la a muel la ca boeh kum thum om sak dae. ");
INSERT INTO hlt_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","A kum li dongkah a thaih boeih te tah BOEIPA taengah cangkoeinah buhcim la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Tedae a kum nga dongkah a thaih te ca uh lamtah a vuei khaw nangmih ham tomthap saeh. Kai tah nangmih kah Pathen BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Thii te ca uh boeh, lungso uh boeh, kutyaek khaw so uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Na lu kah baengki te rhuep uh boeh. Na hmuimul ngalh ngalh kuet uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Hinglu ham namah saa te a boenahhma khueh uh boeh. Na pum dongah mangthun ngo khaw khueh uh boeh. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Cukhalh dongah na tanu te poeih uh boeih. Te daengah ni khohmuen loh cukhalh pawt vetih khohmuen ah khonuen rhamtat a baetawt pawt eh. ");
INSERT INTO hlt_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Kai kah Sabbath he ngaithuen uh lamtah ka rhokso khaw rhih uh. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Nangmih aka poeih ham rhaitonghma taengla hooi uh boeh. Hnam khaw tlap uh boeh. Kai tah nangmih kah Pathen BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Sampok hmai ah thoh pah lamtah patong maelhmai hiin lah. Te phoeiah na Pathen khaw rhih lah. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Na khohmuen ah aka bakuep yinlai te vuelvaek boeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Nangmih taengah aka bakuep yinlai te namamih lamkah mupoe bangla om van saeh. Egypt kho ah yinlai la na om uh van dongah anih te namah pum bangla lungnah. Kai tah na Pathen BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Laitloeknah dongkah cungnueh ham, a khiing ham neh khoe ham dumlai la saii boeh. ");
INSERT INTO hlt_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Nangmih taengah duengnah cooi, duengnah coilung, duengnah cangnoek, neh duengnah bunang mah dawk om saeh. Kai tah Egypt kho lamkah nangmih aka khuen na Pathen BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Ka khosing boeih te ngaithuen uh lamtah ka laitloeknah boeih te vai uh lah. Kai tah BOEIPA ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Israel ca rhoek taengah thui pah. Israel ca rhoek neh Israel taengah aka bakuep yinlai khui lamkah hlang khat khat loh a tiingan te Molek taengah a paek atah vang khuikah pilnam loh lungto neh dae uh saeh lamtah duek rhoela duek saeh. ");
INSERT INTO hlt_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Tekah hlang te kai loh ka hmai ka khueh thil ni. A tiingan te Molek taengla a paek tih ka rhokso te a poeih phoeiah ka ming cim te a thae sak dongah a pilnam khui lamkah ka khoe ni. ");
INSERT INTO hlt_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Tedae Molek taengah a tiingan aka pae hlang te khohmuen pilnam loh a mik a him a him thil uh tih a duek sak uh pawt atah, ");
INSERT INTO hlt_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","tekah hlang neh a huiko te kai loh ka hmai ka khueh thil van vetih anih neh anih taengkah aka cuk aka halh boeih khaw, Molek taengah aka cuk aka halh khaw a pilnam khui lamkah ka khoe ni. ");
INSERT INTO hlt_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Rhaitonghma neh hnam hnukah cukhalh ham aka mael hinglu te khaw ka hmai ka khueh thil bal ni. Tekah hlanghing te a pilnam khui lamkah ka khoe ni. ");
INSERT INTO hlt_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Kai tah na BOEIPA Pathen la ka om dongah nangmih khaw ciim uh lamtah a cim la om uh. ");
INSERT INTO hlt_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Kai kah khosing he ngaithuen uh lamtah vai uh. Kai tah nangmih aka ciim BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Hlang khuikah hlang loh a manu neh a napa te a tap atah duek rhoe duek saeh. A manu a napa a tap dongah amah thii te amah pum ah tla saeh. ");
INSERT INTO hlt_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Hlang yuu neh aka samphaih tih, a hui kah a yuu neh aka samphaih hlang te aka samphaih pa khaw aka samphaih nu khaw duek rhoe duek rhoi saeh. ");
INSERT INTO hlt_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Hlang te a napa yuu taengah yalh tih a napa kah a yah te a poelyoe pah atah amih rhoi te duek rhoe duek rhoi saeh lamtah a thii te amamih dongah om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Hlang te a langa taengah a yalh atah amih rhoi te duek rhoe duek saeh. Amah thii te amah dongah pitpom ham a saii rhoi. ");
INSERT INTO hlt_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Huta thingkong bangla tongpa neh tongpa aka yalh te khaw tueilaehkoi ni. Amamih rhoi kah a saii vanbangla duek rhoe duek rhoi saeh lamtah a thii te amamih rhoi tlak thil saeh. ");
INSERT INTO hlt_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","tongpa pakhat loh huta neh a manu te rhen a loh te khaw khonuen rhamtat ni. Amih te hmai neh hoeh uh. Te daengah ni nangmih khui ah khonuen rhamtat a om pawt eh. ");
INSERT INTO hlt_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Rhamsa taengah a tamtah aka khueh hlang te tah duek rhoe duek sak lamtah rhamsa te ngawn uh. ");
INSERT INTO hlt_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Rhamsa boeih te khaw amah taengah kui sak ham ni huta loh a paan atah huta te ngawn lamtah rhamsa khaw duek rhoe duek sak uh. A thii te amah pum dongah tla saeh. ");
INSERT INTO hlt_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","A napa canu, a manu canu, amah ngannu aka lo tih a napa kah a yah aka so neh a manu kah a yah aka so hlang he khaw rhaidaeng. A pilnam boeina mikhmuh lamkah khoe saeh. A ngannu kah a yah a hli a phen dongah amah kathaesainah te phuei saeh. ");
INSERT INTO hlt_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Hlang pakhat loh pumthim aka tlo huta te a yalh puei atah anih kah a yah ni a hli a phen pah tih pumthim ni a tai pah. Huta amah long khaw a rhoi tih a thii pumthim te a tai dongah amih rhoi te pilnam khui lamkah khoe uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Na nu kah a tanu neh na pa ngannu kah a yah khaw na hli na phen mahpawh. Te dongah amah saa aka yan tah amamih kathaesainah te phuei uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Hlang pakhat mai long ni a napi te a yalh puei atah a nupu kah a yah ni a hli a phen. Te dongah a tholh te phuei saeh lamtah cakol la duek saeh. ");
INSERT INTO hlt_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","U bang hlang long khaw a manuca kah a yuu aka rhawt pah tah rhalawt la om. A manuca kah a yah te a hliphen dongah cakol la duek saeh. ");
INSERT INTO hlt_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Te dongah ka khosing te ngaithuen lamtah ka laitloeknah boeih te vai uh. Te daengah ni kai loh kam pha sak khohmuen loh nangmih te n'lok thil pawt vetih a khuiah te kho na sak uh eh. ");
INSERT INTO hlt_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Namtom kah khosing bangla pongpa uh boeh. Te boeih te a saii uh tih amih te ka muei a puel dongah nangmih mikhmuh lamkah ka haek. ");
INSERT INTO hlt_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Tedae amih kah khohmuen te na pang ham, 'Suktui neh khoitui aka long khohmuen pang ham khaw nangmih taengah kamah loh kam paek ni, ' tila nangmih taengah ka thui. Nangmih kah Pathen BOEIPA kamah long ni pilnam khui lamkah nangmih kan hoep. ");
INSERT INTO hlt_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Te dongah rhamsa aka cuem te rhalawt khui lamloh, vaa rhalawt te khaw a cuem lamloh hoep uh. Na hinglu te rhamsa nen khaw, vaa nen khaw, diklai kah aka colh boeih nen khaw rhun uh boeh. Te tah nangmih ham aka poeih uh lam ni ka hoep. ");
INSERT INTO hlt_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","BOEIPA kamah ka cim dongah kai taengah a cim la om uh. Kamah taengah om sak ham ni pilnam rhoek khui lamkah nangmih te kan hoep. ");
INSERT INTO hlt_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Te dongah tongpa khaw huta khaw, rhaitonghma neh hnam te a om atah duek rhoe duek saeh. Amih te lungto neh dae uh saeh lamtah a thii te amamih dongah tla saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","BOEIPA loh Moses te a voek tih, “Aaron koca khosoih te voek lamtah thui pah. Amih loh a hinglu te a pilnam taengah poeih boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","amah pumsa, amah huiko rhep ham, a manu ham, a napa ham, a capa ham, a canu ham, a manuca ham, ");
INSERT INTO hlt_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","a ngannu a va om pawt tih anih dongah oila la aka hangdang ham atah poeih uh mai saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Amah aka poeih ham a pilnam khuikah boei nen khaw poeih uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","A lu te lungawng la kuet rhoe kuet uh boel saeh. A baengpae neh a baengki khaw vo uh boel saeh. A pumsa te a boenah neh boe uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","A Pathen ham a cim la om uh saeh lamtah a Pathen ming te poeih uh boel saeh. Te dongah BOEIPA kah hmaihlutnah, Pathen kah buh aka nawn amih khaw a cim la om uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Pumyoi neh huta rhong te lo uh boel saeh. A va aka ma huta khaw lo uh boel saeh. Te dongah a Pathen ham a cim la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Khosoih long tah na Pathen kah buh a nawn dongah amah te ciim uh saeh. Nangmih aka ciim BOEIPA kamah he ka cim dongah khosoih khaw nang taengah a cim la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Khosoih tongpa kah a canu khaw a cuk a halh loh a poeih atah a napa ni a poeih. Te dongah anih te hmai neh hoeh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","A manuca khui lamkah a lu dongah koelhnah situi a suep pah tih himbai bai ham a kut a tloeng thil khosoih a ham long tah a lu dongkah lupong te dul boel saeh lamtah a himbai te phen boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Aka duek hinglu boeih taengah khaw cet boel saeh. A napa ham neh a manu ham khaw poeih uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Rhokso lamkah khaw nong boel saeh. Anih soah a Pathen kah koelhnah situi rhuisam a om coeng dongah a Pathen kah rhokso te poeih boel saeh. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","A yuu khaw a cuemnah neh lo saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Nuhmai, vama, pumyoi hlang rhong khaw lo boel saeh. A pilnam khuikah oila bueng te a yuu la lo saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Anih te BOEIPA kamah loh ka ciim coeng dongah a pilnam khuikah a tii a ngan long khaw poeih boel saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Te phoeiah BOEIPA loh Moses a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Aaron te voek lamtah a cadilcahma ham khaw, 'Na tii na ngan taengah rhip thui pah,’ ti nah. U khaw a pum dongah a lolhmaih a om atah a Pathen kah buh aka nawn ham ha moe boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","A pum dongah a lolh a maih aka om hlang boeih, mikdael neh aka khaem khaw, a sa aka vawt neh a sa aka hoei hlang khaw, ");
INSERT INTO hlt_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","A pum dongah kut tlawt, kho tlawt aka om hlang te khaw, ");
INSERT INTO hlt_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","tingkhun khaw, merheh khaw, mik haeh khaw, phaikawk neh vinhna khaw, til hi khaw ha mop boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Khosoih Aaron tiingan khuikah hlang khat khat te a pum dongah a lolh a maih atah BOEIPA kah hmaihlutnah nawn ham ha mop boel saeh. A Pathen kah buh te nawn ham ha mop boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","A Pathen kah buh tah a cim uet ah cim tih aka cim van loh ca saeh. ");
INSERT INTO hlt_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Te dongah a pum dongah a lolh a maih aka om loh hniyan khuila kun boel saeh lamtah hmueihtuk taengla mop boel saeh. Te daengah ni ka rhokso te a poeih pawt eh. Amih te BOEIPA kamah long ni ka ciim,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Te dongah Moses loh Aaron neh anih koca rhoek taengah, Israel ca boeih taengah a thui pah. ");
INSERT INTO hlt_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Aaron neh anih koca rhoek taengah thui pah. Israel ca kah buhcim te hai pa uh saeh. Te daengah ni kai ham a ciim uh vanbangla ka ming cim he a poeih uh pawt eh. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Na cadilcahma ham khaw thui pah. Israel ca rhoek tah BOEIPA ham a ciim uh coeng dongah buhcim te na tii na ngan khat khat khui lamkah hlang khat khat long ni a pum dongkah a ti a hnai neh a nawn atah tekah hlanghing te ka mikhmuh lamkah khoe uh saeh. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Aaron tiingan khuikah hlang khat khat te pahuk tih a hnai atah a caihcil hlanhil buhcim te ca boel saeh. Te phoeiah rhalawt hinglu khat khat aka ben neh yangtui aka coe hlang khaw, ");
INSERT INTO hlt_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Rhulcai khat khat te a ben tih amah aka poeih uh hlang te khaw, A ti a hnai khat khat dongah amah aka poeih uh hlang te khaw, ");
INSERT INTO hlt_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","te te aka ben hinglu te khaw kholaeh duela poeih uh. Te dongah a pum te tui neh a silh pawt atah buhcim te ca boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Tedae khomik a tlak phoeiah atah koep caihcil bitni. Te vaengah buhcim dongkah amah buh te koep ca saeh. ");
INSERT INTO hlt_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Maehrhok neh saha sa a caak nen te poeih uh boel saeh. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Ka kueknah te a ngaithuen uh daengah ni tholh loh a poeih tih aka duek ham long khaw amah tholh te a phueih pawt eh. Kai tah amih aka ciim BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Kholong hlang khat khat long khaw buhcim te ca boel saeh. Khosoih kah impah neh kutloh long khaw buhcim te ca boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Tedae khosoih loh a tangka, hnopai neh a lai hlanghing long tah ca mai saeh. Amah im kah cahlah long khaw anih kah buh te ca saeh. ");
INSERT INTO hlt_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Khosoih canu khaw kholong hlang taengla a om coeng atah khocang neh buhcim te ca boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Tedae khosoih canu nuhmai la om mai tih tiingan om mueh la a hlak uh atah a napa im la mael saeh lamtah a napa kah buh te a camoe vaengkah bangla ca saeh. Tedae kholong boeih long tah ca boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Hlang loh buhcim te tohtamaeh la a caak atah panga neh thap pah saeh lamtah buhcim te khosoih taengah pae saeh. ");
INSERT INTO hlt_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Te dongah BOEIPA taengah Israel ca rhoek kah a tloeng buhcim te poeih uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Amih te BOEIPA kamah loh ka ciim coeng dongah amih kah buhcim aka ca tah amamih kathaesainah lai te amamih loh phuei saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Te phoeiah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Aaron neh anih koca rhoek khaw Israel ca rhoek boeih te khaw voek lamtah thui pah. Israel imkhui kah hlang boeih khaw, Israel taengkah yinlai long khaw, a olcaeng cungkuem dongah amah kah nawnnah a nawn ham khaw, a kothoh cungkuem ham akhaw, ");
INSERT INTO hlt_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","nangmih taengah kolonah ham saelhung khuikah khaw, tu khuikah khaw mae khuikah khaw, a tal a cuemthuek te tah hmueihhlutnah ham BOEIPA taengah nawn uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","A pum dongah khat khat te a lolh a maih atah khuen boeh. Nang ham kolonah khaw om hae mahpawh. ");
INSERT INTO hlt_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Hlang loh olcaeng soep sak ham BOEIPA taengah rhoepnah hmueih a nawn atah kothoh bangla kolonah ham saelhung khaw boiva khaw a cuemthuek la om saeh. A pum dongah a lolh a maih khat khat khaw om boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Mikdael khaw, aka paep khaw, vitvawt khaw, aka hnai khaw, phaikawk khaw, vinhna khaw BOEIPA taengah nawn boel saeh. BOEIPA taengkah hmueihtuk dongah hmaihlutnah ham khaw te khuikah te tloeng boeh. ");
INSERT INTO hlt_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Tedae kothoh ham tah vaito mai khaw tu mai khaw sahoei neh vitvawt lamkhaw na nawn suidae olcaeng ham tah doe mahpawh. ");
INSERT INTO hlt_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Te dongah a neet tangtae, a phop tangtae, vitvawt, aka moeng tangtae te BOEIPA taengah nawn uh boeh. Na khohmuen ah khaw saii uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Kholong ca kut lamkah te khaw na Pathen kah buh la nawn boeh. Amih sokah a lolh a maih khat khat loh amih rhoek te a poeih thai dongah nangmih ham a kolo mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Te phoeiah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Vaito khaw, tu khaw, maae khaw, a thang atah a manu taengah hnin rhih om dae saeh. Tedae a hnin rhet lamkah tah BOEIPA taengah nawnnah hmaihlutnah la thuem pawn ni. ");
INSERT INTO hlt_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Tedae vaito khaw, tu khaw, a ca neh khohnin pakhat dongah hmaih ngawn boeh. ");
INSERT INTO hlt_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","BOEIPA taengah uemonah hmueih na nawn uh vaengah namamih taengah kolonah la nawn uh. ");
INSERT INTO hlt_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Khohnin pakhat dongah hlawp ca uh lamtah mincang duela paih uh boeh. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Te dongah ka olpaek tuem uh lamtah vai uh. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Israel ca rhoek taeng ah ka ciim vanbangla ka ming cim te poeih uh boeh. Kai tah nangmih aka ciim BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Nangmih kah Pathen la om ham ni nangmih te Egypt kho lamkah kan doek. Kai tah BOEIPA ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Israel ca rhoek te voek lamtah thui pah. BOEIPA kah khoning te hoe uh lamtah ka khoning vaengah a cim tingtunnah te khueh uh. ");
INSERT INTO hlt_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Hnin rhuk khuiah bi saii uh saeh. Hnin rhih dongah koiyaeh Sabbath la om saeh lamtah a cim tingtunnah om saeh. BOEIPA kah Sabbath vaengah na tolrhum tom ah bitat khat khaw saii uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Amah khoning vaengah tahae kah BOEIPA khotue he doek uh lamtah a cim tingtunnah khueh uh. ");
INSERT INTO hlt_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Hla lamhma dongkah hlasae hnin hlai li hlaem ah BOEIPA kah Yoom om ni. ");
INSERT INTO hlt_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Hlasae hnin hlai nga dongah BOEIPA kah vaidamding khotue om saeh lamtah hnin rhih khuiah vaidamding ca uh. ");
INSERT INTO hlt_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","A cuek khohnin dongah nangmih ham a cim tingtunnah om saeh lamtah thohtatnah bitat boeih tah saii boeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Hnin rhih khuiah BOEIPA taengla hmaihlutnah nawn uh. A hnin rhih dongah a cim tingtunnah om saeh lamtah thohtatnah bitat boeih te tah saii uh boeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Te phoeiah Moses te BOEIPA loh a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Israel ca rhoek te voek lamtah thui pah. Kai loh nangmih taengah kam paek khohmuen la na kun uh tih cang na ah uh atah na cangah cuek kah canghmuei te khosoih taengla thak uh. ");
INSERT INTO hlt_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Canghmuei te BOEIPA mikhmuh ah thueng saeh. Nangmih taengah kolonah ham khosoih loh Sabbath vuen ah thueng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Canghmuei na thueng uh hnin vaengah tu kum khat ca te BOEIPA taengah hmueihhlutnah ham a cuemthuek la nawn uh. ");
INSERT INTO hlt_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Situi neh a thoek khocang vaidam doh nit te BOEIPA ham hmaihlutnah hmuehmuei botui la om saeh. Tuisi ham misurtui bunang pali khueh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Na Pathen kah nawnnah a khohnin tuung na pha hlan atah vaidam khaw, vairhum khaw, cangthai khaw ca uh boeh. Na tolrhum boeih kah na cadilcahma ham kumhal khosing la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Thueng hmueih la canghuei na khuen tue phoeikah Sabbath vuen lamkah te tae lamtah Sabbath voeirhih a cum due om sak. ");
INSERT INTO hlt_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Sabbath voei rhih na tae vuen kah hnin sawmnga vaengah khocang cangthai te BOEIPA taengla nawn uh. ");
INSERT INTO hlt_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Na tolrhum lamkah thueng hmueih vaidam hluem nit, tolrhu neh a thong vaidam doh nit te BOEIPA ham thaihcuek la khuen uh. ");
INSERT INTO hlt_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Te vaengah vaidam hluem rhih, tu kum khat aka lo ca a cuemthuek neh, saelhung khuikah vaito ca pakhat, tutal panit te khuen lamtah BOEIPA taengkah hmueihhlutnah ham om saeh. Amih kah khocang neh tuisi te khaw BOEIPA ham hmuehmuei botui hmaihlutnah la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Te phoeiah boirhaem ham maae tal pakhat neh rhoepnah hmueih ham tu kum khat ca pumnit te nawn uh. ");
INSERT INTO hlt_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Thaihcuek buh te thueng hmueih la BOEIPA mikhmuh ah khosoih loh thueng saeh lamtah BOEIPA taengkah a cim tuca panit te tah khosoih ham la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Tekah khohnin tuung dongah a cim tingtunnah om ham hoe uh lamtah namahmih kah thohtatnah bitat boeih te tah saii uh boeh. He tah Na tolrhum boeih kah na cadilcahma ham kumhal khosing la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Na khohmuen kah cang na ah uh vaengah khaw na khohmuen te hmangrhong kaep due khap uh boeh. Cang na ah uh vaengah khaw na cang mo te boeih yoep uh boeh. Mangdaeng neh yinlai ham hnoo pauh. Kai tah nangmih kah Pathen BOEIPA ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Israel ca rhoek te voek lamtah thui pah. Hla hlarhih khuikah lamhmacuek hla te nangmih ham a cim tingtunnah tamlung poekkoepnah koiyaeh om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Te vaengah thohtatnah bitat boeih tah saii uh boel lamtah BOEIPA taengah hmaihlutnah nawn ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Moses te BOEIPA loh a voek. ");
INSERT INTO hlt_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“A hla rha khuikah a hla rhih dongah khaw nangmih ham a cim tingtunnah neh dawthnah hnin te om saeh. Te vaengah na hinglu te phaep uh lamtah BOEIPA taengah hmaihlutnah nawn uh. ");
INSERT INTO hlt_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Na Pathen BOEIPA kah mikhmuh ah nangmih kah te dawth ham dawthnah khohnin la a om dongah tekah khohnin tuung ah bitat pakhat khaw saii uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Tekah khohnin tuung dongah a pum aka phaep pawt hlanghing boeih tah a pilnam lamkah khoe van saeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Tekah khohnin tuung dongah bitat khat khat te hlanghing khat khat loh saii mai ngawn saeh. Tedae tekah hlanghing te a pilnam khui lamkah ka milh sak ni. ");
INSERT INTO hlt_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Bitat pakhat khaw na saii uh pawt ham te na tolrhum boeih kah na cadilcahma rhoek ham kumhal khosing la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Nangmih kah koiyaeh Sabbath ah te na hinglu phaep uh. Hla ko dongkah hlaem ah tah hlaem lamloh hlaem hil na Sabbath yaeh uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Israel ca rhoek te voek lamtah thui pah. Hla rhih dongkah hnin hlai nga dongah pohlip khotue te BOEIPA ham hnin rhih khuiah om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Khohnin lamhmacuek, a cim tingtunnah vaengah thohtatnah bitat boeih tah saii uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Hnin rhih khuiah BOEIPA taengah hmaihlutnah nawn uh. Hnin rhet te nangmih kah a cim tingtunnah la om saeh. Pahong vaengah khaw BOEIPA taengah hmaihlutnah nawn uh lamtah thohtatnah bitat boeih te saii uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","BOEIPA kah khoning rhoek te a cim tingtunnah la hoe uh. Tekah khohnin vaengah a khohnin loh a kuek te tah hmueihhlutnah khaw, khocang hmueih neh tuisi khaw BOEIPA taengah hmaihlutnah la khuen uh. ");
INSERT INTO hlt_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","BOEIPA kah Sabbath khaw amah vaengah, nangmih kah kutdoe khaw amah vaengah, na olcaeng boeih khaw amah vaengah, na kothoh boeih khaw amah vaengah BOEIPA taengla pae uh. ");
INSERT INTO hlt_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Hla rhih phoeikah hnin hlai nga dongah khohmuen kah a vuei a thaih te khoem uh bal lamtah BOEIPA kah khotue te hnin rhih lam uh. A cuek khohnin dongah koiyaeh om vetih a rhet khohnin dongah khaw koiyaeh om bal ni. ");
INSERT INTO hlt_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","A cuek khohnin dongah rhuepomnah thing thaih neh rhophoe bom, thing bu thing hlaeng, soklong tuirhi te namamih ham lo uh. Na Pathen BOEIPA mikhmuh ah hnin rhih khui na kohoe sak uh. ");
INSERT INTO hlt_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Kum khat ah hnin rhih tah BOEIPA ham khotue na lam uh ham te na cadilcahma taengah kumhal khosing la omsaeh lamtah hla rhih dongah lam uh. ");
INSERT INTO hlt_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Dungtlungim ah hnin rhih khosa uh. Israel khuikah mupoe boeih longtah dungtlungim khuiah khosa saeh. ");
INSERT INTO hlt_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Te daengah ni kamah loh Egypt kho lamkah Israel ca rhoek ka mawt vaengah dungtlungim ah ka om sak te na cadilcahma loh a ming eh. Kai tah na Pathen BOEIPA ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Te dongah BOEIPA kah khoning te Israel ca rhoek ham Moses loh a thui pah. ");
INSERT INTO hlt_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Moses te BOEIPA loh a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Israel ca rhoek te uen lah. Te vaengah olive situi cil a sui te khuen saeh hmaiim dongah hmaivang te phat vang saeh. ");
INSERT INTO hlt_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Tekah hmaiim te tingtunnah dap khuikah olphong hniyan kah a voel ah Aaron loh ten saeh lamtah BOEIPA mikhmuh ah khoyin lamkah mincang duela pai yoeyah saeh. Te te na cadilcahma rhoek taengah kumhal khosingla om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Hmaiim rhoek te BOEIPA mikhmuh kah a cim hmaitung soah ten yoeyah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Vaidam te khaw lo lamtah vaidam laep parha hlai nit la kaeng saeh. Vaidam doh nit tah vaidam laep pakhat la rhip om saeh lamtah, ");
INSERT INTO hlt_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","BOEIPA mikhmuh kah caboei cim soah than at dongah parhuk neh than nit la tloeng. ");
INSERT INTO hlt_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Tekah a than dongah hmueihtui cil te khueh bal lamtah vaidam te BOEIPA taengah kamhoeinah hmaihlutnah la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Kumhal paipi vanbangla Israel ca rhoek taeng lamkah vaidam te Sabbath hnin, Sabbath hnin ah tah BOEIPA mikhmuh ah tloeng yoeyah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Tekah vaidam te a Aaron neh anih koca rhoek kah a hut la a om dongah aka cim te a cim vanbangla hmuen cim ah dawk ca uh saeh. BOEIPA kah hmaihlutnah khuiah tekah vaidam tah Aaron ham kumhal buhvae la om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Te vaengah Israelhoel nu kah a capa neh Egypt hlang kah a capa te Isreal ca rhoek taengah cet tih rhaehhmuen khuikah Israelhoel nu kah a capa neh Israel hlang te a hnueih uh rhoi. ");
INSERT INTO hlt_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Te vaengah Israelhoel nu kah a capa loh ming a sal a pham tih a tap. Te dongah anih te Moses taengla a thak uh hatah a manu ming tah Dan koca khuikah Dibri nu Shelomith la pawk. ");
INSERT INTO hlt_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Te dongah a lungbuei loh BOEIPA olpaek te a puk duela anih te thongim ah a khoh uh. ");
INSERT INTO hlt_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Thae aka phoei te rhaehhmuen vongvoel la khuen uh. Aka ya boeih loh anih lu soah a kut tloeng uh saeh. Anih te rhaengpuei boeih loh dae uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Isreal ca rhoek te khaw voek lamtah thui pah. Hlang khat khat long ni a Pathen te a tap atah a tholh te amah loh yook van saeh. ");
INSERT INTO hlt_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Te dongah BOEIPA ming aka toeh tah duek rhoe duek saeh. rhaengpuei boeih loh anih te dae rhoe dae uh. Yinlai khaw tolrhum mupoe khawBOEIPAming a toeh atah duek saeh. ");
INSERT INTO hlt_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Hlang kah hinglu khat khat aka ngawn hlang khaw duek rhoe duek saeh. ");
INSERT INTO hlt_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Rhamsa kah hinglu aka ngawn long khaw hinglu te hinglu neh thuung saeh. ");
INSERT INTO hlt_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Hlang loh a imben te nganboh a paek atah a saii vanbangla amah taengah saii pah van saeh. ");
INSERT INTO hlt_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Rhuh tlawt ham rhuh tlawt, mik ham mik, no ham no van, hlang soah nganboh a paek vanbangla amah te pae van saeh. ");
INSERT INTO hlt_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Rhamsa aka ngawn khaw a yueng thuung sak lamtah hlang aka ngawn tah duek saeh. ");
INSERT INTO hlt_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Kai tah nangmih kah BOEIPA Pathen la ka om dongah nangmih taengkah laitloeknah he pakhat la om saeh lamtah yinlai ham khaw, tolrhum mupoe ham khaw, pakhat la om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Te dongah Israel ca rhoek te Moses loh a voek. Te phoeiah BOEIPA loh Moses a uen vanbangla Israel ca rhoek loh a saii uh dongah thae aka phoei te rhaehhmuen vongvoel la a khuen uh tih lungto neh a dae uh. ");
INSERT INTO hlt_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Sinai tlang ah BOEIPA loh Moses a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Israel ca rhoek te voek lamtah thui pah. Kai loh nangmih taengah kam paek khohmuen te na kun thil uh vaengah khohmuen loh BOEIPA ham Sabbath te yaeh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Na khohmuen te kum rhuk tawn lamtah na misur khaw kum rhuk na hloe khuiah a thaih te bit. ");
INSERT INTO hlt_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Tedae a kum rhih dongah tah khohmuen ham koiyaeh Sabbath la om saeh. BOEIPA kah Sabbath ah na khohmuen te tawn boeh. Na misur khaw hloe boeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Na cang pong te at boeh. Na khohai misur khaw bit boeh. Khohmuen kah koiyaeh kum la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Na Khohmuen kah Sabbath vaengah tah cakok te namah ham neh na salpa ham khaw, na salnu ham khaw, na kutloh ham khaw, na taengah aka bakuep na lampah ham khaw om bitni. ");
INSERT INTO hlt_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Na khohmuen kah na rhamsa neh mulhing loh a caak ham khaw a thaih boeih om ni. ");
INSERT INTO hlt_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Te dongah kum rhih kum rhih kah Sabbath voei rhih tae lamtah voei rhih a cup phoeikah kum sawmli pako vaengah Sabbath kum la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Hla rhih dongkah hlasae hnin rha vaengah tamlung neh tuki na ueng ni. Tholh dawthnah khohnin ah khaw na khohmuen boeih ah tuki na ueng ni. ");
INSERT INTO hlt_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Kum sawmnga kum te ciim uh lamtah kho khuikah khosa rhoek boeih ham sayalhnah hoe uh. Te te nangmih ham jubilee la om saeh. Hlang kah a khohut te mael lamtah hlang boeih te a huiko taengla mael uh. ");
INSERT INTO hlt_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","A sawmnga kum te nangmih ham jubilee kum la om saeh lamtah, lo tawn uh boeh. Te dongah amah aka pong khaw at uh boeh. Khohai kah khaw bit uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Tekah jubilee tah nangmih ham a cim la a om dongah khohmuen kah a thaih te na caak uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Tekah jubilee kum vaengah hlang kah a khohut te mael uh. ");
INSERT INTO hlt_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Hnoyoih te na imben taengah na yoih uh tih, na imben kut lamkah na lai atah manuca te khat neh khat vuelvaek uh thae boeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Jubilee phoeikah kum na tae soah na imben kah khohmuen te na lai uh neh a vuei a thaih kum na tae soah yoi saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","A cangvuei kah a tarhing te namah taengah han yoih coeng dongah a kum loh amah tarhing ah yet tih a lainah loh rhoeng cakhaw kum kah a tarhing te hnah pah lamtah a lainah te hnah pah. ");
INSERT INTO hlt_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Hlang pakhat long he a imben te vuelvaek boel saeh. Tedae kai tah nangmih kah BOEIPA Pathen la ka om dongah na Pathen te rhih lah. ");
INSERT INTO hlt_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Te dongah ka khosing te vai uh lamtah ka laitloeknah te ngaithuen uh. Te te na saii uh daengah ni diklai ah ngaikhuek la kho na sak uh eh. ");
INSERT INTO hlt_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Diklai long khaw a thaih a paek vetih kodam la na caak ni. A khuiah khaw ngaikhuek la kho na sak uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Tedae, “Kum rhih dongah lo ka tawn uh pawt tih ka cangvuei khaw ka khoem uh pawt koinih balae ka caak uh eh,” na ti uh oeh cakhaw, ");
INSERT INTO hlt_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","kai kah yoethennah he kum rhuk khuiah nangmih ham kang uen vetih kum thum ham a vuei a thaih om bitni. ");
INSERT INTO hlt_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Kum rhet dongah tawn uh lamtah cang rhuem te kum ko hil ca uh. Cangah a pha duela cang rhuem te ca uh. ");
INSERT INTO hlt_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Nangmih tah kai taengah yinlai neh n lampah uh dae khohmuen tah kamah taengah a ti ham dongah khohmuen te khaw yoi boeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Te dongah na khohut khohmuen boeih dongah khohmuen ham tlannah khueh uh. ");
INSERT INTO hlt_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Na manuca te daeng tih a khohut te a yoih atah khohmuen aka tlan ham anih neh aka yoei uh loh ham paan saeh lamtah a manuca kah hnoyoih te koep tlan saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Aka tlan ham hlang ni a om pawt tih khohmuen a tlannah rhoeh te a kut loh pha pawh, a dang pawt bal atah, ");
INSERT INTO hlt_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","a hnoyoih kah kum te tae saeh lamtah a hoei te koe a yoi thil hlang taengah thuung saeh. Te phoeiah amah khohut te lat saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Tedae anih taengah a mael rhoeh te a kut loh a dang pawt atah a hnoyoih te aka lai kut dongah jubilee kum duela om dae saeh. Tedae jubilee vaengah hlah pah saeh lamtah amah khohut taengla mael saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Hlang loh tolrhum khopuei vongtung khuikah im te a yoih mai ni. Tedae a yoihnah kum a thok hil a tlannah om saeh lamtah a tlannah tue te khueh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Kum loh cup tih a thok duela a tlan pawt atah khopuei vongtung khuikah im te im aka lai neh anih kah cadilcahma taengah a ti la pai saeh lamtah jubilee vaengah khaw hlah boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Vongup kah im mai cakhaw a kaepvai ah vongtung a om pawt atah khohmuen lohma bangla poek uh saeh. Anih ham tlannah om saeh lamtah jubilee vaengah hlah pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Levi khopuei kah khopuei im tah amih kah khohut ni. Levi ham tah kumhal ah tlannah om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Israel ca rhoek khuiah Levi rhoek long tah a khopuei neh a im bueng he amih kah a khohut la a khueh uh dongah Levi rhoek long tah tlan saeh. A khohut khopuei kah im a yoih tangtae khaw jubilee vaengah koep lat saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Tedae amih Levi khopuei kah khohmuen khocaak te tah amamih kah kumhal a khohut la a om coeng dongah yoi uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Na manuca te daeng tih nang taengah a kut a hmawn oeh atah anih te yinlai neh lampah banghui lam khaw talong lamtah namah taengah hing sak. ");
INSERT INTO hlt_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Anih taeng lamkah a casai neh a pueh a kan khaw lo boeh. Na Pathen te na rhih daengah ni na manuca loh nang taengah a hing eh. ");
INSERT INTO hlt_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Anih te a casai la tangka pu boeh. Na cang khaw a pueh a kan la yoi boeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Kai tah nangmih taengah Pathen la om ham neh nang taengah Kanaan khohmuen paek ham Egypt khohmuen lamkah nangmih aka doek na Pathen BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Na taengkah na manuca te daeng tih nang taengla amah a yoih uh atah sal kah thotatnah bangla anih te thohtat sak boeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Namah taengah kutloh neh lampah bangla om saeh lamtah Jubilee kum hil nang taengah thotat saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Te phoeiah amah neh a ca rhoek te nang taeng lamkah nong saeh lamtah a huiko taengla mael saeh. Te vaengah a napa kah khohut la mael saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Kamah kah sal la om ham amih te Egypt kho lamkah ka loh. Amih te sal yoih la yoi uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Anih te mangkhak la taemrhai boeh. Na Pathen te rhih lah. ");
INSERT INTO hlt_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Na kaepvai namtom taeng lamkah sal, salnu na lai te tah namah taengah namah kah salnu salpa la om uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Nangmih loh na lai uh tih nangmih taengah aka bakuep lampah ca rhoek neh nangmih taengkah a huiko lamloh na kho kah nangmih lakliah a cun uh te khaw khohut bangla nangmih taengah om uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Te dongah amih te namah phoeikah na ca rhoek taengah kumhal kah a pang khohut la pang sak lamtah thohtat sak. Tedae na manuca Israel ca rhoek khat khat neh anih kah a manuca soah mangkhak la taemrhai boeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Nang taengkah yinlai neh lampah kut long pataeng a kae vaengah a taengkah na manuca tah daeng tih na taengkah yinlai lampah taengah khaw, yinlai huiko kah a mii taengah khaw, amah a yoi uh khaming, ");
INSERT INTO hlt_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","a yoih uh phoeiah khaw a manuca khui lamkah khat khat long ni tlannah a khueh atah tlan saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","A nupu long khaw, a nupu capa long khaw tlan saeh. A pumsa saa lamkah, amah huiko long khaw tlan saeh. A kut loh a na mak atah amah khaw tlan uh saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Anih a yoih lamkah a lai kum te jubilee kum duela tae pah saeh. Te phoeiah a kum tarhing dongkah a khohnin vanbangla a yoih tangka te om saeh lamtah anih te kutloh bangla om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Kum muep a ngaih pueng atah a yet tarhing la a lainah tangka dong lamkah te tlannah la pae saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Tedae jubilee kum duela kum cavilcavel ni a ngaih coeng atah a kum tarhing te poek pah saeh lamtah a tlannah te pae van saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Kum at phoeiah kum at kutloh bangla om saeh. Anih te na mikhmuh ah mangkhak la taemrhai boeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Te tlam pataeng a tlan thai pawt atah Jubilee kum vaengah anih te a ca rhoek neh rhenten hlah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Israel ca rhoek he kamah taengah ka sal rhoek kah sal la om ham ni Egypt kho lamkah ka loh. Kai tah nangmih kah BOEIPA Pathen ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Mueirhol khaw, mueithuk khaw namamih ham saii uh boeh. Kaam khaw namamih ham ling uh boeh. Kai tah na BOEIPA Pathen la ka om dongah a hmaiah bakop thil ham lung thuk khaw na kho ah khueh uh boeh. ");
INSERT INTO hlt_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ka Sabbath te tuem uh lamtah ka rhokso te rhih uh. Kai tah BOEIPA ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Ka khosing te na vai uh atah ka olpaek khaw ngaithuen uh lamtah saii uh. ");
INSERT INTO hlt_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Te daengah ni amah tuetang vaengah nangmih ham khonal kan tueih vetih diklai loh a cangpai m'paek phoeiah khohmuen kah thingkung long khaw a thaih a thaih eh. ");
INSERT INTO hlt_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Te vaengah na cangtil loh misurbit due a pha vetih na misurbit loh na rhoktuh tue te a pha ni. Na buh khaw kodam la na caak uh vetih na khohmuen ah ngaikhuek la kho na sak uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Khohmuen te rhoepnah ka paek vetih lakueng om mueh la na yalh uh ni. Khohmuen lamkah boethae mulhing khaw ka kangkuen sak vetih na khohmuen te cunghang loh khawkkhek mahpawh. ");
INSERT INTO hlt_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Na thunkha pataeng na hloem vaengah na mikhmuh kah cunghang dongah cungku uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Te vaengah nangmih khuikah panga loh yakhat te a hloem uh vetih yakhat loh thawngrha khaw a hloem ni. Na thunkha rhoek khaw na mikhmuh kah cunghang dongah cungku uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nangmih taengla ka mael vetih kam pungtai sak phoeiah kan rhoeng sak ni. Ka paipi te khaw nangmih taengah ka thoh ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Cang rhuem aka ip te na caak uh vetih cang thai ham te cang rhuem na hlah uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Nangmih lakli ah ka dap ka khueh vetih nangmih te ka hinglu loh tuei voel mahpawh. ");
INSERT INTO hlt_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nangmih lakli ah ka pongpa vetih nangmih kah Pathen la ka om vaengah nangmih khaw ka pilnam la na om uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Egypt kho lamkah nangmih aka doek te khaw na BOEIPA Pathen kamah ni. Amih sal la na om khui lamkah na hnamkun hnokohcung khaw ka khaem tih nangmih te a dueng la kan caeh sak. ");
INSERT INTO hlt_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Tedae ka olna ngai uh pawt tih hekah olpaek boeih he na vai uh pawt atah, ");
INSERT INTO hlt_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ka khosing te na sawtsit uh tih na hinglu loh ka laitloeknah te a tuei dongah ka olpaek boeih te vai pawt ham ka paipi te na phae uh atah, ");
INSERT INTO hlt_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","kai loh nangmih ham hekah he ka saii van ni. Te vaengah kositloh neh mik hum satloh te nangmih soah lungmitnah la kan hlak vetih na hinglu a mueipuel ni. Na cangti khaw a poeyoek la na tuh vetih na thunkha long ni a caak eh. ");
INSERT INTO hlt_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nangmih taengah ka hmai ka khueh vetih na thunkha rhoek kah mikhmuh ah na paloe uh ni. Na lunguet rhoek loh nangmih te n'taemrhai uh vetih nangmih n'hloem pawt cakhaw na rhaelrham uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","He rhoek phoeiah khaw ka ol te na yaak uh pawt atah namamih kah tholh dongah voeirhih duela nangmih te toel ham ka khoep van ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nangmih kah hoemdamnah sarhi te ka khaem vetih na vaan ke thi bangla, na diklai he khaw rhohum bangla ka khueh ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Na khohmuen loh a cangpai m'pae pawt dongah na thadueng khaw a poeyoek la boeih vetih khohmuen kah thingkung khaw a thaih thaii mahpawh. ");
INSERT INTO hlt_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Kai taengah boekoekthingka la na om uh tih ka ol ngai ham na huem uh pawt van atah na tholh tarhing ah hmasoe parhih duela nangmih soah kan khoep sak van ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Kohong mulhing te nang taengla kan tueih vetih namamih khaw cakol la n'khueh uh ni. Na rhamsa te a thup vaengah voehvoeh na muei uh vetih na longpuei khaw sut pong ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","He phoeiah pataeng kai taengah na toel uh pawt tih kai soah boekoekthingka la na pongpa uh mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Te vaengah kai ngawn tah nangmih taengah boekoekthingka la ka lo vetih namamih kah tholhnah dongah voeirhih duela kang ngawn van ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Phulohnah paipi neh phu aka lo cunghang te nangmih soah kang khuen ni. Na khopuei ah kan coi phoeiah nangmih lakli ah duektahaw kan tueih vetih thunkha kut dongah kam voeih ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Nangmih kah thahuelnah buh te kai loh ka khah vaengah na buh te huta parha loh tapkhuel pakhat dongah a thong uh ni. Te vaengah na buh te amah tarhing neh ham phom uh vetih na caak uh suidae na hah uh mahpawh. ");
INSERT INTO hlt_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","He phoeiah pataeng kai taengah na khinngai uh pawt tih kai soah boekoekthingka la na pongpa uh atah, ");
INSERT INTO hlt_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","nangmih taengah kosi neh boekoekthingka la ka lo van vetih nangmih te namamih kah tholh dongah voeirhih duela kan toel ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Te vaengah na capa rhoek kah a saa te na caak uh vetih na canu rhoek kah a saa khaw na caak uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Nangmih kah hmuensang te ka mit sak vetih na bunglawn khaw ka vung ni. Nangmih kah mueirhol thingkoh soah na rhok te ka hmoek vetih nangmih te ka hinglu loh a tuei ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Na khopuei te imrhong la ka khueh vetih na rhokso khaw ka pong sak ni. Nangmih kah hmuehmuei botui khaw ka him mahpawh. ");
INSERT INTO hlt_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Khohmuen te khaw ka pong sak vetih a khuikah kho aka sa na thunkha rhoek te pong uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nangmih te namtom rhoek taengah kan thaek kan yak phoeiah na hnukah cunghang neh kan thun ni. Te vaengah na khohmuen loh khopong la om vetih na khopuei rhoek khaw imrhong la poeh uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Khohmuen loh a Sabbath te a pong tue khuiah uum saeh. Nangmih te na thunkha khohmuen ah na om uh vaengah khohmuen khaw kangkuen saeh lamtah a Sabbath te uum saeh. ");
INSERT INTO hlt_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","A khuiah kho na sak uh vaengkah na Sabbath ah a duem pawt yueng te a pong tue khuiah tah duem saeh. ");
INSERT INTO hlt_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Nangmih khuikah aka sueng rhoek pataeng a thunkha rhoek kah khohmuen ah a thinko te rhiyawpnah ka paek ni. Amih te hloem pawt cakhaw hawn a yawn ol loh a hloem vaengah cunghang kah a hloem bangla yonglong ah rhaelrham uh vetih cungku uh ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","N'hloem uh pawt cakhaw cunghang ha dongkah bangla hlang long he a manuca pataeng a paloe thil vetih na thunkha rhoek hmai ah na oelnah om mahpawh. ");
INSERT INTO hlt_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Namtom taengah na milh uh vetih na thunkha rhoek kah khohmuen loh nangmih te n'yoop ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Nangmih khui lamkah aka sueng rhoek te na thunkha rhoek kah khohmuen ah amamih kathaesainah dongah muei uh vetih, a napa rhoek kathaesainah dongah khaw amih te muei ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","A boekoeknah la kai taengah boe a koek uh tih kai soah boekoekthingka la a caeh uh vaengah amamih kathaesainah neh a napa rhoek kathaesainah te a omtoem uh mai ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Kai khaw amih taengah boekoekthingka la ka cet vetih amih te thunkha rhoek kah khohmuen la ka thak ni. Tedae amih kah thinko pumdul loh a kunyun daengah ni amamih kah thaesainah khaw a moeithen eh. ");
INSERT INTO hlt_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Jakob taengkah ka paipi khaw, Isaak taengkah ka paipi khaw ka thoelh ni. Abraham taengkah ka paipi khaw ka thoelh vetih khohmuen te ka ngaidam ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Amih om mueh la a pong sut vaengah amih kah a hnoo khohmuen loh amah kah Sabbath te a uum ni. Ka laitloeknah a hnawt uh tih a hinglu loh ka khosing a tuei dongah amih kathaesainah a thung ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Kai tah amih kah BOEIPA Pathen la ka om dongah amih he a thunkha rhoek kah khohmuen ah a om vaengah pataeng amih taengkah ka paipi phae ham neh amih thup ham aih tah amih te ka hnawt pawt vetih ka tuei mahpawh. ");
INSERT INTO hlt_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Kai loh amih taengah BOEIPA Pathen la om ham te tah namtom rhoek kah mikhmuh ah Egypt kho lamkah ka khuen patuel rhoek kah paipi te amih ham ka thoelh pueng ni. ");
INSERT INTO hlt_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Hekah oltlueh neh laitloeknah neh olkhueng rhoek he Moses kut neh Sinai tlang ah BOEIPA loh amah laklo neh Israel ca rhoek laklo ah a khueh. ");
INSERT INTO hlt_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","BOEPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Israel ca rhoek te voek lamtah thui pah. Hlang khat khat loh na hinglu phu neh BOEIPA taengah olcaeng a rhaisang sak atah, ");
INSERT INTO hlt_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","na phu te tongpa kum kul ca lamkah kum sawmrhuk ca rhoek te tah hmuencim kah shekel ah tangka shekel sawmnga te na phu la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Tedae anih te huta la a om atah shekel sawmthum na phu la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Te vaengah kum nga ca lamkah kum kul ca te tah tongpa ham shekel pakul neh huta ham shekel parha te na phu la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Tedae hla khat ca lamkah kum nga ca te tah tongpa ham tangka shekel panga te na phu la om saeh lamtah huta ham tangka shekel pathum te na phu la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Kum sawmrhuk ca lamkah a so te tah tongpa te shekel hlai nga te, na phu la om saeh lamtah huta ham shekel parha om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Na phu te a daeng bal oeh atah amah te khaw khosoih kah mikhmuh ah pai saeh lamtah khosoih loh a phu tloek pah saeh. Aka caeng kut loh a na tarhing ah khosoih loh rhan pah saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Rhamsa te BOEIPA taengkah nawnnah ham a nawn uh bal atah BOEIPA taengah a paek boeih te tah a cimcaih la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","A thae te a then neh, a then te a thae neh thung khaw thung boel saeh, tho khaw tho boel saeh. Rhamsa te rhamsa neh a tho la a tho atah rhamsa aka om neh a hnothung te khaw a cimcaih la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Tedae rhalawt rhamsa boeih tah BOEIPA taengkah nawnnah ham khuen uh boel saeh. Tedae rhamsa te khosoih kah mikhmuh ah tloeng saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Te vaengah a thae a then khaw anih te khosoih loh a phu tloek saeh lamtah khosoih kah a tloek te na phu la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Tedae amah loh a tlan la a tlan atah na phu te panga neh thap van saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Hlang pakhat mai long khaw a im te BOEIPA ham a cim la a ciim coeng atah a thae a then khaw khosoih loh a phu tloek saeh lamtah khosoih kah a phu a tloek vanbangla a phu khaw om van saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Tedae a im a ciim tangtae te a tlan atah a phu te tangka a pueh panga neh koep thap saeh lamtah amah hut la koep om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Hlang pakhat mai loh khohmuen khui lamkah amah khohut te BOEIPA ham a ciim atah a cangti a cuk tarhing la a phu om saeh lamtah cangtun tii hma at cuk te tangka shekel sawmnga neh ting van saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Jubilee kum dongah a khohmuen te a ciim atah a phu te amah tarhing la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Tedae a khohmuen te jubilee poengah a ciim atah jubilee kum duela aka sueng te khosoih loh tae saeh lamtah a kum tarhing kah tangka vanbangla a phu te hnop van saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","A hoep mueh tangtae khohmuen te koep a tlan la a tlan atah khohmuen phu tangka te a pueh panga neh koep thap thil saeh lamtah amah hut la koep om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Tedae khohmuen te tlan pawt tih hlang taengla patoeng a yoih coeng atah khohmuen te koep tlan voel boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Jubilee a poeng vaengah khohmuen loh BOEIPA taengah a cim la a om pueng atah khohmuen bangla yaehtaboeihla aka om te tah khosoih kah khohut la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Amah kah khohut khohmuen pawt dae a kho lai te BOEIPA ham a ciim atah, ");
INSERT INTO hlt_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Jubilee kum a pha duela a phu yet te khosoih loh tae saeh lamtah BOEIPA ham a cimcaih sak khohnin van vaengah a phu te pae saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Jubilee kum vaengah tah khohmuen a lai vaengkah a kungmah taengah amah kah khohmuen khohut vanbangla bal saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Na phu boeih boeih hmuencim kah shekel neh tae la om vetih gerah pakul ah shekel pakhat la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Rhamsa khuikah a cacuek boeih he BOEIPA kah caming omthang la a om dongah vaito mai khaw tu mai khaw BOEIPA hut tangtae te tah hlang long he ciim boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Tedae rhalawt rhamsa mai khaw namah kah phu bangla a lat mai ni. Tedae te te a panga neh thap saeh. A tlan pawt daengah ni namah ka a phu bangla a yoih eh. ");
INSERT INTO hlt_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Tedae hlang loh a khueh khui boeih lamkah hlang khaw, rhamsa khaw, amah kah khohut khohmuen khaw BOEIPA ham a ha tangtae, yaehtaboeih la aka om khat khat te tah yoi boel saeh. BOEIPA ham aka cim tih a cim tangkik yaehtaboeih la aka om boeih te tah tlan boel saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Hlang pataeng yaehtaboeih la a ha boeih te tah lat boel saeh lamtah duek rhoe duek sak saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Khohmuen cangtii khaw, diklai thing thaih khaw parha pakhat boeih BOEIPA hut la om tih BOEIPA ham cimcaih bal. ");
INSERT INTO hlt_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Te dongah hlang khat khat mai loh amah kah parha pakhat te a tlan la a tlan atah amah kah panga neh thap thil saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Saelhung khaw, boiva khaw mancai hmuikah aka luem boeih kah parha pakhat boeih te BOEIPA kah a cim parha pakhat la om saeh. ");
INSERT INTO hlt_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","A thae a then khaw hnukdawn boel saeh lamtah thovael boel saeh. A tho la a tho atah aka om tangtae neh a hnothung te a cim la rhen om coeng tih tlan thai mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Tahae kah olpaek rhoek he Israel ca rhoek ham Sinai tlang ah BOEIPA loh Moses a uen. ");
INSERT INTO hlt_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Egypt kho lamloh a coe phoeikah a kum bae, a hla bae hnin khat vaengah, Sinai khosoek kah tingtunnah dap ah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Israel ca rhaengpuei boeih hlangmi te amah huiko neh, a napa imkhui ah tongpa boeih kah ming tarhing neh a hlangmi te lo laeh. ");
INSERT INTO hlt_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Kum kul ca lamloh a so, Israel khuikah caempuei la aka cet boeih te namah neh Aaron loh amah caempuei dong lamloh amih te cawh rhoi laeh. ");
INSERT INTO hlt_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Amah a napa imkhui kah a lu hlang te koca pakhat lamloh hlang pakhat tah nangmih rhoi taengah om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Te dongah he kah hlang ming aka om rhoek loh nangmih rhoi te m'pai puei saeh. Reuben ham Shedeur capa Elizur, ");
INSERT INTO hlt_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simeon ham te Zurishaddai capa Shelumiel, ");
INSERT INTO hlt_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Judah ah Amminadab capa Nahshon, ");
INSERT INTO hlt_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Issakhar ah Zuar capa Nethanel, ");
INSERT INTO hlt_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zebulun ah Helon capa Eliab, ");
INSERT INTO hlt_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Joseph koca ah Ephraim kah Ammihud capa Elishama neh Manasseh kah Pedahzur capa Gamaliel, ");
INSERT INTO hlt_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Benjamin ah Gideoni capa Abidan, ");
INSERT INTO hlt_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan ah Ammishaddai capa Ahiezer, ");
INSERT INTO hlt_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Asher ah Okran capa Pagiel, ");
INSERT INTO hlt_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gad ah Deuel capa Eliasaph, ");
INSERT INTO hlt_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Naphtali ah Enan capa Ahira Enan saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","He mingthang rhoek he rhaengpuei loh a napa rhoek koca kah khoboei neh Israel thawngkhat kah a lu la a khue uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Te phoeiah ming a phoei hlang rhoek te Moses neh Aaron loh a loh. ");
INSERT INTO hlt_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","A hla bae kah hnin at ah tah rhaengpuei boeih te a tingtun sak. Te vaengah kum kul ca neh a so hang tah a hlangmi la amah huiko neh a napa rhoek imko tarhing la ming a khueh uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","BOEIPA loh Moses a uen bangla amih te Sinai khosoek ah a soep. ");
INSERT INTO hlt_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Te vaengah Israel caming, Reuben koca kah a rhuirhong tah, a napa imkhui kah a huiko khaw, a hlangmi ming tarhing ah tongpa ca kum kul lamloh a so hang boeih neh caempuei la aka cet boeih te a tae uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Amih Reuben koca te thawng sawmli thawng rhuk neh ya nga la a soep. ");
INSERT INTO hlt_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Simeon koca kah a rhuirhong tah, a napa imkhui kah a huiko khaw, a hlangmi ming tarhing ah tongpa ca kum kul lamloh a so hang boeih neh caempuei la aka cet boeih te a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Amih Simeon koca te thawng sawmnga thawng ko neh ya thum la a soep. ");
INSERT INTO hlt_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gad koca kah a rhuirhong tah, a napa imkhui kah a huiko khaw, a ming tarhing ah kum kul ca lamloh a so hang neh caempuei la aka cet boeih te a tae uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Amih Gad koca te thawng sawmli thawng nga neh ya rhuk sawmnga la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Judah koca kah a rhuirhong te, a napa imkhui kah a huiko khaw, a ming tarhing ah kum kul ca lamloh a so hang neh caempuei la aka cet boeih te a tae uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Amih Judah koca te thawng sawmrhih thawng li neh ya rhuk la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Issakhar koca kah a rhuirhong te, a napa imkhui kah a huiko khaw, a ming tarhing ah kum kul ca lamloh a so hang neh caempuei la aka cet boeih khaw, ");
INSERT INTO hlt_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Amih Issakhar koca te thawng sawmnga thawng li neh ya li la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zebulun koca kah a rhuirhong te, a napa imkhui kah a huiko khaw, a ming tarhing ah kum kul ca lamloh a so hang neh caempuei la aka cet boeih khaw, ");
INSERT INTO hlt_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Amih Zebulun koca te thawng sawmnga thawng rhih neh ya li la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Joseph koca ah Ephraim koca kah a rhuirhong te, a napa imkhui kah a huiko khaw, a ming tarhing ah kum kul ca lamloh a so hang neh caempuei la aka cet boeih khaw, ");
INSERT INTO hlt_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Amih Ephraim koca te thawng sawmli neh ya nga la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Manasseh koca kah a rhuirhong te, a napa imkhui kah a huiko khaw, a ming tarhing ah kum kul ca lamloh a so hang neh caempuei la aka cet boeih khaw, ");
INSERT INTO hlt_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Amih Manasseh koca te thawng sawmthum thawng hnih yahnih la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Benjamin koca kah a rhuirhong te, a napa imkhui kah a huiko dongkah, a ming tarhing ah kum kul ca lamloh a so hang neh caempuei la aka cet boeih khaw, ");
INSERT INTO hlt_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","amih Benjamin koca te thawng sawmthum thawng nga ya li la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dan koca kah a rhuirhong te, a napa imkhui kah a huiko dongkah, a ming tarhing ah kum kul ca lamloh a so hang neh caempuei la aka cet boeih khaw, ");
INSERT INTO hlt_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","amih Dan koca te thawng sawmrhuk thawng hnih neh ya rhih la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Asher koca kah a rhuirhong te, a napa imkhui kah a huiko khaw, a ming tarhing ah kum kul ca lamloh a so hang neh caempuei la aka cet boeih khaw, ");
INSERT INTO hlt_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","amih Asher koca te thawng sawmli thawng khat neh ya nga la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Naphtali koca kah a rhuirhong te, a napa rhoek imkhui kah a huiko khaw, a ming tarhing ah kum kul ca lamloh a so hang neh caempuei la aka cet boeih khaw, ");
INSERT INTO hlt_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","amih Naphtali koca te thawng sawmnga thawng thum neh ya li la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","He he aka soep rhoek loh a soep vaengah Moses neh Aaron khaw, Israel khoboei hlang hlai nit neh a napa rhoek imkhui pakhat lamkah hlang pakhat rhip om uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Te dongah ni Israel ca rhoek loh a napa rhoek kah imkhui pakhat ah kum kul ca lamloh a so hang, Israel khuiah caempuei la aka cet boeih tah a soep la boeih om uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Te vaengkah a soep boeih te thawng ya rhuk neh thawng thum neh ya nga neh sawmnga lo uh. ");
INSERT INTO hlt_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Tedae Levi te tah a napa koca lamloh amih lakli ah ana soep uh thil pawh. ");
INSERT INTO hlt_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Levi koca bueng tah soep thil boel lamtah amih khuikah a lu te Israel ca khui la khuen boeh. ");
INSERT INTO hlt_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Tedae namah loh Levi te laipainah dungtlungim so neh a hnopai cungkuem so neh a taengkah a cungkuem soah khueh. Amih loh dungtlungim neh a hnopai boeih te kawt uh saeh. Amih te thotat uh saeh lamtah dungtlungim taengah pin rhaeh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Dungtlungim te khuen ham vaengah te te Levi rhoek loh suntlak puei saeh. Dungtlungim a rhaeh ham vaengah khaw te te Levi rhoek loh thoh uh saeh. Tedae hlangthawt loh a paan atah duek saeh. ");
INSERT INTO hlt_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israel ca khuikah hlang he amah kah rhaehhmuen ah rhaeh saeh lamtah hlang he amah caempuei kah a hnitai neh om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Te vaengah Levi rhoek tah laipainah dungtlungim kaepah rhaeh uh saeh. Te daengah ni thinhulnah loh Israel ca rhaengpuei soah a tlak pawt eh. Te dongah laipainah dungtlungim kah tuemkoi te Levi rhoek loh ngaithuen uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israel ca rhoek loh a saii uh vaengah BOEIPA loh Moses a uen bangla a cungkuem te a saii uh. ");
INSERT INTO hlt_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","BOEIPA loh Moses neh Aaron te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Hlang he a napa imko kah miknoek neh a hnitai hmuiah rhaeh uh saeh. Israel ca rhoek te tingtunnah dap taengah a hla la pin rhaeh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Khothoeng khocuk la Judah lambong kah hnitai te amah kah caempuei neh rhaeh saeh. Te vaengah Amminadab capa Nahshon te Judah koca rhoek kah khoboei saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","A caempuei khaw thawng sawmrhih thawng li neh ya rhuk la a soep. ");
INSERT INTO hlt_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","A hmatoeng ah aka rhaeh Issakhar koca neh Issakhar ca rhoek kah khoboei tah Zuar capa Nethanel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","A caempuei khaw thawng sawmnga thawng li neh ya li la soep saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Zebulun koca neh Zebulun ca rhoek kah khoboei tah Helon capa Eliab saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","A caempuei khaw thawng sawmnga thawng rhih neh ya li la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Judah rhaehhmuen kah boeih te thawng yakhat neh thawng sawmrhet neh thawng rhuk ya li la soep uh. Amih kah caempuei te a pacuek ah cet saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Reuben rhaehhmuen kah hnitai tah tuithim ah amah caempuei neh om tih Shedeur capa Elizur te Reuben koca kah khoboei saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","A caempuei neh anih te thawng sawmli thawng rhuk neh ya nga la soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","A hmatoeng ah aka rhaeh Simeon koca neh Simeon ca rhoek kah khoboei tah Zurishaddai capa Shelumiel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","A caempuei neh amih te thawng sawmnga thawng ko neh ya thum la soep saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Gad koca neh Gad ca rhoek kah khoboei tah Reuel capa Eliasaph saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","A caempuei neh amih te thawng sawmli thawng nga neh ya rhuk sawmnga la soep saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Reuben rhaehhmuen kah boeih te thawng yakhat neh thawng sawmnga thawng khat neh ya li sawmnga la soep saeh. Amih kah caempuei te a pabae ah cet saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Te vaengah Levi rhaehhmuen kah tingtunnah dap lambong laklung ah cet saeh. A rhaeh uh vanbangla hlang he amah hnitai hmuikah amah kah hmuen ah cet tangloeng saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ephraim caem kah hnitai a caempuei neh khotlak ah om saeh lamtah Ephraim ca rhoek kah khoboei tah Ammihud capa Elishama saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","A caempuei neh amih te thawng sawmli neh ya nga soep saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","A hmatoeng te Manasseh koca saeh lamtah Manasseh ca rhoek kah khoboei tah Pedahzur capa Gamaliel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","A caempuei neh amih te thawng sawmthum thawng hnih ya hnih la soep saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Benjamin koca neh Benjamin ca rhoek kah khoboei tah Gideoni capa Abidan saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","A caempuei neh amih te thawng sawmthum thawng nga neh ya li la soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ephraim caem te thawng yakhat phoeiah thawng rhet neh ya khat la boeih soep saeh. Amih kah caempuei te a pathum ah cet saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Dan caem kah hnitai tah a caempuei neh tlangpuei ah om saeh lamtah Dan ca rhoek kah khoboei tah Ammishaddai capa Ahiezer saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","A caempuei neh amih te thawng sawmrhuk thawng hnih neh ya rhih la soep saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","A hmatoeng kah aka rhaeh Asher koca neh Asher ca rhoek kah khoboei tah Okran capa Pagiel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","A caempuei neh amih te thawng sawmli thawng khat ya nga soep saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Naphtali koca neh Naphtali ca rhoek kah khoboei tah Enan capa Ahira saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","A caempuei neh amih te thawng sawmnga thawng thum neh ya li soep saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Dan caem khuikah boeih he thawng yakhat neh thawng sawmnga thawng rhih ya rhuk la soep uh tih a hnukkhoem la a hnitai neh cet uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Israel ca rhoek te a napa rhoek imkhui neh a soep tih a caempuei lamloh a caem te boeih a soep vaengah thawng ya rhuk neh thawng thum ya nga sawmnga lo,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Tedae Levi rhoek tah BOEIPA loh Moses a uen vanbangla Israel ca khui ah soep uh thil pawh. ");
INSERT INTO hlt_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","BOEIPA loh Moses a uen bangla a cungkuem te Israel ca rhoek loh a saii uh. A hnitai hmuiah rhaeh uh tih hlang he amah koca ah a napa imkhui neh cet uh. ");
INSERT INTO hlt_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","He tah BOEIPA loh Sinai tlang ah Moses a voek hnin kah Aaron neh Moses rhuirhong ni. ");
INSERT INTO hlt_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aaron ca rhoek he a ming ah, Nadab te a caming tih Abihu, Eleazar neh Ithamar. ");
INSERT INTO hlt_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Khosoih Aaron ca rhoek he khosoih sak ham ming a koelh pah tih a kut ah a buem sak. ");
INSERT INTO hlt_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Tedae Nadab neh Abihu tah BOEIPA mikhmuh ah duek rhoi. Sinai khosoek kah BOEIPA mikhmuh la imlang hmai a khuen dongah amih rhoi te ca khueh rhoi pawh. Te dongah Eleazar neh Ithamar a napa Aaron mikhmuh ah khosoih rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Levi koca te khuen lamtah khosoih Aaron mikhmuh ah pai sak. Te vaengah a taengah thotat uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Te vaengah anih kah tuemkoi neh tingtunnah dap hmai ah rhaengpuei boeih kah tuemkoi khaw, dungtlungim kah thothuengnah dongah thothueng ham khaw ngaithuen saeh. ");
INSERT INTO hlt_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Tingtunnah dap hnopai boeih neh im kah dungtlungim kah thothuengnah dongkah thothueng ham dongah Israel ca rhoek kah tuemkoi te ngaithuen uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Levi rhoek te Aaron taeng neh a ca rhoek taengah pae. Amih te Israel ca rhoek taeng lamloh a taengah pae rhoe pae saeh. ");
INSERT INTO hlt_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aaron neh a capa rhoek te soep lamtah a khosoihbi te ngaithuen saeh. Tedae te aka paan hlangthawt tah duek saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Kai loh Levi te Israel ca rhoek khui lamloh, Israel ca rhoek bung kah cacuek caming boeih yueng ka loh coeng ne. Te dongah Levi rhoek he kamah taengah om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Caming boeih kamah ham coeng dongah Egypt kho kah caming boeih ka ngawn khohnin ah ni Israel khuikah caming boeih te kamah ham ka ciim coeng. Hlang lamloh rhamsa khaw kai Yahweh kamah ham ni a om uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","BOEIPA loh Moses te Sinai khosoek ah a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Levi koca rhoek te a napa imko ah a huiko neh soep lamtah tongpa boeih hla khat ca lamloh a so hang tah soep thil,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Te dongah BOEIPA kah ol a uen bangla Moses loh amih te a soep. ");
INSERT INTO hlt_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levi koca rhoek khui Gershon, Kohath neh Merari a ming om. ");
INSERT INTO hlt_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gershon koca te a cako ah Libni neh Shimei he a ming thum van. ");
INSERT INTO hlt_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohath koca rhoek khaw a cako ah Amram, Izhar, Hebron neh Uzziel thum. ");
INSERT INTO hlt_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari koca rhoek khaw a cako ah Mahli neh Mushi om. Amih he a napa imkhui lamloh Levi koca la om uh. ");
INSERT INTO hlt_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gershon lamloh Libni koca neh Shimei koca a om dongah amih rhoi he Gershon kah a huiko ni. ");
INSERT INTO hlt_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Amih kah a soep tarhing ah hla khat ca lamloh a so hang tongpa boeih te thawng rhih neh ya nga la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gershon cako te dungtlungim kah tahael khotlak ben ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gershon kah a napa imkhui ah Lael capa Eliasaph te khoboei van. ");
INSERT INTO hlt_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gershon koca loh Tingtunnah dap kah dungtlungim neh dap imphu khaw, tingtunnah dap thohka himbaiyan khaw, ");
INSERT INTO hlt_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","vongtung dongkah imbang neh vongtung thohka kah himbaiyan, dungtlungim ham neh hmueituk kaepvai ham, a thothuengnah cungkuem dongkah a rhuimal khaw hutnah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kohath lamloh Amrami cako neh Izhari cako, Khebroni cako neh Ozzeli cako om tih amih he ni Kohathi cako coeng. ");
INSERT INTO hlt_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Hlangmi la, hla khat ca lamloh a so hang tongpa boeih tah hmuencim kah tuemkoi aka ngaithuen ham thawng rhet neh ya rhuk om uh. ");
INSERT INTO hlt_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kohath ca rhoek tah a cako la dungtlungim kaep kah tuithim ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Kohath cako kah a napa imkhui ah Uzziel capa Elizaphan he khoboei van. ");
INSERT INTO hlt_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Te vaengah amih loh thingkawng neh caboei khaw, hmaitung neh hmueihtuk khaw, hmuencim kah hnopai khaw a hutnah. Amih te himbaiyan neh a thothuengnah cungkuem dongah thotat uh. ");
INSERT INTO hlt_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Levi khoboei rhoek kah khoboei, khosoih Aaron capa Eleazar tah hmuencim kah tuemkoi aka ngaithuen rhoek aka cawhkung ni. ");
INSERT INTO hlt_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari lamloh Makhali cako neh Musihe cako tih amih te Merari koca rhoek van. ");
INSERT INTO hlt_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","A hlangmi la, tongpa hla khat ca lamloh a so hang boeih te thawng rhuk neh ya hnih la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merari cako kah a napa imkhui ah Abihail capa Zuriel te khoboei tih dungtlungim kaep kah tlangpuei ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Te vaengah Merari ca rhoek kah a hutnah dungtlungim a longlaeng neh a thohkalh, a tung neh a buenhol, a hnopai boeih neh a thothuengnah boeih aka soepkung ni. ");
INSERT INTO hlt_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Vongtung phai kah tung neh a buenhol khaw, a hlingcong neh a rhuimal khaw a hutnah. ");
INSERT INTO hlt_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Dungtlungim hmai kah khothoeng neh, tingtunnah dap hmai khocuk ah aka rhaeh Moses, Aaron neh anih koca rhoek loh Israel ca kah hutnah yueng la rhokso kah tuemkoi ngaithuen saeh. Tedae te aka paan hlangthawt tah duek saeh. ");
INSERT INTO hlt_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Levi te boeih a soep hil Moses neh Aaron loh BOEIPA ol bangla a soep. Amih koca te hla khat ca lamloh a so hang tongpa boeih te thawng kul hnih lo uh. ");
INSERT INTO hlt_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","BOEIPA loh Moses te, “Israel ca khuiah tongpa caming, hla khat ca lamloh a so hang boeih te soep lamtah a hlangmi ming te khoem pah. ");
INSERT INTO hlt_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Israel ca rhoek lamkah caming boeih yueng la Levi, Israel ca rhoek kah rhamsa caming boeih yueng la Levi kah rhamsa te kai Yahweh kamah ham lo,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Te dongah BOEIPA loh amah a uen bangla Moses loh Israel ca rhoek kah caming boeih te a soep. ");
INSERT INTO hlt_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Te vaengah tongpa caming aka om hla khat ca lamloh a so hang boeih te, a ming neh hlangmi te thawng kul thawng hnih neh ya hnih sawmrhih pathum la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Israel ca rhoek khuikah caming boeih yueng la Levi, a rhamsa yueng la Levi kah rhamsa te loh pah. Levi rhoek te kai Yahweh kamah ham om uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Te dongah tlansum khaw Levi soah te Israel ca caming lamloh ya hnih sawmrhih pathum neh poeng pah. ");
INSERT INTO hlt_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Hlangmi pakhat ham te shekel la shekel panga, panga van lo lamtah hmuencim kah shekel tah gerah pakul loh pah. ");
INSERT INTO hlt_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Tangka te Aaron taeng neh anih koca rhoek taengla na paek vaengah amih kah tlansum te poeng pah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Te dongah Levi kah a lat soah aka poeng rhoek taeng lamkah tlansum tangka te Moses loh a loh. ");
INSERT INTO hlt_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Israel ca caming taeng lamloh tangka te hmuencim shekel ah thawng khat ya thum sawmrhuk panga a doe. ");
INSERT INTO hlt_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","BOEIPA loh Moses a uen vanbangla BOEIPA ol tarhing ah ni Moses loh tlansum tangka te Aaron taeng neh anih koca rhoek taengla a paek. ");
INSERT INTO hlt_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","BOEIPA loh Moses neh Aaron te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Levi koca khui lamloh Kohath ca rhoek kah a lu te a napa rhoek imkhui neh a cako ah tae pah. ");
INSERT INTO hlt_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Kum sawmthum ca lamloh a so hang neh kum sawmnga ca hil tah tingtunnah dap ah bitat saii ham caempuei la boeih kun saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Tingtunnah dap khuiah hmuencim kah hmuencim koek ah Kohath koca kah thothuengnah tah he coeng ni. ");
INSERT INTO hlt_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Lambong a thoeih vaengah Aaron neh anih koca rhoek te kun uh saeh. Te vaengah himbaiyan dongkah hniyan te dul uh saeh lamtah laipainah thingkawng te khuk thil saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Te phoeiah a soah a sing la saham pho neh dah saeh. A so khit ah himbai a thim duk a phaih phoeiah a cung rholh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","A hmai caboei soah himbai thim a phaih tih a soah bael neh yakbu, tuisi-am neh tuisi tui-um tawn uh saeh. Buh khaw a soah phat om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Te rhoek soah himbai hlarhui a lingdik phaih saeh lamtah saham pho imphu neh te te khuk uh saeh. Te phoeiah a cung te rholh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Te vaengah himbai thim lo uh saeh lamtah vangnah hmaitung neh a hmaithoi khaw, a paitaeh neh a baelphaih, a situi am boeih khaw khuk uh saeh. Te rhoek nen te a taengah thotat uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Amah te neh a hnopai boeih te saham pho imphu neh cun uh saeh lamtah cunghloeng dongah buen uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Sui hmueihtuk soah khaw himbai thim neh khuk saeh. Te phoeiah te te saham pho imphu neh khuk uh saeh lamtah a cung rholh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Thohtatnah hnopai cungkuem te khuen uh saeh lamtah hmuencim ah te nen te thotat uh saeh. Himbai thim khuila a sang tih saham pho imphu neh a khuk phoeiah cunghloeng dongah buen uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Te phoeiah hmueihtuk te kol uh saeh lamtah a soah himbai thim phaih uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Te phoeiah a thohtat vaengkah a hnopai cungkuem te, a taengkah baelphaih ciksum neh hmaisoh khaw, baelcak neh hmueihtuk kah hnopai cungkuem te a soah tloeng uh saeh. Te soah saham pho a sing dah uh saeh lamtah a cung te rholh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Aaron neh anih koca rhoek loh hmuencim neh hmuencim kah hnopai cungkuem a khuk te a coeng tih rhaehhmuen puen ham vaengah a hnuk ah koh pah ham Kohath koca rhoek kun uh saeh. Tedae hnocim te ben uh boel saeh duek uh ve. He rhoek he tingtunnah dap khuiah Kohath koca rhoek kah hnophueih la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Khosoih Aaron capa Eleazar loh hmaivang situi neh bo-ul botui khaw, hnin takuem kah khocang neh koelhnah situi aka cawhkung, dungtlungim pum neh a khuikah boeih, hmuencim neh a hnopai aka cawhkung la om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","BOEIPA loh Moses neh Aaron te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Kohathi cako koca te Levi khui lamloh hnawt boeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Tedae he he amih ham na saii daengah ni hmuencim kah hmuencim taengla a mop uh vaengah hing uh vetih a duek uh pawt eh. Aaron neh anih koca rhoek a kun vaengah amih te hlang khat rhip kah a thothuengnah ham neh a hnophueih ham khueh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Tedae hmuencim te hmuh ham yap kun uh boel saeh, tarha duek uh ve,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Te phoeiah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Gershon koca kah a lu te khaw a napa rhoek imkhui lamloh a cako ah tae pah. ");
INSERT INTO hlt_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Capa kum sawmthum lamloh a so hang loh kum sawmnga ca hil soep pah. Amih te tingtunnah dap ah caempuei la thohtat ham neh thothuengnah dongah thothueng ham boeih ha pawk uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","He thothuengnah he Gershon cako kah a thothueng neh a hnophueih la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Te dongah dungtlungim kah himbaiyan neh tingtunnah dap kah a imphu khaw, a so lamkah saham imphu neh tingtunnah dap thohka kah himbaiyan khaw, ");
INSERT INTO hlt_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","vongup kah imbang neh dungtlungim dongkah vongtung vongka thohka kah himbaiyan neh hmueihtuk kaepvai kah a rhuimal khaw, a thothuengnah hnopai cungkuem khaw phuei uh saeh. Te boeih te amih ham khueh pah lamtah thothueng uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aaron neh a capa kah ol bangla Gershon koca rhoek kah thothuengnah cungkuem dongah a hnophueih boeih neh a thothuengnah boeih te om pah saeh. Te phoeiah amih te a hutnah bangla a hnophueih boeih te soep pah. ");
INSERT INTO hlt_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","He he tingtunnah dap ah Gershon koca cako kah thothuengnah coeng ni. Amih hut te khosoih Aaron capa Ithamar kut hmuiah om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Merari koca te a cako ah a napa rhoek imko neh soep pah. ");
INSERT INTO hlt_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Amih te kum sawmthum ca lamloh a so hang neh kum sawmnga ca hil soep pah. Amih te tingtunnah dap ah thothuengnah neh thothueng ham caempuei la boeih kun saeh. ");
INSERT INTO hlt_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Tingtunnah dap ah amih kah thothuengnah boeih la he he a hnophueih neh a hutnah la om saeh. Dungtlungim kah a longlaeng neh a thohkalh khaw, a tung neh a buenhol khaw, ");
INSERT INTO hlt_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","vongtung kaepvai kah tung neh a buenhol khaw, a hlingcong neh a rhuimal khaw, a hnopai boeih neh a thothuengnah boeih khaw, amih kah hnophueih neh a hutnah hnopai te a ming neh soep pah. ");
INSERT INTO hlt_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Tingtunnah dap kah a thothuengnah boeih dongah Merari koca cako thothuengnah he khosoih Aaron capa Ithamar kut hmuiah om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Te dongah Moses, Aaron neh rhaengpuei kah khoboei rhoek loh Kohathi koca kah a cako rhoek neh a napa rhoek imkhui khaw, ");
INSERT INTO hlt_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Kum sawmthum ca lamloh a so hang neh kum sawmnga ca hil, tingtunnah dap kah thothuengnah dongah caempuei la aka pawk boeih te a soep. ");
INSERT INTO hlt_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Amih te a cako la a soep vaengah thawng hnih ya rhih neh sawmnga lo uh. ");
INSERT INTO hlt_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Tingtunnah dap ah tho aka thueng Kohathi cako boeih he a soep vaengah Moses kut dongkah BOEIPA ol bangla Moses neh Aaron loh a soep. ");
INSERT INTO hlt_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gershon koca te a cako la a napa rhoek imkhui lamloh, ");
INSERT INTO hlt_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","kum sawmthum ca lamloh a so hang neh kum sawmnga ca hil tingtunnah dap kah thothuengnah dongah caempuei la aka kun boeih te a soep. ");
INSERT INTO hlt_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Anmih te a cako la a napa imkhui neh a soep vaengah thawng hnih ya rhuk sawmthum lo uh. ");
INSERT INTO hlt_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Tingtunnah dap ah aka thotat Gershon koca cako boeih he a soep vaengah BOEIPA ol bangla Moses neh Aaron loh a soep. ");
INSERT INTO hlt_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Te dongah Merari koca cako te a napa rhoek imkhui neh a cako te a tae. ");
INSERT INTO hlt_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Kum sawmthum ca lamloh a so hang kum sawmnga ca hil, tingtunnah dap kah thothuengnah dongah caempuei la aka kun boeih te a tae. ");
INSERT INTO hlt_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Amih te a soep vaengah a cako ah thawng thum neh yahnih lo. ");
INSERT INTO hlt_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Merari koca cako a soep vaengah Moses kut dongkah BOEIPA ol bangla Moses neh Aaron loh a soep. ");
INSERT INTO hlt_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Moses, Aaron neh Israel khoboei rhoek loh a soep Levi te a cako neh a napa rhoek imkhui khaw boeih a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","tongpaca kum sawmthum neh a so hang kum sawmnga ca hil, thothuengnah dongkah thohtatnah neh tingtunnah dap ah hnophueih dongkah thohtatnah dongah thohtat ham aka pawk boeih khaw, ");
INSERT INTO hlt_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","a soep vaengah amih te thawng rhet ya nga sawmrhet lo . ");
INSERT INTO hlt_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","BOEIPA ol bangla amih te Moses kut ah a soep. Hlang khat rhip kah a thothuengnah ham neh a hnophueih ham khaw BOEIPA loh Moses a uen bangla a tae uh. ");
INSERT INTO hlt_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Israel ca te uen lamtah aka pahuk boeih neh aka hnai boeih khaw, hinglu aka rhalawt boeih te rhaehhmuen lamloh tueih uh. ");
INSERT INTO hlt_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Tongpa lamloh huta hil rhaehhmuen kah vongvoel la tueih. Amih khui ah ka om te amih na tueih uh daengah ni a rhaehhmuen a poeih uh pawt eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Israel ca rhoek loh a ngai tangloeng tih amih te rhaehhmuen kah a voel la a tueih uh. BOEIPA loh Moses taengah a uen bangla Israel ca rhoek loh a saii tangloeng uh. ");
INSERT INTO hlt_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Te phoeiah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Isreal ca rhoek te tongpa khaw huta khaw thui pah. BOEIPA taengah boekoeknah la boekoek ham hlang kah tholhnah cungkuem a saii uh dongah a hinglu te boe coeng. ");
INSERT INTO hlt_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Te dongah tholhnah a saii uh te phoe uh saeh lamtah a hmaithennah te a lu taengah mael saeh. Te phoeiah te te a panga neh koei saeh lamtah anih aka boe sak taengah pae saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Tedae aka tlan ham hlang neh a taengah hmaithennah a sah ham a om pawt atah, hmaithennah te BOEIPA taengah khosoih ham pae saeh. Te vaengah anih ham dawthnah tutal bueng neh dawth pah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Israel ca rhoek kah a cim boeih lamloh khocang cungkuem khaw khosoih taengla khuen saeh lamtah anih ham om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Hlang he amah, amah ah hnocim rhip a khueh te khosoih taengah pae saeh lamtah anih ham om pah saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Israel ca rhoek taengah thui pah lamtah amih te, 'Hlang pakhat kah a yuu te taengphael tih a taengah boekoeknah la boe a koek, ");
INSERT INTO hlt_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","anih te tongpa loh yangtui kah a khaan neh a yalh puei atah a va mikhmuh lamloh hlipdah uh tih thuh uh cakhaw amah poeih uh coeng. Tedae anih taengah laipai om pawt tih anih tu pawh, ");
INSERT INTO hlt_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Anih soah thatlainah mueihla a pha akhaw, a yuu taengah a thatlai akhaw, huta te poeih uh tih tongpa soah thatlainah mueihla a caeh khaw, a yuu taengah thatlai dae a yuu a poeih uh pawt akhaw, ");
INSERT INTO hlt_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","tongpa loh a yuu te khosoih taengla khuen saeh lamtah anih ham a nawnnah te cangtun vaidam cangnoek parha khuen saeh. Tekah kah thatlainah kah khocang dongah a soah situi khaw bueih boel saeh lamtah hmueihtui khaw a soah khueh boel saeh. Poekkoepnah khocang lothaesainah te thoelh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Te phoeiah anih te khosoih loh khuen saeh lamtah BOEIPA mikhmuh ah pai sak saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Te vaengah khosoih loh lai am dongah tui cim khuen saeh. Dungtlungim cirhong ah aka om laipi te khaw khosoih loh lo saeh lamtah tui khuiah sang saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Te phoeiah khosoih loh huta te BOEIPA mikhmuh ah pai sak saeh lamtah huta lu te lim pah saeh. Thatlainah khocang dongkah poekkoepnah khocang neh khosoih kut ah aka om tih thae a phoei thil khahing tui te a kut ah pae saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Anih te khosoih loh toemngam saeh lamtah huta te, “Nang taengah hlang yalh pawt tih na va hmuiah a tihnai neh na taengphael pawt atah he kah thae a phoei thil khahing tui loh m'hmil saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Tedae nang te na va hmui lamloh na taengphael tih na poeih uh vaengah hlang loh nang te na va a om pawt ah a tamtah te a khueh khaming,’ ti nah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Te vaengah khosoih loh huta te thaephoeinah olhlo neh toemngam saeh. Khosoih loh huta te, “BOEIPA loh nang te na pilnam khui kah thaephoeinah neh olhlo bangla n'khueh saeh. BOEIPA loh n'saii vaengah na phai pim saeh lamtah na bung khaw thung saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Thaephoei tui he na ko khuila kun saeh lamtah na bung thung saeh, na phai pim saeh,’ ti nah saeh. Te vaengah huta loh, “Amen, Amen,” ti saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","He kah thaephoeinah he khosoih loh cabu khuiah daek saeh lamtah khahing tui neh huih saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Thaephoei khahing tui te huta tul saeh lamtah thaephoei tui te a khuiah khahing la kun saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Te vaengah khosoih loh huta kut lamkah thatlainah khocang te lo saeh. Tedae khocang te BOEIPA mikhmuh ah thueng saeh lamtah hmueihtuk la khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Te phoeiah khosoih loh kamhoeinah khocang te paco saeh lamtah hmueihtuk ah a phum phoeiah a hnuk la huta te tui tul saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Anih te poeih uh tih a va taengah boekoeknah neh boekoek la a om atah tui a tul tih a khuila thaephoei tui a kun vaengah khahing ni. Te vaengah a bung thung vetih a phai pim ni. Huta te a pilnam khui ah thaephoeinah la om ni. ");
INSERT INTO hlt_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Tedae huta te poeih uh pawt tih a cim atah anih te a hmil vetih tiingan a yom ni. ");
INSERT INTO hlt_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","He tah Huta loh a va hman ah na taengphael tih a poeih uh vaengkah ham thatlainah olkhueng ni. ");
INSERT INTO hlt_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Tongpa khaw a soah thatlainah mueihla loh a pah tih a yuu taengah a thatlai akhaw a yuu te BOEIPA mikhmuh ah pai sak saeh. Te vaengah hekah olkhueng cungkuem he khosoih loh anih taengah saii pah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Tongpa te thaesainah lamloh hmil cakhaw huta tah amah kathaesainah te phuei saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Israel ca rhoek te voek lamtah amih te tongpa khaw huta khaw thui pah. Hlangcoelh kah olcaeng dongah caeng ham neh BOEIPA taengah cue uh ham a rhaisang atah, ");
INSERT INTO hlt_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Misurtui neh yu dong lamloh cue uh saeh lamtah misurtui a thuui neh yu a thuui khaw o boel saeh, misur thaihtui boeih tah o boel saeh lamtah misur he a thingsup khaw, a rhae khaw ca boel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","A rhuisam kah a tue khuiah tah misur misurtui neh a muu lamloh a saii boeih khaw, a kok pataeng khaw ca boel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","A rhuisam dongkah olcaeng tue khuiah tah paihat loh anih lu te paan boel saeh. BOEIPA taengah a cue uh khohnin a cup hil a cim la om saeh lamtah a lu dongkah sammuei sam sai saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","BOEIPA ham a cue uh tue khuiah aka duek hinglu taengla mop boel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","A napa ham neh a manu ham khaw, a pacaboeina ham neh a tanu ham khaw, amih dongah poeih uh boel saeh. Amih te a duek atah a Pathen kah rhuisam kongah anih lu dongah tla saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","A rhuisam kah khohnin khuiah tah anih te BOEIPA taengah cim saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Aka duek khaw anih taengah bangrhuet la pahoi a duek atah a rhuisam lu a poeih coeng. Te dongah a lu te vo saeh lamtah a ciimnah khohnin dongkah a rhih hnin ah vo saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","A rhet nah hnin ah vahu phiknit mai khaw, vahui ca phiknit mai khaw tingtunnah dap thohka kah khosoih taengla la khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Khosoih loh phikat te boirhaem la, phikat te hmueihhlutnah la nawn saeh. A hinglu kah tholh kongah anih ham dawth pah saeh lamtah amah khhnin ah a lu te ciim pah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","A rhuisam kah khohnin ah BOEIPA taengah cue uh saeh lamtah hmaithennah la tu kum khat ca te khuen saeh. Tedae lamhma khohnin kah bangla a rhuisam poeih ham cungku uh ve. ");
INSERT INTO hlt_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","He he hlangcoelh kah olkhueng coeng ni. A rhuisam khohnin a cup khohnin ah anih te tingtunnah dap thohka la khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Te vaengah BOEIPA taengah a nawnnah tah kum khat tu a tal pakhat a hmabuet te hmueihhlutnah la, boirhaem la tumanu kum khat ca a hmabut pumat, rhoepnah ham tutal a hmabuet pakhat khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Vaidamding kodawn pakhat te vaidam laep vaidam la situi neh nom saeh lamtah vaidamding vaidamrhawm khaw situi neh koelh saeh. Te phoeiah a khocang neh a tuisi la khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Te phoeiah khosoih loh BOEIPA mikhmuh ah khuen saeh lamtah anih kah boirhaem neh a hmueihhlutnah te saii pah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Tutal te BOEIPA taengah rhoepnah hmueih la vaidamding kodawn khat neh nawn saeh. Te phoeiah khosoih loh anih kah khocang neh a tuisi te saii pah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Tingtunnah dap thohka kah Hlangcoelh loh a rhuisam lu te vo saeh. Te phoeiah a rhuisam lu dongkah sam te lo saeh lamtah rhoepnah hmueih dang kah hmai dongah phum saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Te phoeiah khosoih loh tutal kah a laeng a hmin neh kodawn dongkah vaidamding laep at, vaidamding dongkah vaidam rhawm pakhat te lo saeh. A rhuisam te a vok phoeiah tah hlangcoelh kut ah pae saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Te rhoek te khosoih loh BOEIPA mikhmuh ah thueng hmueih la thueng saeh. Khosoih ham thueng hmueih kah a rhang neh khosaa kah a laeng te a cim phoeiah tah hlangcoelh loh misurtui khaw o mai saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","He tah BOEIPA taengah amah nawnnah la aka caeng hlangcoelh kah olkhueng ni. A kut loh a pha voel lamloh amah kah rhuisam dongah a olcaeng ol bangla a caeng coeng. Te dongah amah kah rhuisam olkhueng bangla saii saeh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Te phoeiah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Aaron taeng neh anih koca rhoek taengah thui pah lamtah Israel ca rhoek te, 'Na yoethen uh tangloeng,’ ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“BOEIPA loh nang yoethen m'pae saeh lamtah nang n'dawndah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","BOEIPA loh nang soah a maelhmai han sae sak saeh lamtah nang n'rhen saeh. ");
INSERT INTO hlt_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","BOEIPA loh nang taengah a maelhmai han hoi saeh lamtah nang taengah ngaimongnah hang khueh saeh,’ ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Kai ming he Israel ca rhoek soah khueh uh pai saeh lamtah kai loh amih yoethen ka pae pai eh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Moses loh dungtlungim a thoh te a coeng khohnin a pha coeng dongah te te a koelh tih a ciim. A hnopai cungkuem neh hmueihtuk khaw, a umam boeih khaw a koelh tih a ciim. ");
INSERT INTO hlt_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Te phoeiah Israel khoboei rhoek, a napa imkhui kah boeilu loh a nawn uh. Amih te a soep tangtae soah amah koca kah khoboei la pai uh. ");
INSERT INTO hlt_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Te vaengah amih kah nawnnah te BOEIPA mikhmuh la a khuen uh. Tihil leng parhuk neh saelhung hlai nit, khoboei panit ham leng pakhat neh hlang pakhat ham vaitotal pakhat te khaw dungtlungim hmai la a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Te vaengah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Amih lamkah te doe lamtah tingtunnah dap thothuengnah dongah thothueng vaengkah la om saeh. Te te Levi taengah a thothuengnah tarhing la rhip pae,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Te dongah Moses loh leng neh saelhung te a loh tih Levi taengah a paek. ");
INSERT INTO hlt_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Leng panit neh saelhung pumli te Gershon koca rhoek taengah amih thothuengnah tarhing bangla a paek. ");
INSERT INTO hlt_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Leng pali neh saelhung pumrhet te amamih kah thothuengnah tarhing ah khosoih Aaron capa Ithamar kut hmuiah Merari koca rhoek te a paek. ");
INSERT INTO hlt_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Tedae Kohath koca rhoek te tah amamih kah laengpang dongah hmuencim kah thothuengnah a phueih uh dongah pae pawh. ");
INSERT INTO hlt_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Te te a koelh ham khohnin ah khoboei rhoek loh hmueihtuk kah nawnnah te a khuen uh. Te phoeiah khoboei rhoek loh amamih kah nawnnah te hmueihtuk hmai ah a nawn uh. ");
INSERT INTO hlt_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Te phoeiah BOEIPA loh Moses te, “Khoboei pakhat loh hnin at ham, khoboei pakhat van long khaw hnin at ham amamih kah nawnnah te hmueihtuk kah nawnnah la khuen uh saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Anih kah nawnnah lamhmacuek khohnin ah Judah koca lamkah Amminadab capa Nahshon loh a nawn. ");
INSERT INTO hlt_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","A nawnnah khaw cakben bael pakhat ah a khiing ya sawmthum lo tih cakben baelcak pakhat he hmuencim shekel ah shekel sawmrhih lo. Te rhoi dongah vaidam te khocang la situi neh malh a thoek. ");
INSERT INTO hlt_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Bo-ul aka bae yakbu pakhat he sui lungrha neh tluk. ");
INSERT INTO hlt_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Saelhung ca la vaito pumat, tutal pumat neh tu kum khat ca pumat te hmueihhlutnah la. ");
INSERT INTO hlt_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Boirhaem ham maae tal pumat, ");
INSERT INTO hlt_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Rhoepnah hmueih la saelhung pumnit, tutal pumnga, kikong pumnga, tutal kum khat ca pumnga he Amminadab capa Nahshon kah nawnnah coeng ni. ");
INSERT INTO hlt_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","A hnin bae dongah Issakhar khoboei Zuar capa Nethanel loh a nawn. ");
INSERT INTO hlt_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Anih kah nawnnah la a khuen te cakben bael pakhat dongah a khiing ya sawmthum, baelcak pakhat cak he hmuencim kah shekel ah shekel sawmrhih lo. Te rhoi dongkah vaidam a bae te khocang la situi neh a thoek. ");
INSERT INTO hlt_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Sui parha aka tluk tih bo-ul aka bae yakbu pakhat, ");
INSERT INTO hlt_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","vaito saelhung ca pakhat, tutal pumat, tu kum khat ca pumat te hmueihhlutnah ham, ");
INSERT INTO hlt_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","boirhaem la maae ca pumat, ");
INSERT INTO hlt_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","rhoepnah hmueih ham saelhung pumnit, tutal pumnga, kikong pumnga, tu kum khat ca pumnga lo. He tah Zuar capa Nethanel kah nawnnah ni. ");
INSERT INTO hlt_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","A hnin thum dongah Zebulun ca rhoek kah khoboei Helon capa Eliab kah nawnnah a khueh. ");
INSERT INTO hlt_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Anih kah nawnnah dongah cak bael pakhat he a khiing ya sawmthum, baelcak pakhat dongkah cak te hmuencim kah shekel neh shekel sawmrhih lo. Te rhoi dongkah vaidam a bae te khocang la situi neh a thoek. ");
INSERT INTO hlt_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Sui parha aka tluk tih bo-ul aka bae yakbu pakhat, ");
INSERT INTO hlt_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Saelhung ca vaitotal pumat, tutal pumat, tu kum khat ca pumat te hmueihhlutnah la, ");
INSERT INTO hlt_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","boirhaem la maae ca pumat, ");
INSERT INTO hlt_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","rhoepnah hmueih la saelhung pumnit, tutal pumnga, kikong pumnga, tu kum khat ca pumnga lo. He tah Helon capa Eliab kah nawnnah ni. ");
INSERT INTO hlt_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","A hnin li dongah Reuben koca kah khoboei Shedeur capa Elizur loh a nawn. ");
INSERT INTO hlt_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Anih kah nawnnah dongah cak bael pakhat he a khiing ya sawmthum, baelcak pakhat dongkah cak te hmuencim kah shekel neh shekel sawmrhih lo. Te rhoi dongkah vaidam a bae te khocang la situi neh a thoek. ");
INSERT INTO hlt_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","sui parha aka tluk tih bo-ul aka bae yakbu pakhat, ");
INSERT INTO hlt_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Saelhung ca vaitotal pumat, tutal pumat, tu kum khat ca pumat te hmueihhlutnah la, ");
INSERT INTO hlt_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","boirhaem la maae ca pumat, ");
INSERT INTO hlt_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","rhoepnah hmueih la saelhung pumnit, tutal pumnga, kikong pumnga, tu kum khat ca pumnga lo. He tah Shedeur capa Elizur kah nawnnah ni. ");
INSERT INTO hlt_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","A hnin nga dongah Simeon koca rhoek kah khoboei Zurishaddai capa Shelumiel kah om. ");
INSERT INTO hlt_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Anih kah nawnnah dongah cak bael pakhat he a khiing ya sawmthum lo, baelcak pakhat dongkah cak te hmuencim kah shekel neh shekel sawmrhih lo. Te rhoi dongkah vaidam a bae te khocang la situi neh a thoek. ");
INSERT INTO hlt_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Sui parha neh aka tluk tih bo-ul aka bae yakbu pakhat, ");
INSERT INTO hlt_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Saelhung ca vaitotal pumat, tutal pumat, tu kum khat ca pumat te hmueihhlutnah la. ");
INSERT INTO hlt_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","boirhaem la maae ca pumat, ");
INSERT INTO hlt_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","rhoepnah hmueih la saelhung pumnit, tutal pumnga, kikong pumnga, tu kum khat ca pumnga lo . He tah Zurishaddai capa Shelumiel kah nawnnah ni. ");
INSERT INTO hlt_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","A hnin rhuk dongah Gad koca rhoek kah khoboei Deuel capa Eliasaph kah om. ");
INSERT INTO hlt_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Anih kah nawnnah dongah cak bael pakhat he a khiing ya sawmthum lo, baelcak pakhat dongkah cak te hmuencim kah shekel neh shekel sawmrhih lo. Te rhoi dongkah vaidam a bae te khocang la situi neh a thoek. ");
INSERT INTO hlt_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Sui parha neh aka tluk tih bo-ul aka bae yakbu pakhat, ");
INSERT INTO hlt_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Saelhung ca vaitotal pumat, tutal pumat, tu kum khat ca pumat te hmueihhlutnah la, ");
INSERT INTO hlt_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","boirhaem la maae ca pumat, ");
INSERT INTO hlt_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","rhoepnah hmueih la saelhung pumnit, tutal pumnga, kikong pumnga, tu kum khat ca pumnga lo. He tah Deuel capa Eliasaph kah nawnnah ni. ");
INSERT INTO hlt_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","A hnin rhih dongah Ephraim koca rhoek kah khoboei Ammihud capa Elishama kah om. ");
INSERT INTO hlt_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Anih kah nawnnah dongah cak bael pakhat he a khiing ya sawmthum lo, baelcak pakhat dongkah cak te hmuencim kah shekel neh shekel sawmrhih lo. Te rhoi dongkah vaidam a bae te khocang la situi neh a thoek. ");
INSERT INTO hlt_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Sui parha neh aka tluk tih bo-ul aka bae yakbu pakhat, ");
INSERT INTO hlt_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Saelhung ca vaitotal pumat, tutal pumat, tu kum khat ca pumat te hmueihhlutnah la, ");
INSERT INTO hlt_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","boirhaem la maae ca pumat, ");
INSERT INTO hlt_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","rhoepnah hmueih la saelhung pumnit, tutal pumnga, kikong pumnga, tu kum khat ca pumnga lo. He tah Ammihud capa Elishama kah nawnnah ni. ");
INSERT INTO hlt_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","A hnin rhet dongah Manasseh koca rhoek kah khoboei Pedahzur capa Gamaliel kah om. ");
INSERT INTO hlt_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Anih kah nawnnah dongah cak bael pakhat he a khiing ya sawmthum lo, baelcak pakhat dongkah cak te hmuencim kah shekel neh shekel sawmrhih. Te rhoi dongkah vaidam a bae te khocang la situi neh a thoek. ");
INSERT INTO hlt_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Sui parha neh aka tluk tih bo-ul aka bae yakbu pakhat, ");
INSERT INTO hlt_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Saelhung ca vaitotal pumat, tutal pumat, tu kum khat ca pumat te hmueihhlutnah la, ");
INSERT INTO hlt_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","boirhaem la maae ca pumat, ");
INSERT INTO hlt_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","rhoepnah hmueih la saelhung pumnit, tutal pumnga, kikong pumnga, tu kum khat ca pumnga lo. He tah Pedahzur capa Gamaliel nawnnah ni. ");
INSERT INTO hlt_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","A hnin ko dongah Benjamin koca rhoek kah khoboei Gideoni capa Abidan kah om. ");
INSERT INTO hlt_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Anih kah nawnnah dongah cak bael pakhat he a khiing ya sawmthum lo, baelcak pakhat dongkah cak te hmuencim kah shekel neh shekel sawmrhih lo. Te rhoi dongkah vaidam a bae te khocang la situi neh a thoek. ");
INSERT INTO hlt_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Sui parha neh aka tluk tih bo-ul aka bae yakbu pakhat, ");
INSERT INTO hlt_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Saelhung ca vaitotal pumat, tutal pumat, tu kum khat ca pumat te hmueihhlutnah la, ");
INSERT INTO hlt_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","boirhaem la maae ca pumat, ");
INSERT INTO hlt_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","rhoepnah hmueih la saelhung pumnit, tutal pumnga, kikong pumnga, tu kum khat ca pumnga lo. He tah Gideoni capa Abidan nawnnah ni. ");
INSERT INTO hlt_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","A hnin rha dongah Dan koca rhoek kah khoboei Ammishaddai capa Ahiezer kah om. ");
INSERT INTO hlt_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Anih kah nawnnah dongah cak bael pakhat he a khiing ya sawmthum lo, baelcak pakhat dongkah cak te hmuencim kah shekel neh shekel sawmrhih lo. Te rhoi dongkah vaidam a bae te khocang la situi neh a thoek. ");
INSERT INTO hlt_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Sui parha neh aka tluk tih bo-ul aka bae yakbu pakhat, ");
INSERT INTO hlt_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Saelhung ca vaitotal pumat, tutal pumat, tu kum khat ca pumat te hmueihhlutnah la, ");
INSERT INTO hlt_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Boirhaem ham maae ca pumat, ");
INSERT INTO hlt_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","rhoepnah hmueih la saelhung pumnit, tutal pumnga, kikong pumnga, tu kum khat ca pumnga lo. He tah Ammishaddai capa Ahiezer kah nawnnah ni. ");
INSERT INTO hlt_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","A hnin hlai at hnin dongah Asher koca roek kah khoboei Okran capa Pagiel kah om. ");
INSERT INTO hlt_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Anih kah nawnnah dongah cak bael pakhat he a khiing ya sawmthum lo, baelcak pakhat dongkah cak te hmuencim kah shekel neh shekel sawmrhih lo. Te rhoi dongkahvaidam a bae te khocang la situi neh a thoek. ");
INSERT INTO hlt_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Sui parha neh aka tluk tih bo-ul aka bae yakbu pakhat om. ");
INSERT INTO hlt_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Saelhung ca vaitotal pumat, tutal pumat, tu kum khat ca pumat te hmueihhlutnah la, ");
INSERT INTO hlt_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Boirhaem ham maae ca pumat, ");
INSERT INTO hlt_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","rhoepnah hmueih la saelhung pumnit, tutal pumnga, kikong pumnga, tu kum khat ca pumnga lo . He tah Okran capa Pagiel nawnnah ni. ");
INSERT INTO hlt_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","A hnin hlai nit hnin dongah Naphtali koca roek kah khoboei Enan capa Ahira kah om. ");
INSERT INTO hlt_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Anih kah nawnnah dongah cak bael pakhat he a khiing ya sawmthum lo, baelcak pakhat dongkah cak te hmuencim kah shekel neh shekel sawmrhih lo. Te rhoi dongkah vaidam a bae te khocang la situi neh a thoek. ");
INSERT INTO hlt_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Sui parha neh aka tluk tih bo-ul aka bae yakbu pakhat om. ");
INSERT INTO hlt_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Saelhung ca vaitotal pumat, tutal pumat, tu kum khat ca pumat te hmueihhlutnah la, ");
INSERT INTO hlt_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Boirhaem ham maae ca pumat, ");
INSERT INTO hlt_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","rhoepnah hmueih la saelhung pumnit, tutal pumnga, kikong pumnga, tu kum khat ca pumnga lo. He tah Enan capa Ahira nawnnah ni. ");
INSERT INTO hlt_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Israel khoboei rhoek lamloh te te koelh khohnin kah hmueihtuk nawnnah he, cak bael hlai nit, cak baelcak hlai nit, sui yakbu hlai nit, ");
INSERT INTO hlt_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Bael ya sawmthum khaw cak kak ni. Baelcak sawmrhih boeih te a pum la cakben hnopai tih hmuencim kah shekel dongah thawng hnih ya li lo. ");
INSERT INTO hlt_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Sui yakbu hlai nit te bo-ul neh bae. Yakbu te a lang a lang lo tih yakbu dongkah sui boeih he hmuencim kah shekel neh ya pakul lo. ");
INSERT INTO hlt_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Hmueihhlutnah ham saelhung boeih te vaito hlai nit, tutal hlai nit, tu kum khat ca hlai nit, amih kah khocang neh boirhaem ham maae ca khaw hlai nit lo. ");
INSERT INTO hlt_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Rhoepnah hmueih saelhung boeih khaw vaito pakul pali, tutal sawmrhuk, kikong sawmrhuk, tu kum khat ca sawmrhuk lo. He tah hmueihtuk nawnnah a koelh hnukah coeng kah ni. ");
INSERT INTO hlt_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Amah te voek ham tingtunnah dap khuila Moses a kun van neh olphong thingkawng tlaeng sokah cherubim rhoi laklo lamloh anih taengah a thui ol te a yaak tih anih te a voek. ");
INSERT INTO hlt_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Aaron te voek lamtah amah taengah thui pah. Hmaithoi te namah loh hmaitung hmai a dan ah tok lamtah hmaithoi parhih la vang saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Te dongah Aaron loh a ngai tangloeng tih BOEIPA loh Moses a uen bangla hmaitung hmai kah a dan ah hmaithoi te a tok. ");
INSERT INTO hlt_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","He hmaitung dongkah kutngo he a kho lamloh a rhaiphuelh duela sui cakben a boh thil. Te kah cakben te khaw BOEIPA loh Moses a tueng a mueimae bangla hmaitung te a saii van. ");
INSERT INTO hlt_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Levi te Israel ca khui lamloh lo lamtah caihcil laeh. ");
INSERT INTO hlt_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Amih caihcil ham vaengah he he amih ham saii pah. Amih te cangcai tui haeh thil lamtah a pum tom ah paihat caeh sak. Te phoeiah a himbai te suk uh saeh lamtah caihcil uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Te vaengah saelhung ca dongkah vaito neh a khocang dongkah situi neh a thoek vaidam te khuen uh saeh. Te phoeiah saelhung ca dongkah vaito pabae tah boirhaem la khuen. ");
INSERT INTO hlt_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Levi rhoek te tingtunnah dap hmai la khuen lamtah Israel ca rhoek te rhaengpuei la boeih tingtun sak. ");
INSERT INTO hlt_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Levi rhoek te BOEIPA mikhmuh la khuen lamtah Israel ca rhoek loh a kut te Levi soah tloeng uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Israel ca rhoek khui lamkah Levi rhoek te Aaron loh BOEIPA mikhmuh ah thueng hmueih la thueng saeh lamtah BOEIPA kah thothuengnah dongah tho aka thueng la om uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Levi rhoek long khaw a kut te vaito lu soah tloeng uh saeh lamtah pumat te boirhaem la nawn saeh. Te phoeiah pumat te Levi rhoek ham aka dawth la BOEIPA taengah hmueihhlutnah la nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Te vaengah Levi rhoek te Aaron mikhmuh neh anih koca rhoek kah mikhmuh ah pai saehlamtah amih te BOEIPA taengah thueng hmueih la thueng pah. ");
INSERT INTO hlt_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Levi rhoek te Israel ca rhoek khui lamloh hoep tangloeng lamtah Levi rhoek te kamah taengah om uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Te phoeiah tah Levi rhoek te tingtunnah dap ah thothueng ham kun uh saeh. Te vaengah amih te caihcil lamtah amih te thueng hmueih la thueng pah. ");
INSERT INTO hlt_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Israel ca khui lamloh amih te bung boeih kah cacuek yueng la kamah taengah m'pae rhoe m'pae saeh. Israel ca kah caming boeih te kamah ham ka loh coeng. ");
INSERT INTO hlt_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Israel ca khui kah caming boeih he kamah ham ni. Egypt kho ah hlang khaw rhamsa khaw, caming boeih ka ngawn khohnin ah ni, amih te kamah ham ka ciim coeng. ");
INSERT INTO hlt_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Levi rhoek te Israel ca rhoek khui kah caming boeih yueng la ka loh. ");
INSERT INTO hlt_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Tingtunnah dap ah Israel ca rhoek kah thothuengnah dongah thothueng ham neh Israel ca rhoek ham aka dawth pah la, Israel ca khui lamloh Aaron taeng neh anih koca rhoek taengah ka paek te ni Levi taengah ka paek. Te daengah ni Israel ca loh hmuencim la a mop vaengah tlohthae loh Israel ca rhoek a cuk thil pawt eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Te dongah Moses, Aaron neh Israel ca rhaengpuei boeih loh Levi rhoek ham a saii pah. A cungkuem dongah BOEIPA loh Levi ham Moses a uen van bangla Israel ca rhoek loh amih ham te a saii uh tangloeng. ");
INSERT INTO hlt_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Te phoeiah Levi rhoek te ciim uh tih a himbai te a suk uh. Aaron loh amih te BOEIPA mikhmuh ah thueng hmueih la a thueng. Amih caihcil sak ham te Aaron loh amih ham a dawth pah. ");
INSERT INTO hlt_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Te phoeiah tah Levi rhoek te a thothuengnah dongah thothueng ham tingtunnah dap kah Aaron mikhmuh neh anih koca rhoek kah mikhmuh la pawk uh. Te vaengah BOEIPA loh Moses a uen vanbangla Levi rhoek ham te amamih taengah a saii van. ");
INSERT INTO hlt_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Levi ham he tah kum kul kum nga ca lamloh a so hang mah tingtunnah dap kah thothuengnah khuiah caempuei la thotat ham kun saeh. ");
INSERT INTO hlt_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Tedae kum sawmnga ca lamlong tah caempuei lamloh mael saeh lamtah thothuengnah dongah khaw thotat voel boel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Tedae tuemkoi ngaithuen ham te tingtunnah dap ah a manuca te bong saeh. Te phoeiah thothuengnah dongah amah a thotat ham ngawn moenih. Levi rhoek te amamih kah hutnah te khueh pah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Egypt khohmuen lamloh a coe uh phoeikah a kum bae hla lamhma vaengah, BOEIPA loh Moses te Sinai khosoek ah a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Israel ca rhoek loh amah khoning vaengah Yoom te saii saeh. ");
INSERT INTO hlt_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Tahae hlasae kah hnin hlai li hlaem vaengah saii uh. Te te amah khotue vaengah a khosing cungkuem neh a tiktamnah cungkuem bangla saii uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Te dongah Yoom saii ham te Moses loh Israel ca rhoek taengah a thui pah. ");
INSERT INTO hlt_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Te dongah Yoom te lamhmacuek la hlasae hnin hlai li hlaem ah tah Sinai khosoek ah a saii uh. A cungkuem dongah BOEIPA loh Moses a uen bangla Israel ca rhoek loh a saii uh van. ");
INSERT INTO hlt_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Hlang hinglu lamloh rhalawt la aka om hlang rhoek khaw om. Te dongah te khohnin ah Yoom saii uh thai pawh. Tedae amah khohnin ah Moses mikhmuh neh Aaron mikhmuh la tawn uh. ");
INSERT INTO hlt_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Te kah hlang rhoek loh a taengah, “Kaimih he hlang kah hinglu kongah ka rhalawt uh. Balae tih amah khoning vaengah Israel ca lakli ah BOEIPA kah nawnnah te khuen pawt ham n'hloh uh?” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moses loh amih te, “Om uh lamtah BOEIPA loh nangmih ham ng'uen te ka hnatung dae eh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Te phoeiah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Israel ca rhoek te thui pah. Hlang pakhat he hinglu kongah rhalawt la a om vaengah khaw, khola longpueng ah khaw, namah neh na caldilcahma loh thui pah lamtah BOEIPA kah Yoom te saii saeh. ");
INSERT INTO hlt_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Te te a hla bae dongkah hnin hlai li hlaem ah saii uh saeh lamtah vaidamding te ankhaa neh hmaeh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Te te mincang hil paih uh boel saeh. A rhuh khaw paep sak uh boel saeh lamtah a cungkuem dongah Yoom kah khosing bangla saii uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Tedae hlang te tuicil tih longpueng ah khaw om pawt dae Yoom saii ham a toeng atah a pilnam lamloh a hinglu thup pah kangna saeh. Amah khoning ah BOEIPA kah nawnnah te a khuen pawt dongah te kah hlang te amah tholhnah amah loh phuei saeh. ");
INSERT INTO hlt_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Nangmih taengah yinlai bakuep mai cakhaw Yoom kah khosing neh a rhimong bangla BOEIPA kah Yoom te saii saeh. A saii vaengah a khosing te nangmih ham neh yinlai ham khaw, khohmuen mupoe ham khaw pakhat la om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Dungtlungim a thoh hnin ah cingmai loh dungtlungim kah laipainah dap te a khuk. Te vaengah hlaemhmah lamloh mincang hil dungtlungim dongah hmai kah mueimae bangla tueng. ");
INSERT INTO hlt_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Cingmai loh phueih a khuk vaengah tah khoyin ah hmai kah a mueimae la tueng. ");
INSERT INTO hlt_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Cingmai te dap so lamloh nong ham ka a ong phoei daengah ni Israel ca rhoek khaw a hlah uh. Tedae cingmai duem nah hmuen ah Israel ca rhoek khaw pahoi rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Israel ca rhoek te BOEIPA kah olka dongah cet uh tih BOEIPA olka dongah rhaeh uh. Cingmai te dungtlungim soah a duem hnin boeih ah amih khaw rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Cingmai loh dungtlungim soah khohnin a yet a uelh vaengah tah Israel ca rhoek loh BOEIPA kah a kuek te a ngaithuen uh tih cet uh voel pawh. ");
INSERT INTO hlt_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Cingmai te dungtlungim dongah khohnin kolkalh om cakhaw BOEIPA olka dongah rhaeh uh tih BOEIPA olka dongah cet uh. ");
INSERT INTO hlt_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Cingmai te hlaem lamloh mincang hil om tih mincang ah khaw cingmai te a thoeih daengah ni a caeh uh. Khothaih neh khoyin ah khaw cingmai a caeh vaengah cet uh van. ");
INSERT INTO hlt_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Khohnin neh hla neh kum neh dungtlungim soah cingmai te uelh. A soah a om vaengah tah Israel ca rhoek te rhaeh uh tih cet uh pawh. Tedae a thoeih daengah ni a caeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","BOEIPA kah olka dongah rhaeh uh tih BOEIPA kah olka dongah cet uh. BOEIPA kah a kuek tah Moses kut dongkah BOEIPA olka te a ngaithuen uh. ");
INSERT INTO hlt_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Namah ham cak olueng panit saii lamtah cakben boh thil. Te rhoi te nang ham rhaengpuei tingtunnah neh lambong hlahnah lam khaw om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Te te a ueng uh vaengah tah rhaengpuei boeih he tingtunnah dap thohka ah nang taengla tuentah uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Tedae pakhat bueng a ueng uh atah Israel thawng khat kah boeilu, khoboei rhoek te nang taengah tuentah uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Tamlung pacuek na ueng vaengah khothoeng ah aka rhaeh caem rhoek te hlah uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Tamlung pabae neh a ueng bal vaengah tuithim ah aka rhaeh caem te hlah uh saeh. Amih hlahnah ham tamlung neh ueng uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Tedae hlangping te tingtun sak ham vaengah na ueng uh akhaw yuhui uh boeh. ");
INSERT INTO hlt_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Te vaengah Aaron koca khosoih rhoek loh olueng te ueng uh saeh lamtah nangmih ham neh na cadilcahma ham khaw kumhal kah khosing la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Na khohmuen ah rhal taengah caemtloek la na caeh uh vaengah khaw, puen na cak vaengah khaw olueng te ueng uh. Tedae BOEIPA na Pathen kah mikhmuh ah na poek uh daengah ni na thunkha taeng lamloh n'khang eh. ");
INSERT INTO hlt_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Na kohoenah hnin ah khaw, na khoning vaengah khaw, na hlasae tuung vaengah khaw na hmueihhlutnah neh nangmih kah rhoepnah hmueih te olueng neh ueng thil lamtah na Pathen mikhmuh ah nangmih ham poekkoepnah la om saeh. Kai Yahweh he nangmih kah Pathen ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","A kum bae hla bae dongah hlasae hnin kul a pha vaengah, cingmai te laipainah dungtlungim dong lamloh nong. ");
INSERT INTO hlt_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Te dongah Israel ca rhoek te a hlahnah Sinai khosoek lamloh cet uh tih Paran khosoek ah tah cingmai te a pai pah. ");
INSERT INTO hlt_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Te vaengah Moses kut dongkah BOEIPA olka bangla ana cet lamhma uh. ");
INSERT INTO hlt_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Te dongah lamhma la Judah koca caem kah hnitai te amamih kah caempuei tarhing ah a khuen. Te vaengah Amminadab capa Nahshon loh amah kah caempuei te a mawt. ");
INSERT INTO hlt_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Issakhar ca rhoek koca kah caempuei te Zuar capa Nethanel loh a mawt. ");
INSERT INTO hlt_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zebulun ca rhoek koca kah caempuei te Helon capa loh Eliab a mawt. ");
INSERT INTO hlt_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Dungtlungim a hlak van nen tah dungtlungim aka phuei Gershon koca rhoek neh Merari koca rhoek cet uh. ");
INSERT INTO hlt_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Te phoeiah Reuben caem kah hnitai te amamih kah caempuei tarhing ah cet. Te vaengah Shedeur capa Elizur loh a caempuei te a mawt. ");
INSERT INTO hlt_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simeon ca rhoek kah koca caempuei te Zurishaddai capa Shelumiel loh a mawt. ");
INSERT INTO hlt_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gad ca rhoek kah koca caempuei te Deuel capa Eliasaph loh a mawt. ");
INSERT INTO hlt_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Te phoeiah rhokso aka kawt Kohathi te cet. Tedae amih a pawk hlan ah dungtlungim te a thoh uh coeng. ");
INSERT INTO hlt_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Te phoeiah Ephraim koca caem kah hnitai te amamih kah caempuei tarhing la cet. Te vaengah Ammihud kah capa Elishama loh anih kah caempuei te a mawt. ");
INSERT INTO hlt_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Manasseh ca rhoek kah koca caempuei te Pedahzur capa Gamaliel loh a mawt. ");
INSERT INTO hlt_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Benjamin ca rhoek kah koca caempuei te Gideoni capa Abidan loh a mawt. ");
INSERT INTO hlt_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Te phoeiah Dan koca caem kah hnitai te cet. Te vaengah caem boeih te amamih caempuei dongah tingtun uh tih a caempuei te Ammishaddai capa Ahiezer loh a mawt. ");
INSERT INTO hlt_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Asher ca rhoek kah koca caempuei rhoek te Okran capa Pagiel loh a mawt. ");
INSERT INTO hlt_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Naphtali ca kah koca caempuei te Enan capa Ahira loh a mawt. ");
INSERT INTO hlt_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Israel ca rhoek kah a longcaeh he amamih kah caempuei neh cet uh. ");
INSERT INTO hlt_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Te vaengah Moses loh Moses amah masae Median koca Reuel capa Hobab taengah, “Kaimih he BOEIPA loh, 'Nangmih taengah kam paek bitni,’ a ti nah hmuen lam ni ka caeh uh. Kaimih neh pongpa sih lamtah BOEIPA loh Israel soah a then a thui bangla nang taengah ka then uh bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Tedae amah te, “Kam vai mahpawh, kamah khohmuen neh ka pacaboeina taengla ka cet mai eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Tedae, “Khosoek ah ka rhaeh uh ham khaw na ming coeng dongah he kaimih n'hnoo boel mai. Kaimih kah mik la om mai. ");
INSERT INTO hlt_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kaimih neh n'caeh mai akhaw a then la om bitni. BOEIPA loh kaimih taengah n'bawn sak van bangla nang taengah kam bawn sak khaw ana om bitni ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Te phoeiah BOEIPA tlang lamloh hnin thum longcaeh la cet uh. Te vaengah amih ham duemnah aka tlap la hnin thum longcaeh hil amih hmai ah BOEIPA kah paipi thingkawng te a caeh pah. ");
INSERT INTO hlt_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Rhaehhmuen lamloh a caeh uh neh hnin takuem amih soah BOEIPA kah cingmai a om pah. ");
INSERT INTO hlt_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Thingkawng a caeh van neh Moses loh, “BOEIPA aw thoo lamtah, na thunkha te taekyak uh saeh, na lunguet rhoek khaw na mikhmuh lamloh rhaelrham uh saeh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","A duem vaengah khaw, “BOEIPA aw, Israel kah, thawng thawngrha taengla mael laeh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Pilnam te BOEIPA hna ah a thae la kohuet uh tih BOEIPA loh a yaak vaengah a thintoek te sai. Te dongah BOEIPA hmai loh amih taengah a dom tih rhaehhmuen a bawtnah te a hlawp. ");
INSERT INTO hlt_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Te vaengah pilnam te Moses taengah pang tih Moses te BOEIPA taengah a thangthui daengah hmai khaw duek. ");
INSERT INTO hlt_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","BOEIPA kah hmai loh amih te a dom dongah te kah hmuen ming te Taberah la a khue. ");
INSERT INTO hlt_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Amih khui ah aka boihlum kah hoehhamnah te a ngaidam uh. Te vaengah Israel ca rhoek khaw mael uh tih a rhah neh, “U long nim mamih maeh n'cah ve? ");
INSERT INTO hlt_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Egypt ah nga n'caak te n'ngai uh coeng. Yilpuet yiltang neh anthing khaw, rhasawn ling neh rhasawn bok tah a hoeihae mai la. ");
INSERT INTO hlt_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Tedae mamih kah hinglu tah rhae coeng tih mamih mikhmuh kah manna pawt atah a cungkuem he om voel pawh. ");
INSERT INTO hlt_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna khaw mah sungsin muu bangla, a mik khaw thingpi mik bangla om. ");
INSERT INTO hlt_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Pilnam loh van tih a yoep uh. Kuelhsum dongah a kuelh uh , sumngol dongah a daeng uh , am dongah a thong uh. Te te buh la a khueh uh tih a tuihlim khaw, situi hlantui kah a tuihlim bangla om. ");
INSERT INTO hlt_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Rhaehhmuen ah buemtui a bo hatah khoyin ah te nen te manna tla,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Pilnam loh a cako neh, a dap thohka ah hlang a rhah te Moses loh a yaak. Te dongah BOEIPA kah thintoek te sai khungdaeng tih Moses mikhmuh ah thae. ");
INSERT INTO hlt_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Te vaengah Moses loh BOEIPA te, “Balae tih na sal soah thae na huet? Balae tih na mik dongah mikdaithen khaw ka hmuh pawh? He pilnam pum kah hnorhih he kamah soah tloeng ham mai he. ");
INSERT INTO hlt_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Kai loh pilnam pum he ka yom tih kai loh ka sak nim? Kai taengah tah, 'Cahni aka poeh loh a napa ham na toemngam pah khohmuen la a khuen bangla pilnam he na rhang dongah poem,’ na ti. ");
INSERT INTO hlt_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","He pilnam pum taengah paek ham maeh te kai taengah me lamkah nim a om eh? Kai taengah rhap uh tih, 'Kaimih he maeh m'pae lamtah ka ca uh eh,’ a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","He pilnam pum phueih ham tah kai bueng neh ka coeng moenih, kai ham khaw rhih aih. ");
INSERT INTO hlt_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Kai he he tla nan saii oeh atah kamah he nan ngawn khaw nan ngawn laeh mako. Na mikhmuh ah mikdaithen ka dang atah ka yoethae he ka hmu boel eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Te vaengah BOEIPA loh Moses te, “Israel kah a hamca lamloh pilnam kah a hamca neh rhoiboei la na ming te hlang sawmrhih ah kai taengla han coi. Amih te tingtunnah dap la khuen lamtah namah taengah pahoi pai uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ka suntla vetih nang te pahoi kam voek bitni. Te vaengah nang dongkah Mueihla te ka pet vetih amih soah ka khueh ni. Pilnam kah hnorhih te nang n'yingyawn puei daengah ni nang namah bueng ham na phueih pawt eh. ");
INSERT INTO hlt_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Pilnam te, “Thangvuen kah ham ciim uh laeh. Maeh caak ham mai te BOEIPA hna ah na rhap uh tih, “U long nim mamih he maeh n'cah ve, Egypt ah ni mamih ham a hoeikhang palueng,” na ti dongah BOEIPA loh nangmih te maeh m'paek vetih na caak uh bitni. ");
INSERT INTO hlt_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Hnin at bueng na ca mahpawh, hnin nit mai pawt tih hnin nga mai moenih. Hnin rha bal mai pawt tih khohnin kul bueng moenih. ");
INSERT INTO hlt_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Hla bal hnin bal na hnarhong lamloh a coe vaengah nangmih ham kona-awk la om bitni. Na khui ah BOEIPA na hnawt uh tih na rhap uh. A mikhmuh ah, “Balae tih Egypt lamloh n'caeh uh he,” na ti uh ,”ti nah,” a ti. ");
INSERT INTO hlt_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Tedae Moses loh, “Pilnam kah rhalkap he thawng ya rhuk lo tih a khui ah kai ka om ngawn. Namah long tah, “Amih te maeh ka paek vetih khohnin bal hla bal a cak uh bitni,” na ti. ");
INSERT INTO hlt_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Amih ham boiva neh saelhung ngawn cakhaw amih te cung venim?Tuitunli kah nga boeih te amih ham kol pah cakhaw amih te cung venim?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Te dongah BOEIPA loh Moses te, “BOEIPA he a kut ngun a? Kai ol he nang taengah a thoeng khaw, a thoeng pawt khaw na hmuh pawn ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Te phoeiah Moses te cet tih pilnam taengah BOEIPA ol a thui. Te phoeiah pilnam kah a hamca khui lamloh hlang sawmrhih te a coi tih amih te dap kaepvai ah a pai sak. ");
INSERT INTO hlt_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Te vaengah BOEIPA te cingmai khuiah ha suntla tih anih te a voek. Te phoeiah anih dongkah Mueihla te a pet tih a ham rhoek hlang sawmrhih soah a paek. Amih soah Mueihla a om van neh tonghma uh dae khoep uh hae pawh. ");
INSERT INTO hlt_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Te vaengah hlang panit tah rhaehhmuen ah uelh rhoi. Pakhat ming tah Eldad tih pabae te a ming Medad ni. Amih rhoi soah mueihla om tih amih rhoi khaw thum rhoi. Tedae dap la mop rhoi pawt tih rhaehhmuen ah tonghma rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Te dongah camoe pakhat te yong tih Moses taengah a puen pah. Te vaengah, “Eldad neh Medad tah rhaehhmuen ah tonghma rhoi,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Te dongah Moses loh a cacawn lamkah a tueihyoeih Nun capa Joshua loh a doo tih, “Ka boeipa Moses aw amih te paa sak,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Tedae Moses loh anih te, “Kai ham na thatlai a? BOEIPA kah pilnam pum he tonghma la a khueh mai khaming. Amih rhoi soah BOEIPA a mueihla a paek maco,” a ti. ");
INSERT INTO hlt_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Te phoeiah Moses te Israel a ham rhoek neh a rhaehhmuen la khoem uh. ");
INSERT INTO hlt_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Te phoeiah BOEIPA taeng lamloh khohli a tueih tih tuipuei lamkah tanghuem a khuen pah. Te vaengah rhaehhmuen la hnin at longcaeh, hnin at longcaeh hil a khueh pah. Rhaehhmuen kaepvai ah khaw diklai hman ah dong nit hil ngang. ");
INSERT INTO hlt_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Pilnam te thoo tih khothaih puet, khoyin puet, a vuen hnin at puet tanghuem te a kol uh. Homer parha a baeko hil khaw a kol uh tih rhaehhmuen kaepvai ah a yaal la a yaal uh. ");
INSERT INTO hlt_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Maeh te a no laklo ah a ai hlan vaengah BOEIPA kah thintoek te pilnam taengah sai tih BOEIPA loh pilnam te hmasoe puei neh muep a ngawn. ");
INSERT INTO hlt_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Te vaengah maeh hue pilnam te pahoi a up uh dongah te hmuen ming khaw Kiborthhattaavah la a khue. ");
INSERT INTO hlt_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Pilnam te Kiborthhattaavah lamloh Hazeroth la puen uh tih Hazeroth ah om uh. ");
INSERT INTO hlt_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Moses loh Kushi nu a loh vanbangla a loh Kushi nu kah a kongmai dongah Miriam neh Aaron loh a thet. ");
INSERT INTO hlt_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Te vaengah, “Moses lamlong bueng a BOEIPA loh a thui eh? Mamih rhoi lamlong khaw thui mahpawt nim?” a ti rhoi vaengah BOEIPA loh a yaak. ");
INSERT INTO hlt_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Tedae Moses tah a kodo uet ah diklai hman kah hlang boeih lakah kodo tangkik hlang la om. ");
INSERT INTO hlt_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Te dongah BOEIPA loh Moses taeng neh Aaron taengah khaw Miriam taengah khaw, “Nangmih pathum te tingtunnah dap la ha lo uh,” thaeng a ti nah tih a pathum la cet uh. ");
INSERT INTO hlt_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Te vaengah BOEIPA te cingmai tung la suntla tih dap thohka ah pai. Te phoeiah Aaron neh Miriam te a khue tih amih rhoi thoeih rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Te phoeiah, “Kai ol he hnatun rhoi laeh, nangmih kah tonghma om koinih, BOEIPA he anih taengah mangthuinah neh mueimang ah ka phoe vetih anih te ka voek pawnko. ");
INSERT INTO hlt_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ka sal Moses tah te moenih, ka imkhui pum ah anih tah a uepom ta. ");
INSERT INTO hlt_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ka ka dongkah olka te anih taengah ka thui vaengah a hmuethma khaw olkael a om moenih. BOEIPA muei a paelki vaengah he balae tih ka sal Moses taengah cal ham khaw na rhih pawh?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","BOEIPA kah thintoek te amih rhoi taengah sai tih cet. ");
INSERT INTO hlt_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Te phoeiah cingmai te dap so lamloh nong. Te vaengah Miriam te vuelsong bangla pahuk tih Aaron te Miriam taengla a mael vaengah tarha ana pahuk coeng. ");
INSERT INTO hlt_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aaron loh Moses te, “Aw ka boeipa, kaimih rhoi soah tholh han dueh mai boeh, ka nga rhoi tih ka tholh oeh te. ");
INSERT INTO hlt_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","A manu bung lamloh a thoeng vaengah a saa rhakthuem a caak pah vaengkah a duek bangla om mai boel saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Te dongah Moses te BOEIPA taengah pang tih, “Pathen aw anih he hoeih sak mai laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","BOEIPA loh Moses te, “A napa loh a maelhmai ah a timthoeih la a timthoeih coeng atah hnin rhih a hmaithae mahpawt nim? Rhaehhmuen lamloh vongvoel ah hnin rhih om saeh lamtah khue mai saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Te dongah Miriam te rhaehhmuen vongvoel ah hnin rhih a khoh uh tih Miriam a mael duela pilnam khaw cet pawh. ");
INSERT INTO hlt_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Te phoeiah pilnam te Hazeroth lamloh cet tih Paran khosoek ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Namah kah hlang rhoek te tueih lamtah Kanaan kho te yaam uh saeh. Te te Israel ca rhoek taengah ka paek coeng. A napa rhoek koca lamloh hlang pakhat, hlang pakhat tah amamih kah lamkah khoboei la boeih tueih,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Te dongah BOEIPA kah olka bangla Moses loh amih te Paran khosoek lamloh a tueih. Amih tah Israel ca rhoek kah a lu hlang boeih ni. ");
INSERT INTO hlt_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Te rhoek khuiah a ming la Reuben koca lamloh kah Zakkuur capa Shammua, ");
INSERT INTO hlt_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeon koca lamloh Khori capa Shaphat, ");
INSERT INTO hlt_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Judah koca lamloh Jephunneh capa Kaleb, ");
INSERT INTO hlt_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Issakhar koca lamloh Joseph capa Igal, ");
INSERT INTO hlt_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Ephraim koca lamloh Nun capa Hosea, ");
INSERT INTO hlt_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Benjamin koca lamloh Raphu capa Palti, ");
INSERT INTO hlt_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zebulun koca lamloh Sodi capa Gaddi, ");
INSERT INTO hlt_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Joseph koca lamloh Manasseh koca, Susi capa Gaddiel, ");
INSERT INTO hlt_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan koca lamloh Gemalli capa Ammiel, ");
INSERT INTO hlt_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Asher koca lamloh Michael capa Sethur, ");
INSERT INTO hlt_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Naphtali koca lamloh Vophsi capa Nahbi, ");
INSERT INTO hlt_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gad koca lamloh Makhi capa Geuel, ");
INSERT INTO hlt_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Te kah hlang rhoek te a ming Moses loh khohmuen yaam ham a tueih. Te vaengah Moses loh Nun capa Hosea te Joshua la a khue. ");
INSERT INTO hlt_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moses loh amih te Kanaan khohmuen yaam ham a tueih. Te vaengah amih te tuithim lamloh pahoi cet uh lamtah tlang la yoeng uh. ");
INSERT INTO hlt_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Khohmuen neh a khuikah khosa pilnam te so uh. Aka tlungluen nim, aka kha nim, yol nim, yet nim? ");
INSERT INTO hlt_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","A khuiah kho a sak te mebang khohmuen nim? Then nim, thae nim? A khuiah kho a sak khopuei rhoek te rhaehhmuen nen nim, hmuencak nen nim? ");
INSERT INTO hlt_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Diklai te ul nim, caep nim? A khuiah thing om nim, om pawt nim? Moem uh thae lamtah khohmuen thaihtae te hang khuen uh. A tue khaw misur thaihcuek tue coeng ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Te dongah cet uh tih khohmuen te Zin khosoek lamloh Lebokhamath Rehob duela a yaam uh. ");
INSERT INTO hlt_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Te dongah tuithim longah cet uh tih Hebron la pawk uh. Te vaengah Anakim cahlah Sheshai Ahiman neh Talmai ana om coeng. Hebron he Egypt Zoan mikhmuh ah kum rhih khuiah a thoh. ");
INSERT INTO hlt_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Eshkol soklong la a pawk uh vaengah thingluei te a saih uh tih misur a su pakhat te panit loh cunghloeng dongah a koh. Te vaengah tale thaih neh thaibu thaih te a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Israel ca rhoek loh te lamkah thaihsu te a haih uh kawng dongah te hmuen te Eshkol soklong a sui. ");
INSERT INTO hlt_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Khohnin likip a thok vaengah khohmuen aka yaam lamloh mael uh. ");
INSERT INTO hlt_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Cet tih Moses taeng neh Aaron taengah khaw, Kadesh Paran khosoek kah Israel ca rhaengpuei boeih taengla pawk. Amih taengah olka a khuen uh tih rhaengpuei boeih taengah khohmuen thingthaih te a tueng uh. ");
INSERT INTO hlt_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","A taengla a puen uh vaengah, “Kaimih nan tueih nah khohmuen la ka pawk uh , suktui neh khoitui khaw long ngawn tih he he a thaih ni. ");
INSERT INTO hlt_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Lungli lungla la, khohmuen kah khosa pilnam khaw tlung tih khopuei vong cak khaw, bahoeng khangmai. Te phoeiah Anakim cahlah rhoek pataeng hnap ka hmuh uh. ");
INSERT INTO hlt_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalek loh tuithim khohmuen ah kho a sak, Khitti neh Jebusi neh Amori loh tlang ah kho a sak, Kanaan loh tuipuei taeng neh Jordan tuikaeng ah kho a sak,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Tedae Kaleb loh pilnam te Moses mikhmuh ah a sim tih, “Cet rhoe cet uh sih lamtah te te pang uh sih, te te coeng rhoe coeng ta,” a ti. ");
INSERT INTO hlt_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Te vaengah amah neh aka cet hlang rhoek loh, “Mamihs lakah tlungluen coeng tih pilnam te paan ham coeng pawh,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Khohmuen a yaam uh te theetnah la a khuen uh tih Israel ca rhoek taengah, “Khohmuen te yaam ham te longah ka paan uh , khohmuen tah amah khosa rhoek loh a yoop tih a khui kah pilnam te cungkui hlang la boeih ka hmuh uh. ");
INSERT INTO hlt_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Teah te Anakim koca Nephilim te ka hmuh uh. Nephilim lamkah phoeiah tah kaimih mik ah tangku bangla kai om uh coeng tih amih mik ah khaw ka om van,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Rhaengpuei boeih hol uh tih a ol te a huel uh. Te phoeiah pilnam he tekah khoyin ah rhap uh. ");
INSERT INTO hlt_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Israel ca pum he Moses taeng neh Aaron taengah nul uh. Te rhoi taengah rhaengpuei boeih loh, “Egypt kho ah n'duek uh mako, he khosoek ah nim n'duek mai mako. ");
INSERT INTO hlt_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","cunghang dongah cungku ham he BOEIPA loh balae tih he khohmuen la mamih n'khuen. Mamih yuu ca he maeh la om uh pawn ni. Egypt la mael he mamih ham then ngai pawt nim? a Boeipa loh mamih he hela ingkhueh uh? Egypt ramla koep mael he then ngai mah pawt a? Moses neh Aaron taengah ati na uh. ");
INSERT INTO hlt_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Te vaengah hlang loh a manuca taengah, “A lu pakhat n'tuek uh vetih Egypt la m'mael uh mako,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Te vaengah Moses neh Aaron tah Israel ca rhaengpuei hlangping boeih kah mikhmuh ah a maelhmai te a buenglueng rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Tedae khohmuen aka yaam khuikah Nun capa Joshua neh Jephunneh capa Kaleb long tah a himbai te a phen rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Te phoeiah Israel ca rhaengpuei boeih te a thui rhoi tih, “Te khohmuen ka paan uh tih ka yaam vaengah khohmuen khaw bahoeng, bahoeng then. ");
INSERT INTO hlt_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","BOEIPA he mamih taengah hmae tih mamih he te khohmuen la m'pawk sak vaengah suktui neh khoitui aka long khohmuen te mamih taengah m'paek bitni. ");
INSERT INTO hlt_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","BOEIPA bueng te tloelh uh boeh, nangmih loh khohmuen kah pilnam te rhih uh boeh. Amih kah hlipkhup te amih taeng lamloh nong coeng tih amih te mamih kah buh la om coeng. Tedae BOEIPA he mamih taengah a om dongah amih te rhih uh boeh,” a ti rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Te vaengah rhaengpuei pum loh amih rhoi te lungto neh dae ham cai uh. Tedae BOEIPA kah thangpomnah tah tingtunnah dap kah Israel ca boeih taengah a phoe pah. ");
INSERT INTO hlt_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Te phoeiah BOEIPA loh Moses te, “He pilnam loh kai he mevaeng hil n'tlaitlaek uh vetih a khui ah miknoek cungkuem ka saii lalah mevaeng hil nim kai he n'tangnah uh pawtve. ");
INSERT INTO hlt_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Amih te duektahaw neh ka ngawn vetih ka haek ni. Tedae nang te namtom tanglue la kang khueh vetih amih lakah na pilnu ngai ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Tedae Moses loh BOEIPA taengah, “A khui lamloh na thadueng neh he pilnam na khuen te Egypt loh ya saeh. ");
INSERT INTO hlt_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","He khohmuen kah khosa rhoek taengah thui uh saeh. He pilnam lakli ah BOEIPA namah na om te a yaak uh tih BOEIPA namah taengah mik neh mik khaw hmu uh rhoi coeng. Nang kah cingmai khaw amih soah pai. Amih mikhmuh ah khothaih kah cingmai tung neh khoyin ah hmai tung la na caeh pah. ");
INSERT INTO hlt_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","He pilnam he hlang pakhat bangla na duek sak koinih nang olthang a yaak vaengah namtom loh a thui bal ni. ");
INSERT INTO hlt_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Te vaengah, “Amih ham a toemngam pah khohmuen la BOEIPA loh he pilnam he khuen ham a coeng pawt dongah amih te khosoek ah a ngawn,” a ti uh ni. ");
INSERT INTO hlt_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Thui ham na ti vanbangla ka Boeipa kah thadueng te pomsang mai laeh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","BOEIPA tah thintoek a ueh tih sitlohnah khaw puh. Thaesainah neh boekoek khaw a phueih pah dae pa rhoek kathaesainah te ca rhoek soah khongthum, khongli duela a cawh tih hmil rhoe hmil pawh. ");
INSERT INTO hlt_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Na sitlohnah dongkah boeilennah neh Egypt lamloh tahae hil pilnam na khuen bangla he pilnam kathaesainah he khodawkngai mai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Te dongah BOEIPA loh, “Nang ol bangla khodawk ka ngai coeng. ");
INSERT INTO hlt_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Kai ka hingnah la ka om dongah BOEIPA kah thangpomnah he diklai pum ah bae. ");
INSERT INTO hlt_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Egypt neh khosoek ah ka tueng sak kamah kah thangpomnah neh ka miknoek te hlang boeih loh a hmuh. Tedae kai he voei rha khaw n'noemcai uh tih kai ol he hnatun uh pawh. ");
INSERT INTO hlt_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","A napa rhoek taengah ka toemngam pah khohmuen te hmu uh pawt vetih kai aka tlaitlaek boeih loh te hmu mahpawh. ");
INSERT INTO hlt_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ka sal Kaleb tah a khuiah mueihla tloe a om tih kai hnukah hnawn uh. Te dongah anih te a pawk ham koi khohmuen la pahoi ka khuen vetih a tiingan loh te te a pang ni. ");
INSERT INTO hlt_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Kol kah khosa Amalek neh Kanaan te thangvuen ah mael laeh saeh lamtah nangmih ham khosoek kah carhaek tuipuei longpuei te paan uh laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Te phoeiah BOEIPA loh Moses neh Aaron te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Boethae he rhaengpuei ham me hil nim kai taengah a nul uh ve? Amih Israel ca rhoek kah kohuetnah loh kai taengah a nul uh khaw ka yaak coeng. ");
INSERT INTO hlt_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Kai hingnah BOEIPA kah olphong he amih taengah thui pah. Kai hna ah na thui bangla nangmih taengah ka saii van mahpawt nim? ");
INSERT INTO hlt_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Na hlangmi boeih khuiah capa kum kul lamloh a so hang na soep thil boeih khaw kai taengah na nul vanbangla na rhok te he khosoek ah yalh ni. ");
INSERT INTO hlt_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","A khuiah nangmih khosak sak ham ka kut ka phuel coeng dae Jephunneh capa Kaleb neh Nun capa Joshua phoeiah tah te khohmuen la nangmih na kun uh mahpawh. ");
INSERT INTO hlt_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Na ca rhoek khaw maeh la om pawnko na ti uh cakhaw amih te a pawk puei vetih khohmuen na hnawt uh te khaw a ming uh bitni. ");
INSERT INTO hlt_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Tedae nangmih tah namamih rhok te he khosoek ah ni a yalh eh. ");
INSERT INTO hlt_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Na ca rhoek te khosoek ah boiva aka dawn la kum likip om uh vetih na rhok a cing hil khosoek ah nangmih kah pumyoihnah te a phueih uh ni. ");
INSERT INTO hlt_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Khohnin la hnin likip khuiah khohmuen na yaam uh vaengkah khohnin tarhing ah a kum dongah khaw hnin at te kum khat la om ni. Nangmih kathaesainah te kum sawmli na phueih uh vaengah kai kah noihhainah te na ming uh bitni. ");
INSERT INTO hlt_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Kai BOEIPA loh ka thui coeng atah he boethae rhaengpuei boeih taengah ka saii het mahpawt nim. Kai aka tuentah rhoek te he khosoek ah khawk uh tih pahoi duek uh ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Te dongah Moses loh khohmuen yaam ham a tueih hlang a mael uh vaengah tah rhaengpuei boeih te a taengah rhaeh la rhaeh uh tih khohmuen kawng te theetnah la a khuen. ");
INSERT INTO hlt_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Khohmuen kah theetnah aka khuen hlang rhoek tah BOEIPA mikhmuh kah lucik dongah a thae la duek uh. ");
INSERT INTO hlt_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Tedae khohmuen yaam ham aka cet hlang rhoek khui lamloh Nun capa Joshua neh Jephunneh capa Kaleb tah hing. ");
INSERT INTO hlt_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Moses loh he ol he Israel ca boeih taengah a thui vaengah pilnam bung bung nguekcoi uh. ");
INSERT INTO hlt_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Mincang ah thoo uh tih tlang som la luei uh. “Amah dae la he, n'tholh uh dongah BOEIPA kah a thui hmuen la cet uh pawn sih,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Te vaengah Moses loh, “Balae tih BOEIPA olka te na poe uh, te thaihtak he mahpawh. ");
INSERT INTO hlt_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Cet uh boeh, nangmih khui ah BOEIPA a om moenih. Na thunkha rhoek mikhmuh ah na yawk uh mahpawt nim? ");
INSERT INTO hlt_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Nangmih mikhmuh ah Amalek neh Kanaan om lah ko. BOEIPA hnuk lamloh na mael uh dongah cunghang neh na cungku uh ni. Nangmih taengah BOEIPA om mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Te vaengah tlang som la luei ham calak uh dae BOEIPA kah paipi thingkawng neh Moses tah rhaehhmuen khui lamloh nong pawh. ");
INSERT INTO hlt_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Tlang kah khosa Amalek neh Kanaan te ha suntla vaengah tah Amih te a ngawn uh tih Hormah duela amih te a phop uh. ");
INSERT INTO hlt_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“'Kai loh nangmih taengah kam paek ham na tolrhum khohmuen la na pawk uh vaengah, Israel ca rhoek te voek lamtah amih te thui pah. ");
INSERT INTO hlt_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","BOEIPA taengah hmueihhlutnah hmaihlutnah khaw, olcaeng soep sak ham hmueih khaw, kothoh ham khaw, na khoning ham nawn pah. Saelhung khui lamkah khaw, boiva khui lamkah khaw, BOEIPA taengah hmuehmuei la botui nawn. ");
INSERT INTO hlt_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","BOEIPA taengah amah kah nawnnah aka khuen long tah situi bunang pali neh a thoek khocang vaidam doh te khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Tuisi la misurtui bunang pali ah hmoel pah. Hmueihhlutnah neh hmueih ham khaw tuca neh rhip saii. ");
INSERT INTO hlt_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Tutal ham tah situi bunang pathum neh a thoek khocang vaidam doh nit hmoel pah. ");
INSERT INTO hlt_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Tuisi ham misurtui bunang khoi thum te BOEIPA taengah hmuehmuei botui la nawn. ");
INSERT INTO hlt_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Hmaihhlutnah saelhung ca khaw, olcaeng aka soep sak ham hmueih khaw, BOEIPA taengah rhoepnah khaw saii. ");
INSERT INTO hlt_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Saelhung ca nen tah situi bunang ngancawn neh a thoek khocang vaidam doh thum te khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Tuisi ham misurtui bunang ngancawn ah khuen lamtah hmaihlutnah khaw BOEIPA taengah hmuehmuei botui la nawn. ");
INSERT INTO hlt_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Vaito ham pakhat, tutal ham khaw pakhat neh tu ham khaw tuca khui lamkah khaw maae khui lamkah khaw hmoel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Hlangmi tarhing ah na saii te a hlangmi bangla pakhat rhip ham saii tangloeng. ");
INSERT INTO hlt_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Tolrhum mupoe boeih loh he he saii kuekluek saeh lamtah tah te rhoek te BOEIPA taengkah hmaihlutnah hmuehmuei botui la khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Nangmih taengah aka bakuep yinlai khaw namamih khui kah bangla na cadilcahma ham hmaihlutnah te BOEIPA taengah hmuehmuei botui la nawn saeh lamtah na saii uh bangla saii van saeh. ");
INSERT INTO hlt_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Hlangping kah khosing he nangmih ham neh yinlai aka bakuep ham khaw pakhat la om saeh. Na cadilcahma kah kumhal khosing nen khaw yinlai te BOEIPA mikhmuh ah nangmih bangla om van saeh. ");
INSERT INTO hlt_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Nangmih ham neh nangmih taengah aka bakuep yinlai ham he olkhueng pakhat neh laitloeknah pakhat mah om saeh,’ ti nah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Israel ca rhoek te voek lamtah amih te, 'Kai loh nangmih kam pawk khohmuen la na pawk uh tih, ");
INSERT INTO hlt_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","khohmuen kah buh te na caak vaengah BOEIPA taengah khosaa tloeng uh. ");
INSERT INTO hlt_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Na buhhuem tanglue vaidam laep te khocang la tloeng uh lamtah cangtilhmuen kah khocang bangla tloeng uh. ");
INSERT INTO hlt_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Nangmih kah buhhuem tanglue khui lamkah te na cadilcahma due BOEIPA taengah khocang la pae uh. ");
INSERT INTO hlt_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Tedae na palang dongah BOEIPA loh Moses taengah a thui olpaek he boeih na vai uh moenih. ");
INSERT INTO hlt_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Te boeih te BOEIPA loh Moses kut dongah nangmih te ng'uen. Te khohnin lamkah BOEIPA loh a uen he a voel kah na cadilcahma ham hil pawn ni. ");
INSERT INTO hlt_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Rhaengpuei mik lamloh la a saii khaming, te vaengah rhaengpuei pum loh hmueihhlutnah ham saelhung ca vaito pumat neh, a laitloeknah bangla a khocang neh a tuisi khaw, boirhaem la maae ca pumat te, BOEIPA taengah hmuehmuei botui la nawn uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Khosoih loh Israel ca rhaengpuei boeih ham a dawth pah daengah ni tohtamaeh dongah khaw amih te khodawk a ngai eh. Te vaengah amih loh amamih kah nawnnah te BOEIPA taengah hmaihlutnah la khuen uh saeh. Amih kah tohtamaeh dongah amamih kah boirhaem te BOEIPA mikhmuh ah tloeng uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Te daengah ni Israel ca rhaengpuei boeih ham neh amih lakli ah aka bakuep yinlai ham, tohtamaeh khuikah pilnam cungkuem ham khodawk a ngai eh. ");
INSERT INTO hlt_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Hinglu pakhat long he tohtamaeh la a tholh khaming, te vaengah maae la kum khat ca te boirhaem la khuen saeh. ");
INSERT INTO hlt_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","BOEIPA mik ah tohtamaeh kah hlangtholh la aka taengphael hinglu ham khosoih dawth pah saeh. Anih ham adawth pah daengah ni anih te khodawk a ngai eh. ");
INSERT INTO hlt_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Israel ca lamkah mupoe neh a khui kah aka bakuep yinlai ham khaw tohtamaeh la a saii vaengkah olkhueng he nangmih taengah pakhat la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Tedae kut thueng neh aka saii hinglu tah mupoe khaw, yinlai khaw BOEIPA ni a hliphen. Te dongah tekah hinglu te a pilnam khui lamloh hnawt pah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","BOEIPA ol te a sawtsit tih a olpaek te a phae dongah amah sokah amah kathaesainah bangla a hinglu te hnawt rhoe hnawt pah saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Israel ca rhoek te khosoek ah a om uh vaengah Sabbath hnin ah thing aka coi hlang te a hmuh uh. ");
INSERT INTO hlt_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Te dongah thing aka coi amah te aka hmu rhoek loh Moses, Aaron taeng neh rhaengpuei boeih taengla a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Tedae anih taengah metla saii ham khaw a puk pawt dongah thongim khuila a up uh. ");
INSERT INTO hlt_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Te vaengah BOEIPA loh Moses taengah, “Tekah hlang te duek rhoe duek saeh, anih te rhaehhmuen vongvoel ah rhaengpuei pum loh lungto neh dae uh saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Te dongah anih te rhaengpuei pum loh rhaehhmuen vongvoel la a khuen uh tih lungto neh a dae uh dongah BOEIPA loh Moses a uen vanbangla duek. ");
INSERT INTO hlt_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Israel ca rhoek te voek lamtah amih te thui pah. Amih ham maelaw te a cadilcahma due a himbai hmoi ah saii uh saeh lamtah hamnak hmoi kah maelaw dongah a thim khueh uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Maelaw la nangmih taengah om vetih te te na hmuh uh daengah ni BOEIPA kah olpaek cungkuem te na poek uh eh. Te te na ngai uh van daengah ni na thinko hnuk neh na mik hnuk te na yaam uh pawt eh. Nangmih tah te rhoi hnukah ni na cukhalh uh. ");
INSERT INTO hlt_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Kai kah olpaek cungkuem he na poek uh tih na ngai uh daengah ni na Pathen taengah a cim la na om uh eh. ");
INSERT INTO hlt_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Kai tah nangmih kah Pathen la om ham Egypt kho lamloh nangmih aka khuen nangmih kah Pathen Yahweh ni. Kai tah nangmih kah Pathen Yahweh ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Te phoeiah Levi koca Kohath kah a ca Izhar capa Korah, Eliab ca rhoi Dathan neh Abiram, Reuben koca Peleth capa On te a khuen. ");
INSERT INTO hlt_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Te phoeiah Israel ca lamloh hlang yahnih sawmnga, hlang kah tingtunnah khuikah ming aka thang, rhaengpuei khoboei rhoek neh Moses mikhmuh ah tlai uh. ");
INSERT INTO hlt_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Moses taeng neh Aaron taengah tingtun uh tih amih rhoi taengah, “Rhaengpuei boeih ham nangmih rhoi te rhoekoe aih. Amih te boeih cim uh tih amih lakli taengah BOEIPA om ta. Balae tih BOEIPA kah hlangping soah na palawh uh rhoi,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Tedae Moses loh a yaak vaengah a maelhmai dongah buekuep. ");
INSERT INTO hlt_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Te phoeiah Korah taeng neh a hlangboel boeih taengah, “Mincang ah BOEIPA amah taengkah neh hlangcim te mingpha bitni. A taengla a moe vaengah amah ham a coelh te ni anih taengah a moe pa eh. ");
INSERT INTO hlt_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","He he saii uh lamtah Korah neh a hlangboel boeih aw, baelphaih te namamih ham lo uh. ");
INSERT INTO hlt_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Te rhoek dongah hmai khueh lamtah te nen te BOEIPA mikhmuh ah bo-ul tawn pah. Thangvuen ah khaw BOEIPA kah a coelh hlang om bitni. Anih te Levi koca nangmih taengah muep cim ngawn,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moses loh Korah te akhue tih, “Levi koca hnatun uh mai. ");
INSERT INTO hlt_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Israel Pathen loh nangmih te Israel rhaengpuei taeng lamloh amah taengla khuen ham, BOEIPA dungtlungim kah thohtatnah dongah thohtat ham, rhaengpuei mikhmuh kah aka thotat te pai puei ham nangmih n'hoep te nangmih ham a mailai a? ");
INSERT INTO hlt_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Nang neh na manuca boeih, na taengkah Levi koca rhoek m'mop lalah khosoihbi na hue bal pueng. ");
INSERT INTO hlt_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Te dongah nang neh na hlangboel boeih loh BOEIPA na tuentah thil uh. A taengah a nul la na nul uh ham akhaw Aaron te mebang nim?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Te phoeiah Eliab koca Dathan neh Abiram te khue ham Moses loh a tah. ");
INSERT INTO hlt_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Tedae, “Ka cet uh mahpawh, khosoek ah kaimih duek sak ham suktui neh khoitui aka long khohmuen lamloh kaimih n'caeh puei te a mailai a? Kaimih soah na boei la na boei van. ");
INSERT INTO hlt_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Suktui neh khoitui aka long khohmuen la kaimih nang khuen pawt bueng kolla khohmuen neh misurdum khaw kaimih ham rho nan paek loela he. Hlang te a mik na koeih aya? Ka lo uh mahpawh,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Te vaengah Moses te sai khungdaeng tih BOEIPA taengah, “Amih kah khocang taengla mael boeh, amih lamkah laak pakhat pataeng ka khuen pawt tih amih soah pakhat khaw ka thae moenih a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Te phoeiah Moses loh Korah te, “Namah neh na hlangboel boeih aw, thangvuen ah tah namah khaw, amih khaw Aaron khaw BOEIPA mikhmuh ah om uh. ");
INSERT INTO hlt_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Hlang loh amah baelphaih khuen saeh lamtah a khuiah bo-ul khueh pah. Te vaengah hlang kah a baelphaih khaw, nang neh Aaron kah khaw, khat rhip kah a baelphaih te baelphaih yahnih sawmnga la BOEIPA mikhmuh ah khuen pah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Te dongah hlang tom loh a baelphaih te a loh tih a khuiah hmai a poep uh. Te soah bo-ul a poep thil phoeiah tah tingtunnah dap thohka kah Moses neh Aaron taengah pai uh. ");
INSERT INTO hlt_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Tingtunnah dap thohka kah amih hmai ah Korah loh rhaengpuei boeih te a tingtun sak. Te vaengah BOEIPA kah thangpomnah tah rhaengpuei boeih taengah a tueng pah. ");
INSERT INTO hlt_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Te vaengah BOEIPA loh Moses neh Aaron te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","He rhaengpuei khui lamloh tuiphih rhoi lamtah amih te mikhaptok ah ni ka khah eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Tedae a maelhmai dongah bakop rhoi tih, “Pathen aw, pumsa cungkuem kah Mueihla Pathen aw, hlang pakhat a tholh dongah rhaengpuei boeih taengah na thintoek mai,” a ti rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Rhaengpuei te voek lamtah thui pah. Korah, Dathan neh Abiram kah dungtlungim taeng kaepvai lamloh cet uh laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moses te thoo tih Israel kah a ham rhoek Dathan neh Abiram neh anih hnukah aka cet rhoek te a paan. ");
INSERT INTO hlt_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Rhaengpuei taengah a thui pah tih, “Halang hlang rhoek kah dap dong lamlong he nong uh laeh, amih taengkah boeih te tah ben uh boeh, amih kah tholh cungkuem dongah na khoengvoep uh ve,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Te dongah Korah, Dathan kah dungtlungim taeng lamkah neh Abiram kaepvai lamloh nong uh. Te vaengah amamih kah dap thohka ah aka pai Dathan neh Abiram tah a yuu rhoek neh a ca rhoek khaw, camoe khaw ha moe uh. ");
INSERT INTO hlt_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Te vaengah Moses loh, “He bitat cungkuem saii ham he kamah lungbuei lamkah pawt tih BOEIPA loh kai n'tueih khaw he nen he ming uh. ");
INSERT INTO hlt_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Hlang cungkuem a duek bangla he rhoek duek tih hlang cungkuem aka cawhkung bangla amih neh cawh koinih BOEIPA loh kai n'tueih mahpawh. ");
INSERT INTO hlt_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Tedae BOEIPA loh hnothai a suen tih diklai loh a ka a ang khaming. Te vaengah amamih neh amih taengkah a cungkuem te dolh saeh lamtah a hingnah te saelkhui la suntla uh saeh. Te vaengah he kah hlang rhoek loh BOEIPA a tlaitlaek uh te na ming uh bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","He ol cungkuem a thui te a khah van neh diklai te a dang ueth coeng. ");
INSERT INTO hlt_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Te dongah diklai loh a ka a ang tih amih, Korah neh a im khaw, a hlang boeih neh a khuehtawn boeih te a dolh pah. ");
INSERT INTO hlt_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Amih neh amih taengkah boeih te saelkhui ah a hing la a suntlak uh phoeiah tah amih te diklai loh a et tih hlangping lakli lamloh milh uh. ");
INSERT INTO hlt_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Te dongah amih kaepvai kah Israel pum long tah, “Diklai loh mamih n'dolh van ve,” a ti uh tih a ol neh rhaelrham uh. ");
INSERT INTO hlt_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Te phoeiah hmai te BOEIPA taeng lamloh ha puek tih bo-ul aka nawn hlang yahnih sawmnga te hlawp. ");
INSERT INTO hlt_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Te phoeiah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Khosoih Aaron capa Eleazar te thui pah. Baelphaih te ungkhang laklo lamloh koeih saeh lamtah hmai te khaw a ciim coeng dongah voelh thaek saeh. ");
INSERT INTO hlt_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Amih kah hinglu kongah he hlangtholh rhoek kah baelphaih rhoek he phaldaep la phal uh saeh lamtah hmueihtuk dongkah a ben ham khaw te te saii uh saeh. Te rhoek te BOEIPA mikhmuh ah nawn uh saeh lamtah ciim uh saeh. Te vaengah Israel ca rhoek ham miknoek la om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Te dongah a khuen uh tih aka ung tangtae rhohum baelphaih te khosoih Eleazar a loh. Te phoeiah te te hmueihtuk dongkah ben ham a daep uh. ");
INSERT INTO hlt_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Israel ca rhoek ham poekkoepnah la a om daengah ni Aaron tiingan lamkah mueh atah BOEIPA mikhmuh ah bo-ul phum ham kholong hlang a mop pawt eh. Te dongah BOEIPA Moses kut dongah a uen vanbangla Korah neh a hlangboel bang tah om boel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","A vuen ah tah Israel ca rhaengpuei boeih te Moses taeng neh Aaron taengah nul tih, “BOEIPA kah pilnam te na duek sak rhoi,” a ti na uh. ");
INSERT INTO hlt_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Tedae rhaengpuei loh Moses neh Aaron te a tingtun thil uh tih tingtunnah dap la mael uh. Te vaengah cingmai loh tarha a thing tih BOEIPA kah thangpomnah khaw tueng. ");
INSERT INTO hlt_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Te daengah Moses neh Aaron te tingtunnah dap hmai la moe rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“He rhaengpuei khui lamloh cungpet rhoi lamtah amih te mikhaptok ah ni ka khah eh?,” a ti nah. Te dongah a maelhmai neh bakop rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Te phoeiah Moses loh Aaron taengah, “Baelphaih te lo lamtah a khuiah hmueihtuk dongkah hmai na poep phoeiah bo-ul mop thil, rhaengpuei taengla tlek cet lamtah amih ham dawth pah. BOEIPA maelhmai dong lamloh thinhulnah ha thoeng tih tlohthae ha tawn uh coeng,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Te dongah Moses kah a thui bangla Aaron loh a loh tih hlangping khui la yong. Te vaengah tlohthae loh pilnam tarha a phoei coeng. Tedae bo-ul te a phum tih pilnam ham a dawth pah. ");
INSERT INTO hlt_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Aka duek laklo neh aka hing laklo ah a pai vaengah lucik khaw cing. ");
INSERT INTO hlt_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Korah ol ah a duek uh bueng kolla lucik ah aka duek rhoek he thawng hlai li ya rhih lo uh. ");
INSERT INTO hlt_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Lucik a cing daengah Aaron khaw tingtunnah dap thohka kah Moses taengla mael. ");
INSERT INTO hlt_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Israel ca rhoek te thui pah lamtah amih taeng lamkah conghol te lo. Conghol te a napa imkhui tarhing la a khoboei boeih taeng lamkah khaw lo saeh. A napa rhoek imkhui tarhing kah conghol te hlai nit lo ni. Te vaengah hlang te a ming neh a conghol dongah daek pah. ");
INSERT INTO hlt_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Aaron ming te Levi conghol soah daek lamtah a napa rhoek imsawn kah a lu pakhat ham conghol pakhat van saeh. ");
INSERT INTO hlt_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Te rhoek te tingtunnah dap khuikah olphong hmai ah khueh pah. Te rhoek ah ni nangmih ham kan tuentah coeng. ");
INSERT INTO hlt_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Te vaengah ka coelh hlang te ana om vetih anih te a conghol duei ni. Te vaengah nangmih rhoi taengah aka nul, amih Israel ca rhoek kah kohuetnah te kamah taeng lamloh ka hnop ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Te dongah Moses loh Israel ca rhoek te a thui pah tih amih kah khoboei boeih loh khoboei pakhat ham conghol pakhat, khoboei pakhat ham van te conghol pakhat van te a taengla a paek uh. A napa rhoek kah imsawn tarhing ah conghol hlai nit lo tih Aaron kah conghol khaw amih kah conghol lakli ah om. ");
INSERT INTO hlt_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moses loh conghol te olphong dap kah BOEIPA mikhmuh ah a hang. ");
INSERT INTO hlt_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","A vuen ah Moses te olphong dap khuila a kun vaengah Levi imkhui kah Aaron conghol tah tarha aka duei pah. Rhaiphuelh khaw phuelh. Te phoeiah tamlaep bangla a khooi pah tih noe bangla a thaih pah. ");
INSERT INTO hlt_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moses loh conghol boeih te BOEIPA mikhmuh lamloh Israel ca boeih taengla a khuen tih a sawt uh phoeiah hlang boeih a conghol te a loh uh. ");
INSERT INTO hlt_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Te phoeiah BOEIPA loh Moses te, “Boekoek koca rhoek taengah miknoek la tuemkoi ham Aaron kah conghol te olphong hmai ah khueh laeh. Te daengah nih amih kah kohuetnah te ka mikhmuh lamloh paa vetih a duek uh pawt eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","BOEIPA loh amah a uen bangla Moses loh a ngai tih a saii van. ");
INSERT INTO hlt_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Israel ca rhoek loh Moses te a voek uh tih, “M'pal uh ni he, mamih boeih m'milh uh coeng, m'milh uh coeng. ");
INSERT INTO hlt_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","BOEIPA kah dungtlungim te aka paan la aka paan boeih tah duek ni. Pal hamla khum uh mai sih a eya?” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","BOEIPA loh Aaron te, “Namah neh na ca rhoek khaw, na taengkah na pa imkhui khaw rhokso kathaesainah te phuei uh, namah neh na taengkah na ca rhoek loh na khosoihbi dongkathaesainah te phuei uh. ");
INSERT INTO hlt_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Namah manuca, na pa conghol Levi koca khaw, namah taengla lo. Nang taengah naep uh saeh lamtah namah neh namah taengkah na ca rhoek te olphong dap hmai la na om uh vaengah nang te m'bong uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Nang kah hutnah neh dap pum kah a kuek te ngaithuen uh saeh. Tedae hmuencim kah hnopai taeng neh hmueihtuk taengah mop uh boel saeh. Te daengah ni amih khaw nangmih taengah a duek uh pawt eh. ");
INSERT INTO hlt_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Nang taengah naep uh saeh lamtah dap khuikah thohtatnah cungkuem dongah tingtunnah dap kah a kuek te ngaithuen uh saeh. Tedae kholong tah nangmih taengla ha mop uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Hmuencim kah a kuek neh hmueihtuk kah a kuek te ngaithuen uh. Te daengah ni thinhulnah he Israel ca rhoek soah koep a om pawt eh. ");
INSERT INTO hlt_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Kai loh na manuca Levi te Israel ca khui lamloh ka loh coeng ne. Tingtunnah dap kah thothuengnah dongah thothueng ham nangmih te kutdoe la BOEIPA taengah m'paek coeng. ");
INSERT INTO hlt_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Tedae namah neh na taengkah na ca rhoek tah hmueihtuk kah olka boeih neh hniyan khui lamkah te nangmih kah khosoihbi la ngaithuen uh. Nangmih ham kutdoe la khosoihbi kam paek kah thohtatnah dongah thotat uh. Tedae kholong aka mop te tah duek saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Te phoeiah BOEIPA loh Aaron taengah, “Kai loh ka khosaa hut he nang taengah kam paek coeng ne, Israel ca rhoek kah hnocim boeih khui lamloh nang taengah koelhnah la, na ca taengah kumhal kah maehvae la kam paek. ");
INSERT INTO hlt_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Amih kah nawnnah boeih dongah hmai khui lamkah a cim, cim khaw nang ham om bitni. Amih kah khocang cungkuem lamkah neh a boirhaem cungkuem lamkah khaw, a hmaithennah cungkuem lakmah khaw, kai taengla a cim a cim ham mael uh te nang ham neh na ca rhoek ham ni. ");
INSERT INTO hlt_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Te te a cim, cim la ca. Tongpa boeih loh te te ca saeh lamtah nang taengah a cim la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","He khaw nang ham ni. Israel ca rhoek te thueng hmueih cungkuem khui lamloh amih kah kutdoe khosaa hoep pah. Te te nang taeng neh na capa rhoek taengah khaw, namah taengkah na canu rhoek taengah khaw kumhal kah maehvae la kam paek coeng. Na imkhui kah aka cim boeih loh te te ca saeh. ");
INSERT INTO hlt_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","BOEIPA taengah situi tha boeih neh misur thai hangcil boeih, a thaihcuek cangpai a paek uh te nang taengah kam paek. ");
INSERT INTO hlt_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","BOEIPA taengla a khuen a khohmuen kah thaihcuek boeih te nang ham om bitni. Na imkhui kah aka cim boeih loh te te ca saeh. ");
INSERT INTO hlt_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Israel khuikah yaehtaboeih boeih he nang ham ni. ");
INSERT INTO hlt_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Pumsa cungkuem bung lamkah cacuek boeih, hlang khaw, rhamsa khaw, BOEIPA ham a khuen uh te nang ham ni. Tedae hlang kah caming te tah lat rhoe lat lamtah, rhalawt rhamsa kah cacuek khaw lat kuekluek. ");
INSERT INTO hlt_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","A lat koi te hla khat a kuep ca vaengah namah loh a phu vanbangla cak shekel panga neh lat. Hmuencim kah shekel ah tah te te gerah kul lo. ");
INSERT INTO hlt_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Vaito cacuek, tuca cacuek neh maae cacuek tah lat boeh. Te rhoek kah a thii cim te hmueihtuk dongah haeh lamtah a tha te BOEIPA taengah hmaihlutnah hmuehmuei botui la phum. ");
INSERT INTO hlt_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","A saa te nang ham thueng hmueih kah a rhang banghui la om tih bantang laeng khaw nang ham ni. ");
INSERT INTO hlt_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","BOEIPA taengah Israel ca rhoek kah a paek, a cim khosaa boeih te nang ham neh na capa rhoek ham khaw namah taengkah na canu rhoek ham khaw kumhal kah maehvae la kam paek coeng. Te te nang ham neh namah taengkah na tiingan ham khaw BOEIPA mikhmuh ah kumhal lungkaeh paipi la om,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","BOEIPA loh Aaron taengah, “Amih kah khohmuen neh m'phaeng pawt vetih nang ham khoyo amih lakli ah om mahpawh. Kai tah Israel ca khui ah nang kah khoyo neh nang kah rho la ka om. ");
INSERT INTO hlt_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Israel kah parha pakhat boeih he Levi koca rhoek ham ka paek coeng ne. Tingtunnah dap kah thothuengnah dongah aka thotat amih ham a thothuengnah kah a yueng a tlang rho la ka paek. ");
INSERT INTO hlt_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Tholhnah aka phuei ham rhung neh aka duek ham rhung tah, Israel ca rhoek loh tingtunnah dap la koep mop uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Tedae tingtunnah dap kah thothuengnah dongah he Levi amah mah thothueng saeh lamtah na cadilcahma kah kumhal khosing la te rhoek loh amamih kathaesainah te phuei uh saeh. Israel ca lakli ah rho phaeng uh boel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Israel ca rhoek kah parha pakhat, BOEIPA taengah khosaa la a pom te Levi taengah rho la ka paek. Te dongah ni amih te Israel ca lakli ah rho a phaeng pawt ham ka thui,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Levi te voek lamtah amih te thui pah. Israel ca taeng lamkah parha pakhat te doe pah, te te amih taeng lamloh nangmih taengah namamih kah rho la kam paek. Te dongah parha pakhat khui lamkah parha pakhat te BOEIPA kah khosaa la tloeng uh. ");
INSERT INTO hlt_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Nangmih kah khosaa te nangmih ham canghlom khui lamkah cangpai bangla, va-am lamkah thaihhmin bangla nawt saeh. ");
INSERT INTO hlt_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Nangmih khaw Israel ca rhoek taeng lamkah na dang na parha pakhat boeih lamkah te BOEIPA kah khosaa la tloeng uh. Te khui lamkah te BOEIPA kah khosaa la khosoih Aaron taengah pae uh. ");
INSERT INTO hlt_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Nangmih kah kutdoe cungkuem khui lamkah khaw, a rhokso kah a tha cungkuem lamkah khaw BOEIPA kah khosaa la boeih tloeng uh. ");
INSERT INTO hlt_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Te dongah amih te thui pah. Te lamkah a a kuel tha la na tloeng uh khaw Levi ham tah cangtilhmuen kah cangthaih neh va-am kah a thaih la a nawt bitni. ");
INSERT INTO hlt_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Te te na hmuen takuem neh na imkhui ah ca uh. Te te tingtunnah dap ah nangmih kah thothuengnah a yueng a tlang la nangmih kah thapang ni. ");
INSERT INTO hlt_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Te khui lamkah a tha te na tloeng uh vaengah tholhnah la na phuei uh mahpawh. Te dongah Israel ca rhoek kah hmuencim te na poeih uh pawt daengah ni na duek uh pawt eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","BOEIPA loh Moses taeng neh Aaron taengah a thui pah tih, ");
INSERT INTO hlt_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“BOEIPA kah a uen bangla olkhueng dongkah khosing he Israel ca taengah voek lamtah thui pah. Nang taengla vaito ling a hmabuet hang khuen uh saeh. Te te a soah a lolhmaih om boel saeh lamtah a soah hnamkun khuen boel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Te te khosoih Eleazar taengah pae saeh. Te phoeiah rhaehhmuen kah vongvoel la khuen saeh lamtah a mikhmuh ah ngawn saeh. ");
INSERT INTO hlt_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Te kah thii te khosoih Eleazar loh a kutdawn dongah naek saeh. Te phoeiah te kah a thii te tingtunnah dap hmai ah voei rhih haeh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Te phoeiah vaito te a mikhmuh ah hoeh saeh. A pho neh a saa khaw, a thii khaw, a aek khaw hoeh thil saeh. ");
INSERT INTO hlt_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Te phoeiah khosoih loh lamphai thing, pumpiding neh hlampai a lingdik te lo saeh lamtah vaito kah ungkhang khui la pup saeh. ");
INSERT INTO hlt_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Te phoeiah khosoih loh a himbai te suk saeh lamtah a pum khaw tui neh sil saeh. Te phoeiah rhaehhmuen la kun cakhaw khosoih te kholaeh due poeih uhla om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Te te aka hoeh long khaw a himbai te tui neh suk saeh. A pum te tui neh a silh ah pataeng hlaem due aka poeih uhla om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Te phoeiah hlang cuem loh vaito hloi te kol saeh lamtah rhaehhmuen vongvoel kah hmuen cuem ah khueh saeh. Te boirhaem tah Israel ca rhaengpuei ham khaw pumom tui dongkah tuemkoi la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Vaito hloi aka kol tah a himbai a suk phoeiah khaw hlaem due aka poeih uh la om saeh. Te dongah Israel ca ham neh amih khui ah aka bakuep yinlai ham khaw kumhal kah khosing la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Duek rhok aka ben hlang kah hinglu boeih tah hnin rhih khuiah aka poeih uhla om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","A hnin thum dongah anih te amah cilpoe uh saeh lamtah a hnin rhih dongah caihcil saeh. A hnin thum dongah a cilpoe pawt atah a hnin rhih dongah khaw caihcil mahpawh. ");
INSERT INTO hlt_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Hlang hinglu aka duek te aka ben boeih tah duek tih a cilpoe pawt atah BOEIPA kah dungtlungim te a poeih. Te dongah tekah hinglu te Israel lamloh khoe saeh. Pumom tui te a pum dongah a haeh pawt dongah a soah a tihnai kap pueng tih rhalawt. ");
INSERT INTO hlt_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","He tah dap ah hlang a duek vaengkah kah olkhueng ni. Tekah dap la aka mop boeih neh dap khuikah boeih tah hnin rhih poeih uh ni. ");
INSERT INTO hlt_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","A soah amhuep amtlaeng aka om pawt tih aka ah hnopai boeih te khaw rhalawt la om. ");
INSERT INTO hlt_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Diklai hman kah cunghang neh aka duek kah rhok khaw, hlang rhuh khaw, phuel khaw aka ben boeih tah hnin rhih poeih uh ni. ");
INSERT INTO hlt_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Hlang rhalawt ham tah boirhaem kah ungkhang laipi te loh pah lamtah am khuiah tui hing bueih thil saeh. ");
INSERT INTO hlt_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Hlang cuem loh pumpiding a loh tih tui ah a nuem phoeiah tah dap dongah khaw, hnopai boeih dongah khaw, te kah aka om hinglu boeih, te aka ben soah, a rhuh soah khaw, duek rhok soah khaw, phuel ah khaw haeh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Te phoeiah a hnin thum dong neh hnin rhih dongah tah hlang cuem loh hlang rhalawt soah haeh saeh. A hnin rhih dongah tah anih te cilpoe saeh. Te vaengah a himbai suk saeh lamtah tui hlu saeh, hlaem vaengah tah caihcil bitni. ");
INSERT INTO hlt_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Poeih uh tih aka cilpoe uh pawt hlang tah BOEIPA kah rhokso a poeih dongah hlangping khui lamloh a hinglu hnawt pah saeh. Pumom tui te anih soah a haeh pawt dongah anih te rhalawt. ");
INSERT INTO hlt_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Amih ham kumhal kah khosing la om coeng tih pumom tui aka haeh tah a himbai suk uh saeh. Te dongah pumom tui aka ben khaw hlaem duela poeih uh ni. ");
INSERT INTO hlt_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","A soah rhalawt loh a ben boeih khaw poeih uh. Te te aka ben hinglu khaw hlaem duela poeih uh ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Israel ca rhoek te hla lamhmacuek ah tah rhaengpuei boeih loh Zin khosoek la pawk uh. Pilnam te Kadesh ah kho a sak vaengah Miriam duek tih pahoi a up uh. ");
INSERT INTO hlt_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Tedae rhaengpuei ham tui om pawt tih Moses taeng neh Aaron taengah tingtun uh. ");
INSERT INTO hlt_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Te dongah pilnam loh Moses te a ho tih a voek uh hatah, “BOEIPA mikhmuh ah mamih manuca a pal vaengah m'pal uh palueng mako. ");
INSERT INTO hlt_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Bang ham nim BOEIPA kah hlangping he, kaimih neh ka rhamsa khaw pahoi duek sak ham he nim khosoek la nang khuen? ");
INSERT INTO hlt_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","He hmuen thae la kaimih khuen ham te Egypt lamloh kaimih nan caeh puei he bang ham nim? Cangti, thaibu, misur neh tale hmuen khaw tal tih ok ham tui khaw om pawh,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Te dongah Moses neh Aaron tah hlangping mikhmuh lamloh tingtunnah dap thohka la cet rhoi tih a maelhmai neh a bakop rhoi vaengah BOEIPA kah thangpomnah tah amih rhoi taengah a phoe pah. ");
INSERT INTO hlt_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Te phoeiah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Conghol te pom lamtah namah neh na manuca Aaron khaw rhaengpuei khui ah tingtun van. Amih mikhmuh ah thaelpang te voek lamtah a tui m'paek bitni. Te vaengah thaelpang lamkah tui te amih ham khuen lamtah rhaengpuei neh a rhamsa te tul,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Te dongah amah a uen van bangla Moses loh BOEIPA mikhmuh lamkah conghol te a loh. ");
INSERT INTO hlt_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Te phoeiah Moses neh Aaron tah thaelpang hmai ah hlangping neh tingtun uh tih amih te, “Hlang koek rhoek hatun uh laeh, he thaelpang lamkah nim nangmih ham tui kam paek ve?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moses loh a kut a thueng tih thaelpang te a conghol neh hnavoei a boh. Te vaengah tui muep phuet tih rhaengpuei neh a rhamsa loh a ok. ");
INSERT INTO hlt_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Tedae BOEIPA loh Moses taeng neh Aaron taengah, “Kai he Israel ca rhoek mikhmuh ah kai he a ciim la nan tangnah rhoi moenih. Te dongah hlangping he a taengah ka paek khohmuen la na pawk uh mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","He Israel ca rhoek loh BOEIPA a ho nah Meribah tui ni. Tedae amih taengah amah ciim uh coeng. ");
INSERT INTO hlt_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Kadesh lamlong tah Moses loh Edom manghai taengla puencawn a tueih tih, “Na manuca Israel he na ming, bongboepnah cungkuem loh kaimih m'mah coeng. ");
INSERT INTO hlt_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","A pa rhoek he Egypt la suntla uh tih kum te yet Egypt ah kho ka sak uh. Tedae Egypt loh kaimih taeng neh a pa rhoek taengah khaw thae a huet uh. ");
INSERT INTO hlt_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Tedae BOEIPA taengla ka pang uh dongah kaimih ol a yaak tih puencawn han tueih. Te phoeiah kaimih he Egypt lamloh n'khuen tih na khorhi bawt kah khopuei Kadesh ah ka om uh coeng he. ");
INSERT INTO hlt_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Na khohmuen lamlong he ka kat uh mai eh. Lohma long neh misurdum long khaw ka kat uh mahpawh, tuito tui khaw ka o uh mahpawh, manghai longpuei ah ni ka caeh uh eh, na khorhi ka poeng hil banvoei bantang ka phael uh mahpawh” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Tedae Edom loh anih te, “Kai longah kat boeh, nang doe hamla cunghang kang khuen ve,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Te vaengah Israel ca rhoek loh, “Longpuei ah ka cet uh mai eh. Na tui te kamah neh ka boiva long khaw ka ok atah a phu kam van paek bitni. Olka om mahpawh ka kho dongah ka kat uh mai eh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","“Cet uh boeh,” a ti neh Edom te anih doe ham pilnam hlangping neh, tlungluen kut neh pawk. ");
INSERT INTO hlt_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Israel paek ham neh a khorhi long kat ham Edom loh a aal van neh Israel khaw a taeng lamloh hoi uh. ");
INSERT INTO hlt_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Kadesh lamloh a caeh uh phoeiah Israel ca rhaengpuei boeih Hor tlang la pawk uh. ");
INSERT INTO hlt_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Edom khohmuen rhi kah Hor tlang ah BOEIPA loh Moses neh Aaron te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaron te a pilnam taengla khoem uh saeh. Meribah tui ah ka ol te nan koek uh dongah Israel ca rhoek taengah ka paek khohmuen la kun boel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aaron neh a capa Eleazar te khuen lamtah Hor tlang cet. ");
INSERT INTO hlt_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Aaron kah a himbai te pit pah lamtah a capa Eleazar te bai sak. Aaron tah duek vetih pahoi khoem uh pawn ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","BOEIPA kah a uen bangla Moses loh a ngai tih rhaengpuei boeih kah mikhmuh ah Hor tlang la cet uh. ");
INSERT INTO hlt_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Te phoeiah Moses loh Aaron kah a himbai te a pit pah tih a capa Eleazar te a bai sak. Te vaengah Aaron tah tlang lu ah pahoi duek coeng tih Moses neh Eleazar bueng te tlang lamloh suntla rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Rhaengpuei boeih loh Aaron a pal te a hmuh uh vaengah tah Aaron te Israel imkhui pum loh Khohnin sawmthum a rhah uh. ");
INSERT INTO hlt_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Tuithim kah khosa Arad manghai Kanaan loh Atharim longpuei ah Israel a pawk te a yaak vaengah Israel te a vathoh tih tamna la a sol. ");
INSERT INTO hlt_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Te vaengah Israel loh BOEIPA taengah olcaeng neh a caeng tih, “He pilnam he ka kut ah nan paek la nan paek atah a khopuei khaw ka thup bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","BOEIPA loh Israel kah ol te a yaak dongah Kanaan te a paek. Te dongah amih neh a khopuei te a thup tih a hmuen ming te Hormah a sak. ");
INSERT INTO hlt_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Hor tlang lamloh carhaek tuili longpuei la Edom khohmuen te lan ham cet uh. Tedae longpueng ah pilnam kah hinglu tah a huet pah. ");
INSERT INTO hlt_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Te dongah pilnam loh Pathen taeng neh Moses taengah, “Khosoek ah duek ham mai he balae tih Egypt lamloh kaimih nang khuen. Buh om pawh, tui om pawh. Buh kak tangkik he kaimih kah hinglu khaw a mueipuel coeng,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Te dongah BOEIPA loh pilnam taengah minyuk rhul te a tueih pah tih pilnam te a tuk dongah Israel khui lamkah pilnam muep duek. ");
INSERT INTO hlt_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Te vaengah pilnam te Moses taengla cet tih, “BOEIPA taeng neh nang taengah ka cal uh tholh coeng. BOEIPA taengah thangthui lamtah rhul te kaimih taeng lamloh khoe mai saeh,” a ti uh. Te dongah Moses te pilnam ham a thangthui pah. ");
INSERT INTO hlt_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Te dongah BOEIPA loh Moses te, “Namah loh minyuk saii lamtah rholik soah bang, te vaengah nana om bitni, rhul kah a tuk boeih loh te te a hmuh vaengah hing ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Te phoeiah Moses loh rhohum rhul te a saii tih rholik dongah a tai. Te a om phoeiah atah rhul loh hlang a tuk akhaw rhohum rhul te a paelki tih hing. ");
INSERT INTO hlt_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Te phoeiah Israel ca rhoek te thoeih uh tih Oboth ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Oboth lamloh thoeih uh tih khomik khocuk kah Moab dan, Ijeabarim khosoek ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Te lamloh cet uh tih Zered soklong ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Te lamloh cet uh tih Amori khorhi lamkah aka pawk khosoek kah Arnon rhalvangan ah rhaeh uh. Moab khorhi kah Arnon tah Moab laklo neh Amori laklo ah om. ");
INSERT INTO hlt_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Te dongah BOEIPA kah caemtloek cabu khuiah tah “Suphah kah Vaheb neh Arnon soklong,” a ti. ");
INSERT INTO hlt_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Soklong kah tuibah te Ar khosa la a doo tih Moab khorhi te a pangnat. ");
INSERT INTO hlt_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Te lamloh Beer la thoeih uh tih tekah tuito ah tah BOEIPA loh Moses te, “Pilnam te coi lamtah amih te tui ka pae eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Te vaengah Israel loh hekah laa he a hlai. Tuito phuet lah, amah te doo lah. ");
INSERT INTO hlt_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Tuito te mangpa rhoek loh a too uh tih, pilnam hlangcong rhoek loh a vueh. Mattanah khosoek lamloh a conghol neh a taem uh. ");
INSERT INTO hlt_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mattanah lamloh kaloh Nahaliel, Nahaliel lamloh Bamoth, ");
INSERT INTO hlt_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamoth lamloh Moab khohmuen kah kolrhawk, Pisgah som neh khopong hmai kah a dan la thoeih uh. ");
INSERT INTO hlt_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israel loh Amori manghai Sihon taengah puencawn a tueih tih, ");
INSERT INTO hlt_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Na khohmuen longah ka kat mai eh, lohma li neh misurdum khuiah ka ael uh mahpawh, tuito tui khaw ka o uh mahpawh, na khorhi ka poeng hil manghai longpuei bangla ka vai uh bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Tedae Sihon loh Israel te a khorhi longah kat sak pawh. Sihon loh a pilnam boeih te a coi tih Israel doe ham khosoek la cet uh. Jahaz la a pawk vaengah Israel te a tloek. ");
INSERT INTO hlt_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Te dongah Israel loh anih te cunghang ha neh a tloek tih a khohmuen te Arnon lamloh Jabbok hil, Ammon koca taeng duela a huul pa. Te vaengah Ammon koca khorhi tah cak. ");
INSERT INTO hlt_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israel ca loh te kah khopuei boeih te a loh pah. Te dongah Israel loh Amori khopuei rhoek boeih ah khaw, Heshbon neh a khobuel boeih ah khaw kho a sak. ");
INSERT INTO hlt_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Amori manghai Sihon kah khopuei Heshbon phoeiah tah lamhma kah Moab manghai te a tloek tih a kut lamkah a khohmuen pum te Arnon duela a loh. ");
INSERT INTO hlt_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Te dongah aka thuidoek rhoek loh, “Halo uh, Heshbon thoh uh lamtah Sihon khopuei khaw sikim saeh,” tila aka thuidoek rhoek loh a thui uh. ");
INSERT INTO hlt_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Hmai te Heshbon lamloh puek tih Sihon khorha lamkah hmaisai loh Arnon kah hmuensang boei, Moab Ar te a hlawp. ");
INSERT INTO hlt_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Anunae Moab nang aih te, Khemosh pilnam na milh coeng, a capa rhoek! te hlangyong la, a canu rhoek khaw Sihon Amori manghai taengah thongtla la a paek. ");
INSERT INTO hlt_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Amih te n'dong tih Heshbon tah Dibon duela milh, Medeba taengkah Nophah duela m'pong sak uh coeng,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Te dongah Israel loh Amori khohmuen ah kho a sak. ");
INSERT INTO hlt_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Te phoeiah Moses loh Jazer ah longyam la a tueih tih a khobuel rhoek te a buem, a huul uh phoeiah Amori te pahoi a vai uh. ");
INSERT INTO hlt_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Te phoeiah mael uh tih Bashan longpuei a paan uh. Te vaengah Bashan manghai Oga tah amih doe hamla amah khaw a pilnam boeih khaw, Edrei caemtloeknah la cet. ");
INSERT INTO hlt_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Tedae BOEIPA loh Moses taengah, “Anih te rhih boeh, Na kut dongah anih neh a pilnam boeih khaw, a khohmuen khaw kam paek coeng. Heshbon kah khosa, Amori manghai Sihon taengah na saii bangla anih te saii van,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Te dongah a taengah rhaengnaeng khaw a sueng pawt hil amah khaw, a ca rhoek khaw, a pilnam boeih khaw a tloek pa uh tih a khohmuen te a huul uh. ");
INSERT INTO hlt_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Te phoeiah Israel ca rhoek te cet uh tih Jerikho kah Jordan rhalvangan phai, Moab kolken ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Israel loh Amori taengah a saii boeih te Zippor capa Balak loh a hmuh. ");
INSERT INTO hlt_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Israel he khaw muep a ping dongah Moab khaw pilnam mikhmuh ah bakuep. Israel ca rhoek kah mikhmuh ah Moab a mueipuel. ");
INSERT INTO hlt_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Te dongah Moab loh Midian kah a hamca rhoek taengah, “Vaito loh khohmuen kah baelhing a laem bangla mamih kaepvai kah a cungkuem he hlangping loh a laem uh pawn ni,” a ti nah. Te vaeng tue ah Moab kah manghai tah Zippor capa Balak ni. ");
INSERT INTO hlt_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Te dongah a pilnam paca rhoek kah khohmuen tuiva kaep kah Pethor Beor capa Balaam taengah puencawn a tueih. Anih te a khue tih, “Egypt lamkah aka thoeng pilnam he, diklai hman te a khuk tih kai imdan la kho a sak he. ");
INSERT INTO hlt_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Te dongah halo lamtah he pilnam he kai lakah tah a tlung oeh dongah kai yueng la thaephoei thil mai laeh. Anih ngawn ham neh khohmuen lamloh anih ka haek thai khaming. Yoethen na paek hlang te a yoethen tih thae na phoei thil te tah thaephoei a yook te ka ming,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Te dongah Moab kah a hamca neh Midian kah a hamca rhoek khaw, amih kut khuikah bihma rhoek khaw cet uh. Balaam taengla a pha uh vaengah a taengah Balak ol te a thui uh. ");
INSERT INTO hlt_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Te vaengah amih te, “Hlaem at khaw pahoi rhaeh uh lamtah BOEIPA loh kai taengah a thui bangla nangmih taengah ol kam mael bitni,” a ti nah. Te dongah Moab mangpa rhoek tah Balaam taengah om uh. ");
INSERT INTO hlt_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Te vaengah Pathen loh Balaam te a paan tih, “Na taengkah rhoek he u hlang nim?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam loh Pathen taengah, “Moab manghai Zippor capa Balak loh kai taengla han tueih. ");
INSERT INTO hlt_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Egypt lamkah aka pawk pilnam loh diklai hman a khuk coeng ke. Te dongah halo anih te kai yueng la tap laeh. Anih tloek ham neh anih haek ham a coeng khaming,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Pathen loh Balaam te, “Amih taengah cet boeh, pilnam te a yoethen coeng tih thaephoei boeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Te dongah Balaam te mincang ah thoo tih Balak kah mangpa rhoek te, “Nangmih taengah kai caeh sak ham khaw BOEIPA loh a aal dongah namah kho la cet uh laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Te dongah Moab mangpa rhoek tah thoo uh tih Balak taengla pawk uh. Te vaengah, “Balaam loh kaimih taengah lo ham a aal,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Tedae Balak loh amih lakah a yet ngai neh aka lalh ngai mangpa rhoek te a koei tih koep a tueih. ");
INSERT INTO hlt_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Balaam taengla a pawk uh vaengah amah te, “Zippor capa Balak loh, 'Kai taengla na lo ham te uelh boeh. ");
INSERT INTO hlt_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Nang te muep kan thangpom rhoe kan thangpom vetih kai taengah na thui boeih te ka ngai bitni. Te dongah halo lamtah he pilnam he kai yueng la tap mai,’ a ti,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Tedae Balaam loh a doo tih Balak kah sal taengah, “Kai he Balak loh a im kah a bae la cak neh sui m'pae cakhaw Ka Pathen BOEIPA kah olka tah ka poe ham a coeng moenih, a yit a len khaw ngai ham ni. ");
INSERT INTO hlt_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Te dongah nangmih khaw he ah he hlaem at om uh mai laeh. Te daengah ni BOEIPA loh kai taengah thui hamla mebang a thap khaw ka ming eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Khoyin ah tah Pathen te Balaam taengla cet tih amah te, “Nang te khue ham hlang rhoek ha pawk atah thoo lamtah amih neh cet. Tedae nang taengah kanthui ol mah ngai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam te mincang ah thoo tih a laak te a khih tih Moab mangpa rhoek taengla cet. ");
INSERT INTO hlt_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Tedae anih a caeh dongah Pathen thintoek te sai. Te dongah BOEIPA puencawn tah anih te longpueng ah khingkhoekkung bangla a pai pah. Te vaengah amah te a laak dongah ngol tih a taengah a tueihyoeih rhoi om. ");
INSERT INTO hlt_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Te vaengah BOEIPA kah puencawn tah longpuei ah pai tih a kut dongah a cunghang a yueh te laak loh a hmuh. Te dongah laak te long lamloh hooi uh tih lohma la cet. Te dongah longpuei la mael sak ham Balaam lohlaak te a taam. ");
INSERT INTO hlt_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Tedae BOEIPA kah puencawn te misurdum kah longcaek ah a pai pah. He ah khaw vongtung, ke ah khaw vongtung a om pah. ");
INSERT INTO hlt_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Laak loh BOEIPA kah puencawn te a hmuh vaengah pangbueng te a nen tih Balaam kho te pangbueng dongah a nen thil. Te dongah laak a taam te a khoep. ");
INSERT INTO hlt_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Tedae BOEIPA kah puencawn loh koep a kan tih banvoei bantang la mael ham la longpuei aka om pawh hmuen ah a caek la pai. ");
INSERT INTO hlt_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Laak loh BOEIPA kah puencawn te a hmuh vaengah Balaam dangah a kol pah. Te vaengah Balaam thintoek te sai tih laak te conghol neh a taam. ");
INSERT INTO hlt_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Te vaengah BOEIPA loh laak kah aka te a ong pah tih Balaam te, “Nang taengah balae ka saii tih kai thik thum nan boh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam loh laak te, “Kai he nan poelyoe dongah he, ka kut ah cunghang om vetih nang kang ngawn laeh mako,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Laak loh Balaam te, “Kai he nang kah laak moenih a? Kai soah he tahae khohnin due koep na ngol, he he nang taengah saii ham ka hmaiben khaw ka hmaiben nim?,” a ti vaengah, “Pawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Te vaengah BOEIPA loh Balaam mik te a phen pah. Te dongah a kut ah a cunghang a pom tih longpuei ah aka pai BOEIPA kah puencawn te a hmuh. Te daengah buluk tih a thintoek neh bakop. ");
INSERT INTO hlt_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","BOEIPA kah puencawn loh anih te, “Balae tih na laak te thik thum na boh, ka hmai ah longpuei a mueng dongah kai he khingkhoekkung la ka pawk. ");
INSERT INTO hlt_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Laak loh kai m'hmuh dongah ka mikhmuh lamloh voei thum a rhael. Ka mikhmuh lamloh rhael pawt koinih nang te khaw kang ngawn pawn vetih anih bueng ka hing sak khaming. ");
INSERT INTO hlt_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam loh BOEIPA kah puencawn taengah, “Longpuei ah kai mah ham na pai te ka ming pawt dongah ka tholh coeng. Na mik ah a thae oeh atah kai he ka mael voithum mael pawn ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","BOEIPA kah puencawn loh Balaam te, “Hlang rhoek neh cet lamtah nang taengah ka thui ol te mah thui,” a ti nah. Te dongah Balaam khaw Balak kah mangpa rhoek taengah cet. ");
INSERT INTO hlt_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaam halo te Balak loh a yaak van neh khorhi khobawt, Arnon khorhi kah Moab khopuei ah anih te doe hamla cet. ");
INSERT INTO hlt_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Te vaengah Balak loh Balaam te, “Nang te khue ham nang taengah kan tueih rhoe kan tueih moenih a? Balae tih kai taengla na lo pawh, nang thangpom ham ka coeng tang moenih a?” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam loh Balak te, “Nang taengla ka pawk coeng he, ol pakhat khaw thui ham ka coeng khaw ka coeng venim? Pathen loh ka ka dongah a khueh te ka thui eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Te phoeiah Balaam te Balak taengah cet tih Kirjathhuzoth la pawk rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Te vaengah Balak loh saelhung neh boiva khaw a ngawn tih Balaam taeng neh amah taengkah mangpa rhoek taengah a thak. ");
INSERT INTO hlt_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Mincang a pha vaengah Balak loh Balaam te a loh tih Bamothbaal la a khuen. Te vaengah pilnam a bawtnah lamloh pahoi tueng. ");
INSERT INTO hlt_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam loh Balak taengah, “He ah he kai ham hmueihtuk parhih suem lamtah he ah he kai ham vaito pumrhih neh tutal pumrhih han tawn,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaam kah a thui bangla Balak loh a saii tangloeng tih Balak neh Balaam loh hmueihtuk dongah vaito neh tutal te a paan puei . ");
INSERT INTO hlt_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Te phoeiah Balaam loh Balak te, “Namah kah hmueihhlutnah taengah ana pai lamtah ka caeh vaengah kai doe hamla BOEIPA loh m'mah khaming. Kai taengah mebang ol ham phoe akhaw nang taengah ka puen bitni,” a ti nah tih caphoei cuk la cet. ");
INSERT INTO hlt_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Pathen loh Balaam te ana mah tangloeng tih a taengah, “Hmueihtuk parhih ka hol tih hmueihtuk soah vaito neh tutal ka tloeng coeng,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","BOEIPA loh Balaam kah ka ah ol a khueh phoeiah tah, “Balak taengla mael lamtah he he thui pah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Te dongah anih te a mael hatah a hmueihhlutnah taengah amah neh Moab mangpa tom te tarha pai uh. ");
INSERT INTO hlt_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Te phoeiah a thuidoeknah a poh tih, “Khothoeng tlang lamkah Moab manghai Balak loh kai he Aram lamloh m'mawt tih, 'Halo laeh, kai yueng la Jakob te thaephoei thil laeh, halo laeh, Israel te kosisah thil,’ a ti. ");
INSERT INTO hlt_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Pathen loh a tap pawt te metlam ka tap vetih, BOEIPA loh kosi a hong pawt ah metlam kosi ka hong eh? ");
INSERT INTO hlt_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Lungpang soi lamloh amah te ka hmuh tih som rhoek lamloh amah te ka mae. Pilnam he bueng he kho a sak tih namtom khuiah ana moeh moenih. ");
INSERT INTO hlt_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Jakob laipi neh Israel hlopli kah hlangmi te unim aka tae thai? Ka hinglu khaw aka thuem kah dueknah dongah duek saeh lamtah ka hmailong khaw amah la om saeh,” a ti. ");
INSERT INTO hlt_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Te vaengah Balak loh Balaam te, “Kai taengah balae na saii, ka thunkha tap ham nang kan loh dae yoethen la yoethen na paek coeng he,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Te dongah a doo tih, “BOEIPA amah loh ka ka a khueh te thui ham ka ngaithuen mahpawt nim? a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Te dongah amah te Balak loh, “Kamah neh hmuen tloe la cet khaw cet mai mai sih. Te ah ni amah te na hmuh thai eh, he lamlong tah a hmoi ni dawk na hmuh dae a cungkuem na hmuh moenih. Te dongah ke lamloh kai yueng la anih te tap laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Te phoeiah anih te Pisgah somtung kah Zophim khohmuen la a khuen. Te vaengah hmueihtuk parhih a suem tih hmueihtuk soah vaito neh tutal a nawn. ");
INSERT INTO hlt_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Te phoeiah Balak te, “Kai ke la ka pawk vaengah namah kah hmueihhlutnah taengah he ana pai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Te vaengah BOEIPA loh Balaam te a mah tih a ka dongah ol a sang pah phoeiah, “Balak taengah mael lamtah he he thui pah,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Te phoeiah a taengla a mael hatah anih kah hmueihhlutnah taengah amah kah Moab mangpa rhoek khaw tarha ana pai uh. Te vaengah Balak loh anih te, “BOEIPA loh balae a thui,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Te dongah a thuidoeknah te a poh tih, “Balak aw thoo lamtah hnatun lah, Zippor capa khaw kai taengla hnakaeng lah. ");
INSERT INTO hlt_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Pathen tah laithae hlang pawt tih hlang capa bangla dam a ti a? A ti coeng phoeiah a saii moenih a? A thui phoeiah a thoh puei moenih a? ");
INSERT INTO hlt_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Yoethen paek ham ka dang dongah a yoethen coeng tih ka yueh thai moenih ne. ");
INSERT INTO hlt_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Jakob khuiah boethae te paelki pawt tih Israel khuiah thakthaenah a hmuh moenih. A Pathen Yahweh tah a taengah om tih a khui ah manghai kah tamlung la a om pah. ");
INSERT INTO hlt_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Pathen loh amih te Egypt lamloh amah taengah cung ki bangla a khuen. ");
INSERT INTO hlt_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Jakob te lung loh a noeng moenih, Israel te bihma loh a noeng moenih. Pathen loh Jakob neh Israel ham mebang a saii khaw a tue van vaengah a thui. ");
INSERT INTO hlt_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Pilnam te sathuengnu bangla a thoh tih sathueng bangla a kuel. Maeh a ngaeh tih salaem thii a ok duela yalh tlaih pawh. ");
INSERT INTO hlt_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Te dongah Balak loh Balaam te, “Anih tap ham khaw tap boel lamtah yoethen sak ham khaw anih te yoethen pae boeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaam loh a doo tih Balak taengah, “Thui ham koi te nang taengah kan thui moenih a?A cungkuem dongah BOEIPA kah a thui te ni ka saii eh. ");
INSERT INTO hlt_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Te phoeiah Balak loh Balaam taengah, “Cet mai dae sih, hmuen tloe la nang kang khuen saeh lamtah Pathen mik ah thuem mai khaming. Te lamloh kai yueng la anih te tap mai,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Te dongah Balak loh Balaam te khopong hmai la aka dan Peor somtung la a khuen. ");
INSERT INTO hlt_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam loh Balak te, “He ah he kai ham hmueihtuk parhih suem lamtah he ah he kai ham vaito pumrhih neh tutal pumrhih han tawn,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Te dongah Balaam kah a thui bangla Balak loh a ngai tih vaito neh tutal hmueihtuk soah a nawn. ");
INSERT INTO hlt_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Israel yoethen paek te BOEIPA mikhmuh ah hoeikhang tila Balaam loh a hmuh dongah lung te doe ham voei vai khaw cet pawh. Te dongah a maelhmai te khosoek la a khueh. ");
INSERT INTO hlt_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaam loh a mik a huel vaengah Israel te amah koca la kho a sak tih Pathen Mueihla a soah a om te a hmuh. ");
INSERT INTO hlt_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Te vaengah a thuidoeknah te a poh tih Beor capa Balaam olphong neh mikdai dai hlang kah olphong te a thui. ");
INSERT INTO hlt_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Pathen ol aka ya kah olphong tah Tlungthang mikhlam aka tla te a hmuh tih a mik a dai. ");
INSERT INTO hlt_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Jakob nang kah dap neh Israel nang kah dungtlungim tah metlam a hoeikhang. ");
INSERT INTO hlt_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Soklong bangla langdai, tuiva kah dum bangla, BOEIPA kah a phung thingul bangla, tui taengkah lamphai bangla, ");
INSERT INTO hlt_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","A tuiduen lamloh tui sih tih a tiingan khaw tui yet dongah om. A manghai Agag lakah a vetih a ram a phueih ni. ");
INSERT INTO hlt_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Pathen loh anih te Egypt lamloh amah taengah cung ki bangla a loh. A rhal namtom te a ngaeh coeng dongah a rhuh te a cilh vetih a thaltang neh a phop ni. ");
INSERT INTO hlt_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Sathueng neh sathuengnu bangla koisu tih yalh phoeiah tah anih aka haeng te unim? Nang loh yoethen na paek te a yoethen tih nang loh thae na phoei khaw thaephoei a yook. ");
INSERT INTO hlt_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Te vaengah Balak kah thintoek te Balaam taengah sai tih a kut te a paeng. Balak loh Balaam te, “Ka thunkha rhoek te tap ham ni nang kang khue dae he rhoek kah yoethen la voei thum yoethen na paek coeng he. ");
INSERT INTO hlt_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Te dongah namah hmuen la nang te yong laeh. Nang te kan thangpom rhoe kan thangpom eh ka ti coeng dae BOEIPA loh nang te thangpomnah lamkah n'hloh coeng ne,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Te dongah Balaam loh Balak te, “Kai taengla na puencawn nan tueih taengah khaw ka thui moenih a? ");
INSERT INTO hlt_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Kai he Balak loh cak neh sui a im kah a bae la m'pae cakhaw BOEIPA olka te poe hamla ka coeng moenih. Then cakhaw thae cakhaw ngai ham om. Ka lungbuei lamlong pataeng BOEIPA kah a thui te ni ka thui eh ka ti. ");
INSERT INTO hlt_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Kai tah ka pilnam taengla ka cet pawn ni he. Halo lamtah hmailong tue ah he pilnam loh na pilnam soah a saii ham te nang kang uen eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Te phoeiah a thuidoeknah a dangrhoek tih Beor capa Balaam kah olphong neh mik aka dai hlang kah olphong te a thui. ");
INSERT INTO hlt_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Pathen kah olthui aka ya tih Khohni mingnah aka ming, tlungthang mikhlam aka hmu tih a bakop doela mik aka dai kah olphong loh, ");
INSERT INTO hlt_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Amah te ka hmuh dae tahae ah moenih, amah te ka mae dae yoei pawh. Jakob lamkah aisi thoeng vetih Israel lamloh mancai thoo ni. Moab baengki a phop pah vetih Seth koca te boeih a phuet ni. ");
INSERT INTO hlt_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom kah a pang om vetih a thunkha Seir kah a pang om cakhaw Israel loh thadueng neh a saii ni. ");
INSERT INTO hlt_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Jakob lamloh a taemrhai vetih khopuei kah rhaengnaeng te a milh sak ni. ");
INSERT INTO hlt_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Amalek te a hmuh vaengah a thuidoeknah a poh tih, “Amaklek tah namtom kah a tongnah la om dae a hmailong tah pocinah la om. ");
INSERT INTO hlt_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Keni te a hmuh vaengah a thuidoeknah te a poh tih, “Na ngolhmuen khangmai tih thaelpang soah bu na khueh. ");
INSERT INTO hlt_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Tedae hatah Assyria loh nang n'sol duela Kain te hlup hamla om bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","A thuidoeknah a poh tih, “Anunae Pathen loh te a saii vaengah unim aka hing ve? ");
INSERT INTO hlt_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Kittim lihmoi lamkah timbaw rhoek neh Assyria khaw phaep uh ni. Eber khaw a phaep uh ni. Tedae amah khaw pocinah ham ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Te phoeiah Balaam te thoo tih aka cet te amah hmuen la mael. Te dongah Balak khaw amah longpuei la cet. ");
INSERT INTO hlt_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israel te Shittim ah kho a sak vaengah pilnam tah cukhalh hamla Moab nu rhoek taengah poeih uh. ");
INSERT INTO hlt_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Te vaengah pilnam te amih kah pathen hmueih kung la a khue uh. Te dongah pilnam loh a caak tih amih kah pathen taengah bakop uh. ");
INSERT INTO hlt_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Tedae Israel te Baalpeor neh a sun uh dongah BOEIPA kah thintoek tah Israel taengah sai. ");
INSERT INTO hlt_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Te vaengah BOEIPA loh Moses te, “Pilnam kah a lu boeih te khuen lamtah amih te khosae kah BOEIPA hmai ah hoeng laeh. Te daengah ni BOEIPA kah thintoek thinsa he Israel lamloh a mael eh?,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Te dongah Moses loh Israel kah laitloek rhoek taengah, “A hlang rhoek khuiah Baalpeor taengla aka sun hlang te ngawn,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Te vaengah Israel ca rhoek khui lamkah hlang pakhat te pakcak ha pawk tih a manuca rhoek taengkah Moses mikhmuh neh tingtunnah dap thohka kah aka rhap Israel ca rhaengpuei boeih kah mikhmuh ah Median nu te a khuen pah. ");
INSERT INTO hlt_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Khosoih Aaron capa Eleazar koca Phinekha loh a hmuh vaengah rhaengpuei lakli lamloh thoo tih a kut dongah cai a muk. ");
INSERT INTO hlt_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Te phoeiah Israel hlang hnukah popuei khuila kun tih a boktlap la Israel tongpa neh huta te a kotak hil a thun. Te daengah lucik khaw Israel ca taeng lamloh cing. ");
INSERT INTO hlt_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Tedae lucik ah aka duek he thawng kul thawng li lo. ");
INSERT INTO hlt_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Te phoeiah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Amih lakli ah ka thatlainah neh ka thatlai vaengah Khosoih Aaron capa Eleazar koca Phinekha loh ka kosi te Israel ca rhoek taeng lamkah a mael sak. Te dongah ni Israel ca rhoek te ka thatlainah neh ka khah pawh. ");
INSERT INTO hlt_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Te dongah thui pah, ka paipi he a taengah rhoepnah la ka paek coeng. ");
INSERT INTO hlt_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","A Pathen ham a thatlai pah tih Israel ca rhoek ham a dawth pah yueng te anih ham neh amah hnukkah a tiingan ham kumhal ah khosoihbi paipi la om ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Te vaengah Median nu neh a ngawn la a ngawn Israel hlang a ming tah, Simeon napa im kah khoboei Salu capa Zimri, ");
INSERT INTO hlt_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Median nu a ngawn uh kah a ming tah amah Midian khuiah a napa im kah namtu boeilu, Zur canu Kozbi ni. ");
INSERT INTO hlt_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Te phoeiah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Median te daengdaeh lamtah amih te ngawn. ");
INSERT INTO hlt_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Amih loh nangmih te a rhaithinah neh n'daengdaeh. Peor kah ol dongah khaw Midian khoboei canu Kozbi kah ol dongah nangmih te n'rhaithi bal. Peor ol bangla a tanu te lucik hnin ah ngawn,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Lucik a om hnukah BOEIPA loh Moses neh khosoih Aaron capa Eleazar te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Israel ca rhaengpuei boeih hlangmi te tongpaca khui lamloh kum kul neh a so hang tah a napa imko neh Israel khuiah caempuei la aka cet boeih te soep laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Te dongah Moses neh khosoih Eleazar loh amih te Moab kolken kah Jerikho Jordan ah a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Tongpaca khui lamkah kum kul neh a so hang tah BOEIPA kah a uen bangla tae,” a ti nah. Moses neh Egypt kho lamkah aka coe Israel ca rhoek tah, ");
INSERT INTO hlt_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Israel caming Reuben lamloh Reuben koca rhoek, Enok lamloh Hanokhi koca, Pallu lamloh Pallu koca, ");
INSERT INTO hlt_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Khetsron lamloh Khetsron koca, Karmee lamloh Karmee koca, ");
INSERT INTO hlt_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Reuben koca he a soep vaengah thawng sawmli thawng thum neh ya rhih sawmthum lo. ");
INSERT INTO hlt_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Pallu koca lamloh Eliab, ");
INSERT INTO hlt_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliab koca la Nemuel, Dathan neh Abiram tih, Dathan neh Abiram tah Moses neh Aron aka hnuei rhaengpuei khuikah mingthang neh pang rhoi. BOEIPA taengah a hnueih uh vaengkah Korah hlangboel khuiah khaw om rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Diklai loh a ka te a ang tih amih te a dolh vaengah Korah hlangboel tah duek. Hmai loh a hlawp hlang yahnih sawmnga khaw rholik banghui la om uh. ");
INSERT INTO hlt_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Tedae Korah ca rhoek a duek uh moenih. ");
INSERT INTO hlt_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simeon koca khaw amamih cako ah, Nemuel lamloh Nemuel koca, Jamin lamloh Jamin koca, Jakhin lamloh Jakhin koca, ");
INSERT INTO hlt_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zerah lamloh Zarkhii koca, Saul lamloh Saul koca, ");
INSERT INTO hlt_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Simeon koca he thawng kul thawng hnih neh ya hnih lo. ");
INSERT INTO hlt_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gad ca rhoek khaw amah cako ah, Zephon lamloh Zephon koca, Hakki lamloh Hakki koca, Shuni lamloh Shuni koca, ");
INSERT INTO hlt_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni lamloh Ozni koca, Eri lamloh Eri koca, ");
INSERT INTO hlt_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod lamloh Arodi koca, Areli lamloh Areli koca, ");
INSERT INTO hlt_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Gad ca rhoek kah koca he thawng sawmli neh ya nga la a soep. ");
INSERT INTO hlt_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Judah ca rhoi he Er neh Onan dae Er neh Onan te Kanaan khohmuen ah duek. ");
INSERT INTO hlt_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Judah ca rhoek khaw amah koca la om uh. Shelah lamloh Shelahni koca, Perez lamloh Perez koca, Zerah lamloh Zarkhii koca, ");
INSERT INTO hlt_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Perez ca rhoek ah, Khetsron lamloh Khetsron koca, Hamul lamloh Hamul koca la om uh. ");
INSERT INTO hlt_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Amih Judah koca rhoek he thawng sawmrhih thawng rhuk neh ya nga la a soep. ");
INSERT INTO hlt_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Issakhar koca khaw amah cako lamtah, Tola lamkah Tola koca, Puvah lamloh Puni koca, ");
INSERT INTO hlt_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jashub lamloh Jashub koca, Shimron lamloh Shimron koca, ");
INSERT INTO hlt_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Issakhar koca he thawng sawmrhuk thawng li ya thum la a soep. ");
INSERT INTO hlt_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zebulun ca rhoek khaw amah cako lamtah Sered lamloh Sered koca, Elon lamloh Eloni koca, Jahleel lamloh Jahleel koca om. ");
INSERT INTO hlt_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Amih Zebulon koca rhoek he thawng sawmrhuk neh ya nga la a soep. ");
INSERT INTO hlt_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Joseph ca rhoek he amah cako lamtah Manasseh neh Ephraim. ");
INSERT INTO hlt_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manasseh koca la, Makir lamloh Makir koca om. Te dongah Makir loh Gilead a sak tih Gilead lamloh Giladi koca la om. ");
INSERT INTO hlt_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Gilead ca rhoek he, Iezer lamloh Iezer koca, Helek lamloh Heleki koca, ");
INSERT INTO hlt_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel lamloh Asriel koca, Shekhem kah Shekhemi koca, ");
INSERT INTO hlt_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shemida kah Shemida koca, Hepher kah Hepher koca, ");
INSERT INTO hlt_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Hepher capa Zelophehad he a taengah ca tongpa om pawt tih huta rhoek dawk om. Zelophehad canu rhoek kah a ming tah Mahlah, Noah, Hoglah, Milkah neh Tirzah ");
INSERT INTO hlt_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Manasseh koca rhoek he khaw a hlangmi la thawng sawmnga thawng hnih neh ya rhih la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ephraim ca rhoek he amah koca lamtah, Shuthela lamloh Shutheli koca, Bekher lamloh Bekeri koca, Tahan lamloh Tahani koca la om. ");
INSERT INTO hlt_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Shuthela ca rhoek he khaw, Eran lamloh Erani koca la om. ");
INSERT INTO hlt_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ephraim ca koca rhoek he a hlangmi la thawng sawmthum thawng hnih neh ya nga la a soep uh. He rhoek he Joseph ca rhoek lamkah amih koca rhoek ni. ");
INSERT INTO hlt_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Benjamin kah ca lamkah amih koca rhoek he, Bela lamloh Belee koca, Ashbel lamloh Ashbeli koca, Akhiram lamloh Akhirami koca la, ");
INSERT INTO hlt_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shupham lamloh Shuphami koca la, Hupham lamloh Humphami koca la om. ");
INSERT INTO hlt_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Bela ca rhoi Ard neh Naaman om. Ardee koca neh Naaman lamkah Naamani koca om. ");
INSERT INTO hlt_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Benjamin ca rhoek he amah koca ah tah a hlangmi la thawng sawmli thawng nga neh ya rhuk la a soep uh. ");
INSERT INTO hlt_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dan ca rhoek he amah koca ah tah Shuham lamloh Shuhami koca la om. He rhoek ni amih koca khuiah Dan koca la aka om. ");
INSERT INTO hlt_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Shuhami koca boeih he a hlangmi la thawng sawmrhuk thawng li neh ya li la a soep. ");
INSERT INTO hlt_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Asher ca rhoek he amah koca ah tah, Imnah lamloh Imnah koca la, Ishee lamloh Jesuih koca la, Beriah lamloh Breiah koca la, ");
INSERT INTO hlt_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beriah ca rhoi, Heber lamloh Herbari koca la, Malkhiel lamloh Makhiel koca om. ");
INSERT INTO hlt_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asher kah canu ming tah Serah ni. ");
INSERT INTO hlt_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Asher ca rhoek kah koca he a hlangmi lamtah kah thawng sawmnga thawng thum neh ya li soep. ");
INSERT INTO hlt_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Naphtali ca rhoek he amah koca lamtah, Jahzeel lamloh Jahzeeli koca la, Guni lamloh Goni koca la, ");
INSERT INTO hlt_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezer lamloh Jezeri koca la, Shillem lamloh kah Shillemi koca la om. ");
INSERT INTO hlt_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Naphtali koca rhoek he amah koca lamtah a hlangmi khaw thawng sawmli thawng nga neh ya li lo uh. ");
INSERT INTO hlt_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Israel ca rhoek he hlangmi la thawng ya rhuk neh thawngkhat ya rhih sawmthum lo. ");
INSERT INTO hlt_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Te phoeiah BOEIPA loh Moses te voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Amih te a ming tarhing ah khohmuen he rho la tael uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Miping ham tah a rho te len sak lamtah a sii ham tah a rho te hnop pah. Hlang te a ka neh a soep tarhing ah a rho te phaeng saeh. ");
INSERT INTO hlt_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Khohmuen te hmulung loh dawk tael saeh lamtah a napa koca rhoek kah ming tarhing la pang uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","hmulung kah a ka tarhing ah hlangping neh hlangsi laklo ah a rho te tael saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Levi rhoek kah hlangmi he amah koca lamtah, Gershon lamloh Gershon koca, Kohath lamloh Kohathi koca, Merari lamloh Merari koca la om. ");
INSERT INTO hlt_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","He Levi koca khui lamkah, Libni koca, Khebroni koca, Makhali koca, Musihe koca, Korah koca om tih Kohath loh Amram a sak. ");
INSERT INTO hlt_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amram kah a yuu ming tah Levi canu Jochebed ni. Anih te Egypt ah Levi ham a cun pah coeng. Anih long khaw Amram ham Aaron, Moses neh a ngannu Miriam te a cun pah. ");
INSERT INTO hlt_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaron loh Nadab neh Abihu, Eleazar neh Ithamar a sak. ");
INSERT INTO hlt_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Tedae Nadab neh Abihu tah BOEIPA mikhmuh ah kholong hmai a khuen rhoi dongah duek rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Te vaengah amih kah hlangmi aka om rhoek tongpa hlakhat ca neh a so hang boeih tah thawng kul neh thawng thum la a soep uh. Tedae amih te Israel ca lakli ah rho a phaeng pawt dongah Israel ca rhoek lakli ah soep uh thil pawh. ");
INSERT INTO hlt_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","He rhoek he Moses neh khosoih Eleazar loh a soep vaengah Jerikho Jordan kah Moab kolken ah Israel ca rhoek te a soep rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Tedae Moses neh khosoih Aaron kah a soep khui lamloh Sinai khosoek kah Israel ca rhoek a soep vaengkah hlang te tah te rhoek taengah thum pawh. ");
INSERT INTO hlt_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Amih te khosoek ah duek rhoe duek ham khaw, Jephunneh capa Kaleb neh Nun capa Joshua bueng pawt atah amih lamkah hlang a sueng pawt ham khaw BOEIPA loh a thui coeng dongah ni. ");
INSERT INTO hlt_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Joseph capa Manasseh koca kah, Manasseh capa Makir kah a ca Gilead capa patoeng Hepher capa Zelophehad canu rhoek te kun uh. A canu rhoek ming he Mahlah, Noah, Hoglah, Milkah neh Tirzah. ");
INSERT INTO hlt_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Amih te Moses mikhmuh neh khosoih Eleazar mikhmuh ah, tingtunnah dap thohka kah khoboei rhoek neh rhaengpuei boeih kah mikhmuh ah pai uh tih, ");
INSERT INTO hlt_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“A pa he khosoek ah duek tih amah he BOEIPA aka tuentah kah hlangboel lakli neh Korah kah hlangboel khuiah khaw a om moenih. Amah kah tholhnah dongah duek tih a taengah ca tongpa om pawh. ");
INSERT INTO hlt_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Balae tih a cako khui lamloh a pa ming a hma eh? A taengah ca tongpa a om pawt neh a pa kah manuca lakli ah kaimih he khohut m'pae van,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Te dongah Moses loh amih kah laitloeknah te BOEIPA mikhmuh la a khuen. ");
INSERT INTO hlt_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Te dongah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Zelophehad canu rhoek kah a thui te thuem, amih te a napa kah pacaboeina lakli ah rho la khohut te pae rhoela pae. A napa rho te amih taengah mael. ");
INSERT INTO hlt_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Israel ca rhoek te voek lamtah thui pah. Hlang he duek tih a taengah ca tongpa a om pawt atah anih kah rho te a canu taengah mael. ");
INSERT INTO hlt_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Anih te canu a om pawt atah anih kah rho te a manuca taengah pae. ");
INSERT INTO hlt_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Anih te manuca a om pawt bal atah anih kah rho te a napa kah a manuca taengah pae. ");
INSERT INTO hlt_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","A napa te a manuca a om pawt atah anih kah rho te a cako khuiah anih neh aka yoei a thii a saa taengah pae lamtah pang saeh. BOEIPA loh Moses a uen bangla Israel ca rhoek ham laitloeknah khosing la om saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Te phoeiah BOEIPA loh Moses te, “Abarim tlang ah he yoeng lamtah Israel ca rhoek taengah ka paek khohmuen te so lah. ");
INSERT INTO hlt_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Te te na hmuh van phoeiah tah na maya Aaron a khoem uh bangla nang khaw na pilnam taengla na khoem uh ni. ");
INSERT INTO hlt_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Rhaengpuei kah tohhaemnah dongah Zin khosoek ah ol na koek dongah. Zin khosoek, Kadesh Meribah tui kung, amih mikhmuh kah tui taengah kai he nan ciim ham om ta a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Te dongah Moses loh BOEIPA te a thui pah tih, ");
INSERT INTO hlt_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Pumsa boeih kah Mueihla Pathen BOEIPA loh rhaengpuei soah hlang pakhat khueh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Anih te amih mikhmuh ah vuenva vetih amih mikhmuh ah kunael bitni. Te vaengah amih a khuen vetih amih te a pawk puei bitni. Te dongah amih, BOEIPA kah hlangboel he a dawn pawh boiva bangla om mahpawh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","BOEIPA loh Moses taengah, “Nun capa Joshua te namah taengla lo. Tekah hlang tah a soah mueihla a om dongah anih te na kut tloeng thil. ");
INSERT INTO hlt_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Anih te khosoih Eleazar mikhmuh neh rhaengpuei boeih kah mikhmuh ah pai sak lamtah amah te amih mikhmuh ah rhep uen. ");
INSERT INTO hlt_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Na mueithennah te anih taengah na pak daengah ni Israel ca rhoek rhaengpuei boeih loh a ngai uh eh. ");
INSERT INTO hlt_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Te vaengah khosoih Eleazar mikhmuh ah pai saeh lamtah BOEIPA mikhmuh ah Urim kah laitloeknah bangla anih te dawt saeh. Amah taengkah Israel ca boeih neh rhaengpuei boeih taengah khaw a ol bangla vuenva uh saeh lamtah anih ol bangla kunael uh saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","BOEIPA loh amah a uen bangla Moses loh a saii. Te dongah Joshua te a khuen tih khosoih Eleazar mikhmuh neh rhaengpuei boeih kah mikhmuh ah anih te a pai sak. ");
INSERT INTO hlt_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Te phoeiah tah anih soah a kut a tloeng tih BOEIPA loh Moses kut ah a thui bangla anih te a uen. ");
INSERT INTO hlt_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Israel ca te uen lamtah amih te thui pah. Kai kah nawnnah neh kai buh khaw, kai kah hmaihlutnah ham kamah kah hmuehmuei botui te amah khoning vaengah kai taengla khuen ham ngaithuen uh. ");
INSERT INTO hlt_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Te dongah he he amih te thui pah. Sainoek hmueihhlutnah dongah hnin at ham tu kum khat ca, a hmabuet pumnit te BOEIPA taengah hmaihlutnah la khuen uh. ");
INSERT INTO hlt_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Mincang ah tu pumat nawn lamtah tu pabae te kholaeh vaengah nawn. ");
INSERT INTO hlt_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Khocang ham tah cangnoek parha dongkah vaidam te bunang pali dongkah a sui situi neh thoek pah. ");
INSERT INTO hlt_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Sainoek hmueihhlutnah he Sinai tlang ah ni BOEIPA taengkah hmaihlutnah hmuehmuei botui la ana saii coeng. ");
INSERT INTO hlt_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Tuisi bunang pali neh tu pumat te hmuencim ah BOEIPA kah cangsi tuisi la suep. ");
INSERT INTO hlt_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Tuca pabae mincang kah khosaa neh a tuisi bangla kholaeh ah saii lamtah BOEIPA taengah hmuehmuei botui hmaihlutnah la nawn. ");
INSERT INTO hlt_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Sabbath hnin ah tah kumkhat tu ca a hmabuet pumnit, a tuisi situi neh a thoek khocang vaidam doh nit te nawn. ");
INSERT INTO hlt_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Sabbath ah he Sabbath hmueihhlutnah phoeiah sainoek hmueihhlutnah neh tuisi khaw khueh pah. ");
INSERT INTO hlt_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Nangmih kah hla sae vaengah BOEIPA taengah hmueihhlutnah ham saelhung ca vaito pumnit, tutal pumat neh, kumkhat tu ca a hmabuet pumrhih te nawn. ");
INSERT INTO hlt_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Vaito pumat dongah situi neh a thoek khocang vaidam doh thum, tutal pakhat ham situi neh a thoek khocang vaidam doh nit saeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Hmaihlutnah Tuca pumat dongah situi neh a thoek khocang vaidam doh at, doh at saeh lamtah BOEIPA taengah hmuehmuei botui hmaihlutnah la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Amih kah tuisi la misurtui he vaito pumat dongah bunang ngancawn cet saeh lamtah tutal pumat dongah bunang khoi thum saeh, tu pumat dongah bunang khoi li saeh. He he kum khat kah hla khat takuem hlasae vaengah hlasae kah hmueihhlutnah la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","BOEIPA taengkah boirhaem la maae ca pumat phoeiah khaw sainoek hmueihhlutnah te a tuisi neh nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Hla lamhmacuek kah hlasae hnin hlai li vaengah BOEIPA taengla Yoom om ni. ");
INSERT INTO hlt_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Tekah hla dongkah hnin hlai nga vaengah hnin rhih khotue ah vaidamding ca saeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","A cuek hnin ah hmuencim kah tingtunnah om saeh lamtah thohtatnah bitat boeih tah saii uh boeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","BOEIPA taengah hmueihhlutnnah hmaihlutnah na nawn vaengah saelhung ca vaito pumnit neh tutal pumat, tu kum khat ca pumrhih he nangmih taengah hmabuet la om uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Situi neh a thoek a khocang vaidam te vaito pumat dongah doh thum saeh lamtah tutal ham tah doh nit saii pah. ");
INSERT INTO hlt_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Tu pumrhih dongah tu pumat ham doh at, doh at saii pah. ");
INSERT INTO hlt_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Nangmih ham aka dawth la boirhaem maae ca khaw pumat saeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Mincang kah hmueihhlutnah phoeiah sainoek hmueihhlutnah ham khaw he rhoek he saii uh. ");
INSERT INTO hlt_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","hmaihlutnah buh he hnin rhih khuiah hnin takuem BOEIPA taengah hmuehmuei botui neh, sainoek hmueihhlutnah neh a tuisi khaw nawn saeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","A hnin rhih dongah tah nangmih ham hmuencim kah tingtunnah la om saeh. Te vaengah thohtanah bitat boeih tah saii uh boeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","BOEIPA taengah khocang a thai na nawn uh vaengkah thaihcuek khohnin ah khaw nangmih ham hmuencim kah tingtunnah te yalh khat khuiah om saeh lamtah nangmih kah thohtatnah bitat boeih tah saii uh boeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Tedae saelhung ca dongkah vaito pumnit neh tutal pumat, kumkhat tu ca pumrhih te BOEIPA taengah hmueihhlutnah hmuehmuei botui la khuen uh. ");
INSERT INTO hlt_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Situi neh a thoek a khocang vaidam te vaito pumat dongah doh thum saeh lamtah tutal pumat dongah doh nit saeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Tuca pumrhih dongah tuca pumat ham te doh at, doh at saeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Nangmih ham tholh aka dawth la maae ca pumat saeh. ");
INSERT INTO hlt_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Sainoek hmueihhlutnah voel ah khaw a khosaa khueh lamtah a tuisi neh nangmih taengah hmabuet la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","A hla rhih dongkah hlasae a hnin khat vaengah nangmih ham hmuencim kah tingtunnah om saeh. Nangmih ham tamlung khohnin la a om dongah thohtatnah kah bitat boeih tah saii boeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","BOEIPA taengah hmuehmuei botui la saelhung ca vaito pumat, tutal pumat, tu kumkhat ca a hmabuet pumrih neh hmueihhlutnah saii uh. ");
INSERT INTO hlt_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Amih kah khocang tah situi neh a thoek vaidam saeh lamtah vaito pumat dongah doh thum, tutal pumat dongah doh nit saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Tuca pumrhih ham khaw tuca pumat dongah doh at saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Nangmih ham aka dawth la maae ca pumat te boirhaem la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Hlasae kah hmueihhlutnah neh a khocang voel ah, sainoek hmueihhlutnah neh a khocang khaw, a tuisi khaw a laitloeknah bangla BOEIPA taengah hmaihlutnah hmuehmuei botui la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","A hla rhih dongkah a hnin rha vaengah nangmih ham a cim tingtunnah om. Te vaengah na hinglu te phaep uh lamtah bitat boeih te saii uh boeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","BOEIPA taengah hmueihhlutnah te hmuehmuei botui kuen uh lamtah saelhung vaito ca pumat tutal pumat, tu kum khat ca a hmabuet pumrhih te namamih ham om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Situi neh a thoek a khocang vaidam he vaito pumat dongah doh thum, tutal pumat dongah doh nit saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Tuca pumrhih ham khaw tu pumat dongah doh at, doh at saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Maae ca pumat te boirhaem la om saeh. Tholh dawthnah boirhaem voel ah sainoek hmueihhlutnah neh a khocang khaw a tuisi khaw om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Hla rhih dongkah hnin hlai nga vaengah nangmih ham hmuencim kah tingtunnah om saeh. Thohtatnah bitat boeih tah saii uh boel lamtah BOEIPA ham hnin rhih khuiah khotue te lam uh. ");
INSERT INTO hlt_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","BOEIPA taengah hmuehmuei botui hmaihlutnah ham hmueihhlutnah a khuen uh vaengkah, saelhung ca vaito pum hlai thum khaw, tutal rhoi khaw, tu kum khat ca hlai li te khaw hmabuet la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Situi neh a thoek a khocang vaidam khaw, vaito pum hlai thum vaengah vaito pumat dongah doh thum, tutal pumnit vaengah tutal pumat dongah doh nit saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","Tuca hlai li vaengah tuca pumat dongah doh at doh at saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Maae ca pumat te boirhaem la om saeh. Sainoek hmueihhlutnah voel ah a khocang neh a tuisi om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","A hnin bae dongah saelhung ca vaitotal pum hlai nit, tutal pumnit, tu kum khat ca a hmabuet pum hlai li saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","A khocang neh a tuisi te laitloeknah bangla amah tarhing ah vaitotal rhoek ham khaw, tutal rhoek ham khaw, tuca rhoek ham khaw om pah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Sainoek hmueihhlutnah, a khocang neh a tuisi voel ah maae ca pumat te boirhaem la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","A hnin thum dongah vaito pum hlai khat, tutal pumnit, tu kum at ca a hmabuet pum hlai li saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","A khocang neh a tuisi te laitloeknah bangla amah tarhing ah vaitotal rhoek ham khaw, tutal rhoek ham khaw, tuca rhoek ham khaw om pah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Sainoek hmueihhlutnah neh a khocang, a tuisi voel ah maae ca pumat te boirhaem la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","A hnin li dongah vaito pumrha, tutal pumnit, tu kum at ca a hmabuet pum hlai li saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","A khocang neh a tuisi te laitloeknah bangla amah tarhing ah vaitotal rhoek ham khaw, tutal rhoek ham khaw, tuca rhoek ham khaw om pah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Sainoek hmueihhlutnah, a khocang neh a tuisi voel ah maae ca pumat te boirhaem la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","A hnin nga dongah vaito pumko, tutal pumnit, tu kum at ca a hmabuet pum hlai li saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","A khocang neh a tuisi te laitloeknah bangla amah tarhing ah vaitotal rhoek ham khaw, tutal rhoek ham khaw, tuca rhoek ham khaw om pah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Sainoek hmueihhlutnah, a khocang neh a tuisi voel ah maae ca pumat te boirhaem la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","A hnin rhuk dongah vaito pumrhet, tutal pumnit, tu kum at ca a hmabuet pum hlai li saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","A khocang neh a tuisi te laitloeknah bangla amah tarhing ah vaitotal rhoek ham khaw, tutal rhoek ham khaw, tuca rhoek ham khaw om pah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Sainoek hmueihhlutnah, a khocang neh a tuisi voel ah maae ca pumat te boirhaem la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","A hnin rhih dongah vaito pumrhih, tutal pumnit, tu kum at ca a hmabuet pum hlai li saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","A khocang neh a tuisi te a laitloeknah bangla amah tarhing ah vaitotal rhoek ham khaw, tutal rhoek ham khaw, tuca rhoek ham khaw om pah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Sainoek hmueihhlutnah, a khocang neh a tuisi voel ah maae ca pumat te boirhaem la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","A hnin rhet dongah tah nangmih ham pahong la om vetih thohtatnah bitat boeih tah saii uh boeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Hmueihhlutnah dongah vaitotal pumat, tutal pumat, tu kum khat ca a hmabuet pumrhih te BOEIPA taengah hmaihlutnah hmuehmuei botui la khuen uh. ");
INSERT INTO hlt_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","A khocang neh a tuisi te laitloeknah bangla amah tarhing ah vaitotal rhoek ham khaw, tutal rhoek ham khaw, tuca rhoek ham khaw om pah saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Sainoek hmueihhlutnah, a khocang neh a tuisi voel ah maae ca pumat te boirhaem la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Na olcaeng neh na kothoh lamkah a voel ah, na hmueihhlutnah neh na khocang ham khaw, na tuisi neh na rhoepnah ham khaw nangmih kah khoning vaengah BOEIPA ham saii uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Te dongah BOEIPA loh Moses taengah a cungkuem a uen bangla Moses loh Israel ca rhoek taengah a thui pah. ");
INSERT INTO hlt_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moses loh Israel ca rhoek koca kah boeilu rhoek te a voek tih BOEIPA loh a uen bangla ol he a thui pah. ");
INSERT INTO hlt_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Tongpa he BOEIPA taengah olcaeng a caeng vaengah khaw, a hinglu dongah rhuikhih te khih ham olhlo a toemngam vaengah khaw a ol te poeih boel saeh. A ka lamloh a thoeng bangla boeih saii saeh. ");
INSERT INTO hlt_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Huta he BOEIPA taengah olcaeng a caeng tih a camoe ah a napa im kah rhuikhih loh a khih mai ni. ");
INSERT INTO hlt_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","A hinglu dongah a khih a olcaeng neh a rhuikhih te a napa loh a yaak dae a napa loh anih te a ngam tak. Te vaengah a olcaeng boeih te cak vetih a hinglu dongah a khih rhuikhih boeih te khaw cak ni. ");
INSERT INTO hlt_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","A napa loh a yaak hnin ah anih te khaban koinih a olcaeng boeih neh a hinglu dongkah a khih a rhuikhih te cak mahpawh. Te vaeng daengah napa loh anih te a khaban dae BOEIPA loh anih te khodawk a ngai ni. ");
INSERT INTO hlt_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","A va taengah om khaw om mai tih amah sokah a olcaeng neh a hmuilai kah olhlo te a hinglu dongah a khih khaming. ");
INSERT INTO hlt_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Te vaengah a va loh a yaak tih a yaak hnin ah pataeng anih te hil a phah tak atah a olcaeng te cak vetih a hinglu dongah a khih a rhuikhih te cak ni. ");
INSERT INTO hlt_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Tedae a va loh a yaak hnin ah anih te a khaban khaming. Te vaengah amah sokah a olcaeng neh a hinglu dongah a khih a hmuilai kah olhlo khaw a phae coeng dongah BOEIPA loh anih te khodawk a ngai ni. ");
INSERT INTO hlt_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Nuhmai olcaeng neh vama kah a hinglu dongah a khih boeih boeih tah amah soah pai ni. ");
INSERT INTO hlt_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","A va im kah a caeng mai akhaw, olhlo lamloh a hinglu dongah rhuikhih a khih akhaw, ");
INSERT INTO hlt_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","A va loh a yaak vaengah a taengah hil a phah tih anih khaban pawt daengah ni a olcaeng boeih cak vetih a hinglu dongah a khih a rhuikhih boeih khaw a cak eh. ");
INSERT INTO hlt_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","A va loh a yaak hnin ah te te a phae, a phae tih a hmuilai kah aka thoeng boeih, a olcaeng khaw, a hinglu dongkah rhuikhih khaw cak sak mai mahpawh. Te rhoek te a va loh a phae dongah BOEIPA loh huta te khodawk a ngai ni. ");
INSERT INTO hlt_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Olcaeng cungkuem neh, hinglu aka phaep ham rhuikhih olhlo cungkuem he a va loh a cak sak mai tih a va loh a phae mai thai. ");
INSERT INTO hlt_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Tedae a taengah a va te a hnin hnin ah a ngam la ngam khaming. A yaak hnin ah pataeng a taengah a ngam dongah huta kah olcaeng boeih te cak tih a sokah a rhuikhih boeih cak. ");
INSERT INTO hlt_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","A yaak neh te te a phae la a phae atah huta kah amah lothaesainah te phueih saeh. ");
INSERT INTO hlt_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","He oltlueh he tongpa laklo neh a yuu taengkah ham, pa laklo a camoe kah a napa im ah aka om a canu ham BOEIPA loh Moses te a uen pah. ");
INSERT INTO hlt_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Na pilnam te coi lamtah Israel ca rhoek kah tawnlohnah neh Median soah phulo laeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Te dongah Moses loh pilnam te a voek tih, “Na taeng lamkah hlang rhoek te caempuei la pumcum saeh lamtah Midian soah BOEIPA kah tawnlohnah paek ham Midian cuuk uh thil saeh. ");
INSERT INTO hlt_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Israel koca boeih khui lamloh koca khat ah thawng khat, koca khat ah thawng khat rhip te caempuei la tueih uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Te dongah Israel a thawng a thawng khui lamloh koca khat ah thawng khat te hol uh tih thawng hlai nit te caempuei la pumcum uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Te phoeiah Moses loh amih koca pakhat lamkah thawng te caempuei la a tueih. Te vaengah khosoih Eleazar capa Phinekha khaw a kut dongkah hmuencim hnopai neh tamlung olueng neh caempuei la cet. ");
INSERT INTO hlt_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Te dongah BOEIPA loh Moses te a uen bangla Midian te a muk uh tih tongpa boeih te a ngawn uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Midian manghai rhoek te khaw amih kah rhok dongah a ngawn uh. Midian manghai panga, Evi neh Rekem khaw, Zur neh Hur khaw, Reba neh Beor capa Balaam khaw cunghang neh a ngawn uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Israel ca rhoek loh Midian kah huta camoe khaw a rhamsa boeih neh a boiva boeih a mawt uh tih a thadueng boeih khaw a poelyoe pauh. ");
INSERT INTO hlt_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Amih kah tolrhum lakli, a khopuei boeih neh a lumim boeih khaw hmai neh a hoeh pa uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Kutbuem boeih khaw, hlang neh rhamsa dongkah a hnorhawt boeih khaw a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Te phoeiah tamna neh kutbuem hnorhawt te khaw Jerikho kah Jordan kaep, Moab kolken kah rhaehhmuen kah Moses taeng neh khosoih Eleazar taengah, Israel ca rhaengpuei taengla a khuen uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moses, khosoih Eleazar neh rhaengpuei kah khoboei boeih khaw amih doe hamla rhaehhmuen vongvoel la tawn uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Tedae caem aka soep thawng khat mangpa rhoek neh caempuei caemtloek lamkah aka pawk yakhat mangpa taengah Moses a thintoek. ");
INSERT INTO hlt_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Te phoeiah amih te Moses loh, “Huta tah boeih na hlun uh nama?”. ");
INSERT INTO hlt_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Peor kah olka dongah BOEIPA taeng lamloh boekoeknah la hol uh ham Balaam kah ol lamloh Israel ca rhoek taengla amih ha pawk coeng ne. Te dongah ni lucik loh BOEIPA kah hlangboel a tlak thil. ");
INSERT INTO hlt_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Te dongah camoe lakli kah tongpa boeih te ngawn uh lamtah tongpa kah thingkong dongah tongpa aka ming huta boeih khaw ngawn uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Tedae huta khuiah khaw tongpa kah thingkong aka ming hlan camoe boeih tah namamih ham hlun uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Nangmih hinglu aka ngawn boeih neh rhok aka ben boeih tah hnin rhih khuiah rhaehhmuen vongvoel la rhaeh uh. A hnin thum neh a hnin rhih dongah namamih neh na tamna te khaw cilpoe uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Himbai boeih neh maehpho dongkah hnopai boeih, maae lamkah bitat boeih neh thing hnopai boeih khaw cilpoe uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","BOEIPA loh Moses taengah a uen bangla olkhueng dongkah khosing he, khosoih Eleazar loh caemtloek la aka cet caempuei hlang rhoek taengah, ");
INSERT INTO hlt_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","“Sui neh cak, rhohum, thi, samphae neh kawnlawk, ");
INSERT INTO hlt_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","Hmai aka khoeng hno boeih tah hmai ah caeh sak uh lamtah caihcil bitni. Pumom tui neh cilpoe saeh lamtah hmai loh a khoeng pawt boeih tahtui dongah caeh sak uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","A hnin rhih dongah na himbai te na suk uh tih na caihcil uh phoeiah rhaehhmuen la kun uh ,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Hnorhawt dongkah hlangmi te, na hlang kah tamna neh rhamsa khaw, khosoih Eleazar neh rhaengpuei kah a napa rhoek hlangmi khaw tae uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Caempuei la a khuen tih caem aka tu laklo neh rhaengpuei boeih laklo ah hnorhawt te tael pah. ");
INSERT INTO hlt_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Caempuei la aka cet caemtloek hlang rhoek khui lamloh ya nga vaengah hinglu pakhat tah hlang khaw, saelhung khaw, laak khaw, boiva khaw BOEIPA taengah mangmu la tloeng. ");
INSERT INTO hlt_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","A rhakthuem te lo lamtah BOEIPA kah khosaa la khosoih Eleazar ham pae. ");
INSERT INTO hlt_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Israel ca rhoek kah te a rhakthuem ah coelh pah. Sawmnga lamloh pakhat tah hlang khaw, saelhung khaw, laak khaw, boiva khaw, rhamsa khaw boeih tu lamtah BOEIPA kah dungtlungim loh a kuek aka ngaithuen Levi taengah pae,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","BOEIPA loh Moses a uen vanbangla Moses neh khosoih Eleazar loh a saii. ");
INSERT INTO hlt_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Caempuei pilnam loh a poelyoe hnorhawt dong lamloh maeh coih la aka om he boiva he thawng ya rhuk neh thawng sawmrhih thawng nga, ");
INSERT INTO hlt_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","saelhung thawng sawmrhih neh thawng hnih, ");
INSERT INTO hlt_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","Laak thawng sawmrhuk neh thawng khat lo. ");
INSERT INTO hlt_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","Hlang kah hinglu khaw tongpa kah thingkong aka ming pawh huta he a pum la hinglu thawng sawmthum thawng nit lo. ");
INSERT INTO hlt_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Caempuei la aka kun kah hamsum rhakthuem he a pum la boiva thawng ya thum neh thawng sawmthum thawng rhih ya nga lo. ");
INSERT INTO hlt_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","BOEIPA kah mangmu te boiva dong lamloh ya rhuk sawmrhih panga, ");
INSERT INTO hlt_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Saelhung thawng sawmthum thawng rhuk lo. Te vaengah BOEIPA ham amih kah mangmu te sawmrhih pumnit lo. ");
INSERT INTO hlt_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Laak thawng thumkip neh ya nga vaengah BOEIPA ham amih mangmu pum sawmrhuk pakhat lo . ");
INSERT INTO hlt_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Hlang kah hinglu khaw thawng hlai rhuk vaengah BOEIPA ham amih kah mangmu te hinglu thumkip panit lo. ");
INSERT INTO hlt_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Te dongah BOEIPA loh Moses a uen vanbangla BOEIPA kah khosaa mangmu te Moses loh khosoih Eleazar taengah a paek. ");
INSERT INTO hlt_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Israel ca rhakthuem lamloh caem aka muk hlang taeng lamkah khaw Moses loh a tael pah. ");
INSERT INTO hlt_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Hlangboel rhakthuem lamloh boiva thawng ya thum neh thawng sawmthum thawng rhih ya nga lo . ");
INSERT INTO hlt_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","Saelhung he thawng thumkip neh thawng rhuk lo . ");
INSERT INTO hlt_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","Laak thawng sawmthum neh ya nga lo . ");
INSERT INTO hlt_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","Hlang kah hinglu thawng hlai rhuk lo . ");
INSERT INTO hlt_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Israel ca rhoek rhakthuem dongkah te Moses a loh. Sawmnga ah pakhat tah hlang lamkah khaw, rhamsa lamkah khaw a loh tih BOEIPA loh Moses a uen bangla BOEIPA dungtlungim kah a kuek aka ngaithuen Levi taengah a paek. ");
INSERT INTO hlt_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Te phoeiah caempuei a thawng thawng aka soep, thawng khat mangpa rhoek neh yakhat mangpa rhoek tahMoses taengla mop uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Moses taengah, “Na sal rhoek loh caemtloek hlang rhoek kah boeilu te a tae uh vaengah mamih lamkah he kaimih kut hmuiah hlang he a hmaai moenih. ");
INSERT INTO hlt_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Te dongah BOEIPA mikhmuh ah kaimih kah hinglu ham aka dawth la hlang loh a hmuh sui hnopai, cak neh khungpak, kutcaeng, hnathawn neh oilung te BOEIPA nawnnah ham kang khuen,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Te dongah Moses neh khosoih loh Eleazar amih taeng lamkah sui neh kutsai hnopai boeih te a doe. ");
INSERT INTO hlt_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Te dongah thawngkhat mangpa rhoek neh yakhat mangpa rhoek taeng lamloh BOEIPA taengah khosaa la a tloeng uh sui boeih he shekel thawng hlai rhuk ya rhih sawmnga lo. ");
INSERT INTO hlt_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Caempuei hlang rhoek long khaw amah kah hlang te a poelyoe uh. ");
INSERT INTO hlt_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Te phoeiah Moses neh khosoih Eleazar lohthawngkhat neh yakhat mangpa rhoek lamkah sui te a doe tih tingtunnah dap la BOEIPA mikhmuh ah Israel ca rhoek ham poekkoepnah la a khuen. ");
INSERT INTO hlt_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Te vaengah Reuben ca rhoek te boiva muep om tih Gad ca taengah khaw ping uh khungdaeng. Te phoeiah Jazer khohmuen neh Gilead khohmuen te a sawt vaengah a hmuen khaw boiva hmuen la tarha a hmuh uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Te dongah Gad koca rhoek neh Reuben koca rhoek te cet uh tih Moses taeng neh khosoih Eleazar taengah khaw, rhaengpuei khoboei rhoek taengah khaw a thui uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Te vaengah Ataroth neh Dibon, Jazer neh Nimrah, Heshbon neh Elealeh, Sibam, Nebo, Beon, ");
INSERT INTO hlt_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Isreal rhaengpuei kah mikhmuh ah BOEIPA loh a ngawn khohmuen te boiva kah khohmuen tih na sal rhoek taengah khaw boiva om ta,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Te phoeiah, “Na mik ah mikdaithen ka hmuh atah he khohmuen he na sal rhoek taengah khohut la m'paek vetih Jordan te kaimih nam paan sak pawt mako,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Tedae Moses loh Gad koca rhoek taeng neh Reuben koca rhoek taengah, “Nangmih hela na ngol uh vaengah na manuca rhoek tah caemtloek la cet uh saeh a? ");
INSERT INTO hlt_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","BOEIPA loh amih taengah a paek khohmuen la kat ham te balae tih Israel ca rhoek kah lungbuei he a khaban la na khaban uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Khohmuen sawt ham Kadeshbarnea lamloh amih ka tueih vaengah na pa rhoek loh he ni a saii uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Eshkol soklong la cet uh tih khohmuen khaw a hmuh uh dae BOEIPA loh amih taengah a paek khohmuen la kun pawt ham Israel ca rhoek kah lungbuei te a khaban uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Amah khohnin ah BOEIPA kah thintoek sai tih a toemngam. ");
INSERT INTO hlt_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Egypt lamkah aka lo hlang rhoek khuiah kum kul neh a so hang ca rhoek tah khohmuen te hmu uh mahpawh. Te te Abraham, Isaak taeng neh Jakob taengah ka toemngam dae kai hnukah a tlun uh moenih. ");
INSERT INTO hlt_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Kenizzi Jephunneh capa Kaleb neh Nun capa Joshua tah BOEIPA hnukah tlun rhoi. ");
INSERT INTO hlt_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Te vaengah BOEIPA kah thintoek te Israel taengah sai tih BOEIPA mik ah boethae aka saii kah cadil boeih a cing hil amih te khosoek ah kum sawmli a poengdoe sak. ");
INSERT INTO hlt_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Israel taengah BOEIPA kah thintoek thinsa te koep khoengvoep ham ni na pa rhoek yueng hlangtholh hlang kah tahoengnah dongah na pai uh he. ");
INSERT INTO hlt_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","A hnuk lamloh na phael uh dongah khosoek ah amih tloeng ham koep a koei vetih he pilnam boeih he na mit uh bitni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Te phoeiah a taengla mop uh tih, “Kaimih kah boiva ham boiva kah tanglung neh ka ca rhoek ham khopuei pahoi ka thoh uh mako. ");
INSERT INTO hlt_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Tedae amih te a hmuen la ka pawk uh hil tah kaimih he Israel ca mikhmuh ah tawn uh ham ka pumcum uh bitni. Te vaengah khohmuen kah khosa rhoek mikhmuh lamkah hmuencak khopuei rhoek ah mamih kah camoe rhoek ana om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Israel ca rhoek khuikah hlang loh a rho a pang hlanah ka im la ka mael uh mahpawh. ");
INSERT INTO hlt_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Jordan kah rhalvangan neh a voel kah amih neh m'phaeng uh boel saeh. Jordan khocuk ngan ah kaimih taengah kamamih kah rho om coeng,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Te dongah Moses loh amih te, “He ol he na ngai uh mak atah, caemtloek ham BOEIPA mikhmuh ah na pumcum uh mak atah, ");
INSERT INTO hlt_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Nangmih aka pumcum boeih te tah BOEIPA mikhmuh ah Jordan te a poeng vetih a thunkha rhoek te a mikhmuh lamloh a haek ni. ");
INSERT INTO hlt_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","BOEIPA mikhmuh ah khohmuen a khoem uh coeng. Te dongah mael uh lamtah BOEIPA taeng neh Israel taengah ommongsitoe la na om uh bitni. Khohmuen he BOEIPA mikhmuh ah nangmih kah khohut la om bitni. ");
INSERT INTO hlt_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Te te na saii uh pawt atah BOEIPA taengah na tholh coeng ne. Te vaengah namamih kah tholhnah loh nangmih m'hmuh bitni tila ming uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Nangmih ham neh na camoe ham khopuei khaw, na tu ham tanglung khaw thoh uh. Tedae nangmih ka lamloh aka thoeng te rhoi uh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Te phoeiah Gad koca rhoek neh Reuben koca rhoek loh Moses taengah, “Na sal rhoek long he ka boei kah a uen bangla a saii uh bitni. ");
INSERT INTO hlt_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Ka yuu rhoek neh ka ca rhoek, ka boiva neh ka rhamsa boeih tah Gilead khopuei rhoek ah pahoi om uh bitni. ");
INSERT INTO hlt_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Ka boei kah na thui bangla, BOEIPA mikhmuh ah caempuei la aka pumcum na sal rhoek tah caemtloek la boeih kat bitni ni,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Amih kongah Moses loh khosoih Eleazar, Nun capa Joshua neh Israel ca rhoek kah koca, a napa boeilu rhoek te a uen. ");
INSERT INTO hlt_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Te vaengah Moses loh amih te, “BOEIPA mikhmuh ah caemtloek la aka pumcum Gad koca rhoek neh Reuben ca boeih tah nangmih taengah Jordan te kat uh coeng. Nangmih mikhmuh ah khohmuen te a khoem uh dongah Gilead khohmuen te amih taengah khohut la pae. ");
INSERT INTO hlt_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Nangmih taengah aka pumcum uh khaw a kat uh pawt atah Kanaan khohmuen ah tah nangmih khui kah te bawn uh saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gad koca rhoek neh Reuben koca rhoek loh a doo uh tih, “BOEIPA loh na sal rhoek taengah a thui bangla ka saii uh tangloeng bitni. ");
INSERT INTO hlt_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Kaimih BOEIPA mikhmuh ah aka pumcum rhoek tah Kanaan khohmuen la ka kat uh ni. Tedae Jordan rhalvang he tah kaimih kah rho neh kaimih ham khohut la om saeh,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Te dongah Moses loh amih, Gad koca rhoek taeng neh Reuben koca rhoek taengah khaw, Joseph capa Manasseh koca hlangvang taengah khaw, Amori manghai Sihon kah ram, Bashan manghai Oga kah ram neh khohmuen, khohmuen kaepvai khopuei rhibawn kah a khopuei te a paek. ");
INSERT INTO hlt_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Te dongah Gad koca rhoek loh, Dibon, Ataroth neh Aroer, ");
INSERT INTO hlt_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Aroth-shonphan, Jazer neh Jobehah, ");
INSERT INTO hlt_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bethnimrah neh Bethharan, hmuencak khopuei rhoek neh boiva kah tanglung te a thoh uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Reuben koca rhoek loh Heshbon, Elealeh neh Kiriathaim, ");
INSERT INTO hlt_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo neh ming aka hoi Baalmeon, Sibam te a thoh uh. Te kah a thoh uh khopuei rhoek ming te a ming neh a khue uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Manasseh capa Makir koca rhoek tah Gilead la cet uh tih a buem uh. Te vaengah a khui kah Amori te a haek uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Te dongah Moses loh Gilead te Manasseh capa Makir taengah a paek tih a khuiah kho a sak uh. ");
INSERT INTO hlt_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Manasseh capa Jair loh cet tih a vangca rhoek te loh dongah te rhoek te Jair vangca a sui. ");
INSERT INTO hlt_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobah khaw cet tih Kenath neh a khobuel rhoek te a loh. Te dongah te te amah ming la Nobah a sui. ");
INSERT INTO hlt_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","He tah Moses neh Aaron kut hmuiah amamih kah caempuei neh Egypt kho lamloh a coe uh vaengkah Israel ca rhoek kah longcaeh ni. ");
INSERT INTO hlt_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moses loh BOEIPA olka bangla a longpueng kah a pongthohnah te a daek. He rhoek he a longpueng uh vaengkah amih kah pongthohnah ni. ");
INSERT INTO hlt_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","A hla lamhmacuek dongkah hla sae hnin hlai nga dongah Raameses lamloh cet uh. Yoom vuen ah Israel ca rhoek te coe uh tih Egypt pum kah mikhmuh ah kut a thueng uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Te vaengah BOEIPA loh a ngawn Egypt te a up uh. Amih kah caming boeih neh a pathen rhoek soah BOEIPA loh tholhphu a thuung. ");
INSERT INTO hlt_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Israel ca rhoek te Raameses lamloh cet tih Sukkoth ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Sukkoth lamloh cet uh tih khosoek hmoi kah Etham ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Etham lamloh a caeh uh vaengah Baalzephon rhaldan kah Pihahiroth la mael uh tih Migdol rhaldan ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Pihahiroth rhaldan lamloh a caeh uh vaengah tuipuei laklung ah khosoek la kat uh. Etham khosoek ah hnin thum longcaeh te cet uh tih Marah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Marah lamloh cet uh tih Elim la pawk uh. Elim ah tuiphuet tui hlai nit neh rhophoe sawmrhih om tih pahoi rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Elim lamloh cet uh tih carhaek tuipuei ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Carhaek tuipuei lamloh cet uh tih Sin khosoek ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Sin khosoek lamloh cet uh tih Dophkah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Dophkah lamloh cet uh tih Alush ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Alush lamloh cet uh tih Rephidim ah rhaeh uh. Tedae teah te pilnam kah a ok ham tui om pawh. ");
INSERT INTO hlt_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Rephidim lamloh cet uh tih Sinai khosoek ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Sinai khosoek lamloh cet uh tih Kiborthhattaavah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Kiborthhattaavah lamloh cet uh tih Hazeroth ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Hazeroth lamloh cet uh tih Rithmah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Rithmah lamloh cet uh tih Rimmonperez la rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Rimmonperez lamloh cet uh tih Libnah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Libnah lamloh cet uh tih Rissah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Rissah lamloh cet uh tih Kehelathah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Kehelathah lamloh cet uh tih Shepher tlang ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Shepher tlang lamloh cet uh tih Haradah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Haradah lamloh cet uh tih Makheloth ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Makheloth lamloh puen uh tih Tahath ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Tahath lamloh cet uh tih Terah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Terah lamloh cet uh tih Mithkah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Mithkah lamloh cet uh tih Hashmonah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Hashmonah lamloh cet uh tih Moserah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Moserah lamloh cet uh tih Benejaakan ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Benejaakan lamloh cet uh tih Horhagidgad ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Horhagidgad lamloh cet uh tih Jobathah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Jobathah lamloh puen uh tih Abronah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Abronah lamloh puen uh tih Eziongeber ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Eziongeber lamloh cet uh tih Kadesh kah Zin khosoek ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Kadesh lamloh cet uh tih Edom khohmuen bawt kah Hor tlang ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Hor tlang ah tah khosoih Aaron khaw BOEIPA kah olka bangla cet coeng tih Egypt kho lamloh Israel ca rhoek a coe uh phoeikah kum likip, hla nga, hlasae cuek vaengah pahoi duek. ");
INSERT INTO hlt_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaron he a kum ya pakul pathum a lo ca vaengah Hor tlang ah duek. ");
INSERT INTO hlt_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Te vaengah Kanaan khohmuen ah Israel ca rhoek a pawk te tuithim kah kho aka sa Arad manghai Kanaan loh a yaak. ");
INSERT INTO hlt_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Hor tlang lamloh puen uh tih Zalmonah ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Zalmonah lamloh puen uh tih Punon ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Punon lamloh puen uh tih Oboth ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Oboth lamloh puen uh tih Moab khorhi kah Ijeabarim ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Iyim lamloh puen uh tih Gad Dibon ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Gad Dibon lamloh puen uh tih Almondiblathaim ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Almondiblathaim lamloh puen uh tih Nebo rhaldan kah Abarim tlang ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Abarim tlang lamloh puen uh tih Jerikho Jordan kah lo Moab kolken ah rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Jordan kah Moab kolken ah te Bethjeshimoth lamloh Abelshittim duela rhaeh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Jerikho Jordan kah Moab kolken ah BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Israel ca rhoek te voek lamtah amih te thui pah. Nangmih Kanaan khohmuen la Jordan te kat uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","Te vaengah khohmuen kah khosa boeih te na mikhmuh lamloh haek uh. Amih kah ngaihlihnah cungkuem te thup uh lamtah a mueihlawn mueihlip boeih te khaw thup uh. Amih kah hmuensang boeih te khaw tulh uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Khohmuen te pang uh lamtah a khuiah khosa uh. Khohmuen te pang hamla nangmih taengah kam paek coeng. ");
INSERT INTO hlt_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Khohmuen te hmulung neh tael uh. Nangmih kah koca aka ping ham tah a rho te kum sak lamtah a sii ham tah a rho te sih pah. Amah ham hmulung dongah a naan te tah anih ham om pawn vetih na pa rhoek kah koca tarhing ah pang uh. ");
INSERT INTO hlt_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Khohmuen kah khosa rhoek te na mikhmuh lamloh na haek uh pawt atah amih lamkah na sueng sak uh te nangmih mik ah miktlaeh banlga, nangmih kaep ah tlaeh la om ni. A khuikah kho na sak nah khohmuen ah nangmih te n'daengdaeh uh ni. ");
INSERT INTO hlt_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Amih taengah saii ham ka cai vanbangla nangmih taengah khaw ka saii ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Israel ca rhoek te uen lamtah amih te thui pah. Nangmih Kanaan khohmuen la aka kun rhoek aw, khohmuen he tah nangmih ham Kanaan khohmuen kah rho la a rhibawn neh ha yalh bitni. ");
INSERT INTO hlt_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Tuithim baengki ah Zin khosoek lamloh Edom ngong phai Edom te nangmih ham om bitni. Tuithim khorhi tah lungkaeh li a bawt lamloh khothoeng hil nangmih ham om bitni. ");
INSERT INTO hlt_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Nangmih ham khorhi tah tuithim kah Akrabbim kham ah a hil vetih Zin a poeng duela om ni. Te phoeiah Kadeshbarnea tuithim lamloh a hmoi ah pawk vetih Hazaraddar a pha phoeiah Azmon la pawk ni. ");
INSERT INTO hlt_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Azmon lamkah soklong khorhi te Egypt la a hil vetih a bawtnah tuipuei ah om ni. ");
INSERT INTO hlt_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Khotlak kah khorhi te khaw tuipuei len hil te nangmih ham om vetih khotlak khorhi te nangmih ham khorhi la om ni. ");
INSERT INTO hlt_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Tlangpuei khorhi te tuipuei len lamloh nangmih ham om vetih Hor tlang te namamih ham thuun thil uh. ");
INSERT INTO hlt_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Hor tlang lamloh Lebokhamath te thuun uh lamtah khorhi hmoi te Zedad la pawk saeh. ");
INSERT INTO hlt_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Te phoeiah khorhi te Ziphron la pawk vetih Hazarenan ah a bawt om ni. He tah nangmih ham tlangpuei kah khorhi la om ni. ");
INSERT INTO hlt_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Khothoeng kah khorhi te Hazarenan lamloh Shepham duela nangmih ham thuun sak. ");
INSERT INTO hlt_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Riblah Shepham lamkah khorhi te Ayin khothoeng ah suntla saeh lamtah khorhi aka suntla te khothoeng kah Kinnereth tuipuei kah hlaep la khoe saeh. ");
INSERT INTO hlt_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Khorhi te Jordan la suntla bal saeh lamtah a bawtnah te lungkaeh li ah om saeh. He tah khohmuen kaepvai ah nangmih ham rhilung la om ni,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Te phoeiah Moses loh Israel ca rhoek te a uen tih, “BOEIPA loh koca pako neh koca rhakthuem taengah paek ham a uen vanbangla khohmuen he hmulung neh tael uh. ");
INSERT INTO hlt_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","A napa rhoek kah imsawn tarhing ah Reuben ca rhoek kah koca neh a napa rhoek imsawn tarhing ah Gad ca rhoek koca loh a yo uh. Amih kah rho te Manasseh koca rhakthuem a loh. ");
INSERT INTO hlt_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Koca panit neh koca rhakthuem loh a rho te khothoeng ah khocuk kah Jerikho Jordan kah rhalvangan ah a doe uh coeng, ” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","He kah ming aka om hlang rhoi, khosoih Eleazar neh Nun capa Joshua loh nangmih ham khohmuen han tael bitni. ");
INSERT INTO hlt_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Khoboei khaw koca pakhat lamloh khoboei pakhat tah khohmuen aka tael la lo. ");
INSERT INTO hlt_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","He hlang rhoek a ming tah, Judah koca lamloh Jephunneh capa Kaleb, ");
INSERT INTO hlt_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Simeon ca rhoek kah koca lamloh Ammihud capa Samuel, ");
INSERT INTO hlt_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Benjamin koca lamloh Khislon capa Elidad, ");
INSERT INTO hlt_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Dan ca rhoek koca kah khoboei Jogli capa Bukki, ");
INSERT INTO hlt_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Joseph capa Manasseh ca rhoek kah koca lamloh Ephod capa khoboei Hanniel, ");
INSERT INTO hlt_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Ephraim ca rhoek kah koca lamloh Shiphtan capa khoboei Kemuel, ");
INSERT INTO hlt_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Zebulun ca rhoek kah koca lamloh Parnach capa khoboei Elizaphan, ");
INSERT INTO hlt_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Issakhar ca rhoek kah koca lamloh Azzan capa khoboei Paltiel, ");
INSERT INTO hlt_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Asher ca rhoek kah koca lamloh Shelomi capa khoboei Ahihud, ");
INSERT INTO hlt_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Naphtali ca rhoek kah koca lamloh Ammihud capa khoboei Pedahel saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Te rhoek te Kanaan khohmuen ah Israel ca rhoek phaeng sak ham BOEIPA loh a uen. ");
INSERT INTO hlt_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","BOEIPA loh Moses te Jerikho Jordan kah Moab kolken ah a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Israel ca rhoek te uen lamtah amih kah khohut rho lamloh Levi te pae uh saeh. Khosa ham khopuei rhoek neh a kaepvai ah khopuei kah khocaak te Levi ham pae uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Te daengah ni amih khosa rhoek ham khaw khopuei om vetih a rhamsa ham neh a khuehtawn ham khaw, a mulhing cungkuem ham khaw a khocaak a om eh. ");
INSERT INTO hlt_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Khopuei kah khocaak te khopuei pangbueng lamloh vongvoel kaepvai dong thawngkhat hil tah Levi taengah pae uh. ");
INSERT INTO hlt_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Te dongah khopuei kah vongvoel lamloh khothoeng ben te dong thawng hnih, tuithim ben te dong thawng hnih, khotlak ben te dong thawng hnih, tlangpuei ben te dong thawng hnih suem pah. A laklung kah khopuei tah amih ham khopuei kah khocaak la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Khopuei khuiah khaw hlipyingnah khopuei parhuk te Levi taengah pae uh. Te te hlang aka ngawn tah te la rhaelrham sak ham pae uh. Amih te khopuei sawmli panit pae uh. ");
INSERT INTO hlt_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Levi taengah na paek uh khopuei boeih amih kah khocaak nen tah kho sawmli parhet lo saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Khopuei te Israel ca kah khohut khui lamloh pae uh. A yet taeng lamkah tah kum sak uh lamtah a sii taeng lamkah tah sih pa uh. Hlang long he amah rho dongkah olka tarhing ah a pang vanbangla a khopuei khui lamkah te Levi taengah pae saeh,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","BOEIPA loh Moses te a voek tih, ");
INSERT INTO hlt_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Israel ca rhoek te voek lamtah amih te thui pah. Nangmih te Kanaan kho khuila Jordan na kat uh vaengah, ");
INSERT INTO hlt_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","Namamih ham khopuei kang uh lamtah nangmih ham hlipyingnah khopuei la om saeh. Te daengah ni tohtamaeh ah hinglu a boh tih aka ngawn loh te lam a rhaelrham eh. ");
INSERT INTO hlt_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Te vaengah khopuei rhoek te nangmih taengah hinglu aka suk taeng lamloh hlipyingnah la om saeh. Te daengah ni laitloeknah dongah rhaengpuei mikhmuh la a pai hlan hilah hlang aka ngawn te a duek pawt eh. ");
INSERT INTO hlt_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Khopuei parhuk na paek uh te nangmih ham hlipyingnah khopuei la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Khopuei pathum te Jordan kah rhalvangan ah pae uh lamtah khopuei pathum te Kanaan khohmuen ah pae uh. ");
INSERT INTO hlt_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Israel ca rhoek ham neh yinlai ham khaw, amih lakli kah lampah ham khaw hlipyingnah khopuei la om saeh. Khopuei parhuk he tah tohtamaeh ah hinglu aka ngawn boeih loh a rhaelrham vaengah hlipyingnah la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Tedae aka ngawn long khaw anih te thi hnopai neh a boh tih a duek sak atah hlang aka ngawn te duek rhoe duek saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Aka ngawn loh a kut dongkah lungto neh a duek la a thuk tih a duek atah hlang aka ngawn amah te duek rhoe duek saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Hlang aka ngawn loh a kut kah thing hnopai nen khaw a duek la a boh tih a duek atah hlang aka ngawn amah te duek rhoe duek saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Thii aka suk amah loh hlang aka ngawn te duek sak saeh. Anih te amah neh a hum uh vaengah amah loh anih te duek sak saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Hmuhuetnah neh a thaek, rhongngolnah neh anih te a dae tih a duek atah, ");
INSERT INTO hlt_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","thunkha thunhling la anih te a kut neh a thoek tih a duek atah aka thoek te duek rhoe duek saeh. Hlang aka ngawn thii aka suk amah neh a hum uh vaengah hlang aka ngawn te duek sak saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Tedae thunkha thunhling pawt ah buengrhuet la a thaek akhaw, rhongngolnah om pawt ah khaw, hnopai khat khat neh anih te a dae khaming, ");
INSERT INTO hlt_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","lungto nen khaw a duek sak khaming. A hmuh pawt vaengah anih te a tlak thil tih a duek oeh atah anih te thunkha aih pawt tih a boethae a tlap aih moenih. ");
INSERT INTO hlt_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Te dongah rhaengpuei loh hlang aka ngawn neh thii phu aka suk laklo ah he kah laitloeknah bangla laitloek uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Te vaengah rhaengpuei loh hlang aka ngawn te thii phu aka suk kut lamloh huul saeh. Rhaengpuei loh anih te a hlipyingnah khopuei la thak uh saeh lamtah rhaelrham saeh. Tedae Hmuencim kah situi neh a koelh khosoih ham a dueknah rhi hil tah te ah te khosa saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Tedae hlang aka ngawn te a hlipyingnah khopuei la rhaelrham tih khorhi te a poe khaw a poe khaming. ");
INSERT INTO hlt_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","Te vaengah anih te thii aka suk loh a hlipyingnah khopuei rhi kah vongvoel ah a hmuh tih thii aka suk loh a ngawn atah aka ngawn te a taengah thii long boel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Khosoih ham a dueknah rhi hil tah a hlipyingnah khopuei ah khosa saeh. Tedae khosoih ham a dueknah hnukah tah hlang aka ngawn te amah kah khohut khohmuen la mael saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","He rhoek he nangmih ham neh na cadilcahma ham khaw na tolrhum boeih ah laitloeknah khosing la om saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Hinglu aka ngawn boeih tah laipai olka kah bangla hlang aka ngawn te ngawn saeh. Tedae laipai pakhat bueng neh hinglu te duek sak ham doo boel saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Hlang aka ngawn kah hinglu ham tlansum te doe uh boeh. Amah a duek hamla aka halang te tah duek rhoe duek saeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Khosoih a dueknah rhi hil tah a hlipyingnah khopuei la rhaelrham ham neh khohmuen kah khosa la mael sak ham tlansum te lo boeh. ");
INSERT INTO hlt_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Thii loh khohmuen te a poeih coeng dongah a khuiah nangmih loh khohmuen te poeih uh boeh. A soah thii te a long coeng dongah thii aka long sak kah thii nen pawt atah khohmuen ham a dawth thai moenih. ");
INSERT INTO hlt_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","A khuiah kho aka sa nangmih loh te kah khohmuen te poeih uh boeh. Kai he a khui ah kho ka sak. Kai Yahweh he Israel ca rhoek a laklung ah kho ka sak. ");
INSERT INTO hlt_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Joseph ca rhoek kah koca lamloh Manasseh capa, Makir kah a ca, Gilead ca rhoek koca kah a napa boeilu rhoek te capit uh tih Moses mikhmuh neh Israel ca rhoek kah a napa boeilu, khoboei rhoek mikhmuh ah a thui uh. ");
INSERT INTO hlt_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Te vaengah, “Ka boeipa aw, khohmuen he Israel ca rhoek taengah hmulung neh rho la paek ham BOEIPA loh a uen coeng. Ka boeipa aw mah manuca Zelophehad kah rho te a canu rhoek taengah paek ham BOEIPA loh a uen coeng. ");
INSERT INTO hlt_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Tedae Israel ca kah koca pakhat ca lamkah pakhat taengah khaw a yuu la om uh koinih a pa rhoek kah rho khui lamloh amih kah rho te n'tloek pah ni. Amih a om nah koca kah rho te a thap vetih mamih kah rho he hmulung lamloh a hnop ni. ");
INSERT INTO hlt_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Israel ca rhoek ham jubilee om bal vaengah khaw amih a om nah koca kah rho ham ni amih kah rho te a thap eh. Te vaengah a pa koca kah rho lamloh amih kah rho la a yueh ni,” a ti uh. ");
INSERT INTO hlt_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Te dongah Moses loh BOEIPA olka bangla Israel ca rhoek te a uen tih, “Joseph ca rhoek kah koca loh a thui tangloeng coeng. ");
INSERT INTO hlt_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ol he BOEIPA loh Zelophehad canu rhoek ham khaw a uen coeng tih, 'Amih mik ah a then bangla yuu la poeh uh cakhaw a napa koca kah huiko khuikah yuu la om uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Te dongah Israel ca rhoek kah rho he koca pakhat lamloh koca a tloe taengla tinghil boel saeh. Israel ca khuikah hlang long tah a napa koca kah rho dongah balak uh saeh. ");
INSERT INTO hlt_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Israel ca koca khuiah rho aka pang canu boeih tah, a napa cako koca pakhat kah a yuu la om saeh. Te daengah ni a pa rhoek kah rho te Israel ca khuikah hlang loh a pang eh. ");
INSERT INTO hlt_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Rho he koca pakhat lamloh a tloe koca taengla tinghil boel saeh. Hlang he Israel ca, koca khuikah tah amah kah rho dongah balak saeh,’ a ti,” a ti nah. ");
INSERT INTO hlt_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","BOEIPA loh Moses a uen vanbangla Zelophehad canu rhoek loh a saii uh van. ");
INSERT INTO hlt_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Zelophehad canu rhoek Mahlah, Tirzah neh Hoglah khaw, Milcah neh Noah khaw a panoe ca rhoek kah a yuu la om uh. ");
INSERT INTO hlt_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Joseph capa Manasseh ca rhoek kah koca khuiah yuu la a om uh dongah amih kah rho a napa huiko kah koca khuiah om van. ");
INSERT INTO hlt_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","He kah olpaek neh laitloeknah he BOEIPA loh Jerikho Jordan kaep, Moab kolken ah Israel ca ham Moses kut lamloh a uen. ");
INSERT INTO hlt_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Hekah olka he Jordan rhalvang kah khosoek, Suph imdan kolken Paran laklo neh Tophel, Laban, Hazeroth neh Dizahab ah Israel boeih ham Moses loh a thui pah. ");
INSERT INTO hlt_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Te vaengah Seir tlang long kah Horeb lamkah Kadeshbarnea he hnin rha hlai at longcaeh hla pueng. ");
INSERT INTO hlt_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Kum likip a lo vaengkah a hla hlai at kah hla lamhma cuek dongah BOEIPA kah a uen boeih te Israel ca rhoek ham Moses loh a thui pah. ");
INSERT INTO hlt_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Heshbon ah aka ngol Amori manghai Sihon neh Edrei kah Ashtaroth ah aka ngol Bashan manghai Oga a tloek phoeiah, ");
INSERT INTO hlt_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Moab kho kah Jordan rhalvang ah BOEIPA kah olkhueng te Moses loh koe a thuicaih tih, ");
INSERT INTO hlt_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Mamih kah BOEIPA Pathen loh Horeb ah a thui tah, 'Hekah tlang ah na om uh khaw rhoeh coeng. ");
INSERT INTO hlt_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Nangmih te hooi uh lamtah hlah uh laeh. Amori tlang neh a imben boeih ah, kolken tlang neh kolrhawk ah khaw, Negev neh Kanaan kho kah tuitun langkaeng long khaw, Lebanon tuiva Perath tuiva puei duela cet uh. ");
INSERT INTO hlt_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Nangmih mikhmuh kah khohmuen kam paek he hmuh uh. Cet uh lamtah pang uh. Tekah khohmuen te ni BOEIPA loh na pa rhoek Abraham taengah, Isaak taengah, Jakob taengah khaw amih phoeikah a tii a ngan taengah khaw paek ham la ol a caeng. ");
INSERT INTO hlt_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Te vaeng tue ah nang mih taengah ka thui vanbangla, “Nangmih khuen ham he kai loh kan na moenih. ");
INSERT INTO hlt_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","BOEIPA na Pathen loh nangmih m'ping sak coeng dongah tihnin ah tah vaan kah aisi bangla na yet coeng. ");
INSERT INTO hlt_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Na pa rhoek kah BOEIPA Pathen loh nangmih taengkah a thui vanbang la nangmih te a pueh thawng khat lam khaw n'thap saeh lamtah yoethen m'pae saeh. ");
INSERT INTO hlt_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Tedae nangmih kah laipuei neh hnophueih neh tuituknah te kai loh metlam ka phueih thai eh? ");
INSERT INTO hlt_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Te dongah namah koca khui lamkah aka cueih tih aka yakming neh aka ming thai hlang rhoek te namamih ham tuek uh lamtah amih te nangmih kah a lu la ka khueh eh?,’ ka ti. ");
INSERT INTO hlt_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Te vaengah kai te nan doo uh tih, 'Na ol thui te te then, saii ham om,’ na ti uh. ");
INSERT INTO hlt_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Te dongah aka cueih tih aka ming hlang rhoek te namamih koca rhoek kah a lu la ka khueh eh. Te vaengah thawngkhat kah mangpa rhoek, yakhat kah mangpa rhoek, sawmnga kah mangpa rhoek neh hlangrha kah mangpa rhoek te nangmih soah a lu la ka khueh tih nangmih koca rhoek kah rhoiboei la om uh. ");
INSERT INTO hlt_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Te vaengah nangmih taengkah laitloek rhoek te ka uen tih, 'Na manuca rhoek loh a yaak koi la hlang neh a manuca laklo ah khaw yinlai laklo ah khaw duengnah neh laitloek uh. ");
INSERT INTO hlt_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Laitloeknah dongah hlang maelhmai so uh boeh. Tanoe kangham la na yaak akhaw hlang mikhmuh ah bakuep uh boeh. Laitloeknah he Pathen hut la a om dongah nangmih ham aka kuel olka te tah kai taengla hang khuen uh lamtah n'yaak sak uh,’ ka ti nah. ");
INSERT INTO hlt_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Te vaeng tue kah nangmih kang uen olka boeih te saii uh. ");
INSERT INTO hlt_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Te dongah mamih BOEIPA Pathen kah a uen vanbangla Horeb lamkah m'puen uh tih khosoek khoham khaw boeih na hmuh uh. Rhih aka om Amori tlang long la n'cet uh tih Kadeshbarnea te m'pha uh. ");
INSERT INTO hlt_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Te vaengah nangmih taengah, “Mamih kah BOEIPA Pathen loh mamih taengah m'paek Amori tlang la na pawk uh coeng. ");
INSERT INTO hlt_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Na pa rhoek kah BOEIPA Pathen loh nangmih taengah, 'Rhih boeh, rhihyawp boeh,’ a ti vanbangla nangmih mikhmuh ah na BOEIPA Pathen loh m'paek ke so uh. Khohmuen ke cet lamtah pang laeh,’ ka ti. ");
INSERT INTO hlt_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Te vaengah kai taengla boeih na capit uh tih, 'Mamih hmai ah hlang tueih uh sih lamtah khohmuen te ha hip uh saeh. Te daengah ni n'caeh ham koi longpuei neh m'pha ham koi khopuei rhoek kah olka te mamih taengla hang khuen uh eh,” na ti uh. ");
INSERT INTO hlt_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Tekah olka ka mik dongah a thuem van dongah koca pakhat ah hlang pakhat neh hlang hlai nit te nangmih khui lamkah ka tuek. ");
INSERT INTO hlt_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Te dongah hooi uh tih tlang la a yoeng uh phoeiah Eshkol soklong la pawk uh tih kho a hip uh. ");
INSERT INTO hlt_vpl VALUES ("DT1_25","006_1