﻿USE sofia;
DROP TABLE IF EXISTS sofia.hlb_vpl;
CREATE TABLE hlb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hlb_vpl WRITE;
INSERT INTO hlb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","अब्राहम की अवलाद, दाऊद की अवलाद, यीसु मसी को खानदान। ");
INSERT INTO hlb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहम से इसहाक पैदा भयो, इसहाक से याकूब पैदा भयो, याकूब से यहूदा अर ओखा भई हुन पैदा भया, ");
INSERT INTO hlb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहूदा से तामार, तामार को वजे से फिरिस अऊर जेरह पैदा भयो। पेरेस से हेस्रोन पैदा भयो। हेस्रोन से एराम पैदा भयो। ");
INSERT INTO hlb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","एराम अम्मीनादाब को बाप हतो, अम्मीनादाब से नहसोन, नहसोन से सलमोन पैदा भयो, ");
INSERT INTO hlb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सलमोन से राहाब, राहब को वजेसे बोअज पैदा भयो, बोअज से रूत अऊर रूत से ओबेद पैदा भयो, ओबेद यिसै को बाप हतो। ");
INSERT INTO hlb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","अर यिसै से राजा दाऊद पैदा भयो। सुलैमान दाऊद को पोरिया हतो जो वा बाईचारा से पैदा भयो रहा जो पहले उरिय्याह की घरवाली हती। ");
INSERT INTO hlb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सुलैमान रहबाम को बाप हतो, अर रहबाम अबिय्याह को बाप हतो। अर अबिय्याह से आसा को पैदा भयो। ");
INSERT INTO hlb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","अऊर आसा यहोसाफात को बाप भयो, अऊर यहोसाफात से योराम, अऊर योराम से उज्जियाह को जनम भयो, ");
INSERT INTO hlb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उज्जियाह योताम को बाप हतो, अर योताम आहाज को, आहाज से फिर हिजकिय्याह पैदा भयो, ");
INSERT INTO hlb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","अऊर हिजकिय्याह से मनस्सिह को पैदा भयो, मनस्सिह आमोन को बाप भयो, अर आमोन योसिय्याह को। ");
INSERT INTO hlb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","फिर इस्राएल ख इंसान हुन ख बंधी बना ख बेबीलोन ले जान को बखत योसिय्याह से यकुन्याह अऊर ओखा भई हुन को पैदा भयो। ");
INSERT INTO hlb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","बेबीलोन म ले जान को बाद यकुन्याह सालतिएल को बाप बनयो, अऊर फिर सालतिएल से जरूब्बाबिल। ");
INSERT INTO hlb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","अर जरूब्बाबिल से अबीहूद पैदा भयो, अबीहूद इल्याकिम को अर इल्याकिम अजोर को बाप बनयो। ");
INSERT INTO hlb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","अजोर सदोक को बाप हतो। सदोक से अखीम, अखीम से इलीहूद पैदा भयो, ");
INSERT INTO hlb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","इलीहूद इलियाजार को बाप हतो अर इलियाजार मतान को, अर मत्तान याकूब को बाप बनीयो। ");
INSERT INTO hlb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","याकूब से यूसुफ पैदा भयो, जो मरियम को घरवालो हतो, मरियम से यीसु पैदा भयो, जे मसी कहलावा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","असो तरीका से अब्राहम से दाऊद लक कुल चऊदा पीढ़ी हुन भई। अऊर दाऊद से लेखा गुलाम बना ख बेबीलोन पहुँचायो जानो लक की चऊदा पीढ़ी हुन, अऊर गुलाम बना ख बेबीलोन ले जान को बखत से मसी को पैदा होन लक चऊदा पीढ़ी हुन अऊर भई। ");
INSERT INTO hlb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","यीसु मसी को जनम, असो तरीका से भयो। ओकी माय मरियम कि मंगनी यूसुफ से भई रहा, पर असो भयो कि उनको एक संग रहनो से पहले ही मरियम सुध्द आत्मा की ओर से गर्भवती हती रा। ");
INSERT INTO hlb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ओको घरवालो यूसुफ धीरे से मरियम ख छोड़ देन को विचार करत रहा, काहेकि उ धर्मी इंसान हतो रा। अऊर मरियम ख बदनाम नी करन की सोचत रा। ");
INSERT INTO hlb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","जब उ असी बात हुन कि सोच ही म हतो ते प्रभु को स्वर्गदूत ओखा सपना म दिखाई दियो अऊर कहन लग गयो, “अरे यूसुफ! दाऊद को अवलाद, तू अपनी ओरत मरियम ख अपनो इते लेखा आन से मत डरा, काहेकि जो ओकी कोक म हैं, उ सुध्द आत्मा की तरफ से हैं। ");
INSERT INTO hlb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","वा एक पोरिया ख जनम देहे अर तुम ओको नाम यीसु रखनो, काहेकि उ अपना इंसान हुन ख उनका पाप हुन से छुटकारा देहेगो।” ");
INSERT INTO hlb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","यू सब एकोलाने भयो कि भविस्यवक्ता को मुंडो से प्रभु न जो बोल्यो रहा, उ पूरो हो जाहे: ");
INSERT INTO hlb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“देखनो, एक कुंवारी पोरी गर्भवती होए अऊर एक पोरिया ख जनम देहे, अऊर ओको नाम इम्मानुएल, रखो जाहे,” जेको मतलब हैं, परमेस्वर हमरो संग म हैं। ");
INSERT INTO hlb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","तब यूसुफ नींद से जग ख प्रभु को दूत को कहेना को हिसाब से अपनी घरवाली ख लेखा अपनो यहाँ ले आयो; ");
INSERT INTO hlb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","अर जब तक उ पोरिया पैदा नी भयो तब लक उ मरियम को जोने नी गयो: अऊर ओ ना ओको नाम यीसु रखयो। ");
INSERT INTO hlb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","यीसु को जनम यहूदा प्रदेस को बैतलहम सहर म भयो। उ बखत राजा हेरोदेस हतो। यीसु को जनम को बाद तारा ख देख ख बतावन वाला (ज्‍योतिर्सी हुन) पुरब कि तरफ से यरूसलेम सहर म आया। ");
INSERT INTO hlb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“अऊर असा बोल्या, यहूदी हुन को नयो राजा किते हैं? काहेकि हमना पुरब की तरफ ओको तारा ख देखयो हैं अऊर ओखा पाय पढ़न ख आया हैं। ");
INSERT INTO hlb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","यू सुन ख राजा हेरोदेस अऊर ओको संग पुरो यरूसलेम घबरा गयो। ");
INSERT INTO hlb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","राजा न पुरा बड़ा-बड़ा याजक हुन अऊर समाज ख सब सासतिरी हुन को ग्यान रखन वाला हुन कि पंचायत बुला ख बैठाई अऊर उनसे पुछियो, मसी किते पैदा होऐ?” ");
INSERT INTO hlb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","उनना जुवाब दियो, यहूदिया प्रदेस को बैतलहम सहर म; काहेकि भविस्यवक्ता हुन न ऐको बारे म असो लिखो हैं; ");
INSERT INTO hlb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“अरे, बैतलहम, यहूदा प्रदेस को सहर! तू यहूदा प्रदेस ख पुरा सहर म कोई से छोटो नी हाय; काहेकि तोमन से एक अधिपति निकलेगो, जो मोरी प्रजा इस्राएल कि रखवाली करे।” ");
INSERT INTO hlb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","हेरोदेस न बाद म ज्योतिर्सी हुन ख चुप चाप से बुलायो अऊर उन से पूछताछ कर ख यू मालूम कर लियो कि उ तारा ठिक कित्ती घड़ी उनका दिखई दियो रहा। ");
INSERT INTO hlb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","फिर ओ ना उनका बैतलहम सहर भेज दियो, अऊर उनसे बोल्यो, “जाव, पोरिया को सही-सही पता लगाव अर जब तुम ख मिल जाहे ते मोखा खबर बतानो, ताकि मी भी जा ख ओखा पाय पडू।” ");
INSERT INTO hlb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","जब वी राजा की बात मान ख चल दिया। उनना जो तारा ख उगते देखयो रहा, उ उनको आगे-आगे चलते जात रा, अऊर जहाँ पोरिया हतो, वा जगा को ऊपर पहुँच ख रूक गयो। ");
INSERT INTO hlb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","उ तारा ख देख ख वी बेजा खुस भया। ");
INSERT INTO hlb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","घर म भीतर जा ख उनना पोरिया ख ओकी माय मरियम को संग देखियो, अर ओको पाय पढ़ियो। फिर अपनी-अपनी पेटी खोल ख उनना ओखा सोना, लोबान अऊर गन्धरस की भेट दिया। ");
INSERT INTO hlb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","उन ख सपना म या खबर मिली कि तुम हेरोदेस को जोने फिर से मत जानु, एकोलाने वी दूसरो रस्ता से अपनो देस ख चल दिया। ");
INSERT INTO hlb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","उनको चल देन को बाद प्रभु को दूत यूसुफ ख सपना म दिखई दियो अर असो बोल्यो, “उठ, उ पोरिया ख अऊर ओकी माय ख लेखा मिसर देस ख भाग जा। अऊर जब लक मी तोसे नी कहूँ, तब लक उतेइच रैयजो; काहेकि हेरोदेस यू पोरिया ख मार डालन को लाने ऐका ढूँढ़ा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","तब यूसुफ रातम रात उठ ख पोरिया अर ओकी माय ख लेखा मिसर देस ख चल दियो, ");
INSERT INTO hlb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","उ हेरोदेस कि माऊत तक उतेइच रयो, जसो भविस्यवक्ता को मुंडो से जो प्रभु न बोल्यो रहा, उ पूरो हो जाय: “मिना मिसर देस से अपनो पोरिया ख बुलायो।” ");
INSERT INTO hlb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","हेरोदेस ख असो देख ख बेजा घुस्सा आयो कि, तारा हुन ख देख ख भविस्य बतान वाला (ज्योतिर्सी हुन) न मोखा धोका दियो हैं। ओ ना सिपई हुन ख भेजियो अऊर बैतलहम अर ओखा आजू बाजू का गाँव हुन म वी सभी पोरिया हुन ख मरवा डाल्यो, जो ज्योतिर्सी हुन को हिसाब से पता लगा गयो बखत को हिसाब से दो साल का या ओसे कम उमर का हता। ");
INSERT INTO hlb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","तब भविस्यव्दक्ता यिर्मयाह को दुवारा कय्हो गयो यू वचन पूरो भयो; ");
INSERT INTO hlb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामाह म एक बडी जोर कि आवाज सुनाई देवा हैं, रोनो अऊर बड़ो बिलकनो; राहेल अपना पोरिया हुन को लाने रोवत रा, अऊर सान्त ही नी होत रा, काहेकि वी अब नी रया।” ");
INSERT INTO hlb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","राजा हेरोदेस कि माऊत को बाद प्रभु को दूत मिसर देस म यूसुफ ख सपना म दिखई दियो, ");
INSERT INTO hlb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","अऊर असो बोल्यो, “उठ! पोरिया अर ओकी माय ख लेका इस्राएल देस ख चल दा, काहेकि जो पोरिया की जान लेन कि सोचत रहा, उ अब खतम हो गयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","यूसुफ उठियो, अर पोरिया अर ओकी माय ख लेका इस्राएल देस आ गयो। ");
INSERT INTO hlb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","पर जब ओ ना सुनायो कि अरखिलाउस अपनो बाप हेरोदेस कि जगा पर यहूदा प्रदेस म राज कर रयो हैं, तब उ उते जान से डर गयो अऊर सपना म सुन ख गलील प्रदेस चल दियो। ");
INSERT INTO hlb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","अर उ उते नासरत नाम सहर म जा ख बस गयो। असो तरीका से भविस्यवक्ता हुन को वचन पूरो भयो: “उ नासरी कहलायगो।” ");
INSERT INTO hlb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","वी दिन म यूहन्ना बपतिस्मा देनवालो यहूदा प्रदेस को निर्जन प्रदेस म आयो, अऊर वहाँ असो प्रचार करन लग गयो: ");
INSERT INTO hlb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“मन फिराओ, काहेकि स्वर्ग को राज नजीक आ गयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","यूहन्ना उईच व्यक्ति आय जेको बारे म भविस्यवक्ता यसायाह न बोल्यो रहा। “जंगल म एक हाका देन वालो कि आवाज सुनाई देवा हैं प्रभु के यहाँ जान को रस्ता तैयार करो; ओकी रोट ख सिधो करो।” ");
INSERT INTO hlb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","यूहन्ना ऊँट को रुआ को कपड़ा पहिनियो हतो, अर कमर म चमडा को पट्टा बाँधी हतो रहा ओको खाना टिड्डी हुन अर जंगल म की मोऊरस हती। ");
INSERT INTO hlb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","तब यरूसलेम सहर अर पुरो यहूदिया प्रदेस ख, अर यरदन नद्दी को आजू बाजू का सब सिवाना से इंसान हुन यूहन्ना को जोने आत रा। ");
INSERT INTO hlb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","अर उनना अपना-अपना पाप हुन ख मान ख यरदन नद्दी म ओसे बपतिस्मा लियो। ");
INSERT INTO hlb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","जब ओ ना ढ़ेर सारा फरीसी हुन अर सदूकी हुन ख बपतिस्मा को लाने अपनो जोने आते देखियो, ते ओ ना उनसे बोल्यो, “अरे साँप को पोरिया हुन, तुम ख कोना जता दियो कि आवन वालो गुस्सा से भागो?” ");
INSERT INTO hlb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","एकोलाने मन फिराव को लायक फल लाओ। ");
INSERT INTO hlb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","अर अपनो मन म यू मत सोचो कि हमारो बाप अब्राहम की अवलाद आय; मी तुम से कहू हैं कि परमेस्वर इन पत्थर हुन से अब्राहम को लाने अवलाद पैदा कर सका हैं। ");
INSERT INTO hlb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","अब कुल्हाडी झाड़ हुन की जड़ पा रख्यो हैं, एकोलाने जे-जे झाड़ चोक्खो फल नी देवा हैं, वी काट ख अर आगी म झोका दियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“मी तो तुम इंसान हुन ख पानी से पस्चाताप करन को बपतिस्मा देऊ हैं; उ मोसे जादा सक्तिसाली हैं। मी ओको जूता उठान को भी कबील नी हैं। उ तुमका सुध्द आत्मा अर आग से बपतिस्मा देहे। ");
INSERT INTO hlb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ओको सूपडा ओको हात म हैं, अऊर उ अपनो खल्ला चोक्खो तरीका से सफा करेगों, अऊर अपनो गहूँ ख तो बखारी म जमा करेगों, पर भूसा ख वा आगी म जलायगो जे बुझन की नी।” ");
INSERT INTO hlb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","वी बखत म प्रभु यीसु यूहन्ना से बपतिस्मा लेवन को लाने गलील प्रदेस से यरदन नद्दी को किनार म पहुँचियो। ");
INSERT INTO hlb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","पर यूहन्ना ओखा असो बोल ख रोकन लग गयो, “मोखा तो तोरो हात से खुद बपतिस्मा लेन कि जरूरत हैं। अऊर तू मोरो जोने आयो हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","पर यीसु न ओखा जुवाब दियो, “अब तो असो ही होन दा, काहेकि हम ख असोई तरीका से सब धार्मिकता ख पूरो करनो उचित हैं।” येपर यूहन्ना न यीसु कि बात मान ली। ");
INSERT INTO hlb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","अर यीसु बपतिस्मा ले ख तुरत पानी म से ऊपर आयो, अऊर देखनो, ओको लाने आकास खुल गयो, अर ओ ना परमेस्वर की आत्मा ख कबूतर को जसो उतरते अऊर अपनो ऊपर आते देख्यो। ");
INSERT INTO hlb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","अऊर देखनो, स्वर्ग से असी आवाज सुनाई दी, “यू मोरो सबसे अच्छो पोरिया आय, जसो मी बेजा खुस हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","वा बखत आत्मा यीसु ख निर्जन प्रदेस को जंगल म ले गयो कि इब्लीस सैतान ओकी परीक्छा ले। ");
INSERT INTO hlb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","अर यीसु चालीस दिन, अर चालीस रात, निराहार उपास करते रयो, तब ओ ख भूख लगी। ");
INSERT INTO hlb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ते परख न वालो न ओको जोने आका ओसे बोल्यो, “अदि तू परमेस्वर को पोरिया आय, ते कह दा, कि यी पत्थर रोटी हुन बन जाय।” ");
INSERT INTO hlb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","यीसु न जुवाब दियो, “सुध्द सास्र म असो लिख्यो हैं: ‘अदमी सिरप रोटी ही से जिन्दो नी हैं। बल्कि उ परमेस्वर को मुंडो से निकलन वालो हर एक वचन से जिन्दो रहवा हैं।’” ");
INSERT INTO hlb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","तब इब्लीस सैतान यीसु ख सुध्द सहर म ले गयो अर ओखा मन्दिर की चोटी पर खड़ो कर दियो, ");
INSERT INTO hlb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","अऊर इब्लीस न बोल्यो कि, “अदि तू परमेस्वर को पोरिया आय, ते अपनो तुम ख निचू गिरा दे” काहेकि लिख्यो हैं; “वी तोरो बारे म अपना स्वर्गदूत हुन ख हुकुम देहे, अर वी तो ख हातो ही हात उठा लेहे; कई असो नी होए कि तोरो पाय हुन म पत्थर से झट लगे।” ");
INSERT INTO hlb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","यीसु न इब्लीस से बोल्यो कि, “यू भी सुध्द सास्र म लिखो हैं: ‘तू प्रभु अपनो परमेस्वर कि परिक्छा मत लेजो।’” ");
INSERT INTO hlb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","फिर इब्लीस सैतान यीसु ख एक बेजा ऊँचो पहाड़ पा ले खा गयो अर दुनिया ख सारो राज्य अऊर उनको वैभव दिखा ख। ");
INSERT INTO hlb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","अऊर इब्लीस सैतान न बोल्यो, “अदि तू मोरो सामने पाय टेके ख मोरी भक्ती करे, ते मी तुम ख यू सब कुछ दे हूँ!” ");
INSERT INTO hlb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","तब यीसु न जुवाब दियो, “दूर हो जा, सैतान! काहेकि सुध्द सास्र म लिखो हैं: ‘तू प्रभु अपनो परमेस्वर ख आराधना अऊर सिरप ओकी ही उपासना करे।’” ");
INSERT INTO hlb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","तब सैतान यीसु ख छोड़ ख चल दियो, अर देखनो, स्वर्ग दूत आय ख ओकी सेवा करन लग गया। ");
INSERT INTO hlb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","जब यीसु न यू सुन्यो कि यूहन्ना पकड़ा गयो हैं, ते उ गलील प्रदेस ख चल दियो। ");
INSERT INTO hlb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ते उ नासरत सहर ख छोड़ ख, कफरनहूम सहर म रहन लग गयो। यू सहर जबूलून अर नप्ताली कुल हुन को सिवाना म झील को किनार म बसीयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","असो तरीका से भविस्यवक्ता यसायाह को यू वचन पूरो भयो: ");
INSERT INTO hlb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","जबूलून अर नप्ताली को देस कुल हुन की जमीन को सिवाना! समुंदर को रस्ता पर, यरदन को ओनो पार, गैर यहूदी हुन को गलील! ");
INSERT INTO hlb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","अर जो लोग अंधेरा म बठिया हता, उनना बड़ो उजेलो ख देखियो; अर जो माऊत को देस अर छाय म बठिया हतो, उनको पा उजेलो चमकियो। ");
INSERT INTO hlb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","उ बखत से यीसु प्रचार करन अर या खबर सुनान लग गयो, “मन फिराव, काहेकि स्वर्ग को राज्य नजीक आ गयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","जब यीसु गलील कि झील को किनार म फिरत रहा। उनना दो भई हुन ख देखयो समोन, जो पतरस कहलावा हैं, अर ओको भई अन्द्रियास ख। वी झील म जाल डालत रहा काहेकि वी ढ़िमर हता। ");
INSERT INTO hlb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","यीसु न ओसे कय्हो, “मोरो पीछे चलो आव, ते मी तुम ख अदमी हुन ख पकड़न वाला बनाऊँ।” ");
INSERT INTO hlb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","वी तुरत अपनो जाल छोड़ ख ओको पीछु चल्या गया। ");
INSERT INTO hlb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","वहा से आगे बढ़ ख, पर यीसु न अऊर दो भई हुन ख देखा जबदी को पोरिया याकूब अर ओको भई यूहन्ना ख। वी अपनो बाप जबदी को संग नाव म अपनी जाल हुन ख सुधारते रहा। यीसु न उनका बुलायो। ");
INSERT INTO hlb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","वी तुरत नाव अर अपनो बाप ख छोड़ ख ओको पीछु चल दिया। ");
INSERT INTO hlb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","यीसु पूरो गलील प्रदेस म फिर-फिर ख ओको प्रार्थना घर हुन म सिखाते रयो अऊर राज्य को सुसमाचार प्रचार करते, अर इंसान हुन की कई तरीका कि बीमारी हुन अर कमजोरी हुन ख दूर करते जात रहा। ");
INSERT INTO hlb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","अर ओको नाम पूरो सीरिया देस म फैल गयो। अऊर इंसान हुन सब बीमार हुन ख जो कई प्रकार कि बीमारी म अऊर दुख म जकड़ियो हता, अर जेमा भूत-भात हता, अऊर मिर्गी वाला अऊर लकवा ख रोगी हुन ख ओको जोने लाया अऊर ओ ना उनका अच्छो करयो। ");
INSERT INTO hlb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","गलील प्रदेस, दिकापुलिस, यरूसलेम, यहूदा प्रदेस अर यरदन नद्दी को ओनो पार से आयी वाली एक बड़ी भीड़ यीसु ख पिछु हो ली। ");
INSERT INTO hlb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","यीसु बड़ी भीड़ ख देख ख टेकड़ा पर चढ़ गयो, अऊर जब उ वहा पर बठ गयो। ते ओखा चेला ओको जोने आया। ");
INSERT INTO hlb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","अऊर उ उनका यू कह ख उन ख सिखान लग गयो: ");
INSERT INTO hlb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“भलो हैं वी, जो मन का सीधा हैं काहेकि स्वर्ग को राज उनको ही हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“भलो हैं वी, जो दुख ख ध्यान करा हैं; काहेकि उन ख सान्ति मिलेगो।” ");
INSERT INTO hlb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“भलो हैं वी, जो नम्र हैं, काहेकि वी धरती का हकदार होए।” ");
INSERT INTO hlb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“भलो हैं वी, जो धर्म को लाने भूका अऊर प्यासा हैं; काहेकि वी संतुस्ट हो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“भलो हैं वी, जो दया करन वाला हैं; काहेकि उन पर दया करी जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“भलो हैं वी, जिनको मन सुध्द हैं; काहेकि वी परमेस्वर को दर्सन करेगों।” ");
INSERT INTO hlb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“भलो हैं वी, जो मेल-जोल करान वाला हैं; काहेकि वी परमेस्वर की अवलाद कहलाएगो।” ");
INSERT INTO hlb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“भलो हैं वी, जो धर्म का काम हुन करन को वजे से दुख तखलीप सहा हैं; काहेकि स्वर्ग को राज उनको ही हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“भलो हैं तुम, जब इंसान मोरो वजे से तुमरी बेज्जती करा हैं, तुम पा अत्याचार करा अऊर ढ़ेर सारा झुटा अरोप लगावा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","तब हसनो अर मगन होनो, काहेकि तुमारो लाने स्वर्ग म बडो फल हैं। एकोलाने कि उनना वी भविस्यवक्ता हुन ख जो तुम से पहले हता यूईच तरीका से सतायो रहा।” ");
INSERT INTO hlb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","तुम धरती को नमक आय; पर अदि नमक को स्वाद बिगड़ जाहे, ते उ फिर कोन सचीज से नमकीन करियो जाहे? फिर उ कई काम को नी, अकेलो एकोलाने कि बाहर फेका जाहे अर व्यक्ति हुन को पाय हुन से नीच रदा दियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","तुम दुनिया को उजाला आय। जे सहर टेकड़ा पर बसो रवह हैं। उ छिप नी सका। ");
INSERT INTO hlb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","अऊर इंसान हुन दीया जला ख दिया ठानी को नीचु नी पर दिया ठानी को ऊपर रखा हैं, जिते से उ घर का सबरा इंसान हुन ख उजाला देवा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","असोई तरीका से तुमारो उजेलो भी इंसान हुन को सामने चमकते रैय, जसो वी तुमरा भला काम हुन ख देख ख तुमारो स्वर्ग म रहन वालो परमेस्वर बाप की बड़ाई कर सके। ");
INSERT INTO hlb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","असो मत समझनो कि मी मूसा को नेम ख या भविस्यवक्ता हुन की लिखी वाली बात हुन ख हटान आयो हैं। मी उनका हटान को लाने नी पर पुरो करन आयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","अर मी तुम इंसान हुन से सच कहूँ हैं, आकास अर जमीन भले ही टल जाहे, पर लिखो वालो नेम म से एक मातरा अर एक बिन्दु भी बिना पुरो भयो नी मिटे। ");
INSERT INTO hlb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","एकोलाने जे कोई यी छोटा से छोटा आदेस हुन म से एक का भी टोड़ा हैं अऊर दुसरा ख असो ही करनो सिखावा हैं, उ स्वर्ग को राज म सबसे छोटो समझो जाहे। पर जो उनको पालन करा हैं अऊर उनका सिखावा हैं, उ स्वर्ग को राज म बड़ो समझो जावा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","काहेकि मी तुम इंसान हुन से कहू हैं, कि अदि तुमारी धार्मिकता सासतिरी अऊर फरीसी हुन कि धार्मिकता से बढ़ ख नी होए, ते तुम स्वर्ग को राज म कभी नी जा सकन का। ");
INSERT INTO hlb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“तुम इंसान हुन न सुन लियो हैं कि पुरानो जमाना ख अदमी हुन से बोलो गयो रहा कि ‘माऊत मत करनो।’ अऊर जो कोई माऊत करे, ते उ कचेरी म सजा को काबिल होए। ");
INSERT INTO hlb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","पर मी तुम से कहूँ हैं, कि जो कोई अपनो भई पर घुस्सा करे, उ कचेरी म सजा को लायक होए, अर जो कोई अपनो भई ख निकम्मो बोले उ बड़ीसभा म सजा को लायक होए; अर जो कोइ बोले ‘अरे मूरक’ उ नरक कि आग को सजा को लायक होऐ। ");
INSERT INTO hlb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","एकोलाने अदि तू अपनी भेट वेदी पा लाहे, अऊर वहाँ तोखा याद आहे, कि मीना मोरो भई ख कुछ बुरो बोल दियो हैं, ");
INSERT INTO hlb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ते अपनी भेट वही वेदी को जोने छोड़ दा, अर जा ख पहले अपनो भई से मेल मिलाप ला अऊर तब आका अपनी भेट चढ़ा। ");
INSERT INTO hlb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“जब लक तू अपनो दुसमन को संग रस्ता ही म हैं, ओसे तुरत मेल-जोल कर ला कई असो नी होए कि तोरो बैरी तोखा न्याय करन वालो ख सोपे, अर न्याय करन वालो तोखा सिपाई ख सोपे देहे, अर तोखा जेल खाना म डाल दियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","मी तो से सच बोलू हैं, कि जब लक तू दमड़ी-दमड़ी भर नी देन को तब लक वहा से छुट नी पावन को।” ");
INSERT INTO hlb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“तुम न सुन लियो हैं कि बोलो गयो रहा, गलत काम मत करनो।” ");
INSERT INTO hlb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","पर मी तुम से असो कहूँ हैं, कि जो कोई, कोइ ओरत ख बुरी नजर से देखे, उ अपनो मन म ओखा संग गलत काम कर चुकियो। ");
INSERT INTO hlb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","एकोलाने अदि तोरी जेवनी तरफ की आँख तो ख ठोकर खलाहे, ते ओखा निकाल ख फेक दा; काहेकि तोरो लाने युईच भलो हैं कि तोरो सरीर म से एक अंग कट जाय अर तोरो पुरो सरीर नरक म नी डाल्यो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","अदि तोरो जेवनो हात तोखा ठोकर खलाहे, ते ओखा काट ख फेक देजो; काहेकि तोरो लाने यूईच भलो हैं कि तोरो सरीर म से एक अंग कट जाय अर तोरो पूरो सरीर नरक म नी डालो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“असो भी बोलो गयो रहा, ‘जो कोई अपनी घरवाली ख छोड़ छुट्टी देन की सोचे, ते ओखा छोड़ छुट्टी दे।’ ");
INSERT INTO hlb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","पर मी तुम से असो कहूँ हैं कि जो कोई अपनी घरवाली ख गलत काम को अलावा कोइ अऊर कारन से छोड़-छुट्टी देहे ते उ ओसे गलत काम करह हैं; अऊर जो कोई वा छोड़ी वाली से सादी करे, उ गलत काम करह हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","फिर तुम इंसान हुन न सुन लियो होऐ कि पुराना जमाना ख इंसान हुन से बोलो गयो रहा, झूठी कसम मत खानो, पर प्रभु को लाने अपनी कसम ख पुरी करनो। ");
INSERT INTO hlb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","पर मी तुम से यू कहूँ हैं कि कभी कसम नी खानो; न तो स्वर्ग कि, काहेकि उ परमेस्वर को सिंहासन आय; ");
INSERT INTO hlb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","न धरती की, काहेकि वा ओको पाय को नीचु को पिड़ा को समान हैं न यरूसलेम कि, काहेकि उ महाराजा को सहर आय। ");
INSERT INTO hlb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","अपनी मुंडी की भी कसम मत खाजो काहेकि तू एक बाल का भी न सफेत, न कालो कर सका हैं। ");
INSERT INTO hlb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","पर तुमरी बात हाव की हाव, अऊर नी कि नी होनो हो; काहेकि जो कुछ येसे जादा होवा हैं ओसे बुराई ही पैदा होवा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“तुम इंसान हुन न सुनियो होए कि बोलो गयो रहा, आँख को बदला आँख, अर दाँत को बदला दाँत। ");
INSERT INTO hlb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","पर मी तुम से असो बोलू हैं कि बुराई को सामना मत करनो; पर जे कोई तुम्हारो जेवनो गाल पा चाटा मारे, ओको अर ओर तरफ दूसरो भी फेर देजो। ");
INSERT INTO hlb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","जो कोई तोखा डरा धमका ख जबरन तोसे कुरता ले लेहे, ते ओखा दुसरो भी ले लेन दा। ");
INSERT INTO hlb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","जो कोई तोखा कोस भर जबरन लेखा जाहे, ते ओको संग दो कोस चल देजो। ");
INSERT INTO hlb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","जे कोई तोसे मागे, ओ ख दे; अऊर जो तोसे उधार लेन कि सोचे, ओसे मुंडो मत फेरजो।” ");
INSERT INTO hlb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“तुम न सुन चुको होए कि कय्हो गयो रहा, अपनो पड़ोसी से प्रेम रखनो, अऊर अपनो बैरी से बैर।” ");
INSERT INTO hlb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","पर मी तुम से असो कहू हैं कि अपनो बैरी हुन से प्रेम रखनो अऊर जो तुम ख सतावा हैं उनको लाने बिनती करनो, ");
INSERT INTO hlb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","जसो तुम अपनो स्वर्ग म रहन वालो परमेस्वर बाप कि अवलाद ठहरोगो काहेकि उ भली अऊर बुरा दोई पर अपनो सूरज ख उगावा हैं, अऊर धर्मी अऊर अधर्मी दोई पर अपनो सूरज ख उगावा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","काहेकि अदि तुम अपनो से प्रेम रखन वालो ही से प्रेम रखा हैं, ते तुमरो लाने का फायदा कि बात हैं? का कर लेन वालो भी असो नी करा? ");
INSERT INTO hlb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","“अदि तुम केवल अपना भई हुन ख ही नमस्कार करे, ते कोन सो बड़ो काम करा हैं? का गैर-यहूदी का भी असो नी करा हैं? ");
INSERT INTO hlb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","एकोलाने चाहूँ हैं कि तुम नेक बनो, जसो तुमारो स्वर्ग म रहन वालो परमेस्वर बाप सुध्द हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“सतर ख रहेनो! तुम इंसान हुन ख दिखान को लाने अपना धर्म को काम मत करनो” नी ते अपनो स्वर्ग म रहन वालो बाप से, कुछ भी फल नी पान का। ");
INSERT INTO hlb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“एकोलाने जब तू दान करे,” ते अपनी जादा डोंडी मत पिटजो, जसो कपटी हुन, प्रार्थना घर म करते जावा हैं, ताकि इंसान हुन उनकी बड़ाई करे। मी तुम से सच कहूँ हैं कि उन न अपनी मेहनत को फल पा लियो। ");
INSERT INTO hlb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","पर जब तू दान करे, ते जो तोरो जेवनो हात करा हैं, ओखा तोरो ड़ाकरियो हात नी जाननो चाहिए। ");
INSERT INTO hlb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ताकि तोरो दान गुप्त रहे, अर तब तोरो बाप जो गुप्त म देखा हैं, तोखा मेहनत को फल देहे। ");
INSERT INTO hlb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“जब तू बिनती करे,” ते कपटी हुन को जसो मत करजो, काहेकि इंसान हुन ख दिखान को लाने प्रार्थना घर हुन म अऊर रोट कि चऊक हुन म बिनती करनो उनका अच्छो लगा हैं। मी तुम से सच बोलू हैं की वी अपनी मेहनत को फल पा चुकिया हैं। ");
INSERT INTO hlb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","पर जब तुम बिनती करे, “ते अपनी कोठरी म जाव,” अऊर दरवाजा बंद कर ख अपनो बाप से जो गुप्त म हैं बिनती कर। तब तोरो बाप, जो गुप्त म देखा हैं, तोखा तोरी मेहनत को फल देहे। ");
INSERT INTO hlb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","बिनती करते बखत गैर-यहूदी वाला को समान बक मत करनो, काहेकि वी समझा हैं कि उनको बेजा बोलनो से उनकी सुनी जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","एकोलाने तुम उनको जसो मत बननो, काहेकि तुमरो बाप तुमरो माँगनो से पहले ही जाना हैं कि तुमका कोन-कोन सी चीज कि जरूरत हैं। ");
INSERT INTO hlb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","एकोलाने तुम असो तरीका से बिनती करनो: अरे हमरो स्वर्ग म रहन वालो परमेस्वर बाप! तोरो नाम सुध्द मानो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","तोरो राज आहे। तोरी मर्जी जसी स्वर्ग म पूरी होवा हैं, उसी ही या धरती म भी पुरी होय। ");
INSERT INTO hlb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","हमरी दिन भर की रोटी आज हम ख दे। ");
INSERT INTO hlb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","अर जसो तरीका से हमना अपना बैरी हुन ख माप करयो, वसो ही तू भी हमरी अपराध हुन ख माप कर। ");
INSERT INTO hlb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","अर हमका परीक्छा म मत ला, पर बुराई से बचा। काहेकि राज्य अर पराक्रम अर महिमा सदा तोरो ही हैं। आमीन ");
INSERT INTO hlb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","एकोलाने अदि तुम इंसान हुन का पाप माफ करेगों। ते तुमरो स्वर्ग म रहन वालो परमेस्वर बाप भी तुमका माप कर देहे ");
INSERT INTO hlb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","अऊर अदि तुम इंसान हुन की अपराध माप नी करन का, ते तुमरो बाप परमेस्वर भी तुमरी गलती माफ नी करन को। ");
INSERT INTO hlb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“जब तू उपास करे, ते कपटी हुन को जसो तुम्हारो मुँह पर उदासी नी छाई रहे, काहेकि वी अपनो मुँह बनायो रखा हैं, काहेकि अदमी उन ख उपास जाने। मी तुम से सच कहूँ हैं कि वी अपनो इनाम पा चूको। ");
INSERT INTO hlb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","पर जब तू उपास करे ते, अपनो सिर पर तेल लगा अर मुँह ख धो ले, ");
INSERT INTO hlb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","काहेकि अदमी हुन ख नी अऊर तोरो बाप जे अकेलो म, तोखा उपास जाने। ते तोरो बाप जो अकेलो म देखा हैं, तोखा इनाम देहे।” ");
INSERT INTO hlb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“अपनो लाने धरती पर धन इकट्ठा नी कर। काहेकि ओखा कीड़ा अऊर जंग लग ख खत्म कर देवा हैं। जहाँ चोर मालूम कर ख ओखा चुरा सक हैं। ");
INSERT INTO hlb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","जब अपनो लाने स्वर्ग म धन इकट्ठो करो, वहा नी ते कीड़ा अर नी कोई बिगाड़ा हैं, अर जहाँ चोर नी सेध लगो रवह अर नी चुराते हैं। ");
INSERT INTO hlb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","काहेकि जहाँ तोरो धन रहे वा तोरो मन भी लगो रहे।” ");
INSERT INTO hlb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","सरीर को दिया तोरी आँख हैं; एकोलाने अदि तोरी आँख चोक्खी हैं, ते तोरो पुरो सरीर भी उजरो रहे। ");
INSERT INTO hlb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","अऊर अदि तुमारी आँख हुन बुरी हैं, ते तुमारो पूरो सरीर भी आन्धियारो होय; एकोलाने अदि तुमारो भीतर कि उजालो ही अन्धकार होए, ते यू कित्तो जादा अन्धकार होगो। ");
INSERT INTO hlb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","कोई भी दास दो मालिक हुन की सेवा नी कर सकह हैं काहेकि उ ते एक से बुराई करे अऊर दुसरो से प्रेम रखनो। या एक से मिल्यो रहेगो अऊर दुसरो ख संग म तुच्छ जानेगो। तुम परमेस्वर अऊर धन कि अऊर दोई कि एक संग म सेवा नी कर सकह। ");
INSERT INTO hlb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","एकोलाने मी तुम से बोलू हैं की अपनो जिन्दगी को लाने यू चिन्ता नी करनो कि हम का खाएँगो अर का पीए अर नी अपनो जिन्दगी ख लाने कि, का पहिने, का जिन्दगी खान से अर सरीर कपड़ा से बढ़ ख नी हाय? ");
INSERT INTO hlb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","बददल को पक्छी हुन ख देख वी नी बोवह हैं नी काटा हैं अर नी बखारी हुन म बटोर हैं, ते भी तुम्हरो स्वर्गीय बाप उन ख खिलावा हैं, का तुम उन से कई जादा किमती नी रहता? ");
INSERT INTO hlb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","तुम म कोन हैं जे चिन्ता कर ख अपनी उमर म एक घड़ी भी बढ़ा सकह हैं? ");
INSERT INTO hlb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“अर तुम अपनो कपड़ा ख लाने काहे चिन्ता करह हैं? जंगल का फूल हुन पर याद कर कि वी कसो बढ़ हैं वी नी ते मेहनत करिये हैं नी काटा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","तेबी मी तुम से कहूँ हैं कि सुलैमान भी, अपनो पूरो धन महिमा म उन म से कोई ख जसो कपड़ा पहिनो भयो नी हतो।” ");
INSERT INTO hlb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","एकोलाने जब भी परमेस्वर म बररा कि घास ख जे आज हैं अर कल आगी म डाली जाहे, असो कपड़ा पहिना हैं, ते अरे कुछ दिन ख विस्वासी हुन, तुम का उ इत्ता बढ़ ख काहे नी पहिना हे? ");
INSERT INTO hlb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","एकोलाने तुम चिन्ता करा ख यू नी कह जो कि हम का खाएगो या का पीवा हे, या का पहिने। ");
INSERT INTO hlb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","काहेकि गैर यहूदी हुन ख इन सब चीज हुन ख खोज म रवह हैं, पर तुमारो स्वर्गीय बाप जान हैं कि तुम ख इन सब चीज हुन कि जरूत हैं। ");
INSERT INTO hlb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","एकोलाने सबसे पहले परमेस्वर को राज अर ओको धर्म की खोज कर ते यू सब चीज हुन भी तुम ख मिल जाहे ");
INSERT INTO hlb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","अब कल कि चिन्ता नी कर, काहेकि कल को दिन अपनो चिन्ता खुद ही कर ले; आज को लाने आज ही को दुख ढ़ेर सारो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“दोस नी लगा, जेसे तुम पर भी दोस नी लगा जाहे; ");
INSERT INTO hlb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","काहेकि जे तरीका से तुम दोस लगावा हैं, उही तरीका से तुम पर भी दोस लगायो जाहे; अर जे नाप से तुम नापत हैं, उही नाप से तुमारो लाने भी नापो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","जब तुम ख खुदी ही आँख को कचरा ख पता नी, ते तुम अपनो भई बहिन कि आँख को कचरा काहे देख हैं? ");
INSERT INTO hlb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","जब तू खुद की ही आँख म लट्ठा हैं, ते तुम खुद कि भई बहिन से कसो बोल सक हैं। कि आ मी तोरी आँख से कचरा निकाल दे हूँ? ");
INSERT INTO hlb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","अरे “कपटी पहले तू अपनी आँखी म से लट्ठा निकाल ले, फिर ते तू अपनो भई बहिन कि आँखी से कचरा अच्छो से देख ख निकाल सका हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“सुध्द चीज हुन कुत्ता हुन ख नी दे अर अपनी मोती डुक्कर हुन को सामने नी डाल असो नी हो कि वी उन ख पाय म रउदे देहे अर पलट ख तो ख फाड़ डाले।” ");
INSERT INTO hlb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“अऊर माँगो, ते तुम ख दियो जाहे; ढूँडे ते तुम पाहेगो; खटखटाओ, ते तुमारो लाने खोलो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","काहेकि जे कोई माँगे हैं, ओ ख मिला हैं; अर जे ढूढ़ा हैं, ओ ख मिला हैं; अर जे खटखटाऊ हैं, ओको लाने खोलो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","तू म से असो कऊन सो व्यक्ति हैं, “कि अदि ओको पोरिया ओसे रोटी माँगे” ते उ ओ ख पत्थर देहे? ");
INSERT INTO hlb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","अर मच्छी माँगे, ते ओ ख साँप देहे? ");
INSERT INTO hlb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","एकोलाने जब तुम बुरा होय ख, पोरिया-पारी ख अच्छो चीज देनो जाना हैं ते तुमारो स्वर्ग म बाप अपना माँगन वाला हुन ख सुध्द चीज देहे काहे नी देहे। ");
INSERT INTO hlb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","हर बखत दूसरा हुन से अपनो लाने जसा व्यवहार करनो चाहत हैं, तुम भी उनको लाने वसो ही व्यवहार कियो कर; काहेकि नेम धरम म अऊर भविस्यवक्ता हुन कि ऊईच ग्यान हैं। ");
INSERT INTO hlb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","सकेत रस्ता से भीतर जाव। चऊड़ो हैं उ रस्ता अर लम्बो हैं रस्ता, जो नरक कि तरफ ले जाय हैं। ओपर चलन वाला कि गिनती जदा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","पर संकरो हैं उ दुवार अर कठिन हैं उ रस्ता, जे जिन्दगी कि तरफ ले जाय हैं। जे ओ ख पा हैं, ओकी संख्या कम हैं। ");
INSERT INTO hlb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“झूटा भविस्यवक्ता से सतरक रह, वी जे भेड़ को सकल म तुमारा नजीक आय हैं, पर वी भीतर म वी फाड़नवाला भेड़ी हैं। ");
INSERT INTO hlb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","उनका फल हुन से तुम उन ख पहिचान लेहे। का लोग हुन झाड़ी से अंगूर, या ऊँटकटार हुन से अंजीर तोड़ हैं। ");
INSERT INTO hlb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","असो तरीका से हर अच्छो झाड़ अच्छो फल देवा हैं अर बुरो झाड़ बुरो फल देवा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","अच्छो झाड़ बुरो फल नी ला सक, अर नी बेकार झ़ाड़ अच्छो फल नी लाय सका हैं। ");
INSERT INTO hlb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","जे झाड़ अच्छो फल नी लाय सक हैं, ओ ख काट ख अर आगी म झोको जाय हैं। ");
INSERT INTO hlb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","यू ईच ही उन ख फलहन से तुम उन ख पहिचान लेहे।” ");
INSERT INTO hlb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","जे लोग मोखा, प्रभु! प्रभु! कह ख बोल हैं, ओ म से सब का सब स्वर्ग को राज म भीतर नी आहे। जो मोरो स्वर्गीय बाप कि इच्छा ख पूरी कर हैं, ऊईच स्वर्ग राज म भीतर करे। ");
INSERT INTO hlb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ऊईच दिन बेजा से लोग मो से कहे प्रभु, प्रभु का हम नी तोरो नाम से भविस्यव्दाणी नी करी, अर तोरो नाम से दुस्टात्मा हुन ख नी निकाल, अर तोरो नाम से बेजा सो हैंरान नी करियो ");
INSERT INTO hlb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","तब मी उन ख खुल ख कह देहु, “मी न तुम लोग हुन ख कभी नी जाना। अरे बुरो काम करन वाला, मोरो नजीक से चलो जा।” ");
INSERT INTO hlb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“एकोलाने जे कोई मोरी यी बात हुन सुन ख उन ख माना हैं,” उ हुसयार अदमी को सामन रहे जेन अपनो घर टेकड़ा पर बनायो। ");
INSERT INTO hlb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","अऊर पानी बरसो, अर नद्दी म बाढ़ आई, अर धुंद फाफट चली, अर उ घर से टकराई, ते भी उ घर नी गिरो, काहेकि ओकी नीव पट्टान पर डाली गई हती। ");
INSERT INTO hlb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“परन्तु जो कोई मोरी यी बात सुन हैं अऊर ओपर नी चला, उ मुर्ख को जसो रह जेन अपनो घर रेता पर बनायो ");
INSERT INTO hlb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","अऊर पानी बारिस अऊर नद्दी हुन म बाढ़ आई, अऊर हवा-तूफान चली, अऊर ओको घर से टकाराई। अऊर उ गिर ख अर सब बरबाद होय गयो।” ");
INSERT INTO hlb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ते यीसु न अपनो यू प्रचार खत्म करियो, ते जनसमूह उनको ग्यान सुन ख हैंरान हो गयो; ");
INSERT INTO hlb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","काहेकि यीसु उनका सासतिरी हुन कि समान नी अर अधिकार ख संग उन ख सिक्छा देत हतो। ");
INSERT INTO hlb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","“अर यीसु टेकडी पर से उतरियो, ते एक बड़ी इंसान हुन भीड़ ओको पीछु हो ली। ");
INSERT INTO hlb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","उ बखत, एक कोढ से बिमार ओको नजीक आयो अऊर ओ न यू कहते हुए ओखा पाय पढियो, प्रभु! तू चाहे ते मोखा सुध्द कर सका हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","यीसु न हात बढ़ा ख ओ ख छु, करियो अर बोल्यो, “मी चाहूँ हैं, कि तुम अच्छो हो जा।” अर उ ही बखत तुरंत कोढ जुड से सुध्द हो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","यीसु न ओ से बोल्यो कि, “सतरक कोई से कई नी कह, जा ख अपनो तुम ख याजक ख दिखा अर मूसा दुवारा निर्धरित दान चढ़ा जेसे पूरो लोग हुन ख पता होय जाहे कि तुम अच्छो हो गया हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","जब यीसु कफरनहूम सहर म भीतर कर ही रयो हतो कि एक रोमन को सतपति न ओको नजीक आ ख, अऊर ओ न ओसे यू विनती करी, ");
INSERT INTO hlb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","प्रभु, “मोरो सेवक घर म पड़ो हुयो हैं ओखा लकवा को रोग होय गयो हैं अऊर उ बेजा पीड़ा सहन रयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","यीसु न ओ से बोल्यो कि, “मी आँख ओ ख अच्छो कर देहु।” ");
INSERT INTO hlb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","सतपति कय्हो दियो कि, “प्रभु, मी यी लायक नी हैं कि तू मोरो घर म आहे, पर तू एक ही सब्द कह देजे अर मोरो सेवक चोक्खो हो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","मी भी पराधीन अदमी हूँ अऊर सेना हुन मोरो अधीन म हैं। ते मी एक से कहूँ हैं, ‘जा!’ ते उ जाय हैं। अऊर दुसरो से ‘आ!’ ते उ आय हैं; अऊर अपनो दास से, ‘यू कर!’ ते उ करिये हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","यीसु यु सुन ख अचम्बा होय गयो, अऊर, उनना अपनो पिछु आवन वाला से कय्हो, “मी तुम लोग हुन से सच कहूँ हैं। कि इस्राएल म मीन कोई म इतो मजबूत विस्वास नी देखियो। ");
INSERT INTO hlb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","म तुम से कहू हैं। सारा लोग पूरब अऊर पच्छिम से आय ख अब्राहम अऊर इसहाक अऊर याकूब का संग स्वर्ग राज को जोवन म साम्मिल होए। ");
INSERT INTO hlb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","पर राज कि अवलाद ख बाहर अंधेरा म फेक दियो जाहे: वहा रोनो अर दाँत को पिसनो हुए।” ");
INSERT INTO hlb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","अर सतपति से यीसु ख बोल्यो कि, “जा, तुम न जसो विस्वास करियो हैं। वसो ही तुमारो लाने हो जाहे।” अर ऊईच बखत ओको सेवक अच्छो हो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ते यीसु पतरस को घर पहुचो, ते उनन देखो कि पतरस की सास जुड़ म पड़ी भई हैं। ");
INSERT INTO hlb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","उनना ओको हात छुवो करियो अऊर ओको जुड़ उतर गयो, अऊर वा उठ ख ओकी सेवा आदर करन लग गई। ");
INSERT INTO hlb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ते रात होन पर लोग बेजा से भूत ग्रस्त व्यक्ति हुन ख यीसु को नजीक ले आयो। यीसु न सब्‍द को दुवारा उन आत्मा हुन ख निकालो अर रोगी हुन ख अच्छो कर दियो। ");
INSERT INTO hlb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ऊईच परकार भविस्यवक्ता यसायाह की कही बात पूरो भयो: “ओ ना खुद हमारी कमजोरी ख सैय लियो अऊर हमारी बीमारी हुन ख उठा लियो।” ");
INSERT INTO hlb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","यीसु न अपनो चारो-तरफ एक बड़ी भीड़ दिख ख यीसु न झील को उ पार जाना को हुकुम दियो। ");
INSERT INTO hlb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ऊईच बखत एक सासतिरी आ ख ओसे कहयो, प्रभु जिते कही भी तू जाहे, मी तोरो पिछु-पिछु चलूंगो। ");
INSERT INTO hlb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","यीसु न ओसे कहयो, “कि लोमड़ी हुन ख लाने गुफा हुन हैं अर आकास कि पक्छी हुन ख गुड्डा हुन हैं; पर इंसान को पोरिया ख लाने मुंडी लुकान की भी जगह नी आय।” ");
INSERT INTO hlb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","चेला हुन म से कोई न ओ से कहयो कि, “प्रभु, मोखा पहले अपनो बाप ख गाड़ ख लाने जान दे।” ");
INSERT INTO hlb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ते यीसु न दास से बोल्यो कि, “तू मोरो पीछु चलो आ, अर मुर्दा हुन का अपनो मुर्दा गाड़न दे।” ");
INSERT INTO hlb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","जब यीसु नाव पर चढ़ियो, ते ओखा चेला ओखा पीछु चल हो लियो। ");
INSERT INTO hlb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","उ बखत झील म एक असो बड़ो तूफान उठो कि नाव लहर से ढकन लगो, अऊर यीसु नींद लेत रह हतो। ");
INSERT INTO hlb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ते चेला हुन नजीक आ ख ओको जगायो अऊर बोल्यो कि, “अरे प्रभु, हम ख बचा, हम नास होव जाय हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ओ ना उन से बोल्यो कि, “अरे कुछ दिन ख विस्वासी, काहे डर हैं?” तब ओ ना उठ ख आँधी को अऊर पानी ख डाँटियो, अर सब थम गयो। ");
INSERT INTO hlb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","अऊर वी अच्मभा कर ख कहन लग्या, “यू कसो इंसान हैं कि तुफान अर पानी भी ओको कहना माना हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","जब यीसु उ पार गदरेनी सहर हुन को देस म पहुँचियो, ते दो इंसान जेमा बुरी आत्मा हती रह मरघट से निकलत भई ओ ख मिली। वी इत्ती सक्तिसाली हती कि कोई उ रस्ता से जा सकत रह। ");
INSERT INTO hlb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","वी चिल्ला उठायो, “परमेस्वर को पोरिया, हम से तुम ख? का तू बखत से पहले हमका दुख देन ख इते आयो हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ओ से कुछ दूर पर ढ़ेर सारी डुक्कर हुन को एक झुण्ड चर रयो हतो। ");
INSERT INTO hlb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","बुरीआत्मा हुन न यीसु से कह ख विनती करी, “अदि तू हम ख निकला हैं, ते डुक्कर हुन को झुण्ड म भेज दे।” ");
INSERT INTO hlb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","यीसु न उन से कह, “जा ते बुरी आत्मा न उन व्यक्ति हुन से निकल ख डुक्कर हुन म समा गई अर पूरो जात हुन म जल्दी से ढाल पर से झील की तरफ झपट ख अर पानी म डूब ख मर गयो। ");
INSERT INTO hlb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","“डुक्कर ख चरान वाला भगीया” अर गाँव म जाय ख यू सब बात अऊर जिनमा बुरी आत्मा हुन हती उनको पूरो हाल कह ख सुनायो। ");
INSERT INTO hlb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ते पूरा सहर का अदमी हुन यीसु से मिलन ख लाने आयो, अऊर ओखा देख ख विनती करी कि हमारो सिवाना से बाहर चलो जा। ");
INSERT INTO hlb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ते यीसु नाव म चढ़ ख पार गयो, अऊर अपनो सहर म आयो। ");
INSERT INTO hlb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","उ बखत कुछ लोग हुन खटिया पर पड़िया हुए लकवा को एक बीमार ख उनका नजीक लायो। उनको विस्वास देख ख यीसु न लकुवे को बीमार से कय्हो कि, “पोरिया धीरज रख तुमारो पाप माप होय गयो।” ");
INSERT INTO hlb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ये पर कई सासतिरी हुन न सोचियो, “यु ते परमेस्वर को बुराई करा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","यीसु न ओके मन की बात समझ ख कय्हो, तू अदमी अपनो-अपनो मन म बुरो विचार काहे कर रया हैं? ");
INSERT INTO hlb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","जादा सही का हैं, अऊर यू कहनो, तुमारो पाप माप हो गयो हैं अऊर यू कहनो, उठ अर चल फिर? ");
INSERT INTO hlb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","पर एकोलाने कि तुम जान लेनू कि इंसान को पोरिया को धरती पर को पाप माप करन को हक हैं। तब ओ ना लकवा को बीमार वाला से कहयो “उठ, अपनो खटिया उठा, अर अपनो मकान म चलो जा।” ");
INSERT INTO hlb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","अऊर लकवा को बीमार उठ ख अऊर अपनो घर चल गयो। ");
INSERT INTO hlb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","यू देख ख व्यक्ति डर गया अऊर परमेस्वर कि बड़ाई करन लग गयो, जेना व्यक्ति हुन ख असो अधिकार दियो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","यीसु वहा से आगे बढ़ ख यीसु न मत्ती नाम को एक अदमी ख कर घर म बठियो देखो, अर ओसे कय्हो कि, मोरो पीछु हो ला उ उठ ख यीसु पीछु चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ते यीसु घर म खाना खान का लाने बठियो हतो ते बेजा सा कर लेन वालो अर पापी आय ख यीसु अर ओखा चेला हुन ख संग खाने बठो। ");
INSERT INTO hlb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","यू देख ख फरीसी हुन न ओखा चेला हुन से बोल्यो कि, तुम्हारो स्वामी कर लेन वालो अर पापी हुन को संग काहे खाय हैं। ");
INSERT INTO hlb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","यीसु न यू सुन ख ओसे बोल्यो कि, “वैध अच्छो भलो को लाने नी पर बिमार हुन ख लाने जरुरी हैं। ");
INSERT INTO hlb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","एकोलाने कि तुम जा ख ऐको मतलब सीख लेव म बलिदान नी पर दया चाहूँ हैं। काहेकि म धर्मी ख नी, पर पापी हुन ख बुलान आयो हूँ।” ");
INSERT INTO hlb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","तब यूहन्ना को चेला आयो अऊर बोल्यो कि, “का कारन हैं कि हम अऊर फरीसी ढ़ेर सारो उपास करा हैं, अर तोरो चेला उपास नी करा हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","यीसु न ओसे कय्हो, “जब तक दुला संग म हैं का बाराती हुन दुख मना नी सका हैं?” अऊर वी दिन आहे जब दुला उनको बीच म से अलग करो जाहे, उत्ती बखत से वी उपास करनो सुरू करे। ");
INSERT INTO hlb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","कोरो कपड़ा को थेगड़ा पुरानो कपड़ा अर कोई भी नी लगवा हैं, काहे कि उ थेगड़ा उ कपड़ा से कुछ खीच लेवा हैं, अर उ जादा फट जावा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","अर लोग नयो अंगूर को रस पुरानो चमडा म कोई नी भरा हैं, काहेकि असो करनो से चमडा हुन फट जावा हैं। अऊर अंगूर को रस बह जावा हैं अऊर चमडा नास हो अर जावा हैं; “अऊर नयो अंगूर को रस नयो चमडा म भरो जावा हैं अर वी दो ही बचो रवह हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","यीसु बीमार हुन से यू बात हुन बोल ही रयो हतो, कि एक मुखिया आय ख मुखिया न यीसु ख सामने पाय टेक ख यू बोल्यो, “कि मोरी पोरी कि अभी मरी हुई।” ते वी खुद चल ख पोरी पर हात रखे अऊर पोरी जिन्दी होय जाऐ। ");
INSERT INTO hlb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","यीसु उठ ख अपनो चेला हुन को संग ओको पिछु चल दियो। ");
INSERT INTO hlb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","तब देख, एक ओरत न जे ख बारा साल से खून बहिन को बीमार हती, वी पिछु से आ ख यीसु को कपड़ा ख छू लेहूँ ते अच्छी हो जाऊ। ");
INSERT INTO hlb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","काहेकि ओरत अपनो मन म बोल्यो हतो, “कि अदि म यीसु कपड़ा ही ख छी लेहूँ ते अच्छी हो जाऊ।” ");
INSERT INTO hlb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","यीसु न फिर ख ओरत देखो अऊर बोल्यो, कि पोरी धीरज धर, तोरो विस्वास न तोखा चोक्खो करियो हैं। अब वा ओरत उती ही बखत अच्छी हो गई। ");
INSERT INTO hlb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","जब यीसु मुखिया को घर म पहुँची अऊर बाँसुरी बजान वाला ख अऊर लोग हुन ख को रोत मारते देखियो, ");
INSERT INTO hlb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","तो कय्हो, “अगल हो जा पोरी मरी नी, हैं पर वा सोवा हैं।” इन पर वी यीसु कि हँसी कर गया। ");
INSERT INTO hlb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","जब भीड़ ख बाहर निकालो गयो, ते यीसु घर अन्दर जा ख पोरी को हात पकड़ीयो, अर वा जिन्दी हो उठी। ");
INSERT INTO hlb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","अऊर यी बात ख खबर उ पूरो देस म फैल गई। ");
INSERT INTO hlb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","यीसु वहाँ से आगे चलियो, ते दो अंधा यीसु का पिछु यू पुकार कर ख भयो चल्यो, “अरे दाऊद कि अवलाद, हम पर दया कर!” ");
INSERT INTO hlb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","जब यीसु घर म आयो, ते वी अंधो यीसु नजीक आयो, अर यीसु न वी अंधा से बोल्यो कि, “का तुम ख विस्वास हैं, कि म यू कर सकू हूँ?” वी दो अंधा यीसु कय्हो, “हाव, प्रभु!” ");
INSERT INTO hlb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","तब यीसु न दो अंधा हुन ख आँखी छी ख कय्हो, “तुमारो विस्वास ख अनुसार तुमारो लाने होय।” ");
INSERT INTO hlb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","अऊर दो अंधा हुन कि आँखी खुल गई। यीसु न दो अंधा हुन ख जता ख कय्हो, “सतरक रह, कोई यू बात ख नी जाने।” ");
INSERT INTO hlb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","अऊर वी अंधा हुन ना जाय ख पूरो देस म यीसु नाम को खबर फैला दियो। ");
INSERT INTO hlb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","दोई उन बाहर निकल ही रैया हता कि कई, लोग भूत से जकड़ा हुयो हतो एक गूँगा अदमी ख यीसु को नजीक लाया। ");
INSERT INTO hlb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","यीसु न दुस्टात्मा ख बाहर निकाल लियो अऊर उ गूगा बोलन लग गयो। लोग चकित म पड़ ख कहन लग गया, “इस्राएल म असो कभी नी देखियो गयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","पर फरीसी हुन न कय्हो, “यू ते दुस्टात्मा को मुखिया को मदद से बुरी आत्मा ख निकल हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","यीसु पुरो सहर अर गाँवो म फिर-फिर ख अऊर ओको प्रार्थना घर हुन म उपदेस देवा, अऊर राज्य को अच्छो खबर सुन्य रयो हतो, अऊर हर तरीका कि बीमारी अर कमजोरी ख दूर रहयो। ");
INSERT INTO hlb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","जब यीसु भीड़ ख देखियो ते ओ ख लोग हुन पर तरस आयो, काहेकि वी उन भेड़ को जसा हैं जेको कोई देखन वाला कोई नी होए उदास अऊर तुम गई जसी हती। ");
INSERT INTO hlb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ते यीसु अपनो चेला से कय्हो, “पकिया खेत ते बेजा हैं पर मजदूर थोड़ा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","एकोलाने खेत का मालिक से विनती कर कि यीसु अपनो खेत काटन का लाने मजदूर भेज देहे। ");
INSERT INTO hlb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","यीसु न अपनो बारा चेला ख नजीक म बुला ख, उन का बुरी आत्मा हुन पर अधिकार दियो कि उन निकाले अऊर पूरो तरीका कि बीमार हुन अऊर पूरो तरीका की कमजोरी हुन ख दूर करे। ");
INSERT INTO hlb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","यी बारा म प्रेरित हुन को नाम यू हैं: पहलो समोन, जे पतरस कहलावा हैं, अऊर ओको भई अन्द्रियास; जबदी को पोरिया याकूब, अऊर ओको भई यूहन्ना; ");
INSERT INTO hlb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","फिलिप्पुस, अऊर बरतुल्मै, थोमा, अऊर कर लेन वालो मत्ती, हलफई को पोरिया याकूब अर तद्दै, ");
INSERT INTO hlb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","समोन कनानी, अऊर यहूदा इस्करियोती जेन यीसु पकड़वा भी दियो। ");
INSERT INTO hlb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","यी बारा हुन ख यीसु न यू कहना देख ख ‌भेजियो, “कि गैर यहूदी हुन ख, अर नी जानु, अर सामरी हुन ख कोई भी सहर हुन म भीतर नी करनो।” ");
INSERT INTO hlb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","जब इस्राएल कि भी घरानो ही कि खोई भई भेड़ी हुन को नजीक जानु। ");
INSERT INTO hlb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","अऊर चलते-चलते यू खबर कर, स्वर्ग को राज निकट म आय गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","बीमार हुन ख अच्छो करो, मुर्दा हुन ख जिन्दो कर ख कोढ़ी हुन ख सुध्द कर, दुस्टात्मा ख निकाल ख। तुम, फिरी म मिलो हैं फिरी म दे दे। ");
INSERT INTO hlb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","अपनो थैला हुन म नी ते सोना, अऊर नी पैसा अऊर नी ताँबा रखनो; ");
INSERT INTO hlb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","रस्ता को लाने नी झोला रख, नी दो कुरता, नी जूता अऊर नी लाठी ले, काहेकि मजदूर ख ओको खाना मिलनू चाहिए। ");
INSERT INTO hlb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","जे कोई सहर अर गाँव म जाओ, ते मालूम कर कि वहा कोन लायक हैं। अर जब तक वहाँ से नी निकले, ओको ही यहाँ पर रहनो। ");
INSERT INTO hlb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","घर म भीतर आते बखत ओ ख आसीस दे जो। ");
INSERT INTO hlb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","अदि उ घर को अदमी लायक होए ते तुमारो ख सान्ति उन पर मिले पर अदि वी लायक नी हो ते तुमारो सान्ति तुमारो नजीक लउट आहे। ");
INSERT INTO hlb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","जे कोई तुम ख आदर नी कर अऊर तुम्हारी बात हुन नी सुने, ते उ घर अर उ सहर से निकलते बखत अपनो पाय हुन कि धूल झाड़ दे। ");
INSERT INTO hlb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","मी तुम से सच कहूँ हैं कि न्याय को दिन उ देस कि दसा से सदोम अऊर अमोरा को सहर हुन कि दसा जादा सहन लायक होए। ");
INSERT INTO hlb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“देख, मी तुम ख भेड़ी हुन को जसो भेड़ी हुन को बीच म भेजू हूँ, एकोलाने साँप हुन को जसो समझदार अऊर कबूतर हुन को जसो भलो बनो।” ");
INSERT INTO hlb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","पर इंसान से सतर का रहनो, काहेकि वी तुम ख बड़ी प्रार्थना घर हुन म सोपेगो, अऊर अपनी पंचायत हुन म तुमका कोड़ा मारेगो। ");
INSERT INTO hlb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","तुम मोरो लाने अधिकारी हुन अर राजा हुन को समाने तुम ख लायो जाहेगो, जसो मोरो बारे म तुम उनका अऊर गैर यहूदी हुन ख गवाई दे सके। ");
INSERT INTO hlb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","जब वी तुमका पकडवायगो ते या फिकर मत करनो कि हम कसो तरीका से या का कहेगो, काहेकि जो कुछ तुमका कहनो होए, उ उत्ती बखत तुमका बता दियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","काहेकि बोलन वाला तुम नी हाय, पर तुमरो बाप को आत्मा तुम म बोला हैं। ");
INSERT INTO hlb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","भई, भई का, अऊर बाप पोरिया ख, मार खलान को लाने सोपेगो, अऊर पोरिया पारी माय बाप को बारे म मार ड़ालन को लाने उठ ख उनका मरवा ड़ालेगो। ");
INSERT INTO hlb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","मोरो नाम को वजेसे सब इंसान हुन तुम से बैर रखेगो, पर जो आखरी लक धीरज धर ख रहे ओको ही उध्दार होए। ");
INSERT INTO hlb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","जब वी तुम ख एक सहर म सताहे, ते दूसरो सहर ख भग जानो। मी तुम से सच बोलू हैं, तुम इस्राएल देस ख पूरा सहर हुन नी घुम पानी का कि इंसान को पोरिया आ जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“चेला अपनो गुरू से बड़ो नी होवा; अऊर न दास अपनो मालिक से। ");
INSERT INTO hlb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","चेला को गुरू को, अर नउकर को मालिक को बराबर होनो ही बेजा हैं। जब उनना घर को मालिक ख सैतान बोल दियो। ते ओको घरवाला ख का कुछ नी बोलन का? ");
INSERT INTO hlb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“एकोलाने इंसान हुन से मत डरनो; काहेकि कुछ ढाको नी हाय कि जो खोलो नी जाहे, अऊर न कुछ छिपो हैं। जो जानो नी जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","जो मी तुम से अंधेरा म कहू हैं, ओखा तुम उजेलो म सुनाव; अर जो कान ही कान म सुना हैं, ओखा छत पा से प्रचार करा। ");
INSERT INTO hlb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","जे सरीर ख नुकसान पहुचावा हैं, पर आत्मा ख नुकसान नी पहुचा सका, ओसे मत डर; पर ओसे ही डरो, जो आत्मा अर सरीर दोई ख नरक म नास कर सका हैं। ");
INSERT INTO hlb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","का एक पैसा म दो गऊरैया नी बाकी हैं? तेभी तुमरो बाप कि मर्जी को बगैर उनमा से एक भी जमीन पा नी गिड़ा। ");
INSERT INTO hlb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","तुमरी मुंडी का बाल भी सब गिनिया वाला हैं। ");
INSERT INTO hlb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","एकोलाने डरनो मत; तुम ड़ेर सारी गऊरैया से बढ़ ख हैं। ");
INSERT INTO hlb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“जे कोई अदमी हुन ख सामने मोखा मान लेहे, ओखा म भी अपनो स्वर्गीय बाप ख सामने मान लेहूँ। ");
INSERT INTO hlb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","पर जे कोई अदमी ख सामने मोखा मना करे, ओ ख म भी अपनो स्वर्गीय परमेस्वर बाप ख सामने मना करू। ");
INSERT INTO hlb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“असो नी समझ कि म जमीन प सान्ति ले कर आयो हैं; म मिलान करन नी, पर तलवार चलान आयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","मीते आयो हूँ कि इंसान का ओको बाप से, अर पोरी का ओकी माय से, सर बहू को ओकी सास से अलग कर देहूँ; ");
INSERT INTO hlb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","इंसान को दुसमन ओखा घर का ही इंसान होऐ। ");
INSERT INTO hlb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“जे माय अर बाप ख मोसे प्रेम करा हैं, उ मोरो लायक नी हैं; अऊर जो पोरिया अऊर पोरी ख मो से जादा प्रेम करा हैं। उ मोरो लायक नी हैं ");
INSERT INTO hlb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","अऊर जो अपनो सूली लेख मोरो पिछु नी चले उ मोरो लायक नी हैं। ");
INSERT INTO hlb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","जे अपनो जान ख बचावा हैं, उ ओ ख खोएगो; अर जे मोरो कारन अपनो जान देवा हैं, उ ओखा मिले। ");
INSERT INTO hlb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“जे तुम ख सम्मान कर हैं, उ मोखा सम्मान कर हैं; अऊर जे मोखा स्वीकारा कर हैं उ मोरो भेजन वालो ख स्वीकारा कर हैं। ");
INSERT INTO hlb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","जे जोतिस ख भविस्यवक्ता मान ख ग्रहण करा हैं, वी भविस्यवक्ता हुन को बदला मिले; अऊर जे धर्मी ख धर्मी समझ ख स्वीकारा करा, वी धर्मी को बदला मिले। ");
INSERT INTO hlb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","जे भी कोई यी छोटा म से एक ख मोरो चेला समझ ख केवल एक लोटा ठंडो पानी पिलाहेये, ते म तुम से सच कहू हैं, उ कोई भी तरीका से अपनो इनाम नी खोए।” ");
INSERT INTO hlb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","अपना बारा चेला हुन ख यू कैय देन का बाद यीसु वहाँ से चलो गयो, अऊर उ यहूदी हुन को सहर हुन म सिखान लग गयो अऊर अच्छी खबर को बारे म परचार करन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","यूहन्ना न, जेल खाना म मसी को काम हुन की खबर सुनियो अर अपना चेला हुन से यू पूछन ख भेज्यो, ");
INSERT INTO hlb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“का आन वालो तूईच आय, कि हम अऊर कोई को रस्ता देखे?” ");
INSERT INTO hlb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","यीसु न उनका बोल्यो, “जे कुछ तुम सुना हैं अऊर देखा हैं, उ सब जा ख यूहन्ना से बोल देव, ");
INSERT INTO hlb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","अंधा देखा हैं अऊर लंगाडा हुन चला फिरा हैं, अऊर कोढ ख रोगी हुन सुध्द होते जावा सुध्द हैं, अर बहिरा हुन सुनते जावा हैं, मुर्दा हुन ख जिन्दो करो जाय हैं, अर गरीब हुन ख सुसमाचार सुनायो जावा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","अऊर भलो हैं उ, जो मोरो वजेसे ठोकर नी खान को।” ");
INSERT INTO hlb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","जब वी वहा से चल दिया, ते यीसु यूहन्ना को बारे म लोग हुन से कह न लग गयो, “तुम जंगल म का देखन ख गया हता? का हवा से हलते हुए सरकण्डा ख? नी ");
INSERT INTO hlb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ते फिर तुम का देखन ख गया रहा? का बड़िया कपड़ा पहिनिया वाला इंसान हुन ख? देखनु, जो बड़िया कपड़ा हुन पहिना हैं, वी राजा को महल म रहवा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ते तुम फिर काहे गया रहा? का कोई भविस्यवक्ता ख देखन ख? हाँ मी तुम से कहूँ हैं कि भविस्यवक्ता से भी बड़ो ख। ");
INSERT INTO hlb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","यू उईच आय, जेको बारे म ग्रंथ लिखो हैं, ‘परमेस्वर बोला हैं: देखनो, मी अपनो दूत ख तुमरो आगे भेजू हैं, जो तोरो आगे तोरो रस्ता तैयार करेगों।’ ");
INSERT INTO hlb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","मी तुम से सच कहूँ हैं, कि जे बाई चारा हुन से से पैदा भया हैं, ओमा से यूहन्ना बपतिस्मा देन वालो से कोई बड़ो नी भयो। फिर भी, पर जो स्वर्ग ख राज म सबसे छोटो हैं, उ यूहन्ना से बड़ो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","यूहन्ना बपतिस्मा देन वालो को बखत से अबा लक स्वर्ग ख राज म बेधड़क आनो जानो होते रयो हैं, अऊर बलवान ओखा छीन लेवा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","काहेकि सब भविस्वक्ता अर नेम यूहन्ना को बखत लक भविस्यवानी करते रया हैं। ");
INSERT INTO hlb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","अर चाहे तुम माने ते मोरी बात ख मान लेव कि एलिय्याह जो आवन वालो हतो, उ युईच आय। ");
INSERT INTO hlb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","जेका कान होय, उ सुन लेहे। ");
INSERT INTO hlb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“मी इ दुनिया कि तुलना कोसे करू?” वी बजार म बैठिया वाला पोरिया हुन क जसा हैं जो अपना संगी हुन ख हाँका लगा-लगा क बोलत होए: ");
INSERT INTO hlb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","हम न तुमारो लाने बाँसुरी बजाई अऊर तुम नी नचीया; हम न दुख मनायो पर तुम न दुख नी मनायो। ");
INSERT INTO hlb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","काहेकि यूहन्ना न खाते आयो, न पीते, अऊर वी कहत रा “ओमा दुस्टात्मा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","इंसान को पोरिया आयो। उ मामूली इंसान को जसो खावा पीवा हैं अऊर इंसान हुन बोला हैं: देखो, यू इंसान भूक्कड़ अर पेटू हैं। कर लेन वालो को संगी अधिकारी अर पापी हुन को दोस्त हैं। ");
INSERT INTO hlb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","तब यीसु वी सहर हुन ख धितकारन लग गयो जिनमा ओ ना सामर्थ्य ख ढ़ेर सारा काम करिया रहा, पर वहा का रहन वाला न यी सामर्थ्य को काम देख ख भी मन नी फिरायो करयो रहा। ");
INSERT INTO hlb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","यीसु न कय्हो, धितकार तोखा, खुराजीन! धितकार तोखा बैतसैदा! जो सामर्थ्य को काम तोमा करिया गया रहा हैं, अदि वी सूर अर सैदा म किया जाता, ते बोरा टाट ओढ़ ख, अर राँक म बैठ ख वी कब का मन फिरा लेता। ");
INSERT INTO hlb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","एकोलाने मी तुम से कहूँ हैं कि, न्याय को दिन तोरी दसा से सूर अर सदोम कि दसा कही जादा सहन करन को लायक होए। ");
INSERT INTO hlb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","अरे, कफरनहूम, का तू स्वर्ग लक ऊँचो करो जाएगो? तू ते अधोलोक लक नीचे गिरा दियो जाहे; काहेकि जे सामर्थ्य को काम जो तोमन काम करया गया रा, अदि वी सदोम म करा जाता, ते उ आज लक बनो रहतो। ");
INSERT INTO hlb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","एकोलाने मी तोसे कहूँ हैं कि न्याय को दिन तोरी दसा से भली सदोम देस कि दसा कई जादा सहन करन को लायक हैं। ");
INSERT INTO hlb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","वा बखत यीसु न कय्हो, “बाप! स्वर्ग अर जमीन को प्रभु! मी तोरी बड़ाई करूँ हैं; काहेकि तुना यी सब बात हुन ख ग्यानी अर समझदार हुन से छुपा ख रखयो; पर बाल-बच्चा हुन पा परगट करयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","हाँ, बाप! यूइच ही तोखा अच्छो लगियो।” ");
INSERT INTO hlb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","मोरो बाप न मोखा सब कुछ सोपियो हैं। अर पोरिया ख कोई नी जाना, पर सिर्फ पोरिया; अऊर न कोई परमेस्वर ख जाना हैं, पर सिर्फ बाप; अर नी कोई बाप का जाना सिर्फ पोरिया अर उ जेपर पोरिया ओखा प्रगट करनो चाहे। ");
INSERT INTO hlb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“अरे सब हरा-थकिया वाला बोझ से दबिया वाला इंसान! मोरो जोने आव। मी तुम ख आराम देहु। ");
INSERT INTO hlb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","मोरो बोझ अपनो ऊपर ले लेव अऊर मोसे सिखो; काहेकि मी सुभाव से मन म नम्र अर दीन हैं। असो कर ख तुम मन म सान्ति पायगो, ");
INSERT INTO hlb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","काहेकि मोरी बोझ सहज हैं अऊर मोरो बोझ हलको हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","यीसु कोई छुट्टी को रोज गहूँ की खेत हुन से हो ख जात रा। ओखा चेला हुन ख भूक लगी अऊर वी गहूँ की बाली टोड़-टोड़ ख खान लग गया। ");
INSERT INTO hlb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","यू देख फरीसी हुन न यीसु से कय्हो, “देखो, जो काम छुट्टी को रोज करनो मना हैं, तोरा चेला उईच कर रया हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","यीसु न उनसे बोल्यो, “का तुम इंसान हुन न यू नी पढ़िया कि जब दाऊद अऊर ओखा संग ख इंसान हुन ख भूख लगी, ते दाऊद न का करियो रा? ");
INSERT INTO hlb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","उ परमेस्वर को घर को भीतर गयो अऊर अपनो संगी हुन को संग भेंट की रोटी हुन खाई, जिनका खानो ओखा अऊर ओखा संगी हुन ख मना हतो। भेंट कि रोटी सिरप पूजारी हुन ही ख सकत रा। ");
INSERT INTO hlb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","अर का तुम इंसान हुन न मूसा को नेम म नी पढ़ियो कि पूजारी छुट्टी को रोज मन्दिर म आराम करन को दिन को उल्लंघन करनो पर भी दोसी नी ठहरा? ");
INSERT INTO hlb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","पर मी तुम से से कहूँ हैं कि पर इते उ हैं जे मन्दिर से भी बड़ो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","मी बलिदान नी, पर दया चाहूँ हैं अदि तुम इंसानहुन न या बात को मतलब समझ लियो होतो, ते बिनकसुर ख दोसी नी ठहराता। ");
INSERT INTO hlb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","काहेकि इंसान को पोरिया तो हफ्ता को दिन या छुट्टी को रोज को भी प्रभु हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","यीसु वहाँ से आगे बढियो अर उनको प्रार्थना घर म आयो। ");
INSERT INTO hlb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","वहाँ एक अदमी हतो, जेको हात सूख गयो रहा। उनना यीसु पर दोस लगान ख लाने ओसे यू पुछियो, “का छुट्टी को रोज अच्छो करनो नियम को हिसाब से सही हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","यीसु न उनसे बोल्यो, “तुम म असो कोन हैं जेकी एक ही भेड़ होय, अऊर उ छुट्टी को दिन गडडा म गिर जाय, ते उ ओखा पकड़ ख हेड नी ले? ");
INSERT INTO hlb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","इंसान तो भेड़ से कई बढ़ ख हैं! एकोलाने छुट्टी को रोज भलई करनो नेम को हिसाब से उचित हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","तब यीसु न उ अदमी से कय्हो, “अपनो हात ख बढ़ा।” ओ ना अपनो हात बढ़ायो, अऊर उ फिर दूसरो हात को जसो अच्छो हो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ऐपर फरीसी हुन सभा घर से बाहर निकलिया, अऊर उनना यीसु को बारे म सला करी कि हम ओखा कसो तरीका से खतम करे। ");
INSERT INTO hlb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","यू जान ख यीसु वहाँ से चल दियो। अऊर ढ़ेरसारा इंसान हुन ओको पिछे चलन लग गया, अऊर ओ ना सब ख अच्छो करियो, ");
INSERT INTO hlb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","अऊर उन ख जतायो कि मोरो बारे म कोइ ख मत बतानो, ");
INSERT INTO hlb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","असो तरीका से भविस्यवक्ता यसायाह को वचन पूरो भयो: ");
INSERT INTO hlb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“यू मोरो सेवक आय, जेका मी न चुनियो हैं; यू मोरो अच्छो को पोरिया आय, जेसे मोरो मन बेजा खुस हैं: मी ऐका अपनी आत्मा देऊगो, अऊर उ गैर यहूदी हुन का न्याय की खबर देहे। ");
INSERT INTO hlb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","उ न तो लड़ई झगड़ा करेगों, अऊर न हाँका लगायगो, अऊर न कोइ चऊक म कोइ ऐकी आवाज सुनेगो। ");
INSERT INTO hlb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","यू न तो कुचलियो वालो सरकण्डा ख नी टोड़न को, अऊर न धुवा देन वाली बत्ती ख बुझायगो, जब तक उ न्याय ख जीत नी लेन को। ");
INSERT INTO hlb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","एको नाम पर सब गैर यहूदी आसा रखेगो।” ");
INSERT INTO hlb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","तब इंसान हुन एक अंधो-गूँगो ख जेमा भूत-प्रेत हतो, यीसु को जोने लाया; अऊर ओ ना ओखा अच्छो करियो, अऊर उ गूँगा बोलन अऊर देखन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","येपर सब इंसान हुन हईरान हो ख कहन लग गया, “कई यूई तो दाऊद को गोत को नी आय?” ");
INSERT INTO hlb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","पर फरीसी हुन न यू सुन ख बोल्यो, यू तो दुस्टात्मा को मुखिया बालजबूल कि मदत को बगर भूत-प्रेत ख नी निकाला सका। ");
INSERT INTO hlb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","यीसु न ओकी मन कि बात जान ख ओसे कय्हो, जे कोई राज्य म फूट होवा हैं, उ उजड़ जावा हैं; अऊर कोई सहर अर घराना जेमा फूट होवा हैं, बनो नी रहन को। ");
INSERT INTO hlb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","अऊर यदि सैतान ही, सैतान ख निकले, ते उ अपनो, ही बैरी हो गयो हैं; फिर ओको राज कसो बनो रैय सका हैं? ");
INSERT INTO hlb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","भलो हैं, अदि मी‍ बालजबूल दुस्टात्मा कि मदत से दुस्टात्मा ख निकालू हैं, ते तुमरी खानदान कोकी मददत से निकाला हैं? एकोलाने वीइच ही तुमरो फैसला करे। ");
INSERT INTO hlb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","पर अदि मी परमेस्वर कि आत्मा कि मददत से दुस्टात्मा ख निकालू हैं, ते परमेस्वर को राज तुमरो जोने आ गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“या फिर, कसो कोई इंसान कोई बलवान को घर म घुस ख ओको घर को माल लूट सका हैं”, जब लक कि पहलो उ घर धनी ख बाँध नी लेन को? तब जा ख उ ओको घर को माल लूट सका हैं। ");
INSERT INTO hlb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","जे मोरो संग नी हैं, उ मोरो विरोध म हैं, अऊर जे मोरो संग नी बिना उ बिखरावा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","एकोलाने मी तुम से कहूँ हैं कि इंसान को सब तरीका को पाप अऊर बुराई छमा करी जाहे। पर सुध्द आत्मा की बुराई की छमा नी करी जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","जे कोई इंसान को पोरिया को खिलाप म कुछ बात कहे, ओखा यू अपराध छमा कियो जाहे, पर जे कोई सुध्द आत्मा को खिलाप म कुछ काहे, ओको अपराध, नी तो यू लोक म अऊर नी परलोक म छमा कियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“अदि तुम कोई झाड़ ख अच्छो माना हैं”, ते ओको फल ख भी अच्छो मानो, अऊर अदि झाड़ ख बुरो माना हैं, ते ओको फल ख भी बुरो मानो; काहेकि, “झाड़ तो अपनो फल से ही पहिचानो जाय हैं”। ");
INSERT INTO hlb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","अरे साँप ख बच्चा हुन तुम बुरा हो ख कसी भली बात कह सका हैं? काहेकि जो मन म भरो हैं, उईच मुंडो पर आवा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","भलो इंसान मन को भलो भण्डार से भली बात हुन निकाला हैं अऊर बुरो इंसान बुरो मन को भण्डार से बुरी बात निकाला हैं। ");
INSERT INTO hlb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","अऊर मी तुम इंसान हुन से कहूँ हैं कि जो-जो बेकार कि बात हुन इंसान बोले, न्याय को दिन वी हर एक बात को लेखा देहे। ");
INSERT INTO hlb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","काहेकि, “तू अपनी बात हुन को वजे से बेकसूर, अऊर अपनी बात ही को वजेसे दोसी ठहरायो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","येपर कुछ सासतिरी अऊर फरीसी हुन न ओसे कय्हो, “अरे गुरू, हम तोसे एक चिखान देखनो चाहवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","यीसु न उनका जुवाब दियो, यू जमाना का अऊर बुरा अऊर छिनाला वाला इंसान चिन्ह ढूँढ़ा हैं परन्तु योना भविस्यवक्ता को चिन्ह का छोड़ कोई अऊर चिन्ह उनका नी दियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","योना तीन रात दिन पानी म रहन वाली मच्छी को पेट म रयो वसो ही इंसान को पोरिया भी तीन रात दिन जमीन को भीतर रहे। ");
INSERT INTO hlb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","नीनवे का इंसान न्याय को रोज यू जमाना का इंसान हुन को संग उठ ख उनका दोसी ठहरायगो, काहेकि उन ना योना को प्रचार सुन ख मन फिरायो; अऊर देखनो, यहाँ उ हैं जो योना से भी बड़ो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","दक्छिन की रानी न्याय को दिन यू जमाना ख इंसान हुन को संग उठ ख उनका दोसी ठहरायगो, काहेकि वा सुलैमान को ग्यान सुनन को लाने धरती को छोर से आई; अऊर देखनो, यहाँ उ हैं जो सुलैमान से भी बड़ ख हैं। ");
INSERT INTO hlb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","जब बुरी आत्मा इंसान को अंदर म से निकल जावा हैं। ते सुकी वाली जगा म ठिकाना ढूँढ़ते फिरा हैं अऊर ओखा जगा नी मिला। ");
INSERT INTO hlb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","तब बोला हैं, मी अपनो उईच घर म जहाँ से निकली रा, लउट ख चल देहु। अऊर लउट ख ओखा सुनो अऊर साफ-सुतरो अऊर सिंगरो-सिंगरायो मिला हैं। ");
INSERT INTO hlb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","तब वा जा ख अपनो से अऊर सात बुरी आत्मा हुन ख अपनो संग म लेका आवा हैं, अऊर वी ओमा बैठ ख रहन लग जावा हैं, अऊर उ इंसान कि दसा पहले से भी जादा बिगड़ देवा हैं। यू जमाना ख बुरा इंसान हुन की दसा भी असीच होयगो। ");
INSERT INTO hlb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","जब यीसु भीड़ से बात कतर ही रहा, तब ओकी माय अऊर भई बाहर खड़ा हता अऊर ओसे बात करन की सोचत रहा। ");
INSERT INTO hlb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","कोई न यीसु से कय्हो, “देख, तोरी माय अऊर तोरा भई बाहर खड़ा हैं, अऊर तोसे बात करन करन की सोचा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","यू सुन ख यीसु कहन वाला हुन से बोल्यो, “कोन आय मोरी माय? अऊर कोन आय मोरा भई?” ");
INSERT INTO hlb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","अऊर अपनो चेला हुन कि तरफ अपनो हात बढ़ा ख कय्हो, “देखो, मोरी माय अऊर मोरो भई हुन यी आय। ");
INSERT INTO hlb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","काहेकि जो कोई मोरो स्वर्ग म रहन वालो परमेस्वर बाप कि मर्जी पर चला हैं, उईच ही मोरो भई, अऊर मोरी बहिन, अऊर मोरी माय आय।” ");
INSERT INTO hlb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","यीसु उईच दिन घर से निकलियो अऊर झील को किनार म बठ गयो। ");
INSERT INTO hlb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","अऊर ओको नजीक असी बड़ी भीड़ इकट्ठी भई कि उ नाव पर चढ़ गयो, अऊर सारी भीड़ किनार म खड़ी राई। ");
INSERT INTO hlb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","अऊर यीसु न ओसे उदाहरन म बेजा सारी बात कही: “एक बोवन वालो बीज बोन निकलो”। ");
INSERT INTO hlb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","बोते बखत कुछ बीज रस्ता का किनार म गिडिया अऊर चिड़िया हुन न आय ख उनका बीन लियो। ");
INSERT INTO hlb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","कुछ दाना पत्थर वाली जमीन पर गिड़िया, जिते ओखा जादा मिठ्टी नी मिली अऊर जादा मिठ्टी नी मिलन को वजे से उ दाना जल्दी उग आयो। ");
INSERT INTO hlb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","पर घाम निकलनो पर वी मुर्झा गया, अऊर जड़ नी गहरी लम्बी होन को कारन से सुख गया। ");
INSERT INTO hlb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","कुछ दाना झाड़ी हुन म गिढ़ियो अर झाड़ी हुन न बढ़ ख उनका दबा दियो। ");
INSERT INTO hlb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","पर कुछ दाना अच्छी जमीन पा गिढ़ियो, अऊर ओमन दाना लगियो, कोई म सव गुना अऊर कोई म साठ गुना अऊर कोई म तीस गुना। ");
INSERT INTO hlb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“जेका कान होय उ सुन ले।” ");
INSERT INTO hlb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","यीसु का चेला हुन न नजीक आका ओसे कय्हो, “तू सब इंसान हुन से उदाहरन म काहे बात करा हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ओ ना जुवाब दियो, तुम ख स्वर्ग राज को भेद जानन कि समझ दी गई हैं, पर उनका नी। ");
INSERT INTO hlb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","काहेकि जेको जोने हैं, ओखा अऊर भी दियो जाहे, अऊर ओको जोने ढ़ेर सारो हो जाहे। पर जेको जोने कुछ भी नी हाय, ओसे जो कुछ ओको जोने हैं, उ भी ले लियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","मी उनका उदाहरन म ग्यान सिखाऊँ हैं, काहेकि वी देखनो पर भी देखा अऊर सुननो पर भी नी सुना न समझा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ओको बारे म यसायाह कि या भविस्यवानी पूरी होऐ हैं: तुम कान हुन से ते सुने पर समझे नी; अऊर आँख हुन अर से ते देखे, पर तुम ख नी सूझे। ");
INSERT INTO hlb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","काहेकि इन लोग हुन का मन मोटो हो गयो हैं, अर वी कान हुन से उँचो से सुन हैं अऊर उनना अपनी आँखी बंद कर ली हैं; वी आँख हुन बन्द कर ली हैं; कही असो नी हो कि वी आँख हुन से देखे, अर कान हुन से सुने अर मन से समझे, अर फिर जाहे, अर मी उन ख अच्छो करूँ। ");
INSERT INTO hlb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“अऊर भलो हैं, तुमारो आँखी, कि वी देखत हो; अऊर तुमारो कान कि वी सुन हैं। ");
INSERT INTO hlb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","काहेकि मी तुम से सच कहूँ हैं कि बेजा से भविस्यवक्ता न अऊर धर्मी हुन न चाहयो कि जे बात तुम देखत हो, देखे, पर नी देखे; अऊर जे बात तुम सुनो हैं, पर नी सुनो।” ");
INSERT INTO hlb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“अब तुम बीज बोवन वालो ख उदाहरन को मतलब सुनो: ");
INSERT INTO hlb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","जे कोई राज को वचन सुन ख नी समझ हैं, ते ओको मन म जे कई बोयो गयो हतो, ओ ख उ दुस्ट आय ख छीन ले जाय हैं। यी उही आय, जे रस्ता ख किनारा बोयो गयो हतो ");
INSERT INTO hlb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","अऊर जे पथरीली भूमि पर बोयो गयो, यू उही आय, जे वचन सुन ख जल्दी खुसी का संग ख मान लेव हैं। ");
INSERT INTO hlb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","पर अपनो म जड़ नी धरन का कारन उ थोड़ा ही दिन को हैं, अऊर जब वचन को करन अऊर दुख अर उपद्रव होऐ हैं। ");
INSERT INTO hlb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","जे झाड़ी हुन म बोयो गयो हैं, यू उ आय, जे वचन ख सुन हैं, पर यू दुनिया कि चिन्ता कर हैं अऊर धन ख धोखा वचन ख दबाव हैं, अऊर उ फल नी लाव। ");
INSERT INTO hlb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","जे अच्छो जमीन म बोयो गयो, यू उ आय, जे वचन ख सुन ख समझ हैं, अऊर फल लाय हैं, कोई सव गुना।” ");
INSERT INTO hlb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","यीसु न उन ख एक अऊर उदाहरन दियो: “स्वर्ग को राज उस अदमी ख जसो हैं, जे न अपनो खेत म अच्छो बीज बोयो। ");
INSERT INTO hlb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","पर जब लोग सो रहे हता ते ओको दुसमन आँख गहूँ को फसल म जंगली दाना बोय ख चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","जब कोम फूटी अऊर उमबी लगी, तब जंगली दाना को झाड़ भी दिखई दियो। ");
INSERT INTO hlb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","यी पर घर का दास न आँख ओसे कय्हो, ‘अरे मालिक, का तुम न अपनो खेत म अच्छो बीज नी बोयो हतो? फिर जंगली दाना को पऊधा ओ म कहा से आयो?’ ");
INSERT INTO hlb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ओ ना ओसे कय्हो, ‘कि यू कई दुसमन को काम आय।’ दास हुन न ओसे कय्हो, कि तोरी इच्छा हैं, कि हम जाय ख ओ ख बटोर ले? ");
INSERT INTO hlb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","मालिक न जवाब दियो, नई कई असो नई होय की कय्हो, कि असो नी होय की जंगली दाना का पऊधा जमा करते बखत ख तुम गहूँ ख भी जड़ से उखाड़ डाल। काटन तक दोई ख संग संग म बढ़न दा। ");
INSERT INTO hlb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","कटनी तक दोई को एक संग बढ़ दे, अऊर कटनी को बखत म काटन वाला से कहूँ; कि पहले जंगली दाने को पऊधा बटोर ख जलान ख लाने उनको गट्ठे बाँध ले, अऊर गहूँ को मोरो बखारी म जमा कर।” ");
INSERT INTO hlb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","यीसु न ओखा सामन एक अऊर उदाहरन दियो; स्वर्ग को राज राई को एक दाना को जसो हैं, जेको कोई अदमी न लेख अपनो खेत म बो दियो। ");
INSERT INTO hlb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","उ सब बीज हुन से छोटो ते होय हैं, पर जब बढ़ जाय हैं ते सब सब्जी भाजी से बड़ो होय हैं, अऊर असो झाड़ होय जाय हैं, कि आकास को चिड़िया आँख ओकी डाली हुन पर बसेरा करत हैं। ");
INSERT INTO hlb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","यीसु एक अऊर उदाहरन उन ख सुनायो: “स्वर्ग को राज खमीर को जसो हैं जोकी कोई बाई न लेख तीन पसेरी आटा म मिला दियो अऊर होय-होय उ सब खमीरा होय गयो।” ");
INSERT INTO hlb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","यी सब बात यीसु न उदाहरन म अदमी हुन से कय्हो। अऊर बिना उदाहरन उ ओसे कुछ नी कहत रहा, ");
INSERT INTO hlb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","कि जे वचन भविस्यवक्ता को दुवारा कय्हो गयो हतो, उ पूरो हो; म उदाहरन कह ख लाने अपनो मुँह खोलूगा मी उन बात हुन ख जे दुनिया कि आरम्भ से छुपा रयो हैं प्रगट करूँ। ");
INSERT INTO hlb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ते उ भीड़ ख छोड़ ख घर म आयो, अऊर ओको चेला न ओखा नजीक आँख कय्हो, “खेत ख जंगली बीज को उदाहरन हम ख समझा दे।” ");
INSERT INTO hlb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","यीसु उन ख कहयो दियो, “अच्छो बीज को बोन वालो इंसान को पोरिया आय। ");
INSERT INTO hlb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","खेत दुनिया आय, अच्छो दाना राज को खानदान हैं, अऊर जंगली बीज बुराई ख खानदान आय। ");
INSERT INTO hlb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","जे दुसमन न उन ख बोयो उ सैतान आय, कटनी जमाना ख अन्त हैं अऊर काटनवालो स्वर्गदूत आय। ");
INSERT INTO hlb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","अब जसो जंगली दाने बिनो जाहे हैं अऊर जलायो जाहे हैं असो ही दुनिया को आखरी म होय। ");
INSERT INTO hlb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","इंसान को पोरिया अपनो स्वर्गदूत हुन ख भेजे, अऊर उ ओको राज म से सब ठोकर को कारन हुन ख अऊर बुरो काम करन वाला को एक जुट करे, ");
INSERT INTO hlb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","अऊर उन ख आग को कुण्ड म डालो जाहे, जहाँ पर रोनू अऊर दाँत पीसना होय। ");
INSERT INTO hlb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","उ बखत धर्मी अपनो बाप को राज म धूप को जसो चमकेगो। जेका कान हैं, उ सुन ले। ");
INSERT INTO hlb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“स्वर्ग को राज खेत म छुपो हुयो धन को जसो हैं, जे कोई अदमी नी पायो अऊर छुपा दियो अऊर मरे खुसी ख जाख अपनो सब कुछ बेच देहे अऊर उ खेत को खरीदो ले लियो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“फिर स्वर्ग को राज एक खरीदेन को जसो हैं, जे अच्छो मोती हुन कि खोज म हतो। ");
INSERT INTO hlb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","जब ओ ख एक बेजा किमती मोती मिले ते ओ न जा ख अपनो सब कुछ बेच डालो अऊर ओ ख खरीद ले लियो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“फिर स्वर्ग को राज उ बड़ो जाल ख जसो हैं जो समुंदर म डालो गयो, अऊर सब तरीका कि मच्छी हुन ख इकट्ठा कर लियो। ");
INSERT INTO hlb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","अऊर जब जाल भर गयो, ते मच्छी हुन ओ ख समुंदर को किनारा पर खीच लायो, अऊर बैठ ख ‍ चोक्खो-चोक्खो ते टोपली म एक जुट करी अऊर बेकार फेक दियो। ");
INSERT INTO hlb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","दुनिया को आखरी म असो होय। स्वर्गदूत आँख बुरा काम दुस्ट हुन ख धर्मी हुन से अगल करिये, ");
INSERT INTO hlb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","अऊर उन ख आग को कुण्ड म डालो जाहे। जहाँ रोनू अऊर दाँत पीसना होय। ");
INSERT INTO hlb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“का तुम लोग यू सब बात समझ गया?” चेला हुन कय्हो “हव”। ");
INSERT INTO hlb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","यीसु न उन से कय्हो, “एकोलाने हर एक सासतिरी जे स्वर्ग को राज को चेला हुन बन हैं, ते उ घर को जसो हैं, जे अपनो भण्डार से नयो अऊर पुराना चीज हुन निकाल हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","जब यीसु यू पूरो उदाहरन ख कह चुको, ते वहा पर से चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","अऊर अपनो सहर म आँख उन ख प्रार्थना घर म उन ख असो ग्यान देन लगो कि वी अचम्भा हो ख कहन लगो, “ऐका यू ग्यान अऊर सामर्थ्य को काम कहा से मिलो? ");
INSERT INTO hlb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","का यू बड़ाई को पोरिया नी? अऊर का ऐकी माय को नाम मरियम अऊर ऐका भईहुन को नाम याकूब, यूसुफ, समोन अऊर यहूदा नी? ");
INSERT INTO hlb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","अऊर का ऐकी सब बहिन हमारा बीच म नी रहत हती? फिर ऐको यू सब कहाँ से मिलो?” ");
INSERT INTO hlb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","यी तरीका से लोग हुन ओको कारन ठेस खाई। पर यीसु न उन ख कय्हो, कि भविस्यवक्ता ख अपनो देस अऊर अपनो घर ख छोड़ अऊर कही अपमान नी होय। ");
INSERT INTO hlb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","अऊर ओ न वहाँ उनको अविस्वास ख कारन सारो सामर्थ्य को काम नी करियो। ");
INSERT INTO hlb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","उ बखत चऊथाई सहर को राजा हेरोदेस न यीसु को बारा सुनो, ");
INSERT INTO hlb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","अऊर अपनो सेवक हुन से कय्हो, “यू यूहन्ना बपतिस्मा देन वालो आय! उ मरो हुयो म से जिन्दो होय ख उठो हैं, एकोलाने ओकी सामर्थ्य को काम दिखा होव हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","काहे कि हेरोदेस न अपनो भई फिलिप्पुस कि घर वाली हेरोदियास का कारन, यूहन्ना ख पकड़ ख बाँधो अऊर जेल घर म डाल दियो हतो। ");
INSERT INTO hlb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","काहे कि यूहन्ना न ओसे कय्हो हतो कि ऐको ख रखनो तोरो लाने अच्छो नी हैं। ");
INSERT INTO hlb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","एकोलाने यूहन्ना ख मार डालनो कि मर्जी हती, पर अदमी हुन से डर हतो काहेकि वी ओ ख भविस्यवक्ता मानत हतो। ");
INSERT INTO hlb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","पर जब हेरोदेस को जनम दिन आयो, ते हेरोदियास कि पोरी न पोगराम म नाच दिखा ख हेरोदेस ख खुस कर दियो। ");
INSERT INTO hlb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","एकोलाने हेरोदेस न कसम खा ख वादा दियो, “कि जे कुछ भी तुम माँगे, ओ ख म तोखा दा हूँ।” ");
INSERT INTO hlb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","अर वा अपनी माय ख उचकानो से बोली, “यूहन्ना बपतिस्मा देनेवालो को सिर कोपर म ऊईच मो ख मँगवा दे।” ");
INSERT INTO hlb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","राजा उदास हुयो, पर अपनो कसम ख, अऊर संग म बैठने वालो का कारन, कहना दियो कि दे दियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","अऊर हेरोदेस न जेल घर म सैनिक हुन ख भेज ख यूहन्ना की मुण्डी काट दियो; ");
INSERT INTO hlb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","अऊर यूहन्ना को मुण्डी ख कोपर म लायो गयो अऊर पोरी ख दियो, जेको वा अपनी माय ख नजीक ले आई। ");
INSERT INTO hlb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","तब यूहन्ना को चेला आया ख अऊर यूहन्ना को लास ख ले जाय ख गाड़ दियो, अऊर जाख यीसु को खबर दियो, ");
INSERT INTO hlb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","जब यीसु न यू सुनो ते उ नाव पर चढ ख वहा से सुनसान जगह पर, अकेला म चलो गयो। व्यक्ति यू सुन ख सहर-सहर म से पैदल ही ओके पिछे चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","यीसु न निकल ख एक बड़ी भीड़ देखी अऊर उन पर तरस खायो, अऊर यीसु न बीमार हुन ख अच्छो कर करियो। ");
INSERT INTO hlb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","जब रात हुई ते ओखा चेला न ओखा नजीक आँख बोल्यो, “कि यू सुनसान धरती हैं अऊर बखत होय रयो हैं; लोग हुन ख भेज दियो जाये कि उ महोला हुन म जाख अपनो लाने खान खरीद ले।” ");
INSERT INTO hlb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","पर यीसु न ओ न से कय्हो, “ओ ख जानो जरुरी नी हैं! तुम ही इन ख खान ख दे।” ");
INSERT INTO hlb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","उनना ओसे कय्हो, “यहाँ हमारो पास पाँच रोटी अर दो मच्छी हुन ख छोड़ अर कुछ नी हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ओ न कय्हो, “उन ख यहाँ मोरो नजीक ले आ।” ");
INSERT INTO hlb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","तब ओ न अदमी हुन ख घास पर बैठन ख कय्हो, अऊर उन पाँच रोटी हुन अर दो मच्छी हुन ख लियो; अऊर स्वर्ग को तरफ देख ख धन्यवाद करियो अऊर रोटी हुन लेख तोड़-तोड़ ख चेला ख दियो, अर चेला न व्यक्ति हुन ख। ");
INSERT INTO hlb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","अर जब सब न खा भरपूर हो गयो, ते चेला न बचो भयो टुकड़ा से भरी हुई बारा टोकनी हुन उठायो। ");
INSERT INTO hlb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","अर खान वाले बाई हुन अर पोरिया हुन ख छोड़ ख पाँच हजार अदमी हुन ख लगभग हता। ");
INSERT INTO hlb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","तब ओ न जल्दी अपनो चेला ख नाव पर चढन को लाने बाध्य कियो कि उ ओ ख पहले पार चलो गया आय, जब तक वी अदमी हुन ख भेज दियो। ");
INSERT INTO hlb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","उ अदमी हुन ख विदा कर, विनती करन को अलग पहाड पर चलो गयो, अऊर रात ख उ वहाँ अकेलो हतो। ");
INSERT INTO hlb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","उ बखत नाव कि झील को बीच लहर से हिल रही हती, काहेकि हवा सामना कि हती। ");
INSERT INTO hlb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","अऊर यीसु रात ख चऊथ पहर झील पर चलत भयो उन ख पास आयो। ");
INSERT INTO hlb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","चेला हुन ओ ख झील पर चलते हुए देख ख घबरा गयो। अऊर कहन लगो, यू भूत ते नी अर डर ख मारे चिल्लान लगो। ");
INSERT INTO hlb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","“ते यीसु न जल्दी से उन से बात करी अर कय्हो, हिम्मत रख म हूँ, डर नी!” ");
INSERT INTO hlb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","पतरस न ओ ख बोल्यो दियो, अरे प्रभु, तू आय, ते मो ख अपनो नजीक पानी पर चल ख आवन ख लाने कह दे। ");
INSERT INTO hlb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","यीसु न कय्हो, “आ” ते पतरस नाव पर से उतर ख यीसु का नजीक आन का लाने पानी पर चलन लगो। ");
INSERT INTO hlb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","पर हवा को देख ख डर गयो, अऊर जब डूबन लगो ते पुकार ख कय्हो, “अरे प्रभु मोखा बचा!” ");
INSERT INTO hlb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","यीसु न जल्दी हात बढ़ ख ओ ख पकड़ लियो अऊर ओ ख कय्हो, “अरे कुछ दिन ख विस्वासी, तू न काहे सक करियो?” ");
INSERT INTO hlb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","जब उ नाव पर चढ गयो, ते हवा रूक गई। ");
INSERT INTO hlb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","यू पर उन ख जो हता नाव पर हता ओ ख पाय पढ़ ख कय्हो, “सच मुच तू परमेस्वर को पोरिया आय।” ");
INSERT INTO hlb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","वी पार उतर ख गन्नेसरत जगह म पहुँचिया। ");
INSERT INTO hlb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","वहाँ का अदमी हुन ओसे पहचान लियो अऊर आस पास को पूरा देस म खबर भेजो, अऊर सब बीमारो ख ओखा नजीक लायो, ");
INSERT INTO hlb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","अऊर ओसे विनती करन लगो कि उ उन ख अपनो कपड़ा को पल्लू ही ख छुवन दे; अऊर जितनो न ओ ख छूओ उ चोक्खो होय गया। ");
INSERT INTO hlb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","तब यरूसलेम से कुछ फरीसी अऊर सासतिरी यीसु का नजीक आयो ख कहन लग्यो, ");
INSERT INTO hlb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“तोरो चेला सियाना हुन को रीति रिवाज हुन ख काहे मान नी हैं, कि बिना हात धोऐ रोटी खावा हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","यीसु उन से कय्हो दियो, तू भी अपनो रीति रिवाज ख कारन काहे परमेस्वर को आदेस का टाला हैं? ");
INSERT INTO hlb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","काहे कि परमेस्वर न कय्हो हैं, अपनो बाप अऊर अपनी माय ख आदर करनु अऊर जे कोई बाप अर माय ख बुरो कहे, उ मार डालो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","पर तुम कवह हैं, कि यदि कोई अपनो बाप अऊर माय से कहे, जे कोई तोसे मोखा से फायदा पहुँचाए सक हैं ते, उ परमेस्वर ख दान दे जा चूका, ");
INSERT INTO hlb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ते उ अपनो बाप ख आदर नी करे, यू तीरका तुम न अपनो रीति रिवाज का कारन परमेस्वर को वचन टाल दियो। ");
INSERT INTO hlb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","अरे कपटी हुन, यसायाह न तुमारो बारे म यी भविस्यवानी ठीक करी हैं: ");
INSERT INTO hlb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“यी पर अदमी होठ हुन से ते मोरो आदर करा हैं, पर उनको मन मोसे दूर रहवा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","अऊर यी बेकार मोरी भक्ती कर हैं, काहे कि अदमी हुन कि विधि हुन ख धर्मोपदेस कर ख सिखाव हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","तब यीसु अदमी हुन ख अपनो पास बुला ख उन ख कय्हो, “सुन, अऊर समझ: ");
INSERT INTO hlb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","जो मुन्डा म जाय हैं, उ अदमी हुन ख बेकार नी कर, पर जे मुँह से निकल हैं, उही अदमी हुन ख असुध्द करा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","तब चेला हुन न आय ख यीसु कय्हो, “कि का तू जाना हैं कि फरीसी हुन न यू वचन सुन ख ठोकर खायो हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","यीसु बोल्यो दियो, “हर पऊधा जे मोरो स्वर्गीय बाप न नी लगायो, उखाड़ जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","अऊर उनख जान दे; वी अंधा रस्ता दिखावा हैं अऊर अंधा अगर अंधा का रस्ता दिखाए, ते दोई ही गड्डा म गिर पड़े।” ");
INSERT INTO hlb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","यू सुन ख पतरस न उन से कय्हो, “यू उदाहरन हम ख समझा दे।” ");
INSERT INTO hlb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","यीसु कय्हो, “का तुम भी अब तक नासमझ हैं? ");
INSERT INTO hlb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","का तुम नी जाना हैं कि जे कुछ मुँह म जाय हैं उ पेट म पड़ हैं, अर संड़ास से निकल जाय हैं? ");
INSERT INTO hlb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","पर जे कुछ मुँह से निकल हैं, अऊर उ मन से निकला हैं, उही अदमी हुन ख बेकार कर हैं। ");
INSERT INTO hlb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","काहेकि बुरा विचार, हत्या, पस्तरीगमन, गलत काम, चोरी, झूठो गवाही अऊर बदनामी मन ही से निकल हैं। ");
INSERT INTO hlb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","यी आय हैं जे इंसान ख असुध्द करा हैं, परन्तु हात बिना धोए खाना करनो इंसान ख बेकार नी कर।” ");
INSERT INTO hlb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","यीसु वहाँ से निकल ख, सूर अऊर सैदा ख सहर कि तरफ चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","उ सहर से एक कनानी बाई निकली, अर चिल्ला ख कहन लगी, “अरे प्रभु! दाऊद कि अवलाद मोखा पर दया कर! मोरी पोरी ख बुरी आत्मा बेजा सता रही हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","पर यीसु ओसे कुछ नी बोल्यो। तब ओको चेला न आय ख ओसे प्रार्थना कि, “यी ख भेज ख, काहे कि उ हमारो पिछु चिल्लाती भई आ रही हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","यीसु न कय्हो दियो, “इस्राएल ख घराना कि खोई हुई भेड़ ख छोड़ म कोई पास म नी भेजा गयो।” ");
INSERT INTO hlb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","पर वा ओरत यीसु का सामने आई, अऊर उन ख पाय पर गिर पड़ी। ओरत न कय्हो, अरे प्रभु मोरी मदद कर ");
INSERT INTO hlb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","यीसु न कय्हो दियो, “पोरिया हुन कि रोटी लेखा कुत्ता हुन को सामे डालनो अच्छो नी हाय।” ");
INSERT INTO hlb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ओ न कय्हो, “सच हैं प्रभु पर कुत्ता भी उ चूरचार खाव हैं, जो उन को स्वामी हुन कि टेबल से गिर हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","यी पर यीसु न ओ ख कय्हो दियो, “अरे पोरी तोरो विस्वास बड़ो हैं। जसो तू चाह हैं, तोरो लाने वसो ही होय” अऊर ओकी पोरी ऊईच बखत अच्छी हो गई। ");
INSERT INTO hlb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","यीसु वहाँ से गलील कि झील को नजीक आयो, अऊर टेकड़ा पर चढ़ ख बेठ गयो। ");
INSERT INTO hlb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","तब भीड़ पर भीड़ ओखा नजीक आई। वी अपनो संग लंगड़ा, अंधा, गूगा, टुण्डा अर अन्य बेजा को ओको नजीक लायो; अऊर उन ख ओखा पाय पर डाल दियो, अर यीसु उन ख अच्छो करियो। ");
INSERT INTO hlb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","जब अदमी हुन न देखो कि गूगो बोल हैं, अर टुण्डा अच्छा होय हैं, अऊर लंगड़ा चल हैं, अर अंधा देख हैं ते अचम्भा कर ख कि इस्राएल को परमेस्वर की बड़ाई करी। ");
INSERT INTO hlb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","यीसु न अपनो चेला ख बुलायो अर कय्हो, “कि मोखा ओपर भीड़ पर तरस आव हैं, काहेकि वी तीन दिन से मोरो संग हैं अऊर उन का नजीक कुछ खान ख नी हैं। म उन ख भूखो भेज नी चाहूँ हैं, कही असो न होय कि रस्ता म थक ख रह जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","अर चेला हुन न ओसे कय्हो, “हमका यू जंगल म कहा से इत्ती सारी रोटी हुन मिलेगो कि हम येत्ती बड़ी भीड़ को पेट भरे?” ");
INSERT INTO hlb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","यीसु न उनसे पुछयो, “तुमरो जोने कित्ती रोटी हैं?” उनना बोल्यो, सात। “अऊर जरासी छोटी मच्छी हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","तब यीसु न इंसान हुन ख जमीन म बैठन ख बोल्यो। ");
INSERT INTO hlb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","यीसु न वी सात रोटी हुन अऊर मच्छी हुन ख ली; परमेस्वर ख धन्यवाद दियो, अऊर रोटी हुन ख टोड़ियो अऊर अपना चेला हुन ख दियो अऊर चेला हुन न इंसान हुन ख बाँटिया। ");
INSERT INTO hlb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","असो तरीका से सब न पेट भर खायो अऊर चेला हुन न बचियो वाला टुकड़ा से भरिया वाला सात टोकनी भर ख उठायो। ");
INSERT INTO hlb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","खान वाला म ओरत हुन अऊर पोरिया पारी ख छोड़ चार हजार अदमी हुन हता। ");
INSERT INTO hlb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","यीसु न इंसान हुन बिदा करयो अऊर उ नाव पर चढ़ ख अऊर मगदन सहर को सिवाना म आयो। ");
INSERT INTO hlb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","फरीसी हुन अऊर सदूकी हुन न यीसु जोने आ ख यीसु ख परखन को लाने ओसे बोल्यो, “हमका स्वर्ग को कोई चिन्ह दिखा।” ");
INSERT INTO hlb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","यीसु न जुवाब दियो, “साम ख तुम बोला हैं, ‘मोउसम अच्छो रहे, काहेकि आकास लाल हैं।’ ");
INSERT INTO hlb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","भुसारो होनो पा बोला हैं, ‘आज हवा चलेगो, काहेकि आकास लाल अर बददली से ढ़कियो हैं।’ तुम इंसान हुन बददल ख लक्छन तो पहिचान लेवा हैं, पर बखत का लक्छन नी निसान सका हैं। ");
INSERT INTO hlb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","यू जमाना ख बुरा अऊर छिनाला इंसान हुन चिन्न ढूँढ़ा हैं, पर योना का चिन्न ख छोड़ उनका कोई अऊर चिन्ह नी दियो जाहे।” अऊर यीसु उनका छोड़ ख चल दियो। ");
INSERT INTO hlb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","चेला हुन झील को ओ नो पार पहुँचिया। पर वी अपनो संग म रोटी लेनो भूल गया रा। ");
INSERT INTO hlb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","एकोलाने जब यीसु न उनसे बोल्यो, म “देखनो, फरीसी अऊर सदूकी हुन को खमीर से सतर ख रैनो।” ");
INSERT INTO hlb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ते वी आपस म कहन लग गया, “हमना रोटी नी लाया, एकोलाने उ असो कहा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","यू जान ख यीसु न उनसे बोल्यो, “अरे जरा देर का विस्वासी, तुम आपस म असो काहे विचार हैं, कि हमारो जोने रोटी नी हाय। ");
INSERT INTO hlb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","का तुम अबा लक नी समझीया? का तुमका वी पाँच हजार कि पाँच रोटी हुन याद नी हाँय, अर न यू कि तुम न कित्ती टोकनी हुन उठई रहा? ");
INSERT INTO hlb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","अऊर न वी चार हजार कि सात रोटी हुन, अऊर न यू कि तुमना कित्तो टोकनी हुन उठई रहा? ");
INSERT INTO hlb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","तुम काहे नी समझीया कि मी न रोटी हुन को बारे म असो नी बोल्यो, पर फरीसी हुन अऊर सदूकी हुन को खमीर से सावधान रहन ख बोल्यो रहा।” ");
INSERT INTO hlb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","तब चेला हुन समझ गयो कि यीसु न रोटी को खमीर से नी, पर फरीसी हुन अऊर सदूकी हुन कि ग्यान से सतरक रह ख बोल्यो रहा। ");
INSERT INTO hlb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","जब यीसु कैसरिया फिलिप्पी को परदेस म आयो, तब ओ ना अपना चेला हुन से पुछियो, “इंसान को पोरिया ख का बोला हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","चेला हुन न जुवाब दियो, “कुछ इंसान हुन बोला हैं यूहन्ना बपतिस्मा देन वालो कोई बोल हैं, अऊर कोई एलिय्याह भविस्यवक्ता, अऊर कोई यिर्मयाह भविस्वक्ता अऊर कोई भविस्यवक्ता हुन म से कोई एक आय कहाँ हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","पर यीसु न उनसे बोल्यो, “पर तुम मोखा का बोला हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","समोन पतरस न जुवाब दियो, “तू जिन्दो परमेस्वर को पोरिया मसी आय।” ");
INSERT INTO hlb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ये पर यीसु न ओसे बोल्यो, “अरे समोन, योना को पोरिया, तू भलो हैं; काहेकि कोई असो ही इंसान न नी, बल्कि मोरो स्वर्ग म रहन वालो परमेस्वर बाप न तुम पर यू परगट करयो हैं ");
INSERT INTO hlb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","अऊर मी भी तोसे कहू हैं कि तू पतरस आय, अऊर यू पत्थर पा अपनी कलीसिया बनाऊँगो, अऊर अधोलोक का फाटक ओपर भारी नी पढ़न का। ");
INSERT INTO hlb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","मी तो ख स्वर्ग को राज कि चाबी हुन देहु: अऊर जे कुछ तू धरती पा बाँधूँगो; उ स्वर्ग म बंध जाहे अऊर जो कोई तुम जमीन पर खोले, उ स्वर्ग म खुल जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","तब यीसु न चेला ख जतायो कि कोई से असो मत कहजे कि मी मसी आय। ");
INSERT INTO hlb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","उत्तीच बखत से यीसु अपना चेला हुन ख बतान लग गयो कि “मोखा पक्को मालुम हैं, कि मोखा यरूसलेम ख जानो जरूरी हैं सियाना अऊर पुजारी हुन को अऊर तारा हुन ख देख ख भविस्य बतान वाला सासतिरी के हात से बेजा दुख उठाऊ; अऊर मार दियो जाऊ; अऊर तिसरो दिन फिर से जिन्दो हो ख ऊठु।” ");
INSERT INTO hlb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","येपर पतरस यीसु ख अलग ले जा ख डाँटन लग गयो, “अरे प्रभु परमेस्वर असो नी करे कि! तोरो संग असो कभी नी होय।” ");
INSERT INTO hlb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","येपर यीसु न मुड़ ख, पतरस से बोल्यो, “मोरी आँख को सामने से दुर हो जा, सैतान! तू मोरी रस्ता म ठोकर बन रयो हैं। तुम परमेस्वर की बात नी, बल्कि इंसान हुन कि बात हुन पा मन लगा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","तब यीसु न अपनो चेला से कय्हो, “अगर कोई मोरो पिच्छु आन की सोचे, ते उ अपनो खुद को इनकार करे अऊर अपनो सूली ख उठायो, अऊर मोरो पीछु चलन लग जाय। ");
INSERT INTO hlb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","काहेकि जो कोई अपनी जान बचान कि सोचा हैं, उ ओखा बचा नी सकन को; अऊर जो कोई मोरो लाने अपनी जान देहे, उ ओखा बचा लेहे। ");
INSERT INTO hlb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","अदि इंसान ख ऐसे का फायदा अदि उ पुरो संसार ख हासिल कर लेहे, लेकिन अपनी जान ही गवा देहे? अपनी जान को बदला म इंसान का देहेगो? ");
INSERT INTO hlb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","इंसान को पोरिया अपना स्वर्गदूत हुन को संग अपनो परमेस्वर बाप कि महिमा म आएँगो, अऊर उत्तीच घड़ी, उ हर एक ख ओखा काम हुन को हिसाब से फल देहेगो। ");
INSERT INTO hlb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","मी तुम से सच कहूँ हैं कि जो इते खड़ा हैं, उनमा से कुछ असा हैं, कि वी जब तक इंसान को पोरिया ख ओको राज्य म आते हुए नी देख ले, तब तक माऊत को सवाद कभी नी चखन को।” ");
INSERT INTO hlb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","छे दिन को बाद यीसु न पतरस, याकूब अऊर ओको भई यूहन्ना ख अपनो संग म लियो, अऊर उ उनका अकेलो म कोई ऊँचो टेकड़ा म लेखा गयो। ");
INSERT INTO hlb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","वहाँ उनको समाने यीसु को रूप बदल गयो। अऊर ओको मुंडो सूरज को जसो चमकन लग गयो अऊर ओखा कपड़ा उजेरो को जसो चका-चक चमकन लग गया। ");
INSERT INTO hlb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","अऊर उते उनका मूसा अर भविस्वक्ता एलिय्याह उनको संग बात चित करते हुए उनका दिखई दियो। ");
INSERT INTO hlb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","तब पतरस न यीसु से कय्हो, “अरे प्रभु! हमारो यहाँ रहनो कित्तो भलो हैं कि हम इते हैं। तू कहे मी तीन मण्डा यहाँ बनाहे: एक तोरो लाने, एक मूसा का लाने, अऊर एक एलिय्याह को लाने।” ");
INSERT INTO hlb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","उ बोलत ही रहा कि एक सफेदफट बददल न उनका घेर लियो, अऊर उ बददल म से असो अवाज सुनाई दियो: “यू मोरो अच्छो पोरिया आय जसो मी खुस हैं: येकी सुनो।” ");
INSERT INTO hlb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","चेला यू सुन ख मुंड़ो को बल गिड गया अऊर बेजा डर गया। ");
INSERT INTO hlb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","यीसु न जोने आ ख उन ख छियो, अर बोल्यो, “उठ जाव मत डरो।” ");
INSERT INTO hlb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","तब उनना अपनी आँखी उठई अऊर यीसु ख छोड़ अऊर कोई ख नी देख्यो। ");
INSERT INTO hlb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","जब वी टेकड़ी पर से उतारती रहा ते तब यीसु न उनका असो हुकुम दियो, “जब लक इंसान को पोरिया मुर्दा म से जिन्दो हो ख नी उठन को, तब लक जे कुछ तुमना देख्यो हैं कोई से मत कहनू।” ");
INSERT INTO hlb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","येपर ओखा चेला हुन न ओसे पुछियो, “फिर सास्र ख जानन वाला सासतिरी काहे बोला हैं कि एलिय्याह को पहले आनो जरुरी हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","यीसु न जवाब दियो, “एलिय्याह जरूर आहे, अऊर सब कुछ सुधारे। ");
INSERT INTO hlb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","पर मी तुम से कहूँ हैं कि एलिय्याह आ गयो हैं, अऊर इंसान हुन न ओखा नी पहिचानियो; परन्तु जसो सोचियो वसो ही ओको संग करयो। असोई तरीका से इंसान को पोरिया भी उनको हात से दुख उठाए।” ");
INSERT INTO hlb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","तब चेला हुन न समझो कि ओ ना हमसे यूहन्ना बपतिस्मा देनवालो को बारे म बोल्यो रहा। ");
INSERT INTO hlb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","जब वी भीड़ को जोने पहुँचिया, तो एक इंसान ओको जोने आयो, अर टोंगरीया मोड़ ख कहन लग गयो, ");
INSERT INTO hlb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“अरे प्रभु, मोरो पोरिया पा दया कर! काहेकि ओ ख मिर्गी आवा हैं, अऊर उ बेजा तड़पा हैं; अऊर बार बार आगी म अऊर बार बार पानी म गिर पड़ जावा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","मी ओ ख तोरा चेला हुन को जोने लायो रहा, पर वी ओखा अच्छो नी कर सक्या।” ");
INSERT INTO hlb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","यीसु न जुवाब दियो, “अरे अविस्वासी अऊर ढिट इंसान हुन, मी कब लक तुमरो संग म रहूंगो? कब तक तुमका झेलते रहूंगो? ओखा यहाँ मोरो जोने लाव।” ");
INSERT INTO hlb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","अऊर यीसु न भूत की दुस्टात्मा ख डांटियो, अऊर वा ओमन से निकल गई; अऊर पोरिया उत्तीच बखत अच्छो हो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","तब चेला हुन न अकेलो म यीसु को जोने आ ख कय्हो, “हम ओखा काहे नी निकाल सक्या?” ");
INSERT INTO hlb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","यीसु न उनसे कय्हो, “अपनो भरोसा कि कमी को कारन, काहेकि मी तुम से सच कहू हैं, अदि तुमरो विस्वास राई को दाना को बराबर भी होए, ते यू टेकड़ा से कहे देहे, यहाँ से सरक ख वहाँ चलो जा, ते उ चलो जाहे; अर कोई बात तुमरो लाने असी नी हाय की नी होन की। ");
INSERT INTO hlb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","पर या जात बिना प्रार्थना अऊर उपास को नी निकला।” ");
INSERT INTO hlb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","जब वी गलील परदेस म हता, तब यीसु न अपना चेला हुन से बोल्यो, इंसान को पोरिया इंसान हुन को हात म पकड़वा दियो जाहे; ");
INSERT INTO hlb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","वी ओखा मार डालेगो, अऊर उ तिसरो दिन जिन्दो हो जाहेगो। ये पर चेला हुन बेजा दुखी भया। ");
INSERT INTO hlb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","जब वी कफरनहूम सहर म आयो, ते मंदिर का कर लेनवालो न पतरस ख नजीक आय ख पुछीयो, का तुमारो गुरू मन्दिर को कर नी देवा हैं? ");
INSERT INTO hlb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ओ ना कय्हो, “हाँ, देवा हैं।” जब उ घर म आयो, ते यीसु न उनको पुछनो से पहले ही ओसे कय्हो, “अरे समोन, तू का सोच हैं? दुनिया ख राजा हुन कोसे कर या लगान लेवा हैं खुदका ही पोरिया हुन से या पराया से?” ");
INSERT INTO hlb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","पतरस न ओसे कय्हो, पराया से। यीसु न उनसे बोल्यो, “ते पोरिया हुन तो बच गया। ");
INSERT INTO hlb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","तेभी ऐको लाने कि हम उनको लाने ठोकर नी खिलायो, पर तू झील को किनार म जा ख को बंसी डाल, अऊर जे मच्छी पहले निकले, ओको मुंडो खोलनो पर तोखा एक सिक्का मिलेगो, ओखा ही लेखा मोरो अर तोरो बदला म उनका दे देजो।” ");
INSERT INTO hlb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","उत्तीच बखत चेला हुन यीसु को नजीक आय ख पूछन लग गयो, “स्वर्ग को राज म बड़ो कोन हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","येपर यीसु न एक पोरिया ख जोने बुला ख उनको बीच म खड़ो करियो, ");
INSERT INTO hlb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","अऊर कय्हो, मी तुम से सच कहूँ हैं कि जब तक तुम मन नी फिराए अर पोरिया हुन को जसो नी बने, तुम स्वर्ग को राज म भीतर नी जा सकन का। ");
INSERT INTO hlb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","जे कोई अपनो तुम ख यू पोरिया को जसो छोटो बनाएगो, उ स्वर्ग को राज म बड़ो होए। ");
INSERT INTO hlb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","अर जे कोई मोरो नाम से एक असो पोरिया ख अंगीकार करा हैं उ मोखा अंगीकार करा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“अऊर जे कोई यी छोटा म से जे मोरो पर भरोसा करा हैं एक का ठोकर खलाए, ओखा लाने भलो होतो कि बड़ी घट्टी को पाट ओखा गला म लटकायो जातो अऊर उ गहरो समुंदर म डूबायो जातो। ");
INSERT INTO hlb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ठोकर हुन को वजे से दुनिया पर धितकार! ठोकर हुन को लगनो जरूरी हैं; पर धिक्कार उ अदमी पर जे को व्दारा ठोकर लग हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“अऊर तोरो हात अऊर तोरो पाय तो ख ठोकर खिलाये, ते ओ ख काट ख फेक दे; दुण्डा अऊर लगड़ा होय ख जिन्दगी म भीतर करनो तोरो लाने असो चोक्खो हैं कि दो हात अर पाय रहे ते तू अनन्त आगी म डालो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","अदि तोरी आँखी तो ख ठोकर खिलाहे, ते ओ ख निकल ख फेक दे; काना होय ख जिन्दगी म भीतर होनो तोरो लाने ऐसे चोक्खो हैं कि दो आँखी रह हुऐ तू नरक कि आगी म डाल्यो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“देख, यी छोटा म से कोई ख बेकार नी जान; काहेकि म तोसे कहू हैं कि स्वर्ग म उन को स्वर्गदूत मोरो स्वर्गीय बाप ख मुँह हमेसा देख हैं। ");
INSERT INTO hlb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","काहेकि इंसान को पोरिया खोयो हुयो ख बचान आयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","तुम का सोच हैं? अगर कोई इंसान कि सव भेड़ी हुन होय, अऊर ओ म से एक खो जाहे, ते का उ निन्यानबे ख छोड़ ख, अऊर टेकाड़ा पर जाख, ओ ख खोई हुई भेड़ ख नी ढूढे? ");
INSERT INTO hlb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","अऊर अगर असो होय कि ओ ख मिले, ते म तुम से सच कहू हैं कि उ उन ख निन्यानबे भेड़ी हुन ख लाने जो खोई नी हती, इत्तो खुसी नी करे कि जितनो यी भेड़ ख लाने करे। ");
INSERT INTO hlb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","असो ही तुमारो बाप कि जो स्वर्ग म हैं यू इच्छा नी हैं कि इन छोटा म से एक भी खत्म नी होए। ");
INSERT INTO hlb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“अऊर तोरो भई तोरो विरुध्द पाप करा, ते जाय अऊर अकला म बात चीत कर ख ओ ख समझा; अऊर उ तोरी सुन हैं ते तू अपनो भई ख मिल। ");
INSERT INTO hlb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","अदि उ नी सुन हैं, ते एक अऊर दो इंसान का अपनो संग अऊर ले जा, कि ‘हर एक बात दो अऊर तीन गवाह हुन का मुडा से पक्को करो जाहे।’ ");
INSERT INTO hlb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","यदि उ ओकी भी नी माने, ते कलीसिया से कह दे, अऊर यदि उ कलीसिया कि भी नी माने ते तू ओ ख गैर-यहूदी अऊर कर लेन वालो समान जान।” ");
INSERT INTO hlb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","मी तुम से सच कहूँ हैं, कि जे कुछ तू धरती पर बाँधे, उ स्वर्ग म बाँधे अऊर जे कुछ तू धरती पर खोले, उ स्वर्ग म खुले। ");
INSERT INTO hlb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“फिर मी तुम से सच कहू हैं कि अदि तुम म से दो इंसान धरती पर कोई बात का लाने एक मन होय ख ओ ख माँगे, ते उ मोरो बाप कि तरफ से जे स्वर्ग म हैं, उन का लाने हो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","काहेकि जहाँ पर दो अऊर तीन मोरो नाम से इकट्ठा होय हैं, वहा म उन का बीच हूँ।” ");
INSERT INTO hlb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ते पतरस न नजीक आय ख प्रभु से कय्हो, “अरे प्रभु, अदि मोरो भई पाप करा हैं, ते म कित्ती बार ओ ख माप करू? का सात बार तक?” ");
INSERT INTO hlb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","यीसु न ओ से कय्हो, मी तो ख से यू नी कहू हैं कि सात बार तक पर सात बार का सतर गुना तक। ");
INSERT INTO hlb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","एकोलाने स्वर्ग का राज उ राजा का जसो हैं, जेमा अपनो दास हुन से हिसाब लेन चाहे। ");
INSERT INTO hlb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","जब उ हिसाब लेन लगे, ते एक इंसान ओखा सामने लायो गयो जे दस हजार तोड़ा का कर्जदार हतो। ");
INSERT INTO hlb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","अर जब चूकान को ओखा नजीक कुछ भी नी हतो, ते ओखा मालिक न कय्हो, यी अऊर ऐकी ओरत अऊर पोरिया पारी अर जो कोई एको हैं सब बेचो जाहे, अर कर्ज चूका दियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","यी पर ओ ख दास न गिर कर ओ ख पाय पढ़ियो, अऊर कय्हो, अरे स्वामी धीरज रख, म सब कुछ भर दा हूँ। ");
INSERT INTO hlb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ते ओ न दास का मालिक न तरस खा ख ओ ख छोड़ दियो, अऊर ओको कर्ज भी माप कर दियो। ");
INSERT INTO hlb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“अऊर जब वी दास बाहर निकलो, ते ओखा संगी दास हुन म से एक ओ ख क मिलो जे ओको सव दीनार को कर्जदार हतो; ओ न ओ ख पकड़ कर ओको गला घोट अर कय्हो, ‘जो कुछ तो पर कर्ज हैं भर दे।’ ");
INSERT INTO hlb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","यी पर ओखा खुद को दास गिरकर ओसे विनती करन लगो, ‘धीरज रख, म सब भर देहु।’ ");
INSERT INTO hlb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","अर ओ न नी मानो, पर जा ख ओ ख जेल खान म डाल दियो कि जब तक कर्जदार कर्जा भर नी दे हे, तब तक वही रहे। ");
INSERT INTO hlb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","अऊर ओको खुद दास यू जे भयो हतो देख ख बेजा नाराज हुए, अर जा ख अपनो मालिक ख पूरो हाल बता दियो। ");
INSERT INTO hlb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","तब ओखा मालिक न ओ ख ख बुला ख ओसे कय्हो, ‘अरे बुरो दास, तू न जो मोखा से विनती करी, ते मी न तोरो उ पूरो कर्ज माप कर दियो। ");
INSERT INTO hlb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","एकोलाने जसो मी न तो पर किरपा करी हैं, असो ही का तोखा भी अपनो स्वंय को दास पर दया करनो नी चाहयो हतो?’ ");
INSERT INTO hlb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","अर ओको मालिक न गुस्सा म आकर ओ ख सजा देनवालो का हात म सोप दियो, कि जब तक उ सब कर्जदार कर्जा भर नी दे हे, तब तक उन का हात म रह। ");
INSERT INTO hlb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“यी तरीका अगर तुम से हर एक अपनो भई को मन से माप नी करेगों, ते मोरो बाप जे स्वर्ग म हैं, तुम से भी वसो ही करे।” ");
INSERT INTO hlb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","जब यीसु यी बात कय्हो चूका, ते कि गलील सहर से चलो गयो; अर यरदन का पार यहूदी हुन को दूसरा सहर म आयो। ");
INSERT INTO hlb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","तब बड़ी भीड़ ओखा पीछे चल गयो, अऊर ओ न वहाँ उन ख अच्छो कियो। ");
INSERT INTO hlb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","तब फरीसी ओको परखन करन लाने नजीक आय क कहन लगो, “का हर एक कारन से अपनी घर वाली ख छोड़नो चोक्खो हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","यीसु न कय्हो दियो, “का तुम नी पढो कि जेना उन ख बनायो, ओ ना सुरू से अदमी अऊर ओरत बना कर कय्हो, ");
INSERT INTO hlb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘यी कारन अदमी अपनी माय-बाप से अलग होय ख अपनी घर वाली का संग रहे अऊर वी दो एक सरीर होऐ?’ ");
INSERT INTO hlb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","अब वी दो नी, पर एक सरीर होए। एका लाने जे कोई परमेस्वर न जोडो हैं, ओ ख अदमी अलग नी कर।” ");
INSERT INTO hlb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","अर उनना यीसु से कय्हो, “फिर मूसा न यी काहे ठहरायो कि छोड़ छुट्टी देकर ओ ख हुकुम दे ख छोड़ दे?” ");
INSERT INTO hlb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","अर यीसु न कय्हो, “मूसा न तुमारो मन कि कठोरता का कारन ही तुम ख घरवाली ख छोड़ देने ख हुकुम दियो हैं, पर सुरु से असो नी हतो। ");
INSERT INTO hlb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","अऊर मी तुम से बोलू हैं, कि जे कोई भी छिनाला ख छोड़ अऊर कोई भी कारन से अपनी घरवाली ख छोड़ दूसरी से सादी करे, उ गलत काम करह हैं; अऊर जो ओ ख छोड़ी हुई से सादी करे, उ भी गलत काम करह हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","अर चेला हुन न यीसु कय्हो, “अदि अदमी को बाई को संग असो सम्बन्ध हैं, ते सादी करनु चोक्खो नी हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","यीसु न उन से कय्हो, सब यी वचन अंगीकार नी कर सक हैं, अकलो वी जीन यी वरदान दियो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","काहेकि कोई ते नपुंसक असा हैं, जे माता का पेट ही से असो पैदा हुऐ अर कोई नपुंसक असा हैं, जीन ख अदमी न नपुंसक बनयो हैं; अर कोई नपुंसक असा हैं जीन न स्वर्ग को राज ख लाने अपनो तुम ख नपुंसक बनायो हैं जे ऐको अंगीकार कर सक हैं, उ अंगीकार कर। ");
INSERT INTO hlb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","उ बखत लोग यीसु ख नजीक पोरिया हुन ख लायो, जे ख उ उन पर हात रख अऊर प्रार्थना करे, पर चेला हुन न उन ख डाँटियो। ");
INSERT INTO hlb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","यीसु न कय्हो, “पोरिया हुन ख आवन दे, अऊर उन ख मान नी कर, काहेकि स्वर्ग को राज असा ही को हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","अऊर उ पोरिया हुन को माथा पर हात रख ख वहाँ से चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","एक अदमी यीसु का नजीक आय ख अऊर कय्हो, “अरे प्रभु, मी कोन सो भलो काम करुँ कि अनन्त जिन्दगी पाऊ?” ");
INSERT INTO hlb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","यीसु न कय्हो दियो, “तू मो से भलाई का बारा म काहे पूछ हैं? अच्छो ते एक ही हैं, पर अदि तू जिन्दगी म भीतर करनो चाहे हैं, ते आदेस हुन ख मान कर।” ");
INSERT INTO hlb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ओ न ओ से कय्हो, “कोन सो कहना हुन?” यीसु न कय्हो, “यी कि माऊत नी करनो, गलत काम नी करनो, चोरी नी करनो, झूठी गवाही नी देजो, ");
INSERT INTO hlb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","अपनो बाप अऊर अपनी माय को सम्मान करनो, अर अपनो पड़ोसी से अपनो जसो प्रेम रखनो।” ");
INSERT INTO hlb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","उ जवान न ओसे कय्हो, “इन सब ख ते मी न मानो हैं; अब मोखा म कोन सी बात कि कम हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","यीसु न ओसे कय्हो, “अदि तू सिध्द होनू चाहे हैं ते जा, अपनो दऊलत बेच ख भिखारी हुन ख दे, अऊर तोखा स्वर्ग म धन मिले; अऊर आँख मोरो पीछे चलो आ।” ");
INSERT INTO hlb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","यी बात सुन ख उ उदास होय ख चलो गयो, काहेकि ओखा नजीक बेजा धन सम्पत्ति हती। ");
INSERT INTO hlb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ते यीसु न अपनो चेला हुन से कय्हो, “मी तू से सच कहूँ हैं कि धनवान को स्वर्ग का राज म भीतर करनो मूसकिल हैं। ");
INSERT INTO hlb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","तोसे फिर कहूँ हैं कि परमेस्वर का राज म धनवान का भीतर करन से ऊँट को सुज्जी का नाका म से निकलू जानो मूसकिल हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","यी सुन ख चेला हुन न बेजा अचम्भा होयख कय्हो, “फिर कोको उध्दार हो सका हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","यीसु न उनकी तरफ देख ख कय्हो, “अदमी से ते यी नी होय सक हैं, पर परमेस्वर से सब कुछ हो सक हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","यी पर पतरस न यीसु से कय्हो, “देख, हम ते सब कुछ छोड़ ख तोरो पीछे चलो आयो: ते हम का मिले?” ");
INSERT INTO hlb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","यीसु न ओसे कय्हो, मी तू से सच कहूँ हैं कि नई धरती म जब इंसान को पोरिया अपनी महिमा को सिंहासन पर बैठ, ते तुम भी जे मोरो पीछे चलो आय हैं, अर बारा सिंहासन पर बैठ ख इस्राएल को बारा गोत हुन को नीनय करे। ");
INSERT INTO hlb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","अऊर जे कोई न घर हुन, अऊर भई हुन, अऊर बहिन हुन अर माय अर पोरिया-पारी हुन, अर खेत हुन का मोरो नाम ख लाने छोड़ दियो हैं, ओको सव गुना मिले, अऊर उ अनन्त जिन्दगी को हक्कदार होऐ। ");
INSERT INTO hlb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","परन्तु बेजा हुन से जे पहलो हैं, पीछे हो गयो; अर जे पिछु हतो पहलो हो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“स्वर्ग को राज कोई घर मालिक को जसो हैं, जे सबेरे निकलो कि अपनी अंगूर की बारी म मजदूर हुन ख लायो। ");
INSERT INTO hlb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ओ न मजदूर हुन से एक दीनार रोज पर रखो अऊर उनख अपनी अंगूर कि बारी म भेजो। ");
INSERT INTO hlb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","फिर नव बजिया उ बाहर निकल ख अर ओ न दूसरा हुन चऊक म बेकार खड़ा देखो, ");
INSERT INTO hlb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","अऊर ओ न कय्हो, तू भी अंगूर कि बारी म जा, अर जे कुछ उचित हैं, तुम ख देहु। अब वी भी गया। ");
INSERT INTO hlb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","अऊर वी वहा से गया। करी बन बारा बजिया अऊर तीन बजिया भी ओ न बारा निकल ख असो ही करियो। ");
INSERT INTO hlb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","उ रात पाँच बजिया फिर बाहर निकल ख ओ न वी पर कुछ अर मजदूर हुन ख खड़ो देखियो। उ ओ न कय्हो, तू काहे यहाँ दिन भर बेकार खड़ो रयो हैं? ");
INSERT INTO hlb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","उनना से कहयो दियो, ‘एकोलाने कि कोई न हम ख मजदूर हुन म नी लग गयो। ओ न उन से कय्हो, तू भी मोरो अंगूर कि बारी म जा।’” ");
INSERT INTO hlb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","रात ख अंगूर कि बारी को मालिक न अपनो भण्डारी से कय्हो कि मजदूर हुन ख बुला ख पिछला से लेख पहलो तक उन ख मजदूरी दे दे। ");
INSERT INTO hlb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","जब वी मजदूर आया, जे रात पाँच बजिया तक काम पर लग गया हता, ते उन हुन ख एक एक दिन कि दीनार मिलो। ");
INSERT INTO hlb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","यी पर मजदूरी म जो पहलो लग गयो हतो, ते जब वी आया ते उनना समझो कि मजदूर हुन न समझो कि हम ख जादा मिले, पर मजदूर हुन ख भी एक-एक दिन कि दीनार मिलो। ");
INSERT INTO hlb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","जब मिलो ते वी घर स्वामी पर कुड़कुड़नो ख कहन लगो। ");
INSERT INTO hlb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","इन पिछला मजदूर हुन न एक ही घंटा काम कियो, तेभी तू न उन ख हमारो बराबर कर दियो, जीनना दिन भर कढ़ी मेहनत कर हैं अर धूप सहते रयो? ");
INSERT INTO hlb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ओ न ओमा से एक ख कय्हो दियो, अरे दोस्त मी तोसे कुछ बुरो नी करूँ हैं। का तू न ही मोसे एक दिन कि दीनार ठहरा हतो? ");
INSERT INTO hlb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","जे तोरो आय, उठा ले अर चलो जा; मोरी या मर्जी हैं कि जित्तो तो ख दूँ उत्तो ही यी पिछे म आया वाला ख देहु। ");
INSERT INTO hlb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","जे मोरो हैं, का यी ठीक नी कि मी अपनी धन दोलत से जो चाहूँ वसो करूँ? का मोरो अच्छो होन का लाने तू बुरी आँखी से देखे हैं? ");
INSERT INTO hlb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","यू ईच से जे पिछला हैं, वी पहले होए; अऊर जे पहले हैं, वी पिछला होए। ");
INSERT INTO hlb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","यीसु यरूसलेम को जाते हुए बारा चेला हुन क अकला म ले गयो, अऊर रस्ता म उन से कहन लगो, ");
INSERT INTO hlb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“देख, हम यरूसलेम ख जाय हैं; अऊर इंसान को पोरिया याजक हुन अर सासतिरी को हात पकड़वायो जाहे, अर वी ओ ख मारन ख लायक ठहराएगो। ");
INSERT INTO hlb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","अऊर ओ ख गैर यहूदी को हात दे दियो जाहे, कि वी ओको मजाक उड़ायो, अऊर ओखा कोडा लगाया अऊर सूली पर चढ़ाय; लेकिन उ तीन दिन बाद उ फिर से जिन्दो हो ख उठेगो।” ");
INSERT INTO hlb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","तब जबदी को पोरिया हुन कि माय न, अपनो पोरिया हुन का संग यीसु को जोने आय ख नमस्कार करियो, अऊर ओसे कुछ माँगन लगी। ");
INSERT INTO hlb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","यीसु न ओसे कहयो, “तू का चाहे हैं?” उ ओ ख बोली, “यी वचन दे कि मोरो यी दो पोरिया तोरो राज म एक तोरो दाहिनी अऊर एक तोरो बाऐ बठे।” ");
INSERT INTO hlb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","यीसु न ओको पोरिया हुन से कय्हो, तुम नी जान कि का माँगन रहे हो। जे कटोरा म पीवन पर हूँ का तू पी सक हैं उनना ओसे कय्हो, “पी सक हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ऐपर यीसु न उनसे कय्हो, “तू मोरो कटोरा ते पीहे, पर अपनो दाहिनो अऊर बाएँ कोई ख बठानू मोरो काम नी हैं, पर जेका लाने मोरो बाप कि तरफ से तैयार करियो गयो, उन ख लाने हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","यी सुन ख दस हुन चेला उन दोई हुन भई हुन पर गुस्सा भयो। ");
INSERT INTO hlb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","यीसु न अपनो चेला हुन ख अपनो नजीक बुला ख ओ न कय्हो, “तू जाना हैं कि दुनिया को मुखिया हुन ख अपनी सेना पर निरंकुस सासन कर हैं अर उनका सत्ताधारी उन पर अधिकार रख हैं। ");
INSERT INTO hlb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","अऊर तुम म असो नी होए: पर जे कोई तुम म बड़ो होनू चाहे उ तुमारो दास बने; ");
INSERT INTO hlb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","अऊर जे तुम म मुखिया होनू चाहे हैं, उ तुमारो दास बने; ");
INSERT INTO hlb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","जसो कि इंसान को पोरिया; उ एकोलाने नी आयो कि ओकी सेवा टहल कि जाहे, पर एकोलाने आयो कि स्वंय सेवा कर, अऊर बेजा हुन ख छुड़ान का लाने अपनो जान देहे।” ");
INSERT INTO hlb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","जब यीसु अऊर उनका चेला यरीहो सहर से निकल रयो हतो, ते एक बड़ी भीड़ यीसु का पीछे चली आई। ");
INSERT INTO hlb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","अऊर दो अंधा, जे रस्ता का किनारा बैठो हतो, यू सुन ख कि यीसु जा रयो हैं, बुला ख कह लगो, “अरे प्रभु दाऊद कि पोरिया, हम पर दया कर।” ");
INSERT INTO hlb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","अदमी हुन न उन ख डाँट कि चुप रह; पर उ अऊर भी चिल्ला ख बोल्यो, “अरे प्रभु दाऊद कि पोरिया हम पर दया कर।” ");
INSERT INTO hlb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ते यीसु न खड़ो होय ख उन ख अर बुला ख कय्हो, “तू का चाह हैं कि मी तुमारो लाने का करूँ?” ");
INSERT INTO hlb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","उनना ओसे बोल्यो, “अरे प्रभु, यू कि हमारी आँखे खुल जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","यीसु न तरस खा ख ओकी आँखी ख छूई, अऊर उ जल्दी से देखन लग गयो; अर ओको पीछे चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","अऊर वी यरूसलेम ख नजीक आयो अऊर जैतून टेकाड़ा अर बैतफगे को नजीक आया, ते यीसु न दो चेला हुन ख यी कह ख भेजो, ");
INSERT INTO hlb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“सामने को गाँव म जा। वहाँ जाते ही एक गदही बाँधी हुई, अर ओको संग बच्छा तुम ख मिले। उन ख खोल ख मोरो नजीक ले आ। ");
INSERT INTO hlb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","अदि तुम से कोई भी कहे, ते कहजो कि प्रभु ख ऐकी जरूत हैं, तब उ तुरत उन ख भेज दे हे।” ");
INSERT INTO hlb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","यी एकोलाने भयो कि जे वचन भविस्य को बतान वालो का अर कय्हो गयो हतो, उ पूरो होए: ");
INSERT INTO hlb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सिय्योन सहर से कहयो, देख, तोरो राजा तोरो नजीक आयो हैं: उ सिधो हैं, अर वी गदही पा बैठो अऊर बच्छा पर बेठो हैं; पर लादू को पोरिया पर।” ");
INSERT INTO hlb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","दोई चेला हुन चलो गया, यीसु न जसो हुकुम दियो, उनना वसो ही करियो। ");
INSERT INTO hlb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","अर वी गदही अऊर बच्छा ख ला ख, उन पर अपनो कपड़ा डालो, अर उ ओपर बैठ गयो। ");
INSERT INTO hlb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","अर भीड़ हुन म से बेजा सा अदमी हुन न अपनो चादर को कपड़ा रस्ता म बिछा दियो, अर कई अन्य अदमी हुन झाड़ हुन से डाली हुन काट ख रस्ता म बिछायो। ");
INSERT INTO hlb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","यीसु को सामने-सामने अर उनका पीछु-पीछु आत हती, आवाज ख बोलत हती, “दाऊद कि पोरिया कि होसाना, धन्य हैं उ जे प्रभु को नाम से आय हैं, बादल म होसाना।” ");
INSERT INTO hlb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","अऊर यीसु न यरूसलेम नगर पहुँच ख म भीतर करियो, ते सब सहर म हड़बड़ी मच गई, अऊर लोग हुन कहन लग गया, “यी कोन आये?” ");
INSERT INTO hlb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","अऊर लोग हुन न कय्हो, “यी गलील सहर को नासरत को भविस्य को बतान वालो यीसु आय।” ");
INSERT INTO hlb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","यीसु न परमेस्वर को मन्दिर म जान ख उन पूरो ख, जे मन्दिर म लेन देन कर रयो हतो, निकाल दियो, अर सर्राफो को टेबल अऊर कबूतर बेचनेवालो की चोकियाँ पलट दियो; ");
INSERT INTO hlb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","अऊर उन से कय्हो, “सुध्द सास्र म लिखो हैं, मोरो घर परमेस्वर को घर प्रार्थना को घर कहलाहे अऊर तुम लोग डाकू हुन को अड्डा बना हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","अऊर अंधो अऊर लगड़ो, यीसु को नजीक मन्दिर म आयो अऊर यीसु न उन ख अच्छो करियो। ");
INSERT INTO hlb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","पर जब प्रधान याजक हुन अर सासतिरी न इन हईब का काम हुन, जे ओ न करियो अर पोरिया हुन ख मन्दिर म दाऊद को खानदान को होसाना पुकार हुए देखे, ते वी घुस्सा होऐ ");
INSERT INTO hlb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","अऊर वी यीसु से कहन लग गया, “का तू सुन रयो हैं कि यी का कैय रया हैं” यीसु न उनका कय्हो, हाव सुन रयो हैं; का तुम इंसान हुन न ग्रंथ म नी पढियो; कि बालबच्चा अर दूध पीवन वाला पोरिया-पारी हुन को मुंडो तुना अपनो गुन गान करायो? ");
INSERT INTO hlb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","तब यीसु उन ख छोड़ क सहर को बाहर बैतनिय्याह सहर ख गयो अऊर वहाँ रात गुजारी। ");
INSERT INTO hlb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","सुबह ख जब उ सहर ख वापस आ रयो हतो ते यीसु ख भूख लगी। ");
INSERT INTO hlb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","अऊर उनना रस्ता को किनारा अंजीर को एक झाड़ देख ख। उ ओको नजीक गयो, अऊर पत्ता हुन ख छोड़ ख ओमा अर कुछ भी नी पा ख यीसु न झाड़ से कय्हो, “अब से तोम फिर कभी फल नी लगे।” अऊर अंजीर को झ़ाड़ तुरंत सूख गयो। ");
INSERT INTO hlb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","यू देख ख चेला हुन ख अचम्भा भयो अर उन ख कय्हो, “यू अंजीर को झाड़ तुरत कसो सुख गयो?” ");
INSERT INTO hlb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","यीसु न उन ख कय्हो दियो, “मी तुम से सच कहूँ हैं, अदि तू विस्वास रखे अऊर सक नी करे, नी अकेलो ते यी करे जे यी अंजीर को झाड़ से करी गयो हतो, पर अदि यू टेकड़ा से भी कहे ते, उखड़ जा ते, अऊर समुंदर म जा पड़, ते यू हो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","अऊर जे कुछ तुम प्रार्थना म विस्वास से माँगे ते उ सब तुम ख मिले।” ");
INSERT INTO hlb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","जब यीसु मन्दिर म जा ख उपदेस देत रयो हतो, ते मुखिया हुन याजक हुन अऊर अदमी हुन का सियाना हुन न ओको नजीक आ ख पूछो, “तू यू काम कोके हक्क से कर हैं? अर तोखा यू हक्क कोन न दियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","यीसु न उन ख कय्हो दियो, “मी भी तुम से लोग हुन से एक बात पूछ हैं; अदि उ मोखा बता हे, ते मी भी तुम ख बताऊँ कि यू काम कोन अधिकार से करू हूँ। ");
INSERT INTO hlb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","यूहन्ना ख बपतिस्मा कहाँ से हतो? स्वर्ग कि तरफ से या अदमी हुन कि तरफ से?” अर ते वी आपस म लड़ाई करन लगो, “अदि हम कहे ‘स्वर्ग कि तरफ से’ ते उ हम से कहे हे, ‘फिर तुम न यूहन्ना पर विस्वास काहे नी कियो?’ ");
INSERT INTO hlb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","अऊर यदि कह: ‘अदमी हुन कि तरफ से,’ ते हम ख भीड़ को डर हैं, काहेकि वी सब यूहन्ना ख भविस्यवक्ता मानत हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","एकोलाने उन हुन यीसु ख कय्हो दियो, “हम ख नी मालूम हैं।” ओपर यीसु न उन से कय्हो, ते मी भी तुम अदमी हुन ख नी बता कि मी कोकी अधिकार से काम कर रह हैं। ");
INSERT INTO hlb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“तुम अदमी हुन को का सोच हैं? कोई अदमी को दो पोरिया हता; ओ न पहले का नजीक जाय ख कय्हो, ‘अरे पोरिया आज अंगूर कि बाड़ी म काम कर।’ ");
INSERT INTO hlb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ओ न कय्हो दियो, ‘मी नी जाऊ,’ पर बाद म ओ ख पछतावा भयो अर उ गयो। ");
INSERT INTO hlb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ते बाप न दूसरो पोरिया ख नजीक जाख यू कय्हो। ओ न कय्हो दियो, जी हाव हूँ, अऊर उ नी गयो। ");
INSERT INTO hlb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","यी दोई मी से कोन बाप कि मर्जी पूरी करी?” उनना कय्हो, “पहले न।” यी पर यीसु न ओसे कय्हो, मी तुम से सच कहूँ हैं कि कर लेन वालो अऊर वेस्या हुन तुम लोग हुन से पहले परमेस्वर को राज म अन्दर कर रैया हैं। ");
INSERT INTO hlb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","एकोलाने यूहन्ना धर्म को रस्ता दिखाते हुऐ तुमारो नजीक आयो, अर तुम न ओको विस्वास नी करियो; पर कर लेन वालो अर वेस्या हुन न ओको विस्वास करियो: अर तुम यू देखन को बाद म भी नी पछतावा कि ओको विस्वास कर ले। ");
INSERT INTO hlb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“एक अऊर उदाहरन सुन: एक घर मालिक हतो, जेन अंगूर कि बाड़ी लगाई, ओखा चारो तरफ बागड बाँधयो ख। ओ न ओमा रस को कुण्ड खोदो अऊर गुम्मट बनायो, अर किरसान हुन ख ठेका देख ख दूसरा सहर ख चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","जब फल को बखत नजीक आयो, ते ओ न अपनो दास हुन ख ओखा फल लेवन का लाने किरसान हुन ख नजीक भेजो। ");
INSERT INTO hlb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","पर किरसान हुन न ओखा दास हुन ख पकड़ ख कोई ख पीटा, अर कोई ख मार डालो, अर कोई पर पत्थर हुन कियो। ");
INSERT INTO hlb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","फिर ओ न पहले से जादा अऊर दास हुन ख भेजो, अऊर किरसान हुन न दास हुन संग वसो ही करियो। ");
INSERT INTO hlb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","अऊर आखरी म ओ न यी सोच ख अपनो पोरिया ख उनको नजीक भेजो कि वी मोरो पोरिया ख सम्मान करे। ");
INSERT INTO hlb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","अऊर पोरिया ख देख ख किरसान हुन न एक दूसरा हुन से कय्हो यू ते हक्कदार हैं, आव हम ऐखा मार डाले अऊर ऐकी धन सम्पत्ति पर हक्क कर ले। ");
INSERT INTO hlb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","अऊर उनना ओ ख पकड़ अऊर अंगूर कि बाड़ी से बाहर निकल ख मार डालियो। ");
INSERT INTO hlb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“एकोलाने जब अंगूर कि बाड़ी को मालिक आहे, ते उन किरसान हुन ख संग का करे?” ");
INSERT INTO hlb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","अऊर उनना ते यीसु से कय्हो, “उ बुरो अदमी का बुरो रीति से नास करे; अऊर अंगूर कि बाड़ी को ठेका दूसरा किरसान हुन ख देगो, जे बखत पर ओ ख फल दियो करे।” ");
INSERT INTO hlb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","यीसु न ओसे कय्हो, का तुम न कभी सुध्दसास्र म यू नी पढ़यो: जो पत्थर ख राजमिसतिरी न बेकार ठहरा हे, उई कोना को सिरा ख पत्थर हो गयो? यी प्रभु कि तरफ से भयो, अर हमारो देखन म बेजा चोक्खो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","एकोलाने मी तुम से लोग हुन कहूँ हैं कि परमेस्वर को राज तुम से ले लियो जाहे अऊर असी जाति ख जो ओको फल लाहे, दियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","जे यू पत्थर पर गिरेगो, उ चूर हो जाहे; अऊर जेपर उ गिरे, ओखा पीस डाले। ");
INSERT INTO hlb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","अऊर जब मुखिया याजक हुन फरीसी यीसु उदाहरन हुन का सुन ख समझ गयो कि उ हमारो बारे म कह रयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","अऊर उनना ओ ख पकड़नू चाही, पर अदमी हुन से डर गयो काहे की वी यीसु ख भविस्यव्दक्ता माना रह हता। ");
INSERT INTO hlb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","यीसु फिर उन से उदाहरन म कहन लगो, ");
INSERT INTO hlb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","स्वर्ग को राज उ राजा को समान हैं, जेना अपनो पोरिया को सादी म जोवन करियो। ");
INSERT INTO hlb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","अऊर ओ न अपनो दास हुन ख भेजो कि नेवता दिया वाला अदमी हुन ख सादी को खाना म बुलाव; पर उनना आनो नी चाहयो। ");
INSERT INTO hlb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ते ओ न अर दास हुन ख यू बोल ख भेजो, नेवता अदमी हुन से कहयो: देख, मी खानो तैयार कर चुको हैं, मोरो बईल अर पालो वालो हुयो जानवर मर गयो हैं, अर सब कुछ तैयार हैं सादी को खानो म आ। ");
INSERT INTO hlb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","अऊर जो राजा न निवता दियो रहा वी मिजवान हुन न ओको निवता को अपमान कर ख कोई खेत म चल दिया कोई, कोई तो अपनो धंदा देखन ख। ");
INSERT INTO hlb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","दूसरा मिजवान हुन न राजा को दास हुन ख पकड़ ख उन ख लज्जित करियो अऊर उन ख मार डालो। ");
INSERT INTO hlb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","तब राजा ख घुस्सा आयो अऊर ओ न अपनी प्रजा भेज ख उन हत्यारो ख नास करियो, अऊर उनको सहर ख जला दियो। ");
INSERT INTO hlb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","तब राजा न अपनो दास हुन से कय्हो, सादी को खाना तैयार हैं, पर नेवता अदमी हुन लायक नी रैया। ");
INSERT INTO hlb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","एकोलाने चऊक हुन पर जाओ अर जितना भी अदमी मिले जाहे, सब ख सादी को खाना ख लाने बुला लाओ। ");
INSERT INTO hlb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","अब उन दास हुन न रस्ता पर जा ख का बुरो का भलो, जितनो मिले, सब ख जमा करियो; अऊर सादी को घर मिजवान हुन से भर गयो। ");
INSERT INTO hlb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“जब राजा मिजवान हुन ख देखन भीतर आयो, ते ओ न वहाँ एक अदमी ख देखो, जो सादी को कपड़ा नी पहिनो हतो। ");
INSERT INTO hlb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ओ न ओसे पूछो ‘अरे दोस्त, तू सादी को कपड़ा पहिनो बिना यहाँ काहे आ गयो?’ ओको मुँह बंद हो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","तब राजा न दास हुन से कय्हो, ऐको हात पाय बाँध ख ओ ख बाहर अंधेरा म डालो दे, वहाँ रोनू अर दाँत पीसनो होऐ।” ");
INSERT INTO hlb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","काहेकि बुलाए हुऐ “ते जादा हैं, पर चुनीया हुयो थोड़ा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ते फरीसी हुन न जाय ख आपस म विचार करियो कि ओ ख कोई तरीका बात हुन म फसाए। ");
INSERT INTO hlb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","अत: उनना अपनो चेला हुन ख हेरोदियो न को संग ओखा नजीक यू कह ख भेजो, “अरे प्रभु, हम जान हैं कि तू सच्चो हैं, अऊर परमेस्वर को रस्ता सच्चो से सिखावा हैं अऊर कोई ख परवाह नी कर हैं, काहेकि तू अदमी हुन को मुँह देख ख बाते नी करू। ");
INSERT INTO hlb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","एकोलाने हम ख बात तू का सोच हैं? कैसर को लगान देनू चोक्खो हैं कि नी।” ");
INSERT INTO hlb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","यीसु न उनको बुरी जान ख कय्हो, “अरे कपटी हुन, मोखा का। हे परख हैं? ");
INSERT INTO hlb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","अर लगान को सिक्का मोखा दिख” तब वी ओको नजीक एक दिन कि मजदूरी दीनार ले आयो। ");
INSERT INTO hlb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","यीसु न उन से पूछ, कि “यी छाप अऊर नाम कोन आय?” ");
INSERT INTO hlb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","उनना ओसे कय्हो, कैसर को। तब यीसु ओ से कय्हो, “जो कैसर को आय उ कैसर ख दे; अऊर जो परमेस्वर को आय उ परमेस्वर ख दे।” ");
INSERT INTO hlb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","यी सुन ख उनना को अचम्भा भयो, अऊर यीसु छोड़ ख चलो गया। ");
INSERT INTO hlb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","उ ईच दिन सदूकी जे कह हैं की मरो हुयो ख जिन्दो होनू हैं ही नी, यीसु नजीक आयो अऊर ओ ख पुछियो, ");
INSERT INTO hlb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“अरे प्रभु, मूसा न बोल्यो हतो कि यदि कोई अदमी ख बिना अवलाद को मर जाहे ते ओको भई ओकी घर वाली से बिहाव कर ख ख अपनो भई को लाने खानदान पैदा करे। ");
INSERT INTO hlb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","अब हमारो यहाँ सात भई हता; पहले को बिहाव कर ख ख मर गयो, अऊर अवलाद नी होनू का कारन अपनी घरवाली ख अपनो भई ख लाने छोड़ गयो। ");
INSERT INTO hlb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","यू तरीका दूसरो अऊर तीसरो न भी कियो, अऊर सात हुन तक यू ही भयो। ");
INSERT INTO hlb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","सबको बाद म उ ओरत भी मर गई। ");
INSERT INTO hlb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","अऊर जिन्दो होनू पर वा भी वी सात हुन म से कोकी घर वाली होऐ? एकोलाने वा सब कि घर वाली होय चूँकि हती।” ");
INSERT INTO hlb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","यीसु न उन ख कय्हो दियो, “तुम ते सुध्दसास्र ख अऊर नी परमेस्वर कि सक्ति ख नी जान; यी कारन भूल म पड़िया हैं। ");
INSERT INTO hlb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","एकोलाने जिन्दो होनू पर वी बिहाव करे अऊर नी बिहाव म दियो जाहे पर स्वर्ग म परमेस्वर को स्वर्गदूत हुन का जसो होए। ");
INSERT INTO hlb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","अऊर मरिया वालो को हुया ख जिन्दो होनू को बारा म का तुम न यू वचन नी पढ़ियो जे परमेस्वर न तुम से कय्हो हतो: ");
INSERT INTO hlb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘मी अब्राहम को परमेस्वर, अऊर इसहाक को परमेस्वर अऊर याकूब को परमेस्वर आय?’ उ मरे हुयो को नी, पर जिन्दो हुन को परमेस्वर आय।” ");
INSERT INTO hlb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","यू सुन ख लोग यीसु का उपदेस से आचम्भ भयो। ");
INSERT INTO hlb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","जब फरीसी हुन न सुनो कि यीसु न सदूकी हुन को मुँह बन्द कर दियो, ते वी इकट्ठा भयो। ");
INSERT INTO hlb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","अऊर ओमा से एक व्यवस्थापक न यीसु ख परखन का लाने ओसे पुछियो, ");
INSERT INTO hlb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“अरे प्रभु, नेम हुन म कोन सी आदेस बड़ी हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","यीसु न ओसे कय्हो, “तू परमेस्वर अपनो प्रभु से सारो मन अऊर अपनो सारो जान अऊर अपनो सारी बुध्दि का संग प्रेम रख। ");
INSERT INTO hlb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","बड़ी अऊर खास आदेस ते यू हैं। ");
INSERT INTO hlb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","अऊर ओकी को जसो यी दूसरो भी आय कि तू अपनो पड़ोसी से अपनो जसो प्रेम रख। ");
INSERT INTO hlb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","यू ही दो आदेस हुन सारो नेम अर भविस्य बतान वालो को आधार हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","जब फरीसी इकट्ठा हते, ते यीसु न फरीसी हुन से पुछियो, ");
INSERT INTO hlb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“मसी को बारे म तुम अदमी हुन का सोच हैं? उ कोन पोरिया आय?” उन न ओसे कय्हो “दाऊद को।” ");
INSERT INTO hlb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","यी पर यीसु न ओ से कय्हो, “ते दाऊद आत्मा म हो ख ओ ख प्रभु काहे कह हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“प्रभु न, मोरो प्रभु से कय्हो कि तू मोरो दाहिनो ओर बैठे, जब तक कि मी तोरो दुसमन हुन ख तोरो पाय हुन का नीचु नी कर दूँ।” ");
INSERT INTO hlb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“भलो, जब दाऊद ओ ख ‘प्रभु’ कह हैं, ते उ ओको पोरिया कसो रयो?” ");
INSERT INTO hlb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ऐको जवाब म कोई भी एक बात नी बोल सको। उ दिन से कोई ख भी फिर ओसे कई भी पूछन को हिम्मत नी भयो। ");
INSERT INTO hlb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","तब यीसु न भीड़ से अपनो चेला हुन से कय्हो, ");
INSERT INTO hlb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","सास्तिरी अर फरीसी मूसा कि गदी पर बठे हैं; ");
INSERT INTO hlb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","एकोलाने वी तुम अदमी हुन से जे कुछ कहे ओ ख करनो अर माननो, पर उनको जसो काम मत कर जे; काहे कि वी बोल हैं पर करनो। ");
INSERT INTO hlb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","वी एक असो भारी बोझ ख जेका उठानू मूसकिल हैं, बाँध ख उनका इंसान हुन को कंधा हुन पर रखा हैं; पर खुद ओ ख अपनी उंगली से भी सरकान की नी सोचा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","वी अपनो सब काम अदमी हुन ख लाने करिये हैं वी अपनो ताबी हुन ख चऊड़ो कर अर अपनो कपड़ा हुन कि कोर बढ़ हैं। ");
INSERT INTO hlb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","अर खाना खान म चोक्खो-चोक्खो जगह, अर प्रार्थना घर म चोक्खो-चोक्खो सरल हैं, ");
INSERT INTO hlb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","अऊर बजार हुन म अर नमस्कार, अर अदमी म हे गुरू कहलाये उन ख भाव हैं। ");
INSERT INTO hlb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","पर तुम हे गुरू नी कह जो, काहे कि तुमारो एक ही प्रभु हैं, अर तुम सब भई आय। ");
INSERT INTO hlb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","धरती पर कोई ख अपनो बाप नी कहजो काहेकि तुमारो एक ही बाप हैं। जे स्वर्ग म हैं। ");
INSERT INTO hlb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","अर स्वामी भी मत कहजो, काहेकि तुमारो एक ही स्वामी हैं उ मसी आय। ");
INSERT INTO hlb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","जो तुम म बड़ो हो, उ तुमारो दास बने। ");
INSERT INTO hlb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","जो कोई अपनो खुद ख बड़ो बनाहे उ छोटो करियो जाहे; अर जे कोई अपनो तुम ख छोटो बनाहे, उ बड़ो कियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“अरे कपटी सास्तिरी हुन अर फरीसी हुन, पर धितकार! तुम अदमी हुन को लाने स्वर्ग को राज का व्दार बन्द कर दे हैं, नी ते खुद ही ओ म भीतर कर हैं अर नी ओ म भीतर करनो दे हैं। ");
INSERT INTO hlb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","अरे कपटी सासतिरी हुन अर फरीसी हुन, तुम पर धिक्कार! तुम विधवा हुन ख घरो का खा जाव हैं, अर दिखा का लाने बड़ी देर तक बिनती कर रहा हैं। एकोलाने तुम ख ढ़ेर सारो सजा मिले।” ");
INSERT INTO hlb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","अरे कपटी सासतिरी हुन अर फरीसी हुन, तुम पर धितकार! तुम एक अदमी ख अपनो फायदा म लान ख लाने सारो पानी अर थल म फिर हैं, अर जब उ फायदा म आ जाव हैं ते ओ ख अपनो से दूगनो से नारकीय बना दे हैं। ");
INSERT INTO hlb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“अरे अंधा अगुवा हुन, तुम पर धितकार! जे कह हैं अदि कोई मन्दिर को कसम खाऐ ते कुछ नी, पर अदि कोई मन्दिर को सोने कसम खाऐ ते ओ ख बंधो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","अरे मूर्ख हुन अर अंधा हुन कोन बड़ो हैं; सोना अऊर उ मन्दिर जेन सोना सुध्द होव हैं? ");
INSERT INTO hlb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","फिर कह हैं कि पर कोई वेदी कि कसम खाऐ ते कई नी, पर जे दान ओपर हैं, पर कोई ओकी कसम खाऐ ते फस जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","अरे अंधा हुन, कोन बड़ो हैं: भेट अर वेदी जसो दान सुध्द होव हैं? ");
INSERT INTO hlb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","एकोलाने जो वेदी को कसम खाव हैं, उ ओकी अर जो कुछ ओ पर हैं, ओकी भी कसम खाव हैं। ");
INSERT INTO hlb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","जो मन्दिर कि कसम खाव हैं, ओकी अर ओ म रहनवालो कि भी कसम खाव हैं। ");
INSERT INTO hlb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","जो स्वर्ग को कसम खाव हैं, उ परमेस्वर को सिंहासन को अर ओ पर बठनवाला कि भी कसम खाव हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","हे कपटी सासतिरी हुन अर फरीसी हुन, तुम पर धितकार! तुम पुदीने, अर सोप, अर जीरो का दसवां अंस ते दे हैं, पर तुम न नेम ख गम्भीर बातहुन ख असो कि न्याय, अर दया, अर विस्वास ख छोड़ दियो हैं; चाहनो थो कि इन ख भी कर रहनो अर उन ख भी नी छोड़ ");
INSERT INTO hlb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","अरे अंधा अगुवा हुन, तुम मच्छर ख ते छान डाल हैं, पर ऊँट ख निगल जाव हैं। ");
INSERT INTO hlb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“अरे कपटी सासतिरी हुन, अर फरीसी हुन, तुम पर धितकार! तुम टाटी हुन ख ऊपर-ऊपर से ते मांजा हैं। पर वी भीतर अन्धेरो अर असंयम से भरो हुयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","अरे अंधा हुन फरीसी, पहले थाली ख भीतर से मांजा कि वी बाहर से भी साफ होऐ। ");
INSERT INTO hlb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“अरे कपटी सासतिरी हुन, अर फरीसी हुन, तुम पर धितकार तू चुनो फिरी भई सामधी हुन ख जसो हो जे ऊपर से ते चोक्खो दिखाई देवा हैं पर अन्दर मुर्दा हुन ख हड्डी हुन अर पूरो तरीका को मलिनता से भरो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","यू ही रीति से तुम भी ऊपर से अदमी हुन ख धर्मी दिखाई देवा हैं, पर भीतर कपट अर अधर्म से भारो पड़ियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“अरे कपटी सासतिरी हुन अर फरीसी हुन, तुम पर धितकार! तुम भविस्यवक्ता हुन कि सामधी हुन सुधार हैं अऊर धर्मी हुन कि समसान बनाव हैं, ");
INSERT INTO hlb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","अर कह हैं, पर हम बापदादा हुन का दिन हुन म हता ते भविस्यवक्ता हुन कि खून म उनको संग नी हता। ");
INSERT INTO hlb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ऐसे ते तुम अपनो पर खुद ही गवाई देवा हैं कि तुम भविस्यवक्ता हुन ख खून हुन कि अवलाद आय। ");
INSERT INTO hlb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","अब तुम अपनो बापदादा हुन को पाप ख मटका पूरो तरका से भर दा। ");
INSERT INTO hlb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","अर अरे साँप हुन, अरे करैत हुन ख पोरिया हुन, तुम नरक को सजा से कसो बचे? ");
INSERT INTO hlb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","एकोलाने देख, म तुमारो नजीक भविस्यवक्ता हुन अर समझदार हुन अर सासतिरी हुन ख भेजू हैं; अर तुम ओमा से कई ख मार डाले अर सूली पर चढ़ा, अर कई ख अपनो प्रार्थना घर म कोडला मरे अर एक सहर से दूसरो सहर म भगात फिरे। ");
INSERT INTO hlb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","जेना धर्मी हाबिल से ले ख बिखियाह को पोरिया जकरयाह तक जेना तुम न मन्दिर अर वेदी ख बीच म हत्या डालो हतो, जितना धर्मी हुन को खून धरती पर बह गयो हैं उ सब तुमारो सिर पर पड़े। ");
INSERT INTO hlb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","मी तुम से सच कहूँ हैं यी सब बात हुन यी बखत का अदमी हुन पर आ पड़े। ");
INSERT INTO hlb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“अरे यरूसलेम, अरे यरूसलेम! तू भविस्यवक्ता हुन ख मार डाला हैं, अर जो तोरो नजीक भेजो गयो, उन पर पत्थर हुन मार हैं। कित्ती ही बार मीन चाय्हो कि जसो मुर्गी अपनो पोरिया हुन ख अपनो पंख हुन को नीच इकट्ठा कर हैं, वसो ही मी भी तोरो पोरिया हुन ख इकट्ठा कर लेहूँ, पर तुम न चाय्हो। ");
INSERT INTO hlb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","देखियो, तुमारो घर तुमारो लाने उजाड़ छोड़ो जाय हैं। ");
INSERT INTO hlb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","काहे कि म तुम से कहू हैं कि अब से जब तक तुम नी कहे, ‘धन्य हैं उ, जो प्रभु को नाम से आय हैं’ जब तक तुम मोखा फिर कभी नी देख।” ");
INSERT INTO hlb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","अऊर जब यीसु मन्दिर से निकल ख जा रह रयो, ते ओखा चेला ओ ख मन्दिर ख कसो बनना ख दिखा ओखा नजीक आयो ");
INSERT INTO hlb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","अर यीसु न उन से कय्हो, “तुम यी सब देख रया हैं नी! मी तुम से सच कहूँ हैं यी पत्थर पर पत्थर भी नी छुटेगो ते ढायो नी जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","जब यीसु जैतून का टेकड़ा पर बठो हतो, ते चेला हुन न सुनसान म ओखा नजीक आयो अर बोल्यो, “कि हम ख बता कि यी बात हुन कब होऐ? तोरो आवन का अर दुनिया को आखरी को चिन्ह का होगो?” ");
INSERT INTO hlb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","यीसु न उन ख कय्हो दियो, सतरक रहनू कुई तुम ख कोई नी बहकाऐ, ");
INSERT INTO hlb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","काहेकि बेजा हुन से असो होए जो मोरो नाम से आ ख कहे, मी मसी आय अर बेजा हुन ख बहकाऐ नी। ");
INSERT INTO hlb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","तुम झगड़ा हुन पर झगड़ा हुन की बारे म सुनेगो, ते घबरा मत जानू काहेकि इन को होनू जरूरी हैं, पर उ बखत अन्त नी होऐ। ");
INSERT INTO hlb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","काहेकि जात पर जाति अर राज पर राज चढ़ाई करेगों, अर धरती-धरती पर अकाल पड़ेगो, अर भूकम्प होगो। ");
INSERT INTO hlb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","यी सब बात हुन दुख हुन को सुरू से होऐ। ");
INSERT INTO hlb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","अऊर ते वी दुख देन ख लाने तुम ख पकड़वाएगो, अर तुम ख मार डालेगो, अर मोरो नाम को कारन सब जाति हुन ख अदमी तुम से बुराई रखेगो। ");
INSERT INTO hlb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","एकोलाने बेजा हुन ठोकर खाएँगो, अर एक दूसरा ख पकड़वाएगो, अर एक दूसरा से बुराई रखेगो। ");
INSERT INTO hlb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","अर बेजा हुन झूटा भविस्यवक्ता उठ खड़ो होगो, अर बेजा हुन ख बहकाऐ। ");
INSERT INTO hlb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","अर अधर्म को बड़नो से बेजा हुन को प्रेम ठण्डो पड़ जाएगो, ");
INSERT INTO hlb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","पर जो अन्त तक धीरे धरे रहेगो, ओको ही को उध्दार होगो। ");
INSERT INTO hlb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","अर राज को यी अच्छो समाचार सारो दुनिया म प्रचार करो जाहे, काहेकि सब जाति हुन पर गवाई होए, तब अन्त आ जाएगो। ");
INSERT INTO hlb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“एकोलाने जब तुम सुध्द जगह म नास करनवाली घृनित चीज हुन ख जेकी बारे म दानिय्येल भविस्यवक्ता हुन को अर भई हती, सुध्द जगह म खड़ी भई देख जे पढ़, उ समझ, ");
INSERT INTO hlb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","एकोलाने जो यहूदी हुन म हैं उ टेकड़ा हुन पर भाग जाऊ। ");
INSERT INTO hlb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","जो छत पर होऐ उ अपनो घर म से सामायन लान ख लाने नी उत्तर ");
INSERT INTO hlb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","अर जो खेत म होऐ, उ अपनो कपड़ा लेन ख पीछे नी लउट। ");
INSERT INTO hlb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","उ दिन हुन म जो पेट से अर दूध पिलाव हैं। उन ख लाने धितकार, धितकार। ");
INSERT INTO hlb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","विनती कियो कर पर तुम ख जाड़ा म अर छुट्टी को दिन भोगनु नी पड़े ");
INSERT INTO hlb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","काहे कि उ बखत असो भारी दुख होगो, जसो दुनिया ख सुरु से नी अब तक भयो अर नी कभी होगो। ");
INSERT INTO hlb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","अर उ दिन घटायो नी जातो ते कोई सरीर नी बचावत, पर चुनो भयो को कारन उ दिन घटायो दियो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","उत्ती बखत पर कोई तुम से कहे, देख, मसी यहाँ पर हैं! अर वहाँ हैं! ते विस्वास नी करनु। ");
INSERT INTO hlb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","काहे कि झूटा मसी अर झूटा भविस्यवक्ता न उठ खड़ो होगो, अर बड़ो चिन्ह, अर अदभुत काम दिखागो, कि अदि हो सक ते चुनो भयो ख भी बहका देहे। ");
INSERT INTO hlb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","देख, म न पहले से तुम से यी सब कुछ कय्हो दियो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","एकोलाने पर उ तुम से कहे ख, देख, उ जंगल म हैं, ते बाहर नी निकल जानो; अर देख, उ कोठरी हुन म हैं ते विस्वास नी करनु। ");
INSERT INTO hlb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","काहेकि जसो बिजली पूर्व से निकल ख पस्चिम तक चमक हैं, “वसो ही इंसान को पोरिया को भी आनो होगो।” ");
INSERT INTO hlb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“अर जिते कही ढोर मरियो होए उते चील इकट्ठी होए।” ");
INSERT INTO hlb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“उ दिन हुन म दुख को जल्दी बाद सूरज अन्धिरा होए जाएगो, अर चन्द्रमा को उजालो जाते रहे, अर तारा हुन आकास से गिर पड़ेगो अर आकास कि सामर्थ्य हिलायी जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","पर इंसान को पोरिया ख चिन्ह आकास म दिखियो देगो, अर तब धरती ख सब गोत हुन को अदमी छाती पीटेगो; अर अदमी को पोरिया ख बड़ी सक्ति अर महिमा को संग आकास ख बदल हुन पर आते देखे। ");
INSERT INTO hlb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","उ तुरही का बड़ो आवाज को संग अपनो स्वर्गदूत हुन को भेजेगो, अर उ आकास ख यी तरफ से उ तरफ तक, चारो दिसा हुन से ओ ख चुनो भयो ख एकजुट करे।” ");
INSERT INTO hlb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“अंजीर को झाड़ से यू उदाहरन सीख जब ओकी डाली हुन नरम हो जाय हैं अर पत्ता हुन निकल न लग हैं, ते तुम समझ ले हे, कि गर्मी को दिन नजीक आ गया हैं। ");
INSERT INTO hlb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","यी तरीका से जब तुम इन सब बात हुन ख देख; ते समझ ले कि यी उ नजीक हैं, कोई दरवाजा ही पर हैं। ");
INSERT INTO hlb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","म तुम से सच कहूँ हैं कि जब तक यी सब बात हुन पूरी नी हो जाहे, ते तब तक यी पीढ़ी को अन्त नी होगो।” ");
INSERT INTO hlb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","आकास अर धरती मिट जाहेगो, पर मोरो बात कभी नी मिटगो। ");
INSERT INTO hlb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“उ दिन अर उ बखत को बारे म कोई नी जान हैं नी हैं, न स्वर्ग दूत अऊर न पोरिया; पर सिर्फ परमेस्वर बाप।” ");
INSERT INTO hlb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","जसो नूह को दिन म हते, वसो ही इंसान को पोरिया आन वालो भी होगो। ");
INSERT INTO hlb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","काहेकि जसो पानी प्रलय पहलो ख दिन हुन म, जे दिन तक कि नूह नाव पर नी चढ़ो, उ दिन तक अदमी हुन खात पीत रयो हतो, अर ओमा बिहावा होत रयो हतो। ");
INSERT INTO hlb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","अर जब तक पानी प्रलय आय ख उ सब ख बहा नी ले गयो, तब तक उन ख कुछ भी मालूम नी पड़ो; वसो ही इंसान को पोरिया को आन भी होऐ। ");
INSERT INTO hlb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","उ बखत दो अदमी हुन खेत म होगो, एक ले लियो जाएगो अर दूसरा ख छोड़ दियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","दो बाई हुन चक्की पीसते रहे, एक ख ले ली जाहे अर दूसरी ख छोड़ दी जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","एकोलाने जगते रहनू, काहेकि तुम नी जान हो की तुमारो प्रभु कोई दिन आहे। ");
INSERT INTO hlb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","पर यू समझ ले कि पर घर को मालिक जान हैं कि चोर कोई बखत पहर आएँगो ते जागते रहते, अर अपनी घर म चोरी हो नी देतो। ");
INSERT INTO hlb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","एकोलाने तुम भी सावधान रह, काहे कि जो बखत को बारे म तुम विचार भी नी हैं, उ बखत इंसान को पोरिया आ जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ते अब उ भरोसा योग्य अर समझदार, दास कोन हैं, जेना मालिक न अपनो नऊकर-चाकरो पर मुखिया रूको कि बखत पर उन ख खाना देहे? ");
INSERT INTO hlb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","भलो हैं वी दास, जेका ओको मालिक आय ख असो ही करत पायो। ");
INSERT INTO hlb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","“मी तुम से सच कहूँ हैं वी ओ ख अपनी सारी धन-संपति पर हक रहे।” ");
INSERT INTO hlb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","पर यदि उ बुरो दास अपनो मन म कहयो कि मोरो मालिक ख आन म देरी हैं, ");
INSERT INTO hlb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","अर अपनो दोस दास हुन ख मरन लगो, अर पीवन वालो को संग खाए-पीए। ");
INSERT INTO hlb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ते उ दास ख मालिक असो दिन आएँगो, जब उ ओकी रस्ता नी देख हैं, अर असी घड़ी जेख उ नी जान हैं। ");
INSERT INTO hlb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","तब उ ओ ख भारी सजा देगो अर ओको भाग कपटी हुन ख संग ठहराएगो: वहा रोनू अर दाँत पीसनू होऐ। ");
INSERT INTO hlb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ते स्वर्ग को राज उ दस कुंवारी हुन ख जसो होगो जो अपनी मसाले लेख दूल्हा से मिलन करू ख निकली। ");
INSERT INTO hlb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ओ म पाँच बेवकूप अर पाँच समझदार हती। ");
INSERT INTO hlb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","अर बेवकूप हुन न अपनी मसाल हुन ते ली, पर अपनो संग म तेल नी लियो; ");
INSERT INTO hlb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","परन्तु समझदार हुन न अपनी मसाल हुन ख संग अपनी कुप्पी हुन म भी तेल भर लियो। ");
INSERT INTO hlb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","जब दूला ख आन म देर भई, ते वी सब ऊगन लगी अर सो गई।” ");
INSERT INTO hlb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“आधी रात ख धूम मची; देखियो, ‘दूला आ रह हैं! ओसे भेट करन का लाने चलो।’ ");
INSERT INTO hlb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","तब वी सब कुंवारी हुन उठ ख अपनी मसाल हुन सुधार करन लगी। ");
INSERT INTO hlb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","अर बेवकूप न समझ दार हुन से कय्हो, ‘अपनो तेल म से कुछ हम ख भी दे, काहेकि हमारी मसाल हुन भुझी जाय रही हैं।’ ");
INSERT INTO hlb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","पर समझदर हुन न कय्हो दियो, ‘कभी भी हमारो अर तुमारो लाने पूरो नी हैं; अच्छो ते यू हैं कि तुम बेचन वालो का नजीक जा ख अपनो लाने खरीद ले।’ ");
INSERT INTO hlb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","जब वी खरीदन लेन ख जाय रही हती ते दूला आ पहुचो, अर जो तैयार हती, वी ओखा संग बिहाव का घर म चली गई अर दरवाजा बंद कियो गयो।” ");
INSERT INTO hlb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“एको बाद वी दूसरी कुंवारी हुन भी आय ख कहन लगी, अरे मालिक, अरे स्वामी, हमारो लाने दारवाजा खोल दे!” ");
INSERT INTO hlb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ओ न कय्हो दियो, म तुम से सच कहू हैं म तुम ख नी जानू हूँ। ");
INSERT INTO hlb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","एकोलाने जागते रह, काहे कि तुम नी उ दिन ख जान हैं, नी उ बखत ख। ");
INSERT INTO hlb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“काहे कि यू उ अदमी को जसो दसा हैं, जे न दूसरो देस म जाते बखत अपनी दास हुन ख बुला ख अपनी धन संपति उन ख दे दियो। ");
INSERT INTO hlb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ओ न एक ख पाँच तोड़ा, दुसरा ख दो अर तीसरा ख एक: असो कि हर एक ख ओकी सक्ति ख अनुसार दियो, अर तब दूसरो देस चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","तब जेका पाँच तोड़ा मिलो हतो, ओ न परन्तु जाय-ओ न लेन-देन कियो, अर पाँच तोड़ा अर कमायो। ");
INSERT INTO hlb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","यी तरीका से जे ख दो मिलो हतो, ओ न भी दो अर कमायो। ");
INSERT INTO hlb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","पर जे ख एक मिलो हतो, ओ न जाय ख जमीन कि मिठ्टी खोदी, अर अपनो मालिक ख पैसा छुपा दियो।” ");
INSERT INTO hlb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“बेजा दिन हुन का बाद वी दास हुन ख आँख मालिक उनसे हिसाब लेहे।” ");
INSERT INTO hlb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","जे ख पाँच तोड़ा मिलो हतो, ओ न पाँच तोड़ा अर लेख कय्हो, हे मालिक, तू न मोखा पाँच तोड़ा दियो हतो, देख, मी न पाँच तोड़ा अर कमायो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ओखा मालिक न ओ से कय्हो, धन्य हे भलो अर विस्वास योग्य दास, तू थोड़ा म भरोसा योग्य दास, तू थोड़ा म विस्वास लायक रहे; म तोखा बेजा चीज हुन को अधिकारी बनाऊँ। अपनो मालिक ख खुसी म सामिल होऐ। ");
INSERT INTO hlb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","अर जे ख दो तोड़ा मिलो हतो, ओ न भी आय ख कय्हो, हे मालिक तू न मोखा तोड़ा दियो हतो, देख म न दो तोड़ा अर कमायो। ");
INSERT INTO hlb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ओखा मालिक न ओ से कय्हो, धन्य अरे भलो, अर विस्वास लायक दास, तू थोड़ा म विस्वास लायक रयो; मी तोखा बेजा चीज हुन ख अधिकारी बनाऊँ। अपनो स्वामी ख खुसी म साम्मिल हो। ");
INSERT INTO hlb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","तब जे ख एक तोड़ा मिलो हतो, ओ न आय ख कय्हो, अरे मालिक, म तोखा जान हतो कि तू पक्को। अदमी हैं तू जहाँ कही नी बोव हैं वहा से काट हैं, अर जहाँ पर नी फेक हैं वहाँ से सकल हैं। ");
INSERT INTO hlb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","एकोलाने म डर गयो अर जाय ख तोरा तोड़ा जमीन म छुपा दियो देख, जो तोरो हैं, उ यू आय। ");
INSERT INTO hlb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ओखा मालिक न ओ से कय्हो दियो, हे बुरो अर आलसी दास, जब तू यू जाने हतो कि जहाँ म नी बोय वहा से काट हूँ, अर जहाँ म न नी फेक वहा से सकल हैं; ");
INSERT INTO hlb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ते मोखा चाहियो हतो कि मोरो पैसा सर्राफो ख देते, तब मी आय ख अपनो धन-दूगनो संग ले हूँ। ");
INSERT INTO hlb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","एकोलाने उ तोड़ा ओ से ले ले, अर जेका नजीक दस तोड़ा हैं, ओ ख दे दे। ");
INSERT INTO hlb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","काहेकि जे का कोई का नजीक हैं, ओ से अर दियो जाएगो; अर ओखा नजीदीक बेजा हो जाएगो: पर जे का नजीक नी हैं, ओ से उ भी जो ओखा नजीक हैं, ले लियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","अर यी बिमार हुन दास ख बाहर को अंधेरा म डालो दो, वहा पर रोनू अर दाँत पीसनू होगो। ");
INSERT INTO hlb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“तब इंसान को पोरिया माहिमा म आएँगो, अर सारो स्वर्गदूत हुन ओखा संग आएँगो, ते उ अपनी महिमा का संग सिंहासन पर बठे होऐ।” ");
INSERT INTO hlb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","अऊर सारी जाति हुन ओको सामने एकजुट करो जाहे: अर जसो कि चरानवाला भेड़ी हुन ख बकरी हुन से अगल कर दे हैं, वसो ही उ उन ख भी एक-दूसरा से अगल करेगों। ");
INSERT INTO hlb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","उ भेड़ी हुन ख अपनी दाहिनी तरफ अर बकरी हुन ख बाई तरफ खड़ो करे। ");
INSERT INTO hlb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","तब राजा अपनी दाहिनी ओर को लोग हुन से कहेगो, मोरो बाप ख किरपा पस्र हुन आ अर उ राज को अधिकारी हुन बनो, जे दुनिया को सुरूवात से तुमारो लाने तैयार करियो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","काहेकि म भूको हता, अर तुम न मोखा जोव ख नी दियो; मी प्यासो हतो, अर तुम न मोखा पानी नी दियो, म परदेसी हतो, अर तुम न मोखा अपनो घर म रखो; ");
INSERT INTO hlb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","म नंगो हतो, अर तुम न मोखा कपड़ा पहिनायो; म बीमार हतो, अर तुम न मोरी देख भाल करी, म जेल म हतो, अर तुम मोखा मिल आयो। ");
INSERT INTO hlb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ऐपर धर्मी ओ ख से कहेगो, अरे प्रभु हम न कब तो ख भूखो देखियो हतो? अऊर हम न कब प्यासो देखियो अर पानी पिलायो? ");
INSERT INTO hlb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","हम न कब तोखा दूसरो देस देखो अर अपनो घर म ठहरयो? अर नंगो, देखियो हतो अर कपड़ा पहिनायो? ");
INSERT INTO hlb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","हम न कब तोखा बीमार अर जेल घर म देखियो अर तो से मिलन आयो? ");
INSERT INTO hlb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","तब राजा उन ख उत्तर देगो, म तुम सच कहू हैं कि तुम न जो मोरो इन छोटा हुन से छोटा हुन भई हुन म से कोई एक का संग कियो, उ मोरो ही संग कियो। ");
INSERT INTO hlb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","तब उ बाई तरफ वाला से कहेगो, अरे पापी अदमी हुन, मोरो सामने से उ अनन्त आग म चलो जा, ते सैतान अर ओखा दूत हुन ख लाने तैयार कियो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","काहेकि म भूखो हतो, अर तुम न म खान ख नी दियो; म प्यासो हतो, अर तुम न मो ख पानी नी पिलायो; ");
INSERT INTO hlb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","मी दूसरो देस हतो, अर तुम न मोखा अपनो घर हुन म नी रखो; म नंगो हतो, अर तुम न मोखा कपड़ा नी पहिनायो; म बीमार अर जेल घर म हतो, अर तुम न मोरी खबर नी ली। ");
INSERT INTO hlb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“तब वी उत्तर देगो, अरे प्रभु हम न तोखा कब भुखो, अर प्यासो, अर दूसरो देस अर नंगो, अर बीमार, अर जेल घर म देखियो, अर तोरी सेवा देखभाल नी कि। ");
INSERT INTO hlb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","तब उ उन उत्तर देगो, ‘मी तुम से सच कहू हैं कि तुम न जो इन छोटो से छोटो म से कोई एक को संग नी कियो, उ मोरो संग भी नी करियो।’ ");
INSERT INTO hlb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","अर यू अनन्त सजा भोगे पर धर्मी को अन्त जिन्दगी म भीतर करेगों।” ");
INSERT INTO hlb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","जब यीसु यी बात हुन ख कह चुकियो ते अपनो चेला हुन से कहन लग गयो, ");
INSERT INTO hlb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“तुम जाना हैं कि दो रोज को बाद फसह को तिहार आनवालो हैं, अर इंसान को पोरिया सूली पर चढ़ा दियो जान को लाने पकड़ा दियो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","अऊर तब काइफा नाम को मेन पुजारी को महल म अऊर भी दुसरा बड़ा पुजारी हुन अऊर समाज ख सियाना इंसान हुन एक जुट भया। ");
INSERT INTO hlb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","अर उनना आपस म सला मसुरा करयो कि हम कसो तरीका से यीसु ख चतुरई से पकड़ाहे अऊर ओखा मार डाले। ");
INSERT INTO hlb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","पर वी कहत रहा, “तिहार को बखत म नी। कई असो नी होय कि जनता म लड़ई झगड़ा हो जाय।” ");
INSERT INTO hlb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","जब यीसु बैतनिय्याह म समोन कोढ़ी को घर म हतो, ");
INSERT INTO hlb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ते एक बाई न संगमरमर को बर्तन म महेगो वालो इतर लेखा आयी अऊर जब उ खाना खात ही रहा कि ओ ना ओकी मुंडी पा इतर डाल दियो। ");
INSERT INTO hlb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","यू देख ख ओखा चेला हुन गुस्सा हो गया अर कहन लग गया, एको काहे सत्यनास करयो? ");
INSERT INTO hlb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","एका ते अच्छी किमत म बेच ख गरीब-लचार हुन ख बाट दियो जा सकत रहा। ");
INSERT INTO hlb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","यू जान ख यीसु न उनसे बोल्यो, “तुम या बाई ख काहे परेसान करा हैं? ओ ना मोरो संग भलाई करी हैं। ");
INSERT INTO hlb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","गरीब हुन तो हमेसा तुमरो संग म रहवा हैं पर मी तुमरो संग हमेसा नी रहन को। ");
INSERT INTO hlb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ओ न मोरी सरीर पर जो यू इतर डालो अरे, उ मोरो गाड़ो जान का लाने कियो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","म तुम से सच कहू हैं कि पूरी दुनिया म जहाँ कही यू अच्छो खबर प्रचार कियो जाहे, वहा ओखा यू काम को बारा म ओखा याद म कियो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","तब यहूदा इस्करियोती न, जो बारा चेला म से एक हतो, याजक हुन को नजीक जाय ख कय्हो, ");
INSERT INTO hlb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“पर म ओ ख तुमारो हात पकड़वा दू ते मो ख का दे हे?” उन ख ओ से तीस चाँदी को सिक्का नाप ख दे दियो। ");
INSERT INTO hlb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","अर उ उही बखत से ओ ख पकड़ ख मऊका खोजन लगो। ");
INSERT INTO hlb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","अखमीरी रोटी को तेवार को पहले दिन, चेला यीसु का नजीक आय ख पुछन लगो, “तू कय्हो चावह हैं कि हम तोरो लाने फसह खान कि तैयार करे?” ");
INSERT INTO hlb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ओ न कय्हो, “सहर म बेकार अदमी का नजीक जाय ख ओ से कय्हो, ‘प्रभु कह हैं कि मोरो बखत निकट हैं। म अपनो चेला हुन ख संग तोरो यहाँ तेवार फसह ख मनाऊ।’” ");
INSERT INTO hlb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","तब चेला हुन न यीसु कि आग्या मानी अर फसह तैयार कियो। ");
INSERT INTO hlb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","जब साम भई ते वी बारा हुन का संग खानो करन ख लाने बठो। ");
INSERT INTO hlb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","जब वी खा रहे हते ते ओ न कय्हो, “मी तुम से सच कहू हैं कि तुम म एक मो ख पकड़वाएगो।” ");
INSERT INTO hlb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ऐपर वी बेजा उदास भयो अर हर एक ओ से पुछन लगो, “अरे प्रभु का उ मी हूँ?” ");
INSERT INTO hlb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ओ न कय्हो दियो, “जेन मोरो संग थाली म हात डालो हैं, उ मो ख पकड़वाएगो। ");
INSERT INTO hlb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","अर इंसान को पोरिया ते जसो ओखा बारा म लिखो हैं जाय हैं: पर उ अदमी पर धितकार हैं जेको व्दारा अदमी को पोरिया पकड़वा जाय हैं: पर उ अदमी को पैदा ही नी होतो, ते ओखा लाने अच्छो हतो।” ");
INSERT INTO hlb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","“यीसु ओको पकड़वालो यहूदा न कय्हो, अरे गुरू का उ मी आय?” ओ न ओसे कय्हो “तू कह चुको हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","अर जब वी खा हते ते यीसु न रोटी ली, अर आसीस माँग ख तोड़ी अर चेला हुन ख देकर कय्हो, “ले, खा; यू मोरो सरीर आय।” ");
INSERT INTO hlb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ते ओ न कटोरा ले ख धन्यवाद कियो, अर उन ख दे ख कय्हो, तुम सब इन म से पीओ, ");
INSERT INTO hlb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","काहेकि यी वादा को मोरो उ खून आय, जो बेजा हुन का पाप हुन ख छमा का लाने बहायो जा रहा हैं। ");
INSERT INTO hlb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","“म तुम से कहू हैं कि मी अंगूर को यू रस उ दिन तक कभी न पीऊ, जब तक तुमारो संग अपनो बाप को राज म नयो नी पीऊ।” ");
INSERT INTO hlb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","अऊर वी भजन गान को बाद यीसु अर उनको चेला जैतून टेकड़ा पर चल गयो। ");
INSERT INTO hlb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","उ बखत यीसु न चेला हुन से कय्हो, “आज ही रात ख मोरो बारा म तुम सब का विस्वास को इनकार होऐ; काहेकि धर्म सास्त म यू भी लिखो हैं: मी चरनवालो ख मारू, अर झुंड ख भेड़ी हुन तितिर बितर हो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","पर मी मोरो जिन्दो होन को बाद तुम से पहले गलील ख जाऊ।” ");
INSERT INTO hlb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","यी पर पतरस न यीसु से कय्हो, “चाहे तुम ख बारा म सब को विस्वास ख नास हो जाहे; पर मोरो विस्वास को नास कभी नी होऐ।” ");
INSERT INTO hlb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","यीसु न ओसे कय्हो, “मी तो से सच कहूँ हैं कि आज ही रात को मुर्गा का बाँग देना से पहले ही, तुम तीन बार मोसे से इनकार करे।” ");
INSERT INTO hlb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","पतरस न ओ से कय्हो, “अदि मोखा तोरो संग चाहे मरन ही काहे नी पड़े, मी तुम ख कभी इनकार नी करू।” यू तरीका दूसरा सब चेला हुन नी भी कय्हो। ");
INSERT INTO hlb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","तब यीसु अपनो चेला हुन का संग गतसमनी नाम एक जगह म आयो उ उन से कय्हो, “तुम लोग हुन यहाँ बैठ, मी तब तक वहाँ विनती कर जाऊ हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","उ पतरस अर जबदी को दुई पोरिया हुन ख अपनो संग ले गयो, यीसु नाराज अर व्याकुल होन लगो। ");
INSERT INTO hlb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","अर ओ न उन से कय्हो, “मोरो मन बेजा जादा उदास हैं, यहाँ तक कि मोरी जान निकल जा रयो हैं। तुम यही रूको अर मोरो संग जागते रहनु।” ");
INSERT INTO hlb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","अऊर यीसु थोड़ीदर आगे बढ़ ख अर उनना धरती पर मुँह को बल गिर ख, यू विनती करी, “अरे मोरो बाप अदि हो सक, ते यू कटोरा मो से हटा दे, ते भी जसो म मोरी नी, पर तोरी मर्जी पूरी होऐ।” ");
INSERT INTO hlb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ते ओ न चेला हुन ख नजीक आय उन ख सोते देख ख अर पतरस से कय्हो, “का तुम मोरो संग एक बखत भी नी जाग सका? ");
INSERT INTO hlb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","जागते रह अर विनती करते रह कि तुम परीक्छा म नी पड़ो; आत्मा ते तैयार हैं, पर सरीर कमजोर हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","उ ते दुसरी बार गयो अर उनना यी विनती करी, “अरे मोरो बाप, अदि यू कटोरा मोरो पीवन बिना नी हट सक हैं ते तोरी ही मर्जी पूरी हो।” ");
INSERT INTO hlb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ते ओ न आय ख उन ख फिर सोते देखियो, काहेकि उनकी आँख नींद से भरी हती रह। ");
INSERT INTO hlb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","अर यीसु उन ख छोड़ ख उ ते चलो गयो, अर उन ख आवाज म ते तीसरी बार विनती करी। ");
INSERT INTO hlb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","अऊर ऐको बाद उ अपनो चेला हुन ख नजीक आय ख अर ओसे कय्हो, “अब सोते रह, अर आराम कर रयो हो; देखियो, उ बखत नजीक आ गयो हैं, इंसान को पोरिया पापी हुन न को हात पकड़वायो जा रयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","उठो, चलो! देखो, मोरो पकडान वालो नजीक म आ गयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","अऊर यीसु कह ही रह हतो कि यहूदा जे बारा हुन म से एक हतो कि आयो, अर ओखा संग मुखिया हुन याजक अर अदमी को सियाना हुन कि तरफ से बड़ी भीड़ तलवारे अर लाठी हुन लियो भई आय। ");
INSERT INTO hlb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","अऊर ओ ख यू पता दियो रह कि जोको; “जे ख म चुम लूँ उई हैं; ओ ख पकड़ लेनो।” ");
INSERT INTO hlb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","अर तुरंत यीसु का नजीक आय ख कय्हो, “अरे गुरू नमस्कार!” अर ओ ख बेजा चूमा लियो। ");
INSERT INTO hlb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","यीसु न ओसे कय्हो, “अरे दोस्त, जे करन आयो हूँ, ओ ख कर ले।” ते लोग बढ़ आयो अर उनना यीसु पर हात डाले अर उन ख पकड़ लेनो लियो। ");
INSERT INTO hlb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ऐपर यीसु को एक दोस्त हुन म से एक न हात बढ़ ख अपनी तलवार खीच ली अर बड़ो याजक को दास पर चल ख ओको कान उड़ा दियो। ");
INSERT INTO hlb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","अऊर यीसु न ओ से कय्हो, “अपनी तलवार म्यान म रख लो काहेकि जे तलवार चलाय हैं वी पूरा तलवार से नास कियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","का तू यू समझ हैं कि मी अपनो बाप से मददत नी मांग सक? का उ यी पल भर मोरो लाने स्वर्गदूत हुन कि बारा से भी अधिक सेना हुन नी भेज देहु? ");
INSERT INTO hlb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","पर सुध्द सास्र को हिसाब कसो पूरो होगो, जेकी समान असो होनो जरूरी हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","उत्ती बखत यीसु न भीड़ से कय्हो, “का तुम तलवार हुन अर लाठी हुन ले ख मोखा डाकू का जसो पकड़न ख लान निकला हैं? म हर दिन मन्दिर म बठो ख सिखात देवा रयो हतो, अर तुम न मोखा नी पकड़ियो।” ");
INSERT INTO hlb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","यी सब एकोलाने भयो कि भविस्यवक्ता हुन ख वचन पूरो भयो। ते सब चेला ओ ख छोड़ ख भाग गयो। ");
INSERT INTO hlb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","तब यीसु ख पकड़वालो ओ ख काइफा नाम बड़ो पुजारी का नजीक ले गयो, जिते सासतिरी अर सियाना हुन एक जुट भया हता। ");
INSERT INTO hlb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","पतरस थोड़ी दूर पर यीसु को पीछु-पीछु गयो, उ मुखिया याजक को घर को आँगन तक गयो, अर नतिज्जा जान ख लाने भीतर जाय ख सिपाई हुन का संग बैठो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","मेन याजक अर पूरी बड़ी सभा यीसु ख मार डालन को लाने ओखा विरोध म झुठी गवाही को खोज म हता, ");
INSERT INTO hlb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","पर उ मिलो नी अगर बेजा से झूठे गवाह हुन का आयो आखरी म दो गवाह आँख कहे, ");
INSERT INTO hlb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","अर कय्हो, “ये न कय्हो हैं कि म परमेस्वर को मन्दिर ख गिरा सकू हूँ अर ओ न तीन दिन म बान सक हूँ।” ");
INSERT INTO hlb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ऐपर पर मुखिया बड़ो याजक न खड़ो हो ख यीसु से कय्हो, यी लोग तुमारो खलाप जे गवाह दे रयो हैं, “का ऐको जवाब तुमारो नजीक नी हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ऐ पर यीसु चुप रयो। तब मुखिया बड़ो याजक न ओ से कय्हो, “म तोसे जीवित परमेस्वर कि कसम दे हूँ कि तू परमेस्वर को पोरिया मसी हैं, ते हम से कह दे।” ");
INSERT INTO hlb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","यीसु न ओ से कय्हो, “तु न तुम ही कह दियो; पर मी तुम से यू भी कहू हैं कि अब से तुम इंसान को पोरिया ख सर्व सक्ति को दाहिनी ओर बैठे, अर आकास ख बादल हुन पर आते देखे।” ");
INSERT INTO hlb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","यू पर बड़ो याजक न अपनो कपड़ा फाड़ अर कय्हो, “ये न परमेस्वर कि बुराई करी हैं, अब हम गवाह हुन का प्रयोजन देख, तुम न अभी यी बुराई सुनी हैं! ");
INSERT INTO hlb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","तुम का सोच हैं?” उनना कय्हो दियो, यू माऊत होन का लायक हैं। ");
INSERT INTO hlb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","तब उनना यीसु को मुँह पर थुको अर, उन ख मुक्का मारिया। अर कई थप्पड़ मारते हुयो यू कय्हो, ");
INSERT INTO hlb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“अरे मसी अदि तू भविस्यवानी कर, ते हम ख बता कि तोखा कोन मारो?” ");
INSERT INTO hlb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","पतरस अभी नीच आँगन म ही बाहर बठो हतो कि एक दासी पतरस नजीक आई अर बोली, “तू भी ओकी गलीली यीसु का संग हतो।” ");
INSERT INTO hlb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","पर ओ ना सब को जोने इनकार करते हुए बोलयो, “मी नी जानू कि तू का बोल राई हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","अऊर ऐको बाद पतरस बाहर भीतर दुवार पर चलो गयो, पर एक दूसरी दासी न पतरस ख देख लियो अर वहाँ खड़ो हुयो व्यक्ति हुन से कय्हो, “यू व्यक्ति यीसु नासरी ख संग हता।” ");
INSERT INTO hlb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","अऊर पतरस न कसम खा कर फिर इनकार कियो: अर कय्हो, “मी ओ ख अदमी ख नी जानऊ।” ");
INSERT INTO hlb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","थोडा देर बाद अदमी हुन न जो वहाँ खड़ो हता, पतरस ख नजीक आय ख ओ से कय्हो, “सचमुच तू भी ओ म से एक हैं, काहेकि तोरी बोली तोरो छुपो राज खोल हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","तब पतरस खुद ख धिक्कार अर कसम खान लगो: “मी उ अदमी ख नी जानऊ।” तभी मुर्गा न बाँग दी। ");
INSERT INTO hlb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","तब पतरस ख यीसु कि बात याद आई “तब मुर्गा ख बाँग देना से पहले ही तू मो ख तीन बार इनकार करे।” अर पतरस बाहर जा ख फूट-फूट कर रोन लगो। ");
INSERT INTO hlb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","जब सबेरे भयो ते सब याजक मुखिया हुन अर अदमी हुन ख सियाना हुन न यीसु ख मार डालन कि सला मसुरा करियो। ");
INSERT INTO hlb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","अऊर उनना यीसु ख बाँध अर उन ख ले जा ख राजपाल पिलातुस ख सोप दियो। ");
INSERT INTO hlb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","जब यीसु को पकड़वान वालो यहूदा न देख्यो कि उनका सजा मिली हैं, तब ओखा पछतावा भयो अऊर बड़ा याजक हुन अर धरम का सियाना हुन को जोने चाँदी का तीस सिक्का वापिस लऊटान ख लायो, अऊर बोलयो, ");
INSERT INTO hlb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","अर कय्हो, “मी न बिन कसुर वालो ख मरवान को लाने पकडा ख पाप करयो हैं।” उनना बोलयो, “हमका येसे का! तुइच जान।” ");
INSERT INTO hlb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ऐपर यूहदा न चाँदी को सिक्का हुन ख मन्दिर म फेक दियो अर वहाँ से चलो गयो। ते जा ख ओ न फासी लगा ली। ");
INSERT INTO hlb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","अऊर मुखिया याजक हुन न चाँदी को सिक्के उठा ख कय्हो, इन ख खजाना म इकट्ठा करनो चोक्खो नी हैं, यू ते खून को दाम हैं। ");
INSERT INTO hlb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","तब उनना सलाह कर ख उन सिक्का हुन से दुसरो देस को गाड़ जान ख लाने कुमार को खेत खरीद ले लियो। ");
INSERT INTO hlb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","यी कारन हैं की उ जगह आज तक खून को जगह कहलाव हैं। ");
INSERT INTO hlb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","अऊर जो वचन यिर्मयाह भविस्यवक्ता हुन ख व्दारा कय्हो गयो हतो उ पूरो भेयो: “उनना वी तीस सिक्का असो कि उ ठहरायो हुए दाम ख (जेको इस्राएल कि खानदान म से कई न ठहरायो हतो) ले लियो, ");
INSERT INTO hlb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","अर उन ना यी सिक्का हुन कुमार को जगह का लाने दा दियो, जसो कि प्रभु न मोखा हुकुम दियो हतो।” ");
INSERT INTO hlb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","अऊर जब यीसु हाकिम का सामने खड़ो हतो ते हाकिम न उन से पुछो, “का तू यहूदी हुन को राजा आय?” यीसु न कय्हो दियो, “तुम खुद ही यू कह रैया हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ते मुखिया पुजारी अर सियाना हुन ओ पर दोस लगो रह हते, ते ओ न कुछ जवाब नी दियो। ");
INSERT INTO hlb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","यी पर पिलातुस न यीसु से कय्हो, “का तू नी सुन्यो कि यू तुमारो विरोध कित्ती गवाही हुन दे रह हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","पर यीसु न पिलातुस ख कोई भी बात को कोई जवाब नी दियो। पिलातुस ख ऐपर बेजा हैंरान भयो। ");
INSERT INTO hlb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","अऊर फसह को तिहार को मऊका पर हाकिम को नियम हतो कि उ कोई भी एक बन्दी ख, जेको भीड़ चाह हती, उनको लाने छोड़ दियो कर हतो। ");
INSERT INTO hlb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","अऊर उत्ती बखत बरअब्बा नाम को एक बदनामी अदमी बन्दीगृह म हतो। ");
INSERT INTO hlb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","अऊर पिलातुस न इकट्ठा भयो अदमी हुन से कय्हो, “तुम का चाह हैं कि म तुमारो लाने कोसे छोड़ दू? बरअब्बा ख या यीसु ख जे मसी कहलाव हैं?” ");
INSERT INTO hlb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","काहेकि उ जानत रह कि उन ख यीसु ख बुराई से पकड़वायो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","जब उ न्याय कि राज गदी पर बठो भेयो हतो ते ओकी घर वाली न ओ से कहला भेजो, “तु उ धर्मी ख लाफड़ा म हात नी डालनो, काहे कि मी न आज सपना म ओखा कारन बेजा दुख उठायो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","अर मुखिया हुन अर पुजारी अर सियाना हुन न अदमी हुन ख बहका दियो कि वी बरअब्बा ख छोड़े अर यीसु ख खत्म करे। ");
INSERT INTO hlb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","अऊर हाकिम न लोग हुन से फिर पूछो “तुम का चाह हैं? दोई म से कोई ख तुमारो लाने छोड़ दू?” उनना कय्हो दियो, “बरअब्बा ख।” ");
INSERT INTO hlb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","अर पिलातुस न ओ न से पुछो, “फिर यीसु ख, जो मसी बोल हैं, का करू?” सब न ओसे कय्हो “उ सूली पर चढ़ायो जाऐ!” ");
INSERT INTO hlb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","अर पिलातुस न पूछो, “काहे, इन से कऊन न पाप करियो हैं?” पर वी अर भी जोर से चिल्ला ‍चिल्ला ख कहन लगियो, “यीसु ख सूली पर चढ़ायो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","जब पिलातुस न देख्यो कि यीसु ख बचानु म मऊका न मिलत हाय, बल्कि हल्ला अऊर भी बढ़ते जावा हैं, ते ओ ना पानी माँग ख इंसान हुन को सामने हात धोयो अर, कय्हो, “मी यू इंसान को खून को गुनागार नी हाय। तुम इंसान हुन जानो।” ");
INSERT INTO hlb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","सब अदमी हुन न जवाब दियो, “ऐको खून से हम पर अर हमारो खानदान पर होए।” ");
INSERT INTO hlb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","यी पर पिलातुस न उनको लाने बरअब्बा को छोड़े ख दियो अर यीसु ख कोड़ा लगवा ख सूली पर चढ़ान को लाने सिपाही हुन ख हात म सोप दियो। ");
INSERT INTO hlb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","अऊर एकोबाद हाकिम हुन ख सिपाही यीसु ख किला ख अन्दर ले गया अर उनना यीसु को पास पूरा पलटन को झुंड इकट्ठा कर लियो।, ");
INSERT INTO hlb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","अर यीसु को कपड़ा ख उतार ख ओ ख लाल रंग को कपड़ा को कुरता पहिनायो, ");
INSERT INTO hlb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","काटा को मुकुट गूथ ख ओकी मुंडी पा धर दियो अर ओको जेवनो हात म सरकण्डा थमा दियो। तब ओको जोने टोंगरीया टिका-टिका ख उनना यू बोल-बोल ख ओको मजाक उडायो, “यहूदी हुन को राजा प्रणाम!” ");
INSERT INTO hlb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","अर उनना उन पर थूको अर सरकण्डा लेख उनको सिर पर मारियो। ");
INSERT INTO hlb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","जब वी ओको मजाक उड़ा चुकिया, ते वी कुरता ओपर से उतार ख फिर ओकईच कपड़ा ओखा पहिनाया, अर सूली पर चढ़ान को लाने ले गया। ");
INSERT INTO hlb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","बाहर जाते हुए उन ख समोन नाम एक कुरेनी अदमी मिलो। उनना ओसे बेगार म पकड़ो कि ओको सूली उठा ख ले चलो। ");
INSERT INTO hlb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","अऊर वी जगह पर जे गुलगुता पर कि खोपड़ी को जगह पर बोल हैं पहुँच ख ");
INSERT INTO hlb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","अर वहाँ लोग हुन न यीसु ख पित्त मिलो हुयो अंगूर को रस पीवन ख दियो, पर यीसु न ओ ख चखो पर ओ ख पीनो नी चाय्हो। ");
INSERT INTO hlb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","अऊर न यीसु ख सूली पर चढ़ा ख अर चिठ्टी डाल ख उनको कपड़ा आपस म बाँट लेहे, ");
INSERT INTO hlb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","अर वहाँ बैठ ख ओको पहरा देन लगो। ");
INSERT INTO hlb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","अर यीसु को सिर को ऊपर उनको दोसपतर लटकायो, दियो गयो। उ यू तरीका हतो “यहूदी हुन को राजा यीसु हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","तब यीसु संग दो डाकू एक दाहिनो अर एक बाहियो, सूली पर चढ़ायो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","आनो-जानो वाला सिर हिला-हिला ख ओकी बुराई करत हते, ");
INSERT INTO hlb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","अर यू कह हतो, “मन्दिर को मिटान वालो अर तीन दिन म बनावन वालो, अपनो स्वंय ख ते बचा! यदि तू परमेस्वर को पोरिया हैं, ते सूली पर से उतर आ।” ");
INSERT INTO hlb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","यी रीति से मुखिया पुजारी भी सासतिरी हुन अर सियाना मिल ख ठट्ठा ख कर ख कवह हते, ");
INSERT INTO hlb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“यी इन से दूसरो ख बचायो, पर यू अपनो ख नी बचा सक। ते यू ‘इस्राएल को राजा’ हैं। अब यू सूली पर से उतर आय, ते हम ऐपर विस्वास करे। ");
INSERT INTO hlb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ओ न परमेस्वर पर विस्वास रखो हैं; पर उ यी ख चावह हैं, ते अब ऐसे छुड़ा ले, काहेकि यी न कय्हो हतो, मी परमेस्वर को पोरिया हूँ।” ");
INSERT INTO hlb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","यी प्रकार डाकू भी जो ओखा संग सूली पर मर गयो हते, ओकी बुराई करत हते। ");
INSERT INTO hlb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","दोपहर से लेख तीन पहर तक उ पूरो देस म अन्धिरा छायो रयो। ");
INSERT INTO hlb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","अऊर करीब तीन पहर तक यीसु न बड़ो आवाज से बुला ख कय्हो, “एली, एली, लेमा सबक्तनी?” याने “अरे मोरो परमेस्वर, अरे मोरो परमेस्वर, तू न मोखा काहे छोड़ दियो?” ");
INSERT INTO hlb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","जो वहाँ खड़ा हता, ओ म से कितना न यी सुन ख कय्हो, “उ ते एलिय्याह को पुकार हैं।” ");
INSERT INTO hlb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","उन म से एक जल्दी दऊड, ख अर स्पंज ले ख सिरका म डुबायो, अर सरकण्डा म लगा ख यीसु ख पीवन ख दियो। ");
INSERT INTO hlb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","अऊर कई लोग हुन न कय्हो, “रहन दो, देख एलिय्याह ऐख बचान आय हैं कि नी।” ");
INSERT INTO hlb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","तब यीसु न फिर बड़ो जोर से चिल्ला ख जान ख छोड़ दियो। ");
INSERT INTO hlb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","अर देख मन्दिर को परदा ऊपर से नीचु तक फट ख दो टुकड़ा हो गयो; अर जमीन डोल गई अर चट्ठान तड़क गई, ");
INSERT INTO hlb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","अर समसान खुल गई अर सोए हुओ सुध्द इंसान हुन ख बेजा से मरो सरीर जिन्दो हुयो, ");
INSERT INTO hlb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","अर यीसु जिन्दो उठनू का बाद वी समसान म से निकल ख सुध्द सहर म गयो अर बुहत हुन ख दिखाई दियो। ");
INSERT INTO hlb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","अऊर ते सतपति अर जे ओको संग यीसु को पहरा दा रयो हतो, भूकम्प अर जे कोई भेयो हतो ओ ख देख ख बेजा डर गया अर कय्हो, “सचमुच म यी परमेस्वर को पोरिया हतो!” ");
INSERT INTO hlb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","वहाँ पर बेजा सी बाई हुन जे गलील से यीसु की सेवा करती हुई ओखा संग आई हती, दुर से यी देख रही हती। ");
INSERT INTO hlb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","उन म मरियम मगदलीनी, अर याकूब अर यूसुफ कि माय मरियम, अर जबदी को पोरिया हुन की माय हती। ");
INSERT INTO hlb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","जब रात हो जान पर अरिमतियाह सहर को एक धनी सज्जन आयो, ओको नाम यूसुफ हतो, उ खुद यीसु ख चेला बन गयो हतो। ");
INSERT INTO hlb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ओ न पिलातुस का पास जाय ख यीसु को लास माँगो अर पिलातुस न हुकुम दियो कि सरीर ओ ख दे जाहे। ");
INSERT INTO hlb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","यूसुफ न लास लेख ओ ख सुध्द सफेद चादर म लपेटा ");
INSERT INTO hlb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","अर ओ ख अपनी नई समसान म रख दियो, जे ओ न चट्ठान म खुदावायो हतो, उ कबर म पर बड़ो पत्थर लुढ़का ख चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","मरियम मगदलीनी अर दुसरी मरियम वहाँ सामधी का सामने बैठी हुई हती। ");
INSERT INTO hlb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","दुसरो दिन पर सुक्रवार को बाद आराम दिन पर, पूजारी अर याजक हुन अर फरीसी हुन न पिलातुस ख पास एकजुट हो ख कय्हो, ");
INSERT INTO hlb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“अरे मालिक हम ख बहकान वालो न ते उ जीवित हतो, कय्हो, ‘मी तीन दिन को बाद जिन्दो हो जाऊ।’ ");
INSERT INTO hlb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","अर काहेकि तीसरो दिन तक सामधी कि देखभाल को हुकुम दियो जाहे। कही असो नी हो कि ओको चेला ओ ख चुरा ख ले जाए अर अदमी हुन से कह कि, ‘उ मरो हुयो म से जिन्दो उठो हैं।’ यू पिछला छल से ते पहले से भी बुरो होगो।” ");
INSERT INTO hlb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","पिलातुस न कय्हो, “तुमारो पास सिपाही हुन ते हैं। जा, अर जसो चोक्खो, रक्छा ख रखवाली कर।” ");
INSERT INTO hlb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","अऊर जब वी सिपाही हुन ख संग ले ख गयो, अर पत्थर पर मोहर लगा ख सामधी कि देख भाल की। ");
INSERT INTO hlb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","छुट्टी को दिन को बाद हफ्ता को पहिलो दिन भुनसारो होती ही मरियम मगदलीनी अर दुसरी मरियम सामधी ख देखन आई। ");
INSERT INTO hlb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","अर एकदम से बडो भुकम्प भयो अर प्रभु एक दूत स्वर्ग से उतरियो। उ सामधी को जोने आयो अर पत्थर लुढ़का ख ओको ऊप्पर बठ गयो। ");
INSERT INTO hlb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ओको रूप बिजली ख जसो अर ओको कपड़ा स्वर्ग दुत को जसो सफेद हतो। ");
INSERT INTO hlb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","अऊर दूत ख देख ख सिपाही हुन थर न लग गया अर मरिया जसा हो गया। ");
INSERT INTO hlb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","स्वर्गदूत न बाई हुन से कय्हो, “मत डर, म जानु हूँ कि तुम यीसु ख जो सूली पर चढ़ायो गयो हतो ढूढन हैं। ");
INSERT INTO hlb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","उ यहाँ नी हैं, उ जीवित उठ गयो हैं, जसो की उनना कय्हो हतो। आ अर उ जगह देख ले, जहाँ उ रखो गयो हतो। ");
INSERT INTO hlb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","अर जल्दी जाख ओखा चेला से कय्हो कि उ मरिया हुयो म जिन्दो उठ गयो हैं, अर उ तुम से पहले गलील ख जाय हैं, वहाँ ओ ख सपना पाहे! देख जो, म न तुम से कह दियो।” ");
INSERT INTO hlb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","अऊर ओरत जल्दी ही समसान घाट को नजीक से चली गयी अर डर अर बड़ो खुसी को संग उनका चेला हुन ख यू समाचार सुनान दऊड़ी। ");
INSERT INTO hlb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","तब यीसु उन ख मिलो। कय्हो, “नमस्कार”। उनना पास आय ख अर ओखा पाय पकड़ ख ओ ख नमस्कार कियो। ");
INSERT INTO hlb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","तब यीसु न ओ से कय्हो, “डर नी, जा अर मोरो भई हुन ख यू सन्देस दे कि वी गलील सहर ख जा, वहाँ वी मोरो सपना करे।” ");
INSERT INTO hlb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","उ जा ही रह हते कि सिपाही हुन म से कोई न सहर म आय ख पुरो बात मुखिया पुजारी हुन से कह सुनायो। ");
INSERT INTO hlb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","तब उनना सियाना हुन ख संग एक जुट हो ख सलाह विचार कियो अर सिपाही हुन ख बेजा चाँदी दे ख कय्हो, ");
INSERT INTO hlb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“अऊर लोग हुन से कहनो कि रात ख जब हम सो हुयो हतो, ते यीसु को चेला आँख ओ ख चुरा ले गयो। ");
INSERT INTO hlb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","अर यदि यी बात हाकिम ख कान पड़ गयी, ते हम उन ख समझा दे अर तुमारो लाने चिन्ता करी कोई बात नी होऐ।” ");
INSERT INTO hlb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","अब उनना पाय हुन लेख जसो सिखायो गयो हते वसो ही कियो। यी बात आज तक यहूदी हुन म प्रचलित हैं। ");
INSERT INTO hlb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ते ग्यारह चेला गलील सहर म ओ ख टेकड़ा पर गयो, जान ख यीसु न उन ख हुकुम दियो हतो। ");
INSERT INTO hlb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","अऊर उन न यीसु ख देखे, ख उनकी बड़ाई करी, परन्तु कोई कोई ख सक भी भयो। ");
INSERT INTO hlb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ते यीसु न उन ख नजीक आय ख कय्हो, “मोखा स्वर्ग म अर धरती को सारो अधिकार दियो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","एकोलाने तुम जाय ख, सब जाति हुन ख अदमी हुन ख चेला बना; अर उन ख बाप, अर पोरिया, अर सुध्द आत्मा को नाम से बपतिस्मा दे, ");
INSERT INTO hlb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","अऊर मी न तुम ख जे-जे हुकुम दियो हैं, उन ख पालन करनो उन ख सिखा। सुन, मी दुनिया को आखरी तक हमेसा तुमारो संग हूँ।”");
INSERT INTO hlb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","परमेस्वर को पोरिया, प्रभु यीसु मसी को सुभ समाचार कि सुरूवात। ");
INSERT INTO hlb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","जसो यसायाह भविस्यवक्ता को सुसमाचार म लिखो हैं: “देख, ‘मी मोरो दूत ख तोरा आगु भेजूगो, जो तोरा लाने रस्ता सिधो करेगों।’ ");
INSERT INTO hlb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","जंगल म एक हाका देन वालो की आवाज सुनाई देवा हैं, कि प्रभु को राज म जान की रस्ता; सिधी करो, अर ओकी रोट ख सिधो बनाओ।” ");
INSERT INTO hlb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","एकोलाने यूहन्ना आयो, जे जंगल म बपतिस्मा देवा, अर पाप कि छमा को लाने मन फिराव को बपतिस्मा को प्रचार करत रहा। ");
INSERT INTO hlb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","पुरो यहूदिया प्रदेस ख, अर यरूसलेम सहर ख सब रहन वाला निकल ख यूहन्ना को कने गया अर अपना पाप हुन ख मान ख यरदन नद्दी म ओसे बपतिस्मा लियो। ");
INSERT INTO hlb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","यूहन्ना ऊँट को रुआ को कपड़ा पहिनो अर अपनी कम्मर म चमडा को पट्टा लपेटो हतो रह अर हरो वालो टिड्डी हुन अर जंगल म की मोऊरस खावत करत रह। ");
INSERT INTO hlb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","अर असो प्रचार करह हैं, “यूहन्ना न इंसान हुन से कय्हो मोरो बाद उ आवन वालो हैं, जे मोसे जादा सक्तिसाली हैं; मी यु लायक नी हाय कि झुक ख ओको जूता की बददी छोड सकू। ");
INSERT INTO hlb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","मी न तो तुम ख पानी से बपतिस्मा दियो हैं पर यीसु तुम ख सुध्द आत्मा से बपतिस्मा देहे।” ");
INSERT INTO hlb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","वी दिन म प्रभु यीसु न गलील प्रदेस को नासरत नगर से आ ख यरदन नद्दी म यूहन्ना से बपतिस्मा लियो। ");
INSERT INTO hlb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","जसो ही यीसु पानी म से डुपकी लगा ख ऊपर निकलियो, ते तुरत ओ न आकास ख खुल्यो अर आत्मा ख कबूतर ख जसो अपनो ऊपर उतरते देख्यो। ");
INSERT INTO hlb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","अर असी आकास से आवाज सुनाई दी, “तु मोरो सबसे अच्छो पोरिया आय, तोसे मी बेजा खुस हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","परमेस्वर कि आत्मा न तुरत ओ ख जंगल कि तरफ भेज्यो। ");
INSERT INTO hlb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","जंगल म चालीस रोज तक सैतान न ओकी परीक्छा लियो; अर उ जंगल ख जानवर हुन ख संग रयो; अर स्वर्ग दूत ओकी सेवा करत रह। ");
INSERT INTO hlb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","यूहन्ना का पकड ख जेल खाना म ड़ाल दियो जानु को बाद प्रभु यीसु न गलील प्रदेस म आका परमेस्वर को राज को सुभ समाचार को प्रचार सुनायो, ");
INSERT INTO hlb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","अर कय्हो, “बखत पुरो भयो, अर परमेस्वर को राज्य नजीक आ गयो हैं; बुरा काम हुन से मन फिराव अर सुसमाचार पर भरोसा करो।” ");
INSERT INTO hlb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","गलील कि झील को किनारा-किनारा जाती बखत, ओ न समोन अर ओको भई अन्द्रियास ख झील म जाल डालते देखो; काहेकि वी ढ़िमर हता। ");
INSERT INTO hlb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","प्रभु यीसु न ओसे कय्हो, “मोरा पिछु आव; मी तुम ख मच्छी पकडन की जगा म अदमी हुन ख परमेस्वर को राज म लावन वालो बनाऊँगो।” ");
INSERT INTO hlb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","वी तुरत जाल हुन ख छोड़ ख ओको पीछु चल्या गया। ");
INSERT INTO hlb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","थोडो आगे बढ़ ख, यीसु न जबदी को पोरिया याकूब, अर ओको भई यूहन्ना ख नाव पर जाल हुन ख सुधारते देख्यो। ");
INSERT INTO hlb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ओ न तुरत उनका बुलायो; अर वी अपनो बाप जबदी ख मजदूर हुन को संग नाव म छोड़ ख, यीसु को पीछु जान लग गया। ");
INSERT INTO hlb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","तब वी कफरनहूम नगर म आया, अर उ तुरत छुट्टी करन को दिन प्रार्थना घर म जाय ख सिक्छा देन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","एकोलाने इंसान ओको बतानु से भय चक्का हो गया; काहेकि उ उनका सासतिरी हुन को जसो नी, पर अधिकारी को जसो सिक्छा देत रह। ");
INSERT INTO hlb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","उत्ती बखत, उनको प्रार्थना घर म एक अदमी आयो हतो, जेमा एक बुरी आत्मा समायो हतो रह। ");
INSERT INTO hlb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ओ न चिल्लाया ख कय्हो, “अरे यीसु नासरी, हमका तोरो से का काम? का तू हमका नास करन आयो हैं? मी तोखा जानु हैं, तू कोन आय? परमेस्वर को सुध्द जन!” ");
INSERT INTO hlb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","प्रभु यीसु न ओखा डाँट ख कय्हो, “चुप रहो; अर ओमा से निकल जा।” ");
INSERT INTO hlb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","तब भूत कि बुरी आत्मा ओखा मरोड़त ख, अर बडी जोर से चिल्लाया ख ओमा से निकल गई। ");
INSERT INTO hlb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ये पर सबरा जन हाईब कर ख एक दुसरो से बहस करन (वाद विवाद) लग गया, “या कसी बात हैं? यु तो कोई नयो सिखावा हैं! उ हक को संग बुरी आत्मा ख भी कहा हैं, अर वी ओकी बात ख माना हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","अर ओको नाम को बारे म तुरत गलील को आजू-बाजू सीवाना पुरो सी नाम फैल गयो। ");
INSERT INTO hlb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","जसो ही उ तुरत प्रार्थना घर म से निकल ख, याकूब अर यूहन्ना को संग समोन अर अन्द्रियास को घर ख आयो। ");
INSERT INTO hlb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","समोन की सास जुड़ म पड़ी हती, अर उन न तुरत ओको बारे म यीसु ख बतायो। ");
INSERT INTO hlb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","तब ओको जोने म जाका ओको हात पकड़ ख ओखा उठायो; अर ओको जुड़ उतर गयो, अर वा उनकी सेवा-चाकरी करन लग गई। ");
INSERT INTO hlb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","संझा कि घड़ी जब दिन डुब गयो ते अदमी सबरा बीमार हुन ख अर, उनका जिनमा भूत हुन (दुस्टात्मा) समाया हता रह यीसु को कने लाया। ");
INSERT INTO hlb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","अर पुरा नगर ख सबरा अदमी उ दुवार को सामे जुढ़ गया। ");
INSERT INTO hlb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ओ न बेजा सारा ख जे हर एक तरीका की बिमारी से दुखी हता, अच्छो करयो, बेजा सारी दुस्टात्मा ख निकालो, अर भूत हुन ख बोलन नी दियो, काहेकि वी ओखा जानत रह। ");
INSERT INTO hlb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","भुनसारो ख दिन नीकलनु से बेजा पहले, यीसु उठका निकलो, अर एक जंगल वाली जगह म गया अर बिनती करन लगो। ");
INSERT INTO hlb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","फिर समोन अर ओखा संग म रहन वाला यीसु ख ढु़ढ़न गया। ");
INSERT INTO hlb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","जब उ मिलो, ते यीसु से कय्हो, “सबरा झन तोखा ढु़ढ़ा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","यीसु न उनसे कय्हो, “आव अपुन अऊर कही आजू बाजू कि बसती म जाहे, कि मी ओमा भी प्रचार करू, काहेकि मी एको लाने निकल्यो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ओको बाद यीसु पुरो गलील म उनको प्रार्थना घर हुन म जा-जा ख प्रचार करत रह अर दुस्टात्मा ख निकालते रहयो। ");
INSERT INTO hlb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","एक कोढ वालो इंसान ओको कने आयो, ओको सामे विनती करी, अर ओको सामे टोगरिया टेक ख ओसे कय्हो, “अदि तू चाहे ते मोखा सुध्द कर सका हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ओ न ओपर तरस खा का हात बढ़ायो, अर ओखा छीका कय्हो, “मी चाहूँ हैं तू सुध्द हो जा।” ");
INSERT INTO hlb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","अर तुरत ओको कोढ चल दियो, अर उ सुध्द हो गयो ");
INSERT INTO hlb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","फिर यीसु न ओखा जता ख ओखा तुरत बिदा करयो, ");
INSERT INTO hlb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","अर ओसे कय्हो, “देख, कोई से कुछ मत कहजो, पर जा ख अपनो तुम ख याजक ख बता, अपनो सुध्द होन को बारे म जो कुछ मूसा न ठहरायो हैं ओखा भेट चढ़ा कि उन पर भी गवाई होए।” ");
INSERT INTO hlb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","पर उ बाहर जा ख या बात का बेजा प्रचार करन लग गयो अर असो तक फैलान लग गयो कि यीसु फिर अकेलो सहर म नी जा पायो पर बाहर जंगल वाली जगा म रहयो अर चारी तरफ से अदमी ओको कने आवत रह। ");
INSERT INTO hlb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","कई दिन को बाद यीसु फिर कफरनहूम नगर (सहर) म आयो, अर इंसान हुन ख मालुम भयो कि उ घर ख आयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","फिर इत्ता झन इक्टा भया कि दुवार को जोने जगा नी हती; अर उ उनका परमेस्वर को बारे म सुसमाचार बतान लग गयो। ");
INSERT INTO hlb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","अर अदमी एक लकवा को बीमार ख चार अदमी हुन से उठा ख यीसु को जोने लेखा आया।, ");
INSERT INTO hlb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","पर वी जब भीड़ को मारे ओको नजीक नी पहुँच पाया, ते उन न उ घर को खपरा हटाका जोको नीचु यीसु हतो, उन न उधेड दियो; अर जब उन न ओखा उधेड दियो, ते वा खटिया ख जेमा लकवा को बीमार पड़ो हतो, लटका दियो ");
INSERT INTO hlb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","प्रभु यीसु न उनको भरोसा देख ख उ लकवा को बीमार से कय्हो, “पोरिया, तोरा पाप माप हो गया।” ");
INSERT INTO hlb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ओको बाद कई नेम का गुरू सासतिरी जे वहाँ बठिया हता, अपनो-अपनो मन म विचार करन लग गया, ");
INSERT INTO hlb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“यु अदमी असो काहे ख बोल्यो? यु तो परमेस्वर की बेज्जती करा हैं! परमेस्वर को अलावा अऊर कोन पाप माप कर सका हैं?” ");
INSERT INTO hlb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","प्रभु यीसु न तुरत अपनो मन म परख लियो कि वी अपनो-अपनो मन म असो विचार काहे सोच रया हैं, ");
INSERT INTO hlb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","सहज का हैं? का लकवा को बीमार से यू कहनू कि तोरा पाप माप भया, या कि असो कहनू कि उठ अपनी खटिया उठा ख घूम फिर? ");
INSERT INTO hlb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","पर जसो तुम जान लेहे कि इंसान को पोरिया ख दुनिया म पाप माप करन को भी हक हैं। ओ ना उ लकवा को बीमार से कय्हो, ");
INSERT INTO hlb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“मी तो से कहू हैं, उठ अपनी खटिया उठा ख अपनो घर चलो जा।” ");
INSERT INTO hlb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","उ तुरत उठियो अर खटिया उठा ख सबको सामे से निकल ख चल दियो; यु देख ख सब दंग रह गया, अर परमेस्वर कि बड़ाई कर ख कहन लग गया, “हम न असो कभी नी देखो।” ");
INSERT INTO hlb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","यीसु गलीली की झील को किनार म फिर से गयो, अर पुरी भीड़ ओको कने आई, अर यीसु उनका सिक्छा देन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","जाती बखत यीसु न हलफई को पोरिया लेवी ख कर घर कि कुर्सी पर (चुंगी कि चऊकी) बठियो देखो, अर ओसे कय्हो, “मोरो पीछु हो ला।” अर उ उठ ख ओको पीछु हो लियो। ");
INSERT INTO hlb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","जब यीसु लेवी को घर म खाना खान गयो, ते बेजा सारा कर लेन वालो अर पापी, प्रभु यीसु अर ओखा चेला हन को संग खाना खान बठियो; काहेकि वी बेजा झन हता, अर ओको पीछु हो लियो हता। ");
INSERT INTO hlb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","सासतिरी हुन अर फरीसी हुन न यु देख ख कि उ तो पापी हुन अर कर लेन वालो को संग खाना खा रहयो हैं, ओखा चेला हुन से कय्हो, “उ तो कर वसुल करन वाला अर पापी हुन को संग खावा पीवा हैं!” उ असा अदमी हुन को संग काहे खावा पीवा हैं, यु असो काहे करा हैं? ");
INSERT INTO hlb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","प्रभु यीसु न आसो सुन कर उनसे कय्हो, “अच्छो भलो ख वैध की जरूरत नी हाय, पर जेका जुड़ आवा हैं ओको लाने हैं। मी धर्मी हुन ख नी पर पापी हुन ख बुलान आयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","यूहन्ना को चेला, अर फरीसी उपास करत रह हता; ते उन न आका यीसु से आसो कय्हो, “यूहन्ना ख चेला अर फरीसी हुन ख चेला काहे उपास करा हैं, पर तोरा चेला हुन काहे उपास नी करा हैं,” ");
INSERT INTO hlb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","प्रभु यीसु न उन ख कय्हो, जब तक दुला बरात को संग म हैं, का वी उपास कर सका हैं? अत: जब तक दुला बराती हुन को संग म नी रहवा हैं; तब तक वी उपास कर सका हैं? एको मतलब जब तक दुला उनको संग म हैं। तब तक वी बराती हुन उपास नी कर सका। ");
INSERT INTO hlb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","पर वी दिन आहे जीनमा दुला उनको बीच से अलग करो जाहेगो उत्ती बखत वी उपास करे। ");
INSERT INTO hlb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“कोरो कपड़ा को थेगड़ा जुन्नो कपड़ा म कोई नी लगावा; नी ते उ थेगड़ा उनमा से कुछ खीच लेहे, येको मतलब नयो, जुन्नो से अर उ पहलो से जादा फट जाहेगो। ");
INSERT INTO hlb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","नयो अंगूर को रस ख पुरानो चमडा को झोला म कोई नी रखा, नी ते अंगूर को रस चमडा को झोला ख फाड़ दे हे, अर अंगूर को रस अर चमडा को झोला दोई बेकार हो जाहे; पर नयो अंगूर को रस नयो चमडा को झोला म भरो जावा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","असो भयो कि उ छुट्टी करन को दिन गहूँ को खेत को किनार म से होका जात रह हतो, अर ओखा चेला चलती बखत गहूँ की बाली टोड़ टोड़ ख दाना खान लग गया। ");
INSERT INTO hlb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","तब फरीसी हुन न ओसे कय्हो “देख; यी छुट्टी करन को दिन तोरा चेला उ काम काहे करा हैं जो उचित नी हाय?” जो हमारो नेम को हिसाब से नी हाय। ");
INSERT INTO hlb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ओ न उनसे कय्हो, का तुमना यू कभी नी पढियो कि जब दाऊद ख जरूरत पड़ी, अर जब उ अर ओखा संग म रहन वाला भूका हता, तब ओ न कसो करियो हतो रह? ");
INSERT INTO hlb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ओ न कसो अबियातार बड़ो पूजारी (याजक) को बखत म, “परमेस्वर को घर म जा ख भेंट कि रोती संगी हुन को संग खायो, जोका खानु पुजारी हुन का छोड़ अर कोई ख भी लाने ठीक नी हाय, अर ओ न अपना संग वाला ख भी दियो?” ");
INSERT INTO hlb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","तब यीसु न उनसे कय्हो, छुट्टी करन को दिन अदमी हुन ख लाने बनायो गयो हैं न कि अदमी आराम करन को दिन ख लाने। ");
INSERT INTO hlb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","येखा लाने इंसान को पोरिया छुट्टी करन को दिन को भी प्रभु (स्वामी) हैं। ");
INSERT INTO hlb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","जब फिर यीसु प्रार्थना घर म गयो; वहा एक अदमी हतो जेको हात सुख गयो हतो, ");
INSERT INTO hlb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","अर कुछ फरीसी यीसु पर आरोप लगान ख लाने ओकी ताक म लग्या हता कि देखे, यीसु छुट्टी करन को दिन लकवा को बीमार ख चोक्खो करा हैं की नी। ");
INSERT INTO hlb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","यीसु न सुखो हात वालो अदमी ख बोल्यो, “बीच म खड़ो हो। ");
INSERT INTO hlb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","अर यीसु न कय्हो, का छुट्टी करन को दिन भलो करनो अच्छो हैं या बुरो करनु, जान ख बचानो या मारनो?” पर वी चुप रया। ");
INSERT INTO hlb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ओ न उनको मन को ढ़िट पन की कठोरता को लाने नराज होका, उनका गुस्सा से चारी तरफ देख्यो, अर उ अदमी से कय्हो, “अपनो हात आगे कर।” ओ न आगे बढ़ायो, अर ओको हात चोक्खो हो गयो ");
INSERT INTO hlb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","तब फरीसी बाहर जा ख तुरत हेरोदियो को संग म यीसु कि दुसमनी को बारे म सला-मसुरा करन लग गया कि ओखा कसो तरीका से खतम करे ");
INSERT INTO hlb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","प्रभु यीसु अपना चेला हुन ख संग झील कि तरफ चल दियो: अर गलील से एक बड़ी भीड़ ओको पिछु हो ली; ");
INSERT INTO hlb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","अर यहूदिया, अर यरूसलेम, अर इदूमिया अर यरदन को ओ नोपार, अर सूर अर सैदा को सिवाना से एक बड़ी जात भीड़ यु सुन ख कि उ कसो अचम्भा को काम करा हैं, ओको कने आई ");
INSERT INTO hlb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ओ न अपना चेला ख कय्हो, “भीड़ को लाने एक छोटी नाव मोरो लाने तैयार रखो ताकि वी मोखा दबान ख नी” ");
INSERT INTO hlb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","काहेकि ओ न बेजा ख चोक्खो करी रह, येका लाने जित्ता झन बिमारी रोग म हता, ओखा छिवन ख लाने इंसान हुन पर गिरत-पड़त रह ");
INSERT INTO hlb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","बुरी आत्मा भी, जब ओखा देखत रह, ते यीसु को सामे गीड़त-पड़त रह अर चिल्लाया ख कहत रह कि तू परमेस्वर को पोरिया आय। ");
INSERT INTO hlb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","अर ओ ना उनका बेजा जतायो कि मोखा उजागर मत करनु। ");
INSERT INTO hlb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","फिर उ पहाड़ पर चेंग गयो अर जीन ख यीसु चाहवत रह उनका अपनो सामने बुलायो, अर वी ओखा कने आया ");
INSERT INTO hlb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","तब ओ न बारा प्रेरित हन ख चुनियो कि वी ओको संग-संग म रहे अर उ उन ख भेजे की वी सबरा ख प्रचार सुनाया, ");
INSERT INTO hlb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","अर दुस्टात्मा ख निकालन को हक रखे ");
INSERT INTO hlb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","वी यी आय: समोन जो को नाम ओ न पतरस रखो, ");
INSERT INTO hlb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","अर जबदी को पोरिया याकूब अर याकूब को भई यूहन्ना, जेको नाम ओ न बुअनरगिस ये को मतलब गरजन को पोरिया रखो ");
INSERT INTO hlb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","अर अन्द्रियास, अर फिलिप्पुस, अर बरतुल्मै, अर मत्ती, अर थोमा, अर हलफई को पोरिया याकूब, अर तद्दै, अर समोन कनानी, ");
INSERT INTO hlb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","अर यहूदा इस्करियोती जो न ओखा पकड़ा भी दियो रह। ");
INSERT INTO hlb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ये ख बाद म यीसु घर ख आयो, अर इत्ता सारा झन जुडिया कि वी रोटी नी खा सक्या ");
INSERT INTO hlb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","जब ओखा कुटुम्ब ख न असो सुनियो, ते वी ओखा पकड़न ख लाने निकलियो, काहेकि वी बोलत रह, ओको दिमाक ठिकाना म नी हाय ");
INSERT INTO hlb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","सासतिरी भी जब यरूसलेम से आया हता, असा कहत रहा, “ओमा बालजबूल भूत हैं,” अर “उ भूत हुन को मुखिया बाल जबुल की मदत से भूत हुन ख निकला हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","येका लाने यीसु उनका नजीक म बुला ख उनसे उदाहरन हन म बोलन लग गयो, सैतान कसो सैतान का निकाल सका हैं? ");
INSERT INTO hlb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","अदि कोई राज्य म लड़ाई चले ते उ राज्य कसो बसो रह सका हैं? ");
INSERT INTO hlb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","अर कोई को घर म लड़ाई हो जाय, ते उ घर कसो बसो रहे? ");
INSERT INTO hlb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","येका लाने अदि सैतान अपनो ही बैरी होका अपनो म लड़ाई करे, ते उ कसो चोक्खो से रह सका हैं? ओको तो नास ही होनो भलो हैं। ");
INSERT INTO hlb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","पर कोई इंसान कोई बलवान को घर म घुस ख वहाँ को माल नी लूट सका, जब तक कि उ पहले उ बलवान ख बाँध नी लेन को, अर जब उ बाँध लेहे तब ओको घर को माल लूट लेहे। ");
INSERT INTO hlb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“मी तुम से सच म कहूँ हैं कि इंसान की अवलाद ख सब पाप अर बुराई जे वी करत हैं छमा करी जाहे, ");
INSERT INTO hlb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","पर जो कोई सुध्द आत्मा को बारे म बुराई करे, ओको कभी भी छमा नी करो जाहे: पर उ अनन्त पाप ख भोगन वालो पापी ठहरेगो।” ");
INSERT INTO hlb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","काहेकि वी असा बोलत रह की ओमन भूत प्रेत (बुरी आत्मा) समायो हैं, ");
INSERT INTO hlb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","तब यीसु की माय अर ओको भई आया, अर बहार खड़ा होका ओ ख बुलान भेज्यो। ");
INSERT INTO hlb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","भीड़ ओको आजू बाजू बठी हती, अर उन न ओसे कय्हो, “देख, तोरी माय अर तोरा भई बहिन तोखा बुलावा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","यीसु न उनका जवाब दियो, “मोरी माय अर मोरा भई कोन आय?” ");
INSERT INTO hlb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","अर उन को पर जो ओको आजू बाजू बठिया हता, नजर उठा ख कय्हो, सुनो मोरी माय अर मोरा भई यी आय, ");
INSERT INTO hlb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","काहेकि जे कोइ परमेस्वर कि मरजी पर चले, “देखनु वीइच मोरा भई अर बहिन अर माय आय।” ");
INSERT INTO hlb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","यीसु फिर झील को किनार म समझान लग गयो; अर असी बड़ी जात भीड़ ओको सामे जुड़ गई कि उ झील म एक नाव पर जा ख बठ गयो, अर पुरी भीड़ जमीन म झील को किनार म खड़ी राई ");
INSERT INTO hlb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","अर उ उनका उदाहरन देख ढ़ेर सारी बात सिखान लग गयो, अर अपनो समझानो म उनसे कय्हो, ");
INSERT INTO hlb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","सुनो! एक बोन वालो बीज बोन निकलो। ");
INSERT INTO hlb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","बोन की बखत कोई रस्ता को किनार म गिड़िया अर चिड़िया हुन न आका ओखा चुग लियो ");
INSERT INTO hlb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","कुछ पत्थर वाली जमीन म गिड़िया जेमा ओखा ज्यादा मिठ्टी नी मिली, अर ज्यादा मिठ्टी नी मीलन को लाने जल्दी उग गयो ");
INSERT INTO hlb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","अर जब घाम निकली ते छोटो पऊधा मुर्झा गयो अर जड़ नी पकड़न को लाने सूख गयो ");
INSERT INTO hlb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","अर कुछ झाड़ी म गिड़ो अर झाड़ी न बढ़ ख ओखा दबा दियो अर ओ म फल नी लगीयो ");
INSERT INTO hlb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","पर कुछ अच्छी जमीन म गीढियो अर उ उगीयो अर ओ ना बढ़ ख फल लायो अर कोई तीस गुना, कोई साठ गुना, अर कोई सव गुना फल लायो ");
INSERT INTO hlb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","तब यीसु न कय्हो, “जोको पास सुनन ख कान होए वी ध्यान से सुननू लेहे।” ");
INSERT INTO hlb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","जब यीसु अकेलो रह गयो ते ओखा संगी न वी बारा समेत ओसे यू उदाहरन को बारे म पुछियो। ");
INSERT INTO hlb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","यीसु न उनसे कय्हो, तुम ख तो परमेस्वर को राज को भेद समझन कि समझ दियो गयो हैं।, पर बाहर वाला, ख लाने सबरी बात उदाहरन म हैं, ");
INSERT INTO hlb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","येका लाने कि, “वी देखनु पर भी देखे, अर सुननू पर सुने भी अर नी समझा; असो नी होय कि वी लउटे अर पाप माप करा जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","फिर यीसु न उनका कय्हो, “का तुम यू उदाहरन को बारे म नी समझीया? ते फिर अऊर उदाहरन ख कसा समझे? ");
INSERT INTO hlb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","बोन वालो वचन (परमेस्वर को वचन) बोवा हैं, ");
INSERT INTO hlb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","जो रस्ता को किनार ख हैं, जे न परमेस्वर को बारे म सुनियो हैं, यी वी आय कि जब उन न सुनियो, ते भुत (सैतान) न आका वचन ख उनका जो बतायो रह, ओसे बहका दियो ");
INSERT INTO hlb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","वसो ही जो पत्थर वाली जमीन म बोयो गयो हैं, यी वी आय जो वचन ख सुन ख जल्दी से खुस होका मान लेवा ");
INSERT INTO hlb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","पर उन न अपनो भीतर म जड़ नी पकड़न ख लाने वी कुछ दिन ख लाने होवा हैं, एको बाद जब वचन को कारन उनका दुख अर सताव होवा हैं, ते वी तुरत ठोकर खावा हैं, ");
INSERT INTO hlb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","जो झाड़ी म बोया गया हैं वी यी आय जिन्ना वचन सुनियो ");
INSERT INTO hlb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","अर दुनिया भर की चिन्ता अर धन को धोका, अर बेजा सारी चीज को लोभ उनमा समा ख परमेस्वर को वचन ख दबावा अर उ परेसान हो जावा हैं, ");
INSERT INTO hlb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","अर जो अच्छी जमीन म बोया गया हैं, यी वी आय जो वचन ख सुन ख मान लेवा अर फर लावा हैं: कोई तीस गुना, कोई साठ गुना अर कोई सव गुना।” ");
INSERT INTO hlb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","यीसु न उनका कय्हो, “का दिया ख एको लाने लावा हैं कि दिया ठानी अर खाट को नीचु रखो जाय? का एको लाने नी कि दिया ठानी म रखो जाहे? ");
INSERT INTO hlb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","काहेकि कोइ चीज लुकि नी हाय पर एको लाने कि सब दिखे, अर कुछ नी लुकि रहे, पर ऐको लाने की सब दिखे, ");
INSERT INTO hlb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","कोई का सुनन को कान होये ते वी सुन लेहे, ");
INSERT INTO hlb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ऐका बाद यीसु न उनका कय्हो ध्यान से सुननो कि का सुना हैं। जे नाप से तुम नापा हैं उयी नाप से तुमरो लाने भी नापो जाहे अर ओसे भी जादा दियो जाहेगो। ");
INSERT INTO hlb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","काहेकि जोको पास म हैं, ओखा दियो जाहे; अर जोको पास म नी हाय, ओसे उ भी जो ओको पास म हैं ले लियो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","फिर यीसु न कय्हो, “परमेस्वर को राज असो हैं जसो कोइ अदमी अपनी जमीन म बीज बोवा हैं, ");
INSERT INTO hlb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","अर रात ख सोयो अर दिन म जागियो अर उ बीज असो बढ़न लगीयो कि उ नी जाना। ");
INSERT INTO hlb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","जमीन खुद अपनो तुम म बड़ावा अर फल लावा हैं, पहलो कोम फिर बाल, अर फिर बाली म तैयार दाना। ");
INSERT INTO hlb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","पर जब फसल पक जावा हैं, ते उ तुरत दराती लगावा हैं, काहेकि कटनी आ गई हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","फिर यीसु न कय्हो, “हम परमेस्वर को राज को बारे म कसो बताहे, अर कोन सो उदाहरन से ओको बारे म बताहे? ");
INSERT INTO hlb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","उ राई को दाना को जसो हैं: जब उ जमीन म बोयो जावा हैं ते जमीन कि सब चीज से छोटो होवा हैं, ");
INSERT INTO hlb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","पर जब बोयो गयो, ते उ उग ख सब हरी-सब्जी से बडो झाड़ हो जावा हैं, अर ओकी असी बडी डगियान हुन निकला हैं कि आकास चिड़िया ओकी छाय म बसेरा कर सका हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","यीसु उनका असा का बेजा सारा उदाहरन देका उनकी समझ को अनुसार वचन परचार करत रह, ");
INSERT INTO hlb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","अर बिना उदाहरन को उनका कुछ भी नी बतात रह; पर अकेलो म अपनो बनाया चेला हुन ख सब बात हुन समझात रह। ");
INSERT INTO hlb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","उयी दिन जब साम भई, ते यीसु न चेला हुन का कय्हो, “आव अपुन झील को ओ नो पार चलेहे।” ");
INSERT INTO hlb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","अर वी भीड़ ख छोड का जसो वाहा हतो रह, वसो ही यीसु ख नाव पर ले गयो; अर ओको संग म अऊर भी नाव हती रह। ");
INSERT INTO hlb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","एकदम बड़ी जऊर से हवा चलन लग गई अर पानी की लहर यहाँ तक चलत रह कि नाव पानी से भरन लग गई। ");
INSERT INTO hlb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","पर यीसु खुद पिछु को भाग म सिरानी धर ख सोते रह। तब उनना यीसु का जगा ख ओसे कय्हो, “अरे प्रभु का तोखा हमरी चिन्ता नी हाय कि हम मरन पा हैं?” ");
INSERT INTO hlb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","तब यीसु न उठका आँधी ख डांटियो, अर पानी से कय्हो “सान्त रह, रुक जा!” अर हवा रुक गई अर बड़ो चैन आयो; ");
INSERT INTO hlb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","अर यीसु न उनका कय्हो, “तुम काहे ख डरा हैं? का तुमका अबा तक भरोसा नी हाय?” ");
INSERT INTO hlb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","वी बेजा डर गया अर आपस म बोलन लग गया, “यू कऊन आय कि तुफान अर पानी भी ओको कहना माना हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","यीसु जब झील को ओ नो पार गिरासेनी हुन को देस म पहुँचियो ");
INSERT INTO hlb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","जब उ नाव पर से उतरो ते तुरत एक इंसान जेमा बुरी आत्मा लगयो हतो रह, मरघट की गुफा म से निकल ख ओसे मिलियो। ");
INSERT INTO hlb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","उ मरघट म रहत रह हतो अर कोइ ओ ख साँकल हुन से भी नी बाँध सकत रह, ");
INSERT INTO hlb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","काहेकि उ बार-बार बेडी हुन अर साँकल हुन से बाँधी गयो रह, पर ओ न साँकल हुन ख टोड़ दियो अर बेडी हुन को टुकड़ा-टुकड़ा कर दियो हतो, अर कोई भी इंसान ओखा बस म नी कर सकत रह काहेकि उ बेजा सक्तिसाली हतो। ");
INSERT INTO hlb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","उ लगातार रात दिन मरघट अर पहाड़ हुन म चिल्लावा अर खुद ख पत्थर हुन से मारते जात रह अपनो आँग म खत्ता-गुम्मा उठात रह। ");
INSERT INTO hlb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","उ यीसु ख दुर से देख ख दऊडियो, ओको सामने आका पाय मोढ़ ख झूक गयो, ");
INSERT INTO hlb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","अर बड़ी जोर से चिल्ला ख कय्हो, “अरे यीसु, परमप्रधान परमेस्वर को पोरिया, मोखा तोसे का काम? मी तोखा परमेस्वर कि कसम देऊ हैं कि मोखा दुख मत देवा।” ");
INSERT INTO hlb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","काहेकि यीसु न ओसे कय्हो रह, “अरे बुरी आत्मा कि आत्मा, यू अदमी म से निकल ख आ!” ");
INSERT INTO hlb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","यीसु न ओसे पुछियो, “तोरो का नाम हैं?” ओ न ओसे कय्हो, “मोरो नाम सेना हैं; काहेकि हम बेजा सारा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","अर ओ न ओसे बेजा विनती करी, कि “हमका यू सिवाना से बाहर मत भेजा।” ");
INSERT INTO hlb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","वहाँ टेकड़ी कि उतार हती वहाँ पर डुक्कर को एक झुण्ड चरत रह हतो। ");
INSERT INTO hlb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","भुत कि आत्मा न यीसु से विनती कर ख कय्हो, “हम ख वी डुक्कर हुन म भेज दा कि हम उनको भीतर जाए।” ");
INSERT INTO hlb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ओको बाद यीसु न कय्हो अर बुरी आत्मा न ओकी बात मान लियो अर निकल ख डुक्कर हुन को भीतर समा गई अर झुण्ड, जे कोई दो हजार को हतो रह, कड़ाडे म से दऊड ख झील म गिडियो अर ड़ुब मरियो। ");
INSERT INTO hlb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","उनका चरान वाला न दऊड ख नगर अर गाँव हुन म खबर सुनायो, अर जो भयो रह अदमी हुन ओखा देखन आया। ");
INSERT INTO hlb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","यीसु को कने आ ख वी ओखा जेमा भूत हुन समाया हता, एको मतलब जिनमा सेना समाई हती रह, कपड़ा पहिनिया अर चुप चाप बैठियो देख ख ढ़ेर पुरा झन डर गया। ");
INSERT INTO hlb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","देखन वाला हुन न ओको, जेमा भूत हुन समायो हतो, अर डुक्कर हुन को बारे म उनका पुरो हाल कैय ख सुनायो। ");
INSERT INTO hlb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","तब वी ओखा विनती कर ख बोलन लगीया कि हमारो सिवाना से चलो जा। ");
INSERT INTO hlb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","जब यीसु नाव पर चड़न लग गयो ते उ जेमा पहले भूत हुन समायो हतो रह, ओखा विनती करन लग गयो, “मोखा तोरो संग म रहन दा।” ");
INSERT INTO hlb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","पर यीसु न मना करो, अर ओसे कय्हो, “अपनो घर म जा ख अपना माय बाप ख बता की तोपर दया कर ख प्रभु न तोरो लाने कसो बड़ो काम करियो।” ");
INSERT INTO hlb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","उ जा ख दिकापुलिस म या मान्दी ख प्रचार करन लग गयो कि यीसु न मोरो लाने कसो बड़ो काम करियो; अर सब अदमी हाईब करत रह। ");
INSERT INTO hlb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","जब यीसु फिर नाव से ओनो पार गयो, ते एक बड़ी भीड़ ओको कने जुड़ गई। जब उ झील को किनारा ही म हतो कि ");
INSERT INTO hlb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","याईर नाम को प्रार्थना घर को मुखिया हुन म से एक आयो, अर ओखा देख ख ओको पाय हुन को पास म गिड़ियो, ");
INSERT INTO hlb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","अर असो बोल ख ओखा बेजा विनती करी, “की मोरी छोटी पोरी मरन पर हैं: तू आका ओपर हात धर कि वा अच्छी होका जिन्दा रहे।” ");
INSERT INTO hlb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","तब यीसु ओको संग गयो; अर बड़ी भीड़ ओको पिछु जान लग गई, यहाँ तक कि इंसान ओ पर गिड़त रह। ");
INSERT INTO hlb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","एक बाई हती, जेका बारा साल से खून बहिन को रोग हतो। ");
INSERT INTO hlb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ओ न बेजा वैध हुन से बेजा ज्यादा दुख उठायो, अर अपनो सब माल खर्च करनो पर भी ओखा कुछ फायदा नी भयो, पर अऊर भी जादा बिमार हो गई हती ");
INSERT INTO hlb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","वा यीसु को बारे म सुन ख भीड़ म ओको पिछु से आई अर ओको कपड़ा ख छी लियो, ");
INSERT INTO hlb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","काहेकि वा बोलत रह, “अदि मी ओको कपड़ा हीका छी लेहूँ, ते अच्छी हो जाहूँ।” ");
INSERT INTO hlb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","अर तुरत ओको खुन बगरनो बन्द हो गयो, अर ओ न अपनो सरीर म जान लियो कि मी या बीमारी से अच्छी हो गई हैं। ");
INSERT INTO hlb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","यीसु न तुरत अपनो मन म जान लियो कि मोरो म से सक्ति निकली हैं, अर भीड़ म पिछु घुम का पुछियो, “मोरो कपड़ा कोना छियो?” ");
INSERT INTO hlb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","यीसु ख चेला हुन न ओसे कय्हो, “तू देखा हैं कि भीड़ तोपर गिडा-पडा हैं, अर तू बोला हैं, कि कोना मोखा छियो?” ");
INSERT INTO hlb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","तब यीसु न ओखा देखन को लाने जेना यू काम करियो रह, चारी तरफ नजर घुमायो ");
INSERT INTO hlb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","तब वा बाई असी समझ ख कि मोरी कसी भलाई भई हैं, डरते अर कापते अई, अर ओको पाय हुन पर गिढ ख ओ ख सब हाल सच्ची-सच्ची बता दियो ");
INSERT INTO hlb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","यीसु न ओसे कय्हो, “बेटी तोरो भरोसा न तोखा चोक्खो कर दियो हैं: सान्ति से जा, अर अपनी या बीमारी से बची रैय जे।” ");
INSERT INTO hlb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","यीसु यू कहत रह कि प्रार्थना घर को मुखिया को घर म से अदमी हुन न आका बोल्यो, “तोरी बेटी तो मर गई, अब गुरू ख काहे दुख दे रयो हैं?” ");
INSERT INTO hlb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","जो बात वी बोलत रह, ओखा यीसु न अनसुनी कर ख, प्रार्थना घर को मुखिया से कय्हो, “मत डरा; सिर्फ भरोसा रख।” ");
INSERT INTO hlb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","अर यीसु न पतरस अर याकूब अर ओको भई यूहन्ना ख छोड़, अर कोई ख अपनो संग म नी आन दियो। ");
INSERT INTO hlb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","प्रार्थना घर को मुखिया को घर म पहुँच ख, यीसु न अदमी हुन ख बेजा रोते अर चिल्लाते देखो। ");
INSERT INTO hlb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","तब यीसु न भीतर जा ख देख ख उनसे कय्हो, “तुम काहे दुख मनावा अर रोवा हैं? पोरी मरी नी हाय पर सोवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","अदमी हुन न ओकी हँसी उड़ायो, पर ओ न सबका निकाल ख पोरी को माय-बाप अर अपनो चेला हुन को संग भीतर, जहाँ पोरी हती रह, गयो। ");
INSERT INTO hlb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","अर पोरी को हात पकड़ ख ओसे बोल्यो, “हे तलीता कूमी!” जोको मतलब हैं “पोरी मी तोसे बोलू हैं, उठ!” ");
INSERT INTO hlb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","अर पोरी तुरत उठका चलन फिरन लग गई; काहेकि वा बारा साल कि हती। असो देखनो पर अदमी हुन बेजा चकित भया। ");
INSERT INTO hlb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","फिर यीसु न उनका जता ख आदेस दियो कि या बाद कोई ख पता नी होनू चाहिए अर कय्हो, “येका कुछ खान ख देव।” ");
INSERT INTO hlb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","वहा से निकल ख यीसु अपनो गाँव नासरत, म आयो; अर ओ ख चेला भी ओको पीछु चल दिया ");
INSERT INTO hlb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","आराम करन को दिन यीसु प्रार्थना घर म सिक्छा देन लग गयो, अर बेजा सारा झन चकित भया अर कहन लग गया, येका या बात कहा से आवा हैं? यु कोन सो ग्यान आय जो ओखा दियो गयो हैं? कसा सक्ति को काम एको हात हुन से होते जावा हैं? ");
INSERT INTO hlb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","का उ लकड़ी को काम करन वालो (बड़ाई) को पोरिया नी आय जो मरियम को पोरिया अर याकूब अर योसेस, यहूदा अर समोन को भई आय? का ओकी बहिन हमारो बीच म नी रहत आय, एकोलाने खातिर उन न ओको बारे म ठोकर खायो; ");
INSERT INTO hlb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","यीसु न उनका कय्हो; “भविस्य जानन वालो (भविस्यवक्ता) ख अपनो देस अर अपनो कुटुम्ब ख अर अपनो घर ख छोड़ अर कही पर भी बेज्जती नी होवा।” ");
INSERT INTO hlb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","यीसु वहा सक्ति को काम नी कर पायो, लेकिन थोड़ा सा बीमार पर हात रख ख उनका चोक्खो कर पायो। ");
INSERT INTO hlb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","अर यीसु न उनको अविस्वास करनो पर हाईब की बात सोची (अस्चर्य) भयो, अर उ चारी तरफ को गाँव म सिखाते फिरियो। ");
INSERT INTO hlb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ओ न बारा हुन ख अपनो कने बुलायो अर उन ख दो-दो कर ख भेजन लग गयो; अर उनना बुरी आत्मा कि आत्मा हुन पर हक दियो ");
INSERT INTO hlb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ओ न उन ख हुकुम दियो रस्ता को लाने लाठी ख छोड़ अर कुछ मत लेनो; न ते रोटी, न थैला न बटवा म पैसा, ");
INSERT INTO hlb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","पर चप्पल पहनो अर दो-दो कुरता मत पहिननो ");
INSERT INTO hlb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","अर यीसु न उनका कय्हो, “जे कोई को घर म तुम उतरे, जब तक उ घर से चला नी जान ख तब लक उ घर म रुख ख रहनु ");
INSERT INTO hlb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","जे घर का अदमी तुम ख नी बुलान ख अर तुमारी नी सुनन ख वहा से जान को बखत अपनो पाय को धुरा भी झाड़ देनो कि उनको विरोध म गवाई होए” ");
INSERT INTO hlb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","तब जाय ख उन न प्रचार चालू करो कि वी बुरा काम हुन से मन फिराव। ");
INSERT INTO hlb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","अर ढ़ेर सारी भूत की आत्मा हुन ख निकायो, अर ढ़ेर सारा बीमार हुन पा तेल मलें अर ख उनका चोक्खो करो। ");
INSERT INTO hlb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","हेरोदेस राजा न भी ओकी चर्चा सुनी, काहेकि ओको नाम फैल गयो रह, अर ओ ना कय्हो, “यूहन्ना बपतिस्मा देन वालो मुर्दा म से जिन्दो भयो हैं, येको लाने ओसे या सक्ति (सामर्थ्य) ख काम परघट होवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","दुसरा अदमी न कय्हो, “यु एलिय्याह आय” पर कोई दुसरा न कय्हो भविस्यवक्ता हुन को बारे म बतान वालो म से कोई एक आय ");
INSERT INTO hlb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","हेरोदेस न असो सुन ख कय्हो, “जे यूहन्ना कि मुड़्डी मी न कटवायो रह, उयी जिन्दो भयो हैं?” ");
INSERT INTO hlb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","हेरोदेस न अपनो भई फिलिप्पुस कि घर वाली हेरोदियास को लाने जो से ओ न बिहाव कर ली रह, अदमी हुन ख भेज ख यूहन्ना ख पकडवा ख जेल खाना म ड़ाल दियो रह जो यहूदी नेम को अनुसार चोक्खो नी हतो; ");
INSERT INTO hlb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","अर यूहन्ना न हेरोदेस से कय्हो रह अपनो भई की घर वाली ख रखनो तोखा सोभा नी देवा, काहेकि यू हमारो नेम को हिसाब से चोक्खो नी हाय ");
INSERT INTO hlb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","येको लाने हेरोदियास ओसे गुस्सा करत रह अर असी सोचत रह की ओखा मरवा देनू हैं पर असो नी हो सकियो, ");
INSERT INTO hlb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","काहे कि हेरोदेस यूहन्ना ख धर्मी अर सुध्द (सुध्द) अदमी जान ख ओसे डरत रह, अर ओखा बचा ख रखत रह, अर ओकी बात सुन ख बेजा घबरात रह, पर मन लगा ख सुनत रह हतो ");
INSERT INTO hlb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","आखीर सही बखत मील गयो जब हेरोदेस न अपनो जन्म दिन ख आपना मुखिया (प्रधान) ख अर सेनापति हुन ख अर गलील ख बड़ा अदमी हुन को लाने खानो बनायो ");
INSERT INTO hlb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ते हेरोदियास कि पोरी भीतर आयी अर नाच ख हेरोदेस राजा को अर ओको संग म बठन वाला को मन ख खुस करियो तब राजा न पोरी ख कय्हो तू जो चाहे मी तो ख देहु, तू मोसे माँग, मी तो ख देऊगो ");
INSERT INTO hlb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","अर ओकी कसम ख का, “कय्हो मी तो ख आधो राज तक जो कुछ तू मोसे माँगे मी तोखा देऊगो” ");
INSERT INTO hlb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","पोरी न बाहर जाका अपनी माय ख पुछो “मी का माँगू?” माय न बोली, “यूहन्ना बपतिस्मा देन वालो कि मुण्डी” ");
INSERT INTO hlb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","वा तुरत राजा को कने भीतर गयी अर ओसे बोली कि, मी चाहूँ हैं कि तू अब्बीन यूहन्ना बपतिस्मा देन वालो की मुण्डी एक कोपर म मोखा मँगवा दा, ");
INSERT INTO hlb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","तब राजा बेजा दुखी भयो पर अपनी कसम देन को लाने अर संग म बैठन वाला मिजवान हुन को वजे से ओकी बात ख टाल नी पायो ");
INSERT INTO hlb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","अत: राजा न तुरत एक सिपाई का कैय (आग्या) ख, भेजियो कि, अर यूहन्ना की मुण्डी काट ख लाव ओ न जेल खाना म जा ख ");
INSERT INTO hlb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ओ न जेल खाना म जा ख यूहन्ना की मुण्डी ख काटियो अर एक कोपर म रख ख लायो, अर पोरी ख दियो पोरी न ओकी माय ख दियो ");
INSERT INTO hlb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","असो सुन ख यूहन्ना को चेला आया, अर ओकी लास ख ले गया, अर मरघट म धरीयो ");
INSERT INTO hlb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","प्रेरित हुन न यीसु को सामे इकट्ठा हो ख, जे कुछ उन न करयो अर सिखायो थो, सब यीसु ख बतायो, ");
INSERT INTO hlb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","फिर यीसु न उनका कय्हो, “आव अब अपुन सब अलग कही सान्त जगह म जा ख थोड़ो आराम करो।” काहेकि बेजा झन आत-जात रह अर उनका खान को भी बखत नी मिलत रह, ");
INSERT INTO hlb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","येको लाने वी नाव म चड़ ख सुनसान जगह म अलग चला गया। ");
INSERT INTO hlb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","बेजा इंसान न यीसु अर चेला ख जाते देख ख पहिचान लियो, अर सब नगर से इकट्ठा होका वहाँ नंगा पाय दऊड़िया अर यीसु अर चेला को से पहले जा पहुँचिया ");
INSERT INTO hlb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","यीसु न उतर ख वहा बड़ी भीड़ देखियो, अर उन पर तरस खायो, काहेकि वी, वी भेड़ को जसा हैं, जिनका कोई चरान वालो नी हाय; अर यीसु उन ख बेजा सी बात सिखान लग गयो। ");
INSERT INTO hlb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","जब दिन बेजा ढ़ल गयो, ते यीसु ख चेला ओको सामे आ ख कहन लगया, “यहाँ पर सुन सान जगह हैं अर दिन बेजा ढ़ल गयो ");
INSERT INTO hlb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","अदमी हुन ख भेज कि चारी तरफ को गाँव हुन अर बस्ती हुन म जाय ख अपनो लाने, कुछ खान ख मोल लेका आहे।” ");
INSERT INTO hlb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","यीसु न जवाब दियो, “तुम ही उनका खान ख देव।” उन न यीसु से कय्हो, “का हम सव दिन की दीनार की रोटी मोल लेका आहे, अर उनका खलाहे?” ");
INSERT INTO hlb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","यीसु न उनका कय्हो, “जा ख देखो तुमरो पास म कित्ती रोटी हुन हैं?” उन न मालुम कर ख कय्हो, “पाँच रोटी अर दो मच्छी भी।” ");
INSERT INTO hlb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","तब यीसु न आग्या देका कय्हो कि सब ख हरी घास म एक लाइन से बिठाल देव ");
INSERT INTO hlb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","वी सव-सव अर पचास-पचास कर ख कतार म बैठ गया ");
INSERT INTO hlb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","यीसु न वी पाँच रोटी ख लियो अर स्वर्ग की तरफ देख ख परमेस्वर से धन्यवाद दियो, अर ओको बाद फिर दो मच्छी ख लियो अर परमेस्वर कि तरफ धन्यवाद देका चेला हुन ख देते गयो, कि वी सब अदमी हुन ख परोसे, ");
INSERT INTO hlb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","सब न भर पेट खाना खायो ");
INSERT INTO hlb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","अर चेला हुन न बची रोटी को टुकड़ा से बारा टोकनी हुन भर ख उठायो, अर कुछ मच्छी को टुकड़ा से भी। ");
INSERT INTO hlb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","जिन न रोटी खायो वी पाँच हजार इंसान हता वी खान वाला म सिर्फ इंसान हुन कि गिनती करी। ");
INSERT INTO hlb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","तब यीसु न अपनो चेला हुन ख नाव पर चड़न को लाने बेबस करियो, की वी ओसे पहले उपार बैतसैदा ख चल देहे, जब तक कि यीसु अदमी हुन ख बिदा करे, ");
INSERT INTO hlb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","इंसान हुन ख भेज ख यीसु सान्त जगा पर बिनती करन ख गयो ");
INSERT INTO hlb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","जब साँम भई, ते नाव झील को बीच म हती, अर उ अकेलो जमीन म हतो, ");
INSERT INTO hlb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","जब ओ ना देख्यो की वी नाव चलाते-चलाते पस्त हो गया हैं, काहेकि हवा उनको सामने कि तरफ से चलत रह, ते रात को चऊथो पहर को करीब यीसु झील पा चलते उनको पास आयो; अर उनसे आगु चल देनु चाहत रह ");
INSERT INTO hlb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","पर उन न यीसु ख झील म पानी को ऊपर पर चलते देख ख समझीया कि उ भूत आय, अर चिल्लान लग गया: ");
INSERT INTO hlb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","काहेकि सब इंसान यीसु ख देख ख घबरा गया, पर यीसु न तुरत उनको से बात करी अर कय्हो, धीरज धरो मी आय: डरनू मत ");
INSERT INTO hlb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","तब यीसु उनको कने नाव पर गयो, अर हवा रुख गई: अर वी बेजा हाईब सोचन लग गया। ");
INSERT INTO hlb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","वी इंसान, पाँच रोटी हुन को बारे म नी समझीया हता, काहेकि उनको मन कठोर हो गयो रह, ");
INSERT INTO hlb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","यीसु अर ओखा चेला वी पार उतर ख गन्नेसरत को झील जगह म पहुँचिया, अर नाव ख घाट पर लगायो। ");
INSERT INTO hlb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","जब वी नाव पर से उतरियो, ते अदमी हुन न तुरत पहिचान ख ");
INSERT INTO hlb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","आस-पास को सबरो छेस्र म दऊड़िया, अर बिमार हुन ख खटिया म ड़ाल ख, जहाँ-जहाँ खबर मिले की यीसु वहाँ पर हैं, वी वहाँ पर बिमार हुन ख वहाँ-वहाँ ले लेका फिरया। ");
INSERT INTO hlb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","अर जो वी गाँव, नगर, बस्ती म यीसु फिरत रह अदमी बिमार हुन ख बाजार हुन म ले जाय ख ओसे विनती करत रह की यीसु उनका अपनो कपड़ा को छेड़ा ख ही छिन देहे: अर जित्ता ओखा छूवा रह, सबरा अच्छी हो जात रह। ");
INSERT INTO hlb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","तब फरीसी अर कुछ मोसे को नेम का सासतिरी जो यरूसलेम से आया हता, यीसु को कने इकट्ठा भया, हात धोन की रीति रिवाज। ");
INSERT INTO hlb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","अर उन न यीसु ख कुछ चेला हुन ख असुध्द एको मतलब बिना हात धोयो रोटी खाते देखो, ");
INSERT INTO hlb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","काहेकि फरीसी अर सब यहूदी हुन, सियाना कि रीति रिवाज पर चला हैं। अर जब तक चोक्खो से हात नी धो लेवा, तब लक नी खाय: ");
INSERT INTO hlb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","अर बाजार से आय ख, जब लक आँग नी धो लेवा, तब लक नी खाय; अर ढ़ेर सारी अऊर भी बात हैं। जे उनको कने मानन ख लाने पहुचाई गयी हैं, जसा, बटका, अर चरु हन, अर ताँमा को बर्तन हुन ख धोनो-माजनो। ");
INSERT INTO hlb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","येका लाने वी फरीसी हुन अर मूसा को नेम का सासतिरी हुन न ओसे पुछियो, “तोरा चेला काहे सियाना इंसान कि रीति रिवाज (परम्परा) पर नी चला, अर बिना हात धोयो रोटी खावा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","यीसु न उनका कय्हो, यसायाह न तुम कपटी हुन को बारे म बेजा अच्छी भविस्यवानी करी; जसो लिखो हैं: “यी अदमी मोरो मण्डो को सामे तो मोरी बड़ाई करा हैं, पर उनको मन मोसे दूर रहवा हैं, ");
INSERT INTO hlb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","यी बेकार म मोरी भक्ती करा हैं, काहेकि इंसान हुन को नेम हुन ख धरम कि सिक्छा कर ख सिखावा हैं। ");
INSERT INTO hlb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","काहेकि तुम परमेस्वर को आदेस ख टाल ख अदमी हुन कि रीति रिवाज ख माना हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","यीसु न उनका कय्हो, तुम इत्ता चतुर हैं की तुम अपनी रीति रिवाज (परमपरा) ख मानन ख लाने परमेस्वर को आदेस ख कसो चोक्खो तरीका से टाल देवा हैं! ");
INSERT INTO hlb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","काहेकि मूसा न कय्हो हैं, अपनो बाप अर अपनी माय कि सेवा करनु, अर जे भी माय अर बाप ख बुरो कहे, ओखा सच्ची म मार ड़ालो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","पर तुम बोला हैं, कि जो कोई अपनो बाप अर माय ख बोले जो कुछ तोरी मोसे सेवा बन सकत रह, वा अदा कर दियो एकोमतलब पुरो कर दियो। ");
INSERT INTO hlb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ते तुम ओखा ओको बाप अर ओकी माय कि कुछ सेवा नी करन दे ");
INSERT INTO hlb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","असो तरीका से तुम न अपनी रीति रिवाज हुन से जीनका तुम न ठहरायो हैं, परमेस्वर को वचन (वचन) टाल दे हैं; अर असा-असा ढ़ेर सारा काम करा हैं। ");
INSERT INTO hlb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","तब यीसु न भीड़: ख अपनो कने बुला ख उनका कय्हो, तुम सब मोरी सुननू, अर समझनो। ");
INSERT INTO hlb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","असी कोई भी चीज नी हाय की जो इंसान म बाहार से जा ख ओखा असुध्द करे; पर जो चीज इंसान को अन्दर से बहार से नीकला हैं, वही ओखा असुध्द करा हैं। ");
INSERT INTO hlb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“या आयत पुरानी किताब म नी हैं अदि कोई ख सुनन ख कान होए ते वी सुन लेहे” ");
INSERT INTO hlb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","जब यीसु भीड़ को कने से घर गयो, ते यीसु ख चेला न यू उदाहरन को बारे म ओसे पुछियो। ");
INSERT INTO hlb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","यीसु न उनका कय्हो, का तुम भी असा न समझ हैं? का तुम नी समझा कि जो चीज बाहार से अदमी को अन्दर जावा हैं वा ओखा ख असुध्द नी कर सका? ");
INSERT INTO hlb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","काहेकि वा ओको मन म नी पर पेट म जावा हैं अर हगन ख जाय हैं ते नीकल जावा हैं संड़ास? असो बोल ख यीसु न सब खान कि चीज ख सुध्द ठहरायो। ");
INSERT INTO hlb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","फिर यीसु न कय्हो, “जो इंसान को मन म से निकला हैं वही इंसान ख असुध्द करा हैं। ");
INSERT INTO hlb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","काहेकि अन्दर म से मतलब इंसान को मन से, बुरा-बुरा विचार, गलत काम चोरी, हत्या, दुसरो कि घर कि ख रखनो, ");
INSERT INTO hlb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","लोभ, बुरो काम, दुस्टता, छल लुचपन, बुरी नजर, बुराई, घमंड अर गन्दी बात, निकला हैं। ");
INSERT INTO hlb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","यी सब बुरी बात इंसान को अन्दर से निकला हैं अर इंसान ख असुध्द करा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","फिर यीसु ओमा से उठ ख सूर अर सैदा नाम को सिवाना म आयो; अर एक घर म गयो, अर चाहत रह, कि कोई नी जानन ख; पर यीसु छिप नी पायो। ");
INSERT INTO hlb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","अर तुरत एक बाई जोकी छोटी पोरी (बेटी) म बुरी आत्मा हती, ओको बारे म खबर सुन ख अई, अर यीसु को कने गिड़ी। ");
INSERT INTO hlb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","या यूनानी अर सुरूफिनी की जात की हती; ओ न यीसु से हात जोड़ ख विनती करी की, मोरी पोरी म से भूत (दुस्टात्मा) ख निकाल दे। ");
INSERT INTO hlb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","यीसु न ओसे कय्हो, “पहले पोरिया हुन ख खान दा, काहेकि पोरिया हुन कि रोटी लेखा कुत्ता हुन को सामे ड़ालनो अच्छो नी हाय।” ");
INSERT INTO hlb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ओ न यीसु ख जवाब दियो, “सही हैं प्रभु; ते भी कुत्ता हुन भी तो टेबल को नीचु पोरिया हुन कि रोटी को झुटन-काटन खा लेवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","यीसु न ओसे कय्हो, तोरो भरोसा को कारन अब तू चल दा भूत (दुस्टात्मा) की आत्मा तोरी पोरी म से निकल गई हैं। ");
INSERT INTO hlb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ओ न अपनो घर ख आ ख देखियो कि पोरी खटिया म पड़ी हैं, अर भूत कि आत्मा चली गई। ");
INSERT INTO hlb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","फिर यीसु सूर अर सैदा को देसु से निकल ख दिकापुलिस से हो ख गलील को सिवाना कि झील पा पहुँचियो। ");
INSERT INTO hlb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ते कुछ अदमी हुन न एक बहिरो ख जो तोतलो भी बोलत रह, यीसु को कने लाय ख ओसे विनती की कि अपनो हात ओपर धरे। ");
INSERT INTO hlb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","तब यीसु ओखा भीड़ म से अलग ले गयो, अर अपनी उगली हुन ख ओको कान म ड़ालियो अर थूक ख ओकी जीभ ख छियो ");
INSERT INTO hlb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","स्वर्ग कि तरफ देख ख लम्बो साँस!, लियो, अर ओसे कय्हो, “इप्फत्तह।” एको मतलब खुल जा। ");
INSERT INTO hlb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","अर ओखा कान खुल गया, अर ओकी जीभ कि बन्धन भी चली गई, अर उ चोक्खो-चोक्खो बोलन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","तब यीसु न उनका जतायो कि कोई ख मत बतानू, पर जित्तो यीसु न उनका चितायो उत्तो जादा ही उन न प्रचार करो। ");
INSERT INTO hlb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","वी बेजा हईरान हो ख बोलन लगिया, “यीसु न जे कुछ करयो सब चोक्खो करियो हैं; यीसु बहिरो ख सुनन को अर गुँगा ख बोलन कि सक्ति देवा हैं” ");
INSERT INTO hlb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","वी दिन म जब बड़ी जात भीड़ इकट्ठा भई, अर उनको जोने म कुछ खान का नी हतो, ते यीसु न अपना चेला ख पास म बुला ख कय्हो, ");
INSERT INTO hlb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“मोखा या भीड़ पर तरस आवा हैं, काहेकि या मोरो संग म तीन दिन से हैं, अर उनको पास म कुछ भी खान ख नी हाय। ");
INSERT INTO hlb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","अदि मी उनका भूको घर भेजू, ते रस्ता म थक ख रह जाहे; काहेकि इनमा से कोई बड़ी दुर से आया हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","यीसु का चेला न यीसु ख जवाब दियो, “यहाँ जंगल म कोई इत्ती सारी रोटी कहाँ से लाहे कि इनको पेट भरे?” ");
INSERT INTO hlb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","यीसु न उनसे पुछियो, “तुमरो जोने कित्ती रोटी हैं,?” उनना बोल्यो, “सात।” ");
INSERT INTO hlb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","तब यीसु न अदमी हुन ख जमीन पर बिठालन की बोलयो, अर वी सात रोटी लियो, अर परमेस्वर से दुवा कर ख (धन्यवाद) रोटी टोड़ियो, अर अपना चेला ख देते गयो कि उनको आगे परोसे; अर उन न अदमी को सामे रोटी परोसियो। ");
INSERT INTO hlb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","उनको पास म कुछ छोटी मच्छी भी हती; यीसु न परमेस्वर ख धन्यवाद कर ख उनका भी अदमी को सामे परोसन ख कैय दियो। ");
INSERT INTO hlb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","उन न पेट भर खायो अर चेला हुन न बचियो टुकड़ा से सात टोकनी भर ख उठायो। ");
INSERT INTO hlb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","अर अदमी चार हजार को लग-भग हता; तब यीसु न उनका अपनो घर बिदा करियो, ");
INSERT INTO hlb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","अर यीसु तुरत अपनो चेला हुन को संग म नाव पर चढ़ ख दलमनुता प्रदेस ख चल गयो ");
INSERT INTO hlb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","फिर फरीसी आका यीसु से बात-बात म ऊर्झन लग गया, अर ओ ख परखन को लाने यीसु से कोई स्वर्ग को चिन्न (चिन्ह) माँगियो। ");
INSERT INTO hlb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","यीसु न अपनो मन म लम्बो दम भर ख कय्हो, “या बखत म अदमी काहेको चिन्न ढुढा हैं? मी तुमका सच्ची बोलू हैं, की या बखत ख अदमी हुन ख कोई चिन्ह नी दियो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","अर यीसु फरीसी हुन ख छोड़ ख फिर से नाव म चेड़ गयो, अर ओनो पार चल दियो। ");
INSERT INTO hlb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","चेला हुन रोटी लेनो भूल गया रा अर नाव म उनको पास एक ठिया रोटी हती। ");
INSERT INTO hlb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","यीसु न उनका चितायो, “देखो, फरीसी हुन को अऊर हेरोदेस को खमीर से सतर ख रहनू” ");
INSERT INTO hlb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","वी एक दुसरो म विचार कर ख असा कहन लग्या “हमारो कने रोटी नी हाय” ");
INSERT INTO hlb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","यू जान ख प्रभु यीसु न उन ख कय्हो, “तुम काहे आपस म विचार करा हैं, की हमारो जोने रोटी नी हाय? का अब तक नी जाना अर नी समझा? का तुमरो मन कठोर हो गयो हैं, ");
INSERT INTO hlb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","का आँख रहनू पर भी नी देखा अर कान रहनु पर भी नी सुना? अर तुम ख याद नी हाय ");
INSERT INTO hlb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","की जब मी न पाँच हजार इंसान को लाने पाँच रोटी टोड़ी रह, ते तुम ना टुकड़ा से कित्ती टोकनी भर ख उठायो?” उन न यीसु कय्हो, “बारा टोकनी हुन।” ");
INSERT INTO hlb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“अर जब चार हजार को लाने सात ठिया रोटी हती ते तुम न टुकड़ा कि कित्ती टोकनी भर ख उठाया हता?” उन न जवाब दियो “सात टोकनी?” ");
INSERT INTO hlb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","यीसु न उनका कय्हो, “का तुम अभी तक नी समझीया?” ");
INSERT INTO hlb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","तब यीसु अर चेला बैतसैदा म आया; अर अदमी हुन एक अँधा ख ओको कने लेका आया अर यीसु को विनती की कि ओखा छी। ");
INSERT INTO hlb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","यीसु उ अंधा को हात पकड़ ख ओखा गाँव को बाहार ले गयो, अर ओकी आँख म थूक ख ओपर हात रखियो अर, ओसे पुछियो, “का तू कुछ देखा हैं” ");
INSERT INTO hlb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ओ न आँख उठा ख कय्हो, “मी अदमी हुन का देखू हैं, वी झाड़ को जसा चलते दिखा हैं” ");
INSERT INTO hlb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","तब यीसु न दुसरी बार ओकी आँख म हात रखियो अर अंधा न ध्यान से देखियो उ चोक्खो हो गयो, अर सब साप-सुतरो दिखन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","यीसु न ओखा असो बोल ख घर भेजियो, “यू गाँव को भीतर मत जाजो।” ");
INSERT INTO hlb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","प्रभु यीसु अर ओखा चेला कैसरिया फिलिप्पी को गाँव हुन को आजू बाजू को गाँव चल दिया। रस्ता म ओ न आपना चेला हुन ख पुछियो, “लोग मो खा का बोला हैं?” ");
INSERT INTO hlb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","उन न जवाब दियो, “यूहन्ना बपतिस्मा देन वालो; पर कोई-कोई एलिय्याह, आय कोई-कोई भविस्य को बारे म जानन वालो (भविस्यवक्ता) हुन म से एक होए बोला हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","यीसु न उनका पुछियो, “पर तुम मोखा का बोला हैं” पतरस न जवाब दियो; “तू परमेस्वर कि तरफ से आयो वालो मसी आय।” ");
INSERT INTO hlb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","तब यीसु न उनका जता ख कय्हो की मोरो बारे म असो कोई ख मत कहनो। ");
INSERT INTO hlb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","तब यीसु उनका सिखान लग गयो: इंसान को पोरिया को लाने जरुरी हैं, कि उ जादा दुख ख भोगे अर पुराना सियाना अर सबसे बड़ो पुजारी (प्रधान याजक), अर सास्र का जानन वाला सासतिरी ओखा बेकार को जानन को लाने मार ड़ाले, अर उ तीन-दिन को बाद जिन्दो होयगो। ");
INSERT INTO hlb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","यीसु न उनसे या बात साफ सुतरी कह दियो। ये पर पतरस ओखा अकेलो म ले जाका डाँटन लग गयो; ");
INSERT INTO hlb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","पर यीसु न घुम का अपनो चेला हुन कि तरफ देख्यो, अर पतरस का डाँट ख बोल्यो, “वोय सैतान मोरो सामे से चल दा; काहेकि तू परमेस्वर कि बात हुन पर नी, पर अदमी हुन कि बात हुन पर मन लगावा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","यीसु न भीड़ ख अपना चेला हुन को समेत नजीक बुला ख उनका कय्हो, “जे भी कोई मारो पिछु आन ख होए, उ अपनो खुद को इंकार करे अर अपनो सूली उठा ख उ मोरा पिछु चले। ");
INSERT INTO hlb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","काहेकि जो अपनो जान बचानो चाहे उ ओखा खोयगो, पर जे भी कोई मोरो अर सुभ समाचार को लाने अपनो जान खोयगो; उ ओ ख बचाएगो। ");
INSERT INTO hlb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","अदि अदमी पुरो संसार ख पा लेहे अर अपनो जान कि हानि उठाहे, ते ओखा का फायदा होए? ");
INSERT INTO hlb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","अदमी अपनी जान को बदला का देहे? ");
INSERT INTO hlb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","जे भी कोई या छिनाला अर पापी जात को बीच मोसे अर मोरी सिक्छा से अर मोसे लजाहे; इंसान को पोरिया भी जब उ सुध्द स्वर्ग दूत हुन को संग अपनो बाप कि सक्ति सहित आहेगो; तब ओसे भी लजाहे।” ");
INSERT INTO hlb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","यीसु न उनका कय्हो, “मी तुमका सच्ची कहू हैं, कि जे वी यहाँ पर खड़ा हैं, उनमा से कोई-कोई असा हैं, कि जब तक परमेस्वर को राज ख सक्ति (सामर्थ्य) समेत आयो वी नी देख लेन का, तब तक वी नी मरन ख।” ");
INSERT INTO hlb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","छे: दिन ख बाद प्रभु यीसु न पतरस अर याकूब अर यूहन्ना ख संग म लियो, अर सुनसान जगा म कोई ऊँचो टेकड़ा म ले गयो। वहाँ उनको सामे ओको मुँह बदल गयो, ");
INSERT INTO hlb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","अर ओखा कपड़ा असा चमकन लग गया अर असो तक उज्जलो भयो, कि दुनिया को कोई भी धोबी वसो उज्जलो नी धो सका ");
INSERT INTO hlb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","अर तीन चेला हुन न मूसा को संग म एलिय्याह दिखो; वी प्रभु यीसु ख संग म बात करत रह, ");
INSERT INTO hlb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ये पर पतरस न प्रभु यीसु से कय्हो, “गुरू, हमारो यहां रहनु चोक्खो हैं, येका लाने हम तीन मण्डा बनाहे; एक तोरा लाने, एक मूसा ख लाने, अर एक एलिय्याह को लाने,” ");
INSERT INTO hlb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","काहेकि पतरस नी जानत रह, कि का जवाब दे हे, येका खातिर वी बेजा डरा हता ");
INSERT INTO hlb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","तब एक बददल न उनका आका घेर लियो; अर उ बददल म से असो आवाज सुनाई दियो यू मोरो सबसे अच्छो पोरिया आय, “येकी सुननो”। ");
INSERT INTO hlb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","तब उनना एकदम से चारी ओर देखियो अऊर यीसु को अलावा अपनो संग म कोई ख नी देख्यो। ");
INSERT INTO hlb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","जब वी टेकड़ी पर से उतारती बखत यीसु न चेला हुन ख कैय दियो कि जब लक इंसान को पोरिया मरिया वाला हुन म से जिन्दो नी उठन को, तब लक जो कुछ भी तुम न देखो हैं उ कोई से मत कहनू।, ");
INSERT INTO hlb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","उन न या बात ख याद रखो, अर एक दुसरो से बात करन लग गया, “मरीया वाला हुन म से जिन्दो होनू को का मतलब हैं,” ");
INSERT INTO hlb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","अर उन न यीसु से पुछो, सासतिरी काहे ख बोला हैं, कि एलिय्याह को पहले आनो जरुरी हैं? ");
INSERT INTO hlb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","पर यीसु न उनका जवाब दियो; एलिय्याह सही म पहले आ ख सब कुछ सुधारे, पर इंसान को पोरिया को बारे म असो काहे लिखो हैं? कि उ बेजा दुख उठायगो, अर नीच गीनो जाहे? ");
INSERT INTO hlb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","पर मी तुम से कहूँ हैं, कि एलिय्याह तो आ गयो, अऊर जसो ओको बारे म लिखो हैं, उनका जो चोक्खो लगो उन न ओको संग म करो ");
INSERT INTO hlb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","जब यीसु अर ओखा तीन चेला हुन को संग दुसरा चेला को कने आयो, ते देखो कि उनको चारी तरफ बड़ी भीड़ लगी हैं, अर सासतिरी उनको संग म बात-बात म बहस करत रह, ");
INSERT INTO hlb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","यीसु ख देखते ही सब झन बेजा ही आस्चर्य करन लग गया, अर ओकी तरफ दऊड ख ओखा पाय पड़या। ");
INSERT INTO hlb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","यीसु न चेला हुन ख पुछयो, “तुम इनको संग म का बात को बखेड़ा मचावा हैं?” ");
INSERT INTO hlb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","भीड़ म से एक न कय्हो, “गुरू, मी अपनो पोरिया ख, जेमा गुँगो भूत समा गयो हैं, तोरो कने लायो हतो ");
INSERT INTO hlb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","उ भूत ओखा जिते भी पकड़ा हैं, वही पर ओखा पटक देवा हैं अर ओको मुण्डो म सफेद फेस आ जाय हैं, अर दाँत कटरा, अर दुबलो होते जावा हैं।, मीना तोरा चेला हुन से कय्हो कि तुम ओ ख निकाल देव पर वी ओखा नी निकाल सक्या,” ");
INSERT INTO hlb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","यू सुन ख यीसु न उनसे जवाब देखा कय्हो “अरे अविस्वासी अदमी, मी कब तक तुमरो संघ म रहू? अर कब लक तुम ख झेलू? ओ ख मोरो कने लाव।” ");
INSERT INTO hlb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","तब वी ओखा ओको कने ले गया; अर जब यीसु न ओखा देख्यो, ते उ भूत न जलदी ओ ख मरोड़ियो; अर उ जमीन म गिरो, अर मुँह म से फेस निकलन लग गयो अर लुढ़कन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","तब यीसु न ओको बाप से पुछियो; ऐकी या दसा कित्ता दिन से हैं? “ओ न कय्हो, छोटो पन से। ");
INSERT INTO hlb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ओ न ओखा खत्म करन को लाने कित्ती बार कबी आग अर कबी पानी म गिरायो; पर तू कुछ कर सका हैं, ते हम पर रहम कर ख हम पर तरस ख।” ");
INSERT INTO hlb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","प्रभू यीसु न ओसे कय्हो, “अदि तू कुछ कर सका हैं? या कसी बात आय! भरोसा करन वाला को लाने सब कुछ हो सका हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","पोरिया को बाप न तुरत हात पाय जोड़ ख बोलयो “अरे प्रभु मी भरोसा करु हैं, मोरो अविस्वास को उपाय ढुढ।” ");
INSERT INTO hlb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","जब यीसु न देखो कि अदमी हुन दऊड ख भीड़ लगावा हैं, ते यीसु न बुरी आत्मा ख असो कैय ख डांटियो “अर गुँगी अर बहरी आत्मा मी तोखा कहू हैं, ओमा से निकल ख बहार आ अर ओको आँग म फिर कभी मत आजो।” ");
INSERT INTO hlb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","तब वा चिल्लाया ख अर ओखा बेजा मुरोड़ ख निकल ख आ गई पोरिया मरो जसो हो गयो अर अदमी कहन लग गया की उ मर गयो ");
INSERT INTO hlb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","पर प्रभु यीसु न ओको हात पकड़ ख ओखा उठायो; अर उ खड़ो हो गयो। ");
INSERT INTO hlb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","जब उ घर ख आयो, ते ओखा चेला हुन न अकेलो म ओसे पुछयो, “हम ओखा काहे नी निकाल पाया?” ");
INSERT INTO hlb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","यीसु न उन ख कय्हो, “असो तरीका को भुत बिना प्रार्थना को कोई अऊर उपाय से नी निकल सका।” ");
INSERT INTO hlb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","फिर यीसु अर ओ ख चेला वाहा से चलिया, अर उ गलील म से हो ख जावा। उ नी चाहवत रह, की कोई ओखा पहिचाने ");
INSERT INTO hlb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","काहेकि उ अपनो चेला हुन ख सिखावत अर उन ख कहत रह, “इंसान को पोरिया, इंसान हुन को हात म पकड़वा दियो जाहे, अर वी ओखा मार ड़ालेगो; अर उ मरन को तीन रोज बाद म जिन्दो होयगो।” ");
INSERT INTO hlb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","पर या बात उनका समझ म नी आई, अऊर वी ओसे पुछनो से डरत रह। ");
INSERT INTO hlb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","वी फिर कफरनहूम म आया; अऊर घर म आका यीसु न चेला हुन से पुछयो, “कि रस्ता म तुम का बात पर उर्झत रह?” ");
INSERT INTO hlb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","वी चुप चाप रया, काहेकि वी रस्ता म या बात पर उरझीया रह, कि हम म से बड़ो कोन हैं, ");
INSERT INTO hlb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","तब यीसु न वी चेला हुन ख बुला ख अर उनसे कय्हो, “अदि कोई तुम म से बड़ो बननू चाहवा हैं, ते सबसे छोटो बन ख अर सबको सेवक बननो पढ़े।” ");
INSERT INTO hlb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","अर यीसु न एक पोरिया ख लेका बीच म खड़ो कर ख, अर ओखा कोरा म लेका उनसे कय्हो, ");
INSERT INTO hlb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“जो कोई मोरो नाम से असो पोरिया म से कोई एक ख भी मोरो नाम से अपनाहे, ते वी मोखा अपनावा हैं जे कोई मोखा अपनावा हैं ते उ मोरो भेजन वालो ख अपनावा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ते फिर यूहन्ना न ओसे कय्हो, “अरे गुरू, हम न तोरो नाम से एक अदमी ख भूत हुन निकालते देख्यो हैं; अर हमना ओखा मना कर दियो काहेकि उ हमारो संग म नी चलत रह।” ");
INSERT INTO hlb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ते फिर यीसु न कय्हो, ओखा मना मत करो; काहेकि असो कोई नी हाय जो मोरो नाम से सक्ति से अचम्भा को काम करे, अर जल्दी से मोखा बुरो बोल सका हैं। ");
INSERT INTO hlb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","काहेकि जो हमारो दुसमन नी उ हमारो तरफ हैं। ");
INSERT INTO hlb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","जे भी कोई एक लोटा पानी तुमका एको लाने पिलाहे कि तुम यीसु मसी का सेवक आय, ते मी तुम से सच्ची-सच्ची कहू हैं, कि उ अपनो भक्ती को फल कभी भी नी खोवन को। ");
INSERT INTO hlb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","जे भी कोई यी छोटा म से जो मो पर भरोसा करा हैं। कोई ख ठोकर करे ते, ओखा लाने या भलाई कि बात हैं एक बड़ी घट्टी को पाट ओको गरदन म टांगो जाय अर ओखा समुंदर म फेक दियो जाय। ");
INSERT INTO hlb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","अदि तोरो हात तोखा ठोकर खलाहे ते ओखा काट ख फेक देजो। ठोकर खलाहे ते ठोटो होका स्वर्ग को जीवन म जाझे तोरो लाने ये से भलई कि बात हैं, कि दो हात रहनु पर नरक कि आग म डालो जाहे, जो कबी बुझन कि नी। ");
INSERT INTO hlb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","जहाँ पर उनको कीड़ा नी मरा अर आग नी बुझा ");
INSERT INTO hlb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","अदि तोरा पाय तोखा ठोकर खलाहे ते ओखा काट ड़ाल। लंगड़ो होका स्वर्ग को जीवन म पहुँच जो तोरा लाने येसे भलई कि बात हैं, कि दो पाय होनो पर नरक म ड़ाल्यो जाय, ");
INSERT INTO hlb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","जहाँ पर उनको कीड़ा नी मरा अर आग नी बुझा। ");
INSERT INTO hlb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","अदि तोरी आँखी तो ख ठोकर खिलाहे ते ओ ख निकल देजो। काना हो ख परमेस्वर को राज म जाजो तोरो लाने येसे भलो हैं, की दो आँखी रहनो पर भी तू नरक म डाल्यो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","जहाँ पर उनको कीड़ा नी मरा अर आग नी बुझा। ");
INSERT INTO hlb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","काहेकि हर एक झन ख आग से नोन को जसो खरो बनायो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","नोन चोक्खो हैं, पर अदि नोन को सुवाद बिगड़ जाहे, ते ओखा काय से खरो बनाहे? अपनो म नोन पन रखो, अर आपस म मिल जुड़ ख रहनु। ");
INSERT INTO hlb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","फिर यीसु वा जगह से उठ ख यहूदिया कि हद अर यरदन नद्दी को जोने गयो। भीड़ ओखा सामे जामा हो गई, अर यीसु अपनो नेम को हिसाब से उन ख फिर बतान लग्यो। ");
INSERT INTO hlb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","तब कुच फरीसी हुन न ओको सामे आ ख ओकी परिक्छा लेन ख लाने ओसे पुछियो कि, “का यू ठीक हैं का, कि अदमी अपनी घर वाली ख छोड़े?” ");
INSERT INTO hlb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","यीसु न उन ख बतायो, “मूसा न तुम ख का हुकुम दीयो हैं?” ");
INSERT INTO hlb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","उन न कही, “मूसा न छोड़ छुट्टी लिखन अर छोड़न को नेम दियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","यीसु न उनका कही, “तुमरो मन की ड़ीट पन को वजे से ओ न तुमरो लाने यू आदेस लिखो ");
INSERT INTO hlb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","पर ँसृस्टि को सुरू से परमेस्वर न अदमी अऊर ओरत कर ख उनका बनायो हैं, ");
INSERT INTO hlb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","येको लाने अदमी अपनो माय-बाप से अलग होका अपनी घर वाली को संग म रहे ");
INSERT INTO hlb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","इ प्रकार से अब वी दो नी बल्कि एक सरीर आय। ");
INSERT INTO hlb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","येको लाने जोका परमेस्वर न जोड़ियो हैं, ओखा अदमी हुन अलग नी करन का।” ");
INSERT INTO hlb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","जब यीसु घर म पहुँचियो ते चेला हुन न ओको बारे म ओसे अकेलो म फिर पुछयो। ");
INSERT INTO hlb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","यीसु न उनका कय्हो, “जो कोई अपनी घरवाली का छोड़ ख दुसरी ओरत से बिहाव करहे ते वाह पहली घरवाली की नजर म गलत काम करह हैं, ");
INSERT INTO hlb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","अर यदि घर वाली अपनो घर वालो का छोड़ ख दुसरो से बिहाव करे ते वहा गलत काम करह हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","फिर अदमी हुन छोटा पोरिया पारी हुन का ओको जोने लावन लग्या, कि उ उन पर हात धरे, पर चेला हुन न उनका डाँटियो। ");
INSERT INTO hlb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","यीसु न असो देख ख घुस्सा होका उनका कय्हो, “पोरिया-पारी हुन ख मोरा पास म आवन देव अर उनका मना मत करो, काहेकि परमेस्वर को राज असो ही हुन को हैं। ");
INSERT INTO hlb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","मी तुम ख सच्ची बोलू हैं। कि जे भी कोई परमेस्वर को राज का, छोटा पोरिया को जसो नी समझन ख वी परमेस्वर को राज म कभी भी नी जान को।” ");
INSERT INTO hlb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","अर ओ न उनका कन्ना म लियो, अर ओ न उनको पर हात धर ख उनका आसीर्वाद दियो। ");
INSERT INTO hlb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","जब यीसु वहाँ से निकल ख रस्ता म से जात रह, ते एक अदमी ओखा पास म दऊडत आयो; अर ओको सामे टोगरिया मोढ़ ख ओसे पुछयो; “अरे अच्छो गुरू अनन्त जीवन पान ख लाने मी का करु,?” ");
INSERT INTO hlb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","यीसु न ओसे कही, “तू मोखा चोक्खो काहे बोला हैं कोई अच्छो नी, केवल एक परमेस्वर। ");
INSERT INTO hlb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","तू आदेस ख जाना हैं कोइ ख मारजे मत, गलत काम मत करजे, चोरी मत करजे, झुटी गवाही मत देजो, छल-कपट मत करजे अपनो बाप अर माय को आदर करजे।” ");
INSERT INTO hlb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ओ न ओसे कही, अरे गुरू इन सब ख तो मी छुटपन से मानते आयो हैं। ");
INSERT INTO hlb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","यीसु न ओखा ध्यान से देख ख ओसे प्रेम करियो; अर ओसे कही, “तो म एक बात कि कमी हैं। जा जे कुछ भी तोरो हैं ओखा बेच ख गरीब-लचार (कंगाल) हुन म बाट दा, अर तोखा स्वर्ग म धन मिल जाहे, अर आका मोरो पिछु हो जा” ");
INSERT INTO hlb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","या बात (मान्दी) से ओको मन म नराजी सी आय गई अर उ मुण्डो लटका ख चल दियो, काहेकि उ जादा धनी हतो? ");
INSERT INTO hlb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","यीसु न चारी तरफ देख ख अपना चेला हुन से कही, “धनवान को परमेस्वर ख राज म जानो कित्तो कठिन हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","चेला हुन यीसु कि बात से चकित रह गया ये पर यीसु न फिर उनका कही “अरे पोरिया हुन, जो धन पर भरोसा रखा हैं, उनको लाने परमेस्वर को राज म जानो कसो कठिन हैं ");
INSERT INTO hlb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","परमेस्वर को राज म धनवान ख भीतर जानु से ऊँट को सुज्जी को छेद म से निकल जानु सहज हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","वी बेजा ही अचम्भा म पड़ ख आपसी मे कहन लगया, “ते फिर कोन को उध्दार हो सका हैं,?” ");
INSERT INTO hlb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","यीसु न उनकी तरफ देख ख कय्हो, “अदमी हुन से तो यू नी हो सका, पर परमेस्वर से हो सका हैं, काहेकि परमेस्वर से सब कुछ हो जाय हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","पतरस ओसे कहन लग गयो, “देख, हम तो सब कुछ छोड़ ख तोरो पिछु चला हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","यीसु न कही, “मी तुमका सच्ची कहू हैं, कि असो कोई नी; जेना मोरा लाने अर सुभ समाचार ख लाने घर का या भई हुन ख या बहिन हुन ख या माय-बाप ख या पोरिया-पारी हुन ख या खेत हुन ख जेना छोड़या होए; ");
INSERT INTO hlb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","अर अब या बखत सव गुना नी पायो होए, घर हुन अर भई हुन अर बहिन हुन अर माय हुन अर पोरिया पारी अर खेत हुन ख, पर सतायो जानो को संग या दुनिया म। अर स्वर्ग म अनन्त काल को जीवन। ");
INSERT INTO hlb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","अर बेजा सारा जो पहले से हता, पिछे होयगो, अर जो पीछु हैं वी पहले होए।” ");
INSERT INTO hlb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","जब यीसु अर चेला हुन यरूसलेम ख जाति बखत रस्ता म हता, अर यीसु उनको सामे-सामे चलते जात रह, चेला हुन अचम्बा म हता अर जे ओखा पिछु पिछु चलत रह वी डर गया जसा का हता रह। तब उ फिर बारा हुन ख लेका उनसे वा बात बोलन लग गयो, जे ओको ऊपर आन वाली हती रह, ");
INSERT INTO hlb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“देखो अपुन यरूसलेम ख जाय हैं, अर इंसान को पोरिया बड़ा पुजारी हुन अर सासतिरी हुन को हात म पकडवा दियो जाहे। अर वी ओखा सुली पर चढ़ान को योग्य ठहराहे अर दुसरी जात अधिकारी हुन को हात म सोप दियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","अर वी ओको मजाक उड़ाहे, ओको पर थुकेगो; ओखा कोड़ा मारेगो अर वी ओखा मार ड़ालेगो, अर तीन दिन को बाद उ मुर्दा म से जिन्दो होयगो।” ");
INSERT INTO hlb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","तब जबदी को पोरिया याकूब अर यूहन्ना न यीसु को पास म आका कय्हो, “गुरू जो कुछ वी हम तोसे माँगे, उ तू हमारा लाने कर।” ");
INSERT INTO hlb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","यीसु न उन ख कय्हो, “तुम का चाहवा हैं की मी तुमरो लाने करु?” ");
INSERT INTO hlb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","उन न यीसु से कय्हो, “हमका असी सक्ति दे की तोरो राज म जब तू सिंहासन पर बठे ते हम म से एक तोरो दायो हात बाजू अर दुसरो तोरो बायो हात बाजू बठे।” ");
INSERT INTO hlb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","यीसु न उनका कय्हो, “तुमका नी मालूम कि तुम का माँगा हैं? जो दुख को कटोरा मी पीवन पर हैं, का तुम पी सका हैं; अर जो बपतिस्मा मी लेन पर हैं, का तुम ले सका हैं?” ");
INSERT INTO hlb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","उन न यीसु से कय्हो, “हम से हो सका हैं।” यीसु न उनका कय्हो, “जो कटोरा मी पीवन पर हैं, तुम पीहे; अर जो क्रूस को बपतिस्मा मी लेन पर हैं, ओखा लेहे। अर उ कटोरा ख तुम ख पिनो पड़ेगो। ");
INSERT INTO hlb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","पर जेको लाने परमेस्वर न तैयार करयो हैं, उनका छोड़ का अर कोई ख अपनो आजू-बाजू बिठालन मोरो काम नी हाय।” ");
INSERT INTO hlb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","असो सुन ख दस हुन याकूब अर यूहन्ना पर घुस्सा करन लग गया, ");
INSERT INTO hlb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ते यीसु न उनका पास म बुला का उनका कय्हो; “तुम जाना हैं कि जो दुसरी जात अधिकारी हुन समझा जावा हैं, वी उन पर अधिकार जतावा हैं। ");
INSERT INTO hlb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","पर तुम म असो नी हाय, पर जो कोई तुम म बड़ो होन चाहवा हैं, उ तुमारो सेवक बने; ");
INSERT INTO hlb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","अर जे कोई तुम म बड़ो होन चाहवा हैं। उ सबको नउकर बने। ");
INSERT INTO hlb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","काहेकि इंसान को पोरिया येको लाने नी आयो कि ओकी सेवा टहल करी जाय, पर येको लाने आयो कि उ स्वंय सबकी सेवा चाकरी करे, अर बेजा झन ख छुड़ान ख लाने अपनी जान देहे।” ");
INSERT INTO hlb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","वी यरीहो म आया। अर जब उ अर ओखा चेला हुन, अर एक बड़ी जात भीड़ यरीहो म से निकलत रह, तब तिमाई को पोरिया बरतिमाई, एक अंधा भिखारी ख, रोट को किनार म बठियो हतो ");
INSERT INTO hlb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ओ न असो सुन कर कि यीसु नासरी आय, चिल्लाया-चिल्लाया ख कहन लग गयो, “हे दाऊद कि गोत को; यीसु मोरा पर दया कर।” ");
INSERT INTO hlb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ढ़ेर सारा न ओखा डाँटियो कि चुप चाप रवा, पर उ अऊर भी आवाज देन लग गयो “हे दाऊद कि संतान मोरो ऊपर दया कर!” ");
INSERT INTO hlb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","तब यीसु न ठहर ख कय्हो, “ओखा बुलाव।” अर अदमी हुन न उ अँधो ख बुला ख ओसे कय्हो “धीरज धर! उठ उ तोखा बुलावा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","उ अपनो कपड़ा हुन ख फेक ख कुदते हुए, अर यीसु को पास म आयो। ");
INSERT INTO hlb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ये पर यीसु न ओसे कय्हो, “तोरी का इच्छा हैं, कि मी तोरा लाने करु?” अंधा न ओसे बोल्यो, “हे गुरू असो कि मी देखन लग जाऊ।” ");
INSERT INTO hlb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","यीसु न आसो कय्हो, “चल जा, तोरा भरोसा न तोखा चोक्खो कर दियो।” उ तुरत देखन ख लग गयो, अर रस्ता म ओको पिछु जान लगियो ");
INSERT INTO hlb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","जसा ही वी यरूसलेम ख नजीक म, जैतून नाम को पहाड़ पर बैतफगे अर बैतनिय्याह नगर को आजू बाजू आया। ते ओ न अपना चेला हुन म से दो का यू बोल ख भेजियो, ");
INSERT INTO hlb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“सामे को गाँव म जाओ। अर ओमा जा ख एक गधी को बच्छा ख, जो पर कभी कोई नी बठिया; बाँधियो तुम ख मिले। ओखा छोड़ ख लाव। ");
INSERT INTO hlb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","अदि तुमका कोई पुछे, असो काहे करा? ते कहनु प्रभु का येको काम हैं, अर उ जल्दी से ओखा यहाँ भेज दे हे।” ");
INSERT INTO hlb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","उन न जा ख अर उ बच्छा ख दुवार को बाहर चऊक को सामे बाँधियो देखो, अर ओ ख खोल ख लान लग्या। ");
INSERT INTO hlb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","उनमा से जे वहाँ पर खड़ा हता, कोई-कोई कहन लग्या, “यू का करा हैं? गधी को बच्छा ख काहे छोड़ा हैं?” ");
INSERT INTO hlb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","जसो यीसु न उन ख कय्हो रह, वसो ही उन न उन ख बता दियो; तब जाय का अदमी हुन न उनका जान दियो, ");
INSERT INTO hlb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","उन न बच्छा ख यीसु को सामे लाय ख ओपर अपनो कपड़ा ड़ालियो अर यीसु ओपर बठ गयो ");
INSERT INTO hlb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","तब बेजा झन न अपनो कपड़ा रस्ता म बिछायो अर कई झन न तो खेत हुन म से छिन्द का फंटा (कि डगियान) काट काट ख बिछा दियो। ");
INSERT INTO hlb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","जो ओको आगु आगु अर पिछु पिछु चलते जात रह, चिल्लाया ख कहत रह, “होसाना हे प्रभु हम ख बचाय ला, धन्यवाद होवा ओको जो प्रभु को नाम से आवा हैं! ");
INSERT INTO hlb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","हमारो दादा दाऊद को राज जो आवन वालो हैं! धन्यवाद होय ओको ऊँचो बादल म ओकी बड़ाई होय (जय जय कार) होसाना।” ");
INSERT INTO hlb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","यीसु यरूसलेम नगर पहुँच ख मन्दिर म गयो; अर चारी तरफ सब चिज का देखियो बारा चेला हुन को संग म बैतनिय्याह गयो; काहेकि साम हो गई रह। ");
INSERT INTO hlb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","दुसरो दिन वी बैतनिय्याह म से निकलिया ते यीसु ख भुख लगी। ");
INSERT INTO hlb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ओ न दुर से अंजीर को हरो झाड़ का देख ख ओको पास म गयो कि का जाने ओमा कही मिले पर पत्ता ख छोड़ ओमा कही नी मिलियो काहेकि फल को बखत नी हतो रह ");
INSERT INTO hlb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ये पर ओ न झाड़ से कय्हो, “अब से कोई तोरा फल कभी नी खान का!” अर ओखा चेला सुनत रह, ");
INSERT INTO hlb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","पर वी यरूसलेम ख आया, अर उ मन्दिर म गयो; अर वहाँ पर जे लेनो देनो करत रह, उनका बाहर निकालन लग गयो; अर सबसे बड़ा सासन करन वाला को पिढ़ा अर कबूतर बेचन वाला कि चऊकी हुन ख उलट दियो, ");
INSERT INTO hlb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","अर मन्दिर म से कोई का बरतन लेका आन-जान नी दियो। ");
INSERT INTO hlb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","अर सिखाया का उन से कय्हो, “का यू नी लिखो हैं कि मोरो घर परमेस्वर को अऊर सब देस का लोग हुन को लाने बिनती (प्रार्थना करन) करन को घर कहलाहे? पर तुम न येका ड़ाकू हुन को घर बना दियो।” ");
INSERT INTO hlb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","यू सुन ख सबसे बड़ो पुजारी अर सासतिरी ओखा मार ड़ालन को मऊका ताकन लग गया। काहेकि वी ओसे डरत रह, येको लाने कि सब झन ओको बतानु से सोच म पड़ गया रह। ");
INSERT INTO hlb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","साम होते ही वी नगर से बहार निकल गया। ");
INSERT INTO hlb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","फिर सुबेरे उठ ख जब वी उते से जात रह, ते उन न उ अंजीर को झाड़ ख ऊपर से नीचु जड़ तक सुकियो देखो। ");
INSERT INTO hlb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","पतरस ख वा बात याद आ गई, अर ओ न ओसे कही, “गुरू, देख! यू अंजीर को झाड़ ख जेखा तुना बददुवा दियो रह, सुख गयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","यीसु न ओखा कय्हो, “परमेस्वर पर भरोसा रखो ");
INSERT INTO hlb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","मी तुमका सच्ची बोलू हैं, कि जे कोई यू टेकड़ा से कहे ‘तु उखड़ जा, अर समुंदर म गिड जा,’ अर अपनो मन म सक नी करन को पर भरोसा करे कि, जे बोलू हैं। उ हो जाहे, ते ओको लाने उयी होयगो। ");
INSERT INTO hlb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","येको लाने मी तुम से कहू हैं। कि जे कुछ भी तुम बिनती कर ख माँगे, ते भरोसा कर लेनू कि तुम ख मिल गयो; अर उ तुमारो लाने होयगो। ");
INSERT INTO hlb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","जब कभी तुम खड़ा हो ख बिनती करा हैं ते अदि तुमारा मन म कोई ख बारा म गुस्सा होए; ते माप करनु; येको लाने कि तुमरो स्वर्ग म रहन वालो परमेस्वर बाप भी तुमरो पाप माफ करे। ");
INSERT INTO hlb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","अर अदि तुम माफ नी करन का ते तुमारो बाप जे स्वर्ग म रहवा हैं। तुमरी गलती माफ नी करन को।” ");
INSERT INTO hlb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","यीसु अर चेला फिर यरूसलेम ख आया, अर जब उ मन्दिर म फिरत रह, बडो बलिदान कि भेट चड़ान वालो पुजारी अर सासतिरी अर सियाना ओको पास म आय ख पुछन लग गया, ");
INSERT INTO hlb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“उन न ओसे पूछो यू काम कोन को हक से करा हैं? अर यू हक तोखा कोना दियो हैं, कि तू यू काम करे?” ");
INSERT INTO hlb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","यीसु न उनसे कही, “मी भी तुम से एक बात पिछु; मोखा बताहे ते मी तुमका बताऊँ की यू काम कोन को हक से करु हैं। ");
INSERT INTO hlb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","यूहन्ना को बपतिस्मा का स्वर्ग कि तरफ से हतो या अदमी हुन कि तरफ से हतो रह, मोखा बताव।” ");
INSERT INTO hlb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","तब वी एक दुसरो से बात-बात म ऊर्झन लग गया कि अदि हम बोले स्वर्ग को तरफ से ते उ बोले, फिर तुमना यूहन्ना को भरोसा काहे नी करयो? ");
INSERT INTO hlb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","अर का हम असो बोले, अदमी हुन को तरफ से, ते अदमी हुन को डर हैं, काहेकि सब जाना हैं कि यूहन्ना सही म भविस्यवक्ता हतो। ");
INSERT INTO hlb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","एकोलाने उन न यीसु क कही, “हम नी जाना।” यीसु न उनका कही, “मी भी तुमका नी बताऊँ कि यू काम कोन को हक से करु हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","फिर यीसु मसी उदाहरन म उनसे बात करन लग गयो; “कोई अदमी न अंगूर को बगीचा लगायो (दाख की बारी) अर ओको चारी तरफ बागड लगायो अर रस को लाने कुण्ड खोदियो, अर बडो ऊँचो गुम्मट बनायो, अर किरसान हुन ख ओको ठेका देखा दुसरो सहर म चल दियो। ");
INSERT INTO hlb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","फिर फल को बखत म ओ न किरसान हुन को पास म एक नउकर ख भेजियो कि किरसान हुन से अंगूर कि खेत को फल हुन को हिसाब लेहे। ");
INSERT INTO hlb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","पर उन न ओखा पकड़ ख पिटियो अर खाली हात लउटा दियो ");
INSERT INTO hlb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","फिर ओ न एक अऊर नउकर ख उनको पास म भेज्यो; उन न ओकी मुण्डी का फोड़ ड़ालियो अर ओकी बेज्जती करी ");
INSERT INTO hlb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","फिर ओ न एक अऊर सेवक ख भेजियो, उन न ओखा भी मार ड़ाल्यो। तब ओ न अऊर बेजा झन ख भेज्यो; उनमा से उन न कोई ख पिटियो, अर कोई ख मार ड़ालियो। ");
INSERT INTO hlb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","जब एक ठिया ही रह गयो रहा, जे ओको सबसे अच्छो पोरिया हतो रह; आखरी म ओ न ओखा भी उनको जोने यू सोच ख भेज्यो कि वी मोरो पोरिया कि इज्जत करे। ");
INSERT INTO hlb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","पर वी किरसान हुन न आपस म सोचियो, आव अपुन एका मार ड़ाले, अर सबरो धन दऊलत अपनो हो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","अऊर उन न ओखा पकड़ ख मार ड़ाल्यो, अऊर अंगूर को खेत को बाहर फेक दियो। ");
INSERT INTO hlb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“येको लाने अंगूर की खेत को मालिक का करे? उ आका वी किरसान हुन ख नास करेगों, अऊर अंगूर की खेत दुसरो किरसान हुन ख दे देहेगो। ");
INSERT INTO hlb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","का तुम न सुध्द सास्र म यू वचन नी पड़ो? “जो पत्थर ख राज मिसतिरी हुन न बेकार हैं अलग करियो रह। उयी कोना को सिरा हो गयो; ");
INSERT INTO hlb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","अर यू प्रभु कि तरफ से भयो; अर हमारी नजर म अदभुत हतो।” ");
INSERT INTO hlb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","जे यहूदी अदमी हता वी यीसु ख पकडन की कोसिस करत रह; काहेकि समझ गया हता कि ओ न हमारो बारे म यू उदाहरन कय्हो हैं। पर वी अदमी से डरा अऊर ओखा छोड ख चल दिया। ");
INSERT INTO hlb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","तब उन न ओखा बात म फसान को लाने कुछ फरीसी हुन ख अऊर हेरोदियो ख ओको पास म भेज्यो। ");
INSERT INTO hlb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","उन न आका ओसे कही, अरे गुरू, हम जाना हैं कि तू सही बोला हैं अऊर कोई कि चिन्ता नी करा; काहेकि तू अदमी हुन को मुण्डो देख ख बात नी करा, पर परमेस्वर तक जान को रस्ता सच्ची-सच्ची बतावा हैं। ते का कैसर ख लगान (कर देना) देनु ठीक हैं कि नी? ");
INSERT INTO hlb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","“हमका देनु हैं या नी देनु हैं?” ओ न उनको कपटी पन जान ख उनसे कय्हो, “मोखा काहे परखा हैं? एक रोज कि दीनार लेका मोरो कने लाओ, कि मी ओखा देखु।” ");
INSERT INTO hlb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","वी लेका आया अऊर ओ न उन ख कय्हो, “यू छापियो छाप अर नाम कोन को आय?” उन न कही, “कैसर को।” ");
INSERT INTO hlb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","यीसु न उन ख कही, “जे कैसर राजा को हैं, उ राजा ख, अऊर जे परमेस्वर को हैं परमेस्वर ख देव।” तब वी ओपर बेजा अचम्भा करन लग गया। ");
INSERT INTO hlb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","फिर सदूकी हुन न भी जो बोला हैं कि मरीया वाला हुन को जिन्दो होनू हैं नी हाय, ओको कने आका ओसे पुछियो, ");
INSERT INTO hlb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“अरे गुरू, मूसा न हमारो बारे म लिखियो हैं। कि अदि कोई को भई बीना अवलाद को मर जाहे अर ओकी घर वाली रह जाए ते ओको भई ओकी घर वाली से बिहाव कर ले, अर अपनो भई को लाने अवलाद पैदा करे। ");
INSERT INTO hlb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","सात भई हता रह। पहलो भई बीना अवलाद को मर गयो। ");
INSERT INTO hlb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","तब दुसरो भई न ओसे बिहाव कर लियो अर बीना अवलाद को मर गयो अर वसो ही तीसरो न भी करियो। ");
INSERT INTO hlb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","अर सात से ओ न बिहाव करो साती से अवलाद नी भई अर सब को बाद म वा ओरत भी मर गयी। ");
INSERT INTO hlb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","अब: बता सब अदमी जिन्दो होनू को बाद म वा उनमा से कोन कि घर वाली होए? काहेकि वा साती कि घर वाली बन गई रह।” ");
INSERT INTO hlb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","यीसु न उन ख कय्हो, “का तुम असो करनो से भुल म पड़िया हैं, कि तुम न तो सुध्द सास्र ख जाना हैं; अर न ही परमेस्वर कि सक्ति ख? ");
INSERT INTO hlb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","काहेकि जब वी मरीया वाला हुन म से जिन्दा होए, ते वी बिहाव नी करेगों, अर न बिहाव म दियो जाएगो, पर स्वर्ग दूत हुन को जसो हो जायेगो। ");
INSERT INTO hlb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","मरीया वाला हुन को जिन्दो होनू को बारे म काहे तुम न मूसा को किताब म झाड़ी कि कायनी म नी पढियो कि परमेस्वर न ओसे कय्हो, ‘मी तुमरो खानदान अब्राहम को परमेस्वर, अर इसहाक को परमेस्वर, अर याकूब को परमेस्वर आय’? ");
INSERT INTO hlb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","परमेस्वर मरीया वाला हुन को नी पर जिन्दा वाला हुन को परमेस्वर हैं; अब: तुम बड़ी भुल म पड़िया हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","मूसा को नेम ख सासतिरी म से एक न आका उनकी निन्दा करते सुनियो, अर यू समझ ख कि ओ न उनका चोक्खो रीति से जवाब दियो, ओसे पुछियो, “सबसे मेन आग्या कोन सो हैं?” ");
INSERT INTO hlb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","यीसु न ओखा जवाब दियो, “सब नियम हुन म से यू मेन हैं: ‘अरे इस्राएल सुन! प्रभु हमारो परमेस्वर एक ही हैं, ");
INSERT INTO hlb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","अर तू प्रभु अपनो परमेस्वर से अपनो पुरो मन से, अर अपनो पुरो सरीर से अर अपनी पुरी बुध्दी से अर अपनी पुरी सक्ती से प्रेम रखजे’ ");
INSERT INTO hlb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","अऊर दुसरी या वाली हैं ‘तु अपनो पड़ोसी से अपनो जसो प्रेम रखजो,’ ये से बड़ो अऊर कोइ आग्या नी हाय।” ");
INSERT INTO hlb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","मूसा नेम सासतिरी न ओसे कय्हो, “अरे गुरू, बेजा चोक्खो! तुना सच्ची-सच्ची बोलयो कि उ एक ही हैं। अर ओखा छोड़ का अऊर कोई परमेस्वर नी हाय। ");
INSERT INTO hlb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","अऊर ओसे पुरो मन, अर पुरी बुध्दी, अर पुरो सरीर अर पुरी सक्ती को संग म प्रेम रख जे अऊर पड़ोसी से अपनो जसो प्रेम रखजे; पुरी होमबली हुन अर बलिदान हुन से बढका हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","जब यीसु न देखियो कि ओ न समझ ख जवाब दियो हैं, ते ओसे बोल्यो, “तू परमेस्वर को राज से दुर नी हाय।” अर कोइ ख फिर ओसे पूछन की हिम्मत नी भयी। ");
INSERT INTO hlb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","फिर यीसु न मन्दिर म प्रवचन करते बखत असो कय्हो, मूसा ख नेम ख सासतिरी कसा बोला हैं कि मसी दाऊद को पोरिया आय? ");
INSERT INTO hlb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","दाऊद न अपनो तुम ही सुध्द आत्मा म होका कय्हो हैं: प्रभु न मोरो प्रभु से बोल्यो, “मोरो दाहिनो बैठ, जब तक कि मी तोरा बैरी हुन ख तोरो पाय को तला नीचु नी झुका देहु।” ");
INSERT INTO hlb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","दाऊद ते खुद ही ओखा प्रभु बोला हैं; फिर उ ओको पोरिया कसो भयो? अर भीड़ ख अदमी खुसी से सुनत रह। ");
INSERT INTO hlb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ओ न अपनो संन्देस म उनखा कय्हो, सासतिरी हुन से चलाक रहनु, जे लम्बो-लम्बो कपड़ा पहिनो ख घुमनो अर बजार म नमस्कार, ");
INSERT INTO hlb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","अऊर प्रार्थना घर म अच्छी-अच्छी जगह अऊर खाना म चोक्खो स्थान भी चाहवा हैं। ");
INSERT INTO hlb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","वी विधवा हुन को घर को धन ख लुट लेवा हैं, अर दिखान को लाने बडी देर तक बिनती करते जावा हैं। यी सबसे ज्यादा दण्ड पाहे। ");
INSERT INTO hlb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","यीसु मन्दिर की दान पेटी को सामे बैठ ख देखत रह, कि अदमी भण्डार म कसो तरीका से दान डाला हैं; अर बेजा सारा धनवान हुन न बेजा कुछ डाल्यो। ");
INSERT INTO hlb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","इत्तो म एक कंगाल बाँझ न आ ख दो दमड़ी हुन जो एक अधेला को बराबर होवा हैं डाली। ");
INSERT INTO hlb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","तब ओ न अपना चेला हुन ख पास म बुलाय ख उनसे कही; “मी तुम ख सच्ची बोलू हैं। मन्दिर की दान पेटी म; डालन वाला हुन म से या कंगाल बाँझ न सबसे बड ख दान डाल्यो हैं। ");
INSERT INTO hlb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","काहेकि सब न अपनी धन कि बढती म से ड़ाल्यो हैं। पर ये ना अपनी घटती म से जो कुछ भी ओको हतो रह एको मतलब अपनी सबरी कमई म से ड़ाल्यो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","जब उ मन्दिर से निकल्यो रह, ते ओखा चेला म से एक न ओसे कही, “अरे गुरू, देख कसो बड़ो पत्थर अर कसो बड़ो भवन हैं!” ");
INSERT INTO hlb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","यीसु न ओसे कय्हो, “का तुम यी बड़ा-बड़ा मन्दिर देखा हैं: यहाँ पर पत्थर पर पत्थर भी बचीया नी रहन का जो गीड़ायो नी जान को।” ");
INSERT INTO hlb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","जब उ जैतून का टेकड़ा पर मंदिर को सामने म बठो हतो, ते पतरस अर याकूब अऊर यूहन्ना अऊर अन्द्रियास न अकेलो म जा ख ओसे पुछियो ");
INSERT INTO hlb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“हमका बता कि या बात कब होए? अर जब या बात पुरी होन पर होए, उत्ती बखत को कोन सो चिन्ह होये?” ");
INSERT INTO hlb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","यीसु उन ख कहन लग गयो, सतरक रहनू कि कोई तुम ख चुंगल म नी फसा ले। ");
INSERT INTO hlb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ढ़ेर सारा मोरो नाम से आका तुमका कहे कि मी उयी आय! अर ढ़ेर सारा ख भैय्या देहे, ");
INSERT INTO hlb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","जब तुम लड़ाई पर लड़ाई हुन कि बात सुने, ते घबरा मत जानो, काहेकि येको होनू तो जरुरी हैं पर उत्ती बखत अंत नी होन को। ");
INSERT INTO hlb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","काहेकि जात पर जात अर राज पर राज चढ़ाई करेगों। सब जगा म भूकम्प होए अर अकाल पड़े। उत्ती बखत तो दुख को आनो ही होए या पहली दुख कि पीड़ा को जसो हैं। ");
INSERT INTO hlb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","पर तुम खुद को बारे म समझ ख रहनु; काहेकि अदमी हुन तुमका बड़ी-बड़ी सभा म सोपेगो अऊर तुम पंचायत हुन म मार खाए, अऊर मोरो लाने मुनिम हुन अऊर राजा हुन को सामे खड़ा करा जाहे, ताकि उनको लाने गवाई होए। ");
INSERT INTO hlb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","पर जरुरी हैं कि पहले अच्छो समाचार सब जात म प्रचार करो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","तब वी तुम ख लेजा ख सोपे, ते पहले से चिन्ता मत करनु कि हम का कहे; पर जो कुछ भी तुम ख बोलनू हैं उत्ती बखत बतायो जाहे उई बोलनू; काहेकि बोलन वाला तुम नी होन का सुध्द आत्मा हैं। ");
INSERT INTO hlb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","वी दिन म भई ख भई अऊर बाप ख पोरिया मार खलान को लाने सोपे अऊर पोरिया पारी माय-बाप को बारे (विरोध) म उठ ख उनका मरवा ड़ालेगो। ");
INSERT INTO hlb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","अर मोरो नाम को लाने सब झन तुम से घुस्सा करे। पर जो आखरी तक धीरज धरो रहे, ओको ही उध्दार होयगो। ");
INSERT INTO hlb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“एकोलाने : जब तुम वा उजाड़न वाली घृनित चीज ख जहाँ उचित नी हाय वाहा पर ओखा खड़ी देखे, (पढन वालो समझ लेहे) तब जे यहूदिया म हैं, वी पहाड़ हुन पर भग जाय; ");
INSERT INTO hlb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","जो छत पर रहे, उ अपनो घर म कुछ लेन ख लाने नीचू नी जानो चाहिए अर भीतर नी जानो चाहिए; ");
INSERT INTO hlb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","अर जे खेत म रहे, उ अपनो कपड़ा लेन ख लाने पीछु नी लउटन का। ");
INSERT INTO hlb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","उ दिन म जो पेट से रहे अर दुध पिलात होए, उनको लाने धितकार! ");
INSERT INTO hlb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","अर विनती कियो कर असो ठण्ड को बखत नी होनो चाहिए।” ");
INSERT INTO hlb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","काहेकि वी दिन असा दुख ख होये कि पृथ्वी को सुरु से, जे परमेस्वर न बनायो हैं, अभी तक नी भयो न फिर कभी होन को। ");
INSERT INTO hlb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","अदि प्रभु वी दिन ख नी घटातो, ते कोई भी इंसान नी बचावत पर वी दिन चुनीया वाला हुन ख लाने जिनखा ओ न चुनियो हैं, वी दिन ख घटायो हैं। ");
INSERT INTO hlb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“उत्ती बखत, कोइ तुम से बोले, ‘देख, मसी यहाँ पर हैं!’ या, ‘देख, वहाँ पर हैं!’ ते भरोसा मत करनु। ");
INSERT INTO hlb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","काहेकि झुटा मसी अर झूटा भविस्यवक्ता निकल्या हैं अर चिन्ह अर अदभुत काम दिखाहे कि अदि हो सका हैं ते चुनीया वाला हुन का भैय्या देहे।” ");
INSERT INTO hlb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","पर तुम सतर ख रहनु; देखो मी न तुमका सबरी बात बता दियो हैं। ");
INSERT INTO hlb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","उ दिन हुन म, उ दुख को बाद सूरज अंधेरो जसो हो जाहे, अर चाँद उजाला नी देन को; ");
INSERT INTO hlb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","अर आकास ख तारा हुन गिड़न लग जाहे, अर बादल कि सक्ति हुन हिलायी जाहे। ");
INSERT INTO hlb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","तब इंसान हुन इंसान को पोरिया ख बड़ी सक्ति अर मेहमा को संग बददल म आते देखेगो। ");
INSERT INTO hlb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","उत्ती बखत उ अपना स्वर्ग दूत हुन ख भेजेगो अर, दुनिया को यू सिरा से दुनिया को उ सिरा तक चारी दिसा हुन से अपना चुनीया वाला विस्वासी हुन ख एक जगा म जोडेगो। ");
INSERT INTO hlb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“अंजीर को झाड़ से यू उदाहरन सिखो जब ओकी डगियान हुन से कोम नीकलन लग जावा हैं” अर पत्ता निकलन लग जावा हैं, ते तुम जान लेवा हैं, कि बरसात को टेमं आएँगो हैं। ");
INSERT INTO hlb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","असोईच ही तरीका से जब तुम असी बात हुन ख होते देखे, ते समज लेव कि उ नजीक म हैं वरन दुवार को जोने ही हैं। ");
INSERT INTO hlb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","मी तुम से सच्ची बोलू हैं। कि जब तक या सब बात पुरी नी हो जान की तब तक या पिडी ख अदमी मरन का नी ");
INSERT INTO hlb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","आकास अर धरती टल जाहे, पर मोरी बात कभी नी टलन कि। ");
INSERT INTO hlb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","उ दिन या उत्ती बखत को बारे म कोई नी जाना कि कब आहे, न स्वर्ग दूत अऊर न पोरिया; पर सिर्फ परमेस्वर बाप। ");
INSERT INTO hlb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“देखो, जगते अर तैयार रहनु; काहेकि तुम नी जाना कि वा बखत कब आहेगो। ");
INSERT INTO hlb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","या उ अदमी कि सी दसा हैं। जो परदेस जाती बखत अपनो घर छोड़ ख जावा; अर अपना नउकर हुन ख अधिकार देवा हैं: अर हर एक ख उनको काम बता देवा अऊर दुवार पालिन ख जगते रहन को हुकुम देवा हैं। ");
INSERT INTO hlb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","एकोलाने जगते रहनू, काहेकि तुम नी जाना की घर को मालिक कब आहेगो, साँम ख या आधी रात ख या मुर्गा को बाँग देन को बखत या भुनसारो ख, या दिन नीकलन को बखत। ");
INSERT INTO hlb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","असो नी होवा कि उ तुमका अचानक आका तुमका सोते देखे ");
INSERT INTO hlb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","अऊर जोमी तुम से बोलू हैं, वई बात सब से बोलू हैं: जगते रहनो।” ");
INSERT INTO hlb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","दो दिन को बाद म फसह अर अखमीरी रोटी को तिहार होन वालो हतो रह। बड़ा पुजारी अर सासतिरी या बात की ताक म पड़िया हता कि ओखा कसो छल-कपट को संग म पकड़ ख मार ड़ाले; ");
INSERT INTO hlb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","पर बोलत रह, “तिहार को दिन नी कही असो नी होय कि अदमी हुन म लड़ई झगड़ा होन लग जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","जब उ बैतनिय्याह म समोन कोढी को घर म खाना खान ख बैठियो हतो रह, तब एक बाई न संगमरमर को बर्तन म जटामासी को सबसे महेगो खुब मेहकन वालो सुध्द तेल (इतर) लेका आई; अर बर्तन टोड़ ख इतर ओको मुण्ड पर उण्डेलीयो। ");
INSERT INTO hlb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","पर कोइ-कोइ अपनो मन म गुस्सा होका कहन लग गया; “यू महेगो खुब मेहकन वालो तेल (इतर) को काहे ख नास दुस करो? ");
INSERT INTO hlb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","काहेकि कि यू इतर तो तीन सव रोज कि दीनार से भी जादा म बेच ख गरीब हुन म बाट दियो जातो। अर वी ओखा हिड़कन लग गया।” ");
INSERT INTO hlb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","यीसु न उनसे कही, “कि ओखा छोड़ देव; ओ ख काहे सतावा हैं ओ न तो मोरो संग म काम भलो करो हैं। ");
INSERT INTO hlb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","गरीब हुन तुमारो संग म सदा रहे अर जब तुम चाहे तब उनको संग म रहे वी भलो कर सका हैं; पर मी तुमारो संग म सदा नी रहन को। ");
INSERT INTO hlb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","जे कुछ भी वा कर सकत रह ओ न करियो, ओ ना मोरो गाड़ो जान कि तैयारी म पहले से मोरो सरीर म इतर मलो हैं। ");
INSERT INTO hlb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","मी तुम ख सच्ची बोलू हैं कि सारो संसार म जहाँ कही भी सुभ समाचार प्रचार करो गयो हैं वहाँ ओको यू काम कि बात भी ओखा याद करन ख लाने करी जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","तब यहूदा इस्करियोती जे बारा म से एक हतो रह, सबसे बड़ा पुजारी हुन को पास गयो कि यीसु ख उनको हात म पकड़वाहे। ");
INSERT INTO hlb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","वी यू सुन ख बड़ा खुसु भयो, अर ओखा पैसा देन को लाने वादा कियो अर वी तैयार हो गया; अर यहूदा इस्करियोती मऊका ढुढ़न लग गयो कि यीसु का कसो तरीका से पकड़ा देहु। ");
INSERT INTO hlb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","अखमीरी रोटी को तिहार को पहलो दिन, जेमा वी फसह को बलिदान चढ़ात रह, ओखा चेला हुन न ओसे पुछो, “तु किते चाहवा हैं कि हम जाका तोरो लाने फसह खान कि तैयारी करे?” ");
INSERT INTO hlb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","यीसु न अपना चेला हुन म से दो ख असो कैय ख भेजियो, “सहर म जाव, अऊर एक अदमी पानी को मटका लेका, तुमका मिलेह, ओको पिछु हो लेनू। ");
INSERT INTO hlb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","अर उ जे घर म जाहे उ घर को मालीक से कहनु, गुरू न कय्हो हैं कि मोरी पाऊँनचारी को घर जेमा मी अपना चेला हुन को संग फसह खाऊँ किते हैं? ");
INSERT INTO hlb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","उ तुमका एक अर तैयार करी कराई बड़ी ऊपर वाली अटारी दिखाहे, वही अपनो लाने तैयार करनु।” ");
INSERT INTO hlb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","चेला हुन निकल ख यरूसलेम सहर म आया, अर जसो ओ न उनका कय्हो हतो, वसो ही मिल्या अर फसह को खाना तैयार करो। ");
INSERT INTO hlb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","जब साँम भई ते यीसु बारा चेला हुन को संग म आयो। ");
INSERT INTO hlb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","जब वी बैठ ख खाना खात रह हता, ते यीसु न कय्हो, “मी तुम से सच्ची बोलू हैं। कि तुममा से एक जो मोरो संग खाना खा रयो हैं, उ मोरा दुसमन हुन को हात मोखा पकड़वाहे।” ");
INSERT INTO hlb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","उनको मन उदास सो हो गयो, अर वी एक-एक कर ख ओसे कहन लग गया, “का उ मी आय प्रभु?” ");
INSERT INTO hlb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","यीसु न उन ख कय्हो, “उ बारा म से एक आय जो मोरो संग कटोरा म हात ड़ाला रोटी ख खावा हैं। ");
INSERT INTO hlb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","काहेकि इंसान को पोरिया तो जसो ओको बारे म लिखो हैं, उ जाते ही रहे; पर उ अदमी पर धितकार जोको दुवारा अदमी को पोरिया पकड़वायो जाहे: अदि उ अदमी को जनम ही नी होतो ते भलो रहतो।” ");
INSERT INTO hlb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","यीसु न रोटी लियो, अर परमेस्वर ख धन्यवाद देका टोड़ियो, फिर उनका कय्हो “लेव यू मोरो सरीर आय।” ");
INSERT INTO hlb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","फिर यीसु न अंगूर को रस लेका परमेस्वर ख धन्यवाद दियो अर चेला हुन ख दियो; अर वी सब न ओमा से पीयो। ");
INSERT INTO hlb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","अर यीसु न उनका कय्हो “यू वादा को मोरो खून आय, जो ढ़ेर झन को लाने बहायो जावा हैं। ");
INSERT INTO hlb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","मी तुमरो से सच्ची बोलू हैं कि अंगूर को रस उ दिन तक फिर कभी नी पीवन को, जब लक परमेस्वर को राज म नयो दाखरस नी पीऊ।” ");
INSERT INTO hlb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","फिर वी भजन गा ख बाहर जैतून को पहाड़ पर गयो। ");
INSERT INTO hlb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","तब यीसु न उनसे कय्हो, “तुम सब मोखा छोड़ ख भग जाहे, काहेकि लिखो हैं: ‘मी रखवालो ख मारुँगो, अर भेड़ हुन तितिर-बितर हो जाहे।’ ");
INSERT INTO hlb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“पर मी मोरो जिन्दो होन को बाद तुम से पहले गलील ख जाऊ।” ");
INSERT INTO hlb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","पतरस न ओसे कही, “अदि सब तोरो इंकार करे ते करे, पर मी इंकार नी करन को।” ");
INSERT INTO hlb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","यीसु न पतरस से कही, “मी तोसे सच्ची कहू हैं, कि आज कि रात ख मुर्गा को दो बार बासनो से पहले, तू तीन बार मोसे मूँह कर लेहे।” ");
INSERT INTO hlb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","पर पतरस अऊर भी हिम्मत से कय्हो, “अदि मोखा तोरो संग म मरनू भी पड़े तेभी मी तोरो इनकार कभी नी करन को।” एको जसो अऊर सब न भी कय्हो। ");
INSERT INTO hlb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","फिर वी गतसमनी नाम की एक जगा म आया, यीसु अपना चेला हुन से कय्हो, “यहाँ बठिया रहनु, जब तक मी बिनती करु हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","अऊर उ पतरस अर याकूब अर यूहन्ना ख अपनो संग म ले गयो; अर बेजा ही अधीन अर बेचैन होन लगीयो, ");
INSERT INTO hlb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","अर ओ न कही, “मोरो मन बेजा उदास हैं, असो लगा हैं कि मी मरन पर हैं: तुम यहाँ रुखियाँ रहनो, अर जगते रहनो।” ");
INSERT INTO hlb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","फिर उ थोडो आगे बढ़ीयो, अर जमीन पा गिड ख बिनती करन लगिया गयो कि अदि हो सका हैं ते या दुख कि घड़ी मोरो ऊपर से टल जाय ");
INSERT INTO hlb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","अर कही, “अरे बाप, अरे भगवान, तोसे सब कुछ हो सका हैं; यू दुख को पियाला ख मोरो सामे से हटा ला तेभी जसो मी चाहूँ हैं वसो नी, पर जो तू चाहवा हैं वसो ही होय।” ");
INSERT INTO hlb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","फिर उ आयो अर उनका सोते देख का पतरस से कय्हो, “अरे समोन, तू सो रयो हैं? का तू थोड़ी देर भी नी जग पायो? ");
INSERT INTO hlb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","जगते अर बिनती करते रहनो कि तुम परीक्छा म नी पड़न का। आत्मा तो तैयार हैं, पर सरीर कमजोर हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","अर उ फिर चलो गयो, अर वीच सब्द हुन से बिनती करयो। ");
INSERT INTO hlb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","फिर आका उनका सोते देखियो, काहेकि उनकी आँख नींद से भरी हती रह; अर नी जानत रह कि ओखा कसो जवाब देहे। ");
INSERT INTO hlb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","फिर तीसरो बार आका उन ख कय्हो, “अब सोते रहो अर आराम करो, बस, वक्त आ गयो; देखो इंसान को पोरिया पापी हुन ख हात पकड़वायो जाहे। ");
INSERT INTO hlb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","उठो, चलो! देखो, मोरो पकडान वालो नजीक म आ गयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","यीसु यू बोलत ही रह, कि यहूदा जो बारा हुन म से एक हतो रह, अपनो संघ म बड़ा पुजारी (प्रधान याजक) हुन अर सासतिरी अर सियाना कि तरफ से एक बड़ी भीड़ लेका तुरत आ पहुँचियो, जे तलवार अर लकड़ी हुन लियो हता। ");
INSERT INTO hlb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","यहूदा न यू पता दियो रह कि जोको मी चुम्मा लेहूँ उयी होयगो, ओखा पकड ख ले जानो। ");
INSERT INTO hlb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","उ आयो अर तुरत ओको कने जाय ख कय्हो, “गुरू!” अर ओखा चुमियो। ");
INSERT INTO hlb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","तब उन न ओ ख पकड़ लियो, अर बाँध लियो। ");
INSERT INTO hlb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","उनमा से जो पास खड़ा हता, एक न तलवार खीच का बड़ो पुजारी को नउकर पर चलायो, अर ओको कान काँट दियो। ");
INSERT INTO hlb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","यीसु न उनसे कही, “काहे तुम मोखा ड़ाकू समझ ख मोखा पकड़न को लाने तलवार हुन अर लट हुन संग म लेका नीकल्या हैं? ");
INSERT INTO hlb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","मी तो रोज दिन मन्दिर म तुमरो संग रह ख सिक्छा देते जात रह, अर तब तुमना मोखा नी पकड़ीयाँ: पर यु ऐखा लाने भयो कि सुध्द सास्र को लिखो पूरो होय।” ");
INSERT INTO hlb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","असो पर सब चेला हुन ओखा छोड़ख भग गया। ");
INSERT INTO hlb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","एक जवान अपनो नंगो सरीर म चद्दर ओढियो ओको पिछु चलो गयो; अर इंसान हुन न ओखा पकड़ो। ");
INSERT INTO hlb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","पर उ चद्दर छोड़ख नंगो भग गयो। ");
INSERT INTO hlb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","फिर उनना यीसु ख बड़ो पुजारी (महायाजक) को कने ले गयो; अर सब मुखिया हुन (प्रधान याजक) अर ओसे भी सियाना अर मूसा को नेम ख सासतिरी ओको यहाँ पर जुड गया। ");
INSERT INTO hlb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","पतरस दुर ही दुर से ओको पिछु-पिछु बड़ो पुजारी को आँगन को भीतर तक गयो, अर पैदल चलन वाला सिपाई को संघ बैठ ख आग तापन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","बड़ो पुजारी अर यहूदी हुन कि बड़ी सभा यीसु ख मार ड़ालन ख लाने ओको बारे म गवाई ख ढुढत रह, पर नी मिल्या। ");
INSERT INTO hlb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","काहेकि बेजा सारा ओको बारे म झूठी गवाई देत रह, पर उनकी गवाई एक जसी नी हती। ");
INSERT INTO hlb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","तब कुछ अदमी हुन न उठ ख यीसु को बारे म या झूठी गवाई दी, ");
INSERT INTO hlb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“उन न ओसे कय्हो हम न ऐका यू कहते सुनियो हैं, मी यू हात को बनायो हुयो मन्दिर ख मिटा देहु, अर तीन दिन म दुसरो बना देऊ, जो हात से नी बनयो होए।” ");
INSERT INTO hlb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","असो पर भी उनकी गवाई एक जसी नी निकल। ");
INSERT INTO hlb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","तब बड़ो पुजारी न बीच म खड़ो हो ख यीसु से पुछियो; “तू कोइ जवाब काहे नी देवा? यी अदमी हुन तोरो बारे म का गवाई देवा हैं?” ");
INSERT INTO hlb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","पर उ चुप चाप रयो, अर कुछ जवाब नी दियो। बड़ो पुजारी (महायाजक) न फिर पुछियो, “का तू उ परम धन्य को पोरिया (पोरिया) मसी आय?” ");
INSERT INTO hlb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","यीसु न कय्हो, “मी आय: अर तुम इंसान को पोरिया ख सर्व सक्ति मान को दाहिनी तरफ बठियो, अर आकास को बददल हुन को संग आते देखेगो।” ");
INSERT INTO hlb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","तब बड़ो पुजारी न अपनो कपड़ा फाड़ ख कय्हो, “अब हमका गवाह हुन को का काम हैं?” ");
INSERT INTO hlb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","तुमना या बुराई सुनियो। “तुम्हारी का राय हैं?” उन सब न कय्हो कि यू मोत की सजा देन को लायक हैं। ");
INSERT INTO hlb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","तब तो कोइ ओपर थूकन, अर कोई ओको मुंडो ढाँकन अर ओखा मुक्का मारन, अर ओसे कहन लगया, “भविस्यवानी कर!” अर सिपाई हुन न ओ ख पकड़ ख थप्पड़ मरिया। ");
INSERT INTO hlb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","जब पतरस नीचु आँगन म हतो, ते बड़ो पुजारी महायाजक की दासी म से एक से वहाँ आई, ");
INSERT INTO hlb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","अर पतरस ख आग तापते देख ख ओ ख टकटकी लगा ख देखयो अर कहन लग गई, “तु भी तो उ यीसु नासरी को संघ म हतो।” ");
INSERT INTO hlb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ओ न मुंडो कर लियो, अर कय्हो, “मी नी जानू अर न मी समझू हैं कि तू का बोला हैं।” फिर उ बाहर परेल (डेवढ़ी) पर गयो; अर मुर्गा न बाँग दियो। ");
INSERT INTO hlb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","वा नऊकरानी (दासी) ओखा देख ख उन ख जे सामे खड़ीयाँ हता, फिर कहन लग गई, “यू उनमा से एक आय।” ");
INSERT INTO hlb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","पर ओ न फिर मुढो कर लियो। थोड़ी देर को बाद उन ना जे ओको नजीक म खड़ा हता फिर पतरस से कय्हो, “मोखा सच्ची म पुरो भरोसा (निस्चय) हैं कि तू उनमा से एक आय; काहेकि तू गलीली भी आय।” ");
INSERT INTO hlb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","तब उ परमेस्वर कि कसम खान लगयो, “मी उ अदमी ख, जोकी तुम चर्चा करा हैं नी जानू।” ");
INSERT INTO hlb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","तब तुरत दुसरो बार मुर्गा न बाँग दियो। पतरस ख वा बात जे यीसु न ओसे कही रह ध्यान अई: “मुर्गा को दो बार बाँग देनो से पहले तू तीन बार मोरो इनकार करे।” अर उ या बात ख सोच ख फुट-फुट क रोन लगयो। ");
INSERT INTO hlb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","भुनसारो होते ही तुरत बड़ा मुखिया पुजारी, (प्रधान याजको) सियाना हुन, अर मूसा को नेम ख सासतिरी, अर फरीसी कि सभा न सलाह कर ख यीसु ख बन्धवायो, अर ओखा ले जाय ख पिलातुस को हात म सोउप दियो। ");
INSERT INTO hlb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पिलातुस न ओसे पुछियो, “का तू यहूदी हुन को राजा आय?” यीसु न ओखा उत्तर दियो, “तू खुद ही बोला हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","बड़ा पुजारी हुन ओपर बेजा सारी बात हुन को दोस लगात रह। ");
INSERT INTO hlb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","पिलातुस न ओसे पुछियो, “का तू कुछ जवाब नी देवा, देख यी तोपर कित्ती बात को आरोप लगावा हैं?” ");
INSERT INTO hlb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","यीसु न फिर कुछ जवाब नी दियो; यहाँ तक कि पिलातुस ख बड़ो आस्चर्य भयो। ");
INSERT INTO hlb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","पिलातुस उ तिहार म कोई एक बन्धियो का जेखा वी चाहवा हैं, उनको लाने छोड़ देत रह। ");
INSERT INTO hlb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","बरअब्बा नाम को एक इंसान ख भी चोरी करन वाला (बलवाइयो) को संग म बन्धियो हतो, जेना रोमी सासन को विरोध म लड़ाई म हत्या करी रह। ");
INSERT INTO hlb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","अर भीड़ ऊपर जा ख ओसे बिनती करन लग गई, कि जसो तू हमारो लाने रीति-रिवाज को अनुसार करते आयो हैं वसो ही कर। ");
INSERT INTO hlb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","पिलातुस न उनका जवाब दियो, “का तुम चाहवा हैं, कि मी तुमरो लाने यहूदी हुन को राजा ख छोड़ देहु?” ");
INSERT INTO hlb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","काहेकि उ जानत रह, कि बड़ा पुजारी हुन न ओखा घुस्सा से पकड़ायो हैं। ");
INSERT INTO hlb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","पर पुजारी हुन न अदमी हुन ख उकसायो कि वी पिलातुस से माँगे की यीसु को बदला बरअब्बा ही ख उनको लाने छोड़े। ");
INSERT INTO hlb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","यू सुन ख पिलातुस न उनसे फिर से पुछियो, “ते जेखा तू यहूदी हुन को राजा बोला हैं, ओको संग मी का करु?” पिलातुस न फिर भीड़ से पुछो ");
INSERT INTO hlb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","वी फिर चिल्लाया, “ओखा सूली पर चढ़ा दे!” ");
INSERT INTO hlb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पिलातुस न उनका कय्हो, “काहे, येना का गुनाह करो हैं?” पर वी अऊर भी चिल्लाया, “ओखा सूली पर चढ़ा दा।” ");
INSERT INTO hlb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","तब पिलातुस न भीड़ ख खुस करन को लाने उनकी इच्छा से, अर बरअब्बा ख उनको लाने छोड़ दियो, अर यीसु ख कोड़ा मरवा ख सोप दियो कि सूली पर चढ़ायो जाय। ");
INSERT INTO hlb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","सैनिक हुन ओखा किला को भीतर को आँगन म ले गया जो किला भी कारखाना कहलावा हैं, अर पुरी पलटन ख बुला ख लाया। ");
INSERT INTO hlb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","तब उन न ओखा बैजनी रंग को कपड़ा पहनायो अर काटा कि डगियान को मुकुट गुथ ख ओकी मुंड पर धरयो ");
INSERT INTO hlb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","असो बोल ख ओखा हात जोड ख नमस्कार! करन लग गया, “अरे यहूदी हुन को राजा लम्बो बखत तक जितो रहे!” ");
INSERT INTO hlb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","वी ओकी मुंडी पा कोड़ा सरकण्डा मारत, अर ओपर थुकत रह, अर पाय मोढ़ ख ओसे हात जोड़त रह। ");
INSERT INTO hlb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","जब उन न ओको मजाक उड़ा लियो, ते ओपर से बैजनी रंग को कपड़ा उतार ख ओको ही कपड़ा पहिनायो; अर तब ओखा सूली पर चढ़ान को लाने बाहर ले गया। ");
INSERT INTO hlb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","सिकन्दर अर रुफुस को बाप समोन, एक कुरेनी इंसान, जे गाँव से सहर से आत रह उते से निकलियो; उन ना ओखा बेकार म पकड़ीयो कि ओको सूली उठा ख ले चले। ");
INSERT INTO hlb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","जिन्ना यीसु ख गुलगुता नाम की जगा म जोको मतलब हैं खोपड़ी कि जगह हैं, लाया। ");
INSERT INTO hlb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","वहाँ पर ओ ख मुर्र मिलो हुयो अंगूर को रस देन लगिया, पर ओ ना नी लियो। ");
INSERT INTO hlb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","तब उन न ओ ख सूली पर चढ़ायो अर ओको कपड़ा पर चिट्ठी हुन ड़ाल ख, कि कोन सो का का मिले, उन ना बाट लियो। ");
INSERT INTO hlb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","सुबेरो को बखत नव बजो रह, जब उन ना ओखा सूली पर चढ़ायो। ");
INSERT INTO hlb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","अर ओको उपर आरोप लिख ख ओको ऊपर लगा दियो गयो कि “यहूदी हुन को राजा”। ");
INSERT INTO hlb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","उन न ओको संग म दो ड़ाकू, एक ओको दहिनो हात बाजू एक ओको बायो बाजू सूली पर चढ़ायो। ");
INSERT INTO hlb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","तब उ सुध्दसास्र को उ वचन कि उ अपराधी हुन को संग म गिनो गयो, पुरो भयो। ");
INSERT INTO hlb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","अर रस्ता म जान वाला मुण्डी मटका मटका ख अर असो बोल का ओकी बुराई करत रह, “वाह! मन्दिर को गिड़ान वालो, अर तीन दिन म बनान वालो! ");
INSERT INTO hlb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","सूली म से उतर ख अपनो तुम ख बचा ल।” ");
INSERT INTO hlb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","असो तरीका से पुजारी हुन भी, सासतिरी हुन, एक दुसरो म मजाक से बोलत रह, “येना तो दुसरा ख बचायो, पर अपनो तुम ख नी बचा सकियो। ");
INSERT INTO hlb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","इस्राएल को राजा, मसी, अब सूली म से उतर आहे कि हम देख ख भरोसा करे।” अऊर जे ओको संग सूली हुन पर चढायो गया रह, वी भी ओकी बुराई करत रह। ");
INSERT INTO hlb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","दोपहर होते ही पुरो देस म अंधेरा सो हो गयो, अर तीसरो पहर तक हतो। ");
INSERT INTO hlb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","तीसरो पहर यीसु न बड़ी जोर से चिल्लाया ख कय्हो, “इलोई, इलोई, लबा सबक्तनी?” जोको मतलब यू हैं, “अरे मोरो परमेस्वर, अरे मोरो परमेस्वर, तुना मोखा काहे छोड़ दियो?” ");
INSERT INTO hlb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","जे पास म खड़ा हता, उनमा से कुछ न यू सुन ख कय्हो, “सुनो, यु एलिय्याह ख हाँका देवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","अर एक न दऊड ख एक पानी म रहन वालो जीव (स्पंज) ख सिरका म ड़ुबोयो, अर गाठदार सरपत को एक झाड़ (सरकण्डा) कि लकड़ी पर रख ख ओखा पिलायो (चुसायो) अर कय्हो “रुक जाव, देखे, एलिय्याह ओखा क्रूस पर से उतारन को लाने आवा हैं कि नी।” ");
INSERT INTO hlb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","तब यीसु न बड़ी आवाज से चिल्लाया ख जान छोड़ दियो। ");
INSERT INTO hlb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","अर मन्दिर को परदा ऊपर से नीचू तक फट ख दो टुकड़ा हो गयो। ");
INSERT INTO hlb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","जो अधिकारी क्रूस को सामे खड़ा हता, जब ओखा असो चिल्लाया ख जान छोड़ते देखियो, ते ओ न कय्हो, “सच्ची म यू इंसान परमेस्वर को पोरिया हतो!” ");
INSERT INTO hlb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","कई बाई हुन भी दूर से देखत रह: उन म मरियम मगदलीनी, छोटो याकूब अर योसेस कि माय मरियम, अर सलोमी हती। ");
INSERT INTO hlb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","जब यीसु गलील म हतो ते यी ओको पिछु हो लेत रह अर ओकी सेवा करत रह; अर कई ढ़ेर सारी बाई हुन हती, जो ओको संग म यरूसलेम ख आई रह। ");
INSERT INTO hlb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","जब साम हो गई ते एकोलाने कि तैयारी को दिन हतो, जो यहूदी हुन को आराम करन को दिन जे एक दिन पहले होवा। ");
INSERT INTO hlb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","अरिमतिया को रहन वालो यूसुफ आयो, जो बड़ी सबा (महासभा) को सदस्य हतो अर स्वंय भी परमेस्वर को राज कि रस्ता देखत रह। उ धीरज धर ख पिलातुस को पास गयो अर यीसु की लास सरीर माँगियो। ");
INSERT INTO hlb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","यू सुन ख पिलातुस का आस्चर्य भयो कि यीसु इत्तो झलदी मर गयो; अर ओ ना सव सैनिक को ऊपर हक रहन वालो (अधिकारी) ख बुला का पुछीयो, “काहे ओखा मरिया देर हो गई का?” ");
INSERT INTO hlb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","जब ओ न उई अधिकारी को दुवारा हाल जान लियो, ते लास यूसुफ ख दे दियो। ");
INSERT INTO hlb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","तब ओ न मलमल को एक चद्दर को कपड़ा मोल म लियो, अर लास ख उतार का उ चादर म लपेटियो, एक मरघट को गड्डा जो पत्थर को अन्दर काट ख बनायो हतो रह, अर मरघट जहाँ पर ओको सरीर धरीयो रह वहाँ पर पत्थर दरवाजा म लगा दियो ");
INSERT INTO hlb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मरियम मगदलीनी अर योसेस कि माय मरियम देखत रह कि ओको सरीर का कहाँ धरा हैं। ");
INSERT INTO hlb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","जब आराम करन को दिन बीत गयो ते, मरियम मगदलीनी, अर याकूब कि माय मरियम, अर सलोमी न अच्छो मेहकन वालो इतर मोल लेखा आया कि आ ख ओपर मलें। ");
INSERT INTO hlb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","हफ्ता को पहलो दिन बड़ी सुबेरे ख, जब दिन नीकलयो ही हतो, वी मरघट म अई, ");
INSERT INTO hlb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","अर एक दुसरी से असी बोलत रह, “हमारो लाने मरघट को दरवाजा से अन्दर जान को लाने पत्थर कोन बगल करे?” ");
INSERT INTO hlb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","जब उन न आँख उठाई, ते देखो कि पत्थर लुढ़को हैं उ बेजा बड़ो हतो। ");
INSERT INTO hlb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","मरघट को भीतर जाख उन न एक जवान ख सफेत कपड़ा पहिनियो दाहिनी तरफ बठीयो देखो, अर बेजा डर गई। ");
INSERT INTO hlb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ओ न उनसे कय्हो, “चकित मत होव, तुम यीसु नासरी ख जो सूली पर चढ़ायो गयो रह, ढुढ़ा हैं। उ जिन्दो हो गयो हैं, यहाँ नी हाय; देख लेव या वई जगा आय, जिते उन न ओखा रखियो रह। ");
INSERT INTO hlb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","अर तुम जाव अर ओखा चेला अर पतरस से कहनु कि उ तुमरा से पहलो गलील ख जाएगो। जसो ओ न तुम ख कय्हो रह, तुम वही पा ओ ख देखे।” ");
INSERT INTO hlb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","अर वी नीकल ख समसान घाट से भग गई; काहेकि कापनो अर घबरानो उनको भीतर समा गई रह; अर उन न कोई से कुछ नी कय्हो, काहेकि सच्ची म डर गई रह। ");
INSERT INTO hlb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","हफ्ता को पहलो दिन भुनसा सारा होते ही उ जिन्दो हो ख सबसे पहिले मरियम मगदलीनी ख जेमा सात भूत कि आत्मा हुन समाई हती रह, दिखाई दियो। ");
INSERT INTO hlb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ओ न जाख यीसु को संघ म रहन वाला हुन ख जो दुख म डुबीया हता अर रोवत रह, खबर दियो। ");
INSERT INTO hlb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","उन न असो सुन ख कि उ जिन्दा हैं अर उन न ओ ख देखो हैं, भरोसा नी करो। ");
INSERT INTO hlb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","येको बाद यीसु दुसरो रूप म उनमा से दो ख जब वी गाँव की तरफ जात रह हता दिखाई दियो। ");
INSERT INTO hlb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","उन न भी जाख दुसराझना ख खबर दियो, पर उन न उनको भी भरोसा नी करयो। ");
INSERT INTO hlb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ओको पिछु उ वी ग्यारह हुन ख भी, जब वी खाना खान बठीया हता दिखो रह, अर उनको सक करनु अर मन को ड़ीट पन को वजेसे (उलाहना) गवई दियो, काहेकि उनना ओको जिन्दो होनू को बाद ओखा देखियो रह, इनना ओको अविस्वास करयो हतो। ");
INSERT INTO hlb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","अर ओ न उन ख से कय्हो, “तुम पुरो संसार म जाख पुरी दुनिया ख इंसान हुन ख सुभ समाचार कि खबर सुनाव। ");
INSERT INTO hlb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","जे भरोसा करे अर बपतिस्मा लेहे ओको ही उध्दार हो हे, पर जो भरोसा नी करन को उ दोसी ठहरायो जाहे; ");
INSERT INTO hlb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","भरोसा करन वाला हुन कि यू चिन्ह होए कि वी मोरो नाम से भूत हुन ख निकाले, नई नई भासा बोलेगो ");
INSERT INTO hlb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","अदि वी साँप हुन ख उठा लेहे, अर अदि कोई ओखा धोका से जहर भी पिला देहे ते ते भी ओको कुछ नुकसान नी होन को; वी बीमार हुन पर हात धरेगो, अर वी अच्छा हो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","प्रभु यीसु उन से बात करन को बाद स्वर्ग म उठा लियो गयो, अर परमेस्वर को दाहिनी तरफ बैठ गयो ");
INSERT INTO hlb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","अर उन न नीकल ख हर जगा म प्रचार सुनायो, अर प्रभु उनको संघ म काम करते रहयो अर वी चमतकारी निसान को व्दारा जे संग-संग म होत रह हता वचन ख मजबुत करते रयो। आमीन।");
INSERT INTO hlb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ड़ेर सारा न वी बात हुन को जो हमारो बीच म बिती हैं, इतिहास लिखनो म हात लगायो हैं, ");
INSERT INTO hlb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","जसो कि उनना जे पहलो से ही या बात हुन ख देखन वाला अर वचन ख सेवक हता, हमारो तक पहुँचायो। ");
INSERT INTO hlb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ऐका लाने, हे सिरीमान थियुफिलुस मो ख भी यू चोक्खो मालूम भयो कि वी सब बात को पुरो हाल सुरू से सही-सही जाँच कर ख, उन ख तोरो लाने गिनती को अनुसार लिखू ");
INSERT INTO hlb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ताकि तू यू समझ लेहे कि वा बात जिनकी तू न सिक्छा सिखो हैं, कसी अटल हैं। ");
INSERT INTO hlb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यहूदिया को राजा हेरोदेस को बखत म अबिय्याह को दल म जकरयाह नाम को एक याजक हतो, अर ओकी घरवाली हारून ओकी वंस की हती जेको नाम इलीसिबा हतो। ");
INSERT INTO hlb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","वी दो ही परमेस्वर को सामने धर्मी हता, अर वी प्रभु की सारी बात अर आग्या पर बेकसूर चलन वाला हतो। ");
INSERT INTO hlb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","पर ओको कोई भी आवलाद नी हती, काहेकि इलीसिबा बाँझ हती, अर वी दोई ही बूढ़ा हता। ");
INSERT INTO hlb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","जब उ अपनो दल कि पारी पर परमेस्वर को सामे याजक को काम करत रहा हतो, ");
INSERT INTO hlb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ते उ याजक हुन की रीति को अनुसार ओको नाम पर की चिठ्टी निकली की प्रभु को मन्दिर म जा ख धूप जलायो। ");
INSERT INTO hlb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","अऊर धूप जलान को बखत म इंसान हुन की पुरी मण्डली बाहर प्रार्थना करत रह हती। ");
INSERT INTO hlb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ऊ बखत प्रभु को एक स्वर्गदूत धूप की वेदी की दाहिनी तरफ खड़ो भयो अर ओ ख दिखाई दियो। ");
INSERT INTO hlb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","जकरयाह स्वर्गदूत ख देख ख डर गयो अर भयभीत हो उठियो। ");
INSERT INTO hlb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","पर स्वर्गदूत न ओसे कय्हो, “अरे जकरयाह डर मत (घबरावा) नी हो, काहेकि तोरी प्रार्थना मिना सुन ली गई हैं; अर तोरी घरवाली इलीसिबा से तोरो लाने एक पोरिया पैदा होएगो, अर तू ओको नाम यूहन्ना रख। ");
INSERT INTO hlb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","जे तोखा खुसी अर आन्नद होएगो अर बेजा जन ओके जनम को कारन खुसी, होयगो ");
INSERT INTO hlb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","काहेकि उ प्रभु को सामने म बड़ो होऐ। उ अंगूर को रस अर दारू नी पीहे, पर अपनी माय ख पेट से ही सुध्द आत्मा से परिपूर्ण होऐ; ");
INSERT INTO hlb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","अर इस्राएली हुन म से ढ़ेर सारा इंसान ख उन ख प्रभु परमेस्वर कि तरफ वापस लेहे। ");
INSERT INTO hlb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","वी एलिय्याह की आत्मा अर सामर्थ्य म हो ख ओके आगु आगु चलोगो पितरो को मन बाल पोरिया हुन की ओर फेर देगो; अर बात नी माननू वाला ख धर्मी की समझ पर लाए अर प्रभु का लाने ईक योग्य प्रजा तैयार करेगों।” ");
INSERT INTO hlb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","जकरयाह न स्वर्गदूत से पुछियो, “यु मी कसो जानु? काहेकि मी तो सियानो हो गयो; अर मोरी घरवाली भी सियानी हो गई हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","स्वर्गदूत न ओ ख उत्तर दियो, “मी जिब्राईल आय, जो परमेस्वर को सामने खड़ो रहू; अर मी तो ख या बात करन अर तोखा यू सुसमाचार सुनान को लाने भेजो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","देख, जे दिन तक यू बात पुरी नी होऐ, उ दिन तक तू गुँगो रहे अर बोल नी सक काहेकि अपनो मोरी बात हुन ख जो अपनो बखत पर पूरो होवन वाली हैं, भरोसा नी करयो।” ");
INSERT INTO hlb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","वी लोग जकरयाह की बाट देखत रहा अर अचम्भा करन लगियो। ओ ख मन्दिर म इत्ती देर काहे लगी। ");
INSERT INTO hlb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","जब जकरयाह मन्दिर से बाहर आयो, ते उ बोल नी सकियो: एकोलाने: वी जान गया की ओ ना मंदिर म कोई सपना पाहे हैं; अऊर उ उन ख ईसारा करत रह, अर गुँगा रह गयो। ");
INSERT INTO hlb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","जब ओ की सेवा का दिन पुरा भयो, ते उ अपनो घर म चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","वी दिन को बाद म ओकी घरवाली इलीसिबा पेट से भई; अर पाँच महीना तक अपनो तुम ख यु कह ख लूका रखियो, ");
INSERT INTO hlb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“इंसान म मोरी नाम धराइ दुर करन को लाने, प्रभु न दिनो म मोरो ऊपर दया कर ख लाने असो करयो।” ");
INSERT INTO hlb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","छटवो महीना म परमेस्वर को तरफ से जिब्राईल स्वर्गदूत को, गलील नाम को नासरत सहर म, ");
INSERT INTO hlb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","एक कुंवारी को नजीक भेजो गयो जेकी मंगनी यूसुफ नाम दाऊद को घरानो को एक व्यक्ति से भई हती; वा कुँवारी को नाम मरियम हतो। ");
INSERT INTO hlb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","स्वर्गदूत न मरियम को पास अन्दर आयो अर कय्हो, “आन्नद अर जय तोरी होय जो पर प्रभु परमेस्वर को दया भयो हैं! प्रभु तोरो संग म हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","उ यू वचन से बेजा डर गई, अर सोचन लगी कि या कसी तरीका की आदर हैं? ");
INSERT INTO hlb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","स्वर्गदूत न ओसे कय्हो, “अरे मरियम, डरनू मत, काहेकि परमेस्वर को दया तो पर हुओ हैं। ");
INSERT INTO hlb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","देख तू पेट से होए, अर तोरा ख एक पोरिया पैदा होए; तू ओको नाम यीसु रख। ");
INSERT INTO hlb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","उ महान होएगो अर परमप्रधान परमेस्वर को पोरिया कहलायेगो: अर प्रभु परमेस्वर ओके बाप दाऊद को राज्य सिंहासन ओखा देगो, ");
INSERT INTO hlb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","अर उ याकूब को परिवार पर सदा करेगों अर ओको राज को अन्त नी होन को।” ");
INSERT INTO hlb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","मरियम न स्वर्गदूत से कय्हो “यु कसो होगो। मी न तो अदमी को जान ही नी हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","अर स्वर्गदूत न ओको उत्तर दियो सुध्द आत्मा तो पर उतरेगो, अर परमप्रधान परमेस्वर की सक्ति तो पर छाये करेगों: एकोलाने उ सुध्द जे पैदा होवन वाला हैं। परमेस्वर को पोरिया कहलाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","अऊर देखो, सायिनापन म तोरी कुटुम्बी हुन इलीसिबा ख भी, पोरिया होन वालो हैं। अब ओको, जे बाँझ कह हती, छटवा महीना हो रहो हैं; ");
INSERT INTO hlb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","काहेकि जे वचन परमेस्वर की तरफ से होवा हैं उ जबरदस्त रहित नी होवा। ");
INSERT INTO hlb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","मरियम न कय्हो “देख मी प्रभु की दासी आय, मोखा तोरो वचन का अनुसार होव।” एको बाद स्वर्गदूत ओखा जोने से चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","अऊर उन दिन हुन म मरियम उठ ख तुरत ही पहाड़ी सहर म यहूदा को एक मोहल्ला म गई, ");
INSERT INTO hlb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","अर जकरयाह को घर म जा ख इलीसिबा का प्रणाम करियो। ");
INSERT INTO hlb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","जसो ही इलीसिबा न मरियम को नमस्कार सुनियो, वसो ही पोरिया ओको पेट म उछलियो, अर इलीसिबा सुध्द आत्मा से भरपूर हो गई। ");
INSERT INTO hlb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","अर ओ ना बड़ी जोर से आवाज लगा ख कय्हो “तू ओरत हुन म धन्य हैं, अर तोरो पेट को फल चोक्खो हैं! ");
INSERT INTO hlb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","यु आसीर्वाद मोखा कहाँ से भयो कि मोरो प्रभु की माय मोरो पास आयी? ");
INSERT INTO hlb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","देख, जसो ही मीना तोरो नमस्कार को सब्द मोरे कान म पड़ियो, वसो ही पोरिया मोरो पेट म खुसी से उछल पड़ियो। ");
INSERT INTO hlb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","धन्य हैं वी जेना भरोसा करयो कि जे बात प्रभु की तरफ से कही गई रह, वा पुरो होय।” ");
INSERT INTO hlb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","तब मरियम न कय्हो, मोरो मन प्रभु की बड़ाई करा हैं ");
INSERT INTO hlb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","अर मोरी आत्मा मोरे उध्दार करन वालो परमेस्वर से खुस भई, ");
INSERT INTO hlb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","काहेकि ओ न अपनी दासी की दीनता पर नजर लगाई भई हैं; एकोलाने देख अब से सब युग-युग के लाने सब मोखा चोक्खो कहेगो, ");
INSERT INTO hlb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","काहेकि उ सक्तिमान प्रभु न मोरो लियो बड़ो-बड़ो काम कियो हैं। ओको नाम सुध्द हैं, ");
INSERT INTO hlb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","अर ओकी दया ओ पर जे ओसे डरत हैं उन पर उनकी पीढ़ी से पीढ़ी बनी हो रह हैं। ");
INSERT INTO hlb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ओ ना अपनो सक्ति दिखायो, अर जो अपनो तुम ख बड़ो समझत रह, उनखा तितिर बितर करयो। ");
INSERT INTO hlb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ओ ना बलसाली ख उनको सिंहासन हुन से गिरा दियो; अर गरीब लचार ख ऊँचो करयो। ");
INSERT INTO hlb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ओ ना भूखा इंसान ख चोक्खो खाना से उनको पेट भरयो, अर धनी हुन ख खाली हात हेड दियो। ");
INSERT INTO hlb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ओ ना अपनी सेवक इस्राएल ख समाल लियो, अर अपनी वा दया का याद करे, ");
INSERT INTO hlb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","जो अब्राहम अर ओको खानदान पर सदा बनी रहेगो, जसो ओ ना हमारो बाप दादा से कय्हो हतो। ");
INSERT INTO hlb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","मरियम करीब तीन महा ओको संग रह ख अपनो घर ख वापस गई। ");
INSERT INTO hlb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","तब इलीसिबा को पोरिया-पारी पैदा करन को बखत पुरो भयो, अर ओ ना पोरिया का जनम दियो। ");
INSERT INTO hlb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ओखा पड़ोसी हुन अर कुटुम्ब हुन न यु सुन ख कि प्रभु न ओको ऊपर बड़ी दया करियो हैं, ओको संग खुसी मनायो। ");
INSERT INTO hlb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","अर असो हुओ कि आठ दिन को बाद वी पोरिया का खतना देन ख आया अर ओको नाम ओको दादा को नाम पर जकरयाह रखन लग। ");
INSERT INTO hlb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","असो पर ओकी माय न जवाब दियो, “नी; ओको नाम यूहन्ना रखनू हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","उन ना ओसे कय्हो, “तोरो कुटुम्ब म कोई को यू नाम नी हाय!” ");
INSERT INTO hlb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","एकोबाद उन ना ओको दादा से इसारा कर ख पुछियो कि तू ओको का नाम रखनू चाहवा हैं? ");
INSERT INTO hlb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ओ ना लिखन की पठ्टी माँग ख लिख दियो, “ओको नाम यूहन्ना हैं,” अर सबका हैरानी भई। ");
INSERT INTO hlb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","एकोबाद ओखा मुँह अर जीभ तुरंत खुल गई; अर वी बोलन अर परमेस्वर का धन्यवाद करन लगयो। ");
INSERT INTO hlb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ओखा आजु बाजु को सब रहन वाला पर डर समा गयो; वचन की चर्चा यहूदिया के सारो देस म फैल पहाड़ी गई, ");
INSERT INTO hlb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","अर सब सुनन वाला न अपनो-अपनो मन म विचार कर ख कय्हो, “यु पोरिया कसो होगो?” काहेकि प्रभु का हात ओके ऊपर संग हतो। ");
INSERT INTO hlb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ओखा दादा जकरयाह सुध्द आत्मा से भर गयो, अर भविस्यवानी करन लगीयो: ");
INSERT INTO hlb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“प्रभु इस्राएल को परमेस्वर धन्य होय, काहेकि ओ ना अपन लोग हुन पर आँख लगायो हैं अर उनको छुटकारा करयो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","अर अपनो सेवक दाऊद का घराना म हमरो लाने एक उध्दार को लाने सींग निकालीयो; ");
INSERT INTO hlb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(जसो ओ ना अपना सुध्द भविस्यवक्ता हुन को व्दारा जे दुनिया को सुरू से होते आयो हैं, कहयो हतो) ");
INSERT INTO hlb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","एकोमतलब हमारो दुसमन हुन से, अर हमरो सब बैरियो का हात से हमारो उध्दार कियो हैं, ");
INSERT INTO hlb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","कि हमारो दादा पर दादा पर दया कर का अपनो सुध्द वादा का ध्यान करे, ");
INSERT INTO hlb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","अर वी कसम जो ओ ना हमारो पिता अब्राहम से खायो हती, ");
INSERT INTO hlb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","कि वी हमका उध्दार देगो कि हम अपनो दुसमन का हात से छुटियो, ");
INSERT INTO hlb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ओके सामन सुध्दता अर धार्मिकता से जीवन भर निडर रहकर ओकी सेवा करत रहू। ");
INSERT INTO hlb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","अर तू हे पोरिया, परमप्रधान को भविस्यवक्ता कहलाएगो, काहेकि तू प्रभु का रस्ता तैयार करन का लियो ओके आगु-आगु चलेगो, ");
INSERT INTO hlb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","कि ओके लोगो को उध्दार का ग्यान दे, जे ओके पाप हुन की छमा से प्राप्त होत हैं। ");
INSERT INTO hlb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","यू हमारो परमेस्वर की उ बड़ीयो दया से होए जेका लाने स्वर्ग से हमारो ऊपर भुसारो को उजरा होएगो, ");
INSERT INTO hlb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","कि अंधकार अर मृत्यु की छाव म बैठन वाला को ज्योति दे, अर हमारो पैरो का सान्ति रस्ता म सीधो हमका चलयो।” ");
INSERT INTO hlb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","अर यु पोरिया बढ़त अर आत्मा म बलवन्त होतो गयो अर इस्राएल पर प्रगट होन का दिन तक लक जंगल हुन म रया। ");
INSERT INTO hlb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","वी दिनो म ओगुस्तुस कैसर की तरफ से आग्या निकलियो कि सारो दुनिया के लोगो के नाम लिखो जाए। ");
INSERT INTO hlb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","यु पहली नाम लिखाई ओ बखत म सुरु हुई, जब क्विरिनियुस सीरिया को हाकिम हतो। ");
INSERT INTO hlb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","सब लोगो न अपनो-अपनो नाम लिखवान ख लियो अपन नगर म गयो। ");
INSERT INTO hlb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","अत: यूसुफ भी एकोलाने की वी दाऊद ख घराने खानदान का हतो, गलील के नासरत नगर से यहूदिया म दाऊद का नगर बैतलहम का गयो, ");
INSERT INTO hlb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","की अपन होवन वाली घरवाली (मंगेतर) मरियम का संग जे पेट से हती नाम लिखवायो। ");
INSERT INTO hlb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ओखा वहाँ रहतो ओके जनन के दिन पूरो हुओ, ");
INSERT INTO hlb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","अर वा अपनो बड़ो पोरिया जनी, अर ओखा कपड़ा म लपेट ख बईल का कोठा म रखी; काहेकि ओको लाने सराय म जगह नी हती। ");
INSERT INTO hlb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","अर ओखा देस म कितना गड़ेरी हता, जे रात ख मैदान म रहकर अपनो झुंड को पहरा देता हता। ");
INSERT INTO hlb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","अर प्रभु ख एक दुत ओके पास आकर खडो भयो अर प्रभु एक का दूत को उजाला ओके चारो तरफ चमक, अर वी बेजा डर गया। ");
INSERT INTO hlb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","तब स्वर्गदूत न ओसे कहयो “मत डर; देख ल काहेकि, मी तुम ख बड़ी खुसी की खबर सुसमाचार सुनान आयो जे सब लोगो को लाने होगो, ");
INSERT INTO hlb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","कि आज दाऊद को नगर म तुम्हारो लाने एक उध्दार कर्ता दाता पैदा भयो हैं, अर उही प्रभु यीसु मसी आय। ");
INSERT INTO hlb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","अर तुमारो लाने चिखान होऐ; तुम एक पोरिया ख कपड़ा म लपेटो अऊर बईल का कोठा म लेटा पाहे।” ");
INSERT INTO hlb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ऐका बाद उ स्वर्गदूत को ऐख दल परमेस्वर कि स्तुति करते हुओ अर कहते दिखाई दियो, ");
INSERT INTO hlb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“आकास म परमेस्वर की‍‍‍ महिमा अर जमीन म पर उन मनुस्यो म जे से यू खुस हैं, सान्ति होए।” ");
INSERT INTO hlb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","जब स्वर्गदूत ओके नजीक से स्वर्ग को चलो गयो, ते भेड़ी हुन न आपस म कहन लगिया, “आ, हम बैतलहम म जा ख यू बात भई हैं, अर जे से प्रभु न हम ख बतायो हैं, देखे।” ");
INSERT INTO hlb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","अर ओ ना तुरंत जाकर मरियम अर यूसुफ ख, बईल का कोठा म उ पोरिया ख पड़ो देखियो। ");
INSERT INTO hlb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","इनका देख कर ओ न यु बात जो इ पोरिया को विसय म ओ से कहयो गयो हतो‍ प्रगट की ");
INSERT INTO hlb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","अर सब सुनन वाला न उन बात से जो भेड़ी चराना वाला गाड़री हुन से ओसे कहयो अचम्बा कियो। ");
INSERT INTO hlb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","परन्तु मरियम या सब बात ख अपनो मन म रखकर सोचत रही। ");
INSERT INTO hlb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","अर भेड़ी चरान वाला जसो ओ से कहयो गयो हतो वसो ही सब सुन कर अर देखकर परमेस्वर की महिमा अर स्तुति करत भया लउट गयो। ");
INSERT INTO hlb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","जब आठवाँ दिन पूरो भयो अर ओकी खतना को बखत आयो, ते ओको नाम यीसु रखो गयो जो स्वर्गदूत न ओके पेट म आनो से पहिले कय्हो हतो। ");
INSERT INTO hlb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","जब मूसा को नेम को अनुसार ओको सुध्द होन का दिन पुरो भयो, ते वी यरूसलेम म ले गयो कि प्रभु को आगु लायो, ");
INSERT INTO hlb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(जसो कि प्रभु को नेम (व्यवस्था) म लिख्यो हैं: “हर एक पहलो वालो पोरिया प्रभु का लियो‍ सुध्द ठहरगो।” ");
INSERT INTO hlb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","अर प्रभु कि नेम को अनुसार ईक जोडा “पंडुको को अर एक जोड़ा या कबूतर को दो बच्चा हुन” ख लेकर ओकी बलि चढ़ा हैं। ");
INSERT INTO hlb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","यरूसलेम म समोन नाम को एक अदमी हतो, अर वी अदमी धर्मी अर भक्त हता; अर इस्राएल सुख सान्ति की रस्ता देखत रह हतो, सुध्द आत्मा उ पर हती। ");
INSERT INTO hlb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","अर सुध्द आत्मा ओ पर प्रगट भयो हती कि जब तक वी प्रभु के मसी का देख नी लेगो, तब तक मृत्यु ख नी देखेगो। ");
INSERT INTO hlb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","वी आत्मा का सिखानो से मन्दिर म आयो; अर जब माय-बाप उ बालक पोरिया यीसु का आन्दर लायो, कि ओके लियो नेम की रिती को आनुसार करे, ");
INSERT INTO hlb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","तो ओ न ओखा अपनो गोद न लियो अर परमेस्वर को धन्यवाद कर ख कय्हो: ");
INSERT INTO hlb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“हे स्वामी, अब तू अपनो दास ख अपनो वचन (सब्द) के अनुसार सान्ति से विदा करा हैं, ");
INSERT INTO hlb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","काहेकि मोरी आँखी न तोरो उध्दार का देख लियो हैं, ");
INSERT INTO hlb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","जे ख तू न सब सहर हुन का इंसान हुन का आगु तैयार कियो हैं, ");
INSERT INTO hlb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","कि वी दुसरी जात का प्रकास देनो का लियो उजियाला, अर तोरो निज लोग इस्राएल की महिमा होए।” ");
INSERT INTO hlb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ओखा बाप अर ओकी माय या बात से जे ओके बारे म कय्हो जावत हती, आस्चर्य करत हता। ");
INSERT INTO hlb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","समोन न ओ ख आसीस देकर, ओकी माय मरियम से कहयो, “देख, वी तो इस्राएल म बेजा जन का गिरन, अर उठान का लाने अर एक आसो चिखान होन का लाने ठहरायो गयो हैं, जेके विरोध म बात की जाएगो ");
INSERT INTO hlb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","अर तोरो मन का भी तलवार से चलायो आर पार छिदा जाएगो ऐसे बेजा दिल का विचार प्रगट होगो।” ");
INSERT INTO hlb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","आसेर गोत म से हन्नाह नामक फनूएल की पोरी एक भविस्यव्दक्तिन हती। वा बेजा बूढ़ी हो गई रह, अर सादी होनो का बाद सात वर्स तक अपनो पति का संग रह पाई हती। ");
INSERT INTO hlb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","वी चऊरासी वर्स से विधवा हती: अर मन्दिर ख नी छोड़त हती पर उपास अर प्रार्थना कर कर ख रात-दिन सेवा करत हती। ");
INSERT INTO hlb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","अर वा बखत म आकार परमेस्वर को धन्यवाद करन लगियो, अर उ सभो से, जे यरूसलेम नगर की छुटकारा की रस्ता देखत रह हती, उ बालक पोरिया को बारे म बात करन लगियो। ");
INSERT INTO hlb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","जब वी प्रभु का नेम का अनुसार सब कुछ पुरो कर चुक्या ते गलील म अपन नगर नासरत ख फिर वापस चल्या गया। ");
INSERT INTO hlb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","अर बालक पोरिया बढ़तो, अर ताकतवार होतो गयो, अर बुध्दि हे म भरपूर होत गयो; अर परमेस्वर को किरपा ओ पर हतो। ");
INSERT INTO hlb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ओखा माय-बाप हर साल कटनी को फसह मनावन को लाने यरूसलेम जावत रह। ");
INSERT INTO hlb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","जब यीसु बारा साल को भयो, ते वी तेवार की रीति-रिवाज को अनुसार यरूसलेम ख गयो। ");
INSERT INTO hlb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","जब वा दिन का पुरा कर ख लउटन लगिया, ते पोरिया यीसु यरूसलेम ख रह गयो; अर यु ओखा माय-बाप नी जानत रह की। ");
INSERT INTO hlb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","वी यू समझकर कि वी अन्य यातरिया का संग होएगो, एक दिन का बाद पड़ावा निकल गयो: अर ओखा अपनो कुटुम्ब का अर जानन पहिचानन वाला भी ढ़ुढन लगिया। ");
INSERT INTO hlb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","पर जब नी मिलियो, ते ढुढते-ढुढते यरूसलेम ख फिर से लोउट गया, ");
INSERT INTO hlb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","अर तीन दिन को बाद म यीसु उन ख ओखा मन्दिर म सिखान वाला हुन को बिच म बठियो, अर उनकी सुनन अर उनसे पुछते कर हुए पायो। ");
INSERT INTO hlb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","जित्ता ओकी सुनत रह हते, वी सब ओकी समझा अर ओखा उत्तर से दंग होत रह। ");
INSERT INTO hlb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","अऊर ओको माय बाप ओ ख देख ख अचम्भा म पड़ गयो। ओ कि माय न ओ से कय्हो, “पोरिया तुमन हमारो संग म असो काहे कियो? देख तुमारो बाप अर मी चिन्ता हतो, अर तुम ख ढूँढ रयो हतो।” ");
INSERT INTO hlb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ओ ना ओसे कहयो, तुम मोखा काहे ढूढ़ा हैं? “का तुम नी जानत आय कि मोखा अपनो बाप को मंदिर म रहनो जरुरी हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","पर जो बात ओ न उनसे कही, उन ना ओ से नी समझ। ");
INSERT INTO hlb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","तब वी उनको संग नासरत सहर गयो, अर उनको अधीन रह। अऊर ओकी माय न यी सब बात हुन ख अपनो मन म सजायो रखो। ");
INSERT INTO hlb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","अर यीसु म डील डोल म अर परमेस्वर अऊर लोग हुन ख दया म बढ़ते गयो। ");
INSERT INTO hlb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","तिबिरियुस कैसर को राज्य को पंद्रहवे साल म जब पुन्तियुस पिलातुस यहूदिया को दवा देना वाला वैघ हतो अर गलील म हेरोदेस, इतूरैया अर तरखोनीतिस म ओखा भई फिलिप्पुस, अर अबिलेने म लिसानियास, चऊथाई को राजा हतो, ");
INSERT INTO hlb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","अर जब हन्ना अर कैफा मेन याजक हतो, उ बखत परमेस्वर का वचन जंगल म जकरयाह को पोरिया यूहन्ना को नजीक पहुँचियो। ");
INSERT INTO hlb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","उ यरदन नद्दी के आसा-पास का सारो प्रदेस म जाय ख पाप हुन की माफी का लियो मन फिरनो के बपतिस्मा का प्रचार करन लगियो। ");
INSERT INTO hlb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","जसो यसायाह भविस्यवक्ता को कहयो हुयो वचनो की किताब म लिखो हैं: जंगल म एक पुकार न वालो का सब्द हो रय्हो हैं कि, प्रभु का रस्ता तैयार करो ओकी रोट ख सिधो बनाओ। ");
INSERT INTO hlb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","हर एक घाट भर दी जाएगो, अर हर एक टेकड़ा अर टिला निचू कियो जाएगो; अर जे टोढ़ो हैं अर जे सिधो, अर जे ऊँचो नीचो हैं वी बराबार रस्ता बनाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","अर हर इंसान परमेस्वर के उध्दार को देखेगो। ");
INSERT INTO hlb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","जे भीड़ की भीड़ ओसे बपतिस्मा लेन का निकल ख आवत रहा, ओसे उ कहत रह, हे साँप को पोरिया हुन, तुम ख कोना जता दियो कि आवन वालो गुस्सा से भागो। ");
INSERT INTO hlb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","एकोलाने तुम मन फिराव अर ओखा लायक फल लाओ, अर अपनो-अपनो मन म यू मत सोचो कि हमारो बाप अब्राहम आय; काहेकि मी तोसे कहत हूँ कि परमेस्वर इन पत्थर हुन से अब्राहम को लाने अवलाद पैदा कर सक हैं। ");
INSERT INTO hlb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","अब कुल्हाडी झाड़ हुन की जड़ पा रख्यो हैं, एकोलाने जे-जे झाड़ चोक्खो फल नी देवा हैं, वी काट ख अर आगी म झोका दियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","वी लोग हुन न ओसे पुछियो, “तो हम का करेगों?” ");
INSERT INTO hlb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ओ न उनका उत्तर दियो, जेका पास दो कुरता हाए, वी ओके संग जेके नजीक नी हैं बाँट ले अर जेके पास खाना हो उ भी असो ही कर हाँ। ");
INSERT INTO hlb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","कर लेन वालो भी बपतिस्मा लेना आयो अर ओसे पूछो हे प्रभु गुरू हम का करे। ");
INSERT INTO hlb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ओ ना ओसे कय्हो जो तुम्हारो लाने ठहरायो गयो हैं ओसे जादा मत लेनो। ");
INSERT INTO hlb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","सिपाहियो न भी ओसे यु पुछो हम का करे ओ ना ओसे कय्हो बुरा (उपद्रव) न करनो अर न झूठो आरोप लगानो अर अपनो तन्खा (वेतन) पर खुस रहनो। ");
INSERT INTO hlb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","जब लोग आसा लगाए ख हता अर सब अपनो-अपनो मन म यूहन्ना का विसय बारे म सोचत रह: की यु ही मसी तो नी आय, ");
INSERT INTO hlb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ते यूहन्ना न उन सब से कय्हो, “मी तो तुम ख पानी से बपतिस्मा देऊ हैं, पर उ आनवालो हैं जो मो से सक्तिसाली हैं; ते इ योग्य भी नी की मी ओके जूता को बददी खोल सकू उ तुमका सुध्द आत्मा अर आगी से पानी संस्कार देगो। ");
INSERT INTO hlb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ओको सूपडा ओको हात म हैं; अऊर उ अपनो खल्ला चोक्खो तरीका से सफा करेगों; अऊर गहूँ ख अपनो बखारी म इकट्ठो करेगों; पर भूसा ख उ आगी म जे बुझन की नी जला देगो।” ");
INSERT INTO hlb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","अत: उ बेजा सी सिक्छा दे दे ख लोग हुन का चोक्खो खबर सूनात रहा। ");
INSERT INTO hlb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","पर जब ओ न चऊथाई देस का राजा हेरोदेस को ओके भई फिलिप्पुस की घरवाली हेरोदियास को बारे म अर सब बुरो काम करन वाला (कुकर्मो) को बारे म जे ओ न कियो हतो, उलाहना दियो, ");
INSERT INTO hlb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ते हेरोदेस न उनना सब से बढ़ ख यू बुरो काम कियो कि यूहन्ना ख जेल म ड़ाल दियो। ");
INSERT INTO hlb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","जब सब लोगो न पानी बपतिस्मा लियो अर यीसु भी बपतिस्मा ले ख प्रार्थना कर रहे हतो, तो आकास खुल गयो, ");
INSERT INTO hlb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","अर सुध्द आत्मा सारीरिक रूप म कबूतर को जसो ओ पर उतरी, अर यू बददल से सब्द सुनाई दी गई आकास वानी: “तू मोरो सबसे अच्छो पोरिया आय, मी तोसे बेजा खुस हूँ।” ");
INSERT INTO hlb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","जब यीसु तुम सिक्छा (उपदेस) करन लगियो, तो लगभग तीस साल की उम्र को हती अर (जसो समझो जात हैं) यूसुफ का पोरिया हतो अर वी एली को ");
INSERT INTO hlb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","अर मत्तात को, अर उ लेवी को, उ मलकी को, अर उ यन्ना को, अर उ यूसुफ को, ");
INSERT INTO hlb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","अर उ मत्तीत्याह को, अर उ अमोस को, अर उ नहुम को, अर उ असल्लाह को, अर उ नोगह को, ");
INSERT INTO hlb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","अर उ मात को, अर उ मत्तीत्याह को, अर उ सिमी को, अर उ योसेख को अर उ योदाह को ");
INSERT INTO hlb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","अर उ यूहन्ना को, अर उ रेसा को, अर उ जरूब्बाबिल को, अर उ सालतिएल को, अर उ नेरी को, ");
INSERT INTO hlb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","अर उ मलकी को, अर उ अद्दी को, अर उ कोसाम को, अर उ इलमोदाम को, अर उ एर को, ");
INSERT INTO hlb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","अर उ यहोसू को, अर उ इलाजार को, अर उ योरीम को, अर उ मत्तात को, अर उ लेवी को, ");
INSERT INTO hlb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","अर उ समोन को, अर उ यहूदाह को, अर उ यूसुफ को, अर उ योनान को, अर उ इलयाकीम को, ");
INSERT INTO hlb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","अर उ मलेआह को, अर उ मिन्नाह को, अर उ मत्तात को, अर उ नातान को, अर उ दाऊद को, ");
INSERT INTO hlb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","अर उ यिसै को, अर उ ओबेद को, अर उ बोअज को, अर उ सलमोन को, अर उ नहसोन को, ");
INSERT INTO hlb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","अर उ अम्मीनादाब को, अर उ अरनी को, अर उ हेस्रोन को, अर उ फिरिस को, अर उ यहूदा को, ");
INSERT INTO hlb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","अर उ याकूब को, अर उ इसहाक को, अर उ अब्राहम को, अर उ तिहर को, अर उ नाहोर को, ");
INSERT INTO hlb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","अर उ सरूग को, अर उ रऊ को, अर उ फिलिग को, अर उ एबिर को, अर उ सिलह को, ");
INSERT INTO hlb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","अर उ केनान को, अर उ अरफक्छदक को, अर उ सेम को, अर उ नूह को, अर उ लिमिक को, ");
INSERT INTO hlb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","अर उ मथूसिलह को, अर उ हनोक को, अर उ यिरिद को, उ महललेल को, अर उ केनान को, ");
INSERT INTO hlb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","अर उ एनोस को, अर उ सेत को, अर उ आदम को, अर उ परमेस्वर को पोरिया हतो। ");
INSERT INTO hlb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","फिर यीसु सुध्द आत्मा से भर गयो, यरदन नद्दी म से लउटियो; अर चालीस दिन रोज तक आत्मा को सिखानू से जंगल म घूमत रयो; ");
INSERT INTO hlb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","अर तब सैतान न ओकी परीक्छा करतो रय्हो। उ दिनो म ओ ना कुछ भी नी खायो, अर जब वी दिन पुरा भया, ते ओ ख भूख लगी। ");
INSERT INTO hlb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","तब सैतान न ओसे कहयो, “अदि तू परमेस्वर को पोरिया आय, ते इ पत्थर से कह दा कि इ रोटी बन जाहे।” ");
INSERT INTO hlb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","यीसु न ओ ख जुवाब दियो, “लिख्यो हैं: ‘अदमी सिरप रोटी से जिन्दो नी रहगो’।” ");
INSERT INTO hlb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","तब सैतान न यीसु ख ले गयो ओको पल भर म दुनिया को सारो राज्य दिखायो, ");
INSERT INTO hlb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","अर सैतान न ओ न कय्हो “मी तुम सब राज हुन ख अधिकार अऊर ऐको वैभव तोखा देहु, काहेकि उ मो ख दियो गयो हैं: अऊर जे से चाहूँ हैं ओ ख ही देहु हैं। ");
INSERT INTO hlb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ऐका लाने यदि तू मो ख पाय पढ़े तो यु सब तोरो हो जाएगो।” ");
INSERT INTO hlb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","यीसु न ओ ख जुवाब दियो “लिख्यो हैं: ‘तू प्रभु अपनो परमेस्वर पाय पड़ ल; अर केवल ओकी भक्ति कर’।” ");
INSERT INTO hlb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","तब ओ न ओ ख यरूसलेम म ले जाए ख जाय ख मन्दिर की चोटी म खड़ो करियो, अऊर ओसे कय्हो, यदि तू परमेस्वर को पोरिया आय, तो अपनो तुम यहाँ से निचू गिरा दे। ");
INSERT INTO hlb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","काहेकि लिख्यो हैं: वी तोरो बारा म अपनो स्वर्गदूत हुन ख हुकुम देहे, कि वी तोरी रक्छा करे, ");
INSERT INTO hlb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","अऊर वे तो ख हातो ही हात उठा लेहे, असो नी होय की तोरो पाय म पत्थर से झट लगे। ");
INSERT INTO hlb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","यीसु न ओखा जुवाब दियो, “यू भी कय्हो गयो हैं: तू प्रभु अपनो परमेस्वर कि परिक्छा नी करनो।” ");
INSERT INTO hlb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","जब सैतान सब परीक्छा कर चुको रह, तब कुछ बखत का लाने ओको जोने से चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","फिर यीसु आत्मा की सक्ति से भर हुओ, गलील प्रदेस ख लउटियो, अर ओकी चर्चा आसा-पास सारो देस म फैल गई। ");
INSERT INTO hlb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","वी ओके प्रार्थना घर म सिक्छा कर रयो, अर सब ओकी बड़ाई करत हते। ");
INSERT INTO hlb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","फिर वी नासरत म आयो, जे पर उ पालो-वसो गयो हतो; अर अपनो रीति का अनुसार छुट्टी दिन प्रार्थना घर म जाकर पढ़नो का लाने खड़ो हुओ। ");
INSERT INTO hlb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","यसायाह भविस्यवक्ता की किताब ओखा दी गयो अर ओ ना किताब खोलकर वी जगह निकली जे म यु लिखो हतो: ");
INSERT INTO hlb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“प्रभु का आत्मा मोपर हैं, एकोलाने कि ओ ना बिखारी ख सुसमाचार सुनानो का लियो मेरो अभिसेक कियो हैं, अर मो ख ऐको भेजो हैं कि बंदी हुन को छुटकारे का अर अंधो को दृस्टि पानो को चोक्खो प्रचार करुँ अर कुचलो वाला उन ख छुड़ाऊँ, ");
INSERT INTO hlb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","अऊर प्रभु ख खुसी रहन के वर्स ख बारे म प्रचार करूँ।” ");
INSERT INTO hlb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","तब ओखा किताब बंद करवा सेवक के हात म दे दी अर बैठ गयो; अर प्रार्थना घर के सब लोग कि आँख ओ पर लगी हती। ");
INSERT INTO hlb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","तब वी ओ ख कहना लगियो, “आज ही यु सास्र तुमरो आगु पूरो हुओ हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","सब न ओ ख सराहा, अर जो किरपा की बात ओके मुँह से निकलत हती, ओसे अचम्भा हुयो; अर कहन लगियो, “का यू यूसुफ का पोरिया नी?” ");
INSERT INTO hlb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ओ न ओसे कय्हो, “तुम मोरे पर यु कहलावा अवस्य कहेगो कि ‘हे वैघ, अपन तुम को चोक्खो कर! जो कुछ हम न सुनी हैं कि कफरनहूम म कियो गयो हैं, ओ ख यू अपनो देस म भी कर’।” ");
INSERT INTO hlb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","अर ओ ना कय्हो, “मी तुम से सच कहू हूँ कोई भविस्यवक्ता अपन देस म मान सम्मान नी पाए। ");
INSERT INTO hlb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","मी तुम से सच कहू हूँ कि एलिय्याह ख दिनो म जब साढ़े तीन वर्स तक आकास बन्द रयो, यहाँ तक कि पूरो देस म बड़ो अकाल पड़ियो, ते इस्राएल म बेजा सी विधवा हुन हती। ");
INSERT INTO hlb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","पर एलिय्याह ओ म से किसी के पास नी भेजो गयो, केवल सैदा के सारफत म एक विधवा के पास। ");
INSERT INTO hlb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","अर एलीसा भविस्यवक्ता के बखत इस्राएल म ढ़ेर सारा कोढ़ी हुन हता रहा, पर सीरिया को निवासी नामान का ओमा से कोई सुध्द नी कियो गयो।” ");
INSERT INTO hlb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","अऊर यी बात सुन ही जित्ता प्रार्थना घर म हतो, सब गुस्सा से भर गया, ");
INSERT INTO hlb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","अर उठकर ओ ख नगर से बाहर निकलियो, अर जी टेकरा पर ओखा नगर बसो हुओ हते, ओकी चोटी पर ले चल की वहाँ से निचू गिरा दे। ");
INSERT INTO hlb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","पर वी ओके बिच म से निकल कर चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","फिर वी गलील के कफरनहूम नगर को गयो; अऊर छुट्टी को दिन लोग हुन ख सिक्छा दे रहे हतो। ");
INSERT INTO hlb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","वी ओके सिक्छा से चंकित हो गयो काहेकि ओखा वचन (सब्द) अधिकार सहित हतो। ");
INSERT INTO hlb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","प्रार्थना घर म ईक अदमी हतो, जेम असुध्द दुस्टात्मा हती। ऊँचे सब्द से चिल्ला उठियो, ");
INSERT INTO hlb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“हे यीसु नासरी; हम ख तोसे का काम? का तू हम ख नास करन ख आयो हैं? मी तोखा जानू हूँ तू कऊन आय? तू परमेस्वर को सुध्द जन हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","यीसु न ओसे डांट ख कय्हो, “चुप रह, अर ओमा से निकल जा!” तब दुस्टात्मा ओ ख बीच म पटक कर बिना कोई नुकसान पहुँचाए ओमा से निकल गई। ");
INSERT INTO hlb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","या बात पर अदमी हुन ख अचम्भो (हुओ), अर वी आपस म बात कर ख कहन लगियो, “यु कसो सब्द (वचन) हैं? काहेकि वी अधिकार अर सामर्थ्य ख संग बुरी आत्मा ख आग्या देहु हैं अर वी निकल जय हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","इ येका बाद यीसु से चारो तरफ ओकी हर जगह चर्चा होन लगी। ");
INSERT INTO hlb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","वी प्रार्थना घर म से उठ ख समोन को घर म गयो समोन की सास को जुड चढ़ो हुओ हतो, ओर उनना ओको लाने ओसे विनती करी। ");
INSERT INTO hlb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ओ ना ओको जोने खडो हो ख बुखार ख डांटियो अर बुखार ऊतर गयो, अर वा तुरत उठ ख उनकी सेवा-चाकरी करन लग गई। ");
INSERT INTO hlb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","दिन डूबने बखत जिन जिन ख यु लोग कई प्रकार की बीमार म पडे हुए हते, वी सब उन ख पास ले आया अर ओ ना एक एक पर हात रखकर उन ख चंगो कियो। ");
INSERT INTO hlb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","अर भूत (दुस्टात्मा) भी चिल्लाते अर या ओ म से निकल की “तु परमेस्वर को सुध्द पोरिया आय।” कह बेजा म से निगल गई। पर वी ओ ख डांटते अर बोलन नी देत रह काहेकि वी जानत हती कि वी मसी हैं। ");
INSERT INTO hlb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","जब दिन भयो ते वी निकल ख एक सुनसान जगह म गया अर भीड़ की भीड़ ओ ख ढ़ँढ़ते ओको पास आई, अर ओ ख रोकन लगी कि वी ओके पास से नी जाए। ");
INSERT INTO hlb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","परन्तु ओ न ओ से कय्हो, “मो ख अन्य सहरो म भी परमेस्वर को राज को सुसमाचार सुनान ख जानो अवस्य हैं काहेकि मी ऐका खातिर भेजो गयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","अर वी गलील के प्रार्थना घर म प्रचार करते रहयो। ");
INSERT INTO hlb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","जब भीड़ परमेस्वर को वचन सुनन को लियो ओ पर गिर पड़त रह, अर वी गन्नेसरत की झील को किनारा पर खड़ी हती, ते असो भयो ");
INSERT INTO hlb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","कि ओ न नाला के किनारा म दो नाव लगी हुई हती, अर डिम्मर मच्छी पकड़न वालो पर उतर ख जाल कर धोवत रह हते। ");
INSERT INTO hlb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","उ नाव म से एक पर जो समोन की हती, ओ म चढ़कर ओ ना ओसे विनती करी की किनारो से थोड़ा हटा ले अर चल। तब वी बैठ ख लोगो नाव पर से ही सिक्छा (उपदेस) देन लगियो। ");
INSERT INTO hlb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","जब उन ना बात करली ते समोन से कय्हो, “गहरो म ले चल, अर मच्छी पकड़न का लियो अपनो जाल डालो” ");
INSERT INTO hlb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ते समोन न ओ ख उत्तर दियो, “हे स्वामी, हम न पुरी रात मेहनत करी पर अर कुछ नी पकड़ पाया; तोभी तोरो कहना से जाल डालूगो।” ");
INSERT INTO hlb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","जब उन्होना असो कियो, तो बेजा सी मच्छी घेरा म लाए, अर ओको जाल फटन लगियो। ");
INSERT INTO hlb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ऐ पर उन ना अपना संगी हुन ख को जो दुसरी नाव पर हती, इसारा कियो कि आकार हमारी मदद करो, अर उनना आय ख समोन की मदद करी दो ही नाव यह तक भर ली कि डुबन लगी। ");
INSERT INTO hlb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","यु देखकर समोन पतरस यीसु को पाय पर गिर गयो अर कय्हो, “प्रभु मोरो नजीक से चल्यो जा, काहेकि मी पापी अदमी हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","काहेकि इतनी मच्छी ख पकड़ियो जानो ओ ख अर ओके संगी ख बेजा अचम्भा भयो। ");
INSERT INTO hlb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","अर वसो ही जबदी का पोरिया याकूब अर यूहन्ना ख भी, समोन को संग म हते, अचम्भा भयो। तब यीसु न समोन कय्हो, “मत डर; अब से तू अदमी हुन ख जीवता पकडया करेगों।” ");
INSERT INTO hlb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","अर वी नाव हुन ख किनारा पर ले आया, अर सब कुछ छोड़ ख ओको पीछु चल्या गया। ");
INSERT INTO hlb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","जब वी कोई नगर म हता, ते वहा कोढ से भरियो भयो एक अदमी आयो; अर उ यीसु ख देख ख मुंडो को बल गिरियो अर विनती करी, “हे प्रभु, यदि तू चाहे ते मोखा सुध्द कर सकत हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ओ न हात बढ़ा ख ओ ख छु, अर कय्हो “मी चाहत हूँ, तू सुध्द हो जा।” अर ओको कोढ तुरंत ठिक हो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","तब ओ न ओ ख समझायो, “कोई से मत कहनो परन्तु जा अपनो तुम ख याजक ख दिखायो, अर अपनो सुध्द होनो ख बारे म जो कुछ मूसा न चढ़ावो ठहरायो हैं ओ ख चढ़ा की ओ पर गवाई हो हे।” ");
INSERT INTO hlb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","पर ओ न चर्चा ख सब दुर फैला दी, अर ढ़ेर सारी भीड़ ओकी सुनन ख लियो अर अपन बीमारियो से चंगो होवन ख लियो जामा (इकठ्टी) हुई। ");
INSERT INTO hlb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","पर उ जंगल म जाख अलग जगा म बिनती करत रह। ");
INSERT INTO hlb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","एक दिन असो भयो कि उ सिक्छा देवा रवह हतो, अर फरीसी अर व्यवस्थापक वहाँ बठिया हता जो गलील अर यहूदिया को हर एक गाँव से अर यरूसलेम से आया हता, अर चोक्खो करन को लाने प्रभु कि सक्ति ओको संग म हती। ");
INSERT INTO hlb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","उत्ती बकत कई अदमी एक अदमी ख जोका लकवा को रोग हतो, खटिया म लायो अर भीतर ले जानो म अर यीसु को सामे रखनो को उपाय ढुढत रह हता। ");
INSERT INTO hlb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","पर जब भीड़ का लाने ओ ख भीतर नी ले जा सकिया ते उनना छत पर चढ़ाय ख खपरा हट, ख ओ ख खटिया समेत बीच म यीसु का सामे उतार दियो। ");
INSERT INTO hlb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ओ न उनको भरोसा देख ख ओ से कहयो, “अरे इंसान जा तोरा पाप माप हो गया।” ");
INSERT INTO hlb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","तब सासतिरी अर फरीसी झगड़ा करन लगिया, “यु कोन हैं जो परमेस्वर की बुराई करत हैं? परमेस्वर ख छोड़ अर कोन पाप का माप कर सका हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","यीसु न ओके मन की बात समझ ख ओसे कय्हो, “तुम अपना मन म का झगड़ा कर रयो हो? ");
INSERT INTO hlb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","सहज का हैं? का यू कहनू कि ‘तोरा पाप माप हो गयो’ का चलेयो जा ‘उठ अर चल फिर?’ ");
INSERT INTO hlb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","पर एकोलाने ओ ख जानो कि इंसान को पोरिया को धरती पर पाप माप करन को भी अधिकार दियो हैं” ओ ना उ लकवा को बीमार से कय्हो, “मी तोसे कहू हूँ, तू उठ अपनो खटिया उठायो ख घर चलो जा।” ");
INSERT INTO hlb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","उ तुरत ओखा सामे आगे उठा, अर जे पर उ पड़ो हतो ओ ख उठकर, परमेस्वर कि बड़ाई करत भयो अपनो घर म चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","तब वी सब चंकित भया अर परमेस्वर की स्तुति करन लगिया अर बेजा डर कर कहन लगियो, “आज हम न अनोखी बात देखी लियो हैं!” ");
INSERT INTO hlb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ऐको बाद वी बाहर गयो अर लेवी नाम को एक कर लेन वालो को कर घर पर बठियो देखो, अर ओसे कय्हो, “मोरो पिछु हो ला।” ");
INSERT INTO hlb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","तब वी सब कुछ छोड़कर उठियो, अर ओके पिछे हो लियो। ");
INSERT INTO hlb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","तब लेवी न अपन घर म ओखा लियो एक बड़ो खानो दियो; अर कर लेन वालो की अर अन्य लोग की जो ओखा संग खानो करन बैठे हते, एक बठियो भीड़ हती। ");
INSERT INTO hlb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","इ पर फरीसी अर ओसे सासतिरी उ के चेला हुन से यु कह ख कुड़कड़ान लगियो, “तुम कर लेन वालो अर पापी हुन का संग काहे खावा पिवा हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","यीसु न जवाब दियो, “वैघ भलो चंगो को लाने नी, पर जुड़ वाला को लाने जरूरत हैं। ");
INSERT INTO hlb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","मी धर्मियो का नी, पर पापियो को मन फिरानो को लियो बुलायो आयो हूँ।” ");
INSERT INTO hlb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ओ न न ओसे कय्हो, “यूहन्ना का चेला हुन तो बराबर उपवास रखत अर प्रार्थना कियो करत हैं अर वसो ही फरीसी का चेला भी, परन्तु तोरो चेले तो खात-पित हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","यीसु न ओसे कय्हो, “का तुम बरात हुन से, जब तक दुला ओके संग रहे, उपास करा सका हैं? ");
INSERT INTO hlb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","परन्तु उ दिन आए, जेमा दुल्हा ओसे अलग कियो जाएगो, तब वी उत्ती बखत म उपास करे।” ");
INSERT INTO hlb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ओ ना एक अर उदाहरन भी ओसे कय्हो; “कोई अदमी नयो कपड़ा म फाड़कर पुरानो म थेगड़ा पैवन्द नी लगावा, नी तो नयो फट जाएगो अर वी थेगड़ा पुरानो म मिलान (मेलान) भी नी खाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","अर कोई नयो अंगूर को रस को दाखरस पुरानी चमडा म नी भरतो, नी तो नयो अंगूर को रस मटका को फाड़ ख बह जाएगो, अर चमडा भी खतम हो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","परन्तु नयो अंगूर को रस नयो चमडा म भरनो चाहिये। ");
INSERT INTO hlb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","कोई नयो अंगूर को रस अदमी पुरानो अंगूर का रस पी ख नयो नी चाहत, काहेकि वी कहत हैं, कि पुरानो ही अच्छो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","अऊर यीसु कोई आराम को दिन ख गहूँ को खेत हुन से हो ख जा रयो हतो। उन ख चेला हुन फसल कि बाली तोड़ ख अऊर उन ख संग से मसल-मसल ख खान लगो। ");
INSERT INTO hlb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","तब फरीसी हुन म से कुछ कहन लगिया, “तुम असो काम काहे करत हैं जो आराम को दिन म करनो ठीक नी हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","अऊर यीसु न उन ख जवाब दियो, “का तुम लोग हुन न यू नी पढ़ियो कि जब दाऊद अर ओको संगी हुन ख भूख लगी, तब दाऊद न का कियो हतो? ");
INSERT INTO hlb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","उ कसो परमेस्वर को घर म गयो, अर भेट की रोटियाँ लेय ख खायो, जिनका खानो याजक हुन का छोड़ अर कोई को ठीक नी, अर अपन संगियो का भी दी?” ");
INSERT INTO hlb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","अर फिर यीसु न उन से कय्हो, “इंसान को पोरिया आराम को दिन को मालिक आय।” ");
INSERT INTO hlb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","अऊर असो भयो कि कोई आराम को दिन वी प्रार्थना घर म जाकर सिक्छा (उपदेस) करन लगियो; अर वाहा एक अदमी हतो जेका जेवनो हात सुखो हतो। ");
INSERT INTO hlb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","सासतिरी अर फरीसी ऐ पर इज्जाम लगानो का बखत पानो की ताक म हतो की देखे आराम को दिन म चंगो करत हैं कि नी। ");
INSERT INTO hlb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","परन्तु वी ओके विचार जानन हतो; एकोलाने ओ ना सुखो हात वालो अदमी से कय्हो, “उठ, बीच म खड़ो हो गयो” वी उठ खड़ो हुओ। ");
INSERT INTO hlb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","यीसु न ओसे कय्हो, “मी तुम से यु पुछत हूँ कि छुट्टी को रोज का ठीक हैं, अच्छो करनु; या बुरो करनु; प्रान को बचानो या नास करन?” ");
INSERT INTO hlb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","तब ओ न चारो तरफ उन सभो का देखकर उ अदमी से कय्हो “अपनो हात बढ़ा।” ओ ना ऐसी ही कियो, अर ओखा हात फिर चंगो हो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","परन्तु वी तुम से बाहर होकर आपस म विवाद करन लगियो कि हम यीसु ख संग का करे? ");
INSERT INTO hlb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","उन दिनो म यीसु टेकरा (पहाड़) पर विनती करन गयो, अर परमेस्वर प्रार्थना करन म सारो रात बितायो। ");
INSERT INTO hlb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","जब दिन हुओ ते ओ ना अपनो चेला हुन को बुलायो कर ओ म से बारा चुनियो अर ओखा प्रेरित कय्हो; ");
INSERT INTO hlb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","अर वी यी आय समोन जोको नाव (नाम) ओ ना पतरस वी रखियो, अर ओको भई अन्द्रियास, अर याकूब, अर यूहन्ना, अर फिलिप्पुस, अर बरतुल्मै, ");
INSERT INTO hlb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","अर मत्ती, अर थोमा, अर हलफई का पोरिया याकूब अर समोन जे जेलोतेस कहलाता हैं, ");
INSERT INTO hlb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","अर याकूब का पोरिया यहूदा, अर यहूदा इस्करियोती जे यीसु को पकड़ वालो बनो। ");
INSERT INTO hlb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","अऊर यीसु उन ख बारा दास हुन ख संग म टेकड़ा से उतर ख एक रफाड़ म खड़ो हो गयो। वहाँ उनको बेजा सा चेला हुन हता, अऊर एक बड़ी भीड़ को झुण्ड भी हतो वी लोग सब यहूदी सहर, यरूसलेम सहर अऊर सूर अऊर सैदा को समुंदर किनारा से आया हता। ");
INSERT INTO hlb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","जे ओकी सुनन अर अपन जुड़ से चंगा होवन को लाने ओको नजीक आयो हते, वहाँ हते। अर बुरी आत्मा के सताएँ हुओ लोग भी चोक्खो कियो जात हते। ");
INSERT INTO hlb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","सब ओ ख छुनो चाहत हते, काहेकि ओमा से सामर्थ्य निकलकर सब ख चंगो करत हती। ");
INSERT INTO hlb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","तब ओ ना अपनो चेला हुन की तरफ देख ख कय्हो, धन्य हो तुम जे दीन हैं, काहेकि परमेस्वर को राज तुम्हारो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","भलो हैं तुम जो अबी भुखो हैं, काहेकि पेट भर खाहे। “धन्य हैं तुम जो अब रोवा हैं, काहेकि हँसे।” ");
INSERT INTO hlb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“भलो हैं तुम जब इंसान को पोरिया को वजे से इंसान तुम से गुस्सा करे, अऊर निकाल देहे, अऊर तुम्हारी बुराई करे, अर तुम्हारो नाम बुरो जान ख काट देहे।” ");
INSERT INTO hlb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","उ दिन खुसी हो ख कुदे, काहेकि देखनो, तुमारो लाने स्वर्ग म बडो प्रतिफल हैं; ओके बाप-दादा भविस्यवक्ता हुन को संग भी वसो ही कियो करत हतो। ");
INSERT INTO hlb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“परन्तु धितकार तुम पर जा धनी हैं, काहेकि तुम अपनो सान्ति पा लियो।” ");
INSERT INTO hlb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“धितकार तुम पर अब तृप्त हो, काहेकि भूखे होए।” “हाय तुमारो पर जो अब हँस हैं।” काहेकि दुख करे अर रोहे। ");
INSERT INTO hlb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","धितकार तुम पर जब सब अदमी तुम ख भलो कहे, काहेकि बाप-दादा झूटा भविस्यवक्ता ख संग भी कियो करत हतो। ");
INSERT INTO hlb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","पर मी तुम सुनन वाला ख कहू हैं कि अपनो बैरी से प्रेम रखनो; जे तो से बैर करे, ओको भलो कर। ");
INSERT INTO hlb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","जे तुम ख स्राप दे, ओको आसीस दो; जे तुम्हारो अपमान करे, ओको लाने प्रार्थना करो। ");
INSERT INTO hlb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","जे तोरो एक गाल पर चाटा मारे ओको ओर दुसरो भी फेर देजो तोरी दोहर छिन लेहे, ओको कुरता लेनो से भी नी रोक। ");
INSERT INTO hlb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","जे कोई तोसे से मागे, ओ ख दे; अऊर जो तोरी वस्तु छीन ले, ओसे नी माँग। ");
INSERT INTO hlb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","जसो तुम चाहवा हो कि लोग तुम्हारो संग कर, तू भी उन ख संग वसो ही करो। ");
INSERT INTO hlb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“अदि तुम अपनो प्रेम रखन वालो ही को संग प्रेम रखा हैं, तो तुमरो का बड़ाई? काहेकि पापी भी अपनो प्यार रखन वाला को संग प्यार रख हैं। ");
INSERT INTO hlb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","अदि तुम अपनो भलई करन वालो ही ख संग भलाई करत हो, तो तुमरो का बड़ाई? काहेकि पापी भी असो ही कर हैं। ");
INSERT INTO hlb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","यदि तू ओ ख उधार दो जेसे फिर पानो की आसा रखत हो, तो तुम्हारो का बड़ाई? काहेकि पापी पापियो को उधार देहत हैं कि उतनो ही फिर पाएँ। ");
INSERT INTO hlb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","वरन् अपना दुसमन हुन से प्रेम रखो, अर भलाई करो, अर फिर पानो की आसा नी रखकर उधार दो; अर तुम्हारो लियो बड़ो फल होगो, अर तू परमप्रधान ख अवलाद ठहरोगो, काहेकि वी उन पर जे धन्यवाद नी करत अर बुरो पर कृपालु हैं। ");
INSERT INTO hlb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","जसो तुमारो बाप दयावन्त हैं, वसो ही तू भी दयावन्त बनो। ");
INSERT INTO hlb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“दोस नी लगा, तो तोखा भी दोस नी लगायो जाहे। दोस नी लगाहे, ते तुम ख भी दोस नी ठहराए जाएगो माप कर, तो तोखा भी माफ कियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","अगर तू दुसरो ख देगो, ते तुम ख भी दियो जाएगो। अगर लोग हुन ख पुरो नाप से दबा दबाकर ख अर हला हलाकर ख भर ख देहेगो ते उ तुम ख तुम्हारी गोद म भर पुरी से डालेगो, काहेकि, जे नाप से तुमरो नाप हैं, ओसे से तुम्हारो लियो भी नापो जाएगो।” ");
INSERT INTO hlb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","फिर ओ ना एक उदाहरन कय्हो: “का अंधा, अंधो का रस्ता बता सकत हैं? का दोही हुन गड्डा म नी गिरेगो? ");
INSERT INTO hlb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","चेला अपन मुख से बड़ो नी, परन्तु जे कोई सिध्द होगो, वी गुरू का समान होगो। ");
INSERT INTO hlb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","तू अपन भई की आँख को कचरा को काहे देखत हैं, अर अपन आँख को लट्ठा नी दिखत (सूझता) आय? ");
INSERT INTO hlb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","जब तू खुद की ही आँख का लट्ठा नी दिखत आय, तो अपन भई से कसो कहत सकत हैं, ‘हे भई; रुक जा तोरी आँख से कचरा ख निकला दूँ’? हे कपटी, पहले अपन आँख से लट्ठा निकाल, तब जो तिनका तोरो भई की आँख म हैं, ओ ख भली भाँति देखकर निकाल सकेगो। ");
INSERT INTO hlb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“कोई अच्छो झाड़ नी जो निकम्मा फल लाए, अर नी ते निकम्मो झ़ाड़ हैं जो चोक्खो फल लाए। ");
INSERT INTO hlb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","हर एक झाड़ अपन फल से पहचानता जावा हैं; काहेकि अदमी झाड़ी हुन से अंजीर नी तोड़त अर नी झड़बेरी से अंगूर। ");
INSERT INTO hlb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","चोक्खो अदमी अपन मन के भले भण्डार से भली बात निकलत हैं, अर बुरो अदमी अपन मन के बुरो भण्डार से बुरो बात निकलत हैं; काहेकि जो मन म भरो हैं ऊईच ओको मुँह पर आवह हैं। ");
INSERT INTO hlb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“जब तुम मोरो कहन नी मानत तो मोखा हे प्रभु, कहत हो?” ");
INSERT INTO hlb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","जे कोई मोरे पास आत हैं अर मोरी यी बात ख सुन ख उन ख माना हैं, मी तुम्हे बतात हूँ की वी कोके सामन हैं: ");
INSERT INTO hlb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","अऊर उ अदमी का समान हैं, जेने घर बनात बखत जमीन म गहरी गड्डा खोदकर चट्ठान पर नीव डाली, अर जब बाढ़ आयो तो धारा उ घर पर लगियो पर ओखा हिला नी सकी; काहेकि वी पक्को बनो हतो। ");
INSERT INTO hlb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","परन्तु जो सुन कर नी मानत वी उ अदमी का समान हैं, जेना मिठ्टी पर बिना नीव का घर बनायो, जब उ पर धारा लगी तो वी तुरत गिर पड़ो अर गिरकर ओको सत्यानास हो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","जब उ अदमी हुन यू बात हुन कह चक्यो, तू उ कफरनहूम सहर म आयो। ");
INSERT INTO hlb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","उ कोई सतपति को एक दास जो ओखा प्रिय हतो, जुड़ से मरन पर हता। ");
INSERT INTO hlb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ओ न यीसु की चर्चा सुन ख यहूदियो को कई सियाना को ओसे यु विनती करी को लाने ओके पास भेजियो कि आय ख मोरो दास ख चोक्खो कर। ");
INSERT INTO hlb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","वी यीसु का पास आयो, अर ओसे बड़ी विनती कर ख कहन लगियो, “वी योग्य हैं कि तू ओके लियो यु करे, ");
INSERT INTO hlb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","काहेकि वी हमार जाति से प्रेम रखत हैं, अर ओ न हमार प्रार्थना घर का बनायो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","यीसु ओखा संग गयो, पर जब वी घर से दुर नी हतो, ते सतपति ओको नजीक कई दोस्त हुन ख दुवारा कहना भेजो, “अरे प्रभु दुख नी उठा, काहेकि मी यू लायक नी कि तुम मोरो घर को भीतर आहे। ");
INSERT INTO hlb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","इही कारन मी अपन तुम को इ योग्य भी नी समझात कि तोरो पास आऊ, पर सब्द ही कह दे तो मोरो सेवक चंगो हो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","मी भी पराधीन अदमी हूँ, अर सासन मोरा हात म हैं; अर जब एक को कहूँ हैं जा, तो वी जात हैं; अर दुसरो से कहत हूँ, आ तो आत हैं; अर अपन किसी दास को कि यु कर तो वी ओ ख करत हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","यु सुन कर यीसु का अचम्भा हुओ अर मुँह फेर कर उ भीड़ से जो ओके पिछु आवन रही हती, कय्हो, “मी तुम से कहत हूँ, कि मी ना इस्राएल म भी ऐसो विस्वास नी पायो।” ");
INSERT INTO hlb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","अर भेजो हुओ अदमी न घर म लउटकर ओ ख दास चंगो पायो। ");
INSERT INTO hlb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","थोड़ो दिन का बाद नाईन नाम को एक नगर म गयो। ओके चेला हुन अर बड़ी भीड़ ओके संग जा रही हती। ");
INSERT INTO hlb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","जब वी नगर का फाटक का पास पहुँचियो, तो देखो, लोग उ एक मुदा का बाहर ले जात हतो; जे अपन माय को एक ही पोरिया हतो, अर वी विधवा हती; अर नगर को ढ़रो सारो लोग हुन ओको संग म हता। ");
INSERT INTO hlb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ओ ख देखकर प्रभु का तरस आयो, अर ओ ना कय्हो, “नी रो।” ");
INSERT INTO hlb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","तब ओ ना पास म आकर अर्थी को छुओ, अर उठन वाला ठहर गयो। तब ओ ना कय्हो, “हे जवान, मी तो से कहत हूँ, उठ!” ");
INSERT INTO hlb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","तब वी मुरदा उठ बैठियो, अर बोलन लगियो। ओ ना ओ ख ओकी माय का सोप दियो। ");
INSERT INTO hlb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","इसे सब पर डर (भय) छा गयो, अर वे परमेस्वर की बड़ाई कर ख कहन लगिया, “हमार बिच म एक बड़ो भविस्यवक्ता उठियो हैं, अर परमेस्वर न अपना अदमी पर कृपा नजर करी हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","अर ओके बारे म यू बात सारो यहूदिया अर आसा पास का सारो देस म फैल गयो। ");
INSERT INTO hlb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","यूहन्ना का ओके चेला हुन न इ सब बात का खबर (समाचार) दियो। ");
INSERT INTO hlb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","तब यूहन्ना अपना चेलो म से दो जन का बुला ख अर प्रभु का पास यू पुछन ख लियो भेजो, “का आन वाला तू ही हैं, या हम किसी अर की रस्ता (बाट) देखा?” ");
INSERT INTO hlb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","उन्होना ओके पास म आकर कय्हो, “यूहन्ना पानी से बपतिस्मा देन वाला न हमका तोरो पास यु पुछन का लियो भेजो हैं कि का आन वाला तू ही हैं, या हम दुसरा रस्ता (बाट) देखा?” ");
INSERT INTO hlb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ऊईच बखत ओ ना बेजा का जुड़ अर पीड़ा, अर दुस्टात्मा से चोक्खो कियो हयो हतो; अर बेजा से अंधो को आँखी दी; ");
INSERT INTO hlb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","अर ओ न ओ से कय्हो, “जो कुछ तू न देखो अर सुनो हैं, जा ख यूहन्ना से कह देनो; कि अंधो देखत हैं, लंगड़ा चलत-फिरत हैं, कोढ़ी इ सुध्द किए जात हैं, बहिरा सुनत हैं, मरा हुन ख जिन्दो करा हैं, अर कंगाल का सुसमाचार सुनायो जात हैं। ");
INSERT INTO hlb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","धन्य हैं वी जो मोरो विसय म ठोकर नी खाए।” ");
INSERT INTO hlb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","जब यूहन्ना का भेजो हुओ लोग चलो गयो तो यीसु यूहन्ना को बारे म लोग हुन से कहन लगियो, “तुम जंगल म का देखन गयो हतो? का हवा से हिलत सरकण्डा को? ");
INSERT INTO hlb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","वी फिर तुम का देखन गया रहा? का कोमल कपड़ा पहिनो हुओ अदमी को? देखो, जे भड़कीला कपड़ा पहिनत अर सुख विलास से रह हैं, वी राजा को महल रहवा हैं। ");
INSERT INTO hlb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ते फिर का देखन गए हते? का किसी भविस्यवक्ता को? हाँ, मी तुम से कहत हूँ, वरन् भविस्यवक्ता से भी बड़ो का। ");
INSERT INTO hlb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","यु वही हैं, जेको विसय म लिखो हैं: परमेस्वर कह हैं देख, मी अपनो दुत ख तोरा आगु-आगु भेजत हूँ, उ तोरो आगु तोरा रस्ता तैयार करे। ");
INSERT INTO hlb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","मी तुम से कहत हूँ कि जे ओरत से जनमो हैं, ओमा से यूहन्ना से बड़ो कोई नी: पर जे परमेस्वर को राज्य म छोटो से छोटो हैं, उ ओ ख भी बड़ो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","अर सब सामान्न लोगो न सुन कर अर कर लेन वालो न भी यूहन्ना का पानी से बपतिस्मा लेकर परमेस्वर का सच्चो मान लियो। ");
INSERT INTO hlb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","परन्तु फरीसी अर व्यवस्थापक हुन न ओसे बपतिस्मा नी लेकर परमेस्वर का अभिप्राय को अपनो विसय म टाल दियो। ");
INSERT INTO hlb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","अत: मी इ “युग को लोग हुन को बारे म कसो समझऊ उपमा कि वी कोको समान हैं? ");
INSERT INTO hlb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","वी उ पोरिया का समान हैं जो बजार म बैठो हुओ एक दुसरा से पुकार कर कहत रह। ‘हम न तुम्हारो लियो बाँसुरी बजाई, अर तुम नी नाचिया; हमना दुख कियो अर तुम नी रोया!’ ");
INSERT INTO hlb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","काहेकि यूहन्ना पानी बपतिस्मा देनवाला नी रोटी खात आया, नी अंगूर को रस पीवा आयो, अर तुम कहत हूँ, ‘ओमा दुस्टात्मा हैं।’ ");
INSERT INTO hlb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","अऊर इंसान को पोरिया खात-पीत आयो हैं, अर तुम कहत हो, देख भूखड़ अर पियक्कड़ अदमी कर लेन वालो का अर पापी हुन का दोस्त। ");
INSERT INTO hlb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","पर ग्यान अपनी बुध्दि सब अवलाद व्दारा सच्चो ठहरायो गयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","फिर किसी फरीसी न ओसे विनती की कि वी ओको संग खानो करे, अत: वी उस फरीसी के घर म जाकर खानो करन बैठो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","उ सहर की एक पापीनी बाई यु जानकर कि वी फरीसी का घर म जोवन करन बैठियो हैं, संगमरमर को बर्तन म इतर लेख आई, ");
INSERT INTO hlb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","अर ओके पाय का पास, पिछु खड़ी होकर, रोती हुई ओके पाय को आँसु हुन से भगोने लगिया अर अपनो सिर का बाल से पोछन लगिया, अर ओके पाय बार-बार चुमकर उ इतर मलो। ");
INSERT INTO hlb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","यु देखकर वी फरीसी जेना ओ ख बुलायो हता अपन मन म सोचन लगियो, “यदि यु भविस्यवक्ता होतो तो जान जातो कि यु जो ओ ख छूवा रही हैं, वी कऊन, अर कसी बाई हैं, काहेकि वी पापीनी हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","यीसु न ओको उत्तर म कय्हो, “हे समोन, मोरो तो से कुछ कहनो हैं।” उ बोल्यो, “हे गुरू, कह।” ");
INSERT INTO hlb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","अऊर यीसु न कय्हो, “कोई बड़ो व्यक्ति को दो कर्जदार हतो। एक पाँच सव चाँदी सिक्का को ब्याज हतो अर दूसरो, पचास चाँदी सिक्का को कर्जदार हतो। ");
INSERT INTO hlb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","जब ओको नजीक लोटानो का कुछ नी रहयो, तो ओ ना दो ही जन का माप कर दियो, एकोलाने ओ म से कऊन ओसे अधिक प्रेम रखेगो?” ");
INSERT INTO hlb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","समोन न उत्तर दियो, “मोरी समझ म ते ऊईच, जे को जादा कर्जा माप भयो। यीसु न ओ से कहयो।” “तुमारो निर्नय अच्छो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","अर उ बाई का तरफ फिर ख ओ न समोन से कहयो, का तू या बाई ख देखा हैं? मी तोरो घर म आयो पर तू न मोरो पाय धोन ख लाने पानी नी दियो, पर ओ ना मोरो पाय आँसु हुन से भिगयो अर अपनो बाल हुन से पोछो। ");
INSERT INTO hlb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","तू न मोखा चूमा नी दियो, पर जब से मी आयो हैं तब से मी इन से मोरो पाय का चूमन नी छोड़ो। ");
INSERT INTO hlb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","अऊर तो न मोरो सिर पर तेल नी मलो, पर इन मोरो पाय पर इतर मलो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","एकोलाने मी तो से कहूँ हैं कि ओको पाप जे बेजा हते माप भयो काहेकि ऐन बेजा प्यारा कियो; पर जेका थोड़ो माप हुओ हैं, वी थोड़ो प्रेम करत हैं। ");
INSERT INTO hlb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","अर यीसु वा ओरत से कहयो, “कि तुमारो पाप माप हो गयो।” ");
INSERT INTO hlb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","तब जे लोग ओके संग खाना करन बैठी हते, वी अपन-अपन मन म सोचन लगियो, “यू कऊन हैं जे पापो का भी माप करत हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","पर ओ ना बाई से कय्हो, “तोरो विस्वास न तोखा बचा लियो हैं, सान्ति से चली जा”। ");
INSERT INTO hlb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","एको बाद उ सहर-सहर अर गाँव-गाँव म प्रचार कर रयो, अऊर परमेस्वर को राज्य अर को सुसमाचार सुनाते फिरन लगियो, अर वी बाहर ओको संग हते, ");
INSERT INTO hlb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","अर कुछ बाई हुन भी हती जे म दुस्टात्मा हुन से अऊर बिमारी से चोक्खो कियो गयो हती, अर वी ई आय: मरियम जे मगदलीनी कहलाता हती, जेम से सात बुरी आत्मा निकली हती, ");
INSERT INTO hlb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","अर हेरोदेस को भण्डारी खुजा की घरवाली योअन्ना, अर सूसन्नाह, अर बेजा सी अन्य बाई हन। वी अपन इच्छा सम्पत्ति से ओकी सेवा करत रह। ");
INSERT INTO hlb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","जब बड़ी भीड़ इकठ्टी भई अर नगर-नगर का लोग ओके पास चलो आत रह हता, तो ओ न उदाहरन म कय्हो: ");
INSERT INTO hlb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“एक बोवन वाला बीज बोन का लियो निकलियो। बोते हुओ कुछ रस्ता का किनारो म गिरीयो, अर पाय को व्दारा रोदियो गयो, अर आकास की पक्छी हुन न ओ ख चुन लियो। ");
INSERT INTO hlb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","कुछ चट्ठान पर गिरो, अर उपज, पर नमी नी मिलन से सूख गयो। ");
INSERT INTO hlb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","कुछ झाड़ियो का बीच म गिरायो, अर झाड़ हुन न संग-संग बढ़ ख ओको दबा दियो। से ");
INSERT INTO hlb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","कुछ अच्छी जमीन पर गिरायो, अर उगकर सव गुणा फल लायो।” यू कह ख ओ ना ऊँचो सब्द से कय्हो, “जेके सुनन का कान होए वी सुन ले।” ");
INSERT INTO hlb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ओके चेला हुन न ओसे पुछो कि इ उदाहरन को मतलब का हैं? ");
INSERT INTO hlb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ओ न कय्हो, “तुम को परमेस्वर को राज को भेदो की समझ दी गयो हैं, पर अरो को उदाहरन हुन म सुनायो जात हैं, एकोलाने कि ‘वी देखत हुओ भी नी देखा, अर सुन ख भी नी समझ सक हैं।’ ");
INSERT INTO hlb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“उदाहरन को मतलब यू हैं: बीज परमेस्वर को वचन हैं। ");
INSERT INTO hlb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","रस्ता का किनारा म का वी हैं, जे न सुनो: तब सैतान आय ख ओके मन म से वचन उठा लियो जात हैं कि कही असो नी हो कि वी विस्वास कर ख उध्दार पाएँ। ");
INSERT INTO hlb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","पत्थर चट्ठान पर का वी हैं कि जब वी सुनत हैं, ते खुसी को संग म वचन ख ग्रहण वी करत हैं, पर जड़ नी पकड़न से वी थोड़ी देर का तक विस्वास रखत हैं अर परीक्छा को बखत बहक जावा हैं। ");
INSERT INTO hlb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","जे झाड़ म गिरियो, यु वी हैं जे सुनत हैं, पर सामे चल ख चिन्ता, अर धन, अर जीवन का सुख विलास म फंस जावा हैं अर ओखा फल नी पकत हैं। ");
INSERT INTO hlb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","पर चोक्खो जमीन म को वी हैं, जो वचन सुन ख भले अर उत्तम मन म सम्भाल को रखत हैं, अर धीरे धीरे से फल लात हैं। ");
INSERT INTO hlb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“कोई दिया जला ख बर्तन को नीच्चो नी ढाँकत, अर नी खटिया को निचे रखह हैं, पर म्याल (दीवट) पर रखत हैं कि अन्दर आनवालो ख उजालो मिले। ");
INSERT INTO hlb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“कुछ छिपयो नी प्रगट नी होय, अर न कुछ छुपाए (गुप्त) हैं जे जाना नी जाए अर प्रगट नी हो। ");
INSERT INTO hlb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“एकोलाने होसियार रह कि तुम कसो रीति से सुनत हो? काहेकि जेके पास हैं ओको दियो जाएगो, अर जेके पास नी हैं। ओको पास से वी भी ले लियो जाएगो, जे ख भी वी अपनो समझत हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ओकी माय अऊर ओको भई ओके पास आए, पर भीड़ को कारन ओसे मिल नी सक्या। ");
INSERT INTO hlb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ओसे कय्हो गयो, “तोरी माय अर तोरो भई बाहर खड़ो हुयो, तो से मिलना चाहत हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ओ न एको उत्तर म ओसे कय्हो, “मोरी माय अर मोरो भई वी ही आय, जे परमेस्वर का वचन सुनत अर मानत हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","फिर एक दिन वी अर ओको चेला हुन नाव पर चढ़ियो, अर ओ न ओसे कय्हो, “आओ, झील को पार चले।” अत: उन्होना नाव खोल दी। ");
INSERT INTO hlb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","पर जब नाव चल रही हती, तो उ सो गयो: अर झील म आँधी आई, अर नाव पानी से भरन लगीयो अर वी तकलिब (जोखिम) म हते। ");
INSERT INTO hlb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","तब उन्होना यीसु का पास आकार ओको जगायो, अर कय्हो, “स्वामी। स्वामी! हम नास हुओ जात हैं।” तब ओ ना उठकर आँधी को अर पानी की लहरो को डांटियो अर वी थम गए अर ठीक हो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","तब यीसु ओसे कय्हो, “तुम्हारो विस्वास किते हतो?” पर वी डर गया अर अचम्भो होकर आपस म कहन लगिया, “यू कऊन हैं जे आँधी अर पानी ख भी आग्या देव हैं, अर वी ओकी मान हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","फिर वी गिरासेनी हुन को देस म पहुँचियो, जो उ पार गलील का सामने हैं। ");
INSERT INTO hlb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","जब वी किनारा पर उतरिया तो उ नगर को अदमी ओ ख मिलो जे मा दुस्टात्मा हुन हती। वी बेजा दिन से न कपड़ा पहिनत रह। अर न घर म रह पर मरघट म रह हता। ");
INSERT INTO hlb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","उ यीसु ख देखकर चिल्लायो अर ओके सामने गिरकर ऊँचो सब्द से कय्हो, “हे परमप्रधान परमेस्वर को पोरिया यीसु! मोखा तो से का काम? मी तो से विनती करू हूँ, मोखा दुख मत देहे।” ");
INSERT INTO hlb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","काहेकि वी उ दुस्टात्मा ख उ अदमी म से निकलन की आग्या दे रह। पर लोग ओ ख साँकल म अर बेडी हुन से बाँध ख रखत रह तोभी वी बन्धन हुन ख तोड़ डालत रह, अर दुस्टात्मा ओ ख जंगल म भगा ख फिरत रह। ");
INSERT INTO hlb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","यीसु न ओसे पुछियो, “सेना,” काहेकि बेजा दुस्टात्मा ओमा पैठ गई हती। ");
INSERT INTO hlb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","जसो ओसे विनती करी कि हम अथाह कुण्ड म जान की आग्या नी दे। ");
INSERT INTO hlb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","वहाँ टेकड़ी पर डुक्कर का एक बड़ो झुण्ड चर रह हतो, एकोलाने जसो ओ से विनती करी की हम ख ओमा समान (पैठने) दे। ");
INSERT INTO hlb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","तब दुस्टात्मा उ अदमी म से निकलकर डुक्कर हुन म गई अर वी झुण्ड कड़ाड़े म से झपटकर झील म जाय गिर गयो अर डुब मरियो। ");
INSERT INTO hlb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","चरान वाला यु जो हुओ हतो देख ख भाग्यो, अर नगर म अर गाँव हुन म जाय ख ओखा खबर दियो। ");
INSERT INTO hlb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","लोग यु जो भेयो हतो, ओ ख देखन का निकलियो, अर यीसु को कने आ ख जे अदमी से दुस्टात्मा निकली हती, ओ ख यीसु का पा ख पास कपड़ा पहिने अर चांलाकि से बठ गया ओ ख देख डर गया; ");
INSERT INTO hlb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","अर देखन वाला न ओको बतायो कि वी बुरी आत्मा का सताया हुओ अदमी किस प्रकार चोक्खो हुओ। ");
INSERT INTO hlb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","तब गिरासेनी हुन का आजू बाजू का सब लोगो न यीसु से विनती कि की हमारो यहाँ से चलो जा; काहेकि उन पर बड़ो डर छा गयो हतो। अत: वी नाव म चढ़कर लउट गयो। ");
INSERT INTO hlb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","जे अदमी म से दुस्टात्मा निकली हती वी ओसे विनती करन लगियो कि ओ ख अपन संग रहन दे, परन्तु यीसु न ओको विदा कर ख कहयो, ");
INSERT INTO hlb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“अपन घर का लउट जा अर लोगो से बता कि परमेस्वर न तोरो लियो कैसे बड़ो-बड़ो काम कियो हैं।” वी जाकर सारो नगर म प्रचार करन लगियो, कि यीसु न मोरो लाने कसो बड़ो-बड़ो काम कियो। ");
INSERT INTO hlb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","जब यीसु लउटो तो लोगो ओसे आनन्द का संग मिलियो, काहेकि वी सब ओकी रस्ता देख रहे हते। ");
INSERT INTO hlb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","इतनो म याईर नामक एक अदमी जो प्रार्थना घर का मुखिया हता आयो अर यीसु का पाय पर गिर का ओ ख विनती करन लगियो कि मोरो घर चल, ");
INSERT INTO hlb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","काहेकि ओको बारा वर्स की एक ही पोरी हती, अर वी मरन पर हती। जब वी जा रयो हतो, तब लोग ओ पर गिर पड़त हते। ");
INSERT INTO hlb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","एक बाई न जे को बारा वर्स से खून बहिन का जुड़ हतो, अर जो अपन सारी जिन्दगी की कमाई अपनी ओकात ख अनुसार वैघ हुन का पिछे पिछे खर्च कर चुकी हती, तोभी कोई का हात से चंगी नी हो सकी हती, ");
INSERT INTO hlb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","पिछु से आकार यीसु कपड़ा का आँचल ख छूओ, अर तुरंत ओखा खून बहिनो बंद हो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","इ पर यीसु न कय्हो, “मोखा कोना छुओ?” जब सब मुकरने लगियो, तो पतरस अर ओके संगियो न कय्हो, “हे स्वामी, तोखा तो भीड़ दबा रही हैं अर तो ख पर गिरी पड़त हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","परन्तु यीसु न कय्हो, “किसी न मोखा छुओ हैं, काहेकि मी न जान लियो हैं कि मोरो म से सामर्थ्य निकली हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","जब बाई न देखी कि मी छिप नी सकत; ते वा कापते अई, अर ओको पाय हुन पर गिढ सब लोगो का सामने बतायो कि ओ ना किस कारन से ओखा छुओ, अर कसी तुरत चंगी भई। ");
INSERT INTO hlb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ओ न ओसे कय्हो, “पोरी, तोरो विस्वास न तोखो चोक्खो कियो हैं; सान्ति से चली-जाजो।” ");
INSERT INTO hlb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","वी यू कह ही रहा हतो कि किसी न प्रार्थना घर को मुखिया को यहाँ से आय ख कय्हो, “तोरी पोरी मर गई: गुरू का परेसानी मत कर।” ");
INSERT INTO hlb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","यीसु न यू सुन कर ओखा उत्तर दियो, “मत डर; केवल विस्वास रख, तो वी अच्छी जाहे।” ");
INSERT INTO hlb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","घर म आकर ओ ना पतरस, यूहन्ना, याकूब, अर पोरी कि माय-बाप अर छोड़ अन्य कोई ख भीतर आने नी दियो। ");
INSERT INTO hlb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","सब ओके लियो रोहत हतो, परन्तु ओ ना कय्हो, “रोवा मत; वी मरी नी परन्तु सोई रही हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","वी यु जानकर कि वी मर गई हैं ओकी हँसी उड़ान लगियो। ");
INSERT INTO hlb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","परन्तु ओ ना ओखा हात पकड़ियो, अर पुकार कर कय्हो, “हे पोरी उठ!” ");
INSERT INTO hlb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","अऊर ते ओको प्रान लउट आयो अर वी तुरत उठ बैठी। फिर ओ ना आग्या दी कि ओखा कुछ खाना-खान का दियो जाए। ");
INSERT INTO hlb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ओके माय-बाप गजाब म पड़िया, परन्तु ओ ना उन्हे जतायो कि यु जो हुओ हैं। कोई से नी कहनो। ");
INSERT INTO hlb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","फिर ओ न बारा चेलो को बुलायो, अर उन्हे सब दुस्टात्मा अर जुड़यो का दुर करनु की सामर्थ्य अर अधिकार दियो, ");
INSERT INTO hlb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","अर उनना परमेस्वर का राज्य का प्रचार करन को लाने भेजो। ");
INSERT INTO hlb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ओ न ओ से कय्हो, “रस्ता को लाने कुछ नी लेनो, नी ते लाठी, नी झोला, नी रोटी, नी पैसा अर नी दो-दो कुरता। ");
INSERT INTO hlb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","जे कोई घर म तुम उतरो, उते रहनो, अर उते से विदा लेनू। ");
INSERT INTO hlb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","जे कोई तुम ख ग्रहण नी करे, उ नगर से निकलते बखत हुयो अपन पाय की धुल झाड़ ड़ालनू कि उ पर विरोध गवाई हो।” ");
INSERT INTO hlb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","तब वी निकलकर गाँव-गाँव चोक्खो सुसमाचार सुनायो, अर हर लोगो का चंगो करत हुओ फिरत रहे। ");
INSERT INTO hlb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","देस का चऊथाई राजा हेरोदेस यू सब सुन कर घबरा गयो, काहेकि कुछ न कय्हो कि यूहन्ना मरो हुओ म से जिन्दो भयो हैं, ");
INSERT INTO hlb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","अर कुछ न यू कि एलिय्याह दिखाई दियो हैं, अर ओरो न यू कि पुरानो भविस्यवक्ता हुन म से कोई जिन्दो हो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","परन्तु राजा हेरोदेस न कय्हो, “यूहन्ना का तो मी न सिर कटवा दियो हतो, अब यू कऊन हैं जे के बारे म ऐसो बात सुनत हूँ?” अर ओ ना ओ ख देखन की इच्छा करी। ");
INSERT INTO hlb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","फिर प्रेरित हुन न लउटकर जे कुछ उन न कियो हता ओको बता दियो; अर वी उन्हे अलग कर ख बैतसैदा नाम को नगर म ले गयो। ");
INSERT INTO hlb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","यू जानकर भीड़ ओके पिछे हो ली, अर वी खुसी को संग ओसे मिलियो, अर ओमा परमेस्वर का राज्य की बात करन लगियो, अर जे चंगे होन चाहत हते वी चंगो कियो। ");
INSERT INTO hlb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","जब दिन ढ़लन लगियो तो बारहो चेलो न आकार ओसे कय्हो, “भीड़ का विदा कर कि चारो ओर का गाँव हुन अर बस्ती हुन म जाकर रुकनो अर खाना को उपाय करे, काहेकि हम यु सुनसान जगह म हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","यीसु न उनसे कय्हो, “तुम ही उन ख खान ख देव।” उन्होना कय्हो, “हमारो पास पाँच रोटी अर दो मच्छी हुन ख छोड़ अर कई नी हैं; परन्तु हाँ यदि हम जाय ख इ सब लोगो को लाने खाना मोल लेहे, तो हो सकत हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","वी लोग तो पाँच हजार अदमी का लगभग हता। तब ओ ना अपन चेला से कय्हो, “उन ख पचास-पचास कर ख पंगत म लाइन से बैठा दो।” ");
INSERT INTO hlb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","उन्होना ऐसो ही कियो, अर सब का बैठा दियो। ");
INSERT INTO hlb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","तब ओ ना वी पाँच रोटियाँ अर दो मच्छी हुन ली, अर स्वर्ग की ओर देखकर धन्यवाद कियो, अर तोड़-तोड़कर अपन चेला हुन का देतो गयो कि वी लोगो का परोसे। ");
INSERT INTO hlb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","तब सब न खाना खाकर संतुस्ट हुओ, अर चेलो न बचो हुए टुकड़ो से बारा टोकनी हुन भर का उठायो। ");
INSERT INTO hlb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","जब वी एकान्त म प्रार्थना कर रह हता अर चेला ओको संग हता, तो ओ ना ओसे पुछियो, “लोग मो ख का कहत हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","उन्होना जवाब दियो, “यूहन्ना पानी बपतिस्मा देना वालो, अर कोई एलिय्याह, अर कोई यू कि पुरानो भविस्यवक्ता म से कोई जिन्दो हुयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ओ ना उनसे पुछियो, “परन्तु तू मोखा का कहत हो?” पतरस न उत्तर दियो, “परमेस्वर का मसी।” ");
INSERT INTO hlb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","तब ओ ना उनका जता ख कय्हो कि यु कोई से नी कहनू। ");
INSERT INTO hlb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","फिर ओ ना कय्हो, “इंसान को पोरिया को लाने अवस्य हैं कि वी बेजा दुख उठाए, अर सियाना अर प्रधान पुजारी अर सासतिरी ओखा बेकार (तुच्छ) समझ कर मार डाले अर वी तीसरो दिन जिन्दो हो जाए।” ");
INSERT INTO hlb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ओ ना सब से कय्हो, “यदि कोई मोरो पिछु आनो चाह, तो अपना तुम से इंकार करे अर रोज दिन अपनो सूली उठाए हुओ मोरो पिछे हो ले। ");
INSERT INTO hlb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","काहेकि जो कोई अपन प्रायन बचानो चाहेगो वी ओ ख खोएगो, परन्तु जे कोई मोरो लियो अपन प्रायन खोएगो वही ओ ख बचाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","अदि इंसान पुरो दुनिया ख प्राप्त करे अर अपन जान ख कोई भी हानि उठाए, तो ओ ख का फायदा होगो? ");
INSERT INTO hlb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","अऊर जे कोई भी, मो ख से अऊर मोरी बात हुन से सर्म होऐ, इंसान को पोरिया ख भी, जब अपनी अऊर अपनो बाप कि अऊर सुध्द स्वर्ग दूत हुन कि बड़ाई संग म आहे, ते ओ ख लज्जित जाहे। ");
INSERT INTO hlb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","मी तो से सच कहू हूँ कि जे यहाँ खड़ो हैं, ओमा से कुछ ऐसो हैं कि जब तक परमेस्वर का राज्य नी देख ले, तब तक मरन का स्वाद नी चखे।” ");
INSERT INTO hlb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","इन बात का कोई आठ दिन का बाद वी पतरस, यूहन्ना अर याकूब का संग लेकर प्रार्थना करन का लियो पहाड़ पर गयो। ");
INSERT INTO hlb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","जब उ प्रार्थना कर ही रयो हता, ते ओको चेहरा का रूप बदल गयो, अऊर ओको कपड़ा सफेद हो ख चमकन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","अर देखो मूसा अर एलिय्याह, ये दो व्यक्ति ओको संग बाते कर रह हते। ");
INSERT INTO hlb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ये महिमा सहित दिखायो दियो अर ओके मरनो की चर्चा कर रहे हतो, जे यरूसलेम म पूरो होन वालो हतो। ");
INSERT INTO hlb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पतरस अर ओके संगी नींद से भरियो हते, ते ओकी महिमा अर दो अदमी को, जे ओको संग म खड़ो हतो, देखो। ");
INSERT INTO hlb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","जब वी ओको पास से जानो लगियो तो पतरस न यीसु से कय्हो, “हे स्वामी, हमारो यहाँ रहन भलो हैं: अत: हम तीन मण्डा बनाए, एक तोरो लाने, एक मूसा का लाने अर एक एलिय्याह का लाने।” वी जानत नी हता कि वी का कह रहे हैं। ");
INSERT INTO hlb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","वी यू कह ही रहे हतो कि एक बादल न आकार उन्हे छा लियो, अर जब वी उ घिरनो लगी हो ते डर गयो। ");
INSERT INTO hlb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ते उ बादल म से यू आवाज सुनाई दियो, “यू मोरो पोरिया अऊर मोरो चुनो हुओ हैं, ऐकी बात सुनो।” ");
INSERT INTO hlb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","अऊर यू जोर से आवाज होत ही यीसु अकेलो पायो गयो; अऊर उ चुप रयो, अऊर जे कुछ देखो हतो ओकी कोई भी बात उन दिन हुन म किसी से नी कय्हो। ");
INSERT INTO hlb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","दुसरो दिन जब वी पहाड़ से उतरियो तो एक बड़ी भीड़ ओ से आ मिलीयो। ");
INSERT INTO hlb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","अर देखियो, भीड़ म से एक अदमी न पुकार ख कय्हो, “अरे गुरू जी, मी तो से विनती करत हूँ कि मोरो पोरिया दया ओ म पर कर: काहेकि उ मोरो एक ही पोरिया आय। ");
INSERT INTO hlb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","अर देख, एक बुरी आत्मा ओ ख पकड़त हैं, अर वी एकाएक चिल्लो उठत हैं; अर उ ओ ख ऐसो मरोड़त हैं कि वी मुँह म फेस भर लात हैं; अर ओ ख कुचल ख मूसकिल से छोड़त हैं। ");
INSERT INTO hlb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","मी न तोरा चेला से ओ से निकाल न कि निवेदन करी, पर वी असा न कर सका।” ");
INSERT INTO hlb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","यीसु न उत्तर दियो, “अरे अविस्वासी अर कपटी लोग, मी कब तक तुम्हारो संग म सहूँगो? अपन पोरिया का यहाँ ले आ” ");
INSERT INTO hlb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","वी आ ही हतो कि दुस्टात्मा न ओ ख पटक ख मरोड़ियो, पर यीसु न असुध्द आत्मा ख डांटियो अर पोरिया का चोक्खो कर ख ओके बाप का सोप दियो। ");
INSERT INTO hlb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ते सब लोग परमेस्वर का महा सामर्थ्य से चकित हुओ। परन्तु जब सब लोग उ सब काम हुन से जे उ कर हतो, अचम्भा हते, ते ओ ना अपना चेला हुन से कहयो, ");
INSERT INTO hlb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“तुम इन लोग हुन से कान लगा ख यी आवाज सुनो इंसान को पोरिया इंसान हुन को हात से पकड़यो जान वालो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","परन्तु या बात का नी समझ म हते, अर यू ओसे छिप रह कि वी ओ ख जानन नी पाएँ; अर वी इ बात का विसय म ओसे पूछन से डर रह। ");
INSERT INTO hlb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","फिर ओमा यू झगड़ा होन लगियो कि हम म से बड़ो कऊन हैं। ");
INSERT INTO hlb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","पर यीसु न ओ ख मन ख विचार जान लियो, अर एक पोरिया का लेकर अपन पास खड़ो कियो, ");
INSERT INTO hlb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","अर ओसे कहयो, “जे कोई मोरो नाम से इ बालक पोरिया ख ग्रहण करत हैं, उ मोखा ग्रहण करता हैं, उ मोरो भेजन वाला का भी ग्रहण करत हैं, काहेकि जे तुम म से सब छोटो से छोटो हैं, वही बड़ो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","अऊर ते यूहन्ना न कहयो, “हे गुरू जी, हम न एक अदमी का तोरो नाम से दुस्टात्मा ओखा निकालत देखो, अर हम न ओ ख मना कियो, काहेकि उ हमारो संग होकर तोरो पिछु नी हो लेता।” ");
INSERT INTO hlb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","यीसु न ओसे कहयो, “ओखा मना नी कर; काहेकि जे तुम्हारो खिलाफ म नी, वी तुम्हारो ओर हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","जब ओको ऊपर उठन जानो का दिन पुरो होन पर हते, तो ओ ना यरूसलेम जान का विचार पक्का कियो। ");
INSERT INTO hlb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ओ ना अपन आगु दुत भजो। वी सामरी हुन का एक गाँव म गयो कि ओके लियो जगह तैयार करे। ");
INSERT INTO hlb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","परन्तु उ लोग न ओखा उतरन नी दियो, काहेकि वी यरूसलेम जा रयो हतो। ");
INSERT INTO hlb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","यु देखकर ओके चेला याकूब अर यूहन्ना न कहयो, “हे प्रभु, का तू चाहत हैं कि हम आग्या दे हे, आकास से आगी गिरकर उनका जला दे हे?” ");
INSERT INTO hlb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","पर ओ ना मुड़कर उनखा डाँटियो अर, कहयो, “तुम नी जानत कि तुम कसी आत्मा का हैं। काहेकि अदमी को पोरिया लोगो का प्रायन का नास करन न वरन् बचान को लियो आयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","अर वी किसी दुसरो गाँव म चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","जब वी रस्ता म जा रह हते, ते किसी न ओसे कहयो, “जहाँ-जहाँ तू जाहे, मी तोरो पिछु ही रहूंगो।” ");
INSERT INTO hlb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","यीसु न ओसे कहयो, “लोमड़ी हुन ख लाने गुफा अर आकास का पक्छी हुन ख गुड्डा हुन हैं, पर इंसान को पोरिया ख लाने मुंडी लुकान की भी जगह नी आय।” ");
INSERT INTO hlb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ओ ना दुसरो से कहयो, “मोरो पिछु हो ले” ओ ना कहयो, “हे प्रभु, मोखा पहले जान दे कि मी अपन बाप ख गाड़ दूँ।” ");
INSERT INTO hlb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","अऊर यीसु न ओ से कय्हो, “मुर्दा हुन ख अपनो मुर्दा गाड़न दे। अऊर तुम जा ख परमेस्वर को राज्य को प्रचार कर।” ");
INSERT INTO hlb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","एक अर न भी कहयो, “हे प्रभु, मी तोरो पिछे हो लूगो; पर पहलो मोखा जानू दे कि अपन घर का लोगो से विदा ले आऊ।” ");
INSERT INTO hlb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","यीसु न ओ से कय्हो, “जे कोई अपन हात हल पर रखकर पिछु देखत हैं, वी परमेस्वर का राज्य का योग्य नी।” ");
INSERT INTO hlb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","इ बात का बाद प्रभु न सत्तर अर अदमी नियुक्त कियो, अर जे-जे नगर अर जगह को वी तुम जानू पर हता, वहाँ उनका दो-दो कर ख अपन आगु भेज। ");
INSERT INTO hlb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ओ ना ओसे कय्हो, “पकिया खेत ते बेजा हुन हैं, पर मजदूर थोड़ा हैं, एकोलाने खेत का मालिक से विनती कर कि वी अपन के काटन वाला मजदूर का भेज देहे। ");
INSERT INTO hlb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","जाओ; देख, मी तो ख भेड़ का समान भेड़िया का बीच म भेजू हूँ। ");
INSERT INTO hlb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","एकोलाने नी बटुवा, नी झोला, नी जूता लो; अर नी रस्ता म कोई का नमस्ते कर। ");
INSERT INTO hlb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","जे कोई का घर म जाहे, पहलो कहो, ‘इ घर पर सान्ति हो’ ");
INSERT INTO hlb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","यदि वहाँ कोई सान्ति को योग्य होगो, ते तुम्हारो सान्ति उ पर ठहरेगो, नी ते तुम्हारो पर लउट आएँगो। ");
INSERT INTO hlb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","हुई घर म रह, अर जे कुछ ओ से मिले, हुई खाय-पी, काहेकि मजदूर का अपन मजदूरी मिलन चाही; घर-घर नी फिर। ");
INSERT INTO hlb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","जे नगर म जाए, अर वहाँ का अदमी तुम्हारो उतार, ते जे कुछ तोरो आगु रखो जाए उ खाओ। ");
INSERT INTO hlb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","वहाँ का जुड़ ख अच्छो कर अऊर ओसे कय्हो, ‘परमेस्वर को राज्य तुम्हारो पास आ पहुँचो हैं।’ ");
INSERT INTO hlb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","परन्तु जे नगर म जाओ, अर वहाँ को लोग तोखा ग्रहण नी करे, ते ओके बाजार म जाकर कह, ");
INSERT INTO hlb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘तुम्हरो नगर की धूल भी, जो हमार पाय म लगिया हैं, हम तुम्हारो सामने झाड़ देत हैं; तोभी यू जान ला कि परमेस्वर को राज्य तुम्हारो पास आ पहुँचो हैं।’ ");
INSERT INTO hlb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","मी तुम से कहत हूँ कि उ दिन उ नगर से सदोम की दसा ज्यादा सहन योग्य होए। ");
INSERT INTO hlb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“धितकार खुराजीन! धितकार बैतसैदा! जे सामर्थ्य का काम तू म कियो गयो, यदि वी सूर अर सैदा म कियो जात ते बोरा (टाट) ओढ़कर अर राख म बैठ ख वी कब का मन फिरात। ");
INSERT INTO hlb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","परन्तु न्याय का दिन तो हरो दसा से सूर अर सैदा अधिक सहन योग्य होए। ");
INSERT INTO hlb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","अरे कफरनहूम, का तू स्वर्ग लक ऊँचो करो जाएगो? तू ते अधोलोक लक नीचे जाहे। ");
INSERT INTO hlb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“जे तुम्हरो सुनत हैं, वी मोरो सुनत हैं; अर जे तोखा तुच्छ जानत हैं, वी मोरो भेजन वाला का तुच्छ जानत हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","वी सत्तर खुसी करत हुओ लउटियो अर कहन लगियो, “हे प्रभु तोरो नाम से दुस्टात्मा भी हमार वंस म हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ओ ना ओसे कहयो, “मी सैतान का बिजली के समान स्वर्ग से गिरा हुओ देख रहे हतो। ");
INSERT INTO hlb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","देख, मी न तुम्हे साँप अर बिच्चु का कुचालन का, अर दुसमन की सारो सामर्थ्य पर अधिकार दियो हैं; अर किसी वस्तु से तुम्हारी कुछ हानि नी होए। ");
INSERT INTO hlb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","तोभी ओसे खुसी मत ही कि आत्मा तुम्हारो वंस म हैं, परन्तु जे का खुसी हो कि तुम्हारो नाम स्वर्ग पर लिखो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","हुई बखत वी सुध्द आत्मा म होकर खुसी से भर गयो, अर कहयो, “हे बाप स्वर्ग अर जमीन का प्रभु, मी तोरो धन्यवाद करत हूँ कि तू न इन बात ग्यानियो अर समझदार हुन से छिपा रखिए अर पोरिया हुन पर पर प्रगट कियो। हाँ, हे बाप, काहेकि तोखा यु चोक्खो लगे। ");
INSERT INTO hlb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“मोरो पिता न मोखा सब कुछ सोपियो दियो हैं; अर कोई नी जानत कि पोरिया कोन हैं केवल बाप अर पिता कोन हैं यू भी कोई नी जान केवल पोरिया को अऊर उ जेको पर पोरिया ओ पर प्ररगट करनो चाहे।” ");
INSERT INTO hlb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ते चेला हुन की ओर मुड़कर अकेलो म कहयो, “भलो हैं वी आँखी, जे ये बात जे तुम देखत हो देखते हैं। ");
INSERT INTO hlb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","काहेकि मी तू से कहत हूँ कि बेजा से भविस्यवक्ता हुन अर राजा ओ न चाह कि जे बात तुम देखत हो देख पर नी देखी, अर जे बात तुम सुनत हो सुने पर सुनी।” ");
INSERT INTO hlb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","अर देख, एक व्यवस्थापक उठियो अर यू कह ख ओकी परिक्छा करन लगियो, “हे गुरू अनन्त जीवन का वारिस होन को लाने मी का करूँ?” ");
INSERT INTO hlb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","यीसु ओ से कय्हो, “नेम म का लिखो हैं? तू कसो पढ़त हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ओ न उत्तर दियो, “तू प्रभु अपनो परमेस्वर से अपनो सारो मन अर अपनो साक्ति अर अपनो सारी बुध्दि का संग प्रेम रख, अर अपन बाजू वालो से अपनो समान प्रेम रखनो।” ");
INSERT INTO hlb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","अऊर यीसु न ओसे न कहयो, तुम न अच्छो जवाब दियो यू कर अऊर तुम जिन्दगी मिले।; ");
INSERT INTO hlb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","पर ओ ना अपना तुम का धर्मी ठहरान की इच्छा से यीसु से पूछो, “ते मेरो पड़ोसी कऊन हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","यीसु न उत्तर दियो, “एक अदमी यरूसलेम से यरीहो को जा रहे हतो कि डाकू हुन न घेरकर ओके कपड़ा उतार लाने अर मार पीट ख ओखा अधमरा छोड़कर चलो गयो।” ");
INSERT INTO hlb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","अर ऐसो हुओ कि उ रस्ता म से एक याजक जा रहे हतो, परन्तु ओखा देख कर अनदेखा कर चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","इ रीति से एक लेवी उ जगह पर आयो, वी भी ओखा देख ख देखा कतरा ख चलो गयो ");
INSERT INTO hlb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","परन्तु एक सामरी यातरी वहाँ आ निकल, अर ओ ख देखकर तरस खायो। ");
INSERT INTO hlb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ओ ना ओके नजीक आकर ओके घावो पर तेल अर अंगूर को रस ढ़ालकर पट्टियाँ बाँधी, अर अपनी सवारी पर चढ़ाकर सराय म ले गयो, अर ओकी सेवा टहल की। ");
INSERT INTO hlb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","दुसरो दिन ओ ना दो चाँदी सिक्का निकलकर सराय का मालिक को दियो, अर कहयो, ऐ की सेवा टहल करनु, अर जे कुछ तोरो अर लगेगो, “उ मी लउटनू पर तोखा दे दूँगो।” ");
INSERT INTO hlb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","यीसु न कहयो, अब तोरी समझ म जे डाकू हुन म घिरि गयो हतो, “उ तीनो म से ओको पड़ोसी कऊन होए?” ");
INSERT INTO hlb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","अऊर ओ न कय्हो, “वही जे न उ पर दया कियो।” यीसु न ओ से कय्हो, “जा तू भी असो ही कर।” ");
INSERT INTO hlb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","अऊर यीसु अऊर उनको चेला सफर कर रहे हता। ते यीसु एक गाँव म आयो, वहाँ पर मार्था नाम कि एक बाई न अपनो घर पर उनको आदर कियो। ");
INSERT INTO hlb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","मरियम नामकी ओकी एक बहिन हती। उ प्रभु का पाय म बैठ ख ओखा वचन सुनत हती। ");
INSERT INTO hlb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","पर मार्था काम करते करते मार्था चिंता म गई अऊर ओ के पास आ ख कहन लगिया, “हे प्रभु, का तोखा मोरी कोई भी चिन्ता नी हैं कि मोरी बहिन न मोखा सेवा करन का लियो अकेली ही छोड़ दियो हैं? एकोलाने ओसे कह कि मोरी सहायता करे।” ");
INSERT INTO hlb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","प्रभु न ओखा उत्तर दियो, “मार्था, हे मार्था; तू बेजा ज्यादा बात की चिन्ता करा अर घबरावा हैं। ");
INSERT INTO hlb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","पर एक बात आवस्यक हैं, अर अच्छो भाग का मरियम न चुन लियो हैं जे ओसे छिनो नी जाएगो।” ");
INSERT INTO hlb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ते एक बखत यीसु कोई जगह पर विनती कर रयो हतो, विनती खत्म होन पर उनको एक चेला न उनसे कय्हो, “प्रभु हम का निवेदन करनो सिखा, जसो यूहन्ना न अपनो चेला हुन ख सिखायो रहा।” ");
INSERT INTO hlb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","यीसु न ओसे कय्हो, जब तुम प्रार्थना करे: ते कहेनो: अरे बाप, तोरो नाम सुध्द मानो जाहे, तोरो राज आय। ");
INSERT INTO hlb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","हमरी दिन भर की रोटी हर रोज हम ख दियो कर, ");
INSERT INTO hlb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","अर हमरा पाप हुन ख माप करयो, काहेकि हम भी अपन हर एक अपराधी का माप करा हैं, अर हमका परीक्छा म मत ला। ");
INSERT INTO hlb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","अऊर यीसु उन से कय्हो भी हतो, “तुम म से कोन हैं कि ओको दोस्त होय, अर उ आधी रात ख ओको नजीक जाय ख ओसे कहयो, अरे दोस्त मोखा तीन रोटी दे। ");
INSERT INTO hlb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","काहेकि एक यातरी दोस्त मोरो नजीक आयो हैं, अर ओको आगे रखनो ख लाने मोरो पास कुछ नी हाय।” ");
INSERT INTO hlb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","अर उ घर को अन्दर से उत्तर दे, “मो ख तंग मत कर। अब ते दरवाजा बन्द हो चुको हैं। मोरो पोरा पोरी ख मोरो संग बिस्तर पर हैं, मी उठ ख तुम ख कई भी नी दे सका हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","मी तुम से कहू हैं, अदि ओको दोस्त होनो पर भी ओ ख उठ ख नी दे; तेभी ओखा लाज ख छोड़ ख माँगन को कारन ओखा जित्ती जरूरत होए उत्ती उठ ख देहे। ");
INSERT INTO hlb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","अऊर मी तुम से कहू हैं कि माँगो, ते तुम ख दियो जाहे; ढूँडे, ते तुम ख मिलेगो; खटखटाओ, ते तुमारो लाने खोलो जाहे। ");
INSERT INTO hlb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","काहेकि जे कोई माँगे हैं, ओ ख मिला हैं; अर जे ढूढ़ा हैं, ओ ख मिला हैं; अर जे खटखटाऊ हैं, ओको लाने खोलो जाहे। ");
INSERT INTO hlb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","अदि तुमरो म से असो कऊन सो बाप होए, कि जब ओको पोरिया रोटी माँगे, ते ओ ख पत्थर देहे; या मच्छी माँगे, ते मच्छी को बदला ओ ख साँप देहे? ");
INSERT INTO hlb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","या अण्डा माँगे ते ओ ख बिच्चु दे हे? ");
INSERT INTO hlb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","एकोलाने जब तुम बुरा होय ख अपना पोरिया-पारी ख अच्छी चीज देनो जाना हैं, “ते स्वर्ग म रहन वालो बाप अपना माँगन वाला हुन ख सुध्द आत्मा काहे नी देहे।” ");
INSERT INTO hlb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","अऊर यीसु एक दुस्टात्मा गूँगा हतो, निकल रह हतो। दुस्टात्मा ख निकलते ही गूँगा अदमी कहन लगो अऊर अदमी अचम्भा म पड़ गयो हतो ");
INSERT INTO hlb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","पर ओ म से कुछ न कहयो, “यू ते सैतान बालजबूल नाम को दुस्टात्मा हुन को मुखिया कि मदत से दुस्टात्मा हुन ख निकाला हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","अऊर हुन न ओकी यीसु परीक्छा करन को लाने ओसे स्वर्ग को एक चिखान माँगो। ");
INSERT INTO hlb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","पर ओ न उनको मन की बात जान ख, उनसे कहयो, “जे-जे राज्य म फूट होवा हैं, उ राज्य उजड़ जावा हैं; अर जे घर म फूट होवा हैं, उ नास हो जावा हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","यदि सैतान अपनो ही बैरी हो जाए, ते ओको राज्य कसो बनो रहेगो? काहेकि तुम मोरो बारे म तो कहाँ हैं कि यु बालजबूल सैतान की मदद से दुस्टात्मा हुन ख निकालू हैं। ");
INSERT INTO hlb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","अऊर मी बालजबूल कि मददत से दुस्टात्मा ख निकालू हैं, ते तुमारो पोरिया को की मददत से उन ख निकाल हैं? एकोलाने वी तुम लोग हुन ख न्याय करे। ");
INSERT INTO hlb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","पर अदि मी परमेस्वर को सक्ति से दुस्टात्मा का निकालू हैं ते परमेस्वर को राज्य तुम्हारो नजीक आ पहुँचियो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","अऊर जब बलवान अदमी हथियार बाँध ख, अपनो घर की रखवाली हैं, ते ओकी धन-दऊलत (संपत्ति) बची रहवा हैं। ");
INSERT INTO hlb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","पर जब ओसे बढ़ ख कोई बलवान चढ़ाई कर ख ओ ख जीत लेवा हैं, ते ओखा वी अऊजार जिन पर ओको भरोसा हतो, छुड़ा लेवा हैं, अर ओकी धन-दऊलत लूट ख बाँट देवा हैं। ");
INSERT INTO hlb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","जे मोरो संग नी उ मोरो विरोध म हैं, अऊर जे मोरो संग नी बटोरा उ उबिखेरा हैं। ");
INSERT INTO hlb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“अऊर बुरी आत्मा अदमी म से निकल जाय हैं ते सुखी जगह म आराम ढूँढ़ते फिरा हैं, अर जब नी पाय हैं ते बोला हैं, ‘मी अपनो उई घर म जहाँ से निकल हती लोउट जाऊ।’ ");
INSERT INTO hlb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","अर आ ख ओखा झाड़ो-बुहारो अर सजो-सजायो पाहे हैं। ");
INSERT INTO hlb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ते उ जाय ख अपनो से भी जादा सात बुरी आत्मा हुन ख लेख आय हैं अऊर वे उ घर म अन्दर जा ख उ बस जाते हैं। यूईच कारन उ अदमी कि या पिछलो दसा पहली से भी जादा बुरी हो जाय हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","जब उ या बात कहत ही रह हतो ते भीड़ म से किसी बाई न बड़ी जोर से कहयो, “धन्य हैं वा कोक जेमा तू पैदा भयो अर माय को दूध जे तू न पियो।” ");
INSERT INTO hlb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","अऊर यीसु न कय्हो, “हव; पर धन्य वी हैं जे परमेस्वर का वचन सुना अर माना हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","अऊर जब भीड़ बडत जावा अर जुडते होन लगी ते यीसु कहन लग गयो, “यू जमाना ख अदमी बुरा हैं; वी चिन्ह ढूढ़ा हैं; पर योना चिन्न का छोड़ कोई अऊर चिन्ह उन ख नी दियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","जसो योना नीनवे का अदमी हुन को लियो चिन्ह ठहरायो, वसो ही इंसान को पोरिया भी यु युग का अदमी हुन को लियो ठहरेगो। ");
INSERT INTO hlb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","दक्छिन की रानी न्याय को दिन यु बखत का अदमी हुन को संग उठकर उन का दोसी ठहराएगो, काहेकि उ सुलैमान को ग्यान सुनन ख दुनिया की उ छोर से आई, अर देखनु, यु उ हैं जे सुलैमन से भी बड़ो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","अऊर नीनवे का लोग न्याय को रोज या बखत ख लोग हुन को संग खड़ो हो ख, उनका, दोसी ठहरायगो; काहेकि उन ना योना को प्रचार सुन ख मन फिरायो, अर देखनु यु उईच आय हैं जे योना से भी बड़ो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“कोई अदमी दीया जला ख तलघर म या डुल्ला को नीचू नी रखा हैं, पर दिया ठानी दिया रखने की जगह पा रखा हैं कि अन्दर आन वाला का उजेरो मिले। ");
INSERT INTO hlb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","तोरो सरीर को दिया तोरी आँख हैं एकोलाने जब तोरी आँख चोक्खी हैं तो तोरो पुरो सरीर भी उजरो हैं; पर जब वा बुरी हैं ते तोरो पुरो सरीर भी अन्धेरो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","एकोलाने यू बात ख याद रखनो कि जे उजरो तुम म हैं, उ अन्धरो नी हो जाहे। ");
INSERT INTO hlb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","एकोलाने अदि तोरो पुरो सरीर उजलो होए अर ओकी कोई अंग अंधेरो नी रहे ते पूरो को पूरो असो उजेला होएगो, जसो वा बखत होवा हैं जब दिया अपनो चमकनो से तोखा उजाला देवह हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","अऊर जब यीसु बात कर ही रयो हतो कि ते कोई फरीसी न उन से यू विनती कियो, “की तू मोरो संग खानो करे।” यीसु अन्दर जा ख खानो करन बैठियो। ");
INSERT INTO hlb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","फरीसी न यू देख ख अचम्बा भयो कि ओ न खाना खान से पहलो हात पाय नी धोयो। ");
INSERT INTO hlb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","प्रभु न ओसे कय्हो, “अरे फरीसी हुन, तुम कटोरा हुन अर कोपर का ऊपर से तो मांजा हैं, पर तुमरो भीतर लालच अर बुरी बात भरी हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","अरे बे अकली जेना बाहर को भाग बनायो, का ओ ना अन्दर को भाग नी बनायो? ");
INSERT INTO hlb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","पर अन्दर वालो भाग ख दान कर देव, ते देख सब कुछ तुम्हारो लियो सुध्द हो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“पर अरे फरीसी हुन, तुम पर धितकार! पुदीने अर सोप का अर सब भाँति का साग-पात का दसवां हिस्सा (अंस) देवा हैं, पर न्याय को अर परमेस्वर को प्रेम का टाल देवा हैं तुमारी मर्जी या होनो थो कि इन ख भी कर रहनो अर उन ख भी नी छोड़ते। ");
INSERT INTO hlb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“हे फरीसी हुन, तुम पर धितकार! तुम प्रार्थना घर हुन म अच्छी-अच्छी जगा आसन अर बजार हुन म प्रेम नमस्कार चाहवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","धितकार तुम पर! काहेकि तुम वा लुकि समसान को जसो हैं, जिन को ऊपर अदमी हुन चला हैं पर नी जाना ");
INSERT INTO hlb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","तब एक व्यवस्थापक न ओको जवाब दियो “अरे गुरू या बात हुन को बोलनो से तुम हमारो बुराई करा हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","अऊर यीसु न कहयो दियो, व्यवस्थापक ख सिक्छाक धितकार हैं तुम इंसान हुन पर असो बोझ लादते हैं। जिन ख ढोना कठिन हैं, पर तुम उन ख उठान का लाने अपनी एक उँगली भी नी लगा। ");
INSERT INTO hlb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","अऊर धितकार हैं! पर तुम भी भविस्यवक्ता हुन कि समसान बनाव हैं जिनका तुमरो बाप दादा हुन न मार डालियो रह। ");
INSERT INTO hlb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","अऊर पाप हुन ख माफ कर, काहेकि हम ख भी अपनो हरो एक अपराधी ख माफ कर हैं, अऊर हम ख परीक्छा म नी ला। ");
INSERT INTO hlb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","एकोलाने परमेस्वर को ग्यान न भी कहयो हैं मी उनको नजीक भविस्यवक्ता उन का अर प्रेरित उन का भेजोगो अर वी उन म से कई का मार ड़ालेगो अर कुछ का सताएगो। ");
INSERT INTO hlb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","एकोलाने दुनिया को सुरू से जित्ता भविस्यवक्ता हुन को खून बहायो गयो हैं हाबिल को खून से लेख जकरयाह को खून तक, जे मूर्ती अर मन्दिर गर्भ को बीच मारो गयो हतो ओको लेखा यू पीढ़ी ख चुकानो पड़े। मी तुम से कहूँ हैं, कि लेखा यूईच पीढ़ी ख चुकानो पड़े। ");
INSERT INTO hlb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","हाबिल की माऊत से लेका जकरयाह की हत्या तक जो वेदी अर मंदिर को बीच म मार कियो गया हैं मी तुम से सही बोलू हैं इन सब को लेखा यु बखत को इंसान से लियो जाएगो ");
INSERT INTO hlb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","अऊर व्यवस्थापक धितकार हैं तुम लोग हुन ख! काहेकि तुम न ग्यान की कुंजी ले ते लियो हैं पर तुम न स्वंय ही न भीतर नी करे अर जे भीतर करे रहे हतो उन ख रोक दियो हैं ");
INSERT INTO hlb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","जब उ वहाँ से निकलो, ते सासतिरी अर फरीसी बुरी तरीका से ओको पिछे पड़ गया अर छोड़न लगियो कि उ बेजा सी बात की चर्चा करे, ");
INSERT INTO hlb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","अऊर वी यूईच देख रया हता कि यीसु को मुन्डा से निकली कोई बात ख पकड़े। ");
INSERT INTO hlb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","अऊर इत्ता म हजार हुन लोग हुन कि भीड़ लग गई, इत्ते का लोग एक दुसरा हुन को कुचल रयो हतो। ते यीसु पहलो अपनो चेला हुन से कह लगो, “फरीसी हुन ख कपटी जसा खमीर से होसियार रहनो।” ");
INSERT INTO hlb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","कुछ ढको नी, जे खोलो नी जान को; अर न कुछ लूको हैं, जे समझो नी जान को। ");
INSERT INTO hlb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","एकोलाने जे कई तुम न अंधेरो म कय्हो हैं, उ उजेलो म सुनायो जाएगो; अर जो तुम न कोठरी हुन म कान ही कान म बोल्यो हैं उ छत पर से प्रचार कियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","मी तुम से जो मोरा दोस्त आय कहू हैं कि जो सरीर का चोट करत हैं पर ओको पिछे अर कुछ नी कर सकत, ओसे मत डर। ");
INSERT INTO hlb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","मी तुम ख जताऊ हैं कि तुमका कोसे डर नो चाहिए, घात करन का बाद जेका नरक म डालन को अधिकार हैं, ओ से ही डर; हाँ मी तो से कहूँ हैं, ओ से ही डरनू। ");
INSERT INTO hlb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","का दो पैसा कि पाँच गऊरैया नी बाकी? तेभी परमेस्वर ओमा से एक का भी नी भुला। ");
INSERT INTO hlb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","तुमारो मुण्डी का सब बाल भी गिनिया वाला हैं एकोलाने डर नो मत, तुम ढ़ेर सारा गऊरैया से बढ़ ख हैं। ");
INSERT INTO hlb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“मी तो से कहू हैं, जो कोई अदमी को सामने मोखा मान लेहे ओ ख इंसान को पोरिया भी परमेस्वर का स्वर्गदूत का सामने मान लेहे।” ");
INSERT INTO hlb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","पर जो अदमी को सामे मोरो इंकार करे ओ ख मी भी परमेस्वर को स्वर्गदूत को सामे इंकार करूगो। ");
INSERT INTO hlb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“जो कोई इंसान को पोरिया को खिलाप म कोई बुरी बात कहे, ओको वी अपराध माप कियो जाहे, पर जो सुध्द आत्मा की बुराई करे, ओको अपराध छमा नी कियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“जब अदमी हुन तुमका प्रार्थना घर अर हाकिमो अर अधिकारी हुन को सामे ले जाहे, ते चिन्ता नी करनु कि हम कसो रिती से या का उत्तर देहे, या का कहे। ");
INSERT INTO hlb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","काहेकि सुध्द आत्मा उत्तीच बखत तुमका सब सिका देहे कि का कहनो चाहिए।” ");
INSERT INTO hlb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","फिर भीड़ म से एक न ओसे कहयो, “अरे गुरू मोरो भई से कहूँ की बाप की धन-दऊलत मोरो संग बाँट ल।” ");
INSERT INTO hlb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ओ न ओसे कहयो, “व्यक्ति, को न मो ख तुमरो न्याय करत न वालो या बाँटन वालो नियुक्त कियो हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","अर ओ न ओसे कहयो, “सतर ख रहनो, अर सब प्रकार को लोभ से अपनो तुम ख बचा ख रखनू; काहेकि कि कोई को जीवन ओकी धन-दऊलत को ज्यादा होनो से नी होवा।” ");
INSERT INTO hlb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","फिर यीसु न उन ख यू उदाहरन सुनायो; “कोई धनवान कि जगह पर बेजा फसल भई।” ");
INSERT INTO hlb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","एको बाद उ अपनो मन म विचार करन लग गयो, मी का करूँ? काहेकि मोरो यहाँ जगह नी जहाँ अपनो अनाज अऊर कुछ रखूँ। ");
INSERT INTO hlb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","अर ओ न कय्हो, मी असो करुँगो मी अपनो बखारी का तोड़ ख ओसे बड़ी बनाऊँगो; अर वहाँ अपन सब अनाज अर धन-दऊलत रखूगो; ");
INSERT INTO hlb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","अर अपनो मन से बोलुगो कि मन, तोरो पास बेजा साल को लाने बेजा दऊलत धरी हैं; चैन कर खा पी, सुख से रह। ");
INSERT INTO hlb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","पर परमेस्वर न ओसे कय्हो, अरे मुर्ख! या रात तोरी जान तो से ले लियो जाहे; तब जो कुछ तू न जोड़ियो हैं उ कोको होय? ");
INSERT INTO hlb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","असो ही उ इंसान भी हैं जो अपनो लाने पैसा जोड़ा हैं, “पर परमेस्वर की नजर म धनी नी हाय” ");
INSERT INTO hlb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","फिर ओ न अपना चेला हुन से कय्हो, “एकोलाने मी तुम से बोलू हैं, अपनो जिन्दगी को लाने यू चिन्ता करनो कि हम का खाएँगो; न अपनो सरीर की, कि हम का पहिने।” ");
INSERT INTO hlb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","काहेकि खाना से जान, अर कपड़ा से सरीर बढ़ ख हैं। ");
INSERT INTO hlb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","कोऊवा हुन पर ध्यान देव; वी न बोवा हैं, न काटा नी उ ख बखारी अऊर नी बखारी हुन होवा हैं! तेभी परमेस्वर उन ख खिलावा हैं। तुमारो का दरजा इन पक्छी हुन से कही जादा नी हैं। ");
INSERT INTO hlb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","तुम म से असो कोन हैं जे चिन्ता करनो से अपनी उमर म एक घड़ी भी बढ़ा सकह हैं? ");
INSERT INTO hlb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","एकोलाने यदि तुम सबसे छोटो काम भी नी कर सका, ते अऊर बात हुन को लाने कहे चिन्ता करा हैं? ");
INSERT INTO hlb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","जंगल का फूल हुन पर ध्यान देव कि वी कसा बड़ा हैं: वी न तो मेहनत करा हैं न काता हैं; तेबी मी तुम से कहूँ हैं कि सुलैमान भी अपनो पुरो राज्य म, उनमा से कोई एक को समान कपड़ा पहिनिया नी हतो रह ");
INSERT INTO hlb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","एकोलाने जब भी परमेस्वर बररा कि घास ख, जे आज हैं अर कल आगी म झोकी जाएगो, असो पहिनावा हैं; ते अरे अल्प विस्वासी हुन, उ तुम ख काहे नी पहिना हे? ");
INSERT INTO hlb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","अर तुम यू बात की ताक म मत रहनू की का खाएगो अर का पाएगो, अर न मन संका करनो ");
INSERT INTO hlb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","काहेकि दुनिया की जात हुन यी सब चीज हुन की खोज म रहवा हैं: अर तुमरो परमेस्वर बाप जाना हैं कि तुम ख यी चीज हुन की जरूरत हैं। ");
INSERT INTO hlb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","पर ओखा राज की खोज म रहनू, ते यी चीज भी तुम ख मिल जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“अरे छोटा झुंड, मत डर; काहेकि तुम्हारो बाप का यू भयो हैं, कि तुमका राज दे। ");
INSERT INTO hlb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","अपनी धन-दऊलत बेच ख दान कर देव; अर अपनो लाने असो बटुवा बनाव जो जुनना नी होवा, एकोमतलब स्वर्ग म असो धन इकट्ठो करो जो की घटा नी अर जे को जोने चोर नी जावा, अर कीड़ा नी बिगड़ सका। ");
INSERT INTO hlb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","काहेकि जहाँ तुमारो धन रहे, वही तुमरो मन भी लगो रहे। ");
INSERT INTO hlb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“अऊर तुमारो कमरे बन्धी रया अऊर तुमारो दिया जलते रह, ");
INSERT INTO hlb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","अर तुम ख वी अदमी हुन को जसो बननो चाहिए, जो अपनो मालिक की रस्ता देख रया होय कि उ सादी से कब लउटेगो कि जब उ आ ख दरवाजा खटखटाए ते जादा ओको लाने खोल देऊ। ");
INSERT INTO hlb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","धन्य हैं वी दास जेको मालिक आय जगते देखे मी तुम ख सच कहूँ हूँ कि उ कम्मर बाँध ख उन ख खाना खलान ख बैठाले, अर नजीक आँख उनकी सेवा करेगों। ");
INSERT INTO hlb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","अदि उ रात को दुसरो या तीसरो पहर म आ ख उन ख जगते देखे ते वी दास धन्य हैं। ");
INSERT INTO hlb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","पर तुम यु समझ लेनो, की अदि घर को मालिक (स्वामी) जानतो कि चोर कित्ती घड़ी आएँगो, ते जगते रहनू अर अपनो घर म चोरी नी होन देन को ");
INSERT INTO hlb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","तुम भी तैयार रहनो काहेकि जे बखत तुम सोचा भी नी उन्ती बखत इंसान को पोरिया आ जाएगो।” ");
INSERT INTO hlb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","तब पतरस न कय्हो, “अरे प्रभु, का यू उदाहरन तू हम से ही या सब ख कहवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","प्रभु न कय्हो, “वी भरोसा अर बुध्दिमान भण्डारी कोन हैं, जेको स्वामी ओखा नऊकर चाकर हुन पर सरदार ठहरायो कि उन का बखत पर खान कि समान दे।” ");
INSERT INTO hlb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","भलो हैं वी दास, जेका ओको मालिक आय ख असो ही करत पायो। ");
INSERT INTO hlb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","मी तो से सच कहूँ हैं, वी ओ ख अपनी सारी धन-संपति पर हक ठहराएगो। ");
INSERT INTO hlb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","पर अदि उ सेवक सोचन लग जाहे कि मोरो मालिक आनो म देर कर रहयो हैं अर दास हुन अर दासी हुन का मारन पिटन लग गयो, अर खान-पीवन अर पियक्कड़ होन लगियो ");
INSERT INTO hlb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ते उ दास को मालिक असो दिन जब उ ओकी बाट जोहता नी रह, अऊर असी बखत जेसे उ पता नी हो आहे अऊर ओ ख भारी दण्ड देकर ओको भाग अविस्वासी हुन ख संग ठहराएगो। ");
INSERT INTO hlb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","वी दास जे अपनो मालिक कि इच्छा जानत रह हता अर तैयार नी रहा अर नी ओकी इच्छा को अनुसार चलो, अर बेजा मार खाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","पर जे न जानकर मार खान को योग्य काम करा उ थोड़ी मार खाएगो। एकोलाने जे ख बेजा दियो गयो हैं, ओसे बेजा माँगियो जाहे; अर जे ख बेजा सऊपियो गयो हैं ओसे बेजा लियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“मी दुनिया पर आग लगान आयो हैं अऊर का चाहूँ हैं मी केवल यू कि अभी आगी परचा जाय हैं! ");
INSERT INTO hlb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","मो ख तो एक पानी बपतिस्मा लेन हैं अर जब तक उ नी हो लेन को तब तक मी कसो दुख म रहूंगो। ");
INSERT INTO hlb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","का तुम समझा हैं कि मी जमीन प सान्ति या मिलाप करन ख आयो हूँ? मी तोसे कहू हैं अर; नी, पर अलग करान आयो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","काहेकि अब से एक ही घर म पाँच जन आपस म बैर रखेगो, तीन दो से अर दो तीन से। ");
INSERT INTO hlb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","बाप पोरिया से अर पोरिया बाप से बैर रखोगो: माय-पोरी से, अर पोरी माय से, सास बहू से, बहू सास से रखोगी।” ");
INSERT INTO hlb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ओ न भीड़ से भी कय्हो, “जब तुम बददल का तरफ पस्चिम से उठते देखा हैं ते तुरंत कह हो कि बारिस होवन वाली हैं, अर असो ही होवा हैं, ");
INSERT INTO hlb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","अर जब दक्छिनी हवा चलते देखा हैं ते बोला हैं की धूप (लूह) चले, अर असो ही होवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","अरे कपटी हुन, तुम जमीन अर आकास को रंग-रूप म भेर कर सका हैं, ते यु युग को बारे म काहे भेद करनो नी जाना? ");
INSERT INTO hlb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“तुम अपनो तुम म ही निर्नय काहे कर लेवा कि उचित का हैं? ");
INSERT INTO hlb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","जब तू अपनो गवाह को संग न्याय करन वालो ख नजीक जा रहे हो, ते मार्ग म ही ओ ख से समझोता करन कि कोसिस कर। कही असो नी हो कि उ तुम ख न्यायाधीस को नजीक खीच ले जाहे अऊर न्यायाधीस तुम ख सिपाई को हवालो कर दे। अऊर सिपाई तुम ख जेल खाना म डाल दे। ");
INSERT INTO hlb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","मी तो से कहूँ हैं कि जब लक तू दमड़ी-दमड़ी भर नी देहे तब लक वहा से छुट नी पावन को।” ");
INSERT INTO hlb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","अऊर बखत कुछ लोग यीसु ख उन ख गलीली हुन ख बारा म बतान आहे, जिनको खून राजपाल पिलातुस न उन ख बलि चढ़न वालो जानवर हुन ख खून म मिलो दियो हतो। ");
INSERT INTO hlb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","यू सुन ख ओ ना ओसे जवाब म असो कय्हो, “का तुम समझा हैं कि यी गलीली अर सब गलीली हुन से जादा पापी हता कि उन पा असो दुख पड़ीयो? ");
INSERT INTO hlb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","मी तुम से कहू हैं कि नी; पर तुम मन नी फिरान ते तुम सब भी असो ही नास होए। ");
INSERT INTO hlb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","या का तुम समझा हैं कि वी अठारह व्यक्ति जेन पर सीलोह को गुम्मट गिरो, अर वी दब ख मर गया: यरूसलेम ख अऊर सब रहन वाला से जादा अपराधी हता? ");
INSERT INTO hlb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","मी तो से कहत हूँ कि नी; परन्तु अदि तू मन नी फिराएगो ते तुम सब भी इस रीति से नास होगो।” ");
INSERT INTO hlb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ते यीसु न यू उदाहरन भी सुन्यो, “किसी की अदमी को अंगूर की बारी म एक अंजीर का झ़ाड़ लग गयो हतो। उ ओ म फल ढुढ़न आयो, पर ओ म एक भी नी मिलो। ");
INSERT INTO hlb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","तब ओ न बारी को रखन वालो से कय्हो, ‘देख, तीन साल से मी इ अंजीर को झ़ाड़ म फल ढूँढ़न आत हूँ, परन्तु नी पात हूँ। ऐका काट डाल का यू जमीन का भी काहे रोकत हो?’ ");
INSERT INTO hlb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ओ ना ओको उत्तर दियो, ‘हे मालिक ऐखा इ साल अर रहन दे कि मी ऐखा चारो तरफ खोदकर ऐमा खाद डालूगो।’ ");
INSERT INTO hlb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","यदि आगु का फले ते भलो, नी ते ओखा काट डालनू।” ");
INSERT INTO hlb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","आराम को दिन वी एक प्रार्थना घर म सिक्छा दे रयो हतो। ");
INSERT INTO hlb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","वहाँ एक बाई हती जेका अठारह साल से एक दुर्बल करन वाली बुरी आत्मा लगी हती, अर वी कुबड़ी होई गई हती अर कोई रीति से सीधो नी हो सकत रह हता। ");
INSERT INTO hlb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","यीसु न ओ ख देख ख बुलायो अर कय्हो, “हे नारी, तू अपनी कमजोरी से छूट गई।” ");
INSERT INTO hlb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","तब ओ ना ओ पर हात धरियो, अर वा तुरत सिधो हो गई अर परमेस्वर कि बड़ाई करन लग गई। ");
INSERT INTO hlb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","एकोलाने कि यीसु न आराम को दिन ओ ख चोक्खो करी रह, प्रार्थना घर को मुखिया गुस्सा हो ख लोग हुन से कहन लग गयो, “छे: दिन हैं जे म काम करनो चाहिए, अत: वी दिन हुन म आ ख अच्छा होव पर आराम का दिन म नी।” ");
INSERT INTO hlb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","यू सुन कर प्रभु न उत्तर दियो, “हे कपटी हुन का आराम का दिन का तुम म से हर एक अपन बईल या गदही का थान से खोल ख पानी पिलाव नी ले जाय? ");
INSERT INTO hlb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ते का अच्छो नी हता कि यु बाई जे अब्राहम की पोरी हैं जे ख सैतान न आठरह साल से बाँध का रखो हतो, आराम को दिन ऐ ख बन्धन से छुड़ाई जाहे?” ");
INSERT INTO hlb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","जब यीसु ख इन सब्द हुन से उन ख सब विरोध लज्जित हो गया; लेकिन पूरी जनता उनको सामने बड़ाईमय काम हुन ख देख ख खुसी भई। ");
INSERT INTO hlb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","फिर यीसु कय्हो, “परमेस्वर का राज्य कोको समान हैं? अर मी ओकी उपमा कोसे दूँ? ");
INSERT INTO hlb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","वी राई को एक दाना का समान हैं, जेका किसी अदमी न लेकर अपनो खेत म बोयो: अर वी बढ़ ख झाड़ बन गयो; अर आकास की चिड़िया न ओकी डाली पर अपनो बसेरा कियो।” ");
INSERT INTO hlb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ओ न फिर कय्हो, “मी परमेस्वर का राज्य का उपमा कोसे दूँ? ");
INSERT INTO hlb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","वी खमीर का समान हैं, जेको किसी इ बाई न लेकर तीन पसेरी आटा म मिलायो, अर होत होत सब आटा खमीर बन गयो।” ");
INSERT INTO hlb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","वी नगर-नगर, अर गाँव-गाँव म होकर सिक्छा देत हुयो यरूसलेम की ओर जा रहे हतो, ");
INSERT INTO hlb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ते किसी न ओसे पुछियो, “हे प्रभु का उध्दार पान वाला थोड़ो हैं?” ओ ना ओसे कय्हो, ");
INSERT INTO hlb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“सकेत दरवाजा से प्रवेस करन को कोसिस कर, काहेकि मी तुम से कह हूँ कि बेजा से प्रवेस करनो चाह, अऊर नी कर सक। ");
INSERT INTO hlb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","जब घर का स्वामी उठकर अपन दुवार बंद कर चुको होए, अर ते तुम बाहर खड़ा हो दुवार खटखटाकर कहन लगियो, ‘हे प्रभु हमार लियो खोल दे’ अर उ उत्तर दे, ‘मी तुम्हे नी जानत, तुम किते का हो?’ ");
INSERT INTO hlb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","तब ते कहन कहन लगियो, ‘हम न तोरो सामने खाय-पियो अर तू न हमार बाजार म सिक्छा कियो।’ ");
INSERT INTO hlb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","परन्तु उ कहेगो, ‘मी तोसे कहत हूँ मी नी जानता तुम कहाँ से हो हे अधर्मी करन वाला, तुम सब मोसे दूर हो!’ ");
INSERT INTO hlb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","वहा रोनो अर दाँत पिसनो हुए; जब तुम अब्राहम अर इसहाक अर याकूब अर सब भविस्यवक्ता हुन का परमेस्वर का राज्य म बैठियो, अर अपन तुम को बाहर निकाल हुओ देखोगो; ");
INSERT INTO hlb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","अर पूरब अऊर पच्छिम; उत्तर अर दक्छिन से लोग आय का परमेस्वर का राज को भोज म भागी होएगो। ");
INSERT INTO hlb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","अर देखो, कुछ पिछलो हैं वी पहलो होएगो, अर कुछ जे पहलो हैं, वी पिछलो होएगो।” ");
INSERT INTO hlb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","उसी घड़ी कुछ फरीसी हुन न आकर ओसे कय्हो, “यहाँ से निकलकर चलो जा, काहेकि हेरोदेस राजा तोखा मार डालनू चाहत हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ओ न ओसे कय्हो, जाकर उ लोमड़ी से कहू दो कि देख, मी आज अर कल दुस्टात्मा का निकलत अर जुड़ का चंगो करत हैं, अर तीसरो दिन अपनो काम पुरो करुँगो। ");
INSERT INTO hlb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","तेभी मोखा आज अर सक्कार अर परोसो चलनो जरुरी हैं, काहेकि हो नी सका की कोइ भविस्यवक्ता यरूसलेम को बाहर मारो जाय। ");
INSERT INTO hlb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“हे यरूसलेम! हे यरूसलेम! तू जे भविस्यवक्ता हुन का मार डाला हैं, अर जे तोरो पास भेज्या गया उनको पर पथराव करा हैं। कित्ती ही बार मी न यू सोचियो कि जसी मुर्गी अपना बच्चा ख अपना पंख हुन को नीचु एकजुट करा हैं, वसो ही मी भी तोरा पोरिया हुन ख एकजुट करुँ, पर तुम न यू नी चाय्हो। ");
INSERT INTO hlb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","देखनु, तुमरो घर तुम्हारो लाने उजाड़ छोड़ो जावा हैं, अर मी तुम से कहूँ हैं: जब तक तुम नी कहन का, ‘धन्य हैं उ, जे प्रभु को नाम से आवा हैं,’ तब तक तुम मोखा फिर कभी नी देखोगो।” ");
INSERT INTO hlb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","फिर उ आराम को दिन फरीसी हुन का मुखिया म से कोई को घर म खाना खान ख गयो; अर वी ओखा मारन कि ताक म हता। ");
INSERT INTO hlb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","अऊर देख, यीसु को सामने जलोदर से बीमार एक मनुस्य आयो। ");
INSERT INTO hlb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","इ पर यीसु न व्यवस्थापक अर फरीसी हुन से कय्हो, “का आराम को दिन चोक्खो करनु उचित हैं या नी?” ");
INSERT INTO hlb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","पर वी चुपचाप रह गया। तब ओ न ओखा छु का चोक्खो करो अर जान दियो, ");
INSERT INTO hlb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","अर ओ न कहयो, “तुम से असो कोन हैं, जेको गधा या बईल कुआ म गिर जाऐ अर वी आराम को दिन का ओको तुरत बाहर नी निकाले?” ");
INSERT INTO hlb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","वी असी बात को कुछ जवाब देनू को उनको ओकात नी होतो। ");
INSERT INTO hlb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","जब यीसु देखियो कि नेवता दिया वाला अदमी कसो अच्छी-अच्छी जगह चुन लेवा हैं ते एक उदाहरन दे ख उनसे कय्हो, ");
INSERT INTO hlb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","तब कोई तो ख बिहाव म बुलाहे, ते अच्छी जगह म मत बैठनो, कई असो नी होय कि ओ न तोसे भी कोई बड़ो ख देवता दियो होय, ");
INSERT INTO hlb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","अर जोना तो ख अर ओखा वी दोई ख नेवता दियो होय आ ख तोसे कहे, ऐका जगह दे, अर तब तोखा लाज होकर को सबसे नीचु की जगह म बैठनो पड़े। ");
INSERT INTO hlb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","पर जब तो ख बुलायो जाय ते सब से नीचु जगह पर जा ख बठ कि जब उ, जेना तो ख नेवता दियो हैं आए, ते तो से कहे, अरे दोस्त, आगे जा ख बठ तब तोरो संग बठन वाला को जोने तोरी बड़ाई होयगो। ");
INSERT INTO hlb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","काहेकि जे कोई अपनो तुम ख बड़ो बनाएगो, ओको छोटो करो जाहेगो; अर जे कोई अपनो तुम छोटो बनाहे, ओको बड़ो करो जाहेगो। ");
INSERT INTO hlb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","तब ओ न अपना नेवता देन वाला से भी कय्हो, “जब तू दिन का या रात का खानो करे, ते अपनो दोस्त हुन या भई हुन या कुटुम्बीहुन या धनवान पड़ोसी हुन ख नी बुला, कही असो नी हो कि वी भी तो ख नेवता दे, अऊर तोरो बदला हो जाहे। ");
INSERT INTO hlb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","पर जब तू खानो करे ते भिखारी हन, डुण्डा हन, लगड़ा हुन अर अंधा हुन बुला। ");
INSERT INTO hlb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","तब तू धन्य होए, काहेकि उनको नजीक तो ख बदला देन ख कुछ नी, पर तो ख धर्मी हुन को जिन्दो उठनो पर ये की मेहनत को फल मिले।” ");
INSERT INTO hlb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ओके संग खाना करन वाला हुन म से एक न यू बात सुन ख ओसे कय्हो, “धन्य हैं वी जे परमेस्वर का राज्य म रोटी खाएगो।” ");
INSERT INTO hlb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ओ न ओसे कय्हो, “कोई इंसान न बड़ो भोज दियो अर बेजा हुन का बुलायो। ");
INSERT INTO hlb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","जब खानो तैयार हो गयो ते ओ न अपनो दास का हात नेवता लोग हुन का बुलन भेजो, ‘आव, अब खाना बन का तैयार हैं।’ ");
INSERT INTO hlb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","पर वी सब ख सब मापी माँगन लगिया। पहलो न ओसे कय्हो, ‘मी न खेत मोल लियो हैं, अर अवस्य हैं कि ओ ख देखू; मी तोसे विनती करत हूँ मो ख माप कर देनू।’ ");
INSERT INTO hlb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","दूसरो न कय्हो, ‘मी न पाँच जोड़ी बईल मोल लियो हैं, अर उनका परखन जात हूँ; मी तोसे विनती करत हूँ मोखा माप कर देनू।’ ");
INSERT INTO hlb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","एक अर न कय्हो, ‘मी न बिवाव कियो हैं, एकोलाने मी नी आ सकता।’ ");
INSERT INTO hlb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","उ दास न आय ख अपनो मालिक का यू बात कह सुनायो। तब घर को मालिक न गुस्सा म आय ख अपनो दास से कय्हो, ‘नगर को बाजार हुन अर गली हुन म तुरंत जाय ख भिखारी, टुण्ड़ो, लंगड़ो अर अंधो हुन का इत्ते ले आनू।’ ");
INSERT INTO hlb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","दास न फिर कय्हो, ‘हे मालिक जसो तू न कय्हो हतो वसो ही कियो गयो हैं; अर फिर भी जगह हैं।’ ");
INSERT INTO hlb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","मालिक न दास से कय्हो, ‘रस्ता हुन पर अर बागड हुन की ओर जा अर अदमी हुन विवस कर ख ले आनू ताकि मोरो घर भर जाए। ");
INSERT INTO hlb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","काहेकि मी तोसे कहूँ हूँ कि उनना नेवात लोग हुन म से कोई मोरो भोज का नी चखेगो’।” ");
INSERT INTO hlb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","जब बड़ो भीड़ यीसु संग जा रह हती, ते यीसु पिछु मुड़ ख ओसे कय्हो, ");
INSERT INTO hlb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“यदि कोई मोरो नजीक आय, अर अपनो बाप अर माय अर घरवाली अर पोरिया हुन अर भई हुन अर बहिन हुन वरन् अपनो प्रायन को भी चोक्खो नी जानो, ते वी मोरो चेला नी हो सकत; ");
INSERT INTO hlb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","अर जे कोई अपनो सूली नी उठायो, अर मोरो पिछु नी आयो, वी भी मेरो चेला नी हो सकत! ");
INSERT INTO hlb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","तू म से कोन हैं जे गुम्मट बनानो चाहव हैं, अर पहलो बहिठ ख खर्च नी जोड़ा कि पुरो करन की सामर्थ्य मोरो नजीक हैं कि नी? ");
INSERT INTO hlb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","कही असो नी होवा कि जब उ नीव ड़ाल लेहे पर पुरो नी कर सका, ते सब देखन वाला यू कह ख ओ ख ओकात नी अरूर ठठ्टो म उड़ान लगिया, ");
INSERT INTO hlb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","यू अदमी बनान ते लगिया पर पुरो करन को ओकात नी होतो? ");
INSERT INTO hlb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","या कोन असो राजा से लडाई करन जात हो, दूसरो राजा से लडाई करन को लाने जावा हैं अर पहलो बैठ ख सोच नी कर ले कि जे बीस हजार लेख मोरो पर चढ़ आत हैं, का मी दस हजार ले ख ओको सामे कर सकत हूँ या नी? ");
INSERT INTO hlb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","नी ते ओके दूर रह ही उ दूत हुन ख भेज ख मिलाप करनो चाहे। ");
INSERT INTO hlb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","इ रीति से तो म से जे कोई अपनो सब कुछ त्याग नी देवा, उ मोरो चेला नी हो सकत। ");
INSERT INTO hlb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“नमक ते चोक्खो हैं, पर अदि उ नमक को स्वाद बिगड़ जावा, ते उ कोई वस्तु से नमकीन कियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","उ नी ते जमीन को अर नी खाद को लाने काम म आत हैं: ओखा ते लोग हुन बाहर फेक देवा हैं। जेके सुनन को कान हो वी सुन लेहे।” ");
INSERT INTO hlb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","एक रोज तब कर लेन वालो अर पापी ओके पास आयो कर हते। ताकि ओकी सुने। ");
INSERT INTO hlb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","पर फरीसी अर सासतिरी कुड़कुड़ा ख कहन लगिया, “यू ते पापी हुन से मिलत हैं अर उनका संग खात भी हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ऐ पर यीसु न उन ख यू उदाहरन सुनायो: ");
INSERT INTO hlb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“तुम म से कोन हैं जेको सव भेड़ हो, अर ओमा से एक भटक जाए, ते तुम निन्यानवे का जंगल म छोड़कर, उ खोई का जब तक मिल नी जाए ओको खोजतो नी रहे? ");
INSERT INTO hlb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","अर जब मिल जात हैं, ते उ बड़ो खुसी से ओ ख कंधे पर उठकर लेख हैं; ");
INSERT INTO hlb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","अर घर म आकर दोस्तहुन अऊर पड़ोसी हुन का इकठ्टा कर ख कहत रह, ‘मोरो संग आनन्द करो, काहेकि मोरी खोई हुई भेड़ मिल गई हैं।’ ");
INSERT INTO hlb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","मी तोसे कहू हैं कि असो तरीका से एक मन फिरान वालो पापी को बारे म भी स्वर्ग म इत्तो ही खुसी होय, जितनो कि निन्यानवे असा धर्मी हुन को बारे म नी होवा, जिन्हे का मन फिरानू की आवस्यकता नी। ");
INSERT INTO hlb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“या कोन असो बाई होए, जेको पास दस सिक्के हो, अर ओमा म से एक खो जाहे, ते उ दिया हुन जला ख अऊर घर झाड़-बुहारकर, जब तक उ मिल नी जात जिन्दो लग ख खोजत नी रहे? ");
INSERT INTO hlb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","अर जब मिल जाहे ते उ अपनो सहली हुन अर पड़ोसिनी हुन का इकठ्टा कर ख कह हैं मोरो संग आनन्द करो? ‘काहेकि मोरो खोयो हुओ सिक्के मिल गयो हैं।’ ");
INSERT INTO hlb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","मी तोसे कहूँ हैं कि इ ही रीति से एक मन फिरावन वाला पापी का विसय म परमेस्वर का स्वर्गदूत का सामने खुसी होवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","फिर यीसु न कय्हो, कोई अदमी का दो पोरिया हते। ");
INSERT INTO hlb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ओमा से छोटो पोरिया न बाप से कय्हो, हे बाप, धन म से जे भाग मोरो हो उ मोखा दे। ओ न उन ख अपनी धन बाट दियो। ");
INSERT INTO hlb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","कुछ रोज बीते जानो को बाद छोटो पोरिया न सब कुछ इकठ्टा कर ख दूर देस को चलो गयो, अर वहाँ बुरो काम म अपन सारी धन-दऊलत का उड़ा दियो। ");
INSERT INTO hlb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","जब उ पूरो कुछ पैसा खत्म कर चुक्यो, ते उ सहर म बड़ो अकाल पड़ो अऊर उ बिखारी हो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","एकोलाने उ देस का रहवासी हुन म से एक को उते गयो। ओ न ओ ख अपनो खेतो म डुक्कर चरानो को लाने भेजो। ");
INSERT INTO hlb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","अर उ चाहत हतो कि उन फल्ली से जेख डुक्कर खात हते, अऊर अपनो पेट भरे; अऊर ओ ख कोई कुछ नी दे हतो। ");
INSERT INTO hlb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","जब उ अपनो मन म होस म आयो ते कहन लगियो, मोरो बाप ख कित्तो ही मजदूर हुन ख खाना से जादा रोटी मिल हैं, अऊर मी यहाँ भूखो मर रयो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","मी अब उठकर अपनो बाप के पास जाऊँगो अर ओसे कहूगो कि पिता जी, मी न स्वर्ग का विरोध म अर तोरी नजर म पाप कियो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","अब यू लायक नी रह, कि तोरो पोरिया कहलाऊँ, मो ख अपनो एक मजदूर ख समान रख ले। ");
INSERT INTO hlb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","तब उ उठकर, अपनो बाप का नजीक चलो गयो: उ अभी दुर ही हतो कि ओखा बाप न ओ ख देखकर तरस खायो, अर दऊड ख ओ ख गले लगायो, अर बेजा चुमियो। ");
INSERT INTO hlb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","पोरिया न ओसे कय्हो, पिता जी, मी न स्वर्ग का विरोध म अर तोरी नजर म पाप कियो हैं अर अब इ योग्य नी रह गयो कि मी तोरो पोरिया कहलाऊँ। ");
INSERT INTO hlb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","परन्तु पिता न अपनो दासो से कय्हो, जल्दी से चोक्खो से चोक्खो कपड़ा निकालकर ओ ख पहिना, अर ओको हात म अँगूठी, अऊर पाय म जूता पहिनायो, ");
INSERT INTO hlb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","अर पलो हुओ बच्छा लाकर मारियो ताकि हम ओ ख खाएँ खुसी मनाए। ");
INSERT INTO hlb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","काहेकि मोरो यु पोरिया मर गयो हतो, फिर से जिन्दो हो गयो हैं खो गयो हतो, अब मिल गयो हैं अऊर वी खुसी करन लगो। ");
INSERT INTO hlb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“परन्तु ओको बड़ो पोरिया खेत म हतो। जब उ आते हुए घर को नजीक पहुँचे, तो ओ न गान-बजानो अर नाचन वाले का आवाज सुनाई दियो। ");
INSERT INTO hlb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","अत: ओ न एक सेवक का बुला ख पुछियो, ‘यू का हो रहे हैं?’ ");
INSERT INTO hlb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ओ न ओसे कय्हो, ‘तोरो भई आयो हैं, अर तोरो पिता न पलो हुओ बच्छा को कटवायो हैं एकोलाने कि ओ ख भलो चंगो पायो हैं।’ ");
INSERT INTO hlb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","यु सुन कर उ गुस्सा से भर गयो अर भीतर जान नी चाहे, पर ओको बाप बाहर आय का ओ ख मनान लगियो। ");
INSERT INTO hlb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ओ न पिता को उत्तर दियो, ‘देख मी इतनो साल से तोरी सेवा कर रयो हूँ’ अऊर कभी भी तोरी आग्या नी टाली, तोभी तू न मोखा कभी ‘एक भी बकरी को बच्चा भी नी दियो कि मी अपनो दोस्त हुन का संग खुसी करूँ हैं।’ ");
INSERT INTO hlb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","पर जब तोरो यू पोरिया, ‘जेना तोरी धन-दऊलत रंडी बाजी म उडा दी हैं, अर आयो, ते ओके लाने तू न पलो हुओ बच्छा कटवायो।’ ");
INSERT INTO hlb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ओ न ओसे कय्हो, ‘पोरिया, तू सदा मोरो संग हैं; अर जे कुछ मोरो हैं उ सब तोरो ही हैं। ");
INSERT INTO hlb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","पर अब आनन्द करनो अर मगन होन चाहिए, काहेकि यू तोरो भई मर गयो हते, ते जिन्दो गयो हैं; खो गयो हतो, अब मिल गयो हैं’।” ");
INSERT INTO hlb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ते यीसु न अपनो चेला हुन से यू भी कय्हो, “कोई धनवान को एक भण्डारी अनाज इकट्ठो करन वालो हतो। लोग हुन न ओको मालिक ख सामने ओ पर यू दोस लगायो कि उ तोरी धन उड़ा रयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","अब ओ न ओ ख बुलाय ख कय्हो, यू का हैं जे मी तोरो बारे म सुन रहे हूँ? अपन भण्ड़ारी पन का लेख दे, काहेकि तू सामे का भण्डारी नी रह सकत। ");
INSERT INTO hlb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","तब भण्डारी मन म सोचन लगियो, अब मी का करूँ? काहेकि अब मोरो मालिक अब भण्डारी को काम मोसे छीन न ले हे। मिठ्टी ते मोसे खोदी नी जावह की; अर भीख माँगन म मोखा सरम आवा। ");
INSERT INTO hlb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","मी समझ गयो कि का करूँगो; ताकि जब मी भण्डारी को काम से छुड़ायो जाऊ ते लोग मोखा अपनो घरो म ल ला। ");
INSERT INTO hlb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","तब ओ न अपनो मालिक का कर्जदार हुन का एक-एक कर ख बुलायो अर पहलो से पुछियो, तोरा पर मोरा मालिक को कितनो करजा हैं। ");
INSERT INTO hlb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ओ न कय्हो, तीन हजार तेल, तब ओ न ओसे कय्हो, अपनो खाता-बही लेकर अर बैठ ख तुरंत 15 सऊ लिय्ख दे। ");
INSERT INTO hlb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","फिर ओ न दुसरो से पुछियो, तोरो पर कितनो करजा या कर्जदार हैं? ओ न कय्हो, सव मन गहूँ, तब ओ न ओसे कय्हो, अपनो खाता-बही लेकर अस्सी लिय्ख दे। ");
INSERT INTO hlb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“मालिक न उ अधर्मी भण्डारी को सराहो कि ओ न चतुराई से काम कियो हैं, काहेकि इ दुनिया को लोग अपनो बखत ख लोग हुन को संग रीति-व्यवहारो म ज्योति को लोगो से अधिक चतुर हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","अऊर मी तुम से कहू हैं कि अधर्म को धन से अपनो लाने दोस्त बना लेनू, ताकि जब उ जात रहे ते वी तुम्हे अनन्त निवास हुन म ले लेहे। ");
INSERT INTO hlb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","जे थोडे से थोड़ो म ईमानदारी आय, उ बेजा म भी ईमानदारी हैं: अर जे थोडे म भी अधर्मी हैं, वी बेजा म भी बेईमान आय। ");
INSERT INTO hlb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","एकोलाने जब तू अधर्मी को काम को धन म इमानदारी नी ठहरो ते सच्चो धन तुम्हे कोन सोउपेगो? ");
INSERT INTO hlb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","अर यदि तू पराये धन म ईमानदार नी ठहरे ते जो तुम्हारो हैं, ओ ख तुम्हे कोन देगो? ");
INSERT INTO hlb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“कोई भी दास दो मालिक हुन की सेवा नी कर सकह: काहेकि उ ते एक से बुराई अऊर दुसरो से प्रेम रखनो या एक से मिल्यो रहेगो अऊर दुसरो ख तुच्छ जानेगो। तुम परमेस्वर अऊर धन दोई की सेवा नी कर सकह।” ");
INSERT INTO hlb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","अऊर फरीसी जे धन दोलत लोभी हता, यू सब बात हुन सुन ख ओ ख ठट्ठो म उड़ान लगो। ");
INSERT INTO hlb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","यीसु न उनसे कय्हो, “तुम ते अदमी का सामे अपन तुम का धर्मी ठहरात हो, परन्तु परमेस्वर तुम्हारो मन का जानत हैं, काहेकि जे वस्तु अदमी की नजर म महान हैं, उ परमेस्वर को नजीक म बुरी चिज आय।” ");
INSERT INTO hlb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","मूसा को नेम अर भविस्यवक्ता यूहन्ना तक रया; उ बखत से परमेस्वर को राज्य को सुसमाचार सुनायो जा रय्हे हैं, अर हर कोई ओ म प्रबलता से प्रवेस करत हैं। ");
INSERT INTO hlb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","आकास अर जमीन का टल जानू नेम का एक बिन्दु का मिट जानू से सहज हैं। ");
INSERT INTO hlb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“जे कोई अपन ओरत का त्याग कर दुसरी से सादी करत हैं, उ गलत काम करह हैं, अर जे कोई असी त्यागी हुई ओरत से बिहाव करत हैं उ भी गलत काम करह हैं। ");
INSERT INTO hlb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“एक धनवान अदमी हते जे बैजनी रंग का कपड़ा अर मलमल पहिनो अर प्रतिदिन सुख विलाप अर धूम धाम का संग रहत हतो ");
INSERT INTO hlb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","लाजर नाम का एक कंगाल खत्ता हुन से भरियो हुओ ओकी दुवार हुन के सामे पर छोड़ दियो जात हता, ");
INSERT INTO hlb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","अर उ चाहत हतो कि धनवान की मेज पर की जुठन से अपनो पेट भरे; यहाँ तक कि कुत्ता भी आकर ओके खत्ता हुन को घावो को चाटत रह। ");
INSERT INTO hlb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","असो भयो कि उ कंगाल मर गयो, अर स्वर्गदूत हुन न ओ ख लेकर अब्राहम की गोद म पहुँचायो। उ धनवान भी मरो अर गाड़ो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","अर अधोलोक म ओ न पीड़ा म पड़ियो हुओ अपन आँखी खोली, अर दूर से अब्राहम की गोद म लाजर का देखो। ");
INSERT INTO hlb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","तब ओ न पुकार कर कय्हो, ‘हे पिता अब्राहम, मोरो पर दया कर ख लाजर का भेज दे, ताकि उ अपनी उँगली का सिरा का पानी म भिगोकर मोरी जीभ का ठंडो करे, काहेकि मी इ आगी म तड़प रय्हो हूँ।’ ");
INSERT INTO hlb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","पर अब्राहम न कय्हो, ‘हे पोरिया स्मरण कर कि तू अपनो जीवन म अच्छी वस्तु ले चुको हैं, अर वसो ही लाजर बुरी वस्तु: परन्तु अब उ यहाँ सान्ति पर रय्हो हैं, अर तू तड़प रय्हो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","इ सब बात का छोड़ हमारो अर तुम्हारो बीच म एक भारी गड़हा ठहरायो गयो हैं कि जे यहाँ से उ पार तुम्हारो नजीक जानो चाहूँ, वी नी जा सकेगो; अर नी कोई वहाँ से इ पार हमारो नजीक आ सकेगो।’ ");
INSERT INTO hlb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ओ ना कय्हो, ‘ते हे पिता मी तोसे विनती करत हूँ कि तू ओ ख मोरो पिता का घर म भेज, ");
INSERT INTO hlb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","काहेकि मोरो पाँच भई अर हैं; उ ओके सामे इ बात की गवाह दे, असो नी हो कि वी इ भी पीड़ा की जगह म आए।’ ");
INSERT INTO hlb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","अब्राहम न ओसे कय्हो, ‘ओके नजीक ते मूसा अर भविस्यवक्ता हुन की किताब हैं, वी ओकी सुने।’ ");
INSERT INTO hlb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ओ न कय्हो, ‘नी, हे पिता अब्राहम; पर यदि कोई मरे होऐ म से ओखा नजीक जाए, ते वी मन फिराएगो।’ ");
INSERT INTO hlb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ओ न ओसे कय्हो, ‘जब वी मूसा अर भविस्यवक्ता हुन की नी सुनह, ते यदि मरो हुओ म से कोई जी भी उठे तोभी ओकी नी मानेगो’।” ");
INSERT INTO hlb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","फिर यीसु न अपना चेला हुन से कय्हो, “हो नी सका कि ठोकर नी लगे, पर धितकार ओपर जेको वजे से उ धोका खावा हैं!” ");
INSERT INTO hlb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","जो यी छोटा म से कोई एक ख ठोकर खिलात, ओके लाने यू भलो होतो कि चक्की को पाट ओको गरा म बाँध ख लटकायो जातो, अर उ समुंदर म ड़ाल दियो जातो। ");
INSERT INTO hlb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","सतरक रहेजो; यदि तोरो भई पाप करे ते ओखा समझा, अर यदि पछताए ते ओखा माप कर। ");
INSERT INTO hlb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","अदि दिन भर म उ सात बार तोरो विरोध म पाप करते रहे अऊर साती बार तोरो जोने आ ख बोले, मी पछताऊ हैं ते ओखा माप कर। ");
INSERT INTO hlb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","तब प्रेरित हुन न प्रभु से कय्हो, “हमरो विस्वास ख बढ़ा।” ");
INSERT INTO hlb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","प्रभु न कई, “अदि तुम ख राई को दाना को बराबर भी विस्वास होतो, ते तुम यू सहतूत को झाड़ से कहता कि जड़ से उखड़ जा अर समुंदर म लग जा, ते उ तुम्हारी मान लेतो। ");
INSERT INTO hlb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“तुम म से असो कोन हैं, जेको दास हल जोतत या भेड़ चरात होय, अर जब उ खेत से आयो, ते ओसे कहे, ‘तुरत आ अर खाना खान ख बठ’? ");
INSERT INTO hlb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","अर असो नी कहन को, ‘मोरो लाने खाना परोस, अर जब लक मी खाऊँ-पीऊ तब तक कमर कस ख मोरी सेवा कर; एको बाद तू भी खा-पी लेजो’? ");
INSERT INTO hlb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","का स्वामी को उ नउकर को एकोलाने धन्यवाद देनू चाहिए कि ओ न ओको आदेस को पालन कियो हैं? ");
INSERT INTO hlb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","उसी तरीका से तुम भी जब वी सब काम हुन ख कर लेहे जो तुमका बतायो गया रहा, ते बोलो, ‘हम कामचोर नउकर आय हैं; जो हमका करनो चैयेथो हमना सिर्फ उइच काम जरूरी हैं।’” ");
INSERT INTO hlb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","एक बार असो भयो कि उ यरूसलेम ख जाते घड़ी सामरिया अर गलील को बीच म से होका जात रहा। ");
INSERT INTO hlb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","कोई गाँव को भीतर जाते घड़ी ओखा दस कोढ वाला मिल्या। ");
INSERT INTO hlb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","उनना दूर खड़ा हो ख जोर से हाँका लगायो, “यीसु, प्रभु, हमारो ऊपर दया कर!” ");
INSERT INTO hlb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ओ ना उनका देख ख बोल्यो, “जाव, “अर खुद ख याजक हुन ख दिखाव।” अऊर जाते-जाते ही वी सुध्द हो गया। ");
INSERT INTO hlb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","तब उनमा से एक यू देख ख कि मी अच्छो हो गयो हैं, खुसी को मारे परमेस्वर की बड़ाई करते लउटियो; ");
INSERT INTO hlb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","अर यीसु को पाय म अवधो मुंड़ो गिड ख ओको धन्यवाद करन लग गयो; अऊर उ सामरी हतो। ");
INSERT INTO hlb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ऐपर यीसु न कय्हो, “का दसी सुध्द नी भया, ते फिर वी नव किते हैं? ");
INSERT INTO hlb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","का यू परदेसी ख छोड़ कोई अऊर नी निकलियो जो परमेस्वर की बड़ाई करतो?” ");
INSERT INTO hlb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","तब ओ ना ओसे कय्हो, “उठ ख चल दा; तोरो विस्वास न तोखा चोक्खो करयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","जब फरीसी हुन न ओसे पूछो कि परमेस्वर को राज्य कब आहे, ते ओ ना उनका जुवाब दियो, “परमेस्वर को राज्य साकछात रूप म नी आवा कि इंसान हुन ओखा देखे। ");
INSERT INTO hlb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","अऊर लोगबाग हुन असा नी कहन ख, ‘देखो, यहाँ हैं, या वहाँ हैं।’ काहेकि देखो, परमेस्वर को राज्य तुमरो बीच म हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","फिर ओ ना चेला हुन से कय्हो, वी दिन आएँगो, जेमा तुम इंसान को पोरिया को दिन हुन म से एक दिन ख देखन को मन करेगों, अर नी देख सकन ख। ");
INSERT INTO hlb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","अऊर लोग तुम से कहेगो, देखो, वहाँ हैं! या देखो, यहाँ हैं! पर तुम चल मत देनो अऊर न उनको पीछु चल देनू। ");
INSERT INTO hlb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","काहेकि जसो बिजली आकास को एक छोर से तड़क ख आकास का दुसरो छोर तक चमका हैं, वसो ही इंसान को पोरिया को भी अपना दिन म आनो होयगो। ");
INSERT INTO hlb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","पर पहलो जरूर ही उ दुख भोगे, अऊर यु युग का लोग-बाँग ओखा बेकार समझेगो। ");
INSERT INTO hlb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","जसो नूह को बखत म भयो रा, वसो ही इंसान को पोरिया को दिन हुन म भी होयगो। ");
INSERT INTO hlb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","जे दिन तक नूह नाव पा नी चढ़ियो, उ दिन लक लोग बाँग खात-पित रा, अऊर उनमा सादी-बिहाव होत रा। तब पानी न बरस ख वी सब ख नास कर दियो। ");
INSERT INTO hlb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","अर जसो लूत को बखत म भयो रा कि लोग बाँग खात-पित, अर लेन-देन करत रा झाड़ लगात रा अर घर बनात रा; ");
INSERT INTO hlb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","पर जे दिन लूत सदोम से निकल्यो, उईच रोज आग अर गन्धक आकास से बरसीयो अर सब ख नास कर दियो। ");
INSERT INTO hlb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","इंसान को पोरिया को आन को दिन भी असो ही होए। ");
INSERT INTO hlb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“उ दिन जे छत पर होए अर ओको समान घर म होए, उ ओखा लेन ख घर प नी उतरे; अर वसो ही जे खेत म होए उ पिछे नी फिरनो चाहिए। ");
INSERT INTO hlb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लूत की घरवाली ख याद धरनो! ");
INSERT INTO hlb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","जे कोई अपनी जान बचान कि सोचे उ ओ ख गवाँयगो, अर जे कोई ओ ख गवाँहे उ ओ ख जिन्दो रखेगो। ");
INSERT INTO hlb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","मी तुम से कहूँ हैं, वा रात दो इंसान एक खाट पर होएगो; एक उठा लियो जाहे अर दूसरो छोड़ दियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","दो बाई हुन एक संग जाता म दरत होए, एक ख उठा लियो जाहे अर दूसरी ख छोड़ दी जाहे। ");
INSERT INTO hlb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","दो झन खेत म होए, एक उठा लियो जाहे अर दूसरो छोड़ दियो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","यू सुन ख उनना यीसु से पुछियो, “प्रभु! यू कहाँ होए? ओ ना उनसे कय्हो जहाँ लास होए वहाँ चील इकट्ठी होए।” ");
INSERT INTO hlb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","फिर ओ न ओको बारे म रोज प्रार्थना करनु अर हियाव नी छोडनू चाहिए, अर यी उदाहरन कय्हो: ");
INSERT INTO hlb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“कोई नगर म एक न्याय करन वालो रहत हतो। जे नी परमेस्वर से डरत हता नी कोई अदमी की परवाह करत हतो। ");
INSERT INTO hlb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","उ ई नगर म एक विधवा भी रहत हती, जे ओके पास आय-आय का बोलत हती, ‘मोरो न्याय चुकाकर मोखा मुद्दई से बचा।’ ");
INSERT INTO hlb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","कुछ बखत तक ते उ नी मानो पर अन्त म मन म विचार कर कय्हो, यदपि मी नी परमेस्वर मीन से डरनो, अर नी अदमी हुन की कुछ परवाह करतो हूँ; ");
INSERT INTO hlb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","तोभी यू विधता मोखा सतात रह हैं, एकोलाने मी ओखा न्याय चुकाऊँगो, कही असो नी हो कि घड़ी-घड़ी आकर अन्त मोरी नाक म दम कर देहे।” ");
INSERT INTO hlb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","प्रभु न कय्हो, “सुन, यू अधर्मी न्याय करन वालो का कहा हैं? ");
INSERT INTO hlb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","एकोलाने का परमेस्वर अपनो चुनो हुओ को न्याय नी चुकाएगो जे रात-दिन ओकी दुहाई देत रवा हैं। का उ ओके बारे म देर करेगों? ");
INSERT INTO hlb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","मी तोसे कहूँ हूँ उ तुरंत ओको न्याय चुकाएगो। तोभी इंसान को पोरिया जब आएँगो, ते का उ जमीन पर विस्वास पाएगो?” ");
INSERT INTO hlb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ओ न ओसे जे अपनो ऊपर भरोसा रखत हते, कि हम धर्मी हैं, अर दुसरो का तुच्छ जानत रह, यु उदाहरन कय्हो: ");
INSERT INTO hlb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“दो अदमी हुन मन्दिर म प्रार्थना करन को लाने गयो: एक फरीसी हतो अर दुसरो कर लेन वालो। ");
INSERT INTO hlb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","फरीसी अलग खडो होकर अपनो मन म यो प्रार्थना करन लगियो, ‘हे परमेस्वर, मी तोरो धन्यवाद करत हूँ कि मी दुसरो अदमी हुन को समान अंधेरो करन वालो, अधर्मी अर छिनाला नी, अर नी इ कर लेन वालो को जसो हूँ। ");
INSERT INTO hlb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","मी हफ्ता म दो बार उपवास रखत हूँ; मी अपनी सब कमाई का दसवां अंस भी देत हूँ।’ ");
INSERT INTO hlb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“परन्तु कर लेन वालो न दुर खड़ा होकर, स्वर्ग की ओर आँख उठानो भी नी चाहगो, वरन् अपनी छाती का पीट-पीट ख कय्हो, ‘हे परमेस्वर, मी पापी पर दया कर!’ ");
INSERT INTO hlb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","मी तोसे कहूँ हूँ कि उ दुसरो नी, परन्तु यू ही अदमी धर्मी ठहरायो जा ख अपनो घर गयो; काहेकि जे कोई अपनो तुम का बड़ो बनाएगो, उ छोटो कियो जाएगो; अर जे अपनो तुम ख छोटो बनाएगो, उ बड़ो कियो जाएगो।” ");
INSERT INTO hlb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","“फिर यीसु न कहयो अपनो को पोरिया हुन ख भी ओको नजीक लान लगियो कि वी उन पर हात रखे; पर चेला हुन न देखकर उन ख डाँटियो। ");
INSERT INTO hlb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","पर यीसु न बच्चा हुन का पास बुलायो ख अऊर कय्हो, ‘पोरा पारी हुन ख मोरो पास आन दो, अऊर उन ख मना नी कर: काहेकि परमेस्वर को राज्य उन जसा को लोग हुन को हैं।’ ");
INSERT INTO hlb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","मी तोसे सच कहूँ हूँ कि जे कोई परमेस्वर को राज्य छोटो पोरिया का समान ग्रहण नी करेगों उ ओमा कभी प्रवेस करनो नी पाएगो।” ");
INSERT INTO hlb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","कोई मुखिया न ओसे पुछियो, “हे अच्छो गुरू, अनन्त जीवन का अधिकारी होवन का लियो मी का करूँ?” ");
INSERT INTO hlb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","अऊर यीसु न ओसे कय्हो, “तू मोखा चोक्खो काहे बोला हैं? कोई अच्छो नी, केवल एक, अर्थात् परमेस्वर। ");
INSERT INTO hlb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","अऊर तू आदेस हुन ख ते जानत हैं: ‘गलत काम नी करनो, हत्या नी करनो, अऊर चोरी नी करनो, अऊर झूठी गवाही नी देनो, अपनो बाप अऊर माय को आदर करनो’।” ");
INSERT INTO hlb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ओ न कय्हो, “मी तो इ सब का मी जवान बखत ही से मानते आयो हूँ।” ");
INSERT INTO hlb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","अऊर यीसु न यू सुन ख ओसे कय्हो, “तुम म अब तक एक बात ख घटी हैं। अपनो सब कुछ बच ख गरीब हुन म बाट दे अऊर तुमारो नजीक स्वर्ग म धन होऐ। ते आ ख मोरो पिछु हो ला।” ");
INSERT INTO hlb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","उ यू सुन ख बेजा उदास भयो, काहेकि उ बड़ो धनी हतो। ");
INSERT INTO hlb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","यीसु न ओ ख देख ख कय्हो, “धनवान को परमेस्वर को राज म जानु कित्तो मूसकिल हैं। ");
INSERT INTO hlb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","परमेस्वर को राज म धनवान को जानु करनो से भलो हैं ऊँट को सुज्जी को छेद म से निकल जानो आसान हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ये पर सुनन वाला न कय्हो, “ते फिर कोन को उध्दार हो सका हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ओ न कय्हो, “जो इंसान हुन से नी हो सका उ परमेस्वर से हो सका हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ते पतरस न कय्हो, “देख, हम तो घर बार ख छोड़ ख तोरो पिछु हो लाने हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ओ न उन ख कय्हो, “मी तुम ख सच कहू हैं। कि असो कोई नी हाय जोना परमेस्वर को राज ख लाने घर या घरवाली या भई हुन या माय-बाप, या बाल-बच्चा ख छोड़ ख दिया हे।” ");
INSERT INTO hlb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","अर यु बखत कई गुना जादा नी जाहे अर आवन वालो दुनिया म हमेसा कि जिन्दगी। ");
INSERT INTO hlb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","फिर ओ ना बारा को संग म ले जाय ख उनसे कय्हो, “देखो, हम यरूसलेम ख जाय हैं, अर जीत्ति बात इंसान को पोरिया ख लाने भविस्यवक्ता हुन को व्दारा लिखो हैं, वी सबरी पुरी होयगो। ");
INSERT INTO hlb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","काहेकि उ गैर यहूदी को हात म सोपियो जाहेगो अऊर उ यीसु को मजाक कर गया हते, अऊर यीसु को अनादर कर लग गया, अऊर यीसु पर थुकेगे, ");
INSERT INTO hlb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","अर ओ ख कोड़ा मारेगो अर मार कर; अर उ तीन दिन को बाद जिन्दो होयगो।” ");
INSERT INTO hlb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","पर उन यू बात हुन म से कोई भी नी बात नी समझीया अर या बात उनको से छुपी रही, अर जे कय्हो गयो रह उ उनकी समझ म नी आयो। ");
INSERT INTO hlb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","जब यीसु यरीहो नगर को कने पहुँचियो, ते एक अंधा रस्ता को किनारो म बठियो हुयो, भीख माँगत रह हतो। ");
INSERT INTO hlb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","उ भीड़ को चलन की आवाज हुन ख पुछन लगियो, यहाँ का हो रय्हो हैं? ");
INSERT INTO hlb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","अऊर उनना ओ ख बतायो, “यीसु नासरी जा रय्हो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","तब ओ न आवाज लगा ख कय्हो, “हे यीसु, दाऊद की संतान मोरो पर दया कर!” ");
INSERT INTO hlb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","जे आगु-आगु जात रह हता, पर वी ओखा डाँटन लग गयो कि चुप रह, पर उ अर भी चिल्लान लग गयो, “हे दाऊद की संतान मोरो पर दया कर!” ");
INSERT INTO hlb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","तब यीसु न खड़ो होय ख कय्हो कि ओखा मोरो नजीक लाव अर जब उ ओको कने आयो ते यीसु ओसे पुछियो, ");
INSERT INTO hlb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","तू का चाह हैं कि मी तोरो लाने करूँ? ओ न कय्हो, “हे प्रभु असो कि मी देखन चाहूँ।” ");
INSERT INTO hlb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","यीसु न ओसे कय्हो, “देखन लग, तोरो भरोसा न तोखा चोक्खो कर दियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","तब उ तुरंत देखन लग गयो अर परमेस्वर की बड़ाई करत हुयो ओको पाहु चल दियो अर सब लोग न देख ख परमेस्वर की स्तुति करी। ");
INSERT INTO hlb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","उ यरीहो म प्रवेस कर ख जा रहे हतो। ");
INSERT INTO hlb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","अर देख, वही जक्कई नाम को एक अदमी हतो जे चुंगी लेन वालो को सरदार हतो अर धनी हतो। ");
INSERT INTO hlb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","उ यीसु का देखन चाह रहे हतो कि उ कोन सो आय। परन्तु भीड़ का वजे देख नी सकियो, काहेकि उ ठिग्नो हतो रह। ");
INSERT INTO hlb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","तब ओको देखनो ख लियो उ सामे म दऊडकर एक गूलर को झाड़ म चढ़ गयो, काहेकि यीसु हुई रस्ता से आनो वालो हतो। ");
INSERT INTO hlb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","जब यीसु उ जगह पहुँचियो ते ऊपर नजर कर ख ओ से कय्हो, “हे जक्कई, जल्दी उतर का आ; काहेकि आज मो ख तोरो घर म रहनू आवस्यक हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","उ तुरत नीचू उतरकर खुसी से ओखा अपनो घर म ले गयो। ");
INSERT INTO hlb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","यू देख ख सब लोग हुन कुड़कुड़ा ख कहन लगियो, “उ ते एक पापी का यहाँ जा रय्हो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","जक्कई न खड़ा होकर प्रभु से कय्हो, “हे प्रभु, देख, मी अपनो आधी धन-दऊलत बिखारी का देत हूँ अर यदि कोई को कुछ भी अन्याय कर ख ले लियो हैं ते ओ ख चार गुना पास करूँ हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","अऊर यीसु न ओसे कय्हो, “आज इ घर म उध्दार आयो हैं, एकोलाने कि यू भी अब्राहम का एक पोरिया हैं। ");
INSERT INTO hlb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","काहेकि इंसान को पोरिया खोयो हुयो का ढूँढ़न अऊर उन ख उध्दार करन आयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","जब वी यू बात सुन रहे हते, ते ओ न एक उदाहरन कय्हो, एकोलाने कि उ यरूसलेम का नजीक हतो, अर वी समझत हते कि परमेस्वर को राज्य अभी प्रगट होन वालो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","अत: ओ न कय्हो, “एक धनी अदमी दूर देस का चलो गयो” ताकि राजपद पाय ख लउट आयो। ");
INSERT INTO hlb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ओ न अपनो दास हुन म से दस ख बुला ख उन्हे दस चाँदी तोढ़ा दी अर ओसे कय्हो, मोरो लउट आन तक लेन देना करनु। ");
INSERT INTO hlb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","परन्तु ओके सहर को रहन वाला ओसे बैर रखत हता, अर ओखा पिछे दूत हुन ख व्दारा कहला भेज्यो, हम नी चाहवा कि यू हम पर राज करे। ");
INSERT INTO hlb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","जब उ राजपद पा ख लउटो आयो, ते असो भयो कि ओ ना अपनो दास हुन का जेख पैसा दिया रह, अपनो पास बुलायो ताकि पता करे। उनना लेन-देन म का कमायो। ");
INSERT INTO hlb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","तब पहलो न आय ख कय्हो, हे मालिक, तोरी तोढ़ा हुन से दस अर तोढ़ा हुन कमायो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ओ न ओसे कय्हो, धन्य, हे अच्छो दास! तू बेजा ही थोड़ो म विस्वास लायक निकलो अब एकोलाने दस सहर पर अधिकार रखेगो। ");
INSERT INTO hlb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","दूसरो न आय ख कय्हो, हे मालिक, तोरी तोढ़ा म से मी भी पाँच कमायो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ओ न ओसे भी कय्हो, तू भी पाँच सहर हुन पर हाकिम होय जा। ");
INSERT INTO hlb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","तीसरो न आय ख कय्हो, हे मालिक, देख तोरो तोढ़ा यू हैं मी न अंगोछा म बाँध रखो आय। ");
INSERT INTO hlb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","काहेकि मी तोसे डरत रह हतो एकोलाने कि तू कठोर अदमी हैं जे तू न नी रखो ओ ख उठा लेता हैं, अर जे तू न नी बीयो ओखा काटा हैं। ");
INSERT INTO hlb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ओ ना ओसे कय्हो, अरे पापी नउकर, मी तोरो ही मुंडो से तोखा दोसी ठहराऊ हैं। तू मोखा जानत हतो कि मी कठोर अदमी हैं, जे मीना नी रखो ओखा उठा लेऊ हैं, अर जे मीना नी बोयो ओखा काटू हैं; ");
INSERT INTO hlb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ते तूना मोरो पैसा सहूकार ख नजीक काहे नी दे दियो, कि मी आँख ब्याज समेत ले लेतो? ");
INSERT INTO hlb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","अर जे इंसान नजीक म खड़ा हता, ओ ना उनसे कय्हो, उ तोढ़ा ओ से ले ले, अर जेका नजीक दस तोढ़ा हुन हैं ओखा दे देव। ");
INSERT INTO hlb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","उन न ओसे कय्हो, हे मालिक, ओको पास दस तोढ़ा ते हैं। ");
INSERT INTO hlb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","मी तोसे कहूँ हूँ कि जेके नजीक हैं, ओ ख दियो जाएगो; अर जेके नजीक नी हैं, ओसे उ भी जे ओके नजीक हैं ले लियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","पर मोरो उन बैरीहुन का जे नी चाहत हते कि मी उन पर राज्य करूँ, ओको यहाँ लाकर मोरो सामे लाय ख मार ड़ालो। ");
INSERT INTO hlb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","अऊर यू कह ख यीसु आगु चलो अऊर यरूसलेम कि ओर चलनो सुरू कियो। ");
INSERT INTO hlb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","जब उ जैतून नाम को टेकड़ा पर बैतफगे अर बैतनिय्याह को नजीक पहुँचियो, ते ओ न अपनो चेला हुन म से दो यू कह ख भेजो, ");
INSERT INTO hlb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“सामे का गाँव म जाओ; अर ओमा पहुँच ख ही एक गधा का बच्छा घुट बंधो भयो मिले, जे पर कभी कोई सवार नी भयो, तुमख मिलगो, ओ ख खोल ख ले आनू। ");
INSERT INTO hlb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","अदि कोई तोसे पूछेगो, कि काहे खोला हैं ते कह देनू कि प्रभु यीसु ख ऐको काम हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","जे भेजो गयो हते, उन्होना जाय ख जसो ओ न ओसे कहयो हतो वसो ही पायो। ");
INSERT INTO hlb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","जब वी गदहे को बच्छा का खोल रहे हता ते ओके मालिक हुन न ओसे पुछियो, “इ गदहे का पोरिया का काहे खोलत हो?” ");
INSERT INTO hlb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","उन्होना कय्हो, “प्रभु का इका जरूरत आय।” ");
INSERT INTO hlb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","वी ओको यीसु को नजीक म ले आयो, अर अपनो कपड़ा हुन उ बच्छा पर ड़ाल ख यीसु को उ पर बैठल दियो। ");
INSERT INTO hlb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","तब यीसु जाय रहे हते, ते वी अपनो कपड़ा हुन रस्ता म बिछात जात रहे हते। ");
INSERT INTO hlb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","अऊर जब नजीक म आत हुयो जब वी जैतून टेकड़ा की ढलान पर पहुँचियो, ते चेला हुन की सारी मण्डाली उन सब सामर्थ्य को काम हुन को कारन जे उन्होना देखिए हते, खुसी म होय ख बड़ो सब्द से परमेस्वर की स्तुति करन लगियो: ");
INSERT INTO hlb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“धन्य हैं उ राजा, जे प्रभु को नाम से आव हैं। स्वर्ग म सान्ति अर आकास म महिमा होए!” ");
INSERT INTO hlb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","तब भीड़ म से कुछ फरीसी ओसे कहन लगियो, हे गुरू अपनो चेला हुन ख डाँट कर रहजे। ");
INSERT INTO hlb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","अऊर यीसु न उत्तर दियो, “मी तुम से कहूँ हैं, यदि यू चुप रहे, ते पत्थर चिल्ला ख उठे।” ");
INSERT INTO hlb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","जब यीसु नजीक आयो ते सहर को देख ख ओ पर रोयो। ");
INSERT INTO hlb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","अर कय्हो, का ही भलो होत कि तू ही इ दिन म सान्ति कि बात जानत, परन्तु अब वी तोरी आँख हुन से लुक गई हैं। ");
INSERT INTO hlb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","काहेकि वी दिन तो पर आएँगो कि तो से दुसमन मोर्चा बाँध ख तो ख घेर; लेहे अऊर चारी तरफ से तो ख दबा हे ");
INSERT INTO hlb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","अर तोखा अर तोरो बालक हुन का जे तो म हैं मिठ्टी म मिलेगो, अर तो म पत्थर पर पत्थर भी न छोड़गो; काहेकि तू न उ बखत का जब तोखा पर कृपा नजर की गई हती तू नी पहिचानो। ");
INSERT INTO hlb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","तब यीसु मन्दिर म जा ख बेचन वाला ख निकालन लगियो, ");
INSERT INTO hlb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","अर ओसे कय्हो, “लिखो हैं, मोरो घर विनती को घर होगो, परन्तु तुम न ओ ख डाकू का खोह बनयो दियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","उ हर रोज मन्दिर म सिक्छा करत हतो; अर मुखिया याजक अर सासतिरी अर लोग हुन को प्रमुख ओ ख नास करन का बखत ढूँढ़त रह। ");
INSERT INTO hlb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","परन्तु कोई उपाय नी निकाल सकियो कि यू कि इ कोई भी प्रकार करे, काहेकि सब लोग बड़ी चाह से ओकी सुनत रह। ");
INSERT INTO hlb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","एक दिन यीसु मन्दिर म लोगो जा ख सिखा दे रयो हतो अऊर सुसमाचार सुनो रयो हतो कि प्रधान याजक का संग सासतिरी, सियाना हुन को संग म नजीक खड़ो भयो; ");
INSERT INTO hlb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","अर कहन लगियो, “हमका बता, तू इ काम हुन का कोके अधिकार से करत हैं, अर उ कोन हैं जेने तो ख यू अधिकार दियो हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","अऊर यीसु उन ख उत्तर दियो, “मी भी तोसे एक बात पूछत हूँ; मोखा बताओ ");
INSERT INTO hlb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","यूहन्ना का बपतिस्मा स्वर्ग की ओर से हतो या अदमी हुन की तरफ हतो?” ");
INSERT INTO hlb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","तब वी आपस म कहन लगियो, “यदि हम कहे, स्वर्ग को तरफ, ते वी कहेगो ‘फिर तू न ओकी विस्वास काहे नी की?’ ");
INSERT INTO hlb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","अर यदि हम कही, ‘अदमी हुन की तरफ से,’ ते सब लोग हम पर पत्थर हुन से मार डाले, काहेकि लोग हुन ख सच पता हो चुक्यो हैं, कि यूहन्ना भविस्यवक्ता हतो।” ");
INSERT INTO hlb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","अत: उन्होना यीसु ख उत्तर दियो, “हम नी जानत कि उ कोको की तरफ से हतो।” ");
INSERT INTO hlb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ऐ पर यीसु न उनसे कय्हो, “ते मी भी तुम ख नी बतात कि मी यू काम कोको अधिकार से करत हूँ।” ");
INSERT INTO hlb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","अऊर यीसु लोग हुन से यू उदाहरन कहन लग गयो: “किसी अदमी न दाख को खेत लग गयो, अर किरसान हुन का ओको ठेका दे दियो अर बेजा दिन का लियो परदेस चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","जब बखत आयो ते ओ न किरसान हुन को जोने एक दास का भेजो कि वी दाख का खेत को कुछ फल हुन भाग ख ओ ख पीट ख खाली हात लउटा दियो। ");
INSERT INTO hlb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","फिर ओ न एक अर दास का भेजो, अर उन्होना ओ ख भी पीट ख अर ओको अपमान कर ख खाली हात लउट दियो। ");
INSERT INTO hlb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","फिर ओ न तीसरो का भेजो, अर उन ना ओ ख भी घायल कर ख निकाल दियो। ");
INSERT INTO hlb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","तब दास की खेत को मालिक न कय्हो, ‘मी का करूँ? मी अपनो अच्छो पोरिया का भेजूगो, सम्भव हैं वी ओखा आदर करे।’ ");
INSERT INTO hlb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","जब किरसान हुन न ओ ख देखी ते आपस म विचार करन लग गया, ‘यू ते वारिस हैं; आओ, हम इख मार डाल ख धन संपत्ति हमरो हो जाएगो।’ ");
INSERT INTO hlb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","अर उन्होना ओ ख दाख की खेत से बाहर निकाल ख मार डालियो।” एकोलाने दाख की खेत का मालिक ओके संग का करेगों? ");
INSERT INTO hlb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","उ आ ख उन किरसान हुन का नास करेगों, अर दाख की खेत दुसरो का सोपेगो। यू सुन ख उन्होना कय्हो, “परमेस्वर करे असो नी हो पाए।” ");
INSERT INTO hlb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","यीसु न ओकी ओर देख ख कय्हो, फिर यू का लिखो हैं, जे पत्थर को घर बनान वालो मिसतिरी हुन न निकम्मो ठहरायो हतो उन्ही कोने को सिरा हो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","हर कोई उ पत्थर पर गिरेगो उ चकनाचूर हो जाएगो, अर जे पर उ गिरेगो, “ओको पीस डालेगो।” ");
INSERT INTO hlb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","उही बखत सासतिरी अर प्रधान पुजारी न ओ ख पकड़नू चाहयो, काहेकि वी समझ गयो हते कि ओ न हम पर यू उदाहरन कय्हो, परन्तु वी लोग हुन से डरा हैं। ");
INSERT INTO hlb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","अर वी उ की ताक म लगो अर भेदियो भेजो कि धर्म का भेस म धरकर ओकी कोई नी पकडे, ताकि ओ ख हाकिम अर अधिकार को हात म सोप देहे। ");
INSERT INTO hlb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","उन्होना ओसे यू पूछो, “हे गुरू, हम जानत हैं कि तू ठीक कहत अर सिखात भी हैं, अर किसी का पक्छपात नी करत, वरन् परमेस्वर का रस्ता सच्चाई से बताव हैं। ");
INSERT INTO hlb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","का हमक कैसर का कर देनू ठीक हैं या नी?” ");
INSERT INTO hlb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","अऊर यीसु उनकी होसियारी का समझ ख ओ से कय्हो, ");
INSERT INTO hlb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“मोखा एक चाँदी को सिक्का दिखाव। ऐपर कोकी छाप अर नाम हैं?” उनना कय्हो, “कैसर का।” ");
INSERT INTO hlb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ओ न ओसे कय्हो, “ते जे कैसर का हैं, वी कैसर का दो; अर जे परमेस्वर का हैं, उ परमेस्वर का दो।” ");
INSERT INTO hlb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","वी अदमी हुन को इत्ते ओकात नी हते कि ओके बात को जवाब दे सका। तब ओके उत्तर से अचम्भा होकर चुप रह गयो। ");
INSERT INTO hlb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","फिर सदूकी जे कहत हैं कि मरो हुओ को जिन्दो होनू हैं ही नी, ओमा से कुछ न ओके पास आ ख पूछो, ");
INSERT INTO hlb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“हे गुरू, मूसा न हमारो लियो यु लिखो हैं: यदि कोई को भई कि अपन घरवाली को रहत हुए बिना पोरिया मर जाए, ते ओखा भई ओसे घरवाली से बिवाव कर ले, अर अपनो भई का लियो खानदान उत्पन्न करे। ");
INSERT INTO hlb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","सात भई हता, पहलो भई बिवाव कर ख बिना पोरिया पैदा मर गयो। ");
INSERT INTO hlb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","फिर दूसरो भी, ");
INSERT INTO hlb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","अर तीसरो न भी उ ओरत से बिवाव कर लियो। इत्ती रीति से सातो बिन पैदा संतान ख मर गयो। ");
INSERT INTO hlb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","आखरी म उ ओरत भी मर गई। ");
INSERT INTO hlb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","एकोलाने जिन्दो उठनो पर उ ओमा से कोकी घरवाली होए, काहेकि उ सातो कि घर वाली होए गई हती।” ");
INSERT INTO hlb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","यीसु न ओसे कय्हो, “इ दुनिया का पोरिया हुन म ते बिवाव होत हैं, ");
INSERT INTO hlb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","पर जे लोग इ योग्य ठहरोगो कि उ दुनिया का अर भयो, म से जी उठनो का प्राप्त कर, वी नी बिवाव करेगों अर नी बिवाव म दियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","वी फिर मरन को भी नी; काहेकि वी स्वर्गदूत हुन को समानो होएगो, अर जिन्दो होनू को पोरिया होन से परमेस्वर को भी पोरिया होएगो। ");
INSERT INTO hlb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","परन्तु इ बात का कि मरो हुवो भी जिन्दो होवा हैं, मूसा न भी झाड़ी हुन की कायनी म प्रगट की हैं की उ प्रभु का ‘अब्राहम को परमेस्वर, अर इसहाक को परमेस्वर अर याकूब को परमेस्वर’ कहव हैं। ");
INSERT INTO hlb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","परमेस्वर ते मुरदो को नी परन्तु जिन्दो को प्रभु हैं: काहेकि ओको नजीक म सब जिन्दो आय।” ");
INSERT INTO hlb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","तब यू सुन ख सासतिरी हुन म से कुछ न यू कय्हो, “हे गुरू तू न चोक्खो कय्हो।” ");
INSERT INTO hlb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","अर उनन फिर ओसे कुछ अर पूछन को हिम्मत नी भयो। ");
INSERT INTO hlb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","फिर यीसु न ओसे पुछियो, मसी का दाऊद का पोरिया कसो कहत हैं? ");
INSERT INTO hlb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","दाऊद तुम ही भजन संहिता का किताब म कहत हैं: प्रभु न मोरो प्रभु से कय्हो, मोरो दाहिनी बैठ, ");
INSERT INTO hlb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","अऊर जब तक कि मी तोरो बैरी हुन का तोरो पाय हुन ख निचू नी कर देहु। ");
INSERT INTO hlb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“दाऊद ते ओ ख प्रभु कहत हैं, ते फिर उ ओको पोरिया कसो रयो?” ");
INSERT INTO hlb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","जब सब अदमी हुन सुन रहे हते, ते ओ न अपनो चेला हुन से कय्हो, ");
INSERT INTO hlb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“सासतिरी हुन से चलाक रहनू, जेको लम्बो-लम्बो कपड़ा पहिनो हुए फिरन चोक्खो लगत हैं, अर जिन ख बाजार म नमस्ते, अर प्रार्थना घर म अच्छो जगह ओर खानो म चोक्खो जगह प्रिय लगत हैं। ");
INSERT INTO hlb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","वी विधवा हुन को घर खा जात हैं, अर दिखान को लाने बड़ो देर तक विनती करत रहत हैं: यू बेजा ही बड़ो दण्ड पाएँगो।” ");
INSERT INTO hlb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","फिर यीसु न आँखी उठा ख अमीर का अपनो-अपनो दान भण्डार म डालत देखियो। ");
INSERT INTO hlb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","यीसु न एक गरीब विधवा का भी ओमा दो दमड़ी हुन डालत देखियो। ");
INSERT INTO hlb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","तब यीसु कय्हो, मी तुम से सच कहूँ हूँ कि इ बिखारी विधवा न सब से बढ़ ख डालो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","काहेकि सब न अपनो-अपनो धन की बढ़ती म से दान म कुछ डालो हैं, “पर इ न अपनो कमी म से अपनी सबरी कमई म से ड़ाल्यो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","जब कुछ अदमी मन्दिर को बारे म कहत रहे हते कि उ कसो सुन्दर पत्थर हुन अर भेग को समान हुन से संवारो गयो हैं, ते ओ न कय्हो, ");
INSERT INTO hlb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","वी दिन आएँगो, “जेम यू सब जे तुम देखत हो, ओमा से यू कोई पत्थर पर पत्थर भी नी छुटेगो जे पूरो गिरायो जाएगो।” ");
INSERT INTO hlb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","उन्होना यीसु पुछियो, हे गुरू, यू सब कब होएगो? अर यू बात हुन जब पुरो होन पर होए, ते उ आखरी रोज को का चिखान होगो? ");
INSERT INTO hlb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ओ न कय्हो, “सतरक रहनू कि भरमाए नी जाए, काहेकि बेजा से मोरो नाम से आ ख कहेगो, ‘मी उही आय, अर यू भी कि, बखत (बखत) पास म आ पहुचो हैं।’ तुम ओके पिछु नी चलो जानो। ");
INSERT INTO hlb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","जब तुम लड़ाई हुन अर बलवा करन वाला हुन की चर्चा सुने ते घबरा नी जानो, काहेकि इको पहलो होन आवस्य हैं परन्तु उ बखत तुरंत अन्त नी होएगो।” ");
INSERT INTO hlb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","तब यीसु न ओसे कय्हो, जात पर जात अर राज्य पर राज्य को खिलाफ उठ खडो होएगो, ");
INSERT INTO hlb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","अर बड़ो-बड़ो भूकम्प होएगो, अर जगह अकाल अर बड़ो ज्वड़ पड़ेगो अर आकास से भय कर बात बड़ो-बड़ो चिखान प्रगट होएगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","परन्तु इ सब बात हुन से पहलो वी मोरो नाम का कारन तुमका पकड़ेगो, अर सताएँगो, अर पंचायत हुन म सोपेगो, अर जेल म डलवाएगो, अर राजा हुन अर हाकिम हुन को सामे ले जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","पर यू तुम्हारो लाने गवाई देन को मोखा हो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","अपनो मन म निस्चय ख ला कि ते पहले से अपन सफाई की तैयारी नी करोगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","काहेकि मी तुमका बोल अर असो बुध्दि दूँगो कि तुम्हारो सब दुसमन सामनो या खण्डन नी कर सकेगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","तुम्हारो माय-बाप अर भई, अर कुटुम, अर दोस्त भी तुमका पकड़एगो; यू तक कि तू म से कुछ का मर वा भी डालेगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","मोरो नाम को कारन सब लोग हुन तोसे दुसमनी (बैर) करेगों। ");
INSERT INTO hlb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","परन्तु तुम्हारो सिर का एक बाल भी बाँका नी होएगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","अपनो धीरज से तुम अपनो जान या मन का बचाए रखोगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","जब तुम यरूसलेम ख सेना हुन से घेरीयो देखे, ते समझ जानु कि ओको उजड़ जान को बखत नजीक आ गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","तब जे कि यहूदिया म हो वी टेकरा हुन पर भाग जाए, अर जे यरूसलेम को अन्दर होए वी बाहर निकल जाएगो; अर जे गाँव हुन म होए प्रदेस उ म नी जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","काहेकि उ बदला लैन को असो होएगो, जे म लिखो हुयो सब बात पुरी होए जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","उ दिन हुन म जे पेट से होए अर दूध पिलात होएगो, उनको लाने धितकार! काहेकि दुनिया म विपत्ति अर इ लोग हुन पर बड़ो प्रकोप होएगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","वी तलवार कोर हो जाएगो, अर सब देस हुन को लोग हुन म जेल म होयख पहुँचाएगो जाएगो; अर जब तक अन्य जात हुन का बखत पूरो नी होए, तब तक यरूसलेम दुसरी जात हुन से रोदियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“सूरज अर चाँद, अर तारो म चिखान दिखायो देगो; अर जमीन पर देस-देस को लोग का संकट होगो, काहेकि वी समुंदर को गरजनो अर लहर हुन को कोला हल से घबरा जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","डर को कारन अर दुनिया पर आन वाली घटना हुन की रस्ता देखत-देखत लोग हुन को जी म जी नी रहेगो, काहेकि आकास की सक्ति हुन हिलायी जाहे। ");
INSERT INTO hlb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","तब वी इंसान को पोरिया का सामर्थ्य अर बड़ो महिमा को संग बदल पर आते देखे। ");
INSERT INTO hlb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","जब यू बात होन लगेगो, ते सीधो होय ख अपनो सिर ऊपर उठाएगो; काहे कि तुम्हरो छुटकारा जोने होएगो।” ");
INSERT INTO hlb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ओ न ओसे एक उदाहरन भी कय्हो, “अंजीर को झाड़,” अर सब झाड़ हुन का देखो। ");
INSERT INTO hlb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","जसो ही ओमा नया डिक्कर निकला हैं। ते तुम देख ख अपनो तुम ही समझ लेवा हैं कि बरसात को बखत नजीक हैं। ");
INSERT INTO hlb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","असो तरीका से जसा तुम या बात हुन होत देखियो, तब समझ जानू कि परमेस्वर को राज नजीक हैं। ");
INSERT INTO hlb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","मी तुम ख सच बोलू हैं कि जब तक ई सब बात नी हो जान की, तब तक या पीढ़ी को कसो भी नास नी होन को। ");
INSERT INTO hlb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","आकास अर धरती मिट जाहेगो, पर मोरी बात हुन कभी नी खाली जान की ");
INSERT INTO hlb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“एकोलाने होसियार (सावधान) रहनू, असो नी होय कि तुम्हारो मन खुस होय (खुमार) अर मतवालो पन, अर यू सरीर की चिन्ता हुन से लस्त हो जाहे, अर उ दिन तुम प फन्दा को जसो अचानक आ जाहे। ");
INSERT INTO hlb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","काहेकि उ सारो जमीन को सब रहन वालो हुन पर इही प्रकार आ पड़ेगो। ");
INSERT INTO hlb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","एकोलाने जागतू रहनू अर हर बखत विनती करत रहनू कि तुम इ सब आन वाली घटना हुन से बचनो अर इंसान को पोरिया का सामे खड़ो होवन को योग्य बनो।” ");
INSERT INTO hlb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","उ दिन का मन्दिर म सिक्छा (उपदेस) करत हतो; अर रात (साम) का बाहर जाय ख जैतून नाम टेकड़ा पर रह करत हतो; ");
INSERT INTO hlb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","अर भुनसारे सब झन ओकी सुनन ख लाने मन्दिर म ओको कने जायो करत रह। ");
INSERT INTO hlb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","अखमीरी रोटी को तिहार जे फसह कहलावा हैं नजीक हतो, ");
INSERT INTO hlb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","अर मुखिया याजक अर सासतिरी या बात की ताक म हता कि ओ ख कसो मार ड़ाले, पर वी इंसान हुन से डरत रह। ");
INSERT INTO hlb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","तब सैतान यहूदा म समायो, जे इस्करियोती कहलाता अर बारा चेला हुन म गिनो जात हतो। ");
INSERT INTO hlb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ओ न जाय ख मुखिया याजक हुन अर पहरू हुन को सरदार हुन को संग बात चीत की कि ओको कि प्रकार ओके हात म पकड़वागो। ");
INSERT INTO hlb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","वी आनन्दित भयो, अर ओ ख रूपये हुन देन का वादा दियो। ");
INSERT INTO hlb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ओ न मान लियो, अर अवसर (बखत) ढूँढ़न लगियो कि जब भीड़ हुन नी हो ते ओके हात पकड़वा देवा। ");
INSERT INTO hlb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","तब अखमारी रोटी को तिहार को दिन आयो, जे म फसह को बलिदान चडानो (मेम्ना) आवस्यक हतो। ");
INSERT INTO hlb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","यीसु न पतरस अर यूहन्ना का यू कह ख भेजो: “जाय ख हमारो खानो को लाने फसह तैयार कर?” ");
INSERT INTO hlb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","उन्न ओसे पुछियो, “तू किते चाहत हैं कि हम इ ख तैयार करे?” ");
INSERT INTO hlb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ओ न ओसे कय्हो, देख, नगर म प्रवेस करत ही एक अदमी पानी को मटका उठयो हुयो तुमका मिलेगो; जे घर म जाए तू ओके पिछु चलो जानू, ");
INSERT INTO hlb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","अर उ घर को स्वामी कहनू; हे गुरू तोसे कहत हूँ कि उ पाहुनसाला किते हैं जेम मी अपनो चेला हुन को संग फसह खाऊँगो? ");
INSERT INTO hlb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","उ तुम ख एक सजी-सजायो बड़ो अटारी दिखो देगो; उही तैयार करनु। ");
INSERT INTO hlb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","उन्होना जाय ख जसो ओमा ओसे हतो, वसो ही पायो अर फसह तैयार कियो। ");
INSERT INTO hlb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","जब बखत आ पहुँचियो, ते वी प्रेरित हुन संग म खाना खान बठिया। ");
INSERT INTO hlb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","अर ओ न ओसे कय्हो, “मोखा बड़ो लालसा हती कि दुख भोगन से पहलो यू फसह तुम्हारो संग खाऊँ। ");
INSERT INTO hlb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","काहेकि मी तोसे कहूँ हूँ कि जब तक उ परमेस्वर को राज्य म पूरो नी होए तब तक मी ओ ख कभी नी खाऊँगो।” ");
INSERT INTO hlb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","तब ओ न कटोरा ले ख धन्यवाद कियो अर कय्हो, “इ का ले अर आपस म बाँट ला ");
INSERT INTO hlb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","काहेकि मी तोसे कहूँ हूँ कि जब तक परमेस्वर को राज्य नी आएँगो तब तक मी अंगूर को रस अब से कभी नी पीऊगो।” ");
INSERT INTO hlb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","फिर ओ न रोटी लियो, अर धन्यवाद कर ख तोड़, अर ओको यू कहते हुयो दी, यू मोरी सरीर हैं: मोरो याद का लियो असो ही कियो करनु। ");
INSERT INTO hlb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","इ ही रीति से ओ न खानो को बाद कटोरा भी यू कहत हुयो दियो, “यू कटोरा मोरो उ खून म जे तुमरो लियो बहायो जात हैं नयो वादा हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","पर देख, मोरो पकड़न वालो का हात मोरो संग मेज म पर हैं। ");
INSERT INTO hlb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","काहेकि इंसान को पोरिया ते जसो ओके लाने ठहरायो गयो जात ही हैं, “पर धितकार उ इंसान पर जेके व्दारा उ पकड़वायो जावा हैं!” ");
INSERT INTO hlb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","तब वी आपस म पूछताछ करन लगिया कि हम म से कोन हैं, जे यू काम करेगों। ");
INSERT INTO hlb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ओ म यू वाद-विवाद भी कि उ म से कोन बड़ो समझो जावा हैं। ");
INSERT INTO hlb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ओ न ओसे कय्हो, “दुसरी जात हुन के राजा उन्न पर प्रभुता करा हैं। अर जे ओ पर अधिकार रखत हैं, वी उपकारक कहलाता हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","पर तुम असो नी होन; वरन् जे तू म बड़ो हैं, वी छोटो को समान अर जे प्रधान आय, उ सेवक को समान बनेगो। ");
INSERT INTO hlb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","काहेकि बड़ो कोन हैं, उ नी जे खाना पर बैठा हैं? परन्तु मी तुम्हारो बीच म सेवक को जसो हूँ। ");
INSERT INTO hlb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","तुम उ हो, जे मोरी परिक्छा हुन म लगातार मोरो संग रहेगो; ");
INSERT INTO hlb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","अर जसो मोरो बाप न मोरो लियो एक राज्य ठहरायो हैं, वसो ही मी भी तुम्हारो लियो ठहरात हूँ, ");
INSERT INTO hlb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ताकि तुम मोरो राज्य म मोरी मेज पर खायो-पियो, वरन् सिंहासन हुन पर बठ ख इस्राएल को बारा जात हुन को न्याय करेगों। ");
INSERT INTO hlb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“समोन, हे समोन! देख, सैतान न तुम लोग हुन का माँग लियो हैं कि जसो गहूँ को समान फटके, तुम ख फटके, ");
INSERT INTO hlb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","पर मी न तोरो लियो विनती की कि तोरो विस्वास जात नी रय्हे; अर जब तू फिरो, ते अपनो भई हुन का स्थिर करनु।” ");
INSERT INTO hlb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ओ न ओसे कय्हो, “हे प्रभु, मी तोरो संग जेल म जानो, वरन् मरन का भी तैयार हूँ।” ");
INSERT INTO hlb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ओ न कय्हो, “हे पतरस, मी तोसे कहूँ हूँ कि आज मुर्गा बाँग नी देगो जब तक तू तीन बार मोरो इंकार नी कर लेगो कि तू मोखा नी जानत।” ");
INSERT INTO hlb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","फिर ओ न ओसे कय्हो, जब मी न तुमका बटुवा, अर झोली, अर जूता बिना भेजो हतो, ते का तू को किसी वस्तु घटी हुई हती? उन्होना कय्हो, “किसी वस्तु की नी।” ");
INSERT INTO hlb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","यीसु ओसे कय्हो, “परन्तु अब जेके पास बटुवा हो उ ओ ख ले अर वसो ही झोली भी, अर जेके पास तलवार नी वी अपनो कपड़ा बेच ख एक मोल लेवा। ");
INSERT INTO hlb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","काहेकि मी तोसे कहूँ हूँ, कि जे लिखो हैं: ‘उ पापी हुन का संग गिनो गयो,’ ओखा मोखा म पूरो होवन ओखा मोखा म पूरो होवन अवस्य हैं; काहेकि मोरो विसय म लिखो बातो पूरो होन पर हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","तब उन्होना कय्हो, “हे प्रभु, देख यू वा दो तलवार उन आय।” ओ न ओसे कय्हो, “बेजा हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","“तब उ बाहर निकल ख अपनो रीति को अनुसार जैतून को टेकड़ा पर गयो अर चेला हुन ओके पिछु हो लियो। ");
INSERT INTO hlb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","उ जगह पहुँच ख ओ न ओसे कहयो, विनती करो कि तू परीक्छा म नी पड़ो।” ");
INSERT INTO hlb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","उ तुम ओसे अलग ढ़ेला फेकन को दूरी भर गयो, अर घुटना टेक ख बिनती करन लगिया, ");
INSERT INTO hlb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","हे बाप, यदि तू चाहा ते इ कटोरा का मोरो नजीक से हटा दा, तोभी मोरी नी परन्तु तोरी ही मारजी पूरी होए। ");
INSERT INTO hlb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","तब स्वर्ग से एक दूत ओको दिखाई दियो जे ओ ख सामर्थ्य देत हतो। ");
INSERT INTO hlb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","उ बेजा (अत्यन्त) संकट म व्याकुल होय ख अर भी हार्दिक वेदना से प्रार्थना करन लगियो; अर ओखा पसीना माननू खून को बड़ो-बड़ो बूँद हुन का समान जमीन पर गिरत हतो। ");
INSERT INTO hlb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","तब उ प्रार्थना से उठियो अर अपनो चेला हुन का नजीक आय ख उनका उदासी को मोरो सोते पायो। ");
INSERT INTO hlb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","अर ओसे कय्हो, “काहे सोत हो? उठ, प्रार्थना करो कि परीक्छा म नी पड़ो।” ");
INSERT INTO hlb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","उ असो बोलत ही रह कि एक भीड़ आई, अर वी बारा हुन म से एक जेको नाम यहूदा हतो उनको आगु-आगु आत रह। वह उ यीसु को सामे आयो कि ओको चुम्मा ले। ");
INSERT INTO hlb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","यीसु न ओसे कय्हो, “अरे यहूदा का तू चुम्मा ले ख इंसान को पोरिया ख पकड़वा हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ओखा संगी हुन न जब देखियो कि का होन वालो हैं, ते कय्हो, “हे प्रभु, का हम तलवार चलाय।” ");
INSERT INTO hlb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","अर उनमा से एक न बडो याजक को दास पर तलवार चला ख ओको दाहिनो कान काट दियो। ");
INSERT INTO hlb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ये पर यीसु न कय्हो, “अब सब करो।” अर ओको कान छू ख ओ ख चोक्खो करियो। ");
INSERT INTO hlb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","तब यीसु न मुखिया याजक हुन अर मन्दिर पहरू हुन का सरदार हुन अर सियाना हुन से, जे उ हुन पर चढ़ आयो हतो, कय्हो, “का तुम मो ख ड़ाकू जान ख तलवार अर लाठी हुन हुयो निकल हो? ");
INSERT INTO hlb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","जब मी मन्दिर म हर रोज तुम्हारो संग हतो, ते तू न मो पर हात नी ड़ालियो; पर हात नी ड़ालो; पर यू वा तुम्हारी बखत हैं, अर अंधकार को अधिकार हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","फिर वी ओ ख पकड़ ख ले गया, अर मुख्य याजक को घर म लायो। पतरस दुर ही से ओके पिछु-पिछु चलत रहा हतो; ");
INSERT INTO hlb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","अर जब वी आँगन म आग परचा ख इकठ्टे बैठिया, ते पतरस भी उनको बीच म बठ गयो। ");
INSERT INTO hlb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","तब एक दासी ओ ख आगी को उजियाला म बैठो देख का अर ओकी तरफ देख ख कहन लगी, “यू भी तो ओके संग हतो।” ");
INSERT INTO hlb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","पर ओ ना यू बोल ख मुंडो कर लियो कियो, अरे बाई (नारी), मी ओ ख नी जानु। ");
INSERT INTO hlb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","थोड़ी देर बाद कोई अऊर न ओखा देख ख कय्हो, “तू भी ते उन्ही म से हैं।” पतरस न कय्हो, “हे अदमी मी नी हूँ।” ");
INSERT INTO hlb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","कुछ कोई घंटा हुन का बाद एक अर अदमी विस्वास से कहन लगियो, “सच यू भी ते ओको संग हतो, काहेकि यू गलीली हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","पतरस न कय्हो, “हे इंसान, मी नी जानत कि तू का कहत हैं!” उ कह ही रय्हो हतो, कि तुरत मुर्गा न बाँग दियो। ");
INSERT INTO hlb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","तब प्रभु न घूम ख पतरस का तरफ देखियो, अर पतरस का प्रभु की उ बात याद आयो जे बात ओ न कय्ही हती: “आज मुर्गा को बाँग देन से पहलो, तू तीन बार मोरो इंकार करेगों।” ");
INSERT INTO hlb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","अर उ बाहर निकल ख फूट-फूट ख रोन लगियो। ");
INSERT INTO hlb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","जे इंसान यीसु का पकड़े हुयो हते, वी ओखा मजाक उड़ाए ख पीटन लगया; ");
INSERT INTO hlb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","अर ओकी आँख हुन ढ़ाक ख ओसे पुछियो, “भविस्यवानी कर ख बात कि तो ख को न मारो!” ");
INSERT INTO hlb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","अर उन्होना बेजा सी अर भी निन्दा की बात हुन ओखा विरोध म कय्ही। ");
INSERT INTO hlb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","जब दिन भयो ते लोग हुन अर सियाना हुन अर मुखिया याजक अर सासतिरी इकठ्टे भया, अर ओ ख अपनो महासभा म लाय ख पुछियो, ");
INSERT INTO hlb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","यदि तू मसी हैं, ते हमसे कह दा! ओ न ओसे कय्हो, “यदि मी तोसे कहूँ ते भरोसा नी करन ख; ");
INSERT INTO hlb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","अर अदि पूछु, ते उत्तर नी देन का। ");
INSERT INTO hlb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","परन्तु अब से इंसान को पोरिया सर्वसक्तिमान परमेस्वर की दाहिनो तरफ बैहिठ रहेगो।” ");
INSERT INTO hlb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","इ पर सब न कय्हो, ते का परमेस्वर को पोरिया हैं? ओ न ओसे कय्हो, “तुम तुम ही कहत हो, काहेकि मी हूँ।” ");
INSERT INTO hlb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","तब उन्होना कय्हो, “अब हमका गवाई का आवस्यक हैं; काहेकि हम न तुम ही ओके मुँह से सुन लियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","तब पुरी सभा न उठ ख ओखा पिलातुस को जोने ले गयो। ");
INSERT INTO hlb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","वी या बोल ख ओ पर अरोप लगावन लग गया; “हम न ये ख लोग हुन ख बेहेकावा, अर कैसर का कर देन से मना करते, अर अपनो तुम ख मसी राजा बोलते सुनियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","राजा पिलातुस न ओसे पूछो, “काहे तू यहूदी हुन को राजा हैं?” ओ न ओखा कय्हो, “तू अपनो तुम ही बोला हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","तब पिलातुस न मुखिया याजक हुन से अर अदमी हुन से कय्हो, “मो ख यू अदमी न कोई गलती नी दिखा हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","पर वी अर भी हिम्मत से बोलन लग गया, “यू गलील से लेखा यहाँ तक, पुरो यहूदिया म सिक्छा दे दे खा अदमी हुन ख उकसावा हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","यू सुन ख पिलातुस न पूछो, “काहे यू अदमी गलीली हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","अर असो समझ ख कि उ हेरोदेस को अधिकार इलाका को हैं ओखा हेरोदेस को पास भेज दियो, काहेकि वी दिन म उ भी यरूसलेम म हतो ");
INSERT INTO hlb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","हेरोदेस यीसु ख देख ख बेजा ही खुस भयो, काहेकि उ ओखा बेजा दिन से ओखा देखन चावत रह; ऐका लाने कि ओको बारे म सुनियो रह, अर ओसे कुछ चिखान देखन की आसा रखत रह, ");
INSERT INTO hlb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","उ ओसे ढ़ेर सारी बात पुछते रयो, पर ओ न ओ ख कुछ नी उय्हो। ");
INSERT INTO hlb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","मुखिया याजक अर सासतिरी खड़ो होय ख तन मन को संग अर ओ पर दोस लगात रया। ");
INSERT INTO hlb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","तब हेरोदेस न अपना सिपाई हुन का संग ओकी बुराई फरख ठट्ठा म उड़ायो अर चमकीला कपड़ा पहिना ख ओखा पिलातुस को जाने लउटा दियो। ");
INSERT INTO hlb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","उयी दिन से पिलातुस अर हेरोदेस दोई दोस्त बन गया, येको पहलो वी एक दुसरो का बैरी हता रह। ");
INSERT INTO hlb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","पिलातुस न मुखिया याजक हन, अर अदमी हुन ख बुला ख उनखा कय्हो, ");
INSERT INTO hlb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“तुम यू अदमी हुन को लोगो को बहकान वालो बता ख मोरो नजीक लाया, अर देखो, मी न तुम्हारो सामनो ओकी परख करी, पर जे बात को तुम ओपर आरोप लगावा हैं वी बात हुन को बारे म मी न ओमा कुछ भी अरोप नी पायो हैं ");
INSERT INTO hlb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","हेरोदेस न काहेकि ओ ना ओखा हमारो जोने लउटा हैं; अर देखो, ओसे असो कुछ मी नी भयो कि उ मार ड़ालन की सजा को लाने दियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","एकोलाने मी ओखा पिटवा ख छोड़ देहु हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","पिलातुस तिहार को बखत म ओको लाने एक कैदी ख छोड़न ख लाने मजबूर हता रह, ");
INSERT INTO hlb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","तब सब झन न मिल ख चिल्ला उठिया, “येको काम तमाम कर, अर हमारो लाने बरअब्बा ख छोड़ छोड़ दा। ");
INSERT INTO hlb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","उ किसी बलवा को कारन जे नगर म भयो हतो, अर मरन को कारन बन्दीगृह म डालो गयो हतो।” ");
INSERT INTO hlb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पर पिलातुस न यीसु ख छोड़न की इच्छा से अदमी हुन को फिर समझायो, ");
INSERT INTO hlb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","परन्तु उन्होना चिल्ला चिल्ला ख कय्हो ओ ख, “सूली पर चढ़ा, सूली पर!” ");
INSERT INTO hlb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ओ न तीसरो बार ओसे कय्हो, “काहे ओ न कोन सी बुराई कियो हैं? मी न ओमा माऊत को दण्ड को योग्य कोई बात नी पायो। एकोलाने मी ओ ख पिटवा ख छोड़ देत हूँ।” ");
INSERT INTO hlb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","पर वी चिल्ला-चिल्ला ख पिछु पड़ गया कि उ सूली पर चढ़ायो जाएगो, उनको चिल्लानो प्रबल भयो। ");
INSERT INTO hlb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","अत: पिलातुस न आग्या दियो कि उनकी विनती ख अनुसार कियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ओ न उ इंसान का जे बलवा अर माऊत को कारन जेल म ड़ालो गयो हता; अर जे से वी माँगत हते, छोड़ दियो; अर यीसु ख ओकी इच्छा को अनुसार सोप दियो। ");
INSERT INTO hlb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","जब वी ओ ख ले खा जात रह हता, जे उन्न समोन नाम को एक कुरेनी जे गाँव से आन रह हतो, पकड़ ओपर सूली लाद दियो कि ओखा यीसु को पिछु-पिछु लेख चले। ");
INSERT INTO hlb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","इंसान हुन की बड़ी जान भीड़ ओको पिछु जान लग गई अर ओमा ढ़ेर सारी बाई हुन भी हती, जे ओको लाने छाती पिटा अर दुख मानत रह हती। ");
INSERT INTO hlb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","यीसु न उनकी तरफ घुम ख कय्हो, “अरे यरूसलेम की पोरी हन, मोरो लाने मत रोव, परन्तु अपना अर अपना पोरिया पारी को लाने रोनो। ");
INSERT INTO hlb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","काहेकि देखो, वी दिन आवा हैं, जे म इंसान बोलेगो, धन्य हैं वी जे बजली हैं अर वी कोक जे नी जनी अर वी दूध जिन्ना दूध नी पिलायो। ");
INSERT INTO hlb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","उ बखत, वी पहाड़ हुन से बोलन लगेगो कि हमारो ऊपर गिडो, अर टिला हुन से की हमका ढ़ाक ला।” ");
INSERT INTO hlb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","काहेकि वी जब हरो झाड़ को संग असो कर सका हैं, ते सुखो को संग का कुछ नी करन करो जाहे? ");
INSERT INTO hlb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","वी दुसरा दो इंसान ख भी जे बुरा काम करन वाला हता ओको संग लटकान ख लाने ले जाहे ");
INSERT INTO hlb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","जब वी उ जगा जे को खोपड़ी को जगा बोला हैं पहुँचिया, ते उन ना वहाँ ओ ख अर उन बुरा काम करन वाला ख भी एक ख दाहिनी अर दुसरो ख बाई तरफ सूली पर चढ़ायो। ");
INSERT INTO hlb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","तब यीसु न कय्हो, “हे बाप ऐका माप कर, काहेकि यी नी जानत की यू का कर रया।” अर चिठ्टी डाल ख ओके आपस म कपड़ा हुन बाँट लियो। ");
INSERT INTO hlb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","लोग खड़ा-खड़ा देखत रह हता, अर मुखिया भी माजक कर ख कहत रह: “येना दुसरा का बचायो, अदि यू परमेस्वर को मसी हैं, अर ओको चुनो वालो हैं, ते अपनो तुम का बचा ल।” ");
INSERT INTO hlb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","मुखिया भी सामे आ यू ख अर अंगूर को काडवा रस दे ख ओको मजाक कर ख कहत हता। ");
INSERT INTO hlb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“अदि तू यहूदी हुन को राजा हैं, ते अपनो तुम ख बचा! ");
INSERT INTO hlb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","“अर ओको क्रूस ऊपर एक अरोप जिटठी भी लगो हतो; यू यहूदी हुन को राजा हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","जे बुरो काम करन वालो हुन का भी लटकायो गयो हतो, ओमा से एक न ओकी निन्दा कर ख कय्हो, “का तू मसी नी? ते फिर अपनो तुम का अर हम ख बचा!” ");
INSERT INTO hlb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","इ पर दुसरो न ओ ख डाँट ख कय्हो, “का तू परमेस्वर से भी नी डरत? तू भी ते उही दण्ड पर रय्हे हैं, ");
INSERT INTO hlb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","अर हम ते न्याय को अनुसार पा रय्हे हैं, काहेकि हम अपन बुरो काम हुन का फल पा रय्हे हैं; पर ऐना कोई बुरो काम नी कियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","तब ओ न कय्हो, “हे यीसु जब तू अपन राज्य म आएँगो, ते मोरी सुधि लेनो।” ");
INSERT INTO hlb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ओ न ओसे कय्हो, “मी तो से सच कहूँ हूँ कि आज ही तू मोरो संग स्वर्ग लोक म होगो।” ");
INSERT INTO hlb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","लगभग दोपहर से तीसरो पहर तक पुरो देस म अन्धियारो छायो रहयो, ");
INSERT INTO hlb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","अर सूरज को उजियाला जात रहयो अर मन्दिर को परदा बीच म से फट गयो, ");
INSERT INTO hlb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","अर यीसु न बड़ो आवाज से पुकार ख कय्हो, “हे बाप, मी अपनो आत्मा तोरो हात हुन म सोपत हूँ।” अर यू वा कह ख प्रायन छोड़ दियो। ");
INSERT INTO hlb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","सतपति न जे कुछ भयो हतो देख ख परमेस्वर की बड़ाई कियो, अर कय्हो, “निस्चय यू वा अदमी धर्मी हतो।” ");
INSERT INTO hlb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","अर भीड़ जे यू वा देखन का इकठ्टी हुई हती। इ घटना का देख ख छाती पीटत हुई लउट गई। ");
INSERT INTO hlb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","पर ओके सब जान पहचान वाला, अर जे बाई हुन गलील से ओके संग आई हती, दूर खड़ी होय ख यू वा सब देखत रह। ");
INSERT INTO hlb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","अर देख, उही यूसुफ नाम को बड़ो सभा (महासभा) को एक सदस्य हतो। जो अच्छो अर धर्मी अदमी हतो ");
INSERT INTO hlb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","अर ओकी योजना अर ओको इ काम हुन से खुसी नी हती। उ यहूदियो को नगर अरिमतिया का रहन वाला अर परमेस्वर को राज्य की रस्ता जोहन वालो हतो। ");
INSERT INTO hlb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ओ न पिलातुस को नजीक जाय ख यीसु को लास मंगियो; ");
INSERT INTO hlb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","अर ओ ख उतार ख मलमल की चादर म लपेटियो, अर एक कब्रर म रखियो, जे चट्ठान म खुदो भई हती; अर ओमा कभी कोई का नी रखो गयो हतो। ");
INSERT INTO hlb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","वी तैयारी को रोज हतो, अर आराम का दिन सुरू होवन पर हतो। ");
INSERT INTO hlb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","उ बाई हुन जे ओको संग गलील से आयो हती; पिछु-पिछु जायख उ समसान का देखो, अर यू भी कि ओको लास किस रीति से रखो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","तब उनहोना लउट ख खुसबूदार समान हुन इतर तैयार कियो; अर विसराम को उन्होना आग्या ख अनुसार छुट्टी को दिन कियो। ");
INSERT INTO hlb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","पर हफ्ता को पहलो दिन बड़ो सबेरो का नी उन खुसबूदार समान हुन का जे उन्होना तैयार कियो हतो लेय ख कब्रर पर आयो। ");
INSERT INTO hlb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","उन्होना पत्थर का समसान पर से लुढ़का भयो पायो, ");
INSERT INTO hlb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","पर आन्दर जाय ख प्रभु यीसु को लास नी पायो। ");
INSERT INTO hlb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","जब वी इ बात सर उलझन हो हती ते देखियो, दो इंसान हुन चमकीलो कपड़ा पहिनो हुयो ओके नजीक आ खडा भया। ");
INSERT INTO hlb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","जब वी डर गया अर जमीन की ओर मुँह झुकायो जे उन्होना ओसे कय्हो, “तुम जिन्दो का मरो हुओ म काहे ढूढ़न हो? ");
INSERT INTO hlb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","उ यहाँ नी, पर जी उठो हैं। स्मरण (याद) कि ओ न गलील म रहत हुओ तुम से कय्हो हतो, ");
INSERT INTO hlb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","अवस्य हैं कि इंसान को पोरिया पापी हुन को हात म पकड़यो जाएगो, अर सूली पर चढ़ायो जाएगो, अर तीसरो रोज जिन्दो उठयो।” ");
INSERT INTO hlb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","तब ओकी बात हुन ओको याद आयो, ");
INSERT INTO hlb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","अर समसान घाट से लउट ख उन्होना उ ग्यारह हुन का, अर अन्य सब का, यू वा सब बात हुन कह सुनायो। ");
INSERT INTO hlb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","जिन्हो प्रेरित हुन से यूव सब बात हुन कही वी मरियम मगदलीनी अर योअन्ना अर याकूब की माय मरियम अर ओके संग की कई बाई हुन भी हती। ");
INSERT INTO hlb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","पर ओकी बात हुन उनका कायनी सी जान पड़ियो, अर उन्होना ओकी भरोसा नी करी। ");
INSERT INTO hlb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","तब पतरस उठायो ख मरघट म दऊड गयो, अर झुकया ख केवल कपड़ा पड़िया देखो, अर जे भयो हता ओसे अचम्भा करत भयो अपनो घर चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","उही दिन ओ म से दो ही जन इम्माऊस नाम को एक गाँव का जा रहे हता, जे यरूसलेम से कोई दस किलो मीटर की दूरी पर हता। ");
INSERT INTO hlb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","“वी इ वा सब बात हुन पर जे हूई हती, आपस म बात चीत करत जा रय्हे हते, ");
INSERT INTO hlb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","अर जब वी आपस म बातचीत अर पूछताछ प्रस्न भी करत रह हता, ते यीसु आसपास म आय ख ओको संग म हो लियो। ");
INSERT INTO hlb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","परन्तु ओकी आँख हुन असी बंद कर दी गई हती कि ओ ख पहिचानू नी सको। ");
INSERT INTO hlb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ओ न ओसे पुछियो, यूव का बात हैं, जे तुम चलत चलत आपस म करत हो?” वी उदास से खड़ो हो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","यूव सुन ख ओमा से क्लियोपास नाम एक इंसान न कय्हो, “का तू यरूसलेम म अकेलो परदेसी आय, जे नी जानत कि इ दिन हुन म ओ म का-का भयो हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","यीसु न ओसे पूछो, “कोन सी बात?” उन्होना ओसे कय्हो, “यीसु नासरी का बारे म जे परमेस्वर अर सब अदमी हुन का नजीक काम अर वचन म सामर्थी भविस्यवक्ता हता, ");
INSERT INTO hlb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","अर मुखिया (प्रधान) याजक हुन अर हमार सासक हुन न ओ ख पकड़वा दियो दियो कि उ पर मरन की आग्या दी जाएगो, अर ओ ख सूली पर चढ़ायो। ");
INSERT INTO hlb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","पर हमका आसा हती कि यू ही इस्राएल का छुडा देहे गो। इन सब बात हुन का सिवाय इ घटना का भयो तीसरो दिन हैं, ");
INSERT INTO hlb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","अर हम म से कई बाई हुन न भी हमका आस्चर्य म ड़ाल दियो हैं, जे भुसारो का समसान पर गई हती; ");
INSERT INTO hlb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","अर जब ओखा लास नी पायो ते यूव कहत हुयो आयो कि हम न स्वर्गदूत हुन को दर्सन पायो, जिन्होना कय्हो कि उ जीवित हैं। ");
INSERT INTO hlb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","तब हमारो दोस्त हुन म से कई एक समसान पर गयो, अर जसो बाई हुन न कय्हो हतो वसो ही पायो; पर ओको नी देखो।” ");
INSERT INTO hlb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","तब ओ न उनसे कय्हो, “अरे बिना अकल का अर भविस्यवक्ता हुन की सबरी बात हुन पर भरोसा करनो म बेजा धीरे आय! ");
INSERT INTO hlb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","का जरूरी नी हतो कि मसी यूव दुख उठायो ख अपनो महिमा म प्रवेस करियो?” ");
INSERT INTO hlb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","तब ओ न मूसा से अर सब भविस्यवक्ता हुन से सुरू कर ख पुरा सुध्द सास्र म से अपनो बारे म लिखी बात हुन को मतलब उन ख समझ दियो। ");
INSERT INTO hlb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","इत्ते म वी गाँव को नजीक पहुँचियो जहाँ वी जा रहे हते, अर यीसु न ढ़ग से असो जान पड़ो कि ओ ख आगे बढनू चाहत रह। ");
INSERT INTO hlb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","पर उन्होना यूव कह ख ओ ख रोक, “हमारो संग रह, काहेकि साम हो चली हैं अर दिन अब बेजा ढल गयो हैं।” तब उ उनको संग रहन को लाने अर आनन्द गयो। ");
INSERT INTO hlb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","जब उ उनको संग खाना खान को बैठयो, ते ओ न रोटी लेय ख धन्यवाद कियो अर ओ ख तोड़ ख उनको देन लगियो। ");
INSERT INTO hlb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","तब ओकी आँखी खुल गई; अर ऊन न ओ ख पहचान लियो, अर उ ओकी आँखी हुन से छिप गयो। ");
INSERT INTO hlb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ऊन न आपस म कय्हो, “जब उ रस्ता म हमसे बात करत हतो अर सुध्द सास्र का अर्थ हमका समझत हतो, ते का हमारे मन म उत्तेजना नी उत्पन्न हुई?” ");
INSERT INTO hlb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","वी ऊई बखत उठ ख यरूसलेम का लोउट गयो, अर उ ग्यारह हुन अर ओके संगी हुन का इकठ्टे पायो। ");
INSERT INTO hlb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","वी कहत हते, “प्रभु सचमुच जी उठो हैं, अर समोन का दिखाई दियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","तब ऊन न रस्ता की बात हुन उन्हे बता दियो अर यू वा भी ऊन न ओखा रोटी तोड़त बखत कसो पहचानो। ");
INSERT INTO hlb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","वी इ बात कह ही रहे हते कि उ तुम ही उनको कय्हो, “तुम ख सान्ति मिले।” ");
INSERT INTO hlb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","“पर वी घबरा गया अर डर भी गया, अर समझो कि हम कोई भूत का देख रहयो हैं। ");
INSERT INTO hlb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ओ न ओसे कय्हो, काहे घबरात हो? अर तुम्हारो मन म काहे विचार उठत हैं? ");
INSERT INTO hlb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","मोरो हात अर मोरो पाय का देखो, कि मी उही हूँ। मो ख छु ख देख, काहेकि आत्मा को हड्डी मांस नी होत जसो मोरो म देखह हैं।” ");
INSERT INTO hlb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","यू कह ख ओ न ऊन का अपनो हात पाय दिखायो। ");
INSERT INTO hlb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","जब खुसी को मारे ओको भरोसा नी हुई, अर वी आस्चर्य करत हते, “ते ओ न ओसे पुछो, का यहाँ तुम्हारो नजीक कुछ खाना हैं?” ");
INSERT INTO hlb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","उन ना ओखा भुजी भई मच्छी को टुकड़ा दियो। ");
INSERT INTO hlb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ओ न ओ ख लेय ख उनको सामे खायो। ");
INSERT INTO hlb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","फिर ओ न उनसे कय्हो, “यू मोरी वी बात हैं, जे मी न तुम्हारो संग रहत हुए तुम लोग हुन कही हती कि आवस्य हैं कि जितनी बात मूसा की नेम की किताब अर भविस्यवक्ता हुन अर भजन हुन की किताब म मोरो विसय म लिखो हैं, सब पूरो होए।” ");
INSERT INTO hlb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","तब ओ न सुध्द सास्र बूझन को लाने उनकी समझ खोल दी, ");
INSERT INTO hlb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","अर ओसे कय्हो, “यो लिखो हैं कि मसी दुख उठाएगो, अर तीसरो दिन मरो भयो म से जिन्दो उठेगो, ");
INSERT INTO hlb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","अर यरूसलेम से लेय ख सब जाति हुन म मन को अर पाप हुन कि छमा को प्रचार, ओको नाम से कियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","तुम इ सब बात हुन को गवाह होए। ");
INSERT INTO hlb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","अर देख, जेकी वादा मोरो बाप न की हैं, मी ओको तुम पर उतारूँगो अर जब तक स्वर्ग से सामर्थ्य नी पाओ, तब तक तुम इ ही नगर म ठहरो रह।” ");
INSERT INTO hlb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","तब उ उनका बैतनिय्याह तक ले गयो, अर अपनो हात उठा ख उन ख आसीस दियो; ");
INSERT INTO hlb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","अर उन्हे आसीस देत भयो उ उनसे अलग हो गयो अर स्वर्ग पर उठा लियो गयो। ");
INSERT INTO hlb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","तब वी ओको दण्डवत कर ख बड़ो खुसी से यरूसलेम का लोउट गयो; ");
INSERT INTO hlb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","अर वी लगातार मन्दिर म उपस्थित हो ख परमेस्वर की स्तुति कियो करत हते।");
INSERT INTO hlb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","सबसे सुरू म सब्द हतो अऊर सब्द परमेस्वर को संग म हतो, सब्द ही परमेस्वर हतो।, ");
INSERT INTO hlb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","युईच सब्द ही सुरू म परमेस्वर को संग म हतो। ");
INSERT INTO hlb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","दुनिया की हर चीज ओसे ही उपजी। ओको बगर कोई की भी रचना नी भई आय। ");
INSERT INTO hlb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ओमन जीवन हतो अऊर उ जीवन ही दुनिया ख इंसान हुन को लाने उजेरो हतो। ");
INSERT INTO hlb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","उ उजेरो अंधेरा म भयो अऊर अंधेरा न ओखा दुर नी कर पायो। ");
INSERT INTO hlb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","परमेस्वर कि तरफ से एक अदमी आयो। जेको नाम यूहन्ना हतो। ");
INSERT INTO hlb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","उ गवाही देन आयो कि उजियारो कि गवाई दे, जसो सब इंसान ओको दुवारा भरोसा करे। ");
INSERT INTO hlb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","उ अपनो तुम म ज्योति तो नी हतो पर उ ज्योति कि गवाई देन ख लाने आयो हतो रह। ");
INSERT INTO hlb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","सच्ची को उजेरो जो हर एक इंसान ख उजेरो पहुचावा हैं, दुनिया म आन वाली हती। ");
INSERT INTO hlb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","सब्द संसार म हतो, अऊर दुनिया ओको दुवारा सिरजी; पर दुनिया ख न ओखा नी पहिचानियो। ");
INSERT INTO hlb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","उ अपना को जोने आयो अऊर ओखा अपना इंसान न ओखा नी अपनायो। ");
INSERT INTO hlb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","पर जीत्ता न ओखा अपनायो, अऊर ओको नाम म विस्वास करयो, वी सब ख ओ ना परमेस्वर की संतान बनन को हक दे दियो। ");
INSERT INTO hlb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","वी न तो खून से, न सरीर कि मर्जी से, न इंसान कि मर्जी से, पर परमेस्वर से सिरजिया हैं। ");
INSERT INTO hlb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","सब्द न सरीर रूप धर ख, हमरो बीच म आयो, अऊर हम न ओकी असी महेमा देखी जसो परमेस्वर बाप (पिता) को अकेलो पोरिया कि महेमा, जो किरपा अऊर सही से भरपूर हो ख हमारो बीच म ड़ेरा करो। ");
INSERT INTO hlb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","यूहन्ना न बोल-बोल ख ओको बारे म गवाई दियो, “यु उईच आय, जेको बारे म मीना कय्हो रहा जो मोरो बाद आवन वालो हैं उ मोसे बढ़ ख हैं; काहेकि उ मोसे पहलो से हतो रहा।” ");
INSERT INTO hlb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","काहेकि ओकी भरपुरी म से हम सब न हासिल करो एकोमतलब किरपा पर किरपा मिली हैं। ");
INSERT INTO hlb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","एकोलाने नेम तो हकीगत म मूसा को वजे से दी गई रहा, पर किरपा अऊर सच्चाई यीसु मसी को वजे से पहुँची। ");
INSERT INTO hlb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","परमेस्वर ख कभी कोई न नी देख्यो, पर सिरप इकलोतो पोरिया न, जो खुद परमेस्वर आय अऊर जो बाप को कोरा म हैं, उईच न ओखा उजागर करो। ");
INSERT INTO hlb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","यूहन्ना कि गवाई या हैं कि जब यहूदी हुन न यरूसलेम से याजक हुन अर लेवी हुन ख ओसे या पूछन को लाने भेजो, “तु कऊन आय?” ");
INSERT INTO hlb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","तब उनना मान लियो, मना नी पर मान लियो कि मी मसी नी हाय। ");
INSERT INTO hlb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","वी इंसान हुन न यूहन्ना से पुछियो “ते फिर तू कऊन आय? का तू एलिय्याह भविस्यवक्ता आय यूहन्ना न जवाब दियो, मी एलिय्याह नी आय?” “ते का तू उ भविस्यवक्ता आय जो आन वालो थो?” यूहन्ना न जवाब दियो, “नी।” ");
INSERT INTO hlb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","तब उन ना यूहन्ना से बोल्यो, “फिर तू आय कोन? जिन्ना हमका भेज्यो हैं, हम उनका का जुवाब देहे हमका पहिचान वालो ख जवाब देहे। तू अपनो बारे म का बोला हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","यूहन्ना न जुवाब दियो, मी आय, जसो कि यसायाह भविस्यवक्ता न कय्हो हैं, बियाबान जंगल म हाँका लगान वालो की आवाज प्रभु को याहा जान की रस्ता सिधी करो। ");
INSERT INTO hlb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","कुछ इंसान हुन फरीसी हुन कि ओर से भेजिया वाला हता। ");
INSERT INTO hlb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","उन न यूहन्ना से पुछियो, “अदि तू न तो मसी आय, न एलिय्याह अऊर न उ भविस्यवक्ता आय ते फिर बपतिस्मा काहे ख देवा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","यूहन्ना न ओखा जवाब दियो, “मी तो पानी से बपतिस्मा देऊ हैं, पर तुमारो बीच म एक अदमी खड़ो हैं जेका तुम नी जाना। ");
INSERT INTO hlb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","एको मतलब उ मोरो बाद आन वालो हैं, ओकी कि जूता की भी मी बददी खोलन को कबील नी हाय।” ");
INSERT INTO hlb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","या बात हुन यरदन को ओ नो पार बैतनिय्याह गाँव म भई, जेमा यूहन्ना बपतिस्मा देवत रह हतो। ");
INSERT INTO hlb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","दुसरो दिन ओ न यीसु ख अपनी तरफ आते देख ख कय्हो, “देखो यू परमेस्वर को पिल्ला आय जे दुनिया क पाप उठा ख ले जाय हैं। ");
INSERT INTO hlb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","यु उयीच आय जे को बारे म मी न कय्हो रह एक अदमी मोरो पीछु आवा हैं जे मोसे बड़ो हैं। काहेकि उ मोसे पहलो हतो रह। ");
INSERT INTO hlb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","मी तो ओ ख पहिचानत नी रह, पर ऐखा लाने मी पानी से बपतिस्मा देते आयो कि उ इस्राएल म परघट हो जाय।” ");
INSERT INTO hlb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","अर यूहन्ना न असी गवाई दियो, “मीना आत्मा ख कबूतर को जसो बददल या स्वर्ग से उतरते देख्यो हैं, अऊर वा ओ पर ठहर गई। ");
INSERT INTO hlb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","मी तो ओ ख पहिचानत नी रह, पर जोना मो ख पानी से बपतिस्मा देन ख भेज्यो, उईच न मोसे कय्हो, ‘जोपर तू सुध्द आत्मा ख उतरते अऊर बठते देखे, उईच सुध्द आत्मा से बपतिस्मा देन वालो हैं।’ ");
INSERT INTO hlb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","मीना खुद देख्यो, अऊर या मोरी गवाई हैं कि यूईच परमेस्वर को पोरिया आय।” ");
INSERT INTO hlb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","दुसरो दिन फिर यूहन्ना अऊर ओखा चेला म से दो झन खड़ा भया हता, ");
INSERT INTO hlb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","अऊर यूहन्ना न यीसु ख जाते घड़ी देख्यो अऊर कय्हो, “देखो यू परमेस्वर को पिल्ला आय।” ");
INSERT INTO hlb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ऐकोबाद वी दोई चेला ओकी या सुन ख यीसु को पिछु हो लियो। ");
INSERT INTO hlb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","यीसु न लउट ख उनका पिछु आते देखो अर उनसे कय्हो, “अरे गुरू, एकोमतलब, अरे प्रभु तू कहाँ पर रहवा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","यीसु न उनका कय्हो “चले ते देख लेहे।” उनना जा ख देख्यो कि उ कहाँ रहवा हैं, अऊर उ दिन ओको संग म रया। असो दिन को चार बजे तक (दसवां घण्टा) लग भग हतो। ");
INSERT INTO hlb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","जो चेला यूहन्ना कि बात सुन ख यीसु को पिछु हो लियो हता, वी दोई म से एक समोन पतरस को भई अन्द्रियास हतो। ");
INSERT INTO hlb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","उ पहले अपनो भई समोन से मिलियो अर ओसे बोल्यो, “हमका मसी, एकोमतलब मसी, मील गयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","अऊर उ ओखा यीसु को जोने ले गयो। यीसु न ओखा ध्यान से देख ख बोल्यो, “तू यूहन्ना को पोरिया समोन आय: तू कैफा मतलब पतरस कहलाए।” ");
INSERT INTO hlb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","दुसरो रोज यीसु न गलील परदेस जान ख सोचयो। ओकी मुलाकात फिलिप्पुस से भई। उनना ओसे बोल्यो, “मोरो पिच्छु आव।” ");
INSERT INTO hlb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","फिलिप्पुस बैतसैदा सहर को रहन वालो हतो। उते अन्द्रियास अर पतरस भी रहत रहा। ");
INSERT INTO hlb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","फिलिप्पुस नतनएल से मिल्यो अऊर बोल्यो, “जिनको बारे म मूसा न नेम म अर भविस्यवक्ता हुन न भी लिख्यो हैं, उ हमका मिल गयो हैं; उ नासरत को रहनवालो यूसुफ को पोरिया, यीसु आय।” ");
INSERT INTO hlb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","नतनएल न जुवाब दियो, “का कोई भली चीज भी नासरत म से निकल सखा हैं?” फिलिप्पुस न कय्हो, “चल ख देख ला।” ");
INSERT INTO hlb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","यीसु न नतनएल ख अपनी तरफ आते देख ख, ओको बारे म बोल्यो; “देखो, यू सच म इस्राएली आय। येमा कोई कपट नी हाय।” ");
INSERT INTO hlb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नतनएल न ओसे कय्हो, “तू मोखा कसो पहिचाना हैं?” यीसु न ओ ख उत्तर दियो, “येको पहले कि फिलिप्पुस न तो ख बुलायो, जब तू अंजीर को झाड़ को नीचु हतो, जब मीना तो ख देखो रह।” ");
INSERT INTO hlb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","नतनएल न उनसे बोल्यो, “अरे गुरू जी तू परमेस्वर को पोरिया आय; तू इस्राएल को राजा आय।” ");
INSERT INTO hlb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","यीसु न ओखा उत्तर दियो, “मी न तुम से बोल्यो, मी न तोखा अंजीर को झाड़ को नीचु देख्यो, का तुम येको लाने भरोसा करा हैं? तुम येसे भी बड़ा-बड़ा काम देखेगो।” ");
INSERT INTO hlb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","यीसु न ओसे यू भी बोल्यो, “मी तुम इंसान हुन से सच्ची-सच्ची कहूँ हैं: तुम स्वर्ग ख खुल्यो, अर परमेस्वर ख स्वर्गदूत हुन ख इंसान को पोरिया को ऊपर चढ़ते अर उतरते देखेगो।” ");
INSERT INTO hlb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","फिर तीसरो रोज गलील को काना सहर म कोई कि सादी हती, अर यीसु कि माय भी वहाँ हती। ");
INSERT INTO hlb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","यीसु अर ओखा चेला हुन ख भी वा सादी म नेवता देखा बुलायो गयो हतो। ");
INSERT INTO hlb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","जब अंगूर को रस कम पड़ गयो, ते यीसु कि माय न ओसे कय्हो, “उन को जोने अंगूर को दाख रस नी रयो।” ");
INSERT INTO hlb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","यीसु न जुवाब दियो, “अरे बाई मो ख तोरो से का काम? अबा मोरो बखत नी आयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ओकी माय न सेवक हुन से कय्हो, “जे कई भी उ तुम से बोले, उसी ही करनु।” ");
INSERT INTO hlb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","वहाँ पर यहूदी हुन की सुध्द करन की रीत को हिसाब से पत्थर का छे: मटका धरया हता रहा जेमा कि दो-दो तीन-तीन मन पानी समात रह हतो। ");
INSERT INTO hlb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","यीसु न सेवक हुन से कय्हो, “मटका हुन म पानी भर देव।” उन न उन ख मुड़ो तक लबा-लब भर दीयो। ");
INSERT INTO hlb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","तब यीसु न उनसे कय्हो, “अब हेड का खाना खलान वालो घर को उ मुखिया को जोने ले जाव।” अर वी ले गया। ");
INSERT INTO hlb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","जब उ खाना खालान वालो घर को मुखिया न उ पानी ख पीयो, जो अंगूर को रस बन गयो रह अर नी जानत रह कि उ किते से लायो हैं। (पर जे सेवक हुन न पानी निकायो रह वी जानत रह हता), ते खाना तैयार करन वालो घर को मुखिया न दुल्हा ख बुलाय ख ओसे कय्हो, ");
INSERT INTO hlb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“हर एक इंसान पहले चोक्खो दाख रस देवा हैं, अर जब अदमी हुन पी ख छक जावा हैं: तब थोड़ो ठण्ड़ो वालो देवा हैं पर तू न अच्छो अंगूर को रस अबा लक रक ख धरियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","यीसु न अपनो यू पहिलो अदभुत चिन्ह गलील को काना सहर म दिखायो असो तरीका से ओ ना खुद ख उजागर करियो अर ओ ख चेला हुन न ओको पर भरोसा करयो। ");
INSERT INTO hlb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","येको बाद यीसु अर ओकी माय अर ओखा भई हुन अर ओखा चेला हुन को संग कफरनहूम सहर ख गयो अर उते कुछ दिन रयो। ");
INSERT INTO hlb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहूदी हुन को फसह को तिहार आन वालो हतो, अर यीसु यरूसलेम सहर ख गयो। ");
INSERT INTO hlb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","वहाँ ओ न मन्दिर म बईल, भेड़ अर कबूतर ख बेचन वाला अर अपनो टेबल को जोने बैठिया बियाना करन वाला ख देख्यो। ");
INSERT INTO hlb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","यीसु न रस्सी हुन को कोड़ा बना ख, सब भेड़ हुन अर बईल हुन ख मन्दिर से निकाल दियो, ओ ना बियाना करन वाला का पैसा छितरा दियो, उनको टेबल उलटा दियो, ");
INSERT INTO hlb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","अर कबूतर बेचन वाला से कय्हो, “यू सब ख यहाँ से हटा ख ले जाव। मोरो पिता परमेस्वर को घर ख बजार मत बनाव।” ");
INSERT INTO hlb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","तब ओ ख चेला हुन ख सास्र को यू वचन याद आयो, “तोरो घर कि चिन्ता-फिकर मोखा खा जाहे।” ");
INSERT INTO hlb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ये पर यहूदी धरम ख गुरू हुन न यीसु से कय्हो, “तू हमका कोन सो भयानक चिन्ह दिखा सका हैं, जेसे हम यू समझे कि जसो तू जो कुछ करा हैं, ओको तू हक रखन वालो हैं यू साबित हो जाय?” ");
INSERT INTO hlb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","यीसु न उनका जवाब दियो, “यू मन्दिर ख खतम कर देव अर मी ये ख तीन रोज म खड़ो कर देहु।” ");
INSERT INTO hlb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","येपर वी यहूदी हुन न कय्हो, “यू मन्दिर ख बननो म छियालीस बरस लग्या, अऊर का तू येका तीन दिन म खड़ो कर देहे?” ");
INSERT INTO hlb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","पर यीसु न अपनो सरीर को मन्दिर को बारे म बोल्यो रहा। ");
INSERT INTO hlb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","जब उ मुर्दा म से जिन्दो भयो, ते ओ ख चेला ख याद आयो कि यीसु न असो बोल्यो रहा अर उनना सुध्द सास्र अर उ वचन कि जे यीसु न कय्हो रहा, भरोसा करयो। ");
INSERT INTO hlb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","जब यीसु यरूसलेम म फसह को बखत तिहार म हतो, ते ढ़ेर सारा इंसान हुन न उनको वजे से भया वाला भयानक चिन्ह देख ख ओको नाम पा भरोसा करयो। ");
INSERT INTO hlb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","पर यीसु न अपनो तुम ख उनको भरोसा पर नी छोड़यो, काहेकि उ सब ख जानत रह; ");
INSERT INTO hlb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","उनका या जरूरत नी हती कि कोई उनका इंसान को बारे म बताया; काहेकि उ खुद जानत रहा कि इंसान को मन म का चला हैं। ");
INSERT INTO hlb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","फरीसी समुदाय को एक इंसान हतो ओको नाम नीकुदेमुस थो उ यहूदी हुन को एक मुखिया हतो। ");
INSERT INTO hlb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","उ रात म यीसु को जोने आयो अऊर बोल्यो, “अरे गुरू हम जाना हैं कि तू परमेस्वर कि तरफ से आयो वालो गुरू हैं। तू जो हईब ख चिन्ह दिखावा हैं, उनका कोई तब लक नी दिखा सका, जब लक की परमेस्वर ओको संग म नी होय।” ");
INSERT INTO hlb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","यीसु न ओखा जवाब दियो, “मी तोसे सच्ची-सच्ची कहूँ हैं, अदि कोई नयो सिरा से नी जनम लेन को ते परमेस्वर को राज देख नी सका।” ");
INSERT INTO hlb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","नीकुदेमुस न ओसे पुछयो, “इंसान जब सियानो हो गयो, ते कसो जनम ले सका: हैं? का उ माय को कोक म दुसरी बार जाका जनम ले सका हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","यीसु न जवाब दियो, “मी तोसे सच्ची-सच्ची कहूँ हैं, जब लक कोई इंसान पानी अर आत्मा से जनम नी लेन को तब लक उ परमेस्वर को राज म नी जा सकन को। ");
INSERT INTO hlb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","काहेकि जो सरीर से जनमिया हैं, उ सरीर हैं; अऊर जो आत्मा से जनमिया हैं, उ आत्मा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","हैंरान मत होव कि मीना यू बोल्यो कि तुम ख नयो सिरा से जनम लेनो जरूरी हैं। ");
INSERT INTO hlb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","हवा जिते चाहवा हैं उते चला हैं अर तुम ओकी आवाज सुना हैं, पर नी जाना कि वा किते से आवा हैं अर किते ख जावा हैं? जे कोई आत्मा से जनमिया हैं उ असोईच ही हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","नीकुदेमुस न ओसे पुछयो, “असो कसो हो सका हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","यीसु न ओखा जुवाब दियो तू इस्राएली हुन को गुरू आय अऊर यी बात हुन ख नी समझा? ");
INSERT INTO hlb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","मी तोसे सच्ची-सच्ची कहूँ हैं कि हम जो जाना हैं उईच ही बोला हैं, अर जेका हम न देखो हैं ओकी गवाई देवा हैं, अर तुम हमारी गवाई कबुल नी करा। ");
INSERT INTO hlb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","जब मी न तुम से दुनिया कि बात बताई अर तुम भरोसा नी करा ते, अदि मी तुम से स्वर्ग कि बात बोलू, ते तुम फिर कसा भरोसा करे? ");
INSERT INTO hlb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","कोई इंसान स्वर्ग पर नी चढ़ायो, केवल उई जो स्वर्ग म से उतरो, एको मतलब इंसान को पोरिया जो स्वर्ग म हैं। ");
INSERT INTO hlb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","अर जो तरीका से मूसा न जंगल म साँप ख ऊँचो पर लटकायो, उईच तरीका से जरूर हैं कि इंसान को पोरिया भी ऊँचो पर लटकायो जाहे; ");
INSERT INTO hlb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ताकि जो भी कोई ओपर भरोसा करे, उ ओमा अनन्तकाल को जीवन ख पाहे। ");
INSERT INTO hlb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“काहेकि परमेस्वर न पुरा दुनिया ख इंसान हुन से असो प्रेम रख”, कि ओ न अपनो अकेलो पोरिया तक दे दियो, ताकि जो कोई ओपर भरोसा करे उ नास नी होन को, पर अनन्त जीवन पाहे। ");
INSERT INTO hlb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","परमेस्वर न अपनो पोरिया ख दुनिया म येको लाने नी भेजो कि उ दुनिया ख दोसी ठहराए। ओ ना ओखा एकोलाने भेज्यो हैं, कि संसार ओको दुवारा छुटकारा ख पाहे। ");
INSERT INTO hlb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","जो पोरिया पा भरोसा करा हैं, ओपर दोस नी लगायो जावा। जो ओपर भरोसा नी करा, उ दोसी ठहर चुक्यो; काहेकि उ परमेस्वर को इकलोतो पोरिया को नाम पा भरोसा नी करा। ");
INSERT INTO hlb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","दोसी ठहरान को यू कारन हैं कि ज्योति दुनिया म आई हैं, अर इंसान हुन न अंधेरा ख उजेरो (ज्योति) से जादा अच्छो समझियो काहेकि उनका काम बुरा हता। ");
INSERT INTO hlb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","काहेकि जो कोई बुराई करा हैं, उ ज्योति से बैर रखा हैं, अर ज्योति को जोने एकोलाने नी आवा, असो नी होय कि ओखा काम हुन पर दोस लगायो जाय। ");
INSERT INTO hlb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","पर जो सच्चई पर चला हैं, उ ज्योति को पास म आवा हैं, “ताकि ओखा काम हुन दिखन लग जाय कि वी परमेस्वर कि तरफ से करयो वाला हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","एको बाद यीसु ओखा चेला हुन को संग यहूदिया देस म आयो। अर उ वहा उनको संग म रह ख बपतिस्मा देन लग्यो। ");
INSERT INTO hlb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","यूहन्ना भी सालेम सहर को नजीक एनोन म पानी संस्कार देत रहा हतो, काहेकि वहा बेजा पानी हतो। अर अदमी वहा आ-आ ख बपतिस्मा लेवत, रहा। ");
INSERT INTO hlb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","यूहन्ना वा बखत लक जेल खाना म नी ड़ालो गयो रहा हतो। ");
INSERT INTO hlb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ओमा यूहन्ना को चेला हुन को कोई यहूदी धरम गुरू को संग म सुध्द होन को बारे म बहस भई। ");
INSERT INTO hlb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","अर उनना यूहन्ना को कने आ ख ओसे कय्हो, अरे गुरू या रब्बी, देख, जो यरदन नद्दी को ओनो पार तोरो संग हतो, अर जेको बारे म तू न गवाई दी हैं; देख, “उ बपतिस्मा देवा हैं”, अर सब ओको पास म आवा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","यूहन्ना न जवाब दियो, “जब तक इंसान ख स्वर्ग से नी दियो जाय, तब लक ओ ख कुछ भी नी मिल सका: ");
INSERT INTO hlb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","तुम तो अपनो तुम म ही मोरा गवाई हैं कि मी न बोल्यो, ‘मी मसी नी आय, पर ओको आगे भेजयो गयो हैं।’ ");
INSERT INTO hlb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","जो कि दुलिन आय, उई दुला आय; पर जो दुला को दोस्त जो खड़ो भयो ओकी सुना हैं, दुला नाम को सब्द से बेजा खुस होवा हैं: अब मोरी या खुसी पुरी भई हैं। ");
INSERT INTO hlb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","यू जरूरी हैं कि उ बढ़ते जाय अर मी घटु। ");
INSERT INTO hlb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“जो ऊपर से आवा हैं उ सबसे अच्छो हैं; जो दुनिया से आवा हैं उ दुनिया को हैं, अर दुनिया पर कि बात हुन करा हैं: जो स्वर्ग, म से आवा हैं उ सब को ऊपर हैं। ");
INSERT INTO hlb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","जो कुछ भी ओ न देखो अर सुनो हैं, ओकीच गवाही देवा हैं; अर कोई ओकी गवाई ख नी माना। ");
INSERT INTO hlb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","जोना ओकी गवाई ख मान लियो ओ न या बात पर मोहर लगा दियो कि परमेस्वर सच्चो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","काहेकि जेका परमेस्वर न भेजो हैं, उ परमेस्वर कि बात बोला करा हैं; काहेकि उ आत्मा नाप-नाप ख नी देवा। ");
INSERT INTO hlb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","बाप पोरिया ख बेजा प्रेम रखा हैं अर ओ न पुरी चीज ओको हात म दे दियो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","जो पोरिया पर भरोसा करा हैं, अनन्त जीवन ओको ही हैं; पर जो पोरिया कि नी माना, उ जीवन ख नी देखन को, परमेस्वर कि घुस्सा या क्रोध ओपर बनो रहवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","फरीसी हुन ख असो पता भयो कि यीसु यूहन्ना से जादा चेला हुन बनावा अर उनका बपतिस्मा देवा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","पर यीसु खुद नी, पर ओखा चेला हुन बपतिस्मा देवत रहा। जब यीसु ख ऐको पता चल्यो, ");
INSERT INTO hlb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","तब उ यहूदिया परदेस ख छोड़ ख फिर गलील परदेस ख चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","अर ओखा सामरिया से होका जानो जरुरी थो। ");
INSERT INTO hlb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","एकोलाने उ सामरिया परदेस को सूखार नाम को सहर पहुँचियो। यू सहर वा जमीन को जोने म हैं, जोका याकूब न अपनो पोरिया यूसुफ ख दियो रहा; ");
INSERT INTO hlb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","वहाँ याकूब को कुवा भी हैं। यीसु रस्ता से थक गयो रहा, एकोलाने उ कूवाँ को जोने असो ही बठ गयो रहा। या बात लगभग दोपहर को करीब की आय। ");
INSERT INTO hlb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","इत्तो म सामरिया कि एक बाई पानी भरन ख आई। यीसु न ओसे कय्हो, “मो ख पानी पिला।” ");
INSERT INTO hlb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","काहेकि ओखा चेला हुन तो सहर म खाना मोल लेन ख गया हता। ");
INSERT INTO hlb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","यहूदी हुन सामरी हुन से कोई लेन-देन नी रखत आय। एकोलाने सामरी बाई न यीसु से कय्हो, “यू का होवा हैं कि तू यहूदी होका भी मी सामरी ओरत से पानी काहे ख माँगा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","यीसु न जवाब दियो, “अदि तू परमेस्वर को वरदान ख जानती, अर या भी जानती कि उ कोन आय, जो तोसे बोल रयो हैं, मो ख पानी पिला, ते तू ओसे माँगत, अर उ तोखा जिन्दगी को पानी देतो।” ");
INSERT INTO hlb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ओरत न यीसु से कय्हो, “अरे प्रभु तोरो जोने पानी भरन ख लाने तो कही भी नी हाय, अऊर कुवा गहिरो हैं; ते फिर उ जिन्दगी पानी को पानी तोरो पास किते से आयो? ");
INSERT INTO hlb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","का तू हमारो बाप दादा याकूब से भी बड़ो हैं? जोना हमका यू कुवाँ दियो; अर ओ न खुद अपनी अवलाद हुन, अर अपना ढोर बईल हुन समेत येमा से पियो?” ");
INSERT INTO hlb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","यीसु न ओखा जवाब दियो, “जे कोई यू पानी पीहे उ फिर प्यासो होए, ");
INSERT INTO hlb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","पर जो मोरो दियो वालो पानी पीए कोई उ पानी म से पिहेगो जो मी ओखा देऊ, उ फिर अनन्त काल को जीवन लक प्यासो नी रहन को; पर जो पानी मी ओखा देऊ, उ ओमा एक झिरिया सो बन जाहे जे अनन्त जीवन को लाने हमेसा उमंड़तो रहेगो।” ");
INSERT INTO hlb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","येपर ओरत न ओसे कय्हो, “प्रभु, उ पानी मोखा दे ताकि मी प्यासी नी रहन कि अऊर न पानी भरन ख इत्ती दुर आन की।” ");
INSERT INTO hlb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","यीसु न ओसे कय्हो, “जा तोरो घर को का बुला ख लाजे।” ");
INSERT INTO hlb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ओरत न जवाब दियो, “मी बिना अदमी कि हैं।” यीसु न ओसे कय्हो, तुना ठीक ही बोल्यो हैं, मी बिना अदमी कि हैं। ");
INSERT INTO hlb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","काहेकि तूना पाँच अदमी कर लियो हैं, अर जेको जोने तू अबा हैं उ भी तोरो अदमी नी हाय। या तुना सच ही कही हैं। ");
INSERT INTO hlb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","बाई न ओसे कय्हो, अरे प्रभु, मोखा लगा हैं कि तू कोई भविस्यवक्ता आय। ");
INSERT INTO hlb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","हमारा बाप दादा न याईच पहाड़ म बिनती करी, अर तुम बोला हैं कि वा जगा जेमा बिनती करनो चाहिए यरूसलेम म हैं। ");
INSERT INTO hlb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","यीसु न ओसे कय्हो, बाई मोरी बात को भरोसा कर कि उ बखत आवा हैं जब तुम न तो या पहाड़ म बाप कि बिनती करे, न यरूसलेम म। ");
INSERT INTO hlb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","तुम जेखा नी जाना, ओकी बिनती करा हैं अऊर हम जेखा जाना ओकी भक्ती करा हे; काहेकि उध्दार यहूदी हुन म से हैं। ");
INSERT INTO hlb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","पर उ बखत आवा हैं, वरन आ ही गयो, जेमा सच्चा भक्त बाप कि बिनती आत्मा अर सच्चाई से करे, काहेकि बाप अपनो लाने असा ही सच्ची भक्ति करन वाला ख ढूँढा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","काहेकि परमेस्वर आत्मा हैं, “यू जरूरी हैं कि ओकी भक्ति करन वाला आत्मा से अर सच्चई से बिनती करे।” ");
INSERT INTO hlb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","बाई न ओसे कय्हो, “मी जानू हैं कि मसी जो परमेस्वर को जन कहलावा हैं, आन वालो हैं; जब उ आएँगो, ते हमका सब बात बता देहे।” ");
INSERT INTO hlb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","यीसु न ओसे कय्हो, “मी, जो तोसे बोल रयो हैं, मी उई आय।” ");
INSERT INTO hlb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","इत्ता म ओखा चेला आ गया, अर यीसु ख एक ओरत को संग बात हुन करते देख ख सोच म पड़ गया; फिर भी कोई न असो नी बोल्यो, “तुमका का चाहिए?” “तू या बाई से काहे बात कर रयो हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","तब वा बाई न अपनो मटका वही छोड़ दियो, अर सहर म जा ख इंसान हुन से बोली, ");
INSERT INTO hlb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“आव, एक इंसान ख देखो, जोना मोखा उ सब कुछ जो मीना करियो मोखा बता दियो। कही युई तो मसीहा नी आय?” ");
INSERT INTO hlb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","एकोबाद: वी इंसान सहर से निकलिया अर यीसु को जोने आन लग गया। ");
INSERT INTO hlb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","येको बीच ओ ख चेला हुन न यीसु से असी विनती करी, “गुरू!, कुछ खा ला।” ");
INSERT INTO hlb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","पर ओ ना उनसे कय्हो, “मोरो पास खान ख लाने असो खाना हैं जेका बारे म तुम नी जाना।” ");
INSERT INTO hlb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","तब चेला हुन न आपस म कय्हो, “का कोई ओको लाने कुछ खान ख लायो हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","येपर यीसु न उनसे बोल्यो, जेना मोखा भेज्यो हैं ओकी मर्जी को हिसाब से चलू अर ओको काम पुरो करनो, यूइच मोरो खाना आय। ");
INSERT INTO hlb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“का तुम असा नी बोला की अब कटनी का चार महा रैय गया हैं? पर मी तुम इंसान हुन से कहूँ हैं ‘देखो, मी तुम से बोलू हैं, अपनी आँखी उठा ख ध्यान से खेत हुन पर नजर घुमाव कि वी कटनी को लाने पक चुक्या हैं। ");
INSERT INTO hlb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","काटन वालो मजदूरी कमाहे अर अनन्त जीवन को लाने फल बटोरा हैं, ताकि बोन वालो अर काटन वालो दोई मिल ख आनन्द करे। ");
INSERT INTO hlb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","काहेकि येमा या कहवत ठीक बैठा हैं: एक बोवा हैं अऊर दुसरो काटा हैं।’ ");
INSERT INTO hlb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","मी न तुम ख उ खेत काटन ख लाने भेज्यो हैं, जोमा तुम न मेहनत नी करयो: दुसरा न मेहनत करयो अर तुम उनकी मेहनत को फल म सामिल भया।” ");
INSERT INTO hlb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","वा ओरत न या गवाई दी रहा, ओ ना मोखा उ सबरो, जो मिना करयो, बता दियो हैं। या बात को वजे से उ सहर ख ढ़ेर सारा सामरी हुन न यीसु को ऊपर भरोसा करयो। ");
INSERT INTO hlb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","जब सामरी लोग यीसु को जोने आया, तब उनना हात जोड़ ख विनती करी, तू हमरो गाँव म रूक उ दो रोज वही रूक्यो। ");
INSERT INTO hlb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ओको वचन को बतानो से अऊर भी बेजा सारा अदमी हुन न भरोसा करयो ");
INSERT INTO hlb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","सामरी इंसान हुन वा ओरत से बोल्या, “अब हम तोरो बोलन को वजे से भरोसा नी करा। हमना खुद ओको मुंडो से ऐका लियो हैं अऊर हम जान गया कि उ सचमुच म संसार को मुक्तिदाता आय।” ");
INSERT INTO hlb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","फिर वी दो दिन को बाद उ ओमा से निकल ख गलील परदेस ख गयो, ");
INSERT INTO hlb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","काहेकि यीसु न खुद ही गवाई दीयो रहा कि अपनो देस म भविस्यवक्ता को सम्मान नी होवा। ");
INSERT INTO hlb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","जब उ गलील परदेस पहुँचियो, तब इंसान हुन न ओको मान सम्मान करयो; काहेकि यीसु न तिहार को दिन हुन म यरूसलेम म जो कुछ करयो रहा, उ सब गलीली परदेस ख वी रहवासी हुन न देख्यो रहा। तिहार को लाने वी भी वहाँ गया हता। ");
INSERT INTO hlb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","यीसु फिर गलील परदेस को काना सहर म आयो, जिते ओ ना पानी ख अंगूर को रस बनायो रहा। ओमन राज्य को एक सरकारी करम चारी भी हतो, जेको पोरिया कफरनहूम सहर म जुड़ म हतो। ");
INSERT INTO hlb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","जब उ सरकारी करमचारी न सुन्यो कि यीसु यहूदिया परदेस से गलील परदेस ख आ गयो हैं, तब उ उनको जोने आयो। सरकारी करमचारी न ओसे विनती करी कि उ चल ख ओको पोरिया ख चोक्खो कर दे, काहेकि उ मरन पर हतो रहा। ");
INSERT INTO hlb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","यीसु न ओसे कही, “तुम इंसान जब लक चिन्ह अऊर अदभुत नी देखन ख तब लक कुछ भी भरोसा नी करन का।” ");
INSERT INTO hlb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","येपर सरकारी करमचारी न ओसे बोल्यो, “प्रभु! मोरो पोरिया को मरन से पहले आव।” ");
INSERT INTO hlb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","यीसु न जवाब दियो, “जा, तोरो पोरिया जिन्दो हैं।” उ यीसु कि कही बात को ऊपर भरोसा कर ख चल दियो ");
INSERT INTO hlb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","उ रस्ता म हतो कि ओ ख नउकर ओसे आ मिल्या अर ओसे कहन लग्या, “तोरो पोरिया जिन्दो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ओ ना उनसे पुछयो “कि उ कित्ती घड़ी से अच्छो होन लग गयो रहा। कल दिन को एक बजे ओको जुड़ उतर गयो रहा।” ");
INSERT INTO hlb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","तब बाप जान गयो कि ठीक उत्तीच घड़ी यीसु न ओसे कय्हो रहा, “तोरो पोरिया जिन्दो हैं,” अर ओ न अपनो पुरो घर का को संग भरोसा करयो, ");
INSERT INTO hlb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","यु यीसु को दुसरो चमत्कार चिन्ह हतो, जो उनना यहूदिया परदेस से आ ख गलील परदेस म दिखायो। ");
INSERT INTO hlb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ऐको कुछ रोज को बाद यहूदी हुन को एक तिहार भयो, अर यीसु यरूसलेम ख गयो। ");
INSERT INTO hlb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरूसलेम म भेड़-फाटक को कने एक कुण्ड हैं जो इब्रानी भासा म बैतहसदा कहलावा हैं; ओखा पाँच ओसरा हैं ");
INSERT INTO hlb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","येमा बेजा सारा बिमार, अंधा, लंगड़ा अर सुखा अंग वाला पानी को हलनो कि आसा म पड़िया रहत रहा। ");
INSERT INTO hlb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","काहेकि सही बखत म परमेस्वर को स्वर्ग दुत कुण्ड म उतर ख पानी ख हलात रह। पानी को हलाते ही जो भी कोई उतरा उ चोक्खो हो जात रह चाहे ओकी कित्तीच बड़ी बिमारी काहे नी होय। ");
INSERT INTO hlb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ओमा एक अदमी हतो, जो अड़तीस बरस से बिमारी म पड़ो हतो। ");
INSERT INTO hlb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","यीसु न ओ ख वहा पड़ो देख ख अर असो जान ख कि उ बेजा दिन से असी दसा म पड़ियो हैं, ओसे पुछो, “का तू चोक्खो होनो चाहवा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","उ बिमार न ओखा जवाब दियो, “अरे प्रभु, मोरो कोइ नी हाय कि जब पानी हलायो जावा, ते मो ख पानी को कुण्ड म उतारे; पर मोरो पहुँचते-पहुँचते दुसरो मोसे पहले उतर जावा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","यीसु न ओसे कय्हो, “उठ, अपनो खटिया उठा अर चल फिर।” ");
INSERT INTO hlb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","उ बिमार अदमी उत्तीच घड़ी चोक्खो हो गयो, अर अपनो खटिया उठा ख चलन फिरन लग गयो अर उ आराम को दिन हतो। ");
INSERT INTO hlb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","येपर यहूदी हुन न जो अच्छो हो गयो रहा, बोल्यो, “आज आराम करन को दिन हैं अऊर हमरा नेम हुन को यू हिसाब से नी हाय कि तू अपनो खटिया उठायो।” ");
INSERT INTO hlb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ओ न उनका जवाब दियो, “जोना मोखा अच्छो करो हैं, ओ ना ही मोखा बोल्यो हैं कि, अपनो खटिया उठा, अऊर चल फिर।” ");
INSERT INTO hlb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","वी इंसान हुन न ओसे पुछियो, “उ कोन इंसान आय जो न तोसे बोल्यो रहा, ‘अपनो खटिया ख उठा अर चल फिर’?” ");
INSERT INTO hlb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","पर उ बिमार इंसान जो चोक्खो हो गयो रह, नी जानत रह कि उ कोन थो, काहेकि वा जगा म जादा भीड़ हती अऊर यीसु वहा से चुपचाप चल दियो रहा। ");
INSERT INTO hlb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","असी बात हुन को बाद यीसु न उ इंसान ख मन्दिर म देख्यो ओसे कय्हो, “देख, तू अब चोक्खो होय गयो हैं” फिर से पाप मत करजे, असो नी होय कि येसे कोई बड़ो दुख तो पर आ जाहे। ");
INSERT INTO hlb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","अऊर उ अदमी न यहूदी हुन से आ ख बोलयो कि मोखा अच्छो करन वालो यीसु आय। ");
INSERT INTO hlb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","काहेकि यीसु न असो काम आराम को दिन करयो रहा। एको लाने यहूदी हुन न यीसु ख सतानो सुरू कर दियो।, ");
INSERT INTO hlb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","असो पर यीसु न उनसे कय्हो, “मोरो बाप अबा लक काम करा हैं, अर मी भी काम करू हैं।” एकोलाने यहूदी यीसु ख मार ड़ालन को अऊर भी मऊका ढुढ़न लग गया। ");
INSERT INTO hlb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","इ कारन यहूदी अर भी ज्यादा ओको मर डालन को प्रयास करन लगियो काहेकि वी नी सिरप एकोलाने कि उ आराम को दिन कि विधि ख टोड़ रयो हैं, बल्कि उ परमेस्वर ख अपनो बाप भी बोलत रहा। अऊर असो तरीका से अपनो तुम ख परमेस्वर को बराबर भी बतावा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","असो पर यीसु न उनसे कय्हो, “मी तुम ख सच्ची-सच्ची कहूँ हैं,” पोरिया अपनो तुम म कुछ नी कर सका, सिर्फ उ उईच कर सका हैं जो परमेस्वर ख करते देखा हैं; परमेस्वर बाप जो कुछ करा हैं पोरिया भी ऊसीच ही करा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","काहेकि परमेस्वर बाप पोरिया से प्रेम करा हैं अर जे-जे उ काम करा हैं ओखा पोरिया ख दिखावा हैं; अऊर उ इन से भी बड़ा-बड़ा काम ओ ख दिखायगो, ताकि तुम हैरानी करे। ");
INSERT INTO hlb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","जसो परमेस्वर बाप मरिया वाला ख उठावा अर जिन्दो करा हैं, वसो ही पोरिया भी जिनका चाहवा हैं उनका जिन्दो करा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","बाप कोई को न्याय नी करा, पर न्याय करन को पुरो हक पोरिया ख सोप दियो हैं, ");
INSERT INTO hlb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","कि सब इंसान जसो पिता परमेस्वर को सम्मान करा हैं वसो ही पोरिया कि भी इज्जत करे। जो पोरिया की इज्जत नी करा, उ बाप ख जोना यीसु ख भेजो हैं, सम्मान नी करा। ");
INSERT INTO hlb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","मी तुम से सच्ची-सच्ची कहूँ हैं, जो मोरो वचन सुन कर मोरो भेजियो वालो पर भरोसा करा हैं, अनन्त जीवन ओको ही हैं; अर ओपर दण्ड या न्याय कि सजा नी होन कि पर उ माऊत से पार होका जीवन म पहुँचा चुकियो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“मी तुम से सच्ची-सच्ची कहूँ हैं,” कि उ बखत आन वालो हैं, पर आ ही गयो हैं, जोमन मरिया वाला परमेस्वर को पोरिया कि आवाज सुनेगो, अर जे सुनेगो वी जिन्दगी पायगो। ");
INSERT INTO hlb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","काहेकि जो तरीका से बाप अपनो तुम म जीवन रखा हैं, उईच तरीका से ओ ना पोरिया ख भी अधिकार दियो हैं कि अपनो तुम म जीवन रखे; ");
INSERT INTO hlb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","वरन ओखा न्याय करन को भी हक दियो हैं, एकोलाने लाने कि उ इंसान को पोरिया आय। ");
INSERT INTO hlb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ये से हईब मत होव; काहेकि उ बखत आवा हैं कि जित्ता मरघट म हैं वी ओकी आवाज सुन ख निकल आएँगो। ");
INSERT INTO hlb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","जिन्ना भलाई करी हैं वी उ जीवन को लाने फिर से जनम को लाने जिन्दो उठनो अर जिन्ना बुराई करी हैं वी दण्ड न्याय कि सजा झेलन को लाने जिन्दो उठेगो। ");
INSERT INTO hlb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“मी अपनो तुम से कुछ नी कर सकू; जसो सुनु हैं, ओकोईच हिसाब से न्याय करू हैं; अर मोरो निर्णय, न्याय को हिसाब से ही होवा हैं, काहेकि मी अपनी मरजी से नी पर जेना मोखा भेज्यो हैं ओकी मरजी पुरी करन की सोचू हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","अदि मी अपनी गवाई खुद देहु हैं ते मोरी गवाही कि कोई सच्ची नी हाय। ");
INSERT INTO hlb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","एक अऊर हैं जो मोरी गवाई देवा हैं, अर मी जानु हैं कि मोरी जो गवाई उ देवा हैं, वा सच्ची हैं। ");
INSERT INTO hlb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","तुम अदमी हुन न यूहन्ना से पुछवायो अर ओ न सच्ची कि गवाई दियो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","पर मी अपनो बारे म इंसान हुन कि गवाई नी चाहूँ; तेभी मी या बात ऐखा लाने कहू हैं कि तुम ख उध्दार मिले। ");
INSERT INTO hlb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","यूहन्ना तो जलतो अर चमकतो जसो दिया हतो। अर तुम ख थोड़ी देर लक ओको उजेला म मगन होनो अच्छो लग्यो। ");
INSERT INTO hlb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","पर मोरो जोने जो गवाई हैं वा यूहन्ना कि गवाई से बड़ी हैं; काहेकि जो काम पिता न मोखा पुरो करन को सोपियो हैं एकोमतलब यू काम जो मी करू हैं। वी मोरा गवाह हैं कि परमेस्वर बाप न मोखा भेजो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","अर बाप जोना मोखा भेजो हैं, उईच न मोरी गवाई दियो हैं। तुमना न कभी ओकी आवाज सुनियो, अर न ओको मुंडो देखो हैं; ");
INSERT INTO hlb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","अर उ वचन ख मन म धर ख नी रखा, काहेकि जोना ओखा भेज्यो तुम ओपर भरोसा नी करा। ");
INSERT INTO hlb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","तुम सुध्द सास्र म ढुँढ़ा हैं, काहेकि समझा हैं कि उनमा अनन्त जीवन तुम ख मिला हैं; अर यू उई आय जो मोरी गवाई देवा हैं; ");
INSERT INTO hlb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","फिर भी जीवन पान ख लाने मोरा कने आनो नी चाहवा। ");
INSERT INTO hlb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","मी इंसान हुन से इज्जत नी चाहूँ। ");
INSERT INTO hlb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","पर मी तुमका जानु हैं कि तुम म परमेस्वर को प्रेम नी हाय। ");
INSERT INTO hlb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","मी अपनो बाप परमेस्वर को नाम से आयो हैं, अर तुम न मोखा नी पहिचानियो; अदि कोई अपनो ही नाम से आहे, ते ओ ख पहिचान लेहे। ");
INSERT INTO hlb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","तुम जो एक दुसरा से इज्जत चाहवा हैं अर उ सम्मान जो एक मातर परमेस्वर की तरफ से हैं? नी चाहवा कसो तरीका से भरोसा कर सका हैं? ");
INSERT INTO hlb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","असो मत समझो कि मी बाप को सामे तुम पर अरोप लगाऊ; तुम पर अरोप लगान वालो तो मूसा हैं, जोपर तुमना भरोसा रखो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","काहेकि तुम मूसा को भरोसा करता, ते मोरो भी भरोसा करता, ऐका लाने कि ओ ना मोरो बारे म लिखो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","पर अदि तुम ओकी लेख बात हुन पर भरोसा नी करा, ते मोरी बात हुन को कसो भरोसा करे? ");
INSERT INTO hlb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","असी बात हुन को बाद यीसु गलील कि झील एकोमतलब तिबिरियास कि झील को पार गयो। ");
INSERT INTO hlb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","अर एक बड़ी भीड़ उनको पिछु चलन लग गई काहेकि इंसानहुन न वी अदभुत निसान ख देख्या रहा, जो यीसु न बिमारहुन पर दिखायो रहा। ");
INSERT INTO hlb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","यीसु पहाड़ पर चढ़ियो अऊर अपनो चेलाहुन को संग बठ गयो। ");
INSERT INTO hlb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","यहूदी हुन को फसह को तिहार नजीक म हतो। ");
INSERT INTO hlb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","जब यीसु न अपनी आँख उठा ख एक बड़ी भीड़ ख अपनो पास आते देखो, ते उनना फिलिप्पुस से कय्हो, “हम इनका खालान को लाने कहाँ से रोटी मोल लेका आहे?” ");
INSERT INTO hlb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","उनना फिलिप्पुस ख परखन को लाने असो बोलयो, काहेकि उ तो जानत ही रह कि उ का करेगों। ");
INSERT INTO hlb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिलिप्पुस न ओखा जवाब दियो, “दो सव चाँदी ख सिक्का से भी इत्ती रोटी नी मोल ले सका हैं जेमन से हर एक इंसान ख एक कऊर से थोडो भी जादा मिल सके।” ");
INSERT INTO hlb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ओखा चेला म से समोन पतरस को भई अन्द्रियास न ओसे कय्हो, ");
INSERT INTO hlb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“यहाँ एक छोटो पोरिया हैं को जोने पाँच रोटी अर दो मच्छी हैं; पर इत्ता झन को लाने वी का होए?” ");
INSERT INTO hlb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","यीसु न कय्हो, “सब इंसान हुन ख बैठाल देव।” वा जगा म ढ़ेर सारी घास हती: तब इंसान जिनमा अदमी हुन कि गिनती लगभग पाँच हजार कि हती, बैठ गया। ");
INSERT INTO hlb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","तब यीसु न रोटी हुन लियो, अर परमेस्वर ख धन्यवाद कर ख बठन वाला इंसान हुन म बाट दियो; अर वसो ही तरीका से मच्छी हुन भी, जित्ती उनका लगत रहा बाँट दियो। ");
INSERT INTO hlb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","जब सब इंसान हुन न खा का पेट भर लियो, ते यीसु न अपना चेला हुन ख कय्हो, “बचियो वाला टुकड़ा इक्टठा कर लेव कि कुछ फेक नी जाय।” ");
INSERT INTO hlb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","एकोलाने चेला हुन न उनका बिन लियो, अऊर वी टुकड़ा से बारा टोकनी हुन भर ली, जो इंसान हुन को खान को बाद जुवार की पाँच रोटी हुन से बच गया रहा। ");
INSERT INTO hlb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","तब जो हईब ख चिन्ह यीसु न कर दिखायो ओखा वी इंसान हुन देख ख कहन लग्या, “उ भविस्यवक्ता जो दुनिया म आन वालो हतो रह सच्ची म यूईच आय।” ");
INSERT INTO hlb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","जब यीसु न असो देखियो कि इंसान हुन आ ख ओखा राजा बनान को लाने पकड़नो चाहवा हैं, ते उ अकेलो ही पहाड़ पर फिर चल दियो। ");
INSERT INTO hlb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","जब साम भई, ते ओखा चेला हुन झील को किनार गया, ");
INSERT INTO hlb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","अऊर वी नाव पर बठ ख कफरनहूम सहर कि तरफ झील पार करत रहा। अन्धेरा होन लग गयो रहा अऊर यीसु अबा लक उनको जोने नी पहुँचियो हतो। ");
INSERT INTO hlb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","हवा को मारे झील म लहर उठन लगी। ");
INSERT INTO hlb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","जब वी चलाते-चलाते तीन-चार कोस को करीब निकल गया, ते उन न यीसु ख झील पर चलते अर नाव कि तरफ आते देखो, अर डर गया ");
INSERT INTO hlb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","पर यीसु न उनसे कय्हो, “मी आय; डरो मत।” ");
INSERT INTO hlb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","एकोबाद; वी ओखा नाव पर चढ़ान वाला ही हता कि नाव तुरत ही वा जगह म जा ख पहुँची जहाँ पर वी जात रह हता। ");
INSERT INTO hlb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","जो इंसान झील को वा पार रह गया रहा, उनना दुसरो दिन देख्यो कि वहाँ सिर्फ एक ही नाव हती अर वा भीड़ न जो झील को किनारा म खड़ी हती, असो देखो कि यहाँ एक ख छोड़ अऊर कोई नाव नी हती; अर यीसु अपना चेला हुन को संग उ नाव पर नी चढ़ो हतो, पर ओखा चेला ही गया हता। ");
INSERT INTO hlb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","तब जा ख दुसरी नाव हुन तिबिरियास से वा जगा को नजीक म आई, जेमा उनना प्रभु को धन्यवाद करन को बाद रोटी खाई हती। ");
INSERT INTO hlb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ऐको लाने जब ओ ना देखो कि येमा न यीसु हैं अऊर न ओ ख चेला हुन, ते वी भी नाव हुन म चढ़ ख यीसु ख ढ़ुढ़ते कफरनहूम पहुँचिया। ");
INSERT INTO hlb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","झील को ओ नो पार जब वी ओसे मिलियो ते कय्हो, “अरे गुरू, तू यहाँ कब आयो?” ");
INSERT INTO hlb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","यीसु न उनका उत्तर दियो, “मी तुम से सच्ची-सच्ची कहूँ हैं, तुम मोखा एकोलाने लाने नी ढूँढ़ा हैं कि तुम न निसान देख्यो, पर ऐको लाने की तुम न रोटी खाकर पेट भरीयो रह। ");
INSERT INTO hlb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","नास होन वालो खाना को लाने मेहनत मत करो, पर उ खाना को लाने जो अमर (अनन्त) जीवन तक ठहरो रहवा हैं, जोका इंसान को पोरिया तुम ख देहे; काहेकि बाप ऐकोमतलब परमेस्वर न ओपर मोहर लगायो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","इंसान हुन न ओसे पुछयो, “परमेस्वर को काम करन को लाने हम का करे?” ");
INSERT INTO hlb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","यीसु न उनका जुवाब दियो, “परमेस्वर को काम यू हैं कि तुम ओपर, जोका ओ न भेज्यो हैं, भरोसा करो।” ");
INSERT INTO hlb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","तब इंसान हुन न ओसे कय्हो, “फिर तू कोन सो चिन्ह दिखा सका हैं, कि हम ओखा देख ख तोरो ऊपर भरोसा करे? तू कोन सो काम दिखा सका हैं? ");
INSERT INTO hlb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","हमरा बाप दादा हुन न रेगिस्तान को जंगल म मन्ना खायो; जसो कि सुध्द ग्रंथ म लिखो हैं, ओ ना उनका खान ख लाने, स्वर्ग से रोटी दीयो।” ");
INSERT INTO hlb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","येपर यीसु न उनसे बोलयो, “मी तुमका सच्ची-सच्ची बताऊँ हैं उ मूसा नी आय जेना तुमका खान को लाने स्वर्ग म से रोटी दियो रहा बल्कि यू मोरो परमेस्वर बाप आय जो तुमका स्वर्ग से सच्ची रोटी देवा हैं ");
INSERT INTO hlb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","वा रोटी जेका परमेस्वर बाप देवा हैं वा स्वर्ग से उतरी हैं अऊर संसार ख जीवन देवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","इंसान हुन न यीसु से कय्हो, “अरे प्रभु, अब हमका वा रोटी दे अऊर हमेसा देते रैजो।” ");
INSERT INTO hlb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","तब यीसु न उनसे बोल्यो, जीवन की रोटी मी आय।, जो जिन्दगी देवा हैं। जो मोरो जोने आवा हैं उ कभी भूको नी रहन को, अर जो मोपर भरोसा करा हैं उ कभी भी प्यासो नी रहन को। ");
INSERT INTO hlb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","मी न तुमका पहले ही कैय दियो हैं कि तुमना मोखा देख लियो हैं, फिर भी तुम मोरो ऊपर भरोसा नी करा। हर एक उ इंसान जेका परमेस्वर बाप न मोखा सोपियो हैं, मोरो जोने आयेगो। ");
INSERT INTO hlb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","जो कुछ परमेस्वर बाप मोखा देवा हैं उ सब मोरो जोने आहेगो, अऊर जो कोई मोरो जोने आएँगो ओखा मी कभी नी निकालन को। ");
INSERT INTO hlb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","काहेकि मी अपनी मर्जी से नी, पर अपनो भेजन वालो कि मर्जी पुरी करन को लाने स्वर्ग म से उतरियो हैं; ");
INSERT INTO hlb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","अर मोरो भेजन वालो कि मर्जी या हैं कि जो कुछ ओ ना मोखा दियो हैं, ओमन से मी कुछ नी खुवान को पर ओखा आखरी दिन फिर से जिन्दो करूँ। ");
INSERT INTO hlb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","काहेकि मोरो बाप कि मर्जी या हैं कि जो कोई पोरिया ख देखे अर ओपर भरोसा करे, उ अनन्त जीवन पाहे अर मी ओखा आखरी दिन फिर से जिन्दो करुँगो। ");
INSERT INTO hlb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","एकोलाने लाने यहूदी हुन न यीसु पर बड़बड़ानो सुरू करयो, काहेकि उ कहत रहा, “वा रोटी मी आय जो स्वर्ग से उतरी आय।” ");
INSERT INTO hlb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","अऊर उनना कही, “काहे यु यूसुफ को पोरिया यीसु नी हाय, जेका माय बाप ख हम जाना हैं? ते उ कसो बोला हैं कि मी स्वर्ग से उतरियो हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","यीसु न उनका जवाब दियो, “एक दुसरा पर मत बड़बड़ाव ");
INSERT INTO hlb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","कोइ मोरा कने नी आ सका जब लक बाप, जोना मोखा भेज्यो हैं, ओखा खिच नी ले; अऊर मी ओखा आखरी दिन फिर जिन्दो करूँगो। ");
INSERT INTO hlb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","भविस्यवक्ता हुन कि किताब म यु लिखो हैं: ‘वी सब परमेस्वर कि तरफ से सिखाया वाला होए।’ जे कोइ न बाप से सुनो अऊर सिखो हैं, उ मोरो कने आवा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","असो नी हाय कि कोइ न बाप ख देख्यो हैं; पर जे परमेस्वर कि ओर से हैं, सिर्फ उईच न बाप ख देख्यो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","मी तुम ख सच्ची-सच्ची कहूँ हैं कि जे कोइ भरोसा करा हैं, अनन्त काल को जीवन ओको ही हैं। ");
INSERT INTO hlb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","जीवन की रोटी मी आय। ");
INSERT INTO hlb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","तुम्हारो बापदादा न जंगल म मन्ना खायो अऊर फिर भी वी मर गया। ");
INSERT INTO hlb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","या वा रोटी आय जो स्वर्ग से उतरी हैं ताकि इंसान ओमन से खाय अर नी मरन का। ");
INSERT INTO hlb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","जीवन कि रोटी जे स्वर्ग से उतरी, मी आय। अदि कोई या रोटी म से खाए, ते हमेसा को लाने जिन्दो रहेगो; अर जे रोटी मी दुनिया को जीवन को लाने देऊगो, उ मोरो मांस या सरीर हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","येपर यहूदी असो कैय ख एक दुसरा म ऊर्झन लग गया, “यू इंसान कसो हमका अपनो सरीर या मांस खान ख दे सका हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","यीसु न उनका कय्हो, “मी तुम ख सच्ची-सच्ची कहूँ हैं कि जब लक तुम इंसान को पोरिया को मांस नी खायगो; अर ओको खून नी पीवन का। तुम्हारो सरीर म जीवन नी। ");
INSERT INTO hlb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","जो मोरो मांस खावा अर मोरो खून पीवा हैं, अनन्त काल को जीवन ओको ही हैं; अऊर मी ओखा आखरी दिन फिर से जिन्दो करुँगो। ");
INSERT INTO hlb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","काहेकि मोरो मांस सही म खान कि चीज हैं, अऊर मोरो खून सही म पीवन की चीज हैं। ");
INSERT INTO hlb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","जे मोरो मांस खावा हैं अऊर मोरो खून पीवा हैं उ मोरो म जड़ पकड़ ख बनो रहवा हैं, अर मी ओमा। ");
INSERT INTO hlb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","जसो जिन्दो परमेस्वर बाप न मोखा भेज्यो, अर मी परमेस्वर बाप को कारन जिन्दो हैं, वसो ही उ भी जो मोखा खाएगो मोरो कारन उ जिन्दो रहेगो। ");
INSERT INTO hlb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","जो रोटी स्वर्ग म से उतरी ययीच आय, वा रोटी को जसो नी जेका बापदादा न खायो अर मर गयो; जे कोइ या रोटी खाएगो, उ हमेसा अमर जीवन तक जिन्दो रहेगो।” ");
INSERT INTO hlb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","या बात ओ ना कफरनहूम को एक प्रार्थना घर म परचार करते बखत कही रहा। ");
INSERT INTO hlb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ओखा चेला हुन म से ढ़ेर सारा न असो सुन ख बोल्यो, “या बेजा बड़ी बात हैं; येका कोन सुन सका हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","यीसु न अपनो मन म असो जान्यो कि मोरा चेला एक दुसरो पर या बात पर बड़बड़ावा रया हैं, ते उनना उनसे पुछयो, “का तुम या बात से परेसान हैं? ");
INSERT INTO hlb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","अदि तुम इंसान को पोरिया ख जहाँ उ पहले हतो, वहाँ ऊपर जाते देखेगो; ते का होयगो? ");
INSERT INTO hlb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","आत्मा ही हैं जो जीवन देवा हैं, सरीर से कुछ फायदा नी हाय; जो बात मी न तुम से कही हैं वी आत्मा हैं, अर जिन्दगी भी हैं। ");
INSERT INTO hlb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","फिर भी तुम म से कुछ असा हैं जो मोपर भरोसा नी करा।” काहेकि यीसु पहले से ही असो जानत रह कि कोन मोपर भरोसा नी करा अऊर कोन मोखा पकडवायगो। ");
INSERT INTO hlb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","अर ओ ना कय्हो, “एको लाने मी न तुम से कय्हो रहा कि जब लक कोइ ख परमेस्वर बाप कि तरफ से यू वरदान नी दियो जाय तब लक उ मोरो कने नी आ सका।” ");
INSERT INTO hlb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","येपर ओखा चेला म से ढ़ेर सारा उल्टा फिर गया अऊर ओको बाद ओको संग नी चल्या। ");
INSERT INTO hlb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","एकोबाद यीसु न वी बारा हुन से बोल्यो, “काहे तुम भी चल देनो चाहवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","समोन पतरस न ओखा जवाब दियो, “अरे प्रभु हम कोन को जोने जाए? अनन्त जीवन कि बात हुन तो तोरो ही जोने हैं। ");
INSERT INTO hlb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","अऊर हम न भरोसा करयो अऊर जान गया हैं कि परमेस्वर को सुध्द जन तुइच ही आय।” ");
INSERT INTO hlb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","यीसु न उनका जुवाब दियो, “काहे मी न तुम बारा ख नी चुनियो? ते भी तुम म से एक जन सैतान हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","असो ओ न समोन इस्करियोती को पोरिया यहूदा को बारे म कय्हो रहा, काहेकि उई जे बारा हुन म से एक थो, ओ ख पकड़वान ख हतो। ");
INSERT INTO hlb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","असी बात हुन को बाद यीसु गलील परदेस ख घुमन गयो; काहेकि उ यहूदिया परदेस ख नी जानो चाहत रहा, काहेकि वहाँ ख यहूदी गुरू हुन ओखा मार ड़ालन कि सोचत रहा। ");
INSERT INTO hlb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","यहूदी हुन को झोपड़ी को तिहार नजीक म हतो। ");
INSERT INTO hlb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","एका लाने यीसु ख भई हुन न ओसे कय्हो, या जगा ख छोड़ दा अऊर यहूदिया ख जा, ताकि तोरो पिच्छु चलन वाला वी चिन्न हुन ख देखे जे तू करन वालो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","इंसान असो नी लूकावा कि वी कोन सो काम कर रया हैं। जब से तू यू काम कर रयो हैं, पुरी दुनिया ख तोरो बारे म बता। ");
INSERT INTO hlb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","काहेकि यीसु ख भई भी ओपर भरोसा नी करत रह। ");
INSERT INTO hlb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","तब यीसु न उनसे कय्हो, “मोरो लाने सही बखत अबा लक नी आयो हैं। पर तुम्हारो लाने कोई भी बखत सही हैं। ");
INSERT INTO hlb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","दुनिया तुम से घुस्सा नी कर सका, पर उ मोसे घुस्सा करा हैं काहेकि मी ओको बारे म या गवाई देऊ हैं कि ओखा काम बुरा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","तुम तिहार म जाव; मी अभी यू तिहार म नी जाऊ हैं, काहेकि अबा लक मोरो बखत सही बखत पूरो नी आयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","असो बोल ख यीसु गलील परदेस म ही रैय गयो। ");
INSERT INTO hlb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","पर जब ओखा भई हुन तिहार म चला गया ते उ खुद भी, हालाकी, उ उजागर तो नी पर लुकते-छुपते असो ही चलो गयो रहा। ");
INSERT INTO hlb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","तिहार म यहूदी गुरू हुन यीसु का ढुँढ़त रहा हता। “उ किते हैं?” उनना पुछयो। ");
INSERT INTO hlb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","भीड़ म यीसु को बारे म खुब चाली-चुगली होवत रहा। “उ एक अच्छो अदमी हैं, कुछ इंसान हुन न बोल्यो। नी, दुसरा न बोल्यो, उ इंसान हुन ख बेकुप बनावा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","लेकिन कोई न भी यीसु को बारे म खुल ख बात नी करी काहेकि वी यहूदी अधिकारी हुन से डरत हता। ");
INSERT INTO hlb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","जब यीसु प्रार्थना मन्दिर म गयो अऊर सिक्छा सिखानो सुरू करयो ते यू तिहार करीब आधो खतम हो गयो। ");
INSERT INTO hlb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","यहूदी गुरू हुन बड़ी सोच म पढ़ गया अऊर उनना कय्हो, “यू इंसान कसो जाना हैं जब उ कभी स्कूल नी गयो?” ");
INSERT INTO hlb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","यीसु न जवाब दियो, जो मी सिखऊँ हैं उ मोरो खुद को ग्यान नी हाय, बल्कि यू परमेस्वर कि तरफ से आय, जेना मोखा भेज्यो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","जे कोइ भी असो करन ख तैयार हैं जो परमेस्वर चाहवा हैं ओखा पता चल जाहे कि मी जो सिखऊँ हैं उ परमेस्वर से आवा हैं या नी या मी खुद अपनो अधिकार पा बोलू हैं। ");
INSERT INTO hlb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","जो इंसान अपनो हक पर बोला हैं, वी अपनो लाने बड़ाई हासिल करन की सोच रया हैं। लेकिन उ जो ओको लाने बड़ाई चाहवा हैं जेना ओखा भेज्यो हैं उ सच्चो हैं, अऊर येमा कई भी अधर्म नी हाय। ");
INSERT INTO hlb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","मूसा न तुम ख नेम दियो, का ओ ना नी दियो? तेभी तुम म से कोई नियम को पालन नी करत आय। तुम मोखा मारन की कोसिस काहे कर रया हैं? ");
INSERT INTO hlb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","इंसान हुन न जवाब दियो, “तोरो म भूत की आत्मा हैं! कोन तोखा मार ड़ालनो चाहवा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","यीसु न उनका जवाब दियो, “मी न एक काम करयो, अर तुम सब सोच म पढ़ गया हैं। ");
INSERT INTO hlb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","एको लाने मूसा न तुमका खतना कारान को नियम दियो (असो नी कि उ मूसा कि तरफ से हैं पर बाप दादा से चलते आयो हैं), अर तुम आराम को दिन इंसान को खतना करावा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","जब हफ्ता को दिन कोइ पोरिया को खतना करो जावा हैं ताकि मूसा को नेम को कानुन नी टूटे, ते तुम मोसे काहेको लाने घुस्सा करा हैं काहेकि मीना एक इंसान ख आराम करन को दिन पूरी तरीका से अच्छो करियो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","मुंडो देख ख न्याय मत करो, पर सच्ची-सच्ची न्याय करो।” ");
INSERT INTO hlb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","तब कुछ यरूसलेम का रहन वाला इंसान हुन न बोल्यो, “का यु उयीच इंसान नी आय जेका यहूदी गुरू हुन मार ड़ालन को लाने कोसिस कर रया हैं? ");
INSERT INTO hlb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","पर देखो, उ तो खुल्लम खुल्लो बात हुन कर रयो हैं, अऊर कोई ओको खिलाप कुछ नी बोलत आय। का मुखिया हुन न सचमुच म जान लियो हैं कि उ मसी आय? ");
INSERT INTO hlb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","लेकिन जब मसी आहे ते कोई ख पता नी चलन को की उ कहाँ को हैं। अऊर हम सब जाना हैं कि यू इंसान किते से आवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","जसो कि यीसु न मन्दिर म सिखायो, ओ ना बड़ी जोर कि आवाज से बोल्यो का “तुम सही म मोखा जाना हैं कि मी कहाँ को आय? मी खुद की मर्जी से नी आयो हैं। पर जेना मोखा भेज्यो हैं, उ सच्चो हैं तुम ओखा नी जानत आय, ");
INSERT INTO hlb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","पर मी ओखा जानु हैं, काहेकि मी ओकी तरफ से आयो हैं अऊर उयीच न मोखा भेज्यो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","येपर उनना ओखा पकड़न की कोसिस करी, तेभी कोई न ओपर हात नी ड़ाल्यो काहेकि ओको बखत अबा लक नी आयो रहा ");
INSERT INTO hlb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","फिर भी भीड़ म से ढ़ेर सारा न ओपर भरोसा करियो अऊर कहन लग गया, “जब मसी आहे, ते का उ यू इंसान से बड़ ख चिन्ह करे?” ");
INSERT INTO hlb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","फरीसी हुन न भीड़ ख यीसु को बारे म असी बात हुन ख कहते हुए सुन्यो, एकोलाने उनना अऊर मुखिया पुजारी हुन न ओखा पकड़न को लाने कुछ सिपाई भेज्या। ");
INSERT INTO hlb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","येपर यीसु न कय्हो, “मी थोड़ी देर अऊर तुमरो संग म रहूंगो, अऊर फिर मी ओको जोने चलो जाहूँ जेना मोखा भेज्यो रहा। ");
INSERT INTO hlb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","तुम मोखा ढुढ़ेगो, पर मोखा नी ढुढ़ सकन का; काहेकि तुम वहाँ नी जा सका जिते मी रहूंगो।” ");
INSERT INTO hlb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","येपर यहूदी गुरू हुन न आपस म बोल्यो, “यू किते जान वालो हैं जोकी हम ओखा नी देखन का? का उ वी यूनानी सहर हुन म जाएगो जिते हमारा इंसान हुन रहवा हैं, अऊर यूनानी हुन ख सिखावा हैं? ");
INSERT INTO hlb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","उ कहा हैं कि तुम मोखा ढुढ़ेगो, पर मोखा नी ढुढ़ सकन का, अऊर तुम वहाँ नी जा सका जिते उ होऐ एको का मतलब हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","तिहार ख आखरी अऊर सबसे खास दिन यीसु न खड़ो होका बड़ी जोर कि आवाज म बोल्यो, जे कोई भी प्यासो हैं उ मोरो जोने आय, अऊर ");
INSERT INTO hlb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","जे कोई मोपर भरोसा करा हैं ओखा पीनो चाहिए।, जसो कि सुध्द सास्र कहाँ हैं, जिन्दगी देन वाली पानी की धार हुन ओकी तरफ से बहिन लग जाहे। ");
INSERT INTO hlb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","यीसु न यू आत्मा को बारे म बोल्यो रहा, जे इंसान हुन ओपर भरोसा करत रहा उनका मिलन वाली हती। उ बखत लक आत्मा उनखा नी दियो गयो रहा, काहेकि यीसु ख महिमा म नी उठायो गयो रहा। ");
INSERT INTO hlb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","फिर भीड़ म से कोइ-कोइ इंसान हुन न ओखा असो कहते हुए सुनायो अऊर बोल्यो, “यू इंसान सचमुच म भविस्यवक्ता आय।” ");
INSERT INTO hlb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","दुसरा न कय्हो, “यू मसी आय।” पर कोइ न कय्हो, “मसी गलील से नी आन को! ");
INSERT INTO hlb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","सुध्द सास्र कहाँ हैं कि मसी राजा दाऊद को गोत से होयगो अऊर बैतलहम सहर म पैदा होयगो, जेमा दाऊद रहत रह?” ");
INSERT INTO hlb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","एकोलाने यीसु की वजे से भीड़ म फुट-फैल पड़ गई रहा। ");
INSERT INTO hlb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","उनमा से कुछ ओखा पकड़नू चाहवत रह, पर कोई न ओखा हात नी लगायो। ");
INSERT INTO hlb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","तब सिपाई लउट ख चल दिया, ते खाँस पुजारी हुन अऊर फरीसी हुन न उनसे पुछयो, “तुम ओखा काहे नी लेका आया?” ");
INSERT INTO hlb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","सिपाई हुन न जवाब दियो, “कोइ न भी यू इंसान से कभी असी बात नी करी!” ");
INSERT INTO hlb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","का ओ ना तुमका भी घुमायो हैं? फरीसी हुन न उनसे पुछयो। ");
INSERT INTO hlb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“का तुमना कभी मुखिया हुन या कोई फरीसी ख ओपर भरोसा करते देख्यो हैं? ");
INSERT INTO hlb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","या भीड़ मूसा को नेम ख नी जाना, एकोलाने वी परमेस्वर को सराप म पढ़िया हैं!” ");
INSERT INTO hlb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","फरीसी हुन म से एक नीकुदेमुस थो, उ अदमी जो यीसु ख देखन गयो रहा। उनना दुसरो से बोल्यो, ");
INSERT INTO hlb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“हमारो नेम को हिसाब से हम इंसान हुन ख उनकी बात सुनन अऊर यू पता लगानो से पहिले ओकी बुराई नी कर सका कि ओ ना का करयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","उन न ओखा जवाब दियो; “का तू भी गलील को हैं? ढ़ूँढ़ अर देख कि गलील से कोइ भविस्यवक्ता परगट नी होन को।” ");
INSERT INTO hlb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","फिर सब कोइ अपना-अपना घर चल दिया ");
INSERT INTO hlb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","फिर प्रभु यीसु जैतून पहाड़ पा गयो। ");
INSERT INTO hlb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","सुबेरे का यीसु प्रार्थना मन्दिर म आयो; सब इंसान हुन ओको कने जुड़ गया, अर यीसु बठ ख उनका सिखान लग गयो। ");
INSERT INTO hlb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","तब सासतिरी अर फरीसी एक बाई ख लाया जो छिनाला करते बखत पकड़ा गई रह, अऊर ओखा बीच म खड़ो कर ख यीसु से कही, ");
INSERT INTO hlb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“अरे प्रभु, या ओरत गलत काम करते बखत पकड़ा गई हैं। ");
INSERT INTO hlb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","नेम कि किताब म मूसा न हमका असी ओरत हुन ख पत्थर हुन से मार ड़ालन को हुकुम दियो हैं। तू या ओरत को बारे म का बोला हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","उनना न यीसु ख परखन को लाने असी बात कही, जसो उनका ओपर अरोप लगान को कोई सबूत ढुढ़े। यीसु न नीचु बठ ख उँगली से जमीन पर लिखन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","जब वी ओसे पूछत ही रया, ते ओ ना सिधो खड़ो होका उनसे पूछो “तुम म से जे सुध्द होए उई पहले ओखा पत्थर मारे।” ");
INSERT INTO hlb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","अऊर उ फिर बठ ख जमीन पा उँगली से लिखन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","पर वी यू सुन ख बड़ा से लेका छोटा लक, एक-एक कर ख निकल गया, सिरप यीसु अऊर वा ओरत, जो ओको सामने खड़ी हती रैय गई। ");
INSERT INTO hlb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","यीसु न ओकी तरफ देख ख बोल्यो, वी किते गया? का कोई न तो पर सजा नी दी? ");
INSERT INTO hlb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","कोई नी, “प्रभु, ओ ना जुवाब दियो। ठीक हैं, फिर, यीसु न बोल्यो, मी भी तोखा सजा नी देऊ, जा पर अब फिर से पाप मत करजे।” ");
INSERT INTO hlb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","यीसु न फरीसी हुन से फिर बात करी। मी “संसार को उजियारो आय, ओ ना कयो। जो कोई मोरो पिछु चलेगो, ओको जोने जीवन को उजेरो होयगो अऊर उ कभी इंधारो म नी चलन को।” ");
INSERT INTO hlb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","फरीसी हुन न ओसे कही, “तू खुद को बारे म गवाई दे रयो हैं; तोरी गवाई सच्ची नी हाय।” ");
INSERT INTO hlb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","यीसु न उनका जुवाब दियो, “तू खुदकी गवाई खुद दे हैं, तोरी गवाई सच्ची नी हाय।” ");
INSERT INTO hlb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","तुम सरीर को अनुसार न्याय करत हो मी कोई को न्याय नी करत। ");
INSERT INTO hlb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","लेकिन अगर मी असो करन लगीयो, ते मोरो न्याय सच्ची हैं; काहेकि मी ऐमन अकेलो नी हाय, मोखा भेजन वालो बाप मोरो संग म हैं। ");
INSERT INTO hlb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","तुमरी नेम की किताब म भी लिखो गयो हैं कि जब दो झन गवाई देन ख सामिल होवा हैं, ते वी जो कुछ भी बोला हैं उ सच्ची हैं; ");
INSERT INTO hlb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","एक तो मी अपनो तुम गवाई देऊ हैं, अऊर दुसरी बाप (परमेस्वर पिता) मोरी गवाई देवा हैं जोना मोखा भेजो। ");
INSERT INTO hlb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","उनना ओसे कहयो, “तोरो बाप किते हैं?” यीसु न जवाब दियो, “न तुम मोखा जाना हैं।” “न मोरो बाप का, अदि मोखा जानता ते मोरो बाप का भी जानता।” ");
INSERT INTO hlb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","यीसु न असी बात कही, जसो कि ओ ना मन्दिर म सिखायो, उ कमरा म जहाँ भण्ड़ार घर जेमा भेट रखी जावत रहा। पर कोई न ओखा नी पकडियो, काहेकि ओको बखत अबा लक नी आयो रह। ");
INSERT INTO hlb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","यीसु न फिर उनका कय्हो, “मी जाऊ हैं, अऊर तुम मोखा ढूँढ़ेगो अऊर अपनो पाप म मरेगो; जहाँ मी जाऊ, वहाँ तुम नी आ सका।” ");
INSERT INTO hlb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ये पर यहूदी हुन न कय्हो, “का उ अपनो तुम का खत्म कर देहे, जो बोला हैं, ‘जहाँ मी जाऊ हैं उते तुम नी आ सका’?” ");
INSERT INTO hlb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ओ ना उनसे कय्हो, “तुम नीचे का हैं, मी ऊपर को हैं; तुम संसार का हैं, मी दुनिया को नी। ");
INSERT INTO hlb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","एकोलाने मी न तुम से कय्हो कि तुम अपनो पाप म मरेगो, काहेकि अदि तुम भरोसा नी करन का कि मी उईच आय ते अपना पाप म मरेगो।” ");
INSERT INTO hlb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","उनना ओसे कय्हो, “तू कोन आय?” यीसु न उनसे कय्हो, “उईच आय जो सुरू से तुम से कहते आयो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","तुमरो बारे म मोखा ढ़ेर सारो कहेनो हैं, अऊर न्याय करनु हैं पर जेना मोखा भेज्यो हैं उ सच्छो हैं; अऊर जे कुछ भी मिना ओसे सुनायो हैं उसी ही दुनिया वाला ख बताऊँ हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","पर वी यू नी समझीया कि यीसु उनसे परमेस्वर बाप को बारे म बोल रयो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","एकोलाने यीसु न कय्हो, “जब तुम इंसान को पोरिया ख ऊँचो पर चढ़ायगो, ते तब यु जान जाहे कि ‘मी उईच आय’ अऊर मी अपनी ओर से कुछ नी कर सकू। पर मी जो कुछ कहूँ हैं वसो ही करूँ हैं जसो परमेस्वर बाप न मोखा सिकायो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","जेना मोखा भेज्यो हैं, उ मोरो संग म हैं ओ ना मोखा अकेलो नी छोड़यो; काहेकि मी हमेसा उई करू हैं, जो ओखा अच्छो लगा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","उ जब यू बात कहत ही रहा कि तब ढ़ेर सारा न ओपर भरोसा करियो ");
INSERT INTO hlb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","तब यीसु न वी यहूदी हुन से जिन्ना ओपर भरोसा करियो रह, कय्हो, “अदि तुम मोरो वचन म बनिया रहेगो, ते सच्ची म मोरा चेला कहलाहे। ");
INSERT INTO hlb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","तुम सच्चई का जानेगो, अऊर सत्य तुमका छुड़ा लेहे।” ");
INSERT INTO hlb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","उनना ओखा जवाब दियो, “हम तो अब्राहम कि संतान आय, हम कभी कोई का गुलाम नी रया। फिर तू कसो बोला हैं कि तुम छुट जाएगो?” ");
INSERT INTO hlb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","यीसु न उनका जवाब दियो, “मी तुम से सच्ची-सच्ची कहूँ हैं कि जे कोई पाप करा हैं वी पाप का दास हैं। ");
INSERT INTO hlb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","नउकर हमेसा घर म नी रहवा; पोरिया हमेसा रहवा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","एकोलाने अदि पोरिया तुमका छोड़ देहे, ते सच्ची म तुम छुट जाहेगो। ");
INSERT INTO hlb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","मी जानु हैं कि तुम अब्राहम कि संतान आय; फिर भी तुम मोखा मार ड़ालन की ताक म लग्या रहवा हैं, तेभी मोरी कही बात तुमरो मन म समझ नी आत आय। ");
INSERT INTO hlb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","मीना अपनो परमेस्वर बाप को यहाँ जो देख्यो हैं, उईच करूँ हैं तुम इंसान हुन न अपनो बाप से जो सुनायो हैं, उइच करा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","उनना ओखा जवाब दियो, “हमारो बाप तो अब्राहम आय।” येपर यीसु न उनसे कय्हो, “अदि तुम अब्राहम कि कुल का होता, ते अब्राहम को जसा काम करता। ");
INSERT INTO hlb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","पर तुम तो मोखा, एकोमतलब असो इंसान ख जेना परमेस्वर से सुनी वाली सच्चई तुमका बता दियो, मार ड़ालन को मऊका ढुड़ा हैं। अब्राहम न तो असो नी करियो। ");
INSERT INTO hlb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","तू तो अपनो बाप को जसो काम कर रयो हैं।” उनना यीसु से कय्हो, “हम गलत काम करनो से पैदा नी भया। हमारो एक बाप हैं अऊर उ परमेस्वर आय।” ");
INSERT INTO hlb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","यीसु न उनसे बोल्यो, “अदि परमेस्वर तुमरो बाप होतो, ते तुम मोसे प्रेम रखता; काहेकि मी परमेस्वर कि तरफ से निकलियो अऊर इते आयो हैं। मी अपनी मर्जी से नी आयो हैं, मोखा उईच न भेज्यो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","तुम मोरी बात काहे नी समझत आय? मतलब यु हैं कि तुम वचन सहन नी कर सका। ");
INSERT INTO hlb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","तुम तो अपनो बाप सैतान से आय अऊर अपनो बाप की इच्छा का पुरी करन कि सोचा हैं। उ तो सुरू से ही हत्यारो हैं उ सच्चई पर खड़ो नी रह सका, काहेकि ओमन इमानदारी तो हइच नी हाय। जब उ झुठ बोला हैं, ते अपनो स्वभाव ही से बोला हैं; काहेकि उ झूठो हैं अऊर झूठ को बाप हैं। ");
INSERT INTO hlb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","पर मी जो सच बोलू हैं, एकोलाने तुम मोरो भरोसा नी करा। ");
INSERT INTO hlb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","तुम म से कोन मोपर पाप को आरोप लगा सका हैं? अदि मी सच कहूँ हैं, ते तुम मोरो भरोसा काहे नी करा? ");
INSERT INTO hlb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","जो परमेस्वर को हैं, उ परमेस्वर को वचन सुना हैं।; तुम इंसान एकोलाने नी सुना हैं कि तुम परमेस्वर ख नी आय।” ");
INSERT INTO hlb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","असो सुन ख यहूदी अधिकारी हुन न ओसे कय्हो, “का हमरो यु कहेनो ठीक नी हाय कि तू सामरी आय, अर तोमा दुस्टात्मा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","यीसु न जवाब दियो, “मोरो म दुस्टात्मा नी हाय। मी अपनो बाप कि इज्जत करू हैं, पर तुम मोरी बेज्जती करा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","पर मी अपनी इज्जत नी चाहत आय; पर हाँ, एक हैं जो चाहवा हैं अऊर उईच न्याय करा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","मी तुम से सच्ची-सच्ची कहूँ हैं: अदि कोइ मोरो वचन को पालन करे, ते उ अनन्त काल को जीवन तक मोत का नी देखन-को।” ");
INSERT INTO hlb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","यहूदी धरम गुरू हुन न ओसे कय्हो, “अब हमना पक्को समझ लियो कि तोरो आँग म भूत हैं। अब्राहम, अऊर भविस्यवक्ता भी मर गया हैं; पर तू बोला हैं, ‘अदि कोई मोरो वचन पर चले, ते उ कभी माऊत को स्वाद नी चखन को।’ ");
INSERT INTO hlb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","का तू हमारो बाप दादा अब्राहम से भी बड़ ख हैं? उ मर गयो। अऊर भविस्यवक्ता भी मर गया। तू अपनो तुमरो का समझा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","यीसु न जवाब दियो, “अदि मी अपनो तुम ख बड़ो बनाऊँ, ते मोरो बड़ो बननो कुछ काम को नी हाय; पर मोरी बड़ाई करन वालो मोरो बाप परमेस्वर हैं, जेका तुम बोला हैं कि उ तुमारो परमेस्वर आय ");
INSERT INTO hlb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","तुम न तो ओखा नी जानो; पर मी न ओखा जानियो हैं। अदि मी ओखा बोलू हैं कि मी ओखा नी जानू, ते मी तुमारो जसो झूठो ठहरूँ; पर मी ओखा जानू अऊर ओको वचन पर चलू हैं। ");
INSERT INTO hlb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","तुमरो बाप दादा अब्राहम यू जान ख खुस भयो कि उ मोरो दिन देखेगो अऊर उ ओखा देख ख मगन हो गयो।” ");
INSERT INTO hlb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","यहूदी धरम ख गुरू हुन न यीसु से कय्हो, “अबा लक तू पचास साल को नी भयो, फिर भी तुना अब्राहम का देखो हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","यीसु न उनसे कय्हो, “मी तुम से सच्ची-सच्ची कहूँ हैं कि एको पहलो की अब्राहम उत्पन्न भयो, मी हतो।” ");
INSERT INTO hlb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","येरप इंसानहुन न यीसु ख मारन को लाने पत्थर उठायो, पर यीसु लुक का मन्दिर से निकल गयो। ");
INSERT INTO hlb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","जाती बखत यीसु न एक इंसान ख देखो जो जनम से अंधो हतो। ");
INSERT INTO hlb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ओखा चेला न ओसे पूछो, “अरे गुरू, कोना पाप करियो रह कि यू अंधो पैदा भयो, यू अदमी न या ऐका माय-बाप न?” ");
INSERT INTO hlb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","यीसु न जवाब दियो, “न ते येना पाप करियो रह, न ऐका माय-बाप न; पर यू एकोलाने जनम से अंधो भयो रह कि परमेस्वर को काम ऐमन दिखे। ");
INSERT INTO hlb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","जोना मोखा भेजो हैं, हमका ओको काम दिन ही दिन म करनो जरूरी हैं; वा रात आन वाली हैं जेमा कोई काम नी कर सका। ");
INSERT INTO hlb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","जब लक मी दुनिया म हैं, तब लक मी दुनिया कि ज्योति आय।” ");
INSERT INTO hlb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","असो बोल का यीसु न जमीन पर थूको, अऊर उ थूक से माटी सानी, अऊर वा माटी उ अंधा की आँखी हुन पा लगाया ख। ");
INSERT INTO hlb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ओसे बोल्यो, “जा, सीलोह को कुण्ड, म धोला” पत्थर को कुण्ड को मतलब “भेजियो वालो हैं।” ओ ना जा ख धोयो, अऊर देखते हुए लउट आयो। ");
INSERT INTO hlb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","तब पड़ोसी अऊर जिन्ना पहले ओखा भीख माँगते देखो रह, बोलन लग्या, “का यु उईच नी आय, जो बठ ख भीख माँगत रह?” ");
INSERT INTO hlb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","कुछ अदमी हुन न कय्हो, “हाँ यू उईच आय,” दुसरा न बोलयो, “नी, पर ओको जसो कोई अऊर हैं।” ओ ना कय्हो, “मी उईच आय।” ");
INSERT INTO hlb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","तब वी ओसे पुछन लग गया, “तोरी आँखी कसी खुल गई?” ");
INSERT INTO hlb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ओ ना जवाब दियो, “यीसु नाम को एक अदमी न मिठ्टी सानी, अऊर मोरी आँखी पर लगाया ख मोसे कय्हो ‘सीलोह को जोने जा ख धोला,’ अऊर मी गयो अर धोयो अऊर देखन लग गयो।” ");
INSERT INTO hlb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","उनना ओसे पुछो, “उ किते हैं?” “ओ ना कय्हो?” “मी नी जानु।” ");
INSERT INTO hlb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","अदमी ओखा जो पहले अंधो हतो, फरीसी हुन को जोने ले गया। ");
INSERT INTO hlb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","जो दिन यीसु न मिठ्टी सान ख ओकी आँखी खोलो रहा, उ इतवार को या आराम को दिन हतो। ");
INSERT INTO hlb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","फिर फरीसी हुन न भी ओसे पूछो कि ओकी आँखी कसो तरीका से खुल गई। ओ ना उनसे कय्हो, “ओ ना मोरो आँखी पर मिठ्टी लगायो, फिर मी न धोयो, अऊर अब देखु हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","येपर कुछ फरीसी हुन बोलन लग गया, “यू इंसान परमेस्वर कि तरफ से नी हाय, काहेकि उ आराम को दिन या हफ्ता को दिन का नी माना।” दुसरा न कय्हो, “पापी इंसान असा चिन्ह कसा दिखा सका हैं?” तब उनमा फुट पड़ गई। ");
INSERT INTO hlb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","उनना उ अंधो से फिर बोलयो, “जोना तोरी आँखी खोली हैं। तू ओको बारे म का बोला हैं?” ओ ना कय्हो, “उ भविस्यवक्ता आय।” ");
INSERT INTO hlb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","पर यहूदी हुन का भरोसा नी भयो की उ अंधा हतो अऊर अब देखा हैं, जब तक उनना ओखा, जोकी आँखी खुल गई रह, माय बाप का बुलाय ख ला। ");
INSERT INTO hlb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","उनसे नी पूछो, “का यू तुमरो पोरिया आय, जेखा बारे म तुम बोला हैं कि यू जनम से अंधो पैदा भयो रह? फिर उ अब कसो देखन लग गयो हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ओखा माय बाप न उनका जवाब दियो, “हम तो जाना हैं कि यू हमरो पोरिया आय, अऊर अंधो पैदा भयो रह; ");
INSERT INTO hlb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","पर हम यू नी जानत आय कि अब कसो देखा हैं, अऊर नी यू जानत आय कि कोना ओकी आँखी खोली। यू सियानो हैं, ओको ही से पूछ लेव; यू अपनो बारे म खुद बता देहे।” ");
INSERT INTO hlb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","या बात ओखा माय-बाप न एकोलाने बोली काहेकि वी यहूदी हुन से डरत रह, काहेकि यहूदी हुन एक सलहा का हो गया हता कि अदि कोइ बोले कि उ मसी आय, ते प्रार्थना मन्दिर म से निकाल दियो जाय। ");
INSERT INTO hlb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","एकोलाने ओखा माय बाप न बोलयो, “यू सियानो हैं, ओको से ही पूछ लेव।” ");
INSERT INTO hlb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","तब उनना उ इंसान का जो अंधा हतो, दुसरी बार बुलाय ख ओसे बोलयो, “परमेस्वर कि बिनती या इज्जत कर। हम तो जाना हैं की उ अदमी पापी हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ओ ना जवाब दियो, “मी नी जानत आय कि उ पापी आय या नी; मी एक बात जानु हैं कि मी अंधो हतो अऊर अब देखु आय।” ");
INSERT INTO hlb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","उनना ओसे फिर बोलो, “ओ ना तोरो संग का करो? अऊर ओ ना कसो तरीका से तोरी आँखी खोली?” ");
INSERT INTO hlb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ओ ना उनसे कय्हो, “मी तो तुम इंसान हुन से बोल चुक्यो, अऊर तुम न नी सुनियो; अब तुम न दुसरी बार काहे सुनन कि सोचा हैं? का तुम भी ओखा चेला बनन कि सोचा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","तब वी ओखा बुरो-भलो बोल ख बोल्यो, “तू ही ओको चेला आय, हम तो मूसा का चेला आय। ");
INSERT INTO hlb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","हम जाना हैं कि परमेस्वर न मूसा से बात करी; पर यू अदमी ख नी जाना कि कहाँ को आय।” ");
INSERT INTO hlb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ओ ना उनका जवाब दियो, “या तो गजब की बात आय कि तुम नी जाना कि उ कहाँ को आय, तेभी ओ ना मोरी आँखी खोली दी। ");
INSERT INTO hlb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","हम जाना हैं कि परमेस्वर पापी हुन कि नी सुना, पर अदि कोइ परमेस्वर को जन होए अऊर ओकी मरजी पर चलत होए, ते उ ओकी सुना हैं। ");
INSERT INTO hlb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","या दुनिया बनी जब से यू सुननो म नी आयो कि कोई न जनम को अंधा की आँखी खोली होए। ");
INSERT INTO hlb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","अदि यू इंसान परमेस्वर कि तरफ से नी होतो, ते कुछ भी नी कर सका।” ");
INSERT INTO hlb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","उनना ओसे बोल्यो, “तू तो बिलकुम पाप से पैदा भयो हैं, तू हमका का सिखावा हैं?” अऊर उनना ओखा बहार निकाल दियो। ");
INSERT INTO hlb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","यीसु न सुनो कि उनना ओखा बाहर निकाल दियो हैं, अऊर जब ओसे मुलाकात भई ते कय्हो, “का तू इंसान को पोरिया पर भरोसा करा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ओ ना जवाब दियो, “अरे प्रभु! उ कोन आय मोखा बता, कि मी ओपर भरोसा करूँ?” ");
INSERT INTO hlb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","यीसु न ओसे कय्हो, “तू न ओखा देखो भी हैं, अऊर जो तोरो संग म बात हुन करा हैं उ उईच आय।” ");
INSERT INTO hlb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ओ ना कय्हो, “अरे प्रभु, मी भरोसा करू हैं।” अर ओसे बिनती या पाय पड़ियो। ");
INSERT INTO hlb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","तब यीसु न कय्हो, “मी या दुनिया म न्याय को लाने आयो हैं, ताकि जो नी देखा वी देखे, अऊर जो देखा हैं वी अंधा हो जाय” ");
INSERT INTO hlb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","जो फरीसी ओखा संग हता उनना या बात सुन कर ओसे कय्हो, “का हम भी अंधा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","यीसु न उनसे कय्हो, “अदि तुम अंधा होता ते पापी नी ठहरता; पर अब बोला आय कि हम देखा हैं, एकोलाने तुमरो पाप बनो रहवा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“मी तुम से सच्ची-सच्ची कहूँ हैं कि जे कोई दुवार से भेड़ी हुन को कोठा म भीतर नी जावा, पर कोई दुसरी तरफ से चेंग जावा हैं, उ चोर अऊर डाकू आय। ");
INSERT INTO hlb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","पर जे दुवार से भीतर जावा हैं, उईच भेड़ी हुन का चरान वालो आय। ");
INSERT INTO hlb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ओको लाने पहरेदार फाटक खोल देवा हैं, अऊर भेड़ी हुन ओकी आवाज सुना हैं, अऊर उ अपनी भेड़ी हुन को नाम ले-ले ख बुलावा हैं अर उ बाहर ले जावा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","जब उ अपनी सब भेड़ी हुन का निकाल देवा हैं, ते उ उनको आगे-आगे चला हैं, अर भेड़ी उनको पीछे-पीछे चलते जावा हैं, काहेकि वी ओकी आवाज पहिचाना हैं। ");
INSERT INTO hlb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","पर वी पराया को पीछु नी जान कि, पर वी ओसे दुर भगन लग जाहे, काहेकि वी परायो कि आवाज नी पहिचाना।” ");
INSERT INTO hlb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","यीसु न उनसे या कायनी सुनाई, पर वी नी समझीया कि उ उनसे का बोल रयो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","एकोलाने यीसु न फिर उनसे कय्हो, मी तुम से सच्ची-सच्ची कहूँ हैं। भेड़ी हुन को दुवार मी आय। ");
INSERT INTO hlb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","जित्ता मोसे पहले आया, वी सबरा चोर अऊर डाकू आय; पर भेड़ी हुन न ओकी नी सुनी। ");
INSERT INTO hlb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","फाटक मीइच आय अदि कोई मोरो दुवार भीतर जाहे, ते उध्दार का पायगो अऊर भीतर बाहर आनो जानो करेगों अऊर चारा पाएगो। ");
INSERT INTO hlb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","चोर कुछ अऊर काम को लाने नी पर केवल चोरी करन अर नुकसान अऊर खतम करन का आवा हैं; मी एकोलाने आयो कि उनका जीवन मिले, अऊर हमेसा को मिले। ");
INSERT INTO hlb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","अच्छो चरैया मी आय। अच्छो चरैया भेड़ी हुन को लाने अपनी जान दे देवा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","मजदूरी म चरान वालो जे न चरैया आय अऊर न भेड़ी हुन को मालिक आय, लाँढिया का आते देख भेड़ी हुन ख छोड़ का भग जावा हैं; अऊर लाँढिया उनका पकड़ा अऊर तितिर-बितर कर देवा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","उ एकोलाने भग जावा हैं कि उ मजदूर आय, अर ओखा भेड़ी हुन कि चिन्ता नी। ");
INSERT INTO hlb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","अच्छो चरान वालो मालिक मी आय; मी अपनी भेड़ी हुन का जानु आय, अऊर मोरी भेड़ी हुन मोखा जाना हैं। ");
INSERT INTO hlb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","जसो परमेस्वर बाप मोखा जाना हैं अऊर मी परमेस्वर बाप का जानु आय अऊर मी भेड़ी हुन को लाने अपनी जान देऊ आय। ");
INSERT INTO hlb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","मोरी अऊर भी भेड़ी हुन हैं, जो यू भेड़ी कोठा की नी हाय। मोखा उनको भी लानो जरूरी हैं। वी मोरी आवाज सुने, तब एक ही झुंड होए अऊर एक ही चरैया होए। ");
INSERT INTO hlb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","परमेस्वर बाप मोसे एकोलाने प्रेम करा हैं कि मी अपनी जान देऊ आय कि ओखा फिर ले लेहूँ। ");
INSERT INTO hlb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","कोई मोसे मोरी जान नी ले सका, पर मी ओखा अपनो तुम ही दे देऊ आय। मोखा मोरी जान दे देन को भी अधिकार हैं अऊर फिर ओखा ले-लेन को भी हक: यू आग्या मोरो बाप परमेस्वर से मोखा मिलो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","यीसु की या बात हुन को वजे से यहूदी हुन म फिर फुट पड़ गई। ");
INSERT INTO hlb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","उनमा से बेजा सारा बोलन लग्या, “ओमा भूत हैं, अर उ पागल हैं; तुम ओकी काहेको लाने सुना हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","दुसरा इंसान हुन बोलत रहा, “यी बात हुन असो इंसान कि नी जेमा भूत होए। का भूत अंधा की आँख खोल सका हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","यरूसलेम म मन्दिर को बनायो वालो साल (स्थापना) मनायो जात हतो रह; अर ठंड को बखत हतो। ");
INSERT INTO hlb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","यीसु मन्दिर म सुलैमान को ओसरा म घुमत रह हतो। ");
INSERT INTO hlb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","तब यहूदी अधिकारी हुन न ओखा आ ख घेर लियो अर पुछियो, “तू हमारो मन का कब लक सोच म रखेगो? अदि तू मसी आय ते हम से सही-सही बोल दा।” ");
INSERT INTO hlb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","यीसु न उनका जवाब दियो, “मी न तुम ख कैय दियो पर तुम भरोसा करत ही नी आय। जो काम मी अपनो बाप परमेस्वर को नाम से करू हैं वीइच ही मोरो बारे म गवाई देवा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","पर तुम एकोलाने भरोसा नी करा काहेकि मोरी भेड़ी हुन म से नी आय। ");
INSERT INTO hlb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","मोरी भेड़ी हुन मोरी आवाज सुना हैं; मी उनका जानु आय, अर वी मोरो पिछु-पिछु चला हैं; ");
INSERT INTO hlb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","अर मी उनका हमेसा तक को अनन्त जीवन देऊ आय। वी कभी नास नी होन की, अर कोई उनका मोरो हात से छुड़ा नी सकन को ");
INSERT INTO hlb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","मोरो बाप परमेस्वर जोना उनका मोखा दियो हैं, सब से बड़ो हैं अर कोई उनका परमेस्वर को हात से छुड़ा नी सका। ");
INSERT INTO hlb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","मी अर परमेस्वर बाप एक आय।” ");
INSERT INTO hlb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","यहूदी हुन न यीसु ख मार ड़ालन को लाने फिर पत्थर उठाया। ");
INSERT INTO hlb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","येपर यीसु न उनसे कय्हो, “मी न तुमका अपनो बाप परमेस्वर कि तरफ से ढ़ेर सारा अच्छा काम दिखाया हैं; उनमा से कोन सो काम को लाने तुम मोरो ऊपर पत्थर उठा ख मार डालन को लाने होय हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यहूदी हुन न ओखा जवाब दियो, “कोई भलो काम को लाने हम तोरो ऊपर पत्थर नी उठात आय पर परमेस्वर की बदनामी करन को लाने, अऊर एकोलाने कि तू अदमी हो ख अपनो तुम ख परमेस्वर बनावा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","यीसु न उनका जवाब दियो, “का तुम्हारी नेम को किताब म नी लिखो आय, ‘मीना कय्हो, तुम परमेस्वर आय’? ");
INSERT INTO hlb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","अदि ओ ना उनका परमेस्वर कय्हो जिनको जोने सुध्द सास्र को वचन पहुँचियो (अर परमेस्वर कि बात गलत नी हो सका), ");
INSERT INTO hlb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ते जेखा परमेस्वर बाप न सुध्द ठहराय ख संसार म भेजियो हैं, ओसे तुम इंसान हुन यू कसो बोला हैं, तू परमेस्वर की निन्दा करा हैं, एकोलाने कि मी न कय्हो, ‘मी परमेस्वर को पोरिया आय’? ");
INSERT INTO hlb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","अदि मी अपनो बाप परमेस्वर को काम नी करतो, ते मोरो पर भरोसा मत करो। ");
INSERT INTO hlb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","पर अदि मी वी काम हुनका करू हैं, ते मोरो भरोसा नी भी करे, पर वी काम को तो भरोसा करो, ताकि तुम जाने अर समझे कि परमेस्वर बाप मोरो म हैं अऊर मी बाप म हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","तब उनना फिर ओखा पकडन को उपाय करयो पर उ उनको हात से निकल गयो। ");
INSERT INTO hlb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","फिर उ यरदन को ओनो पार वा जगा पर चल दियो, जेमा यूहन्ना पहले बपतिस्मा देत रहा, अर उ वही रहयो। ");
INSERT INTO hlb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","डेर सारा इंसान ओको जोने आय ख बोलत रह, “यूहन्ना न तो कोइ चिन्ह नी दिखायो, पर जे कुछ यूहन्ना न येको बारे म गवाही दियो रह, वा सब सच्ची हैं” ");
INSERT INTO hlb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","अर ओमा डेर सारा न यीसु पर भरोसा करो। ");
INSERT INTO hlb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","मरियम अर ओकी बहिन मार्था को गाँव बैतनिय्याह को लाजर नाम को एक अदमी बीमार हतो। ");
INSERT INTO hlb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","या वा वाली मरियम हती जोना प्रभु पर इतर डाल ख ओको पाय हुन ख अपनी बाल चोटी से पोची रह, एको ही भई लाजर बीमार हतो। ");
INSERT INTO hlb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","एकोलाने ओकी बहिन हुन न यीसु खबर भेजियो, “अरे प्रभु, देख जसो तू प्रेम करत रह, उ बीमार हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","यू सुन ख यीसु न कय्हो, “या बीमारी माऊत कि नी; पर परमेस्वर कि बड़ाई करन को लाने हैं, कि ओको दुवारा परमेस्वर को पोरिया की इज्जत होये।” ");
INSERT INTO hlb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","यीसु मार्था अर ओकी बहिन अर लाजर से प्रेम रखत रह। ");
INSERT INTO hlb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","फिर भी जब ओ ना सुनो कि उ बीमार हैं, ते जे जगा पर उ हतो, ओमा दो दिन अऊर ठहर गयो। ");
INSERT INTO hlb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","एको बाद ओ ना चेला हुन से कय्हो, “आव, अपुन फिर यहूदिया ख जाहें।” ");
INSERT INTO hlb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","चेला हुन न ओसे कय्हो, “अरे गुरू, अबा बाई तो कुछ रोज पहले यहूदी तोरो ऊँपर पत्थर मारन को लाने होत रह, अऊर का तू फिर भी उते जाय हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","यीसु न जवाब दियो, “का दिन का बारा घंटा नी होवा? अदि कोई दिन म चले ते डच नी खावा, काहेकि यू दुनिया को उजियारा देखा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","पर अदि कोई रात म चले ते डच खावा हैं, काहेकि रात म उजेरो नी रहवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ओ ना या बात बोली, अऊर एको बाद उनसे बोलन लग गयो, “हमारो दोस्त लाजर सो गयो हैं, पर मी ओखा जागान ख जाऊ हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","तब चेला हुन न यीसु से कय्हो, “अरे प्रभु, अदि उ सो गयो हैं ते अच्छी हो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","यीसु न तो ओकी माऊत को बारे म यू बोल्यो रह, पर वी समझीया कि ओ ना नींद से सो जान को बारे म कय्हो। ");
INSERT INTO hlb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","तब यीसु न उनसे साफ-साफ कह दियो, “लाजर मर गयो हैं; ");
INSERT INTO hlb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","अऊर मी तुमरो वजेसे बेजा खुस हैं कि मी वहाँ नी हतो जेमा तुम भरोसा करे। पर अब आव, अपून ओको जोने चले।” ");
INSERT INTO hlb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","येपर थोमा न जो दिदुमुस कहलावा हैं, अपना चेला हुन से कय्हो, “आव अपुन भी ओको संग मरन का चले।” ");
INSERT INTO hlb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","वहाँ पहुँचनो पर यीसु का यु मालुम भयो कि लाजर ख मरघट म धरिया चार दिन हो चुक्या हैं। ");
INSERT INTO hlb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बैतनिय्याह यरूसलेम को कोई दो कोस की दुर पर हतो। ");
INSERT INTO hlb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","बेजा सारा यहूदी मार्था अर मरियम को जोने ओको भई की गति पर सान्ति देन ख लाने आया हता। ");
INSERT INTO hlb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","जब मार्था न यीसु को आन की खबर सुनी ते ओखा देखन का गई, पर मरियम घर म बठी हती रह। ");
INSERT INTO hlb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","मार्था न यीसु से कय्हो, “अरे प्रभु, तू यहाँ होतो, ते मोरो भई नी मरतो। ");
INSERT INTO hlb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","अर अब भी मी जानु हैं कि जो कुछ तू परमेस्वर से माँगे, परमेस्वर तोखा देहेगो।” ");
INSERT INTO hlb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","यीसु न ओसे कय्हो, “तोरो भई फिर से जिन्दो होय ख उठे।” ");
INSERT INTO hlb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मार्था न ओसे कय्हो, “मी जानु हैं कि आखरी दिन म फिर से जिन्दो उठन को दिन म उ जिन्दो उठेगो।” ");
INSERT INTO hlb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","यीसु न ओसे कय्हो, “फिर से जिन्दो करन वालो अर जीवन मीइच ही आय जो कोई मोपर भरोसा करा हैं उ अदि मर भी जाहे तेभी जिन्दो होयगो, ");
INSERT INTO hlb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","अर जे कोई जिन्दा हैं अर मोरो ऊपर भरोसा करा हैं, उ कभी नी मरन को। का तू या बात पर भरोसा करा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ओ ना ओसे कय्हो, “हाँ प्रभु, मी भरोसा करू हैं कि तू ही परमेस्वर को पोरिया मसी जो संसार म आनवालो हतो।” ");
INSERT INTO hlb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","असी बोल ख वा चल दी, अऊर अपनी बहिन मरियम ख बुलाय ख धीरे से बोली, “प्रभु इतेइच हैं अर तोरो ख बुलावा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","असी सुनते ही वा तुरत उठ ख खड़ी भई अऊर यीसु से मिलन ख ओको जोने गई। ");
INSERT INTO hlb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","यीसु अबा गाँव म नी पहुँचियो रहा पर वई जगह म हतो रह जेमा मार्था न ओखा देख्यो रहा हतो ");
INSERT INTO hlb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","तब जे यहूदी ओको संग दुख को बखत घर म हता अर ओखा सान्ति देत रह हता, यू देख ख कि मरियम तुरत उठ ख बाहर गई हैं असा समझीया कि वा मरघट पर रोवन का जावा हैं, ते ओखा पिछु जान लग गया। ");
INSERT INTO hlb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","जब मरियम वहाँ पहुँची जहाँ यीसु हतो, ते ओखा देखते ही ओको पाय हुन म गीर पड़ी अर बोली, “अरे प्रभु अदि तू यहाँ होतो ते मोरो भई नी मरतो।” ");
INSERT INTO hlb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","जब यीसु न ओखा अर वी यहूदी हुन का जे ओखा संग म आया हता रोते हुए देखयो, ते आत्मा म बेजा उदास अर नराज भयो, ");
INSERT INTO hlb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","अर कय्हो, “तुम न ओखा किते मिठ्टी दी हैं?” उन न ओसे कय्हो, “प्रभु, आ अऊर चलका देख ला।” ");
INSERT INTO hlb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","यीसु रोयो। ");
INSERT INTO hlb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","येपर यहूदी हुन बोलन लग गया, “देखो, उ ओसे कित्तो प्रेम करत रहा।” ");
INSERT INTO hlb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","पर उनमा से कुछ न कय्हो, “का यू जोना अंधा की आँख खोली यू भी नी कर सको कि यू इंसान नी मरतो?” ");
INSERT INTO hlb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","यीसु मन म फिर बेजा ही नराज होयका मरघट म आयो। वा एक गुफा हती अर एक पत्थर ओपर धारो हतो। ");
INSERT INTO hlb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","यीसु न कय्हो, “पत्थर बगल करो।” उ मरियो वालो कि बहिन मार्था ओसे कहन लग गई, अरे प्रभु, उ तो अब गधान लग गयो होए। ");
INSERT INTO hlb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","यीसु न ओसे कय्हो, “का मीना तोसे नी कय्हो रह कि अदि तू भरोसा करे, ते परमेस्वर को काम कि महेमा ख देखेगो।” ");
INSERT INTO hlb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","तब उनना उ पत्थर ख हटायो। यीसु न आँखी ऊपर उठायो ख बोल्यो, “अरे परमेस्वर बाप, मी तोरो धन्यवाद करू हैं कि तू न मोरी बिनती सुन लियो हैं, ");
INSERT INTO hlb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","मी जानत रह कि तू हमेसा मोरी सुना हैं, पर जे भीड़ आजू-बाजू खड़ी हैं, उनको लाने मीना यू कय्हो, जसो कि यी भरोसा करे कि तुना मोखा भेजो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","यू बोल ख ओ ना बड़ी जोर से पुकारा, “लाजर, बहार निकल आ!” ");
INSERT INTO hlb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","जो मर गयो रह उ कठरी से हात पाय बंधियो हता वसो निकल आयो, “अर ओको मुंडो अंगोछा से लपटियो हतो। यीसु न उनसे कय्हो, ओखा खोल देव अर येखा जान देव।” ");
INSERT INTO hlb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","तब जो यहूदी हुन मरियम को जोने आया हता अर जिन न ओको यू काम देखो हतो, उनमा से ढ़ेर सारा न ओपर भरोसा करो। ");
INSERT INTO hlb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","पर उनमा से कुछ फरीसी हुन न ओको जोने जा ख बतायो कि यीसु न का करयो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","येपर मेन पुजारी हुन अर फरीसी हुन न बड़ी सभा जोडयो, अर कय्हो, “हम का कर रया हैं? यू इंसान तो बेजा चिन्ह दिखावा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","अदि हम ओखा असो करते ही रहन देहे, ते सब ओपर भरोसा करन लग जाहे अर रोमी आ ख हमरी जगह अर जात दोई पर हक जमा लेहे।” ");
INSERT INTO hlb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","तब उनमा से काइफा नाम को एक अदमी न जो उ बखत म मेन पुजारी हतो, उनसे कय्हो, “तुम कुछ भी नी जाना। ");
INSERT INTO hlb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","अऊर न यू समझत आय कि तुम्हारो लाने यू भलो हैं कि हमरा इंसान को लाने एक इंसान मरे, अर सब जात नास नी होन कि।” ");
INSERT INTO hlb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","या बात ओ ना अपनी तरफ से नी बोल्यो, पर उ साल को मेन पुजारी होयका भविस्यवानी करी, कि यीसु सब जात को लाने मरेगो; ");
INSERT INTO hlb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","अऊर न सिर्फ यहूदी जात को लाने, वरन एकोलाने भी कि परमेस्वर कि सब तितिर बितर संतान हुन का एक कर देहे। ");
INSERT INTO hlb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","उई दिन से वी यीसु ख मार ड़ालन को मऊका ढुढ़न लग गया। ");
INSERT INTO hlb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","एकोलाने यीसु उ बखत से यहूदी हुन म उजागर नी फिरो पर वहाँ से जंगल को जोने वालो परदेस को इफ्राईम नाम को एक सहर म चल दियो; अर अपना चेला हुन को संग ओमा ही रहन लग्यो। ");
INSERT INTO hlb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","यहूदी हुन को फसह को तिहार जोने हतो रह, अर ड़ेर सारा इंसान फसह से पहले दिहात से यरूसलेम का गया रहा कि अपनो तुम ख सुध्द या पाक करे। ");
INSERT INTO hlb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","एको बाद वी यीसु का ढूँढ़न लग्या अऊर मन्दिर म खड़ो हो का एक दुसरा से बोलन लग्या, “तुमरो का विचार हैं? का उ तिहार म नी आन को?” ");
INSERT INTO hlb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","मेन पुजारी हुन अऊर फरीसी हुन न यू आदेस दियो हतो रह, कि अदि कोई यू जाने कि यीसु किते हैं ते बताव काहेकि कि वी ओखा पकड़ सके। ");
INSERT INTO hlb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","यीसु फसह को तिहार को छे दिन पहले बैतनिय्याह म आयो जहाँ लाजर हतो, जेखा यीसु न मरो म से जिन्दो करियो रह। ");
INSERT INTO hlb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","उते उन न यीसु को लाने खाना बनायो; अर मार्था सेवा करत रह, अर लाजर ओमा से एक हतो जो ओको संग खाना खान को लाने बठियो हतो। ");
INSERT INTO hlb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","तब मरियम न जटामासी को सबसे मेंहगो सुध्द इतर लेका यीसु को पाय हुन पा ड़ालो, अर अपनी बाल चोटी से ओको पाय हुन का पोची; अर इतर को मेहकनो से या गंधानो से घर मेहकन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","पर ओखा चेला म से यहूदा इस्करियोती नाम को एक चेला जे ओखा पकड़ान पर हतो, कहन लगो, ");
INSERT INTO hlb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“यू इतर तीन सव चाँदी का सिक्का म बेच ख पैसा गरीब इंसान हुन म काहेनी बाँटिया गयो?” ");
INSERT INTO hlb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ओ ना या बात एकोलाने नी बोलो की ओखा गरीब हुन कि चिन्ता हती पर एकोलाने कि उ चोर हतो, अर ओको जोने पैसा की थैली रहत रह अर ओमा जो कुछ ड़ालो जात रह, उ निकाल लेत रह। ");
INSERT INTO hlb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","यीसु न बोलो, “ऐका छोड़ देव। ऐका यू काम मोरो गाड़ो जान को दिन को लाने करन देव। ");
INSERT INTO hlb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","काहेकि गरीब हुन तो तुमरो संग म हमेसा रहवा हैं, पर मी तुमरो संग हमेसा नी रहन को।” ");
INSERT INTO hlb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","जब यहूदी हुन कि बड़ी भीड़ जान गई कि यीसु वहाँ आयो हैं, ते वी न केवल यीसु को वजेसे आया पर एकोलाने भी कि लाजर का देखे, जेका यीसु न मुर्दा म से जिन्दो करियो रह, ");
INSERT INTO hlb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","तब मेन पुजारी हुन न लाजर का भी मार ड़ालन की कोसीस करी। ");
INSERT INTO hlb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","काहेकि ओको वजेसे डेर सारा यहूदी चला गया अर यीसु पर भरोसा करो। ");
INSERT INTO hlb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","दुसरो दिन, ड़ेर सारा इंसान हुन न जो तिहार म आया हता असो सुनो कि यीसु यरूसलेम म आ रयो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","एकोलाने उन ना खजूर कि डगियान हुन लियो अर “ओकी महेमा करन को लाने निकलिया, अर आवाज देन लग्या, होसाना धन्य हैं इस्राएल को राजा, जो प्रभु को नाम से आवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","जब यीसु का गदही को एक बच्चा मिलो; ते उ ओपर बठ गयो, जसो ग्रंथ म लिखो हैं, ");
INSERT INTO hlb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“अरे सिय्योन सहर, मत डरा; देख, तोरो राजा गदही को बच्छा पर बठ ख आवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","यीसु का चेला हुन या बात पहले नी समझीया हता, पर जब यीसु कि महिमा परगट भई ते उनका याद आयी कि या बात ओको बारे म लिखी हती रह अर इंसान हुन न ओसे आसो तरीका से व्यवहार करो रह। ");
INSERT INTO hlb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","तब भीड़ का वी अदमी हुन न गवाई दियो, जे वा बखत ओको संग म हता जब ओ ना लाजर का मरघट म से बुला ख मरो म से जिन्दो करो रह ");
INSERT INTO hlb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","एको लाने अदमी हुन ओसे मीलन को लाने आया हता काहेकि उन न सुनो हतो रह कि यीसु यू बड़ो चिन्ह दिखायो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","यू सब देख ख फरीसी हुन न आपस म बोल्यो, देख रया हैं न, “तुम से कुछ नी बन सका। देखो, दुनिया ओको पिछु होते जावा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","जे अदमी उ तिहार म बिनती करन आया रह ओमन से कुछ यूनानी हता ");
INSERT INTO hlb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","उन ना गलील को बैतसैदा को रहन वालो फिलिप्पुस को जोने आय ख ओसे पूछो, “अरे गुरू जी हम यीसु प्रभु से मिलनु चाहवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","फिलिप्पुस न आय ख अन्द्रियास से कय्हो; ओको बाद अन्द्रियास अर फिलिप्पुस न यीसु से कय्हो ");
INSERT INTO hlb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","येपर यीसु न उनसे कय्हो, “उ बखत आ गयो हैं, कि इंसान को पोरिया की महिमा होए। ");
INSERT INTO hlb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","मी तुम से सच्ची-सच्ची कहूँ हैं कि जब तक गहूँ को दाना जमीन म रैय ख सड़ नी जावा तब लक उ अकेलो रहवा हैं; पर जब अदि उ सड़ जावा हैं, ते ड़ेर सारो फर लावा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","जे अपनी जान का बेजा प्रेम करा हैं उ ओखा नास कर देवा हैं; अर जे यू दुनिया म अपनी जान का ज्यादा प्रेम नी करा हैं, उ अनन्त जीवन को लाने ओ ख बचाहे। ");
INSERT INTO hlb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","अदि कोई मोरी सेवा करे, ते मोरो पिछु आन लग जाय; अर जीते मी रहू हैं, ओमा मोरो सेवक भी रहेगो। अदि कोई मोरी सेवा करे ते मोरो परमेस्वर बाप भी ओकी इज्जत करेगों। ");
INSERT INTO hlb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“अब मोरी जान घबरावा हैं। का मी असो कहूँ, बाप या घड़ी की मुसीबत से मोखा बचा? काहेकि मी एको कारन या घड़ी का पहुँचो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","अरे बाप, अपनो नाम कि महेमा कर।” उत्तीच बखत स्वर्ग से असी आवाज सुनाई पड़ी, “मी न अपनो नाम की बड़ाई करी हैं अर फिर ओकी भी करुँगो।” ");
INSERT INTO hlb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","तब जे अदमी आजू-बाजू खड़ा होका सुनत रह हता उन ना कय्हो, कि बादल गरजो। कुछ न बोलयो, “कोई स्वर्ग दूत ओसे कुछ बोलयो।” ");
INSERT INTO hlb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","येपर यीसु न कय्हो, “यु सब्द मोरो लाने नी, पर तुमरो लाने आयो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","अब या दुनिया को न्याय होवा हैं, अब यू दुनिया को मुखिया नीकाल दियो जाहेगो; ");
INSERT INTO hlb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","अऊर मी, जब जमीन पर से ऊँचो पर लटकायो जाऊँगो, ते सब इंसान हुन का अपनो पास खीचूँगो।” ");
INSERT INTO hlb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","असो बोल ख ओ ना यू परगट कर दियो कि उ कसी माऊत से मरे। ");
INSERT INTO hlb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","येपर अदमी हुन न ओसे कय्हो, “नेम हमका असो ग्यान देवा हैं कि मसी हमेसा रहेगो, फिर तू काहे बोला हैं कि इंसान को पोरिया का ऊँचो पर लटकायो जानो जरुरी हैं? यू इंसान को पोरिया कोन आय?” ");
INSERT INTO hlb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","येपर यीसु न उनसे कय्हो, “ज्योति अब थोड़ी देर तक तुम्हारो बीच म हैं। जब लक ज्योति तुम्हारो संग हैं तब लक चलते ही चलते रहनु कही असो नी होय की अंधेरा तुमका घेर ले; जे अंधेरा म चला हैं उ नी जाना की किते जावा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","जब लक ज्योति तुमरो संग म हैं, ज्योति पर भरोसा करो ताकि ज्योति की संतान बने।” यीसु यू बोल ख चल दियो अऊर उनकी आँखी से लुप्त हो गयो। ");
INSERT INTO hlb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","फिर भी यीसु न उनको सामे इत्ता चिन्ह दिखाया, तेभी उनना यीसु पर भरोसा नी करो; ");
INSERT INTO hlb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","यू जरूरी होनो थो कि ताकि यसायाह भविस्यवक्ता को वचन पूरो होय जे, ओ ना कय्हो: “अरे प्रभु, हमारी अच्छी बात पर को कोना भरोसा करियो? अर प्रभु को हात की ताकत कोपर परघट भयो हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","एको लाने वी भरोसा नी कर सक्या, काहेकि यसायाह न यू भी कियो हैं: ");
INSERT INTO hlb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“परमेस्वर न उनकी आँखी ख अंधो कर दियो हैं, अऊर उनकी अकल बंद कर दी हैं परमेस्वर न बोल्यो: कही असो नी होय कि वी आँखी से देखे, अर मन से समझे, अर मोरी तरफ लउटे आहे, अर मी उनका अच्छो कर देहु।” ");
INSERT INTO hlb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यसायाह न यू एकोलाने बतायो रहा कि उनना खुद यीसु कि महेमा देखी रहा, अर ओ ना उनको बारे म असो कही रहा। ");
INSERT INTO hlb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","तेभी अधिकारी हुन म से बेजा सारा न यीसु पर भरोसा करियो, पर वी फरीसी हुन को कारन उजागर म नी मानत रह हता, कभी असो नी होय की वी प्रार्थना मन्दिर म से निकाल जाए: ");
INSERT INTO hlb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","उनका परमेस्वर की महेमा करनो से बड़ ख इंसान कि इज्जत करनो ऐसे ज्यादा प्यारो लगत रह। ");
INSERT INTO hlb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","यीसु न जोर से कही, “जे मोरो ऊपर भरोसा रखा हैं, उ मोरो ऊपर नी पर जेना मोखा भेज्यो हैं ओको ऊपर भरोसा करा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","अर जे मोखा देखा हैं, उ ओखा देखा हैं जेना मोखा पहुँचियो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","मी दुनिया म ज्योति सरीको बन ख आयो हैं, ताकि जे कोई मोपर भरोसा करे उ अन्धेरा म नी रहन को। ");
INSERT INTO hlb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","अदि कोई मोरी बात सुन कर नी माना, ते मी ओखा न्याय या दोसी नी ठहराऊ; काहेकि मी दुनिया ख दोसी ठहरान को लाने नी, पर दुनिया को उध्दार करन को लाने आयो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","जे मोखा फालतु समझा हैं अर मोरी बात ख मननो से मना करा हैं ओखा दोसी ठहरान वालो तो एक हैं: एकोमतलब जे वचन मी न कय्हो हैं, उई पिछे आन वालो दिन म ओखा दोसी ठहरायगो। ");
INSERT INTO hlb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","काहेकि मीना अपनी तरफ से कुछ बात नी करी; पर बाप जेना मोखा भेजो हैं ओ ना ही मोखा आदेस दियो हैं कि का कहनो हैं अर का बोलनू हैं? ");
INSERT INTO hlb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","अर मी जानु हैं कि ओको आदेस अनन्त काल को जीवन हैं। एकोलाने जे कुछ मी बोलू हैं उ जसो मोरो बाप परमेस्वर न मोसे कही हैं वसो ही कहूँ हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","फसह को तिहार से पहले को दिन हतो, जब यीसु न जान लियो कि मोरी वा घड़ी आ गई हैं कि दुनिया छोड़ख बाप को जोने जाऊ, ते अपना इंसानहुन से जे दुनिया म हता जसो प्रेम उ रखत रह हतो, आखरी तक वसो ही प्रेम रखते रयो। ");
INSERT INTO hlb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","यीसु अपना चेला हुन को संग खाना खात रहा ते। भूत समोन इस्करियोती को पोरिया यहूदा को मन म यीसु ख पकड़ान को विचार डाल चुक्यो रहा। ");
INSERT INTO hlb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","यीसु न, यू जान लियो कि परमेस्वर बाप न सब कुछ मोरो हात म कर दियो हैं अर यू की यीसु परमेस्वर को जोने से आयो हैं अर परमेस्वर को जोने जा रयो हैं, ");
INSERT INTO hlb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","एकोलाने उ खाना पर से उठ ख अपना ऊपर का कपड़ा ऊतार दियो, अर अंगोछा लेका अपनी कम्मर बाँधी। ");
INSERT INTO hlb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","तब कोपर म पानी बरखा चेला को पाय धोन अर जो अंगोछा से ओकी कम्मर बंधी हती ओसे ही पोछन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","जब उ समोन पतरस को पास म आयो, तब पतरस न ओसे कही, “अरे प्रभु, का तू मोरा पाय हुन धोवा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","यीसु न ओखा जवाब दियो, “जो मी करुँ हैं, तू ओखा अभी नी जाना, पर एको बाद समझेगो।” ");
INSERT INTO hlb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पतरस न ओसे कही, “तू मोरा पाय कभी नी धो पान को!” यू सुन कर यीसु न ओसे कय्हो, “अदि मी तोरा पाय का नी धोन को, ते मोरो संग तोरो हमेसा को कुछ भी नाता नी रहन को।” ");
INSERT INTO hlb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","येपर समोन पतरस न ओसे कय्हो, “अरे प्रभु, ते मोरा पाय ही नी, पर मोरा हात अर आँग भी धो दा।” ");
INSERT INTO hlb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","यीसु न ओसे कय्हो, “जोना आँग धो लियो हैं ओखा पाय को अलावा अर कुछ धोन कि जरूरत नी हाय, पर उ बिलकुल सुध्द हैं; अर तुम सुध्द हैं, पर सब का सब नी।” ");
INSERT INTO hlb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","उ तो अपनो पकडवान वालो का जानत रह हतो एकोलाने ओ ना कय्हो, “तुम सब का सब सुध्द नी हाय।” ");
INSERT INTO hlb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","जब यीसु उन सबको पाय धो चुक्यो, तब उ अपना कपड़ा पहिन का फिर बठ गयो, अऊर उनसे कहन लग गयो, “का तू समझीया की मीना तुमरो संग का करो? ");
INSERT INTO hlb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","तुम मोखा गुरू अर प्रभु बोला हैं, अऊर ठीक ही बोला हैं, काहेकि मी उईच आय।” ");
INSERT INTO hlb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","अदि मी न प्रभु अर गुरू होका तुमरो पाय धोयो, ते तुमका भी एक दुसरो को पाय धोनु जरूर धोनो चाहिए। ");
INSERT INTO hlb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","काहेकि मी न तुमका नमूना दिखा दियो हैं कि जसो मी न तुमरो संग करो हैं, तुम भी वसो ही करते रहनु। ");
INSERT INTO hlb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","मी तुम से सच्ची सच्ची कहूँ हैं, सेवक (दास) अपनो मालीक या प्रभु से बडो नी हाय, अर न भेज्यो वालो अपनो भेजन वालो से। ");
INSERT INTO hlb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","तुम या बात हुन जाना हैं, अर अदि उन पर चले ते अच्छा या धन्य हैं। ");
INSERT INTO hlb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","मी तुम सब को बारे म नी कहूँ हैं; जिनका मी न चुनियो हैं, उनका मी जानु हैं; पर यू एको लाने हैं कि सुध्द सास्र को यू वचन पूरो होय, जो मोरी रोटी खावा हैं, ओ ना मोरो ऊपर लात उठाई हैं। ");
INSERT INTO hlb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","अब मी ओको होनू से पहले तुमका जाता देऊ हैं कि जब यू हो जाहे ते तुम भरोसा करे की मी ऊईच आय। ");
INSERT INTO hlb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","मी तुम से सच्ची सच्ची कहूँ हैं की जे मोरो भेज्यो वालो ख अपनावा हैं; अर जे मोखा अपनावा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","या बात बोल ख यीसु मन म नाराज भयो अर या गवाई दियो, मी तुम से सच्ची सच्ची कहूँ हैं कि तुम मा से एक मोखा पकडवाएगो। ");
INSERT INTO hlb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","चेला हुन ओको कहनु से, कि उ कोन को बारे म बोला हैं, एक दुसरो की तरफ देखन लग गया। ");
INSERT INTO hlb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ओखा चेला हुन म से एक जसो यीसु प्रेम रखत रह हतो यीसु को सीना की तरफ झुक का बठो हतो रह। ");
INSERT INTO hlb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","समोन पतरस न ओकी तरफ इसारा कर ख ओसे पुछो, “पूछ तो उ कोन को बारे म बोला हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","तब ओ ना वसो ही यीसु की छाती की तरफ झुक का ओसे पूछो, “अरे प्रभु, उ कोन आय?” ");
INSERT INTO hlb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","यीसु न जवाब दियो, “जेखा मी या रोटी को टुकड़ा डुबा ख देऊ ऊँईच आय।” अर ओ ना टुकड़ा डुबा ख समोन इस्करियोती को पोरिया यहूदा का दियो। ");
INSERT INTO hlb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","टुकड़ा लेते ही भूत ओमा समा गयो। तब यीसु न ओसे कय्हो, “जो तू करा हैं, तुरत कर।” ");
INSERT INTO hlb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","पर बठन वाला म से कोई न नी जानो ओ ना या बात ओसे काय को लाने कही। ");
INSERT INTO hlb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","यहूदा को जोने थैली रहत रह हती, एकोलाने कोई कोई न समझो की यीसु ओसे बोल रयो हैं कि जे कुछ हमका तीहार को लाने लेनू हैं ओखा मोल लेव, यु एको लाने कि कंगाल हुन का कुछ देहे। ");
INSERT INTO hlb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","एको बाद उ टुकड़ा लेका बहार चल दियो; अर यू रात को बखत हतो रह। ");
INSERT INTO hlb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","जब उ बहार चल दियो ते यीसु न कही, “अब इंसान को पोरिया की बड़ाई भई हैं, अर परमेस्वर की बड़ाई ओमा भई हैं; ");
INSERT INTO hlb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","अदि ओमा परमेस्वर की बड़ाई भई हैं, ते परमेस्वर भी अपनो म ओकी बड़ाई करेगों अर तुरत करेगों। ");
INSERT INTO hlb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","अरे पोरिया हुन, मी अऊर थोड़ी देर ख तुमरो कने हैं; फिर तुम मोखा ढूँढ़ेगो, अर जसो मी न यहूदी हुन से कय्हो, जीते मी जाऊ हैं वहाँ तुम नी आ सका, वसो ही मी अब तुम से भी कहूँ हैं। ");
INSERT INTO hlb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","मी तुम ख एक नयो आग्या देऊ हैं कि एक दुसरा से प्रेम रखनू; जसो मी न तुम से प्रेम रखो हैं, वसो ही तुम भी एक दुसरा से प्रेम रखनू। ");
INSERT INTO hlb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","अदि आपस म प्रेम रखेगो, ते आसे से सब जाने की तुम मोरा चेला हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","समोन पतरस न ओसे कय्हो, “अरे प्रभु, तू किते जावा हैं?” यीसु न जवाब दियो, “जीते मी जाऊ हैं वहाँ तू अबा मोरो पीछु आ नी सकन को: पर एको बाद मोरो पीछु आएँगो।” ");
INSERT INTO hlb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पतरस न ओसे कय्हो, “अरे प्रभु, आबा मी तोरो पीछु काहे नी आ सकन को? मी तो तोरो खातिर अपनी जान भी दे देऊगो।” ");
INSERT INTO hlb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","यीसु न जवाब दियो, “का तू मोरो खातिर अपनी जान देहे? मी तोसे सच्ची-सच्ची कहूँ हैं कि मुर्गा बाँग नी देन को जब लक तू तीन बार मोरो इनकार कर लेन को।” ");
INSERT INTO hlb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“तुमारो मन ख नराज मत करो; परमेस्वर पर भरोसा रखो अर मोरो ऊपर भी भरोसा रखो। ");
INSERT INTO hlb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","मोरो बाप को घर म ढ़ेर सारी रहन की जगह हैं, अदि नी होती ते मी तुम से कह देतो; काहेकि मी तुमरो लाने जगह तैयार करन जाऊ हैं। ");
INSERT INTO hlb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","अर अदि मी जा ख तुमरो लाने जगह तैयार करुँ, ते फिर आ ख तुमका अपनो यहाँ लेका जाऊँगो कि जीते मी रहू ओमा तुम भी रहो। ");
INSERT INTO hlb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","जीते मी जाऊ हैं तुम उते को रस्ता जाना हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमा न ओसे कय्हो, “अरे प्रभु, हम नी जाना की तू किते जावा हैं; ते रस्ता कसा जाने?” ");
INSERT INTO hlb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","यीसु न ओसे कही, “मार्ग अऊर सही अऊर जीवन मीइच ही आय; बिना मोरो दुवारा कोई परमेस्वर बाप को पास नी पहुँच सका। ");
INSERT INTO hlb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","अदि तुम न मोखा जानो होतो, ते मोरो बाप परमेस्वर का भी जानता; अर अब ओखा जाना हैं, अर ओखा देखो भी हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फिलिप्पुस न ओखा देखो, “अरे प्रभु, परमेस्वर बाप का हम का दिखा दा, यूइच हमरो लाने बेजा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","यीसु न ओसे कही, अरे फिलिप्पुस, मी इत्तो दिन से तुमरो संग म हैं, अर का तू मोखा नी जाना? जोना मोखा देखो हैं ओ ना परमेस्वर बाप ख देखो हैं। तू काहे बोला हैं कि परमेस्वर बाप ख हमका दिखा? ");
INSERT INTO hlb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","का तू भरोसा नी करा कि मी परमेस्वर बाप म हैं अर परमेस्वर बाप मोरो म हैं? या बात हुन जो मी तोसे कहू हैं, अपनी तरफ से नी कहत आय, पर परमेस्वर बाप मोरो म रह ख अपनो काम करा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","मोरी या बात को भरोसा करो कि मी परमेस्वर बाप म हैं अर परमेस्वर बाप मोरो म हैं; नी ते वी काम हुन को ही वजेसे मोरो भरोसा करो। ");
INSERT INTO hlb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","मी तुम से सच्ची-सच्ची कहूँ हैं कि जे मोरो ऊपर भरोसा रखा हैं, यी काम जे मी करूँ हैं उ भी खुद करेगों, वरन ऐसे भी बड़ा काम करेगों, काहेकि मी परमेस्वर बाप को पास जाऊ हैं। ");
INSERT INTO hlb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","जे कुछ तुम मोरो नाम से माँगेगो, मी ओखा पुरो करुँगो कि जसो पोरिया को दुवारा परमेस्वर बाप की महिमा परघट होय। ");
INSERT INTO hlb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","अदि तुम मोसे मोरो नाम से कुछ माँगेगो, ते मी ओखा पुरो करुँगो। ");
INSERT INTO hlb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“अदि तुम मोसे प्रेम करत होए, ते मोरा आग्या ख मानेगो। ");
INSERT INTO hlb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","मी परमेस्वर बाप से विनती करुँगो, अर उ तुमका एक अऊर मदत करन वालो देहेगो कि उ हमेसा तुमरो संग म रहे।” ");
INSERT INTO hlb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ऐको मतलब सच को आत्मा, जेखा दुनिया नी अपना सका, काहेकि वी न ओखा देखा हैं अऊर न ओखा जाना हैं; तुम ओखा जाना हैं, काहेकि उ तुमरो संग म रहवा हैं, अर उ तुम म होयगो। ");
INSERT INTO hlb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“मी तुम ख अनाथ नी छोड़न को; मी तुमरो पास आऊ हैं। ");
INSERT INTO hlb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","अऊर थोड़ी देर अऊर बच गई हैं कि फिर दुनिया मोखा नी देखन को, पर तुम मोखा देखेगो; एकोलाने कि मी जिन्दो हैं, तुम भी जिन्दा रहेगो। ");
INSERT INTO hlb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","उ दिन तुम समझेगो की मी अपनो बाप परमेस्वर म हैं, अर तुम मो म अर मी तुम म।” ");
INSERT INTO hlb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“जेको पास मोरो आग्या हैं अर उ उनका माना हैं, उईच मोसे प्रेम करा हैं; अर जे मोसे प्रेम रखा हैं ओसे मोरो परमेस्वर बाप प्रेम रखेगो, अर मी ओसे प्रेम रखूगो अर अपनो तुम ख ओपर परघट करुँगो।” ");
INSERT INTO hlb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","उ यहूदा न जो इस्करियोती नी हतो, ओसे कही, “अरे प्रभु, का भयो कि तू अपनो तुम ख हम पा परघट करनु चाहवा हैं अर दुनिया पर नी?” ");
INSERT INTO hlb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","यीसु न ओखा जवाब दियो, “अदि कोई मोसे प्रेम रखेगो ते उ मोरो वचन ख मानेगो, अर मोरो बाप परमेस्वर ओसे प्रेम रखेगो, अर हम ओको पास आएँगो अर ओको संग रहेगो। ");
INSERT INTO hlb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","जे मोसे प्रेम नी रखा, उ मोरा वचन नी माना; अर जे वचन तुम सुनते रहवा हैं उ मोरो नी पर परमेस्वर बाप को हैं, जोना मोखा भेजो।” ");
INSERT INTO hlb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“या बात मी न तुमरो संग म रहते बखत तुम से कही हैं ");
INSERT INTO hlb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","पर तुमारी मदत करन वालो एको मतलब सुध्द आत्मा जोका परमेस्वर बाप मोरो नाम से भेजेगो, उ तुमका सबरी बात हुन सिखाएगो अर जे कुछ मी न तुम से कय्हो हैं, उ सब तुमका याद दिलायगो।” ");
INSERT INTO hlb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","मी तुमका सान्ति देका जाऊ हैं, मोरी सान्ति तुमका देऊ हैं; जसी दुनिया देवा हैं, मी तुमका नी देऊ: तुमारो मन नाराज नी होय अर मत डरनू। ");
INSERT INTO hlb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","तुम न सुनो की मी न तुम से कय्हो, मी जाऊ हैं, अर तुमरो कने फिर आऊगो। अदि तुम मोसे प्रेम रखता, ते या बात से खुस होता कि मी परमेस्वर बाप को कने जाऊ हैं, काहेकि परमेस्वर बाप मोरो से बड़ो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","अर मी न एको होनो से पहले तुम से कैय दियो हैं, कि जब उ हो जाऐ, ते तुम भरोसा करे। ");
INSERT INTO hlb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","मी अब तुमरो संग जादा बात हुन नी करन को, काहेकि या दुनिया को मुखिया आवा हैं। मोरो ऊपर ओको कुछ हक नी हाय; ");
INSERT INTO hlb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","पर यु एकोलाने होवा हैं कि दुनिया जाने कि मी परमेस्वर बाप से प्रेम करुँ हैं, अर जसो परमेस्वर बाप न मोखा हुकुम दियो हैं मी वसो ही करुँ हैं। उठो, येमा से चले। ");
INSERT INTO hlb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“मी सच्ची की फर फरन वाली डगियान आय, अर मोरो बाप किरसान आय। ");
INSERT INTO hlb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","जो डगियान मोरो म हैं अर फर नी फरा, ओखा उ काट देवा हैं; अर जेमा फर लगा हैं ओखा उ छाँटा हैं काहेकि अऊर फरे। ");
INSERT INTO hlb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","तुम तो उ वचन को वजेसे जे मी न तुम से कय्हो हैं, सुध्द हैं। ");
INSERT INTO hlb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","तुम मोरो म बनिया रहनु, अर मी तुम म। जसी डगियान अदि झाड़ की डगियान म लगी नी रहन की ते अपनो तुम म नी फर सका, वसो ही तुम भी अदि मोरो म बनिया नी रहन का ते नी फल फर सका।” ");
INSERT INTO hlb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","मी सही फर फरन वाली डगियान आय: अर तुम ओकी ड़ाली हुन आय। जो मोरो संग म बनिया रहवा हैं अर मी ओमा, उ ढ़ेर सारो फर फरा हैं, काहेकि मोसे अलग होका तुम कुछ भी नी कर सका। ");
INSERT INTO hlb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","अदि कोई मोरो म बनीयो नी रहन को, ते उ डगियान को जसो फेक दियो जावा, अर सुख जावा हैं; अर इंसान उनका बीन ख आग म डाल देवा हैं, अर वी पानी जावा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","अदि तुम मोरो म बनिया रहे अर मोरो वचन तुम म बनो रहे, ते जे भी कुछ माँगे अर उ तुमारो लाने हो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","मोरो परमेस्वर बाप की बड़ाई ऐसे होवा हैं की तुम ढ़ेर सारो फल लाव, तब जा ख तुम मोरा चेला ठहरे। ");
INSERT INTO hlb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","जसो परमेस्वर बाप न मोसे प्रेम रखो, वसो ही मी न तुम से प्रेम रखो; मोरो प्रेम म बनिया रव। ");
INSERT INTO hlb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","अदि तुम मोरो आग्या हुन का मानेगो, ते मोरो प्रेम म बनिया रहेगो जसो की मी न अपनो बाप को आग्या हुन का मानो हैं, अर ओको प्रेम म बनीयो रहू हैं। ");
INSERT INTO hlb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","मी न या बात तुम से एकोलाने नी बोलो हैं, कि मोरी खुसी तुम म बनी रहे, अर तुमारी खुसी पुरी हो जाहे। ");
INSERT INTO hlb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","मोरो आग्या यू हैं, कि जसो मी न तुम से प्रेम रखो, वसो ही तुम भी एक दुसरा से प्रेम रखनू। ");
INSERT INTO hlb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ऐसे बड़ो प्रेम कोई को नी हाय कि कोई अपना दोस्त को लाने अपनी जान दे। ");
INSERT INTO hlb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","जो हुकुम मी तुमका देऊ हैं, अदि तुम ओखा माने ते तुम मोरा दोस्त आय। ");
INSERT INTO hlb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","आज से मी तुमका दास नी कहन को, काहेकि दास नी जाना कि ओको स्वामी या प्रभु का करा हैं; पर मी न तुमका दोस्त कय्हो हैं, काहेकि मी न जो बात हुन अपनो बाप से सुनी, वी सब तुमका बता दियो। ");
INSERT INTO hlb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","तुम न मोखा नी चुनियो पर मी न तुमका चुनो हैं अर तुमका ठहरायो कि तुम जाका फल लाव अर तुमरो फल बनो रहे, कि तुम मोरो नाम से जे कुछ परमेस्वर बाप से माँगे, उ तुमका दे। ");
INSERT INTO hlb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","या बात को हुकुम मी तुमका एकोलाने देऊ हैं कि तुम एक दुसरा से प्रेम रखे। ");
INSERT INTO hlb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“अदि दुनिया तुम से बैर रखा हैं, ते तुम जाना हैं कि ओ ना तुम से पहले मोसे बैर रखो। ");
INSERT INTO hlb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","अदि तुम दुनिया का होता, ते दुनिया तुम ख अपनो समझ ख प्रेम करतो; पर तुम दुनिया का नी हाय, पर मी न तुमका दुनिया म से चुनियो लियो हैं, एको लाने दुनिया तुम से बैर रखा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","जो बात मी न तुम से कही रह, ‘दास अपनो प्रभु से बड़ो नी होवा,’ ओखा याद रखनू। अदि उन ना मोखा सतायो, ते तुमका भी सताएँगो; अदि उन न मोरी बात मानी, ते तुम्हारी भी मानेगो। ");
INSERT INTO hlb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","पर यू सब कुछ वी मोरो नाम को लाने तुमारो संग करेगों, काहेकि वी मोखा भेजन वालो का नी जाना।” ");
INSERT INTO hlb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","अदि मी नी आतो अर उनसे बात हुन नी करतो, ते वी पापी नी ठहरता; पर अब तो उन न उनको पाप को लाने कोई बहाना नी। ");
INSERT INTO hlb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","जो मोरो से बैर रखा हैं, उ मोरो बाप से भी बैर रखा हैं। ");
INSERT INTO hlb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","अदि मी उनमा वी काम नी करतो जो अऊर कोई न नी करो, ते वी पापी नी ठहरता; पर अब तो उन न मोखा अर मोरो बाप परमेस्वर दोई का देखो अर दोई से बैर करो। ");
INSERT INTO hlb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","यू एकोलाने भयो कि उ वचन पूरो होय, जे उनको नेम को किताब म लिखो हैं, उन न मोसे फालतु म बैर करो। ");
INSERT INTO hlb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","पर जब उ मदत करन वालो आएँगो, जेखा मी तुमरो पास परमेस्वर बाप कि तरफ से भेजूगो, एकोमतलब सच्चई को आत्मा परमेस्वर बाप कि तरफ से निकला हैं, ते उ मोरी गवाई देहेगो; ");
INSERT INTO hlb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","अर तुम भी मोरा गवाह हैं काहेकि तुम सुरू से मोरो संग रया हैं। ");
INSERT INTO hlb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","या बात हुन मी न तुम से एकोलाने कही, कि तुम ठोकर नी खान का। ");
INSERT INTO hlb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","वी तुमका प्रार्थना करन को मन्दिर म से निकाल देगो, इत्तोइच नी पर उ बखत आवा हैं, कि जे कोई तुमका मार ड़ालेगो उ समझेगो कि मी परमेस्वर कि सेवा करुँ हैं। ");
INSERT INTO hlb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","असो वी एकोलाने करेगों कि उनना न तो परमेस्वर बाप ख जानो हैं अर न मोखा जाना हैं। ");
INSERT INTO hlb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","पर या बात मी न एकोलाने तुम से कही, कि जब इनको बखत आहे ते तुमका याद आ जाहे कि मी न तुम से इनको बारे पहले ही कह दियो रह। मी न सुरू म तुम से या बात हुन एकोलाने नी कही काहेकि मी तुमरो संग हतो। ");
INSERT INTO hlb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","पर अब मी मोखा भेजन वालो को जोने जाऊ हैं; अर तुम म से कोई मोसे यू नी पूछा, कि तू किते जावा हैं? ");
INSERT INTO hlb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","पर मी न जो या बात हुन तुम से कही हैं, एकोलाने तुमरो मन दुख से भर गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","तेभी मी तुम से सच्ची कहूँ हैं कि मोरो जानो तुमारो लाने उचीत हैं, काहेकि अदि मी नी जाऊ ते उ मदत करन वालो तुमरो जोने नी आन को; पर अदि मी जाऊँगो, ते ओखा तुमरो जोने भेजूगो। ");
INSERT INTO hlb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","जब उ आएँगो, ते आका दुनिया ख पाप अर धार्मिकता अर न्याय को बारे म संसार ख निरुत्तर करेगों। ");
INSERT INTO hlb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","पाप को बारे म एकोलाने कि वी मोरो पर भरोसा नी करा; ");
INSERT INTO hlb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","अर धार्मिकता को बारे म एकोलाने कि मी परमेस्वर बाप को जोने जाऊ हैं, अर तुम मोखा फिर नी देखन का; ");
INSERT INTO hlb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","न्याय को बारे म एकोलाने कि दुनिया को मुखिया अरोपी ठहरायो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“मोखा तुम से अऊर भी ढ़ेर सारी बात कहनु हैं, पर अबा तुम उनका नी सैय सका। ");
INSERT INTO hlb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","पर जब उ एकोमतलब सत्य को आत्मा आएँगो, ते तुमका सब सत को रस्ता बतायगो, काहेकि उ अपनी तरफ से नी कहन को पर जे कुछ सुनेगो उईच कहेगो, अर आन वाली बात हुन तुमका बताएगो। ");
INSERT INTO hlb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","उ मोरी बड़ाई करेगों, काहेकि उ मोरी बात म से लेका तुमका बताएगो। ");
INSERT INTO hlb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","जे कुछ परमेस्वर बाप को हैं, उ सब मोरो हैं; एकोलाने मी न कय्हो कि उ मोरी बात हुन म से लेका तुमका बताएगो। ");
INSERT INTO hlb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“थोड़ी देर म तुम मोखा नी देखन ख, अर फिर थोड़ी देर म मोखा देखेगो।” ");
INSERT INTO hlb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","तब ओखा कुछ चेला हुन न एक दुसरा से बोल्या, “यू का हैं जे उ हम से बोला हैं, ‘थोड़ी देर म तुम मोखा नी देखन का, अर फिर थोड़ी देर म मोखा देखेगो?’ अर यू एकोलाने कि मी परमेस्वर बाप को जोने जाऊ हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","तब उनना कय्हो, “यू ‘थोड़ी देर’ जाऊ बोला हैं, का बात आय? हम नी जाना कि उ का बोला हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","यीसु न यू जानका कि वी मोसे पूछनो चाहवा हैं, उनसे कय्हो, “का तुम एक दुसरा म मोरी या बात को बारे म पूछा पिछु करा हैं, ‘थोड़ी देर म तुम मोखा नी देखन का, अर फिर थोड़ी देर म मोखा देखेगो’?” ");
INSERT INTO hlb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","मी तुम से सच्ची सच्ची कहूँ हैं कि तुम रोएगो अर पछताएगो, पर दुनिया खुसी मनाएगो; तुम ख चिन्ता होएगो, पर तुमरो दुख खुसी म बदल जाएगो। ");
INSERT INTO hlb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","बालबच्चा पैदा होन की घड़ी ओरत का दुख होवा हैं, काहेकि ओकी दुख की घड़ी आ जावा हैं, पर जब वा अवलाद का जनम दे देवा हैं, ते या खुसी से कि दुनिया म एक अवलाद पैदा भयो हैं, उ दुख का फिर याद नी करा। ");
INSERT INTO hlb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","वसो ही तरीका से तुम सब अबा दुख म हैं, पर मी तुम ख फिर से देखुगो अर तुमरो मन खूसी से भर जाएगो; अर तुमरी खुसी कोई तुम से छीन नी सकन को। ");
INSERT INTO hlb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","उ दिन तुम मोसे कुछ नी पूछेगो। मी तुम से सच्ची सच्ची कहूँ हैं, अदि परमेस्वर बाप से कुछ मागे, ते उ मोरो नाम से तुमका देहेगो। ");
INSERT INTO hlb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","अबा तक तुम न मोरो नाम से कुछ नी माँगियो हैं; माँगो, ते पायगो ताकि तुम्हारी खुसी पुरी हो जाए। ");
INSERT INTO hlb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“मी न या बात तुम से उदाहरन म कही हैं, पर उ बखत आवा हैं कि मी तुम से फिर उदाहरन म नी कहन को, पर खोलका तुमका परमेस्वर बाप को बारे म बताऊँगो। ");
INSERT INTO hlb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","उ दिन तुम मोरो नाम से माँगेगो; अर मी तुम से असो नी कहत आय कि मी तुम्हारो लाने परमेस्वर बाप से विनती करुँगो; ");
INSERT INTO hlb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","काहेकि परमेस्वर तो अपनो तुम ही तुम से प्रेम रखा हैं, एकोलाने कि तुम न मोसे रखो हैं अर यू भी भरोसा करो हैं कि मी परमेस्वर बाप की तरफ से आयो। ");
INSERT INTO hlb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","मी परमेस्वर बाप कि ओर से दुनिया म आयो हैं; मी फिर दुनिया का छोडका परमेस्वर बाप को जोने जाऊ हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ओखा चेला हुन न कय्हो, “देख, अब तो तू खोल ख बोला हैं, अर कोई उदाहरन नी बोला। ");
INSERT INTO hlb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","अब हम जान गया हैं कि तू सब कुछ जाना हैं, अर ऐकी जरूरत नी कि कोई तो से कुछ पूछे; येसे हम भरोसा करा हैं कि तू परमेस्वर कि तरफ से आयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","असो सुन ख यीसु न उनसे कय्हो, “का तुम अब भरोसा करा हैं? ");
INSERT INTO hlb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","देखो उ बखत आवा हैं वरन आ पहुँचयो हैं कि तुम सब तीतीर-बितर हो ख अपनो-अपनो रस्ता लेहे, अर मोखा अकेलो छोड़ देहे; तेभी मी अकेलो नी काहेकि परमेस्वर बाप मोरो संग म हैं। ");
INSERT INTO hlb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","मी न या बात हुन तुम से एकोलाने कही हैं कि तुमका मोरो म सान्ति मिले। दुनिया म तुमका दुख होवा हैं, पर हिम्मत बाँधी, मी न दुनिया ख जीत लियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","यीसु न या बात कही अर अपनी आँखी बददल या स्वर्ग कि तरफ उठा ख कय्हो, “बाप, वा घड़ी आ गई हैं; अपनो पोरिया कि महिमा कर कि पोरिया भी तोरी महेमा करे।” ");
INSERT INTO hlb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","काहेकि तुना ओखा सबरा इंसान हुन पर हक दियो हैं, कि जिनका तुना ओखा दियो हैं वी सबका उ अनन्त काल को जीवन देहे। ");
INSERT INTO hlb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","अर अनन्त काल को जीवन यू हैं कि वी तू अकेलो मातर सच्चो परमेस्वर ख अर प्रभु यीसु मसी ख, जेका तुना भेजो हैं, जाने। ");
INSERT INTO hlb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","जे काम तुना मोखा करन का दियो रह, ओखा पुरो कर ख मीना दुनिया म तोरी महिमा करी हैं। ");
INSERT INTO hlb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","अब तु, बाप, अपनो संग म मोरी महिमा वा महिमा से कर जे दुनिया बनानो से पहले, मोरी तोरो संग म हती। ");
INSERT INTO hlb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“मीना तोरो नाम वी इंसान हुन पर परघट करयो हैं जिनका तूना दुनिया म से मोखा दियो। वी तोरा हता अर तुना उनका मोखा दियो, अर विन्ना तोरो वचन ख मान लियो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","अब वी समझ गया हैं कि जे कुछ तुना मोखा दियो हैं उ सब तोरी तरफ से हैं; ");
INSERT INTO hlb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","काहेकि जे वचन तुना मोखा दियो, मीना उनका पहुँचा दियो; अर उनना उनका अपना लियो, अर सच्ची-सच्ची जान लियो हैं कि मी तोरी तरफ से आयो हैं, अर भरोसा कर लियो हैं कि तू न ही मोखा सच्ची म भेज्यो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","मी उनको लाने भी बिनती करूँ हैं; दुनिया को लाने विनती नी करूँ पर उनको ही लाने जिनका तू न मोखा दियो हैं काहेकि वी तोरा हैं; ");
INSERT INTO hlb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","अर जो कुछ मोरो हैं उ सब तोरो हैं, अर जे तोरो हैं उ मोरो हैं, अर ऐसे मोरी महिमा परगट भई हैं। ");
INSERT INTO hlb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","मी अब दुनिया म नी रहन को, पर यी दुनिया म रहेगो, अर मी तोरो कने आऊ हैं। अरे सुध्द बाप, अपनो उ नाम से जे तू न मोखा दियो हैं, उनकी देख भाल कर कि जसा अपुन एक हैं वी अपनो समान एक रहे। ");
INSERT INTO hlb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","जब लक मी उनको संग म रयो, ते मीना तोरो उ नाम से, जे तुना मोखा दियो हैं मीना उनकी देख भाल करी की, नास करन वालो को पोरिया ख छोड़ उनमा से कोई नास नी भया, एकोलाने कि सुध्द सास्र म जे कय्हो गयो उ पूरो होय। ");
INSERT INTO hlb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","अब मी तोरो कने आऊ हैं, अर यी बात हुन दुनिया म कहूँ हैं, कि वी मोरी खुसी अपनो म पुरी पायो। ");
INSERT INTO hlb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","मीना तोरो वचन उनका सुना दियो हैं; अर दुनिया न उनसे बैर करियो, काहेकि जसो मी दुनिया को नी, वसा ही वी भी दुनिया का नी हाय। ");
INSERT INTO hlb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","मी असी विनती नी करूँ कि तू उन ख दुनिया म से उठा ला; पर या कि तू उनका बुराई से बचा ख रख। ");
INSERT INTO hlb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","जसो मी दुनिया को नी हाँय, वसा ही वी भी दुनिया ख नी हाँय। ");
INSERT INTO hlb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","तू सत्य को दुवारा उनका सुध्द कर: तोरो बचन सत्य हैं। ");
INSERT INTO hlb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","जसो तू न मोखा दुनिया म भेजो, वसो ही मी न भी उनका दुनिया म भेज्यो; ");
INSERT INTO hlb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","अर उनको लाने मी अपनो तुम ख सोउप देऊ हैं, ताकि वी भी सही को दुवारा सोउप दिया जाय। ");
INSERT INTO hlb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","मी सिर्फ इनको लाने विनती नी करुँ, पर उनको लाने भी जे इनको वचन को वजेसे मोरो ऊपर भरोसा करे।, ");
INSERT INTO hlb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","कि वी सब एक होय; जसो तू बाप मोरो म हैं, अर मी तोरो म हैं, वसा ही वी भी हम म एक होय, जे से पुरी दुनिया भरोसा करे कि तुना ही मोखा भेजो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","वा महिमा जे तूना मोखा दी मी न भी उनका दे दी हैं, कि वी वसा ही एक होय जसा कि अपुन एक हैं, ");
INSERT INTO hlb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","मी उन म अर तू मोरो म जसो कि वी पुरो तरीका से नेक बन ख एक हो जाय, अर दुनिया यू जान लेहे कि तुना ही मोखा भेज्यो हैं, अर जसो तरीका से तुना मोसे प्रेम रखियो हैं, उसी ही तरीका से ओ ना भी प्रेम रखियो। ");
INSERT INTO hlb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","परमेस्वर बाप! मी चाहूँ हैं कि जिनका तुना मोखा दियो हैं, वी जीते मी हैं मोरो संग रहे, जसो वी मोरी वा महेमा का देखे जे तुना मोखा दी हैं, काहेकि तूना दुनिया बनानो से पहले मोसे प्रेम रखो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“अरे धर्मी परमेस्वर बाप, दुनिया न मोखा नी जानो, पर मी न तोखा जानयो; अर वी जान गया कि तुना मोखा भेज्यो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","मीना उनका तोरो नाम बतायो हैं अऊर बताते रहूंगो, जसो तुना जो प्रेम मोखा दियो, उ प्रेम उनमा बनो रहे अऊर मी भी ओमन बनो रहू।” ");
INSERT INTO hlb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","यीसु या बात बोल ख अपना चेला को संग किद्रोन नाला को पार गयो। वहाँ एक बगीचा हतो, जेमा उ अर ओखा चेला गया। ");
INSERT INTO hlb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ओखा पकड़वान वालो यहूदा भी वा जगा जानत रह, काहेकि यीसु अपना चेला हुन को संग वहाँ जाते रहत रह। ");
INSERT INTO hlb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","तब यहूदा, सिपाई हुन को एक दल का अर मेन पुजारी हुन अर फरीसी हुन की तरफ से पैदल चलन वाला ख लेका दिया वालो टेमा अर धुंधरी हुन अर हथियार लट्ठा ख लेखा वहाँ आया। ");
INSERT INTO hlb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","तब यीसु वी सब बात ख जे ओपर आन वाली हती जान ख, निकलो अर उनसे कय्हो, “कोखा ढूँढ़ा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","उनना ओखा जवाब दियो, “यीसु नासरी ख”। यीसु न उनसे कय्हो, “मी आय।” ओखा पकड़वान वालो यहूदा भी उनको संग म खड़ो हतो। ");
INSERT INTO hlb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","जब यीसु न उनसे बोल्यो, ओको यू बोलते ही, “मी आय,” वी पीछु हट ख जमीन पा गीर पड़या। ");
INSERT INTO hlb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","तब यीसु न फिर उनसे पुछो, “तुम कोखा ढूँढ़ा हैं।” वी बोल्या, “यीसु नासरी ख।” ");
INSERT INTO hlb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","येपर यीसु न जुवाब दियो, “मीना तो तुम से कैय दियो हैं कि मी उइच आय, अदि तुम मोखा ढूँढ़ा हैं, ते इनका जान देव।” ");
INSERT INTO hlb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","यू एकोलाने भयो कि यीसु की कही बात पूरो हो जाय: “जिनका तुना मोखा सोपियो, उनमा से मीना एक का भी नास नी होन दियो।” ");
INSERT INTO hlb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","तब समोन पतरस को जोने एक तलवार हती, ओ ना तरवाल खीची अर बड़ो पुजारी को नउकर पर घूमा ख ओको जेवनो वालो कान काट ड़ाल्यो। उ सेवक को नाम मलखुस हतो। ");
INSERT INTO hlb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","तब यीसु न पतरस से कय्हो, “अपनी तलवार म्यान म धर ला। जे कटोरा परमेस्वर बाप न मोखा दियो हैं, का मी ओखा नी पीऊ?” ");
INSERT INTO hlb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","तब सिपाई हुन अर उनका सरदार अर यहूदी हुन ख पैदल चलन वाला न यीसु का पकड़ ख बाँध लियो।, ");
INSERT INTO hlb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","अर वी पहले ओखा पकड़ ख हन्ना को जोने ले गया, काहेकि हन्ना उ साल को मेन पुजारी काइफा को ससुर हतो। ");
INSERT INTO hlb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","यू उई काइफा हतो, जेना यहूदी नेता हुन ख सलाह दियो थो कि सब इंसान हुन को लाने एक इंसान को मरनू अच्छो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","समोन पतरस अर एक दुसरो चेला भी यीसु को पिछु-पिछु चल दियो। यू चेला मेन पुजारी को जानो पहिचानो हतो, एकोलाने उ यीसु को संग मेन पुजारी को आँगन म घुस गयो।, ");
INSERT INTO hlb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","पर पतरस बाहर दरवाजा पर ही खड़ो रैय गयो। तब उ दुसरो चेला जो बड़ो पुजारी को जानो पहिचानो हतो, बाहर निकलो अर दुवार पालिन से बोल ख पतरस ख भीतर ले आयो। ");
INSERT INTO hlb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ऐपर वा दासी न जे दुवार पालिन हती, पतरस से कही, “कही तू भी यू इंसान को चेला म से तो नी आय?” पतरस न कही, “नी, मी नी आय।” ");
INSERT INTO hlb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","नउकर अर पैदल चलन वाला सिपाई ठण्डी को कारन आँगी जला ख खड़ा हो ख आँग तापत रह, अर पतरस भी उनको संग खड़ो हो ख आँग तापत रह हतो ");
INSERT INTO hlb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","तब मेन पुजारी न यीसु से ओखा चेला को बारे म अर ओको ग्यान को बारे म पुछियो। ");
INSERT INTO hlb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","यीसु न ओखा जवाब दियो, “मीना हमेसा दुनिया म इंसान हुन से खुल का बात करी हैं। हमेसा मीना प्रार्थना घर अर मन्दिर म, जेमा सब यहूदी हुन एक जुट होत रह, ग्यान सिखायो हैं मीना कई भी लूका ख कुछ नी बोल्यो हैं। ");
INSERT INTO hlb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","फिर तू मोसे काहे पूछा हैं? मीना का बोल्यो हैं उनसे पूछ जिनको जोने मीना कही हैं। मीना का कही, हकीगत वी जाना हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","जब ओ ना असो कही, ते मन्दिर को एक पैरा देन वालो सिपाई न, जो वही खड़ो थो, यीसु का एक चाटा मारयो अऊर बोल्यो, “तुना महा याजक का असो बोलन कि हिम्मत कसो करी?” ");
INSERT INTO hlb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","यीसु न ओखा जवाब दियो, “अदि मी न कुछ बुरो कही हैं, ते वा बुराई को बारे म गवाई दे अऊर बता कि ओमा बुराई का है, पर अदि मीना भलो कही हैं, ते तू मोखा काहे मारा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","फिर हन्ना न ओखा बंधियो-बाँधियो ही काइफा महा याजक कैफा को जोने भेज दियो। ");
INSERT INTO hlb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","जब समोन पतरस खड़ो हो ख आँग तापत रह। ते ओसे पुछो गयो, “कही तू भी ओको चेला म से तो एक नी आय?” ओ ना इंकार कर ख कही, “नी मी नी आय।” ");
INSERT INTO hlb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","बड़ो पुजारी को दास हुन म से एक, जो ओको कुटुम्ब म से हतो जेको कान पतरस न काट ड़ाल्यो रह, बोलो, “का मीना तोखा ओको संग बगीचा म नी देखो रह?” ");
INSERT INTO hlb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ऐपर पतरस न एक बार फिर इंकार कर दियो, अर तुरत मुर्गा न बाँस दियो। ");
INSERT INTO hlb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","तब वी यीसु का काइफा को घर से रोमी किला म ले गया, सुबेरो को बखत हतो।, यहूदी हुन किला म नी जानो चाहत रहा की कई असुध्द नी हो जाय अऊर फसह को खाना नी खवा जाय। ");
INSERT INTO hlb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","तब पिलातुस उनको जोने बाहर निकल आयो अर बोल्यो, “तुम यू अदमी पर कोन सी बात को आरोप लगावा हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","उनना ओखा जवाब दियो, “अदि यू बुरो काम करन वालो नी होतो ते हम ऐका तोखा नी सोउपता।” ");
INSERT INTO hlb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","येपर पिलातुस न उनसे कही, “ऐका तुम लेका जाव अर अपनो नेम को अनुसार ओको न्याय करो।” यहूदी हुन न ओसे कय्हो, “हमका हक नी हाय कि कोई कि जान लेहे।” ");
INSERT INTO hlb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","यू एकोलाने भयो कि यीसु कि वा बात पूरो होय जे ओ ना या बात करती बखत कही रह कि ओकी माऊत कसी होए। ");
INSERT INTO hlb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","तब पिलातुस फिर किला को भीतर गयो, अर यीसु ख बुला ख ओसे पुछियो, “का तू यहूदी हुन को राजा आय?” ");
INSERT INTO hlb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","यीसु न जवाब दियो, “का तू या बात खुद की तरफ से बोला हैं या दुसरा न मोरो बारे म तोसे यू कहन का कही हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातुस न जवाब दियो, “का तू सोचा हैं कि मी यहूदी आय? तोरी ही जात अर सब बड़ा पुजारी हुन न तोखा मोरो हात सोपियो हैं। तुना का करयो हैं?” ");
INSERT INTO hlb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","यीसु न जवाब दियो, “मोरो राज यू संसार को नी; अदि मोरो राज्य यू संसार को होतो, ते मोरी सेवक मोखा यहूदी हुन को हवाले सोपियो जानो से बचान को लाने लड़ई करता पर हकीगत म मोरो राज्य यहाँ को नी।” ");
INSERT INTO hlb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","येपर पिलातुस न ओसे कही, “ते का तू राजा आय?” यीसु न जवाब दियो, “तू बोला हैं कि मी राजा आय। मी न एकोलाने जनम लियो हैं अर एकोलाने ही मी दुनिया म आयो हैं कि सत्य कि गवाई देऊ। जे कोई सत को हैं, उ मोरो वचन सुना हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पिलातुस न ओसे कही, “सत्य का हैं?” असो बोल ख उ फिर यहूदी हुन को पास निकल गयो अर उनसे कय्हो, “मी तो ओमा कोई खोट नी पात आय। ");
INSERT INTO hlb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","पर तुम्हारी या रीति हैं कि मी फसह म तुमरो लाने एक इंसान ख छोड़ देऊ। अत: का तुम चाहवा हैं कि मी तुमरो लाने यहूदी हुन को राजा ख छोड़ देऊ?” ");
INSERT INTO hlb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","तब उन न फिर चिल्लाया ख कय्हो, “एका नी, पर हमरो लाने बरअब्बा ख छोड़ दा।” अर बरअब्बा ड़ाकू हतो। ");
INSERT INTO hlb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","येपर पिलातुस न यीसु ख पकड ख कोड़ा लगवायो। ");
INSERT INTO hlb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","सिपाही हुन न काटा कि डगियान ख मोड़ ख ओको मुकुट गुँथ ख ओकी मुण्ड पा धरयो, अर ओखा बैजनी रंग को कपड़ा पहिनायो, ");
INSERT INTO hlb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","फिर वी उनको जोने आका कहन लग गया, “अरे यहूदी हुन को राजा, प्राणाम!” अर उनना यीसु ख चाटा मारियो। ");
INSERT INTO hlb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","तब पिलातुस फिर राज भवन को बाहर निकल ख अदमी हुन ख कय्हो, “देखो, मी ओखा तुमरो पास फिर बाहर लाऊ हैं; ताकि तुम जाने कि मी ओमा कुछ भी दोस नी पायो।” ");
INSERT INTO hlb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","तब यीसु ख काटा को मुकुट अर बैजनी रंग को कपड़ा पहिना ख बाहर निकलो; अर पिलातुस न उनसे कय्हो, “देखो, यु इंसान!” ");
INSERT INTO hlb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","जब मेन पुजारी हुन अर सिपाई न ओखा देखो, ते चिल्लाया ख कय्हो, “ओखा सूली पर चढ़ा, सुली पर!” पिलातुस न उनसे कय्हो, “तुम ही ओखा लेका क्रूस पर चढ़ावा, काहेकि मी ओमा कोई दोस नी पात आय।” ");
INSERT INTO hlb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहूदी हुन न ओखा जवाब दियो, “हमारो भी नेम हैं अर उ नेम को अनुसार उ जरूर मार दियो जान को लायक हैं, काहेकि ओ ना खुद ख परमेस्वर को पोरिया बनायो।” ");
INSERT INTO hlb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","जब पिलातुस न या बात सुनी ते अऊर भी डर गयो, ");
INSERT INTO hlb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","अर फिर किला को भीतर गयो अर यीसु से कय्हो, “तू कहाँ को आय?” पर यीसु न ओखा कुछ भी जवाब नी दियो। ");
INSERT INTO hlb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ये पर पिलातुस न ओसे कय्हो, “मोसे काहे नी बोला? का तू नी जाना कि तोखा छोड़ देन को हक मोखा हैं, अर तोखा सूली पर चढ़ान को भी मोखा हक हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","यीसु न जवाब दियो, “अदि तोखा ऊपर से नी दियो जातो, ते तोरो मोपर कुछ अधिकार या हक नी होतो; एकोलाने जोना मोखा तोरो हात पकड़वायो हैं ओखा पाप ज्यादा हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ऐपर पिलातुस न ओखा छोड़ देनो चाही, पर यहूदी हुन न चिल्ला-चिल्ला ख कही, “अदि तू ऐका छोड़ देहेगो, ते तोरी कैसर राजा को संग तोरी दोस्ती नी। जे कोई खुद ख राजा बनावा हैं उ कैसर को सामना करेगों।” ");
INSERT INTO hlb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","असी बात ख सुन कर पिलातुस यीसु ख बाहर लायो अर वा जगह एक चबूतरा हतो जो इब्रानी म गब्बता कहलावा हैं, अर उ न्याय आसन पर बैठो। ");
INSERT INTO hlb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","यू फसह की तैयारी को दिन हतो, अर छटवा घण्टा को लग भग हतो तब ओ ना यहूदी हुन से कही, “देखो तुमारो राजा!” ");
INSERT INTO hlb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","पर वी चिल्लाया, “लेका जा! लेका जा! ओखा सुली पर चढ़ा!” पिलातुस न उनसे कही, “का मी तुमरो राजा ख सूली पर चढ़ाऊ?” मेन पुजारी हुन न जवाब दियो, “कैसर ख छोड़ हमरो अर कोई राजा नी।” ");
INSERT INTO hlb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","तब ओ ना ओखा उनको हात सोउप दियो ताकि यीसु सूली पर चढ़ायो जाए। ");
INSERT INTO hlb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","तब वी यीसु ख ले गया, अर यीसु अपनो सूली उठा ख वा जगा तक बहार गयो, जे खोपड़ी की जगा कहलावा हैं अर इब्रानी म गुलगुता कहलाय हैं। ");
INSERT INTO hlb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","उते उनना यीसु का अर ओको संग अर दो इंसान हुन का सूली पर चढ़ायो, एक का इतेबाजु अर एक का उतेबाजु, अर बीच म यीसु ख। ");
INSERT INTO hlb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पिलातुस न एक दोस वाली चिठ्टी भी लिख ख सूली पर लगवा दियो, अर ओमा यू लिखियो हतो, “यीसु नासरी, यहूदी हुन को राजा आय।” ");
INSERT INTO hlb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","या दोस वाली चिठ्टी डेर सारा यहूदी हुन न पढ़ियो, काहेकि उ स्थान जहाँ यीसु सूली पर चढ़ायो गयो हतो नगर को पास हतो; अर चिट्ठी इब्रानी अर लतीनी अर यूनानी म लिखी हती रह। ");
INSERT INTO hlb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","तब यहूदी हुन को मेन पुजारी न पिलातुस से कही, “यहूदी हुन को राजा मत लिखा पर यू कि ‘ओ ना कय्हो, मी यहूदी हुन को राजा हैं’।” ");
INSERT INTO hlb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पिलातुस न जवाब दियो, “मी न जो लिख दियो, उ लिख दियो।” ");
INSERT INTO hlb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","जब सैनिक यीसु ख सूली पर चढ़ा चुक्या, ते ओखा कपड़ा लेका चार भाग करया, हर सैनिक को लाने एक भाग, अर कुरता भी लियो, पर कुरता बीन सीअन ऊपर से नीचु तक बुनो हुयो हतो। ");
INSERT INTO hlb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","एकोलाने उन न आपस म कही, हम ऐका नी फाड़ा, पर ऐपर चिट्ठी ड़ाले कि यू कोन को होए। यू एकोलाने भयो कि सुध्द सास्र म जो कय्हो गयो उ पूरो होय “उनना मोरा कपड़ा आपस म बाँट लियो अर मोरो कपड़ा पर चिठ्टी डाली।” एकोलाने उनना आपस म कही, “हम ऐका नी फाड़ा, पर ऐपर चिट्ठी ड़ाले कि यू कोन को होऐ।” यू एकोलाने भयो कि सुध्दसास्र म जो कय्हो गयो उ पुरो होय। “उन ना मोरा कपड़ा आपस म बाँट लियो अर मोरो कपड़ा पर चिठ्टी डाली।” ");
INSERT INTO hlb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","अत: सैनिक हुन न असो ही करो। यीसु को सूली को पास ओकी माय, अर ओकी माय कि बहिन क्लोपास की घरवाली मरियम, अर मरियम मगदलीनी खड़ी हती। ");
INSERT INTO hlb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","जब यीसु न अपनी माय, अर उ चेला ख जे से उ प्रेम रखत रह हतो पास म खड़ो देख्यो ते अपनी माय से कही, “ओ बाई, देख यू तोरो पोरिया आय।” ");
INSERT INTO hlb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","तब ओ ना चेला से कय्हो, “या तोरी माय आय।” अर उत्ती बखत से उ चेला ओखा अपनो घर ले गयो। ");
INSERT INTO hlb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","एकोबाद यीसु न यू जान ख कि अब सब कुछ पुरो हो चुक्यो, एकोलाने कि सुध्द सास्र म जो कय्हो गयो हैं उ पुरो होय, कय्हो, “मोखा प्यास लगी हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","वहाँ सिरका से भरयो एक बरतन रख्यो हतो, तब उनना सिरका म भिगयो हुयो स्पंज ख चाटला म रख ख ओको मुंडो से लगायो। ");
INSERT INTO hlb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","जब यीसु न उ सिरका लियो, ते कही, “पुरो भयो” अर मुण्डी नीचु कर ख जान छोड़ दियो। ");
INSERT INTO hlb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","एकोलाने कि उ तैयारी को दिन हतो, यहूदी हुन न पिलातुस से पूछो की उनकी टाँग तोड़ दीयो जाय अर वी उतारा जाय, ताकि आराम को दिन उनको सरीर सूली पर नी रहनो चाहिये, काहेकि उ हफ्ता को दिन बड़ो दिन हतो। ");
INSERT INTO hlb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","अत: सैनिक हुन न आ ख वी अदमी म से पहिलो कि टाँग हुन तोड़ी फिर दुसरो की भी टोड़ दी, जे यीसु को संग सुली पर चढायो गया हता; ");
INSERT INTO hlb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","पर जब उनना यीसु को जोने आ ख देख्यो कि उ मर चुकियो हैं, ते उनना ओकी टाँग नी तोड़ी। ");
INSERT INTO hlb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","पर सैनिक हुन म से एक न ओकी पसली म बल्लम से मारियो अर ओमन से तुरत खून अर पानी बहिन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","जोना यू देखो, ओ ना येकी गवाई दी हैं, अर ओकी गवाई सच्ची हैं; अर उ जाना हैं कि उ सच्ची बोला हैं कि तुम भी भरोसा करो। ");
INSERT INTO hlb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","या बात हुन एकोलाने भई कि सुध्द सास्र म जो कय्हो गयो वचन हैं उ पूरो हो जाय, “ओकी एक भी हड्डी टोड़ी नी जान की।” ");
INSERT INTO hlb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","फिर एक अऊर जगह पर सुध्द सास्र म यू लिखो हैं, “जोका उन ना भेदो हैं, ओखा वी देखेगो।” ");
INSERT INTO hlb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","असी बात हुन को बाद अरिमतिया गाँव को यूसुफ न जो यीसु को चेला हतो रह, पर यहूदी हुन को डर से यीसु को अंदरोनी चेला हतो, पिलातुस से यीसु को सरीर ख उतार लेन कि विनती करी। पिलातुस न ओखा अनुमती दे दियो। एकोलाने यूसुफ आ ख यीसु को सरीर ख ले गयो। ");
INSERT INTO hlb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","नीकुदेमुस भी पहुँचियो, जो पहले यीसु को जोने रात को घड़ी मिलन ख आयो रह, पचास सेर को लग भग मिल्यो वालो गन्धरस अर लोबान लेका आयो। ");
INSERT INTO hlb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","तब उनना यीसु को सरीर लियो, अर यहूदी हुन कि गाड़न कि रीति-रिवाज को अनुसार ओखा खुब मेहकन वालो इतर को संग कपड़ा म लपेटियो। ");
INSERT INTO hlb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","वा जगा पर जहाँ यीसु सूली पर चढ़ायो गयो रह, एक बगीचा हतो, अर वा बारी म एक नयो मरघट हतो जेमा कभी कोई नी रखो गयो रह। ");
INSERT INTO hlb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","एकोलाने यहूदी हुन कि तैयारी को दिन को कारन उनना यीसु ख ओमा ही धरियो, काहेकि वा मरघट जोने हती। ");
INSERT INTO hlb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","हफ्ता को पहिलो दिन मरियम मगदलीनी सुबेरे ख अंधेरा रहते ही मरघट म आई, अर पत्थर का मरघट से हटीयो देखो। ");
INSERT INTO hlb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","तब वा या देख ख दऊड़ी अर समोन पतरस अर उ दुसरो चेला को जोने जो से यीसु प्रेम रखत रह, मरियम न ओसे कही, “वी प्रभु ख मरघट म से उठा ख ले गया हैं, अर हम नी जाना कि उनना ओखा किते रख दियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","तब पतरस अर उ दुसरो चेला निकल ख मरघट की तरफ चल्या। ");
INSERT INTO hlb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","वी दोई संग-संग भक्ते जात रह, पर दुसरो चेला पतरस से आगे बढ़ ख मरघट म पहले पहुँचियो; ");
INSERT INTO hlb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ओ ना नीउड ख यू देखियो कि कपड़ा पड़िया हैं, तेभी उ मरघट म भीतर नी आयो। ");
INSERT INTO hlb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","तब समोन पतरस ओको पिछु-पिछु पहुँचियो, अर मरघट को भीतर गयो अर ओ ना कपड़ा पड़ीयो देखो; ");
INSERT INTO hlb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","अर उ अंगोछा जे यीसु की मुंढ से बंधियो हतो, कपड़ा को संग म पड़ीयो हुयो नी पर अलग एक जगा गुमंड ख रखियो हुयो देखो। ");
INSERT INTO hlb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","तब उ दुसरो चेला भी जे मरघट म पहिले पहुँचियो हतो, भीतर गयो ओ ना देखियो अर भरोसा करियो। ");
INSERT INTO hlb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","काहेकि वी तो अबा लक सुध्द सास्र को उ लेख अबा लक नी समज पाया रहा जेको हिसाब से यीसु को मुर्दा म से जिन्दो होनू जरूरी हतो। ");
INSERT INTO hlb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","तब यी चेला अपना घर ख लउट गया। ");
INSERT INTO hlb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","पर मरियम रोते-रोते मरघट को पास म ही बाहर खड़ी हती, अर रोते-रोते मरघट कि तरफ नीउड ख, मरघट को भीतर नजर घुमई। ");
INSERT INTO hlb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","दो स्वर्ग दूत हुन ख उजरो कपड़ा पहिनिया हुयो एक ख सिराना तरफ अर दुसरा ख पाय तरफ बठीयो देखो, जिते यीसु को सरीर रखियो हतो रहा। ");
INSERT INTO hlb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","दूत हुन न ओसे कही, “अरे बाई तू काहे रोवा हैं?” ओ ना उनसे कही, “वी मोरो प्रभु ख उठा ख ले गया अर मी नी जानु कि उनना ओखा कहाँ धरीयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","या कैय ख वा पिछु घुमी अर यीसु ख खड़ो देखी, पर नी पहिचानी कि यू यीसु आय। ");
INSERT INTO hlb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","यीसु न उनसे कय्हो, “अरे बाई, तू काहे ख रोवा हैं?” कोन ख ढूँढा हैं? ओ न माली समझ ख ओसे कय्हो, “अरे प्रभु, अदि तू न ओखा उठा लियो हैं ते मोखा बता कि ओखा कहाँ धरीयो हैं, अर मी ओखा ले जाऊ।” ");
INSERT INTO hlb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","यीसु न ओसे कय्हो, “मरियम!” ओ न पीछु घुम ख ओसे इब्रानी म कय्हो, “रब्बूनी” एकोमतलब “अरे प्रभु।” ");
INSERT INTO hlb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","यीसु न ओसे कय्हो, “मोखा पाय पकड़ ख मत रोको, काहेकि मी अबा लक परमेस्वर बाप को जोने ऊपर नी गयो हैं, मोरा भई हुन को जोने जाव अर उनसे असो कहनो कि मी अपनो परमेस्वर बाप अर तुम्हारो परमेस्वर बाप, अर अपनो परमेस्वर अर तुमारो परमेस्वर को पास ऊपर जा रयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","मरियम मगदलीनी न जा ख चेला ख या खबर बतायो, “मी न प्रभु ख देख्यो हैं, अर ओ ना मोसे या बात हुन कही हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","उई दिन जो हफ्ता को पहिलो दिन हतो, साम को बखत जब वहाँ ख दरवाजा जीते चेला हता, यहूदी हुन को डर को मारे बन्द हता, तब यीसु आयो अर उनको बीच म खड़ो हो ख उनसे कय्हो, “तुम ख सान्ति मिले।” ");
INSERT INTO hlb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","अर यू बोल ख ओ न अपनो हात अर अपनो पसली को घाव उन ख दिखायो। तब चेला प्रभु ख देख ख खुस भया। ");
INSERT INTO hlb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","यीसु न फिर उनसे कय्हो, “तुमका सान्ति मिले; जसो परमेस्वर बाप न मोखा भेजो हैं, वसो ही मी भी तुम ख भेजू हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","यू बोल का ओ न उन पर फूँको अर उन से कय्हो, “सुध्द आत्मा लेव। ");
INSERT INTO hlb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","जिनको पाप तुम माप करे, वी उनको लाने माप करा गया हैं; जिनको तुम रखे वी रखिया गया हैं।” ");
INSERT INTO hlb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","पर बारा हुन म से एक, एकोमतलब थोमा जेखा दिदुमुस बोलो जाय हैं, जब यीसु आयो ते उनको संग नी हतो। ");
INSERT INTO hlb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","जब दुसरा चेला ओसे कहन लग गया, “हम न प्रभु ख देखो हैं,” तब ओ न उनसे कय्हो, “जब तक मी ओखा हात हुन म खिल्ला हुन को छेद नी देख लेहूँ, अर ओको पंजा म अपनो हात नी डाल लेहूँ, तब तक मी भरोसा नी करन को।” ");
INSERT INTO hlb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","आठ रोज को बाद फिर चेला हुन घर को भीतर हता, अर थोमा उनको संग थो; अर दरवाजा बन्द हता, तब यीसु आयो अर उनको बीच म खड़ो होका कय्हो, “तुम ख सान्ति मिले।” ");
INSERT INTO hlb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","तब ओ ना थोमा से कय्हो, “तोरी उँगली यहाँ लाखा मोरा हात ख देख अर अपनो हात लाखा मोरी पसली म ड़ाल, अर संका अविस्वासी नी पर भरोसा करन वालो बन।” ");
INSERT INTO hlb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","यू सुन ख थोमा न जवाब दियो, “अरे मोरो प्रभु, अरे मोरो परमेस्वर!” ");
INSERT INTO hlb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","यीसु न ओसे कय्हो, “तू न मोखा देखो हैं, का एकोलाने भरोसा करयो हैं? धन्य वी हैं जिन्ना बिना देखो भरोसा करयो।” ");
INSERT INTO hlb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","यीसु न अऊर भी ढ़ेर सारा चिन्ह चेला को सामने दिखायो, जो या किताब म लिखया नी गया; ");
INSERT INTO hlb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","पर यी एकोलाने लिखया गया हैं कि तुम भरोसा करे कि यीसु मसी ही परमेस्वर को पोरिया आय, अर भरोसा कर ख ओको नाम से जीवन पाव। ");
INSERT INTO hlb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","या बात हुन को बाद यीसु न अपनो तुम ख तिबिरियास झील को किनार म फिर से अपना चेला ख दिखई दियो यू असो तरीका से भयो ");
INSERT INTO hlb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","समोन पतरस, अर थोमा जेखा दिदुमुस बोला हैं, अऊर गलील को काना नगर को नतनएल, अर जबदी को पोरिया, अर ओखा चेला हुन म से दो अऊर झन इकट्ठा हता। ");
INSERT INTO hlb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","समोन पतरस न उनसे कय्हो, मी मच्छी पकड़न ख जा रयो हैं। उनना ओसे कही, “हम भी तोरो संग चला हैं।” एकोबाद वी नाव पा चढ़ीया, पर वा रात कुछ नी पकड़ीयो। ");
INSERT INTO hlb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","भुनसारो होत ही रहा कि यीसु किनार पर आका खड़ो भयो; तेभी चेला हुन न नी पहिचानियो कि यू यीसु आय। ");
INSERT INTO hlb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","तब जा ख यीसु न उन से कय्हो, “अरे पोरिया हुन, का तुमारो जोने जरासी (थोड़ी) मच्छी हुन हैं?” उन ना जवाब दियो, “नी हाय।” ");
INSERT INTO hlb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","उनसे कही, “नाव को सिधो हात बाजू जाल ड़ालनू ते मिले।” एको बाद उन ना जाल ड़ालो, अर मच्छी ढ़ेर सारी होन को कारन ओखा खीच नी सक्या। ");
INSERT INTO hlb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","एकोबाद उ चेला न जसो यीसु प्रेम रखत रह हतो, पतरस से कय्हो, “यू तो प्रभु आय!” समोन पतरस न यू सुन ख कि “उ प्रभु आय!” कम्मर म अंगोछा कस लियो, काहेकि उ नंगो हतो, अर झील म कूद पड़ीयो। ");
INSERT INTO hlb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","पर दुसरा चेला ड़ोगी या नाव पर मच्छी हुन से भरीयो वालो जाल खीचते-खाचते लाया, काहेकि वी किनार से जादा दुर की जगह पर नी हता, पर थोडी कुछ दुर दो सव हात पर हता। ");
INSERT INTO hlb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","जब वी वा जगह की किनार पर उतरियो, ते उन ना कोयला कि आग अर ओपर मच्छी धरी, अर रोटी देखी। ");
INSERT INTO hlb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","यीसु न उन से कय्हो, “जे मच्छी हुन तुम न अब्बी पकड़ी हैं उनमा से कुछ लाव।” ");
INSERT INTO hlb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ते समोन पतरस न ड़ोगी पर चढ़ ख जाल किनार म खीच लायो ओमन एक सव तिरेपन बड़ी मच्छी हुन हती अऊर इत्ती मच्छी हुन होनो पर भी जाल नी फटीयो। ");
INSERT INTO hlb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","यीसु न उनसे कय्हो, “आव, खाना खाहे।” चेला म से कोई की हिम्मत नी भई कि ओसे कुछ पूछे, “तू कोन आय?” काहेकि वी जानत रह कि यू प्रभु ही हो सका हैं। ");
INSERT INTO hlb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","यीसु आयो अर उन ख रोटी लेखा उनका दी, अर वसो ही मच्छी भी। ");
INSERT INTO hlb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","यू तीसरी बार आय कि यीसु मरो म से जिन्दो होन को बाद चेला ख दिखाई दियो। ");
INSERT INTO hlb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","खाना खान को बाद यीसु न समोन पतरस से कही, “अरे समोन, यूहन्ना को पोरिया, का तू इन से बढ़ ख मोसे प्रेम करा हैं?” ओ न ओसे कय्हो, “हव, प्रभु; तू तो जाना हैं कि मी तो से प्यार करू हैं।” ओ न ओसे कय्हो, “मोरा मेम्ना हुन ख चरा।” ");
INSERT INTO hlb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ओ ना फिर दुसरी बार ओसे कय्हो, अरे समोन यूहन्ना को पोरिया, “का तू मोसे प्रेम रखा हैं?” ओ ना ओसे कय्हो, हव, “प्रभु; तू जाना हैं कि मी तोसे प्यार रखू हैं।” ओ ना ओसे कय्हो, “मोरी भेड़ी हुन की देख रेख कर।” ");
INSERT INTO hlb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ओ ना तीसरी बार ओसे कय्हो, अरे समोन, “यूहन्ना को पोरिया, का तू मोसे प्रेम रखा हैं?” पतरस नाराज भयो कि ओ ना ओसे तीन बार असो कही, “का तू मोसे प्रेम रखा हैं?” अर ओसे कय्हो, “अरे प्रभु, तू तो सब कुछ जाना हैं; तू यू जाना हैं कि मी तो से प्रेम रखू हैं।” यीसु न ओसे कय्हो, “मोरी भेड़ी हुन ख चरा। ");
INSERT INTO hlb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","मी तोसे सच्ची-सच्ची कहूँ हैं, जब तू जवान हतो ते अपनी कम्मर बाँध ख जहाँ इच्छा होत रह वहाँ फिरत रह; पर जब तू सियानो होए ते अपनो हात फैलाहेगो, अर दुसरो तोरी कम्मर बाँध ख जीते तू नी चाहन को वहाँ तोखा ले जाएगो।” ");
INSERT INTO hlb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ओ ना या बात से इसारा दियो कि पतरस कसी माऊत से परमेस्वर कि महिमा या बड़ाई करे। अर तब ओ ना ओसे कय्हो, “मोरो पीछु हो ला।” ");
INSERT INTO hlb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पतरस न घुमका उ चेला ख आते देखो, जसो यीसु प्रेम रखत रह, अर जोना खाना को बखत ओकी छाती की तरफ झुक ख पुछियो रह, “अरे प्रभु, तोखा पकड़ान वालो कोन आय?” ");
INSERT INTO hlb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ओखा देख ख पतरस न यीसु से कही, “अरे प्रभु एको का हाल होए?” ");
INSERT INTO hlb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","यीसु न ओसे कही, “अदि मी चाहूँ की उ मोरो आनो तक रूको रहे, ते तोखा ऐसे का? तू मोरो पीछु हो ला।” ");
INSERT INTO hlb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","एकोलाने भई हुन म या बात फैल गई कि उ चेला नी मरन को; तेभी यीसु न यू नी बोलो की उ चेला नी मरन को, पर यू कि “अदि मी चाहूँ कि उ मोरो आनो तक ठहर ख रहे, ते तोखा ऐसे का?” ");
INSERT INTO hlb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","यू उई चेला आय जे या बात हुन कि गवाई देवा हैं अर जेना या बात हुन ख लिखो हैं, अर हम जाना हैं कि ओकी गवाही सच्ची हैं। ");
INSERT INTO hlb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","यीसु न अऊर भी ढ़ेर सारा काम करीया हैं, अदि एक-एक कर ख उनको बारे म लिखो जातो ते मी समझू हैं कि जो किताब लिखी जावा हैं वी संसार भर म भी नी समाती।");
INSERT INTO hlb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","अरे प्रिय थियुफिलुस, मीना पहलो किताब वी सब बात हुन को बारे म लिखी, जे यीसु न सुरू से करो अर करते अर सिखात रह, ");
INSERT INTO hlb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ओ न उ दिन तक चुने हुन ख सुध्द आत्मा ख दुवारा हुकुम दियो ओखा बाद उजब उ वी प्रेरित हुन का जीन ख ओ ना चुनो हतो, दे ख ओ न ऊपर स्वर्ग म उठायो नी गयो। ");
INSERT INTO hlb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","उ अपनो मरन क बाद उ चालीस दिन तक उ अगल अर तरीका से दिखाई दियो अर प्ररगट हुओ जिन्दो को प्रमाण ते रयो उन न ख देख्यो अर उन से ओ न परमेस्वर को राज्य कि बात करी। ");
INSERT INTO hlb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","अऊर वी ओखा संग जमा हता ते ओ न उन ख आग्या दी यरूसलेम ख मत छोड़ जे बल्कि जे सुध्द आत्मा क बारा म मोसे सुन्यो हैं बाप को उ वादा तुम न पूरो होन को इन्तेजार करजो। ");
INSERT INTO hlb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","“काहेकि यूहन्ना न ते पानी म बपतिस्मा दियो हैं पर थोडो रोज को बाद म यू तुम ख सुध्द आत्मा से बपतिस्मा पाएगो।” ");
INSERT INTO hlb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","जब प्रेरित इकठ्टा होय ख ओसे पुछियो, “हे प्रभु, क तू इ ही बखत इस्राएल का राज्य म फेर देहे?” ");
INSERT INTO hlb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","यीसु न उन से कय्हो, “उ बखत हुन अर तारीक हुन ख जाननो, जेका बाप न अपनो ही हक म रखो हैं। उनख जाननो तुम्हारो काम नी आय। ");
INSERT INTO hlb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","पर जब सुध्द आत्मा तो पर आए तब ते सक्ति पाएगो अर यरूसलेम अऊर सारी यहूदिया अर सामरिया म, अर जमीन का उन छोड़ तक मोरो गवाह होए।” ");
INSERT INTO hlb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","यू कह ख वी उ ख देखत ऊपर उठा लियो, अर बदल न ओको उनकी आँखी हुन से छिपा लियो। ");
INSERT INTO hlb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ओके जात बखत जब वी आकास की ओर ताक रहे हता, ते देख, दो अदमी सफेद कपड़ा पहिनो हुयो उन ख बगंल आए ख खड़ा भया, ");
INSERT INTO hlb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","अर ओ न कय्हो, गलीली व्यक्ति हुन तुम काहे खड़ा हैं आकास को ओर देख रयो हो? यू यीसु, जे तुम्हारो नजीक से स्वर्ग म उठा लियो गयो हैं, “जे रीति से तुम न ओको स्वर्ग का जात देखो हैं उही रीति से फिर ऊही रिती से आपस आएँगो।” ");
INSERT INTO hlb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","तब वी जैतून नामक पहाड़ से जे यरूसलेम सहर क नजीक एक आराम को दिन कि 1 किलो मीटर की दुरी पर हैं, यरूसलेम को लउटियो। ");
INSERT INTO hlb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","जब वी वहाँ पहुँचिया ते उ उपार वाला अटारी प रुकया गया राहा, जाहा पतरस अर यूहन्ना अर याकूब अर अन्द्रियास अर फिलिप्पुस अर थोमा अर बरतुल्मै अर मत्ती अर हलफई को पोरिया याकूब समोन जेलोतेस अर याकूब का पोरया यहूदा रहत रह। ");
INSERT INTO hlb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","यु सब कई बाई हुन अर यीसु की माता मरियम अर ओको भई यी सभी अपनो तुम ख एक संग प्रार्थना म लगायो रहव हैं। ");
INSERT INTO hlb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","कुई दिन बाद म विस्वासी भई हुन की सभा म एक सव बीस अदमी हुन को संख्या हता , पतरस खड़ो होय ख बोलन लगियो, ");
INSERT INTO hlb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“हे भई हुन जरुरी हतो कि सुध्द सास्र को वी लेख पूरो होए जे सुध्द आत्मा न दाऊद क मुँह से यहूदा क बारे म जे यीसु क पकड़न वाला हुन को अगुवा हतो, पहलो से कहयो हतो। ");
INSERT INTO hlb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","यहूदा हमार समूह को सहायक हतो अर इ सेवा म ओको भी सहयोग हतो।” ");
INSERT INTO hlb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“ओ न अधर्म क कमाई से एक खेत मोल लियो, अर सिर क बल गिरियो अर ओको पेट फट गयो अर ओकी सब अन्तड़ियाँ निकल पड़ी। ");
INSERT INTO hlb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","अर यरूसलेम सब रहन वाला जन का मालूम भयो कि ओकी भासा म उ खेत को नाम ‘हकलदमा रखो गयो अर्थात्; खून को खेत’ पड़ गयो।” ");
INSERT INTO hlb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","काहेकि की भजन संहिता कि किताब म लिखो हैं, ओको घर उजड़ जाएगो, अर ओमा कोई नी रहन का अर असो ही लिखो गयो हैं ओकी की जगह कोई भी दुसरो ले लेय। ");
INSERT INTO hlb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","एकोलाने या जरुरी आय कि जब प्रभु यीसु हमारो बिच म हतो जब लोग हुन हमेसा हमरो संग म हता ओ म से कोई एक क चुनो जाय याने उ बखत से लेय ख जब से यूहन्ना का लोग हुन बपतिस्मा देनो सुरूआत करयो रह अर जब तक यीसु क हमारो बीच म से ऊठा लियो गयो हतो उन लोगो म से कोई एक ख ओको बिच म जी उठन को साक्छी होनू चहिये, ");
INSERT INTO hlb_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","उचित हैं कि ओमा से एक अदमी हमारो संग ओको जिन्दो होनो को गवाह हो जाहे ");
INSERT INTO hlb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","तब उन्होना दो व्यक्ति हुन को नाम को सुझाव दियो, एक युसुफ को जो बरसब्बा कहलाता हैं, जेको उपनाम यूस्तुस हैं, दुसरो मत्तियाह का। ");
INSERT INTO hlb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","फिर उन न प्रार्थना करी, “हे प्रभु, तू जे सब ख मन को जाँचन वालो हैं, यू प्रगट कर की इ दोनो जन म से तू न कोको चुनो हैं, ");
INSERT INTO hlb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","कि उ या सेवकाई अर सिखावन देन को पद लेहे, जाहा यहूदा की जगह हती वी चल दियो प चल दियो।” ");
INSERT INTO hlb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","तब उन न उनको बारे म चिट्ठी हुन ड़ाली, अर चिट्ठी मत्तियाह को नाम पा निकल। तब जा ख उ ग्यारह प्रेरित देन वाला को संग म गिनो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","जब फसह पर्व को बाद यहूदी हुन को तिहार को पचासवे दिन आयो, ते सब विस्वासी लोग एक जगह म एकजुट भया। ");
INSERT INTO hlb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","एकदम से आकास से आधी के तुफान के जसो के आवाज आई जे घर म अवाज आई उ जे घर भर गयो बड़ी आवाज अई। ");
INSERT INTO hlb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","अर आगी की फहलती अऊर लपट हुन जसी जीभ हुन सामे दिखई देवन लगी वी आगी अलग अलग जीभ उन म से हर एक प आ टिकी। ");
INSERT INTO hlb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","वी सब दी अर ओमा से भरख गयो, अर जे प्रकार सुध्द आत्मा हैं उन्हे बोलन की सामर्थ्य दी, वी अन्य अन्य भासा हुन बोलन लगिया। ");
INSERT INTO hlb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","आकास को नीचु की हर एक जात म से यहूदी यरूसलेम म रहत रहा। ");
INSERT INTO hlb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","जब वी आवाज गरजो ते एक बडी भीड़ जमा हुई गई वी लोग अचम्भा म पड़ गया विस्वासी भई हुन कि यापन खुद भासा म बोलतो हुओ सुनियो। ");
INSERT INTO hlb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","वी सब चकित अर अचम्भा होय ख कहन लगिया, “देख, जे लोग हुन बोलत रय्हे हैं क सब गलीली प्रांत क ते नी? ");
INSERT INTO hlb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ते फिर हम म से हर एक उनख हमरी अपनी खुद की भासा म कोसे बोलते हुआ कसा सुन रय्हा हैं? ");
INSERT INTO hlb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","हम जे पारथी, अर मेदी अर एलामी, अर मेसोपोटामिया, अर यहूदिया अर कप्पदूकिया, पुन्तुस अर आसिया, ");
INSERT INTO hlb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","अर फूगिया अर पंफूलिया, अर मिसर अर निकट लीबिया को रहन वालो; रोम को यहूदी अर गैर यहूदी कुछ परदेस ख लोग देस जे कुरेने क आसा पास हैं, इ सब देस हुन क रहन वाला अर रोमी प्रवासी, ");
INSERT INTO hlb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","अर्थात् यहूदी अर यहूदी मत धारण करन वाला, क्रेती अर अरबी का रहन वाला हुन हम सब परमेस्वर क आस्चर्य पुरो काम हुन का अपन अपन भासा म सुन रय्ह हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","अर वी सब चकित भया अर संका म पडिया अर एक दूसरा से पूछ रय्ह हता कि, “यू क हो रय्हो हैं?” ");
INSERT INTO hlb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","पर दूसरा लोग हुन न ठठ्टा कर ख कय्हो, “वी ते दारू का नसा म चूर हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","फिर उन न ग्यारह हुन को संग पतरस खड़ो हुओ उचो सब्द सम्बोधित करते हुआ कहन लगया की यहूदी साधि हुन अर यरूसलेम क पुरा निवासी हुन मोरी बात हुन ख अच्छो से सुन अऊर मो ख ओको अर्थ बतावन दा। ");
INSERT INTO hlb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","जसो तुम लोग समझत रह, यू लोग नसे म नी हैं, काहेकि अभी ते भुनसारो को नव बजिया हैं। ");
INSERT INTO hlb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","बल्कि या वा बात हैं, जेको बारा म योएल भविस्यवक्ता न कय्हो हतो: ");
INSERT INTO hlb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“परमेस्वर कहत हैं कि अन्त क दिन हुन म असो होएगो कि मी अपनो आत्मा सब जन हन पर उड़ेलेगो, अर तोरो पोरिया हुन अर तोरी पोरी हुन भविस्यव्दाणी करे अर तोरो जवान हुन दर्सन देखेगो, अर तोरो सियाना हुन सपना देखेगो।” ");
INSERT INTO hlb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","हाँ उ दिन म मी अपना दास हुन अर सेविका हुन पर भी उ दिन हुन म अपन आत्मा म से उँड़ेलूगो, अर वी भी भविस्यव्दाणी करेगों। ");
INSERT INTO hlb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","अर ऊपर आकास म गजब को काम अर नीचो जमीन पर चिखान अर्थात् खून अर आगी अर धूआ को बादल दिखाऊँगो। ");
INSERT INTO hlb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","प्रभु को बड़ो अर उजाला वालो दिन को आनो से पहलो सूरज अंधेरा म अर चंदा खून जसो लाल म बदल जाएगो। ");
INSERT INTO hlb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","अर जे प्रभु को नाम से मदद माँगे हे ओ ख प्रभु बचाएगो, वी उध्दार पाएगो। ");
INSERT INTO hlb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“हे इस्राएली हुन लोगो, यू वचन ख सुनायो: यीसु नासरी एक अदमी हतो जेको परमेस्वर की ओर होन को प्रमाण उ सामर्थ्य क काम हुन अर आस्चर्य क काम हुन अर चिखान हुन से प्रगट हैं जे परमेस्वर न तुमरो बीच ओको व्दारा दिखायो जेसे तुम तुम ही जानत हो।” ");
INSERT INTO hlb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","यु अदमी ख परमेस्वर कि पक्की योजना अर पुरो ग्यान को अनुसार तुम ख सोपयो गयो अर तुम न पापी व्यक्ति हुन कि मदद से ओ ख क्रूस प चडायो अर खिल्ला ठुकवायो अर मार डालयो। ");
INSERT INTO hlb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","पर उही को परमेस्वर न माऊत क बंधन हुन से छुड़ाय ख जिलायो; काहेकि यु अनहोनो हतो। मृत्यु म इत्तती सक्ती नी हती कि ओ ख बंधी बनायो रखे वी ओके बस वंस म रय्हे। ");
INSERT INTO hlb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","काहेकि दाऊद ओके विसय म कहत हैं, मी प्रभु का हमेसा (सर्वदा) अपन सामे देखत रहू काहेकि वी मोरी दाँया ओर हैं, ताकि मी डिग नी जाऊ। ");
INSERT INTO hlb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","इही कारन मोरो मन खुसी आय, अर मोरी जीभ आनन्दित हैं; अऊर मोरो सरीर भी आसा म जिये। ");
INSERT INTO hlb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","काहेकि तू मोरो जान ख अधोलोक म नी छोड़ेगो; अर नी अपन सुध्द जन ख सड़न ही देगो। ");
INSERT INTO hlb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","तू न मोखा जीवन को रस्ता दिखायो हैं; तू मोखा अपन दर्सन ख व्दारा खुसी से भर देगो। ");
INSERT INTO hlb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“अरे लोगो, मी अपनो कुटुम्ब को दाऊद राजा को बारे म तुम से हिम्मत को संग बोल सकू हैं कि उ ते मर गयो अर गाड़ो गयो अर ओकी कब्रर आज तक हमारो येमा आज तक मऊजूद हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","वी एक भविस्यवक्ता हतो अर वी जानत हतो कि परमेस्वर न मोसे कसम को संग म वादा दियो हैं कि वी ओके वंस म से एक ख सिंहासन पर बैठाऊँगो; ");
INSERT INTO hlb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","एकोलाने जे भविस्य मे घटन वाला हैं ओ ख देखत दाऊद न यू कय्हो हतो ओ ख मृत्यु को संसार म नी छोड़ो गयो अर नी ही ओके सरीर का कबर म सड़न रख दियो ते ओ न मसी की जी उठन मसी का फिर से जी उठन को बारे म कय्हो हतो। ");
INSERT INTO hlb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","इही यीसु ख परमेस्वर न जिलाया, अर हम सब बात को गवाह हैं। ");
INSERT INTO hlb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","इ प्रकार परमेस्वर क दाँया हात से सर्वोच्च पद पाय ख, यीसु न पिता बाप से वी सुध्द आत्मा प्राप्त कर ख जेकी वादा (प्रतिग्या) की गई हती, ओ न यू उंडेल दियो हैं जे तुम देखत अर सुनत हो। ");
INSERT INTO hlb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","काहेकि दाऊद ते स्वर्ग पर नी चढ़यो; पर वी तुम कहत हैं, प्रभु से कय्हो, मोरो दाँया बैठ, ");
INSERT INTO hlb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“जब तक कि मी तोरो बैरी हन ख तोरो पाय ताले की चऊकी नी कर दूँ।” ");
INSERT INTO hlb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ऐको लाने इस्राएल को पुरो घराना हकीगत म जान ले कि परमेस्वर न उई यीसु ख जेखा तुम न सूली पर चढ़ायो दियो हता प्रभु भी ठहरायो अर मसी भी ठहरायो हतो। ");
INSERT INTO hlb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","तब सुनन वाला हुन क मन छिद गया अर वी पतरस तथा अर प्रेरित हुन से पूछन लगियो, “हे भई हन, हम क करे?” ");
INSERT INTO hlb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पतरस न ओसे कय्हो, “मन फिराओ, अर अपना पाप हुन माफी पान को लाने तुम म से हर एक ख यीसु मसी क नाम से बपतिस्मा लेनू चहिए; अर तुम ख परमेस्वर को सुध्द आत्मा को वरदान मिलेगो। ");
INSERT INTO hlb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","काहेकि यू प्रतिग्या (वादा) तुम, अर तुम्हरो बच्चे हन, अर उ सब दूर-दूर ख लोग हुन क लियो भी हैं जेको प्रभु हमार परमेस्वर अपन नजीक बुलाएगो।” ");
INSERT INTO hlb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","अर पतरस न ढ़ेर सारो से वचन हुन को व्दारा उनना गवाह दी अर आग्रह को संग ओसे से कय्हो या वंसावली ख अपनो तुम से बचायो रखो, ");
INSERT INTO hlb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","अर बेजा सारे लोग हुन ओको सन्देस सुन ख उन न भरोसा करियो अर उन उ ख बपतिस्मा दियो गयो यु तरीका उन को समूह म अनदाजन तीन हजार लोग हुन जुद गया। ");
INSERT INTO hlb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","अर वी प्रेरित हुन से सिक्छा पान, अर संगति रखन, अर रोटी तोड़न, अर प्रार्थना करन म लोलीन रह। ");
INSERT INTO hlb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","अर सब लोग हुन पर डर छा गयो अर बेजा से अदभुत काम अर चिन्ह प्रेरित हुन को दुवारा प्रगट होवा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","अर सब विस्वासी हमेसा सहभागी म रहवा हतो अऊर उन को जोने जे कुछ अपनो हतो ओ ख अब आपस म बाट लेवत रह। ");
INSERT INTO hlb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","वी अपनी सम्पत्ति समान बेच देवत रह अर आवन वाला पैसा हर एक कि आवस्कता को अनुसार बाट दियो कर हते हैं। ");
INSERT INTO hlb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","वी दिन प्रति वे मन्दिर म समूह म मिलत रह वी अपनो घर हुन म संग म खाना बाँट ख उदार मन से खुसी को संग मिल जुल ख खावत हता, ");
INSERT INTO hlb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","हर दिन प्रभु उन ख समूह म जोडत हतो, सब लोग हुन सद भावना को खुसी ले ख परमेस्वर की स्तुति करते हुयो अर वे हर दिन प्रभु उन ख समूह म मिलयो करह हैं। ");
INSERT INTO hlb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","एक रोज पतरस अर यूहन्ना दोपहर को बाद 3 बजे प्रार्थना को बखत मन्दिर जावत रय्हा ");
INSERT INTO hlb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","अर लोग एक जनम क लंगड़ा का ला रह हते, जेको वी हर दिन मन्दिर क उ दुवार पर जे सुन्दर कहलाता हतो, बैठा देत हते कि वी मन्दिर म जान वाला हुन से भीख माँगत हैं। ");
INSERT INTO hlb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","जब ओ न पतरस अर यूहन्ना का मन्दिर म जाते देख, ते ओसे भीख माँगियो। ");
INSERT INTO hlb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","उन न सिदो ओ की तरफ देखो अर पतरस न कहयो अर, “हमारो तरफ देख!” ");
INSERT INTO hlb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","अत: वी ओसे कुछ पान की आसा रखत हुओ ओकी ओर ताकन लगियो। ");
INSERT INTO hlb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","तब पतरस न ओ से कहयो मोरो जोने कुछ भी नी ते चाँदी, नी सोना, परन्तु जे मोरो नजीक हैं वी तो ख देता हूँ; “यीसु मसी नासरी क नाम से चलो फिरो।” ");
INSERT INTO hlb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","फिर ओ न ओखा जेवनो हात पकड़ ख ओ न ओकी मदद करी; अर तुरत ओके पाय अर घुटनो म बल आ गयो। ");
INSERT INTO hlb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","वी उछल ख अपनो पाय प खड़ो हो गयो अर चलन-फिरन लगियो; फिर उ उछलतो-कुदता उन को संग मन्दिर म गयो हैं अर परमेस्वर की स्तुति करत रहयो। ");
INSERT INTO hlb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","सब लोग हुन न ओ ख चलत फिरत अर परमेस्वर की स्तुति करते देखो, ");
INSERT INTO hlb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","लोग हुन न ओ ख पहचान लियो कि यू उही हैं जे मन्दिर को “सुन्दर दुवार” पर बैइठ ख भीख माँग रहो हतो; ओ ख संग जे कही घटो हतो ओ ख देख ख ओको संग हुई हती वी बेजा आस्चर्य चकित भयो। ");
INSERT INTO hlb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","जब वी पतरस अर यूहन्ना का संग हतो, ते सब लोग बेजा आस्चर्य करत हुयो ओ ख ओसरा म जे सुलैमान को कहलाता हैं, ओके नजीक दऊड ख गयो। ");
INSERT INTO hlb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","यू देख पतरस न लोग हुन से कय्हो, “हे इस्राएली हन, तू इ अदमी पर काहे आस्चर्य करत हो, अर हमार ओर काहे इ प्रकार देखत हो कि मानो हम ही न अपन सामर्थ्य या भक्ति से ऐसा चलत फिरत योग्य बना दियो ");
INSERT INTO hlb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्राहम अर इसहाक अर याकूब क परमेस्वर, हमार बापदादा हुन का परमेस्वर न अपन सेवक यीसु मसी की दिव्य बडी महिमा दिया हैं, पर तुम न अधिकारी हुन ख सोप दियो अर पिलातुस को सामे ओको इंकार कियो अर जब कि पिलातुस ने छोडन देवन को न्याय करयो रह। ");
INSERT INTO hlb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","उ सुध्द अर उचित व्यक्ति को तुना न सिवकार नी करयो अर ओको बदलो म पिलातुस से माँग कियो कि एक हत्यारो ख तुम्हारो लाने छोड़ दियो जाहे; ");
INSERT INTO hlb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","अर तुम न जिन्दगी कि राहा दिखावन वाला ख मर डालो पर परमेस्वर न फिर मरा म से जिन्दो कर दियो अर तुम पुरा गवाह हैं। ");
INSERT INTO hlb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","काहेकि हम यीसु को नाम म विस्वास करह हैं ऐको लाने ओको ही नाम ही जो लगड़ो व्यक्ति म सक्ती दी हैं जेको पाय म तुम देखह रहया हैं ओ म जान दी हैं। उही विस्वास न जे यीसु से प्राप्त होवह हैं तोसे सब को सामे यू व्यक्ति ख पुरी तरह चंगो कियो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“अर अब हे भई हन, मी जानत हूँ कि यू काम तुम न अग्यानता म कियो, अर वसा ही तुम्हारो मुखिया हुन न भी कियो। ");
INSERT INTO hlb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","पर जीन बात हुन को परमेस्वर न सब भविस्यव्दक्ता को मुंह से पहलो ही बता दियो हतो, कि ओको मसी दुख उठायो, उन्हे ओ न इ रीति से पूरो कियो। ");
INSERT INTO hlb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ऐको लाने मन फिराओ अर परमेस्वर कि ओर लोउट आओ ताकि तुम्हारो पाप ख माप कियो जाहे, ");
INSERT INTO hlb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ताकि आत्मिक सक्ति को बखत प्रभु कि ओर से आहे अऊर प्रभु तुम्हारो लाने मसी को भेजो जे से तुम्हारो लाने पहले से चुन ख रखो हैं अर्थात यीसु ख। ");
INSERT INTO hlb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","अवस्य हैं कि वी स्वर्ग म उ बखत तक रय्हे सब बात हुन पहलो जसी सही नी हो जाहे जेका बारे म बेजा पहलो से ही परमेस्वर न अपन सुध्द भविस्यवक्ता को दुवारा बतायो हती। ");
INSERT INTO hlb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","जसो कि मूसा न कय्हो, प्रभु परमेस्वर तुम्हारो भई म से तुम्हारो लोग हुन म से रक मोरो जसो एक भविस्यवक्ता भेजोगो, जे कुछ वी तुम से कहे, ओकी सुननो। ");
INSERT INTO hlb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","जे कोई उ भविस्यवक्ता की आग्या न माने ओ ख परमेस्वर की तरफ से अगल कियो जाहे अर नास कियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","अर समूएल से लेय ख ओके बाद वाला हुन तक जितना भविस्यव्दक्ता बोला उन सब न इ दिन हुन का घोसना करी आय। ");
INSERT INTO hlb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","अऊर तुम ते उ भविस्यव्दक्ता हुन अर उ वादा को उतराधिकारी होय जे से परमेस्वर न तुम्हारो बापदादा को संग करियो थो, जब ओसे अब्राहम से कय्हो, ‘तोरो खानदान ख व्दारा जमीन क सारो घरानो आसीस पाएँगो।’ ");
INSERT INTO hlb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","अर परमेस्वर न अपनो सेवक ख चुनियो अर अपनो सेवक ख तुम्हारो नजीक भेज दियो, अर तुम ख तुमरो बुरो रस्ता से फिरा ख तुम ख आसीस दी।” ");
INSERT INTO hlb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ये यहूदी लोग होवह हैं येको नेम को अनुसार परमेस्वर को मंदिर म बलिदान अर्पन चढायो करह हैं हर एक याजक को प्रिरिस्ट ख हर छ: महीना म एक हफ्ता को लाने याजकी सेवा करनो पड़त रह। सदूकी। ");
INSERT INTO hlb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","वी ओसे या बात से चिड़चिड़ा हुया हता कि पतरस अर यूहन्ना लोग हुन ख सिखात हते अर यीसु ख मरो हुओ म से जिन्दो उठन ओसे यू साबीत कर रय्ह हता। मरा हुओ जी उठ सकह हैं। ");
INSERT INTO hlb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","सो उन्होना उन ख बंदी बना लियो अर काहेकि उ बखत साम हुई गई रय्ह एको लाने उन ख जेल म रखियो। ");
INSERT INTO hlb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","पर वचन सुनन वाला हुन म से बेजा हुन न विस्वास कियो, बढन वाला बेजा झन की गिनती म पाँच हजार होई गयी। ");
INSERT INTO hlb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","अगले दिन यहूदी ख मुखिया, सियाना अर नेम सासतिरी ख मानन वाला सिक्छक यरूसलेम म जमा भया। ");
INSERT INTO hlb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","अर बड़ो याजक हन्ना अर कैफा अर यूहन्ना अर सिकन्दर अर जितना बड़ो-बड़ो याजक क घराना क हते, सब यरूसलेम म इकठ्टा भया। ");
INSERT INTO hlb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","वी इही बीच म खड़ा कर ख पूछन लगिया कि तुम न यू काम कोको सामर्थ्य से अर कोको नाम से कियो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","तब पतरस न सुध्द आत्मा से भरख (परिपूर्ण) होय ख उनसे कय्हो, अरे लोग हुन को मुखिया अर सियाना मुखिया ");
INSERT INTO hlb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“हे अदमी हुन क सरदार हुन अर पुरनियो हन, इ दुर्बल इंसान क संग जे भलाई को गयो हैं,” यदि आज हमसे ओके बारे म पूछ ताक की जात हैं, कि वी कसो चोक्खो भयो। ");
INSERT INTO hlb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ते तुम सब यीसु अर सारो इस्राएली लोग जान लेहे कि यीसु मसी नासरी क नाम से जेका तुमन सूली पर चढ़ायो, अर परमेस्वर न मरो हुओ म से जिन्दो कियो, यू इंसान तुमरो सामे भलो चंगो खड़ो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","यू उही पत्थर हैं, जेका तुम मकान बनान वालो हुन न नकारो जानो, अर वी कोन क सिरो को पत्थर हो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“किसी दूसरो क दुवारा उध्दार नी; काहेकि स्वर्ग को नीचू इंसान हुन म अर कोई दूसरो नाम नी दियो गयो, जेके व्दारा हम सब उध्दार पा सका।” ");
INSERT INTO hlb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","“जब उन्होना पतरस अर यूहन्ना को साहस देखो,” अर यू जानो कि इ अनपढ़ अर साधारण इंसान हैं, ते आस्चर्य कियो; फिर ओको पहचानो कि ये यीसु क संग रय्हे चुके हुये हैं। ");
INSERT INTO hlb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","पर वी उ इंसान का जे चंगो हुयो हतो, उनको ही संग खड़ो देख पा रय्ह था, सो उनको जोने कहन ख कुछ नी रय्हा। ");
INSERT INTO hlb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","उन न ओ से यहूदी बडी सभा नीकल जान ख कहयो, अर फिर वी विचार विमर्स करन लगया, ");
INSERT INTO hlb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“हम इ इंसान हुन क संग क करे? काहेकि यरूसलेम क सब रहन वाला हुन पर प्रगट हैं, कि इको दुवारा एक प्रसिध्द चिखान दिखायो गयो हैं; अर हम ओखा इंकार नी कर सकत। ");
INSERT INTO hlb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","पर एकोलाने कि यू बात अदमी हुन म अर अधिक फैल नी जाऐ, हम इनका धमकी देहे, कि वी इ नाम से फिर कोई इंसान से बात नी कर सका।” ");
INSERT INTO hlb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","तब उनका बुलायो अर चेतावनी देय ख यू कय्हो, “यीसु क नाम से कुछ भी नी बोलनो अर नी सिखानो।” ");
INSERT INTO hlb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","पर पतरस अर यूहन्ना न ओको उत्तर दियो, “तुम ही न्याय करनु; का वी परमेस्वर को सामे उ उचित होए की परमेस्वर क आग्या नी माना; काहे यू परमेस्वर के नजीक भलो हैं कि हम परमेस्वर को बात का बढ़ ख तुम्हारो बात माने। ");
INSERT INTO hlb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","काहेकि यू ते हम से ही सकता कि जे हम न देखो अर सुनो हैं वी लोगो ख नी कहे।” ");
INSERT INTO hlb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","तब उन्होना ओको अर धमका ख छोड़ दियो, काहेकि अदमी हुन क कारन उन्हे दण्ड देहन को कोई मऊका नी मिलियो, एकोलाने कि जे घटना भई हती ओको कारन सब लोग हुन परमेस्वर की बड़ाई करत हता। ");
INSERT INTO hlb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","वी इंसान, जे पर यू चंगो करन को चिखान दिखायो गयो हतो, चालीस साल से भी ज्यादा उमर को हतो। ");
INSERT INTO hlb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","जसो ही पतरस अर यूहन्ना ख छोड़ दियो गयो वी फिर से अपन लोगो का समूह म गयो अर हुन से जे मेन याजक अर सियाना यहूदी मुखिया न कय्हो हतो, उन ख सब सुनायो। ");
INSERT INTO hlb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","जब विस्वासी हुन न यू सुनो तब मिल ख प्रार्थना करन लगिया, अर ऊँचो सब्द से परमेस्वर से कय्हो “स्वामी तू न ही स्वर्ग अर धरती अर समुदर अर उनको अन्दर जे कुछ आय ओकी रचना आय।” ");
INSERT INTO hlb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","तू न सुध्द आत्मा क दुवारा अपन सेवक हमारो बुजुर्ग दाऊद क मुँह से का कय्हो, यू जमाना को इंसान हुन न अपनो घमंड दिखायो? लोग हुन न बेकार की साजिस काहे रच डाली? ");
INSERT INTO hlb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","प्रभु अर ओके मसी क विरोध म, जमीन क राजा खड़ा भया, अर मुखिया एक संग इकठ्टा हो गया। ");
INSERT INTO hlb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","हेरोदेस अर पुन्तियुस पिलातुस भी यू सहर म गैर यहूदी अर इस्राएली हुन क संग मिल ख तोरो सुध्द सेवक यीसु को विरोध म जे ख तू न मसी को रूप म अभिसेक करियो रहा, सही म एकजुट हो गया। ");
INSERT INTO hlb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","वी जमा भया एकोलाने ताकि तोरी इच्छा अर तोरी सक्ति को अनुसार उ पुरो हो सके। ");
INSERT INTO hlb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","अब “हे प्रभु ओकी धमकी हुन का देख; अपना दास हुन ख यू असो कर क दे कि वरदान तोरो वचन हियाव से सुनेगो। ");
INSERT INTO hlb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","अब हे प्रभु ओकी चंगो करन ख लियो तू अपन हात बढ़ा ख कि चिखान अर अदभुत काम तोरो सुध्द सेवक यीसु क नाम से कियो जाएगो।” ");
INSERT INTO hlb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","जब की प्रार्थना कर चुकियो, ते वी जगह जाहेगो वी इकठ्टे हते हिल गयो, अर वी सब सुध्द आत्मा से परिपूर्ण हो होएगो, अर परमेस्वर को वचन हियाव से सुनते रय्हे। ");
INSERT INTO hlb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","विस्वास करन वाला हुन को सहभागी एक चित्त अर एक मन की हती, यू तक कि कई भी अपन समप्ती नी कहत हतो, पर सब कुछ एक संग म हो ख बाँट लेवत रह। ");
INSERT INTO hlb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","प्रेरित बड़ी सक्ति से प्रभु यीसु को जिन्दो होन कि गवाई देते रया अर उन सब पर बड़ी आसीस हती रह। ");
INSERT INTO hlb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","उ समूह म असो कोई नी हतो कि कोई बात हुन घटी होय काहेकि जे कोई को नजीक खेत या घर होवत रहा, उन ख बेच जो पैसा मिलत रहा ओ ख लावत रह ");
INSERT INTO hlb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","अर प्रेरित को पाय म रख देवत रहा जे क जसा आवस्यकता होवा हैं, अर ओकी जरूरत को अनुसार उन ख बाँट दियो जावह हैं। ");
INSERT INTO hlb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","अर यूसुफ नाम साइपरस पैदा भयो को एक लेवी हतो, जेको प्रेरित बरनबास कह कर बोलत रह अर्थात् जो ख सान्ति को पोरिया कहत रह। ");
INSERT INTO hlb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ओकी कुछ जमीन हती, जेका ओ न बेचीयो, अर दाम क पैसा लाय ख प्रेरित हुन पाय हुन पर रख दियो। ");
INSERT INTO hlb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","हनन्याह नाम को एक अदमी अर ओकी ओरत, सफीरा न अपनी कुछ जमीन ख बेचियो। ");
INSERT INTO hlb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","अर अपन ओरत जानकारी म कुछ पैसा बचा ख रख लियो, अर कुछ पैसे प्रेरित हुन को पाय क आगु म रख छोडियो ");
INSERT INTO hlb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","पतरस न ओसे कय्हो, हे हनन्याह! सैतान न तोरो मन म यू बात काहे डाली कि तू सुध्द आत्मा से झूठ बोल्यो, अर भूमि क दाम म से कुछ रख छोडियो? ");
INSERT INTO hlb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","जब तक तू न या जमीन ख बचीयो या तोरी नी हती जब तू न ओ से पैसा मिलियो उ भी तोरो थो फिर भीइ तू न न अपनो मन म झुठ बोलन को कसो सोचियो, तू न अदमी से झुठ नी बोल्यो परमेस्वर से झुठ बोलयो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","अर जे न या बात ख सुनायो भय छा गयो, हनन्याह गिर पडियो अर प्रायन छोड़ दियो, अर अब सुनन वाला हुन बड़ो डर छा गयो। ");
INSERT INTO hlb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","फिर जवान हुन न उठ ख ओकी अर्थी बनायो अर बाहर ले जाय ख गाड़ दियो। ");
INSERT INTO hlb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","लगभग तीन घंटा का बाद ओकी ओरत, जे कुछ भयो हते नी जाय ख, अन्दर अई। ");
INSERT INTO hlb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","तब पतरस न ओसे कय्हो, “मोखा बता तोरो पति न वी जमीन ख इतना ही पैसा म बेची हती का?” ओ ना कय्हो, “हाँ इतना म ही बेची हती।” ");
INSERT INTO hlb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","पतरस न ओसे कय्हो, “या क बात हैं कि तुम दो ही एक मत हो गया प्रभु का आत्मा की परीक्छा लियो एको कियो? देख, तोरो पति क गाड़न वाला हुन दरवाजा ही पर खड़ा हैं, अर तोखा भी उठा ख बाहर ले जाएगो।” ");
INSERT INTO hlb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","तब वी तुरत ओको पाय प गीर गाई पड़ी, अर प्रान छोड़ दियो; अर जवान हुन न अन्दर आय ख ओ ख मरो पायो अर बाहर ले जाय ख ओ ख ओको पति क नजीक गाड़ दियो। ");
INSERT INTO hlb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","सारो कलीसिया पर अर इ बात हुन का अर सब सुनन वाला हुन पर बड़ो डर छा गयो। ");
INSERT INTO hlb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","प्रेरित हुन का हात हन से बेजा चिखान अर अदभुत काम अदमी हुन का बीच म दिखायो जात हते, अर वी सब एक चित्त म होय ख सुलैमान क ओसरा म इकठ्टे भया करत हते। ");
INSERT INTO hlb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","उ समूह म सम्मीलित होवन को साहस कोई नी करत रह पर लोग हुन कि बड़ाई जरूर करत रह। ");
INSERT INTO hlb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","विस्वास करन वाला बेजा अदमी हुन अर बाई हुन प्रभु को कलीसिया म बडी संख्या म मिलत रहा। ");
INSERT INTO hlb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","असो तरीका से लोग हुन अपन जुड़ हुन ख लाय ख, खटिया अरुर बिस्तर पा रस्ता म लिटान लगिया ताकि जब पतरस इते से निकलिया ते ओकी छाय ही पड जाहे। ");
INSERT INTO hlb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","अर यरूसलेम क आसा पास क नगर हुन म से भी कई लोग हुन भी जुड़ अर बुरी आत्मा हुन क सतायो भया का ला लाय ख इकठ्टे होत हते, अर सब चंगो हो जात हते। ");
INSERT INTO hlb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","तब बड़ो याजक अर ओके सब संगी जे सदूकी हुन को दल का हता, बेजा जादा जलन से भर उठिया ");
INSERT INTO hlb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","अर प्रेरित हुन का पकड़ ख जेल म बंद कर दियो। ");
INSERT INTO hlb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","पर उ रात को बखत प्रभु को एक स्वर्गदूत न जेल क दरवाजा खोल दियो उन ख बाहर लाय ख कय्हो, ");
INSERT INTO hlb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“जाओ, मन्दिर म खड़ो होय ओ उ नयो जिन्दगी क बारा म सब बात लोग हुन ख सुनाओ।” ");
INSERT INTO hlb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","वी यू सुन ख भुसारो होत ही मन्दिर म जायख सिक्छा (उपदेस) देन लगियो। तब बड़ो याजक अर ओके संगी वाहा पहुँचिया यहूदियो के अगवे अर इस्राएली हुन का सब बुजुर्ग का बुला लायो, अर सैनिक ख जेल म भेजो कि प्रेरित ख बुला ख लाए। ");
INSERT INTO hlb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","पर जब सिपाई जेल खाना म पहुँचिया ते प्रेरित नी मिलीयो ते लउट ख खबर दियो, ");
INSERT INTO hlb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","जब हम जेल म पहुँचिया ते हम न पायो कि जेल की सुरक्छा का ताला लगिया हुआ अर दुवार पर सुरक्छा कर्मी खडा मिलीयो हता पर हमना दुवार खोलो ते हम ख आन्दर कोई नी मिलीयो। ");
INSERT INTO hlb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","जब मन्दिर को सरदार को अधिकारी प्रधान याजक हुन से या बात सुनी तब अचभ्बे म पड गया अर, सोचन लगिया प्रेरित को क होए! ");
INSERT INTO hlb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","इतना म किसी न आय ख उनको बतायो, “देख, जे लोग ख तुम न जेल म बंद रखो हतो, वी लोग मन्दिर म खड़ा भया लोग हुन ख सिक्छा देत रहा।” ");
INSERT INTO hlb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","सो मन्दिर को सुरक्छा करन वाला को मुखिया अपनो सिपाई हुन को संग उते गयो हैं अर प्रेरित ख बिना ताकत को प्रयोग कियो उनख वापस आयो काहेकि उन ख डर हतो कि लोग हुन हमका पत्थर नी मारे। ");
INSERT INTO hlb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","उन्होना उन्हे लाय ख बड़ो सभा क सामे खड़ो कर दियो; तब बड़ो याजक न ओसे पुछियो, ");
INSERT INTO hlb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“क हम न तुमख चिता ख हुकुम नी दी हती कि तुम इ नाम से उपदेस नी करनु? तभी देख, तुम न सारो यरूसलेम ख अपन उपदेस से भर दियो हैं अर तू यू पर व्यक्ति की हत्या को अपराध हम प लादनो चावह हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","तब पतरस अर अन्य प्रेरित हुन न उत्तर दियो, “इंसान हुन की हुकुम से बढ़ ख परमेस्वर को हुकुम माननो चाहिए। ");
INSERT INTO hlb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","हमार बापदादा हुन को परमेस्वर न यीसु ख जिन्दो कियो, जिनका तुम न यीसु ख सूली पर खिलला ठोक ख मार ड़ालियो। ");
INSERT INTO hlb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ओखा ही परमेस्वर न अगुवा प्रभु अर उध्दार करन वालो ठहराय ख, अपने जेवनो हात पर ऊँचो कर दियो, कि उ इस्राएली हुन का मन फिरान की मोखा देवह हैं अर पाप की माफी को लाने मऊका दे। ");
INSERT INTO hlb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","हम यू बात हुन का गवाह हैं। अर वसो ही सुध्द आत्मा भी, जेखा परमेस्वर न उनखा दियो हैं। जे ओको नेम ख मानो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","जब महा सभा का सदस्य हुन न यू सुनो ते वी आग बबुला हो गयो अर प्रेरित ख मर डालनो चाहयो। ");
INSERT INTO hlb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","पर उन म एक फरीसी जेको नाम गमलीएल हतो जे व्यवस्थापक हतो अर सब लोग हुन म बडो ही समान को योग हतो अर सभा म खडो हुयो अर हुकुम दियो की प्रेरित ख थोडी बखत को लाने बाहर कर दियो जाये। ");
INSERT INTO hlb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","तब उ सभा से कय्हो, “हे इस्राएली हन, तुम जे कुछ भी इंसान हुन को संग करनो चाहवा हैं, ओ ख सोच समझ ख करनु। ");
INSERT INTO hlb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","क तुम ख याद हैं कि कुछ बखत पहलो अपन तुम ख कुछ महान व्यक्ति हैं थियूदास व्यक्ति प्रगट हुयो अर लगभग चार सव व्यक्ति ओको पीछु हो लियो पर ओ ख मार डालो गयो अर ओ के सभी अनुयायी तितर-बितर हो गया पर ओको परिणाम कुछ नी निकलियो। ");
INSERT INTO hlb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","इ को बाद जनगणना को बखत गलीली को रहन वालो यहूदा सिर उठयो। उन कुछ लोग हुन ख अपनी तरफ आकर्सित कर लियो रह वी भी मारो गयो ओ ख भी पिछे चलन वाला अनुयायी इते उते बिखर गयो। ");
INSERT INTO hlb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","एकोलाने नी अभी को बारे म तुम से मी कहूँ हैं इ इंसान से अगल रहो इन को बारे म कोई काम मत करजे उन ख आकेलो छोड दा अदि इ की यू योजना यू काम इंसान को तरफ हैं ते अपन तुम खत्म हो जाहे। ");
INSERT INTO hlb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","पर अदि परमेस्वर कि तरफ से हैं, ते तुम उन ख कभी नी नास कर पान का। कही असो नी होय कि तुम परमेस्वर से भी लड़न वाला ठहरे।” ते सभा न गमलीएल की बात मान ली। ");
INSERT INTO hlb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","उन ना प्रेरित अर उन न कोड़ा लगयो अर उन ख हुकुम दियो कि यीसु को नाम की चर्चा नी करे अर उन ख छोड दियो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","उन्होने असो समझ लियो की परमेस्वर न उन न यीसु को नाम को लाने अपमान सहन को लायक समझियो। ");
INSERT INTO hlb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","फिर मन्दिर अर घर-घर म लगातार हर रोज यू सुसमाचार को यीसु मसी हैं उपदेस देनो अर सिक्छा देनो उन न कभी नी छोडियो। ");
INSERT INTO hlb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","कुछ रोज बाद चेला हुन कि संख्या बड़ रही हैं ते यूनानी भासा बोलन वाला यहूदी विस्‍वास भासा बोलन वाला एक विस्वासी काहेकि इब्रानी यूनानी यहूदी विस्वासी यु दावा कर रया हता उन कि विदवा हुन को दैनिक वितरण कि चिज हुन म से नजर अनदाज कियो जावा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","बारा प्रेरित हुन न चेला हुन कि पुरी मण्डली क अदमी बुला ख कहयो हमारो लाने परमेस्वर कि सेवा को वचन ख छोड़ ख खाना अथवा पैसा को प्रबंध करनो अच्छो नी आय। ");
INSERT INTO hlb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","एकोलाने, “हे भई हुन, अपन म से सात सुनाम अदमी हुन का जे सुध्द आत्मा अर बुध्दि से भरपुर्न होए, चुन लोओ, कि हम उनका इ काम की जुम्मेदारी दे। ");
INSERT INTO hlb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","परन्तु हम ते प्रार्थना म अर वचन की सेवा लगाए रहनू।” ");
INSERT INTO hlb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","यू बात सारो मण्डली ख चोक्खो लगियो, अर अर उन्होना स्तिफनुस नामक एक अदमी का जो कि विस्वास अर सुध्द आत्मा म भरपुर्न हतो, अर फिलिप्पुस, अर प्रुखुरुस, अर नीकानोर, अर तीमोन, अर परमिनास, अर अन्ताकिया वासी नीकुलाउस का जे यहूदी मत म आ गयो हतो, चुन लियो। ");
INSERT INTO hlb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","उन ख प्रेरित हुन का सामे खड़ो कियो अर उन ख प्रार्थना कर ख ओ पर हात रखियो। ");
INSERT INTO hlb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","अर यू तरीका परमेस्वर को वचन फैलातो गयो अर यरूसलेम म चेला हुन की गिनती बेजा बढता गयो; अर याजक हुन को बड़ो समाज इ मत ख मानन वाला हो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्तिफनुस दया अर सामर्थ्य से परिपूर्ण होय ख अदमी हुन म बड़ो बड़ो अदभुत काम अर निसान करत हतो। ");
INSERT INTO hlb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","पर तथा स्वतरत कियो गयो यहूदी हुन प्रार्थना घर का कुछ इंसान हुन जे कुरेनी अर सिकन्दरिया अर किलिकिया अर आसिया प्रान्थ से आयो यहूदी हतो वी स्तिफनुस को विरोध म वाद विवाद करन लग गया। ");
INSERT INTO hlb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","पर उ आत्मा जेसे बात वी करता हतो, अर ओको ग्यान को आगो नी टिक पाहे। ");
INSERT INTO hlb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","इ पर उन्होना कई अदमी हुन को लालच देय क अर कहन लगिया, “हम न एको मूसा अर परमेस्वर को विरोध म ओ ख अपनायक जनक निन्दा को बात कहत सुनो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","अर लोग हुन अर सियाना हुन अर सासतिरी हुन ख भड़का ख चढ़ गया अर ओ ख पकड़ ख बड़ो सभा म ले आयो। ");
INSERT INTO hlb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","अर उन न झूठा गवाह हुन खड़ो कियो गयो, जिनना कय्हो, “यू इंसान हमेसा सुध्द मन्दिर को बाराम बोलह हैं नेम ख विरोध म बोलनो नी छोड़त। ");
INSERT INTO hlb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","काहेकि हम न ओ ख यू कहत सुनो हैं कि उही यीसु नासरी इ मन्दिर खा तहस नहस कर देगो, अर हमरी रीति रिवाज हुन ख बदल देहे जे मूसा न दियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","तब सब अदमी हुन न जे सभा म बैठा हते, ओ पर नजर गड़ाई ते ओको चेहरा स्वर्गदूत को सो देखियो। ");
INSERT INTO hlb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","तब बड़ो याजक न पुछियो, “का यी बात हुन सच्ची हैं?” ");
INSERT INTO hlb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","स्तिफनुस न उत्तर दियो, “अरे भई हुन, अर सियाना हुन! मोरी बात सुनो। जब हमारो स्यानो अब्राहम हारान देस म बसन से पहिले मेसोपोटामिया म रहत रहा, ते वा बखत महिमा म रहन वालो परमेस्वर ओ ख दिख्यो।” ");
INSERT INTO hlb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","अऊर बोल्यो, तू अपनो देस अऊर अपनो कुटुम ख छोड़ दा अऊर उ देस क जा, जेखा मी तोखा दिखाऊँगो। ");
INSERT INTO hlb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ये पर उ कसदियो को देस छोड़ ख हारान देस म बस गयो। अऊर ओको बाप की माऊत को बाद, परमेस्वर न ओखा उते से यू देस म लायका बसायो जेमन अब तुम रहवा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","यू देस म परमेस्वर न उनका पाय रखन को लाने भी जगा नी दियो; पर ओ ना वादा करयो रहा की मी यू देस तोरो अर तोरो बाद तोरी अवलाद को बस म कर देहु; फिर भी उ बखत अब्राहम की कोई अवलाद नी हती। ");
INSERT INTO hlb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","परमेस्वर न असो कय्हो, अब्राहम की अवलाद परायो देस म परदेसी हुन को जसा रहेगो। वी अदमी हुन उनका नउकर बना ख रखेगो अर चार सव बरस लक उन पा अत्याचार करते रहेगो। ");
INSERT INTO hlb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","परमेस्वर न फिर बोल्यो, मी उ जात ख दण्ड देहु जेका वी गुलाम रहे। येको बाद वी वहाँ से बहार ईकल आहे अर या जगा म मोरी भक्ति करेगों। ");
INSERT INTO hlb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","फिर परमेस्वर न अब्राहम को लाने खतना करन को नियम बाँध्यो; अर सही म, अब्राहम न इसहाक का पैदा करयो अर आठ रोज को बाद ओको खतना करयो। इसहाक से याकूब अर याकूब को बारा कुल ख इंसान हुन पैदा भया। ");
INSERT INTO hlb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","यी बारा भई हुन न जलन रखन को वजे से उनको भई यूसुफ ख मिसर देस म जान वाला को हात बेच दियो, फिर भी परमेस्वर ओको संग म हतो रहा। ");
INSERT INTO hlb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","परमेस्वर न ओ ख सब बिपत्ती हुन से छुड़ायो, अर ओखा मिसर देस को राजा फिरोन की नजर म दया अर ग्यानवान बना दियो। फिरोन न यूसुफ ख मिस्र को अर अपनो पुरो राजभवन को अधिकारी ठहराय दियो। ");
INSERT INTO hlb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","उ बखत पुरो मिसर अर कनान देस म अकाल अऊर घोर संकट पड़यो। येको वजेसे हमरा बाप-दादा हुन ख अन्न नी मिलत रहा। ");
INSERT INTO hlb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","जब याकूब न यू सुन ख कि मिसर देस म अनाज मिला हैं, ते ओ ना हमरा सियाना हुन ख उते पेहली बार भेज्यो। ");
INSERT INTO hlb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","दुसरी बार मिलन को मऊका पर यूसुफ न अपना भई हुन ख अपनो बारे म बतायो अर फिरोन ख यूसुफ की जात अर कुल को पता चल्यो। ");
INSERT INTO hlb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ओको बाद यूसुफ न अपनो बाप याकूब अर ओको पुरो परिवार ख बुलावा भेज्यो। सबरा मिलायो ख वी पचहत्तर इंसान हता। ");
INSERT INTO hlb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","याकूब मिसर देस ख गयो। उते ओको अर हमरा बाप-दादा हुन की भी माऊत हो गई। ");
INSERT INTO hlb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","बाद म उनकी लास सकेम सहर लाया अर उ समसान घाट म रखिया, जेखा अब्राहम न सकेम म हमोर को पोरिया हुन से चाँदी दे ख खरिद्यो रहा। ");
INSERT INTO hlb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“परमेस्वर न अब्राहम से जो वादा करयो रहा, जब ओको पुरो होन को बखत आयो, तब हमरा इंसान हुन की गिनती मिसर देस म बेजा सारी बढ़ गई। ");
INSERT INTO hlb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","कुछ दिन को बाद मिसर म एक असो राजा भयो, जो यूसुफ को बारे म कुछ नी जानत रहा। ");
INSERT INTO hlb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ओ ना हमरी जात को संग कपटी मन से बर्ताव करयो, अर हमरा बाप-दादा हुन पा अत्याचार करयो। ओ ना हमारा बाप-दादा हुन ख इत्तो मजबुत करयो कि वी अपना छोटा-छोटा पोरिया-पारी ख बाहर फेक देनो चाहिए, जसो वी जिन्दा नी रह सकन का। ");
INSERT INTO hlb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","असो बखत म मूसा को जनम भयो। उ परमेस्वर को नजर म बेजा खुफसुरत हतो अऊर तीन महा लक ओखा अपनो बाप को घर म पालो-पोसो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ऐको बाद जब उ फेक दियो गयो, तब फिरोन की बेटी न ओखा पालक पोरिया बना लियो अर अपनो पोरिया को जसो ओ ना ओखा पालन-पोसन कियो। ");
INSERT INTO hlb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","मूसा ख मिसतिरी की पुरी बिध्या सिखई गई, अर उ वचन अर करम करनो दोई म बलसाली हतो।” ");
INSERT INTO hlb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“जब उ चालीस बरस को भयो, ते ओको मन म आयो कि मी अपनो कुटुम्ब ख इस्राएली भई हुन से मेल-जोल करूँ। ");
INSERT INTO hlb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","उनमा से एक संग बुरो व्यवहार होते देख ख, मूसा न ओको पक्छ लियो अर मिसतिरी ख मार ख अत्याचार को पलटा लियो। ");
INSERT INTO hlb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","मूसा न सोचियो की ओखा भई हुन समझेगो कि परमेस्वर मूसा को हात से उनका मुक्ति करेगों, पर उनना असो नी समझियो। ");
INSERT INTO hlb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","दुसरो रोज मूसा न दो इस्राएली हुन ख झगड़ते देख्यो। ओ ना यू सोच ख उनमा मेल-जोल करन की सोचियो, अरे भई हुन! तुम तो भई-भई हैं। तुम काहेको लाने एक-दुसरा का हानि पहूँचा रया हैं? ");
INSERT INTO hlb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","जो व्यक्ति अपनो पड़ोसी की हानि करत रा, ओ ना मूसा ख एक बाजू ढकेल दियो अऊर बोल्यो, कोना तोखा हमारो मुखिया अर न्याय करन वालो ठहरायो हैं? ");
INSERT INTO hlb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","जो तरीका से तू न कल मिसतिरी ख मार ड़ाल्यो रहा मोखा भी मारन कि सोचा हैं का? ");
INSERT INTO hlb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","या बात सुन ख मूसा वहाँ से भागयो अर मिदयान देस म परदेसी बन ख रहन लग गयो, अर वहाँ ओखा दो पोरिया पैदा भया।” ");
INSERT INTO hlb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","चालीस बरस की ऊमर को बाद सीनै पहाड़ को भटा म आगी से काटा झाड़ी जलते हुए दिखई दियो। ");
INSERT INTO hlb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","यू देख ख मूसा सोच म पड़ गयो, अऊर जब देखन को लाने जोने गयो, ते उनका प्रभु की या आवाज सुनाई दियो, ");
INSERT INTO hlb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","मी तोरो बाप-दादा को परमेस्वर आय अब्राहम, इसहाक तथा याकूब को परमेस्वर। मूसा डर को मारे काँपन लग गयो। अर ओखा फिर देखन कि हिम्मत नी भई। ");
INSERT INTO hlb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","फिर प्रभु न ओसे बोल्यो, अपनो पाय से जूता उतार ला, काहेकि जो जगह पर तू खड़ो हैं, वा सुध्द जमीन हैं। ");
INSERT INTO hlb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","मीना मिसर देस म रहन वाली मोरी जात पर हो रयो अत्याचार अच्छो से देख्यो अर उनको रोनो सुनियो हैं। एकोलाने उनका छुड़ान को लाने मी उतर आयो हैं अब तैयार हो जा! मी तोखा मिस्र देस भेजुगो। ");
INSERT INTO hlb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“जो मूसा ख अदमी हुन न असो कहते हुए इंनकार करयो रहा कि कोना तोखा हमारो मुखिया अर न्याय करन वालो ठहरायो हैं?” ओको ही परमेस्वर न झाड़ी म दर्सन देन वालो स्वर्ग दूत को दुवारा हक जतान वालो अर छुड़ान वालो को रूप म उनको जोने भेज्‍यो। ");
INSERT INTO hlb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","उई मूसा न उनका बाहर हेड का लायो अर मिसर देस म लाल समुंदर को अर बियाबान परदेस म चालीस बरस लक अदभुत काम अर चिखान दिखात रहा। ");
INSERT INTO hlb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","यू उईच मूसा आय जेना इस्राएली हुन से बोल्यो रहा, परमेस्वर तुमरा भई हुन म से तुमरो लाने मोरो जसो एक भविस्यवक्ता खड़ो करे। ");
INSERT INTO hlb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","यू उईच मूसा आय, जोना बियाबान परदेस की कलेसीया म उ स्वर्गदूत को संग हता, जेना सीनै पहाड़ पा उनसे बात करयो रहा। अऊर उ हमरा बाप-दादा को संग म भी हतो। उईच मूसा ख जीवित वचन मिल्या ताकि उ ओखा हम सब ख सुनाया। ");
INSERT INTO hlb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","पर हमरा बाप-दादा न ओकी बात ख मानन कि नी सोचियो। उनना मूसा ख छोड़ दियो अर वी मिसर देस ख लउटन की सोचत रहा। ");
INSERT INTO hlb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","उनना हारून से बोल्यो, हमरो लाने असो भगवान ख बना, जो हमरो अउवल-अउवल चले; काहेकि हम नी जानत आय कि उ मूसा को का भयो, जो हमका मिसर देस से हेड ख लायो रहा। ");
INSERT INTO hlb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","वी दिन म उनना बछड़ा की मुरती बनाई अर ओको सामने बलि चढ़ई अर अपनो हात से बनाई वाली मूर्ति को लाने एक तिहार मनायो। ");
INSERT INTO hlb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","तब परमेस्वर न उनसे मुड़ो फेर लियो अर ओ ना उनका आकास ख नकित्तर हुन को भक्ति करन को लाने छोड़ दियो, जसो की भविस्यवक्ता कि किताब म लिख्यो हैं: इस्राएली हुन! का तुम इंसान हुन न बियाबान परदेस म चालीस बरस लक मोखा जानवर बलि अर अनाज बलि नी! चढ़ायो रहा? ");
INSERT INTO hlb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","तुम मोलेक ख भी तम्बू अर अपनो भगवान रिफान को तारा ख भी अपनो संग म ले खा गयो रहा। वा मूर्ती हुन भी तुम लेखा गयो जिनका तुमना दण्डवत करन को लाने बनायो रय्हा। ");
INSERT INTO hlb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“गवाई को तम्बू जंगल म हमारा बापदादा को बीच म हतो, जसो ओ ना ठहरायो जेना मूसा से येको बारे म कय्हो, जे आ ख तू न देखो हैं; ओको अनुसार ओखा बना।” ");
INSERT INTO hlb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","हमरा बाप दादा ओ ख हासिल कर ख तभी उते वहाँ आया रहा जब यहोसू को बखत म उन ना वी दुसरी जात हुन पा हक पायो जीन ख परमेस्वर न हमरा बाप दादा जोने निकाल ख बाहर कर दियो रहा। अर दाऊद को बखत तक असो ही रहा। ");
INSERT INTO hlb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","दाऊद न परमेस्वर की किरपा को आनन्द उठायो। ओ ना सोचियो की उ याकूब ख अदमी हुन को लाने एक रहन को जगा बना सके। ");
INSERT INTO hlb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","पर सुलैमान न ओको लाने मन्दिर बनायो। ");
INSERT INTO hlb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","पर परमप्रधान से रहन वालो परमेस्वर हात को बनायो घर म नी रहवा, जसो की भविस्यवक्ता न कय्हो, ");
INSERT INTO hlb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","प्रभु बोला हैं, स्वर्ग मोरो सिंहासन, अर जमीन मोरो लियो तुम कसो तरीका को घर बनायगो? अर मोरो आराम को कोन सी जगह होयगो? ");
INSERT INTO hlb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","का यी सब चिज मोरो सामर्थ की बनाई वाली नी? ");
INSERT INTO hlb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“स्तिफतुस आगे बोलते ही रयो तुम अदमी हुन कित्ता ढीट हैं। तुमना हमेसा दी सुध्द आत्मा को विरोध करयो हैं। तुम अपना बादा दादा ख जसा ही हैं। ");
INSERT INTO hlb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","का कोई भी असो भविस्यवक्ता हतो, जेखा तुमरा बाप-दादा न नी सतायो? उनना तो उन ख मार भी डाल्यो जिनना बेजा पहिले से ही उ धर्मी को आन को बारे म बता दियो रहा, जेखा अब तुमना धोका दे ख पकड़वा दियो अर मरवा डाल्यो, ");
INSERT INTO hlb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","तुम विईच ही आय जिनना स्वर्गदूत हुन को जरिया दी वाली नेम को विधान हासिल तो कर लियो पर ओपर चल्या नी।” ");
INSERT INTO hlb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","जसा ही सभा अदमी हुन न स्तिफनुस कि बात हुन ख सुनी ते वी घुस्सा से आग बबुला हो ख उठायो अर ओपर दाँत पीसन लग गया। ");
INSERT INTO hlb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","पर ओ ना सुध्द आत्मा म भरख स्वर्ग की तरफ देखियो अर परमेस्वर को महिमा का अर यीसु का परमेस्वर ");
INSERT INTO hlb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","एकोलाने ओ ना कय्हो, “देखो मी देख रयो हैं कि स्वर्ग खुल गयो हैं अर इंसान को पोरिया परमेस्वर को जेवनो तरफ खड़ो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","तब उनना बड़ो आवाज से पुकार ख कान बंद कर लियो, अर एक संग ओ पर झपटियो; ");
INSERT INTO hlb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","वी ओ ख घीसते हुए सहर ले गया अर ओपर पत्थर चलान लग गया। तभी विस्वासी हुन न अपना कपड़ा उतार ख साऊल नाम को एक जवान को पाय को जोने रख दियो। ");
INSERT INTO hlb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","वी लोग स्तिफनुस पर पत्थर फेंकते रह, अर वी यू कह ख विनती करत रय्हो, “हे प्रभु यीसु, मोरी आत्मा का ग्रहण कर।” ");
INSERT INTO hlb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","फिर ओ न घुटना बल टिक ख ऊँचो सब्द से पुकारा, “हे प्रभु, यू पाप ख उन को विरुद म मत लगाजो।” अर यू इत्तो कह ख मर गयो। ");
INSERT INTO hlb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","साऊल ओको मरन को संग सहमत हतो। उही दिन यरूसलेम को कलीसिया पर बड़ो मूसिबत आरम्भ भयो अर प्रेरित हुन का छोड़ सब क सब यहूदिया अर सामरिया देस हुन म तितर-बितर हो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","कुछ भक्त हुन न स्तिफनुस ख कब्र म रखो अर ओको लियो बड़ो सोक विलाप कियो। ");
INSERT INTO hlb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","साऊल कलीसिया ख उजाड़ रय्हो हतो; अर घर-घर घुस ख घसीट अदमी अर बाई हुन ख खीच ख जेल म डालत हतो। ");
INSERT INTO hlb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","जे विस्वासी म तितर-बितर भया हते, वी सुसमाचार सुनात भया फिरत हते; ");
INSERT INTO hlb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","अर फिलिप्पुस सामरिया नगर म जाय ख लोग हुन म मसी को प्रचार सुनावन लगयो। ");
INSERT INTO hlb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","फिलिप्पुस का अदमी हुन न जब सुन्यो अर जो हईब ख चिन्ह ख उ पर घट करते जात रहा, देख्यो, ते जो बात हुन ख उ बतात रहा उन पा उनना खुब ध्यान से ध्यान दियो। ");
INSERT INTO hlb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ढ़ेर सारा इंसान हुन म से, जिनमा बुरी आत्मा समायो हतो रहा, वी बड़ी जोर से किलकारी मार ख बादर निकल ख अई रह। ढ़ेर सारा लकवा ख बीमार अर लंगडा अच्छो होत रहा। ");
INSERT INTO hlb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","यु तरीका से सहर म बड़ो खुसी छा गयो। ");
INSERT INTO hlb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","वहाँ समोन नाम को एक अदमी रहत रहा। उ काफी दिन से वहाँ जादू-टोना करते जात रहा अर सामरिया ख इंसान हुन ख सोच म डाल देत रह। उ महान अदमी होन को दावा करत रहा ");
INSERT INTO hlb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","छोटा से लेकर बड़ा तक सभी इंसान हुन ओकी बात हुन पा ध्यान देत रहा अऊर बोला, “यू अदमी परमेस्वर की वई सक्ती आय जो महा सक्ति कह लाय हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ओ न बेजा दिन हुन से उनका जादू को काम हुन से चकित कर रखो हतो, एकोलाने वी ओको बेजा मानत हैं। ");
INSERT INTO hlb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","पर जब उनना जब फिलिप्पुस पा भरोसा करयो काहेकि ओ ना उनका परमेस्वर को राजा को सुसमाचार अऊर यीसु मसी को नाम सुनायो रहा, ते वी अदमी ओरत दोई से बपतिस्मा लेन लग गया। ");
INSERT INTO hlb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","तब समोन न खुद भी विस्वास कियो अर बपतिस्मा लेय ख फिलिप्पुस को संग रहन लगिया। वी चिखान अर बड़ो-बड़ो सक्ति को काम होत देख ख बडो अचिम्मित होत हतो। ");
INSERT INTO hlb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","जब प्रेरित हुन न जो यरूसलेम म हते, सुनियो कि सामरिया हुन न परमेस्वर को वचन मान लियो हैं ते पतरस अर यूहन्ना का ओके नजीक भेजियो। ");
INSERT INTO hlb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","फिर जब वी पहुँचिया ते उनना उनको लाने बिनती करी कि उनका सुध्द आत्मा मिले। ");
INSERT INTO hlb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","काहेकि वी अब तक ओमा से कोई पर नी उतरियो हतो, उनना ते केवल प्रभु यीसु को नाम म बपतिस्मा लियो हतो। ");
INSERT INTO hlb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","एकोलाने पतरस आ यूहन्ना न उन पा हात धरया अर उनका सुध्द आत्मा मिल गयो। ");
INSERT INTO hlb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","जब समोन न देखियो कि प्रेरित हुन को हात रखन से सुध्द आत्मा दियो जात हैं, ते ओको नजीक पैसा लाय ख कय्हो, ");
INSERT INTO hlb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“मो ख भी असी अधिकार दे, कि जे कोई पर मी हात रखू ते वी सुध्द आत्मा पाएगो।” ");
INSERT INTO hlb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","पतरस न ओसे कय्हो, “तोरो अर तोरो धन को सत्यानास होय, काहेकि तू न असो सोच्चो कि तू पैसा से परमेस्वर ख वरदान हुन ख मोल ले सका हैं। ");
INSERT INTO hlb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","इ बात म नी तोरो हिस्सा हैं, नी भाग; काहेकि तोरो कोई हिस्सा नी मन परमेस्वर को आगु सिधो नी हैं। ");
INSERT INTO hlb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","एकोलाने अपनी या बुरी चाल से मन फिरा ख अर प्रभु से विनती कर। हो सका हैं तोरो मन म जो विचार हतो, उ विचार को लाने तोखा माप कर दियो जाय।” ");
INSERT INTO hlb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","काहेकि मी देख रयो हैं कि तू अधर्म से भरो पड़यो हैं अर पाप को चुंगल म फस गयो। ");
INSERT INTO hlb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","पतरस न समोन अर यूहन्ना ख उत्तर दियो, “तुम प्रभु से मोरो लाने विनती करो कि ताकि तुमना जो कुछ बोल्यो हैं, ओमा न से कोई भी बात मोपर नी घटन करी।” ");
INSERT INTO hlb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","जब वी अपनी दे ख अर प्रभु को वचन सुना ख रस्ता ख ढ़ेर सारा सामरी गाँव हुन म सुसमाचार को बारे म बताते हुए यरूसलेम लऊट आयो। ");
INSERT INTO hlb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","प्रभु को एक स्वर्ग दूत न फिलिप्पुस ख बोलते हुए बतायो “तैयार हो जा, अर दक्छिन दिसा म वा रस्ता म जा, जो यरूसलेम से गाजा ख जावा हैं।” यू एक बियाबान रस्ता हैं। ");
INSERT INTO hlb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","एकोलाने उ तैयार भयो अर निकल पड़यो वही एक क्रूस को खोजा हतो। उ क्रूस की रानी केदाके को एक अधिकारी हतो जो ओको पूरो खजाना को राज्यपाल हतो। उ बिनती करन को लाने यरूसलेम गयो रहा। ");
INSERT INTO hlb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","लोउते बखत उ अपनो रथ पर बैठो भयो हतो, अर यसायाह भविस्यवक्ता को किताब पढ़त भयो लउट जा रय्हो हतो। ");
INSERT INTO hlb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","तभी फिलिप्पुस ख आत्मा न बतायो कि, “उ रथ को जोने जा अर उते ही रूक।” ");
INSERT INTO hlb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फिलिप्पुस जब उ रहा को जोने दऊड ख गयो ते ओ ना ओखा यसायाह भविस्यवक्ता कि किताब पढते सुन्यो। एकोलाने उ बोल्यो, “का जेखा तू पढ़ रयो हैं ओखा का समझा भी हैं?” ");
INSERT INTO hlb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","अधिकारी न उत्तर दियो, “भी भला तब लक कसो समझ सकू हैं। जब लक कोई मोखा ऐका नी समझान को?” फिर ओ ना फिलिप्पुस ख रथ पा अपनो संग बैठन ख बुलायो। ");
INSERT INTO hlb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","सास्र को जो भाग ख उ पढ़त रहा उ हतो: “ओखा बली चढ़न वाली भेड़ को जसो ले जायो गयो। उ तो उ पिल्ला को समान चुप था। जो ऊन करन कि बखत चुप-चाप रहवा हैं, ठीक वसो ही ओ ना अपनो मुंडो नी खोल्यो! ");
INSERT INTO hlb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ओको सिधो स्वभाव म ओको संग न्याय नी हो पायो। ओको बखत का अदमी हुन को बारे म कऊन बता सका हैं? काहेकि ओ कि जिन्दगी खतम कर दी हैं। काहेकि दुनिया से ओको प्रान उठा लियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","“ये पर खोजे न्याय अधिकारी न फिलिप्पुस से पुछो, मी तोसे प्रार्थना करू हैं, यू बता कि भविस्यवक्ता यू कोन को बारे म बोला हैं, अपनो बारे म या कोई दुसरो बारे म?” ");
INSERT INTO hlb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","फिर फिलिप्पुस न कहेनो सुरू करयो अर यू सास्र से लेका यीसु को सुसमाचार लक सब ओखा बता दियो। ");
INSERT INTO hlb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","“रस्ता म आगे बढ़ते हुए वी कई पानी को जोने पहुँचिया फिर उ खोजा मंतरी न कय्हो, देख! यहाँ पानी हैं।” अब मोखा बपतिस्मा लेनो म का बात को रोक हैं? ");
INSERT INTO hlb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिप्पुस न कहयो “अदि तू पुरो मन से भरोसा करह हैं ते ले सकह हैं।” ओ न उत्तर दियो, “मी भरोसा करु हूँ कि यीसु मसी परमेस्वर को पोरिया हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","तब ओ ना रथ खड़ो करन को आदेस दियो, अर फिलिप्पुस अर खोजा दोई पानी म उतर पढ़िया, अर ओ ना खोजा ख पानी बपतिस्मा दियो। ");
INSERT INTO hlb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","जब वी पानी म से निकल ऊपर आय, ते प्रभु को आत्मा फिलिप्पुस का उठायो ले गयो, अर खोजे न ओ ख फिर नी देखियो अर उ खुसी मानत हुयो अपनो रस्ता म चल दियो। ");
INSERT INTO hlb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","फिलिप्पुस असदोद म निकल्यो, अर जब तक कैसरिया म नी पहुँचियो, तब तक पुरो नगर-नगर सुसमाचार सुनाते गयो। ");
INSERT INTO hlb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","साऊल प्रभु ख मानन वाला विस्वासी अदमी हुन ख मार डालन कि धमकी देते ही जात रह उ प्रमुख याजक को जोने गयो ");
INSERT INTO hlb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","फिर ओ ना दमिस्क को प्रार्थना घर म हुन ख नाम माँग ख अधिकार चिठ्टी ले लियो जसो ओखा वहाँ अदि कोई ओखा यीसु मसी ख मानन वाला विस्वासी मिले, फिर जाहे वा ओरत होय चाहे अदमी होय ते उ उनका पकड़ ख फिर वापस यरूसलेम लेखा आहे। ");
INSERT INTO hlb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","जब साऊल दमिस्क सदा को जोने पहुँच गयो, ते एक दम से आकास म से उजाला ओकी आँखी म आ गयो, ");
INSERT INTO hlb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","अर वी जमीन पर गिर पड़ो अर यू सब्द सुनियो, “हे साऊल, हे साऊल, तू मोखा काहे सतावा हैं?” ");
INSERT INTO hlb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","साऊल न पुछयो, “प्रभु, तू कोन आय?” उतर मिल्यो, “मी यीसु आय, जेखा तू सतावा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","पर तू अब खड़ो हो अर सहर म जा। उते तोखा बता दियो जाहे कि तोखा का करनो चहिए।” ");
INSERT INTO hlb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","जे अदमी ओके संग हते, वी दंग रय्ह गया; काहेकि सब्द ते सुनत हते पर या कोई का नी देखयो। ");
INSERT INTO hlb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","तब साऊल जमीन पर से उठयो, परन्तु जब आँख हुन खोली ते ओ ख कुछ नी दियो, अर वी ओखा हात पकड़ का दमिस्क सहर ले गयो। ");
INSERT INTO hlb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","वी तीन दिन तक नी देख सकिया, अर वी दिन म कुछ नी खायो अर न पियो। ");
INSERT INTO hlb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमिस्क म हनन्याह नाम को एक चेला हता, ओसे प्रभु न दर्सन म कय्हो, “हे हनन्याह!” ओ न कय्हो, “प्रभु मे याहा हूँ।” ");
INSERT INTO hlb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","तब प्रभु न ओसे कय्हो, उठ ख उ गली म जा जो “सिधी” कहलाता हैं, अर यहूदा का घर म साऊल नाम को एक तरसुस वासी का पुछियो; काहेकि देख, वी प्रार्थना कर रय्हो हैं, ");
INSERT INTO hlb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","“अर ओ न हनन्याह नाम को एक अदमी का आन्दर आत अर अपन ऊपर हात रखत देखो हैं; ताकि फिर से नजर पाएगो।” ");
INSERT INTO hlb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","हनन्याह न उत्तर दियो, “हे प्रभु, मी न यू इंसान को बारे म बेजा कुछ सुनो हैं कि यरूसलेम म तोरो ऊपर सुध्द अदमी हुन को संग यरूसलेम बड़ो-बड़ो बुराई हुन की हैं; ");
INSERT INTO hlb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","अऊर यू भी येखा प्रमुख याजक हुन की तरफ से अधिकार मिलो हैं, जो इंसान हुन तोरो नाम ख लेवा हैं वी सब ख बाँध ले।” ");
INSERT INTO hlb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","पर प्रभु न ओसे कय्हो, “तू जा काहेकि यू इंसान ख गैर यहूदी हुन अर राजा हुन अऊर इस्राएल ख रहन वाला इंसान हुन को सामे मोरो नाम लेवन को लाने मीन ऐका चुनियो।” ");
INSERT INTO hlb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","“अर मी तो ख बताऊँगो कि मोरो नाम को लियो ओ ख कसो कसो दुख उठानो पडेगो।” ");
INSERT INTO hlb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","तब हनन्याह उठ ख ओ घर म गयो अर जाहा साऊल था, अर ओ पर पर अपनो हात रख ख कय्हो, “हे साऊल भई, प्रभु, अर्थात् यीसु, जे ओ रस्ता म, जेसे तू आयो तोखा दिखाई दियो हतो, ओको न मोखा भेजो हैं कि तू फिर नजर पाएगो अर सुध्द आत्मा से भर जाएगो।” ");
INSERT INTO hlb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","फिर तुरत बाद छिलका जसी कोई चीज ओकी आँखी से गीड़ी अर ओखा फिर से दिखन लग गयो। उ खड़ो भयो अर ओ ना बपतिस्मा लियो; ");
INSERT INTO hlb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","फिर थोड़ो सो खाना का बाद ओ ना अपनी ताकत ख फिर से ले लियो। उ दमिस्क म विस्वासी चेला हुन को संग कुछ दिन अऊर रूकियो। वी कई दिन उन चेला हुन को संग रय्हो जे दमिस्क म हते। ");
INSERT INTO hlb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","अर वी तुरंत प्रार्थना घर हुन म यीसु को प्रचार करन लगिया कि यीसु ही परमेस्वर को पोरिया हैं। ");
INSERT INTO hlb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","जो कोई न मी, ओको परचार ख सुन्यो म पड़ गया अऊर कहन लग्या, “का यू उई नी आय, जो यरूसलेम म यीसु को ऊपर भरोसा करन वाला ख करन कि कोसिस करत रहा अऊर का यू क इते पकड़न अर प्रमुख याजक हुन को जाने लेका जान को लाने नी आयो रहा?” ");
INSERT INTO hlb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","पर साऊल को परचार अऊर मी जादा सक्तीसाली होते गयो अऊर दमिस्क म रहन वाला यहूदी हुन ख यू बताते हुए कि यू यीसु ही मसी आय, हरान लग गयो। ");
INSERT INTO hlb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","बेजा रोज बीत जान को बाद यहूदी हुन न ओखा मार डालन को लाने पिलान बनायो। ");
INSERT INTO hlb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","पर ओकी योजना साऊल को पता चल गयो। वी सदा अर दरवाजा हुन पा रात दिन ताँक लहा ख रहत रहा ताकि ओखा खतम कर दे हे। ");
INSERT INTO hlb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","पर रात ख ओके चेला हुन न ओ ख बाउनडरी म बैठ यो, अर बाउनडरी पर से लटका ख उतार दियो। ");
INSERT INTO hlb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","फिर जब पोलुस यरूसलेम पहुँचियो ख ओ न चेला हुन को संग मिल जानो को प्रयास कियो; पर सब ओसे डरत हते, काहेकि उन ख विस्वास नी होत हतो, कि वी भी चेला हैं। ");
INSERT INTO hlb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","पर बरनबास न ओ ख अपना संग प्रेरित हुन क नजीक ले जाय ख ओको बतायो कि साऊल से मार्ग म प्रभु ख देखियो, अर ओ ना ओसे बात कियो; फिर दमिस्क म इन कसो हिम्मत से यीसु को नाम से प्रचार कियो। ");
INSERT INTO hlb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","वी ओके संग यरूसलेम म आन जान रह अर बेधड़क होयका प्रभु को नाम से प्रचार करत रहा। ");
INSERT INTO hlb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","अर कोई को डर नी होय ख प्रभु का नाम से प्रचार करत हता; अर उ यूनानी भासा बोलन वाला यहूदी हुन को संग बातचीत अर झगड़ा-लगड़ा करत लगिया। ");
INSERT INTO hlb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","यू जान ख भई ओ ख साऊल को कैसरिया ले आयो अर तरसुस ख भेज दियो। ");
INSERT INTO hlb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","असो तरीका से पुरो यहूदिया, गलील, अर सामरिया कि कलेसिया को उ बखत सान्ति से बितीयो। वहाँ कलेसिया अऊर जादा तेजी से बढ़न लग गी। काहेकि कि वी प्रभु से डर ख अपनो जीवन बितात रहा, अर सुध्द आत्मा न ओखा अऊर जादा उकसायो कय्हो रहा एकोलाने उनकी गिनती बढ़न लग गई। ");
INSERT INTO hlb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","फिर असो भयो कि पतरस लुद्दा म पूरो परदेस म फिरते रयो, उ सुध्द अदमी हुन का नजीक भी जा पहुँचियो जे लुद्दा म रहत हते। ");
INSERT INTO hlb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","उही ओ ख एनियास नाम को लकवा को जुड़ वाला एक अदमी मिलियो, जो आठ साल से खटिया म पड़ो हतो ");
INSERT INTO hlb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पतरस न ओसे कय्हो, “हे एनियास! यीसु मसी तो ख चंगो करह हैं। उठ, अपनो बिछोना बिछा ठिक कर।” तब वी तुरंत उठ खड़ो भयो। ");
INSERT INTO hlb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","तब लुद्दा अर सारोन क सब रहन वाला ओ ख देख ख प्रभु की ओर फिरा। ");
INSERT INTO hlb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","याफा म तबीता नाम कि एक विस्वासी बाई रहत रहा। जेको यूनानी मत लब होय हैं, “दोरकास एको मतलब” हिरनी वा हमेसा भलाई काम कर रहा अऊर गरीब हुन ख दान देत रहा। ");
INSERT INTO hlb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","उई बखत म वा जुड़हो गई; अर उन ना ओखा पानी सपड़ा ख अटारी पर रख दियो। ");
INSERT INTO hlb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","एकोलाने कि लुद्दा याफा सहर को नजीक हतो रह, चेला हुन न यू सुन ख कि पतरस ओमा हैं, दो अदमी भेज ख ओसे विनती करी, “कि हमरो यहाँ आनो म देर मत कर जो।” ");
INSERT INTO hlb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","तब पतरस उठख ओको संग हो लियो, अर जब वी पहुँचियो ते वी ओ ख उ अटारी पा ले गयो। सब विधवा हुन रोती हुयो ओको नजीक आ खडी भई अर जे कुरता अर कपड़ा दोरकास न ओको संग रहत हुए बनायो हते, दिखन लगिया। ");
INSERT INTO hlb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","तब पतरस न सब ख बहार निकाल दियो, अर घुटना टेक ख विनती करी अर मुर्दा लास कि तरफ देख ख कय्हो, कि “अरे तबीता, उठ।” तब ओ ना अपनी आँखी खोल दियो; अर पतरस ख देख ख उठ बैठी। ");
INSERT INTO hlb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ओ ना हात देख ख ओखा उठायो, अर अदमी या सुध्द अदमी हुन अर राड़ भई वाली बाई ख बुला ख ओखा जिन्दो दिखा दियो। ");
INSERT INTO hlb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","या बात पुरो याफा म फैल गयो; अर ढ़ेर सारो न प्रभु पर भरोसा कियो। ");
INSERT INTO hlb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","अर पतरस याफा म समोन नाम को कोई चमडा को धंदा करन वालो का घर म बेजा दिन तक रय्हो। ");
INSERT INTO hlb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरिया म कुरनेलियुस नाम को एक अदमी थो। जो रोमी सेना को सेना नायक हतो जेका इतालवी सेना दल को सतपति बोल जते रहा। ");
INSERT INTO hlb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","उ भक्त हतो, अर अपन सारो घरानो समेत परमेस्वर से डरत हतो, उ यहूदी गरीब इंसान हुन ख मददत को लाने दान देत रय्हा, अर रोज दिन परमेस्वर से विनती करत हतो। ");
INSERT INTO hlb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ओ ना दोपहर को तीन बजे को नजीक दर्सन म साफ सुतरो से देखियो कि परमेस्वर को एक स्वर्गदूत ओको नजीक आन्दर आय ख कहत हैं, “कुरनेलियुस!” ");
INSERT INTO hlb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","एकोलाने कुरनेलियुस करते हुए स्वर्ग दुत कि तरफ देखते बोल्यो, “अरे प्रभु, यू का आय?” स्वर्ग दूत न ओसे कय्हो, “तोरी बिनती अर गरीब लचार ख दियो वालो दान तो ख याद दिलान को लाने परमेस्वर को जोने पहुँच गया हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","अऊर अब कुछ इंसान हुन ख याफा भेज अऊर समोन नाम को एक इंसान ख, जोका पतरस भी बोलो जावा हैं; इते बुलवा ला। ");
INSERT INTO hlb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","“उ समोन नाम को एक चमडा को धंदा कान वालो को संग रह रयो हैं। ओको घर सागर को किनार म हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","जब वी स्वर्गदूत जे तोसे बात कि हती चलो गयो, ते ओ ना अपना दो दास हुन बुलायो, अर जो ओके नजीक म रय्हा करत हते ओ म से एक निजी साहयक भलो सिपाही ख बुलायो, ");
INSERT INTO hlb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","अर उन्हो सब बात बता ख याफा का भेजो। ");
INSERT INTO hlb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","दूसरो दिन जब वी चलत चलत नगर का नजीक पहुँचिया, तब पतरस लगभग दोपहर को निकट छत म प्रार्थना करन चढ़ियो। ");
INSERT INTO hlb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","जब वी खाना बनात ही रह।, ते पतरस न तैयारी कर रय्हो हतो ते पतरस न दर्सन देख्यो।; ");
INSERT INTO hlb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","अऊर ओ ना देख्यो कि आकास खुल गयो हैं। अऊर एक बड़ो चादर जसो कोई चीज नीचु उतर ख आवा हैं। ओखा चारी कोना से पकड़ ख जमीन पा उत्तरो जावा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","जे म जमीन को सब प्रकार को चऊपाए अर रेगन वालो जानवर अर आकास क पक्छी हता। ");
INSERT INTO hlb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ओ ख एक असो सब्द सुनाई दियो, “भी एक वानी न कहयो पतरस उठ, अर इनका मार अऊर खा।” ");
INSERT INTO hlb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","पतरस न बोल्यो, “प्रभु बिलकुम भी नी, काहेकि मी न कभी भी असुध्द या असुध्द खाना क कभी मी नी खायो।” ");
INSERT INTO hlb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","फिर दूसरो बार ओ ख सब्द सुनाई दियो, जे कुछ परमेस्वर न सुध्द ठहरायो हैं, “ओ ख तू काहे असुध्द मत कहव।” ");
INSERT INTO hlb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","तीन बार असो भयो; तब तुरत वी थाली आकास पर उठा लियो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","जब पतरस अपन मन म सोच म हतो, कि यू सपना जे मी न देखो, वी कहो सकत हैं, ते देखो, वी अदमी जिनका कुरनेलियुस न भेजो हतो, समोन को घर पता लगाया ख ओको दुवार को आ ख खड़ो भया, ");
INSERT INTO hlb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","अर पुकार ख पूछन लगियो, “का समोन जे पतरस कहलावा हैं, उ यही मेहमान हैं?” ");
INSERT INTO hlb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","पतरस तो ओ दर्सन पर ही सोच ही रय्हो हतो, कि आत्मा न ओसे कय्हो, “देख, तीन अदमी तोरो खोज म हैं। ");
INSERT INTO hlb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","अत: उठ ख नीचो जा, अर बिना सक ओखा संग हो लेवा; काहेकि मी ही न उनका भेजो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","तब पतरस न उतर ख उ अदमी हुन से कय्हो, “देख, जेकी खोज तुम कर रय्हा हैं, वी मी ही हूँ। तुम्हारो आन को क कारन हैं?” ");
INSERT INTO hlb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","उनना बोल्यो, “हमका सतपति कुरनेलियुस न भेजो हैं। उ परमेस्वर से डरन वालो धर्मी इंसान आय। यहूदी जात म ओकी बेजा मान इज्जत हैं ओसे सुध्द स्वर्गदूत न तोखा अपनो घर बुलान को निवता देन को अऊर जे कुछ तू कहे ओखा सुनन कि बोल्यो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ये पर पतरस उन्हे भीतरी बुला लियो अऊर रुकन को लाने जगह दी। फिर दुसरो रोज तैयारी कर ख उ उनको संग चल दियो। अऊर याफा ख कुछ भई हुन भी ओको संग चल दियो। ");
INSERT INTO hlb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","दूसरो दिन वी कैसरिया पहुँचिया, अर कुरनेलियुस अपन कुटुम हुन अर चोक्खो दोस्त ख इकट्ठा कर ख ओकी रस्ता देखत रय्हा हतो। ");
INSERT INTO hlb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","जब पतरस पीछे आत रह हतो, ते कुरनेलियुस न ओसे मुलाकात करी, अर ओको पाय पर गीर ख ओको पाय पड़ियो; ");
INSERT INTO hlb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","पर पतरस न ओखा उठा ख कय्हो, “खड़ो हो, मी भी तो एक इंसान ही आय।” ");
INSERT INTO hlb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","अर ओको संग बात चीत करते हुये भीतर गयो, अऊर उते ओ ना ढ़ेर सारा विस्वासी हुन ख इकट्ठो देख ख। ");
INSERT INTO hlb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ओ ना ओसे कय्हो, “तुम जाना हैं कि एक यहूदी को लाने अनजात को संग नाता रखनो या ओको घर जानो नियम को हिसाब से गलत हैं। पर फिर भी परमेस्वर न मो ख बतायो हैं कि मी कोई भी इंसान हुन ख नीच या असुध्द नी कैय सकू। ");
INSERT INTO hlb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","एकोलाने जब मी बुलायो गयो ते बिना कुछ बोल ख चलो गयो। अब मी पुछु हैं कि मोखा कोन सो काम को लाने बुलायो गयो हैं?” ");
INSERT INTO hlb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ये पर कुरनेलियुस म कय्हो, “चार रोज पहिले इत्ती बखत दिन को तीन बजे नी अपनो घर म बिनती करत रहा एकदम से सफेत फट कपड़ा म एक इंसान मोरो जोने आ ख खड़ो भयो।” ");
INSERT INTO hlb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","अऊर बोल्यो, “कुरनेलियुस। तोरी बिनती सुन लियो हैं अऊर गरीब लचार ख दियो वाला तोरा दान परमेस्वर को जोने पहुँच गया हैं। ");
INSERT INTO hlb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","एकोलाने कोई क याफा भेज ख समोन ख जोका पतरस बोला हैं, बुला। उ समुंदर को किनार समोन, चमडा को धंदा करन वालो को घर म मिजवान हैं। ");
INSERT INTO hlb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ऐको लाने तब मीना तुरत तोरो जोने अदमी भेजियो, अर तू न चोक्खो करियो कि तू आ गयो। अब हम सब इते परमेस्वर को जोने हैं, ताकि जो कुछ प्रभु न तोसे कय्हो हैं ओखा सुने।” ");
INSERT INTO hlb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","तब पतरस न कय्हो, “अब मो ख भरोसा भयो कि परमेस्वर कोई को संग पक्छ नी करा,” ");
INSERT INTO hlb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","बलकी अदमी कोई भी जात को काहे नी होय जो आते डरा हैं अऊर धर्म काम करा हैं उ ओखा अपना लेवा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","यईच आय वा खबर जेका ओ ना यीसु मसी को दुवारा सान्ति को सुसमाचार ख परचार करते बखत इस्राएल ख इंसान हुन ख दियो थो उ सभी को प्रभु आय।, ");
INSERT INTO hlb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","“तुम वा बड़ी घटी-घटना ख जाना हैं,” जो पुरो यहूदिया म बिती रहा। गलील से सुरू हो का यूहन्ना को बपतिस्मा दियो जान को बाद से जेको प्रचार यूहन्ना न करो गयो रहा: ");
INSERT INTO hlb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","परमेस्वर न उसी नासरी यीसु कसो तरीका से यीसु नासरत ख सुध्द आत्मा अर सामर्थ्य से अभिसेक करियो; उ भलाई करा अर सब का जो सैतान का सताया वाला हता, चोक्खो करते फिरीयो, काहे की परमेस्वर को संग म हतो ");
INSERT INTO hlb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","हम वी सब काम हुन को गवाह हैं; जो ओ ना यहूदिया को अऊर यरूसलेम म भी करीया। उईच यीसु ख उनना सूली पा खिल्ला ठोक ख लकड़ी पा लटका ख मार डाल्यो। ");
INSERT INTO hlb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ओको परमेस्वर न तिसरो रोज जिन्दो कियो, अर प्रगट भी कर दियो हैं; ");
INSERT INTO hlb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","सब अदमी हुन पर वरन् उ गवाह हुन पर जिन ख परमेस्वर न पहलो से ही लियो हतो अर्थात् हम पर जिन्होना ओको मरो भयो म से जिन्दो उठन को बाद ओको संग खायो पियो; ");
INSERT INTO hlb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","“ओ ना ही हमका आदेस दियो कि हम इंसान हुन ख बताया अऊर साबीत करे कि यू उईच आय, जो परमेस्वर न जिन्दो अर मरो हुओ को न्याय करन वालो का बनन ख चुनो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ओकी सब भविस्यवक्ता गवाई देव हैं कि जे कोई ओ पर विस्वास करेगों, ओको ओके नाम को व्दारा पाप हुन को माफ मिलेगी।” ");
INSERT INTO hlb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पतरस यू बात कह ही रय्हो हतो कि सुध्द आत्मा ओको सन्देस सुनन वालो पर उतर आयो। ");
INSERT INTO hlb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","काहेकि सुध्द आत्मा को वरदान गैर यहूदी हुन पा भी उँडेल दियो जात रहा, एकोलाने पतरस को संग आया वाला यहूदी विस्वासी सोच म पड़ गया। ");
INSERT INTO hlb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","काहेकि वी गैर यहूदियो उन्होना उन ख अलग अलग भासा बोलत अर परमेस्वर कि बड़ाई करत सुनियो। इ पर पतरस न कय्हो, ");
INSERT INTO hlb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“क कोई पानी ख रोक सकत हैं कि ये बपतिस्मा नी पायो, जिन्होना हमारो समान सुध्द आत्मा पायो हैं?” ");
INSERT INTO hlb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","अर पतरस अपना हुकुम दियो कि उन ख यीसु मसी को नाम म बपतिस्मा दियो जाएगो। तब उन्होना पतरस से ओसे विनती की कि वी कुछ दिन अर ओके संग रय्हे। ");
INSERT INTO hlb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","फिर प्रेरित हुन अर भई हुन जे यहूदिया म हते सुनो कि दुसरी जात हुन न भी परमेस्वर को वचन मान लियो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","जब पतरस यरूसलेम पहुँचियो ते जो विस्वास हुन न खतना कर लियो वाला इंसान हुन ओसे भेस बाजी करन लग गया, ");
INSERT INTO hlb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“तू न खतना नी करिया लोग हुन ख यहाँ जाय ख ओके संग काहे खायो।” ");
INSERT INTO hlb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ये पर पतरस न हकिगत म जो घटयो रहा, ओखा सुनान समझान लग गया, ");
INSERT INTO hlb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","मी याफा सहर म विनती कर रय्हो हतो, अर बेसुध होय ख एक सपना देखियो कि एक थाली, बड़ो चादर को समान चारो कोन हुन से लटकायो भयो, आकास से उतर ख नजीक आयो। ");
INSERT INTO hlb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","जब मी न ओ पर ध्यान से देखयो, ते ओमा दुनिया का चार पाय वाला अर जंगल म जानवर अर रेगन वाला जीव जन्तु अर आकास म उड़न वाली चिड़िया हुन देखो; ");
INSERT INTO hlb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","अर यू आवाज भी सुनो, पतरस उठ, पकड़ मार अऊर खा। ");
INSERT INTO hlb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“पर मीन कय्हो,” प्रभु सही म नी, काहेकि मीना कभी भी कोई असुध्द अर असुध्द खाना ख हात से छियो तक नी हाय। ");
INSERT INTO hlb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","येको बारे म आकास से दुसरी बार फिर से या आकासवानी भई, जो कुछ परमेस्वर सुध्द ठहरायो हैं ओखा असुध्द मत बोला। ");
INSERT INTO hlb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","तीन बार असो ही भयो; तब सब कुछ फिर आकास म उठा लियो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","अर देखो, तुरत तीन अदमी जे कैसरिया से मोरो नजीक भेजो गयो हतो, उ घर पर जेम हम हते, आ ख खड़ो भया। ");
INSERT INTO hlb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","तब आत्मा न मोसे उनको संग बेधड़क चल कय्हो।, यी छे: भई हुन मी मोरो संग गया। अऊर हमना उ इंसान को घर म गया। ");
INSERT INTO hlb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ओ ना हम ख बतायो, कि ओ ना एक स्वर्गदूत ख अपनो घर म खड़ो देखो, जेना ओसे कय्हो, याफा म इंसान भेज ख समोन ख जेखा लोग हुन पतरस बोला हैं, बुलवा ला। ");
INSERT INTO hlb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","उ तुम से असी बात बोलेगो, जेको व्दारा तू अर तोरो परिवार या घराना उध्दार पाएगो। ");
INSERT INTO hlb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","जसो ही मीना बोलनो चालू करयो ते सुध्द आत्मा उन पा उतरियो। ठीक वसो ही जसो सरू म हम पर उतरियो रहा। ");
INSERT INTO hlb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","तब मोखा प्रभु को उ वचन याद आयो; जो ओ ना कय्हो रह, यूहन्ना न तो पानी से बपतिस्मा दियो, पर तुम सुध्द आत्मा से बपतिस्मा पाएगो। ");
INSERT INTO hlb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","असो तरीका से अदि परमेस्वर न गैर यहूदी हुन ख मी उईच वरदान दियो जेखा ओ ना जब हमना प्रभु यीसु मसी को नाम पा भरोसा मी करयो रह, तब हमका दियो रहा, “ते रोकन वालो मी कोन होत आय?” ");
INSERT INTO hlb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","विस्वासी हुन न जब यू सुनियो ते उनना जबाब पुछनो बन्द कर दियो। “वी परमेस्वर कि बड़ाई कर ख कहन लग गया,” अच्छा, ते परमेस्वर न गैर यहूदी हुन तक ख मन फिरान को उ मऊका दे दीयो हैं, “जो अनन्त काल को जीवन की तरफ ले जाय हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","वी इंसान जो उ स्तिफनुस को बखत म पड़ो मिलन वालो दुख को वजे से तितिर-बितर हो गया रहा, वी फीनीके अर साइपरस अर अन्ताकिया म पहुँचियो; पर यहूदिया ख छोड़ कोई अर का सन्देस नी सुनात रह। ");
INSERT INTO hlb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","यीच गैर यहूदी हुन म से कुछ झन साइपरस अर कुरेनी ख विस्वासी हता, वी अन्ताकिया म आय ख गैर यहूदी हुन ख भी प्रभु यीसु को सुसमाचार की बात सुनावन लग गया। ");
INSERT INTO hlb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","प्रभु की सामर्थ ओ पर हती, अर ढ़ेर सारो इंसान भरोसा कर ख प्रभु की तरफ फिरया। ");
INSERT INTO hlb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","जब ओकी चर्चा यरूसलेम की कलीसिया को सुननो म आई, ते उनना बरनबास का अन्ताकिया भेजो। ");
INSERT INTO hlb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","उ वहाँ पहुँच ख अर परमेस्वर की दया देख ख खुस हो गयो, अर सब ख ग्यान दियो कि तन मन लगा ख प्रभु से लिपटिया रहनु। ");
INSERT INTO hlb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","काहेकि बरनबास एक अच्छो इंसान हतो, अर सुध्द आत्मा से भयो हतो मजबूत हतो; अर ढ़ेर सारो इंसान प्रभु म आ खा मिलयो ");
INSERT INTO hlb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ओको पस्चात बरनबास साऊल ख ढ़ूँढ़न को लाने तरसुस ख चल दियो। ");
INSERT INTO hlb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","जब उ ओसे मिलो ते ओखा अन्ताकिया म लायो अर असो भयो कि वी एक साल तक कलीसिया को संग मिलत अर ढ़ेर सारो इंसान हुन ख परमेस्वर को ग्यान सिखाते रया; अर चेला सबसे पहलो अन्ताकिया ही म मसी कहलायो। ");
INSERT INTO hlb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","वी दिन म कई भविस्यवक्ता यरूसलेम से अन्ताकिया आयो। ");
INSERT INTO hlb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","उनमा से अगबुस नाम को एक न खड़ो होख सुध्द आत्मा की अगुवाई से यू बतायो कि पुरो दुनिया म एक भयानक अकाल पड़न वालो हैं उ अकाल क्लोदियुस को बखत म आयो रहा। ");
INSERT INTO hlb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","तब चेला हुन न निर्णय करियो कि हर एक झन अपनी-अपनी पूंजी को हिसाब से यहूदिया म रहन वाला भई हुन की मदत को लाने कुछ भेजयो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","उनना असो ही कियो; अर बरनबास अर साऊल को हात सियाना को नजीक दान भेजो दियो। ");
INSERT INTO hlb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ओ बखत हेरोदेस राजा न कलीसिया का कई इंसान हुन ख मार डालन को लाने उन ख पकड़ियो। ");
INSERT INTO hlb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ओ न यूहन्ना को भई याकूब का तलवार से मार डालियो। ");
INSERT INTO hlb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","जब ओ न देखियो कि यहूदी लोग इसे खुसी होत हैं, ते ओ ना पतरस का भी पकड़ लियो वी दिन अखमीरी रोटी को दिन हतो। ");
INSERT INTO hlb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ओ न पतरस ख पकड ख जेल म डाला दियो, अर चार-चार सिपाही हुन क चार पहरो म रखो हतो; इ विचार से की फसह को तिहार को बाद ओपर मुकदमा चलान कि सोचत रहा। ");
INSERT INTO hlb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","जेल खाना म पतरस बन्द हतो; उते कलीसिया ओको लाने लो लगाया ख परमेस्वर से बिनती करते रहा। ");
INSERT INTO hlb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","जब हेरोदेस ओ ख लोग हुन को सामे लान को हतो, उही रात पतरस दो जंजीर से बंधो भयो दो सिपाही हुन को बीच म सो रय्हो हतो; अर पहरूयो दरवाजा प जेल को रखवाली कर रय्हो हतो। ");
INSERT INTO hlb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","अचानक प्रभु को एक स्वर्ग दूत वहाँ पर घट हो गयो, जेल कि कोठरी उजेरो से चकाचक हो गई, ओ ना पतरस कि पीठ थपथपायो अऊर ओखा जगा ख कय्हो, तुरत खड़ो हो। साँकल हात से खुल ख गीर गई। ");
INSERT INTO hlb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","तब स्वर्गदूत न ओसे कय्हो, “कमर बाँधियो, अर अपन चप्पल पहिन लेवा।” ओ न वसो ही कियो। फिर ओ न ओसे कय्हो, “अपनो कपड़ा पहिन ख मोरो पिछु हो लेवा।” ");
INSERT INTO hlb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","पतरस निकल ख ओको पिछु होए लियो; परन्तु यू नी जानत हतो कि जे कुछ स्वर्गदूत कर रय्हो हैं वी सच हैं, वरन् यू समझो कि मी सपना देख रय्हो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","तब वी पहलो अर दूसरो पहरो से निकल ख ओ लोहो को फाटक पर पहुँच ख, जे नगर की तरफ हैं। वी ओको लियो तुम खुलो गयो, अर वी निकल ख एक ही गली होयख गयो, अर अर तुरत ही स्वर्ग दूत ओ ख छोड ख चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","फिर पतरस ख जसो ही होस आयो, ओ ना बोल्यो, “अब मोरी समझ म आयो कि यू सचमुच म सही हैं कि प्रभु न अपनो स्वर्ग दूत ख भेज ख राजा हेरोदेस को पंजा से मोखा छुड़ायो हैं। यहूदी इंसान हुन जो कुछ मोरो संग करन कि सोचत रहा, ओसे ओ ना ही मऊका बचायो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","यू जान ख वी उ यूहन्ना की माय मरियम को घर म आयो, जे मरकुस कहलाता हैं। उही बेजा से लोग जमा हो ख अर प्रार्थना कर रय्हा हते। ");
INSERT INTO hlb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","जब ओ ना दुवार की खिड़की खटखटायो, ते रूदे नाम को एक दासी देखन ख आई। ");
INSERT INTO hlb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","पतरस को सब्द पहचान ख ओ न खुसी को मारे म ओ न फाटक नी खोलियो, पर वी तुरंत आन्दर भाग ख गई अर बतायो कि पतरस दुवार पर खड़ो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","उन्होना ओसे कय्हो, “वी ओ से बोल्या तू पागल हो गई हैं।” पर वी हिम्मत से बोल्यो कि असो ही हैं तब उनना कय्हो, “ओको स्वर्गदूत होएगो।” ");
INSERT INTO hlb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","पर पतरस दुवार खटखटाते ही रयो: अत: उनना खिड़की खोलियो, अर ओ ख देख ख दंग रह गयो। ");
INSERT INTO hlb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","परतस तब ओ न उन ख हात से संकेत कियो कि चुप रहा अर तब ओखा बतायो कि प्रभु का रिती से ओ ख जेल से निकाल लायो हैं। फिर कहयो, “याकूब अर दुसरा विस्वासी हुन ख अर भई को या बात बता देजो। तब निकल ख दुसरी जगह चलो गयो।” ");
INSERT INTO hlb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","जब भुसारे भयो ते पैहरे दार हुन म बडी हड़बडी मच गई। वी हईरान होय ख सोच म पड़ गया कि पतरस को संग का भयो। ");
INSERT INTO hlb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ऐकोबाद राजा हेरोदेस जब ओकी छान बिन कर चुकियो उ ओखा नी मिल्यो ते ओ ना पैहरे दार हुन से पुछ परख करी अर उनका मार डालन को हुकुम दियो अऊर उ यहूदिया ख छोड़ ख कैसरिया म जाय ख रहन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","राजा हेरोदेस सूर अर सैदा क लोग हुन से बेजा घुस्सा करत रहा। एकोलाने वी एक चित्त होयख ओको नजीक आयो, अर बलास्तुस का जे राजा को एक काम करन हतो, मान ख मेल करन चाहयो; काहेकि राजा को देस से उनख देस को पालन पोसन होत रहा। ");
INSERT INTO hlb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","एक खाँस दिन आन पर हेरोदेस राज को कपड़ा पहिन ख सिंहासन पर बैठियो, अऊर उनका समझान लग गयो। ");
INSERT INTO hlb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","तब लोग पुकार उठियो, “यु ते अदमी को नी ईस्वर को सब्द आय।” ");
INSERT INTO hlb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","इही बखत प्रभु को एक स्वर्ग दूत न तुरंत ओ ख मारो, काहेकि ओ न परमेस्वर का महिमा नी करी रह; अर वी कीड़े पकड मर गयो। ");
INSERT INTO hlb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","पर परमेस्वर को वचन बढ़त अर फैलतो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","जब बरनबास अर साऊल अपन सेवा पूरो कर चुकियो ते यूहन्ना का जे मरकुस कहलाता हैं संग लेय ख यरूसलेम से लउटियो। ");
INSERT INTO hlb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अन्ताकिया की कलीसिया म कई भविस्यवक्ता अर सिखना वाला हते; जसो: बरनबास अर समोन जे नीगर कहलाव हैं; अर लूकियुस कुरेनी, अर चऊथाई देस को राजा हेरोदेस को दूधभई मनाहेम, अर साऊल। ");
INSERT INTO hlb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","जब वी उपास रह ख प्रभु की सेवा कर रय्हे हते, ते सुध्द आत्मा न कय्हो, “मोरो लियो बरनबास अर साऊल का उ काम को लाने अलग करियो जेको लियो मी न उन ख बुलायो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","तब उन्होनो उपवास अर प्रार्थना कर ख अर ओ पर हात रख ख उन ख बिदा कियो। ");
INSERT INTO hlb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","अत: वी सुध्द आत्मा को भेजो भया सिलूकिया ख गया; अर उही से जहाज पर चढ़ ख साइपरस ख चलो गयो; ");
INSERT INTO hlb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","अर सलमीस म पहुँच ख, परमेस्वर को वचन यहूदिया को प्रार्थना घर हुन म सुनायो। यूहन्ना ओको सेवक हतो। ");
INSERT INTO hlb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","वी उ सारो टापू म होत भयो पाफुस तक पहुँचियो। उही उन ख बार-यीसु नाम को एक यहूदी टोना अर झूटा भविस्यवक्ता मिलियो। ");
INSERT INTO hlb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","वी हाकिम सिरगियुस पोलुस को संग हतो, जे होसियार अदमी हतो। ओ न बरनबास अर साऊल ख अपन नजीक बुला ख परमेस्वर को वचन सुनायो चाहयो। ");
INSERT INTO hlb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","परन्तु इलीमास टोना न, काहेकि उही ओको नाम को अर्थ हैं, ओको विरोध कख हाकिम ख विस्वास करन से रोकन चाहयो। ");
INSERT INTO hlb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","तब साऊल न जेको नाम पोलुस भी हैं, सुध्द आत्मा से भरख ओकी तरफ टकटकी लगाए ख देखो अर कय्हो, ");
INSERT INTO hlb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“हे सारो कपट अर सब चतुराई से भारो भयो सैतान को पोरिया, सकल धर्म को बैरी हुन, क तू प्रभु को सिधो रस्ता हुन को टेढ़ो करन नी छोड़ोगो? ");
INSERT INTO hlb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","अब देख, प्रभु को हात तोरो पर लगो हैं; अर तू कुछ बखत तक अंधो रहेगो अर सूरज ख नी देखेगो।” तब तुरंत ओ पर धुंधलोपन छा गयो अर अन्धेरो भी ओ पर छा गयो, अर वी इते उते टटोरन लगियो ताकि कोई ओको हात पकड़ख ले चले। ");
INSERT INTO hlb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","तब हाकिम न जे भयो हतो ओ ख देख ख अर प्रभु को सिक्छा से बेजा चकित होयख विस्वास कियो। ");
INSERT INTO hlb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पोलुस अर ओके संगी हुन पाफुस से जहाज खोलख पंफूलिया क पिरगा म आयो; अर यूहन्ना उन ख छोड़ख यरूसलेम ख लउट गयो। ");
INSERT INTO hlb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","पिरगा से आगू बढ़ ख वी पिसिदिया क अन्ताकिया म पहुँचियो; अर आराम को दिन प्रार्थना घर म जाय ख बैठ गयो। ");
INSERT INTO hlb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","नेम अर भविस्यवक्ता की किताब से पढ़न क बाद प्रार्थना घर को मुखिया न ओके नजीक कहला भेजो, “हे भई हन, यदि लोग हुन की सान्ति क लियो तुम्हारो मन म कोई बात होए ते कह।” ");
INSERT INTO hlb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","तब पोलुस न खड़ो होयख अर हात से संकेत कर ख कय्हो, “हे इस्राएली हन, अर परमेस्वर से डरन वालो सुनो।” ");
INSERT INTO hlb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","इ इस्राएली लोग हुन क परमेस्वर न हमार बापदादा हुन का चुन लियो, अर जब यू लोग मिसर देस म परदेसी होयख रहत हतो, ते ओकी उन्नति कियो; अर बलवन्त भुजा से निकाल लायो। ");
INSERT INTO hlb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","वी कोई चालीस साल तक जंगल म ओकी सहता रय्हो, ");
INSERT INTO hlb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","अर कनान देस म सात जात हुन को नास कर ख ओखा देस कोई साढ़े चार सव साल म एको मीरास म कर दियो ");
INSERT INTO hlb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","एको बाद ओ न समूएल भविस्यवक्ता तक ओमा न्याय करन वालो ठहरायो। ");
INSERT INTO hlb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ओको बाद उनना एक राजा माँगो: एको बाद परमेस्वर न चालीस साल को लाने बिन्यामीन को गोत म से एक अदमी को पोरिया; एकोमतलब किस को पोरिया साऊल ख उन पा राजा ठहरायो। ");
INSERT INTO hlb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","फिर ओखा अलग करखा दाऊद ख उनको राजा बनायो; जेको बारे म ओ ना गवाही दियो, मोखा एक इंसान, यिसै को पोरिया दाऊद, मोरो मन को अनुसार मिल गयो हैं; उई मोरी पुरी इच्छा पुरी करेगों। ");
INSERT INTO hlb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","एको ही वंस म से परमेस्वर न अपनो वादा को अनुसार इस्राएल लोगो को बीच म एक उध्दार कर्ता, एको मतलब यीसु ख भेजो। ");
INSERT INTO hlb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","यीसु को आनो से पहले यूहन्ना न पुरा इस्राएली हुन म मन फिराव को बपतिस्मा को प्रचार करियो। ");
INSERT INTO hlb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","जब यूहन्ना न अपनी सेवा पुरी करन पा हतो, ते ओ न कय्हो, तुम मोखा का समझावा हैं? मी उ नी आय! लेकिन देखनु, मोरो बाद एक आन वालो हैं, जेको पाय कि जूता की बददी ख मी खोलन को लायक नी हाय। ");
INSERT INTO hlb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“हे भई हन, तुम जे अब्राहम को बच्चा हाय; अर तुम जे परमेस्वर से डरत हो, तुम्हारो नजीक इ उध्दार को वचन भेजो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","काहेकि यरूसलेम क रहन वाला अर ओके मुखिया हुन न ओ ख पहचानो अर नी भविस्यवक्ता हुन की बात समझी, जे हर छुट्टी को दिन पढी जात हैं, एकोलाने ओ ख दोसी ठहरायो उ बात हुन का पूरो कियो।” ");
INSERT INTO hlb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","उन्होना मार डालनो ख योग्य कोई दोस ओमा नी पायो, तोभी पिलातुस से विनती से विनती की कि वी मार डालो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","जब उन्होना ओको बारे म लिखो भई सब बात हुन पूरो कियो, ते ओ ख सूली पर से उतारख समसान म रखो। ");
INSERT INTO hlb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","पर परमेस्वर न ओ ख मरो म से जिन्दो कर दियो, ");
INSERT INTO hlb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","अर वी उन्हे जे ओको संग गलील से यरूसलेम ख आयो हतो, बेजा दिन हुन तक दिखाई देत रय्हो; लोग हुन का सामे अब वी ही ओको गवाह हैं। ");
INSERT INTO hlb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","हम तुम ख वादा को बारे म जे बाप दादा से कही गई हैं यू चोक्खो सुसमाचार सुनावा हैं ");
INSERT INTO hlb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","कि परमेस्वर न यीसु ख जिलायो ख, वही आग्या हमरी अऊलाद हुन को लाने पुरी करी जसो दुसरो भजन म भी लिखो गयो हैं, तू मोरो पोरिया आय; आज ही मी न तो ख पैदा करियो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","अर ओको इ रीति से मरो भयो म से जिलान क बारे म भी कि वी कभी नी सड़ेगो, ओ न यो कय्हो हैं, मी दाऊद पर को सुध्द अर अटल कृपा तुम पर करूँगो। ");
INSERT INTO hlb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","एकोलाने ओ ना एक अर भजन म भी कय्हो हैं, तू अपन सुध्द जन ख सड़न नी देगो। ");
INSERT INTO hlb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","काहेकि दाऊद ते परमेस्वर को इच्छा क अनुसार अपन बखत म सेवा कर ख सो गयो। अर अपन बापदादा हुन म जा मिलियो, अर सड़ भी गयो। ");
INSERT INTO hlb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","परन्तु जेको परमेस्वर न जिन्दो कियो, वी सडन नी पाएगो। ");
INSERT INTO hlb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","एकोलाने, हे भई हन, तुम जान लेनू कि इ के व्दारा पाप हुन को माफ को समाचार तुम्हे दियो जात हैं; मूसा को नेम जिन बात से तुमख मुक्त नी कर सका। ");
INSERT INTO hlb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","अर जिन बात हुन म तुम मूसा को नियम के व्दारा बेकसूर नी ठहर सकत हते, उन्ही सब म हर एक विस्वास करन वालो ओको व्दारा निर्दोस ठहरात हैं। ");
INSERT INTO hlb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","एकोलाने चऊकस रहनू, असो नी हो कि जे भविस्यवक्ता हुन किताब म आयो हैं, तुम पर भी आ पड़ो: ");
INSERT INTO hlb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","हे निन्दा करन वाला, देख, अर चकित हो, अर मिट जाए; काहेकि मी तुम्हारो दिन हुन म एक काम करत हूँ, असो काम कि यदि कोई तोसे ओकी चर्चा करेगों, “तो तुम कभी विस्वास नी करोगो।” ");
INSERT INTO hlb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ओको बाहर निकलत बखत लोग ओसे विनती करन लगियो कि अगलो छुट्टी को दिन हम ख यू बात फिर सुनाई जाएगो। ");
INSERT INTO hlb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","जब सभा उठ गयो ते यहूदियो अर यहूदी मत म आयो भयो पुजारी हुन म से बेजा से पोलुस अर बरनबास को पिछु हो लियो; अर उन्होना ओसे बात कर ख समझायो कि परमेस्वर को किरपा म बनो रय्हो। ");
INSERT INTO hlb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","अगलो छुट्टी को दिन नगर के भुसारो: सब लोग प्रभु को वचन सुनन का इकट्ठे हो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","पर यहूदी भीड़ ख देख ख जलन से भर गयो, अर निन्दा करत भयो पोलुस की बात हुन को विरोध म बोलन लगियो। ");
INSERT INTO hlb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","तब पोलुस अर बरनबास न निडर होय ख कय्हो, अवस्य हतो कि परमेस्वर को वचन पहलो सुनायो जातो; परन्तु जब तुम ओ ख दूर हटात होए अर अपन अनन्त जीवन क योग्य नी ठहरात, अर दुसरी जात की तरफ फिरत हैं। ");
INSERT INTO hlb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","काहेकि प्रभु न हमका यू हुकुम दियो हैं, मी न तो ख दुसरी जात को लियो रोसनी ठहरायो हैं, ताकि तू जमीन की छोर तक उध्दार को दारवाजा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","गैर यहूदी यू सुन ख अन्य जातियो खुसी भयो, अर प्रभु को वचन की बड़ाई करन लगियो; अर जीवन अनन्त को लियो ठहरायो गयो हते, उन्होना विस्वास ग्रहन कियो। ");
INSERT INTO hlb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","तब प्रभु को वचन उ सारो देस म फैलन लगियो। ");
INSERT INTO hlb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","पर यहूदी हुन न पुजारी अर कुलीन बाई हुन का अर नगर का प्रमुख लोग हुन को उस खयो, अर पोलुस अर बरनबास को खिलाप उपद्रव करवा ख उन ख अपन सीमा से निकाल दिया। ");
INSERT INTO hlb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","तब वी ओको सामे अपन पाय को धूल झाड़ ख इकुनियुम का चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","अर चेला हुन खुसी से अर सुध्द आत्मा से भरपुर्न होते गयो। ");
INSERT INTO hlb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","इकुनियुम म असो हुओ की वी यहूदिया को प्रार्थना घर म संग गया, अर इन प्रकार बात की यहूदी अर यूनानी हुन दोनो म से बेजा जहन न भरोसा कियो ");
INSERT INTO hlb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","पर भरोसा नी करन वाला यहूदी न दुसरी जात हुन को मन म भई हुन को विरोध म उपसायो अर फुट फैल पैदा कर दियो ");
INSERT INTO hlb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","वी बेजा दिन तक वाहा रहया अर प्रभु को भरोसो पर हियाव से बात करत रह थे अर वही उन का हात से चिन्ह अर अदभुत काम करवा ख कर अपन दया को वचन पर गवाही देवह हैं ");
INSERT INTO hlb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","पर नगर का इंसान म फुट पड़ गई थी उन से कितनो न यहूदी की आर अर कित्ता प्रेरित की ओर हो गया ");
INSERT INTO hlb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","पर जब दुसरी जात अर यहूदी उन का अपमान अर उन पर पथराव करन को लाने अपना मुखिया हुन समेत ओ पर दऊडया ");
INSERT INTO hlb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","तो वी यह बात ख जान गया अर लुकाउनिया के लुस्रा अर दिरबे नगरो म अर आसा पास को प्रदेसो म भाग गयो ");
INSERT INTO hlb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","अर वही सुसमाचार सुनान लगया ");
INSERT INTO hlb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुस्रा म एक इंसान बैठो थो जो पाव को लगडो थो वह जन्म से ही लंगडा था अर कभी नीय चलयो थो। ");
INSERT INTO hlb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","वह पोलुस बात करत सुन रहयो थो पोलुस न ओको ओर टकटकी लगा ख देखो की ओ ख चोक्खो हो जान को भरोसा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","अर ऊँचे सब्द से बोलो अपनो पाय को बल खडो हो ख तब वह उछल कर चलन फिरन लगयो। ");
INSERT INTO hlb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","इंसान न पोलुस का यू काम ख लूका लुकाउनिया भासा म उचो सब्द से कहयो देवता इंसान को रूप म हो कर हमारो पास उतर आयो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","उन न बरनबास को ज्यूस अर पोलुस हिरमेस कहयो काहे की वह बात करन म मेन था। ");
INSERT INTO hlb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","अर ज्यूस ख उस मन्दिर को पूजारी जो उन को नगर को सामने था बईल हुन अर फुल हुन को हार फाटको पर ला ख इंसान को संग बलिदान करनो चाहत था। ");
INSERT INTO hlb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","पर बरनबास अर पोलुस प्रेरित न जब यह सनो तो अपना कपड़ा फाडे अर भीड़ म लपके अर पुकार ख कहन लगो ");
INSERT INTO hlb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","अरे इंसान तुम का करह हम वी तो तुम्हारो समान दु; ख सुख भोगन वाला इंसान हैं अर तुम्हे सुसमाचार सुनायो हे की बेकार वस्तुओ ख अलग हो ख जीवितो परमेस्वर की ओर फिरो जिन स्वर्ग अर धरती अर समुदर अर जो उन म हैं बनाया ");
INSERT INTO hlb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","उन न बीते बखत म जात पात को अपनो अपनो मार्ग म चलन दिया ");
INSERT INTO hlb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","तोभी उन न अपनो पास की यू गवाह नी छोडया पन वह भलाई करते रहयो अर बादल से वर्सा अर फलवन्त रितू देक ख तुम्हारो मन को खाना अर खुसी से भरते रहयो ");
INSERT INTO hlb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","यह बोल कर भी उन न इंसान ख बडी मूसकिल से रोखयो की उन को लाने बलिदान नीय करह ");
INSERT INTO hlb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","पर कुछ यहूदी हुन न अन्ताकिया अर इकुनियुम से आ ख इंसान ख अपनी ओर कर लियो अर पोलुस पर पथराव कियो अर मरा समझकर ओ ख नगर को बाहार घीस ख ले गयो ");
INSERT INTO hlb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","पर जब चेला ओखा चारो ओर आ खडा भया तो वह उठकर नगर म गयो अर दुसरा दिन बरनबास को संग दिरबे को चलो गयो ");
INSERT INTO hlb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","वी उन नगर को अदमी को अच्छो सुसमाचार सुनवा ख अर बेजा सा चेला बना ख लुस्रा अर इकुनियुम अर अन्ताकिया को लउट आयो ");
INSERT INTO hlb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","अर चेला हुन को मन को स्थिर करत रह अर यह सन्देस देता था कि भरोसा म बना रहो अर यह सिखाते हैं हम ख बडो क्लेस उठाकर परमेस्वर को राज्य म प्रवेस करनो होगा ");
INSERT INTO hlb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","अर उन न हर एक कलीसिया म उन को लाने सियाना रखियो अर उपास सहित प्रार्थना कर ख उन ख प्रभु को हात सोपियो जो पर उन न विस्वास करयो रह ");
INSERT INTO hlb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","जब पिसिदिया से होते हुए वी पंफूलिया पहुँचिया ");
INSERT INTO hlb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","पर पिरगा म सुसमाचार सुना ख अत्तलिया म आया ");
INSERT INTO hlb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","अर वाहा से वी जहाज पर अन्ताकिया गया वी उन काम को लाने जो उन न पुरो किया था परमेस्वर को किरपा म सोपियो गयो थो ");
INSERT INTO hlb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","वाहा पहुँच कर उन न कलीसिया इकट्ठी की अर बोल्यो कि परमेस्वर न उन को संग हो ख कसो बडो बडो काम कियो अर दुसरी जात को लाने भरोसा को दुवार खोल दिया ");
INSERT INTO hlb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","अर वी चेला को संग बेजा दिन तक रहया ");
INSERT INTO hlb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","पर कुछ इंसान यहूदिया से आ ख भई हुन ख सिखान लगया यह मूसा की रिती पर तुम्हारो खतना ना हो तो तुम उध्दार नीय पा सका। ");
INSERT INTO hlb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","जब पोलुस अर बरनबास को उन से बेजा झगड़ा अर वाद विवाद हुओ तो यह ठहरायो गयो की पोलुस अर बरनबास अर उन म से कुछ अदमी इस बात को विसय म प्रेरित अर सियाना हुन को पास यरूसलेम को जावह। ");
INSERT INTO hlb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","अत; कलीसिया न उन ख कुछ दुर तक पहुचियो अर वे फीनीके अर सामरिया से होता हुआ दुसरी जात हुन को दिमाक फिराने को सुसमाचार सुनत गया अर सब भई बेजा खुसी भया ");
INSERT INTO hlb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","जब वी यरूसलेम पहुँचिया तो कलीसिया अर प्रेरित अर सियाना उन ख आनन्द को संग मिलियो अर उन न बतायो की परमेस्वर उन को संग हो ख कसो कसो काम करह हैं ");
INSERT INTO hlb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","पर फरीसी हुन को पंथ म से जिन न भरोसा करयो रह उन म से कुछ न उठ कर कहयो उन न खतना करने अर मूसा की नेम को मानन को ग्यान देनू हैं। ");
INSERT INTO hlb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","जब प्रेरित अर सियाना इस बात को बारे म विचार करन को लाने इखट्ठा भया ");
INSERT INTO hlb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","जब पतरस न बेजा वाद विवाद हो जानो को बाद खडो हो ख ओ ना बोलो ओ भई तुम जानह हैं की बेजा दिन भया परमेस्वर न तुम म से मो ख चुन लियो की मोरो मुँह से दुसरी जात हुन सुसमाचार को वचन सुन ख भरोसा करो ");
INSERT INTO hlb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","मन को जाँचन वालो परमेस्वर न उन ख हमारो समान सुध्द आत्मा देकर उन की गवाही दी ");
INSERT INTO hlb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","अर भरोसा को व्दारा उन को मन सुध्द कर ख हम म अर उन म कुछ भेद न रखो ");
INSERT INTO hlb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","तो अब तुम का परमेस्वर परीक्छा करत हो की चेला की गरदन पर असो बोझ रखो जिन न हमारो बाप दादा उठा सकते हैं अर हम भी उठा सहके हैं ");
INSERT INTO hlb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","हाँ हमारो यू विस्वास पक्को हैं की जो रिती वे प्रभु यीसु को दया से उध्दार पाऐ यू ही रिती से हम भी पाये। ");
INSERT INTO hlb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","जब पुरी पंचायत चुपचाप बरनबास अर पोलुस की सुनन लगया की परमेस्वर न उन को लाने व्दारा दुसरी जात हुन म कसो कसो बडो बडो चिन्ह अर अदभुत काम कियो ");
INSERT INTO hlb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","जब वी चुप भया तो याकूब कहन लगयो ओ भई मोरी सुन ");
INSERT INTO hlb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","समोन न बतायो की परमेस्वर न पहलो पहल दुसरी जात हुन पर कसी दया करी रह की उन म से अपनो नाम को लाने एक इंसान बना लो ");
INSERT INTO hlb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ऐसे भविस्यवक्ता की बात भी मिलह हैं जसो की लिखो हैं ");
INSERT INTO hlb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ओको बाद म फिर आ ख दाऊद को गिरो हुओ डेरा उठाउगा अर ओ ख खडो करु ");
INSERT INTO hlb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","एको लाने की अच्छो इंसान ऐको सब दुसरी जात जो मोरो नाम ख लेवा हैं, प्रभु ख ढुढे ");
INSERT INTO hlb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","यह वही प्रभू कवह हैं जो जगत को उत्पत्ती से इन बात को समाचार देता आयो हैं ");
INSERT INTO hlb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ऐको लाने मोरो विचार यू हैं की दुसरी जात म से जो इंसान परमेस्वर की तरफ फिरत हैं, हम उनका दुख नी दे; ");
INSERT INTO hlb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","पर उन न ओ ख भेजो की वी मुरती की असुध्दता अर गलत काम गला दबा ख मांस से अर खून से दुर रहो ");
INSERT INTO hlb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","उन न प्राचीन काल म नगर नगर मूसा को व्यवस्था को प्रचार करन वालो वाला चेला आया हे अर वह हर आराम को दिन प्रार्थना घर म पढ़ी जाय हैं ");
INSERT INTO hlb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","जब पुरी कलीसिया सहित सिखान वाला प्रेरित अर सियाना हुन ख को चोक्खो लगो कि अपन म से कुछ इंसान हुन ख चुने एको मतलब यहूदा जे ख बरसब्बा कवह हैं अर सीलास को जो भई हुन म मुखिया हतो अर उन ख पोलुस अर बरनबास को संग अन्ताकिया भेजो ");
INSERT INTO hlb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","उन न उन को हात यु लिख भेजो अन्ताकिया अर सीरिया अर किलिकिया को रहन वालो भई हुन ख को दुसरी जात म से हे प्रेरित अर सियाना भई हुन ख नमस्कार ");
INSERT INTO hlb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","हम न सूनो हैं कि हम म से कुछ न वही जाकर तुम ख अपनी बात से परेसानी करी अर तुम रो मन ख आ स्दीर कियो दियो अर तुम्हारो मन उलट पुलट कर दियो हैं पर हम न ओ ख आग्यानीय दियो रह ");
INSERT INTO hlb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ओको लाने हम न एक मन हो ख अच्छो समझो चुनो हुआ अदमी को अपन प्रिय बरनबास अर पोलुस को संग तुम्हारो पास भेजे ");
INSERT INTO hlb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","यू असो अदमी हैं जो न अपनो जान प्रभु यीसु मसी को नाम को लाने जोखिम म डालो हैं ");
INSERT INTO hlb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ओको लाने हम न यहूदा अर सीलास को भेजो हैं जो अपनो मुँह से भी यह बात कह देह ");
INSERT INTO hlb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","सुध्द आत्मा को अर हम ख चोक्खो जानो पडो की इन अच्छी बात ख छोड तुम पर अर बोझ नीय डालो ");
INSERT INTO hlb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","कि तुम मूरतो पर बलि कियो हुओ से अर खून से अर गला घोट कर हुआ कि मांस से अर गलत काम से दुर रहा ओ से दुर रहे ते तुम्हारो भला होये अर आगे चोक्खो रहे ");
INSERT INTO hlb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","फिर वी बिदा हो ख अन्ताकिया पहुँचिया अर पंचायत ख इखट्ठी कर ख वह चिठ्टी उन ख दे दियो ");
INSERT INTO hlb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","वी चिठ्टी पड़ ख अदमी की सान्ति की बात पढ़ ख मन म सान्त भयो ");
INSERT INTO hlb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यहूदा अर सीलास न जो ख भविस्यवक्ता हता बेजा बात से भई हुन ख उपदेस दे ख सान्त कियो ");
INSERT INTO hlb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","वी कुछ दिन रह ख भई को सान्ति को संग विदा हुआ की अपनो भेजन वालो को कने जाये ");
INSERT INTO hlb_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","पर सीलास को वाहा रहनू चोक्खो नी हाय ");
INSERT INTO hlb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","(पर पोलुस अर बरनबास अन्ताकिया म रह गयो अर अन्य बेजा सा इंसान को संग प्रभु को वचन को उपदेस करतो अर सुसमाचार सुनात रहया। ");
INSERT INTO hlb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","कुछ दिन बाद पोलुस न बरनबास से कहयो न जिन जिन नगरो म हम न प्रभु को सुसमाचार सुनायो रह आये पर उन म पहुँच कर अपना भई हुन ख देखे की वी कसा हैं ");
INSERT INTO hlb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","जब बरनबास ख यूहन्ना को जो मरकुस कहलाव हैं संग लेनो को विचार कियो ");
INSERT INTO hlb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","पर पोलुस न उन ख जो पंफूलिया म उन से अलग भया अर काम पर ओको संग नी गया संग ले जानो चोक्खो नीय झमजो ");
INSERT INTO hlb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","अत: असो झगड़ा उठो की एक दुसरा से अलग भया अर बरनबास मरकुस ख लेकर जहाज पर साइपरस चलो गयो ");
INSERT INTO hlb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","पर पोलुस न सीलास ख चुन लियो अर भई हुन ख प्रभु दया म सोपियो जा ख वाहा से चलो गयो ");
INSERT INTO hlb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","अर वह कलीसिया हुन ख स्धिर करतो हुआ सीरिया अर किलिकिया ख होतो हुओ निकलो ");
INSERT INTO hlb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","पर वही दिरबे अर लुस्रा म भी गयो वही तीमुथियुस नाम को चेला था जो जो कसो विस्वासी यहूदी को पोरिया था पर येको पिता यूनानी था ");
INSERT INTO hlb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","वह लुस्रा अर इकुनियुम को भई हुन म सुनाम थो। ");
INSERT INTO hlb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पोलुस को इकछा वा हतो की वी ओको संग जाय अर जो यहूदी इंसान यही जगह म था उन न ओको कारन ओ ना ओको खतना कियो काहे की वी सब जानह हैं की ओको बाप यूनानी हतो ");
INSERT INTO hlb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","अर नगर नगर जावह हुआ अर वी उन विधियो को जो यरूसलेम को प्रेरित अर सियाना हुन म रोखयो थो मानन को लाने उन ख पहुचान जात रह ");
INSERT INTO hlb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","यू प्रकार कलीसिया हुन भरोसा म स्थिर हती रह अर संख्या हर दिन बडत रह। ");
INSERT INTO hlb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","वी फूगिया अर गलातिया प्ररदेस म से हो ख गया काहे की सुध्द आत्मा न उन आसिया म वचन सुनान ख मना कियो। ");
INSERT INTO hlb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","उन न मूसिया क निकट पहुचा कर बितूनिया म जानो चाहायो पर यीसु को आत्मा न उन ख जान न दियो। ");
INSERT INTO hlb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","अत; वी मूसिया को हो ख त्रोआस म आयो ");
INSERT INTO hlb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","वही पोलुस न रात ख एक दर्सन देखो की एक मकिदूनी अदमी खडो भयो उन से विनती बोलत रह पार उतरकर मकिदुनिया म आ अर हमारो मदद कर। ");
INSERT INTO hlb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ओ ना यह सपना देखते ही हम न तुरत मकिदुनिया जानो चाहायो समझ ख की परमेस्वर न हम न उन ख सुसमाचार सुनन न को लाने बुलायो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","एको लाने त्रोआस से जाहज ख खोल ख हम सीधा सुमाताके अर दुसरा दिन नियापुलिस म आया ");
INSERT INTO hlb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","वही से हम फिलिप्पी पहुँचिया जो मकिदुनिया प्रांत को मेन नगर, अर रोमियो की बस्ती हैं अर हम उन नगर म कुछ दिन तक रहया ");
INSERT INTO hlb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","आराम को दिन हम नगर को फाटक को बाहार नद्दी को किनारो यह झमजा ख गया की वहा यहूदी प्रार्थना करन की जगह होऐ अर बैठ ख उन बाई हुन ख जो जमा भया रह बोलन ख लगया ");
INSERT INTO hlb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","लुदिया नामक थुआतीरा नगर को बैजनी पकड़ो बेचन वालो एक पुजारिन बाई सुनत रह प्रभु न ओको मन खोल दियो कि वह पोलुस की बात म मन लगाहे ");
INSERT INTO hlb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","जब ओ ना अपना घर सहित बपतिस्मा लियो की ओ ना हमारो सामने हात जोडया की यदि तुम मुझ प्रभु की विस्वासीनी समझ ख हो तो चल ख मोरो घर म चल ख रहो वह हम ख मना ख ले गयो। ");
INSERT INTO hlb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","जब हम प्रार्थना करन की जगह पर जा रहया था हम ख एक विस्वासी दासी मिले जो म भविस्य वाली आत्मा थी अर भविस्य कहन से अपनो मालिक को लाने बेजा कुछ कमा लावा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","वह पोलुस को अर हमरो पीछे आ ख चिल्लाने लगो यु अदमी परमप्रधान परमेस्वर को दास हैं हम उध्दार को मार्ग की कायनी (कथा) सुनान लगया ");
INSERT INTO hlb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","वी बेजा दिन तक असा ही करत रह पर पोलुस दुखी भयो अर मुड कर यु आत्मा से कहयो मी तो ख यीसु मसी को नाम से ढाटन लगया की ओ म से निकल जा अर वह उसी घड़ी नीकल गई। ");
INSERT INTO hlb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","जब उन ख मालिक ख देखो की हमारी कमाई की आसा जाती रही तो पोलुस अर सीलास को पकड ख चऊक म से मुखिया को पास खीच ले गयो ");
INSERT INTO hlb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","अर उन ख सेना को अधिकारी को जोने ले गया अर बोलयो यी इंसान जो यहूदी हैं हमारो नगर म हल चल मचा रहा। ");
INSERT INTO hlb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","अर असी रिती बोल रहया हैं जो ख गहन करन या मरन हम रोमी नागरीक क लाने सिवकार योग्य नी, ");
INSERT INTO hlb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","जब भीड़ को इंसान उन को विवाद म जमा हो ख चढ़ आया, अर हाकिमो न उन ख कपड़ा फाड़कर उतार डालो, अर उन ख कोडा मारन की बात बोली हैं ");
INSERT INTO hlb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","बेजा कोडा लगवाकर ओ ना उन ख जेल खाना म डाल दियो अर दारोगा बात बोल दियो उन न चोकसी म रखो ");
INSERT INTO hlb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","उन न असी आग्या दी कि उन ख पा ख कोठरी म रखो अर न ख भारी लकड़ी कि पाव काठ म ठोक दिया। ");
INSERT INTO hlb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","आधी रात को लगभग पोलुस अर सीलास प्रार्थना करते हुऐ परमेस्वर को भजन गा राहा था अर दुसरा कैदी उन ओ की सुन राहा था ");
INSERT INTO hlb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","इतनो म एका एक असो बडो भूकम्प आयो, याहा तक की जेल की नीव की हिल गयो, अर तुरत सब दुवार खुल गया; अर सब खा बन्धन खुल गया ");
INSERT INTO hlb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","दारागो जाग उठयो, अर जेल को दुवार खुला दे ख समझा की कैदी भाग गये हैं, अत: ओ ना अपनी तलवाल पकर ख अपनो तुम ख मार डालनो चाहायो। ");
INSERT INTO hlb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","पर पोलुस न ऊचा सब्द से नाम ले ख कहयो, “अपना तुम ख कोई हानी मत पहुचा काहे की हम सब यही हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","फिर वी दीया मगवा ख पास लपका अर कापतो हुओ पोलुस अर सीलास को सामने गिरया; ");
INSERT INTO hlb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","अर उन न बाहार ला ख कय्हो, “हैं मालिक हुन, उध्दार पावन को लाने का करु?” ");
INSERT INTO hlb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ओ ना कहयो, “प्रभु यीसु मसी पर भरोसा रख तू अर तो रो घराना उध्दार पाहे।” ");
INSERT INTO hlb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","अर उन न उन ख अर ओखा सारा घराना को अदमी ख प्रभु को वचन सुनाया ");
INSERT INTO hlb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","रात ख उसी बखत उन न उन ख ले जा ख उन खा घाव धोया, अर ओ ना अपना सब अदमी सहीत तुरत बपतिस्मा लियो ");
INSERT INTO hlb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","तब ओ न उन ख अपनो घर ले जा ख उन को सामने खाना रखो अर सारे घराना समेत परमेस्वर पर भरोसा कर ख आनन्द कियो काहेकि अब ओ न परमेस्वर पर भरोसा करयो। ");
INSERT INTO hlb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","जब दिन भयो तब हाकिमो न सिपाहियो को हात कहला भेजा की यु अदमी ख छोड दा। ");
INSERT INTO hlb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","दारोगा न या बात पोलुस से बोली हाकिम न तुम ख छोड देन की आग्या दियो हैं ओको लाने अब निकल ख सान्ति से चलो जाओ ");
INSERT INTO hlb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","पर पोलुस न उन ख बोलयो, “उन म जो रोमी इंसान हैं, दोसी ठहरायो बिना इंसान को सामने मारो अर जेल खाना म डाल दियो। अब हम ख चुपके से निकाल रहया हैं? असो नी; पर वी खुद आ ख बाहार निकाले।” ");
INSERT INTO hlb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","सिपाही हुन न यू बात हाकिमो से बोली, अर वी यह सुन ख कि रोमी हैं, डर गया, ");
INSERT INTO hlb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","अर उन ख आ क मनायो, अर बाहार ले जा ख विनती की कि नगर से चलो जाओ। ");
INSERT INTO hlb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","वे जेल खाना से निकल ख लुदिया को कने गया, अर भई से भेट कर ख उन ख सान्ति दी अर चला गया। ");
INSERT INTO hlb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","फिर वे अम्फिपुलिस अर अपुल्लोनिया हो ख थिस्सलुनीके म आयो, जहाँ यहूदी हुन को एक प्रार्थना घर हतो। ");
INSERT INTO hlb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","पोलुस अपनी रीति को अनुसार उन को कने गयो, अर तीन आराम को दिन सुध्दसास्र से उन को संग वाद विवाद करयो; ");
INSERT INTO hlb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","अर उन को मतलब खोल ख समझात रह कि मसी को दुख उठानो अर मरो म से जी उठनो, अवस्य हतो; अर “यही यीसु जोकी मी तुम ख कथा सुनात रह, मसी हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","उन म से कितनो न, अर पुजारी यूनानी हुन म से बेजा न, अर बेजा सा कुलीन स्तरियो न मान लियो, अर पोलुस अर सीलास को संग मिल गयो। ");
INSERT INTO hlb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","पर यहूदी हुन घुस्सा से भर ख फालतु घुमन वाला कुछ पापी इंसान हुन ख अपनो संग म लियो, अर भीड़ जोड ख सहर म हल्ला मचान लगया अर यासोन को घर प चडाई कर ख उन ख इंसान हुन को सामने लानो चाहयो। ");
INSERT INTO hlb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","उनख याहा न देख ख वी यह चिल्लाते हुऐ यासोन अर कुछ भई हुन को नगर म हाकिमो को सामने खीच लायो, “वी इंसान जीन न दुनिया को उलट पलट कर रखयो हैं, यहाँ भी आ गया हैं। ");
INSERT INTO hlb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","यासोन न उन ख यहाँ उतरियो हैं। यी सारा का सारा यह बोलह हैं की यीसु राजा हैं, अर कैसर की बात को विरोध करह हैं। ");
INSERT INTO hlb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","उन न इंसान की अर नगर का हाकिम को यह बोल ख घबरा दियो। ");
INSERT INTO hlb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ऐको लाने उन न यासोन अर बाकी इंसान से जमानत ले ख उन ख छोड दियो।” ");
INSERT INTO hlb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","भई हुन न तुरत रात ही रात पोलुस अर सीलास ख बिरीया भिजा दियो; अर वी याहा पहुँच कर यहूदी हुन प्रार्थना घर म गया। ");
INSERT INTO hlb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","यी इंसान हुन थिस्सलुनीके को लोगो हुन से बेजा अच्छा हता, अर हर दिन सुध्द सास्र म ढुँढ़ते रह कि यह बात योंही आय कि नी। ");
INSERT INTO hlb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ऐको लाने उन म से बेजा न, अर यूनानी बाई म से अर अदमी म से भी बेजा न विस्वास कियो। ");
INSERT INTO hlb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","किन जब थिस्सलुनीके क यहूदी जान गयो कि पोलुस बिरीया म भी परमेस्वर को वचन सुनावा हैं, ते वाहा भी आ ख इंसान ख उस हलचल मचान लगया। ");
INSERT INTO hlb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","जब भई हुन से तुरत पोलुस ख विदा कियो कि बन्दा को किनारे चलो जाओ पर सीलास अर तीमुथियुस यही रह गये। ");
INSERT INTO hlb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पोलुस ख पहुचान वाला उस एथेंस तक ले गयो; अर सीलास अर तीमुथियुस को लाने यह आदेस पाकर बिदा भया कि वी उन ख जल्दी से जल्दी आया। ");
INSERT INTO hlb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","तब पोलुस एथेंस उन की रस्ता देख रहयो थो, ते नगर म मूरतो म से भरो हुओ देख ख ओको ही पानी गयो। ");
INSERT INTO hlb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","अत: वी प्रार्थना घर म यहूदी अर पुजारी से, अर चऊराह म जो इंसान उन से मिलत रह उन ख वाद विवाद किया करत रह। ");
INSERT INTO hlb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","तब इपिकूरी अर स्तोईकी दर्सन करन म से, उन म से कुछ वजह जानन लगया, अर कुछ बोलन लगया, “यु बकवादी का बोलन चावह हैं?” पर दुसरो न बोलयो, “वी अन्य देवता ओको प्रचालको ख मालुम पडह हैं” काहे की वी यीसु को अर जी उठन को अच्छो सुसमाचार सुनावत रह। ");
INSERT INTO hlb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","जब वी अपना संग अरियुपगुस क सामे सहरी सभा म गयो अर पुछो, “का हम जान ख हैं की यह नयो बात जो तू सुनावह हैं, का हैं? ");
INSERT INTO hlb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","काहे की तू हम ख अनोखी बात सुनावह हैं, एकोलाने हम जानह हैं की चाहत हैं की इनको मतलब का हैं। ");
INSERT INTO hlb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","एको लाने कि सब एथेंसवासी अर दुसरा देस का जो वाहा रहत रह नयो-नयो बात बोलन ख अर सुनन को अलावा अर कोई काम म बखत नीय बितात रह।” ");
INSERT INTO hlb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","जब पोलुस न अरियुपगुस को बीच म खडो हो ख बोलयो, “हे एथेंस को अदमी, मी देखु हैं की तुम हर बात म देवताओ ख बडा मानन वाला हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","काहे की मी घुमतो हुओ तुम्हारो पुजनु की वस्तु हुन ख देख रहयो थो, तो एक असो वेदी भी पायो, जो पर लिखो थो, अनजान म ईस्वर को लाने। ओ खो लाने तुम बिना जाने पुजा हैं, मी उन को अच्छो समाचार सुनाउ हैं। ");
INSERT INTO hlb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","जो परमेस्वर न दुनिया अर उन की अब वस्तु हुन ओको बनायो, स्वर्ग अर दुनिया को मालिक हो ख मनुस्य हात को बनायो हुओ मन्दिर हुन म नीय रहत रह; ");
INSERT INTO hlb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","न कोई वस्तु कि आवस्कता को कारन इंसान हुन कि हतो कि सेवा लेवह हैं, काहे कियु अपनो तुम ख सब को जीवन अर स्वास अर सब कुछ देवह हैं। ");
INSERT INTO hlb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","उन ख एक ही मुल से इंसान कि सब जातिया सारी धरती पर रहन को लाने बनायो हैं; सीमा को ऐ को लाने बाँधा हैं, ");
INSERT INTO hlb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","कि वी परमेस्वर को ढुँढ़ें कदाचित उन ख टटोलकर पायो तेभी वही हम म से किसी से दुर नीय हाय। ");
INSERT INTO hlb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","काहे की हम ओ से जिन्दो रह, अर चलत-फिरत अर स्थित रहत रह। हम ते उसी का वंसज हैं। ");
INSERT INTO hlb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","अत: परमेस्वर को वंस हो ख हमे यह झमजनो जरूरी नी हैं ईस्वरत्व सोने या रुपे या गोटा को समान हैं जो इंसान की कारीगरी अर कल्पना से गढे गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ओको लाने परमेस्वर न अन्यता को बखतों पर ध्यान नी दियो, पर अब हर जगह सब इंसान को मन फिरान को आदेस देवह हैं। ");
INSERT INTO hlb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","काहे की उन न एक दिन रोखयो हैं, जो म एक इंसान को व्दारा धर्म से दुनिया को न्याय करे, जो ख उन न रोखयो हैं, अर उन म से मरिया हुआ म से जिलाकर ख यह बोली सब पर साबित कर दियो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","“मरा हुआ को जी उठन को बात सुन ख कुछ ते ठटा करन लगया अर कुछ न कहयो यह बात हम तोसे फिर कभी सुने।” ");
INSERT INTO hlb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","येपर पोलुस उनको बीच म से निकल गयो। ");
INSERT INTO hlb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","पर कुछ अदमी ओको संग मिल गया, अर भरोसा करियो; जिनमा दियुनुसियुस जो अरियुपगुस को मेम्बर हतो, अर दमरिस नाम की एक बाई हती, अर उनको संग अऊर भी इंसान हुन हता। ");
INSERT INTO hlb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ऐको बाद पोलुस एथेंस ख छोड़ ख कुरिन्थुस म आयो। ");
INSERT INTO hlb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","वहाँ ओखा अक्विला नाम को एक यहूदी मिलो, जेको जनम पुन्तुस म भयो हतो। उ अपनी घर वाली प्रिसकिल्ला को संग इटली से तुरत म ही आयो रह, काहेकि क्लोदियुस न पुरा यहूदी हुन क रोम से निकल जान को हुकुम दियो रह। एकोलाने उ पोलुस ख मिलन गयो। ");
INSERT INTO hlb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ओको अर उनको एक ही व्यपार हतो, एकोलाने उ उनको संग रयो अर वी काम करन लग गया; अर उनको उघम तम्बू तानन को हतो। ");
INSERT INTO hlb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","उ हर एक आराम को दिन प्रार्थना घर म बहस कर ख यहूदी हुन अर यूनानी हुन ख भी समझा वह को प्यास करह हैं। ");
INSERT INTO hlb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","जब सीलास अर तीमुथियुस मकिदुनिया से आया, ते पोलुस वचन सुनान कि धुन म यहूदी हुन ख गवाही देन लग्यो की यीसु ही मसी आय। ");
INSERT INTO hlb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","पर जब वी मन मोटाव अर निन्दा करन लग्या, ते ओ न अपना कपड़ा झाड़ ख उनसे कय्हो, “तुम्हारो खून तुम्हारी ही गर्दन पा रहे! मी बेगुनह हैं। अब से मी दुसरी जात हुन को पास जाऊँगो। ");
INSERT INTO hlb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","वहाँ से चल ख उ तितुस यूस्तुस नाम को परमेस्वर को एक पुजारी को घर म आयो; जेको घर प्रार्थना घर से लगो लगायो हतो। ");
INSERT INTO hlb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","तब प्रार्थना घर को मुखिया क्रिसपुस न अपनो पुरो घराना समेत प्रभु पर भरोसा करो; अर डेर सारा कुरिन्‍थुस मे रहन वाला सुन ख भरोसा लायो अर बपतिस्मा लियो।” ");
INSERT INTO hlb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","प्रभु न एक रात सपना को व्दारा पोलुस से कय्हो, मत डरा, पर बोलो जा अर चुप मत रह; ");
INSERT INTO hlb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","“काहेकि मी तोरो संग म हैं, अर कोई तोरो ऊपर चढ़ाई कर ख तोरी हानी नी करन को; काहेकि यू सहर म मोरा ढ़ेर सारा इंसान हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","एकोलाने उ उनमा परमेस्वर को वचन सिखाते हुए डेढ़ साल तक रयो। ");
INSERT INTO hlb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","जब गल्लियो अखया देस का मुखिया हतो, ते यहूदी हुन एक जुट हो ख पोलुस पर चढ़ आया, अर ओखा न्याय को सामे ला ख कहन लग्या, ");
INSERT INTO hlb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“यू अदमी हुन ख समझावा हैं कि परमेस्वर को भक्ती असो तरीका से करे, जो नेम को विरुद म हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","जब पोलुस कहन पर ही हतो, ते गल्लियो हुन न यहूदी हुन से कय्हो, “अरे यहूदी हुन अदि या कुछ अन्याय या बुराई की बात होती, ते उचीत होतो कि मी तुम्हारी ऐकता। ");
INSERT INTO hlb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","पर अदि या बहस कही वाली बात हुन, अर नाम हुन अर तुमरो खुद कि नेम की रीति-रीवाज को बारे म हैं, ते तुम ही समझनू: काहेकि मी असी बात हुन को न्याय करन वालो नी बननू चाहूँ।” ");
INSERT INTO hlb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","अर ओ ना मोखा न्याय आसन को सामे से निकलवा दियो। ");
INSERT INTO hlb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ऐकोबाद सब इंसान हुन न यहूदी प्रार्थना घर को मुखिया सोस्थिनेस ख फर दबोजा पकड़ ख न्याय को सामे मारो लगया। पर गल्लियो हुन न ओ पर कही भी नी दियो असी फिकर नी। ");
INSERT INTO hlb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","पोलुस बेजा दिन तक ओमा रयो। फिर भई हुन से बीदा हो ख किंख्रिया म ऐको लाने मुण्डी मुडायो, काहेकि ओ न मन्नत मानी रह, अऊर जहाज पा सीरिया ख चल दियो अर उनको संग प्रिसकिल्ला अर अक्विला हता। ");
INSERT INTO hlb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ओ न इफिसुस पहुँच ख उन ख उते छोडयो, अर उ जा ख प्रार्थना घर म जा ख यहूदी हुन से बहस करन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","जब उन न ओसे विनती करी, “हमरो संग म थोड़ा दिन रहो।” ते ओ न मना कर दियो; ");
INSERT INTO hlb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","पर असो बोल ख उनसे बीदा भयो, “अदि परमेस्वर चाहे ते मी तुमरो जोने फिर आहूँ। ओको बाद उ इफिसुस से जहाज खोल ख चल दियो; ");
INSERT INTO hlb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","अर कैसरिया म उतर ख (यरूसलेम ख) गयो अर कलेसिया ख मिलाप भेट कर ख अन्ताकिया म आया।” ");
INSERT INTO hlb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","फिर थोडा दिन रह ख उ वहाँ से निकलो, अर एक तरफ से गलातिया अर फूगिया प्रदेस हुन म सब चेला ख स्थिर करते फरो। ");
INSERT INTO hlb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","अपुल्लोस नाम को एक यहूदी, जेको जनम सिकन्दरिया म भयो रह, जो मनो जानो अदमी हतो जो सुध्दसास्र ख अच्छी तरीका से जानत रह, इफिसुस म आयो। ");
INSERT INTO hlb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ओ न प्रभु को रस्ता को ग्यान पायो रह, अर मन लगा ख यीसु को बारे म सही-सही सुनत रह अर सिखात रह, पर उ सिर्फ यूहन्ना को बपतिस्मा की बात जानत रह। ");
INSERT INTO hlb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","उ प्रार्थना घर म बेधड़क हो ख कहन लग्यो, पर प्रिसकिल्ला अर अक्विला ओकी बात सुन ख ओ ख अपनो यहाँ ले गया अर परमेस्वर को यहाँ जान कि रस्ता ओ ख अऊर भी सही-सही बतायो। ");
INSERT INTO hlb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","जब ओ न भरोसा करो की पार उतर ख अखया ख जाय ते भई हुन न ओ ख हिम्मत दे ख चेला हुन ख लिखो कि वी ओसे चोक्खो तरीका से मिले; अर ओ न वहाँ पहुँचा ख वी अदमी हुन की बड़ी मदत करी जिन्ना परमेस्वर कि दया को कारन भरोसा करियो रह ");
INSERT INTO hlb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","काहेकि उ सुध्दसास्र से सबूत दे दे ख की यीसु ही मसी आय, बडी हिम्मत से यहूदी हुन ख सब को सामे मुण्डो बंद करत रह। ");
INSERT INTO hlb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","वा बखत असो भयो कि जब अपुल्लोस कुरिन्थुस म हतो तो पोलुस भीतर ख परदेस हुन से घुम-फिर हो ख इफिसुस म आयो। उते ओ ख कुछ चेला हुन मिल्या। ");
INSERT INTO hlb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ते उनसे कय्हो, “क तुम न विस्वास करत बखत सुध्द आत्मा पायो?” उनना ओसे कय्हो, “हम न तो सुध्द आत्मा को बारे म भी नी सुनी।” ");
INSERT INTO hlb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ओ न ओसे कय्हो, “ते तुम न कसो बपतिस्मा लियो” उनना कय्हो, “यूहन्ना को बपतिस्मा।” ");
INSERT INTO hlb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","पोलुस न कय्हो, “यूहन्ना न यू कह ख मन फिराव को बपतिस्मा दियो कि जे मोरो बाद आन वालो हैं, उ पर अर्थात् यीसु प विस्वास करनु।” ");
INSERT INTO hlb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","यू सुन ख उनना प्रभु यीसु को नाम म बपतिस्मा लियो। ");
INSERT INTO hlb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","जब पोलुस न उन पर हात रखिया, ते सुध्द आत्मा उ पर उतरियो, अर वी अलग-अलग भासा बोली बोलत अर भविस्यवानी करन लगिया। ");
INSERT INTO hlb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","यू सब कम से कम बारा अदमी हते। ");
INSERT INTO hlb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","फिर पोलुस यहूदी प्रार्थना घर म चलो गयो अर तीन महा लक बे फिकर हो ख सुनाते रयो। उ यहूदी हुन को संग बात-चीत करते हुए उन ख परमेस्वर को राज को बारे म समझाते जात रहा। ");
INSERT INTO hlb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","पर उनमा से कुछ अदमी हुन ढ़ीट हता उनना विस्वास करनो से मना कर दियो अर पुरा इंसान हुन को सामे प्रभु को राज की रस्ता ख भलो बुरो कहन लग गयो एकोलाने उ अपना चेला हुन ख संग म ले ख उनका छोड़ ख चल दियो। अर तुरन्नुस की पाटसाला म रोज दिन बात-चीत करन लग गयो। ");
INSERT INTO hlb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","दो साल तक असो ही होते रयो, ऐको मतलब असो भयो कि आसिया ख रहन वाला का यहूदी का यूनानी सब न प्रभु को वचन सुन लियो। ");
INSERT INTO hlb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","परमेस्वर पोलुस को हात को दुवारा सामर्थ्य को काम करते जात रहा। ");
INSERT INTO hlb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","असो तक की ओखा छिया वाला रूमाल, अंगोछा हुन ख रोगी हुन को जोने ले ख जात रहा अर उनकी बिमारी दुर हो जात रहा अर दुस्टात्मा भग जात रहा। ");
INSERT INTO hlb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","पर कुछ यहूदी इंसान जो दुस्टात्मा निकालते अर इते उते फिरत रहा असा कहन लग्या कि जो इंसान हुन म भूत प्रेत समायो रहा उन पा प्रभु यीसु का नाम को उपयोग कर ख फून को काम करे अर मी तुम ख उई यीसु को नाम को जेको प्रचार पोलुस करा हैं मी तुम ख आदेस देऊ हैं। ");
INSERT INTO hlb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","अर स्क्किवा नाम को एक यहूदी महा याजक का सात पोरिया हता, जो असा ही करत रह। ");
INSERT INTO hlb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","पर दुस्टात्मा न उनका जवाब दियो, “यीसु ख मी जानु हैं, अर पोलुस ख भी मी पहिचानू हैं, पर तुम कोन आय?” ");
INSERT INTO hlb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","फिर उ अदमी जेमा दुस्टात्मा समायो रहा, उन पर लग्यो ओ ना उन पा काबु पा ख वी दोई ख हरा दियो असो तरीका से वी नंगा ही हो ख उ घर से निकल ख भग गया। ");
INSERT INTO hlb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","या बात इफिसुस ख रहन वाला सब यहूदी अर यूनानी भी जान गया, अर उन सब पा डर समा गयो; अर प्रभु यीसु को नाम की बड़ाई भई। ");
INSERT INTO hlb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ओमा से ढ़ेर सारा जीन्ना भरोसा कर लियो रहा, अपनो ही हात से करिया बुरा काम हुन ख सबको जोने मान ख वहाँ आया। ");
INSERT INTO hlb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","जादू करन वाला म से ढ़ेर सारा न अपनी-अपनी किताब हुन इकठ्टी कर ख सब को सामे जला दीया अर जब उनको दाम जोडो गयो ते पचास हजार चाँदी को सिक्का हुन को बराबर हतो। ");
INSERT INTO hlb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","उ तरीका से प्रभु को वचन बड़ी जोर सोर फैलते अर सब तक पहुँचा गया। ");
INSERT INTO hlb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","या घटना घटन को बाद पोलुस न अपनो मन म मकिदुनिया अर अखया से हो ख यरूसलेम जान को पक्को करियो। उन कय्हो, “वहाँ जान को बाद मोखा रोम भी देखनो चहिए।” ");
INSERT INTO hlb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","एकोलाने अपन सेवा करन वालो म से तीमुथियुस अर इरास्तुस नाम ख दो विस्वासी हुन ख मकिदुनिया भेज दियो अर खुद आसिया म कुछ रोज अऊर रूक्यो। ");
INSERT INTO hlb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","वा बखत उ रस्ता को बारे म बड़ो ऊधम मचियो। ");
INSERT INTO hlb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","वहा देमेत्रियुस नाम को एक चाँदी को काम करन वालो सोनार रहत रहा। अर ओ ना अरतिमिस को चाँदी को मन्दिर बनवात रहा जसो मिसरी हुन ख बेजा फायदा मिलत रहा। ");
INSERT INTO hlb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ओ ना उन ख अऊर यू काम ख करन वाला दूसरा मिसरी हुन ख इकठ्टो करियो अऊर बोल्यो, “देखो भैय्या हुन, तुम जाना हैं कि यू काम से हम ख एक अच्छी आमदानी हो जावा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","तुम देख सक हैं अर सुन सका कि यू पोलुस न, न सिर्फ इफिसुस को पूरो सिवाना म अदमी हुन ख बहकाए ख बदल दियो हैं उ बोला हैं इंसान को हात से बनाया वाला भगवान वी बीलकुम भी भगवान नी हैं। ");
INSERT INTO hlb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ऐसे न सिरप या बात को डर हैं कि हमारी रोजी-रोटी बंद नी होन की पर महान देबी अरतिमिस को मन्दिर को नाम निसान तक मिट जान को डर हैं अर जो देबी की भक्ती पुरी दुनिया। को दुवारा होते जावा हैं, ओको नाम को नाम निसान मिट जान को डर भी हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","वी असा सुन ख घुस्सा से भर गया अऊर चिल्ला-चिल्लाया ख कहन लग्या, “इफिसीयो कि अरतिमिस देवी बड़ी महान हैं!” ");
INSERT INTO hlb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","अर पुरो सहर म बड़ो ऊधम मच गयो, अऊर अदमी हुन न मकिदुनिया वासी गयुस अऊर अरिस्तर्खुस का जो पोलुस को संगी यातरी हता पकड़ लियो, अर एक संग म रंग साला म दऊड गया। ");
INSERT INTO hlb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","जब पोलुस न अदमी हुन को पास भीतर जानो चाहो ते चेला न ओ ख जान नी दियो। ");
INSERT INTO hlb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","कुछ प्रान्तीय अधिकारी हुन न जो ओखा दोस्त हता, उनका कैय दियो की उ वहाँ रंग साला म आन की कोसीस नी करन को। ");
INSERT INTO hlb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","वहाँ कोई कुछ चिल्लात रह अर कोई कुछ, काहे की सभा म बड़ी हड़बड़ी होत रह हती, बेजा सारा इंसान हुन तो यू समझत भी नी रह की हम काय को लाने यहाँ इकट्ठा भया हैं। ");
INSERT INTO hlb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","यहूदी हुन न सिकन्दर ख जेको नाम जवाबदार को रूप म समझायो रहा ओखा आगे सब को सामने कर दियो फिर उ अपना हात हुन ख हलाहला ख सिकंदर न इंसान हुन को सामे बचन को पक्छ सामने रखन कि सोचियो। ");
INSERT INTO hlb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","पर जब उन ना जान लियो की उ यहूदी आय, ते सब का सब एक आवाज से कोई दो घण्टा तक चिल्लाता रया, “इफिसीयो की अरतिमिस, बड़ी हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","फिर सहर को मंतरी न भीड़ ख सान्त कर ख बोल्यो, “अरे इफिसुस ख रहन वाला इंसान हुन का दुनिया म कोई असो इंसान हैं जो यू नी जानत आय कि इफिसुस सहर महान देबी अरतिमिस को मंदिर अर स्वर्ग से गीड़ी वाली सुध्द पत्थर को टहलुवा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","एकोलाने जब कि असी बात हुन को खण्डन ही नी हो सका, ते भलो हैं कि तुम चुप चाप रहो अऊर बिना सोचे समझे कुछ मत करनु। ");
INSERT INTO hlb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","काहेकि तुम असा इंसान हुन का लाया हैं कि जे न मन्दिर कि चोरी करन वाला हैं अर न हमारी देबी की निन्दा करन वाला। ");
INSERT INTO hlb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","अदि देमेत्रियुस अर ओखा संगी कारीगार हुन ख कोई से बहस होये ते कचेरी खुली हैं अर राज्यपाल भी हैं; वी एक दुसरो पर मुकदमा चलाय सकह हैं। ");
INSERT INTO hlb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","पर तुम ऐसे अऊर कुछ जादा जानन कि सोचा हैं ते ओको फैसला कानुन कि सभा म करो जाहे। ");
INSERT INTO hlb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","पर अब जो कुछ हैं ओको हिसाब से हमका या बात को डर हैं कि आज को उपद्रा हुन को अरोपी कई हमारी मुंड पा नी मढ़ दियो जाहे। यू दंगा को लाने हमरो जोने कोई सबूत नी हाय जसो हम ऐका उचित ठहरा सके।” ");
INSERT INTO hlb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","इत्तो कहन को बाद ओ ना सभा खतम कर दियो। ");
INSERT INTO hlb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","फिर यू उपद्रा को सान्त हो जान को बाद पोलुस न यीसु ख चेला हुन ख बुलायो अर उनको होसला बढ़ान को बाद उनसे बिदा लेका उ मकिदुनिया ख चल दियो। ");
INSERT INTO hlb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","वी पुरा परदेस म से होका अऊर चेला हुन को खुसी बढ़ा ख उ यूनान म आयो ");
INSERT INTO hlb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","उ वहाँ तीन महा रूक्यो रहो काहेकि यहूदी हुन न ओखा फसान को लाने एक प्लान बनायो रहा। एकोलाने जब उ नाव म से सीरिया जान वालो ही हतो कि ओ ना विचार करयो कि मी मकिदुनिया ख लउट जाऊ। ");
INSERT INTO hlb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","बिरीया को पिर्रूस को पोरिया प सोपतुस, थिस्सलुनीकियो क रहन वाला अरिस्तर्खुस अर सिकुन्दस, दिरबे को रहन वालो गयुस, अर तीमुथियुस, अर ऐसियाई सहर को तुखिकुस अर त्रुफिमुस आसिया ओखा संग म हता। ");
INSERT INTO hlb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","यी अदमी हुन पहले ही चल दिया रहा अर त्रोआस म हमरी रस्ता देखत रहा। ");
INSERT INTO hlb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","अर हम अखमीरी रोटी को दिन हुन को बाद फिलिप्पी से जहाज पा चढ़कर पाँच दिन म त्रोआस म ओको जोने पहुँचो, अर सात रोज तक वहीं रया। ");
INSERT INTO hlb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","हफ्ता को दिन जब हम रोटी खान को लाने इकट्ठा भया ते पोलुस उनसे बात चीत करन लग गयो। ओखा दुसरो रोज ही जानो रा एकोलाने उ आधी रात लक बात चित करते ही रयो। ");
INSERT INTO hlb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","अटारी को उपर वालो खन म जिते हम इकट्ठा भया रहा, वहाँ ढ़ेर सारा दीया हता। ");
INSERT INTO hlb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","वही एक यूतुखुस नाम को एक जुवान खिड़की को उप्पर बठियो रहा उ गहरी नींद सोत रहा। काहेकि पोलुस बेजा देर से बोलते ही जात रहा ते ओखा गहरी नींद आ गई रहा ऐसे उ तीन खंड को माला से नीचे गीर पडियो अर जब ओखा उठायो ते उ मर गयो रहा। ");
INSERT INTO hlb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","पर पोलुस नीचु उतर ख ओसे लपट गयो अर गला लक ख उनसे बोल्यो, “घबरावा मत काहेकि ऐकी जान अबा ऐमन ही हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","फिर उ उपर को खन म चल दियो अर ओ ना रोटी ख टोढ़ ख टुकड़ा करयो अर ओखा खायो। उ उनको संग दिन कि किरन फुटते लक बात चित करते रयो। फिर ओ ना उनसे बिदा लियो। ");
INSERT INTO hlb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","उ जिन्दो इंसान ख उनना घर ख लेका आया। येसे उनका बेजा सान्ति मिल्यो। ");
INSERT INTO hlb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","हम नाव पा पहले ही पहुँच गया अर अस्सुस ख निकल पड़िया। उते पोलुस ख हमका नाव पर लेनो होतो। ओ ना असो ही पिलान बनायो रहा उ खुद पैदल आन की सोचत रहा। ");
INSERT INTO hlb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","जब उ अस्सुस म हमका मिल्यो ते हमना ओखा नाव म बिठाल लियो अर हम मितुलेने ख चल पडिया। ");
INSERT INTO hlb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","वहाँ से जहाज खोल ख हम दुसरो दिन खियुस को सामने पहुँचा, अर अगलो दिन सामुस म जा लगया; फिर दुसरो दिन मिलेतुस म आया। ");
INSERT INTO hlb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","काहेकि पोलुस जहाँ तक हो सका पिन्तकुस्त को रोज तक यरूसलेम पहिचान कि जलदी करत रहा, एकोलाने ओ ना सोचियो कि उ इफिसुस म बिना रूक्यो आगे चल देहे जसो ओखा आसिया म बखत नी गुजारनो पड़े। ");
INSERT INTO hlb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ओ न मिलेतुस से इफिसुस ख सियाना हुन ख अर कलेसिया ख खबर भेज ख अपनो जोने बुलायो। ");
INSERT INTO hlb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","जब वी ओको जोने आया, ते उनसे कय्हो: “तुम जाना हैं कि पहिलो ही दिन जब मी आसिया म पहुँचो, मी हमेसा से तुमरो संग कसो तरीका से रयो।” ");
INSERT INTO hlb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","यानी बड़ी नम्रता से अर आँसु बहा-बहा ख, अर वी परीक्छा हुन म जे यहूदी हुन को साजिस को लाने मो पर आ पड़ी, मी प्रभु की सेवा करते ही रयो; ");
INSERT INTO hlb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","अर जे जे बात हुन मोरो फायदा की हती, उनका बतान अर इंसान हुन को जोने अर घर-घर सिखान से कभी नी हिचकीयो, ");
INSERT INTO hlb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","यहूदी हुन अर यूनानी हुन ख मी समान भाव से पाप हुन की छमा को लाने परमेस्वर कि तरफ फिरन की बोलते रयो हैं अर हमारो प्रभु यीसु को विस्वास को उपर उनका चिताते रयो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","मी सुध्द आत्मा को बस म होका यरूसलेम जा रयो हैं। मी नी जानत आय कि वहा मोरो संग का कुछ नी घटन को ");
INSERT INTO hlb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","मी तो बस इत्तो जानु हैं कि हर सहर म सुध्द आत्मा असो बोलते हुए मो ख जतायो हैं कि बन्धन अर कलेस तोरो इंतजार कर रया हैं ");
INSERT INTO hlb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","पर मोरो लाने मोरी जान को कोई मोल नी हाय। मी तो बस वा दऊड धूप अर सेवा ख पुरो करनो चाहूँ हैं जेखा मी न प्रभु यीसु से पायो हैं वा हैं परमेस्वर कि किरपा को सुसमाचार की गवाही देनो। ");
INSERT INTO hlb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","अब देखनु, मी जानु हैं कि तुम सब जिनमा मी परमेस्वर को राज को प्रचार करते फिरो, मोरो मुँह फिर नी देखन का। ");
INSERT INTO hlb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","एकोलाने मी आज मी तुमरो जोने गवाई देहु हैं कि तुम म से कोई को खून से बेगुनह हैं। ");
INSERT INTO hlb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","काहेकि मी परमेस्वर को सारो अभिप्राय ख तुम ख पूरी रीति से बतान से नी झिझका। ");
INSERT INTO hlb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","एकोलाने अपनी अर पुरो झुंड की निगरानी करो जेमा सुध्द आत्मा न तुम ख अध्यक्छ ठहरायो हैं, कि तुम परमेस्वर की कलीसिया का रखवाली करे, जे ख ओ न अपनो खून से मोल लियो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","मी जानु हैं कि मोरी बिदा होवन को बाद फाड़न खान वाला भेड़िया तुमरो बीच म आएँगो अर वी असा भलो-भाला विस्वासी झुंड ख नी छोडेगो। ");
INSERT INTO hlb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","इत्तो तक की असो बखत आएँगो की तुमरो ही बिच म से भी असा इंसान उठेगो, जो विस्वास करन वाला ख अपनो पिच्छु चलन ख लाने बात हुन ख तोड़ मरोड़त ख कहेगो। ");
INSERT INTO hlb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","एकोलाने जगते रहनु, अर याद करनु कि मी न तीन साल तक रात दिन आँसु बहा-बहा ख हर एक ख जतानु नी छोड़ो। ");
INSERT INTO hlb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","अर अब मी तुम ख परमेस्वर को, अर ओकी किरपा को वचन ख सोप देऊ हैं; जो तुम ख बढ़ा सका हैं अर सब सुध्द करया वाला इंसान हुन म तुमरो उत्तराधिकार दिला सका हैं। ");
INSERT INTO hlb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","मी न कोई को चाँदी, सोना या कपड़ा को लालच नी करो। ");
INSERT INTO hlb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","तुम तुम ही जाना हैं कि ईच हात हुन न मोरी अर मोरा संग म काम करन वाला की जरूरत पूरी करी। ");
INSERT INTO hlb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","“मी न तुम ख सब कुछ कर ख दिखायो कि असो तरीका से मेहनत करते हुये निर्बल हुन ख संभालनो अर प्रभु यीसु ख वचन याद रखनू जरूरी हैं, जे ओ न तुम ही बोलो हैं: लेनो से देनो भलो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","यू बोल ख वोना टोंगरीया टेकीयो अर उन सब को संग बिनती करी। ");
INSERT INTO hlb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","तब वी सब रोया अर पोलुस को गला ख चुम्मा लेन लग्या ");
INSERT INTO hlb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","वी खास कर ख या बात से दुखी हता जे ओ न कही रह कि तुम मोरो चेहरा फिर कभी नी देखन का। एकोबाद उन न ओ ख जहाज तक पहुँचायो। ");
INSERT INTO hlb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","फिर उनसे बिदा हो ख हम न सागर म अपनी नाव खोली अर सिधो रस्ता कोस जा ख पहुँचिया अर दुसरो रोज रूदुस। फिर वहाँ से पतरा ख चल दिया। ");
INSERT INTO hlb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","वहाँ हमना एक जहाज फीनीके का जाते हुयो मिलो, अर हम न ओपर चढ़ ख खोल दियो। ");
INSERT INTO hlb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","जब साइपरस दिखई देन लग गयो ते हम ओखा उल्टो हात की तरफ छोड़ ख सीरिया की तरफ घुम गया काहेकि जहाज ख सूर म माल उतारनो हतो एकोलाने हम भी वही उतर गया। ");
INSERT INTO hlb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","वहाँ हम ख विस्वासी मिल्या जिनको यहाँ हम सात रोज लक रूक्या। उनना आत्मा कि सक्ती से भर ख पोलुस ख यरूसलेम जानो से मना करयो। ");
INSERT INTO hlb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","फिर वहाँ रूकन को अपनो बखत पुरो कर ख हमना बिदा लियो अर अपनो सफर पा निकल पड़या। अपनी ओरत अर पोरिया-पारी समेत वी पुरा सहर को बाहर लक हमरो संग आया। फिर वहाँ सागर को किनार म हमना टोगरिया को बल झूक ख बिनती करी। ");
INSERT INTO hlb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","तब एक दुसरो से बिदा हो ख हम तो जहाज पर चढ़ीया अर वी अपना-अपना घर लउट गया। ");
INSERT INTO hlb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","सूर से पानी को रस्ता पुरो कर ख पतुलिमयिस म पहुँचिया, अऊर भई हुन ख नमस्कार कर ख उनको संग एक दिन रहया। ");
INSERT INTO hlb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","दुसरो दिन हम वहाँ से चल ख कैसरिया म आया, अर फिलिप्पुस सुसमाचार प्रचारक को घर म जो साती म से एक हतो; जा ख ओको यहाँ रया। ");
INSERT INTO hlb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ओकी चार कुंवारी पोरी हुन हती, जे भविस्यवानी करत रह। ");
INSERT INTO hlb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","जब हम वहाँ बेजा दिन तक रैय चुक्या, ते अगबुस नाम को एक भविस्यवक्ता यहूदिया से आयो। ");
INSERT INTO hlb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ओ ना हमरो जोने आ ख पोलुस को अंगोछा लियो, अर अपना हात पाय बाँध ख कय्हो, “सुध्द आत्मा असो बोला हैं कि जो अदमी को यू अंगोछा आय, ओ ख यरूसलेम म यहूदी असोच ही तरीका से बाँधूँगो, अर दुसरी जात हुन को हात म सोपेगो।” ");
INSERT INTO hlb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","जब हम न असी बात सुनी, ते हम अर वहाँ ख अदमी हुन न ओसे विनती करी कि यरूसलेम ख मत जानु। ");
INSERT INTO hlb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","पर पोलुस न जवाब दियो, “तुम का करा हैं कि रो-रो ख मोरो मन तोड़ा हैं? मी तो प्रभु यीसु को नाम को लाने यरूसलेम म नी केवल बाँधी जान ही को लाने पर मरन को लाने भी तैयार हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","जब ओ न नी मानो ते हम यू बोल ख चुप हो गया, “प्रभु की मर्जी पुरी होय।” ");
INSERT INTO hlb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ई दिन को बाद हमना तैयारी करी अर यरूसलेम ख चल दिया। ");
INSERT INTO hlb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","कैसरिया से भी कुछ चेला हमरो संग म हो लियो। अर हम ख मनासोन नामक साइपरस को एक पुरानो चेला को यहाँ ले आया, कि हम ओको यहाँ रूके। ");
INSERT INTO hlb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","जब हम यरूसलेम म पहुँचिया, ते भई हुन बड़ी खुसी को मारे हम से मिलीयो। ");
INSERT INTO hlb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","दुसरो दिन पोलुस हम ख ले ख याकूब को जोने गयो, वहाँ पर सब सियाना जुड़िया हता। ");
INSERT INTO hlb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","तब ओ न उन ख नमस्कार कर ख, जो जो काम परमेस्वर न ओकी सेवा को दुवारा दुसरी जात हुन म करी रह, एक एक कर ख सब बताया। ");
INSERT INTO hlb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","उन न असो सुन ख परमेस्वर कि स्तुति करी फिर ओसे कय्हो, “भई, तू देखा हैं कि यहूदी हुन म से करीब हजार न भरोसा करो हैं; अर सब नेम को लाने धुन लगाया हैं। ");
INSERT INTO hlb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","उनका तोरो बारे म सिखायो गयो हैं कि तू दुसरी जात हुन म रहन वाला यहूदी हुन का मूसा से फिर जान की सिखावा हैं, अर बोला हैं, कि न अपना पोरिया पारी को चढ़ावा अर न रीति-रीवाज हुन पर चलो। ");
INSERT INTO hlb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ते फिर का करो जाय? अदमी हुन जरूरी सुने कि तू आयो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","एकोलाने जो हम तो से कह हैं, उ कर। हमरो इते चार इंसान हैं जिन्ना मन्नत चढ़ाई हैं। ");
INSERT INTO hlb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","उन ख ले ख उनको संग अपनो तुम ख सुध्द करो; अर उनको लाने खर्चा दे कि वी मण्ड़ी मुडायो। तब सब जान लेहे कि जो बात हुन उन ख तोरो बारे म कही गई, ओमा कुछ हकीगत नी हाय पर तू स्वंय भी नेम ख मान ख ओको जसो चला हैं। ");
INSERT INTO hlb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","पर वी दुसरी जात हुन को बारे म जिन्ना भरोसा करो हैं, हम न यू सोच समझ ख लिख भेजो हैं कि वी मुरती हुन को सामे चढ़ाई वाली मटन म से, अर खून से अर गलो घोटियो वालो कि मटन म से, अर गलत काम से बचियो रहनु।” ");
INSERT INTO hlb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","तब पोलुस वी अदमी हुन ख लेखा, अर दुसरो रोज उनको संग सुध्द हो ख मन्दिर म गयो, अर वहाँ बता दियो कि सुध्द हो न को दिन, यानी उनमा से हर एक को लाने चढ़ावा चढ़ाय जान तक को दिन कब पुरा होए। ");
INSERT INTO hlb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","जब वी सात दिन पुरा होन पा हता, ते आसिया का यहूदी हुन न पोलुस को मन्दिर म देख ख सब अदमी हुन ख उकसायो, अर असा चिल्ला ख ओ ख पकड़ लियो, ");
INSERT INTO hlb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“अरे इस्राएली हुन, सहायता करो; यू उई अदमी आय जो अदमी हुन को, अर नेम का, अर या जगा को विरोध म हर जगह सब अदमी हुन ख सिखावा हैं, यहाँ तक की यूनानी हुन ख भी मन्दिर म ला ख ओ न यू सुध्द जगह ख असुध्द करो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","उन न येसे पहिले इफिसुस वासी त्रुफिमुस को ओको संग नगर म देखो हतो, अर समझीया हता कि पोलुस ओ ख मन्दिर म ले आयो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","तब पुरो सहर म कोला हल मच गयो, अर अदमी दऊड ख एक जुट भया अर पोलुस ख पकड़ ख मन्दिर को बहार घसीट लाया, अर तुरत दरवाजा बन्द करा गया। ");
INSERT INTO hlb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","जब वी ओ ख मार डालनो चाहत रह, ते पलटन को मुखिया ख खबर पहुँची कि पुरो यरूसलेम म कोला हल मच रयो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","तब वी तुरंत सैनिक हुन अर सतपति हुन को लेय ख ओके नजीक नीचे दऊड आयो; अर उनना पलटन को सरदार ख अर सैनिक हुन ख देख ख पोलुस ख मरनो पिटनो छोड़ दियो। ");
INSERT INTO hlb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","तब पलटन को सरदार न नजीक आय ख ओ ख पकड़ लियो; अर दो जंजीर से बाँधन की आग्या देय ख पुछन लगिया, “यू कोन आय अर इन न का कियो आय?” ");
INSERT INTO hlb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","पर भीड़ म से कोई न कोई चिल्लात रह। जब कल्ला को मारे वी सही सच्चाई नी जान सको ते ओ ख मजबूत गढ़ म ले जान को आग्या दियो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","जन वी पायरी पर पहुँचिया, ते असो भयो कि भीड़ को दबाव को मारे सैनिक हुन ख ओ ख उठा ख ले जानो पड़ियो। ");
INSERT INTO hlb_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","काहेकि अदमी हुन को भीड़ यू कल्ला करती हुई ओको पीछे पडी हती रह, “ओ ख मार दाल।” ");
INSERT INTO hlb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","जब वी पोलुस ख गढ़ म ले जानो हते, ते ओ ना पलटन को सरदार से कय्हो, “क मोखा आग्या हैं कि मी तोखा कुछ कहूँ?” ओ न कय्हो, “क तू यूनानी जानह हैं? ");
INSERT INTO hlb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","का तू वी मिसतिरी नी आय, जे इ दिन हुन से पहलो विद्रोही बना ख, चार हजार चक्कु बंद लोग हुन ख जंगल म ले गयो?” ");
INSERT INTO hlb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","पोलुस न कय्हो, “मी ते तरसुस को यहूदी इंसान आय! किलिकिया के प्रसिध्द नगर को निवासी आय मी तोसे बिनती करू हूँ कि मो ख लोग हुन से बात करन दे।” ");
INSERT INTO hlb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","जब ओ न आग्या दियो, ते पोलुस न सीढ़ी पर खड़ो होय ख लोग हुन को हात से संकेत कियो। जब वी चुप हो गयो ते वी इब्रानी भासा म बोलन लगियो। ");
INSERT INTO hlb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","पोलुस न बोल्यो, “अरे मोरा यहूदी भैय्या हुन अऊर मोरो बाप को समान दादा हुन! मोरी पक्छ म अब मोखा जे कुछ कहनो हैं, ओखा ध्यान धर ख सुनो।” ");
INSERT INTO hlb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","वी यू सुन ख कि उ अब हमसे इब्रानी भासा म बोला हैं, अर यी चुपचाप हो गया तब ओ न कय्हो; ");
INSERT INTO hlb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","मी एक यहूदी इंसान आय, जो किलिकिया को तरसुस म मोरो जनम भयो; अऊर मी यूईच सहर म मोरो पाल-पोस ख बड़ो भयो हैं। गमलीएल को पाय को जोने बैठ ख हमारी परम्परा को नेम को हिसाब से बड़ी मेहनात को संग मोखा ग्यान बुध्दी मिली, परमेस्वर को लाने मी बड़ो धुन लगायो थो। ठीक वसो ही जसा आज तुम सब हैं। ");
INSERT INTO hlb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","मी न अदमी अऊर ओरत दोई ख बान्ध बाँध ख अऊर जेल म डाल-डाल ख यीसु मसी ख मानन वाला ख असो तक सतायो कि उनका मरना भी डालो। ");
INSERT INTO hlb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","या बात को लाने मुखिया याजक अऊर सबरा सियाना गवाह हैं, कि उनसे भी भई हुन को नाम पर चिठ्टी हुन लेख दमिस्क का चलो जात रह हतो, जो वहाँ रहे उनका भी सजा दिलान को लाने बाँध ख यरूसलेम लाऊ। ");
INSERT INTO hlb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","जब मी चलते चलते दमिस्क को जोने पहुँचियो; ते असो गयो कि दोपहर दिन को एक बजे को करिब एकाएक एक बड़ी बिजली आकास से मोरो चारी तरफ चमकी। ");
INSERT INTO hlb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","अर भी जमीन पा गिर पड़ियो अर असो आवाज सुनो, साऊल, ओ साऊल तू मोखा काहे सतावा हैं? ");
INSERT INTO hlb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","मी न उत्तर दियो हर प्रभु, तू कोन आय? ओ न मोसे कय्हो, मी यीसु नासरी आय, जो ख तू सतावा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","मोरा संग वाला न बिजली तो देखी, पर जो मोसे बोलत रह ओकी आवाज नी सुनियो। ");
INSERT INTO hlb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","तब मी न कय्हो, प्रभु मो ख का करनो चहिए? प्रभू न मोसे कय्हो, उठ ख दमिस्क म जा, अर जे कुछ तोखा करन को लाने ठहरायो गयो उ तोसे सब बता दियो जाहेगो। ");
INSERT INTO hlb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","जब वा बिजली को उजाला को मारे मो ख कुछ दिखाई नी दियो, ते मी अपना संगी हुन को हात पकड़ ख दमिस्क म आयो। ");
INSERT INTO hlb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","तब हनन्याह नाम को नेम को अनुसार एक दास अदमी, जो वहाँ रहत रह सब यहूदी हुन म सुनाम हतो मोरो जोने आयो, ");
INSERT INTO hlb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","अर खड़ो होख मोसे कय्हो, हे साऊल भई, फिर देखन लग उसी घड़ी मोरी आँखी खुल गई अर मी न ओ ख देखो। ");
INSERT INTO hlb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","तब ओ न कय्हो, हमरो बाप दादा हुन को परमेस्वर न तोखा एकोलाने ठहरायो हैं कि तू ओकी इच्छा को जानो अर उ धर्मी को देखे अर ओको मुण्डो से बात हुन सुने। ");
INSERT INTO hlb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","काहेकि तू ओकी तरफ से सब अदमी हुन को सामे वी बात को गवाह होयगो जे तू न देखो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","अब काहे टेमं करा हैं? उठ बपतिस्मा ले अर ओको नाम ले ख अपनो पाप धो ड़ाल। ");
INSERT INTO hlb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“जब मी फिर यरूसलेम म आँख मन्दिर म बिनती करत रह हतो, ते बेसुध हो गयो, ");
INSERT INTO hlb_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","अर ओखा देखो कि उ ओसे बोला हैं, ‘जल्दी कर ख यरूसलेम से पटाक निकल ला, काहेकि वी मोरो बारे म तोरी गवाई नी मानन ख।’ ");
INSERT INTO hlb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","मी न कय्हो, प्रभु, वी तो खुद जाना हैं कि मी तो पर भरोसा करन वाला ख जेल म ड़ालू अर जगह-जगह प्रार्थना घर म पिटवात रह। ");
INSERT INTO hlb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","जब तोरो गवाह स्तिफनुस को खून बहायो जान रह तब मी भी वहाँ हतो; अर या बात म सहमत हतो, अर ओखा मारन वाला को कपड़ा की देख रेख करत रह। ");
INSERT INTO hlb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","अर ओ ना मोसे कय्हो, चलो जा; काहेकि मी तोखा दुसरी जात को पास दूर-दूर भेजेगो।” ");
INSERT INTO hlb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","वी या बात तक ओकी सुनते रया, तब बड़ी जोर से चिल्लायो, “असो अदमी ख मार ड़ालो; ओको जिन्दो रहनू ठीक नी हाय।” ");
INSERT INTO hlb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","जब वी चिल्लाते रय्हो अर कपड़ा फेंकते अर बादल म धुदर उड़ात रह; ");
INSERT INTO hlb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ते पलटन को मुखिया सरदार न कय्हो, “ऐका गढ़ म ले जाव, अर कोड़ा लगा का पुछो, कि मी जानू कि इंसान काम को वजे से ओको विरोध म असा चिल्ला रया हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","तब उनन ओ ख चमडा से बाँधी ते पोलुस न उ सतपति से जे नजीक म खड़ो हतो, कय्हो, “क यू ठीक हाय, कि तुम एक रोमी इंसान ख, अर उ भी बिना दोसी ठहरायो हुयो: कोड़ा मारो?” ");
INSERT INTO hlb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","सतपति न यू ऐका ख पलटन को मुखिया को जोने जा ख कय्‍हो, “तु यु का करा हैं? यु तो रोमी इंसान आय।” ");
INSERT INTO hlb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","तब पलटन को मुखिया न ओको जोने आ कय्हो, “मोखा बता, का तू रोमी आय? ओ न कय्हो हाव।” ");
INSERT INTO hlb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","यू सुन ख पलटन को मुखिया न कय्हो, “मी न रोमी होन को पद ढ़ेर सारा रुपया देख पायो हैं।” पोलुस न कय्हो, “मी ते जनम से रोमी आय।” ");
INSERT INTO hlb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","तब जे अदमी ओ ख जाँचन पर हता, वी तुरंत ओको जोने से हट गयो अर पलटन को मुखिया भी यू जान ख कि यू ते रोमी आय अर मी न ओ ख बाँधी हैं, डर गयो। ");
INSERT INTO hlb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","दूसरो दिन ओ न ठीक-ठीक जाँचन की इच्छा से कि यहूदी ओ पर काहे आरोप लगाव हैं, ओकी ढ़ोरी खोली दियो जाय: अर प्रधान याजक हुन अर पुरी बड़ी सभा का एक जुट होन को दियो; अर पोलुस का नीचे ले जा ख उनको जोने खड़ो कर दियो। ");
INSERT INTO hlb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पोलुस न बड़ी सभा पा टकटकी लगा ख कय्हो, “भई मी न आज तक परमेस्वर को लाने बिलकुल भली इच्छा से चाल चलन से जीवन बनायो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ये पर हनन्याह माह याजक न उनका जो ओको पास जोने खड़ा हता; मुण्डो पर चाटा मारन को हुकुम दियो। ");
INSERT INTO hlb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","तब पोलुस न ओसे कय्हो, अरे चूना फेरी वाली समादी, परमेस्वर तो ख भी मारे। तू नेम को हिसाब से मोरो न्याय करन ख बठो हैं, अर फिर का नेम को विरूद मो ख मारन की कहा हैं? ");
INSERT INTO hlb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","जो सामे खड़ा हता उन न कय्हो, का तू परमेस्वर को बडो माह याजक ख बुरो भलो कहाँ हैं? ");
INSERT INTO hlb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पोलुस न कय्हो, “भई हुन मी नी जानत रह हतो कि यू बडो याजक आय; काहे कि लिखो हैं? अपना अदमी हुन को मुखिया (प्रधान) ख, बुरो मत बोलजे।” ");
INSERT INTO hlb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","तब पोलुस न यू जान ख की एक दल सदूकीहुन अर दूसरो फरीसी हुन को हैं, सभा म पुकार ख कय्हो “भई हुन, मी फरीसी अर फरीसी हुन को खानदान को आय मरिया वाला की आसा अर फिर से जी उठन को बारे म मोरो मुकदमा हो रयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","जब ओ न या बात कही ते फरीसी हुन अर सदूकी हुन की हुन म झगड़ा होन लगो अर सभा म फूट पड़ गई। ");
INSERT INTO hlb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","काहे कि सदूकी तो असा बोला हैं कि कि न फिर से जी उठनो हैं, न स्वर्ग दूत अर न आत्मा हैं, म पर फरीसी इन सब ख माना हैं ");
INSERT INTO hlb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","तब बड़ो हल्ला मचो अर कुछ सासतिरी जो फरीसी हुन को दल का हता उठ खड़ा भया अर असा कह ख झगड़न लग्या “हम यू अदमी म कुछ बुराई नी देखो अऊर अदि कोई आत्मा या स्वर्गदूत ओसे बोलो हैं ते फिर का?” ");
INSERT INTO hlb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","जब बेजा झगड़ा भयो ते पलटन को मुखिया (सरदार) न यू डर से कि वी पोलुस को टुकड़ा टुकड़ा नी कर डाले पलटन का आदेस दियो कि उतर ख ओ ख उनको बीच म से जबरदस्ती निकाले, अर गढ़ म ले जाव। ");
INSERT INTO hlb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","वई रात प्रभु न ओको जोने खड़ो होख कय्हो, “अरे पोलुस धीरज धर, काहेकि जसी तू न यरूसलेम म मोरी गवाही दियो वसो ही मोखा रोम म भी गवाही देनी पड़ो।” ");
INSERT INTO hlb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","जब दिन हुओ ते यहूदी हुन न सड्यंत्र रचो अर कसम खाई कि जब तक हम पोलुस ख मार नी डाले, तब तक खायो पियो वाले हम पा धितकार। ");
INSERT INTO hlb_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","जिन न एक दुसरो से असी कसम खाई रह वी चालीस झन से ज्यादा हता। ");
INSERT INTO hlb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","उनन मुखिया (प्रधान) याजक हुन अर सियाना हुन को नजीक जा ख कय्हो, “हम न यू ठान लियो हैं कि जब तक हम पोलुस ख मार नी ड़ाला, तब तक अदि कुछ चखे भी ते हमरो ऊपर धितकार हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","एकोलाने अब यहूदी सभा समेत पलटन को मुखिया (सेनानायक) ख, समझाव कि ओ ख तुमरो जोने लेख आव, समझानो कि तुम ओको बारे म अऊर भी चोक्खो से जाँच करनो चाहवा हैं। अर हम ओको पहुँचनो से पहिले ही ओ ख मार डालन को लाने तैयार रहेगो। ");
INSERT INTO hlb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","पोलुस को बहिन को पोरिया भांजा न सुनो कि वी ओखा मरनो पर हैं, ते गढ़ म जा ख पोलुस ख खबर दियो। ");
INSERT INTO hlb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","पोलुस न सतपति म से एक ख अपनो जोने बुला ख कय्हो, “यू जवान ख सेनापति को जोने ले ख जाव यू ओसे कुछ बोलनो चाहवा हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","एको लाने ओ न ओ ख पलटन को मुखिया को जोने ले जा ख कय्हो, बन्दी पोलुस न मोखा बुला ख विनती करी कि यू जवान पलटन को मुखिया से कुछ बोलनो चाहवा हैं; ऐका ओको जोने ले जाव। ");
INSERT INTO hlb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","पलटन को सरदार न ओको हात पकड़ ख अर ऊते ले जाय ख पुछियो, “तू मोसे क हकन चावा हैं?” ");
INSERT INTO hlb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ओ न कय्हो, “यहूदी हुन न सड्यंत्र रचो हैं कि तोसे विनती करे कि कल पोलुस ख बड़ो सभा म लाय, अर वी अच्छी तरह जाँच करन चावा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","पर उनकी नी माननू, काहेकि ओमा से चालीस का उपर अदमी हुन ओकी घात म हैं, जिनना यू ठान लियो हैं कि जब तक वी पोलुस ख मार नी ड़ाले, तब तक नी ते खावन को अर नी पाएगो को। अर वी तैयार हैं अर तोरो वादा की बट जो रया हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","तब पलटन को सरदार न जवाब ख यू आग्या देय ख बिदा कियो, “कोई ख नी कहनो कि तू न मो ख या बात कही आय।” ");
INSERT INTO hlb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","तब ओ न दो सतपति हुन ख बुलाय ख कय्हो, “दुई सव सैनिक, सत्तर सवार, अर दुई सव भालैत, पहर रात बीती कैसरिया ख जानू ख लियो तैयार कर रखियो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","अर पोलुस ख लाने घोड़ा हुन सवारी तैयार रखो हैं, कि ओ ख फेलिक्स हाकिम को नजीक चोक्खो से पहुँचा देहे।” ");
INSERT INTO hlb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ओ न इ प्रकार को चिठ्टी म भी लिखी हती: ");
INSERT INTO hlb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","महामहिम फेलिक्स हाकिम ख क्लोदियुस लूसियास को नमस्ते। ");
INSERT INTO hlb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","इ अदमी ख यहूदी हुन न पकड़ ख मार ड़ालन चावा हैं, पर जब मी न जानो कि रोमी हैं, ते पलटन लेय ख छुड़ा लायो। ");
INSERT INTO hlb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","मी जानन चाहूँ कि वी ओ पर का कारन आरोप लगावा हैं, एकोलाने ओ ख ओकी बड़ोसभा म ले गयो। ");
INSERT INTO hlb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","तब मी न जान लियो कि वी अपन मूसा ख नेम को विवाद को बारे म ओ पर आरोप लगाव हैं, पर मर डालन या बाँधन को योग्य ओमा कोई आरोप नी आय। ");
INSERT INTO hlb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","जब मोखा बतायो गयो कि वी इ अदमी की घात म लगे आय ते मी न तुरंत मी ओको तोरो नजीक म भेज दियो; अर मुद्दई हुन ख भी आग्या दी कि तोरो सामे ओ पर नजीक करे। ");
INSERT INTO hlb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","अत: जसी सैनिक हुन ख आग्या दी गई हती वसो ही वी पोलुस ख लेय ख रात तम रात अन्तिपतिरस म आया। ");
INSERT INTO hlb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","दुसरा दिन वी सवार हुन ख ओके संग जानू ख लियो छोड़ ख वापस गढ़ ख लउटे। ");
INSERT INTO hlb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","उनना कैसरिया पहुँच ख हाकिम ख चिठ्टी दी; अर पोलुस ख भी ओको सामे खड़ो कियो। ");
INSERT INTO hlb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ओ न चिठ्टी पढ़ ख पुछियो, यू कऊन सो देस को निवासी आय? अर जब जान लियो कि किलिकिया को आय ");
INSERT INTO hlb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“अर जब जान लियो कि किलिकिया को आय ते ओसे कय्हो, जब तोरो मुद्दई भी आएँगो, ते जब नी तोरो मुकदमा करुँ।” अर ओ न ओ ख हेरोदेस को किला म पहरा म रखन को आग्या दी। ");
INSERT INTO hlb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पाँच दिन को बाद म हनन्याह बड़ो याजक अर बेजा सारो सियाना हुन को अर तिरतुल्लुस नाम को कोई वकील ख संग म ले ख आयो। उनना हाकिम को सामे पोलुस ख पिटो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","जब वी बुलायो गयो ते तिरतुल्लुस ओ पर अरोप लगा ख कहन लगियो: “अरे महामहिम फेलिक्स, तोरो दरवाजा हम म बडी सान्ति होवा हैं; अर तोरो काम करनो से इ या जात को लाने कई प्रकार को बुराई हुन सुधरी जात हैं। ");
INSERT INTO hlb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","इको हम हर जगह अर हर प्रकार धन्यवाद ख संग मानत हैं। ");
INSERT INTO hlb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","पर एकोलाने कि तोखा अर दुख नी देनो चाहत, मी तोसे विनती करन हूँ कि किरपा कर ख हमारी दो एक बात सुन लेवा। ");
INSERT INTO hlb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","काहेकि हम न इ अदमी ख बुरो काम अर दुनिया को सारो यहूदी हुन म झगड़ा लगड़ा करन वालो, अर नासरी को कुपन्थ को मुखिया पायो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ओ न मन्दिर ख असुध्द करनो चाहयो, पर हमना ओ ख पकड़ लियो। हम न ओ ख अपन मूसा को नेम को अनुसार दण्ड दियो होतो; ");
INSERT INTO hlb_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","पर पलटन को सरदार लूसियास न ओ ख जबरदस्ती छीन लियो, ");
INSERT INTO hlb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","अर मुद्दई हुन ख तोरो सामे आन की आग्या दी। इ सब बात हुन का जेके बारे म हम ओ पर आरोप लगावा हैं; तू तुम ही ओको परख कर ख जान लेगो।” ");
INSERT INTO hlb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","यहूदी हुन न भी ओखा संग देय ख कय्हो, बात इही प्रकार की आय। ");
INSERT INTO hlb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","जब हाकिम न पोलुस का बोलन को संकेत कियो, ते ओ न उत्‍तर दियो: मी यू जान ख कि ढ़ेर सारो साल से इ जात को न्याय कर रय्हो हैं खुसी से अपन प्रत्युत्तर देहु हूँ। ");
INSERT INTO hlb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","तू कुद जान सका हैं कि जब से मी यरूसलेम म आराधना करन ख आयो, मोखा बारा रोज से मोखा ऊपर नी भया। ");
INSERT INTO hlb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","मोखा नी मन्दिर म नी प्रार्थना घर हुन म, नी नगर म कोई से झगड़ा (विवाद) करत या भीड़ लगात पायो; ");
INSERT INTO hlb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","अर नी ते वी उ बात ख, जेको वी अब मोखा पर आरोप लगात हैं, तोरो सामे सच प्रमाणित कर सका हैं। ");
INSERT INTO hlb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","पर मी तोरो सामे यू मान लेहूँ हूँ कि जे पंथ ख वी रस्ता कहत हैं, उही की रीति पर मी अपन बापदादा हुन को परमेस्वर की सेवा करत हूँ; अर जे बात नेम अर भविस्यवक्ता हुन को किताब म लिखी हैं उन सब पा विस्वास करू हूँ। ");
INSERT INTO hlb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","अर परमेस्वर से आसा रखूँ हूँ जे वी तुम भी रखत हैं कि धर्मी अर अधर्मी दो ही जन को जी उठनो होगो। ");
INSERT INTO hlb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","एको मी तुम भी यत्न करत हूँ कि परमेस्वर की, अर इंसान हुन की तरफ मोरो विवेक सदा निर्दोस रया। ");
INSERT INTO hlb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ढ़ेर सारो साल को बाद म अपन लोग हुन ख दान (भिख) पहुँचानो, अर भेट चढान आयो हतो। ");
INSERT INTO hlb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","उन्होना मो ख मन्दिर म, सुध्द दसा म, बिना भीड़ को संग, अर बिना दंग करत हुया भेंट चढ़ात पायो हाँ आसिया को कई यहूदी हते उनख उचित हतो ");
INSERT INTO hlb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","कि अदि मोरो विरोध म ओको नजीक कोई बात होए ते यहाँ तोरो सामे आय ख मो पर आरोप लगावा। ");
INSERT INTO hlb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","या यू तुम ही बताए कि जब मी बड़ो सभा को सामे खड़ो हतो ते उनना मो म कोन सो अपराध पायो? ");
INSERT INTO hlb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","इही एक बात ख छोड़ जे मी न ओके बीच म खडो होयख पुकार ख कही हती: “मरो हुओ ख जी उठने को बारे म आज मोरो तुम्हारो सामे मुकदमा को रय्हो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","फेलिक्स न, जे इही रस्ता की बात हुन ठीक ठीक जानत हतो, उनना यू कह ख टाल दियो, “जब पलटन को सरदार लूसियास आएँगो, ते तुम्हारी बात को निर्णय करूँगो।” ");
INSERT INTO hlb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","अर सतपति ख आग्या दी कि पोलुस ख कुछ छुट म रख ख रखवाली करनु, अर ओको दोस्त हुन म से कोई ख भी ओकी सेवा करन से नी रोकनू। ");
INSERT INTO hlb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","कुछ दिन हुन को बाद फेलिक्स अपन ओरत द्रुसिल्ला का, जे यहूदी नी हती, संग लेय ख आयो अर पोलुस ख बुलवा ख उ विस्वास का बारे म जे मसी यीसु पर आय, ओसे सुनो। ");
INSERT INTO hlb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","जब वी धर्म, अर संयम, अर आन वाले न्याय को चर्चा कर रय्हा हता, ते फेलिक्स न डर ख उत्तर दियो, “अभी तर जा; मी अवसर पा ख तोखा फिर बुलाऊँगो।” ");
INSERT INTO hlb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ओ ख पोलुस से कुछ पैसा मिलन की आसा हती एकोलाने अर भी बुला-बुला ख ओसे बात कियो करत हतो। ");
INSERT INTO hlb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","पर जब दो साल बीत गया ते पुरकियुस फेस्तुस, फेलिक्स को जगह पर आयो; अर फेलिक्स यहूदी हुन ख खुस करन को चक्कर म पोलुस ख जेल म ही छोड़ दियो। ");
INSERT INTO hlb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","फेस्तुस उ देस म पहुँचन का तीन दिन बाद कैसरिया से यरूसलेम ख गयो। ");
INSERT INTO hlb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","तब पुजारी याजक हुन अर यहूदी हुन का खास अदमी हुन न ओखा सामने पोलुस कि नालिस करी; ");
INSERT INTO hlb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","अर ओ से प्रर्थाना कर ख ओखा खिलाप म यी वर चावा कि वी ओ ख यरूसलेम म बुलन की किरपा करे, काहेकि वी ओ ख रस्ता म ही मर ड़ालन की घात म लग हुए हता। ");
INSERT INTO hlb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","फेस्तुस न उत्तर दियो, “पोलुस कैसरिया म बन्दी म हैं, अर मी तुम जल्द ही वापस जाऊँगो।” ");
INSERT INTO hlb_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","फिर कय्हो, “तुम म कोई अगुवा रखह हैं वी संग चले, अर यदि इ अदमी न कुछ बुरो काम कियो आय ते ओ पर आरोप लगाए।” ");
INSERT INTO hlb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ओके बीच म कोई आठ दस रोज रह ख वी कैसरिया चलो गयो; अर दुसरो रोज न्याय आसन म बैहिठ ख पोलुस को लाने कि आग्या दी। ");
INSERT INTO hlb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","जब वी आयो ते जे यहूदी यरूसलेम से आया हता, उनना आसा-पास खड़ो होख ओ पर ढ़ेर सारो अपराध लगायो, जेको प्रमाण वी नी दे सकत हतो। ");
INSERT INTO hlb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","पर पोलुस न उत्तर दियो, “मी न नी ते यहूदी हुन की नेम को किताब को अऊर नी मन्दिर को, अऊर नी कैसर को विरूध्द कोई पाप कियो हाय।” ");
INSERT INTO hlb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","तब फेस्तुस न यहूदी हुन का खुस करन की इच्छा से पोलुस से कय्हो, “क तू चावा हैं कि यरूसलेम ख जाए अर वी मोरो सामे तोरो यू मुकदमा तय कियो जाए?” ");
INSERT INTO hlb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","पोलुस न कय्हो, “मी कैसर को न्याय-आसन को सामे खड़ो हाय; मोरो मुकदमा तय कियो जाए?” सजो तू अच्छी तरीका से जाना हैं यहूदी हुन को मी न कुछ बुरो नी करयो हाय। ");
INSERT INTO hlb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","अदि मी बुरो हाय अर मार डाले योग्य मी कोई काम कियो हैं, ते मरन से नी मुखर को; पर जे बात हुन को यु मोरो पर आरोप लगावा हैं, अदि उनमा से कोई भी बात सही नी ठहरे ते “कोई मोखा उनको हात नी सोप सका हैं। मी कैसर की दोहाई दे ख कहू हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","तब फेस्तुस न मंतरी हुन को सभा को संग बात कर ख कहन लग्या, तू न कैसर को दोहाई दी हाय, “तू कैसर को ही कने जाहे।” ");
INSERT INTO hlb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","कुछ दिन बितान को बाद अग्रिप्पा राजा अर बिरनीके न कैसरिया म आय ख फेस्तुस से भेट करी। ");
INSERT INTO hlb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ओके ढ़ेर सारो दिन उही रहन को बाद फेस्तुस न पोलुस का बारे म राजा ख बतायो: “एक अदमी आय, जेख फेलिक्स जेल म छोड़ दियो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","जब मी यरूसलेम म हतो, ते प्रधान याजक अर यहूदी हुन को सियाना न ओकी माँग कियो अर चाहा कि उ पर दण्ड की हुकुम दी जाहे। ");
INSERT INTO hlb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","पर मी न ओको उत्तर दियो कि रोमी कि यू रीति नी कि कोई इंसान का दण्ड को लाने सोप देहे, जब तक मुद्दाअलैह को अपन मुद्दई हुन को सामे खड़ो होय ख अपराध को उत्तर देन ख अवसर नी मिले। ");
INSERT INTO hlb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","अत: जब वी यू इकठ्टा भया, ते मी न कुछ बखत नी कियो, पर दुसरा ही दिन न्याय-आसन पर बैहिठ ख उ इंसान को लाने हुकुम दी। ");
INSERT INTO hlb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","जब ओको मुद्दई खड़ो भयो ते उनना असी अनुचित बात हुन आरोप नी लगायो जसा मी समझत हतो। ");
INSERT INTO hlb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","पर वी अपन मत को अर यीसु नाम कोई अदमी का बारे म, जे मर गयो हतो अर पोलुस ओको जिन्दो बतात हतो, विवाद करत हते। ");
INSERT INTO hlb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","मी उलझन म हतो कि इन बात हुन को बारे म कसो पता लगाऊ? एकोलाने मी न ओसे पूछो, क तू यरूसलेम ख जाएगो कि उही बात को न्याय होए? ");
INSERT INTO hlb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","पर जब पोलुस न दोहाई दे ख कहन लग्यो कि ओको मुकदमा म को फैसला महाराजा धिराज को यहाँ होए, ते मी न हुकुम दी कि जब तक ओ ख कैसर को नजीक नी भेजू, ओ ख हिरासत म रखो जाहे।” ");
INSERT INTO hlb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","तब अग्रिप्पा न फेस्तुस से कय्हो, “मी भी उ इंसान की सुननू चाहूँ हूँ। ओ न कय्हो तू कल सुन लेगो।” ");
INSERT INTO hlb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","अत: दुसरो रोज जब अग्रिप्पा अर बिरनीके बड़ो धूम धाम से आयो अर अर पलटन को सरदार हुन अर नगर को प्रमुख लोग हुन को संग दरबार म पहुँचिया। तब फेस्तुस न हुकुम दी कि वी पोलुस का ले आवा। ");
INSERT INTO hlb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","फेस्तुस न कय्हो, “हे राजा अग्रिप्पा, अर हे सब इंसान हुन जे यहाँ हमारो संग हो, तुम इ इंसान ख देखत हो, जेको बारे म सब यहूदी हुन न यरूसलेम म अर यू भी कल्ला करत मोसे विनती की कि इको जिन्दो रहनू उचित नी हाय। ");
INSERT INTO hlb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","पर मी न जान लियो कि ओ न असो कुछ नी कियो कि मार डाला जाहे; अर जबकि ओ न तुम ही बड़ो राजा जा धिराज को दोहाई दी, ते मी न ओ ख भेजन को निर्नय कियो। ");
INSERT INTO hlb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","मी न ओके बारे म कोई निस्चिय बात नी पायो कि अपनो ‍मालिक को नजीक लिखूँ। एकोलाने मी ओ ख तुमरो सामे अर विसेस कर ख हे राजा अग्रिप्पा, तोरो सामे लायो हूँ कि जाँचन को बाद मोखा कुछ लिखन का मिलो। ");
INSERT INTO hlb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","काहेकि बंदी ख भेजनू अर जे अपराध उ पर लगायो गयो, उन न बतायो, मो ख पड़त हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","राजा अग्रिप्पा न पोलुस से कहयो, “तो ख खुद अपनो बारे म बोलन को हक हैं” इ पर पोलुस न अपनो हात उठायो अर अपनो बचाव म बोलन सुरु कियो, ");
INSERT INTO hlb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","अरे राजा अग्रिप्पा! मी अपनो खुद को खुस किस्मत समझू हूँ कि यहूदी हुन न मोखा पा जे आरोप लगायो आय, उन सब बात हुन को बचाव म मी तोरो सामे बोलन जा रय्हे हूँ। ");
INSERT INTO hlb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","खास कर ख एको लाने की तू हैं कि तोखा सभी यहूदी रीति रिवाज हुन अर उनका लड़ाई हुन ख ग्यान हैं। एकोलाने मी तोसे प्रार्थना करूँ हैं कि धीरज का संग मोरी बात सुनो जाहे। ");
INSERT INTO hlb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","मोरो जिन्दगी छोटो पन से अपनी जात ख लोग हुन का संग, अर यरूसलेम देस म ही गुजरो हैं। एकोलाने सारा यहूदी जानह हैं कि सुरू से ही मोरो रहन सहन को ढंग कसो हतो। ");
INSERT INTO hlb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","वी मोखा ढ़ेर सारा बखत से जान हैं अर अदि वी चाहे ते ईच बात कि गवाही दे सका हैं कि मीन हमारो धर्म को एक सबसे जादा मजबूत धर्म ख जसो ही एक फरीसी को जसो म जिन्दगी जियो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","अब उ वादा म आसा को लाने जे परमेस्वर न हमारा बापदादा हुन से कियो गयो हतो। मो पर मुकदमा चला रय्हो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","उई वादा को पुरो होन की असो लगा ख हमारा बारा गोत अपनो पुरो मन से रात दिन परमेस्वर की आराधना करते आया हैं। अर हे राजा यही आसा को बारो म मो पर यहूदी दुवारा आरोप लगावा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","जबकि परमेस्वर मरिया वाला ख जिन्दो करा हैं, ते तुमरो यहां यह बात काहे भरोसा को काबिल नी समझी जावा। ");
INSERT INTO hlb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","मी न भी समझो हतो कि यीसु नासरी को नाम को विरोध म मो ख बेजा कुछ करनो चाहिए। ");
INSERT INTO hlb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","अर मी न यरूसलेम म यसो ही करियो हतो अर प्रधान याजक हुन से हक पा ख ठेर सारा सुध्द अदमी हुन ख जेल म ड़ालियो, अर जब वी मर जात रा ते मी भी उनको विरोध म अपनी गवाही देत रा। ");
INSERT INTO hlb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","हर प्रार्थना घर म मी उन ख दुख दिला दिला ख यीसु की निन्दा करवा तर असो तक की गुस्सा को मारे असो पागल हो गयो कि बाहर का सहर हुन म भी जा ख उन ख सतात रा। ");
INSERT INTO hlb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","यही धुन म जब प्रधान याजक हुन से हक अऊर आदेस चिट्ठी ले ख दमिस्क म जात रह हतो। ");
INSERT INTO hlb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","अरे राजा रस्ता म दोपहर की बखत मी न बादल से सूरज की आच से भी बड़ ख एक आंच देखी, अपनो अऊर अपना संग चलन वाला हुन को चारी तरफ चमकते देखियो। ");
INSERT INTO hlb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","जब हम सब जमीन पर गीर गया ते मी न इब्रानी भासा म बोलते हुए यह सब्द सुनायो, अरे साऊल अरे साऊल तू मो ख काहे सतावा हैं। पैनो पर लात मारनो तोरो लाने कठिन हाय। ");
INSERT INTO hlb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","मीन न कहयो अरे प्रभु तो कऊन आय प्रभु न कहयो कि मी यीसु आय जे ख सतावा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","पर अब तू उठ अपनो पाय पर खड़ो हो काहे की मी न तो ख एको लाने दर्सन दियो हैं कि तो ख वी बाप हुन को सेवक अर गवाह ठहराऊ जे तू न देखी हैं, अर उनको भी जिनको लाने मी तो ख दर्सन देऊ। ");
INSERT INTO hlb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","मी तो ख तोरा अदमी हुन से अर दुसरी जात हुन से बचातो रहूंगो जिनको जोने मी अब तो ख एको लाने भेजू हैं। ");
INSERT INTO hlb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","कि तू उनकी आँखी खोले कि वी अंधेरा से उजाला की तरफ अऊर सैतान को हक परमेस्वर की तरफ फिरे, पाप हुन की माफी अर वी अदमी हुन को संग जो मो पर भरोसा करनो से सुध्द करीया गया हैं वी छुटकारा पाय। ");
INSERT INTO hlb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","अत: हे राजा अग्रिप्पा, मी न ओ स्वर्गीय दर्सन की बात नी टाली आय, ");
INSERT INTO hlb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","पर पहलो दमिस्क ख, फिर यरूसलेम ख, अर तब यहूदिया को सारो देस ख रहन वाला ख अर दुसरी जात हुन का समझत रय्हा, कि मन फिराओ अर परमेस्वर को तरफ फिर ख मन मन फिराव के योग्य को काम करा। ");
INSERT INTO hlb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","इ बात हुन को कारन यहूदी मोखा मन्दिर म पकड़ ख मार डालन को प्रयास करत हते। ");
INSERT INTO hlb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","पर परमेस्वर को सहयोग से मी आज तक बनो आय अर छोटा बड़ा सभी को सामे भी गवाई देहु, अर उन बात हुन ख छोड़ कुछ नी कहू जे भविस्यव्दक्ता हुन अर मूसा न भी कही कि होन वाली हैं, ");
INSERT INTO hlb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","कि मसी ख दुख उठनो होएगो, अर उही सब से पहलो मरो हुओ म से जी उठ ख, “हमारो अदमी हुन म अर दुसरी जात हुन म प्रचार करेगों।” ");
INSERT INTO hlb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","जब वी इ रीति से उत्तर दे रय्हो हतो, ते फेस्तुस न ऊँचो आवाज से कय्हो, “अरे पोलुस, तू पागल आय। ढ़ेर सारो ग्यान न तो ख पागल कर दियो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","पर पोलुस न कय्हो, “हे महामहिम फेस्तुस, मी पागल नी आय, पर सच्चाई अर अकल की बात करू हूँ। ");
INSERT INTO hlb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","राजा भी जेके सामे बिना डरे होयख बोलू रय्हो हैं, यू बात जानत आय; अर मो ख विस्वास आय कि इ बात म से कोई ओसे छिपी नी, काहेकि यू घटना कोई कोना म नी भई। ");
INSERT INTO hlb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","हे राजा अग्रिप्पा, क तू भविस्यव्दक्ता हुन को विस्वास करा हैं? हाँ, मी जानू हूँ कि तू विस्वास करा हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","तब अग्रिप्पा न पोलुस से कय्हो, “क तू थोड़ा ही समझानो से मोखा मसी बनानो चावा हैं?” ");
INSERT INTO hlb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पोलुस न कय्हो, “परमेस्वर से मोरी प्रार्थना आय कि क थोड़ो म क ढ़ेर सारो म, केवल तू ही नी पर जितना लोग आज मोरी सुन हैं, इ बन्धन हुन ख छोड़ वी मोरो समान हो जाएगो।” ");
INSERT INTO hlb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","तब राजा अर हाकिम अर बिरनीके अर ओके संग बैठन वाला उठ खड़ा भया; ");
INSERT INTO hlb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","अर अलग जाय ख आपस म कहन लगिया, “यू अदमी असो ते कुछ नी करा, जो मृत्यु दण्ड या जेल म ड़ालन जाने योग्य आय।” ");
INSERT INTO hlb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","अग्रिप्पा न फेस्तुस से कहयो, “अदि यू अदमी कैसर की दोहाई नी देवा, ते यू छूट सका हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","जब निर्नय यू पुरो पक्को हो गयो कि हम जहाज को दुवारा इटली जाहे ते उनका पोलुस अर कुछ अऊर बधिया वाला ख भी यूलियुस नाम को ओगस्तुस की पलटन को एक सतपति का हात सोप दियो। ");
INSERT INTO hlb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","अद्रमुत्तियुम को एक जहाज पर जे आसिया को किनारा की जगा पर जान वालो हतो चढ़ ख हम न ओ ख खोल दियो अर अरिस्तर्खुस नाम को थिस्सलुनीकियो को एक मकिदूनी हमरो संग हतो रहा। ");
INSERT INTO hlb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","दुसरो रोज हम न सैदा म लंगर डालो अर यूलियुस न पोलुस पर किरपा कर ख ओखा दोस्त को इते जान दियो कि ओकी इज्जत कारी जाहे। ");
INSERT INTO hlb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","उते से जहाज खोल ख हवा को उल्टो होन को लाने हम साइपरस कि आड़ म होका चलिया। ");
INSERT INTO hlb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","अऊर किलिकिया अऊर पंफूलिया को जोने को समुंदर से हो का लूसिया को मूरा म उतरियो। ");
INSERT INTO hlb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","उते सतपति ख सिकन्दरिया को एक जहाज इटली जान वालो मिल्यो। अर ओ ना हम ख ओपर बठाल दियो। ");
INSERT INTO hlb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","जब हम बेजा दिन लक धीरे-धीरे चल ख दुख सुख से कनिदुस को जाने पहूँचिया ते एकोलाने की हवा हमका आगे नी बढ़न देत रहा हती, हम सलमोने को सामे से होय ख क्रेते को आड़ म चलो; ");
INSERT INTO hlb_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","अर ओको किनारा-किनारा कठिनाई से चल ख “सुभलंगरबारी” नाम को एक जगा पहुँचिया, जहाँ से लसया नगर नजीक हतो। ");
INSERT INTO hlb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","जब ढ़ेर सारो दिन बीत गयो अर पानी यातरा म जोखिम एकोलाने होत हती कि उपास काल को दिन बीत गयो हतो। अत: पोलुस न उनका यू कह ख समझायो, ");
INSERT INTO hlb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“हे सज्जनो, मो ख असो जान पड़ हैं कि इ यातरा म विपत्ति अर ढ़ेर सारो हानि होए, नी केवल माल अर जहाज को वरन् हमार प्राह हुन को भी होन वालो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","पर सतपति न पोलुस को बात हुन से कप्तान अर जहाज को मालिक को बात हुन ख बढ़ ख मानो। ");
INSERT INTO hlb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","वी जहाज रूकन वाली जगह बन्दरगाह जाड़ा काटन को लाने चोक्खो नी हतो, एकोलाने ढ़ेर सारो हुन को विचार भयो कि उते से नाव खोल ख अदि कोई रीति से हो सका ते फीनिक्स पहुँच ख जाड़ा काट यू ते क्रेते को एक नाव रूकन को जगह हाय जे दक्छिन-पस्चिम अर उत्तर-पस्चिम को तरफ खुलत हाय। ");
INSERT INTO hlb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","जब कुछ कुछ दक्छिनी हवा बहिन लगियो, ते यू समझ ख कि हमार अभिप्राय पुरो हो गयो, लंगर उठायो अर किनारा धरो भया क्रेते को नजीक से जानो लगियो। ");
INSERT INTO hlb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","पर थोड़ो देर न जमीन को तरफ से एक बड़ो आँधी उठयो, “जे यूरकुलीन” कहलावा हैं। ");
INSERT INTO hlb_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","जब जहाज प लगी ते वी ओको सामे रुक नी सकियो, अत: हम न ओ ख बहिन दियो अर यू तरह बहता भयो चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","तब कोदा नाम को एक छोटो सो टापू को आड़ म बहतो-बहतो हम मुसीबत से डोगो ख वंस म कर सकह ");
INSERT INTO hlb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","फिर मल्लाह हुन न ओ ख उठ ख हर एक उपाय कर ख जहाज को निचू से बाँधी अर सुरतिस को चोर बालू प चिक जान को डर से पाल अर सामान उतार ख बहतो भयो चलो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","जब हम न आँधी से ढ़ेर सारो हिचकोले अर धक्का खायो ते दुसरो रोज वी जहाज को माल फेकन लगिया। ");
INSERT INTO hlb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","अर तीसरो रोज उनना अपनो हात हुन से जहाज को साज-समान भी फेक दियो। ");
INSERT INTO hlb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","जब ढ़ेर सारो दिन हुन तक सूरज नी, नी तारा दिखाई दिया अर बड़ी आँधी चलत रही, ते अन्त म हमार बचान को सारी आसा जात रही। ");
INSERT INTO hlb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","जब वी बेजा सारो दिन तक भुखा रया, ते पोलुस न उन ख बीच म खड़ो हो ख कय्हो, “हे लोग हुन, चाहिए थो कि तुम मोरी बात मान ख क्रेते से नी जहाज खोलह अर वी इते विपत्ति आवा अर नी यू हानि उठावा।” ");
INSERT INTO hlb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","पर अब मी तुम ख समझाऊ हैं कि धीरज धरो, काहेकि तुम म से कोई की जान की नुकसानी नी होन की पर सिरप जहाज की। ");
INSERT INTO hlb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","काहेकि परमेस्वर जे को मी आय, अर जेकी सेवा मी करू हैं। ओखा स्वर्गदूत न आज रात मोरो जोने आ ख मोसे बोल्या, ");
INSERT INTO hlb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","अरे पोलुस, मत डरा! तो ख कैसर को सामने खड़ो होनो जरूरी हैं। देख परमेस्वर न सबका जो तोरो संग सफर करा हैं। तो ख दियो हैं। ");
INSERT INTO hlb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","एकोलाने , अरे सज्जन हुन, धीरज धरनो; काहेकि मी परमेस्वर को ऊपर भरोसा करू हैं, जसो मोसे कय्हो गयो हैं, वसो ही होयगो। ");
INSERT INTO hlb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","पर हम ख कोई टापू पर जा ख टिकनो पड़ो। ");
INSERT INTO hlb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","“जब चऊदह वी दिन की रात आई, अर हम अद्रिया समुंदर म भटक रहा फिरत रह, ते आधी रात को निकट मल्लाह हुन न अनुमान लगा ख जानियो कि हम कोई देस को नजीक म पहुँचन वाला हैं। ");
INSERT INTO hlb_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","गहिरो नापनो पर उनना बीस पुरुस गहिरो पायो, अऊर थोड़ो आगे बढ़ ख फिर से नापियो ते पन्द्रह पुरुस पायो।” ");
INSERT INTO hlb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","तब पत्थर वाली जमीन से टकरान को डर से उन ना जहाज की पिछाड़ी चार लंगर डाल्या, अर भूनसारो होन की आसा लगाया हता। ");
INSERT INTO hlb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","पर जब नावरीया हुन नाव (जहाज) पर से भागन की सोचत रह, अर आगे को भाग (गलही) से लंगर डालन को बहाना नाव समुंदर म उतार दी; ");
INSERT INTO hlb_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ते पोलुस न सतपति अर सैनिक हुन से कय्हो, “अदि यी जहाज पा नी रहन का, ते तुम मी नी बच सकन का।” ");
INSERT INTO hlb_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","तब सैनिक हुन न रस्सा काट ख नाव गिरा दिया। ");
INSERT INTO hlb_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","जब भुनसारो होन पा हतो, तब पोलुस न यू बोल ख, सब का खाना खान को लाने समझायो, आज चऊदह दिन गया कि तुम आसा देखते देखते भुखा रया अर कुछ भी खाना नी कियो। ");
INSERT INTO hlb_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","एकोलाने तुम ख समझऊ हैं कि कुछ खा लेव, जेसे तुमारी बचाव हो सके; काहेकि तुम म से कोई को मुण्डी को एक बाल भी नी गिरन को। ");
INSERT INTO hlb_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","असो कह ख ओ न रोटी ले ख सब को सामने परमेस्वर को धन्यवाद करियो अर तोड़ ख खान लग गयो ");
INSERT INTO hlb_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","तब वी सब ढाढ़स बाँध ख खाना खान लगिया। ");
INSERT INTO hlb_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","हम सब मिल ख नाव पर दो सव छिहत्तर जन हते। ");
INSERT INTO hlb_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","जब वी खाना खा ख तृप्त भया, ते गहूँ का समुंदर म फेक ख जहाज हल्को करन लगिया। ");
INSERT INTO hlb_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","“जब दिन निकलियो हे उनना उ देस का नी पहिचानी, पर एक खाड़ी देखी जेको किनारा चऊरस हतो, अर वी विचार कियो कि अदि हो सका ते इसी प जहाज का टिकाहे।” ");
INSERT INTO hlb_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","तब उनना लंगरा हुन ख खोल ख समुंदर म छोड़ दियो अर उही बखत पतवारो को बंधन खोल दियो, अर हवा को सामे अगलो पाल चढ़ा ख किनारा को तरफ चलन लगिया। ");
INSERT INTO hlb_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","पर दो समुंदर को एक जगा मिलन की जगह देख ख उनना नाव को टिकायो, अर गलही तो धक्का खा ख गड़ गई अर टल नी सकी; पर पिच्छु की लहर हुन को हिसाब से टुटन लगी। ");
INSERT INTO hlb_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","तब सैनिक हुन को यू विचार भयो कि, बन्धिया वाला इंसान ख मार डालो असो नी होय की कोई तीर ख बहार निकल ख भगे। ");
INSERT INTO hlb_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","पर सतपति न पोलुस का बचान की इच्छा से उन्हे इ सोच से रोका अर यू कय्हो, कि जे तैर सका हैं पहले कुद ख किनारा म निकल जाहे; ");
INSERT INTO hlb_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","अर बाकी हुन कोई पटरो पर, अर कोई जहाज की अन्य समान हुन को सहारो निकल जाहे। इ रीति से सब जन जमीन पर बच निकले। ");
INSERT INTO hlb_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","जब हम बच निकल्या, ते पता चल्यो कि यू व्दीप मालटा को नाम हतो। ");
INSERT INTO hlb_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","वहा ख रहन वाला न हमारो संग अनोखी किरपा कियो काहेकि जाड़ो को दिन हतो अर पानी भी गिरन लगो ऐको लाने आगी जलाई हम सब ख समान दियो। ");
INSERT INTO hlb_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","जब पोलुस न लकड़ी हुन को गट्ठा बटोर ख आगी पा धरीयो ते एक साँप आँच ले ख निकलो अर ओको हात से गुमंड गयो। ");
INSERT INTO hlb_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","जब वी रहन वाला हुन न साँप ख ओको हात पर गुमंडियो हुयो देखो, ते एक दुसरा से कहन लग्या “सही म यू अदमी हत्यारो हैं कि जसो समुंदर से बच गयो, ते मी न्याय न जिन्दो रहन नी दियो।” ");
INSERT INTO hlb_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","तब पोलुस न साँप ख आग क झटक दियो, अर पोलुस ख कुछ भी नुकसान नी भयो। ");
INSERT INTO hlb_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","वी रस्ता देखत रह कि उ सूज जाएगो या एकाएक जमीन गिर ख मर जाएगो पर जब वी बड़ी देर तक देखते रया अर देखो की ओको कुछ भी नी बिगड़ा ते अपनी सोच बदल ख कय्हो, “यु तो कोई भगवान आया।” ");
INSERT INTO hlb_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","वा जगह को आजू बाजू उ टापू को मुखिया पुबलियुस की जमीन हती। ओ न हम ख अपनो घर ले जा ख तीन रोज तक प्रेम व्यवहार मिजवानी करी ");
INSERT INTO hlb_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","पुबलियुस को दादा जुड़ अर खुन बहिन वालो से रोग से पड़ियो हतो। ऐको लाने पोलुस घर को भीतर गयो। ते पोलुस न ओखा ऊपर हात रख ख प्रार्थना करियो ते उ इंसान चोक्खो कर दियो। ");
INSERT INTO hlb_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","इ घटना को बाद उ टापू ख जित्ता झन बीमार हता वी सब चोक्खो होय गया। ");
INSERT INTO hlb_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","एकोलाने लोग हुन ढ़ेर सारो भेट दियो जब हम नाव म से सामे चलन लग्या ते, जे कुछ हमरो लाने जरूरी सामन जहाज पा रख दियो। ");
INSERT INTO hlb_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","तीन माह को बाद सिकन्दरिया को एक जहाज म हम चल पडिया, यू जहाज सिनस्तु म उही रुको हता जहाज को अगलो भाग म जुडुवा ईस्वर असो निसान अंकित हतो। ");
INSERT INTO hlb_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","हम सुरक्छा सहर म पहुँचिया अर हम तीन रोज तक रूकया हता। ");
INSERT INTO hlb_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","वहाँ से हम जहाज को व्दारा रेगियूस म आया पहुँचियो: अर फिर अगलो ही रोज को बाद दक्छिन वाली हवा लगी, ते अगलो रोज हम पुतियुली म आ गयो। ");
INSERT INTO hlb_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","वहाँ हम ख विस्वासी भई मिल्या, अर उनको कहना से हम उनको इते सात रोज तक रया; अर यू तरीका से हम रोम का चल्या। ");
INSERT INTO hlb_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","जब रोम का विस्वास भई हुन न हमारो आवन कि खबर मिली ते वी अप्पियुस बाजार अर तीन सराय गाँव लक हमेसा मिलन ख आयो जब पोलुस न उन ख देखो ते परमेस्वर ख आसीर्वाद दियो अर ढ़ेर सारो बड़ाई करी। ");
INSERT INTO hlb_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","जब हम रोम म पहुँचिया, ते एक सिपाई कि देख रेख म पोलुस ख अपनो खुद अलग से रहन कि अनुमती मिल गई; ");
INSERT INTO hlb_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","तीन रोज को बाद पोलुस न यहूदी अगुवा ख बुलायो अर उन ख इकट्ठा हो जानो पर वी उन से बोल्यो अरे, “भई हुन, चाहे मी न अपनो बाप दादा हुन को रीति रिवाज अर मोरो लोग हुन को खिलाप कुछ भी नी करियो आय ते बही उनना बंदी बना ख यरूसलेम से रोमी को हात म सोपो गयो। ");
INSERT INTO hlb_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","रोमन अधिकारी हुन न मो ख छोड़ देनो चाहयो, काहेकि मो म माऊत की सजा देन को लायक कोई दोस नी हतो, ");
INSERT INTO hlb_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","काहेकि जब यहूदी हुन ऐका परेसान करन लग गया कि की मी कैसर की दोहाई देनो पडे: ऐको लाने नी कि मी अपनो ही लोग हुन पर कोई खिलाप लगानो चावत रह। ");
INSERT INTO hlb_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","एको लाने मी न तुम ख बुलायो हैं कि तुम से मिलू अर बातचीत करू; काहेकि इस्राएल की आसा को लाने मी या साँकल से बाँधी गयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","यहूदी अगुवा हुन न पोलुस कय्हो, “तुमारो विसय म यहूदिया प्रांत हुन से कोई चिठ्टी ही वहा लियो, अर न भई न तोरो कोई नी खबर दियो अर नी तोरो म कोई बुरी बात कय्हो। ");
INSERT INTO hlb_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ते तोरो विचार का हैं, उई हम तो से सुनो चाहवा हैं, काहेकि हम जाना हैं कि लोग सब कही ईच धर्म का खिलाप म बोल हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ते यहूदी हुन न पोलुस को संग एक दिन सलाह ठहरायो, अर ढ़ेर सारा इंसान ओको यहाँ इकट्ठा भयो, पोलुस सबेरे से साम तक उनका लाने समझनो कर रह हैं। उन हुन परमेस्वर को राज को बारे म गवाही दी अर मूसा को नेम अर ख, भविस्यवक्ता हुन की किताब हुन का ओखा ऊपर उन ख यीसु को रस्ता म समझान ख कोसिस करियो। ");
INSERT INTO hlb_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ओ न जे कुछ कय्हो हतो, ओ ख कुछ ते मान लियो गया बल्कि कुई न ते भरोसा नी करिया। ");
INSERT INTO hlb_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","जब वी आपस म एक मत नी भया, ते पोलुस की या बात को कहनो पर चलो गयो: सुध्द आत्मा न यसायाह भविस्यवक्ता को दुवारा तुमरा बापदादा हुन से अच्छो ही कय्हो, ");
INSERT INTO hlb_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","जाख यी अदमी हुन से बोल, कि सुनते तो रहे पर न समझन का, अर देखते तो रहे, पर नी दिखन को ");
INSERT INTO hlb_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","काहेकि यी अदमी हुन को मन मोरो अर उनको कान कुन्द हो गया हैं, अर उनना अपनी आँख बंद करी हाय, असो नी होय की वी कभी आँख से देखे अर कान हुन से सुने अर मन से समजे अर फिरे, “अर मी उन ख चोक्खो करूँ हैं।” ");
INSERT INTO hlb_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","एको लाने खुद सब ख मालूम होय कि “परमेस्वर को यु उध्दार की बात गैर यहूदी हुन ख भेजो गयो हैं। वी जरूर ही सुनेगो।” ");
INSERT INTO hlb_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","जब पोलुस यू कह चूको ते वी आपस म ज्यादा लड़ाई करन लग गया अर उते से चले गये। ");
INSERT INTO hlb_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","पोलुस पूरा दो साल अपनो किराया को घर म रयो। ");
INSERT INTO hlb_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","उ परमेस्वर ख राज को प्रचार करा हैं प्रभु यीसु मसी ख बारे म उपदेस देवा हैं। उ यू काम ख पूरो बे धड़क अर बीना कोई रोक से जसो कियो करत राहा।");
INSERT INTO hlb_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","अर यू चिट्ठी यीसु मसी को दास पोलुस कि तरफ से आये, जे परमेस्वर को वजेसे सिखान वालो प्रेरित होन ख लाने बुलायो गयो हैं अऊर परमेस्वर को उ समाचार ख लाने अलग करियो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","परमेस्वर न पहलो से ही अपना भविस्यवक्ता हुन ख दुवारा सुध्द सास्र म, उ सुभ समाचार को वादा कर दियो रहा, ");
INSERT INTO hlb_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","अपनो पोरिया हमारो प्रभु यीसु मसी को बारे म वादा करयो रहा; उ सरीर को हिसाब से तो दाऊद को खानदान से पैदा भयो। ");
INSERT INTO hlb_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","अर ओको पोरिया हमरो प्रभु यीसु मसी को बारे म हैं। पर सुध्द आत्मा को हिसाब से मुर्दा म से जिन्दो होन को वजे से सामर्थ्य को संग परमेस्वर को पोरिया आय साबित भयो। ");
INSERT INTO hlb_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ओको वजेसे हम ख किरपा अरे सिखावन ख मिल्यो कि ओको नाम को वजेसे पुरी जात ख इंसान हुन विस्वास कर ख ओकी माने, ");
INSERT INTO hlb_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","जे मन से तुम भी हैं यीसु मसी का ही होन का लाने बुलायो गया हैं। ");
INSERT INTO hlb_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","उन सब को नाम जो रोम म परमेस्वर ख प्यारो हैं अऊर सुध्द होन ख लाने बुलायो गया हैं: हमारो बाप परमेस्वर अर प्रभु यीसु मसी कि ओर से तुम ख किरपा अर सान्ति मिलती रैय। ");
INSERT INTO hlb_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","सबसे पहले मी तुम सब को लाने यीसु मसी को वजेसे अपनो परमेस्वर कि बड़ाई करू हैं, काहेकि दुनिया भर म तुमारो विस्वास कि खबर फैइल गई हैं। ");
INSERT INTO hlb_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","जो परमेस्वर को सेवा मी ओको पोरिया को सुभ समाचार को वजेसे पुरो मन से करू हैं, उ मोरो गवाह आय कि मी अपनो बिनती करनो म तुम ख लगातार याद कर हूँ, ");
INSERT INTO hlb_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","अऊर हमेसा असी बिनती करू हैं कि परमेस्वर कि मर्जी से कई न कई तरीका से मोखा आखरी म तुम अदमी हुन को नजीक आवन का अच्छो मऊका मिले। ");
INSERT INTO hlb_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","काहेकि मी तुम से मिलन कि इच्छा करू हैं की मी तुम ख विस्वास म मजबुत बनान ख लाने तुमका भी एक आत्मिक वरदान देन कि सोचू हैं; ");
INSERT INTO hlb_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","या असो कहे: मी सोचू हैं कि मी तुमारो यहाँ रह ख तुमरो विस्वास करनो से कुछ सीखु अऊर मोरो विस्वास करनो से सिखो। ");
INSERT INTO hlb_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","अरे भई हुन मी नी चाहूँ हैं कि तुम असी बात हुन से अनजान रैव कि मी न बार-बार तुमारो जोने आन को पिलान बनायो ताकि, जसो दुसरी जात हुन म फल मिले, वसो ही तुम म भी मिले, ते भी अब तक वहाँ जान ख लाने रोको गयो। ");
INSERT INTO hlb_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","म अपनो ख यूनानी हुन फिर गैर-यूनानी हुन, ग्यानी हुन अर निर्बुध्दी हुन ख कर्जदार माना हैं। ");
INSERT INTO hlb_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","अब म तुम ख भी जे रोम सहर म रवह हैं, सुसमाचार सुनान ख लाने तैयार रवह हैं। ");
INSERT INTO hlb_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","काहेकि म सुसमाचार से लज्जित नी होऊ, एकोलाने कि उ हर एक विस्वास करनवाला का लाने, पहले ते यूनानी फिर गैर यहूदी का लाने, उध्दार को लाने परमेस्वर कि सामर्थ्य हैं। ");
INSERT INTO hlb_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","काहेकि ओ म परमेस्वर कि न्यायीपन विस्वास से अर विस्वास ख लाने प्रगट होय हैं; जसो लिखो हैं, “विस्वास से धर्मी इंसान जिन्दो रहे।” ");
INSERT INTO hlb_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","परमेस्वर को यू घुस्सा स्वर्ग से वी सब पाप अऊर लोग हुन ख अधर्म काम ख विरोध म प्ररगट होवा हैं। जे को झूठो तरीका से सच ख जान न ख लाने रूक हैं। ");
INSERT INTO hlb_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","यू कारन हैं कि परमेस्वर को बारे म जे कुछ जानो जा सक हैं, उ उन पर प्ररगट भयो। खुद परमेस्वर न ओ ख उन पर प्रगट करियो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","अऊर जब से परमेस्वर न दुनिया ख बनायो हैं। तब से परमेस्वर को नी दिखाई देन वालो गुन ओको हमेसा सक्ति अर ओको देवीका आचरन दोई ख साफ साफ समझ अर देखो जा सक हैं, असो बतायो जाय हैं ते कोई बहाना नी हैं। ");
INSERT INTO hlb_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","यू कारन कि परमेस्वर ख जानन पर भी उनना परमेस्वर को काबिल बड़ाई अऊर धन्यवाद नी कियो पर बेकार विचार करन लग गया, इत्तो तक कि उनको मन भीतरी से न समझ हो गयो। ");
INSERT INTO hlb_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","वी अपनो आप ख बुध्दिमान समझ ख मुर्ख बन गया, ");
INSERT INTO hlb_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","अऊर अविनासी परमेस्वर कि बड़ाई ख नासवान अदमी, अऊर चिड़िया हुन, अऊर चार पाय वालाहन, रेगनवालो अर जन्तु हुन कि मूर्ति को रूप म बदल डालो। ");
INSERT INTO hlb_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","एकोलाने परमेस्वर न उनका उनको मन कि अभिलासा हुन ख अनुसार असुध्द हुन ख लाने छोड़ दियो कि वी आपस म अपनो सरीर हुन ख अनादर कर। ");
INSERT INTO hlb_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","काहेकि उनना परमेस्वर कि सच्चाई ख बदल ख झूठ बना दियो, अर सृस्टी कि उपासना अर विनती अर सेवा करी, नी कि ओ ख सृजनहार कि जो सदा धन्य हैं। आमीन। ");
INSERT INTO hlb_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","एकोलाने परमेस्वर न उन ख बुरा काम हुन ख बस म छोड़ दियो; यहाँ तक कि ओकी ओरत हुन न भी स्वाभाविक व्यवहार ख ओ ख जो स्वभाव को खिलाप हैं, बदल डालो। ");
INSERT INTO hlb_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","वसो ही तरीका से अदमी हुन न भी बाई हुन को संग प्राकृतिक संबध हुन ख छोड़ दियो अर एक दूसरा हुन ख लाने वासना हुन को संग भड़कायो गया अदमी हुन न दूसरा अदमी हुन को संग लाज को हर कते को तुम ख उनको गलती हुन ख दंड मिलो। ");
INSERT INTO hlb_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","अऊर काहेकि उनना परमेस्वर ख पहिचान न से इंकार कर दियो, ते परमेस्वर न उन ख वसो ही निबुध्दि रहन दियो अर वी मन कि इच्छा से जिन्दो काम करन लगो। ");
INSERT INTO hlb_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","एकोलाने वी सब तरीका को अधर्म, अऊर दुस्टता, अऊर लोभ, अऊर बैर भाव से भर गयो हैं; अर डाह, अऊर हत्या, अऊर झगड़ा अर धोखा, जलन से भरपूर होय गयो, अर चुगलीखोर, ");
INSERT INTO hlb_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","बदनाम करनवालो, परमेस्वर से घुसा करनवालो, दुसरा का अनादर करनवालो, अभिमानी, डींगमार, बुरी-बुरी बात हुन ख बनान वाला, माय-बाप को केहना नी मानन वाला, ");
INSERT INTO hlb_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","बेग्यानी, विस्वासघती, दया रहित अर बेरहमी होय गया। ");
INSERT INTO hlb_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","वी तो परमेस्वर की या विधि जानत हैं कि असो बुरो काम करन वाला ख अच्छो सजा मरनो हैं। ते भी वी नी अकेलो खुद यू ही काम कर हैं, पर असो बुरो करन वाला से खुस भी होय हैं। ");
INSERT INTO hlb_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","एकोलाने तोरो नजीक कोई बाहाना नी हैं तुम ते दूसरो पर दोस लगवा हैं जे से कि तुम जे निर्नय कर हैं उ ईच तुम खुद कि निंदा कर हैं, तुम जे निर्नय लेवय हैं ऐको उ ईच काम कर हैं। ");
INSERT INTO hlb_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","हम जान हैं कि उ ईच तरह को काम करन को खिलाफ परमेस्वर को तरफ से सच्चो निर्नय को हैं का न्याय सच्चाई पर आधारित हैं। ");
INSERT INTO hlb_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","अरे इंसान, तू जे असो काम करन वाला हुन पर दोस लगायो हैं, अऊर खुद उ ही काम करत आय, का यू समझत आय, कि तू परमेस्वर कि सजा या केहना से बच जाहे? ");
INSERT INTO hlb_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","का तू परमेस्वर की किरपा, अऊर सहनसीलता, अऊर धीरज रूपी धन ख बेकार जान हैं? का यू नी समझ हैं कि परमेस्वर कि किरपा तो ख पस्चाताप करन की अगुवाई कर हैं? ");
INSERT INTO hlb_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","लेकिन तू ही अपनो यू हठ अर अपनो मन पस्चाताप नी करन वालो तुम ही परमेस्वर को गुस्सा ख दिन को लाने खुद ख खिलाफ गुस्सा इकट्ठा कर रया हैं। जब ओको न्यायी पन निर्नय सामने आहे। ");
INSERT INTO hlb_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","परमेस्वर हर एक ख उनको काम को अनुसार बदला दहे: ");
INSERT INTO hlb_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","अऊर जे लोग सान्ति पूर्वक भलाई कर हुयो बड़ाई, आदर अर अमरता की खोज म लगो रह हैं, परमेस्वर उन क अनन्त जिन्दगी देहे गयो; स्वार्थी रह हैं अर जे सच्चाई ख अस्वीकार कर हैं। ");
INSERT INTO hlb_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","परन्तु जे लोग हुन जे स्वार्थी कि खोज म रहन हैं अऊर सच्चाई कि खोज नी कर हैं, अर अधर्म पर चल हैं। अर ओ पर गुस्सा अर जादा भड़का पड़ेगो। ");
INSERT INTO hlb_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","अऊर परेसानी अऊर संकट हर एक अदमी ख जान पर जे बुरो करा हैं आहे, पहले गैर यहूदी पर फिर यूनानी पर। ");
INSERT INTO hlb_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","अऊर भलाई करन वाला हर एक अदमी ख कल्यान हर एक ख पहले यहूदी ख फिर यूनानी ख बड़ाई, आदर अऊर सान्ति मिले। ");
INSERT INTO hlb_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","काहेकि परमेस्वर कोई को भी पक्छपात नी कर हैं। ");
INSERT INTO hlb_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","एकोलाने जीन हुन बिना मूसा को नेम पाहे पाप कियो, वी बिना नेम ख खत्म भी होए; अऊर जीन न भी नेम पा ख अपराध कियो, ओकी मूसा को नेम को अनुसार न्याय कियो जाहे; ");
INSERT INTO hlb_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","काहेकि परमेस्वर का यहाँ नेम ख सुनन वालो लोग परमेस्वर कि देखन म धर्मी नी हैं, पर मूसा को नेम पर चलन वालो न्यायी ठहरे जाहे। ");
INSERT INTO hlb_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","काहेकि जे गैर यहूदी हैं वी अपनो व्यवस्था से मूसा कि नेम नी होन को पस्चात फिर भी वी अपनो मन म मूसा की नेम को पालन करनो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","अऊर वी अपनो मन म लिखो हुयो नेम को कर्मी को दिखायो, उनको विवेक भी गवाही दियो, अर उनको मन उन ख कभी दास हुन ते कभी निर्दोस ठहरो हैं; ");
INSERT INTO hlb_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","यू सब उ दिन प्ररगट कियो जाहे, कि जब परमेस्वर, मोरो अच्छो समाचार ख जसो, यीसु मसी दुवारा लोग हुन को छुपी सलाह हुन ख न्याय करे। ");
INSERT INTO hlb_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","अदि तू यहूदी कह हैं, ते नेम पर विस्वास रख हैं, अऊर परमेस्वर ख बारा म गर्व कर हैं, ");
INSERT INTO hlb_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","अदि तुम ओ ख सिक्छा ख जान हैं, जे अच्छो हैं। अऊर जे परख कर सका हैं, जे कि तुम ख मूसा को नेम दुवारा निर्देस कियो; ");
INSERT INTO hlb_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","अऊर अपनो पर विस्वास रख हैं; कि म अंधो ख अगुवा, अर अंधकार म पड़ो हुयो कि ज्योति, ");
INSERT INTO hlb_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","अऊर समझदार ख सिखानवालो, अऊर पोरिया ख उपदेसक हूँ; अऊर ग्यान, अऊर सच को नमूना, जो नेम म हैं, मोखा मिलयो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ते का तू जे दूसरा हुन ख सिखाव हैं, अपनो खुद ख नी सिखाव हैं? का तू जे चोरी नी करन को उपदेस देव हैं, तुम ही चोरी करा हैं? ");
INSERT INTO hlb_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","तू जो कह हैं, “गलत काम नी करनो”, का खुद ही छिनालापन करा हैं? तू जे मुरती हुन से गुस्सा करा हैं, का खुद ही मन्दिर हुन ख लुट हैं? ");
INSERT INTO hlb_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","तू जे नेम ख बारा म घमंड करा हैं, का नेम नी मान ख परमेस्वर को अनादर करा हैं? ");
INSERT INTO hlb_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","“काहेकि तुमारो लाने गैर यहूदी हुन म परमेस्वर ख नाम कि बुराई की जाव हैं।” जसो लिखो भी हैं। ");
INSERT INTO hlb_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","पर तू नेम पर चले हैं ते खतना से का फायदा ते हैं, पर अगर तू नेम ख नी माने ते तोरो खतना बिन खतना कि दसा ठहरे। ");
INSERT INTO hlb_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","एकोलाने अदि खतना रहित गैर यहूदी इंसान नेम कि विधि हुन माना कर, ते का ओकी गिनती बिना खतना कि दसा खतना को सामने नी गिनो जाहे? ");
INSERT INTO hlb_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","अर जो अदमी सारीरिक रूप से बिना खतना रहे, अगर उ नियम ख पूरो करिये, ते का तोखा जो लेख पानो अर खतना कियो जाने पर भी नेम ख माना नी करिये हैं, दोस नी ठहराएगो? ");
INSERT INTO hlb_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","काहेकि यहूदी उ नी जो दिखन म यहूदी हैं; अर नी उ खतना हैं जो दिखन म हैं अर सरीर म हैं। ");
INSERT INTO hlb_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","पर यहूदी उ हैं जो मन म हैं; अर खतना उ हैं जो मन ख अर आत्मा म हैं, नी की लेख को: असो कि खुसी अदमी हुन कि तरफ से नी, पर परमेस्वर कि तरफ से होवा हैं। ");
INSERT INTO hlb_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ते का दूसरा हुन कि इच्छा यहूदी का जादा का मिला? अऊर खतने से का फायदा? ");
INSERT INTO hlb_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","हर तरीका से बेजा कई! पहले ते यू कि परमेस्वर को वचन उन ख सोप गयो। ");
INSERT INTO hlb_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","अदि कुछ अविस्वास करन वाला निकले भी ते का भयो? का उनको भरोसा नी होनो से परमेस्वर की सच्चाई बेकार ठहरे? ");
INSERT INTO hlb_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","कभी नी भलो ही हर एक व्यक्ति झूठो निकल जाहे, पर परमेस्वर सच्चो लिखो होए; जसो कि सुध्द सास्र म लिखो हैं तोरो वचन तोखा धार्मिकता ठहरायो हैं; जब तोरो न्यायीपन होय हैं ते तू जीत मिले हैं। ");
INSERT INTO hlb_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","अदि पर हमारो अधर्म परमेस्वर ख धार्मिकता रयो देवा हैं, ते हम का कहे? का यू कि परमेस्वर जो घुस्सा करिये हैं अधर्मी हैं? यू ते म अदमी की रीति पर कहूँ हैं। ");
INSERT INTO hlb_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","कभी नी नी ते परमेस्वर कसो दुनिया को न्याय करे? ");
INSERT INTO hlb_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","यू मोरो झूठ को कारन परमेस्वर को सच को ओकी महिमा ख लाने अधिकार ख प्ररगट होवा हैं, ते फिर काहे पापी ख जसो म न्याय ख तैयार रयो जाय हैं? ");
INSERT INTO hlb_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","“तब काहे नी कहयो, कि हम ख बुराई कर हैं काहे भलाई आ सक?” कुल लोग हुन न वास्तव म मोपर यहाँ बात कहन को आरोप लगा ख मोरो अपनो कियो हैं कि उनकी बुराई करी जाय जसो मोरो जसो यहाँ होनो उचित हैं। ");
INSERT INTO hlb_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ते हम का? उपायए का हम ओ से अच्छो हैं? असो नी; काहे कि हम यहूदी हुन अऊर यूनानी हुन दूई पर यू दोस लगा चूको हैं कि वी सब ख सब पाप को फसो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","जसो लिखो हैं; “कोई धर्मी नी, एक भी नी। ");
INSERT INTO hlb_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","कोई भी समझदार नी हैं; कोई परमेस्वर ख ढुनन वालो नी हैं। ");
INSERT INTO hlb_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","सब भटक गया हैं; सब ख सब बेवकूप बन गया हैं; कोई दया करन वालो नी हैं, एक भी नी। ");
INSERT INTO hlb_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","उन को गला खुली हुई सामधी हैं उनको अपनो जीभ हुन से धोखा कियो हैं, ओ न होट हुन म सर्प को जहर हैं। ");
INSERT INTO hlb_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","उन को मुँह बद्दुवा राप अऊर कड़वाहट से भरो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","उन का पाय खून बहान ख जोसिलो हैं ");
INSERT INTO hlb_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","उन का रस्ता म नास अऊर दुख हैं, ");
INSERT INTO hlb_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","उन ख सान्ति को रस्ता नी मालूम। ");
INSERT INTO hlb_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","उन कि आँखी हुन का सामने परमेस्वर ख डर नी हैं।” ");
INSERT INTO hlb_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","हम ख मालूम हैं कि नेम जे कुछ कह हैं ऊईच से कह हैं, जे नेम को बस हैं एकोलाने कि हर एक मुँह बंद करियो जाहे हैं अऊर सारो दुनिया परमेस्वर को सजा का लायक रूके; ");
INSERT INTO hlb_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","काहेकि नेम को काम हुन से कोई सरीर ओखा सामने धर्मी नी ठहरे, एकोलाने कि नेम ख अऊर पाप हुन ख पहिचान होऐ हैं। ");
INSERT INTO hlb_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","पर अब नेम से अलग परमेस्वर कि उ धार्मिकता प्रगट भयो हैं, जेकी गवाही नेम अऊर भविस्यवक्ता हुन देवा हैं, ");
INSERT INTO hlb_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","जसो कि परमेस्वर कि उ धार्मिकता जे यीसु मसी पर विस्वास करना से सब विस्वास करन वालो ख लाने हैं। काहेकि कुछ छुपो नी हैं, ");
INSERT INTO hlb_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","एकोलाने कि सब न पाप कियो हैं अऊर परमेस्वर कि महिमा से दूर हैं, ");
INSERT INTO hlb_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","पर ओको दया से उ छुटकारा ख दुवारा जे मसी यीसु म हैं, सेंतमेंत धर्मी ठहरायो जाहे हैं। ");
INSERT INTO hlb_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ओ ख परमेस्वर न ओको खून को कारन एक असो पचताप ठहरायो, जे विस्वास करन से कामकारी होव हैं, कि जे अपराध पहले कियो गयो अऊर जीन पर परमेस्वर न अपनो सहनसीलता का कारन याद नी दियो। उन को बारे म उ अपनो धार्मिकता प्ररगट करिये। ");
INSERT INTO hlb_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","पर ऊईच बखत ओकी धार्मिकता प्ररगट हो कि जेसे उ खुद ही धर्मी रूको, अऊर जो यीसु पर विस्वास करा, ओको भी धर्मी ठहरानो होन वालो होए। ");
INSERT INTO hlb_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ते घमंड करनु कहाँ रहयो? ओको ते जगह ही नी हैं। कोन-सो नेम ख कारन से? कर्मी कि नेम से? नी, पर विस्वास का नेम को कारन। ");
INSERT INTO hlb_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","एकोलाने हम ऊईच परिनाम पर पहुचो हैं, कि इंसान नेम को कामहुन से अलग ही विस्वास को दुवारा धर्मी ठहरायो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","का परमेस्वर केवल यहूदी हुन को ही का हैं? का गैर यहूदी हुन को परमेस्वर नी हैं? उ पको ही गैर यहूदी हुन को भी परमेस्वर हैं। ");
INSERT INTO hlb_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","काहेकि एक ही परमेस्वर हैं, जे खतना वालो ख भी भरोसा ख व्दारा धर्मी ठहरायो। ");
INSERT INTO hlb_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ते का हम नियम ख विस्वास को व्दारा बेकार ठहरायो हैं? कभी नी! पर नेम को पक्को करिये हैं। ");
INSERT INTO hlb_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","एकोलाने हम ख का कह हैं हमारो सारीरिक बाप अब्राहम ख का मिलो हतो? ");
INSERT INTO hlb_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","यदि अब्राहम अपनो काम हुन से धर्मी ठहरायो गयो हैं, ते ओ ख अपनो पर गर्व करन कि जगह होव, पर परमेस्वर को सामने असो नी कर सक। ");
INSERT INTO hlb_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","काहेकि सुध्द सास्र का बोल हैं? यी कि “अब्राहम न परमेस्वर पर विस्वास करियो, अऊर यी उनका लाने धार्मिकता इंसान गिनो गयो।” ");
INSERT INTO hlb_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","अऊर जब जे काम कर हैं उपहार को रूप म नी बल्कि अधिकार को रूप म दियो जाय हैं। ");
INSERT INTO hlb_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","पर जे काम नी धार्मिकता इंसान काम करन ख बजाए ओ ख परमेस्वर पर विस्वास करनो हैं जे पापी हुन ख भी छोड़ देवा हैं ते ओको विस्वास ही ओको नेक इंसान होन ख कारन बन जाय हैं। ");
INSERT INTO hlb_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","यूईच तरह दाऊद उ अदमी को अच्छो कह हैं, जे ख परमेस्वर बीना काम कियो भी धार्मिकता इंसान ठहरानो हैं: ");
INSERT INTO hlb_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“धन्य हैं उ जीन को अधर्म माप कियो हैं, अर ओको पाप भी ढक दियो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","भलो हैं उ इंसान, जेको पाप ख हिसाब प्रभु नी रख।” ");
INSERT INTO hlb_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","तब का जे को खतना नी हुओ: “अब्राहम अपनो विस्वास को दुवारा उ धार्मिकता इंसान गिनो गयो।” ");
INSERT INTO hlb_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ते उ कसो मानो गयो हैं? का खतना कि दसा म अऊर तब उ खतना म हतो नी बिन खतने कि दसा म? खतना म नी बल्कि खतना म। ");
INSERT INTO hlb_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","अब्राहम लिग खतना करवायो विस्वास को नेक इंसान गिनो गयो ओको ऊपर मुहर को रूप म खतना को चिन्ह लग गयो ऐको का उ उन सब को बाप बनो जे खतना करवायो बिना विस्वास कर हैं जे ख उनको विस्वास को दुवारा उ नेम व्यक्ति मानो जाहे। ");
INSERT INTO hlb_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","अर अब्राहम उन खतना वालो ख भी बाप बना जे नी अकेलो खतना पर निर्भर रह हैं पर हमारो बाप अब्राहम भी ओको विस्वास को रस्ता पर चल हैं जे अब्राहम खनना को पहलो विस्वास करह हतो। ");
INSERT INTO hlb_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","काहेकि परमेस्वर न अब्राहम अर उनको खानदान से वादा करी कि वी दुनिया को उत्तराधिकारी होऐ। यू एकोलाने नी हुयो कि अब्राहम न मूसा को नेम ख पालन कियो, पर एकोलाने कि उनना विस्वास कियो अर परमेस्वर न उन ख न्यायीपन मानो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","अदि मूसा को नेम ख बस रहन वालो ही उत्तराधिकारी बन न हैं, ते विस्वास बेकार हैं अर वादा खत्म हो जाय हैं। ");
INSERT INTO hlb_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","नेम ते घुस्सा पैदा कर हैं, अर जहाँ नेम नी वहाँ ओको माननवालो भी नी हैं। ");
INSERT INTO hlb_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","अऊर सब कुछ विस्वास पर अर दया म निर्भर रह हैं, उ वादा पर नी केवल वी लोग हुन पर जे नेम ख मान हैं पर समस्य पर लागु होवा हैं अर उन सभी को ऊपर जे दया नेक जसो विस्वास करनो हैं अब्राहम हम सबको बाप हैं। ");
INSERT INTO hlb_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","जसो कि लिखो हैं, “मी न तुम क बेजा सी जाति हुन को बाप नियुक्त कियो हैं।” परमेस्वर कि देखन म अब्राहम हमारो बाप हैं। ओ ख परमेस्वर म विस्वास कियो, जे मुर्दा हुन म फिर से जिन्दो कर हैं अर उन वस्तु हुन ख अस्तित्व म लाय हैं मानो वी हैं; ");
INSERT INTO hlb_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","अब्राहम से कय्हो गयो हतो कि सभी आसा हुन ख खिलाफ अब्राहम विस्वास कर रयो एकोलाने कोई सब जात हुन को बाप बनो जसो कि ओको कय्हो गयो हतो कि तुमारो असंख्य खानदान होऐ। ");
INSERT INTO hlb_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","उ जो एक सऊ साल को हतो, अपनो मरो सो सरीर अर सारा की कोक की मरी सी दसा जान ख भी विस्वास म कमजोर नी भयो, ");
INSERT INTO hlb_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","अऊर नी अविस्वास होयख परमेस्वर को वादा पर सक नी भयो, पर विस्वास म मजबूत हो ख परमेस्वर कि बड़ाई करी; ");
INSERT INTO hlb_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","उन ख पक्को निस्चय हतो कि परमेस्वर न जिस बात कि वादा करी हैं, उ ओ ख पूरो करनो म भी समर्थ हैं। ");
INSERT INTO hlb_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","यूईच कारन यू परमेस्वर न ओ ख धार्मिकता इंसान मानो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","अऊर यू लाने हो गयो हतो, यू सब्द अकेलो उनको लाने नी लिखो गयो हतो। ");
INSERT INTO hlb_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","पर हमारो लाने भी जिनको लाने विस्वास न्यायीपन गिनो जाहे, अर्थात हमारो लाने जो उ पर विस्वास करत हैं जिनना हमारो प्रभु यीसु को पर अपनो लाने भी लिखो हैं हम ख मरे हुओ म से जिन्दो कियो। ");
INSERT INTO hlb_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","उ हमारो अपराध हुन को लाने पकड़ायो गयो, अर हमारा न्याय करन ख लाने जीवित उठो। ");
INSERT INTO hlb_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","पर जब हम विस्वास से धर्मी ठहरे, ते हम अपनो प्रभु यीसु मसी ख माध्यम से सान्ति हैं परमेस्वर का संग मेल रख हैं। ");
INSERT INTO hlb_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","जेको माध्यम से हम न विस्वास को माध्यम से, ओ ख दया न पहुँच प्रान करी हैं ऐ म हम अब खड़ो हैं अर हम परमेस्वर कि महिमा की आसा म गर्व कर हैं। ");
INSERT INTO hlb_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","इत्तो ही नी हम संकट अर मुसीबत म भी गर्व करे काहेकि जान हैं कि संकट मुसीबत म धीरज पैदा होवा हैं। ");
INSERT INTO hlb_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","अर धीरज से खरो चरिस्र निकलो, अर खरा चरिस्र से आसा पैदा होवा हैं; ");
INSERT INTO hlb_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","अर आसा से लज्जा नी होव हैं, काहेकि परमेस्वर न हम ख सुध्द आत्मा दियो हैं, अर ओको लाने परमेस्वर को प्रेम हमारो मन म उडेलो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","काहेकि तब हम कमजोर हुन ही हता, ते मसी अच्छी बखत पर भक्तिहीन का लाने मरो। ");
INSERT INTO hlb_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","कुई भी न्यायीपन व्यक्ति का लाने कुई मरे, यी ते दुर्लभ हैं; पर हो सक हैं कुई अच्छो अदमी का लाने कुई मरनो को भी हिम्मत करिये। ");
INSERT INTO hlb_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","पर परमेस्वर न हम पर अपनो प्रेम कि भलाई यी रीति से प्रगट करिये हैं कि पर जब हम पापी ही हता जब यीसु मसी हमारो लाने मरो असो कर ख परमेस्वर अपनो प्रेम प्ररगट कियो। ");
INSERT INTO hlb_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","पर जब कि हम अब ओखा खून का कारन धार्मिक रहयो, ते ओखा व्दारा परमेस्वर को घुस्सा से काहे नी बचे हे? ");
INSERT INTO hlb_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","हम दुसमन ही हतो, जब परमेस्वर को संग हमारो मिलनो ओको पोरिया कि माऊत मो माध्यम हो गयो हतो; अर परमेस्वर को संग मेल हो जान को बाद ओको पोरिया ख जिन्दगी माध्यम निस्चय ही हमारो उध्दार होऐ? ");
INSERT INTO hlb_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","अऊर इत्तो ही नी, अब ते हमारो प्रभु यीसु मसी को अर से परमेस्वर से हमारो मेल हो गयो एकोलाने हम ओ से परमेस्वर पर विस्वास रख ख गर्व करह हैं। ");
INSERT INTO hlb_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","एकोलाने जसो एक अदमी ख व्दारा पाप दुनिया म आयो, अर पाप को व्दारा माऊत आयो, अर यी तरीका से माऊत भी सब अदमी हुन म फैल गई, काहेकि सब न पाप कियो। ");
INSERT INTO hlb_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","नियम को दियो जानू तक पाप दुनिया म ते हतो, पर जहाँ नेम नी वहाँ पाप गिनो नी जाव। ");
INSERT INTO hlb_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","अऊर तेबी आदम से मूसा तक माऊत उन लोग हुन पर भी राज कर हतो, जे न उ आदम को, जसो कोई कहना ख नी मान हतो अर्थात पाप नी कियो आदम उ इंसान को रूप आय जे आन वालो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","पर अपराध वरदान को जसो नी, एक इंसान को अपराध को करन अनको कि माऊत हुई परमेस्वर को अनुग्रह सच्चो एक इंसान मसी यीसु को दया हम दियो हुओ वरदान अनेक हुन म स्थापित होगा। ");
INSERT INTO hlb_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","जसो एक इंसान पाप अर परमेस्वर ख छुटकारे को वरदान कि तुलना नी हैं एक को पाप को कारन से सजा कि कहना ही दियो गयो पर पाप, को बाद छुटकारा को वरदान दियो गयो जे से न्याय मिले गयो। ");
INSERT INTO hlb_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","काहेकि जब एक व्यक्ति को अपराध ख करन एक ही इंसान को माध्दयम राज को सासन होऐ, ते ऐ से कही जादा फैलो हुओ किरपा अर धर्म को उ वरदान जे उनको जीवन म ओ पर एक इंसान यीसु मसी को माध्यम सासन करे। ");
INSERT INTO hlb_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","एकोलाने जसो एक अपराध सब अदमी हुन का लाने सजा कि आग्या को कारन भयो, वसो ही एक धर्म को काम भी सब अदमी हुन को लाने जिन्दगी को पाप मुक्ति न्याय अर जीवन मिलो। ");
INSERT INTO hlb_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","काहेकि जसो एक व्यक्ति ख आग्या न मानना से बेजा व्यक्ति पापी ठहरगो, वसो ही एक व्यक्ति को आग्या मानन से बेजा व्यक्ति हुन धर्मी ठहरे। ");
INSERT INTO hlb_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","नेम बीच म आ गई कि पाप बेजा हो गयो, पर जहाँ अपराध बेजा भयो वहाँ दया ओ ख भी कही बेजा भयो ");
INSERT INTO hlb_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","यूईच प्रकार पाप माऊत को माध्यम से, राज कर रयो; पर हमारो प्रभु यीसु मसी दुवारा दया, धर्म को माध्यम से अपनो राज्य स्थापित करे अर हम अनन्त जिन्दगी म ले जाहे। ");
INSERT INTO hlb_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ते हम का कह हैं? का हम पाप करह रह कि परमेस्वर को दया अपनो पर होनो हैं? ");
INSERT INTO hlb_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","असो नी हैं! हम जब पाप का लाने मर गयो ते फिर सामने ख ओ म कसो जिन्दगी बितायो? ");
INSERT INTO hlb_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","का तुम लोग यू नी जान कि यीसु मसी को जे बपतिस्मा हम सब को मिलो हैं, उ उनकी माऊत को बपतिस्मा हैं। ");
INSERT INTO hlb_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","अऊर हम उनकी माऊत को बपतिस्मा मान ख उनका संग एकोलाने दफनायो गयो हैं कि जिस तरीका मसी बाप को महिमा मय सक्ति से माऊत हुन म से जिन्दो उठो हैं, ऊईच तरीका हम भी एक नयो जिन्दगी जीहे। ");
INSERT INTO hlb_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","अदि हम यू ईच प्रकार मसी को जसो मर ख उनको संग एक हो गयो हैं, ते हम उन्ही को जसो जिन्दो होनू म भी उनको संग एक होऐ। ");
INSERT INTO hlb_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","हम जाना हैं कि हमारो पुरानो अदमी हुन ओकी संग सुली पर चढायो गयो काहे पाप को सरीर बेकार हो जाहे, अर हम आगे से पाप को दास नी रहे। ");
INSERT INTO hlb_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","काहेकि जो मर चुको हैं, उ पाप कि गुलामी से मुक्ति हो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","अऊर हम विस्वास हैं कि अदि हम मसी को संग मर गया हैं, ते हम उन्ही को जिन्दगी को भी भागी होऐ। ");
INSERT INTO hlb_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","काहेकि यी जाना हैं कि मसी मर हुओ म जिन्दो उठ ख फिर मरन ख नी; ओ पर फिर माऊत कि प्रभुता नी होन की। ");
INSERT INTO hlb_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","अऊर जब उ मर, ते पाप कि ओर से एक बार ही मर गयो; पर अब उ जीवित हो ख परमेस्वर ख लाने ही जीव हैं। ");
INSERT INTO hlb_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","असो ही तुम भी अपनो खुद ख पाप का लाने ते मरो, पर परमेस्वर का लाने मसी यीसु म जिन्दो समझ। ");
INSERT INTO hlb_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","एकोलाने पाप तुमारो नस्वर सरीर म राज नी करे, काहे कि तुम ओकी लालसा हुन ख बस म रहे; ");
INSERT INTO hlb_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","अर नी अपनो आग हुन ख अधर्म का हथियार होन का लाने पाप ख दियो, पर अपनो तुम ख मरो भयो म से जिन्दो हुयो जाना क परमेस्वर ख दियो, अर अपनो सरीर हुन ख धर्म ख हथियार होन का लाने परमेस्वर ख दियो। ");
INSERT INTO hlb_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","अऊर तुम लोग हुन पर को पाप कोई अधिकार नी रहे। अब तुम मूसा को नेम को नी, बल्कि किरपा को बस हैं। ");
INSERT INTO hlb_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ते का हम एकोलाने पाप कर कि हम मूसा कि नेम को नी, पर किरपा को बस हैं? कभी नी! ");
INSERT INTO hlb_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","का तुम यू नी समझ कि तुम अपनो ख कहना ख मान वाला दास को जसो म जे को प्रति अरपित कर हैं अर जेकी बात ख पालन कर हैं, खुद ही ओको दास बन जाय हैं? यू गुलामी चाहे पाप कि हो, जेको परिनाम माऊत हैं चाहे परमेस्वर कि हो, जे को बात ख पालन को परिनाम धर्म हैं। ");
INSERT INTO hlb_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","पर परमेस्वर को धन्यवाद हैं कि तुम जो पाप ख दास हतो अब मन से ओ ख सिखान ख मान वाला हो गयो, जेका रूप म ढाले गयो हतो, ");
INSERT INTO hlb_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","अर तुम पाप से मुक्ति हो ख धर्म को दास बन गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","मी तुमरी सरीर की कमजोरी को वजेसे इंसान हुन की परंपरा को हिसाब से कहूँ हैं। जसा तुमना सरीर हुन ख बुरो काम को लाने असुध्द अर बुरो काम का दास होन को लाने सोपयो रा, वसा ही अब अपना सरीर ख सुध्द होन को लाने धर्म को दास कर ख सोप देव। ");
INSERT INTO hlb_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","तब तुम पाप का दास हतो, ते धर्मी कि तरफ से आजाद हतो। ");
INSERT INTO hlb_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","अब जीन बात हुन से अब तुम लज्जित होव हैं, ओ से उ बखत तुम का फल पायो हतो? काहेकि उन ख आखरी ते मरनू हैं। ");
INSERT INTO hlb_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","पर अब पाप से आजाद हो ख अर परमेस्वर को दास बन ख तुम ख फल मिलो जेसे सुध्द हुन मिल होव हैं, अर ओको अन्त आखरी जिन्दगी हैं। ");
INSERT INTO hlb_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","काहेकि पाप कि मजदूरी ते माऊत हैं, पर परमेस्वर को वरदान हमारो प्रभु मसी यीसु म आखरी जिन्दगी हैं। ");
INSERT INTO hlb_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","अरे भई हुन, का तुम नी जाना हैं कि म नेम का जानावालो से कहूँ हैं कि जब तक अदमी जिन्दो रयो हैं, तब तक ओ पर नेम कि दया रय्हे हैं? ");
INSERT INTO hlb_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","सादी तब तक अपनो बंधन नियम से बनी रवह हैं जब तक उ जीवित यदि मर जाय हैं ते उ अपनो पति को नेम से छुट गई। ");
INSERT INTO hlb_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","एकोलाने अगर घर वालो को जीतो जी उ कुई दूसरो अदमी ख हो जाए, ते छिनालापन बोले, पर अगर घर वालो मर जाहे, ते उ नेम से छुट गई यहाँ तक कि अगर कुई दूसरो अदमी कि हो जाहे तब भी छिनालापन नी रहे। ");
INSERT INTO hlb_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","वसो ही अरे मोरो भई हुन, तुम भी मसी को सरीर को दुवारा नेम हुन ख लाने मरे हुयो बन गयो, कि उ दूसरो को हो जा, जो मरे हुयो म से जिन्दो भयो: काहेकि हम परमेस्वर का लाने फल लाएँ हे। ");
INSERT INTO hlb_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","काहे कि जब हम सारीरिक हतो, ते पाप हुन कि लालचपन से जो नेम हुन ख व्दारा हतो, मरन का फल पैदा करन का लाने हमारो जिन्दगी म काम करत हता। ");
INSERT INTO hlb_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","पर जे ख बन्धन म हता ओखा लाने मर ख अब नेम हुन से असो छुट गयो, कि लेख कि पुरानी रीति पर सेवा नी, पर आत्मा कि नई रीति पर सेवा कर हैं। ");
INSERT INTO hlb_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ते हम का कह हैं? का नेम पाप हैं? असो नी हैं! पर बिना नेम को म पाप ख नी चीन्न पर नेम अगर नी कह हैं, कि लोभ नी कर ते म लोभ ख नी जाना। ");
INSERT INTO hlb_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","पर पाप नी मऊका देख ख आदेस को व्दारा मोखा म सब तरीका को लोभ उत्पन्न कियो, काहेकि बिना नेम पाप मुर्दा हैं। ");
INSERT INTO hlb_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","म ते नेम बिना पहले जीवित हतो, पर अब आदेस आई, ते पाप जिन्दो हो गयो, अर म मर गयो। ");
INSERT INTO hlb_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","अर उही आदेस जो जिन्दगी ख लाने हतो, मोरो लाने मरन ख लाने रयो। ");
INSERT INTO hlb_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","काहेकि पाप हुन न देख ख आदेस को व्दारा मोखा बहकायो दियो, अर ओको व्दारा मोखा मार भी डालो। ");
INSERT INTO hlb_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","एकोलाने नेम सुध्द हैं, अर आदेस भी उचित अर अच्छो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ते का उ ते अच्छो हतो, मोरो लाने मरनू रयो? असो नी! पर पाप ओकी अच्छी चीज ख व्दारा मोरो लाने माऊत ख पैदा करनवालो भयो कि ओको पाप होन दिखनू हो, अर आदेस को व्दारा पाप ही पाप मय रहे! ");
INSERT INTO hlb_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","हम जाना हैं कि नेम ते आत्मिक हैं, पर म सारीरिक अर पाप ख हात बिक हुयो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","जो म करूँ हैं ओ ख नी जाना: काहेकि जो म चाहूँ हैं नी कियो करूँ पर जेसे मोखा गुस्सा आय हैं उ करूँ हैं। ");
INSERT INTO hlb_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","पर जो म नी चाहूँ हैं कि ऊईच करूँ हैं ते म मान लियो हैं कि नेम अच्छो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ते असो मजबुरी म ओकी करन वालो म नी, पर पाप हैं जो मोखा म बठो भयो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","काहेकि मी जानू हैं कि मोखा म असो कि मोरो सरीर म कुई अच्छी चीज भीतर नी करिये। इच्छा ते मोखा म हैं, पर अच्छो काम मोखा से बन नी पड़ आय। ");
INSERT INTO hlb_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","काहेकि जसो अच्छो काम कि मी इच्छा करूँ हैं उ ते नी करूँ हैं, पर जे ख बुराई कि इच्छा नी कर हैं उही कियो करूँ हैं। ");
INSERT INTO hlb_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","अब अदि म उही करूँ हैं जेको इच्छा नी करूँ हैं, ते ओको करनवालो म नी रय्हो, पर पाप जो मोखा म बठो भेयो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","यी तरीका म यी नेम पायो हैं कि अब दया करन कि अच्छो करा हैं, ते बुराई मोरो नजीक आव हैं। ");
INSERT INTO hlb_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","काहेकि मी अंदर अदमीत्व से ते परमेस्वर कि नेम से बेजा खूसी रह हैं। ");
INSERT INTO hlb_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","पर मोखा अपनी आग हुन म दूसरो तरीका को नेम दिखई पड़ह हैं, जे मोरो समझ को नेम से लड़ह हैं अर मोखा पाप को नेम ख बन्धन म डालो हैं जो मोरो आग हुन म हैं। ");
INSERT INTO hlb_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","मी कसो अभागो अदमी हूँ! मोखा यी मरन का सरीर से कोन छुड़ा हे? ");
INSERT INTO hlb_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","हमारो प्रभु यीसु मसी को व्दारा परमेस्वर को धन्यवाद हो। एकोलाने म स्वंय दिमाक से ते परमेस्वर को नेम ख, पर सरीर से पाप कि नेम को सेवा करूँ हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","पर अब जो मसी यीसु म हैं, ओ पर सजा कि आग्या नी हैं। काहेकि वी सरीर ख अनुसार नी पर आत्मा का अनुसार चल हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","काहेकि जिन्दगी कि आत्मा को नेम नी मसी यीसु म मोखा पाप कि अर मरन कि नेम से आजाद कर दियो। ");
INSERT INTO hlb_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","काहेकि जो काम नेम से सरीर का लाने कमजोर होकर नी कर सक, ओ ख परमेस्वर नी कियो, असो कि अपनो ही पोरिया ख पाप मय को जिन्दगी ख समान म अर पापबलि होन का लाने भेज ख, जिन्दगी म पाप पर सजा कि आग्या दियो। ");
INSERT INTO hlb_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","एकोलाने कि नेम कि रीति हम म जो सरीर ख अनुसार नी पर आत्मा ख अनुसार चल हैं, पुरी कि जाहे। ");
INSERT INTO hlb_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","काहेकि सारीरिक अदमी सरीर कि बात हुन पर मन लगयो हैं; पर आध्यात्मिक आत्मा ख बात हुन पर मन लगाव हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","सरीर पर मन लगानो ते माऊत हैं, पर आत्मा पर मन लगानो जिन्दगी अर सान्ति हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","काहेकि सरीर पर मन लगानो ते परमेस्वर से बुराई रखनो हैं, काहेकि नी ते परमेस्वर कि नेम ख बस म हैं अर नी हो सक हैं; ");
INSERT INTO hlb_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","अर जे सारीरिक मजबूरी म हैं, वी परमेस्वर ख खुसी नी कर सक हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","पर जब कि परमेस्वर को आत्मा तुम म बसो हैं, ते तुम सारीरिक मजबूरी म नी पर आत्मिक मजबूरी म होव। अदि कोई म मसी को आत्मा नी ते उ ओ ख जान नी। ");
INSERT INTO hlb_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","अदि मसी तुम म हैं, ते सरीर पाप ख लाने मरी भई हैं; पर आत्मा धर्मी का लाने जिन्दो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","अदि ओको आत्मा जे न यीसु ख मरो भेयो म से जिन्दो कियो हैं, तुम म बसो भेयो हैं; ते जे न मसी ख मरो भेयो म से जिन्दो, उ तुमारो नासवन सरीर हुन ख भी अपनो आत्मा को व्दारा जो तुम म बसो हुयो हैं, जिन्दो। ");
INSERT INTO hlb_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","एकोलाने अरे भई हुन, हम ख जिन्दगी को कर्जदार नी कि सरीर ख समान दिन गुजारे, ");
INSERT INTO hlb_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","काहेकि अगर तुम सरीर ख समान दिन काटे ते मरे, अदि आत्मा से सरीर कि क्रिया हुन ख मारे ते जिन्दो रहे। ");
INSERT INTO hlb_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","जे व्यक्ति परमेस्वर को आत्मा ख चलायो चल हैं, उ ही परमेस्वर को पोरिया हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","काहेकि तुम ख गुलामी कि आत्मा नी मिली कि ते बिना डर पर कि आत्मा मिली हैं, जेसे हम अरे अब्बा, अरे बाप कह पुकार हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","आत्मा खुद ही हमारो आत्मा ख संग गवाही देव हैं, कि हम परमेस्वर कि पोरिया हैं; ");
INSERT INTO hlb_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","अर अगर सन्तान हैं ते वारिस भी हैं, पर परमेस्वर कि वारिस अर मसी ख सगो वारिस हैं, कि जब हम ओखा संग दुख उठाएयो ते ओखा संग महिमा भी पाहे। ");
INSERT INTO hlb_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","काहेकि म समझू हैं कि यी बखत को दुख अर संकट उ महिमा को जसो, जो हम पर प्ररगट होनवाली हैं, कई भी नी हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","काहेकि धरती बड़ी आसा भरी आँख से परमेस्वर को पोरिया हुन ख प्रगट होन का रस्ता देख रही हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","काहेकि धरती अपनी मन से नी पर बस करनवालो कि तरीफ से, बेकार ख अधीन यी आसा से कि गई ");
INSERT INTO hlb_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","कि धरती भी खुद ही विनास को गुलमी से मुक्ति पा ख, परमेस्वर कि अवलाद हुन कि महिमा कि आजादी मिल करिये। ");
INSERT INTO hlb_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","काहेकि हम जान हैं कि सारी धरती अब तक मिल ख कराह अर परेसानी हुन म पड़ी तड़प हैं; ");
INSERT INTO hlb_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","अर अकेलो उ नी पर हम भी जेका नजदीक आत्मा को पहलो फल हैं, खुद ही अपनो म कराह हैं; अर लेपालक होन की, असो कि अपनो सरीर ख छुटकारा की रस्ता देख हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","यू आसा ख व्दारा हमारो उध्दार भयो हैं; पर जी चीज की आग्या कि जाय हैं, जब उ देखन म आयो ते फिर आसा कह रयो? काहेकि जे चीज ख कुई देख रयो हैं ओकी आसा का करे? ");
INSERT INTO hlb_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","पर जे चीज ख हम नी देखो, अदि ओकी आसा रख हैं, ते धीरे से ओकी रस्ता देख भी हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","यू रीति से आत्मा भी हमारो कमजोर म मदद करूँ हैं: काहेकि हम न जाना हैं कि विनती कसो रीति से करूँ चाहिए, पर आत्मा खुद ही असो आह भर ख जो बियाना से बाहर हैं, हमारो लाने प्रार्थना करूँ हैं; ");
INSERT INTO hlb_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","परमेस्वर हमारो मन ख परख अर ओ ख पता हैं कि हमारो आत्मा विचार हैं। काहेकि आत्मा अपनो सुध्द लोग हुन ख ओर से अर अपनी इच्छा को अनुसार परमेस्वर से प्रर्थना कर हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","हम ख मालूम हैं कि जे व्यक्ति परमेस्वर से प्रेम कर हैं, उनको लाने सब बात हुन मिल ख भलाई ही ख पैदा कर हैं; पर उन को लाने जे ओकी मर्जी को समान बुलायो हुयो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","काहेकि जीन न परमेस्वर ख पहले ही से चुनो कि हैं उन ख पहले ही से अपनो पोरिया को जसो ठहरायो भी हैं कि ओको पोरिया सरूप म होय। ");
INSERT INTO hlb_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","फिर जीन ओ न पहले से ठहरायो, उन ख बुलायो भी: जीन ख बुलायो, जीन धर्मी भी ठहरायो, हैं: अर धर्मी ठहरायो, उन ख बड़ाई भी दियो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","अब इन बात हुन ख देखते हुए हम का कह सक हैं अगर परमेस्वर हमारी ओर हैं अर हमारो विरोध कऊन कर सक हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","परमेस्वर न अपनो निजी पोरिया ख भी नी छोड़ ओ न हम सब ख लाने ओ ख समपित कर दियो ते इत्तो देन को बाद का उ मुक्ति म नी देहे? ");
INSERT INTO hlb_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","परमेस्वर को चुनो भयो पर दोस कोन लगाएगो? परमेस्वर ही न्यायी ही ठहरान वालो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","फिर कऊन हैं जो हम ख सजा को आग्या देहे? यीसु मसी ही हैं। जो मर गयो अर मुर्दो म से जिन्दो भी भयो हैं, अर परमेस्वर को दाहिनी ओर हैं, अर हमारा लाने निवदेन करह हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","कोन हम ख मसी को प्रेम से अलग करे? का दुख, का सकंट, का उपद्रव, का अकाल, का नांगई का जोखिम, का तलवार? ");
INSERT INTO hlb_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","जसो लिखो हैं, “तोरो लाने हम दिन भर मर कियो जाव हैं; हम वध होनवाली भेड़ी हुन ख समान गिनो गयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","पर इन सब बात हुन म हम ओखा व्दारा जेन हम से प्रेम कियो हैं, जयवन्त से भी बढ़ ख हैं। ");
INSERT INTO hlb_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","काहेकि म पक्का म जान हैं कि नी माऊत, नी जिन्दगी, नी स्वर्गदूत, नी अधिकारी हुन, नी अभी को, नी भविस्य, नी सक्ति, नी ऊँचाई, ");
INSERT INTO hlb_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","नी गहराई अर नी कोई अर धरती हम ख परमेस्वर को प्रेम से जे हमारो प्रभु मसी यीसु म हैं दूर कर सके। ");
INSERT INTO hlb_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","मी मसी म सच कहूँ हैं, मी झूठ नी कह रयो मोरो विवेक भी सुध्द आत्मा मी गवाही दे हे। ");
INSERT INTO hlb_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","कि मोखा बड़ो दुख हैं, अर मोरो मन सदा दु: ख रह हैं, ");
INSERT INTO hlb_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","काहेकि मी यहाँ तक चाह रयो, कि अपनो भई हुन ख लाने जे सरीर ख भाव से मोरो कुटुम हैं, खुद ही मसी से बद्दुवा हो जाव हैं। ");
INSERT INTO hlb_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","वी इस्राएली हैं, अर लेपालकपन को हक अर महिमा, अर वादा हुन, अर नेम हुन अर उपासना, अर वादा हुन उन्ही की आय। ");
INSERT INTO hlb_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","सियना हुन भी उन को हैं, अर मसी भी सरीर को भाव से उन म से भयो। जे सब का ऊपर परम परमेस्वर हमेसा धन्य हैं। आमीन। ");
INSERT INTO hlb_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","पर यी नी कि परमेस्वर को सब्द मिट गयो, एकोलाने कि जे इस्राएल को खानदान आय, वी सब इस्रएली नी आय; ");
INSERT INTO hlb_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","अर नी अब्राहम को खानदान होन का कारन सब ओकी पोरिया रहे, पर लिखो भी हैं “इसहाक ही से तोरो खानदान कहलाएगो।” ");
INSERT INTO hlb_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","असो कि सरीर ख पोरिया परमेस्वर को पोरिया नी, पर वादा को पोरिया खानदान गिनो जाहे हैं। ");
INSERT INTO hlb_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","काहेकि वादा को वचन यू आय: “मी यू बखत को समान आऊगो, अर सारा को पोरिया होए।” ");
INSERT INTO hlb_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","अर अकेलो यी नी, पर जब रिबका भी एक से पर हमारो बाप इसहाक से पेट हती, ");
INSERT INTO hlb_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","अर अभी तक नी ते; पोरिया पैदा हतो, अर नी उनना कई अच्छो अर बुरो करियो हतो, एकोलाने कि परमेस्वर कि मनसा जे ओको चुन लेन ख समान हैं, कर्मी को कारन नी, पर बुलान वाला ख कारन हैं, बनी रहे: ");
INSERT INTO hlb_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ओ न बोल्यो कि, “बड़ो छोटो को दास होगो।” ");
INSERT INTO hlb_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","जसो लिखो हैं, “मी न याकूब से प्रेम कियो, पर एसाव ख चोक्खो नी जानो।” ");
INSERT INTO hlb_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","एकोलाने हम ख का कह हैं? का परमेस्वर को यी अधर्म हैं? असो नी! ");
INSERT INTO hlb_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","काहेकि उ मूसा से कह हैं, “मी जे कुई पर तरस करनो चाहूँ ओ पर तरस करूँगो, अर जीन कई पर दया करनो चाहूँ ओ दया करूँगो।” ");
INSERT INTO hlb_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","अब यी नी ते चाहन वालो कि, नी दऊड वाला कि पर दया करन वालो परमेस्वर कि बात हैं। ");
INSERT INTO hlb_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","काहेकि सुध्द सास्र म फिरोन से कय्हो गयो हैं, “मी न तोखा यी लाने खड़ो कियो हैं कि तोखा म अपनो सक्ति दिखाऊ अर मोरो नाम ख प्रचार सारी धरती पर होए।” ");
INSERT INTO hlb_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","एकोलाने उ जे पर चाहे हैं ओ पर दया करे हैं, अर जे ख चाहूँ हैं ओ ख मजबूत कर दे हैं। ");
INSERT INTO hlb_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","अब तू मोखा कहे, “उ फिर काहे दोस लगाव हैं? कऊन ओकी इच्छा को सामने करा हैं?” ");
INSERT INTO hlb_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","अरे अदमी, भलो तू कऊन हैं जे परमेस्वर को सामने करा हैं? का गढ़ी हुई चीज गढ़न वालो से बोल सक हैं, “तू न मो ख असो काहे बनायो हैं?” ");
INSERT INTO hlb_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","का कुमार ख मिठ्टी को अधिकार नी हैं कि एक ही लोद म से एक बर्तन लज्जित का लाने, अर दुसरो ख लज्जित का लाने बनायो हैं? ");
INSERT INTO hlb_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ते एम कोन सी गजब कि बात हैं कि परमेस्वर न अपनो गुस्सा दिखान अर अपनो साक्ति प्रगट करन कि इच्छा से गुस्सा का बर्तन हुन कि जे नास का लाने तैयार कियो हतो, बड़ो धीरज से सही हैं; ");
INSERT INTO hlb_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","अर दया को बर्तन पर, जीन ओ न बड़ाई को लाने पहले से तैयार करियो, अपनो बड़ाई ख धन ख दिखा कि इच्छा करी हैं? ");
INSERT INTO hlb_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","असो हम पर जीन ओ न न अकेलो यहूदी हुन म से, पर गैर यहूदी हुन म से भी बुलायो। ");
INSERT INTO hlb_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","जसो उ होसे कि पुस्तक म भी कय्हे हैं, “जो मोरी प्रजा नी हती, उन ख मी अपनो प्रजा कहेगो; अर जे नी हती, ओ ख प्रेम कहेगो। ");
INSERT INTO hlb_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","अर असो होगो कि जी जगह म ओ न यी कय्हो गयो हतो कि तुम मोरी प्रजा नी होए, उ जगह वी जीवित परमेस्वर कि खानदान कहलाएगो।” ");
INSERT INTO hlb_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","अर यसायाह इस्राएल को बारा म पुकार ख कय्हो हैं, “चाय्हे इस्राएल कि खानदान हुन कि गिनती समुंदर कि रेता का बराबर हैं, तेभी उन म से थोड़ो ही बचे हे। ");
INSERT INTO hlb_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","काहेकि प्रभु अपनो वचन धरती पर पूरो करे, धार्मिक हुन से जल्दी ओ ख सिध्द करेगों।” ");
INSERT INTO hlb_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","जसो यसायाह न पहले भी कय्हो हतो, “पर सेना हुन को प्रभु हमारो लाने कई अवलाद नी छोड़त, ते हम सदोम ख समान हो जात, अर अमोरा ख जसा ठहराता।” ");
INSERT INTO hlb_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","अब हम का कह हैं? यी कि गैर यहूदी हुन न जो धार्मिक कि खोज नी कर हती, धार्मिक हुन मिलो कि पर उ धर्म ख जो विस्वास से हैं; ");
INSERT INTO hlb_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","पर इस्राएली, जे धर्मी को नेम कि खोज करिय हता उ नेम तक नी पहुचे। ");
INSERT INTO hlb_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","असो काहे भेयो? काहे इस्राएली विस्वास पर नी पर नी, कर्मो से ओकी खोज कर हता। उन न ओ ख ठोकर को पत्थर पर ठोकर खाई, ");
INSERT INTO hlb_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","जसो लिखो हैं, देख, मी सिय्योन मी एक ठोकर लगन ख पत्थर, अर ठेस खान कि पहाड़ रखू हैं, अर जे ओ पर विस्वास करे उ लज्जित नी होए। ");
INSERT INTO hlb_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","अरे भई हुन, मोरो मन कि लोभ अर उनका लाने परमेस्वर से मोरी विनती हैं कि वी उध्दार पाहे। ");
INSERT INTO hlb_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","काहेकि मी गवाही देऊ हैं कि ऐको परमेस्वर का लाने धुन रवह हैं, पर समझदार का संग नी। ");
INSERT INTO hlb_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","काहेकि वी परमेस्वर का धर्म से अनजान हो ख अर अपनो धर्म स्थापित करन कि कोसिस कर ख, परमेस्वर को न्यीय हुन को अधीन नी भयो। ");
INSERT INTO hlb_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","काहेकि मसी नेम ख परिपूर्णता पहुँच हैं, अर हर एक विस्वास करन वालो ख धर्म प्रदान कर हैं। ");
INSERT INTO hlb_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","काहेकि मूसा न यी लिखो हैं कि जे अदमी उ धार्मिक हुन पर जो नेम से हैं, चल हैं, उ ओ से जिन्दो रहेगो। ");
INSERT INTO hlb_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","पर जे विस्वास को दुवारा धर्म हैं उन ख लाने असो लिखो हैं कि तुम अपनो मन असो विचार मन कर कि स्वर्ग म ऊपर कऊन चढ़े। अऊर मसी ख नीच लान ख लाने। ");
INSERT INTO hlb_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","अथाह कुण्ड या “अधोलोक म निच कऊन जाहे?” का मसी ख मरे हुयो म से हैं ऊपर लान को लाने! ");
INSERT INTO hlb_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","परन्तु यू सच्चो सास्र का कह हैं “यू कि वचन तोरो नजीक हैं, अर उ तोरो मुँह म अर तोरो मन म यू ईच विस्वास को वचन आय जे हम प्रचार करन हैं,” यू विस्वास को वचन हैं जेको हम प्रचार कर हैं, ");
INSERT INTO hlb_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","कि पर तू अपनो मुँह से यीसु ख प्रभु जाना ख अंगीकार करिये, अर अपनो मन से विस्वास कर कि परमेस्वर न ओ ख मरे भेयो मी से जिन्दो कियो, ते तू जरूर उध्दार पाएगो। ");
INSERT INTO hlb_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","काहेकि धार्मिक का लाने मन से विस्वास करन से अच्छो इंसान ठहरयो हैं, अर मुँह से स्वीकार करन से ओ ख उध्दार मिल हैं। ");
INSERT INTO hlb_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","काहेकि सुध्द सास्र यू कह हैं, “कि जे कोई ओ पर विस्वास करेगों उ लज्जित नी होगो।” ");
INSERT INTO hlb_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","अब यहूदी हुन अर यूनानी हुन न कई पक्छ पात नी हैं एकोलाने उ सब को प्रभु आय अर अपनो सब नाम लेन वालो का लाने उध्दार मिल हे। ");
INSERT INTO hlb_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","काहेकि, “जे कोई प्रभु को नाम लेहे या लेन ख होए, उ उध्दार पाएगो।” ");
INSERT INTO hlb_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","जे पर उन न पर विस्वास नी कियो, वी ओको नाम कसो लेहे? अर जेको बारा म सुन्यो नी उ पर कसो विस्वास करिये? अर प्रचारक हुन का बिन कसो सुने? ");
INSERT INTO hlb_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","अर अगर भेजो नी जाहे, ते कसो प्रचार करे? जसो लिखो हैं, “उन का पाय का ही सुन्दर आय, जे भली बात हुन का सुसमाचार लाने हैं।” ");
INSERT INTO hlb_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","पर सब हुन न उ सुसमाचार पर कान नी लगायो: जोतिस यसायाह कह हैं, “अरे प्रभु, कऊन न हमारो अच्छो समाचार पर विस्वास रख हैं?” ");
INSERT INTO hlb_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","एकोलाने विस्वास सुनना से, अर सुन्ना से मसी को वचन से होए हैं। ");
INSERT INTO hlb_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","पर म कहूँ हैं कि उनना नी सुनो? सुन ते जरुरी हैं; काहेकि लिखो हैं, “उनको आवाज पूरो धरती म, अर उनको वचन दुनिया कि कोना तक पहुँच गयो हैं।” ");
INSERT INTO hlb_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","मी फिर कहूँ हैं, का इस्राएली लोग हुन ख मालूम ही नी हता? पहले ते मूसा कह हैं, “मी उन ख व्दारा जे जाति नी हैं, तुमारो मन म जलन उपजाऊँगो; मी एक मुर्ख जात को व्दारा तुम ख घुस्सा दिलाऊँगो।” ");
INSERT INTO hlb_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","फिर यसायाह बड़ो हिम्मत को संग कहूँ हैं, “जे मोखा नी ढ़ूँढत हता, उन न मोखा पा लियो अर जे मोखा पूछत भी नी हता, उन पर मी प्रगट होए गयो।” ");
INSERT INTO hlb_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","पर इस्राएल को बारा म उ असो कह हैं, “मी बखत को दिन अपनो हात एक हुकुम नी पालन करनवालो अर झगड़ा करनवालो प्रजा की ओर फैलाए रयो।” ");
INSERT INTO hlb_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","एकोलाने मी कहू हैं, का परमेस्वर न अपनो लोग हुन ख छोड़ दियो? असो नी हैं! मी भी ते इस्राएली आय; अब्राहम को खानदान को अर बिन्यामीन को खानदान म से आय। ");
INSERT INTO hlb_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","परमेस्वर न अपनो उ प्रजा ख नी छोड़ोगो, जे ख ओ न पहले ही से जान। का तुम नी जान हैं कि सुध्द सास्र एलिय्याह को बारा मी का कह हैं, कि उ इस्राएली को खिलाप म परमेस्वर से प्रर्थाना करिये हैं? ");
INSERT INTO hlb_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“अरे प्रभु उनना तोरो भविस्यवक्ता हुन को मार डालो हैं, अर तोरी वेदी हुन ख तोड़ दियो हैं; अर मी ही बचो हूँ, अर वी मो ख मारन कि कोसिस म हैं।” ");
INSERT INTO hlb_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","पर परमेस्वर से ओ ख का उतर मिलो? “मी न अपनो लाने सात हजार अदमी हुन ख रख छोड़ो हैं, जीन बाल देवता हुन को सामने घुटना नी टेको हैं।” ");
INSERT INTO hlb_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","अच्छो असो रिती से यी बखत भी, दया से चुनो भेयो कई व्यक्ति बाकी हैं। ");
INSERT INTO hlb_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","पर यी दया से भेयो हैं, ते फिर करम से नी; ते दया फिर नी रय्हो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","एकोलाने परिनाम का निकलो इस्राएली जे कि खोज म हतो, ओ ख नी पा सक; किन्तु चुन हुयो लोग हुन न ओ ख पालन अर दूसरा हुन सुननो नी चाहव। ");
INSERT INTO hlb_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","जसो कि सुध्द सास्र म लिखो हैं, “कि परमेस्वर न सुध्द आत्मा को दुवारा कि बुध्दि को जड़ बना दियो हैं ओ म उन ख, असी आँखी दे दी जे नी देख हैं, अर असो कान जे नी सुननो नी अर ओकी यू हाल्त आज लक बनी हैं।” ");
INSERT INTO hlb_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","अर दाऊद कह हैं, “उन को खान उन का लाने जाल अर फंदा अर ठोकर अर दंड को लाने होए जाएगो। ");
INSERT INTO hlb_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ओकी आँख हुन पर अन्धेरा छाय जाहे ताकि नी देखे, अर तू सदा उन कि पीठ ख झुका ख रखा।” ");
INSERT INTO hlb_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","एकोलाने अब म पूछनो हैं का उन न एकोलाने ठोकर खाई ख गिर पड़े? असो नी हैं! पर उन को गिरनु को कारन गैर यहूदी हुन का उध्दार मिले, कि उन ख जलन होए। ");
INSERT INTO hlb_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","एकोलाने अदि उनको गिरन को संसार ख लाने धन अर उन ख कमी गैर यहूदी हुन ख लाने धन को कारन होऐ ते उन ख परिपूर्णता से का कुछ नी होऐ। ");
INSERT INTO hlb_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","मी गैर यहूदी हुन से यू कहनो हैं। मी ते गैर यहूदी हुन म प्रेरित करन गयो, अर गैर यहूदी हुन ख लाने भेजो गयो अर मो ख सेवकाई महान देती हैं। कि कोई भी तरीका से अपनो कुटुम्बी हुन म जलन पैदा कर सक अर ऐको दुवारो ओ म से कोई ख छुटकारा हो सका। ");
INSERT INTO hlb_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","काहेकि कई रिवाज से मी अपनो कुटुम्बी हुन म जलन पैदा करवा ख ओ म से कई एक को उध्दार कराऊगो। ");
INSERT INTO hlb_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","काहेकि जब उनको छोड़ दियो जानू दुनिया को मिलन ख कारन भयो ते का उनको स्वीकार कियो जानो माऊत भेयो म से जिन्दो उठान को बराबर नी होऐ? ");
INSERT INTO hlb_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","जब दान को पहलो पेड़ा सुध्द ठहरो, ते पुरो गुँथो भयो आटा भी सुध्द आय; अर जब जड़ सुध्द ठहरे, ते डाली हुन भी सुध्द ठहरे। ");
INSERT INTO hlb_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","पर अदि कुछ डगियान तोड़ दी जाय, अर तू जंगली जैतून हो ख ओमा कलम करो गयो, अर जैतून की जड़ कि चिकनई म सामिल हो गयो ");
INSERT INTO hlb_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ते तुम अपनो ख डाली हुन से बढ़ ख नी समझ अदि तुम गर्व करनो चाहव हैं, ते याद रख कि तुम जड़ ख नी संभाल हैं, हाल्कि जड़ तुम ख संभाल हैं। ");
INSERT INTO hlb_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","फिर तू कहे, “डाली हुन एकोलाने तोड़ो गयो कि मी साटो जाऊ।” ");
INSERT INTO hlb_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","चोक्खो हैं, वी ते अविस्वास का कारन तोड़ो गयो, पर तू विस्वास से बनो रह हैं एकोलाने घमंडी नी हो, पर डर मान, ");
INSERT INTO hlb_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","काहेकि जब परमेस्वर न स्वाभाविक डगियान हुन ख नी छोड़ो ते तोखा भी नी छोड़ेगो। ");
INSERT INTO hlb_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","एकोलाने परमेस्वर कि किरपा अर कठोरता पर ख विचार कर गिर हुयो इंसान हुन क लाने कठोरता अर परमेस्वर तुमारो लाने किरपा अदि तुम हकिगत म उनकी दया कि हद म बन्धो रहन हो नी ते तुम ख अलग कर दियो जाहे। ");
INSERT INTO hlb_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","अऊर दुसरी ओर अदि वे अविस्वासी जन नी रहे ते वी भी कमल लगयो पाहे। काहेकि परमेस्वर उनख पुन लगानो को समर्थ रख हैं। ");
INSERT INTO hlb_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","काहेकि अदि तू उ जैतून से, जे स्वभाव से जंगली हैं; काटा गयो अर स्वभाव को विरूध्द चोक्खो जैतून म छाटो गयो, ते यी जे स्वाभाविक डगियान हुन हैं, अपनो ही जैतून म काहे नी लगयो जाहे। ");
INSERT INTO hlb_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","अरे भई अर बहिन, कही असो नी होए कि तुम अपनो खुद ख समझदार समझ ले, एकोलाने म नी चाहूँ कि तुम यी बात से अनजान रय्हे कि जब तक गैर यहूदी हुन पुरी रीति से भीतर नी कर ले, तब तक इस्राएल को एक हिसा असो ही मजबूत रहेगो। ");
INSERT INTO hlb_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","अर यी रीति से सारो इस्राएल ख उध्दार पाहे। जसो लिखो हैं, “छुड़ा न वालो सिय्योन से आएँगो, अर अभक्ति ख याकूब ख नास्तिक हुन से दूर करेगों।” ");
INSERT INTO hlb_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","अर उनको संग मोरी उही वाचा होए, जब कि मी उनख पाप हुन का दूर ख दूगो। ");
INSERT INTO hlb_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","सुसमाचार को भाव से ते तुमारो लाने वी परमेस्वर का दुसमन हैं, पर चुन लाने जान का भाव से वी बापदादा हुन का कारन प्यारो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","काहेकि परमेस्वर अपनो वरदान हुन से, अर पुकारा से कभी पछतावा नी। ");
INSERT INTO hlb_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","काहेकि जसो अपनो प्राचीन काल से परमेस्वर कि हुकुम नी मानो हैं, पर अब तुम लोगहुन पर परमेस्वर कि दया भई हैं ");
INSERT INTO hlb_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","वसो ही उन न भी अब बात नी मानी, कि तुम पर जे दया होवा हैं असो ओ पर भी दया होवा। ");
INSERT INTO hlb_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","काहेकि परमेस्वर न सब ख हुकुम नी पालन को लाने कैदी बना ख रखो हैं, जे उ सब पर दया करे। ");
INSERT INTO hlb_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","आहा! परमेस्वर को धन अर समझदार अर ग्यान को ही गभीर हैं ओको विचार कसो असो ही, अर ओको रस्ता कसो आवन अगम हैं! ");
INSERT INTO hlb_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","प्रभु कि समझ को कोन जानो? या ओको साहलकार कोन बनो? ");
INSERT INTO hlb_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","या फिर कोन पहले ओ ख कई दियो हैं जेको बदला ओसे ही दियो जाएगो? ");
INSERT INTO hlb_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","काहेकि ओकी ही ओर से, अर ओको ही व्दारा, अर ओको लाने सब कुछ हैं। ओकी महिमा हमेसा होती रहे: आमीन ");
INSERT INTO hlb_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","एकोलाने अरे भई हुन, म तुम से परमेस्वर कि दया याद दिला ख विनती करु हूँ कि अपनो सरीर ख जीवित, अर सुध्द, अर परमेस्वर को खुसी करन लायक यू तुमारी बलिदान कर ख चढ़ाओ। यू तुम्हारो सच्ची सेवा हैं। ");
INSERT INTO hlb_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","अर यू दुनिया को सदस्य नी बन; पर तुमारी मन का नयो हो जानू से तुमारी चाल चलन भी बदलतो जाहे, जे से तुम परमेस्वर कि भली, अर भावती, अर पसंन्द, अर अच्छी परख अनुभव से मालूम कर सका हैं। ");
INSERT INTO hlb_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","काहेकि म उ दया का कारन जो मोखा ख मिलो हैं, तुम म से हर एक से कहूँ हैं कि जसो समझनो चाहिए ओ से बढ़ ख कोई भी अपनो तुम ख नी समझे; पर जसो परमेस्वर न हर एक ख विस्वास नतिज्जा को अनुसार बाट दियो हैं, वसो ही सुबुध्दि का संग अपनो ख समझे। ");
INSERT INTO hlb_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","काहेकि जसो हमारी एक ही सरीर म बेजा से अंग हैं, अर सब अंग हुन को एक ही सो काम नी हैं; ");
INSERT INTO hlb_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","वसो ही हम जे बेजा हैं, मसी म एक सरीर हो ख आपस म एक दुसरा को अंग हैं। ");
INSERT INTO hlb_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","अर ओकी दया का अनुसार जो हम ख दियो गयो हैं, हम ख अगल-अगल वरदान मिलो हैं, ते जेको भविस्यवानी को दान मिलो हैं, उ विस्वास को नतिज्जा ख अनुसार भविस्यवानी करे; ");
INSERT INTO hlb_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","अदि सेवा को वरदान हैं, ते हम ख सेवा करन चाहिए; अगर हम ख सिक्छा देन को वरदान मिलो हैं, ते हम ख सिखानो चाहिए; ");
INSERT INTO hlb_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","अदि एक दूसरा ख उत्साह करन को वरदान हैं, ते उत्साहित कर। अऊर एक दूसरा ख देन को वरदान हैं, ते उदारता से दे अर जे ख अगुवाई वरदान हैं ते खुसी से करो, जेख अनुग्रह करन को वरदान हैं ते ओ ख दया करनो चाहिए। ");
INSERT INTO hlb_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","प्रेम म कई कपट हो; पर बुराई से घृना कर; भलाई म लगो रह। ");
INSERT INTO hlb_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","भई म जसो प्रेम होवा हैं वसो ही एक दुसरा से प्रेम रख आपस म एक दुसरा आदर कर। अर एक दुसरा से चढ़ कर। ");
INSERT INTO hlb_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","अऊर कोसिस करन म आलस नी कर सुध्द आत्मा कि खुसी म भरो रह प्रभु कि सेवा करते रह। ");
INSERT INTO hlb_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","आसा म आनन्दित रह; दुख म पक्को रह; प्रार्थना म लगातार लगो रह। ");
INSERT INTO hlb_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","सुध्द व्यक्ति हुन ख जो कुई जरूरत हो, ओ म ओकी सहायता कर; पहुनाई करन म लगो रह। ");
INSERT INTO hlb_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","अपनो सतान वाला ख आसीस दे; आसीस दे स्राप नी दे। ");
INSERT INTO hlb_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","आनन्द करन वालो का संग खुसी कर, अर रोन वालो का संग रोओ। ");
INSERT INTO hlb_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","आपस म एक सो मन रख; घमंड नी हो, पर सीधा का संग संगति रख; अपनी आँख म समझदार नी हो। ");
INSERT INTO hlb_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","बुराई का बदला कोई से बुराई नी कर; सब ख दृस्टि सब को जे अच्छो हैं ऊईच करन को विचार कर। ");
INSERT INTO hlb_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","जहाँ तक हो सका हैं, तुम अपनी ओर से सब को संग म मिल जुड सान्ति रखनू बनायो रख। ");
INSERT INTO hlb_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","हे प्यारो, भई हुन अर बहिन हुन तुम न्याय नी कर, बल्कि ओ ख परमेस्वर को प्रकोप म छोड़ दे। काहेकि लिखो हैं, “प्रभु कह हैं बदला लेना मोरो काम हैं मी ही बदला लेहूँ।” ");
INSERT INTO hlb_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","पर “यदि तोरो दुसमन भुखो हो ते ओ ख जोवन खिला, पर प्यासो हो ते ओ ख पानी पिला; काहेकि असो करना से तू ओको सिर पर आग को अंगार हुन को ढ़ेर लगाएगो।” ");
INSERT INTO hlb_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","बुराई से नी हार, पर भलाई से बुराई ख जीत ले। ");
INSERT INTO hlb_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","हर एक व्यक्ति सासन को अधीन रवह अधिकारी हुन का बस रह, काहेकि कोई अधिकार असो नी हैं जे परमेस्वर कि तरफ से नी होऐ; अर जे अधिकार हैं, वी परमेस्वर का दुवारा ठहरायो गयो हैं अधिकारी हैं। ");
INSERT INTO hlb_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","एकोलाने जे कोई अधिकार को विरोध करह हैं, उ परमेस्वर कि रीवाज को सामना करिये हैं, अर विरोध करनवालो दण्ड पाहे। ");
INSERT INTO hlb_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","काहेकि सासक अच्छो काम करन वालो म नी, पर कुकरम करन वालो म डर पैदा करह हैं का तुम अधिकारी हुन को डर से बे फिकर रहवन चाहव हैं? ते ऊईच काम कर जे चोक्खो हैं वी तुमारी बड़ाई हैं। ");
INSERT INTO hlb_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","काहेकि वी तुमारी भलाई ख लाने परमेस्वर को सेवक हैं। पर अदि तुम कुकरम करह हैं, ते उन से डर काहेकि ओको हात म तलवार बेकार नी हैं, अर वी परमेस्वर को चुनो हुओ सेवक आय। ओको गुस्सा को संग नी हो ख बुरोकाम करनवालो ख सजा देवा हैं। ");
INSERT INTO hlb_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","यू ईच कारन से तुम ख अधिकारी हुन को बस म रहनो चाहिए, नी ही गुस्सा को वजे से बल्कि मन से भी। ");
INSERT INTO hlb_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","एकोलाने कर भी दे काहेकि सासन करन वालो परमेस्वर का दास आय अर सदा यी काम म लगो रह हैं। ");
INSERT INTO hlb_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","अऊर जे ख कोई को तो ख देनो हैं, ओको हक चुका दे। जे कर तो ख देनो हैं, ओ ख दे। जेकी चूँगी तो पर निकलह हैं, ओ ख चूँगी दे। जे से तो ख डरनो चहिए ओको सम्मान कर। ");
INSERT INTO hlb_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","अऊर एक दूसरा हुन से प्रेम करनो छोड़ ख दूसरी कोई भी बात हुन को कर्जा वालो नी होनो चहिए काहेकि जे दूसरो ख प्रेम करह हैं उ मूसा को नेम ख मान लियो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","काहेकि गलत काम नी करह, कोई को नी मरनू, चोरी नी करनु, लालसा नी करनु अर ऐको अलावा अदि कोई आदेस हो ते ओको सारो यूईच हैं, अपनो पड़ोसी ख लाने तुमारो प्रेम वसो ही हो वसो ही तुमारो खुद ख लाने होऐ। ");
INSERT INTO hlb_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","प्यार पड़ोसी कि कुछ बुराई नी कर, एकोलाने प्रेम रखनो नेम ख पुरो करनु हैं। ");
INSERT INTO hlb_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","बखत ख पहिचान ख असो ही कर, एकोलाने कि अब तुमारो लाने नींद से जाग उठनू कि बखत आ पहुचो हैं; काहेकि जे बखत हम न विस्वास कियो हतो, उ बखत का सलाह से अब हमारो उध्दार नजीक हैं। ");
INSERT INTO hlb_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","अऊर रात गुजर चुकी हैं। सुबेरे होन वाली हैं, अर दिन निकल पर हैं; एकोलाने हम अन्धकार को काम हुन ख छोड़ कर उजाला को हथियार बाँध ले। ");
INSERT INTO hlb_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","जसो दिन ख अच्छो देवा हैं, असो ही हम सिधी चाल चले, नी की लीला-क्रीड़ा अर पियक्कड़ पन म, नी छिनालापन अर भोग विलास, अर झगड़ा अर जलन से दूर रह। ");
INSERT INTO hlb_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","पर तुम प्रभु यीसु मसी ख धारन कर, अर सरीर की बुरी इच्छा ख पुरो करन को कोसिस नी कर। ");
INSERT INTO hlb_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","जे विस्वास म कमजोर हैं, ओ ख संग संगति म ले ले, पर ओकी न्याय करन कि छमता पर लड़ाई नी कर। ");
INSERT INTO hlb_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","काहे कि एक ख विस्वास करह हैं उ सब कुछ खा सका हैं, पर जे विस्वास म कमजोर हैं उ सब्जी भाजी ही खाए हैं। ");
INSERT INTO hlb_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","जे न खान वालो हैं ओ खान वालो ख बेकार नी जान खान वालो पर नी पर लगा अर नी खान वालो म कमी हुन नी खोज। ");
INSERT INTO hlb_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","तू कोन आय जे दुसरा का दास पर दोस लगाव हैं? ओको मजबूत रहनू या गिर जानू ओको मालिक ही से रिस्ता रख हैं; पर उ पक्को ही कर दियो जाएगो, काहेकि प्रभु ओ ख स्थिर रख सक हैं। ");
INSERT INTO hlb_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","अऊर जे कोई दिन ख खास मान हैं, अर कोई सब दिन हुन ख एक समान मान हैं। पर हर एक अपनो ही मन म ठान लेवा हैं। ");
INSERT INTO hlb_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","जे कोई दिन को मान हैं, उ प्रभु का लाने मान हैं। जे खाए हैं, प्रभु का लाने खाए हैं, काहेकि उ परमेस्वर को धन्यवाद कर हैं, अर जे नी खाए, उ प्रभु का लाने नी खाए अर परमेस्वर को धन्यवाद करिये हैं। ");
INSERT INTO hlb_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","काहेकि हम म से नी ते कोई अपनो लाने जीवित हैं अर नी कोई खुद ख लाने मरता हैं। ");
INSERT INTO hlb_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","अदि हम जीवित हैं, ते प्रभु का लाने हैं, अर अगर मर हैं, ते प्रभु का लाने मर हैं; अब हम जिन्दो अऊर फिर मरे, प्रभु ही का हैं। ");
INSERT INTO hlb_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","काहेकि मसी यी का लाने मरो अर जीवित भी उठो हैं कि उ मरो हुयो अर जीवतो दुई को प्रभु आय। ");
INSERT INTO hlb_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","तू अपनो भई पर काहे दोस लगाव हैं? अर तू फिर काहे अपनो भई ख खराब जान हैं? हम पूरा का पूरा परमेस्वर को न्याय सिंहासन को सामने खड़ो होऐ। ");
INSERT INTO hlb_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","काहेकि लिखो हैं, “प्रभु कहत हैं, मोरो जिन्दी की कसम कि हर एक घुटना मोरो सामने झुकेगो, अऊर हर एक जीभ परमेस्वर ख अंगीकार करे।” ");
INSERT INTO hlb_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","एकोलाने हम म से हर परमेस्वर ख अपनो अपनो हिसाब देहे। ");
INSERT INTO hlb_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","एकोलाने हम एक दूसरो ख दोस लगान छुड़ा ख आपस म निस्चय कर ले कि कोई अपनो भई ख रस्ता म ठोकर ख कारन म नी पैदा कर अर बनो। ");
INSERT INTO hlb_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","मोखा मालूम हैं अर प्रभु यीसु म मोखा जरूर भयो हैं कि कोई चीज अपनो खुद से असुध्द नी, पर जे ओ ख असुध्द समझ हैं ओको लाने असुध्द हैं। ");
INSERT INTO hlb_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","पर तोरो भई तोरो जोवन का कारन नाराज होय हैं ते फिर तू प्रेम को तरीका से नी चले हैं ते जे को लाने मसी मरे, ओ ख तू अपनो जोवन को व्दारा खत्म नी कर। ");
INSERT INTO hlb_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","अब तुमारी सामने जे भलो हैं ओको बारा म बुराई नी करनु। पर न्याय अर सान्ति अर सुध्द आत्मा म आनन्द हैं। ");
INSERT INTO hlb_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","काहेकि परमेस्वर को राज खान-पीवन को नी आय, पर धर्म अर मेलमिलाप अर उ सान्ति अर खुसी हैं जे सुध्द आत्मा से होवा हैं। ");
INSERT INTO hlb_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","जे मसी कि सेवा कर हैं, उ परमेस्वर ख प्रसन्न कर हैं, अर लोग हुन को बीच विस्वास लायक हैं। ");
INSERT INTO hlb_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","अऊर हम असी बात हुन म लगया रह जे न सान्ति ख बढ़ावा मिल अर जिनको दुवारो हम एक दूसरा हुन ख सुधार कर सक हैं। ");
INSERT INTO hlb_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","अऊर जोवन को कारन परमेस्वर को काम हुन ख नी बिगाड़ो यू सच्चो हैं। सब कुछ अपनो म सुध्द पर जोवन को दुवारो दुसरो ख रस्ता म ठोकर को कारन बुरो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","अच्छो ते यू हैं कि तू नी मांस खाए अर नी अंगूर को रस पीए नी अर कुछ असो करे जेसे तोरो भई ठोकर खाऐ। ");
INSERT INTO hlb_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","तोरो जे विस्वास हैं, ओ ख परमेस्वर को सामने अपनो मन म रख हैं। धन्य हैं वी जे उ बात म, जेखा उ ठीक परखा हैं अपनो तुम म दोस नी ठहरायो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","पर जे सक कर ख खाता हैं उ सजा को योग्य ठहर चूको, काहेकि उ विस्वास से नी खाऐ; अर जे कुछ विस्वास से नी, उ पाप हैं। ");
INSERT INTO hlb_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","अब हम ताकतवार हुन ख जरूरी आय कि कमजोर हुन ख कमजोर हुन ख सहन, नी कि अपनो खुद ख खुस कर। ");
INSERT INTO hlb_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","हम म से हर एक अपनो पड़ोसी ख ओकी भलाई का लाने सुधार ख जसो खुसी कर। ");
INSERT INTO hlb_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","काहेकि मसी हुन अपनो तुम ख खुसी नी कियो, पर जसो लिखो हैं: “तोरो बुराई हुन कि बुराई मोपर आ पड़ी।” ");
INSERT INTO hlb_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","जे बात हुन पहले से लिखी गई, वी हमारी ही सिखान का लाने लिखी गई हैं कि हम‍ सान्ति अर सुध्द सास्र परमेस्वर को वचन ख प्रोत्साहन ख व्दारा आसा रखो। ");
INSERT INTO hlb_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","अऊर परमेस्वर ही धीरज अर सान्ति को परमेस्वर खुद लोग हुन ख वरदान दे कि तुम यीसु मसी ख सिक्छा ख जसो आपस म मेल मिलाप को भाव बनायो रखो। ");
INSERT INTO hlb_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","काहे कि तुम एक मन अर एक आवाज म हमारो प्रभु यीसु मसी को बाप परमेस्वर कि बड़ाई कर। ");
INSERT INTO hlb_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","एकोलाने, जसो मसी हुन न परमेस्वर कि बड़ाई का लाने तुम ख स्वीकार करियो हैं, असो ही तुम ख भी एक दुसरा ख अंगीकार करनो चाहिए। ");
INSERT INTO hlb_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","एकोलाने मी कहू हैं कि जे वादा हुन बापदादा हुन ख दी गई हती उन ख सच करन का लाने मसी, परमेस्वर कि सच्चाई को नतिज्जा देन का लाने, खतना कियो भेयो अदमी हुन को दास बनो; ");
INSERT INTO hlb_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","अर गैर यहूदी हुन भी दया का लाने परमेस्वर कि बड़ाई कर; जसो लिखो हैं, “एकोलाने मी जाति जाति म तोरो धन्यवाद करूँ, अर तोरो नाम को भजन गाऊँ।” ");
INSERT INTO hlb_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ते फिर कह हैं, “अरे जात-जात का सब अदमी हुन, ओकी सेना का संग आनन्द करे।” ");
INSERT INTO hlb_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","अऊर फिर, यू जात जात को सब लोग हुन प्रभु की स्तुति करे, “राज्य का सब इंसान हुन ओकी बड़ाई कर।” ");
INSERT INTO hlb_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","अर फिर यसायाह कह हैं, “यिसै कि एक जड़ प्ररगट होए, अर गैर यहूदी हुन को मुखिया होनू का लाने एक उठेगो, ओ पर गैर यहूदी हुन आसा रखेगो।” ");
INSERT INTO hlb_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","परमेस्वर जे आसा को दाता आय तुमारो विस्वास करन म सब तरीका को खुसी अर सान्ति अर धीरज से परिपूर्ण करिये, कि सुध्द आत्मा कि सक्ति से तुमारो आसा बढ़ जाहे। ");
INSERT INTO hlb_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","अरे मोरो भई हुन जहाँ तक तुम ख बारा, मी खुद विस्य कोच हैं अर विस्वास हैं कि तुम खुद ही भलाई अर समझो जानो से परिपूर्ण हो ख अर पूरी समझ से एक दुसरा ख सलाह दे सक। ");
INSERT INTO hlb_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","तब म नी कही-कही याद दिलान का लाने तुमारो जे बेजा हिम्मत कर लिखू। यी ओ पर दया को करना भेयो जे परमेस्वर न मोखा दियो हैं, ");
INSERT INTO hlb_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","कि म गैर यहूदी हुन का लाने मसी यीसु को सेवक हो ख परमेस्वर को सुसमाचार की सेवा याजक का समान करू जेसे गैर यहूदी हुन को लाने चढ़ायो जानो, सुध्द आत्मा से सुध्द बन ख स्वीकार कियो जाएगो। ");
INSERT INTO hlb_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","एकोलाने उन बात हुन का बारा म जे परमेस्वर से सम्बन्ध रखी हैं, मी मसी यीसु म गर्व कर सकू हूँ। ");
INSERT INTO hlb_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","काहेकि उन बात हुन ख छोड़ मोखा अर कोई बात का बारा म कह को हिम्मत नी हैं; जे मसी न गैर यहूदी हुन को बात हुन ख लाने वचन, करम से, ");
INSERT INTO hlb_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","अर चिन्हान, अर अदभुत काम हुन कि सक्ति से, अर सुध्द आत्मा कि सक्ति से मोरो ही व्दारा कियो हैं; यहाँ तक कि मी न यरूसलेम से चारो तरफ इल्लुरिकुम तक मसी का सुसमाचार को पूरो प्रचार कियो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","पर मोरो मन कि उमंग यी हैं कि जहाँ-जहाँ मसी को नाम नी लियो गयो हैं, वही सुसमाचार सुनाऊ असो नी होए कि दुसरो कि नीव पर घर बनाऊँ। ");
INSERT INTO hlb_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","पर जसो लिखो हैं वसो ही हो, “जे को नजीक ओको सुसमाचार नी पहुँचो हैं, वी दर्सन करे अर जे न नी सुनो हैं यू ईच समझे।” ");
INSERT INTO hlb_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","काहेकि मी बार बार तुम लोग हुन को नजीक आन से रुको रयो हूँ। ");
INSERT INTO hlb_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","पर अब इन दास हुन म मोरो काम का लाने अर जगह नी रय्हो, अर बेजा साल से मो ख तुमारो पास आन का इच्छा हैं। ");
INSERT INTO hlb_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","एकोलाने जब मी स्पेन ख जाऊ ते तुमारो पास होए जाऊ, काहेकि मोखा आसा हैं कि उ सफर म तुम से मेल होए, अर तब तुमारी संगति से मोरो मन कुछ भर जाहे ते तुम मोखा कुछ दूर आग पहुँचा देनू। ");
INSERT INTO hlb_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","पर अभी ते मी सुध्द अदमी हुन कि सेवा करन का लाने यरूसलेम ख जाऊ हैं। ");
INSERT INTO hlb_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","काहेकि मकिदुनिया अर अखया का अदमी हुन ख यी अच्छो लग हैं कि यरूसलेम का सुध्द अदमी हुन म कंगाल हुन का लाने कुछ चन्दा करे। ");
INSERT INTO hlb_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","उन ख अच्छो ते लगे, पर वी उन ख कर्जदार भी हैं, काहे कि अदि दुसरी जात ओकी आत्मिक बात हुन म सामिल भयो, ते उन ख भी जरूरी हैं कि सारीरिक बात हुन म ओकी सेवा करिये। ");
INSERT INTO hlb_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","एकोलाने मी यी काम पूरो कर ख अर उनको यी चन्दा दे ख तुमारो पास होतो भेयो स्पेन नगर ख जाऊ। ");
INSERT INTO hlb_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","अर म मालूम हैं कि तब मी तुमारो पास आऊ, ते मसी कि पूरी आसीस का संग आऊ। ");
INSERT INTO hlb_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","अरे भई हुन, हमारो प्रभु यीसु मसी को अर सुध्द आत्मा का प्रेम को याद दे ख म तुम से विनती करू हैं, कि मोरो लाने परमेस्वर से प्रार्थना करन म मोरो संग मिल ख लोलीन रय्हो ");
INSERT INTO hlb_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","कि म यहूदी हुन को अविस्वास हुन से बचो रय्हो, अर मोरी उ सेवा जो यरूसलेम का लाने हैं, सुध्द अदमी हुन ख पसन्द आहे; ");
INSERT INTO hlb_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","अर म परमेस्वर कि इच्छा से तुमारो पास खुसी का संग आ ख तुमारो संग आराम पा हे। ");
INSERT INTO hlb_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","सान्ति को परमेस्वर तुम सब का संग रह। आमीन। ");
INSERT INTO hlb_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","मी तुम से फीबे का लाने जे हमारी बहिन अर किंख्रिया कि कलीसिया कि सेविका हुन आय, प्रार्थना करू हैं। ");
INSERT INTO hlb_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","कि तुम प्रभु म यू प्रकार से अंगीकार कर जसो कि परमेस्वर को सुध्द लोग हुन लायक हैं, ओ से तुमारो वजे जसा मददत चहिए वसा ही ओकी मददत कर काहेकि उ मोरो संग बेजा लोग हुन कि मददत करियो हैं। ");
INSERT INTO hlb_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","प्रिस्का अर अक्विला ख भी जे यीसु मसी म मोरो संग बटायो हैं, नमस्कार। ");
INSERT INTO hlb_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","अऊर उनना मोरो लाने अपनो जीवन परेसानी म डाल दियो हतो; अर अकेलो म ही नी, पर दुसरी जात हुन कि पूरी कलीसिया हुन ख भी उन ख धन्यवाद कर हैं। ");
INSERT INTO hlb_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","उ कलीसिया हुन ख भी नमस्कार जे उनका घर म हैं। मोरो प्यारो इपैनितुस को, जे मसी का लाने आसिया को पहलो फल आय, नमस्कार ");
INSERT INTO hlb_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","मरियम ख, जेन तुमारा लाने बेजा महेनत करियो हैं, नमस्कार। ");
INSERT INTO hlb_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","अन्द्रनीकुस अर यूनियास ख जे मोरो खानदानी आय, अर मोरो संग बंद भेयो अर प्रेरित हुन म नामी आय, अर मोसे से पहले मसी भयो हतो, नमस्कार। ");
INSERT INTO hlb_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","अम्पलियातुस ख, जे प्रभु म मोरो प्यारो आय, नमस्कार। ");
INSERT INTO hlb_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","उरबानुस ख, जे मसी म हमारो संग बटायो हैं, अर मोरो प्यारो इस्तखुस ख प्रणाम। ");
INSERT INTO hlb_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","अपिल्लेस ख जो मसी म विस्वास लायक निकलो, नमस्कार। अरिस्तुबुलस ख घरानो ख भी नमस्कार। ");
INSERT INTO hlb_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","मोरो संबधी हुन ख भी हेरोदियोन ख प्रणाम। नरकिस्सुस का घराना ख जे अदमी प्रभु म आय, उन ख प्रणाम। ");
INSERT INTO hlb_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","त्रूफैना अर त्रूफोसा ख जे प्रभु म मेहनत करिये हैं, प्रणाम। प्यारो पिरसिस ख, जेन प्रभु म बेजा मेहनत कियो, नमस्कार। ");
INSERT INTO hlb_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","रूफुस ख भी जे प्रभु म चुनो भेयो हैं अर ओकी माय ख, जे मोरी भी माय आय, दूई ख प्रणाम। ");
INSERT INTO hlb_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","असुंक्रितुस अर फिलगोन अर हिर्मेस अर पोरियाबास अर हिर्मास अर उनका संग का भई हुन ख भी प्रणाम। ");
INSERT INTO hlb_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","फिलुलुगुस अर यूलिया अर नेर्युस अर ओकी बहिन, अर उलुम्पास अर ओखा संग का पूरा सुध्द अदमी हुन ख भी नमस्कार। ");
INSERT INTO hlb_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","आपस म सुध्द चुमा से नमस्कार कर। तुम ख मसी कि सारी कलीसिया हुन ख तरफ से नमस्कार। ");
INSERT INTO hlb_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","पर अरे भई हुन, बहिन हुन मी तुम लोग ख प्रोत्साह करूँ हूँ से विनती करू हैं कि जे अदमी उ सिखान का दूसरी, जे तुम न पायो हैं, फूट डालन अर ठोकर खिलान को लाने होए हैं, उन ख ताड़ लियो कर अर उनमा दूर रह। ");
INSERT INTO hlb_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","काहेकि असो अदमी हमारो प्रभु मसी को नी, पर अपनो पेट कि सेवा करिये हैं; अर चिकनी चुपड़ी बात हुन से सीधो-सादे मन का अदमी हुन ख बहका दे हैं। ");
INSERT INTO hlb_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","तुमारो कहना हुन मान न कि खबर सब अदमी हुन म फैल गई हैं, एकोलाने मी तुमारो बार म खुसी करू हैं, पर म यी चाहूँ हैं कि तुम भलाई का लाने समझदार पर बुरो का लाने सिदो बनो ख रह। ");
INSERT INTO hlb_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","सान्ति को परमेस्वर सैतान ख तुमारो पाय से सीघ्र कुचल देगो। हमारो प्रभु यीसु मसी को दया तुम पर होतो रह। ");
INSERT INTO hlb_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","मोरो संग बटायो तीमुथियुस ख, अर कुटुम्बी हुन लूकियुस अर यासोन अर सोसिपुस्रस ख भी तुम ख नमस्कार। ");
INSERT INTO hlb_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","मोखा चिठ्टी ख लिखन वाला तिरतियुस ख, प्रभु म तुम ख नमस्कार। ");
INSERT INTO hlb_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","गयुस जो मोरो अर कलीसिया कि पहुनाई करन वालो हैं, ओको तुम ख भी नमस्कार। इरास्तुस जो सहर को भण्डारी हैं, अर भई क्वारतुस ख तुम ख भी नमस्कार। ");
INSERT INTO hlb_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","हमारो प्रभु मसी को दया तुम पूरा पर बनी रहे। आमीन। ");
INSERT INTO hlb_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","पर जे तुम ख मोरो सुसमाचार परन्तु यीसु मसी को सुसमाचार को प्रचार को जसो खड़ो कर सक हैं, सच्चो को प्रकासन को जसो जे हमेसा से छिपा हुओ हतो, ");
INSERT INTO hlb_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","पर अब प्ररगट हो ख अनन्त परमेस्वर कि बात से भविस्यवक्‍ता हुन कि पुस्तक हुन को व्दारा सब जात हुन ख बतायो गयो हैं कि वी विस्वास से बात मान वाला हो जाहे। ");
INSERT INTO hlb_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","उही एक अकलो समझदार परमेस्वर कि यीसु मसी को व्दारा हमेसा तक महिमा होती रहे आमीन। ");
INSERT INTO hlb_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","पोलुस कि ओर से जे परमेस्वर कि इच्छा से यीसु मसी को प्रेरित होन का लाने बुलायो गयो अऊर भई सोस्थिनेस को तरफ से चिठ्टी, ");
INSERT INTO hlb_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","परमेस्वर कि वा कलीसिया को नाम जीई कुरिन्थुस नगर म हैं, पर उनको नाम जे मसी यीसु म सुध्द करियो गयो, अर सुध्द होन ख लाने बुलायों गया हैं; अऊर उन सब का नाम भी जीई हर जगह हमारो अऊर अपनो प्रभु यीसु मसी को नाम से लेहे अर प्रर्थाना करा हैं। ");
INSERT INTO hlb_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","हमारो बाप परमेस्वर अऊर प्रभु यीसु मसी कि ओर से तुम ख दया अर सान्ति मिलेह हैं। ");
INSERT INTO hlb_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","मी तुमारो बारा म अपनो परमेस्वर कि जय जयकार करू हैं, कि परमेस्वर ख यी दया तुम पर मसी यीसु म विनती आय। ");
INSERT INTO hlb_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","कि ओमा, होय ख तुम हर बात म असो सारो वचन अऊर सारो ग्यान म धनी करियो गयो हैं ");
INSERT INTO hlb_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","कि मसी कि गवाई तुम म पक्को निकलियो ");
INSERT INTO hlb_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","यहाँ तक कि कई वरदान म तुम ख घटी नी हैं, अऊर तुम हमारो प्रभु यीसु मसी ख प्ररगट होन कि रस्ता देख रह हैं। ");
INSERT INTO hlb_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","वी तुम ख आखरी तक मजबूत भी करे कि तुम हमारो प्रभु यीसु मसी ख दिन मी बेकसूर ठहरायो। ");
INSERT INTO hlb_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","परमेस्वर सच्चो हैं, जे न तुम ख अपनो पोरिया हमारो प्रभु यीसु मसी कि संगति म बुलायो हैं। ");
INSERT INTO hlb_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","अरे भई अर बहिन, मी तुम से हमारो प्रभु यीसु मसी का नाम से विनती करू हैं कि तुम सारा एक ही बात कह, अऊर तुम म फूट नी होय, पर एक ही मन अऊर एक ही मत हो ख मिलो रह। ");
INSERT INTO hlb_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","काहेकि अरे मोरा भई-बहिन हुन, खलोए को घराना ख अदमी हुन न मो ख तुमारो बारा म बतायो हैं कि तुम म लड़ाई होय रही हैं। ");
INSERT INTO hlb_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","मोरो कहनो को मतलब यू हैं कि तुम म कोई ते अपनो खुद ख “पोलुस ख,” ते कोई “अपुल्लोस ख,” ते “कैफा को,” ते कोई “मसी को” कह हैं। ");
INSERT INTO hlb_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","का मसी बँट गयो? का पोलुस तुमारो लाने सूली पर चढ़ायो गयो? या तुम ख पोलुस को नाम पर बपतिस्मा मिलो? ");
INSERT INTO hlb_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","म परमेस्वर ख सुक्रिया करू हैं कि क्रिसपुस अऊर गयुस ख छोड़ मी न तुम म से कुई ख भी बपतिस्मा नी दियो। ");
INSERT INTO hlb_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","कही असो नी हो कि कोई कहे कि तुम ख मोरो नाम पर बपतिस्मा मिलो। ");
INSERT INTO hlb_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","अऊर हाव, मी न स्तिफनास को घराना ख भी बपतिस्मा दियो; इन ख छोड़ मी नी मालूम हैं कि मी न अऊर कोई ख बपतिस्मा दियो। ");
INSERT INTO hlb_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","काहेकि मसी न मोखा बपतिस्मा देन ख नी, पर सुसमाचार सुनान ख भेजो हैं, अऊर यू भी मनुस्य को वचन हुन ख ग्यान को अनुसार नी, असो नी होय कि मसी ख सूली बेकार ठहरे। ");
INSERT INTO hlb_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","काहेकि सूली कि कथा बेकार होन वाला का लाने मूर्ख आय, पर हम उध्दार पान वाला का लाने परमेस्वर कि सक्ति आय। ");
INSERT INTO hlb_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","काहेकि लिखो हैं, “मी ग्यान हुन ख ग्यान ख बेकार करू, अऊर ग्यान कि समझ ख बेकार कर दा हूँ।” ");
INSERT INTO hlb_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","कहाँ रयो ग्यानवान? कहाँ रय्हो सासतिरी? कहाँ रयो यू दुनिया को लड़ाई हन? का परमेस्वर न दुनिया को ग्यान ख मूर्ख हुन नी ठहरायो। ");
INSERT INTO hlb_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","काहेकि जब परमेस्वर ख ग्यान को जसो दुनिया न ग्यान से परमेस्वर ख न जानो, ते परमेस्वर ख यू अच्छो लगो कि यू प्रचार कि मुर्ख हुन ख व्दार विस्वास करन वालो ख उध्दार दे। ");
INSERT INTO hlb_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","यहूदी ते चिन्ह माँग हैं, अऊर यूनानी ग्यान कि खोज म आयो, ");
INSERT INTO hlb_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","अऊर हम ख ते ओकी सूली पर चढ़ायो हुयो ख मसी को प्रचार करिये हैं, जे यहूदी हुन ख लाने ठोकर को लाने अऊर गैर यहूदी हुन ख का लाने मूर्खाता हैं; ");
INSERT INTO hlb_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","अऊर जो बुलायो हुयो हैं, का यहूदी का यूनानी, उनको नजीक मसी कि सक्ति अऊर परमेस्वर को ग्यान हैं। ");
INSERT INTO hlb_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","काहेकि परमेस्वर कि मुर्खता बेकार अदमी हुन ख ग्यान वान से समझ दार हैं, अऊर परमेस्वर कि कमजोर अदमी हुन को ताकत से बेजा सक्ति साली हैं। ");
INSERT INTO hlb_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","अरे भई हुन, अपनो बुलाए हुन जान ख ते सोच कि नी सरीर ख अनुसार बेजा ग्यान वान, अऊर नी बेजा सक्ति, अऊर नी बेजा अच्छो ख खानदार बुलायो गयो। ");
INSERT INTO hlb_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","अदि परमेस्वर न दुनिया ख मुर्ख हुन ख चुन लियो हैं कि ग्यान हुन ख लज्जित करे, अऊर परमेस्वर न दुनिया को कमजोर हुन ख छाट लियो हैं कि सक्तिसाली हुन ख लज्जित करे; ");
INSERT INTO hlb_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","अऊर परमेस्वर न दुनिया को नीच हुन अऊर बेकार काम हुन ख, अदि जे हता भी नी उन ख भी चुन लियो कि उन ख जो हैं, बेकार खड़ो करा हैं। ");
INSERT INTO hlb_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","काहेकि जे कोई इंसान हुन परमेस्वर का नजीक घमण्ड नी कर सक। ");
INSERT INTO hlb_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","अदि ओकी कि ओर से तुम मसी यीसु म हैं, जे परमेस्वर कि ओर से हमारो लाने ग्यान वान रयो हैं, अदि धार्मिक, अऊर सुध्दता करे, अऊर छुटकारा; ");
INSERT INTO hlb_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","काहेकि जसो लिखो हैं, वसो ही हो, “जे घमण्ड करे उ प्रभु म घमण्ड करे।” ");
INSERT INTO hlb_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","भई अर बहिन हुन, ते मी परमेस्वर ख भेद सुनाते भयो तुमारो नजदीक आयो, ते वचन हुन या ग्यान कि उतमता का संग नी आयो। ");
INSERT INTO hlb_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","काहेकि मीन यू फैसला लियो हतो कि तुमारो बीच यीसु मसी पर सूली पर चढ़ायो हुयो मसी ख छोड़ अऊर कई बात ख नी जान। ");
INSERT INTO hlb_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","मी कमजोर हुन अऊर डर ख संग, अऊर बेजा घबराते हुयो तुमारो संग रयो; ");
INSERT INTO hlb_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","अऊर मोरो वचन, अऊर मोरो प्रचार म ग्यान कि लालच वाली बात हुन नी हैं, पर आत्मा अऊर सक्ति को नमस्कार हतो, ");
INSERT INTO hlb_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","एकोलाने कि तुमारो भरोसा अदमी हुन का ग्यान पर नी, पर परमेस्वर कि सक्ति पर निर्भर होय हैं। ");
INSERT INTO hlb_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","फिर भी सिध्द अदमी हुन म हम ग्यान सुनत हैं; अऊर यू दुनिया को अऊर यू दुनिया नास होन वाला अदमी हुन मुखिया हुन ख ग्यान नी हैं; ");
INSERT INTO hlb_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","पर हम ख परमेस्वर को उ छुपो ग्यान, भेद कि रीत रीवज पर बताये हैं, जसो परमेस्वर न सनातन युग से हमारी महिमा का लाने ठहरायो गयो हतो। ");
INSERT INTO hlb_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","जे से यू दुनिया को मुखिया हुन म से कोई न नी जानो, काहेकि यदि वी जान हैं ते महिमामय प्रभु ख सूली पर नी चढ़ा तो। ");
INSERT INTO hlb_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","अदि जसो लिखो हैं, “जो बात हुन आँखी न नी देख अऊर कान न नी सुनी, अऊर जे बात हुन अदमी को मन म नी चढ़ी, वी ही आय जे परमेस्वर न अपनो प्रेम रखन वालो का लाने तैयार करो हैं।” ");
INSERT INTO hlb_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","परमेस्वर न अपनो आत्मा का व्दारा हम पर प्ररगट कियो, काहेकि आत्मा सब बात हुन पर परमेस्वर कि गहरी बात हुन भी परख हैं। ");
INSERT INTO hlb_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","अदमी हुन म से कोन कोई अदमी कि अधीन हुन जान हैं, अकेलो अदमी कि आत्मा जो ओ म हैं? वसो ही परमेस्वर कि बात हुन भी कोई नी जान, अकलो परमेस्वर को आत्मा। ");
INSERT INTO hlb_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","पर हम न दुनिया कि आत्मा नी, पर उ आत्मा पायो हैं जो परमेस्वर कि ओर से आय कि हम उन बात हुन ख जान सके कि जो परमेस्वर न हम ख दियो हैं। ");
INSERT INTO hlb_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","जे ख हम अदमी हुन को ग्यान कि सिखाई हुई बात हुन म नी हैं, पर आत्मा कि सिखाई हुई बात हुन मिल ख सुनाए हैं। ");
INSERT INTO hlb_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","पर दुनिया को अदमी हुन परमेस्वर कि आत्मा कि बात हुन मान नी करिये, काहेकि वी ओकी देखना म बेकार कि बात हैं, अर नी उ उन ख जान सक हैं काहेकि ओकी परख आत्मिक रीति से होए हैं। ");
INSERT INTO hlb_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","आत्मिक अदमी हुन सब कुछ जाँचा हैं, पर उ अपना खुद ख परख हुन नी जाहे हैं। ");
INSERT INTO hlb_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","काहेकि प्रभु को मन ख कोन जानो हैं “कि ओ ख सिखाव हैं? पर हम म मसी को मन आय।” ");
INSERT INTO hlb_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","अरे भई अर बहिन हुन म तुम से यू रिवाज से बात हुन नी कर सक। जसो आत्मिक अदमी हुन से, पर जसो दुनिया अदमी से, अर उनसे जो मसी म नानू हैं ");
INSERT INTO hlb_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","मी न तुम ख दूध पिलायो, खाना नी खिलायो; काहेकि तुम ओ ख नी खा सक्त हैं; पर तब तक भी नी खा सक्त हैं, ");
INSERT INTO hlb_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","काहेकि अब तक सारीरिक हैं। एकोलाने कि जब तुम म जलन अऊर लड़ाई हैं, ते का तुम सारीरिक नी हैं? अऊर का अदमी कि रिती रिवाज पर नी चल हैं? ");
INSERT INTO hlb_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","काहेकि जब एक बोल हैं, “मी पोलुस को आय” अऊर दूसरो, “मी अपुल्लोस को आय” ते का तुम सारीरिक नी आय? ");
INSERT INTO hlb_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","अपुल्लोस कोन आय? अऊर पोलुस कोन आय? अकलो सेवक, जीन ख व्दार तुम न विस्वास करियो हतो, ते हर एक ख प्रभु न दियो हतो। ");
INSERT INTO hlb_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","मी न रोपा लगायो, अपुल्लोस न ओ ख सीचो, अऊर परमेस्वर न बढ़ायो। ");
INSERT INTO hlb_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","एकोलाने नी ते लगानवालो कई हैं नी सीचने वालो, पर परमेस्वर ही सब कई आय जे बढ़ान वालो आय। ");
INSERT INTO hlb_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","लगान वालो अऊर सीचन वालो दूई एक ही आय; पर हर एक अदमी अपनो ही आराम को जसो ही अपनो मजदूरी पाहे। ");
INSERT INTO hlb_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","काहेकि हम परमेस्वर ख संग म काम करन आय हैं; तुम परमेस्वर कि खेती अऊर परमेस्वर की मन्दिर आय। ");
INSERT INTO hlb_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","परमेस्वर ख ओकी दया का अनुसार जो मोखा दियो गयो, मी न हुसयार मिस्री का सामने नीव डाली, अऊर दूसरो ओ पर पर रदा रख्य हैं पर हर एक अदमी हुसयार रैय कि उ ओ पर कसो रदा रख हैं। ");
INSERT INTO hlb_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","काहेकि वाह नीव ख छोड़ जो पड़ी हैं, अऊर उ यीसु मसी आय, कोई दूसरी नीव नी डाल नी सक आय। ");
INSERT INTO hlb_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","अदि कोई नीव पर सोना अऊर चाँदी अऊर बेजा किमती पत्थर अऊर काठ अऊर घास अऊर फूस को रदा रख्यो हैं, ");
INSERT INTO hlb_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ते हर एक ख काम दिख जा हे; काहेकि उ दिन ओ ख बताएगो, एकोलाने कि सामने का संग दिखो जाहे अऊर उ सामने हर एक ख काम कि परखो होय कि कसो हैं। ");
INSERT INTO hlb_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","जेको निर्मान को काम बनो रहे, ओ ख इनाम मिले। ");
INSERT INTO hlb_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","पर कोई को काम पानी जाहे, ते उ नुकसान उठा हे; पर उ खुद उध्दार जाहे पर जलते जलते बच जाएगो। ");
INSERT INTO hlb_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","का तुम ख नी पता हैं कि तुम परमेस्वर को मन्दिर आय, परमेस्वर को आत्मा तुम रवह हैं। ");
INSERT INTO hlb_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","पर कोई परमेस्वर को मन्दिर ख नास करे ते परमेस्वर ओ ख नास करे; काहेकि परमेस्वर को मन्दिर सुध्द आय, अऊर उ तुम आय। ");
INSERT INTO hlb_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","कोई अपनो स्वंय ख धोखा नी दे हैं। अदि तुम म से कोई यू दुनिया म अपनो स्वंय ख चलाक मान, हैं ते मुर्ख ओ ख हुसयार हो जा। ");
INSERT INTO hlb_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","काहेकि यू दुनिया को ग्यान परमेस्वर का पास बेकार हैं, जसो लिखो हैं, “उ ग्यान वान हुन ख उनकी चालाकी म फँस देव हैं,” ");
INSERT INTO hlb_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","अऊर फिर, “प्रभु चालाक हुन ख विचार हुन ख जान हैं कि वी बेकार हैं। ");
INSERT INTO hlb_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","एकोलाने अदमी हुन पर कोई घमण्ड नी कर, काहेकि सब कुछ तुमारो आय ");
INSERT INTO hlb_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","का पोलुस, का अपुल्लोस, का कैफा, का दुनिया को जिन्दगी, का माऊत, का जल्दी को बखत म, का जोतिस सब कुछ तुमारो आय, ");
INSERT INTO hlb_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","अऊर तुम मसी को आय, अऊर मसी परमेस्वर को आय।” ");
INSERT INTO hlb_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","अदमी हम ख मसी को दास अऊर परमेस्वर को छुपी बात का भण्डारी समझे। ");
INSERT INTO hlb_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","फिर यहाँ भण्डारी म बात हुन देखी जाहे। कि उ भरोसा लायक होय। ");
INSERT INTO hlb_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","पर मोरी देखन म यू बेजा छोटी सी हैं कि तुम अऊर अदमी हुन ख कोई सजा देनवालो मोखा जाचे, पर म खुद अपनो तुम ख नी परख हूँ हैं। ");
INSERT INTO hlb_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","काहेकि म मोरो मन मोखा कोई बात म दोसी नी ठहरा हैं, पर असो मी बेकसूर नी रयो हैं, काहेकि मोखा परख वालो प्रभु आय। ");
INSERT INTO hlb_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","एकोलाने जब तक प्रभु नी आये हे उ बखत से पहले कुई बात हुन ख फैसला नी करे उ अन्धकार कि छुपी बात हुन ज्योति म दिखाए, अऊर मन हुन ख अभिप्राय ख देखागो करेगों, तब परमेस्वर कि तरफ से हर एक कि स्वगत होय। ");
INSERT INTO hlb_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","हे भई हुन, मन यू बात हुन म तुमारो लाने अपनो अऊर अपुल्लोस ख खबर उदाहरन का रीति पर हैं, एकोलाने कि तुम हमारो व्दारा यू सिख कि किन लिखो हुयो से सामने बड़नो, अऊर एक का तरफ म अऊर दूसरो का खलाप म घमण्ड नी कर जे। ");
INSERT INTO hlb_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","काहेकि ते म अऊर दूसरो म कोन भेद करिये हैं? अर तोरो पास का हैं जो तुना (दूसरो से) नी पायो हैं, अर जब तू न दुसरो से पायो आय? ते असो घमण्ड काहे करिये हैं कि मानो नी पायो। ");
INSERT INTO hlb_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","तुम ते भरपूर हो चूको, तुम धनी हो चूको, तुम न हमारो बिना राज कियो; पर चोक्खो हो तो कि तुम राज करिये कि हम भी तुमारो संग राज करिये। ");
INSERT INTO hlb_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","मोरो समझ म परमेस्वर न हम ख प्रेरित हुन ख सब बाद उन अदमी हुन का सामे खड़ो करियो हैं, जिन की माऊत को हुकुम हो चुको हो; काहेकि हम दुनिया अऊर स्वर्गदूत हुन अऊर अदमी को लाने एक तमासा बने हैं। ");
INSERT INTO hlb_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","हम मसी का लाने बेकार हैं, पर तुम मसी म समझदार हैं; हम कमजोर हैं पर तुम ताकतवार हैं। तुम भीतर पाय हैं, पर हम अपमान हो हैं। ");
INSERT INTO hlb_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","हम यू बखत भी भूखा अऊर प्यासो अऊर नंगा हता, फटे पुराना कपड़ा पहन हैं, अऊर मार खायो हैं अऊर मारो-मारो फिर ये हैं; ");
INSERT INTO hlb_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","अऊर अपनो ही हात हुन से काम कर ख मेहनत करा हैं। अदमी हम बुरो बोल हैं, कि हम आसीस देव हैं; वी परेसान करिये हैं, हम सहन कर हैं। ");
INSERT INTO hlb_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","वी बदनाम करिये हैं, हम विनती करिये हैं। हम, आज तक दुनिया को कचरा अऊर सब सारी चीज हुन ख खुरचन का सामन रया हैं। ");
INSERT INTO hlb_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","मी तुम ख लज्जित करन का लाने यू बात हुन नी लिखु हैं, पर अपनो अच्छो पोरिया समझ ख तुम ख बताऊँ हैं। ");
INSERT INTO hlb_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","काहेकि यदि मसी म तुमारो सीखान वालो दस हजार भी हो, ते तब भी तुमारो बाप बेजा से नी; एकोलाने कि मसी यीसु म सुसमाचार ख व्दारा म तुमारो बाप हुयो हैं। ");
INSERT INTO hlb_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","एकोलाने म तुम से विनती करू हैं मोरी जसी चाल‍ चल। ");
INSERT INTO hlb_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","एकोलाने मन तीमुथियुस ख जो प्रभु म मोरो अच्छो दोस्त अऊर विस्वास लायक पोरिया हैं, तुमारो पास भेजो हैं। उ तुम ख यीसु मसी म मोरो आचरन याद करूँ, जसो कि म हर जगह हर एक कलीसिया म सिक्छा लाऊ। ");
INSERT INTO hlb_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","कई ते असा घुस्सा हो गयो हैं, मान कि म तुमारो नजीक आवन को नी हतो ");
INSERT INTO hlb_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","पर प्रभु न चाय्हो ते म तुमारो नजीक जल्दी ही आऊ, अऊर उन घुस्सा भेयो हुन का बात हुन ख नी, पर उनकी सक्ति ख समझ हैं। ");
INSERT INTO hlb_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","काहेकि परमेस्वर को राज बात हुन म नी पर सक्ति काम हुन म हैं। ");
INSERT INTO hlb_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","तू का चाय्हे हैं? का मी छड़ी लेख तुमारो पास आऊ, अऊर प्रेम अर दीनता कि आत्मा का संग म? ");
INSERT INTO hlb_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","यहाँ तक सूना म आयो हैं कि तुम म गलत काम होय हैं, पर असो गलत काम जो गैर यहूदी हुन म नी होय कि अदमी अपनो बाप कि घरवाली ख रख हैं। ");
INSERT INTO hlb_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","अऊर नाराज ते नी करिये, जे से असो काम करन वालो तुमारो बीच म से निकल जा हे, पर घमण्ड करिये हैं। ");
INSERT INTO hlb_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","मी ते सरीर न का भाव से दूर हतो, अऊर आत्मा का भाव से तुमारो संग हो ख मान कि उपस्थिति कि मजबूरी म असो काम करनवालो का बारा म यू फैसला दे चूको हूँ। ");
INSERT INTO hlb_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","कि जब तुम अऊर मोरी आत्मा, हमारो प्रभु यीसु कि सक्ति ख संग जमा हो, ते असो अदमी हमारो प्रभु यीसु को नाम से। ");
INSERT INTO hlb_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","उही अदमी ख सैतान को हात म दे दियो, जेख ओखा सरीर ख नास हो, अर प्रभु को दिन ओकी आत्मा को छुटकारा हो। ");
INSERT INTO hlb_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","तुमारो घमण्ड करनो अच्छो नी; का तुम नी जान की थोड़ो सो खमीर तीन दीन को गूँधो हुयो आटा ख खमीर कर दे हैं। ");
INSERT INTO hlb_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","पूरानो खमीर रोटी निकाल ख अपनो तुम ख सुध्द कर कि नयो गूँधो हुयो आटा बना जाय; काहे कि तुम अखमीरी आय काहेकि हमारो भी फसह जो मसी हैं, जो बलिदान हुयो हैं। ");
INSERT INTO hlb_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","एकोलाने आ, हम तेवर दिन म खुसी माना, नी ते पुरानो खमीर अऊर नी बुराई अऊर दुसमन हुन को खमीर से, पर सीधाई अऊर सही कि अखमरी रोटी से। ");
INSERT INTO hlb_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","मीन अपनी चिठ्टी म तुम ख लिखो हैं कि बुरो काम हुन का संग मेल जोल नी रख। ");
INSERT INTO hlb_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","यी जरूरी नी कि तुम बिल्कुल यी दुनिया का बुरो काम करन वाला हुन अऊर लालच हुन, अऊर अन्धेरा करन वालो, अऊर मूर्ति पूजा हुन कि संग म नी रह जो, काहेकि यू मजबूरी म ते तुम ख दुनिया म से निकल जानो ही पड़ हैं। ");
INSERT INTO hlb_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","पर मोखा यू बोलनू हैं कि पर कोई भई बोल-ख बुरो काम, अऊर लाची, अऊर मूर्ति पूजा क हुन अऊर गाली देनवालो, अऊर पियक्कड़ अऊर अन्धेर करन वालो होय, ते ओकी संग म नी रह पर अदमी ख संग खाना भी नी खा। ");
INSERT INTO hlb_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","काहेकि मोखा बाहार वाला का फैसला करना से का काम? का तुम भीतर वाला हुन का फैसला नी करिये? ");
INSERT INTO hlb_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","पर बाहर वाला हुन कस फैसला परमेस्वर करिये हैं। एकोलाने ओकी कुकर्मी ख अपनो बीच म से निकाल दे। ");
INSERT INTO hlb_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","का तुम से कुई ख यी याद हैं कि जब दूसरो ख संग झगड़ा होय हैं ते फैसला ख लाने अधर्मी को काम कर वालो हुन का पास जाहे अऊर सुध्द अदमी हुन का नजीक नी जाय हे? ");
INSERT INTO hlb_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","का तुम नी जानत आय कि सुध्द लोग दुनिया को फैसला करे? एकोलाने जब तुम दुनिया को फैसला करनो हैं, ते का तुम छोटा से छोटा लड़ाई हुन को भी निर्णय करन का लायक भी नी हैं? ");
INSERT INTO hlb_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","का तुम नी जान कि हम स्वर्गदूत हुन को फैसला करे? ते का जमाना कि बात हुन को फैसला नी करे। ");
INSERT INTO hlb_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","पर तुम ख जमाना कि बात हुन का फैसला करनो होय, ते का उन्ही का बैठा हे जे कलीसिया म कुछ नी समझे जाय हे? ");
INSERT INTO hlb_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","मी तुम ख लज्जा आवन का लाने यू कहूँ हैं। का सच म तुम म एक भी समझदार नी मिल हैं, जो अपनो भई हुन ख फैसला कर सके? ");
INSERT INTO hlb_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","तुम म भई-भई म मुकदमा होय हैं, अऊर उ भी अविस्वास हुन का सामने। ");
INSERT INTO hlb_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","पर सही म तुम म बड़ो दोस ते यू हैं कि आपस म फैसला करिये हैं, जसो अन्याय काहे नी सह हैं? पर अपनी हानि काहे नी सह हैं? ");
INSERT INTO hlb_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","पर तुम ते स्वंय जुम करिये हैं अऊर हानि देवा हैं, अऊर उ भी भई हुन ख। ");
INSERT INTO hlb_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","का तुम नी जान हैं कि अधर्मी को काम करन वालो अदमी परमेस्वर का राज ख अधिकारी नी होय? धोखा नी खा; नी छिनाला करन वालो (न वेस्यागामी), नी मूर्ति पूजक हुन, नी बुरो काम करन वालो, नी पुरूसगामी, ");
INSERT INTO hlb_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","नी चोर, नी लोभी, नी पियक्कड़ नी गाली देन वालो नी लुट पाट करन वालो परमेस्वर का राज ख अधिकारी नी होय। ");
INSERT INTO hlb_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","अऊर तुम म से कितना असो भी हता, पर तुम प्रभु यीसु मसी का नाम से अऊर हमारो परमेस्वर का आत्मा से धोए गयो अऊर सुध्द हुयो अऊर धर्मी रया। ");
INSERT INTO hlb_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","सब चीज मोरो लाने ठीक हैं, पर सब चीज हुन लाभ कि नी हैं, सब चीज हुन मोरो लाने ठीक हैं, पर मी कुई भी बात का बस नी होऊ। ");
INSERT INTO hlb_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","कोई यू भी कहे, “अऊर खानो पेट का लाने हैं अऊर पेट खानो का लाने।” हाव पर परमेस्वर दोई ख खत्म कर दे हे। सरीर गलत काम का लाने नी, पर प्रभु को लाने हैं अऊर प्रभु सरीर को लाने। ");
INSERT INTO hlb_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","परमेस्वर न अपनी सक्ति से प्रभु ख जिन्दो करिये, अऊर हम ख भी जीवित करे। ");
INSERT INTO hlb_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","का तुम नी जाना कि तुमारो सरीर मसी को अंग आय? ते का म मसी को सरीर ले ख उन ख छिनाला पना हुन को जीवन बनाऊँ? कभी नी। ");
INSERT INTO hlb_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","का तुम नी जिन्दगी कि जो कोई गलत काम से रह हैं, उ ओखा संग एक सरीर हो जाहे हैं? काहेकि लिखो हैं: “वी दूई एक तन होए।” ");
INSERT INTO hlb_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","अऊर जो प्रभु कि भक्ति म रह हैं, उ ओखा संग एक आत्मा हो जाए हैं। ");
INSERT INTO hlb_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","गलत काम से बचो रह, जितनो भी पाप अदमी करिये हैं वी जीवन का बाहर ही हैं, पर सरीर गलत काम करन वाला अपनी ही जीवन का विरोध पाप करिये हैं। ");
INSERT INTO hlb_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","का तुम यू नी मालूम हैं कि तुमारो सरीर सुध्द आत्मा को मन्दिर आय, जो तुम म बसो भयो हैं अऊर तुम ख परमेस्वर कि तरफ से मिलो हैं; अऊर तुम अपनो नी हैं? ");
INSERT INTO hlb_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","काहेकि तुम लोग पैसा देख ख खरीदो लियो गयो हैं, एकोलाने तुम लोग अपनो सरीर ख दुवारा परमेस्वर कि बड़ाई करे। ");
INSERT INTO hlb_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","इन बात हुन का बारा म जो तुम न लिखो, यू चोक्खो हैं कि अदमी ओरत ख नी छू। ");
INSERT INTO hlb_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","अदि गलत काम का डर से हर एक अदमी कि घरवाली, अऊर हर एक ओरत को घरवालो होय। ");
INSERT INTO hlb_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","घरवालो अपनी घरवाली को हक पूरो करे; अऊर असो ही घरवाली भी अपनो घरवालो को। ");
INSERT INTO hlb_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","घरवाली ख अपनी सरीर पर अधिकार नी पर ओको घरवालो कि अधिकार हैं; असो ही घरवालो को भी अपनी जीवन पर अधिकार नी हैं, पर घरवाली को हैं। ");
INSERT INTO hlb_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","तुम एक दूसरा से दूर मत रह; मगर केवल थोड़ी देर बखत तक आपस की मर्जी से कि प्रार्थना का लाने जोतिस बतान मिले, अऊर फिर एक संग रय्हे; असो नी हो कि तुमारो उपस्ति नी रहना का सैतान तुम ख जाँचे। ");
INSERT INTO hlb_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","अगर मी जो यी कहूँ हैं वी अनुमती हैं नी कि कय्हे। ");
INSERT INTO hlb_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","मी यी चाहूँ हैं कि जसो म हूँ, असो ही सारा अदमी हो; अगर हर एक ख परमेस्वर कि तरफ से खास खास वरदान मिलो हैं; कोई ख कई तरीका को, अर कई को अर तरका को। ");
INSERT INTO hlb_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","अगर मी जेका सादी सूदा हुन वाला हुन अर बुरो काम हुन का बारा म कहूँ हैं कि उनका लाने असो ही रह नो चोक्खो हैं, जसो मी हूँ। ");
INSERT INTO hlb_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","अगर यदि वी स्वंय नी कर सके, ते सादी करे: काहेकि सादी करूँ कामातुर रहनु से चोक्खो हैं। ");
INSERT INTO hlb_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","जीन को सादी हो गयो हैं, उनको मी नी, पर प्रभु हुकुम देवह हैं कि घरवाली अपनो घरवालो से दूर नी हो ");
INSERT INTO hlb_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","अर अगर दूर भी हो जाहे ते बिना दूसरो सादी कियो रह; या अपनो घरवालो से फिर मेल कर ले अर नी घरवालो अपनी इ घरवाली ख छोड़। ");
INSERT INTO hlb_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","दूसरा से प्रभु नी अगर म ही कहूँ हैं पर कई भई की घरवाली भरोसा नी रखे हो अर ओखा संग रहना से खुसी हो, ते उ ओ ख नी छोड़। ");
INSERT INTO hlb_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","यी पोरी को घरवालो विस्वास नी रख हो, अर ओखा संग रहना से खुसी हो; उ घरवालो ख नी छोड़। ");
INSERT INTO hlb_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","काहेकि असा पति जो विस्वास नी रखा हो, उ पत्नी को कारन सुध्द रवह हैं; अर असी पत्नी जो विस्वास नी रखा, पति का कारन सुध्द रवह हैं; नी ते तुमारो पोरा पारी असुध्द रवह हैं, अगर अब ते सुध्द हैं। ");
INSERT INTO hlb_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","अगर जो अदमी विस्वास नी रख, हैं पर उ अलग होव हैं ते अलग हो दूई, असी मजबूरी म कई भई या बहिन बन्धन म नी। परमेस्वर न हम ख मेल मिलाप का लाने बुलायो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","काहेकि हे पोरी, तू का मालू हैं कि तू अपनो घरवालो को उध्दार करा दे? अर हे अदमी, तो का मालू हैं तू अपनी घरवाली को उध्दार करा दे हे? ");
INSERT INTO hlb_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","जसो प्रभु न हर एक ख बाँटो हैं, अर जसो परमेस्वर न हर एक क पुकार हैं, असो ही उ चलो। म सारी कलीसिया हुन म असो ही ठहराऊ हैं। ");
INSERT INTO hlb_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","जो पूजा देनु कियो भेयो ख बुलायो गयो हैं, उ पूजा देनु (खतना रहित) नी बनो। जो बिना खतनाराहित बूलायो गयो हैं; उ खतना नी करिये। ");
INSERT INTO hlb_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","नी तो खतना कुछ हैं अर नी खतना रहित, पर परमेस्वर कि आदेस हुन ख मान ही सब कुछ हैं। ");
INSERT INTO hlb_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","हर एक अदमी जी मजबूरी म बुलायो गयो हैं ओ म ही रह। ");
INSERT INTO hlb_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","पर तू दास कि मजबुरी म बुलायो गयो हैं, ते चिन्ता नी कर; अगर यदि तू आजाद हो सके, ते असो ही काम कर। ");
INSERT INTO hlb_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","काहेकि जो गुलाम कि मजबूरी म प्रभु बुलायो गयो हैं, उ प्रभु स्वागत कियो भेयो हैं असो ही जो आजाद की मजबूरी म बुलायो गयो हैं, उ मसी को दास आय। ");
INSERT INTO hlb_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","तुम ख दाम दे ख खरीद लियो गयो हैं; अदमी हुन का दास नी बन। ");
INSERT INTO hlb_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","अरे भई बहिन, जो कोई जी दसा म बुलायो गयो हैं; उ ओ म ही परमेस्वर को संग रह। ");
INSERT INTO hlb_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","कुँवारी हुन का बारा म प्रभु की कोई कहना मोखा नी मिली, पर विस्वास योग्य होन का लाने जसो दया प्रभु न म पर कि हैं, ओखा अनुसार सम्मति दे हूँ। ");
INSERT INTO hlb_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","एकोलाने मोरी समझ म यू चोक्खो हैं कि आज कल दुख का कारन, अदमी जसो हैं असो ही रह। ");
INSERT INTO hlb_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","पर तोरी घरवाली आय, ते ओ ख दूर होन या तलाक कि कोसिस मत कर; अर अगर तोरी घरवाली नी, ते घरवाली की ढूँन मत। ");
INSERT INTO hlb_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","पर अदि तू ब्याह भी करे, ते पाप नी; अर अदि कुंवारी बयाही जाहे ते कोई पाप नी। पर असो को सारीरिक दुख होए, अर म बचनो चाहूँ हैं। ");
INSERT INTO hlb_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","हे भई हुन, म यी कहू हैं कि बखत कम कर दियो गयो हैं, एकोलाने चाहिए कि जीन की घरवाली होए, वी असो ही मानो उन कि घरवाली नी हो: ");
INSERT INTO hlb_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","अर रोन वाला असो होए, मानो खुसी नी करिये; अर मोल लेन वालो असो होए, मानो ओखा पास कुछ हैं ही नी। ");
INSERT INTO hlb_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","अर यी दुनिया का संग व्यवहार करन वालो असो हो, कि दुनिया ही को नी हो ले; काहेकि यी दुनिया की रीति रीवाज अर व्यवहार बदल जाहे हैं। ");
INSERT INTO hlb_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","अब म यी चाहूँ हैं कि तुम ख चिन्ता न हो। जेन कि सादी नी भई (अविवाहित) अदमी प्रभु कि बात हुन की चिन्ता म रय्हे हैं कि प्रभु ख कसो खुस रखू। ");
INSERT INTO hlb_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","पर जीन कि सादी हो गई (विवाहित) अदमी दुनिया कि बात हुन कि चिन्ता म रय्हे हैं कि अपनी घरवाली ख किस तरका से खुस रखू। ");
INSERT INTO hlb_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","जीन कि ब्याह होए (विवाहित) अर जीन कि ब्याह नी भई ओ म भी कुछ पाप हैं: जीन की ब्याह नी भई उ प्रभु कि म रय्हे हैं कि उ सरीर अर आत्मा दूई म सुध्द होए, पर जीन की ब्याह होऐ दुनिया कि आसा म रय्हे हैं कि अपनो घरवालो ख कसो खुस रखू। ");
INSERT INTO hlb_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","मी यू बात तुमारो ही फयदा का लाने कहूँ हैं, न कि तुम ख फँसान का लाने, पर एकोलाने कि जसो सोभा देव हैं, वसो ही कियो जाहे, कि तुम एक मन हो ख प्रभु कि सेवा म लगो रह। ");
INSERT INTO hlb_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","अगर कुई यी जरूरी नी समझ कि म अपनी वा कुंवारी को हक्क माँग रय्हे हूँ, जेकी जवानी बुडी हो गई हैं, अर जरूत भी होए, ते जसो चाय्हे वसो कर, इन म पापी नी, उ ओको ब्याह होन दे। ");
INSERT INTO hlb_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","पर जो मन म फैसला रह हैं, अर ओ ख जरूत नी होए, अगर अपनी इच्छा पर अधिकार रख हैं, अर अपनो मन म यी बात ठान ली हैं कि उ अपनी कुंवारी पोरी कि ब्याह नी करिये, उ अच्छो करिये हैं। ");
INSERT INTO hlb_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","एकोलाने जो अपनी कुंवारी ख ब्याह कर दे हैं, उ चोक्खो करिये हैं, अर जो ब्याह नी करिये दे, उ अर भी चोक्खो करिये हैं। ");
INSERT INTO hlb_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","तब तक कोई ओरत की घरवालो जीवित रय्हे हैं, तब तक उ ओ से बन्धी भई हैं; अगर पर कको घरवालो मर जाहे ते जे से चाय्हे सादी कर सक हैं, अदि केवल प्रभु म। ");
INSERT INTO hlb_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","अदि जसी हैं वसी ही रय्हे, ते मोरो खयाल म अऊर भी चोक्खो हैं; अऊर मी समझू हैं कि परमेस्वर को आत्मा मोरो म भी हैं। ");
INSERT INTO hlb_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","अब मुर्ति हुन का सामने चढ़ाई ख हुई चीज हुन का बारा म हम जान हैं कि हम ख सब को समझ हैं। समझ घमण्ड पैदा करिये हैं, अऊर प्रेम से पैदा होय हैं। ");
INSERT INTO hlb_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","अदि कोई समझ कि म कुछ जानु हैं, ते जसो जानो चाहिए हैं वसो अब तक नी जान हैं। ");
INSERT INTO hlb_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","अदि कोई परमेस्वर से प्रेम रख हैं, ते परमेस्वर ओ ख जान हैं। ");
INSERT INTO hlb_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","अब मुरती हुन का सामने चढ़ाई हुई चीज हुन ख खान का बारा म हम जान हैं कि मुर्ति दुनिया म कुई चीज नी हैं, अऊर एक ख छोड़ अऊर कई भी परमेस्वर नी हैं। ");
INSERT INTO hlb_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","अदि आकास म अऊर धरती पर बेजा से प्रभु कह हैं जसो कि बेजा से ईस्वर अऊर बेजा से प्रभु हैं। ");
INSERT INTO hlb_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ते भी हमारो लाने ते एक ही परमेस्वर हैं: अदि बाप जेकी ओर से सब चीज हुन हैं, अदि यीसु मसी जेका दुवारा सब चीज हुन हुई, अऊर हम भी ओखा को दुवारा हैं। ");
INSERT INTO hlb_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","पर सब ख यू ग्यान नी हैं, कि कुछ ते अब तक मुरती ख कुछ समझन का कारन मूर्ति हुन का सामने चढ़ाई हुई चीज ख कुछ समझ ख खाऐ हैं, अऊर ओखा समझ कमजोर होन का कारन खराब होय गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","खाना हम ख परमेस्वर का निकट नी पहुँच हैं। पर हम नी खाएँ ते हमारो कुछ नुकसान नी हैं, अऊर पर खाएँ ते कुछ फायदा नी हैं। ");
INSERT INTO hlb_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","अदि सतरक रैय, असो नी होय कि तुम हमारो यू आजादी कही कमजोर हुन का लाने ठोकर को कारन नी हो जाहे। ");
INSERT INTO hlb_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","काहेकि पर कोई तोखा ग्यानी को मूर्ति ख मन्दिर म खाते देख अऊर उ कमजोर अदमी होय, ते का ओको विवेक को मूर्ति का सामने चढ़ाई हुई चीज खान ख हिम्मत नी होय हैं ");
INSERT INTO hlb_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","यीई रीति रिवाज से तोरो ग्यान का कारन उ कमजोर भई जेका लाने मसी मरा नास हो जाहे। ");
INSERT INTO hlb_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ते भई बहिन हुन का विरोध पाप करन से अऊर उन ख कमजोर समझ ख चोट देन से, तुम मसी का विरोध पाप करिये हैं। ");
INSERT INTO hlb_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","यू ईच कारन अदि खाना मोरो भई ख ठोकर खिलाएँ हैं, ते म कभी कुई रीति रिवाज से मांस नी खाऊँ हैं, नी होय कि म अपनो भई का ठोकर ख कारन बन जाऊ। ");
INSERT INTO hlb_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","का म आजाद अदमी नी हूँ? का म प्रेरित नी? का तुम मीन प्रभु यीसु ख को जे हमारो प्रभु आय, नी देख? का तुम प्रभु म मोरो बनयो हुयो नी हैं? ");
INSERT INTO hlb_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","अदि मी दूसरो को लाने प्रेरित नी आय, ते तुमारो लाने ते आय; काहेकि तुम प्रभु म मोरो सिखावन पर चिखान आय। ");
INSERT INTO hlb_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","जो अदमी हुन मोखा परख हैं, उनको लाने यू मोरो कहना हैं। ");
INSERT INTO hlb_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","का हम ख खान पीवन को अधिकार भी नी आय? ");
INSERT INTO hlb_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","का हम ख यू भी अधिकार नी आय, कि कई मसी बहिन हुन का संग सादी कर ख ख ओ ख लाने घूमे, जसो दूसरो प्रेरित अऊर प्रभु का भई अऊर कैफा करिये हैं? ");
INSERT INTO hlb_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","का मी अऊर बरनबास ही अपनो जिन्दगी निर्वाह का लाने काम करन ख रुकवाट हैं। ");
INSERT INTO hlb_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","का यू कभी सुननो म आयो कि कुई अपनो पैसा खर्च ख सेना म सेवा कर हैं? कोन अंगूर कि बारी लगा ख ओको फल नी खाय हैं? कोन पालतू ढोर पाल ख उन ढोर हुन को दूध नी पीवा हैं? ");
INSERT INTO hlb_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","वी मी साधो जीवन को उदाहरन को आधार पा ही नी कह रहे हूँ बल्कि नेम भी उही कहत हैं। ");
INSERT INTO hlb_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","का नेम भी यीई नी कय्हे? काहेकि मूसा को नेम म लिलो हैं, “दावन करते बखत चलते हुए बईल को मुण्डो मत बाँन्धजे।” का परमेस्वर बईल हुन ही कि चिन्ता करिये हैं? ");
INSERT INTO hlb_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","या खास कर ख हमारो लाने कहूँ हैं। हाँव, हमारो लाने ही लिखो गयो, काहेकि जरूरी हैं कि जोतन वालो आसा से जोत अऊर दाँवन वालो सामिल होन की आस से दाँवनी करे। ");
INSERT INTO hlb_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","अब जब तक हम न तुमारो लाने आत्मिक चीज हुन बोई हैं, ते का यी कोई बड़ी बात हैं कि तुमारो सारीरिक चीज हुन की फसल काटे। ");
INSERT INTO hlb_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","जब दूसरा अदमी हुन को तुम पर यू अधिकार हैं, ते का हमारो सामिल होने ये से बेजा जादा अधिकार नी होए? पर हम ख यी अधिकार काम म नी लाजो; अऊर सब कुछ सहन करिये हैं कि हमारो अर मसी को सुसमाचार म कुछ रोकवाट नी होय। ");
INSERT INTO hlb_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","का तुम अदमी यू नी जान हैं कि मन्दिर म देख भाल करन वाला हुन ख मन्दिर से खाना मिल हैं अऊर वेदी कि देख भाल करन वाला वेदी का चढ़न का हिस्सा दार हैं। ");
INSERT INTO hlb_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","यी ही रीति से प्रभु न भी आग्या दियो कि जो लोग सुसमाचार सुनात हैं, कि उनकी जीविका को सुसमाचार से होय हैं। ");
INSERT INTO hlb_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","पर मी इन म से कुई ख भी बात काम म नी लायो, अऊर मीन ते यी बात हुन एकोलाने नी लिखी हैं, कि मोरो लाने असो करियो जाय कि, काहे कि यी से ते मोरो मरनो ही अच्छो हैं कि कोई मोरो घमण्ड ख बेकार खड़ो करे। ");
INSERT INTO hlb_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","अगर म ससुमाचार सुनाऊ, ते मोरो लाने कुछ घमण्ड की बात नी हैं; काहेकि यी ते मोरो लाने जरूत हैं। अगर म सुसमाचार नी सुनाऊ, ते म पर धितकार! ");
INSERT INTO hlb_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","अदि मी अपनो विस्वास से से यू करू हैं, ते मोखा इनाम को अधिकार होय। अर म अपनी मर्जी से यू नी करू हैं। मोखा जे काम दियो गयो हैं, म ओ ख पूरो करूँ हैं। ");
INSERT INTO hlb_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ते मोरो कोन सी मजदूरी आय? कि यी ससुमाचार सुनाऊ म कि म मसी को सुसमाचार कर दूँ यहाँ तक सुसमाचार म जो मोरो अधिकार हैं ओ ख भी म पूरी रीति से काम म नी लाऊ। ");
INSERT INTO hlb_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","काहेकि सब से स्वतरत होना पर भी मन अपनो तुम ख सब का दास बना दियो हैं कि ढ़ेर सारो अदमी हुन ख खीच लाऊ। ");
INSERT INTO hlb_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","मी यहूदी हुन का लाने यहूदी बनो कि यहूदी हुन ख खीच लाऊ। जो अदमी नियम हुन का बस हैं ओखा लाने म नियम, ख बस नी होनू पर भी नेम का बस बन कि उनको जो नियम को बस हैं, खीच लाऊ। ");
INSERT INTO hlb_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","जो अदमी नेम का बस नी हैं, उन ख हासिल करन को लाने मी उनको जसो बिन व्यवस्था को पापी बनीयो, फिर भी मसी की व्यवस्था को बस म होन को वजेसे मी हकीगत म परमेस्वर की व्यवस्था से आजाद नी भयो हैं। ");
INSERT INTO hlb_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","म कमजोर हुन ख लाने कमजोर जसो बनो कि कमजोर हुन ख खीच लाऊ। म सब अदमी हुन का लाने सब कुछ बनो हैं कि कुई न कोई रीति से कुई एक को उध्दार कराऊँ। ");
INSERT INTO hlb_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","मी यू सब कुछ सुसमाचार का लाने करू हैं कि अऊर हुन का संग ओखा सामिल हो जाऊ। ");
INSERT INTO hlb_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","का तुम नी जाना की दऊड म तो दऊडा सब ही हैं, पर इनाम एक ही ले जावा हैं? तुम वसो ही दऊडो की जीते। ");
INSERT INTO hlb_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","सब प्रतियोगी हर बात म संयम रखह हैं। वी मुरझान वालो मुकुट पावन को लाने असो करह हैं, जब कि हम अविनासी मुकुट को लाने। ");
INSERT INTO hlb_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","एकोलाने म ते यू इच्छा से दऊड हूँ, पर इच्छा ही से नी; म भी यी इच्छा से मुकूट हुन से लूड़ हूँ, पर ओखा सामने नी जो हवा पीट हैं हुई लड़ हैं। ");
INSERT INTO hlb_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","अदि म अपनी सरीर ख मार कूट अऊर बस म लाऊ हैं, असो नी होय कि उ दूसरा ख प्रचार करन म स्वंय ही कोई रिती से बेकार हो। ");
INSERT INTO hlb_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","अरे भई बहिन हुन, म नी चाहूँ कि तुम यी बात से अनजान रय्हे कि हमारो सब बापदादा बदल का नीचु हता, अऊर पूरा का पूरा समुंदर का बीच से निकल गयो, ");
INSERT INTO hlb_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","अऊर पूरा हुन न बदल म अऊर समुंदर हुन म, मूसा ख अनुवाई को रूप म बपतिस्मा लियो हैं; ");
INSERT INTO hlb_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","अऊर सब हुन न एक ही आत्मिक खान खायो; ");
INSERT INTO hlb_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","अऊर सब हुन न एक ही आत्मिक पानी पीयो हैं, काहेकि वी वाह आत्मिक घाट हुन से पीवा हता जो ओखा संग संग‍ चलत भी हता, अऊर उ घाट मसी हतो। ");
INSERT INTO hlb_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","अदि परमेस्वर उन न से पूरा हुन से खुस नी भयो, काहेकि वी जंगल म मर गया। ");
INSERT INTO hlb_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","यी बात हुन हमारो लाने उदाहरन रयो हैं, कि जसो उन न लालच करियो, वसो ही हम न भी बेकार चीज हुन ख लालच नी कर।; ");
INSERT INTO hlb_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","अऊर नी तुम मूर्ति पूजा हुन बन, जसो कि ओमा से कि कई किता बन गया भी हैं, जसो लिखो हैं, “अदमी खा पीवन बैठ, अऊर आनन्द मानन को लाने उठे।” ");
INSERT INTO hlb_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","अऊर नी हम ख गलत काम कर, जसो उन म से कई न कियो; अऊर एक दिन म तेईस हजार मर गया हता। ");
INSERT INTO hlb_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","अऊर नी हम प्रभु मसी ख परखा, जसो कुछ लोग हुन करियो, अऊर साँप हुन को कटने अऊर नास करियो गयो। ");
INSERT INTO hlb_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","अऊर नी तुम कुड़ हुन, जसो रिती से उन न मन से कई कुड़ कुड़ाए अऊर खत्म करन वालो ख अर दूत न उनख खत्म कियो गयो। ");
INSERT INTO hlb_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","यी सब उदारन जसो रूप म उन पर गुजरो अऊर हम ख चेतावनी देन का लाने लिखो गयो हैं, जे दुनिया का अन्त म विधमान हैं। ");
INSERT INTO hlb_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","एकोलाने जो समझ हैं, “मी पक्को हूँ,” उ हुसयार रैय कि कही गिर नी पड़े। ");
INSERT INTO hlb_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","तुम कई असी परीक्छा म नी पड़ो, जो अदमी ख सहन से बाहर हैं। परमेस्वर विस्वास लायक हैं अऊर उ तुम ख सक्ति से बाहर परीक्छा म नी पड़न दे, पर परीक्छा का संग निकास भी करे कि तुम, सहन सके। ");
INSERT INTO hlb_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","उ ईच ही कारन, अरे मोरो प्यारो, मूर्ति पूजा से बचो रैय। ");
INSERT INTO hlb_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","म तुम लोग हुन ख समझदार जानु ख यू बोल रयो हूँ। तुम स्वंय मोरी बात हुन पर सलाह कर। ");
INSERT INTO hlb_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","उ धन्यवाद को कटोरा, जे पर हम धन्यवाद करिये हैं, का मसी को खून को सहभागी नी हैं? का वा रोटी जेख हम तोड़ हैं, हम ख मसी की सरीर की सह भागी नी हैं? ");
INSERT INTO hlb_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","एकोलाने कि एक ही रोटी हैं ते हम भी जो बेजा सारी हैं, एक ही सरीर हैं; काहेकि हम पूरा ओ म कि ही एक रोटी म सामिल भैय्या हैं। ");
INSERT INTO hlb_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","जो जिन्दगी का भाव से इस्राएली आय, उन ख देख: का बलिदान हुन को खान वालो वेदी का संग म भाग नी हैं? ");
INSERT INTO hlb_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","फिर मी का कहूँ हैं? का यू कि मुरती पर चढ़ायो गयो बलि दान कुछ हैं, अर मुरती कुछ हैं? ");
INSERT INTO hlb_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","नी, पर यू कि गैर यहूदी जे बलिदान करियो हैं; वी परमेस्वर को लाने नी पर दुस्टात्मा हुन को लाने बलिदान करिये हैं अऊर म नी चाहूँ कि तुम दुस्टात्मा हुन का संग हो। ");
INSERT INTO hlb_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","तुम प्रभु को कटारा अऊर दुस्टात्मा हुन का कटारा दूई म से नी पी सक हैं। तुम प्रभु कि मेज अऊर दुस्टात्मा हुन कि मेज दोई म सामिल नी हो सका। ");
INSERT INTO hlb_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","का हम प्रभु; ख घुस्सा दिलाएँ हैं? का हम ओ ख से ताकत वार हैं? ");
INSERT INTO hlb_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","पूरी चीज हुन मोरो लाने ठीक ते हैं, पर सब लोभ का लाने नी हैं: सब चीज हुन से बड़ो नी हैं। ");
INSERT INTO hlb_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","अऊर सब कोई अपनो नी हैं, अर दूसरा हुन को लाने कोसिस करे। ");
INSERT INTO hlb_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","अर जे बाजार म मांस बिक हैं, उ खा अर समझ का कारन कुछ नी पूछ? ");
INSERT INTO hlb_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","“काहेकि जमीन अर ओकी कि भर पूरी प्रभु की आय।” ");
INSERT INTO hlb_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","अगर अविस्‍वासियो म से कुई तुम ख नेवता दे, अर तुम ख जान कि इच्छा होए, ते जो कुछ तुमारो सामने रखो जाहे वही खा: अर समझ का कारन कुछ भी नी पूछ। ");
INSERT INTO hlb_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","पर अगर कोई तुम ख कहे, “यी ते मूर्ति पर चढ़ायो गयो हुई चीज आय,” ते ओकी बखत वालो का कारन अर समझ का कारन नी खाजो। ");
INSERT INTO hlb_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","मोरो असो कहन को मतलब हतो कि समझ नी पर ओकी दूसरो ख। अच्छो, मोरी आजादी दूसरो का लाने फैसला से काहे परखो जाहे? ");
INSERT INTO hlb_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","अदि म धन्यवाद कर ख सामिल होऊ हैं। ते जे पर धन्यवाद करू हैं ओखा कारन मोरी बदनामी काहे होय हैं? ");
INSERT INTO hlb_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","एकोलाने तुम ख मन चाहे खा, मन चाहे पी, मन चाहे जो कुछ कर, सब कुछ परमेस्वर की महिमा का लाने कर। ");
INSERT INTO hlb_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","तुम ख नी यहूदी हुन, का लाने नी यूनानी हुन, का लाने अर नी परमेस्वर की कलीसिया का लाने ठोकर को कारन बन ");
INSERT INTO hlb_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","जसो म भी सब बात हुन म सब ख खुस रखू हैं, अऊर अपनो ख नी पर ढ़ेर सारा हुन ख फयदा ढूँढ हूँ की वी उध्दार पाहे। ");
INSERT INTO hlb_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","तुम ख मोरी जसी चाल चल हैं जसो म मसी कि जसी चाल चलू हैं। ");
INSERT INTO hlb_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","अरे भई हुन, मी तुमख सराहता हूँ कि सब बात हुन तुम मोखा याद करत हो; जे रीति रिवाज मी न तुमख सोउपू हैं उनको पालन करत रहजे। ");
INSERT INTO hlb_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","अदि म चाहूँ हैं कि तुम ख यू मालूम होय कि हर एक अदमी को माथा मसी हैं, अऊर ओरत हुन को माथा अदमी आय, अऊर मसी को सिर परमेस्वर आय। ");
INSERT INTO hlb_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","जे अदमी माथा ढाँको होय प्रार्थना अऊर भविस्यव्दानी करिये हैं, उ अपनो माथा ख लज्जित करिये हैं। ");
INSERT INTO hlb_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","पर जे ओरत हुन माथा पर बिना कपड़ा लेख प्रार्थना अर फिर भविस्यव्दानी करिये हैं, उ अपनो माथा को लज्जित करिये हैं, काहेकि उ मुण्डी होनू का बराबर हैं। ");
INSERT INTO hlb_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","अदि बाई हुन ओढ़नी नी ओढ़े ते बाल भी काट ले; अदि ओरत का लाने बाल कटानो अर फिर मुण्डन करानो लज्जा कि बात हैं, ते ओढ़नी ओढ़े। ");
INSERT INTO hlb_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","हाँव, अदमी ख अपनो माथा ढ़ाकनो जरूरी नी, हैं काहेकि उ परमेस्वर को जसो चहेरा हैं अऊर महिमा हैं; अऊर बाई अदमी कि सोभा आय। ");
INSERT INTO hlb_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","काहे कि अदमी बाई से नी भयो, अऊर बाई अदमी से भई हैं; ");
INSERT INTO hlb_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","अऊर अदमी बाई का लाने नी बनायो गयो, अऊर बाई अदमी का लाने बनायो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","एकोलाने स्वर्गदूत हुन का कारन बाई ख अच्छो हैं कि अधिकार अपनो माथा पर रख जो। ");
INSERT INTO hlb_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ते भी प्रभु म नी ते बाई बिना अदमी, अऊर नी अदमी बिना बाई को आय। ");
INSERT INTO hlb_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","काहेकि जसो बाई अदमी से हैं, वसो ही अदमी बाई को दुवारा हैं; पर सारी चीज हुन परमेस्वर से हैं। ");
INSERT INTO hlb_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","तुम ख स्वंय ही सालह कर, का बाई ख उघाड़े माथा परमेस्वर से प्रार्थना करनु सोभा देवा हैं? ");
INSERT INTO hlb_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","का स्वाभाविक रीति से भी तुम नी जान हैं, कि अदि अदमी लम्बे बाल रख, ते ओखा लाने अपमान हैं। ");
INSERT INTO hlb_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","अऊर अदि बाई लम्बे बाल रखे ते ओखा लाने सोभा हैं, काहेकि बाल ओ ख ओढ़नी का लाने दियो गयो हैं। ");
INSERT INTO hlb_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","अदि अऊर कोई लड़ाई करनो चाहे, ते यी जान ले कि नी हमारी अऊर परमेस्वर कि कलीसिया हुन कि असी रिवाज हैं। ");
INSERT INTO hlb_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","पर यी आदेस देते होय मी तुम ख नी सराह उ हैं, एकोलाने कि तुमारो इकट्ठा होना से अच्छाई नी हैं, अऊर तुम ख बुराई होय हैं। ");
INSERT INTO hlb_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","काहेकि पहले ते यह हैं कि मोरो सुनन म आयो हैं, कि जब तुम ख कलीसिया म जमा होय हैं, ते तुम म फूट होय हैं, अऊर म यी पर थोड़ा विस्वास भी कर हैं। ");
INSERT INTO hlb_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","काहेकि दलबन्दी भी तुम म जरू होए, एकोलाने कि जो अदमी तुम म विस्वास लायक हैं वी देख ना म आ जाहे। ");
INSERT INTO hlb_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","अब तुम जो एक जगह म जमा होय हैं ते यी प्रभु-भोज खान का लाने नी, ");
INSERT INTO hlb_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","काहेकि खान का बखत एक दूसरा से पहले अपनो रोटी खा ले हैं, यी तरीका से कुई ते ख भूखो रह हैं अऊर कुई नसा वालो होय जाहे हैं। ");
INSERT INTO hlb_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","का खान पीवन का लाने तुमारो घर नी हैं? ते परमेस्वर कि कलीसिया ख बेकार जान हैं, अऊर जेका पास नी हैं उन ख लज्जित करिये हैं? म तुम से का कहूँ हैं वा? का यी बात हुन म तुमारो खुसी करूँ? इ बात को लाने मी नी मेरी प्रसंसा करूँ हैं। ");
INSERT INTO hlb_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","काहेकि यी बात हुन मोखा प्रभु यीसु न जी रात उ पकड़वायो गयो, रोटी ली, ");
INSERT INTO hlb_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","अऊर धन्यवाद कर ख ओ ख तोड़ी अऊर कय्हो, “यी मोरो सरीर आय, जो तुमारो लाने हैं: मोरो याद का लाने यी कियो कर।” ");
INSERT INTO hlb_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","यू रीति से जो ओ न बियारी का पीछु कटोरा भी लियो अऊर कय्हो, “यी कटोरा बर्तन मोरो खून म नई वादा हैं: जब कभी पीवा हैं, ते मोरो याद का लाने यी कियो कर।” ");
INSERT INTO hlb_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","काहेकि जब तुम ख यी रोटी खाव अऊर यी कटोरा म से पीवा हैं, ते प्रभु कि मरन ख जब तक उ नी आगो प्रचार करते रहे। ");
INSERT INTO hlb_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","एकोलाने जो कोई भूल चूक रिवाज से प्रभु कि रोटी ख खाव, ते ओकी कटोरा म से पीए, उ प्रभु कि सरीर की जीवन अऊर खून का अपराधी रहे। ");
INSERT INTO hlb_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","एकोलाने अदमी अपनी तुम ख परखे ले अऊर यी तरीका से यी भोज म से खाऐ, अऊर यी कटारो म से पीए। ");
INSERT INTO hlb_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","काहेकि जो खाव-पीते बखत प्रभु को सरीर ख नी पहिचाने, उ यी खाने अऊर पी से अपनो ऊपर सजा लाहे हैं। ");
INSERT INTO hlb_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","यू तीरका तुम म बेजा सारा सो दुखी अऊर बीमार हैं, अऊर बेजा सारा मर भी गया। ");
INS