﻿USE sofia;
DROP TABLE IF EXISTS sofia.hla_vpl;
CREATE TABLE hla_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hla_vpl WRITE;
INSERT INTO hla_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nonei teka a pal tubuna tere Iesu Kristo. E Iesu e hatubunaia tere Devit, ne Devit e hatubunaia tere Abraham. ");
INSERT INTO hla_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","E Abraham e hatuhanei e Aisak i manasa. Ne Aisak e hatuhanei e Jekop. Ne Jekop e hatuhaner ere Juda mia u toulanen. ");
INSERT INTO hla_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ne Juda e hatuhaner ere Peres mere Sira. Ne tsinaren e Temar. Ne Peres e hatuhanei e Hesron. Ne Hesron e hatuhanei e Ram. ");
INSERT INTO hla_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ne Ram e hatuhanei e Aminadap. Ne Aminadap e hatuhanei e Nason. Ne Nason e hatuhanei e Salmon. ");
INSERT INTO hla_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ne Salmon e hatuhanei e Boas. E tsinane Boas e Rehap. Ne Boas e hatuhanei e Obet. E tsinane Obet e Rut. Ne Obet e hatuhanei e Jesi. ");
INSERT INTO hla_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ne Jesi e hatuhanei e Devit a king. Ne Devit e hatuhanei e Solomon. E tsinane Solomon a tahol tere Iuraia te mate. ");
INSERT INTO hla_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ne Solomon e hatuhanei e Riaboam. Ne Riaboam e hatuhanei e Abaitsa. Ne Abaitsa e hatuhanei e Eisa. ");
INSERT INTO hla_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ne Eisa e hatuhanei e Jihosapat. Ne Jihasopat e hatuhanei e Joram. Ne Joram e hatuhanei e Usaia. ");
INSERT INTO hla_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ne Usaia e hatuhanei e Jotam. Ne Jotam e hatuhanei e Eihes. Ne Eihes e hatuhanei e Hesekaia. ");
INSERT INTO hla_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ne Hesekaia e hatuhanei e Manesa. Ne Manesa e hatuhanei e Eimos. Ne Eimos e hatuhanei e Josaia. ");
INSERT INTO hla_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ne Josaia e hatuhaner ere Jekonaia mia u toulanen. Na tara poata teka a tei Israel i na piou ria i Bebilon, ba te hereri u karabus. ");
INSERT INTO hla_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nori i na piou ria i Bebilon, be Jekonaia e hatuhanena e Sialtiel. Ne Sialtiel e hatuhanei e Serababel. ");
INSERT INTO hla_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ne Serababel e hatuhanei e Abaiat. Ne Abaiat e hatuhanei e Elaiakim. Ne Elaiakim e hatuhanei e Eisor. ");
INSERT INTO hla_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ne Eisor e hatuhanei e Sedok. Ne Sedok e hatuhanei e Eikim. Ne Eikim e hatuhanei e Elaiat. ");
INSERT INTO hla_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ne Elaiat e hatuhanei e Elieser. Ne Elieser e hatuhanei e Matan. Ne Matan e hatuhanei e Jekop. ");
INSERT INTO hla_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ne Jekop e hatuhanei e Josep a tson tere Maria. Ne Maria te posei e Iesu, te ngö haseri e Kristo e Mesaia.* ");
INSERT INTO hla_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","E kato uana teka, u mun tamana hoboto ti taniama tere Abraham me mi noa ria tere Devit, nori a 14 u mun tamana. Nu mun tamana ti taniama tere Devit me mi noa ria tara poata ti na piou rien i Bebilon, nori a 14 u mun tamana. Nu mun tamana ti taniama tara poata ti na piou rien i Bebilon me mi noa ria tara poata te butuia e Mesaia, nori has a 14 u mun tamana. ");
INSERT INTO hla_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","E Iesu Kristo i mar posa menai teka. E Maria i hopu kap mei te goölo menien e Josep. Kaba nori i ma soho gono noai, be Maria e pikana turu Namnamei u Goagono.* ");
INSERT INTO hla_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","A tson i tanen e Josep e poei e Maria e pikaia tara tana tson. E Josep a katun a matskö kaba nonei e raman hamatsingoli e Maria i matar a barebana. Te markato uen teka, ba nonei e katsin tapolasa hamousna tere Maria. ");
INSERT INTO hla_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","E Josep e hakhakats noa hasin a ka teka, ba turu sinasoho a toa angelo tara Tsunono e butuia i tanen. A angelo e poei, “O Josep, a hatutubunei tere Devit, alö go ma matoutui te goölo menai a tahol i tamulö e Maria. Tara neha, nonei e pikaia turu Namnamei u Goagono. ");
INSERT INTO hla_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nonei e pose nou a pien tson, ba lö te ngöe moien e Iesu, te mouna uana ‘A Katun a Hihitaguhu’. Taraha, nonei e taguhu ranou u barebana i tanen ba te lu ba nena u markato u omi i taren.” ");
INSERT INTO hla_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","A mamana ka hoboto teka e butu sil te ga kato hamana meni u ranga te ranga sila nia a Tsunono tara toa propet* i manasa. A propet e mar ranga u teka: “Hengo iam! A tahol a kukubei te ma lu noe nei ta tson e pika nou. Ba nonei te pose nou a pien tson, ba nori te ngöe roi a solonen e Emanuel.” A mouna solo teka e kato uana, “E Sunahan e Got* e ka gono mera nora.” ");
INSERT INTO hla_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Be Josep e tagulena ba nonei e kato tatatiena te ranga menien a angelo tara Tsunono. Nonei etöli a tahol i tanen. ");
INSERT INTO hla_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kaba nonei e ma soho gono meien, e na antunaia tara poata te na poseia a tahol i tanen a pien tson. Be Josep e ngöe neien e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","E Maria e poseia e Iesu i Betelehem tara provins i Judia tara poata te kingia e Herot. Na tara poata ti posa hakapeia e Iesu, ba palabir u katun u atei tara han te butubutu nama a pitala i la uamato i Jerusalem me mi poier, “Ime te kana a pien ti posa sil meni ga kingir u Jiu? Alam e atei silem nonei i posa hamani, tara neha alam u tarema a pitopito tara makum te butubutu nama a pitala, a pitopito te haruto nena ti posa sil menien a king. Ba lam e la sile muma te go mi hatsunono u i tanen.” ");
INSERT INTO hla_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","U ranga teka e la soku u tere Herot a King, ba nonei e toku koru mena te hengo menien a tana king e butu hamanasa. Nu barebana hobotor i Jerusalem i toku has. ");
INSERT INTO hla_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Be Herot e gono rena u pris pan hoboto nu tson hihatuts turu Lo ni Israel me rangata ranen, “Ime te poiena u Buk u Goagono te gi poseia e Mesaia a katun te hopu kapin e Sunahan?” ");
INSERT INTO hla_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ba nori e hateie ren, “Tara taun i Betelehem i Judia, te koloto meni a toa propet i manasa. E Sunahan e kato u, ");
INSERT INTO hla_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Alimiu u katunur i Betelehem, turu tsiktsikina i Judia, alimiu e ka tala memou a solo a kapan i gusuna pal tsunono i Judia. Tara neha, a toa tsunono pan e butu nama romana i Betelehem, ba nonei te tsunono noa tara pala i tar u Israel.’” ");
INSERT INTO hla_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ti markato uen teka be Herot e ngö hamous tun rena nori u katun u atei. Ba nonei e rangrangata ranen, me atei nena a saha poata te butu mamia a pitopito teka. ");
INSERT INTO hla_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ba nonei e poiena, “Alimiu go la uam i Betelehem ba te na sake hatagale muma a pien teka. Na poata te sabie mumen romana limiu, ba limiu te hatei poutse mumo romana lia. Ba lia te na hatsunono hase goen.” Ba nonei e hala tala mera neien i Betelehem. ");
INSERT INTO hla_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nori i hengo u ranga tara king ba nori e lar. Na pitopito ti ruto mame len tara han te butubutu nama a pitala e mam raien, me na kana i iasa tara makum te kaia a pien. ");
INSERT INTO hla_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ba nori e tarer a pitopito ba nori te sasala hapan korur. ");
INSERT INTO hla_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ba nori e tasur i iahana luma te kaia a pien ne tsinanen e Maria. Ba nori e hatukunur me hatsunono uar tara pien. Ba nori e kalatser u kabekabe i taren me louser a ma tsi ka ma tsi niga me haleri a pien: a goul, na insens te hatser ba te masi hanigana, nu uapi u soksoka. ");
INSERT INTO hla_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na nori i takopis pouts u tara han i taren ba te la sila ria tara tana maroro. Tara neha, e Sunahan e ranga merien turu sinasoho i taren e gi ma tatei la pouts uai tere Herot. ");
INSERT INTO hla_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","U katun u atei i la hakapa, ba toa angelo tara Tsunono e butuna turu sinasoho tere Josep me poiena i tanen, “Alö go takei ba lö te lu rem u mun tsinana, ba limiu te bus uamiu tara han i Itsip. Ba limiu te ka moa i Itsip e antunana tara poata te ranga lel goa lia i tamulö. Taraha, e Herot a King e katsin sakiena a pien teka ba te atung hamatie nen.” ");
INSERT INTO hla_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Be Josep e takei mena bong noa me lu rena u mun tsinana me la uar i Itsip. ");
INSERT INTO hla_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ba nori e na ka ria i Itsip e antunaia tara poata te ga mateia e Herot. A ka teka e butu sil te go kato hamana meni u ranga te ranga sila nia a Tsunono tara toa propet i manasa. E kato u: “Alia e ngö ba neguma romana a Pien Tson i tar i Itsip.” ");
INSERT INTO hla_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Be Herot e atei sil talena, u katun u atei tara han te butubutu nama a pitala i gamoe ien. Ba torinen e si koruna. Ba nonei e hala rena u katun i Betelehem, na tara ma tsi han i sukusuku, ba nori e atung hamate rer a galapien tson hoboto ti antunaia turu huol u hiningal. Taraha, u katun u atei i hateien a pitopito te harutein a tou posa tere Mesaia e butu mamia turu huol u hiningal te kapa. ");
INSERT INTO hla_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","E kato uana teka bu toa u ranga te ranga sila nia e Sunahan tara propet e Jeremaia e butu hamana. ");
INSERT INTO hla_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Nonei e poei, “U ngala pan e butuna tara han i Rama. A barebana e taber me ku hatatagi hapanir. A pala tere Retsel e tabe siler a galapien i taren. Nu katun e ma antunan hasokolei rarien. Taraha, a galapien i taren i kapa.” fl A propet te mar ranga u teka. ");
INSERT INTO hla_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","I murimuri be Herot e matena. Ba toa angelo tara Tsunono e butuna tere Josep i Itsip turu sinasoho. ");
INSERT INTO hla_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nonei e poei, “Alö go takei, ba lö te lu rem u mun tsinana, ba limiu te la pouts uamiu tara han i Israel. A katun te torohanan atung hamate a pien e mate hakapa.” ");
INSERT INTO hla_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Be Josep e takeina me lu rena u mun tsinana, ba nori e la pouts uar tara han i Israel. ");
INSERT INTO hla_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kaba e Josep e hengoen te lu menai e Arkileas a makum tere tamanen e Herot, me king nena a provins i Judia. Be Josep e matoututo. Na turu tana u sinasoho e Sunahan e hateien e ga ma tatei la uai i Judia, ba nonei e la uana tara provins i Galili. ");
INSERT INTO hla_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ba nonei e na kana tara toa taun te ngöeri i Nasaret. A ka teka e butu sil hasi te go kato hamana meni u ranga ti habulunganein u propet. Nori i poei, “E Mesaia e ngöe roi romana a toun Nasaret.” ");
INSERT INTO hla_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","I murimuri e Jon a tson te baptaisir u katun e habulunganein u ranga tere Sunahan tara latu pinopino i iahana provins i Judia. ");
INSERT INTO hla_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","E kato u, “Alimiu go habirits ba neiam u markato u omi. A Nipepeito tere Sunahan e sukusuku hakapama.” ");
INSERT INTO hla_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","E Jon nonei a katun te ranga nia e Aisaia a propet i manasa. Nonei e kato u: “A toa katun e na ranga hapan noa romana tara latu pinopino ba te poiena, ‘Kato hamatsköe iam u markato i tamilimiu, taraha a Tsunono e ngilin sila nama romana tara maroro a matskö.’” ");
INSERT INTO hla_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","E Jon e roron hasogi u hasobu ti kuiei a huluna kamel, ba te hapouse iena a lete. Na nonei e roron noui a köno nu möröana. ");
INSERT INTO hla_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na tara poata teka, u katun u para ri Jerusalem na turu palair u han hoboto tara provinsina i Judia na turu hanir i rehina a ramun olo i Jodan, nori i la uama tere Jon. ");
INSERT INTO hla_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ba nori i pokeieto a man markato a man omi i taren, ba nonei e baptais ranen tara ramun i Jodan. ");
INSERT INTO hla_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Be Jon e tara rena u katun u para tara pala turu Parisi na turu Sadiusi* i la silema te gi mi lu menien a baptais, ba nonei e poiena i taren, “Alimiu u katunur tara kukutsi a omi — alimiu u katun u gamogamo! Alimiu e ma antunan bus ba puku nemi a raharaha tere Sunahan te butu nou! ");
INSERT INTO hla_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Alimiu go habirits ba niam u markato u omi i tamilimiu, ba limiu te mar kato hamana koru uamiu tara katun te habirits ba nena u markato u omi i tanen. ");
INSERT INTO hla_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Alimiu go ma tatei mar hakats uami teka, ‘Alam e nigam, taraha e Abraham e tubumulam.’ Alia e hatei rago limiu, e Sunahan e antunan katoe nei u hatu teka a pinaposa tere Abraham. E Sunahan e ma haniga pinopinoe nei a katun te palaua nen tere Abraham. E moa. E hanige iena a katun te kato hanigana. ");
INSERT INTO hla_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ne Sunahan e katsin ngats lupu hamanasena u roei hoboto te mamala hua haniga nei, ba te lapo naria turu tula. E kato uana, e Sunahan e hahune nou a katun te ma kato haniga nei.” ");
INSERT INTO hla_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","E Jon e ranga u tara barebana me poiena, “Alia e baptais ragi limiu u ramun tun, taraha alimiu u habirits ba niam u markato u omi. Kaba nonei a katun te murimuri nama i tar e pan saluhe nano lia. Nonei a tsunono pan, na lia a katun papala koru. Nonei te baptais ranoi romana limiu u Namnamei u Goagono nu tula. ");
INSERT INTO hla_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nonei e katsin kato hamanasena a toukuin hamou turu ranga. Nonei e lu katata renou u katun u niga nu katun u omi. Nonei e haka renoa u katun u niga tara han a niga, ba nonei te tsuga mera nei u katun u omi turu tula te ma antunan hoso nari.” ");
INSERT INTO hla_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na tara poata teka e Iesu e la ba nema i Galili me la uana tara ramun i Jodan te go na habaptaisia tere Jon. ");
INSERT INTO hla_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kaba e Jon e rama me poiena, “E ma matskö nei te baptais mena goi lia alö. Alö e pan nemo lia. E niga balana te go baptais meni lö alia.” ");
INSERT INTO hla_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kaba e Iesu e ranga palis u i tanen me poiena, “Tara poata teka e nigana te baptaise mulö alia. Alö go haniga, taraha e nigana te katoe rara a mamana ka hoboto a matskö te ngilene Sunahan.” Be Jon e hatanganato ba te baptaisena e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","E baptaise ien be Iesu e topei takei poutsuna turu ramun. Bu kolö e takalatana, ba nonei e tarena u Namnamei tere Sunahan te kouluma, e herei a kulu me la uanama tere Iesu. ");
INSERT INTO hla_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Bu toa u ranga e butu nama i Kolö me poiena, “Nonei a Pien Tson a tsomi koru i tar teka. Alia e haniga korue gen.” ");
INSERT INTO hla_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nu Namnamei tere Sunahan e peigi menai e Iesu tara latu pinopino te go na torohana menien e Satan. ");
INSERT INTO hla_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ne Iesu e agonein a kannou e antunaia turu 40 u lan nu 40 u bong. Na nonei e ka mei a bes a kapan koru. ");
INSERT INTO hla_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ne Satan e mi torohane ien me poiena i tanen, “Te go Pien u lö tere Sunahan, ba lö te rangam bu hatu teka te palis uar turu beret.” ");
INSERT INTO hla_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kaba e Iesu e ranga palis u i tanen me poiena, “Turu Buk u Goagono i koloto nia, ‘A beret peisa e ma antunan hala nenei a nitoatoa tara katun. E moa. A katun te ga lu a nitoatoa turu ranga hoboto te ranga nena e Sunahan.’” ");
INSERT INTO hla_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nonei e mar ranga u teka, be Satan e toan lu mena neien tara taun a goagono i Jerusalem, me na hatuole nen i iasa koru i pungana tara Luman Lotu Pan. ");
INSERT INTO hla_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ba nonei e poiena tere Iesu, “Te go Pien u lö tere Sunahan, ba lö te kurapa uam i puta. Taraha, turu Buk u Goagono i koloto nia, ‘E Sunahan e ranga mera noi u angelo i tanen te gi tara kap menien lö. Na nori e pile sei nario lö, te go ma tatei tu hamate meni lö turu hatu.’” ");
INSERT INTO hla_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Be Iesu e ranga menen me poiena, “Turu Buk u Goagono i koloto has nia, ‘Alö e moa te go torohana menai a Tsunono. Nonei a Sunahan i tamulö.’” ");
INSERT INTO hla_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Be Satan e lu mena nei e Iesu turu toa u pokus i iasa koru. Ba nonei e harute neien u han hoboto i puta na mamana ka a niga i taren. ");
INSERT INTO hla_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Be Satan e poiena tere Iesu, “Te hatukun moa lö ba te hatsunono uamou i tar, ba lia te hale goi lö a mamana han hoboto teka.” ");
INSERT INTO hla_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Be Iesu e ranga menen, “Satan, alö go la! Taraha, turu Buk u Goagono i koloto nia, ‘Alö go hatsunono u tara Tsunono. Nonei a Sunahan i tamulö, na nonei peisa te mamanieteie mulö.’” ");
INSERT INTO hla_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Be Satan e la ba nanen. Bu angelo e la rima me mi taguher e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Be Iesu e hengo nena u ranga ti haka menai e Jon tara karabus, ba nonei e lana i Nasaret tara provins i Galili. ");
INSERT INTO hla_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ba nonei e la ba nena i Nasaret me na kana tara taun i Kapeneam i harehirehi tara Ramun Perperere i Galili.* Kapeneam e kaia tara pala tere Sebiulan ne Naptali, a huol a pala turu Jiu. ");
INSERT INTO hla_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","A ka teka e butu sil te ga kato hamana meni u ranga te ranga sila nia e Sunahan tara propet e Aisaia i manasa. ");
INSERT INTO hla_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Nonei e poei, “Alia e hatei negu a mounana tara pala tere Sebiulan ne Naptali, u tsikitsiki i rehina ramun pan i hapalana ramun i Jodan, a han i Galili te ka ria a pala te halhal ria turu Jiu. ");
INSERT INTO hla_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","U katun teka te gum ria turu kuhil, nori e tare riou u ualesala u kapan! E Sunahan e hala nenou romana u mana i tanen e here nei u ualesala turu katun te tutu naren ba te hereri u katun te katsin mate ba ner e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na tara poata teka, e Iesu e tanian habulunganein u ranga ba te poiena, “Alimiu go habirits hamatsköe iam a torimiu! Taraha, a Nipepeito tere Sunahan e la hasukusuku hakapama.” ");
INSERT INTO hla_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","E Iesu e laia i kotolana tara Ramun Perperere i Galili, ba nonei e tara rena ere Saimon te ngöeri e Pita mere Endru u mun toulana ba te hagala ria i ramun, taraha nori u katunun hagala. Nori i holei a kannou i taren a iena. ");
INSERT INTO hla_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Be Iesu e poiena i taren, “La gono memu molia. Fp fl Alimiu u roron sohe iam a iena tara abe, kaba lia e hatuts ragoi limiu te go ngö gugono mera milimiu u katun i tar.” ");
INSERT INTO hla_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ba nori e la ba hamanasa ner a abe i taren, me la gono meren. ");
INSERT INTO hla_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ba nonei e gamon la lelina me tarena u taina u mun toulana ere Jemis mere Jon, a hinpien tere Sebedi. Nori i kaia tara tsi tolala i taren ba te suge ier u abe i taren, ba nonei e ngö ranen e gi la gono meien. ");
INSERT INTO hla_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ba nori e la ba hamanasa ner e tamaren ba te kana tara tsi tolala nu tsonun kui. Ba nori a elasolana e la gono mer e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","E Iesu e hula laia tara han hoboto i Galili, ba te hihatutsna turu luman lotu turu Jiu. Nonei e hihatutsin u Bulungana u Niga tara Nipepeito tere Sunahan ba te kato haniga pouts rena a barebana ti ka mei u mamana u mar nimate. ");
INSERT INTO hla_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bu barebana tara mamana han hoboto tara provins i Siria i hengoin a toukui nu hihatuts te kato e Iesu. Ba barebana e peigi rarima u katun hoboto ti ka mei a nimate: u katun ti sagohi a mamana mar kamits, nu katun u popoloana, nu katun u kotskotsibong, nu katun u matekata. E Iesu e kato haniga pouts hoboto ren. ");
INSERT INTO hla_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","U katun u para koru i kukute e Iesu: u katunur i Galili na i Dikapolis ni Jerusalem ni Judia ni hapalana ramun i Jodan. ");
INSERT INTO hla_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","E Iesu e tarer a barebana u para ti gono hobotoma ba nonei e seina tara tsi pokus. Ba nonei e gumuna bu katunun tsitsilo* i tanen e mi gono hahise ren, ba nonei e tanian hatuts ranen. ");
INSERT INTO hla_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ba nonei e poiena: “U katun te kato hateteneier a peisaren e gi sasala. E Sunahan e ngö rane ien u katun u sasala, taraha a Nipepeito tere Sunahan e ra kaien. ");
INSERT INTO hla_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","U katun te tori-tiamar e gi sasala. E Sunahan e ngö rane ien u katun u sasala, taraha nonei e kato hagegaha poutsena romana a toriren. ");
INSERT INTO hla_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","U katun te kokomotor ba te ma tatei raharahari e gi sasala. E Sunahan e ngö rane ien u katun u sasala, taraha nori e lue riou romana a han i puta. ");
INSERT INTO hla_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","U katun te matesil koruer a markato te matsköna i matana e Sunahan e gi sasala. Nori e hereri a katun te bes silena na te maka silena a ka a niga. E Sunahan e ngö rane ien u katun u sasala, taraha nori e masul haniga riou romana. ");
INSERT INTO hla_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","U katun te tatagi ner a tana katun e gi sasala. E Sunahan e ngö rane ien u katun u sasala, taraha nonei e tatagi has ranoen romana. ");
INSERT INTO hla_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","U katun a toriren te gogosona e gi sasala. E Sunahan e ngö rane ien u katun u sasala, taraha nori e na tare riou romana e Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","U katun te nolo pouts rer a palai te hiaraharahar e gi sasala. E Sunahan e ngö rane ien u katun u sasala, taraha nonei e ngö has rane ien romana a galapien i tanen. ");
INSERT INTO hla_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","U katun te kato hamatskö ria i matana e Sunahan e gi sasala. E manana, u katun te kato homi ria i matane Sunahan e kato hakamits raren. Kaba e noahasina. E Sunahan e ngö rane ien u katun u sasala, taraha a Nipepeito tere Sunahan e ra kaien. ");
INSERT INTO hla_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“E Sunahan e ngö has ranei limiu u katun u sasala tara poata a barebana e ranga homi sil rariou limiu ba te kato hakamits rario limiu me poa mera rilimiu a mamana mar gamo. Nori e rama nerio lia ba te katsin pita-pute ier a toukui i tar. ");
INSERT INTO hla_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Alimiu go sasala hapan iam, taraha alimiu e na lue mou romana a ka a niga koru i Kolö. A barebana i kato has u teka i manasa me kato homi has rer u propet.” ");
INSERT INTO hla_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Be Iesu e poe hasena, “Alimiu e heremi u sol tara barebana i puta. U sol e kato hanige iena a kannou, na alimiu u katun i tar e kato haniga has remiu u katun. Kaba te tia ba nena u sol a nitatasena i tanen, ba katun te mar hatatasena halona pouts mena neien ime? E moa tala. E moa lel ta toukui i tanen, ba barebana e ba naren ba tetötö ria i tanen. ");
INSERT INTO hla_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Alimiu e heremi u ualesala tara katun hoboto. A barebana e ma antunari te gi hamous meni a taun te gumna i ieluna u pokus. ");
INSERT INTO hla_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na katun e namala hakulupe nei u lam ba te kope neien a tabeli. E moa. Nonei e haka seie nen tara tsi salolo ba te alesala uana turu katun hoboto te ka ria i iahana luma. ");
INSERT INTO hla_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nu ualesala i tamilimiu e ga kato has u i iesana ba te alesala uana tara barebana. Ba nori te tare riou romana a markato a niga i tamilimiu ba te soloseie riou romana e Tamamilimiu te kana i Kolö.” ");
INSERT INTO hla_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","E Iesu e ranga me poiena, “Alimiu go ma poiemi alia u la silema te go mi tsuga ba meni u Lo* tere Moses nu ranga turu propet. E moa. Alia u ma la sile mei te go mi tsuga ba merien lia, kaba alia u la silema te go mi kato hamouna koru merien. ");
INSERT INTO hla_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na lia e hatei hamana rago limiu, u kolö nu puta e tatei tia nou romana i murimuri, kaba e moa ta tsi toa ta tsi makumun ranga te ga tia iou romana turu Lo, antunana tara poata te butuna a mamana ka hoboto te ranga nanen. ");
INSERT INTO hla_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","A katun te hipus nana a tsi toa puku turu ranga teka ba te hatuts rena a palai te gi kato has u i iesana, nonei e katun papala koruna romana tara Nipepeito tere Sunahan. Kaba a katun te hengoena u ranga teka ba te hatuts rena a palai te gi kato has u i iesana, ba nonei e katun panna romana tara Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Alia e hatei rago limiu, u markato u matskö i tamilimiu e tatei saluhena turu markato u matskö turu tson hihatuts turu Lo na turu Parisi. Te moa nen, ba limiu te ma tatei tasu korumi romana tara Nipepeito tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Be Iesu e poe hasena, “Alimiu u hengo niam u ranga ti hengoin u tuburara i manasa ba te poiena, ‘Alö go ma hipulii. A katun te hipulina e go la u turu kot.’ ");
INSERT INTO hla_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kaba alia e hatei rago limiu, a katun te raharahena a hahatoulana i tanen e tatei lana turu kot. Na katun te sigalena a hahatoulana i tanen ba te poiena, ‘Esi nonei teka?’ nonei e tatei lana turu kot pan. Na katun te hamal nena a hahatoulana i tanen e tatei lana turu tula i hel. ");
INSERT INTO hla_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Kaba te katsin hatsunono uamu lö tere Sunahan ba lö te songots hakats sabe nem a hahatoulana i tamulö e raharahe nolö, ba lö te na nolo pouts bem a hahatoulana i tamulö. Te kapa nen, ba lö te la pouts muma ba te mi hatsunono uam tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Te kot nana a toa katun alö, alö go kapiena boroboro poutsen i mam te na butu moa lö turu kot. Te moa nen, ba nonei te kot nenoa lö tara tsonun hamou turu ranga, ba tsonun hamou te hala nenoa lö tara polis, ba nonei te na hake noa lö tara karabus. ");
INSERT INTO hla_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na lia e hatei hamane golö, alö e ma halakasa poutse roi tara karabus antunana te hole mia lö a mamana toea hoboto tara hol turu kot.” ");
INSERT INTO hla_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Be Iesu e ranga lelina me poiena, “Alimiu u hengo niam u ranga te poiena, ‘Alö go ma tsikoloi.’ ");
INSERT INTO hla_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kaba alia e hatei rago limiu, a tson te tara uana tara tahol ba te hakats tununa te ga na opu gono menien e kato uana tara tson te tsikolo hamanana. ");
INSERT INTO hla_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Te ga kato homieia a matamulö tara pal matou alö, ba lö te hase men ba te ba namen! Taraha, e omi koruna te gi lapo ba meni a tuanreimulö hoboto i hel, kaba e ma omi koru nei te go tia u a toa makum tara tuanreimulö. ");
INSERT INTO hla_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Te ga kato homieia a limamulö tara pal matou alö, ba lö te ngats pekoe men ba te ba namen! Taraha, e omi koruna te go la u a tuanreimulö hoboto i hel, kaba e ma omi koru nei te go tia u a toa makum tara tuanreimulö.” ");
INSERT INTO hla_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Be Iesu e poe lelena, “U ranga e poe hasena, ‘A tson te la ba nena a tahol i tanen e go hale ien u pepa te poiena a hitöl e tapekona.’ ");
INSERT INTO hla_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kaba alia e hatei rago limiu, a tson te la ba nena a tahol i tanen kaba tahol e ma lui a tana tson, ba ka teka e kato here nanei a tahol teka a tahol te halokuna. Na tson tetölena a tahol a hitöl mam i tanen te tapeko, ba tson teka e here hase nei a tson te tsikolona.” ");
INSERT INTO hla_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Be Iesu e ranga lelina me poiena, “Alimiu u hengo niam u ranga ti hengoin u tuburara i manasa ba te poiena, ‘Alö go ma hamana meni i iasa u gamo, kaba alö go kato hamana a ka tu hamana meni lö i matana Tsunono.’ ");
INSERT INTO hla_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kaba alia e hatei rago limiu, alimiu go ma hamana uami i iasa. Alimiu go ma hamana uami i kolö, taraha u kolö a makum tara nitsunono tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Na limiu go ma hamana uami tara han i puta, taraha u puta e here nei utötö te haholena e Sunahan a mounen. Na limiu go ma hamana has uami i Jerusalem, taraha nonei a taun tara King a kapan. ");
INSERT INTO hla_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na limiu go ma hamana has uami i bakumilimiu, taraha alimiu e ma antunami te go kato hahiaka menami a tsi toa a tsi hulu, tsi te go kato haruruhana menami a tsi toa a tsi hulu. ");
INSERT INTO hla_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","U ranga i tamilimiu e ga poe talasi ‘Aa’ tsi ‘E moa’. U ranga te tagala balana turu ranga teka e butu nama tere Satan.” ");
INSERT INTO hla_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Be Iesu e kato uana, “Alimiu u hengo niam u ranga te poiena, ‘Te ga kato homi meni ta katun a matamulö, ba lö te hipou has namien i matanen, ne ga kato has u i iesana turu liho na tara mamana mar nomi.’ ");
INSERT INTO hla_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kaba alia e hatei rago limiu, alimiu go ma palisemi a katun te kato homina i tamilimiu. E moa. Te tapalena a katun u uabuabu tara pal matou i tamulö ba lö te habirits nem a hapala. ");
INSERT INTO hla_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na te kot nenoa lö a toa katun ba te katsin luena a siot i tamulö ba lö te hala hase men u hasobu u ngahangaha i tamulö. ");
INSERT INTO hla_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Na te hasoatse nei lö a toa polis a ka i tanen e noana tara toa kilomita, ba lö te soate men e noana tara huol a kilomita. ");
INSERT INTO hla_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Poata te rangata hatatagi silena a toa katun ta ka i tamulö, ba lö te haleie men. Na poata te katsin harohona a katun ta ka i tamulö, alö e ma tatei peits namien.” ");
INSERT INTO hla_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Be Iesu e ranga lelina me poiena, “Alimiu u hengo niam u ranga te poiena, ‘Alö go ngil a hahikapien i tamulö ba lö te paköe iem u katun te paköe rio lö.’ ");
INSERT INTO hla_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kaba alia e hatei rago limiu, alimiu go ngil poutse riam u katun te pakö rario limiu ba limiu te singo silemiu u katun te kato hakamits rario limiu. ");
INSERT INTO hla_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Te kato uamou limiu teka ba limiu te haruto namou alimiu a galapien tere Tamamilimiu te kana i Kolö. Taraha, nonei e hapirena a pitala i tanen tara katun a niga na tara katun a omi has, na nonei e hapolena a langits tara katun te kato hamatsköna na tara katun te ma kato hamatskö has nei. ");
INSERT INTO hla_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Te ngil hase moa limiu u katun te ngil rario limiu, aha te ngil silemi limiu a hamatana? U katun te lulu hagamoer a takis e kato has uar i iesana. ");
INSERT INTO hla_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na te ranga haniga peisa mia limiu tara hahikapien i tamilimiu, alimiu go ma peimi alimiu e kato haniga korumiu. U tematan e kato has uar i iesana. Kaba alimiu, e moa. ");
INSERT INTO hla_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","A markato i tamilimiu e ga matskö nitoa, te kato uana e Tamamilimiu i Kolö te matskö nitoana.” ");
INSERT INTO hla_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Be Iesu e poe hasena, “Hanei iam, ba limiu te ma kato silemi a markato a niga i tamilimiu i matar u barebana te gi tara merien limiu ba pal tson na tohaliou has te haniga rario limiu. Te kato uamou limiu teka be Tamamilimiu te kana i Kolö te ma hamatana ranoi limiu. ");
INSERT INTO hla_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Hena, te hale moa lö a moni turu katun te moar ta moni, ba lö te ma katoe mien i matana barebana te mar kato uar u katun u gamogamo i iahana luman lotu na turu kalana. Nori e kato sile ier a ka teka i matar u barebana te gi solosei merien u katun. Nonei u hamatana i taren teka. Na lia e hatei hamana rago limiu, nori i lu hakapa u hamatana i taren, ne moa lel tala. ");
INSERT INTO hla_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kaba poata te hale moa lö a moni turu katun te moar ta moni, ba lö te ma hatei has nemi a tsomi i tamulö, te kato uana turu ualima te ma tare nei a ka te katoena u tana u ualima. ");
INSERT INTO hla_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","E kato uana teka ba lö te hala hamomous nem a monin hitaguhu. Be Tamamulö te tarena a ka te kato hamous nena a katun, nonei e hamatane nou romana lö.” ");
INSERT INTO hla_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Be Iesu e poe lelena, “Poata te singo mia limiu, ba limiu te ma heremi u katun u gamogamo. Taraha, nori e ngil korue ier te gi tuol uen ba te singo ria turu luman lotu na turu makum te hitupali ria u kalana, te gi tara merien u katun. Alia e hatei hamana rago limiu, nori i lu hakapa a hamatana i taren, ne moa lel tala. ");
INSERT INTO hla_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kaba poata te singo mia lö, alö go tasuia tara rum i tamulö ba te hapiliem a tamana ba te singo uam tere Tamamulö te ka hasina tara makum te mousuna. Be Tamamulö te tarena a ka te kato hamous nena a katun nonei e hamatane nou romana lö. ");
INSERT INTO hla_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Na poata te singo mia lö, alö go ma hula raranga hakopisi te kato uar u tematan. Nori e poier a sunahan i taren e hengo ranoen te katoe rien u ranga u parapara. ");
INSERT INTO hla_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Alö go ma here rien, taraha e Sunahan e Tamamulö e atei silena a ka te ngile mulö i mam te rangatse mien lö. ");
INSERT INTO hla_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Alimiu go mar singo uam teka: ‘O Tamamulam i Kolö, a solomulö e gi hagoagoni. ");
INSERT INTO hla_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","A Nipepeito i tamulö e ga lama. Alam go kato u turu ngil i tamulö i puta te kato has uarien i Kolö. ");
INSERT INTO hla_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Alö go hala ramei lam a tsi kannou te noana i romana. ");
INSERT INTO hla_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Alö go lu ban a ka a omi tu kati lam ba te solopale men, tu solopala hakapa has meni lam a ka a omi te kato u a tana katun i tamulam. ");
INSERT INTO hla_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Alö go ma hala meri lam tara tou hiamus, kaba alö go lu ba beri lam a nomi. U mana.’ ");
INSERT INTO hla_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Te solopale mia lö a ka a omi ti kato u a palair u katun i tamulö, be Tamamulö i Kolö e lu ba has nanou a ka a omi tu kati lö. ");
INSERT INTO hla_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kaba te ma solopale moi lö a ka a omi ti kato u a palair u katun i tamulö, be Tamamulö e ma lu ba has nanoi a ka a omi tu kati lö.” ");
INSERT INTO hla_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Be Iesu e ranga noana me poiena, “U katun u gamogamo e matalohor poata te agono uaren tere Sunahan, kaba alimiu go ma mar kato uami teka. Taraha, nori e hamataloho siler te gi tara merien a barebana nori e agonor. Alia e hatei hamana rago limiu, nori i lu hakapa a hamatana i taren, ne moa lel tala. ");
INSERT INTO hla_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kaba alö, poata te agono mua lö, ba lö te kato here nami a peisamulö a katun te ma agono nei. ");
INSERT INTO hla_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ba barebana te ma tareri te agono uamu lö. E Tamamulö peisa te kana tara makum te mousuna nonei te ateina. Be Tamamulö te tarena a ka te kato momousena a katun nonei e hamatane nou romana lö.” ");
INSERT INTO hla_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Be Iesu e poe lelena, “Alimiu go ma kui hatagala silemi a man ka man niga i puta. U binatang nu sö e kato homiena a man ka teka, nu kopkop e hela hasir ba te kopur. ");
INSERT INTO hla_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kaba alimiu go kui hatagala sile iam u markato te ranga negu lalia be Sunahan te hala renoi romana limiu u hamatana pan i Kolö. U binatang nu sö e ma antuna nei te go kato homi meni a man ka teka, nu kopkop has e ma tatei helari ba te kopur. ");
INSERT INTO hla_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Taraha, te poe mia limiu a ka a niga hamana e kana i puta, bu ngil i tamilimiu e ka has uana i puta. Na te poe mia limiu a ka a niga hamana e kana i Kolö, bu ngil i tamilimiu e ka has uana i Kolö.” ");
INSERT INTO hla_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Be Iesu e kato uana, “A matarara e here nei u lamina turu namnamei i tarara te haharoei nena u ngil i tarara. Te ka mena a katun u ngil u niga, ba nonei te lalana tara maroro te alesalana. ");
INSERT INTO hla_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Na te ka mena a katun u ngil u omi, ba nonei te lalana tara maroro te kuhilina. A katun te ka talasi mena u ngil u omi nonei te lalana tara maroro te kuhil nitoana.” ");
INSERT INTO hla_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Be Iesu e poiena, “A katun e ma antuna nei te ga kui uen tara elasolana tsunono. Taraha, nonei e rama nenou a toa ba te ngilena a tabi, tsi te moa nen, ba nonei te hengo hanige nou a toa ba te karous nena a tabi. Alimiu e ma antunan kui hoboto bemi e Sunahan na tara moni. ");
INSERT INTO hla_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nonei lasi te hatei sil ragi lia alimiu: alimiu e moa te go hakats hapara sil menami a nitoatoa i puta ba te poemiu, ‘Aha te noue gou lia? Na aha te ue gou lia?’ Ne moa has te go hakats hapara sil mena milimiu u tuanrei i tamilimiu ba te poemiu, ‘U saha u hasobu te hasoge gou lia?’ E moa. U katun e ma ka sileri a tou nou peisa. Nu tuanrei tara katun e ma ka sile nei u hasobu peisa. E moa. ");
INSERT INTO hla_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Alimiu go rute iam u apena i iasa. Nori e ma leberi ta kannou na nori e ma hagala haseri a kannou ba te mi hake ria tara luman haputu. E moa. Kaba e Tamamilimiu i Kolö e hanou noa las ranen. Na limiu e niga bala nemiu u apena. ");
INSERT INTO hla_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na toa i tamilimiu te tatei hakats hapanina ba te gamon hangahangahena a nitoatoa i tanen i puta? E moa. ");
INSERT INTO hla_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Na ha te hakats sile milimiu u hasobu? Alimiu go rute iam u palaua u hie te mar pusuku uaren. Nori e ma katoeri a peisaren ba te taratara hanigana. E moa. ");
INSERT INTO hla_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Na lia e hatei has ragi limiu, e King Solomon e ka mei u hasobu u taratara haniga koru, kaba a tsi toa puku tara palaua teka e taratara haniga bala nena u hasobu tere King Solomon. ");
INSERT INTO hla_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","E Sunahan te hataratara hanige iena u garas u hie teka, te pusukuna i romana na te hats hase ria turu tula i mahö. Na te hataratara hanige iena e Sunahan u garas, ba limiu te ma poemi e Sunahan e ma hala ranoi limiu tu hasobu. E moa koru. Alimiu e ka memiu a tsi nihamana a tsi tetenei. ");
INSERT INTO hla_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Alimiu go ma hakatsmi ba te poemiu, ‘Aha te noue rou ra? Na aha te ue rou ra? Nu sahu hasobu te hasoge rou ra?’ ");
INSERT INTO hla_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","A mamana ka teka te kato hatagala siler u tematan te gi lu menien. Ne Tamamilimiu i Kolö e atei silena te ngil mena milimiu a man ka hoboto teka. ");
INSERT INTO hla_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kaba limiu go hakats mam niam a Nipepeito tere Sunahan na man ka te matsköna i matanen. Ba man ka hoboto teka, a kannou na kan ua nu hasobu, e la has uar romana i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Na limiu e moa te go hakats hapara sil menami u lan i mahö, taraha u lan i mahö e ka menou u tana u mar hakhakats peisa. Man toa man lan e ka mena u hakats e noana turu toa u lan.” ");
INSERT INTO hla_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Be Iesu e rangana me poiena, “E moa te go poe mena milimiu a tana katun e omina, be Sunahan te ma poe hase noi alimiu e omimiu. ");
INSERT INTO hla_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Taraha, e Sunahan e tsimou rano limiu te mar ona mena milimiu a tana katun. Na mar skel te roron hala rami limiu u katun, tara mar skel teka e Sunahan e hala hapopo pouts has nanen romana i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Aha te ruto puku sile milö a tsi bita i matana hahatoulana i tamulö, ba lö te ma rutemi a tutoka i matamulö pouts? E here nei a katun te ma rute nei a markato a omi pan i tanen, kaba nonei e poiena te omina a tana katun te ka mena a tsi markato a tsi omi te teteneina. ");
INSERT INTO hla_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Aha te poe mulö tara hahatoulana i tamulö, ‘Alia go lu ban a tsi bita i matamulö,’ na te ka memia lö a tutoka i matamulö pouts? ");
INSERT INTO hla_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","O gamogamo! Alö go lu ba mamin a tutoka i matamulö pouts, ba lö te toan ruto haniga mou ba te lu ba nem a tsi bita i matana hahatoulana i tamulö.” ");
INSERT INTO hla_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Be Iesu e poe lelena, “Alimiu e moa te go hala menami a ka te goagonona turu muki, taraha nori e namos habiritsir ba te kotoleke rario limiu. Na e moa te go lapo mena milimiu u beroana turu poum, taraha nori e namostötö homie ren.” ");
INSERT INTO hla_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Be Iesu e kato uana, “Alimiu go rangata sakesake iam ba limiu te lue moen romana. Na limiu go ruto sakesake iam ba limiu te sabie moen romana. Na limiu go ngö sakesake iam ba tamana te kalatse riou romana. ");
INSERT INTO hla_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Taraha, a katun te rangata sakesake nou e lue noen romana, na katun te ruto sakesake nou e sabie noen romana, na katun te ngö sakesake nou, a tamana e kalatse riou romana. ");
INSERT INTO hla_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Esi i tamilimiu te tatei hale nei a pien i tanen a hatu te singoe nen ta tsi beret? ");
INSERT INTO hla_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Na esi te tatei hale nei a pien i tanen a kukutsi te singoe nen ta tsi iena? ");
INSERT INTO hla_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Alimiu e ka memiu a markato a omi, kaba alimiu e hala noa has nemiu a man ka man niga tara galapien i tamilimiu. Ne Tamamilimiu i Kolö e niga bala nena u katun, ba nonei te hala noa las nenou a man ka man niga turu katun te singo ria i tanen. ");
INSERT INTO hla_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Te ngile mia limiu a tana katun e ga nigaia i tamilimiu, ba limiu te kato has uamiu i iesana i tanen. Nonei u mouna u ranga te kana turu buk tere Moses nu propet has.” ");
INSERT INTO hla_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Be Iesu e poe lelena, “Alimiu go tete sila mia tara panete, taraha a maroro a tetenei te ka mena a panete e la uana tara nitoatoa, na katun te sabie nen e ma para nei. ");
INSERT INTO hla_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kaba a kalana pan te ma ka menei ta makum ta tekteki e la uar tara han a omi, na para a katun e la uar tara kalana teka.” ");
INSERT INTO hla_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Be Iesu e rangana me poiena, “Hanei sile iam u propet u gamogamo. Nori e hereri u muki u hie u hihigul, kaba nori e gamor ba te kato here rari a peisaren u sipsip te alenar. ");
INSERT INTO hla_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Alimiu e atei sil ramoen te go ruto mera mien limiu te mar kato uaroen. U korkoru e hua here nei u gerep? Nu rokrokoto e hua here nei u fik? E moa lasi. ");
INSERT INTO hla_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","U roei u niga e ka has mena u hua u niga, nu roei u omi e ka has mena u hua u omi. ");
INSERT INTO hla_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","U roei u niga e moa te ga ka menien u hua u omi, nu roei u omi e ma tatei ka has menei u hua u niga. ");
INSERT INTO hla_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","A barebana e ngats luper u roei te ma ka menei u hua u niga ba te lapo mena rien turu tula. ");
INSERT INTO hla_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ba limiu te atei sil has ramou u propet u gamogamo teka te go ruto mera mien limiu te mar kato uaroen.” ");
INSERT INTO hla_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Be Iesu e poe lelena, “Palair u katun te poier i tar ‘O Tsunono, O Tsunono’ e ma tatei tasuri romana tara Nipepeito tere Sunahan. U katun lasi te kato uar turu ngil tere Tamar i Kolö nori te tatei tasu riou romana tara Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Poata te butu nama romana u Lan teka, ba para a katun te poiena romana i tar, ‘O Tsunono, o Tsunono. Alam u hihatuts silaia tara solomulö na lam u tsuga ba sila has ria u mate u omi tara solomulö na lam u kato sila has nia u nitagala pan u para tara solomulö.’ ");
INSERT INTO hla_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ba lia te ranga hatarare gia romana i taren ba te poiegu, ‘Alia u namala haniga rai limiu. La ba nemo lia! Alimiu u katun u omi.’” ");
INSERT INTO hla_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Be Iesu e ranga lelina me poiena, “A katun te hengo uana turu ranga i tar ba te hengo hanige nen, nonei e here nei a katun a hahatongo te hatakei a luma i tanen i ieluna u lapo. ");
INSERT INTO hla_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ba langits e polo hatagalana ba ramun olo e saputu piuna ba lomolomo e bahu hatagalana ba te gasena a luma teka. Kaba a luma e ma talupui, taraha a kopinen e rokotoia turu lapo. ");
INSERT INTO hla_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Na katun te hengo uana turu ranga i tar kaba e ma hengo hanige neien, nonei e here nei a katun a tutu te hatakei a luma i tanen turu kotolana. ");
INSERT INTO hla_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ba langits e polo hatagalana ba ramun olo e saputu piuna ba lomolomo e bahu hatagalana ba te gasena a luma teka. Ba luma e talupuna ba te tarura hakapana.” ");
INSERT INTO hla_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Be Iesu e hakapena u raranga i tanen ba barebana te asingotor te mar hihatuts uen. ");
INSERT INTO hla_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Taraha, nonei e ma herei u tson hihatuts turu Lo, kaba nonei e hihatuts herei a katun te ka mei a nitsunono. ");
INSERT INTO hla_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","E Iesu e koul putaia tara tsi pokus bu katun u para koru e toan kukutie ren. ");
INSERT INTO hla_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na toa katun te ka mei a toba e la hasukusukuma, me hatukununa i matanen me poiena, “O Tsunono, te ngil mia lö ba lö te tatei kato haniga poutse mumo lia.” ");
INSERT INTO hla_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Be Iesu e hasoa nena a limanen ba te sebeleie nen me poiena, “Alia e ngiligu. Alö go niga pouts tala!” Ba toba i tanen e topei kapana ba nonei e niga poutsuna. ");
INSERT INTO hla_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Be Iesu e poiena i tanen, “Alö go hengo. Alö e moa koru te go tatei hatei menai ta toa ta katun. Kaba lö go la hamatskö u tara pris ba nonei te na rutena a peisamulö te niga pouts uanen. Ba lö te hale moien a kan hats te haruto nena a toba e kapa hamana, te ranga u e Moses i manasa. Bu katun te tatei atei sile riou a toba i tamulö e kapa koru.” ");
INSERT INTO hla_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Be Iesu e lana i iahana taun i Kapeneam, ba toa tsunono turu soldiar i Rom te ma Jiui e la uamato i tanen me ranga hatatagina i tanen me poiena, “O Tsunono, a katunun kui i tar e kana i han ba te opu mena peisanen e matekata hakapa, ne sagoho hasena a kamits pan koru.” ");
INSERT INTO hla_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Be Iesu e poiena, “Alia e na kato haniga poutse goen.” ");
INSERT INTO hla_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kaba a tsunono turu soldia e ranga palis u i tanen me poiena, “O Tsunono, alia e ma katun niga korugi ba te antunana te go la uama lö i iahana luma i tar. E moa. Alö go ranga tun ba katunun kui i tar te niga pouts nou. ");
INSERT INTO hla_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Alia e atei silegu a markato te ranga uar a pal tsunono. Alia e ka puta gia tara toa pal tsunono, na toa pal soldia e ka puta has neno lia. Alia go poe tara toa, ‘Alö go la,’ ba nonei te lana. Na lia go poe tara tai, ‘Alö go lama,’ ba nonei te la nama. Na lia go poe tara katunun kui i tar, ‘Alo go kato a toukui teka,’ ba nonei te kato hase nen. Nu ranga tun has i tamulö e ka mena a nitagala.” ");
INSERT INTO hla_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","E Iesu e hengo u ranga teka me asingotona. Ba nonei e ranga merena u katun ti kukutie ien me poiena, “Alia e ranga hamana gia i tamilimiu, alia u ma sabie mei ta toa ta katun i Israel has te ga ka mei a mar nihamana a niga te ka mena a tson teka te ma Jiu nei. ");
INSERT INTO hla_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na lia e hatei rago limiu, u katun u para te halhal ria turu Jiu e la rima romana tara mamana han. Ba nori te gum gono meroa e Abraham ne Aisak ne Jekop tara kannou i iahana a Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kaba limiu u Jiu, u barebana te go mala ka mia nonei tara Nipepeito, e Sunahan e tsuga mera noi limiu i ielesala turu kuhil. Na tara makum teka alimiu e tabe hohomi mou romana ba te har tun has mou.” ");
INSERT INTO hla_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Be Iesu e poiena tara tsunono turu soldia, “La tala. A ka e ga butu u i tamulö te mar hamana uamu lö.” Na tara poata puku lasi teka a katunun kui i tanen e niga pouts. ");
INSERT INTO hla_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ne Iesu e tasuia i iahana luma tere Pita me tarena e tsinana a tahol tere Pita e opu ba bakunen te hiskina. ");
INSERT INTO hla_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Be Iesu e hasebeliena a limanen, ba hiski i bakunen e kapana. Ba nonei e takeina me nasena a tsi kannou tere Iesu. ");
INSERT INTO hla_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na tara lahibong nori i na piou ria u katun u para u sesein mate tere Iesu. Ba nonei e ranga tununa ba te tsuga rena u mate u omi. Na nonei e kato haniga poutsir u katun hoboto ti ka mei a nimate. ");
INSERT INTO hla_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A ka teka e butu sil te ga kato hamana meni u ranga te ranga sila nia e Sunahan tara propet e Aisaia i manasa. E kato u: “Nonei e lu ba hakapein a ka te kato hapinolasa rano ra, na nonei e soata u nimate i tarara.” ");
INSERT INTO hla_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Be Iesu e tara rena u barebana u para ti gono hahise ien, ba nonei e ranga merena u katunun tsitsilo, “Ara gi la u i hapalana ramun.” ");
INSERT INTO hla_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nonei e katsin osa, ba toa tson hihatuts turu Lo e la uanama i tanen me poiena, “Tson Hihatuts, alia e la gono megou lö tara mamana han te la uamou lö.” ");
INSERT INTO hla_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Be Iesu poiena i tanen, “U muki u hie e ka mer u kiou i taren, nu apena e ka mer u suhana i taren. Kaba lia tu butun katunuma,* alia u moa ta makumun soho i tar.” ");
INSERT INTO hla_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ba tana katunun tsitsilo e poiena i tanen, “O Tsunono, e ma pina noi be tamagulia te mate nou. Alö go haniga te go na ngaho mam menien lia, ba te toan lala gono mego lö.” ");
INSERT INTO hla_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kaba e Iesu e poei i tanen, “U katun te ma hengoeri e Sunahan ba te hereri i mate ban a nitoatoa i tanen, nori te tatei ngaho ner u mate i taren. Alö go la gono memo lia.” ");
INSERT INTO hla_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Be Iesu e osana tara tsi tolala, nu katunun tsitsilo i tanen i la gono has meien. ");
INSERT INTO hla_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ba lomolomo pan e butu hamanasana, bu ramun e posa hongona tara tolala. Kaba e Iesu e soho. ");
INSERT INTO hla_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bu katunun tsitsilo e na gulie ren me poier, “O Tsunono, alö go taguhu ramo lam! Ara e katsin ruku hamanasara!” ");
INSERT INTO hla_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ba nonei e poiena i taren, “A neha tsiponi te matout sile milimiu? Alimiu e hamana hatetenei koru miu!” Ba nonei e takeina me abis hatagalena a lomolomo nu ramun me selohona. Ba lomolomo e hanoan tahutuna bu ramun e maraha koruna. ");
INSERT INTO hla_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ba nori e asingoto korur me poier, “A saha koru a mar katun teka? A lomolomo nu ramun has e hengo korue ren!” ");
INSERT INTO hla_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nori i na butuia i hapalana Ramun i Galili tara bun tsiktsikina turu Gadara. Na elasolana katun ti sesein mate i butuma turu ngahongaho ti roron ka ien, me hitupali mer e Iesu. A elasolana katun teka i hie homi koru ba te antunan kato homier a tana katun, ba barebana e matoutun sila ria tara maroro teka. ");
INSERT INTO hla_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ba elasolana e ku homi korur me poier, “Alö a Pien Tson tere Sunahan, alö go haka ba rio lam. Haromana koru, alö go ma hakamits rai lam i mam tara poatan hahuna i tamulam!” ");
INSERT INTO hla_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na toa heis poum pan i gamon kaia i pal lehana ba te nour. ");
INSERT INTO hla_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bu mate u omi e ranga hatatagi uar tere Iesu me poier, “Te tsuga ramoa lö alam, ba lö te tsuga mera moi lam tara heis poum.” ");
INSERT INTO hla_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ba nonei e poiena turu mate, “Alimiu go la iam.” Ba nori e koul ba ner a elasolana katun teka, me na sei ria tara heis poum. Ba heis poum hoboto teka e hiapipieta gala hoboto uar turu uarahana, me kurapa ria turu ramun me pasur me mate hakapar. ");
INSERT INTO hla_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bu katunun taratarakap turu poum i busuto. Ba nori e na tuku ria tara taun me habulungana ner a ka te butuia tara elasolana katun ti ka mei u mate u omi na mamana ka hoboto te butu. ");
INSERT INTO hla_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bu barebana u para koru tara taun teka e mi sakier e Iesu. Ba poata ti tare ien ba nori e ranga hatatagi merien te go la ba menien a han i taren. ");
INSERT INTO hla_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Be Iesu e osana tara tsi tolala, me kopis sila poutsna i hapalana ramun a perperere me tukuna tara taun hamatskö i tanen i Kapeneam. ");
INSERT INTO hla_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bu katun e soata menari a katun a matekata i tanen, ba te opuna tara poapoa. E Iesu e tara sabe nori i hamana koru i tanen, ba nonei e poiena tara katun a matekata, “A tsi pien, a torimulö e tatei gegaha poutsuna. Alia e lu ba negu u markato u omi i tamulö.” ");
INSERT INTO hla_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ba palabir u tson hihatuts turu Lö e hakats tunur me poier, “A katun teka e katsin gulena a nitsunono tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kaba e Iesu e atei sil hakapi u hakats i taren me poiena, “A neha tsiponi te hakats homi memi limiu i torimilimiu? ");
INSERT INTO hla_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Alimiu e ma hanigami te poe mena gulei lia, ‘Alia e lu ba negu u markato u omi i tamulö’? Bara, alia e poa hamanase gou u tana u ranga te ka has mena a toukui pan te kato uana, ‘Alö go takei ba te lam!’ ");
INSERT INTO hla_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Alia e haruto ragi limiu a mirakul teka alia tu butun katunuma e ka megu a nitagala i puta te go lu ba has menai lia u markato u omi.” Be Iesu e toan ranga mena a katun a matekata, “Alö go takei ba te soatsem a poapoa i tamulö ba lö te lam tara han i tamulö.” ");
INSERT INTO hla_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ba nonei e takeina me lana i han i tanen. ");
INSERT INTO hla_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","U katun u para i tara a ka teka me matout korur. Nori i tara sabe e Sunahan e halan a mar nitagala teka tara katun, ba nori e toan soloseier e Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Be Iesu e la lelina ba nonei e tarena a toa katun e gumia tara luman takis, a solonen e Matiu ba te kuina. Be Iesu e poiena i tanen, “Alö go mi la gono meio lia.” Ba nonei e takeina me la gono menen. ");
INSERT INTO hla_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Be Iesu e na nouna tara luma tere Matiu nu katun u para ti lulu a takis nu palair u katun i la hasima. U katun u kapan turu Jiu i ngö rien u katun u omi. Ba nori e gum gono mer e Iesu nu katunun tsitsilo i tanen me nou gono meren. ");
INSERT INTO hla_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bu Parisi e tarer a ka teka me poier turu katunun tsitsilo tere Iesu, “A neha tsiponi te nou gono mera nei a Tson Hihatuts i tamilimiu u katun te luluer a takis nu palair u katun u omi?” ");
INSERT INTO hla_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Be Iesu e hengo nena a ka teka me poiena i taren, “U katun te moar ta nimate e ma tatei la uari tere dokta. E moa. U katun lasi te ka mer a nimate te la peisa uar tere dokta. ");
INSERT INTO hla_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Alimiu go na atei nemia te mouna uana u ranga teka turu Buk u Goagono: ‘Alia e ma ngilegi te gi hats* tun u u katun i tar. Alia e ngilegu u katun e gi hiatatagi.’ Alia u ma la sile mei te go mi ngö merai u katun te poier nori e nigar. E moa. Alia u la silema te go mi ngö merai u katun te atei siler nori e omir ba te habirits hamatsköer a toriren.” ");
INSERT INTO hla_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na turu toa u lan u katunun tsitsilo tere Jon a Tsonun Baptais i la uama tere Iesu me mi poier, “Tara neha ba lam muru Parisi te roron agono nami a kannou te go singo u tere Sunahan, kaba u katunun tsitsilo i tamulö e ma agonori?” ");
INSERT INTO hla_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Be Iesu e ranga palisina, “Tara poata te hiakukoto gono meria a halis, na tsonun hitöle kana, a pala tara tson e ma tatei lohori ba te agonor. E moa. Kaba alia e heregi a toa tsonun hitöl te lu ba ner romana. Ba pala i tar te agono riou romana nonei tara poata.” ");
INSERT INTO hla_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Be Iesu e poiena, “A katun e ma tatei hakune nei a tsi makumun labalaba a tsi tsimus te ga lakopo kapin a tabutu turu labalaba u toutounei. Te kato uanen teka ba poata te galuse rien bu labalaba u tsimus te tasukupuna ba te takis ba nena a makumun labalaba a toutounei, ba tabutu te pan koru lelina. ");
INSERT INTO hla_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na lia e hatei has ragoi limiu a kan osul te kuieri a pikpiköna meme. E moa ta katun te ga tatei osul u wain u tsimus tara kan osul a toutounei teka. Te kato uanen teka, ba nitagala turu wain u tsimus te pan susuluna ba te kato butsena a kan osul a toutounei te ma antunan talas nei, bu wain na kan osul te omi hoboto hakapar. E moa. A katun e tatei osulena u wain u tsimus tara kan osul a tsimus, ba huol hoboto te ka hanigar.” E Iesu e mar ranga u teka ba te haruto ranen u hihatutsina i manasa turu Jiu e ma hisoböei menei u hihatuts u tsimus tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Poata te hatei noa reien e Iesu a ka teka, ba toa tson pepeito turu Jiu e tasu nama me hatukunna i matanen me poiena, “A pien tahol i tar e mate lala. Kaba lö go na hatakopo a limamulö i tanen ba nonei te niga pouts nou ba te toatoana.” ");
INSERT INTO hla_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Be Iesu e la gono menen nu katunun tsitsilo i tanen has. ");
INSERT INTO hla_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","A toa tahol te posa nitoan u rahatsing turu 12 u hiningal e la hasukusuku u i murina e Iesu me hasebelena i runguna u hasobu i tanen. ");
INSERT INTO hla_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nonei a tahol e poei turu hakats i tanen, “Te hasebele tun gia lia turu hasobu tere Iesu ba lia te niga pouts gou.” ");
INSERT INTO hla_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Be Iesu e habiritsina me tara uana i tanen me poiena, “E nigana, alö e hamana haniga mula ba lö te niga poutsum.” Na i teka puku a tahol e niga pouts. ");
INSERT INTO hla_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","E Iesu e tukuia tara luma tara tson pepeito me hengoena u katun i tabe ba te ketar. ");
INSERT INTO hla_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ba nonei e poiena, “La iam. A pien e ma mate nei. Nonei e soho tununa.” Poata ti hengoe ien a ka teka, nori i gol hahamanein e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kaba nori i halakasa meri i ielesala, be Iesu e tasuna me luena a limana pien, ba pien e takeina ba te niga poutsuna. ");
INSERT INTO hla_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Bu bulungana tara ka teka e tasata uato tara han a para ti sukusuku. ");
INSERT INTO hla_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Poata te la ba nia e Iesu a han teka, a elasolana katun a kiau i kukutie ien me ku hapanir me poier, “A Hatutubunei tere Devit a King pan i tarara, alö go tatagi ramo lam!” ");
INSERT INTO hla_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Be Iesu e tasuna tara luma bu matakiau e la uarima i tanen ba nonei e poiena i taren, “Alimiu e hamanemiu te antunan katoe gulia a mirakul teka te ngile milimiu?” Ba nori e hatanganar. ");
INSERT INTO hla_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ba nonei e sebeliena a mataren me poiena, “E tatei butu hapopona te hamana uami limiu.” ");
INSERT INTO hla_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ba nori e toan tara poutsur! Be Iesu e ranga hatagala mera nen me poiena, “E moa te go hatei mena milimiu ta toa tara ka teka!” ");
INSERT INTO hla_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kaba nori i habulungana lan e Iesu tara han a para ti sukusuku. ");
INSERT INTO hla_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nori i la hakapa, bu katun e mi piou ner a toa katun a biru tere Iesu, taraha a mate a omi e seseiia i tanen. ");
INSERT INTO hla_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Be Iesu e tsuga ba nena a mate a omi ba katun e toan ranga poutsuna. Bu katun e asingoto koruru me poier, “E moa koru te ga butu u a mar ka teka i Israel i manasa!” ");
INSERT INTO hla_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kaba u Parisi i poei, “A tsunono turu mate u omi te hale ien a nitagala te go tsuga ba merien u mate u omi!” ");
INSERT INTO hla_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ne Iesu e hula laia turu taun nu han hoboto. Nonei e hihatutsia turu luman lotu turu Jiu ba te hatei nena u Bulungana u Niga tara Nipepeito tere Sunahan. Na nonei e kato haniga poutsir u katun ti ka mei a mamana mar nimate. ");
INSERT INTO hla_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ba tara poata te tara rien u katun u para ti gono, ba nonei e tatagi ranen, taraha nori i sökana me tutu hasir ba te ma antunan taguheri a peisaren, te kato uar u sipsip te moar ta tsonun taratarakap. ");
INSERT INTO hla_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Be Iesu e poiena turu katunun tsitsilo i tanen, “U katun u para e katsin hamana uar i tar, kaba e moa ta katun ta para te ga taguhu raien. E kato uana tara kui pan te tangoho hakapa ba te moana ta katun ta para te gi hagale iema a kannou. ");
INSERT INTO hla_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Alimiu go singo uam tara Tsunono te kato hahaloso mamir u katun teka ba te katsin hamana uar i tar. Alimiu go singo uam tara Tsunono ba te hala lel rena u katunun tsitsilo te gi la uen ba te na taguhu rer u katun e gi la uama i tar.” ");
INSERT INTO hla_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Be Iesu e ngö gugono rena a 12 a katunun tsitsilo i tanen ba nonei e hala rane ien a nitagala te gi tsuga ba merien u mate u omi ba nori te kato haniga pouts rer u katun te ka mer a mamana mar nimate. ");
INSERT INTO hla_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na nonei a man solo teka tara 12 a katun te ngöri e Iesu u aposol* i tanen: Saimon ti ngö hasei e Pita. Endru e toulane Saimon. Jemis a pien tere Sebedi. Jon e toulane Jemis. ");
INSERT INTO hla_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip. Batolomiu. Tomas. Matiu te lulu a takis. Jemis a pien tere Alpias. Tadias. ");
INSERT INTO hla_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon te tagala sil a han i tanen. Judas Iskeriot a katun te ga harutein romana e Iesu turu katun ti omien. ");
INSERT INTO hla_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tara poata te hala ria e Iesu u katun teka te gi na hihatuts la uen, ba nonei e poiena i taren, “Alimiu go ma la uami turu katun te halhal ria turu Jiu na turu han has i Sameria. ");
INSERT INTO hla_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Alimiu go la las uam turu katunur i Israel te ma atei sile rilia ba te hereri u sipsip te tiar. ");
INSERT INTO hla_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ba limiu te na habulungana nemiu u raranga teka: ‘A Nipepeito tere Sunahan e sukusuku nama!’ ");
INSERT INTO hla_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Alimiu go kato haniga pouts reiam u katun te ka mer a nimate ne go hatakei pouts has reiam u katun ti mate. Ba limiu te kato haniga pouts remiu u katun u toba ba te tsuga ba has remiu u mate u omi. Alimiu u lu pukue iam a nihitaguhu ba te ma hole mien, na limiu go taguhu has reiam u katun ba te ma luemi ta hihol. ");
INSERT INTO hla_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Na limiu go ma la has memi ta moni. ");
INSERT INTO hla_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Alimiu go ma la has memi a pora nu sendol nu tukana tara nilala i tamilimiu. E moa. Alimiu e la las memiu u toa puku u hasobu u ngahangaha. U katun te taguhu rami limiu e tatei hanou rariou limiu. ");
INSERT INTO hla_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Na poata te la mia limiu a man toa toa i iahana toa taun tsi tara han, alimiu go tara sakesakie iam a luma tara katun a niga te haniga rano limiu ba limiu te ka mia i tanen antunana te la ba nemia limiu a taun teka. ");
INSERT INTO hla_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tara poata te na tasu mia limiu tara luma teka, ba limiu te hala remi u katun i tanen a masalohana. ");
INSERT INTO hla_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na te lu raroa u katun teka alimiu, ba masalohana i tamilimiu te tatei kakana i taren. Kaba te ma lu raro ien limiu, ba masalohana e tatei taguhu pouts rano limiu peisa. ");
INSERT INTO hla_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Te ma lu mera nei limiu a toa hun katun i luma i taren tsi tara taun i taren, na te ma hengo has rarien limiu, ba limiu te tohu ba nemiu u koahu i pitpitan moumilimiu poata te la ba remien limiu. A ka teka e haruto nanou te raharaha mera neien e Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","U mana koru alia e hatei rago limiu, a nihahuna tara taun teka e pan nanou romana a nihahuna turu taun i Sodom ni Gomora.” ");
INSERT INTO hla_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Be Iesu e poiena, “Hengo iam! Alia e hala mera gilimiu i gusur u katun u omi, e here nei te la uar u sipsip i gusur u muki u hie. Alimiu go tara kap here moi a kukutsi, ba limiu te here hase moi a kulu te ma kato homie nei ta ka. ");
INSERT INTO hla_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Hanei iam! Taraha, u katun e pile kap rariou limiu ba te lu mera rilimiu turu kot, ba nori te lahus has raroa limiu turu luman lotu i taren. ");
INSERT INTO hla_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nori e haka raroa limiu i matar u tsunono nu king te hamana uami limiu i tar, taraha alia e ngilegu alimiu go hatei ramien u Bulungana u Niga na turu katun has te halhal ria turu Jiu. ");
INSERT INTO hla_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Na poata te kot raroen limiu, e moa te go hakats hapara uam limiu ba te poiemiu, ‘Ime te mar ranga halona uagou lia? Na aha te poe gou lia?’ E moa. U ranga u matskö e butu noa i tamilimiu tara toa poata noa lahas. ");
INSERT INTO hla_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Alimiu peisa te ma ranga moi. E moa. U Namnamei tere Tamamilimiu e Sunahan te haranga ranou limiu. ");
INSERT INTO hla_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Na nonei tara poata, u katun e hala mera roi u toularen te gi kato hamate merien, bu palabir u katun te haniga riou te gi kato hamate merai a galapien pouts i taren. Na palabir a galapien e omi has reriou u tsinaren nu tamaren, bu tsinaren nu tamaren te kato hamate has rariou. ");
INSERT INTO hla_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","U katun u para e omi rariou limiu te hamana uami limiu i tar. Kaba a katun te hamana nitoa uana i tar, e Sunahan e lu pouts mena noien i tanen. ");
INSERT INTO hla_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Na tara poata te kato homi pino ria u katun i tamilimiu tara toa taun, ba limiu te bus ba namen ba te la uamiu tara tana taun. U mana koru alia e hatei rago limiu, alimiu e ma hakapa noa hase moi a toukui i tamilimiu tara mamana taun hoboto i Israel, ba lia tu butun katunuma te la pouts guma romana. ");
INSERT INTO hla_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“A katunun tsitsilo e ma pan nanei a tson hihatuts i tanen, na katunun kukui puku* e ma pan has nanei a katun pan i tanen. ");
INSERT INTO hla_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","E nigana te kato here mena nei a katunun tsitsilo a peisanen a tson hihatuts i tanen. Ne niga hasina te kato here mena nei a katunun kukui puku a peisanen a katun pan i tanen. Alia a katun pan tara pal barebana i tar. Nu palair u katun e ngö tsipone rilia e Bielsibul.* Te mar kato uaren teka, ba nori te ngö tala rario limiu u katun u omi koru, taraha alimiu e pala uamiu i tar.” ");
INSERT INTO hla_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","E Iesu e ranga lel me poiena, “Alimiu go ma matout rami u katun. E moa. Taraha, a man ka hoboto te hamouser i romana e butu noa romana i matar u katun turu ualesala i murimuri. ");
INSERT INTO hla_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","U raranga te hala negia lia i tamilimiu te ka pepeisa ria ra, alimiu go habulungana namien turu katun hoboto. ");
INSERT INTO hla_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Na limiu go ma matout rami u katun te puli hamatier u tuanrei, ba te ma antunan kato hamatieri u namnamei. E moa. Alimiu go matout lase iam e Sunahan, taraha nonei e antunan kato homi nitoe iena u tuanrei nu namnamei has i hel. ");
INSERT INTO hla_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Alimiu e antunan holemi a solana a tsi apena a 10 toea puku. Kaba e moa koru ta toa te ga tatei tuhamateni puta te go ma haniga uai e Tamamilimiu. ");
INSERT INTO hla_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Na limiu go ma matout has rami u katun, taraha e Sunahan e tara kap rano limiu, na limiu e niga bala koru namiu u apena i matane Sunahan. Nonei e atei sil hasena u hihase tara ma tsi hulu hoboto i bakumilimiu.” ");
INSERT INTO hla_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Be Iesu e poiena, “Te hatei rena a katun u barebana nonei a katun i tar, ba lia te hatei hase gou e Tamar i Kolö nonei a katun i tar. ");
INSERT INTO hla_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kaba te holis nena a katun nonei a katun i tar i matar a barebana, ba lia te holis has nagoen romana tere Tamar i Kolö.” ");
INSERT INTO hla_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Be Iesu e poe lelena, “Alimiu go ma poemi alia u la silema te go mi hala meni a masalohana tara barebana i puta. E moa. Alia u ma la memei a masalohana. Alia u la mema a hiatatung. ");
INSERT INTO hla_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","E kato uana, a katun te hahamanana na tou sungutunen te hamane nolia e hiapalpal riou. Hena, a tson e pal nanou e tamanen, na tahol e pal nanou e tsinanen, na tana tahol e pal nanou e tsinana tson i tanen. ");
INSERT INTO hla_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“A katun te ngil koruena e tamanen ne tsinanen, ba te ma ngil saluhe korue nei lia, a katun teka e ma antuna nei te gi ngö menien a katun hamana i tar. Na katun te ngil koruena a pien tson i tanen na pien tahol i tanen ba te ma ngil saluhe korue nei lia, nonei e ma antuna has nei te gi ngö menien a katun hamana i tar. ");
INSERT INTO hla_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Alimiu go haniga iam te go sagoho menami u kamitsina te kukute mena milimiu alia, te mar kato uana a katun te soatsena a korusena tara tou mate i tanen. Te rama mia limiu, ba limiu te ma antunami te gi ngö meri u katun hamana i tar. ");
INSERT INTO hla_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Te ngil korue mia limiu te go haka haniga meni a nitoatoa i tamilimiu i puta ba te peits namien i tar, ba nitoatoa i tamilimiu te taia noa has nou romana. Kaba te mate sile moa limiu alia, alimiu e na sabie mou romana a nitoatoa hamana i tamilimiu.” ");
INSERT INTO hla_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","E Iesu e ranga lel me poiena, “A katun te nigana i tamilimiu e niga hasna i tar. Na katun te nige nolia, nonei e niga hasna tere Tamar te hale molia. ");
INSERT INTO hla_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Na katun te tarena a tana katun te rararie nen u ranga tere Sunahan, ba te hanige nen na toukui i tanen, nonei e lue nou romana u hamatana te lu hase nou a katun te rarariena u ranga tere Sunahan. Na katun te tarena a tana katun te matsköna i matane Sunahan ba te hanige iena nonei a tana katun, nonei e lue nou u hamatana te lu hase nou a katun a matskö. ");
INSERT INTO hla_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na lia e hatei hamana rago limiu, a katun te tarena a tsi katun papala koru i tar ba te haue neien a tsi ramun, nonei e lu korue nou u hamatana u niga.” E Iesu e ranga hanoaia teka. ");
INSERT INTO hla_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","E Iesu e hala hakapein u ranga teka tara 12 a katunun tsitsilo i tanen, ba nonei e toan la ba nena a han teka me na hihatutsna ba te rarare lana turu taun te ka hasukusukur. ");
INSERT INTO hla_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","E Jon a Tsonun Baptais e ka silia tara karabus tara poata teka te rarare menien u ranga tere Sunahan. Ba nonei e hengo nena a man toukui a man niga te kato e Iesu. Ba nonei e hala mera namei a palabir u katunun tsitsilo i tanen tere Iesu. ");
INSERT INTO hla_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ba nori e mi poier tere Iesu, “Alö go hatei ramo lam, alö nonei a katun te rarangein e Jon te ga la uama i puta? Tsi alam go hahaloso a tana katun?” ");
INSERT INTO hla_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Be Iesu e ranga palis uana i taren me poiena, “Alimiu go na hateimi e Jon a man ka te tare milimiu na man ka te hengoe milimiu. ");
INSERT INTO hla_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","E kato uana: u katun u kiau e tara poutsur, nu katun u mou-omi e tatala poutsur, nu katun u toba e niga poutsur, nu sikö e hengo haniga poutsur, nu katun ti mate hakapa e toatoa pouts hasir. Nu katun papala e hengoer u Bulungana u Niga. Alia te katoegu a man ka teka. ");
INSERT INTO hla_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na katun te ma hapolase nei a nihamana i tanen i tar e sasala nou!” ");
INSERT INTO hla_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Na poata ti la poutsia u katunun tsitsilo tere Jon, be Iesu e hatei ranei u katun e Jon me poiena, “Poata tu la uam limiu tara latu pinopino te go na tara mena milimiu e Jon, alimiu u poe iam nonei a saha mar katun? E here nei u nga te hula bahena a lomolomo ba te haharoei nena a katun te hula hakatsina? E moa. ");
INSERT INTO hla_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tsi alimiu u la sil iam te go na tara menami a katun te ka mei u hasobu u niga koru? Kaba a mar katun teka e kana tara luma a tsimala koru tara king. E ma tatei ka neia tara latu pinopino. ");
INSERT INTO hla_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tsi alimiu u la sil iam te go na tara menami a propet? Aa, e Jon a propet hamana. Na lia e hatei rago limiu, nonei a katun te pan hasna tara propet. ");
INSERT INTO hla_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Taraha, u Buk u Goagono e hatei nena a katunun tatala e Jon te poe nen, ‘E Sunahan e poiena, Hengo iam. Alia e hala negu romana a katunun tatala i tar te go mam nio lö, ba nonei te na hamatsköena romana a maroro i tamulö.’ U Buk u Goagono te mar ranga uana teka. ");
INSERT INTO hla_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na lia e hatei hamana rago limiu, e Jon a Tsonun Baptais e panna turu katun hoboto ti poseia i puta. Kaba a katun papala koru tara Nipepeito tere Sunahan e pan has nena e Jon, te kato a toukui i tanen i mam tara Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Na tara poata te rararieia e Jon u ranga i tanen ba te noana i romana, u katun i tagala sil a Nipepeito tere Sunahan, ba nori e torohana hatagala sil haser te gi tasu uen i tanen. ");
INSERT INTO hla_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Na i mam tara poata tere Jon a Tsonun Baptais, u propet hoboto ni manasa nu ranga has tere Moses, nori i hatein a Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na te hamane mia limiu u ranga i taren, ba limiu te atei silemiu e Jon nonei a katun te ngöei u Buk u Goagono e Ilaitsa ba te poiena nonei e ga lama. ");
INSERT INTO hla_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","A katun te atein hengona e ga hengo haniga! ");
INSERT INTO hla_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","“Ga lia e go poei alimiu a barebanar i romana e heremi a ha? A saha ka te tatei haharoei rano limiu? Alimiu e heremi a galapien te hirata ria tara toana, ba palai i taren te poier, ‘Alam e katoe mula u kömana tara hitöl, kaba limiu e ma sasala mulei! Na lam e köma hase mula u hahuri, kaba limiu e ma tabe mulei!’ ");
INSERT INTO hla_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ne kato has uana i iesana tere Jon a Tsonun Baptais na lia. E Jon e ma tatei noui a tana kannou ne namala ua hasei tu wain. Ba limiu e poemiu, ‘Nonei a katun a popoloana.’ ");
INSERT INTO hla_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na lia tu butun katunuma e tatei nouegu a mamana kannou, ne tatei ua hasegu u wain. Kaba limiu e poemiu, ‘Pua! Nonei a nounou-pala, na katun a uaua-pala. Na nonei e kapiena has rena u katun te luluer a takis nu katun u omi.’ Alimiu e mar ranga uamiu teka. Kaba noahasina, a man markato turu katun tere Sunahan e haruto nena te mana uana a niatei i tanen.” ");
INSERT INTO hla_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Be Iesu e tanian ranga sisi rena u katun tara man taun te katoe men u mirakul u para. Taraha, nori i hengo u ranga u mana kaba nori i ma tori-tsuga bani u markato u omi i taren. ");
INSERT INTO hla_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ba nonei e poiena, “A nomi pan koru e butuna romana i tamilimiu u katunur turu taun i Korasin na i Betsaida! Sanena e Sunahan e ga kato u mar mirakul turu taun i Taia na i Saidon i manasa tu kato u lia i Korasin na i Betsaida tara poata i romana, i manasa noa nori sane harutein ti tori-tsuga ba koru menien u markato u omi i taren. ");
INSERT INTO hla_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Na lia e hatei rago limiu, turu lanin hahuna tere Sunahan a nihahuna i tamilimiu u barebanar i Korasasin na i Betsaida e pan bala nanou a nihahuna tara barebanar i Taia na i Saidon. Taraha, alimiu u hipus niam u ranga u mana ti namala hengo nien. ");
INSERT INTO hla_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na limiu u katunur tara taun i Kapeneam e ngilin soloseiemiu a peisamiu i iasa, kaba e Sunahan e lapo ba has ranoa limiu i puta i hel! Sanena e Sunahan e ga kato u mar mirakul tara taun i Sodom i manasa tu kato u lia i Kapeneam, a taun i Sodom sane ka noana i romana. ");
INSERT INTO hla_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Na lia e hatei hamana rago limiu, turu lanin hahuna tere Sunahan, a nihahuna i tamilimiu a barebanar i Kapeneam e pan bala nanou a nihahuna tara barebanar i Sodom. Taraha, alimiu u hipus has niam u ranga u mana ti namala hengo nien.” ");
INSERT INTO hla_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tara poata teka e Iesu e mar singo u teka, “O Tamar, alö e Tsunono pan mia i Kolö na i puta has. Alia e haniga uagu i tamulö te hamous mena milö u ranga u mana turu katun te poier e ka mer a niatei, ba te haruto namen turu katun papala te ma atei balari. ");
INSERT INTO hla_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aa, O Tamar, alö e mar kato uam teka turu ngil peisa i tamulö ba lö te sasala memen.” E Iesu e mar singo u teka. ");
INSERT INTO hla_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Be Iesu e ranga lelina me poiena, “E Tamar e hale moi lia a mamana ka hoboto. Ne moa ta tan ta katun te ga atei sileio lia a Pien Tson tere Sunahan. E Tamar peisa. Ne moa has ta katun te ga atei sil e Tamar. Alia peisa a Pien Tson i tanen te atei silegu e Tamar, nu barebana te haruto ragoi lia e Tamar, nori e tatei atei sil hase ren. ");
INSERT INTO hla_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“La uamuma i tar, alimiu hoboto te kui hatagala koru miu, ba te ka memiu u hakhakats u kapan. Alia e hahusa ragou limiu. ");
INSERT INTO hla_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Alimiu go haniga iam ba lia te hatuts rago limiu. Alia e roron kato hateteneiegu a peisar, ba te hatami regu u katun. Ba lia te hahusa poutse gou a torimilimiu. ");
INSERT INTO hla_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","A toukui i tar e ma pan bala nei i tamilimiu, nu hihatuts i tar e ma tutu koru has nei i tamilimiu.” ");
INSERT INTO hla_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tara pal poata teka e Iesu nu katunun tsitsilo i tanen i laia i gusuna kuin wit turu Lan u Goagono turu Jiu. U katunun tsitsilo i sagoho a bes ba nori e tanian patsiker a hua turu wit ba te noue ren. ");
INSERT INTO hla_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nu Parisi i tara a ka teka ba te poier tere Iesu, “Pua! U Lo i tarara e ranga hapiu nena te gi kato meni a markato teka turu Lan u Goagono!” ");
INSERT INTO hla_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Be Iesu e poiena i taren, “Alimiu go mala rit hanige iam a ka te kato e Devit e tuburara a king ni manasa. Tara toa poata nonei nu pal katun i tanen i moa ta kannou ba nori i besuto. ");
INSERT INTO hla_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ba nonei e tasuna tara luma tere Sunahan ba pris e haniga nena te gi nou menien u beret u goagono ti hakeia i matane Sunahan. U Lo turu lotu i tarara e hapiun te gi ma nou menien a beret teka. U pris peisa te tatei noue ren. Kaba e Sunahan e ma kot mei e Devit nu katun i tanen, na limiu go ma si has rami lam! ");
INSERT INTO hla_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Na limiu go mala rit haniga hase iam a makum turu Lo tere Moses te hatei nena u pris te tatei kui ria i iahana Luman Lotu Pan turu Lan u Goagono. U Lo e hapiu nena te gi ma kui uai u katun turu Lan u Goagono, kaba u pris e kuir, ba te ma omi has ria i matana u Lo. ");
INSERT INTO hla_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na lia e hatei rago limiu, a katun e kana teka te pan koruna tara Luman Lotu Pan. ");
INSERT INTO hla_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ne Sunahan e ranga has turu Buk u Goagono me poiena, ‘Alia e ma ngilegi te gi hats tun u u katun i tar. E moa. Alia e ngilegu u katun e gi hiatatatagi.’ Sanena tu atei sile iam limiu ime te mouna uana u ranga teka, alimiu sane ma torohanan kot merami u katun teka te ma kato homi lilei. ");
INSERT INTO hla_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Taraha, alia tu butun katunuma te pan gia turu Lan u Goagono i gusumilimiu hoboto.” ");
INSERT INTO hla_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","E Iesu e gamon la lel me na tasuna tara toa luman lotu turu Jiu. ");
INSERT INTO hla_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na toa katun e kaia teka te ka mei u ualima u mate. Nu palabir u katun i ka has ba te sakier a ka te gi saka meien e Iesu ta ka te omina. Ba nori e rangatse ren me poier, “U Lo i tarara e haniga hasina te gi kato haniga pouts meni a katun turu Lan u Goagono?” ");
INSERT INTO hla_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Be Iesu e mar ranga palis mera neien teka: “Te ga ka meia ta toa i tamilimiu a toa sipsip, ba sipsip te rus uana i iahana kiou pan turu Lan u Goagono, ba nonei te lu ba nanoen tara kiou, tsime? Aa. ");
INSERT INTO hla_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na toa katun e niga bala koru nena a toa sipsip. Nu Lo i tarara e haniga hasina te tatei taguhu mena nei a tana katun turu Lan u Goagono.” ");
INSERT INTO hla_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Be Iesu e poieto tara katun a lima-mate, “Alö go haparorema a limamulö.” Ba katun e haparorena a limanen, me niga pouts here nei a tabina limanen. ");
INSERT INTO hla_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Na poata ti tareia u Parisi a ka teka, ba nori e lakasar me na korupakö ner te gi atung hamate menien e Iesu.* ");
INSERT INTO hla_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na poata te hengo nia e Iesu a ka teka, ba nonei e la ba nena a han teka bu katun u para e kukutie ren. Na nonei e kato haniga pouts hasir u katun hoboto ti ka mei a nimate. ");
INSERT INTO hla_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ba nonei e ranga mera neien te gi ma hatei menien turu palabir u katun. ");
INSERT INTO hla_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","18","A ka teka e butu sil te go kato hamana meni u ranga tere Aisaia a propet te koloto menien e Iesu i manasa ba te poiena, “E Sunahan e poiena, ‘Nonei a katunun kui i tar teka, a katun tu hopu kapin lia. Nonei a tsomi i tagulia na torir e sasala koru menen. Na lia e hale goien u Namnamei i tar, ba nonei te habulungana has nanou a markato a matskö i tar turu katun te halhal ria turu Jiu. ");
INSERT INTO hla_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kaba nonei e ma ngena noi ba te elena. Na nonei e ma ranga hapan noi i iahana u taun. E moa. ");
INSERT INTO hla_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A katun a palabasa koru na katun te ka mena a tsitabubun nihamana koru e hereri u nga te tasopolona tsi u lam te katsin osona. Kaba nonei a katun i tar teka e ma tori-tsuga ba nanoi a mar katun teka. E moa. Nonei e tagala noa has bera nou u katun, e antunana te tagala saluhe noa a markato a matskö i tanen u nomi hoboto. ");
INSERT INTO hla_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nu katun te halhal ria turu Jiu e hamane roen ba te hahaloso hase roen.’” ");
INSERT INTO hla_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bu katun e mi piou naria a toa katun tere Iesu. A katun teka e matakiau ne biru has, taraha nonei a sesein mate. Be Iesu e kato haniga poutse ten, ba katun e tara poutsuna ba te ranga haniga pouts hasina. ");
INSERT INTO hla_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bu katun hoboto e asingoto koru ner e Iesu me poier, “Nonei toum a Hatutubunei tere Devit a King te hahaloso nitoa nera ra?” ");
INSERT INTO hla_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Na pala turu Parisi i ka has. Nori i ranga hamomousin e Iesu me poier, “Nonei e antunan tsuga ba rena u mate u omi, taraha a tsunono i taren e Bielsibul e hale ien a nitagala te ga tsuga ba merien.” ");
INSERT INTO hla_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","E Iesu e atei sil u hakhakats i taren ba te poiena, “Te gi hiatatungia a barebana tara toa han pan ba han teka te ma tatei tagala nei. Na te gi hiatatungia a toa han tsi a toa hunhaposa, bu katun teka te ma tatei ka haniga lel hasri. ");
INSERT INTO hla_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na te tsuga ria e Satan u katun i tanen, ba nipepeito tere Satan te here nei e takatana, ba te tarura nou romana. ");
INSERT INTO hla_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","U katunun tsitsilo i tamilimiu e tsuga ba has rer u mate u omi turu katun. Ge Bielsibul e hala rane ien a nitagala teka? E moa. Bu katun pouts i tamilimiu e haruto ner alimiu e ranga hakölomiu te poe mena milimiu e Bielsibul e hale nei lia a nitagala te go tsuga ba meri u mate u omi. ");
INSERT INTO hla_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","E moa. U Namnamei tere Sunahan te hale nei lia a nitagala te go tsuga meri u mate, na ka teka e haruto nena a Nipepeito tere Sunahan e butu talana i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Te ngilin tasuna a toa katun i luma tara katun a tagala ba te lu ba nena a man ka i tanen, nonei e tatei kits mamena a katun a tagala. Ne kato has uana i iesana i tar. Alia e ka megu a nitagala te go tagala saluhe meni e Satan. Nonei a ka teka te antunan kato homi sil mera gilia a pala i tanen. ");
INSERT INTO hla_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“A katun te ma hanige nei lia e omie nolia. Na katun te ma gono bera nei lia u katun e here nei e sata ba rane ien lia. ");
INSERT INTO hla_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ba lia te hatei rago limiu, e Sunahan e tatei lu ba nenou a man markato hoboto a man omi ti kato u barebana, nu ranga u omi has te ranga sesei naria i tanen. Kaba esi te ranga homi nena u Namnamei tere Sunahan, e Sunahan e ma tatei lu ba nanoi a markato a omi i tanen. ");
INSERT INTO hla_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","A katun te ranga homi neno lia tu butun katunuma, e Sunahan e tatei lu ba nanou a markato a omi i tanen. Kaba a katun te ranga homina turu Namnamei u Goagono, e Sunahan e ma tatei lu ba koru nanoi a markato a omi teka i tanen, tara poata i romana, na tara poata has i murimuri.” ");
INSERT INTO hla_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Be Iesu e ranga noana me poiena, “U roei u niga e ka mena a hua a niga. Nu roei u omi e ka has mena a hua a omi. U katun e hamoue ier u roei tara hua i tanen. Nu katun e hamou hase ier a katun tara markato nu ranga i tanen. ");
INSERT INTO hla_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Alimiu u katunur tara kukutsi a omi —alimiu u katun u gamogamo! Na limiu e ma antunan ranga hanigami, taraha alimiu u katun u omi. U rung e roron ranga nena a saha ka te saputena u tori. ");
INSERT INTO hla_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A katun te ka mena u hakats u niga i torinen e habutsena a markato nu ranga te nigana. Na katun te ka mena u hakats u omi i torinen e habutsena a markato nu ranga te omina. ");
INSERT INTO hla_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Na lia e hatei ragi limiu, turu Lanin Hahuna i murimuri, u katun e hateie roi romana e Sunahan a mouna a man ranga pinopino hoboto ti kate ien i puta. ");
INSERT INTO hla_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","E Sunahan e hamou mera noi romana limiu u ranga tun i tamilimiu. Nonei e ngö hapopo ranoa limiu u katun u matskö tsi u katun te gi hahuner turu ranga te katoe milimiu.” ");
INSERT INTO hla_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ba palabir u tson hihatuts turu Lo nu Parisi i poieto tere Iesu, “Tson Hihatuts, alam e ngilem alö go habutu tu mirakul te haruto nena alö u la hamanama tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Be Iesu e poiena i taren, “Alimiu a hei barebana a omi tu hapolasa hakapa ba niam e Sunahan te kato silemiu te go tara menami tu mirakul. Kaba alia e ma tatei haruto nagi tu toa tu mirakul. A hatoatongo lasi tere Jona a propet i manasa te haruto ragi lia limiu. ");
INSERT INTO hla_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","E Jona e keia i iahana torina iena pan u topisa u lan na topisa bong, ne kato has uana i iesana alia tu butun katunuma e na ke goa i iahana kioun mate u topisa u lan na topisa bong. ");
INSERT INTO hla_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Poata te butu noa romana u Lanin Hahuna, ba pal barebanar i Nineva te saka meroi a hei barebana i romana u ranga, ba te haruto ner te ga hahuna meri e Sunahan alimiu. Taraha, a tei Nineva i hengo u raranga tere Jona me hapolaser u markato u omi i taren. Na a toa katun te pan bala nena e Jona e kana teka, kaba limiu e ma hapolasa noa hasemi u markato u omi i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na turu Lanin Hahuna, a Tetahol panina i Siba e saka mera noi a hei barebana i romana u ranga, ba te haruto nena te ga hahuna meri e Sunahan alimiu. Taraha, nonei a tetahol e la halehana koruma te go mi hengo menien u hihatuts u niga tere King Solomon. Na lia e hatei rago limiu, a katun te pan bala nena e Solomon e kana teka, kaba limiu e ma hengoe mien.” ");
INSERT INTO hla_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","E Iesu e ranga lel me poiena, “Alimiu a hei barebana a omi i romana e heremi a katun a popoloana. Poata te la ba nena a mate a omi a katun, ba nonei te lagi sakesakiena ta makum te go na husa ien tara makum pinopino i gusuna latu. ");
INSERT INTO hla_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ba nonei te hakats nena nonei a katun te la ba nemen me poiena, ‘Alia e la pouts gou tara luma tu la ba nema lia.’ Ba nonei te na sabiena e beköna, ne gogosona ne taratara haniga hasina. ");
INSERT INTO hla_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ba nonei a mate a omi e na lu lelena a tana elahit a mate ti omi koru naien. Ba nori e mi ka gono merien i iahana katun teka. Na i romana nonei a katun e omi bala koru nena a poata i manasa. Ne kato has uana i iesana, alimiu has e omi bala koru namiu a poata i manasa, taraha alimiu e tori-tsuga namo lia.” ");
INSERT INTO hla_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Poata te ranga noaia e Iesu turu katun, be tsinanen nu toulanen i tukuto. Ba nori e tuol ria i ielesala me rangata ner te gi ranga gono menien e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ba toa katun e poiena tere Iesu, “E tsinamulö nu toulamulö e tuol ria i ielesala ne ngilin ranga gono merio lö.” ");
INSERT INTO hla_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Be Iesu e ranga palise nen me poiena, “E tsinar nu toular?” ");
INSERT INTO hla_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Be Iesu e tus uana turu katunun tsitsilo i tanen me poiena, “Ruto! A barebana i rekeso e hereri e tsinar nu toular. ");
INSERT INTO hla_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Eresi te katoer u ngil tere Tamagulia i Kolö, nori e hereri u toular nu hahinar ne tsinar.” ");
INSERT INTO hla_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na nonei has turu lan be Iesu e la ba neto a luma me na gumuna i rehina Ramun a Perperere i Galili, me hihatutsina. ");
INSERT INTO hla_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","U katun ti gono uama i tanen i para koru, ba nonei e na osato tara tsi toa tsi tolala me gumna i tanen. Na barebana i tuolia i monsingmou. ");
INSERT INTO hla_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nonei e hatuts rane ien a ka para turu haharoei. Na toa haharoei e kato u teka: “A katun e na hula tsihasein a ngalina kannou. ");
INSERT INTO hla_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tara poata te tsihasa nien a ngal tara kui, ba palainu ngal te pururuku ria i maroro, bu apena e la rima me mi nou hakape ren. ");
INSERT INTO hla_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Na palai i pururukuia turu tsikitsiki te ka mei u lapo, ba te ka mena a tsitabubun tsikitsiki koru. Bu ngal e pusuku boroborona, taraha u tsikitsiki e ma lai i iogana. ");
INSERT INTO hla_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ba poata te la seima a pitala me piri halangoe nen, taraha a poloso e ma la uai i iogana, ba man kan leba teka e lango boroborona. ");
INSERT INTO hla_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Na palair u ngal i pururukuia turu tsikitsiki te ka mei u kolits u hihitoka, bu kolits e panir me kato homier a man kan leba teka. ");
INSERT INTO hla_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ba palainu ngal e pururuku ria turu tsikitsiki u niga, me panina me ka mena a hua. A palabi i ka mei a hua a para koru, na palabi i ka mei a hua te molo para, na palabi i ka mei a hua te ma para balai.” ");
INSERT INTO hla_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Be Iesu e poiena, “A katun te atein hengona e ga hengo haniga.” ");
INSERT INTO hla_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bu katunun tsitsilo e la uarima tere Iesu me rangatse ren, “Taraha ba lö te ranga nem u haharoei poata te ranga mia lö i taren?” ");
INSERT INTO hla_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Be Iesu e poiena, “E Sunahan e haruto ranei limiu a ka te ma haruto rien u barebana i manasa. Alimiu e atei sil talemiu ime te mar pepeito kap uanen. Kaba barebana teka e ma ateiri. ");
INSERT INTO hla_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Taraha, a katun te ateina, e Sunahan e hala lele noien romana a niatei, ba nonei te ka mena romana a niatei a niga. Kaba a katun te raman ateina, e Sunahan e lu ba nenou romana a tsitabubun niatei te ka menen. ");
INSERT INTO hla_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nonei a ka te ranga megi lia u haharoei tara barebana teka, taraha nori e tarar kaba e ma tara hamanari, na nori e hahengor kaba e ma hengo hamanari, ne ma atei hasri. ");
INSERT INTO hla_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","U ranga tere Aisaia a propet i manasa e butu hamana sila tala nama turu katun teka. E Aisaia e kolotein u ranga te hala meni e Sunahan turu Jiu me kato uana: ‘Alimiu e hahengo mou ba te hengo talasimiu, kaba limiu ma atei koru moi romana. Alimiu e tara mou ba te tara tun talasimiu, kaba limiu e ma tara hamana koru moi romana.’ fl ");
INSERT INTO hla_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ne Sunahan e poei tere Aisaia, ‘U katun teka e baku-kits hakapar. Nori i tupi a talingaren, na nori i hasohi a mataren. Taraha, nori e poier a mataren e namos tarana, na talingaren e namos hengona, nu hakhakats i taren e namos ateina. Nori e raman habirits pouts uar i tar te go kato haniga pouts merien lia.’ Te ranga u e Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Kaba limiu e tatei sasalamiu. Taraha, a matamilimiu e tarana, na talingamilimiu e hengona. ");
INSERT INTO hla_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Hakhakats niam a ka teka! U propet u para nu katun u para tere Sunahan i manasa i ngilin tara koru a man ka te tare milimiu, kaba nori i ma antunai. Na nori i ngilin hengo koru a man ka te hengoe milimiu, kaba nori i ma antuna hasi.” ");
INSERT INTO hla_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Be Iesu e poiena, “Hengo tala iam, ba te atei silemiu u haharoei tara katun te tsihasein u ngal. ");
INSERT INTO hla_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","U ngal e here nei u ranga tere Sunahan. A maroro te pururukuia u ngal e here nei u katun te hengoer u raranga ba te ma atei sile rien. Be Satan te la nama ba te gul ba nena u ranga te gamon kaia i toriren. ");
INSERT INTO hla_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nu tsikitsiki te ka mena u lapo e here nei a palabir u katun te hengoer u raranga ba te haniga borobore ren ba te sasala meren. ");
INSERT INTO hla_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kaba u raranga e ma tsiruku koru uanei i iogana i taren, na nori u katun e ke ier a tsitabubun poata puku. Ba poata te omi mera rien u katun te hamana mena rien u ranga tere Sunahan ba barebana te kato hatiamer u hakhakats i taren, ba nori te hapolasa boroborer u ranga. ");
INSERT INTO hla_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nu tsikitsiki te ka mena a kolits a hihitoka e here nei u katun te hengoer u raranga, kaba nori e ka mer u hakhakats pan tara nitoatoa i puta ba te ngiler te gi lu koru meni a moni pan. Na man ka teka e here nei e piler u raranga tere Sunahan bu raranga e ma habutse nei u markato u niga turu katun teka. ");
INSERT INTO hla_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nu tsikitsiki u niga e here nei u katun te hengoer u raranga ba te atei sile ren. Bu raranga te kato hanige iena a markato turu katun teka: palabi e niga korur, na palabi e molo nigar na palabi e niga hatsitabubur.” ");
INSERT INTO hla_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Be Iesu e ranga mera nei a barebana u taina u haharoei me poiena, “A Nipepeito tere Sunahan tsi a markato te mar pepeito kap mera nei e Sunahan u katun e kato uana teka: A toa katun e na tsihasein a ngalin wit a niga tara kui i tanen. ");
INSERT INTO hla_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kaba tara toa bong, tara poata ti soho hakapaia u katun ba pakö i tanen e la nama me mi tsihasa nena a huanu pulung u omi te tara here nei u wit i gusuna kuin wit, me lana. ");
INSERT INTO hla_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ba poata te pusukuia u ngalin wit ba bakuren e katsin huana, bu katun e tara sabier u pulung u omi u para e ka has. ");
INSERT INTO hla_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bu katunun kui e la uar tara tamana kui me poier, ‘O tsunono, alö u tsihasein u ngalin wit u niga tara kui i tamulö, kaba ime te butuma u pulung u omi u para?’ ");
INSERT INTO hla_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ba nonei e poiena, ‘A pakö te kato a ka teka.’ Ba nori e rangatse ren, ‘Alö e ngilem alam e go na pate ban u pulung?’ ");
INSERT INTO hla_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ba nonei e poiena, ‘E moa. Taraha, alimiu e namos pate ba nemiu u wit te sohalana turu pulung te go na pate ba mena milimiu u pulung u omi. ");
INSERT INTO hla_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Hake iam u wit nu pulung e gi pan hoboto popona te ga tangohoia u wit. Ba lia te ranga meregu romana u katun te na gone riou romana a kannou a tangoho, ‘Pate mam iam u pulung ba te kitse men a man kits te gi lapo nia turu tula. Ba limiu te toa gone miu u wit ba te haka ramien tara luman haputu te kana a kannou i tar.’” ");
INSERT INTO hla_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Be Iesu e hatei rane ien u taina u haharoei me poiena, “A Nipepeito tere Sunahan e here hase nei u ngalin mastet te makosi koru ba nena u ngal hoboto. A katun e lue nen ba te na sapul nanen tara kui i tanen. Ba tara poata te pan nen, nonei e pan bala nena u mamana u man kan leba hoboto, ba te here nei u roei. Bu apena te la rima ba te mi katoe ria u suhana tara man kala i tanen. Na Nipepeito tere Sunahan e hatania hatetenei hasina ba te pan susuluna.” ");
INSERT INTO hla_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Be Iesu e ranga mera neien u taina u haharoei me poiena, “A Nipepeito tere Sunahan e here nei a yis te luena a tahol ba te sohale neien a toa taram palaua, bi murinen ba palaua hoboto te la seina.” ");
INSERT INTO hla_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","E Iesu e hatuts rai a barebana a man ka hoboto teka u haharoei. Nonei e ma tatei rangani ta ka i taren te go ma ranga menien u haharoei. ");
INSERT INTO hla_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nonei e kato mei a man ka teka te ga mana u u ranga te rangein a propet te kato u: “Alia e ranga negoa romana u haharoei te go ranga u lia i taren. Alia e ranga mera gien romana a man ka ti ma atei silei u katun i iomin koru ba te noa hasina i romana.” ");
INSERT INTO hla_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Be Iesu e la ba reto u katun me tasuna tara luma. Bu katunun tsitsilo i tanen e la uarima i tanen ba toa i taren e poiena, “Hatei ramei lam aha te poiena u haharoei turu pulung te kana tara kui.” ");
INSERT INTO hla_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Be Iesu e ranga palis ranen me poiena, “A katun te tsihasein u ngal u niga e here nei alia tu butun katunuma. ");
INSERT INTO hla_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na kui e here nei u han hoboto i puta. Nu ngal u niga e here nei u katunur tara Nipepeito tere Sunahan. Nu pulung u omi e here nei u katun tere Satan. ");
INSERT INTO hla_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na pakö te tsihasein u pulung tara kui nonei e Satan. Na poata te gone ria a kannou a tangoho e here nei a nikapakapana poata turu han i puta. Nu katun te gone ria a kannou a tangoho tara kui, nori u angelo. ");
INSERT INTO hla_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Na te gono menari u pulung ba te hats raria turu tula, e mar kato uana te mar kato uar romana tara poata te kapana romana a han. ");
INSERT INTO hla_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Alia tu butun katunuma e hala reguma romana u angelo i tar, ba nori te mi luer romana a mamana katun te roron kato homir nu katun hoboto has te amus rer u palai ba te kato homir, ba te lu ba rarien romana tara Nipepeito i tar. ");
INSERT INTO hla_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ba nori te lapo ba merari romana turu tula u kapan. Ba nori te tabe hohomi ria romana nonei turu tula teka ba te har tun hasir. ");
INSERT INTO hla_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bu katun u matskö te alesala koru hereri romana a pitala tara Nipepeito tere Tamaren. A katun te atein hengona e ga hengo haniga!” ");
INSERT INTO hla_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Be Iesu e poiena, “A Nipepeito tere Sunahan e here nei a moni pan te hamouse ria tara kui. Ba toa katun te sabie nen ba te hamous lele nen. Ba nonei te sasala koruna, ba te na hahol nena a mamana ka hoboto i tanen, ba te mi toan hol benei a peisanen nonei a kui.” ");
INSERT INTO hla_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Be Iesu e poe lelena, “Na Nipepeito tere Sunahan e here hase nei a katunun hahol te roron sakiena a man kabono a man niga. ");
INSERT INTO hla_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ba poata te sabie nen u toa u kabono u niga koru ba te hol sei koruna, ba nonei te na hahol hakapa koru nena a mamana ka hoboto te ka menen, ba te holena u kabono teka.” ");
INSERT INTO hla_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","E Iesu e ranga lel me poiena, “Na Nipepeito tere Sunahan e here hase nei a abe te lapo naria i tasi ba te luena a mamana mar iena. ");
INSERT INTO hla_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Poata te saputu nen, bu katun te hagalar te las mena rien i singmou ba te gum mier te arena menari a iena. U iena u niga te honge ria turu bona i taren, ba pala a omi te ba rer. ");
INSERT INTO hla_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Te mar kato has uaren romana tara poata te kapana romana a han. U angelo e la rima romana ba te arena rariou u katun u omi nu katun u niga, ba te lapo ba raria romana u katun u omi turu tula pan. Ba nori te tabe hohomir romana ba te har tun hasir.” ");
INSERT INTO hla_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","E Iesu e ranga u turu katun ti hengoen me poiena, “Alimiu e atei sile miu a man ranga te katoe gula lia?” Ba nori i poieto, “Aa.” ");
INSERT INTO hla_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ba nonei e poiena i taren, “U tson hihatuts hoboto turu Lo te katunun tsitsilo has uar i tar tara Nipepeito tere Sunahan e hereri a katun terena luma a niga te lue nama a man ka a man tsimus na man ka man toutounei tara makumun haputu i tanen. Nori e atei siler u ranga u mana ni manasa nu ranga u mana u tsimus has.” ");
INSERT INTO hla_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","E Iesu e ranga hakapein a man haharoei teka, me la ba nena nonei a han teka. ");
INSERT INTO hla_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ba nonei e la pouts uana tara han i tanen i Nasaret. Ba nonei e hihatutsna tara luman lotu turu Jiu. Ba barebana ti hengoe ien i asingoto koruto me poier, “Ime te luema a katun teka a mar niatei te kato uana teka? Gime te mar kato mena neien a man mirakul te hengo nera ra? ");
INSERT INTO hla_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nonei banei a pien tara kapenta e Josep, ne tsinanen e Maria. Ara e atei silera u munmun toulana i tanen ere Jemis mere Josep ne Saimon ne Judas. ");
INSERT INTO hla_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nu hahinanen e ka hasir. Gime te lue men a mar nitsunono teka?” ");
INSERT INTO hla_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ba nori i raharahe ten. Be Iesu e poieto i taren, “A propet tere Sunahan e ka mena a solo turu han hoboto. Kaba u katun pouts i tanen e ma poeri e Sunahan e hale ien a nikapan.” ");
INSERT INTO hla_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na nonei e ma katoei tu mirakul tu para i han i tanen, taraha u katun i hahamana. ");
INSERT INTO hla_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tara poata teka e Herot a King e hengoen e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Na nonei e poei turu katunun kui i tanen, “Nonei e Jon a Tsonun Baptais ti hatakei poutsi tara tou mate. Nonei te kato bene ien a man mirakul teka.” ");
INSERT INTO hla_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","E Herot e ranga u teka, taraha nonei noa has te rangein i manasa te gi pile kap meni e Jon, ba te kitser ba te hake ria tara karabus. Nonei e kato mei a ka teka u ngil tara tahol tere toulanen e Pilip. E Herot e hitöl hakapa mei a tahol teka a solonen e Herodias. ");
INSERT INTO hla_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ne Jon e ranga nitoa mei e Herot me poiena, “E ma niga koru nei te gotölo meni lö e Herodias!” ");
INSERT INTO hla_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Be Herot e ngilin atung hamate nanen, kaba e matoutir u katun u Jiu. Taraha, nori i poei e Jon a toa propet. ");
INSERT INTO hla_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Na turu lan ti hatoatongeia u lan ti poseia e Herot ba nori e katoer a kannou pan nu hirata, ba pien tahol a kukubei tere Herodias e sanina i matar u katun hoboto ti kaia tara kannou. Be Herot e haniga koruna, me ranga hamana menen turu ranga te mana uana i iasa me poiena, “Ta saha ta ka te ngile moa lö i tar, alia e hale goien lö!” ");
INSERT INTO hla_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Be Herodias e ranga mei a pien tahol i tanen te ga mar ranga uen teka tere Herot, “Alia e ngilegu e Jon a Tsonun Baptais e ga mate ba lö te hala hamatskö nemuma a bakunen tara toa pelet te haruto nena te ga mate hamana uen!” ");
INSERT INTO hla_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Be king e ka mena u tori u tiama, kaba nonei e kato hakapa tsiponi u ranga u mana i matar u katun ti nou gono meien, ba nonei e hatangana tala nena u ranga tara tahol. ");
INSERT INTO hla_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ba nonei e tahulena a toa tsonun taratarakap e go na soatsema a bakune Jon. Ba tsonun taratarakap e lato tara luman karabus, me na ngats kotsena a bakune Jon. ");
INSERT INTO hla_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bu baku e hake ria tara pelet me haleri a pien tahol, ba nonei e la mena neien tere tsinanen. ");
INSERT INTO hla_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bu katunun tsitsilo tere Jon e la rima, me luer a tuanreinen me kaho naren. Ba nori e na ranga mier e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Poata te hengo nia e Iesu e Jon e mate, ba nori meru katunun tsitsilo i tanen e la ba ner a han teka tara tsi tolala me la pepeisa uar tara toa han te moaia ta katun. Bu katun u para e hengo naren, me la ba ner u taun i taren me kukute sila nalila e Iesu i maroro. ");
INSERT INTO hla_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Be Iesu e na hasunguto me koul ba nena a tsi tolala. Ba poata te rute ien a katun a para koru, ba torinen e tatagi koru ranen, ba nonei e kato haniga pouts rena u katun i taren ti ka mei a nimate. ");
INSERT INTO hla_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ba tara lahi bu katunun tsitsilo i tanen e la uarima i tanen me poier, “E lahibong hamanasana, ne moa ta han tara makum teka. Hala mera lei u katun tara ma tsi han te sukusukur ba te na hol peise ier ta kannou i taren.” ");
INSERT INTO hla_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Be Iesu e poiena, “Nori e ma tatei lari. Alimiu go hala ramien ta ka te gi nouen.” ");
INSERT INTO hla_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ba nori e poier, “Alam e ka puku miem a tolima beret na solana iena.” ");
INSERT INTO hla_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Be Iesu e poiena, “La mena mumei i tar.” ");
INSERT INTO hla_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ba nonei e ranga merena u barebana e gi gumia turu garas. Ba nonei e luena a tolima beret na solona iena, me tara sei uana i Kolö, me hanigana tere Sunahan. Ba nonei e pose iena u beret me hala rane ien u katunun tsitsilo, ba nori e molamola rarien a barebana. ");
INSERT INTO hla_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ba nori hoboto e nour me masulur. Bu katun tsitsilo e luer a 12 a kalobaka a saputu tara ma tsi nouba i taren. ");
INSERT INTO hla_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","U hihase turu katun ti nou e sukusukuia tara 5000 tara pal tson peisa, ba te ma ase rari a tohaliou na galapien. ");
INSERT INTO hla_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Be Iesu e ranga mereto u katunun tsitsilo e gi osaia tara tsi tolala, ba te la ba mam mena rien i hapalana ramun a perperere, tara poata te hala kalakala rien u katun. ");
INSERT INTO hla_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bi murina te hala kalakala rien u katun, ba nonei e la sei pepeisa uana turu pokus te na singo ien. Ba poata te lahiia a lahi, be Iesu e ka pepeisana turu pokus. ");
INSERT INTO hla_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tara poata teka a tsi tolala e la halehana ban a monsingmou, ba lomolomo e la uamato i matana tsi tolala bu keikei e kato hagigere iena a tolala. ");
INSERT INTO hla_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ba tara sukusukuna lunlan, be Iesu e la uamato i taren me tatala silana i ieluna a ramun. ");
INSERT INTO hla_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ba poata ti tareia u katunun tsitsilo e Iesu te tatala uen turu ramun, ba nori e tololo mer a nimatout. Nori i ku homi me poier, “A liliahanei!” ");
INSERT INTO hla_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Be Iesu e topei ranga uana i taren me poiena, “Alia ba. Ma matoutumi!” ");
INSERT INTO hla_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Be Pita e ranga uato, “O Tsunono, te go Iesu hamana koru u lö, ranga memo lia ba lia te la ua gou i tamulö i ieluna a ramun.” ");
INSERT INTO hla_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Be Iesu e poiena, “Lama!” Be Pita e kouluna tara tsi tolala me tanian tatala uana tere Iesu turu ramun. ");
INSERT INTO hla_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kaba nonei e hasagoho tsiponi a lomolomo me matoutuna, me tanian ruku uana i iogana. Ba nonei e kuto me poiena, “O Tsunono, taguhe molia!” ");
INSERT INTO hla_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Be Iesu e topei hasoa nena a limanen me pile nanen me poiena, “Alö e ka mem u hamana u tetenei! Aha tsiponi te hula hakats memuö?” ");
INSERT INTO hla_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ba nori a elasolana e na osa ria tara tolala, ba lomolomo e seloho poutsuna. ");
INSERT INTO hla_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bu katunun tsitsilo ti kaia tara tolala e hatsunoner e Iesu me poier, “U mana koru, alö a Pien Tson tere Sunahan!” ");
INSERT INTO hla_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","35","Ba nori e tupekoer a ramun me na sung ria tara han i Genesaret, bu katunur i Genesaret e mareier e Iesu. Ba nori e hangö rer u katun hoboto ti ka mei u nimate turu han hoboto i sukusuku me piou rarien tere Iesu. ");
INSERT INTO hla_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ba nori i ranga hatagala hoboto sileto te gi hapile tun merien u katun ti ka mei u nimate i runguna u hasobu i tanen. Bu katun hoboto ti hasebeleia turu hasobu i tanen i niga poutsuto. ");
INSERT INTO hla_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Bu palair u Parisi nu tson hihatuts turu Lo i la mato i Jerusalem me la uarima tere Iesu me rangatse ren, “Taraha tsiponi bu katunun tsitsilo i tamulö te hipus ner u hihatuts ti halan u katun pan i tarara i manasa? Nori e ma galus hamatsköeri a limaren te mar ranga uana u lo te katsin nou rien!” ");
INSERT INTO hla_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Be Iesu e ranga palisito, “Gaha tsiponi te hipus memi limiu u hihatuts tere Sunahan te go kukute menami u hihatuts turu katun i manasa? ");
INSERT INTO hla_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","E Sunahan e poei, ‘Hapane iam e tamamilimiu ne tsinamilimiu. A katun te ranga homi nena e tamanen tsi e tsinanen e gi atung hamate korui.’ ");
INSERT INTO hla_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kaba u hihatuts i tamilimiu e poiena, ‘A katun te ka mena a ka te tatei taguhena e tamanen tsi e tsinanen, nonei e tatei poiena, A ka teka a ka tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Bu ranga te poiena, Hapane iam e tamamilimiu, e ma la uanei tara katun teka.’ Te mar ranga uami limiu. E kato uana teka, ba limiu te roron hala putemiu u ranga tere Sunahan te kukute mena milimiu u hihatuts turu tubumilimiu. ");
INSERT INTO hla_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","8","Alimiu u gamogamo! A propet e Aisaia ni manasa e ranga hamatskö koru rio limiu te poien turu tubumilimiu, ‘E Sunahan e poiena, U katun teka e hatsunono meri lia u ranga tun i taren, kaba a toriren e ka halehana ba koru nano lia. ");
INSERT INTO hla_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nori e mastei hatsunone rio lia, taraha nori e roron hihatuts ner a man markato turu katun tun, ba te poier a man markato tere Sunahan!’” ");
INSERT INTO hla_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Be Iesu e ngö mera nei u katun i tanen me poiena i taren, “Hengo iam, ba limiu te ateimiu! ");
INSERT INTO hla_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","A ka te la uana i runguna katun te ma kato hakorkoriane nei a katun. A ka talasi te lakasana turu rung te kato hakorkoriane nen.” ");
INSERT INTO hla_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bu katunun tsitsilo e la uarima i tanen me poier, “U Parisi e omie ier u ranga te katoe mula lö ba te raharahar.” ");
INSERT INTO hla_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Be Iesu e poiena, “Noahasina. U katun teka e hereri u pulung u omi te ka ria tara kui tere Tamar. Nonei e pate baba ranoen romana. ");
INSERT INTO hla_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nori e hereri a katun a matakiau te peigena a tai. Ba tara poata te peigena romana a toa katun a matakiau a tai, ba nori te tsia hoboto ria romana tara holö.” ");
INSERT INTO hla_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Be Pita e poiena i tanen, “Alö go hatei ramei lam a ka te poiena u haharoei te katoe mula lö.” ");
INSERT INTO hla_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Be Iesu e poiena i taren, “Alimiu u moa noa iam tu niatei. ");
INSERT INTO hla_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Alimiu go atei sile iam, a mamana ka te la uana i runguna katun e la uana i mukolonen ba i murimuri e lakasa ba nena u tuanrei. ");
INSERT INTO hla_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kaba man ka te lakasa nama turu rung e la nama turu tori te here nei u namnamei. Nonei a man ka te kato hakorkorianena a katun. ");
INSERT INTO hla_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Turu tori te la nama a man ka man omi teka: u hakats u omi na hipuli na tsikolo na haloku na kop nu ranga u gamo, nu tuts. ");
INSERT INTO hla_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","A man ka teka te kato hakorkorianena a katun. Kaba te gi nou mam meni a kannou i mam te galus hamatskö menari u ualima, a ka teka e ma kato hakorkoriane nei a katun.” ");
INSERT INTO hla_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Be Iesu e la ba neto a han teka me la uana tara han turu katun te ma Jiuri te sukusukuia tara man taun i Taia ni Saidon. ");
INSERT INTO hla_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ba toa taholuna tara provins teka i Kenan te kaia tara han teka e la uato i tanen ba te ranga hatatagina me poiena, “O Tsunono, a Hatutubunei tere Devit! Alö go tatagi namo lia! A pien tahol i tar e sinasaha koruna tara mate a omi!” ");
INSERT INTO hla_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Be Iesu e ma ranga nanei ta tsi ranga i tanen. Bu katunun tsitsilo e la uarima tere Iesu me ranga hatagala meren, “Hala ban! Taraha, nonei e kukute rano ra ba te ngalana.” ");
INSERT INTO hla_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Be Iesu e ranga palisina, “E Sunahan e hala sil tune moi lia turu Jiu ti tutu ba menien. Na lö e ma Jiumi.” ");
INSERT INTO hla_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kaba a tahol e lama me mi hatukunna i matanen me poiena, “O Tsunono, taguhe molia!” ");
INSERT INTO hla_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Be Iesu e ranga palisito, me haharoei nena u Jiu nu katun te halhal ria turu Jiu, me poiena, “E ma matskö nei te gi lu meni a kannou tara galapien ba te ba neria turu muki.” ");
INSERT INTO hla_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ba tahol e hatanganato, “U mana koru, o Tsunono. Kaba u muki e roron nou noa haser a ma tsi kannou te pururukuna turu tebol.” ");
INSERT INTO hla_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Be Iesu e atei sileto nonei a tahol e hakats u teka: u Jiu i ngöri u katun halhal u muki, kaba u katun halhal i tatei lu noa hasi a palabina man ka man niga tere Sunahan. Be Iesu e ranga paliseto a tahol, “Alö e hamana hatagala korum. A ka te ngile mulö e butu hamanasana.” Ba pien tahol i tanen e niga pouts hamanasato. ");
INSERT INTO hla_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Be Iesu e laba neto a han teka me sila uana i rehina Ramun a Perperere i Galili. Ba nonei e seieto a tsi pokus me gumuna. ");
INSERT INTO hla_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bu katun u para i la uamato i tanen, me la merima u katun u tasiko, nu korus, nu matakiau, nu katun u biru, nu palair u katun has u para ti ka mei u nimate, me haka rarien i mouna e Iesu. Ba nonei e kato haniga pouts ranen. ");
INSERT INTO hla_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bu katun i asingoto koruto ti hengo meni ti ranga u u biru, na ti tara meni u katun u korus nu tasiko i niga pouts, nu matakiau i ruto. Ba nori i solo seieto e Sunahan te pania i Israel. ");
INSERT INTO hla_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Be Iesu e ngö gugono mera nei u katunun tsitsilo i tanen me poiena, “Alia e tatagi koru regu u katun teka, taraha nori i ka gono meio lia turu topisa u lan ba te moana ta ka te gi nouen. Alia e raman hala kalakala ragen ba te ma nou noari, taraha nori e namos tutupu ria i maroro.” ");
INSERT INTO hla_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bu katunun tsitsilo i rangatse ten, “Ime te sabie roa ra ta kannou te ga antunaia turu katun u para tara makum pinopino teka te gi hanou rien?” ");
INSERT INTO hla_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Be Iesu e rangatato, “A lahisa beret te ka memi limiu?” Ba nori e poier, “A tohit a beret na ma tsi iena has.” ");
INSERT INTO hla_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Be Iesu e ranga mera tei u katun e gi gumia turu tsikitsiki. ");
INSERT INTO hla_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ba nonei e lueto a tohit a beret na ma tsi iena, me haniga uana tere Sunahan, me pose ranen me hala rane ien u katunun tsitsilo, bu katunun tsitsilo i molamola rate ien u katun. ");
INSERT INTO hla_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ba nori hoboto e nour me masulur. Bu katunun tsitsilo e luer a tohit a kalobaka a saputu tara ma tsi nouba i taren. ");
INSERT INTO hla_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","U hihase turu katun ti nou e noaia tara 4,000 tara pal tson peisa, ba te ma ase rari a tohaliou na galapien. ");
INSERT INTO hla_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Be Iesu e toan hala kalakala reto u katun, ba nonei e osana tara tsi tolala, ba nonei e la uato tara pal han i Magadan. ");
INSERT INTO hla_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","U palair u Parisi nu Sadiusi i la uama tere Iesu. Nori i ngilin tohala nen, ba nori e rangatse rien te ga kato beme rien ta mirakul te ga harutein a nitagala tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Be Iesu e ranga palisito, “Poata te tsirukuna a pitala ba limiu te poemiu, ‘Ara e ka merou a poata a niga, taraha u kolö e röröna.’ ");
INSERT INTO hla_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ba tara bongbong koru, ba limiu te poemiu, ‘A langits e polo nou i romana, taraha u kolö e röröna ba te tara here nei a langits.’ Alimiu e atei silemiu te mouna uana a mar nitaratara i kolö. Kaba limiu e ma atei silemi te mouna uana a man hiharuts tara kapakapana poata. ");
INSERT INTO hla_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","A hei barebana a omi ti hapolasa hakapa ban e Sunahan te kato siler te gi tara meni a mirakul. Kaba alia e ma tatei haruto negi tu toa tu mirakul. A hatoatongo lasi tere Jona a propet i manasa te haruto ragi lia limiu.” Be Iesu e la ba ranen me lana. ");
INSERT INTO hla_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ba tara poata ti arohoeia u katunun tsitsilo a Ramun, ba nori e hakats sabe ner nori i solopali te gi lu meni ta beret. ");
INSERT INTO hla_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Be Iesu e ranga mera nen te gi ma hengo ien u hihatuts u omi turu katun me poiena, “Alimiu go tara kap haniga iam ba te hanei silemiu u yis turu Parisi nu Sadiusi.” ");
INSERT INTO hla_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ba nori e hatanian hiararanga poutsur me poier, “Nonei e mar ranga uana teka, taraha ara e ma lue rimei ta beret.” ");
INSERT INTO hla_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Be Iesu e atei sileto aha ti ranga nen, ba nonei e poiena, “Taraha tsiponi ba limiu te hiararanga pouts silemiu te ma ka mena milimiu ta beret? Alimiu e hamana hatetenei korumiu! ");
INSERT INTO hla_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Alimiu e ma atei noa hasmi? Alimiu go hakats pouts neiam tu pose meni lia a tolima beret tara 5000 tara katun nu kalobaka tu ongo hasapute iam limiu. ");
INSERT INTO hla_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na limiu go hakats pouts has niam a tohit a beret tara 4000 tara katun nu kalobaka tu ongo hasapute iam limiu. ");
INSERT INTO hla_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Aha tsiponi te poe memi limiu alia e ranga sile gula ta beret? Alia e poie gula, ‘Hanei sile iam u yis turu Parisi nu Sadiusi!” ");
INSERT INTO hla_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bu katunun tsitsilo i toan atei sileto e Iesu e ma ranga silei a yis te katoeri a beret, kaba e ranga sil te gi hanei sil menien u hihatuts u omi turu Parisi nu Sadiusi. ");
INSERT INTO hla_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","E Iesu e la u tara pal han i Sesaria Pilipai, ba te rangata rena u katunun tsitsilo i tanen, “U katun e ngöeri alia tu butun katunuma esi?” ");
INSERT INTO hla_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ba nori e ranga palise ren, “A palai e poier alö e Jon a Tsonun Baptais, na palai e poier alö e Ilaitsa na palai e poier alö e Jeremaia tsi alö a tai turu propet ti mate hakapa me takei poutsum tara tou mate i tamulö.” ");
INSERT INTO hla_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Be Iesu e poiena, “Gime te kato uami limiu? Alimiu e poemiu alia esi?” ");
INSERT INTO hla_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Be Saimon Pita e ranga palisito, “Alö a Mesaia te hopu kapin e Sunahan. Alö a Pien Tson tere Sunahan te toatoana.” ");
INSERT INTO hla_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Be Iesu e poiena i tanen, “O Saimon a pien tere Jona, e Sunahan e kalale nolö! A niatei teka e ma hatei namei ta katun tun i tamulö. E moa. E Tamar i Kolö te hale namen i tamulö. ");
INSERT INTO hla_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na lia e hateie golö, a solomulö e Pita, a hatu. Na i ieluna u lapo teka alia e hatakeiegu romana a luman lotu i tar te haharoei nenou romana a pal barebana te hamana uarou i tar. Na nitagala tara tou mate noa has e ma tagala saluhe noi romana i tanen. ");
INSERT INTO hla_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Alia e hale goi romana lö a ki tara Nipepeito tere Sunahan. A saha ka te hapiu namia romana lö i puta, e hapiu has nena romana e Sunahan i Kolö. Na saha ka te hanige mia romana lö i puta, e haniga hasena romana e Sunahan i Kolö.” ");
INSERT INTO hla_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Be Iesu e ranga hatagala merena u katunun tsitsilo i tanen e gi ma tatei hatei ta katun te Mesaia uanen. ");
INSERT INTO hla_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tara poata teka e Iesu e hatanian hateiia turu katunun tsitsilo i tanen te ga mate uen me poiena, “Alia e la uagou romana i Jerusalem ba te na kamits hapan gia turu tsunono, nu pris pan, na turu tson hihatuts turu Lo. Ba nori te na atung hamate rio lia, ba lia te takei potsugu romana turu hatopisana u lan.” ");
INSERT INTO hla_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Be Pita e lu mena neien i harehirehi me tanian ranga hapiu menen me poiena, “O Tsunono, e Sunahan e ga hapiun a ka teka! E ma tatei butu koru neia i tamulö!” ");
INSERT INTO hla_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Be Iesu e habiritsina me poiena tere Pita, “Hatalis ba neio lia, o Satan! Alö e hatu kap namo lia. Alö e ma ka memi u hakats tere Sunahan. Alö e ka mem u hakats tara katun!” ");
INSERT INTO hla_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Be Iesu e poieto turu katunun tsitsilo i tanen, “Te ngilin la gono mena molia ta katun, e ga solopali a peisanen, ba te haniga te ga sagoho menien u kamitsina te kukute mena neien lia te mar kato uana a katun te soatsena a korusena tara tou mate i tanen, ba te la gono mena molia. ");
INSERT INTO hla_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Taraha, a katun te ka mena u hakats pan te go haka haniga meni a nitoatoa i tanen ba te peits nanen i tar, nonei e na hataia tun noa hase nen romana.Kaba a katun te hataia sile nei a nitoatoa i tanen te ngil koru mena neien lia, nonei e sabie nen romana. ");
INSERT INTO hla_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Te ga lueia ta katun a man ka hoboto ni puta, ba te toan taia ba nena a nitoatoa te ka nitoana, ga mamana ka teka e mar taguhu halona mena noien ime? E moa tala. E moa koru ta ka te ga antunan hala nen ba te lu poutse nei a nitoatoa i tanen. ");
INSERT INTO hla_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Taraha, alia tu butun katunuma e la gono meguma romana u angelo i tar turu ualesala pan tere Tamar, ba lia te toa palis regoi romana u katun ti kato homi a ka a omi nu katun ti kato haniga a ka a niga. ");
INSERT INTO hla_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Alia e hatei hamana rago limiu, a palair u katun teka e ma materi romana e popona te gi tara menien alia tu butun katunuma tara poata te na butu here gumei lia a king.” ");
INSERT INTO hla_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","U tönomo u lan i murimuri e Iesu e lui e Pita, nu muntoulana e Jemis ne Jon, me peigi pepeisa mera neien i ieluna u toa u pokus pan. ");
INSERT INTO hla_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ba tara poata ti tara ien, ba nori e tarer te palis u a tuanreina e Iesu: a polenen e alesala koru herei a pitala, nu hasobu i tanen e hiaka koru herei u ualesala. ");
INSERT INTO hla_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Be Moses mere Ilaitsa u propetir i manasa ti mate i bututo ba nori a elapisa katunun tsitsilo e tara raren ba nori te ranga gono mier e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Be Pita e rangana me poiena tere Iesu, “O Tsunono, e nigana te ka ria ra teka. Te go ngil u lö, ba lia te kuiegu a topisa taluhu teka, a toa i tamulö, na toa tere Moses, na toa tere Ilaitsa.” ");
INSERT INTO hla_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tara poata te ranga noa ien, bu koasi te alesala koru e mi hoho ranen me la uanama i ieluren bu toa u ranga e poie nama turu koasi, “Nonei a Pien Tson a tsomi koru i tar teka. Alia e haniga korue gen. Hengo mia i tanen!” ");
INSERT INTO hla_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Poata ti hengoeia u katunun tsitsilo u ranga teka ba nori e matout korur, me hatukunur me turu putar. ");
INSERT INTO hla_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Be Iesu e la uanama i taren me hasebelena i taren me poiena, “Takei iam. Ma matoutmi!” ");
INSERT INTO hla_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ba nori e tara seir me tarer e Iesu pepeisa. ");
INSERT INTO hla_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Poata ti koul men turu pokus be Iesu e ranga mera nen, “Alimiu e ma tatei ranga memi ta toa ta katun tara ka teka te tara mula limiu antunana te takei pouts goa romana alia tu butun katunuma tara tou mate.” ");
INSERT INTO hla_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bu katunun tsitsilo e rangater e Iesu, “Tara naha te poe menari u tson hihatuts turu Lo e Ilaitsa a propet e ga mam nema romana e Mesaia?” ");
INSERT INTO hla_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Be Iesu e ranga pouts mera nen, “E Ilaitsa e la mam pouts hamana nama ba nonei te kato hamatsköena romana a mamana ka. ");
INSERT INTO hla_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Na lia e hatei ragi limiu a ka teka: e Ilaitsa e la hakapama, kaba u katun i ma marei ien na nori i mar kato homi menien ti mar ngil uaien. Na tara toa has a markato ba nori te kato homi hase riou romana alia tu butun katunuma.” ");
INSERT INTO hla_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Bu katunun tsitsilo i toan atei sileto nonei e ranga merien e Jon a Tsonun Baptais, nonei a katun te ngöi u Buk u Goagono e Ilaitsa ba te poiena nonei e ga lama. ");
INSERT INTO hla_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Poata ti kopis uen turu barebana, ba toa katun e la uamato tere Iesu, me hatukunna i matanen me poiena, “O Tsunono, alö go tatagi nema a pien tson i tar! Nonei e roron kotskotsibonguna na peisanen e omi koruna, na nonei e roron rus uana turu tula na turu ramun. ");
INSERT INTO hla_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Alia u la mena meien turu katunun tsitsilo i tamulö, ba nori e ma antunan kato hanige rien.” ");
INSERT INTO hla_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Be Iesu e ranga poutsuto me poiena, “Alimiu u katun u hahamana koru na limiu e ma matskömi! Alia e soso koru megu a nihahamana i tamilimiu. La mena mumei a pien i tar!” ");
INSERT INTO hla_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Be Iesu e ranga hatagala mena a mate a omi ba nonei e toan lakasana, ba nonei a pien tson teka e niga poutsuna i teka puku. ");
INSERT INTO hla_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bu katunun tsitsilo e la uarima tere Iesu me rangata hamouse ren, “Taraha ba lam te ma antunan tsuga halakase mulei a mate?” ");
INSERT INTO hla_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Be Iesu e ranga palisina me poiena, “Taraha, a tsi nihamana i tamilimiu e ma antuna nei. Hakats niam a ka teka! A ngalin mastet e makosi koruna kaba e habutena a kan leba te pan sokuna. Ne kato has uana i iesana, te tetenei hasina a nihamana i tamilimiu, alimiu e antunan kato noa hasemiu a man ka man kapan. Hena, alimiu e tatei poemiu turu pokus teka, ‘Takeiia teka ba te la uam ili!’ ba nonei te lana. Ba limiu te tatei katoe mou a mamana ka!* ");
INSERT INTO hla_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Alimiu go singo hatagala uam tere Sunahan te agono sil mena mien limiu a kannou. E moa ta taina ta maroro te ga tatei tsuga ban a mar mate a omi teka.*” ");
INSERT INTO hla_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Ba poata ti la gugono uama u katunun tsitsilo i Galili, be Iesu e poieto i taren, “Alia tu butun katunuma e susukun hala menari i limar u katun te na atung hamate rio lia. Kaba turu hatopisana u lan ba lia te takei pouts gou romana.” Bu katunun tsitsilo e tatagi korur. ");
INSERT INTO hla_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ba poata te la u e Iesu nu katunun tsitsilo i Kapeneam, bu katunun lulu monina tara Luman Lotu Pan i la mato me mi rangatser e Pita, “A tson hihatuts i tamilimiu e hol hasena a takis tara Luman Lotu Pan, tsime?” ");
INSERT INTO hla_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Be Pita e poiena, “Aa.” Na tara poata te la u e Pita i luma me pats rangana, kaba e Iesu e ranga mam me poiena, “O Saimon, u saha u hakhakats i tamulö? A toukui teresi te holena a takis turu king turu han i puta? U katun hamatskö tere king tsi u katun halhal?” ");
INSERT INTO hla_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Be Pita e ranga palisina, “U katun halhal.” Be Iesu e poiena, “Aa, bu katun tere king te ma tatei holri. Ne kato has uana i iesana i tarara. ");
INSERT INTO hla_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kaba ra e namos kato haraharaha rera u katun teka. Bara, la u tara ramun a perperere ba te lapo nem a ohono. Na i runguna a iena tutun te lase molö, alö e sabie mou a toa moni e antunana tara takis i tarara a elasolana. Luema ba te hole mien a takis i tarara.” ");
INSERT INTO hla_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tara poata teka bu katunun tsitsilo i la uamato tere Iesu me rangatar, “Esi te pan koruna tara Nipepeito tere Sunahan?” ");
INSERT INTO hla_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Be Iesu e ngöena a toa pien me hatuole nen i mam i taren me poiena, “Hakats kap niam a ka teka! Te ma habirits moia limiu ba te heremi a galapien, e moa koru te go tatei tasu noa has uamou limiu tara Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","A katun te hala pute iena a peisanen ba te here nei a pien teka, a katun teka te pan koruna tara palai tara Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na katun te hatamiena a toa mar pien teka te pien uanen i tar, e here nei e hatami hase nolia.” ");
INSERT INTO hla_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","E Iesu e ranga noana me poiena, “Kaba sanena ta toa ta katun e ga katsin amusia a toa pien i gusur a galapien teka te hamana uar i tar ba pien te hapolasa ba nenou a nihamana i tanen, e niga balana te gi kits mam meni u katun a toa hatu pan i totongolona katun teka ba te na harukue rien i gusuna loul. ");
INSERT INTO hla_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","A nomi pan e butu noa romana turu han i puta, taraha u hiamus e gono ba te kato homiena u nihamana turu katun. E manana, a markato a omi teka e roron katona. Kaba a nomi pan e butu noa romana tara katun te habute nen! ");
INSERT INTO hla_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Te ga kato homieia a limamulö tsi a moumulö alö, bara, ngats kots ba te ba namen! Taraha, e nigana te go ka meni lö u toa puku u ualima, tsi u toa puku u mou, ba lö te toan luem a nitoatoa te ka nitoana. Kaba e omina te go ka meni lö u huol u ualima tsi u huol u mou ba nori te ba neria lö turu tula te ma tatei oso nei. ");
INSERT INTO hla_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na te ga kato homieia a matamulö alö, bara, has talei ba lö te ba namen. E nigana te go ka meni lö u toa puku u mata ba lö te toan luem a nitoatoa te ka nitoana. Kaba e omina te go ka meni lö u huol u mata ba nori te ba neria lö turu tula ni hel.” ");
INSERT INTO hla_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Be Iesu e poiena, “Alimiu e go hanei haniga iam ba te ma sigalemi ta toa tara galapien teka. E moa. Alia e hatei rago limiu, u angelo te tara kap raren e roron ka ria tere Tamar i Kolö.* ");
INSERT INTO hla_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Taraha, alia u butun katun silema te go mi lu pouts meri u katun hoboto ti taia.* ");
INSERT INTO hla_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Aha te hakats nami limiu tara katun te ka mena 100 tara sipsip ba toa i taren te taiana? Nonei e neha nou? Nonei e gamon la ba rena romana u 99 ba te nou ria turu pokus ba te na sakiena a sipsip te taia. ");
INSERT INTO hla_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Poata te sabie nen a sipsip te taia, alia e ranga mera go limiu, nonei e sasala koru mena romana a toa sipsip te taia ba te ma hakats hapara nanei u 99 ti ma taiai. ");
INSERT INTO hla_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na e kato has uana i iesana, e Tamamilimiu i Kolö e ma ngile nei te ga taia u ta toa tara galapien teka.” ");
INSERT INTO hla_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","E Iesu e ranga lel me poiena, “Te kato homiena a hahatoulana i tamulö alö, ba lö te la uam i tanen ba limiu a elasolana te ka pepeisamiu ba lö te hatare mien a markato a omi i tanen. Te ga hengo menien u ranga i tamulö, ba limiu te hikapiena pouts miu. ");
INSERT INTO hla_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kaba te ma hengoe neien romana lö, ba lö te luem ta toa tsi ta elasolana ta katun ba te la gono merio lö. Kato uana teka ba elasolana tsi a elapisa katun te tatei hitaguhu ria turu ranga. ");
INSERT INTO hla_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kaba te ma ngilin hengoe neien romana u ranga i taren, ba lö te hatei nem a mamana ka tara barebana te hagum ria turu lotu. Na te ma hengo noa hase neien romana u ranga i taren, ba limiu te kato here namien a katun a omi te kana i ielesala turu lotu.” ");
INSERT INTO hla_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Be Iesu e poiena, “Na lia e ranga hamana mera golimiu, a mamana ka te hapiu namia limiu i puta, e Sunahan e hapiu has nanen romana i Kolö. Na mamana ka te hanige mia limiu i puta, e Sunahan e haniga hase nen romana i Kolö. ");
INSERT INTO hla_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Alia e ranga lel mera go limiu, te singo sile ria ta elasolana i tamilimiu i puta ta toa ta ka ba te hatangana hoboto naren, be Tamar i Kolö e kato bera noien romana a ka te singo sile ren. ");
INSERT INTO hla_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Taraha, te gi hakats sileia a elasolana tsi a elapisa katun a solor ba te gono hobotor, alia e ka gia romana i gusuren.” ");
INSERT INTO hla_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Be Pita e la uato i rehina e Iesu me rangatana, “O Tsunono, a tana katun e ga kato homiia i tar tara lahisa poata ba lia te solopale gou a markato a omi i tanen ba te tara poutse gen? Antunana tara tohit a poata?” ");
INSERT INTO hla_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Be Iesu e poieto i tanen, “Alia e ma poiegi a tohit a poata puku. E moa. Alia e poiegu a tohit a poata lel na tana tohit a poata ba te kato talasina. ");
INSERT INTO hla_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","E kato uana teka ba Nipepeito tere Sunahan e kato uana tara toa king te katsin hakapena a haroho i tanen te kana turu katunun pepeitokap i tanen. ");
INSERT INTO hla_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ba nonei e tanian kato hamatsköe iena a haroho ba nori e na piou narima a toa katunun pepeitokap te ka mena a haroho te antunana tara 10 milion kina. ");
INSERT INTO hla_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kaba a katun teka e ma antunan hamatana kopis poutse nei a haroho teka. Ba king e poiena turu katunun pepeitokap i tanen, ‘Alimiu go hahol niam a tson teka na tahol i tanen na galapien i tanen na mamana ka hoboto i tanen has. Ba moni te hole roien e hamatana kopise noien a haroho i tar.’ ");
INSERT INTO hla_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ba katunun pepeitokap teka e tuhatukun nena ba te ranga hatatagi-torina me poiena, ‘Alö go hahaloso patu bum ba lia te hamatana poutse gou romana a haroho hoboto i tamulö.’ ");
INSERT INTO hla_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ba king e tatagi nena a katunun pepeitokap i tanen teka ba te hakapa bene ien a haroho i tanen me hapuresie nen. ");
INSERT INTO hla_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ba nonei a katunun pepeitokap teka e la talana me hitupali mena a hahelasolana i tanen. Na tana katun teka e ka mei a haroho i tanen te antunaia turu maloto u pits puku. Ba nonei e pile nena a totongolonen me poiena, ‘Alö go hamatana poutsema a haroho i tar!’ ");
INSERT INTO hla_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ba hahelasolana i tanen e tuhopu nena i matanen ba te ranga hatatagi-torina me poiena, ‘Alö go hahaloso patu bum ba lia te hamatana poutse gou a haroho i tamulö.’ ");
INSERT INTO hla_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kaba nonei e ramana me na hakeie nen tara karabus antunana tara poata te hamatana poutse nen romana a haroho. ");
INSERT INTO hla_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","A palair u katunun pepeitokap i tare ien ba te raharaha korur me na hateieri a king a mamana ka hoboto te butu. ");
INSERT INTO hla_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ba king e ngöe iena a katunun pepeitokap teka me poiena i tanen, ‘Alö a katun a omi koru! Alia u hakapa bei lö a haroho pan tu katoia lö i tar, taraha alö u ranga hatatagi-toriia i tar. ");
INSERT INTO hla_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Alö go mala tatagi hasin a hahelasolana i tamulö tu mar tatagi has meni lia alö!’ ");
INSERT INTO hla_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ba king e raharaha koru talana me hala mena neien tara karabus te go kamits nitoa uen antunana tara poata te hamatana poutse noen a haroho hoboto.” ");
INSERT INTO hla_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Be Iesu e poe hasena, “Ne Tamar i Kolö e kato has uana romana i iesana i tamilimiu hoboto te ma solopala hamane moi limiu a markato a omi tara tana katun ba te tara poutse men.” ");
INSERT INTO hla_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Poata te ranga hakapa nia e Iesu a man ka teka, ba nonei e la ba nena i Galili me la pouts uana tara han i Judia i hapalana Ramun i Jodan. ");
INSERT INTO hla_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bu katun u para i kukutie ten, ba nonei e kato haniga pouts ranen tara makum teka. ");
INSERT INTO hla_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ba palair u Parisi i la uamato i tanen me torohane ren me poier, “U Lo i tarara e hanigana te ga tapurese ba meni a tson a tahol i tanen tara mamana markato?” ");
INSERT INTO hla_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Be Iesu e ranga palisina, “Alimiu go mala rit hanige iam u ranga teka turu Buk u Goagono te poiena, ‘I mam koru te habutsi e Sunahan a katun, nonei e kui a tson na tahol me poiena, Nonei teka te tapurese silena romana a tson tere tamanen ne tsinanen ba te na ka gono miena a tahol i tanen bu muntahol teka te here roi romana u toa u tuanrei.’ ");
INSERT INTO hla_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ba nori te ma here leleri romana a elasolana, kaba nori e here taleri a toa katun. Na katun e ma tatei puresie nei romana a ka teka te haka gono hakaper e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bu Parisi i rangatse ten, “Ga tara neha tsiponi be Moses te hala nena a lo me poiena a tson e tatei koloto tunena a pepana te gi peko meni a hitöl ba te hale neien a tahol i tanen ba te tsuge iena a tahol?” ");
INSERT INTO hla_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Be Iesu e ranga palisina, “Moses e halari u tubumilimiu u raranga teka, taraha a toriren e ma ngil hamanai, kaba te habutu tutuneia e Sunahan a tson na tahol, e ma hanigai te gi peko meni a hitöl. ");
INSERT INTO hla_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Alia e ranga mera go limiu, a tson te tapurese ba nena a tahol i tanen, kaba tahol i tanen e ma halokui ba tson te hitöl mena a taina tahol, a tson teka e kato uana tara tson te tsikolona.” ");
INSERT INTO hla_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bu katunun tsitsilo e poier i tanen, “Te ga markato uen teka tara tson na tahol, e noahasina te gi hitöl u.” ");
INSERT INTO hla_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Be Iesu e ranga palisina, “U ranga teka e ma tatei la uanei turu katun u para, kaba e Sunahan e hala nena a nitagala tara palair u katun te hapiu ner te gi ma hitöl uaien. ");
INSERT INTO hla_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Palair u tson e ma antunan hitöl meri ti mar posa noa merien. Na palai e ma hitöl meri ti pö ba meri u katun a kolren. Na palai e ma tatei hitölri, taraha nori e ngilin kato hanige ier a toukui tara Nipepeito tere Sunahan. A tson te antunan kukutiena u ranga teka, e nigana te go kukute uen.” ");
INSERT INTO hla_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","U katun i la mena mei a galapien tere Iesu te ga hopu menien a limanen i taren ba te singona tere Sunahan. Bu katunun tsitsilo i ranga hapiu raten. ");
INSERT INTO hla_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Be Iesu e poieto, “Haka riam a galapien e gi la uama i tar, ma hapiu rami, taraha a Nipepeito tere Sunahan e ka uana tara mar katun te kato uana teka.” ");
INSERT INTO hla_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ba nonei e hopuena a limanen i taren me lana. ");
INSERT INTO hla_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","A toa tson e la uama tere Iesu me poiena, “Tson Hihatuts, a saha ka a niga te go kati lia ba te luegu a nitoatoa te ka nitoana?” ");
INSERT INTO hla_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Be Iesu e ranga palisito, “Aha te rangata memi lö alia ba te ranga nem aha te nigana? E Sunahan a toa puku te nigana. Te ngilin lue mulö a nitoatoa te ka nitoana, ba lö te kukutiem a man masaka tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ba nonei a katun e rangatato, “U sahu masaka?” Be Iesu e ranga palisito, “A man masaka te kato uana teka: ‘Alö go ma hipulii. Alö go ma kopui. Alö go ma gamogamoi. Alö go ma tsikoloi. ");
INSERT INTO hla_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Alö go hapan e tamamulö ne tsinamulö. Na lö go ngil a tai te mar ngil mena milö a peisam.’” ");
INSERT INTO hla_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ba tson a hitots e ranga poutsuto me poiena, “Alia e kukutiegu a man masaka hoboto teka, kaba lia e kukunaro noagu. Aha lel te go kati lia?” ");
INSERT INTO hla_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Be Iesu e poieto i tanen, “Te ngilin butu haniga koru mia lö i matana Tsunono, ba lö te na hahol nem a man ka i tamulö ba lö te hala rami u katun ti moa ta moni, ba lö te ka mem romana a mamana ka a niga i Kolö. Ba lö te mi kukutie molia.” ");
INSERT INTO hla_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ba poata te hengo nia a tson a hitots a ka teka, ba nonei e la halhalina me mataloho koruna, taraha nonei a katun te ka mei a mamana ka, na moni pan. ");
INSERT INTO hla_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Be Iesu e poieto turu katunun tsitsilo i tanen, “Alia e ranga hamana mera golimiu, u katununa tara moni e ka mer romana a toukui pan te gi tahongo uen tara Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Alia e hatei lel rago limiu, e tutu koruna te ga la u a katunun moni tara Nipepeito tere Sunahan, te mar tutu has uana a kamel te katsin sipina tara tsi tabutu tara salum.” ");
INSERT INTO hla_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ba poata ti hengo nia u katunun tsitsilo a ka teka, ba nori i asingoto koruto me poier, “Gesi tsiponi te antunan ka hanigana?” ");
INSERT INTO hla_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Be Iesu e ruto hamatskö uana i taren me ranga palis ranen, “A ka teka e ma antuna nei tara katun tun, kaba e Sunahan e antunana tara mamana ka.” ");
INSERT INTO hla_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Be Pita e poiena, “Alam u la ba nema a mamana ka me kukutie molö. Aha te ka mem romana lam?” ");
INSERT INTO hla_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Be Iesu e poieto i taren, “Alia e ranga hamana mera go limiu, tara han a tsimus i murimuri, poata te na gum goa lia tu butun katunuma turu Gumgum u Goagono i tar, ba limiu u katun te lala gono merio lia te gum has mia romana turu 12 u gumgum u goagono turu king, ba te hamou ramou a 12 a pal barebanar i Israel. ");
INSERT INTO hla_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bu katun hoboto te hakats uar i tar ba te la ba ner u luma i taren tsi u toularen nu hahinaren nu tamaren nu tsinaren, na galapien nu tsikitsiki, nori e na luer romana a para koru lel tara man ka teka, ba te lu hase riou a nitoatoa te ka nitoana. ");
INSERT INTO hla_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kaba u katun u para te panir i romana e na katun papala riou i murimuri, nu katun u para te katun papalar e na pan riou romana.” ");
INSERT INTO hla_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Be Iesu e poieto, “A Nipepeito tere Sunahan e here nei a toa katun terena kuin gerep te la mena bongbong koru ba te na luena u katun te gi na kuiia tara kuin gerep i tanen. ");
INSERT INTO hla_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nonei e hatangana gono mera nen te ga hol merien a man toa toa u toa denarius,* nonei a hihol turu toa u lan, ba nonei te toan hala mera neien tara toukui. ");
INSERT INTO hla_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ba nonei te la lel uana tara toana tara pal 9 kilok ba te tarena a palair u katun te tutuol pukur ba te moar ta toukui. ");
INSERT INTO hla_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ba nonei te ranga mera nen, ‘Alimiu e na kui has moa tara kuin gerep i tar ba lia te hol ragoi limiu a hol te matsköna.’ Ba nori te lar. ");
INSERT INTO hla_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Te kato has uanen tara pal 12 kilok na tara pal 3 kilok, ba nonei a katun te kato hasena a toa markato. ");
INSERT INTO hla_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","7","Na tara pal 5 kilok ba nonei te la lelina ba te tarena a palair u katun ba te tutuol puku hasir. Ba nonei e poiena i taren, ‘Aha te hakapa pinopino sile milimiu u lan u ohots teka ba te ma kuimi?’ Ba nori e ranga palise ren, ‘E moa ta katun te ga hala rilam ta toukui.’ Ba nonei e poieto, ‘Bara, alimiu go la iam ba te na kui has mia tara kuin gerep i tar.’ ");
INSERT INTO hla_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ba poata te lahiia a lahi, ba katun terena kui e ranga mena a kuskus i tanen, ‘Ngö rema u katunun kui ba te hala ramien a hihol i taren, e hataniana tara pala te hatanian kui hamurimuri lila, ba lö te hol hamurimuri ramou a pala te hatanian kui mam lila.’ ");
INSERT INTO hla_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","A barebana ti hatanian kui mei a pal 5 kilok i holri a man toa man denarius. ");
INSERT INTO hla_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ba poata hamanasa tara pala ti hatanian kui mam, e poier nori e gi lu ta hihol ta kapan. Kaba nori has i halari a man toa man denarius. ");
INSERT INTO hla_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Ba nori i lu hakapeto a moni i taren ba nori e hatanian raharaher a katun terena kui me poier, ‘U katun te hagou kui lila e kui pukue lila a toa aua, ba hihol i taren te hihinatoe tsipon mena a hihol i tamulam. Kaba lam e kui mula tara bongbong i gusuna pitala a hiski me na noana tara lahi, ba lö te mar hol mera mule ien te mar hol mera mulei lö alam!’ ");
INSERT INTO hla_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ba katun terena kui e ranga palisena a toa katun i gusuren, ‘O ka, alö go hengo! Alia e ma kato homi gia i tamulö. Alö e hatangana mula te go kui sil meni lö a toa denarius turu toa u lan. ");
INSERT INTO hla_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bara, alö go lui a hol i tamulö ba lö te lam i han. Alia e ngilin hol menagi a katun teka te hagou kui lala te mar hol mena gilia alö. ");
INSERT INTO hla_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Alia e tatei kato menagi a moni i tar te ngil uagu lia. Alö go ma hiomii te tatangana uagu lia.’” ");
INSERT INTO hla_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Be Iesu e hakapena u ranga teka me hatuts rena u katun te hihinatoe uaren i matanen me poiena, “U katun ti murimuri te mamur romana, nu katun ti mam e murimurir romana.” ");
INSERT INTO hla_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Poata te la noa u e Iesu i Jerusalem, nonei e lu halhalir a 12 a katunun tsitsilo i tanen, ba nonei e ranga mera nen tara poata ti la ien i maroro me poiena, “Hengo iam. Ara e la uara i Jerusalem, ba alia tu butun katunuma te na hala neria turu pris pan na turu tson hihatuts turu Lo. Ba nori te na kot nerio lia ba te poier, ‘Alö go mate.’ ");
INSERT INTO hla_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ba nori te hala lel nerio romana lia tara pala te ma Jiuri, ba nori te na hahakos ria romana i tar ba te lahuse rio lia, ba te tapala naria lia tara koruse. Ba turu hatopisanu lan ba lia te takei poutsugu romana ba te toatoagu.” ");
INSERT INTO hla_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Be tsinar a galapien tson tere Sebedi e la uamato tere Iesu na elasolana pien tson i tanen i la gono memen, be tsinaren e hatukununa i matane Iesu, me rangata nena te ga haniga meni e Iesu u ngil i tanen. ");
INSERT INTO hla_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Be Iesu e poieto i tanen, “Aha te ngile mulö?” Ba nonei e ranga palisina, “Alö go haniga ba elasolana pien tson i tar teka te na gum gono merio romana lö, a toa tara pal matou na tai tara pal keruka. Nori e na kato ramoi lö a man gohus i tamulö tara poata te na king mia romana lö.” ");
INSERT INTO hla_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Be Iesu e poiena i taren, “Alimiu e ma atei silemi a ka te rangata nemi limiu. Alimiu e antunan ua mia tara gotana te na ua goa romana lia ba limiu te na sagohe mou a kamits te na sagohe gou lia?” Ba nori i palise ten, “Alam e antunam.” ");
INSERT INTO hla_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Be Iesu e poiena, “E manana, alimiu e na lue mou romana a mar kamits te na lue gou romana lia, kaba lia e moa te go tatei hopu kap meni esi te gumna romana tara pal matou na tara pal keruka i tar. E Tamar talasi te hala nena a man makum teka turu katun te hopu kap raien.” ");
INSERT INTO hla_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ba poata ti hengo nia a maloto a katunun tsitsilo u ranga teka te gi hapan merien, ba nori e raharaha rer u mun toulana teka. ");
INSERT INTO hla_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Be Iesu e ngö gugono mera neien i tanen me poiena, “Alimiu e atei silemiu a markato turu katun te ma Jiuri. U tsunono i taren e ranga hamal ria i taren, na pal kapan i taren e pepeito kap hatagala has raren. ");
INSERT INTO hla_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kaba a markato teka e ma tatei ka neia i gusumilimiu. E moa. Te ngilin panna ta toa i tamilimiu, nonei e tatei here nei a katunun kui i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","28","Na te ngilin mammamna ta toa i tamilimiu, nonei go kato hereni a peisanen a tsi kutupin katun, te mar kato has uagu lia tu butun katunuma. Alia u ma la sile mei te gi kuibe meni u barebana alia. E moa. Alia u la silema e mi kui beragu u barebana, ba te sakahis regi u katun u para a tou mate i tar.” ");
INSERT INTO hla_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tara poata ti la ba nien i Jeriko, bu katun u para koru e kukutie ier e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ba elasolana katun a matakiau e gum ria i rehina kalana me hengoer te la u e Iesu i kalana ba nori e kur me poier, “A Hatutubunei tere Devit a King! Alö go tatagi has ramo lam!” ");
INSERT INTO hla_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bu katun i ranga mera ten e gi ma rarangai ba te kokomotor. Kaba nori i ku hapan koru lel, “A Hatutubunei tere Devit! Alö go tatagi ramo lam, o Tsunono!” ");
INSERT INTO hla_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Be Iesu e tuoluto me ngö ranen, “Aha te ngile milimiu te go kati lia i tamilimiu?” ");
INSERT INTO hla_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ba nori i ranga palis uato i tanen, “Tsunono, alam e ngilin taram!” ");
INSERT INTO hla_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Be Iesu e tatagina me sebele iena a mataren, ba nonei tara poata puku has teka ba nori e tara poutsur, me kukutier e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Tara poata ti susuku ien i Jerusalem, ba nori e butu rima i Betpasi, a han te kaia i rehina u Pokus tara Roein Olip. Be Iesu e hala mammam renama a elasolana katunun tsitsilo me poiena i taren, “Alimiu e la uamiu tara tsi han te tare milimiu ili, ba limiu te toan tare mou a toa dongki ti kits kap nia a lohiana, na tuna has i tanen. Ba limiu te purese ramu men ba te la mera mumeien i tar. ");
INSERT INTO hla_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na te ranga nenoa ta toa ta katun ta ha, ba limiu te ranga memen, ‘A Tsunono e ngil rena men.’ Ba nonei te hala boroboro rena men romana.” E Iesu e ranga u teka. ");
INSERT INTO hla_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","A ka teka e butu mei te ga mana u u ranga te rangein a propet i manasa: ");
INSERT INTO hla_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Alimiu go hatei rami u barebanar i Jerusalem te ngöeri i Saion,* ‘A King i tamilimiu e la hamanasa uanama i tamilimiu. Nonei a tson a tami, e osa papala nama tara tunan dongki a hitots.’” ");
INSERT INTO hla_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bu katunun tsitsilo i na katoeto a ka te rangein e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ba nori e mi piou ner a dongki na tuna, me lapo neria a man hasobu i taren turu dongki, be Iesu e osato. ");
INSERT INTO hla_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bu katun u para koru i haholaseto a man hasobu i taren tara kalana, ba palai e ngatser a man kalan roei me haholase rien tara kalana. ");
INSERT INTO hla_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","U katun u para i laia i mam tere Iesu nu katun u para i la hasia i murimuri tere Iesu me kur me poier, “Hosana! Hala sei iam a Hatutubunei tere Devit! E Sunahan e kalalena a katun te la menama a nitsunono i tanen. Hala sei korue iam a solone Sunahan!” ");
INSERT INTO hla_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tara poata te tukuia e Iesu i Jerusalem, bu katun hoboto tara taun e asingoto korur me poier, “Esi nonei a katun ili?” ");
INSERT INTO hla_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bu katun ti la gono meien e poier, “Nonei e Iesu a propet ni Nasaret i Galili.” ");
INSERT INTO hla_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","E Iesu e la u tara Luman Lotu Pan me tsuga rena u katun ti hol na ti haholia tara makum tara Luman Lotu Pan. Ba nonei e halakopena u salolo turu katun ti hahapalis a moni na u gumgum turu katun ti haholin u kulu. ");
INSERT INTO hla_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ba nonei e poiena i taren, “U ranga tere Sunahan ti koloto nia turu Buk u Goagono e poiena, ‘A luma i tar e ngöeri romana a luman singo.’ Kaba limiu e kato here tsipon namien a kioun mous turu kopkop!” ");
INSERT INTO hla_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","U matakiau nu mou-omi i la uama i tanen tara Luman Lotu Pan ba nonei te kato haniga pouts ranen. ");
INSERT INTO hla_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bu pris pan nu tson hihatuts turu Lo e raharaha mer ti tara menien u mamana u mirakul te katoe ien, na ti kuia a galapien tara Luman Lotu Pan ba te poier, “Hosana! Hala sei iam a Hatutubunei tere Devit!” ");
INSERT INTO hla_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ba nori e poier tere Iesu, “Alö e hengoem a ka te ranga ner a galapien? E ma niga nei.” Be Iesu e ranga palisina, “Alia e hengogu. Alimiu go mala rit hanige iam u ranga te poei tere Sunahan, ‘Alö e haniga rem a ma tsi galapien a ma tsi tetenei noa has te gi solo sei menien lö.’” ");
INSERT INTO hla_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Be Iesu e la ba raten tara taun i Jerusalem me la uana tara han i Betani, te ke ien a toa bong. ");
INSERT INTO hla_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ba poata te la pouts uaien i Jerusalem tara bongbong, be Iesu e besuto. ");
INSERT INTO hla_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ba nonei e tarena u toa u roein fik i rehina kalana ba nonei e la uato i tanen, ba nonei e lagi sakesakieto ta hua. Nonei e ka talasi mei a kala peisa. Ba nonei e poieto turu roei teka, “Alö e ma tatei hua lel moi!” Ba nonei puku tara poata te ranga ien bu roein fik e langona. ");
INSERT INTO hla_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bu katunun tsitsilo i tareto a ka teka me asingotor me poier, “Ime te mar lango boroboro ualala u roein fik teka?” ");
INSERT INTO hla_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Be Iesu e poieto i taren, “Hakhakats kapu niam a ka teka! Te hamana haniga mia limiu ba te ma hula torimi, alimiu e tatei mar kato uamiu te mar kato uagu lalia turu roein fik teka, na limiu e tatei mar ranga has uamiu teka turu pokus teka ba te poemiu, ‘Alö go takei ba lö te lapo ba pouts namia a peisamulö i tasi,’ ba nonei te kato has uana romana te ranga uamou limiu. ");
INSERT INTO hla_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te hamana mia limiu, ba limiu te lue mou romana ta saha ta ka te singo sile milimiu.” ");
INSERT INTO hla_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Be Iesu e kopis poutsuna tara Luman Lotu Pan, ba poata te hihatuts ien, bu pris pan nu tsunono turu Jiu e la uarima i tanen me mi rangatar, “A saha nitsunono te ka memu lö te kato memi lö a man ka teka? Esi te halei lö a nitsunono?” ");
INSERT INTO hla_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Be Iesu e ranga palis ranen, “Alia e rangata has ragoi limiu u toa u harangata. Te hale moa limiu alia u ranga palis i tanen, ba lia te hatei has ragoi limiu esi te hale moi lia a nitsunono te go kato meni lia a man ka teka. ");
INSERT INTO hla_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ime te lueia e Jon a nitsunono te ga baptais merien u katun? Tere Sunahan tsi tara katun tun?” Ba nori e hiarangrangata poutsur me poier, “Aha te poe rou ra? Te gi poe meni ra, ‘E Jon e ka mei a nitsunono tere Sunahan,’ be Iesu te poe nou i tarara, ‘Ga taraha tsiponi ba limiu te ma hamanemi e Jon?’ ");
INSERT INTO hla_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na ra e namos poe hasera, ‘E Jon e ka mei a nitsunono tara katun.’ Taraha, a barebana hoboto e poier e Jon a propet tere Sunahan. Na ra e matoutera te gi raharaha uen.” ");
INSERT INTO hla_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ba nori e ranga paliser e Iesu, “Alam e ma ateimi.” Ba nonei e poiena i taren, “Na lia has e ma tatei hatei ragi limiu esi te hale moi lia a nitsunono ba lia te katoegu a man toukui teka.” ");
INSERT INTO hla_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Be Iesu e ranga lelina me poiena, “Hakats neiam u ranga te katoe gou lia teka: A toa katun e ka mei a elasolana pien tson. Ba nonei e la uana tara pien a hamua me poiena, ‘A pien i tar, alö go na kuiia tara kui i romana.’ ");
INSERT INTO hla_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ba pien e ranga palisito, ‘Alia e ramagu.’ Kaba i murinen ba nonei e habiritseto u hakhakats i tanen ba nonei e na kuina tara kui. ");
INSERT INTO hla_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Be tamanen e lato me na katoena u toa u mar ranga tara pien tson a hatut. Ba pien e ranga palisito me poiena, ‘Aa, alia e la gou.’ Kaba nonei e ma lai. ");
INSERT INTO hla_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Na saha pien te kato a ka te ngil e tamanen?” Ba barebana e poier, “A pien a hamua.” Be Iesu e poieto i taren, “Ne kato has uana i iesana tara Nipepeito tere Sunahan. Alia e ranga hamana mera golimiu, u katun te lulu hagamoer a takis nu tohaliou u hahaloku e la mammam rariou limiu ba te na tasu ria romana i iahana Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Taraha, e Jon a Tsonun Baptais e mi haruto rilimiu a maroro a matskö te go luam limiu, kaba limiu u ma hamane mien. Na pal tson u omi na tohaliou u omi i hamane ien. Na limiu u ruto hakape iam ti mar kato uen teka, kaba limiu u ma palisemi u hakhakats ba te hamane men.” ");
INSERT INTO hla_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Be Iesu e hihatuts lel neto a ka teka me poiena, “Hengo iam turu tana u haharoei. A toa katun te ka mei a toa makumun tsikitsiki i tanen e na lebei a kuin gerep me kuiena a ololo i tanen, me kahoena a kiou te gitö pulpuleia u gerep ba te kuieri u ramun i tanen u wain. Ba nonei e kui lelena a toa luman pepeitokap a pia tara kuin gerep. Ba nonei e hataratara kap tun ranei u palabir u katun a kuin gerep teka me hakuin moni nanen, ba hapalana moni e la uato tara katun terena kui. Ba nonei e la uato tara toa han i lehana. ");
INSERT INTO hla_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Bi murimuri ba poatan tangoho tara kui e butu hakapato, ba nonei e hala mera nei u katunun kui i tanen tara barebana ti kuiia tara kuin gerep. Nonei e ngilin lu a pal hua i tanen. ");
INSERT INTO hla_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bu katunun taratarakap tara kui e lu rer u katunun kui i tanen, me lahuser a toa, me atung hamatier a tai, ba nori e tieri a tai a hatu. ");
INSERT INTO hla_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ba katun terena kui e hala lele mato u tana u katunun kui i tanen, e para baler a pala mam, bu katunun taratarakap tara kui e mar kato lel mera rien i iesana. ");
INSERT INTO hla_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ba kapakapanen ba nonei e hala nena a pien tson i tanen, ba nonei e poiena, ‘Nori e hapane riou romana a pien tson i tar.’ ");
INSERT INTO hla_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kaba poata ti tare ien a pien tson teka ba nori e poier, ‘A pien tara katun terena kui teka te lue nou romana a kuin gerep. Ara gi atung hamatien, ba ra te lue rou a kui i tanen!’ ");
INSERT INTO hla_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ba nori i pile kap naten me las halakasa mena rien tara kuin gerep ba nori e atung hamatie ren. ");
INSERT INTO hla_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Bara, ba poata te lama a katun terena kuin gerep gaha te katoe noen turu katun u omi teka?” Te mar rangata u e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ba pal kapan turu Jiu e poier, “Nonei e atung hamate koru ranou u katun u omi teka, ba nonei te hataratara kap ranoi u katun u niga a kuin gerep teka, ba nori te hala hamatsköe roien u hua i tanen tara poatan tangoho.” ");
INSERT INTO hla_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Be Iesu e ranga mera ten, “Alimiu go mala rit hanige iam u ranga turu Buk u Goagono te kato here nanei lia a hatu. E kato uana, ‘A hatu ti raman u katunun hatakei tara luma ba te hapiraka ba ner, nonei a hatu te niga balana tara toukuina tara luma. A ka teka a Tsunono te katoen, ba ra te poiera a ka a kapan koru teka!’” ");
INSERT INTO hla_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Be Iesu e poe lelena, “U ranga teka e ranga rano limiu. Na lia e hatei rago limiu, a Nipepeito tere Sunahan e lu ba rari romana limiu ba te hala rari romana u katun te katoer a toukui a niga.* ");
INSERT INTO hla_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","A katun te tsiana romana tara hatu teka e tapekona romana. Kaba te konena romana a hatu teka ta katun, ba nonei te kono bulbul here nanoien u koahu.*” ");
INSERT INTO hla_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bu pris pan nu Parisi e hengoer a man haharoei teka tere Iesu, ba nori i atei sileto e Iesu e ranga sil ren, ba nori e raharahar. ");
INSERT INTO hla_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ba nori e katsin pile kap naren, kaba nori i matoutir a barebana, taraha a barebana i poei e Iesu a toa propet. ");
INSERT INTO hla_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","E Iesu e ranga lel ponin u haharoei tara poata te ranga ien turu katun me poiena, “A Nipepeito tere Sunahan e kato uana teka. A toa king e kato a kannoun hitöl tara pien tson i tanen. ");
INSERT INTO hla_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ba nonei e hala rena u katunun kui i tanen te gi na ngö mera mei u katun ti tahul mam rema te gi la uama tara kannoun hitöl, kaba nori i ma ngilin la uamei tara kannou. ");
INSERT INTO hla_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ba nonei a king e hala lel rena a palair u katunun kui me poiena i taren, ‘Na ranga mera muma u katun tu tahul mam rela lia, A kannou e aloso hamanasana. Alam u atung hakapi u bulumakau u tson na man tunan bulumakau man bokoko. Na mamana ka e kana e alosona. Alimiu go la uamuma tara kannoun hitöl.’ ");
INSERT INTO hla_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ba nori e na ngö raren. Kaba u katun ti ngö rela i ma hengoei u ranga, me la uar tara man toukui i taren: a toa e la u tara kui i tanen, na tai e la u tara stoa i tanen. ");
INSERT INTO hla_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ba palai e pile kap rer u katunun kui tara king me kato homi raren, me atung hamate raren. ");
INSERT INTO hla_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Be king e raharaha koruto, me hala rena u soldia i tanen me na atung hamate rer u katun ti atungir u katunun kui i tanen, me hakuluper a taun i taren. ");
INSERT INTO hla_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ba nonei e ngö rena a palair u katunun kui i tanen me poiena, ‘A kannoun hitöl e alosona, kaba u katun tu ngö rilia e omir. Nori e ma tatei la tala rimei. ");
INSERT INTO hla_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bara, la uam tara man kalana i iahana taun ba te tahul mera mumei u katun hoboto te go sabe riam limiu tara kannou.’ ");
INSERT INTO hla_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bu katunun kui e la uar tara man kalana me gono rarima u katun hoboto ti sabe ren, u katun u omi nu katun u niga. Ba luma tara hitöl e saputu rena u katun. ");
INSERT INTO hla_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Be king e lato te na ruto meri u katun ti lama, ba nonei e tarena a toa katun e ma la memei u hasobuna tara hitöl. ");
INSERT INTO hla_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ba nonei poiena i tanen, ‘O ka, a neha tsiponi te la uamu malö teka ba te moam tu hasobuna tara hitöl?’ Ba katun e hahalongolona. ");
INSERT INTO hla_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Be king e ranga mereto u katunun kui i tanen, ‘Kits kap niam a limanen na mounen ba limiu te lapo ba namien i ielesala turu kuhil, tara makum te tabe hohomi noen ba te har tun hasina.’” ");
INSERT INTO hla_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Be Iesu e rangana, “E kato uana teka be Sunahan te ngö rena u katun u para, kaba e ma paraparari te hopu kap rena e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Bu Parisi e na hiarangrangata ner ime te gi mar hagögohe meni e Iesu turu ranga i tanen. ");
INSERT INTO hla_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ba nori i hale ieto a palair u katunun tsitsilo i taren na palair u katun tere Herot tere Iesu me poier, “Tson Hihatuts, alam e atei silem alö a katun a mana. Alö e roron hihatuts hamana nem a maroro tere Sunahan, taraha alö e ma hakats silemi a ka te hakats ner u katun tsi a nikapan i taren. ");
INSERT INTO hla_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bara, alö go hatei ramo lam, e niga hasina turu Lo i tarara te gi hol meni a takis tere Sisa* a Gamman Pan, tsi e moa?” ");
INSERT INTO hla_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kaba e Iesu e atei sil hakapi u hakhakats u omi i taren, ba nonei e poiena, “Alimiu u gamogamo! Aha te katsin gamo sile milimiu alia? ");
INSERT INTO hla_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Harute mumei lia a moni te holeri a takis.” Ba nori e hale rien a toa moni. ");
INSERT INTO hla_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ba nonei e rangata ranen, “A bakuna esi na solona esi te kar teka?” ");
INSERT INTO hla_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ba nori e poier, “E Sisa.” Be Iesu e poiena i taren, “Bara, halemi e Sisa a man ka i tanen, ba te hala hasemi e Sunahan a man ka i tanen.” ");
INSERT INTO hla_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ba poata ti hengoe ien a ka teka, ba nori e asingoto korur. Ba nori e la ba naren. ");
INSERT INTO hla_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","24","Nonei turu lan bu Sadiusi i la uamato tere Iesu. Nori a pal katun teka i poe e moa ta tou takei pouts tara tou mate. Ba nori i poieto tere Iesu, “Tson Hihatuts, i manasa e Moses te poei, ‘Te ga mateia ta tson ba te moana ta pien, e toulanen e tatei tölena a amoba, ba nori te hatuhaner romana ta pien te ngö rari romana a solona tson te mate.’ ");
INSERT INTO hla_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bara, a elahit u mun toulana i kaia i gusumulam. Ba ka hamua e hitöluna, me matena ba te moa noana ta pien. Be toulanen a hatut e toan tölena a amoba. ");
INSERT INTO hla_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na hatut e mate has ba te moana ta pien. Ne kato hasi u i iesana tara helapisa, na tara munmun toulana hoboto teka. ");
INSERT INTO hla_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ba i muriren hoboto, ba tahol e mate hasina. ");
INSERT INTO hla_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na tara poata te takei pouts ria romana a barebana tara tou mate i taren, nonei e tahol uana romana teresi? Taraha, u mun toulana elahit i hitöl hoboto meien.” ");
INSERT INTO hla_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Be Iesu e palis ranen me poiena, “Alimiu e ma matskömi. Taraha, alimiu e ma atei silemi u Buk u Goagono na nitagala tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Poata te takei ria romana u mate, nori e hereri romana u angelo ri Kolö ba te ma tatei hitölri romana. ");
INSERT INTO hla_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kaba turu ranga teka te takei pouts uar romana u katun ti mate, alia e ngilin hatei rago limiu: alimiu go mala rit hanige iam u ranga tere Sunahan te la has uana i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nonei e mar ranga u teka: ‘Alia a Sunahan tere Abraham na lia a Sunahan tere Aisek na lia a Sunahan tere Jekop i romana.’ U ranga teka e poiena nonei e ma Sunahan uanei turu katun u mate. E moa. Nonei a Sunahan turu katun te toatoar. Ere Abraham mere Aisek ne Jekop i mate hakapa, kaba nori i ma taiai. Taraha, u ranga teka e poiena nori e toatoa noar.” ");
INSERT INTO hla_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ba poata ti hengoeia u katun a ka teka, ba nori e asingoto koru ner u hihatuts i tanen. ");
INSERT INTO hla_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ba poata ti hengoeia u Parisi te tupu meri e Iesu a rungur u Sadiusi, ba nori e la gugono rima. ");
INSERT INTO hla_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ba toa i taren, a tson hihatuts turu Lo, e katsin torohale neien u toa u harangata. ");
INSERT INTO hla_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ba nonei e poiena, “Tson Hihatuts, sahu masaka te panina turu masaka hoboto tere Sunahan?” ");
INSERT INTO hla_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Be Iesu e ranga palisina, “‘Alö go ngil koru a Tsunono i tamulö e Sunahan turu tori hoboto i tamulö na turu namnamei hoboto i tamulö na turu hakhakats hoboto i tamulö!’ ");
INSERT INTO hla_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nonei u toa u masaka teka te pan koruna. ");
INSERT INTO hla_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na u hahuoluna u masaka u kapan e kato has uana teka: ‘Alö go mar ngil koru meni a tana katun te mar ngil koru mena milö a peisam.’ ");
INSERT INTO hla_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","U huol u masaka teka e mounana turu mamanu ranga tere Moses na turu propet.” ");
INSERT INTO hla_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Poata ti gonogono hobotoia u Parisi, be Iesu e rangata ranen, “Ime te mar hakats uami limiu tere Mesaia? Nonei a hatutubunei teresi?” Ba nori i poieto, “Nonei a hatutubunei tere Devit.” ");
INSERT INTO hla_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Be Iesu e poe leleto, “Ga taraha tsiponi bu Namnamei u Goagono e haranga e Devit be Devit e ngöe nei e Mesaia ‘A Tsunono’? ");
INSERT INTO hla_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Taraha, e Devit e poei, ‘A Tsunono e poei tara Tsunono i tar, Gumia teka tara pal matou i tar, antunana te hale goi lia lö u katun te paköe rio lö ba lö te na pita-puta ramoen.’ ");
INSERT INTO hla_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","E Devit e ngöei a katun teka ‘A Tsunono’. Gime te mar hatubuna uana e Mesaia tere Devit?” ");
INSERT INTO hla_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kaba e moa ta toa te ga antunan ranga poutsin ta tsi toa ta tsi ranga tere Iesu. Na i murina poata teka e moa ta toa te ga rangate ien tu toa tu harangata, taraha nori i matout. ");
INSERT INTO hla_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","2","Be Iesu e rangana turu barebana na turu katunun tsitsilo i tanen me poiena, “U tson hihatuts turu Lo nu Parisi e ka mer a nitsunono te gi hatarare meni u Lo tere Moses. ");
INSERT INTO hla_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Na limiu go hengo ramen ba te kukutiemiu a mamana ka te ranga mera rien limiu. Kaba limiu e ma tatei kukutiemi a markato i taren, taraha nori pouts e ma kukutieri a man lo te hake rien i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nori e roron hake ria a man lo man tiama turu katun, u lo te ka mer a toukui pan. Kaba nori e ma tatei kukutieri ta tsi toa ta tsi lo teka. ");
INSERT INTO hla_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","A mamana ka te roron katoe ren e kato merien te gi ruto merien u katun. Hena, nori e roron hakits neria a ma tsi bokis ma tsi kapan i poleren na i limaren te ka mena u rangan lotu i iogana. Na nori e kato hatsimaler u rungrunguna u hasobu u ngahangaha i taren ba te tatabala koruna. ");
INSERT INTO hla_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Na nori e ngilin gum ria turu gumgum tara pal kapan tara kannou na turu gumgum u niga i luman lotu. ");
INSERT INTO hla_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nori e ngiler u katun e gi hapan rien tara toana, na nori e ngil haser a barebana e gi ngö rien u Rebai. ");
INSERT INTO hla_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kaba u katun e ma tatei ngö raroi limiu u Rebai (te mouna uana tara Tson Hihatuts) taraha alimiu e ka memiu a toa puku a Tson Hihatuts, nonei a Tsunono, na limiu hoboto u man munmun toulana.* ");
INSERT INTO hla_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ba limiu te ma ngö hasemi ta toa ta katun pan e Tamamilimiu i puta teka, taraha alimiu e ka memiu a toa Tamamilimiu, te kana i Kolö. ");
INSERT INTO hla_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na u katun e ma tatei ngö has rari limiu u Masta, taraha alimiu e ka memiu a toa Masta, alia e Mesaia. ");
INSERT INTO hla_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","A katun te pan bala rano limiu e tatei katunun kuina i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","A katun te solo sei peise iena a peisanen, a solonen e na la putana romana. Kaba katun te solo pute iena a peisanen, nonei e na luena romana a solo pan.” ");
INSERT INTO hla_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","E Iesu e ranga lel me poiena, “Alimiu u tson hihatuts turu Lo na limiu u Parisi, a nomi pan e butuna romana i tamilimiu! Alimiu u gamogamo, ba te pili ba remi u katun te ngilin tasu ria tara Nipepeito tere Sunahan, na limiu noa has te ma tasumi. ");
INSERT INTO hla_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Alimiu u tson hihatuts turu Lo nu Parisi, a nomi pan e butuna romana i tamilimiu, u katun u gamogamo! Alimiu e roron katoemiu u singon lotu u ngahangaha turu rung tun, ba te lu tsipon bemi a peisamiu a man ka turu amoba. E kato uana teka ba limiu te luemiu romana a nihahuna a omi koru.* ");
INSERT INTO hla_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“A nomi pan e butuna romana i tamilimiu u tson hihatuts nu Parisi, u gamogamo! Alimiu e roron la halehana korumiu i tasi na turu tsikitsiki, te go kato menami a toa puku a katunun tsitsilo i tamilimiu. Ba poata te butun katunun tsitsilo hakapa nen, ba limiu te kato tsipone mien a katun a omi koru te na hahune ria romana i hel, ba te here hase nei limiu. Na limiu e katoe mien a katun te omi karasa has ranou limiu. ");
INSERT INTO hla_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Alimiu u matakiau te ngilin haruto tsipon nemiu a maroro turu katun! A nomi pan e butuna romana i tamilimiu. Alimiu e roron mar ranga uamiu teka ba te poemiu, ‘Te ga hamanaia ta katun tara Luman Lotu Pan ba te poiena e manana i iasa, a ka pinopino. Kaba te ga hamanaia ta katun tara goul tara Luman Lotu Pan ba te poiena e manana i iasa, aa, nonei e tatei mar kato koru uana te ranga uanen.’ ");
INSERT INTO hla_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Alimiu u katun u matakiau u tutu! Saha ka te panina, a goul? E moa! A Luman Lotu Pan te hagoagonena a goul, nonei te panina. ");
INSERT INTO hla_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Na limiu e poe hasemiu, ‘Te ga hamanaia ta katun tara makumun hats, a ka pinopino. Kaba te ga hamanaia ta katun tara man ka te kana tara makumun hats, aa, nonei e ga mar kato koru u te mar ranga uanen.’ ");
INSERT INTO hla_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Alimiu u katun u matakiau! Aha te panina, a man ka te kana tara makumun hats? E moa. A makumun hats te hagoagonena a man ka te kana i tanen, nonei te panina. ");
INSERT INTO hla_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","A katun te hamanana tara makumun hats e hamana hasna tara man ka te kana i tanen. ");
INSERT INTO hla_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na katun te hamanana tara Luman Lotu Pan e hamana hasna tere Sunahan te kana i tanen. ");
INSERT INTO hla_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na katun te hamanana i Kolö e hamana has uana tere Sunahan na turu gumgum u goagono te gum nen. ");
INSERT INTO hla_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Alimiu u tson hihatuts turu Lo na limiu u Parisi, a nomi pan e butuna romana i tamilimiu! Alimiu u gamogamo! A mamana ma tsi kan hasoksoka a ma tsi tetenei te kana tara kui, alimiu e roron patskikemiu a ma tsi maloto a ma tsi makum ba te halemi e Sunahan a man hamalotona man makum. Na markato te hala menari a hamalotona makum tere Sunahan e nigana. Kaba limiu e totonemiu u mar hihatuts u kapan turu Lo te kato uana: a markato te hamou hamatskö menari u ranga turu katun, na markato te tatagi mera nei e Sunahan u katun, na markato a mana. ");
INSERT INTO hla_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Alimiu u matakiau te ngilin haruto tsipon nemiu a maroro turu katun! Alimiu e roron hakats hapara nemiu a ma tsi markato pinopino, kaba limiu e ma kato tsiponemi a markato a niga te panina i matane Sunahan. ");
INSERT INTO hla_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Alimiu u tson hihatuts turu Lo nu Parisi, a nomi pan e butuna romana i tamilimiu, u katun u gamogamo! Alimiu e roron kato hagogosemiu a murina kap na pelet, kaba ahanen e korkorianana, te kato has uana a torimilimiu te habutsena a markato tara kop na te rongaronga mena milimiu u ngil tun turu tuanrei. ");
INSERT INTO hla_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Alimiu u Parisi u matakiau! Alimiu go kato hagogoso mam iam a torimilimiu, ba markato i tamilimiu te tarer u katun e niga has nou romana. ");
INSERT INTO hla_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“A nomi pan e butuna romana i tamilimiu u tson hihatutus nu Parisi, u gamogamo! Taraha alimiu e heremi u kioun mate ti goagoei u goagoa u hiaka te tara hanigana i ielesala, kaba i iogana e saputena u tsinön mate na mamana ka a koreme. ");
INSERT INTO hla_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Alimiu has e mar ka talasi uamiu teka. Bu katun te tarer a peisamilimiu ba te poier alimiu u katun u matskö. Kaba i iogana alimiu e saputemiu a markato turu gamo na mamana markato a omi.” ");
INSERT INTO hla_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Iesu e ranga lel me poiena, “A nomi pan e butuna romana i tamilimiu u tson hihatuts turu Lo nu Parisi, alimiu u katun u gamogamo! Alimiu e roron kuiemiu u kahokaho u niga turu propet ti mate ba te kalalan hitots namiu u kahokaho turu katun u matskö. ");
INSERT INTO hla_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ba limiu te poemiu, ‘Sanena ara ti kaia tara poata turu tuburara i manasa, ara sane ma taguhu rien te gi atung hamate meri u propet.’ ");
INSERT INTO hla_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Turu ranga teka i tamilimiu, alimiu e poke iemiu te hatutubunei uami limiu turu katun ti hamatir u propet i manasa! ");
INSERT INTO hla_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na limiu e mar kato uamiu ti kato uen, ba te hahonotsemiu u markato u omi i taren. ");
INSERT INTO hla_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Alimiu u katunur tara kukutsi a omi —u gamogamo! E moa koru te go antunan bus ba mena milimiu romana a nihahuna i hel. ");
INSERT INTO hla_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Alia e hala regou romana i tamilimiu u propet nu katun u atei nu tson hihatuts. Ba limiu te tapala nemia romana ta palai tara koruse ba te kato hamate ramen, ba limiu te lahus ramia romana ta palai turu luman lotu i tamilimiu ba te kute ramen romana tara man taun te bus uaren. ");
INSERT INTO hla_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ba limiu te alatsemiu romana u katun u matskö hoboto ti atung hamate pukur i manasa, e taniaia tere Abel ti atung hamate puku, ba te noana tere Sekaraia a pien tere Berekaia ti atung hamateia u tubumilimiu i gusuna Luman Lotu Pan na makumun hats. ");
INSERT INTO hla_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Alia e ranga hamana koru mera golimiu, a nihahuna tara man markato teka e lue riou romana a hei barebana i romana!” ");
INSERT INTO hla_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Be Iesu e poieto, “A tei Jerusalem, tei Jerusalem, alimiu e roron atung hamate ramiu u propet me ti hatu ramiu u katunun raranga te hala mera mei e Sunahan i tamilimiu! A poata a para tu ngilin gono mera mei lia limiu i tar ba te hatongo kap rago limiu, te mar gono mena nei a keriau u tuna i kopina pakapakanen. Kaba limiu e ramamiu! ");
INSERT INTO hla_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na han i tamilimiu e kaka puku koruna romana. ");
INSERT INTO hla_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Alia e ranga mera golimiu, alimiu e ma tatei tara lele moi lia e popona te poe mia romana limiu, ‘E Sunahan e kalalena a katun te la menama a nitsunono i tanen.’” ");
INSERT INTO hla_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Be Iesu e la ba neto a Luman Lotu Pan me katsin lana, bu katunun tsitsilo i tanen e la uarima i tanen te go mi haruto meni e Iesu a man luma tara Luman Lotu Pan. ");
INSERT INTO hla_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Be Iesu e poieto, “Aa, ruto uam tara man luma man niga hoboto teka. Na lia e ranga hamana mera golimiu, e moa ta toa ta hatu teka te ga ka lelia romana tara makum i tanen. Nori hoboto koru e lapo puta rer romana.” ");
INSERT INTO hla_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","E Iesu e gumia turu Pokus tara Roein Olip bu katunun tsitsilo i mi ka pepeisa gono meten me rangatse ren, “Hatei ramei lam i hangisa te butuna romana a ka teka, na hiharuts te haruto nenou a poata te go la pouts uama lö na te kapana romana a han.” ");
INSERT INTO hla_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Be Iesu e ranga palisito, “Hanei iam, ba te ma hengoemi ta katun te ga gamo rio limiu. ");
INSERT INTO hla_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Taraha, u katun u para e la rima romana ba te ngöe roi a peisaren a solor ba te poier, ‘Alia e Mesaia!’ ba nori te gamo rer romana u katun u para. ");
INSERT INTO hla_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Alimiu e hengoemiu romana te ling uana romana a man hiatatung i susuku nu habulungana tara man pula i lehana. Kaba limiu go ma matoutumi. A man ka teka e butu noa lasina romana, kaba a nikapakapa e ka noana. ");
INSERT INTO hla_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","A toa han e hiatatung mena romana a tana han, na palair u hun katun e hiapulpular romana. A bes pan na man nun e gas lana romana turu han u para. ");
INSERT INTO hla_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","A man ka teka e here nei romana te kamits tutun uana a pien te pose ier. ");
INSERT INTO hla_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Bu katun te pile kap rariou romana limiu te gi hakamits meri limiu, ba limiu te kato hamate rariou. U mamanu hun katun e omi merari romana limiu alia. ");
INSERT INTO hla_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","A katun a para e hapolaser romana u nihamana i taren tara poata teka. Nori e hala mera roi romana a palai turu katun te pakö raren ba te hihiomi pouts hasir. ");
INSERT INTO hla_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bu katun u gamogamo u para te butur romana ba te ngöeri a peisaren u propet tere Sunahan, ba te gamo rer u katun u para. ");
INSERT INTO hla_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","A man markato a man omi teka e para koruna romana bu ngilngil turu katun u para te kapa susuluna romana. ");
INSERT INTO hla_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kaba u katun te pile kap ner romana a markato tere Sunahan tara poata a omi teka ba te ma hapolasari, e Sunahan e lu pouts mera noien i tanen. ");
INSERT INTO hla_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bu Bulungana u Niga teka tara Nipepeito tere Sunahan te hihatuts laner romana tara mamana han i puta, bu hun katun hoboto te hengoe ren romana, bi murinen ba kapakapana han te toan butu nou.” ");
INSERT INTO hla_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Be Iesu e poiena, “Alimiu e taremiu romana a ka a omi koru te rangein e Daniel a propet ni manasa, ba te tuolna tara makum a goagono.” (A katun te ritena u ranga teka e ga hakats koru nen.) ");
INSERT INTO hla_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Ba pala te ka ria romana i Judia e gi bus u tara pokus. ");
INSERT INTO hla_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na katun te kana romana i iapu i tanen e moana romana ta poata te ga lu meien a man ka i tanen i iahana luma. ");
INSERT INTO hla_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na katun te kana romana tara kui i tanen e ma tatei la pouts nei romana te ga na lu meni a man hasobu i tanen. ");
INSERT INTO hla_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","A nitatagi pan koru e kana romana tara tohaliou te ka mer romana u pika nonei tara poata, na tara tohaliou te hihasusur romana! ");
INSERT INTO hla_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Alimiu go singo uam tere Sunahan ba poatan bus teka te ma butu nei tara poatan hamuri na turu Lan u Goagono. ");
INSERT INTO hla_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Taraha, a niomi te butuna romana nonei tara poata e pan saluhe koru nena romana a man niomi hoboto, te butu i manasa tara poata te katoeia e Sunahan a mamana ka ba te noana i romana na tara poata hoboto i murimuri. ");
INSERT INTO hla_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kaba e Sunahan e hamakmakumena romana a poata teka. Sanena te moana, e ga moa koru ta katun te ga tatei ka haniga romana. Kaba e Sunahan e peko menei romana a poata teka te go taguhu merien u katun te hopu kap reien. ");
INSERT INTO hla_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kaba te poiena ta katun i tamilimiu, ‘Ruto iam, e Mesaia teka!’ tsi ‘Nonei ili!’ — ma hamanemi. ");
INSERT INTO hla_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Taraha, u Mesaia gamogamo nu propet gamogamo e butur romana, ba nori te katoer romana u hiharuts u kapan na man mirakul. Te gi antuna uen, ba nori te gamo rer romana u katun noa has te hopukap meri e Sunahan i tanen. ");
INSERT INTO hla_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Hengo iam! Alia e hatei mera gilimiu a ka teka i mam tara poata te ga butu ien romana. ");
INSERT INTO hla_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“E kato uana, te gi hatei raia u katun alimiu, ‘E Mesaia e kana tara latu pinopino!’ - ma la uami ili. Tsi te gi poien, ‘Nonei e mousna i iahana luma’ — ma hengoemi u ranga teka. ");
INSERT INTO hla_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Taraha, alia tu butun katunuma e la here gumei romana u kanaha te kanahana tara mamana makum turu kolö. ");
INSERT INTO hla_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“U katun e atei siler a makum te kana u tuanrei u mate, taraha nonei a makum te gonogono ria u apena te nounouer a ka a koreme. Ne kato has uana i iesana, a barebana e atei sil hase riou ime te butu goa romana lia.” ");
INSERT INTO hla_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","E Iesu e ranga noana, “Poata te hagou kapana romana a niomi nonei tara poata i murimuri, ba pitala te kuhilina romana, na tsihau e ma piri has nei romana, nu pitopito e rus rima romana i kolö. Ba mamana ka a tagala ni kolö te gasir romana ba te tasula ba ner a man makum i taren. ");
INSERT INTO hla_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ba hiharuts i tar tu butun katunuma te butuna romana i kolö. Bu mamanu pal katun i puta te matoutur romana, ba te taber, ba nori te tarer romana alia tu butun katunuma ba te la meguma u koasi i kolö na nitagala nu ualesala u kapan. ");
INSERT INTO hla_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ba lia te hapihegu romana a tuhil ba te ling hapanina, bu angelo i tar te lar turu han hoboto i puta, ba nori te gono rarima u katun te hopu kapir e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","E Iesu e ranga lel me poiena, “Alimiu go hatate niam u haharoei turu ngal. Tara poata te suluna u ngal, ba limiu te atei silemiu a poatan nou turu ngal e susukuna. ");
INSERT INTO hla_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ne kato has uana i iesana, poata te tare mia romana limiu a man ka hoboto teka te ranga negu lalia, ba limiu te atei sile mou a poata e susuku koru nama. ");
INSERT INTO hla_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Alia e hatei hamana rago limiu, a mamana ka hoboto teka e butuna romana i mam te mate ria a palair u barebana te toatoar tara poata teka. ");
INSERT INTO hla_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","U kolö nu puta e taia hakapar romana, kaba u ranga i tar e moa koru te ga tatei taia uen romana.” ");
INSERT INTO hla_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Be Iesu e poiena, “Kaba e moa ta toa te ga atei sil u lan tsi a aua te butu nama romana a man ka teka. U angelo ri Kolö e ma ateiri, na lia has tu butun katunuma e ma atei hasgi. E Tamar peisa te ateina. ");
INSERT INTO hla_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","A poata te la pouts guma romana lia e mar kato has uana romana te kato u a poata tere Noa i manasa. ");
INSERT INTO hla_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tara man lan i mam turu uolo pan, u katun i nou na i ua, na pal tson na tohaliou i hitöl e noa hamatsköia turu lan te tasuia e Noa tara tolala. ");
INSERT INTO hla_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na nori i ma atei sil noa hasei aha te ga butu. Nu uolo e butu hakapa tala ba nori te toan atei sil hamanaser te mana u u ranga tere Sunahan. Kaba u uolo e salo ba hakapa ren. Na nonei lahas te mar kato uana romana a poata te la pouts guma romana lia, alia tu butun katunuma. ");
INSERT INTO hla_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nonei tara poata i murimuri a elasolana tson e kui ria romana tara kui. A toa e lu ba ner romana, ba tai te kakana romana. ");
INSERT INTO hla_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Na elasolana tahol e kono hoboter romana a kannou i han. A toa e lu ba ner romana, ba tai te kakana romana. E kato uana teka, ba limiu te haneimiu. ");
INSERT INTO hla_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Taraha, alimiu e ma atei silemi u sahu lan te la nama romana a Tsunono i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hakats niam a ka teka: sanena te ga atei sil meni a katun terena luma i hangisa te ga lama a kopkop, ba nonei sane kalatana ba te hatongo kap nena a kopkop te ga tasu uen i luma. ");
INSERT INTO hla_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","E kato uana teka ba limiu te hanei hasmiu. Taraha, alia tu butun katunuma e la pouts guma romana tara poata te ma hakats namia limiu te go la uama lia.” ");
INSERT INTO hla_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Be Iesu e poe lelena, “Alimiu e heremi a katunun kui hamana te hakats hanigana? Hengo iam. A katun pan i tanen e hataratara kap nien a palair u katunun kui i tanen te ga hala rien a kannou i taren tara poata hamatskö i tanen. ");
INSERT INTO hla_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","A katunun kui teka e tatei sasalana te ga sabe meni a katun pan i tanen te markato uanen teka tara poata te ga la pouts uamen i han! ");
INSERT INTO hla_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","U mana koru alia e ranga mera golimiu, a katun pan i tanen e tatei hataratara kap nena a katunun kui teka i tanen a mamana ka hoboto te teie nen. ");
INSERT INTO hla_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kaba te ga katunun kui homi uen, ba nonei te rangana i torinen ba te poiena, ‘A katun pan i tar e ma hasesein la pouts namei romana.’ ");
INSERT INTO hla_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ba nonei te hatanian atung rena romana a palai turu katunun kui, ba nonei te nouna ba te ua gono me rena u katun te ua hatutur. ");
INSERT INTO hla_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ba katun pan tara katunun kui teka te songots la nama romana tara poata te ma hakats nane ien e ga lama. ");
INSERT INTO hla_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ba katun pan te hahune noen, ba nonei te haka gono mera neien u katun u gamogamo. Tara makum teka u katun e tabe hohomi riou romana ba te har tun hasir.” ");
INSERT INTO hla_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Be Iesu e poe lelena turu katunun tsitsilo i tanen, “Poata te butu nama romana nonei u lanin takopis tara Tsunono, ba Nipepeito tere Sunahan te here namei romana a maloto a tahol a kukubei ti lu a lam i taren ba te lar te gi na hitupali menien a tsonun tölo. ");
INSERT INTO hla_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Na elalima tahol ti tutu na tana elalima tahol ti hakats haniga. ");
INSERT INTO hla_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","A tohaliou u tutu i lui a lam i taren, kaba i ma lui tu karasin tu para. ");
INSERT INTO hla_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ba tohaliou ti hakats haniga i lueto a man botolo karasin a man saputu na lam i taren. ");
INSERT INTO hla_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na tsonun tölo e ma la boroboro mei, ba nori hoboto e topir me sohor. ");
INSERT INTO hla_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ba tara gusuna bong ba toa katun e kuna me poiena, ‘A tsonun tölo e la hamanasa nama. Alimiu go la uamuma i tanen.’ ");
INSERT INTO hla_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bu tohaliou u kukubei hoboto e takeir ba te pilits hapan pouts ner a lam i taren. ");
INSERT INTO hla_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ba pal tohaliou u tutu e poier tara pal tohaliou ti hakats haniga, ‘Alimiu go hala ramu mei lam ta tsi karasin i tamilimiu, taraha a lam i tamulam e katsin osor.’ ");
INSERT INTO hla_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kaba a pal tohaliou ti hakats haniga i ranga palis me poier, ‘E moa. U karasin e ma antuna nei i tamilimiu na i tamulam has. Alimiu go la uam i stoa ba te na hol peisemiu u karasin i tamilimiu.’ ");
INSERT INTO hla_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ba pal tohaliou u tutu e na holer u karasin. Ba poata ti tia noa men, ba tsonun tölo te tukuna. Ba pala ti redi e tasu gono mer a tsonun tölo tara kannouna tara hitöl, ba tamana e pilier. ");
INSERT INTO hla_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ba i murimuri ba palair u tohaliou u kukubei e la pouts rima me poier, ‘O tsunono, o tsunono, kalats a tamana ba lam te tasu mou.’ ");
INSERT INTO hla_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kaba a tsonun tölo e ranga palisima me poiena, ‘Alia e ma haniga ragi limiu.’” ");
INSERT INTO hla_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Be Iesu e poiena, “Alimiu go hanei tala iam, taraha alimiu e ma atei silemi u lan tsi a aua te butu nama romana a Tsunono i tamilimiu.” ");
INSERT INTO hla_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Be Iesu e poieto, “A Nipepeito tere Sunahan e here hase nei romana a katun te katsin la ba nena a han i tanen ba te his uana i lehana. Ba nonei e ngö gugono rena u tson pepeitokap i tanen me hataratara kap rane ien a mamana ka i tanen. ");
INSERT INTO hla_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ba nonei e mar hala toa toa hapopo mera neien a moni turu nikukuin hantuna i taren a man toa toa. Nonei e halei a toa katun a tolima talen, a mar moni teka te karasana tara 5,000 kina. Ba nonei e hala nei a tai a huol a talen moni, na tai i halei a toa talen. Ba nonei e la uato tara tou lala i tanen. ");
INSERT INTO hla_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ba tson pepeitokap te lui u tolima u talen moni e lato me na hakui nena a moni teka ba nonei e lueto u tana u tolima u talen. ");
INSERT INTO hla_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na tara toa has a markato ba tson pepeitokap te lui u huol u talen moni e na lueto u taina u huol u talen. ");
INSERT INTO hla_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ba tson pepeitokap te lui u toa u talen moni e lato, me na kaho hamous nena a moni tara katun pan i tanen. ");
INSERT INTO hla_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Bi murina a poata a lehana, ba katun pan turu tson pepeitokap teka e la pouts mato me mi tanian ase gono mera neien u moni. ");
INSERT INTO hla_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ba tson pepeitokap te lui u tolima u talen e la mato me mi hala nena a moni i tanen me hala gono mene ien u tana u tolima u talen i tanen me poiena, ‘O tsunono, alö u halei lia u tolima u talen i tamulö. Ruto! U tana u tolima u talen has teka tu lui lia.’ ");
INSERT INTO hla_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ba katun pan i tanen e poieto, ‘E niga nitoana, alö a tson pepeitokap hamana na lö u kato hanigei a toukui i tamulö. Alö u tara kap haniga korun a tsi ka a tsi tetenei, na lia e hake gia lö tara tou taratara kap tara man ka man kapan. Mi lu talei a makum a niga i tamulö, ba ra te sasala hobotora!’ ");
INSERT INTO hla_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ba tana tson pepeitokap ti halei u huol u talen e la mato me poiena, ‘O tsunono, alö u halei lia u huol u talen i tamulö. Ruto! U tana u huol u talen has tu lui lia teka.’ ");
INSERT INTO hla_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ba katun pan i tanen e poieto, ‘E niga nitoana, alö a tson pepeitokap hamana na lö u kato hanigei a toukui i tamulö. Alö u tara kap haniga korun a tsi ka a tsi tetenei, na lia e hake gia lö tara tou taratarakap tara man ka man kapan. Mi lu talei a makum a niga i tamulö, ba ra te sasala hobotora!’ ");
INSERT INTO hla_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ba tson pepeitokap te lui u toa u talen e la mato me poiena, ‘O tsunono, alia e atei silegu alö a katunun hakhakui hatagala. Alö e ma kuimi, kaba lö e roron lu noa hasem a hihol tara toukui tara tana katun. ");
INSERT INTO hla_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Alia u matout ba lia e na hamouse gia a moni i tamulö turu tsiktsiki. Ruto! A moni i tamulö i teka.’ ");
INSERT INTO hla_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ba katun pan i tanen e poieto, ‘Alö a tson pepeitokap a omi na karous! Alö e poiem alia e ma kuigi kaba lia e roron luegu a hihol tara toukui tara tana katun? ");
INSERT INTO hla_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ga lö go mala hakeia a moni i tar tara beng, ba lia te tatei lu pouts gono megien ta taina ta moni tara poata te go kopis pouts malia.’ ");
INSERT INTO hla_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ba nonei e poieto tara palair u katunun kui i tanen, ‘Lu ba nemi a moni ba te halemi a katun te ka mena u maloto u talen moni. ");
INSERT INTO hla_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Taraha, a katun te ka mena a huhua tara toukui i tanen e hala hase roi a maroro te ga kui meni a huhua lel, ba nonei te ka mena romana a man ka man para. Kaba katun te moa ta huhua tara toukui i tanen e lu ba neroi a ma tsi ka pinopino noa has te ka menen. ");
INSERT INTO hla_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ba tson pepeitokap a omi teka e go tsuga mena milimiu i ielesala turu kuhil. Tara makum teka te tabe hohomi koru ria romana u katun ba te har tun hasir.’” E Iesu e ranga u teka. ");
INSERT INTO hla_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Be Iesu e poe lelena, “Alia tu butun katunuma e la guma romana ba te heregi a king, bu angelo hoboto e la gono has meri mou romana lia. Na nonei a poata teka, alia e gum goa romana turu gumgum u goagono i tar. ");
INSERT INTO hla_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bu pal katun hoboto e gono hoboto ria romana i matar. Ba lia te lu kakata ragen romana te kato uana a katunun taratarakap te lu kakata rena u sipsip nu meme. ");
INSERT INTO hla_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ba lia te haka ragia romana u sipsip tara pal matou i tar nu meme tara pal keruka i tar. ");
INSERT INTO hla_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ba lia te poiegu romana tara barebana tara pal matou i tar, ‘A barebana te kato hasasala rena e Tamar, la muma ba limiu te mi lue mou a Nipepeito te kato hamatskö beri limiu i iomin noa te habutia e Sunahan a mamana ka. ");
INSERT INTO hla_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Taraha, alia u bes ba limiu e hale milia a tsi kannou. Na lia u maka has ba limiu e haue molia. Na lia a katununa tara tana han ba limiu e las mena milia i luma i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Alia u moa tu hasobu ba limiu e hale moi lia u hasobu. Alia u ka mei a nimate ba limiu e taguhe molia. Alia u kaia tara karabus ba limiu e mi tare molia.’ ");
INSERT INTO hla_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ba barebana te matskör e poier romana i tar, ‘O Tsunono, i hangisa tu tareia lam tu bes u lö ba lam e hale moi lö a tsi kannou? I hangisa tu tareia lam tu maka u lö ba lam e haue molö? ");
INSERT INTO hla_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tara saha poata tu tareia lam alö a katununa tara tana han ba lam e las mena milö i luma i tamulam? Tara saha poata tu tareia lam alö u moa tu hasobu ba lam e hale moi lö u hasobu? ");
INSERT INTO hla_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","I hangisa tu tareia lam tu ka meni lö a nimate tsi tu kaia lö tara karabus ba lam e na tare molö?’ ");
INSERT INTO hla_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ba lia te ranga palis uagu romana i taren ba te poiegu, ‘Alia e hatei hamana rago limiu, a poata tu katoe mia limiu a ka teka tara toa tara man hahatoulana i tar te katun papala koruna, alimiu u heremi u katobe hase mien lia.’ ");
INSERT INTO hla_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ba lia te poiegu romana tara barebana tara pal keruka i tar, ‘A barebana te ranga hamalir e Sunahan, la ba nemo lia ba limiu te la uamiu turu tula te ka nitoana, ti kato hahaloso bei e Satan nu angelo i tanen. ");
INSERT INTO hla_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Taraha, alia u bes ba limiu e ma hale milia ta tsi kannou. Na lia u maka has ba limiu e ma haue milia ta tsi ramun. ");
INSERT INTO hla_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na lia a katununa tara tana han, kaba limiu u ma las mena milia i luma i tamilimiu. Alia u moa tu hasobu ba limiu e ma hale milia tu hasobu. Alia u ka mei a nimate na lia u ka hasia tara karabus, kaba limiu u ma na tare milia.’ ");
INSERT INTO hla_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ba nori has te poe uaser romana i tar, ‘O Tsunono, i hangisa tu tareia lam tu bes u lö na tu maka u lö na tu katununa u lö tara tana han ba lam e ma taguhe moi lö? Tara saha poata tu tareia lam tu moa meni lö tu hasobu na tu ka meni lö a nimate na tu kaia lö tara karabus ba lam e ma taguhu hase moi lö?’ ");
INSERT INTO hla_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ba lia te ranga palis uagu romana i taren ba te poiegu, ‘Alia e hatei hamana rago limiu, a poata tu raman katoe mia limiu a ka teka tara toa tara man hahatoulana i tar te katun papala koruna, alimiu u heremi u raman katobe hase mien lia.’ ");
INSERT INTO hla_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","E kato uana teka bu katun teka te na lue riou romana a nihahuna te ka nitoana, bu katun u matskö te na lue riou romana a nitoatoa te ka nitoana.” ");
INSERT INTO hla_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","A poata te hihatuts hakapa nia e Iesu a man ka teka, ba nonei e poiena turu katunun tsitsilo i tanen, “Alimiu e ateimiu, u huol u lan patu ba kannouna turu Paska* turu Jiu te katoer. Ba lia tu butun katunuma e na hala naroa turu katun te na tapala naria romana lia tara koruse.” ");
INSERT INTO hla_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Bu pris pan nu pal kapan turu Jiu e gono hoboto ria tara luma a kapan tere Kaiapas, a tsunono pan turu pris.* ");
INSERT INTO hla_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ba nori e korupakö ner te gi pile kap hamous meni e Iesu ba te atung hamate ren. ");
INSERT INTO hla_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ba nori e poier, “Ara e ma tatei katoe reien tara poata tara kannou, taraha u katun e namos hiagetagetar.” ");
INSERT INTO hla_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","E Iesu e kaia i Betani tara luma tere Saimon te ka mam mei a toba ba te niga poutsuna. ");
INSERT INTO hla_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ba toa tahol e la uamato tere Iesu te ka mei a tsi botolo tsikitsiki a tsi niga te ka mei u uapi u soksoka te hol sei koru. Ba nonei e kis nena u uapi i bakune Iesu tara poata te nou ien. ");
INSERT INTO hla_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bu katunun tsitsilo i tareto a ka teka me raharahar me poier, “Aha te kato baba sileri a ka teka? ");
INSERT INTO hla_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Sanena u uapi teka e gi haholin, sane lueri ta moni ta para ba te hala rari u katun ti moa ta moni!” ");
INSERT INTO hla_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","E Iesu e atei sil aha ti ranga nen me poiena i taren, “Aha te ngena sile milimiu a tahol teka? Nonei e katoe lala a ka a niga koru i tar. ");
INSERT INTO hla_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","U katun te moar ta moni e ka gono nitoa mera rio limiu. Kaba lia e ma tatei ka gono nitoa mera goi limiu. ");
INSERT INTO hla_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nonei e kis nelala u uapi i tuanreir i mam tara poata te gi na kaho meni lia. ");
INSERT INTO hla_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na limiu go hakhakats niam a ka teka! Tara mamana han hoboto i puta te na hihatuts neria romana u Bulungana u Niga, nori e na hihatuts nariou a ka a niga te katoe lala a tahol teka, ba barebana te hakats sile ren romana.” ");
INSERT INTO hla_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Ba toa i tamulam turu 12 u katunun tsitsilo, a solonen e Judas Iskeriot, e la u turu pris pan ti korupakön e Iesu me poiena, “Aha te hale moi limiu alia ba lia te haruto ragoi limiu e Iesu?” Ba nori e hale rien u 30 u moni u silva.* ");
INSERT INTO hla_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ba tara poata teka, nonei e hatanian sakiena ta maroro te go haruto menien e Iesu turu katun teka. ");
INSERT INTO hla_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Turu lan tutun tara kannou te noue ria u beret te moa ta yis,* bu katunun tsitsilo i la uamato tere Iesu me rangatse ren, “Alö e ngilem alam go la u ime ba te na kato hamatskö bemoi lö a kannouna turu Paska?” ");
INSERT INTO hla_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ba nonei e poiena, “Alimiu go la uam tara toa tson te kana tara taun teka ba limiu te na hateie men, ‘A Tson Hihatuts e poe nama, A poata i tar e sukusukuna. Alam nu katunun tsitsilo i tar e na noue moa a kannouna turu Paska i luma i tamulö.’” ");
INSERT INTO hla_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bu katunun tsitsilo e kato uar te ranga mera meien e Iesu ba te na kato hamatskö mamer a kannouna turu Paska. ");
INSERT INTO hla_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","A ka e lahibong hakapa be Iesu na 12 a katunun tsitsilo i gum hobotota te gi nou uen. ");
INSERT INTO hla_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tara poata ti nou ien be Iesu e poiena, “Alia e hatei hamana rago limiu, a toa i tamilimiu e haruto nenoa lia turu katun ti korupakö nio lia.” ");
INSERT INTO hla_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bu katunun tsitsilo e toku koru talar me rangata uase ren, “O Tsunono, esi? Alia romana?” ");
INSERT INTO hla_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Be Iesu e ranga palisito me poiena, “A toa i tamilimiu te kana gono menei lia a beret tara toa pelet, nonei e na haruto nenoa lia turu katun ti korupakö nio lia. ");
INSERT INTO hla_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Alia tu butun katunuma e mar mate uagou te ranga u u Buk u Goagono. Kaba a niomi pan e butuna romana tara katun nonei te haruto neno lia turu katun ti korupakö nio lia. Sanena ti ma posei nonei a katun teka, sane nigana i tanen.” ");
INSERT INTO hla_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Be Judas nonei a katun te haruto nenoen e poiena, “O Tsunono, esi? Alia romana?” Be Iesu e poiena i tanen, “Alö talasi te rangam.” ");
INSERT INTO hla_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tara poata ti nou ien be Iesu e lueto a beret me hanigana tere Sunahan me poseposie nen me hala nanen turu katunun tsitsilo. Ba nonei e poiena, “Lu tale iam ba limiu te noumiu. Nonei u tuanrei i tar teka.” ");
INSERT INTO hla_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ba nonei e lueto a gotana wain me hanigana tere Sunahan me hala rane ien. Ba nonei e poiena, “Alimiu hoboto go ua mia tara gotana teka. ");
INSERT INTO hla_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Taraha, nonei u rahatsing i tar teka te kato hatagalena u rangan kits u tsimus tere Sunahan na te takis bera nou u katun u para ba te lu ba bera neien u markato u omi. ");
INSERT INTO hla_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ba lia te hatei ragoi limiu, alia e ma tatei ua lele goi romana u wain teka antunana tara poata te na ua gono mera gia lia limiu u wain u tsimus tara Nipepeito tere Tamar.” ");
INSERT INTO hla_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ba poata ti köme ien u toa u köman lotu, ba nori e la uar turu Pokus tara Roein Olip. ");
INSERT INTO hla_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Be Iesu e poieto i taren, “Alimiu hoboto e matout mou ba te la ba nemo lia nonei noa has tara bong teka. Taraha, e Sunahan e mar ranga u teka turu Buk u Goagono: ‘Alia e atung hamate gou romana a katunun taratarakap ba heis sipsip te bus satar romana.’ ");
INSERT INTO hla_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kaba i murina te hatakei poutse noa romana e Sunahan alia tara tou mate i tar, ba lia te mam rago limiu i Galili.” ");
INSERT INTO hla_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Be Pita e ranga hateina me poiena i tanen, “U katun hoboto teka e la ba toum nario lö, kaba e moa koru te go la ba meni romana lia alö!” ");
INSERT INTO hla_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Be Iesu e poieto tere Pita, “Alia e hatei hamane golö, i mam te kekeretskö noa a keriau a tson i bong teka, ba lö te holis namou te go atei sil meni lö alia tara topisa poata.” ");
INSERT INTO hla_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Be Pita e poieto i tanen, “Alia e moa koru te go holis meni romana lö, noahasina te mate gono megoa lia alö.” Bu katunun tsitsilo hoboto i mar ranga has uato i iesana. ");
INSERT INTO hla_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Be Iesu e la gono mera nen tara toa makum te ngöeri Getsemani, ba nonei e poiena i taren, “Gum bumia teka tara poata te la uagu lia ili ba te na singo uagu tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ba nonei e la merena e Pita na elasolana pien tson tere Sebedi, ba torinen e tanian asingotona me toku hapanina. ");
INSERT INTO hla_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ba nonei e poiena i taren, “A peisar e tiama koru mena a nitatagi pan. Kaka mia teka ba limiu te taratara kap gono memo lia.” ");
INSERT INTO hla_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ba nonei e gamon la lelina me tuhalakopo nena turu tsiktsiki me singona, “O Tamar, te go antuna u lö, ba lö te hatongo kap ba nemoi lia a kamits teka te katsin butuna i tar. Kaba alö go ma kato uai turu ngil i tar. Alö go kato u turu ngil i tamulö.” ");
INSERT INTO hla_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ba nonei e la pouts uana tara elapisa katunun tsitsilo me sabe ranen ba nori te sohor. Ba nonei e poieto i taren, “Pua! Alimiu e ma antunami te go kalata uam tara toa aua puku? ");
INSERT INTO hla_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tara kap iam ba te singo uamiu tere Sunahan. U hiamus u omi e namos butuna i tamilimiu. A namnamei i tamilimiu e ngilin katoena a ka teka, kaba u tuanrei i tamilimiu e ma tagala nei.” ");
INSERT INTO hla_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Be Iesu e la hahuol lelina me na singo uana tere Sunahan me poiena, “O Tamar, te ma antunan hatongo kap namoia lö a kamits teka na te go sagoho koru menien lia, ba lö te kato uam turu ngil i tamulö.” ");
INSERT INTO hla_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ba nonei e la pouts uato turu katunun tsitsilo me sabe ranen ba nori te sohor, taraha nori i topi koru. ");
INSERT INTO hla_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Be Iesu e la lel ba ranen me na singo hatopisa uana tere Sunahan turu toa puku u mar singo. ");
INSERT INTO hla_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ba nonei e la pouts uato turu katunun tsitsilo me poiena i taren, “Alimiu e soho noamiu ne husa noamiu? Hengo iam! A poata e butu hakapa. Alia tu butun katunuma e hala tala naria tara nitagala turu katun u omi. ");
INSERT INTO hla_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Takei iam, ba ra te lara. Ruto iam, a katun te haruto nano lia turu katun ti korupakö nio lia e tuku hakapa.” ");
INSERT INTO hla_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","E Iesu e ranga noa, be Judas, a toa i tamulam turu 12 u katunun tsitsilo, e tukuto. Ba nonei e peigi remato u katun u para koru ti soatsema a man kilatan hiatatung na man baru. U pris pan turu lotu nu pal kapan turu Jiu ti hala ramen. ");
INSERT INTO hla_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na katun te haruto nanou e Iesu e hopu kap mamin a ka te mi katoe noen. Nonei te hatei hakapa mamir u katun te ga peigi ramen romana me poiena, “A katun te mutsi nagoa lia i abuabunen, nonei a katun te ngilin lu nami limiu. Pile kap niam!” ");
INSERT INTO hla_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Be Judas e tuku hakapato me la uana tere Iesu me poiena, “A tsi bong, o Tson Hihatuts.” Be Judas e mutsi nanen i abuabunen. ");
INSERT INTO hla_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Be Iesu e poiena i tanen, “E gu hahikapien, alö go kato sapsap a ka te la sile muma lö.” Ba nori e mi pile hakarapoto naren. ");
INSERT INTO hla_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ba toa turu katun ti ka gono mei e Iesu e hasoana me lousena u kilatan hiatatung i tanen me katsin atungena a katunun kukui puku tara tsunono pan turu pris ba nonei e ngats ba nena a talinganen. ");
INSERT INTO hla_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Be Iesu e poiena i tanen, “Haka poutsi u kilatan hiatatung i tamulö tara makum i tanen. Taraha, a katun te luena a kilatan hiatatung e atung hamate roi romana u kilatan hiatatung. ");
INSERT INTO hla_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Alia e hateie golö, te go ngil u lia ba lia te ngöegu e Tamar ba i teka puku ba nonei te hala nenama a pal angelo pan a para te takarasa ria tara 12 a ami te gi mi taguhio lia. ");
INSERT INTO hla_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kaba te go kato u lia teka ba ime te tatei mana halona uana u Buk u Goagono? Taraha, u Buk u Goagono e poiena nonei e ga mar butu u teka.” ");
INSERT INTO hla_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Be Iesu e poieto tara pal barebana, “Alimiu e la memuma a man kilatan hiatatung na man baru te go mi pile kap mena milia ba limiu te poemiu alia e heregi a kopkop. Taraha? Turu mamanu lan alia u kaia i Luman Lotu Pan ba te hihatutsugu, ba limiu te ma pile kap nami lia. ");
INSERT INTO hla_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kaba mamana ka hoboto teka e butu silena te go hamana meni a ka ti koloto mamin u propet turu Buk u Goagono.” Ba lam u katunun tsitsilo hoboto u la ba neten me busum. ");
INSERT INTO hla_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bu katun teka ti pile kapin e Iesu e na piou narien tere Kaiapas a tsunono pan turu pris ti gono hobotoia u tson hihatuts turu Lo tere Moses na pal kapan. ");
INSERT INTO hla_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Be Pita e murimuri halehanana tere Iesu me noana tara luma tara tsunono pan turu pris, ba te na kana i pal porina luma i iahana ololo te hahisin a luma. Ba nonei e gum gono merena u tson pepeitokap te go tara kap menien a saha ka te go butu. ");
INSERT INTO hla_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bu pris pan nu katun hoboto ti kaia turu Kot Pan e sakier ta elasolana ta katun te gi kot mei e Iesu tu toa tu mar ranga tu gamo te gi kato hamate menien. ");
INSERT INTO hla_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","U katun u para i la uama i mam me gamo neren, kaba a pal kapan i ma sabei ta elasolana te gi boei tu toa. Ba elasolana katun e la uarima i mam me poier, “A katun teka e poei, ‘Alia e antunagu te go tuba meni a luma tere Sunahan ba te hatakei poutse gen turu topisa u lan.’” ");
INSERT INTO hla_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ba tsunono pan turu pris e tuoluna me poiena tere Iesu, “Alö e ma ranga palismi? Gaha nonei te kot meri u katun teka alö?” ");
INSERT INTO hla_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kaba e Iesu e kokomoto. Ba nonei a tsunono e ranga lelina i tanen me poiena, “Alia e rangate gia lö i matana e Sunahan, alö go hatei ramei lam, alö e Mesaia, a Pien Tson tere Sunahan?” ");
INSERT INTO hla_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Be Iesu e poiena i tanen, “Alö talasi te rangam. Na lia e hatei rago limiu, i murina a poata teka ba limiu te tare mou romana alia tu butun katunuma te gum goa tara pal matou tere Sunahan a tagala koru, ba lia te la guma romana turu koasi i kolö.” ");
INSERT INTO hla_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ba tsunono pan turu pris e raharaha koruto me kise iena u hasobu i tanen me poiena, “Nonei e katoe lala u ranga u omi koru me poiena e ka mena a nitsunono tere Sunahan. Ara e ma tatei ngö lele rimei ta katun te ga kot gono meien, bokam? Alimiu e hengo tale mula u ranga u omi i tanen. ");
INSERT INTO hla_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Alimiu e poemiu aha?” Ba nori e ranga palisir me poier, “Nonei e gi atung hamati!” ");
INSERT INTO hla_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Ba nori e kahus ria i polenen me muke ren. Ba palai e tapale ren me poier, “Bara! Te go Mesaia u lö, ba lö te kato uam te kato uana a propet. Poa talei esi te muke lalo lö.” ");
INSERT INTO hla_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","E Pita e gumia i ielesala i pal pori. Ba toa taholun kui e la uamato i tanen me poiena, “Alö has tu ka gono mei e Iesu a toun Galili.” ");
INSERT INTO hla_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Be Pita e holisna i matana katun hoboto me poiena, “Alia e ma atei silegi a ka te ranga nemu lö.” ");
INSERT INTO hla_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ba poata te lakasa ien ba te na kana i rehina tamana tara ololo, ba tana taholun kui e tare nen me poiena turu katun ti tuolia i sukusuku, “A katun teka e ka gono mei e Iesu a toun Nasaret.” ");
INSERT INTO hla_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Be Pita e holis lelina me poiena, “U mana koru ni iasa, alia e ma atei silegi a katun teka.” ");
INSERT INTO hla_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","E ma manasai bu katun ti tuolia i sukusuku i la uamato tere Pita me poier, “Alö koru has a toa katun tere Iesu, taraha u ranga i tamulö e haruto nena tu la malö.” ");
INSERT INTO hla_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Be Pita e toan hamal neto a peisanen me poiena, “E Sunahan e tatei hahune nolia te go ma ranga hamana uai lia. Alia e ma atei silegi a katun teka!” Ba toa keriau a tson e kekeretsköna. ");
INSERT INTO hla_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Be Pita e hakats pouts neto u ranga te hateien e Iesu te kato u, “I mam te kekeretskö noa a keriau a tson ba lö te holis hatopisa namou te go atei sil meni lö alia.” Ba nonei e lakasana me na tabe mena a nitatagi pan koru. ");
INSERT INTO hla_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na tara bongbong koru bu pris pan na pal kapan hoboto has turu Jiu i hagum hobotota te gi korupakö menien e Iesu. ");
INSERT INTO hla_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ba nori e kitse rien a tsien ba te la meren me na hala narien tere Pailat a Gamman. ");
INSERT INTO hla_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","E Judas, a katun te hala meni e Iesu turu katun ti paköe ien, nonei e tara sabe ti hopu kap hamanasa menien te ga mate u e Iesu. Ba nonei e palisena u hakhakats i tanen me lu pouts mena nei u 30 u moni silva turu pris pan na tara pal kapan turu Jiu. ");
INSERT INTO hla_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ba nonei e poiena, “Alia u kato homi me hala tsipon ragi limiu a katun te moa ta ka ta omi i tanen ba nonei te na mate nou!” Ba nori e poier, “E ma ka uanei i tamulam. A nitoku peisa i tamulö.” ");
INSERT INTO hla_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Be Judas e na lapo ba nena a moni tara Luman Lotu Pan me lana, ba nonei e na haliona. ");
INSERT INTO hla_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bu pris pan e luer a moni me poier, “A moni teka a hihol te kato hamate meri a katun. U Lo i tarara e hapiu nena te gi ma haka menien tara makum tara moni i Luman Lotu Pan.” ");
INSERT INTO hla_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ba nori i hagumuto me kitser u ranga, ba nori e holeri a moni teka a makumun tsikitsiki ti kukuiei a tabeli, te gi kaho meri u katunur turu han i lehana. ");
INSERT INTO hla_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nonei te ngö beri a makum teka, “U Tsikitsiki turu Rahatsing” tara poata i romana. ");
INSERT INTO hla_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Nu ranga tara propet e Jeremaia ni manasa e butu hamana tala te poien, “Nori i lu u 30 u moni silva, a hihol ti haka meni a palair u Jiu tara katun teka, ba nori te hole rien a makum te kukuie ria a tabeli, te mar ranga meni a Tsunono alia.” ");
INSERT INTO hla_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Be Iesu e tuolna i matane Pailat a Gamman be Pailat e rangatse nen, “Alö a King turu Jiu?” Be Iesu e ranga palisito, “Alö a tuam ba te rangam.” ");
INSERT INTO hla_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kaba nonei e ma ranga palisni u ranga ti kot meien u pris pan na pal kapan. ");
INSERT INTO hla_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Be Pailat e poieto i tanen, “Alö e ma hengoemi u mamanu ranga te kot meri u katun teka alö?” ");
INSERT INTO hla_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kaba e Iesu e raman te ga ranga palis meni ta tsi toa ta tsi ranga, be Gamman e hakats hapan koruna. ");
INSERT INTO hla_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Turu mamanu hiningal tara poata tara kannouna turu Paska, e Pailat e roron puresir a man toa man karabus ti ranga sil u katun ");
INSERT INTO hla_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na tara poata teka a toa katun a omi e kaia tara karabus ti atei sil a barebana, a solonen e Barabas. ");
INSERT INTO hla_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ba tara poata ti gonogonoia u katun, be Pailat e rangata ranen, “Esi te ngile milimiu te go hapurese beri lia limiu tara karabus, e Barabas tsi e Iesu te ngöeri e Kristo?” ");
INSERT INTO hla_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nonei e atei sil ti hala menien e Iesu i tanen taraha nori i hiomi. ");
INSERT INTO hla_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tara poata te gum noaia e Pailat turu kot, ba tahol i tanen e hale neien u raranga me poiena, “Alö go ma katoei ta ka tara katun teka. E moa ta ka ta omi i tanen. Alia e tare gulen turu sinasoho i tar i bong ba lia e ka miegu a nitoku pan koru.” ");
INSERT INTO hla_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bu pris pan na pal kapan turu Jiu i las hatagala u hakats turu katun ba te kitser u ranga te gi rangata meni e Pailat ba te hapuresiena e Barabas tara karabus ba te hala menari e Iesu tara tou mate. ");
INSERT INTO hla_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Be Gamman e rangata lel ranen, “Esi tara elasolana katun teka te ngile milimiu te gi hapuresi?” Ba nori i poieto, “E Barabas!” ");
INSERT INTO hla_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Gaha te katoe goa lia tere Iesu te ngöeri e Kristo?” E Pailat e mar rangata u teka i taren. Ba nori hoboto i poieto, “Tapala namia tara koruse!” ");
INSERT INTO hla_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Be Pailat e poiena, “Tara neha? A saha ka omi te katoe ien?” Ba nori e hatanian ku sei hobotor, “Tapala namia tara koruse!” ");
INSERT INTO hla_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Be Pailat e toan atei sileto u ranga i tanen e ma antunai, bu barebana e tanian hiagetagetar. Ba nonei e luena u ramun me galusena a limanen i matar u katun hoboto, me poiena, “Alia u moa ta ka ta omi te go ha-atung hamate meni a katun teka! A ka peisa i tamilimiu.” ");
INSERT INTO hla_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bu katun hoboto e hatangana hobotor me poier, “A nihahuna tara tou mate i tanen e tatei la uana i tamulam na tara galapien i tamulam!” ");
INSERT INTO hla_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Be Pailat e purese bera neien e Barabas tara karabus. Ba nonei e halahus nena e Iesu me hala mena neien i taren te gi na tapala menien tara koruse. ");
INSERT INTO hla_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Bu soldia tere Pailat e lu menari e Iesu tara luma tere Gamman, bu soldia hoboto e mi gono hahise ren. ");
INSERT INTO hla_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ba nori e hiser u hasobu i tanen me haseie rien u hasobu u ngahangaha u miamia te tara herei u hasobu tara king. ");
INSERT INTO hla_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ba nori e hil haperperere ier a kolits a hihitoka me hasoge ria i bakune Iesu, ba nori e hapile rien a tsi roei i limanen tara pal matou. Ba nori e hatukun ria i matanen me hahakos sile ren me poier, “Solo sei iam a King turu Jiu!” ");
INSERT INTO hla_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ba nori e kahuse ren, me luer a tsi roei i tanen me singata narien i bakunen. ");
INSERT INTO hla_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Poata ti hakakos sil hakape ien e Iesu, ba nori e his ba ner u hasobu u miamia ba nori e hasogo poutse rien u hasobu i tanen, me lakasa meren te gi na tapala menien tara koruse. ");
INSERT INTO hla_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tara poata ti la ien, ba nori e tupaler a toa tsonuna i Sairini, a solonen e Saimon. Ba nori e hatöe rien a koruse tere Iesu. ");
INSERT INTO hla_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ba nori e na butu ria tara makum te ngöeri u Golgota, te poiena “A makum turu lakö”. ");
INSERT INTO hla_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tara makum teka ti katsin haue ien u wain ti sohale ien u meresin u mal koru te ga kato hatetenei a kamits. Ba nonei e ua torohane ten, kaba nonei e raman ua neien. ");
INSERT INTO hla_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ba nori e tapala narien tara koruse, me satu siler a man makumun hasobu i tanen. ");
INSERT INTO hla_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ba nori e gumur me peitoe ren. ");
INSERT INTO hla_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ba i iasa tara bakunen nori i hopun u ranga ti kot meien e Iesu te poiena “A katun teka e Iesu, a King turu Jiu.” ");
INSERT INTO hla_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ba nori e tapala has naria a elasolana katun a kopkop tara man koruse i rehina e Iesu, a toa tara pal matou na tai tara pal keruka. ");
INSERT INTO hla_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Bu katun ti hula laia i matanen e ranga sesei ria tere Iesu me tsibtsibil ner a bakuren me poier, “Alö a katun te tatei rure iem a Luman Lotu Pan ba te kui poutse men turu topisa u lan, taguhi a peisa mulö! Te go Pien Tson u lö tere Sunahan, bara, koul talama tara koruse!” ");
INSERT INTO hla_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","Bu pris pan nu tson hihatuts turu Lo nu pal kapan i mar kato has uato i iesana ti ranga sesei uen me poier, “Nonei e haka hanigeir a palair u katun, kaba e ma tatei haka haniga tsipone nei a peisanen! Nonei a Kingina i Israel, tsime? Ga nonei e ga koul ba tala nema a koruse ba ra te hamane ren! ");
INSERT INTO hla_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nonei e hamanana tere Sunahan ba nonei te poiena nonei a Pien tere Sunahan. Bara, ruto iam te go ngilin haka haniga menien e Sunahan!” ");
INSERT INTO hla_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bu katun u kopkop ti tapala gono meien e mar ranga sesei has uar i iesana tere Iesu. ");
INSERT INTO hla_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ba tara gusuna soasa ba han hoboto e kopo hobotena u kuhil, me antoe iena a topisa aua. ");
INSERT INTO hla_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ba tara pal 3 kilok be Iesu e ku hapanina me poiena, “Eli, Eli, lama sabaktani?” E poiena, “O Sunahan i tar, Sunahan i tar, aha te la ba sile mulei lö alia?” ");
INSERT INTO hla_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ba palair u katun ti tuolia i susuku i hengoto me poier, “A katun teka e ngöe iena e Ilaitsa!” ");
INSERT INTO hla_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ba toa i taren e piata boroborona, me haputue nei u magmagolo u wain u melil, me hakeie nen i runguna a tsi roei, me hasoa nanen tere Iesu te go ua uen. ");
INSERT INTO hla_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ba palai e poier, “Aloso bum, ba ra te tarera te ga la uama e Ilaitsa ba te mi taguhe nen!” ");
INSERT INTO hla_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Be Iesu e ku hapan lelina, ba nonei e hala ba nena u namnamei i tanen me matena. ");
INSERT INTO hla_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Bu labalaba pan te kuteia i Luman Lotu Pan e takis katato i iasa me la nitoana i puta.* Bu tsikitsiki e tagasina, bu hatu e tapose kakatana. ");
INSERT INTO hla_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Bu kioun mate e taposena me kalatana, ba para a katun tere Sunahan ti mate i takeito me toatoa poutsur. ");
INSERT INTO hla_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bi murina te takei poutsia e Iesu tara tou mate i tanen, ba nori i la ba neto u kiou me la uar i Jerusalem, ba te butu ria turu katun u para. ");
INSERT INTO hla_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ba tsunono tara hun soldia nu soldia i tanen ti pepeito kapin e Iesu i tareto a nun na mamana ka te butu, ba nori e matout korur me poier, “U mana koru nonei a Pien Tson hamana tere Sunahan!” ");
INSERT INTO hla_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A tahol a para i ka me ruruto rima i lehana, a tohaliou ti kukute mena mei e Iesu i Galili na ti taguhe ien. ");
INSERT INTO hla_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","I gusuren i kaia ere Maria Matalina ne Maria e tsinane Jemis ne Josep, na e tsinana a galapien tson tere Sebedi. ");
INSERT INTO hla_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tara lahi, ba toa katunun moni e la mato, a solonen e Josep. Nonei a katununa i Arimatia, na nonei has a toa katunun tsitsilo tere Iesu. ");
INSERT INTO hla_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ba nonei e la uato tere Pailat me na rangata silena u tuanrei tere Iesu. Be Pailat e haniga nena te gi hala meni a tuanreine Iesu tere Josep. ");
INSERT INTO hla_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Be Josep e lue ten, me pitse neien u labalaba u lamelame u tsimus. ");
INSERT INTO hla_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Me na hakeie nen tara kiou hamatskö i tanen te hakaho nien turu lapo. Ba nonei e hategele tupe nei a matana kiou a toa hatu pan me lana. ");
INSERT INTO hla_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Be Maria Matalina na taina Maria e gumur, me tara uar tara kiou. ");
INSERT INTO hla_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ba turu hamahö, turu Lan u Goagono, bu pris pan nu Parisi e lar mena gono ria tere Pailat. ");
INSERT INTO hla_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ba nori e poier, “O Tsunono, alam e hakats kap nem u ranga te kato nonei e Iesu a katun a gamogamo tara poata te toatoa noa ien. Nonei e poei, ‘I murina u topisa u lan ba lia te ");
INSERT INTO hla_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","E kato uana teka, ba lö te hala nem u raranga te gi taratara kap haniga meni a kioun mate e popona turu hatopisana u lan, bu katunun tsitsilo i tanen te ma tatei lari ba te na kope ren ba te poier turu katun, ‘Nonei e takei poutsia tara tou mate.’ Te gi kato uen romana teka bu gamo i taren te karase nou u gamo mam i tanen.” ");
INSERT INTO hla_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Be Pailat e poieto i taren, “Lu riam u soldia ba te na hataratara kap haniga nitoa remi a kiou.” ");
INSERT INTO hla_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ba nori e lar, me na harokoto kap ner a hatun pilpili te gi hagoagono meni a kiou, ba nori e haka rer a palair u soldia te gi taratara kap nen. ");
INSERT INTO hla_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","I murina te kapaia u Lan u Goagono, tara bongbong koru turu Sanrei, be Maria Matalina na taina Maria e lar te gi na tara meni a kioun mate. ");
INSERT INTO hla_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ba nun a tagala e songots gasina, taraha a angelo tara Tsunono e lama i Kolö me hategele ba nena a hatu, me gumna i ielunen. ");
INSERT INTO hla_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ba matanen e piri here nei u kanaha, nu hasobu i tanen e hiaka herei u koasi. ");
INSERT INTO hla_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bu soldia e matout korur ba nori e tololor me hereri u katun u mate. ");
INSERT INTO hla_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ba angelo e ranga mereto a tohaliou, “Alimiu e go ma tatei matoutmi. Alia e atei silegu alimiu e sakiemiu e Iesu ti tapala nia tara koruse. ");
INSERT INTO hla_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nonei e ma ka neia teka. Nonei e takei pouts, te mar ranga noa has uen. La buua muma teka ba te mi taremiu a makum te opu ien. ");
INSERT INTO hla_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ba limiu te la boroboro mula ba te na hatei ramiu u katunun tsitsilo i tanen, ‘Nonei e takei pouts hakpaia tara tou mate, na nonei e la mam rano limiu i Galili. E na tare moa limiu ili!’ Hakats niam a ka te ranga mera gulei lia alimiu.” ");
INSERT INTO hla_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ba nori e haseseir me la ba ner a kiou, me matoutur kaba i ka noa has mei a nisasala pan, me piatar ti na hatei meri u katunun tsitsilo i tanen. ");
INSERT INTO hla_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Be Iesu e sabe ranen i maroro me hatsomi ranen. Ba nori e mareie ren me la hasukusuku uarima i tanen, me pile ria i mounen me hatsunone ren. ");
INSERT INTO hla_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Ma matoutmi,” te mar ranga u e Iesu i taren. “La iam ba te na ranga meramiu a man hahatoulana i tar ba te la uar i Galili, ba nori te na tare roa lia ili.” ");
INSERT INTO hla_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tara poata ti la poutsia a tohaliou, bu palair u soldia i la pouts uato tara taun me na hahatei rari u pris pan a man ka hoboto te butu. ");
INSERT INTO hla_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Bu pris pan e gono merer u pal kapan me kitser u ranga. Ba nori e hala rari u soldia a pal moni pan me poier, “Alimiu e go na mar ranga uam teka tara barebana, ‘U katunun tsitsilo tere Iesu e la rima i bong me mi koper u tuanrei i tanen tara poata te soho mula lam.’ ");
INSERT INTO hla_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na te go hengo meni e Gamman a ka teka, alam e tatei hale mien tu raranga tu niga, ba limiu te moa mou tu raranga.” ");
INSERT INTO hla_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bu soldia e lue ier a moni me katoer a ka ti ranga merien te gi katoen. Na nonei u hahatei teka ti ranga hoboto nia u Jiu nonei tara poata ba te noana i romana. ");
INSERT INTO hla_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ba 11 a katunun tsitsilo i la uato turu pokus i Galili te ranga merien e Iesu te gi la uen. ");
INSERT INTO hla_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ba nori e tare ren me hatsunone ren, kaba palai i taren i hula hakats. ");
INSERT INTO hla_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Be Iesu e la hasukusuku nama i taren me poiena, “E Sunahan e halei lia a nitsunono hoboto ni Kolö na turu puta. ");
INSERT INTO hla_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","E kato uana teka, ba limiu te la uamiu turu hun katun hoboto tara mamana han ba te kato rami u katunun tsitsilo i tar. Ba limiu te baptais ramen tara solona e Tamar na tara solor, a Pien Tson i tanen, na tara solo turu Namnamei u Goagono i tanen. ");
INSERT INTO hla_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ba limiu te hatuts ramien te gi kukute menien a mamana ka tu ranga meri lia alimiu. Ba limiu te hakhakats nemiu a ka teka: alia e ka gono nitoa mera gou romana limiu, e noa hasina romana tara nikapakapana poata.” ");
INSERT INTO hla_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","U Bulungana u Niga tere Iesu Kristo a Pien Tson tere Sunahan e mar tania u teka: a propet tere Sunahan e Aisaia e kolotein u ranga i manasa me poiena, “E Sunahan e poiena, ‘Hengo iam. Alia e hala negu romana a katunun tatala i tar te ga mam nio lö, ba nonei te hamatsköena romana a maroro i tamulö. ");
INSERT INTO hla_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nonei e na ranga hapan noa romana tara latu pinopino ba te poiena, Kato hamatsköe iam u markato i tamilimiu, taraha a Tsunono e ngilin sila nama romana tara maroro a matskö.’” ");
INSERT INTO hla_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Na nonei a katun te hale iema e Sunahan nonei e Jon, a katun te baptaisir u barebana. Nonei e butuia i latu pinopino me habulunga nana me poiena, “Habirits ba niam u markato u omi i tamilimiu ba te habaptaismiu, be Sunahan te lu ba nenou u markato u omi i tamilimiu ba te tara pouts rano limiu.” ");
INSERT INTO hla_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ba barebana hoboto tara provins i Judia na tara taun i Jerusalem i na hengota tere Jon. Ba nori i poke ieto u markato u omi i taren ba nonei te baptais ranen tara ramun olo i Jodan. ");
INSERT INTO hla_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","E Jon e roron hasogi u hasobu ti kuiei a huluna kamel, ba te hapouse iena lete. Na nonei e roron noui a köno nu möröana. ");
INSERT INTO hla_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nonei e ranga u tara barebana me poiena, “A toa katun e murimuri nena molia te pan bala neno lia. Nonei a tsunono pan, na lia a katun papala koru. ");
INSERT INTO hla_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Alia e baptais ragi limiu u ramun tun, kaba nonei te na baptais ranoi romana limiu u Namnamei u Goagono.” ");
INSERT INTO hla_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nonei tara poata e Iesu e la ba nema a taun i Nasaret tara provins i Galili, be Jon e baptaise nen tara ramun olo i Jodan. ");
INSERT INTO hla_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Be Iesu e takei poutsuna turu ramun ba te tarena u Kolö te takalata, bu Namnamei tere Sunahan e koul uamato i tanen e here mei a kulu. ");
INSERT INTO hla_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bu toa u ranga e butu nama i Kolö me poiena, “Alö a Pien Tson a tsomi koru i tar. Alia e haniga korue golö.” ");
INSERT INTO hla_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Bu Namnamei tere Sunahan e hala boroboro mena neien tara latu pinopino. ");
INSERT INTO hla_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ba nonei e na ke iena u 40 u lan i latu pinopino te kaia a mamana ka a hie, be Satan e torohane ten. Bu angelo tere Sunahan e mi taguheto e Iesu. ");
INSERT INTO hla_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","I murina ti haka meni e Jon tara karabus, e Iesu e la uala i Galili me na rarare iena u Bulungana u Niga tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ba nonei e poiena, “A poata e sukusuku nama te pepeito kap ranoa e Sunahan a barebana. Palise iam u markato u omi i tamilimiu ba te hamanemiu u Bulungana u Niga.” ");
INSERT INTO hla_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","E Iesu e laia i kotolana tara Ramun a Perperere i Galili ba nonei e tara rena ere Saimon mere Endru u mun toulana ba te hagala ria i ramun, taraha nori u katunun hagala. Nori i holei a kannou i taren a iena. ");
INSERT INTO hla_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Be Iesu e poiena i taren, “La gono memu molia. Alimiu u roron sohe iam a iena tara abe, kaba lia e hatuts ragoi limiu te go ngö gugono mera milimiu u katun i tar.” ");
INSERT INTO hla_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ba nori e la ba hamanasa ner u abe i taren me la gono meren. ");
INSERT INTO hla_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ba nonei e gamon la lelina me tara rena ere Jemis mere Jon a hinpien tere Sebedi. Nori i kaia tara tsi tolala i taren ba te suge ier u abe i taren. ");
INSERT INTO hla_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ba nonei e ngö ranen e gi la gono meien. Ba nori e la ba hamanasa ner e tamaren e Sebedi ba te kana tara tsi tolala nu tsonun kui. Ba nori a elasolana e la gono mer e Iesu. ");
INSERT INTO hla_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nori i la u tara toa taun te ngöeri Kapeneam. Ba turu tana u Lan u Goagono turu Jiu, e Iesu e tasuia tara luman lotu me hatanian hihatutsina. ");
INSERT INTO hla_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ba barebana ti hengo ien i asingotota te mar hihatuts uen. Nonei e ma herei u tson hihatuts turu Lo, kaba nonei e hihatuts herei a katun te ka mei a nitsunono pan. ");
INSERT INTO hla_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Ba toa tson a sesein mate e butu hamanasana me ku homina me poiena, “O Iesu ni Nasaret. Alö banei go haka ba rio lam! Alö e mi katsin kato homi ramo lam! Alia e atei silegu alö a katun a goagono tere Sunahan!” ");
INSERT INTO hla_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Be Iesu e ranga sisi mieto a mate me poiena, “Kokomoto. Koul ba nema.” ");
INSERT INTO hla_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ba mate e gas hapanena a tson me ku hohomina me koul ba nanen. ");
INSERT INTO hla_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ba barebana hoboto i asingoto koruto me hiarangrangatar me poier, “Aha nonei reka? U mar hihatuts u tsimus? A katun teka e ka mena a nitagala te go ranga meien u mate u omi e gi koul ba nori te maniete ren!” ");
INSERT INTO hla_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Bu bulungana tere Iesu e la kalakala boroborona tara mamana han hoboto i Galili. ");
INSERT INTO hla_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nori i la ban a luman lotu me na tasur i luma tere Saimon mere Endru. Ne re Jemis mere Jon i la gono has meren. ");
INSERT INTO hla_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ba halis a tahol tere Saimon te opu mena a bakunen e hiski. Ba nori e hatei boroboro naren tere Iesu. ");
INSERT INTO hla_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Be Iesu e toan la uana i tanen me luena limanen me hatakeie nen. Bu hiski i bakunen e kapana ba nonei e na nasena kannou i taren. ");
INSERT INTO hla_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tara lahibong ba barebana e peigi rarima u katun ti ka mei u nimate nu katun ti seseir u mate u omi. ");
INSERT INTO hla_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bu katun hoboto tara taun teka e mi gonogono ria i matana luma. ");
INSERT INTO hla_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Be Iesu e kato haniga reiena u katun u para ti ka mei u mamana u mar nimate, me tsuga rena u mate u omi u para. Ba nonei e hakokomoto rena u mate, taraha nori i atei sile ien. ");
INSERT INTO hla_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tara lunlan koru e Iesu e takei me la uana tara toa makum a ski me na singo uana tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Be Saimon na palai i tanen i lato me na sakie ren. ");
INSERT INTO hla_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Poata ti sabie ien e Iesu ba nori e hateie ren, “U katun hoboto e sakie rio lö.” ");
INSERT INTO hla_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Be Iesu e ranga palisina, “Ara gi la u tara palabina u han te sukusukuna ba lia te na tatei rarare has goa turu han teka. Taraha, nonei a ka tu la sile malia.” ");
INSERT INTO hla_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ba nonei e la hobotona turu han i Galili ba te rararena turu luman lotu ba te tsuga ba has nena u mate u omi. ");
INSERT INTO hla_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","A toa katun a toba e la uama tere Iesu me hatukununa i matanen. Ba nonei e ranga hatatagina tere Iesu me poiena, “Alö go ngil ba lö te tatei kato hataie iem a toba i tar.” ");
INSERT INTO hla_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Be Iesu e tatagi koru nanen me hasoa nena a limanen me sebele nen. Be Iesu e poiena i tanen, “Aa, alia e ngiligu. Alö go niga pouts.” ");
INSERT INTO hla_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ba i teka puku ba toba te taia hakapana ba nonei te niga pouts talana. ");
INSERT INTO hla_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Be Iesu e ranga hatagala menen me poiena, “Hengo haniga. Alö go ma hateii ta toa ta katun. Alö go la hamatskö u tara pris ba nonei te na rutsena a peisamulö te niga pouts uanen. Ba lö te hale moien a kan hats te haruto nena a toba e kapa hamana, te ranga u e Moses i manasa, ba barebana te atei sile riou a toba i tamulö e kapa koru.” Be Iesu e ranga hakapana ba te hala borobore nen. ");
INSERT INTO hla_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kaba a tson teka e la me na habulungana nena a ka teka turu han hoboto. Be Iesu e ma antuna nei te go la u i iahana taun i matar u katun, taraha a barebana e namos gono beren. Kaba nonei e kaia tara man makum pinopino te moaia ta katun, bu barebanar tara mamana han hoboto e la uar i tanen. ");
INSERT INTO hla_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","I murina a palair u lan e Iesu e la pouts u i Kapeneam, ba barebana e hengoer te ka uen i han. ");
INSERT INTO hla_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","3","Bu katun u para e mi gonor ba luma e saputu koruto na i matana tamana e moa has ta makum te ga ski. E Iesu e hatei rien u ranga ba barebana e mi piou neto a katun a matekata. Ba elahats a katun e soatse rimen. ");
INSERT INTO hla_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","A makum e saputu tara katun ba nori a elahats a katun teka e ma antunari te gi soata menien i rehina e Iesu. Ba nori e na lu ba ner a toa makumun pungana tara luma i matina te kaia e Iesu.* Poata ti kato hakape ien a tabutu, ba nori e hakouler a katun te opuia tara poapoa. ");
INSERT INTO hla_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","I hakoul hakape ien i puta, be Iesu e atei talana te hamana uaren i tanen. Ba nonei e poiena tara katun a matekata, “A tsi pien, alia e lu ba negu u markato u omi i tamulö.” ");
INSERT INTO hla_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","U tson hihatuts turu Lo i ka has ba te hakhakats tunur me poier, “Te ha u a katun teka ba te mar ranga uana teka? Nonei e katsin gulena a nitsunono tere Sunahan? E moa ta toa ta katun te ga tatei lu ban u markato u omi, e Sunahan talasi a toa te antunana.” ");
INSERT INTO hla_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Be Iesu e atei sil hamanasena u hakats turu katun teka ba te poiena i taren, “A neha tsiponi te hakats homi memi limiu i torimilimiu? ");
INSERT INTO hla_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Alimiu e ma hanigami te poe mena gulei lia, ‘Alia e lu ba negu u markato u omi i tamulö’? Bara, alia e poa hamanase gou u tana u ranga te ka has mena a toukui pan te kato uana, ‘Alö go takei ba te soatsem a poapoa i tamulö ba lö te lam!’ ");
INSERT INTO hla_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Alia e haruto ragi limiu a mirakul teka alia tu butun katunuma e ka megu a nitagala i puta te go lu ba has menai lia u markato u omi.” Be Iesu e toan ranga mena a katun a matekata me poiena, “Alia e ranga mego lö, alö go takei ba te soatsem a poapoa i tamulö ba lö te la uam i han.” ");
INSERT INTO hla_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ba katun e takeito me soatsena a poapoa i tanen i matar u barebana hoboto ba te lana. Ba barebana e asingoto korur me soloseier e Sunahan me poier, “Ara i namala tarei ta ka te ga kato u teka.” ");
INSERT INTO hla_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Be Iesu e la pouts uato i kotolana i Ramun i Galili ba barebana hoboto e la uar i tanen ba nonei e tanian hatuts ranen. ");
INSERT INTO hla_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Poata te lalaia e Iesu ba te tarena a katun te lului a takis, a solonen e Livai a pien tere Alpias, ba nonei te gumuna tara luman takis i tanen ba te kuina. Be Iesu e poiena i tanen, “Alö go la gono memo lia.” Be Livai e takeina me la gono menen. ");
INSERT INTO hla_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Bu katun u para ti lului a takis nu katun u para has ti ngöri u katun u omi i la gono has mieto e Iesu. Be Iesu e na nouna i luma tere Livai bu palair u katun teka e na nou gono has mer e Iesu nu katunun tsitsilo i tanen has. ");
INSERT INTO hla_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bu palair u tson hihatuts turu Lo ti ngöri u Parisi e tarer e Iesu e nou gono mer u katun ti ngöri u omi nu katun ti lului a takis. Ba nori e rangata rer u katunun tsitsilo, “Tara naha te nou gono mera neien u katun te luluer a takis nu palair u katun u omi?” ");
INSERT INTO hla_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Be Iesu e hengo raten me ranga palisina, “U katun te moar ta nimate e ma tatei la uari tere dokta. E moa. U katun lasi te ka mer a nimate te la peisa uar tere dokta. Alia u ma la sile mei te go mi ngö merai u katun te poier nori e nigar. E moa. Alia u la silema te go mi ngö merai u katun te atei siler nori e omir ba te habirits hamatsköer a toriren.” ");
INSERT INTO hla_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tara toa poata u katunun tsitsilo tere Jon nu katunun tsitsilo turu Parisi i agonoein a kannou te gi singo uen tere Sunahan ti roron kato uen. U Parisi nori u pal katununa turu lotu turu Jiu. Bu katun e mi rangatser e Iesu me poier, “Tara neha bu katunun tsitsilo tere Jon nu katunun tsitsilo turu Parisi te agono ner a kannou, kaba u katunun tsitsilo i tamulö e ma agonori?” ");
INSERT INTO hla_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Be Iesu e ranga palisina, “Tara poata te hiakukoto gono meria a halis, na tsonun hitöl e kana, a pala tara tson e ma tatei agonori. E moa. Tara poata te kana a tsonun hitöl tara kannou, a pala tara tson e ma tatei agonori. ");
INSERT INTO hla_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kaba lia e heregi a toa tsonun hitöl te lu ba ner romana, ba pala i tar te agono riou romana nonei tara poata.” ");
INSERT INTO hla_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Be Iesu e poiena, “A katun e ma tatei hakune nei a tsi makumun labalaba a tsi tsimus te ga lakopo kapin a tabutu turu labalaba u toutounei. Te kato uanen teka ba poata te galuse rien bu labalaba u tsimus te tasukupuna ba te takis ba nena a makumun labalaba a toutounei, ba tabutu te pan koru lelina. ");
INSERT INTO hla_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na lia e hatei has ragoi limiu a kan osul te kuieri a pikpiköna meme. E moa ta katun te ga tatei osulia u wain u tsimus tara kan osul a toutounei teka. Te kato uanen teka ba nitagala turu wain u tsimus te pan susuluna ba te kato butsena a kan osul a toutounei te ma tatei talas nei, bu wain na kan osul te omi hoboto hakapar. E moa. A katun e tatei osulena u wain u tsimus tara kan osul a tsimus.” E Iesu e mar ranga u teka ba te haruto ranen u hihatutsuna i manasa turu Jiu e ma hisoböei menei u hihatuts u tsimus tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Turu toa u Lan u Goagono turu Jiu e Iesu e laia turu kuin wit. Bu katunun tsitsilo i tanen i la gono meien ba nori e tanian patsiker a hua turu wit. ");
INSERT INTO hla_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bu Parisi i poieto tere Iesu, “Pua, u Lo i tarara e ranga hapiu nena te gi kato meni u katunun tsitsilo i tamulö a ka teka turu Lan u Goagono.” ");
INSERT INTO hla_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Be Iesu e ranga palisito, “Alimiu go mala rit hanige iam a ka te kato e Devit e tuburara a king ni manasa. Tara toa poata nonei nu pal katun i tanen i moa ta kannou i taren ba nori i besuto. ");
INSERT INTO hla_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ba nori e na tasu ria tara luma tere Sunahan ba te nouer u beret te kaia i matana e Sunahan. A ka teka e butuia tara poata te tsunono pania e Abaiata turu pris. Turu Lo i tarara u pris talasi te tatei nouer u beret teka. Kaba e Devit e noue ien me hala has rena u pal katun i tanen. E Sunahan e ma kot mei e Devit. Ga tara neha te kot sil mera milimiu u katunun tsitsilo i tar?” ");
INSERT INTO hla_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Be Iesu e poiena i taren, “E Sunahan e ma katoei a katun te go kutekute meni u lo tara katun tun turu Lan u Goagono. E moa. Nonei e haka bei u Lan u Goagono e ga taguhi a katun ba te rorona. ");
INSERT INTO hla_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Alia tu butun katunuma te pan gia turu Lan u Goagono i gusumilimiu hoboto.” ");
INSERT INTO hla_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","E Iesu e la pouts u i luman lotu te kaia a toa katun te ka mei u ualima u mate. ");
INSERT INTO hla_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bu palair u katun i ngilin kotin e Iesu ba nori i ruto kap naten te ga kato haniga menien a katun teka turu Lan u Goagono. ");
INSERT INTO hla_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Be Iesu e poieto tara katun a lima-mate, “La uama i mam teka.” ");
INSERT INTO hla_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ba nonei e rangata rena a barebana, “U Lo i tarara e ranga nena aha te gi kato ra turu Lan u Goagono? Ara e tatei kato hanigara tsi ara e tatei kato homira? Ara e tatei taguhera a katun te katsin matena tsi ara e tatei atung hamatie ren?” Kaba nori i ma rangai. ");
INSERT INTO hla_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Be Iesu e hula tarana i taren me raharaha ranen me tori-tiama ranen, taraha a toriren e lagi hengo. Ba nonei e poieto tara katun, “Hasoa nema a limamulö.” Ba nonei e hasoa neto a limanen ba limanen e niga poutsuna. ");
INSERT INTO hla_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bu Parisi i lakasa ba neto a luman lotu me na hagum boroboro gono mer u pal katun tere Herot a King. Ba nori e katoer u korupakö te gi atung hamate meni e Iesu. ");
INSERT INTO hla_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","E Iesu nu katunun tsitsilo i tanen i la u tara Ramun i Galili bu katun u para koru i kukutie ten. ");
INSERT INTO hla_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nori i lama i Galili na i Judia ni Jerusalem ni Idumia ni hapalana ramun i Jodan na tara pal han tara man taun i Taia ni Saidon. U katun u para teka i la u tere Iesu, taraha nori i hengoin a man ka te katoen. ");
INSERT INTO hla_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","U katun i para koru be Iesu e poiena turu katunun tsitsilo i tanen, “Alimiu go na lue muma a tsi tolala. Te songe roa a barebana alia ba lia te osa goa tara tsi tolala.” ");
INSERT INTO hla_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nonei e kato haniga hakapa poutsir u katun u para, bu katun hoboto ti ka mei a nimate i hiasusongo sileto te gi sebele menien. ");
INSERT INTO hla_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tara mamana poata ti tareia u katun u sesein mate e Iesu, ba nori te hatukun ria i matanen. Ba nori i ku hohomito me poier, “Alö a Pien Tson tere Sunahan!” ");
INSERT INTO hla_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Be Iesu e ele hatagala mena si turu mate u omi te gi ma hatei meni a barebana nonei esi. ");
INSERT INTO hla_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Be Iesu e la sei uato i rehina u pokus ba nonei e ngö rena u katun te ngil raien ba nori e la uar i tanen. ");
INSERT INTO hla_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Ba nonei e hopu kap neto a 12 a katun me poiena, “Alia e hopu kap ragu lei limiu te go ka gono memo lia. Alia e hala has ragoi limiu te go na rarare uam limiu ba limiu te ka memou a nitagala te go tsuga ba mena milimiu u mate u omi.” ");
INSERT INTO hla_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nori u katun te hopu kap ren teka: e Saimon Pita (e Iesu te hale ien a tana solo e Pita). ");
INSERT INTO hla_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ere Jemis mere Jon a hinpien tere Sebedi. E Iesu te hala rien a tana solo Boanetsis. A mouna a solo teka u katun te tagala hereri u gururu. ");
INSERT INTO hla_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","E Endru ne Pilip ne Batolomiu ne Matiu ne Tomas ne Jemis a pien tere Alpias, ne Tadias. Na tana Saimon te tagala bei a han i tanen, ne Judas Iskeriot, a katun te ga harutein romana e Iesu tara pal barebanan korupakö i tanen. ");
INSERT INTO hla_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Be Iesu e la uato i han. Bu katun u para i gono lelito be Iesu nu katunun tsitsilo i tanen e moar ta poatan nou i taren. ");
INSERT INTO hla_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ba poata te hengo nia a pala i tanen a ka teka, ba nori e na katsin pile kap naren, taraha a barebana i poei, “Nonei e tutu hakapa.” ");
INSERT INTO hla_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bu palair u katunun hihatuts turu Lo ti lama i Jerusalem e poier, “E Bielsibul e seie nen. A tsunono turu mate u omi te hale neien a nitagala te ga tsuga ba merien u mate u omi.” ");
INSERT INTO hla_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Be Iesu e ngö rena a barebana gi la uama i tanen, ba nonei e haharoeina i taren me poiena, “Ime te ga mar tsuga ba meni e Satan e Satan? ");
INSERT INTO hla_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Te gi hiatatung poutsia u barebana i iahana toa han pan ba han teka te ma tatei tagala nei. ");
INSERT INTO hla_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na te gi hiatatung poutsia u katun tara toa hunhaposa bu katun teka te ma tatei ka haniga lel hasri. ");
INSERT INTO hla_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na te gi hiatatung poutsia a pala tere Satan ba te tarura mer a raharaha, be Satan te ma tagala lel nei, ba nonei te kapana romana. ");
INSERT INTO hla_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“A katun e ma antuna nei te ga sei u tara luma tara katun a tagala ba te kopena a man ka i tanen. E moa. Kaba nonei e ga kits kap mam bin a katun a tagala ba nonei te toan kopena a man ka te kana i luma. Ne kato has uana i iesana i tar. Alia e ka megu a nitagala te go tagala saluhe meni e Satan. Nonei a ka teka te antunan kato homi sil mera gilia a pala i tanen. ");
INSERT INTO hla_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Alia e hatei hamana rago limiu, e Sunahan e tatei lu ba nanou a man markato hoboto a man omi ti kato u barebana, nu ranga u omi has te ranga sesei naria i tanen. ");
INSERT INTO hla_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kaba eresi te ranga homi ner u Namnamei u Goagono tere Sunahan, be Sunahan te moa koru nou te ga tatei lu ba meni a markato a omi i tanen. Nori e ka nitoa mer romana a markato a omi teka.” ");
INSERT INTO hla_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","E Iesu e ranga u teka, taraha nori i ranga mam me poier, “A mate a omi e seie nen.” ");
INSERT INTO hla_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","E tsinane Iesu nu toulanen i tuku me tuol ria i ielesala tara luma. Ba nori e hala menari u ranga i tanen te ga la uen i taren. ");
INSERT INTO hla_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bu barebana u para ti gum hahis e Iesu e poier i tanen, “E tsinamulö nu toulamulö e ka ria i ielesala na nori e ngöe rio lö.” ");
INSERT INTO hla_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Be Iesu e ranga palisina, “E tsinar nu toular?” ");
INSERT INTO hla_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ba nonei e hula tarana turu katun ti gum hahisen me poiena, “Ruto iam. A barebana i rekeso e hereri e tsinar nu toular. ");
INSERT INTO hla_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Eresi te kato uar turu ngil tere Sunahan, nori e hereri u toular nu hahinar ne tsinar.” ");
INSERT INTO hla_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","E Iesu e tanian hihatuts lelia i rehina Ramun a Perperere i Galili. Bu barebana ti gonogono hahise ien i para koru, ba nonei e osana tara tsi tolala me gumuna. A tolala e agaia i ramun bu barebana te tuol ria i monsingmou. ");
INSERT INTO hla_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Ba nonei e hatuts rane ien a ka a para turu haharoei. Na toa haharoei e kato u teka: “Hengo iam. A katun e na hula tsihasein a ngalina kannou. ");
INSERT INTO hla_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nonei e tsihasa nen ba palain u ngal te pururuku ria i maroro bu apena te la rima ba te mi nou hakape ren. ");
INSERT INTO hla_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ba palain u ngal e pururuku ria turu tsikitsiki te ka mei u lapo ba nonei te pusuku boroborona, taraha e moa tu tsikitsiki tu kapan. ");
INSERT INTO hla_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ba poata te pirina a pitala, bu kan leba te magmagolona ba te langona, taraha e moa ta makum te ga silaia a poloso. ");
INSERT INTO hla_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ba palain u ngal e pururuku ria turu tsikitsiki te ka mei a kolits a hihitoka, bu kolits e panina ba te kato homiena a man kan leba teka, ba nonei te ma hua nei. ");
INSERT INTO hla_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ba palain u ngal e pururuku ria turu tsikitsiki u niga ba te panir ba te hua hobotor. Palabi i hua kaba a hua e ma parai. Na palabi i hua hapara, na palabi i hua hapara koru.” ");
INSERT INTO hla_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Be Iesu e poiena, “A katun te atein hengona e ga hengo haniga.” ");
INSERT INTO hla_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tara poata te ka pepeisaia e Iesu, ba palair u katun ti roron la gono meien na 12 a katunun tsitsilo i la uato i tanen me na rangatse rien te go ranga hatarare menien u haharoei. ");
INSERT INTO hla_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ba nonei e ranga palis ranen me poiena, “E Sunahan e haruto ranei limiu a ka te ma haruto rien a barebana i manasa. Alimiu e atei sil talemiu ime te mar pepeito kap uanen. Kaba u katun te ma atei sileri ime te mar pepeito kap uana e Sunahan, nori e hengo talaser u haharoei tun. ");
INSERT INTO hla_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","E Aisaia a propet tere Sunahan e kolotein a ka teka i manasa me poiena, ‘Nori e tara riou ba te tara tun talasir, kaba nori e ma tara hamana koru roi romana. Nori e hahengo riou ba te hengo tun talasir, kaba nori e ma atei hamana koru roi romana. Taraha, nori e raman habirits pouts uar i tar te go lu ba merien lia u markato u omi i taren.’ E Sunahan te ranga u teka.” ");
INSERT INTO hla_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","E Iesu e rangata ren, “Te ma atei sile mia limiu u haharoei teka, ba ime te mar atei sil mena moi limiu a man taina man haharoei? ");
INSERT INTO hla_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A katun e tsihasa nena u ranga tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A maroro te pururukuia u ngal e here nei u katun te hengoer u ranga be Satan te la boroboro nama me mi gulena u ranga ti tsihasa nia i toriren. ");
INSERT INTO hla_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","U tsikitsiki te ka mena u lapo e here nei a palabir u katun te hengoer u ranga tere Sunahan ba te haniga borobore ren ba te sasala meren. ");
INSERT INTO hla_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kaba u ranga e ma tsiruku haniga nei ba nori u katun teka te ke ier a tsitabubun poata puku. Ba poata te butu nama a poata a omi tsi a raharaha, te hamana mena rien u ranga tere Sunahan, ba nori te hapolasa boroborer u ranga. ");
INSERT INTO hla_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","U tsikitsiki te ka mena a kolits a hihitoka e here nei a palabir u katun te hengoer u ranga. ");
INSERT INTO hla_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Kaba nori e ka mer u hakats pan tara nitoatoa ni puta ba te ngiler e gi lu korui a moni pan ba te matesil koruer te gi lu meni ta palain ta ka. Na mamana ka teka e butu nama ba te piler u ranga tere Sunahan, bu ranga te ma habutse nei u markato u niga turu katun teka. ");
INSERT INTO hla_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bu tsikitsiki u niga te here nei a palabir u katun te hengoer u ranga tere Sunahan ba te pile kap naren, bu ranga te kato haniga rena u katun teka. Palabi u katun u niga, na palabi e niga korur, na palabi e niga bala korur.” ");
INSERT INTO hla_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Be Iesu e rangata ponina me poiena, “Aha te katoena a katun te tasu menama u lam? Nonei e mi kopo kap nane ien a tabeli, tsi e mi hakeie nen i kopina inana? E moa. Nonei e hakeie nen i iasa. ");
INSERT INTO hla_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","E mar kato uana teka, ba mamana ka hoboto te mousuna turu haharoei i tar i romana e atei sile riou romana i murimuri. Nu mamanu ranga i tar te ma atei sileri a barebana i romana, nori e atei sile roen romana i murimuri. ");
INSERT INTO hla_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","A katun te atein hengona e ga hengo haniga.” ");
INSERT INTO hla_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ba nonei e poe hasena i taren, “A man ka te hengoe milimiu alimiu go hengo hanige men. E Sunahan e hala hapopo nanoa romana a niatei i tamulö popona te go hengo haniga u lö, ba lö te lu lel has mou. ");
INSERT INTO hla_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","A katun te ateina, e Sunahan e hala lele noien romana a niatei. Na katun te raman ateina, e Sunahan e lu ba nenou romana a tsitabubun niatei te ka menen.” ");
INSERT INTO hla_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","E Iesu e poe leli, “Uhaharoei teka e haruto ranei limiu te mar butu uana a Nipepeito tere Sunahan. A katun e na tsihasa nena u ngalin wit te here nei a rais. ");
INSERT INTO hla_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nonei e soho mena bong ba te kalata mena lan me kuina, ba te kato talasina. Ba nonei u ngalin wit e pusukuna me panina, kaba katun e ma atei sile nei te mar pusuku uanen. ");
INSERT INTO hla_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","U tsikitsiki e habututena a kan leba ba te huana, a gohus e butu mamina ba holaka te toan butuna ba hua a tangoho te toan butuna. ");
INSERT INTO hla_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Poata te tangoho hakapana a hua ba katun te kete mena u kilata u koela, taraha a poatan tangoho turu wit e butu hakapa.” ");
INSERT INTO hla_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","E Iesu e rangata me poiena, “Ara e tatei poiera a Nipepeito tere Sunahan e here nei a neha? Alia e haharoei hatarare nagou te mar pepeito kap uana e Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nonei e here nei u ngalin mastat te makosi koru ba nena u ngal hoboto. Ba katun te lue nen ba te na sapul nanen turu tsikitsiki. ");
INSERT INTO hla_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ba nonei te pusukuna ba te pan sokuna turu kan leba hoboto. Ba nonei te taholakana ba te hikalan panina bu apena te mitö ria i tanen ba te kuier u suhana turu uoho i tanen. Na Nipepeito tere Sunahan e hatania hatetenei hasina ba te pan susuluna.” ");
INSERT INTO hla_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","E Iesu e rarare u ranga i tanen turu barebana me kato uana i iesana turu palainu haharoei u para. Nonei e haharoei hantunaia ti atei hapopo ien. ");
INSERT INTO hla_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nonei e ranga tun talasi merien u haharoei. Kaba te ka pepeisa gono meria e Iesu u katunun tsitsilo i tanen, ba nonei te ranga hatarare mera neien a mamana ka hoboto. ");
INSERT INTO hla_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Turu toa u lan noa has tara lahibong be Iesu e poieto turu katunun tsitsilo i tanen, “Ara gi aroho u i hapalana ramun.” ");
INSERT INTO hla_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ba nori e la ba rer u pal barebana u para bu katunun tsitsilo e na osa ria tara tsi tolala te ka hakapaia e Iesu, ba nori e la gono meren. Ba palain a ma tsi tolala i ka has. ");
INSERT INTO hla_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bu ualupu pan e takeito bu ramun te posa hongona i iahana tolala ba tolala e katsin saputuna turu ramun. ");
INSERT INTO hla_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","E Iesu e opuia i pal tou tara tolala ba te sohona turu uolana. Bu katunun tsitsilo i gulie ten me poier, “Tson Hihatuts, alö e ma tatagi rami lam? Ara e katsin taia talara.” ");
INSERT INTO hla_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Be Iesu e takeito ba te haselohena a lomolomo me abisena u keikei, “Opu.” Ba lomolomo nu keikei e opu poutsuto me kapana ba maraha pan e bututo. ");
INSERT INTO hla_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Be Iesu e ranga mera nen me poiena, “Tara neha ba limiu te matout korumiu? Alimiu e ma hamanami?” ");
INSERT INTO hla_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ba nori i matout koruto me hihirangatsir, “A saha koru a mar katun teka? A lomolomo nu keikei e manietse ren.” ");
INSERT INTO hla_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nori i tuku hakapaia i hapalana Ramun i Galili tara han ti kaia a pal barebana ti ngöri u Gerasin. ");
INSERT INTO hla_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Be Iesu e toan kouluto tara tsi tolala ba nonei e hitupali mena a katun te butuma turu ngahongaho ti kuieia turu lapo. ");
INSERT INTO hla_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A mate a omi e sesei a katun teka ba nonei e roron kakata i ngahongaho. A barebana i ma antunai te gi kits lel menien a tsien. ");
INSERT INTO hla_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tara mamana poata a para nori i kits kakapi a man limanen a tsien na man mounen a aien, kaba nonei e roron kato pusin a tsien me singata pus nana a aien. Nonei e tagala koru na katun te go kato halene ien i ma antuna korui i tanen. ");
INSERT INTO hla_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tara mamana poata, a lan na bong, nonei e lala pinopinoia turu ngahongaho na tara pokus ba te ku hohomina ba te ngats bubutse nei a peisanen a hatu. ");
INSERT INTO hla_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nonei e ka noaia i lehana ba te tare nama e Iesu ba te pieta nama me mi hatukununa i matane Iesu. ");
INSERT INTO hla_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ba nonei e ku hapanina me poiena, “O Iesu, a Pien Tson tere Sunahan i Iasa Koru, alö go haka ba nio lia. Alia e singo hatatagi koru gua i tamulö i matane Sunahan, alö go ma hahunei lia.” ");
INSERT INTO hla_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nonei e kato u teka taraha e Iesu e ranga hakapa meien, “A mate a omi, alö go koul ban a katun teka.” ");
INSERT INTO hla_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Be Iesu e rangate nen, “Esi a solomulö?” Ba katun e ranga palisina, “A solor e Ami, taraha alam e param.” ");
INSERT INTO hla_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ba nonei e singo hatagalana tere Iesu te go ma tsuga ba meri u mate u omi tara han teka. ");
INSERT INTO hla_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A toa heis poum pan i nouia i rehina u pokus te sukusuku. ");
INSERT INTO hla_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bu mate i singoia tere Iesu me poier, “Alö go hala meri lam turu poum ba lam te na sei mia i taren.” ");
INSERT INTO hla_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ba nonei e hanigato i taren. Bu mate u omi e koul ba ner a katun ba te na sei ria turu poum. Ba heis poum teka, te popoia turu 2000 tara poum, e hipipieta gala hobotor turu uarahana ba te na pasur tara ramun me mate hakapar. ");
INSERT INTO hla_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bu taratarakap turu poum i bus talato me na polase ria u ranga i taun na turu han. Ba barebana e mi katsin tarer a ka te butu hakapa. ");
INSERT INTO hla_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ba nori e la uarima tere Iesu ba te mi rutser a katun ti seseibi u mate tara ami. Ba nonei e gumuna ba te haseiena u hasobu ba te hakats haniga poutsuna. Ba nori e matoutur. ");
INSERT INTO hla_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bu katun ti tarei a ka teka e hatei rer a barebana a ka te butuia tara popoloana na turu poum. ");
INSERT INTO hla_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ba nori e tahuler e Iesu te go la ba menien a han i taren. ");
INSERT INTO hla_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","E Iesu e osa poutsia tara tsi tolala ba katun te popoloana e singo hatagalana tere Iesu, “Alia go la gono meio lö.” ");
INSERT INTO hla_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kaba e Iesu e ma hanigai. Ba nonei e poieto i tanen, “Alö go la pouts u i han i tamulö ba lö te na rarare berami a pala i tamulö a ka a niga te kato bena moi lö a Tsunono, na te tatagi has mena name ien lö.” ");
INSERT INTO hla_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ba katun teka e lato turu han i iahana provins i Dikapolis (a solo teka e poiena a Maloto a Taun). Ba nonei e habulungana nena a ka te kato beien e Iesu. Ba barebana hoboto e asingoto korur. ");
INSERT INTO hla_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","E Iesu nu katun i tanen i aroho pouts u i hapalana a ramun. Poata ti sung pouts ien i mounsingmou, bu katun u para koru i gono hahise ten. ");
INSERT INTO hla_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ba toa tsonun pepeito tara luman lotu e la nama, a solonen e Jairas. Ba poata te tare ien e Iesu ba nonei te hatukununa me turuna i matane Iesu. ");
INSERT INTO hla_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ba nonei e singo hatatagi koru uana i tanen me poiena, “A tsi pien tahol i tar e katsin matena. Alö go na hatakopo a limamulö i tanen ba nonei te toan niga pouts nou ba te toatoana.” ");
INSERT INTO hla_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Be Iesu e la gono menen. Ba barebana u para koru i la gono meten ba te hipasasir i tanen. ");
INSERT INTO hla_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","A toa tahol e kaia i gusuren e posa nitoan u rahatsing antunaia tara 12 u hiningal. ");
INSERT INTO hla_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nonei e la hakapa u turu dokta hoboto ba te lapo hakapa nena a moni hoboto i tanen, kaba a nimate i tanen e ma kapai. E pan susul hasoala. ");
INSERT INTO hla_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nonei e hengoin e Iesu ba nonei te mi kukutie nen i gusuna barebana ti la gono meien. ");
INSERT INTO hla_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ba nonei e hakats tununa, “Alia go hasebeleia turu hasobu tun i tanen ba lia te niga pouts gou.” ");
INSERT INTO hla_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ba nonei e la hasukusukuna ba te na hasebelena turu hasobu tere Iesu bu rahatsing e kapa pouts boroboro koruna. Ba nonei a tahol e hasagoho talena a nimate i tanen e kapa. ");
INSERT INTO hla_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ba i teka puku be Iesu te hasagohona i peisanen te la ba menien a nitagala. Ba nonei e habiritsina i gusuna a barebana me poiena, “Esi te sebele lala turu hasobu i tar?” ");
INSERT INTO hla_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bu katunun tsitsilo i tanen e poier, “Alö e tarem a barebana e hiasusongor i tamulö. Tara naha te rangata memi lö esi te sebele lala turu hasobu i tamulö?” ");
INSERT INTO hla_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Be Iesu e hula tara sakesake nena esi te kato. ");
INSERT INTO hla_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na nonei a tahol e atei sil a ka te butuia i tanen ba nonei e tololo mena nimatout. Ba nonei e na hatukununa me turuna i matane Iesu ba te hateie nen a man ka hoboto. ");
INSERT INTO hla_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Be Iesu e poieto i tanen, “A tsi tahol, a nihamana i tamulö e kato haniga poutse lala a nimate i tamulö. La talala, na torimulö e tatei husa poutsuna. A nimate i tamulö e kapa nitoa tala.” ");
INSERT INTO hla_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Poata te ranga noaia e Iesu, bu katunun tatala e la rima i luma tere Jairas me mi hateie ren, “A pien tahol i tamulö e mate hakapa lala. Alö go ma hakui leli a Tson Hihatuts.” ");
INSERT INTO hla_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Be Iesu e tupena a talinganen turu ranga i taren ba nonei te poiena tere Jairas, “Alö go ma matouti. Alö go hamana noa talasi.” ");
INSERT INTO hla_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ba nonei e hapiu rena a barebana hoboto te gi ma la lel gono menien. Kaba ere Pita mere Jemis ne toulanen e Jon nori talasi ti la gono meien. ");
INSERT INTO hla_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ba nori e tuku hakapa ria i luma tara tson pepeito tara luman lotu, be Iesu e tarena a barebana ti keta ba te tabe hobotor. ");
INSERT INTO hla_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ba nonei e tasuna me poiena i taren, “Aha te keta sile milimiu? Alimiu e tabiemiu aha? A pien e ma mate nei. Nonei e soho tununa.” ");
INSERT INTO hla_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ba nori e gol hahamana naren ba nonei e tsuga halakasa ranen. Be Iesu e lu rena e tamana pien ne tsinanen na elapisa katunun tsitsilo i tanen me la mera nen i iahana makum te opuia a pien. ");
INSERT INTO hla_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ba nonei e luena a limanen me poiena i tanen, “Talita kumi.” U ranga teka e poiena, “A tsi pien, alia e ranga mego lö, takei.” ");
INSERT INTO hla_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ba nonei e hakalatsena a matanen me takei hamanasana me tanian hula lana. Nonei e ka mei u 12 u hiningal i tanen. Ba nori e asingoto hapan korur. ");
INSERT INTO hla_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Be Iesu e ranga hatagala mera nen e gi ma hatei korui ta toa ta katun. Ba nonei e poiena, “Halei ta ka ga nouen.” ");
INSERT INTO hla_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","E Iesu nu katunun tsitsilo i tanen i la ban a han teka me la pouts uar i han i tanen. ");
INSERT INTO hla_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na turu Lan u Goagono nonei e tanian hihatutsia tara luman lotu. U katun u para ti kaia tara luma teka i hengoen me asingoto korur. Ba barebana e hiahihiragatsir, “Ime te lue ien a man ranga teka? Ime te mar lu mena neien a mar niatei teka? Na ime te mar kato mena neien a man mirakul teka? ");
INSERT INTO hla_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nonei a kamda talasi, a pien tere Maria. Nu toulanen ere Jemis mere Joses ne Judas ne Saimon, nu hahinanen e ka has ria teka.” Ba nori e raharahe ren. ");
INSERT INTO hla_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Be Iesu e poiena i taren, “A propet tere Sunahan e ka mena a solo turu han hoboto. Kaba a han i tanen nu katun pouts i tanen e ma poeri e Sunahan e hale ien a nikapan.” ");
INSERT INTO hla_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na nonei e ma antunai te go kato menien tu mirakul tu para i han teka. Nonei e halakopi a limanen tara man toa man katun ti ka mei a man nimate ba te kato haniga pouts ranen. ");
INSERT INTO hla_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ba nonei e asingoto koru nena ti hahamana uen. Ba nonei e hula lana turu han ti sukusuku me hihatutsuna. ");
INSERT INTO hla_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","9","E Iesu e ngö gugoner a 12 a katun ba te katsin hala rena a man elasolana tara man toa man makum. Ba nonei e hala rane ien a nitagala te gi tsuga ba merien u mate u omi, me poiena i taren, “Alimiu go ma la gono memi ta ka tara tou lala i tamilimiu. E moa tu la mei ta beret na ta pora na ta moni. Kaba alimiu e tatei luemiu u tukana, na limiu e tatei hasogoemiu u sendol nu toa puku u hasobu u ngahangaha. ");
INSERT INTO hla_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Poata te butu moa limiu tara toa taun, alimiu e tatei ka mia tara toa puku a luma antunana te la ba nemia limiu nonei a taun. ");
INSERT INTO hla_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te ma las hagum raroa limiu u katun tsi te ma hengo rarien limiu, alimiu e tatei la ba namiu a taun i taren ba te tohu ba namiu u koahu i pitpitan moumilimiu. A ka teka e haruto nanou te raharaha mera neien e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ba nori te lar ba te na rararer te gi na palis meni a barebana u markato u omi i taren. ");
INSERT INTO hla_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ba nori te tsuga rer u mate u omi u para ba te sahi ner u uapi turu katun u para ti ka mei a nimate ba nori te niga poutsur. ");
INSERT INTO hla_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","E Herot a King e hengoin a man ka teka, taraha u han hoboto i hengoin e Iesu. Palabir u barebana i poei, “A katun teka nonei e Jon te baptaisir u barebana, Nonei e toatoa poutsuma ba te ka mena a nitagala teka.” ");
INSERT INTO hla_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ba palai te poier, “Nonei e Ilaitsa.” Ba palai lel te poier, “Nonei a tana propet tere Sunahan ni manasa.” ");
INSERT INTO hla_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Poata te hengoeia e Herot u ranga teka ba nonei e poiena, “Nonei e Jon te baptaisir u barebana. Alia u hangats babin a bakunen ba nonei te toatoa pouts lel nama.” ");
INSERT INTO hla_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","A ka te habuti u ranga teka tere Herot e kato uana teka: a toa tahol a solonen e Herodias a hahagono tere Herot. Nonei a tahol mam tere Pilip e toulane Herot. Kaba e Herot e töle ien, be Jon e ranga meto e Herot, “E ma matskö nei te tölo mena milö a hahagono i tamulö.” Be Herodias e hengoe ieto a ka teka me raharaha koruena e Jon. Be Herot e hangö nena e Jon bu katun tere Herot e na pile kap naren me kitse ren me na hake rien tara karabus. Nonei e kato silei a ka teka e Herodias. ");
INSERT INTO hla_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Be Herodias e ngil hasi e Jon e gi ngats hamate, kaba e ma antoei tere Herot. ");
INSERT INTO hla_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","E Herot e matouti e Jon, taraha e atei sili e Jon a katun a niga koru. Ba nonei e hapiu nena te ga kato homi menien ta katun. E Herot e toku koru mei tara mamana poata te hengo menien a man ranga tere Jon, kaba nonei e hengo noa talasen. ");
INSERT INTO hla_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tara toa poata e Herodias e sabe iena a maroro i tanen turu lan te hatoatongein u lan ti posa mei e Herot. U lan teka e butu hakapa be Herot e katoe iena a panna kannou me hangö rena u katun pan tara gamman i tanen nu kepten pan turu soldia i tanen na pal kapanir i Galili. ");
INSERT INTO hla_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ba pien tahol a kukubei tere Herodias e tasu nama me sani hamamangil rena ere Herot meru katun ti nou gono meien. Be Herot e poiena tara kukubei teka, “Aha te ngilin lue mulö? Alia e hale goi lö ta ka te ngile mulö.” ");
INSERT INTO hla_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ba nonei e poe hasina tara kukubei, “Alia e hamana gia i iasa tere Sunahan te go hala meni lia lö ta ka te ngile mulö, antunana tara hapalana u nipepeito i tar popona tara makum te pile noa nagu lia.” ");
INSERT INTO hla_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ba kukubei e lakasana me na rangatsena e tsinanen me poiena, “Aha te go na rangata sili lia?” Be tsinanen e poiena, “A bakune Jon e gi ngats pagotsema!” ");
INSERT INTO hla_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ba kukubei e pieta pouts hamanasa uana tere Herot me na poiena i tanen, “Alia e ngilegu alö go hahongema a bakune Jon tara pelet teka puku ba lö te hale mume ien lia, ba te haruto nena te mate hakapa uen.” ");
INSERT INTO hla_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Be Herot e tori-tiama koruna, kaba e ma antunai te go pita harus meni u ranga i tanen, taraha nonei e hamana hakapaia tere Sunahan i matar u katun ti nou gono meien. ");
INSERT INTO hla_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ba nonei e tahul hamanasena a toa tson taratarakap e go na soatema a bakune Jon. Ba tson taratarakap e lato tara luman karabus me na ngats kotsena a bakune Jon. ");
INSERT INTO hla_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ba nonei e soata poutse namen tara pelet me na hale neien a kukubei ba kukubei e na hala uase neien e tsinanen. ");
INSERT INTO hla_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Bu katunun tsitsilo tere Jon e hengo ner a ka teka me mi soatser a tuanreinen me na hahonge rien tara kioun mate. ");
INSERT INTO hla_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","U aposol i kopis uama tere Iesu me mi hatei rien a man ka ti katoe men na man ka ti hihatuts namen. ");
INSERT INTO hla_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","U katun u para koru i la hiton uama tere Iesu ba nonei nu aposol i tanen te moa talar ta poatan nou i taren. Ba nonei e poiena i taren, “Ara gi la pepeisa u tara makum a ski ba limiu te tatei na gamon husamiu.” ");
INSERT INTO hla_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ba nori e osa peisa ria tara tsi tolala me la uar tara toa makum a ski. ");
INSERT INTO hla_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bu katun u para i tara raten ti la uen me marei hamanasa raren. Ba nori e la ba ner a han hoboto me pipieta mam uar tara makumun han te gi na hasung ien. ");
INSERT INTO hla_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Poata te koulia e Iesu tara tsi tolala ba nonei te tara rena u katun u para koru teka. Ba nonei e tatagi koru ranen, taraha nori i herei u sipsip ti moa ta katunun taratarakap i taren. Ba nonei e tanian hatuts rane ien a ka a para. ");
INSERT INTO hla_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","A ka e sukusukun lahibong bu katunun tsitsilo e la uarima i tanen me poier, “E lahibong hamanasana kaba e moa ta han tara makum teka. ");
INSERT INTO hla_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Hala bar a barebana ba nori te la uar turu han te sukusukur ba te na holer tera tsi kannou.” ");
INSERT INTO hla_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Be Iesu e ranga palisina, “Alimiu peisa te go hala ramien ta kannou te gi nouen.” Ba nori e rangatar, “Alö e ngilem alam go na hol ta beret antunana turu 200 denarius te popona tara hihol turu 200 u lan ba te hanou ramien?” ");
INSERT INTO hla_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Be Iesu e rangata ranen, “Lahisa beret te ka memi limiu? Na tara muma.” Poata ti sabie men u beret ba nori e mi hateie ren, “A tolima beret na solana iena puku.” ");
INSERT INTO hla_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Be Iesu e ranga merana u katunun tsitsilo i tanen e gi hagum gonogono kalakala ria u barebana turu garas u bibil. ");
INSERT INTO hla_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ba barebana e hagum ria tara ma tsi hagum. A toa hagum e antoeia turu 50 u katun, na tana u hagum u 100 u katun, ba te kato talasina. ");
INSERT INTO hla_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Be Iesu e luena a tolima beret na solana iena me tara sei uana i Kolö me hanigana tere Sunahan. Ba nonei e posepose iena u beret me hala rane ien u katunun tsitsilo i tanen e gi molamola rien u barebana. Ba nonei e molamola hase iena a solana iena i taren hoboto. ");
INSERT INTO hla_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ba barebana hoboto e nour me masulur. ");
INSERT INTO hla_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bu katunun tsitsilo e gone ier u makumun beret nu iena ti masul ba neien me antunana tara 12 a kalobaka a saputu. ");
INSERT INTO hla_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ba turu katun ti nou u beret, a pal tson i popoia turu 5000. ");
INSERT INTO hla_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Be Iesu e toan hosa rena u katunun tsitsilo i tanen tara tsi tolala ba nori te mam naren i Betsaida i hapalana ramun a perperere. Ba nonei e hala ba rena a barebana. ");
INSERT INTO hla_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nonei e hala hakapa raien ba te kete uana turu pokus te go na singo uen tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ba ka e bong hakapana ba tsi tolala te kana i gusuna ramun be Iesu te ka pepeisana turu tsikitsiki. ");
INSERT INTO hla_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ba nonei e tare ieto u katunun tsitsilo i tanen i lagi susua mei a lomolomo. Ba tara sukusukuna lunlan ba nonei e la uana i taren me tatala silana i ieluna ramun. Ba nonei e katsin la karasa ranen. ");
INSERT INTO hla_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kaba nori i tare ien te la uen i ramun ba nori e poier, “A liliahanei!” ba te hani naren. ");
INSERT INTO hla_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Taraha, a poata ti tara hobotose ien nonei ba nori e matoutu korur. Be Iesu e ranga hamanasa mera nen, “Ma matoutmi. Alia ba.” ");
INSERT INTO hla_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ba nonei e osa gono mera nen tara tsi tolala ba lomolomo e selohona. Bu katunun tsitsilo e asingoto korur. ");
INSERT INTO hla_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ba nori e ma atei sil haniga korueri ime te mar mouna u a mirakul te kato e Iesu turu beret. A bakuren e tutun a ka teka. ");
INSERT INTO hla_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nori i la harohi a ramun a perperere me na hasung hapasana ria i han i Genesaret. ");
INSERT INTO hla_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ba nori e la ba ner a tsi tolala bu katun i marei hamanase ieto e Iesu. ");
INSERT INTO hla_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ba nori e hula pieta uar turu luma hoboto me soata rarima u katun ti ka mei a nimate. Nori i soata rame ien u poapoa me la mera rien tara makum ti hengo nen te kaia e Iesu. ");
INSERT INTO hla_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ba tara mamana makum te la u e Iesu, tara taun nu han pan nu han u tetenei, bu barebana te soata rer u katun ti ka mei u nimate ba te la mera rien tara man makumun tago. Ba nori e singo hatatagi ria i tanen te gi hasebele u i runguna u hasobu i tanen. Nu katun hoboto ti sebele ien i niga pouts. ");
INSERT INTO hla_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","U Parisi nu tson hihatuts turu Lo ti lama i Jerusalem i gonogono hahis e Iesu. ");
INSERT INTO hla_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ba nori e tarer a palabir u katunun tsitsilo i tanen ti nou a kannou i taren me hakats tunur ba te poier, “Nori e nou mer u ualima u korkoriana.” U katunun tsitsilo tere Iesu i ma mar galus meni a limaren ti mar ranga u u Parisi. ");
INSERT INTO hla_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","U Parisi nu Jiu hoboto e kukutier u hihatutsuna turu tuburen. Nori e ma tatei nou mamri te ma galus noa mena rien a limaren te mar ranga uana u lo turu tuburen. ");
INSERT INTO hla_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na nori e ma tatei nou haseri a man ka te lue rimen tara toana ba te ma galus mameri. Na nori e kukute haser a palaina man markato u para ti luen. Nori e mar galus haniga has menari a gotana na tabeli na sospen kapa ti mar ranga u u tuburen. ");
INSERT INTO hla_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bu Parisi nu tson hihatuts turu Lo i rangatse ieto e Iesu me poier, “Tara naha bu katunun tsitsilo i tamulö te ma kukutieri u hihatuts turu tuburara ba te nou tsipon mer u ualima u korkoriana?” ");
INSERT INTO hla_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Be Iesu e ranga palisina i taren, “E Aisaia e ranga hamana rio limiu i manasa. Alimiu u katun u gamogamo te koloto u e Aisaia me poiena, ‘E Sunahan e poiena, U katun teka e hatsunono meri lia u ranga tun i taren, kaba a toriren e lehana ba neno lia. ");
INSERT INTO hla_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nori e mastei hatsunone rio lia, taraha nori e roron hihatuts ner a man markato turu katun tun, ba te poier nonei a man markato tere Sunahan.’” ");
INSERT INTO hla_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Be Iesu e poiena, “Alimiu e hapolasa ba nemiu u ranga tere Sunahan ba te pile kap namiu u markato turu katun tun.” ");
INSERT INTO hla_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ba nonei e ranga lelina, “Alimiu e atei koruemiu te go habirits ba menami u ranga tere Sunahan ba te pile kap namiu u markato peisa i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Te poe meni e Moses, ‘Hapan iam e tamamilimiu ne tsinamilimiu,’ me poe hasena, ‘A katun te ranga homi nena e tamanen tsi e tsinanen e gi atung hamate korui.’ ");
INSERT INTO hla_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kaba u hihatuts i tamilimiu e poiena, ‘A katun te ka mena a ka te tatei taguhena e tamanen tsi e tsinanen, nonei e tatei poiena, A ka teka a Korban (a mouna u ranga teka, A ka tere Sunahan). ");
INSERT INTO hla_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","13","Ba nonei a katun teka e ga ma taguhi e tamanen tsi e tsinanen.’ Te mar ranga uami limiu. E kato uana teka ba limiu te hatuts hiton namiu u markato turu tubumilimiu ba limiu te hipus namiu u ranga tere Sunahan. Na palair a man markato u para te katoe milimiu e kato has uana i iesana.” ");
INSERT INTO hla_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","E Iesu e ngö lelir a barebana te gi la uama i tanen me poiena i taren, “Alimiu hoboto go hengo mia i tar ba te hengo hanigamiu. ");
INSERT INTO hla_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","A ka te kana i ielesala tara katun ba te lana i iogana i tanen, a ka teka e ma antunan kato hakorkoriane nei a katun teka. A ka talasi te lakasa nama i iogana tara katun te tatei kato hakorkoriane nen.* ");
INSERT INTO hla_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","A katun te atein hengona e ga hengo haniga.*” ");
INSERT INTO hla_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Poata te la ba ria e Iesu a barebana me tasuna i luma, bu katunun tsitsilo i rangatse teien u haharoei teka. ");
INSERT INTO hla_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Be Iesu e poieto i taren, “Alimiu e ma atei noa hasmi? Ga limiu go atei sile iam a ka te kana i ielesala tara katun ba te lana i iogana i tanen e ma antunan kato hakorkoriane neien. ");
INSERT INTO hla_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Taraha, e ma tasu nei turu tori hamana te here nei u namnamei i tanen. Kaba e tasu talasina turu mukolo tun i tanen ba te la sokuna i ielesala turu tuanreinen.” (E Iesu e ranga u teka ba te poiena a mamana mar kannou e tatei noue ier.) ");
INSERT INTO hla_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ba nonei te ranga lelina, “A ka te lakasa nama i runguna katun, nonei a ka te kato hakorkoriane nen. ");
INSERT INTO hla_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","A mamana ka a omi e butu nama i iogana tara katun, i torinen: u hakats u omi na tsikolo na haloku na kop na hipuli na tsikolen a katun a hitöl na matesil a man ka tara tana katun na markato a omi. Na gamogamo na markaton hamatsingolo tua nu hiomi nu tuts na hipus nu hirata u omi. ");
INSERT INTO hla_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","A mamana ka a omi hoboto teka e tuhana nama i iogana tara katun ba te kato hakorkoriane nen.” ");
INSERT INTO hla_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","E Iesu e la ban a han teka ba te la uana tara toa han i rehina a taun te ngöeri i Taia. Ba nonei e tasuna tara toa luma ba te rama nena a barebana e gi atei sil te ka uen teka. Kaba a barebana i sabe noa hase ien. ");
INSERT INTO hla_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Na toa tahol e ka mei a tsi pien tahol i tanen te sinasahaia tara mate a omi. Ba tahol teka e hengoin e Iesu ba te la boroborona i tanen me na hatukununa i matanen. ");
INSERT INTO hla_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A tahol teka a toun Pinisia tara provins i Siria, a pal barebana i tanen te halhal ria turu Jiu. Ba nonei e ranga hatatagi-torina tere Iesu te go tsuga ba menien a mate a omi tara tsi pien tahol i tanen. ");
INSERT INTO hla_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Be Iesu e ranga palisina me haharoei nena u Jiu nu katun te halhal ria turu Jiu me poiena, “Gi hanou mam bir a galapien. E ma niga nei te go lu meni lam a kannou tara galapien ba te lapo rami u muki.” ");
INSERT INTO hla_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ba tahol e hatanganato me poiena, “E manana, Tson Hihatuts. Kaba u muki te kar i kopina u tebol e nou haser a ma tsi kukoto tara galapien.” Be Iesu e atei sileto nonei a tahol e hakats u teka: u Jiu i ngöri u katun halhal u muki, kaba u katun halhal i tatei lu noa hasi a palabina man ka man niga tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Be Iesu e poiena tara tahol, “Alö e tatei la poutsum i han i tamulö, taraha alö e ranga palis haniga mula. A mate e la ba hakapa nelala a pien tahol i tamulö.” ");
INSERT INTO hla_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ba tahol e la poutsuna i han i tanen ba te na sabe poutsena a pien tahol i tanen e opuia tara inana. A mate e la ba hakapa nen. ");
INSERT INTO hla_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","E Iesu e la ba nela a ma tsi han i rehina taun i Taia ba te na silana i rehina tana taun i Saidon. Ba nonei e sila hasina i iahana Dikapolis ba te tukuna tara Ramun a Perperere i Galili. ");
INSERT INTO hla_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ba barebana e la merima a katun a talingatu na mianen has e makmakum. Ba nori te na ranga hatatagi-tori ria tere Iesu te go hatakopo meni a limanen i tanen. ");
INSERT INTO hla_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Be Iesu e lue nen me la ba mera neien u katun tara makum a ski. Be Iesu e hasogeto a man kabelenen turu talingatu me kahusuna me sebelena i miana katun. ");
INSERT INTO hla_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Be Iesu e tara sei uana i iasa i Kolö me husatakana me poiena tara katun, “Epata.” U ranga teka e poiena, “Tasoku.” ");
INSERT INTO hla_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ba i teka puku a talingana katun e hengo poutsuna na mianen e niga hakapa poutsuna ba nonei te ranga haniga pouts talana. ");
INSERT INTO hla_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Be Iesu e ranga hapanina i taren, “Alimiu go ma hateiemi ta toa ta katun.” Nonei e raranga hapan noa has kaba nori i na hahatei noa talasi. ");
INSERT INTO hla_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ba barebana hoboto ti hengo ren te asingoto koru siler a ka teka, ba nori te poier, “A mamana ka hoboto te katoe nen e nigana. Nonei e kato haniga pouts rena u talingatu ba nori te hengo poutsur, na nonei e kato haniga pouts has rena u mia-makum ba nori te ranga haniga poutsur.” ");
INSERT INTO hla_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tara poata teka a barebana u para koru i gono lelia tara toa makum ti hengo menien e Iesu. Poata te kapaia a kannou i taren, be Iesu e ngö rena u katunun tsitsilo i tanen ba nori e la uarima i tanen. ");
INSERT INTO hla_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ba nonei e poiena, “Alia e tatagi koru regu a barebana teka, taraha nori i ka gono meio lia turu topisa u lan ba kannou i taren e kapa koruna. ");
INSERT INTO hla_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Te go hala pouts merien lia turu han i taren ba te ma nou noari, ba nori te na tutupulala meriou a bes i maroro. Taraha, a palai i lama turu han i lehana.” ");
INSERT INTO hla_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bu katunun tsitsilo i tanen i rangatse ten me poier, “Ime te mar sabe halona mena roi ra ta kannou tara latu pinopino teka te gi hanou rira u barebana?” ");
INSERT INTO hla_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Be Iesu e rangatato, “Lahisa beret te ka memi limiu?” Ba nori e poier, “A tohit.” ");
INSERT INTO hla_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Be Iesu e ranga mereto a barebana e gi gumia turu tsikitsiki. Ba nonei e luena a tohit a beret me haniga uana tere Sunahan me posepose ienen. Ba nonei te hala rane ien u katunun tsitsilo i tanen e gi molamola rien u barebana. Ba nori e mar kato uar teka. ");
INSERT INTO hla_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nori i ka has mei a man toa man iena man tetenei. Be Iesu e haniga uana tere Sunahan tara ma tsi iena teka ba te ranga merena u katunun tsitsilo e gi molamola has rien a ma tsi iena. ");
INSERT INTO hla_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ba barebana hoboto e nour me masulur. A barebana teka i sukuskuia tara 4000 tara katun. ");
INSERT INTO hla_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bu katunun tsitsilo e gone ier u nouba me antunana tara tohit a kalobaka suputu. ");
INSERT INTO hla_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Be Iesu e hala ba rena u barebana ba te toan osa gono merena u katunun tsitsilo i tanen tara tsi tolala. Ba nori e la uar tara provins i Dalmanuta. ");
INSERT INTO hla_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Palair u Parisi i lama ba te mi tanian ngene ier e Iesu. Nori i katsin torohane ien. Ba nori i rangatse ten te ga kato beme rien ta mirakul te ga harutein a nitagala tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Be Iesu e sökana koruna i torinen me poiena, “Tara naha tsiponi ba limiu a hei barebana i romana te ngilin ruto namiu a mirakul te ga harutein a nitagala tere Sunahan? Alia e hatei hamana rago limiu, alia e ma haruto nagoi ta mirakul tara hei barebana i romana.” ");
INSERT INTO hla_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ba nonei e la ba rena a barebana, ba nonei nu katunun tsitsilo i tanen e na osa pouts ria tara tsi tolala me la uar i hapalana ramun a perperere. ");
INSERT INTO hla_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","U katunun tsitsilo i solopalema te gi soata mena mei ta beret. A toa puku a beret ti ka meien tara tsi tolala. ");
INSERT INTO hla_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Be Iesu e ranga hatagalana i taren te gi ma hengoe ien u hihatuts u omi turu katun me poiena, “Alimiu go tara kap haniga iam ba te hanei silemiu u yis turu Parisi nu yis tere Herot.” ");
INSERT INTO hla_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ba nori e hiararangar me poier, “Nonei e ranga nanei a ka teka taraha ara e moa ta beret.” ");
INSERT INTO hla_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","E Iesu e atei sil nori i hakatsin u yis tun ba te ma hakats neri u hihatuts u omi turu Parisi na tere Herot. Ba nonei e poiena, “Naha te hiararanga nemi limiu, ‘Ara e moa ta beret’? Alimiu e ma hahatongo noami? Alimiu e ma atei noami? A bakumilimiu e tutuna? ");
INSERT INTO hla_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Alimiu e ka memiu u mata. Tara naha te ma tara memi limiu? Alimiu e ka memiu u talinga. Tara naha te ma hengo memi limiu? Alimiu u solopala hakapa iam? ");
INSERT INTO hla_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Poata tu poseposeia lia a tolima beret tara 5000 turu katun, ba lahisa kalobaka nouba tu onge iam limiu?” Ba nori e ranga palisir, “A 12 a kalobaka.” ");
INSERT INTO hla_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Be Iesu e rangata lelina, “Na poata tu poseposeia lia a tohit a beret tara 4000 turu katun, ba lahisa kalobaka nouba tu onge iam limiu?” Ba nori e ranga palisir, “A tohit.” ");
INSERT INTO hla_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ba nonei e rangata ranen, “Ga limiu e ma atei noa hasmi?” ");
INSERT INTO hla_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nori i tukuia tara tsi han i Betsaida ba barebana e la merima a toa katun a matakiau. Ba nori e mi piou narien tere Iesu me ranga hatatagi-torir te go sebele u e Iesu i tanen. ");
INSERT INTO hla_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Be Iesu e pile nena a limana katun a matakiau ba te lase nen me la ba ner a tsi han. Be Iesu e kahusuna i matana katun me hatakopena a limanen i tanen me rangatse nen, “Alö e tarem ta ka?” ");
INSERT INTO hla_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ba katun e hala seiena a bakunen me poiena, “Alia e tara hakurukuruhanegu u katun te hula lar, kaba nori e hereri a roei.” ");
INSERT INTO hla_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Be Iesu e hatakopo lelena a limanen i matana katun. Ba poata teka a katun e torohanan tara koru ba matanen e niga pouts talana, ba nonei te tara hanige iena a mamana ka. ");
INSERT INTO hla_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Be Iesu e poiena i tanen, “Alö e moa te go la pouts u i han teka.” Ba nonei e hala pouts mena teien i han i tanen. ");
INSERT INTO hla_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","E Iesu nu katunun tsitsilo i tanen i la u turu han i rehina i Sesaria Pilipai. Nori i la noaia i maroro ba nonei e rangata ranen, “Poata te ranga naria lia a barebana, nori e ngöe rilia esi?” ");
INSERT INTO hla_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ba nori i ranga palisito, “Palair u katun e poier alö e Jon a Tsonun Baptais, na palai e poier alö e Ilaitsa, na palai e poier alö a tai turu propet ti mate hakapa me takei poutsum tara tou mate i tamulö.” ");
INSERT INTO hla_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ba nonei e rangata ranen, “Ga limiu e ngöe milia esi?” Be Pita e ranga palise nen, “Alö e Mesaia te hopu kapin e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Be Iesu e ranga hatagala mera nen, “Alimiu go ma hatei nami lia ta toa ta katun.” ");
INSERT INTO hla_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","E Iesu e tanian hatutsri u katunun tsitsilo i tanen a tou kamits i tanen me poiena, “Alia tu butun katunuma e go sagoho koru romana a kamits pan, bu pal kapan nu pris pan nu tson hihatuts turu Lo e tori hasoala nario romana lia. Alia te atung hamatie riou romana, ba i murina u topisa u lan ba lia te takei poutsugu.” ");
INSERT INTO hla_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nonei e ranga halesala koru merien a ka teka. Be Pita e lu hatalisena e Iesu me tanian ranga hapiu nanen. ");
INSERT INTO hla_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kaba e Iesu e habirits me tara uana turu katunun tsitsilo i tanen ba te ranga hapiu mena e Pita me poiena, “O Satan, la hatalisila. Alö e ma hakats nami a man ka tere Sunahan. Alö e hakats tun talasi nem a man ka tara katun.” ");
INSERT INTO hla_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Be Iesu e ngö rena a barebana nu katunun tsitsilo i tanen e gi la uama i tanen. Ba nonei e poiena, “Te ngilin la gono mena molia ta katun, e ga solopali a peisanen, ba te hanigana te ga sagoho menien u kamitsina te kukute mena neien lia te mar kato uana a katun te soatsena a korusena tara tou mate i tanen, ba te la gono mena molia. ");
INSERT INTO hla_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Taraha, a katun te ka mena u hakats pan te go haka haniga meni a nitoatoa i tanen ba te peits nanen i tar, nonei e na hatia tun noa hase nen romana. Kaba a katun te hatia sile nei a nitoatoa i tanen te ngil koru mena neien lia nu Bulungana u Niga, nonei e sabie nen romana. ");
INSERT INTO hla_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Te ga lueia ta katun a man ka hoboto tara han i puta ba te toan taia ba nena a nitoatoa te ka nitoana, ga mamana ka teka e mar taguhu halona mena noien ime? E moa tala. ");
INSERT INTO hla_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","E moa koru ta ka te ga antunan hala nen ba te lu poutse nei a nitoatoa i tanen. ");
INSERT INTO hla_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","A hei barebana i romana i hapolasa hakapi e Sunahan ba te kato homir. Kaba sanena ta katun e ga matsingolo nio lia nu ranga i tar tara poata a omi teka, ba lia tu butun katunuma e matsingolo has nagen romana tara poata te la gono meguma romana lia u angelo u niga turu ualesala pan tere Tamar.” ");
INSERT INTO hla_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Be Iesu e ranga lelina i taren me poiena, “Alia e hatei hamana rago limiu, a palair u katun e ka ria teka te ma materi romana e popona te gi tara menien a Nipepeito tere Sunahan te butu menama romana a nitagala pan.” ");
INSERT INTO hla_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","3","I murina u tönomo u lan e Iesu e lui e Pita mere Jemis ne Jon me la gono mera nen. Ba nonei e na piou ranen i iasa turu toa u pokus pan ba nori te na ka pepeisar. Ba peisanen e palisina i mataren, bu hasobu i tanen e kankanaha hamanasana ba te hiaka koruna. E moa ta toa ta katun te ga antunan kato hahiaka meni u hasobu te mar hiaka u u hasobu teka. ");
INSERT INTO hla_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Be re Ilaitsa mere Moses u propetir i manasa ti mate e butu ria i mataren me ranga mer e Iesu. ");
INSERT INTO hla_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Be Pita e poieto tere Iesu, “Tson Hihatuts, e nigana te ka ria ra teka. Alam go kato a topisa taluhu, a toa i tamulö na toa tere Moses na toa tere Ilaitsa.” ");
INSERT INTO hla_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","E Pita e mar ranga u teka taraha u katunun tsitsilo i matout koru be Pita e ma ateie nei a saha ka te go ranga nen. ");
INSERT INTO hla_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ba toa koasi e butuna me hoho kap ranen, bu toa u ranga e butu nama i gusuna u koasi me poiena, “Nonei a Pien Tson a tsomi koru i tar teka. Alimiu go hengoe men.” ");
INSERT INTO hla_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ba nori e songots hula tarar ba te ma tara sabieri ta tan ta katun. E Iesu pepeisa te ka gono meren. ");
INSERT INTO hla_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Poata te koul pouts men turu pokus, be Iesu e ranga hatagala mera nen me poiena, “Alimiu go ma hateiemi ta toa ta katun a ka te tare mula limiu, antunana tara poata alia tu butun katunuma te takei hakapa pouts gou romana tara tou mate i tar.” ");
INSERT INTO hla_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nori i hengo u ranga i tanen ba te hiarangrangatar me poier, “Aha nonei u mouna u ranga teka te poiena, ‘Alia e takei pouts gou romana tara tou mate?’” ");
INSERT INTO hla_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ba nori e rangatser e Iesu, “Tara naha te poe menari u tson hihatuts turu Lo e Ilaitsa a propet e ga mam nema romana e Mesaia?” ");
INSERT INTO hla_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ba nonei e ranga palisina, “E Ilaitsa e mam pouts hamana nama te go mi kato hamatskö meni a mamana ka. Kaba tara naha has te ranga nena u Buk u Goagono alia tu butun katunuma e sagohe gou romana a kamits pan ba nori te sigale rio lia? ");
INSERT INTO hla_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Alia e hatei rago limiu e Ilaitsa e la hakapama, ba barebana i kato sile teien a mamana ka hoboto ti ngile ien, ti mar koloto menien turu Buk u Goagono.” ");
INSERT INTO hla_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Poata ti hihitupali merien a palair u katunun tsitsilo, ba nori e tarer a katun a para koru ti gono. Bu tson hihatuts turu Lo e hiangenangena gono mer u katunun tsitsilo. ");
INSERT INTO hla_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ba poata ti tareia a barebana e Iesu ba nori te asingoto korur ba te toan pieta uar i tanen me hatsisoasa naren. ");
INSERT INTO hla_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Be Iesu e rangata ranen me poiena, “Alimiu e hiangenangena silemiu a neha?” ");
INSERT INTO hla_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ba toa katun te kaia i gusuna a barebana e ranga palisina, “Tson Hihatuts, alia e mi piou nia a pien tson i tar i tamulö, taraha a toa mate a omi e seseie nen ba te kato habirue nen. Kaba alö e ma ka mulei. ");
INSERT INTO hla_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Poata te seie nen a mate ba nonei te lapo piou nena a pien i puta, ba runguna pien e poueipoueina bu lihonen te ngilingilikina ba tuanreinen te soei hobotona. Alia e tahul ragula u katunun tsitsilo i tamulö te gi tsuga ba menien, kaba nori e ma antuna lilei.” ");
INSERT INTO hla_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Be Iesu e poieto i taren, “Alimiu u hei barebanar i romana e hahamana korumiu. Alia e soso koru megu a nihahamana i tamilimiu. Mi piou namia a pien i tar.” ");
INSERT INTO hla_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ba nori e mi piou narien i tanen. Ba poata te tare ien e Iesu, ba mate e toan kato hapetepetete hapanena a pien, ba nonei te rusuna turu tsikitsiki ba te hula tabtabililina ba rungnen e poueipoueina. ");
INSERT INTO hla_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Be Iesu e rangatsena e tamanen, “I hangisa te taniaia a markato teka i tanen?” Be tamanen e poiena, “Te pien tetenei noa ien. ");
INSERT INTO hla_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","A poata a para a ka teka e katsin kato hamatie ien ba te harus bene ien u tula nu ramun has. Alö go tatagi rema lam ba te taguhu remu malam, te go antuna u lö.” ");
INSERT INTO hla_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Be Iesu e poiena i tanen, “Tara naha te poe sile mulei lö, ‘Te go antuna u lö’? A katun te ka mena a nihamana e antunan kato nena a mamana ka hoboto.” ");
INSERT INTO hla_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ba tamana pien e toan ranga hapanina me poiena, “Alia e hamanagu. Alö go taguhema a nihamana a tetenei i tar.” ");
INSERT INTO hla_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Be Iesu e tarena a katun a para ti la gugono uama i taren, ba nonei e ranga sisi mena a mate a omi me poiena, “Alö a mate te habiruem na te hasiköem a katun, alia e ranga mego lö, koul ban a pien teka ba lö te ma tatei sei lel korue mien romana.” ");
INSERT INTO hla_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ba mate e ku hohomina ba te kato hapetepetete hapan koruena a pien me koul ba nanen. Ba tuanreina pien e here nei a mate, bu katun u para e poier, “Nonei e mate hakapa.” ");
INSERT INTO hla_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kaba e Iesu e lui a limana pien me las hatakeie nen ba nonei e tuoluna. ");
INSERT INTO hla_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ba poata te tasuia e Iesu i luma, bu katunun tsitsilo i tanen e rangata hamouse ren me poier, “Tara naha te ma antunan tsuga ba mena mulei lam a mate?” ");
INSERT INTO hla_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Be Iesu e poieto i taren, “Alimiu go singo hatala uam tere Sunahan. E moa ta taina ta maroro te ga tatei tsuga ban a mar mate a omi teka.” ");
INSERT INTO hla_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nori i la ban a han teka ba te sila ria i gusuna provins i Galili. Ba nonei e rama neto a barebana e gi atei sil ime te ka ien. ");
INSERT INTO hla_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Taraha, nonei e hatutsir u katunun tsitsilo i tanen me poiena i taren, “Alia tu butun katunuma e na hala naroa romana tara pal tson te na kato hamatie riou romana lia. E kato hamate hakape riou lia, ba i murina u topisa u lan ba lia te takei pouts gou romana.” ");
INSERT INTO hla_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kaba nori i ma atei silei te ranga uaien, ba nori e matouter te gi rangata sei menien. ");
INSERT INTO hla_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nori i na tukuia i han i Kapeneam. Ba poata ti tasu hakapa ien i luma be Iesu e rangata ranen, “Alimiu e hihirangatsi namuma a neha i maroro?” ");
INSERT INTO hla_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kaba nori i ma ranga palise ien, taraha nori i hiangenangena silema esi te panina. ");
INSERT INTO hla_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Be Iesu e gumuna me ngö renama a 12 a katunun tsitsilo me poiena i taren, “A katun te ngilin tsunono panina e ga kato hatetenei korui a peisanen ba te kui haniga beiena u katun hoboto.” ");
INSERT INTO hla_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Ba nonei e luena a toa pien me hatuole nen i mataren. Ba nonei e lukutu nanen me poiena i taren, “A katun te haniga benoi lia a toa tara galapien teka e haniga hase nolia. Na katun te hanige nolia e ma hanige noi lia pepeisa, kaba e here nei e haniga hasena e Sunahan te hale molia.” ");
INSERT INTO hla_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Be Jon e poiena i tanen, “Tson Hihatuts, alam u tarema a katun te poa a solomulö ba te tsuga ba rena u mate u omi. Ba lam u ranga hapiu naten, taraha nonei e ma ka neia tara pala i tarara.” ");
INSERT INTO hla_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Be Iesu e poiena, “Alimiu e ma tatei ranga hapiu namien, taraha a katun te katoena a mirakul ba te poiena a solor e ma antunan ranga homi boroboro nanoi lia. ");
INSERT INTO hla_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","A katun te ma pal ranei ra e haniga rano ra. ");
INSERT INTO hla_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Alia e hatei hamana rago limiu, a katun te ateina alimiu u katun i tar ba te haua ranoi limiu ta tsi ramun, a katun teka e lu hamane nou romana u hamatana i tanen.” ");
INSERT INTO hla_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","E Iesu e ranga noa me poiena, “Sanena ta toa ta katun e ga katsin amusia a toa pien i gusur a galapien teka te hamana uar i tar ba pien te hapolasa ba nanou a nihamana i tanen, e niga balana te gi kits mam meni u katun a toa hatu pan i totolongolona katun teka ba te na harukue rien i gusuna loul. ");
INSERT INTO hla_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na te ga kato homieia a limamulö alö, bara, ngats kots talei ba te ba namen. Taraha, e nigana te go ka meni lö u ualima u korus ba lö te toan luem a nitoatoa te ka nitoana. Kaba e omina te go ka meni lö u huol u ualima ba lö te la uam tara hanin hahuna i hel, turu tula te ma tatei hoseri romana.* ");
INSERT INTO hla_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tara makum teka u kakaminei te nounouer u tuanreina u mate e ma tatei mate roi romana, nu tula e ma hoseri romana.* ");
INSERT INTO hla_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na te ga kato homieia a moumulö alö, bara, ngats kots talei ba te ba namen. Taraha, e nigana te go ka meni lö u mou u korus ba lö te toan luem a nitoatoa te ka nitoana. Kaba e omina te go ka meni lö u huol u mou ba nori te lapo ba naria lö i hel.* ");
INSERT INTO hla_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tara makum teka u kakaminei te nounouer u tuanreina u mate e ma tatei mate roi romana, nu tula e ma hoseri romana.* ");
INSERT INTO hla_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na te ga kato homieia a matamulö alö, bara, has ba talein ba te ba namen. Taraha, e nigana te go ka meni lö u toa u mata ba lö te toan tasu mia tara Nipepeito tere Sunahan. Kaba e omina te go ka meni lö u huol u mata ba nori te lapo ba naria lö i hel. ");
INSERT INTO hla_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tara makum teka u kakaminei te nounouer u tuanreina u mate e ma tatei mate roi romana, nu tula e ma hoseri romana. ");
INSERT INTO hla_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“A man nitiama te butu roa romana turu katun hoboto e here hase roi romana u tula ba te kato haniga rano ra, te kato has uana u sol te haka menari tara kannou ba te kato hanige nen. ");
INSERT INTO hla_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","U sol u ka u niga. Kaba te taia ba nena u sol a nitatasena i tanen, ba lö te mar hatatasena halona pouts mena mien ime? E moa. Na limiu go here hasemi u sol ba limiu te hiakaka haniga hobotomiu.” ");
INSERT INTO hla_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","E Iesu e la ban a han teka me la uana tara provins i Judia me aroho uana tara Ramun olo i Jodan. Bu katun u para e mi gonogono lel ria i tanen, ba nonei e hatuts pon ranen te roron kato uen. ");
INSERT INTO hla_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bu Parisi e la uarima i tanen me mi katsin torohane ren. Ba nori te poier, “U Lo i tarara e haniga nena te go hatapolasa hakapa ba meni a tson a tahol i tanen?” ");
INSERT INTO hla_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Be Iesu e rangata palisina, “Sahu masaka te halari e Moses u tubumilimiu?” ");
INSERT INTO hla_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ba nori e ranga palisir, “E Moses e haniga te go koloto meni a tson u pepa te poiena a hitöl e tapeko, ba te toan hala ba nena a tahol i tanen.” ");
INSERT INTO hla_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Be Iesu e ranga mera nen, “E Moses e koloto beri limiu u masaka teka taraha alimiu e baku-tumiu. ");
INSERT INTO hla_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kaba i mam koru, poata te habuteia e Sunahan a mamana ka, ba nonei e katoeto a katun a tson na tahol. ");
INSERT INTO hla_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Te poe bei e Sunahan, ‘A tson e la ba nena romana e tamanen ne tsinanen ba te na ka gono mena a tahol i tanen. ");
INSERT INTO hla_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ba nori u muntahol teka te here roi romana a toa katun.’ Ba nori te ma here lel roi a elasolana, kaba nori e here taleri a toa katun. ");
INSERT INTO hla_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Na katun e ma tatei puresie nei romana a ka teka te haka gono hakaper e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Poata ti kopis pouts uen i luma, bu katunun tsitsilo i na rangatseto e Iesu tara ka teka. ");
INSERT INTO hla_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ba nonei e poiena i taren, “A katun te pekoena a hitöl i tanen te rama mena neien a tahol i tanen ba te tölena a tana tahol e tsikolona ba te kato homiena a tahol tutun i tanen. ");
INSERT INTO hla_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na tahol te tapolasa hakapa ba nena a tson i tanen ba te hitöl mena tana tson, nonei e hahaloku hasina.” ");
INSERT INTO hla_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","U barebana mi polasa reia a galapien tere Iesu te go sebele merien e Iesu ba te kalala ranen, kaba u katunun tsitsilo i hapiu ren. ");
INSERT INTO hla_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Be Iesu e tarena a ka teka me raharahana me poiena turu katunun tsitsilo, “Haka riam a galapien gi la uama i tar ba limiu te ma hapiu ramien. Taraha, a Nipepeito tere Sunahan e ka uana tara mar katun te kato uana teka. ");
INSERT INTO hla_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Alia e hatei hamana rago limiu, a katun te ma hengo hanige nei u ranga tere Sunahan te mar hengo uana a pien, a katun teka e ma antuna nei te go tasu uen tara Nipepeito tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ba nonei e lukutu ranen me halakopena a limanen i taren me kalala ranen. ");
INSERT INTO hla_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","E Iesu e hatania leli a nilala i tanen ba toa tson e pieta uanama i tanen me mi hatukununa i matanen me rangatse nen, “Tson Hihatuts a niga, aha te go kati lia ba lia te luegu a nitoatoa te ka nitoana?” ");
INSERT INTO hla_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Be Iesu e rangatse nen, “Tara naha te poe memi lö alia a niga? E moa ta toa ta katun te ga niga. E Sunahan a toa puku te nigana. ");
INSERT INTO hla_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Alö e atei silem a man masaka tere Sunahan. E kato uana: ‘Ma hipulimi. Ma tsikolomi. Ma kopkopmi. Ma gamogamomi. Ma gamogamo nami a man ka tara tana katun ba te luemiu. Hapan iam e tamamilimiu ne tsinamilimiu.’” ");
INSERT INTO hla_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ba katun e poiena, “Tson Hihatuts, poata tu pien noaia lia ba te la noana i romana, alia u hengo hanigei a man masaka hoboto teka.” ");
INSERT INTO hla_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Be Iesu e tara uana i tanen me ngil korue nen me poiena, “A toa patu a ka te ka noana. Alö go na haholin a mamana ka hoboto i tamulö ba te hala nem a moni turu katun te moar ta moni, ba lö te na ka memou romana a mamana ka a niga koru i Kolö. Ba lö te toan la gono memu molia.” ");
INSERT INTO hla_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ba poata te hengoeia a katun u ranga teka ba nonei e mata papala koruna ba te la poutsuna me tatagina, taraha nonei e ka mei a man ka man para koru. ");
INSERT INTO hla_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Be Iesu e tara habirits uana turu katunun tsitsilo i tanen me poiena i taren, “U barebanana tara moni e ka mer romana a toukui pan te gi tasu uen tara Nipepeito tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bu katunun tsitsilo i asingoto neto u ranga i tanen. Be Iesu e poe lelina i taren, “A ma tsi galapien, a panna toukui te gi tasu u tara Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","E tutu koruna te ga la u a katunun moni tara Nipepeito tere Sunahan, te mar tutu has uana a kamel te katsin sipina tara tsi tabutu tara salum.” ");
INSERT INTO hla_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ba nori i asingoto koruto me poier, “Gesi tsiponi te antunan ka hanigana?” ");
INSERT INTO hla_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Be Iesu e tara uana i taren me poiena, “A katun tun e ma antuna koru nei tara ka teka, kaba e Sunahan e antunana. E Sunahan e antunana tara mamana ka hoboto.” ");
INSERT INTO hla_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Be Pita e toan poiena i tanen, “Kaba alam u la ba nema a mamana ka hoboto ba te la gono memu molö.” ");
INSERT INTO hla_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Be Iesu e poiena, “U mana koru, na lia e hatei ragi limiu, a katun te hakats uana i tar na turu Bulungana u Niga ba te la ba nenama a luma i tanen tsi u toulanen nu hahinanen ne tsinanen ne tamanen nu hinpien i tanen nu tsikitsiki i tanen, a katun teka e lu poutsena romana a man ka man para lel has tara poata i romana turu luma nu toulanen nu hahinanen nu tsinanen nu hinpien i tanen nu tsikitsiki i tanen. Na nonei e na kamitsbe hase nou romana lia. Ba tara poata te la nama i murimuri, ba nonei te na lue nou romana a nitoatoa te ka nitoana. ");
INSERT INTO hla_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kaba pal para te panir i romana e na katun papala riou romana, na pal para te katun papalar i romana e na pan riou romana.” ");
INSERT INTO hla_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","33","Nori i laia i maroro be Iesu e mam ranen. Bu katunun tsitsilo e asingotor me tokur, taraha nori i la u i Jerusalem. Bu barebana ti murimurima e matoutur. Be Iesu e lu halhal lel rena a 12 a katunun tsitsilo ba te hatei rane ien a man ka te go na butuia i tanen me poiena, “Hengo iam, ara e la uara i Jerusalem, ba alia tu butun katunuma te na hala naria turu pris pan na turu tson hihatuts turu Lo. Ba nori te na kot nario lia ba te poier, ‘Alö go mate,’ ba te hala nario lia tara pala te halhal ria turu Jiu. ");
INSERT INTO hla_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bu katun teka te na hahakos nario romana lia ba te kahuse rio lia ba te lahuse rio lia ba te atung hamatie rio lia. Ba i murina u topisa u lan ba lia te takei pouts guma romana.” ");
INSERT INTO hla_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","E Jemis ne Jon a galapien tere Sebedi i la uama tere Iesu me poier, “Tson Hihatuts, alam e ngilem alö go kato bera mei lam a ka te rangatse milam alö.” ");
INSERT INTO hla_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Be Iesu e rangata ranen, “Aha te ngile milimiu alia go kato berien limiu?” ");
INSERT INTO hla_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ba nori e ranga palise ren, “Poata te lue mia romana lö a nitsunono pan i tamulö na solo pan i tamulö, ba lam e ngilem alö go haniga ba lam te na gum gono memo lö, a toa tara pal matou i tamulö na toa tara pal keruka i tamulö, ba lam te na gohus uamou i tamulö.” ");
INSERT INTO hla_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Be Iesu e poiena i taren, “Alimiu e ma atei silemi a ka te rangata sile milimiu. Alimiu e antunan ua mia tara gotana te na ua goa romana lia ba limiu te na sagohe mou a mar kamits te na sagohe gou lia?” ");
INSERT INTO hla_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ba nori e poier i tanen, “Alam e antunam.” Be Iesu e poiena i taren, “Aa, alimiu e na ua moa tara gotana te na ua goa romana lia ba limiu te na sagohe mou a mar kamits te na sagohe gou lia. ");
INSERT INTO hla_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kaba alia e moa te go tatei hopu kap meni esi te ga gumia tara pal matou i tar na tara pal keruka i tar. E Sunahan talasi te hala nanou u makum teka turu katun ti hamatskö berien.” ");
INSERT INTO hla_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Poata ti hengoa a maloto a katunun tsitsilo a ka teka ba nori e raharaha rer ere Jemis mere Jon. ");
INSERT INTO hla_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Be Iesu e ngö gugono hoboto mera neien i tanen me poiena, “Alimiu e atei silemiu a markato turu barebana halhal turu Jiu. U katun te ngö rarien u tsunono e ranga hamal ria i taren, na pal kapan i taren e pepeito kap hatagala raren. ");
INSERT INTO hla_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kaba alimiu go ma kato uami teka. Ta saha ta katun i tamilimiu te ngilin panina i tamilimiu e go kato hereni a peisanen a katun a tsekotseko-kala i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na ta saha ta katun i tamilimiu te ngilin tsunono malina e go kato hereni a peisanen a tsi kutupin katun. ");
INSERT INTO hla_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Alia has tu butun katunuma u ma la sile mei te gi kuibe meni a barebana alia. E moa. Alia u la silema e mi kui beregu a barebana. Alia u la silema e mi sakahis regu u katun u para tara tou mate i tar.” ");
INSERT INTO hla_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nori i tukuia tara taun i Jeriko. Ba poata e Iesu nu katunun tsitsilo i tanen nu katun u para has i la ban a taun teka, ba toa katun a matakiau te gumna i rehina kalana me singo papala hatatagi silena ta tsi moni. A solonen e Batimias, a pien tson tere Timias. ");
INSERT INTO hla_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ba poata te hengoe ien te la uama e Iesu ni Nasaret ba nonei e tanian kuna me poiena, “O Iesu a Hatutubunei tere Devit a King, alö go tatagi namo lia.” ");
INSERT INTO hla_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bu katun u para i ranga hapiu naten me poier, “Kokomoto.” Kaba nonei e ku hapan hasoalana me poiena, “Hatutubunei tere Devit, alö go tatagi namo lia.” ");
INSERT INTO hla_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Be Iesu e tuhatuol neto me poiena, “Ngöe muma.” Ba nori i ngöeto a katun a matakiau me poier i tanen, “Nigana ba! Takei tala. Nonei e ngöe nolö.” ");
INSERT INTO hla_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ba nonei e his ba neto u hasobu u ngahangaha i tanen ba te supatakeina me la uanama tere Iesu. ");
INSERT INTO hla_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Be Iesu e rangatse ten, “Alö e ngilem alia go kato bei lö aha?” Ba katun a matakiau e ranga palisito, “Tson Hihatuts, alia e ngilin tara poutsugu.” ");
INSERT INTO hla_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Be Iesu e poieto i tanen, “La tala. A nihamana i tamulö e kato haniga poutse lalo lö.” Ba nonei e toan tara poutsuna teka puku, ba te la gono mena e Iesu i kalana. ");
INSERT INTO hla_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Poata ti la hasukusuku ien i Jerusalem ba nori e tuku ria turu han i Betani na i Betpasi te ka ria i rehina a tsi pokus te ngöeri u Pokus tara Roein Olip. Be Iesu e hala neto a elasolana katunun tsitsilo i tanen me poiena i taren, “Alimiu go la uam i han te ka nama ili, ba poata te na butu moa limiu i han ba limiu te na sabie mou a tunan dongki a hitots ti kitsei a lohiana. U katun i namala osa noei a dongki teka. Na puresie muma ba limiu te mi piou namen teka. ");
INSERT INTO hla_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Te rangata noa ta katun, ‘Aha te katoe milimiu a ka teka?’ ba limiu te hateie men, ‘A Tsunono e ngile namen ba nonei te mi toan hala pouts nanoen i teka.’” ");
INSERT INTO hla_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Ba nori e lar me na sabier a dongki ti kits nia tara tamana ba te kana i rehina kalana. Ba poata ti purese ien bu katun ti tuolia i sukusuku e rangata raren, “Aha te purese sile milimiu a dongki?” ");
INSERT INTO hla_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ba nori i hatei rate ien te ranga uama e Iesu. Bu katun i hanigato. ");
INSERT INTO hla_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ba nori e las menari a dongki tere Iesu me haholaser a hasobu a ngahangaha i taren tara dongki, be Iesu e osato i tanen. ");
INSERT INTO hla_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bu katun u para i haholaseto a hasobu a ngahangaha i taren tara kalana, bu palai e ngatse rima a man kalan roei i rehina kalana ba te haholase rien tara kalana. ");
INSERT INTO hla_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","A barebana ti laia i pal mam na barebana has ti lama i pal murimuri i tanian ku hoboto, “Hosana! E Sunahan e kalalena a katun te la menama a nitsunono i tanen. ");
INSERT INTO hla_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","E Sunahan e kalalena a katun te mar pepeito kap uana romana te mar pepeito kap u e tuburara e Devit i iomin. Solosei korue iam e Sunahan!” ");
INSERT INTO hla_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Be Iesu e na tukuta i Jerusalem me na tasuna i Luman Lotu Pan me hula tara uana tara mamana ka. Ba ka e lahi hakapana ba nonei e lakasa merena a 12 a katunun tsitsilo ba nori e takopis uar i Betani. ");
INSERT INTO hla_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ba turu tana u lan, poata ti la pouts men i Betani, be Iesu e besuna. ");
INSERT INTO hla_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ba nonei e tareto u toa u roein fik te kaia i pal lehana ba te ka mena a kala hulung. Ba nonei e na tare nen te go ka menien ta hua. Kaba poata te tukuia e Iesu turu roei teka, ba nonei e tarena a kala puku, taraha a poata turu fik e ma butu noa nei. ");
INSERT INTO hla_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Be Iesu e poieto turu roein fik, “E moa koru ta katun te go tatei nou leli romana a hua i tamulö.” Bu katunun tsitsilo i tanen te hengor. ");
INSERT INTO hla_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Poata ti tuku ien i Jerusalem be Iesu e la uana tara Luman Lotu Pan ba te tanian tsuga rena u katun ti hihol na ti haholia i Luman Lotu Pan. Ba nonei e lapo ba neto u tebol turu katun ti palpalis a moni na e lapo ba hasin u gumgum turu katun ti haholin u kulu. ");
INSERT INTO hla_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na nonei e hapiu hasir u katun ti katsin sila meia a ma tsi ka i taren tara makum i rehina Luman Lotu Pan. ");
INSERT INTO hla_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ba nonei e hatuts reto a barebana me poiena, “U Buk u Goagono e ka mena u ranga tere Sunahan te poiena, ‘A luma i tar a luma te tatei gono ria romana u pal barebana hoboto ba te singo uar i tar.’ Kaba alimiu e kato hakapa here tsipon namien a kioun mous turu kopkop.” ");
INSERT INTO hla_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bu pris pan nu tson hihatuts turu Lo i hengo neto a ka teka ba te tanian sake ner ta maroro te gi atung hamate menien e Iesu. Kaba nori i matoutse ien, taraha a barebana hoboto i asingotoein a man ka te hihatuts nen. ");
INSERT INTO hla_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ba tara lahibong be Iesu nu katunun tsitsilo e la ba ner a taun. ");
INSERT INTO hla_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na tara bongbong koru, poata ti la lel ien i kalana, ba nori e tarer nonei u roein fik e lango hakapa me na noana i polosonen. ");
INSERT INTO hla_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Be Pita e hakats sabe nena a ka te butuia i tanen ba te poiena tere Iesu, “Tson Hihatuts, tara. U roei tu ranga hapiun lö e lango hakapa.” ");
INSERT INTO hla_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Be Iesu e poiena i taren, “Alimiu go hamana mia tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Alia e hatei hamana ragoi limiu, te ranga mena a toa katun u pokus teka ba te poiena, ‘Alö go takei ba lö te lapo ba nem a peisamulö i tasi,’ ba ka teka te butu hamana benoen. Kaba a ka teka e butu talasi noa romana i tanen te go ma hula hakats uaien. Nonei e go hamana u tara ka te ranga nanen e butu hamana nou romana. ");
INSERT INTO hla_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Na poata te singo uami limiu tere Sunahan ba te singo silemiu a toa ka, alimiu go hamana iam te go lu mena mien, ba limiu te lu hamane moen romana. ");
INSERT INTO hla_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Te raharahe mia limiu a tana katun, alimiu go solopale iam a ka a omi te katoen ba te tara poutse men tara poata te tuol mia limiu ba te singo uamiu tere Sunahan. Te go mar kato uam limiu teka, be Tamamilimiu te kana i Kolö te lu ba has nanou u markato u omi i tamilimiu ba te tara pouts rano limiu.* ");
INSERT INTO hla_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kaba te ma solopale moi limiu u markato u omi tara tana katun, be Tamamilimiu te kana i Kolö te ma lu ba has nanoi u markato u omi i tamilimiu.*” ");
INSERT INTO hla_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nori i tuku poutsia i Jerusalem. Ba poata te lalaia e Iesu i iahana Luman Lotu Pan bu pris pan nu tson hihatuts turu Lo na pal kapan i la uamato i tanen. ");
INSERT INTO hla_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ba nori i rangatse ten, “Esi te hanigein te go kato meni lö a man ka teka? Alö e kato memi a man ka teka a nitsunono teresi?” ");
INSERT INTO hla_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Be Iesu e poieto i taren, “Alia e rangata has ragoi limiu u toa u harangata. Te ranga palis moa limiu i tar, ba lia te toan hatei ragoi limiu esi te hale moi lia a nitsunono te go kato meni lia a man ka teka. ");
INSERT INTO hla_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Poata te baptais ria e Jon a barebana, nonei e ka mei a nitsunono tere Sunahan tsi tara katun tun? Ranga palis uamuma i tar.” ");
INSERT INTO hla_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ba nori e hihirangatsir me poier, “Aha te poe rou ra? Te gi poe meni ra, ‘E Jon e ka mei a nitsunono tere Sunahan,’ be Iesu te poie nou, ‘Gaha tsiponi te ma hamana memi limiu e Jon?’ ");
INSERT INTO hla_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na ra e namos poe hasera, ‘E Jon e ka mei a nitsunono tara katun tun.’” Nori i matoutir a barebana, taraha u katun hoboto i poei e Jon a propet hamana tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ba nori i ranga palisito tere Iesu, “Ara e ma atei rei.” Be Iesu e poieto i taren, “Na alia has e ma hatei ragoi limiu esi te hale moi lia a nitsunono te go kato meni lia a man ka teka.” ");
INSERT INTO hla_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Be Iesu e tanian ranga mera nei u katun a man haharoei. Nu toa u haharoei e kato u teka: “A toa katun e lebei a kuin gerep me haka hahise neien a ololo me kahoena a kiou. Tara kiou teka nonei e kui a makum te pita bulbule ria u gerep te gi lu menien u ramun tara gerep te kuieri u wain. Ba nonei e hatakei hasena a luman pepeitokap a pia. Ba nonei e hataratara kap nena a kuin gerep i tanen turu palair u katun me hakuin moni nanen, ba nori te tatei lue riou romana a hapala turu gerep i tanen na nonei e lue nou a hapala. Ba nonei e la uana tara toa han i lehana. ");
INSERT INTO hla_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Poatan tangoho turu gerep e butu hakapa ba nonei e hala nenama a katunun kui te go mi lu a pal gerep i tanen turu katunun taratarakap. ");
INSERT INTO hla_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ba nori e pile kap naren me lahuse ren ba nori e hakopis pukpukue ren. ");
INSERT INTO hla_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ba tamana kuin gerep e hala lel nenama a tana katunun kui i taren, bu katunun taratarakap e singatser a bakunen me kato hamatsingole ren. ");
INSERT INTO hla_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ba tamana kui e hala nenama a tana katunun kui ba nori te atung hamate ren. Ba nori e kato has uar i iesana tara palari u katunun kui u para. Nori i lahusir a palai me atung hamate rer a palai. ");
INSERT INTO hla_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“A toa puku a katun te ka noa. Nonei a pien tson tara tamana kui, a tsomi i tanen. Nonei e hala hase men i taren me poiena, ‘Nori e hapane riou romana a pien tson i tar.’ ");
INSERT INTO hla_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kaba poata ti tareia u katunun taratarakap a pien tson teka, ba nori e hiararangar me poier, ‘Nonei a pien tson tara tamana kui teka te lue nou romana a kuin gerep. Ara gi atung hamatien ba ra te lue rou a kui i tanen.’ ");
INSERT INTO hla_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ba nori e pile kap naren me atung hamatie ren me lapo ba naria a tuanreinen i ielesala tara kuin gerep.” ");
INSERT INTO hla_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Be Iesu e rangatana me poiena, “Gaha te katoe nou a tamana kuin gerep? Nonei e mi atung hamate ranou romana u katun teka ba te hataratara kap nena a kuin gerep teka turu katun u niga. ");
INSERT INTO hla_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Alimiu go mala rit hanige iam u ranga teka turu Buk u Goagono: ‘A hatu ti raman u katunun hatakei tara luma ba te hapiraka ba ner, nonei a hatu te niga balana tara toukuina tara luma. ");
INSERT INTO hla_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","A ka teka a Tsunono te katoen, ba ra te poiera a ka a kapan koru teka.’” ");
INSERT INTO hla_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","A pal kapan turu Jiu i torohanan pile kapin e Iesu, taraha nori i atei sil nonei e hatein u haharoei teka te go haruto menien u markato u omi i taren. Kaba nori i matoutir a barebana ba nori te la ba naren. ");
INSERT INTO hla_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","A palabir u Parisi nu palair u katun tere Herot i hala meri tere Iesu, ba nori e katsin hagögohe ner e Iesu turu ranga i tanen. ");
INSERT INTO hla_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ba nori e la uarima i tanen me poier, “Tson Hihatuts, alam e atei silem alö a katun a mana. Alö e ma hakats silemi a ka te poier a barebana, taraha alö e ma hakats nami a nitsunono tara katun. Alö e hihatuts hamana nem a maroro tere Sunahan. U Lo i tarara e ranga hapiu nena te gi hala meni ra a takis tere Sisa a Gamman Pan, tsi e moa? Ara e tatei hala nera a takis, tsi e moa?” ");
INSERT INTO hla_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kaba e Iesu e atei sil u gamo i taren me poiena, “Tara naha tsiponi te katsin hagögohe sile milimiu alia? Hale mume lia a tsi moni ba lia te tare gen.” ");
INSERT INTO hla_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ba nori e hale rien a toa moni ba nonei e rangata ranen me poiena, “U baku teresi na solo teresi teka?” Ba nori e ranga palisir, “Tere Sisa.” ");
INSERT INTO hla_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Be Iesu e poiena, “Bara, halemi e Sisa a man ka i tanen, na hala hasemi e Sunahan a man ka i tanen.” Ba nori e asingoto koru naren. ");
INSERT INTO hla_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","U Sadiusi i la uama tere Iesu. Nori u pal katun teka e poier a barebana e ma takei poutsri romana i murina a tou mate i taren. ");
INSERT INTO hla_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ba nori e poier i tanen, “Tson Hihatuts, e Moses e koloto beri ra a lo teka: ‘Te ga mate ba nia a tson a tahol i tanen ba te moana ta pien, ba toulana tson teka te tatei tölena a amoba, ba nori te hatuhaner romana ta pien te ngö rari romana a solona tson te mate.’ ");
INSERT INTO hla_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bara, tara toa poata a tson a hamua te ka mei a elonomo a toulanen e hitöl mei a tahol. Kaba a tson e mate ba te moana ta pien i tanen. ");
INSERT INTO hla_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ba hatut e tölena a amoba ba nonei e mate hasina ba te moana ta pien i tanen. Ba hahelapisa e kato has uana i iesana. ");
INSERT INTO hla_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","U mun toulana elahit hoboto i töli a tahol teka me mater, ba te moana ta pien i taren. Ba i muriren ba tahol e mate hasina. ");
INSERT INTO hla_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na tara poata te takei pouts ria romana a barebana tara tou mate i taren, ba nonei te tahol uanou romana teresi? Taraha, nori u mun toulana elahit hoboto i töle ien.” ");
INSERT INTO hla_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Be Iesu e poiena i taren, “Alimiu e mar ranga uamiu teka ba limiu te ma matskömi. Taraha, alimiu e ma atei silemi u Buk u Goagono na nitagala tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","U katun te takei pouts ria romana tara tou mate i taren e ma hitölri romana, kaba nori e hereri romana u angelo ri Kolö. ");
INSERT INTO hla_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na turu ranga te poiena a katun e takei poutsuna romana tara tou mate i tanen, alimiu go mala rit hanige iam a makumun ranga i iahana u buk tere Moses te hatei nena a tsi roei te kulupu. Tara makum teka e Sunahan e ranga mei e Moses me poiena, ‘Alia a Sunahan tere Abraham na alia a Sunahan tere Aisek na alia a Sunahan tere Jekop i romana.’ ");
INSERT INTO hla_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","U ranga teka e poiena nonei e ma Sunahan uanei turu katun u mate. E moa. Nonei a Sunahan turu katun te toatoar. Ere Abraham mere Aisek ne Jekop i mate hakapa, kaba nori i ma taiai. Taraha, u ranga teka e poiena nori e toatoa noar. Alimiu e tutu korumiu.” ");
INSERT INTO hla_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","A toa tson hihatuts turu Lo e hengo ti hiarangrangata uen. Ba nonei e hengo sabiena te ranga palis haniga meni e Iesu u Sadiusi, ba nonei e la hasuksuku nama me rangatse nen, “Sahu masaka te panina turu masaka hoboto tere Sunahan?” ");
INSERT INTO hla_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Be Iesu e ranga palisina, “Nonei u masaka u kapan koru teka: ‘Hengo iam, u barebana i Israel. E Sunahan a Tsunono i tarara a toa puku a Tsunono. ");
INSERT INTO hla_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Alö go ngil koru a Tsunono i tamulö e Sunahan turu tori hoboto i tamulö na turu namnamei hoboto i tamulö na turu hakhakats hoboto i tamulö na tara nitagala hoboto i tamulö.’ ");
INSERT INTO hla_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na u hahuoluna u masaka u kapan teka: ‘Alö go mar ngil koru meni a tana katun te mar ngil koru mena milö a peisam.’ E moa tu tan tu masaka te ga mar pan u te mar pan uana u huol u masaka teka.” ");
INSERT INTO hla_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ba tson hihatuts turu Lo e poiena tere Iesu, “U mana koru, Tson Hihatuts. Alö e ranga hamana nemula e Sunahan a toa puku, na e moa lel ta tan ta sunahan. ");
INSERT INTO hla_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na katun e go ngil koru e Sunahan turu tori hoboto i tanen na turu hakhakats hoboto i tanen na tara nitagala hoboto i tanen. Na nonei e go mar ngil koru meni a tana katun te mar ngil koru mena neien a peisanen. Na katun te kukutiena u huol u masaka teka e niga bala nena a katun te hats mena nei u benö u ohots tere Sunahan na te kato hasena u tana u mar hats.” ");
INSERT INTO hla_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Be Iesu e hengoena te ranga palis haniga uaien ba nonei e ranga menen, “Alö e ma lehana ba nemi a Nipepeito tere Sunahan.” Kaba u katun hoboto i matoutsi te gi rangata lel meni e Iesu tu taina tu harangata. ");
INSERT INTO hla_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Poata te hihatutsia e Iesu tara Luman Lotu Pan me rangatana, “Taraha te poe sileri u tson hihatuts turu Lo e Mesaia a hatutubunei romana tere Devit a King? ");
INSERT INTO hla_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","E Devit noa has te rangaia tara nitagala turu Namnamei u Goagono ba te poiena, ‘A Tsunono e poei tara Tsunono i tar, Gumia teka tara pal matou i tar antunana tara poata te hale goi lia lö u katun te pakoe rio lö ba lö te na pita-puta ramoen.’ ");
INSERT INTO hla_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","E Devit te ngöei a katun teka ‘A Tsunono.’ Gime te mar hatubuna uana e Mesaia tere Devit?” Kabe moa ta katun te ga ranga palis. (Matiu 23:1-36, Luk 20:45-47) U barebana u para koru teka i sasala mei ti hengo meni e Iesu. ");
INSERT INTO hla_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ba nonei e hatuts raten me poiena, “Hanei sile iam u tson hihatuts turu Lo. Nori e ngilin hula la mer a hasobu a ngahangaha i taren, na nori e ngil haser u barebana te ka ria tara toana gi hapan ren. ");
INSERT INTO hla_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nori e ngilin gum has ria turu gumgum tara pal kapan i luman lotu na turu gumgum tara pal kapan tara kannou pan. ");
INSERT INTO hla_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nu tson hihatuts turu Lo e roron katoer u singon lotu u ngahangaha tara rungren tun, ba te lube tsiponeri a peisaren a man ka turu amoba. Kato uana teka ba nihahuna i taren te pan koruna romana.” ");
INSERT INTO hla_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","E Iesu e gamon gum halehana ban a makum turu moni i iahana Luman Lotu Pan ba te tara uana turu barebana ti lapo hongein a monin hitaguhu turu bokisin moni. Bu katunun moni u para te lapo hongo ner a moni pan. ");
INSERT INTO hla_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ba toa amoba te moa koru ta ka i tanen e la nama me mi lapo hongo nena a tsi huol a tsi toea. ");
INSERT INTO hla_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Be Iesu e ngö gugono renama u katunun tsitsilo i tanen me poiena i taren, “Alia e hatei hamana rago limiu, a amoba teka e hala nelala a moni tara bokisin moni te saluhena tara moni te hala nelila a barebana hoboto. ");
INSERT INTO hla_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Taraha, nori hoboto e hala lila turu moni te kurapana i taren, kaba nonei a tahol e moa lel ta tsi moni i tanen. A tsi huol puku a tsi makumun monina tara kannou te lapo hongo hakapa nala len.” ");
INSERT INTO hla_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Poata te la ba nia e Iesu a Luman Lotu Pan, ba toa katunun tsitsilo i tanen e poieto, “Tson Hihatuts, ruto turu hatu pan soku teka na turu luma u niga koru teka.” ");
INSERT INTO hla_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Be Iesu e ranga palisina, “Alö e tarem u luma pan soku teka? E moa ta toa ta hatu teka te ga ka lelia romana tara makum i tanen. Nori u hatu hoboto teka e lapo raria romana i puta.” ");
INSERT INTO hla_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","E Iesu e gumia turu Pokus tara Roein Olip ba te tara uana i Luman Lotu Pan. Ere Pita mere Jemis ne Jon ne Endru i ka pepeisa gono meien me poier i tanen, “Hatei ramei lam i hangisa te butuna romana a ka teka, na hatei has ramei lam a hiharuts te haruto nanou a poata te ga butu mei romana a man ka teka.” ");
INSERT INTO hla_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Be Iesu e tanian hatuts ranen ba te poiena, “Hanei sil iam te go gamo meri ta katun alimiu. ");
INSERT INTO hla_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","U katun u para e la rima romana ba te ngöe roi a peisaren a solor. Ba man toa toa i taren te poier romana, ‘Alia e Mesaia,’ ba nori te gamo ria romana tara katun a para. ");
INSERT INTO hla_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Na alimiu go ma tokumi tara poata te hengoe mia romana limiu te ling uana a man hiatatung i sukusuku nu habulungana tara man pula i lehana. A man ka teka e butu noa talasina romana, kaba a poata i puta e ma kapa noa noi. ");
INSERT INTO hla_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","A toa han e hiatatung mena romana a tana han, na palair u hun katun e hiatatungur romana. Bu nun te gasir romana tara han a para, na bes pan e ka hasina romana. A man ka teka e hereri romana a kamits tutun tara tahol te katsin posana. ");
INSERT INTO hla_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Alimiu go hanei iam, taraha u katun e pile kap rariou romana limiu ba te hala mera rilimiu turu kot. Ba nori te lahus rariou romana limiu tara man luman lotu turu Jiu. Na limiu e na tuol mia romana i matar u gamman nu king, taraha alimiu e hamana mia i tar, ba limiu te hatei ramou ien u Bulungana u Niga. ");
INSERT INTO hla_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nu Bulungana u Niga e gi rarare mamia romana turu han hoboto. ");
INSERT INTO hla_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na poata te pile kap rarien limiu ba te las mera rilimiu turu kot, alimiu go ma toku mam memi a man ka te na ranga namou limiu. Poata te butuna romana a poata a omi teka ba limiu te poiemiu a man ranga te hatei ranoi limiu e Sunahan. Taraha, u ranga te poie milimiu romana e ma ranga uanei i tamilimiu. Nonei e tuhana nama romana turu Namnamei u Goagono. ");
INSERT INTO hla_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","U katun e hala rer romana u toularen turu katun te atung hamate raren romana, bu tamaren te kato has uariou i iesana tara galapien i taren. A galapien e hiatatung mer romana u tamaren nu tsinaren ba te hala mera rien turu katun te atung hamate raren romana. ");
INSERT INTO hla_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bu katun hoboto te pakö sil rari romana limiu alia. Kaba u katun te pile kap ner romana a markato tere Sunahan tara poata a omi teka ba te ma hapolasari, e Sunahan e lu pouts mera noien i tanen.” ");
INSERT INTO hla_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Be Iesu e poiena, “Alimiu e taremiu romana a ka a omi koru te tuoluna romana tara makum te hagoagono ba nerien.” (A katun te ritena u ranga teka e ga hakats hanigein te mouna uanen.) “Ba pala te ka ria romana i Judia e gi bus romana tara pokus. ");
INSERT INTO hla_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Na katun te kana romana i apu i tanen e moa te ga tatei tasu uen i luma i tanen ba te na lu bena ta tsi ka. ");
INSERT INTO hla_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na katun te kana romana i kui e ma tatei gala pouts nei i han ba te na luena u hasobu u ngahangaha i tanen. ");
INSERT INTO hla_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Haromana koru tara tohaliou te pikar romana na tara tohaliou te hasus rer a galapien tara poata teka. ");
INSERT INTO hla_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Alimiu go singo uam tere Sunahan ba ka teka te ma butu mena mei romana a poata turu hamuri. ");
INSERT INTO hla_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","U kamits tara poata teka e pan saluhe nena romana u kamits hoboto tara poata i manasa, tara poata i mam koru te katoeia e Sunahan a mamana ka ba te noana tara poata i romana. Na tara poata hoboto has i murimuri e moa lel ta kamits te ga kato u teka. ");
INSERT INTO hla_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kaba a Tsunono e hopu kap hakapein te go makum u romana a poata teka. Sanena e ga moa, ba te moa hasina ta toa ta katun te ga tatei ka haniga romana. Kaba e Sunahan e peko menei romana a poata teka te go taguhu merien u katun te hopu kap reien. ");
INSERT INTO hla_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Alimiu go ma hamanemi ta katun te ga poei i tamilimiu, ‘Tara iam, e Mesaia teka,’ tsi ta katun te ga poei, ‘Tara iam, nonei e kana i tium.’ ");
INSERT INTO hla_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","U Mesaia gamogamo nu katun u gamogamo te ngöeri romana a peisaren u propet tere Sunahan e butur romana. Ba nori te katoer romana u hiharuts pan na man mirakul. Taraha, te gi antuna uen ba nori te gamo rer romana u katun has te hopu kapir e Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Alimiu go hanei iam. Alia e hatei ragu lei limiu a mamana ka hoboto i mam tara poata te ga butu ien romana.” ");
INSERT INTO hla_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Be Iesu e poiena, “Tara man lan i murina tara poata turu kamits teka ba pitala te kuhilina romana na tsihau e ma piri nei romana. ");
INSERT INTO hla_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nu pitopito e rus rima romana i kolö, na mamana ka a tagala ni kolö e gasir romana ba te tasula ba ner a man makum i taren. ");
INSERT INTO hla_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ba barebana te tare riou romana alia tu butun katunuma te butu guma romana turu koasi ba te la meguma a nitagala pan nu ualesala pan. ");
INSERT INTO hla_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ba lia te hala regu romana u angelo turu han hoboto i puta ba nori te na gono rarima u katun te hopu kapir e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","E Iesu e ranga lel me poiena, “Alimiu go hatatei niam u haharoeina turu ngal. Poata te suluna u ngal, ba limiu te atei silemiu a poatan nou turu ngal e sukusukuna. ");
INSERT INTO hla_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ne kato has uana i iesana, poata te tare mia romana limiu a man ka hoboto teka te ranga nagu lalia, ba limiu te atei sile mou a poata e sukusuku koru nama. ");
INSERT INTO hla_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Alia e hatei hamana rago limiu, a man ka hoboto teka e butuna romana i mam tara tou mate tara palair u barebana te toatoar tara poata teka. ");
INSERT INTO hla_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","U kolö nu puta e taia hakapar romana, kaba u ranga i tar e moa koru te go tatei taia uen romana.” ");
INSERT INTO hla_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Be Iesu e poiena, “Kaba e moa ta katun te ga atei sil u lan tsi a aua te butu nama romana a man ka teka. U angelo ri Kolö e ma ateiri na lia a Pien Tson tere Sunahan e ma atei hasgi. E Tamar peisa te ateina. ");
INSERT INTO hla_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Hanei iam, na tara kap haniga iam. Taraha, alimiu e ma atei silemi i hangisa te butu nama romana a poata teka. ");
INSERT INTO hla_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","A poata teka e kato uana romana tara katun te his uana i lehana. Ba nonei te hataratara kap ranei u tsekotseko-kala i tanen a man ka i tanen, ba te hala ranei a man toa toa a man toukui i taren. Ba nonei te hateiena a katunun taratarakap tara tamana te go pepeito haniga uen. ");
INSERT INTO hla_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Na limiu go tara kap haniga iam, taraha alimiu e ma atei silemi i hangisa te la nama romana a katun terena luma. Nonei e la toum menama a lahibong tsi a bong roto tsi a gusuna bong tsi a lunlan. ");
INSERT INTO hla_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Te go songots la uamen, e omina te go mi sabe merien limiu ba te sohomiu. ");
INSERT INTO hla_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A ka te ranga mera gilia alimiu e la has uana turu katun hoboto: tara kap haniga iam.” ");
INSERT INTO hla_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","U huol u lan patu ba kannouna turu Paska turu Jiu te butu nou, na kannou has te noue ria a barebana u beret te moa ta yis. U pris pan nu tson hihatuts turu Lo i sake ta maroro te gi pile kap hamous halona menien e Iesu ba te atung hamate ren. ");
INSERT INTO hla_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ba nori e poier, “Ara e moa te gi tatei kato menien tara poata turu kinalala, taraha a barebana e namos hiagetagetar.” ");
INSERT INTO hla_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","E Iesu e kaia i Betani tara luma tere Saimon te ka mei a toba i manasa. Ba tara poata ti nou ien, ba toa tahol e tasu menama a tsi botolo tsikitsiki a tsi niga te ka mei u uapi u masi te antunaia tara hihol pan koru na ti ngöei u nat. Ba nonei e bute iena a boloto me hakis nena nonei u uapi u masi teka i bakune Iesu. ");
INSERT INTO hla_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ba palair u katun ti kaia teka i raharahato me hiararangar, “Tara naha tsiponi te tsu ba mela lei a tahol u uapi u masi? ");
INSERT INTO hla_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Taraha, a hihol turu uapi teka e saluhena tara 300 denarius, a holina turu 300 u lan. Sanena te hahol nala len sane nonei e tatei hala ranei a moni u katun ti moa ta moni.” Ba nori i ngene ten. ");
INSERT INTO hla_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kaba e Iesu e poei, “Haka ba niam. Tara naha tsiponi te ngena memien limiu? Nonei e katoe lala a ka a niga koru i tar. ");
INSERT INTO hla_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","U katun ti moa ta moni e ka gono nitoa mera riou limiu, ba limiu te tatei taguhu ramen tara poata te ngil mia limiu. Kaba alia e ma ka gono nitoa lel mera goi limiu. ");
INSERT INTO hla_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A tahol teka e katoe lala a ka te antunan kato nanen. Nonei e hakis nelala u uapi u masi turu tuanrei i tar i mam tara poata te gi na kaho nien romana lia. ");
INSERT INTO hla_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Alia e hatei hamana rago limiu, ime te rarare roa romana u Bulungana u Niga, tara mamana han hoboto i puta, ba nori te rarare riou a tahol teka ba barebana te hakats sile riou a ka a niga teka te katoe lalen.” ");
INSERT INTO hla_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","E Judas Iskeriot, a toa tara 12 a katunun tsitsilo, e la u turu pris pan, taraha nonei e na katsin harutein e Iesu i taren. ");
INSERT INTO hla_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ba nori i sasala koru mieto ti hengo meni a ka teka me ranga hamana ner te gi hala menien ta moni. Be Judas e tanian sake nena ta maroro te go na haruto menien e Iesu turu katun teka. ");
INSERT INTO hla_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Turu lan tutun tara kannou te noue ria u beret te moa ta yis, u lan te atunge ria u tunan sipsip tara kannouna turu Paska, bu katunun tsitsilo e rangatser e Iesu, “Alö e ngilem alam go la u ime ba te na kato hamatsköem a kannou i tamulö turu Paska?” ");
INSERT INTO hla_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Be Iesu e hala nena a elasolana katun i tanen me poiena i taren, “La uam i iahana taun ba toa tson te soatsena a tabeli te ka mena u ramun e tupala ranou limiu. ");
INSERT INTO hla_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kukute iam tara luma te tasu nen ba limiu te poiemiu tara katun terena luma, ‘Tson Hihatuts e poiena, Ime te kana a rum i tar te nou gono megoa lia u katunun tsitsilo i tar a kannouna turu Paska?’ ");
INSERT INTO hla_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ba nonei te toan haruto ranoi limiu a toa rum pan te kana i iasa te haholasa hakape lila na te kato hamatskö hakape lila. Ba limiu te na kato hamatskö mame mou a kannou i tarara tara makum teka.” ");
INSERT INTO hla_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bu katunun tsitsilo i lato me la uar i taun, ba nori e na sabier a mamana ka te kato u te ranga uama e Iesu. Ba nori e kato hamatsköer a kannouna turu Paska. ");
INSERT INTO hla_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","A ka e lahibong hakapa be Iesu e la gono memato a 12 a katunun tsitsilo. ");
INSERT INTO hla_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na tara poata ti nou ien turu tebol be Iesu e poiena, “Alia e hatei hamana rago limiu, a toa i tamilimiu e haruto nenoa lia turu pakö i tar, a katun te nou gono mera nora.” ");
INSERT INTO hla_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bu katunun tsitsilo e toku talar me rangata uase ren, “Esi, alia romana?” ");
INSERT INTO hla_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Be Iesu e ranga palisito, “Nonei a toa tara 12 a katun teka te kana gono menei lia a beret tara toa pelet. ");
INSERT INTO hla_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Alia tu butun katunuma e mar mate uagou te ranga u u Buk u Goagono. Kaba a niomi pan koru tara katun teka te haruto nenoa lia turu pakö i tar. Sanena ti ma posei nonei a katun teka, sane niga balana i tanen.” ");
INSERT INTO hla_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na tara poata ti nou ien, be Iesu e lueto a beret me haniga uana tere Sunahan me poseposie nen me hala rane ien. Ba nonei e poiena, “Lu iam. Nonei u tuanrei i tar teka.” ");
INSERT INTO hla_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ba nonei e lu lelena a gotana wain me haniga uana tere Sunahan me hala rane ien, ba nori e ua hoboto ria i tanen. ");
INSERT INTO hla_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Be Iesu e poieto, “Nonei u rahatsing i tar teka te kato hatagale nou u rangan kits u tsimus tere Sunahan na te takis bera nou u katun u para. ");
INSERT INTO hla_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Alia e hatei hamana rago limiu, alia e ma tatei ua lel korue goi romana u wain antunana tara poata te ue gia romana lia u wain u tsimus tara Nipepeito tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ba poata ti köme ien u toa u köman lotu, ba nori e la uar turu Pokus tara Roein Olip. ");
INSERT INTO hla_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Be Iesu e poieto i taren, “Alimiu hoboto e matout mou ba te la ba nemou lia, taraha e Sunahan e mar ranga u teka turu Buk u Goagono: ‘Alia e atunge gou romana a katunun taratarakap bu sipsip te bus satar romana.’ ");
INSERT INTO hla_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kaba i murina te hatakei poutse noa romana e Sunahan alia tara tou mate i tar, ba lia te mam ragou limiu i Galili.” ");
INSERT INTO hla_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Be Pita e poieto i tanen, “U katun hoboto teka e la ba toum nariou lö, kaba e moa koru te go la ba meni lia alö.” ");
INSERT INTO hla_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Be Iesu e poieto tere Pita, “Alia e hatei hamane golö, i mam te kekeretskö hahuol noa a keriau a tson i bong teka, ba lö te holis namou te go atei sil meni lö alia tara topisa poata.” ");
INSERT INTO hla_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Be Pita e ranga palis hatagalato, “Alia e moa koru te go holis menoi lö, noahasina te mate gono mena goi lia alö.” Bu katunun tsitsilo hoboto i mar ranga uato i iesana. ");
INSERT INTO hla_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nori i na tukuia tara toa makum te ngöeri Getsemani, be Iesu e poieto turu katunun tsitsilo i tanen, “Gum mia teka tara poata te singo gia lia tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ba nonei e la merena ere Pita mere Jemis ne Jon, ba torinen e tanian asingotona me toku hapan koruna. ");
INSERT INTO hla_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ba nonei e poieto i taren, “A peisar e tiama koru mena a nitatagi pan. Ka bumia teka ba te taratara kapmiu.” ");
INSERT INTO hla_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ba nonei e gamon la lelina me tuhopu nana turu tsikitsiki. Ba nonei e singona tere Sunahan te go antuna uen ba te hapiu nena te ga butu u a poata tara kamits i tanen. ");
INSERT INTO hla_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ba nonei e poieto, “O Tamar, alö e antunam tara mamana ka hoboto. Alö go lu ba nei lia a kamits teka. Kaba alö go ma kato uai turu ngil i tar. Alö go kato u turu ngil i tamulö.” ");
INSERT INTO hla_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ba nonei e kopisina me sabiena a elapisa a katunun tsitsilo ba te sohor. Ba nonei e poieto tere Pita, “O Saimon, alö e sohom? Alö e ma antunami te go kalata u tara toa aua puku?” ");
INSERT INTO hla_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ba nonei e poiena i taren, “Tara kap iam ba te singo uamiu tere Sunahan. U hiamus u omi e namos butuna i tamilimiu. A namnamei i tamilimiu e ngilin katoena a ka teka, kaba u tuanrei i tamilimiu e ma tagala nei.” ");
INSERT INTO hla_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ba nonei e la pouts lelito me singona tere Sunahan turu toa puku u mar singo. ");
INSERT INTO hla_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ba nonei e la pouts uato turu katunun tsitsilo me sabe ranen ba te sohor, taraha nori i topi koru. Ba nori e ma atei sileri aha te gi poien i tanen. ");
INSERT INTO hla_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Na poata te kopis hatopisa pouts ien, ba nonei e poieto i taren, “Alimiu e soho noamiu ne husa noamiu? E noa tala. A poata e butu hakapa. Ruto mula. Alia tu butun katunuma e hala tala naria tara nitagala turu katun u omi. ");
INSERT INTO hla_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Takei iam, ba ra te lara. Ruto iam, a katun te haruto nano lia turu pakö i tar e tuku hakapa.” ");
INSERT INTO hla_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","E Iesu e ranga lel noa be Judas a toa tara 12 a katunun tsitsilo e tukuto. Ba nonei e peigi remato u katun u para ti soatsema a man kilatan hiatatung na man baru. U pris pan nu tson hihatuts turu Lo na pal kapan ti hala ramen. ");
INSERT INTO hla_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na katun te haruto nanou e Iesu e hopu kap mamin a ka te mi katoe noen. Nonei te hatei hakapa mamir u katun te ga peigi ramen romana me poiena, “A katun te mutsi nagoa lia i abuabunen, nonei a katun te ngilin lu nami limiu. Pile kap niam ba limiu te peige men ba te tara kap haniga namen.” ");
INSERT INTO hla_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Be Judas e tuku hakapato me la uana tere Iesu me poiena, “Tson Hihatuts.” Ba nonei e mutsi nanen i abuabunen. ");
INSERT INTO hla_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ba nori e pile naren ba te pile hakarapoto naren. ");
INSERT INTO hla_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kaba toa katun te tuol hasukusuku e lous u kilatan hiatatung i tanen me katsin atungena a katunun kukui puku tara tsunono pan turu pris, ba nonei e ngats ba nena a talinganen. ");
INSERT INTO hla_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Be Iesu e rangata raten, “Alimiu e la memuma a man kilatan hiatatung na man baru te go mi pile kap mena milia ba limiu te poiemiu alia e heregi a kopkop? ");
INSERT INTO hla_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Turu mamanu lan alia u ka gono merio limiu tara Luman Lotu pan ba te hihatutsugu, ba limiu te ma pile kap nami lia. Kaba a ka teka e butu silena te ga mana u u Buk u Goagono.” ");
INSERT INTO hla_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bu katunun tsitsilo hoboto i tanen i la ba naten me busur. ");
INSERT INTO hla_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Ba toa katun a hitots e kukutieto e Iesu ba te kope nei a peisanen u labalaba u lamelame tun. Ba nori e hiapilepile naren ba nonei e la ba neto u labalaba te kopen me bus belobelosona. ");
INSERT INTO hla_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nori i na piou nia e Iesu tara tsunono pan turu pris, bu pris pan na pal kapan nu tson hihatuts turu Lo e gono hobotor. ");
INSERT INTO hla_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Be Pita e murimuri halehanana me la uana tara luma tara tsunono pan turu pris, ba te na kana i pal porina luma i iahana ololo. Ba nonei e na gum gono merena u tson taratarakap ba te meimeina turu tula. ");
INSERT INTO hla_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bu pris pan nu katun hoboto ti kaia turu Kot Pan e sakier ta elasolana ta katun te gi kot mei e Iesu tu toa tu mar ranga te gi atung hamate sila nien e Iesu. Kaba nori i ma sabei ta elasolana. ");
INSERT INTO hla_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","U katun u para i gamoin e Iesu, kaba man ranga i taren e ma boei tu toa. ");
INSERT INTO hla_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Bu palair u katun e takeir me gamo ner e Iesu me poier, “Alam u hengo nonei e poei, ‘Alia e kato lupegu romana a luma tere Sunahan teka ti kui u katun, ba i murina u topisa u lan ba lia te kuie gou a taina luma te ma antunan kuie nei a katun.’” ");
INSERT INTO hla_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kaba a man ranga i taren e ma bo hasei tu toa. ");
INSERT INTO hla_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ba tsunono pan turu pris e tuoluna i mataren hoboto me rangatsena e Iesu, “Alö e ma ranga palismi? Gaha nonei te kot meri u katun teka alö?” ");
INSERT INTO hla_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Be Iesu e kokomotona me ma poe nei ta ka. Ba tsunono pan turu pris e rangata lele nen, “Alö e Mesaia, a Pien Tson tere Sunahan?” ");
INSERT INTO hla_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Be Iesu e poiena, “Nonei alia. Alimiu e tare mou romana alia tu butun katunuma ba te gum goa tara pal matou tere Sunahan a tagala koru, ba lia te la guma turu koasi i kolö.” ");
INSERT INTO hla_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ba tsunono pan turu pris e kise iena u hasobu i tanen me poiena, “Ara e ma tatei ngö lele rimei ta katun te ga kot gono meien. ");
INSERT INTO hla_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Alimiu e hengo hakape mula nonei e poe lala nonei e ka mena a nitsunono tere Sunahan. Nonei u ranga u omi koru teka. Alimiu e poiemiu aha?” Ba nori e poe hoboter, “Nonei e gi atung hamati.” ");
INSERT INTO hla_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ba palai e tanian kahuser e Iesu me pou kap ner a matanen me muke ren. Ba nori e poier i tanen, “Poa talei esi te muke lalo lö.” Bu tson taratarakap e gono beie ren me atunge ren. ");
INSERT INTO hla_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","E Pita e ka noaia i puta i pal pori, ba toa taholun kui tara tsunono pan turu pris te la nama. ");
INSERT INTO hla_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Poata te tare ien e Pita ba te meimeina ba nonei e ruto hasukusukuna me mareie nen me poiena, “Alö has tu ka gono mei e Iesu ni Nasaret.” ");
INSERT INTO hla_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Be Pita e holisina me poiena, “Alia e ma ateigi a ka te ranga nemu lö.” Be Pita e na kana i rehina tamana tara ololo. ");
INSERT INTO hla_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ba nonei a taholun kui e tare nen me ranga lelina turu katun ti tuolia i sukusuku me poiena, “Nonei a toa katun tere Iesu teka.” ");
INSERT INTO hla_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kaba e Pita e holis lel. Ba tsitabubun poata patu bu katun ti tuolia i sukusuku e poier tere Pita, “Alö koru a toa katun tere Iesu, taraha alö has a katununa i Galili.” ");
INSERT INTO hla_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ba nonei e poiena, “E Sunahan e tatei hahune nolia te go ma ranga hamana uai lia. Alia e ma atei silegi nonei a katun teka te ranga nemi limiu.” ");
INSERT INTO hla_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ba toa keriau a tson e songots kekeretskö hahuoluna. Be Pita e hakats pouts neto te mar ranga menien e Iesu, “I mam te kekeretskö hahuol noa a keriau a tson ba lö te holis hatopisa namou te ma atei sil mena milö alia.” Ba nonei e hakats pouts nena a ka teka me tabena. ");
INSERT INTO hla_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na tara bongbong koru bu pris pan na pal kapan nu tson hihatuts turu Lo nu katun hoboto turu Kot Pan i hagumuto. Ba nori i kits kap neto e Iesu me la meren me hala narien tere Pailat a Gamman. ");
INSERT INTO hla_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Be Pailat e rangatse ten, “Alö a king turu Jiu?” Be Iesu e ranga palise ten, “Alö a tuam ba te rangam.” ");
INSERT INTO hla_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bu pris pan e kot meri e Iesu a mamana ka a para. ");
INSERT INTO hla_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Be Pailat e rangata lele ten, “Alö e ma ranga palismi? Alö e ma hengoemi a mamana ka teka te kot merien lö?” ");
INSERT INTO hla_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Be Iesu e ma palis lele nei tu toa tu ranga, be Pailat e asingoto koruto. ");
INSERT INTO hla_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tara poata tara kannouna turu Paska, e Pailat e roron pureseir a man toa man karabus ti rangata sil a barebana. ");
INSERT INTO hla_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na tara poata teka a palair u katun ti hiatatung mei a gamman na ti hihipuli, nori i kaia tara karabus. Na toa tson a solonen e Barabas e ka gono mera ien. ");
INSERT INTO hla_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ba barebana u para e na gono ria tere Pailat me rangatse ren te go kato uen te roron mar kato uen i taren. ");
INSERT INTO hla_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Be Pailat e rangata raten me poiena, “Alimiu e ngilemiu alia go purese beri limiu a king turu Jiu?” ");
INSERT INTO hla_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nonei e atei sil u pris pan i hala mei e Iesu i tanen taraha nori i hiomi. ");
INSERT INTO hla_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bu pris pan i hasingoto reto a barebana te gi rangata hoboto sil meni te go hapurese beme rien e Pailat e Barabas peisa. ");
INSERT INTO hla_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Be Pailat e rangata lel raten, “Ime te mar kato mena goi lia a katun te ngöe milimiu a king turu Jiu?” ");
INSERT INTO hla_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ba nori i ku pouts uato i tanen, “Tapala nia tara koruse!” ");
INSERT INTO hla_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Be Pailat e rangata raten, “Tara naha? A saha ka a omi te katoen?” Ba nori e ku hapan lelir, “Tapala nia tara koruse!” ");
INSERT INTO hla_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Be Pailat e ngilin kato haniga rena a toriren me hapurese bera neien e Barabas. Ba nonei e halahus neto e Iesu me hala nanen i taren te gi na tapala menien tara koruse. ");
INSERT INTO hla_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bu soldia e lu menari e Iesu i pal porina luma tere Gamman (a makum teka i ngöei Peretorium). Ba nori e ngö gugono rer u soldia hoboto. ");
INSERT INTO hla_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ba nori e haseieri e Iesu u hasobu u ngahangaha u miamia te tara herei u hasobu tara king, me hil haperperere ier a kolits a hihitoka me hake rien i bakunen. ");
INSERT INTO hla_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ba nori e hohou hatsunone ren me poier, “Solosei iam a king turu Jiu.” ");
INSERT INTO hla_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ba nori e singsingatseri a bakunen u nga me kahkahuse ren me hathatukunur me turuturu uar i tanen. ");
INSERT INTO hla_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Poata ti hahakos hakapa ien tere Iesu, ba nori e his ba ner u hasobu u miamia me hamago poutse rien u hasobu i tanen. Ba nori e lakasa meren te gi na tapala menien tara koruse. ");
INSERT INTO hla_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ba i maroro nori i tupali a toa katun a solonen e Saimon e lama tara tana han. Nonei a toun Sairini, e tamar re Aleksenda mere Rupas. Nori i hatöe ien a koruse tere Iesu. ");
INSERT INTO hla_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ba nori i peigi mena tei e Iesu tara makum ti ngöei Golgota (u ranga teka e poiena “A Makum turu Lakö”). ");
INSERT INTO hla_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ba nori e torohanan hale rien u wain ti sohala gono mei a ka a mal ti ngöei u mer, kaba e Iesu e ma ue ien. ");
INSERT INTO hla_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ba nori e tapala narien tara koruse. Ba nori e satu siler esi te ga lui tu toa tu hasobu tara man hasobu tere Iesu, ba nori e molamoleri a peisaren a man hasobu i tanen. ");
INSERT INTO hla_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nori i tapala nien tara koruse tara 9 kilok tara bongbong. ");
INSERT INTO hla_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nori i hakeia tara bakunen i iasa u ranga ti kot meien te poei, “A King turu Jiu.” ");
INSERT INTO hla_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na tara toa makum nori i tapala hasin a elasolana a kopkop tara man koruse i rehina e Iesu, a toa tara pal matou na tai tara pal keruka.* ");
INSERT INTO hla_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","A ka teka e kato hamani u ranga turu Buk u Goagono te poiena: “Nori e na kato mena rien te mar kato has mena rien tara kopkop.”* ");
INSERT INTO hla_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na barebana ti silaia i sukusuku i raranga homi sil e Iesu me tsibtsibil ner a bakuren me poier, “Nonei alö a katun tu katsin kato lupu a Luman Lotu Pan ba te hatakei poutse men turu topisa u lan. ");
INSERT INTO hla_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Alö go kouluma tara koruse ba te taguhem a peisam.” ");
INSERT INTO hla_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bu pris pan nu tson hihatuts turu Lo e kato has uar i iesana ba te ranga hahakos ria tere Iesu me hiararangar, “Nonei e haka hanigeir a palabir u katun, kaba nonei e ma antuna nei te go haka haniga meni a peisanen. ");
INSERT INTO hla_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","E Mesaia a King ni Israel e go koul hamanasama tara koruse ba ra te tare ren ba te hamane ren.” Na elasolana katun ti tapala gono mei e Iesu nori i ranga homi sil hasen. ");
INSERT INTO hla_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tara 12 kilok tara soasa, bu kuhil e kopo kap neto u han hoboto me noana tara 3 kilok. ");
INSERT INTO hla_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na tara 3 kilok e Iesu e ku hapan koru me poiena, “Eloi, Eloi, lama sabaktani?” U ranga teka e poiena, “O Sunahan i tar, Sunahan i tar, aha te la ba sile mulei lö alia?” ");
INSERT INTO hla_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ba palina u katun ti tuolia i sukusuku e hengoe ren me poier, “Hengo iam. Nonei e ngöe iena e Ilaitsa.” ");
INSERT INTO hla_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ba toa katun e pietato me haputuena u magomagolo turu wain u melil me hakeie nen turu nga. Ba nonei e hale neien e Iesu te go ous menien me poiena, “Ka biam, ba ra te tarera te ga la uama e Ilaitsa ba te mi hakoule nen tara koruse.” ");
INSERT INTO hla_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Be Iesu e ku hapanito me matena. ");
INSERT INTO hla_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bu labalaba pan te kuteia i Luman Lotu Pan e takis katato i iasa me la nitoana i puta. ");
INSERT INTO hla_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ba tsunono turu soldia te tuolia i matane Iesu e tareto te mar mate uen me poiena, “A katun teka a Pien Tson hamana tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na palair a tohaliou i ka hasia i lehana ba te pepeitor. I gusuren e kaia e Maria Matalina ne Salomi ne Maria e tsinana ere Jemis a tetenei mere Joses. ");
INSERT INTO hla_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nori i lala gono mei e Iesu i Galili me taguhe ren. Na palair a tohaliou u para ti la gono meien i Jerusalem i ka gono has meien. ");
INSERT INTO hla_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na turu lan teka a barebana i kato mami a mamana ka, taraha i mahö u Lan u Goagono turu Jiu. A lahibong e butu hamanasa, be Josep ni Arimatia e tukuto. ");
INSERT INTO hla_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Nonei a katununa turu Kot Pan te ka mei a solo a niga, ba te hahaloso hasena a Nipepeito tere Sunahan. Be Josep e ongolona me la uana tere Pailat me rangata sile neien u tuanrei tere Iesu. ");
INSERT INTO hla_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Be Pailat e asingoto meto te hengo menien te mate hakapa u e Iesu, ba nonei e ngöena a tsunono turu soldia me rangatse neien te ga mate hakapa u e Iesu. ");
INSERT INTO hla_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Poata te hengoeia e Pailat u ranga tara tsunono, ba nonei te hanigana te ga lu meni e Josep u tuanrei tere Iesu. ");
INSERT INTO hla_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Be Josep e holeto u labalaban kopo me na hakoulena u tuanrei tere Iesu me pitse neien u labalaba me na hopue nen i iahana kioun mate ti kuieia turu lapo. Ba nonei e hategelieto a hatu pan me tupe neien a matana kioun mate. ");
INSERT INTO hla_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ne Maria Matalina ne Maria e tsinana e Joses i pepeito ti hopueia e Iesu. ");
INSERT INTO hla_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Poata te kapaia u Lan u Goagono, be re Maria Matalina mere Salomi ne Maria e tsinane Jemis i holi u uapi u masi te gi na kis menien turu tuanrei tere Iesu. ");
INSERT INTO hla_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tara bongbong koru turu lan tutun turu wik te butu uama a pitala, nori i la u tara kioun mate. ");
INSERT INTO hla_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ba nori e hiarangrangatar me poier, “Esi te hategele ba bera noi ra a hatu te tupena a matana kiou?” ");
INSERT INTO hla_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nonei a hatu pan koru. Ba nori i tara seito me tarer a hatu i hategele ba hakapein. ");
INSERT INTO hla_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ba nori e tasu ria tara kioun mate me tarer a toa tson a hitots ba te gumuna tara pal matou ba te ka mena u hasobu u hiaka. Ba nori e asingotor me matoutur. ");
INSERT INTO hla_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ba nonei e poieto i taren, “Alimiu go ma asingotomi ne go ma matoutmi. Alimiu e sakiemiu e Iesu ni Nasaret ti tapala nia tara koruse. Nonei e ma ka nei. Nonei e takei hakapa. Tara uam tara makum ti hopue ien. ");
INSERT INTO hla_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","La tala iam, ba limiu te na hatei ramiu u katunun tsitsilo i tanen ne Pita u ranga teka: ‘Nonei e mam ranou limiu i Galili, ba limiu te na tare moen ili, te mar hatei merien limiu.’” ");
INSERT INTO hla_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ba nori e lakasar me bus ba ner a kioun mate, taraha nori i asingoto koru me tolotololo mer a nimatout. Ba nori e ma hatei narien ta toa ta katun, taraha nori i matoutu koru. ");
INSERT INTO hla_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","I murina te takeia e Iesu tara tou mate i tanen, tara lunlan turu lan tutun turu wik, ba nonei e butu mamuna tere Maria Matalina, a tahol te tsuga ba mam nien a tohit a mate a omi. ");
INSERT INTO hla_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Be Maria e la uato turu katun ti roron ka gono mei e Iesu ba te hahurir me taber. ");
INSERT INTO hla_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ba nonei e poiena i taren, “E Iesu e toatoana na lia e tare gumen.” Poata ti hengoe ien a ka teka ba nori e hahamana naren. ");
INSERT INTO hla_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ba i murinen be Iesu e butuna tara elasolana katunun tsitsilo ti la uen tara han te kaia i ielesala tara taun, ba peisanen e halhalina. ");
INSERT INTO hla_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ba nori i kopis poutsuto me hatei rer a palai ti roron ka gono meien. Kaba nori i hahamana has ren. ");
INSERT INTO hla_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ba i murinen be Iesu e butuna tara 11 a katunun tsitsilo tara poata ti nou ien. Ba nonei e ranga hatagala mera nen, taraha nori i hahamana me baku-tur. Nonei e ranga hatagala meren, taraha nori i hahamaneir u katun ti tare ien i murina te takei pouts ien. ");
INSERT INTO hla_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ba nonei e poiena i taren, “La uam turu han hoboto i puta ba te na rarariemiu u Bulungana u Niga tara barebana hoboto. ");
INSERT INTO hla_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","A katun te hamanana na te luena a baptais e ka hanigana romana. Kaba a katun te ma hamana nei e rusuna romana turu Kot tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nu katun te hamanar e katoer romana a man hiharuts tara nitagala tere Sunahan te kato uana teka: nori e poier romana a solor ba te tsuga ba rer romana u mate u omi. Na nori e ranga ria romana tara man ranga man tsimus te ma atei sileri. ");
INSERT INTO hla_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Te pile narien romana u kukutsi tsi te ue rien u mar ramun te kato hamatiena a katun, a man ka teka e ma kato homi rane ien romana. Na nori e hatakoper romana a limaren turu katun te ka mer a nimate ba nori te niga poutsur romana.” ");
INSERT INTO hla_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","A Tsunono e Iesu e ranga hakapa meren be Sunahan e lu pouts mena neien i Kolö, be Iesu e na gumna tara pal matou tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bu katunun tsitsilo i lato me na rarare ria turu han hoboto. Ba Tsunono e kui gono mera ten, ba man hiharuts tara nitagala tara Tsunono te haruto nena te mana u u ranga i taren. ");
INSERT INTO hla_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O Tiopilas a tsi tsunono, a palair u katun u para i koloto hakapein u ranga te hatei nena a man ka te kato e Iesu Kristo i gusurara. ");
INSERT INTO hla_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nori i torohanan hopun u ranga ti hengo nia ra turu katun ti lala tutun gono mei e Iesu Kristo me tarer a man ka te katoe ien ba te hahatei nena u hihatuts i tanen. ");
INSERT INTO hla_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na lia uas e ngilin koloto menagi i tamulö u ranga te hatei hamatskö nena a man ka teka, taraha alia u solon hatatei hanigein a man ka te kato e Iesu te tania mam koru. ");
INSERT INTO hla_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Alia e ngilegu alö go atei haniga sil u ranga u mana hoboto turu hihatuts tu hengoin lö. ");
INSERT INTO hla_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tara poata te kingia e Herot i Judia, a toa pris e ka ti ngöei e Sekaria. Nonei e kaia tara pal pris tere Abaitsa. A tahol tere Sekaria a solonen e Elisabet e pala has u turu pris, taraha nonei e hatutubuneia tere Eron. ");
INSERT INTO hla_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nonei u muntahol teka i matsköia i matane Sunahan, na nori i kukute haniga hasi u mamanu ranga nu markato tere Sunahan a Tsunono. ");
INSERT INTO hla_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kaba nori i moa ta pien, taraha Elisabet e kuba, na nori i lopi tobuana. ");
INSERT INTO hla_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bu toa u lan be Sekaria e kuieto a toukuin pris i tanen i matane Sunahan, taraha a poata tara pal pris i tanen e butu tala te gi kui uen i iahana Luman Lotu Pan tara Tsunono. ");
INSERT INTO hla_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nori i hopu kap menien tara markato turu pris te ga na kato menien u ruhu u soka haniga tara tsi makumun hats turu insens (kumahoana). Be Sekaria e tasuna tara Luman Lotu Pan. ");
INSERT INTO hla_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tara poatan hats teka u katun u para koru i gonoia i ielesala ba te singor. ");
INSERT INTO hla_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ba toa angelo tara Tsunono e butuna tere Sekaria me tuolna tara pal matou tara makum te hahatse ria u insens. ");
INSERT INTO hla_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tara poata te tareia e Sekaria a angelo, ba nonei e asingotona me matout koruna. ");
INSERT INTO hla_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ba angelo e poieto i tanen, “Alö go ma matouti, o Sekaria, taraha e Sunahan e hengo hakapi tu singo sil meni lö ta pien. A tahol i tamulö e Elisabet e pose nou romana a pien tson i tamulö, ba lö te ngöe mien e Jon. ");
INSERT INTO hla_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ba limiu te ka memou a nisasala pan te gi posa menien, bu katun u para te sasala gono mera riou limiu. ");
INSERT INTO hla_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Taraha, nonei e katun pan noa romana i matana Tsunono. Ba nonei te ma tatei ue nei romana a wain nu ramun u hiski. Na nonei e saputu mena romana u Namnamei u Goagono i mam has te gi posa menien! ");
INSERT INTO hla_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nonei e habirits pouts mera nei romana u katunur i Israel u para tere Sunahan a Tsunono i taren. ");
INSERT INTO hla_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ba nonei te la mamna romana tara Tsunono ba te ka mena a toa markato na nitagala te ka mei e Ilaitsa a propet i manasa. Na nonei e na nolo pouts rena romana a man munmun tamana, ba te habirits rena romana u katun u hihipus ba nori te toan hakats hanigar te mar hakats uar u katun u niga. Na nonei e kato hamatskö rena romana u katun i mam te go lama a Tsunono ba te lu hahaloso mera neien i tanen.” ");
INSERT INTO hla_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Be Sekaria e poieto tara angelo, “Ime tsiponi te mar atei mena goi lia te ga mana u u ranga teka? Taraha, alia u tsonpan hakapa na tahol i tar e tobuana hakapa has.” ");
INSERT INTO hla_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ba angelo e ranga palise ten me poiena, “Alia e Gabriel, te roron tuol gia i matane Sunahan. Nonei e tahul mena mei lia te go ranga u lia i tamulö ba te hatei gilö u bulungana u niga teka. ");
INSERT INTO hla_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nu ranga i tar e butu hamana nou romana tara poata hamatskö i tanen. Kaba hengo! A rungumulö e tu nou, taraha alö e ma hamanemi u ranga i tar! Alö e ma tatei rangami antunana romana te go butu hamana u romana a man ka teka!” ");
INSERT INTO hla_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Bu katun e lagi aloloser e Sekaria, me hakhakatsir me poier, “Aha tsiponi te kaka pala menen i luman lotu?” ");
INSERT INTO hla_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ba tara poata te lakasa men ba nonei e ma antunan ranga nei i taren, kaba nori i atei sil e Sekaria e tarei a hiharuto i iahana luman lotu. Nonei e biru hakapa, me ranga tun nena a limanen. ");
INSERT INTO hla_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ba poata te kapaia a poatan kui tere Sekaria i iahana Luman Lotu Pan, ba nonei e la pouts uato i han. ");
INSERT INTO hla_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bi murinen ba tahol i tanen e Elisabet e pikana, me ma la ba nanei a luma tara tolima tsihau. ");
INSERT INTO hla_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ba nonei e poiena, “A Tsunono e mar taguhu mena nei lia teka. Nonei e lu ba nilia a nimatsingolo tara tou kuba.” ");
INSERT INTO hla_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Poata te pika hakapaia e Elisabet tara tönomo a tsihau, e Sunahan e hala nema a toa angelo a solonen e Gabriel me la uana tara toa taun i Galili ti ngöei Nasaret. ");
INSERT INTO hla_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nonei e la u tara toa tahol a kukubei a solonen e Maria. Nonei a tahol ti hopu kap bei a toa tson a solonen e Josep, a hatutubunei tere Devit a Kingina i manasa. ");
INSERT INTO hla_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ba angelo e tasuna me poiena tere Maria, “O Maria, a Tsunono e ka gono meno lö na nonei e ngil korue nolö.” ");
INSERT INTO hla_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Be Maria e hengoena u ranga teka me toku koruna, ba nonei e hakats tununa me poiena, “Aha nonei a mouna u ranga teka?” ");
INSERT INTO hla_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ba angelo e poiena i tanen, “O Maria, alö go ma matoutui, taraha e Sunahan e hanige nolö. ");
INSERT INTO hla_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Alö e pika mou ba lö te poseie mou romana a pien tson, ba lö te ngöe moien e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ba nonei te pan nou romana ba nori te ngöe roien a Pien tere Sunahan i Iasa Koru. E Sunahan a Tsunono e hale noien romana a nitsunono tere Devit e tubunen. ");
INSERT INTO hla_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ba nonei te tara kap nena romana a pala tere Jekop tara mamana poata i murimuri. Na nipepeito i tanen e ma tatei kapa nei romana.” ");
INSERT INTO hla_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Be Maria e poiena tara angelo, “Ime te mar butu halona uanou a ka teka? Taraha, alia e ma lu noegi ta tson.” ");
INSERT INTO hla_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ba angelo e poiena i tanen, “U Namnamei u Goagono e la uanama romana i tamulö na nitagala tere Sunahan te mi hohe nolö. Ba pien a goagono te pose iem romana lö te ngöeri romana a Pien Tson tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na hengo! A tou sungutumulö e Elisabet e pika hasena a pien tson! Nonei e tobuana koruna na nori i ngöe ien a tahol a kuba, kaba nonei e pikaia tara tönomo a tsihau te kapa. ");
INSERT INTO hla_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Taraha, e moa ta toa ta ka te ma antunan katoe nei e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Be Maria e poiena, “Alia a taholun kui tara Tsunono. A ka teka e tatei butuna i tar te ranga uamu lalö.” Ba angelo e la ba nanen. ");
INSERT INTO hla_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tara poata teka be Maria e takeina me la boroboro uana tara toa taun te kaia tara pokus tara provins i Judia. ");
INSERT INTO hla_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ba nonei e na tasuna i luma tere Sekaria ba te hatsomiena e Elisabet. ");
INSERT INTO hla_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ba poata te hengoeia e Elisabet u ranga tere Maria, ba pien e sosina i torinen, be Elisabet e toan saputu mena u Namnamei u Goagono tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Be Elisabet e ranga hapanina me poiena, “E Sunahan e kalala saluhe rilö a tohaliou hoboto, na nonei e kalala hase nou a pien te pose iem romana lö. ");
INSERT INTO hla_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Alia a tahol papala, na alö a tsinana a Tsunono i tar. Aha te la sile muma lö i tar? ");
INSERT INTO hla_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Poata te hengoe gula lia u ranga i tamulö, ba pien te kana i torir te sasalana ba te sosina. ");
INSERT INTO hla_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Alö e sasala koru mem te hamana uamu lö, taraha u ranga te hopu kapin a Tsunono i tamulö e butu hamana nou romana.” ");
INSERT INTO hla_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Be Maria e poiena: “A torir e soloseiena a Tsunono, na lia e sasala koru megu e Sunahan te taguhe nolia. ");
INSERT INTO hla_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nonei e tatagi silena a taholun kui papala i tanen na heir i romana na heir hoboto i murimuri e ngöe roi romana lia a taholun kalala. ");
INSERT INTO hla_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Taraha, e Sunahan a Tagala e kato bei lia a ka a kapan, na solonen e goagonona. ");
INSERT INTO hla_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nonei e tatagi sil rena u katun te hatsunone ren, u katununa i romana nu katununa tara poata hoboto i murimuri. ");
INSERT INTO hla_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nonei e haruto nena a nitagala i tanen, ba nonei te rura rena u katun u hihipus. ");
INSERT INTO hla_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nonei e hakoul ba rena u king u tagala turu makum i taren, ba nonei te soata seiena a katun papala. ");
INSERT INTO hla_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nonei e hala ranei u katun te besur a man ka man niga, ba nori te masulur. Na nonei e ma hala ranei u katunun moni a man ka te singoe ren. ");
INSERT INTO hla_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nonei e taguhu rena a barebanar i Israel, u katunun kui i tanen. Nonei e kato hamanena u ranga te hopu kap nien turu tuburara. ");
INSERT INTO hla_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nonei e ma solopalei te go haruto meni a nihitaguhu tere Abraham na tara pala i tanen tara mamana poata i murimuri.” ");
INSERT INTO hla_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","E Maria e ranga hakapana teka. Ba nonei te ka gono mena e Elisabet tara topisa toum a tsihau, ba nonei e la poutsuna i han i tanen. ");
INSERT INTO hla_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na poata e butu hakapa te ga posa mei e Elisabet, ba nonei e pose iena a pien tson. ");
INSERT INTO hla_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bu katun tara han i tanen na u sungutunen e hengoer te tatagi koru u a Tsunono i tanen te hala menien a pien, ba nori e sasala gono meren. ");
INSERT INTO hla_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ba poata te keia a pien u toal u lan, bu pal katun i tanen e la rima te gi pö meni a hatoatongo tere Sunahan i pikpiköna pien.* Ba nori e pats ngöe rien e Sekaria, a solo tere tamanen. ");
INSERT INTO hla_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kaba Elisabet e poiena, “E moa, a solonen e ngöe roi e Jon!” ");
INSERT INTO hla_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ba barebana e poier i tanen, “E moa koru ta toa tara pala i tamulö te gi ngöei e Jon!” ");
INSERT INTO hla_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ba nori i ranga tun meto e tamana pien turu ualima me rangata ner a solo te ngile nen tara pien. ");
INSERT INTO hla_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Be Sekaria e ranga silena ta tsi pepa ba nonei te koloto uana teka: “A solonen e Jon.” Ba nori e asingoto hoboto korur. ");
INSERT INTO hla_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ba i teka puku be Sekaria e tanian ranga poutsuna, ba nonei e soloseiena e Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bu barebana hoboto i han i tanen e matoutur, bu bulungana tara mamana ka teka e la hoboto uato tara mamana han tara pokus i Judia. ");
INSERT INTO hla_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bu barebana hoboto ti hengo e solon hakhakatsir me poier, “A pien teka e katun pan nou romana, taraha a nitagala tara Tsunono e kana i tanen.” ");
INSERT INTO hla_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","68","Be tamana pien e Sekaria e saputu mena u Namnamei u Goagono, ba nonei e katoena u ranga tara propet me poiena, “Ara gi solosei e Sunahan a Tsunono ni Israel! Taraha, nonei e mi taguhu rena ra u katun i tanen, ba te sakahis pouts rena ra. ");
INSERT INTO hla_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nonei e habutsena a tsonun mammam a tagala te go taguhu rio ra, a hatutubunei tere Devit, a katunun kui tara Tsunono. ");
INSERT INTO hla_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","E kato uana ti ranga u u propet u niga tara Tsunono i manasa. ");
INSERT INTO hla_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nori i rangein u ranga tere Sunahan me poier e Sunahan e ranga hamana te ga lu ba merien ra tara nitagala turu pakö hoboto i tarara, u katun te tori homi ria i tarara. ");
INSERT INTO hla_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","E Sunahan e poei nonei e ga tatagir u tuburara ba te ma tatei solopale nei u ranga u niga ti kits. ");
INSERT INTO hla_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Nonei e ranga hamana koruia i iasa tere tuburara e Abraham me poiena nonei e ga taguhu rio ra ba ra te butu haniga ba nerou u pakö i tarara, ba ra te tatei kui beiera e Sunahan ba ra te ma matout rei. ");
INSERT INTO hla_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nonei e ngilena ara gi niga na ra gi matsköia i matanen turu mamanu lan tara nitoatoa i tarara.” ");
INSERT INTO hla_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Be Sekaria e poe hasena tara pien, “Alö a tsi pien i tar, alö e ngöe roi a propet tere Sunahan i Iasa Koru, taraha alö e la mam nemou a Tsunono te go hamatskö meni a maroro te ga sila ien romana. ");
INSERT INTO hla_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Alö e na hatei rem u katun tere Sunahan nonei e lu ba nena romana u markato u omi i taren ba te lu pouts mera neien i tanen. ");
INSERT INTO hla_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Taraha, a Sunahan i tarara e tatagi koru rano ra ne tami hasina. Nonei e hala ranoi ra a hitaguhu a niga ba te here noi a pitala te purus nama tara bongbong ba te lu ba nena u kuhil. ");
INSERT INTO hla_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","U ualesala i tanen e halesala rena romana u katun te ka ria turu kuhil, u katun te ka uar tara tou mate. Ba nonei te hamatskö rena romana a mourara ba ra te lara tara marorona tara masalohana.” E Sekaria e ranga u teka. ");
INSERT INTO hla_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","A pien teka e pan susul, bu namnamei i tanen te butu hatagala susul hasina. Nonei e pan hakapa ba nonei e roron kana tara latu pinopino, a makum te ga butu ien romana i matar u katun i Israel. ");
INSERT INTO hla_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tara poata teka e Sisa Ogastas nonei a Gamman Panina i Rom. Nonei e hala nela a lo te gi hakoloto meni u katun hoboto a soloren turu buk tara gamman. ");
INSERT INTO hla_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nonei a poata tutun ti kato ien a nikoloto teka, a poata te gamman hasia e Kuirinias tara provins i Siria. ");
INSERT INTO hla_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ba barebana i la kalakala u tara man toa man mouna han i taren te gi na hakoloto menien a soloren turu buk. ");
INSERT INTO hla_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Be Josep e la ba has nena a taun i Nasaret te kana i Galili ba nonei e kete uana tara taun tere Devit a solonen i Betelehem tara provins i Judia. Taraha, e Josep e hatutubuneia tere Devit. ");
INSERT INTO hla_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nonei e la gono has mei e Maria a tahol i tanen, te gi na hakoloto menien a soloren turu buk. Ne Maria e pika hapan. ");
INSERT INTO hla_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na poata ti ka noa ien i Betelehem, ba poatan posa i tanen e bututa. ");
INSERT INTO hla_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ba nonei e pose iena a pien tson a hamua i tanen me pitse neien u labalaba me hopue nen tara bokisin nounou turu bulumakau. Taraha, e moa ta makum i taren tara luman pasendia. ");
INSERT INTO hla_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tara han teka a palair u katun i pepeito kapin a heis sipsip i taren tara bong i ielesala tara taun i Betelehem. ");
INSERT INTO hla_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ba toa angelo tara Tsunono e butuna i taren, bu ualesala pan tara Tsunono e alesalana i taren ba nori e matout korur. ");
INSERT INTO hla_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ba angelo e poiena i taren, “Alimiu go ma matoutumi. Alia e la meguma u bulungana u niga te la uanama i tamilimiu na turu katun hoboto ba te kato hasasala koru rano limiu. ");
INSERT INTO hla_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","A Tson Hitaguhu i tamilimiu e posie lila tara bong teka i romana i taun tere Devit. Nonei a katun te ga la uama i puta te ngöeri e Kristo. Nonei a Tsunono! ");
INSERT INTO hla_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Alimiu e na sabie mou a tsi goama te pitse lilei u labalaba na te opuna tara bokisin nounou turu bulumakau.” ");
INSERT INTO hla_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Ba toa ami pan turu angelo ri Kolö e singotei butu gono mena a angelo teka. Ba nori e soloseier e Sunahan me poier, “Solosei iam e Sunahan i Kolö i iasa koru! Na tara han i puta, a barebana te haniga rena e Sunahan e tatei ka ria tara masalohana!” ");
INSERT INTO hla_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Poata ti la ba rien u angelo ba te la poutsur i Kolö, bu katunur turu sipsip e hiararangar me poier, “Ara gi topei la i Betelehem ba ra te na tare rou a ka te butu lala, te hatei rala lei ra a Tsunono.” ");
INSERT INTO hla_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ba nori e la boroboror me na sabe rer ere Maria mere Josep, ba nori e sabe haser nonei a tsi goama te opuia tara bokisin nounou turu bulumakau. ");
INSERT INTO hla_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nori i tara hakape ien me toan ranga hatei ner a ka te hatei ramei a angelo a pien teka. ");
INSERT INTO hla_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ba barebana hoboto ti hengo u bulungana teka turu katunur turu sipsip i asingoto koruto. ");
INSERT INTO hla_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Be Maria e hakats kap nitoa neto a man ka hoboto teka. ");
INSERT INTO hla_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bu katunur turu sipsip e la poutsur ba te solosei meri e Sunahan a man ka hoboto ti hengoe ien na ti tare ien. A man ka teka e butu hamana u te ranga u a angelo. ");
INSERT INTO hla_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ba te kapaia u toal u lan, ba nori te pö ner a hatoatongo tere Sunahan tara pikpiköna pien, ba te ngöeri a solonen e Iesu, a solo te hatein a angelo i mam te pikaia e Maria. ");
INSERT INTO hla_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","A poata e butu hakapa te gi kato hagogoso mei a pien ne tsinanen, te mar ranga u u Lo tere Moses, be Josep ne Maria e lu menari a pien i Jerusalem te gi na hala menien tara Tsunono. ");
INSERT INTO hla_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Taraha, u ranga ti koloto nia turu buk tara Tsunono e poiena, “A mamana hamua tson e go ngöe milimiu a katun te ka uana tara Tsunono.” ");
INSERT INTO hla_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na nori i la hasi u ti na hatsunono meni u hats te mar ranga hasi u u buk tara Tsunono, “Alö go hats a solona kitou tsi a solana kulu a hitots.” ");
INSERT INTO hla_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na toa katun e kaia i Jerusalem a solonen e Simion. Nonei a katun a niga ne roron hatsunono e Sunahan, na nonei e hahaloso sil te ga taguhu meri e Sunahan a tei Israel. Nu Namnamei u Goagono e roron kaia i tanen. ");
INSERT INTO hla_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","U Namnamei u Goagono e ranga hakapa meien nonei e ma tatei mate boroboro nei romana. E moa. Nonei e tatei ruto mam noa bena e Mesaia, a katun te ranga hamanein a Tsunono te ga lama. ");
INSERT INTO hla_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bu Namnamei u Goagono te peigi mena nei e Simion i iahana Luman Lotu Pan. Bu mun tahol e la mena rimei e Iesu a goama tara Luman Lotu Pan te gi kato meni a markato i tanen te mar ranga u u Lo tere Moses. ");
INSERT INTO hla_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","29","Be Simion e soatsena a pien i limanen, me hanigana tere Sunahan me poiena, “O Tsunono, alia a katunun kui i tamulö e ka tala megou romana a masalohana tara poata te na mate goa lia. A ka tu ranga hamanein lö e butu hakapa tala. ");
INSERT INTO hla_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Taraha, a matagulia e tara hakapi a katun tu kati lö te go mi lu pouts meri lam. ");
INSERT INTO hla_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Alö u hopu kap sile ien te ga butu ien i matar u barebana hoboto. ");
INSERT INTO hla_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nonei e here noi romana u ualesala, ba te haruto nena a maroro i tamulö turu katun te ma Jiuri, na nonei e hala seiena romana a solona pala i tamulö u Jiu.” ");
INSERT INTO hla_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Be Josep ne Maria i asingoto koru neto u ranga teka te hatei meni e Simion e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Be Simion e kalala ranen me poiena tere tsinanen e Maria, “Poata te pan hakapana romana a pien teka, a katun a para i Israel e tori hasoala naroen ba nori te taiar romana. Kaba nonei e halu pouts rena romana a palair u katun u para. A torimulö e kamits menou romana a nitatagi pan, nu hakats i torina katun a para e haruto ner romana.” Te mar ranga u e Simion. ");
INSERT INTO hla_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na toa propet a tahol e ka has, a solonen e Ana. Nonei a pien tahol tere Panuel, tara pala tere Aser. Nonei a tahol a tobuana te hitöl hakapa turu tohit u hiningal i manasa ba tson i tanen e toan mateto. ");
INSERT INTO hla_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ba nonei e amobana turu 84 u hiningal lel. Nonei e ma tatei la bani a makum tara Luman Lotu Pan. Tara lan na tara bong nonei e roron hatsunono e Sunahan ba te singo uana i tanen me roron agono nena a kannou. ");
INSERT INTO hla_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na nonei has tara toa poata turu lan teka nonei e la u tara goama e Iesu me hala nena u haniga tere Sunahan, me ranga nena e Iesu tara pala hoboto i Jerusalem ti hahalosi a poata te ga taguhu meri e Sunahan u katun i Israel. ");
INSERT INTO hla_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Poata ti kato hakapia ere Josep mere Maria a mamana ka te rangein u Lo tara Tsunono, ba nori e la pouts mer e Iesu tara taun i taren i Nasaret tara provins i Galili. ");
INSERT INTO hla_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ba nonei a pien e Iesu e pan susuluna me butun tagalana. Nonei e ka mei u hakats u niga koru, ne Sunahan e kalale ien. ");
INSERT INTO hla_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Turu mamanu hinigal e tamane Iesu ne tsinanen i roron la u i Jerusalem tara kannouna turu Paska turu Jiu. ");
INSERT INTO hla_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Na tara poata te ka meia e Iesu u 12 u hiningal, nori i la u nonei tara kannou. ");
INSERT INTO hla_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Te kapaia a man lan tara kannou, ba nori te hatanian la poutsur i han, kaba a pien e Iesu e kakaia i Jerusalem. Ne Josep mere Maria i ma atei silei a ka teka. ");
INSERT INTO hla_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nori i poei nonei e ka gono mer a palai ti lala gono meren, ba nori e le ier u toa u lan u ohots. Ba nori e tanian sakie rien turu pal katun i taren na turu hahikapien i taren. ");
INSERT INTO hla_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kaba nori i ma sabie ien, ba nori e kopis pouts uar i Jerusalem ti na sake menien. ");
INSERT INTO hla_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ba turu hatopisana u lan nori i na sabie ien i iahana Luman Lotu Pan, te gum ien i gusur u tson hihatuts turu lotu, me hengona i taren me rangata nena a man harangata. ");
INSERT INTO hla_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","U katun hoboto ti hengoia i tanen i asingoto koru mei a niatei i tanen na man ranga te palis menien i taren. ");
INSERT INTO hla_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ne tamanen ne tsinanen i asingoto koru has mei tara poata ti tara menien e Iesu. Be tsinanen e poiena i tanen, “A pien i tar, taraha tsiponi ba lö te mar kato uam teka i tamulam? E tamamulö na lia u lagi sakesakie mou lö me toku korum.” ");
INSERT INTO hla_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Be Iesu e ranga palis ranen, “Taraha ba limiu te sakesakie mumo lia? Alimiu e go mala atei sile iam te go ka u lia tara luma tere Tamar.” ");
INSERT INTO hla_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kaba u muntahol i ma atei silei a mouna a ka te ranga nien i taren. ");
INSERT INTO hla_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Be Iesu e la gono pouts mera nen i Nasaret ba te hengo nitoa nena u ranga i taren. Be tsinanen e hakats nitoa nena a man ka teka i torinen. ");
INSERT INTO hla_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Be Iesu e pan susuluto, bu hakhakats i tanen e butu haniga koruto. Be Sunahan nu katun has e haniga korue ren. ");
INSERT INTO hla_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Turu hamalotonu tolimanu hiningal te Gamman Pania e Taibirius i Rom, e Jon e tanian hihatuts. Tara poata teka, e Pontias Pailat a Gamman tara provins i Judia, ne Herot te tara kapin a provins i Galili, ne toulanen e Pilip te tara kapin a provins i Ituria ni Trekonaitis. Ne Laisenias te tara kapin a provins i Abilin. ");
INSERT INTO hla_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Be re Anas mere Kaiapas te tsunono panir turu pris. Nonei tara poata teka u ranga tere Sunahan e la uama tara pien tere Sekaria e Jon te kaia tara latu pinopino. ");
INSERT INTO hla_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Be Jon e la uato tara mamana han i rehina Ramun i Jodan me hihatuts uana teka, “Habirits ba niam u markato u omi i tamilimiu ba te habaptaismiu, be Sunahan te lu ba nenou u markato u omi i tamilimiu, ba te tara pouts rano limiu.” ");
INSERT INTO hla_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Te mar koloto u e Aisaia a propet turu buk i tanen i manasa me poiena, “A toa katun e na ranga hapan noa romana tara latu pinopino ba te poiena, ‘Kato hamatsköe iam a man markato i tamilimiu, taraha a Tsunono e ngilin sila nama romana tara maroro a matskö. ");
INSERT INTO hla_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","U gohi hoboto e tatei hu riou, nu pokus hoboto e tatei hala pute riou. U kalana u kokoela e hamatskö riou, nu maroro u tuktukul e kato hamamarohane riou. ");
INSERT INTO hla_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bu mamanu katun te tarer romana a nihitaguhu tere Sunahan!’” U koloto tere Aisaia e kapana teka. ");
INSERT INTO hla_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bu katun u para e la uarima tere Jon te gi habaptaisia i tanen. Ba nonei e poiena, “Alimiu u katunur tara kukutsi a omi—alimiu u katun u gamogamo! Alimiu e ma antunan bus ba namoi a raharaha tere Sunahan te butu nou! ");
INSERT INTO hla_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Alimiu go habirits ba niam u markato u omi, ba limiu te mar kato hamana koru uamiu te kato uana a katun te habirits ba nena a markato a omi. Alimiu go ma tatei mar hakats uami teka: ‘Alam e nigam, taraha e Abraham a tubumulam.’ Alia e hatei rago limiu, e Sunahan e antunan katoe nei u hatu teka a pinaposa tere Abraham. E Sunahan e ma haniga pinopinoe nei a katun te pala uana tere Abraham. E moa. E hanige iena a katun te kukutiena u ranga tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ne Sunahan e katsin ngats lupu hamanasena u roei hoboto te mamala hua haniga nei, ba te lapo naria turu tula. E kato uana, e Sunahan e hahune nou a katun te ma kato haniga nei.” ");
INSERT INTO hla_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Bu katun e rangatser e Jon, “Aha tala te katoe mou lam?” ");
INSERT INTO hla_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ba nonei e ranga palisina, “A katun te ka mena u huol u hasobu u ngahangaha e ga halan u toa tara katun te moana. Na katun te ka mena a kannou e ga kato has u i iesana.” ");
INSERT INTO hla_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","U katun ti lulu a takis i la silema te gi mi habaptais uen, ba nori e rangatse ren, “Tson hihatuts, aha te go kati lam?” ");
INSERT INTO hla_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ba nonei e poieto i taren, “Alimiu go lu takis hapopo mia te ranga uana a gamman, ba te ma lu lelmi.” ");
INSERT INTO hla_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bu palair u soldia i rangata hase ten, “Ga lam, aha te go kati lam?” Ba nonei e poiena i taren, “Ma singatsemi ta katun ba te luemiu a moni i tanen. Na limiu go ma kot gamogamo has nami ta katun. Alimiu go sasala meiam a hihol i tamilimiu.” ");
INSERT INTO hla_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A barebana e tanian hakats ner e Mesaia e sukusukun lama, nonei a katun te hopu kapin e Sunahan, me hakhakats ner e Jon me poier nonei toum e Mesaia. ");
INSERT INTO hla_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Be Jon e poiena i taren hoboto, “Alia e baptais ragi limiu u ramun tun, kaba a toa katun te pan bala nano lia e la nama romana. Nonei a tsunono pan, na lia a tsikutupin katun papala koru. Nonei te baptais ranoi romana limiu u Namnamei u Goagono nu tula. ");
INSERT INTO hla_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nonei e katsin kato hamanasena a toukui i tanen te go lu kakata menien u katun u niga nu katun u omi, te mar hapiraka menari a pemuna ngal. Nonei e haka renoa u katun u niga tara han a niga, ba nonei te tsuga mera nei u katun u omi turu tula te ma antunan hoso nari.” ");
INSERT INTO hla_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na turu mamana has u mar ranga e Jon e kato hatakei rien u hakhakats tara barebana te hatuts rien u Bulungana u Niga. ");
INSERT INTO hla_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Be Jon e ranga sileta e Herot a Gamman, taraha nonei e töli e Herodias, a tahol tere toulanen pouts. Ne Herot e kato hakapi a palaina a markato a omi a para. ");
INSERT INTO hla_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Be Herot e katoena a tana markato a omi koru te haka menien e Jon tara karabus. ");
INSERT INTO hla_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","I murina ti habaptaisia a barebana hoboto, be Iesu e habaptais hasina. Tara poata te singo ien, bu Kolö e takalatana, bu Namnamei u Goagono e hakulue mata a peisanen me koul uanama i tanen. Bu toa u ranga e butu nama i Kolö me poe nama, “Alö a Pien Tson a tsomi koru i tar. Alia e haniga korue golö.” ");
INSERT INTO hla_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Poata te hatanieia e Iesu a toukui i tanen, ba nonei e ka toum mena u 30 u hiningal. E Iesu i ngöei a pien tere Josep. Ne Josep e tamanen e Hilai ");
INSERT INTO hla_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hilai e tamanen e Matat. Matat e tamanen e Livai. Livai e tamanen e Melkai. Melkai e tamanen e Janai. Janai e tamanen e Josep. ");
INSERT INTO hla_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep e tamanen e Matataias. Matataias e tamanen e Emos. Emos e tamanen e Neham. Neham e tamanen e Eslai. Eslai e temanen e Nagai. ");
INSERT INTO hla_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai e tamanen e Meat. Meat e tamanen e Matataias. Matataias e tamanen e Semein. Semein e tamanen e Josek. Josek e tamanen e Joda. ");
INSERT INTO hla_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda e tamanen e Joanan. Joanan e tamanen e Risa. Risa e tamanen e Serababel. Serababel e tamanen e Sialtiel. Sialtiel e tamanen e Nerai. ");
INSERT INTO hla_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai e tamanen e Melkai. Melkai e tamanen e Edai. Edai e tamanen e Kosam. Kosam e tamanen e Elmedam. Elmedam e tamanen e Er. ");
INSERT INTO hla_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er e tamanen e Josua. Josua e tamanen e Elieser. Elieser e tamanen e Jorim. Jorim e tamanen e Matat. Matat e tamanen e Livai. ");
INSERT INTO hla_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai e tamanen e Simion. Simion e tamanen e Juda. Juda e tamanen e Josep. Josep e tamanen e Jonam. Jonam e tamanen e Elaiakim. ");
INSERT INTO hla_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaiakim e tamanen e Melia. Melia e tamanen e Mena. Mena e tamanen e Matata. Matata e tamanen e Netan. Netan e tamanen e Devit. ");
INSERT INTO hla_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit e tamanen e Jesi. Jesi e tamanen e Obet. Obet e tamanen e Boas. Boas e tamanen e Salmon Salmon e tamanen e Nason. ");
INSERT INTO hla_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason e tamanen e Aminadap. Aminadap e tamanen e Admin. Admin e tamanen e Arni. Arni e tamanen e Hesron. Hesron e tamanen e Peres. Peres e tamanen e Juda. ");
INSERT INTO hla_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda e tamanen e Jekop. Jekop e tamanen e Aisak. Aisak e tamanen e Abraham. Abraham e tamanen e Tera. Tera e tamanen e Nehor. ");
INSERT INTO hla_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nehor e tamanen e Sirak. Sirak e tamanen e Riu. Riu e tamanen e Pilek. Pilek e tamanen e Iber. Iber e tamanen e Sila. ");
INSERT INTO hla_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila e tamanen e Kenan. Kenan e tamanen e Arpaksat. Arpaksat e tamanen e Sem. Sem e tamanen e Noa. Noa e tamanen e Lemek. ");
INSERT INTO hla_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek e tamanen e Metusela. Metusela e tamanen e Inok. Inok e tamanen e Jeret. Jeret e tamanen e Mahalaliel. Mahalaliel e tamanen e Kenan. ");
INSERT INTO hla_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan e tamanen e Inos. Inos e tamanen e Set. Set e tamanen e Adam. Ne Adam e tamanen e Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","E Iesu e saputu mei u Namnamei u Goagono tere Sunahan me la ba nena a Ramun i Jodan. Bu Namnamei tere Sunahan e peigi mena teien i iahana latu pinopino. ");
INSERT INTO hla_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Be Satan e tolahe nen e antunaia turu 40 u lan. Tara poata teka e Iesu e ma noui. Bi murina te kapaia a man lan teka, be Iesu e bes koruna. ");
INSERT INTO hla_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Be Satan e poieta i tanen, “Te go Pien u lö tere Sunahan, alö go ranga ba hatu teka te palis uana tara beret.” ");
INSERT INTO hla_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Be Iesu e ranga palisina, “Turu Buk u Goagono i koloto nia, ‘A beret peisa e ma antunan hala nanei a nitoatoa tara katun.’” ");
INSERT INTO hla_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Be Satan e la sei menen me haruto borobore neien a man han hoboto i puta. ");
INSERT INTO hla_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Be Satan e poieto i tanen, “Alia e hale goi lö a nitagala te go pania lö turu han hoboto teka, na man ka man niga i iaharen. A man ka hoboto teka i halei lia. Na te ngilin hala nagien lia tara toa katun, ba lia te tatei hala nagen. ");
INSERT INTO hla_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Te hatukun moia lö i matar ba te hatsunone molia, a man ka teka a man ka i tamulö.” ");
INSERT INTO hla_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Be Iesu e ranga palisito me poiena, “Turu Buk u Goagono i koloto meni turu katun, ‘Alö go hatsunono u tara Tsunono. Nonei a Sunahan i tamulö, na nonei peisa te mamaniete iemu lö.’” ");
INSERT INTO hla_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Be Satan e lu mena teien i Jerusalem me hatuole nen i iasa koru i pungana tara Luman Lotu Pan me poiena i tanen, “Te go Pien u lö tere Sunahan, kurapa u i puta. ");
INSERT INTO hla_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Taraha, turu Buk u Goagono ti kolotein, ‘E Sunahan e ranga mera noi u angelo i tanen te gi tara kap haniga menien lö. ");
INSERT INTO hla_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na nori e pile sei nario lö, te go ma tatei tu hamate meni lö turu hatu.’” ");
INSERT INTO hla_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Be Iesu e ranga palise nen, “U Buk u goagono e poiena turu katun, ‘Alö go ma tatei tohalei a Tsunono. Nonei a Sunahan i tamulö.’” ");
INSERT INTO hla_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ba poata te tohala hakapeia e Satan e Iesu a mamana ka, ba nonei e la ba nena e Iesu me alosena a tana poata. ");
INSERT INTO hla_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Be Iesu e kopis pouts uato tara provins i Galili na nitagala turu Namnamei u Goagono e ka gono meien. Bu katun turu han hoboto ti sukusuku e hengo naren. ");
INSERT INTO hla_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ba nonei e hihatutsina turu luman lotu turu Jiu, bu barebana hoboto e soloseie ren. ");
INSERT INTO hla_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Be Iesu e la uato i Nasaret, a taun te ka ien tara poata te pien noa ien. Ba turu Lan u Goagono turu Jiu ba nonei e la uato i luman lotu, te roron mar kato uen. Ba nonei e tuoluna te go rit meni u Buk u Goagono. ");
INSERT INTO hla_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ba nori e hale rien u buk tere Aisaia a propet. Ba nonei e palatseto u buk me sabiena a makum te mar ranga u teka, ");
INSERT INTO hla_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“U Namnamei tara Tsunono e kana i tar, taraha nonei e hopu kapin alia e go rarare beri u katun pinopino u Bulungana u Niga. Nonei e hala nemo lia te go habulungana meni lia u mar ranga teka: U katun ti kitsir e purese rariou, nu katun u kiau e tatei tara poutsu riou. Nonei e hala nemo lia te go mi taguhu meri lia u katun te tori-tiamar, taraha nori e pita-puta rer. ");
INSERT INTO hla_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nonei e hala nemo lia te go mi habulungana meni lia a poata te ga lu pouts meri a Tsunono u katun i tanen.” Makumun ranga tere Iesu e kapa. ");
INSERT INTO hla_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Be Iesu e hakopo poutseto u buk me hala pouts nanen tara katunun taratarakap me gumuna. Bu barebana i luman lotu e tara hoboto uar i tanen. ");
INSERT INTO hla_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ba nonei e hatanian rangana i taren me poiena, “I romana u koloto teka tere Sunahan te hengoe mula limiu e butu hamana talana.” ");
INSERT INTO hla_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ba nori e ranga haniga naren me asingoto koru ner u ranga u niga te katoen. Ba nori e poier, “Nonei a pien tere Josep, tsimiem?” ");
INSERT INTO hla_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ba nonei e poieto i taren, “Alia e ateigu alimiu e katoemiu romana u rangan haharoei teka i tar, ‘O dokta, alö go kato haniga poutsi a peisamulö.’ E kato uana, alimiu e mar ranga uamou teka i tar: ‘Alam u hengoin alö u kato a man mirakul i Kapeneam. Gaha tsiponi te ma kato has mena milö i iesana teka tara han hamatskö i tamulö?’” ");
INSERT INTO hla_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Be Iesu e poe hasena, “Alia e ranga hamana koru gia i tamilimiu, u katun e roron hanige ier a propet tara tana han, kaba a han hamatskö i tanen e ma hanige rien. ");
INSERT INTO hla_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Hengo iam. I manasa tara poata tere Ilaitsa a propet, u amoba i gonoia i Israel, tara poata te moaia ta langits turu topisa u hiningal na tunomo a tsihau, ba bes pan koru te butuna tara mamana han. ");
INSERT INTO hla_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kaba e Sunahan e ma hala meni e Ilaitsa tara toa amoba i Israel. E moa. Nonei e na taguhu talasi a toa amobana i Sarepat, tara pal han ni Saidon, a pala te ma Jiuri. ");
INSERT INTO hla_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na tara poata tere Ilaisa a tana propet, u toba i gonoia i Israel. Kaba e moa noa has ta toa i taren te gi kato haniga poutsi. E Neaman puku lasina i Siria, tara pala te ma Jiuri. Taraha, u katun i Israel i ramar u propet i taren. Ne kato has uana i iesana, alimiu e rama has nemo lia.” ");
INSERT INTO hla_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","U katun hoboto ti kaia tara luman lotu, u Jiu, i raharaha koru ti hengo menien u ranga teka. ");
INSERT INTO hla_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ba nori e takei seir me las tsibil ba neria e Iesu i taun, me lu mena rien i ieluna u pokus ti kuieia a taun i taren te gi ba hakurapa menien turu uarahana. ");
INSERT INTO hla_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kaba nonei e lakasa silaia i gusur u barebana me la halhalina. ");
INSERT INTO hla_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Be Iesu e la uato i Kapeneam, a taun i Galili, ba te hatuts rena u katun turu Lan u Goagono turu Jiu. ");
INSERT INTO hla_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ba nori e asingoto ner u hihatuts i tanen, taraha u ranga i tanen e ka mei a nitagala. ");
INSERT INTO hla_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","A toa katun te ka mei a mate a omi i peisanen e kaia tara luman lotu. Na nonei e ku hohomi hapan koru me poiena, “Pua! O Iesu ni Nasaret, alö banei go haka ba rio lam! Alö e mi katsin kato homi ramo lam! Alia e atei silegu alö a katun a goagono tere Sunahan!” ");
INSERT INTO hla_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Be Iesu e ranga mena a mate, “Kokomoto, ba lö te koul ba nem a katun!” Ba mate e lapo ba nena a katun i puta i mataren hoboto, me koul ba nanen me ma kato homie neien. ");
INSERT INTO hla_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bu katun hoboto e asingotor me hiararangar, “U saha u mar ranga teka? Nonei e tatei hala nena u ranga u mal u tagala turu mate u omi, ba nori te hengoe ren, ba te koul ba ner a katun!” ");
INSERT INTO hla_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bu bulungana te hatein a man ka te kato e Iesu te tala hamanasana tara mamana han te sukusuku. ");
INSERT INTO hla_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Be Iesu e la ba neto a luman lotu me la uana tara han tere Saimon. A halis tere Saimon a tahol e opu mei a peisanen e hiski koru, ba nori e ranga merien e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ba nonei e na tuolna i rehina inana i tanen, me abisena u hiski i peisana tahol. Bu hiski e la ba nanen, ba tahol e topei takeito me hanou ranen. ");
INSERT INTO hla_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","I murina te tsirukuia a pitala, bu katun hoboto u pala i taren ti ka mei a saha mar nimate e la mera rimei tere Iesu. Ba nonei e hopuena a limanen i taren hoboto me kato haniga pouts hoboto ranen. ");
INSERT INTO hla_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","U mate u omi has i la bar u katun u para, me ku hohomir me poier tere Iesu, “Alö a Pien tere Sunahan!” Be Iesu e ranga hatagala mera nen me hapiu nena te gi ma tatei ranga uaien, taraha nori i atei sil nonei e Mesaia. ");
INSERT INTO hla_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tara lunlan be Iesu e la ba neto a taun me la uana tara toa makum a ski. Bu katun e sakie ren, ba tara poata ti sabe ien ba nori i torohanan hapiu naten te go ma la uaien. ");
INSERT INTO hla_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ba nonei e poiena i taren, “Alia go na hatuts hasin u Bulungana u Niga tara Nipepeito tere Sunahan turu palair u taun has. Taraha, nonei a ka te hala sile mei e Sunahan alia te go kati lia.” ");
INSERT INTO hla_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Be Iesu e hihatuts lana tara man luman lotu i Judia. ");
INSERT INTO hla_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tara toa poata e Iesu e tuolia i singmouna Ramun a Perperere i Genesaret, tara poata ti hiatulatula sileia a barebana te gi la hasukusuku uen i tanen ba te hengoer u ranga tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nonei e tari a tsi huol a tsi tolala i las seia i kotolana. U tsonun hagala i la ba ren me na galuser u abe. ");
INSERT INTO hla_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Be Iesu e osata tara toa tsi tolala tere Saimon, me tahule nen te ga gamon tula ba menien i singmou. Be Iesu e gumuna i iahana tolala me hatuts rena a barebana. ");
INSERT INTO hla_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Poata te ranga hakapa ien, be Iesu e poieto tere Saimon, “Tula meni a tsi tolala tara makum a ruku, ba limiu te harukuemiu u abe ba te luemiu ta iena.” ");
INSERT INTO hla_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Be Saimon e ranga palisina, “O Tsunono, alam e kui bala mula i bong ba te kui halanim, kaba lam e ma sohe mulei ta ka. Kaba u ranga i tamulö ba lia te hakoule gou u abe.” ");
INSERT INTO hla_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ba nori i hakouleto u abe me soher a iena a para koru, bu abe e katsin tapusur. ");
INSERT INTO hla_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ba nori e ku rer a palabi i taren tara tana tolala te gi la uamen ba te mi taguhu raren. Ba nori e la rima me mi ongo hasaputer u huol u tolala tara iena me katsin rukur. ");
INSERT INTO hla_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Be Saimon Pita e rutsena a man ka teka, ba nonei e hatukunna i mouna e Iesu me poiena, “Alö go la ba neio lia, o Tsunono, taraha alia a katun a omi!” ");
INSERT INTO hla_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nonei e mar ranga u teka taraha nonei na palai i tanen i asingoto korun a iena a para koru ti sohe ien, na nori i tara sabe e Iesu e goagono. ");
INSERT INTO hla_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ti kato hasi u a pala tere Saimon, e Jemis ne Jon, a galapien tere Sebedi. Be Iesu e poieto tere Saimon, “Ma matouti. Alö a katun a sosoho iena. Kaba tara man poata te la nama, alö e na lu mera mumei u katun i tar!” ");
INSERT INTO hla_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ba nori e sua hasung menari a ma tsi tolala i taren i kotolana, me la ba ner a mamana ka me kukutier e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tara toa poata e Iesu e kaia tara toa taun, ba toa katun a peisanen te ka hoboto mei a toba e ka has. Ba nonei e tarena e Iesu, me hatukununa i matanen me singona i tanen me poiena, “O Tsunono, te ngil mia lö, alö e tatei kato haniga poutse molia.” ");
INSERT INTO hla_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Be Iesu e hasoa nena a limanen me sebele nen me poiena, “Alia e ngiligu. Alö go niga pouts tala!” Bi teka puku ba toba te la ba nena nonei a katun. ");
INSERT INTO hla_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Be Iesu e ranga menen, “Ma hateini a ka teka ta katun, kaba lö go la hamatskö u tara pris ba nonei te na rutena a peisamulö te niga pouts uanen. Ba lö te hale moien a kan hats te haruto nena a toba e kapa hamana, te ranga u e Moses i manasa. Bu katun te tatei atei sile riou a toba i tamulö e kapa koru.” ");
INSERT INTO hla_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kaba u bulungana te hatein a man ka te kato e Iesu e tasata u i lehana. Bu barebana u para e la sile rima te gi hengo menien na te ga kato haniga pouts merien tara man nimate i taren. ");
INSERT INTO hla_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kaba nonei e la pepeisa u tara latu pinopino ba te singona tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Turu toa u lan e Iesu e hihatutsia turu katun, na palabina u Parisi nu tson hihatuts turu Lo tere Moses i gum has. Nori i lama turu han hoboto i Galili ni Judia na i la hasma i Jerusalem. Na nitagala tere Sunahan e kaia tere Iesu te ga kato haniga pouts merien u katun ti ka mei a nimate. ");
INSERT INTO hla_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ba pal tson e soatse rima a toa katun a matekata tara poapoa. Nori i torohanan soata menien i iahana luma ba te hake rien i matane Iesu. ");
INSERT INTO hla_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kaba a makum e saputu tara katun, ne moa ta makum te gi sila meien. Ba nori e sei meren i ieluna a luma me lu ba ner a toa makumun pungana. Ba nori e hakoul gono meri a katun a poapoa i gusuna ti gonoia u katun me hake rien i matane Iesu. ");
INSERT INTO hla_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Be Iesu e atei talata te hamana uaren i tanen me poiena tara katun a matekata, “A tsi katun, alia e lu ba negu u markato u omi i tamulö.” ");
INSERT INTO hla_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bu tson hihatuts turu Lo nu Parisi e tanian hiarangarangata poutsur me poier, “Te ha u a katun teka ba te mar ranga uana teka? Nonei e katsin gulena a nitsunono tere Sunahan! E moa ta toa ta katun te ga tatei lu ban u markato u omi, e Sunahan lasi a toa!” ");
INSERT INTO hla_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","E Iesu e atei sil u hakats i taren me ranga mera nen me poiena, “A neha te hula hakats memi limiu? ");
INSERT INTO hla_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Alimiu e ma hanigami te poe mena gulei lia, ‘Alia e lu ba negu u markato u omi i tamulö’? Bara, alia e poa hamanase gou u tana u ranga te ka has mena a toukui pan te kato uana, ‘Alö go takei ba te lam!’ ");
INSERT INTO hla_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Alia e haruto ragoi limiu a mirakul teka alia tu butun katunuma e ka megu a nitagala i puta te go lu ba has menai lia u markato u omi tara katun.” Be Iesu e ranga meto a katun a matekata me poiena, “Alia e ranga mego lö, alö go takei ba lö te soatsem a poapoa i tamulö ba lö te lam i han i tamulö.” ");
INSERT INTO hla_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na i teka puku ba nonei e takei seina i matar u barebana hoboto me soatsena a poapoa te opu men me lana i han me soloseiena e Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bu katun hoboto i asingoto koruto me matoutur. Ba nori e soloseier e Sunahan me poier, “Ara e tare lila a man ka man kapan koru i romana!” ");
INSERT INTO hla_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","I murina a ka teka, e Iesu e tari a toa katun te lului a takis a solonen e Livai te gumia tara luman takis ba te kuina. Be Iesu e poieto i tanen, “Alö go la gono memo lia.” ");
INSERT INTO hla_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Be Livai e takeito me la ba nena a mamana ka me kukutiena e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Be Livai e katoeto a kannou pan tere Iesu i luma i tanen, nu katun u para ti lului a takis nu palair u katun ti nou gono meren. U kapan turu Jiu i ngö rien u katun u omi. ");
INSERT INTO hla_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bu palair u Parisi nu tson hihatuts turu Lo i tara raten me ranga sil rer u katunun tsitsilo tere Iesu, “Taraha tsiponi ba limiu te nou gono meremiu u katun te luluer a takis nu palair u katun u omi?” ");
INSERT INTO hla_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Be Iesu e hengona me ranga mera nen, “U katun te moar ta nimate e ma tatei la uari tere dokta. E moa. U katun lasi te ka mer a nimate te la peisa uar tere dokta. ");
INSERT INTO hla_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Alia u ma la sile mei te go mi ngö meri u katun u matskö ba te habirits hamatsköer a toriren. E moa. Alia u la silema e go mi ngö meri u katun u omi ba te habirits hamatsköer a toriren.” ");
INSERT INTO hla_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bu katun e poier tere Iesu, “U katunun tsitsilo tere Jon e roron agono ner a kannou ba te singo uar tere Sunahan. Nu katunun tsitsilo turu Parisi e mar kato has uar i iesana. Kaba u katunun tsitsilo i tamulö e namala agonori. Taraha tsiponi?” ");
INSERT INTO hla_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Be Iesu e poiena i taren, “Tara poata te hiakukoto gono meria a halis, na tsonun hitöl e kana, a pala tara tson e ma tatei agonori. E moa. ");
INSERT INTO hla_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kaba lia e heregi a toa tsonun hitöl te lu ba ner romana. Ba pala i tar te agono riou romana nonei tara poata.” ");
INSERT INTO hla_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ne Iesu e ranga has merien u haharoei teka: “E moa ta katun te ga kis ban ta makumun labalaba ta tsimus ba te tupe nei a tabutu turu labalaba u toutounei. Te ga kato uen teka, ba nonei te kisena u labalaba u tsimus, nu labalaba u tsimus e ma tatei taratara haniga gono menei u labalaba u toutounei. ");
INSERT INTO hla_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ne moa ta katun te ga tatei kis nia u wain u tsimus tara pikpiköna meme te toutouneina. Te ga mar kato uen teka, bu nitagala turu wain u tsimus te pan susuluna ba te kato butsena a kan osul a toutounei te ma antunan talas nei. Bu wain te takis uana i puta, ba pikpiköna meme te omi hasina. E moa. ");
INSERT INTO hla_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","U wain talasi u tsimus te gi kis nia turu pikpikö u tsimus. ");
INSERT INTO hla_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ne moa ta katun te ga ngil u wain u tsimus i murina te ua hakape nen u wain u toutounei. Taraha, nonei e poiena, ‘U wain u toutounei te niga balana.’” E Iesu e mar ranga u teka ba te haruto rane ien u hihatutsina i manasa turu Jiu te ma hisoböei menei u hihatuts u tsimus tere Sunahan. hasina. E moa. ");
INSERT INTO hla_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","E Iesu e hula laia i iahana u kuin wit turu Lan u Goagono turu Jiu. Bu katunun tsitsilo i tanen e patsiker a bakunu wit, me musase rien a limaren, me nouer a hua. ");
INSERT INTO hla_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bu palair u Parisi i tarato me poier, “Aha tsiponi te kato memi limiu a ka te poiena u Lo i tarara e gi ma katoei turu Lan u Goagono?” ");
INSERT INTO hla_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Be Iesu e ranga palis ranen, “Alimiu go mala rit hanige iam a ka te kato e Devit e tuburara a kingina i manasa. Tara toa poata nonei nu pal katun i tanen i moa ta kannou ba nori i besuto. ");
INSERT INTO hla_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ba nonei e la uato tara luma tere Sunahan, ba pris e haniga nena te gi nou menien u beret u goagono ti hakeia i matane Sunahan. E Devit e noue ien me hala has rena u katun i tanen. U Lo turu lotu i tarara e hapiun te gi ma nou meni a beret teka. U pris peisa te tatei noue ren. Kaba e Sunahan e ma kot mei e Devit nu katun i tanen, na limiu go ma si has rami lam!” ");
INSERT INTO hla_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Be Iesu e ranga lelina, “Alia tu butun katunuma te pan gia turu Lan u Goagono i gusumilimiu hoboto.” ");
INSERT INTO hla_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Turu tana u Lan u Goagono e Iesu e la u tara toa luman lotu me hihatutsina. A toa katun e ka te ka mei u ualima u mate. ");
INSERT INTO hla_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bu palair u tson hihatuts turu Lo nu Parisi i ngil ta makum ta omi te gi saka mei e Iesu. Ba nori e taratara hatagala uar i tanen te ga kato haniga pouts menien ta katun turu Lan u Goagono. ");
INSERT INTO hla_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kaba e Iesu e atei sil u hakhakats i taren me poiena tara katun a lima mate, “Alö go takei ba lö te la uamuma i mam teka.” Ba katun e takeina me mi toulna i rehina e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Be Iesu e poiena i taren, “Alia e rangata rago limiu, aha te hatangana nena u lo i tarara te gi kato ra turu Lan u Goagono? A niniganiga tsi a niomi? Ara gi taguhu a katun ba te toatoa poutsuna tsi ara gi atung hamate ien?” ");
INSERT INTO hla_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ba nonei e hula rutona i taren hoboto me poiena nonei tara katun, “Hasoa nema a limamulö!” Ba nonei e hasoa neto a limanen me niga poutsuna. ");
INSERT INTO hla_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kaba nori u Parisi nu tson hihatuts i raharaha koru me hiararanga ner a saha ka te gi kato ien tere Iesu. ");
INSERT INTO hla_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tara poata teka e Iesu e la sei u turu toa u pokus me singona, me ke iena a toa bong a ohots te singo uen tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Te lania u lan, nonei e ngör u katunun tsitsilo i tanen me hopu kap rena a 12 me ngö rane ien u aposol. ");
INSERT INTO hla_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","A soloren e: Saimon (ti ngö hasei e Pita) ne toulane Saimon e Endru. Ne Jemis ne Jon, ne Pilip ne Batolomiu. ");
INSERT INTO hla_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ne Matiu ne Tomas, ne Jemis a pien tere Alpias ne Saimon te tagala sil a han i tanen. ");
INSERT INTO hla_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ne Judas a pien tere Jemis ne Judas Iskeriot, a tson te ga harutein romana e Iesu i matar u pakö i tanen. ");
INSERT INTO hla_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Be Iesu e koul gono mere namen turu pokus, ba nonei e tuol gono merena u katunun tsitsilo u para i tanen tara toa makum a tatabala. U katun u para koru i ka has, u katun ti lama tara mamana han i iahana provins i Judia na tara taun ni Jerusalem, na pala has ti lama tara pal tasi tara taun i Taia ni Saidon. ");
INSERT INTO hla_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nori i la silema te mi hengo meni e Iesu na te ga kato haniga pouts merien e Iesu tara man nimate i taren. Nori has ti omi mei u mate u omi i la hasima me kato haniga pouts rer. ");
INSERT INTO hla_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","U katun hoboto i torohanan sebele nen, taraha a nitagala e lakasa ba nen me kato haniga pouts ranen hoboto. ");
INSERT INTO hla_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","E Iesu e ruto u turu katunun tsitsilo i tanen me poiena, “Alimiu u katun te kaka pukumiu, alimiu go sasala iam. Taraha, a Nipepeito tere Sunahan e ka uana i tamilimiu! ");
INSERT INTO hla_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Alimiu u katun te besmiu i romana, alimiu go sasala iam. Taraha, alimiu e masul mou! “Alimiu te tabemiu, alimiu go sasala iam. Taraha, alimiu e golgol mou! ");
INSERT INTO hla_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Sasala iam tara poata te omi raria limiu, na te tori-hasoala raria limiu, na te ranga homi raria limiu, na te tsuga raria limiu, te hamana uami limiu i tar tu butun katunuma. ");
INSERT INTO hla_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sasala iam tara poata te butuna romana a man ka teka, ba te sani memiu a nisasala, taraha u hamatana pan e haka bera rilimiu i Kolö. U tuburen i mar kato homi has meri u propet u niga teka i manasa. ");
INSERT INTO hla_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Kaba a nomi pan e ka uana romana i tamilimiu u katun te ka mer a moni a para i romana. Alimiu u lu hakape iam a poatan sasala i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“A nomi e ka uana romana i tamilimiu u katun te masulmiu i romana. Alimiu e na bes mou! “A nomi i tamilimiu te golgolmiu i romana. Alimiu e ton mou ba te tabemiu. ");
INSERT INTO hla_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“A nomi i tamilimiu te ranga haniga ria u katun hoboto i tamilimiu, taraha u tuburen i mar ranga has u i iesana turu propet u gamogamo i manasa.” ");
INSERT INTO hla_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","E Iesu e ranga lel me poiena, “Kaba lia e ranga mera golimiu eresi te hengoe rio lia, ngil riam u pakö i tamilimiu. Kato haniga mia turu katun te omi rario limiu. ");
INSERT INTO hla_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kalala riam u katun te ranga homi ria i tamilimiu, ba limiu te singo sil ramiu u katun te kato homi ria i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Te ga tapaleia ta toa ta katun a abuabumulö, hatapala hasin a hapala. Te ga lueia ta toa u hasobuna i tamulö u ngahangaha, hala hasei u siot i tamulö. ");
INSERT INTO hla_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","U katun hoboto te rangata ner ta ka i tamulö, halari. Na tara poata te lue ria a man ka i tamulö, ma rangatari ba lö te lu poutse men. ");
INSERT INTO hla_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kato meri a palabi te ngil mera mien lö te gi mar kato has uen i tamulö. ");
INSERT INTO hla_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Te ngil puku ramia lö u katun te ngile rio lö, gaha te ngil sile milö a nikalala? A katun has a omi te ngilena a katun te ngile nen. ");
INSERT INTO hla_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na te go kato haniga peisa u lö turu katun te kato haniga ria i tamulö, gaha tsiponi te ngil sile milö a nikalala? Te kato has uar u katun u omi. ");
INSERT INTO hla_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na te hala peisa ramia lö u katun te poe mia lö nori e tatei hala pouts ner a man ka, gaha te ngil sile milö a nikalala? U katun u omi e hala has rer u katun u omi, te gi lu hamatskö pouts meni a man ka i murimuri. ");
INSERT INTO hla_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","E moa! Alimiu go katoe iam a markato te niga balana. Alimiu go taguhu riam u pakö i tamilimiu ba te kato haniga mia i taren. Alimiu go hala pukpuku iam ba te ma ngilin lu poutsemi a man ka. Ba limiu te ka memiu romana u hamatana pan, ba te haruto has namiu alimiu e pien uamiu tere Sunahan i iasa koru. Taraha, nonei e niga hasina turu katun u omi te namala haniga uari tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Alimiu go tatagi riam u katun, te mar tatagi mera nei limiu e Tamamilimiu e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Be Iesu e rangana me poiena, “Ma poemi a palabi e omir, be Sunahan te ma poe hase noi alimiu e omimiu. Ma kato sil rami a palabi te gi hahuneir, be Sunahan te ma kato sile noi romana te ga hahuna meri limiu. Alimiu go solopale iam a man ka man omi ti kato a palai ba te tara pouts ramen, be Sunahan te solopala hase nou a man ka man omi tu kate iam limiu ba te tara pouts rano limiu. ");
INSERT INTO hla_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Hala niam a hitaguhu tara mamana ka turu katun be Sunahan te hala renou romana limiu. Bu katun te skel haniga korue rien romana i tamilimiu, ba nori te hasaputu korue ren romana, ba te tula puta naren, ba te hasaputu lel hase ren, antunana te ga pururuku uen, ba nori te hala rarien romana limiu. A mar skel te roron hala rami limiu u katun, tara mar skel teka e Sunahan e hala hapopo pouts has nanen romana i tamilimiu.” ");
INSERT INTO hla_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Be Iesu e hatei rane ien u haharoei teka. “A toa katun a matakiau e ma tatei peige nei a tai. Te ga markato uen teka, ba elasolana hoboto te na tsia ria tara holö. ");
INSERT INTO hla_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","A katunun tsitsilo e ma pan nanei a tson hihatuts i tanen. Kaba u katunun tsitsilo hoboto, poata te hakape rien u hatatei i taren, ba nori te toan hereri a tson hihatuts i taren. ");
INSERT INTO hla_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Taraha tsiponi ba lö te tarem a tsi bita i matana tana katun, kaba alö e ma rutemi a tutoka i matamulö hamatskö? ");
INSERT INTO hla_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Aha te poe mulö tara tana katun, ‘Alia e go lu ban a tsi bita i matamulö,’ kaba lö e ma tara tsipon noa hasemi a tutoka i matamulö pouts? Alö a gamogamo! Lu ba mam bin a tutoka te kana i matamulö, ba lö te tara haniga mou ba te toan lu ba nem a tsi bita i matana tana katun.” E Iesu e ranga u teka ba te hatuts nena a ka teka: a katun te ma tangoho nei e ga ona noabi a peisanen. ");
INSERT INTO hla_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Be Iesu e poiena, “U roei u niga e ma tatei ka menei a hua a omi, nu roei u omi e ma ka has menei a hua a niga. ");
INSERT INTO hla_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","U mamanu roei e atei sile ria tara hua i taren. Alimiu e ma tatei lue mia ta huan kakau turu rokrokoto na limiu e ma tatei lu hase mia ta huan laho turu korkoru. ");
INSERT INTO hla_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","A katun te ka mena u hakats u niga i torinen e habutsena a markato nu ranga te nigana. Na katun te ka mena u hakats u omi i torinen e habutsena a markato nu ranga te omina. Taraha, a runguna katun e roron ranga nena a ka te saputu mena a torinen.” ");
INSERT INTO hla_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","E Iesu e hakapi u ranga i tanen te poe ien, “Taraha ba limiu te ngöe milia, ‘Tsunono, Tsunono,’ ba te ma katoemi a man ka tu hatei rilia limiu? ");
INSERT INTO hla_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","A katun te la uanama i tar ba te hengoena u ranga i tar ba te kukutie nen, alia e haruto ragoi limiu ime te mar kato uanen. ");
INSERT INTO hla_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nonei e here nei a katun te katsin kuiena a luma. Ba nonei te kaho uana i iogana ba te hopuena u simel turu lapo. Bu uolo pan e la nama ba te mi gasena a luma. Kaba e ma gas homie ien, taraha a luma i kui hanigei. ");
INSERT INTO hla_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kaba a katun te hengoena u ranga i tar ba te ma kukutie neien e here nei a katun te kuiena a luma turu tsikitsiki puku ba te ma haka mame nei tu simel. Ba poata te la nama u uolo pan, e mi topei lupena a luma ba te omi hakapana.” ");
INSERT INTO hla_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Poata te ranga hakapa nia e Iesu a man ka teka tara barebana, me la uana tara taun i Kapeneam. ");
INSERT INTO hla_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A toa tsunono turu soldiar i Rom te ma Jiui e kaia i Kapeneam ba te ka mena a katunun kui a tsomi i tanen te ka mei a nimate pan me katsin matena. ");
INSERT INTO hla_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ba poata te hengo nia a tsunono teka e Iesu, ba nonei e hala nena u palair u katun pan turu Jiu e gi na rangatse ien te ga la uamen ba te mi kato haniga poutsena a katunun kui i tanen. ");
INSERT INTO hla_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ba nori i la uamato tere Iesu me mi rangatan hatsunono naren, “Nonei a katun a niga e antunana alö go taguhe ien. ");
INSERT INTO hla_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Taraha, nonei e ngil koru rena u katun na han i tarara na nonei e kui hasi a luman lotu i tamulam.” ");
INSERT INTO hla_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Be Iesu e la gono mera nen. Poata te susuku ien tara luma ba tsunono turu soldia e tula rena u hahikapien i tanen e gi na hateien, “A tsi tsunono, alö go ma la soku mei. Alia e ma katun niga korugi ba te antunana te go la uama lö i iahana luma i tar. E moa. ");
INSERT INTO hla_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Na lia e ma niga hasgi antunana te go la u lia i tamulö. Alö go hala tun nema u raranga ba katunun kui i tar te niga pouts nou. ");
INSERT INTO hla_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Alia e ka has gia i kopina a nitagala turu katun pan i tar, na lia e ka has megu u soldia te ka puta ria i tar. Alia go ranga mei ta toa ba te poiegu, ‘La!’ ba nonei te lana. Na lia go ranga mei ta tai, ‘Lama!’ ba nonei te la nama. Na lia go ranga mei a katunun kui i tar, ‘Kui a ka teka!’ ba nonei te kuie nen. Nu ranga tun has i tamulö e ka mena a nitagala.” ");
INSERT INTO hla_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Be Iesu e asingoto koruto te hengo menien u ranga teka. Ba nonei e habirits kopisina me poiena turu katun u para ti kukutien, “Alia e hatei rago limiu, alia e mamala sabiegi ta toa ta katun i Israel has te ga ka mei a mar nihamana a niga te ka mena a tson teka.” ");
INSERT INTO hla_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bu katunun tatala i la pouts uato tara luma tara tsunono turu soldia ba nori e na sabier a katunun kui i tanen e niga hakapa pouts. ");
INSERT INTO hla_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","E ma manasai be Iesu e la uato tara toa taun a solonen i Nein. U katunun tsitsilo i tanen nu katun u para koru i la gono meien. ");
INSERT INTO hla_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tara poata te susuku ien tara tamana tara ololo tara taun, ba toa katun a mate e soata halakase rima ti na kaho meni, a toa puku a pien tson tere tsinanen, na nonei a tahol a amoba. Nu katun u para koru tara taun i la gono meien. ");
INSERT INTO hla_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na tara poata te tareia a Tsunono a tahol teka, ba nonei e tagagi koru nanen, me poiena i tanen, “Alö go ma tabei.” ");
INSERT INTO hla_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Be Iesu e na sebeliena a bokisin mate. Bu katun ti soatsen i tuol hakokomototo. Ba nonei e poiena tara mate, “Katun a hitots, alia e poiegu i tamulö, takei!” ");
INSERT INTO hla_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ba katun te mate e takeito me tanian rangana. Be Iesu e hala pouts nanen tere tsinanen. ");
INSERT INTO hla_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bu katun hoboto e matout korur, me soata seier a solone Sunahan me poier, “A propet pan te ka mena a solo pan e butu hakapa i gusurara! E Sunahan e la silema ga mi taguhir u katun i tanen!” ");
INSERT INTO hla_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bu raranga teka te hatein e Iesu e la hobotona tara provins i Judia na tara man han ti sukusuku. ");
INSERT INTO hla_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bu katunun tsitsilo tere Jon i hateie ten a man ka teka. Be Jon e ngö mera nei a elasolana i taren i tanen. ");
INSERT INTO hla_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ba nonei e hala mera neien tara Tsunono te gi na rangatse ien, “Nonei alö te rarangein e Jon te go lama, tsi alam go hahalosi ta tabi?” ");
INSERT INTO hla_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Tara poata teka e Iesu e kato haniga poutsir u katun u para ti ka mei a mamana mar nimate nu mate u omi, me hatara pouts has rena u katun u matakiau u para. Poata ti butu uama u katunun tsitsilo tere Jon tere Iesu, ba nori e poier, “E Jon a Tsonun Baptais te tula rena molam e go mi rangata, ‘Nonei alö te rarangein e Jon te go lama, tsi alam go hahalosi ta tabi?’” ");
INSERT INTO hla_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Be Iesu e palis ranen me poiena, “La pouts iam ba te na hateiemi e Jon a man ka te tare mula limiu na te hengoe mula limiu: a matakiau e tara haniga poutsuna, na mou-omi e lalana na toba e kato haniga poutser, na talinga tupu e hengona, nu katun ti mate e hatakei pouts rer ba te toatoar, nu Bulungana u Niga e hatei naria turu katun pinopino. ");
INSERT INTO hla_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na katun te ma hapolase nei a nihamana i tanen i tar e sasala nou!” ");
INSERT INTO hla_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tara poata ti la hakapaia u katunun tatala tere Jon, be Iesu e hatanian ranga mera nei u katun e Jon me poiena, “Tara poata tu la uam limiu tara latu pinipino te go na tara menami e Jon, alimiu u poe iam nonei a saha mar katun? E here nei u nga te hula bahena a lomolomo ba te haharoei nena a katun te hula hakatsina? E moa. ");
INSERT INTO hla_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tsi alimiu u la sil iam te go na tara menami a katun te ka mei u hasobu u niga koru? Kaba a mar katun teka e kana tara luma a tsimala koru na luma tara king. E ma tatei ka neia tara latu pinopino! ");
INSERT INTO hla_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tsi alimiu u la sil iam te go na tara menami a propet? Aa, e Jon a propet hamana. Na a katun te pan hasna tara propet. ");
INSERT INTO hla_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Taraha, u Buk u Goagono e ranga hatei nena e Jon, ‘E Sunahan e poiena, Hengo! Alia e hala negu romana a katunun tatala i tar te go mam nio lö, ba nonei te hamatsköena romana a maroro i tamulö.’ ");
INSERT INTO hla_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na lia e ranga mera golimiu, e Jon e panna turu katun hoboto ti poseia i puta. Kaba a katun papala koru tara Nipepeito tere Sunahan e pan has nena e Jon, te kato a toukui i tanen i mam tara Nipepeito tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","U katun u para nu katunun lulu takis, poata ti hengo ien u ranga tere Iesu, nori i poei a maroro tere Sunahan e matsköna, taraha nori i habaptaisia tere Jon. ");
INSERT INTO hla_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kaba u Parisi nu tson hihatuts turu Lo i tori hasoalein u ngil tere Sunahan i taren, na nori i raman a tou baptais tere Jon. ");
INSERT INTO hla_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Be Iesu e poiena, “Ga lia e go poei alimiu a barebanar i romana e heremi aha? A saha ka te tatei haharoei rano limiu? ");
INSERT INTO hla_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Alimiu e heremi a galapien te hirata ria tara makumun toana, ba palai i taren te poier, ‘Alam e katoe mula u kömana tara hitöl, kaba limiu e ma sasala mulei! Na lam e köma hase mula u hahuri, kaba limiu e ma tabe mulei.’ Ne kato has uana i iesana tere Jon a Tsonun Baptais na lia. ");
INSERT INTO hla_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","E Jon e ma tatei noue nei a tana kannou ne namala ua hase nei tu wain. Ba limiu e poiemiu, ‘Nonei a katun a popoloana!’ ");
INSERT INTO hla_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Na lia tu butun katunuma e tatei nouegu a mamana kannou ne tatei ua hasegu u wain. Kaba limiu e poie miu, ‘Pua! Nonei a nounou-pala, na katun a uaua-pala! Na nonei e kapiena has rena u katun te luluer a takis nu palair u katun u omi!’ Alimiu e mar ranga uamiu teka. ");
INSERT INTO hla_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kaba noahasina. A man markato turu katun tere Sunahan e haruto nena te mana uana a niatei i tanen.” ");
INSERT INTO hla_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","A toa katun turu Parisi a solonen e Saimon e ngö e Iesu e ga nou gono meien. Be Iesu e la uato i luma i tanen me gum silena a tou nou. ");
INSERT INTO hla_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tara taun teka e kaia a toa tahol ti ngöei a tahol a omi. Nonei e hengoen te nou u e Iesu tara luma tere Saimon a Parisi, ba nonei e la mena a tsi toa tsi botolo turu uapi u soksoka me la uana nonei tara luma. ");
INSERT INTO hla_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ba nonei e na tuolna i murina e Iesu i rehina mounen.* Ba tahol e tabena me hapulise nei a man moune Iesu u sulunmata i tanen. Ba nonei e hapalake neien a hulunen, me mutsi ranen, me tsu rane ien u uapi u soksoka. ");
INSERT INTO hla_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ba tara poata te tareia a Parisi te ngö e Iesu a ka te kato a tahol, ba nonei e hakats tununa me poiena, “Te ga propet hamanaia a katun teka e Iesu, ba nonei te ma tatei haniga nanei te go sebele menien a tahol teka, taraha nonei a tahol a omi!” ");
INSERT INTO hla_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Be Iesu e poiena tara Parisi, “O Saimon, alia e ka megu a tsi ranga te katsin ranga megi lia alö.” Be Saimon e poiena, “Hateie molia, Tson Hihatuts.” ");
INSERT INTO hla_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Be Iesu e poiena, “A elasolana katun i harohen a moni tara katun te roron halan a moni tara toukuin bisnis i tanen. A toa e harohen a 500 denarius. Na toa denarius a hihol turu toa u lan. Na tai e harohen a 50 denarius. ");
INSERT INTO hla_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na i murimuri a elasolana hoboto i ma antunan palis poutsi a moni, ba katunun halhala moni e hakapeto a haroho tara elasolana. Ba saha katun te tatei ngil balena nonei a katunun halhala moni?” ");
INSERT INTO hla_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Be Saimon e poiena, “Toum, nonei a katun te ka mei a haroho pan te lu ban a katunun halhala moni.” Be Iesu e poiena, “U ranga pouts i tamulö e matsköna.” ");
INSERT INTO hla_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Be Iesu e habirits uana tara tahol me poiena tere Saimon, “Alö go ruto tara tahol teka. Alia e tasu guma i luma i tamulö, ba lö e ma hale mulei lia tu ramunun galus turu mou tara markato i tarara. Kaba a tahol teka e tobue lalei a man mour u sulunmata i tanen me hapalaka rane ien a hulunen. ");
INSERT INTO hla_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Alö e ma hatsomie mulei lia ba te mutsie molia te mar kato uar a pala i tarara. Kaba a tahol teka e ma hapolasan mutsi noe lalei a man mour popona te tuku uagu lalia. ");
INSERT INTO hla_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Alö e ma hakis namu lei tu wel i bakur tara markato i tarara. Kaba a tahol teka e tsu nelala u uapi u soksoka tara man mour. ");
INSERT INTO hla_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Na lia e ranga mego lö, nonei e kato hakapi a para a markato a omi, kaba nonei e haruto nalala nonei e ngil korue nolia, taraha alia u lu bar u markato u omi u para i tanen. Kaba u katun ti ma kato balei a man markato a man omi ba te atei siler e Sunahan e lu ba nen, u katun teka e ma ngil bala korueri e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Be Iesu e poieto tara tahol, “Alia u lu ba hakapein a man markato a man omi i tamulö ba te solopala ragen.” ");
INSERT INTO hla_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ba pala ti nou gono meien e hiararangar me poier, “Esi banei teka? Nonei e lu ba tsipon has nena u markato u omi? A katun tun e ma antuna nei tara ka teka!” ");
INSERT INTO hla_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Be Iesu e poieto tara tahol, “E Sunahan e taguhe nolö, taraha alö e hamanam. La tala, na torimulö e tatei husa poutsuna.” ");
INSERT INTO hla_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","Tara tana poata i murimuri e Iesu e hula la u turu taun nu han, me hatei la nena u Bulungana u Niga tara Nipepeito tere Sunahan. Na l2 a katunun tsitsilo i tanen i la gono meien, na palair has u tohaliou ti kato haniga bari u mate u omi na man nimate has. Nori a tohaliou teka: e Maria Matalina, ti tsuga bani a elahit a mate a omi i tanen. ");
INSERT INTO hla_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ne Joana, a tahol tere Kusa a toa tson pepeito tere Herot a King. Ne Susana, na palair u tohaliou has u para ti taguhi e Iesu nu katunun tsitsilo i tanen ba te hala raren a man ka ti ngilen. ");
INSERT INTO hla_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","5","U katun i la noa hasima tara mamana taun, na tara poata ti gonoia u katun tere Iesu, ba nonei e ranga nena u haharoei teka me poiena, “A toa katun e na hula tsihasein a ngalina kannou. Tara poata te tsihasa nien u ngal tara kui, a palai i pururukuia tara maroro ti tötö rien, bu apena e mi nou raren. ");
INSERT INTO hla_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Na palai i pururukuia turu tsikitsiki te ka mei u lapo, ba poata ti pusuku ien ba nori e langor, taraha u tsikitsiki e moa tu ramun i tanen. ");
INSERT INTO hla_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Na palair u ngal i pururukuia turu tsikitsiki te ka mei a kolits a hihitoka, bu kolits e pusuku hapan gono meren me kato homiena a man kan leba teka. ");
INSERT INTO hla_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nu palair u ngal i pururukuia turu tsikitsiki u niga. Bu ngal e pusuku hapanir me ka mer a hua a para koru.” Be Iesu e ranga hapanina me poiena, “A katun te atein hengona e ga hengo haniga!” ");
INSERT INTO hla_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Bu katunun tsitsilo tere Iesu e rangate rien ime te mouna u u haharoei teka. ");
INSERT INTO hla_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Be Iesu e ranga palisina, “E Sunahan e haruto ranei limiu a ka te ma haruto rien a palair u katun i manasa, nonei te go atei sil mena milimiu ime te mar pepeito kap uanen. Kaba nori e hengo tuner u haharoei. Taraha, nori e tarar kaba e ma tara hamanari, na nori e hahengor kaba e ma ateiri.” ");
INSERT INTO hla_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Be Iesu e poiena, “U haharoei te ranga negu lalia te kato uana teka: a ngal e here nei u ranga tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","A ngal te pururukuia tara maroro e kato uana tara pala te hengoer u ranga tere Sunahan, kaba e Satan e mi gul ba nena u ranga te gamon kaia i toriren. Taraha, nonei e rama nena te gi hamana uen be Sunahan te lu pouts ranen. ");
INSERT INTO hla_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nu ngal te pururukuia turu tsiktsiki te ka mena u lapo e hatei nena a pala te hengoer u raranga ba te sasala koru meren. Kaba u raranga e ma la koru nei turu hakhakats i taren. Ba te hamana mier a tsitabubun poata, ba poata te la nama a tou hiamus, ba nori te hanoan hamanar. ");
INSERT INTO hla_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nu ngal te pururukuia tara makum te ka mena a kolits a hihitoka e hatei nena a pala te hengor, kaba nori e ka mer u hakhakats pan tara nitoatoa i puta, ba te hakats koru ner a moni na man nisasalana i puta. Na man ka teka e here nei e piler u raranga tere Sunahan bu raranga te ma habutse nei u markato u niga turu katun teka. ");
INSERT INTO hla_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bu ngal te pururukuia turu tsikitsiki u niga e hatei nena a pala te hengoer u ranga ba te hake rien turu hakhakats u niga i toriren, ba nori te pile kap hakarapoto naren. Bu raranga te kato hanige iena a markato turu katun teka ba te kato talasina.” ");
INSERT INTO hla_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Be Iesu e poiena, “A katun te hakulupena u lam e namala kopo kap nane ien a tabeli ne namala hake neien i kopina inana. E moa, e roron hake nen tara makumun gumgum i tanen i iasa ba barebana te tatei tarer u kulupu tara poata te tasu rien. ");
INSERT INTO hla_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ne kato has uana i iesana, a mamana ka hoboto te mousuna turu haharoei i tar i romana e atei riou romana i murimuri. Na mamanu ranga i tar te ma atei sileri a barebana i romana, nori e atei sile roen romana i murimuri. ");
INSERT INTO hla_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Alimiu go tara kap haniga niam te mar hengo uami limiu. Taraha, a katun te ateina, e Sunahan e hala lele noien romana ta niatei. Kaba a katun te raman ateina, e Sunahan e lu ba nenou romana a tsitabubun niatei te ga poien e ga ka meien.” ");
INSERT INTO hla_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","E tsinane Iesu nu toulanen i la uama i tanen, kaba nori i ma antunan la hasukusuku uai i tanen, taraha a katun e gono. ");
INSERT INTO hla_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ba toa katun e poiena tere Iesu, “E tsinamulö nu toulamulö e tuol ria i iesesala ba te ngilin ranga gono merio lö.” ");
INSERT INTO hla_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Be Iesu e poiena i taren hoboto, “U katun te hengoer u ranga tere Sunahan ba te kukutie ren, nori has e hereri e tsinar nu toular.” ");
INSERT INTO hla_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Turu toa u lan be Iesu e osa gon merena u katunun tsitsilo i tanen tara tsi toa tsi tolala tara Ramun i Galili. Me poiena i taren, “Ara gi aroho u i hapalana ramun.” ");
INSERT INTO hla_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ba nori e la talar me seil talar, be Iesu e sohona. bu panina u ualupu e butuna tara ramun bu ramun e katsin saputuna tara tolala, a tsitabubu koru ba nori te rukur. ");
INSERT INTO hla_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ba nori e gulier e Iesu me poier, “O Tsunono, Tsunono! Ara e katsin tia talara!” Ba nonei e tagulena me abis hatagalana tara lomolomo na turu ramun te posa here mei u tasi pan. Ba lomolomo nu keikei e opu poutsuna ba seloho pan e butuna. ");
INSERT INTO hla_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ba nonei e poiena turu katunun tsitsilo i tanen, “Alimiu e ma hamanami?” Ba nori e asingoto korur me matoutur, ba nori e hiarangrangatar, “A saha koru a mar katun teka? Nonei e hala nena u ranga tara lomolomo nu ramun te posana ba te selohona!” ");
INSERT INTO hla_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ba nori e seilir me na tuku ria tara provins ti kaia a pal barebana ti ngöri u Gerasin. A han teka e kana i hapalana ramun na provins i Galili e kana i hapala. ");
INSERT INTO hla_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Be Iesu e toan kouluna tara tsi tolala ba nonei e sunguna me hitupali mena toa katun tara taun i sukusuku, u mate u omi i seseia i tanen. Poata lehana nonei e mamala pousei tu labalaba, na e mamala kai tara toa luma. E moa. E ka lasia i ngahongaho tara man kioun mate. ");
INSERT INTO hla_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ba nonei e tarena e Iesu me ku hapanina me tuhatukun nena i matane Iesu me turu putana. Ba nonei e ku hapan koruna me poiena, “O Iesu a Pien Tson tere Sunahan Iasa Koru! Alö go haka ba nio lia! Alia e singo hatatagi gia i tamulö, alö e moa te go hahuna menai lia!” ");
INSERT INTO hla_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nonei e kato u teka, taraha e Iesu e ranga hakapa mei a mate a omi e ga koul ban a katun teka. Para a poata a mate a omi e roron pile kapin a katun teka. U katun i taratara kap nitoa nen ba te kitseri a limanen na mounen a tsien. Kaba nonei e roron kato pupus a tsien na mate e roron hapieta menien tara latu pinopino. ");
INSERT INTO hla_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Be Iesu e rangatse nen, “Esi a solomulö?” Ba nonei e ranga palisina me poiena, “A solor e Ami.” Taraha a mate a omi a para i sei hakapaia i tanen. ");
INSERT INTO hla_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bu mate e singo hatagala uar tere Iesu me poier, “Alö go ma hala merai lam tara kiou te tsiruku nitoana.” ");
INSERT INTO hla_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A toa heis poum pan i nouia i rehina u pokus te sukusuku. Bu mate u omi e singo ria tere Iesu me poier, “Alö go hala merai lam tara heis poum!” Be Iesu e hanigana i taren. ");
INSERT INTO hla_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ba nori e koul ba ner a katun teka me na sei ria turu poum. Ba heis poum teka e hiapipieta gala hoboto sila ria turu uarahana. Ba nori e na rus ria i ramun me pasur me mate hakapar. ");
INSERT INTO hla_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bu katun ti hanhanour u poum i tareto a ka teka me busur, me na polaser u ranga tara taun na turu han. ");
INSERT INTO hla_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ba barebana e mi katsin tarer a ka te butu. Ba nori e la uarima tere Iesu me tarer a katun u mate u omi ti koul ba hakapa nen. Nonei e gumia i rehina i mouna e Iesu ba te haseiena u hasobu bu hakats i tanen te niga poutsuna. Ba nori e matoutur. ");
INSERT INTO hla_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bu katun ti tara a ka teka e hatei rer a barebana te mar niga pouts u nonei a katun a popoloana. ");
INSERT INTO hla_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bu katun hoboto tara han turu Gerasin e tahuler e Iesu te ga la pouts uen i han i tanen, taraha nori i matout koru. Be Iesu e osa poutsna tara tsi tolala, te ga la pouts uen. ");
INSERT INTO hla_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Ba katun ti la ban u mate u omi e rangatsena e Iesu, “Alia go la gono meio lö.” Kaba e Iesu e hala poutse ien me poiena, “Alö go la pouts i han i tamulö ba lö te na rarariem a ka te kato bena mei lö e Sunahan.” Ba katun teka e la uana tara mamana makum i iahana taun me na habulungana lanena a ka te kato beien e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Poata te tuku poutsia e Iesu i hapalana ramun, ba barebana e sasala mer te la pouts uamen, taraha nori hoboto i hahalose ien. ");
INSERT INTO hla_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ba toa tson pepeito tara luman lotu e tuhatukun nena i matane Iesu me turu putana me singo hatatagi silena te ga la u e Iesu i luma i tanen. ");
INSERT INTO hla_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Taraha, nonei e ka mei a toa puku a pien tahol te ka mei a 12 a hiningal i tanen, na nonei a tsi tahol e katsin mate. Be Iesu e lana bu barebana e hipasasi ria i tanen. ");
INSERT INTO hla_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na toa tahol e kaia i gusuren te posa nitoan u rahatsing popoia tara 12 a hiningal. Nonei e lapo hakapein u moni hoboto i tanen tara dokta a para, na e moa ta toa te ga antunan kato haniga pouts neien. ");
INSERT INTO hla_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nonei a tahol teka e la hasukusukuia i murina e Iesu ba te hasebelena i runguna u hasobu tere Iesu, bu rahatsing i tanen e topei kapana. ");
INSERT INTO hla_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Be iesu e rangatana, “Esi te sebele lala i tar?” Ba barebana hoboto e holisir, be Pita e poiena, “Tsunono, u barebana e tuol hahise rio lö ba te hiasusongo ria i tamulö.” ");
INSERT INTO hla_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kaba e Iesu e poei, “A toa katun e hasebele lala i tar. Alia e hasagohe gula a nitagala i tar e taguhe lala a tana katun.” ");
INSERT INTO hla_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ba tahol e atei sil hamanasena te ma antunan mous lel ba menien e Iesu, ba nonei te tololo mena a nimatout. Ba nonei e na tuhatukun nena i matane Iesu me turu putana. Na i matana a barebana hoboto, nonei e hatei e Iesu a mouna a ka te hasebele sile ien i tanen, ne hatei hasin ime te mar niga boroboro pouts halona uen. ");
INSERT INTO hla_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Be Iesu e poiena i tanen, “A tsi tahol, a nihamana i tamulö e kato haniga poutse lala a nimate i tamulö. La tala, na torimulö e tatei husa poutsuna.” ");
INSERT INTO hla_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Poata te ranga noaia e Iesu, ba toa katununa tara luma tere Jairas e la nama me mi hateie nen me poiena, “A pien tahol i tamulö e mate hakapa. Alö go ma hakui leli a Tson Hihatuts.” ");
INSERT INTO hla_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Be Iesu e hengona me poiena tere Jairas, “E moa te go matout u lö. Alö go hamana tun talasi, ba pien tahol i tamulö te niga pouts nou.” ");
INSERT INTO hla_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Be Iesu e na tukuna tara luma ba nonei e hapiu rena a barebana te gi tasu gono menien i luma, e Pita lasi mere Jemis ne Jon ne tamana pien ne tsinanen. Nori lasi ti tasu gono mei e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na barebana hoboto i tabe sil a pien teka. Be Iesu e poiena i taren, “Alimiu e moa te go tabe uam. A pien e ma mate nei, e soho tununa.” ");
INSERT INTO hla_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ba nori e gol hahamana naren, taraha nori i atei sil te mate hakapa u a pien. ");
INSERT INTO hla_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Be Iesu e luena a limana a pien me ranga hapanina me poiena, “A tsi pien, alö go takei.” ");
INSERT INTO hla_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bu namnameina a pien e la pouts nama i tanen, ba nonei e topei takeina. Be Iesu e ranga mera nen me poiena, “Alimiu go halei mien ta ka ga noue ien.” ");
INSERT INTO hla_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ne tamana pien ne tsinanen i asingoto koru. Kaba e Iesu e ranga hatagala mera ien me poiena, “Alimiu go ma hateiemi ta toa ta katun a ka te butu lala teka.” ");
INSERT INTO hla_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","E Iesu e ngö gugoner a 12 a aposol i tanen me hala rane ien a nitagala pan te gi tatei tsuga meien u mate u omi hoboto na te gi kato haniga pouts meri u katun te ka mer a man nimate has. ");
INSERT INTO hla_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ba nonei e hala mera neien te gi na hihatuts lame nien a Nipepeito tere Sunahan na te gi na kato haniga pouts merien u katun te ka mer a nimate. ");
INSERT INTO hla_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ba nonei e poieto i taren, “Ma soatsemi ta ka te la uami limiu: e moa tu tukana na ta pora, na ta kannou na ta moni, ne moa has tu tana tu hasobu tu ngahangaha. ");
INSERT INTO hla_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Te haniga ria a toa pal katun i tamilimiu, ba limiu te susoho mia tara toa luma popona te go la ba nemia limiu nonei a taun. ");
INSERT INTO hla_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Te ma haniga raria limiu u katun, tohu ba neiam u koahu i pitpitan moumilimiu ba te la ba nemiu a taun i taren. A markato teka e haruto rano ien te raharaha mera neien e Sunahan, taraha nori e hipus ner u ranga i tanen.” ");
INSERT INTO hla_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bu aposol e takeir me la sila ria i iahana man han, me hihatuts ner u Bulungana u Niga me kato haniga pouts rer u katun tara mamana han. ");
INSERT INTO hla_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","E Herot a Kingina i Galili e hengoen a mamana ka te kato e Iesu ba nonei e tutu nena a ha koru te butu, taraha a barebana i rangein e Iesu me poier, “E Jon a Tsonun Baptais e takei poutsia tara tou mate i tanen!” ");
INSERT INTO hla_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ba palai e poier, “E Ilaitsa e butu pouts,” ba palai e poier a tana propet ni manasa e toatoa pouts. ");
INSERT INTO hla_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Be Herot e poiena, “Alia u hangats pagotein e Jon. Gesi nonei a katun te roron hengo negu lia?” Ba nonei e ngilin tara koru nena e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bu aposol e kopis rima tara nilala i taren me hateieri e Iesu a mamana ka ti katoe men. Ba nonei e lu ranen me peigi ranen me la pepeisa uar tara taun ti ngöei i Betsaida. ");
INSERT INTO hla_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Poata ti hengo nia a barebana a ka teka ba nori e kukutie ren. Ba nonei e haniga ranen me ranga mera neien a Nipepeito tere Sunahan, me kato haniga pouts rena a pala ti ka mei a nimate. ");
INSERT INTO hla_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ba poata te tanian tsirukuia a pitala, ba 12 a katunun tsitsilo e la uarima i tanen me poier, “Alö go halar u katun ba nori te la uar turu han te sukusukur ba nori te na sakier ta makumun susoho na ta kannou. Taraha, e moa ta han teka.” ");
INSERT INTO hla_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Be Iesu e poieto i taren, “E moa, alimiu go hala ramien ta ka gi nouen.” Ba nori e ranga palisir, “A man ka te ka memu lam a tolima beret na solana iena puku. Alö e ngilem alam e go na hol ta kannou turu katun hoboto teka?” ");
INSERT INTO hla_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nori i ranga u teka taraha a pal tson peisa i antuna toumia tara 5,000. Be Iesu e poieto turu katunun tsitsilo i tanen, “Hagum ramia u katun popona tara man 50 tara man hagum hoboto.” ");
INSERT INTO hla_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bu katunun tsitsilo e kato has uar te ranga u e Iesu me hagum rer u katun hoboto. ");
INSERT INTO hla_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Be Iesu e lueto a tolima beret na solana iena, me tara sei uana i Kolö, me hanigana tere Sunahan tara man ka teka, me pose ranen, me hala rane ien u katunun tsitsilo i tanen e gi molamola rien u katun. ");
INSERT INTO hla_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ba nori hoboto e nour me masulur. Bu katunun tsitsilo e onger a 12 a kalobaka tara man ka ti nou ban u katun. ");
INSERT INTO hla_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tara toa poata te singo pepeisaia e Iesu, bu katunun tsitsilo e la uarima i tanen. Ba nonei e rangata ranen, “U katun e poier alia esi?” ");
INSERT INTO hla_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ba nori i ranga palise ten, “A palai e poier alö e Jon a Tsonun Baptais te takei pouts. Na palai e poier alö e Ilaitsa, na palai e poier alö a tana propet ni manasa te toatoa poutsuna.” ");
INSERT INTO hla_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ba nonei e rangata ranen, “Gime te kato uami limiu? Alimiu e poiemiu alia esi?” Be Pita e ranga palisito, “Alö e Mesaia tu lama tere Sunahan!” ");
INSERT INTO hla_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Be Iesu e hala rate ien u ranga u tagala koru e gi ma hateii ta toa ta katun te Mesaia uen. ");
INSERT INTO hla_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ba nonei e ranga noana, “Alia tu butun katunuma e sagohe gou romana a kamits pan. Ba pal kapan nu pris pan nu tson hihatuts turu Lo e tori hasoala nariu romana lia. Alia te kato hamatie riou romana, ba turu hatopisanu lan ba lia te hatakei poutse riou.” ");
INSERT INTO hla_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ba nonei e poieto i taren hoboto, “Te ngilin la gono mena molia ta katun, e ga solopali a peisanen, ba te hanigana te ga sagoho menien u kamitsina te kukute mena neien lia turu mamanu lan te mar kato uana a katun te soatsena a korusena tara tou mate i tanen, ba te la gono mena molia. ");
INSERT INTO hla_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Taraha, a katun te ka mena u hakats pan te go haka haniga meni a nitoatoa i tanen ba te peits nanen i tar, nonei e na hataia tun noa hase nen romana. Kaba a katun te hataia sile nei a nitoatoa i tanen te ngil koru mena neien lia, nonei e sabie nen romana. ");
INSERT INTO hla_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Te ga lueia ta katun a man ka hoboto ni puta ba te toan taia ba nena a nitoatoa te ka nitoana, ga mamana ka teka e mar taguhu halona mena noien ime? E moa tala. ");
INSERT INTO hla_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Na sanena a toa katun e ga matsingolo nio lia nu ranga i tar, ba lia tu butun katunuma te matsingolo has nagen romana tara poata te la meguma romana lia u ualesala i tar na tere Tamagulia na turu angelo u goagono. ");
INSERT INTO hla_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na lia e hatei hamana rago limiu, a palair u katun teka e ma materi romana e popona te gi na sabe menien a Nipepeito tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Turu hatoalina toum u lan i murina te ranga nien a man ka teka, e Iesu e lui e Pita ne Jon ne Jemis me la sei uar i ieluna u pokus te na singo u. ");
INSERT INTO hla_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tara poata te singo ien, ba polenen e palisina, nu hasobu i tanen e butun hiaka koru me here nei u ualesala. ");
INSERT INTO hla_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ba elasolana katun e songots butu merima u ualesalana i Kolö me ranga gono mer e Iesu. Nori ere Moses mere Ilaitsa, u propetir i manasa ti mate. Ba nori e ranga gono mier e Iesu te na mate noien i Jerusalem ba te hakapena u ngil tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tara poata teka e Pita na pala ti ka gono meien i topi koru me sohor. Kaba nori i tagule me ruter u ualesala tere Iesu na elasolana katun ti tuol gono meien. ");
INSERT INTO hla_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","A elasolana katun i katsin la ban e Iesu, be Pita e poiena i tanen, “O Tsunono, e nigana te ka uaria ra teka. Alam go kui a topisa taluhu, a toa i tamulö, na toa tere Moses, na toa tere Ilaitsa.” Kaba e Pita e ma ateii a ka te ranga nen. ");
INSERT INTO hla_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tara poata te ranga noa ien, bu toa u koasi te butuna bu uoho i tanen e hoho ranen. Bu katunun tsitsilo e matoutur te kopo kap merien u koasi. ");
INSERT INTO hla_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Bu toa u ranga e butu mata turu koasi me poiena, “Nonei a Pien Tson i tar teka, a katun tu hopu kapin lia. Alimiu go hengo mia i tanen!” ");
INSERT INTO hla_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tara poata te hanoaia u ranga, be Iesu e ka pepeisana. A elasolana katun i la hakapa. Bu katunun tsitsilo e hahalongolo koru mer a ka teka, na nonei tara poata nori i ma hateii ta toa ta katun a ka ti tare ien. ");
INSERT INTO hla_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Bu tana u lan ba nori e koul rima turu pokus, bu katun u para e hitupal mier e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ba toa katun e kuta i gusur u barebana, “Tson Hihatuts, alia e ranga megu a nitatagi i tamulö, alö go na ruto tara pien tson i tar. Nonei a toa puku a pien tson i tar! ");
INSERT INTO hla_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","A toa mate a omi e roron pile kap nanen, ba te songots ku hapanina. Na mate teka e roron hula tula homi koru nanen, antunana te butuna u poeipoei i rungnen. Nonei e roron kato homi koruena a tuanreinen, ne mamala hapurese borobore neien. ");
INSERT INTO hla_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Alia u tahul hatatagi korur u katunun tsitsilo i tamulö gi tsuge ien, kaba nori i ma antunai.” ");
INSERT INTO hla_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Be Iesu e ranga palisito, “Alimiu u katun u hahamana koru na limiu e ma matskömi! Alia e soso koru megu a nihahamana i tamilimiu!” Ba nonei e poieto tara katun, “Hala mena mei a pien tson i tamulö teka.” ");
INSERT INTO hla_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tara poata te lama a pien, ba mate a omi e lapo ba nanen i puta me hula tula homi nanen. Be Iesu e tsuge ieto a mate, me kato haniga poutsena a pien, me hala poutse neien e tamanen. ");
INSERT INTO hla_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bu katun e asingoto hoboto koru ner a nitagala a kapan tere Sunahan. (Matiu 17:22-23, Mak 9:30-32) A barebana i hakats hapara noan a mamana ka te kato e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ba nonei e poieto turu katunun tsitsilo i tanen, “Hakats koru neiam u ranga teka: alia tu butun katunuma e sukusukun hala menari tara nitagala turu katun.” ");
INSERT INTO hla_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kaba nori i ma ate silei a mouna u ranga teka. A mounen i hamous rien e gi ma atei sile ien. Na nori i matoutun rangata neien u ranga teka. ");
INSERT INTO hla_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","U katunun tsitsilo i hiarangrangatein esi i taren a kapan. ");
INSERT INTO hla_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ne Iesu e atei sil aha ti hakats nen, ba nonei e luena a toa pien, me hatuole nen i rehinen. ");
INSERT INTO hla_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Me poiena i taren, “A katun te nigana tara pien teka te pien uanen i tar, e here nei e niga hase nolia. Na katun te nige nolia, e niga hasena e Sunahan te hale molia. A katun te teteneina i gusumilimiu hoboto nonei a kapan hamana.” ");
INSERT INTO hla_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Be Jon e poiena, “O Tsunono, alam u tari a katun e tsuga ban u mate u omi tara solomulö. Ba lam u ranga hapiu naten, taraha nonei e ma pala uanei i tarara.” ");
INSERT INTO hla_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Be Iesu e poieto i tanen na turu katunun tsitsilo, “Ma torohanan hapiu nami, taraha a katun te ma pal ranei limiu e haniga rano limiu.” ");
INSERT INTO hla_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","A poata e susuku hakapa te gi lu menai e Iesu i Kolö, ba nonei e hakhakats hakarapoto nena te ga la uen i Jerusalem me tanian lana. ");
INSERT INTO hla_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ba nonei e hala mam rena u katunun tatala, ba nori e na tuku ria tara toa han i iahana provins i Sameria te gi na hamatskö mam beien a man ka. ");
INSERT INTO hla_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kaba u katun tara han teka i ma ngili e Iesu, taraha nori i atei sil nonei e la uana turu lotu halhal i Jerusalem. ");
INSERT INTO hla_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Poata te hengo sabeia e Jemis ne Jon a ka teka, nori i raharaha me poier, “Tsunono, alö e ngilem alam e go ngö hakoulema u tula i Kolö ba te mi kato homi rena u katun teka?” ");
INSERT INTO hla_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Be Iesu e habiritsito me ngena ranen. ");
INSERT INTO hla_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ba nori e la lelir tara tana han. ");
INSERT INTO hla_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tara poata ti la ien i maroro, ba toa katun e poieto tere Iesu, “Alia e la gono mego lö tara mamana han te lala uamou lö.” ");
INSERT INTO hla_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Be Iesu e poieto i tanen, “U muki u hie e ka mer u kiou i taren, nu apena e ka mer u suhana. Kaba lia tu butun katunuma, alia u moa ta makumun soho i tar.” ");
INSERT INTO hla_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ne Iesu e poei tara tai, “La gono memo lia.” Ba nonei e poieto, “O Tsunono, e ma pina noi be tamagulia te mate nou. Alö go haniga te go na ngaho mam menien lia, ba te toan lala gono mego lö.” ");
INSERT INTO hla_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ba nonei e poieto i tanen, “U katun te ma hengoeri e Sunahan ba te hereri i mate ban a nitoatoa i tanen, nori te tatei ngaho rer u mate i taren. Kaba lö go na habulunganein a Nipepeito tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ba tabi e poiena, “Alia e kukutie gou lö, O Tsunono. Kaba lö go hala buna molia ba lia te na ruto polasa buguma tara pala i tar.” ");
INSERT INTO hla_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Be Iesu e poieto i tanen, “A katun te tanian kukutie nolia ba te roron tara pouts uana tara nikaka mam i tanen, e ma antuna nei tara Nipepeito tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","I murimuri ba Tsunono e hopu kapu reto u 70 u katun. Nonei e ngil te gi mammam uen turu taun nu han hoboto te katsin la uen — a man elasolana tara toa han, na tana elasolana tara tai, ba te kato talasina. ");
INSERT INTO hla_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Be Iesu e poieto i taren, “A katun a para e katsin hamana uar i tar, kaba e moa ta para ta katun te ga taguhu raien. E kato uana tara kui pan te tangoho hakapa ba te moana ta katun ta para te gi hagali a kannou. Alimiu go singo uam tara Tsunono te kato hahaloso mamir u katun teka ba te katsin hamana uar i tar. Alimiu go singo uam tara Tsunono ba te hala rena u katunun tsitsilo lel te gi la uen ba te na taguhu rer u katun e gi la uama i tar. ");
INSERT INTO hla_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","La tala mula. Alia e hala here ragi limiu u tunan sipsip te la uar i gusur u muki u hie, u katun te ngilin kato homi rario romana limiu. ");
INSERT INTO hla_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Alimiu go ma la memi ta paus moni tsi ta pora tsi ta palaina tu sendol. Alia te pile rago limiu tara mamana ka. Ma tuolmi ba te raranga gono memiu ta katun i maroro. ");
INSERT INTO hla_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Na i mam te go tasu uam limiu a man elasolana ta luma, alimiu go poe mame iam, ‘U katun tara luma teka, alimiu e tatei ka memiu a masalohana.’ ");
INSERT INTO hla_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na te ka noa ta katununa tara masalohana nonei tara luma, ba masalohana i tamilimiu te kaka noa i tanen ba te kalale nen. Kaba te ga moa u ta katununa tara masalohana, bu masalohana i tamilimiu te taguhu pouts rano romana limiu peisa. ");
INSERT INTO hla_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Alimiu go ka nitoa mia tara luma tara katununa tara masalohana ba te ma hula soho mia tara man luma. Alimiu e tatei noue miu ba te ue miu ta ka te gi hala nen, taraha a katunun kui e gi halei a hihol i tanen. ");
INSERT INTO hla_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Poata te na butu mia limiu tara toa taun bu katun te lu mera rilimiu i luma i taren, alimiu go noue iam a saha kannou te hanou rarien romana limiu. ");
INSERT INTO hla_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Alimiu go kato haniga pouts riam u katun te ka mer u nimate nonei tara taun ba te poemiu tara barebana, ‘A poatan pepeitokap tere Sunahan e susuku hakapa uama i tamilimiu.’ ");
INSERT INTO hla_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Kaba te butu mia limiu tara toa taun bu katun te ma haniga rari romana limiu, ba limiu te na tuol moa i kalana i iahana taun ba te poemiu, ‘Alam e tohu ba nem u koahu tara taun i tamilimiu te rokotona i moumulam! A ka teka e haruto nena te raharaha mera nei limiu e Sunahan. Alimiu go hakats haniga iam: a Nipepeito tere Sunahan e la hasusuku hakapa uama i tamilimiu, kaba limiu e rama tsiponmiu!’ Alimiu go mar ranga uamou teka. ");
INSERT INTO hla_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na lia e ranga mera golimiu, turu lanin hahuna tere Sunahan u katun tara taun teka e lue riou a nihahuna te pan bala nenou a nihahuna turu katun u omi i Sodom.” E Iesu e ranga u teka. ");
INSERT INTO hla_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","E Iesu e hihatuts me poiena, “A nomi pan koru e butuna romana i tamilimiu u katunur turu taun i Korasin na i Betsaida! Sanena e Sunahan e ga kato u mar mirakul turu taun i Taia na i Saidon i manasa tu kato u lia i Korasin na i Betsaida tara poata i romana, i manasa noa nori sane harutein ti tori-tsuga ba koru menien u markato u omi i taren. ");
INSERT INTO hla_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kaba turu lanin hahuna tere Sunahan, a nihahuna i tamilimiu u barebanar i Korasin na i Betsaida e pan bala nenou a nihahuna tara barebanar i Taia na i Saidon. Taraha, alimiu u hipus niam u ranga u mana ti namala hengo nien. ");
INSERT INTO hla_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na limiu u katunur tara taun i Kapeneam e ngilin soloseiemiu a peisamilimiu i iasa, kaba e Sunahan e lapo ba has ranoa limiu i puta i hel!” ");
INSERT INTO hla_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Be Iesu e poieto turu katunun tsitsilo i tanen, “U katun te hengo rario limiu e hengo hase rio lia, nu katun te tori-hasoala rario limiu e tori-hasoala has nario lia. Nu katun te tori-hasoala nario lia e tori-hasoala has ner e Sunahan te haleie molia.” ");
INSERT INTO hla_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nori u 70 tara katun i kopis mema a nisasala pan me poier tere Iesu, “O Tsunono, u mate u omi noa has i hengo koru u ranga i tamulam tu tsuga merien lam tara solomulö!” ");
INSERT INTO hla_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Be Iesu e ranga palis raten, “Aa, alia u tarei e Satan e rus here mei u kanaha i Kolö. ");
INSERT INTO hla_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Hengo iam! Alia u hala hakapa rilimiu a nitagala te go tötö mera milimiu u kukutsi nu kukoto, ba nori te ma hakamits raroi limiu. Na lia u hala hakapa rilimiu a nitagala te go tagala saluhe mena milimiu a nitagala hoboto tere Satan a katun te pakö rano ra. Ne moana romana ta ka te ga kato homi riou limiu. ");
INSERT INTO hla_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Alimiu e sasala memiu u mate u omi e hengo rario limiu. Kaba a tana ka te pan balana: e kato uana, alimiu go sasala koru meiam a solomilimiu i koloto hakapa nia i Kolö.” ");
INSERT INTO hla_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nonei has tara poata teka e Iesu e ka mei a nisasala pan turu Namnamei u Goagono me poiena, “O Tamar, a Tsunono pan ni Kolö ni puta! Alia e haniga koru megia i tamulö taraha alö e hamous ba nem u ranga u mana turu katun te poier e ka mer a niatei, ba te haruto namen turu katun papala te ma atei balari. Aa, o Tamagulia, alö e mar kato uam teka turu ngil peisa i tamulö ba lö te sasala memen.” ");
INSERT INTO hla_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Be Iesu e rangana tara barebana, “E Tamar e halei lia a mamana ka hoboto. Ne moa ta tan ta katun te ga atei sileio lia a Pien Tson tere Sunahan. E Tamar peisa. Ne moa has ta katun te ga atei sil e Tamar. Alia peisa a Pien Tson i tanen te atei silegu e Tamar, nu barebana te haruto ragoi lia e Tamar, nori e tatei atei sil hase roen.” ");
INSERT INTO hla_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Be Iesu e habirits uato turu katunun tsitsilo me poiena i taren pepeisa, “Alimiu go sasala iam! Taraha, a matamilimiu e tarena a ka a mana. ");
INSERT INTO hla_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Alia e ranga mera golimiu, u propet u para nu king u para ri manasa i ngilin tara koru a man ka te tare milimiu, kaba nori i ma tare ien. Nori i ngilin hengo koru a man ka te hengoe milimiu, kaba nori i ma hengoe ien.” ");
INSERT INTO hla_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Turu toa u lan, a toa tson hihatuts turu Lo tere Moses e tuol seito me torohane nei e Iesu u rangatasei teka ba nonei e poiena, “Tson Hihatuts, aha te go kati lia ba lia te luegu a nitoatoa te ka nitoana?” ");
INSERT INTO hla_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Be Iesu e poiena i tanen, “Aha te ranga nena u Buk u Goagono? Alö e mar rit mena mien ime?” ");
INSERT INTO hla_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ba nonei e poiena, “U Buk u Goagono e poiena, ‘Alö go ngil koru a Tsunono i tamulö e Sunahan turu tori hoboto i tamulö na turu namnamei hoboto i tamulö na tara nitagala hoboto i tamulö na turu hakats hoboto i tamulö. Na alö go mar ngil koru meni a tana katun te mar ngil koru mena milö a peisam.’” ");
INSERT INTO hla_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Be Iesu e poiena i tanen, “Alö e ranga palis hona mula. Te mar kato uamou lö teka ba lö te toatoa hamana mou.” ");
INSERT INTO hla_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kaba a tson hihatuts turu Lo e ngil a barebana e gi poei nonei e kato hamatsköna, ba nonei e poiena tere Iesu, “Esi nonei a tana katun te go ngili lia?” ");
INSERT INTO hla_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Be Iesu e ranga palisina me poiena, “A toa katun e la ban i Jerusalem me gala uana tara taun i Jeriko, bu kopkop e songotei pile naren me las louser u hasobu i tanen me atung hohomie ren. Ba nori e Fp fl la ba naren ba nonei e katsin matena. ");
INSERT INTO hla_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ba tara poata teka a toa pris turu Jiu e gala silaia tara maroro teka, ba poata te rutse ien a katun teka ba nonei e sila hapal ba nanen i hapalana maroro. ");
INSERT INTO hla_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na e kato has u i iesana tara toa Livait,* a katun te tagtaguhir u pris. Nonei e mi tuku hasia tara makum teka, ba poata te rutse ien a katun teka ba nonei e sila hapal ba has nanen i hapalana maroro. ");
INSERT INTO hla_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ba toa toun Sameria e lala hasia tara maroro teka. Nu Jiu i roron raman a pal barebana i tanen. Ba nonei e mi tukuto tara katun teka, ba poata te tare ien nonei a katun ba nonei e tatagi koru nanen. ");
INSERT INTO hla_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ba nonei e la uana i tanen me hakis nena u wel nu wain tara man takiraha na man ngats i peisanen, me poue nen. Ba nonei e hosena a katun tara dongki peisa i tanen ba te lu mena neien tara toa luman pasendia me na pakoke nen. ");
INSERT INTO hla_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hamahö ba nonei e lousena a huol a denarius moni (te antunaia tara 10 kina) ba te hale neien a katun terena luman pasendia me poiena, ‘Alö e pakoko hanige mou a katun teka. Na te noue noen ta moni lel i tamulö, ba lia te mi palis poutse goen poata te mi butu pouts gia lia teka.’” ");
INSERT INTO hla_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Be Iesu e poe lelena, “Esi nonei a toa tara elapisa katun teka te ngil koru a tana katun te mar ranga uamu lalö?” ");
INSERT INTO hla_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ba tson hihatuts turu Lo e poiena, “A katun te tatagi neien.” Be Iesu e poiena i tanen, “Ba lö te na kato has uam i iesana.” ");
INSERT INTO hla_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","E Iesu nu katunun tsitsilo i tanen i la u tara maroro ba te butu ria tara toa han, ba toa tahol a solonen e Marta e lu mena neien tara luma i tanen. ");
INSERT INTO hla_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nonei e ka mei a toulanen a solonen e Maria, ne Maria e gumia i rehina mouna e Iesu me hengona turu hihatuts i tanen. ");
INSERT INTO hla_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kaba e Marta e kato sil korui a toukuin kannou te ga kato ien. Ba nonei e la mato me poiena, “Tsunono, alö e ma hakats nami e toular e la ba nena molia ba lia te kato peise iegu a toukui? Alö go ranga memen ba te mi taguhe nolia!” ");
INSERT INTO hla_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ba Tsunono e ranga palise nen. “O Marta, Marta! Alö e toku korum ne hakats nem a mamana ka. ");
INSERT INTO hla_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kaba toa puku a ka te pan balana. E Maria e hopu kapin a ka a niga teka, ne ma tatei lu ba narien romana.” ");
INSERT INTO hla_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","E Iesu e singoia tara toa makum. Poata te hakapa ien, ba toa katunun tsitsilo i tanen e poieto i tanen, “Tsunono, hatuts ramei lam te gi mar singo u, te mar hatuts meri e Jon a Tsonun Baptais u katunun tsitsilo i tanen.” ");
INSERT INTO hla_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Be Iesu e poieto i taren, “Alimiu go mar singo uam teka, ‘O Tamamulam, a solomulö e gi hagoagoni. A Nipepeito i tamulö e ga lama. ");
INSERT INTO hla_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Alö go hala ramei lam a tsi kannou te noana tara man toa man lan hoboto. ");
INSERT INTO hla_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Alö go lu ban a man ka man omi tu kati lam ba te solopale men, taraha alam e roron solopala hasem a man ka man omi turu katun hoboto ti kato homiia i tamulam. Na lö go ma hala merai lam tara tou hiamus.’” Pal singo e kapa. ");
INSERT INTO hla_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Be Iesu e poieto turu katunun tsitsilo i tanen, “Ta toa toum ta katun i tamilimiu e ka mena ta hahikapien, ba te la toum uana i luma i tanen tara gusuna bong ba te hateie nen, ‘O hahikapien, alia e ngilin haroho negu ta topisa ta beret. ");
INSERT INTO hla_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","A tana hahikapien i tar e lala i maroro me butuna i tar, kaba lia u moa ta kannou te go hale ien!’ ");
INSERT INTO hla_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na hahikapien i tamulö toum e tatei soul nama i iahana luma, ‘Ma hakui balei lia! A tamana e pili hakapa lala, na lam mera galapien i tar e opum, na lia e ma tatei takeigi ba te hale gilö ta ka.’ ");
INSERT INTO hla_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nonei e ma tatei takei nei ba te hale nei lö ta beret te hahikapien noa has uamu lö i tanen. Kaba lia e ranga mego lö, nonei e tatei takei hasina ba te hale nei lö a mamana ka te go ngili lö, taraha alö e ma matsingolomi te go rangata nitoa u. ");
INSERT INTO hla_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Na lia e poiegu i tamilimiu, alimiu go rangata sakesake iam ba limiu te lue moen romana. Na limiu go ruto sakesake iam ba limiu te sabie moen romana. Na limiu go ngö sakesake iam ba tamana te kalatse riou romana. ");
INSERT INTO hla_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Taraha, a katun te rangata sakesake nou e lue noen romana, na katun te ruto sakesake nou e sabie noen romana, na katun te ngö sakesake nou, a tamana e kalatse riou romana. ");
INSERT INTO hla_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Esi i tamilimiu te tatei hale nei a pien i tanen a kukutsi te ga singo menien ta iena? ");
INSERT INTO hla_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tsi alö e tatei hale mien a kukoto tara poata te ga rangata nien ta nata? E moa. ");
INSERT INTO hla_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","E manana, alimiu u katun u omi, kaba limiu e atein hala noa has namiu a man ka man niga tara galapien i tamilimiu. Ne Tamarara i Kolö e niga bala nena u katun, ba nonei te hala noa las nenou u Namnamei u Goagono turu katun te rangata sile ren!” ");
INSERT INTO hla_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","E Iesu e tsugei a mate a omi te roron kato habiru a toa katun. Tara poata te lakasaia a mate, ba katun e tanian rangana. Bu katun e asingoto korur. ");
INSERT INTO hla_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kaba palai i taren i poei, “Nonei e antunan tsuga ba rena u mate u omi taraha a tsunono i taren e Bielsibul e hale ien a nitagala te ga tsuga ba merien!” ");
INSERT INTO hla_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ba palai e torohane ren, ba nori te rangate rien te ga kato menien tu toa tu hiharutona i Kolö te ga harutein e Sunahan e hanige ien. ");
INSERT INTO hla_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kaba e Iesu e atei sil u hakhakats i taren me poiena i taren, “Te gi hiatatung poutsia u barebana i iahana toa han pan, ba han teka te ma tatei tagala nei. Na te gi hiatatung poutsia u katun tara toa pinaposa, bu katun teka te ma tatei ka haniga lel hasri. ");
INSERT INTO hla_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na te gi hiatatung poutsia a pala tere Satan, ba nipepeito i tanen te tarura nou romana. Alia e mar ranga uagu teka taraha alimiu e poiemiu e Bielsibul e hale nei lia a nitagala te go tsuga ba meri u mate u omi. ");
INSERT INTO hla_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","U katunun tsitsilo i tamilimiu e tsuga ba has rer u mate u omi turu katun. Ga limiu e poiemiu e Bielsibul e hala rane ien a nitagala teka? E moa. Bu katun pouts i tamilimiu te haruto ner alimiu e ranga hakölomiu te poe mena milimiu e Bielsibul e hale nei lia a nitagala. ");
INSERT INTO hla_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","E moa. E Sunahan te hale nei lia a nitagala te go tsuga meri u mate, na ka teka e hatarare nena a Nipepeito tere Sunahan e la hakapa uama i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Tara poata te hanei mena a katun a tagala a man kan hiatatung i tanen, ba te tara kap haniga nena a luma i tanen, a mamana ka i tanen e nigana. ");
INSERT INTO hla_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kaba te ga butuia ta katun ta tagala bala ba te atunge nen ba te tagala saluhena i tanen, ba nonei te lu ba hakapa nane ien a man kan hiatatung te kahete nien a peisanen. Ba nonei e ase iena a mamana ka hoboto te kopen, ba te molamole nen turu palabir u katun. Kaba lia e ka megu a nitagala te go tagala saluhe meni e Satan. Nonei a ka teka te antunan kato homi sil mera gilia a pala i tanen. ");
INSERT INTO hla_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“A katun te ma hanige nei lia, nonei e omie nolia. Na katun te ma gono bera nei lia u katun e here nei e sata ba rane ien lia.” ");
INSERT INTO hla_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Be Iesu e poe lelena, “Tara poata te lakasa ba nena a mate a omi a katun, ba nonei te hula lana tara makum pinopino i gusuna latu ba te lagi sakesakiena ta makum te ga husa ien. E moa te ga sabie ien ta makumun husa, ba nonei te hakats nena nonei a katun te la ba namen me poiena, ‘Alia e la pouts uagou tara luma tu la ba nema lia.’ ");
INSERT INTO hla_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ba nonei te la poutsuna ba te sabiena a luma te gogoso na te taratara haniga has. ");
INSERT INTO hla_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ba nonei a mate a omi e na peigi renama a elahit a mate a omi ti omi balaia i tanen. Ba nori te la rima ba te mi ka ria i iahana nonei a katun. Na i romana nonei e omi bala koru nena a poata i manasa. Ne kato has uana i iesana, alimiu has e omi bala koru namiu a poata i manasa, taraha alimiu e tori-tsuga namo lia.” ");
INSERT INTO hla_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tara poata te ranga hakapa nia e Iesu a ka teka, ba toa tahol e ranga seita i gusur u barebana me poiena i tanen, “E Sunahan e tatei kalalena a tahol te poseio lö na te hasuseio lö!” ");
INSERT INTO hla_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Be Iesu e ranga palisina, “Ne Sunahan e tatei kalala koru rena u katun te hengoer u ranga i tanen ba te kukutie ren!” ");
INSERT INTO hla_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tara poata ti gono hahiseia a barebana e Iesu, ba nonei e ranga noa hasina me poiena, “Alimiu u barebana tara poata i romana u barebana u omi. Alimiu e roron kato silemiu te go tara menami tu mirakul. Kaba lia e ma tatei haruto ragoi limiu tu toa tu mirakul. Alia e haruto las ragoi limiu a hatoatongo tere Jona a propet i manasa. ");
INSERT INTO hla_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","E Jona e herei a hatoatongo te harutein e Sunahan te ranga u turu katun i Nineva. Na alia tu butun katunuma e here goi a hatoatongo te haruto negu e Sunahan te ranga uana i tamilimiu u barebanar i romana. ");
INSERT INTO hla_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Turu Lanin Hahuna i murimuri, a tetahol panina i Siba e saka mera noi a hei barebana i romana u ranga, ba te haruto nena te ga hahuna meri e Sunahan alimiu. Taraha, nonei a tetahol e la halehana koruma te go mi hengo meni u hihatuts u niga tere Solomon a King. Na lia e hatei rago limiu, a katun te pan bala nena e Solomon e kana teka, kaba limiu e ma hengoe mien!” ");
INSERT INTO hla_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Turu Lanin Hahuna ba pal barebanar i Nineva te saka mera roi a hei barebana i romana u ranga, ba te haruto ner te ga hahuna meri e Sunahan alimiu. Taraha, a tei Nineva i hengo u raranga tere Jona me hapolaser u markato u omi i taren. Na a toa katun te pan bala nena e Jona e kana teka, kaba limiu e ma hapolasa noa hasemi u markato u omi i tamilimiu!” ");
INSERT INTO hla_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","E Iesu e ranga lel me poiena, “E moa ta katun te ga hakulupi u lam ba te hamouse nen tsi ba te kope neien a tabeli. E moa. Nonei e roron hake nen tara makumun gumgum i tanen i iasa, bu katun te tatei rutser u kulupu te tasu uaren. ");
INSERT INTO hla_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ne kato has uana i iesana, a matarara e here nei u lamina turu namnamei i tarara te haharoei nena u ngil i tarara. Te ka mena a katun u ngil u niga, ba nonei te lalana tara maroro te alesalana. Na te ka mena a katun u ngil u omi, ba nonei te lalana tara maroro te kuhilina. ");
INSERT INTO hla_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Na lö go hanei ba te ka mem u ngil u niga. Alö e namos lala mia turu kuhil. ");
INSERT INTO hla_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Te go ka meni lö u ngil u niga peisa ba te moam tu ngil tu omi, ba maroro i tamulö te alesala koru nou.” ");
INSERT INTO hla_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Poata te ranga hakapaia e Iesu, ba toa katun turu Parisi e ngö mena teien i luma i tanen te gi na nou uen. Be Iesu e na gumna tara kannou. ");
INSERT INTO hla_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ba nonei a Parisi e asingoto neto te nou u e Iesu ba te ma galus mame nei a man limanen tara markato turu Jiu. ");
INSERT INTO hla_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ba Tsunono e poieto i tanen, “Alimiu u Parisi e roron kato hagogosemiu a murina kap na pelet, kaba i iahana torimilimiu e korkorianana, ba te habutsena a markato tara kop na te rongaronga mena milimiu u ngilina tun turu tuanrei. ");
INSERT INTO hla_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Alimiu u katun u tutu! E Sunahan te kato u tuanrei ni ielesala nu tuanrei has te ma rutseri, u namnamei. ");
INSERT INTO hla_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Na nonei e ngilena u namnamei nu tori i tamilimiu e ga habuti a markaton tatangana na hitaguhu turu katun ti moa ta ka, ba limiu te toan gogoso hamana mia i matane Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kaba limiu u Parisi, a nomi pan e butuna romana i tamilimiu. A mamana ma tsi kan hasokoka a ma tsi tetenei te kana tara kui, alimiu e roron patsikemiu a ma tsi maloto a ma tsi makum ba te halemi e Sunahan a man hamalotona man makum. Na markato te hala menari a hamalotona makum tere Sunahan e nigana. Kaba limiu e roron totonemiu u mar hihatuts u kapan turu Lo te kato uana: a markato te hamou hamatskö menari u ranga turu katun, na markato te tatagi mera nei e Sunahan u katun. ");
INSERT INTO hla_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Alimiu u Parisi, a nomi pan e butuna romana i tamilimiu. Taraha, alimiu e roron ngilin gum mia turu gumgum u niga tara luman lotu, na limiu e ngil hasemiu u katun e gi hapan ria limiu tara toana. ");
INSERT INTO hla_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","A nomi e butuna romana i tamilimiu, taraha alimiu e heremi u kioun mate te ma tareri u katun. Nori e lala ria i ielunen kaba e ma atei sileri a ka a omi te kana i iogana.” ");
INSERT INTO hla_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ba toa tson hihatuts turu Lo e poieto i tanen, “O Tson Hihatuts, tara poata te ranga nemia lö a ka teka, alö e saka has ramien lam!” ");
INSERT INTO hla_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Be Iesu e ranga palisina, “A nomi pan e butuna romana i tamilimiu has u tson hihatuts turu Lo! Alimiu e roron hake mia a man lo a man tiama turu katun, u lo te ka mer a toukui pan, kaba limiu e ma tatei kukutiemi ta tsi toa ta tsi lo teka. ");
INSERT INTO hla_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","A nomi e butuna romana i tamilimiu, taraha alimiu e roron kuiemiu u kahokaho u niga turu propet ti atung hamatir u tubumilimiu. ");
INSERT INTO hla_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Alimiu e haruto nemiu te hatangana mena milimiu a markato turu tubumilimiu: nori i pulir u propet ba limiu te kuiemiu u kahokaho i taren. ");
INSERT INTO hla_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","E Sunahan te ka mena u hakhakats u niga e poei, ‘Alia e hala regou u propet nu katunun raranga i taren. Ba nori te kato homi rer romana a palai i taren, ba te atung hamate rer a palai.’ ");
INSERT INTO hla_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Ba limiu u katun tara poata i romana te alatemiu romana u propet hoboto ti atung hamate pukur i mam noa, e taniaia tere Abel ti atung hamati, ba te noana tere Sekaria ti atung hamateia i gusuna makumun hats na Luman Lotu Pan. Aa, alia e ranga mera golimiu, alimiu a hei barebana i romana e alata sil ramen romana!” ");
INSERT INTO hla_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Be Iesu e poiena, “A nomi i tamilimiu u tson hihatuts turu Lo. Alimiu e rama namiu a maroro te ga kalats a niatei hamana tere Sunahan. Alimiu e ma lu bemi a peisamiu a niatei teka, na limiu e hapiu tsipon has remiu u katun te ngilin lue ren!” A pala tere Iesu e kapa. ");
INSERT INTO hla_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tara poata te la ba nia e Iesu a makum teka, bu tson hihatuts turu Lo nu Parisi i tanian hona korue ten me rangatse rien u rangrangatana tara mamana ka. ");
INSERT INTO hla_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Taraha, nori i torohanan hagögohe naien. Nori i ngilin saka meien tu ranga tu omi te ga katoen. ");
INSERT INTO hla_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tara poata ti gono hobotoia a man tausen katun ba te para korur, ba palai te tö ier a mour a palai, be Iesu e poe mameto turu katunun tsitsilo i tanen, “Alimiu go hanei haniga sile iam u yis turu Parisi, alia e ranga negu a markato a gamogamo i taren. ");
INSERT INTO hla_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A mamana ka te hamouser i romana e butu noa romana i matar u katun turu ualesala i murimuri. ");
INSERT INTO hla_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ba saha man ka tu ranga niam limiu tu ka pepeisa mia limiu, u katun u para e hengoe ren romana.” ");
INSERT INTO hla_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Be Iesu e poiena, “Alia e ranga mera golimiu u hahikapien i tar, ma matout remi u katun te puli hamatier u tuanrei ba te ma antunan kato homi lel ranei limiu. ");
INSERT INTO hla_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Alia e haruto ragi limiu esi te go matoutse iam limiu: alimiu go matoute iam e Sunahan, taraha nonei e antunan kato hamatiena u tuanrei, na i murinen nonei e ka has mena a nitagala te lapo ba renoa romana u katun i hel! Aa, alia e ranga mera gilimiu, alimiu go matoute iam e Sunahan! ");
INSERT INTO hla_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Alimiu e antunan holemi a solima a tsi apena a 20 toea puku. Kaba e Sunahan e ma solopala noa hase nei ta toa i taren. ");
INSERT INTO hla_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na limiu go ma matout has rami u katun, taraha e Sunahan e tara kap rano limiu, na limiu e niga bala koru namiu u apena i matane Sunahan. Nonei e ase hakapa hasi u hulu hoboto i bakumilimiu.” ");
INSERT INTO hla_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","E Iesu e ranga lel me poiena, “Alia e ranga mera golimiu: esi te hatei ranou u barebana nonei a katun i tar, ba lia tu butun katunuma te hatei has ragou u angelo tere Sunahan nonei a katun i tar. ");
INSERT INTO hla_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kaba esi te holis nena nonei a katun i tar i matar u barebana, ba lia te holis has nagoen romana turu angelo tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“A katun te ranga homi nanou lia tu butun katunuma, e Sunahan e tatei lu ba nanou a markato a omi i tanen. Kaba a katun te ranga homina turu Namnamei u Goagono, e Sunahan e ma tatei lu ba nanoi a markato a omi teka i tanen. ");
INSERT INTO hla_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Na poata te kot raroen limiu ba limiu te tuol mia i iahana u luman lotu na i matar a pal kapan, e moa te go hakats hapara uam limiu ba te poiemiu, ‘Ime te mar ranga halona uagou lia?’ E moa. ");
INSERT INTO hla_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Taraha, u Namnamei u Goagono te hatuts ranei romana limiu a ka te go ranga niam limiu.” ");
INSERT INTO hla_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","A toa katun te kaia i gusur u barebana e poei tere Iesu, “O Tson Hihatuts, alö go ranga mei e toular ba nonei te lu kakatena a man ka te mate ban e tamamulam ba nonei te hale noi lia a hapala.” ");
INSERT INTO hla_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Be Iesu e poiena i tanen, “Aha banei! Esi te hopu kap niu lia go tsimou meni lia alimiu ba te lu kakategu a man ka i tamilimiu?” ");
INSERT INTO hla_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ba nonei e poiena i taren hoboto, “Hanei iam! Hanei sile iam a mar ngil hoboto te ka mena a katun a gulgulka. Taraha, a mamana ka a para te ka mena a katun e ma habutse nei a mouna a nikaka a niga. E moa.” ");
INSERT INTO hla_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Be Iesu e hatei rane ien u toa u haharoei me poiena, “A toa tson moni e ka mei u tsikitsiki te hapusuke ien a kannou a para. ");
INSERT INTO hla_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ba nonei e hakats tununa me poiena, ‘Alia e moa ta makum te go haputia lia a kannou a para i tar.* Aha te katoe gou lia?’ ");
INSERT INTO hla_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ba nonei e poiena, ‘Alia e katoe gou a ka teka. Alia e kato lupe gou u luman haputu i tar ba lia te hatakei hase gou u luma u kapan. Ba lia te hapute goa romana a kannou hoboto i tar turu luma u kapan teka, na man tana man ka hoboto has i tar. ");
INSERT INTO hla_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ba lia te ranga pouts megou romana a peisar ba te poiegu, Pua, alö e ka mem a mamana ka a para te antunan kakapalana tara hiningal a para. Alö go nou haniga tala ba te uam, ba lö te rorom ba te sasalam.’ ");
INSERT INTO hla_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Be Sunahan e poiena i tanen, ‘Alö a katun a tutu. Tara toa bong lahas i romana ba lö te mate mou. Ba esi te lue nou a man ka hoboto teka te hapute mulö?’” ");
INSERT INTO hla_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Be Iesu e poiena, “E kato has uana teka tara katun te gono beie nei a peisanen a mamana ka, kaba i matane Sunahan nonei e moa ta ka ta niga hamana.” ");
INSERT INTO hla_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Be Iesu e poieto turu katunun tsitsilo i tanen, “Nonei lasi te hatei bera gilia alimiu: ma hakats hapara silemi a nitoatoa ni puta ba te poemiu, ‘Aha te noue gou lia?’ Ne moa has te go hakats hapara sil mena milimiu u tuanrei i tamilimiu ba te poemiu, ‘U sahu hasobu te hasoge gou lia?’ E moa. ");
INSERT INTO hla_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Taraha, u katun e ma ka sileri a tou nou peisa. Nu tuanrei tara katun e ma ka sile nei u hasobu peisa. ");
INSERT INTO hla_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ruto uam turu apena te ngö reri u kokou. Nori e ma lebari ne ma hagala haseri a kannou, na nori e ma ka has meri ta makumun hakhaka tara kannou. Kaba e Sunahan te hanou noa las ranen! Na limiu e niga bala ramiu u apena! ");
INSERT INTO hla_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Na toa i tamilimiu te tatei hakats hapanina ba te gamon hangahangahena a nitoatoa i tanen i puta? E moa. ");
INSERT INTO hla_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na te ma antunan kato namia limiu ta tsitabubun ka te ga kato u teka te teteneina tara nitagala tere Sunahan, ga taraha tsiponi ba limiu te hakhakats hapara namiu a palaina man ka man kapan teka? ");
INSERT INTO hla_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ruto iam ime te mar pan uar u palaua u hie. Nori e ma kuiri ne ma katoeri tu labalaba i taren. Na lia e ranga mera golimiu, i manasa e Solomon a King e ka mei u hasobu u taratara haniga koru, kaba a tsi toa puku tara palaua teka e taratara haniga bala nena u hasobu tere Solomon. ");
INSERT INTO hla_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","E Sunahan te hataratara hanige iena u garas u hie teka, te pusukuna i romana na te hats hase ria turu tula i mahö. U mana, e Sunahan e hataratara hanige iena u garas, ba limiu te ma poemi e Sunahan e ma hala ranoi limiu tu hasobu. E moa koru. Alimiu e ka memiu a tsi nihamana a tsi tetenei. ");
INSERT INTO hla_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Na limiu go ma hakats hapara silemi ta ka te go noue iam limiu na te go ue iam limiu. ");
INSERT INTO hla_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","A pal hahamana i puta e roron hakats sil koruer te gi lu meni a mamana ka teka. Ne Tamamilimiu i Kolö e atei silena te ngil mena milimiu a man ka teka. ");
INSERT INTO hla_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kaba alimiu go hakhakats sile iam a Nipepeito tere Sunahan, ba nonei te hala has ranoi limiu a man ka teka.” ");
INSERT INTO hla_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Be Iesu e poiena, “Alimiu a ma tsi katun i tar, ma matoutmi. Taraha, e Tamamilimiu e sasala mena te ga hala meri limiu a Nipepeito i tanen. ");
INSERT INTO hla_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Hahol niam a man ka i tamilimiu ba te hala namiu u moni turu katun ti moa ta ka. A man kan hohongo moni ni puta e roron omi susuluna, na limiu go lue iam a kan hohongo i Kolö te ma tatei omi nei. Alimiu go kui hatagala sile iam u markato u niga be Sunahan te hala ranoi romana limiu a man ka man niga i Kolö, a man ka te ma tatei taia nei, nu katun u kopkop e ma tatei lue rien romana, ne moa ta binatang te ga kato homi ren. ");
INSERT INTO hla_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Taraha, te poe mia limiu a ka a niga hamana e kana i puta, bu ngil i tamilimiu te ka has uana i puta. Na te poe mia limiu a ka a niga hamana e kana i Kolö, bu ngil i tamilimiu e ka has uana i Kolö.” ");
INSERT INTO hla_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Be Iesu e poe lelena, “Hapous hamakmakume iam a labalaba i tamilimiu ba te hakulupemiu a lam ba te ka hahalosemiu a saha toukui te butu nou. ");
INSERT INTO hla_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ba te heremi u katunun kui te hahaloser a katun pan i taren te ga kopis men tara kannouna tara hitöl. Poata te kopis namen ba nonei te ngöna, ba nori te kalata boroboro narien a tamana. ");
INSERT INTO hla_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Te tukuna a katun pan ba te sabiena u katunun kui i tanen te hahalose ren ba te ma sohori, bu katunun kui te sasala korur. Alia e ranga mera golimiu, nonei a katun pan e kato here nanoi romana a peisanen a katunun susoata kannou, ba te hagum ranen ba te hanou ranen. ");
INSERT INTO hla_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Na te ga la memen a gusuna bong koru, tsi tara pal bongbong koru, ba nonei te tarena nori e aloso noar ba te ma sohori, u katunun kui teka e tatei sasala korur. ");
INSERT INTO hla_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Alimiu go hakats niam a ka teka: te ga atei sil mameia a katun terena luma i hangisa koru te ga lama a katun a kopkop, ba nonei te hatongo kap nena a katun teka ba te ma heleie nei a luma i tanen ba te tasuna. ");
INSERT INTO hla_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na limiu has e go hanei iam, taraha alia tu butun katunuma e la guma romana tara poata te ma hakats namia limiu te go la uama lia.” ");
INSERT INTO hla_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Be Pita e poieto, “Tsunono, alö e hatei rami lam pepeisa u haharoei teka, tsi alö e ranga mena mien turu katun hoboto?” ");
INSERT INTO hla_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ba Tsunono e ranga palisina, “Alimiu e heremi a katunun kui hamana te hakats hanigana? Hengo iam. A katun pan i tanen e hataratara kap nanen romana a palair u katunun kui i tanen te ga hala rien a kannou i taren tara poata hamatskö i tanen. ");
INSERT INTO hla_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","A katunun kui teka e tatei sasalana te ga sabe meni a katun pan i tanen te markato uanen teka tara poata te ga la pouts uamen i han. ");
INSERT INTO hla_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","U mana koru, alia e ranga mera golimiu, a katun pan i tanen e tatei hataratara kap nanei a katunun kui i tanen a mamana ka hoboto te teie nen. ");
INSERT INTO hla_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kaba te ga katunun kui homi uen, ba nonei te hakatsna i peisanen ba te poiena, ‘A katun pan i tar e ma hasesein la pouts namei romana.’ Ba te hatanian singata rena a palair u katunun kui, a pal tson na tohaliou, ba te nouna ba te uana ba nonei te tutuna. ");
INSERT INTO hla_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ba katun pan tara katunun kui teka te songots la nama romana tara poata te ma hakats nane ien e ga lama. Ba katun pan te hahune nou a katunun kui a omi teka ba nonei te hake noen tara pal katunun kui te ma tara kap haniga nari a toukui i taren. ");
INSERT INTO hla_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“A katunun kui te atei silena a toukui te ngilena a kapan i tanen, ba te ma hanei sile neien te ga kato meni a ka te ngilena a kapan i tanen, ba nonei te singata hapaner romana. ");
INSERT INTO hla_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kaba a katunun kui te ma atei sile nei a ka te ngilena a kapan i tanen, ba te katoena a ka te antunana tara nihahuna, ba katun pan i tanen te singata hateteneie nen. U katun te hala rari a ka a para, nori te gi palis hapara lele ien.” E Iesu te ranga u teka. ");
INSERT INTO hla_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","E Iesu e ranga lel me poiena, “Alia u la silema tu mi hala meni u tula i puta, na lia e ngil koruegu te ga hatanian kulupu hakapa uen! ");
INSERT INTO hla_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","A tou baptaisina turu kamits e alose nolia, na torir e tiama koru silena te ga butu hakapa uen. ");
INSERT INTO hla_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Alimiu e poemiu alia u la silema te go mi hala meni a masalohana i puta? E moa, alia u ma la memei a niniganiga. Alia e ranga mera golimiu, alia u la silema te go mi peko meri u barebana. ");
INSERT INTO hla_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","E kato uana, tara man poata te la nama, a katun te hahamanana na tou sungutunen te hamane nolia e hiapalpal riou. A elalima katun te ka ria romana tara toa luma e hialulukatar romana ba te katoer a huol a pala. A elapisa te pal rer romana a elasolana, ba elasolana te pal rer a elapisa. ");
INSERT INTO hla_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","U munmun tamana e hiapalpalir romana, a galapien tson nu tamaren. Nu munmun tsinana e kato has uar romana i iesana ba te hiapalpalir, a galapien tohaliou nu tsinaren. Ba halis a tahol i taren te pal nena romana a pien tahol a halis i taren, ba pien tahol a halis i taren te pal nena romana a tahol a halis i taren.” ");
INSERT INTO hla_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Be Iesu e poe hasena tara barebana, “Poata te tare mia limiu u toa u koasi te butu nama tara pala te tsiruku uana a pitala, ba limiu te songots poiemiu, ‘Langits e polo nou,’ ba nonei te kato has uana teka. ");
INSERT INTO hla_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na poata te hasagohe mia limiu a lomolomo te la nama tara pal saut, ba limiu te poiemiu, ‘Ke hiski nou,’ ba nonei te kato has uana teka. ");
INSERT INTO hla_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Alimiu e tatei ruto uamiu turu tsikitsiki na i kolö ba te atei silemiu aha te poie nen. Kaba limiu u katun u gamogamo! Taraha, alimiu e ma atei silemi te mouna uana a man ka te butuna tara poata i tar i romana!” ");
INSERT INTO hla_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Be Iesu e poiena, “Alimiu peisa te go one iam a ka te matsköna. ");
INSERT INTO hla_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tara poata te la gono memia lö a katun te ngilin kot neno lö, na tara poata te ka noa mia limiu i maroro, alö go torohanan hamatskö gono meien. Nonei e namos las mena nei lö tara katun pan turu kot ba katun pan te hala nanoa lö tara polis, ba polis te hakei noa lö tara karabus. ");
INSERT INTO hla_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Alia e ranga mego lö, alö e ma tatei lakasa mumei romana e popona tara poata te go hala nia lö a mamana moni hoboto tara hol turu kot.” ");
INSERT INTO hla_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nonei tara poata, a palair u katun i ka me hateieri e Iesu u katunur i Galili te atung hamatir e Pailat a Gamman tara poata ti hats uen tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Be Iesu e ranga palis raten, “Alimiu e poiemiu nori a tei Galili i omi koru balein a palair a tei Galili hoboto ti mar mate uen teka? E moa. ");
INSERT INTO hla_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Alia e hatei ragi limiu, te ma habirits ba namoi limiu u markato u omi i tamilimiu, alimiu hoboto e mate has mou romana. ");
INSERT INTO hla_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Na limiu e atei nemiu u 18 u katun te kono hamatir a luma a pia i Siloam. Alimiu e poemiu nori ti omi koru balein a palair u katun hoboto ti kaia i Jerusalem? E moa has! ");
INSERT INTO hla_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Na lia e ranga mera golimiu, te ma habirits ba namoi limiu u markato u omi i tamilimiu, alimiu hoboto e mate has mou romana!” ");
INSERT INTO hla_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Be Iesu e ranga mera neien u haharoei teka. “A katun e ka mei u roein fik te pusukuia tara kuin gerep i tanen. Nonei e na sake ta hua me lagi sakesakena. ");
INSERT INTO hla_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ba nonei e poiena tara katunun kui tara kui i tanen, ‘Ruto, turu topisa u hiningal alia u lala uama teka tu mi sake meni ta hua turu roein fik teka, ba lia u ma sabie tei ta hua. Ngats ban! Nonei e namos hakapa pinopinoena a kannou turu tsikitsiki.’ ");
INSERT INTO hla_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ba katunun kui e ranga palisina, ‘Hakei e ga ka, a tsi tsunono, turu toa u hiningal puku teka. Ba lia te kaho hahise gen romana ba te hakeiegu u tei. ");
INSERT INTO hla_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nonei toum e tatei huana romana turu hiningal te la nama. Na te moa nen, bara, ba lö te tatei hangats ba namen.’” ");
INSERT INTO hla_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Turu toa Lan u Goagono e Iesu e hihatutsia tara toa luman lotu turu Jiu. ");
INSERT INTO hla_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","A tahol e kaia teka te ka mei a mate a omi te kato ien me ka mena a nimate turu 18 u hinigal. Nonei e turu nitoa me mamala matskö nei. ");
INSERT INTO hla_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tara poata te tareia e Iesu nonei a tahol, ba nonei e ngöe nen me ranga menen, “A tsi tahol, alia e lu ba negu a nimate i tamulö!” ");
INSERT INTO hla_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ba nonei e hopuena a limanen i tanen ba tahol e topei hamatskö seiena a peisanen me hatsunonena e Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ba tsunono tara luman lotu e tori si nena e Iesu te kato haniga pouts menien a tahol turu Lan u Goagono. Ba nonei e poieto tara barebana, “Ara e ka mera u tönomo u lan te gi kui meira. Alimiu e tatei la muma nonei tara man lan teka ba katun te kato haniga pouts rena u nimate, kaba turu Lan u Goagono e moa!” ");
INSERT INTO hla_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ba Tsunono e mar ranga palis mena teien teka me poiena, “Alimiu u katun u gamogamo! Turu Lan u Goagono alimiu hoboto e roron la uamiu turu luman bulumakau ba te purese ramiu u bulumakau tsi u dongki i tamilimiu, ba te na haua ramun ramen. ");
INSERT INTO hla_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na tahol teka, a toa hatutubunei tere Abraham, te pile kapin e Satan turu 18 u hiningal. Na nonei e tatei tapurese ba has nena a tou kits i tanen turu Lan u Goagono.” ");
INSERT INTO hla_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","U ranga palis i tanen i halan matsingolo pouts nema u pakö hoboto i tanen. Bu katun hoboto i sasala meto a mamana ka a niga te katoen. ");
INSERT INTO hla_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Be Iesu e poiena, “Ime te mar kato uana a Nipepeito tere Sunahan? Aha te tatei haharoei nanen? ");
INSERT INTO hla_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nonei e here nei a ngalin mastet te luena a katun ba te lebe nen tara kui i tanen. Bu kan leba te panina ba te butun roeina, bu apena te katoer a man suhana i taren tara man kala. Na Nipepeito tere Sunahan e hatania hatetenei hasina ba te pan susuluna.” ");
INSERT INTO hla_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Be Iesu e rangata lelina, “Ta ha te go haharoei gono mei lia a Nipepeito tere Sunahan? ");
INSERT INTO hla_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nonei e here nei a yis. A tahol e luena a yis ba te sohala gono mene ien a toa taram palaua, bi murimuri ba taram palaua hoboto teka te la seina.” ");
INSERT INTO hla_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Be Iesu e la sila uana turu taun nu han, me hihatutsina turu barebana me la uana i Jerusalem. ");
INSERT INTO hla_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Te la noa ien i maroro ba toa katun e rangatse ten, “O Tsunono, e ma para noi u katun te lu pouts ranou romana e Sunahan?” ");
INSERT INTO hla_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Be Iesu e ranga palise nen me poiena turu katun ti ka gone meien, “Alimiu go torohana hatagala iam ba te sila mia tara tamana a tetenei, ba te tasu mia tara Nipepeito tere Sunahan. Taraha, alia e ranga mera golimiu, a katun a para e torohanan tasur romana kaba e ma antunari romana. ");
INSERT INTO hla_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ba katun terena luma te takeina romana ba te piliena a tamana. Ba limiu te na tuol mia romana i ielesala ba te tanian kumiu ba te poiemiu, ‘Kalata beri lam a tamana, O Tsunono!’ Kaba nonei e ranga palis rena romana limiu, ‘Alia e ma atei silegi ime te la muma limiu!’ ");
INSERT INTO hla_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ba limiu te ranga palis lelmiu romana, ‘Alam u nou nu ua gono meio lö. Alö u hihatutsia tara taun i tamulam!’ ");
INSERT INTO hla_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kaba nonei e poe lelena romana, ‘Alia e ma atei silegi ime te la muma limiu. La ba nemo lia, alimiu u katun hoboto tara markato a omi!’ ");
INSERT INTO hla_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Alimiu e taremiu romana e Abraham ne Aisak ne Jekop nu propet hoboto te ka ria romana tara Nipepeito tere Sunahan, kaba limiu e lapo raria romana i ielesala. Ba limiu te tabe homi korumiu romana ba te harmiu. ");
INSERT INTO hla_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","U katun e la rima romana tara pala te butu nama a pitala na pala te tsiruku uana a pitala, na i Not na i Saut, ba te gum ria tara kannou tara Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bu palai te katun papalar i romana te na panir romana nonei tara poata, bu palai te panir i romana te na katun papalar romana!” ");
INSERT INTO hla_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ba nonei has tara poata, bu palair u Parisi i la mato me poier tere Iesu, “Alö go la ban a han teka ba te la uam ta tana ta han, taraha e Herot e ngilin atung hamatie nolö.” ");
INSERT INTO hla_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Be Iesu e ranga palis ranen, “La iam ba te na ranga memiu nonei a katun a hahatongon gamo, ‘Alia e tsuga regu u mate u omi ne kato haniga pouts regu u katun i romana ni mahö, bu hatopisana u lan ba lia te na tuku goa tara han te la uagu lia.’ ");
INSERT INTO hla_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kaba lia go la noa hasia tara maroro i romana ni mahö na i ielisa, ba te na butu goa i Jerusalem. Taraha, e ma niga nei te gi atung hamate meni a propet tara tana han, i Jerusalem noa has. ");
INSERT INTO hla_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“A tei Jerusalem, tei Jerusalem! Alimiu e roron atung hamate ramiu u propet ne titi hatu ramiu u katunun raranga te hala mera mei e Sunahan i tamilimiu. A poata a para tu ngilin gono mera mei lia limiu i tar ba te hatongo kap rago limiu, te mar gono mera nei a keriau u tuna i kopina pakapakanen. Kaba limiu e ramamiu! ");
INSERT INTO hla_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ba han i tamilimiu te kaka pukuna romana. Alia e ranga mera golimiu, alimiu e ma tatei tara lele moi lia popona te poe mia romana limiu, ‘E Sunahan e ga kalala a katun te la menama a nitsunono i tanen.’” ");
INSERT INTO hla_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Turu toa u Lan u Goagono, e Iesu e la me na nouna i luma tara toa katun a kapan turu Parisi. Bu katun e taratara kap ner a saha ka te go kato e Iesu, taraha nori i poei e omina te go katoeia a katun ta toukui turu Lan u Goagono. ");
INSERT INTO hla_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ba toa katun e la uamato tere Iesu, a mounen na limanen i hihapala ti puku hapan. ");
INSERT INTO hla_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Be Iesu e ranga merena u tson hihatuts turu Lo nu Parisi me poiena, “U Lo i tarara e hatangana nena te gi kato haniga pouts meni a katun turu Lan u Goagono, tsi e moa?” ");
INSERT INTO hla_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kaba nori i ma rangani ta ka. Be Iesu e lueto nonei a katun, me kato hanige nen me hala ba nanen. ");
INSERT INTO hla_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ba nonei e poieto i taren, “Sanena ta toa i tamilimiu e ga ka mei ta pien tson tsi ta bulumakau ba te tsirukuna i iogana tara kioun ramun turu Lan u Goagono, alimiu e tatei las sei poutse men turu Lan u Goagono noa has, tsime?” ");
INSERT INTO hla_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kaba nori i ma antunan ranga palise ien turu ranga teka. ");
INSERT INTO hla_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","E Iesu e ruteir a palair u barebana ti la uama tara kannou teka, nori i ngilin gum talasia turu gumgum tara pal kapan. Nori i mar kato u teka ba nonei e hala nena u haharoei teka i taren hoboto a man toa toa. ");
INSERT INTO hla_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Me poiena, “Tara poata te ga ngö meni ta toa ta katun alö tara kannouna tara hitöl, ma gumia tara pal gumgum turu tsunono. E moa. Taraha, e namos omina te gi ngö meni ta katun te ga pan balaia i tamulö. ");
INSERT INTO hla_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Te ga kato uen teka, ba katunun hihanou te ngö hoboto raio limiu te la nama ba te poiena i tamulö, ‘Alö go halei a makum teka a katun pan ili.’ Ba lö te matsingolom ba te na gum mia tara makum turu katun papala koru. ");
INSERT INTO hla_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kaba te ga ngöeia lö ta katun ba lö te lam tara kannou, ba lö te na gum mia tara makum turu katun papala koru. Alö go kato u teka, ba katun te ngöeio lö te la nama ba te ranga meno lö, ‘O hahikapien, alö go mi gumia tara makum turu tsunono.’ Te mar kato uanen teka, ba lö te ka mem a solo pan i matar u katun hoboto te nou gono merio lö. ");
INSERT INTO hla_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Taraha, a katun te hapanena a solonen pouts, a solonen e hala pute ier romana. Na katun te hala pute iena a solonen, nonei e na luena romana a solo pan.” E Iesu e ranga u teka. ");
INSERT INTO hla_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Be Iesu e poiena tara Parisi a katun te ngöe ien tara kannou, “A poata te katoe mia lö a kannou, ba lö te ma tatei ngö rami u hahikapien i tamulö, tsi u toulamulö, tsi a pal katun i tamulö, tsi a pal katunun moni te atei sile mulö, taraha nori e ngö uase rio romana lö tara kannou i taren ba te hamatana poutse rio lö. ");
INSERT INTO hla_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Poata te katoe mia lö a kannou, ngöri u katun ti moa ta ka, nu katun a tuanreiren te omina, nu mou omi nu matakiau. ");
INSERT INTO hla_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ba lö te sasalam romana, taraha nori e ma antunan hamatana poutseri romana lö. E Sunahan te hamatane nou romana lö tara poata te takei pouts ria romana u barebana u niga tara tou mate.” ");
INSERT INTO hla_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","A toa katun te gumia tara kannou e hengo a ka teka me poiena tere Iesu, “A katun te na nouena romana a kannou tara Nipepeito tere Sunahan e ga sasala koru.” ");
INSERT INTO hla_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Be Iesu e poieto i tanen, “A toa katun e kato a kannou pan, ba te ngö rena u katun u para. ");
INSERT INTO hla_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tara poata tara kannou nonei e tahulei a katunun kui i tanen go na tahul rema u barebana, ‘La muma, a poata hamanasa tara kannou!’ ");
INSERT INTO hla_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ba nori hoboto i ramato, ba te tanian katoer u mamanu ranga te poiena nori e ma tatei la uari tara kannou. Ba toa katun e ranga mena a katunun kui, ‘Alia u holi a toa kui, na lia e na ngilin tare gen. Alia e rangate golö, alö go haniga te go ma la uai lia.’ ");
INSERT INTO hla_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ba tai e poiena, ‘Alia u holi a maloto a bulumakau, na lia e na ngilin tohala ragen. Alia e rangate golö, alö go haniga te go ma la uai lia.’ ");
INSERT INTO hla_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ba tai e poiena, ‘Alia e hagou hitölgi, nonei te ma tatei la sila gia lia.’ ");
INSERT INTO hla_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ba katunun kui e la poutsuna me na hateie nei a tsunono i tanen a man ka teka. Ba torina tsunono e si koruna me poiena tara katunun kui i tanen, ‘Hasesei boroboro u turu maroro u kapan na turu maroro u tetenei i iahana taun teka. Ba lö te lu ramuma u katun ti moa ta ka, nu katun a tuanreiren te omina, nu matakiau, nu mou-omi, ba lö te mi piou ramien i luma i tar.’ Ba nonei e na kato uana teka. ");
INSERT INTO hla_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","E ma manasai ba katunun kui e mi poiena tara tsunono i tanen, ‘O tsunono, alia e katoe gula a ka te ranga nemu lalö, kaba kannou e antunana turu palai has e gi lama.’ ");
INSERT INTO hla_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ba tsunono e poieta tara katunun kui, ‘Alö go la u turu maroro pan nu maroro u tetenei i ielesala tara taun, ba lö te las mera mumei u katun tara kannou. Alia e ngilegu a luma i tar e ga saputu. ");
INSERT INTO hla_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Alia e hateie golö, e moa ta toa ta katun ti ngö mam rela te gi mi noua romana tara kannou i tar!’” ");
INSERT INTO hla_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","A katun a para koru i lala gono mei e Iesu. Ba nonei e habiritsito me poiena i taren, “A katun te la uanama i tar e tatei ngil bala korue nolia, nu ngil teka e tatei pan bala nena u ngil i tanen te ngil mera neien e tamanen ne tsinanen na tahol i tanen na galapien i tanen, nu toulanen nu hahinanen na nonei pouts has. Te moa nen, nonei e ma tatei katunun tsitsilo uanei i tar. ");
INSERT INTO hla_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Alimiu go haniga iam te go sagoho menami u kamitsina te kukute mena milimiu alia, te mar kato uana a katun te soatsena a korusena tara tou mate i tanen. Te rama mia limiu, ba limiu te ma tatei katunun tsitsilo uami i tar. ");
INSERT INTO hla_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Te ga hakats nia ta toa i tamilimiu te ga kui meni ta luma ta pia, nonei e gum mam buna ba te hakats nena a lahisa moni te antune iena a luma teka, ba te hakats sabiena te ga antuna u a moni ba te tatei hakapena a toukui. ");
INSERT INTO hla_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Te moanen, nonei e na kuiena a kopina luma, ba te ma antuna toum noi te ga kui hakapa meni a luma. Be resi te tarer a ka teka te gol sile ren romana ba te poier, ‘A katun teka e hatanian hatakei a luma, kaba e ma antunan hakapa nanei a toukui!’ ");
INSERT INTO hla_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Sanena a toa king e ga katsin lakasa gono mei u 10,000 turu soldia i tanen ba te na hiatatung gono mier a tana king te ka mena u 20,000 turu soldia, ba nonei te gum mam buna ba te hakats nena te ga tagala hantuna uen. ");
INSERT INTO hla_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Te ma antuna neien, ba nonei te hala nena u katunun ranga ba te na sabiena nonei a tana king tara poata te lehana noa nen, ba te rangata nena te gi tatei hamasalohana pouts uen. ");
INSERT INTO hla_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ne kato has uana i iesana i tamilimiu a man toa toa. Alö go hakats mamin te tatei mar kato uamu lö te go katunun tsitsilo u lö i tar — alö go rama korun a mamana ka te ka memu lö.” ");
INSERT INTO hla_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Be Iesu e poiena, “U sol e nigana, kaba te ga taiaia a nitagala i tanen, e moa lel ta maroro te gi kato haniga lel meien. ");
INSERT INTO hla_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","U mar sol teka e ma antuna nei te ga taguhu meni u tsikitsiki tsi a kan leba i kui. Ara e tatei kato baba tun las naren. A katun te atein hengona e ga hengo haniga!” ");
INSERT INTO hla_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","U katunun lulu takis u para na barebana ti ngöri u katun u omi i lama me mi hengo ria tere Iesu. ");
INSERT INTO hla_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bu Parisi nu tson hihatuts turu Lo e ranga haraharaha ner e Iesu me poier, “A katun teka e kapiena rena u katun u omi ne nou gono has mera nen!” ");
INSERT INTO hla_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Be Iesu e ranga mera teien u haharoei teka, “Sanena te go ka meia ta toa i tamilimiu a 100 tara sipsip ba toa i taren te taiana, gaha te ga katoen? Nonei e ga la bar u 99 u sipsip tara makum i taren ba te na sakiena a sipsip te taia antunana te ga sabe pouts menien. ");
INSERT INTO hla_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Poata te sabe poutse nen a ka te taia, ba nonei te sasala koruna ba te hopue nen i halahalanen. ");
INSERT INTO hla_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ba te soata pouts mena neien i han. Ba nonei e ngö gugono rena u hahikapien i tanen na barebana te sukusukur me poiena i taren, ‘Sasala gono memo lia, taraha alia u sabe poutsi a sipsip i tar te taia!’” ");
INSERT INTO hla_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Be Iesu e poiena, “Na lia e ranga mera golimiu, e kato has uana i iesana, e Sunahan i Kolö e sasala koru mena romana a toa katun a omi te tori habirits ba nena u markato u omi nu hakats u omi i tanen, be Sunahan te ma hakats hapara nanei u 99 u katun te poier nori e nigar.” ");
INSERT INTO hla_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Be Iesu e poiena, “Sanena ta toa ta tahol e ga ka mei ta maloto ta moni ta silva — a man toa toa te popona tara tolima kina — ba te hatie iena ta toa i taren, aha te ga katoen? Nonei e ga hakulupi u lam, ba te saloena a luma i tanen, ba te ruto haniga koruna tara mamana makum antunana te ga sabe menien. ");
INSERT INTO hla_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Poata te sabie nen, ba nonei te ngö gugono rena u hahikapien i tanen na barebana i sukusuku ba te poiena, ‘Sasala gono memo lia, taraha alia u sabe a moni tu hatiei lia.’” ");
INSERT INTO hla_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Be Iesu e poiena, “Na lia e ranga mera golimiu, e kato has uana i iesana, u angelo tere Sunahan e sasala koru mier a toa katun a omi te tori-habirits ba nena u markato u omi nu hakats u omi i tanen.” ");
INSERT INTO hla_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Be Iesu e poiena, “A toa katun e ka mei a elasolana pien tson i tanen. ");
INSERT INTO hla_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ba pien a hatut e ranga mena e tamanen me poiena, ‘O Tamar, alö go hale mei lia a man ka tu hopu kap mei lö alia ba lia te pile pepeisa nagen.’ Be tamanen e lu kakata talena a man ka i tanen me hala mena nei tara elasolana pien tson i tanen. ");
INSERT INTO hla_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","E ma manasai ba pien a hatut te hahol nena a man ka hoboto i tanen me luena moni ba te his uana tara han i lehana. Ba nonei e na ba pinopino nena a moni i tanen tara man markato a man omi. ");
INSERT INTO hla_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nonei e lapo ba hakapein a moni hoboto i tanen, ba bes pan e butu hobotona tara han te ka ien, ba nonei e sakena i peisanen e moa lel ta ka. ");
INSERT INTO hla_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ba nonei e na kuina tara toa katununa tara han teka. Ba katun teka e hala mena neien tara makum te kaia a heis poum i tanen, ba nonei te na taratara kap rena u poum. ");
INSERT INTO hla_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nonei e bes koru ba te ngilin nou hamasuluna tara hakorö turu poum. Kaba e moa ta katun te ga hale ien ta ka. ");
INSERT INTO hla_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ba poata u hakats i tanen e talesala pouts sil a ka te katoen, ba nonei e poiena, ‘U katunun kui tere tamar e ka mer a kannou a para i taren, na lia e ka gia teka ba te mate koru megu a bes pan! ");
INSERT INTO hla_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Alia e takei gou ba te la uagou tere tamar ba lia te na poiegu romana i tanen, O Tamar, alia u kato homiia i matana e Sunahan na i tamulö. ");
INSERT INTO hla_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Alia e ma antuna talagi te gi ngö menai lia a pien i tamulö. Alö go kato here namei lia a katunun kui i tamulö.’ ");
INSERT INTO hla_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ba nonei e takei talana ba te la uana tere tamanen. “Nonei e ka noaia i pal lehana be tamanen e ruto sabie nen me tatagi koru nanen. Be tamanen e pieta uana i tanen me lukutse nen me hatsomie nen. ");
INSERT INTO hla_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ba pien tson e poiena i tanen, ‘O Tamar, alia u kato homiia i matana e Sunahan na i tamulö. Alia e ma antuna talagi te gi ngö menai lia a pien i tamulö.’ ");
INSERT INTO hla_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Be tamanen e poiena turu katunun kui i tanen, ‘Lue muma u hasobu u niga ba te mi hasoge mien. Hasesei iam! Ba limiu te hasogo hasemiu a ring a goul i kabelenen na sendol i mounen! ");
INSERT INTO hla_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Na soatse muma nonei a tunan bulumakau a bokoko ba te mi kato hamatie men, ba ra te katoera a tsi kannou pan ba te sasalara. ");
INSERT INTO hla_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Taraha, nonei a pien tson i tar e herei a katun te mate, kaba e toatoa poutsuna. Nonei e tia me butu pouts nama.’ Ba nori e tanian nour ba te sasalar. ");
INSERT INTO hla_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Na turu lan teka a pien tson a hamua e ka noaia i kui. Ba nonei e gala uanama i han me la hasukusuku uanama i rehina luma ba nonei e hengoena a barebana ti köma ba te sanir. ");
INSERT INTO hla_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ba nonei e ngöena a toa katunun kui me poiena, ‘Aha nonei teka?’ ");
INSERT INTO hla_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ba katunun kui e poiena i tanen, ‘E toulamulö e la pouts uanama i han be tamamulö e kato hamate hakape lala a tunan bulumakau a bokoko, taraha nonei e lu poutse lala a pien tson i tanen ba nonei te niga noa hasina.’ ");
INSERT INTO hla_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ba pien a hamua e raharaha koruna me raman tasuna i iahana luma. Be tamanen e lakasa nama me ranga hatamina i tanen. ");
INSERT INTO hla_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kaba nonei e ranga palisena e tamanen me poiena, ‘Alia u kui hatagala koruia i tamulö turu mamanu hiningal, na lia u mamala hipusni u ranga i tamulö. Na lö u mamala halei lia ta toa ta tunan meme te go nou gono mei lia a man hikapien i tar. ");
INSERT INTO hla_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kaba a pien tson i tamulö teka e ba pinopino nia a moni i tamulö tara tohaliou u omi te hala pinopino ner a peisaren. Na tara poata te la pouts uana men i han, ba lö te kato hamate bemien a tunan bulumakau a bokoko!’ ");
INSERT INTO hla_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Be tamanen e poiena i tanen, ‘A tsi pien i tar, alö e roron ka gono nitoa memo lia, na tara mamana ka hoboto i tar e maman ka has lö. ");
INSERT INTO hla_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kaba ara gi sasala ba te masa korura. Taraha, nonei e toulamulö e herei a katun te mate, kaba e toatoa poutsuna. Nonei e tia me butu pouts nama.’” ");
INSERT INTO hla_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","E Iesu e poei turu katunun tsitsilo i tanen, “A toa tson moni e ka mei a tson pepeito i tanen, ba tana katun e hateiena a tson moni, ‘A tson pepeito i tamulö e kato baba nena a moni i tamulö.’ ");
INSERT INTO hla_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ba nonei a katun pan e ngöena a tson pepeito me poiena, ‘Aha nonei te hengo negu lia i tamulö? Alö go na kui tu toa tu raranga ba te hateie molia tu mar pepeito kap meni lö a man ka i tar. Alö e ma tatei tson pepeito lelmi i tar.’ ");
INSERT INTO hla_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ba tson pepeito e hakatsna i peisanen ba te poiena, ‘A tsunono i tar e tsuge noa lia tara toukui i tar. Gaha te go kati lia? Alia e ma tagala hantunegi te go kaho meni a holö, na lia e matsingolon singo tun silegu ta moni. ");
INSERT INTO hla_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bara, alia e atei silegu aha te katoe gou romana lia! Na te go kato meni lia a ka teka, bu katun te lu menari romana lia turu luma i taren tara poata te ga tsugeia lia a tsunono i tar tara toukuin taratarakap.’ ");
INSERT INTO hla_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ba tson pepeito e ngö gugono mera nei u katun i tanen ti ka mei a haroho tara tsunono i tanen. Ba nonei e poiena tara katun tutun, ‘A lahisa tu harohen lö tara tsunono i tar?’ ");
INSERT INTO hla_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ba nonei ranga palis uana i tanen, ‘A 100 taram welin nas.’ Ba tson pepeito e poiena, ‘A pepa te ka mena u hiase i tamulö teka. Gum boroboro ba lö te koloto nem u 50.’ ");
INSERT INTO hla_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Na tson pepeito e poei tara tai, ‘A lahisa tu harohen lö?’ Ba nonei e ranga palis uana i tanen, ‘A 100 bek palaua.’ Ba tson pepeito e poiena, ‘A pepa tara hiase i tamulö teka. Alö go kolotein u 80.’ ");
INSERT INTO hla_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ba tsunono tara tson pepeito e hengo neto a ka teka me poiena nonei a tson pepeito a gamogamo e hahatongo koru. Nu katunur tara han i puta teka e hahatongon hamatskö koru ner a man ranga tara hei katun pouts i taren, na tara markato teka nori e karasa rer a pal katun tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Be Iesu e ranga noana me poiena, “Na lia e ranga mera golimiu, alimiu go lue iam a moni i tamilimiu ba te taguhu ramiu u katun ba nori te kapiena rario limiu. Ba poata te taiana romana a moni, ba markato teka te tatei taguhu rano limiu te la uami romana limiu tara han i Kolö te ma tatei taia nei. ");
INSERT INTO hla_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","A katun te roron taratara kap haniga nena a man ka man tetenei e taratara kap haniga has nena romana a man ka man kapan. Na katun te roron kui hagamona tara man ka man tetenei e kui hagamo hasina romana tara man ka man kapan. ");
INSERT INTO hla_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Sanena limiu e go ma taratara kap haniga nemi a man ka ni puta teka, gesi te hala ranei romana limiu a man ka man niga hamana i Kolö te go taratara kap niam limiu? E moa tala. ");
INSERT INTO hla_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na sanena limiu e go ma taratara kap haniga nemi a man ka tara tana katun, gesi te hala ranei romana limiu ta man ka i tamilimiu hamatskö? E moa. ");
INSERT INTO hla_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“E moa ta katunun kui te ga antunan kuiia tara elasolana tsunono i tanen. Te ga kato uen teka, ba nonei te omiena romana a toa ba te ngilena a tai. Tsi, nonei e karous nena romana a toa ba te hengo hanige iena a tai. Alimiu e ma tatei kui hoboto bemi e Sunahan na tara moni.” ");
INSERT INTO hla_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bu Parisi i hengo neto a man ka teka, ba nori i ranga hahakosta tere Iesu, taraha nori i ngil koru a moni. ");
INSERT INTO hla_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Be Iesu e poieto i taren, “Alimiu te kato here nami a peisamilimiu u katun u niga i matar u katun, kaba e Sunahan e atei silena u hakhakats i tamilimiu e omina. Taraha, a ka te panina i matar u katun e here nei a ka pinopino i matane Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“U Lo tere Moses nu kolkoloto turu propet i tagala hantunaia tara poata tere Jon a Tsonun Baptais. Kaba tara poata tere Jon ba te popona i romana, u Bulungana u Niga tara Nipepeito tere Sunahan te rarare laner, bu katun hoboto e tagala sil koruer te gi la u i iogana tara Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Na u kolö nu puta e tatei tia nou romana i murimuri, kaba tsi toa tsi makum a tsi tetenei turu Lo e ma tatei taia koru nei romana. ");
INSERT INTO hla_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“A katun te pekoena a hitöl i tanen te rama mena neien a tahol i tanen ba te tölena a tana tahol e tsikolona. Na tson te tölena a tahol a hitöl mam i tanen te tapeko, a tson teka e tsikolo hasina.” ");
INSERT INTO hla_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Be Iesu e poiena, “A toa tson moni e roron hasein u hasobu te ka mei a hihol pan, na nonei e nounou haniga hasi a kannou a niga turu mamanu lan. ");
INSERT INTO hla_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na toa katun pinopino te moa ta ka a solonen e Lasarus i roron hopueia i rehina tamana tara ololo i matina luma tara tson moni teka. Na peisanen e saputu mei a pi. ");
INSERT INTO hla_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nonei e matesil korui te ga nou hamasul u tara ma tsi nouba ti rusia turu tebol tara tson moni. Bu muki te mi ramram has ria turu pi i tanen. ");
INSERT INTO hla_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ba nonei a katun pinopino teka e mateto, bu angelo e soatse ren ba te na haka gono merien e Abraham. Na tson moni e mate has me kaho ner. ");
INSERT INTO hla_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nonei e sagohi u kamits pan i hel, ba nonei te ruto seina ba te tarena e Abraham i lehana, ne Lasarus e ka hasia i rehinen. ");
INSERT INTO hla_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ba nonei e kuna me poiena, ‘O Abraham, o Tubur, alö go tatagi namo lia! Alö go hale iema e Lasarus ba nonei te kana nena a kopuluna a kabelenen turu ramun ba te mi habout hatsitabubena a miar. Taraha, alia e sagohegu a kamits pan koru turu tula teka!’ ");
INSERT INTO hla_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Be Abraham e poiena, ‘A tsi hatutubunei, alö go hakats pouts hasin a poata tu toatoa noaia lö i puta. Alö u lu nitoan a mamana ka a niga i tamulö i puta, ne Lasarus e lu a mamana ka a omi. Kaba i romana nonei e ka hanigana teka ba lö te sagohem a kamits. ");
INSERT INTO hla_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na tana ka, a toa sia pan soku e ka kap rano ra, na katun te kana tara pala teka te katsin aroho uana i tamulö e ma antuna nei, na katun te kana tara pala i tamulö e ma tatei aroho has uana mei i tamulam.’ ");
INSERT INTO hla_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Ba katunun moni e poiena, ‘E noahasina, o Tubur, kaba alia e ranga hatatagi koru mego lö te go sala meni lö e Lasarus tara luma tere tamar te ka ria a elalima a toular. Ba nonei te na ranga hatagala mera nen e gi hanei sil te gi ma la has uame ien tara hanin kamits teka!’ ");
INSERT INTO hla_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Be Abraham e poiena, ‘Nori e ka mer u buk te kolotsi e Moses nu propet tere Sunahan i manasa. A man toulamulö e tatei hengoer u ranga i taren.’ ");
INSERT INTO hla_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ba tson moni e poiena, ‘O Tubur, e moa te gi kato menien romana a ka teka. Kaba te ga takei poutsia a katun tara tou mate ba te lana i taren, ba nori te toan hakapa korue riou u markato u omi nu hakats u omi i taren.’ ");
INSERT INTO hla_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Be Abraham e poiena i tanen, ‘Te ma hengoe roien u ranga tere Moses na turu propet, ba nori te ma hakapa hase roi u markato u omi nu hakats u omi i taren, noahasina te ga takei poutsia a katun tara tou mate.’” ");
INSERT INTO hla_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","E Iesu e poei turu katunun tsitsilo i tanen, “U hiamus e gono ba te roron las rena u katun ba te kato homir, kaba a nomi pan e butu noa romana tara katun te habute nen! ");
INSERT INTO hla_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Te ga katsin amusia a katun teka a toa pien i gusur a galapien teka te hamana uar i tar ba pien te hapolasa ba nenou a nihamana i tanen, e niga balana te gi kits mam meni u katun a toa hatu pan i totongolona katun teka ba te na harukue rien i gusuna loul! ");
INSERT INTO hla_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Alimiu go tara kap haniga niam a peisamilimiu ba te ma katoemi a markato a omi teka. “Sanena te ga kato homia a hahatoulana i tamulö, alö go ranga hapiu nen. Na te ga habiritse ien a torinen, ba lö te solopalem a ka a omi i tanen ba te tara poutse men. ");
INSERT INTO hla_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Te kato homi nen i tamulö tara tohit a poata turu toa u lan, ba nonei te la uanama i tamulö tara man poata hoboto teka ba te poiena, ‘Alia e habiritsegu a torir,’ ba lö te solopala noa hasem a man ka man omi te katoen ba te tara poutse men.” ");
INSERT INTO hla_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bu Aposol e poier tara Tsunono, “Kato hapanema u nihamana i tamulam.” ");
INSERT INTO hla_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ba Tsunono e ranga poutsuna, “A ngalin mastet e makosi koruna kaba e habutena a kan leba te pan sokuna. Ne kato has uana i iesana, te tetenei hasina a nihamana i tamilimiu, alimiu e antunan kato noa hasemiu a man ka man kapan. Hena, alimiu e tatei poemiu turu roei teka, ‘Alö go pate sei a kopimulö ba lö te lam ba te na butu lel mia turu tasi!’ ba nonei te kukutiena romana u ranga i tamilimiu.” ");
INSERT INTO hla_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","E Iesu e ranga noa me poiena, “Sanena ta toa ta katun i tamilimiu e ga ka mei ta katunun kui ba te kuina tara kui tsi ba te taratara kap nena u sipsip, ba tara poata te ga la uamen i han ga lö go poe has i tanen, ‘Mi nou hamanasa tara kannou’? ");
INSERT INTO hla_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","E moa koru! Alö e tatei poiem i tanen, ‘Alö go nas a kannou i tar, ba te hake iem u labalaban kui ba te susoatsem a kannou tara poata te nou gia lia. I murinen ba lö te noum.’ ");
INSERT INTO hla_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na tsunono e namala poie nei, ‘Nigana,’ te kukute menien u ranga i tanen. E moa. ");
INSERT INTO hla_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ne kato has uana i iesana i tamilimiu. Tara poata te hakape mia limiu a man ka te ranga mei limiu e Sunahan te go katoe iam limiu, alimiu go ma ngilemi e Sunahan e ga hapan rio limiu. Taraha, alimiu u kato talase iam a toukui te hopu kap merien limiu.” ");
INSERT INTO hla_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tara poata te la u e Iesu i Jerusalem, nonei e silaia tara maroro i gusuna provins i Sameria ni Galili. ");
INSERT INTO hla_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Nonei e laia i iahana a toa han ba maloto a katun a toba e sabie ren. Nori i tuolia i lehana me kur, “O Iesu! Tsunono! Alö go tatagi ramo lam!” ");
INSERT INTO hla_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Be Iesu e tara raten me poiena i taren, “La iam ba limiu te na hatara namiu a peisamilimiu turu pris.” Ba nori i tanian lato ba nori e butu haniga poutsur. ");
INSERT INTO hla_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","A toa i taren e tara sabe ti kato haniga menien ba te la pouts nama me ranga hapanina me hatsunonena e Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ba nonei e tuhopu nena i mouna e Iesu me hanigana i tanen. A katun teka a katununa i Sameria. ");
INSERT INTO hla_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Be Iesu e rangana, “Alia e kato haniga pouts regula a maloto a katun. Ime te ka ria a elasie? ");
INSERT INTO hla_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","E moa ta tan ta katun te ga kopisima ba te soloseiena a solone Sunahan, a toa puku lasi a katun teka tara tana han.” ");
INSERT INTO hla_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Be Iesu e poiena i tanen, “Takei, ba te lam. A nihamana i tamulö te kato haniga poutse lalo lö.” ");
INSERT INTO hla_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","A palair u Parisi i rangatei e Iesu ta poata te ga butuma romana a Nipepeito tere Sunahan. Nu ranga pouts i tanen e kato u, “A Nipepeito tere Sunahan e ma tatei mar butu uana mei romana te gi tara menien. ");
INSERT INTO hla_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","E moa ta toa te ga poei romana, ‘Ruto, a Nipepeito tere Sunahan teka!’ tsi, ‘Nonei ili!’ Taraha, a Nipepeito tere Sunahan e kana i gusumilimiu.” ");
INSERT INTO hla_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Be Iesu e poieto turu katunun tsitsilo, “A poata e la nama romana te ngilin tare moa limiu alia tu butun katunuma tara tsitabubun poata te ka pouts goa lia i puta, kaba alimiu e ma tare moi lia tara poata teka. ");
INSERT INTO hla_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kaba u katun e poier romana i tamilimiu, ‘Ruto iam, nonei e kana i pala ili,’ tsi, ‘Ruto iam, nonei te kana teka.’ Kaba limiu e ma tatei kukute ramien. ");
INSERT INTO hla_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Alimiu e ateimiu, poata te kulupuna u koasi, u kanaha e roron alesala uana tara mamana makum i kolö. Ne kato has uana romana i iesana tara poata te butu pouts guma romana lia tu butun katunuma. ");
INSERT INTO hla_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kaba alia e sagoho mame gou romana u kamits u para. Bu katun tara poata i tar i romana te tori hasoala nariou romana lia. ");
INSERT INTO hla_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","A poata te la pouts guma romana lia e mar kato has uana romana te kato u a poata tere Noa i manasa. ");
INSERT INTO hla_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tara man lan i mam turu uolo pan, bu katun e nour me uar me hitölur, me noana turu lan te tasuia e Noa tara tolala i tanen, bu uolo e la nama me atung hamate hoboto rena u katun i ielesala. ");
INSERT INTO hla_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ne mar kato has uana romana te mar kato u a poata tere Lot. U katun i nou me uar, me hiholur me haholur, me lebar me hatakeier u luma. ");
INSERT INTO hla_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kaba turu lan te la ba nia e Lot a taun i Sodom, bu tula u uahiahi e rus here matei a langits i kolö me kato hamate rena u barebana hoboto. ");
INSERT INTO hla_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na e kato has uana romana teka tara poata e Sunahan e habutena romana lia tu butun katunuma. ");
INSERT INTO hla_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Nonei turu lan teka i murimuri, ta katun te ga kaia i iapu e namos hahaloso buna ba te luena a man ka i tanen i iahana luma. E ga topei la! Na katun has te kana tara kui i tanen e ma tatei kopis uanei romana i luma i tanen. ");
INSERT INTO hla_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Hakats niam a ka a omi te butuia tara tahol tere Lot i manasa. ");
INSERT INTO hla_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","A katun te ka mena u hakats pan te go haka haniga meni a nitoatoa i tanen ba te peits nanen i tar, nonei e na hataia tun noa hase nen romana. Kaba a katun te hataia sile nei a nitoatoa i tanen te ngil koru mena neien lia, nonei e sabie nen romana. ");
INSERT INTO hla_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Alia e ranga mera golimiu, a bong turu lan te habutena romana e Sunahan alia, ba elasolana katun e soho gono ria romana tara toa inana. A toa e lu ba ner romana, ba tai te kakana. ");
INSERT INTO hla_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","A elasolana tahol e kono hoboter romana a kannou, ba toa te lu ba ner romana ba tai te kakana.* ");
INSERT INTO hla_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","A elasolana tson e kui ria romana i kui, ba toa te lu ba ner romana ba tai te kakana.*” ");
INSERT INTO hla_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bu katunun tsitsilo e rangatse ren, “O Tsunono, ime te butu noa a ka teka?” Be Iesu e ranga palisina, “U katun e atei siler a makum te kana u tuanrei u mate, taraha nonei a makum te gonogono ria u apena te nounouer a ka a koreme. Ne kato has uana i iesana, a barebana e atei sil hase riou ime te ga butuia romana a ka teka.” ");
INSERT INTO hla_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Be Iesu e hatei ratei u katunun tsitsilo u haharoei teka, te ga hatuts ren te gi singo hiton uen ba te ma sökanari ba te hakapar. ");
INSERT INTO hla_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ba nonei e ranga mera ten, “Tara toa taun, a toa tsonun hamou turu ranga e ka. A katun teka e ma tatei matoutei e Sunahan na nonei e ma tatei hapan hasri u katun. ");
INSERT INTO hla_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na tara taun teka a toa amoba e roron lala u i tanen ba te poiena, ‘A katun te paköe nolia e ngilin homie nolia. Alö go taguhe molia turu kot.’ ");
INSERT INTO hla_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tara poata lehana a katun pan teka e mamala hengoi, kaba i murimuri ba nonei e poiena i tanen pouts, ‘Alia e ma matoutegi e Sunahan, na lia e ma hapan has ragi u katun. ");
INSERT INTO hla_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Kaba tahol a amoba teka e roron ranga haparana ba te hala nena a toukui pan i tar. Bara, alia e taguhe goen turu kot. Taraha, nonei e namos la hiton nama ba peisar te soso koru mena u ranga i tanen.’” ");
INSERT INTO hla_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Be Iesu a Tsunono e ranga noana me poiena, “Alimiu go hengoe iam u ranga te kati a tson hamou a omi teka. ");
INSERT INTO hla_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Te kato uen teka ba limiu te mar hakats uamiu ime tere Sunahan? Ge ma taguhu ranei romana u katun hamatskö i tanen te singo nitoa uar i tanen tara lan na tara bong? E moa. Nonei e taguhu koru ranoen ba te ma aloso nei. ");
INSERT INTO hla_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Alia e ranga mera golimiu, nonei e hamou hanige ienou u ranga i taren ba te kato borobore nen. Kaba poata te la pouts guma romana lia i puta, alia tu butun katunuma, ga lahisa katun te sabie golia ba te hamana korur?” ");
INSERT INTO hla_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","E Iesu e hatei hasin u haharoei teka turu katun ti roron hanigei a peisaren me poier nori te maktskör ba te sigala homi koru rer a palair u katun. ");
INSERT INTO hla_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ba nonei e poiena, “A elasolana katun i sei u tara Luman Lotu Pan me na singor. A toa nonei a katun turu Parisi, na tai a katunun lulu takis. ");
INSERT INTO hla_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","A Parisi e tuol pepeisa me singona, ‘O Sunahan, alia e haniga uagu i tamulö, taraha alia e namala kato hohomigi te kato uar a palair u katun hoboto. Alia e ma kopkopgi, na lia e ma gamogamogi, na lia e ma tsiktsikologi. Na lia e ma kato hohomigi te kato uana a tsonun lulu takis i tium. ");
INSERT INTO hla_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Turu huol u lan i iahana mamanu wik alia e roron agono negu a kannou, na lia e roron lu katsegu u moni i tar tara maloto a makum ba te hala negu a toa makum i tamulö.’ ");
INSERT INTO hla_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kaba katunun lulu takis e tuolma i lehana me ma hala sei mena nei a polenen i Kolö, taraha e matsingolo. Ba nonei e mukmuketo a lumlumanen te tatagi uen me poiena, ‘O Sunahan, alia a katun a omi koru, kaba lö go tatagi namo lia.’” ");
INSERT INTO hla_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Be Iesu e poiena, “Alia e ranga mera golimiu, a katun hahuol teka te maksköna i matane Sunahan tara poata te la pouts uanen i han, na katun mam e moa. Ba katun te solosei peise iena a peisanen, a solonen e na la putana romana. Kaba katun te solo pute iena a peisanen, nonei e na luena romana a solo pan.” ");
INSERT INTO hla_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","U katun e mi piou ria a ma tsi goama tere Iesu te go sebele merien e Iesu. Bu katunun tsitsilo e tarer a ka teka me ranga hapiu raren. ");
INSERT INTO hla_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kaba e Iesu e ngö meri a galapien i tanen me poiena turu katunun tsitsilo, “Haka riam a galapien e gi la uama i tar. E moa te go hapiu mera mien limiu. Taraha, a Nipepeito tere Sunahan e ka gono merana romana u mar katun te kato uar teka. ");
INSERT INTO hla_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Alia e hatei hamana rago limiu, a katun te ma hengo hanige nei u ranga tere Sunahan te mar hengo haniga uana a pien, a katun teka e ma tatei tasu koru nei tara Nipepeito tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ba toa katun a kapan turu Jiu e rangatena e Iesu, “O Tson Hihatuts a niga, aha te go kati lia ba te luegu a nitoatoa te ka nitoana?” ");
INSERT INTO hla_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Be Iesu e ranga palisito i tanen, “Taraha ba lö te ngöe milia a katun a niga? E moa ta katun te ga niga. E Sunahan talasi. ");
INSERT INTO hla_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Alö e atei silem a man masaka tere Sunahan. Hena teka: ‘Alö go ma tsikoloi. Alö go ma hipulii. Alö go ma kopui. Alö go ma gamogamoi. Alö go hapan e tamamulö ne tsinamulö.’” ");
INSERT INTO hla_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ba katun e rangato, “E popona tu hitotsia lia ba te noana i romana, alia u hengo korui a man lo teka.” ");
INSERT INTO hla_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Poata te hengoeia e Iesu a ka teka, ba nonei e poieto i tanen, “A toa patu a ka te go kato lö. Alö go haholin a man ka hoboto i tamulö ba te molamola remi u katun ti moa ta moni. Ba lö te ka mem romana a mamana ka a niga i Kolö. Ba lö te tatei la muma ba te kukutie mumo lia.” ");
INSERT INTO hla_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kaba poata te hengo nia a katun a ka teka ba nonei e mataloho koruna, taraha nonei e ka mei a moni a para koru. ");
INSERT INTO hla_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","E Iesu e tari te tatagi uen me poiena, “U katununa tara moni e ka mer romana a toukui pan te gi tahongo uen tara Nipepeito tere Sunahan! ");
INSERT INTO hla_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","E tutu koruna te ga la u a katunun moni tara Nipepeito tere Sunahan, te mar tutu has uana a kamel te katsin sipina tara tsi tabutu tara salum.” ");
INSERT INTO hla_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bu katun ti hengoen e rangatar, “Gesi tsiponi te antunan ka hanigana?” ");
INSERT INTO hla_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Be Iesu e ranga palisina, “A ka teka e ma antunan kato nanei a katun tun, kaba e Sunahan e antunan kato nanen.” ");
INSERT INTO hla_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Be Pita e poiena, “Ruto! Alam u la ba nema a han i tamulam me kukutie mumo lö.” ");
INSERT INTO hla_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Be Iesu e poieto i taren, “Alia e ranga hamana mera gilimiu a ka teka, a katun te hakats uana tara Nipepeito tere Sunahan ba te la ba nena romana a luma i tanen tsi a tahol i tanen tsi u hatoulana tsi e tamanen tsi e tsinanen tsi a galapien i tanen, nonei e luena romana a para koru lel tara man ka teka tara poata i romana, ba te lu hase nou a nitoatoa te ka nitoana tara poata te la nama.” ");
INSERT INTO hla_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Be Iesu e lu halhal rena a 12 a katunun tsitsilo i tanen me poiena, “Hengo iam! Ara e la uara i Jerusalem, na mamana ka ti kolotein u propet te ga butuia i tar e butu hamana noa nonei tara han. ");
INSERT INTO hla_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Taraha, alia e hala naria romana turu katun te ma Jiuri, ba nori te hahakos ria romana i tar ba te kato hohomi ria i tar ba te kahus has nario lia. ");
INSERT INTO hla_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nori e lahuse rio romana lia ba te atung hamate rio lia. Kaba turu hatopisana u lan ba lia te takei poutsugu romana.” ");
INSERT INTO hla_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kaba u katunun tsitsilo i ma atei silei a man ka teka. A mouna u ranga teka i hamous ba rien, ba nori e ma atei sileri a ka te rangein e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Be Iesu e la hasusuku uama tara taun i Jeriko, na toa katun a matakiau e gumia i rehina maroro ba te singo lanena ta moni. ");
INSERT INTO hla_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Poata te hengoe ien ti la karasa u u katun u para me rangatana, “Aha teka?” ");
INSERT INTO hla_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ba barebana e ranga uar i tanen, “E Iesu ni Nasaret te la karasana.” ");
INSERT INTO hla_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ba nonei e kuto, “Iesu! A Hatutubunei tere Devit! Alö go tatagi namo lia!” ");
INSERT INTO hla_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bu katun ti mam i raharahe ten me poier, “Alö go kokomoto!” Kaba nonei e ku hapan koru lel, “Hatutubunei tere Devit! Alö go tatagi namo lia!” ");
INSERT INTO hla_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Be Iesu e tuoluto me ranga nena a katun a matakiau e gi na piou nia i tanen. Poata te la hasusuku men, be Iesu e rangatse ten, “Aha te ngile mulö te go kati lia i tamulö?” Ba nonei e ranga palisina, “O Tsunono, alia e ngilin taragu.” ");
INSERT INTO hla_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Be Iesu e poieto i tanen, “Bara, alö go tara pouts! U nihamana i tamulö te kato haniga poutse nolö.” ");
INSERT INTO hla_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ba i teka puku nonei e tara poutsuna, me kukutiena e Iesu me haniga uana tere Sunahan. Ba poata ti tareia u katun a ka teka, ba nori e hapaner e Sunahan. ");
INSERT INTO hla_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","E Iesu e laia i iahana taun i Jeriko me ngilin la sokuna i hapala. ");
INSERT INTO hla_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na toa katun a solonen e Sakias e ka. Nonei a toa katunun lulu takis a kapan, na e ka hasi mei a moni a para. ");
INSERT INTO hla_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nonei e ngilin tari e Iesu, kaba nonei e makmakum koru me ma antunan tare nei e Iesu, taraha a katun e gono. ");
INSERT INTO hla_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ba nonei e pieta mamuna turu katun me na seina turu roein fik u kapan te ga tara menien e Iesu. Nonei e atei sil a makum teka te ga silaia e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Poata te laia e Iesu tara makum teka ba nonei e tara seina me poiena tere Sakias, “O Sakias, koul boroboro, taraha alia e na ka goa tara luma i tamulö i romana.” ");
INSERT INTO hla_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Be Sakias e koul boroborona me na las hagumena e Iesu i luma i tanen me sasala koruna. ");
INSERT INTO hla_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bu katun ti tari a ka teka e tanian ranga haraharaha hobotor, “A katun teka e na kana tara luma tara katun a omi!” ");
INSERT INTO hla_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Be Sakias e tuoluto me poiena tara Tsunono, “Hengo, o Tsunono! Alia e lu katse gou a man ka i tar tara huol a makum ba te hala ragoi u katun pinopino a toa makum. Na tu gamoeia lia ta toa ta katun ba te kopegu ta ka i tanen, alia e palis poutse goen popona tara tohats a poata.” ");
INSERT INTO hla_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Be Iesu e poieto i tanen, “I romana e Sunahan e lu pouts hakapa relala u katun tara luma teka. Alö a toa Jiu tu taia. ");
INSERT INTO hla_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na lia tu butun katunuma u la silema e go mi sake ne go mi lu poutsir u katun ti taia.” ");
INSERT INTO hla_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bu barebana i hengo noa uato tere Iesu. Be Iesu e ranga nena u haharoei teka, taraha nonei e susuku hakapaia i Jerusalem, na nori i hakats me poier a Nipepeito tere Sunahan e katsin butu hamanasa. ");
INSERT INTO hla_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ba nonei e poiena, “A toa katun pan e katsin la u tara han i lehana te gi na haking menien ba te la pouts nama i han. ");
INSERT INTO hla_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","I mam te katsin la ien, ba nonei e ngö gugono rena a maloto a katunun kui i tanen me hala rane ien a maloto a maina moni. A toa maina e antunaia tara hihol tara topisa tsihau. Ba nonei e ranga mera nen, ‘Alimiu e kui memiu a moni teka e popona te la pouts guma lia.’ ");
INSERT INTO hla_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kaba u katun tara toa han i tanen i tori homi koru nen, ba nori e hakukutie lila u katunun raranga i murinen te gi na poe meni, ‘Alam e rama nem a katun teka e ga king raio lam.’ Kaba nonei e na king noa has. ");
INSERT INTO hla_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ba katun pan teka ti na hakingema e kopis nama. Poata te tuku ien ba nonei e hangö gugono rena u katunun kui i tanen te hala rien a moni te gi butu hoboto uen i matanen ba te sakiena a lahisa moni ti luen. ");
INSERT INTO hla_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ba katunun kui tutun e la mato me poiena, ‘O tsunono, alö u halei lia a toa maina moni i tamulö, na lia u lu leli a tana maloto a maina moni tara moni tu halei lö alia.’ ");
INSERT INTO hla_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ba katun pan e poieto i tanen, ‘Alö u kato haniga. Alö a katunun kui a niga! Alö u tara kap haniga korur a man ka man tetenei. Kato uana teka ba lia e hale goi lö a nitsunono ba lö te tara kap nem a maloto a taun.’ ");
INSERT INTO hla_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ba helasolanana katunun kui e la nama me poiena, ‘Tsunono, alia u lu leli a tana tolima maina moni tara moni tu hala nilö.’ ");
INSERT INTO hla_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ba katun pan e poieto i tanen, ‘Alö e tsunono nem romana a tolima taun.’ ");
INSERT INTO hla_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ba tana katunun kui e la mato me poiena, ‘Tsunono, a maina moni i tamulö teka. U haka hamouseia lia tara makumun labalaba. ");
INSERT INTO hla_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Alia u matouteio lö, taraha alö a katunun hakhakui hatagala. Alö e ma kuimi, kaba lö e roron lu noa hasem a hihol tara toukui tara tana katun.’ ");
INSERT INTO hla_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ba katun pan e poieto i tanen, ‘Alö a katunun kui a omi! Alia e kot megoi lö a man ranga pouts i tamulö! Alö e atei silem alia a katunun hakhakui hatagala, na lia e ma kuigi kaba lia e roron lu noa hasegu a hihol tara toukui tara tana katun. ");
INSERT INTO hla_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aa, gaha tu ma haka nilö a moni i tar tara luman moni, ba lia te tatei lu pouts gono megien ta tana ta moni tara poata te go kopis malia?’ ");
INSERT INTO hla_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ba katun pan e poiena tara pala ti tuol hasukusuku, ‘Lu ba nami a maina moni a katun teka ba te halemi a katunun kui te ka mena a maloto a maina moni.’ ");
INSERT INTO hla_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ba nori e poier i tanen, ‘Tsunono, nonei e ka hakapa mena a maloto a maina moni!’ ");
INSERT INTO hla_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ba nonei e ranga palisina, ‘Alia e ranga mera golimiu, a katun te ka mena a huhua tara toukui i tanen e hala hase roi a maroro te ga kui meni a huhua lel. Kaba katun te moa ta huhua tara toukui i tanen e lu ba naroi a ma tsi ka pinopino noa has te ka menen. ");
INSERT INTO hla_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na nori u pakö i tar te rama ner te go king merien lia, lu mera mumei teka ba te atung hamate ramien i matar!’” U haharoei tere Iesu e kapana teka. ");
INSERT INTO hla_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","E Iesu e ranga u teka ba te gamon mam rena u katun i tanen ba nonei e kete uana i Jerusalem. ");
INSERT INTO hla_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nonei e la hasukusukuia tara ma tsi han i Betpasi na i Betani ti kaia i rehina u Pokus tara Roein Olip, ba nonei e katsin hamam rena a elasolana katunun tsitsilo. ");
INSERT INTO hla_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ba nonei e poiena i taren, “Alimiu go la mula tara tsi han te ka nama ili, ba poata te na tuku moa limiu i han ba limiu te na sabie mou a toa tunan dongki te kitse lilei a lohiana na te mamala osa noeri u katun. Ba limiu te puresie mumen ba te la mena mume ien teka. ");
INSERT INTO hla_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Te rangata noa ta katun, ‘Aha te purese sile mien limiu?’ ba limiu te poemiu i tanen, ‘A Tsunono e ngile namen.’” ");
INSERT INTO hla_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ba elasolana katun e lar me na sabier a man ka te mar ka u te ranga uala e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Na tara poata ti purese ien a dongki bu katun tere ra dongki e poier i taren, “Aha te purese sile milimiu a tunan dongki?” ");
INSERT INTO hla_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ba nori e poier, “A Tsunono e ngile namen.” ");
INSERT INTO hla_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ba nori e mi piou naria a tunan dongki tere Iesu me haholase rime ien a man hasobu a man ngahangaha i taren ba nori e hose ier e Iesu i tanen. ");
INSERT INTO hla_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nonei e gumia i ieluna a dongki ba te lana, ba barebana e haholase ier a man hasobu a man ngahangaha i taren i kalana. ");
INSERT INTO hla_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ba poata te tuku ien tara pal kalana te la puta u turu Pokus tara Roein Olip te kaia i rehina i Jerusalem, bu katun u para koru i tanen e tanian köma hapan ria tere Sunahan ba te solosei merien u man mirakul pan u para ti tare ien. ");
INSERT INTO hla_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ba nori e poier: “E Sunahan e ga kalala a king te la menama a nitsunono i tanen: A masalohana e ga kaia i Kolö, na solona e Sunahan e ga pan koru!” ");
INSERT INTO hla_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ba palair u Parisi i gusur u barebana i poieto tere Iesu, “O Tson Hihatuts, alö go hakokomoteir u katunun tsitsilo i tamulö.” ");
INSERT INTO hla_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Be Iesu e ranga palisito me poiena, “Alia e hatei ragi limiu, te kokomoto roa a barebana teka bu hatu tun te ku riou.” ");
INSERT INTO hla_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","E Iesu e la hasukusuku u tara taun i Jerusalem, ba poata te rutse ien a taun ba nonei e tabe sile nen. ");
INSERT INTO hla_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ba nonei e poiena tara taun teka, “Sanena alimiu tu atei sile iam a ka te habutsena a masalohana, i romana noa has, alia sane sasalagu. Kaba a ka teka e mous ba tala rano limiu ba limiu te ma antunan rutse mien. ");
INSERT INTO hla_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","A poata te la nama, bu katun te pakö rario limiu te mi gono hahis beri romana a ololo tara taun i tamilimiu a ma tsi pokusun hiatatung ba nori te mi hatukap rariou romana limiu. ");
INSERT INTO hla_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ba nori te hela haruse riou romana a han i tamilimiu ba te kato hohomi has rariou romana limiu na galapien has i tamilimiu te ka ria i iahana taun. Na e moa ta tan ta hatu tara ololo te go kaia romana i ieluna tabi. Taraha, alimiu u ma atei silemi a poata te torohanan taguhu ria limiu e Sunahan!” ");
INSERT INTO hla_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Be Iesu e tasuto i iahana Luman Lotu Pan me tanian tsuga rena u katunun hahol, me poiena i taren, “U ranga tere Sunahan ti koloto nia turu Buk u Goagono e mar ranga uana teka, ‘A luma i tar e ngöeri romana a luman singo.’ Kaba limiu e kato here tsipon namien a kioun mous turu kopkop!” ");
INSERT INTO hla_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","E Iesu e hihatutsia i Luman Lotu Pan turu mamanu lan. Bu pris pan nu tson hihatuts turu Lo nu pal kapan turu Jiu e ngilin atung hamate naren. ");
INSERT INTO hla_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kaba nori i ma sabiei ta maroro te gi mar kato menien, taraha u katun hoboto i roron hengo nitoaia turu ranga i tanen. ");
INSERT INTO hla_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","2","Turu toa u lan, tara poata te kaia e Iesu i Luman Lotu Pan ba te hatuts rena u katun ba te hatei nena u Bulungana u Niga, bu pris pan nu tson hihatuts turu Lo nu tsunono e la rima me poier i tanen, “Hatei ramo lam, alö e ka mem a saha nitsunono ba lö te katoem a man ka teka? Esi te halei lö a nitsunono?” ");
INSERT INTO hla_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Be Iesu e ranga palis raten, “Alia e rangata has ragi limiu u toa u harangata. Hateie mumo lia, ime te lueia e Jon a nitsunono te ga baptais merien u katun? Tere Sunahan, tsi tara katun tun?” ");
INSERT INTO hla_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ba nori e hiarangrangata poutsur me poier, “Aha te gi poei ra? Te gi poe meni ra, ‘E Jon e ka mei a nitsunono tere Sunahan,’ be Iesu te poe nou i tarara, ‘Ga taraha tsiponi tu ma hamana memi limiu e Jon?’ ");
INSERT INTO hla_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na ra e namos poe hasera, ‘E Jon e ka mei a nitsunono tara katun.’ Te gi kato u ra teka, bu katun hoboto te titi hatu rariou ra, taraha nori e hamana koruer e Jon a toa propet tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ba nori e ranga paliser e Iesu, “Alam e ma atei silemi ime te lama a nitsunono tere Jon.” ");
INSERT INTO hla_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Be Iesu e poieto i taren, “Na lia has e ma tatei hatei ragi limiu esi te hale moi lia a nitsunono ba lia te katoegu a man toukui teka.” ");
INSERT INTO hla_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Be Iesu e ranga mera nei u katun u haharoei teka, “A toa katun e lebei a kuin gerep, ba nonei e hataratara kap tun rena u palair u katun a kuin gerep teka me hakuin moni nanen, ba hapalana moni e la uato tara katun terena kui. Ba nonei e la uato tara toa han i lehana me na ke iena a poata a ngahangaha koru. ");
INSERT INTO hla_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bi murimuri ba poatan tangoho tara kui e butu hakapato, ba nonei e hala mena nei a toa katunun kui i tanen tara barebana ti kuiia tara kuin gerep. Nonei e ngilin lu a pal hua i tanen. Kaba barebanan kui tara kui teka i atunge ien me tsuge ren ba nonei e lala puku poutsuna. ");
INSERT INTO hla_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ba nonei a katun terena kui e hale iena a taina katunun kui i tanen, bu katunun taratarakap tara kui e atung lel hase ren, me kato hamatsingole ren, ba nori e hala pukpuku poutse ren. ");
INSERT INTO hla_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ba nonei e hala lel nena a helapisana katunun kui, bu katunun taratarakap e kato hakamits hase ren, ba nori e tsuga ba naren. ");
INSERT INTO hla_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ba katun terena kuin gerep e poieto, ‘Aha te go kati lia? Alia e hala negou a pien tson a tsomi i tar. Nori toum e tatei hapane roen.’ ");
INSERT INTO hla_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ba poata ti tare ien u katunun taratarakap ba nori e hiararangar me poier, ‘A pien tara katun terena kui teka te lue nou romana a kuin gerep. Ara gi atung hamatien, ba kuin gerep i tanen te ka uanou i tarara!’ ");
INSERT INTO hla_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ba nori i lapo ba naten tara kui me atung hamatie ren.” Be Iesu e rangatato, “Ga katun terena kuin gerep e ga kato aha turu katun u omi teka? ");
INSERT INTO hla_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nonei e la nama romana ba te mi atung hamate rena u katun teka, ba nonei te hala mena nei romana a kuin gerep teka turu katunun taratarakap u niga.” Ba poata ti hengo nia u katun a ka teka ba nori e poier, “U katun e gi ma tatei kato homi uai teka!” ");
INSERT INTO hla_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Be Iesu e ruto uana i taren me poiena, “Ga limiu go hakats niam u ranga turu Buk u Goagono te kato here nanei lia a hatu. E kato uana, ‘A hatu ti raman u katunun hatakei tara luma ba te hapiraka ba ner, nonei a hatu te niga balana tara toukuina tara luma.’ ");
INSERT INTO hla_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","U katun hoboto te tsia roa tara hatu teka e taptapeko riou romana. Kaba te konena romana a hatu teka ta katun, ba nonei te kono bulbul here nanoien u koahu.” ");
INSERT INTO hla_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bu tson hihatuts turu Lo nu pris pan e ngilin pile kap hamanasa ner e Iesu, taraha nori i atei sil e Iesu e saka merien u haharoei teka, kaba nori i matoutir u katun. ");
INSERT INTO hla_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ba nori i tara kap naten. Ba nori e hol rer u katun u gamogamo me hala rari men te gi mi tara kakap menien. U katun teka i gamo ba te katoer u rangrangata u para tere Iesu. Nori i ngil e Iesu e ga kato tu ranga tu omi te gi kot meien na te gi hala menien tara nitagala tere Gamman. ");
INSERT INTO hla_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ba nori i rangatse ten me poier, “Tson Hihatuts, alam e atei silem alö a katun a mana. Alö e roron hihatuts hamana nem a maroro tere Sunahan, taraha alö e mamala hakats silemi a nikapan turu katun. ");
INSERT INTO hla_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Alö go ranga mera molam, e niga hasina turu Lo i tarara te gi takis u ra tere Gamman Pan e Sisa, tsi e moa?” ");
INSERT INTO hla_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Kaba e Iesu e atei sil u gamo i taren me poiena, “Hatare mumei lia ta toa ta moni ta silva. A bakune si na solone si te kana i tanen?” Ba nori e ranga palisir, “E Sisa.” ");
INSERT INTO hla_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Be Iesu e poieto, “Bara, halemi e Sisa a man ka i tanen, ba te hala hasemi e Sunahan a man ka i tanen.” ");
INSERT INTO hla_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nori i ma antunan kot mei e Iesu tu toa tu ranga tu omi teka i matar u katun, ba nori e hahalongolor me asingoto ner te ranga palis haniga uen. ");
INSERT INTO hla_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bu palair u Sadiusi i la uamato tere Iesu. Nori a pal katun ti poei e moa ta tou taktakei pouts tara tou mate. ");
INSERT INTO hla_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ba nori i poieto tere Iesu, “Tson Hihatuts, e Moses e koloto meni a lo teka i manasa: ‘Te ga mate ba meni a tson a tahol i tanen ba te moana ta pien, e toulanen e tatei tölena a amoba ba nori te hatuhaner ta pien te ngö rari romana a solona tson te mate.’ ");
INSERT INTO hla_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bara. Tara toa poata a elahit u mun toulana i ka. Ba hamua e hitöluna, me matena ba te moana ta pien. ");
INSERT INTO hla_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ba hatut e töleto a tahol a amoba me na mate hasina ba te moana ta pien. ");
INSERT INTO hla_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Te kato has uen i iesana tara helapisa na turu munmun toulana hoboto teka. Nori i mate hoboto ba te moar ta pien. ");
INSERT INTO hla_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ba i murimuri ba tahol te mate hasina. ");
INSERT INTO hla_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ga tara poata te takei pouts ria romana u katun tara tou mate i taren ba te luer a tuanreiren, ga tahol teka e tahol uana romana teresi? Taraha, a elahit hoboto ti töle ien.” ");
INSERT INTO hla_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Be Iesu e ranga palis ranen, “A pal tson na tohaliou e hitölur tara poata i tarara i romana. ");
INSERT INTO hla_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kaba pal tson na tohaliou te rangeir e Sunahan te tatei takei poutsur romana ba te ka mer u tuanrei tara poata i murimuri, nori e ma tatei hitölri. ");
INSERT INTO hla_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nori e hereri romana u angelo ne ma tatei mate lelri. Nori a galapien tere Sunahan, taraha nori e hatakei raria romana tara tou mate. ");
INSERT INTO hla_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ne Moses e haruto haniga korun te takei pouts uar u katun ti mate ba te toatoar. Turu ranga turu Buk u Goagono te hatei nena a tsi roei te kulupu, e Moses e rangein a Tsunono me ngö neien, ‘A Sunahan tere Abraham, na Sunahan tere Aisak, na Sunahan tere Jekop.’ ");
INSERT INTO hla_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A ka teka e ranga nena nonei a Sunahan turu katun te toatoar. E ma Sunahan uanei turu katun u mate. Taraha, i matane Sunahan, u katun hoboto e toatoa noar.” ");
INSERT INTO hla_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bu palair u tson hihatuts turu Lo e ranga palisir me poier, “U raranga palis u niga, o Tson Hihatuts!” ");
INSERT INTO hla_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nori i ranga u teka, taraha nori i raman rangata leli e Iesu tu rangrangata. ");
INSERT INTO hla_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Be Iesu e poieto i taren, “Taraha te poe mena nei u Buk u Goagono e Mesaia a hatutubunei romana tere Devit a King? ");
INSERT INTO hla_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","E Devit noa has te poei turu buk turu Sam, ‘A Tsunono e poei tara Tsunono i tar, Gumia teka tara pal matou i tar, e popona te hale goi lia lö u katun te paköe riou lö ba lö te na pita-puta ramoen.’ ");
INSERT INTO hla_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","E Devit e ngöei a katun teka ‘A Tsunono.’ Gime te mar hatubuna uana e Mesaia tere Devit?” Kaba e moa ta katun te ga ranga palis. ");
INSERT INTO hla_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","A poata ti hengo hobotoia u katun i tanen, be Iesu e poieto turu katunun tsitsilo i tanen, “Hanei sil riam u tson hihatuts turu Lo. Nori e ngilin hula la koru mier a hasobu a ngahangaha i taren, ba te ngil koruer u katun e gi hapan rien tara toana. Na nori e ngil koru haser e gi gumia turu gumgum u niga i matar u katun i iahana luman lotu na turu gumgum tara pal kapan tara kannou. ");
INSERT INTO hla_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nori e roron katoer u singon lotu u ngahangaha turu rung tun, ba te lu tsipon beri a peisaren a man ka turu amoba. Ba nori te luer romana a nihahuna a omi koru.” ");
INSERT INTO hla_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","E Iesu e hula tara me tarena u katunun moni ba te lapo hongo ner a monin hitaguhu i taren tara bokisin moni. ");
INSERT INTO hla_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Na nonei e tara hasi a toa tahol a amoba te moa koru ta ka ba te lapo hongo nena a tsi huol a tsi toea. ");
INSERT INTO hla_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ba nonei e poieto, “Alia e ranga mera golimiu, a tahol a amoba teka te moa koru ta ka e hala nelala a moni te pan saluhena tara moni te hala nelila a barebana hoboto. ");
INSERT INTO hla_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Taraha, nori hoboto e hala lila turu moni te kurapana i taren, kaba nonei a tahol e moa lel ta tsi moni i tanen. A tsi huol puku a tsi monin kannou te lapo hongo hakapa nala len.” ");
INSERT INTO hla_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","6","Ba palabir u katunun tsitsilo i ranga sileto a Luman Lotu Pan me poier, “Ruto u tara man hatu a man niga na tara man ka man taratara haniga ti halei a barebana tara luma tere Sunahan!” Be Iesu e poieto, “Hakats niam a man ka teka te rute milimiu. A poata e la nama romana be moa ta toa ta hatu teka te ga ka lelia romana tara makum i tanen. Nori hoboto koru e lapo ba raria romana i puta.” ");
INSERT INTO hla_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ba nori i rangate ten, “Tson Hihatuts, i hangisa te baba naria romana u hatu teka? Na saha hiharuts te haruto nena romana a poata te katsin butuna romana a ka teka?” ");
INSERT INTO hla_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Be Iesu e poieto, “Hanei iam, u katun e namos gamo rario limiu. Taraha, u katun u para e la rima romana ba te ngöe roi a peisaren a solor ba te mi poier, ‘Nonei alia!’ na ‘A poata hamanasa!’ Kaba ma kukute rami. ");
INSERT INTO hla_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Alimiu e hengo namiu romana a man hiatatung na man pula, kaba limiu go ma matoutmi. A man ka teka e butu mamuna romana, kaba a nikapakapa e ka noana.” ");
INSERT INTO hla_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ba nonei e ranga noana me poiena, “A toa han e hiatatung gono mena romana a tana han, na palair u hun katun e hiapulpular romana. ");
INSERT INTO hla_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ne ka has mena romana a man nun pan koru, na bes pan nu himati e na butu roa romana tara han a para. A man ka te hamatout rena u katun e butuna romana, na man hiharutona has i kolö. ");
INSERT INTO hla_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kaba i mam te ga butuia romana a man ka teka, ba limiu te pile kap rariou romana ba te kato homi pinopino rariou romana. Alimiu e kot raria romana i iahana u luman lotu turu Jiu ba te haka raria tara luman karabus. Na limiu e lu merari romana i matar u king na turu gamman te hamana uami limiu i tar. ");
INSERT INTO hla_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na nonei a poata te go na ranga mena milimiu u Bulungana u Niga. ");
INSERT INTO hla_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Na hengo iam! Alimiu go ma hakhakats hapara mam nami tu ranga te go ranga palis niam romana limiu. ");
INSERT INTO hla_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Taraha, alia e hala ragi romana limiu u ranga nu hakhakats u niga koru, bu pakö i tamilimiu te ma antunan tula puta nari romana u ranga te go hala rilia alimiu. ");
INSERT INTO hla_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A pal katun i tamilimiu e hala rario romana limiu turu pakö, u tamamilimiu nu tsinamilimiu nu toulamilimiu nu hahikapien i tamilimiu. Na palabi i tamilimiu e kato hamate rariou romana. ");
INSERT INTO hla_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","U katun hoboto e omi rario romana limiu te katun uami limiu i tar. ");
INSERT INTO hla_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kaba e moana romana tu toa tu hulu te ga taiaia romana i bakumilimiu. ");
INSERT INTO hla_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Alimiu go tuol hakarapoto sile iam a Tsunono ba nonei te lu pouts rano limiu.” ");
INSERT INTO hla_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","E Iesu e ranga lel me poiena, “Poata te tare mia romana limiu a ami a para te gono hahiser romana i Jerusalem, ba limiu te ateimiu romana a poata hamanasa te gi kato homi hakapa meni nonei a taun teka. ");
INSERT INTO hla_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ba pala te ka ria romana tara provins i Judia e gi bus tara pokus. Ba eresi te ka ria romana i iahana taun i Jerusalem e gi la ba nen, be resi te ka ria romana tara man han i ielesala e ma tatei la uari romana i iahana taun. ");
INSERT INTO hla_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Taraha, nonei a man lanin hahuna teka te kato hamanena romana u ranga hoboto turu Buk u Goagono te ranga mamin a man nomi teka. ");
INSERT INTO hla_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","A nitatagi pan koru e kana romana tara tohaliou te ka mer romana u pika nonei tara poata, na tara tohaliou te hihasusur romana. A poata a omi koru e butuna romana tara han teka, ne Sunahan e tor-si koru rena romana u katun teka. ");
INSERT INTO hla_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","A palai e ngats hamate rari romana u kilatan hiatatung, ba palai te karabus rer romana ba te la merari romana tara mamana han pan i lehana. Ba barebana te halhal ria turu Jiu e tötö homier romana a taun i Jerusalem ba te tara kap naren popona te ga kapa u romana a poata turu katun halhal teka.” ");
INSERT INTO hla_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Be Iesu e poiena, “U hiharuts e butuna romana tara pitala na tara tsihau na turu pitopito. Nu han pan u para i puta e tutu mer romana a nitatagi a kapan, ne matouter romana u tasi pan te ga posa uamen romana i loul nu sopo pan. ");
INSERT INTO hla_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","U katun e maten-topi mer romana a nimatout te hakats mena rien romana a man nomi te butuna romana i puta. Taraha, a mamana ka ni kolö e gasina romana. ");
INSERT INTO hla_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ba nori te tarer romana alia tu butun katunuma e la meguma romana u koasi i kolö na nitagala nu ualesala u kapan. ");
INSERT INTO hla_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tara poata te tanian butuna romana a man ka teka, ba limiu te ongolomiu ba te hatara seiemiu a bakumilimiu, taraha a poata te ga lu pouts meri limiu e Sunahan e susuku hakapa!” ");
INSERT INTO hla_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Be Iesu e hatei rane ien u haharoei teka, “Hakhakats niam a man roei te tatei sulur. ");
INSERT INTO hla_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Hena, tara poata te suluna u ngal, ba limiu te atei silemiu a poatan nou turu ngal e susukuna. ");
INSERT INTO hla_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ne kato has uana i iesana, poata te tare mia romana limiu a man ka teka, ba limiu te atei sil hasemiu a Nipepeito tere Sunahan e susukun butu nama. ");
INSERT INTO hla_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Alia e ranga hamana mera golimiu, a mamana ka hoboto teka e butuna romana i mam te mate ria a palair u barebana te toatoar tara poata teka. ");
INSERT INTO hla_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","U kolö nu puta e taiar romana, kaba u ranga i tar e moa koru te ga tatei taia uen romana.” ");
INSERT INTO hla_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Be Iesu e poiena, “Tara kap niam a peisamilimiu! E omina te go hakats talasi mena milimiu a tou nou na tou roro ba limiu te spakmiu ba te toku silemiu a man kana tun lasi i puta. Alimiu e namos asingoto namiu romana te songots butu nama romana nonei u Lan Pan tara Tsunono. ");
INSERT INTO hla_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Taraha, u Lan Pan teka e la here namei romana a tanga, ba te butuna romana turu katun hoboto te ka ria i puta, turu han hoboto. ");
INSERT INTO hla_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tara kap haniga iam ba te singo nitoa uamiu tere Sunahan ba limiu te ka memou a nitagala te go saluhe memi limiu a man nomi teka te ga butu uen, ba limiu te tuol mia romana i matar tu butun katunuma.” E Iesu e ranga u teka. ");
INSERT INTO hla_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mamanu lan e Iesu e hihatutsia i Luman Lotu Pan. Ba tara man bong nonei e na sohoia turu pokus ti ngöei u Pokus tara Roein Olip. ");
INSERT INTO hla_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bu katun hoboto te roron la uar i Luman Lotu Pan tara bongbong koru ti hengo u i tanen. ");
INSERT INTO hla_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","A poata e susuku hakapa tara Kannouna tara Beret te moa ta Yis, ti ngö hasei a Kannouna turu Paska. ");
INSERT INTO hla_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bu pris u kapan nu tson hihatuts turu Lo e torohanan sake ner ta maroro ta niga te gi atung hamate meni e Iesu, kaba nori i matoutir u katun, ba te sakier a maroro te gi atung hamate hamous menien. ");
INSERT INTO hla_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Be Satan e la uato i torina e Judas Iskeriot, nonei a toa tara 12 a katunun tsitsilo tere Iesu. ");
INSERT INTO hla_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Be Judas e na ranga gono merena u pris u kapan nu kepten turu polis ti taratara kapin a Luman Lotu Pan te ga mar hala menien e Iesu i taren. ");
INSERT INTO hla_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ba nori e sasalar me kitser u ranga te gi hala menien ta moni. ");
INSERT INTO hla_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Be Judas e hanige ieto a ka teka me hatanian sake nena ta maroro ta niga te ga hala menien e Iesu i taren te gi ma atei silei a barebana. ");
INSERT INTO hla_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","I iahana man lan tara kannouna tara beret te moa ta yis, u lan te gi atung hamate meri u tunan sipsip turu Paska e butu hakapa. ");
INSERT INTO hla_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Be Iesu e hala mera nei ere Pita ne Jon u ranga teka, “La iam ba te na hamatsköemiu a man ka, ba ra te na noue rou a kannou i tarara turu Paska.” ");
INSERT INTO hla_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ba nori i rangate ten, “Ime te ngile mulö te go na katoa lam a kannou teka?” ");
INSERT INTO hla_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ba nonei e poieto, “Hengo iam! A toa tson te soate nou a toa tabeli ramun e hitupali gono mera noa limiu te butu moa limiu i iahana taun. Ba limiu te kukutie moen ba te na tasu moa tara luma te la uanen. ");
INSERT INTO hla_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ba limiu te poe mou tara katun terena luma, ‘A Tson Hihatuts e poe nama i tamulö, Ime te kana a makum te mi nou gono mera goa lia u katunun tsitsilo i tar a kannouna turu Paska?’ ");
INSERT INTO hla_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ba nonei te haruto ranoi limiu a rum pan i iasa te ka hakapa mena a man tebol na man gumgum. Nonei tara makum teka te na kato hamatsköe moa limiu a mamana ka tara kannou.” ");
INSERT INTO hla_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ba nori e lar me na sabier a mamana ka te kato u te mar ranga merien e Iesu, ba nori e kato hamatsköer a kannouna turu Paska. ");
INSERT INTO hla_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","A poata e butu hakapa, be Iesu nu aposol e gum ria tara kannou. ");
INSERT INTO hla_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ba nonei e poieto i taren, “Alia e ngil koruegu te go nou gono meri limiu a kannouna turu Paska teka i mam te go sagoho meni lia a kamits! ");
INSERT INTO hla_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Taraha, alia e ranga mera golimiu, alia e ma tatei nou lele gien romana e popona tara poata a man ka te haharoei nena a kannou teka e butu hamana hakapana romana tara Nipepeito tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Be Iesu e luena a gotana wain me hanigana tere Sunahan me poiena, “Lue iam a gotana teka ba te hala namia i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Taraha, alia e ranga mera golimiu, alia e ma tatei ua lelegi u wain popona tara poata te la nama romana a Nipepeito tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ba nonei e lu hasena a beret me hanigana tere Sunahan me poseposie nen, me hala rane ien me poiena, “Nonei u tuanrei i tar tekaöte na mate sil rano limiu. Alimiu e na kato has uamiu teka tara beret ba te noue men ba te hakats pouts namo lia.” ");
INSERT INTO hla_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Na i murina ti nou hakapa ien, be Iesu e lu has mena nei a gotana wain i iesana me poiena, “A gotana teka te takis bera nolimiu e haharoei nena u rangan kits u tsimus te na kato hatagale goi lia u rahatsing i tar.* ");
INSERT INTO hla_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Kaba nonei a katun te hala nenoa lia turu pakö i tar, nonei e nou gono meno lia tara kannou teka! ");
INSERT INTO hla_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","E manana, alia tu butun katunuma e go na mate, te mar hopu kap meni lia e Sunahan. Kaba a nomi pan e butu noa nonei tara katun te hala neno romana lia turu pakö!” ");
INSERT INTO hla_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bu katunun tsitsilo e tanian rangrangata pouts ria i taren esi a toa i taren te katoe nou a ka teka. ");
INSERT INTO hla_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bu katunun tsitsilo e hiatatung mer u ranga me poier, “Esi te mammamna i tarara?” ");
INSERT INTO hla_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Be Iesu e poieto i taren, “U king tara man han i puta teka e roron tsunono hatagala ria turu katun i taren, nu katun pan e ngil beri a peisaren a solon ‘Tsunono Pan a Niga.’ ");
INSERT INTO hla_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kaba a markato teka e ma tatei ka neia i gusumilimiu. E moa. A katun i tamilimiu te panina e tatei kato here nanei a peisanen a hitots, ba tsunono i tamilimiu e tatei here nei a katunun kui. ");
INSERT INTO hla_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Esi a katun a tsunono, a katun te gumuna ba te nouna, tsi a katun te susoatsena a kannou i tanen? A katun te gumuna, nonei te panina. Kaba lia e ka gia i gusumilimiu e heregi a katunun susoata kannou. ");
INSERT INTO hla_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Alimiu u ka gono memo lia tara man poata ti torohaneia lia u katun. ");
INSERT INTO hla_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ba lia te hala ragoi limiu a nitsunono, te mar hala has meni e Tamar alia a nitsunono. ");
INSERT INTO hla_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Alimiu e nou mia ne ua mia romana tara kannou i tar tara Nipepeito i tar, ba limiu te gum mia romana tara gumgum a goagono turu king ba limiu te tsonun hamou mou romana tara 12 a hun katunur i Israel.” ");
INSERT INTO hla_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Be Iesu e poieto tere Pita, “Saimon, Saimon, hengo! E Satan e rangata hatagala sil te ga tohala merien romana alimiu hoboto, ne Sunahan e haniga. A nitolaha teka tere Satan e here nei a katun te lu katsena a kannou a niga na bita. ");
INSERT INTO hla_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kaba lia u singo hakapa sileio lö, o Saimon, te go ma hapolasa meni lö a nihamana i tamulö. Ba tara poata te habirits pouts uamuma romana lö i tar, ba lö te hatagala rem a nihamana turu hahatoulana i tamulö.” ");
INSERT INTO hla_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Be Pita e poiena, “Tsunono, alia e hanigegu te go la gono meni lia alö tara karabus na te go mate gono has meni lia alö!” ");
INSERT INTO hla_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kaba e Iesu e ranga poutsuna, “Alia e ranga mego lö, o Pita, a keriau a tson e ma kekeretskö noa noi i bong teka e popona te poe moa lö tara topisa poata alö e ma atei sile moi lia.” ");
INSERT INTO hla_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Be Iesu e poieto i taren, “Tara poata tu hala puku ria lia limiu ba te moana ta paus moni na pora nu sendol, ga limiu u makmakum ba niam ta toa ta ka, tsi e moa?” Ba nori i ranga poutsuto, “E moa ta ka te ga makmakum.” ");
INSERT INTO hla_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Be Iesu e poieto, “Kaba i romana, ta katun i tamilimiu te ka mena a paus moni tsi a pora e ga luen. Ne si te moana tu kilatan hiatatung e ga haholin u hasobu u ngahangaha i tanen ba te holena tu toa. ");
INSERT INTO hla_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Taraha, alia e ranga mera gilimiu a ka teka, u ranga turu Buk u Goagono e ga butu hamana te poiena, ‘Nori i haka gono meien u katun u omi,’ taraha nonei e ranga nano lia, nu ranga ti koloto mei lia e butu hamana nou romana.” ");
INSERT INTO hla_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bu katunun tsitsilo e poier, “O Tsunono, u huol u kilatan hiatatung teka.” Ba nonei e poiena i taren, “E antunana!” ");
INSERT INTO hla_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Be Iesu nu katunun tsitsilo e la ba ner a rum i iasa me la uar turu Pokus tara Roein Olip te roron kato uen. ");
INSERT INTO hla_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Poata ti tuku ien nonei tara makum, ba nonei e poiena i taren, “Singo uam tere Sunahan. U hiamus u omi e namos butuna i tamilimiu.” ");
INSERT INTO hla_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Ba nonei e gamon la ba ranen, te lehana hapopoia te lapo menari a hatu, me hatukununa me singona, “O Tamar, te ngil mia lö, ba lö te hatongo kap ba namoi lia a kamits teka te katsin butuna i tar. Kaba lö go ma kato uai turu ngil i tar. Alö go kato u turu ngil i tamulö.”* ");
INSERT INTO hla_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","44","Ba toa angelo ni Kolö e butuna i tanen me hatagale nen, taraha e Iesu e sagohi a nitagagi pan koru. Ba nonei e singo hatagala koru lelina. Bu siung i tanen e butu here nei u rahatsing me rus uana i puta. ");
INSERT INTO hla_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","I murinen ba nonei e takeina ba te la pouts uana turu katunun tsitsilo i tanen me sabe ranen ba te sohor, taraha nori i topi koru mei a nitatagi pan. ");
INSERT INTO hla_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ba nonei e poiena i taren, “Aha te soho memi limiu? Takei iam ba te singo uamiu tere Sunahan. U hiamus u omi e namos butuna i tamilimiu.” ");
INSERT INTO hla_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","E Iesu e ranga noa has ba toa hun katun te tukur. E Judas, a toa tara 12 a katunun tsitsilo te mammam ren, ba nonei e la uamato tere Iesu go mi mutsie ien. ");
INSERT INTO hla_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Be Iesu e poieto, “Judas, alö e katoem a saha markato teka te mutsi mena milia ba te haruto namia lia turu pakö i tar?” ");
INSERT INTO hla_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Poata ti tareia u katunun tsitsilo ti ka gono mei e Iesu a ka te butu hamanasana, ba nori e poier, “O Tsunono, alö e ngilem alam go atung rien u kilata?” ");
INSERT INTO hla_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ba toa i taren e torohanan atungena a katunun kui tara tsunono pan turu pris ba te ngats ba nena a talinganen tara pal matou. ");
INSERT INTO hla_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Be Iesu e ranga palisina, “E noana!” Ba nonei e sebeliena a talingana katun me kato haniga poutse nen. ");
INSERT INTO hla_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Be Iesu e poieto turu pris u kapan nu kepten turu polis ti taratara kapin a Luman Lotu Pan nu tsunono ti la silema te gi lu menien, “Taraha te la mena mumei limiu a man kilatan hiatatung na man baru ba te mi pile kap here mena milia a kopkop? ");
INSERT INTO hla_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Alia u ka gono merio limiu turu mamanu lan i Luman Lotu Pan ba limiu u ma pile kap natei lia. Kaba teka a poata i tamilimiu, a poata te panna a nitagalana turu kuhil.” ");
INSERT INTO hla_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ba nori i pile kap neto e Iesu me lu mena rien i luma tara tsunono pan turu pris. E Pita e kukute has, kaba e lama i pal lehana. ");
INSERT INTO hla_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","U tula i hatseia i gusuna makum i pal porina luma, be Pita e sohalata tara barebana ti gum hahis u tula. ");
INSERT INTO hla_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tara poata te tareia a toa taholun kui e Pita te gum uen i rehina u tula, ba nonei e tara hamatskö uana tere Pita me poiena, “A katun teka e ka gono has mei e Iesu!” ");
INSERT INTO hla_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Be Pita e holise ten me poiena, “Alia e ma atei sile gien!” ");
INSERT INTO hla_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Na tara tsitabubun poata, ba tana katun e tare ten me poiena tere Pita, “Alö has a toa i taren.” Be Pita e ranga palisito, “Alia u moa!” ");
INSERT INTO hla_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Na tara toa aua i murimuri, ba tana katun e ranga hatagala sisi nena e Pita, “U mana koru a katun teka e ka gono has mei e Iesu, taraha nonei has a katununa i Galili!” ");
INSERT INTO hla_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Be Pita e ranga palisito, “Alia e ma atei silegi a ka te ranga nemu lö!” Na i teka puku, tara poata te ranga noaia e Pita, ba keriau a tson e kekeretsköna. ");
INSERT INTO hla_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ba Tsunono e habiritsito me tara hamatskö uana tere Pita, ne Pita e hakhakats kapin u ranga tara Tsunono te ranga mam naien, “I mam te kekeretskö noa a keriau a tson i romana, ba lö te ranga topisa mou ba te poiem alö e ma atei sile milia.” ");
INSERT INTO hla_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Be Pita e lakasana me na tabe mena a nitatagi pan koru. ");
INSERT INTO hla_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Bu katun ti tara kapin e Iesu i hahakose ten. Ba nori e pitser a matanen me muke ren me rangatse ren, “Alö a propet! Esi te muke lalo lö?” ");
INSERT INTO hla_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ba nori e kato leler u mamana u ranga u omi i tanen. ");
INSERT INTO hla_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Poata te lania a lan, bu tsunono turu Jiu nu pris u kapan nu tson hihatuts turu Lo e gono hobotor, be Iesu e la menari turu hagum i taren. ");
INSERT INTO hla_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ba nori i poieto tere Iesu, “Hatei ramo lam, alö e Mesaia, tsi e moa?” Ba nonei e ranga palisina, “Sanena alia go ranga meraio limiu, ba limiu te ma hamane moi lia. ");
INSERT INTO hla_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na sanena alia go rangata rio limiu tu toa tu harangata, ba limiu te ma ranga palise moi lia. ");
INSERT INTO hla_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kaba i murina a poata teka, alia tu butun katunuma e gum gia romana tara pal matou tere Sunahan a tagala koru.” ");
INSERT INTO hla_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ba nori hoboto e poier, “Alö e poiem alö a Pien Tson tere Sunahan?” Ba nonei e ranga palis ranen, “Aa, limiu e ranga hamatskö mula.” ");
INSERT INTO hla_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ba nori i poieto, “Ara e ma tatei ngö lele rimei ta katun te ga kot gono meien! Ara e hengo peisa lila te kot mena lale ien a peisanen u ranga pouts i tanen!” ");
INSERT INTO hla_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bu katun hoboto i takeito me la menari e Iesu i matane Pailat. ");
INSERT INTO hla_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ba nori e hatanian kot ner e Iesu me poier, “Alam u tari a katun teka e kato hatutui a pal katun i tamulam. Nonei e ranga hapiu rilam te go hala meni lam a takis tere Sisa. Ba nonei e roron poiena, ‘Alia noa has e Mesaia. Alia a king.’” ");
INSERT INTO hla_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Be Pailat e rangatse nen, “Alö a King turu Jiu?” Be Iesu e ranga palisito, “Alö a tuam ba te rangam.” ");
INSERT INTO hla_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Be Pailat e poiena turu pris u kapan na turu katun u para ti gono, “Alia e ma sabiegi ta ka ta omi te gi hahuna silei a katun teka.” ");
INSERT INTO hla_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ba nori i ranga hatagala koruto me poier, “Nonei e roron hatutsir u katun turu han hoboto i Judia me kato hasingoto ranen. Nonei e hataniaia i Galili me mi noana teka.” ");
INSERT INTO hla_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Poata te hengoeia e Pailat a ka teka me rangatana, “A katun teka a katununa i Galili?” ");
INSERT INTO hla_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ba nori i hatanganato, be Pailat e toan hala mena nei e Iesu tere Herot a King te ka hasia i Jerusalem nonei tara poata, taraha e Herot e tara kapin a provins i Galili. ");
INSERT INTO hla_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","E Herot e sasala koru tara poata te tare ien e Iesu, taraha nonei e hengo nen na e solon ngil hasi te ga tara menien. Nonei e ngilin tari te ga kato meni e Iesu tu mirakul. ");
INSERT INTO hla_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Be Herot e rangate nei e Iesu u rangrangata u para, kaba e Iesu e ma ranga palisni ta toa ta makumun ranga. ");
INSERT INTO hla_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bu pris u kapan nu tson hihatuts turu Lo i la hasusuku mato me kot hatagala koru ner e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Be Herot nu soldia i tanen i hahakos neto e Iesu me maman ranga ria i tanen. Ba nori i haseieto u hasobun king i tanen ba nori i hala pouts mena teien tere Pailat. ");
INSERT INTO hla_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nonei turu lan teka e Pailat mere Herot i hikapien pouts, kaba nori i hiapalpal mam. ");
INSERT INTO hla_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","E Pailat e ngö gugoner u pris u kapan nu tsunono nu katun me poiena i taren, “Alimiu u mi piou namia a katun teka i tar me poemiu nonei e kato hatutu u hakats tara barebana. Na lia e katoe gula u kot i tanen teka i matamilimiu, kaba lia e ma sabie gulei ta toa ta ka ta omi i tanen te kot memien limiu. ");
INSERT INTO hla_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ne Herot has e ma sabie lalei ta ka ta omi i tanen, taraha nonei e hala pouts mena name ien i tamulam. Hengo iam, a katun teka e ma katoei ta ka ta omi te ga antunaia te gi atung hamate meien. ");
INSERT INTO hla_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kato uana teka ba lia te halahus negoen ba te hapuresie goen.”* ");
INSERT INTO hla_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Turu mamanu hiningal tara poata tara kannouna turu Paska, e Pailat e roron purese a toa karabus ti ranga sil u katun.* ");
INSERT INTO hla_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bu katun hoboto i kuto, “Atunge iam a katun teka, ba te hapurese mena mumei e Barabas i tamulam!” ");
INSERT INTO hla_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(E Barabas i haka mei tara karabus e hatakei a toa hiatatung tara gamman i iahana taun i Jerusalem, na nonei e atung hamate hasi a katun, ba nori e hake rien tara karabus.) ");
INSERT INTO hla_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Be Pailat e ngilin hapuresiena e Iesu, ba nonei e ranga lel merena u katun. ");
INSERT INTO hla_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kaba nori i ku pouts, “Tapala namia tara koruse! Tapala namia tara koruse!” ");
INSERT INTO hla_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Be Pailat e ranga hatopisana i taren me poiena, “Ga saha ka a omi te katoen? Alia e ma sabie gulei ta ka ta omi te ga katoen ba nonei te mate sile nen! Alia e halahus negoen ba te hapuresie goen.” ");
INSERT INTO hla_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kaba nori i ku hapan koru noa has te gi tapala meni e Iesu tara koruse. Bu ranga i taren e karasena u ranga tere Pailat. ");
INSERT INTO hla_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Be Pailat e toa kukutiena u ngil i taren me kitsena u ranga te ga mate u e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ba nonei e hapuresiena e Barabas a katun ti ngile ien, nonei ti haka sile ien tara karabus te habutu menien a hiatatung na te atung hamate menien a katun. Be Pailat e hala mena nei e Iesu turu katun e gi kato meien ti ngil uen. ");
INSERT INTO hla_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ba nori i la meto e Iesu. Poata ti la ien, ba nori i sabieto a toa katun a solonen e Saimon, a katununa tara provins i Sairini. Nonei e lama turu han i ielesala tara taun i Jerusalem. Ba nori i pile kap naten me hasoatse rien a koruse tere Iesu, ba nonei e murimurina tere Iesu. ");
INSERT INTO hla_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bu katun u para i kukutieto e Iesu. I gusuren i kaia a tohaliou ti tabe me hahuri meren. ");
INSERT INTO hla_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Be Iesu e habirits uato i taren me poiena, “Tohaliour i Jerusalem, ma tabe sile milia, kaba tabe sil riam a peisamilimiu na galapien i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Taraha, a poata e la nama te poe ria romana, ‘A tohaliou u kuba ti mamala posei ta pien na tohaliou ti ma hasusei ta pien, nori e gi sasala mei a tou kuba i taren!’ ");
INSERT INTO hla_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nonei tara poata a barebana e poier romana tara pokus pan, ‘Alimiu go rus muma i ielumulam!’ na tara pokus a tetenei, ‘Hamous ramo lam!’ ");
INSERT INTO hla_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Taraha, te mar kato mena rien lia teka te heregi u roei u pelpeli, ga ime te mar kato uaren romana turu katun u omi te hereri u roei u lango?” ");
INSERT INTO hla_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","A elasolana katun a omi i lu has meien te gi kato hamate gono meri e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tara poata ti tuku ien tara makum ti ngöei “U Lakö,” ba nori e tapala naria e Iesu tara koruse, na elasolana katun a omi i tapala has ria turu koruse i rehinen, a toa tara pal matou na tai tara pal keruka. ");
INSERT INTO hla_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Be Iesu e singo uato tere Sunahan me poiena, “O Tamar, alö go lu ban a markato a omi i taren. Nori e ma atei sileri aha te katoe ren.” Bu soldia e pilei satu siler u hasobu i tanen, me molamole ren. ");
INSERT INTO hla_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bu katun ti tuolia i susuku i tara uato i tanen, ba pal kapan turu Jiu e hahakos ner e Iesu me poier, “Nonei e taguhir a palai. Bara, nonei e ga taguhu peisa a peisanen, te ga Mesaia uen te hopu kapin e Sunahan!” ");
INSERT INTO hla_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Nu soldia has i hahakos nen. Ba nori i la hasusuku uamato i tanen ba nori e torohanan hale rien u wain u melil me poier, “Taguhi a peisamulö, te go King u lö turu Jiu!” ");
INSERT INTO hla_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A man ranga ti koloto nia i bakuna koruse i tanen e kato u, “A King turu Jiu teka.” ");
INSERT INTO hla_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","A toa katun a omi te kuteia i susuku e ranga homiia tere Iesu me poiena, “Alö e Mesaia, boka? Bara, taguhi a peisamulö na lam has!” ");
INSERT INTO hla_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ba taina katun a omi te kuteia i hapala e raharahe ten me poiena, “Alö e ma matoutemi e Sunahan? Ara e ka mera a toa nihahuna. ");
INSERT INTO hla_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ne matsköna, taraha a nihahuna i tarara a elasolana e palisena u markato u omi ti kato ra. Kaba a katun teka e ma katoei ta toa ta ka ta omi.” ");
INSERT INTO hla_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ba nonei e poiena tere Iesu, “Hakats sile molia, o Iesu, tara poata te la pouts here mumei romana lö a King!” ");
INSERT INTO hla_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Be Iesu e poieto i tanen, “Alia e ranga megi lö a ka teka, i romana alö e ka gono memoa lia i Kolö.” ");
INSERT INTO hla_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tara pal 12 kilok tara soasa, ba pitala te piri hanoana bu kuhil e kopo kap hoboto nena a han me antunana tara 3 kilok. ");
INSERT INTO hla_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bu labalaba pan te kuteia tara Luman Lotu Pan e takis katana me katoena a huol a makum. ");
INSERT INTO hla_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Be Iesu e ku hapan koruna, “O Tamar! Alia e hake gia u namnamei i tar i limamulö!” Nonei e ranga u teka me matena. ");
INSERT INTO hla_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ba tsunono turu soldia e tareto a man ka teka, ba nonei e soloseiena e Sunahan me poiena, “U mana koru nonei a katun a niga teka!” ");
INSERT INTO hla_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","U katun u para ti gono sil a man ka teka i taratara kapin a man ka te butu, ba nori e tatagi korur me mukumuku hoboter a lumlumaren me la pouts uar i han. ");
INSERT INTO hla_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bu hahikapien tere Iesu nu tohaliou ti kukutie men i Galili e tuol halehanar me tarer a man ka teka. ");
INSERT INTO hla_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","A toa katun a solonen e Josep e ka, a toun Arimatia a toa taun turu Jiu. Nonei a katun a niga na katun a matskö, na nonei e alosi te ga butu uama a Nipepeito tere Sunahan. Na nonei a pala turu Kot Pan turu Jiu, kaba nonei e ma hanigei a ka ti hatangana nien na ti katoen tere Iesu. ");
INSERT INTO hla_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ba nonei e la sileto te na singo meni u tuanrei tere Iesu tere Pailat. ");
INSERT INTO hla_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Be Pailat e hanigato, be Josep e na lu hakoulena u tuanrei tere Iesu, ba nonei e pitse neien u labalaba u lamelame, me hahonge nen tara kiou ti kahoeia turu lapo, a kiou te mamala haka noei ta mate i iahanen. ");
INSERT INTO hla_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nonei u lanin kato hamatskö tara mamana ka, na i mahö u Lan u Goagono turu Jiu. ");
INSERT INTO hla_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ba tohaliou ti la gono mema e Iesu i Galili e la gono mier e Josep me na tarer a kiou nime ti mar hopu meni a peisane Iesu i iogana. ");
INSERT INTO hla_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ba nori e la pouts uar i han me na hamatsköer a man ka man soka haniga tara tuanreine Iesu. Ba nori e husa mier u Lan u Goagono, te mar ranga u u Lo turu Jiu. ");
INSERT INTO hla_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tara bongbong koru turu Sandei ba tohaliou e la uar tara kiou me soater a man ka man soka haniga ti hamatskö mame ien. ");
INSERT INTO hla_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","3","Ba nori e na sabier a hatu i hategele bani a matana kiou, ba nori e lar i iogana. Kaba nori i ma sabiei a tuanreina e Iesu a Tsunono. ");
INSERT INTO hla_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ba nori i tuolta tara kiou me hakats koru ner a ka teka, ba elasolana katun e songots tuol ria i rehiren, u hasobu i taren e alesala koru. ");
INSERT INTO hla_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","A tohaliou i matout koru, ba nori e turu puta uar i puta, ba elasolana katun e poier i taren, “Aha te sake sile milimiu a katun a toatoa i gusur u katun u mate? ");
INSERT INTO hla_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nonei e ma ka neia teka. Nonei e takei hakapa. Hakats niam a ka te ranga nien i tamilimiu tara poata te ka ien i Galili. ");
INSERT INTO hla_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nonei e poei, ‘Alia tu butun katunuma e gi hala meni turu katun u omi, ba nori te tapala nariou romana lia tara koruse, ba lia te takei pouts megu romana u hatopisana u lan.’” ");
INSERT INTO hla_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Ba tohaliou e hakats sabe pouts ner u ranga teka, me kopis pouts uar i han me na ranga naria a ka teka tara 11 a katunun tsitsilo na tara palai hoboto has. ");
INSERT INTO hla_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","A tohaliou teka ere Maria Matalina ne Joana, ne Maria e tsinane Jemis. Nori nu palair a tohaliou ti ka gono meren i ranga mera tei u aposol a man ka teka. ");
INSERT INTO hla_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kaba u aposol i hakats me poier a tohaliou i kato u ranga pinopino. Ba nori i ma hamane tei u ranga i taren.* ");
INSERT INTO hla_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kaba e Pita e takei me pieta uana tara kiou, ba nonei e turuna me tara uana i iogana me tarena u labalaba u lamelame tun ne moa ta tan ta ka. Ba nonei e la pouts uana i han me hakats koru nena a ka te butu.* ");
INSERT INTO hla_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nonei noa has turu lan ba elasolana katun tere Iesu e la uar tara toa han a solonen i Emeas, e ka halehana ban i Jerusalem e popona tara 11 kilomita. ");
INSERT INTO hla_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ba nori e hiararanga ner a man ka hoboto te hagou butu. ");
INSERT INTO hla_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nori i hiararangaia tara poata ti la ien i maroro, be Iesu noa has e la hasusukuna me la gono mera nen i maroro. ");
INSERT INTO hla_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ba nori i tare ten, kaba e Sunahan e kato hatutu a mataren ba nori i ma marei sabie tei nonei e Iesu. ");
INSERT INTO hla_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Be Iesu e poieto i taren, “Aha te hiararanga nami limiu te la uami limiu i maroro?” Ba nori e tuolur me ruto hatatagir. ");
INSERT INTO hla_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ba toa i taren a solonen e Kliopas e ranga palise nen, “Alö a toa puku a katununa i Jerusalem te ma atei silemi a man ka te butuia tara man lan te la hakapa?” ");
INSERT INTO hla_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ba nonei e rangatato, “A saha man ka?” Ba nori e ranga palisir, “A man ka te butuia tere Iesu ni Nasaret. A katun teka a propet, na nonei e kato a man ranga man tagala nu mirakul has, ne Sunahan nu katun hoboto i hapan hobote ien. ");
INSERT INTO hla_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","U pris u kapan nu tsunono i tarara i hala menien te gi kato hamate menien, ba nori e hatapala narien tara koruse. ");
INSERT INTO hla_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kaba i manasa alam u mar hamana u teka: ‘Nonei a katun teka te sakahis pouts rena romana a barebanar i Israel.’ Aa, na u lan i romana u hatopisana u lan has i murina te butuia a man ka teka. ");
INSERT INTO hla_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Na palair a tohaliou tara pala i tamulam i hasingoto rio lam. Nori i la u tara kioun mate, kaba nori i ma sabiei a tuanreinen. Ba nori i kopis mato me poier nori i tarema u angelo, bu angelo e poier i taren nonei e toatoa pouts. ");
INSERT INTO hla_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ba palai tara pala i tamulam i la uato tara kiou me na sabe hamatsköer ti mar ranga u a tohaliou, kaba nori i ma rutei e Iesu.” ");
INSERT INTO hla_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Be Iesu e poieto i taren, “Alimiu e ma hakhakats hanigami. U hakhakats i tamilimiu e mokomoko koruna te go hamana mena milimiu a mamana ka ti rangein u propet i manasa! ");
INSERT INTO hla_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","E matskö has te ga sagoho meni e Mesaia a kamits teka ba nonei te toan luena a nikapan i tanen.” ");
INSERT INTO hla_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Be Iesu e hatarare rane ien u mamanu ranga turu Buk u Goagono te hatei nen, a man buk te kolotein e Moses nu ranga ti kolotein u propet hoboto. ");
INSERT INTO hla_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ba nori e la rima i rehina han ti la uen, be Iesu e tatatiena te ga la karasa uen. ");
INSERT INTO hla_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kaba nori i ranga hapiu nen me poier, “Ka gono bume rio lam. U lan e la hakapa na ka e lan kuhilina.” Ba nonei e tasuna me na ka gono mera nen. ");
INSERT INTO hla_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ba nonei e gum gono mera nen tara kannou me luena a beret, me haniga uana tere Sunahan. Ba nonei e posiena a beret me hala rane ien. ");
INSERT INTO hla_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ba mataren e alesalata ba nori e mareie ren, kaba nonei e songote taia. ");
INSERT INTO hla_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ba nori a elasolana e hiararanga poutsur, “U mana, a torirara e sagohe nama te mana uana u ranga i tanen, tara poata te ranga namen i maroro me hatuts ranei ra u Buk u Goagono.” ");
INSERT INTO hla_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ba nori e tutoa takeir me la pouts uar i Jerusalem, me sabe rer a 11 u katunun tsitsilo nu palai has ti ka gono mera ien. ");
INSERT INTO hla_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ba nori i poieto nori tara elasolana katun, “A Tsunono e takei hamana! Nonei e butuia tere Saimon!” ");
INSERT INTO hla_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ba elasolana e hatei rarien a ka te butuia i maroro, na ti mar marei menien e Iesu te pose menien a beret. ");
INSERT INTO hla_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ba poata ti hatei rien a man ka teka, be Iesu noa has e tuolna i gusuren me poiena i taren, “Masalohana e tatei ka gono mera nolimiu.” ");
INSERT INTO hla_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kaba nori i asingoto me matoutur, taraha nori i poei nori i tari a mate. ");
INSERT INTO hla_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ba nonei e poieto i taren, “Aha te toku memi limiu? A torimilimiu e hula hakats mena ha? ");
INSERT INTO hla_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Rute iam a man limar na man mour ba te mareiemiu a peisar, alia peisa. Salase molia ba limiu te atei mou, taraha alimiu e taremiu alia e ka megu u benö nu tsinö, kaba a mate e moa tu benö na tu tsinö.” ");
INSERT INTO hla_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nonei e mar ranga u teka me haruto rane ien a man limanen na man mounen. ");
INSERT INTO hla_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ba nori e ma hamana haniga noa hasiri, taraha nori i sasala koru ba te hula hakats hasir. Ba nonei e rangata ranen, “Ta kannou e kana?” ");
INSERT INTO hla_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Ba nori i hale teien a makumun iena a mösa, ba nonei e lue ten me noue nen i mataren. ");
INSERT INTO hla_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ba nonei e poiena i taren, “Nonei koru a man ka teka tu ranga merai lia limiu tara poata tu ka gono noa meria lia alimiu: a mamana ka ti koloto nilia tara Buk tere Moses na tara buk turu propet na turu Sam e ga butu hamana koru.” ");
INSERT INTO hla_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","46","Ba nonei e kalatseto u hakhakats i taren te gi atei sil menien u Buk u Goagono, me poiena i taren, “A man ka teka i kolotein: e Mesaia e ga sagohi u kamits ba te matena ba te toatoa poutsna tara tou mate i tanen turu hatopisanu lan. ");
INSERT INTO hla_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na ka teka i koloto hasin: u bulungana teka e gi rarareia turu hun katun hoboto i puta ba te taniana i Jerusalem — u katun te habirits ba ner u markato nu hakats u omi i taren ba te hamana uar tere Mesaia, e Sunahan e tatei lu ba nena u markato u omi i taren ba te tara pouts ranen. ");
INSERT INTO hla_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Na limiu tu tara hakape iam a man ka teka e habulungana namoen turu katun. ");
INSERT INTO hla_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Hengo iam. Nonei a ka te ranga hamanein e Tamar i manasa e ga hala meri limiu, nonei te hala ragi lia limiu romana. Kaba limiu go aloso bumia tara taun i Jerusalem teka e antunana te butu nama romana a nitagala i Kolö ba te kopo kap rano limiu.” ");
INSERT INTO hla_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ba nonei e halakasa ranen tara taun ba te na la hapopo ria i Betani, ba nonei te hasoa sei nena a limanen me kalala ranen. ");
INSERT INTO hla_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ba tara poata te kalala noa rien u katun teka, ba nonei e la ba ranen me na lu sei menari i Kolö. ");
INSERT INTO hla_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ba nori e hatsunone ren me la poutsur i Jerusalem ba te ka mer a nisasala pan. ");
INSERT INTO hla_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ba nori e ka nitoa ria i Luman Lotu Pan ba te haniga uar tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","A katun te ka mamin a mamana ka a solonen e Ranga. E Ranga e ka gono mei e Sunahan, na nonei e Sunahan noa lahas. ");
INSERT INTO hla_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nonei e ka gono mei e Sunahan i mam koru. ");
INSERT INTO hla_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","E Sunahan e habuteia a mamana ka tere Ranga. E moa ta toa ta ka te ga butu peisa. A mamana ka e butu lasia tere Ranga. ");
INSERT INTO hla_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A nitoatoa e kaia i tanen, na nitoatoa teka u ualesala turu katun. ");
INSERT INTO hla_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na nonei u ualesala teka e alesala noana turu kuhil, nu kuhil e ma hose neien. ");
INSERT INTO hla_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tara toa poata e Sunahan e hale iema a toa katun a solonen e Jon. ");
INSERT INTO hla_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","E Jon e la silema te ga hatei meri u barebana u ualesala teka, bu katun hoboto te tatei hamane ren. ");
INSERT INTO hla_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","E Jon e moa te go ualesala uen teka, kaba nonei e la silema te ga hatei meri u barebana u ualesala. ");
INSERT INTO hla_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nonei hamatskö koru u ualesala te la uama i puta me alesala uana turu katun hoboto. ");
INSERT INTO hla_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","E Ranga e habuti a han i puta na nonei e ka hasia i puta, kaba u katunur i puta i ma marei ien. ");
INSERT INTO hla_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nonei e la uama tara han i tanen bu katun i tanen i ma lu mena teien i taren. ");
INSERT INTO hla_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kaba a palabir u katun i lu menien i taren na i hamana koru u i tanen. Na nonei e hala rien a nitsunono te gi pien uen tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nori i butun pien u tere Sunahan, kaba e ma here nei a mar tuhana tara pien tere tubunen. E moa. Na nori i ma tuhana mei u ngil turu tuanrei tsi u ngil tara katun. E moa. Nori i tuhanaia tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","E Ranga e butun katunuma me kana i gusurara. Nonei a tsonun hitaguhu na tsonuna turu mana. Alam u ruto a nitsunono pan i tanen, a mar nitsunono te ka mena a toa koru a Pien Tson tere Tamanen i Kolö. ");
INSERT INTO hla_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","E Jon e hatei nen ba te poiena, “Nonei a katun teka tu rangein lia tu poe meni lia, ‘Nonei a katun te murimurina i tar i puta e pan bala nano lia, taraha nonei e ka mam neio lia i Kolö.’” ");
INSERT INTO hla_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Na tara hitaguhu pan i tanen nonei e haniga rano ra na nonei e hala ranei ra a nisasala pan me kato lele nen ba te kato talasina. ");
INSERT INTO hla_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","E Moses e hale iema u Lo tere Sunahan, ne Iesu Kristo e hale iema a nihitaguhu nu ranga u mana. ");
INSERT INTO hla_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","E moa ta toa ta katun te ga tari e Sunahan. Kaba a toa koru a Pien Tson i tanen, te kana i rehina e Tamanen, nonei te hatei rira e Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Turu toa u lan a pal kapan turu Jiu i Jerusalem i hala mera mei u pris nu Livait tere Jon. Ba nori e rangatse ren me poier, “Alö esi? Alö e Mesaia te ga la uama i puta?” ");
INSERT INTO hla_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Be Jon e holisina. Nonei e ma hahalongoloi. Nonei e ranga hamatskö u i taren me poiena, “Alia e moa te go Mesaia u.” ");
INSERT INTO hla_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ba nori e rangatse ren me poier, “Alö banei esi? Alö e Ilaitsa a propet?” Ba nonei e poiena, “Alia e moa.” Ba nori e poier, “Alö toum nonei a propet te hahalose mulam?” Ba nonei e poe lelina, “E moa.” ");
INSERT INTO hla_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ba nori e poe leler i tanen, “Hatei ramei lam, alö esi? Alam go la pouts mena lei u ranga palis tara pal tson te hala reri malam. Alö e ngöemi a peisamulö esi?” ");
INSERT INTO hla_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ba nonei e poiena, “Alia e heregi u runguna katun te ranga hapanna tara latu pinopino ba te poiena, ‘Kato hamatsköe iam a maroro te ga silama a Tsunono,’ te ranga has u e Aisaia a propet.” ");
INSERT INTO hla_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","U Parisi ti hala rema u katun teka. ");
INSERT INTO hla_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ba nori e rangatse ren me poier, “Alö e poe mula alö e ma Mesaiami na lö e ma Ilaitsami na lö e ma propet hasmi. Te mar kato uanen teka, gaha te baptais sil rami lö u katun?” ");
INSERT INTO hla_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Be Jon e ranga palis uana i taren me poiena, “Alia e baptais negu u ramun tun. Kaba a toa katun e kana i gusumilimiu te ma atei sile milimiu. ");
INSERT INTO hla_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","A katun teka nonei te murimuri nama romana i tar. Nonei a tsunono pan na lia a katun papala koru.” ");
INSERT INTO hla_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","A ka teka e butuia tara han i Betani i hapalana ramun i Jodan, te baptais reia e Jon u katun. ");
INSERT INTO hla_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Turu tan u lan be Jon e tarena e Iesu e la uama i tanen, be Jon e poiena turu katun, “Ruto uam nonei tara katun. Nonei e here noi romana a Tunan Sipsip tere Sunahan. Nonei e lu ba nenou romana u markato u omi turu katun i puta. ");
INSERT INTO hla_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nonei a katun teka tu rangein lia tu poe meni lia, ‘A toa katun e murimuri nama romana i tar i puta te pan bala nano lia, taraha nonei e ka mam neio lia i Kolö.’ ");
INSERT INTO hla_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Alia u ma atei silei esi koru nonei e Mesaia. Kaba alia e mi baptais mei u ramun te gi atei sil meni u katunur i Israel nonei.” ");
INSERT INTO hla_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","E Jon e baptais e Iesu, ba i murinen ba nonei e poiena, “Alia u rutei u Namnamei tere Sunahan e kouluma i Kolö me here namei a kulu, ba nonei e kakana i tanen. ");
INSERT INTO hla_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Alia u ma atei silei esi koru nonei e Mesaia. Kaba e Sunahan, te hala nemo lia te go mi baptais meri lia u katun u ramun, nonei e poei i tar, ‘Alö e na rute mou u Namnamei tere Sunahan e koul nama romana ba te mi kakana tara toa katun. Nonei a katun te na baptais nenou u Namnamei u Goagono.’” ");
INSERT INTO hla_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Be Jon e poiena, “Alia u ruto a ka teka te butu uen, na lia e hatei ragi limiu nonei a Pien Tson tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Turu tan u lan be Jon e ka gono lel merena a elasolana turu katunun tsitsilo i tanen. ");
INSERT INTO hla_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ba nonei e tara silena te la u e Iesu me poiena, “Ruto mula. Nonei a Tunan Sipsip tere Sunahan i tium.” ");
INSERT INTO hla_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ba nori a elasolana katunun tsitsilo tere Jon e hengoer u ranga teka me toan kukutier e Iesu. ");
INSERT INTO hla_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Be Iesu e habiritsina me tarena ti kukute mena meien me poiena i taren, “Alimiu e sakiemiu aha?” Ba nori e poier i tanen, “O Rebai, ime te susoho mia lö?” (A Rebai e mouna uana tson hihatuts.) ");
INSERT INTO hla_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ba nonei e poiena i taren, “Alimiu mi ruto mou.” Ba nori e la gono meren me rute ier a han i tanen. Nori i la mei a pal 4 kilok tara lahi. Ba nori e na ka gono meren turu lan teka. ");
INSERT INTO hla_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","E Endru nonei a toa tara elasolana katun teka ti hengo u ranga teka tere Jon na ti la gono mei e Iesu. E Endru nonei e toulana e Saimon Pita. ");
INSERT INTO hla_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Be Endru e la hamatsköna tere toulanen e Saimon me poiena i tanen, “Alam e sabie muma e Mesaia.” (E Mesaia e ngö haseri e Kristo.) ");
INSERT INTO hla_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ba nonei e piou nena e Saimon tere Iesu. Be Iesu e tare nen me poiena, “Alö e Saimon, a pien tere Jon. Alö e ngö hase roi e Sipas.” (E Sipas e ngö haseri e Pita, ne mouna uana a Hatu.) ");
INSERT INTO hla_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Turu tan u lan e Iesu e ngilin la u tara han i Galili, me sabiena e Pilip me poiena i tanen, “La gono memo lia.” ");
INSERT INTO hla_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","E Pilip a toun Betsaida, a taun tere Endru mere Pita. ");
INSERT INTO hla_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Be Pilip e na sabe uasena e Nataniel me hateie nen, “Alam e sabie muma e Mesaia, a katun te koloto bin e Moses nu propet i manasa! Nonei e Iesu a toun Nasaret, a pien tere Josep.” ");
INSERT INTO hla_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Be Nataniel e poiena, “E moa ta ka ta niga te ga tatei butuia i Nasaret.” Be Pilip e poiena, “E moa. Alö go la gono memo lia ba te na tara peisam.” Ba nori e la talar. ");
INSERT INTO hla_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Poata te tara raien e Iesu ba nonei e ranga nena e Nataniel me poiena, “A toun Israel hamana te la nama teka. E moa tu gamo i tanen.” ");
INSERT INTO hla_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Be Nataniel e rangatsena e Iesu, “Ime te mar atei sil halona mena milö alia?” Be Iesu e ranga palise nen, “U hakhakats tun i tar te tare lalo lö i mouna u roein fik i mam te ngöe nama e Pilip alö.” ");
INSERT INTO hla_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Be Nataniel e poiena, “O Rebai, alö a Pien tere Sunahan! Alö a katun te hopu kap bin e Sunahan te go Kingia i Israel!” ");
INSERT INTO hla_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Be Iesu e rangatse nen, “Alö e hamana miem te poe mena gulei lia alia e tare gulo lö i mouna u roein fik? Alö e na tare mou romana a man mirakul te pan bala nena a ka teka. ");
INSERT INTO hla_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","U mana koru alia e hatei rago limiu, alimiu e tare mou romana u kolö e kalata nou bu angelo tere Sunahan te sei ria romana i tar ba te koul pouts has rima romana i tar, alia tu butun katunuma.” ");
INSERT INTO hla_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","I murina u huol u lan, a toa katun e hitölia tara taun i Kena tara provins i Galili, ne tsinane Iesu e ka has. ");
INSERT INTO hla_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","E Iesu nu katunun tsitsilo i tanen i ngö has merai tara hitöl teka. ");
INSERT INTO hla_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Poata ti ua hakapia a barebana u wain, be tsinane Iesu e poiena i tanen, “Nori i moa tu wain.” ");
INSERT INTO hla_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Be Iesu e ranga menen me poiena, “Nonei a ka i tar, e ma ka uanei i tamulö. A poata i tar e ka noana.” ");
INSERT INTO hla_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Be tsinanen e poiena turu katunun kui, “Alimiu go kato iam a man ka te ranga nanen.” ");
INSERT INTO hla_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","A tönomo a tabeli e ka, a man kan totobu turu Jiu. U lotu turu Jiu e ka mena a lo te hatei nena te ga mar galus meni a katun a limanen. Tara man toa man tabeli e tatei osuler ba te antunana tara 100 lita tsi a 150 lita tara man toa. ");
INSERT INTO hla_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Be Iesu e poiena turu katunun kui, “Osulemi u tabeli tu ramun.” Ba nori e osul hasaputu hobotser u tabeli. ");
INSERT INTO hla_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ba nonei e ranga mera nen me poiena, “Kana tale iam ta tsitabubu ba limiu te na hale mien a tson te taratara kap nena a kannou.” Ba nori e lu tala mena rien i tanen. ");
INSERT INTO hla_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Ba tson taratarakap tara kannou e torohana talena u ramun ti hagou palis menai turu wain. Nonei e ma atei silei ime te lama u wain teka. Kaba u katunun kui ti osul u ramun nori ti atei. Ba tson taratarakap tara kannou e ngöena a tsonun tölo ba nonei e poiena i tanen, “Palabir u katun hoboto e haua mam ner u wain u niga, nu katun e ua hakaper a para koru, ba nori te toan haua ner u wain te ma niga bala nei. Kaba alö e hamouse mula u wain u niga na i teka puku talasi te toan lu mena mume ien lö i teka!” ");
INSERT INTO hla_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nonei a mirakul tutun te kato e Iesu na nonei e katoe ien i Kena tara provins i Galili. Na nonei e harutori a barebana te pan uen, bu katunun tsitsilo i tanen e hamana uar i tanen. ");
INSERT INTO hla_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","I murina te kapaia a hitöl, be Iesu e la uana i Kapeneam me gamon ke iena a tsi poata a tsi lehana. Be tsinanen nu toulanen nu katunun tsitsilo i tanen e la gono has meren. ");
INSERT INTO hla_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","A poata tara kannouna turu Paska turu Jiu e sukusuku, be Iesu e la uana i Jerusalem. ");
INSERT INTO hla_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nonei e tasuia i iahana makum i rehina Luman Lotu Pan, ba nonei e sabiena u katun ti haholin u bulumakau nu sipsip nu kulu. Na palabi i gumia i rehina a man tebol i taren me paliser a moni. ");
INSERT INTO hla_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Be Iesu e luena a lohiana me kuie neien a kan hisingata, ba nonei e tsuga ba rena u katun teka nu bulumakau nu sipsip na man ka hoboto tara makum i rehina Luman Lotu Pan. Ba nonei e halakopena u tebol turu katunun palpalis moni me tsihasa nena u silva i taren. ");
INSERT INTO hla_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ba nonei e poiena turu katun ti haholin u kulu, “Lu ba neiam a man ka teka! A luma tere Tamar e ma tatei kato here nami limiu a luman toana!” ");
INSERT INTO hla_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bu katunun tsitsilo i tanen e hakats pouts ner u ranga turu Buk u Goagono te poe mami, “A torir e matesil koruena a luma tere Sunahan e ga ka haniga nitoa.” ");
INSERT INTO hla_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ba pal kapan turu Jiu e rangata seier e Iesu me poier, “Ime tu lui malö a nitsunono? Te go ka meia lö a nitsunono tere Sunahan, ba lö te katoem ta mirakul ba te haruto namen!” ");
INSERT INTO hla_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Be Iesu e ranga kopisina, “Bara. Alimiu go kato homi iam a luma tere Sunahan teka ba lia te hatakei poutse goen turu topisa u lan.” ");
INSERT INTO hla_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ba pal kapan turu Jiu e poier, “Pua! A Luman Lotu Pan teka i hatakei mei u 46 u hiningal! Ime koru te hatakei pouts boroboro halona mena moien lö turu topisa u lan?” ");
INSERT INTO hla_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kaba e Iesu e rangein a tuanreinen, te here nei a luma tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Na i murimuri, te hatakei poutsia e Sunahan e Iesu tara tou mate i tanen, bu katunun tsitsilo i tanen e hakats pouts ner te kato menien u ranga teka. Ba nori e toan hamaner u Buk u Goagono nu ranga tere Iesu. ");
INSERT INTO hla_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","E Iesu e kaia i Jerusalem tara poata ti kateia u Jiu a kannouna turu Paska i taren. Bu para u katun i tare ten te kato menien u mirakul ba te toan hamane ren. ");
INSERT INTO hla_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kaba e Iesu e ma hamana talasii i taren, taraha nonei e atei sil u hakats turu katun hoboto. ");
INSERT INTO hla_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nonei e ma ngili ta katun e ga hateien ime te mar kato uana a torir u katun. Taraha, nonei e atei. ");
INSERT INTO hla_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","A toa katun a solonen e Nikodimas e la uama tere Iesu tara toa bong. Nonei a toa kapan turu Jiu na nonei a pala has turu Parisi. Ba nonei e poiena tere Iesu, “O Tson Hihatuts, alam e atei silem alö u lama tere Sunahan e go mi hatutsir lam. Taraha, e moa ta toa ta katun te go tatei kato a man mirakul te katoe mulö te go ma taguhu menien e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Be Iesu e ranga palise nen me poiena, “U mana koru alia e hateie golö, te ma posa lele ria a katun, e ma tatei atei sile nei a man kana tara Nipepeito tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Be Nikodimas e poiena i tanen, “Ime te tatei posa halona lel mena roi a katun te pan hakapa? Nonei e tatei la poutsuna i iahana u ongungon-pien tere tsinanen ba te posa hahuol lele riou?” ");
INSERT INTO hla_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Be Iesu e ranga palis uana i tanen me poiena, “U mana koru alia e hateie golö, te ma pose ria a katun turu ramun na turu namnamei, nonei e ma tatei tasu nei tara Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","U tuanrei e hatuhanena u tuanrei, nu namnamei e hatuhanena u namnamei. ");
INSERT INTO hla_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Alö go ma asingotoi te hatei mena gulei lia alö, ‘Alimiu gi posa lel riou.’ ");
INSERT INTO hla_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A lomolomo e bahu uana te ngil uanen, ba lö te hengoem te ling uanen. Kaba alö e ma atei silemi te la namen na te la uanen. Ne kato has uana i iesana tara katun te pose ria turu Namnamei.” ");
INSERT INTO hla_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Be Nikodimas e poiena i tanen, “Ime te tatei mar butu halona uana a ka teka?” ");
INSERT INTO hla_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Be Iesu e ranga palisina i tanen me poiena, “Alö a tson hihatuts pan i Israel ba lö te ma atei silemi a ka teka? ");
INSERT INTO hla_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","U mana koru alia e hateie golö, alam mera pal barebana i tar e raranga nem a man ka te atei sile mulam na man ka tu ruto hakapi lam, kaba alimiu e rama namiu u raranga i tamulam. ");
INSERT INTO hla_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Alia u hatei rai limiu a man kana i puta. Te ma hamane mia limiu a man ka teka, ba te moa koruna te go tatei hamana uam limiu i tar te go hatei meri lia limiu a man kana i Kolö. ");
INSERT INTO hla_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","E moa ta toa ta katun te ga la sei i Kolö. Kaba alia tu butun katunuma u koulma i Kolö. ");
INSERT INTO hla_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","E Moses e haka sei u keisan kukutsi turu roei tara latu pinopino. Ba lia tu butun katunuma e haka sei noa has menari romana i iesana. ");
INSERT INTO hla_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","E kato uana teka bu katun hoboto te hamana roa i tar e tatei ka meriou romana a nitoatoa te ka nitoana.” ");
INSERT INTO hla_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","E Sunahan e tatagi sil koru rema u katun hoboto me hala nenama a toa koru a Pien Tson i tanen. Na katun te hamana uana i tanen e ma tatei tia nei romana kaba e tatei ka menou a nitoatoa te ka nitoana. ");
INSERT INTO hla_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","E Sunahan e ma hala sile mei a Pien Tson i tanen i puta te go mi kot sil merien u katun i puta. E moa. Nonei e hala sile meien te go mi taguhu merien u katun. ");
INSERT INTO hla_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","A katun te hamana uana tara Pien Tson tere Sunahan e moa tu kot te ga butuia i tanen. Kaba a katun te ma hamana nei e ka noa has mena u kot, taraha nonei e ma hamana uai tara toa koru a Pien Tson tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","U kot e mar kato uana teka: u ualesala e la uama i puta. Nu ualesala teka e haharoei nena u niateina tara man ka hamana tere Sunahan. Bu katun e ngiler u kuhil me rama ner u ualesala, taraha a markato i taren e omina. ");
INSERT INTO hla_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Taraha, a katun a omi e rama koru nena u ualesala, ba nonei te ma la uana mei turu ualesala, te gi ma haruto menien a markato i tanen. ");
INSERT INTO hla_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kaba a katun te kato hamatsköna e la uanama turu ualesala, bu ualesala te haruto nanou e Sunahan e hanige iena a markato i tanen. ");
INSERT INTO hla_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ba i murimuri, be Iesu nu katunun tsitsilo i tanen e la hoboto uar tara provins i Judia. Ba nori e na ka ria tara han teka ba te baptais rer a barebana. ");
INSERT INTO hla_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","E Jon i ma haka noei tara karabus. Nonei e baptais hasir u katun i Inon te sukusukuia tara han i Selim. Taraha, a ramun e gono. Ba barebana e mi luer a baptais. ");
INSERT INTO hla_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ba palair u katunun tsitsilo tere Jon na toa Jiu e hiangengangena siler a saha mar baptais te matsköna. ");
INSERT INTO hla_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ba nori e la uarima tere Jon me poier i tanen, “Tson Hihatuts, alö e atei silem nonei a katun te ka gono meio lö i hapalana ramun i Jodan, nonei a katun tu rangein lö? Nonei e baptais has rena u katun, nu barebana e la hoboto uar i tanen!” ");
INSERT INTO hla_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Be Jon e ranga hakopis mera nen, “A katun e ka talasi mena a ka te hale meien e Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Alimiu u hengo mam buniam tu poe meni lia, ‘Alia e moa te go Mesaia u. E Sunahan e hala sile moi lia te go mam mena meien lia.’ ");
INSERT INTO hla_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","E Iesu e here nei a tsonun tölo na lia e heregi a tsonun hitaguhu i tanen. Poata te hitöl mena a tson a tahol i tanen, ba tsonun hitaguhu te tuol hatalisina ba te sasala koruna te hengo mena neien u ranga tara tsonun tölo. E kato uana teka ba lia te sasala koru hasigu. ");
INSERT INTO hla_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nonei a katun e ga pan, na lia e go tetenei pouts.” ");
INSERT INTO hla_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nonei a katun te lama i iasa e pan bala rena u katun hoboto. A katun te kato uana i tar te butuia i puta. Kaba nonei a katun te lama i Kolö e kana i iasa turu katun hoboto. ");
INSERT INTO hla_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nonei e hatei nena a man ka te tare ien na te hengoe ien. Kaba e moa ta katun te go hengo u ranga i tanen. A ma tsi palabi lasi te hengoe ren. ");
INSERT INTO hla_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kaba a katun te hengoe nen e sabiena te mana uana e Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","E Sunahan te hale iema a katun teka ba nonei te mi hatei nena u ranga tere Sunahan. Na nonei e saputena u Namnamei u Goagono te hala nenama e Sunahan i tanen. ");
INSERT INTO hla_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","E tamanen e Sunahan e ngil korue nen me hale neien a mamana ka te go tsunono nen. ");
INSERT INTO hla_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","A katun te hamanena nonei a Pien tere Sunahan e ka mena a nitoatoa te ka nitoana. Na katun te hahamanana na te ma hengoe neien, nonei e ma tatei lue nei a nitoatoa hamana, na raharaha tere Sunahan e ka nitoana i tanen. ");
INSERT INTO hla_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","U Parisi i hengoin u katunun tsitsilo tere Iesu i para balein u katunun tsitsilo tere Jon, na i hengo hasin u katunun tsitsilo tere Iesu i baptaisir u katun u para. (");
INSERT INTO hla_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","E Iesu e ma baptaisri u katun, u katunun tsitsilo i tanen lasi ti baptais ren.) ");
INSERT INTO hla_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Poata e Iesu e atei sil ti hengo meni u Parisi u ranga teka, ba nonei e toan la ba nena a provins i Judia me la pouts uana tara provins i Galili. ");
INSERT INTO hla_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","E la u i Galili ba te silana tara maroro te butuna i gusuna provins i Sameria. ");
INSERT INTO hla_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ba nonei e na tukuna tara toa taun i Sameria te ngöeri Saikar. A taun teka e sukusukuna tara makumun tsikitsiki te halei e Jekop a pien i tanen e Josep i iomin koru. ");
INSERT INTO hla_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","A kioun ramun te hakahoin e Jekop i manasa e ka noa has. E Iesu e gegesi koru mei a nilala a ngahangaha i tanen, ba nonei te na gumuna i rehina a kioun ramun tara pal soasa. ");
INSERT INTO hla_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","U katunun tsitsilo tere Iesu i na holia a tsi kannou tara taun. Ba toa taholuna i Sameria e mi osul ramununa. Be Iesu e poiena i tanen, “Hale moi lia ta tsi ramun e go ue lia.” ");
INSERT INTO hla_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ba tahol e asingoto koruna me poiena i tanen, “Alö e rangata nem ta tsi ramun i tar? Ga lö a Jiu na lia a taholuna i Sameria!” (Nonei e mar ranga u teka, taraha u Jiu i ma ngilri a tei Sameria. Nu Jiu e ma ua has ria tara kan uaua turu Sameria.) ");
INSERT INTO hla_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Be Iesu e ranga palise nen, “Alö e ma atei silemi a ka a niga te ngilin hala nanoi lö e Sunahan. Na lö e ma atei sil noa hase milia. Sanena te go atei sil meni lö alia, alö sane rangata nem ta tsi ramun i tar, ba lia te hale goi lö u ramununa tara nitoatoa!” ");
INSERT INTO hla_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ba tahol e poiena i tanen, “Kaba lö e moa ta kan osul na ta lohiana, na kioun ramun teka e tsiruku koruna. Ime te lue moa lö u ramununa tara nitoatoa teka? ");
INSERT INTO hla_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Alö e pan bala nem e tuburara e Jekop? Nonei e hala rilam a kioun ramun teka, na nonei na galapien i tanen nu sipsip nu bulumakau i tanen i uaua hobotoia tara kioun ramun teka.” ");
INSERT INTO hla_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Be Iesu e ranga palis menen, “A katun te ueie nou u ramun teka e na maka lel nou. ");
INSERT INTO hla_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kaba a katun te ueie nou u ramun te hala nagou lia e ma tatei maka lel noi. Taraha, u ramun te hale goien lia e here noi a kioun ramun i iogana i tanen, ba nonei te bututu nitoa mena a nitoatoa te ka nitoana.” ");
INSERT INTO hla_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ba tahol e poieto, “Alö go hale mei lia nonei u ramun teka ba lia te ma tatei maka lel goi, na lia go ma tatei la halehana uamei teka te go mi osul ramun u.” ");
INSERT INTO hla_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Be Iesu e poieto i tanen, “Alö go na ngöema a tson i tamulö ba limiu te la pouts uamuma i teka.” ");
INSERT INTO hla_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ba tahol e poiena i tanen, “Alia e moa ta tson.” Be Iesu e poiena, “Alö e ranga hamanam te poe mena milö alö e moa ta tson. ");
INSERT INTO hla_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Alö u hitöl hakapa mei a elalima tson, na tson te ka gono memu lö tara poata teka e ma tson hamana uanei i tamulö. Alö e ranga hamanam.” ");
INSERT INTO hla_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ba tahol e asingoto koruna me poiena, “Ii, alö banei a propet? ");
INSERT INTO hla_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","U tubumulam i lotu tere Sunahan turu pokus te ka nama ili.* Kaba alimiu u Jiu te poemiu a barebana e gi lotuia i Jerusalem.” ");
INSERT INTO hla_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Be Iesu e poiena i tanen, “Hengo tala. A poata te la nama bu katun te ma lotu uaroi tere Sunahan turu pokus puku teka tsi i Jerusalem puku. E moa. ");
INSERT INTO hla_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Alimiu e ma atei silemi aha te lotu uami limiu. Kaba alam e atei silem a ka te lotu uamu lam. Taraha, a katun te lu pouts mera nei u katun tere Sunahan e butu sila nama turu Jiu. ");
INSERT INTO hla_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","I romana na i murimuri has a katun te ngil hamanena e Sunahan e lotu uanou i tanen i torinen ba te lotu hamanana. E Sunahan e sakiena a mar katun teka te go lotu u i tanen. ");
INSERT INTO hla_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","E Sunahan u Namnamei, na katun te lotu uana i tanen e go lotu hamana i torinen.” ");
INSERT INTO hla_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ba tahol e poiena i tanen, “Alia e atei silegu e Mesaia e la nama romana, a katun te ngöeri e Kristo. Poata te butu nen romana ba nonei te hatei ranoi ra a mamana ka hoboto.” ");
INSERT INTO hla_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Be Iesu e poieto, “Alia nonei e Mesaia te ranga gono mego lö.” ");
INSERT INTO hla_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nonei a poata teka bu katunun tsitsilo tere Iesu te tuku poutsur, ba nori i asingoto koru neto te ranga gono menai e Iesu a tahol. Kaba nori i ma rangats ien, “Aha te ranga gono sil memi lö a tahol teka, na ha te ranga nemi limiu?” E moa. Nori i ma rangata uai teka. ");
INSERT INTO hla_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Ba tahol e la ba nena a tabelin osul i tanen me la poutsuna tara taun ba te na hatei rena u barebana, “Alimiu go la muma. Mi tare iam a katun te hatei namoi lia a mamana ka hoboto tu kati lia i manasa. Nonei romana e Mesaia, a katun te hahalose rara?” ");
INSERT INTO hla_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ba barebana e la ba nerima a taun ba te la uarima tere Iesu. ");
INSERT INTO hla_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nonei tara poata teka u katunun tsitsilo i tahulei e Iesu te ga nou menien a tsi kannou. ");
INSERT INTO hla_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Be Iesu e poieto i taren, “E moa. Alia e ka megu a tsi kannou te ma atei sile milimiu.” ");
INSERT INTO hla_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bu katunun tsitsilo i tanen e hiarangarangatar me poier, “Ta katun toum e hale lale ien ta tsi kannou?” ");
INSERT INTO hla_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Be Iesu e ranga hakopisina, “A kannou a niga i tar e kato uana teka: alia e kato begu u ngil tere Sunahan te haleie molia, ba lia te hakape gou a toukui i tanen. A ka teka e here nei a kannou i tar. ");
INSERT INTO hla_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Alimiu e poiemiu, ‘A tohats — tsihau patu ba kannou te tangoho nou.’ Na lia e hatei rago limiu, a kannou te tangohona e here nei a katun a para te katsin hamana uar i tar. Alimiu go tara sei uam tara man kui. Nori i tangoho hakapa. ");
INSERT INTO hla_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","37","E kato uana tara toa katun te lebei a uele ba tai te luena a lango i tanen ba te kuie nen. Ba nori te sasala hobotor te lu mena rien a moni. A toukui teka e here nei u katun te katsin hamana uar i tar ba te luer a nitoatoa te ka nitoana. A katun te lu mera name ien i tar e luena u hamatana tere Sunahan, ba nonei te sasala hoboto gono mena a katun te hala mam rien u ranga tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Alia e hala sil ragoi limiu te go na gono mera mumei limiu u katun te katsin hamana uar i tar. A palair u katun i hala mam rien u ranga tere Sunahan, na limiu e na kato halesalemiu u ranga tere Sunahan te gi tatei hamana haniga uen.” ");
INSERT INTO hla_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A tei Sameria a para tara taun teka i hamanaia tere Iesu, taraha nonei a tahol e poe hakapi, “Nonei e hatei namei lia a mamana ka hoboto tu kati lia i manasa.” ");
INSERT INTO hla_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bu Sameria e mi butu ria tere Iesu me rangatse ren te go kaka gono mam merien. Ba nonei te ka gono mera nen turu huol u lan. ");
INSERT INTO hla_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ba palabir u katun u para i hamanaia tere Iesu ti hengo menien u ranga i tanen. ");
INSERT INTO hla_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ba nori e hateier nonei a tahol, “Alam u tanian hamana u tere Iesu tu hengo meni lam u ranga i tamulö. Kaba alam e hamana koru talam, taraha alam peisa has tu hengoe ien, ba lam te atei sil talem nonei koru a katun te hala sile mei e Sunahan te go lu ba menien u markato u omi turu katun i puta.” ");
INSERT INTO hla_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Te kapaia u huol u lan be Iesu e la ba nena a taun teka ba te la uana i Galili. Nonei noa has te poe mami, “A propet tere Sunahan e ma hapane ria i han i tanen.” ");
INSERT INTO hla_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kaba poata te tuku ien i Galili ba barebana e sasala meren, taraha nori i la hasi u tara kannouna turu Paska turu Jiu i Jerusalem, na nori i ruto hakapi u mirakul hoboto te kate ien tara poata tara kannou. ");
INSERT INTO hla_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Be Iesu e tuku poutsta i Kena, a taun i Galili te palis menien u ramun tara wain. Na toa tson tara gamman e kaia i Kapeneam, na pien tson i tanen e ka mei a nimate pan. ");
INSERT INTO hla_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nonei e hengoen e Iesu e la ba nema i Judia me tukuna i Galili, ba nonei e la uana tere Iesu me tahule nen te ga la uen i Kapeneam ba te na kato haniga poutsena a pien i tanen, taraha nonei e katsin mate. ");
INSERT INTO hla_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Be Iesu e poiena, “Te ma tare mia limiu a mirakul a para i tar, alimiu toum e ma hamana koru moi.” ");
INSERT INTO hla_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ba tson tara gamman e ranga hatatagina me poiena, “A tsi tsunono, la boroboroma. A tsi pien i tar e namos matena.” ");
INSERT INTO hla_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Be Iesu e poieto i tanen, “Kopis pouts talala i han. A pien i tamulö e toatoana ne niga poutsuna.” Ba nonei a tson teka e hamanena u ranga tere Iesu ba te la pouts uana i han i tanen. ");
INSERT INTO hla_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Poata te la noa ien i maroro, bu katunun kui i tanen e hitupali meren me poier, “A pien i tamulö e niga poutsuna.” ");
INSERT INTO hla_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ba nonei e rangata ranen, “Saha poata te hapitan niga pouts ien?” Ba nori e poier, “U lolanga i tanen e kapaia tara pal 1 kilok i nolaha.” ");
INSERT INTO hla_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ba tson e atei sil talena nonei a toa poata talasi te rangaia e Iesu, “A pien i tamulö e toatoana ne niga poutsuna.” Ba nonei a tson na hun barebana hoboto i tanen i hamana uato tere Iesu. ");
INSERT INTO hla_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nonei a hahuoluna a mirakul te kato e Iesu tara provins i Galili i murina te la ba namen i Judia. ");
INSERT INTO hla_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Na i murimuri u Jiu i kato a kannou pan i Jerusalem turu lotu i taren, ne Iesu e la has u i Jerusalem. ");
INSERT INTO hla_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Te kaia a toa kats i Jerusalem ti ngöei Betesda turu Ha-Hibru. A kats teka e kaia i rehina tamana tara ololon hatu pan ti ngöei a Tamana turu Sipsip. Na tolima luman oho i hahisei a kats teka. ");
INSERT INTO hla_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nu katun u para ti ka mei a nimate i opuia turu luman oho teka — a matakiau, na mou korus na matekata. Nori i hahalosi te ga hula la u u ramun. ");
INSERT INTO hla_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Taraha, tara tana poata a toa angelo tara Tsunono e roron kouluma ba te heroko habililena a kats. Ba katun te tasu mamia tara kats i murina te hula la ien e niga pouts. ");
INSERT INTO hla_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na toa katun te kaia teka e solon ka mei a nimate e antunaia turu 38 u hiningal. ");
INSERT INTO hla_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Be Iesu e tarena nonei a katun te opu. Nonei e atei sili a katun teka e solon ka mei a nimate, ba nonei e poiena i tanen, “Alö e ngilin niga poutsum?” ");
INSERT INTO hla_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ba katun e poiena i tanen, “Aa. Kaba e moa ta katun te ga lu menai lia tara kats poata te hula la nen. Te torohanan tasu gia lia, a tana katun e roron tasu mam nano lia.” ");
INSERT INTO hla_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Be Iesu e poiena i tanen, “Alö go takei ba te soatem a poapoa i tamulö ba te lam.” ");
INSERT INTO hla_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Na i teka puku a katun teka e niga pouts. Ba nonei e soatena a poapoa i tanen me lana. A ka teka e butuia turu Lan u Goagono turu Jiu. ");
INSERT INTO hla_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ba pal kapan turu Jiu i poieto tara katun te niga pouts, “I romana u Lan u Goagono. Alö e pekoem a lo turu lotu te soata mena milö a poapoa i tamulö turu lan teka.” ");
INSERT INTO hla_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ba nonei e ranga palis uana i taren, “Kaba a katun te kato hanige namo lia e poe nama i tar, ‘Alö go soata a poapoa i tamulö ba te lam.’” ");
INSERT INTO hla_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ba nori e rangatse ren, “Esi te mar ranga uanama teka?” ");
INSERT INTO hla_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kaba a katun te niga pouts e ma ateii. Nonei e ma atei sil noei e Iesu, taraha a katun a para i gono, be Iesu e toan lato. ");
INSERT INTO hla_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","I murina a tsitabubun poata be Iesu e na sabiena nonei a katun i iahana Luman Lotu Pan ba te poiena i tanen, “A nimate a omi i tamulö e kapa tala. Alö go ma kato homi leli. Te kato homi lel moa lö romana, ba ka te omi koruna e butu toum noa romana i tamulo.” ");
INSERT INTO hla_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ba katun teka e na hatei rena a pal kapan turu Jiu nonei e Iesu te kato haniga poutse men. ");
INSERT INTO hla_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","E kato u teka ba pal kapan e tanian ranga homi siler e Iesu me katsin kato homi hase ren, taraha nonei e kato a mirakul teka turu Lan u Goagono. ");
INSERT INTO hla_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Be Iesu e poieto turu katun teka, “Te kato haniga poutse gia lia a katun ba ka teka te haruto nena e Tamar e kuina. Na lia e kui noa hase gou a toukui teka.” ");
INSERT INTO hla_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ba pal kapan e ngil koru taler te gi kato hamate menien e Iesu, taraha nonei e peko a lo i taren turu Lan u Goagono me ngö hase nei e Sunahan e Tamanen, na tara markato teka nonei e hahinatei menei a peisanen e Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Be Iesu e poieto tara pal kapan turu Jiu, “Alia e hatei hamana rago limiu, alia a Pien tere Tamar ba te ma antunan kato pepeisegi ta ka. Alia e kato lasegu a ka te tare gulia te katoena e Tamar. Nonei e katona ba lia te kato hasigu. ");
INSERT INTO hla_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Taraha, e Tamar e ngil korue nolia, alia a Pien i tanen, na nonei e harute nei lia a mamana ka hoboto te katoe nen. Na nonei e harute noi romana lia a man mirakul te pan bala nena a mirakul teka, ba limiu te asingoto koru mou. ");
INSERT INTO hla_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","E Tamar e hatakei rena u katun tara tou mate i taren me hala rane ien a nitoatoa. Na lia a Pien i tanen e kato has uagou i iesana ba te hala has negou a nitoatoa turu katun turu ngil i tar. ");
INSERT INTO hla_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","E Tamar e ma tsimoue nei ta katun. Nonei e halei moi lia a nitsunono hoboto i tanen te go mi tsimou u lia turu katun. ");
INSERT INTO hla_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nonei e mar kato uana teka ba barebana te tatei hapane rio lia te mar hapan has mena rien e Tamar. A katun te ma hapane nei lia e ma hapan hase nei e Tamar te haleie molia.” ");
INSERT INTO hla_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Be Iesu e poiena, “Alia e hatei hamana rago limiu, a katun te hengoena u ranga i tar na te hamanena e Sunahan te haleie molia, nonei a katun te ka hamanasa mena a nitoatoa te ka nitoana. Nonei e ma la noi turu kot tere Sunahan. E manana, nonei e ka halhal ba mamin a nitoatoa tere Sunahan ne herei a katun a mate. Kaba nonei e la ba nema a tou mate teka ne aroho hakapa u tara nitoatoa tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Alia e hatei hamana rago limiu, i romana na i murimuri has, u katun te ma ka meri a nitoatoa teka e hengoe riou u ranga tara Pien tere Sunahan, ba katun te hengo hanigana e lue nou a nitoatoa teka. ");
INSERT INTO hla_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","E Tamar nonei a mouna a nitoatoa, na nonei e hanigein alia a Pien i tanen te go mouna has u tara nitoatoa. ");
INSERT INTO hla_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ne Tamar e halei moi lia a nitsunono i tanen te go tsimou u lia, taraha alia nonei tu butun katunuma. ");
INSERT INTO hla_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Alimiu go ma asingoto nami a ka teka, taraha a poata te la nama bu mate hoboto te ka ria turu ngahongaho e hengoe riou u ranga i tar, ba nori te takei pouts riou. U katun ti kato haniga e hatakei pouts sil raroi a nitoatoa te ka nitoana, nu katun ti kato homi e hatakei pouts sil raroi te gi lu menien a nihahuna.” ");
INSERT INTO hla_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Be Iesu e ranga noana tara pal kapan turu Jiu me poiena, “Alia e ma katoegi ta ka turu ngil peisa i tar. E moa. Alia e mar tsimou meragi u katun te hatei mena nei lia e Sunahan. Na lia e tsimou hamatskö hasigu, taraha alia e ma katoegi u ngil peisa i tar. E moa. Alia e kato lasegu u ngil tere Sunahan te haleie molia. ");
INSERT INTO hla_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Te hatei pepeisa nagoa lia a peisar, u katun e na poier u ranga i tar e ma mana nei. ");
INSERT INTO hla_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kaba e Tamar e hatei has nano lia tara poata teka, na lia e atei negu u ranga i tanen teka e manana. ");
INSERT INTO hla_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Alimiu u hala riam a pal katun te gi rangata meni e Jon, na nonei e hatei hamana nio lia. ");
INSERT INTO hla_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Alia e ma ngil koruegi a katun tun e go kato hamana meni u ranga i tar. Kaba alia e hatei sil ragi limiu u ranga tere Jon te go hamana mena mien limiu na te go lu pouts meni e Sunahan alimiu. ");
INSERT INTO hla_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","E Jon e hatei hamana rilimiu u ranga, na nonei e herei u lam te kulupu halesalena a maroro. Na limiu u gamon sasala tun meiam u ranga i tanen. ");
INSERT INTO hla_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kaba a ka te pan bala nena e Jon e hatei has nano lia. E Tamar e hanigein te go kui meni lia a man mirakul. Na man mirakul has te katoe gulia e haruto nena e Tamar te haleie molia. ");
INSERT INTO hla_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ne Tamar has te haleie molia, nonei e hatei nena te mana uana u ranga i tar. Alimiu u namala hengoemi a rungnen na limiu u namala tara hasemi a matanen. ");
INSERT INTO hla_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nu ranga tere Sunahan e ma ka neia i torimilimiu, taraha alimiu e ma hamane milia, alia tu lama i tanen. ");
INSERT INTO hla_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Alimiu e roron ruto nitoa namiu u Buk u Goagono, taraha alimiu e poiemiu nonei te hala ranoi romana limiu a nitoatoa te ka nitoana. Na alia nonei a katun te hatei nena u Buk u Goagono. ");
INSERT INTO hla_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kaba alimiu e rama noa namiu te go la uamuma i tar ba te mi luemiu a nitoatoa te ka nitoana. ");
INSERT INTO hla_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Alia e ma tokugi te ma hapan menari a barebana alia. ");
INSERT INTO hla_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Na lia e atei silegu u hakats i tamilimiu, na lia e atei sil hasegu a torimilimiu e ma ngile nei e Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Alia u la mema a nitsunono tere Tamar, na limiu e ma lu mena milia i tamilimiu. Kaba te la menama romana a toa katun a nitsunono peisa i tanen, alimiu e lu mena moien i tamilimiu, noahasina te moa nen ta nitsunono tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Te mar hakats uami limiu teka, alimiu e moa koru te go antunan hamana uam i tar. Taraha, alimiu e ngilemiu a tai e ga hapan rio limiu, kaba alimiu e ma ngilemi e Sunahan a toa puku te ga kato hapan rio limiu. ");
INSERT INTO hla_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Alimiu e namos hakats uamiu alia e kot ragoa limiu i matana e Tamar. E moa. E Moses nonei a katun te kot rano limiu, nonei e Moses te poie mia limiu alimiu e hamanemiu u ranga te koloto nen. ");
INSERT INTO hla_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sanena te hamane milimiu e Moses, alimiu sane tatei hamana hase molia. Taraha, nonei e koloto nia lia turu Buk u Goagono. ");
INSERT INTO hla_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kaba alimiu e ma hamanemi u ranga i tanen. E kato uana teka ba e moa koru te go antunan hamana mena milimiu u ranga i tar.” ");
INSERT INTO hla_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","I murinen be Iesu e la pouts uato i hapalana Ramun a Perperere i Galili, te ngö haseri i Taibirias. ");
INSERT INTO hla_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","U katun u para koru i kukutie ien, taraha nori i tara hakapa a man mirakul te katoe ien turu katun ti ka mei a nimate. ");
INSERT INTO hla_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Be Iesu e gamon la seina tara tsi pokus me gum gono merena u katunun tsitsilo i tanen. ");
INSERT INTO hla_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na kannouna turu Paska turu Jiu e sukusuku. ");
INSERT INTO hla_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Be Iesu e hula tarana me tara sabiena a pal barebana u para koru ti la uama i tanen, ba nonei e poiena tere Pilip, “Ime te hole roa ra ta beret te gi hanouri u barebana hoboto teka?” ");
INSERT INTO hla_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nonei e mar ranga u teka te ga torohana menien e Pilip. Nonei e atei sil mami a ka te ga kate ien. ");
INSERT INTO hla_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Be Pilip e ranga palise nen me poiena, “Te gi holeia ra a beret te antunana turu 200 denarius moni ba te ma antuna has nei turu barebana te gi lu menien a ma tsitabubu.” ");
INSERT INTO hla_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Na toa katunun tsitsilo i tanen e Endru e toulane Saimon Pita e poei i tanen, “A toa pien tson e kana teka te ka mena a tolima bali beret na huol a iena. Kaba e ma antuna nei turu pal barebana u para koru teka.” ");
INSERT INTO hla_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Be Iesu e poiena, “Hagum raiam u barebana.” U garas u para te kana tara makum teka. Bu barebana e gumur, a pal tson na tohaliou has. Na hihase tara pal tson e antunaia tara 5000. ");
INSERT INTO hla_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Be Iesu e luena u beret me haniga uana tere Sunahan me molamola rane ien u barebana ti gum. Te kato has uen turu iena. E hala has menien i taren, me antunana turu ngil i taren. ");
INSERT INTO hla_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ba nori e nou hantuna hakapar, ba nonei e ranga merena u katunun tsitsilo i tanen me poiena, “Alimiu go gone iam u nouba te ka noana. E moa te gi kato baba menien.” ");
INSERT INTO hla_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ba nori e gone ier u nouba me ongo hasaputer a 12 a kalobaka te saputsi a ma tsi makumun bali beret ti nou ba nen. ");
INSERT INTO hla_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ba barebana e tarer a mirakul teka te kate ien ba nori e poier, “U mana koru, nonei teka a propet te ga la uama tara han i puta.” ");
INSERT INTO hla_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","E Iesu e atei sil nori e mi katsin pile kap naren ba te katoe rien a king i taren, ba nonei a toa pepeisa e la lel uana i gusuna a ma tsi pokus. ");
INSERT INTO hla_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Te butuia a lahilahi, bu katunun tsitsilo tere Iesu e gala uar tara Ramun Perperere i Galili. ");
INSERT INTO hla_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nori i tuku hakapaia i kotolana me osa ria tara tsi tolala te gi la uen i hapalana ramun tara taun i Kapeneam. Ba ke bong talana be Iesu te tia noa nama. Ba nori e la talar. ");
INSERT INTO hla_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ba lomolomo e takei talana bu ramun e posana. ");
INSERT INTO hla_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ba nori e sua hantuna ria tara tolima kilomita tsi a tönomo ba nori e tarer e Iesu te tatalama i ieluna a ramun ba te la uanama tara tolala. Nori i ma marei ien ba nori e matoutur. ");
INSERT INTO hla_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ba nonei e poiena i taren, “Alia ba! Alimiu go ma matoutmi.” ");
INSERT INTO hla_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Poata ti hengo marei ien a runguna e Iesu ba nori e sasala talar me hose rien i iahana tolala. Ba i teka puku ba tolala e na butuna tara han ti ngilin la uen. ");
INSERT INTO hla_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Bu hamahö ba barebana te la ba rema e Iesu te ka noa has ria i hapalana ramun. Ba nori e poier, “Ara i tarei a tsi toa puku a tsi tolala te ka i nolaha, ne Iesu e ma osai i tanen. U katunun tsitsilo i tanen toum i sua pepeisa ba nela a han teka.” ");
INSERT INTO hla_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kaba palaina ma tsi tolalana i Taibirias i ka hasia i rehina makum te hanigeia a Tsunono a tsi kannou ba nori te toan nouer a beret. ");
INSERT INTO hla_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ba poata ti atei sileia a barebana e Iesu nu katunun tsitsilo i tanen i ma ka talai, ba nori e toan osa ria tara ma tsi tolala teka me sakie rima e Iesu i Kapeneam. ");
INSERT INTO hla_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","A barebana i aroho hakapama tara ramun me mi sabier e Iesu. Ba nori e poier i tanen, “Tson Hihatuts, i hangisa tu tukuia lö i han teka?” ");
INSERT INTO hla_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Be Iesu e poieto i taren, “Alia e hatei hamana koru rago limiu, alimiu e ma sake sil memu mei lia tu tara mena mei limiu a man mirakul i tar. E moa. Alimiu e sake sil memu mei lia tu hanou hamasul mera mei lia alimiu. ");
INSERT INTO hla_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Alimiu go ma kui sil lasemi a ka te tatei putakana. E moa. Alimiu go kui sile iam a ka te niga nitoana, a ka te hala nena a nitoatoa te ka nitoana. Alia tu butun katunuma e hala ragoi limiu a ka teka, taraha e Tamar e Sunahan e hanige nolia.” ");
INSERT INTO hla_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ba nori e poier i tanen, “Ime te mar kato mena moi lam nonei a mar toukui teka te ngilena e Sunahan?” ");
INSERT INTO hla_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Be Iesu e ranga palis uana i taren me poiena, “Nonei a toukui teka te ngilena e Sunahan te go kate iam limiu: alimiu go hamana uam i tar, taraha e Sunahan te haleie mou lia.” ");
INSERT INTO hla_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ba nori e poier i tanen, “Saha mirakul te katoe mou lö te haruto nanou te go hamana u lam i tamulö? Alö go haruto rilam a toukui pan i tamulö. ");
INSERT INTO hla_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","U tuburara i noui a ka ti ngöei u mena,* tara poata ti ka ien tara latu pinopino te moaia ta kannou. U Buk u Goagono e poe hasena, ‘Nonei e hala rien a kannou te lama i Kolö.’” ");
INSERT INTO hla_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Be Iesu e poiena i taren, “U mana koru alia e hatei rago limiu, e Moses e ma halani a kannou te lama i Kolö turu tubumilimiu. E moa. E Tamar te hala nen. Na nonei e ngilin hala has rana mei limiu a tana kannou a niga i Kolö. ");
INSERT INTO hla_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nonei a kannou a niga teka tere Sunahan e lama i Kolö ne hala nena a nitoatoa tara barebana i puta.” ");
INSERT INTO hla_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ba nori e poier, “A tsi tsunono, alö go hala nitoa ramei lam a kannou teka.” ");
INSERT INTO hla_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Be Iesu e poiena i taren, “Alia nonei a kannou te hala nena a nitoatoa. A katun te la uanama i tar ba te hamana uana i tar e sasala nitoa menou a nitoatoa te ka nitoana. E kato uana tara katun te mamala bes nei ne mamala maka has nei.” ");
INSERT INTO hla_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Be Iesu e ranga noana me poiena, “E kato uana tu hatei meri lia alimiu, alimiu u tara hakape molia, kaba limiu e ma hamanami. ");
INSERT INTO hla_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","U katun hoboto te hala mera namei romana e Tamar i tar e la uarima romana i tar. Ne moa koru te go hakopis ba meni lia ta katun te ga la uama i tar. E moa. ");
INSERT INTO hla_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Alia u ma la sile mei i Kolö te go mi kato meni u ngil peisa i tar. E moa. Alia u la silema te go mi kato meni lia u ngil tere Sunahan te haleie molia. ");
INSERT INTO hla_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na nonei a ka teka te ngilena e Sunahan: nonei e ngilena te go ma taia u ta toa ta katun te hale meien lia. Na nonei e ngil hasena te go hatakei pouts merien romana lia tara tou mate tara kapakapana poata. ");
INSERT INTO hla_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ne Tamar e ngil hasena u katun hoboto te tare rio lia na te hamana uar i tar, nori gi ka meiou a nitoatoa te ka nitoana. Na lia e hatakei pouts ragoen romana tara tou mate tara kapakapana poata.” ");
INSERT INTO hla_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ba pal kapan turu Jiu e hihirangatsi ner e Iesu te poe menien, “Alia a kannou tu lama i Kolö.” ");
INSERT INTO hla_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ba nori e poier, “Nonei banei lasi e Iesu a pien tere Josep. Ara e atei silera e tamanen ne tsinanen. Ime te kato halona uanen ba nonei te poiena, ‘Alia u lama i Kolö’?” ");
INSERT INTO hla_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Be Iesu e poieto i taren, “Hapolase iam u ranga. ");
INSERT INTO hla_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","A katun e ma antunan la peisa uana mei i tar te ma las mena name ien e Tamar. E moa. Kaba katun te la uanama i tar, alia e hatakei poutse goen romana tara tou mate tara kapakapana poata. ");
INSERT INTO hla_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","A propet tere Sunahan e koloto nia turu Buk u Goagono i manasa me poiena, ‘E Sunahan e hatuts ranoen romana, nori hoboto.’ Nu katun hoboto te hengo hanige ier u hihatuts tere Tamar e la uarima romana i tar. ");
INSERT INTO hla_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","E moa ta toa ta katun te antunan tara nena e Tamar. E moa. Alia pepeisa tu tarema e Tamar e Sunahan, taraha alia u lama i tanen.” ");
INSERT INTO hla_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Be Iesu e ranga noana me poiena, “U mana koru alia e hatei rago limiu, a katun te hamanana e ka menou a nitoatoa te ka nitoana. ");
INSERT INTO hla_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Alia a kannou te hala nena a nitoatoa. ");
INSERT INTO hla_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","U tubumilimiu i noui a ka ti ngöei u mena tara latu pinopino te moaia ta kannou. Kaba nori i ma toatoa nitoai. Nori i mate noa has. ");
INSERT INTO hla_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Alia e ranga negu a kannou te lama i Kolö, na katun te noue nen e ma mate noi. ");
INSERT INTO hla_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Alia nonei a kannou te hala nena a nitoatoa na te lama i Kolö. Te hamana uana a katun i tar, nonei e toatoa nitoa nou. Na kannou te hala negu lia ba te hala nena a nitoatoa tara barebana i puta, nonei a tuanreir.” ");
INSERT INTO hla_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bu pal kapan turu Jiu e toan hiararangar me poier, “Ime te kato halona uanou a katun teka ba te hala ranoi ra a tuanreinen ba ra te noue ren?” ");
INSERT INTO hla_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Be Iesu e ranga palis ranen me poiena, “Te ma nou nei a katun na te ma ua has neien, nonei e ma antunan toatoa nei. Na lia e hatei hamana koru rago limiu, e kato has uana i iesana tara katun te hahamanana i tar. Alimiu go lu mena milia i torimilimiu, alia tu butun katunuma. Te moa nen, ba limiu te ma antunan ka memi a nitoatoa te ka nitoana. ");
INSERT INTO hla_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","A katun te nouena a tuanreir na te ue iena u rahatsing i tar e ka menou a nitoatoa te ka nitoana. Na lia e hatakei poutse goen romana tara tou mate tara kapakapana poata. ");
INSERT INTO hla_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Taraha, a tuanreir nonei a kannou hamana nu rahatsing i tar nonei u ramunun ua hamana. ");
INSERT INTO hla_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","A katun te nouena a tuanreir na te ue iena u rahatsing i tar e ka nitoana i tar, na lia e ka nitoa has gia i tanen. ");
INSERT INTO hla_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","E Tamar te toatoa nitoana e haleie molia. Na lia e toatoa nitoa has megu e Tamar e halei lia a nitoatoa teka. Ne kato has uana i iesana tara katun te noue nolia. Nonei has te toatoa nitoa nou, taraha alia e hale gien a nitoatoa teka. ");
INSERT INTO hla_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nonei a kannou teka te ranga nagu lalia te lama i Kolö. E ma kato uanei nonei tara kannou ti nou u tubumilimiu kaba i mate noa has. E moa. A katun te nouena a kannou teka e toatoa nitoa nou.” ");
INSERT INTO hla_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","E Iesu e kateia u ranga teka te hihatuts ien i iahana luman lotu tara taun i Kapeneam. ");
INSERT INTO hla_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","A katun a para tere Iesu i hengo u ranga teka me poier, “U ranga teka e kato hatutu koru rano ra. Ara e ma tatei hengoe reien!” ");
INSERT INTO hla_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","E Iesu e atei sil peiseir u katun ti lala gono meien i hihirangatsin u ranga te katoe ien, ba nonei e poiena, “Alimiu e raman hengoemiu u ranga teka? ");
INSERT INTO hla_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Na limiu e mar hakats uamou ime te tara mena moi limiu alia te la pouts uagou lia i Kolö tu lama lia, alia tu butun katunuma? ");
INSERT INTO hla_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","U Namnamei i tar te hala nena a nitoatoa teka. A tuanreir e moa. U ranga te hatei ragu lei lia alimiu nonei u rangana turu namnamei, na nonei te hala ranei limiu a nitoatoa. ");
INSERT INTO hla_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kaba palair u katun i gusumilimiu e hahamana noar.” E Iesu e mar ranga u teka, taraha nonei e atei mamir u katun ti hahamana nen, na nonei e atei mam hasin esi nonei a katun te ga haruto nen turu katun ti korupakö nen. ");
INSERT INTO hla_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ba nonei e poiena, “Nonei te hatei bera gulei lia alimiu e moa ta katun te go la uama i tar te ga ma haniga uai e Tamar.” ");
INSERT INTO hla_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","E kato uana teka bu katun u para ti lala gono meien e toan la ba neren, na nori i ma hula la gono lel meien. ");
INSERT INTO hla_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Be Iesu e rangata rena a 12 a katunun tsitsilo i tanen me poiena, “Ga limiu has te la ba nemo lia?” ");
INSERT INTO hla_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Be Saimon Pita e ranga palise ten me poiena, “Alam go la u teresi? E moa tala. Taraha, alö peisa te ka mem u rangana tara nitoatoa te ka nitoana. ");
INSERT INTO hla_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Na lam e hamanem u ranga i tamulö, na lam e atei sil hasem alö a Pien a Goagono tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Be Iesu e poiena i taren, “Alia tu hopu kap rio limiu a 12 a katun. Kaba toa i tamilimiu noa has e katun uana tere Satan.” ");
INSERT INTO hla_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nonei e rangein e Judas a pien tere Saimon Iskeriot. E manana, nonei a toa tara 12 a katunun tsitsilo tere Iesu, kaba nonei te na harutoen e Iesu turu katun ti korupakö nen. ");
INSERT INTO hla_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ba i murimuri e Iesu e hula laia i iahana provins i Galili. Nonei e raman hula la lelia i iahana provins i Judia, taraha a pal kapan turu Jiu i Judia i ngilin kato hamate nen. ");
INSERT INTO hla_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A poata tara kannou pan e sukusuku tala, a ka ti ngöei a Kannouna turu Taluhu. ");
INSERT INTO hla_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Bu toulane Iesu e hahakos ria i tanen me poier, “Alö go la ban a han teka ba te la uam i Judia ba barebana i tamulö te tatei tarer a man mirakul i tamulö. ");
INSERT INTO hla_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","A katun e ma tatei kui hamous nei te ngile nen a barebana e gi atei silen. Te antunan kui hamana namia lö a man mirakul, ba lö te katoe men i matar a barebana hoboto!” ");
INSERT INTO hla_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","U toulane Iesu i ranga u teka, taraha nori i ma hamana has uai i tanen. ");
INSERT INTO hla_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Be Iesu e poiena i taren, “A poatan la i tar e tabuna butu noana. Kaba mamana poata a man poata i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","A barebanar i puta e ma tatei omi rari limiu, kaba nori e omie rio lia, taraha alia e hatei ragien te omi uana a markato i taren. ");
INSERT INTO hla_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Alimiu go la uamula tara kannou. Alia e ma la noa bugoi tara kannou, taraha a poata i tar e tabuna butu noana.” ");
INSERT INTO hla_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nonei e ranga u teka ba te gamon ka lelina i Galili. ");
INSERT INTO hla_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ba i murina ti la hakapaia u toulanen tara kannou, be Iesu e la hasina. Kaba nonei e ma lai i matar a barebana. E moa. Nonei e la hamous. ");
INSERT INTO hla_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na pal kapan turu Jiu i sakie ien tara kannou me poier, “Ime nonei e Iesu?” ");
INSERT INTO hla_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ba barebana i hahasi hapara naten. Palai i taren i poei, “Nonei a katun a niga,” ba palabi te poier, “E moa. Nonei e gamo rena a barebana.” ");
INSERT INTO hla_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kaba e moa ta katun te ga ongolo ba te ranga haniga nena e Iesu i matar a barebana, taraha u katun hoboto i matoutir a pal kapan turu Jiu. ");
INSERT INTO hla_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","I gusuna poata tara kannou be Iesu e la uana tara Luman Lotu Pan ba te tanian hatuts rena u katun. ");
INSERT INTO hla_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ba pal kapan turu Jiu e asingoto koru ner u ranga i tanen me poier, “Ime te hahatongo haniga halona menien u Buk u Goagono? Nonei e mamala la noai turu skul i tarara.” ");
INSERT INTO hla_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Be Iesu e poieto i taren, “U hihatuts teka e ma ka uanei i tar. E moa. E la nama tere Sunahan, nonei te haleie molia. ");
INSERT INTO hla_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","A katun te ngilin katoena u ngil tere Sunahan e atei sil peise nou u hihatuts teka, te ga la men tere Sunahan tsi te ga la men i tar pepeisa. ");
INSERT INTO hla_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","A katun te habutena u ranga pepeisa i tanen e ngilin hapan nena a peisanen. Kaba a katun te ngilin hapan nena a katun te haleie men e ranga hamanana ne ma gamo nei. ");
INSERT INTO hla_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","E Moses e hala rilimiu u Lo tere Sunahan. Kaba e moa ta toa i tamilimiu te ga kukutei u Lo teka. Gaha te katsin atung hamate sile milimiu alia?” ");
INSERT INTO hla_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ba barebana e ranga palise ren me poier, “Alö e momolö korum! E moa ta katun te ga ngilin atung hamate nio lö!” ");
INSERT INTO hla_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Be Iesu e poiena, “Alia u kato a toa mirakul ba limiu te ma hanigami, taraha alia u kato ien turu Lan u Goagono. ");
INSERT INTO hla_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kaba te butuna a hatoalina u lan tara pien tson ba limiu te pö has nemiu a hatoatongo tere Sunahan i pikpikönen, taraha u Lo tere Moses e ranga nena a katun e ga kato a ka teka, noahasina te ga butu ien turu Lan u Goagono. (Kaba a markato teka e butuia turu tubumilimiu i mam tere Moses.) ");
INSERT INTO hla_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Te ga butuia a poatan hipö teka turu Lan u Goagono, ba limiu te kato noa hase men, taraha alimiu e raman peko nemiu u Lo tere Moses. E kato uana teka, ba limiu te ma tatei raharahe milia tu kato haniga pouts menai lia a tuanreina katun turu Lan u Goagono! ");
INSERT INTO hla_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Alimiu go ma tara papalami ba te one iemiu a tana katun. E moa. Alimiu go atei haniga mam niam aha te kato sile nen, ba limiu te toan ranga hamanamiu.” ");
INSERT INTO hla_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ba palair u katun i Jerusalem i ranga neto e Iesu me poier, “Nonei a katun teka te ngilin atung hamate ner, boka? ");
INSERT INTO hla_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kaba nonei e ka noa hasina teka ba te rangana i matar a barebana, na pal kapan e ma ranga hapiu narien! A pal kapan toum i sabe hakapa nonei hamana e Mesaia, a katun te hopu kapin e Sunahan? ");
INSERT INTO hla_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kaba poata te butu nama romana e Mesaia, ba barebana e ma atei sile roi ime te la namen romana, Kaba ara e atei silera ime te butuma a katun teka.” ");
INSERT INTO hla_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","Be Iesu e hatuts noa rena a barebana tara Luman Lotu Pan ba te ranga hapanna me poiena, “Alimiu e poiemiu alimiu e atei sile molia na han tu butu malia? Alia u ma la memei u ngil peisa i tar. E Tamar te haleie molia te manana. Alimiu e ma atei sile mien, kaba alia e atei sile gen. Taraha, nonei te haleie molia ba lia te la guma.” ");
INSERT INTO hla_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ba nori e pats pile kap naren, kaba e moa, taraha a poata i tanen e ma butu noai. ");
INSERT INTO hla_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nu katun u para i hamana u tere Iesu ba nori e poier, “Te la nama romana e Mesaia, ba nonei te katoe nou tu mirakul tu para te kato uana a katun teka e Iesu. Ba ra te toan poe tale rou nonei e Mesaia.” ");
INSERT INTO hla_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bu Parisi i hengo reto u katun teka ti hahasin e Iesu, ba nori u Parisi nu tsunono pan turu lotu e hala rerima a palair u polis i taren te gi mi pile kap menien. ");
INSERT INTO hla_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Be Iesu e poiena tara barebana, “Alia e gamon ka gono lel mera golimiu tara tsitabubun poata, ba lia te toan la pouts uagou tara han tu la malia. ");
INSERT INTO hla_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kaba limiu e lagi sakesakiemiu romana lia na limiu e ma sabe hase moi lia. Taraha, alimiu e ma antunan la uami tara han te na ka goa lia.” ");
INSERT INTO hla_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ba pal kapan turu Jiu e hiarangarangatar me poier, “Ime te katsin la uana a katun teka ba ra te ma tatei sabie roien? Toum nonei e katsin la uana turu Jiu te ka kalakala ria turu han i lehana ba te na hatuts toum ranoen nu katun has te halhal ria turu Jiu. ");
INSERT INTO hla_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Na nonei e poe hase lala, ‘Alimiu e lagi sakesakiemiu romana lia na limiu e ma sabe hase moi lia. Taraha, alimiu e ma antunan la uami tara han te na ka goa lia.’ Ime te mouna uana u ranga teka?” ");
INSERT INTO hla_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","U lan te kapaia a kannou nonei u lan pan. Be Iesu e tuoluna turu lan teka ba te ranga hapan uana tara barebana me poiena, “Esi te makana e tatei la uanama i tar ba te mi uana. ");
INSERT INTO hla_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Taraha, u Buk u Goagono e poiena a katun te hamanana i tar e here noi a ramun te olona, ba nonei te hala nena a nitoatoa turu katun.” ");
INSERT INTO hla_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","E Iesu e rangein u Namnamei tere Sunahan te ga halan e Sunahan turu katun ti hamanaia tere Iesu. Kaba e Sunahan e ma hala noa namei u Namnamei i tanen, taraha nonei e ma kato hapan pouts noei e Iesu i Kolö. ");
INSERT INTO hla_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Poata ti hengoeia a barebana u ranga teka ba palai e poier, “Nonei e Iesu a propet te ga lama.” ");
INSERT INTO hla_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ba palabi e poier, “Nonei e Mesaia.” Kaba palabi te poier, “E Mesaia e go ma tatei la mei i Galili. E moa. ");
INSERT INTO hla_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","U Buk u Goagono e poiena e Mesaia e ga tuhanaia tara pala tere Devit. Nonei gi poseia i Betelehem, a taun te kaia e Devit.” ");
INSERT INTO hla_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ba barebana e hula hakats ner e Iesu. ");
INSERT INTO hla_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ba palabi e ngilin pile kap naren, kaba e moa ta toa te ga luen. ");
INSERT INTO hla_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bu polis e la pouts talar, bu pris pan nu Parisi i rangata raten me poier, “Aha te ma lu memu mei limiu e Iesu?” ");
INSERT INTO hla_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bu polis e poier, “E moa ta katun te ga ranga u te mar ranga uana a katun teka.” ");
INSERT INTO hla_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bu Parisi i poieto, “Nonei e gamo has rana molimiu? ");
INSERT INTO hla_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ta toa tara pal kapan tsi ta toa turu Parisi e hamana uar i tanen? E moa. ");
INSERT INTO hla_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nori u katun papala te hamanar, kaba nori e tutu ba ner u Lo tere Moses. Ne Sunahan e hahuna ranoen romana.” ");
INSERT INTO hla_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","E Nikodimas nonei has a Parisi. Nonei te la u tere Iesu tara toa bong. Ba nonei e poiena i taren, “U Lo i tarara e poiena ara gi ma tatei hala pinopino nai a nihahuna tara katun. E moa. Ara gi hengo mam u i tanen ba ra te sabiera a ka a omi te katoe ien.” ");
INSERT INTO hla_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ba nori e hohou rangatse ren, “Alö esi? Alö a toun Galili has? Alö go tsilo hanigei u Buk u Goagono ba lö te tara peise mou e moa ta propet te ga butuma i Galili.” ");
INSERT INTO hla_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","U barebana i tarura tala me la poutsur i han i taren. Kaba e Iesu e la u turu Pokus tara Roein Olip. ");
INSERT INTO hla_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tara bongbong koru ba nonei e la pouts uana tara Luman Lotu Pan. Ba barebana e gono hoboto ria i tanen, ba nonei e gumuna me tanian hihatuts uana i taren. ");
INSERT INTO hla_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","Nu tson hihatuts turu Lo nu Parisi i piou nema a toa tahol ti sabie men te haloku. Ba nori e hake rien i matar a barebana me poier tere Iesu, “O Tson Hihatuts, u katun e sabie rima a tahol teka ba te halokuna. ");
INSERT INTO hla_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","U Lo tere Moses e poiena ara gi titi hatu hamate a mar katun teka. Na ha te poie mulö?” ");
INSERT INTO hla_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nori i mar ranga u teka ba te torohana tun neren, taraha nori i kato sili ta ka te gi mar kot meien e Iesu. Be Iesu e turu putana me koloto nena a kabelenen turu tsikitsiki. ");
INSERT INTO hla_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nori i katokato sili te ga ranga palis uen ba nonei e tuol sei poutsuna me poiena i taren, “Bara. A katun i gusulimiu te mamala kato homii e tatei ti hatu mamena a tahol teka.” ");
INSERT INTO hla_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Be Iesu e turu puta lelina me koloto lel nena a kabelenen turu tsikitsiki. ");
INSERT INTO hla_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Poata ti hengoe ien u ranga teka ba nori e la hihieser, u katun pan ti mam bu katun papala te murimurir. Be Iesu peisa te ka, na nonei a tahol has te tuolia i matanen. ");
INSERT INTO hla_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Be Iesu e tuol sei poutsuna me poiena tara tahol, “Nori i la hakapa. E moa ta katun te katsin hahune nolö, tsime?” ");
INSERT INTO hla_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ba tahol e poieto, “E moa tala, a tsi tsunono.” Be Iesu e poiena, “Na lia has e ma tatei hahune gilö. La talala, ba lö te ma kato homi lelmi.” ");
INSERT INTO hla_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","E Iesu e ranga lel u tara barebana tara tana poata me poiena, “Alia e heregi u ualesala te alesala uana tara barebana i puta. Na katun te kukutie nolia a bakunen e ma kuhil lel noi. Ba lia te kalatse gou a bakunen ba nonei te ka menou a nitoatoa hamana.” ");
INSERT INTO hla_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bu Parisi i poieto i tanen, “Alö e hatei pepeisa nem a peisamulö. U ranga i tamulö e ma mana nei.” ");
INSERT INTO hla_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Be Iesu e poiena i taren, “E manana, alia e hatei negu a peisar. Kaba u ranga i tar e mana noa hasina. Taraha, alia e atei silegu ime tu la malia na ime te la has uagou lia. Kaba alimiu e ma atei silemi ime tu la malia na ime te la has uagou lia. ");
INSERT INTO hla_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Alimiu e tara papala lasmiu ba te one iemiu a tana katun. Kaba alia e ma one iegi a tana katun. ");
INSERT INTO hla_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kaba te one iegia lia a tana katun, bu ranga i tar te manana. Taraha, alia e ma kato pepeisegi a ka teka. E moa. E Tamagulia te haleie molia nonei e kui gono has meno lia. ");
INSERT INTO hla_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","A toa turu Lo i tamilimiu e poiena te hiahanhaniga ria a elasolana katun, bu ranga i taren te manana. ");
INSERT INTO hla_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na lia e hatei negu a peisagulia ne Tamar e hatei has nano lia. Nonei te haleie molia.” ");
INSERT INTO hla_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ba nori i poieto i tanen, “Ime te kana e Tamamulö?” Be Iesu e poiena, “Alimiu e ma atei sile milia na limiu e ma atei sil hasemi e Tamagulia. Sanena te go atei sile mia limiu alia, alimiu sane atei sil hasemiu e Tamagulia.” ");
INSERT INTO hla_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","E Iesu e mar hihatuts u teka tara Luman Lotu Pan i rehina makum turu bokisin moni. Na e moa ta katun te ga pile kap nen, taraha a poata i tanen e ka noa. ");
INSERT INTO hla_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Be Iesu e poe leleto i taren, “Alia e la ba negou romana a han teka ba limiu te na sakie molia. Kaba alimiu e mate gono memou romana u markato u omi i tamilimiu. Na limiu e ma antunan la has uami tara han te la uagou lia.” ");
INSERT INTO hla_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ba pal kapan turu Jiu i poieto, “Nonei e katsin kato hamatie nou a peisanen? Taraha, nonei e poe lala, ‘Alimiu e ma antunan la uami tara han te la uagou lia.’” ");
INSERT INTO hla_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Be Iesu e poiena i taren, “Alimiu u butu mia tara han i puta teka, kaba alia u lama i iasa. Alimiu u katunur i puta, kaba alia e ma katun uagi i puta. ");
INSERT INTO hla_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nonei te hatei bera gulei lia limiu, alimiu e mate gono memou romana u markato u omi i tamilimiu. Ne manana, alimiu e mate hamana gono memou u markato u omi i tamilimiu te ma hamane moi limiu alia nonei a katun te antunan lu ba negu u markato u omi i tamilimiu.” ");
INSERT INTO hla_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ba nori e poier i tanen, “Alö esi?” Be Iesu e soso koru tala mena u harangata u para i taren ba te poiena, “I mam noa ba te noana i romana, alia u hatei rilimiu alia esi. ");
INSERT INTO hla_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Alia e tatei hate negu a markato a para i tamilimiu, na lia e tatei haruto has ragi limiu a mamana ka a omi te katoe milimiu. Kaba a mamana ka te hatei negu lia tara barebana i puta nonei a man ka tu hengoe malia nonei tara katun te haleie molia, na nonei e ranga hamanana.” ");
INSERT INTO hla_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","A pal kapan turu Jiu i ma atei silei e Iesu e rangein e Tamanen e Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","E kato uana teka be Iesu te poiena, “Poata te tapala namoa limiu alia tara koruse, alia tu butun katunuma, ba limiu te toan atei sile mou alia esi. Ba limiu te atei sil hase mou alia e ma ranga peisa megi a nitsunono i tar. E moa. Alia e ranga las megu u ranga te hatutse mei e Tamar alia. ");
INSERT INTO hla_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ne Tamar e ka gono has meno lia. Nonei e ma la ba nei lia, taraha alia e roron katoegu a mamana ka te mangane nen.” ");
INSERT INTO hla_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","E Iesu e kato u ranga teka bu katun u para te hamana uar i tanen. ");
INSERT INTO hla_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Be Iesu e poieto turu Jiu ti katsin hamanaia i tanen, “Te go kukute hiton nemia limiu u hihatuts i tar, ba limiu te katunun tsitsilo hamana uamiu i tar. ");
INSERT INTO hla_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ba limiu te toan atei sile mou u mana, nu mana e purese rano limiu, te kato uana tara katunun kukui puku te hapurese ba ner tara katun pan a omi i tanen.” ");
INSERT INTO hla_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ba nori i poieto i tanen, “Alam u tuhanaia tere Abraham. Na alam u namala katunun kuikui pukui ta katun. Gime te mouna uana u ranga i tamulö to poiena, ‘Alimiu e hapurese rariou’?” ");
INSERT INTO hla_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Be Iesu e poieto i taren, “U mana koru alia e hatei rago limiu, a katun te kato homi hitonina e kato uana tara katun a karabus. A markato a omi e katoe nen ba nonei te kato homina. ");
INSERT INTO hla_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Alimiu e heremi u karabus te kui beier a katun pan. A karabus e ma pala uanei tara katun te hakuie nen, kaba a pien tara katunun hakui te pala nitoa uana tara hun katun i tanen. ");
INSERT INTO hla_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Alia a pien tere Tamar e Sunahan. Te hapurese ragoa lia alimiu, ba limiu te toan tapurese hamana mou. ");
INSERT INTO hla_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Alia e atei silegu alimiu u tuhanaia tere Abraham. Kaba alimiu e ngilin atung hamate noa hase molia, taraha u ranga i tar e ma ongo neia i torimilimiu. ");
INSERT INTO hla_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Alia e hatei negu a man ka tu tare malia tara poata tu kaia lia tere Tamar. Na limiu e hengo hasemiu u ranga tere tamamilimiu.” ");
INSERT INTO hla_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ba nori e poier i tanen, “E Abraham e tamamulam, nonei e tubumulam.” Be Iesu e poieto i taren, “Te go tuhana hamana mia limiu tere Abraham, gaha tsiponi te ma kato haniga nami limiu te mar kato uaien? ");
INSERT INTO hla_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Alimiu e katsin atung hamatie molia. E Abraham e ma kato uai teka. Na lia e hatei ragu lei limiu u ranga hamana tu hengo mame malia tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Alimiu e kato has uamiu te kato u e tamamilimiu.” Ba nori i poieto i tanen, “Alam e ma binauimi. Alam e ka mem a toa tamamulam, nonei e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Be Iesu e poieto i taren, “Sanena te go hatamana uamia limiu tere Sunahan, alimiu sane ngile molia, taraha alia u la hamatsköma tere Sunahan. Alia u ma la memei u ngil peisa i tar. E moa. Nonei te haleie molia. ");
INSERT INTO hla_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Aha tsiponi te ma atei memi limiu a ka te hatei ragi lia alimiu? Alia e ateigu. Alimiu e rama koru nemiu te go hengo menami u ranga i tar. ");
INSERT INTO hla_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","E Satan nonei e tamamilimiu. Na limiu e ngilin katoemiu a ka te ngile nen. Nonei a katunun hihipuli i mam koru noa, na nonei e rama koru nena u ranga u mana, taraha e moa ta ka ta mana i tanen. Na poata te gamo nen, nonei e kukutiena a markato noa has i tanen, taraha nonei u mouna u mamanu gamo hoboto. ");
INSERT INTO hla_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ba poata te ranga hamana gia lia, alimiu e ma hamane milia. ");
INSERT INTO hla_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","A toa i tamilimiu e antunan haruto nena ta toa ta ka ta omi tu kato lia? E moa! Gaha te ma hamana sile milimiu alia te ranga hamana uagu lia? ");
INSERT INTO hla_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","A katun te pien uana tere Sunahan e hengoena u ranga tere Sunahan. Na limiu e ma hengoemi u ranga tere Sunahan, taraha alimiu e ma pien uami i tanen.” ");
INSERT INTO hla_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bu Jiu e poier i tanen, “Aa, alam u ranga hamatskö u tu poe meni lam alö a toun Sameria, na lö a sesein mate!” ");
INSERT INTO hla_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Be Iesu e poieto, “Alia e ma sesein mategi. E moa. Alia e hapanegu e Tamar e Sunahan, na limiu e pita-pute molia. ");
INSERT INTO hla_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Alia e ma katokato silegi te go hapan menai lia a peisar. E moa. Kaba e Sunahan te hapane nolia, ba nonei te haruto nanou esi te nigana na esi te omina. ");
INSERT INTO hla_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","U mana koru alia e hatei rago limiu, a katun te kukutiena u hihatuts i tar e ma mate koru noi romana!” ");
INSERT INTO hla_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bu Jiu e poier i tanen, “Pua! Alam e atei talam te haranga mena nei lö a mate! E Abraham e mate hakapa, nu propet has tere Sunahan. Kaba lö e poe noa hasem, ‘A katun te kukutiena u hihatuts i tar e ma mate koru noi romana.’ ");
INSERT INTO hla_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Alö e ma pan nami e tubumulam e Abraham. Nonei e mate hakapa, nu propet has. Alö e kato here nami a peisamulö esi?” ");
INSERT INTO hla_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Be Iesu e ranga palis uana i taren me poiena, “Sanena te go hapan meni lia a peisar, alia sane mastei katoe gen. E Tamagulia nonei te hapane nolia, na nonei has te ngöe milimiu a Sunahan i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Alimiu e ma atei silemi e Sunahan, kaba alia te atei sile gen. Sanena te go poe meni lia, ‘Alia e ma atei sile gien,’ sane alia a katun a gamogamo te heregi alimiu. Kaba alia e atei sile gen na lia e kukute hasegu u ranga i tanen. ");
INSERT INTO hla_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","E tubumilimiu e Abraham e hamana sil mami te go la uama lia tara han i puta. E here nei nonei e tara hakapi a ka teka, ba nonei te sasala koru menen.” ");
INSERT INTO hla_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bu Jiu e poier tere Iesu, “E Abraham e mate hakapa i iomin noa, na lö e ma antuna noemi u 50 u hiningal i tamulö. E kato halona uana ime ba lö u tare ten?” ");
INSERT INTO hla_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Be Iesu e poiena i taren, “U mana koru alia e hatei hamana rago limiu, alia u ka hakapaia i mam ti poseia e Abraham.” ");
INSERT INTO hla_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Poata ti hengoe ien u ranga teka ba nori e luier u hatu me katsin tieri e Iesu. Kaba e Iesu e la hamous ba raien tara Luman Lotu Pan. ");
INSERT INTO hla_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tara tana poata e Iesu e la me sabiena a toa katun a matakiau, e tsinanen e posa noa meien u matakiau. ");
INSERT INTO hla_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bu katunun tsitsilo i tanen e poier, “Tson Hihatuts, esi te kato homi ba matanen te kiauna? Nonei, tsi e tsinanen ne tamanen?” ");
INSERT INTO hla_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Be Iesu e poiena, “E moa. E moa ta markato ta omi te ga kato hakiau a katun teka. Nonei e matakiau silema te go kui beme nien e Sunahan a mirakul ba barebana te toan tareren. ");
INSERT INTO hla_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ara gi kato nitoa meni a mar toukui teka, a toukui tere Sunahan te haleie molia. A poata te la nama ba toukui teka te kapa nou. E kato uana tara katun te kui mena lan. Te bong nama a bong, ba katun te ma antunan kui lel nei. ");
INSERT INTO hla_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Poata te ka noa gia lia i puta, alia e heregi u ualesala tara barebana i puta.” ");
INSERT INTO hla_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","E Iesu e ranga hakapa me kahusuna turu tsikitsiki, ba nonei e sohale nei u kinahus u tsikitsiki ba te sahi nanen i matana katun a matakiau. ");
INSERT INTO hla_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Be Iesu e poiena i tanen, “La tala, ba lö te na galusem a matamulö tara kats i Siloam.” (A solo teka e poiena ‘hala’.) Ba nonei a katun e na galusuna, ba poata te kopis pouts men ba matanen e tara haniga poutsuna. ");
INSERT INTO hla_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ba pal katun ti atei sile ien na pal katun ti tare ien poata te singo ien ta tsi monin hitaguhu, nori i poei, “Nonei a katun teka te roron gum ba te singoe iena ta tsi monin hitaguhu, tsime?” ");
INSERT INTO hla_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ba palabi e poier, “Aa, nonei.” Kaba palabi i poei, “E moa. E ma nonei nei, kaba e here neien.” Ba nonei a katun e poiena, “E moa, alia lasi.” ");
INSERT INTO hla_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ba nori e poier i tanen, “E kato halona uana ime ba matamulö te niga poutsuna?” ");
INSERT INTO hla_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ba nonei e poiena, “A katun a solonen e Iesu e kuie lala u tsikitsiki me sahi nana i matar ba te poiena i tar, ‘Alö go la u tara kats i Siloam ba lö te na galusem a matamulö.’ Ba lia e la gula me na galusugu, ba lia e toan tara haniga poutsugu.” ");
INSERT INTO hla_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ba nori e poier i tanen, “A katun teka e kana ime?” Ba nonei e poiena, “Iba, alia e ma ateigi.” ");
INSERT INTO hla_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ba nori i lu mena tei a katun te matakiau mam turu Parisi. ");
INSERT INTO hla_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","A mirakul teka e butia turu Lan u Goagono turu Jiu. ");
INSERT INTO hla_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bu Parisi e rangata haser nonei a katun me poier, “E kato halona uana ime ba matamulö te kalata poutsuna?” Ba nonei e poiena i taren, “E Iesu e hakeie lala u tsikitsiki i matar ba lia e na toan galusegu a matar ba lia e tara haniga pouts talagu.” ");
INSERT INTO hla_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bu palair u Parisi e poier, “Nonei a katun teka e Iesu e ma la meia tere Sunahan, taraha nonei e roron kato pekoena a lo turu Lan u Goagono.” Ba palabi e poier, “Ga a katun a omi e ma antunan kato nanei a mar mirakul teka.” Ba nori e hula hakats talar. ");
INSERT INTO hla_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bu Parisi e rangata leler nonei a katun me poier, “Alö e poiem a katun te kato hakalata poutse lala a matamulö nonei esi?” Ba katun e poiena, “Nonei romana a toa propet!” ");
INSERT INTO hla_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kaba u Jiu i hahamanein nonei a katun teka te matakiau mam uen ni hahamana hasin te kalata pouts u a matanen. Ba nori e ngöer e tsinanen ne tamanen. ");
INSERT INTO hla_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ba nori e rangata raren me poier, “Nonei a pien tson i tamilimiu teka? Nonei i posa noa mei u matakiau? E kato halona uana ime ba matanen te kalata poutsuna?” ");
INSERT INTO hla_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bu muntahol e ranga palis raren me poier, “Alam e atei silem a katun teka nonei a pien i tamulam, na lam e atei sil hasem nonei i posa noa mei u matakiau. ");
INSERT INTO hla_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kaba alam e ma atei silemi te mar tara pouts uanen, na lam e ma atei sil hasemi esi te kato hakalata poutse lala a matanen. Alimiu peisa go rangatse men. Nonei e pan hakapa. Nonei e tatei ranga peisana.” ");
INSERT INTO hla_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","U muntahol i mar ranga u teka taraha nori i matoutir a pal kapan turu Jiu. A pal kapan i hatangana hoboto hakapein te gi tsuga ba menien ta katun i luman lotu te poiena e Iesu nonei e Mesaia te hale iema e Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nonei a ka te poe bei u muntahol, “Alimiu peisa go rangatse men. Nonei e pan hakapa.” ");
INSERT INTO hla_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nori i ngö hahuolema nonei a katun te matakiau mam me poier i tanen, “Alö go ranga hamana koruia i matane Sunahan. Alam e atei silem nonei e Iesu teka a katun a omi.” ");
INSERT INTO hla_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ba nonei e poiena i taren, “E omina, tsi e moa? Alia e ma ateigi. Alia e atei sil lasegu tu matakiau mam u lia, kaba i romana alia e tara pouts talagu.” ");
INSERT INTO hla_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ba nori e poier i tanen, “Aha te katoe lalen i tamulö? E kato halona uana ime ba nonei te kato hakalata poutse lala a matamulö?” ");
INSERT INTO hla_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ba nonei e ranga lelina me poiena, “Alia e hatei hakapa ragu lolimiu, kaba limiu e ma hengo mulei. Aha te ngilin hengo hahuol nami limiu u ranga teka? Alimiu toum e ngilin katunun tsitsilo has uamiu i tanen?” ");
INSERT INTO hla_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ba nori e ranga homi naren me poier, “Alö a katunun tsitsilo i tanen, kaba alam e moa. Alam u katunun tsitsilo tere Moses. ");
INSERT INTO hla_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Alam e atei silem e Sunahan e ranga gono mei e Moses. Kaba a katun teka, alam e ma atei silemi ime te la men.” ");
INSERT INTO hla_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ba nonei e asingoto koruna me poiena, “Pua! A katun teka te kato hakalatse lala a matar, kaba alimiu te poe noa hasemiu alimiu e ma atei silemi ime te la men? ");
INSERT INTO hla_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ara e atei silera e Sunahan e ma hengoe nei a katun a omi. Kaba e Sunahan e hengoena a katun te hapane nen na te katoena a ka te ngile nen. ");
INSERT INTO hla_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","I mam koru noa ba te noana i romana u katun i namala hengoni ta katun te ga kato hakalata poutsi a matana a katun ti posa noa mei u matakiau. ");
INSERT INTO hla_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Alia e poiegu a katun teka e lama tere Sunahan. Sanena te ga ma la meien tere Sunahan, nonei sane ma antunan katoe nei ta mirakul.” ");
INSERT INTO hla_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ba nori e ranga sisi uar i tanen me poier, “Alö i posa noa mei u matakiau. E haruto nena alö a katun a omi koru! E moa koru te go hatuts meri lö alam!” Ba nori e toa tsuga ba naren i luman lotu. ");
INSERT INTO hla_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","E Iesu e hengoin ti tsuga ba menien nonei a katun, ba nonei e na sabie nen me poiena, “Alö e hamana uam tara Pien tere Sunahan?” ");
INSERT INTO hla_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ba nonei e poiena, “A tsi tsunono, alö go hateie molia esi nonei ba lia te toan hamana uagu i tanen.” ");
INSERT INTO hla_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Be Iesu e poiena i tanen, “Alö e tara hakape mulen. Alia nonei a katun, alia te ranga gono mego lö.” ");
INSERT INTO hla_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ba katun e poiena, “O Tsunono, alia e hamanagu.” Ba nonei te hatukununa i matane Iesu. ");
INSERT INTO hla_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Be Iesu e poiena tara barebana, “Alia u la silema i puta te go mi lu kata meri lia u katun te hamanar nu katun te hahamanar. U katun te hamanar e kato uar tara katun a matakiau te kato hakalata poutse gula lia. Nu katun te hahamanar e kato uar tara katun te tara hanigana ba te toan matakiauna.” ");
INSERT INTO hla_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ba palabir u Parisi ti ka hasukusukuia teka e hengoer u ranga me poier i tanen, “Alö e poiem alam e here noa hasemi u katun u matakiau?” ");
INSERT INTO hla_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Be Iesu e poiena i taren, “Sanena te go poe mia limiu, ‘Alam e heremi u katun u matakiau,’ u markato u omi i tamilimiu sane ma pan bala nei. Kaba u markato u omi i tamilimiu e pan talana, taraha alimiu e poemiu, ‘Alam e atei hanigam.’” ");
INSERT INTO hla_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Be Iesu e poiena, “U mana koru alia e hatei hamana rago limiu, a katun te raman tasuna tara tamana tara ololon sipsip kaba e aroho tununa tara tana makum, nonei a katun a kopkop. ");
INSERT INTO hla_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kaba a katunun pepeitokap turu sipsip e roron tasuna tara tamana. ");
INSERT INTO hla_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Na katunun pepeitokap tara tamana e kalata nanei a katun teka a tamana. Na katunun pepeitokap turu sipsip e ngöena a solor a man toa man sipsip hoboto i tanen, ba nori te hengo mareier a mar ranga i tanen, ba nonei te peigi mera neien i ielesala. ");
INSERT INTO hla_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nonei e peigi mera nei u sipsip hoboto i tanen i ielesala ba nori te kukutie ren, taraha nori e atei siler u mar ranga i tanen. ");
INSERT INTO hla_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","U sipsip i tanen e ma tatei kukutieri a tana katun. E moa. Nori e bus ba naren, taraha nori e ma hengo mareieri u mar ranga tara tana katun.” ");
INSERT INTO hla_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","E Iesu e kato u haharoei teka turu katun, kaba nori i ma atei silei aha te ranga nen. ");
INSERT INTO hla_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Be Iesu e poe lelena i taren, “U mana koru alia e hatei hamana rago limiu, a barebana e hereri u sipsip na lia e heregi a tamana tara ololon sipsip. ");
INSERT INTO hla_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","U katun u gamogamo hoboto ti mamia i tar ba te poier e Sunahan e hala ramen, nori e hereri u katun te kopkop rer u sipsip. Kaba u katun te hamana uar i tar i ma hengo rien, e kato uar turu sipsip te ma hengoeri u ranga tara tana katun. ");
INSERT INTO hla_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Alia e heregi nonei a tamana turu sipsip. A katun te hamana uana i tar alia e hatongo kap nagen tara nomi ba lia te pakoko hase gen. Alia e heregi a katun te pakoko rena u sipsip te na hoatar ba te mi tasu poutsur. ");
INSERT INTO hla_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nori u gamogamo e hereri u katun te kopkop rer u sipsip. Nori e mi katsin kopur ba te atung hamate raren ba te kato hohomi raren. Kaba alia u la silema te gi lu meni a barebana a nitoatoa, a mar nitoatoa te niga balana. ");
INSERT INTO hla_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Alia e heregi a katunun pepeitokap a niga turu sipsip te tatei mate sil rena u sipsip i tanen. ");
INSERT INTO hla_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","A katunun kui tun e bus ba rena u sipsip tara poata te la nama a muki a hie, taraha nonei e ma tei ranei u sipsip na nonei e ma katunun pepeitokap hamana has uanei turu sipsip. Ba muki a hie e na kotokoto rena u sipsip ba te rura ranen. ");
INSERT INTO hla_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nonei e busuna, taraha nonei a katunun kui tun ne ma hakats sil ranei u sipsip. Ne kato has uana turu katun u gamogamo te ma pepeito kap haniga rari u barebana i tar. ");
INSERT INTO hla_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Alia e heregi a katunun pepeitokap a niga turu sipsip te atei sil rena u sipsip i tanen nu sipsip i tanen e atei sil hase ren. Alia e atei sil regu u barebana te hamana uar i tar ba nori te atei sil hase rio lia. Ne kato has uana i iesana tere Tamar. Nonei e atei sile nolia na lia e atei sil hase gen. Na lia e mate sil ragou romana u barebana i tar. ");
INSERT INTO hla_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","U palabir u katun has te hereri u sipsip i tar e ka ria i ielesala tara pal barebana i tar. Alia e na peigi has ragu men romana ba nori te hengoe riou u ranga i tar. Ba i murimuri e ka noa romana a toa pal barebana na toa katunun pepeitokap i taren. ");
INSERT INTO hla_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“E Tamar e ngil korue nolia, taraha alia e hanigagu te go mate u romana lia ba lia te toatoa pouts gou romana. ");
INSERT INTO hla_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","A katun e ma antunan atung hamate nanoi lia turu ngil peisa i tanen. E moa. Alia peisa te hala negou romana a peisar tara tou mate. Alia e ka megu a nitagala te go haniga u lia bu barebana te atung hamatie rio lia, na lia e ka has megu a nitagala te go toatoa pouts u lia. Nonei a ka te ranga mei lia e Tamar te go katoi lia.” ");
INSERT INTO hla_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ba poata ti hengoeia u Jiu u ranga teka, ba nori e hula hakatsir. ");
INSERT INTO hla_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bu katun u para e poier, “A katun teka e seier u mate na e momolö hasina. Aha te hengo sile mien limiu?” ");
INSERT INTO hla_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kaba palabi e poier, “E moa. A katun te seier u mate e ma tatei ranga uanei teka. A mate e antunan kato hakalata nena a matakiau? E moa!” ");
INSERT INTO hla_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","A poata tara kannou pan tara Luman Lotu Pan e butuia i Jerusalem. A ke hamuri tala be Iesu e roro lana turu luman oho i rehina Luman Lotu Pan ti ngöei u luman oho tere Solomon. ");
INSERT INTO hla_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bu Jiu e gono hahise ren me poier i tanen, “Alö e roron haharoei ramo lam alö esi. Alö e katoe mou a ka teka tara lahisa poata lel? Te Mesaia mia lö te hala nema e Sunahan, ba lö te hatei hamaroro ramo lam.” ");
INSERT INTO hla_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Be Iesu e poieto i taren, “Alia u hatei hakapa raio limiu nonei alia, kaba alimiu e ma hamane milia. E Tamagulia e halei lia a nitsunono te go kato meni lia a man mirakul, na nori e haruto ner te mana uana u ranga i tar. ");
INSERT INTO hla_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kaba alimiu e ma hamane milia, taraha alimiu e ma katun uami i tar. ");
INSERT INTO hla_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","U barebana i tar e hengo mareier a mar ranga i tar ba te kato uar turu sipsip te hengo mareier u mar ranga tara katunun pepeitokap i taren. Na lia e atei sil ragen, na nori e kukute hase rio lia. ");
INSERT INTO hla_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na lia e hala negu a nitoatoa te ka nitoana turu katun i tar. Ne moa koru te gi mate nitoa uen romana. A muki a hie e tatei gulena a sipsip tara limana katunun pepeitokap, kaba e moa ta katun te ga antunan gul a katun i tar i limar. ");
INSERT INTO hla_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","E Tamagulia e hala rien lia na nonei e pan bala nena a man ka hoboto. Ne moa ta katun te ga antunan gul has raien i limane Tamagulia. ");
INSERT INTO hla_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Alam mere Tamar a toa puku.” ");
INSERT INTO hla_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bu Jiu e lu leler u hatu me katsin tie rien. ");
INSERT INTO hla_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kaba e Iesu e poei i taren, “Alia u kato a para a toukui a niga te haruto nena e Tamagulia e taguhe nolia. Alia u kato a saha mar toukui ba limiu te katsin ti hatu namo lia?” ");
INSERT INTO hla_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bu Jiu e palise ren me poier, “Alam e ma ngilin ti hatu nami lö tu katoa lö a toukui a niga. E moa. Alam e raharaha silem te ranga homi mena milö e Sunahan. Taraha, alö a katun tun lasi, kaba alö e kato here nami a peisamulö e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Be Iesu e poiena i taren, “I koloto hakapa nia turu Buk u Goagono i tamilimiu te poe meni e Sunahan, ‘Alimiu e heremi u sunahan.’ ");
INSERT INTO hla_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nu ranga turu Buk u Goagono e ma antunan rus nei. Ne Sunahan e poei nori u katun i herei u sunahan, u katun te halari e Sunahan u ranga i tanen. ");
INSERT INTO hla_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","E Tamagulia te hopu kap neio lia me hala mena nei lia i puta. Gaha te poe sile milimiu alia e ranga homi negu e Sunahan te poe mena gulei lia, ‘Alia a Pien tere Sunahan’? ");
INSERT INTO hla_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Te go ma kato meni lia u toukui tere Sunahan, alimiu sane go ma hamane milia. ");
INSERT INTO hla_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kaba alia e katoegu u toukui tere Sunahan. Te ma hamane milimiu alia, alimiu go hamana noa has mia te mana uana u toukui i tar. Te mar kato uamou limiu teka ba limiu te atei sile mou e Tamagulia e ka uana i tar na lia e ka has uagu i tanen.” ");
INSERT INTO hla_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","E Iesu e ranga hakapa ba nori e katsin pile kap lel naren, kaba nonei e la hatalis ba ren. ");
INSERT INTO hla_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ba nonei e la poutsuna i hapalana a Ramun i Jodan me na kana tara han te baptais mameia e Jon. ");
INSERT INTO hla_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bu katun u para e la uarima tere Iesu me hiararangar me poier, “E Jon e namala katoi ta mirakul, kaba a mamana ka te hatei nien tere Iesu e manana.” ");
INSERT INTO hla_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bu katun u para teka e hamana ria tere Iesu. ");
INSERT INTO hla_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","A toa katun a solonen e Lasarus e kaia tara taun i Betani ti ka hasia u hahinanen e Marta mere Maria. ");
INSERT INTO hla_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","E Maria nonei a tahol te hakis mami u uapi u soksoka tere Iesu me sahi nei a hulunen a man moune Iesu. E Lasarus e ka mei a nimate pan. ");
INSERT INTO hla_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bu mun toulana tahol e hala ner u ranga tere Iesu me poier, “O Tsunono, a tsomi i tamulö e ka mena a nimate pan.” ");
INSERT INTO hla_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kaba poata te hengoeia e Iesu u ranga teka, ba nonei e poieto, “A nimate teka e ma kato hamate nitoe noi e Lasarus. Nonei e ka sil menei a nimate te gi solo sei meni a solone Sunahan, na Pien tere Sunahan has.” ");
INSERT INTO hla_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","E Iesu e ngil koru e Marta ne toulanen ne Lasarus has. ");
INSERT INTO hla_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kaba poata te hengo nien e Lasarus e ka mei a nimate, ba nonei e ka lelena u huol u lan i han te ka ien. ");
INSERT INTO hla_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ba nonei e toan poieto turu katunun tsitsilo i tanen, “Ara gi la pouts i Judia.” ");
INSERT INTO hla_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bu katunun tsitsilo e poier i tanen, “Tson Hihatuts, e ma manasei ti katsin tie mei lö u Jiu u hatu. Ga lö e ngilin la pouts koru lel hasim nonei tara han teka?” ");
INSERT INTO hla_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Be Iesu e poieto, “A lan e ka mena u ualesala te popona tara bongbong ba te lana e antuna noa i lahi. Te hula la mena a katun a lan ba nonei te ma tutuna nei, taraha a pitala e piri halesalena a han. ");
INSERT INTO hla_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kaba te hula la mena a katun a bong ba nonei te tutu menei u kuhil. Ne kato has uana i tar. E moa ta ka ta omi te ga butuia i tar e antunana te hopu kap nena e Sunahan te gi kato hamate meni u katun alia.” ");
INSERT INTO hla_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Be Iesu e ranga lelina me poiena, “A hahikapien i tarara e Lasarus e sohona, kaba alia e na gulie goen.” ");
INSERT INTO hla_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Bu katunun tsitsilo e poier, “O Tsunono, te soho nen ba nonei te niga pouts nou romana.” ");
INSERT INTO hla_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","E Iesu e haharoein te mate hakapa u e Lasarus, kaba u katunun tsitsilo i tanen i poei e Lasarus e soho tun. ");
INSERT INTO hla_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Be Iesu e hatei hamaroro ranen te mate hakapa u e Lasarus. ");
INSERT INTO hla_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ba nonei e poiena, “E nigana tu ma kaia lia i tanen. Ba poata te tare moa limiu a ka te na kate gou lia, ba limiu te toan hamana mou. La tala mou i tanen.” ");
INSERT INTO hla_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Be Tomas ti ngö hasei “U Puna” e poei turu palabir u katunun tsitsilo, “Bara. Ara gi la tala. Te atung hamatie roen e Iesu, noahasina, ara e na mate gono meroen.” ");
INSERT INTO hla_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Poata te tukuia e Iesu i rehina taun i Betani ba nonei e toan hengoena ti hongo hakapa menien e Lasarus turu tohats u lan te kapa. ");
INSERT INTO hla_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani e sukusukuna i Jerusalem, a topisa puku a kilomita. ");
INSERT INTO hla_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nu Jiu u para i lama me mi hatatagi gono mer e Marta ne Maria te mate u e hahinaren e Lasarus. ");
INSERT INTO hla_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Poata te hengoeia e Marta te la uama e Iesu, ba nonei e na hitupali meten, kaba e Maria e kakaia i han. ");
INSERT INTO hla_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Be Marta e poiena tere Iesu, “O Tsunono, sanena alö tu kaia teka, e hahinar sane ma tatei matei! ");
INSERT INTO hla_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Na tara poata teka noa has alia e atei silegu e Sunahan e hale noi lö a ka te rangata sile mulö i tanen.” ");
INSERT INTO hla_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Be Iesu e poieto i tanen, “E hahinamulö e takei pouts noa tara tou mate i tanen.” ");
INSERT INTO hla_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Be Marta e poiena i tanen, “Alia e atei silegu nonei e takei poutsna romana tara tou mate i tanen tara kapakapana poata, tara poata te hatakei pouts rena romana e Sunahan u mate hoboto.” ");
INSERT INTO hla_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Be Iesu e poiena i tanen, “Alia nonei te hatakei pouts regu u katun tara tou mate i taren ba te hala has ragien a nitoatoa. E manana, a katun te hamana uana i tar e matena romana, kaba nonei e toatoa pouts hasina romana. ");
INSERT INTO hla_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na katun te toatoa noa hasina i romana na te hamana uana i tar, e moa koru te ga mate nitoa uen romana. Alö e hamanem u ranga teka?” ");
INSERT INTO hla_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Be Marta e poiena i tanen, “Aa, o Tsunono. Alia e hamanegu alö e Mesaia, a Pien tere Sunahan te ga la uama i puta.” ");
INSERT INTO hla_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","E Marta e mar ranga u teka me la poutsuna me na ngöena e toulanen e Maria me hahasi menen me poiena, “A Tson Hihatuts e kana na nonei e ngöe nolö.” ");
INSERT INTO hla_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Poata te hengoeia e Maria u ranga teka ba nonei te haseseina te go na hitupali menien e Iesu. ");
INSERT INTO hla_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","E Iesu e ma tuku noai tara tsi han tere Maria. Nonei e ka noaia tara makum te ranga meien e Marta. ");
INSERT INTO hla_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","A palabir u Jiu i tatagi gono mei e Maria i luma. Poata ti tare ien nonei e lakasa hasesei ba nori e kukutie ren, taraha nori i poei nonei e la u tara kioun mate ba te na tabena. ");
INSERT INTO hla_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Poata te tukuia e Maria me tarena e Iesu ba nonei e tuhatukun nena i matanen me poiena, “O Tsunono, sanena alö tu kaia teka, e hahinar sane ma tatei matei!” ");
INSERT INTO hla_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Be Iesu e tarena e Maria te tabe u, nu Jiu ti la gono has memen i tabe has, ba nonei e toan sagohena a nitatagi pan i torinen. ");
INSERT INTO hla_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Be Iesu e poieto, “Ime ti honge ien?” Ba nori e poier i tanen, “O Tsunono, lama. Mi tara.” ");
INSERT INTO hla_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Be Iesu e tabe hasina. ");
INSERT INTO hla_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bu Jiu e poier, “Tara iam. Nonei e ngil bala korui e Lasarus.” ");
INSERT INTO hla_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kaba palabi i poei, “Nonei e kato hakalata poutsi a matakiau. Ga neha tsiponi te ma hapiu naien te go ma mate uai a katun teka?” ");
INSERT INTO hla_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","E Iesu e sagoho leli a nitatagi pan i torinen ba nonei te na tukuna tara kioun mate. A kioun mate teka i kuieia turu lapo. Nori i haka hakapa a hatu pan a perperere i matana kiou. ");
INSERT INTO hla_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Be Iesu e poiena, “Lu ba neiam a hatu!” Be Marta e hahinana katun te mate e poieto i tanen, “O Tsunono, nonei e soka homi talana, taraha u tohats u lan te mate hakapa ien.” ");
INSERT INTO hla_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Be Iesu e poiena i tanen, “Alia e hateie gulo lö te hamana mia lö i tar, ba lö te tare mou te haruto nanoa e Sunahan a nitagala pan i tanen.” ");
INSERT INTO hla_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ba nori e lu ba ner a hatu. Be Iesu e tara seina me poiena, “O Tamar, alia e haniga uagu i tamulö te hengo mena milö alia. ");
INSERT INTO hla_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na lia e atei silegu alö e roron hengoe molia, kaba alia e mar ranga uagu teka i matar u katun te ka ria teka, ba nori te tatei hamaner tu hala mena mei lö alia.” ");
INSERT INTO hla_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nonei e ranga u teka me ngö hapanina me poiena, “O Lasarus, lakasama!” ");
INSERT INTO hla_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ba katun a mate e lakasa nama tara kiou. A limanen na mounen i pilei u labalaba na bakunen has. Be Iesu e poiena i taren, “Purese iam, ba nonei te lana!” ");
INSERT INTO hla_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","U katun u para turu Jiu ti la mema e Maria e mi tarei a ka te kato e Iesu, ba nori e toan hamana uar i tanen. ");
INSERT INTO hla_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kaba palabir u Jiu teka i la u turu Parisi me hatei rarien a ka te kato e Iesu. ");
INSERT INTO hla_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bu pris pan nu Parisi e ngö gugono rer a pal kapan turu Kot Pan turu Jiu ba nori e poier, “Aha te katoe rou ra? A katun teka e katoena a mirakul a para! ");
INSERT INTO hla_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Te ma hapiu naro ien ra, ba barebana hoboto te hamana uariou i tanen. Bu amir i Rom te mi toa kato homie riou a Luman Lotu Pan i tarara nu han hoboto has!”* ");
INSERT INTO hla_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","E Kaiapas nonei a tsunono pan turu pris turu hiningal teka, na nonei e ka hasia turu hagum. Ba nonei e poiena i taren, “Alimiu e tutu korumiu! ");
INSERT INTO hla_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Alimiu e ma atei silemi a ka te nigana. A han hoboto i tarara e gi ma kato homiei. E nigana te mate sil rena a toa puku a katun a barebana hoboto.” ");
INSERT INTO hla_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaba nonei e ma katoei u ranga teka i peisanen. E moa. Nonei a tsunono pan turu pris, kaba e ma atei silei nonei e hatei mamin te go na mate sil meroi e Iesu u Jiu. ");
INSERT INTO hla_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ne Iesu e moa te go mate sil merien u Jiu peisa. Nonei e mate sil hase nou a galapien tere Sunahan te ka kalakala ria tara mamana han ba nori te here roi romana a toa hun katun. ");
INSERT INTO hla_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ba pal kapan e tanian korupakö ner te gi atung hamate menien e Iesu. ");
INSERT INTO hla_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","E kato u teka, be Iesu te ma hula la lel nei i matar u Jiu i Judia. Nonei e la u tara toa han i rehina a latu pinopino, ba nonei e na ka gono merena u katunun tsitsilo i tanen tara taun te ngöeri Ipraim. ");
INSERT INTO hla_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","A kannouna turu Paska turu Jiu e sukusuku tala, bu katun u para turu han i lehana i la uamato i Jerusalem. Taraha, nori i ngilin hamatskö poutsi a peisaren turu Lo turu Jiu i mam tara kannouna turu Paska. ");
INSERT INTO hla_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","U katun i sake e Iesu me roro ria i Luman Lotu Pan me poier, “Alimiu e poemiu a neha? E Iesu e la has uanama romana tara kannou, tsi e moa?” ");
INSERT INTO hla_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","U pris pan nu Parisi i haka hakapa u ranga u tagala te poei, “A katun te atei silena te kana e Iesu e hatei noa las rano lam ba lam te na halu namoen.” ");
INSERT INTO hla_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","E Iesu e la uama tara taun i Betani turu tönomo u lan i mam tara kannouna turu Paska turu Jiu. Nonei a han te kaia e Lasarus, a katun te hatakei poutsi e Iesu tara tou mate i tanen. ");
INSERT INTO hla_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bu katun i nas bete ien a tsi kannou. Ne Marta e susoata a kannou be Lasarus nu palabir u katun e gum gono mer e Iesu turu tebol. ");
INSERT INTO hla_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Be Maria e luena a botolo uapi u soksoka ti kuiei a ka ti ngöei u nat ba te hol sei koruna. Ba nonei e kis nanen i mouna e Iesu me sahe nei a mounen a hulunen. Ba luma e saputena u masina turu uapi. ");
INSERT INTO hla_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Ne Judas Iskeriot e ka hasia teka. Nonei a toa katunun tsitsilo tere Iesu na nonei has te haruto nanou romana e Iesu turu katun ti paköe ien. Ba nonei e poieto, “U uapi teka e antunana tara 300 denarius, a holina turu 300 u lan. A neha ti ma hahol nien ba te hala naria turu katun ti moa ta moni?” ");
INSERT INTO hla_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kaba nonei e ma ranga uai teka te tatagi sil merien u katun ti moa ta moni. E moa. Nonei e mar ranga u teka, taraha nonei a kopkop. Nonei a katun te taratara kapin a moni turu katunun tsitsilo na tere Iesu, na nonei e roron kopia i tanen. ");
INSERT INTO hla_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Be Iesu e poiena, “Hakei! Nonei e haputu silei u uapi u soksoka teka tara poata te na honge roen lia tara kiou. ");
INSERT INTO hla_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","U katun ti moa ta moni e ka gono nitoa mera rio limiu. Kaba alia e ma ka gono nitoa mera goi limiu.” ");
INSERT INTO hla_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nu Jiu u para i hengoen te ka u e Iesu i Betani, ba nori e mi katsin tarer e Iesu. Na nori e mi katsin tara hasi e Lasarus te hatakei poutseia e Iesu tara tou mate i tanen. ");
INSERT INTO hla_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Bu pris pan e toan korupakö ner te gi atung hamate meni e Lasarus has, taraha u Jiu u para i tanian tara halhal ban a pal kapan i taren ba te hamana uar tere Iesu ti hengo menien te toatoa pouts u e Lasarus. ");
INSERT INTO hla_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Turu tanu lan a parapara koru u katun ti la uama tara kannouna turu Paska turu Jiu i hengoen e Iesu e la uanama romana i Jerusalem. ");
INSERT INTO hla_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ba nori e luer a man kalan roei me na katsin hitupali meren me ku hapanir me poier, “Hosana! E Sunahan e kalalena a katun te la menama a nitsunono i tanen! Solosei iam a Kingina i Israel!” ");
INSERT INTO hla_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Be Iesu e sabiena a toa tunan dongki me osana i tanen. Nonei e kato u te ranga u u Buk u Goagono i manasa te poien, “E moa te go matoutuam limiu, u barebanar i Saion. A King i tamilimiu e la tala uanama i tamilimiu, ba te osana tara tunan dongki.” ");
INSERT INTO hla_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nu katunun tsitsilo i ma atei silei nonei u ranga tara poata teka. Kaba i murimuri, te la poutsna romana e Iesu i Kolö, ba nori te toan hakats pouts ner romana te mar ranga u u Buk u Goagono, nu ranga i tanen e butu hamana. ");
INSERT INTO hla_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","U katun u para koru teka i na hitupali mei e Iesu, taraha nori i hengoen te ngö halakasa meni e Iesu e Lasarus me kato hatoatoa poutse nen. A pal barebana ti tara hakapi a mirakul teka ti hatei ren. ");
INSERT INTO hla_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bu Parisi e hiararangar me poier, “Ara e mastei hapiu naren. Tara iam, u katun hoboto e kukutie ren!” ");
INSERT INTO hla_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","U palair u Grik i ka hasia i gusur u barebana ti la u i Jerusalem tara kannouna turu Paska ti na lotu uen tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ba nori e la uar tere Pilip, a toun Betsaida i Galili, ba nori e poier i tanen, “A tsi tsunono, alam e ngilin tara nem e Iesu.” ");
INSERT INTO hla_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Be Pilip e na hateiena e Endru. Be re Endru mere Pilip e na hateier e Iesu. ");
INSERT INTO hla_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Be Iesu e poiena i taren, “A poata e butu hakapa te kato hapan poutse noa e Sunahan alia, alia tu butun katunuma. ");
INSERT INTO hla_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Alimiu e atei silemiu a markato tara ngalin kannou. Te ma lebe ria a tsi ngalin kannou ba te ma buta nei, ba nonei te ka tun talasina. Kaba te lebe rien ba te butana, ba nonei te toan pusuku talana ba te na hua haparana romana. Ne kato has uana i iesana i tar. U mana koru alia e hatei rago limiu, alia e mate gou romana. Alia e mate sile gou te gi lu meni u katun u para a nitoatoa hamana. ");
INSERT INTO hla_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","A katun te hakats talasi nena a nitoatoa i tanen i puta e na mate noa talasina romana. Kaba a katun te hakats koru nena e Sunahan ba te ma ngil korue nei a nitoatoa i tanen i puta e na luena romana a nitoatoa te ka nitoana. ");
INSERT INTO hla_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","A katun te ngilin kato nena a toukui i tar e ga kukuteio lia. Na katun te katoena a toukui i tar e na ka noa te na ka has gia lia, ne Tamagulia te kato hapane noen.” ");
INSERT INTO hla_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Be Iesu e poe lelina, “A torir e tiama koru talana. Kaba alia go poei aha, ‘O Tamar, alö go lu ban a poata a omi te butu tala nama i tar’? E moa. Taraha, nonei a ka tu la sile malia. ");
INSERT INTO hla_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","O Tamar, alö go kato hapan a peisamulö.” Bu toa u ranga e butu nama i Kolö me poiena, “Alia u kato hapan hakapi a peisar na lia e kato lel hase goen romana.” ");
INSERT INTO hla_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ba barebana ti ka hasukusuku e hengoer u gutsil teka me poier, “U gururu!” Ba palabi e poier, “A toa angelo te ranga gono mela len!” ");
INSERT INTO hla_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Be Iesu e poiena, “Alia e atei silegu e Sunahan e hengoe lalo lia. Kaba nonei e ranga ualala teka te go atei has uam limiu. ");
INSERT INTO hla_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","A poata turu kot tere Sunahan e sukusuku tala nama. Nonei e katsin tsuga ba tala nena e Satan. ");
INSERT INTO hla_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ba poata te haka seie roen romana lia tara koruse, ba lia te toan las reguma u katun hoboto.” ");
INSERT INTO hla_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","E Iesu e ranga u teka ba te hatei nena te mar mate uanoen romana. ");
INSERT INTO hla_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ba barebana e poier i tanen, “U Buk u Goagono e poiena e Mesaia te hopu kapin e Sunahan te ga butun katun uen, nonei e toatoa nitoana romana. Te na haka sei ria romana lö tara koruse, gaha tsiponi te poe nami lö alö nonei tu butun katunuma?” ");
INSERT INTO hla_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Be Iesu e poiena i taren, “Alia e heregi u ualesala te gamon ka gono lel mera golimiu. Alimiu go hamane iam u ranga i tar ba lia te halesala negu a maroro i tamilimiu. Alimiu go ma kato uami tara katun te bong kapu nana i gusuna maroro. Nonei e la mena u kuhil ba te ma atei sile nei ime te la uanen. ");
INSERT INTO hla_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Alimiu go hamana uam i tar tara poata te ka gono noa mera gia lia alimiu, ba limiu te pien uamiu i tar.” E Iesu e mar ranga u teka ba te toan mous ba rena u Jiu teka. ");
INSERT INTO hla_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nonei e kato u mirakul u para i mataren, kaba nori i hahamana noa has nen. ");
INSERT INTO hla_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Na ka teka e kato hamani u ranga tere Aisaia a propetina i manasa te poien, “O Tsunono, u katun e ma hamaneri u ranga i tamulam. E Sunahan e harutein a nitagala i tanen tara man toa man katun lasi.” ");
INSERT INTO hla_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nori i ma antunan hamana talai, te poe hasi e Aisaia i manasa, ");
INSERT INTO hla_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“E Sunahan e kato hakuhil u hakhakats i taren te mar kuhil uana a katun a matakiau. Nonei e kato hatu hasi a bakuren. Na mataren e ma antunan tara lele nei a ka te manana, nu hakats i taren e ma antunan atei sil lel hase nei u ranga u mana. Na nori e ma antunan habirits pouts lel uari i tar ba lia te kato kato haniga pouts ragen. E moa.” ");
INSERT INTO hla_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","E Aisaia e mar ranga u teka, taraha nonei e tara mami te ga pan u romana e Kristo me hatei nanen. ");
INSERT INTO hla_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kaba a para a pal kapan turu Jiu i hamana noa hasia tere Iesu. Kaba nori i ma ranga nien i matar a barebana, taraha nori i matoutir u Parisi te gi tsuga ba merien tara luman lotu. ");
INSERT INTO hla_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","U katun teka i ngil koru noa hasi te gi haniga merien a palair u katun. Nori i ma ngil korui te go haniga merien e Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Be Iesu e ranga hapanina me poiena, “A katun te hamana uana i tar e hamana has uana tere Sunahan te haleie molia. ");
INSERT INTO hla_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Na katun te tare nolia e here nei e tara hasena e Sunahan te haleie molia. ");
INSERT INTO hla_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Alia u la uama i puta u here mei u ualesala. Alia u la silema ta katun te go hamana u i tar e go ma ka mei tu baku tu kuhil. ");
INSERT INTO hla_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Te hengo papalena a katun u ranga i tar ba te ma kukutie neien, alia e ma tatei one gien. Taraha, alia u la silema te go mi lu ba meni u barebana i puta a nihahuna. Alia u ma la sile mei te go mi ona merien lia. E moa. ");
INSERT INTO hla_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kaba a katun te tori-tsuga nano lia na te rama nena u ranga i tar, nonei e butu noa hasina romana tara toa tsonun hamou turu ranga tara kapakapana poata. Nu ranga te katoe gulia nonei te na hamoue noen. ");
INSERT INTO hla_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Alia e ma ranga negi u ranga peisa i tar. E moa. E Tamar te haleie molia te hatei lia a ka te go rangein lia. ");
INSERT INTO hla_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na lia e atei silegu u ranga i tanen te hala nena a nitoatoa te ka nitoana. Na man ka hoboto te ranga nagu lia e hatei e Sunahan alia.” ");
INSERT INTO hla_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","U lan i mam tara kannouna turu Paska turu Jiu e butu hakapa tala, be Iesu e atei silena a poata e sukusuku koru talana te ga la ba menien a han i puta teka ba te la pouts uana tere Tamanen. Nonei e roron ngil korur u katun i tanen. Nonei e ngil nitoa ren. ");
INSERT INTO hla_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","E Iesu nu katunun tsitsilo i tanen i nou a kannouna tara bong. Ne Satan e ranga hakapa mei e Judas Iskeriot a pien tere Saimon te go haruto menien e Iesu turu katun ti paköe ien. ");
INSERT INTO hla_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ne Iesu e atei sil e Tamanen e kato hapane ien tara mamana ka hoboto, na nonei e atei sil hasi nonei e lama tere Sunahan na nonei e ga la pouts has u romana tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ba nonei e takeina ba te lu ba nena u hasobu u ngahangaha i tanen me pousena u taol ba te kato here nanei a peisanen a katunun kui. ");
INSERT INTO hla_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ba nonei e hakis nena u ramun tara tabeli ba te tanian galusena a man mour u katunun tsitsilo i tanen me sahi hapalaka rane ien u taol te pouse ien. ");
INSERT INTO hla_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Poata te hasula u e Iesu tere Saimon Pita, be Pita e poiena i tanen, “A tsi tsunono, alö e ma tatei galusemi a man mour!” ");
INSERT INTO hla_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Be Iesu e poiena i tanen, “Alö e ma atei silemi a ka te kate gulia teka, kaba alö e atei moto mou romana.” ");
INSERT INTO hla_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Be Pita e poiena, “E moa koru te go galus meni lö a man mour!” Be Iesu e poiena, “Te ma galuse gia lia alö, ba lö te ma tatei katun uami i tar.” ");
INSERT INTO hla_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Be Saimon Pita e poiena i tanen, “A tsi tsunono, te kato uanen teka, ba lö te galusem a man mour na man limar na bakur na peisar hoboto!” ");
INSERT INTO hla_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Be Iesu e poiena i tanen, “A katun te totobu hakapa, a peisanen e gogoso hobotona. A torimilimiu e gogosona. Kaba toa puku te ma gogoso nei.” ");
INSERT INTO hla_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","E Iesu e atei sil esi te katsin haruto nen turu katun ti paköe ien. Nonei te poe beien, “A toa i tamilimiu te ma gogoso nei.” ");
INSERT INTO hla_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","E Iesu e galus hakapi a man mouren ba te hasei poutsena u hasobu u ngahangaha i tanen me gum poutsuna. Ba nonei e poiena i taren, “Alimiu e atei silemiu a ka te katoe gula lia i tamilimiu? ");
INSERT INTO hla_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Alimiu e ngöe milia a Tson Hihatuts, na limiu e ngö hase milia a Tsunono. Na limiu e ranga hamatskömiu, taraha alia a Tsunono i tamilimiu na Tson Hihatuts has i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Alia e galuse gula a man moumilimiu. Ba limiu te galus hasemiu a man mour a palabi. ");
INSERT INTO hla_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Alia e kato negu lei a ka teka te go kato has uam limiu i iesana. ");
INSERT INTO hla_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","U mana koru alia e ranga hamana mera golimiu, a katunun kui e ma pan nanei a katun pan i tanen. Na katunun tatala e ma pan has nanei a katun te haleie nen. ");
INSERT INTO hla_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Alimiu e atei silemiu a ka te ranga nagu lalia. Alimiu go kukute hase men ba limiu te toan sasalamiu. ");
INSERT INTO hla_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“U ranga teka e ma la uanei i tamilimiu hoboto. E moa. Alia e atei silegu u katun tu hopu kapir lia. Nu ranga turu Buk u Goagono e butu hamana nou te poiena, ‘A katun te nou gono meio lia e na haruto neno lia turu katun te paköe rio lia.’ ");
INSERT INTO hla_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Alia e hatei ragi limiu a ka teka i mam te butu noen, ba poata te butu hamana noen ba limiu te hamane mou nonei alia e Kristo. ");
INSERT INTO hla_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","U mana koru alia e ranga hamana mera golimiu, te hala mena gilia a toa katun i tamilimiu ba limiu te lu has mena mien i tamilimiu, e here nei alimiu e lu hase molia. Na poata te lue mia limiu alia, alimiu e lu hasemiu e Tamar te haleie molia.” ");
INSERT INTO hla_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","E Iesu e ranga u teka ba peisanen te tiama koru talana, ba nonei e ranga hapanina me poiena, “U mana koru alia e ranga hamana mera golimiu, a toa i tamilimiu e na haruto neno lia turu katun te paköe rio lia.” ");
INSERT INTO hla_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Bu katunun tsitsilo i tanen e hiataratarar. Nori i ma atei silei esi te ranga nen. ");
INSERT INTO hla_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na lia e Jon a tsomi tere Iesu, alia tu ka hasukusukuia i rehina e Iesu. ");
INSERT INTO hla_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Be Saimon Pita e kalohe nolia me poiena, “Alö go rangatsen esi nonei te ranga nanen.” ");
INSERT INTO hla_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ba lia te hatalupu uagu tere Iesu me poiegu, “O Tsunono, esi nonei?” ");
INSERT INTO hla_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Be Iesu e poiena, “Alia e kane goi a tsi beret a sirö ba te hale goien nonei a katun.” Ba nonei e kaneto a tsi beret me hale neien e Judas, a pien tere Saimon Iskeriot. ");
INSERT INTO hla_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Be Judas e luena a tsi beret, be Satan e toan seina i tanen. Be Iesu e poiena i tanen, “A ka te katsin kato nemu lö alö go na kato boroboren!” ");
INSERT INTO hla_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","E moa ta toa ta katun ti gum hahisia turu tebol te ga atei sili aha te ranga silei e Iesu u ranga teka. ");
INSERT INTO hla_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","E Judas e roron pepeito kapin u moni turu katunun tsitsilo, ba palabi e poier e Iesu e ranga mei e Judas te go na hol menien ta tsi kana tara kannou, ba palabi te poier nonei e ga na hala toumin a tsi moni turu katun ti moa ta moni. ");
INSERT INTO hla_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Be Judas e lu hakapena a tsi beret me toan lakasana. Ba ke bong talana. ");
INSERT INTO hla_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","E Judas e la hakapa be Iesu e poiena, “A solor e hala sei tale riou, alia tu butun katunuma. Ba lia te hala sei hasegu a solona e Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Alia te hala seiegu a solona e Sunahan be Sunahan te hala seie nou a solor, ba nonei te kato boroboro hase noen. ");
INSERT INTO hla_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","A ma tsi pien, alia e ka gono mera golimiu tara tsitabubun poata, ba lia te toan la ba rago limiu. Ba limiu te sakie molia. Kaba alia e hatei ragi limiu tu ranga u lia tara pal kapan turu Jiu, ‘Alimiu e ma tatei la uami te la uagu lia.’ ");
INSERT INTO hla_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Alia e hala ragi limiu u toa u ranga u tsimus: alimiu go hiangilngil iam. Alimiu e hiangilngil mou ba te kato uana tu mar ngil merai lia limiu. ");
INSERT INTO hla_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Te hiangilngil moa limiu, bu katun hoboto te atei sile riou alimiu u katunun tsitsilo i tar.” ");
INSERT INTO hla_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Be Saimon Pita e poiena tere Iesu, “O Tsunono, ime te la uamou lö?” Be Iesu e poiena, “Alö e ma antunan kukute namoi lia tara poata teka tara han te la uagou lia, kaba alö e kukute moto mou.” ");
INSERT INTO hla_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Be Pita e poiena, “Tara neha tsiponi te ma antunan kukute megi lia alö tara poata teka? Te go ngil u lö ba lia te mate beie golö.” ");
INSERT INTO hla_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Be Iesu e hohou rangata uana i tanen me poiena, “Alö be mate hamana bemou lia? U mana koru alia e ranga mego lö, tara bong teka noa lahas ba lö te holis topisa namou te go atei sil meni lö alia, i mam te kekeretskö noa a keriau a tson!” ");
INSERT INTO hla_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Be Iesu e poe lelena, “Alimiu go ma tokumi. Hamana uam tere Sunahan na limiu go hamana has uam i tar. ");
INSERT INTO hla_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","A rum a para e kana i luma tere Tamar, na lia e la silegu te go na hamatskö mam meni a makum i tamilimiu. Alia go ma tatei hatei rilimiu a ka teka te go ma mana uaien. ");
INSERT INTO hla_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Alia e la silegu te go na hamatskö mam meni a makum i tamilimiu, ba lia te na la pouts guma romana ba te mi lu mera gilimiu i tar te go na ka mia limiu te na ka gia lia. ");
INSERT INTO hla_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Na limiu e atei silemiu a maroro tara han te la uagou lia.” ");
INSERT INTO hla_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Be Tomas e poiena i tanen, “O Tsunono, alam e ma atei silemi te la uamou lö. Ime te mar atei sil mena moi lam a maroro?” ");
INSERT INTO hla_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Be Iesu e poiena i tanen, “Alia a maroro, na lia a mouna turu mana, na lia a mouna tara nitoatoa. E moa ta katun te go la u tere Tamar tara tana maroro. Alia peisa a maroro. ");
INSERT INTO hla_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Te atei sile mia limiu alia, alimiu e atei sil hasemiu e Tamar. Na alimiu e atei sil tale moen tara poata teka na i murimuri has. Na limiu u tara hakape men.” ");
INSERT INTO hla_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Be Pilip e poiena i tanen, “O Tsunono, haruto ramei lam e Tamamulö, ba te antunana i tamulam.” ");
INSERT INTO hla_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Be Iesu e poiena i tanen, “Alia u solon ka gono meraio limiu. Ba lö, o Pilip, te ma atei sil noa hase milia? A katun te rute nolia e ruto hasena e Tamar. Aha te poe mulö, ‘Haruto ramei lam e Tamamulö’? ");
INSERT INTO hla_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Alö e ma hamanami te ka uagu lia tere Tamar ne Tamar e ka has uana i tar? U ranga te hatei negu lia i tamilimiu u ma habutei lia. Kaba e Tamar te ka gono meno lia te katoena a man toukui peisa i tanen. ");
INSERT INTO hla_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Hamana iam te ka uagu lia tere Tamar na te ka has uana e Tamar i tar. Te moa milimiu ta nihamana teka, ba limiu te hamana noa hasemiu u toukui i tar e haruto nena te ka uagu lia tere Tamar. ");
INSERT INTO hla_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","U mana koru alia e hatei rago limiu, a katun te hamana uana i tar e katoe nou romana a man toukui te katoe gulia. Na man toukui i tanen e la sei nou romana tara man toukui teka, taraha alia e la uagu tere Tamar. ");
INSERT INTO hla_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na saha ka te rangata sile mia limiu tara solor, alia e katoe goen. E kato uana teka ba lia te soloseie gou a solona e Tamar. ");
INSERT INTO hla_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Te rangata namia limiu ta toa ta ka tara solor ba lia te katoe goen.” ");
INSERT INTO hla_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Be Iesu e poe lelena, “Te ngile moa limiu alia, ba limiu te hengoe mou u ranga i tar. ");
INSERT INTO hla_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ba lia te rangatse gou e Tamar ba nonei te hala ranei limiu a tana Hihitaguhu, u Namnameina turu mana te go mi ka gono nitoa meraio limiu. ");
INSERT INTO hla_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","A barebanana tara markatona i puta e ma antunan lue rien, taraha nori e ma tare rien na ma atei sil hase rien. Kaba alimiu e atei sile men, taraha nonei e ka gono mera nolimiu na nonei e ka has noa i torimilimiu. ");
INSERT INTO hla_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Alia e ma tatei la ba ragoi limiu ba limiu te heremi a pien a binaui. E moa. Alia e la pouts uaguma romana i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tara tsitabubun poata ba barebanana tara markatona i puta te ma tara lele roi lia, kaba alimiu te tare molia. Taraha, alia e toatoa pouts gou na limiu has. ");
INSERT INTO hla_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","A poata e butu nama romana ba limiu te na atei peisa namou romana alia e ka gia tere Tamar na limiu e ka has uamiu i tar na lia e ka has uagu i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“A katun te hengoena u ranga i tar ba te kukutie nen, nonei a katun teka te ngile nolia. Be Tamar te ngil hase nou a katun te ngile nolia, na lia has e ngile goen ba lia te hatare goien a peisar.” ");
INSERT INTO hla_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Be Judas te halhalia tere Judas Iskeriot e poiena tere Iesu, “O Tsunono, aha te hatara peisa sile moi lö a peisam i tamulam ba te ma hatara nami a peisam tara barebanana tara markatona i puta?” ");
INSERT INTO hla_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Be Iesu e ranga palisina i tanen me poiena, “Taraha, alimiu e hengoemiu u ranga i tar. A katun te ngile nolia e hengoe nou u ranga i tar. Be Tamar te ngil hase noen, na lam mere Tamar e la has uamuma romana i tanen ba te mi ka gono memen. ");
INSERT INTO hla_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kaba a barebanana tara markatona i puta e ma hengoeri u ranga i tar. A katun te ma ngile nei lia e ma hengo hase nei u ranga i tar. Nu ranga te hengoe milimiu u ma habutei lia. E Tamar te hale molia te habutu mame ien. ");
INSERT INTO hla_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Alia e hatei ragi limiu a man ka teka tara poata te ka gono noa mera gia lia limiu. ");
INSERT INTO hla_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Be Tamagulia te hala nenama romana u Namnamei u Goagono te go mi lu a makum i tar. Nonei e taguhu rano limiu ba te mi hatuts ranei limiu a man ka hoboto, ba te mi haka poutsena romana a man ka hoboto tu hatei rilia limiu i bakumilimiu. ");
INSERT INTO hla_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Alia e la ba tala rago limiu ba lia te hala ragi limiu a masalohana, a masalohana peisa i tar. A barebanana tara markatona i puta e ka mer a masalohana peisa i taren. Kaba a masalohana i tar e niga balana tara masalohana i taren. A torimilimiu e go ma tokui ne go ma matout hasi. ");
INSERT INTO hla_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Alimiu e hengoe mula alia e poie gula i tamilimiu, ‘Alia e la talagu, kaba lia e la pouts has guma romana i tamilimiu.’ Te ngile moa limiu alia, alimiu e sasala memou te la uagu lia tere Tamar, taraha e Tamar te pan nano lia. ");
INSERT INTO hla_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Alia e hatei tala ragu lei limiu a ka teka i mam te na butu noen, ba poata te butu hamana noen ba limiu te hamana mia romana i tar. ");
INSERT INTO hla_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Alia e ma tatei ranga hapara lelgi i tamilimiu, taraha nonei a kapan tara han i puta teka e la nama. Nonei e moa ta nitagala te ga haka puta menien lia. ");
INSERT INTO hla_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Kaba a barebana tara han i puta e gi atei sil alia e katoegu a mamana ka hoboto te hatei nei lia e Tamar te go kati lia, taraha alia e ngile iegu e Tamagulia. “Takei tala iam. Ara gi la.” ");
INSERT INTO hla_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Be Iesu e ranga lelina me poiena, “Alia u roein gerep hamana, ne Tamar e here nei a katun terena kuin gerep. ");
INSERT INTO hla_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Hena, a katun e roron ngats ba nena u hikalanin gerep hoboto te ma huari. Na nonei e kato hagogoso sil hase nei a hikalan te huana te go hua hapara lel uen. U katun te hamana uar i tar e hereri u hikalan te huar, nu katun te ma hamana uari i tar e hereri u hikalan te ma huari. ");
INSERT INTO hla_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Alimiu e here talemi a hikalan te gogosona, taraha alimiu e hengo hanigemiu u ranga i tar. ");
INSERT INTO hla_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Alimiu go ka gono memo lia ba lia te ka gono has mera golimiu. A hikalan e ma antunan hua pepeisa nei. Nonei e ga rokoto noa hasia i tuanreina u roei ba te toan huana. Ne kato has uana i iesana i tamilimiu. Alimiu e ma antunan katoemi ta markato ta niga te go ma ka gono mena milimiu alia. ");
INSERT INTO hla_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Alia u roei na limiu u hikalan. Te rokotona a hikalan turu roei ba te ka mena a nitoatoa i tanen, ba nonei te toan hua haparana. Ne kato has uana i iesana i tamilimiu. Te ka gono memia limiu alia ba lia te ka gono has mera golimiu, ba limiu te toan kato hanigemiu a man ka te ngilena e Sunahan. Kaba te la ba namia limiu alia, ba limiu te ma antunan kato nami ta toa ta ka te ngilena e Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","A katun te ma ka gono menei lia e ba nariou romana. Nonei e here nei a hikalanin roei te langona. U hikalan teka e goner ba te lapo ba naria turu tula ba te atsina. ");
INSERT INTO hla_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Te ka gono memia limiu alia na te hengo hanige mia limiu u ranga i tar, ba limiu te lue mou romana ta ka te singo sile mou limiu. ");
INSERT INTO hla_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Poata te katoe mia limiu a markato a niga ba te soloseiemiu e Tamar, ba limiu te haruto has namiu alimiu u katunun tsitsilo hamana i tar. ");
INSERT INTO hla_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Alia e ngil koru rago limiu te mar ngil koru has mena nei e Tamar alia. Na limiu go ka gono has memo lia ba lia te ngil koru noa has rago limiu. ");
INSERT INTO hla_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Te hengo hanige mia limiu u ranga i tar ba lia te ngil koru noa has rago limiu, te mar ngil mena nei e Tamar alia, taraha alia e hengo hanige iegu u ranga i tanen. ");
INSERT INTO hla_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Alia e hatei ragu lei limiu u ranga teka ba limiu te tatei sasala uamiu te mar sasala has uagu lia, ba te sasala nitoamiu. ");
INSERT INTO hla_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Alia e hatei rago limiu: alimiu go hiangilngil uam te mar ngil has mera gilia alimiu. ");
INSERT INTO hla_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Te mate silena a toa katun a ma tsomi i tanen, nonei e haruto nena nonei e ngil soku koru ranen. E moa noa has tu ngil te ga antunaia turu mar ngil teka. ");
INSERT INTO hla_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na te hengo hanige mia limiu u ranga i tar, alimiu a ma tsomi i tar. ");
INSERT INTO hla_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Alia e ma ngö lel ragi limiu u katunun kui, taraha a katunun kui e ma atei sile nei a ka te katoena a katunun hakui i tanen. Kaba alia e ngö tala ragi limiu a ma tsomi i tar, taraha alia u hatei hakapa rilimiu u ranga hoboto te hatei e Tamar alia. ");
INSERT INTO hla_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Alimiu u ma hopu kap namoi lia te go pan u lia i tamilimiu. E moa. Alia u hopu kap rio limiu te go kukute mena milimiu alia. Na lia e hala tala mera goi limiu te go na kato mena milimiu u ngil tere Sunahan. Ba limiu te ma tapusun katoe moien. Ne Tamar e hala ranoi limiu a man ka te singo sile moa limiu i tanen te ka uami limiu i tar. ");
INSERT INTO hla_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na lia e hatei lel rago limiu: alimiu go hiangilngil iam.” ");
INSERT INTO hla_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","E Iesu e ranga lel me poiena, “Poata te raharaha raroa romana a barebana te ka mer u hakatsina i puta alimiu, ba limiu te hakats pouts namiu ti raharaha mam menien lia. ");
INSERT INTO hla_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sanena te go ka memia limiu u hakatsina i puta, a barebana te ka mer u hakatsina i puta sane ngil rario limiu. Kaba e moa tala. Nori e ma ngil raroi limiu, taraha alia u hopu kap rio limiu te go halhal uam limiu i taren. Na nori e raharaha tala rario limiu, taraha alimiu e ma katun uami i taren. ");
INSERT INTO hla_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Alimiu go hakats pouts niam u ranga te hala ragu lei lia alimiu: a katunun kui e ma pan nanei a tsunono i tanen. Nori u katun ti kato homia i tar e kato homi has rariou romana limiu. Nu katun te hengo hanige ier u ranga i tar e hengo haniga has rario limiu. ");
INSERT INTO hla_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nori e katoe riou romana a man ka teka i tamilimiu, taraha alimiu u katun i tar. Nori e katoe roen, taraha nori e ma atei sileri e Sunahan te haleie molia. ");
INSERT INTO hla_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Sanena alia tu ma la mei ba te ma hatei ragien u ranga i tar, sane moa ta katun te ga poei, ‘Nori e kato homir.’ Kaba alia u la hamanama me mi hatei ragien u ranga i tar, na nori e moa tala te gi tatei hamous menien u markato u omi i taren. ");
INSERT INTO hla_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","A katun te omie nolia e omi hasena e Tamar. ");
INSERT INTO hla_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Alia u kato a man mirakul i mataren, a man mirakul te mamala katoei ta tan ta katun. Sanena alia tu ma katoei a man mirakul teka, sane moa ta katun te ga poei, ‘Nori e kato homir.’ Kaba nori i tara hakapi a man toukui i tar, na nori e omi noa hase rio lia ne Tamar has. ");
INSERT INTO hla_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nori e mar kato uar teka ba te kato hamaner u ranga ti koloto nia turu Buk u Goagono i taren te poiena, ‘Alia u ma katoi ta ka ta omi, kaba nori i omi noa haseio lia.’ ");
INSERT INTO hla_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Kaba lia e na hala mena gumei romana a katunun hitaguhu i tamilimiu, ba nonei te mi hatei nano lia. Nonei u Namnamei te ranga hamanana, u Namnamei tere Tamar, na e la nama romana tere Tamar. ");
INSERT INTO hla_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na limiu has te hatei namou romana lia, taraha alimiu tu ka gono meio lia tu tanian kui mamia lia ba te noana i romana.” ");
INSERT INTO hla_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Be Iesu e ranga noana me poiena, “Alia e hatei ragu lei limiu u ranga teka, taraha alimiu e namos hapolase molia te butuna romana a poata a omi. ");
INSERT INTO hla_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nori e hapiu ba raroi romana limiu u luman lotu, na nori e kato hamate has rariou a palai i tamilimiu ba te poier, ‘Alam u kato bei e Sunahan a ka teka.’ ");
INSERT INTO hla_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nori e katoe riou romana a man ka man omi teka, taraha nori e ma atei sile roi lia ne Tamar has. ");
INSERT INTO hla_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Alia e hatei ragi limiu a man ka teka i romana, na tara poata te butu hamana noen romana, ba limiu te hakats namou u ranga tu hala mam rilia alimiu.” Be Iesu e poiena, “Alia u ma hatei rilimiu a man ka teka i mam, taraha alia u ka gono meriu limiu. ");
INSERT INTO hla_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Na lia e la pouts uagou tere Tamagulia, nonei te haleie molia. Kaba alimiu e ma rangatse moi lia, ‘Ime te la uamu lö?’ ");
INSERT INTO hla_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","E moa. Alimiu e tatagi koru noa has nemiu te hala mena gulei lia u ranga teka. ");
INSERT INTO hla_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kaba alia e hatei hamana rago limiu, e nigana i tamilimiu te la pouts uagu lia. Te ma la goi lia, a katunun hitaguhu e ma tatei la uana mei romana i tamilimiu. Kaba te la pouts uagou lia, ba lia te toan hala negu men romana i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na poata te la namen romana, ba nonei te mi haruto ranei a barebana te ka mer u hakatsina i puta a mouna a markato a omi, na mouna a markato a niga, nu mouna u kot tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nori e hahamana nario lia, na ka teka a mouna a markato a omi. ");
INSERT INTO hla_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Na lia e la pouts uagou tere Tamar, ba limiu te ma tara lele moi lia. A ka teka e haruto nena alia a mouna a markato a niga nu ranga i tar e manana. ");
INSERT INTO hla_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ne Sunahan e tsimou ranou romana a barebanar i puta, taraha nonei e hopu kap hakapein a nihahuna tara katun te panna tara han i puta teka, nonei e Satan. ");
INSERT INTO hla_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“U ranga u para te ka noana, kaba alimiu e ma antunan lu noa namien. ");
INSERT INTO hla_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kaba poata te la nama u Namnamei u Goagono, nonei te ranga hamana nou romana, na nonei te mi haruto ranoi limiu a mamana ka te manana. Taraha, nonei e ma la mena mei romana a ranganen. E moa. Nonei e hatei nanou romana u ranga te hengoe nen tere Tamar. Na nonei u Namnamei u Goagono e hatei ranoi romana limiu a man ka te butu nou romana i murimuri. ");
INSERT INTO hla_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nonei e hapane nou romana lia, taraha nonei e haruto ranoi limiu a man ka i tar. ");
INSERT INTO hla_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","A mamana ka hoboto te teiena e Tamar e tei hase gulia. Nonei te poe begu lei lia, ‘Nonei e haruto ranoi limiu a man ka i tar.’” ");
INSERT INTO hla_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Be Iesu e ranga lelina me poiena, “A tsitabubu ba limiu te ma tare moi lia. Na tsitabubu lel ba limiu te tara poutse molia.” ");
INSERT INTO hla_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ba palabir u katunun tsitsilo i tanen e hiararangar me poier, “Ime te mouna uana u ranga teka? Nonei e poie lala, ‘A tsitabubu ba limiu te ma tare moi lia, na tsitabubu lel ba limiu te tara poutse molia.’ Na nonei e poe hase lala, ‘Alia e la pouts uagou tere Tamar.’ ");
INSERT INTO hla_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ime te mouna uana u ranga te poe lalen, ‘A tsitabubu’? Ara e ma atei sile rei a ka te ranga nanen.” ");
INSERT INTO hla_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","E Iesu e atei sil nori i ngilin rangatsen, ba nonei e poiena i taren, “Alimiu e hiarangarangata namiu ime te mouna uana u ranga te hagou ranga nagu lalia? ");
INSERT INTO hla_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","U mana koru alia e ranga hamana mera golimiu, alimiu e tabe mou, kaba a barebana te ka mer u hakatsina i puta e sasala riou. Alimiu e tatagi mam mou, na limiu e na sasala moto mou romana. ");
INSERT INTO hla_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Poata te katsin pose iena a tahol a pien, nonei e kamitsina, taraha a tou posa i tanen e sukusukuna. Kaba poata te butu hakapana a pien, nonei a tahol e solopalena u kamits, taraha nonei e sasala miena te posa hakapa mena lale ien a pien. ");
INSERT INTO hla_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ne kato has uana i iesana i tamilimiu. Alimiu e tatagi has mou, kaba alia e tara pouts ragou romana limiu. Ba limiu te toan sasala koru mou, ne moa ta katun te ga tatei lu ban a nisasala i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Nonei tara poata te la nama, alimiu e ma rangarangata lele moi romana lia. U mana koru alia e ranga hamana mera golimiu, alimiu go singo sile iam ta ka tere Tamar te katun uam limiu i tar, ba nonei te hala rano ien limiu. ");
INSERT INTO hla_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","I manasa na te noana i romana alimiu u ma singo silemi ta ka tere Tamar te katun uam limiu i tar. Singo tala iam, ba limiu te lue moen romana, ba limiu te toan sasala nitoa mou.” ");
INSERT INTO hla_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Be Iesu e ranga noana me poiena, “Alia e haharoei tun gula i tamilimiu. Kaba i murimuri alia e ma tatei haharoei lelgi. E moa. Alia e ranga halesala tun nagou e Tamar. ");
INSERT INTO hla_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nonei tara poata, alimiu e singo uamou romana tere Sunahan te katun uam limiu i tar. Alimiu e ma ngil lele moi te go singo beme rilia alimiu tere Tamar. ");
INSERT INTO hla_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Taraha, e Tamar e ngil has rano limiu. Nonei e ngil mera nei limiu alimiu e ngil hase molia na limiu e hamana hasemiu tu la uama lia i tanen. ");
INSERT INTO hla_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Alia u la ba nema e Tamar me la uaguma i puta teka. Na lia e la ba pouts tala nagou a han i puta ba te la pouts uagu tere Tamar.” ");
INSERT INTO hla_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Bu katunun tsitsilo i tanen e poier, “Alö e ranga halesala talam ba te ma haharoei lelmi. ");
INSERT INTO hla_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Alam e atei talam alö e atei silem a mamana ka hoboto. Alö e atei silem a ka te ngilin rangata nemu lam, na lam e ma ngilin rangata lel nami lö ta ka. Ba lam te hamanem tu la uama lö tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Be Iesu e hohou rangatana me poiena i taren, “Alimiu e hamana haniga talamiu? ");
INSERT INTO hla_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","A tsitabubu patu ba limiu hoboto te bus kalakala pouts uamou turu han i tamilimiu ba lia te ka pepeisa gou. Kaba alia e ma ka pepeisa koru goi, taraha e Tamar e ka gono meno lia. ");
INSERT INTO hla_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Alia e mar ranga uagula teka i tamilimiu ba torimilimiu te tatei gegahana, taraha alimiu e hamane molia. E manana, a markatona i puta teka e habutse nou romana u kamits i tamilimiu, kaba alimiu go ongolo noa has iam, taraha alia u karasa hakapi a markatona i puta.” ");
INSERT INTO hla_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","E Iesu e ranga hakapaia turu katunun tsitsilo i tanen me tara sei uana i Kolö me poiena, “O Tamagulia, a poata e butu hamanasa talana, a poata tu ranga mamin lö. Alö go hapane molia, alia a pien i tamulö, ba lia te tatei hapan hase golö. ");
INSERT INTO hla_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Alö u katoei lia a tsunono tara katun hoboto, ba lia te antunan hala nagia a nitoatoa te ka nitoana turu katun hoboto tu hala ramei lö alia. ");
INSERT INTO hla_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","U katun te atei sile rio lö na lia, e toatoa nitoa riou romana, taraha alö a toa koru a Sunahan te manana, na lia e Iesu Kristo tu haleie malö. ");
INSERT INTO hla_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Alia u hapaneio lö i puta, taraha alia u kato a mamana ka hoboto tu hatei lö alia. ");
INSERT INTO hla_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Tamagulia, alö go hala tale moi lia a nikapan i rehimulö tu ka mei lia i mam te butuia a han i puta. ");
INSERT INTO hla_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Alö u hopu kap meri u katunur i puta teka te gi katun uen i tar. Na lia u haruto nia lö i taren. Nori a galapien i tamulö na lö u hala mera meien i tar. Na nori e hengo hanige ier u ranga i tamulö. ");
INSERT INTO hla_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nori e atei sil tale ier a mamana ka hoboto te ka megu lia e lama i tamulö. ");
INSERT INTO hla_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Na lia u hala hakapa rien u raranga tu hale mei lö alia, ba nori te hamane ren. Na nori e atei siler alia u la hamanama i tamulö, na nori e hamaner tu hala mena mei lö alia. ");
INSERT INTO hla_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Alia e singo bera gien i tamulö. Alia e ma singo beragi a barebanana tara markatona i puta, kaba alia e singo beregu u katun tu hale mei lö alia, taraha nori u katun i tamulö. ");
INSERT INTO hla_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","U katun hoboto i tar e katun has uar i tamulö, nu katun hoboto i tamulö e katun has uar i tar. Na nori e haruto ner a nikapan i tar. ");
INSERT INTO hla_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Alia e la tala uagou i tamulö. Alia e ma ka lel goi tara han i puta, kaba nori e kaka ria i puta. O Tamagulia, alö te goagono korum, alö go tara kap ren tara nitagala i tamulö, nori u katun tu hala ramei lö alia. Ara e here rei a toa katun. Na lia e ngilegu nori gi here hasi a toa katun. ");
INSERT INTO hla_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Poata tu ka gono merien lia, alia u tara kap ren tara nitagala i tamulö. Alia u tara kapir u katun tu hala ramei lö alia, ne moa te gi taia uen. A toa puku te taia nou. Nonei e taia nou, taraha u Buk u Goagono e mar hatei mam menien teka. ");
INSERT INTO hla_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na lia e la tala uagou i tamulö. Alia e katoegu u ranga teka i puta ba nori te sasala nitoa has uar te sasala uagu lia. ");
INSERT INTO hla_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na lia u hala rien u ranga i tamulö. Na barebanana tara markatona i puta e omi raren, taraha nori e here rilia: alia e ma katun uagi tara markatona i puta, na nori e ma katun has uari tara markatona i puta. ");
INSERT INTO hla_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Alia e ma rangata sile goi lö te go lu ba merien lö tara han i puta teka. E moa. Alia e rangata silegu te go hatongo kap merien lö tara nitagala tere Satan. ");
INSERT INTO hla_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Alia e ma katun uagi tara markatona i puta, na nori e here rilia. Nori e ma katun has uari tara markatona i puta. ");
INSERT INTO hla_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nu ranga i tamulö e mana nitoana. Alö go ranga hahengo ren ba nori te hatalis ba ner a markato a omi hoboto. ");
INSERT INTO hla_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Alö u hala mena moi lia tara barebana te ka mer u hakatsina i puta, ba lia te hala uas mera goi u katun teka tara barebana te ka mer u hakatsina i puta. ");
INSERT INTO hla_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na lia e hala menagi a peisar i tamulö te go taguhu meri lia u katun teka, taraha alia e ngilegu nori gi katun hamana has u i tamulö. ");
INSERT INTO hla_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Na lia e singo bera gien i tamulö, na lia e singobe has regu u katun te hengoe riou romana u ranga i taren ba te toan hamana uarima i tar. ");
INSERT INTO hla_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Alia e singo silegu nori gi here hobotoi a toa katun. O Tamagulia, alö na lia e tori rei i iesana, Na nori has e gi tori u i iesana te mar kato has uara ra. Nori gi ka mei u toa u tori, ba barebanana i puta te tatei atei sil haser tu hala mena mei lö alia. ");
INSERT INTO hla_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na lia e hala ragien a nikapan tu hala hase mei lö alia. Taraha, alia e ngilegu nori e gi tori u i iesana te mar tori iesana has uara ra. ");
INSERT INTO hla_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Alia e ka gia i taren na lö e ka has mia i tar, ba nori te tatei tori iesana hoboto korur. E kato uana teka ba barebanana i puta te tatei atei siler tu hala mena mei lö alia, ne tatei atei sil haser alö e ngil koru rem u katun teka te mar ngil mena milö alia. ");
INSERT INTO hla_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“O Tamagulia, alö u hala rema u katun teka i tar, na lia e ngilegu nori e gi ka gono meio lia tara makum te na ka goa romana lia. Ba nori te na tare riou romana a nikapan i tar, a nikapan tu hale mei lö alia, taraha alö u ngil koruio lia i mam te butuia a han i puta. ");
INSERT INTO hla_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Tamagulia, alö e matskö korum. Na barebanana tara markatona i puta e ma atei sile roi lö. Kaba alia e atei sile golö. Na nori u katun i tar teka e atei siler tu hala mena mei lö alia. ");
INSERT INTO hla_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Alia u haruto nia lö i taren, na lia e kato noa hase goen tara mamana poata. Taraha, alia e ngilegu nori gi hiangilngil te mar ngil has mena milö alia. Na lia e ka goa romana i taren.” ");
INSERT INTO hla_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","E Iesu e singo hakapa u tara Tsunono ba te la merena u katunun tsitsilo i tanen i hapalana a tsi ramun olo i Kitron, ba nori te la uar tara kuin olip. ");
INSERT INTO hla_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","E Judas, a katun te ga harutein e Iesu turu katun ti omien, e atei sil te kana a makum teka, taraha e Iesu e roron hagum gono mer u katunun tsitsilo i tanen tara makum teka. ");
INSERT INTO hla_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Be Judas e lu rena u soldia nu katunun taratarakap tara Luman Lotu Pan ti hala rema u pris pan nu Parisi, ba nonei e peigi mera neien tara makum te kaia e Iesu. Na nori i la mei a lam nu bito na man kan hiatatung. ");
INSERT INTO hla_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","E Iesu e atei sil a man ka hoboto te ga butuia i tanen. Ba poata ti tukuia a pal katun teka, be Iesu e tatago rena men me poiena, “Alimiu e sakiemiu esi?” ");
INSERT INTO hla_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ba nori e poier, “E Iesu ni Nasaret.” Be Iesu e poiena, “Alia e Iesu.” ");
INSERT INTO hla_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Poata te poien, “Alia e Iesu,” be Judas nu katun ti ka gono meien e tatulan hatoumurir ba te tsiar i puta. ");
INSERT INTO hla_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Be Iesu e rangata lelina, “Alimiu e sakiemiu esi?” Ba nori e poier, “E Iesu ni Nasaret.” ");
INSERT INTO hla_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Be Iesu e poiena, “Alia e hatei hakapa ragu lolimiu alia nonei e Iesu. Te sakie milimiu alia, ba limiu te hala ba ramiu a palabir u katun teka.” ");
INSERT INTO hla_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nonei e ranga u teka te go kato hamana menien u ranga te hagou ranga nen te poien, “O Tamagulia, alia u ma hapolasei ta toa ta katun tu hale mei lö alia.” ");
INSERT INTO hla_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Be Saimon Pita e lousena u kilatan hiatatung i tanen me ngats sukena a katunun kui tara tsunono pan turu pris me ngats sekilena a talinganen tara pal matou. A solona katun teka e Malkus. ");
INSERT INTO hla_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Be Iesu e poiena tere Pita, “Alö go hasogo poutsi u kilatan hiatatung. Nonei a kamits teka te hopu kap bei e Tamar alia. Alia e ma tatei ramagi.” ");
INSERT INTO hla_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","13","Ba kepten tara ami nu soldia i tanen nu katunun taratarakap tara Luman Lotu Pan e pile kap ner e Iesu me kits naren, ba nori e piou mam narien tere Anas. E Anas nonei e tamana a tahol tere Kaiapas, a tsunono pan turu pris turu hiningal teka. ");
INSERT INTO hla_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nonei e Kaiapas te ranga mei a pal kapan turu Jiu me poiena, “E nigana te mate sil mena nei a toa puku a katun a barebana hoboto.” ");
INSERT INTO hla_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Be Saimon Pita na lia u kukutieto e Iesu. Ba lia e la gono miegu e Iesu tara pal porina luma tara tsunono pan turu pris, taraha a tsunono teka e atei sileio lia. ");
INSERT INTO hla_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kaba e Pita e na kaia i ielesala i rehina tamana tara ololo. Ba lia e la poutsugu me ranga gono megu a tahol te pepeito kapin a tamana tara ololo ba te hatasuegu e Pita i iahana ololo i pal porina luma. ");
INSERT INTO hla_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ba nonei a tahol e poiena tere Pita, “Alö has a katunun tsitsilo tere Iesu, boka?” Be Pita e poiena, “E moa.” ");
INSERT INTO hla_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","U katunun kui nu katunun pepeitokap i hats u tula, taraha a han e hamuri. Ba nori e tuol hahiser u tula ba te meimeir. Be Pita e ka gono mera nen ba te meimei hasina. ");
INSERT INTO hla_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ba tsunono pan turu pris e rangrangatse nei e Iesu u katunun tsitsilo i tanen na mar hihatuts i tanen. ");
INSERT INTO hla_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Be Iesu e poiena i tanen, “Alia u roron rangaia i matana barebana. Na lia u roron hihatutsia turu luman lotu u tetenei na tara Luman Lotu Pan, a man makum ti roron gono hobotoia u Jiu. Na lia u ma raranga hamousi. ");
INSERT INTO hla_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Aha te rangrangata sile milö alia? Alö go rangater u katun ti hengoio lia. Nori e atei siler a man ranga tu hatei rien lia.” ");
INSERT INTO hla_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Poata te ranga nia e Iesu a ka teka, ba toa katunun pepeitokap te tuolia i sukusuku e tapale nen me poiena, “Alö go ma ranga uai teka tara tsunono pan turu pris!” ");
INSERT INTO hla_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Be Iesu e poiena i tanen, “Te ranga homi gula lia, ba lö te hatei nem u ranga te omi lala. Kaba te ranga haniga gula lia, alö e moa te go tapala menoi lia.” ");
INSERT INTO hla_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","E Iesu e ka noa mei a kits, be Anas e hala mena neien tere Kaiapas, a tsunono pan turu pris. ");
INSERT INTO hla_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","E Pita e meimei noaia turu tula, ba barebana e poier i tanen, “Alö has a toa katunun tsitsilo tere Iesu, boka?” Be Pita e holisina me poiena, “E moa!” ");
INSERT INTO hla_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ba toa katunun kui tara tsunono pan turu pris, a tou sungutuna a katun te ngats sekilema e Pita a talinganen, e poiena tere Pita, “Alia e poiegu alia e tara ragu molimiu mere Iesu tara kuin olip.” ");
INSERT INTO hla_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Be Pita e holis lelina me poiena, “E moa!” Ba keriau a tson e toan kekeretsköna. ");
INSERT INTO hla_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tara lunlan koru ba nori e la ba ner a luma tere Kaiapas me piou naria e Iesu tara luma tere Pailat a Gamman. Bu Jiu e ma la soku uari i iahana luma, taraha u lo i taren e poei a katun te tasuna i iahana luma tara katun halhal turu Jiu e ma tatei noue nei a kannou turu Paska turu Jiu. ");
INSERT INTO hla_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Be Pailat e lakasa uana i taren me poiena, “Alimiu e kot memi a katun teka aha?” ");
INSERT INTO hla_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ba nori e poier i tanen, “Sanena a katun teka te ma kato homii, alam sane ma tatei piou namien i tamulö.” ");
INSERT INTO hla_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Be Pailat e poiena i taren, “Alimiu go lue men ba te kot memen turu lo peisa i tamilimiu.” Bu Jiu e poier, “Alam e ma tatei kato hamatiemi a katun.” ");
INSERT INTO hla_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","A ka teka e kato hamanei u ranga tere Iesu te ranga mam nen nori e na hakutie rien romana tara koruse, taraha u Rom peisa te tatei mar kato uar teka.* ");
INSERT INTO hla_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Be Pailat e tasu poutsuna i iahana luma me ngöena e Iesu me poiena i tanen, “Alö a King turu Jiu?” ");
INSERT INTO hla_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Be Iesu e rangatana me poiena, “Alö peisa te hakats nem a ka teka, tsi alö toum u hengo nien tara tana katun?” ");
INSERT INTO hla_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Be Pailat e poiena, “Alia e ma Jiugi! A hun katun noa has i tamulö nu pris pan i taren te piou naria lö i tar. Saha ka a omi tu kato lö?” ");
INSERT INTO hla_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Be Iesu e poiena, “Alia a toa king, kaba alia u ma butun king uai i puta teka. Sanena te go king u lia i puta teka, u katun i tar sane hiatatung sile rio lia ba pal kapan turu Jiu te ma tatei pile kap naroi lia. Kaba alia u ma butun king uai i puta teka.” ");
INSERT INTO hla_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Be Pailat e poiena i tanen, “Kaba alö a king noa has, boka?” Be Iesu e poiena, “Aa, nonei a ka ti posa silei lia. Alia u tuhana sileia i puta te go hatei meri lia a barebana u Mana. U katun hoboto te ngiler u Mana e hengo hanige rio lia.” ");
INSERT INTO hla_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Be Pailat e poiena i tanen, “Aha nonei u Mana?” (Matiu 27:15-31, Mak 15:6-20, Luk 23:13-25) E Pailat e ranga hakapa me lakasa pouts uana turu Jiu me poiena i taren, “Alia e ma sabiegi ta ka ta omi tara katun teka. ");
INSERT INTO hla_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tara mamana hiningal alimiu u roron rangata sile milia te go hapurese meni lia a toa karabus i tamilimiu tara poata tara kannou turu Paska teka. Alimiu e ngil hasemiu te go hapurese pouts meni lia nonei a King turu Jiu?” ");
INSERT INTO hla_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ba nori e ku hapanir me poier, “E moa te gi hapurese meni a katun teka! Alö go hapurese e Barabas!” E Barabas nonei a katun te roron atungir u katun ba te kopuna. ");
INSERT INTO hla_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Be Pailat e luena e Iesu me halahus nanen. ");
INSERT INTO hla_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Bu soldia e hil haperperere ier a kolits a hihitoka, ba nori e hake rien i bakunen me hasoge rien u hasobu a holnen te la sei. ");
INSERT INTO hla_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nori i katon hahakos tunia tere Iesu ba te kato here narien a king. Ba nori e la uar i rehinen me poier, “Solosei iam a King turu Jiu,” ba nori e tapale rien a limaren. ");
INSERT INTO hla_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Be Pailat e lakasana i ielesala me poiena tara barebana, “Ruto iam! Alia e lu halakasa mena gien i tamilimiu ba limiu te atei silemiu alia e ma sabiegi ta ka ta omi i tanen.” ");
INSERT INTO hla_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Be Iesu e lakasana i ielesala, e hasogena u hata u hihitoka nu hasobu a holnen te la sei. Be Pailat e poiena i taren, “Ruto iam! Nonei a katun teka!” ");
INSERT INTO hla_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Poata ti tareia u pris pan nu polis e Iesu ba nori e ku hapanir me poier, “Tapala namia tara koruse! Tapala namia tara koruse!” Be Pailat e poiena i taren, “Alimiu peisa te go lue men ba limiu te na tapala namien tara koruse. Alia e ma sabiegi ta ka ta omi i tanen.” ");
INSERT INTO hla_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bu Jiu e ranga palis uar i tanen, “Alam e ka mem a toa lo te poiena nonei e ga mate noa lasi, taraha nonei e poei nonei a Pien Tson tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Poata te hengoeia e Pailat a ka teka, ba nonei e matout koruna. ");
INSERT INTO hla_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ba nonei e tasu pouts uana i luma tara gamman me poiena tere Iesu, “Ime tu la malö?” Kaba e Iesu e ma palisei u ranga i tanen. ");
INSERT INTO hla_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Be Pailat e poiena i tanen, “A neha te ma ranga memi lö i tar? Alö e atei silem alia e ka megu a nikapan te go hapurese meni lia alö na nikapan has te go hatapala meni lia alö tara koruse.” ");
INSERT INTO hla_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Be Iesu e ranga palis uana i tanen me poiena, “Sanena e Sunahan te ma halei lö ta nikapan, alö sane moa hasem ta nitagala te go pita-puta meni lö alia. Kaba a katun te hapile nala loa lia i limamulö, a markato a omi i tanen e pan bala nena a markato a omi i tamulö.” ");
INSERT INTO hla_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Poata te hengoeia e Pailat a ka teka ba nonei e ngil koru talena te ga hapurese menien e Iesu ba te lana. Bu Jiu e kur me poier, “Te hapurese moa lö a katun teka ba te lana, alö e ma hahikapien lel uamoi tara Gamman Pan e Sisa! A katun te poiena nonei a king e paköena e Sisa.” ");
INSERT INTO hla_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Be Pailat e hengoena u ranga teka me lu halakasa mena nei e Iesu i ielesala me gumna turu gumgum tara tson hahamou turu ranga tara makum ti ngöei a Pulo Simel. Turu Ha-Hibru i ngö ien Gabata. ");
INSERT INTO hla_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nonei a pal soasa teka turu lan te gi hamatsköe ien a man ka turu Paska turu Jiu. Be Pailat e poiena turu Jiu, “Nonei a king i tamilimiu teka!” ");
INSERT INTO hla_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ba nori e ku lelir me poier, “Atung hamate iam! Atung hamate iam! Tapala namia tara koruse!” Be Pailat e rangata ranen, “Alimiu e ngilemiu alia e go hatapala nia a king i tamilimiu tara koruse?” Bu pris pan i ranga palisito me poier, “Alam e moa ta tana ta king. E Sisa lasi a toa!” ");
INSERT INTO hla_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Be Pailat e hapile rane ien e Iesu te gi tapala menien tara koruse. ");
INSERT INTO hla_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ba nori e luer e Iesu, ba nonei e soata peise iena a koruse i tanen me la ba nena a taun me la uana tara makum ti ngöei Lakö turu Baku. Turu Ha-Hibru i ngöe ien Golgota. ");
INSERT INTO hla_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","A makum teka nonei ti tapala nien tara koruse, ba nori e tapala has ner a tana elasolana katun tara tana huol a koruse, tabi i hapala na tabi i hapala, be Iesu te kana i hagus. ");
INSERT INTO hla_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Be Pailat e hakoloto nena a toa bun ranga me hake rien tara koruse. Na bun ranga teka e poei, “Iesu ni Nasaret, a King turu Jiu.” ");
INSERT INTO hla_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","U Jiu u para ti rit u ranga teka, taraha a makum ti tapala nia e Iesu tara koruse e ma lehana bani a taun. A bun ranga teka i koloto nia turu topisa u mar ranga: Ha-Hibru na Ha-Latin na Ha-Grik. ");
INSERT INTO hla_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bu pris pan turu Jiu e poier tere Pailat, “Alö e moa te go mar hakoloto menien teka: ‘A King turu Jiu.’ E moa. Alö go mar hakoloto menien: ‘A katun teka e poei, Alia a King turu Jiu.’” ");
INSERT INTO hla_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Be Pailat e ranga palisito me poiena, “U ranga te hakoloto nagu lalia i koloto hakapein.” ");
INSERT INTO hla_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","I murina poata ti tapala hakapa nia u soldia e Iesu tara koruse, ba nori e luer a man hasobu i tanen me molamole ieren tara tohats a makum, a toa soldianen ne na makum. Nori i lu hasi u hasobu u ngahangaha i tanen te moa ta samap i tanen. Nonei a toa makum a ohots. ");
INSERT INTO hla_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bu soldia e hiararangar me poier, “Ara gi ma kis kakate ien. Ara gi pilei satu sil tune ien ba ra te tare rou esi te lue noen.” A ka teka e butu sil te ga mana u u ranga turu Buk u Goagono te poiena: “Nori i molei a peisaren a man hasobu i tar. Ba nori e pilei satu siler esi te ga lu u hasobu u ngahangaha i tar.” Bu soldia i mar kato mena teien teka. ");
INSERT INTO hla_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","E tsinana e Iesu e tuol hasukusukuia i rehina koruse tere Iesu, ne toulana e tsinanen has, ne Maria nonei a tahol tere Klopas, ne Maria Matalina. Nori a pal tohaliou reka i ka hoboto. ");
INSERT INTO hla_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Be Iesu e tarena e tsinanen na lia a katunun tsitsilo te ngil korue ien alam u tuol hobotoia i rehinen. Be Iesu e poiena tere tsinanen, “Nonei a katunun tsitsilo teka a pien i tamulö.” ");
INSERT INTO hla_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ba nonei e poiena i tar, “E tsinamulö teka.” Na tara poata teka ba lia e lu menagi e Maria tara luma i tar te go na ka nitoa ien. ");
INSERT INTO hla_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","E Iesu e atei sil a mamana toukui i tanen e kapa. Bu ranga turu Buk u Goagono e butu hamanana te poien, “Alia e makagu.” ");
INSERT INTO hla_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","A kan osul te saputi u wain u melil e ka, ba nori e haputuer u magomagolo turu wain u melil me hake rien tara tsi kalan hisop, ba nori e hala mena rien i runguna e Iesu. ");
INSERT INTO hla_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Be Iesu e ousena a wain me poiena, “A toukui hoboto i tar e kapa talana.” Ba nonei e haturu pute iena a bakunen me matena. ");
INSERT INTO hla_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bu Jiu e rangatser e Pailat te go haniga merien te gi peko merien a man mour u katun ti kuteia turu koruse na te gi lu puta meri a peisaren turu koruse. I kato mei a ka teka taraha nonei u lan te gi hamatskö meien a man ka turu Paska turu Jiu, na nori i raman te gi ka u a tuanreiren turu koruse turu Lan u Goagono turu Jiu i mahö, taraha u lan teka e goagono koru. ");
INSERT INTO hla_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Bu soldia e lar me na pekoer a man mouna toa katun te kute gono mei e Iesu. Na nori i peko hasi a man mouna tabi te kaia i hapala. ");
INSERT INTO hla_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ba nori e la uarima tere Iesu me tarer e Iesu e mate hakapa, ba nori e ma pekoeri a man mounen. ");
INSERT INTO hla_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kaba toa soldia e sakei a liklikina e Iesu u saka. Bu rahatsing nu ramun e lakasa boroborona i ielesala. ");
INSERT INTO hla_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Alia e Jon tu tarei a ka teka alia u hatei hakapein u ranga. U ranga i tar e manana, na lia e atei hasegu te mana uana u ranga i tar. E kato uana teka ba limiu te tatei hamanamiu. ");
INSERT INTO hla_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","A ka teka e butu ba te kato hamanena u ranga turu Buk u Goagono te poiena, “E moa tu toa tu tsinö i tanen te gi tatei peko romana.” ");
INSERT INTO hla_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na u tana u ranga turu Buk u Goagono e kato uana, “U katun ti sake ien e tare roen.” ");
INSERT INTO hla_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Poata te kapaia a man ka teka, be Josep a katun tara taun i Arimatia e rangatsena e Pailat te go lu menien u tuanrei tere Iesu. E Josep a toa katunun tsitsilo tere Iesu, kaba nonei e matoutir u Jiu me hamousena a nihamana i tanen. Be Pailat e hanigana, be Josep e lana me na lu ba nena a tuanreina e Iesu. ");
INSERT INTO hla_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","E Nikodimas, a katun te la mam u tere Iesu tara bong, nonei e la gono mei e Josep, ba nonei e la mena a potsingina u huol u mar roei ti ngöei u mer na u alos. Nonei i sohala hobotsen na nitiama i tanen e antunaia tara 45 kilo. ");
INSERT INTO hla_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ba nori a elasolana katun i lueto a tuanreina e Iesu me pits gono merien u labalaba u lamelame te ka mei u potsing teka te soka haniga koru, te mar kato uar u Jiu te kaho mena rien a katun. ");
INSERT INTO hla_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","A toa kui te kaia i rehina makum ti kato hamatia e Iesu, na i iahana kui e kaia a kioun mate a tsimus. E moa noa ta toa te gi hongeia tara kiou teka. ");
INSERT INTO hla_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","U Lan u Goagono turu Jiu e sukusuku tala, ba nori e honge ria e Iesu i iahana kiou teka, taraha e kaia i sukusuku. ");
INSERT INTO hla_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tara bongbong koru turu lan tutun turu wik, Maria Matalina e la u tara kioun mate ba ka te kuhil noana. Ba nonei e tarena a hatu ti hapili kap nai a kiou i lu bani a matana kiou. ");
INSERT INTO hla_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ba nonei e pietana tere Saimon Pita na i tar has me poiena i tamulam, “Nori e lous halakase lila e Iesu tara kiou ba lam te ma atei silemi ime te na hake lilen!” ");
INSERT INTO hla_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ba lam mere Pita e la ba nem a han me la uam tara kiou. ");
INSERT INTO hla_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Alam a elasolana u pieta tun, kaba lia u pieta hatala ban e Pita me na tuku mam gia tara kiou. ");
INSERT INTO hla_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ba lia e turu putagu me taregu u labalaba u lamelame e ka, kaba lia u ma tasui i iogana. ");
INSERT INTO hla_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Be Saimon Pita e la hamurimuri nama i tar me la soku nitoana tara kiou, me tarena u labalaba ti pitsei a tuanreinen te opu nu labalaba ti pits hahis nia i bakuna e Iesu. Kaba e ma opu gono mei u labalaba ti pitsei a tuanreinen. Nonei e tapits noa has ba te opu pepeisana tara tana makum. ");
INSERT INTO hla_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Na lia tu tuku mamia tara kiou u toan tasu has, ba lia e taregu a ka teka me hamanagu. ");
INSERT INTO hla_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kaba lam u ma atei haniga sil koru noei u ranga turu Buk u Goagono te poiena nonei e ga takei poutsia tara tou mate i tanen. ");
INSERT INTO hla_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ba lam a elasolana katunun tsitsilo e la poutsum i han. ");
INSERT INTO hla_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","E Maria e tuku poutsia tara kiou ba te tuolna i ielesala me tabena. Nonei e tabe noa has ba te turu putana me tara uana i iahana kiou. ");
INSERT INTO hla_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ba nonei e tarena a elasolana angelo i ka mei u hasobu u hiaka, ba nori e gum ria tara makum te opuia u tuanrei tere Iesu, toa e gumia tara pal baku na tabi e gumia tara pal mou. ");
INSERT INTO hla_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ba nori e rangatse ren, “A tsi tahol, a neha te tabe sile mulö?” Be Maria e ranga palisina me poiena, “Nori e lu halhale lila a Tsunono i tar, na lia e ma ateigi ime te na hake lilen!” ");
INSERT INTO hla_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","E Maria e mar ranga u teka ba nonei e gamon habiritsina me tarena e Iesu te tuolia i sukusuku, kaba nonei e ma atei silei nonei e Iesu. ");
INSERT INTO hla_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Be Iesu e rangatse nen, “A tsi tahol, a neha te tabe sile mulö? Esi te sakie mulö?” E Maria e poei nonei a tson te taratara kapin a kui, ba nonei e poiena i tanen, “A tsi tsunono, tu lu halhale len lö, hatei moi lia ime tu na hake ien lö ba lia te na lue goen.” ");
INSERT INTO hla_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Be Iesu e poiena i tanen, “Maria!” Be Maria e habirits uana i tanen me poiena turu Ha-Hibru, “Rabonai!” U mar ranga teka e poiena, “Tson Hihatuts.” ");
INSERT INTO hla_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Be Iesu e poiena i tanen, “Alö e moa te go pile kap menai lia, taraha alia e ma la noa gulei i iasa tere Tamar. Kaba alö go la tara man hahatoulana i tar, a pal barebana te hamana ria i tar, ba lö te na hatei ramen alia e lagu i iasa tere Tamar ne Tamamilimiu has. Alia e lagu tara Sunahan i tar na Sunahan has i itamilimiu.” ");
INSERT INTO hla_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Be Maria Matalina e la talana me na ranga merena u katunun tsitsilo me poiena, “Alia e tara hakape guma a Tsunono!” Ba nonei e hatei has rate ien nonei u ranga teka te ranga mena meien e Iesu. ");
INSERT INTO hla_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nonei noa has turu lan, alam u katunun tsitsilo u matoutir u Jiu, me piliem u tamana tara luma tu kaia lam. A pitala e tsiruku hakapa nonei turu lan tutun turu wik teka, be Iesu e butuna me tuolna i gusumulam me poiena i tamulam, “Masalohana e tatei ka gono mera nolimiu.” ");
INSERT INTO hla_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nonei e ranga hakapa ba nonei e haruto ranei lam a man limanen na liklikinen. Ba lam u katunun tsitsilo u sasala koru mieto tu marei meni lam a Tsunono. ");
INSERT INTO hla_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Be Iesu e ranga lelina i tamulam me poiena, “Masalohana e tatei ka gono mera nolimiu. E Tamar e hala mena moi lia i puta ba lia te hala kalakala uas rago limiu.” ");
INSERT INTO hla_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nonei e mar ranga u teka ba nonei e husa uana i tamulam me poiena i tamulam, “Lu tale iam u Namnamei u Goagono. ");
INSERT INTO hla_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Te lu ba namia limiu u markato u omi turu katun, bu markato u omi teka te tiana. Te ma lu ba namia limiu u markato u omi turu katun, bu markato u omi teka te ma tatei tia has nei.” ");
INSERT INTO hla_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","E Tomas, nonei a toa i tamulam turu 12 u katun i ngö hasei “U Puna”, e ma ka gono merai lam poata te lama e Iesu. ");
INSERT INTO hla_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ba palabir u katunun tsitsilo e hateie ren me poier, “Alam e tara hakape muma a Tsunono.” Be Tomas e poiena i taren, “Te ma tare goi lia u uahil turu nila tara man limanen, na te ma tupa nagoi lia a kabeler tara man makum turu nila, na te ma tupa nagoi lia a limar i liklikinen, e moa te go tatei hamana u lia.” ");
INSERT INTO hla_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","I murina te kapaia u toa u wik, ba lam u katunun tsitsilo i tanen e ka lel mia i luma, ne Tomas e ka gono has merio lam. U tamana e pili, kaba e Iesu e tasuma me tuolna i gusumulam me poiena, “Masalohana e tatei ka gono mera nolimiu.” ");
INSERT INTO hla_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ba nonei e poiena tere Tomas, “Hakeia a kabelemulö teka, ba lö te tara uam tara man limar, ba lö te hasoa nem a limamulö ba te tupa namen i iogana i liklikir. Alö e moa te go hipus menai a nihamana, e moa. Kaba alö go hamana.” ");
INSERT INTO hla_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Be Tomas e ranga palis uana i tanen me poiena, “Alö a Tsunono i tar! Alö a Sunahan i tar!” ");
INSERT INTO hla_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Be Iesu e poiena i tanen, “Alö e hamana mem te tara mena milö alia. E Sunahan e kalala rena u katun ti ma tarei lia kaba e hamana noa hasir.” ");
INSERT INTO hla_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","E Iesu e kato u palair u mirakul u para i matamulam u katunun tsitsilo ti ma kolotoni i iahana u buk teka. ");
INSERT INTO hla_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","U ranga teka i kolotoni te go hamana mena milimiu e Iesu nonei e Mesaia a katun te hopu kapin e Sunahan, a Pien Tson tere Sunahan. Na te hamana uami limiu i tanen ba limiu te lu hase mou a nitoatoa i tanen. ");
INSERT INTO hla_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","I murina a poata teka e Iesu e butu lelia turu katunun tsitsilo i tanen tara Ramun i Galili te ngö haseri a Ramun i Taibirias. Nonei e mar butu u teka. ");
INSERT INTO hla_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Alam a palair u katunun tsitsilo i tanen u ka hoboto — e Saimon Pita, ne Tomas ti ngö hasei “U Puna”, ne Natanielina i Kena i Galili, na lam a galapien tson tere Sebedi, na elasolana lel. ");
INSERT INTO hla_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Be Saimon Pita e poiena i tamulam, “Alia e na hagala talagu.” Ba lam e poiem i tanen, “Alam e la gono has memo lö.” Ba lam e sua talam me na hagala halanim, kaba lam u ma sohe mei ta iena. ");
INSERT INTO hla_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","A ke sukusukun lunlan tala, be Iesu e tuolna i kotolana. Kaba alam u ma mareie ien. ");
INSERT INTO hla_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ba nonei e poiena i tamulam, “A galapien, alimiu e soho hase muma ta iena?” Ba lam e poiem, “E moa.” ");
INSERT INTO hla_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ba nonei e poiena, “Alimiu go lapo menami a abe tara pal matou, ba limiu te toan sohemiu ta iena.” Ba lam e lapo nem a abe me toan sohem a iena a para koru, ba lam e ma antunan las hasei namien tara tsi tolala. ");
INSERT INTO hla_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ba lia e poiegu tere Saimon Pita, “Nonei a Tsunono!” Ba poata te hengoeia e Pita u ranga teka, ba nonei e hasei boroborena u hasobu i tanen me kurapa uana turu ramun me ape sunguna. ");
INSERT INTO hla_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Alam u palaina u katunun tsitsilo u ma lehana ba koruni a kotolana, a tolima maloto a ngaha puku. Ba lam e sua hasung tala muma me las hapasa nem a abe te saputi a iena. ");
INSERT INTO hla_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Poata tu sung hakapaia lam, ba lam u tareto u tula na ma tsi iena ti höia i tanen, na beret e ka has. ");
INSERT INTO hla_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Be Iesu e poiena i tamulam, “La memuma ta iena te sohe muma limiu.” ");
INSERT INTO hla_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Be Pita e sei poutsuna tara tsi tolala me las hasungena a abe iena a saputu. A iena a kapan a para e ka, e antunaia tara 153, kaba a abe e ma tapusi. ");
INSERT INTO hla_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Be Iesu e poiena i tamulam, “Mi nou talam.” Na lam u ma rangatani nonei esi, taraha alam u atei sil nonei a Tsunono. ");
INSERT INTO hla_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Be Iesu e hanou ranei lam a beret na iena. ");
INSERT INTO hla_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nonei a hatopisana a poata teka te butuia e Iesu turu katunun tsitsilo i tanen i murina te takei pouts ien tara tou mate. ");
INSERT INTO hla_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Poata tu nou hakapaia lam, be Iesu e poiena tere Saimon Pita, “O Saimon, a pien tere Jon, alö e ngil hase molia? U ngil i tamulö e saluhiena u ngil turu katun teka?” Be Pita e poiena i tanen, “Aa, o Tsunono. Alö e atei silem alia e ngile golö.” Be Iesu e poiena, “Alö go tara kapir u tunan sipsip i tar, nori u katun u pinolasa i tar.” ");
INSERT INTO hla_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Be Iesu e rangata hahuolena e Pita me poiena, “O Saimon, a pien tere Jon, alö e ngil hamane molia?” Be Pita e poiena i tanen, “Aa, o Tsunono. Alö e atei silem alia e ngile golö.” Be Iesu e poiena, “Alö go hanour u sipsip i tar — alö go hatuts hanigeir u katun i tar.” ");
INSERT INTO hla_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Be Iesu e rangata hatopise iena e Pita me poiena, “O Saimon, a pien tere Jon, alö e ngil korue molia?” Ba torina e Pita e tiama tala mena te rangata hatopisa u e Iesu me poiena, “Alö e ngile molia?” Ba nonei e poiena tere Iesu, “O Tsunono, alö e atei silem a mamana ka hoboto, na lö e atei sil hasem alia e ngile golö.” Be Iesu e poiena i tanen, “Alö go taguhir a pal barebana i tar. ");
INSERT INTO hla_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","U mana koru alia e ranga hamana mego lö, a poata tu hitots noaia lö, alö u hula la mei u ngil i tamulö. Kaba poata te tsonpan mia romana lö, ba lö te na hasoe iem a limamulö bu palair u katun te kitse rio romana lö ba te na piou naria lö tara makum te raman la uamu lö.” ");
INSERT INTO hla_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","E Iesu e ranga u teka ba te haruto nena te mar solosei mena nei romana e Pita e Sunahan tara poata te atung hamate rien romana. Be Iesu e poiena i tanen, “Alö go la gono memo lia.” ");
INSERT INTO hla_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Be Pita e tanian la gono mena e Iesu, ba nonei e habiritsina me tare nolia tu kukute merien lia. Alia nonei a katun te ngil korui e Iesu, na lia tu gum hasukusukuia i tanen tara kannou me poiegu, “O Tsunono, esi nonei te haruto nano lö turu katun te paköe rio lö?” ");
INSERT INTO hla_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ba poata te tareia e Pita alia, ba nonei e poiena tere Iesu, “O Tsunono, aha te butuna romana tara katun teka?” ");
INSERT INTO hla_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Be Iesu e poiena i tanen, “Te ngile gia lia nonei ga toatoa hantunaia tara poata te kopis pouts guma romana lia, a ka teka e ma ka uanei i tamulö. Alö go la gono noa has meio lia!” ");
INSERT INTO hla_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","I murinen, u ranga te poei alia e ma tatei mategi romana e hula laia tara pal barebana tere Iesu. Kaba e Iesu e ma poei alia e Jon e ma mategi romana. E moa. Nonei e poe lasi, “Te ngile gia lia nonei ga toatoa hantunaia tara poata te kopis pouts guma romana lia, a ka teka e ma ka uanei i tamulö.” ");
INSERT INTO hla_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Alia e Jon, a katunun tsitsilo tere Iesu te koloto negu a man ka teka. Alia u tare ien ba te hatei nagen, na lam e atei silem te mana uana u ranga teka. ");
INSERT INTO hla_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ne Iesu e kato hasi a palabina man ka man para. Na sanena te gi koloto hoboto meni a man ka te katoen, a han i puta teka sane saputu piu toumuna romana turu buk. ");
INSERT INTO hla_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","O Tiopilas, alia e koloto lel uagu i tamulö. Turu buk mam* i tar alia u kolotein a mamana ka te kato e Iesu tara poata te hatanie ien a toukui i tanen, antunana tara poata ti lu sei pouts menai e Iesu i Kolö. I mam te la seien, nonei e hala sila nia u rangana tara toukui turu Namnamei u Goagono turu katun te hopu kap merien u aposol i tanen. ");
INSERT INTO hla_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","I murina a poata te mate hakapa ien, ba nonei e mi butuna turu aposol i tanen. Nonei e kato silei a man ka man para te go haruto merien nonei e toatoa hamanana. Nori i tare ien tara man toa toa man lan i iahana u 40 u lan, ba nonei e hatei rane ien a Nipepeito tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tara toa poata e Iesu e nou gono mer u aposel me poiena i taren, “Alimiu e moa te go la ba menami i Jerusalem, kaba limiu go hahalose iam u Namnamei u Goagono te ranga nema e Tamar te katsin hala rane ien limiu, tu hatei has rilia limiu. ");
INSERT INTO hla_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","E Jon e baptaisri u katun u ramun, kaba e moa te ga pina uen ba limiu te na habaptais moa romana turu Namnamei u Goagono.” ");
INSERT INTO hla_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na tara tana poata u aposol i gono hoboto lel mei e Iesu me rangatse ren me poier, “O Tsunono, aha tala? Alö e taguhe mou a han i tarara i Israel tara poata teka ba ra te pile peisa pouts has narou a peisarara?” ");
INSERT INTO hla_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Be Iesu e poieto i taren, “E Tamar e rama nena te go atei sil mena milimiu a poata tsi u hiningal te poa hapopo ien. Nonei peisa te poa hapopona a poata te butu noa a mamana ka. ");
INSERT INTO hla_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kaba u Namnamei u Goagono tere Sunahan e mi gumuna romana i tamilimiu ba nonei te hala ranoi limiu a nitagala. Ba limiu te na rararie moa romana lia i Jerusalem na turu han hoboto i Judia na i Sameria na turu han hoboto i puta.” ");
INSERT INTO hla_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","E Iesu e ranga hakapa tala ba nonei e la sei uana i iasa i matar u aposol, bu toa u koasi e hamouse nen ba nori i ma tara lele teien. ");
INSERT INTO hla_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nori i tara noa u i kolö tara makum te la ien, ba elasolana katun i songots bututo me mi tuol ria i rehiren, nu hasobu i taren e hiaka. ");
INSERT INTO hla_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ba elasolana katun e poier, “Alimiu u katunur i Galili, a neha te tuol sile mia limiu teka ba te tara uamiu i iasa i kolö? Alimiu e tara hakape mula te mar la ba mera laloi limiu e Iesu me la uana i Kolö. Nonei e kopis pouts has uanama romana te mar la uala len i Kolö.” ");
INSERT INTO hla_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","U aposol i la ban u Pokus tara Roein Olip ti ka ien me la poutsur i Jerusalem. A maroro teka e antunaia tara tsi niroro a tsi makmakum turu Jiu turu Lan u Goagono i taren. ");
INSERT INTO hla_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nori i tukuia i Jerusalem me na sei uar tara rum i iasa ti roron ka ien. Nori ere Pita mere Jon ne Jemis ne Endru, ne Pilip ne Tomas ne Batolomiu ne Matiu. Ne Jemis a pien tere Alpias, ne Saimon a katun te tagala bei a han i tanen, ne Judas a pien tere Jemis. ");
INSERT INTO hla_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","U katun hoboto teka i roron gono hoboto ba te singo uar tere Sunahan, ba nori i ka mieto u toa u hakats. Na tohaliou i ka gono has meren, ne Maria has e tsinane Iesu, nu toulane Iesu. ");
INSERT INTO hla_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","Tara poata teka u katunun tsitsilo tere Iesu i gono hoboto. Nori i antunaia tara 120 a katun. Be Pita e tuoluto i mataren me poiena, “A ma tsi hahatoulana i tar, u Namnamei u Goagono tere Sunahan e haranga e tuburara e Devit i manasa me ranga nena e Judas, a katun te piour u katun ti pile kapin e Iesu. U ranga teka e kana turu Buk u Goagono ba te tatei butu hamanana. ");
INSERT INTO hla_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","E Judas a toa katun i tarara i manasa, na nonei e pilein a toa toukui te ka mera ra.” E Pita e ranga u teka. ");
INSERT INTO hla_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","A hihol tara markato a omi tara katun teka i holi a toa makumun tsikitsiki. Ba nonei e Judas e rusuto ba gusunen e tabutuna ba torinen e talousuna. ");
INSERT INTO hla_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","U katun hoboto i Jerusalem i hengoin a ka teka me toan hake ier a solo turu tsikitsiki teka me ngöe rien i Akeldama. A solo teka e poiena “U Tsikitsikina turu Rahatsing.” ");
INSERT INTO hla_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Be Pita e poiena, “A toa makum turu Buk u Goagono te ngöeri u Sam e poiena, ‘A luma i tanen e tatei opingina romana, na e moa ta katun te ga tatei kaia i tanen.’ Nu Buk u Goagono e poe hasena, ‘A tana katun e tatei palise nen romana tara toukui i tanen.’ ");
INSERT INTO hla_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“E kato uana i romana a toa katun e ga tahongoia i tarara ba te na habulungana nena te takei pouts u e Iesu tara tou mate i tanen. Ara e ngil lasera a katun te lala hiton gono meri ra tara mamana poata te hula la gono meria ra e Iesu, tara poata e Jon e baptais ria a barebana e noana tara poata te la ba ria ra e Iesu ba te lana i Kolö.” ");
INSERT INTO hla_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ba nori e hopu kap ner a elasolana katun: a toa e Josep te ngöeri e Basabas na tana solonen e Jastas, na tana katun e Matias. ");
INSERT INTO hla_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ba nori te singo uar tere Sunahan me poier, “O Tsunono, alö e atei silem u hakats turu katun hoboto. Alö go haruto rilam a toa tara elasolana katun teka te hopu kap namu lö. ");
INSERT INTO hla_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Taraha, nonei e ga palis a toukui tara aposol te pile mamin e Judas. Taraha, nonei e rusia tara toukui teka me la uana tara makumun nihahuna i tanen.” ");
INSERT INTO hla_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ba nori e hongo hoboter a hihase tara elasolana, ba hihase tere Matias e talous mamuna. Ba nonei e tahongo talana tara 11 a aposol. ");
INSERT INTO hla_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Te butuma u Lan u Goagono ti ngöei u Pentikos,* bu katunun tsitsilo e ka hoboto ria tara toa makum. ");
INSERT INTO hla_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bu toa u ling e songots butu mato i Kolö me here namei u ualupu pan te olongoma, me saputena a hana luma hoboto ti gum ien. ");
INSERT INTO hla_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ba nori i tareto a ka te herei u kulupu me la kalakalana me na töna tara man toa man katun hoboto. ");
INSERT INTO hla_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ba nori e saputu hoboto mier u Namnamei u Goagono tere Sunahan, ba nonei e haranga ranen ba nori te toan töho hoboto ria turu man ranga halhal u para. ");
INSERT INTO hla_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","U Jiu u para turu han hoboto i kaia i Jerusalem, u Jiu hamana ti hengo u ranga tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ba poata ti ketaia u katunun tsitsilo, bu katun u para i hengoto me mi gono hobotor. ");
INSERT INTO hla_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ba nori i asingoto koruto me poier, “Ara a man toa man katun e hengoera u katun teka ba te töho ria turu mar ranga i tarara.” Ba nori e asingotor me poier, “U katun teka te rangar nori hoboto a tei Galili. ");
INSERT INTO hla_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Taraha tsiponi te hengo merei ra u katun teka ba te töho ria turu mar ranga i tarara? ");
INSERT INTO hla_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ara u katununa tara man provins i Patia na i Midia ni Ilam ni Mesopotemia ni Judia ni Kapadosia ni Pontas ni Eisia. ");
INSERT INTO hla_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","Na i Piritsia ni Pampilia ni Itsip na tara man makum i Libia te sukusuku uana i Sairini. Na palair u katununa i Rom, u Jiu hamana na pala halhal ti lu hasi u lotu turu Jiu, na palair u katununa i Krit na i Arebia. Ara hoboto e hengo raren ba nori te töho ria turu mar ranga i tarara ba te hatei ner a man toukui pan te kato e Sunahan!” ");
INSERT INTO hla_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ba nori e asingoto hobotor me lagi hakhakatsir ba te hihirangatsir, “Aha nonei koru a mouna a ka teka?” ");
INSERT INTO hla_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kaba palai i ranga hamatsingolo ren me poier, “U katun teka e tutu mer a wain.” ");
INSERT INTO hla_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Be Pita e takei gono merena a 12 a aposol me ranga hapanina me poiena turu barebana, “Alimiu u katunur i Judia na limiu hoboto te ka mua i Jerusalem, hengo tale iam u ranga i tar ba lia te ranga hatarare negu a man ka teka i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Alam u katun teka e ma tutu memi a wain te poe milimiu. U katun e namala ua hatuturi tara nain kilok tara bongbong. ");
INSERT INTO hla_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kaba a ka reka e ranga mamin e Joel a propet tere Sunahan i manasa ba te poiena, ");
INSERT INTO hla_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘E Sunahan e poiena, Tara poata i murimuri te sukusukun kapa noa romana a poata hoboto, alia e katoe gou romana a ka teka: Alia e hala nagou romana u Namnamei i tar turu katun hoboto. Na galapien tson i tamilimiu na galapien tohaliou has e na ranga nariou romana u ranga turu propet. Nu katun u hitots i tamilimiu e tare riou romana a man hiharuto, nu sinasoho e butu nou romana turu tsonpan i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","E manana. Na tara poata teka alia e hala nagou romana u Namnamei i tar turu tsonun kui nu taholun kui i tar, ba nori te na ranga nariou romana u ranga turu propet. ");
INSERT INTO hla_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na lia te haruto nagou romana a man hiharuts i iasa i kolö na man hiharuts i puta turu tsikitsiki — u rahatsing nu tula nu ruhu pan. ");
INSERT INTO hla_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A pitala e kuhil nou romana na tsihau e rörö here noi romana u rahatsing, i mam te butu noa u Lan tara Tsunono — u Lan u kapan koru. ");
INSERT INTO hla_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na Tsunono e taguhu ranou romana u katun te singo uar i tanen, bu katun teka te ma tatei omi roi.’ E Sunahan te ranga u teka. ");
INSERT INTO hla_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Alimiu u katunur i Israel, hengoe iam u ranga i tar. E Iesu ni Nasaret nonei a katun te hopu kapin e Sunahan. Ne Sunahan e hale ien a nitagala ba nonei te katoena a man mirakul pan i matamilimiu, na man ka teka e harutein te mana uana e Iesu. Alimiu e atei namiu a ka teka, taraha nonei e butuia tara han teka. ");
INSERT INTO hla_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","E Sunahan e atei mam me haka ba rena u katun te gi pile kap menien e Iesu ba te hala narien i tamilimiu. Na limiu tu kato hamatie men, taraha alimiu u tagala sil iam u katun u omi gi tapala nia e Iesu tara koruse. ");
INSERT INTO hla_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kaba e Sunahan e hatakei poutse ien tara tou mate i tanen. E Sunahan e purese bani e Iesu a kits tara tou mate i tanen, taraha a tou mate e ma antuna korui te ga kits kap meni e Iesu. ");
INSERT INTO hla_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","E tuburara e Devit e rangein e Iesu i manasa me poiena tere Sunahan, ‘Alia u tarei a Tsunono ba nonei te roron kakana i rehir. Nonei e kana tara pal matou i tar ba lia te ma tatei tokugi. ");
INSERT INTO hla_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","A torir e sasalana nu ranga i tar e haruto nena a nisasala i tar. Na peisar e ka haniga has nou romana. ");
INSERT INTO hla_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Taraha, alö e ma la ba namoi romana u namnamei i tar ba te kakana turu mate. E moa. Alö e ma haniga moi romana te go koreme u a tsomi i tamulö. E moa. ");
INSERT INTO hla_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Alö u harutoei lia a maroro te la uana tara nitoatoa. Na lö e kato hasasala korue mou romana lia, taraha alö e ka gono memou romana lia.’ E Devit te ranga u teka.” ");
INSERT INTO hla_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","E Pita e ranga lel me poiena, “A ma tsi hahatoulana i tar, alia e ranga halesala negu e Devit a King i tarara i manasa e mate hakapa ba nori i honge ten tara kiou, na kioun mate i tanen e ka noa hasina i romana. ");
INSERT INTO hla_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nonei a propet, na nonei e atei sil e Sunahan e hale ien u ranga te mana u i iasa. E Sunahan e ranga mamin nonei e hatuolena romana a toa katun tara pala tere Devit ba nonei te kingina romana. ");
INSERT INTO hla_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ne Devit e atei sil a ka teka ba nonei e ranga mam nena e Mesaia a katun te hopu kapin e Sunahan. Ba nonei e poiena e Mesaia e ga takei poutsia tara tou mate i tanen. E kato u, ‘E Sunahan e ma la ba nien ba nonei te kakana turu mate. E moa. A tuanreinen e ma koremei.’ ");
INSERT INTO hla_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nonei e Iesu teka e Sunahan e hatakei poutsen, na alam u tara hobotsen ba lam te habulungana namen. ");
INSERT INTO hla_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Na nonei e la hakapa u i iasa me na gumuna i rehina e Sunahan, be Sunahan e hale neien u Namnamei u Goagono te ranga mam nen i manasa. Na a ka te tare milimiu na te hengoe milimiu nonei u Namnamei teka te hala rame ien lam. ");
INSERT INTO hla_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","A katun te la u i Kolö e ma Devit nei, taraha nonei e poei, ‘A Tsunono e poei tara Tsunono i tar, Gumia i reka tara pal matou i tar antunana tara poata te hale goi lia lö u katun te paköe rio lö ba lö te na pita-puta ramoen.’ ");
INSERT INTO hla_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“U katun hobotor i Israel e gi atei sil talei a ka teka: nonei e Iesu teka tu tapala niam limiu tara koruse, e Sunahan e katoe ien a Tsunono na Mesaia, a katun ti hahalosoi ra!” E Pita e hakapeia u ranga i tanen teka. ");
INSERT INTO hla_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Poata ti hengoia a barebana u ranga teka, ba nori e toku korur ba te ranga mer e Pita nu palair u aposol me poier, “A ma tsi hahatoulana, alam e go kato aha?” ");
INSERT INTO hla_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Be Pita e poieto i taren, “Hakapa korue iam u markato u omi nu hakats u omi i tamilimiu ba limiu te na luemiu a baptais te haruto nena alimiu u katun tere Iesu Kristo. Be Sunahan te toan lu ba bera noi limiu u markato u omi, ba nonei te hala has ranoi limiu u Namnamei u Goagono. ");
INSERT INTO hla_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","U Bulungana u Niga teka e la uana i tamilimiu na tara galapien has i tamilimiu i murimuri. Na nonei e la has uana turu katun hoboto te ka ria tara han i lehana na turu katun hoboto te ngö rena e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Be Pita e hatei has rane ien u ranga u para lel ba te ranga hatatagina i taren me poiena, “Hanei iam! Alimiu e namos lu hasemiu a nihahuna te la uanama romana tara hei barebana i romana.” ");
INSERT INTO hla_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ba barebana ti hengo u ranga i tanen e toan luer a baptais. Sukusukuna tara 3000 a katun i mi honoto gono mei u katunun tsitsilo turu lan teka. ");
INSERT INTO hla_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nori i ka hobotoia tara poata a para ba te hihitaguhir me hengoer u hihatutsina turu aposol. Ba nori e nonou hoboto hasir ba te singo hoboto uar tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bu aposol e katoer a mirakul a para, ba barebana e matoutu korur. ");
INSERT INTO hla_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","A barebana hoboto ti hamana i ka hoboto ba te hiamolamola ner a man ka hoboto i taren. ");
INSERT INTO hla_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ba nori e hahol ner a man ka i taren ba te luer a moni me molamola rari u katun hoboto ti moa ta moni. ");
INSERT INTO hla_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ba nori e la hobotor tara Luman Lotu Pan turu mamanu lan ba te ka mer u toa u hakats. Ba nori i nonou hobototo i luma i taren, ba nori i sasala mieto ti molamola merien a kannou. ");
INSERT INTO hla_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ba nori e hatsunono hiton ner e Sunahan ba barebana te haniga raren. Na turu mamanu lan a Tsunono e honoter u katun ti hamana hatsimusia tara pal barebana i taren. ");
INSERT INTO hla_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Turu toa u lan e Pita ne Jon i la u tara Luman Lotu Pan tara pal 3 kilok tara lahi, a poatan singo. ");
INSERT INTO hla_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na toa katun a mounen e omi hakapa e kaia i rehina a tamana te ngöeri “A Tamana a Niga”. E tsinanen e mar posa noa has menien teka. Turu mamanu lan nonei i soata nitoa menai tara tamana teka, te ga singo beme nien a peisanen ta tsi moni turu katun ti tasuia tara Luman Lotu Pan. ");
INSERT INTO hla_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tara poata te tara rien ere Pita mere Jon ti katsin tasu uen, ba nonei e singoe iena ta tsi moni i taren. ");
INSERT INTO hla_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ba nori e tara hamatskö uar i tanen be Pita e poiena, “Tara uama i tamulam!” ");
INSERT INTO hla_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ba nonei e tara uana i taren me hakats nena te ga lu menien ta ka i taren. ");
INSERT INTO hla_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Be Pita e poiena i tanen, “Alia u moa ta moni, kaba lia e hale gilö a ka te ka megu lia. Tara solone Iesu Kristo ni Nasaret, alia e ranga mego lö, alö go tatala!” ");
INSERT INTO hla_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ba nonei e pilena tara pal matou i limanen me taguhe nen ba nonei e tanian takeina. Ba i teka puku ba man pitpitan mou na man pagpagotusna man mounen e tagala poutsur! ");
INSERT INTO hla_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ba nonei e kurapa seina me tuol nena a mounen me tanian hula lana! Ba nonei e tasu gono merena ere Pita mere Jon i Luman Lotu Pan, ba te kurapa lalana me soloseiena e Sunahan turu ranga i tanen! ");
INSERT INTO hla_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bu barebana hoboto i tare ten te tatala uaien ba te soloseier e Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ba nori i toan atei sil taleto nonei a katun te roron singoin ta moni ba te gumna tara Tamana a Niga. Ba nori i asingoto koru meto a ka te butuia tara katun teka. ");
INSERT INTO hla_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","U barebana hoboto i asingoto koru me pieta uar i taren, tara makum ti ngöei a “Luman Oho tere Solomon” i rehina Luman Lotu Pan. Na nonei a katun e pile noar ere Pita mere Jon. ");
INSERT INTO hla_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Be Pita e tara rena u barebana me poiena i taren, “Alimiu u barebanar i Israel, alimiu e asingoto koru namiu a ka teka ba te tara tutoso uamuma i tamulam, boka? Kaba a katun teka e ma niga mela lei a nitagala peisa i tamulam tsi a markato a niga i tamulam ba te tatalana. E moa. ");
INSERT INTO hla_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","A Sunahan tere Abraham mere Aisak ne Jekop nu tuburara e hala sei a solona a katunun kui i tanen e Iesu. Nonei a katun teka tu haka mena milimiu turu katun ti paköe ien. Ne Pailat a Gamman e ngilin purese e Iesu ba te lana, kaba alimiu u tori-tsuga namien i matane Pailat. ");
INSERT INTO hla_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nonei a katun a matskö na niga koru, kaba limiu u tori-tsuga namen. Alimiu u singo tsipon nemi e Pailat te ga hapurese beme rilimiu a katun a hihipuli. ");
INSERT INTO hla_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Alimiu u atung hamate iam u Mouna a Nitoatoa. Kaba e Sunahan e hatakei poutse ien tara tou mate i tanen, na lam u tarei a ka teka ba te hahatei namen. ");
INSERT INTO hla_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","A markato te hamana mena milam e Iesu na te haniga mena milam a solonen, nonei a markato te hatagala poutse lala a katun teka te tare milimiu na te atei sile milimiu. E Iesu te habutu a nihamana i tamulam, na nihamana teka te kato haniga poutse lala a katun teka i matamilimiu hoboto.” ");
INSERT INTO hla_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ne Pita e ranga lel me poiena, “A man hahatoulana, alia e atei silegu a ka a omi teka u kato memi limiu a nitutu, na pal kapan has i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","I manasa noa e Sunahan e hasila nia u ranga i tanen turu propet hoboto ba te poiena e Mesaia e ga sagohi u kamits pan, ne Sunahan e kato hamana noa has menien teka. ");
INSERT INTO hla_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","E kato uana teka, ba limiu te palisemiu u hakats i tamilimiu ba torimilimiu te habirits uana tere Sunahan, be Sunahan te lu ba nanou u markato u omi i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Te mar kato uamou limiu teka, ba Tsunono te habute nou u nitagala u tsimus i tamilimiu, ba nonei te hala pouts has mena namei romana e Iesu i tamilimiu, nonei e Mesaia te hopu kap mam berien limiu. ");
INSERT INTO hla_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nonei e ga ka mam bia i Kolö antunana te butu nama romana a poata te kato hatsimuse noa e Sunahan a man ka hoboto, te mar ranga sila u e Sunahan turu propet u matskö i tanen i manasa. ");
INSERT INTO hla_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","E Moses e poei, ‘E Sunahan a Tsunono i tamilimiu e soloseie nou romana a toa propet turu toulamilimiu i murimuri ba te taguhu rano romana limiu, kato has uana te solosei menien lia. Alimiu go hengoe iam a mamana ka te ranga mera neien limiu. ");
INSERT INTO hla_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Esi u katun te ma hengoe roi a ka te ranga nanou a propet teka, e lu kata raroa turu katun tere Sunahan ba nori te na taia riou romana.’ ");
INSERT INTO hla_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","E Samuel nu palair u propet has ti butu hamurimurima i tanen, nori hoboto i rangein a poata te kana i romana. ");
INSERT INTO hla_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Alimiu a pal barebanana turu propet. Na limiu u katun te lu hasemiu a man ka turu ranga hamana te halei e Sunahan u tubumilimiu. Nonei e poei tere Abraham, ‘Alia e kalala sila ragoa romana a hun katun hobotor i puta tara pala i tamulö.’ ");
INSERT INTO hla_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Be Sunahan e hopu kap neto a katunun kui i tanen e Iesu me hala mam mena name ien i tamilimiu te ga kalala merien limiu. Nonei e ngilin habirits ba ranei limiu a man markato a man omi i tamilimiu.” ");
INSERT INTO hla_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","E Pita ne Jon i ranga noa hasia tara barebana, bu pris na tson pepeitokap turu polis ti tara kapin a Luman Lotu Pan nu Sadiusi e tuku ria i taren. ");
INSERT INTO hla_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nori i raharaha koru mei a elasolana aposol ti hatuts merien a barebana e Iesu e takei poutsia tara tou mate, ba te haruto nena u katun ti mate hakapa e takei pouts has riou romana. ");
INSERT INTO hla_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ba nori e pile kap rer ere Pita mere Jon me karabus raren te gi kot merien turu tanu lan, taraha a ke lahi hakapa. ");
INSERT INTO hla_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kaba u katun u para ti hengo u ranga i taren i hamana koru, ba te honoto rer a pala ti hamana mamia tere Iesu. Nu hihase tara pal tson hoboto e sukusukuia tara 5000. ");
INSERT INTO hla_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Turu hamahönu lan ba pal kapan turu Jiu nu tson hihatuts turu Lo e gono hoboto ria i Jerusalem. ");
INSERT INTO hla_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nori i gono hoboto mei e Anas a tsunono pan turu pris, ne Kaiapas ne Jon ne Aleksenda, na palabi has ti pala u tara tsunono pan turu pris. ");
INSERT INTO hla_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ba nori e hatuol raria a elasolana aposol i mataren me rangata raren me poier, “Ime tu lue mia limiu a nitagala tu kato haniga pouts memi limiu a katun teka? Alimiu u kato memien a solo teresi?” ");
INSERT INTO hla_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Bu Namnamei u Goagono e saputena e Pita me ranga palis uana i taren, “Alimiu u pal kapanir i Israel nu tsunono. ");
INSERT INTO hla_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","I romana alimiu toum e katsin rangata rami lam a ka a niga tu katoei lam a katun a mou-omi na ime te mar niga pouts uen. ");
INSERT INTO hla_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Alia e ranga hatei mera golimiu hoboto nu katun hoboto has i Israel, a katun teka te tuoluna i matamilimiu e niga pouts mei a nitagala tara solone Iesu Kristo ni Nasaret. Nonei tu hatapala namia limiu tara koruse* be Sunahan e hatakei pouts noa hase nen tara tou mate. ");
INSERT INTO hla_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","E Iesu nonei a katun te ranga nena u Buk u Goagono ba te poiena, ‘Alimiu e heremi u katun te hatakeier a luma. Na katun teka e herei a hatu tu rama niam limiu. Kaba nonei a hatu te niga balana tara toukuina tara luma.’ ");
INSERT INTO hla_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","E moa ta tan ta katun te ga tatei lu pouts meri u katun tere Sunahan. Tara mamana han hoboto i puta, e Sunahan e ma hanigei ta tan ta katun te ga tatei lu pouts meri ra tere Sunahan. E Iesu peisa.” ");
INSERT INTO hla_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ba nori i asingoto koru neto ti mar ranga hatagala u ere Pita mere Jon ba te ma matoutri, me asingoto has ner a elasolana katun pinopino teka ti ma la uai turu skul pan. Ba nori i tara sabieto ti roron lala gono menien e Iesu i manasa. ");
INSERT INTO hla_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ba nori e hahalongolo mer ti tara menien nonei a katun ti kato haniga poutsi ba te tuol gono mena e Pita ne Jon. ");
INSERT INTO hla_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","16","Ba nori e ranga merer a elasolana te gi gamon lakasa ba menien a makumun hagum teka, ba pal kapan e hatanian hirari ria i peisaren me poier, “A neha te gi kato rira u katun teka? A barebana hoboto te ka ria i Jerusalem e atei siler ti kato menien a mirakul pan teka, na ra e ma tatei holis narien. ");
INSERT INTO hla_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kaba ra gi ranga hatagala mera ien ba nori te ma tatei hala lel nari tu ranga tara palabir u katun tara solone Iesu. Taraha, u bulungana teka e namos hula la hobotona turu barebana.” ");
INSERT INTO hla_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ba nori e ngö hatasu pouts rari men, me ranga hatagala mera rien te gi ma rarare lel menien e Iesu, na te gi ma hihatuts lel has menien a solonen. ");
INSERT INTO hla_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Be Pita mere Jon e ranga palis raren me poier, “Alimiu peisa te go hamoue iam a saha ka te nigana i matane Sunahan. Alam e go hengo raio limiu, tsi alam e go hengo e Sunahan? ");
INSERT INTO hla_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kaba alam e go ma tatei hanoan rangani a man ka tu tari lam na tu hengo lam.” ");
INSERT INTO hla_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ba pal kapan e ranga hatagala lel mera ren me toan hapurese raren. Nori i ma sabiei ta markato te gi mar hahuna sila merien, taraha u katun hoboto i ranga me soloseier e Sunahan tara ka te butu. ");
INSERT INTO hla_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tara neha, a katun ti katoe ien a mirakul teka ba te niga poutsuna, nonei e hatsonpan hamanasa tala. ");
INSERT INTO hla_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tara poata ti hapurese rien, be re Pita mere Jon e la pouts uar tara pal katun i taren me na hatei rarien a man ka ti ranga nela u pris pan na pal tsunono. ");
INSERT INTO hla_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Poata ti hengo hakapa ien, ba nori e gono hobotor me singo uar tere Sunahan me poier, “O Tsunono Pan, alö tu kato u kolö nu puta nu tasi na mamana ka te ka ria i taren. ");
INSERT INTO hla_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","I manasa u Namnamei u Goagono i tamulö e ranga silaia tere Devit e tubumulam a katunun kui i tamulö me poiena, ‘U katun te halhal ria i tamulam u Jiu i raharaha koru. Nori i mastei korupakön a Tsunono. ");
INSERT INTO hla_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","U tsunono pan turu han i puta i tuol me hanei siler a hiatatung. Aa, u katun u kapan i gono hoboto sil te gi hiatatung gono menien a Tsunono ne Mesaia, a katun te hopu kap nen.’ U Namnamei u Goagono te ranga u teka. ");
INSERT INTO hla_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Na ka teka e hagou butuia teka i Jerusalem. U mana koru, e Herot a King ne Pontias Pailat a Gamman i gono hoboto mer a pal kapan i tamulam u Jiu nu katun halhal. Nori i gono hobotoia tara taun teka te gi kato homi menien e Iesu, nonei a katunun kui a goagono i tamulö tu hopu kap mamin lö te go Mesaia. ");
INSERT INTO hla_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tara nitagala i tamulö na turu ngil i tamulö, alö u kits hakapi u ranga tara man ka teka te ga butu. Ba nori u katun i gono sileto te gi kato menien a mamana ka teka. ");
INSERT INTO hla_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Tsunono, alö go hakats sil u ranga u tagala te katoe lilen, ba lö te taguhu ramu molam u katunun kui i tamulö, ba lam te tatei ongolo korum te go hatei meni lam u ranga i tamulö ba te ma matoutmi. ");
INSERT INTO hla_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Alö go harutein a nitagala i tamulö ba te kato haniga pouts rem u katun te ka mer a nimate, ba te katoem a mamana mirakul tara nitsunono tere Iesu a katunun kui a goagono i tamulö.” ");
INSERT INTO hla_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tara poata ti singo hakapa ien, ba makum ti gono ien e tagasina. Nori hoboto i saputu mei u Namnamei u Goagono me tanian hatei ner u ranga tere Sunahan ba te ma matoutri. ");
INSERT INTO hla_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","A pala ti hamana i ka mei u toa u tori nu toa u hakats. E moa ta toa i taren te ga poei ta toa ta ka i tanen e na ka peisaien. E moa. Kaba mamana ka hoboto i taren era mamana era ka hobotoien. ");
INSERT INTO hla_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","U aposol i roron hatein u ranga te takei pouts u a Tsunono e Iesu, bu ranga i taren e tagala koruna. Be Sunahan e hala hoboto rane ien a nisasala pan. ");
INSERT INTO hla_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","E moa ta toa i taren te ga makmakum ban ta ka. U katun ti tei u tsikitsiki tsi a luma i hahol nen, ba nori e mi piou pouts ner a moni tara ka ti hahol nen. ");
INSERT INTO hla_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ba nori e mi hala narien turu aposol, bu aposol e molamola rarien u katun popona ti makmakum hanoa ien tara ma tsi ka. ");
INSERT INTO hla_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Hena, a toa katun e ka a solonen e Josep te tuhanaia tara tolo i Saipras na te hatubunaia tere Livai. U aposol i ngöe ien e Banabas. A mouna solo teka e poiena, “A katun te katoena u rangan hitaguhu.” ");
INSERT INTO hla_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ba nonei e hahol nena a toa makumun tsikitsiki i tanen, me la pouts menama a moni me hala rane ien u aposol. ");
INSERT INTO hla_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","A toa katun e ka a solonen e Ananaias, na tahol i tanen e Sapaira. E Ananaias e haholin a toa bun tsikitsiki i taren. ");
INSERT INTO hla_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ba nonei e peits benei a peisanen a hapalana hihol, na tahol i tanen e atei has. Ba nonei e na hala ranei u aposol a hapalana hihol. Ba nonei e poieto i taren, “A moni hoboto teka ti holei u tsikitsiki.” ");
INSERT INTO hla_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Be Pita e poiena i tanen, “O Ananaias, aha tsiponi tu hengo silei lö u hiamus tere Satan ba lö u gamoeto u Namnamei u Goagono? Alö u haka poutsi a hapalana moni ti holei u tsikitsiki, kaba lö e gamo mula ba te poiem, ‘A moni hoboto teka.’ ");
INSERT INTO hla_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","I mam ti holeia u tsikitsiki, u tsikitsiki peisa i tamulö. Ni murina tu hahol nien lö, alö u kato meien u ngil peisa i tamulö. Gaha tsiponi tu mar hakats meni lö teka i torimulö me katoem a markato a omi teka? Alö e torohanan gamo ramu lolam, kaba e Sunahan e ateina!” ");
INSERT INTO hla_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Poata te hengoeia e Ananaias a ka teka ba nonei e rusuna me tuhamate nitoa nena. Nu katun hoboto ti hengoein u bulungana teka i matout koru. ");
INSERT INTO hla_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bu katun u hitots e tasu rima me mi pitseri a peisanen u labalaba, me soata halakase ren me na ngaho naren. ");
INSERT INTO hla_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","I murina te kapaia a topisa aua ba tahol i tanen e Sapaira e tasu nama. Kaba nonei e ma atei silei a ka te butu. ");
INSERT INTO hla_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Be Pita e poieto i tanen, “Hatei molia, nonei lasi a hihol hoboto turu tsikitsiki teka tu lue iam limiu u mun tahol?” Ba tahol e poieto, “Aa, nonei lasi a hihol hoboto.” ");
INSERT INTO hla_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Be Pita e poiena i tanen, “Aha tsiponi tu kits gono memi limiu u ranga te go torohane milimiu u Namnamei tara Tsunono? U katun te ngaho narima a tson i tamulö e ka ria tara tamana. Nori e soata halakasa hase rio lö!” ");
INSERT INTO hla_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","I teka puku has ba tahol e rus putana i mouna e Pita me matena. Bu katun u hitots e tasu rima me tarer a tahol e mate hakapa, ba nori e soata halakase ren me na ngaho narien i rehina tson i tanen. ");
INSERT INTO hla_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ba pal barebana hoboto tere Kristo nu katun hoboto has ti hengoein a ka teka i matout koruto. ");
INSERT INTO hla_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","U katunun tsitsilo i kato u mamana u mar mirakul i gusur u katun. Nu katun hoboto ti hamana i gono hobotoia tara makum te ngöeri a Luman Oho tere Solomon. ");
INSERT INTO hla_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","E moa koru ta katun te ga hahamana ti hagum gono meren, kaba barebana i solosei noa has ren. ");
INSERT INTO hla_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kaba para koru a katun ti hamana i tapoia tara pala tara Tsunono, a tson a para na tahol has a para. ");
INSERT INTO hla_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Bu katun e soata halakasa merari u katun ti ka mei a nimate i kalana me na hopu rarien turu inana na tara man holholasa. Nori i mar kato u teka te ga la uama e Pita ba momounen te tatei hoho rena a palai i taren ba te kato haniga pouts ranen. ");
INSERT INTO hla_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","U barebana u para i lama turu han ti ka hahis a taun i Jerusalem me mi piou rer u katun ti ka mei u nimate nu katun has ti roron seia u mate u omi. Be Sunahan te kato haniga hoboto pouts ranen. ");
INSERT INTO hla_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ba tsunono pan turu pris nu katun ti ka gono meien, a pala turu Sadiusi, nori i hiomi koruia turu aposol. ");
INSERT INTO hla_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ba nori e pile kap rer u aposol me haka rarien tara karabus ba te kits kap ner a tamana. ");
INSERT INTO hla_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Kaba nonei noa has tara bong a angelo tara Tsunono e kalata a tamana tara luman karabus me halakasa rena u aposol me poiena i taren, “Na tuol mia i iahana Luman Lotu Pan ba te hatei rami a barebana u ranga hoboto tara markato a tsimus teka.” ");
INSERT INTO hla_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bu aposol e hengoer u ranga teka, ba nori e la uar tara Luman Lotu Pan tara bongbong koru me tanian hihatuts ria turu katun. Ba tsunono pan turu pris na pala i tanen e ngö gugono merari a pal kapan hoboto turu Jiu turu hagum turu Kot Pan, ba nori e hala ner u ranga tara luman karabus te gi mi piou meri u aposol i mataren. ");
INSERT INTO hla_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Ba poata ti na tukuia u polis, ba nori e ma sabe rari u aposol tara luman karabus. Ba nori e la pouts uarima turu Kot me mi hateir, “A poata te na tuku mula lam tara luman karabus, alam e na sabie mula a man tamana e pili hakarapoto koru lala, nu tson pepeitokap e tuol has rima turu tamana. Kaba poata te kalate muma lam u tamana, alam e ma sabie mumei ta toa i iogana.” ");
INSERT INTO hla_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","A tson pepeitokap turu polis ti tara kapin a Luman Lotu Pan nu pris pan i hengo a ka teka me hakats hapara koru ner a ka te butuia turu aposol. ");
INSERT INTO hla_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ba toa katun e tasu nama me poiena i taren, “Hengo iam! U katun tu haka ramia limiu tara karabus e tuol ria i iahana Luman Lotu Pan ba te hihatuts ria turu barebana!” ");
INSERT INTO hla_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ba tson pepeitokap e la gono merena u polis i tanen me na lu pouts rarima u aposol. Kaba nori i ma atungri u aposol, taraha nori i matout tuni te gi titi hatu merien u katun ti haniger u aposol. ");
INSERT INTO hla_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","28","Ba nori e mi piou pouts raria u aposol i gusuna u Kot Pan, ba tsunono pan turu pris e rangata sei uana i taren me poiena, “Alam u hapiu hatagala korun te go ma tatei hihatuts mena milimiu a solone Iesu, boka! Kaba alimiu u sata tsipon niam u hihatuts i tamilimiu turu han hoboto i Jerusalem! Ba limiu te ngilin hasösö mera milam te mate uen!” ");
INSERT INTO hla_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Be Pita nu palabir u aposol e ranga palisir me poier, “Alam e ma tatei kukutiemi u ranga teka i tamilimiu! Alam e kukute talasem u ranga tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Alimiu tu hatapala niam e Iesu tara koruse me kato hamatie men, kaba a Sunahan turu tuburara te hatakei pouts ien tara tou mate. ");
INSERT INTO hla_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Be Sunahan e lu sei mena teien i iasa tara pal matou i tanen, nonei a Tson Mammam na Tson Hihitaguhu. Nonei e lu sei sile ien te gi palis meni u katun i Israel u hakats nu markato u omi i taren, ne lu sei sil hase ien te go lu ba menien u markato u omi i taren ba te tara pouts uana i taren. ");
INSERT INTO hla_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Alam nu Namnamei u Goagono u tarei a man ka teka te kato e Sunahan me hatei namen. Be Sunahan e hala has nena u Namnamei u Goagono turu katun te kukutier u ranga i tanen.” ");
INSERT INTO hla_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Poata ti hengoeia a pal kapan u ranga teka, ba toriren e si koruna ba nori e katsin atung hamate rer u aposol. ");
INSERT INTO hla_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","35","Kaba toa katun pan turu Kot, a solonen e Gameliel, e tuolia i gusuren. Nonei a pala turu Parisi na nonei has a tson hihatuts turu Lo, nu katun hoboto i roron solosei hase ien. Nonei e rangein te gi halakasa mam meri u polis u aposol, ba nonei e poiena turu Kot, “U katunur i Israel, alimiu go hakats mam niam a ka te ngilin katoe milimiu turu katun teka. ");
INSERT INTO hla_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","E ma manasa korui a toa katun a solonen e Tiudas e poei i peisanen, ‘Alia e ka megu a nitagala.’ Bu 400 tara katun i hamane ten. Kaba gamman te atung hamate ien, ba pal katun hoboto ti hamanaia i tanen e tarura kalakalar, ba toukui i taren e taia pinopinona. ");
INSERT INTO hla_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Na i murina a ka teka, tara poata ti hopu nia a barebana a soloren tara gamman, be Judas ni Galili e las mena nei u hakats turu palabir u katun i peisanen. Ba nonei e lu ranen te gi kukute menien u ngil i tanen. Kaba nonei i atung hamate hasi, ba pal katun hoboto ti hamanaia i tanen e tarura kalakalar. ");
INSERT INTO hla_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na turu katun teka i romana, alia e hatei rago limiu, alimiu go ma katoemi ta markato ta omi i taren. Haka riam. Te ga butuma a toukui teka turu katun tun, ba nonei te taia nou. ");
INSERT INTO hla_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kaba te ga butuma a toukui teka tere Sunahan, alimiu e moa koru te go tatei tagala saluhe merami u katun teka. Kaba limiu e namos here tsipon rami u katun te omier e Sunahan!” Ba pal kapan e hengoer u ranga tere Gameliel. ");
INSERT INTO hla_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ba nori e ngö hatasu pouts rer u aposol me hasingata raren. Ba nori e ranga hatagala mera rien te gi ma kato lel menien u ranga tara solone Iesu, ba nori e hapurese raren. ");
INSERT INTO hla_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bu aposol e la ba ner u Kot, me sasala koru siler te haniga merien e Sunahan te gi kamits sil menien a solone Iesu. ");
INSERT INTO hla_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na turu mamanu lan, tara Luman Lotu Pan na turu luma has turu katun, nori i roron rarare u Bulungana u Niga ba te hihatuts ner e Iesu nonei e Mesaia, a katun te hopu kapin e Sunahan te ga taguhu merien u katun i tanen. ");
INSERT INTO hla_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na tara poata teka u hihase turu katunun tsitsilo e butu hapan susul. Na pal katun ti atei sil u rangan Ha-Grik i raharaher a pal katun ti atei sil u rangan Ha-Hibru me poier, “Turu mamanu lan alimiu e roron taguhu ramiu u katun ti makmakumia tara kannou. Kaba alimiu e ma taguhu rami u tohaliou u amoba i tamulam.” ");
INSERT INTO hla_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ba 12 a aposol e ngö gugono rer u katunun tsitsilo hoboto me poier, “E ma niga koru nei te go hapolasan rarare meni lam u ranga tere Sunahan ba te hihanou nem a kannou. ");
INSERT INTO hla_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","A ma tsi hahatoulana, alimiu go hopu kap niam ta elahit ta katun i gusumilimiu te ka mer a solo a niga i matar u katun, nu Namnamei u Goagono e saputuna i taren ba te ka mier a niatei a niga. Ba ra te haka raria u katun teka te gi tara kapin nonei a toukuin kannou teka. ");
INSERT INTO hla_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ba lam te kui nitoa moa te go singo u lam tere Sunahan na te go taguhu has meri lam u katun turu ranga tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nu barebana hoboto i haniga koru u ranga teka turu aposol. Ba nori e hopu kap ner e Stiven, a tson te ka mei u nihamana u kapan na te saputu mei u Namnamei u Goagono. Ba nori e hopu kap has ner e Pilip ne Prokoras ne Naikena ne Taimon ne Pamenas ne Nikolas. E Nikolas a katununa i Antiok te tasogoia tara pala turu Jiu. ");
INSERT INTO hla_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ba nori e hatuol raria u katun teka i matar u aposol, ba nori e singo uar tere Sunahan me hatakope ria a limaren i taren te ga kalala merien e Sunahan tara toukui i taren. ");
INSERT INTO hla_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nu ranga tere Sunahan e tasata noa has. Nu hihase turu katunun tsitsilo i Jerusalem e la sei hapan koru, bu pris u para turu Jiu i hamana hasito. ");
INSERT INTO hla_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","E Sunahan e haniga koru e Stiven me hale neien a nitagala a kapan, na nonei e roron kato a mamana mirakul i gusur a barebana. ");
INSERT INTO hla_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bu palair u katun e tanian raharaher e Stiven. Nori a pal katun tara toa luman lotu turu Jiu ti ngöei a luman lotu turu Friman.* Nori u katunur i Sairini na i Aleksenria na i Silisia na i Eisia. ");
INSERT INTO hla_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kaba u Namnamei tere Sunahan e halei e Stiven a niatei a niga koru, ba nori te ma antunan karasa nari u ranga i tanen. ");
INSERT INTO hla_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ba nori e hol sil rari a palabir u katun te gi poe meni, “Alam u hengoen te ranga homi menien e Moses ne Sunahan!” ");
INSERT INTO hla_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","E kato uana teka, ba nori te hatakeier a raharaha pan tara barebana na turu katun u tsunono na turu tson hihatuts turu Lo. Ba nori e la uarima tere Stiven me pile kap naren me na piou narien i matana u Kot Pan. ");
INSERT INTO hla_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ba nori e ngö sil rari u katun te gi mi gamo menien ba te poier, “A katun teka e roron ranga homi nena a luman lotu a goagono i tarara nu Lo has tere Moses. ");
INSERT INTO hla_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Taraha, alam u hengoen te poe menien, ‘Nonei e Iesu ni Nasaret e kato rure nou a Luman Lotu Pan ba te palise nou a man markatona i manasa te hala rira e Moses!’” ");
INSERT INTO hla_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bu katun hoboto ti gumia turu Kot i tara tutoso uato tere Stiven me tarer a pal polenen e tara herei a polena angelo. ");
INSERT INTO hla_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ba tsunono pan turu pris e rangatena e Stiven, “U ranga teka e manana?” ");
INSERT INTO hla_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Be Stiven e ranga palisina me poiena, “A ma tsi hahatoulana na ma tsi hahatamana, hengo iam! A Sunahan turu ualesala e butuia tere tuburara e Abraham tara poata te ka ien i Mesopotemia i mam te la uen i Heran me poiena, ‘Alö go la ban a pal katun i tamulö na han i tamulö ba lö te la uam tara han te harutse goi lia alö.’ ");
INSERT INTO hla_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ba nonei e la ba nena a han i Kaldia me na kana i Heran. Bi murina te mateia e tamane Abraham, be Sunahan e hala mena namei e Abraham tara han te ka mia limiu teka. ");
INSERT INTO hla_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","E Sunahan e ma hala noei e Abraham ta makum turu tsikitsiki teka ba nonei te tatei teie nen. E moa koru ta tsitabubu. Kaba e Sunahan e ranga hamanein te ga hala menien u tsikitsiki teka i murimuri, ba nonei te tatei tei gono mera noien u tutubuneien i murimuri. Kaba e Abraham e moa noa ta toa ta pien tara poata te katoeia e Sunahan u ranga hamana teka. ");
INSERT INTO hla_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","E Sunahan e mar ranga u teka i tanen me poiena, ‘U tutubumilö i murimuri e na ka roa tara toa han tara tana pal katun, ba nori te na hakukui puku rariou romana ba te kato homi rariou antuna noa turu 400 u hiningal. ");
INSERT INTO hla_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kaba lia e hahuna ragou romana u katun te hakukui puku raroen, ba i murimuri bu katun i tar te la ba nerima romana nonei a han ba te mi hatsunone roa lia tara han teka.’ ");
INSERT INTO hla_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Be Sunahan e hale tei e Abraham a markato te pö menari a hatoatongo tere Sunahan turu pikpikö, ba te haruto nena u ranga te kits hoboto mei e Sunahan ne Abraham e manana. Be Abraham e hatuhanena e Aisak me pöena a pikpikönen turu hatoalinu lan ti poseia e Aisak. Be Aisak e hatuhanena e Jekop me kato has mena neien i iesana. Be Jekop e hatuhana rena a l2 a pien tson me kato has mera neien i iesana. Na nori u tuburara. ");
INSERT INTO hla_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","“Na man munmun toulana u tuburara i hiomia tere Josep me hahol naren, ba nonei e na kukui pukuna i Itsip. Kaba e Sunahan e ka gono meien, me lu ba nane ien a mamana nomi hoboto te butuia i tanen. Ba poata te butuia e Josep i matane Pero a Kingina i Itsip, be Sunahan e hanige ienen me hale neien a niatei a niga. Be Pero e hopu kap sile nei e Josep te ga pepeito kap menien a mamana ka tere Pero nu katun has i tanen na han hobotona i Itsip. ");
INSERT INTO hla_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Na tara toa poata a bes e butuia tara mamana han i Itsip na i Kenan, me bes homi korur. Bu tuburara e ma antunan sabe nari ta kannou. ");
INSERT INTO hla_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Be Jekop e hengo neto te ka u a kannou i Itsip, me hala rena a galapien tson i tanen tara poata tutun. ");
INSERT INTO hla_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ba tara poata ti la hahuol uen, be Josep e habutsena a peisanen turu toulanen, be Pero e toan atei silena a pala tere Josep. ");
INSERT INTO hla_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Be Josep e hala nena u raranga tere Tamanen e Jekop me hatei nena te gi la hakapa u a pala hoboto i tanen i Itsip. Nori i antuna hobotoia turu 75 u katun. ");
INSERT INTO hla_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Be Jekop e la uana i Itsip me na solon kana ba te toan matena, na galapien has i tanen, nori u tuburara. ");
INSERT INTO hla_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","A tuanreiren i na hongo ria turu ngahongaho te holei e Abraham u moni tara pala tere Hemor i Sikem.” ");
INSERT INTO hla_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","E Stiven e ranga lel me poiena, “A poata e sukusuku tala te go butu hamanaia u ranga hamana te kato e Sunahan tere Abraham, bu hihase tara pal barebana i tarara i Itsip te para susul lelina. ");
INSERT INTO hla_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na i murina a poata tere Josep, a tana king e pania i Itsip ba te ma hakats nanei nonei a katun a niga e Josep. ");
INSERT INTO hla_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nonei e gamoer a pala i tarara, ba te katoena a markato a omi turu tuburara. Nonei e tagala sil korui te gi na haka piu merien a ma tsi goama i taren i ielesala ba te mater. ");
INSERT INTO hla_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tara poata teka e Moses i posei, na nonei e taratara haniga koruia i matane Sunahan. Be tamanen ne tsinanen e taratara kap narien i luma i taren e antunaia tara topisa tsihau. ");
INSERT INTO hla_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kaba nori i na haka piu nien i ielesala, ba pien tahol tere Pero e mi lue nen me hahahu here nane ien a pien peisa i tanen. ");
INSERT INTO hla_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","E Moses i hatutsei a mamana niatei a niga turu katunur i Itsip, na nonei a katun a tagala turu ranga i tanen na tara toukui i tanen. ");
INSERT INTO hla_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Tara poata te ka meia e Moses u 40 u hiningal, ba nonei e hakats nena te go na tara merien a pal katun i tanen u Israel. ");
INSERT INTO hla_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ba nonei e na tarena a toun Itsip ba te kato homiena a toun Israel. Be Moses e taguhena a toun Israel me katoena a hipou tara toun Itsip me atung hamatie nen. ");
INSERT INTO hla_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nonei e hakatsin a pala i tanen e gi mar hakats u teka: ‘E Sunahan e katsin taguhu sila ranoa ra tara nitagala tere Moses.’ Kaba nori i ma mar hakats uai teka. ");
INSERT INTO hla_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ba turu hamahö be Moses e na tara rena a elasolana toun Israel ba te hiatatungur. Ba nonei e torohanan kato haniganiga ranen me poiena, ‘Hengo iam! Alimiu a toa han. Aha te hiomimi sile milimiu?’ ");
INSERT INTO hla_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kaba a katun te kato homi a tai e tula hatalis ban e Moses me poiena, ‘E moa ta katun te ga hakapanio lö i tamulam ba te mi hahamouem a markato i tamulam! ");
INSERT INTO hla_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Alö toum e katsin atung hamate here nami lia a toun Itsip tu atung hamati lö i nolaha?’ ");
INSERT INTO hla_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nonei e mar ranga u teka be Moses e bus ba nena a han i Itsip me na ka here nei a katun a sal tara han i Midian. Poata te ka ien tara han teka ba nonei e tölena a tahol ba te hatuhanena a elasolana pien tson.” ");
INSERT INTO hla_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","E Stiven e ranga lel me poiena, “U 40 u hiningal e la hakapa, ba toa angelo e butuna tere Moses tara latu pinopino i rehina u Pokus i Sinai me kana tara tsi roei te kulupu. ");
INSERT INTO hla_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Be Moses e asingoto koruna te tara menien u kulupu tara tsi roei kaba e ma atsi, ba nonei e la hasukusukuna te go na tara haniga menien. Ba nonei e hengoena a Tsunono te poei, ‘Alia a Sunahan turu tubumulö, nori ere Abraham mere Aisak ne Jekop.’ Be Moses e tololona me matoutun tara uana turu kulupu. ");
INSERT INTO hla_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ba Tsunono e hateie nen, ‘Alö go lu ban u sendol i moumulö. A makumun tsikitsiki te tuol mia lö e goagonona. ");
INSERT INTO hla_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Alia u tara hakapi a man markato a man omi te katoer u katunur i Itsip tara pal katun i tar. Na lia u hengo hakapi u har i taren, na lia e koul sile guma te go mi taguhu merien. Alö go lama. Alia e hala pouts mena gilö i Itsip.’” ");
INSERT INTO hla_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Be Stiven e ranga noana me poiena, “Nonei e Moses ti raman a barebanar i Israel me poier, ‘E moa ta katun te ga hakapanio lö i tamulam ba te hahamouem a markato i tamulam!’ Nonei lasi a katun te hala here nai e Sunahan a tsunono na katun te ga lu ba rien a nomi. E Sunahan e hatagala sila nien tara angelo te butuia i tanen tara tsi roei te kulupu. ");
INSERT INTO hla_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","E Moses e kato a mamana mirakul i Itsip me peigi halakasa ba ranei a barebana i Itsip. Ba nonei e katoena a mirakul turu tasi ti ngöei u Tasi u Rörö na mamana mirakul tara latu pinopino antunaia turu 40 u hiningal. ");
INSERT INTO hla_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nonei lasi e Moses te hateir a barebanar i Israel me poiena, ‘E Sunahan e soloseie nou romana a toa propet turu toulamilimiu i murimuri, kato has uana te solosei menien lia.’ ");
INSERT INTO hla_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nonei e Moses te ka gono mer u katunur i Israel ti gono hoboto ien tara latu pinopino. Nonei e ka gono mei u tuburara na angelo has te rangia i tanen turu Pokus i Sinai. Nonei e lui u raranga tere Sunahan, u rarangana tara nitoatoa, te ga hala rien ra. ");
INSERT INTO hla_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Kaba u tuburara i ma ngilin hengo nai u ranga i tanen. E moa. Nori i tori-tsuga nen ba te ngilin la pouts uar tara han i Itsip. ");
INSERT INTO hla_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ba nori e hateier e Eron, ‘Alö go kui bera mei ra u got ba nori te mam rario ra. Ara e ma atei sile rei aha te butuia nonei tere Moses te peigi halakasa rema ra i Itsip.’ ");
INSERT INTO hla_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nonei tara poata nori i kui u keisa te mata herei a tunan bulumakau ba te hats uar i tanen. Ba nori e sasalar me katoer a kannou tara got gamogamo teka ti kuie ien a limaren tun. ");
INSERT INTO hla_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kaba e Sunahan e habirits me haka ba ranen ba nori e hatsunono uar tara pitala na tsihau nu pitopito, te mar koloto u a propet turu Buk u Goagono, fi ‘Alimiu u katunur i Israel! I manasa alimiu u ka mia tara latu pinopino turu 40 u hiningal, ba limiu e atung hamate ramiu u bulumakau nu sipsip me hats ramen. Na limiu u mar kato uam teka teresi? I tar? E moa. ");
INSERT INTO hla_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Alimiu u lue iam a luma seil tara got gamogamo a solonen e Molok, me soata gono memien a pitopito tara got gamogamo e Repan, nori a man keisa tu kui sile milimiu te go hatsunono mena mien limiu. E kato uana teka, ba lia te lu ba has rago limiu ba te hala mera gilimiu i hapalana i Bebilon.’ A propet te mar ranga u teka. ");
INSERT INTO hla_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Be Stiven e ranga noana me poiena, “Tara poata ti kaia u tuburara tara latu pinopino, nori i ka mei a luma seil ti lotu uen tere Sunahan. E Sunahan e harutei e Moses te go mar kui menien a luman lotu teka, ba nori te toan mar kui mena rien te mar haruto meni e Sunahan e Moses. ");
INSERT INTO hla_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Bi murimuri bu tuburara e la gono merima e Josua te gi mi lu menien u tsikitsiki tara tana pal katun. Be Sunahan e tsuga raten i matar u tuburara. Tara poata teka nori i mi pioun nonei a luma seil me hakei rien teka antunaia tara poata tere Devit a King. ");
INSERT INTO hla_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","E Sunahan e haniga korui e Devit, be Devit e singo uana i tanen te ga tatei kui menien a toa luma a niga tara Sunahan tere Jekop. ");
INSERT INTO hla_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kaba e Solomon a pien tson tere Devit te kui bei e Sunahan a luma. ");
INSERT INTO hla_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Kaba e Sunahan Iasa Koru e mamala ka neia turu luma ti kui u katun. E mar kato uana te mar ranga u a propet, ");
INSERT INTO hla_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘A Tsunono e poiena, Alia e king gia tara mamana makum hoboto i Kolö na i puta. E moa ta luma te go antunan kui bemi limiu alia ba lia te husa gia i tanen. ");
INSERT INTO hla_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","A han i tar e ka hobotona tara mamana makum, taraha alia peisa tu kui a mamana ka hoboto.’ E Sunahan e mar ranga u teka.” ");
INSERT INTO hla_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","E Stiven e ranga lel tara pal kapan turu Kot me poiena, “Alimiu u katun u hihipus! Alimiu e tori here noa hasemi u tematan! Alimiu e talinga-tu ba koru namiu u ranga tere Sunahan! Alimiu e hipus nitoa namiu u Namnamei u Goagono ti mar kato has u u tuburara! ");
INSERT INTO hla_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","U tuburara i kato homir u propet hoboto i manasa. Nori i atung hamatir u katun tere Sunahan ti habulungana mamin te go la uama romana a Katun a Matskö i tanen, nonei e Kristo. Na limiu u hala hakapa mena mien turu katun ti omien ba nori e atung hamatie ren. ");
INSERT INTO hla_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Alimiu tu lue iam u Lo te hala meni e Sunahan turu angelo, na limiu u ma kukutie mien te la noa hasina i romana!” E Stiven te mar ranga u teka. ");
INSERT INTO hla_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Poata ti hahengoia a pal kapan turu ranga tere Stiven, ba toriren e saka hasoalana me raharaha korue ren. ");
INSERT INTO hla_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kaba u Namnamei u Goagono e saputi e Stiven, ne Stiven e tara hatagala u i Kolö me tarena u ualesala pan tere Sunahan, ne Iesu te tuolia tara pal matou tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Be Stiven e poiena, “Alia e taregu u Kolö e kalatana ne Iesu te butun katunuma e tuolna tara pal matou tere Sunahan!” ");
INSERT INTO hla_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ba nori e tuper a talingaren me ele hapan korur, me takei hobotor me pietar me na pile kap ner e Stiven. ");
INSERT INTO hla_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ba nori e las ba mena rien tara taun me na tanian titi hate ren. U katun ti saka mam meien u ranga i his ban u hasobu u ngahangaha i taren me hakei rien i rehina a toa katun a hitots a solonen e Sol. ");
INSERT INTO hla_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tara poata ti titi hate ien e Stiven, ba nonei e mar singo uana teka, “O Iesu a Tsunono, alö go lu u namnamei i tar!” ");
INSERT INTO hla_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ba nonei e hatukununa me ku hapan koruna me poiena, “O Tsunono, alö go ma palisei a markato a omi teka i taren!” E Stiven e mar ranga u teka me matena. Ne Sol e hanigei ti atung hamate menien. ");
INSERT INTO hla_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Nonei noa has turu lan teka, nori i tanian kato homi korur u Kristen ti kaia i Jerusalem. E mar kato u teka bu Kristen hoboto e la kalakala uar tara man han i iahana provins i Judia na i Sameria. U aposol peisa ti ka noaia i Jerusalem. ");
INSERT INTO hla_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","A pal katun ti hamana ti ngahoen e Stiven, me ka mer a nitatagi pan i tanen. ");
INSERT INTO hla_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kaba e Sol e kato homi korur u Kristen. Nonei e hula tasuia turu luma me lu rena a pal tson na tohaliou has, me las mera neien tara karabus. ");
INSERT INTO hla_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","U Kristen i sata me la kalakala uar turu han hoboto me rarare laner u Bulungana u Niga. ");
INSERT INTO hla_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ne Pilip e la u tara taun i Sameria me hatuts ranei u katun i Sameria e Mesaia. ");
INSERT INTO hla_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","U katun u para koru i hahengo u tere Pilip, ba poata ti tare ien a man mirakul te katoen, ba nori i toan hengo haniga korueto u ranga i tanen. ");
INSERT INTO hla_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bu mate u omi i ku hapan koruto me lakasa ba rer u barebana u para. Nu katun u para ti matekata na ti mou-omi i kato haniga poutsir. ");
INSERT INTO hla_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ba nisasala pan e butuna tara taun i Sameria. ");
INSERT INTO hla_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","A toa katun e kaia tara taun teka a solonen e Saimon. I manasa nonei e roron kato a matuna na hirakö. Bu katunur i Sameria i roron asingoto koru neto a man ka te katoen. Nonei e roron poei, “Alia a katun pan.” ");
INSERT INTO hla_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ba barebana tara taun teka ti ka mei a solo na pala ti moa ta solo, nori hoboto i tagala koru mei ti hengo menien e Saimon. Nori i poei, “A katun teka nonei a nitagala tere Sunahan te ngöeri a Nitagala Pan.” ");
INSERT INTO hla_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nonei e solon hasingoto koru rien a nitagala i tanen, ba nori e hengo korue ren. ");
INSERT INTO hla_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kaba nori i hamani te hatei meni e Pilip u Bulungana u Niga tara Nipepeito tere Sunahan na solone Iesu Kristo, ba nori hoboto a pal tson na tohaliou e habaptaisir. ");
INSERT INTO hla_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ne Saimon e hamana has me habaptaisina. Ba nonei e ka gono mena e Pilip me asingoto koru nena a man mirakul pan te kato e Pilip. ");
INSERT INTO hla_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","U aposol ti kaia i Jerusalem i hengoen ti lu meni u katunur i Sameria u ranga tere Sunahan, ba nori e hala merari ere Pita mere Jon i taren. ");
INSERT INTO hla_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tara poata ti tuku ien, ba nori i singo uato tere Sunahan ba te singo siler u Kristen te gi lu menien u Namnamei u Goagono. ");
INSERT INTO hla_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Taraha, u Namnamei u Goagono e ma koul noa uamei i taren. I manasa nori i habaptais tun mei a solona Tsunono e Iesu. ");
INSERT INTO hla_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Be re Pita mere Jon e hatakope ria a limaren i taren, ba nori e toan luer u Namnamei u Goagono. ");
INSERT INTO hla_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Be Saimon e tareto ti hatakopo meni u aposol a limaren turu katun ba nori e luer u Namnamei. Ba nonei e torohanan hala nena a moni tere Pita mere Jon me poiena, “Alimiu go hala hase mumei lia a nitagala teka, ba lia te tatei hatakope goa a limar turu katun ba nori te lu haser u Namnamei u Goagono.” ");
INSERT INTO hla_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Be Pita e poiena i tanen, “Alö e tatei na tia gono mem a moni i tamulö, taraha alö e ngilin hol tsiponemi a kan halhala puku tere Sunahan a moni tun! ");
INSERT INTO hla_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","E moa koru te go lu meni lö a toukui teka, taraha a torimulö e ma matskö nei i matane Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Alö go palis u hakats u omi i tamulö teka, ba lö te singo silem tara Tsunono te go lu ba menien u ngil u omi teka i torimulö. ");
INSERT INTO hla_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Taraha, alia e taregu a torimulö e hiomi koruna, ba lö te heremi a karabus te kits mena a markato a omi.” ");
INSERT INTO hla_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Be Saimon e poiena, “Pua, alimiu go singo bemu molia tara Tsunono ba man ka te ranga nemu lalö te ma tatei butu neia i tar!” ");
INSERT INTO hla_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ba poata te hatei hakapa nia e Pita mere Jon u ranga tara Tsunono, ba nori e rarare laner u Bulungana u Niga tara han a para tara Provins i Sameria, ba te na butu hamurimuri ria i Jerusalem. ");
INSERT INTO hla_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ba toa angelo tara Tsunono e poieto tere Pilip, “Alö go takei ba lö te la uam i pal saut tara maroro te la ba nena i Jerusalem, ba te gala uana tara taun i Gesa.” Te mar ranga u a angelo. A maroro teka e kaia tara latu pinopino. ");
INSERT INTO hla_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Be Pilip e takeina me lana. Tara maroro teka e laia a toa toun Itiopia te ma antunan hitöli. Nonei a toa tson pepeito a kapan te pilein a toukui tara tetahol panina i Itiopia a solonen e Kandesi. Nonei e taratara kapin a mamana ka a niga tere Kandesi. A tson teka e la silema e go mi lotuia i Jerusalem. ");
INSERT INTO hla_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nonei e lotu hakapa me katsin takopis pouts hamanasana. Nonei e gumia tara karis i tanen ba te ritena u buk te kolotein e Aisaia a propet ba te lana. ");
INSERT INTO hla_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Bu Namnamei tere Sunahan e ranga meto e Pilip me poiena, “Alö go la hasukusuku ba lö te na la gono mem nonei a karis.” ");
INSERT INTO hla_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Be Pilip e pieta hasukusukuto me hengoena a katun teka te rit menien u buk te kolotein e Aisaia a propet. Be Pilip e poiena, “Alö e atei silem a mouna u ranga te tare mulö?” ");
INSERT INTO hla_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ba nonei a katun teka e kato uana, “Te ma hale nei lia ta katun ta niatei ba lia te mar atei halona uagu ime?” Ba nonei e poiena tere Pilip, “Alö go seima ba lö te gum gono memo lia.” Be Pilip e seina me gum Fp fl gono menen. ");
INSERT INTO hla_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A bun ranga turu Buk u Goagono te tare ien e mar kato u teka: “Nonei a katun e here nei a sipsip te piou ner ba te katsin atung hamatier. Nonei e here nei a tunan sipsip a hulunen te kulier ba te ma ngala nei. Nonei has e moa te go ranga u. ");
INSERT INTO hla_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nori e pita-puta korue ren ba te ma katoeri tu kot tu niga i tanen. A hei barebana ti kaia tara poata i tanen, nori i kato a markato a omi koru. Ne moa ta katun te ga hatararein a ka teka. Taraha, nori i atung hamate hakape ien, ba nonei te ma ka lel neia i puta.” U Buk u Goagono te mar ranga u teka. ");
INSERT INTO hla_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ba nonei a tson pepeito e ranga meto e Pilip me poiena, “Alia e rangatse golö, a propet e rangein esi ba nonei te katoena u ranga teka? Nonei e rangein a peisanen, tsi e rangein a tana katun?” ");
INSERT INTO hla_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Be Pilip e poiena, “Nonei e rangein e Iesu Kristo.” E Pilip e taniaia tara bun ranga teka turu Buk u Goagono, me hatei nena u Bulungana u Niga tere Iesu. ");
INSERT INTO hla_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nori a elasolana katun i la noaia i maroro me na butu ria tara toa ramun, ba tson pepeito teka e poiena, “Alö go ruto, a ramun i tium. E antunana te go habaptais u lia?” ");
INSERT INTO hla_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Be Pilip e poiena, “Te hamana koru mia lö i torimulö, alö e antunan habaptaisim.” Ba nonei e ranga palisina me poiena, “Alia e hamana koruegu e Iesu Kristo nonei a Pien Tson tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ba nonei e hagumena a karis, be Pilip na nonei a tson pepeito e koul uar tara ramun, be Pilip e baptais tale nen. ");
INSERT INTO hla_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ba nori e la sei pouts rima tara ramun, bu Namnamei tara Tsunono e luena e Pilip ba te la menen. Na tson pepeito e ma tara lele ien, kaba nonei e sasala koru noa has, ba nonei e la noana tara maroro i tanen. ");
INSERT INTO hla_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ne Pilip e na butuia tara taun i Asdot. Nonei e hatei lan u Bulungana u Niga tara mamana taun, antunaia te na butu ien tara taun i Sesaria. ");
INSERT INTO hla_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Tara poata teka a toa katun a solonen e Sol e ranga hatagala korun te ga pile kap merien u katunun tsitsilo tara Tsunono ba te atung hamate ranen. Ba nonei e lana tara tsunono pan turu pris turu Jiu me na rangata nena ta kalanloun te ga la gono meien turu luman lotu turu Jiu me tara taun i Damaskas. Bu ranga u tagala turu kalanloun teka e poiena, “Te go na sabe meni e Sol ta katun tara barebana te kukutier a maroro tere Iesu, a tson na tahol has, ba nonei te na pile kap ranen ba te las mera neien i Jerusalem.” ");
INSERT INTO hla_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Be Sol e la uana i Damaskas. Ba poata te sukusuku ien tara taun teka bu toa u ualesalana i kolö e songots butu kalakalana i man rehinen. ");
INSERT INTO hla_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ba nonei e rus uana i puta turu tikitsiki, ba nonei e hengoena u toa u ranga ba te poiena i tanen, “O Sol, o Sol, aha te kato hakamits sile milö alia?” ");
INSERT INTO hla_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Be Sol e rangatana, “O tsunono, alö esi?” Ba nonei e poiena, “Alia e Iesu, a katun te kato hakamitse mulö. Te kato hakamits ramia lö u katun i tar, alö e kato hakamits hase molia. ");
INSERT INTO hla_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Alö go takei ba lö te lam tara taun ba nori te na hateie rilö a saha ka te go kato lö.” ");
INSERT INTO hla_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ba pal tson ti la gono mei e Sol e tuolur ba te hahalongolo korur. Nori i hengo u toa u ranga kaba nori i ma tarei ta katun. ");
INSERT INTO hla_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Be Sol e takei talana turu tsikitsiki me hakalatena a matanen, kaba nonei e ma antunan tarei ta ka. Ba nori e pile ner a limanen me las mena rien i Damaskas. ");
INSERT INTO hla_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Na turu topisa u lan nonei e ma antunan tarai, na tara poata teka nonei e ma noui ne ma ua hasi. ");
INSERT INTO hla_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A toa katunun tsitsilo tere Iesu e kaia i Damaskas, a solonen e Ananaias. Nonei e tarei a Tsunono tara hiharuto i tanen ba Tsunono e poieto, “O Ananaias.” Be Ananaias e poiena, “O Tsunono, alia reka.” ");
INSERT INTO hla_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ba Tsunono e poiena i tanen, “Alö go takei ba lö te la uam tara toa kalana a solonen Matskö, ba lö te la uam tara luma tere Judas. Alö e na rangata nem a toa katununa i Tasas a solonen e Sol. Nonei e singo uana tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","E Sol e tarei a toa katun a solonen e Ananaias te butuia turu hiharuto i tanen, ba nonei e tasuna me hatakopena a limanen tere Sol te ga kato haniga pouts menien a matanen.” ");
INSERT INTO hla_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Be Ananaias e ranga palisina me poiena, “O Tsunono, a katun a para i hatei mei lia a katun teka. Nori i poei nonei e kato hakamits korur u katun i tamulö i Jerusalem. ");
INSERT INTO hla_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ba nonei e la uamato teka me ka mena u ranga u tagala turu pris pan turu lotu te poiena e Sol e tatei pile kap rena u barebana hoboto te singo uar i tamulö.” ");
INSERT INTO hla_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ba Tsunono e poieto i tanen, “La tala, taraha alia u hopu kapin a katun teka te ga hatei meni a solor turu katun te halhalir turu Jiu na turu king i taren na turu barebana i Israel. ");
INSERT INTO hla_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ba lia te harutse goien romana a kamits pan te na lue noen romana. U katun te rama nario lia e hakamitse roen romana.” ");
INSERT INTO hla_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Be Ananaias e lana me na tasuna tara luma tere Judas. Ba nonei e na hatakopena a limanen tere Sol me poiena, “O Sol, ara te hatoulana uara tere Kristo, a Tsunono te hale namo lia. E Iesu, te butuma i tamulö i kalana tara poata tu la uama lö teka, nonei te hale namo lia te go mi taguhu meni lia alö ba lö te tara haniga pouts mou, ba lö te saputu memou u Namnamei u Goagono tere Sunahan.” ");
INSERT INTO hla_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ba i teka puku ba ka te herei u kapoana te rus ba nena a matane Sol ba nonei te toan tara haniga poutsuna. Ba nonei e takeina me luena a baptais. ");
INSERT INTO hla_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ba nonei e nouena a tsi kannou me tagtagala poutsuna. ");
INSERT INTO hla_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","E moa te go pina uen ba nonei e la uana turu luman lotu turu Jiu me na hatei rane ien e Iesu me poiena, “Nonei a Pien Tson tere Sunahan!” ");
INSERT INTO hla_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ba barebana hoboto ti hengoen i asingoto koruto me poier, “Nonei a katun teka te atung hamater u katun i Jerusalem ti pala u tere Iesu, bokam? Nonei e la silema teka te go mi kato has u i iesana, te go mi pile kap hasir u katun tere Iesu ba te las mera neien turu pris pan turu lotu, bokam?” ");
INSERT INTO hla_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kaba u ranga tere Sol e pan susul ba nonei e haruto nena e Iesu nonei e Mesaia hamana, a katun te hopu kapin e Sunahan. Na tara poata u Jiu ti kaia i Damaskas i hengo u ranga teka ba nori e ma antunan ranga paliseri e Sol. ");
INSERT INTO hla_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Te kapaia u lan u para, bu Jiu i katoeto u korupakö te gi atung hamate menien e Sol. ");
INSERT INTO hla_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kaba e Sol e hengoin u korupakö teka. A lan na bong, nori i pepeito kapin u tamana tara taun i Damaskas te gi atung hamate meni e Sol. A toa ololo hatu e hahis kapin a taun teka ba te ka mena u tamana i tanen. ");
INSERT INTO hla_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kaba tara toa bong u katunun tsitsilo tere Sol i lue ien ba te na hakoule rien i hapalana a ololo turu pikö pan. ");
INSERT INTO hla_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","E Sol e la u i Jerusalem me na torohanan ka gono merena u katunun tsitsilo tere Iesu. Kaba nori i matoutsen me hahamana ner te go katunun tsitsilo uen tere Iesu. ");
INSERT INTO hla_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Be Banabas e na piou naten turu aposol me hatei rane ien e Sol e tareia a Tsunono i maroro ba Tsunono e ranga gono menen. Be Banabas e hatei has rane ien e Sol e ongolo me ranga hatei nena e Iesu i Damaskas. ");
INSERT INTO hla_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Be Sol e ka gono mera nen me hula lana i Jerusalem. Ba nonei e ongolona me ranga hatei nena a Tsunono. ");
INSERT INTO hla_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Be Sol nu Jiu ti rangaia turu Ha-Grik e hiatagtagala mer u ranga. Ba nori e hakats ner te gi puli menien. ");
INSERT INTO hla_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Na tara poata ti hengo nia u katunun tsitsilo tere Iesu a ka teka, ba nori e na piou naria e Sol tara taun i Sesaria me hala ba naren i Tasas. ");
INSERT INTO hla_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Bu katun hobotor i Judia na i Galili na i Sameria ti hamanaia tere Iesu i ka hanigata tara poata tara masalohana. Ba niateina tere Sunahan e pan susuluna i taren. Ba nori e hapan hitoner a Tsunono bu Namnamei u Goagono tere Sunahan e taguhu ranen. Ba nori e para susulur. ");
INSERT INTO hla_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","E Pita e hula laia tara mamana han teka, ba nonei e gala hasina tara taun i Lida me na ka gono merena u Kristen i Lida. ");
INSERT INTO hla_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tara han teka nonei e tara a toa katun a solonen e Inias. A peisanen e matekata hakapa, ba te opu nitoana tara inana e antunaia turu toal u hingingal. ");
INSERT INTO hla_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Be Pita e poiena i tanen, “O Inias, e Iesu Kristo e kato haniga pouts hamanase nolö. Alö go takei ba lö te hamatsköem a inana i tamulö.” Ba nonei e topei takeina. ");
INSERT INTO hla_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bu katun hoboto tara huol a taun i Lida na i Seran e tare ren te niga pouts uaien ba toriren e toan tabirits uato tara Tsunono. ");
INSERT INTO hla_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tara taun i Jopa a tahol a solonen e Tabita e hamana u tere Iesu. Turu Ha-Grik nori i ngöe ien e Dokas. Tara mamana poata nonei e roron kato a markato a niga, ba te taguhu rena u katun ti moa ta ka. ");
INSERT INTO hla_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tara poata teka nonei e lu a nimate pan koru me matena. Ba nori e totobue ren me na hake rien tara toa rum i iasa i iahana luma. ");
INSERT INTO hla_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","A taun i Lida e susukuna tara taun i Jopa. Bu Kristen i Jopa i hengo neto te ka u e Pita i Lida, ba nori e hala menari a elasolana katun i tanen me na poier i tanen, “Alö go la uama i tamulam. Alö moa te go hamokomoko u.” ");
INSERT INTO hla_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Be Pita e takeina me la gono mera nen. Ba nori e na butu hoboto ria tara luma, bu katun e piou narien tara rum i iasa te kaia e Dokas. U amoba hoboto i mi tuolia i rehina e Pita ba te taber. Nori i harute ien u mamana u hasobu te kato e Dokas me hala rane ien tara poata te ka gono noa mera ien e Dokas. ");
INSERT INTO hla_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Be Pita e halakasa hoboto ranen, ba nonei e hatukununa me singo uana tara Tsunono. Ba nonei e habirits uana tara tahol a mate me poiena, “O Tabita, alö go takei!” Ba tahol e hakalatena a matanen. Ba poata te tare ien e Pita, ba nonei e gum seina. ");
INSERT INTO hla_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Be Pita e pile nena a limanen me las hatakeie nen, be Tabita e tuoluna. Nonei e toatoa pouts tala. Be Pita e ngö gugono rena u amoba na palabir u Kristen, ba nonei e hala pouts rane ien e Dokas. ");
INSERT INTO hla_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nu ranga tara ka teka e hula laia tara mamana makum i Jopa, bu para u katun ti hengo nen e hamana uar tara Tsunono. ");
INSERT INTO hla_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ne Pita e keia i Jopa u lan u para. Nonei e ka gono mei a toa katun te kukuiia turu pikpiköna bulumakau, a solonen e Saimon. ");
INSERT INTO hla_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","A toa katun a solonen e Konilias e kaia tara taun i Sesaria. Nonei a tsunono te kaia tara toa hun soldia ti ngöei a Retsimenina i Itali. ");
INSERT INTO hla_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nonei e hamanaia tere Sunahan, na nonei na pala i tanen hoboto i hatsunonei e Sunahan. Nonei e roron hala nela a moni ti na taguhu meri u Jiu ti moa ta moni, na nonei e roron singo has u tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Turu toa u lan i sukusukuna tara 3 kilok tara lahi ba nonei e tarena u toa u hiharuto. Ba nonei e tara hanige iena a toa angelo tere Sunahan ba te tasuna me poiena i tanen, “O Konilias.” ");
INSERT INTO hla_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Be Konilias e tara tutosona i tanen me matout koruna me poiena, “O tsunono, ha nonei?” Ba angelo e poieto i tanen, “Alö u roron singo u tere Sunahan ba te hala nemula u moni turu katun ti moa ta moni. Ne Sunahan e rutei a ka teka me sasala menen. ");
INSERT INTO hla_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Alö go hala nela u katun tara taun te ngöeri i Jopa, ba nori te na ngöe rima a toa katun a solonen e Saimon Pita. ");
INSERT INTO hla_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nonei e ka gono mena a tana Saimon, a katun te kukuina tara pikpiköna bulumakau. A luma i tanen e kana i rehina u tasi.” ");
INSERT INTO hla_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","A angelo e ranga hakapaia i tanen me la ba nanen. Be Konilias e ngö rena a elasolana katunun kui i tanen, ba nonei e ngö hasena a toa soldia te kuibe hase ien na te hatsunoni e Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ba nonei e hatei ranen a ka te butuia i tanen me hala mera neien i Jopa. ");
INSERT INTO hla_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bu hamahö, tara poata ti la noa ien i maroro ba te la hasukusuku ria tara taun, be Pita e seina tara makumun roro i ieluna luma ba te na katsin singo uana tere Sunahan tara soasa. ");
INSERT INTO hla_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ba nonei e sagohena a bes me katsin nouna. Tara poata ti nas noe ien a tsi kannou, be Pita e tarena u toa u hiharuto. ");
INSERT INTO hla_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ba nonei e rutena u Kolö e takalata hakapa, ba toa ka te herei u seil e koul nama i puta me here nei a elahats a katun i pileia tara tohats a kona ba te hakoule ren. ");
INSERT INTO hla_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mamana mar haruete te kaia turu seil teka: u poum nu kori na mamana ka te silna turu tsikitsiki nu apena has ti ka hoboto has. ");
INSERT INTO hla_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Bu toa u ranga e poiena i tanen, “O Pita, alö go takei, ba lö te atung hamatem ba te noum!” ");
INSERT INTO hla_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Be Pita e poieto, “O Tsunono, e moa koru! Taraha, alia e namala nouegi ta ka te hagonein e Sunahan.” ");
INSERT INTO hla_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Bu ranga teka e poe lelena i tanen, “A ka te haniga nena e Sunahan te go noui lö e go ma tatei agono nilö.” ");
INSERT INTO hla_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","A ka teka e butuia tara topisa poata bu seil e songots la sei poutsuna i Kolö. ");
INSERT INTO hla_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Be Pita e hakats hapan nena a ka teka te tare ien me hakhakats nena a saha mounen. Na tara poata teka u katun te hala rema e Konilias i sabe hakapema a luma tere Saimon ba te mi tuol ria i matana tamana. ");
INSERT INTO hla_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ba nori e ngör ba te rangatar, “A toa katun a solonen e Saimon Pita e kana reka?” ");
INSERT INTO hla_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Be Pita te hakats noa nena a ka te tare ien, bu Namnamei tere Sunahan e poieto i tanen, “A elapisa katun e mi sakie rio lö. ");
INSERT INTO hla_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Alö go takei ba lö te koulum i puta ba te na la gono mera men. Alö go ma tokui, taraha alia te hala ragu men.” ");
INSERT INTO hla_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Be Pita e koul uana i puta ba te poiena turu katun, “Alia a katun te sakie muma limiu. Alimiu e la sile muma aha?” ");
INSERT INTO hla_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ba nori e poier, “A toa tsunono tara ami e Konilias e hala rena molam. Nonei a katun a niga na nonei e hatsunonena e Sunahan, nu Jiu hoboto e hanige ren. A toa angelo tere Sunahan e butuia i tanen me poiena, ‘Alö go na ngöe iema e Saimon Pita ba nonei te la uanama i luma i tamulö, ba lö te hengoem u ranga i tanen.’” ");
INSERT INTO hla_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Be Pita e las hagum rena u katun ba nori e soho ria i luma tere Saimon. Bu hamahö be Pita te la gono mera nen, na palair u katunur i Jopa ti hamanaia tere Iesu i la gono has meren. ");
INSERT INTO hla_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ba nori e na soho ria i maroro, bu hamahö ba nori e na tuku ria i Sesaria. E Konilias e ngö gugono hakaper a man sungutu i tanen na ma tsomi has i tanen, ba nori e hahaloso raren. ");
INSERT INTO hla_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tara poata te tukuia e Pita, be Konilias e tupale ten me hatukunna i matanen ba te turu putana. ");
INSERT INTO hla_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Be Pita e hatakeie nen me poiena, “Takei, taraha alia a katun tun has.” ");
INSERT INTO hla_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Be Pita e ranga gono mena e Konilias ba nori e tasur i luma, be Pita e tarena u katun u para ti gono hoboto. ");
INSERT INTO hla_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ba nonei e poieto i taren, “Alimiu e atei silemiu a lo i tamulam u Jiu te hapiu nena te go hikapien u lam na limiu u katun halhal. Na lam u Jiu e ma tatei tasu has mia tara luma i tamilimiu. Kaba e Sunahan e harutsei lia te go ma hakats lel u lia teka. Alia e ma tatei poegi a tana katun e tara halelna i matana e Sunahan. E moa. ");
INSERT INTO hla_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Na poata tu ngöe mula limiu alia, ba lia te la guma me ma ramagi. Na lia e katsin rangata rago limiu, aha tu ngö sile mei limiu alia?” ");
INSERT INTO hla_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Be Konilias e poieto, “Turu tohats u lan te la hakapa, tara mar aua teka, alia u poei u singona tara 3 kilok tara lahi. Ba toa katun te hasei u hasobu u kankanaha e singotei butuna me tuoluna i matar. ");
INSERT INTO hla_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ba nonei e poiena, ‘O Konilias, e Sunahan e hengo hakapi u singo i tamulö, ba nonei e hakats kap nena tu roron hala meni lö u moni turu katun ti moa ta moni. ");
INSERT INTO hla_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Alö go hala nela u katun i Jopa ba nori te na ngöe rima a toa katun a solonen e Saimon Pita. E kana tara luma tara tana Saimon te kukuina tara pikpiköna bulumakau. A luma reka e kana i rehina u tasi.’ ");
INSERT INTO hla_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ba lia u toan ngöe tolö, ba lö te la hakapa muma ba te mi kato hasasale molia. Na lam e ka hoboto tala mia i teka i matana e Sunahan, ba lam te katsin hengoem u ranga hoboto te halei lö a Tsunono.” ");
INSERT INTO hla_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Be Pita e tanian rangana me poiena, “Alia e atei hamana talagu e Sunahan e ma ngil kalakala ranei u katunur i puta. E moa. ");
INSERT INTO hla_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","E Sunahan e haniga rena u katun turu han hoboto te hatsunone ren na te kato hamatskör. ");
INSERT INTO hla_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Alimiu e atei silemiu u ranga te hala namen i tamulam a tei Israel. U ranga teka e habulungana nena a masalohana te mi halan e Iesu, ba te hakapa hasena u pakö turu katun i tanen. Nonei e panna turu katun hoboto. ");
INSERT INTO hla_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","U ranga teka e taniama i Galili i murina te baptais ria e Jon a barebana, ba te la hobotona turu han i Judia. ");
INSERT INTO hla_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Alimiu e atei silemiu e Iesu ni Nasaret. E Sunahan e hale meien u Namnamei u Goagono na nitagala has. Nonei e hula la ba te hitaguhuna tara barebana ba nonei te kato haniga pouts rena u katun hoboto ti ka mei a nimate nu katun te pile kapir e Satan, taraha e Sunahan e ka gono meien. ");
INSERT INTO hla_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Alam tu tarei a man ka hoboto te kato ien i Jerusalem na tara palabir u han has turu Jiu. Ba nori i hakutie ten tara koruse ba te pulie ren. ");
INSERT INTO hla_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kaba turu hatopisana u lan e Sunahan e hatakei poutsen tara tou mate i tanen, ba nonei te haruto nanen turu ualesala i matar a barebana. ");
INSERT INTO hla_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","U katun hoboto i ma tare ien kaba alam tu tare ien, taraha e Sunahan e hopu kap mamir lam te go tara meni lam a ka teka ba lam te na hahatei namen. Alam u nou gono meien nu ua gono has meien i murina te takei pouts ien tara tou mate. ");
INSERT INTO hla_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Na nonei e ranga meri lam me poiena, ‘Alimiu go na hahatei niam u Bulungana u Niga tara barebana, ba te na hatei ramien e Sunahan e hopu kap nio lia te go tsimou meni lia u katun te toatoar nu katun ti mate.’ ");
INSERT INTO hla_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","U propet hoboto i ranga nen me poier u katun hoboto te hamana ria i tanen, e Sunahan e lu ba bera neien u markato u omi, taraha e Iesu e taguhu ranen.” ");
INSERT INTO hla_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","E Pita e ranga noa bu Namnamei u Goagono tere Sunahan e koul nama me mi gumuna turu katun hoboto ti hengo u ranga. ");
INSERT INTO hla_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","U Jiu ti la gono mema e Pita u katunun tsitsilo tere Iesu. Ba nori e asingotor, taraha e Sunahan e hala nema u Namnamei u Goagono i tanen turu katun has te halhal ria turu Jiu. ");
INSERT INTO hla_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","47","Ba nori e hengo raren ti töho uen turu tanu mar ranga halhalina i Kolö ba te soloseier e Sunahan. Be Pita e poiena, “A barebana teka e lu haser u Namnamei u Goagono tu mar lu has menien lam. A katun e ma tatei hapiu nanei te gi baptais merien u ramun.” ");
INSERT INTO hla_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Be Pita e ranga nena te gi baptais merien tara solona e Iesu Kristo. Ba nori e rangatse ren e go gamon ka gono bume ren. ");
INSERT INTO hla_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","U aposol nu Kristen ti ka kalakalaia i Judia i hengo u ranga te poei a pal katun ti halhalia turu Jiu i lu hakapa hasi u ranga tere Sunahan me hanige ren. ");
INSERT INTO hla_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Na tara poata te la poutsia e Pita i Jerusalem, bu Kristen tara pala turu Jiu i raharaha ten. ");
INSERT INTO hla_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ba nori e poier, “Alö u la u turu luma turu katun te halhal ria turu Jiu, ba lö e nou gono tsipon has mera men! Tara neha tsiponi?” ");
INSERT INTO hla_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Be Pita e tanian hatei nena a mamana ka te butu. ");
INSERT INTO hla_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Nonei e poei, “Alia u kaia tara taun i Jopa me singogu. Bu hakats i tar e tabiritsina ba lia u tareto u toa u hiharuto. A toa ka e koulma i Kolö me here nei u seil u kapan. E herei a elahats a katun ti pilein a tohats a kona turu seil me hakoul mena rien i puta me la uanama i tar. ");
INSERT INTO hla_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Alia u tara haniga koru u i iahana u seil ba lia e taregu a mamana mar haruetena i puta turu seil: u poum nu kori na mamana ka te silna turu tsikitsiki, nu apena has. ");
INSERT INTO hla_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ba lia e hengoegu u toa u ranga e poei i tar, ‘O Pita, alö go takei ba lö te atung hamatem ba te noum.’ ");
INSERT INTO hla_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kaba lia u poei, ‘E moa koru, o Tsunono. Alia u mamala nouei ta toa ta ka tu hagonoin lö.’ ");
INSERT INTO hla_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kaba nonei u ranga teka e la lelma i Kolö ba te ranga hahuol meno lia me poiena, ‘A ka te hanigein e Sunahan te gi noui, alö e ma tatei agono namien.’ ");
INSERT INTO hla_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","A ka teka e butuia tara topisa poata, ba mamana ka hoboto teka e las sei pouts menari i Kolö. ");
INSERT INTO hla_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ba tara toa puku a poata, a elapisa katun e mi butuia tara luma tu kaia lia. A toa katununa i Sesaria te hala mera meien i tar. ");
INSERT INTO hla_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Bu Namnamei tere Sunahan e ranga meno lia, ‘Alö go la gono mera ien. Alö moa te go hakats hapara u.’ Na nori a elonomo a Kristen teka i la gono has meio lia. Ba lam e na tasu mia tara luma tere Konilias. ");
INSERT INTO hla_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ba nonei e hatei ranei lam te tara menien a angelo te tuolia i iahana luma i tanen me poiena, ‘Alö go hala menai ta katun i Jopa, ba te na sakie nama e Saimon te ngö haseri e Pita. ");
INSERT INTO hla_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nonei e hale noi lö u ranga, na turu ranga teka e Sunahan e lu pouts gono hoboto mera noi lö a pala i tamulö.’ A angelo te mar ranga u teka tere Konilias.” ");
INSERT INTO hla_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Be Pita e ranga noana me poiena, “Na poata tu na butuia lia tere Konilias ba te tanian rangagu, bu Namnamei u Goagono e koul uana i taren, te kato has uen i tarara tara poata tutun. ");
INSERT INTO hla_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ba lia u hakats lel neto u ranga tara Tsunono te poei, ‘E Jon e baptaisri u katun u ramun, kaba alimiu e na habaptais moa romana turu Namnamei u Goagono.’ ");
INSERT INTO hla_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","I manasa ara i hamanaia tere Iesu Kristo a Tsunono, be Sunahan e hala nena u Namnamei u Goagono i tarara. Na nonei lasi u Namnamei u Goagono teka te hala rien e Sunahan. Ba lia e moa te go hatu kap meni a maroro tere Sunahan!” E Pita te mar ranga u teka. ");
INSERT INTO hla_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Poata ti hengo ien u ranga teka tere Pita, ba nori e hanige ieren. Ba nori e soloseier e Sunahan me poier, “U mana, e Sunahan e haniga hasir u katun te halhal ria turu Jiu te gi habirits ba menien u markato u omi ba te toatoa has riou.” ");
INSERT INTO hla_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","A pal Kristen i sata noa hasia ti titi hatu hamate meni e Stiven na ti kato homi meri a barebana a pala ti hamana u tere Iesu. Ba nori e la kalakala hanoa ria i Pinisia ni Saipras ni Antiok. Nori i halan u Bulungana u Niga turu Jiu peisa. ");
INSERT INTO hla_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kaba a palabi i taren, nori u katunur i Saipras ni Sairini, nori i la u tara taun i Antiok ba te hatei laner u raranga turu katun has ti halhalia turu Jiu. Nori i rararein u Bulungana u Niga tere Iesu Kristo. ");
INSERT INTO hla_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Na nitagala tara Tsunono e kaia i taren, bu katun u para e hamanar ba te habirits hamatskö menari a toriren tara Tsunono. ");
INSERT INTO hla_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","U Kristenir i Jerusalem i hengoin u ranga tara ka teka, ba nori e hala menari e Banabas i Antiok. ");
INSERT INTO hla_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Poata te na tuku ien, ba nonei e rutena a nihitaguhu tere Sunahan e ka gono mera ien, ba nonei e sasalana. Na nonei e kato hatagali u hakats turu katun hoboto te gi hatagala menien a toriren ba te hamana hiton uar tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","E Banabas a katun a niga, nu Namnamei u Goagono e sapute ien, na nonei e ka has mei u nihamana u tagala. Bu pal katun u para e honoto ria tara pala tara Tsunono. ");
INSERT INTO hla_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Be Banabas e la uato i Tasas te na sake menien e Sol. ");
INSERT INTO hla_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nonei e sabe hakape men me mi piou nanen i Antiok. Ere Banabas mere Sol i ka gono mer u katun tere Iesu i Antiok turu toa u hiningal u ohots, me hatuts rari u katun u para u ranga tere Sunahan. U katunun tsitsilo tere Iesu i ngö tutunri u Kristen nonei tara taun i Antiok. ");
INSERT INTO hla_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tara poata teka, a palabir u propet i la ba nema i Jerusalem, me la uar i Antiok. ");
INSERT INTO hla_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Na toa i taren, a solonen e Agabas, e tuolia turu hagum, na tara nitagala turu Namnamei u Goagono nonei e hatein a bes a kapan e butu noa tara mamana han hoboto i puta. Ba i murimuri, poata te Gamman Pania e Klodias, nonei tara poata teka a bes e butu hamana. ");
INSERT INTO hla_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ba man tutoa man Kristen hobotor i Antiok e kitser u ranga te gi hala hapopo nien u monin hitaguhu turu Kristenir i Judia. ");
INSERT INTO hla_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nori i mar kato u teka, ba nori e hala rer ere Banabas mere Sol te gi na piou menien u moni turu tsunono turu Kristenir i Judia. ");
INSERT INTO hla_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nonei tara poata teka e Herot a King e kato homir a palabir u katun tere Iesu. ");
INSERT INTO hla_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nonei e hangats hamatein a toulane Jon e Jemis u kilatan hiatatung. ");
INSERT INTO hla_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Na poata te tare ien u Jiu i ngil a ka teka, ba nonei e hapile kap has nena e Pita. (A man ka teka e butuia turu wikina turu Paska turu Jiu, poata tara beret te moa ta yis.) ");
INSERT INTO hla_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herot e hapile kapin e Pita me hala mena neien tara karabus. Nori i hake ien tara tohats a hun soldia te gi tara kap menien. A man toa man hun soldia hoboto teka i ka mei a man tohats a man soldia ti roron tara kapin e Pita. Herot e hakats tun me poiena, “I murina te kapa noa u Paska turu Jiu, ba lia te mi toan piou negu e Pita i matar u katun.” ");
INSERT INTO hla_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Be Pita e ka talana tara karabus, ba nori e tara kap naren. Kaba tara mamana poata u Kristen i singo hatagala sile ien tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tara bong i mamina u lan te ngilin hapiou nia e Herot e Pita turu kot, be Pita e sohona i gusuna elasolana soldia. Nori i kitse ien a huol a tsien, nu soldia i tuol hasia tara tamana ba te tara kap ner a luman karabus. ");
INSERT INTO hla_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kaba a toa angelo tara Tsunono e butu, bu ualesala e alesalana i iahana rum te kaia e Pita. Ba angelo e tapalena a liklikina e Pita ba te gulie nen me poiena, “Alö go takei boroboro.” Bu tsien e tapurese ba neto a limane Pita me rusuna. ");
INSERT INTO hla_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ba angelo e ranga menen, “Alö go hasogo u hasobu nu sendol i tamulö.” Be Pita e mar kato uana teka. Ba angelo e ranga menen, “Alö go pits u hasobu u ngahangaha i tamulö ba lö te kukutie mumo lia.” ");
INSERT INTO hla_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Be Pita e lakasana me kukutiena a angelo. Kaba nonei e ma atei silei a ka te katoeia a angelo i tanen te ga mana uen. E Pita e poei e tarei u hiharuto. ");
INSERT INTO hla_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ba nori e lar me la karasa ba ner a tson pepeito tutun na tson pepeito hahuol, ba nori e na butu ria tara tamana aien te mata u tara taun. A tamana teka e takalata peisa ber nori a elasolana katun. Ba nori e lakasar i ielesala me siler a toa maroro. Ba angelo e songots la ba nena e Pita. ");
INSERT INTO hla_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Bu hakats tere Pita e toan talesala poutsuna, ba nonei e poiena, “Alia e atei hamana talagu, a Tsunono e haleie nama a angelo i tanen me lu ba neno lia tara nitagala tere Herot na tara mamana ka ti katsin kato a pala turu Jiu i tar.” ");
INSERT INTO hla_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","E Pita e hakats sabein a ka teka me toan la uana tara luma tere Maria, e tsinane Jon a tana solo i tanen e Mak. U katun u para ti gonoia tara luma teka ba te singor. ");
INSERT INTO hla_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Be Pita e mi porporokona tara tamana tara ololo i ielesala tara luma, ba toa taholun kukui a solonen e Roda e la sile nama te go mi kalata meni a tamana. ");
INSERT INTO hla_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ba nonei e hengo mareiena te ranga u e Pita, ba torinen e sasala koruna. Ba tahol e pieta poutsuna i iahana luma, kaba e ma kalata nai e Pita a tamana! Ba nonei e hatei ranen, “E Pita e tuolna tara tamana!” ");
INSERT INTO hla_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ba nori e poier i tanen, “Alö e tutu korum!” Kaba nonei e tagala koru ba te poiena, “U mana koru nonei e kana!” Ba nori e poier, “A angelo banei i tanen.” ");
INSERT INTO hla_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","E Pita e porporoko noa hasia tara tamana, ba nori e na kalata tale ren me tarer e Pita, ba nori e asingoto korur. ");
INSERT INTO hla_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Be Pita e hasoa sei nena a limanen te gi kakamoto uen. Ba nonei e hatei rane ien te mi piou menien a Tsunono i ielesala tara luman karabus. Ba nonei e poiena, “Alimiu e na hateie mou e Jemis na palabir u Kristen te butu ualala a ka teka.” Be Pita e la ba ranen me lana tara tana makum. ");
INSERT INTO hla_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ba bongbong, bu soldia e asingoto korur, me poier, “Pua, ime tsiponi e Pita?” ");
INSERT INTO hla_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Be Herot e hala nena u ranga te gi na sake lameni e Pita, kaba i ma sabie ien. Te mar kato uen teka, ba nonei e kot rena u soldia ti taratara kapin e Pita, ba nonei e kitsena u ranga te gi atung hamate merien. Be Herot e la ba nena i Judia me galana tara taun i Sesaria me na kana nonei tara han. ");
INSERT INTO hla_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tara poata teka e Herot a King e raharaha korur u katunur tara huol a taun i Taia na i Saidon. Ba nori e gono hobotor me la mam uar tere Blastas, a toa tson pepeito tere Herot. Nori i hamatskö gono mam mei e Blastas u ranga me toan la uar tere Herot. Ba nori e rangata siler te ga hakapa meni e Herot a raharaha. Taraha, u katunur tara han i taren i roron holeia a kannou tara pal katun tere Herot. ");
INSERT INTO hla_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Be Herot e hopu kap nena u toa u lan, ba turu lan teka nonei e hasogi u hasobu u ngahangaha tara king, me gumna turu gumgum u goagono, me katoena u ranga u ngahangaha i taren. ");
INSERT INTO hla_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bu katun e ku hapanir me poier, “Nonei e ma ranga uanei tara katun tun! E moa. Nonei u ranga tara toa got!” ");
INSERT INTO hla_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kaba e Herot e ma soloseii e Sunahan, ba i teka puku ba angelo tara Tsunono e atunge nen. Bu ngungoto e noue ren, ba nonei e mate nitoana. ");
INSERT INTO hla_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Bu ranga tara Tsunono e butu hapanina me tasatana turu han u para. ");
INSERT INTO hla_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Na tara poata ti hakapeia ere Banabas mere Sol a toukui i taren i Jerusalem, ba nori e luer e Jon Mak, ba nonei e la pouts gono mera nen i Antiok. ");
INSERT INTO hla_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","I gusuna pal katun tere Kristo i Antiok i kaia u propet nu katunun hihatuts turu lotu. Nori ere Banabas, mere Simion ti ngö hasei a Korokun, ne Lusias ni Sairini, ne Maneien a hatoulana tere Herot a King, ne Sol. ");
INSERT INTO hla_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tara poata u Kristen i singo u tara Tsunono me agono ner a kannou, bu Namnamei u Goagono e poieto, “Alimiu go hopu kap gono memi ere Banabas mere Sol a toukui tu ngö merien lia e gi katoen.” ");
INSERT INTO hla_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ba nori e agono lel ner a kannou me singo uar tara Tsunono, ba nori e hatakope ria a limaren tere Banabas mere Sol, ba nori e hala mera rien tara toukui i taren. ");
INSERT INTO hla_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Bu Namnamei u Goagono e hala ranen ba nori e gala uar tara taun i Selusia. I Selusia nori i osaia tara tolala, ba tolala e lu mera neien tara tolo pan a solonen i Saipras. ");
INSERT INTO hla_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ba nori e na tuku ria tara taun i Salamis me hatei laner u ranga tere Sunahan turu luman lotu turu Jiu. Ne Jon Mak e ka gono has mera ien te ga taguhu merien. ");
INSERT INTO hla_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ba nori e hula la ria tara mamana han i Saipras, ba nori e na tuku ria tara taun i Pepos. I Pepos nori i hitupal mei a toa Jiu a solonen e Ba-Jisas (na turu Ha-Grik i ngö hase ien Elimas). Nonei a katunun kukui turu matuna na hirakö, na nonei e ngö gamogamo hasei a peisanen a toa propet. ");
INSERT INTO hla_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nonei e ka gono mei e Gamman tara tolo teka, a solonen Setsias Polas, a katun te ka mei u niatei u niga. Be Setsias Polas e ngö rena ere Banabas mere Sol, taraha nonei e ngilin hengoen u ranga tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kaba e Elimas e torohanan ranga kap ren. Nonei e ngilin habiritsin u hakats tere Gamman be Gamman te ma hamana uanei tara Tsunono. ");
INSERT INTO hla_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Kaba e Sol, ti ngö hasei e Pol, e toan saputu mei u Namnamei u Goagono, ba te tara hamatskö uana tere Elimas me poiena, “Alö a pien tere Satan! Alö e paköem a mamana markato a matskö! Mamana markato turu gamo na mamana markato a omi e saputu korue nolö! Alö e roron kato hakokoele iem a mamana maroro a matskö tara Tsunono, na lö e ma ngilin hapolasa has nami a markato teka i tamulö! ");
INSERT INTO hla_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Alia e hateie golö, a nihahuna tara Tsunono e koul hamanasa uanama i tamulö, ba matamulö te gamon kiau nou ba lö te ma antunan tara has namoi a pitala!” E Pol e mar ranga u teka, ba ka te herei u koasi u ruruhana e topei hatu kap nena a matane Elimas. Ba nonei e hula lalana me sakiena ta katun te ga pilein a limanen ba te harute neien a maroro. ");
INSERT INTO hla_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Be Gamman e tareto a ka teka me toan hamanana. Nonei e asingoto koru ba te hakats hapara nena u hihatuts tara Tsunono. ");
INSERT INTO hla_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","E Pol nu katun ti lala gono meien i la ban a taun i Pepos, ba tolala e lu mera neien tara taun i Pega tara provins i Pampilia. Kaba e Jon Mak e la ba reien me la pouts uana i Jerusalem. ");
INSERT INTO hla_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ba nori e la ba ner i Pega, ba te na tatala habutu ria tara taun i Antiok tara provins i Pisidia. Na turu lanin lotu nori i tasuia tara luman lotu turu Jiu, me gumur. ");
INSERT INTO hla_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","A toa katun e rit hapan a palabina u ranga turu Lo tere Moses na palabina u ranga turu propet, bu tsunono turu lotu e toan hala menari u ranga tere Pol na pal katun i tanen, me poier, “A ma tsi hatoulana, te ka memia limiu ta tsi rangan hitaguhu turu katun, ba limiu te tatei hateimiu.” ");
INSERT INTO hla_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Be Pol e tuoluna me hasoasei nena a limana te gi hengo menien u katun me poiena, “Alimiu u katunur i Israel, na limiu a palabir u katun te hatsunono hasemiu e Sunahan, alimiu go hengo iam. ");
INSERT INTO hla_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","E Sunahan, te tara kap rena a pal barebanar i Israel, nonei te hopu kapir u tuburara, na tara poata ti ka ien tara han i Itsip, ba nonei e kato hapara koru ranen. Na i murimuri, tara nitagala pan i tanen, nonei e mi peigi ba rien a han i Itsip. ");
INSERT INTO hla_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Na nonei e tara kap rien tara latu pinopino, ba te hakats sil koruena u markato u omi i taren e antunaia turu 40 u hiningal. ");
INSERT INTO hla_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tara han i Kenan e Sunahan e kato homir a tohit a pal katun, me hala ranei a Israel u tsikitsiki i taren. Ba nori e pile ner u tsikitsiki teka e antunaia turu 450 u hiningal.” ");
INSERT INTO hla_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","E Pol e ranga lel me poiena, “E Sunahan e toan haka reto u tsonun taratarakap tara Israel e antunaia tara poata tere Samuel a propet. ");
INSERT INTO hla_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Na nonei tara poata teka u katunur i Israel i ngil ta toa ta king, be Sunahan e hala rane ien e Sol, a pien tere Kis na pala tere Bentsamen. Nonei e kingia i Israel turu 40 u hiningal. ");
INSERT INTO hla_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Be Sunahan e tsuge nen me hake iena e Devit a king i taren. Nonei e mar hatei menai e Devit teka: ‘Alia e tara sabiegu e Devit a pien tere Jesi nonei a mar katun te ngile gulia. A torir e ngil korue nen. Nonei te kukute hanige nou u mamana u ngil hoboto i tar.’ E Sunahan te mar ranga u teka. ");
INSERT INTO hla_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Tara pala tere Devit i murimuri, e Sunahan e habutu e Iesu, a katun te ga lu pouts raio ra, me hala nanen tara Israel, te ranga hamana u e Sunahan i manasa. ");
INSERT INTO hla_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","I mam te butuia e Iesu, e Jon a Tsonun Baptais e habulunganein u ranga tara Israel hoboto te gi habirits menien a toriren ba nori te habaptaisir. ");
INSERT INTO hla_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Na poata te katsin kapaia a toukui tere Jon, ba nonei e poiena, ‘Alimiu e poemiu alia esi? E Kristo? E moa. Kaba limiu go hengo iam! E Kristo te la hamurimuri nama romana i tar. Nonei a Tsunono pan, na lia a katun papala koru.’ Jon te mar ranga u teka.” ");
INSERT INTO hla_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","U raranga tere Pol e la noa me poiena, “A ma tsi hahatoulana i tar tara pala tere Abraham, na limiu has a palabir u katun te hatsunonemiu e Sunahan, u raranga te poiena e Sunahan e ngilin lu pouts rena u katun i hala mena meien i tarara noa has. ");
INSERT INTO hla_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","U katunur i Jerusalem na pal kapan i taren i ma atei silei e Iesu nonei e Mesaia. Na nori i ma atei haniga silei u ranga turu propet ti roron rite ien turu mamanu lanin lotu. E moa. Nori i kotin e Iesu ba nori e mar kato mena rien ti mar ranga u u propet i manasa. ");
INSERT INTO hla_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nori i ma sabei ta toa ta ka te ga antunaia te gi kato hamate menien. Kaba nori i rangats e Pailat te gi atung hamate noa has menien. ");
INSERT INTO hla_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Na tara poata ti kato hakape ien a mamana ka ti koloto mamin u propet, ba nori e atung hamatie ier e Iesu. Ba nori e lu hakoule rien tara koruse, me na honge rien tara kioun mate. ");
INSERT INTO hla_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","31","Kaba e Sunahan e hatakei poutse ien tara tou mate, nu katun ti la ban i Galili me la gono mena rien i Jerusalem, nori i tare ien turu lan u para i murina tara poata te takei pouts ien. Nu katun teka e roron habulungana naren tara barebana. ");
INSERT INTO hla_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Na lam e hatei has rami limiu u Bulungana u Niga teka. A ka te hateiri e Sunahan u tuburara i manasa te ga katoen, nonei e kato hakapa berien ra u hatutubunei i taren, te hatakei menien e Iesu. U Buk u Goagono e mar ranga has u teka turu hahuoluna u Sam, te poieia e Sunahan, ‘Alö a pien i tar. I romana alö e hatamana mia i tar.’ ");
INSERT INTO hla_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","E Sunahan e hatakei poutse ien tara tou mate, na nonei e ma antunan mate lel nei ba te koremena. E moa. E mar kato uana te ranga u e Sunahan, ‘Alia e kato hamana bera gilimiu romana a ka a niga tu ranga hamana nia lia tere Devit i manasa.’ ");
INSERT INTO hla_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Gaha nonei a ‘ka a niga’ teka? U Buk u Goagono e mar hatei mena neien teka turu tanu Sam, ‘Alö e ma haniga namoi romana te go koreme u a tsomi i tamulö. E moa.’ ");
INSERT INTO hla_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","U ranga teka e ma hatei nanei e Devit. Tara neha, i murina te kato e Devit u ngil tere Sunahan tara poata i tanen, ba nonei e toan matena ba nori e ngaho narien ti ngaho ria u tubunen, ba nonei e koremena. ");
INSERT INTO hla_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kaba e Iesu nonei a katun te hatakei poutsi e Sunahan, nonei e ma koremei. ");
INSERT INTO hla_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Na ma tsi hahatoulana, alia e habulungana ragi limiu, nonei a katun teka e Iesu te lu sila ba nena e Sunahan u markato u omi i tamilimiu. ");
INSERT INTO hla_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","U Lo tere Moses e ma antunan lu ba nanei u markato u omi i tamilimiu ba te ngö ranei limiu u katun u matskö. Kaba e Iesu e lu ba nena u markato u omi hoboto turu katun te hamana uar i tanen, ba te ngö has rane ien u katun u matskö. ");
INSERT INTO hla_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Alimiu go hanei iam! A ka teka e namos la uanama i tamilimiu, ti rangein u propet i manasa me poier, ");
INSERT INTO hla_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Alimiu u katun te hahakosmiu, alimiu go tara iam, ba te asingoto korumiu, ba te toan tiamiu! Alia e katoegu a toa toukui tara poata teka i tamilimiu. Na te hatei haniga ranoa limiu ta toa ta katun tara toukui teka, ba limiu te ma hamana koru noa has moi.’” E Pol e mar ranga u teka me toan hakapana. ");
INSERT INTO hla_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ere Pol mere Banabas i katsin lakasa u i ielesala bu katun e poier, “Turu lanin lotu te la nama alimiu go hatei lel naiam u ranga teka i tamulam.” ");
INSERT INTO hla_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","A barebana i tarura tala, nu Jiu u para nu katun halhal ti honoto hasia turu lotu turu Jiu, nori i kukute ere Pol mere Banabas. Ba nori a elasolana katun e hala ner u ranga u niga i taren ba te ranga hatagala mera ren te gi ka hatagala uen tara hitaguhu tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na turu tanu lanin lotu, u katun u para koru tara taun teka i gono silema te gi mi hengo menien u ranga tere Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kaba palabir u Jiu i tara u katun u para ti gono, ba toriren e hiomi koruna. Nori i torohanan pita-putei u ranga tere Pol ba te ranga homi naren. ");
INSERT INTO hla_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ti mar kato uen teka be Pol ne Banabas e ranga hatagala korur me poier, “E matsköna tu hala mam meri lam alimiu u ranga tere Sunahan. Kaba limiu e tori-tsuga ba namen ba te kato here rami a peisamiu u katun te raman lu ner a nitoatoa te ka nitoana. Te kato uanen teka ba lam te la hamanasam tara pala te halhal ria turu Jiu. ");
INSERT INTO hla_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","A Tsunono e mar hatei mera mei lam teka: ‘Alia e haka here ragi limiu u ualesala turu katun te halhal ria turu Jiu. Ba limiu te tatei taguhu ramiu u katun tara mamana han i puta, ba lia te lu pouts ragoen romana.’” ");
INSERT INTO hla_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","U katun ti ma Jiui i hengo u ranga teka, ba nori e sasala korur, me hanige ier u ranga tere Sunahan. Nu katun te hopu kapir e Sunahan te gi toatoa nitoa, nori i hamana u i tanen. ");
INSERT INTO hla_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nu ranga tara Tsunono e tasata hobotoia tara mamana han ti ka hasukusuku. ");
INSERT INTO hla_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kaba palabir u Jiu i hatakei a raharaha tara tohaliouna turu lotu ti ka mei a solo pan, na turu tsunono has tara taun teka, ba nori e tanian kato homi rer ere Pol mere Banabas. Ba nori e tsuga rarien tara han i taren. ");
INSERT INTO hla_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","I kato u teka, be Pol ne Banabas e taholo ba ner u koahu i mouren, ba te mar haruto menari te raharaha mera nei e Sunahan u katununa tara han teka. Ba nori e lar i Aikoniam. ");
INSERT INTO hla_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kaba u Kristen i Antiok i sasala koru, ba nitagala turu Namnamei u Goagono e saputuna i taren. ");
INSERT INTO hla_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tara taun i Aikoniam ere Pol mere Banabas i mar kato has u i iesana. Nori i tasu u i iahana luman lotu turu Jiu me hatei ner u ranga. Nori i hatein u ranga u niga bu katun u para turu Jiu na turu Grik e hamanar. ");
INSERT INTO hla_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kaba palabir u Jiu i ma hamanai, ba nori e hatakeier a raharaha turu katun ti halhalia turu Jiu, ba nori e tori-hasoala ria turu ");
INSERT INTO hla_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kaba e Pol ne Banabas i kei a poata lehana i Aikoniam, na nori i tagala mei ti hatei menien u ranga tara Tsunono. Ba Tsunono e hatagala ranen ba nori e katoer u mamana u mirakul. Tara ka teka a Tsunono e haruto nia turu katun u rangan hitaguhu i tanen e mana koru. ");
INSERT INTO hla_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kaba u katun tara taun teka i lu kata me katoer a huol a pala. A palabi i hanigei u ranga turu Jiu, na palabi i hanigei u ranga turu aposol. ");
INSERT INTO hla_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Bu Jiu nu katun halhal has e toan takei gono merer u tsunono i taren. Nori i katsin kato homir ere Pol mere Banabas ba te titi hatu hamate raren. ");
INSERT INTO hla_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ere Pol mere Banabas i hengo sabe a ka teka, ba nori e bus uar tara provins i Likionia, me kui laria turu taun i Listra na i Debi, na tara man han ti sukusuku. ");
INSERT INTO hla_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ba nori e hatei ner u Bulungana u Niga turu han teka. ");
INSERT INTO hla_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Tara taun i Listra a toa katun e gum a man mounen e ma tagalai. Tara poata te pose ien e tsinanan, a mounen e omi hakapa noa has na nonei e mamala tatalai. ");
INSERT INTO hla_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ba nonei e hengoena u ranga te kato e Pol. Be Pol e tarena a katun teka e ka mei u nihamana e antunaia te ga tatei butu haniga pouts uen. ");
INSERT INTO hla_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Be Pol e tara hatagala uana i tanen me ranga hapanina ba te poiena i tanen, “Alö go takei ba lö te tuol hamatskö nem a moumulö.” Ba nonei e topei takeina me hula tatalana. ");
INSERT INTO hla_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","U katun u para ti tarei a ka teka te kato e Pol i ku hapan u turu rangan Ha-Likionia me poier, “U got e butu here rimei u katun, me koul puta uarima i tarara!” ");
INSERT INTO hla_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ne Banabas i ngöe ien e Sius, ne Pol i ngöe ien e Hermis,* taraha e Pol a katunun raranga. ");
INSERT INTO hla_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","A luman lotu pan tere Sius e kaia i matana taun i ielesala. Na pris tara luman lotu pan teka e lu gono mei u bulumakau u tson u palaua ti hil haperpereri. Ba nonei e la uanama tara tamana tara ololo tara taun. Nonei nu katun ti ngilin katoen u hats tara elasolana aposol. ");
INSERT INTO hla_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kaba e Banabas ne Pol i hengo u ranga tara ka teka, ba nori e kise ier u hasobu i taren ba te haruto ner te rama koru mena rien a markato teka. Ba nori e piata uar i gusur u barebana ba nori e kur, ");
INSERT INTO hla_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Alimiu e moa te go mar kato uam teka! Alam u katun tun lasi e here has rami limiu. Alam u la silema te go hatei menai u Bulungana u Niga ba limiu te hapolasemiu a markato a tutu teka, ba te habirits uamiu tere Sunahan te toatoana. Nonei te kato u kolö nu puta nu tasi, na mamana ka te kana i iaharen. ");
INSERT INTO hla_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","E manana, tara mamana poata i manasa u katun i mar kato u ti ngil uen, ne Sunahan e ma hakapa rien. ");
INSERT INTO hla_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Kaba nonei e roron haruto noa has nena te mar kato haniga uanen i tamilimiu. Nonei e roron hapoloena a langitsina i kolö ba te hahua hanige iena u kui i tamilimiu. Nonei e hantune iena a kannou i tamilimiu ba te kato hasasala has rena a torimilimiu.” ");
INSERT INTO hla_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","U aposol i ranga u teka ba te torohana hatagala korur, ba nori e hatu kap rer u katun ba te ma tatei katoe roi tu hats i taren. ");
INSERT INTO hla_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kaba a palabir u Jiu turu taun i Antiok na i Aikoniam i lama, ba te mi kato homier u hakats turu katun. Ba nori e ti homi korueri e Pol u hatu, ba nori e las halakasa ba narien a taun. Nori i poei e mate hakapa, ba te la ba naren. ");
INSERT INTO hla_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kaba u Kristen e mi gono hahise ien, ba nonei e takeina ba te na tasu poutsuna i iahana taun. Hamahö ba nonei e la gono mena e Banabas tara taun i Debi. ");
INSERT INTO hla_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ere Pol mere Banabas i rararein u Bulungana u Niga tara taun i Debi, bu katun u para i butun katunun tsitsilo uato tere Iesu. Ba nori e la sila pouts uar turu taun i Listra na i Aikoniam, na i Antiok te kana tara provins i Pisidia. ");
INSERT INTO hla_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ba nori e hatagala rer a torir u Kristen. Nori i halan u rangan hitaguhu i taren me poier, “Alimiu e go hamana hatagala hiton uam tara Tsunono. A maroro te sila uara ra ba te na tasu ria tara Nipepeito tere Sunahan, a maroro teka e ka mena u hakats u tiama u para i tanen.” Nori i mar ranga u teka. ");
INSERT INTO hla_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tara pala turu Kristen tara mamana taun, nori i hopu kapir u katunun pepeitokap i taren ti hamana u tara Tsunono. Ba nori e agono ner a kannou me katoer u singo, ba nori e haka reria u Kristen tara nitagala tara Tsunono te ga tatei tara kap merien. ");
INSERT INTO hla_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Be re Pol mere Banabas e la sila uar tara provins i Pisidia me na tuku ria tara provins i Pampilia. ");
INSERT INTO hla_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ba nori e hatei naria u ranga tara taun i Pega, me gala lel uar tara taun i Atelia. ");
INSERT INTO hla_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","I Atelia nori i osaia tara tolala ba tolala e lu pouts mera neien i Antiokuna i Siria. I manasa tara han teka, u Kristen i haka rien tara hitaguhu tere Sunahan te gi kato menien nonei a toukui teka te kapa hamanasana. ");
INSERT INTO hla_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nori i mi butuia i Antiok me gono hoboto rer u Kristen. Ba nori e hahatei ner a mamana ka hoboto te kato sila rien e Sunahan, me poier, “E Sunahan e kato a maroro turu katun te halhal ria turu Jiu, ba nori e hamanar.” ");
INSERT INTO hla_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Be re Pol mere Banabas e ka gono merer u Kristen i Antiok tara poata lehana. ");
INSERT INTO hla_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kaba a palabir u katunur i Judia i la uama i Antiok me mi tanian hatuts rer u katun u Kristen. Nori i poei, “Te ma kukute moi limiu a markato tere Moses ba te ma hapö namoi a hatoatongo tere Sunahan i pikpikömilimiu, be Sunahan te ma taguhu ranoi romana limiu.” ");
INSERT INTO hla_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ti mar ranga uen teka, be Pol mere Banabas e ka mer a raharaha pan i taren ba te hiangenngena gono tun mera ren. Bu Kristen e hatuol rer ere Pol mere Banabas na palabir u katun has te gi la uen i Jerusalem ba te na hamatskö gono merari u aposol na pal kapan turu Kristen lotu u ranga teka. ");
INSERT INTO hla_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bu Kristen e na hipiou ria i taren ba nori e la hagusuna ria tara provins i Pinisia ni Sameria. Nori i hatei hatarareri u Kristen tara huol a han teka e Sunahan e habirits a torir u katun ti halhalia turu Jiu. Ti markato uen teka, ba nori e kato hasasala koru rer a torir u Kristen. ");
INSERT INTO hla_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tara poata ti na tuku hakapa ien i Jerusalem, bu aposol na pal kapan na palabir u Kristen i sasala mieto ti tara merien. Be Pol mere Banabas e hatei rarien a mamana ka hoboto te kato gono merien e Sunahan. ");
INSERT INTO hla_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kaba a palabir u Kristen tara pala turu Parisi i takei me poier, “Alimiu go pö namia a hatoatongo tere Sunahan i pikpikör u katun te ma Jiuri, ba limiu te hatei ramen nori e gi kukute u Lo tere Moses.” ");
INSERT INTO hla_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bu aposol na pal kapan e gono sil taler te gi hamatskö menien u ranga teka. ");
INSERT INTO hla_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nori