﻿USE sofia;
DROP TABLE IF EXISTS sofia.hixNT_vpl;
CREATE TABLE hixNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hixNT_vpl WRITE;
INSERT INTO hixNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Txesusu Kryestu hoko àmenhehe. Noro rma, Dafe heno yohamàtho me nehxakon hatà. Akmaraw heno yohamàtho me rma nehxakon hatà. Onà wyaro nehxatxkon hatà, Txesus horyen heno komo, Akmaraw heno yohamàthàyamo. ");
INSERT INTO hixNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Akmaraw heno muru me nehxakon hatà, Esake heno. Esake heno muru me nehxakon hatà, Xako heno. Xako heno muru me nehxatxkon hatà, Xukna heno, ewtà heno komo xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Xukna heno muru me nehxatxkon hatà, Peryes heno komo, Sera heno xarha. Nyamoro yon me nehxakon hatà, Tamah heno. Peryes heno muru me nehxakon hatà, Esraw heno. Esraw heno muru me nehxakon hatà, Araw heno. ");
INSERT INTO hixNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Araw heno muru me nehxakon hatà, Amenaknakme heno. Amenaknakme heno muru me nehxakon hatà, Nasawu heno. Nasawu heno muru me nehxakon hatà, Sarmaw heno. ");
INSERT INTO hixNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sarmaw heno muru me nehxakon hatà, Boas heno. Noro yon me nehxakon hatà, Hakme heno. Boas heno muru me nehxakon hatà, Okmekne heno. Noro yon me nehxakon hatà, Hutxe heno. Okmekne heno muru me nehxakon hatà, Xese heno. ");
INSERT INTO hixNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Xese heno muru me nehxakon hatà, Dafe heno. Noro heno rma, Ehsayewyana komo kayaryet me ymo nehxakon hatà. Dafe heno muru me nehxakon hatà, Saromaw heno. Noro yon me nehxakon hatà, Uryeyas heno hetxenho. Noro rma, Dafe hetx me harha nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saromaw heno muru me nehxakon hatà, Hokmoaw heno. Hokmoaw heno muru me nehxakon hatà, Akmeyas heno. Akmeyas heno muru me nehxakon hatà, Asa heno. ");
INSERT INTO hixNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa heno muru me nehxakon hatà, Xosafah heno. Xosafah heno muru me nehxakon hatà, Xoraw heno. Xoraw heno muru me nehxakon hatà, Useyas heno. ");
INSERT INTO hixNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Useyas heno muru me nehxakon hatà, Xotaw heno. Xotaw heno muru me nehxakon hatà, Akas heno. Akas heno muru me nehxakon hatà, Esekeyas heno. ");
INSERT INTO hixNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekeyas heno muru me nehxakon hatà, Manases heno. Manases heno muru me nehxakon hatà, Amon heno. Amon heno muru me nehxakon hatà, Xoseyas heno. ");
INSERT INTO hixNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Xoseyas heno muru me nehxatxkon hatà, Xekoneyas heno, ewtà heno komo xarha. Nyamoro heno yehtoko rma, tasom me nehxatxkon hatà, Ehsayewyana heno komo, omeroro. Bakmeronya yamtar hona tasom me nehxatxkon heno hatà. Àton komo nanàr me nehxatxkon heno hatà, anoto komo me harha. ");
INSERT INTO hixNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Amnye nomohtxownà harha tà, Bakmeronya yamtar hoye. Omokàtxhenye rma, onà wyaro nehxatxkon hatà, Txesus horyen heno komo. Xekoneyas heno muru me nehxakon hatà, Sarateyew heno. Sarateyew heno muru me nehxakon hatà, Sorokmakmew heno. ");
INSERT INTO hixNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorokmakmew heno muru me nehxakon hatà, Akmeyukne heno. Akmeyukne heno muru me nehxakon hatà, Eryeyaken heno. Eryeyaken heno muru me nehxakon hatà, Asoh heno. ");
INSERT INTO hixNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoh heno muru me nehxakon hatà, Saknoke heno. Saknoke heno muru me nehxakon hatà, Aken heno. Aken heno muru me nehxakon hatà, Eryeyukne heno. ");
INSERT INTO hixNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eryeyukne heno muru me nehxakon hatà, Eryeyasah heno. Eryeyasah heno muru me nehxakon hatà, Matan heno. Matan heno muru me nehxakon hatà, Xako heno. ");
INSERT INTO hixNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Xako heno muru me nehxakon hatà, Xose heno. Noro heno hetx me nehxakon hatà, Maryeya. Txesus yonà rma mok nehxakon hatà. Kryestu ryhe noro ha, Txesusu, Khoryenkomo nànyaketxho rma. ");
INSERT INTO hixNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Àro wyaro nehxatxkon hatà, Txesus horyen heno komo. Akmaraw heno mahyaka, 14 me nehxatxkon hatà, ehamàthàyamo. 14 me exetxhenye, nenuruy hatà, Dafe heno. Dafe heno mahyaka, 14 me rma rha nehxatxkon hatà, Txesus horyen heno komo xarha. 14 me exetxhenye, tasom me nehxatxkon hatà, Ehsayewyana heno komo, omeroro, Bakmeronya yamtar hona. Àsnye ro omokàtxhenye, 14 me rma rha nehxatxkon hatà, Txesus horyen heno komo xarha. 14 me exetxhenye, nenuruy hatà, Txesusu Kryestu. ");
INSERT INTO hixNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Onà wyaro nehxakon hatà, Txesusu yonuruthuru, Kryestu yonuruthuru. Xose hetx me ekarymaxah me nehxakon hatà, Maryeya, Txesus yonà. Àhyawohra hak nehxakon hatà. Ukukmahnà ro me rma hak nehxakon hatà. Àro wyaro rma tehtoko, yuhna me harha nehxakon hatà. Natahosày hatà, àhokru, Khoryenkom yokato yahoxet yano me mak hatà, kàrà yano mehra mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Khoryenkom yokato yano me ehtxoho hutwahra mak nehxakon hatà, Xose. Àro ke, onà wyaro nehutwekon hatà, tàhnawo. Atxke nehxak hamà, rohetxenho, kekon hatà, tàwya rma. Ahohsàra wehxan hamà, kekon hatà. Enyhoru rma mok nehxakon hatà. Wosà hyahamnohrà xehra mak nehxakon hatà. Àro ke, onà wyaro nkekon xarha tà, tàwya rma. Noro yanhànàtho yokarymahra wehxan hamà, toto komo wya. Ahohsàra mpàn wehxaha kahra wehxan hamà, kekon hatà, Xose, tàwya rma. ");
INSERT INTO hixNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Àro wyaro tehutwantoko rma, nosenyetày hatà. Osenyetnàr me, nosonyhoy hatà, kahe yawono, Kohkom yanoto, àwya. Xose y, kekon hatà, àwya. Dafe heno yohamàtho y, uro enytxako. Maryeya ahosko rma, ohetx me, kekon hatà, kahe yawono. Atxke nehxak hamà kahra exko. Khoryenkom yokato yahoxet yano me ryhe natahohsako, àhokru, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nenuryan hatà, kàrà me txko. Txesus me mesohten hatà. Noro ryhe, tàmryenon komo yonyhoryen hatà, kekon hatà. Tàmryenon komo yanhànàtho yowyan hatà, tàwya enyhoryetxho menye. Àro ke, Txesus me nay hatà, esotà, kekon hatà, kahe yawono, Xose wya, osenyetnàr me hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25","Taa. Hakay hatà, Xose. Kohkom yanoto yoyukye hatà. Maryeya yahosày hatà, thetx me. Ukukmahra hak nehxakon hatà. Amnye nenuruy hatà, àmryerà. Txesus me nesohtoy hatà, Xose. Enurutxhe, thetx kukmay hatà. Àro wyaro nehxakon hatà, Txesusu yonuruthuru, Kohkomo rwonàmàthàràtho yawo ro ehtxoho me. Amnyehra, onà wyaro nkekon hatà, Kohkomo, tanoto heno wya, tàrwon yokarymanye ro heno wya. Amnye hohtehe hampànà, wosà, ukukmahnà ro. Natahohsaha hampànà, àmryerà. Nenuryaha hampànà. Noro yosotà rma, Emanwew me naha hampànà. Àro wyaro nkekon hatà, Kohkomo rwonà yokarymanye ro heno, amnyehra. Àro wyaro katxhàrànhàr yawo ro rma haxa nenuruy hatà, Txesusu. Onà wyaro katxho me rma naha, Emanwew katxho. Kàhyawony harha naha, Khoryenkomo, katxho me rma naha. ");
INSERT INTO hixNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Beryen ho nenuruy hatà, Txesusu, Xukneya yamtar ho rma hatà. Xuknewyana komo kayaryet me nehxakon hakahpa tà, Eroknes heno. Xerusaryen hono rma mok nehxakon heno hatà, Xukneya yamtar hono rma hatà. Txesusu yonurutxhe rma, Xerusaryen hona nomohtxownà hatà, horykomo komo. Xeryko hutwanye ro mokyam nehxatxkon hatà. Kamàmà yahatakatxho nyero nomohtxownà hatà, Xerusaryen hona, moxe rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Onà wyaro nketxkon hatà, toto komo wya, Xerusaryen hon komo wya. Henta naye, enuxenyeno, ketxkon hatà. Xuknewyana komo kayaryet me enusaho rma, henta naye. Noro hutwamohsonye amna nenyako, ketxkon hatà. Amna yowto ho rma hak amna yehtoko, amna nenyako, xeryko, noro hutwamohsonye rma. Àro ke, noro yowakryexe amna nomokyako, ketxkon hatà, horykomo komo. ");
INSERT INTO hixNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Àrwon komo yokarymatxownà hatà, toto komo, Eroknesà wya, tkayaryet komo wya. Tàwya enytxatxhe rma, noseryehokekon hatà, Eroknesà. Xuknewyana komo kayaryet me enusaho katxho hoko rma noseryehoketxkon hatà, Eroknes komo, Xerusaryen hon komo rma, omeroro. ");
INSERT INTO hixNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Àro ke, eh komo yanyekye hatà, Eroknesà. Khoryenkomo màn yonye ro yoh komo yanyekye hatà. Àyweronàhyamano ynye ro komo xarha yanyekye hatà. Onà wyaro nkekon hatà, àwyanye. Àsoke nkeno, Khoryenkom karyehtanà, kekon hatà. Àsoke nkeno, Kryestu hoko. Henta ryhe nenuryano, kekon hatà, Eroknesà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Neyuhtxownà hatà, eh komo. Beryen ho ryhe nenuryan hatà, ketxkon hatà. Xukneya yamtar ho rma nenuryan hatà, Beryen ho hatà. Noro hoko rma, onà wyaro nmenhoy hatà, Khoryenkomo rwonà yokarymanye ro heno. ");
INSERT INTO hixNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Beryen hon komo y, onà wyaro àkehe hampànà, oyowto kom hoko. Xukneya yamtar ho rma nay hamà, oyowto komo. Xukneya yamtar ho rma rha naha, owto komo xarha, thenyehra. Oyowto komo ryhe, anar komo yoho rma haxa mpàn naha ha. Àsok tawro hana. Amnye oyowto kom ho nenuryaha hampànà, Ehsayewyana komo kayaryetà ymo, Khoryenkomo mryenon komo kayaryetà ymo. Àro ke, anar komo yoho rma haxa nay hamà, oyowto komo, Beryenà. Àro wyaro rma nmenhoy hatà, Khoryenkomo rwonà yokarymanye ro heno, ketxkon hatà, eh komo, Eroknesà wya. ");
INSERT INTO hixNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Àro ke, horykomo komo yanyekye hatà, Eroknesà. Xeryko hutwanye ro komo yanyekye hatà. Toto komo nenytxahtor me mak nanyehtxownà hatà. Àsokentoko ryhe xeryko menyatxoko, kekon hatà, àwyanye. Àsokentoko ryhe menyatxoko. Àro ke nekarymatxownà hatà, àwya. Amnyehra amna nenyako, xeryko, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Onà wyaro nkekon xarha tà, Eroknesà, àwyanye. Àtotxoko rma, Beryen hona, kekon hatà. Xenytxatxko ha, enuxenyeno. Owyanye xenyetxhe rma, momokyatxhe harha, rohyaka, kekon hatà. Ekarymaxe momokyatxhe ha, rowya. Uro xarha, noro yowakryexe rma rha rotonàr xe wehxaha, àhyaka, kekonà rma haryhe tà, Eroknesà, horykomo komo wya. Àro wyaro tàwya tatoko rma, nenkuhtetxkon hatà, Txesusu mryenà yotahanàr xe rma haxa tesnàr ke mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tàwyanye noro yonytxatxhe rma, totxownà xarha tà, horykomo komo. Ehokokonye tekon hatà, xeryko. Towto kom ho ànenyetxhàyamotho rma mok nehxakon hatà. Àywahonye rma tekon hatà. Kràk, horohye hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Teryehorye rma haxa nehxatxkon hatà, horykomo komo, tàwyanye xeryko yonyàr ke hatà, Txesusu mryenà hyaka tanàr komo ke hatà. Thenyehra rma haxa neryehotatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Àmàn yaka nowomtxownà hatà. Txesusu mryenà yonytxownà hatà. Àyon xarha yonytxownà hatà. Maryeya rma yonytxownà hatà. Tosoknar kom ho neryewtatxownà hatà, Txesusu yowakryenàr horà. Ehonomnà xaxa omoro ha, ketxkon hatà, àwya. Tkatxho yon komo yahurmakatxownà hatà. Ehetàhpenyeno yonkatxownà hatà, uru hatà, ensensu xarha hatà, meha xarha hatà. Nàmtxownà hatà, Txesusu mryenà wya. ");
INSERT INTO hixNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Taa. Nosenyehtxownà hatà, horykomo komo. Tosenyetnàr komo me, Khoryenkomo rwonà yonytxatxownà hatà. Àtohra mpàn ehtxoko, Eroknesà hyaka, kekon hatà, àwyanye, osenyetnàr komo me hatà. Àro ke, àhyaka harha àtohra nehxatxkon hatà. Anato harha totxownà hatà, horykomo komo, towto kom hona harha. ");
INSERT INTO hixNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Horykomo komo totxhenye, nosenyetày hatà, Xose. Osenyetnàr me nosonyhoy hatà, kahe yawono, Kohkom yanoto, àwya. Onà wyaro nkekon hatà, àwya. Àtok ha, kekon hatà. Oyokahtàmko hampànà, Exet yamtar hona. Omuru txko arko ha, kekon hatà. Àyon xarha arko ha. Eroknesà ryhe, omurunhuru txko yohoryaha, etahanàr horà, kekon hatà. Àro ke oyokahtàmko hampànà, Exet yamtar hona. Àto roro rma hak exko. Rowya, àtok harha, oyowto hona harha, kahra ro rma haka, Exet yamtar ho rma hak exko, kekon hatà, Kohkom yanoto, Xose wya, osenyetnàr me hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Àro ke nasanàmye hatà, Xose. Kohsaya rma toy hatà. Txesusu mryenà yarày hatà. Àyon xarha yarày hatà. Exet yamtar hona toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Àto roro rma hak nehxakon hatà, Eroknes heno wayehpàra ro rma haka. Àro wyaro nehxakon hatà, Txesusu mryenà, Kohkomo rwonàmàthàràtho yawo ro tehtxoho me. Amnyehra, onà wyaro nkekon hatà, Kohkomo, tanoto heno wya, tàrwon yokarymanye ro heno wya. Exet yamtar hoye romuru ànyakyaha hampànà. Àro wyaro nkekon hatà, Kohkomo rwonà yokarymanye ro heno, amnyehra. Àro wyaro katxhàrànhàr yawo ro rma, Exet yamtar ho htxero nehxakon hakahpa tà, Txesusu mryenà. ");
INSERT INTO hixNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ewakhàra rma haxa nehxakon hatà, Eroknes heno. Ronkuhtetxok hamà, horykomo komo, xeryko hutwanye ro komo, kekon hatà. Àro ke ewakhàra nehxakon hatà. Waha komo nyakye hatà, Beryen hona. Àtotxoko, bàryekomotho komo yotahaxe, kekon hatà, àwyanye. Kàrà me ehtokonye, metahetxhe ha. 2 me àtxemnyehàntahra hak ehtokonye, metahetxhe ha, kekon hatà, Eroknes heno, tanoto komo wya. Àsok tawro hana. Horykomo komo rwonàmàthàrà hutwekon hamà, noro heno. Àwyanye, amnyehra amna nenyako, xeryko, katxhàrà hutwekon hamà. Àro ke, onà wyaro nkekon hatà, waha komo wya. 2 me àtxemnyehàntahra hak ehtokonye, metahetxhe ha, kekon hatà, Eroknes heno, àwyanye. Àro ke, Beryen hona totxownà hatà, waha komo. Bàryekomo txko heno komo yotahatxownà hatà, omeroro hatà, Beryen hon heno kom hatà, àhorye ron heno komo xarha hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nyamoro heno hoko rma, yaworo rma haxa nehxakon hamà, àmenhosahonhàrà. Onà wyaro nmenhoy hatà, amnyehra, Xeryemeyas heno, Khoryenkomo rwonà yokarymanye ro heno. ");
INSERT INTO hixNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Nàratetxhe hampànà, Hamah yamtar hon komo, woràskomo komo, Hakew heno yohamàthàyamo. Thenyehra nehokoyatxhe hampànà, tàmryethàyam heno hnànà. Ehxera harha natxhe hampànà, bàryekomo txko heno komo. Àro ke nekhoketxhe hampànà, thenyehra mak ha. Ekhokahra ehtxoko tawro xehra ro mak natxhe hampànà, toto komo wya. Àro wyaro rma nmenhoy hatà, Xeryemeyas heno. Ànmenhothàrànhàrà yawo ro rma haxa nehxatxkon hamà, Beryen hon komo, Eroknes komo wya bàryekomo txko heno komo yotahanàr ke mak ha. ");
INSERT INTO hixNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Taa. Wayehye hatà, Eroknes heno. Noro heno wayhàtxhe rma, nosenyetày xarha tà, Xose. Exet yamtar ho rma hak nehxakon hatà. Nosenyetày hatà. Osenyetnàr me nosonyhoy hatà, kahe yawono, Kohkom yanoto, àwya. Onà wyaro nkekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Àtok ha, kekon hatà. Oyowto hona harha àtoko, Ehsayew yamtar hona harha. Omuru txko arko ha, kekon hatà. Àyon xarha arko ha. Omuru yotahanàr xan heno wayehyako. Àro ke àtok harha, oyowto hona harha, kekon hatà, kahe yawono, Xose wya, osenyetnàr me hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Àro ke nasanàmye hatà, Xose. Txesusu mryenà yarày hatà. Àyon xarha yarày hatà. Ehsayew yamtar hona toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tàtonàr me rma, Ehsayewyana komo kayaryetà yokaytà yonytxay hatà. Àkayaryet komo me harha nay hatà, Ahkerawu, Eroknes heno murunho, tàyàm peno hryetayo me, tawro yonytxay hatà. Xukneya yamtar ho nay hatà tawro yonytxay hatà. Àro ke noseryehye hatà, Xose, Xukneya yamtar hona tàtonàr hona. Tosenyetnàr me rma rha Kohkomo rwonà yonytxay xarha tà. Àro ke, Karyeryeya yamtar hona haxa toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nasarye hona rma toy hatà. Ewto me harha nehxakon hatà, Nasarye. Àtono ro me harha nehxakon hatà, Txesusu, Kohkomo rwonàmàthàràtho yawo ro tehtxoho me. Amnyehra, onà wyaro nkekon hatà, Kohkomo, tanoto heno komo wya, tàrwonà yokarymanye ro heno komo wya. Noro ryhe, Nasarye honotho mosonà katxho me naha hampànà. Àro wyaro nketxkon hatà, Kohkomo rwonà yokarymanye ro heno komo, amnyehra. Àro wyaro katxhàrànhàr yawo ro nehxakon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Taa. Ahehnawo nehxakon hatà, Xowaw heno, aymomno ynye ro heno. Xukneya yamtar ho rma, ahehnawo nehxakon hatà. Khoryenkomo rwonà yokarymekon hatà, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Atxke manatxhe, kekon hatà, àwyanye. Kàkayaryet komo me Khoryenkomo nànyaketxho ryhe, omohsah me naha. Àro ke, anar me harha ayanhànàthàyamo xenytxoko, kekon hatà, Xowaw heno, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Noro hoko rma nmenhoy hatà, Esaeyas heno, Khoryenkom rwonà yokarymanye ro heno. Amnyehra, onà wyaro nkekon heno hatà. Onà wyaro nkehe hampànà, ahehnawono, teryewrye ro. Kohkomo ryhe nomokyan hatà, àro ke osonyhoryetxoko, kehe hampànà, toto komo wya. Tkayaryet komo yomoknàtoko, esamar komo yonyhoryetxow hamà, àmryenon komo. Àro wyaro rma rha, oyowan komo enyhoryetxoko, owyanye Kohkomo rwonà yonytxatxho me, kehe hampànà, ahehnawono. Àro wyaro rma nkekon hatà, Esaeyas heno, amnyehra. Xowaw hoko àro wyaro nkekon heno hamà. ");
INSERT INTO hixNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Àsok hana nehxakon ha, Xowaw heno ha. Onà wyaro nehxakon hatà. Okno hpotxetho yawo nehxakon hatà, kameru hpotxetho yaw hatà, enyhoryehnà rma yaw hatà. Okno hutxhotho ke tasok nehxakon xarha tà. Età ryhe, kratxatxa me nehxakon hatà. Ànyahrà xarha, weno me nehxakon hatà. Àro wyaro nehxakon hatà, Xowaw heno. ");
INSERT INTO hixNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Àhyaka tetxkon hatà, toto komo, omeroro hatà, Xerusaryen hon kom hatà, Xukneya yamtar hon komo xarha hatà, Xoknaw yohoyen horye ron komo xarha hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nataymompetxkon hatà, àwya, tuna kwaka. Xoknaw kwaka ryhe nataymomyatxkon hatà. Tataymomnàtokonye rma, noskarymetxkon hatà. Tanhànàthàyamo yokarymetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Àhyaka totxownà xarha tà, Farysew kukuru komo, Saknusew kukuru komo xarha. Ataymomposo totxownà hatà, àwya. Tàwya xenyetxhenye rma, onà wyaro nkekon hatà, Xowawu, àwyanye. Okoye wyaro atxke manatxhe, kekon hatà. Ayataymomrà komo xe rma manatxhe haryhe, oyoseryehrà komo ke mak ha. Ewakhàra Khoryenkom yehtxoho hona moseryehyatxow hamà, kekon hatà. Amnye kanàhnohyatxhe hampànà, Khoryenkomo, katxho hona rma moseryehyatxow hamà, kekon hatà. Àro wyaro rma rha weheto krunke nekahtàmyaha, okoye, kekon hatà, Xowawu, Farysew komo wya, Saknusew komo wya xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Anar me harha ranhànàtho wenyaha, màketxhe rma haryhe, kekon xarha tà, àwyanye. Àhnànkahra mak manatxhe ha. Anar me harha ranhànàtho wenyaha kany me oyehtokonye, ayanhàn komo àhnànkatxoko, ohxe harha oyosonyhotho menye, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Onà wyaro rma màketxhe haryhe, kekon xarha tà, àwyanye. Ohxe rma haxa tehxatxhe, Akmaraw heno yohamàtho kaxe, màketxhe rma haryhe. Àro wyaro kahra ehtxoko, kekon hatà. Onà wyaro haxa ryhe àkehe, owyanye. Akmaraw heno yohamàtho me marma oyehtxoho komo ryhe, ohxehra ro mak naha, Khoryenkomo wya, kekon hatà. Àsok tawro hana. Akmaraw heno yohamrà me marma toto yesnàr xehra nay hamà, Khoryenkomo. Noro heno yohamrà me marma toto yesnàr xe tehtok haxa, tohu txkotho yakàhtonàràtho haryhe, àwya, Akmaraw heno yohamrà me harha. Ehnyahnà ro kax mak naha ha, noro ha, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Àsok hana nay ha, natàtho ha, kekon xarha tà, àwyanye. Ehetahra ehtoko, tamaxem me nay hamà. Àmxathàr me ro rma tawotosom me nay hamà. Amaxahotho rma, weheto waka tarymaxem me xarha nay hamà, kekon hatà. Àro wyaro rma rha tanàhnohsom me rma manatxhe hampànà. Ayanhàn komo hnànkahra oyehtokonye, mexehra rma haxa ayanàhnohtàketxhe hampànà, Khoryenkomo, kekon hatà, Xowawu, Farysew komo wya, Saknusew komo wya xarha, ");
INSERT INTO hixNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tuna kwaka ryhe kaymomyatxhe, uro ha, kekon xarha tà, toto komo wya. Àro wyaro kaymomyatxhe, anar me harha ayanhànàthàyamo yony me ohutwamohsonàr kom horà, kekon hatà. Nomokyaha, anaro, rohryetayo. Rohono rma haxa noro ha. Noro yanoto mehra tehxorye wehxaha, esnaka rma haxa ryesnàr ke. Àhrorà womunu yarhàra rma tehxorye wehxaha, kekon hatà. Noro ryhe, anar me ayaymomyatxhe ha. Khoryenkom yokato nyakyaha, ohonanye. Ayaymomtoho komo rma àro ha, noro wya, kekon hatà. Ayaymomyatxhe xarha. Weheto waka txexaho wyaro ayaymomyatxhe, oyonyhoryenàr kom horà, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Àsok hana natxow ha, nasànasà hotnye ro kom ha, kekon xarha tà, àwyanye. Uhpunkatxho yaryatxow hamà. Nasànasà hpunketxow hamà, kekon hatà. Nasànasà ryhe, enyhoru rma yohamnohyatxow hamà, nyah màn yaka. Uhpunuthuru haxa ryhe yaknyohyatxow hamà, weheto waka, kekon hatà. Àro wyaro rma rha wahanonkano yeryaha hampànà, noro ha, tomohsomà. Mexehra rma haxa wahanonkano yxe nomokyaha. Enyhoru komo yohamnohyaha hampànà, bàn yaka. Anhàtho kom haxa ryhe yanàhnohyaha hampànà, meya roro, kekon hatà, Xowawu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Taa. Nomokye hatà, Txesusu. Karyeryeya yamtar hoye nomokye hatà. Xoknaw yohokoso nomokye hatà, Xowawu hyaka. Ataymomposo nomokye hatà, àwya. Uro aymomko, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Àna matà, kekon hatà, Xowawu, àwya. Ayaymomnyehnà uro. Omoro haxa ryhe, raymomnye me manay hamà, kekon hatà. Àsok tawro ayaymomrà xe manaye, rowya, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Onà wyaro haxa neyukye hatà, Txesusu. Uro aymomko rma, kekon hatà. Khoryenkom hak weyuhtukaxe, ohxe roro rma haxa rosonyhotho me. Àro ke, uro aymomko, kekon hatà, Txesusu. Àna hamà, kekon hatà, Xowawu. Àro ke naymomye hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tataymomàtxhe rma, nasanàmye hatà, Txesusu, tuna kwaye. Àtoko rma natahurmakay hatà, kahe. Khoryenkom yokato ryhe nàhtoy hatà. Watkuk me nehxakon hatà, ànenyàr me. Txesus hona nàhtoy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Àrwo yonytxatxownà hatà. Kahe yawono ryhe nàrwonàmye hatà. Romuru mosonà, kekon hatà. Ronàhnàn xaxa mosonà. Àhoko rma teryehorye rma haxa wehxaha, kekon hatà, kahe yawono. ");
INSERT INTO hixNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Taa. Txesusu yarày hatà, Khoryenkom yokato, ahehnaka. Narày hatà, worokyamo yohà ymo wya ukukmatxho me. ");
INSERT INTO hixNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ahehnawo tehtoko, ànyahpàra ro mak nehxakon hatà, Txesusu. Ànyahpàra rma, 40 me nenmahye hatà. 40 me tonmahàtxhe, nahyehtàkaye rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Àro ke nomokye hatà, worokyamo yohà ymo, àhyaka. Onà wyaro nkekon hatà, àwya. Khoryenkom muru me oyehtoko, owru akàhtoko, kekon hatà. Onà wyaro rma kasko, tohu wya, onà wya. Ekeyu me harha exko, kasko, tohu wya, kekon hatà, worokyamo yohà ymo, kukmano ynye ro ymo. ");
INSERT INTO hixNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Àna matà, kekon mak hatà, Txesusu, àwya. Onà wyaro haxa nkehe, Khoryenkom karyehtanà, àmenhosahonhàrà rma. Nyah marma hoye rohra karyhe tehxatxhe. Khoryenkomo rwon hoye ro haxa ryhe karyhe tehxatxhe. Àro wyaro rma nkehe, àmenhosahonhàrà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Taa. Narày hatà, worokyamo yohà ymo, Xerusaryen hona, owto hona, enyhoru ro hona. Khoryenkom mànà ryetàr hona neryey hatà, kakoso rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Khoryenkom muru me oyehtoko, atahrumko, oyoro ro, kekon hatà. Kahe yawon komo nyakyan hatà, Khoryenkomo, àwyanye okurunhotho me hatà. Àro wyaro rma nkehe, àmenhosahonhàrà, kekon hatà. Okurunhetxow hatà, kahe yawon komo, toh hona oyehrotkahanàr hona. Àro ke atahrumko, kekon hatà, worokyamo yohà ymo. ");
INSERT INTO hixNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Àna matà, kekon mak hatà, Txesusu. Onà wyaro haxa nkehe, Khoryenkomo karyehtanà, àmenhosahonhàrà rma. Oyohkom me naha, Khoryenkomo. Noro hak ukukmaxe kahra ehtxoko. Àro wyaro rma nkehe, àmenhosahonhàrà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Taa. Àhà ymo hona haxa narày hatà, worokyamo yohà ymo. Àsok hana nenyhoy ha, Txesusu wya. Toto komo, ehonomnà komo xarha, àmryenon komo xarha, ewto komo xarha, uyukryekan komo xarha, omeroro rma nenyhotàhkay hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Onà wyaro nkekon hatà. Onenyetxhàrà rma wàmyaha, owya, eh komo me oyehtxoho me, kekonà rma haryhe tà, Txesusu wya. Ehurkako, rakrataka. Ehonomnà me xaxa manaha, kasko, rowya. Àro wyaro owya katxhe rma, omeroro wàmyaha, owya, kekonà rma haryhe tà, worokyamo yohà ymo, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Onà wyaro haxa nkekon hatà, Txesusu, àwya. Àtok ha, rohyaye, Satanasà ymo, kekon hatà. Àtok ha, rohyaye. Àsok tawro hana. Onà wyaro nken hamà, Khoryenkom karyehtanà, àmenhosahonhàrà rma. Oyohkom me naha, Khoryenkomo. Noro wya ryhe, ehonomnà me xaxa manaha, katxok xaxa mak hampànà, noro wya marma mak ha. Àro wyaro rma nkehe, àmenhosahonhàrà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Àro wyaro àwya katxhe rma, toy hatà, worokyamo yohà ymo, Txesusu hyaye. Noro yakoronomaxe nomohtxownà hatà, kahe yawon komo, Khoryenkom yanoto komo. ");
INSERT INTO hixNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Taa. Xowaw heno yokaytà yonytxay hatà, Txesusu. Watxa ymo yaka ahryemxaho nay hatà tawro yonytxay hatà. Àro ke toy hatà, Karyeryeya yamtar hona. ");
INSERT INTO hixNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasarye hona htxero toy hatà. Àsnye ro toy xarha tà. Kafahnaw hona haxa toy hatà. Karyeryeya kuthonà ymo yohoyeno rma àro ha, owto, Kafahnawu. Sekmurun yamtarà màhtono rma àro ha, Naftarye yamtarà màhton xarha. Àtono ro me harha nehxakon hatà, Txesusu, ");
INSERT INTO hixNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","àmenhosahonhàr yawo ro tehtxoho me. Amnyehra, onà wyaro nmenhoy hatà, Esaeyas heno, Khoryenkomo rwonà yokarymanye ro heno. ");
INSERT INTO hixNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Àsok hana natxow ha, Sekmurun hon kom ha, Naftarye hon komo xarha. Àsok hana natxow ha, Karyeryeya hon kom ha. Tuna ymo yawo ro natxow hamà. Xoknaw yohoy xarha natxow hamà. Mon ho natxow hamà. Àwawonye rma natxhe xarha, Xuknewyanahnà komo. Àsok hana natxow ha. ");
INSERT INTO hixNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Awaràn wawon komo wyaro ohxehra natxow hamà. Twayehsom komo wyaro xarha, ohxehra rma rha natxow hamà. Onà wyaro haxa ryhe natxhe hampànà. Awasàn hon komo wyaro haxa ryhe natxhe hampànà. Khoryenkomo hutwamohsonye ymo yonyatxhe hampànà. Noro rma yonytxetxhe hampànà. Àro ke, awasàn hon komo wyaro haxa natxhe hampànà, nyamoro ha. Àro wyaro rma nmenhoy hatà, Esaeyas heno. Ànmenhothàrànhàr yawo ro harha nehxatxkon hamà, Karyeryeya hon komo, tàhyawonye Txesusu yesnàr ke mak ha. ");
INSERT INTO hixNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Àsna tàtotxhe rma, Khoryenkomo rwonà yokarymekon haxa hatà, Txesusu, toto komo wya. Atxke manatxhe, kekon hatà, àwyanye. Akayaryet kom me Khoryenkomo nànyaketxho ryhe, omohsah me naha. Àro ke, anar me harha ayanhànàthàyamo xenytxoko, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Taa. Karyeryeya kuthonà yohokoko tekon hatà, Txesusu. Semaw yonyey hatà. Petru rma noro ha, esot yowtà. Antrye xarha yonyey hatà. Semaw yowtà rma noro ha. Txaruka yarymetxkon hatà, tuna kwaka. Kana yaramnye ro komo kax mak nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Omohtxoko, rakoro, kekon hatà, Txesusu, àwyanye. Omohtxoko, rakoro. Kana yaramnye ro omnyam hamà. Rakoro oyomokàtxhenye, toto komo yoknye me harha mpànà keryatxhe ha, rohyaka, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Àsoke rma tàtxarukanàthàyamo nomtxownà hatà. Txesus yakoro harha totxownà hatà, Semaw komo. ");
INSERT INTO hixNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Meya nyhe toy hatà, Txesusu. Txaku yonyey hatà. Sekmeknew muru rma noro ha. Xowaw xarha yonyey hatà. Txaku yowtà rma noro ha. Kanawa yawo nehxatxkon hatà, tàyàm kom yakoro, Sekmeknew yakoro. Tàtxarukanàthàyamo yonyemyatxkon hatà. Omohtxoko rakoro, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Àsoke rma tkanawathàyamo nomtxownà hatà. Tàyàmànhàyamo xarha nomtxownà hatà. Txesus yakoro harha totxownà hatà, Txaku komo. ");
INSERT INTO hixNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Taa. Karyeryeya yamtar horye tekon hatà, Txesusu, anaro rha owto horye hatà. Anaro rha ohsamnohno ytxoho ro yaka tekon hatà. Hananàhno ryakon hatà. Àrwo yonyhorunu yokarymekon hatà. Àsok hana kàkayaryet komo me nay ha, Khoryenkom ha. Àro rma yokarymekon hatà, toto komo wya. Teheryankemàtho komo yonyhoryekon xarha tà, omeroro hatà. Enyhoruhnutho komo rma yonyhoryekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Àro ke nekaytekon hatà, thenyehra hatà. Serya yamtar horye rma nekaytekon hatà. Àro ke, àhyaka okno ryatxkon hatà, àton komo. Àsokenotho kom hana yokyatxkon ha, ekehàtho komo rma hatà, teheryankemàtho komo rma hatà, anaro rha eherya yawonotho komo rma hatà, worokyamo yohàtho komo xarha hatà, tàrohsomàtho komo xarha hatà, amusnaxemotho komo xarha hatà. Omeroro rma nekyatxkon hatà, Txesusu hyaka. Nenyhoryetxkon hatà, omeroro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Noro yakoro tetxkon hatà, toto komo, thenyenohnà kom hatà, Karyeryeya yamtar hon kom hatà, Dekaporyes hon komo xarha hatà, Xukneya yamtar hon komo xarha hatà, Xoknaw mon hon komo xarha hatà. Txesus yakoro tetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Takoron komo yonyey hatà, Txesusu. Thenyehra natxow hamà, toto komo, kekon hatà, tàwya rma. Àro ke toy hatà. Àhà ymo yawnukye hatà. Neryewtay hatà. Àhyaka nomohtxownà hatà, ànhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Àro ke, hananàhyatxkon hatà, Txesusu. Onà wyaro nkekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Onà wyaro kany me ehtxoko, kekon hatà. Atxke wehxan hamà, Khoryenkomo wya, kany me ehtxoko. Àro wyaro kany me oyehtokonye, towakryexe rma manatxhe ha, amnye Khoryenkom yowto hon me oyesnàr komo ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ekhokatxoko, ayanhànàthàyam hoko. Oyekhokantokonye, towakryexe rma manatxhe, amnye teryehotanàhsom me harha oyesnàr komo ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Norohnàtho me osonytxoko. Norohnàtho me oyosonyetokonye, towakryexe rma manatxhe, amnye Khoryenkomo wya ehonomnà me harha oynyàr komo ke mak ha. Yukryeka yoh me harha oyeryatxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ohxe roro oyesnàr komo xe rma haxa ehtxoko. Ohxe roro oyesnàr komo xe oyehtokonye, towakryexe rma manatxhe, amnye Khoryenkomo wya ohxe roro rma haxa oynyàr komo ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Toto komo hnàn yawo rma haxa ehtxoko. Àhnàn kom yawo oyehtokonye, towakryexe rma manatxhe, amnye ohnàn kom yawo rma rha Khoryenkom yesnàr ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Anhà hokonohnà ro me ehtxoko, ohnawonye. Anhà hokonohnà ro me oyehtokonye, towakryexe rma manatxhe, amnye owyanye Khoryenkom yonyàr ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Toto komo akoronomatxoko, osoyhera harha ehtxoho menye, othoko towanhke harha ehtxoho menye. Àro wyaro owyanye akoronomantokonye, towakryexe rma manatxhe, amnye Khoryenkomo wya, rohokru mosonà katxho me oyesnàr komo ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Teryewhamnohsom me manatxow hana, Khoryenkom yoyuknye me oyesnàr komo ke mak ha, ohxe oyesnàr komo ke mak ha. Àro wyaro teryewhamnohsom me oyehtokonye, towakryexe rma manatxhe, amnye Khoryenkom yowto hon me oyesnàr komo ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Owàràhyaketxow hana, toto komo. Oyeryewhamnohyatxow hana. Atxke manatxhe, ketxow hana, ohokonye, yaworohra mak ha, kekon hatà. Thenyehra owàràhyaketxow hana, romryenon me oyesnàr komo ke mak ha. Àro wyaro rma ohxehra oyehtokonye, towakryexe rma manatxhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Àro ke, teryehorye rma ehtxoko. Ekhokahra mak ehtxoko. Amnye kahe yaw harha oyehtokonye, towakryexem me rma haxa manatxhe. Àsok tawro hana. Amnyehra teryewhamnohsom me rma rha nehxatxkonà, Khoryenkomo rwonà yokarymanye ro heno komo xarha. Oyonurhura ronye rma haka, toto komo neryewhamnohrà me rma haxa nehxatxkonà, nyamoro heno, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Onà wyaro nkekon xarha tà, àwyanye. Xura wyaro manatxhe, omnyamo, kekon hatà. Ohxe rma woto yeryan hamà, xura. Àro wyaro rma rha, ohxe toto komo meryatxhe ha, omnyamo, kekon hatà. Àsok haxa hana nay ha, xuratho ha. Tanhàntatxhe rma, ohxehra ro mak nay hamà. Xura me harha txeryhen me nay hamà, kekon hatà. Tarymaxem me nay hamà. Takmehxem me nay hamà. Àro wyaro rma rha, atxke harha oyesnàr kom hona mpànà xenytxoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Weyu ymo wyaro xarha manatxhe, kekon xarha tà, àwyanye. Ohxe tonyxem me nay hamà, weyu ymo. Toto komo yawasmen hamà. Àro wyaro rma rha, ohxe tonyxem me mpànà ehtxoko, toto komo wya Khoryenkom hutwanàr horà, kekon hatà. Àhà ymo ho owto yehtoko, ohxe tonyxem me nay hamà, omeroron komo wya. Àro wyaro rma rha ohxe tonyxem me mpànà ehtxoko, toto komo wya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kàwyanye kweyuru komo hotuhtotxhe rma, etahurhura tehxatxow hamà. Oryen yosnaka txeryhera tehxatxow hamà. Ahon hona haxa teryatxow hamà, kekon hatà. Àro ho tehtoko, kweyhetxow hamà. Bàn yawon komo rma weyhetxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Àro wyaro rma rha, ohxe tonyxem me mpànà ehtxoko, toto komo wya, ohxe rma haxa natxow hamà, moxamo, tawro horà. Tàwyanye ohxe oyehtxoho komo yonyetoko rma, onà wyaro xarha nketxow hamà, Khoryenkom hoko, oyàmkom hoko, kahe yawon hoko. Ohxe xaxa nay hamà, Khoryenkomo, ohxe rma rha thokyamo yesnàr ke, ketxow hamà, toto komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Àsok hana màketxow ha, rohoko, kekon xarha tà, Txesusu. Onà wyaro màketxow hana. Moyses heno nmenhotho yawo rohra harha tehxatxow hamà, moson yomoknàr ke, Txesus yomoknàr ke, màketxow hana. Khoryenkomo rwonà yokarymanye ro heno komo nmenhotho yawo rohra harha tehxatxow hamà, mosonà khananàhnye komo yomoknàr ke, màketxow hana. Àro wyaro ehutwahra ehtxoko, rohoko, kekon hatà. Àro yawo rohra harha ehtxoko kaxehra komokye. Onà wyaro ehtxok hampànà, àro yawo ro rma haxa oyehtxoho menye, kax haxa ryhe komokye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Onà wyaro yaworo xaxa àkehe, owyanye, kekon xarha tà. Nyamoro heno nmenhotho ryhe, toyuhsom me roro rma haxa mpànà naha ha. Kahe yosomtatkahra ro rma haka, yukryeka xarha yosomtatkahra ro rma haka, toyuhsom me roro mpànà naha ha, omeroro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Àro ke, onà wyaro kahra ehtxoko, Moyses heno nmenhotho hoko, àhoyenotho txko hoko. Àrotho txko yawo rohra harha wehxan hamà, kahra ehtxoko, kekon hatà. Eyukhura harha tehtxe, kahra ehtxoko, toto komo wya. Àro wyaro owyanye tatok haxa ryhe, norohnàtho me manatxhe hampànà. Khoryenkom yowto ho oyehtokonye, norohnàtho me rma manatxhe hampànà, Moyses heno nmenhotho yoyukhura oyesnàr komo ke mak ha, kekon hatà. Eyuhtukany me oyehtokony haxa ryhe, omeroro teyuhtukatxe kany me oyehtokonye rma, ehonomnà me mpànà manatxhe ha. Khoryenkom yowto ho oyehtokonye, ehonomnà me rma haxa mpànà manatxhe ha, owyanye Moyses heno nmenhotho yoyuhtukanàr ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Onà wyaro àkehe xarha, owyanye. Ohxe roro wehxaha, ketxhe rma haryhe, àyweronàhyamano ynye ro komo, Farysew komo xarha. Nyamoro yoho rma haxa ohxe ehtxoko. Nyamoro wyaro marma oyehtokonye, Khoryenkomo yowto hona àtohra ro mak manatxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Moyses heno nmenhotho yonytxanyenhàr me manatxow hamà. Onà wyaro nkekon heno hatà, amnyehran heno komo wya. Toto yotahahra ehtxoko, kekon heno hatà, àwyanye. Owyanye toto yotahatxhe rma, tanàhnohsom me manatxhe hampànà, kekon heno hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Onà wyaro haxa àkehe, owyanye. Toto yotahahra manatxow hana. Ewakhàra marma manatxow hana, toto hoko. Noro hoko ewakhàra oyehtokonye, tanàhnohsom me rma rha manatxhe hampànà, kekon hatà. Anatoko, atxke manaha, tàywenyeke manaha, màketxow hana, toto wya. Àro wyaro owyanye tatoko rma, tasom me manatxhe hampànà, owto yoh komo hyaka, àwyanye ayanàhnohrà kom horà, kekon hatà. Anatoko, akàhpànà ymo xak omoro màketxow hana, toto wya. Àro wyaro owyanye tatoko rma, eryewhamnohno ytxoho ro na tàtosom me manatxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Toto xehra oyehtokonye, onà wyaro ehtxok hampànà. Owyanye Khoryenkomo yowakryehra ro rma haka, noro xe harha ehtxoko, kekon hatà. Khoryenkom màn yawo manatxow hana. Onekàthàyamo màmyatxow hana, Khoryenkomo wya. Owyanye tàmnàtoko rma, toto muhutwetxow hana, kekon hatà. Noro hoko atxke wehxak hamà, màketxow hana. Àro wyaro rma oyehtokonye, tàmpàra hak ehtxoko, Khoryenkomo wya. Tàmpàra ro rma haka màtetxhe ha, toto hyaka, kekon hatà. Towahke harha exko, rohoko, màketxhe ha, àwya. Osox harha oyehtokonye, Khoryenkom màn yaka harha màtetxhe, Khoryenkomo yowakryexe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Àsok hana manatxow ha, kekon xarha tà. Txenyeru yehetàhkanye wyaro manatxow hamà, Khoryenkomo wya. Àsok hana nay ha, toto ha. Anaro wya txenyeru yehetàhken hamà, noro ha. Noro hoko ewakhàra harha nay hamà, ehemahra esnàr ke mak ha, kekon hatà. Owto yohà hyaka karyan hamà, ehemahra oyesnàr ke, ken hamà, àwya. Asama yarye tàtontokonye rma, tehemahorye nay hamà, ehetàhkatxhàràtho wya, owto yohà hyaka àwya tanàr hona, kekon hatà. Ehemahra rma ehtoko, watxa ymo yaka noro yahryempen hamà, owto yohà, tanoto wya, ahosno ynye ro wya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Onà wyaro yaworo xaxa àkehe, owyanye. Ehematxehkahra rma tehtoko, watxa ymo yawo roro nay hamà. Ahatakahra ro mak naha ha. Àro wyaro rma rha, anar me harha ayanhànàthàyamo yonyhera oyehtokonye, tanàhnohsom me mpànà manatxhe ha, omnyam xarha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Moyses heno nmenhotho yonytxanyenhàr me manatxow hamà, kekon xarha tà, Txesusu. Onà wyaro xarha nkekon hatà, noro heno. Anar komo hetx hokohra ehtxoko, kekon heno hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Onà wyaro haxa àkehe, owyanye. Wos hokohra rma manatxow hana. Tehohkaxem me marma manatxow hana, wos hoko. Noro rma menyatxow hana, àhoko oyehohkanàr kom horà, kekon hatà. Àro wyaro wos hoko oyehohkantokonye rma, atxke manatxhe. Wos hokon komo wyaro atxke rma rha manatxhe, ohnawonye àhoko oyehohkanàr komo ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Àsok hana mehohketxow ha, ayanhàn kom hoko. Mehohketxow hamà, oyonur komo ke mak ha, kekon hatà. Onà wyaro haxa katxoko. Enhura hak wehxe, ranhàn hoko ehohkahra harha ryehtxoho me, katxoko, kekon hatà. Tarymaxem me manatxhe hampànà, yuhnayen hona, eryewhamnohno ytxoho ro na, tonke oyesnàr kom ke mak ha, oyonur kom ke rma atxke oyesnàr kom ke mak ha. Enhura haxa oyehtokonye, ohxe rma manatxhe. Arymahnà me rma manatxhe, yuhnayen hona, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Anatoko ayanhàn kom hoko manatxow hana, ayamor komo ke mak ha, kekon xarha tà. Onà wyaro haxa katxoko. Amohra hak wehxe, ranhàn hokohra harha ryehtxoho me, katxoko, kekon hatà. Tarymaxem me manatxhe hampànà, yuhnayen hona, eryewhamnohno ytxoho ro na, tamok oyesnàr kom ke mak ha, ayamor kom ke rma atxke oyesnàr kom ke nak ha. Amohra haxa oyehtokonye, ohxe rma manatxhe. Arymahnà me rma manatxhe, yuhnayen hona, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Onà wyaro xarha nkekon hatà, Moyses heno, kekon xarha tà, Txesusu. Ohetxenhàyamo hyaye oyotownàtokonye, akaryehtan komo àmenhotxoko, kekon heno hatà. Kotowyaha hampànà, ohyaye, katxho me hak nahko, onmenhothàyamo, kekon hatà, Moyses heno, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Onà wyaro haxa àkehe, owyanye. Ohetxe hyaye otowhàra ro mak ehtxoko. Tàhyaye oyotowàtxhenye, atxke naha, wosà, kekon hatà. Anaro kàrà hetx me harha tehtoko, atxke rma haxa naha, anaro hoko tesnàr ke. Anatoko, anaro kàrà hoko nay hana, ohetxe. Anaro hoko ehxaho hyaye rma oyotownàtokonye, ohxe rma manatxhe, kekon hatà. Tànyonhàrà hyaye wos yotowàtxhe, ohetx kom me noro yahohsàra ro mak ehtxoko. Owyanye ahosnàtoko rma, atxke manatxhe, anaro hetx me noro yesnàr ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Moyses heno nmenhotho yonytxanyenhàr me manatxow hamà, kekon xarha tà, Txesusu. Onà wyaro xarha nkekon heno hatà, amnyehran heno komo wya. Onà wyaro kany me manatxow hamà, orwonàmàthàyam yawo ro oyehutwamohsonàr kom horà, kekon heno hatà. Rorwonàmàthàrà yawo ro xaxa mpànà wehxaha ha, àro yawo rohra haxa ryehtoko, romtatkano rma haka, Kohkomo, kany me manatxow hamà, kekon heno hatà, àwyanye. Àro wyaro owyanye tatoko rma, orwonàmàthàyamo yawo ro rma haxa ehtxok hampànà, Kohkomo nenyàr me, kekon heno hatà, àwyanye. Yaworohra àro wyaro kahra ro mak ehtxok hampànà, kekon hatà, Moyses heno, amnyehran heno komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Onà wyaro haxa àkehe, owyanye. Romtatkano rma haka, Kohkomo, kahra ro mak ehtxoko. Romtatkano rma haka, Kohkomo, kanyehnà rma, orwonàmàthàyam yawo ro ehtxoko, kekon hatà. Àsok haxa hana nketxow ha, toto kom ha. Anatoko onà wyaro nketxow hamà. Rorwonàmàthàrà yawo rohra ryehtoko, nosomtatkano rma haka, kahe, ketxow hamà. Àro wyaro kahra ro mak ehtxoko, kahe hoko, Khoryenkom yowto me esnàr ke. Àro wyaro kanyehnà rma, orwonàmàthàyam yawo ro ehtxoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Anatoko onà wyaro nketxow hamà, toto komo. Rorwonàmàthàr yawo rohra ryehtoko, nosomtatkano rma haka, yukryeka, ketxow hamà. Àro wyaro kahra rma rha ehtxoko, yukryeka hoko xarha, Khoryenkom yahon me esnàr ke. Àro wyaro kanyehnà rma, orwonàmàthàyam yawo ro ehtxoko, kekon hatà. Anatoko onà wyaro nketxow hamà. Rorwonàmàthàr yawo rohra ryehtoko, nosomtatkano rma haka, Xerusaryenà, ketxow hamà. Àro wyaro kahra rma rha ehtxoko, Xerusaryen hoko xarha, akayaryet komo ymo yowto me esnàr ke, Khoryenkomo nànyaketxho yowto me esnàr ke. Àro wyaro kanyehnà rma, orwonàmàthàyam yawo ro ehtxoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Anatoko onà wyaro nketxow hamà. Rorwonàmàthàr yawo rohra ryehtoko, anar me harha hak nahko, rohpotxetho, ketxow hamà. Àro wyaro kahra rma rha ehtxoko. Àsok tawro hana, ohpotx komo yoh me Khoryenkom yesnàr ke. Buknye harha txeryhera manatxow hamà, omnyamo. Buknye ehtoko, thurme harha txeryhera manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Àro ke, toto kom yakoro orwonàmnàtokonye, yaworo rye rma haxa orwonàmtxoko. Kohkom hak romtatkano kanyehnà rma, anaro rha hoko nosomtatkan haka kanyehnà rma, yaworo rma orwonàmtxoko, kekon hatà. Àro wyaro kanyehnà rma, orwonàmàthàyam yawo ro ehtxoko. Àro wyaro kany komo rma, atxke tehtxoho kom hoye ro àro wyaro nketxhe, tàtemaronyem me tehtxoho hoye ro mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Moyses heno nmenhotho yonytxanyenhàr me manatxow hamà, kekon xarha tà, Txesusu. Onà wyaro xarha nkekon heno hatà. Onà wyaro ehenàhno txetxoko, kekon heno hatà. Toto wya anaro yonutho yowàtxhe, noro yonutho xarha towtxoko, kekon heno hatà. Toto wya anaro yotho yowàtxhe, noro yotho xarha towtxoko. Àro wyaro rma ehenàhno txetxoko, kekon hatà, Moyses heno, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Onà wyaro haxa àkehe, owyanye. Ohsànàhpàra ro mak ehtxoko, axanhàn kom hoko, anhà kom hoko rma, kekon hatà. Anatoko dow ketxow hana, oyompatar kom hoko. Ohsànàhpàra rma ehtxoko. Onà wyaro haxa katxoko, àwyanye. Àrakayo me kasko xarha, katxoko, àwyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Anatoko ayaryatxow hana, owto yoh komo hyaka, owomunuthuyamo yowrà horà, twomun kom me harha towrà horà. Ohsànàhpàra rma ehtxoko. Onà wyaro haxa katxoko, axanhàn komo wya. Anarotho xarha towko, katxoko, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Anatoko ayanotometxow hana, waha komo. Rokatxho arko ha, ketxow hana. 1 kerometru me àmoxenonà arko ha, ketxow hana. Àro wyaro àwyanye tatoko rma, ohsànàhpàra rma ehtxoko. Onà wyaro haxa katxoko, àwyanye. Moxe nyhe waryaha, 2 kerometrus me àmoxenonà, katxoko, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Uro nyhe txko rokatxho ha kanye ro komo eyuhtxoko, kekon xarha tà. Nyamoro rma ewakryetxoko. Anatoko akatxho komo yanàr xe nay hana, toto. Noro wya rma, arhàra exko kahra ro mak ehtxoko. Arhotxoko rma, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Moyses heno nmenhotho yonytxanyenhàr me manatxow hamà, kekon xarha tà, Txesusu. Onà wyaro xarha nkekon heno hatà. Ohoyen komo xe xaxa ehtxoko, kekon heno hatà. Axanhàn komo xehra ehtxoko, kekon xarha tà, Moyses heno, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Onà wyaro haxa àkehe, owyanye. Axanhàn komo xe ehtxoko. Oyeryewhamnohnye kom hoko orwonàmtxoko, Khoryenkom yakoro, àwya ewakryenàr kom horà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Àro wyaro rma ohxe ehtxoko, oyàmkomo wyaro rma rha ohxe oyehtxoho menye, kahe yawono wyaro ohxe oyehtxoho menye. Àsok hana nay ha, noro ha, oyàmkomo, kekon hatà. Omeroron komo yowakryeny me nay hamà. Kamàmà yonampatakehe, toto komo yowakryenàr horà, enyhoru komo rma yowakryenàr horà, anhà komo xarha yowakryenàr horà, kekon hatà. Àro wyaro rma rha tuna heno nyakyaha, ohxe ehxemo komo yowakryenàr horà, atxke ehxemo komo xarha yowakryenàr horà. Noro wyaro rma rha ohxe ehtxoko, omeroron kom hoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Axan komo xe marma oyehtokonye, ohxe manatxhe kahra rma wehxaha, owyanye, kekon xarha tà. Àsok tawro hana. Atxke natxhe moxamo katxho komo xarha, tàxan komo xe natxow hamà. Nyamoro yoho rma haxa ohxe oyesnàr komo xe wehxaha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Okukur kom hok marma towahke oyehtokonye, anar komo wyaro manatxow hamà. Xuknewyanahnà komo xarha, towahke natxow hamà, tkukur kom hoko. Nyamoro yoho rma haxa ohxe oyesnàr komo xe wehxaha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Àro ke, onà wyaro àkehe. Omnyamo ryhe, ohxe roro rma haxa ehtxoko, anar komo yoho rma haxa mak ha. Ohxe roro rma haxa nay hamà, oyàmkomo, kahe yawono. Noro wyaro rma rha ohxe roro ehtxoko, omnyam xarha, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Onà wyaro nkekon xarha tà, Txesusu, tànhananàhrà ro komo wya. Àsok hana natxow ha, anar kom ha, kekon hatà. Onà wyaro natxow hamà. Khoryenkom hoko rma natxhe haryhe, toto komo wya ohxe tosonyhotho meny mak ha, kekon hatà. Nyamoro wyarohra ehtxok hampànà. Àwyaronye oyehtokonye rma, ohxe manatxhe kahra ro mak naha, owyanye, oyàmkomo, kahe yawono, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Àro wyaro rma rha tkatxho kom hoye rma nàmyatxhe haryhe, anar komo, ewakryehnà rotho komo wya. Yaworohra mak natxhe, tàhnawonye, kekon hatà. Toto komo wya ohxe manatxhe tawro xe rma natxhe haryhe. Àro ke nàmyatxhe rma haryhe, ohsamnohno ytxoho ro yawo tehtokonye, owto ho xarha tehtokonye, yakentawo rma tehtokonye, kekon hatà. Onà wyaro yaworo xaxa àkehe, owyanye. Nyamoro hoko rma, ohxe natxhe ketxow hamà, toto komo. Ohxe manatxhe kahra mak naha, Khoryenkomo, àwyanye, kekon hatà. Nyamoro wyarohra ehtxok hampànà. ");
INSERT INTO hixNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Onà wyaro haxa ehtxoko. Akatxho kom hoye tàmtxoko, ewakryehnà rotho komo wya. Ekayhera rma tàmtxoko, toto komo nenytxahtor me mak ha, ànenyehtor kom me xarha. Oyonyatxhe mak ha, oyàmkomo. Xenyhenà ro yony kax mak naha ha. Noro rma, ohxe manatxhe kehe hampànà, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Àro wyaro rma rha, Khoryenkom yakoro rma nàrwonatxhe haryhe, anar komo, kekon hatà, Txesusu. Yaworohra mak natxhe, tàhnawonye. Ohxe tosonyhonàr komo xe rma natxhe haryhe, toto komo wya. Àro ke, ohsamnohno ytxoho ro yawo tehtokonye, nàrwonatxhe rma haryhe. Owto ho xarha, yakentawo rma tehtokonye, Khoryenkom yakoro rma nàrwonatxhe haryhe, toto komo wya ohxe tosonyhonàr kom horà, kekon hatà. Onà wyaro yaworo xaxa àkehe, owyanye. Nyamoro hoko rma, ohxe natxhe ketxow hamà, toto komo. Ohxe manatxhe kahra mak naha, Khoryenkomo, àwyanye, kekon hatà. Nyamoro wyarohra ehtxok hampànà. ");
INSERT INTO hixNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Onà wyaro haxa ehtxoko. Khoryenkom yakoro orwonàmtxoko, toto komo nenyehtor me mak ha. Omàn kom yaka àtotxoko, kekon hatà. Yuhnaka rma àtotxoko, ehxera toto yehtok mak ha. Àto rma orwonàmtxoko, oyàmkom yakoro, xenyhenà ro yakoro. Noro rma oyonyatxhe ha. Xenyhenà ro yony kax mak naha ha. Noro rma, ohxe manatxhe kehe hampànà, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Àsok hana nàrwonatxow ha, Xuknewyanahnà kom ha, Khoryenkomo hutwanyehnà kom ha, kekon xarha tà. Thoryenà ro kom yakoro nàrwonatxow hamà. Thenyehra rma nàrwonatxhe haryhe. Àtohnaw mak nàrwonatxow hamà. Mexe rma haxa tàrwonàmtxe, khoryenà ro komo wya ohxe konytxatxho menye, ketxhe rma haryhe, kekon hatà. Àro wyaro kahra mak ehtxoko, Khoryenkom yakoro orwonàmtoho kom hoko. ");
INSERT INTO hixNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nyamoro wyarohra ehtxoko. Mexe rma haxa tàrwonàmtxe, Khoryenkomo wya ohxe konytxatxho menye, kahra ehtxoko, kekon hatà. Àsok tawro hana. Orwonàmpàra ronye rma haka, orwon komo rma hutwehe, oyàmkomo. Ohutwatxehkanye ro komo kax mak naha ha, noro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Àro ke, noro yakoro orwonàmnàtokonye, onà wyaro katxoko. Apa y, kahe yawono y, onà wyaro kanye ro me hak nahtxoko, toto komo, omeroro. Enyhoru ro me naha, Khoryenkomo, kanye ro me hak nahtxoko, ohoko, katxoko. ");
INSERT INTO hixNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Apa y, amamehra nyhe rma hak oyonytxowà, toto komo, tkayaryet kom me harha, katxok xarha. Apa y, oyoyuknye ro me hak nahtxoko, toto komo, kahe yawon komo wya oyoyuhtoho wyaro mak ha, katxok xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Apa y, amnye rma amna ànyahmako, katxok xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Apa y, oseryewhokako, amna yanhànàtho hoko. Apa y, amna xehra toto komo yexetxhe, amna xarha noseryewhokehe, àhokonye, àro ke oseryewhokako, amna hoko, àhokonye amna yoseryewhokanàr ke, katxok xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Apa y, anhà nkukmahtor me amna txeryko, katxok xarha. Apa y, amna ukurunhoko, anhà hona, àsok tawro hana, omeroron komo kayaryet me roro rma haxa oyesnàr ke, ehonomnà me roro rma haxa oyesnàr ke, ohxe xaxa manay hamà katxho me roro rma haxa oyesnàr ke. Àro wyaro rma amna nkehe owya, apa y, katxok xarha, Khoryenkom yakoro orwonàmnàtokonye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Toto kom hoko toseryewhokaxem me oyehtokonye, ohokony xarha toseryewhokaxem me rma rha naha, oyàmkomo, kahe yawono, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Toto kom hoko oseryewhokahra oyehtokony haxa ryhe, ohokony xarha oseryewhokahra rma rha naha, oyàmkomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Àsok hana natxow ha, anar kom ha, kekon xarha tà, Txesusu. Onà wyaro natxow hamà. Natahyehnometxhe rma haryhe, tàyweronàhyamatxhàyamo yawo ro tosonyhotho meny mak ha. Yaworohra mak natxhe, tàhnawonye, kekon hatà. Toto komo wya ohxe tosonyhonàr komo xe rma natxhe haryhe. Àro ke, osonkotohra natxhe, tekhokaxem me harha tosonyhotho menye, tatahyehnomaxem me rma tosonyhotho menye, kekon hatà. Onà wyaro yaworo xaxa àkehe, owyanye. Nyamoro hoko rma, ohxe natxhe ketxow hamà, toto komo. Ohxe manatxhe kahra mak naha, Khoryenkomo, àwyanye, kekon hatà. Nyamoro wyarohra ehtxok hampànà. ");
INSERT INTO hixNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Onà wyaro haxa ehtxoko. Ayatahyehnomantokonye, osonkototxoko rma, ekhokahnà me rma oyosonyhotho menye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Àro wyaro oyehtokonye, ayatahyehnomatxho komo yonyhera natxow hamà, toto komo. Oyonyatxhe mak ha, oyàmkomo, xenyhenà ro. Xenyhenà ro yony kax mak naha ha. Noro rma, ohxe manatxhe kehe hampànà, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Akatxho komo henyekhera ehtxok hampànà, kekon xarha tà, Txesusu. Owyanye àhenyeknyetok haxa, amnye nosomtatken hamà, akatxhothàyamo. Anatoko hurutuhu nenahrà me nay hana. Anatoko nàhxeryehtyen hana, kekon hatà. Anatoko temenyem komo nanàr me nay hana. Àro wyaro rma nosomtatken hamà, akatxhothàyamo, onhenyeketxhàyamotho, yukryeka honotho, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kahe yawo oyowakryetxho kom hok haxa ehtxoko. Àro ryhe, osomtatkahnà ro me naha. Ehxera ro mak naha, hurutuhu, kekon hatà. Ehxera rma rha naha, àhxeryekryenye. Ehxera rma rha naha, any komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Àsok tawro hana. Tano tkatxhonke oyehtokonye, tano roron me oyesnàr komo xe manatxow hamà. Kahe yaw haxa towakryexem me oyehtokonye, àtono ro me oyesnàr komo xe manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ohxe oyonur komo yehtoko, omeroro menyatxow hamà, kekon xarha tà, Txesusu. Tawasnye rma haxa manatxhe, ohnawonye, ohxe oyonur komo yehtok mak ha. ");
INSERT INTO hixNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ohxehra ehtok haxa, xenyhera ro mak manatxow hamà. Tawanye mak manatxhe, ohnawonye. Àro wyaro rma rha, Khoryenkomo hutwahra oyehtokonye, tawanye manatxhe, ohnawonye, kekon hatà. Khoryenkomo hutwany me wehxaha kany me rma oyehtokonye, ohxe mpànà ehtxoko. Noro hutwahra rma manatxow hana. Noro hutwahra oyehtokonye, tawanye rma haxa manatxow hamà, ohnawonye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Horykomo yanoto ro me kehtoko, anaro rha yanoto mehra tehxan hamà, kekon xarha tà, Txesusu. Asako kanotomany komo yehtok haxa, onà wyaro tehxan hamà. Anaro xehra tehxan hamà. Anaro xe tehxan hamà, kekon hatà. Anaro tàxanomkahnohyan hamà. Anaro teyukyan hamà. Àro wyaro rma rha, katxhonano hokono ro me oyehtokonye, Khoryenkom hokon mehra manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Àro ke, onà wyaro àkehe, owyanye, kekon xarha tà, Txesusu. Oseryehokahra ehtxoko, ànyahpàra oyehtxoho kom hoko. Kwayehyan hamà, ànyahpàra ryesnàr ke, kahra ro mak ehtxoko, kekon hatà. Oseryehokahra rma rha ehtxoko, àwomumra oyehtxoho kom hok xarha. Rohunutho natanàhnohyan hamà, àwomumra ryesnàr ke, kahra ro mak ehtxoko, kekon hatà. Khoryenkom yano me àwayehpàra rma hak oyehtokonye, noro yano me rma rha tànyahmaxem me manatxow hamà. Noro yano me tuhnye rma hak oyehtokonye, noro yano me rma rha twomumtosom me manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Àsok hana nay ha, torono ha, kekon xarha tà. Àhomohra nay hamà. Osowrukhura xarha nay hamà. Tànyahrà màmtohra xarha nay hamà, kekon hatà. Àsok tawro hana. Torono nyahmen hamà, oyàmkomo, kahe yawono, kekon hatà. Àro ke, omnyam xarha anyahmetxow hamà, noro ha. Àsok tawro hana. Torono komo yoho rma haxa noro nàhnàn me manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Oyoseryehokatxho komo rma, ohorymamnohpàranye nay hamà, kekon xarha tà. Àro ke, oseryehokahra ehtxoko. ");
INSERT INTO hixNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Toseryehokahoryehra manatxhe, àwomumra oyehtxoho kom hoko. Àsok hana nay ha, txawarkoyato ha, kekon hatà. Tomyawon hokohra nay hamà. Twomun yenyempera nay hamà. Ohxe tonyxem me mak naha, txawarkoyato, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Àsok hana nehxakon ha, Saromaw heno ha. Ohxe tonyxemà ro me rma haxa nehxakon hatà, noro heno. Ehonomnà womun yawo tehtoko, ohxe tonyxemà ro me nehxakon heno hatà. Onà wyaro mak àkehe, owyanye. Noro heno yoho rma haxa ohxe tonyxem me naha, txawarkoyato, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Àsok tawro hana. Khoryenkomo ryhe, txawarkoyato yeherkotkuryen hamà. Ohxe tonyxem me neryan hamà, àwomumtonàrà wyaro mak ha, kekon hatà. Txawarkoyato ryhe, mexehra ehxah me ehxen me harha nay hamà. Taknyohsom me rma nay hamà. Mexehra tehxemà rma womumtehe, Khoryenkomo, ohxe tonyxemà ro me ehtxoho me. Àro yoho rma haxa owomumtony kom me nay hamà, noro ha. Àsok tawro noro hona xenyhera manatxowà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Àro ke, oseryehokahra ro mak ehtxoko, kekon xarha tà. Henta nyhe txko haryhe ronyahrà, kahra ehtxoko. Henta nyhe txko haryhe rowomunu, kahra rma rha ehtxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Àro hoko roro nehutwetxow hamà, anar komo, Khoryenkomo hutwanyehnà komo, omeroro. Ayahyehrà komo hutwany me mak naha, oyàmkomo, kahe yawono. Tànyahrà komo xe natxow hamà, kany me rma naha, noro ha, ohokonye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Àro ke, on hok haxa ehtxoko, omnyamo, kekon xarha tà. Khoryenkomo mryenon me oyehtxoho kom hoko ehtxoko. Noro wyaro rma rha ohxe roro oyehtxoho kom hoko ehtxoko. Àro hoko rma oyehtokonye, anyahrà komo xarha yàmyaha, noro ha. Omeroro rma nàmyaha, owyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Àro ke, awanaworo ohxehra oyehtxoho kom hoko ehutwahra ehtxoko. Amnye rma ohxehra oyehtxoho kom hoko rma ehutwatxoko, àhoko rma Khoryenkom yakoro orwonàmtoho menye. Awanaworo ohxehra oyehtokonye, àro rma ho àhok orwonatxow hamà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Onà wyaro nkekon xarha tà, Txesusu, tànhananàhrà ro komo wya. Toto komo yanhànà hutwany mehra ehtxoko, kekon hatà. Anhàn komo hutwany mehra oyehtokonye, ayanhàn komo hutwany mehra rma rha naha, Khoryenkomo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Anar kom hoko atxke manatxhe kany me haxa oyehtokonye, ohokony xarha atxke manatxhe kany me rma rha naha hampànà, Khoryenkomo, kekon hatà. Owyanye toto komo yowakryentoko, mukuknometxow hamà, ewakryetxho komo. Thenyehra hana, yakehra haxa hana mukuknometxow ha. Àro wyaro owyanye ukuknomatxhàrà wyaro rma rha, oyowakryetxho komo kuknomehe xarha, Khoryenkomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Kuknonano me onà wyaro nkekon xarha tà. Ohoyen komo yonuru menyatxow hana, kekon hatà. Enuru komo kwawo uhpunu txko menyatxow hana. Hoymo y, uhpunu txko hak wowsà, oyonuru kwaye, màketxow hana, àwya. Àro wyaro owyanye tatoko rma, oyonuru komo kwawo rma naha, wewe ymo. Àro ymo yonyhera mak manatxow hamà. Àro wyaro oyehtokonye, onà wyaro tehxorye manatxhe, kekon hatà. Wahoro htxero wewe ymo towtxoko, oyonur komo kwaye rma. Owyanye towàtxhe rma, ohoyen komo yonuru kwaye uhpunu txko mowyatxow hamà, tonke harha oyesnàr kom ke, kekon hatà. Àro wyaro rma rha, ayanhàn kom hoko rma hak oyehtokonye, anar komo hananàhpàra ro mak manatxow hamà. Owyanye àhananàhnàtokony haxa, yaworonohnà ro me manatxow hamà, ayanhàn kom hokon me oyesnàr kom ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kuknonano me rma rha, onà wyaro nkekon xarha tà. Enyhoru yàmpàra tehxatxow hamà, kaykusu wya, kekon hatà. Ehetàhpenyeno rma yàmpàra tehxatxow hamà, honyko wya. Tàmsahotho rma yakmekyan hamà. Bayanye rma nay hamà, khokonye, kekon hatà. Àro wyaro rma rha, àrwo yonyhorunu yokarymahra ehtxok hampànà, Khoryenkomo xanhànà ymo komo wya. Ekarymaxahotho rma xanomkahnohyatxow hamà, nyamoro ha. Owàràhyaketxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Onà wyaro nkekon xarha tà, Txesusu. Apa y, uro ewakryeko kany me ehtxoko. Uro ewakryeko kany me oyehtokonye rma, oyowakryetxhe xaxa mak hampànà, Khoryenkomo, kekon hatà. Apa y, uhutwamohsoko, rowya, kany me ehtxok xarha. Uhutwamohsoko, rowya, kany me oyehtokonye rma, hutwamohsehe xaxa mak hampànà, noro ha, owyanye, kekon hatà. Àsok hana natxow ha, bàn yawon kom ha. Bàn kom hotar hoko, tey tey tey tawro yonytxatxhe rma, nahurmaketxow hamà. Àro wyaro rma rha, tàwya oyonytxatxhenye rma, oyoyukyatxhe xaxa mak hampànà, Khoryenkomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Àsok tawro hana. Uro ewakryeko kany komo rma, towakryexem me harha natxow hamà. Uhutwamohsoko, rowya, kany kom xarha, hutwetxow harha mà. Tey tey tey kany komo xarha, toyuhsom me harha natxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Àsok hana omuru komo meyukyatxow ha. Apa y, rowru txko tàmko, rowya, kany me ehtokonye, tohu ymo yàmpàra manatxow hamà, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Apa y, kana txko tàmko, rotà, kany me xarha ehtokonye, okoye yàmpàra manatxow hamà, àwyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Enyhoru marma màmyatxow hamà, ohokyamo wya. Àro wyaro rma manatxhe, omnyamo, anhà komo rma. Àsok haxa hana nay ha, oyàmkom ha, kahe yawono rma. Oyohonye rma haxa enyhoru yàmnye ro me nay hamà. Owyanye, uro ewakryeko, katxhe rma, enyhoru rma yàmyaha ha, noro ha, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Àsok hana oynyàr komo xe manatxow ha, toto komo wya. Ohxe oynyàr komo xe manatxow hamà, àwyanye. Àro ke, ohxe rma rha toto komo txetxoko, omnyam xarha. Àro wyaro rma khananàhyatxow hamà, Khoryenkom karyehtanà, Moyses heno nmenhotho rma, Khoryenkomo rwonà yokarymanye ro heno komo nmenhotho xarha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Àsok hana nay ha, nàmno hotar ha, kekon xarha tà, Txesusu. Anatoko taxkàtnye nay hana. Taxkàtnye ehtoko, krawame mak tetxow hamà, toto komo, àro yarye. Yakenohnà komo rma nowomyatxow hamà, kekon hatà. Àro wyaro rma rha, kahe yaka ototho komo, krawame naha. Àro ke, yakehra natxow hamà, tàtosom komo, kekon hatà. Anatoko àhotaheny haxa nay hana, nàmno hotarà. Àhotahenye ehtoko, krawamehra tetxow hamà, toto komo, àro yarye. Thenyenohnà komo rma nowomyatxow hamà, kekon hatà. Àro wyaro rma rha, anàhnohno ytxoho ro na ototho komo, krawamehra naha. Àro ke thenyehra natxow hamà, tàtosom komo, kekon hatà. Kahe yaka haxa tàtosom me ehtxoko, taxkàtnyem yarye tàtosom komo wyaro mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yaworohra nekarymetxow hamà, anar komo, kekon xarha tà, Txesusu. Khoryenkomo rwonà yokarymanye uro ketxhe rma haryhe. Yaworohra mak àro wyaro nketxow hamà. Nyamoro hona mpànà xenytxoko, kekon hatà. Towahke rma nosonyhetxhe haryhe, kahneru wyaro, àmayamnà wyaro. Atxke mak natxhe ha, tàhnawonye, kamara wyaro mak ha, bayanyemà wyaro mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Enyhoru hokohra ro mak natxhe, nyamoro ha. Enyhoru hokohra ehtxoho kom hoye ro, yaworonohnà me muhutwetxow hamà, kekon hatà. Ewekhàrà wawo ufa yeherà yonyhera tehxatxow hamà. Wakrakra yato wawo, fek yeherà yonyhera tehxatxow hamà. Àro wyaro rma rha natxhe, yaworonohnà komo, kekon hatà. Enyhoru hokohra ro mak natxhe. Àro ke, owyanye xenyetokonye, enyhorun komo yonyhera manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Àsok hana nay ha, nat ha, kekon xarha tà. Ohxe tehtoko, neheten hamà. Atxke haxa tehtoko, ehetahra nay hamà. ");
INSERT INTO hixNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Àrotho rma, tamaxem me nay hamà. Weheto waka tarymaxem me nay hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Àro wyaro rma rha, enyhoru hokohra ro mak natxhe, yaworonohnà komo. Enyhoru hokohra ehtxoho kom hoye ro, yaworonohnà me muhutwetxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Amna yohà omoro kany me natxhe, toto komo, rowya, kekon xarha tà, Txesusu. Àro wyaro kany kukur kom marma, royàm yoyukyatxhe, omerorohra mak ha. Nyamoro marma, noro yowto hona tetxhe, kahe yawono yoyuknyenhàr me tesnàr kom ke, kekon hatà. Anar kom haxa ryhe, amna yohà omoro kany kukur komo rma, àtohra natxhe hampànà, noro yowto hona, eyukhura tesnàr kom ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Khoryenkom yowto ho nyamoro yehtoko, onà wyaro nketxhe rma haryhe, anar komo, thenyenohnà komo, rowya, kekon hatà. Amna yohà y, oyowto hona amna nomokno, ketxhe rma haryhe. Ayano me ro rma amna nekarymekonà, ketxhe rma haryhe. Ayano me ro rma rha, worokyamo amna nowyakonà, toto komo hyaye, ketxhe rma haryhe. Ayano me ro rma rha, eryehokano amna neryakonà, àro ke, omohtxok ha, rowto hona, kasko, amna wya, ketxhe rma haryhe, rowya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Onà wyaro haxa àkehe hampànà, àwyanye. Oywenyekenye wehxaha, àkehe hampànà, àwyanye. Àtotxok ha, rohyaye, atxke rma haxa oyesnàr kom ke, àkehe hampànà, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Rorwonà yonytxetxhe, anar komo, kekon hatà, Txesusu. Royukyatxhe xarha. Àsok hana natxow ha, nyamoro ha, kekon hatà. Onà wyaro natxow hamà. Ukuknon komo rma wekarymehe, owyanye. Bàn yenyàr xe nehxakon hatà, toto. Tàywero nehxakon hatà. Àro ke, yuhnaka rma haxa nakay hatà. Toh hona bàn yeryey hatà, towaxke ehtxoho me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Amnye nomokye hatà, tuna heno. Nàkmay mak hatà. Atxowowo ymo xarha nomokye hatà, kekon hatà. Dyow, dyow, dyow kekon hatà, tuna ymo, toto màn hoko. Emokotohra mak nehxakon hatà, toh hona txexah me esnàr ke, kekon hatà. Àro wyaro rma rha, atanàhnohpàra ro mak natxhe, royuknye komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Anar kom haxa ryhe, rorwonà yonytxetxhe rma haryhe, kekon xarha tà. Royukhura rma natxhe. Nyamoro kuknon xarha wekarymehe, owyanye, kekon hatà. Bàn yeryey xarha tà, toto, anaro. Tàywenyek mak nehxakon hatà. Àro ke, sakarara hona haxa neryey hatà. Ewahxera rma nehxakon hatà, àmànàthàrà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Amnye nomokye hatà, tuna heno. Nàkmay mak hatà. Atxowowo ymo xarha nomokye hatà, kekon hatà. Dyow, dyow, dyow kekon hatà, tuna ymo, toto mànàtho hoko. Bo, nemokotoy hatà. Natanàhnohtàkay mak hatà, omeroro. Àro wyaro rma rha natanàhnohtàketxhe hampànà, royuknyehnàtho komo, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Àro wyaro hananàhtxownà hatà, Txesusu. Thenyehra nehxatxkon hatà, toto komo, thananàhsom komo. Àwya thananàhtàkatxhenye rma, onà wyaro nketxkon hatà. Koo, ohxe rma haxa khananàhtxow hamà, mosonà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Àro wyaro nketxkon hatà, ehonomnà me tàwyanye xenyàr ke. Ehonomnà me rma haxa hananàhyatxkon hatà, Txesusu. Àyweronàhyamano ynye ro komo yoho rma haxa hananàhyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Taa. Àhà ymo yonàhtoy hatà, Txesusu. Tàwya enàhtotxhe rma, toy xarha tà. Akoro rma tetxkon hatà, toto komo, thenyenohnà komo. ");
INSERT INTO hixNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Taa. Àhyaka nomokye hatà, toto. Hunmata ymo yawo rma haxa nehxakon hatà, noro ha. Ehonomnà me Txesusu yonyakon hatà. Àro ke, tosoknar ho neryewtay hatà, akrataka. Rohà y, kekon hatà. Amna yonyhoryenye omoro hatà. Ronyhoryenàr xe oyehtoko, uro menyhoryen hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Natahoyotkay hatà. Txesusu. Dye, nahey hatà. Oyonyhoryenàr xe wehxaha, kekon hatà. Konyhoryen hampànà, kekon hatà, Txesusu. Àtoko rma nàhnànkay hatà, uhunmatathotho. Ohxe harha nehxakon hatà, toto. ");
INSERT INTO hixNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Onà wyaro nkekon xarha tà, Txesusu, àwya. Toto komo wya oskarymahra xaxa exko hampànà, kekon hatà. Àtoko. Osonyhota, horykomo wya, Khoryenkom màn yonye ro wya, kekon hatà. Moyses heno nekarymatxho yawo ro, owoknàthàrà màmyaha ha, àwya, kekon hatà. Khoryenkomo wya tàmsomà rma màmyaha ha, enyhoryexah me oyesnàr ke. Àro wyaro rma muhutwamohsehe, oyonyhoryetxhàrà, toto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Taa. Kafahnaw hona nahatakay hatà, Txesusu. Ahatakantoko rma, àhyaka nomokye hatà, horykomo. Arymano ynye ro komo yohà rma mok nehxakon hatà, 100 komo yohà rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Onà wyaro nkekon hatà, teryewrye ro hatà, Txesusu wya. Rohà y, ekeh me rma haxa manaye, ranototho, amusnano wya, kekon hatà. Romàn yawo manaye. Neryewano rma haxa mak hatà, kekon hatà, horykomo. ");
INSERT INTO hixNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ayakoro komokyaha, noro yonyhoryexe, kekon hatà, Txesusu, àwya. Noro yonyhoryexe komokyaha, omàn yaka, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Onà wyaro haxa neyukye hatà, horykomo. Rohà y, ehonomnà me rma haxa manay hatà, kekon hatà. Romàn yaka owompàra manay hamà, ehonomnà me oyesnàr ke, roho rma haxa oyesnàr ke. Àro ke romàn yaka àtohra exko, kekon hatà. Tano rma oyehtoko, onà wyaro kasko, ranototho hoko. Wenyhoryen hampànà kasko. Àro wyaro owya katxhe rma, ohxe harha naha, ranoto, kekon hatà, horykomo. ");
INSERT INTO hixNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Àsok tawro hana. Owyaro rma rha roh yano me ehonomnà me wehxan hamà. Àro ke arymano ynye ro komo wanotomen hamà, kekon hatà. Àtok ha àkehe, anaro wya. Noro rma tehe, rano me ro mak ha. Omok ha àkehe xarha, anaro wya. Noro rma nomokyaha, rano me ro rma rha, kekon hatà. On hok exko àkehe xarha, ranoto komo wya xarha. Àro hoko rma natxhe, nyamoro xarha, rano me ro rma rha. Àro wyaro rma rha toyuhsom me manay hamà, omoro xarha, kekon hatà. Àro ke, owya wenyhoryen hampànà katxhe rma, ohxe harha nay hamà, ranoto, kekon hatà, horykomo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Àro wyaro tàwya enytxatxhe rma, koo kekon hatà, Txesusu, tàwya rma. Ehonomnà me xaxa ronyan hamà, mosonà, Xuknewyanahnà rma, kekon hatà, tàwya rma. Onà wyaro nkekon xarha tà, toto komo wya, takoron komo wya. Onà wyaro yaworo xaxa àkehe, owyanye, kekon hatà. Rohona rma haxa nenyan hamà, mosonà. Ehsayewyana komo yoho rma haxa, rohona nenyaha, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Onà wyaro àkehe xarha, owyanye. Amnye, Khoryenkom yowto ho natxhe hampànà, Akmaraw komo, Esake xarha, Xako xarha. Àhyawonye rma natxhe hampànà, anaro rha yana komo xarha, kamàm yahatakatxho nyeron komo rma, kamàm yowomtoho nyeron komo xarha, kekon hatà. Khoryenkom yowto ho nasahxemtetxhe hampànà, nyamoro ha. ");
INSERT INTO hixNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ehsayewyana kom haxa ryhe, Khoryenkomo mryenon komo kàwyamo kany komo rma, ukukur komo rma, owompàra ro mak natxhe hampànà, Khoryenkom yowto hona, kekon hatà. Tarymaxem me natxhe hampànà, nyamoro heno, anàhnohno ytxoho ro na. Àto rma tawanye rma haxa naha. Àton heno komo rma nàratetxhe hxak hampànà, teryewhamnohrà komo ke, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Onà wyaro nkekon xarha tà, horykomo wya, arymano ynye ro komo yohà wya. Àtoko, omàn yaka, kekon hatà. Àtoko, omàn yaka. Onà wyaro màkano, rowya. Owya wenyhoryen hampànà katxhe rma, ohxe harha nay hamà, ranoto, màkano. Àro wyaro màkano, rohona owya xenyàr ke. Àro ke, ohxe harha naha, ayanoto, kekon hatà, Txesusu, àwya. Àro wyaro àwya tatoko rma, ohxe harha nexey hatà, anoto. ");
INSERT INTO hixNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Taa. Petru màn yaka toy hatà, Txesusu. Towomàtxhe rma, Petru hetx yon heno yonyey hatà. Ekeh me nehxakon hatà, noro heno, atunano wya. ");
INSERT INTO hixNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Amorà yahey hatà, Txesusu. Àwya ahetxhe rma, nàhnànkay hatà, atunano. Say, nasanàmye hatà, wosà. Natamokyakon harha tà, Txesusu hyaka. ");
INSERT INTO hixNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Àro rma kokmamrà ro nomohtxownà hatà, toto komo. Ekeh komo yokyatxkon hatà, Txesusu hyaka. Worokyamo yoh komo xarha yokyatxkon hatà. Thenyehra nehxatxkon hatà, worokyamo yoh komo. Àhyayenye worokyamo yowye hatà, Txesusu, tàrwon ke mak hatà. Ekehàtho komo xarha yonyhoryetxehkay hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Àro wyaro Esaeyas heno nmenhotho yawo ro nehxakon hamà, Txesusu. Onà wyaro nmenhoy hatà, noro heno, Khoryenkomo rwonà yokarymanye ro heno. Keheryan komo yowyaha hampànà, noro ha. Àro wyaro rma nmenhoy hatà, Esaeyas heno. Ànmenhothàrànhàr yawo ro rma haxa nehxakon hamà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Txesus yakoro nehxatxkon hatà, toto komo. Thenyehra rma haxa nehxatxkon hatà. Thenyehra ehtxoho komo yonyakon hatà, noro. Àro ke, onà wyaro nkekon hatà, tànhananàhrà ro komo wya. Àpa txowà, mon hona, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Àtohra ronye rma haka, nomokye hatà, toto, àyweronàhyamano ynye ro. Onà wyaro nkekon hatà, Txesusu wya. Khananàhnye y, ayakoro komokyaha, kekon hatà. Henta kom otontok hana, àsna rma àtehe, ayakoro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Onà wyaro nkekon mak hatà, Txesusu, àwya. Àsok hana natxow ha, onokna kom ha, torono komo xarha, kekon hatà. Bànke natxow hamà, nyamoro ha. Towtakem me natxhe, onokna komo. Tamke natxhe, torono komo. Toto me Enusah haxa ryhe, àmàmra naha, kekon hatà. Atakryetxho rma, ehxera naha. Àro wyaron yakoro rma otonàr xe kat manaye, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Onà wyaro nkekon xarha tà, toto anaro. Txesusu nhananàhrà rma mok nehxakon hatà. Rohà y, omokhàra hak wehxaha, ayakoro, kekon hatà, Txesusu wya. Royàm peno wayhàtxhe, wenamyan hamà, uro ha. Rowya noro heno yonamàtxhe, àten hamà, ayakoro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Àna matà, kekon mak hatà, Txesusu, àwya. Anar kom hak àwayehsahotho yonamtxowà. Karyhe roro harha manatxhe katxhohnà komo rma hak nenamtxowà. Omoro haxa ryhe, omoko, rakoro, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kanawa yaka nosonkahye hatà, Txesusu. Nosonkahtxownà xarha tà, ànhananàhra ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Àtontokonye rma, nomokye hatà, atxowowo ymo, thenyenohnà ymotho rma haxa mak hatà. Ukuthonà ymo hoko rma haxa natxowowonakon hatà. Nataràhtekon hatà, kanawa heno. Tànàhso nehxakon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nempakatxownà hatà, akoron komo. Amna yohà y, ketxkon hatà. Tànoryatxow hamà. Kàwyamo ukurunhoko, kwayehrà kom hona, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Àsok tawro moseryehyatxow harha, kekon hatà, Txesusu, àwyanye. Àsok tawro moseryehyatxow harha. Khoryenkom hona xenyhera manatxow hamà, kekon hatà, àwyanye. Àro wyaro tàwya katxhe rma, nasanàmye hatà. Atxowowo ymo yatàknanàhkay hatà. Dà kasko, kekon xarha tà, tuna ymo wya. Dà, natàknay hatà. Tatàknye rma haxa nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Noseryehoketxkon hatà, akoron komo. Onok moson haryhe, ketxkon hatà. Onok moson haryhe. Atxowowo ymo neyuknur me nay hamà. Tuna ymo neyuknur me xarha nay hamà, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mon hona nahatakatxownà hatà, Txesus komo. Kaknara yamtar hona rma nahatakatxownà hatà. Txesusu yasanàmàtxhe rma, àhyaka nomohtxownà hatà, toto, asako. Worokyamo yohà rma mokyam nehxatxkon hatà. Onokna bayanyemà wyaro nehxatxkon hatà, worokyamo yoh me tesnàr kom ke hatà. Àhyahanye àtohra ro mak nehxatxkon hatà, toto komo, àhonanye toseryehrà kom ke hatà. Nyamoro rma nomohtxownà hatà, Txesusu hyaka. Yatxetxho waye nomohtxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Onà wyaro nketxkon hatà, àwya, teryewrye ro hatà. Khoryenkom muru omoro ha, ketxkon hatà. Àsok manaye, amna hoko. Amna yeryewhamnohso momokno hamà, ketxkon hatà. Amna yeryewhamnohpàra exko. Amna yeryewhamnohtoho mehra rma hak naha, owya, ketxkon hatà, worokyamo yoh komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Àto nehxatxkon hatà, okno komo, honyko wyaron komo. Moxe nyhe txko nehxatxkon hatà, thenyehra rma haxa mak hatà. Nasahxemtetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Àro ke, onà wyaro nketxkon hatà, toto komo, worokyamo yano me hatà. Owya amna yownàtoko, amna ànyahko, okno komo yowan yaka, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Àtotxok ha, kekon hatà, Txesusu. Àro ke notowtxownà hatà, worokyamo komo, toto komo hyaye, kray kray. Okno komo yowan yaka haxa nowomtxownà hatà, kuru kuru kuru. Uuff, huhyakanto kàtatxownà hatà, okno heno komo, omeroro. Krow, ukuthonà kwaka nowomtxownà hatà. Nànotàhkatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Okno yonye rotho komo ryhe nekahtàmtxownà hatà. Owto hona totxownà hatà. Àton komo wya nekarymatxownà hatà, omeroro hatà. Worokyamo yohàtho komo yexetxhàr xarha yokarymatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Àro ke, Txesusu hyaka totxownà hatà, owto hon komo, omeroro hatà. Tàwyanye xenyetxhe rma, onà wyaro nketxkon hatà, àwya. Àtoko, amna yowto hoye, ketxkon hatà, teryewrye ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nosonkahtxownà hatà, Txesus komo, kanawa yaka. Tuna ymo wetotxownà hatà. Towto kom hona harha nahatakatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Txesusu hyaka nomohtxownà hatà, toto komo. Ekeh yohtxownà hatà, tahon hono rma hatà, amusnaxaho rma hatà. Rohona xaxa nenyatxow hamà, kekon hatà, Txesusu, tàhnawo. Àro ke, onà wyaro nkekon hatà, amusnaxaho wya. Kàrà y, kekon hatà. Teryehorye harha exko. Koseryewhokan hampànà, ayanhànàthàrà hoko. Towsah me harha naha, ayanhànàthàrà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Àto nehxatxkon hatà, àyweronàhyamano ynye ro komo. Tàwyanye Txesusu yonytxatxhe rma, onà wyaro nketxkon hatà, ukukur komo, tàhnawonye. Khoryenkomo wàràhyaken hamà, mosonà, ketxkon hatà. Khoryenkomo wyaro kanhànàthàyamo yownye me nehutwen hamà, ketxkon hatà, tàhnawonye. ");
INSERT INTO hixNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ehutwatxho komo rma hutwekon hatà, Txesusu, tàhnawo. Àro ke, onà wyaro nkekon hatà, àwyanye. Àsok tawro atxke mehutwetxow haryhe, ohnawonye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Rowya, towsah me harha naha, ayanhànàthàrà, katxho ryhe, tkahoryehra nay hamà, owyanye. Asanàmko, àtok ha, katxho haxa ryhe, tkahorye rma haxa nay hamà, owyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Towsah me harha naha, ayanhànàthàrà, kany me mak wehxaha, Toto me Enusah kaxe. Tano rma yukryeka ho rma ryehtoko, àro wyaro kany me wehxaha, Khoryenkom yano me mak ha, kekon hatà. Àro wyaro kany me hak kehutwamohsosà, owyanye. Moson yeheryanàtho wowyaha hampànà, Khoryenkom yano me ryehutwamohsonàr horà, kekon hatà. Onà wyaro àkehe, owya, kekon hatà, amusnaxaho wya. Asanàmko, ayahon anàmko ha, omàn yaka àtok ha, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sax, nasanàmye hatà, amusnaxahotho. Toy hatà, bàn yaka. ");
INSERT INTO hixNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nenytxownà hatà, toto komo, thenyenohnà komo. Àro ke noseryehoketxkon hatà. Ohxe xaxa nay hamà, Khoryenkomo, ketxkon hatà. Noro yano me ehonomnà me rma haxa nay hamà, mosonà, toto rma, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Àsnye ro toy hatà, Txesusu. Tàtonàr me rma, toto yonyey hatà. Matewsà rma noro ha. Nàmno yawo nehxakon hatà. Txenyeru yahohtoho yawo rma nehxakon hatà, eryewtaxaho, tkayaryet komo txenyerun yahosnye ro kaxe. Noro wya rma, onà wyaro nkekon hatà, Txesusu. Rakoro omok ha, kekon hatà. Sax, nasanàmye hatà, Matewsà. Txesus yakoro harha toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Taa. Bàn yaka Txesus yarày hatà, Matewsà. Emtakmantokonye, nomokyatxkon hatà, toto komo, thenyenohnà komo. Tkayaryet komo txenyerun yahosnye ro komo rma mokyam nehxatxon hatà, atxke natxhe moxamo katxho komo xarha hatà. Nyamoro rma nemtakmatxownà hatà, Txesus kom yakoro, ànhananàhrà ro kom yakoro xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nenyatxkon hatà, Farysew kukur komo. Àro ke, onà wyaro nketxkon hatà, Txesusu nhananàhrà ro komo wya. Àsok tawro mokyam yakoro nemtakmeno, ahananàhnye komo, ketxkon hatà. Atxke natxow hamà, mokyamo, txenyeru yahosnye ro komo rma, atxke natxhe moxamo katxho komo xarha. Àsok tawro nemtakmeno, anhà kom yakoro, ketxkon hatà, Farysew komo. ");
INSERT INTO hixNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nenytxatxownà hatà, Txesusu. Àro ke, onà wyaro nkekon hatà, àwyanye. Àsok hana natxow ha, eheryamnà kom ha, kekon hatà. Ohtxemano ynye ro komo hyaka àtohra natxow hamà, enyhoru kom kaxe. Teheryankem kom marma ryhe, àhyakanye tetxhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Àro wyaro rma rha, rohyaka omokhàra natxhe, ohxe natxhe moxamo katxho komo. Atxke natxhe moxamo katxho kom haxa ryhe, rohyaka nomokyatxhe. Àwyanye rma, rakoro omohtxoko kanye uro komokye, kekon hatà. Àro ke, àmenhosahonhàrà uhutwatxok harha. Onà wyaro rma nkehe. Toto komo hnàn yawo oyesnàr kom xe wehxaha. Àhnàn kom yawohra rma oyehtokonye, rowakryenàr xehra mak wehxaha, owyanye. Owoknàthàyamo yàmrà xehra rma wehxaha, owyanye, toto komo hnàn yawohra oyesnàr komo ke. Àro wyaro rma nkehe, àmenhosahonhàrà. Àro wyaro katxhàrànhàrà rma uhutwatxok harha, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Txesusu hyaka nomohtxownà hatà, Xowawu nhananàhrà ro komo, aymomno ynye nhananàhrà ro komo. Onà wyaro nketxkon hatà, àwya. Kàyweronàhyamatxho kom yawo ro amna natahyehnomehe yohà, ketxkon hatà. Àro yawo ro rma rha natahyehnometxhe yohà, Farysew komo xarha. Onhananàhrà ro kom haxa ryhe, atahyehnomahra natxhe haryhe. Àsok tawro atahyehnomahra natxowà, ketxkon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Onà wyaro neyuhtxownà hatà, Txesusu. Àsok hana natxow ha, ronhananàhrà ro kom ha, kekon hatà. Thetx yahosnye yakoron komo wyaro natxow hamà. Tàwya thetx yahosnàtoko, tkukur komo yanyekyan hamà, toto. Asahxemtoso nanyekyatxow hamà. Àro ke, tàhyawonye rma hak noro yehtoko, atahyehnomahra natxow hamà, kekon hatà. Amnye àhyayenye tehe, àhehtaxaho. Tàhyayenye àtotxhe rma, natahyehnometxhe hxak hakahpa harha, akoronotho komo, toseryehokanàr kom ke mak ha, kekon hatà. Àro wyaro rma rha natxhe, ronhananàhrà ro komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kuknonano me rma rha, onà wyaro nkekon xarha tà, àwyanye. Rowya ahananàhtoho komo ryhe, wom xenyeno wyaro naha, kekon hatà. Kwomunuthuyamo yenyemrà xe kehtokonye, wom xenyenohnà ke tenyemyatxow hamà. Xenyeno ke haxa kàwyanye enyemnyetoko, notowyan hamà, xenyenotho. Kàwyanye ahxeketxhe rma, notowyan hamà, kwomunuthuyam hoye, amnyehranotho hoye. Tamtak harha nay hamà, ewtarà, kekon hatà. Àro wyaro rma rha, oyweronàhyamatxhotho kom yawo ro rma haxa oyehtokonye, ronytxanàr xehra manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ufa xkunu wyaro xarha naha, rowya ahananàhtoho komo, kekon xarha tà. Àkawawantaxenyeno wyaro rma naha. Àkawawantaxenyen me ufa xkun yehtoko, arkahra tehxatxow hamà, enàthàrànhàr yaka, amnyehranotho yaka, okno hutxhothonhàr yaka, kekon hatà. Àrotho yaka kàwyanye arkantok haxa, enàthàrànhàrà rakehe. Notukwamyaha hxak ha, àkawawantaxenyenotho. Enàthàrànhàràtho xarha, natanàhnohyaha hxak ha, kekon hatà. Àkawawantaxenyeno rma, xenyeno yaka ryhe tarketxow hamà. Xenyeno yawo tehtoko, ohxe nay hamà, ufa xkunu. Ohxe rma rha naha, en xarha, kekon hatà. Àro wyaro rma rha, rowya ahananàhtoho kom yawo ro rma haxa oyehtokonye, oyweronàhyamatxhotho kom yawo rohra harha manatxow hamà, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Àro wyaro Txesusu wya tatoko rma, àhyaka nomokye hatà, horykomo. Xuknewyana komo yohà rma mok nehxakon hatà. Tosoknar ho neryewtay hatà, Txesus yakrataka, ehonomnà me tàwya xenyàr ke. Onà wyaro nkekon hatà, àwya. Wayehno, romsàtho txko, kekon hatà. Omoko, romàn yaka. Norotho txko yahexe omoko, enyxentatho me harha, kekon hatà, horykomo. ");
INSERT INTO hixNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Àro ke toy hatà, Txesusu, akoro. Totxownà xarha tà, ànhananàhrà ro komo, Txesus yakoro. ");
INSERT INTO hixNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Àtontokonye rma, Txesusu mkaye nomokye hatà, wosà. Ekehà rma mok nehxakon hatà, tkamsukryemà roro rma hatà. Tkamsukrye roro 12 me txemnyehàntay hatà. Noro rma, Txesusu mkaye nomokye hatà. Àhonon yotxhàrà yahey hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Onà wyaro rma nkekon hatà, tàwya rma. Rowya àhononà yahenàr ke ryhe, ohxe harha wehxan hamà, kekon hatà. Àro ke nahey hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Neramay hatà, Txesusu. Wos yonyey hatà. Wosà y, kekon hatà, àwya. Teryehorye harha exko. Ohxe harha manaha, rohona owya xenyàr ke mak ha, kekon hatà, àwya. Àtoko rma ohxe harha nehxakon hatà, wosà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Horykomo màn yaka totxownà hatà, Txesus komo. Àto rma nehxatxkon hatà, toto komo, thenyehra hatà. Natmeryketxkon mak hatà, omsamtxemo heno hnànà. Noro heno hnànà rma rha, weryeke txemekyatxkon xarha tà, ukukur komo. Nenytxownà hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Àro ke, onà wyaro nkekon hatà, àwyanye. Àtotxoko, kekon hatà, àwyanye. Àtotxoko. Àwayehpàra naha, omsamtxemo. Ànàknàrà rma onà. Àro ke àtotxoko, kekon hatà, àwyanye. Newnohtxownà mak hatà, toto komo. Àna make ryhe mpe, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nahatakatxownà mak hatà, horykomo màn yaye. Ahatakatxhenye rma, nowomye hatà, Txesusu. Omsamtxemo yahosày hatà, amor hoko. Sax, nasanàmye hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tàwya ekehàtho yanàmtoho hoye ro nekaytay hatà, Txesusu. Noro yokaytà yonytxetxkon hatà, omeroron komo, àton komo rma, àhorye ron komo xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Àsnye ro toy hatà, Txesusu. Àtontoko, akoro totxownà hatà, toto, asak hatà. Enhunu ro rma mokyam nehxatxkon hatà. Onà wyaro nketxkon hatà, teryewrye ro hatà. Dafe heno yohamàtho omoro hatà, ketxkon hatà. Amna hnàn yawo exko, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tekonà rma hatà, Txesusu. Bàn yaka nowomye hatà. Àhyaka haxa totxownà hatà, enhunu ro komo. Onà wyaro nkekon hatà, Txesusu, àwyanye. Àsok wehxano, owyanye, kekon hatà. Oyontanàhnye kom me kat wehxano. Oyontanàhnyehnà kom me kat wehxano. Àsok wehxano, owyanye, kekon hatà, Txesusu, àwyanye. Amna yohà y, ketxkon hatà. Amna yontanàhnye omoro ha, amna wya, ketxkon hatà, enhunu ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Enur komo yahey hatà, Txesusu. Kontanàhtxow hampànà, kekon hatà, àwyanye. Owyanye amna yontanàhnye omoro ha katxho yawo ro rma oyontetxhe harha, rohona owyanye xenyàr ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Àtoko rma tonke harha nehxatxkon hatà, enhunu rotho komo. Onà wyaro nkekon xarha tà, Txesusu, àwyanye, teryewrye ro hatà. Toto komo wya oskarymahra xaxa mpànà ehtxok ha, kekon hatà. Rowya oyontanàhtoho komo yokarymahra xaxa mpànà ehtxok ha, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nekarymatxownà mak hatà, nyamoro ha. Txesusu hyaye tàtotxhenye, nekarymatxownà hatà, àton komo wya, omeroron komo wya. Ehonomnà me rma haxa nay hamà, mokà, ketxkon hatà, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Enhunu rotho komo tontoko rma, Txesusu hyaka nomohtxownà hatà, anar komo. Toto yohtxownà hatà. Noro ryhe, worokyamo yoh me nehxakon hatà. Àrwomnà ro me rma nehxakon hatà, worokyamo yano me mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Noro hyaye nowye hatà, Txesusu. Worokyamo yowye hatà. Nàrwonàmye harha tà, àrwomnà rotho. Noseryehoketxkon hatà, toto komo. Àro wyaro mosonà wya enyhoryetxho ryhe, denyehtorà rotho kom me nay hamà. Ehsayewyana komo nenyehtorà rotho me nay hamà, ketxkon hatà, toto komo, thenyenohnà komo rma. ");
INSERT INTO hixNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Farysew kom haxa ryhe, onà wyaro haxa nketxkon hatà, Txesus hoko. Worokyamo yohà ymo yano me ryhe, worokyamo yownye me nay hamà, mosonà, ketxkonà rma haryhe tà, Farysew komo. ");
INSERT INTO hixNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Anaro rha owto ymo hona tekon hatà, Txesusu, anaro rha owto txko hona xarha hatà. Anaro rha ohsamnohno ytxoho ro yaka tekon hatà. Hananàhno ryakon hatà. Àrwo yonyhorunu yokarymekon hatà. Àsok hana kàkayaryet kom me nay ha, Khoryenkom ha. Àro rma yokarymekon hatà, toto komo wya. Teheryankemàtho komo yonyhoryekon xarha tà, omeroro hatà. Enyhoruhnutho komo rma yonyhoryekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Thenyehra rma haxa nomokyatxkon hatà, toto komo, àhyaka. Tàwya xenyetokonye rma, àhnàn kom yawo rma haxa nehxakon hatà, Txesusu. Àsok hana nay ha, kahneru ha. Esompàra tehtoko, toseryehokaxem me nay hamà, kahneru. Ahoxemra nay hamà. Àro wyaro rma rha ohxehra nehxatxkon hatà, toto komo, Khoryenkomo hutwahra tesnàr kom ke hatà. Àro ke, àhnàn kom yawo rma haxa nehxakon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Àro ke, onà wyaro nkekon hatà, tànhananàhrà ro komo wya. Nat yeher komo wyaro, thenyehra rma haxa natxhe, toto komo, Khoryenkomo hyaka tohsom komo, kekon hatà. Khoryenkomo hyaka soknye kom haxa ryhe, yakehra ro mak natxhe. ");
INSERT INTO hixNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Àro ke, soknye komo nyaknyàr hoko orwonàmtxoko, Khoryenkom yakoro. Àsok tawro hana. Owto yohà wyaro nay hamà, noro ha, tànatkemà wyaro mak ha, kekon hatà. Noro yakoro rma orwonàmtxoko. Apa y, ayanoto komo ànyahtxoko, katxoko, àwya, kekon hatà. Apa y, ànyahtxoko, ohyaka àwyanye toto komo yohtoho me, katxoko, àwya, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","12 komo yanyekye hatà, Txesusu. Tànhananàhrà ro komo rma yanyekye hatà, tàhyaka. Onà wyaro nkekon hatà, àwyanye. Rano me ryhe ehonomnà me manatxhe, owyanye worokyamo yowtoho me, owyanye teheryankemàtho komo yonyhoryetxho me xarha, enyhoruhnutho komo rma yonyhoryetxho me, kekon hatà, 12 komo wya, tànànyaknyàr komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nyamoro yosotà rma, onà wyaro nehxakon hatà. Wahorono Semawu. Petru rma noro ha, esot yowtà rma. Anaro Antrye. Semaw yowtà rma noro ha. Anaro xarha Txaku. Sekmeknew muru rma noro ha. Anaro xarha Xowawu. Txaku yowtà rma noro ha. ");
INSERT INTO hixNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Anaro xarha Feryepe. Anaro xarha Bahtormewu. Anaro xarha Tome. Anaro xarha Matewsà. Tkayaryet komo txenyerun yahosnye rotho rma noro ha. Anaro xarha Txaku. Awfew muru rma noro ha. Anaro xarha Taknewu. ");
INSERT INTO hixNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Anaro xarha Semawu. Serotes komo yakoronotho rma noro ha. Anaro xarha Xuknasà Eskaryotesà. Txesusu yahohsonye rma noro ha, anhà komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","12 komo nyakye hatà, Txesusu. Tàwya ànyakhera ronye rma haka, onà wyaro nkekon hatà, àwyanye. Xuknewyanahnà komo hyaka àtohra ro mak ehtxok hampànà, kekon hatà. Samaryayana yowto kom hona xarha àtohra ro mak ehtxok hampànà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ehsayewyana komo hyaka marma àtotxoko. Nyamoro rma, okno àwaymamxemo komo wyaro natxow hamà, Khoryenkomo hutwahra tesnàr kom ke. Àro ke, àhyakanye àtotxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Otonàr kom me ekarymatxoko. Onà wyaro rma katxoko, toto komo wya. Kàkayaryet kom me Khoryenkomo nànyaketxho ryhe, omohsah me naha, katxoko, àwyanye, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ekehàtho komo enyhoryetxoko, kekon xarha tà. Àwayehxemotho komo anàmtxoko. Hunmata ymo yawonotho komo enyhoryetxok xarha. Worokyamo towtxok xarha, toto komo hyaye, kekon hatà. Ehematxoko, amna wya oyonyhoryetxho komo, kahra ro mak ehtxoko, toto komo wya. Àsok tawro hana. Rano me ryhe ehonomnà me manatxow hamà. Ehonomnà me oyehtxoho komo rma yehemahra manatxow hamà, rowya. Àro ke, ehematxoko kahra ro mak ehtxoko, anar komo wya, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Onà wyaro nkekon xarha tà, àwyanye. Akorohra rma àtotxoko, kekon hatà. Otxenyerun komo yarhàra ehtxoko. ");
INSERT INTO hixNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ayamatan komo xarha yarhàra ehtxoko. Asako owomun komo yarhàra ehtxoko, kekon hatà. Asako ohrorà womun komo xarha yarhàra ehtxoko. Ayahoso komo xarha yarhàra ehtxoko, kekon hatà. Àsok tawro hana. Akorohra rma otontokonye, towakryexem me rma manatxhe ha, ranoto me oyesnàr kom ke mak ha. Tànyahmaxem me rma manatxhe ha. Àsok tawro hana. Kàhyakanye tatamoketxhenye, towakryexem me natxow hamà, toto komo, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Anaro rha owto hona àtotxoko, kekon xarha tà. Owto hona ayahatakatxhenye rma, enyhoru komo ehotxoko. Oyonytxanàr xan komo rma ehotxoko. Nyamoro rma màn yaka àtotxoko, kekon hatà. Àto rye rma hak oyonmahyatxhe ha. Owto hoye otohra ronye rma haka, àro rye yawo rma oyonmahyatxhe ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Àmàn kom yaka oyowomàtxhenye rma, onà wyaro htxero katxoko, àton komo wya. Teryehorye hak oytxowà, Khoryenkomo, katxoko, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Teryehorye texem me ehtokonye, neryehoryetxow hamà, Khoryenkomo. Teryehorye texem mehra haxa ehtokonye, eryehoryehrany nay hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Oyonytxahranye rma ehtokonye, onà wyaro ehtxoko, anhàn komo hutwamohsonàr horà. Àmàn kom yaye otontokonye, ewto kom hoye rma otontokonye, ehtahpunkatxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Onà wyaro yaworo xaxa àkehe, owyanye, nyamoro hoko. Amnye, Khoryenkomo wya wahanonkano ytxoho ro ho haxa, atxke rma haxa natxhe hampànà, àton komo, oyonytxanyehnànhàyamotho. Soknoma hon heno komo yoho rma haxa, atxke natxhe hampànà. Komoha hon heno komo yoho rma haxa, atxke natxhe hampànà, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Onà wyaro nkekon xarha tà, Txesusu, 12 komo wya. Àsok hana nay ha, kahneru ha, kekon hatà. Kamara wawo tehtoko, osowyomahra nay hamà. Àro wyaro rma rha manatxhe hampànà. Toto komo hyaka mpànà dyakyatxhe ha, kamara wyaron komo hyaka rma, kekon hatà. Àro ke, ohxe mpànà ehtxoko. Àsok hana nay ha, okoy ha. Twero nay hamà. Okoye wyaro rma rha twero ehtxoko, kekon hatà. Àsok hana nay ha, watkuku ha. Towahke nay hamà. Watkuku wyaro rma rha towahke ehtxoko, toto kom hoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Toto kom hona mpànà xenytxoko, kekon xarha tà. Àsok hana oyeryewhamnohyatxow ha. Oyeryewhamnohyatxow hamà. Ayaryatxhe hampànà, horykomo komo hyaka, tosonytxaxemà ro komo hyaka. Tohsamnohtoho kom yawo ohpokyatxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tkayaryet komo hyaka ayaryatxhe hampànà, kofehnakno komo hyaka, romryenon me oyesnàr kom ke mak ha. Àwyanye ayanàhnohrà kom horà ayaryatxhe hampànà. Àwyanye rma uro mekarymetxhe ha. Xuknewyanahnà komo wya xarha uro mekarymetxhe ha, omeroron komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Àhyakanye ayaràtxhenye, oseryehokahra rma ehtxoko. Àsoke ryhe koskarymeno, kahra rma ehtxoko, kekon hatà. Àsoke ryhe roxanhàn komo weyukyatxowà, kahra ehtxoko. Àtoko rma orwonàhyametxhe ha, oyàmkom yokato. Omnyamohnà rma, noro haxa nàrwonaha, tàwya orwonàhyamanàr kom ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Oyowtà komo rma ayahohsetxhe hampànà, axanhàn komo wya, awayehkanàr kom horà. Oyàm komo rma, ohokyam xarha, ayahohsetxhe hampànà, àwyanye awayehkanàr kom horà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Oxehranye rma haxa natxhe hampànà, toto komo, omeroro, romryenon me oyesnàr kom ke mak ha. Enàmtxok mak hampànà. Enàmtàhkanyenhàrà rma, karyhe roro harha manatxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Anaro owto hon komo wya oyeryewhamnohnàtokonye, anaro owto hona oyokahtàmtxoko, kekon xarha tà. Anaro rha owto hona àtotxoko, Ehsayewyana yowto kom hona rma. Onà wyaro yaworo xaxa àkehe, owyanye. Omeroro owto hona otohra ronye rma haka, nomokyaha harha hampànà, Toto me Enusaho, kekon hatà, Txesusu, 12 komo wya, tànànyaknyàr komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Onà wyaro nkekon xarha tà, àwyanye. Àsok hana natxow ha, thananàhsom kom ha, kekon hatà. Rohananàhnye yoho rma haxa ohxe wehxaha, uro, kahra natxow hamà. Àro wyaro rma rha natxow hamà, tanotomaxem komo xarha. Ranotomany yoho rma haxa wehxaha kahra natxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Thananàhnye komo wyaro rma rha tehtokonye, teryehorye natxow hamà, thananàhsom komo. Àro wyaro rma rha, tanotomany komo wyaro tehtokonye, teryehorye rma rha natxow hamà, tanotomaxem komo xarha, kekon hatà. Ayanotomany kom me wehxan hamà, uro. Àro ke, rowyaro oyehtokonye, teryehorye rma ehtxoko. Bewsekmu moson hamà, ketxhe rma haryhe, toto komo, rohoko, rowàràhyakanàr horà, kekon hatà. Àro ke, owàràhyaketxhe xarha, thenyehra rma haxa, ranoto me oyesnàr kom ke. Teryehorye rma ehtxoko, rowyaro rma rha oyesnàr kom ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Àro ke, oseryehpàra ehtxoko, toto kom hona, kekon xarha tà, Txesusu, 12 komo wya. Amnye rma, ekayhera rma owàràhyaketxow hana, toto komo. Àwyanye owàràhyakatxhàyamotho rma, tonytxaxem me harha mpànà naha ha, amnye ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Toto komo nenytxahtor me rma kàrwonaha, ayakoronye. Amnye rorwonà rma mekarymetxhe ha, toto komo wya, omeroron komo wya. Omnyam marma onenytxatxhàyamotho rma, mekarymetxhe ha, omeroron komo nenytxanàr me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Awayehkany kom hona oseryehpàra ehtxoko. Àsok tawro hana. Tàwyanye awayehkatxhenye, oyeryewhamnohpàrany harha natxow hamà. Karyhe roro oyehtxoho komo yowhàra ro mak natxow hamà, nyamoro ha, kekon hatà. Khoryenkom hona haxa oseryehtxoko. Wayehkano ynye me naha, noro ha. Arymano ynye me xarha naha, eryewhamnohno ytxoho ro na. Noro hona rma oseryehtxoko, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Onà wyaro nkekon xarha tà, àwyanye. Àsok hana nay ha, torono yehetho ha, kekon hatà. Ehetàhpenyehra nay hamà, torono. 2 torono txko yehetho rma, 1 kruseyru me marma nay hamà. Ehetàhpenyenohnàtho txko rma hutwehe, oyàmkomo, kekon hatà. Toronotho txko wayehrà rma hutwehe, noro ha. Noro nhutwanàr me rma wayehyaha, torono, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Àro ke, ohutwany kom me rma rha naha, noro ha. Omnyam haxa ryhe, ehetàhpenye rma haxa manatxhe, oyàmkomo wya, torono yehetho yoho rma haxa mak ha, thenyenohnà rma yehetho yoho rma haxa mak ha, kekon hatà. Ohpotx komo yakenonà hutwany me xarha naha, noro ha. Àro ke ohutwahkahpàranye nay hamà. Àro ke, oseryehpàra ehtxoko, toto kom hona, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Txesusu mryenon uro kanye ro me ehtxoko, toto komo nenytxanàr me, oseryehpàra ro mak ha, kekon xarha tà. Àro wyaro kanye ro me oyehtokonye, amnye onà wyaro àkehe xarha, uro ha, owyanye, kekon hatà. Romryenon omoro àkehe hampànà, royàm nenytxanàr me, kahe yawono rma nenytxanàr me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Àsok haxa hana màketxow ha. Txesusu mryenonàhnà uro, màketxow hana, toto komo nenytxanàr me, àhonanye oyoseryehrà kom ke mak ha, kekon hatà. Àro wyaro owyanye tatoko, amnye onà wyaro àkehe xarha, uro ha, owyanye. Romryenonàhnà omoro àkehe hampànà, royàm nenytxanàr me, kahe yawono rma nenytxanàr me, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Àsok hana màketxow ha, rohoko, kekon xarha tà, Txesusu, 12 komo wya. Onà wyaro màketxow hana. Yukryeka hona nomokye hamà, osohtahahra harha toto komo yehtxoho me, màketxow hana. Àro wyaro ehutwahra ehtxoko, rohoko, kekon hatà. Onà wyaro haxa àkehe, owyanye. Nosohtahetxhe xaxa mak hampànà, toto komo, yukryeka hona romoknàr ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Àro rye yawon komo ryhe osoxehra harha natxhe hampànà. Tàyàm komo xehra harha natxhe, umur komo, romryenon me esnàr kom ke mak ha, kekon hatà. Tàyon komo xehra harha natxhe, emsàr komo, romryenon me esnàr kom ke mak ha. Tànyo yon komo xehra harha natxhe, àhatx komo, romryenon me esnàr komo ke mak ha, kekon hatà. Àro wyaro bàn yawon komo xehra natxhe hampànà, toto komo, yukryeka hona romoknàr ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Okukur komo hnànàytxoho yoho rma haxa rox ehtxok hampànà, oyàm komo hnànàytxoho yoho rma haxa mak ha, oyon komo hnànàytxoho yoho rma haxa mak ha, ohokyamo hnànàytxoho yoho rma haxa mak ha, kekon hatà. Rohnànàytxoho yoho nyhe nyamoro xe oyehtokony haxa, romryenon mehra ro mak manatxhe ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Oyeryewhamnohtoho komo enàmtxok hampànà. Àro wyaro enàmnye rma rakoro àtotxok hampànà, romryenon me oyehtxoho menye, kekon hatà. Oyeryewhamnohtoho komo yonàmpàra oyehtokony haxa, romryenon mehra ro mak manatxhe ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Àsok hana manatxow ha. Oyekrunhonàr xe manatxow hana, awayehrà kom hona. Oyekrunhonàr xano rma, awayehyatxhe xak mak hampànà, kekon hatà. Àsok haxa hana manatxow ha. Mosoxanomkahnohyatxow haxa hana, twayehso ro, rox oyesnàr kom ke mak ha. Àro wyaro tosoxanomkahnohsomà rma, mekrunhetxhe harha. Karyhe roro harha manatxhe ha, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Onà wyaro nkekon xarha tà, Txesusu, àwyanye. Àsok hana natxow ha, oyonytxany kom ha, kekon hatà. Tàwyanye oyonytxantokonye rma, uro rma ronytxetxhe. Tàwyanye ronytxantoko rma, ronyaknyenhàrà rma yonytxetxhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Khoryenkomo rwonà yokarymany komo yonytxahra natxhe, anar komo, kekon hatà. Anar kom haxa ryhe nenytxetxhe mak ha. Khoryenkomo rwonà yokarymanye moson hamà, wenytxen hamà, ketxhe. Nyamoro rma, towakryexem me rma haxa natxhe hampànà, kekon hatà. Towakryexem me ekarymany komo yehtxoho wyaro rma rha, towakryexem me natxhe, enytxany komo. Enyhoru moson hamà, wenytxen hamà, kany komo xarha, towakryexem me natxhe hampànà. Towakryexem me enyhoru komo yehtxoho wyaro rma rha, towakryexem me natxhe, enytxany komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Àsok hana natxow ha, romryenon kom ha. Anatoko norohnàtho wyaro natxow hana, bàryekomo txko wyaro, moxamo txko wyaro, kekon hatà. Norohnàtho rma akoronomatxoko, romryenon me esnàr kom ke mak ha. Akoronomany komo rma, towakryexem me natxhe hampànà, kekon hatà. Tuna marma txko yàmyatxow hana, àwokru kom me. Tuna yàmnyenhàrà rma, towakryexem me rma haxa natxhe hampànà, tàwyanye romryenon komo yakoronomanàr ke mak ha. Àro wyaro yaworo xaxa àkehe, owyanye, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","12 komo hananàhtàkatxownà hatà, Txesusu. Tàwya àhananàhtàkatxhenye rma, toy xarha tà. Anaro rha owto hona tekon hatà, Karyeryeya yamtar hon komo yowto hona rma. Toto komo hananàhyakon hatà. Khoryenkomo rwonà yokarymekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Noro yokaytà yonytxay hatà, Xowawu, aymomno ynye rotho. Watxa ymo yaka ahryemxaho rma mok nehxakon hatà. Watxa ymo yawo rma tehtoko, Txesus yokaytà yonytxay hatà. Eryehokano ytxoho hoko rma haxa manaye, Kryestu me nay hamà katxho rma yonytxay hatà, Xowawu. Àro ke, tànhananàhrà kukur komo nyakye hatà, Txesusu hyaka. ");
INSERT INTO hixNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Onà wyaro nketxkon hatà, ànyahxemo komo, Txesusu wya. Amnye nomokyaha, Kryestu, katxhàr hona ro amna naha, kaxe amna nyaknyo, Xowawu, ketxkon hatà. Noro kat omoro ha kaxe amna nyaknyo. Anaro yomoknàr hona ro haxa katà amna naye, kaxe amna nyaknyo, Xowawu, ohyaka, ketxkon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Onà wyaro neyuhtxownà hatà, Txesusu. Àtotxok harha, kekon hatà. Àtotxok harha. Onenyetxhàyamo mekarymetxhe ha, Xowawu wya. Onenytxatxhàyamo xarha mekarymetxhe ha, àwya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Monentetxow harha, enhunutho komo, màketxhe ha, àwya. Manataryeknohyatxow harha, àhrohnàtho komo, màketxhe xarha, kekon hatà, Txesusu. Monenyhotetxow harha, hunmata ymo yawonotho komo, màketxhe xarha, àwya. Thanak harha manatxowà, àhanahnàtho komo, màketxhe xarha, kekon hatà. Manasanàmyatxow harha, àwayehsahotho komo, màketxhe xarha, àwya. Àrwo yonyhorunu yonytxany me harha manatxowà, toto komo, ewakryehnàtho komo, màketxhe xarha, Xowawu wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kryestu me nay hana, àna hana, kany me kat manatxowà, rohoko. Àro wyaro kahra oyehtokonye, towakryexem me manatxhe ha, kekon hatà, Txesusu, Xowaw nànyaketxho komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Totxownà harha tà, Xowaw nànyaketxho komo. Àtotxhenye rma, onà wyaro nkekon hatà, Txesusu, Xowaw hoko, toto komo wya, ohsamnohxemo komo wya. Ahehnaka otontokonye, toto yonyxe màtetxkon hamà, kekon hatà. Àsok hana nehxakon ha, noro ha. Omamu wyarohra mak nehxakon hamà, atxowowo newusnuru wyarohra mak ha, anar me rha tehutwaxem mehra ro mak ha. ");
INSERT INTO hixNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ehonomnà komo womun yawohra mak nehxakon hamà, kekon hatà. Àsok tawro hana. Ehonomnà komo màn yawo natxow hamà, ehonomnà komo womun yawon komo. Nyamoro wyarohra mak naha, noro. ");
INSERT INTO hixNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Àsok haxa naye, kekon hatà, Txesusu. Khoryenkomo rwonà yokarymanye ro me rma haxa nay hamà. Onà wyaro àkehe xarha, owyanye. Ekarymanye ro heno komo yoho rma haxa naha, noro ha, onenyetxhàyamo, kekon hatà, Txesusu, Xowaw hoko. ");
INSERT INTO hixNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Noro hoko rma, onà wyaro nkehe, àmenhosahonhàrà. Ranoto mosonà, kehe, Khoryenkomo. Oywaho ànyakyaha. Osonyhoryetxoko, Kohkomo yomoknàr hona, kehe hampànà, toto komo wya, kehe, Khoryenkomo. Àro wyaro rma nkehe, àmenhosahonhàrà, Xowaw hoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Onà wyaro yaworo xaxa àkehe, owyanye. Toto komo yoho rma haxa naha, Xowawu, aymomno ynye ro. Omeroro enuxemotho komo yoho rma haxa naha, kekon hatà. Norohnàtho kom haxa ryhe, Khoryenkomo mryenon me tehtokonye, Xowaw yoho rma haxa natxhe. Khoryenkomo wya, akayaryet kom me naha, ronànyaketxho, katxho me rma tehtokonye, Xowaw yoho rma haxa natxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","14","Xowaw yomokhàra ro rma haka, tokarymaxemà ro me nehxakon hamà, kàyweronàhyamatxho komo, Moyses heno nmenhotho rma, Khoryenkomo rwonà yokarymanye ro heno komo nmenhotho xarha, kekon hatà. Nomokye haxa ha, Xowawu. Noro rma, Eryeyas heno wyaro mpànà naha ha, tomohsomà, katxhàr yawo ro nehxakonà. Yaworo xaxa màken hamà, Xowaw hoko, kahra kat manatxowà, kekon hatà, Txesusu, toto komo wya. Xowaw yomokàtxhe rma, onà wyaro katxho haxa ryhe tokarymaxemà ro me nay hamà. Àsok hana akayaryet kom me nay ha, Khoryenkom ha, katxho rma, tokarymaxemà ro me nay hamà. Noro mryenon me harha tehtxahke rma haxa natxow hamà, toto komo. Akayaryet kom me naha, Khoryenkomo, katxho me harha tehtxahke rma haxa natxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Uro enytxatxoko, thanak oyehtokonye. Àhanahra kat manatxowà, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Onà wyaro nkekon xarha tà, Txesusu, toto komo wya. Àsok hana natxow ha, toto kom ha, amnyeno rma kom ha, kekon hatà. Àsok hana nay ha, ukuknon kom ha. Bàryekomo txko yewatxarykatxho ryhe, ukuknon kom me nay hamà, kekon hatà. Yakentawo newatxaryketxow hamà, bàryekomo txko komo. Tewatxarykantokonye rma, onà wyaro nketxhe, ukukur komo, anar komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Furwe amna ntxemeknyo. Àsok tawro amna yakoro àmanhohra mahtxoko, ketxhe, àwyanye, kekon hatà. Onà wyaro nketxhe xarha. Amna nehokoynyo xarha. Àsok tawro àratahra mahtxoko, ketxhe xarha, àwyanye, tewatxarykanàr kom me, kekon hatà, Txesusu. Bàryekomo wyaro natxhe, toto komo. Eyuknyehnà komo wyaro rma natxhe, amnyeno rma komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Xowawu htxero ryhe nomokye. Noro yoyukhura mak nehxatxkonà, toto komo. Natahyehnomekonà, noro ha. Asahxemtohra nehxakonà. Noro hoko rma, worokyamo yoh me naha, ketxkonà rma haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Toto me Enusah xarha nomokye. Noro ryhe nasahxemtehe. Atahyehnomahra naha. Noro yoyukhura xarha natxhe, toto komo, kekon hatà. Noro hoko rma, tasahxemtosomà roro mokro hamà, ketxhe rma haryhe. Ufa xkun yonye roro mokro hamà, ketxhe xarha. Txenyeru yahosnye ro komo yakoron xarha mokro hamà, ketxhe xarha, kekon hatà. Atxke natxhe moxamo katxho komo yakoron xarha mokro hamà, ketxhe xarha. Àro wyaro nketxhe rma haryhe, toto komo, amnyeno rma komo, Toto me Enusah hoko, kekon hatà, Txesusu. Tàywero rma haxa naha, Khoryenkomo. Tàywero tehtxoho hoye ro, anar me rha tanoto komo yeryan hamà. Tàywero oyehtokonye, tàyweron me noro menyatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Eryehokano yeryakon hatà, Txesusu, anaro rha owto hon komo nenyàr me hatà. Tahoxetà rma yonyhekon hatà, àwyanye, thenyehra rma haxa mak hatà. Atxke rma nehxatxkon hatà, nyamoro ha. Anar me harha tanhànàthàyamo yonyhera rma nehxatxkon hatà. Àro ke, anàhnohtoho komo yokarymay hatà, Txesusu. Onà wyaro nkekon hatà, àhokonye. ");
INSERT INTO hixNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Onà wyaro àkehe, Korasen hon kom hoko, Betsayda hon kom hok xarha, kekon hatà. Tanàhnohsom me rma haxa natxhe hampànà, nyamoro ha. Àsok tawro hana. Eryehokano weryaknano, ànenyàr kom me. Rahoxetà rma wenyheknano, àwyanye. Anar me harha tanhànàthàyamo yonyhera rma natxhe ha, kekon hatà. Txeru hon kom haxa ryhe, rahoxet yonyhera nehxatxoko. Seknon hon komo xarha, eryehokano ytxoho yonyhera rma rha nehxatxoko. Tàwyanye xenyetok haxa, mexehra rma haxa anar me harha tanhànàthàyamo yonyàràtho haryhe, àwyanye, sakatho ke harha ewomumtonàràtho kom haryhe, wàràmno waka xarha eryewtanàràtho kom haryhe, àro wyaro rma anar me harha tanhànàthàyamo yony me ehutwamohsonàràtho kom haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Àro ke, onà wyaro àkehe, Korasen hon kom hoko, Betsayda hon kom hoko xarha. Amnye, Khoryenkomo wya wahanonkano ytxoho ro ho haxa, atxke rma haxa natxhe hampànà, nyamoro ha. Txeru honotho komo yoho rma haxa, atxke natxhe hampànà. Seknon honotho komo yoho rma haxa, atxke natxhe hampànà, nyamoro ha, Korasen hon komo rma, Betsayda hon komo xarha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Onà wyaro àkehe, Kafahnaw hon kom hoko xarha, kekon hatà. Kahe yaka tanàmsom me nosonyatxow hamà, nyamoro ha. Tanàmsom mehra mak natxhe ha, kahe yaka. Tarymaxem me haxa ryhe natxhe hampànà, yuhnayen hona, anàhnohno ytxoho ro na, kekon hatà. Soknoma hon heno kom haxa ryhe, rahoxet yonyhera nehxatxkon hamà. Eryehokano ytxoho yonyhera rma nehxatxkon hamà. Àwyanye xenyetok haxa, atakhera ewtothàyamo yesnàràtho haryhe, esnàrà rotho haryhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Àro ke, onà wyaro àkehe, Kafahnaw hon kom hoko. Amnye, Khoryenkomo wya wahanonkano ytxoho ro ho haxa, atxke rma haxa natxhe hampànà, nyamoro ha. Soknoma hon heno komo yoho rma haxa, atxke natxhe hampànà, nyamoro ha, Kafahnaw hon komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Karyeryeya yamtar ho rma tehtoko, onà wyaro tàyàm yakoro nàrwonàmye hatà, Txesusu. Apa y, kekon hatà. Kahe yawon komo yohà ryhe omoro. Yukryeka hon komo yoh xarha omoro, kekon hatà. Romryenon komo wya mehutwamohseko. Àro ke, ohxe xaxa manaha, àkehe, owya. Tàyweron uro ha kanyehnà komo wya mehutwamohseko, uhutwatxehkanye ro uro ha kanyehnà komo wya rma, kekon hatà. Uhutwanyehnà uro kany komo wya haxa ryhe mehutwamohseko, bàryekomo txko wyaron komo wya rma, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Apa y, àwyanye rma mehutwamohseko, ayano me ro mak ha, àhokonye towahke xaxa oyesnàr ke mak ha, kekon hatà, Txesusu, tàyàmà wya. ");
INSERT INTO hixNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Thutwamohsony me ryeryeye, royàmà, kekon xarha tà, toto komo wya. Buru hutwatxehkanye ro me naha, royàmà, noro marma mak ha. Khoryenkom muru hutwahra ro mak natxhe, anar komo, kekon hatà. Royàm hutwahra xarha natxhe. Uro marma, royàm hutwatxehkanye ro me wehxaha, umuru kaxe. Noro uhutwamohsehe xarha, ronwahanonkanàr komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","30","Àsok hana manatxow ha, kekon xarha tà, toto komo wya. Tàyweronàhyamaxem me rma haxa manatxow hamà, oyosonyhoryenàr kom horà. Oyweronàhyamatxhàyamo rma, krawame rma haxa nay hamà, kekon hatà. Rowya ahananàhtoho kom haxa ryhe, krawamehra naha. Ronhananàhrà me oyehtokonye, teryehorye harha manatxhe, ohnawonye, kekon hatà. Àro ke, ronhananàhrà me harha ehtxoko. Rohyaka omohtxoko, rowya ahananàhtoho menye. Rohoko ehohkatxok xarha, kekon hatà. Uro ryhe, towahke wehxaha, ehonomnà komo wyarohra mak ha. Àro ke, rohoko ehohkatxoko. Ronhananàhrà me rma ehtxoko, teryehorye harha oyehtxoho menye, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Karyeryeya yamtar ho rma tehtoko, marataha tekon hatà, Txesusu, hokano ytxoho yawasàn ho hatà. Akoro tetxkon hatà, ànhananàhrà ro komo. Nyamoro rma, nahyehtxownà hatà. Àro ke, nasànasà hohtyatxkon hatà. Nenahyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nenytxownà hatà, Farysew kukur komo. Ha y, ketxkon hatà, Txesusu wya. Àsok natxow haryhe, onhananàhrà ro komo. Kàyweronàhyamatxho kom yawo rohra natxow hamà. Hokano ytxoho yawasàn ho thothoryehra naha, kàwyanye, ketxkon hatà, Farysew komo. ");
INSERT INTO hixNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Khoryenkomo karyehtan hutwahra kat manatxowà, Dafe heno kom hoko, kekon hatà. Nyamoro heno xarha, tahyehnàtokonye, kàyweronàhyamatxho kom yawo rohra rma rha nehxatxkon hatà. Nahyehyatxkonà rma haxa mak hatà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Àro ke, Khoryenkom màn yaka nowomye hatà, Dafe heno. Ekeyu yonahye hatà. Àsoken hana mon nehxakon ha, ekeyu, kekon hatà. Khoryenkomo yompataka txexahonhàràtho rma mon nehxakon hatà. Kàyweronàhyamatxho kom yawo ro àro yonahyatxkon hatà, Khoryenkom màn yonye ro kom marma mak hatà. Anar komo nenahpàtorà ro mak hatà àro ha, kekon hatà. Dafe heno komo xarha nenahpàtor me nehxakon hatà. Nyamoro heno rma nenahtxownà hatà, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Onà wyaro nkekon xarha tà, àwyanye. Moyses heno nmenhotho xarha hutwahra kat manatxowà, Khoryenkom màn yonye ro heno kom hoko, kekon hatà. Hokano ytxoho yawasàn ho xarha, tomyawon kom hoko rma rha nehxatxkon hatà, nyamoro heno, Khoryenkom màn hoko rma. Àsok tawro hana. Hokano ytxoho yawasàn ho oyomyawon kom hokohra ehtxoko katxhàrànhàr yawo rohra nehxatxkon hamà, nyamoro heno. Atxke natxhe, moxamo, kahra mak nehxakon hatà, Khoryenkomo, àhokonye, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","8","Hokano ytxoho yawasàn yoho rma haxa nehxakon hamà, Khoryenkom mànà, kekon xarha tà, àwyanye. Onà wyaro àkehe, owyanye. Uro haxa ryhe, awawon komo rma, Khoryenkom màn yoho rma haxa wehxaha. Hokano ytxoho yawasàn yoh me xarha wehxaha, Toto me Enusah kaxe, kekon hatà. Àro ke, atxke natxhe kahra ehtxoko, moxam hoko, atxke natxhe katxho mehra esnàr kom ke. Khoryenkomo karyehtan hoyen hutwahra manatxow hamà. Onà wyaro rma nkehe, àmenhosahonhàrà. Toto komo hnàn yawo oyesnàr komo xe wehxaha. Àhnàn kom yawohra rma oyehtokonye, rowakryenàr xehra mak wehxaha, owyanye. Owoknàthàyamo yàmrà xehra rma wehxaha, owyanye, toto komo hnàn yawohra oyesnàr kom ke. Àro wyaro rma nkehe, àmenhosahonhàrà, Khoryenkom karyehtan hoyeno rma, kekon hatà. Àro wyaro katxhàrànhàrà hutwahra manatxow hamà. Owyanye uhutwantok haxa, atxke natxhe moxamo kahra oyesnàràtho kom haryhe, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tàwya Farysew komo hananàhàtxhe rma, toy hatà, Txesusu. Ohsamnohno ytxoho ro yaka nowomye hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Àto nehxakon hatà, toto. Amoskurumentaxaho rma mok nehxakon hatà. Àto nehxatxkon xarha tà, Farysew kukur komo. Onà wyaro tawro xe rma nehxatxkon haryhe mà, Txesusu wya. Atxke manaha, kàyweronàhyamatxho kom yawo rohra oyesnàr ke, tawro xe nehxatxkon hamà, àwya. Àro ke, onà wyaro nketxkon hatà, àwya. On ho tonyhoryehorye natxowà, ekeh komo, tonyhoryehoryehra kat natxowà, hokano ytxoho yawasàn ho, ketxkon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Àsok hana manatxow ha, hokano ytxoho yawasàn ho, kekon hatà. Ewtarà ymo yaka owoknà komo yehurkatxhe, anàmpàra kat manatxowà. Àna matà, hokano ytxoho yawasàn ho rma manàmyatxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Okno yehetho yoho rma haxa ehetàhpenye nay hamà, toto. Àro ke, tonyhoryehorye natxow hamà, ekeh komo, hokano ytxoho yawasàn ho xarha, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Onà wyaro nkekon xarha tà, amoskurumentaxaho wya. Atahoyotkako, kekon hatà, àwya. Natahoyotkay hatà. Ohxe harha nehxakon hatà, amorà. Àrakayo wyaro rma rha ohxe harha nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nahatakatxownà mak hatà, Farysew komo. Nosonytxetxkon hatà, nyamoro rye rma, Txesus hoko. Àsoke ryhe noro twayehketxowà, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Osonytxatxho komo rma hutwekon hatà, Txesusu. Àro ke, àsnye ro toy hatà. Akoro tetxkon hatà, toto komo, thenyehra rma haxa mak hatà. Omeroro ekehàtho komo yonyhoryetxownà hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Rokarymahra xaxa mpànà ehtxok ha, toto komo wya, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Àro wyaro nkekon hatà, Esaeyas heno nmenhotho yawo ro tehtxoho me. Onà wyaro nmenhoy hatà, noro heno, Khoryenkomo rwonà yokarymanye ro heno, amnyehra. ");
INSERT INTO hixNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ranoto ryhe noro ha, ronwahanonkatxho rma, ronàhnàn xaxa rma. Noro hoko rma, teryehorye rma haxa wehxaha, rohnawo. Àhyawo rye mpànà naha ha, rokato. Onà wyaro nkehe hampànà, noro ha, Xuknewyanahnà komo wya. Oyonyhoryeny kom me naha, Khoryenkomo, kehe hampànà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ewakàhkahpàra mpànà naha ha, noro ha, toto kom hoko. Àkowontahra mpànà naha ha. Eryewhura rma mpànà nàrwonaha ha. ");
INSERT INTO hixNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ahoxemnàtho komo yakoronomehe hampànà. Ewakryehnàtho komo yowakryehe hampànà. Àro wyaro ohxe toto komo yeryaha hampànà. Amnye haxa onyhoryetxehkano yeryaha hampànà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Noro hona ro rma natxhe hampànà, Xuknewyanahnà komo. Àro wyaro rma nmenhoy hatà, Esaeyas heno. Ànmenhothàrànhàrà yawo ro rma haxa nehxakon hamà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Toto yohtxownà hatà, toto komo, Txesusu hyaka. Worokyamo yano me enhunu ro me nehxakon hatà. Àrwomnà ro me xarha nehxakon hatà, worokyamo yano me rma rha hatà. Noro hyaye worokyamo yowye hatà, Txesusu. Nenyhoryey hatà. Nàrwonàmye harha tà, toto. Tonke harha nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Noseryehoketxkon hatà, toto komo. Dafe heno yohamàtho me naye, ketxkon hatà, Txesus hoko. ");
INSERT INTO hixNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tàwyanye enytxatxhe rma, onà wyaro haxa nketxkon hatà, Farysew komo. Bewsekmu yano me xaxa we nowyaha ha, mokro, ketxkon hatà. Worokyamo yohà ymo yano me towsom me nay hamà, worokyamo, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Atxke ehutwatxho komo hutwekon mak hatà, Txesusu. Àro ke, onà wyaro nkekon hatà, àwyanye. Àsok hana natxow ha, owto hon kom ha, kekon hatà. Tosoyxemà ro me tehtokonye, natanàhnohyatxow hamà, owto hon heno komo. Àsok hana natxow ha, àro rye yawon komo xarha, kekon hatà. Tosoyxemà ro me tehtokonye, natakhahyatxow hamà, àro rye yawonotho komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Àro wyaro rma rha, tosoyxemà ro me tehtokonye, Satanasà ymo heno komo yatanàhnohràtho haryhe mà. Noro ymo yano me worokyamo yownye me ryehtoko, amna yosoynyàràtho haryhe mà, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Okukur komo xarha, worokyamo yowyatxow hatà, kekon xarha tà. Àsok tawro hana. Bewsekmu yano me amna nowyaha kahra natxow hamà, nyamoro ha. Àro ke, Bewsekmu yano me towsom me nay hamà, worokyamo, tatoko rma owyanye, yaworohra mak màketxhe ha, ketxow hamà, okukur komo rma, owyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Khoryenkom yokato yano me haxa ryhe, worokyamo yowrà hoko wehxaha. Noro yano me townye me ryehtoko, onà wyaro kany me rma nay hamà, Khoryenkomo, owyanye. Akayaryet kom me naha, mosonà, ronànyaketxho, kany me rma nay hamà, owyanye, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tahoxerye ymo toto yehtoko, noro katxhotho yarhàra nay hamà, anaro, kekon xarha tà, àwyanye. Bàn yawo rma noro ymo yehtoko, krawame rma haxa nowomyan hamà, àkatxhothàrà yanàr horà. Tàwya noro ymo yahomometxhe haxa ryhe, àkatxhothàrà yaryan hamà, tkatxho me harha. Àro wyaro rma rha, rowya worokyamo yownàtoko, Satanas komo warymen hamà, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Àsok hana manatxow ha, kekon xarha tà. Rakoro àtohra oyehtokonye, roxanhàn me rma manatxow hamà. Rohyaka toto komo yokhàra oyehtokonye, rohyaye maryatxow hamà, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Àro ke, onà wyaro àkehe, owyanye, kekon xarha tà. Toseryewhokaxem me naha, Khoryenkomo, ayanhànàthàyam hoko, omeroron hoko rma. Owyanye twàràhyakatxhe rma, noseryewhokehe, ohokonye. Owyanye tokato wàràhyakatxhe haxa ryhe, oseryewhokahra ro mak naha ha, Khoryenkomo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Toto me Enusah hoko atxke orwonàmàtxhenye, noseryewhokehe rma, ohokonye. Tokato hok haxa ryhe atxke orwonàmàtxhenye, oseryewhokahra ro mak naha ha, Khoryenkomo, kekon hatà. Tano roro rma hak oyehtokonye, oseryewhokahra roro rma naha. Awayhàtxheny xarha, oseryewhokahra roro rma rha naha, ohokonye, tokato hoko atxke orwonàmrà kom ke, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Àsok hana nay ha, nat ha, kekon xarha tà. Ohxe tehtoko, ohxe neheten hamà. Atxke tehtoko, atxke neheten hamà. Eherà ryhe, nat hutwamohsehe, ohxe hana, ohxehra haxa hana, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Àro wyaro rma rha, atxke orwonatxhe, omnyamo, rohoko, ohnawonye atxke oyesnàr kom ke. Okoye wyaro atxke manatxhe. Àro ke ohxe àrwomra ro mak manatxhe ha, kekon hatà. Àsok tawro hana. Kàhnawonye ohxe kehtokonye, ohxe tàrwonatxow hamà, toto kom hoko. Kàhnawonye atxke haxa kehtokonye, atxke tàrwonatxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Enyhoru me kehtoko, enyhoru hokono ro me tehxan hamà, kàhnawo ohxe rma haxa kesnàr ke. Anhà me haxa kehtoko, anhà hokono ro me tehxan hamà, kàhnawo atxke rma haxa kesnàr ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Onà wyaro àkehe, owyanye, kekon hatà. Amnye, Khoryenkomo wya wahanonkano ytxoho ro ho haxa, noskarymetxhe hampànà, toto komo, omeroro. Àsok make tàrwonàmàthàyamotho rma yokarymetxhe hampànà, Khoryenkomo wya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Atxke tàrwonàmàthàyamotho hoye ro, atxke manatxhe hampànà katxho me roro rma natxhe hampànà, Khoryenkomo wya. Ohxe tàrwonàmàthàyam hoye ro, ohxe manatxhe katxho me roro rma natxhe, toto komo, Khoryenkomo wya, wahanonkano ytxoho ro ho haxa, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Onà wyaro nketxkon hatà, àyweronàhyamano ynye ro kukur komo, Farysew kukur komo xarha, Txesusu wya. Khananàhnye y, kahe yawon yakoxetà xenyhoko, amna wya, yaworo xaxa manay hamà katxho me, amna wya, ketxkonà rma haryhe tà. Eryehokano ynyàr xe amna naha, owya, ketxkonà rma haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Àsok hana manatxow ha, omnyam ha, amnyeno rma komo, kekon hatà. Atxke rma haxa manatxow hamà. Thetxenhàrà hyaye toto yotowrà wyaro, Khoryenkomo hyaye otowsah me manatxow hamà. Àro ke, kahe yawon yahoxetà xenyhoko, amna wya, màketxhe rma haryhe, rowya, kekon hatà. Noro yahoxetà yonyhohra mak wehxaha, owyanye. Xonas heno hutwahkahpàra ehtxoko. Khoryenkomo rwonà yokarymanye ro heno rma hutwahkahpàra ehtxoko, kekon hatà. Noro heno hoko rma tahoxetà yonyhoy hatà, Khoryenkomo, Enenefe hon heno komo wya. Àro wyaro rma rha, Toto me Enusah hoko xarha tahoxetà yonyhehe hampànà, owyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Àsok hana nehxakon ha, Xonas heno ha. Kana ymo yowan yawo nehxakon hatà. Kana ymo yowan yawo rma 3 me nenmahye hatà. Noro rma yanàmye hatà, Khoryenkomo, kekon hatà. Àro wyaro rma rha, yukryeka waka enamsaho, 3 me nenmahyaha hampànà, Toto me Enusaho, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Khoryenkomo wya tanàmàtxhe rma, nekarymekon hatà, Xonas heno, Enenefe hon heno komo wya. Nyamoro heno rma, tàwyanye enytxatxhe rma, anar me harha tanhànàthàyamo yonytxownà hatà, kekon hatà. Nyamoro heno wyarohra mak manatxhe, omnyamo, amnyeno rma komo. Awawonye rma naha, ehonomnà xaxa. Xonas heno yoho rma haxa ehonomnà me naha. Noro yonytxahra mak manatxhe, omnyamo, kekon hatà. Àro ke, amnye, Khoryenkomo wya wahanonkano ytxoho ro ho haxa, atxke rma haxa manatxhe hampànà. Àro rma ho, Enenefe hon heno komo menyatxhe hampànà. Onà wyaro nketxhe hampànà, nyamoro ha, owyanye, kekon hatà. Atxke rma haxa mehxatxkon hamà, amna wyarohra oyesnàr kom ke, ehonomnà xaxa yonytxahra oyesnàr kom ke, ketxhe hampànà, Enenefe hon heno komo, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Àsok hana nehxakon ha, Saromaw heno ha, kekon xarha tà. Tàywero rma haxa nehxakon hatà, noro heno, anar komo yoho rma haxa mak hatà. Àro ke, noro yonytxaxe nomokye hatà, wosà, notxwakomo. Sur yaworon heno komo notxwanà rma noro hatà. Nyamoro yowto rma, moxe rma haxa nehxakon hatà. Àsnye ro moxe rma haxa nomokye hatà, ànotxwan heno komo, Saromaw heno yonytxaxe mak hatà. Àsok hana manatxow ha, omnyamo, amnyeno rma komo, kekon hatà, Txesusu. Awawonye rma naha, ehonomnà xaxa. Saromaw heno yoho rma haxa ehonomnà me naha, noro ha. Noro yonytxahra mak manatxhe, omnyamo. Àro ke, amnye, Khoryenkomo wya wahanonkano ytxoho ro ho haxa, atxke rma haxa manatxhe hampànà. Àro rma ho, Sur yaworon heno komo notxwanà menyatxhe hampànà. Onà wyaro nkehe hampànà, noro ha, owyanye. Atxke rma haxa mehxatxkon hamà, rowyarohra oyesnàr kom ke, ehonomnà xaxa yonytxahra oyesnàr kom ke, kehe hampànà, Sur yaworon heno komo notxwanà, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Àsok hana nay ha, worokyamo ha, kekon xarha tà, Txesusu. Toto hyaye totowàtxhe rma, ahehnaha ten hamà. Tosarà yohoryan hamà. Xenyhera ro mak naha, àto. ");
INSERT INTO hixNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Àro ke, onà wyaro nken hamà. Toto hyaka harha àten hamà, romànàtho yaka harha, kehe, worokyamo, toto hyaye otowsahotho, kekon hatà. Àro ke nomokyaha harha, toto hyaka harha. Toto yowanà yonyaha. Bànàthàrà rma yonyaha. Yarhàra rma nenyaha. Enyhoryexaho rma yonyaha. Àro yawono, ehxera rma naha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Àro wyaro tàwya xenyetxhe, tkukur komo yanyekyaha, worokyamo. 7 me nanyekyatxhe. Noro ymo yoho rma haxa, atxke natxhe, nyamoro ha, ànanyeketxhàyamo, kekon hatà. Toto yowan yaka nowomyatxhe, nyamoro ha, omeroro, àto roro tehtxoho menye. Àsok hana nay ha, tototho. Atxke rma haxa nay hamà, kekon hatà. Amnyehra htxero atxke nehxakon hakahpa, towenyxa esnàr ke. Àro wyaro atxke texetxhàràtho yoho rma haxa, atxke nehtxekehe haxa ha, norotho, yake rma haxa esnàr ke, kekon hatà. Àro wyaro rma rha atxke manatxhe hampànà, omnyamo, amnyeno rma komo. Amnyehra atxke oyexetxhàyamotho yoho rma haxa, atxke manatxhe haxa ha, royukhura oyesnàr kom ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Àro wyaro toto kom yakoro Txesusu rwonàmnàtoko rma, nomohtxownà hatà, àyon komo, ewtà komo yakoro. Màmyaye rma horohtxownà hatà. Txesus yakoro amna rwonàmrà xe amna naha, ketxkon hatà, àton komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Àton kukur komo nekarymay hatà, Txesusu wya. Màmyaye manatxowà, oyon komo, oyowtà komo yakoro, kekon hatà. Tàrwonàmrà komo xe natxow hatà, ayakoro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Onà wyaro haxa neyukye hatà, Txesusu. Àsoken kom hana, royon me natxow ha, kekon hatà. Àsoken kom hana, rowtà me natxow ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Natahoyotkay hatà, tànhananàhrà ro kom wetxe. Moxamo ryhe, royon me natxhe. Rowtà me natxhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Àsok tawro hana. Royàm yoyuknye ro komo rma, rowtà me natxow hamà, kekon hatà. Kahe yawon yoyuknye komo rma, rowosàn me natxow hamà. Royon me natxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Taa. Àro rma ho bàn yaye toy hatà, Txesusu. Ukuthonà ymo yohokoso toy hatà. Àto rma neryewtay hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Àhyaka nohsamnohtàkatxownà hatà, toto komo. Thenyehra rma haxa nehxatxkon hatà. Àro ke nosonkahye hatà, Txesusu, kanawa yaka. Eryewtaxaho rma nhananàhyatxkon hatà. Tuna ymo yohoye rma nehxatxkon hatà, toto komo, omeroron komo. ");
INSERT INTO hixNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kuknonano me rma hananàhyatxkon hatà, thenyehra hatà. Onà wyaro htxero nkekon hatà, àwyanye. Nat yonamso toy hatà, toto, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Onà wyaro nexey hatà, natàtho. Tonamsom hoye nothahye hatà, asama yaka. Àrotho yonahtxownà hatà, torono heno, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Àhoye rma nothahye xarha tà, toh hona, yukryeka ahtumnu waka. Nahtaye rma haryhe tà, àrotho. ");
INSERT INTO hixNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Àro ke, kamàmà yasawnukutxhe, naknay hatà. Nuskurumentay hatà, àmxahra tesnàr ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Àhoye rma nothahye xarha tà, ewekhàr waka. Àto rye rma horymamtxownà hatà, ewekhàr yakoro. Natàtho yompoymay hatà, ewekhàrà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Àhoyeno rma, tonamsom me haxa nexey hatà, yukryeka taxeronokem waka. Àro rma, thenyehra nehetay hatà. Anar komo, 100 me nehetay hatà. Anar komo xarha, 60 me nehetay hatà. Anar komo xarha, 30 me nehetay hatà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Uro enytxatxoko, thanak oyehtokonye. Àhanahra kat manatxowà, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Amnye, Txesusu hyaka haxa nomohtxownà hatà, ànhananàhrà ro komo. Onà wyaro nketxkon hatà, àwya. Àsok tawro kuknonano me orwonano, toto komo hananàhrà me, ketxkon hatà, àwya. Àsok tawro kuknonano me orwonano, ketxkon hatà, ànhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Onà wyaro neyuhtxownà hatà, Txesusu. Àsok hana toto komo kayaryet me nay ha, Khoryenkom ha, kekon hatà. Àkayaryet kom me tehtxoho hutwamohsohra rma hak naha, noro, toto komo wya. Owyany haxa ryhe uhutwamohsehe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Àsok tawro hana. Ohxe enytxanyenhàyamo wya ryhe, tàrwonà yonytxamohsehe rye rma haxa, Khoryenkomo. Nyamoro rma, thenyehra rma haxa nenytxetxow hamà, kekon hatà. Enytxanyehnàtho komo wya haxa ryhe, enytxamohsohra harha mpànà naha ha, Khoryenkomo. Uhutwehe kanyenhàràtho rma, hutwahkahyatxhe harha hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Àro ke, kuknonano me kàrwonaha, rowya àhananàhrà kom me. Àsok tawro hana. Khoryenkomo yahoxetà yonyatxhe rma haryhe. Noro ywenyeke rma natxow hamà, kekon hatà. Rorwonà yonytxetxhe rma haryhe. Enytxahra mak natxow hamà. Uhutwahra rma natxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nyamoro rma, Esaeyas heno nmenhotho yawo ro rma haxa natxow hamà. Onà wyaro nmenhoy hatà, noro heno, Khoryenkomo rwonà yokarymanye ro heno, amnyehra. Rorwonà menytxetxhe roro mak haryhe. Uhutwahra rma manatxhe ha. Rahoxetà menyatxhe roro mak haryhe. Roywenyeke rma manatxhe ha. ");
INSERT INTO hixNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Àsok tawro hana. Akàhpàra natxow hamà, romryenon komo, tàhnawonye, tàwyanye royuknur hona. Nehanahuryatxow hamà, tàwyanye rorwonà yonytxanàr hona. Nosompatanyohomtetxow hamà, tàwyanye rahoxetà yonyàr hona. Rohona xenyhera natxow hamà. Rowya tonyhoryenàr komo xehra natxow hamà. Àro wyaro rma nmenhoy hatà, Esaeyas heno, kekon hatà, Txesusu. Ànmenhothàrànhàr yawo ro rma haxa natxow hamà, toto komo, amnyeno rma komo. ");
INSERT INTO hixNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Omnyam haxa ryhe, towakryexem me rma manatxow hamà, rahoxetà yony me oyesnàr komo ke, rorwonà yonytxany me xarha oyesnàr komo ke, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Onà wyaro yaworo xaxa àkehe, owyanye. Amnyehran heno komo yoho rma haxa towakryexem me manatxow hamà, kekon hatà. Àsok tawro hana. Onenyàr komo yonyhera nehxatxkon hamà, nyamoro heno. Xenyàr xe rma nehxatxkon haryhe, nyamoro heno, Khoryenkomo rwonà yokarymanye ro heno komo rma, enyhoru heno komo xarha, kekon hatà. Onenytxanàr komo yonytxanàr xe xarha nehxatxkonà rma haryhe. Enytxahra mak nehxatxkon hamà, nyamoro heno, omokhàra rma hak ryesnàr ke hamà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Onà wyaro nkekon xarha tà, Txesusu, tànhananàhrà ro komo wya. Kuknonano uhutwamohsehe, owyanye, kekon hatà. Nat yonamso toy hatà, toto, katxho rma uhutwamohsehe, owyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Natà ryhe, Khoryenkomo rwonà kuknon me naha. Àsok hana akayaryet kom me nay ha, Khoryenkom ha, katxho kuknon me rma naha, kekon hatà. Asama yaka othahsahotho ryhe, Khoryenkomo rwonà yonytxanyenhàyamo kuknon me naha. Àwyanye enytxatxhe rma, nomokyaha, anhà ymo. Ewan yakanye enamsahotho yaryaha, noro ymo ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Toh hona othahsahotho ryhe, anar komo kuknon me naha. Khoryenkomo rwonà yonytxetxhe rma haryhe, nyamoro ha. Tàwyanye enytxatxhe rma, teryehorye nahohsatxhe rma haryhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ewan yakanye enamsahotho rma, àmxahnà wyaro mak naha. Mexehra mak nahohsatxhe ha. Mexehra texetxhenye, toseryehokaxem me harha natxhe, kekon hatà. Teryewhamnohsom me rma natxhe, tàwyanye Khoryenkomo rwonà yonytxanàr ke mak ha. Àro wyaro toseryehokatxhenye rma, nàhnànketxhe harha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ewekhàr waka othahsahotho ryhe, anar komo kuknon me naha. Khoryenkomo rwonà yonytxetxhe rma haryhe, nyamoro xarha. Amnye, tomyawon kom hoko roro mak natxhe ha, kekon hatà. Tkatxhonke rma haxa tesnàr komo xe natxhe xarha. Àro hoye ro, Khoryenkomo rwonà hutwahkahtàketxhe xak hampànà. Ehetahra mak natxhe ha. Ohxe roro natxhe katxho mehra ro mak natxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yukryeka taxeronokem waka enamsahotho ryhe, anar komo kuknon me naha. Khoryenkomo rwonà yonytxetxhe, nyamoro ha, kekon hatà. Tàwyanye enytxatxhe rma, ohxe hutwetxhe. Uhutwahkahpàra mak natxhe. Àro ke, tehetaxemà wyaro ohxe roro natxhe, kekon hatà. Ukukur komo rma, 100 me tehetaxemà wyaro ohxe roro natxhe. Ukukur komo xarha, 60 me tehetaxemà wyaro ohxe rma rha natxhe. Ukukur komo xarha, 30 me tehetaxemà wyaro ohxe rma rha natxhe, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Anaro kuknonano me nekarymay xarha tà, Txesusu, toto komo wya. Àsok hana akayaryet kom me nay ha, Khoryenkom ha, kekon hatà. Àsok hana wekarymen ha, owyanye. Kuknonano me wekarymen hamà. Onà wyaro nay hamà, kekon hatà. Nat enyhoru yonamye hatà, toto, tànatàr me. ");
INSERT INTO hixNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kohsaya nomokye hatà, noro xanhànà ymo. Anhà haxa yonamye hatà, noro natàr wawo, enyhoru wawo rma, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Àto rye rma nahtay hatà, anhà, enyhoru yakoro. Àro ke, enyhoru yehetantoko, àto rma rha nehxakon hatà, anhà xarha, ehetahnà rma, txufu wyarono, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Totxownà hatà, tànatkemà yanoto komo, àhyaka. Amna yohà y, ketxkon hatà, àwya. Enyhoruhnu kat menamyako. Àsok tawro atxke harha naye, ketxetxe keny harha, ketxkon hatà, anoto komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Àna mak hana, kekon hatà, tànatkemà. Àro wyaro neryak hamà, roxanhànà ymo, kekon hatà. Anhàtho wakanàr xehra manaye, amna wya, ketxkon hatà, anoto komo. ");
INSERT INTO hixNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Àna matà, àwakahra rma hak ehtxoko, kekon hatà, tànatkemà. Owyanye anhàtho wakantok haxa, enyhorutho xarha màwaketxow hamà. Àro ke, àwakahra rma hak ehtxoko, kekon hatà, tànatkemà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Àto rye rma hak horymamtxowà, anhà, enyhoru yakoro, kekon hatà, noro. Horymamtxowà rma haka, tehetatàhkaxe ro. Ehetatàhkatxhe rma, onà wyaro àken hamà, àhotnye komo wya, kekon hatà. Wahoro htxero anhàtho ehamnohtxoko, owyanye aknyohrà horà, àken hamà, àwyanye. Enyhoru xarha ehamnohtxoko, nyah màn yaka, àken hamà, àwyanye, kekon hatà, tànatkemà, tanoto komo wya, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Anaro kuknonano me nekarymay xarha tà, Txesusu, toto komo wya. Àsok hana akayaryet kom me nay ha, Khoryenkom ha, kekon hatà. Àsok hana wekarymen ha. Kuknonano me wekarymen hamà. Nat horymamtoho wyaro nay hamà, kekon hatà. Natà txko tenamyatxow hamà, mostakna nathàrà txko rma. ");
INSERT INTO hixNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Anaro nathàr komo yosnaka rma haxa nay hamà, kekon hatà. Esnakanotho txko rma, thorymamàtxhe, ehànhenye ymo rma haxa mak naha ha, anar komo yoho rma haxa mak ha. Nasakmatahtehe, thenyehra, kekon hatà. Amnye akmatar hona nemàmtetxow hamà, torono komo. Àro wyaro rma rha nehamyatxhe ha, Khoryenkomo mryenon komo. Yakenohnàtho komo rma nehamyatxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Anaro kuknonano me nekarymay xarha tà. Àsok hana akayaryet kom me nay ha, Khoryenkom ha, kekon hatà. Àsok hana wekarymen ha. Kuknonano me xarha wekarymen hamà. Wosà wya katamaru wakanomanàrà wyaro nay hamà, kekon hatà. Yukwarà yeryan hamà, katamaru waka. 3 waka hana neryan ha. Àro wawo tehtoko, osonyhera harha nay hamà, yukwarà. Osonyhenà rma hoye ro twakanonke rye nay hamà, katamaru, omeroro, kekon hatà. Àro wyaro rma rha, tonyhoryetxehkaxem me natxhe, Khoryenkomo mryenon komo. Osonyhen hoye ro rma tonyhoryetxehkaxemà rye me natxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Àro wyaro anaro rha kuknonano me nekarymekon hatà, toto komo wya, ohsamnohxemo komo wya. Kuknonano mehra ekarymahra ro mak nehxakon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Àro wyaro tàwya ekarymantoko rma, Khoryenkomo rwonà yokarymanye ro heno nmenhotho yawo ro nehxakon hamà. Onà wyaro nmenhoy hatà, noro heno, amnyehra. Kuknonano me kàrwonaha hampànà. Enytxahnà rotho rma wekarymehe hampànà, toto komo wya. Rowya toto yakàhtotxhe rma, enytxamohsohra roro rma wehxakonà, àwyanye. Àro rma wekarymehe hampànà. Àro wyaro rma nmenhoy hatà, Khoryenkomo rwonà yokarymanye ro heno. Ànmenhothàrànhàr yawo ro rma haxa nehxakon hamà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Taa. Toto komo hyaye toy hatà, Txesusu, ohsamnohxemo komo hyaye rma hatà. Bàn yaka harha toy hatà. Àhyaka nomohtxownà hatà, ànhananàhrà ro komo. Onà wyaro nketxkon hatà, àwya. Kuknonano me onekarymatxhàrà uhutwamohsoko, amna wya, ketxkon hatà. Anhà yonamtoho rma uhutwamohsoko, amna wya, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Onà wyaro neyuhtxownà hatà, Txesusu. Nat enyhoru yonamnye ryhe, Toto me Enusaho kuknon me naha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Noro natàrà ryhe, yukryeka hon komo kuknon me naha. Nat enyhoru ryhe, Khoryenkomo mryenon komo kuknon me naha. Nat anhà ryhe, anhà ymo mryenon komo kuknon me naha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tànatkemà xanhànà ymo ryhe, worokyamo yohà ymo kuknon me naha. Anhà ymo rma kuknon me naha. Ehetatàhkatxhe rma katxho ryhe, wahanonkano ytxoho ro ho haxa katxho kuknon me naha, kekon hatà. Àhotnye komo ryhe, kahe yawon komo kuknon me natxhe. Khoryenkom yanoto komo rma kuknon me natxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","41","Anhàtho yohamnohtxownà hatà, àhotnye komo, tàwyanye aknyohtoho me. Àro wyaro rma rha, anhàtho komo yohamnohyatxhe hampànà, kahe yawon komo. Wahanonkano ytxoho ro ho haxa, tanoto komo rma nyakyaha hampànà, Toto me Enusaho, kekon hatà. Khoryenkomo mryenon kom waye anhà yaryatxhe hampànà, nyamoro ha. Omeroro rma naryatxhe hampànà. Atxke ehxemotho komo xarha yaryatxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Eryewhamnohno ytxoho ro na narymetxhe hampànà, weheto ymo wyaron hona rma. Àton heno komo rma nàratetxhe hxak hampànà, teryewhamnohrà kom ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Àro wyaro wahanonkano yeryetxhe rma, tàyàm komo yowto ho natxhe hampànà, Khoryenkomo mryenon komo. Noro nenyhoryetxho komo rma nyamoro ha. Ohxe tonyxemà ro me natxhe hampànà. Àsok hana ohxe tonyxem me nay ha, kamàm ha, kekon hatà. Kawasmeny komo rma, ohxe tonyxem me nay hamà. Àro wyaro rma rha, ohxe tonyxemà ro me natxhe hampànà, Khoryenkomo mryenon komo, kekon hatà. Uro enytxatxoko, thanak oyehtokonye. Àhanahra kat manatxowà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Anaro kuknonano me nekarymay xarha tà, Txesusu. Àsok hana akayaryet kom me nay ha, Khoryenkom ha, kekon hatà. Kuknonano me xarha wekarymen hamà. Onà wyaro nay hamà. Katxhonano ehetàhpenyeno yonyey hatà, toto, kekon hatà. Anar komo yowto ho enamsaho nehxakon hatà. Àro ke, tàwya xenyetxhe rma, nenamye harha tà, anar komo wya xenyàr hona. Ewtothàyamo yehekatnàr xe nehxakon hatà. Àro ke, tkatxhothàrà yàmtàhkay hatà, omeroro, txenyeru hona. Txenyeru rma yàmtàhkay hatà, omeroro, ewtothàyamo yehetho me, kekon hatà. Teryehorye rma haxa nehxakon hatà, tkatxho me harha esnàr ke. Àro wyaro rma rha, omeroro màhnànkatxehketxow hamà, Khoryenkomo mryenon me oyehtxoho menye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Àro wyaro rma rha, tohu txko ehetàhpenyeno yehekahtyakon hatà, toto, anaro. Nehoryakonà rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Enyhoru haxa yonyey hatà, kekon hatà. Àro ryhe, anaro tohu txko yoho rma haxa ehetàhpenye nehxakon hatà, kekon hatà. Àro ke, tkatxhothàrà yàmtàhkay hatà, omeroro, txenyeru hona. Txenyeru rma yàmtàhkay hatà, omeroro, tohu txko yehetho me. Àro wyaro rma rha, omeroro màhnànkatxehketxow hamà, Khoryenkomo mryenon me oyehtxoho menye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Àsok hana akayaryet kom me nay ha, Khoryenkom ha, kekon xarha tà. Kuknonano me xarha wekarymen hamà. Onà wyaro nay hamà. Tàtxarukan komo yarymetxow hamà, toto komo, tuna kwaka, kekon hatà. Àro wyaro kana yaramyatxow hamà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Thenyehra kana heno yehtoko, txaruka hpexekyatxow hamà, mahona. Teryewtatxhenye rma, kana wahanonketxow hamà, kekon hatà. Enyhoru komo yonkahyatxow hamà, en yaka. Anhàtho kom haxa yarymetxow hamà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Àro wyaro rma rha natxhe hampànà, toto komo. Wahanonkano ytxoho ro ho haxa, nomokyatxhe hampànà, kahe yawon komo, Khoryenkom yanoto komo. Nyamoro rma, Khoryenkomo nenyhoryetxho komo wahanonketxhe hampànà, Khoryenkom yowto hon me ehtxoho menye. Atxke ehxemotho komo xarha wahanonketxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nyamoro heno rma yarymetxhe hampànà, eryewhamnohno ytxoho ro na, weheto ymo wyaron hona. Àton heno komo rma nàratetxhe hxak hampànà, teryewhamnohrà kom ke, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Àro wyaro katxho komo muhutwatxowà. Uhutwahra kat mahtxoko, kekon xarha tà, àwyanye. Àhà, amna nhutwano, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Toto komo kayaryet me Khoryenkom yehtxoho muhutwatxow hamà, kekon hatà, Txesusu, àwyanye. Uhutwany me harha manatxow hamà, ronhananàhàtho me oyesnàr kom ke. Àro ke, horykomo wyaro manatxow hamà. Tkatxho hoye nàmyan hamà, noro, bàn yawon komo wya, kekon hatà. Anatoko xenyhenà rotho yàmyan hamà, àwyanye. Anatoko xenyxahotho rma yàmyaha xarha, àwyanye, kekon hatà. Àro wyaro tkatxho hoye nàmyan hamà, bàn yawon komo wya. Àro wyaro rma rha toto komo màhananàhyatxow hamà, kekon hatà. Anatoko ànenytxahtorà rotho komo mekarymetxow hamà, àwyanye. Anatoko ànenytxatxhàyamo rma mekarymetxhe xarha, àwyanye, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kuknonano me tàwya ekarymatxehkatxhe, toy hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Towtothàr hona toy hatà. Àton komo hananàhyakon hatà, ohsamnohtoho kom yawo. Koo, noseryehoketxkon hatà, nyamoro. Àsok nay haryhe, mosonà, ketxkon hatà. Àsok nay haryhe. Tàywero rma haxa nay hamà. Eryehokano ynye ro me xarha nay hamà. Tahoxetà rma yonyhen hamà, kàwyanye. Onok hoye ro ryhe ehonomnà me naye, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Noro ywero tehxatxow hamà. Wewe yonyhoryenye ro heno murunho mehra kat naye. Maryeya mryerà mehra kat naye. Txaku yowtà mehra kat naye, ketxkon hatà. Xose yowtà mehra kat naye. Semaw yowtà mehra kat naye. Xuknasà yowtà mehra kat naye, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Noro wosàn mehra kat natxowà, mokyamo, kwawon komo rma. Noro ywero tehxatxow hamà, ketxkon hatà. Noro rma, ehonomnà me mak naha. Àsok nay haryhe, ketxkon hatà. Khoryenkom yano me ehonomnà me nay hamà, kahra mak nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Àro ke, noro xehra nehxatxkon hatà. Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Khoryenkomo rwonà yokarymanye ro komo yonytxetxow hamà, toto komo, kekon hatà. Ewto hon kom haxa ryhe, enytxahranye ro mak natxow hamà. Ukukur komo rma, enytxahranye ro mak natxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Towtothàr ho rma tehtoko, tahoxetà yonyhohra nehxakon hatà, àwyanye, thona xenyhera esnàr kom ke. Nenyhoye rma haryhe tà, ekehàtho komo yonyhoryenàr hoko. Yakehra mak nenyhoryetxownà hatà, àto. ");
INSERT INTO hixNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Karyeryeya yamtar ho rma hak Txesusu yehtoko, noro yokaytà yonytxay hatà, Eroknesà, àton komo kayaryetà ymo. Ehonomnà me rma haxa nay hamà, tàwya eryehokano ynyàr ke, katxho rma yonytxay hatà, Txesus hoko. ");
INSERT INTO hixNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Àro ke, onà wyaro nkekon hatà, tanoto komo wya. Xowaw heno mok hamà, kekon hatà. Aymomno ynye ro heno rma mok hamà. Àwayehxemo kom waye nasanàmyak hamà. Àro hoye ro eryehokano yeryan hamà, kekon hatà, Eroknesà. ");
INSERT INTO hixNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Noro rma, Xowaw heno yahohsonyenhàr me nehxakon hatà. Nasohtohoy xarha tà. Nahryempoy xarha tà, watxa ymo yaka, àwya toynyàr ke mak hatà. Àsok tawro hana. Towtà hetxenho yahosnyenhàr me nehxakon hatà, Eroknesà. Erokneyasà noro hatà, wos yosotà, Feryepe hetxenho rma hatà. Noro rma yahosày hatà, Eroknesà, thetx me harha. ");
INSERT INTO hixNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Àro ke neyey hatà, Xowaw heno. Atxke manaha, kekon heno hatà, Eroknesà wya. Atxke manaha. Tahohsoryehra ro mak naha ha, owya, oyowtà hetxe kaxe, kekon hatà, Xowaw heno. Àro hoye ro nahryempoy hatà, Eroknesà, watxa ymo yaka. ");
INSERT INTO hixNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Etahahonàr xe xarha nehxakon hatà. Etahahohra rma hak nehxakon hatà, toseryehrà ke hatà. Toto kom hona noseryehyakon hatà, onà wyaro kany me esnàr kom ke hatà. Khoryenkomo rwonà yokarymanye ro noro hamà, kany me nehxatxkon hatà, Xowaw heno hoko. ");
INSERT INTO hixNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tonuruthurunhuru yawasàn ho haxa noro heno yotahahoy hatà, Eroknesà. Àro rma ho ehonomnà komo yahxemtoy hatà. Àhyakanye nomokye hatà, omaso, Erokneyasà yomsàrà. Manhoy hatà, Eroknes komo nenyàr me hatà. Eroknesà yeryehotanàhye hatà, banhonàr ke. ");
INSERT INTO hixNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Àro ke, onà wyaro nkekon hatà, noro, omaso wya. Eten xe manaye, kekon hatà. Eten xe manaye. Àro rma wàmyaha, àx oyehtxoho rma. Tàmpàra rma ryehtoko, romtatkano rma hak Khoryenkomo, kekon hatà, Eroknesà. ");
INSERT INTO hixNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tàyon yano me, onà wyaro haxa nkekon hatà, omaso, Erokneyasà yano me rma hatà. Xowaw heno àhàmkotohoko, ayanoto komo wya, kekon hatà. Aymomno ynye ro heno rma àhàmkotohoko, àwyanye. Uyhuthuthuru mekhehe ha, rohyaka, àwyanye. Wetxe yaw hak nehtxowà, kekon hatà, omaso. ");
INSERT INTO hixNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Àro wyaro tàwya enytxatxhe rma, nekhokay hatà, Eroknesà. Àhàmkotohonàr xehra nehxakon hatà. Onà wyaro kanyenhàr me mak nehxakon hatà. Tàmpàra rma ryehtoko, romtatkano rma hak Khoryenkomo, kanyenhàr me mak nehxakon hatà, àton komo nenytxanàr me hatà, omeroron komo nenytxanàr me hatà. Àro ke hàmkotohoy hatà. Onà wyaro nkekon hatà, tanoto komo wya. Àhàmkototatxko ha, kekon hatà. Àhàmkototatxko ha. Uyhuthuthuru mekyatxhe ha, wetxe yawo, kekon hatà, Eroknesà, tanoto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Watxa ymo yaka totxownà hatà, nyamoro. Xowaw heno hàmkototxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Uyhuthuthuru yohtxownà hatà, wetxe yawo. Nàmtxownà hatà, omaso wya. Noro rma narày hatà, tàyonà hyaka. ");
INSERT INTO hixNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Watxa ymo yaka totxownà hatà, Xowawu nhananàhrà rotho komo. Ekehàthàrà yatxownà hatà. Nenamtxownà hatà. Tàwyanye enamàtxhe rma, ekarymaxe totxownà hatà, Txesusu hyaka. ");
INSERT INTO hixNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Xowaw heno yokaytà yonytxay hatà, Txesusu. Tàwya enytxatxhe rma, meya toy hatà. Nosonkahye hatà, kanawa yaka. Ahehnaka tàtonàr xe rma nehxakon haryhe tà, totohnaka hatà. Àtonàrà yonytxatxownà mak hatà, toto komo. Àro ke totxownà hatà, nyamoro xarha, thenyenohnà komo. Anaro rha owto hoye omohxemo komo rma nyamoro hatà. Àwararo totxownà hatà. Txesusu yohoso totxownà hatà. Nyamoro htxero nahatakatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Txeey, Txesus komo xarha nahatakatxownà hatà. Tasanàmnàtoko, toto komo yonyey hatà, Txesusu. Thenyehra rma haxa nehxatxkon hatà. Àhnàn kom yawo rma haxa nehxakon hatà, Txesusu. Ekehàtho komo yonyhoryey hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Àro rma kokmamrà ro, Txesusu hyaka haxa totxownà hatà, ànhananàhrà ro komo. Ehxera ro mak naha, owto, tano, ketxkon hatà, àwya. Tkokmamtxow ha. Àro ke, toto komo ànyahtxoko, ketxkon hatà. Ànyahtxoko, anaro rha owto hona. Tànyahrà komo yehekahso ànyahtxoko, ketxkon hatà, ànhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Àtohra hak nahtxoko, kekon mak hatà, Txesusu, àwyanye. Àtohra hak nahtxoko. Omnyamo rma ànyahmatxoko, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ehxera naha, ànyahrà komo, amna hyawo, ketxkon mak hatà, àwya. 5 me marma naha, ekeyu, amna hyawo. Kana xarha, 2 me marma naha, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Àrotho rma sohtxoko, rohyaka, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Toto komo yeryewtanàhye hatà, txufu txko waka. Ekeyu yanàmye hatà. 5 me rma nanàmye hatà. Kana xarha yanàmye hatà, 2 me rma. Kakoso nosompotày hatà. Khoryenkom yakoro nàrwonàmye hatà, ekeyu hoko, kana hoko xarha. Nowye hatà. Nàmye hatà, tànhananàhrà ro komo wya. Nyamoro rma nàmtxownà hatà, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Omeroro rma nenahtàkatxownà hatà. Wahuramtàhkatxownà hatà. Otàkràskatxhàràtho yonàmatxownà hatà, wetxe ymo yaka. 12 me rma nenàmatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Twahak hana nehxatxkon ha, àyakenon kom ha. Kàrkomo komo ryhe, 5000 me hana nehxatxkon ha. Nenahtxownà xarha tà, woràskomo komo, àhokyamo xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tàwya toto komo nyahmatxhe rma, tànhananàhrà ro komo nyakye hatà, Txesusu. Kanawa yaka osonkahtxoko, kekon hatà, àwyanye. Roywaho àtotxoko, mon hona. Uro ryhe toto komo ànyakyaha, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Àro ke nànyahtxownà hatà. Tàwya ànyaketxhenye rma, toy hatà, àh hona. Noro ro toy hatà, Khoryenkom yakoro àrwonàmso. Kohsaya rma àhà ymo ho nehxakon hatà, noro ro mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ànhananàhrà ro kom haxa ryhe, kanawa yawo rma nehxatxkon hatà. Tuna ymo rakatawo rma nehxatxkon hatà. Moxe rma haxa mak nehxakon hatà, yukryeka. Empatayenye nomokyakon hatà, atxowowo ymo. Dyow dyow dyow kekon hatà, kanawa heno hoko. ");
INSERT INTO hixNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Enmahpaya ehtoko, nomokye hatà, Txesusu, àhyakanye. Tuna ymo ratokoko nomokyakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tuna ymo ratokoko omoknàrà rma yonytxownà hatà, ànhananàhrà ro komo. Noskatokatxownà mak hatà. Mokro ymo ha okatonho, ketxkon hatà. Kowontetxkon hatà, oseryehrà komo. ");
INSERT INTO hixNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Amamehra mak nàrwonàmye hatà, Txesusu. Oseryehpàra ehtxoko, kekon hatà, àwyanye. Uro ryhe uro. Towankaryhe ehtxoko, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Neyukye hatà, Petru. Rohà y, kekon hatà. Txesus me oyehtoko, uro anyehko. Amna yoh me rma oyehtoko, uro anyehko, ohyaka, kekon hatà. Tuna ymo ratokoko omoko, kasko, rowya. Tuna ymo ratokok hak komohsà, ohyaka, ayano me, kekon hatà, Petru. ");
INSERT INTO hixNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Omoko, kekon hatà, Txesusu, àwya. Omoko. Àro ke nàhtoy hatà, Petru, kanawa yaye. Tuna ymo ratokoso rma nàhtoy hatà. Tuna ymo ratokoko toy hatà, Txesusu hyaka. ");
INSERT INTO hixNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Atxowowo ymo yonyey hatà. Àro ke noseryehyakon harha tà. Nowomyakon hatà, tuna ymo kwaka. Rohà y, uro ukurunhoko, rowomrà hona, kekon hatà, teryewrye ro. Uro ukurunhoko, rowomrà hona. ");
INSERT INTO hixNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Àro wyaro àwya katxhe rma, natahoyotkay hatà, Txesusu. Nahosày hatà. Rohona xenyhera harha mahko hamà, kekon hatà, àwya. Rahoxet hona xenyhera harha mahko hamà. Kowomyan hana, kwayehyan hana, màkan hamà, rohona xenyhera harha oyesnàr ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nosonkahtxownà hatà, Txesus komo, Petru xarha, kanawa yaka. Osonkahàtxhenye rma, natàknay hatà, atxowowo ymo. ");
INSERT INTO hixNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ehonomnà me xaxa Txesusu yonyatxkon hatà, kanawa yawon komo. Khoryenkom muru me xaxa manay hamà, omoro, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Wetotxownà haxa hatà, Txesus komo. Txeey katxownà hatà, Xenesarye yamtar hona. Nasanàmtxownà hatà, mahona. ");
INSERT INTO hixNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mokro ha Txesusu, ketxkon hatà, toto komo, àton komo. Àro ke, ekeh komo yanyehxe totxownà hatà. Xenesarye yamtar horye totxownà hatà, anaro rha owto hona. Ekeh komo yokyatxkon hatà, omeroro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ohononà ahehoko, amna wya, ketxkon hatà, ekeh komo, Txesusu wya. Ohononà yotxhàrà rma ahehoko, amna wya, ketxkon hatà. Àro ke nahetxownà hatà. Ahenyenhàyamo rma, ohxe harha nehxatxkon hatà, omeroro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Txesusu hyaka nomohtxownà hatà. Farysew kukur komo, àyweronàhyamano ynye ro kukur komo xarha. Xerusaryen hoye omohxemo komo rma mokyam nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Atxke natxow hamà, onhananàhrà ro komo, ketxkon hatà, Txesusu wya. Àsok tawro hana. Osomyakorokahra nemtakmetxhe. Àro ke atxke natxow hamà. Khoryen heno komo wya kàyweronàhyamatxho kom yawo rohra natxow hamà, ketxkon hatà, Farysew komo. ");
INSERT INTO hixNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Ohoryen heno komo meyukyatxow hamà, omnyamo, kekon hatà. Nyamoro heno yoyuknye rma, Khoryenkomo yoyukhura rma manatxow hamà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Onà wyaro ryhe kàyweronàhyamahotxownà hatà, Khoryenkomo, Moyses heno wya. Toyuhsom me xenytxoko, oyàm komo, oyon komo xarha. Tàyàm komo wàràhyakany kom haxa ryhe etahatxoko. Àro wyaro kàyweronàhyamahotxownà hatà, Khoryenkomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Onà wyaro haxa ryhe àyweronàhyamano meryatxhe, omnyamo, ohoryen heno kom yano me mak ha. Khoryenkomo wya dekàthàyamo yàmnàtoko, kyàm komo yowakryehra harha tehxatxow hamà, màketxhe, toto komo wya, kekon hatà, Txesusu. Apa y, eme y, owya tàmsomàtho rma haxa on nahko haryhe, rokatxhotho, owya tàmpàra harha wehxaha, Khoryenkomo wya tàmsom me esnàr ke, tkatxe, màketxhe, toto komo wya, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Àro wyaro ohoryen heno komo meyukyatxow hamà. Nyamoro heno yoyuknye rma, Khoryenkom yoyukhura rma manatxow hamà. Nahko yxak haka kany me rma manatxow hamà, Khoryenkomo rwon hoko, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Enyhoru uro ha kanye rma, yaworohra manatxhe, kekon xarha tà, àwyanye. Ohokonye rma, yaworo xaxa nmenhoy hamà, Esaeyas heno, Khoryenkom yano me. Onà wyaro nmenhoy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ohxe naha, Khoryenkomo, ketxhe rma haryhe, nyamoro ha. Tàmtar kom ke marma, àro wyaro nketxhe. Tàhnawony haxa ryhe, rohona xenyhera ro mak natxhe ha. ");
INSERT INTO hixNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Àtohnawo rma rowakryetxhe haryhe. Khoryenkomo rwonà amna nekarymehe, owyanye, ketxhe rma haryhe, toto komo wya. Toto rwon haxa ryhe yokarymetxhe, nyamoro ha. Àro wyaro nmenhoy hatà, Esaeyas heno. Ohokonye ryhe nmenhoy hamà, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Toto komo yanyekye hatà, Txesusu, tàhyaka. Uro enytxatxoko, kekon hatà, àwyanye. Thutwaxem me hak nahko, rorwonà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Àsok katxho me hana natxow ha, toto kom ha. Atxke manatxhe katxho me natxow hamà, omeroro, kekon hatà. Woto yonotho hoye rohra mak àro wyaro katxho me natxhe, osomyakorokahra temtakmatxho kom hoye rohra mak ha. Atxke tàrwonàmtoho kom hoye ro haxa ryhe, atxke manatxhe katxho me natxhe ha, Khoryenkomo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Àhyaka haxa nomohtxownà hatà, ànhananàhrà ro komo. Onà wyaro nketxkon hatà, àwya. Àro wyaro orwonàmrà xehra ro mak nahtxoko, Farysew komo. Uhutwahra mahko, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Ehetahnà wyaro natxow hamà, nyamoro ha, kekon hatà. Tàwya ehetahnà yonyetoko, onà wyaro nken hamà, tànatkemà. Anhà moro hamà, ronenamàthohnà rma moro hamà, ken hamà. Àro ke waken hamà, tànatkemà, kekon hatà, Txesusu. Àro wyaro rma rha natxow hamà, nyamoro ha. Toto nenamàthohnà wyaro, royàm nànyaketxhohnà me natxhe. Kahe yawono nànyaketxhohnà me natxhe. Àro ke, toto wya àwakanàrà wyaro, tanàhnohsom me natxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nyamoro hoko rma, oseryehokahra ehtxoko. Enhun komo wyaro xarha natxow hamà. Àsok hana natxow ha, enhun kom ha. Enhura tehtokonye, anaro enhun komo yarhàra natxow hamà. Tàwyanye anàtokony haxa, ewtar yaka nehurketxow hamà, anyetho komo, kekon hatà. Asahotho komo xarha nehurketxow hamà. Àro wyaro rma rha natxhe, nyamoro ha. Amna ahananàhyatxhe ketxhe rma haryhe, toto komo wya. Àhananàhpàrany mak natxhe ha, uhutwanyehnà komo kaxe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Onà wyaro nkekon hatà, Petru, àwya. Kuknonano me onekarymatxhàrà uhutwamohsoko, amna wya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Omnyamo xarha, uhutwahra manatxowà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Onà wyaro thutwaxem me nay hamà, ronekarymatxho. Kowan kom yawo rorohra nay hamà, tonosahotho. Khosot kom yarye ten hamà, kekon hatà. Baharaxkaxe ro nahataken hamà. Àro ke, woto yonotho hoye rohra atxke manatxhe katxho me natxow hamà, toto komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Atxke tàrwonàmtoho kom hoye ro haxa ryhe, atxke manatxhe katxho me natxhe ha. Atxke nàrwonatxhe, tàhnawonye atxke tesnàr kom ke mak ha. Àro hoye ro, atxke manatxhe katxho me natxhe ha, toto komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Àsok tawro hana. Onà wyaro atxke natxow hamà, tàhnawonye. Atxke nehutwetxow hamà. Anatoko toto yotahanàr xe natxow hamà, kekon hatà. Anatoko anar komo hetx hoko tesnàr komo xe natxow hamà. Anatoko anar komo ynyo hoko tesnàr komo xe natxow hamà. Anatoko twayamontanàr komo xe natxow hamà, kekon hatà. Anatoko anar komo katxhotho yanàr xe natxow hamà. Anatoko yaworohra toto yokarymanàr xe natxow hamà. Anatoko toto wàràhyakanàr xe natxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Àro wyaro tàhnawonye atxke tehtxoho kom hoye ro, atxke manatxhe katxho me natxhe ha, toto komo, Khoryenkomo wya. Osomyakorokahra temtakmatxho kom hoye rohra rma atxke natxhe, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Xenesarye yamtar hoye toy hatà, Txesusu. Toy hatà, Txeru màtkoso, Seknon màtkoso rma. Xuknewyanahnà komo yowto rma àro ha, Txeru, Seknon xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Àto rma hak Txesus yehtoko, àhyaka nomokye hatà, wosà. Àton komo kukuru rma mok nehxakon hatà, Kananeyayana komo kukuru rma hatà. Rohà y, kekon hatà, Txesusu wya. Dafe heno yohamàtho omoro hatà. Rohnàn yawo exko, kekon hatà. Worokyamo yoh me rma haxa manaye, romsàtho txko. Atxke rma haxa manaye, kekon hatà, wosà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Eyukhura mak nexey hatà, Txesusu. Àro ke, onà wyaro nketxkon hatà, ànhananàhrà ro komo, àwya. Moson ànyahko ha, ketxkon hatà. Moson ànyahko ha. Kwenaryenye nomokyaha. Teryewrye ro nàrwonaha. Àro ke ànyahko ha, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Ehsayewyana komo hyaka marma ànyahxah uro, Xuknewyana komo hyaka marma, kekon hatà. Nyamoro rma, okno àwaymamxemo komo wyaro natxow hamà, Khoryenkomo hutwahra harha tesnàr kom ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Àhyaka haxa nomokye hatà, wosà. Akrataka neryewtay hatà, tosoknar ho, ehonomnà me tàwya xenyàr ke. Rohà y, uro nyhe txko ewakryeko, kekon hatà, àwya. Uro nyhe txko ewakryeko. ");
INSERT INTO hixNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Onà wyaro haxa neyukye hatà, Txesusu. Khokyamo nyahrà hoye tàmpàra tehxatxow hamà, kaykusu wya, kekon hatà. Àro wyaro rma rha, Xuknewyana yonyhoryeny komo, anar komo yonyhoryehra nay hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Àna mat mà, rohà y, kekon hatà, wosà. Onà wyaro haxa àkehe, owya. Tosom nyahrà hpunutho txko yonahyan hamà, kaykusu. Àro ke, uro nyhe txko ewakryeko, atxke txko nyhe rma, kekon hatà, wosà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Àro wyaro àwya katxhe rma, neyukye hatà, Txesusu. Wosà y, rohona rma haxa menyan hamà, kekon hatà. Oyomsàrà yonyhoryenàr xe manay hamà, rowya. Wenyhoryen hampànà, kekon hatà. Àro wyaro àwya tatoko rma, ohxe harha nehxakon hatà, emsàrà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Karyeryeya yamtar hona harha toy hatà, Txesusu. Karyeryeya kuthonà ymo yohokoko toy hatà. Àhà ymo yawnukye hatà. Neryewtay hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Àhyaka nohsamnohtàkatxownà hatà, toto komo, thenyehra rma haxa mak hatà. Ekeh komo yohtxownà hatà, àhrohnà komo rma hatà, teheryankem komo xarha hatà, enhun komo xarha hatà, àrwomnà komo xarha hatà, anar komo xarha hatà. Thenyenohnà komo rma yohtxownà hatà, Txesusu hyaka. Akrataka rma netxownà hatà. Omeroro nenyhoryetxownà hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Àro ke noseryehokatxehkatxownà hatà, toto komo. Àsok tawro hana. Àrwomnà rotho komo nàrwonatxkon harha tà. Teheryankemàtho komo xarha, ohxe harha nehxatxkon hatà. Àhrohnà rotho komo xarha, nataryeknohyatxkon harha tà. Enhunu rotho komo xarha, tonke harha nehxatxkon hatà. Koo, ketxkon hatà, toto komo. Ohxe xaxa nay hamà, Khoryenkomo. Ehsayewyana komo horyenà ro rma noro hamà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tànhananàhrà ro komo yanyekye hatà, Txesusu, tàhyaka. Onà wyaro nkekon hatà, àwyanye. Thenyehra natxow hamà, toto komo, ohsamnohxemo komo, kekon hatà. 3 me nenmahyatxoko, tano, rohyawo. Ànyahpàra natxhe. Àro ke, àhnàn kom yawo rma haxa wehxaha, kekon hatà. Ànyaknyàr komo xehra wehxaha, ahyehrà kom ke. Tàtontokonye rma, namotohyatxow hamà, asama rakatawo rma, kekon hatà, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ànyahrà komo ehxera ro mak nay hamà, tano, ahehnawo, ketxkon hatà, ànhananàhrà ro komo. Thenyehra rma haxa natxow hamà. Àsok tànyahmetxow haryhe, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Twahak naye, ekeyu, ohyawonye, kekon hatà, Txesusu. 7 me naha, ketxkon hatà. Kana txko xarha naha, amna hyawo, yakehra mak ha, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Toto komo yeryewtanàhye hatà, yukryeka hona. ");
INSERT INTO hixNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ekeyu yanàmye hatà. 7 me rma nanàmye hatà. Kana txko xarha yanàmye hatà. Khoryenkom yakoro tàrwonàmàtxhe, nowye hatà. Nàmye hatà, tànhananàhrà ro komo wya. Nyamoro rma nàmtxownà hatà, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Omeroro rma nenahtàkatxownà hatà. Wahuramtàhkatxownà hatà. Otàkràskatxhàràtho yonàmatxownà hatà, wetxe ymo yaka. 7 me rma nenàmatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Twahak hana nehxatxkon ha, àyakenon kom ha. Kàrkomo komo ryhe, 4000 me nehxatxkon hatà. Nenahtxownà xarha tà, woràskomo komo, àhokyamo xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Taa. Nànyahtxownà hatà, Txesusu. Tàwya ànyaketxhenye rma, nosonkahye hatà, kanawa yaka. Owto màtkoso toy hatà. Makaknanà rma àro ha, owto yosotà. ");
INSERT INTO hixNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Txesusu hyaka nomohtxownà hatà, Farysew kukur komo, Saknusew kukur komo xarha. Onà wyaro nketxkon hatà, àwya. Kahe yawon yahoxetà xenyhoko, amna wya, yaworo xaxa manay hamà katxho me, amna wya, ketxkonà rma haryhe tà. Noro yahoxetà kukmanàrà xe rma nehxatxkon haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Awanaka owyanye kahe yonyetoko, onà wyaro kany me manatxow hamà, kekon hatà, àwyanye. Awanaworo omokhàra nay hamà, tuna, kahe roro me esnàr ke, kany me manatxow hamà. Àro hoko yaworo màketxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Enmahrà ro xarha, onà wyaro kany me manatxhe. Tuna heno nomokyan hamà, tawanye esnàr ke, kany me manatxhe. Àro hoko xarha, yaworo rma rha màketxow hamà, kekon hatà. Àro ywero manatxow hamà. Onà ywenyeke mak manatxhe. Khoryenkom yano me tan ryehtxoho ywenyeke rma manatxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Àsok hana manatxow ha, omnyam ha, amnyeno rma komo, kekon xarha tà, àwyanye. Atxke rma haxa manatxow hamà. Thetxenhàrà hyaye toto yotowrà wyaro, Khoryenkomo hyaye otowsah me manatxow hamà. Àro ke, kahe yawon yahoxetà xenyhoko, amna wya, màketxhe rma haryhe, kekon hatà. Noro yahoxetà yonyhohra mak wehxaha, owyanye. Xonas heno hutwahkahpàra ehtxoko. Noro heno hoko rma tahoxetà yonyhoy hatà, Khoryenkomo, tàwya anàmrà ke mak ha. Àro wyaro rma rha, towenyxa ro haxa tahoxetà yonyhehe hampànà, kekon hatà, Txesusu, Farysew komo wya, Saknusew komo wya xarha. Àro wyaro tàwya katxhe rma, àhyayenye toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mon hona totxownà hatà, Txesus komo. Ekeyu yarhàra mak nehtxownà hatà, ànhananàhrà ro komo. Nàkwetarontatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Onà wyaro nkekon hatà, Txesusu, àwyanye. Katamaru wakan hona mpànà xenytxoko, kekon hatà. Farysew yanhàn komo rma hona mpànà xenytxoko. Saknusew yanhàn komo rma hona mpànà xenytxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Àro wyaro tàwyanye enytxatxhe rma, nosonytxetxkon hatà, ànhananàhrà ro komo, nyamoro rye rma. Àsok tawro àro wyaro nkano, katamaru wakan hoko, ekeyu yokhàra kesnàr kom ke hamà, ketxkonà rma haryhe tà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Osonytxatxho komo hutwekon mak hatà, Txesusu. Àro ke, onà wyaro nkekon hatà, àwyanye. Rorwonà hutwahra manatxow hamà, rohona xenyhera oyesnàr kom ke, kekon hatà. Àsok tawro àro wyaro mosonytxatxow harha. Àsok tawro orwonatxow harha, uyuhra oyehtxoho kom hoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","10","Uhutwahra rma manatxowà. Muhutwahkahyatxok hamà. Rahoxetà yonyhohra kat wehxako, owyanye, ekeyu hoko. 5000 komo nyahmahra kat wehxako, 5 me ekeyu ke rma, kekon hatà. 4000 komo xarha nyahmahra kat wehxako, 7 me ekeyu ke rma. Otàkràskatxhàràtho yonàmahra kat mehxatxoko, wetxe ymo yaka, yaken yaka rma. Àro wyaro owyanye rahoxetà yonyetxhàrà muhutwahkahyatxok hamà, kekon hatà. Àro hoye ro moseryehoketxow hamà, uyuhra oyehtxoho kom hoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Rowya, katamaru wakan hona mpànà xenytxoko tatoko rma, ekeyu hokohra rma àro wyaro àkano, kekon xarha tà. Katamaru wakano katxho rma, Farysew yanhàn komo kuknon me naha. Saknusew yanhàn komo kuknon me rma naha. Nyamoro yanhàn hona mpànà xenytxoko, àkan haxa hawe, owyanye. Àro wyaro uhutwahra mak mahtxok hamà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Àro wyaro tàwyanye enytxatxhe rma, hutwatxownà harha tà, nyamoro ha. Ekeyu hokohra nàrwonàmno hamà, ketxkon hatà, tàwyanye rma. Katamaru wakan hona mpànà xenytxoko katxho rma, ekeyu hokohra nahko hamà. Farysew komo wya ahananàhtoho kom hona mpànà xenytxoko katxho me rma nahko hamà. Saknusew komo wya ahananàhtoho kom hona mpànà xenytxoko katxho me rma nahko hamà, ketxkon hatà, Txesusu nhananàhrà ro komo, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Taa. Sesaryeya Feryepe màtkoso tetxkon hatà, Txesus komo. Tàtonàr kom me, onà wyaro nkekon hatà, Txesusu, tànhananàhrà ro komo wya. Onok me ryhe naye, Toto me Enusaho, toto komo wya, kekon hatà. Onok me netakyatxowà, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Onà wyaro nketxhe, anar komo, ketxkon hatà. Xowaw heno we mokro ha, aymomno ynye ro heno we mokro ha, ketxhe haryhe, ohoko, anar komo, ketxkon hatà. Eryeyas heno haxa we mokro ha, ketxhe, anar komo xarha. Xeryemeyas heno haxa we mokro ha, ketxhe, anar komo xarha. Khoryenkomo rwonà yokarymanye ro heno komo kukur haxa we mokro ha, ketxhe, anar komo xarha, ketxkon hatà, ànhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Omnyam haxa, onok me ryhe uro metakyatxowà, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kryestu ryhe omoro, amna wya, kekon hatà, Semaw Petru. Khoryenkom muru rma omoro, tehxem xaxa muru rma omoro, amna wya, kekon hatà, Semaw Petru. ");
INSERT INTO hixNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Semawu y, Xowaw muru y, kekon hatà, Txesusu. Towakryexem me rma haxa manay hamà. Àsok tawro hana. Toto yano mehra àro wyaro màkan hamà, rohoko. Royàm yano me haxa ryhe àro wyaro màkano, kahe yawon yano me mak ha. Noro ryhe rohutwamohson hamà, owya. Àro ke, towakryexem me rma haxa manay hamà, kekon hatà, Txesusu, Petru wya. ");
INSERT INTO hixNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Onà wyaro àkehe, owya, kekon xarha tà, àwya. Petru omoro. Tohu katxho me rma nay hamà, oyosotà, Petru katxho. Owya, Kryestu ryhe omoro, Khoryenkom muru omoro, katxho xarha, tohu wyaro rma rha naha, towaxkemà wyaro rma, kekon hatà. Àsok hana romryenon komo weryan ha. Onà wyaro kany me weryatxow hamà, kekon hatà. Kryestu ryhe omoro, Khoryenkom muru rma omoro, kany me rma rha weryatxhe hampànà, romryenon komo, kekon hatà. Àro hoye ro arymahranye ro mak naha hampànà, anhà yohà ymo, awayehtoho komo yohà ymo, kekon hatà, Txesusu, Petru wya. ");
INSERT INTO hixNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Rano me ryhe, onà wyaro màkehe, omoro, toto komo wya, kekon xarha tà, àwya. Khoryenkomo mryenon mehra manatxhe hampànà, màkehe, anar komo wya, rano me mak ha. Àro wyaro rma màkehe, omoro, yukryeka hono rma. Àro wyaro rma rha àkehe, uro xarha, kahe yawono, nyamoro hoko, kekon hatà. Khoryenkomo mryenon mehra harha hak nahtxoko, nyamoro ha, ranoto rwonà yawo ro mak ha, àkehe uro, kahe yawono, kekon hatà. Khoryenkomo mryenon me mpànà manatxhe ha, màkehe xarha, anar komo wya, rano me rma rha. Àro wyaro rma màkehe, omoro, yukryeka hono rma. Àro wyaro rma rha àkehe, uro xarha, kahe yawono, nyamoro hoko, kekon hatà. Khoryenkomo mryenon me hak nahtxoko, nyamoro ha, ranoto rwonà yawo ro mak ha, àkehe uro, kahe yawono, kekon hatà, Txesusu, Petru wya. ");
INSERT INTO hixNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Onà wyaro nkekon xarha tà, tànhananàhrà ro komo wya. Kryestu me naha, Txesusu, kahra xaxa mpànà ehtxok ha, toto komo wya, kekon hatà, Txesusu, teryewrye ro, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Àro wyaro Petru kom yakoro tàrwonàmàtxhe, noskarymekon harha tà, Txesusu. Twayehtoho rma yokarymekon harha tà, tànhananàhrà ro komo wya. Àtehe ro mak hampànà, Xerusaryen hona, kekon hatà. Thenyehra rma haxa ryeryewhamnohyatxhe hampànà, Xuknewyana yoh komo, horykomo komo rma, Khoryenkom màn yonye ro yoh komo xarha, àyweronàhyamano ynye ro komo xarha, kekon hatà. Yahkotohen hona ramoyathohetxhe xarha hampànà. Rowayhàtxhe, kasanàmyaha harha hampànà. Osorwawo ro enmahàtxhe, kasanàmyaha harha hampànà, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Àro ke, meya nyhe txko narày hatà, Petru. Amna yohà y, àro wyaro kahra exko, kekon hatà, àwya. Àro wyaro kahra exko. Oyeryewhamnohpohra nay hamà, Khoryenkomo, àwyanye. Àro wyarohra manay hamà, kekon hatà, Petru, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Noro wetxe neramay hatà, Txesusu. Onà wyaro nkekon hatà, àwya. Khoryenkomo yoyuknur xehra manay hamà, rowya, kekon hatà. Khoryenkomo yehutwatxho hoye rohra àro wyaro màkano. Toto yehutwatxho hoye ro haxa ryhe àro wyaro màkano, kekon hatà. Satanasà ymo yano me ryhe àro wyaro màkano. Àro ke, onà wyaro àkehe, noro ymo wya. Satanasà y, àtok ha, rohyaye, àkehe, àwya, kekon hatà, Txesusu, Petru wya. ");
INSERT INTO hixNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Onà wyaro nkekon hatà, Txesusu, tànhananàhrà ro komo wya. Rakoro otonàr komo xe oyehtokonye, onà wyaro ehtxok hampànà, kekon hatà, àwyanye. Osoxanomkahnohtxok hampànà. Oyeryewhamnohtoho komo enàmtxok hampànà. Àro wyaro enàmnye rma, rakoro àtotxok hampànà, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Anatoko oyeryewhamnohrà komo xehra manatxow hana, toto komo wya, kekon xarha tà, àwyanye. Àro ke, oyekrunhonàr xe manatxow hana, awayehrà kom hona. Oyekrunhonàr xano rma, awayehyatxhe xak mak hampànà, kekon hatà. Àsok haxa hana manatxow ha. Mosoxanomkahnohyatxow haxa hana, twayehso ro, rox oyesnàr kom ke mak ha. Àro wyaro tosoxanomkahnohsomà rma, mekrunhetxhe harha. Karyhe roro harha manatxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Àsok hana manatxow ha, kekon xarha tà, àwyanye. Tkatxhonke rma haxa manatxow hana. Ohyawonye rma nay hana, anaro rha katxhonano, omeroro, kekon hatà. Àro wyaro thenyehra tkatxhonkemà rma, ohxehra rma manatxhe ha. Karyhe roro harha manatxhe katxho mehra oyehtokonye, ohxehra rma manatxhe ha. Tanàhnohsom me xak mak manatxhe hampànà, kekon hatà. Karyhe roro harha oyehtxoho komo rma, onàhnàn kom me nay hamà. Anaro onàhnàn komo ehxera ro mak nay hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Amnye nomokyaha hampànà, Toto me Enusaho, kahe yawon kom yakoro, tanoto kom yakoro, kekon xarha tà. Tàyàmà wyaro ehonomnà me xaxa nosonyhehe hampànà. Tomokàtxhe rma, ehenàhno yeryaha hampànà. Anar komo wya, ohxe exetxhàyamo yehemehe hampànà. Anar komo wya haxa ryhe, atxke exetxhàyamotho yehenàhyaha hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Onà wyaro yaworo xaxa àkehe, owyanye. Toto komo kayaryet me nomokyaha xaxa mak hampànà, Toto me Enusaho, kekon hatà. Àro wyaro noro yomokhàra ro rma haka awayehyatxhe hampànà, omnyamo, kekon hatà. Okukur kom marma ryhe, àwayehpàra rma hak natxhe hampànà. Nyamoro rma, toto komo kayaryet me noro yomohtoho yonyatxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Àro wyaro nekarymay hatà, Txesusu. Taa. 6 me enmahàtxhe, toy hatà, àhà ymo hona. Petru yarày hatà. Txaku xarha yarày hatà. Xowaw xarha yarày hatà. Txaku yowtà rma noro ha. Nyamoro marma yarày hatà. Àhà ymo hona natxownà hatà, kawono ymo hona. ");
INSERT INTO hixNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Anar me tonyxem me harha nexey hatà, Txesusu. Anar me harha nehxakon hatà, empatarà, kamàm yawasànà wyaro. Àwomun xarha, tàkrokromuknye harha nehxakon hatà. Awasànà ymo wyaro nenkahxatxkon hatà, àwomunu. ");
INSERT INTO hixNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Àtoko rma nosonyhotxownà hatà, asakon komo, Moyses heno rma hatà, Eryeyas heno xarha hatà, àwyanye. Nàrwonatxkon hatà, Txesus yakoro. ");
INSERT INTO hixNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Onà wyaro nkekon hatà, Petru, Txesusu wya. Amna yohà y, tan kehtxoho komo ohxe nay hamà, kekon hatà. Wato hak wexe, osorwawo, omàn komo, Moyses màn xarha, Eryeyas màn xarha. Txenyàr xehra kat manaye, rowya, kekon hatà, Petru. ");
INSERT INTO hixNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Àro wyaro Petru wya tatoko rma, nomokye hatà, kahrutunu, ehokosonye. Tawasnye ymo nehxakon hatà, kahrutunu. Àro wawono rwonà yonytxatxownà hatà. Romuru mosonà, kay hatà. Ronàhnàn xaxa mosonà. Àhoko rma teryehorye rma haxa wehxaha. Noro enytxatxoko, kay hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Àro wyaro tàwyanye enytxatxhe rma, tano me ronye rma nehurkatxownà hatà, Petru komo, yukryeka hona, thenyehra toseryehrà kom ke mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Àhyakany haxa nomokye hatà, Txesusu. Nahetxownà hatà. Asanàmtxok harha, kekon hatà, àwyanye. Asanàmtxok harha. Oseryehpàra ehtxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nosompohtxownà hatà, Petru komo. Tosompotàtxhenye, Txesus marma yonytxownà hatà. Anar komo ehxera harha nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Àhà ymo yonàhtotxownà hatà, Txesus komo. Enàhtonàr me rma, onà wyaro nkekon hatà, Txesusu, Petru komo wya. Onenyetxhàyamo yokarymahra xaxa mpànà ehtxok ha, toto komo wya, kekon hatà. Àwayehxemo kom waye rasanàmàtxhe, mekarymetxhe ha, Toto me Enusaho yasanàmàtxhe rma, kekon hatà. Rasanàmpàra ro rma haka, ekarymahra rma ehtxok hampànà, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Onà wyaro nketxhe, àyweronàhyamano ynye ro komo, ketxkon hatà, Petru komo. Kryestu yomokhàra ro rma haka, nomokyan hatà, Eryeyas heno, ketxhe. Àsok tawro àro wyaro nketxowà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yaworo nketxhe, kekon hatà, Txesusu, àwyanye. Tomohsom me nehxakonà, Eryeyas heno wyarono. Onyhoryetxehkano yxe tomohsom me nehxakonà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Onà wyaro haxa àkehe, owyanye. Omohsah me rma naha, noro ha. Àywenyeke mak nehxatxkonà, toto komo, kekon hatà. Noro heno mak yeryewhamnohtxownà, tano me ronye rma. Àro wyaro rma rha ranàhnohyatxhe hampànà. Toto me Enusaho rma yeryewhamnohyatxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Àro wyaro tàwyanye enytxatxhe rma, hutwatxownà harha tà, Petru komo. Xowaw heno hoko ryhe, àro wyaro nkan hamà, aymomno ynye ro heno hoko rma, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Toto komo hyaka nomohtxownà hatà, Txesus komo, ohsamnohxemo komo hyaka. Omokàtxhenye rma, Txesusu hyaka nomokye hatà, toto. Akrataka rma neryewtay hatà, tosoknar ho. ");
INSERT INTO hixNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Rohà y, kekon hatà, Txesusu wya. Romuru hnàn yawo nyhe txko exko. Tàrohsomà ro me naha, kekon hatà. Thenyehra neryewhamyaha. Yake ro nehurkaye, weheto waka, tuna kwaka xarha. Àro ke noro akoronomako, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Wekno rma haryhe, onhananàhrà ro komo hyaka, moxamo hyaka. Romurunho txko enyhoryetxoko, àkano rma haryhe, àwyanye. Onyhoryeno ynyehnà ro mak moxam hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Onà wyaro haxa nkekon hatà, Txesusu. Àsok hana manatxow ha, omnyam ha, amnyeno rma komo, kekon hatà. Khoryenkom hona xenyehnà omnyam hamà. Noro yanweknye rma omnyam hamà, kekon hatà. Mexe rma haxa ehxah me wehxaha, awawonye. Khoryenkom yahoxetà hutwahra rma manatxhe, kekon hatà. Mexe rma rha kramamyan hamà, awawonye rma. Khoryenkom yahoxetà hutwahra rma oyehtxoho komo wenàmyano rye rma hamà, tano, kekon hatà, Txesusu. Sohtxok ha, rohyaka, kekon xarha tà. ");
INSERT INTO hixNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Worokyamo yoyey hatà. Notowye hatà, worokyamo, noro hyaye. Àtoko rma ohxe harha nehxakon hatà, bàryekomo. ");
INSERT INTO hixNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Taa. Toto komo totxhe rma, Txesusu hyawo rma nehxatxkon hatà, ànhananàhrà ro komo, nyamoro rye rma. Onà wyaro nketxkon hatà, àwya. Àsok tawro towhàra amna nahko harha, ketxkon hatà. Àsok tawro towhàra amna nahko harha. ");
INSERT INTO hixNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Khoryenkom yahoxet hona xenyhera mahtxoko, kekon hatà, Txesusu, àwyanye. Towhàra mahtxoko, noro hona xenyhera oyesnàr kom ke. Onà wyaro yaworo xaxa àkehe, owyanye, kekon hatà. Anatoko Khoryenkom hona menyatxow hana, atxke txko rma, natà txko wyaro rma, mostakna nathàrà txko wyaro rma. Atxke txko noro hona owyanye xenyetoko rma, eryehokano meryatxhe rma, noro yano me mak ha, kekon hatà. Oyoyukyatxhe hampànà, àhà ymo, moro ymo. Owyanye meya ohtakako katxhe rma, oyoyukyatxhe hampànà, Khoryenkom hona owyanye xenyàr ke mak ha, kekon hatà. Àro wyaro rma eryehokano meryatxhe. Àsok maken kom hoko, ehnyahnà ro me xaxa mpànà manatxhe ha, Khoryenkom hona owyanye xenyàr ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Onà wyaro nkekon xarha tà, àwyanye. Khoryenkom yakoro àrwomra oyehtokonye, otowhànà ro me rma naha hampànà, worokyamo, kekon hatà. Khoryenkom hoko atahyehnomahra rma oyehtokonye, otowhàn me rma naha, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Karyeryeya yamtar ho harha tehtokonye, Txesusu hyaka nohsamnohtxownà hatà, ànhananàhrà ro komo. Onà wyaro nkekon hatà, àwyanye. Tahohsosom me naha hampànà, Toto me Enusaho, toto komo wya, anhà komo wya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nyamoro rma namoyathohetxhe, yahkotohen hona. Twayhàtxhe, nasanàmyaha harha hampànà. Osorwawo ro enmahàtxhe, nasanàmyaha harha hampànà, kekon hatà, Txesusu. Àro wyaro tàwyanye enytxatxhe rma, nekhokatxownà hatà, ànhananàhrà ro komo, thenyehra rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Taa. Kafahnaw hona nahatakatxownà hatà. Ahatakatxhenye, Petru hyaka nomohtxownà hatà, toto komo. Txenyeru yahosnye ro komo rma mokyam nehxatxkon hatà, Khoryenkom màn yonyhoryetxho rma yahosnye ro kom hatà. Onà wyaro nketxkon hatà, Petru wya. Txenyeru yàmpàra naye, ahananàhnye komo, ketxkon hatà. Khoryenkom màn yonyhoryetxho rma yàmpàra naye, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Àhà, nàmyaha, kekon hatà, Petru, àwyanye. Taa. Bàn yaka harha tàtotxhe, Txesusu yonyey hatà. Petru rwonàmpàra ro rma haka, Txesusu htxero nàrwonàmye hatà. Onà wyaro nkekon hatà, àwya. Semawu y, kekon hatà. Onok komo wya ryhe, amna txenyerunu tàmtxoko, ketxowà, owto yoh komo, tàmryenon komo wya katà, anaro ro komo wya haxa katà, tànarymatxhàyamo wya rma katà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Anaro ro komo wya ryhe àro wyaro nketxow hamà, kekon hatà, Petru. Owto yoh txenyerun komo yàmyatxow hamà, anaro ro komo, ànarymatxhàyamo, kekon hatà. Àna hamà, kekon hatà, Txesusu. Àro ke, txenyeru yàmpàra natxhe, àmryenon komo, owto yoh komo wya. Àro wyaro rma rha, txenyeru tàmko, romàn yonyhoryetxho, kahra naha, royàmà, rowya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wàmyan mak hamà, àwyanye, atxke manaha tawro hona. Àro ke, txenyeru tàmtaha, ronàmrà rma, onàmrà xarha, àwyanye, kekon hatà, Petru wya. Onà wyaro ryhe ehorko. Tuna ymo yohokoso àtoko. Musu marymehe ha, tuna kwaka, kekon hatà. Owya kana yanàmàtxhe rma, towenyxa anàmàtxhe rma, àmtarà menyaha ha. Àmtawo rma menyaha, txenyeru, 2 me, ronàmrà rma, onàmrà xarha, kekon hatà. Àrotho rma màmyaha ha, txenyeru yahosnye ro komo wya, kekon hatà, Txesusu, Petru wya. ");
INSERT INTO hixNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Bàn yawo rma hak Txesus yehtoko, àhyaka nomohtxownà hatà, ànhananàhrà ro komo. Onokà ryhe, ehonomnà me nyhe naye, Khoryenkomo mryenonà, ketxkon hatà. Onokà ryhe, anar komo Khoryenkomo mryenon komo yoho nyhe naye, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Bàryekomo txko yanyekye hatà, Txesusu. Amrakatakanye neryey hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Mosonà txko xenytxoko, kekon hatà, àwyanye. Onà wyaro yaworo xaxa àkehe, owyanye. Anar me harha ehtxoko, ohnawonye. Norohnàtho me harha osonytxoko. Mosonà txko wyaro rma osonytxoko, kekon hatà. Ehonomnà me rma oyosonyetokonye, Khoryenkomo mryenon mehra ro mak manatxhe ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mosonà txko wyaro norohnàtho me oyosonyetokony haxa ryhe, ehonomnà me rma haxa manatxhe, noro wya. Noro mryenon komo yoho nyhe, ehonomnà me manatxhe, norohnàtho me oyosonyàr komo ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Bàryekomo txko komo ewakryetxoko, kekon xarha tà, àwyanye. Rox oyehtokonye, ewakryetxoko. Owyanye ewakryentokonye rma, uro rma mewakryetxhe, kekon hatà, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Tanhàn hokon me harha bàryekomo yeryhera mak ehtxoko. Rohona xenyetho komo rma yeryhera mak ehtxoko, tanhàn hokon me harha. Àro hokon me harha owyanye txenyetokonye, ohxehra ro mak manatxhe hampànà, kekon hatà. Àro wyaro txeryhera ronye rma awayehnàtokonye, ohxe oyesnàràtho kom haryhe. Tuna kwaka ononàtokonye, ohxe oyesnàràtho kom haryhe. Tohu ymo ke amusmexah me ononàtokonye, àro wyaro rma awayehnàtokonye, ohxe oyesnàràtho kom haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tanhàn hokon me texem me natxow hamà, toto komo, kekon xarha tà. Àro hoye ro tanàhnohsom me natxow hamà. Àro hokon me txenyetho komo ryhe, tanàhnohsom me rma haxa natxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Anatoko ayanhàn kom hoko manatxow hana, ayamor kom ke hana, ohror kom ke haxa hana, kekon xarha tà. Onà wyaro haxa katxoko. Amohra hak wehxe, àhrohra hak wehxe, ranhàn hokohra harha ryehtxoho me, katxoko, kekon hatà. Tamoke rma oyehtokonye, tàhroke rma oyehtokonye, tarymaxem me manatxhe hampànà, eryewhamnohno ytxoho ro na, weheto ymo wyaron hona, ewehpànà ro ymo wyaron hona, ayanhàn kom hoko oyesnàr kom ke, kekon hatà. Amohra haxa oyehtokonye, àhrohra haxa oyehtokonye, ohxe rma manatxhe, karyhe roro harha oyesnàr kom ke, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Àsok haxa hana mehohketxow ha, ayanhàn kom hoko. Mehohketxow hamà, oyonur kom ke mak ha, kekon hatà. Onà wyaro haxa katxoko. Enhura hak wehxe, ranhàn hoko ehohkahra harha ryehtxoho me, katxoko, kekon hatà. Tonke rma oyehtokonye, tarymaxem me manatxhe hampànà, eryewhamnohno ytxoho ro na, weheto ymo wyaron hona, oyonur kom ke atxke oyesnàr kom ke, kekon hatà. Enhura haxa oyehtokonye, ohxe rma manatxhe, karyhe roro harha oyesnàr kom ke, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Onà wyaro kahra xaxa mpànà ehtxok ha, bàryekomo txko kom hoko, kekon xarha tà. Norohnàtho me nay hamà, akoronomahra wehxan hamà, kahra xaxa mpànà ehtxok ha, àhokonye. Onà wyaro àkehe, owyanye. Nyamoro yakoronomanye ro me natxhe, kahe yawon komo, royàm yanoto komo, kekon hatà. Royàmà hyawo roro natxhe, bàryekomo yakoronomanye ro komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Àsok tawro hana. Enyhoruhnu rotho komo yonyhoryexe komokye, Toto me Enusah kaxe. Tanàhnohsomà rotho komo rma yonyhoryexe komokye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Okno yonye ro komo wyaro, bàryekomo txko komo yonye ro me naha, royàmà. Àsok hana toknàthàyamo yohoryatxow ha, okno yonye ro komo, kekon hatà. Àwaymamsahotho rma yohoryatxow hamà. Ehorhàra kat natxowà, owyanye. Nehoryatxow hamà, kekon hatà. 100 me toknà komo yehtoko, 99 komo nomyatxow hamà. Àhà ymo ho rma nànomyatxow hamà, towenyxanotho txko yohonàr horà, àwaymamsahotho txko yohonàr horà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Onà wyaro yaworo xaxa àkehe, owyanye. Tàwyanye xenyetxhe rma, teryehorye rma haxa natxow hamà. Àwaymampàn kom hoko teryehotatho komo yoho rma haxa neryehotetxhe ro mak ha, àwaymamsahotho hoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Àro wyaro rma rha, bàryekomo txko komo yonyhoryenàr xe rma haxa naha, royàmà, kahe yawono. Tanàhnohsom me esnàr komo xehra ro mak naha ha, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Onà wyaro nkekon hatà, Txesusu, tànhananàhrà ro komo wya. Oyowtà wya owàràhyakantokonye, anhànà ekarymatxoko, àwya, kekon hatà. Wahoro htxero omoro ro àtoko, àhyaka. Anhànà ekarymako, àwya, anar komo nenytxahtor me mak ha, kekon hatà. Tàwya oyonytxantoko rma, yaworo noskarymen hamà, noro ha. Toskarymatxhe rma, towahke harha nay hamà, ohoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Oyonytxahra rma ehtok haxa, àtok xarha, àhyaka. Anar komo arko, ayakoro. Towenyxan hana, asakon kom haxa hana, nyamoro rma arko ha, kekon hatà. Nyamoro rma hak àrwonà yonytxatxowà, amnye yaworo tàwyanye ekarymatxho me. Nyamoro hak hananàhtxow xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nyamoro yonytxahra noro yehtoko, ekarymako, tohsamnohsomà ro komo wya, Khoryenkomo mryenon komo wya, kekon hatà. Omeroron komo yonytxahra rma tehtoko, axanhàn me rma nay hamà. Khoryenkomo mryenon mehra harha noro xenytxoko, kekon hatà. Khoryenkom hutwanyehnà komo wyaro harha noro xenytxoko. Atxke natxhe moxamo katxho komo wyaro harha noro xenytxoko, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Onà wyaro yaworo xaxa àkehe, owyanye, kekon xarha tà. Rano me ryhe, onà wyaro màketxhe, omnyamo, toto komo wya. Khoryenkomo mryenon mehra harha manatxhe hampànà, màketxhe, anar komo wya, rano me mak ha, kekon hatà. Àro wyaro rma màketxhe, omnyamo, yukryeka hon komo rma. Àro wyaro rma rha àkehe, uro xarha, kahe yawono, nyamoro hoko, kekon hatà. Khoryenkomo mryenon mehra harha hak nahtxoko, nyamoro ha, ranoto komo rwon yawo ro mak ha, àkehe uro, kahe yawono, kekon hatà. Khoryenkomo mryenon me mpànà manatxhe ha, màketxhe xarha, anar komo wya, rano me rma rha. Àro wyaro rma màketxhe, omnyamo, yukryeka hon komo rma. Àro wyaro rma rha àkehe, uro xarha, kahe yawono, nyamoro hoko, kekon hatà. Khoryenkomo mryenon me hak nahtxoko, nyamoro ha, ranoto komo rwon yawo ro mak ha, àkehe uro, kahe yawono, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Onà wyaro xarha àkehe, owyanye, kekon xarha tà, Txesusu. Khoryenkom yakoro orwonàmpàra ronye rma haka, osonytxatxoko, anaro oyowtà yakoro. On hoko ryhe tàrwonàmnye, kahe yawon yakoro, àwya koyuhtoho me, katxoko, omnyamo rye rma, yukryeka hon komo rma, kekon hatà. Àro hoko rye rma orwonàmàtxhenye, oyoyukyatxhe xaxa mak hampànà, royàmà, kahe yawono, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Romryenon me oyohsamnohnàtokonye, awawonye wehxaha. Yakehra manatxow hana, asak hana, osorwaw haxa hana. Yakenohnà kom wawo rma wehxaha. Àro ke, oyoyukyatxow hamà, royàmà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Txesusu hyaka nomokye hatà, Petru. Rohà y, kekon hatà. Anatoko yake ro rowàràhyaken hana, rowtà. Noro hoko rma koseryewhoken hamà, towahke ryehtxoho me, kekon hatà. Twahake koseryewhokeno, yake ro katà, yake rohra haxa katà, kekon hatà, Petru. ");
INSERT INTO hixNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yake rohra oseryewhokako, noro hoko, kahra wehxaha, owya, kekon hatà, Txesusu. Onà wyaro haxa àkehe. Yake ro oseryewhokak mak hampànà, oyowtà hoko, atàknahnà ro me mak ha, kekon hatà, Txesusu, Petru wya. ");
INSERT INTO hixNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Àro hoko rma kuknonano me wekarymen hamà, kekon xarha tà. Àsok hana noseryewhoken ha, Khoryenkom ha, tàmryenon kom hoko. Noseryewhoken hamà, ukukur kom hoko. Oseryewhokahra mak naha, anar kom hoko. Nyamoro rma, owto yoh yanoto wyaro atxke natxow hamà, kekon hatà, Txesusu. Àsok hana nehxakon ha, owto yoh ha. Onà wyaro nehxakon hatà. Tanoto komo wya tàtxenyerunu yehemanàr xe nehxakon hatà. Nyamoro rma nehetàhketxkon hatà, àwya. Àro ke nanyehtxownà hatà, owto yohà, tàhyaka, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wahoro htxero nomokye hatà, anoto. Noro rma, thenyenohnà ryhe yehetàhkekon hatà, owto yohà wya, 10.000 txenyeru ymo rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ehemahra ro mak nehxakon hatà, àtxenyerumra tesnàr ke, kekon hatà, Txesusu. Àro ke, onà wyaro nkekon hatà, owto yohà, tanoto komo wya, anar komo wya. Mosonà ehemanyehnàtho ymo xak tàmtxoko, anar komo wya, kekon hatà. Anar komo yanoto me harha tàmtxoko, txenyeru hona, kekon hatà. Àhetxenhàrà xarha, àhokuthuyamo xarha, àkatxhothàrà xarha, omeroro rma tàmtxoko, txenyeru hona, kekon hatà. Àro wyaro rma rotxenyerunu wahohsan hamà, kekon hatà, owto yohà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Àro wyaro tàwya enytxatxhe rma, akrataka neryewtay hatà, anoto, tosoknar ho hatà. Teryewrye ro nàrwonàmye hatà, owto yoh yakoro. Anar komo wya rompàra nyhe rma exko, kekon hatà. Mexe nyhe txko hak àmomohko, rowya ehematxho, kekon hatà. Mexe nyhe txko ehxah me wehematxehkehe, omeroro, owya, kekon hatà, anoto, owto yohà wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Àro ke, àhnàn yawo rma haxa nehxakon hatà, owto yohà. Noseryewhokay harha tà, tanoto hoko. Towahke harha nehxakon hatà, àhoko. Ehemahra rma exko, kekon hatà, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Owto yohà hyaye toy hatà, anoto. Tàtonàr me rma, tkukuru yonyey hatà. Owto yoh yanoto rma rha noro hatà. Norotho rma yahosày hatà, àhmàwo, kekon hatà, Txesusu. Rotxenyerunu tàmko yxak ha, omoro, kekon hatà, àwya. Àro wyaro nkekon hatà, àwya ehetàhkanàr ke hatà. Yakenohnà rma yehetàhkekon hatà, 100 txenyeru rma hatà. Rotxenyerunu tàmko yxak ha, kekon hatà, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Àro ke neryewtay hatà, norotho, tosoknar ho. Teryewrye ro nàrwonàmye hatà. Mexe nyhe txko hak àmomohko, rowya ehematxho, kekon hatà. Mexe nyhe txko ehxah me wehematxehkehe, omeroro, owya, kekon hatà, norotho, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Àna matà, àmomokhàra mak wehxaha ha, kekon hatà. Àro ke nahryemye hatà, watxa ymo yaka, ehemahra esnàr ke. Àro yawo roro rma exko yxak ha, owya ehemahra ro rma haka, kekon hatà, noro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nenytxownà mak hatà, anar komo, owto yoh yanoto kukur komo. Watxa ymo yaka tkukuthuyamo yahryemnyàrà yonytxownà hatà. Noseryehoketxkon hatà, thenyehra hatà. Àro ke totxownà hatà, owto yohà hyaka. Omeroro nekarymatxehkatxownà hatà, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ewakhàra nehxakon hatà, owto yohà, tanoto hoko. Àro ke nanyekye hatà, tàhyaka. Ranoto y, atxke rma haxa manay hamà, kekon hatà, àwya. Thenyenohnà ymo mehetàhkeko, rowya. Koseryewhokan haxa hawe, ohoko, kekon hatà. Ehemahra rma exko àkan haxa hawe, owya, teryewrye ro orwonàmrà ke, kekon hatà, owto yohà. ");
INSERT INTO hixNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Anaro hnàn yawohra mak mahko hatà, omoro, kekon hatà. Noro hoko oseryewhokahra ro mak mahko hatà, kekon hatà. Ohnàn yawo rma haxa wahko, uro. Àro wyaro rma rha, noro hnàn yawo tehxorye mahko haryhe, kekon hatà, owto yohà, tanototho wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Norotho yarhoy hatà, watxa ymo yonye ro komo hyaka, anàhnohno ynye ro komo hyaka. Àhyakanye narhoy hatà, tanoto komo wya, ewakhàra rma haxa tesnàr ke. Watxa ymo yawo roro rma hak nahko, tàwya ehematxehkahra ro rma haka, kekon hatà, owto yohà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Owto yohà wyaro rma rha naha hampànà, royàmà, kahe yawono, ohokonye, kekon xarha tà. Ohnawonye oyowtà hoko oseryewhokahra oyehtokonye, oseryewhokahra rma rha naha hampànà, royàmà, ohokonye. Ayanàhnohyatxhe mak hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Àro wyaro tàwya àhananàhtàkatxhenye, toy hatà, Txesusu, Karyeryeya yamtar hoye. Xukneya yamtar hona haxa nahatakay hatà, Xoknaw mon hona. ");
INSERT INTO hixNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Akoro rma tetxkon hatà, toto komo, thenyenohnà komo. Àsna nohsamnohtàketxkon hatà. Àto rma ekehàtho komo yonyhoryekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Àhyaka nomohtxownà hatà, Farysew kukur komo. Noro kukmanàr xe nehxatxkon haryhe tà, enkukmanàr horà. Onà wyaro nketxkonà rma haryhe tà, àwya. Khetxenhàrà hyaye kotowtoho, ohxe naye, ohxehra kat naye, owya, ketxkon hatà. Eten hoye ro haxa katà totowyano, khetxe hyaye, kekon hatà, Farysew komo. ");
INSERT INTO hixNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Neyuhtxownà hatà, Txesusu. Onà wyaro nkehe, Khoryenkom karyehtanà, àmenhosahonhàrà, kekon hatà. Amnyehra, tàwya toto yakàhtontoko, kàrà me, wos me xarha, nakàhtoye, Khoryenkomo, kehe. Àro wyaro uhutwahra kat manatxowà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Àro wyaro tàwya akàhtotxhe rma, onà wyaro nkekon hatà, Khoryenkomo. Àro wyaro toto wakàhtono, kàrà, wosà, àro ke, toto hak tàyàmànhàyamo hnànkano, thetxe hyawo roro harha tehtxoho me, kekon hatà. Àro wyaro mpànà naha ha, toto, wos yakoro. Asakononhàyamo, towenyxano wyaro harha mpànà naha ha, kekon hatà, Khoryenkomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Àro wyaro natxow hamà, toto komo, thetx kom yakoro. Asako ehxera harha natxhe, Khoryenkomo nenyàr me. Towenyxano wyaro harha natxhe, kekon hatà. Khoryenkomo ryhe, osomryeno ynye me naha. Àro ke, onà wyaro kahra hak nahtxoko, toto komo. Totowyatxow hamà, khetxenhàyamo hyaye, kahra hak nahtxoko, osomryeno ynye me Khoryenkomo yesnàr ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Onà wyaro haxa kàyweronàhyamatxownà hatà, Moyses heno, ketxkon mak hatà, Farysew komo. Ohetxenhàyamo hyaye oyotownàtokonye, akaryehtan komo àmenhotxoko, kekon heno hatà. Kotowyaha hampànà, ohyaye, katxoko, owyanye àmenhonàr me, kekon heno hatà. Àro wyaro owyanye àmenhotxhe rma, motowyatxhe, ohetxenhàyamo hyaye, kekon hatà, Moyses heno, ketxkon hatà, Farysew komo. Àsok tawro àro wyaro kàyweronàhyamatxownà, ketxkon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Àro wyaro kàyweronàhyamatxownà, ohnawonye atxke rma haxa oyesnàr kom ke, ohetxenhàyamo hyaye oyotowrà komo xe rma haxa oyesnàr kom ke, kekon hatà, Txesusu. Amnyehra haxa, tàwya toto yakàhtotxhe, noro yotowrà xehra ro mak nehxakonà, Khoryenkomo, thetxe hyaye. Àro wyaro oyesnàr komo xe roro rma naha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Onà wyaro àkehe, owyanye, kekon xarha tà. Ohetx komo hyaye otowhàra ro mak ehtxoko. Àhyayenye oyotownàtokonye rma, anaro wos yahohsàra ro mak ehtxoko, kekon hatà. Owyanye anaro yahosnàtoko rma, atxke manatxhe, ohetxe ro kom mehra noro yesnàr ke mak ha. Anatoko, anaro kàrà hoko nay hana, ohetxe. Anaro hoko ehxaho hyaye rma oyotownàtokonye, ohxe rma manatxhe, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Onà wyaro nketxkon hatà, ànhananàhrà ro komo, Txesusu wya. Krawame rma haxa kotowtoho komo nay hamà, ketxkon hatà. Àhehnà ro me kehtokonye, ohxe haxa tehxatxow hamà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Àhehnà ro me tesnàr komo xe natxow hamà, anar komo, kekon hatà, Txesusu, àwyanye. Nyamoro rma yakoronomehe, Khoryenkomo, àhehnà ro me ehtxoho menye. Anar kom haxa ryhe, àhehnà ro me tesnàr komo xehra ro mak natxhe. Àro ke hehtetxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Àsok hana natxow ha, anar kom ha. Anar komo, wos kukmanyehnà ro me natxow hamà, ahoxemnà ro me tonunur komo ke. Àro wyaron komo rma, àhehnà ro me natxow hamà, kekon hatà. Anar komo, wos kukmanyehnà ro me natxow hamà, toto komo wya tanyyeheryamanàr komo ke. Àro wyaron komo xarha, àhehnà ro me rma rha natxow hamà, kekon hatà. Anar kom haxa ryhe, tano me ronye rma àhehnà ro me natxhe, Khoryenkomo mryenon me tesnàr kom ke mak ha. Khoryenkom hoko roro tesnàr komo xe natxhe, nyamoro ha. Wos hoko tesnàr komo xehra mak natxhe, Khoryenkom hoko roro tesnàr kom horà. Àro ke, tano me ronye rma àhehnà ro me natxhe, kekon hatà. Àro wyaro oyesnàr komo xe oyehtokonye, àhehnà ro me rma ehtxoko, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Thokyamo txko yokyatxkon hatà, toto komo, Txesusu hyaka. Mosonà txko hona ayamorà txeryko tawro xe nehxatxkon hatà, àwya. Mosonà txko hoko orwonàmko, Khoryenkom yakoro, tawro xe nehxatxkon xarha tà, àwya. Horohkatxownà mak hatà, Txesusu nhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nekhotxownà rma hatà, Txesusu, tàhyaka. Bàryekomo txko kom hak nomohtxowà, rohyaka, kekon hatà, tànhananàhrà ro komo wya. Àhorohkahranye ehtxoko. Moxamo txko wyaron komo ryhe, Khoryenkomo mryenon me natxhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tamorà yeryey hatà, àhonanye. Taa. Àsnye ro toy hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Txesusu hyaka nomokye hatà, toto, tkatxhonkemà. Khananàhnye y, kekon hatà. Àsoke ryhe ohxe wehxano, karyhe roro harha ryehtxoho me, kekon hatà. Eten hok haxa ryhe wehxano, enyhoru hoko, kekon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Àsok tawro enyhoru màken harha, rowya, kekon hatà, Txesusu, àwya. Towenyxano ryhe enyhoru me naha. Khoryenkom marma enyhoru me naha, kekon hatà. Karyhe roro harha oyesnàr xe oyehtoko, kàyweronàhyamatxho kom yawo ro exko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Àsok katxho yawo ro ryhe wehxano, kekon hatà, noro ha. Toto yotahahra ehtxoko katxho yawo ro rma exko, kekon hatà, Txesusu. Anar komo hetx hokohra ehtxoko katxho yawo ro xarha, toto katxho yarhàra ehtxoko katxho yawo ro xarha, toto hoko àtemarontahra ehtxoko katxho yawo ro xarha, ");
INSERT INTO hixNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","toyuhsom me xenytxoko, oyàm komo, oyon komo xarha, katxho yawo ro xarha, osox oyehtxoho wyaro ohoyen komo xe xaxa ehtxoko katxho yawo ro xarha, àro wyaro katxho kom yawo ro rma exko, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Àro wyaro katxho kom yawo ron uro, kekon hatà, noro ha. Àsok xarha wehxano, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ohxe roro oyesnàr xe oyehtoko, onà wyaro xaxa mpànà exko ha, kekon hatà, Txesusu, àwya. Akatxhothàrà tàmko, omeroro, txenyeru hona. Txenyeru rma tàmko xarha, toto komo wya, àkatxhomnà komo wya, ànyahpàn komo wya, kekon hatà. Àro wyaro exko hampànà, kahe yawo towakryexem me oyehtxoho me. Àro wyaro oyexetxhe rma, rakoro omok ha, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Àro wyaro tàwya enytxatxhe rma, nekhokay mak hatà, noro ha, tkatxhonke rma haxa tesnàr ke. Ekhokaxaho rma toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Onà wyaro nkekon hatà, Txesusu, tànhananàhrà ro komo wya. Onà wyaro yaworo xaxa àkehe, owyanye, kekon hatà. Tkayaryet kom me Khoryenkomo hutwahra natxow hamà, tkatxhonkem komo. Krawame mak natxhe, noro mryenon me harha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Arkurya yowtarà txko yarye àtohra nay hamà, kameru ymo. Krawame rma haxa nay hamà, àtotho, hory me ymo esnàr ke, kekon hatà. Àro yarye noro totho yoho rma haxa krawame natxhe, tkatxhonkem komo, Khoryenkomo mryenon me harha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Àro wyaro tàwyanye enytxatxhe rma, noseryehoketxkon hatà, ànhananàhrà ro komo, thenyehra rma haxa mak hatà. Àsok tawro harha, ketxkon hatà. Tonyhoryexem komo ehxera natxow hamà. Àsoken kom katà tonyhoryexem me natxowà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nenytxehkatxownà hatà, Txesusu. Onà wyaro nkekon hatà, àwyanye. Tonyhoryetxho kom hoko tehnyaxem me natxhe ha, toto komo, kekon hatà. Khoryenkom haxa ryhe, ehnyahnà ro me mak naha ha. Ehonomnà xaxa kax mak naha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Onà wyaro nkekon hatà, Petru, àwya. Amna ryhe, amna yomyawonotho nànomye, ayakoro amna totho me, kekon hatà. Àsoke ryhe towakryexem me amna naye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Onà wyaro yaworo xaxa àkehe, owyanye, kekon hatà, Txesusu. Towakryexem me rma haxa manatxhe hampànà. Amnye, toto komo kayaryet me romokàtxhe rma, ehonomnà me xaxa keryewtehe hampànà, rahonà ymo hona, Toto me Enusah kaxe, kekon hatà. Ehonomnà me rma rha meryewtetxhe, rohyawo, omnyam xarha, rakoro tàtosomà rotho komo kaxe. 12 me ayahonà ymo kom hona meryewtetxhe. Eryewtaxaho rma, Ehsayewyana komo màwahanonketxhe, atxke manatxhe tawro me, ohxe manatxhe tawro me xarha. Àro wyaro rma towakryexem me manatxhe, amnye ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Àsok hana natxow ha, romryenon kom ha. Rox tehtxoho kom hoye ro onà wyaro natxow hamà. Anatoko bànàthàyamo nomyatxow hana, kekon hatà. Anatoko towtànhàyamo nomyatxow hana. Anatoko twosànànhàyamo nomyatxow hana. Anatoko tàyàmànhàyamo nomyatxow hana, kekon hatà. Anatoko thokuthuyamo nomyatxow hana. Anatoko towtothàyamo nomyatxow hana. Omeroro rma nànomyatxow hana, romryenon komo, rox tesnàr kom ke mak ha, kekon hatà. Nyamoro rma, towakryexem me rma haxa mpànà natxhe ha. Amnye rma, tano rma hak tehtokonye, thenyehra towakryexem me mpànà natxhe ha. Amnye xarha, karyhe roro mpànà natxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Àsok tawro hana, kekon xarha tà. Anar komo yosnakan uro kany komo ryhe, wahoro htxero towakryexem me natxhe hampànà. Anar komo yohon uro kany kom haxa ryhe, mahtuk me towakryexem me natxhe hampànà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kuknonano me nàrwonàmye xarha tà, Txesusu. Àsok hana akayaryet kom me nay ha, Khoryenkom ha, kekon hatà. Anotomano ynye wyaro nay hamà. Onà wyaro nehxakon hatà, horykomo, tanoto kom hoko. Enmahrà ro toy hatà, tanoto kom horà, tànatàr hokon kom horà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tàwya nyamoro yonyetxhe, nànyahtxownà hatà, tànatàr waka, àhoko ehtxoho menye. Ronatàr hoko atamohtxoko, amnye rma, kekon hatà. Àkokmamàtxhe, 1 txenyeru wàmyaha, owyanye, ayatamoketxhet komo, kekon hatà. Àna hamà, 1 txenyeru màmyan hamà, amna wya, ketxkon hatà, nyamoro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Àro rma ho, kamàmà yasawnuknutoko rma, anar komo yonyey hatà. Owto rakatawo nehxatxkon hatà, àhokohra mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Omnyam xarha, ronatàrà waka àtotxoko, àhoko oyehtxoho menye, kekon hatà, àwyanye. Àkokmamàtxhe, ayatamoketxhet komo wàmyaha, owyanye, kekon hatà, horykomo. Àro ke totxownà hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kamàmà thataw ehtoko, anar komo yanotomay xarha tà. Àro wyaro rma rha, kokonye ehtoko, anar komo xarha yanotomay hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Awanaka haxa anar komo yonyey hatà. Àhokohra nehxatxkon hatà. Àsok tawro àhokohra mahtxoko, amnye rma, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Amna yanotomahra nahtxoko, anar komo, ketxkon hatà. Àro ke àhokohra amna nahko, ketxkon hatà. Omnyam xarha, ronatàrà waka àtotxoko, àhoko oyehtxoho menye, kekon hatà, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kokmamtàhkay hatà. Àkokmamàtxhe rma, onà wyaro nkekon hatà, horykomo, tanoto komo yohà wya. Atamohxemotho komo anyehko, owya àtxenyerun komo yàmtoho me, kekon hatà. Wahoro htxero, mahtukme atamohxemotho komo wya ehemako, atamoketxhet komo. Mahyakanye, wahoro atamohxemotho komo wya ehemako, kekon hatà, horykomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Àro ke nehemay hatà, àwyanye. Awanaka omohxemotho komo wya htxero nehemay hatà. 1 txenyeru yàmye hatà, àwyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Enmahrà ro omohxemotho komo nomohtxownà haxa hatà. Onà wyaro nehutwetxkon hatà, nyamoro ha. Tkokmamnohtxowà, àro ke eho nyhe nehemen hamà, kàwyanye, ketxkon hatà, tàwyanye rma. 1 me rma rha nàmye hatà, àwyanye xarha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Àro ke nàrwonatxkon hatà, nyamoro ha, horykomo hoko. Onà wyaro nketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Anar komo wya ehematxho wyaro rma rha meheman hamà, amna wya xarha, ketxkon hatà, àwya. Nyamoro ryhe, mexehra natamohtxowà. Amna haxa ryhe, enmahrà ro amna natamoknyo, tkokmamnohso ro. Kamàm nawo rma haxa amna nahko, tamotohso ro. Àsok tawro eho nyhe tàmpàra mahko, amna wya, ketxkon hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Onà wyaro nkekon hatà, horykomo, ukukur komo wya. Hoymo y, oyonkuhtohra ro mak wahko, kekon hatà, àwya. 1 txenyeru wàmyaha, owyanye, àkan haxa hawe, owyanye, kekon hatà. Àna hamà, 1 txenyeru màmyan hamà, amna wya, màkatxowà, rowya. Àro wyaro kahra kat mahtxoko, kekon hatà, horykomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Ahohtxoko rma, ayatamoketxhet komo, 1 txenyeru rma, kekon hatà. Àme rye rma tàmrà xe wehxaha, owyanye, nyamoro wya xarha, kekon hatà. Rano me rohra kat wàmyano, rotxenyerun hoye, kekon hatà. Thenyehra rowya tàmnàtoko, ohxehra kat wehxano, owyanye, kekon hatà. Ahohtxoko rma. Owyanye ahosàtxhe rma, àtotxoko, kekon hatà, horykomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Àro wyaro rma rha, àme rye rma tàmryenon komo yowakryehe, Khoryenkomo, kekon hatà. Àro wyaro rma rha, anar komo yosnakan uro kany komo ryhe, wahoro htxero towakryexem me natxhe hampànà. Anar komo yohon uro kany kom haxa ryhe, mahtuk me towakryexem me natxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Xerusaryen hona tetxkon hatà, Txesus komo. Tàtonàr kom me, tànhananàhrà ro komo yarày hatà, Txesusu, toto komo hyaye. 12 komo rma yarày hatà. Asama yarye tàtontokonye rma, onà wyaro nkekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Xerusaryen hona tàtetxow hamà, kekon hatà. Tahohsosom me mpànà naha ha, Toto me Enusaho, Xuknewyana yoh komo wya, Khoryenkom màn yonye ro yoh komo wya, àyweronàhyamano ynye ro komo wya xarha. Nyamoro ryhe, twayehkahorye naha ketxhe hampànà, noro hoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nahohsetxhe xarha hampànà, Xuknewyanahnà komo wya. Nyamoro rma newnohyatxhe hampànà. Nàhpokyatxhe xarha hampànà, kekon hatà. Yahkotohen hona namoyathetxhe xarha hampànà. Twayhàtxhe, nasanàmyaha harha hampànà, noro ha. Osorwawo ro enmahàtxhe, nasanàmyaha harha hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Txesusu hyaka nomokye hatà, Txaku yonà, Xowaw yonà rma. Sekmeknew muru komo rma nyamoro ha, Txaku komo. Nyamoro yakoro rma nomokye hatà, àyon komo, Txesusu hyaka. Noro yakrataka neryewtay hatà, tosoknar ho, ehonomnà me tàwya xenyàr ke. Nàrwonàmye hatà, akoro. Uro enytxako, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Eten xe manaye, kekon hatà, Txesusu, àwya. Eten xe manaye. Onà wyaro neyukye hatà, wosà. Toto komo kayaryet me mosonyhen hatà, amnye ha, kekon hatà. Ehonomnà me xaxa mosonyhen hatà. Ehonomnà me rma rha romryerà komo yenyàr xe wehxaha, owya, kekon hatà. Toto komo kayaryet me harha oyehtoko, onà wyaro kasko, moxamo wya, romryerà komo wya. Rohanaka eryewtatxoko, omoro howehehra, omoro xarha howehe, kasko, àwyanye, owyaro rma rha ehonomnà me ehtxoho menye, kekon hatà, Txaku komo yonà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Onà wyaro haxa neyukye hatà, Txesusu. Àna matà, rohanawo toto yehtxoho hutwahra ro mak manaha ha, kekon hatà. Rowyaro rma rha eryewhamnohxemo komo ryhe, ehonomnà me harha natxhe hampànà, rohanaw harha, kekon hatà, wosà wya. Ryeryewhamtoho wenàmtàhkehe hampànà, kekon hatà, Txaku komo wya. Toto wya twokru yontàhkantokono wyaro, ryeryewhamtoho wenàmtàhkehe hampànà. Rowyaro rma rha katà menàmtàhketxowà, oyeryewhamtoho komo, kekon hatà. Àhà, amna nenàmtàhkehe, ketxkon hatà, Txaku komo. ");
INSERT INTO hixNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yaworo màketxhe, kekon hatà, Txesusu. Rowyaro rma rha oyeryewhamtoho komo menàmtàhketxhe hampànà. Enàmtàhkanyenhàrà rma yeryhera mak wehxaha, uro, ehonomnà me harha, rohanaka harha, kekon hatà. Àsok tawro hana. Royàmà nwahanonkatxho komo ryhe, rohanaka texem me natxhe hampànà, kekon hatà, Txesusu, Txaku komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tàwyanye Txaku komo rwonà yonytxatxhe rma, ewakhàra nehxatxkon hatà, ukukur komo. Txesusu nhananàhrà ro komo rma rha nyamoro ha, 10 komo rma. Tkukur kom hoko, 2 kom hoko rma, ewakhàra nehxatxkon hatà. Kohonye nyhe ehonomnà me tesnàr komo xe natxow hamà, moxamo, ketxkon hatà, Txaku kom hoko. ");
INSERT INTO hixNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tàhyaka haxa nanyehtxownà hatà, Txesusu. Onà wyaro nkekon hatà, àwyanye. Àsok hana natxow ha, toto kayaryet kom ha, anaro rha yana kayaryet kom ha, kekon hatà. Ehonomnà me rma haxa natxow hamà, tàmryenon komo yoho rma haxa mak ha. Tàmryenonàthàyamo rma yanotometxow hamà, ehonomnà komo. Tanàhnohso ro nanotometxow hamà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Omnyam haxa ryhe, nyamoro wyarohra mpànà ehtxoko. Ehonomnà me oyesnàr komo xe oyehtokonye, okukur komo yanoto me xaxa mpànà ehtxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Àro wyaro rma rha wehxaha, uro, Toto me Enusaho. Anotomano ynye mehra mak komokye. Toto komo yanoto me haxa ryhe komokye, kekon hatà. Toto komo yonyhoryeny me ryhe komokye. Rano me ro rma kwayehyaha hampànà, rowya enyhoryetxho menye. Anhàn komo hyaye towtoho komo wehemehe, rowayehrà ke, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Taa. Xeryko hoye tetxkon hatà, Txesus komo. Akoronye tetxkon hatà, toto komo, thenyenohnà komo. ");
INSERT INTO hixNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Asama yahetawo nehxatxkon hatà, toto, asako. Enhunu ro rma mokyam nehxatxkon hatà. Tàhyahanye Txesusu tonàrà yonytxatxownà hatà. Àro ke nàrwonàmtxownà hatà, teryewrye ro. Ha y, ketxkon hatà, Dafe heno yohamàtho omoro hatà. Amna hnàn yawo exko, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Neytxownà mak hatà, toto komo. Tatàknye ehtxoko, ketxkon hatà, àwyanye. Tatàknye ehtxoko. Thenyehra nàrwonatxkon hatà, enhunu ro komo, teryewrye ro rma haxa mak hatà. Amna yohà y, Dafe heno yohamàtho omoro hatà. Amna hnàn yawo exko, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kràk, horohye hatà, Txesusu. Nanyehtxownà hatà, tàhyaka. Àsok oynyàr komo xe manatxowà, rowya, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Amna yohà y, amna yontanàhrà xe amna naha, owya, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Àhnàn kom yawo rma haxa nehxakon hatà, Txesusu. Àro ke, enur komo yahey hatà. Àwya ahetxhe rma, tonke harha nehxatxkon hatà. Noro yakoro totxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Xerusaryen hahnohyatxkon hatà, Txesus komo. Owto txko màtkoso nomohtxownà hatà, Betfaxe màtkoso rma hatà. Oryefera yàhàn mahoturu hono rma àro ha, Betfaxe. Àro màhto rma tehtokonye, asako nànyahtxownà hatà, Txesusu. Tànhananàhrà ro kom hoye asako nànyahtxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Onà wyaro nkekon hatà, àwyanye. Owto hona àtotxoko, kekon hatà. Owto hona àtotxoko. Menyatxhe, àro hona, kekon hatà. Ayahatakatxhenye rma, xumentu menyatxhe hampànà. Àmxekrà xarha menyatxhe hampànà. Ewahtosaho rma menyatxhe, kekon hatà. Meweketxhe ha. Xaro mekyatxhe ha, rohyaka, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Àsok tawro meweketxowà ketxow hana, toto komo, owyanye. Onà wyaro meyukyatxhe ha. Kohkomo, moxam xe nay hatà, màketxhe ha, àwyanye. Nyamoro rma, àro wyaro tàwyanye enytxatxhe rma, nekhetxhe hampànà, owyanye, kekon hatà, Txesusu, tànànyaknyàr komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Àro wyaro xumentu yonyxe nànyahtxownà hatà, Khoryenkomo rwonà yokarymanye ro heno nmenhotho yawo ro tehtxoho me. Amnyehra, onà wyaro nmenhoy hatà, noro heno. ");
INSERT INTO hixNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Onà wyaro katxoko, Seyaw hon komo wya. Ohyakanye nomokyaha hampànà, akayaryet komo. Ehonomnà mehra mak nomokyaha hampànà. Xumentu mkakoso atakryexaho rma nomokyaha hampànà. Àmxekrà mkakoso rma atakryexaho nomokyaha hampànà. Àro wyaro rma nmenhoy hatà, Khoryenkomo rwonà yokarymanye ro heno, amnyehra. Ànmenhothàrànhàr yawo ro rma haxa nehxakon hamà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Àro ke totxownà hatà, ànhananàhrà ro komo, asakon komo rma. Txesusu rwonàmàthàr yawo ro nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xumentu yohtxownà hatà. Àmxekrà xarha yohtxownà hatà. Nàmkayamtotxownà hatà, twomun komo ke. Sax, dyerye, àmkakoso natakryey hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Asama yaka twomun komo yatxaraketxkon hatà, toto komo, ukukur komo rma, thenyenohnà komo rma. Àhaya xarha yeryatxkon hatà, anar komo, asama yaka rma rha. Txaray txaray txaray, wewe txaraymetxkon hatà, asama yaka tàwyanye txetxoho me. Àro wyaro rma nehxatxkon hatà, tàwyanye ehonomnà me Txesusu yonyàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Txesusu ywaho tetxkon hatà, anar komo. Noro wenarye tetxkon hatà, anar komo. Thenyehra rma haxa nehxatxkon hatà. Omeroro rma, onà wyaro nketxkon hatà, teryewrye ro hatà. Ehonomnà me xaxa hak nahko, Dafe heno yohamàtho, ketxkon hatà. Kohkom yano me omohsaho ryhe mosonà. Towakryexem me xaxa hak nahko, mosonà, ketxkon hatà. Ehonomnà me xaxa nay hamà, Kohkomo, katxow haka, kahe yawon komo, ketxkon hatà, toto komo, teryewrye ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Àro wyaro Xerusaryen hona nahatakay hatà, Txesusu. Noseryehoketxkon hatà, owto hon komo, omeroro. Onok mokro haryhe, ketxkon hatà. Onok mokro haryhe. ");
INSERT INTO hixNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Khoryenkomo rwonà yokarymanye ro ryhe mosonà, ketxkon hatà, toto komo, Txesus yakoron komo. Txesusu rma mosonà, Nasarye honotho rma, Karyeryeya yamtar honotho rma, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Taa. Khoryenkom màn yaka nowomye hatà, Txesusu. Àto nehxatxkon hatà, twarawantaxemà ro komo. Nukrunyemehtxownà hatà, Txesusu. Ukukur komo, txenyeru yomtakayonomanye ro me nehxatxkon hatà. Àtxenyerun komo rma, warata ho nehxakon hatà. Tax, teryay, waratatho matxakay hatà, Txesusu. Anar komo, watkuku yàmnye ro me nehxatxkon hatà, tahon kom ho eryewtaxemo. Tax, teryay, ahonàthàyamo xarha matxakay hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Onà wyaro nkekon hatà, àwyanye. Onà wyaro nkehe, àmenhosahonhàrà, kekon hatà. Toto komo rwonàmtoho ro me naha, romànà. Àro wyaro rma nkehe, àmenhosahonhàrà, Khoryenkom màn hoko, kekon hatà. Àro rma manàhnohyatxhe harha, omnyamo. Àsok tawro hana, àro yawo rma toto komo txenyerunutho yahosnàr ke, owyanye, temenyem komo wyaro owyanye ahosnàr ke, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Khoryenkom màn yawo rma noro yehtoko, àhyaka nomohtxownà hatà, enhun komo, àhrohnà komo xarha. Nenyhoryetxownà hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Àto rma rha nehxatxkon hatà, Khoryenkom màn yonye ro yoh komo, àyweronàhyamano ynye ro komo xarha. Txesusu wya ekehàtho komo yonyhoryenàrà yonyatxkon hatà. Àro ke ewakhàra nehxatxkon hatà. Bàryekomo txko komo xarha yonytxatxownà hatà. Ehonomnà me hak nahko, mosonà, Dafe heno yohamàtho, ketxkon hatà, bàryekomo txko komo. Nyamoro rma yonytxatxownà hatà, eh komo. Àro hoko xarha ewakhàra nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Onà wyaro nketxkon hatà, Txesusu wya. Moxamo txko rwonà yonytxahra kat manaye. Eyherany kat manaye, ketxkon hatà, àwya. Àna matà, kekon hatà, Txesusu, àwyanye. Khoryenkom karyehtan yawo ro natxow hamà, moxamo. Àhoyeno rma hutwahra kat manatxowà, kekon hatà. Onà wyaro nkehe, àmenhosahonhàrà. Ohxe xaxa manay hamà, kanye ro me natxhe hampànà, bàryekomo txko komo. Apa y, àro wyaro kany me meryatxow hamà, ayano me ro rma. Anar komo rwonàmtoho yoho rma haxa, ohxe rma haxa nàrwonatxhe, bàryekomo txko komo, ayakoro. Àro wyaro rma nkehe, àmenhosahonhàrà. Àro wyaro katxhàrànhàr yawo ro natxow hamà, moxamo, kekon hatà, Txesusu, Xuknewyana yoh komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Àhyayenye toy hatà. Xerusaryen hoye toy hatà, moxehra nyhe rma hatà. Betanya hona toy hatà. Àto rma kokmamye hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sa, nenmahye hatà. Enmahrà ro tekon harha tà, Txesusu, Xerusaryen hona. Tàtonàr me rma nahyehyakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Asama yahetawo nehxakon hatà, fek yohà. Tàwya xenyetxhe rma, xenyxe toy hatà, Txesusu. Eherhàra mak nehxakon hatà. Tak marma nehxakon hatà. Àro ke, onà wyaro nkekon hatà, Txesusu, àwya. Ehetahnà ro me oyesnàrà hxak moro ha, kekon hatà, fek yohàtho wya. Àro wyaro àwya katxhe rma, wayehye hatà, àrotho. ");
INSERT INTO hixNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nenytxownà hatà, ànhananàhrà ro komo. Àro ke noseryehokatxownà hatà. Àsok tawro wayehno harha, fek yohàtho, ketxkon hatà. Enyhorutho rma wayehno hamà, denyàr kom me, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Onà wyaro yaworo xaxa àkehe, owyanye, kekon hatà, Txesusu. Khoryenkom yahoxet hona xenytxoko. Owyanye àhona xenyetoko rma, onà wyaro kahra ro mak ehtxoko, ohnawonye. Royukyan hana, àna hana, kahra ro mak ehtxoko, ohnawonye, kekon hatà. Royukyan hamà, tahoxerye rma haxa tesnàr ke, ehonomnà me rma haxa tesnàr ke, katxok xa ha, ohnawonye. Àro wyaro owyanye tatoko rma, rowyaro rma rha eryehokano meryatxhe hampànà, Khoryenkom yahoxet yano me mak ha, kekon hatà, Txesusu. Rowya fek yohàtho wayehkanàrà wyaro, eryehokano meryatxhe hampànà, omnyam xarha. Oyoyukyatxhe hampànà, àhà ymo, moro ymo. Owyanye, ohtakako, atarymako tuna ymo kwaka, Khoryenkom yahoxet yano me, katxhe rma, oyoyukyatxhe hampànà, moro ymo, Khoryenkom yahoxet hona owyanye xenyàr ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Àsok maken kom hoko orwonàmtxoko, Khoryenkom yakoro. Thona xeny me oyehtokonye, oyoyukyatxhe xaxa mak hampànà, noro ha, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Taa. Khoryenkom màn yaka nowomye xarha tà, Txesusu. Toto komo hananàhyakon hatà. Àwya àhananàhnàtokonye rma, àhyaka nomohtxownà hatà, Xuknewyana yoh komo, Khoryenkom màn yonye ro yoh komo rma, horykomo kom yakoro xarha. Onà wyaro nketxkon hatà, àwya. Onok yano me ukrunyemeknyo meryak harha, on yaye, ketxkon hatà. Onokà ryhe, ukrunyemehtxoko keknano, owya, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Uro htxero onà wyaro àkehe, owyanye royuhtoho me, kekon hatà. Onok yano me aymomno ryakonà, Xowaw heno, owyanye, kahe yawon yano me katà, toto yano me katà. Uro eyuhtxoko. Owyanye royukutxhe rma, uro haka rha koyukyatxhe, kekon hatà, Txesusu. Àro ke nosonytxetxkon hatà, nyamoro rye rma. Àsoke tketxowà, ketxkon hatà, tàwyanye rma. Àsoke tketxowà. Kahe yawon yano me aymomno ryakon hamà, noro heno, tketxow katà, ketxkon hatà. Àro wyaro kàwyanye tatoko, onà wyaro nken hamà, mosonà. Àsok tawro noro heno yoyukhura mehxatxkonà, ken hamà, kàwyanye, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Àsok haxa katà tketxowà. Toto yano me aymomno ryakon hamà, tketxowà, ketxkon hatà. Àro wyaro kàwyanye tatoko, toseryehyatxow hamà, toto kom hona. Khoryenkomo rwonà yokarymanye ro me haxa we nehxakon heno ha, kany me natxow hamà, toto komo, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Àro ke, onà wyaro nketxkon hatà, Txesusu wya. Hàà, àna hana, ketxkon hatà. Onok yano me hana aymomno ryakon ha, noro heno ha. Uhutwahra amna naha, ketxkon hatà. Uro xarha, oyoyukhuranye wehxaha, kekon hatà, Txesusu, àwyanye. Onok yano me hana ukrunyemeknyo weryak ha. Oskarymahra ro mak wehxaha ha, owyanye, kekon hatà, Txesusu, Xuknewyana yoh komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kuknonano me onà wyaro nkekon hatà, Txesusu, Xuknewyana yoh komo wya. Asak nehxatxkon hatà, toto muru komo, kekon hatà. Kàrà y, kekon hatà, wahoto wya. Ronatàr hoko ehxe àtoko, amnye rma, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Àna matà, àtohra wehxaha, kekon mak hatà, umuru, wahoto, kekon hatà, Txesusu. Amnye nehutway harha tà. Àhoko ehxe àten hamà, kay hatà, tàwya rma. Àro ke toy hatà, nat waka, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Àro wyaro rma rha nkekon xarha tà, àyàm komo, anaro wya, buru rma wya. Ronatàr hoko ehxe àtoko, kekon hatà, àwya xarha. Àna hamà, àten hamà, apa y, kekon hatà. Àtohra mak nexey hatà, noro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Àsok muhutwetxowà, kekon xarha tà, àwyanye. Àsok muhutwetxowà. Onokà ryhe tàyàm yoyukye, wahoto katà, anaro haxa katà, kekon hatà, Txesusu. Wahoto hamà, noro rma neyukye hamà, ketxkon hatà, Xuknewyana yoh komo. Onà wyaro yaworo xaxa àkehe, owyanye, kekon hatà, Txesusu. Noro wyaro rma rha, Khoryenkom yoyuknye me harha natxow hamà, atxke natxhe moxamo katxho rotho komo, txenyeru yahosnye rotho komo rma, anaro rha kàrà hokono rotho komo xarha, kekon hatà. Àro ke, Khoryenkomo mryenon me harha natxhe, nyamoro ha. Omnyam haxa ryhe, noro mryenon mehra rma manatxhe, eyukhura rma oyesnàr kom ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ohyakanye nomokye, Xowaw heno. Osonyhoryetxoko, owyanye Kohkomo rwonà yonytxatxho me, kekon heno, owyanye. Noro heno yoyukhura mak mehxatxkonà. Txenyeru yahosnye rotho kom haxa ryhe neyukyatxkonà, kekon hatà. Anaro rha kàrà hokono rotho komo xarha neyukyatxkonà. Àwyanye eyuhtoho rma menyatxkonà, omnyamo. Owyanye xenyetxhe, eyukhura rma mehxatxkonà. Anar me harha ayanhàn komo yonyhera rma mehxatxkonà, kekon hatà, Txesusu, Xuknewyana yoh komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kuknonano me rma rha nàrwonàmye xarha tà, Txesusu. Xuknewyana yoh komo wya tàxanomkahnohtoho hutwamohsonàr xe nehxakon hatà. Àro ke, kuknonano me onà wyaro nkekon hatà, àwyanye. Tànatàrà yeryey hatà, horykomo, kekon hatà. Ufa heno yonamye hatà. Watxamtoy xarha tà. Toh yakay xarha tà, ufa xkunkatxho rma hatà, kekon hatà. Wato ymo yeryey xarha tà, kawono ymo hatà, tànatàrà yonytxoho rma hatà. Àro wyaro tàwya txetxehkatxhe rma, toto komo yomyaràhtoy hatà, kekon hatà. Tànatàrà yony me nemyaràhtotxownà hatà. Tàwya emyaràhtotxhenye rma, toy hatà, anar komo yowto hona, monyen komo yowto hona, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Amnye ehetawawo tanoto komo nyakye hatà, horykomo, tànatàrà yony komo hyaka. Àhyakanye nànyahtxownà hatà, eher horà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Anoto heno komo yahohtxownà mak hatà, nat yony komo, txom txom txom. Anaro heno hpohtxownà hatà. Anaro heno yotahatxownà hatà. Wayehye hatà, noro heno. Toh ke anaro heno yotahatxownà hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Thenyehra nyhe nànyahtxownà hatà, horykomo, àhyakanye. Atxke rma rha nyamoro heno yetxownà xarha tà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Àmahyakanye buru nyakye hatà, àhyakanye. Ohxe romuru yonyatxow hamà, kekon hatà, tàwya rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Onà wyaro haxa nketxkon hatà, nat yony kom ha. Tàwyanye noro yonyetxhe rma, onà wyaro nketxkon hatà, tàwyanye rma. Moson hamà umuru, ketxkon hatà. Tàyàmànhàrà wayhàtxhe, nat yoh me harha nay hamà, umurunhuru kaxe, ketxkon hatà. Àro ke norotho tetahatxe, norohnà harha kàwyam harha nat yoh me kehtxoho menye, ketxkon hatà, tàwyanye rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Àro ke noro heno yahohtxownà hatà. Narymatxownà hatà, nat waye. Netahatxownà hatà. Wayehye hatà, noro heno, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Àsok muhutwetxowà, kekon xarha tà, àwyanye. Àsok muhutwetxowà. Àsoke ryhe nat yony komo yeryano, horykomo. Towto hona harha tomokàtxhe, àsoke ryhe neryatxowà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Onà wyaro neyuhtxownà hatà, Xuknewyana yoh komo. Nyamoro heno ymo yotahen hamà, atxke rma haxa esnàr kom ke, ketxkon hatà. Nanàhnohtàketxow hamà. Anar komo yomyaràhten hamà, tànatàr yony me harha. Eherà yàmnye komo rma yomyaràhten hamà, ketxkon hatà, Xuknewyana yoh komo. ");
INSERT INTO hixNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Khoryenkom karyehtanà hutwahra manatxowà, kekon hatà, Txesusu, àwyanye. Onà wyaro nkehe, àmenhosahonhàrà. Toh xanomkahnohnye komo wyaro, noro xanomkahnohyatxhe hampànà, toto komo. Noro ryhe, ehonomnà me harha mpànà naha ha. Nàmno yetxehà wyaro, ehonomnà me noro yeryaha hampànà, Kohkomo. Ehonomnà me harha noro yehtxoho rma, ohxe rma haxa naha, kàwyanye. Àro wyaro rma nkehe, àmenhosahonhàrà. Àro wyaro katxhàrànhàrà hutwahra kat manatxowà, kekon hatà, Txesusu, Xuknewyana yoh komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Àro ke, onà wyaro àkehe, owyanye, kekon xarha tà. Khoryenkomo mryenon me tehxatxhe, kàwyamo, màketxhe rma haryhe, omnyamo. Khoryenkomo mryenon mehra harha manatxhe hampànà. Anaryana kom haxa ryhe, Khoryenkomo mryenon me harha natxhe hampànà. Nyamoro rma, Khoryenkomo yoyuknye ro me natxhe, kekon hatà, Xuknewyana yoh komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Àsok hana tehxan ha, kekon xarha tà. Anatoko tehurken hana, tohu ymo hona. Totàkràsken hana, toh hona kehurkanàr ke mak ha. Àro wyaro rma rha, noro xanomkahnohnye heno komo natanàhnohyatxhe hampànà, kekon hatà. Anatoko keryemnukyan hana, tohu ymo, khona tothahrà ke mak ha. Àro wyaro rma rha tàxanomkahnohnye heno komo yanàhnohyaha hampànà, noro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Àro wyaro kuknonano me Txesusu rwonàmnàtoko, nenytxetxkon hatà, Xuknewyana yoh komo, Khoryenkom màn yonye ro yoh komo rma, Farysew komo xarha. Khokonye rma nàrwonàmno hamà, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Àro ke, noro yahohtxahke nehxatxkon haryhe tà. Ahohsàra mak nehxatxkon hakahpa tà, toto kom hona toseryehrà komo ke hatà. Toto komo rma, Khoryenkomo rwonà yokarymanye ro me Txesusu yonyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kuknonano me rma rha nàrwonàmye xarha tà, Txesusu. Onà wyaro nkekon hatà, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Àsok hana akayaryet kom me nay ha, Khoryenkom ha, kekon hatà. Àsok hana wekarymen ha, owyanye. Kuknonano me wekarymen hamà. Onà wyaro nay hamà, kekon hatà. Buru yahxemtoy hatà, horykomo, toto kayaryet komo. Thetx yahohsakon hatà, umuru. Àro ke nahxemtekon hatà, àyàmà. Nyahà ymo yeryey hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tasahxemtotho komo hahnok ehtoko, tanoto komo nyakye hatà, àmàtmatxhàyamo hyaka. Omohtxok hatà, tasahxemtetxow haxa hatà, ketxkon hatà, anoto komo, àwyanye. Àtohra mak nehxatxkon hatà, nyamoro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Anaro tanoto komo xarha nyakye hatà. Onà wyaro katxoko, àmàtmatxhàyamo wya, kekon hatà, tanoto komo wya. Nyahà ymo yonyhoryetxehkan haxa hatà, horykomo, katxoko, kekon hatà. Woto xarha yonyhoryetxehkan haxa hatà, fakatho rma hatà, faka mxekàtho xarha hatà, ehsuryexahotho rma hatà, katxoko, àwyanye. Àna hatà, omohtxok hatà, tasahxemtetxow haxa hatà, katxoko, àwyanye, kekon hatà, horykomo, tanoto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Àsok hana nehxatxkon ha, nyah màtmatxhàyamo. Atxke rma haxa nehxatxkon hatà. Tàtonàr komo xehra mak nehxatxkon hatà. Nosownohyatxkon mak hatà, kekon hatà, Txesusu. Bararàn kom hoko rma nehxatxkon hatà, anar komo. Warawantetxkonà rma hatà, anar komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Anar komo ryhe, horykomo yanoto heno komo yahohtxownà hatà, txom txom txom. Atxke rma haxa netxownà hatà. Netahatxownà hatà. Bo, wayehtxownà hatà, anoto heno komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Àro ke, ewakhàra harha nehxakon hatà, horykomo. Waha komo nyakye hatà. Tanoto heno yotahanyenhàyam heno yotahahoy hatà, waha komo wya. Ewto heno komo xarha yaknyohpoy hatà, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Onà wyaro nkekon hatà, horykomo, tanoto komo wya. Amnye rma hehtehe haxa ha, romuru, kekon hatà. Tasahxemtetxow hamà. Asahxemtohra mak natxow hamà, àmàtmatxhàyam heno, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Àro ke àtotxoko, owto horye, anaro rha asama yarye, kekon hatà. Tasahxemtosom komo anyehtxatxko ha, onenyetxhàyamo rma, àsok maken komo rma, omeroro, kekon hatà, horykomo, tanoto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Àro ke totxownà hatà, anoto komo, owto horye, anaro rha asama yarye. Tànenyetxhàyamo yanyehtxownà hatà. Atxke natxhe moxamo katxho komo rma yanyehtxownà hatà, kekon hatà. Ohxe natxhe moxamo katxho komo xarha yanyehtxownà hatà. Omohtxok hatà, tasahxemtotxe, ketxkon hatà, àwyanye, omeroron komo wya. Àro ke nomohtàkatxownà hatà. Tanohke ro rma haxa nehxakon hatà, nàmno ymo, ahxemtono ytxoho, hehtano ytxoho, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ehonomtoxaho nehxatxkon hatà, nyamoro ha, tasahxemtosom komo rma. Osonyhoryexaho rma nehxatxkon hatà, thetx yahosnye hyawo tesnàr kom ke. Ukukur kom haxa ryhe, àhonomra ro mak nehxakon hatà. Noro rma yonyey hatà, horykomo. Nàmno ymo yaka towomàtxhe rma, àhonomnà rma yonyey hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Hoymo y, kekon hatà, horykomo, àwya. Àsok tawro ryhe àhonomra mowomno, xaro, kekon hatà, àwya. Eyukhura mak nexey hatà, toto. Àrwomra ro mak nehxakon hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Àro ke, onà wyaro nkekon hatà, horykomo, tanoto komo wya. Mosonàtho ymo asohtotxoko, kekon hatà. Àhrowomtxok xarha. On yaye arymatxoko, awarànà ymo waka, kekon hatà, horykomo, tanoto komo wya, kekon hatà, Txesusu. Àro wyaro rma rha tanàhnohsom me natxhe hampànà, osonyhoryehnàtho komo. Tarymaxem me natxhe hampànà, nyamoro heno, anàhnohno ytxoho ro na. Àton heno komo rma nàratetxhe hxak hampànà, teryewhamnohrà kom ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Khoryenkom yowto hona anyehxemotho komo ryhe, thenyehra natxhe. Towomsom kom haxa ryhe, yakehra natxhe, Khoryenkomo nwahanonkatxho komo rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Osonytxaxe nohsamnohtxownà hatà, Farysew komo. Àsoke ryhe mokà ymo tahohsatxowà, ketxkon hatà, Txesus hoko. Atxke àrwonàmàtxhe rma, tahohsatxow hamà. Atxke àwya koyuhtoho kom hoye ro tahohsatxow hamà. Noro yakoro tosonytxatxe, kàwyanye atxke màkehe, yaworohra mak màkehe, katxho me, ketxkon hatà, Farysew komo. ");
INSERT INTO hixNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Àro ke tànhananàhrà komo nyahtxownà hatà, Txesusu hyaka. Eroknes kukur komo xarha nyahtxownà hatà. Onà wyaro nketxkonà rma haryhe tà, ànyahxemo komo, Txesusu wya. Khananàhnye y, yaworo rma haxa manaha, amna wya, ketxkonà rma haryhe tà. Yaworo xaxa hananàhno meryaha, amna wya. Àme yohà rma haxa manaha, toto kom hoko. Owya àhananàhnàtokonye, oseryehpàra ro mak manaha, toto kom hona, ketxkonà rma haryhe tà. Àhyahampàra ro mak manaha, toto kom hona. Yaworo xaxa Khoryenkomo muhutwamohsehe, amna wya, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Àro ke uhutwamohsoko, amna wya, ketxkonà rma haryhe tà. Txenyerun kom hoye tàmporye naye, Sesa wya, Homayana komo kayaryetà wya. Tàmporyehra kat naye, owya, ketxkonà rma haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tàxehra ehtxoho komo hutwekon mak hatà, Txesusu. Àro ke, onà wyaro nkekon hatà, àwyanye. Yaworonohnà ro mak omnyamo, kekon hatà. Rokukmanàr xe manatxow hamà, ronkukmanàr horà. ");
INSERT INTO hixNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Txenyeru txko xenyhotxoko, rowya, kekon hatà. Àro ke nehtxownà hatà, àhyaka. ");
INSERT INTO hixNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Onok kuknonà mosonà, onok yosotà onà àmenhosaho, kekon hatà, txenyeru txko hoko. ");
INSERT INTO hixNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hàà, Sesa hamà, ketxkon hatà. Hàà, yaworo màketxow hamà, kekon hatà, Txesusu. Noro katxho me nay hamà, onà, kekon hatà. Àro ke noro ewakryetxoko, owyanye àkatxho yàmrà ke mak ha, kekon hatà. Àro wyaro rma rha Khoryenkomo xarha ewakryetxoko, owyanye eyuknur ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Àro wyaro tàwyanye enytxatxhe rma, noseryehoketxkon hatà, ànyahxemo komo. Koo, ohxe rma haxa koyuhtxow hamà, ketxkon hatà, tàwyanye rma. Àro ke totxownà hatà, Txesusu hyaye. ");
INSERT INTO hixNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Àro rma ho nomohtxownà hatà, Saknusew kukur komo, Txesusu hyaka. Kwayhàtxhenye asanàmpàra ro mak tehxatxhe kany komo rma nyamoro ha. ");
INSERT INTO hixNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Khananàhnye y, ketxkon hatà, àwya. Onà wyaro nmenhoy hatà, Moyses heno, kàyweronàhyamanye ro heno komo. Towàt heno wayhàtxhe, àhokhura rma àwayhàtxhe, àhetxenhàr hak yahosno, ewtànhàrà rma. Noro ryhe, thetx me nahohsaha, àhohtanàr horà. Towàt heno wenatàhwo hohtehe, noro ha, towàt heno hokru me. Àro wyaro rma nmenhoy hatà, Moyses heno, ketxkon hatà, Saknusew komo. ");
INSERT INTO hixNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Àro ke enytxako. Tànyonye wos yexetxhàrànhàrà amna nekarymehe, owya, ketxkon hatà. 7 me nehxatxkonà, toto heno komo, ewtà rye komo rma. Amna kukur me rma nehxatxkonà, nyamoro heno, ketxkon hatà. Wahoto heno wos yahosàye. Bo, wayehye, noro heno. Àhokhura rma wayehye, ketxkon hatà. Àhonanotho heno ryhe, towàt heno hetxenho yahosàye. ");
INSERT INTO hixNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tàwya ahosàtxhe, wayehye, noro heno xarha, àhokhura rma rha, ketxkon hatà. Àro wyaro rma rha nexeye, àhonanotho heno xarha. Àro wyaro rma rha nehtxownà, 7 heno komo, omeroro, ketxkon hatà. Tàwyanye wos yahosàtxhe, wayehtàkatxownà. Àhohtahra rye rma wayehtàkatxownà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Amnye wos heno xarha wayehye, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Àsok natxowà àro ke, owya, ketxkon hatà, Txesusu wya. Kwayhàtxhenye tasanàmyatxhe harha màkehe hawe, omoro. Onok hetx me ryhe naye, wosà, tasanàmàtxhenye, ketxkon hatà. Onok hetx me ryhe naye, amnye ha. Tano rma hak tehtoko, 7 kom hetx me nehxakon hamà, ketxkon hatà, Saknusew komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Àna matà, ayawexenatxow hamà, omnyamo, kekon hatà. Owyanye, asanàmpàra ro mak tehxatxhe tatoko rma, ayawexenatxow hamà. Khoryenkom karyehtanà hutwahra ro mak manatxow hamà. Khoryenkom yahoxet xarha hutwahra rma rha manatxow hamà. Àro ke ayawexenatxhe ro mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tasanàmàtxhenye, àhehtahra ro mak natxhe ha, àwayehxemonhàr komo. Ànyontahra ro mak natxhe xarha. Kahe yawon komo wyaro rma natxhe ha, Khoryenkom yanoto komo wyaro rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tanàmsom me xaxa mpànà natxhe ha, àwayehxemotho komo, kekon xarha tà, àwyanye. Khoryenkom karyehtanà hutwahra kat manatxowà. Àro yawo rma, onà wyaro nkekon hatà, Khoryenkomo. ");
INSERT INTO hixNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Akmaraw horyenà rma uro ha, kekon hatà. Esake horyenà rma uro ha, Xako horyenà rma uro ha, kekon xarha tà, Khoryenkomo. Noro ryhe, ehxen kom horyen mehra ro mak naha ha. Tehxemà rma kom haxa horyen me naha. Àro ke, àwayehxemotho komo yanàmnye me nay hamà, kekon hatà, Txesusu, Saknusew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nenytxetxkon xarha tà, toto komo, ohsamnohxemo komo. Tàwyanye enytxatxhe rma, noseryehoketxkon hatà. Koo, ohxe rma haxa khananàhyatxow hamà, mosonà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Onà wyaro tawro yonytxatxownà hatà, Farysew komo. Txesusu yameryekahra harha natxhe, Saknusew komo, ohxe àwya toyuknur kom ke, tawro yonytxatxownà hatà, toto komo wya. Àro ke, Txesusu hyaka nohsamnohtxownà hatà, Farysew komo. ");
INSERT INTO hixNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ukukur komo rma, Txesusu kukmanàr xe nehxakon haryhe tà, enkukmanàr horà. Àyweronàhyamano ynye ro rma mok nehxakon hatà. Àro ke, onà wyaro nkekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Khananàhnye y, thenyehra nay hamà, Moyses heno nmenhotho, kàyweronàhyamatxho komo, kekon hatà. Thenyehra mak nay hamà. Àsok katxho ryhe, anar komo yoho nyhe naye, owya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Neyukye hatà, Txesusu. Onà wyaro katxho ryhe, ohxe rma haxa naha, kàyweronàhyamatxho komo. Anar komo yoho nyhe naha. Kohkom xe xaxa ehtxoko. Khoryenkom xe rma ehtxoko, oyowan kom ke xaxa mak ha, ohnawon kom ke xaxa mak ha, oyehutwanàr kom me xaxa mak ha. Àro wyaro katxho rma, anar komo yoho nyhe naha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Àhonan xarha, onà wyaro katxho rma, ohxe rma rha naha. Osox oyehtxoho wyaro rma, ohoyen kom xe xaxa ehtxok xarha. Àro wyaro katxho rma, ohxe rma rha naha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Àro wyaro katxho kom hoye ro, anaro rha hoko kàyeronàhyamatxownà, Moyses heno komo, Khoryenkomo rwonà yokarymanye ro heno komo xarha, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tohsamnohso rma hak ehtokonye, onà wyaro nkekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Àsoke ryhe Kryestu muhutwetxowà, kekon hatà. Àsoke ryhe Kryestu muhutwetxowà. Onok heno yohamàtho me naye, owyanye, kekon hatà, àwyanye. Dafe heno yohamàtho me nay hatà, Kryestu, Khoryenkomo nànyaknyàrà rma, ketxkon hatà, Farysew komo. ");
INSERT INTO hixNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Rohà ryhe noro kekon mak hatà, Dafe heno, Kryestu hoko, kekon hatà, Txesusu. Noro hoko rma, onà wyaro nkay heno hatà, Khoryenkom yokato yano me mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Onà wyaro nken hatà, Kohkomo, rohà wya. Ehonomnà me xaxa eryewtako, rohanaka, ken hatà. Howehehra eryewtako, ken hatà. Tan oyehtoko rma haka, onà wyaro kany me axanhàn komo weryaha hampànà. Ehonomnà me xaxa manaha kany me weryatxhe hampànà, ohoko, ken hatà, Kohkomo, rohà wya. Àro wyaro rma nkay hatà, Dafe heno, Kryestu hok hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tohamrà rma yotakyakonà, toh me. Àsok tawro ryhe, ehamàthàrà me harha nexeye, ehà rma, owyanye, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Eyukhura mak nehxatxkon hatà. Eyuknyehnà ro me nehxatxkon hatà, toto komo, omeroro. Àro wyaro Txesusu wya katxhe rma, àrwomra harha nehxatxkon hatà. Àsok naye, owya, kahra harha nehxatxkon hatà, towankaranàmrà komo ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Onà wyaro nkekon hatà, Txesusu, tànhananàhrà ro komo wya, toto komo wya xarha, ohsamnohxemo komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Moyses heno nmenhotho hutwamohsetxow hamà, Farysew komo, àyweronàhyamano ynye ro komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Àro hoye ro àwyanye ahananàhnàtokonye, nyamoro eyuhtxoko, àro yawo ro oyehtxoho menye. Nyamoro wyarohra mak ehtxoko, atxke esnàr kom ke, àro yawo rohra esnàr kom ke, kekon hatà. Yaworo rma nekarymetxhe. Àro yawo rohra mak natxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Thenyehra rma haxa hananàhno yeryatxow hamà, Moyses heno nmenhotho yoho rma haxa mak ha, toto komo wya eyuknur yoho rma haxa mak ha. Amotaka nyhe hananàhno yhera mak natxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ohxe nosonyhetxhe rma haryhe, Farysew komo, toto komo wya, kekon xarha tà. Eten kom hoko tehtokony hana, ohxe tosonyhonàr komo xe rma natxhe haryhe, toto komo wya. Àro ke àmenhosaho womyatxhe, temeknuwonye, kekon hatà. Khoryenkom karyehtan hoyeno rma womyatxhe, temeknuwonye, thewony xarha, ohxe tosonyhonàr kom horà. Kawo rma haxa horokuhtetxhe xarha, ohxe tosonyhonàr kom horà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Anar kom yakoro tasahxemtontokonye, ehonomnà me tosonyhonàr komo xe rma natxhe haryhe. Ohsamnohno ytxoho ro yawo tehtokonye, ehonomnà komo yahon ho neryewtetxhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yakentawo tàtontokonye, Ha y, khananàhnye y, tawro xe natxhe haryhe, toto komo wya. Khananàhnye y katxho me tesnàr komo xe rma haxa natxhe, toto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Onà wyaro nkekon xarha tà, Txesusu, tànhananàhrà ro komo wya. Omnyamo ryhe, khananàhnye y katxho me oyesnàr komo xehra ehtxoko, kekon hatà. Ehonomnà komo wyaro oyesnàr komo xehra rma ehtxoko. Uro ryhe, ahananàhnye kom me wehxaha. Anaro ehxera ro mak naha, ahananàhnye komo. Omnyam haxa ryhe, noro rye me manatxhe, ewtà rye komo wyaro, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Apa y kahra ro mak ehtxoko, toto komo wya, ehonomnà komo wya, yukryeka hon komo wya, kekon xarha tà. Towenyxa mak naha, oyàmkomo, apa y katxho rma. Kahe yawono rma noro ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Àro wyaro rma rha, amna yohà y katxho mehra ro mak ehtxoko. Towenyxa mak naha, oyohkomo. Kryestu rma noro ha, Khoryenkomo nànyaketxho rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Onà wyaro haxa ehtxoko, omnyamo ro rye rma. Ehonomnà me oyesnàr komo xe oyehtokonye, okukur komo yanoto me rma ehtxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ehonomnà me oyosonyetokonye, norohnàtho me harha oyeryatxhe hampànà, Khoryenkomo. Norohnàtho me haxa oyosonyetokonye, ehonomnà me harha oyeryatxhe hampànà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Onà wyaro nkekon xarha tà, Txesusu. Farysew komo y, àyweronàhyamano ynye ro komo y, yaworonohnà ro me manatxhe, omnyamo, kekon hatà. Tanàhnohsom me manatxhe hampànà, omnyam heno. Àsok tawro hana. Khoryenkomo hutwamohsohra ro mak manatxhe ha, toto komo wya. Uhutwanyehnà komo kax mak manatxhe ha, kekon hatà. Àro ke, Khoryenkomo mryenon mehra rma manatxhe. Toto komo xarha, noro mryenon mehra rma rha natxhe. Àmryenon me harha tehtxahkemàtho rma, àmryenon mehra rma natxhe, owyanye anar me thananàhrà kom ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Farysew komo y, àyweronàhyamano ynye ro komo y, yaworonohnà ro me manatxhe, omnyamo, kekon xarha tà. Tanàhnohsom me manatxhe hampànà, omnyam heno. Àsok tawro hana. Enyonkaxemo katxhotho maryatxhe, akatxho kom me harha, kekon hatà. Khoryenkom yakoro orwonàmnàtokonye, mexe rma haxa orwonatxhe, onkuhtono ynyàr me mak ha, ohxe oyosonyhonàrà kom horà mak ha. Àro ke, tanàhnohsom me manatxhe hampànà, anar komo yoho rma haxa mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Farysew komo y, àyweronàhyamano ynye ro komo y, yaworonohnà ro me manatxhe, omnyamo, kekon xarha tà. Tanàhnohsom me manatxhe hampànà, omnyam heno. Thenyehra rma haxa hananàhno meryatxow hamà, omryenon kom me harha toto komo yehtxoho me, kekon hatà. Omryenon kom me harha toto yehtoko, tanàhnohsom me rma rha noro meryatxhe. Eryewhamnohno ytxoho ro na tarymaxem me rma rha noro meryatxhe. Tanàhnohsom me oyehtxoho komo yoho rma haxa, tanàhnohsom me naha, noro, owyanye atxke thananàhrà ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Tanàhnohsom me manatxhe hampànà, omnyam heno, kekon xarha tà, àwyanye. Owyanye toto komo hananàhnàtokonye, enhun komo wyaro manatxow hamà. Àsok tawro hana. Anar komo yarhàra natxow hamà, enhun komo, kekon hatà. Àro wyaro rma rha, Khoryenkomo hutwamohsohra manatxhe, omnyamo, toto komo wya, uhutwanyehnà komo kaxe. Àro ke màhananàhyatxhe rma haryhe, kekon hatà. Onà wyaro màketxhe rma haryhe, toto komo wya. Orwonàmàthàyam yawo ron me oyosonyhontokonye, onà wyaro kahra ehtxoko, màketxhe. Rorwonàmàthàrà yawo rohra ryehtoko, nosomtatkano rma haka, Khoryenkom mànà, kahra ehtxoko, màketxhe. Onà wyaro haxa katxoko, màketxhe. Rorwonàmàthàrà yawo rohra ryehtoko, nosomtatkano rma haka, uru, Khoryenkom màn yawono, katxok xa ha, màketxhe. Nosomtatkano rma haka uru kanye rma, orwonàmàthàyam yawo ro ehtxok hampànà, atxke oyesnàr kom hona, màketxhe, toto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Àro wyaro owyanye tatoko rma, Khoryenkom màn yoho nyhe àro yawono menyatxow hamà. Akàhpàra manatxow hamà. Enhun komo wyaro rma manatxow hamà, uhutwanyehnà komo kaxe, kekon hatà. Àsok tawro hana. Uru yoho nyhe enyhoru ro me nay hamà, Khoryenkom mànà. Enyhoru ro me rma rha naha, uru xarha, Khoryenkom màn yawo tesnàr ke mak ha. Àro yawohra tehtok haxa, enyhoru ro mehra esnàràtho haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Onà wyaro màketxhe xarha, toto komo wya, kekon xarha tà. Orwonàmàthàyam yawo ron me oyosonyhontokonye, onà wyaro kahra ehtxoko, màketxhe. Rorwonàmàthàr yawo rohra ryehtoko, nosomtatkano rma haka, faka yaknyohtoho, kahra ehtxoko, màketxhe. Onà wyaro haxa katxoko, màketxhe. Rorwonàmàthàr yawo rohra ryehtoko, nosomtatkano rma haka, tàmsomà, faka yaknyohtoho mkawono, katxok xa ha, màketxhe. Nosomtatkano rma haka tàmsomà kanye rma, orwonàmàthàyam yawo ro ehtxok hampànà, atxke oyesnàr kom hona, màketxhe, toto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Àro wyaro owyanye tatoko rma, faka yaknyohtoho yoho nyhe àmkawono menyatxow hamà. Enhun komo wyaro manatxow hamà, uhutwanyehnà komo kaxe, kekon hatà. Àsok tawro hana. Tàmsom yoho nyhe enyhoru ro me nay hamà, faka yaknyohtoho. Enyhoru ro me rma rha naha, tàmsom xarha, faka yaknyohtoho mkawo tesnàr ke mak ha. Àmkawohra tehtok haxa, enyhoru ro mehra esnàràtho haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Onà wyaro haxa àkehe, owyanye, kekon xarha tà. Owyanye, nosomtatkano rma haka, faka yaknyohtoho, tatoko, àro marmahnà hoko, àmkawon hoko xarha orwonatxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Owyanye, nosomtatkano rma haka, Khoryenkom mànà, tatoko, àro marmahnà hoko, àro yawon hoko xarha orwonatxow hamà. Nosomtatkano rma haka, Khoryenkomo, kany me rma manatxow hamà, bàn yawon me noro yesnàr ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Owyanye, nosomtatkano rma haka, kahe, tatoko, àrohnà hoko rma, Khoryenkom yowto hok haxa orwonatxow hamà. Nosomtatkano rma haka, Khoryenkomo, kany me rma manatxow hamà, towto hon me noro yesnàr ke, kekon hatà. Àro wyaro kahra ro mak ehtxoko. Àro wyaro kanyehnà rma, orwonàmàthàyam yawo ro rma ehtxoko, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Farysew komo y, àyweronàhyamano ynye ro komo y, yaworonohnà ro me manatxhe, omnyamo, kekon xarha tà. Tanàhnohsom me manatxhe hampànà, omnyam heno. Àsok tawro hana. Anatàr komo yeher hoye desmu rma màmyatxow hamà, Khoryenkomo wya, kekon hatà. Ohteran komo txko hoye, ehfaknose komo txko hoy xarha, komenyu komo txko hoy xarha, desmu rma màmyatxhe haryhe, Khoryenkomo wya, kàyweronàhyamatxho kom yawo ro oyosonyhonàr kom horà, kekon hatà. Onà wyaro katxho kom yawo ro haxa tehxorye manatxhe haryhe. Àme rye rma haxa ehtxoko, toto kom hoko, katxho yawo ro tehxorye manatxhe haryhe, kekon hatà. Toto komo hnàn yawo rma haxa ehtxoko katxho yawo ro xarha tehxorye manatxhe haryhe. Yaworo rma haxa ehtxoko katxho yawo ro xarha tehxorye manatxhe haryhe. Àro wyaro katxho kom yawo ro ryhe tehxorye manatxhe, kàyweronàhyamatxho kom yawo ro oyehtxoho menye, kekon hatà. Àro yawo rohra mak manatxhe. Àro yawo rono rma, desmu yàmrà hoko xarha tehxorye manatxhe ha, Khoryenkomo wya, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Anar komo yarhàra natxow hamà, enhun komo. Àro wyaro rma rha, Khoryenkomo hutwamohsohra manatxow hamà, omnyamo, toto komo wya, uhutwanyehnà komo kaxe, kekon hatà. Yaworohra oyehtokonye, desmu yàmrà xehra naha, Khoryenkomo, owyanye. Toto komo hnàn yawohra oyehtokonye rma, desmu yàmrà xehra naha, owyanye, kekon hatà. Omnyam haxa ryhe, onà wyaro màketxow hamà. Datàr komo txko hoye kàwyanye desmu yàmtoho ryhe, toto komo hnàn yawo kehtxoho komo yoho rma haxa naha, Khoryenkomo wya, màketxhe rma haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Farysew komo y, àyweronàhyamano ynye ro komo y, yaworonohnà ro me manatxhe, omnyamo, kekon xarha tà. Tanàhnohsom me manatxhe hampànà, omnyam heno. Àsok tawro hana. Àmkay marma oryen korokaxaho wyaro manatxow hamà, kekon hatà. Kàyweronàhyamatxho kom yawo ron me mosonyhetxhe rma haryhe, toto komo wya. Ohnawonye ryhe, àro yawo rohra mak manatxhe ha. Atxke rma haxa manatxhe, ohnawonye. Anar komo katxho hoko tehohkaxemà ro me manatxhe, ohnawonye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Enhun komo wyaro manatxow hamà, omnyamo, Farysew komo. Wahoro htxero osonyhoryetxoko, ohnawonye. Ohnawonye osonyhoryexaho rma, ohxe mosonyhetxow hamà, toto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Farysew komo y, àyweronàhyamano ynye ro komo y, yaworonohnà ro me manatxhe, omnyamo, kekon xarha tà. Tanàhnohsom me manatxhe hampànà, omnyam heno. Àsok tawro hana. Onamno ytxoho ro wyaro manatxow hamà, kekon hatà. Umuturyexah me ehtoko, ohxe tonyxem me nay hamà, onamno ytxoho ro. Àmkay marma ohxe tonyxem me nay hamà. Yaw haxa ryhe nay hamà, toto heno yotxhotho, anhà rma, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Àro wyaro rma rha, ohxe rma mosonyhetxhe haryhe, omnyamo, toto komo wya. Ohnawony haxa ryhe, atxke rma haxa manatxhe. Yaworohra mak manatxhe, ohnawonye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Farysew komo y, àyweronàhyamano ynye ro komo y, yaworonohnà ro me manatxhe, omnyamo, kekon xarha tà. Tanàhnohsom me manatxhe hampànà, omnyam heno. Àsok tawro hana. Khoryenkomo rwonà yokarymanye ro heno komo yonamàthàràtho menyhoryetxow hamà, kekon hatà. Enyhoru heno komo rma yonamàthàràtho menyhoryetxow hamà. ");
INSERT INTO hixNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","31","Nyamoro heno yotahanyenhàyamo yohamàtho me manatxhe, omnyamo, kekon hatà. Onà wyaro màketxhe rma haryhe. Amnyehran heno me kehtokony haxa, Khoryenkom yanoto yotahahtoràtho kom haryhe kàwyanye, khoryen heno komo wyarohra kesnàràtho kom haryhe, màketxhe rma haryhe, kekon hatà. Àro wyaro owyanye tatoko rma, etahanyenhàyamo yohamàtho me moskarymetxow hamà. Anhà heno komo yohamàtho me rma moskarymetxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Àsok tawro hana. Ohoryen heno komo yoho nyhe ayanhàn kom hoko roro rma haxa mpànà manatxhe ha, nyamoro heno wyaro rma rha tanàhnohsom me oyehtxoho menye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Okoye wyaro atxke manatxow hamà, kekon xarha tà, àwyanye. Àsok tawro hana. Weheto krunke nekahtàmyan hamà, okoye. Àro wyaro rma rha, oyokahtàmrà komo xe manatxow hamà, Khoryenkomo wya ayanàhnohrà kom hona. Ekahtàmpàra mak manatxhe hampàna. Eryewhamnohno ytxoho ro na tarymaxem me manatxhe hampànà, atxke oyesnàr kom ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Àro ke, onà wyaro àkehe, owyanye, amnyeno rma komo wya, kekon xarha tà. Ohyakanye ànyakyatxhe hampànà, Khoryenkomo rwonà yokarymany komo, tàyweron komo rma, oyweronàhyamany komo rma. Nyamoro rma ànyakyatxhe hampànà, ohyakanye, kekon hatà. Ukukuthuyamo rma metahetxhe hampànà. Yahkotohen hona mamoyathetxhe hampànà. Ukukuthuyamo xarha meryewhamnohyatxhe hampànà. Anaro rha owto ho mehoryatxhe hampànà, eryewhamnohrà kom horà, kekon hatà. Maryatxhe hampànà, oyohsamnohtoho kom yaka. Àro yawo rma màhpokyatxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Àro ke ayanàhnohyatxhe hampànà, Khoryenkomo. Amnyeno rma komo yanàhnohyaha hampànà. Amnyehra, thenyehra rma haxa nehxatxkon hatà, etahaxemo heno komo, enyhoru ro heno komo, kekon hatà. Wahoro htxero wayehye hatà, Akmew heno. Atxke naha mosonà katxho mehra ro mak nehxakon hatà, noro heno. Wayehye mak hatà, totahatxho wya, kekon hatà. Noro heno wyaro rma rha wayehtxownà hatà, enyhoru ro heno komo, thenyenohnà heno komo, totahatxho komo wya rma rha. Amnye nyhe rma àmahyakany haxa wayehye hatà, Sakaryeyas heno, Barakeyas muru heno rma, totahatxho wya rma rha, kekon hatà. Khoryenkom màn watxan yawo noro heno yotahatxownà hatà, ohoryen heno komo. Faka yaknyohtoho monye nyhe hatà, Khoryenkom màn màhto rma hatà, noro heno yotahatxownà hatà, kekon hatà. Nyamoro heno yotahatxehkatxownà hatà, ohoryen heno komo, amnyeno rma horyen heno komo rma. ");
INSERT INTO hixNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Àro hoye ro, tanàhnohtàkaxem me rma haxa manatxhe hampànà, omnyamo, amnyeno rma komo. Àro wyaro yaworo xaxa àkehe, owyanye, kekon hatà, Txesusu, Farysew komo wya, àyweronàhyamano ynye ro komo wya xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Onà wyaro nkekon xarha tà, Txesusu. Àsok hana natxow ha, Xerusaryen hon kom ha, kekon hatà. Amnyehran heno komo, Khoryenkomo rwonà yokarymanye ro heno komo yotahetxkonà, Xerusaryen hon heno komo rma. Tàhyakanye ànyahxemotho komo rma yotahetxkonà, toh ke, kekon hatà. Amnyeno rma komo xarha, roxehra natxhe, Xerusaryen hon komo rma. Nyamoro rma kurunhonàr xe roro wehxakon haryhe. Àsok hana nay ha, apaytara ha, kekon hatà. Tahothàrà yosnaka tàmxekrà yohamnohyan hamà, ukurunhonàr horà. Àro wyaro rma rha, Xerusaryen hon komo kurunhonàr xe roro wehxakon haryhe. Tkurunhonàr komo xehra mak natxhe, rowya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Àsok tawro hana. Àxanomkahnohsah me harha naha, Xerusaryen heno. ");
INSERT INTO hixNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Àto ehxera harha wehxaha. Ronyhera harha natxhe hampànà, àton komo, kekon hatà. Yukryeka hona harha romokhàra ro rma haka, ronyhera roro rma natxhe hampànà, Xerusaryen hon komo. Romokàtxhe, ronyatxhe harha, àton komo, amnyen komo. Àtoko rma, onà wyaro nketxhe hampànà. Kohkom yano me omohsaho ryhe mosonà, towakryexem me xaxa hak nahko, mosonà, ketxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Khoryenkom màn yaye nahatakatxownà hatà, Txesus komo. Àsnye ro tàtonàr kom me, àhyaka haxa nomohtxownà hatà, ànhananàhrà ro komo. Khananàhnye y, ketxkon hatà. Xenyko, moro ymo, anaro rha nàmno, Khoryenkom mànà ymo. Poo, ohxe rma haxa wenyaha, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Moro ymo menyatxow hamà, omeroro, kekon hatà. Onà wyaro yaworo xaxa àkehe, owyanye. Amnye nosomkawononkatxehkehe hampànà, àro ymo heno. Osomkawono ymo heno natarymatxehkehe hampànà, othenyekhenà ro me mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Oryefera yàhàn hona totxownà hatà. Àto rma nehxakon hatà, Txesusu, eryewtaxaho. Àhyaka haxa nomohtxownà xarha tà, ànhananàhrà ro komo. Anar komo nenytxahtor me rma, onà wyaro nketxkon hatà, àwya. Àsokentoko ryhe nosomtatkatxehkeno, Khoryenkom mànà ymo heno, ketxkon hatà. Àsokentoko nosomtatkatxehkeno. Àsokentoko momokyan harha, ketxkon hatà. Àsokentoko nosomtatkatxehkeno, yukryeka heno. Àhahnoke rma haxa ehtoko, eten komo tenyatxowà, uhutwamohsotho. Ekarymako, amna wya, ketxkon hatà, Txesusu nhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Onà wyaro neyuhtxownà hatà, Txesusu. Anar komo wya oyonkuhtonàr kom hona mpànà xenytxoko, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nomokyatxhe hampànà, onkuhtono ynye komo, anaro rha komo, thenyehra. Kryestu uro ha ketxhe rma haryhe. Thenyenohnà komo yonkuhtetxhe hampànà, kekon hatà. Nyamoro wya oyonkuhtonàr kom hona mpànà xenytxoko. ");
INSERT INTO hixNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Waha yosohtahanàr komo yokaytà menytxetxhe hampànà. Mexehra nosohtahetxow hatà, waha komo, tawro xarha menytxetxhe hampànà, kekon hatà. Àro wyaro owyanye enytxantoko, oseryehpàra rma ehtxoko. Àro wyaro htxero haka mpànà natxhe ha, toto komo. Osomtatkatxehkahra rma hak naha, yukryeka, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Anaro rha yana komo nosohtahetxhe hampànà, kekon xarha tà, àwyanye. Anaro rha owto hon komo nosohtahetxhe hampànà. Anato rha nosowuhsaha hampànà, yukryeka, thenyehra. Ehxera ro mak naha hampànà, nyahà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Àro wyaro htxero neryewhamyatxhe hampànà, toto komo. Eryewhamtàhkahra rma hak natxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Àtoko rma ayahohsetxhe hampànà, axanhàn komo, tkayaryet komo wya, kekon xarha tà. Nyamoro rma oyeryewhamnohyatxhe hampànà. Oyotahetxhe hampànà. Oxehranye rma haxa natxhe hampànà, anaro rha yana komo, omeroro, romryenon me oyesnàr kom ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Rohnànketxhe harha hampànà, toto komo, thenyenohnà komo. Txesusu mryenonà uro kanyetho komo rma, rohnànketxhe harha hampànà. Osoxehra harha natxhe hampànà. Nyamoro ryetho rma, natahohsetxhe hampànà, anhà komo wya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yaworohra nekarymetxhe hampànà, anar komo, thenyenohnà komo. Khoryenkomo rwonà yokarymanye uro ketxhe rma haryhe. Yaworohra àro wyaro nketxhe hampànà. Toto komo yonkuhtetxhe hampànà, nyamoro ha. Thenyenohnà komo rma yonkuhtetxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Atxke rma haxa natxhe hampànà, toto komo, thenyehra rma haxa mak ha. Àro ke, osoxehra harha natxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Enàmtxok mak hampànà. Enàmtàhkanyenhàrà rma, karyhe roro harha manatxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tokarymaxem me mak naha hampànà, àrwo yonyhorunu. Akayaryet kom me nomokyaha hampànà, Khoryenkomo nànyaknyàrà, katxho rma, tokarymaxem me mpànà naha ha. Àro rma yonytxatxehketxhe hampànà, toto komo, anaro rha yana komo, omeroro, kekon hatà. Àwyanye enytxatxehkatxhe rma, mexehra nosomtatkatxehkehe hampànà, yukryeka heno, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Onà wyaro nkekon xarha tà, Txesusu. Yukryeka yosomtatkahra ro rma haka, anhà ymo menyatxhe hampànà, Khoryenkom mànàtho xanomkahnohmohsonye ymo, kekon hatà. Khoryenkom mànàtho yaka rma neryatxhe hampànà, waha komo, enyhoru rotho yaka rma. Àto rma menyatxhe hampànà. Àto noro ymo yehtxoho hoko rma, menhoy hatà, Danyew heno, Khoryenkomo rwonà yokarymanye ro heno, amnyehra, kekon hatà, Txesusu. Àro wyaro nkekon hatà, Txesusu, anhà ymo hoko, Danyew heno nmenhothàrànhàr hoko. Àro wyaro rma àmenhono, tano, thutwaxem me harha noro heno nmenhothàrànhàrà yehtxoho me. ");
INSERT INTO hixNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Onà wyaro nkekon xarha tà, Txesusu, tànhananàhrà ro komo wya. Tàwyanye anhà ymo yonyetxhe rma, onà wyar hak nahtxoko, àton komo, Xukneya yamtar hon komo, kekon hatà. Àhà ymo hona hak nekahtàmtxowà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Màmyaye tehtokonye, àtohra harha hak nahtxoko, bàn kom yaka harha. Tkatxho kom horà àtohra hak nahtxoko. Nekahtàmtxow haxa haka, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bararàn kom hoko tehtokonye, omokhàra harha hak nahtxoko. Twomun kom horà omokhàra hak nahtxoko. Nekahtàmtxow haxa haka, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Oko txko, mokyamo txko ha, yuhna heno komo, tonarkem heno komo xarha. Àtoko rma, thenyehra neryewhamyatxhe hampànà, nyamoro heno, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Onà wyar hak nàrwonàmtxowà, Khoryenkom yakoro. Apa y, txemnyeh mehra hak nahko, rokahtàmtoho, katxow haka, toto komo, àwya. Apa y, tuna mehra hak nahko. Apa y, hokano ytxoho yawasàn mehra hak nahko, rokahtàmtoho, katxow haka, toto komo, Khoryenkomo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Àtoko rma, thenyehra rma haxa neryewhamyatxhe hampànà, toto komo. Àro wyaro eryewhampàra ro mak nehxatxkonà, amnyehran heno komo, kekon hatà. Àro wyaro eryewhampàra rma rha natxhe xarha, amnyen komo. ");
INSERT INTO hixNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Thenyehra mak neryewhamyatxhe hampànà, kekon hatà. Amnye eryewhamtohotho komo yatàknanàhkehe hampànà, Khoryenkomo, tàwya tàmryenon komo kurunhotho me, tànwahanonkatxhàyamo kurunhotho me. Atàknanàhkahra ehtok haxa, omeroron komo wayehtàkanàràtho haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Àtoko rma, onà wyaro nketxhe hampànà, anar komo, owyanye. Tan naha, Kryestu, omohsaho rma, ketxhe hampànà. Mono nay hatà, ketxhe xarha, anar komo, owyanye. Enytxahrany mak ehtxok hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kryestu uro ketxhe rma haryhe, anar komo. Khoryenkomo rwonà yokarymanye uro ketxhe rma haryhe, anar komo. Eryehokano yeryatxhe rma haryhe, thenyehra, kekon hatà. Tahoxet komo rma yonyhetxhe rma haryhe, toto komo wya. Àro hoye ro onkuhtono yeryatxhe hampànà. Khoryenkomo mryenon komo xarha yonkuhtotxahke natxhe rma haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Omokhàra ronye rma haka, nyamoro rma wekarymehe, owyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Àro ke, enytxahranye ehtxok hampànà, kekon hatà. Onà wyaro nketxow hana, owyanye. Ahehnawo nay hatà, Kryestu, ketxow hana. Ahehnaka àtohra mpànà ehtxok ha, kekon hatà. Nàmno yaw nay hatà, tahusom yaw hatà, ketxow haxa hana. Enytxahrany mak ehtxok hampànà. Yaworohra àro wyaro nketxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Onà wyaro nkekon xarha tà, Txesusu. Onà wyaro haxa ryhe nomokyaha hampànà, Toto me Enusaho, kekon hatà. Toto komo nenytxehkanàr me mpànà nomokyaha ha, omeroron komo nenyàr me mak ha. Àsok tonyxem me hana nay ha, sasa ha, kekon hatà. Sasa tatoko rma, tonyxem me rma haxa nay hamà, kahe ratokoko, kekon hatà. Tawasnye rma haxa tonyxem me nay hamà, sasa. Àro wyaro rma rha, tonyxem me rma haxa mpànà nomokyaha ha, Toto me Enusaho, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Henta ya hana nohsamnohyatxow ha, kwatxenama kom ha, kekon xarha tà. Àmataxahotho hyaka nohsamnohyatxow hamà. Àro wyaro rma rha, atxke ehxemotho komo hyaka nomokyaha hampànà, Toto me Enusaho, tàwya anàhnohtàkatxho menye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Toto komo yeryewhamtoho yatàknatxhe rma, nawanyehe hakahpa harha hampànà, kamàm heno, kekon xarha tà. Awasmehra harha naha hampànà, nuno xarha. Kahe hoye nothahyaha hampànà, xeryko heno xarha. Nosowuhsaha hampànà, kahe hokonotho rma, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Àro wyaro exetxhe rma, nosonyhehe hampànà, Toto me Enusaho. Kahe yawo rma nosonyhehe hampànà, toto komo wya, kekon hatà. Tàwyanye xenyetxhe rma, nekhoketxhe hampànà, toto komo, anaro rha yana komo, omeroro. Nekhoketxhe hampànà, oseryehrà komo, kekon hatà. Toto me Enusaho yomoknàrà yonyatxhe hampànà. Kahrutun wawo nomokyaha. Ehonomnà me xaxa nomokyaha. Ohxe xaxa tonyxem me rma nomokyaha, Toto me Enusaho, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kahe yawon komo nyakyaha xarha. Tanoto komo rma nyakyaha. Nyamoro yomoknàtoko rma, tonytxaxem me mpànà naha ha, waxuru ymo, kekon hatà. Khoryenkomo nwahanonkatxhàyamo yohamnohyatxhe hampànà, nyamoro. Ananye rha nehamnohyatxhe hampànà, yukryeka màtà ymo hoye, kahe màtà ymo hoye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kuknonano me xarha nekarymay hatà. Àsok hana nay ha, nat ha, kekon hatà. Tataskatxhe rma, naten hamà, natà, fek yohà rma. Owyanye atanàrà yonyetoko, onà wyaro màketxow hamà. Mexehra rma haxa tàtxemnyehàntetxow hamà, màketxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Àro wyaro rma rha amnye muhutwetxhe hampànà. Àro wyaro owyanye ronekarymatxho yonyetoko, onà wyaro màketxhe hampànà. Mexehra rma haxa nomokyan hamà, Toto me Enusaho, màketxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Onà wyaro yaworo xaxa àkehe, owyanye, kekon xarha tà. Àwayehtàkahra natxhe hampànà, amnyeno rma kukur komo. Ehtokonye rma haka nehoryatxhe hampànà, ronekarymatxho, omeroro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nosomtatkehe hampànà, kahe heno. Yukryeka heno xarha nosomtatkehe hampànà. Rorwon haxa ryhe, osomtatkahra ro mak naha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Onà wyaro nkekon xarha tà, Txesusu. Àsokentok hana nomokyan ha, Toto me Enusaho, kekon hatà. Omohtoho yawasànà ywero naha, royàmà, noro marma mak ha. Àywenyeke mak natxhe ha, toto komo, kekon hatà. Àywenyeke rma rha natxhe, kahe yawon komo xarha. Àywenyeke rma rha naha, Khoryenkom muru xarha. Royàm marma ryhe, àywero naha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nowe heno yehtoko tuna ymo yomokàthàrànhàrà wyaro nomokyaha hampànà, Toto me Enusaho. ");
INSERT INTO hixNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Àsok hana nehxatxhkon ha, nyamoro heno ha, kekon hatà. Tuna ymo yomokhàra ro rma haka, tànyahrà kom hoko nehxatxkon hamà. Thehtanàr kom hoko xarha nehxatxkon hamà. Tànyontanàr kom hoko xarha nehxatxkon hamà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tanàhnohtoho komo ywenyeke rma hak nehxatxkon hamà, tuna ymo wya, kekon hatà. Tkanawarà ymo kom yaka Nowe heno komo yosonkahàtxhe rma, nomokye hatà, tuna ymo. Toto heno komo yanàhnohtàkay hatà. Àro wyaro rma rha àywenyeke toto komo yehtoko, nomokyaha hampànà, Toto me Enusaho, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Noro yomohtoho ho, bararàn kom hoko natxow hana, toto komo, asako. Anaro, tanàmsom me mpànà naha ha. Anaro haxa ryhe, tànomsom me mpànà naha ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Àto rye xerye kyatxow hana, woràskomo, asako. Anaro, tanàmsom me mpànà naha ha. Anaro haxa ryhe, tànomsom me mpànà naha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Àro ke, thona ro mpànà ehtxok ha. Àsokentok hana nomokyan ha, oyohkom ha. Omohtoho yawasànà ywenyeke manatxhe. Àro ke, thona ro mpànà ehtxok ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Onà wyaro uhutwamohsehe xarha, owyanye, kekon xarha tà. Àsok hana natxow ha, temenyem kom ha. Toto katxhotho yanàr xe tehtokonye, tomohtoho yokarymahra natxow hamà, noro wya. Àro ke uhutwahra rma nay hamà, toto, kekon hatà. Tàwya uhutwantok haxa, ànàkhàra esnàràtho haryhe mà, thona ro esnàràtho haryhe mà, bàn yaka owomrà kom hona xenyàràtho haryhe mà, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Àro wyaro rma rha, thona ro mpànà ehtxok ha, omnyam xarha. Àsokentok hana nomokyan ha, Toto me Enusaho. Owyanye omokhàra hak nay hamà tatoko rma, nomokyan hamà. Àro ke, thona ro mpànà ehtxok ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kuknonano me rma rha nekarymay xarha tà. Bàn yaye tàtontoko, anotomano yeryan hamà, horykomo, kekon hatà. Tanoto komo yoh xarha wahanonken hamà. Toyuknye ro rma wahanonken hamà. Takàhsomà rma wahanonken hamà, tanoto komo yoh me noro yehtxoho me, kekon hatà. Romàn yawon komo xenyko, rohnawo, ken hamà, horykomo, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Àsok hana nay ha, anoto komo yoh ha. Anatoko àhoko roro nay hana, tanotomanyenhàrà rwon yawo ro mak ha, kekon hatà. Tomokàtxhe harha, àhoko roro noro yehtxoho yonyan hamà, horykomo. Àro ke noro yowakryen hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Onà wyaro yaworo xaxa àkehe, owyanye. Tkatxho yoh me noro yeryan hamà, horykomo. Omeroron yoh me noro yeryan hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Àsok haxa hana nay ha, anoto komo yoh ha. Anatoko àhokohra rma nay hana. Tanotomanyenhàrà rwon yawo rohra harha nay hana, kekon hatà. Onà wyaro haxa nken hamà, tàwya rma. Nàramamyan hamà, horykomo, ken hamà. Omokhàra mak nay hamà, ken hamà, tàwya rma. Àro ke, àsok make rma haxa nay hamà, atxke tehtxoho hoko. ");
INSERT INTO hixNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Horykomo yanototho komo hpokyan hamà, kekon hatà. Tkukuthuyamo rma hpokyan hamà. Teryehotanàr hoko xarha nay hamà, tasahxemtonàr hoko. Tànyerhontanàr hoko xarha nay hamà, tanotomanyenhàrà ramamrà ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Àsok tawro hana. Omokhàra mak nay hamà, horykomo, ken hamà, noro. Àro wyaro àwya tatoko rma, nomokyaha hampànà, horykomo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Norotho yanàhnohyaha hampànà. Thenyehra rma haxa nanàhnohyaha hampànà. Yaworonohnà rotho komo hyaka neryan hamà, anàhnohno ytxoho ro na, kekon hatà. Àton heno komo rma nàratetxhe hxak hampànà, teryewhamnohrà kom ke. Àro ke, Toto me Enusaho yomohtoho hona ro mpànà ehtxok ha, omnyamo, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kuknonano me rma rha nekarymay xarha tà, Txesusu, tànhananàhrà ro komo wya. Àsok hana akayaryet kom me nay ha, Khoryenkom ha, kekon hatà. Toto me Enusaho yomoknàtoko, akayaryet kom me harha nay hamà. Noro yomohtoho rma, onà wyaro nay hamà. Àhehtaxe toto yomohtoho wyaro nay hamà, kekon hatà. Àhehtaxe noro yomoknàtoko, ehoso totxownà hatà, omaso komo, àhetxe yanoto komo. 10 komo rma nyamoro hatà, omaso komo. Noro yohoso tàtontokonye rma, namparyena yatxownà hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Akàhpàra mak nehxatxkon hatà, ukukur komo, 5 komo rma. Tàwyanye namparyena yanàtoko, kerosenà yarhàra rma nehxatxkon hatà. Anar kom haxa ryhe, 5 komo rma rha, takàhso nehxatxkon hatà. Tàwyanye namparyena yanàtoko, kerosen xarha yatxownà hatà. Kerosen yonà rma, aràhtosaho rma yatxownà hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nàramamyakon mak hatà, toto, àhehtaxe tomohsomà. Àro ke nànàhtxownà hatà, omaso komo, omeroro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kohsa rakatawo nomokye hatà, noro. Àhehtaxe nomokyan hatà, ketxkon hatà, toto komo. Noro ehotatxko, omaso komo y, ketxkon hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tàwyanye enytxatxhe rma, hakatxownà hatà, omaso komo, omeroro. Tweyur komo hotuhtotxownà hatà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Onà wyaro nketxkon hatà, akàhpàn komo, takàhsom komo wya. Amna namparyenanàtho newehno, ketxkon hatà. Okerosenyen kom hoye tàmtxoko, amna wya, amna namparyenan yaràrà, ketxkon hatà, akàhpàn komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Àna matà, ketxkon mak hatà, takàhsom komo. Tàmpàra amna nay hamà. Àwararohra nay hana, kerosenà. Ehekahtatxko ha, kerosen yàmnye ro komo hyaka, ketxkon hatà, takàhsom komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Àro ke, ehekahso totxownà hatà, akàhpàn komo, kekon xarha tà. Àyaràhnawonye rma nomokye haxa hatà, toto. Àhehtaxe toy hatà, nàmno yaka, kekon hatà. Noro yakoro totxownà hatà, omaso komo, takàhsom komo. Noro yakoro asahxemtoso totxownà hatà, takàhso tesnàr kom ke, thona ro rma haxa tesnàr kom ke, kekon hatà, Txesusu. Owomàtxhenye rma, tahuso harha nexey hatà, àmàn hotar komo. ");
INSERT INTO hixNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Amnye nomohtxownà harha tà, anar komo, akàhpàn komo rma. Amna yohà y, amna yohà y, ahurmakako, amna yowomtoho me, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Àna matà, kekon mak hatà, noro ha, àwyanye. Onà wyaro yaworo xaxa àkehe, owyanye. Oywenyekenye wehxaha, kekon hatà, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Àro wyaro rma rha nomokyaha hampànà, Toto me Enusaho, kekon xarha tà. Noro yomohtoho yawasànà ywenyek mak manatxhe. Àro ke, thona ro mpànà ehtxok ha, takàhsom komo wyaro, akàhpàn komo wyarohra mak ha, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Àsok hana nay ha, Toto me Enusaho yomohtoho, kekon xarha tà, Txesusu, tànhananàhrà ro komo wya. Onà wyaro nay hamà. Mox tàtonàr xe nehxakon hatà, horykomo. Àro ke, tanoto komo yanyekye hatà. Tàtxenyerun yoh me harha netxownà hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Àwarawantanàr komo xe nehxakon hatà, tàtxenyerun ke. Thenyehra nàmye hatà, anaro wya, tàywero rma haxa esnàr ke hatà, kekon hatà. Àro ke, 5 meryaw txenyeru yàmye hatà, àwya, thenyehra hatà. Noro yosnaka tàywero nehxakon hatà, anaro, anoto xarha. Àro ke, esnaka rma rha txenyeru yàmye hatà, àwya. 2 meryaw yàmye hatà, àwya, kekon hatà. Noro yosnaka rma haxa tàywero nehxakon hatà, anaro, anoto xarha. Àro ke, esnaka rma rha txenyeru yàmye hatà, àwya. 1 meryaw marma yàmye hatà, àwya. Àro wyaro tàwya tàmtàhkatxhe rma, toy hatà, horykomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","5 meryaw yahosnyenhàrà ryhe, amamehra warawantay hatà. Twarawantatho hoye ro 5 meryawu rma rha yahosày hatà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Àro wyaro rma rha, 2 meryaw yahosnyenhàrà xarha, 2 meryawu rma rha yahosày hatà, twarawantanàr ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","1 meryaw yahosnyenhàr haxa ryhe, àwarawantahra ro mak nehxakon hatà. Txenyerutho yonamye hatà, yukryeka waka. Tanotomanye nàmàthàràtho rma yonamye hatà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Mexe rma haxa ehxah me nomokye harha tà, horykomo, anotomanyenhàyamo, kekon hatà. Àwarawantathàyamotho hutwanàr xe nehxakon hatà. Àro ke nanyehtxownà hatà, tàhyaka, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","5 meryaw yahosnyenhàrà htxero nomokye hatà. 5 meryaw xarha txenyeru yokye hatà, horykomo hyaka. Rohà y, kekon hatà, àwya. 5 meryaw txenyeru màmye, rowya. Rowarawantatho hoye ro 5 meryawu rma rha wahohsako, otxenyerunu, kekon hatà, noro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ohxe mehxak hamà, kekon hatà, horykomo, àwya. Ranoto me yaworo mehxak hamà, rotxenyerun hoko, yakenohnà hoko rma. Thenyenohnà haxa yoh me harha keryaha, kekon hatà. Ohoko teryehorye wehxaha. Àro ke, rowyaro rma rha teryehorye exko, omoro xarha, kekon hatà, horykomo, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","2 meryaw yahosnyenhàrà xarha nomokye hatà. Rohà y, kekon hatà. 2 meryaw txenyeru màmye, rowya. Rowarawantatho hoye ro 2 meryawu rma rha wahohsako, otxenyerunu, kekon hatà, noro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ohxe mehxak hamà, kekon hatà, horykomo, àwya. Ranoto me yaworo mehxak hamà, rotxenyerun hoko, yakenohnà hoko rma. Thenyenohnà haxa yoh me harha keryaha, kekon hatà. Ohoko teryehorye wehxaha. Àro ke, rowyaro rma rha teryehorye exko, omoro xarha, kekon hatà, horykomo, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","1 meryaw yahosnyenhàrà xarha nomokye hatà. Onà wyaro haxa nkekon hatà, horykomo wya. Rohà y, onà wyaro khutweknano, kekon hatà. Tanàhnohso ro amna manotomehe. Ohoye rohra, amna hoye ro haxa, anyahtehe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Àro ke koseryehyako, ohona. Otxenyerunuthuru wenamyako, yukryeka waka. On harha otxenyerunuthuru, onàmàthàràtho rma, kekon hatà, horykomo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Onà wyaro haxa neyukye hatà, horykomo. Atxke mehxak hamà, owya ranweknàr ke, kekon hatà, tanoto wya. Wenyhe mehxak hamà. Àwarawantahra mehxak hamà, kekon hatà. Ohoye rohra, amna hoye ro haxa, anyahtehe, màkano, rohoko, kekon hatà. Àro wyaro rohutwanye me manay hamà, kekon hatà, horykomo, tanoto wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Àro ke, tàmporye nehxak haryhe, rotxenyerunu, txenyeru hokono ro komo wya, kekon hatà, horykomo. Txenyeru yehetho yàmnye ro me natxow hamà, nyamoro, kekon hatà. Tàhyawonye rotxenyerunu yehtok haxa, rowya harha tàmràtho haryhe àwyanye, eho nyhe tàmràtho haryhe àwyanye, romokàtxhe harha, kekon hatà, horykomo, noro wya, tanototho wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Àro ke, onà wyaro nkekon xarha tà, horykomo, àton komo wya, anaro tanoto komo wya, kekon hatà, Txesusu. Rotxenyerunutho atxok ha, noro hyaye, anhàtho hyaye, kekon hatà, àwyanye. Anaro wya ryhe tàmtxok harha. 10 meryawu yahosnyenhàrà wya rma tàmtxoko, kekon hatà, horykomo, tanoto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Onà wyaro nkekon xarha tà, horykomo, tanoto komo wya. Tkatxhonke rma oyehtokonye, thenyehra nyhe mahohsatxhe xarha, akatxho komo xarha, kekon hatà. Àkatxhomra oyehtokony haxa, ahohsàra ro mak manatxhe hampànà. Akatxhothàyamo rma, yakenohnàtho txko rma, natarymatxehkehe hampànà, kekon hatà, horykomo, tanoto komo wya, kekon hatà, Txesusu. Àro wyaro rma rha, towakryexem me xarha natxhe, Khoryenkomo newakryetxho komo, noro yoyuknyenhàyamo. Àro wyaro rma rha, ewakryehnà me rma natxhe hampànà, ewakryehnàtho komo, noro yoyuknyehnànhàyamotho, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Onà wyaro nkekon xarha tà, horykomo, tanoto komo wya, kekon xarha tà, Txesusu. Ranototho arymatxok ha, romàn yaye, awarànà ymo waka, kekon hatà, horykomo, àwyanye, kekon hatà, Txesusu. Àro wyaro rma rha tanàhnohsom me natxhe hampànà, Khoryenkomo yoyuknyehnànhàyamotho. Tarymaxem me natxhe hampànà, nyamoro heno, anàhnohno ytxoho ro na. Àton heno komo rma nàratetxhe hxak hampànà, teryewhamnohrà kom ke, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Onà wyaro nkekon xarha tà, Txesusu, tànhananàhrà ro komo wya. Amnye komokyaha harha hampànà, Toto me Enusah kaxe, kekon hatà. Ehonomnà me xaxa komokyaha hampànà. Rakoro nomokyatxhe xarha, kahe yawon komo, Khoryenkom yanoto komo, kekon hatà. Romokàtxhe rma, ehonomnà me xaxa keryewtehe hampànà, rahonà ymo hona. Toto komo kayaryet me harha keryewtehe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Rohyaka nohsamnohtàketxhe hampànà, toto komo, anaro rha yana komo, omeroro. Àtoko wahanonkano weryaha hampànà, kekon hatà. Àsok hana toknà komo wahanonketxow ha, okno yonye ro kom ha. Onà wyaro nwahanonketxow hamà. Kahneru komo wahanonketxhe. Kakmàryetu xarha wahanonketxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kahneru komo yeryatxhe, thanakanye, howehehra. Howehe haxa ryhe kakmàryetu komo yeryatxhe. Àro wyaro nwahanonketxow hamà, okno yonye ro komo, kekon hatà. Àro wyaro rma rha wahanonkano weryaha hampànà. Ohxe ehxemo komo weryaha, rohanaka, howehehra. Atxke ehxemotho kom haxa ryhe weryaha, howehe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Onà wyaro àkehe hampànà, ohxe ehxemo komo wya, howehenohnà komo wya, àkayaryet komo kaxe. Omohtxoko, rowto hona, Khoryenkom yowto hona, àkehe hampànà, àwyanye, kekon hatà. Royàm newakryetxho me manatxhe, omnyamo. Noro yowto hon me harha manatxhe, àkehe hampànà, àwyanye. Àsok tawro hana. Tàwya akàhtono yeryetxhe rma, onà wyaro kanyenhàr me nehxakonà, Khoryenkomo, àkehe hampànà, àwyanye. Romryenon komo ryhe, rowto hon me harha natxhe hampànà, kanyenhàr me nehxakonà, Khoryenkomo. Àro wyaro àwya katxhàrànhàrà yawo ro manatxhe, omnyamo, àkehe hampànà, ohxe ehxemo komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Àsok tawro hana. Rahyehnàtoko, uro mànyahmetxkonà, àkehe xarha, àwyanye. Twohtxahke ryehtoko, uro màwokhetxkonà, àkehe xarha, àwyanye. Hawana me ohyakanye romoknàtoko, uro mewakryetxkonà, àkehe xarha, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Anyempera ryehtoko, uro manyempetetxkonà, àkehe xarha, àwyanye. Ekeh me ryehtoko, rakoronomaxe momokyatxkonà, àkehe xarha, àwyanye. Watxa ymo yawo ahryemxah me ryehtoko, rowakryexe momokyatxkonà, àkehe xarha, àwyanye, ohxe ehxemo komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Onà wyaro nketxhe hampànà, nyamoro, enyhoru komo rma, rowya, kekon xarha tà. Amna yohà y, ayahyehrà hutwahra mak amna nehxakonà, àro ke anyahmahra amna nehxakon hamà, ketxhe hampànà, rowya. Twohtxahke oyehtxoho hutwahra rma rha amna nehxakonà, àro ke owokhahra amna nehxakon hamà, ketxhe xarha, rowya. ");
INSERT INTO hixNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hawana me oyomohtoho hutwahra rma rha amna nehxakonà, àro ke oyowakryehra amna nehxakon hamà, ketxhe xarha, rowya. Anyempera oyehtxoho hutwahra rma rha amna nehxakonà, àro ke ayanyempetohra amna nehxakon hamà, ketxhe xarha, rowya. ");
INSERT INTO hixNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ekeh me oyehtxoho hutwahra rma rha amna nehxakonà, watxa ymo yawo ahryemxah me oyehtxoho hutwahra rma rha amna nehxakonà, àro ke ayakoronomaxe àtohra amna nehxakon hamà, ketxhe xarha, ohxe ehxemo komo, rowya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Àro wyaro àwyanye katxhe rma, onà wyaro haxa àkehe hampànà, àwyanye, kekon xarha tà. Onà wyaro yaworo xaxa àkehe, owyanye, àkehe hampànà. Rowtà komo ryhe makoronometxkonà, omnyamo, àkehe hampànà, àwyanye. Norohnàtho komo rma makoronometxkonà. Nyamoro yakoronomanye rma, uro haxa makoronometxkonà, àkehe hampànà, ohxe ehxemo komo wya. Àro wyaro àkehe, uro, àkayaryet komo rma, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Onà wyaro haxa àkehe hampànà, anar komo wya, atxke ehxemotho komo wya, howehenotho komo wya, kekon xarha tà. Àtotxok ha, rohyaye, àkehe hampànà, àwyanye. Tanàhnohsomà ro me manatxhe hampànà. Àtotxok ha, eryewhamnohno ytxoho ro na, weheto ymo wyarono rma hona, ewehpànà ro ymo wyaron hona, àkehe hampànà, àwyanye. Àro hoko rma, onà wyaro kanyenhàr me nehxakonà, Khoryenkomo. Eryewhamnohno ytxoho ro hon me natxhe hampànà, worokyamo yohà ymo heno, anoto heno komo xarha, kanyenhàr me nehxakonà, Khoryenkomo, àkehe hampànà, àwyanye, atxke ehxemo komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Àsok tawro hana. Rahyehnàtoko, ronyahmahra mehxatxkonà, omnyamo, àkehe xarha, àwyanye. Twohtxahke ryehtoko, rowokhahra mehxatxkonà, àkehe xarha, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Hawana me ohyakanye romoknàtoko, rowakryehra mehxatxkonà, àkehe xarha, àwyanye. Anyempera ryehtoko, ranyempetohra mehxatxkonà, àkehe xarha, àwyanye. Ekeh me ryehtoko, rakoronomaxe omokhàra mehxatxkonà, àkehe xarha, àwyanye. Watxa ymo yawo ahryemxah me ryehtoko, rowakryexe omokhàra mehxatxkonà, àkehe xarha, àwyanye, atxke ehxemotho komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Onà wyaro nketxhe hampànà, nyamoro, rowya, kekon xarha tà. Amna yohà y, ayahyehrà hutwahra mak amna nehxakonà, twohtxahke oyehtxoho hutwahra rma rha amna nehxakonà, ketxhe hampànà, rowya. Hawana me oyomohtoho hutwahra rma rha amna nehxakonà, anyempera oyehtxoho hutwahra rma rha amna nehxakonà, ketxhe xarha, rowya. Ekeh me oyehtxoho hutwahra rma rha amna nehxakonà, watxa ymo yawo ahryemxah me oyehtxoho hutwahra rma rha amna nehxakonà, àro ke ayakoronomahra amna nehxakon hamà, ketxhe xarha, atxke ehxemotho komo, rowya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Onà wyaro yaworo xaxa àkehe, owyanye, àkehe hampànà, àwyanye, kekon xarha tà. Ohxehra rowtà komo yehtxoho muhutwetxkonà, àkehe hampànà, àwyanye. Nyamoro yakoronomahra mak mehxatxkonà. Nyamoro yakoronomanyehnà rma, uro haxa rakoronomahra mehxatxkonà, àkehe hampànà, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tanàhnohso roro natxhe hampànà, nyamoro ha, atxke ehxemotho komo. Anàhnohno ytxoho ro na tasom me natxhe hampànà. Enyhoru kom haxa ryhe, karyhe roro natxhe hampànà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Àro wyaro tàwya ekarymatxehkatxhe, onà wyaro nkekon xarha tà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Asako ro enmahàtxhe, tasahxemtetxow hamà, kekon hatà, àwyanye. Tasahxemtetxow hamà, khoryen heno komo yohokoko àtothàrànhàrà hutwahkahpàra kehtxoho menye. Àtoko rma tahohsosom me mpànà wehxaha ha, uro, Toto me Enusaho, anhà komo wya. Nyamoro rma ramoyathetxhe hampànà, yahkotohen hona, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Taa. Nohsamnohtàkatxownà hatà, Xuknewyana yoh komo, Khoryenkom màn yonye ro yoh komo rma, horykomo kom yakoro xarha. Osonytxaxe nohsamnohtàkatxownà hatà, Kayfas mànà ymo yaka. Khoryenkom màn yonye ro komo yohà ymo rma noro ha, Kayfasà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nosonytxatxownà hatà, tàwyanye Txesusu yahohtoho hoko, àwayehkatxho hoko. Ekayhera rma ahosnàr xe nehxatxkon hatà, toto komo nenyehtor me rma. ");
INSERT INTO hixNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Onà wyaro haxa nketxkon hatà. Kasahxemtontokonye, ahohsàra hak tehtxe, ketxkon hatà. Ahohsàra hak tehtxe. Kàwyanye ahosnàtoko rma, ukurunhoso nohsamnohyatxow hamà, toto komo, thenyehra, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Taa. Betanya ho nehxakon hatà, Txesusu. Semaw màn yawo nehxakon hatà, hunmata ymo yawonotho rma màn yaw hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Àto emtakmantoko, àhyaka nomokye hatà, wosà. Ownyaku yokye hatà. Ehetàhpenye rma haxa nehxakon hatà, ownyaku. Enà ryhe, toh me nehxakon hatà. Arakmasturu rma mon nehxakon hatà, tohu. Ownyaku yarkay hatà, wosà, Txesusu yhutho horye. Ehetàhpenyeno rma yarkay hatà, àhorye. Àsok tawro hana, ohxe rma haxa tàwya xenyàr ke hamà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nenytxownà hatà, Txesusu nhananàhrà ro komo. Ewakhàra mak nehxatxkon hatà. Onà wyaro nketxkon hatà, tàwyanye rma. Àsok tawro ownyakutho yanàhnohno harha, mosonà, ketxkon hatà. Àsok tawro ownyakutho yanàhnohno harha. Tarkahoryehra nahko haryhe, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Txenyeru hona tàmporye nahko haryhe. Thenyenohnà rma hona tàmporye nahko haryhe. Txenyeru rma, tàmporye nahko haryhe, àtxenyerumnu ro komo wya, àkatxhomnà ro komo wya, ketxkon hatà, Txesusu nhananàhrà ro komo, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Àrwon komo hutwekon mak hatà, Txesusu. Àro ke, onà wyaro nkekon hatà, àwyanye. Moson hoko àrwomra ehtxoko, kekon hatà. Ohxe rma haxa ryenyo, tàwya rokaryenàr ke. Àro ke àrwomra tehxorye mahtxok haryhe, àhoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Àsok tawro hana. Tano roro rma natxow hamà, àtxenyerumnu ro komo, onewakryenàr komo. Uro haxa ryhe, tano rorohra mak wehxaha. Amnye awawonyehra harha wehxaha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Rowayehpàra ro rma haka rokaryeno, mosonà. Amnye ronamtoho hona rokaryeno, rohorye tàwya arkanàr ke. Ohxe rma haxa ryenyo hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Onà wyaro yaworo xaxa àkehe, owyanye. Tokarymaxem me nay hamà, àrwo yonyhorunu, kekon hatà. Tonytxaxem me nay hamà, toto komo wya, omeroron komo wya. Mosonà wya rokaryetxhàrà xarha, tokarymaxem me rma rha mpànà naha ha. Tonytxaxem me rma rha mpànà naha ha, omeroron komo wya, noro hutwahkahpàra ehtxoho menye, kekon hatà, Txesusu, tànhananàhrà ro komo wya, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Txesusu yahohsonàr xe nehxakon hatà, Xuknasà Eskaryotesà, àxanhàn komo wya. 12 komo kukuru rma mok nehxakon hatà, Xuknasà Eskaryotesà. Àro ke toy hatà, Khoryenkom màn yonye ro yoh komo hyaka. ");
INSERT INTO hixNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Mokàtho ymo wahohsehe hampànà, owyanye, kekon hatà, àwyanye. Wahohsehe hampànà, owyanye. Twahak mehemetxowà, rowya, kekon hatà, Xuknasà, àwyanye. Àro ke txenyeru yàmtxownà hatà, àwya, 30 me hatà, Txesusu yahohtoho hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Àro wyaro tàwya ahosàtxhe rma, Txesusu yahohsotxahke nehxakon hatà, Xuknasà, àwyanye. Àsokentoko tahohsorye naye, kekon hatà, tàwya rma. Amnye nyhe txko tahohsorye nay hamà, kekon hatà, tàwya rma. ");
INSERT INTO hixNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sa, nenmahye haxa hatà, asahxemtotho komo. Ekeyu àwakanomnà yonahtoho katxho rma àro hatà. Àro hoko rma, 7 me nenmahyatxkon yoh hatà, Xuknewyana komo. Wahoro htxeron ho, thoryen heno komo yohokoko àtothàrànhàrà hutwetxkon hatà. Àro rma ho nomohtxownà hatà, ànhananàhrà ro komo, Txesusu hyaka. Henta ryhe amna nenyhoryeno, kasahxemtotho komo, ketxkon hatà, àwya. Henta ryhe amna nenyhoryeno, kasahxemtotho komo. ");
INSERT INTO hixNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Àtotxoko, owto ymo hona, kekon hatà, Txesusu, àwyanye. Àto toto menyatxhe. Onà wyaro màketxhe ha, àwya. Nomokyan hatà, khananàhnye komo, màketxhe ha, àwya. Tàyàmà hyaka tàtotho hahnok nay hatà, màketxhe ha, àwya. Omàn yawo nasahxemten hatà, tànhananàhrà ro kom yakoro, amna yakoro, màketxhe ha, noro wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Àro ke totxownà hatà. Txesusu rwonàmàthàr yawo ro nehxatxkon hatà. Tasahxemtotho komo yonyhoryetxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Àro rma kokmamrà ro nasahxemtotxownà hatà, Txesus komo, tànhananàhrà ro kom yakoro, 12 kom yakoro. ");
INSERT INTO hixNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tasahxemtontokonye rma, onà wyaro nkekon hatà, àwyanye. Onà wyaro yaworo xaxa àkehe, owyanye, kekon hatà. Okukur komo ryhe rahohsehe hampànà, roxanhàn komo wya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Àro wyaro tàwyanye enytxatxhe rma, nekhokatxownà hatà. Osomahyaka onà wyaro nketxkon hatà, àwya. Amna yohà y, ayahohsonye uro, owya, ketxkon hatà, omeroro, osomahyaka. ");
INSERT INTO hixNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Onà wyaro neyuhtxownà hatà, Txesusu. Oryen yaka rakoro àhpanyenhàrà rma, rahohsony me naha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Àwayehso àtehe hampànà, Toto me Enusah kaxe, àmenhosahonhàr yawo ro ryehtxoho me. Tanàhnohsom me mak naha, rahohsonyenhàrà ymo heno. Enurhura tehtok haxa, ohxe esnàràtho haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Onà wyaro nkekon hatà, Xuknasà, ahohsonyenhàrà ymo. Khananàhnye y, ayahohsonye uro, owya, kekon hatà. Omoro rma, ayahohsonye uro màkano, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tasahxemtontokonye rma, ekeyu yanàmye hatà, Txesusu. Apa y, ohxe onàmàthàrà onà, kekon hatà, Khoryenkomo wya. Nàkràskay hatà. Nekamye hatà, tànhananàhrà ro komo wya. Ahohtxoko, kekon hatà, àwyanye. Tohtxoko. Rohun kuknonà rma onà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ufa xkun yonà yanàmye hatà. Apa y, ohxe onàmàthàrà onà, kekon hatà. Nàmye hatà, àwyanye. On hoye entxoko, omnyamo, omeroro, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Rokamsukuru kuknonà rma onà. Kekamsuhkehe, Khoryenkomo wya romryenon komo yonyhoryetxehkany me wehxaha tawro ke. Àro ke kekamsuhkehe, rowya toto komo yonyhoryetxho me, thenyenohnà komo rma yonyhoryetxho me, anhànàthàyamo yowtoho me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Onà wyaro àkehe, owyanye. Ufa xkun yonhàra harha wehxaha, kekon hatà. Royàm yowto ho harha oyehtokonye, anaro meno ufa xkunu tenyatxhe hampànà. Àro hohra rma hak oyehtokonye, enhàra roro rma wehxaha, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tasahxemtotxhenye, wano yatxownà hatà, Txesus komo. Twanotatxhenye rma, totxownà hatà, Oryefera yàhàn hona. ");
INSERT INTO hixNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Onà wyaro nkekon hatà, Txesusu, àwyanye. Amnye rma kohsaya uro màhnànkatxehketxhe hampànà, omnyamo, omeroro, kekon hatà. Anhà komo wya rahohtoho hoye ro, uro màhnànkatxehketxhe hampànà. Àsok tawro hana. Onà wyaro nken hamà, àmenhosahonhàrà. Kahneru komo yonye ro heno wetahehe hampànà. Àro ke natakhahyatxhe hampànà, eknàthàyamo. Àro wyaro rma nkehe, àmenhosahonhàrà. Àro wyaro katxhàrànhàr yawo ro matakhahyatxhe hampànà, rohyaye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Àwayehsahonhàrà rma, kasanàmyaha harha hampànà. Rasanàmàtxhe, oywahonye àtehe hampànà, Karyeryeya yamtar hona, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Onà wyaro haxa nkekon hatà, Petru, àwya. Moxamo ohnànkatxehketxow hana, omeroro. Uro haxa ryhe, ohnànkahra ro mak wehxaha ha, kekon hatà, Petru. ");
INSERT INTO hixNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Onà wyaro yaworo xaxa àkehe, owya, kekon mak hatà, Txesusu, àwya. Noro ywenyeke wehxaha màkehe hampànà, rohoko. Màkehe xarha, màkehe xarha, osorwawo ro, kekon hatà. Àro wyaro rma màkehe hampànà, amnye rma kohsaya, apaytara htàmpàra ro rma haka, kekon hatà, Txesusu, Petru wya. ");
INSERT INTO hixNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Àro wyaro kahra wehxaha, kekon hatà, Petru, àwya. Noro ywenyeke wehxaha kahra ro mak wehxaha ha, ohoko. Norotho xarha àwayehkatxoko katxho me rma ryehtoko, àro wyaro kahra rma wehxaha, kekon hatà, Petru. Àro wyaro rma rha nketxkon hatà, ukukur komo xarha, Txesusu nhananàhrà ro komo rma, omeroro. ");
INSERT INTO hixNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nat waka totxownà hatà, Txesus komo, tànhananàhrà ro kom yakoro. Ketsemane rma àro hatà, nat yosotà. Eryewtatxoko, kekon hatà, Txesusu, àwyanye. Tan ehtxoko. Uro ryhe, meya nyhe txko àtehe. Khoryenkom yakoro àrwonàmso àtehe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Petru yarày hatà. Sekmeknew muru komo xarha yarày hatà, takoro. Meya nyhe txko totxownà hatà. Nekhokay harha tà, Txesusu. Noseryehokay harha tà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Thenyehra koseryehokehe, rohnawo, kekon hatà, Petru komo wya. Àwayehpaya wehxan hamà, roseryehokanàr ke. Tano rma hak ehtxoko. Tonke rma ehtxoko, owyanye rakoronomanàr horà, kekon hatà, Txesusu, Petru komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Meya nyhe txko toy xarha tà. Tano me ro rma nehurkay hatà, yukryeka hona. Onà wyaro nàrwonàmye hatà. Apa y, ryeryewhamtoho hona uro ukurunhoko, rokurunhonàr xe oyehtok mak ha, kekon hatà. Rano me rohra mak ryesnàr xe wehxaha. Ayano me ro ryhe ryesnàr xe wehxaha, kekon hatà, Txesusu, Khoryenkomo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nomokye harha tà, Petru komo hyaka. Nànàkyatxkon hatà. Onà wyaro nkekon hatà, Petru wya. Ownàhtxow hamà, kekon hatà, àwya. Tonke ehtxoko àkan haxa hawe, owyanye. Mexehra ownàhtxow hamà. Rakoronomahra mahtxok hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tonke ehtxoko. Khoryenkom yakoro orwonàmtxoko, anhà nkukmahtor me oyehtxoho menye, kekon hatà. Ohxe oyesnàr komo xe rma manatxhe haryhe, ohnawonye. Ahoxemra mak manatxhe, ohun kom ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Toy xarha tà. Nàrwonàmye xarha tà. Apa y, ryeryewhamtoho hona rokurunhohra oyehtoko, keryewhamyaha rma, ayano me ro mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nomokye harha tà, Petru komo hyaka. Nànàkyatxkonà rma hatà, twetun kom ke rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Àro ke toy xarha tà, àhyayenye. Nàrwonàmye xarha tà. Àro wyaro osorwawo ro nàrwonàmye hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nomokye harha tà, Petru komo hyaka. Ownàkyatxowà rye rma hamà, kekon hatà, àwyanye. Ownàkyatxowà rye rma hamà. Ahakatxok ha. Àsok tawro hana. Tahohsoso haxa wehxan hamà, anhà komo wya, Toto me Enusah kaxe, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Asanàmtxok ha. Àpa txow ha. Mok noro hamà, rahohsonye ymo, kekon hatà, Txesusu, Petru komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Àro wyaro Txesusu wya tatoko rma, nomokye hatà, Xuknasà. 12 komo kukuru rma mok nehxakon hatà. Toto komo yokyakon hatà, takoro. Thenyehra rma haxa nehxatxkon hatà, omohxemo komo. Xuknewyana yoh komo nànyaketxho rma mokyam nehxatxkon hatà, Khoryenkom màn yonye ro yoh komo nànyaketxho komo rma, horykomo komo nànyaketxho komo rma. Twatmanke nehxatxkon hatà. Tkatxefaranke xarha nehxatxkon hatà, àyehrye komo rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Onà wyaro kanyenhàr me nehxakon hatà, Xuknasà, àwyanye. Noro mpànà wamtxuhkehe ha, noro rma mahohsatxhe hampànà, kanyenhàr me nehxakon hatà, ahohsonye ymo. Àro wyaro kanyenhàr me nehxakon hatà, Txesusu ywero ehtxoho menye. ");
INSERT INTO hixNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tomokàtxhe rma, Txesus yawo ro toy hatà. Ha y, khananàhnye y, kekon hatà. Namtxuhkay hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Hoymo y, rahohsoso momokno hamà, mokyamo wya, kekon hatà, Txesusu, àwya. Uro ahohsoko rma, kekon hatà. Àro wyaro àwya katxhe rma, àhyaka haxa nomohtxownà hatà, Xuknas yakoron komo. Txom, nahohtxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tkatxefaranà wakay hatà, Txesus yakoron komo kukuru. Khoryenkom màn yonye ro komo yohà ymo yanototho hanakay hatà, txaray. ");
INSERT INTO hixNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Onà wyaro haxa nkekon hatà, Txesusu, àwya. En yaka harha enkahko, akatxefaranà, kekon hatà. Katxefara ke otahano ynye me oyehtokonye, katxefara ke rma rha totahaxem me manatxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ukurunhohnà uro. Ryekurunhonàr xe ryehtoko, royàm yakoro rorwonàmràtho haryhe, uro ukurunhoko tawrotho haryhe rowya, rakoronomanàràtho haryhe àwya, kahe yawon komo nyaknyàràtho haryhe àwya, thenyenohnà komo rma nyaknyàràtho haryhe àwya. Àro wyaro uhutwahra kat manatxowà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Noro wya rokurunhontok haxa, àmenhosahonhàr yawo rohra ryesnàràtho haryhe. Àro yawo ro rma haxa mpànà wehxaha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Onà wyaro nkekon xarha tà, waha komo wya, tahosnyenhàyamo wya. Àsok tawro twatmanke momohtxowà, kekon hatà. Àsok tawro tkatxefaranke momohtxowà. Waha me uro menyatxow hamà. Àro ke twatmanke momohtxow hamà, owyanye rahohtoho me, kekon hatà, Emahona ro Khoryenkom màn yawo wehxaknano, hananàhno ynyàr hoko. Àto rma ryehtoko, rahohsàra rma mehxatxkenano, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amnye rma haxa uro mahohtxowà, àmenhosahonhàr yawo ro ryehtxoho me, Khoryenkomo rwonà yokarymanye ro heno komo nmenhotho yawo ro ryehtxoho me, kekon hatà, Txesusu. Àtoko rma noro hnànkatxehkatxownà hatà, ànhananàhrà rotho komo, omeroro. Nekahtàmtàhkatxownà mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Txesusu yatxownà hatà, ahosnyenhàyamo. Kayfas màn yaka natxownà hatà, Khoryenkom màn yonye ro komo yohà ymo màn yaka. Àro yaka rma ohsamnohsah me nehxatxkon hatà, tosonytxaxemà ro komo, àyweronàhyamano ynye ro komo rma, horykomo kom yakoro xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Txesus wenarye toy hatà, Petru, moxe nyhe hatà. Kayfas màn watxan yaka ryhe toy hatà. Àro yaka rma nowomye hatà. Àto rma neryewtay hatà, Kayfas yanoto komo hyawo. Osonytxatxho komo yonytxanàr xe nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Txesus wayehkanàr xe nehxatxkon hatà, Khoryenkom màn yonye ro yoh komo, tosonytxaxemà ro kom yakoro. Àro ke, noro yanhànà yonyenhàyamo yohoryatxkon hatà. Yaworonohnà komo rma yohoryatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ehxera ro mak nehxatxkon hatà, noro yanhànà yonyenhàyamo. Yaworohra ekarymany kom haxa ryhe, yak nehxatxkon hatà. Àmahyakanye nomohtxownà xarha tà, asakon komo. ");
INSERT INTO hixNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Onà wyaro nketxkon hatà. Mosonà amna nenytxeko, ketxkon hatà. Onà wyaro nkeknan haryhe. Khoryenkom mànàtho yarymatxehkanye uro, keknano. Atarymatxehkaxahotho rma weryaha harha, keknano. Osorwawo ro enmahàtxhe, weryaha harha, Khoryenkom mànà, keknano, mosonà, ketxkonà rma haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nasanàmye hatà, Khoryenkom màn yonye ro komo yohà ymo. Onà wyaro nkekon hatà, Txesusu wya. Eyukhuranye manaye, kekon hatà. Eyukhuranye manaye. Yaworo katà, yaworohra haxa katà, àro wyaro oyokarymetxowà, moxamo, kekon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tatàknye rma nehxakon hatà, Txesusu. Àro ke, onà wyaro nkekon xarha tà, noro ymo, àwya. Oskarymak xaxa mak hampànà, amna wya, kekon hatà. Yaworo xaxa oskarymak hampànà, Khoryenkomo wya oyomtatkanàr hona, tehxemà ro wya oyomtatkanàr hona. Kryestu omoro, owya. Khoryenkom muru omoro, owya. Yaworo xaxa oskarymak hampànà, amna wya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Omoro rma, Kryestu omoro, Khoryenkom muru omoro, màkano, kekon hatà, Txesusu. Onà wyaro xarha àkehe, owyanye. Amnye uro menyatxhe hampànà. Toto me Enusaho rma menyatxhe hampànà, kekon hatà. Khoryenkom hanaka eryewtaxaho rma menyatxhe hampànà, howehehra eryewtaxaho rma. Àro wyaro ehonomnà me xaxa uro menyatxhe hampànà, kekon hatà. Kahrutun wawo romoknàrà xarha menyatxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Àro wyaro Txesusu wya katxho rma, atxke rma haxa nehxakon hatà, noro ymo wya. Neryehokatxehkay hatà. Àro ke, thononàthàrà yawotoy hatà, teryehokatxho hutwamohsonàr horà. Khoryenkomo wyaro ehonomnà me nosonyan hamà, mosonà, kekon hatà. Khoryenkomo wàràhyaken hamà. Menytxatxowà rma, kekon hatà. Àro ke, anhàn yokarymany komo yonytxahra harha tehtxe. ");
INSERT INTO hixNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Àsok màketxowà, omnyamo, moson hoko, kekon hatà. Àsok màketxowà, moson hoko. Onà wyaro neyuhtxownà hatà, tosonytxaxemà ro komo. Twayehkahorye naha, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Txesusu yompatar horye netahtatxownà hatà. Netahatxownà xarha tà. Empatawo nahetxownà xarha tà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Onà wyaro nketxkon hatà, etahany kukur komo, àwya. Onok oyotahano, etaxko mpa, ketxkon hatà. Kryestu me oyehtoko, etaxko, oyotahanyenhàrà, ketxkon hatà. Àro wyaro newnohyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Màmyaye rma nehxakon hatà, Petru. Nàmno watxan yawo rma eryewtaxaho nehxakon hatà. Àhyaka nomokye hatà, omaso, anotonano. Txesus yakoronotho komo kukuru omoro hamà, kekon hatà, àwya. Karyeryeya yamtar hon yakoronotho omoro hamà, kekon hatà, omaso. ");
INSERT INTO hixNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Norohnà uro, kekon mak hatà, Petru. Noro ywenyeke wehxaha. Orwonà hutwahra wehxaha, kekon hatà. Àro wyaro nkekon hatà, toto komo nenytxanàr me, omeroron komo nenytxanàr me. ");
INSERT INTO hixNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nàmno watxan hotaka toy hatà. Àto rma ehtoko, nenyey hatà, omaso rma rha. Txesus yakoronotho moson hamà, kekon hatà, àton komo wya. Nasarye honotho yakoronotho rma moson hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Norohnà uro, kekon xarha tà, Petru. Noro ywenyeke wehxaha. Àro wyaro yaworo xaxa àkehe, owya, Khoryenkomo wya romtatkanàr hona, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mexehra exetxhe, Petru hyaka totxownà hatà, àton komo. Nyamoro kukur me xaxa manay hamà, omoro, anar me orwon yesnàr ke, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Noro ywenyeke wehxaha, kekon mak hatà. Noro ywenyeke wehxaha. Àro wyaro yaworo xaxa àkehe, owyanye. Yaworohra rowya tatok haxa, Khoryenkom hak romtatkano, kekon hatà. Àro wyaro nkekon hatà, teryewrye ro hatà. Àro wyaro àwya katxhe rma, nàhtàmye hatà, apaytara. ");
INSERT INTO hixNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Txesusu rwonàmàthàràtho hutway harha tà, Petru. Noro ywenyeke wehxaha màkehe hampànà, rohoko, katxhàràtho rma hutway hatà. Màkehe xarha, màkehe xarha, osorwawo ro, katxhàràtho rma, àro wyaro rma màkehe hampànà, apaytara htàmpàra ro rma haka, katxhàràtho rma hutway hatà, Petru. Àro ke nahatakay hatà, nàmno watxan yaye. Nàratay hatà, thenyehra. Noseryehokekonà rma haxa mak hatà, tàwya noro ywenyeke wehxaha katxhàràtho hok hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Sa, nenmahye hatà. Enmahàtxhe rma nosonytxatxehkatxownà hatà, tosonytxaxemà ro komo, Khoryenkom màn yonye ro yoh komo rma, horykomo kom yakoro xarha. Txesus wayehkatxho hoko nosonytxatxehkatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Noro yasohtotxownà hatà. Natxownà hatà, Peratusu hyaka, kofehnakno hyaka. Nahohsotxownà hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Àsok hana nehxakon ha, Xuknas ha. Onà wyaro nehxakon hatà, noro ymo, Txesusu yahohsonyenhàrà ymo. Twayehkaxem me Txesus yehtxoho yonytxay hatà. Tàwya enytxatxhe rma, anar me harha tanhànàthàrà yonyey hatà. Àro ke 30 txenyerutho yarày harha tà, Xuknewyana yoh komo hyaka harha, Khoryenkom màn yonye ro yoh komo hyaka rma, horykomo komo hyaka xarha. Ahohsotxhetàtho rma yarày harha tà, àhyakanye. Tàmrà xe harha nehxakon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Atxke rma haxa wehxak hamà, kekon hatà, àwyanye. Enyhoru ro ryhe wahohsek hamà, owyanye. Rohoye ro wayehyan hamà, enyhoru ro heno. Atxke rma haxa wehxak hamà, kekon hatà, Xuknasà. Àna matà, ketxkon mak hatà. Ayanhànàthàrà hokonohnà ro mak amna ha. Uhutwanàr xehra amna naha, ketxkon hatà. Àsok tawro amna meryehoken harha. Omoro rma uhutwako, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Àro ke txenyerutho yarymay hatà, Xuknasà. Khoryenkom màn yawo rma 30 txenyerutho yarymay hatà. Àsnye ro toy hatà. Natamposohtoy heno hatà, tano me ro rma. Bo wayehye hatà, Xuknas heno. ");
INSERT INTO hixNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Txenyerutho yamuhtxownà harha tà, Khoryenkom màn yonye ro yoh komo. Khoryenkom màn yaye natxownà hatà. Atxke nay hamà, onàtho, ketxkon hatà. Toto wayehkatxhetàtho rma on hamà. Toto kamsukutho yehetho rma on hamà. Àro ke atxke nay hamà, ketxkon hatà. Tonkahporyehra nay hamà, txenyerun komo yon yaka. Khoryenkom màn yawon yaka rma tonkahporyehra nay hamà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Àsoke ryhe teryatxowà, ketxkon hatà. 30 txenyerutho hoko rma nosonytxetxkon hatà. Toto heno komo yonamtoho tehekahtxe, onàtho hona, txenyerutho hona, ketxkon haxa hatà. Àro ke, toto yowtotho yehekahtxownà hatà. Oryen kahnye ro yowtotho rma yehekahtxownà hatà. Anaro heno komo yonamtoho me harha netxownà hatà, hawana me Xerusaryen hona omohxemo heno komo yonamtoho me rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Àro ke, onà wyaro katxho me harha nehxakon hatà, àro ha. Toto kamsukutho hutwatxho onà katxho me harha nehxakon hatà, owto. Àro wyaro katxho me roro rma naha. ");
INSERT INTO hixNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Àro wyaro àwyanye ehekahtoho hoko rma, yaworo rma haxa nehxakon hamà, àmenhosahonhàrà. Onà wyaro nmenhoy hatà, amnyehra, Xeryemeyas heno, Khoryenkomo rwonà yokarymanye ro heno. Onà wyaro nketxhe hampànà, Ehsayewyana kukur komo. 30 txenyeru ryhe, noro yehetho me hak nahko, ketxhe hampànà. Noro yehethotho hona rma, toto yowtotho yehekahtyatxhe hampànà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Oryen kahnye ro yowtotho rma yehekahtyatxhe hampànà. Àro wyaro rma nmenhoy hatà, Xeryemeyas heno. Txesusu yehethotho hoko ryhe, àro wyaro rma nmenhoy hamà. Anatoko, onà wyaro nmenhoy xarha tà. Kohkom yano me ryhe, oryen kahnye ro yowtotho wehekatàye. Àro wyaro rma nmenhoy hatà, Xeryemeyas heno. ");
INSERT INTO hixNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kofehnakno yakratawo nehxakon hatà, Txesusu, Peratusu yakratawo. Onà wyaro nkekon hatà, noro, àwya. Xuknewyana komo kayaryetà omoro, owya, kekon hatà. Omoro rma, Xuknewyana komo kayaryetà omoro màkano, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Xuknewyana yoh komo yoyukhura mak nehxakon hatà. Noro hoko atxke nàrwonatxkon hatà, nyamoro ha, Khoryenkom màn yonye ro yoh komo rma, horykomo kom yakoro xarha. Eyukhurany mak nehxakon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Àro ke, onà wyaro nkekon xarha tà, Peratusu, àwya. Atxke nàrwonatxow hamà, moxamo, ohoko, kekon hatà. Anaro rha ayanhànà yokarymetxow hamà. Enytxahrany kat manaye, kekon hatà, Peratusu. ");
INSERT INTO hixNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Eyukhura mak nehxakon hatà, Txesusu. Oskarymahra ro mak nehxakon hatà. Ekurunhohra ro mak nehxakon hatà. Àro ke, thenyehra noseryehokay hatà, Peratusu. Àsok tawro oskarymahra nay haryhe, kekon hatà, tàwya rma. ");
INSERT INTO hixNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tasahxemtotho kom ho yohà, toto heno yonampatakahetxkon hatà, Xuknewyana komo, Kofehnakno wya. Watxa ymo yawo ahryemxemotho kom hoye rma nenampatakahetxkon yoh hatà, àwya. Toto kom yano me rma nenampatakahekon yoh hatà, Peratusu. ");
INSERT INTO hixNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Àwyanye Txesusu yahosnàtoko rma, watxa ymo yawo nehxakon hatà, toto. Barakmasà rma noro hatà. Anhà ymo rma haxa mosonà katxho me rma nehxakon hatà, noro. ");
INSERT INTO hixNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Àro ke, onà wyaro nkekon hatà, Peratusu, toto komo wya, ohsamnohxemo komo wya. Onok wenampatakaheno, Barakmas katà, Txesus haxa katà, Kryestu rma noro hatà, kekon hatà. Onok yonampatakahonàr xe manatxowà, rowya, kekon hatà, Peratusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Àsok tawro hana. Onà wyaro nehutwekon hamà, tàhnawo. Txesusu yahohsotxow hamà, eh komo, rowya, tatakuynyàr kom ke hamà, ehonomnà me toto komo wya noro yonyàr ke hamà, kekon hatà, tàhnawo. Àro ke, Txesusu yonampatakahonàr xe nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Thetxe yosenyetàthàrà hoye ro xarha enampatakahonàr xe nehxakon hatà. Tàwya Txesusu yonytxantoko rma, thetxe yosenyetàthàrà yonytxay hatà. Thetxe yanoto rwonà yonytxay hatà. Amnye rma nosenyetno hatà, ohetxe, Txesus hoko, kekon hatà, anoto, àwya. Tosenyetàthàr hoye ro thenyehra noseryehokan hatà, kekon hatà. Enyhoru ro noro hatà, anhànà ehxera ro mak nay hatà, kekon hatà. Àro ke àwayehkahohra exko hatà, kekon hatà, àhetxe yanoto, Peratusu wya. Àro hoye ro rma, Txesusu yonampatakahonàr xe nehxakon hatà, Peratusu. ");
INSERT INTO hixNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Onà wyaro haxa nketxkon hatà, Xuknewyana yoh komo, toto komo wya, ohsamnohxemo komo wya. Barakmas haxa enampatakahoko, katxoko, Peratusu wya, ketxkon hatà. Txesus haxa ryhe àwayehkahoko, katxok xarha, àwya, ketxkon hatà, Khoryenkom màn yonye ro yoh komo, horykomo kom yakoro xarha, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Onà wyaro nkekon xarha tà, kofehnakno, àwyanye. Onok haxa ryhe wenampatakaheno, kekon hatà. Onok yonampatakahonàr xe manatxowà, rowya, kekon hatà. Barakmas haxa enampatakahoko, ketxkon hatà, toto komo, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Àsoke ryhe Txesusu weryano, kekon hatà, Peratusu, àwyanye. Kryestu rma noro hatà. Àsoke ryhe weryano, owyanye, kekon hatà. Amoyathohoko, yahkotohen hona, ketxkon hatà, omeroro. ");
INSERT INTO hixNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Àsok ehtxoho hoye ro wamoyathoheno, kekon hatà, Peratusu. Àsoke ryhe naye, anhànà, owyanye, kekon hatà, toto komo wya. Thenyehra rma haxa kowontetxkon hatà, nyamoro, teryewrye ro rma haxa mak hatà. Amoyathohoko, yahkotohen hona, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ronytxahra ro mak natxow hamà, moxamo, kekon hatà, Peratusu, tàwya rma. Natmeryketxow hamà, kekon hatà. Àro ke tuna yokhoy hatà. Nosomyakorokay hatà, toto komo nenyàr me. Onà wyaro nkekon hatà, àwyanye. Rano me rohra, ayano me rony haxa, tamoyathosom me naha, mosonà. Omnyamo rma, amoyathohony me manatxhe, kekon hatà, Peratusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Àro wyaro hamà, ketxkon hatà, toto komo, omeroro. Amna yano me hak tamoyathosom me nahko. Tanàhnohsom me rma hak amna nehxe. Tanàhnohsom me rma hak nahtxoko, Xuknewyana komo rma, amna yohamrà rma, ketxkon hatà, toto komo. ");
INSERT INTO hixNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Àro ke, Barakmasà yonampatakahoy hatà, Peratusu, nyamoro yano me. Txesusu hpokhoy hatà, arymano ynye ro komo wya. Namoyathohoy xarha tà, àwyanye. Yahkotohen hona amoyathoso atxok ha, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Txesusu yatxownà hatà, arymano ynye ro komo, kofehnakno yanoto komo. Kofehnakno mànà ymo yaka htxero natxownà hatà. Tkukur komo yanyehtxekatxownà hatà. Omeroro rma nohsamnohtàkatxownà hatà, Txesusu hyaka. Noro yownohso nomohtàkatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hononkatxownà hatà. Honomtotxownà harha tà, tàswayem ke, ehonomnà komo hononà wyaron ke, ewnohrà me rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ewekhàrà hryekahtxownà xarha tà, erokon me. Ehonomnà komo yorokonà wyarono rma àro hatà. Suu, noro yhutho hona netxownà hatà, ewnohrà me rma rha hatà. Omamu yàmtxownà xarha tà, àwya. Ehonomnà komo yahoso wyarono rma àro hatà. Emyaka rma netxownà hatà, ewnohrà me rma rha hatà. Tosoknar kom ho neryewtatxownà xarha tà, akrataka. Ha y, Xuknewyana komo kayaryetà y, ketxkonà rma haryhe tà, àwya, ewnohrà me rma rha hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Noro horye netahtatxownà xarha tà. Omamu yahohtxownà harha tà. Àro rma ke noro yhutho yotahatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Àro wyaro tàwyanye ewnohtàkatxhe rma, tàswayemàtho wakatxownà harha tà. Honomtotxownà harha tà, àhononàthàr ke harha. Amoyathoso natxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Amoyathoso Txesusu yaryatxkon hatà, arymano ynye ro komo. Tàtonàr kom me, toto yohotxownà hata. Semawu rma noro hatà. Seryene honotho rma mok nehxakon hatà. Noro wya rma yahkotoheno yarhotxownà hatà. Txesus wayehkatxho rma yarhotxownà hatà, Semawu wya. ");
INSERT INTO hixNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Amoyathono ytxoho ro na nahatakatxownà hatà. Korkota rma àro hatà, esotà. Okno yhutho yotxhotho onà katxho rma àro hatà, Korkota katxho. ");
INSERT INTO hixNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Àwokru yàmyatxkon haryhe tà, Txesusu wya. Tutxunyem yohkuru ke ufa xkunu wakanomaxaho rma àro hatà, àwokru, ehtxe wyaron hatà. Nàmyatxkonà rma haryhe tà, àwya, eryewru hutwahra ehtxoho me. Atxke txko tàwya ukukmatxhe rma, enhàra nehxakon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Namoyathotxownà hatà, yahkotohen hona. Tàwyanye amoyathotxhe rma, àwomunuthuru yokamtxownà hatà, tàwyanye rma. Tohu txko yarymatxownà hatà, tàwyanye xenytxoho me, tàwyanye àrotho uro hamà katxho me. Àro wyaro nekamtxownà hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Neryewtatxownà hatà. Eryewtaxaho rma, noro yonyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Àmenhosaho yetxownà hatà, wewe hona, Txesusu yhutho yohoye. Txesusu mosonà katxho rma, Xuknewyana komo kayaryet heno mosonà katxho rma, menhotxownà hatà, noro yanhànà hutwamohsonàr horà rma haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Àhanawo rma wahanhotho yamoyathotxownà xarha tà, asak hatà. Anaro, howehehra nehxakon hatà. Anaro xarha, howehe nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Txesusu wàràhyaketxkon hatà, toto komo, àhyaha tàtosom komo. Wàh wà nketxkon hatà, ewnohrà me hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Owya ymo hxako, ketxkon hatà. Khoryenkom mànàtho yarymatxehkanye uro, kanyenhàràtho omoro hatà. Atarymatxehkaxahotho rma weryaha harha, kanyenhàràtho rma omoro hatà, ketxkon hatà. Osorwawo ro enmahàtxhe, weryaha harha, Khoryenkom mànà, kanyenhàràtho rma omoro hatà. Àro wyaro ehonomnà me oyehtoko, ekurunhoko, awayehrà hona, ketxkon hatà. Osonyhoryek harha. Khoryenkom muru me oyehtoko, ohtok harha, yahkotohen hoye, ketxkon hatà, toto komo, Txesusu wya, ewnohrà me hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Àro wyaro rma rha newnohyatxkon hatà, Xuknewyana yoh komo xarha, Khoryenkom màn yonye ro yoh komo rma, àyweronàhyamano ynye ro kom yakoro xarha, horykomo kom yakoro xarha. Onà wyaro nketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Toto komo yonyhoryetxownà hatà. Noro rma, osonyhoryehra ro mak nay hamà, ketxkon hatà. Ehsayewyana komo kayaryet me nay hatà. Kàkayaryet kom me tehtoko, yahkotohen hoy hak nàhtono, denyàr kom me, ketxkon hatà. Kàwyanye àhtonàrà yonyetxhe, noro mokro hamà tketxhe ha, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Khoryenkom hona nenyan hatà. Khoryenkom muru uro kanyenhàr me nay hatà. Ukurunhohra mak nay hamà, Khoryenkomo, ketxkon hatà. Noro xe tehtok haxa, ukurunhonàràtho haryhe mà, àwya. Nukrunhon haxa haka, noro xe tehtoko, ketxkon hatà, Xuknewyana yoh komo. Àro wyaro newnohyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Àro wyaro rma rha newnohyatxkon hatà, wahanhotho komo xarha, noro yakoro amoyathoxemotho komo rma. ");
INSERT INTO hixNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kamàmà thataw ehtoko, nawanay harha tà. Ràà kay hatà, yukryeka yamtar horye, omeroro hatà. 3 oras nenatày hatà, tawanye rma hatà. Kokonyehra rma hak ehtoko, tawanye rma hak nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kokonye ehtoko, nàrwonàmye hatà, Txesusu, teryewrye ro hatà. Erye, erye, ryema sakmahtane, kekon hatà. Àro wyaro katxho rma, onà wyaro katxho me rma naha. Rohoryenà y, rohoryenà y, àsok tawro uro màhnànkan harha katxho me rma naha. ");
INSERT INTO hixNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Àro wyaro tàwyanye enytxatxhe rma, onà wyaro nketxkon hatà, àton kukur komo. Eryeyas heno yanyekyan hamà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Àtoko rma karyhe toy hatà, toto, ukukur komo rma, àwokru horà. Sosoheno yaràhtoy hatà, ufa xkun ke, tutxunyem ke rma. Omam hotkoso neryey hatà. Nàmye hatà, Txesusu wya entoho me. ");
INSERT INTO hixNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Thona ro hak tehtxe, ketxkon mak hatà, anar komo. Tenytxe haka, omoknàrà. Nomokyan xana, Eryeyas heno, ketxkon hatà. Ukurunhos xana nomokyano. Tenytxe haka, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kowontay haxa hatà, Txesusu, teryewrye ro hatà. Àro wyaro tkowontatxhe rma, wayehye hatà. Tano me ro rma wayehye hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Àro wyaro Txesus wayehnàtoko, Khoryenkom màn yawonotho newaraxkay hatà. Thoko rma newaraxkay hatà, wom yatxarakaxahotho, Khoryenkom màn yawonotho. Eryehtyero newaraxkay hatà, txomo na hama. Nosowusày xarha tà, yukryeka. Nerakay xarha tà, tohu ymo. Àro wyaro tahoxetà yonyhoy hamà, Khoryenkomo, Txesus wayehnàtoko. ");
INSERT INTO hixNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nasanàmtxownà xarha tà, toto heno komo, àwayehxemo kom waye. Natahurmakay hatà, enamàthàyamotho, tohu ymo, ahusahotho ymo. Thenyehra nasanàmtxownà hatà, àwayehxemotho komo, Khoryenkomo mryenon heno komo rma. ");
INSERT INTO hixNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tonamàthàyamotho yaye nahatakatxownà hatà. Amnye, Txesusu yasanàmàtxhe, totxownà hatà, owto ymo hona, enyhoru ro hona rma, Xerusaryen hona rma. Àto rma nosonyhetxkon hatà, toto komo wya, thenyenohnà komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yukryeka yosowusnàrà yonyey hatà, horykomo, arymano ynye ro komo yohà rma, 100 komo yohà rma. Akoron komo xarha, arymano ynye ro komo rma, nenytxownà hatà. Txesusu yonyàr hoko ehxemo rma mokyam nehxatxkon hatà, nyamoro ha. Khoryenkom yahoxetà hutwamohsotho yonytxownà hatà, thenyehra hatà. Àro ke noseryehyatxkonà rma haxa mak hatà. Khoryenkom muru me nahko hamà, moson heno, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Àto nehxatxkon xarha tà, woràskomo komo, thenyenohnà komo rma. Moxe ro rma, omeroro nenytxehkatxownà hatà. Txesus yakoronotho komo rma mokyam nehxatxkon hatà, Karyeryeya yamtar hoye omohxemotho komo rma, Txesus yakoronomanyenhàyamotho rma. ");
INSERT INTO hixNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Àwawonye rma nehxakon hatà, Maryeya. Maknara honotho rma mok nehxakon hatà. Àwawonye rma rha nehxakon xarha tà, Maryeya rma rha. Txaku yonà rma noro hatà. Xose yon xarha noro hatà. Àwawonye rma rha nehxakon xarha tà, Sekmeknew muru komo yonà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Àro rma kokmamrà ro, Peratusu hyaka toy hatà, horykomo. Xose rma noro hatà, tkatxhonkemà ro rma hatà. Arymateya honotho rma mok nehxakon hatà. Txesusu nhananàhàtho me rma rha nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Noro rma toy hatà, Peratusu hyaka. Txesusu yekehàtho yanàr xe wehxaha, rowya enamtoho me, kekon hatà, àwya. Àro ke narhoy hatà, Peratusu, àwya. Noro hak nano ha, kekon hatà, tanoto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Àro ke ekehàthàrà yarày hatà, Xose. Karamye hatà, wom ke, xenyeno rma ke, enyhoru rma ke. ");
INSERT INTO hixNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nenamye hatà, toh yowtar yaka, onamno ytxoho yaka, tànakatxhàrà rma yaka. Toto heno komo yonamtoho mehra hak nehxakon hatà. Tohu ymo hanamay xarha tà, ewtar hotaka. Ahutoho ymo rma hanamay hatà. Àro wyaro tàwya ahurutxhe, toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Àto rma nehxatxkon hatà, Maryeya komo, Maknara honotho rma, esohye xarha, Maryeya rma rha. Eryewtaxaho rma, Txesusu yonamàthàrà màhto nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Xuknewyana komo yosonyhoryetxho yawasàn me rma hak nehxakon hatà. Kokmamye haxa hatà. Sa, nenmahye hatà. Enmahàtxhe, Peratusu hyaka nohsamnohtxownà hatà, Khoryenkom màn yonye ro yoh komo, Farysew kom yakoro xarha. ");
INSERT INTO hixNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Onà wyaro nketxkon hatà, àwya. Kofehnakno y, ketxkon hatà. Tàtemarontaxemà ro me nehxak hamà, noro heno, ketxkon hatà, Txesus hoko. Tano rma hak tehtoko, onà wyaro nkeknano, amna nenytxanàr me. Osorwawo ro enmahàtxhe, kasanàmyaha harha hampànà, àwayehxemo kom waye, keknano, ketxkon hatà, Peratusu wya. Àro wyaro tàwya tatoko, temaronteknan hamà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Àro ke, noro heno yonamàthàrà xenyhoko, ayanoto komo wya, ketxkon hatà. Osorwawo ro enmahrà, ohxe xenyhoko, àwyanye, ànhananàhrà rotho komo wya ekehàthàrà yanàr hona, àwyanye nasanàmno harha tawro hona, ketxkon hatà. Àsok tawro hana. Anatoko ekehàthàrà yaryatxow hana, ànhananàhrà rotho komo. Yaworohra onà wyaro nketxow hana. Àwayehxemo kom waye nasanàmno harha, ketxow hana, toto komo wya, ketxkon hatà. Àro wyaro àtemarontatho komo, atxke rma haxa nay hamà. Noro heno temarontathàràtho yoho rma haxa atxke nay hamà, toto komo wya yaworo nketxow hamà, nasanàmno hamà, tawro ke. Àro ke, noro heno yonamàthàrà xenyhoko, ayanoto komo wya, arymano ynye ro komo wya, ketxkon hatà, Xuknewyana yoh komo, Peratusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Arymano ynye ro kukur komo atxoko, kekon hatà, Peratusu, àwyanye. Àtotxoko. Ohxe mpànà menyhetxhe ha, àwyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Àro ke totxownà hatà, Txesusu yonamàthàrà na. Tohu ymo hsomatxownà hatà, ahutuhkanàr horà. Arymano ynye ro komo yanotomatxownà xarha tà. Tano roro ehtxok hampànà, ohxe xenytxok hampànà, ketxkon hatà, àwyanye. Àro wyaro Txesusu yonamàthàrà yetxownà hatà, Xuknewyana yoh komo, akoronotho komo wya ekehàthàrà yanàr hona. ");
INSERT INTO hixNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Hokano ytxoho yawasàn me rma hak nehxakon hatà. Kokmamye haxa hatà. Sa, nenmahye hatà, domenku. Enmahrà ro totxownà hatà, Maryeya komo, Maknara honotho rma, esohye xarha, Maryeya rma rha. Txesusu yonamàthàrà yonyxe totxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nosowusày mak hatà, yukryeka, thenyehra rma haxa mak hatà. Àsok tawro hana. Kahe yaye nomokye hatà, Kohkom yanoto. Tohu ymo yotakay hatà, ewtar hotaye. Neryewtay hatà, àhona. ");
INSERT INTO hixNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sasa wyaro tonyxem me nehxakon hatà. Àhonon xarha, buknye rma haxa nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tàwyanye xenyetxhe rma, nàràrànatxkon hatà, arymano ynye ro komo, oseryehrà kom hatà. Txesusu yonamàthàrà yony komo rma mokyam nehxatxkon hatà. Tàywenyeke harha nehxatxkon hatà, àwayehsaho wyaro rma hatà, kahe yawon hona toseryehrà kom ke rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Onà wyaro haxa nkekon hatà, kahe yawono, woràskomo komo wya. Oseryehpàra ehtxoko, kekon hatà. Oseryehpàra ehtxoko. Txesusu yonyxe momohtxow hamà. Amoyathosahotho rma yonyxe momohtxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tan ehxera naha. Nasanàmno ha, àwayehxemo kom waye. Tàrwonàmàthàràtho yawo ro rma nasanàmno ha, kekon hatà. Omohtxoko. Xenytxoko, enamàthàràtho, kekon hatà, kahe yawono. ");
INSERT INTO hixNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Owyanye xenyetxhe, àtotxoko. Ekarymaxe àtotxoko, ànhananàhrà rotho komo wya. Àwayehxemo kom waye nasanàmno hatà, màketxhe ha, àwyanye, kekon hatà. Oywahonye ten hatà, Karyeryeya yamtar hona, màketxhe ha, àwyanye. Àto menyatxow hatà, màketxhe xarha, àwyanye. Àro wyaro rma wekarymano, owyanye, kekon hatà, kahe yawono, woràskomo komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Àro ke karyhe totxownà hatà, woràskomo komo, onamno ytxoho nyero. Nàràrànatxkon hatà, ewankaran komo. Neryehotetxkon xarha tà, thenyehra hatà. Ekarymaxe karyhe tetxkon hatà, ànhananàhrà rotho komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Àtontokonye rma, nehotxownà hatà, Txesusu. Ha y, kekon hatà, àwyanye. Àhyaka totxownà hatà, woràskomo komo. Tano me ronye rma nehurkatxownà hatà, akrataka. Àhrorà yahohtxownà hatà. Ehonomnà me xaxa manay hamà, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ewankaramra ehtxoko, kekon hatà, Txesusu, àwyanye. Àtotxoko, rowtà komo hyaka. Onà wyaro màketxhe ha, àwyanye. Karyeryeya yamtar hona màtetxow hatà, àto rma noro menyatxow hatà, màketxhe ha, àwyanye, kekon hatà, Txesusu, woràskomo komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tetxkonà rma hatà, woràskomo komo, Txesusu nhananàhrà rotho komo hyaka. Àtontokonye rma, totxownà xarha tà, arymano ynye ro kukur komo. Onamno ytxoho nyero totxownà hatà. Owto ymo hona totxownà hatà, Khoryenkom màn yonye ro yoh komo hyaka. Nekarymatxehkatxownà hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Àro ke nohsamnohtàkatxownà hatà, Xuknewyana yoh komo, Khoryenkom màn yonye ro yoh komo rma, horykomo kom yakoro xarha. Nosonytxatxownà hatà. Txesusu yasanàmtoho yokaytanàr xehra nehxatxkon hamà. Àro ke nosonytxatxownà hatà. Tosonytxatxhenye rma, onà wyaro nketxkon hatà, arymano ynye ro komo wya, Txesusu yonamàthàrà yonyenhàyamo wya. Otxenyerun komo amna nàmyaha, owyanye, ketxkon hatà. Otxenyerun komo amna nàmyaha, owyanye. Àro ke, onà wyaro màketxhe ha, toto komo wya. Kohsaya tetxoko, ànhananàhrà rotho komo, màketxhe ha. Amna nàknàtoko rma, ekehàthàrà yaryatxoko, màketxhe ha, toto komo wya, ketxkon hatà, Xuknewyana yoh komo, arymano ynye ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Anatoko ownàkàthàyamo yonytxen hana, Kofehnakno. Ewakhàra nay hana, ohokonye, ketxkon xarha tà, àwyanye. Àro wyaro ewakhàra ehtoko, amna newakoryehe harha, ayanàhnohpàranye ehtxoho me, ketxkon hatà, Xuknewyana yoh komo, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Àro ke txenyeru yahohtxownà hatà, nyamoro. Xuknewyana yoh komo nàmàtho rma yahohtxownà hatà. Àrwonàmàthàyam yawo ro nekarymetxkon hatà, toto komo wya. Ànekarymatxhàyamo rma, nekaytekon hatà, thenyehra hatà. Tonytxaxem me rma haxa nehxakon hatà. Xuknewyana komo nenytxanàr me rma haxa nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Karyeryeya yamtar hona totxownà hatà, Txesusu nhananàhrà rotho komo, 11 komo rma. Àhà ymo hona totxownà hatà. Txesusu wya àsna màtetxhe ha katxhàr hona rma totxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Àto Txesusu yonytxownà hatà. Tàwyanye xenyetxhe rma, tano me ronye rma nehurkatxownà hatà, akrataka. Ehonomnà me xaxa manay hamà, ketxkon hatà, àwya. Ukukur komo rma, onà wyaro haxa nketxkon hatà, tàhnawonye. Noro me nay haryhe, ketxkon hatà, tàhnawonye. ");
INSERT INTO hixNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Àhyakany haxa toy hatà, Txesusu. Onà wyaro nkekon hatà, àwyanye. Royàm yano me ehonomnà me xaxa wehxaha, kahe yawon komo yoho rma haxa mak ha, yukryeka hon komo xarha yoho rma haxa mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Àro ke, rano me àtotxoko. Uro ekarymatxoko, toto komo wya, anaro rha yana komo wya, omeroron komo wya, kekon hatà. Uro ekarymatxoko, àwyanye, romryenon me harha ukukur komo yehtxoho me. Aymomtxok xarha, tuna kwaka, kekon hatà. Aymomtxoko, Khoryenkomo mryenon me harha ehtxoho menye, Khoryenkom muru mryenon me harha ehtxoho menye, Khoryenkom yokato mryenon me harha ehtxoho menye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Àhananàhtxok xarha. Rowya ahananàhtoho komo wyaro rma rha, nyamoro xarha àhananàhtxoko, royuknye ro me ehtxoho menye, kekon hatà. Onà wyaro àkehe xarha, owyanye. Ohyawonye roro rma wehxaha. Yukryeka hona harha romokhàra ro rma haka, ohyawonye roro rma wehxaha, kekon hatà, Txesusu, tànhananàhrà rotho komo wya.");
INSERT INTO hixNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Txesusu Kryestu yexetxhàrà ryhe, tonytxahoryem me xaxa mpànà naha ha. Khoryenkom muru ryhe noro ha, Txesusu Kryestu. Noro yexetxhàrà rma, àrwo yonyhorunu rma, onà wyaro ryhe notàhtxeye. ");
INSERT INTO hixNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Xowaw heno htxero ryhe nehxakon hakahpa tà. Noro hoko rma nmenhoy hatà, amnyehra, Esaeyas heno. Khoryenkomo rwonà yokarymanye ro rma mok nehxakon hatà, Esaeyas heno. Onà wyaro ryhe nmenhoy heno hatà. Onà wyaro nken hatà, Khoryenkomo, buru wya. Oywaho ranoto ànyakyaha hampànà, ken hatà, àwya. Toto komo yonyhoryenàr hoko mpànà naha ha, noro, àwyanye orwonà yonytxanàr horà, ken hatà, Khoryenkomo, buru wya. ");
INSERT INTO hixNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Àro ke, onà wyaro nkehe hampànà, ahehnawono, Khoryenkom yanoto rma. Kohkomo ryhe nomokyan hatà, àro ke osonyhoryetxoko, kehe hampànà, teryewrye ro, toto komo wya. Tkayaryet komo yomoknàtoko, esamar komo yonyhoryetxow hamà, àmryenon komo. Àro wyaro rma rha, oyowan komo enyhoryetxoko, owyanye Kohkomo rwonà yonytxatxho me, kehe hampànà, ahehnawono. Àro wyaro rma nmenhoy hatà, Esaeyas heno, Xowaw hoko. ");
INSERT INTO hixNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Àro ke, ahehnawo nehxakon hakahpa tà, Xowaw heno. Toto komo yaymomyatxkon hakahpa tà, tuna kwaka. Khoryenkomo rwonà yokarymekon hatà, àwyanye. Atxke manatxhe, kekon hatà, àwyanye. Anar me harha ayanhànàthàyamo xenytxoko. Ataymompotxok xarha, ohokonye Khoryenkomo yoseryewhokatxho me, àwya ayanhànàthàyamo yowtoho me, kekon hatà, Xowaw heno, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Àhyaka tetxkon hatà, toto komo, omeroro hatà, Xukneya yamtar hon kom hatà, Xerusaryen hon kom xarha hatà. Nataymompetxkon hatà, àwya, tuna kwaka. Xoknaw kwaka ryhe nataymomyatxkon hatà. Tataymomnàtokonye rma, noskarymetxkon hatà. Tanhànàthàyamo yokarymetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Àsok hana nehxakon ha, Xowaw heno ha. Onà wyaro nehxakon hatà. Okno hpotxetho yaw nehxakon hatà, kameru hpotxetho yaw hatà, enyhoryehnà rma yaw hatà. Okno hutxhotho ke tasok nehxakon xarha tà. Kratxatxa ryhe, et me nehxakon hatà. Weno xarha, ànyahrà me nehxakon hatà. Àro wyaro nehxakon hatà, Xowaw heno. ");
INSERT INTO hixNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Onà wyaro nkekon xarha tà, toto komo wya. Nomokyaha hampànà, anaro, rohryetayo, kekon hatà, àwyanye. Rohono rma haxa noro ha. Àhrorà womun yasotà wompokahra wehxaha, esnaka rma haxa ryesnàr ke, kekon hatà. Asot wompokaxe ewanahra mak wehxaha, esnaka rma haxa ryesnàr ke, kekon hatà, Xowaw heno. ");
INSERT INTO hixNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tuna kwaka ryhe kaymomyatxhe, uro ha. Noro ryhe, anaro me ayaymomyatxhe ha. Khoryenkom yokato nyakyaha, ohonanye, kekon hatà. Ohonanye noro yomohtoho ryhe, ayaymomtoho kom me naha, kekon hatà, Xowaw heno. ");
INSERT INTO hixNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Xowaw yehtoko rma haka, nomokye hatà, Txesusu. Nasarye hoye nomokye hatà. Karyeryeya yamtar hono ryhe àro ha, owto, Nasarye. Àsnye ro nomokye hatà, Txesusu, Xoknaw yohokoso. Nataymompoy hatà, Xowawu wya, Xoknaw kwaka. ");
INSERT INTO hixNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tataymomàtxhe rma, nasanàmye hatà, tuna kwaye. Asanàmnàtoko rma, natahurmakay hatà, kahe, Txesusu nenyàr me hatà. Khoryenkom yokato ryhe nàhtoy hatà. Watkuk me nehxakon hatà, ànenyàr me. Txesus hona nàhtoy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Àrwo yonytxay hatà, Txesusu. Kahe yawono ryhe nàrwonàmye hatà. Romuru omoro, kay hatà. Ronàhnàn xaxa omoro ha. Ohoko teryehorye rma haxa wehxaha, kay hatà, kahe yawono. ");
INSERT INTO hixNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Àro tàhto rma nànyakye hatà, Khoryenkom yokato. Ahehnaka ryhe nànyakye hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ahehnawo rma, 40 me nenmahye hatà, Txesusu. Àto rma ehtoko, kukmekon haryhe tà, Satanasà ymo. Txesusu wya toyuknur xe rma nehxakon haryhe tà, noro ymo. Onokna wawo nehxakon hatà, Txesusu, bayanyem wawo rma hatà. Khoryenkom yanoto komo ryhe, nakoronometxkon hatà. Kahe yaye omohxemo komo rma, nakoronometxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Watxa ymo yaka ahryemxah harha nehxakon hatà, Xowaw heno. Àro wyaro noro heno yehtoko, toy hatà, Txesusu, Karyeryeya hona. Khoryenkomo rwonà yokarymekon hatà. Àrwo yonyhorunu rma yokarymekon hatà, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Akayaryet kom me Khoryenkomo nànyaketxho ryhe, omohsah me naha, kekon hatà, àwyanye. Amnyehran heno komo nekarymatxho ryhe, nomokye haxa ha. Àrwo yonyhorunu rma àro ha, kekon hatà. Atxke manatxhe, omnyamo. Àro ke, anaro me harha ayanhànàthàyamo xenytxoko. Àrwo yonyhorunu ahohtxoko, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Taa. Karyeryeya kuthonà yohokoko tekon hatà, Txesusu. Semaw yonyey hatà. Antrye xarha yonyey hatà. Semaw yowtà rma noro ha. Txaruka yarymetxkon hatà, tuna kwaka. Kana yaramnye ro komo kax mak nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Omohtxoko, rakoro, kekon hatà, Txesusu, àwyanye. Omohtxoko, rakoro. Kana yaramnye ro omnyam hamà. Rakoro oyomokàtxhenye, toto komo yoknye me harha mpànà keryatxhe ha, rohyaka, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Àsoke rma, tàtxarukanàthàyamo nomtxownà hatà. Txesus yakoro harha totxownà hatà, Semaw komo. ");
INSERT INTO hixNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Meya nyhe toy hatà, Txesusu. Txaku yonyey hatà. Sekmeknew muru rma noro ha. Xowaw xarha yonyey hatà. Txaku yowtà rma noro ha. Kanawa yawo nehxatxkon hatà. Tàtxarukanàthàyamo yonyemyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Àsoke rma natxownà hatà, Txesusu. Omohtxoko, rakoro, kekon hatà, àwyanye. Àro ke, tàyàmànhàyamo nomtxownà hatà. Kanawa yawo rma nehxakon hatà, Sekmeknew. Tanoto komo hyawo rma nehxakon hatà. Nyamoro hyawo rma nànomtxownà hatà. Txesus yakoro harha totxownà hatà, Txaku komo. ");
INSERT INTO hixNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kafahnaw hona totxownà hatà, Txesus komo. Hokano ytxoho yawasàn ho nowomtxownà hatà, nàmno ymo yaka, ohsamnohno ytxoho ro yaka. Àton komo hananàhye hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Koo, ohxe rma haxa khananàhyatxow hamà, mosonà, ketxkon hatà, toto komo. Noseryehoketxkon hatà, ehonomnà me rma haxa àwya thananàhrà kom ke hatà. Àyweronàhyamano ynye ro komo yoho rma haxa hananàhyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Àto nehxakon hatà, toto. Worokyamo yohà rma mok nehxakon hatà. Ohsamnohtoho kom yawo rma nehxakon hatà. Teryewrye ro nàrwonàmye hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Txesusu y, Nasarye honotho y, kekon hatà. Àsok manaye, amna hoko. Amna yanàhnohso momokye hamà, kekon hatà. Oywero wehxaha. Khoryenkomo nànyaketxho omoro ha. Enyhoru ro rma omoro ha, kekon hatà, toto, worokyamo yohà rma. ");
INSERT INTO hixNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Neyey mak hatà, Txesusu. Tatàknye exko, kekon hatà, àwya. Otowko ha, toto hyaye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nànyerymamnohye hatà, worokyamo, anhà ymo. Kowontay hatà, teryewrye ro hatà. Kray, notowye hatà, anhà ymo, àhyaye. ");
INSERT INTO hixNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Koo, noseryehokatxehketxkon hatà, àton komo, omeroro. Àro ke nosonytxetxkon hatà, nyamoro rye. Àsoke nkan haryhe, mosonà, ketxkon hatà, tàwyanye rma. Àsoke nkan haryhe. Anar me khananàhyatxow hamà, mosonà, ketxkon hatà. Toyuhsom me, àro wyaro nkan hamà, worokyamo wya. Moson yoyukyatxow hamà, nyamoro, ketxkon hatà, toto komo, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Àtoko rma nekaytekon hatà, Txesusu, othoyehra hatà. Noro yokaytà yonytxetxkon hatà, àton komo, Karyeryeya yamtar hon komo, anaro rha owto hon komo, àhorye ron komo. ");
INSERT INTO hixNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kura, nahatakatxownà hatà, Txesus komo, ohsamnohtoho kom yaye. Tahatakatxhenye rma, totxownà hatà, Semaw màn kom yaka, Antrye mànà rma yaka. Akoronye totxownà hatà, Txaku komo, Xowaw xarha. ");
INSERT INTO hixNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Àto nehxakon hatà, Semaw hetx yonà. Ekeh me nehxakon hatà, atunano wya. Namotohyakon hatà. Txesusu yowomàtxhe rma, nekarymatxownà hatà, àwya. Ekeh me naha, mosonà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Àhyaka haxa toy hatà, Txesusu. Tok, sax, amor hoko nanàmye hatà. Nàhnànkay hatà, atunuthuru. Natamokyakon harha tà, àhyakanye, ekeh me ehxahonhàràtho. ");
INSERT INTO hixNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kokmamye hatà. Àkokmamàtxhe rma, nomohtxownà hatà, toto komo, Txesusu hyaka. Ekeh komo yokyatxkon hatà. Worokyamo yoh komo xarha yokyatxkon hatà. Omeroro rma nekyatxkon hatà, Txesusu hyaka. ");
INSERT INTO hixNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Thenyenohnà komo rma nomohtàkatxownà hatà, owto hon komo rma, omeroron komo rma. Nohsamnohtàkatxownà hatà, àmàn kom hotaka. ");
INSERT INTO hixNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Thenyehra rma haxa nehxatxkon hatà, ekeh komo. Anaro rha ke teheryanke nehxatxkon hatà. Omeroro rma nenyhoryetxehkatxownà hatà, Txesusu. Worokyamo komo yowyakon xarha tà, toto komo hyaye, thenyehra hatà. Khoryenkom muru me Txesusu hutwetxkon hatà, worokyamo komo. Totaknyàr xehra mak nehxakon hatà, noro, àwyanye. Àrwomra ro mak ehtxok hampànà, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sa, nenmahye hatà. Tawanye nyhe rma ehtoko, hakay hatà, Txesusu. Bàn yaye toy hatà. Ahehnake toy hatà. Àto nàrwonakon hatà, Khoryenkom yakoro. ");
INSERT INTO hixNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nesamatàhkatxownà hatà, Semaw komo. Sàh sàh sàh sàh sàh sàh, kràk. ");
INSERT INTO hixNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Noro yonytxownà hatà. Ha y, ketxkon hatà. Oyonyàr xe manatxowà, toto komo, omeroro, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Àpa txowà rma, kekon mak hatà, Txesusu, àwyanye. Anana haka rha àpa txowà, anaro rha owto hona, màhton hona, kekon hatà. Àsna haka rha wekarymatxano. Àsok tawro hana. Àhyakanye ekarymaxe omohsaho rma uro, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Àro ke totxownà hatà. Karyeryeya yamtar horye rma tetxkon hatà. Anaro rha owto hona rma tetxkon hatà, anaro rha ohsamnohno ytxoho ro yaka rma hatà. Àton komo wya nekarymekon hatà, Txesusu. Worokyamo komo yowyakon xarha tà, toto komo hyaye. ");
INSERT INTO hixNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Taa. Nomokye hatà, toto, Txesusu hyaka. Hunmata ymo yawo rma haxa nehxakon hatà, noro ha. Ehonomnà me Txesusu yonyakon hatà. Àro ke, tosoknar ho neryewtay hatà, akrataka. Nàrwonàmye hatà, akoro, teryewrye ro rma haxa hatà. Uro enyhoryeko, kekon hatà, àwya. Amna yonyhoryenye omoro hatà. Ronyhoryenàr xe oyehtoko, uro menyhoryen hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Àhnàn yawo rma haxa nehxakon hatà, Txesusu. Àro ke natahoyotkay hatà. Dye, nahey hatà. Oyonyhoryenàr xe wehxaha, kekon hatà. Konyhoryen hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Àtoko rma nàhnànkay hatà, uhunmatathotho. Ohxe harha nehxakon hatà, toto. ");
INSERT INTO hixNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Àtoko rma nànyakye hatà, Txesusu. Teryewrye ro rma haxa hananàhye hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Àtok ha, kekon hatà, àwya. On yokarymahra xaxa mpànà exko ha, toto komo wya, kekon hatà. Osonyhota, horykomo wya, Khoryenkom màn yonye ro wya. Moyses heno nekarymatxho yawo ro, owoknàthàrà màmyaha ha, àwya, kekon hatà. Khoryenkomo wya tàmsomà rma màmyaha ha, enyhoryexah me oyesnàr ke. Àro wyaro rma muhutwamohsehe, oyonyhoryetxhàrà, toto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Toy hatà, toto, hunmata ymo yawonotho. Noskarymekonà rma haxa mak hatà, toto komo wya, omeroron komo wya. Ronyhoryeko, Txesusu, kekonà roro rma haxa mak hatà. Àro ke, tàtonàr komo xe rma haxa nehxatxkon haryhe tà, toto komo, Txesusu hyaka. Omoknàr komo xehra mak nehxakon hakahpa tà, noro, tàhyaka. Àro ke, àtohra harha nehxakon hakahpa tà, owto hona, toto komo wya tonyàr hona. Ahehnawo roro nehxakon hakahpa tà. Àhyaka rma nomokyatxkon hatà, toto komo, ananye rha. ");
INSERT INTO hixNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yake rohra enmahàtxhe, nomokye harha tà, Txesusu. Àpo, Kafahnaw hona nahatakay hatà. Àro ke nekaytay hatà. Mono manay ha, bàn yawo, ketxkon hatà, toto komo. ");
INSERT INTO hixNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Àro ke nomohtàkatxownà hatà, àmàn yaka. Toto komo, thenyenohnà komo, nohsamnohtàkatxownà hatà. Esar komo kenyehra rma haxa nehxakon hatà, tahruruhke esnàr ke hatà. Àhotaw xarha, ehxera nehxakon hatà, esar komo. Khoryenkomo rwonà yokarymekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nomohtxownà hatà, anar komo xarha, 4 komo rma. Tototho yohtxownà hatà, ekehà rma hatà, amusnaxaho rma hatà, tahon hono rma hatà. Txesusu hyaka nekyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Àhyakatho ro omokhàra mak nehxatxkon hatà, thenyehra rma haxa toto komo yesnàr ke hatà. Àro ke nàmnotho yowtxownà hatà, yaworo. Tàwyanye àhosokatxhe rma, nenàhtotxownà hatà. Amusnaxaho yonàhtotxownà hatà, tahon hono rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Rohona xaxa nenyatxow hamà, moxamo, kekon hatà, Txesusu, tàhnawo. Àro ke, onà wyaro nkekon hatà, amusnaxaho wya. Kàrà y, kekon hatà. Koseryewhokan hampànà, ayanhànàthàr hoko. Towsah me harha naha, ayanhànàthàrà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Àto nehxatxkon hatà, àyweronàhyamano ynye ro kukur komo. Onà wyaro ryhe nehutwetxkon hatà, tàhnawonye. ");
INSERT INTO hixNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Àsoke nkan haryhe mosonà, denytxanàr kom me, ketxkon hatà, tàhnawonye. Khoryenkomo wàràhyaken hamà. Khoryenkom marma ryhe, kanhànàthàyamo yownye me naha. Khoryenkomo wyaro nehutwen hamà, mosonà, ketxkon hatà, tàhnawonye. ");
INSERT INTO hixNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ehutwatxho komo rma hutwekon hatà, Txesusu, tàhnawo. Àro ke, onà wyaro nkekon hatà, àwyanye. Àsok tawro àro wyaro màketxow haryhe, ohnawonye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Rowya, towsah me harha naha, ayanhànàthàrà, katxho ryhe, tkahoryehra nay hamà, owyanye, kekon hatà, àwyanye. Àro wyaro tkahoryehra naha, mosonà wya, amusnaxaho wya, màketxow hamà. Onà wyaro haxa tkahorye nay hamà, owyanye. Asanàmko, ayahon anàmko ha, àtok ha, katxho haxa ryhe, tkahorye rma haxa nay hamà, owyanye, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Towsah me harha naha, ayanhànàthàrà, kany me mak wehxaha, Toto me Enusah kaxe, kekon hatà. Tano rma yukryeka ho rma ryehtoko, àro wyaro kany me wehxaha, Khoryenkom yano me mak ha, kekon hatà. Àro wyaro kany me hak kehutwamohsosà, owyanye. Moson yeheryanàtho wowyaha hampànà, Khoryenkom yano me ryehutwamohsonàr horà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Onà wyaro àkehe, owya, kekon hatà, amusnaxaho wya. Asanàmko, ayahon anàmko ha, omàn yaka àtok ha, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Àtoko rma nasanàmye hatà, amusnaxahotho. Sax, ànenyàr kom me nasanàmye hatà. Tahon yanàmye hatà. Kura, nahatakay hatà, àyweroronye. Àro ke noseryehokatxehketxkon hatà. Koo, ketxkon hatà. Ohxe xaxa nay hamà, Khoryenkomo. Xenyhenà rotho rma tenytxowà, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Meya toy xarha tà, Txesusu, Karyeryeya kuthonà yetxehtaka. Toto komo nomohtàkatxownà hatà, àhyaka. Nyamoro hananàhye hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Taa. Tàtonàr me Ryefe yonyey hatà. Awfew muru rma noro hatà. Nàmno yawo eryewtaxaho nehxakon hatà. Txenyeru yahohtoho yawo rma nehxakon hatà, tkayaryet komo txenyerunu yahosnye ro kaxe. Rakoro omok ha, kekon hatà, Txesusu, àwya. Sax, nasanàmye hatà, Ryefe. Txesus yakoro harha toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Taa. Ryefe màn yawo nehxakon hatà, Txesusu. Nemtakmekon hatà, tànhananàhrà ro kom yakoro, anar kom yakoro xarha. Thenyehra rma haxa nehxatxkon hatà, toto komo, Txesus yakoro tàtosom komo. Anar komo, tkayaryet komo txenyerunu yahosnye ro me nehxatxkon hatà. Anar komo, atxke natxhe moxamo, katxho ro me nehxatxkon hatà. Omeroro rma nemtakmetxkon hatà, Txesus yakoro, Ryefe màn yaw hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nenyatxkon hatà, àyweronàhyamano ynye ro komo. Farysew komo rma nyamoro hatà. Txesus komo yemtakmanàrà yonyatxkon hatà. Àro ke, onà wyaro nketxkon hatà, ànhananàhrà ro komo wya. Àsok tawro mokyam yakoro nemtakmeno, ketxkon hatà. Àsok tawro mokyam yakoro nemtakmeno. Atxke natxow hamà, mokyamo, txenyeru yahosnye ro komo rma, atxke natxhe moxamo katxho ro komo xarha, ketxkon hatà, Farysew komo. ");
INSERT INTO hixNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nenytxatxownà hatà, Txesusu. Àro ke, onà wyaro nkekon hatà, àwyanye. Àsok hana natxow ha, eheryamnà kom ha, kekon hatà. Ohtxemano ynye ro komo hyaka àtohra natxow hamà, enyhoru komo kaxe. Teheryankem kom marma ryhe, àhyakanye tetxhe, kekon hatà. Àro wyaro rma rha, rohyaka omokhàra natxhe, ohxe natxhe moxamo katxho komo. Atxke natxhe moxamo katxho kom haxa ryhe, rohyaka nomokyatxhe. Nyamoro wya rma, rakoro omohtxoko kanye uro komokye, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Xowawu nhananàhrà ro komo natahyehnometxkon hatà, tàyweronàhyamatxho kom yawo ro hatà. Àro wyaro rma rha natahyehnometxkon hatà, Farysew komo xarha. Àro ke nomohtxownà hatà, toto komo, Txesusu hyaka. Onà wyaro nketxkon hatà, àwya. Kàyweronàhyamatxho kom yawo ro natahyehnometxhe yohà, Xowawu nhananàhrà ro komo, ketxkon hatà, àwya. Farysewu nhananàhrà ro komo xarha natahyehnometxhe yohà. Onhananàhrà ro kom haxa ryhe, atahyehnomahra natxhe haryhe, ketxkon hatà. Àsok tawro atahyehnomahra natxowà, ketxkon hatà, toto komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Onà wyaro neyuhtxownà hatà, Txesusu. Àsok hana natxow ha, ronhananàhrà ro kom ha, kekon hatà. Thetx yahosnye yakoron komo wyaro natxow hamà. Tàwya thetx yahosnàtoko, tkukur komo yanyekyan hamà, toto. Asahxemtoso nanyekyatxow hamà. Àro ke, tàhyawonye rma hak noro yehtoko, atahyehnomahra natxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amnye àhyayenye tehe, àhehtaxaho. Tàhyayenye àtotxhe rma, natahyehnometxhe hxak hakahpa harha, akoronotho komo, toseryehokanàr komo ke mak ha, kekon hatà. Àro wyaro rma rha natxhe, ronhananàhrà ro komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kuknonano me rma rha, onà wyaro nkekon xarha tà, àwyanye. Rowya ahananàhtoho komo ryhe, wom xenyeno wyaro naha, kekon hatà. Kwomunuthuyamo yenyemrà xe kehtokonye, wom xenyenohnà ke tenyemyatxow hamà. Xenyeno ke haxa kàwyanye enyemnyetoko, notowyan hamà, xenyenotho. Kàwyanye ahxeketxhe rma, notowyan hamà, kwomunuthuyam hoye, amnyehranotho hoye. Tamtak harha nay hamà, ewtarà, kekon hatà. Àro wyaro rma rha, oyweronàhyamatxhotho kom yawo ro rma haxa oyehtokonye, ronytxanàr xehra manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ufa xkunu wyaro xarha naha, rowya ahananàhtoho komo, kekon xarha tà. Àkawawantaxenyeno wyaro rma naha. Àkawawantaxenyen me ufa xkun yehtoko, arkahra tehxatxow hamà, enàthàrànhàr yaka, okno hutxhothonhàr yaka, amnyehranotho yaka, kekon hatà. Àrotho yaka kàwyanye arkantok haxa, tonàthàrà rakehe. Notukwamyaha hxak ha, àkawawantaxenyenotho. Enàthàrà xarha natanàhnohyaha hxak ha, kekon hatà. Xenyeno yaka ryhe tarketxow hamà, kekon hatà. Àro wyaro rma rha, rowya ahananàhtoho kom yawo ro rma haxa oyehtokonye, oyweronàhyamatxhotho kom yawo rohra harha manatxow hamà, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Marataha tetxkon hatà, Txesus komo, hokano ytxoho yawasàn ho hatà. Tàtontokonye rma, nasànasà hohtyatxkon hatà, ànhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nenytxownà hatà, Farysew kukuru komo. Ha y, ketxkon hatà, Txesusu wya. Àsok natxow haryhe, mokyamo, ketxkon hatà. Àsok natxow haryhe. Kàyweronàhyamatxho kom yawo rohra natxow hamà. Hokano ytxoho yawasàn ho, thothoryehra naha, kàwyanye, ketxkon hatà, Farysew komo. ");
INSERT INTO hixNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Khoryenkom karyehtan hutwahra kat manatxowà, Dafe heno kom hoko, kekon hatà. Nyamoro heno xarha, tahyehnàtokonye, kàyweronàhyamatxho kom yawo rohra rma rha nehxatxkon hatà, kekon hatà. Nahyehyatxkonà rma haxa mak hatà. Tànyahrà komo xe rma haxa nehxatxkon hatà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Àro ke, Khoryenkom màn yaka nowomye hatà, Dafe heno. Apeyata heno ryhe, Khoryenkom màn yonye ro komo yoh me nehxakon hakahpa tà. Apeyata yehtoko rma haka, nowomye hatà, Dafe heno, Khoryenkom màn yaka, kekon hatà. Towomàtxhe, ekeyu yonahye hatà. Àsoken hana mon nehxakon ha, ekeyu. Khoryenkom yompataka txexahonhàràtho rma mon nehxakon hatà. Khoryenkom màn yonye ro komo yuru marma mon nehxakon hatà. Kàyweronàhyamatxho kom yawo ro nyamoro marma àro yonahyatxkon hatà. Anar komo nenahpàtorà ro mak hatà àro ha. Àrotho rma yonahye hatà, Dafe heno, tahyehrà ke mak hatà. Nàmye xarha tà, takoron komo wya, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Onà wyaro nkekon xarha tà, àwyanye. Hokano ytxoho yawasànà wahanonkaye, Khoryenkomo, kekon hatà. Toto komo hokanàr horà ryhe, wahanonkaye, toto komo yowakryenàr horà ryhe. Toto komo yeryehokanàr horàhnà mak wahanonkaye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Àro ke, hokano ytxoho yawasàn yoh me wehxaha, Toto me Enusah kaxe, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Txesusu nowomye xarha tà, nàmno ymo yaka, ohsamnohno ytxoho ro yaka. Àto nehxakon hatà, toto. Amoskurumentaxaho rma mok nehxakon hatà, noro ha. ");
INSERT INTO hixNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Txesusu yonytxehketxkon hatà, Farysew komo. Onà wyaro ryhe nehutwetxkon hamà. Anatoko norotho yonyhoryen hana, mosonà, on ho, hokano ytxoho yawasàn ho, ketxkon hamà, tàhnawonye. Onà wyaro tawro xe rma nehxatxkon haryhe mà, Txesusu wya. Atxke manaha, kàyweronàhyamatxho kom yawo rohra oyesnàr ke, tawro xe nehxatxkon hamà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Onà wyaro nkekon hatà, Txesusu, amoskurumentaxaho wya. Xaro omok ha, amna yamrakataka, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Onà wyaro nkekon xarha tà, Farysew komo wya. Kàyweronàhyamatxho kom yawo ro tehxorye tehxatxow hamà, kekon hatà, àwyanye. Àsok kat wehxano, owyanye, àro yawo ro ryehtxoho me. Hokano ytxoho yawasàn ho àsok kat wehxano. Onyhoryeno yhera kat wehxano. Anàhnohno ynye me kat wehxano, kekon hatà. Anàmno yhera kat wehxano. Wayehkano ynye me kat wehxano. Àsok kat wehxano, owyanye, kekon hatà, Txesusu, àwyanye. Eyukhura mak nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Àhorye ronye nenytxehkatxownà hatà, Txesusu. Ewakhàra rma haxa nehxakon hatà, àhokonye. Noseryehokekonà rma hatà, àhokonye, tàhnawonye atxke rma haxa esnàr kom ke. Onà wyaro nkekon hatà, toto wya. Atahoyotkako. Natahoyotkay hatà. Ohxe harha nehxakon hatà, amorà. ");
INSERT INTO hixNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Meya totxownà hatà, Farysew komo. Nosonytxetxkon hatà, Eroknes kom yakoro. Txesus hoko ryhe nosonytxetxkon hatà. Àsoke ryhe noro twayehketxowà, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Tuna ymo yohokoso toy hatà, Txesusu. Akoro totxownà hatà, ànhananàhrà ro komo. Akoro rma rha totxowna hatà, toto komo xarha, thenyenohnà kom hatà, Karyeryeya yamtar hon kom hatà, Xukneya yamtar hon komo xarha hatà, ");
INSERT INTO hixNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Xerusaryen hon komo xarha hatà, Eknumeya yamtar hon komo xarha hatà, Xoknaw mon hon komo xarha hatà, Txeru màhton komo xarha hatà, Seknon màhton komo xarha hatà. Txesus yokaytà yonytxanyenhàr me nehxatxkon hatà. Àro ke, àhyaka nomohtàketxkon hatà, thenyenohnà kom hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Onà wyaro nkekon hatà, Txesusu, tànhananàhrà ro komo wya. Xaro ewahtotxoko, kanawa, rohyaka, kekon hatà. Anatoko kosonkahyan hana, àro yaka, toto komo wya ryeryemnuknur hona, kekon hatà. Àsok tawro hana. Thenyehra rma haxa nehxatxkon hatà, toto komo. ");
INSERT INTO hixNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Thenyenohnà komo yonyhoryenyenhàr me nehxakon hatà, Txesusu. Àro ke, anar komo xarha nohsamnohtàketxkon hatà, àhyaka, anaro rha teheryankem kom hatà. Noro yahenàr xe nehxatxkon hatà. Àro ke nohtaymetxkon hatà, àhona. ");
INSERT INTO hixNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Worokyamo yoh komo xarha nomohtxownà hatà. Tàwyanye Txesus yonyetoko ryhe, nehurketxkon hatà, akrataka. Teryewrye ro nàrwonatxkon hatà, worokyamo yano me mak hatà. Khoryenkom muru ryhe omoro, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Àro ke, onà wyaro nkekon hatà, Txesusu, àwyanye, teryewrye ro rma haxa mak hatà. Rotakhera xaxa mpànà ehtxok ha, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Taa. Àhà ymo yawnukye hatà, Txesusu. Anyeknyo yeryey hatà. Takoron menyxan komo ryhe yanyekye hatà, tàhyaka. Àhyaka totxownà hatà, nyamoro ha. ");
INSERT INTO hixNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Àwayenye rma, 12 me wahanonkatxownà hatà, Txesusu. Onà wyaro katxho me nehxatxkon hatà, nyamoro ha, àwya. Ronànyaknyàrà ro komo moxamo katxho me nehxatxkon hatà, àwya. Takorono ro me esnàr komo xe nehxakon hatà. Ekarymaxe ànyaknyàr komo xe xarha nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Toto komo hyaye worokyamo yowso xarha ànyaknyàr komo xe nehxakon hatà. Tano me worokyamo yowrà xe nehxakon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Onà wyaro nehxatxkon hatà, 12 komo, esot komo rma. Anaro Semawu. Petru me harha nesohtoy hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Anaro xarha Txaku. Sekmeknew muru rma noro ha. Anaro xarha Xowawu. Txaku yowtà rma noro ha. Boanehtxes me harha nyamoro yosohtoy hatà, Txesusu. Taraye wyaron komo moxamo katxho me rma naha, Boanehtxes katxho. ");
INSERT INTO hixNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anaro xarha Antrye. Anaro xarha Feryepe. Anaro xarha Bahtormewu. Anaro xarha Matewsà. Anaro xarha Tome. Anaro xarha Txaku. Awfew muru rma noro ha. Anaro xarha Taknewu. Anaro xarha Semawu. Serotes komo yakoronotho rma noro ha. ");
INSERT INTO hixNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Anaro xarha Xuknasà Eskaryotesà. Noro rma, Txesusu yahohsony me nehxakon hatà, anhà komo wya. Bàn yaka harha toy hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Thenyehra nomohtàkatxownà xarha tà, toto komo. Àro ke, àhoko rma haxa nehxatxkon hatà, Txesus komo, emtakmahra tehxe ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Àro wyaro ekaytà yonytxatxownà hatà, Txesus yanan komo. Emtakmahra ro mak manaye tawro rma yonytxatxownà hatà. Àro ke, onà wyaro nketxkon haryhe tà, noro hoko, Tàywenyeke rma haxa nay hamà, ketxkon haryhe tà, àhoko. Àpa txowà tehtxe. Àro ke totxownà hatà, noro yanàr horà haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Taa. Àto nehxatxkon hatà, àyweronàhyamano ynye ro kukuru komo, Txesus komo hyaw hatà. Xerusaryen hoye omohxemo komo rma nyamoro hatà. Onà wyaro nketxkonà rma haryhe tà. Bewsekmu ymo yoh me xaxa we naha ha, mokro, ketxkon haryhe tà. Noro ymo yano me ryhe worokyamo yowyan hamà, worokyamo komo yohà ymo yano me mak ha, ketxkon haryhe tà, àyweronàhyamano ynye ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tàhyaka haxa nanyehtxownà hatà, Txesusu. Onà wyaro ryhe nkekon hatà, àwyanye. Rowya worokyamo yownàtoko ryhe, nyamoro warymen hamà, kekon hatà. Satanasà ymo yano mehra mak warymetxow hamà. Àsok tawro hana. Tàmryenon komo rma yarymahohra nay hamà, noro ymo ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Àro hoko rma kuknonano me nàrwonàmye hatà. Àsok hana natxow ha, owto hon kom ha, kekon hatà. Tosoyxemà ro me tehtokonye, natakhahyatxow hamà, owto hon heno komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Àsok hana natxow ha, àro rye yawon komo xarha. Tosoyxemà ro me tehtokonye, natakhahyatxow hamà, àro rye yawonotho komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Àro wyaro rma rha, tosoyxemà ro me tehtokonye, Satanasà ymo heno komo yatanàhnohràtho haryhe mà. Noro ymo yano me towsom me worokyamo yehtoko, osoynyàràtho komo haryhe mà. Àro wyaro tàmryenon komo yehtoko, eh kom mehra harha Satanasà ymo yesnàràtho haryhe mà, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tahoxerye ymo toto yehtoko, noro katxhotho yarhàra nay hamà, anaro, kekon xarha tà, àwyanye. Bàn yawo rma noro ymo yehtoko, krawame rma haxa nowomyan hamà, àkatxhothàrà yanàr horà. Tàwya noro ymo yahomometxhe haxa ryhe, àkatxhothàrà yaryan hamà, tkatxho me harha. Àro wyaro rma rha, rowya worokyamo yownàtoko, Satanasà ymo komo warymen hamà, kekon hatà, Txesusu, àyweronàhyamano ynye ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Onà wyaro ryhe yaworo xaxa àkehe, owyanye, kekon xarha tà, àwyanye. Toseryewhokaxem me naha, Khoryenkomo, ayanhànàthàyam hoko, omeroron hoko rma. Owyanye twàràhyakatxhe rma, noseryewhokehe, ohokonye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Owyanye tokato haxa wàràhyakatxhe, oseryewhokahra ro mak naha ha, Khoryenkomo, kekon hatà. Àro wyaro atxke ehxemotho kom hoko ryhe, oseryewhokahra roro rma haxa mpànà naha ha, meya roro rma haxa mak ha, kekon hatà, Txesusu, àyweronàhyamano ynye ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Àro wyaro nkekon hatà, àwyanye, worokyamo yoh me xaxa we naha ha, mokro, kanyenhàr me esnàr kom ke hatà. Khoryenkom yokato yano me worokyamo yownye hoko rma, àro wyaro atxke nàrwonàmtxownà hatà, nyamoro ha. ");
INSERT INTO hixNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Txesusu hyaka nomohtxownà hatà, àyon komo, ewtà komo xarha. Màmyaye rma horohtxownà hatà. Noro yanyekhotxownà hatà, àton komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Thenyehra rma haxa nehxatxkon hatà, toto komo. Txesusu hyawo eryewtaxemo nehxatxkon hatà, bamtotàhkaxe ro hatà. Onà wyaro nketxkon hatà, àwya. Mono natxow hatà, oyon komo, oyowtà komo xarha, ketxkon hatà, àwya. Màmyaye rma natxow hatà. Oyonyàr xe natxow hatà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Àsoken kom hana royon me natxow ha, kekon hatà. Àsoken kom hana rowtà me natxow ha, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Thorye ron komo yonytxehkay hatà. Moxamo ryhe, royon me natxhe, rowtà me natxhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Àsok tawro hana. Khoryenkomo yoyuknye ro komo ryhe, rowtà me natxhe, rowosàn me natxhe, royon me natxhe, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Toto komo hananàhyakon xarha tà, Txesusu, tuna ymo yohoye. Àhyaka nohsamnohtàkatxownà hatà, toto komo. Thenyehra rma haxa nehxatxkon hatà. Àro ke nosonkahye hatà, Txesusu, kanawa yaka. Àto neryewtay hatà, kanawa yawo, tuna ymo kwawo. Tuna ymo yohoye rma nehxatxkon hatà, toto komo, omeroron komo rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kuknonano me hananàhyatxkon hatà, Txesusu, thenyehra hatà. Onà wyaro nkekon hatà, àwyanye, àhananàhrà kom me hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Nat yonamso toy hatà, toto, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Onà wyaro nexey hatà, natàtho. Tonamsom hoye nothahye hatà, asama yaka. Àrotho yonahtxownà hatà, torono heno, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Àhoye rma nothahye xarha tà, toh hona, yukryeka ahtumnu waka. Nahtaye rma haryhe tà, àrotho. ");
INSERT INTO hixNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Àro ke, kamàmà yasawnukutxhe, naknay hatà. Nuskurumentay hatà, àmxahra tesnàr ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Àhoye rma nothahye xarha tà, ewekhàr waka. Àto rye rma horymamtxownà hatà, ewekhàr yakoro. Natàtho yompoymay hatà, ewekhàrà. Àro ke, ehetahra ro mak nexey hatà, nat heno, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Àhoyeno rma tonamsom me haxa nexey hatà, yukryeka taxeronokem waka. Àro rma nahtay hatà. Horymamye xarha tà. Nehetay xarha tà, thenyehra hatà. Anar komo, 30 me nehetay hatà. Anar komo xarha, 60 me nehetay hatà. Anar komo xarha, 100 me nehetay hatà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Uro enytxatxoko, thanak oyehtokonye. Àhanahra kat manatxowà, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Taa. Totxownà hatà, toto komo. Txesusu hyawo noknomtxownà hatà, 12 komo, anar komo ànhananàhrà komo xarha. Àsok mon màkan ha, kuknonano me, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Onà wyaro neyuhtxownà hatà, Txesusu. Àsok hana toto komo kayaryet me nay ha, Khoryenkom ha, kekon hatà. Àkayaryet kom me tehtxoho hutwamohsohra rma hak naha, noro, toto komo wya. Owyany haxa ryhe uhutwamohsehe, kekon hatà. Anar komo wya haxa ryhe, uhutwamohsehe rma haryhe. Kuknonano me marma wekarymehe, àwyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kuknonano me wekarymehe, toto komo wya, uhutwahra rma ehtxoho menye. Khoryenkom yahoxetà yonyatxhe rma haryhe. Noro ywenyeke rma natxhe ha, kekon hatà. Rorwonà yonytxetxhe rma haryhe. Uhutwahra rma natxhe ha, kekon hatà. Àro ke, kuknonano me marma wekarymehe, àwyanye, Khoryenkom hona àwyanye xenyàr hona. Thona harha àwyanye xenyetok haxa, àhokonye oseryewhokanàràtho haryhe, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Onà wyaro nkekon xarha tà, Txesusu, tànhananàhrà ro komo wya. Kuknonano me ronekarymanàrà hutwahra mahtxok hamà, kekon hatà. Nat yokarymatxho rma hutwahra mahtxok hamà. Àsok tawro hana. Amnye, kuknonano me rma rha rorwonàmnàtok xarha, uhutwahra rma rha manatxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Uhutwamohsos haka, owyanye. Toto wya nat yonamnàtokono wyaro, Khoryenkomo rwonà tekarymetxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Asama yaka othahsahotho ryhe, Khoryenkomo rwonà yonytxanyenhàyamo kuknon me naha. Àwyanye enytxatxhe rma, nomokyaha, Satanasà ymo. Ewan yakanye enamsahotho yaryaha, noro ymo ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Toh hona othahsahotho xarha, anar komo kuknon me naha. Khoryenkomo rwonà yonytxetxhe rma haryhe, nyamoro ha. Tàwyanye enytxatxhe rma, teryehorye nahohsatxhe rma haryhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ewan yakanye enamsahotho rma, àmxahnà wyaro mak naha. Mexehra mak nahohsatxhe ha. Mexehra texetxhenye, toseryehokaxem me harha natxhe, kekon hatà. Teryewhamnohsom me rma natxhe, tàwyanye Khoryenkomo rwonà yonytxanàr ke mak ha. Àro wyaro toseryehokatxhenye rma, nàhnànketxhe harha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ewekhàr waka othahsahotho ryhe, anar komo kuknon me naha. Khoryenkomo rwonà yonytxetxhe rma haryhe, nyamoro xarha. ");
INSERT INTO hixNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Amnye tomyawon kom hoko roro mak natxhe ha. Tkatxhonke rma haxa tesnàr komo xe natxhe xarha. Anaro rha katxhonano hoko rma haxa nehohketxhe xarha. Àro hoye ro, Khoryenkomo rwonà hutwahkahtàketxhe xak hampànà, kekon hatà. Ehetahra mak natxhe ha. Ohxe roro natxhe katxho mehra ro mak natxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Yukryeka taxeronokem waka enamsahotho ryhe, anar komo kuknon me naha. Khoryenkomo rwonà yonytxetxhe, nyamoro ha, kekon hatà. Tàwyanye enytxatxhe rma, ohxe nahohsatxhe. Àro ke, tehetaxemà wyaro ohxe roro natxhe. Ukukur komo rma, 30 me tehetaxemà wyaro ohxe natxhe. Ukukur komo xarha, 60 me tehetaxemà wyaro ohxe rma haxa natxhe. Ukukur komo xarha, 100 me tehetaxemà wyaro ohxe roro rma haxa natxhe, meya roro rma haxa mak ha, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Onà wyaro nkekon xarha tà, Txesusu, tànhananàhrà ro komo wya. Kweyur komo wyaro naha, Khoryenkomo rwonà, kekon hatà. Kweyur komo yotahurhura tehxatxow hamà. Oryen yosnaka txeryhera tehxatxow hamà, kekon hatà. Kahon komo yosnaka txeryhera tehxatxow hamà. Ahon hona haxa teryatxow hamà, àwya kweyhotho menye. Àro wyaro rma rha, Khoryenkomo rwonà tekarymetxow hamà, toto komo wya Khoryenkomo hutwatxho me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Àsok haxa hana nay ha, Khoryenkomo rwonà. Anatoko uhutwahnà me nay hana, kuknonano me rorwonàmrà ke. Uhutwahnàtho rma, thutwaxem me harha mpànà naha ha, amnye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Uro enytxatxoko, thanak oyehtokonye. Àhanahra kat manatxowà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Àro ke, ohxe mpànà enytxatxoko, rorwonà, kekon hatà, àwyanye. Onenytxatxhàyamo ekarymatxoko, anar komo wya. Ekarymahra oyehtokony haxa ryhe, enytxahra harha mpànà manatxhe ha, kekon hatà. Owyanye ekarymantok haxa ryhe, thenyehra menytxetxhe xarha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Owyanye ohxe enytxantoko rma, nenytxamohsehe rye rma haxa, Khoryenkomo, owyanye. Enytxahra oyehtokony haxa ryhe, enytxamohsohra harha mpànà naha ha, owyanye, kekon hatà. Owyanye uhutwehe katxhe rma, muhutwahkahyatxhe harha hampànà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kuknonano me rma rha nàrwonàmye xarha tà, Txesusu, toto kom yakoro. Àsok hana akayaryet kom me nay ha, Khoryenkom ha, kekon hatà. Akayaryet kom me noro yehtxoho, onà wyaro nay hamà. Nat tenamyan hamà, yukryeka waka. ");
INSERT INTO hixNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kàwya enamàtxhe, mexe nyhe ehetahra nay hamà, kekon hatà. Ehetanàr hona ro tehxan hamà. Àhona ro rma tànàkyaha xarha. Thakehe xarha, kekon hatà. Eten hoye ro hana nahten ha. Eten hoye ro hana horymamyan ha. Àywenyeke tehxan hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yukryeka ryhe, nahtanàhyan hamà, tano me ro rma. Ehà htxero nahtehe. Amnye neheràmtxontehe. Amnye nehetehe. Àro wyaro kehutwatxho hoye rohra mak neheten hamà, natà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ehetatxhe rma, thohtyan hamà. Àro wyaro rma rha, tàmryenon me oyeryatxhe, Khoryenkomo, oyehutwatxho kom hoye rohra mak ha. Amnye tàmryenon komo yohamnohyaha hampànà, noro ha, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Onà wyaro nkekon xarha tà, Txesusu, toto komo wya. Àsok hana akayaryet kom me nay ha, Khoryenkom ha, kekon hatà. Àsok hana wekarymen ha, owyanye. Kuknonano me wekarymen hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nat horymamtoho wyaro nay hamà. Natà txko tenamyatxow hamà, mostakna nathàrà txko rma. Anaro nathàr komo yosnaka rma haxa nay hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Horyehnàtho txko rma horymamyaha. Thorymamàtxhe, ehànhenye ymo rma haxa nay hamà, anar komo yoho rma haxa mak ha. Kawo rma haxa nasakmatahten hamà. Akrotnaka ryhe nemàmtetxow hamà, torono komo, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Àro wyaro Khoryenkomo rwonà yokarymekon hatà, àwyanye. Anaro rha kuknonano me nekarymekon hatà, toto komo wya, thenyehra hatà. Àwyanye enytxanàr wararo nyhe rma nekarymekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kuknonano mehra, ekarymahra ro mak nehxakon hatà, toto komo wya. Tànhananàhrà ro komo wya haxa ryhe, omeroro hutwamohsotàhkekon hatà, Txesusu, toto komo nenytxahtor me mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Àro rma kokmamàtxhe, onà wyaro nkekon hatà, Txesusu, tànhananàhrà ro komo wya. Àpa txowà, mon hona, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Àro ke, toto komo nomtxownà hatà. Txesusu ryhe, kanawa yawo rma nehxakon hatà. Àro ke, àro yawo rma natxownà hatà, ànhananàhrà ro komo. Akoronye totxownà hatà, anar komo xarha. Anaro rha kanawa yawo totxownà hatà, nyamoro ha. ");
INSERT INTO hixNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Àtontokonye rma, nomokye hatà, atxowowo ymo, thenyenohnà ymotho rma haxa mak hatà. Dyow dyow dyow kekon hatà, tuna ymo, kanawa heno hoko. Àro heno rma nataràhtekon hatà, thenyehra hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Txesusu ryhe, mahtwo nehxakon hatà. Ahon ho ànàhsaho nehxakon hatà. Nempakatxownà hatà, akoron komo. Khananàhnye y, ketxkon hatà, àwya. Tànoryatxow hamà. Oseryehokahra manaye, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hakay hatà, Txesusu. Atxowowo ymo yatàknanàhkay hatà. Dà kasko, kekon xarha tà, tuna ymo wya. Ayatàknako. Dà, atxowowo ymo natàknay hatà. Tatàknye rma haxa nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Àsok tawro moseryehtxow harha, kekon hatà, Txesusu, àwyanye. Àsok tawro moseryehtxow harha. Khoryenkom hona xenyhera rma hak manatxow hamà, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Noseryehokatxehkatxownà mak hatà, thenyehra rma haxa mak hatà. Onok moson haryhe, ketxkon hatà, tàwyanye rma. Onok moson haryhe. Atxowowo ymo neyuknur me nay hamà. Tuna ymo neyuknur me xarha nay hamà, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mon hona nahatakatxownà hatà, Txesus komo. Xerasa yamtar 4 hona rma nahatakatxownà hatà. Txeey katxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nasanàmye hatà, Txesusu, kanawa yaye. Asanàmàtxhe rma, àhyaka nomokye hatà, toto. Worokyamo yohà rma mok nehxakon hatà. Yatxetxho waye nomokye hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yatxetxho wawo roro nehxakon hatà. Noro ymo yasohtohra harha nehxatxkon hatà, toto komo. Yawaka ke asohtohra harha nehxatxkon hatà, atxke ymo rma haxa esnàr ke. ");
INSERT INTO hixNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Amnyehra, yake ro nasohtotxownà haryhe tà, yawaka ke. Nàhrowomtxownà xarha tà. Yawaka heno yawotekon mak hatà, noro ymo ha. Nakmeryekon mak hatà, worokyamo yano me tahoxerye rma haxa tesnàr ke hatà. Àro ke, arymahra nehxatxkon hatà, toto komo, esnaka tesnàr kom ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yatxetxho wawo nehxakon hatà, àhà ymo ho xarha. Emahona ro kowontekonà roro hatà, kohsaya xarha, awasnaw xarha. Toh ke notokekon hatà, thoko rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Noro ymo rma, moxe ro Txesusu yonyey hatà. Tàwya xenyetxhe rma, karyhe toy hatà, àhyaka. Tosoknar ho neryewtay hatà, akrataka, ehonomnà me tàwya xenyàr ke, ");
INSERT INTO hixNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Teryewrye ro nàrwonàmye hatà. Txesusu y, kekon hatà. Khoryenkom muru omoro ha. Omeroron komo yohon muru rma omoro. Àsok manaye, rohoko, kekon hatà. Àsok manaye, rohoko. Ryeryewhamnohpàra exko hampànà àkehe, owya, Khoryenkomo nenytxanàr me, kekon hatà, noro ymo. ");
INSERT INTO hixNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Àro wyaro rma nkekon hatà, onà wyaro kanyenhàr me rma Txesus yesnàr ke hatà. Worokyamo y, otowko ha, toto hyaye, kanyenhàr me nehxakon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Onok omoro, oyosotà, kekon xarha tà, Txesusu, àwya. Thenyenohnà mak on ha, rosotà, thenyenohnà ymo yoh me ryesnàr ke, kekon hatà, noro ymo. ");
INSERT INTO hixNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Worokyamo nyakhera exko hampànà, oyoro ro, kekon hatà, Txesusu wya. Àro wyaro nkekon hatà, teryewrye ro rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Àto nehxatxkon hatà, okno komo, honyko wyaron komo. Àh yawxawo rma nehxatxkon hatà, thenyehra rma haxa mak hatà. Àto rma nasahxemtetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Àro ke, onà wyaro nkekon xarha tà, noro ymo, worokyamo yano me hatà. Okno komo hyaka amna ànyahko, kekon hatà, Txesusu wya. Ewan yakanye owomso amna ànyahko, kekon hatà. Àro wyaro nkekon hatà, teryewrye ro rma haxa mak hatà, worokyamo yano me mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Àtotxoko, kekon hatà, Txesusu, worokyamo wya. Àtotxoko. Toto hyaye notowtxownà hatà, worokyamo komo, kray kray kray. Okno komo yowan yaka haxa nowomtxownà hatà, kuru kuru kuru. Uuff, huhyakanto kàtatxownà hatà, okno heno komo, omeroro. Krow, tuna ymo kwaka nowomtxownà hatà. Nànotàhkatxownà hatà. Àyakenon komo ryhe, 2000 me nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Okno yonye rotho komo ryhe, nekahtàmtxownà hatà, owto hona. Àton komo wya nekarymatxownà hatà. Owto màhton komo wya xarha nekarymatxownà hatà. Àro ke, exetxhàràtho yonyxe nomohtxownà hatà, toto komo. ");
INSERT INTO hixNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Txesusu hyaka rma nomohtxownà hatà. Worokyamo yohàtho yonytxownà hatà. Thenyenohnà yohàtho yonytxownà hatà. Àto eryewtaxah harha nehxakon hatà. Twomunke harha nehxakon hatà. Tonyxerye harha nehxakon hatà. Àro ke noseryehokatxownà hatà, toto komo, omohxemo komo. ");
INSERT INTO hixNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Xenyenhàyamo ryhe nekarymatxehkatxownà hatà, àwyanye, omohxemo komo wya. Worokyamo yohàtho yonyhoryetxhàrà yokarymatxownà hatà. Okno heno komo noràthàrà xarha yokarymatxownà hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Àro ke, onà wyaro nketxkon hatà, toto komo, Txesusu wya, teryewrye ro rma haxa mak hatà. Àtoko, oyoro ro, amna yowto hoye, ketxkon hatà, àwya, noro yahoxet hona toseryehrà kom ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Àro ke, kanawa yaka nosonkahye hatà, Txesusu. Osonkahnàtoko rma, onà wyaro nkekon hatà, worokyamo yohàtho, àwya. Ayakoro romoknàr xe wehxaha, kekon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Omokhàra exko, kekon mak hatà, Txesusu, àwya. Àtoko, omàn yaka, ayanan kom waka. Oskarymako, àwyanye. Kohkomo ryhe ronyhoryeno, thenyehra, kasko, àwyanye. Rohnàn yawo rma haxa nahko, kasko, àwyanye, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Àro ke toy hatà, worokyamo yohàtho. Noskarymekon hatà, toto komo wya, Dekaporyes hon komo wya. Txesusu ryhe ronyhoryeno, kekon hatà, àwyanye. Towahke rma haxa nahko, rohoko, kekon hatà. Koo, àsok tawro harha, ketxkon hatà, toto komo, omeroron komo. ");
INSERT INTO hixNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Wetoy harha tà, Txesusu, on hona harha. Àhyaka nohsamnohtàkatxownà hatà, toto komo, thenyenohnà komo. Tuna ymo yohoye rma nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nomokye hatà, horykomo. Xayru rma noro hatà. Xuknewyana komo yohà rma mok nehxakon hatà, tohsamnohsomà ro komo yonye ro rma hatà. Tàwya Txesusu yonyetxhe rma, tano me ro rma nehurkay hatà, akrataka. ");
INSERT INTO hixNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Onà wyaro nkekon hatà, àwya, teryewrye ro rma haxa mak hatà. Romsàtho txko àwayehpaya manaye, kekon hatà. Omoko xenykoto. Ayamorà txerykoto, àhona, ohxe harha ehtxoho me, àwayehpàra ehtxoho me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Àro ke toy hatà, Txesusu, akoro. Txesus yakoro rma totxownà, hatà, toto komo xarha, thenyenohnà komo. Nohtaymetxkon hatà, noro hona. ");
INSERT INTO hixNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Àwawonye nehxakon hatà, wosà. Ekehà rma mok nehxakon hatà, noro ha. Tkamsukrye roro nehxakon hatà. Àro wyaro rma 12 me txemnyehàntay hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tkatxhothàrà yàmtàhkanyenhàr me nehxakon hatà, ohtxemano ynye ro komo wya, anaro rha komo wya. Omeroro tàmtàhkanyenhàr me nehxakon hatà, tohtxe yehetho me rma haryhe tà. Tohtxemaxemà rma, neryewakonà rye rma haxa mak hatà. Ehtxemnà ro me mak nehxakon hatà, tanhàntatàhkaxe ro rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Noro rma, Txesusu yokaytà yonytxanyenhàr me nehxakon hatà. Àro ke nomokye hatà, toto kom yakoro. Txesusu mkaye nomokye hatà. Àhononà yahey hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Àsok tawro hana. Onà wyaro rma nkekon hatà, tàwya rma. Rowya àhononà yahenàr ke ryhe, ohxe harha wehxan hamà, kekon hatà. Àro ke nahey hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Dà kay hatà, àkamsukuthuru. Àtoko rma natàknay hatà. Eheryanàthàrà rma natàknay hatà. Ryeheryanàtho natàknan hamà, ohxe harha wehxan hamà, kekon hatà, tàhnawo. ");
INSERT INTO hixNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Àtoko rma nehutway hatà, Txesusu. Rohyaye notowno hamà, rahoxetà, toto yonyhoryetxho, kekon hatà, tàhnawo. Àro ke neramay hatà, toto kom wawo rma, thenyenohnà kom wawo rma. Onok mokro rohononà yaheno ryhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Onà wyaro nketxkon hatà, ànhananàhrà ro komo, àwya. Toto komo menyaha, ketxkon hatà. Thenyehra rma haxa natxow hamà. Nohtaymetxow hamà, ohona. Àsok tawro, onok mokro raheno, màken harha, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Àhorye ronye nenytxehketxkon hatà, Txesusu, tahenyenhàrà yonytxoho me. ");
INSERT INTO hixNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Àhyaka haxa nomokye hatà, wosà. Ohxe harha tehtxoho hutwekon hatà. Àro ke nàràrànakon hatà, oseryehrà. Tano me ro rma nehurkay hatà, Txesus yakrataka. Yaworo rma haxa noskarymay hatà, tkatxehkaxe ro, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Wosà y, kekon hatà, Txesusu, àwya. Ohxe harha manaha, rohona owya xenyàr ke mak ha. Ohxe àtoko. Ohxe roro oyesnàrà moro ha, kekon hatà, Txesusu, wosà wya. ");
INSERT INTO hixNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wos yakoro Txesusu rwonàmnàtoko rma, nomohtxownà hatà, toto komo. Horykomo màn yaye nomohtxownà hatà, Xayru màn yaye rma hatà. Oyomsàthàr heno wayehno haxa ha, ketxkon hatà, Xayru wya. Khananàhnye komo yarhàra harha manay hamà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Txesusu ryhe, àrwon komo yonytxanyehnà wyaro rma nehxakon hatà. Onà wyaro haxa ryhe nkekon hatà, horykomo wya. Oseryehokahra exko, kekon hatà, àwya. Rohona rma xenyko, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Horohkano yeryey hatà. Rakoro omokhàra ehtxoko, kekon hatà, toto komo wya. Petru kom marma totxownà hatà, akoro, Txaku xarha hatà, Xowaw xarha hatà. Txaku yowtà rma noro ha, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Horykomo màn yaka haxa totxownà hatà. Thenyehra rma haxa natmeryketxkon hatà, toto komo, àton komo. Nàratetxkon hatà. Nehokoyatxkon hatà, omsamtxemo heno hnànà, thenyehra rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nowomye hatà, Txesusu. Onà wyaro nkekon hatà, àwyanye. Àsok tawro matmeryketxow harha, kekon hatà, àwyanye. Àsok tawro owratetxow harha. Àwayehpàra naha, omsamtxemo. Ànàknàrà rma onà, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Newnohtxownà mak hatà, toto komo. Àna make ryhe mpe, ketxkon hatà. Nenampatakatxehkatxownà mak hatà, Txesusu. Omsamtxemo yàmà yarày hatà. Àyon xarha, Petru komo xarha yarày hatà. Nowomtxownà hatà, tahusom yaka, àto omsamtxemo yehtxoho yaka rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Noro yahosày hatà, Txesusu, amor hoko. Taryeta kume, kekon hatà, àwya. Àro wyaro katxho rma, onà wyaro katxho me rma naha. Roknà y, asanàmko, àkehe, owya, katxho me rma naha, taryeta kume katxho. ");
INSERT INTO hixNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Àtoko rma nasanàmye hatà, omsamtxemo. Sax, sàh sàh sàh, nataryeknohyakon harha tà. 12 me txemnyehà nehxakon hatà, enuruthurunhuru. Txesus yakoron komo ryhe, noseryehokatxehketxkon hatà, thenyehra rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","On yokarymahra xaxa mpànà ehtxok ha, anar komo wya, kekon hatà, Txesusu, àwyanye. Àro wyaro nkekon hatà, teryewrye ro rma haxa mak hatà. Ànyahrà tàmtxoko, kekon xarha tà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Karyeryeya kuthonà ymo yohoye ro toy hatà, Txesusu. Towtothàr hona harha toy hatà, Nasarye hona harha hatà. Ànhananàhrà ro komo xarha, akoro totxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Àton komo hananàhyakon hatà, Txesusu, hokano ytxoho yawasàn ho hatà. Nàmno ymo yawo hananàhyatxkon hatà, ohsamnohtoho kom yawo. Koo, noseryehoketxkon hatà, nyamoro, enytxany komo rma, thenyenohnà komo rma. Àsok nay haryhe, mosonà, ketxkon hatà, tàwyanye rma. Àsok nay haryhe. Tàywero rma haxa nay hamà. Eryehokano ynye ro me xarha nay hamà. Tahoxetà rma yonyhen hamà, kàwyanye. Onok hoye ro ryhe ehonomnà me naye, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Noro ywero tehxatxow hamà. Wewe yonyhoryenye ro mehra kat naye, ketxkon hatà. Maryeya mryerà mehra kat naye. Txaku yowtà mehra kat naye, ketxkon hatà. Xose yowtà mehra kat naye. Xuknas yowtà mehra kat naye. Semaw yowtà mehra kat naye, ketxkon hatà. Noro wosàn mehra kat natxowà, mokyamo, kwawon komo rma. Noro ywero tehxatxow hamà. Noro rma, ehonomnà me mak naha. Àsok nay haryhe, ketxkon hatà, tàwyanye rma. Khoryenkom yano me ehonomnà me nay hamà, kahra mak nehxatxkon hatà. Àro ke noro xehra nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Khoryenkomo yokarymanye ro komo yonytxetxow hamà, toto komo, kekon hatà. Ewto hon kom haxa ryhe, enytxahranye ro mak natxow hamà. Ukukur komo ryhe, enytxahranye ro mak natxow hamà, kekon hatà, Txesusu, towto hon komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Towtothàr ho tehtoko, tahoxetà yonyhohra nehxakon hatà, àwyanye. Nenyhoye rma haryhe tà. Yakenohnà komo rma yonyhoryey hatà. Ekeh kom hona tamorà yeryey hatà, tàwya enyhoryetxho menye. Yakehra mak nenyhoryetxownà hatà, àto. ");
INSERT INTO hixNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Noseryehokekonà rma haxa mak hatà, àhokonye, thona xenyhera esnàr kom ke hatà. Anaro rha owto hona toy hatà, Nasarye màhton hona rma hatà. Àton komo hananàhyakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","12 komo yanyekye hatà, Txesusu, tàhyaka. Asako rye nànyahtxownà hatà, asako rma rha, asako rma rha. Àro wyaro asako rye nànyahtxownà hatà, omeroro. Àtotxok ha, kekon hatà. Àtotxok ha. Rano me ryhe ehonomnà me manatxhe ha, owyanye worokyamo yowtoho me, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Akorohra rma àtotxoko, kekon xarha tà. Owru komo yarhàra ehtxoko. Ayamatan komo xarha yarhàra ehtxoko, kekon hatà. Otxenyerun komo xarha yarhàra ehtxoko. Atxok haryhe, ayahoso kom mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tàhrowomke rma àtotxoko, kekon hatà. Asako owomun komo yarhàra mak ehtxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Onok kom màn yaka hana oyowomàtxhenye, àto rye rma hak oyonmahyatxhe ha. Owto hoye otohra ronye rma haka, àro rye yawo rma oyonmahyatxhe ha, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Anaro rha owto hona àtotxoko. Oyonytxahranye owto hon komo yehtoko, onà wyaro ehtxoko, anhàn komo hutwamohsonàr horà, kekon hatà. Ewto kom hoye otontokonye, ehtahpunkatxoko, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Àro ke totxownà hatà, 12 komo. Onà wyaro nekarymetxkon hatà. Anar me harha ayanhànàthàyamo xenytxoko, ketxkon hatà, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Worokyamo komo yowyatxkon hatà, toto komo hyaye, thenyehra hatà. Ekeh komo karyetxkon hatà, àkat ke, thenyehra rma rha hatà. Àro wyaro nenyhoryetxkon hatà, Txesus yano me hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Txesusu nekaytay hatà, thenyehra hatà. Àro ke nenytxay hatà, Eroknesà. Karyeryeya yamtar hon komo kayaryetà rma mok nehxakon hatà, noro ha. Onà wyaro nketxkon hatà, toto komo, Txesus hoko. Xowaw heno mokro hamà, ketxkon hatà, anar komo. Àwayehxemo kom waye nasanàmyak hamà, Xowaw heno, aymomno ynye ro heno. Noro rma mokro hamà. Karyhe harha tehtxoho hoye ro eryehokano yeryan hamà, ketxkon hatà, Txesus hoko. ");
INSERT INTO hixNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Onà wyaro nketxkon hatà, anar komo, noro hoko. Eryeyas heno mokro hamà, ketxkon hatà. Onà wyaro nketxkon hatà, anar komo. Khoryenkomo rwonà yokarymanye ro heno komo kukuru ryhe mokro hamà, ketxkon hatà. Àro wyaro anar me rha nketxkon hatà, toto komo, Txesus hoko. ");
INSERT INTO hixNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Eroknesà ryhe, onà wyaro haxa nkekon hatà, tàwya Txesusu yokaytà yonytxatxhe. Xowaw heno mok hamà, kekon hatà. Ronhàmkotohothotho rma mok hamà. Àwayehxemo kom waye nasanàmyak hamà, kekon hatà, Eroknesà, Txesus hoko. ");
INSERT INTO hixNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Àro wyaro nkekon hatà, Xowaw heno wayehkahonyenhàr me tesnàr ke hatà. Noro heno yahohsonyenhàr me nehxakon hatà. Nasohtohoy xarha tà. Nahryempoy xarha tà, watxa ymo yaka, àwya toynyàr ke mak hatà. Àsok tawro hana. Towtà hetxenho yahosnyenhàr me nehxakon hatà, Eroknesà. Erokneyasà noro hatà, wos yosotà, Feryepe hetxenho rma hatà. Noro rma yahosày hatà, Eroknesà. Àro ke neyey hatà, Xowaw heno. Atxke manaha, kekon heno hatà, Eroknesà wya. Atxke manaha. Tahohsoryehra ro mak naha ha, owya, oyowtà hetxe kaxe, kekon hatà, Xowaw heno. Àro hoye ro nahryempoy hatà, Eroknesà, watxa ymo yaka. ");
INSERT INTO hixNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Newakàhkahye hatà, wosà, Erokneyasà. Newakàhkahye hatà, Xowaw heno hoko. Noro yotahahonàr xe rma haxa nehxakon hatà, Eroknesà wya. Etahahohra rma hak nehxakon hatà, noro wya. ");
INSERT INTO hixNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Àsok tawro hana. Eroknesà ryhe, newankaranakon hatà, Xowaw hona. Ohxe roro rma haxa nay hamà, mokà. Enyhoru ro me rma haxa nay hamà, kekon hatà, Xowaw hoko. Àro ke, noro hona newankaranakon hatà. Noro kurunhekon hatà. Noro yonytxekonà rma haryhe tà, Eroknesà. Tàwya enytxantoko rma, uhutwahra rma nehxakon hatà. Enytxanàr xe mak nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Taa. Eroknesà yonuruthurunhuru yawasànà ryhe, nenmahye haxa hatà. Àro rma ho Xowaw heno yotahahoy haxa hatà, wosà, Erokneyasà. Onà wyaro nehxakon hatà, Eroknesà. Ehonomnà komo yahxemtoy hatà, tonuruthurunhuru yawasàn ho hatà. Asahxemtoso totxownà hatà, ehonomnà komo, Eroknes yanoto yoh komo rma, waha yoh komo xarha, horykomo komo xarha. Karyeryeya hon komo rma nyamoro hatà, horykomo komo. Nyamoro rma yahxemtoy hatà, Eroknesà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Àto rye ehtokonye rma, nowomye hatà, omaso, Erokneyasà yomsàrà. Manhoy hatà, Eroknes komo nenyàr me hatà. Neryehotanàhtxownà hatà, banhonàr ke. Àro ke, onà wyaro nkekon hatà, Eroknesà, àwya, omaso wya. Eten xe manaye, kekon hatà, àwya. Eten xe manaye. Àro rma wàmyaha, àx oyehtxoho rma, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Àx oyehtoko, rowto hoye wàmyaha, owya. Àrakayotho wararo wàmyaha, àx oyehtoko, kekon hatà. Àro ke, àx oyehtxoho ekarymako, rowya. Tàmpàra rma ryehtoko, romtatkano rma hak Khoryenkomo, kekon hatà, Eroknesà, omaso wya. ");
INSERT INTO hixNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Àro ke toy hatà, omaso, tàyonà hyaka, Erokneyasà hyaka. Eme y, kekon hatà. Eten kom hoko ryhe, àx wehxaha, àkeno, àwya, kekon hatà, tàyonà wya. Onà wyaro haxa neyukye hatà, àyonà. Xowaw heno àhàmkotohoko, kasko, àwya, kekon hatà. Noro heno yhuthotho sokhoko, rohyaka, kasko, àwya, kekon hatà, Erokneyasà, tomsàrà wya. ");
INSERT INTO hixNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Amamehra rma haxa toy harha tà, omaso, Eroknesà hyaka. Tàyon yano me onà wyaro nkekon hatà, àwya. Xowaw heno àhàmkotohoko, kekon hatà. Aymomno ynye ro heno rma àhàmkotohoko. Noro heno yhuthotho sokhoko, rohyaka. Wetxe yaw hak nehtxowà, ayanoto komo, kekon hatà. Àro rma xe wehxaha, kekon hatà, omaso, Eroknesà wya. ");
INSERT INTO hixNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Àro wyaro tàwya enytxatxhe rma, nekhokay hatà, Eroknesà, thenyehra rma haxa mak hatà. Àhàmkotohonàr xehra nehxakon hatà. Onà wyaro kanyenhàr me mak nehxakon hatà. Tàmpàra rma ryehtoko, romtatkano rma hak Khoryenkomo, kanyenhàr me nehxakon hatà, àton komo nenytxanàr me hatà, omeroron komo nenytxanàr me hatà. Àro ke omaso yoyukye hatà. Àhàmkotohohra wehxaha kahra nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Àtoko rma tanoto nyakye hatà. Otahano ynye ro rma nyakye hatà. Àhàmkototaha, uyhuthuthuru mekyaha ha, kekon hatà, Eroknesà, àwya. Àro ke watxa ymo yaka toy hatà, anoto. Xowaw heno hàmkotoy hatà, àto. ");
INSERT INTO hixNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Uyhuthuthuru yokye hatà, wetxe yawo. Nàmye hatà, omaso wya. Noro rma narày hatà, tàyonà hyaka. ");
INSERT INTO hixNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Taa. Tàwyanye enytxatxhe, totxownà hatà, Xowawu nhananàhrà rotho komo. Ekehàthàrà yatxownà hatà. Nenamtxownà hatà, toh yowtar yaka. Àro wyaro noro heno yetxownà hatà, ànhananàhrà rotho komo. ");
INSERT INTO hixNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Taa. Txesusu hyaka nomohtxownà harha tà, 12 komo, ànànyaketxhàyamotho rma. Àhyaka nohsamnohtàkatxownà harha tà. Noskarymatxehkatxownà hatà, àwya. Àsok hana nenyhoryetxownà ha. Àsok hana hananàhtxownà ha. Noskarymatxehkatxownà hatà, Txesusu wya, omeroro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Onà wyaro nkekon hatà, Txesusu, àwyanye. Omohtxoko, kekon hatà. Ahehnaka omohtxoko, tàtotxe, kàwyamo ro rye, kekon hatà. Mexe nyhe txko àhokaxe tàtotxe, kekon hatà. Àro wyaro nkekon hatà, thenyehra rma haxa toto komo yesnàr ke hatà. Ososathànanye nomokyatxkon hatà, toto komo, Txesusu hyaka. Àro ke, emtakmahra nehxatxkon hatà, Txesus komo, àhoko rma haxa tesnàr kom ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Àro ke totxownà hatà, kanawa yawo. Meya totxownà hatà, ahehnaka, totohnaka hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Àtonàr komo yonytxownà mak hatà, toto komo. Mokyam hamà, ketxkon hatà. Mokyam ha tetxhe, ketxkon hatà. Àro ke totxownà hatà, nyamoro xarha, thenyenohnà komo. Anaro rha owto hoye omohxemo komo rma nyamoro hatà. Karyhe rye rma haxa totxownà hatà. Mahorye totxownà hatà, àwararo rma hatà. Tur tur tur tur tur tur, kràk, katxownà hatà. Nyamoro htxero, Txesus komo wahrokototxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Txeey, Txesus komo xarha nahatakatxownà hatà. Tasanàmnàtoko, toto komo yonyey hatà, Txesusu. Thenyehra rma haxa nehxatxkon hatà. Àhnàn kom yawo rma haxa nehxakon hatà, Txesusu. Àsok tawro hana. Kahneru wyaro nehxatxkon hatà, àwya. Esompànà wyaro rma nehxatxkon hatà, àwya, àhananàhpànàtho me tesnàr kom ke hatà. Àro ke hananàhyatxkon hatà. Anaro rha ke hananàhyatxkon hatà, thenyehra hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Àro rma kokmamrà ro, Txesusu hyaka haxa totxownà hatà, ànhananàhrà ro komo. Onà wyaro nketxkon hatà, àwya. Ehxera ro mak naha, owto, tano, ketxkon hatà, àwya. Tkokmamtxow ha. ");
INSERT INTO hixNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Àro ke, toto komo ànyahtxoko, ketxkon hatà. Ànyahtxoko. Anaro rha owto hona hak totxowà, ketxkon hatà. Màhton hona hak totxowà, tànyahrà komo yehekahso, ketxkon hatà, ànhananàhrà ro komo, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Omnyamo rma ànyahmatxoko, kekon hatà, àwyanye. Àna matà, ketxkon hatà. Amna tonàr xe manaye. Moxam nyahrà yehekahso amna tonàr xe manaye, ketxkon hatà. Uyur komo yehetho ryhe, 1000 kruseyrus yoho nyhe nay hamà. Àro rma yàmrà xe manaye, amna wya, ànyahmanàr kom horà, ketxkon hatà, ànhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Twahak naye, ekeyu, ohyawonye, kekon hatà, Txesusu, àwyanye. Twahak naye, ekeyu. Xenytxatxko, kekon hatà. Tàwyanye xenyetxhe, nomohtxownà harha tà. 5 me manaye, ketxkon hatà. Kana xarha, 2 me manaye, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Eryewtatxoko, kekon hatà, Txesusu, toto komo wya. Eryewtatxoko. Neryewtanàhtxownà hatà, txufu txko waka. ");
INSERT INTO hixNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Àro ke neryewtatxownà hatà, toto komo, asamtaha ro. 100 me rye neryewtatxownà hatà, anar komo. 50 me rye neryewtatxownà hatà, anar komo xarha. 100 me rma rha neryewtatxownà hatà, anar komo xarha. 50 me rma rha neryewtatxownà hatà, anar komo xarha. Àro wyaro nehxatxkon hatà, eryewtaxemo, thenyenohnà komo. ");
INSERT INTO hixNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ekeyu yanàmye hatà, Txesusu. 5 me rma nanàmye hatà. Kana xarha yanàmye hatà, 2 me rma. Kakoso nosompotày hatà. Nàrwonàmye hatà, Khoryenkom yakoro, ekeyu hoko, kana hok xarha. Nowye hatà. Nàmye hatà, tànhananàhrà ro komo wya. Ekamtxoko, kekon hatà, àwyanye. Kana xarha hanahtoy hatà, 2 me, et kom hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Omeroro rma nenahtàkatxownà hatà. Wahuramtàhkatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Otàkràskatxhàràtho yonàmatxownà hatà, wetxe ymo yaka. Kana hpunutho xarha yonàmatxownà hatà. 12 me rma nenàmatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Twahak hana nehxatxkon ha, toto komo, ekeyu yonahnyenhàyamo. Kàrkomo komo ryhe, 5000 me hana nehxatxkon ha. Nenahtxownà xarha tà, woràskomo komo, àhokyamo xarha. ");
INSERT INTO hixNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tàwya toto komo nyahmatxhe rma, tànhananàhrà ro komo nyakye hatà, Txesusu. Kanawa yaka osonkahtxoko, kekon hatà, àwyanye. Roywaho àtotxoko, mon hona, Betsayda hona, kekon hatà. Uro ryhe toto komo ànyakyaha, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Àro ke nànyahtxownà hatà. Tàwya ànyaketxhenye rma, toy hatà, àh hona. Noro ro toy hatà, Khoryenkom yakoro àrwonàmso. ");
INSERT INTO hixNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Taa. Kokmamye hatà. Txesusu nhananàhrà ro komo ryhe, kanawa yawo rma nehxatxkon hatà. Tuna ymo rakatawo rma nehxatxkon hatà. Moxe rma haxa mak nehxakon hatà, yukryeka. Txesus haxa ryhe, yukryeka ho rma nehxakon hatà, noro ro mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Moxe ro nyamoro yonyey hatà. Kway kway ketxkon hatà, nyamoro, tahoxerye rma haxa hatà. Empatayenye nomokyakon hatà, atxowowo ymo. Àro wyaro nenytxownà hatà, Txesusu. Àro ke toy hatà, àhyakanye. Enmahpaya ehtoko, àhyakanye toy hatà. Tuna ymo ratokoko toy hatà, sàh sàh sàh sàh sàh sàh. Àwetotxahkenye nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tuna ymo ratokoko omoknàrà rma yonytxownà hatà, kanawa yawon komo. Noskatokatxownà mak hatà. Mokro ymo ha okatonho, ketxkon hatà. Kowontetxkon hatà, oseryehrà komo. ");
INSERT INTO hixNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Amamehra mak nàrwonàmye hatà, Txesusu, akoronye. Oseryehpàra ehtxoko, kekon hatà. Uro ryhe uro. Towankaryhe ehtxoko, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kanawa yaka nosonkahye hatà, àhyakanye. Dà, natàknay hatà, atxowowo ymo. Thenyehra rma haxa noseryehokatxehketxkon hatà, Txesus yakoron komo. ");
INSERT INTO hixNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Àsok tawro hana, Txesusu yahoxetà hutwahra rma hak tesnàr kom ke hatà. Noro wya toto komo nyahmanàrà yonyenhàr me nehxatxkon hatà. Noro yahoxetà hutwahra rma nehxatxkon hatà. Akàhpàra rma haxa nehxatxkon hatà, tàhnawonye. ");
INSERT INTO hixNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Wetotxownà haxa hatà, Txesus komo. Txeey, katxownà hatà, Xenesarye yamtar hona. Tkanawar komo yowahtotxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kanawa yaye nasanàmtxownà hatà. Mokro ha Txesusu, ketxkon hatà, toto komo, àton komo. ");
INSERT INTO hixNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Àro ke totxownà hatà. Karyhe totxownà hatà, ekeh kom horà. Anana rha totxownà hatà, anaro rha owto hona. Xenesarye yamtar horye rma totxownà hatà. Ekeh komo yokyatxkon hatà. Tahon hon komo rma yokyatxkon hatà. Henta ya hana nekyatxkon ha. Mono manaye, Txesusu, katxho na rma nekyatxkon hatà. Txesusu hyaka rma nekyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Txesusu ryhe, anana rha tekon hatà, anaro rha owto txko hona hatà, anaro rha owto ymo hona xarha hatà, owto màhton hona xarha hatà. Henta kom ehtok hana, àhyaka nomohtxownà hatà, toto komo. Ekeh komo yohtxownà hatà. Yakentaka ryhe nenàhtotxownà hatà. Ohonon ahehoko, amna wya, ketxkon hatà, ekeh komo, Txesusu wya. Ohonon yotxhàrà rma ahehoko, amna wya, ketxkon hatà. Àro ke nahetxownà hatà. Ahenyenhàyamo rma, ohxe harha nehxatxkon hatà, omeroro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Txesusu hyaka nomohtxownà hatà, Farysew kukur komo, àyweronàhyamano ynye ro kukur komo xarha. Xerusaryen hoye omohxemo komo rma mokyam nehxatxkon hatà. Omeroro rma nohsamnohtàkatxownà hatà, Txesusu hyaka. ");
INSERT INTO hixNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Txesusu nhananàhrà ro komo yemtakmanàrà yonytxownà hatà. Osomyakorokahra nemtakmetxkon hatà. Àro ke, atxke rma haxa nehxatxkon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tosomyakorokatxheny marma ryhe, nemtakmetxhe, Farysew komo. Àro wyaro ryhe natxhe, Xuknewyana komo, omeroron komo, thoryen heno komo wya tàyweronàhyamatxhàyam yawo ro tehtxoho menye. ");
INSERT INTO hixNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Warawantano ytxoho yaye tomokàtxhenye, emtakmahra hak natxhe. Bàn kom yaka harha tomokàtxhenye, wahoro htxero nekoroketxhe. Tekorokatxheny marma, nemtakmetxhe. Anaro rha ke nàyweronàhyamatxownà xarha tà, àhoryen heno komo, thenyehra hatà. Àro ke, orymak heno yakoroketxhe. Oryen heno xarha yakoroketxhe. Oryen yawaka heno xarha yakoroketxhe. Àro wyaro natxhe, Xuknewyana komo, tàyweronàhyamatxhàyam yawo roro rma tehtxoho menye. ");
INSERT INTO hixNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Àro ke, onà wyaro nketxkon hatà, Farysew komo, àyweronàhyamano ynye ro komo xarha, Txesusu wya. Atxke natxow hamà, onhananàhrà ro komo, ketxkon hatà, àwya. Àsok tawro hana. Osomyakorokahra nemtakmetxhe. Àro ke atxke natxow hamà. Khoryen heno komo wya kàyweronàhyamatxho kom yawo rohra natxow hamà, ketxkon hatà, Farysew komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Enyhoru uro ha kany me rma manatxhe haryhe, kekon hatà, àwyanye. Enyhoru uro ha kanye rma, yaworohra manatxhe. Ohokonye ryhe, yaworo xaxa menhoy hamà, Esaeyas heno, Khoryenkom yano me mak ha, kekon hatà. Onà wyaro nmenhoy hatà. Ohxe naha, Khoryenkomo, ketxhe rma haryhe, nyamoro ha. Tàmtar kom ke marma, àro wyaro nketxhe. Tàhnawony haxa ryhe, rohona xenyhera ro mak natxhe ha. ");
INSERT INTO hixNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Àtohnawo rma rowakryetxhe haryhe. Khoryenkomo rwonà amna nekarymehe, owyanye, ketxhe rma haryhe, toto komo wya. Toto rwon haxa ryhe yokarymetxhe, nyamoro ha. Àro wyaro rma nmenhoy hatà, Esaeyas heno. Ohokonye ryhe nmenhoy hamà, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Khoryenkomo yoyukhura manatxhe. Ohoryen heno kom haxa ryhe meyukyatxhe, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Khoryen heno komo wya kàyweronàhyamatxho kom yawo ron me rma haxa tehtxe, kany me manatxhe. Àro yawo rono rma, Khoryenkomo rwon yawo rohra mak manatxhe, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Àsok tawro hana. Tàrwonà ryhe menhohoy hatà, Khoryenkomo, Moyses heno wya. Àro yawo rohra mak manatxow hamà. Onà wyaro ryhe nmenhoy hatà, noro heno. Toyuhsom me xenytxoko, oyàm komo, oyon komo xarha. Tàyàm komo wàràhyakany kom haxa ryhe etahatxoko. Àro wyaro rma nmenhoy hatà, Moyses heno, Khoryenkom yano me mak hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Onà wyaro haxa ryhe àyweronàhyamano meryatxhe, omnyamo, ohoryen heno kom yano me mak ha. Khoryenkomo wya dekàthàyamo yàmnàtoko, kyàm komo yowakryehra harha tehxatxow hamà, kyon komo yowakryehra harha tehxatxow hamà, màketxhe, toto komo wya, kekon hatà. Onà wyaro katxoko, oyàm komo wya, oyon komo wya, màketxhe, àwyanye. Apa y, eme y, owya tàmsomàtho rma haxa on nahko haryhe, rokatxhotho, owya tàmpàra harha wehxaha, Kokman onà katxho me harha esnàr ke, Khoryenkomo wya tàmsomà onà katxho me harha esnàr ke, katxoko, màketxhe, toto komo wya, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Àro wyaro owyanye àyweronàhyamantokonye, ohoryen heno kom yano me màyweronàhyametxow hamà. Nyamoro heno yano me owyanye àyweronàhyamantokonye rma, Khoryenkomo yoyukhura rma manatxow hamà, kekon hatà. Nahko yxak haka kany me rma manatxow hamà, Khoryenkomo rwon hoko. Àro wyaro rma rha atxke màyweronàhyametxhe, anaro rha ke, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Toto komo yanyekye xarha tà, Txesusu, tàhyaka. Toto komo y, uro enytxatxoko, kekon hatà, àwyanye. Rorwonà ahohtxoko, ohnawonye, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Àsok katxho me hana natxow ha, toto kom ha. Atxke manatxhe katxho me natxow hamà, omeroro, kekon hatà. Woto yonotho hoye rohra mak àro wyaro katxho me natxhe, osomyakorokahra temtakmatxho kom hoye rohra mak ha. Tàhnawonye atxke tehtxoho kom hoye ro haxa ryhe, atxke manatxhe katxho me natxhe ha, Khoryenkomo wya, àro hoye ro atxke tesnàr kom ke mak ha, kekon hatà. Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Uro enytxatxoko, thanak oyehtokonye. Àhanahra kat manatxowà, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Taa. Toto komo nomtxownà hatà, Txesus komo. Bàn kom yaka nowomtxownà hatà. Àsok mon màkan ha, kuknonano me, ketxkon hatà, ànhananàhrà ro komo, Txesusu wya. Àsok mon màkan ha, kuknonano me. ");
INSERT INTO hixNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Onà wyaro nkekon hatà, Txesusu, àwyanye. Omnyam xarha, uhutwahra manatxowà, kekon hatà. Uhutwahra manatxowà. Onà wyaro thutwaxem me nay hamà, ronekarymatxho. Kowan kom yawo rorohra nay hamà, tonosahotho, kekon hatà. Khosot kom yarye ten hamà. Baharaxkaxe ro nahataken hamà. Àro ke, woto yonotho hoye rohra atxke manatxhe katxho me natxow hamà, toto komo. Àro wyaro uhutwahra kat manatxowà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. Àro wyaro tàwya tatoko rma, onà wyaro nkekonà rma hamà. Ohxe rma haxa naha, woto, omeroro, tonohorye rma haxa naha, kekonà rma hamà. ");
INSERT INTO hixNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Onà wyaro nkekon xarha tà, Txesusu, àwyanye. Tàhnawonye atxke tehtxoho kom hoye ro haxa ryhe, atxke manatxhe katxho me natxhe ha, toto komo, Khoryenkomo wya, àro hoye ro atxke tesnàr kom ke mak ha, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Àsok tawro hana. Onà wyaro atxke natxow hamà, tàhnawonye. Atxke nehutwetxow hamà. Anatoko twayamontanàr komo xe natxow hamà. Anatoko anar komo katxhotho yanàr xe natxow hamà. Anatoko toto yotahanàr xe natxow hamà, kekon hatà. Anatoko anar komo hetx hoko tesnàr komo xe natxow hamà. Anatoko anar komo ynyo hoko tesnàr komo xe natxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Anatoko nehohketxow hamà. Anatoko toto xehra rma haxa natxow hamà. Anatoko toto yonkuhtonàr xe natxow hamà, kekon hatà. Anatoko tweromra tesnàr komo xe natxow hamà. Anatoko toto hoko tatakuynyàr komo xe natxow hamà, kekon hatà. Anatoko toto wàràhyakanàr xe natxow hamà. Anatoko ehonomnà me rma haxa nosonyatxow hamà. Anatoko akàhpàra rma haxa nehutwetxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Àro wyaro tàhnawonye atxke tehtxoho kom hoye ro, anaro rha tanhàn kom hoko natxhe, toto komo. Àro hoye ro ryhe, atxke manatxhe katxho me natxhe ha, Khoryenkomo wya, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Xenesarye yamtar hoye toy hatà, Txesusu. Toy hatà, Txeru màtkoso, Seknon màtkoso rma. Xuknewyanahnà komo yowto rma àro ha, Txeru, Seknon xarha. Àto tehtoko, toto màn yawo nehxakon hatà. Àto tehtxoho hutwanàr xehra nehxakon hatà, toto komo wya. Nekaytay mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Noro yokaytà yonytxay hatà, wosà. Xuknewyanahnà rma mok nehxakon hatà. Serofeneseyayana haxa mok nehxakon hatà. Noro yomsàtho txko ryhe, worokyamo yoh me nehxakon hatà. Àro ke, tàwya Txesus yokaytà yonytxatxhe rma, nomokye hatà, noro, àhyaka. Tano me ro rma nehurkay hatà, akrataka. ");
INSERT INTO hixNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Onà wyaro nkekon hatà, àwya. Worokyamo yoh me manaye, romsàtho txko. Noro hyaye towko ha, kekon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Onà wyaro haxa nkekon hatà, Txesusu, àwya. Wahoro htxero khokyamo ryhe tànyahmetxow hamà, kekon hatà. Khokyamo nyahrà hoye tàmpàra tehxatxow hamà, kaykusu wya. Àro wyaro rma rha, Xuknewyana komo yonyhoryenye ryhe, anar komo yonyhoryehra nay hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Àna mat mà, rohà y, kekon hatà, wosà. Neyukyakon hatà. Àna mat mà. Onà wyaro haxa àkehe, owya. Tosom hokru nyahrà hpunutho txko yonahyan hamà, kaykusu, kekon hatà. Emtakmano ytxoho yahomyawo nenahyan hamà. Àro ke, uro nyhe txko ewakryeko, atxke txko nyhe rma, kekon hatà, wosà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ohxe uro meyukno ha, kekon hatà, Txesusu, àwya. àwya. Àro ke, ohxe àtoko. Worokyamo wowno hampànà, oyomsàrà hyaye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Àro ke toy hatà, wosà. Toy hatà, bàn yaka harha. Tomsàra txko yonyey hatà. Tàrah nehxakon hatà, tahon ho. Ohxe harha nehxakon hatà. Worokyamo yoh mehra harha nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Toy harha tà, Txesusu. Txeru màthoye toy hatà. Seknon horye toy hatà. Dekaporyes yamtar horye xarha toy hatà. Karyeryeya yohokos harha toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Àto nehxakon hatà, toto, àhanahnà ro. Àrwomra xarha nehxakon hatà. Noro rma yohtxownà hatà, toto komo, Txesusu hyaka. Ayamorà txeryko nyhe, moson hona, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Noro yarày hatà, Txesusu, toto komo hyaye. Tamorà yeryey hatà, àhanar yaka. Suu, tyufa, see, totakru xarha yeryey hatà, unyur horye. ");
INSERT INTO hixNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kakoso nosompotày hatà. Txee, kay hatà, àhnàn yawo rma haxa tesnàr ke. Ehfata, kekon hatà, noro wya. Atahurmakako katxho me rma naha, Ehfata katxho. ");
INSERT INTO hixNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Day, thanak harha nehxakon hatà. Unyuru xarha nàkrakrantay hatà. Towaxkemàtho nàkrakrantay hatà. Ohxe harha nàrwonakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Onà wyaro nkekon hatà, Txesusu, toto komo wya. On yokarymahra xaxa mpànà ehtxok ha, anar komo wya, kekon hatà, àwyanye. Nyamoro ryhe, nekarymatxownà haxa mak hatà. On yokarymahra xaxa mpànà ehtxok ha, kanye ro me rma haxa nehxakon hatà, Txesusu, toto komo wya, thenyehra hatà. Àro wyaro enytxanyenhàrà rma, nekarymetxkonà roro rma haxa mak hatà, thenyehra rma rha hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Noseryehokatxehkatxownà mak hatà, thenyehra rma haxa mak hatà, Txesusu wya onyhoryeno ytxoho hoko. Ohxe xaxa nay hamà, mokro. Ohxe rma haxa keryatxow hamà, ketxkon hatà. Àhanahnà rotho komo ryhe hanaryehe. Àrwomnà rotho komo xarha rwonàhyamehe, ketxkon hatà, toto komo, Txesus hoko. ");
INSERT INTO hixNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Àto nehxatxkon xarha tà, toto komo, ohsamnohxemo komo xarha, thenyehra rma haxa mak hatà. Ànyahpàra nehxatxkon hatà. Àro ke, tànhananàhrà ro komo yanyekye hatà, Txesusu, tàhyaka rma. Onà wyaro nkekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Thenyehra natxow hamà, toto komo, ohsamnohxemo komo, kekon hatà, àwyanye. 3 me nenmahyatxoko, tano, rohyawo. Ànyahpàra natxhe. Àro ke, àhnàn kom yawo rma haxa wehxaha, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ànyakheranye wehxan hamà, àmàn kom yaka, mox omohsah me esnàr kom ke. Àsok tawro hana. Tàtontokonye rma, namotohyatxow hamà, asama rakatawo rma, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ànyahrà komo ehxera ro mak nay hamà, tano, ahehnawo, ketxkon hatà, àwya. Àsok tànyahmetxow haryhe, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Twahak naye, ekeyu, ohyawonye, kekon hatà, Txesusu. 7 me naha, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Toto komo yeryewtanàhye hatà, yukryeka hona. Ekeyu yanàmye hatà. 7 me rma nanàmye hatà. Khoryenkom yakoro tàrwonàmàtxhe, nowye hatà. Nàmye hatà, tànhananàhrà ro komo wya. Ekamtxoko, kekon hatà, àwyanye. Nyamoro rma nekamtxownà hatà, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kana txko xarha, àhyawonye nehxakon hatà, yakenohnà rma hatà. Noro hoko xarha nàrwonàmye hatà, Txesusu, Khoryenkom yakoro. Tàrwonàmàtxhe rma, noro xarha yokampoy hatà, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nenahtàkatxownà hatà, toto komo. Wahuramtàhkatxownà hatà. Otàkràskatxhàràtho yonàmatxownà hatà, wetxe ymo yaka. 7 me rma nenàmatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Twahak hana nehxatxkon ha, àyakenon kom ha. 4000 me hana nehxatxkon ha. ");
INSERT INTO hixNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Taa. Nànyahtxownà hatà, Txesusu. Tàwya ànyaketxhenye rma, nosonkahye hatà, kanawa yaka. Ànhananàhrà ro komo xarha nosonkahtxownà hatà. Totxownà hatà, Dawmanuta yamtar hona. ");
INSERT INTO hixNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Txesusu hyaka nomohtxownà hatà, Farysew kukur komo. Noro yameryekatxownà hatà. Kahe yawon yahoxetà xenyhoko, amna wya, yaworo xaxa manay hamà katxho me, amna wya, ketxkonà rma haryhe tà, àwya. Noro yahoxetà kukmanàr xe rma nehxatxkon haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Noseryewsànkay hatà, Txesusu, yuhnaye ro, àhokonye toseryehokanàr ke. Txee, kay hatà, tàhnawo. Àsok tawro, kahe yawon yahoxetà yonyàr xe manatxowà, omnyamo, amnyeno rma komo, kekon hatà. Onà wyaro yaworo xaxa àkehe, owyanye. Xenyhera ro mak manatxhe hampànà, omnyamo, amnyeno rma komo, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nànomtxownà hatà, Txesusu. Nosonkahye xarha tà. Mon hona toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ekeyu yarhàra nehtxownà hatà, Txesusu nhananàhrà ro komo. Nàkwetarontatxownà hatà. Towenyxanotho txko nehxakon hatà, ekeyu, àhyawonye, kanawa yawo. Anaro nyhe txko ehxera nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Onà wyaro nkekon hatà, Txesusu, àwyanye. Katamaru wakan hona mpànà xenytxoko, kekon hatà. Farysew yanhàn komo rma hona mpànà xenytxoko. Eroknes yanhànà rma hona mpànà xenytxoko, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Àro wyaro tàwyanye enytxatxhe rma, nosonytxetxkon hatà, ànhananàhrà ro komo, nyamoro rye rma. Àsok tawro àro wyaro nkano, katamaru wakan hoko, ekeyu yokhàra kesnàr kom ke hamà, ketxkonà rma haryhe tà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Osonytxatxho komo hutwekon mak hatà, Txesusu. Àro ke, onà wyaro nkekon hatà, àwyanye. Àsok tawro àro wyaro mosonytxatxow harha, kekon hatà. Àsok tawro orwonatxow harha, uyuhra oyehtxoho kom hoko. Rorwon hutwahra rma manatxow hamà. Rahoxet yonyhera rma manatxow hamà, kekon hatà. Ohnawonye akàhpàra rma manatxow hamà. ");
INSERT INTO hixNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tonke rma manatxhe haryhe. Rahoxet yonyhera mak manatxhe, kekon hatà. Thanake rma manatxhe haryhe. Rorwon yonytxahra mak manatxhe, kekon hatà. Muhutwahkahyatxok hamà. ");
INSERT INTO hixNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Rahoxet yonyhohra kat wehxako, owyanye, ekeyu hoko. 5000 komo nyahmahra kat wehxako, 5 me ekeyu ke rma, kekon hatà. Twahak menàmetxoko, otàkràskatxhàràtho, kekon hatà. 12 me amna nenàmeko, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","4000 komo xarha nyahmahra kat wehxako, 7 me ekeyu ke rma, kekon hatà, Txesusu. Twahak menàmetxoko, otàkràskatxhàràtho, kekon hatà. 7 me amna nenàmeko, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Àro wyaro owyanye rahoxet yonyetxhàrà muhutwahkahyatxok hamà, kekon hatà. Àro hoye ro moseryehoketxow hamà, uyuhra oyehtxoho kom hoko. Rorwon hutwahra rma manatxow hamà, Farysew yanhàn kom hoko, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betsayda hona nahatakatxownà hatà, Txesus komo. Àto nehxakon hatà, toto, enhunu ro. Noro rma yohtxownà hatà, toto komo, Txesusu hyaka. Moson aheko nyhe, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Enhunu ro yarày hatà, Txesusu. Amor hoko narày hatà, owto hoye. Tyufa, netahtay hatà, enur horye. Dye, tamorà yeryey hatà, àhona. Àsok menyano, kekon hatà, àwya. Àsok menyano. Xenyhera rma kat manaye, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nosompotày hatà, enhunu ro. Krawame wenyan hamà, kekon hatà. Toto komo rma wenyatxhe haryhe. Tataryeknohsom komo rma wenyatxhe haryhe. Wewe wyaro mak wenyatxhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dye, tamorà yeryey xarha tà, Txesusu, enur hona. Ohxe haxa nentatàhkay hatà, enhunu rotho. Ohxe harha nehxakon hatà, enuru. Mox xarha nosompohtyakon hatà, omeroro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nànyakye hatà, Txesusu. Àmàn yaka harha nànyakye hatà. Àtok ha, omàn yaka, kekon hatà. Owto hona àtohra exko hampànà, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Toy hatà, Txesusu. Akoro totxownà hatà, ànhananàhrà ro komo. Sesaryeya Feryepe yamtar horye rma tetxkon hatà, anaro rha owto hona. Asama yarye tàtontokonye rma, onà wyaro nkekon hatà, Txesusu, tànhananàhrà ro komo wya. Onok me ryhe wehxano, toto komo wya, kekon hatà, àwyanye. Onok me rotakyatxowà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Onà wyaro nketxhe, anar komo, ketxkon hatà. Xowaw heno we mokro ha, aymomno ynye ro heno we mokro ha, ketxhe haryhe, ohoko, anar komo, ketxkon hatà. Eryeyas heno haxa we mokro ha, ketxhe, anar komo xarha. Khoryenkomo rwonà yokarymanye ro heno komo kukur haxa we mokro ha, ketxhe, anar komo xarha. Àro wyaro nketxhe, toto komo, ohoko, ketxkon hatà, ànhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Omnyam haxa, onok me ryhe uro metakyatxowà, kekon hatà, Txesusu, àwyanye. Petru ryhe neyukye hatà. Kryestu ryhe omoro, amna wya, kekon hatà. Khoryenkomo nànyaketxho ryhe omoro, amna wya, kekon hatà, Petru, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kryestu me rokarymahra xaxa mpànà ehtxok ha, toto komo wya, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Twayehtoho yokarymay harha tà, Txesusu, tànhananàhrà ro komo wya. Thenyehra rma haxa teryewhamnohsom me naha hampànà, Toto me Enusaho, kekon hatà, àwyanye. Noro xanomkahnohyatxhe hampànà, horykomo komo, Khoryenkom màn yonye ro yoh komo xarha, àyweronàhyamano ynye ro komo xarha, kekon hatà. Yahkotohen hona namoyathohetxhe xarha hampànà. Twayhàtxhe nasanàmyaha harha hampànà, Toto me Enusaho. Osorwawo ro enmahàtxhe, nasanàmyaha harha hampànà, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Àro wyaro noskarymay hatà, nyamoro nenytxanàr me. Àro ke, meya nyhe txko narày hatà, Petru. Àro wyaro kahra exko, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sara, neramay hatà, Txesusu. Tànhananàhrà ro komo yonyey hatà. Petru yoyey hatà. Khoryenkomo yehutwatxho hoye rohra àro wyaro màkano, kekon hatà, àwya. Toto yehutwatxho hoye ro haxa ryhe àro wyaro màkano. Satanasà ymo yano me ryhe àro wyaro màkano. Àro ke, onà wyaro àkehe, noro ymo wya. Satanasà y, àtok ha, rohyaye, àkehe, àwya, kekon hatà, Txesusu, Petru wya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Thenyehra rma haxa nehxatxkon hatà, toto komo, ohsamnohxemo komo. Àto rma nehxatxkon xarha tà, Txesusu nhananàhrà ro komo. Omeroro nanyehtxekatxownà hatà, Txesusu, tàhyaka. Onà wyaro nkekon hatà, àwyanye. Rakoro otonàr komo xe oyehtokonye, onà wyaro ehtxok hampànà, kekon hatà. Osoxanomkahnohtxok hampànà. Oyeryewhamnohtoho komo enàmtxok hampànà. Àro wyaro enàmnye rma, rakoro àtotxok hampànà, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Anatoko oyeryewhamnohrà komo xehra manatxow hana, toto komo wya, kekon xarha tà, àwyanye. Àro ke, oyekrunhonàr xe manatxow hana, awayehrà kom hona. Oyekrunhonàr xano rma, awayehyatxhe xak mak hampànà, kekon hatà. Àsok haxa hana manatxow ha. Mosoxanomkahnohyatxow haxa hana, twayehso ro, rox oyesnàr kom ke mak ha, àrwo yonyhorunu yokarymanàr xe oyesnàr kom ke mak ha, kekon hatà. Àro wyaro tosoxanomkahnohsomà rma, mekrunhetxhe harha. Karyhe roro harha manatxhe ha, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Àsok haxa hana manatxow ha, kekon xarha tà, àwyanye. Tkatxhonke rma haxa manatxow hana. Ohyawonye rma nay hana, anaro rha katxhonano, omeroro, kekon hatà. Àro wyaro thenyehra tkatxhonkemà rma, ohxehra rma manatxhe ha. Karyhe roro harha manatxhe katxho mehra rma oyehtokonye, ohxehra rma manatxhe ha. Tanàhnohsom me xak mak manatxhe hampànà, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Karyhe roro harha oyehtxoho komo rma, onàhnàn kom me nay hamà. Anaro onàhnàn komo ehxera ro mak naha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Atxke rma haxa natxhe, toto komo, amnyeno rma komo, kekon xarha tà. Thetxenhàrà hyaye toto yotowrà wyaro, Khoryenkomo hyaye otowsah me natxhe, amnyeno rma komo. Anatoko nyamoro hona moseryehyatxow hana, kekon hatà. Txesusu mryenonà uro ha kahra manatxow hana, oyoseryehrà kom ke. Txesusu rwon yawo ron uro kahra manatxow hana, oyoseryehrà kom ke mak ha, kekon hatà. Àro wyaro oyehtokonye, romryenonà mosonà kahra rma rha naha hampànà, Toto me Enusaho, ohokonye, kekon hatà. Amnye nomokyaha hampànà, noro ha. Tàyàmà wyaro ehonomnà me xaxa nosonyhehe hampànà. Akoro nomokyatxhe hampànà, kahe yawon komo xarha, enyhoru ro komo rma. Àro wyaro tomokàtxhe rma, romryenonà mosonà, kahra ro mak naha hampànà, oskarymahnàtho kom hoko, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Onà wyaro nkekon xarha tà, Txesusu, toto komo wya. Toto komo kayaryet me nosonyhehe xaxa mak hampànà, Khoryenkomo, kekon hatà. Ehonomnà me xaxa mpànà nosonyhehe ha. Onà wyaro yaworo xaxa mpànà àkehe ha, owyanye. Àro wyaro noro yosonyhohra ro rma haka, awayehyatxhe hampànà, omnyamo, kekon hatà. Okukur kom marma ryhe, àwayehpàra rma hak natxhe hampànà. Nyamoro rma, toto komo kayaryet me noro yehtxoho yonyatxhe hampànà, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Taa. 6 me enmahàtxhe, toy hatà, Txesusu. Petru yarày hatà, takoro. Txaku xarha yarày hatà. Xowaw xarha yarày hatà. Nyamoro marma yarày hatà. Àhà ymo hona natxownà hatà, kawono ymo hona. Àto rye nehxatxkon hatà, nyamoro rye mak hatà. Anar me tonyxem me harha nexey hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Àwomunu ryhe, tàkrokromuknye harha nehxakon hatà. Nenkahxatxkon hatà. Àro wyaro umuturyehra ro mak natxow hamà, toto komo, wom muturyenye ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Àtoko rma nosonyhotxownà hatà, asakon komo, Eryeyas heno rma hatà, Moyses heno xarha hatà. Nosonyhotxownà hatà, àwyanye. Nàrwonatxkon hatà, Txesus yakoro. ");
INSERT INTO hixNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Onà wyaro nkekon hatà, Petru, Txesusu wya. Khananàhnye y, tan kehtxoho komo ohxe nay hamà, kekon hatà. Wato hak amna nexe, osorwawo, omàn komo, Moyses màn xarha, Eryeyas màn xarha, kekon hatà, Petru, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Àsok kat àkeno, àwya, kekon hatà, tàwya rma. Thenyehra noseryehyatxkon hatà, Petru komo. ");
INSERT INTO hixNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ehokosonye nomokye hatà, kahrutunu. Àro wawono rwonà yonytxatxownà hatà. Romuru mosonà kay hatà. Ronàhnàn xaxa mosonà. Noro enytxatxoko, kay hatà, kahrutun wawono. ");
INSERT INTO hixNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dàk dà nkatxownà hatà, Petru komo. Àhorye ronye nenytxehkatxownà hatà. Txesus marma yonyatxkon hatà, tàhyawonye. Anar komo ehxera harha nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Àhà ymo yonàhtotxownà harha tà, Txesus komo. Enàhtonàr me rma, onà wyaro nkekon hatà, Txesusu, Petru komo wya. Onenyetxhàyamo yokarymahra xaxa mpànà ehtxok ha, toto komo wya, kekon hatà. Amnye haxa mekarymetxhe ha, àwayehxemo kom waye rasanàmàtxhe mak ha, Toto me Enusaho yasanàmàtxhe mak ha. Rasanàmpàra ro rma haka, ekarymahra rma ehtxok hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Àro ke neyuhtxownà hatà, Petru komo. Anar komo wya ekarymahra haka nehxatxkon hatà. Àwayehxemo kom waye katxho hutwahra mak nehxatxkon hatà. Àro ke, onà wyaro nketxkon hatà, tàwyanye rma. Àsok mokà nkan harha, ketxkon hatà. Àwayehxemo kom waye rasanàmàtxhe katxho, àsok mokà nkan ha, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Onà wyaro nketxkon hatà, Txesusu wya. Onà wyaro nketxhe, àyweronàhyamano ynye ro komo, ketxkon hatà. Kryestu yomokhàra ro rma haka, nomokyan hatà, Eryeyas heno, ketxhe. Àsok tawro àro wyaro nketxowà, ketxkon hatà, Petru komo. ");
INSERT INTO hixNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Yaworo nketxhe, kekon hatà, Txesusu, àwyanye. Eryeyas heno wyarono htxero tomohsom me nehxakonà. Onyhoryetxehkano yxe tomohsom me nehxakonà, kekon hatà. Onà wyaro haxa àkehe, owyanye. Omohsah me rma naha, noro ha, kekon hatà. Noro heno mak yeryewhamnohtxownà, àxanhàn komo, tano me ronye rma. Àro wyaro teryewhamnohsom me rma haxa nehxakonà, àmenhosahonhàrà yawo ro rma haxa tehtxoho me, kekon hatà, Txesusu. Toto me Enusah xarha, àmenhosahonhàrà yawo ro rma rha naha hampànà, onà wyaro katxhàrànhàrà yawo ro mak ha, teryewhamnohsom me rma haxa naha hampànà katxhàrànhàrà yawo ro, tàxanomkahnohsom me rma haxa naha hampànà katxhàrànhàrà yawo ro rma, kekon hatà, Txesusu, Petru komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nomohtxownà harha tà, Txesus komo, tànhananàhrà ro komo hyaka harha. Nyamoro hyawo nehxatxkon hatà, toto komo, ohsamnohxemo komo, thenyenohnà kom hatà. Àyweronàhyamano ynye ro kukur komo xarha, àto nehxatxkon hatà. Nyamoro rma nosonytxetxkon hatà, Txesusu nhananàhrà ro kom yakoro. ");
INSERT INTO hixNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Txesusu yonytxownà hatà, toto komo, ohsamnohxemo komo. Tàwyanye xenyetoko, noseryehokatxehketxkon hatà, thenyehra rma haxa mak hatà. Karyhe totxownà hatà, àhyaka. Netakmetxownà hatà. Momokno ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Eten kom hoko mosonytxetxowà, moxam yakoro, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Neyukye hatà, toto, ohsamnohxemo kom wawono. Khananàhnye y, kekon hatà. Romuru wekno rma haryhe, ohyaka. Worokyamo yoh me naha. Noro ymo yano me àrwomnà ro me naha, kekon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Henta xak na mokro nay ha. Àto rma nahohsaha, worokyamo. Tàwya ahosàtxhe, narymehe, yukryeka hona, kekon hatà. Wakrontehe. Nàyohsàkyaha xarha. Nakàhyaha xarha, kekon hatà. Àro ke wekno rma haryhe, ohyaka. Kàrwonàmno rma haryhe, moxam yakoro, onhananàhrà ro kom yakoro. Noro ymo towtxoko, romurunho txko hyaye, àkano rma haryhe, àwyanye, kekon hatà. Townyehnà ro mak moxam hamà, kekon hatà, àyàmà. ");
INSERT INTO hixNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Onà wyaro haxa nkekon hatà, Txesusu. Àsok hana manatxow ha, omnyam ha, amnyeno rma komo, kekon hatà. Khoryenkom hona xenyehnà omnyam hamà. Mexe rma haxa ehxah me wehxaha, awawonye. Khoryenkom yahoxetà hutwahra rma manatxhe, kekon hatà. Mexe rma rha kramamyan hamà, awawonye rma. Khoryenkom yahoxetà hutwahra rma oyehtxoho komo wenàmyano rye rma hamà, tano, kekon hatà, Txesusu. Sohtxok ha, rohyaka, kekon xarha tà. ");
INSERT INTO hixNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Àro ke bàryekomo yohtxownà hatà, àhyaka. Tàwya Txesusu yonyetxhe rma, nànyerymamnohye hatà, worokyamo ymo. Fuhto, nehurkay hatà, bàryekomo, yukryeka hona. Nehanamekon hatà. Wakrontekon xarha tà. ");
INSERT INTO hixNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Twahak nahosàye, worokyamo, kekon hatà, Txesusu, àyàmà wya. Twahak nahosàye. Àmryentoko rma nahosàye, kekon hatà, àyàmà. ");
INSERT INTO hixNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Yake ro narymaye, weheto waka. Tuna kwaka xarha narymaye. Àro wyaro yake ro narymaye, àwayehkanàr horà, kekon hatà, àyàmà. Amna hnàn yaw exko nyhe, kekon hatà. Àsok hana manay ha, omoro, ehonomnà me hana, ehonomnà mehra haxa hana. Ehonomnà me oyehtoko, amna akoronomako nyhe, kekon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Àro wyaro tkahoryehra naha, kekon hatà, Txesusu, àwya. Àsok hana manay ha, ehonomnà me hana, ehonomnà mehra haxa hana, tkahoryehra ro mak naha ha. Ehonomnà me xaxa mpànà naha ha, Khoryenkomo, tkahorye haxa naha, kekon hatà. Àro wyaro Khoryenkom hona owya xenyetoko, towakryetxehkaxem me mpànà manaha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Noro hona wenyaha rma haryhe, kekon hatà, àyàmà, teryewrye ro hatà. Noro hona wenyaha rma haryhe, atxke txko mak ha. Uro akoronomako nyhe, àhona xeny me nyhe ryehtxoho me, kekon hatà, àyàmà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Txesusu hyaka nomohtàketxkon hatà, toto komo. Karyhe rma haxa nomohtàketxkon hatà, thenyenohnà kom hatà. Àro wyaro nenytxownà hatà, Txesusu. Àro ke, worokyamo yoyey hatà. Worokyamo y, kekon hatà, àwya. Àrwonàmnà ro me mosonà meryey hamà. Àhanahnà ro me meryey hamà. Onà wyaro àkehe hampànà, owya, kekon hatà. Otowko hampànà, àhyaye. Ahohsàra harha exko hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Teryewrye ro kowontay hatà, worokyamo. Thenyehra nànyerymamnohye xarha tà. Kray, notowye hatà, àhyaye. Àwayehsaho wyaro nehxakon hatà, bàryekomo. Àro ke, wayehno ha ketxkon hatà, àton kukur komo, yaken komo rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tok, amor hoko nanàmye hatà, Txesusu. Sax, nasanàmye hatà, bàryekomo. ");
INSERT INTO hixNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Taa. Bàn kom yaka harha totxownà hatà, Txesus komo. Towomàtxhenye, onà wyaro nketxkon hatà, ànhananàhrà ro komo, Txesusu wya, anar komo nenytxahtor me mak hatà. Àsok tawro towhàra amna nahko harha, ketxkon hatà, àwya. Àsok tawro towhàra amna nahko harha. ");
INSERT INTO hixNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Neyuhtxownà hatà, Txesusu. Noro wyaron komo ryhe, towhànà ro me natxhe, kekon hatà, àwyanye. Khoryenkom yakoro kàrwonàmtoho kom hoye ro marma, towsom me natxhe, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Taa. Àsnye ro totxownà hatà, Txesus komo. Karyeryeya yamtar horye totxownà hatà. Ekayhera rma tàtonàr xe nehxakon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Àsok tawro hana, 12 komo hananàhrà hoko rma haxa tesnàr ke hatà. Onà wyaro nkekon hatà, àwyanye. Tahohsosom me naha hampànà, Toto me Enusaho, toto komo wya, anhà komo wya, kekon hatà, àwyanye. Nyamoro rma namoyathohetxhe hampànà, yahkotohen hona. Twayhàtxhe, nasanàmyaha harha hampànà. Osorwawo ro enmahàtxhe, nasanàmyaha harha hampànà, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Àro wyaro katxho hutwahra mak nehxatxkon hatà, ànhananàhrà ro komo. Uhutwamohsoko, amna wya, kahra mak nehxatxkon hatà, àwya, kurunye tàwyanye xenyàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Taa. Kafahnaw hona nahatakatxownà hatà, Txesus komo. Bàn kom yawo tehtokonye, onà wyaro nkekon hatà, Txesusu, 12 komo wya. Eten kom hoko mosonytxatxowà, omnyamo ro rye rma, asama yarye komoknàr kom me, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Eyukhura mak nehxatxkon hatà. Àsok tawro hana, tatameryekanàr kom ke hatà. Asama yarye tàtontokonye, natameryeketxkon hatà, nyamoro rye rma. Onokà ryhe, ehonomnà me nyhe naye, kwawonye, tawro hoko natameryeketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Dyerye, neryewtay hatà, Txesusu. Omohtxoko, kekon hatà, àwyanye. Omohtxoko, ronytxaxe. Ehonomnà me oyesnàr komo xe oyehtokonye, norohnàtho me xaxa mpànà ehtxoko. Okukur komo yanoto me xaxa mpànà ehtxoko, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bàryekomo txko yokye hatà, amrakatakanye. Nanàmye hatà, tonaka. Onà wyaro nkekon hatà, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Mosonà txko xenytxoko, kekon hatà, àwyanye. Toto komo yosnaka rma haxa nay hamà, mosonà txko. Mosonà wyarono txko komo ewakryetxoko, kekon hatà. Rox oyehtokonye, ewakryetxoko. Owyanye ewakryentokonye rma, uro rma mewakryetxhe, kekon hatà. Àro wyaro owyanye rowakryentoko rma, urohnà rma, ronyaknyenhàr haxa mewakryetxhe, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Khananàhnye y, kekon hatà, Xowawu, Txesusu wya. Toto amna nenyako. Worokyamo yowyaknano, noro ha, ayano me rma haryhe, kekon hatà. Txesus yano me otowko ha, keknano rma haryhe, worokyamo wya. Àro ke, àro wyaro kahra exko, kek amna, àwya. Amna natàknanàhkeko, kukukur kom mehra esnàr ke, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Atàknanàhkahra ehtxoko, kekon mak hatà, Txesusu. Àsok tawro hana. Àro wyaron komo ryhe, atxke naha Txesusu, kahra natxow hamà. Onyhoryeno ytxoho hoko, Txesus yano me ryhe konyhoryen hampànà kany komo rma, rowàràhyakahra natxow hamà, kekon hatà, Txesusu. Àro ke, atàknanàhkahranye ehtxoko. ");
INSERT INTO hixNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Àsok tawro hana. Kxanhàn kom mehra tehtokonye, kukukur kom me rma natxow hamà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Onà wyaro nkekon xarha tà, àwyanye. Anatoko ayakoronometxow hana, anar komo, romryenon me oyesnàr kom ke mak ha, Kryestu mryenonà mosonà katxho me oyesnàr kom ke mak ha, kekon hatà. Tuna marma txko yàmyatxow hana, owokru kom me. Tuna yàmnyenhàrà rma, towakryexem me rma haxa natxhe hampànà, tàwyanye romryenon komo yakoronomanàr ke mak ha. Àro wyaro yaworo xaxa àkehe, owyanye, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Onà wyaro nkekon xarha tà, Txesusu, tànhananàhrà ro komo wya. Tanhàn hokon me harha bàryekomo yeryhera ro mak ehtxok hampànà, kekon hatà. Rohona xenyetho komo rma yeryhera ehtxok hampànà, tanhàn hokon me harha. Àro hokon me harha owyanye txenyetokonye, ohxehra ro mak manatxhe hampànà, kekon hatà. Àro wyaro txeryhera ronye rma awayehnàtokonye, ohxe oyesnàràtho kom haryhe. Tuna kwaka ononàtokonye, ohxe oyesnàràtho kom haryhe. Tohu ymo ke amusmexah me ononàtokonye, àro wyaro rma awayehnàtokonye, ohxe oyesnàràtho kom haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Anatoko ayanhàn kom hoko manatxow hana, ayamor kom ke hana, kekon xarha tà. Onà wyaro haxa katxoko. Amohra hak wehxe, ranhàn hokohra harha ryehtxoho me, katxoko, kekon hatà. Tamoke rma oyehtokonye, eryewhamnohno ytxoho ro na màtetxhe hampànà, ayanhàn kom hoko oyesnàr kom ke. Weheto ymo wyaron hona màtetxhe hampànà, ewehpànà ro ymo wyaron hona, kekon hatà. Amohra haxa oyehtokonye, ohxe rma manatxhe, karyhe roro harha oyesnàr kom ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Anatoko ayanhàn kom hoko manatxow hana, ohror kom ke hana, kekon xarha tà. Onà wyaro haxa katxoko. Àhrohra hak wehxe, ranhàn hokohra harha ryehtxoho me, katxoko, kekon hatà. Tàhroke rma oyehtokonye, eryewhamnohno ytxoho ro na màtetxhe hampànà, ayanhàn kom hoko oyesnàr kom ke. Àhrohra haxa oyehtokonye, ohxe rma manatxhe, karyhe roro harha oyesnàr kom ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Àsok haxa hana mehohketxow ha, ayanhàn kom hoko. Mehohketxow hamà, oyonur kom ke mak ha, kekon hatà. Onà wyaro haxa katxoko. Enhura hak wehxe, ranhàn hoko ehohkahra harha ryehtxoho me, katxoko, kekon hatà. Enhura oyehtokonye, ohxe rma manatxhe, Khoryenkom yowto hona otonàr kom ke. Tonke haxa oyehtokonye, tarymaxem me manatxhe hampànà, eryewhamnohno ytxoho ro na, oyonur kom ke atxke oyesnàr kom ke, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Eryewhamnohno ytxoho ro ryhe, weheto ymo wyaro naha, ewehpànà ro ymo wyaro mak ha. Àton komo ryhe, àwayehpàra natxhe hampànà. Àwayehpànà rma, teryewhamnohso roro rma haxa natxhe hampànà, meya roro rma haxa mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Xura ryhe, woto yonyhoryeny me nay hamà, kekon xarha tà. Weheto ryhe, uru yonyhoryeny me nay hamà. Weheto waka txexaho wyaro, tonyhoryexem me natxhe hampànà, romryenon komo, omeroro, teryewhamnohtoho komo yonàmrà ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ohxe nay hamà, xura. Anatoko nanhànten hana. Tanhàntatxhe rma, ohxehra ro mak nay hamà. Xura me harha txeryhen me nay hamà, kekon hatà. Xura kenye woto yexaho wyaro, ohxe ehtxoko, ohnawonye. Àro wyaro oyehtokonye, towahke rye manatxow hamà, omnyamo ro rye rma, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Taa. Karyeryeya yamtar hoye toy hatà, Txesusu. Xukneya yamtar hona haxa toy hatà, Xoknaw mon hona rma hatà. Àhyaka nohsamnohtàkatxownà hatà, toto komo, thenyenohnà kom hatà. Àto xarha hananàhyatxkon hatà, Txesusu, hananàhno ynye ro kaxe. ");
INSERT INTO hixNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farysew kukur komo xarha nomohtxownà hatà, àhyaka. Noro kukmanàr xe nehxatxkon haryhe tà, enkukmanàr horà. Onà wyaro nketxkonà rma haryhe tà. Khetxenhàrà hyaye kotowtoho, ohxe naye, ohxehra kat naye, owya, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Neyuhtxownà hatà, Txesusu. Àsoke nkaye, Moyses heno, kekon hatà. Àsoke ryhe kàyweronàhyamatxownà, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Onà wyaro kàyweronàhyamatxownà hatà, Moyses heno, ketxkon hatà, Farysew komo. Ohetxenhàyamo hyaye oyotownàtokonye, akaryehtan komo àmenhotxoko, kekon heno hatà. Kotowyaha hampànà, ohyaye, katxoko, owyanye àmenhonàr me, kekon heno hatà, ketxkon hatà, Farysew komo. Àro wyaro owyanye àmenhotxhe rma, motowyatxhe, ohetxenhàyamo hyaye, kekon heno hatà. Àro wyaro kàyweronàhyamatxownà hatà, Moyses heno, ketxkon hatà, Farysew komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Àro wyaro kàyweronàhyamatxownà, ohnawonye atxke rma haxa oyesnàr kom ke, ohetxenhàyamo hyaye oyotowrà komo xe rma haxa oyesnàr kom ke, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amnyehra haxa, toto yotowrà xehra mak nehxakonà, Khoryenkomo, thetxe hyaye. Àsok tawro hana. Tàwya toto yakàhtontoko, kàrà me, wos me xarha nakàhtoye, otàhyawo roro ehtxoho menye, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Àro ke, toto hak tàyàmànhàrà hnànkano. Noro hak tàyonànhàrà hnànkano, thetxe hyawo roro harha tehtxoho me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Àro wyaro mpànà naha ha, toto, wos yakoro. Asakononhàyamo, towenyxano wyaro harha mpànà naha ha, kekon hatà. Àro wyaro natxow hamà, toto komo, thetx kom yakoro. Asako ehxera harha natxhe, Khoryenkomo nenyàr me. Towenyxano wyaro harha natxhe, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Khoryenkomo ryhe, osomryeno ynye me naha. Àro ke, onà wyaro kahra hak nahtxoko, toto komo. Totowyatxow hamà, khetxenhàyamo hyaye, kahra hak nahtxoko, osomryeno ynye me Khoryenkomo yesnàr ke, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bàn kom yaw harha tehtokonye, onà wyaro nketxkon hatà, ànhananàhrà ro komo, Txesusu wya. Àsok màkan harha, kotowtoho kom hoko, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Onà wyaro nkekon hatà, Txesusu, àwyanye. Ohetx komo hyaye otowhàra ro mak ehtxoko, kekon hatà. Àhyayenye oyotownàtokonye rma, anaro wos yahohsàra ro mak ehtxoko. Owyanye anaro yahosnàtoko rma, atxke manatxhe, ohetxe ro kom mehra noro yesnàr ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Àro wyaro rma rha natxhe, woràskomo komo xarha. Tànyonhàrà hyaye otowsahotho rma, anaro kàrà yahohsàra hak nahtxoko, kekon hatà. Tàwyanye anaro yahosnàtoko rma, atxke natxhe, tànyo ro kom mehra noro yesnàr ke mak ha, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Thokyamo txko yokyatxkon hatà, toto komo, Txesusu hyaka. Mosonà txko aheko tawro xe nehxatxkon hatà, àwya, ohxe texem me esnàr kom horà. Horohkatxownà mak hatà, Txesusu nhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nyamoro wya àhorohkanàr komo yonyey hatà, Txesusu. Atxke nehxakon hatà, àwya. Ewakhàra nehxakon hatà. Àro ke, onà wyaro nkekon hatà, àwyanye. Bàryekomo txko kom hak nomohtxowà, rohyaka, kekon hatà, tànhananàhrà ro komo wya. Àhorohkahranye ehtxoko. Moxamo txko wyaron komo ryhe, Khoryenkomo mryenon me natxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Onà wyaro yaworo xaxa àkehe, owyanye, kekon hatà. Akayaryet kom me Khoryenkomo yesnàr xe oyehtokonye, bàryekomo wyaro norohnàtho me xaxa mpànà osonytxoko, kekon hatà. Àro wyarohra oyehtokonye, noro mryenon mehra ro mak manatxhe hampànà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bàryekomo komo yanàmyakon hatà, Txesusu, tonaka. Say, tok, tamorà yeryakon hatà, àhonanye. Khoryenkom yakoro nàrwonakon hatà, àhokonye. ");
INSERT INTO hixNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Taa. Asama yarye tekon hatà, Txesusu. Àtonàr me, àhyaka toy hatà, toto, karyhe mak hatà. Tosoknar ho neryewtay hatà, akrataka. Khananàhnye y, enyhoru ryhe omoro, kekon hatà, àwya. Àsoke ryhe ohxe wehxano, karyhe roro harha ryehtxoho me, kekon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Àsok tawro enyhoru ryhe omoro màken harha, rowya, kekon hatà, Txesusu, àwya. Khoryenkomo ryhe, enyhoru me naha, noro marma mak ha. Enyhoru mehra ro mak natxhe ha, toto komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Karyhe roro harha oyesnàr xe oyehtoko, kàyweronàhyamatxho kom yawo ro tehxorye manaha, kekon hatà, Txesusu. Onà wyaro katxho komo hutwahra kat manaye, toto yotahahra ehtxoko katxho rma, anar komo hetx hokohra ehtxoko katxho xarha, toto katxho yarhàra ehtxoko katxho xarha, toto hoko àtemarontahra ehtxoko katxho xarha, amotaka ehemahra ehtxoko katxho xarha, toyuhsom me xenytxoko, oyàm komo, oyon komo xarha, katxho xarha. Àro wyaro katxho kom yawo ro tehxorye manaha, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Khananàhnye y, kekon hatà, noro, Txesusu wya. Àro wyaro katxho kom yawo ron uro. Romryen yaye ro rma, àro wyaro katxho kom yawo ro ehxah uro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Thànye rma haxa nenyakon hatà, Txesusu. Onà wyaro nkekon hatà, àwya. Khoryenkomo yoyuhtukahra hak manaha, kekon hatà. Onà wyaro xaxa mpànà exko ha, noro yoyuhtukatxho me. Akatxhothàrà tàmtaha, omeroro, txenyeru hona, kekon hatà. Txenyeru rma tàmko xarha, toto komo wya, àkatxhomnà komo wya, ànyahpàn komo wya. Àro wyaro exko hampànà, kahe yawo towakryexem me oyehtxoho me, kekon hatà. Àro wyaro oyexetxhe rma, rakoro omok ha, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Àro wyaro tàwya enytxatxhe rma, nekhokay hatà, tkatxhonke rma haxa tesnàr ke hatà. Ekhokaxaho rma toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Noro totxhe rma, àhorye ronye nenytxehkatxownà hatà, Txesusu. Onà wyaro nkekon hatà, tànhananàhrà ro komo wya. Tkayaryet kom me Khoryenkomo hutwahra natxow hamà, tkatxhonkem komo, kekon hatà. Krawame mak natxhe, noro mryenon me harha, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Koo, noseryehoketxkon hatà, nyamoro, Txesusu rwon hoko. Kàrkomo komo y, kekon xarha tà, Txesusu, àwyanye. Tkatxho hona ron komo ryhe, krawame rma haxa natxhe, Khoryenkomo mryenon me harha, kekon hatà, ");
INSERT INTO hixNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Arkurya yowtarà txko yarye àtohra nay hamà, kameru ymo. Krawame rma haxa nay hamà, àtotho, hory me ymo esnàr ke, kekon hatà. Àro yarye noro totho yoho rma haxa krawame natxhe, tkatxhonkem komo, Khoryenkomo mryenon me harha, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Koo, noseryehokatxehketxkonà rma haxa mak hatà, nyamoro, thenyehra rma haxa mak hatà. Àsok tawro harha, ketxkon hatà. Tonyhoryexem komo ehxera natxow hamà. Àsoken kom katà tonyhoryexem me natxowà, ketxkon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nenytxehkatxownà hatà, Txesusu, Onà wyaro nkekon hatà, àwyanye. Tonyhoryetxho kom hoko tehnyaxem me natxhe ha, toto komo, kekon hatà. Khoryenkom haxa ryhe, ehnyahnà ro me mak naha. Ehonomnà xaxa kax mak naha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Onà wyaro nkekon hatà, Petru, àwya. Amna ryhe, amna yomyawonotho nànomye, ayakoro amna totho me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Neyukye hatà, Txesusu. Àsok hana natxow ha, romryenon kom ha, kekon hatà. Onà wyaro natxow hamà, rox tesnàr kom ke mak ha, àrwo yonyhorunu yokarymanàr xe tesnàr kom ke mak ha. Anatoko bànàthàyamo nomyatxow hana, kekon hatà. Anatoko towtànhàyamo nomyatxow hana. Anatoko twosànànhàyamo nomyatxow hana. Anatoko tàyàmànhàyamo nomyatxow hana, kekon hatà. Anatoko tàyonànhàyamo nomyatxow hana. Anatoko thokuthuyamo nomyatxow hana, kekon hatà. Anatoko towtothàyamo nomyatxow hana. Omeroro rma nànomyatxow hana, romryenon komo, rox tesnàr kom ke mak ha, rokarymanàr xe tesnàr kom ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Onà wyaro yaworo xaxa àkehe, owyanye. Nyamoro ryhe, towakryexem me rma haxa mpànà natxhe ha, kekon hatà. Amnye rma, tano rma hak tehtokonye, thenyehra towakryexem me mpànà natxhe ha, bànkem me rma haxa mak ha, towtànkem me rma haxa mak ha, twosànkem me rma haxa mak ha, tàyonkem me rma haxa mak ha, thohkem me rma haxa mak ha, towtokem me rma haxa mak ha, kekon hatà. Àro wyaro towakryexem me mpànà natxhe ha, amnye rma. Àro wyaro towakryexemà rma, teryewhamnohsom me rma natxhe hampànà, tano rma hak tehtokonye. Amnye haxa, karyhe roro mpànà natxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Àsok tawro hana, kekon xarha tà. Anar komo yosnakan uro kany komo ryhe, wahoro htxero towakryexem me natxhe hampànà. Anaro komo yohon uro kany kom haxa ryhe, mahtuk me towakryexem me natxhe hampànà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Asama yarye tetxkon hatà, Txesus komo. Xerusaryen hona tetxkon hatà. Wahoro tekon hatà, Txesusu. Noro yakoron komo ryhe, noseryehoketxkon hatà. Àwenaryenye totxownà hatà, toto komo. Nyamoro rma newankaranatxkon hatà. 12 komo yanyekye hatà, Txesusu, tàhyaka. Noskarymay hatà, àwyanye. Amnye tehtxoho rma yokarymay hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Xerusaryen hona tàtetxow hamà, kekon hatà. Tahohsosom me mpànà naha ha, Toto me Enusaho, Xuknewyana yoh komo wya, Khoryenkom màn yonye ro yoh komo wya, àyweronàhyamano ynye ro komo wya xarha. Nyamoro ryhe, twayehkahorye xak naha, ketxhe hampànà, noro hoko, kekon hatà. Nahohsetxhe xarha hampànà, Xuknewyanahnà komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nyamoro rma newnohyatxhe hampànà, kekon hatà. Noro horye netahtetxhe xarha hampànà. Nàhpokyatxhe xarha hampànà. Yahkotohen hona namoyathetxhe xarha hampànà, kekon hatà. Twayhàtxhe, nasanàmyaha mak hampànà, noro ha. Osorwawo ro enmahàtxhe, nasanàmyaha harha hampànà, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Txesusu hyaka haxa totxownà hatà, Txaku komo, Xowaw xarha. Sekmeknew muru komo rma nyamoro hatà. Khananàhnye y, ketxkon hatà, àwya. Amna ryhe yowakryenàr xe amna naha, owya, ketxkon hatà. Amna yano me ryhe, amna yowakryenàr xe amna naha, owya, ketxkon hatà, Txaku komo. ");
INSERT INTO hixNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Àsoke ryhe oyowakryenàr komo xe manatxowà, rowya, kekon hatà, Txesusu, àwyanye. Àsoke ryhe oyowakryenàr komo xe manatxowà, rowya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Onà wyaro nketxkon hatà, àwya. Ehonomnà me rma haxa amna yenyàr xe amna naha, owya, ketxkon hatà. Toto komo kayaryet me oyomoknàtoko, ehonomnà me xaxa mosonyhen hamà, omeroron komo wya. Àtoko rma, ahanaka haxa amna txeryko, anaro howehehra, anaro howehe, owyaro rma rha ehonomnà me amna yehtxoho me, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Àna matà, rohanawo toto yehtxoho hutwahra ro mak manatxhe ha, kekon hatà. Rowyaro rma rha eryewhamnohxemo komo ryhe, ehonomnà me harha natxhe hampànà, rohanaw harha, kekon hatà. Ryeryewhamtoho wenàmtàhkehe hampànà. Toto wya twokru yontàhkantokono wyaro, ryeryewhamtoho wenàmtàhkehe hampànà, kekon hatà. Tuna kwaka toto yataymomnàtokono wyaro, ryeryewhamtoho yaka koteryaha hampànà. Rowyaro rma rha katà menàmtàhketxowà, oyeryewhamtoho komo, kekon hatà, Txesusu, Txaku komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Àhà, amna nenàmtàhkehe, ketxkon hatà, nyamoro ha. Yaworo màketxhe, kekon hatà, Txesusu, àwyanye. Rowyaro rma rha oyeryewhamtoho komo menàmtàhketxhe hampànà. ");
INSERT INTO hixNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Enàmtàhkanyenhàrà rma yeryhera mak wehxaha, uro, ehonomnà me harha, rohanaka harha, kekon hatà. Àsok tawro hana. Royàmà nwahanonkatxho komo ryhe, rohanaka texem me natxhe hampànà, kekon hatà, Txesusu, Txaku komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Txaku komo rwonà yonytxatxownà hatà, ukukur komo. Txesusu nhananàhrà ro komo rma rha nyamoro ha, 10 komo rma. Àro ke newakàhkahtxownà hatà, tkukur kom hoko, Txaku kom hoko, Xowaw hoko xarha. Kohonye nyhe ehonomnà me tesnàr komo xe natxow hamà, ketxkon hatà, 10 komo, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Àro ke nanyehtxekatxownà hatà, Txesusu, tàhyaka. Onà wyaro nkekon hatà, àwyanye. Àsok hana natxow ha, toto kayaryet kom ha, anaro rha yana kayaryet kom ha, kekon hatà. Ehonomnà me rma haxa natxow hamà, tàmryenon komo yoho rma haxa mak ha. Tàmryenonàthàyamo rma yanotometxow hamà, ehonomnà komo. Tanàhnohso ro nanotometxow hamà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Omnyam haxa ryhe, nyamoro wyarohra tehxorye manatxhe, kekon hatà. Ehonomnà me oyesnàr komo xe oyehtokonye, okukur komo yanoto me xaxa mpànà ehtxoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Àro wyaro rma rha wehxaha, uro, Toto me Enusaho. Anotomano ynye mehra mak komokye. Toto komo yanoto me haxa ryhe komokye, kekon hatà. Toto komo yonyhoryeny me ryhe komokye. Rano me ro rma kwayehyaha hampànà, rowya enyhoryetxho menye. Anhàn komo hyaye towtoho komo wehemehe, rowayehrà ke, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Taa. Xeryko hona nahatakatxownà hatà, Txesus komo. Taa. Àsnye ro totxownà xarha tà, Xeryko hoye rma hatà. Txesus yakoro tetxkon hatà, ànhananàhrà ro komo, toto komo xarha, thenyenohnà kom hatà. Asama yahetawo nehxakon hatà, toto. Enhunu ro rma mok nehxakon hatà. Bahtxemewu rma noro hatà. Txemew muru rma noro hatà. Uro nyhe txko rotxenyerun ha kanye ro me nehxakon hatà, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tàhyaha Txesusu tonàrà yonytxay hatà. Txesusu nomokyaha, Nasarye honotho rma nomokyaha, tawro yonytxay hatà, toto komo wya. Àro ke nàrwonàmye hatà, teryewrye ro. Ha y, Txesusu y, kekon hatà. Dafe heno yohamàtho omoro hatà. Rohnàn yaw exko, kekon hatà, enhunu ro. ");
INSERT INTO hixNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Neytxownà mak hatà, toto komo. Thenyenohnà komo rma neytxownà hatà. Tatàknye exko, ketxkon hatà, àwya. Tatàknye exko. Noro ryhe, nàrwonakonà rma haxa mak hatà, thenyehra rma haxa mak hatà. Dafe heno yohamàtho omoro hatà. Rohnàn yaw exko, kekonà rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kràk, horohye hatà, Txesusu. Noro hak anyehtxoko, rohyaka, kekon hatà, toto komo wya. Àro ke, enhunu ro yanyehtxownà hatà. Omok hatà, ketxkon hatà, àwya. Teryehorye exko. Asanàmko ha. Ayanyekyaha, mosonà, ketxkon hatà, toto komo, noro wya. ");
INSERT INTO hixNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Thononàthàrà wakay hatà, enhunu ro. Xuway, fuh txow, sax, nasanàmye hatà. Sàh sàh sàh sàh, Txesusu hyaka toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Àsok oynyàr xe manaye, rowya, kekon hatà, Txesusu, àwya. Khananàhnye y, kekon hatà, Rontanàhrà xe wehxaha, owya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ohxe àtoko, kekon hatà, Txesusu, àwya. Tonke harha manaha, rohona owya xenyàr ke, kekon hatà. Àtoko rma tonke harha nehxakon hatà, enhunu rotho. Txesus yakoro toy hatà, asama yarye. ");
INSERT INTO hixNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Xerusaryen hahnohyatxkon hatà, Txesus komo. Anaro rha owto txko màtkoso nomohtxownà hatà, Betfaxe màtkoso rma hatà, Betanya màtkos xarha hatà. Oryefera yàhàn mahotur ho ryhe nehxatxkon hatà, Txesus komo. Àto tehtokonye, asako nànyahtxownà hatà, Txesusu. Tànhananàhrà ro kom hoye asako nànyahtxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Onà wyaro nkekon hatà, àwyanye. Owto hona àtotxoko, kekon hatà. Owto hona àtotxoko. Menyatxhe, àro hona. Ayahatakatxhenye rma, xumentu mxekrà menyatxhe hampànà, kekon hatà. Ewahtosaho rma menyatxhe. Toto komo, àmkawo àtotho mehra hak naha, kekon hatà. Meweketxhe ha. Xaro mekyatxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Àsok tawro meweketxowà ketxow hana, toto komo, owyanye. Onà wyaro meyukyatxhe ha. Kohkomo, moson xe nay hatà, màketxhe ha, kekon hatà, Txesusu. Mexehra nekhen harha tà, Kohkomo, xaro harha, màketxhe ha, kekon hatà, Txesusu, tànànyaknyàr komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Àro ke totxownà hatà, nyamoro. Xumentu mxekrà yonytxownà hatà. Nàmno hotaka ewahtosaho nehxakon hatà. Màmyaye nehxakon hatà, asama yawo rma. Àro ke newekatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Onà wyaro nketxkon hatà, àton kukur komo, àwyanye. Àsok tawro meweketxowà, xumentu mxekrà, ketxkon hatà, àwyanye. Àsok tawro meweketxowà, xumentu mxekrà. ");
INSERT INTO hixNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Neyuhtxownà hatà, ànyahxemo komo. Txesusu wya katxhàrà yawo ro neyuhtxownà hatà. Àro ke narhotxownà hatà, àton komo, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Àro ke natxownà hatà, Txesusu hyaka. Xumentu mxekrà yatxownà hatà. Nàmkayamtotxownà hatà, twomun kom ke. Sax, dyerye, àmkakoso natakryey hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Asama yaka twomun komo yatxaraketxkon hatà, toto komo, thenyenohnà komo rma. Àhaya xarha yeryatxkon hatà, anar komo, asama yaka rma rha. Txaray txaray txaray, asama horye ro wewe txaraymetxkon hatà, Txesusu yosamar yaka txenyàr horà. Àro wyaro rma nehxatxkon hatà, tàwyanye ehonomnà me Txesusu yonyàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Txesusu ywaho tetxkon hatà, anar komo. Noro wenarye tetxkon hatà, anar komo. Omeroro rma, onà wyaro nketxkon hatà, teryewrye ro hatà. Kohkom yano me omohsaho ryhe mosonà. Ehonomnà me xaxa hak nahko, ketxkon hatà. Towakryexem me xaxa hak nahko. ");
INSERT INTO hixNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kàkayaryet komo me omohsaho ryhe mosonà, ketxkon hatà. Khoryen heno komo kayaryet me Dafe heno yehtxoho wyaro rma rha, kàkayaryet komo me nay hamà, mosonà, ketxkon hatà. Towakryexem me xaxa hak nahko. Ehonomnà me xaxa nay hamà, katxow haka, kahe yawon komo, ketxkon hatà, toto komo, teryewrye ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Àro wyaro Xerusaryen hona nahatakay hatà, Txesusu. Khoryenkom màn yaka nowomye hatà. Àro yawon horye ro nenytxehkay hatà, omeroro hatà. Tàwya xenytxehkatxhe rma, àro yaye toy hatà. Awanaka haxa nehxakon hatà. Àro ke, Betanya hona toy hatà. Akoro rma totxownà hatà, 12 komo. ");
INSERT INTO hixNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sa, nenmahye hatà. Betanya hoye totxownà hatà, Txesus komo. Tàtonàr me rma nahyehyakon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Moxe ro fek yoh yonyey hatà. Take rma haxa nehxakon hatà. Àro ke toy hatà, Txesusu, eher horà. Teherke nay hana, kekon hatà. Màtkoso toy hatà. Kràk. Eherhàra mak nehxakon hatà. Tak marma nehxakon hatà, ehetawawohra hak esnàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Onà wyaro nkekon hatà, Txesusu, fek yoh heno wya. Ehetahnà ro me oyesnàrà hxak moro ha, kekon hatà, àwya. Àro wyaro nenytxatxownà hatà, ànhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Xerusaryen hona nahatakatxownà hatà, Txesus komo. Khoryenkom màn yaka nowomye hatà, Txesusu. Àto nehxatxkon hatà, twarawantaxemà ro komo. Khoryenkom màn yawo ryhe warawantetxkon hatà. Nukrunyemehtxownà hatà, Txesusu. Fow fow, bey bey kekon hatà. Anar komo ryhe, txenyeru yomtakayonomanye ro me nehxatxkon hatà. Àtxenyerun komo rma, warata ho nehxakon hatà. Tax, teryay, waratatho matxakay hatà, Txesusu. Anar komo, watkuku yàmnye ro me nehxatxkon hatà, tahon kom ho eryewtaxemo. Tax, teryay, ahonàthàyamo xarha matxakay hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Anar komo, tkatxho komo yaryatxkon hatà, Khoryenkom màn yarye rma hatà. Horohkano yeryey hatà, Txesusu. Akatxho komo yarhàra ehtxok hampànà, on yarye, enyhoru ro yarye, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hananàhtxownà xarha tà. Àsok hana nken ha, àmenhosahonhàrà, kekon hatà. Onà wyaro nken hamà. Toto komo rwonàmtoho ro me naha, romànà. Anaro rha yana komo rwonàmtoho ro me naha. Àro wyaro rma nkehe, àmenhosahonhàrà, Khoryenkom màn hoko, kekon hatà, Txesusu. Àro rma manàhnohyatxhe harha, omnyamo. Àsok tawro hana, àro yawo rma toto komo txenyerunutho yahosnàr ke, owyanye, temenyem komo wyaro owyanye ahosnàr ke, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Àro wyaro nenytxatxownà hatà, Xuknewyana yoh komo, Khoryenkom màn yonye ro yoh komo rma, àyweronàhyamano ynye ro komo xarha. Àro ke, Txesusu wayehkanàr xe nehxatxkon hatà. Àsoke twayehketxowà, ketxkon hatà, tàwyanye rma. Àwayehkahra mak nehxatxkon hakahpa tà. Àsok tawro hana, toto kom hona toseryehrà kom ke hatà. Onà wyaro nketxkon hatà, toto komo. Koo, ohxe rma haxa khananàhyatxow hamà, mosonà, ketxkon hatà, tàwyanye rma, Txesus hoko. ");
INSERT INTO hixNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Awanaka haxa ehtoko, toy harha tà, Txesusu, owto ymo hoye. ");
INSERT INTO hixNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sa, nenmahye xarha tà. Fek yoh heno màtkoko totxownà xarha tà, Txesus komo, asama yarye rma hatà. Nenytxownà hatà. Àwayehsaho rma nehxakon hatà, fek yoh heno, àmxathàr heno me ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Txesusu rwonàmàthàrà hutway hatà, Petru. Khananàhnye y, mon ham fek yoh heno, onwayehkatxhàràtho, kekon hatà, Txesusu wya. Wayehyako hxak hamà, kekon hatà, Petru. ");
INSERT INTO hixNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Onà wyaro nkekon hatà, Txesusu, àwyanye. Khoryenkom hona xenytxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Onà wyaro yaworo xaxa àkehe, owyanye. Khoryenkom hona owyanye xenyetoko, rowyaro rma rha eryehokano meryatxhe hampànà, noro yahoxet yano me mak ha, kekon hatà. Oyoyukyatxhe hampànà, àhà ymo, moro ymo. Owyanye, ohtakako, atarymako tuna ymo kwaka, Khoryenkom yahoxet yano me, katxhe rma, oyoyukyatxhe hampànà, moro ymo. Onà wyaro kahra mak ehtxoko, ohnawonye, kekon hatà. Royukyan hana, àna hana, kahra ro mak ehtxoko, ohnawonye. Royukyaha xaxa mak hampànà, katxok xa ha, ohnawonye. Àro wyaro owyanye tatoko rma, oyoyukyatxhe hampànà, moro ymo, Khoryenkom hona rma haxa owyanye xenyàr ke mak ha, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Àro ke, onà wyaro àkehe, owyanye, kekon xarha tà. Àsok maken kom hoko orwonàmtxoko, Khoryenkom yakoro. Uro txko ewakryeko nyhe kanye ro me ehtxoko, noro wya, kekon hatà. Noro yakoro orwonàmnàtokonye, royukyaha xaxa mak hampànà katxoko, ohnawonye. Àro wyaro ohnawonye tatoko rma, Khoryenkomo oyowakryetxhe hampànà, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Noro yakoro orwonàmnàtokonye rma, oseryewhokatxoko, toto kom hoko. Oxehranye toto yehtoko, noro hoko rma oseryewhokatxoko, ohokony xarha Khoryenkomo yoseryewhokatxho me. Kahe yawono rma noro ha, Khoryenkomo, oyàmkomo rma. Noro rma noseryewhokehe, ohokonye, ayanhànàthàyam hoko, axanhàn kom hoko oyoseryewhokanàr kom ke, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nyamoro hoko oseryewhokahra oyehtokony haxa ryhe, oseryewhokahra rma rha naha hampànà, oyàmkomo, kahe yawono, ohokonye, ayanhànàthàyam hoko, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Xerusaryen hona nahatakatxownà xarha tà, Txesus komo. Khoryenkom màn yarye tekon hatà, Txesusu. Àtontoko rma, àhyaka nomohtxownà hatà, Khoryenkom màn yonye ro yoh komo, àyweronàhyamano ynye ro kom yakoro xarha, horykomo kom yakoro xarha. ");
INSERT INTO hixNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Onà wyaro nketxkon hatà, àwya. Onok yano me ukrunyemeknyo meryak harha, on yaye, ketxkon hatà. Onokà ryhe, ukrunyemehtxoko keknano, owya, ketxkon hatà, Xuknewyana yoh komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Uro htxero onà wyaro àkehe, owyanye royuhtoho me, kekon hatà. Onok yano me aymomno ryakonà, Xowaw heno, owyanye, kahe yawon yano me katà, toto yano me katà, kekon hatà. Omnyamo htxero, uro eyuhtxoko. Owyanye royukutxhe rma, uro haka rha koyukyatxhe, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Àro ke nosonytxetxkon hatà, nyamoro rye rma. Àsoke tketxowà, ketxkon hatà, tàwyanye rma. Àsoke tketxowà. Kahe yawon yano me aymomno ryakon hamà, noro heno, tketxow katà, ketxkon hatà. Àro wyaro kàwyanye tatoko, onà wyaro nken hamà, mosonà. Àsok tawro noro heno yoyukhura mehxatxkonà, ken hamà, kàwyanye, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Àsok haxa katà tketxowà. Toto yano me aymomno ryakon hamà, tketxowà, ketxkon hatà, Xuknewyana yoh komo, tàwyanye rma. Àro wyaro tawro xehra mak nehxatxkon hatà. Àsok tawro hana, toto kom hona toseryehrà kom ke hatà. Onà wyaro kany me nehxatxkon hatà, toto komo. Khoryenkomo rwonà yokarymanye ro me haxa we nehxakon ha, Xowaw heno, kany me nehxatxkon hatà, toto komo, omeroron komo. Àro ke noseryehyatxkon hatà, eh komo, toto yano me aymomno ryakon hamà tawro hona. ");
INSERT INTO hixNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Àro ke, onà wyaro nketxkon hatà, Txesusu wya. Hàà, àna hana, ketxkon hatà, àwya. Onok yano me hana aymomno ryakon ha, noro heno ha. Uhutwahra amna naha, ketxkon hatà. Uro xarha, oyoyukhuranye wehxaha, kekon hatà, Txesusu, àwyanye. Onok yano me hana ukrunyemeknyo weryak ha. Oskarymahra ro mak wehxaha ha, owyanye, kekon hatà, Txesusu, Xuknewyana yoh komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kuknonano me nàrwonàmye hatà, Txesusu, akoronye, Xuknewyana yoh kom yakoro. Nyamoro wya tàxanomkahnohtoho kuknon me ryhe, onà wyaro nkekon hatà, àwyanye. Tànatàrà yeryey hatà, horykomo, kekon hatà. Ufa heno yonamye hatà. Watxamtoy xarha tà, kekon hatà. Toh yakay xarha tà, ufa xkunkatxho rma hatà. Wato ymo yeryey xarha tà, kawono ymo hatà, tànatàrà yonytxoho rma hatà, kekon hatà. Àro wyaro tàwya txetxehkatxhe rma, toto komo yomyaràhtoy hatà. Tànatàr yony me nemyaràhtotxownà hatà, kekon hatà. Tàwya emyaràhtotxhenye rma, toy hatà, horykomo, anar komo yowto hona, monyen komo yowto hona, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Amnye ehetawawo tanoto nyakye hatà, horykomo, tànatàr yony komo hyaka. Àhyakanye nànyakye hatà, eher horà, kekon hatà. Ronatàr yeher hoye mpànà monekhetxow ha, owya, kekon hatà, tanoto wya. Àro ke toy hatà, àhyakanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Anoto heno yahohtxownà mak hatà, nat yony komo, txom, txom, txom. Nàhpohtxownà xarha tà. Akorohra rma nànyahtxownà harha tà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Amnye, anaro tanoto xarha nyakye hatà, àhyakanye. Noro heno yhuthuhwo netahatxownà hatà, nyamoro ha. Atxke rma haxa netxownà hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Amnye, anaro tanoto xarha nyakye hatà, àhyakanye. Noro heno yotahatxownà hatà, nyamoro ha. Wayehye hatà, kekon hatà. Anar komo tanoto komo xarha nyakye hatà, àhyakanye. Anaro heno komo hpohtxownà hatà. Anaro heno komo yotahatxownà hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Horykomo yakoro rma nehxakon hatà, umuru txko, towenyxano txko, ànàhnànà txko. Noro rma nyakye haxa hatà, àhyakanye. Ohxe romuru yonyatxhe, kekon hatà, horykomo, tàwya rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Onà wyaro haxa nketxkon hatà, nat yony kom ha, tàwyanye rma. Moson hamà umuru, ketxkon hatà. Tàyàmànhàrà wayhàtxhe, nat yoh me harha nay hamà, umurunhuru kaxe, ketxkon hatà. Àro ke norotho tetahatxe, norohnà harha kàwyam harha nat yoh me kehtxoho menye, ketxkon hatà, tàwyanye rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Àro ke noro heno yahohtxownà hatà. Netahatxownà hatà. Ekehàthàrà yarymatxownà hatà, nat waye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Àsok hana nyamoro heno ymo yeryan ha, horykomo, kekon xarha tà, àwyanye. Nyamoro heno ymo yotahaxe ten hamà. Netahetxow hamà. Anar komo yomyaràhten hamà, tànatàr yony me harha, kekon hatà, Txesusu. Àro wyaro kuknonano me nàrwonàmye hatà, Xuknewyana yoh komo wya tàxanomkahnohtoho hutwamohsonàr horà rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Onà wyaro nkekon xarha tà, àwyanye. Khoryenkom karyehtanà hutwahra manatxowà, kekon hatà. Onà wyaro nkehe, àmenhosahonhàrà. Toh xanomkahnohnye komo wyaro, noro xanomkahnohyatxhe hampànà, toto komo. Noro ryhe, ehonomnà me harha mpànà naha ha. Nàmno yetxehà wyaro, ehonomnà me noro yeryaha hampànà, Kohkomo. ");
INSERT INTO hixNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ehonomnà me harha noro yehtxoho rma, ohxe rma haxa naha, kàwyanye. Àro wyaro rma nkehe, àmenhosahonhàrà. Àro wyaro katxhàrànhàrà hutwahra kat manatxowà, kekon hatà, Txesusu, Xuknewyana yoh komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Onà wyaro nehutwetxkon mak hatà, nyamoro ha. Khokonye rma nàrwonàmno hamà. Kukuknon kom me nàrwonàmno hamà, ketxkon hatà, Xuknewyana yoh komo, tàwyanye rma. Àro ke, noro yahohtxahke nehxatxkon haryhe tà. Ahohsàra mak nehxatxkon hakahpa tà, toto kom hona toseryehrà kom ke hatà. Àro ke, noro hyaye totxownà hatà, Xuknewyana yoh komo. ");
INSERT INTO hixNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tkukur komo nyahtxownà hatà, Xuknewyana yoh komo, Txesusu hyaka. Farysew kukur komo rma nyahtxownà hatà. Eroknes kukur komo xarha nyahtxownà hatà, àhyaka. Onà wyaro tawro xe rma nehxatxkon haryhe tà, ànyahxemo komo, Txesusu rwon hoko. Atxke màkehe, yaworohra mak màkehe, tawro xe rma nehxatxkon haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Txesusu hyaka haxa totxownà hatà. Khananàhnye y, ketxkon hatà, àwya. Yaworo rma haxa manaha, amna wya, ketxkonà rma haryhe tà. Yaworo xaxa hananàhno meryaha, amna wya. Àme yohà rma haxa manaha, toto kom hoko. Owya àhananàhnàtokonye, oseryehpàra ro mak manaha, toto kom hona, ketxkonà rma haryhe tà. Toto kom hona àhyahampàra ro mak manaha. Yaworo xaxa Khoryenkomo muhutwamohsehe, amna wya, ketxkonà rma haryhe tà. Àro ke, uhutwamohsoko, amna wya. Txenyerun kom hoye tàmporye naye, Sesa wya, Homayana komo kayaryetà wya. Tàmporyehra kat naye, owya, ketxkonà rma haryhe tà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tàmyatxow katà. Tàmpàra kat tehxatxowà, owya, ketxkonà rma haryhe tà. Yaworon mehra ehtxoho komo hutwekon mak hatà, Txesusu. Àro ke, onà wyaro nkekon hatà, àwyanye. Rokukmanàr xe manatxow hamà, ronkukmanàr horà, kekon hatà, àwyanye. Txenyeru txko sohtxoko, rowya xenytxoho me, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Àro ke nehtxownà hatà, àhyaka. Onok kuknonà mosonà, kekon hatà, Txesusu. Onok yosotà onà, àmenhosaho, kekon hatà, txenyeru txko hoko. Hàà, Sesa hamà, ketxkon hatà, nyamoro ha. ");
INSERT INTO hixNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Hàà, yaworo màketxow hamà, kekon hatà, Txesusu. Noro katxho me nay hamà, onà, kekon hatà. Àro ke, noro ewakryetxoko, owyanye àkatxho yàmrà ke mak ha, kekon hatà. Àro wyaro rma rha Khoryenkomo xarha ewakryetxoko, owyanye eyuknur ke mak ha, kekon hatà, Txesusu. Àro wyaro tàwyanye enytxatxhe rma, noseryehoketxkon hatà, ànyahxemo komo, thenyehra hatà. Koo, ohxe rma haxa koyuhtxow hamà, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saknusew kukur komo xarha nomohtxownà hatà, Txesusu hyaka. Kwayhàtxhenye, asanàmpàra ro mak tehxatxhe, kany komo rma nyamoro ha. Khananàhnye y, ketxkon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Onà wyaro nmenhoy hatà, Moyses heno, kàyweronàhyamanye ro heno komo. Towàt heno wayhàtxhe, àhokhura rma àwayhàtxhe, àhetxenhàrà hak yahosno, ewtànhàrà rma. Noro ryhe, thetx me nahohsaha, àhohtanàr horà. Towàt heno wenatàhwo hohtehe, noro ha, towàt heno hokru me. Àro wyaro rma nmenhoy hatà, Moyses heno, ketxkon hatà, Saknusew komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Àro ke enytxako. Tànyonye wos yexetxhàrànhàrà amna nekarymehe, owya, ketxkon hatà. 7 me nehxatxkonà, toto heno komo, ewtà rye komo rma. Wahoto heno wos yahosàye, ketxkon hatà. Wayehye, noro heno. Àhokhura rma wayehye, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Àhonanotho heno rhye, towàt heno hetxenho yahosàye. Àhokhura rma rha wayehye, noro heno xarha, ketxkon hatà. Àro wyaro rma rha nexeye, àhonanotho heno xarha. ");
INSERT INTO hixNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Àro wyaro rma rha nehtxownà, 7 heno komo, omeroro, ketxkon hatà. Tàwyanye wos yahosàtxhe, wayehtàkatxownà. Àhohtahra rye rma wayehtàkatxownà. Nyamoro heno mahyaka wos heno xarha wayehye, ketxkon hatà, Saknusew komo. ");
INSERT INTO hixNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Àsok natxowà àro ke, owya, ketxkon hatà, Txesusu wya. Kwayhàtxhenye tasanàmyatxhe harha màkehe hawe, omoro. Onok hetx me ryhe naye, wosà, tasanàmàtxhenye, ketxkon hatà. Onok hetx me ryhe naye, amnye ha. Tano rma hak tehtoko, 7 kom hetx me nehxakon hamà, ketxkon hatà, Saknusew komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Àna matà, kekon mak hatà, Txesusu, àwyanye. Ayawexenatxow hamà, omnyamo. Owyanye asanàmpàra ro mak tehxatxhe tatoko rma, ayawexenatxow hamà. Khoryenkomo karyehtanà hutwahra ro mak manatxow hamà. Khoryenkomo yahoxet xarha hutwahra rma rha manatxow hamà. Àro ke ayawexenatxhe ro mak ha, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tasanàmàtxhenye, àhehtahra ro mak natxhe ha, àwayehxemonhàr komo. Ànyontahra ro mak natxhe xarha, kekon hatà. Kahe yawon komo wyaro rma natxhe ha, Khoryenkomo yanoto komo wyaro rma, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tanàmsom me xaxa mpànà natxhe ha, àwayehxemotho komo, kekon xarha tà, àwyanye. Moyses heno nmenhotho hutwahra kat manatxowà. Tàwya ewekhàr yoh hoko àmenhontoko rma, Khoryenkomo rwonà yokarymay hatà, noro heno, kekon hatà. Onà wyaro ryhe nkekon hatà, Khoryenkomo, noro heno wya. Akmaraw horyenà rma uro ha, kekon hatà. Esake horyenà rma uro ha, Xako horyenà rma uro ha, kekon hatà, Khoryenkomo, noro heno wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Khoryenkomo ryhe, ehxen komo horyen mehra ro mak naha ha. Tehxemà rma kom haxa horyen me naha. Àro ke, àwayehxemotho komo yanàmnye me nay hamà, kekon hatà. Àro ke, ayawexenatxow hamà, thenyehra mak ha, kekon hatà, Txesusu, Saknusew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Txesusu hyaka nomokye hatà, àyweronàhyamano ynye ro kom kukuru. Noro yakoro Saknusew komo yosonytxanàrà yonytxay hatà. Ohxe neyuhtxow hamà, mosonà, kekon hatà, tàwya rma. Àro ke, onà wyaro nkekon hatà, Txesusu wya. Thenyehra nay hamà, Moyses heno nmenhotho, kekon hatà. Thenyehra mak nay hamà, kàyweronàhyamatxho komo. Àsok katxho ryhe, anar komo yoho nyhe naye, owya, kekon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Neyukye hatà, Txesusu. Onà wyaro katxho ryhe, ohxe rma haxa naha, kàyweronàhyamatxho komo. Anar komo yoho nyhe naha, kekon hatà. Ehsayewyana komo y, enytxatxoko. Kohkomo ryhe, Khoryenkom me naha, noro ro mak ha, Kohkom ha. ");
INSERT INTO hixNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Noro xe xaxa ehtxoko. Khoryenkom xe rma ehtxoko, oyowan kom ke xaxa mak ha, ohnawon kom ke xaxa mak ha, oyehutwanàr kom me xaxa mak ha, ayahoxet kom ke xaxa mak ha. Àro wyaro katxho ryhe, anar komo yoho nyhe naha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Àhonan xarha, onà wyaro katxho rma, ohxe rma rha naha. Osox oyehtxoho wyaro rma, ohoyen kom xe xaxa ehtxok xarha. Àro wyaro katxho rma, ohxe rma rha naha, kekon hatà, Txesusu. Àro wyaro katxho komo yohono, ehxera ro mak naha, kàyweronàhyamatxho komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Àna mat mà, khananàhnye y, kekon hatà, noro, àyweronàhyamano ynye ro. Àna mat mà. Yaworo mak màkan ha. Noro ro mak mok ha, Khoryenkomo, kekon hatà. Anaro ehxera ro mak naha. Noro ro mak mok ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Noro xe rma haxa tehxatxow hamà, kowan kom ke xaxa mak ha, kehutwanàr kom me xaxa mak ha, kahoxet kom ke xaxa mak ha, kekon hatà, noro. Khoyen kom xe xarha tehxatxow hamà, osox kehtxoho wyaro. Khoryenkomo xe kehtxoho komo ryhe, khoyen komo xe kehtxoho komo xarha, anar komo yoho rma haxa nay hamà. Kàwyanye Khoryenkomo yowakryetxho yoho rma haxa nay hamà, kekon hatà. Kàwyanye koknàthàyamo yàmtoho yoho rma haxa nay hamà, noro xe kehtxoho komo, toto xe kehtxoho komo xarha, kekon hatà, àyweronàhyamano ynye ro, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ohxe royukno hamà, mosonà, kekon hatà, Txesusu, tàwya rma. Àro ke, onà wyaro nkekon hatà, àwya. Khoryenkomo yoyuknur xe manay hamà, àro ke, noro mryenon me ehxaya rma haxa manaha, kekon hatà, àwya. Àro wyaro Txesusu wya katxhe rma, osonytxahra harha nehxatxkon hatà, toto komo, noro yakoro. Àsok naye, owya, kahra harha nehxatxkon hatà, àwya, towankaranàmrà kom ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Taa. Hananàhno ryakon hatà, Txesusu, Khoryenkom màn yawo. Hananàhno ynyàr me, onà wyaro nkekon hatà, toto komo wya. Dafe heno yohamàtho me nay hatà, Kryestu, Khoryenkomo nànyaknyàrà rma, kany me natxhe, àyweronàhyamano ynye ro komo, kekon hatà. Àsok tawro, àro wyaro nketxowà, yaworo katà, yaworohra haxa katà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dafe heno ryhe, toh me ryhe Kryestu yotakye. Onà wyaro ryhe nkay hatà, noro heno, Khoryenkom yokato yano me. Onà wyaro nken hatà, Kohkomo, rohà wya. Ehonomnà me xaxa eryewtako, rohanaka, ken hatà. Howehehra eryewtako, ken hatà. Tan oyehtoko rma haka, onà wyaro kany me axanhàn komo weryaha hampànà. Ehonomnà me xaxa manaha kany me weryatxhe hampànà, ohoko, ken hatà, Kohkomo, rohà wya. Àro wyaro rma nkay hatà, Dafe heno, Kryestu hok hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tohamrà rma yotakyakonà, toh me. Àsok tawro ryhe, ehamàthàr me harha nexeye, ehà rma, owyanye, kekon hatà, Txesusu. Teryehorye rma haxa noro yonytxetxkon hatà, toto komo. Thenyenohnà komo rma nyamoro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Taa. Hananàhno ynyàr me, onà wyaro nkekon xarha tà, Txesusu, toto komo wya. Àyweronàhyamano ynye ro komo ryhe, atxke natxow hamà, kekon hatà. Atxke ehtxoho kom hona mpànà xenytxoko, nyamoro wyarohra oyehtxoho menye. Ohxe tosonyhonàr komo xe rma natxhe haryhe, nyamoro ha, kekon hatà. Àro ke newomumtetxhe, enyhoru ke, kawono ymo ke. Àro yawo rma tetxhe. Yakentawo tàtonkonye, Ha y, khananàhnye y, tawro xe natxhe haryhe, toto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ohsamnohno ytxoho ro yawo tehtokonye, ehonomnà komo yahon ho neryewtetxhe, nyamoro ha, kekon hatà. Anar kom yakoro tasahxemtontokonye, ehonomnà me tosonyhonàr komo xe rma natxhe haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nyamoro rma, enyonkaxemo katxhotho yaryatxhe, tkatxho kom me harha, kekon hatà. Khoryenkom yakoro tàrwonàmnàtokonye, mexe rma haxa nàrwonatxhe, onkuhtono ynyàr me mak ha, ohxe tosonyhonàr kom horà mak ha, kekon hatà. Àsok hana natxow ha, nyamoro ha. Tanàhnohsom me natxhe hampànà, anar komo yoho rma haxa mak ha, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Khoryenkom màn yawo rma nehxakon hatà, Txesusu. Neryewtay hatà, txenyeru yonkahtoho ro màhto. Khoryenkom màn yonye ro komo txenyerun yonà rma àro hatà. Toto komo yonyakon hatà, Txesusu. Thenyenohnà komo rma, tàtxenyerun kom hoye nenkahyatxkon hatà, àro yaka. Thenyenohnà rma haxa yonkahyatxkon hatà, ukukur komo, tàtxenyerunkem komo rma. ");
INSERT INTO hixNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nomokye xarha tà, wosà, enyonkaxaho. Àtxenyerumnu rma mok nehxakon hatà, noro ha. Àro yaka rma rha nenkahye hatà, noro xarha. Asak marma txko nenkahye hatà. Ehetàhpenyenohnà rma haxa yonkahye hatà, noro. ");
INSERT INTO hixNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tànhananàhrà ro komo yanyekye hatà, Txesusu, tàhyaka. Onà wyaro nkekon hatà, àwyanye. Moson wosà, enyonkaxaho, àtxenyerumnu rma, kekon hatà, àwyanye. Yaworo xaxa àkehe, owyanye. Noro nàmàtho, anar komo nàmàtho yoho rma haxa tehetàhke naha, Khoryenkomo wya, kekon hatà. Omeroron komo yoho rma haxa nenkahno ha. ");
INSERT INTO hixNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nyamoro nàmtxownà rma haryhe, tàtxenyerun kom hoy mak ha, thenyenohnà ymo hoy mak ha, kekon hatà. Moson haxa ryhe nàmtàhkano, omeroro mak ha. Àtxenyerumra tesnàr yoho ro rma nàmtàhkano. Tànyahrà yehekahtoho kenyehra nàmtàhkano, wosà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Khoryenkom màn yaye nahatakatxownà hatà, Txesus komo. Tahatakantokonye rma, onà wyaro nkekon hatà, ànhananàhrà ro komo kukuru, Txesusu wya. Khananàhnye y, kekon hatà. Xenyko, moro ymo, anaro rha nàmno, Khoryenkom mànà ymo, poo, ohxe rma haxa wenyaha, tohu ymo, enyhoryexaho ymo, kekon hatà, noro, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Onà wyaro haxa nkekon hatà, Txesusu, àwya. Moro ymo menyan hamà, anaro rha nàmno ymo, horyetho ymo, kekon hatà. Amnye nosomkawononkatxehkehe hampànà, àro ymo heno. Osomkawono ymo heno natarymatxehkehe hampànà, othenyekhenà ro me mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Oryefera yàhàn hona totxownà hatà. Àto rma nehxakon hatà, Txesusu, eryewtaxaho. Khoryenkom màn wetxe tompataye nehxakon hatà. Noro hyawo nehxatxkon hatà, Petru komo, Txaku xarha, Xowaw xarha, Antrye xarha. Nyamoro marma nehxatxkon hatà, àhyawo. Onà wyaro nketxkon hatà, àwya, anar komo nenytxahtor me mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Àsokentoko ryhe nosomtatkatxehkeno, Khoryenkom mànà ymo heno, ketxkon hatà, àwya. Àsokentoko nosomtatkatxehkeno. Àhahnoke rma haxa ehtoko, eten komo tenyatxowà, uhutwamohsotho. Ekarymako, amna wya, ketxkon hatà, Petru komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Onà wyaro neyuhtxownà hatà, Txesusu. Anar komo wya oyonkuhtonàr kom hona mpànà xenytxoko, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nomokyatxhe hampànà, onkuhtono ynye komo, anaro rha komo, thenyehra. Kryestu uro ha ketxhe rma haryhe. Toto komo yonkuhtetxhe hampànà. Thenyenohnà komo rma yonkuhtetxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Waha yosohtahanàr komo yokaytà menytxetxhe hampànà. Mexehra nosohtahetxow hatà, waha komo, tawro xarha menytxetxhe hampànà, kekon hatà. Àro wyaro owyanye enytxantoko, oseryehpàra rma ehtxoko. Àro wyaro htxero haka mpànà natxhe ha, toto komo. Osomtatkatxehkahra rma hak naha, yukryeka, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Anaro rha yana komo nosohtahetxhe hampànà, kekon xarha tà, àwyanye. Anaro rha owto hon komo nosohtahetxhe hampànà. Anato rha nosowuhsaha hampànà, yukryeka, thenyehra, kekon hatà. Ehxera ro mak naha hampànà, nyahà. Àro wyaro htxero neryewhamyatxhe hampànà, toto komo. Eryewhamtàhkahra rma hak natxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ohxe mpànà ehutwatxoko, oseryehokahra oyehtxoho menye, kekon xarha tà, Txesusu, Petru komo wya. Anar komo ayaryatxhe hampànà, horykomo komo hyaka, tosonytxaxemà ro komo hyaka. Tohsamnohtoho kom yawo ohpokyatxhe hampànà, kekon hatà. Anaro rha tkayaryet komo hyaka ayaryatxhe hampànà, anaro rha kofehnakno komo hyaka xarha. Àwyanye ayanàhnohrà kom horà ayaryatxhe hampànà, romryenon me oyesnàr kom ke mak ha. Àwyanye rma uro mekarymetxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tokarymaxem me mak naha hampànà, àrwo yonyhorunu. Yukryeka yosomtatkatxehkahra ro rma haka, tokarymaxem me mak naha hampànà. Àro rma yonytxatxehketxhe hampànà, toto komo, anaro rha yana komo, omeroro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Horykomo komo hyaka ayaryatxhe hampànà, ayanàhnohrà kom horà, kekon xarha tà. Àhyakanye ayanàtokonye, oseryehokahra rma ehtxoko. Àsoke ryhe koskarymeno, àwyanye, kahra rma ehtxoko, ohnawonye, kekon hatà. Àtoko rma oyoskarymatxho komo hutwamohsehe, Khoryenkom yokato. Omnyamohnà rma, noro haxa nàrwonaha, tàwya orwonàhyamanàr kom ke mak ha. Àro yawo ro rma haxa oskarymatxoko, kekon hatà, Txesusu, Petru komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Oyowtà komo rma ayahohsetxhe hampànà, axanhàn komo wya, awayehkanàr kom horà. Oyàmkomo rma, ohokyamo xarha, ayahohsetxhe hampànà, àwyanye awayehkanàr kom horà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Oxehranye rma haxa natxhe hampànà, toto komo, omeroro, romryenon me oyesnàr kom ke mak ha. Enàmtxok mak hampànà. Owyanye enàmtoho hoye ro, karyhe roro harha manatxhe hampànà, kekon hatà, Txesusu, Petru komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Onà wyaro nkekon xarha tà, Txesusu, Petru komo wya. Anhà ymo menyatxhe hampànà, Khoryenkom mànàtho xanomkahnohmohsonye ymo, kekon hatà. Khoryenkom mànàtho yaka rma neryatxhe hampànà, waha komo, enyhoru rotho yaka rma. Àto tehxoryehra ro mak naha ha. Àto rma menyatxhe hampànà, kekon hatà, Txesusu. Àro wyaro nkekon hatà, Txesusu, anhà ymo hoko. Àro wyaro rma àmenhono, tano, thutwaxem me anhà ymo yehtxoho me. Onà wyaro nkekon xarha tà, Txesusu, Petru komo wya. Tàwyanye anhà ymo yonyetxhe rma, onà wyaro hak nahtxoko, àton komo, Xukneya yamtar hon komo, kekon hatà. Àhà ymo hona hak nekahtàmtxowà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Màmyaye tehtokonye, àtohra harha hak nahtxoko, bàn kom yaka harha. Tkatxho kom horà àtohra hak nahtxoko. Nekahtàmtxow haxa haka, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bararàn kom hoko tehtokonye, omokhàra harha hak nahtxoko. Twomun kom horà omokhàra hak nahtxoko. Nekahtàmtxow haxa haka, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Oko txko, mokyamo txko ha, yuhna heno komo, tonarkem heno komo xarha. Àtoko rma, thenyehra neryewhamyatxhe hampànà, nyamoro heno, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Onà wyaro hak nàrwonàmtxowà, Khoryenkom yakoro. Apa y, txemnyeh mehra hak nahko, rokahtàmtoho, katxow haka, toto komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Àtoko rma, thenyehra rma haxa neryewhamyatxhe hampànà, toto komo. Àro wyaro eryewhampàra ro mak nehxatxkonà, amnyehran heno komo, Khoryenkomo wya toto yakàhtothàrànhàrà yaye ro rma. Àro wyaro eryewhampàra rma rha natxhe xarha, amnyen komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Thenyehra mak neryewhamyatxhe hampànà, kekon hatà. Amnye eryewhamtohotho komo yatàknanàhkehe hampànà, Kohkomo, tàwya tàmryenon komo kurunhotho me, tànwahanonkatxhàyamo kurunhotho me. Atàknanàhkahra ehtok haxa, omeroron komo wayehtàkanàràtho haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Àtoko rma, onà wyaro nketxhe hampànà, anar komo, owyanye. Tan naha, Kryestu, omohsaho rma, ketxhe hampànà. Mono nay hatà, ketxhe xarha, anar komo, owyanye. Enytxahrany mak ehtxok hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kryestu uro ketxhe rma haryhe, anar komo. Khoryenkomo rwonà yokarymanye uro ketxhe rma haryhe, anar komo. Eryehokano yeryatxhe rma haryhe, thenyehra, kekon hatà. Tahoxet komo rma yonyhetxhe rma haryhe, toto komo wya. Àro hoye ro onkuhtono yeryatxhe hampànà. Khoryenkomo mryenon komo xarha yonkuhtotxahke natxhe rma haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Omokhàra ronye rma haka, wekarymatxehkan hampànà, owyanye. Àro ke, ohxe mpànà ehtxoko, kekon hatà, Txesusu, Petru komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Toto komo yeryewhamtoho yatàknatxhe rma, nawanyehe hakahpa harha hampànà, kamàm heno, kekon xarha tà, Txesusu. Nuno xarha, awasmehra harha naha hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Xeryko heno xarha, kahe hoye nothahyaha hampànà. Nosowuhsaha hampànà, kahe hokonotho rma, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Àro wyaro exetxhe rma, Toto me Enusaho yonyatxhe hampànà, toto komo. Kahrutun wawo omoknàrà yonyatxhe hampànà. Ehonomnà me xaxa nomokyaha. Ohxe xaxa tonyxem me rma nomokyaha, Toto me Enusaho, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Àtoko rma, kahe yawon komo nyakyaha, noro ha. Tanoto komo rma nyakyaha. Nyamoro wya, tànwahanonkatxhàyamo yohamnohpehe hampànà. Ananye rha nehamnohyatxhe hampànà, yukryeka màtà ymo hoye, kahe màtà ymo hoye, kekon hatà, Txesusu, Petru komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kuknonano me xarha nekarymay hatà, Txesusu, Petru komo wya. Àsok hana nay ha, nat ha, kekon hatà. Tataskatxhe rma, naten hamà, natà, fek yohà rma. Owyanye atanàrà yonyetoko, onà wyaro màketxow hamà. Mexehra rma haxa tàtxemnyehàntetxow hamà, màketxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Àro wyaro rma rha amnye muhutwetxhe hampànà. Àro wyaro owyanye ronekarymatxho yonyetoko, onà wyaro màketxhe hampànà. Mexehra rma haxa nomokyan hamà, Toto me Enusaho, màketxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Onà wyaro yaworo xaxa àkehe, owyanye, kekon xarha tà. Amnyeno rma kukur komo ryhe, àwayehtàkahra natxhe hampànà. Ehtokonye rma haka nehoryatxhe hampànà, ronekarymatxho, omeroro, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kahe heno nosomtatkehe hampànà. Yukryeka heno xarha nosomtatkehe hampànà. Rorwon haxa ryhe, osomtatkahra ro mak naha ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Àsokentok hana nomokyan ha, Toto me Enusaho, kekon hatà. Omohtoho yawasànà ywero naha, royàmà, noro marma mak ha. Àywenyeke mak natxhe ha, toto komo, kekon hatà. Àywenyeke rma rha natxhe, kahe yawon komo xarha. Àywenyeke rma rha naha, Khoryenkom muru xarha. Royàm marma ryhe, àywero naha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ohxe mpànà ehtxoko, kekon xarha tà. Thona ro mpànà ehtxoko, omohtoho yawasànà ywenyeke oyesnàr kom ke, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Horykomo wya anotomano ynyàrà wyaro naha, kekon hatà. Anatoko meya ten hana, noro ha, anar komo yowto hona. Bàn yaye tàtohra ro rma haka, onà wyaro nken hamà, tanoto komo wya. On hok exko, rano me, kehe, anaro wya. On hok exko, rano me, omoro xarha, kehe, anaro wya. Àro wyaro omeroro nanotometxow hamà, kekon hatà. Bàn yonye ro xarha yanotomen hamà. Thona ro mpànà exko, ken hamà, horykomo, noro wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Àro wyaro rma rha thona ro mpànà ehtxoko, omnyam xarha, kekon hatà. Àsokentok hana nomokyan ha, oyoh komo, bànkemà wyarono, awanaka hana, kohsarakataw hana, apaytara htàmnàtok hana, enmahrà ro hana. Noro yomohtoho ywenyeke manatxhe. Àro ke, thona ro mpànà ehtxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Anatoko onhutwahtor kom ho nomokyan hana. Tànàhsomà wyaro oyonyatxow hana. Àro ke, thona ro mpànà ehtxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Àro wyaro àkehe, owyanye. Àro wyaro rma rha àkehe xarha, omeroron komo wya. Thona ro mpànà ehtxoko, àkehe, kekon hatà, Txesusu, Petru komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Txesus hoko nosonytxetxkon hatà, Xuknewyana yoh komo, Khoryenkom màn yonye ro yoh komo rma, àyweronàhyamano ynye ro komo xarha. Ekayhera rma noro yahosnàr xe nehxatxkon hatà, àwayehkanàr horà. Toto komo nenyehtor me rma noro yahosnàr xe nehxatxkon hatà. Onà wyaro nketxkon hatà, tàwyanye rma. Asako ro enmahàtxhe, tasahxemtetxow hamà, ketxkon hatà. Tasahxemtetxow hamà, khoryen heno komo yohokoko àtothàrànhàrà hutwahkahpàra kehtxoho menye, ketxkon hatà. Ekeyu àwakanomnà tenahyatxow hamà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kasahxemtontokonye, ahohsàra hak tehtxe. Kàwyanye ahosnàtoko rma, ukurunhoso nohsamnohyatxow hamà, toto komo, thenyehra, ketxkon hatà, Xuknewyana yoh komo. ");
INSERT INTO hixNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Taa. Betanya ho nehxakon hatà, Txesusu. Semaw màn yawo nehxakon hatà, hunmata ymo yawonotho rma màn yaw hatà. Àto nemtakmekon hatà. Emtakmantoko rma, àhyaka nomokye hatà, wosà. Ownyaku yokye hatà. Naknu katà ryhe àro hatà, ownyaku. Ehetàhpenye rma haxa nehxakon hatà. Enà ryhe, toh me nehxakon hatà. Arakmasturu rma mon nehxakon hatà, tohu. Enàthàrà yakahay hatà, wosà. Ownyaku yarkay hatà, Txesusu yhutho horye. Ehetàhpenyeno rma yarkay hatà, àhorye. Àsok tawro hana, ohxe rma haxa tàwya xenyàr ke hamà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Àton kukur komo ryhe, ewakhàra mak nehxatxkon hatà. Onà wyaro nketxkon hatà, tàwyanye rma. Àsok tawro ownyakutho yanàhnohno harha, mosonà, ketxkon hatà, tàwyanye rma. Àsok tawro ownyakutho yanàhnohno harha. ");
INSERT INTO hixNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tarkahoryehra nahko haryhe, ketxkon hatà. Txenyeru hona tàmporye nahko haryhe. 300 txenyeru yoho nyhe nahko haryhe, ehethàrà. Txenyeru rma, tàmporye nahko haryhe, àtxenyerumnu ro komo wya, àkatxhomnà ro komo wya, ketxkon hatà, àton kukur komo. Àro wyaro atxke nàrwonatxkon hatà, wos hoko. ");
INSERT INTO hixNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Moson hoko àrwomra ehtxoko, kekon hatà. Noro yeryehokahra ehtxoko. Ohxe rma haxa ryenyo, tàwya rokaryenàr ke. Àro ke àrwomra tehxorye mahtxok haryhe, àhoko, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Àsok tawro hana. Àtxenyerumnu ro komo ryhe, tano roro rma natxow hamà, awawonye. Emahona ro nyamoro mewakryetxow hamà, ewakryenàr komo xe oyehtokonye, kekon hatà. Uro haxa ryhe, tano rorohra mak wehxaha. Amnye awawonyehra harha wehxaha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mosonà ryhe, rowakryenàr xe nahko hamà. Àro ke rokaryeno, kekon hatà. Rowayehpàra ro rma haka rokaryeno. Amnye ronamtoho hona rokaryeno, rohorye tàwya arkanàr ke. Ohxe rma haxa ryenyo hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Onà wyaro yaworo xaxa àkehe, owyanye. Tokarymaxem me nay hamà, àrwo yonyhorunu, kekon hatà. Toto komo nenytxanàr me nay hamà, omeroron komo nenytxanàr me mak ha. Mosonà wya rokaryetxhàr xarha, tokarymaxem me rma rha mpànà naha ha. Tonytxaxem me rma rha mpànà naha ha, noro hutwahkahpàra toto komo yehtxoho me, kekon hatà, Txesusu, àton komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Khoryenkom màn yonye ro yoh komo hyaka toy hatà, Xuknas Eskaryotesà. 12 komo kukuru rma mok nehxakon hatà. Noro rma, Txesusu yahohsonàr xe nehxakon hatà, àwyanye, àxanhàn komo wya. Àro ke toy hatà, àhyakanye. Wahohsos haka, mokàtho ymo, owyanye, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Àro wyaro tàwyanye enytxatxhe rma, teryehorye nehxatxkon hatà, nyamoro ha. Otxenyerunu amna nàmyaha, noro ymo yahohsotxhetà, ketxkon hatà, àwya. Àro ke, Txesusu yahohsotxahke nehxakon hatà, Xuknasà, àwyanye. Àsokentoko tahohsohorye naye, kekon hatà, tàwya rma. Amnye nyhe txko tahohsorye nay hamà, toto komo ehxera ehtok mak ha, kekon hatà, Xuknasà, tàwya rma. ");
INSERT INTO hixNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sa, nenmahye haxa hatà, asahxemtotho komo. Ekeyu àwakanomnà yonahtoho katxho rma àro hatà. Àro hoko rma, 7 me nenmahyatxkon yoh hatà, Xuknewyana komo. Wahoro htxeron ho, thoryen heno komo yohokoko àtothàrànhàrà hutwetxkon hatà. Tharaxkaxem me nehxakon hatà, kahneru mxekàtho. Àhoryen heno komo yohokoko àtothàrànhàrà hutwatxho rma mon nehxakon hatà. Àro rma ho, onà wyaro nketxkon hatà, ànhananàhrà ro komo, Txesusu wya. Henta ya ryhe amna tonàr xe manaye, kasahxemtotho komo yonyhoryexe, ketxkon hatà, àwya. Henta ryhe amna nenyhoryeno, kasahxemtotho komo, ketxkon hatà, ànhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Àro ke, asako nànyahtxownà hatà, Txesusu, tànhananàhrà ro kom hoye. Àtotxok ha, owto ymo hona, kekon hatà, àwyanye. Àto toto menyatxhe. Oryen ke tomyarkemà rma oyohoryatxhe, tuna yon ke tomyarkemà rma. Noro wenarye màtetxhe ha, kekon hatà, Txesusu, asakon komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nàmno yaka owomnàtoko, mowomyatxhe ha, omnyam xarha. Onà wyaro màketxhe ha, horykomo wya, nàmno yohà wya. Hawana me nomokyan hatà, ohyaka, khananàhnye komo, màketxhe ha. Omàn yawo nasahxemten hatà, tànhananàhrà ro kom yakoro, khoryen heno komo yohokoko àtothàrànhàrà hutwatxho me, màketxhe ha. Esarà xenyhok hatà, amna wya, màketxhe ha, horykomo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Noro ryhe, bàn yawo tahusomà ymo yonyhehe hampànà, owyanye. Kayeno rma, tahonkemà ro rma, enyhoryexaho rma yonyhehe, owyanye. Àto rma menyhoryetxhe ha, kasahxemtotho komo, kekon hatà, Txesusu, asakon komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Àro ke totxownà hatà, ànyahxemo komo. Àpo, owto ymo hona nahatakatxownà hatà. Txesusu rwonàmàthàrà yawo ro rma haxa nenytxownà hatà. Tasahxemtotho komo yonyhoryetxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Taa. Awanaka nomokye hatà, Txesusu, 12 kom yakoro. ");
INSERT INTO hixNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Asahxemtoso neryewtatxownà hatà. Tasahxemtontokonye rma, onà wyaro nkekon hatà, Txesusu, àwyanye. Onà wyaro yaworo xaxa àkehe, owyanye, kekon hatà. Okukur komo ryhe rahohsehe hampànà, roxanhàn komo wya. Rakoro tasahxemtosomà rma, rahohsehe hampànà, àwyanye, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Àro wyaro tàwyanye enytxatxhe rma, nekhokatxownà hatà. Osomahyaka onà wyaro nketxkon hatà, àwya. Ayahohsonye uro, owya, ketxkon hatà, omeroro, osomahyaka. ");
INSERT INTO hixNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Onà wyaro neyuhtxownà hatà, Txesusu. Okukur komo ryhe, 12 komo kukuru rma, rahohsony me naha, kekon hatà. Oryen yaka rakoro àhpanye rma, rahohsony me naha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Àwayehso àtehe hampànà, Toto me Enusah kaxe, àmenhosahonhàrà yawo ro ryehtxoho me. Tanàhnohsom me mak naha hampànà, rahohsonyenhàrà ymo heno. Enurhura tehtok haxa, ohxe esnàràtho haryhe, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tasahxemtontokonye rma, ekeyu yanàmye hatà, Txesusu. Apa y, ohxe onàmàthàrà onà, kekon hatà, Khoryenkomo wya. Nàkràskay hatà. Nekamye hatà, 12 komo wya. Ahohtxoko, kekon hatà, àwyanye. Rohun kuknonà rma onà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ufa xkun yonà yanàmye hatà. Apa y, ohxe onàmàthàrà onà, kekon hatà, Khoryenkomo wya. Nàmye hatà, àwyanye. Àhoye nentxownà hatà, omeroro. ");
INSERT INTO hixNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Rokamsukuru kuknonà rma onà, kekon hatà, Txesusu, àwyanye. Kekamsuhkehe, Khoryenkomo wya romryenon komo yonyhoryetxehkany me wehxaha tawro ke. Àro ke kekamsuhkehe, rowya toto komo yonyhoryetxho me, thenyenohnà komo rma yonyhoryetxho me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Onà wyaro yaworo xaxa àkehe, owyanye, kekon hatà. Ufa xkun yonhàra harha wehxaha. Khoryenkom yowto ho harha oyehtokonye, anaro meno ufa xkunu tenyatxhe hampànà. Àro hohra rma hak oyehtokonye, enhàra roro rma wehxaha, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tasahxemtotxhenye, wano yatxownà hatà, Txesus komo. Twanotatxhenye rma, totxownà hatà, Oryefera yàhàn hona. ");
INSERT INTO hixNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Onà wyaro nkekon hatà, Txesusu, 12 komo wya. Uro màhnànkatxehketxhe hampànà, omnyamo, omeroro, kekon hatà. Anhà komo wya rahohtoho hoye ro, uro màhnànkatxehketxhe hampànà. Àsok tawro hana. Onà wyaro nken hamà, àmenhosahonhàrà. Kahneru komo yonye ro heno wetahehe hampànà. Àro ke natakhahyatxhe hampànà, eknàthàyamo. Àro wyaro rma nkehe, àmenhosahonhàrà. Àro wyaro katxhàrànhàrà yawo ro matakhahyatxhe hampànà, rohyaye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Àwayehsahonhàrà rma, kasanàmyaha harha hampànà. Rasanàmàtxhe, oywahonye àtehe hampànà, Karyeryeya yamtar hona, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Onà wyaro haxa nkekon hatà, Petru, àwya. Moxamo ohnànkatxehketxow hana, omeroro. Uro haxa ryhe, ohnànkahra ro mak wehxaha ha, kekon hatà, Petru. ");
INSERT INTO hixNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Onà wyaro yaworo xaxa àkehe, owya, kekon hatà, Txesusu, àwya. Noro ywenyeke wehxaha, màkehe hampànà, rohoko. Màkehe xarha, màkehe xarha, osorwawo ro, kekon hatà. Àro wyaro rma màkehe hampànà, amnye rma kohsaya, asako ro apaytara htàmpàra ro rma haka, kekon hatà, Txesusu, Petru wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Onà wyaro nkekon mak hatà, Petru, teryewrye ro rma haxa mak hatà. Àro wyaro kahra ro mak wehxaha ha, kekon hatà, Txesusu wya. Noro ywenyeke wehxaha kahra ro mak wehxaha ha, ohoko. Norotho xarha àwayehkatxoko katxho me rma ryehtoko, àro wyaro kahra rma wehxaha, kekon hatà, Petru. Àro wyaro rma rha nketxkon hatà, ukukur komo xarha, Txesusu nhananàhrà ro komo rma, omeroro. ");
INSERT INTO hixNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nat waka totxownà hatà, Txesus komo. Ketsemane rma àro hatà, nat yosotà. Onà wyaro nkekon hatà, Txesusu, tànhananàhrà ro komo wya. Eryewtatxoko, kekon hatà. Tan ehtxoko. Uro ryhe, Khoryenkom yakoro àrwonàmso àtehe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Petru yarày hatà, Txaku xarha hatà, Xowaw xarha hatà. Meya nyhe txko totxownà hatà. Noseryehokay harha tà, Txesusu, thenyehra mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Àro ke, onà wyaro nkekon hatà, Petru komo wya. Thenyehra koseryehokehe, rohnawo, kekon hatà. Àwayehpaya wehxan hamà, roseryehokanàr ke. Tano rma hak ehtxoko. Tonke rma ehtxoko, kekon hatà, Txesusu, Petru komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Meya nyhe txko toy xarha tà. Tano me ro rma nehurkay hatà, yukryeka hona. Onà wyaro nàrwonàmye hatà, Khoryenkom yakoro. Apa y, ryeryewhamtoho hona uro ukurunhoko, rokurunhonàr xe oyehtok mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Apa y, ehnyahnà ro me xaxa manay hamà, omoro, ehonomnà xaxa kaxe. Àro ke, ryeryewhamtoho hona uro ukurunhoko. Rano me rohra mak ryesnàr xe wehxaha. Ayano me ro ryhe ryesnàr xe wehxaha, kekon hatà, Txesusu, Khoryenkomo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nomokye harha tà, Petru komo hyaka. Nànàkyatxkon hatà. Àro ke, onà wyaro nkekon hatà, Petru wya. Semawu y, ownàkno hamà, kekon hatà. Tonke ehtxoko àkan haxa hawe, owyanye. Mexehra ownàkno hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tonke ehtxoko, kekon hatà. Khoryenkom yakoro orwonàmtxoko, anhà nkukmahtor me oyehtxoho menye. Ohxe oyesnàr komo xe rma manatxhe haryhe, ohnawonye. Ahoxemra mak manatxhe, ohun kom ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Toy xarha tà. Nàrwonàmye xarha tà, Khoryenkom yakoro. Tàrwonàmàthàrà wyaro rma rha nàrwonàmye xarha tà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nomokye harha tà, Petru komo hyaka. Nànàkyatxkonà rma hatà, twetun kom ke rma haxa mak hatà. Txesusu wya tompakatxhenye, noro yoyukhura rma nehxatxkon hatà. Àsok tawro hana, twetun komo ke rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Osorwawo ro nàrwonàmye hatà, Txesusu, Khoryenkom yakoro. Osorwawo ro rma rha nomokye harha tà, Petru komo hyaka. Osorwawo ro tomokàtxhe, onà wyaro nkekon hatà, àwyanye. Ownàkyatxowà rye rma hamà, kekon hatà. Ownàkyatxowà rye rma hamà. Àna haxa ha. Ahakatxok haxa ha. Tahohsoso haxa wehxan hamà, anhà komo wya, Toto me Enusah kaxe, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Asanàmtxok ha. Àpa txow ha. Mok noro hamà, rahohsonye ymo, kekon hatà, Txesusu, Petru komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Àro wyaro Txesusu wya tatoko rma, nomokye hatà, Xuknasà. 12 komo kukuru rma mok nehxakon hatà. Noro yakoro nomohtxownà hatà, toto komo, thenyenohnà komo. Tkatxefaranke, twatmanke xarha, nomohtxownà hatà. Àro wyaro nomohtxownà hatà, Khoryenkom màn yonye ro yoh kom yano me, àyweronàhyamano ynye ro kom yano me xarha, horykomo kom yano me xarha. ");
INSERT INTO hixNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Onà wyaro kanyenhàr me nehxakon hatà, Xuknasà, àwyanye. Noro mpànà wamtxuhkehe ha, noro rma mahohsatxhe hampànà, ohxe maryatxhe hampànà, kanyenhàr me nehxakon hatà, ahohsonye ymo. Àro wyaro kanyenhàr me nehxakon hatà, Txesusu ywero ehtxoho menye. ");
INSERT INTO hixNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tomokàtxhe rma, Txesus yawo ro toy hatà. Khananàhnye y, kekon hatà. Namtxuhkay hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Txom, nahohtxownà hatà, Xuknas yakoron komo. ");
INSERT INTO hixNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Txesus yakoron komo kukuru ryhe, tkatxefaran wakay hatà. Khoryenkom màn yonye ro komo yohà ymo yanototho hanakay hatà, txaray. ");
INSERT INTO hixNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Onà wyaro nkekon hatà, Txesusu, waha komo wya, tahosnyenhàyamo wya. Àsok tawro tkatxefaranke momohtxowà, kekon hatà. Àsok tawro twatmanke momohtxowà. Waha me uro menyatxow hamà. Àro ke twatmanke momohtxow hamà, owyanye rahohtoho me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Emahona ro wehxaknano, awawonye. Khoryenkom màn yawo wehxaknano, hananàhno ynyàr hoko, kekon hatà. Àto rma ryehtoko, rahohsàra rma mehxatxkenano. Amnye rma haxa uro mahohtxowà, àmenhosahonhàrà yawo ro ryehtxoho me, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Àtoko rma noro hnànkatxehkatxownà hatà, akoronotho komo, omeroro. Nekahtàmtàhkatxownà mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Txesus yakoro rma tekon hatà, toto, àhorymamxenyeno. Tkaramxe nehxakon hatà, wom ke, enyhoru rma ke. Txom, nahohtxownà hatà, waha komo. ");
INSERT INTO hixNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Newomunkay mak hatà, noro, emyakanye. Anyempera rma nekahtàmye hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Txesusu yatxownà hatà, ahosnyenhàyamo. Khoryenkom màn yonye ro komo yohà ymo hyaka natxownà hatà. Àhyaka rma nohsamnohtàkatxownà hatà, Xuknewyana yoh komo, Khoryenkom màn yonye ro yoh komo rma, horykomo komo xarha, àyweronàhyamano ynye ro komo xarha. Tosonytxaxemà ro komo rma mokyam nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Txesus wenarye toy hatà, Petru, moxe nyhe hatà. Nàmno ymo watxan yaka ryhe toy hatà. Khoryenkom màn yonye ro komo yohà ymo màn watxan yaka rma toy hatà. Àro yaka rma nowomye hatà. Àto rma neryewtay hatà, anotonano ro komo hyawo. Eryewtaxaho rma nosomyakon hatà, weheto hona. ");
INSERT INTO hixNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Txesusu wayehkanàr xe nehxatxkon hatà, Khoryenkom màn yonye ro yoh komo, tosonytxaxemà ro kom yakoro. Àro ke, noro yanhànà yonyenhàyamo yohoryatxkon hatà. Atxke nehxako mokà ymo, ronenyàr me, kany komo rma yohoryatxkon hatà. Ehxera mak nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yaworohra ekarymany kom haxa ryhe, yak nehxatxkon hatà. Àme ryehra mak nekarymetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nasanàmtxownà hatà, anar komo. Yaworohra rma rha nekarymatxownà xarha tà. Onà wyaro nketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Mosonà amna nenytxeko, ketxkonà rma haryhe tà. Onà wyaro nkeknan haryhe. Khoryenkom mànàtho warymatxehkehe, keknano. Toto nyeryetxhotho rma warymatxehkehe, keknano. Amnye anaro weryaha, keknano. Osorwawo ro enmahàtxhe, anaro weryaha harha, Khoryenkom mànà, toto nyeryehtorà rma, keknano, mosonà, amna nenytxanàr me, ketxkonà rma haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Àro wyaro tàwyanye tatoko rma, àme ryehra rma rha nekarymetxkon hatà, nyamoro xarha. ");
INSERT INTO hixNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Khoryenkom màn yonye ro komo yohà ymo ryhe nasanàmye hatà, amrakatakanye. Onà wyaro nkekon hatà, Txesusu wya. Àsok tawro eyukhuranye manaye, kekon hatà, àwya. Yaworo katà, yaworohra haxa katà, àro wyaro oyokarymetxowà, moxamo, kekon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tatàknye rma nehxakon hatà, Txesusu. Eyukhura ro mak nehxakon hatà. Àro ke, onà wyaro nkekon xarha tà, noro ymo, àwya. Oskarymako, kekon hatà. Oskarymako. Kryestu me manaye. Khoryenkom muru me manaye. Ohxe xaxa manaha katxho muru me manaye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Àhà, noro mat uro, kekon hatà, Txesusu. Amnye, uro menyatxhe hampànà. Toto me Enusaho rma menyatxhe hampànà, kekon hatà. Khoryenkom hanaka eryewtaxaho rma menyatxhe hampànà, howehehra eryewtaxaho rma. Àro wyaro ehonomnà me xaxa uro menyatxhe hampànà. Kahrutun wawo romoknàr xarha menyatxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Àro wyaro Txesusu wya katxho rma, atxke rma haxa nehxakon hatà, noro ymo wya. Neryehokatxehkay hatà. Àro ke, thononàthàrà yawotoy hatà, teryehokatxho hutwamohsonàr horà. Onà wyaro nkekon hatà, tosonytxaxemà ro komo wya. Khoryenkomo wyaro ehonomnà me nosonyan hamà, mosonà, kekon hatà. Khoryenkomo wàràhyaken hamà. Menytxatxowà rma, kekon hatà. Àro ke, anhàn yokarymany komo yonytxahra harha tehtxe. Àsok màketxowà, omnyamo, moson hoko, kekon hatà, noro ymo. Twayehkahorye naha, ketxkon hatà, nyamoro, tosonytxaxemà ro komo rma, omeroro rma. ");
INSERT INTO hixNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Txesus horye netahtatxownà hatà, ukukur komo. Nempatanyohomtotxownà hatà. Netahatxownà hatà, tamor kom ke. Empatanyohomtosaho wya rma, onà wyaro nketxkon hatà, tàwyanye ewnohrà me hatà. Onok oyotahano, etaxko mpa, ketxkon hatà, àwya. Anoto komo xarha netahetxkon hatà, tamor kom ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ahomyawo rma nehxakon hatà, Petru. Nàmno watxan yawo rma eryewtaxaho nehxakon hatà. Nosomyakonà rma hatà. Àhyaka nomokye hatà, omaso. Khoryenkom màn yonye ro komo yohà ymo yanoto rma mok nehxakon hatà, omaso. ");
INSERT INTO hixNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Petru yonyey hatà. Osomnàtoko rma nenyey hatà. Nenytxehkay hatà. Txesus yakoronotho komo kukuru omoro hamà, kekon hatà, àwya. Nasarye hon yakoronotho rma omoro hamà, kekon hatà, omaso, Petru wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Norohnà uro, kekon mak hatà, Petru. Noro ywenyeke wehxaha. Orwon hutwahra wehxaha, kekon hatà. Àro wyaro tàwya katxhe rma, nàmno watxan hotaka toy hatà. Àtoko rma nàhtàmye hatà, apaytara. ");
INSERT INTO hixNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Noro rma rha yonyey hatà, omaso. Nyamoro kukuru moson hamà, kekon xarha tà, àton komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Norohnà uro, kekon xarha tà, Petru. Noro ywenyeke wehxaha, kekon hatà. Mexehra exetxhe, onà wyaro nketxkon hatà, àton komo, Petru wya. Nyamoro kukuru me xaxa manay hamà, Karyeryeya honotho me oyesnàr ke, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Onok hoko orwonatxowà, kekon mak hatà, Petru, àwyanye. Noro ywenyeke wehxaha. Àro wyaro yaworo xaxa àkehe, owyanye. Yaworohra rowya tatok haxa, Khoryenkom hak romtatkano, kekon hatà. Àro wyaro nkekon hatà, Petru, teryewrye ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Àro wyaro àwya katxhe rma, nàhtàmye xarha tà, apaytara. Àro ke, Txesusu rwonàmàthàràtho hutway harha tà, Petru. Noro ywenyeke wehxaha màkehe hampànà, rohoko, katxhàràtho rma hutway hatà. Màkehe xarha, màkehe xarha, osorwawo ro, katxhàràtho rma, àro wyaro rma màkehe hampànà, asako ro apaytara htàmpàra ro rma haka, katxhàràtho rma hutway hatà, Petru. Tàwya uhutwatxhe rma, nàratay hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Sa, nenmahye hatà. Enmahàtxhe rma, nosonytxatxehkatxownà hatà, tosonytxaxemà ro komo, Khoryenkom màn yonye ro yoh komo rma, horykomo kom yakoro xarha, àyweronàhyamano ynye ro kom yakoro xarha. Tosonytxatxhenye, Txesusu yasohtotxownà hatà. Natxownà hatà, Peratusu hyaka, kofehnakno hyaka. Nahohsotxownà hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Xuknewyana komo kayaryetà omoro, owya, kekon hatà, Peratusu, Txesusu wya. Omoro rma, Xuknewyana komo kayaryetà omoro màkano, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Noro hoko atxke nàrwonatxkon hatà, Khoryenkom màn yonye ro yoh komo. Anaro rha noro yanhànà yokarymetxkonà rma haryhe tà, thenyehra hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Onà wyaro nkekon xarha tà, Peratusu, àwya. Atxke nàrwonatxow hamà, moxamo, ohoko, kekon hatà. Anaro rha ayanhànà yokarymetxow hamà. Eyukhuranye manaye. Oskarymahra manaye, kekon hatà, Peratusu, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Eyukhurany harha nehxakon hatà, Txesusu. Oskarymahra ro mak nehxakon hatà. Ekurunhohra ro mak nehxakon hatà. Àro ke noseryehokay hatà, Peratusu. Àsok tawro oskarymahra nay haryhe, kekon hatà, tàwya rma. ");
INSERT INTO hixNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tasahxemtotho kom ho yohà, toto heno yonampatakahetxkon hatà, Xuknewyana komo, kofehnakno wya. Watxa ymo yawo ahryemxemotho kom hoye rma nenampatakahetxkon yoh hatà, àwya. Toto kom yano me rma nenampatakekon yoh hatà, Peratusu. ");
INSERT INTO hixNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Àwyanye Txesusu yahosnàtoko rma, watxa ymo yawo nehxatxkon hatà, ahryemxemo komo. Homayana komo yarymatxahkenotho komo rma mokyam nehxatxkon hatà. Arymatxahkenye tehtokonye rma, toto heno komo yotahanyenhàr me nehxatxkon hatà. Barakmasà ryhe, ukukur kom me nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Àro ke, Peratusu hyaka haxa totxownà hatà, toto komo, ohsamnohxemo komo. Amna yasahxemtotho ho yohà, ahryemxemotho menampataketxow hamà, ketxkon hatà, àwya. Àro ke, toto enampatakako, amna hyaka, ketxkon hatà, toto komo, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Onà wyaro neyuhtxownà hatà, Peratusu. Txesus hak wenampatakaxe, kekon hatà, àwyanye. Xuknewyana komo kayaryetà mosonà katxho rma hak wenampatakaxe. Noro yonampatakanàr xehra kat manatxowà, rowya, kekon hatà, Peratusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Àsok tawro hana. Onà wyaro nehutwekon hamà, tàhnawo. Txesusu yahohsotxow hamà, rowya, Khoryenkom màn yonye ro yoh komo, tatakuynyàr kom ke hamà, ehonomnà me toto komo wya noro yonyàr ke hamà, kekon hatà, Peratusu, tàhnawo. Àro ke, Txesusu yonampatakanàr xe nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Onà wyaro haxa nketxkon hatà, Khoryenkom màn yonye ro yoh komo, toto komo wya, ohsamnohxemo komo wya. Barakmas haxa enampatakako, amna hyaka, katxoko, Peratusu wya, ketxkon hatà, àwyanye. Àro ke, àro wyaro nketxkon hatà, toto komo, Peratusu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Onà wyaro neyuhtxownà xarha tà, Peratusu. Àsoke ryhe weryano, mosonà, Xuknewyana komo kayaryetà mosonà katxho rma, owyanye, kekon hatà. Àsoke ryhe noro weryano, owyanye, kekon hatà, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Noro amoyathohoko, yahkotohen hona, ketxkon hatà, teryewrye ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Àsok ehtxoho hoye ro wamoyathoheno, kekon hatà, Peratusu, àwyanye. Àsoke ryhe naye, anhànà, owyanye, kekon hatà, toto komo wya. Thenyehra rma haxa kowontetxkon hatà, nyamoro, teryewrye ro rma haxa mak hatà. Amoyathohoko, yahkotohen hona, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Toto komo yeryehotanàhrà xe nehxakon hatà, Peratusu. Àro ke, Barakmasà yonampatakahoy hatà, nyamoro yano me. Txesusu hpokhoy hatà, arymano ynye ro komo wya. Namoyathohoy xarha tà, àwyanye. Yahkotohen hona amoyathoso atxok ha, kekon hatà, Peratusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Txesusu yatxownà hatà, arymano ynye ro komo. Kofehnakno mànà ymo yaka htxero natxownà hatà. Pàryetoryo onà katxho rma àro hatà, nàmno yosotà. Tkukur komo yanyehtxekatxownà hatà. Omeroro rma nohsamnohtàkatxownà hatà, Txesusu hyaka. Noro yownohso nomohtàkatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Noro honomtotxownà hatà, tàswayem ke, ehonomnà komo hononà wyaron ke, ewnohrà me rma hatà. Ewekhàrà hryekahtxownà hatà, erokon me. Ehonomnà komo yorokonà wyarono rma àro hatà. Suu, noro yhutho hona netxownà hatà, ewnohrà me rma rha hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ha y, Xuknewyana komo kayaryetà y, ketxkonà rma haryhe tà, àwya, ewnohrà me rma rha hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Noro yhutho yotahatxownà xarha tà, omam ke. Noro horye netahtatxownà xarha tà. Tosoknar kom ho neryewtatxownà xarha tà, noro yakrataka, tkayaryet komo yakrataka teryewtatho komo wyaro rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Àro wyaro tàwyanye ewnohtàkatxhe rma, tàswayemàtho wakatxownà harha tà. Honomtotxownà harha tà, àhononàthàr ke harha. Amoyathoso natxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tàtonàr kom me, toto yohotxownà hatà. Semawu rma noro hatà. Seryene honotho rma mok nehxakon hatà. Aryesantàrye yàmà rma noro hatà. Hufu yàm xarha noro hatà, Semawu. Noro rma, owto ymo hona nomokyakon hatà. Àro wyaro nehotxownà hatà, arymano ynye ro komo. Àro ke, noro wya rma yahkotoheno yarhotxownà hatà. Txesusu wayehkatxho rma yarhotxownà hatà, Semawu wya. ");
INSERT INTO hixNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Amoyathono ytxoho ro na nahatakatxownà hatà. Korkota rma àro hatà. Okno yhutho yotxhotho onà katxho rma àro hatà, Korkota katxho. ");
INSERT INTO hixNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Àwokru yàmyatxkon haryhe tà, Txesusu wya. Meha yohkur ke ufa xkun wakanomaxaho rma àro hatà, àwokru, ehtxe wyaron hatà. Nàmyatxkonà rma haryhe tà, àwya, eryewru hutwahra ehtxoho me. Enhàra mak nehxakon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Namoyathotxownà hatà, yahkotohen hona. Àwomunuthuru yokamtxownà hatà, tàwyanye rma. Tohu txko yarymatxownà hatà, tàwyanye xenytxoho me, tàwyanye àrotho uro hamà katxho me. Àro wyaro nekamtxownà hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Enmahrà ro, 9 oras me ehtoko, namoyathotxownà hatà, kamàmà yasawnukhura ro nyhe rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Àmenhosaho yetxownà hatà, wewe hona, Txesusu yhutho yohoye. Xuknewyana komo kayaryet heno mosonà katxho rma menhotxownà hatà, noro yanhànà hutwamohsonàr horà rma haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Àhanawo rma wahanhotho yamoyathotxownà xarha tà, asak hatà. Anaro, howehehra nehxakon hatà. Anaro xarha, howehe nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Àro wyaro Txesus hanawo nehxatxkon hatà, àmenhosahonhàrà yawo ro rma haxa noro yehtxoho me. Onà wyaro nkehe, àmenhosahonhàrà. Noro ryhe, waha komo kukuru me naha hampànà, toto komo wya. Àro wyaro rma nkehe, àmenhosahonhàrà. Àro wyaro katxhàrànhàrà yawo ro nehxakon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Noro wàràhyaketxkon hatà, toto komo, àhyaha tàtosom komo. Wàh wà nketxkon hatà, ewnohrà me hatà. Owya ymo hxako, ketxkon hatà. Khoryenkom mànàtho warymatxehkehe, kanyenhàràtho omoro hatà. Atarymatxehkaxahotho rma weryaha harha, kanyenhàràtho rma omoro hatà, ketxkon hatà. Osorwawo ro enmahàtxhe, weryaha harha, Khoryenkom mànà, kanyenhàràtho rma omoro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Àro wyaro ehonomnà me oyehtoko, ekurunhoko, awayehrà hona, ketxkon hatà. Osonyhoryek harha. Ohtok harha, yahkotohen hoye, ketxkon hatà, toto komo, Txesusu wya, ewnohrà me hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Àro wyaro rma rha newnohyatxkon hatà, Xuknewyana yoh komo xarha, Khoryenkom màn yonye ro yoh komo rma, àyweronàhyamano ynye ro kom yakoro xarha. Onà wyaro nketxkon hatà. Toto komo yonyhoryetxownà hatà. Noro rma, osonyhoryehra ro mak nay hamà, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kryestu me nay hatà. Ehsayewyana komo kayaryet me nay hatà, ketxkon hatà. Kàkayaryet kom me tehtoko, yahkotohen hoy hak nàhtono, denyàr kom me. Kàwyanye àhtonàrà yonyetxhe, noro mokro hamà tketxhe ha, ketxkon hatà, Xuknewyana yoh komo, tàwyanye rma. Àro wyaro rma rha newnohyatxkon hatà, wahanhotho komo xarha, noro yakoro amoyathoxemotho komo rma. ");
INSERT INTO hixNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kamàm thataw ehtoko, nawanay harha tà. Ràà kay hatà, yukryeka yamtar horye, omeroro hatà. 3 oras nenatày hatà, tawanye rma hatà. Kokonyehra rma hak ehtoko, tawanye rma hak nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kokonye ehtoko, nàrwonàmye hatà, Txesusu, teryewrye ro hatà. Eroye, Eroye, ryema sakmahtane, kekon hatà. Àro wyaro katxho rma, onà wyaro katxho me rma naha. Rohoryenà y, rohoryenà y, àsok tawro uro màhnànkan harha, katxho me rma naha. ");
INSERT INTO hixNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Àro wyaro tàwyanye enytxatxhe rma, onà wyaro nketxkon hatà, àton kukur komo. Eryeyas heno yanyekyan hamà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Àro ke karyhe toy hatà, toto, ukukur komo rma, àwokru horà. Sosoheno yaràhtoy hatà, ufa xkun ke, tutxunyem ke rma. Omam hotkoso neryey hatà. Nàmyakonà rma haryhe tà, Txesusu wya entoho me. Thona ro hak tehtxe, kekon hatà. Tenytxe haka. Nomokyan xana, Eryeyas heno, kekon hatà. Yahkotohen hoye towso xana nomokyano. Tenytxe haka, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kowontay haxa hatà, Txesusu, teryewrye ro hatà. Àro wyaro tkowontatxhe rma, wayehye hatà. Tano me ro rma wayehye hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Àro wyaro Txesusu wayehnàtoko, Khoryenkom màn yawonotho newaraxkay hatà. Thoko rma newaraxkay hatà, wom yatxarakaxahotho, Khoryenkom màn yawonotho. Eryehtyero newaraxkay hatà, txomo na hama. ");
INSERT INTO hixNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Txesusu yompataye nehxakon hatà, arymano ynye ro komo yohà, 100 komo yohà rma. Tàwya Txesusu wayehrà yonyetxhe, onà wyaro nkekon hatà. Khoryenkom muru me nahko hamà, moson heno, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Àto nehxatxkon xarha tà, woràskomo komo. Moxe ro rma, omeroro nenytxehkatxownà hatà. Àwawonye rma nehxakon hatà, Maryeya. Maknara honotho rma mok nehxakon hatà. Àwawonye rma rha nehxakon xarha tà, Maryeya rma rha. Txaku txko yonà rma noro hatà. Xose yon xarha noro hatà. Àwawonye rma rha nehxakon xarha tà, Sarome. ");
INSERT INTO hixNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Txesus yakoronotho komo rma mokyam nehxatxkon hatà, woràskomo komo, Karyeryeya yamtar horye noro yakoro tàtosomàtho komo rma hatà, noro yakoronomanyenhàyamotho rma hatà. Àwawonye nehxatxkon xarha tà, anar komo, woràskomo komo rma, thenyenohnà komo rma. Txesus yakoro Xerusaryen hona omohxemotho komo rma nyamoro hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hokano ytxoho yawasànà yosnaka rma tà wayehye ha, Txesusu, Xuknewyana komo yosonyhoryetxho yawasàn ho rma hatà. Awanaka rma haxa wayehye hatà. Hokano ytxoho yawasàn ho enampànà ro me nehxatxkon hatà, àwayehxemo komo. Àro ke, Txesusu yekehàtho yonamrà xe nehxakon hatà, horykomo, àro rma ho hatà, awanaka rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Xose rma noro hatà, horykomo. Arymateya honotho rma mok nehxakon hatà. Ehonomnà rma haxa noro hatà, tosonytxaxemà ro komo kukuru rma hatà. Kàkayaryet kom me Khoryenkomo nànyaknyàr hona ro nehxakon hatà. Noro rma toy hatà, Peratusu hyaka. Oseryehpàra rma, onà wyaro nkekon hatà, àwya. Txesusu yekehàtho yanàr xe wehxaha, rowya enamtoho me, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mexehra mak wayehno ha, kekon hatà, Peratusu. Mexehra mak wayehno ha. Àro ke, 100 komo yohà yanyekye hatà, tàhyaka. Twayehso naye, kekon hatà, àwya, Txesus hoko. ");
INSERT INTO hixNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Àhà, wayehno ha, kekon hatà, 100 komo yohà. Àro ke, ekehàthàrà yarhoy hatà, Peratusu, Xose wya. ");
INSERT INTO hixNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Womu yehekatày hatà, Xose, enyhoru rma hatà. Ekehàthàrà yowye hatà, yahkotohen hoye. Karamye hatà, wom ke, enyhoru rma ke. Toh yowtar yaka nenamye hatà, onamno ytxoho yaka, toh yakaxahonhàrà rma yaka. Tohu ymo hanamay xarha tà, ewtar hotaka. Ahutoho ymo rma hanamay hatà, Xose. ");
INSERT INTO hixNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Àto rma nehxatxkon hatà, Maryeya komo, Maknara honotho rma, esohye xarha, Maryeya rma rha, Xose yonà rma. Txesusu yonamtoho yonytxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Hokano ytxoho yawasànà kokmamye hatà. Àkokmamàtxhe rma, ownyaku thoxnyemà yehekahtxownà hatà, Maryeya komo, Maknara honotho rma, esohye xarha, Maryeya rma rha, Txaku yonà rma, Sarome xarha. Ownyaku thoxnyemà rma yanàr xe nehxatxkon hatà, onamno ytxoho na, Txesusu yekehàtho karyenàr horà rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sa, nenmahye hatà, domenku. Enmahrà ro totxownà hatà, Maryeya komo. Onamno ytxoho na totxownà hatà, kamàm yahatakatxhe nyhe hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Onà wyaro nketxkon hatà, tàwyanye rma. Tohu ymo yotakanye txko yka nahko, toh yowtar hotaye, kàhyakanye, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Dàk, nosompohtxownà hatà. Tohu ymo yonytxownà hatà. Ewtar hotaye etakaxaho rma yonytxownà hatà. Koo, ketxkon hatà, hory me ymo rma haxa esnàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nowomtxownà hatà, ewtar yaka. Toto wyarono yonytxownà hatà, àhorymamxenyeno wyarono rma hatà. Eryewtaxaho nehxakon hatà, noro, ewtar yawo, howehehra. Thononke nehxakon hatà, buknyem ke rma hatà. Tàwyanye xenyetxhe rma, noskatokatxownà hatà, woràskomo komo. ");
INSERT INTO hixNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Oskatokahra ehtxoko, kekon hatà, noro, àwyanye. Oskatokahra ehtxoko. Txesusu yonyxe momohtxow hamà, kekon hatà. Nasarye honotho rma, amoyathosahotho rma yonyxe momohtxow hamà. Nasanàmno ha, àwayehxemo kom waye, kekon hatà. Tan ehxera naha. Xenytxoko, àwyanye enamàthàràtho, kekon hatà, noro, woràskomo komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ekarymatxatxko, ànhananàhrà rotho komo wya, kekon hatà. Petru wya ryhe ekarymatxatxko. Onà wyaro màketxhe ha, àwyanye. Oywahonye ten hatà, Karyeryeya yamtar hona, màketxhe ha, àwyanye, kekon hatà. Àto menyatxow hatà, màketxhe xarha, àwyanye. Àro wyaro rma noskarymay hatà, owyanye, màketxhe ha, Petru komo wya, kekon hatà, toto wyarono, woràskomo komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Toh yowtar yaye nahatakatxownà harha tà, woràskomo komo. Nekahtàmtxownà hatà. Àsok tawro hana, tàràrànàmrà kom ke rma haxa mak hatà, toseryehokanàr kom ke rma haxa mak hatà. Anar komo wya ekarymahra nehtxownà hatà, toseryehrà kom ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Domenku yonmahàtxhe rma, nasanàmye hatà, Txesusu. Tasanàmàtxhe rma, nosonyhoy hatà, Maryeya wya, Maknara honotho wya. Noro htxero nenyey hatà. Worokyamo yoh me tehxemànhàràtho rma mok nehxakon hatà, Maryeya, 7 komo yoh me tehxemànhàràtho rma hatà, Txesusu nenyhoryetxhàràtho rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tàwya Txesusu yonyetxhe, toy hatà, noro. Akorono rotho komo wya ekarymaxe toy hatà. Nyamoro ryhe, nekhoketxkon hatà. Nàratetxkon xarha tà, Txesusu hnànà. Àwyanye rma nekarymay hatà, Maryeya. ");
INSERT INTO hixNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tonyxerye harha manay ha, kekon hatà, àwyanye. Noro rma wenyo, kekon hatà. Tàwyanye enytxatxhe rma, àro wyaro hamà kahra rma nehxatxkon hatà, nyamoro ha. Yaworohra màken hamà, ketxkon mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Àro wyaro tàwyanye enytxatxhe rma, owto ymo hoye totxownà hatà, ukukur komo, asak hatà. Asama yarye àtontokonye rma, nosonyhoy hatà, Txesusu, àwyanye. Anar me harha nyhe nosonyhoy hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Neramatxownà harha tà, nyamoro ha. Owto ymo hona harha totxownà hatà. Nekarymatxownà hatà, tkukur komo wya. Tàwyanye enytxatxhe rma, àro wyaro hamà kahra rma nehxatxkon hatà, nyamoro, Txesusu yakorono rotho komo rma. ");
INSERT INTO hixNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Àro wyaro texetxhenye rma, nemtakmatxownà hatà, nyamoro ha, 11 komo rma. Emtakmantokonye rma, Txesusu nosonyhoy hatà, àwyanye. Neytxownà hatà, noro, àro wyaro hamà kanyehnàtho me esnàr kom ke hatà, tàhnawonye atxke rma haxa esnàr kom ke hatà, onà wyaro kanyenhàyamo yoyukhura esnàr kom ke hatà, asanàmsaho amna nenyo kanyenhàyamo yoyukhura esnàr kom ke hatà. Àro ke neytxownà hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Onà wyaro nkekon xarha tà, àwyanye. Àtotxoko, yukryeka yamtar horye, anaro rha owto hona, othoyehra, kekon hatà. Àrwo yonyhorunu ekarymatxoko, toto komo wya, omeroron komo wya, kekon hatà, Txesusu, 11 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Àro yoyuknye kom hak nataymompotxowà, tuna kwaka. Nyamoro rma, tonyhoryexem me mpànà natxhe ha, kekon hatà. Eyuknyehnà kom haxa ryhe, tanàhnohsom me natxhe hampànà, kekon hatà, Txesusu, 11 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Eyuknye komo ryhe, onà wyaro mpànà natxhe ha, kekon hatà. Rahoxetà yonyhetxhe hampànà, toto komo wya. Rano me ryhe worokyamo yowyatxhe hampànà. Anaro rha yana komo rwon yawo nàrwonatxhe xarha hampànà, rahoxet yano me mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Anatoko okoye yahohsatxow hana. Tàwyanye ahosàtxhe rma, eskahnà me rma natxhe hampànà, rahoxet yano me rma rha, kekon hatà. Anatoko tàkrakokemà yonyatxow hana. Tàwyanye enàtxhe rma, ekehàntahra rma natxhe hampànà, rahoxet yano me rma rha, kekon hatà. Ekehàtho komo yonyhoryetxhe xarha hampànà àhonanye tamor komo yenyàr ke. Àro wyaro rma rahoxetà yonyhetxhe hampànà, nyamoro ha, rahosnyenhàyamo, àrwo yonyhorunu yoyuknyenhàyamo, kekon hatà, Txesusu, 11 komo wya, tànhananàhrà rotho komo wya. ");
INSERT INTO hixNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Àro wyaro tàwya katxhe, kahe yaka nasanàmye hatà, Txesusu, Kohkomo. Ehonomnà me xaxa neryewtay hatà, Khoryenkom hanaka hatà, howehehra hatà. ");
INSERT INTO hixNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Totxownà hatà, ànhananàhrà rotho komo, anaro rha owto hon komo hyaka, omeroron komo hyaka. Nekarymatxownà hatà, àwyanye. Kohkomo ryhe nakoronometxkon hatà. Eryehokano yeryhekon hatà, àwyanye, tahoxetà yonyhonàr horà. Àro wyaro yaworon me xaxa àrwon komo hutwamohsekon hatà, toto komo wya.");
INSERT INTO hixNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Teyoferu y, ohyaka àmenhehe. Ehonomnà me rma haxa manaha, omoro ha. Amna kukur wawo nehxakon hatà, Txesusu. Noro yonyenhàyamo rma, nekarymatxownà, amna wya. Àro ma noro yomokàtxhe, nenytxehkatxownà hatà, nyamoro ha. Àrwo yonyhorunu yokarymany komo rma nyamoro ha. Ànekarymatxhàyamo rma menhotxownà hatà, anar komo. Yak natxhe, àmenhonyenhàyamo. Àro ke, uro xarha, àmenhehe, ohyaka. ");
INSERT INTO hixNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Omeroro uhutwatxehkanàr hoko rma haxa wehxakonà, mexe rma haxa mak ha. Yaworo uhutwatxehkanàr hoko rma. wehxakonà. Àro ke, onà wyaro àkeko. Àmenhen haxa hamà, Teyoferu hyaka, àkeko. Omeroro ohxe wekarymatxehkehe, àwya, ronmenhotho ke, àkeko, ");
INSERT INTO hixNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","owya yaworo xaxa uhutwatxho me. Onenytxatxhàr hoko rma, yaworo xaxa uhutwanàr xe wehxaha, owya. Àro ke àmenhehe, ohyaka. ");
INSERT INTO hixNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Xukneya hon komo kayaryet me nehxakon hakahpa tà, Eroknes heno. Noro heno yehtoko rma, àto nehxakon hakahpa tà, toto. Sakaryeyasà rma noro hatà. Khoryenkom màn yonye ro komo kukuru mok nehxakon hatà, noro heno. Akmeyas heno yohamàthàyamo kukur me nehxakon heno hatà. Khoryenkom màn yonye ro kukur komo rma mokyam nehxatxkon hatà, Akmeyas heno yohamàthàyamo. Tàhye nehxakon hatà, Sakaryeyas heno. Esakmew me nehxakon hatà, àhetx yosotà. Aron heno yohamàthàyamo wosàn me nehxakon hatà, Esakmew heno, Khoryenkom màn yonye ro kukur komo wosàn me rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ohxe nehxatxkon hatà, Sakaryeyas komo, àhetx xarha, Khoryenkomo nenyàr me. Noro rwon yawo ro rma haxa nehxatxkon hatà. Tàyweronàhyamatxho kom yawo ro rma haxa nehxatxkon hatà. Atxke manaha katxho mehra ro mak nehxatxkon hatà, nyamoro heno. ");
INSERT INTO hixNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Àhokhura mak nehxatxkon hatà. Esakmew yowan yaka atahohsàra ro mak nehxakon hatà, àhokru. Notxwakomotho me rma haxa nehxakon hatà. Horykomotho me rma rha nehxakon hatà, Sakaryeyas heno. ");
INSERT INTO hixNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ososathànanye yohà natamokyatxkon hatà, Khoryenkom màn yonye ro komo. Anatoko natamokyatxkon hakahpa harha tà, Akmeyas heno yohamàthàyamo. Àtoko rma Sakaryeyas haka rha natamokyakon hatà, Khoryenkomo hyaka. ");
INSERT INTO hixNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Noro rma wahanonkatxownà hatà, ukukur komo, Khoryenkom màn yaka owomtoho me, ownyaku yaknyohso owomtoho me. Onà wyaro yohà wahanonkano yeryatxkon hatà, Khoryenkom màn yonye ro komo. Tàwyanye tohu txko yarymatxho hoye ro yohà, wahanonkano yeryatxkon hatà. Àro wyaro rma àwahanonkaxaho nowomye hatà, Sakaryeyas heno, Khoryenkom màn yaka. ");
INSERT INTO hixNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Àro yawo rma ownyaku yaknyohyakon hatà. Màmyaye nehxatxkon hatà, toto komo, thenyenohnà komo. Khoryenkom yakoro nàrwonatxkon hatà, àwya ownyaku yaknyohnàtoko rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Àtoko rma nosonyhoy hatà, kahe yawono, Sakaryeyas heno wya. Kohkomo yanoto rma mok nehxakon hatà, kahe yawono. Yamata màhto nehxakon hatà, ownyaku yaknyohtoho màhto rma, howehehra hatà. Thatawo nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tàwya noro yonyetxhe rma, noseryehokekon mak hatà, Sakaryeyas heno. Noseryehyakonà rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Onà wyaro haxa nkekon hatà, kahe yawono, àwya. Sakaryeyasà y, oseryehpàra exko, kekon hatà. Oseryehpàra exko. Takoro orwonàmrà yonytxeko, Khoryenkomo, kekon hatà. Àro ke hohten hatà, ohetxe, Esakmewu. Omuru rma nenuryan hatà. Xowaw me ryhe mesohten hatà, kekon hatà, kahe yawono. ");
INSERT INTO hixNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Teryehorye rma haxa mpànà manaha ha. Teryehorye rma rha mpànà natxhe ha, toto komo xarha, thenyenohnà komo, noro yonunur ke mak ha, kekon hatà, kahe yawono. ");
INSERT INTO hixNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ehonomnà me mpànà naha ha, noro ha, Kohkomo nenyàr me, kekon hatà. Ufa xkun yonhàra ro mak naha ha. Kawawaheno rma yonhàra ro mak naha ha, kekon hatà. Noro yowan yawo rma haxa naha ha, Khoryenkom yokato. Enuruhtxehwo ro, ewan yawo rma haxa naha ha, Khoryenkom yokato, kekon hatà, kahe yawono. ");
INSERT INTO hixNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ehsayewyana kukur komo yokyaha harha, noro ha, Khoryenkomo hyaka harha, Kohkomo hyaka harha. Thenyenohnà komo rma yokyaha harha, àhyaka harha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kohkomo ywaho tàtosom me naha ha, noro ha, kekon hatà. Eryeyas heno wyaro, tahoxerye rma haxa naha ha, Khoryenkom yokato yano me mak ha, kekon hatà. Toto komo hananàhyaha ha, thokru komo hnàn yaw harha ehtxoho menye. Khoryenkomo yoyuknyehnàtho komo xarha hananàhyaha, enyhoru komo wyaro takàhso harha ehtxoho menye. Àro wyaro hananàhyatxhe ha, omuru, Kohkomo yomoknàr hona osonyhoryetxho menye, kekon hatà, kahe yawono. ");
INSERT INTO hixNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Onà wyaro nkekon hatà, Sakaryeyasà, kahe yawono wya. Àsok hana màken ha, kekon hatà. Àsok hana, àro wyaro hamà àken ha. Horykomotho me rma haxa wehxaha, urotho. Notxwakomotho me xarha naha, rohetxenho, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Neyukye hatà, kahe yawono. Kakmryeyewu uro, kekon hatà. Khoryenkom yakratawono ro rma uro ha. Ayakoro àrwonàmso ronyaknyo, noro ha. Àro yokarymaxe ronyaknyo. Tonytxahoryemà rma yokarymaxe ronyaknyo, ohyaka, kekon hatà, kahe yawono. ");
INSERT INTO hixNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Àro wyaro hamà kahra mak mahko, rorwon hoko. Àro ke, àrwomra harha manaha hampànà, kekon hatà. Rorwon yawo ro xaxa nenuryaha hampànà, omuru. Àsokentok hana. Khoryenkomo ryhe hutwehe. Enurhura ro rma haka àrwomra roro rma manaha hampànà, àro wyaro hamà kahra oyesnàr ke, kekon hatà, kahe yawono. ");
INSERT INTO hixNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sakaryeyas yahatakanàr hona ro nehxatxkon hatà, toto komo. Àro ke noseryehoketxkon hatà, àramamrà hoko. Àsok tawro nàramamyan harha, Khoryenkom màn yawo, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nahatakay haxa hatà, noro ha. Àrwomra ro mak nehxakon hatà, toto kom yakoro. Tamor ke ryhe nàrwonakon hatà, akoronye. Àrwomra mak nehxakon hatà. Àro ke, onà wyaro nketxkon hatà, toto komo. Kahe yawono nosonyhon hamà, noro wya, Khoryenkom màn yawo ehtoko, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Taa. Tàhkay hatà, Sakaryeyasà. Khoryenkom màn yawo atamokhera harha nehxakon hatà. Toy harha tà, bàn yaka. ");
INSERT INTO hixNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Amnye hohtay haxa hatà, àhetxe, Esakmewu. Ewan yaka rma natahosày hatà, àhokru. Àro ke onà wyaro nkekon hatà, Esakmewu. Rowakryek hamà, Kohkomo, kekon hatà. Rowakryek hamà, rohnàn yawo tesnàr ke. Onà wyaro kahra harha natxow hamà, toto komo, rohoko. Atxke nay hamà, mokro, àhohtahnà ro me tesnàr ke, kahra harha natxow hamà, kekon hatà. Taa. Bàn yawo roro nehxakon hatà. Osonyhohra nehxakon hakahpa tà, toto komo wya. Àro wyaro 5 me nuno yonatkay hatà, Esakmewu. ");
INSERT INTO hixNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Yuhna me rma nehxakon hatà, Esakmewu. 5 me nuno yonatkanyenhàr me rma nehxakon hatà. Àtoko rma Kakmryeyew nyakye xarha tà, Khoryenkomo. Nasarye hona haxa tanoto rma nyakye hatà. Karyeryeya yamtar hono rma àro ha, owto, Nasarye. ");
INSERT INTO hixNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nànyakye hatà, wosà hyaka. Maryeya rma noro ha. Ukukmahnà ro mok nehxakon hatà. Toto hetx me ekarymaxah me rma nehxakon hatà. Xose rma noro ha, Maryeya ynyo. Dafe heno yohamàthàyamo kukuru rma mok nehxakon hatà, noro ha. ");
INSERT INTO hixNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Àro ke nomokye hatà, Khoryenkom yanoto, wosà hyaka. Ha y, kekon hatà, àwya. Ohxe manaha. Towakryexem me manaha. Ayakoro naha, Kohkomo, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Àro wyaro tàwya enytxatxhe rma, noseryehokekon mak hatà, Maryeya. Thenyehra rma haxa noseryehokekon hatà. Nehutwekon hatà. Àsoke nken haryhe, rowya, kekon hatà, tàhnawo. Àsoke nken haryhe, rowya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Maryeya y, kekon hatà, Khoryenkom yanoto. Oseryehokahra exko. Towahke rma haxa naha, Khoryenkomo, ohoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Oyowan yaka natahohsan hatà, ohokru, kekon hatà. Nenuryan hatà, omryerà txko. Txesus me mesohten hatà, kekon hatà, Kakmryeyewu. ");
INSERT INTO hixNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ehonomnà me xaxa naha hampànà, noro ha. Omeroron komo yohon muru omoro ha, katxho me naha hampànà, kekon hatà. Xuknewyana komo kayaryet me noro yeryan hatà, Khoryenkomo, Kohkomo rma. Àhoryen heno komo wyaro, Dafe heno wyaro rma, àkayaryet kom me noro yeryan hatà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Xako heno yohamàthàyamo kayaryet me roro nay hatà, meya roro hatà. Àkayaryet kom me noro yehtxoho, osomtatkahnà ro me nay hatà, kekon hatà, Kakmryeyewu. ");
INSERT INTO hixNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Àsok tawro harha, kekon hatà, Maryeya. Ronyo hyawohra hak wehxaha. Àro ke, àhohtahra wehxan hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Neyukye hatà, Khoryenkom yanoto. Khoryenkom yokato yano me ryhe ohohten hatà, kekon hatà. Omeroron komo yohon yahoxet yano me rma ohohten hatà. Àro ke, enyhoru ro xaxa noro ha katxho me nay hatà, ohokru txko, tonusomà rma, kekon hatà. Khoryenkom muru noro ha katxho me nay hatà, kekon hatà, Kakmryeyewu. ");
INSERT INTO hixNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Esakmew xarha hohteko. Okukuru rma hohteko, kekon hatà. Notxwakomotho rma hohteko. Natahohsako, àmryerà. Àhohtahnà rotho rma hohtek harha. 5 me rma nuno yonatkanyenhàr me naha, yuhna me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Àsok tawro hana. Ehnyahnà ro me mak nay hamà, Khoryenkomo. Ehonomnà xaxa kax mak naha ha, kekon hatà, Kakmryeyewu. ");
INSERT INTO hixNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Àro wyaro hamà, kekon hatà, Maryeya. Kohkom yanoto me hak wehxe. Orwon yawo ro hak wehxe, kekon hatà. Àro wyaro àwya katxhe rma, toy hatà, Khoryenkom yanoto, kahe yawono. ");
INSERT INTO hixNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Àro tàhto rma, towto hoye toy hatà, Maryeya. Mexehra toy hatà, owto txko hona. Xukneya yamtar hono rma àro ha, owto txko. Àto rma naha, àhà, Xukneya yamtarà rma. ");
INSERT INTO hixNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Àto nehxatxkon hatà, Sakaryeyas komo. Àmàn kom yaka rma toy hatà, Maryeya. Nowomye hatà. Komokno, kekon hatà, Esakmewu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Àro wyaro Esakmewu wya enytxatxhe rma, ewan yawo rma nasanàmye hatà, àhokru. Khoryenkom yokato yano me rma haxa nàrwonàmye hatà, Esakmewu, teryewrye ro. ");
INSERT INTO hixNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Towakryexem me rma haxa manaha, omoro ha, kekon hatà, Maryeya wya. Woràskomo komo yoho rma haxa towakryexem me manaha, omeroron komo yoho rma haxa mak ha. Towakryexem me rma haxa naha, ohokru txko, tonusomà rma, kekon hatà, Esakmewu. ");
INSERT INTO hixNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Oyosnaka rma haxa wehxaha, urotho. Kohkom yonà ryhe omoro hatà. Rohyaka rma momokno ha. Àsok tawro hana uro mewakryen ha. Uro mewakryen hamà, rohyaka oyomoknàr ke, Kohkom yon me rma oyesnàr ke, kekon hatà, Esakmewu. ");
INSERT INTO hixNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Owya komokno katxhe rma, rowan yawo rma nasanàmno, rohokru txko, teryehorye rma haxa tesnàr ke hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tàrwon yawo ro naha ha, Kohkomo, rohoko, kany me mehxak hamà. Àro ke, towakryexem me rma haxa manay hamà, kekon hatà, Esakmewu, Maryeya wya. ");
INSERT INTO hixNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Onà wyaro nkekon hatà, Maryeya. Ohxe xaxa nay hamà, Kohkomo, àkehe, rohnawo rma, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Teryehorye rma haxa wehxaha, Khoryenkom hoko. Ronyhoryenye rma noro ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Norohnàtho me rma haxa ryehtoko, moson haxa hak wewakryexe, keknan hamà, Khoryenkomo, rohoko, tanoto hoko, kekon hatà. Àro ke, onà wyaro nketxhe hampànà, toto komo, amnye tonusom komo rma, omeroro. Khoryenkomo newakryetxho me rma haxa nehxakon hamà, Maryeya, ketxhe hampànà, rohoko, kekon hatà, Maryeya. ");
INSERT INTO hixNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Rowakryeno rma haxa mak hamà, Khoryenkomo. Ehonomnà xaxa rma noro ha. Enyhoru ro rma noro ha, kekon hatà, Maryeya. ");
INSERT INTO hixNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Noro hona kàwyanye xenyetoko, kàhnàn kom yawo rma haxa naha, Khoryenkomo, kekon xarha tà. Amnyehran heno komo hnàn yawo rma nehxakonà. Amnyeno rma komo hnàn yaw xarha naha. Amnye tonusom komo hnàn yaw xarha naha, kekon hatà, Maryeya. ");
INSERT INTO hixNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tahoxerye rma haxa nosonyhehe, Khoryenkomo, kàwyanye, kekon hatà. Ehonomnà komo yohon me rma haxa nosonyhehe. Ehonomnà me nosonyatxkonà rma haryhe, nyamoro ha, tàhnawonye. Ehonomnà mehra harha neryatxhe ha, Khoryenkomo, kekon hatà, Maryeya. ");
INSERT INTO hixNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ehonomnà rotho komo rma, ehonomnà mehra harha neryatxhe ha. Norohnàtho kom haxa ryhe, ehonomnà me harha neryatxhe ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ewakryehnà rotho komo xarha, towakryexem me harha neryatxhe ha. Towakryexemà rotho kom haxa ryhe, ewakryehnà me harha neryatxhe ha, kekon hatà, Maryeya. ");
INSERT INTO hixNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ehsayewyana komo yakoronomehe, Khoryenkomo. Tanoto komo rma yakoronomehe, kekon hatà. Onà wyaro nkekon hatà, amnyehra, khoryen heno komo wya, Akmaraw heno komo wya, ehamàthàyamo wya xarha. Ohnàn kom yawo roro wehxaha hampànà, kekon hatà, Khoryenkomo, àwyanye. Àro wyaro tàwya katxhàrànhàràtho yawo ro rma haxa naha ha, kekon hatà, Maryeya. ");
INSERT INTO hixNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Esakmewu hyawo rma hak nehxakon hatà, Maryeya. Noro hyawo rma, 3 me nuno yonatkay hatà. 3 me rma tàwya enatkatxhe rma, towto hona harha toy hatà, Maryeya. ");
INSERT INTO hixNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Neryewhamye haxa hatà, Esakmewu. Nenuruy hatà, kàrà me txko hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Àsok hana nenytxatxownà ha, àhoyen kom ha, àyanan komo xarha. Ekaytà yonytxatxownà hatà. Esakmewu yowakryeno rma haxa mak hatà, Kohkomo, tawro yonytxatxownà hatà. Àro ke, Esakmewu wyaro, teryehorye rma rha nehxatxkon hatà, nyamoro xarha. ");
INSERT INTO hixNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","8 me enmahàtxhe, nomohtxownà hatà, anyyokono ynye komo. Bàryekomo txko yanyyokoso nomohtxownà hatà. Àtoko rma esohtonàr xe xarha nehxatxkon hatà. Àyàm yosot yawo Sakaryeyas me esohtonàr xe nehxatxkon haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Àna matà, kekon mak hatà, àyonà. Xowaw me haxa ryhe tesohtotxe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Àna matà, ketxkon hatà, àwya. Xowaw me ayanan komo yosotà ehxera we naha ha, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Àro ke, onà wyaro nketxkon hatà, àyàmà wya, tamor kom ke. Àsok esohtonàr xe manaye, ketxkon hatà, àwya, tamor kom ke. ");
INSERT INTO hixNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Benhosom soko, kekon hatà, àyàmà, tamor ke. Onà wyaro nmenhoy hatà. Xowaw me ryhe naha, esotà, katxho menhoy hatà. Noseryehokatxownà mak hatà, omeroro. ");
INSERT INTO hixNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Àtoko rma nàrwonakon harha tà, Sakaryeyasà. Nàkrakrantay hatà, unyuru. Ohxe xaxa nay hamà, Khoryenkomo, kay hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Noseryehoketxkon hatà, toto komo, àhoyen komo rma. Omeroro nekarymetxkon hatà, anar komo wya. Nekaytay hatà, Xukneya yamtar horye, tàhànkem horye rma, othoyehra mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Àsok tawro harha, ketxkon hatà, enytxanyenhàyamo, omeroro. Àhoko rma haxa nehutwetxkon hatà, tàhnawonye. Àsok hana ehonomnà me nay ha, enuxenyeno, ketxkon hatà. Thorymamtàhkatxhe rma, ehonomnà me rma haxa nay hamà, ketxkon hatà. Kohkom yahoxet yano me horymamyakon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Khoryenkom yokato yano me rma haxa onà wyaro nkekon hatà, Sakaryeyasà, Xowaw yàmà rma, ànhutwamohsothàr yano me rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ohxe xaxa nay hamà, Khoryenkomo, tkatxe, kekon hatà. Kohkomo rma noro ha, Ehsayewyana komo horyenà ro rma. Tàmryenon komo yonyhoryexe tomohsomà rma noro ha. Àro ke, ohxe xaxa nay hamà, tkatxe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Konyhoryeny komo rma nyakyaha. Ehonomnà xaxa rma nyakyaha. Dafe heno yohamàtho rma, tanoto heno yohamàtho rma nyakyaha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tànànyaknyàrà yokarymekonà rma hatà, tàrwon yokarymanye ro heno komo wya, enyhoru ro heno komo wya, amnyehran heno komo wya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nànyakyaha, àwya kxanhànàtho komo yarymatxho me, Xuknewyanahnàtho komo rma yarymatxho me, kekon hatà, Sakaryeyasà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Àro wyaro kàhnàn kom yawo rma haxa naha hampànà, Khoryenkomo. Onà wyaro nkekon hatà, amnyehra, khoryen heno komo wya. Ohnàn kom yawo rma haxa wehxaha hampànà, kekon hatà, àwyanye. Àro wyaro tàwya katxhàrànhàràtho yawo ro rma haxa nosonyhehe hampànà, kàwyanye, kekon hatà, Sakaryeyasà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Akmaraw heno wya ryhe, onà wyaro nkekon hatà. Kowakryetxhe xaxa mak hampànà, àkehe, owya, ronenytxanàr me xaxa mak ha, kekon hatà, noro heno wya. Àro wyaro àrwonàmàthàrà rma, ohxe xaxa nehxakonà. Àro hutwahkahpàra ro mak naha, Khoryenkomo, kekon hatà, Sakaryeyasà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Àro yawo ro rma, kxanhàn komo yanoto mehra harha keryatxhe hampànà, Khoryenkomo. Kxanhàn kom hona oseryehpàra harha tehxatxhe hampànà. Oseryehpàra rma Khoryenkomo tewakryetxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Anhà hokonohnà ro me tewakryetxhe hampànà. Noro nenyàr me ohxe tehxem me rma tewakryetxhe hampànà. Àro wyaro rma, tano roro rma hak kehtokonye, noro tewakryetxhe hampànà, kekon hatà, Sakaryeyasà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Onà wyaro nkekon xarha tà, buru mryenà txko hoko. Kàrà y, onà wyaro nketxhe hampànà, toto komo, ohoko, kekon hatà. Omeroron komo yohono rwonà yokarymanye ro noro ha, ketxhe hampànà, ohoko, Kohkomo ywaho tàtosom me oyesnàr ke. Noro yomoknàr hona toto komo menyhoryetxhe hampànà, kekon hatà, Sakaryeyasà, buru wya. ");
INSERT INTO hixNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kohkomo wya enyhoryetxho komo muhutwamohsehe hampànà, àmryenon komo wya, kekon hatà, buru hoko. Ayanhànàthàyam hoko noseryewhokehe, Khoryenkomo, màkehe hampànà, àwyanye. Àro wyaro rma oyonyhoryetxhe, màkehe hampànà, àwyanye, kekon hatà, Sakaryeyasà, buru hoko. ");
INSERT INTO hixNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kanhànàthàyam hoko noseryewhokehe hampànà, Khoryenkomo, kekon xarha tà. Khokonye noseryewhokehe hampànà, kàhnàn kom yawo rma haxa tesnàr ke mak ha. Àro hoye ro nomokyaha, kahe yawono, kàhyakanye. Enmahrà wyaro rma nomokyaha, awaràn wawohra harha kehtxoho menye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Awaràn wawon komo wyaro tehxatxhe, yaworon xaxa hutwahra kesnàr komo ke. Twayehso rma tehxatxhe. Noro ryhe, yaworon xaxa hutwamohsehe hampànà, kàwyanye, teryehoryemà ro me harha kehtxoho menye, kekon hatà, Sakaryeyasà. Àro wyaro nkekon hatà, Khoryenkom yokato yano me mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Horymamyakon hatà, bàryekomo, Xowawu. Tahoxerye nehxakon hatà, tàhnawo. Thorymamtàhkatxhe rma, ahehnawo roro nehxakon hakahpa tà. Toto komo wya tosonyhohra ro rma haka, ahehnawo roro nehxakon hatà. Amnye nosonyhoy haxa hatà, àwyanye, Ehsayewyana komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Toto yakenon komo kuknomahoy hatà, Sesa, Homayana komo kayaryetà ymo. Awkustu rma noro ha. Txesusu yonurhura ro rma haka, kuknomahotxownà hatà, tanoto komo wya. Àyakenon komo ukuknomatxoko, omeroro, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Àro ma ukuknomanàr komo mon nehxakon hatà. Serya yamtar hon komo kayaryet me nehxakon hakahpa tà, Seryenyu. Sesa nànyaketxho rma noro ha. ");
INSERT INTO hixNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Àro ke totxownà hatà, toto komo. Towtothàyam hona totxownà hatà. Thoryen heno komo yowtotho hona rma totxownà hatà, tekuknomahotho menye. ");
INSERT INTO hixNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Xose xarha toy hatà. Karyeryeya yamtar hoye toy hatà. Nasarye hoye rma, towto hoye rma, toy hatà. Xukneya yamtar hona toy hatà. Dafe heno yowtotho hona, Beryen hona rma, toy hatà, Xose. Dafe heno yohamàtho kaxe nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Àsna toy hatà, tekuknomahotho me. Maryeya xarha toy hatà, akoro. Àhetx me ekarymaxah me nehxakon hatà, noro ha. Yuhna me rma nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Beryen ho tehtokonye, neryewhamye hatà, Maryeya. ");
INSERT INTO hixNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nenuruy hatà, kàrà me txko hatà. Àro ma àhohtathàrà mok nehxakon hatà. Karamye hatà, àyonà, wom ke. Neryey hatà, okno nyahrà yon yaka. Tarke rma haxa nehxakon hatà, hawana kom mànà. Xose komo yosarà ehxera nehxakon hatà. Àro ke, okno màn yawo nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Beryen màhto nehxatxkon hatà, kahneru yonye ro komo. Owto yonatowo nehxatxkon hatà. Txuf wawo nehxatxkon hatà. Kohsaya toknà komo yonyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Àro wyaro ehtokonye rma, nosonyhoy hatà, kahe yawono. Kohkom yanoto rma nosonyhoy hatà, àwyanye. Nawasmetxownà hatà, Kohkom yawasànà ymo. Bamtotàhkaxe ro nehxakon hatà, awasànà ymo. Noseryehyatxkonà rma haxa mak hatà, kahneru yonye ro komo. ");
INSERT INTO hixNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Oseryehpàra ehtxoko, kekon hatà, kahe yawono, àwyanye. Oseryehpàra ehtxoko. Ronekarymanàrà, tonytxahorye rma haxa naha. Àro hoye ro neryehotetxhe hampànà, toto komo, omeroro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Amnye rma nenuno ha, oyonyhoryenye komo. Dafe heno yowtotho ho nenuno ha. Kryestu ryhe noro ha, Kohkomo rma, kekon hatà, kahe yawono. ");
INSERT INTO hixNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Onà wyaro uhutwamohsehe, owyanye. Enuxenyeno txko menyatxhe, kekon hatà. Wom ke àkaramxaho menyatxhe. Okno nyahrà yon yaka txexaho rma menyatxhe. Àro wyaro uhutwamohsehe, owyanye noro moson hamà katxho me, kekon hatà, kahe yawono, kahneru yonye ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Àro wyaro àwya katxhe rma, noro hyaka nomohtxownà hatà, kahe yawon komo xarha, thenyenohnà komo. Khoryenkom hoko wanotetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ohxe xaxa manaha tkatxe, Khoryenkomo wya, kahe yawono wya, ketxkon hatà. Teryehorye rma haxa natxhe hampànà, toto komo, yukryeka hon komo. Khoryenkomo newakryenàr komo rma, teryehorye natxhe hampànà, ketxkon hatà, kahe yawon komo. ");
INSERT INTO hixNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Àro wyaro tàwyanye katxhe rma, totxownà harha tà. Kahe yaka harha totxownà hatà. Noknomtxownà hatà, kahneru yonye ro komo. Àpa txowà, ketxkon hatà, tàwyanye rma. Owto hona, Beryen hona rma àpa txowà. Kohkomo nhutwamohsotho rma yonyxe àpa txowà, ketxkon hatà, kahneru yonye ro komo. ");
INSERT INTO hixNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Àro ke, karyhe rma haxa totxownà hatà. Maryeya yonytxownà hatà. Xose xarha yonytxownà hatà. Enuxenyeno txko xarha yonytxownà hatà. Okno nyahrà yon yawo nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Àro wyaro tàwyanye xenyetxhe, kahe yawono rwonà yokarymetxkon hatà, kahneru yonye ro komo, toto komo wya. Enuxenyeno yokarymatxhàràtho rma yokarymetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Àsok tawro moro ha, ketxkon hatà, toto komo, enytxany komo, omeroro. Àsok tawro moro ha, ketxkon hatà, àrwon kom hoko, kahneru yonye ro komo nekarymatxho hoko rma. Noseryehoketxkonà rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maryeya ryhe, tàmryerà yokarymatxhàràtho hutwahkahpàra nehxakon hatà. Nehutwekonà rma hatà, tàhnawo. ");
INSERT INTO hixNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Totxownà harha tà, kahneru yonye ro komo. Khoryenkom hoko wanotetxkon hatà, kahe yawono nekarymatxho hoko. Tànenytxatxhàyam hoko rma, tànenyetxhàyam hoko xarha, wanotetxkon hatà. Ohxe xaxa manay hamà. Ehonomnà me xaxa manay hamà, ketxkon hatà, Khoryenkomo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","8 me enmahàtxhe, enuxenyeno txko yanyyokotxownà hatà. Àtoko rma Txesus me nesohtotxownà hatà. Àro wyaro nesohtohoy hatà, kahe yawono, atahohsàra rma hak ehtoko. ");
INSERT INTO hixNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moyses heno wya tàyweronàhyamatxho kom yawo ro tosonyhoryenàr komo xe nehxatxkon hatà, Maryeya komo. Tonuruthuru hoye ro anhàntaxah kax mak nehxakon hatà. Àro ke, tonurutxhe 40 me nenmahye hatà, tàyweronàhyamatxho kom yawo ro hatà. 40 me enmahàtxhe, totxownà hatà, Xerusaryen hona. Thokru txko yatxownà hatà, Khoryenkom màn yaka. Kohkomo wya tonyhosom me natxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Àro hoko rma àyweronàhyamano yeryhoy hatà, Kohkomo, Moyses heno wya. Wahoto rye komo ryhe mekyatxhe ha, rohyaka, rowyano ro me ehtxoho menye, kekon hatà, Moyses heno wya. Kàrà me tehtokonye, rowyano ro me natxhe ha, wahoto rye komo, kekon hatà, noro heno wya. Àro yawo ro nehxatxkon hatà, Maryeya komo. ");
INSERT INTO hixNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Onà wyaro nkekon xarha tà, Kohkomo, Moyses heno wya. Onok kom haxa hana màmyatxow ha, xàhàhà kom haxa hana, watkuku kom haxa hana. 2 me rma màmyatxhe ha, àmxekrà komo rma, kekon hatà, àyweronàhyamano ynyàr me hatà. Àro yawo ro xarha nehxatxkon hatà, Maryeya komo. Tànàmrà komo rma yatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Àto nehxakon hatà, horykomotho. Semyawu rma noro hatà. Xerusaryen ho nehxakon hatà. Ohxe nehxakon hatà. Khoryenkom hokon me nehxakon hatà. Ehsayewyana komo yonyhoryenye hona ro nehxakon hatà. Omoknàr hona ro rma nehxakon hatà. Ewan yawo nehxakon hatà, Khoryenkom yokato. ");
INSERT INTO hixNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Noro ryhe, onà wyaro hutwamohsoy hatà, àwya. Awayehpàtor hak moro, kay hatà, àwya. Kryestu yomokhàra ro rma haka, awayehpàtor hak moro, owya Kohkomo nànyaketxho yonyhera ro rma haka, kay hatà, Khoryenkom yokato, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Àro ke, Khoryenkom màn yaka nowomye hatà, noro ha, Khoryenkom yokato yano me mak hatà. Àtoko rma Txesusu mryenà txko yohtxownà hatà, àyàm komo. Thokru txko yohtxownà hatà, tàyweronàhyamatxho kom yawo ro tehtxoho menye. ");
INSERT INTO hixNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Bàryekomo txko yanàmye hatà, Semyawu, tonaka. Apa y, ohxe xaxa manay hamà, kekon hatà, Khoryenkomo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Rohà y, ayanoto uro. Orwonàmàthàr yawo ro mahko hamà, rohoko. Rowayehpàra ro rma haka, wenyo haxa ha, onànyaketxhàrà, kekon hatà. Amna yonyhoryenye ro rma wenyo haxa ha. Àro ke, teryehorye rma kwayehyan hamà, ayano me mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Onànyaketxhàrà wenyo haxa ha. Amna yonyhoryenye ro rma wenyo haxa ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mosonà mànyakyako, toto komo wya xenytxoho me, anaro rha yana komo wya xenytxoho me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Weyu wya amna yawasmentokono wyaro ohutwamohsehe hampànà, mosonà, Xuknewyanahnà komo wya. Xuknewyana komo xarha, ohxe harha natxhe hampànà, toto komo wya. Moson hoye ro, onà wyaro nketxhe hampànà, toto komo, omeroro. Ohxe xaxa natxow hamà, Xuknewyana komo, Khoryenkomo mryenon komo, ketxhe hampànà, kekon hatà, Semyawu. ");
INSERT INTO hixNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tàwyanye Semyawu rwonà yonytxatxhe rma, koo, ketxkon hatà, àyàm komo, àyon xarha. Àrwon hoko rma noseryehoketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Onà wyaro nkekon xarha tà, Semyawu, àyàm komo wya. Khoryenkom hak oyowakryetxowà, kekon hatà, àwyanye. Onà wyaro nkekon xarha tà, Maryeya wya, àyonà wya. Uro enytxako, kekon hatà, àwya. Ronànyaketxho me naha, mosonà, oyonyhoryeny komo, kany me mpànà naha ha, Khoryenkomo, omryer hoko, Xuknewyana komo wya, kekon hatà. Xanomkahnohyatxhe mak hampànà, ukukur komo. Àro ke natanàhnohpetxhe hampànà, tàwyanye àxanomkahnohrà ke mak ha, kekon hatà. Anar komo, ukukur komo rma, nosonyhoryehetxhe hampànà, moson hona tàwyanye xenyàr ke mak ha, kekon hatà, Semyawu. ");
INSERT INTO hixNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Moson hoko anar me rha nehutwetxhe hampànà, toto komo, tàhnawonye. Ohxe hana, ohxehra haxa hana, nehutwetxow ha. Ehutwatxho komo rma hutwamohsehe hampànà, mosonà, kekon hatà, Maryeya wya. Omoro ryhe, mekhokehe xaxa mak hampànà, moson hoko. Teryewhamso ro mekhokehe xaxa mak hampànà, katxefara ke àharaxkaxaho wyaro mak ha, kekon hatà, Semyawu, Maryeya wya. ");
INSERT INTO hixNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Àto nehxakon hatà, wosà. Ana rma noro hatà. Fanwew heno yomsàrà rma noro hatà, Ase heno komo yohamàthàyamo kukuru rma hatà. Khoryenkomo rwonà yokarymanye ro me nehxakon hatà, noro ha. Notxwakomotho me rma haxa nehxakon hatà. Tànyonye rma hak tehtoko, 7 me txemnyehàntay hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tànyo heno wayhàtxhe, ànyomra harha 84 me txemnyehàntay hatà. Àro ke, notxwakomotho me rma haxa nehxakon hamà. Noro rma, Khoryenkom màn yawo roro nehxakon hatà. Ahatakahra ro mak nehxakon hatà. Kohsaya rma, awasnaw xarha, nàrwonakon hatà, Khoryenkom yakoro. Tano me ro rma natahyehnomekon xarha tà. Àro wyaro Khoryenkomo yowakryekonà roro hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Àto Txesusu mryenà yehtoko rma, nomokye hatà, Ana, àhyakanye. Apa y, ohxe xaxa manay hamà, amna hoko, kekon hatà, Khoryenkomo wya, tàwya Txesusu mryenà yonyàr ke mak hatà. Noro yokarymay hatà, toto komo wya. Tonyhoryeny komo yomohtoho hona ron komo rma nyamoro hatà. Xerusaryen hona nànyakyan hatà, Khoryenkomo, katxhàr hona ro rma nehxatxkon hatà. Nyamoro wya rma Txesusu yokarymay hatà, Ana. ");
INSERT INTO hixNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kohkomo wya tàyweronàhyamatxho kom yawo ro tehtxekatxhenye, totxownà harha tà, Maryeya komo. Karyeryeya yamtar hona harha totxownà hatà, Nasarye hona harha, towto kom hona harha. ");
INSERT INTO hixNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Horymamyakon hatà, àhokru. Karyhe nehxakon hatà. Takàhso rma haxa nehxakon hatà. Khoryenkomo newakryenàr me rma haxa nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Txemnyeh wawo yohà tetxkon hatà, Txesus yàm komo, Xerusaryen hona. Asahxemtono ytxoho na tetxkon hatà. Thoryen heno komo yohokoko àtothàrànhàrà hutwatxho rma àro ha, asahxemtotho komo. Àsna yohà tetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","12 me Txesusu txemnyehàntatxhe, totxownà xarha tà, tàtothàyamo wyaro rma rha. ");
INSERT INTO hixNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Taa. Nenatày hatà, asahxemtotho komo. Enatàtxhe rma, towto kom hona harha tetxkon hatà, Txesus yàm komo. Noknomye mak hatà, Txesusu, bàryekomo. Xerusaryen ho rma noknomye hatà. Oknomàthàrà hutwahra mak nehxatxkon hatà, àyàm komo. ");
INSERT INTO hixNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Akoron komo rma, thenyehra nehxatxkon hatà, Maryeya yanan komo, Xose yanan komo xarha, anar komo xarha. Àro ke, àwawonye rma Txesus hutwetxkonà rma haryhe tà. Tkokmamnohso ro tetxkon hatà. Tkokmamàtxhenye rma, Txesusu yohoryatxkon hatà. Tàyanan kom waha, thoyen kom waha xarha, nehoryatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Xenyhera mak nehxatxkon hatà. Àro ke totxownà harha tà, Xerusaryen hona, àhorà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Osorwawo ro enmahàtxhe, nehotxownà haxa hatà. Khoryenkom màn yawo nehxakon hatà. Àyweronàhyamano ynye ro kom wawo nehxakon hatà. Àwawonye rma eryewtaxaho nehxakon hatà. Nyamoro yonytxekon hatà. Àsok naye, owyanye, kekon xarha tà, àwyanye, anaro rha hoko. ");
INSERT INTO hixNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Noro yonytxetxkon xarha tà, nyamoro ha. Àwyanye rma, àsok naye, owya, tatoko, ohxe rma haxa neyukyatxkon hatà, Txesusu, bàryekomo. Enkukmahnà ro kax mak nehxakon hatà. Àro ke noseryehoketxkon hatà, nyamoro ha, omeroro. ");
INSERT INTO hixNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Àro wyaro àwya eyuknur komo yonytxownà hatà, àyàm komo. Àro ke noseryehokatxownà hatà. Onà wyaro nkekon hatà, àyonà, àwya. Roknà y, àsok tawro amna meryehokek harha, kekon hatà. Amna oyohoryaknano. Apapa xarha oyohoryaknano. Amna noseryehokeknano rma haxa, ohoko, kekon hatà, àyonà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Àsok tawro uro mehoryatxkenan harha, kekon hatà, Txesusu, àwyanye. Royàm màn yawo tehxoryehra kat wehxaknano, owyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Àro wyaro àwya katxho hutwahra mak nehxatxkon hatà, àyàm komo. ");
INSERT INTO hixNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Akoronye toy hatà, Txesusu. Nasarye hona nahatakatxownà hatà. Tàyàm komo yoyukyakon hatà. Tàyon xarha yoyukyakon hatà. Noro rwonàmàthàrà hutwahkahpàra nehxakon hatà, àyonà. Nehutwekonà rma hatà, tàhnawo. ");
INSERT INTO hixNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Horymamyakon hatà, Txesusu. Horykomo me nyhe nehxakon hatà. Takàhso nyhe nehxakon hatà. Khoryenkomo newakryenàr me rma haxa nehxakon hatà. Toto komo newakryenàr me xarha nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tàrwon yokarymahoy haxa hatà, Khoryenkomo, Xowaw heno wya. Àsokentok hana. Sesa me Txekmeryu yehtoko, nekarymahoy hatà, àwya. Homayana komo kayaryet me rma, 15 me àtxemnyehàntaxaho mok nehxakon hatà, Txekmeryu. Àtoko rma, Xukneya yamtar hon komo kayaryet me nehxakon hakahpa tà, Ponseyu Peratusu. Àtoko rma, Karyeryeya yamtar hon komo kayaryet me nehxakon hakahpa tà, Eroknesà. Àtoko rma, noro yowtà ryhe, Feryepe rma, anar komo kayaryet me nehxakon hakahpa tà. Eturyeya yamtar hon komo kayaryet me rma, Tàrakonetes yamtar hon komo kayaryet me xarha, nehxakon hakahpa tà, Feryepe. Àtoko rma, Akmeryene yamtar hon komo kayaryet me nehxakon hakahpa tà, Ryesanyasà. ");
INSERT INTO hixNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Àtoko rma Khoryenkom màn yonye ro komo yoh me nehxatxkon hakahpa tà, Anas komo, Kayfas xarha. Nyamoro yehtoko rma, tàrwon yokarymahoy hatà, Khoryenkomo, Xowaw heno wya. Sakaryeyas heno murunho rma mok nehxakon hatà, Xowawu. Ahehnawo rma tehtoko, Khoryenkomo rwonà yonytxay hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Àro ke toy hatà. Xoknaw horye ro rma tekon hatà, àwararo, mahorye xarha, othoyehra mak hatà. Khoryenkomo rwonà yokarymekon hatà, toto komo wya. Atxke manatxhe, kekon hatà, àwyanye. Anar me harha ayanhànàthàyamo xenytxoko. Ataymompotxok xarha, ohokonye Khoryenkomo yoseryewhokatxho me, àwya ayanhànàthàyamo yowtoho me, kekon hatà, Xowaw heno, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Noro hoko rma menhoy hatà, amnyehra, Esaeyas heno, Khoryenkomo rwonà yokarymanye ro heno. Noro heno karyehtan yawo rma, onà wyaro nkehe, ànmenhothàrànhàrà rma. Onà wyaro nkehe hampànà, ahehnawono, teryewrye ro. Kohkomo ryhe nomokyan hatà, àro ke osonyhoryetxoko, kehe hampànà, toto komo wya. Tkayaryet komo yomoknàtoko, esamar komo yonyhoryetxow hamà, àmryenon komo. Àro wyaro rma rha, oyowan komo enyhoryetxoko, owyanye Kohkomo rwonà yonytxatxho me, kehe hampànà, ahehnawono. ");
INSERT INTO hixNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Takawanke asamatho yehtoko, nanohketxow hamà, kehe hampànà. Tàhànke ehtoko, àheterunuthuru yowyatxow hamà, kehe hampànà. Tokemxe ehtoko, hàràsàhse harha neryatxow hamà, kehe hampànà. Ketxetx me ehtoko, ketxetxenketxow hamà, kehe hampànà. Asamatho wyaro, atxke manatxhe, omnyam ha. Àro ke, osonyhoryetxok xaxa mak hampànà, kehe hampànà. ");
INSERT INTO hixNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Konyhoryenye ro komo nyakyan hatà, Khoryenkomo. Noro yonyatxhe xaxa mak hampànà, toto komo, omeroro, kehe hampànà, ahehnawono, toto komo wya. Àro wyaro rma nkehe, Esaeyas heno nmenhotho. ");
INSERT INTO hixNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Xowawu hyaka nomokyatxkon hatà, toto komo, thenyenohnà komo. Àwya ataymomposo nomokyatxkon haryhe tà. Onà wyaro haxa nkekon hatà, Xowawu, àwyanye. Okoye wyaro atxke manatxhe, kekon hatà. Ayataymomrà komo xe rma manatxhe haryhe, oyoseryehrà komo ke mak ha. Ewakhàra Khoryenkom yehtxoho hona moseryehyatxow hamà. Amnye kanàhnohyatxhe hampànà, Khoryenkomo, katxho hona rma moseryehyatxow hamà, kekon hatà. Àro wyaro rma rha, weheto krunke nekahtàmyaha, okoye, kekon hatà, Xowawu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Anar me harha ranhànàtho wenyaha, màketxhe rma haryhe. Àhnànkahra mak manatxhe ha, kekon hatà. Anar me harha ranhànàtho wenyaha kany me oyehtokonye, ayanhàn komo àhnànkatxoko, ohxe harha oyosonyhotho menye. Onà wyaro rma màketxhe haryhe, kekon hatà. Ohxe rma haxa tehxatxhe, Akmaraw heno yohamàtho kaxe, màketxhe rma haryhe. Àro wyaro kahra ehtxoko, kekon hatà. Onà wyaro haxa ryhe àkehe, owyanye. Akmaraw heno yohamàtho me marma oyehtxoho komo ryhe, ohxehra ro mak naha, Khoryenkomo wya, kekon hatà. Àsok tawro hana. Akmaraw heno yohamrà me marma toto yesnàr xehra nay hamà, Khoryenkomo, kekon hatà. Noro heno yohamrà me marma toto yesnàr xe tehtok haxa, tohu txkotho yakàhtonàràtho haryhe àwya, Akmaraw heno yohamrà me harha. Ehnyahnà ro kax mak naha ha, noro ha, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Àsok hana nay ha, natàtho ha. Ehetahra ehtoko, tamaxem me nay hamà, kekon hatà. Àmxathàr me ro rma tawotosom me nay hamà. Amaxahotho rma, weheto waka tarymaxem me xarha nay hamà, kekon hatà. Àro wyaro rma rha tanàhnohsom me rma manatxhe hampànà. Ayanhàn komo hnànkahra oyehtokonye, mexehra rma haxa ayanàhnohtàketxhe hampànà, Khoryenkomo, kekon hatà, Xowawu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Àsoke ryhe amna naye, ketxkon hatà, toto komo. Àsoke ryhe amna naye, ohxe harha amna yehtxoho me, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Onà wyaro neyuhtxownà hatà, Xowawu. Owakryeno txetxoko, kekon hatà. Owakryeno txetxoko. Twomunke oyehtokonye, 2 me ehtoko, 1 me rma tàmtxoko, toto wya, àwomumnutho wya, kekon hatà. Àro wyaro rma rha, tànyahke oyehtokonye, àhoye rma tàmtxoko, toto komo wya, ànyahpànàtho komo wya, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tkayaryet komo txenyerunu yahosnye ro komo xarha, ataymomposo nomohtxownà hatà. Khananàhnye y, ketxkon hatà, Xowawu wya. Àsoke ryhe amna naye, ohxe harha amna yehtxoho me, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Onà wyaro neyuhtxownà hatà, Xowawu. Owyanye toto komo txenyerunutho yahosnàtoko, eho nyhe ahohsàra ro mak ehtxoko. Oyoh komo rwonàmàthàr yawo ro rma ahohtxoko, kekon hatà, Xowawu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Àto nehxatxkon xarha tà, arymano ynye ro komo. Àsoke ryhe amna naye, ohxe harha amna yehtxoho me, ketxkon hatà, nyamoro xarha, Xowawu wya. Onà wyaro neyuhtxownà hatà, noro ha. Àsok hana manatxow ha, kekon hatà, àwyanye. Àsok hana manatxow ha. Toto heno komo yotahany me manatxow hatà, omnyamo, owyanye àtxenyerunuthuyamo yahohtoho me. Anatoko toto komo wàràhyakany me manatxow hatà, owyanye àtxenyerunuthuyamo yahohtoho me, kekon hatà. Àro hokohra harha ehtxok hampànà. Otxenyerunu ro kom hoko rma teryehorye ehtxoko. Ayanotomany komo nàmàtho hoko rma, teryehorye ehtxoko, kekon hatà, Xowawu, arymano ynye ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Koo, onokà ryhe mosonà, ketxkon hatà, toto komo, tàhnawonye. Onà wyaro katxhàr me moson naye. Amnye nomokyaha hampànà Kryestu katxhàr me moson naye, ketxkon hatà. Àro wyaro rma nehutwetxkon hatà, tàhnawonye. Xowaw hoko noseryehoketxkon hatà, toto komo, omeroro. ");
INSERT INTO hixNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Àro ke, onà wyaro nkekon hatà, Xowawu, àwyanye. Tuna kwaka ryhe kaymomyatxhe, uro ha, kekon hatà. Nomokyaha, anaro, rohryetayo. Rohono rma haxa noro ha. Àhrorà womun yasotà wompokahra wehxaha, esnaka rma haxa ryesnàr ke, kekon hatà. Noro ryhe, anar me ayaymomyatxhe ha. Khoryenkom yokato nyakyaha, ohonanye. Ayaymomtoho komo rma àro ha, noro wya, kekon hatà. Ayaymomyatxhe xarha. Weheto waka txexaho wyaro ayaymomyatxhe, oyonyhoryenàr kom horà, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Àsok hana natxow ha, nasànasà hotnye ro kom ha. Uhpunkatxho yaryatxow hamà. Nasànasà hpunketxow hamà, kekon hatà. Nasànasà ryhe, enyhoru rma yohamnohyatxow hamà, nyah màn yaka. Uhpunuthur haxa ryhe yaknyohyatxow hamà, weheto waka, kekon hatà. Àro wyaro rma rha wahanonkano yeryaha hampànà, noro ha, tomohsomà. Mexehra rma haxa wahanonkano yxe nomokyaha. Enyhoru komo yohamnohyaha hampànà, bàn yaka. Anhàtho kom haxa ryhe yanàhnohyaha hampànà, meya roro, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Àro wyaro nekarymekon hatà, toto komo wya. Anaro rha ke thenyehra nekarymekon hatà. Tonytxahoryemà rma yokarymekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Àtoko rma, Karyeryeya yamtar hon komo kayaryet me nehxakon hakahpa tà, Eroknesà. Towtà hetxenho yahosày hatà, noro ha. Erokneyasà rma yahosày hatà. Anaro rha tanhàn hoko xarha atxke rma haxa nehxakon hatà. Àro ke noro yoyey hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Amnye, tanhànàthàr yoho rma haxa, onà wyaro atxke nexey hatà, Eroknesà. Xowaw heno yahryempoy hatà, watxa ymo yaka. ");
INSERT INTO hixNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Toto komo yaymomtàhkatxownà hatà, Xowaw heno. Txesus xarha yaymomye hatà. Noro heno wya taymomàtxhe rma, Khoryenkom yakoro nàrwonakon hatà, Txesusu. Àrwonàmnàtoko rma, natahurmakay hatà, kahe. ");
INSERT INTO hixNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nàhtoy hatà, Khoryenkom yokato. Tohànke rma nàhtoy hatà. Watkuk me rma nàhtoy hatà, Txesus hona. Nàrwonàmye hatà, kahe yawono. Romuru omoro, kay hatà. Ronàhnàn xaxa omoro ha. Ohoko teryehorye rma haxa wehxaha, kay hatà, kahe yawono. ");
INSERT INTO hixNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Hananàhno yxe nomokye haxa hatà, Txesusu. 30 me àtxemnyehàntaxah me hana nehxakon ha. Xose muru me noro hutwetxkonà rma haryhe tà, toto komo. Txesus horyen heno yosot komo on ha. Erye heno muru me nehxakon hatà, Xose. ");
INSERT INTO hixNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matate heno muru me nehxakon hatà, Erye heno. Ryefe heno muru me nehxakon hatà, Matate heno. Mawke heno muru me nehxakon hatà, Ryefe heno. Xanay heno muru me nehxakon hatà, Mawke heno. Xose heno muru me nehxakon hatà, Xanay heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matateyas heno muru me nehxakon hatà, Xose heno. Amos heno muru me nehxakon hatà, Matateyas heno. Naun heno muru me nehxakon hatà, Amos heno. Esrye heno muru me nehxakon hatà, Naun heno. Nakay heno muru me nehxakon hatà, Esrye heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maate heno muru me nehxakon hatà, Nakay heno. Matateyas heno muru me nehxakon hatà, Maate heno. Semey heno muru me nehxakon hatà, Matateyas heno. Xose heno muru me nehxakon hatà, Semey heno. Xokna heno muru me nehxakon hatà, Xose heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Xoanan heno muru me nehxakon hatà, Xokna heno. Hesa heno muru me nehxakon hatà, Xoanan heno. Sorokmakmew heno muru me nehxakon hatà, Hesa heno. Sarateyew heno muru me nehxakon hatà, Sorokmakmew heno. Nerye heno muru me nehxakon hatà, Sarateyew heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Mewke heno muru me nehxakon hatà, Nerye heno. Akne heno muru me nehxakon hatà, Mewke heno. Kosan heno muru me nehxakon hatà, Akne heno. Ewmaknaw heno muru me nehxakon hatà, Kosan heno. Er heno muru me nehxakon hatà, Ewmaknaw heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Xoswe heno muru me nehxakon hatà, Er heno. Eryeyeser heno muru me nehxakon hatà, Xoswe heno. Xoryen heno muru me nehxakon hatà, Eryeyeser heno. Matate heno muru me nehxakon hatà, Xoryen heno. Ryefe heno muru me nehxakon hatà, Matate heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Semyaw heno muru me nehxakon hatà, Ryefe heno. Xukna heno muru me nehxakon hatà, Semyaw heno. Xose heno muru me nehxakon hatà, Xukna heno. Xonan heno muru me nehxakon hatà, Xose heno. Eryeyaken heno muru me nehxakon hatà, Xonan heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meryeya heno muru me nehxakon hatà, Eryeyaken heno. Mena heno muru me nehxakon hatà, Meryeya heno. Matata heno muru me nehxakon hatà, Mena heno. Natan heno muru me nehxakon hatà, Matata heno. Dafe heno muru me nehxakon hatà, Natan heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Xese heno muru me nehxakon hatà, Dafe heno. Okmekne heno muru me nehxakon hatà, Xese heno. Boas heno muru me nehxakon hatà, Okmekne heno. Sara heno muru me nehxakon hatà, Boas heno. Nasaw heno muru me nehxakon hatà, Sara heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Amenaknakme heno muru me nehxakon hatà, Nasaw heno. Aknemen heno muru me nehxakon hatà, Amenaknakme heno. Ahne heno muru me nehxakon hatà, Aknemen heno. Esraw heno muru me nehxakon hatà, Ahne heno. Peryes heno muru me nehxakon hatà, Esraw heno. Xukna heno muru me nehxakon hatà, Peryes heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Xako heno muru me nehxakon hatà, Xukna heno. Esake heno muru me nehxakon hatà, Xako heno. Akmaraw heno muru me nehxakon hatà, Esake heno. Tera heno muru me nehxakon hatà, Akmaraw heno. Nakoh heno muru me nehxakon hatà, Tera heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruke heno muru me nehxakon hatà, Nakoh heno. Rakawu heno muru me nehxakon hatà, Seruke heno. Faryeke heno muru me nehxakon hatà, Rakawu heno. Ekmeh heno muru me nehxakon hatà, Faryeke heno. Sara heno muru me nehxakon hatà, Ekmeh heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kaynan heno muru me nehxakon hatà, Sara heno. Ahfaxakne heno muru me nehxakon hatà, Kaynan heno. Sem heno muru me nehxakon hatà, Ahfaxakne heno. Nowe heno muru me nehxakon hatà, Sem heno. Rameke heno muru me nehxakon hatà, Nowe heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metusaryen heno muru me nehxakon hatà, Rameke heno. Enoke heno muru me nehxakon hatà, Metusaryen heno. Xaryete heno muru me nehxakon hatà, Enoke heno. Maryeryew heno muru me nehxakon hatà, Xaryete heno. Kaynan heno muru me nehxakon hatà, Maryeryew heno. ");
INSERT INTO hixNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos heno muru me nehxakon hatà, Kaynan heno. Setxe heno muru me nehxakon hatà, Enos heno. Aknaw heno muru me nehxakon hatà, Setxe heno. Aknawu ryhe, Khoryenkom muru me nehxakon hatà, noro nakàhtotho kaxe. ");
INSERT INTO hixNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Xoknaw yohoye ro harha toy hatà, Txesusu. Ewan yawo rma haxa nehxakon hatà, Khoryenkom yokato. Noro rma narày hatà, ahehnaka. ");
INSERT INTO hixNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ahehnawo rma, 40 me nenmahye hatà, Txesusu. Noro kukmekon haryhe tà, worokyamo yohà ymo. Txesusu wya toyuknur xe nehxakon haryhe tà. Ahehnawo roro tehtoko, ànyahpàra ro mak nehxakon hatà, Txesusu. Ànyahpàra rma 40 me tonmahàtxhe, nahyehtàkaye rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Onà wyaro nkekon hatà, worokyamo yohà ymo, àwya. Khoryenkom muru me oyehtoko, owru akàhtoko, kekon hatà. Onà wyaro rma kasko, tohu wya, onà wya. Ekeyu me harha exko, kasko, tohu wya, kekon hatà, worokyamo yohà ymo. ");
INSERT INTO hixNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Àna matà, kekon mak hatà, Txesusu, àwya. Onà wyaro haxa nkehe, Khoryenkom karyehtanà, àmenhosahonhàrà rma. Nyah marma hoye rohra karyhe tehxatxhe. Àro wyaro rma nkehe, àmenhosahonhàrà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Taa. Txesusu yarày hatà, worokyamo yohà ymo. Àhà ymo yawnukye hatà. Àsok hana nenyhoy ha, Txesusu wya. Toto komo, ehonomnà komo xarha, àmryenon komo xarha, ewto komo xarha, uyukryekan komo xarha, omeroro rma nenyhotàhkay hatà, àwya. Dàk, àtoko ro rma nenytxehkatxownà hatà, Txesusu, worokyamo yoh yano me. ");
INSERT INTO hixNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Onà wyaro nkekon hatà, noro ymo. Onenyetxhàrà rma wàmyaha, omeroro, owya, kekonà rma haryhe tà, Txesusu wya. Omeroron komo yoh me harha keryaha. Ehonomnà me xaxa keryaha, kekonà rma haryhe tà. Omeroron komo yohà rma uro ha. Àro ke, rano me ro rma wàmyaha, ronwahanonkatxho komo wya, kekonà rma haryhe tà, worokyamo yohà ymo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ehurkako, rakrataka. Ehonomnà me xaxa manaha, kasko, rowya. Àro wyaro owya katxhe rma, omeroro wàmyaha, owya, kekonà rma haryhe tà, worokyamo yohà ymo. ");
INSERT INTO hixNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Àna matà, kekon mak hatà, Txesusu, àwya. Onà wyaro haxa nkehe, Khoryenkom karyehtanà, àmenhosahonhàrà rma. Oyoh kom me naha, Khoryenkomo. Noro wya ryhe, ehonomnà me xaxa manaha, katxok xaxa mak hampànà, noro wya marma mak ha. Àro wyaro rma nkehe, àmenhosahonhàrà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Taa. Xerusaryen hona xarha narày hatà, worokyamo yohà ymo. Khoryenkom màn ryetàr hona neryey hatà, kakoso rma haxa mak hatà. Khoryenkom muru me oyehtoko, atahrumko, oyoro ro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kahe yawon komo nyakyan hatà, Khoryenkomo, àwyanye okurunhotho me hatà. Àro wyaro rma nkehe, àmenhosahonhàrà, kekon hatà, worokyamo yohà ymo. ");
INSERT INTO hixNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Okurunhetxow hatà, kahe yawon komo, toh hona oyehrotkahanàr hona. Àro ke atahrumko, kekon hatà, worokyamo yohà ymo. ");
INSERT INTO hixNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Àna matà, kekon mak hatà, Txesusu. Onà wyaro haxa nkehe, Khoryenkom karyehtanà, àmenhosahonhàrà rma. Oyoh kom me naha, Khoryenkomo. Noro hak ukukmaxe kahra ehtxoko. Àro wyaro rma nkehe, àmenhosahonhàrà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Àro wyaro Txesusu kukmekon haryhe tà, worokyamo yohà ymo. Tàwya ukukmatxehkatxhe rma, toy hatà, àhyaye. Amnye ukukmen xarha hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Karyeryeya yamtar hona harha toy hatà, Txesusu. Khoryenkom yokato yano me, tahoxerye rma haxa nehxakon hatà, tàhnawo. Noro yokaytà yonytxetxkon hatà, toto komo, àro yamtar hon komo, àhorye ron komo xarha, omeroro. ");
INSERT INTO hixNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Anaro rha ohsamnohtoho kom yawo, toto komo hananàhyakon hatà, Txesusu. Ohxe xaxa nay hamà, mosonà, ketxkon hatà, toto komo, omeroro, noro hoko. ");
INSERT INTO hixNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nasarye hona harha toy hatà, Txesusu. Àto àhorymamsaho mok nehxakon hatà. Àton komo yohsamnohtoho yaka toy hatà, hokano ytxoho yawasàn ho. Ohsamnohno ytxoho ro yaka tàtosomà ro kaxe ryhe nehxakon hatà. Khoryenkom karyehtanà rwonàhyamaxe nasanàmye hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Esaeyas heno nmenhotho yàmtxownà hatà, àwya. Khoryenkomo rwonà yokarymanye ro heno rma noro ha, Esaeyas heno. Karyehta ramkay hatà, Txesusu, àhoyen horà. Nenyey haxa hatà. Onà wyaro nehxakon hatà, àmenhosahonhàrà, Txesusu nàrwonàhyamanàrà rma. ");
INSERT INTO hixNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Rohyawono ro me naha, Kohkom yokato. Tokato nyakye, Kohkomo, rohona, tànànyaketxhàr me rohutwamohsotho me. Ronyakye, rowya àrwo yonyhorunu yokarymatxho me, ewakryehnà rotho komo wya enytxatxho me. Anhà yanoto mehra harha keryatxhe kaxe ronyakye, anhà yanoto rotho komo wya. Kontanàhyatxhe harha kaxe rma ronyakye, enhunu rotho komo wya, Khoryenkomo hutwanyehnà rotho komo wya. Anhà neryewhamnohàthotho komo yonyhoryexe ronyakye. ");
INSERT INTO hixNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Amnye rma oyonyhoryenàr komo xe harha naha, Kohkomo, kaxe ronyakye, toto komo wya. Àro wyaro rma nehxakon hatà, àmenhosahonhàrà, Txesusu nàrwonàhyamanàrà rma. ");
INSERT INTO hixNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Karyehta yamye harha tà, Txesusu. Nàmye harha tà, nàmno ymo yonye ro wya. Dyeryey, neryewtay harha tà, Txesusu. Noro yonytxehketxkon hatà, toto komo, ohsamnohxemo komo, omeroro. ");
INSERT INTO hixNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Onà wyaro htxero nkekon hatà, Txesusu, àwyanye. Amnye rma haxa, àro yawo ro naha, Khoryenkomo, kekon hatà. Tkaryehtan hoyen yawo ro rma naha, amnye rma, onenytxanàr kom me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ohxe xaxa nay hamà, mosonà, ketxkon hatà, toto komo, omeroro. Ohxe rma haxa nahko, àrwonà, ketxkon hatà. Àro ke noseryehoketxkon hatà. Xose heno murunho mehra kat naye. Àsok nay haryhe, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Onà wyaro nkekon xarha tà, Txesusu, àwyanye. Àsok kany me hana tehxatxow ha, kekon hatà. Onà wyaro kany me tehxatxow hamà. Ohtxemano ynye me oyehtoko, osohtxemako, kany me tehxatxow hamà. Àro wyaro rma rha, onà wyaro màketxow hamà, rowya, kekon hatà. Kafahnaw ho oyehtoko, onyhoryeno meryaknan hatà. Eryehokano meryaknan hatà. Àro wyaro rma rha onyhoryeno txeryko, tan xarha, oyowto ho rma, amna nenyàr me, onyhoryeno ynye me oyonytxoho me amna wya, màketxow hamà, rowya, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Onà wyaro yaworo xaxa àkehe, owyanye. Khoryenkomo rwonà yokarymanye ro komo yonytxahra ro mak natxhe, toto komo. Towto komo honotho me ehtokonye, enytxahranye ro mak natxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Onà wyaro ryhe, yaworo xaxa àkehe, owyanye, kekon xarha tà. Àsok hana nehxatxkon ha, Eryeyas heno kom ha. Nyamoro heno yehtoko rma, omokhàra ro mak nehxakon hatà, tuna, kekon hatà. 3 me txemnyehàntay hatà, omokhàra rma. 6 me nuno yonatkay xarha tà, omokhàra rma. Ànyahpàra rma haxa nehxatxkon hatà, Xukneya yamtar hon heno komo, omeroro, kekon hatà. Àtoko rma, thenyehra nehxatxkon hatà, enyonkaxemo komo, Ehsayewyana komo rma, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nyamoro yowakryexe Eryeyas heno nyakhera mak nehxakon hatà, Khoryenkomo. Anaro hyaka haxa ryhe noro heno nyakye hatà, kekon hatà. Saryepta hona ryhe nànyakye hatà. Seknon yamtar hono rma àro ha, owto, Saryepta. Àto nehxakon hatà, wosà, enyonkaxaho. Ehsayewyanahnà rma mok nehxakon heno hatà. Noro rma yowakryexe Eryeyas heno nyakye hatà, Khoryenkomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Amnye nyhe rma, Khoryenkomo rwonà yokarymanye ro me nehxakon hatà, Eryesew heno, kekon xarha tà. Noro heno yehtoko rma, thenyehra nehxatxkon hatà, teheryankem komo, hunmata ymo yawon komo rma, Ehsayewyana komo rma. Nyamoro heno yonyhoryehra mak nehxakon hatà, Eryesew heno, kekon hatà. Anaro heno haxa ryhe yonyhoryey hatà. Naaman heno rma yonyhoryey hatà. Serya yamtar hon me nehxakon hatà, Naaman heno. Ehsayewyanahnà rma mok nehxakon heno hatà, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Àro wyaro tawro yonytxatxhe rma, ewakhàra rma haxa nehxatxkon hatà, toto komo, ohsamnohxemo komo, nàmno ymo yawon komo, omeroro. Ehsayewyanahnà komo yowakryey hatà, Khoryenkomo, katxho hoye ro ewakhàra nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Say, nasanàmtxownà hatà. Txom, Txesus yahohtxownà hatà. Owto hoye natxownà hatà. Àhà ymo ryetwo amaxaho ryhe àro ha, owto, Nasarye. Àro ke Txesusu yatxownà hatà, àhà ymo hekoso, tàwyanye akawanà ymo yaka arymanàr horà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nemyarkatxownà mak hatà, Txesusu. Àwahany mak toy hatà. Àhyayenye toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kafahnaw hona toy hatà, Txesusu. Karyeryeya yamtar hono rma àro ha, owto, Kafahnawu. Hokano ytxoho yawasàn ho àton komo hananàhye hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Koo, ohxe rma haxa khananàhyatxow hamà, mosonà, ketxkon hatà, toto komo. Noseryehoketxkon hatà, ehonomnà me rma haxa àwya thananàhrà komo ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Àto nehxakon hatà, toto. Ohsamnohtoho kom yawo rma nehxakon hatà. Worokyamo yohà rma mok nehxakon hatà. Teryewrye ro nàrwonàmye hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Txesusu y, Nasarye honotho y, àsok manaye, amna hoko, kekon hatà. Amna yanàhnohso momokye hamà, kekon hatà. Oywero wehxaha. Khoryenkomo nànyaketxho omoro ha. Enyhoru ro rma omoro ha, kekon hatà, toto, worokyamo yohà rma. ");
INSERT INTO hixNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Neyey mak hatà, Txesusu. Tatàknye exko, kekon hatà, àwya. Otowko ha, toto hyaye, kekon hatà. Toto yarymay hatà, worokyamo. Yukryeka hona narymay hatà, ohsamnohxemo komo yamrakataka rma. Eryewhura rma narymay hatà. Tàwya arymatxhe rma, notowye hatà, àhyaye, kray. ");
INSERT INTO hixNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Koo, noseryehokatxehketxkon hatà, àton komo, omeroro. Onà wyaro nketxkon hatà, tàwyanye rma. Àsoke nkan haryhe, mosonà, ketxkon hatà. Àsoke nkan haryhe. Toyuhsom me àro wyaro nkan hamà, worokyamo wya. Ehonomnà me xaxa àro wyaro nkan hamà, àwya, ketxkon hatà. Moson yoyukyatxow hamà, nyamoro. Noro yano me notowyatxow hamà, toto komo hyaye, ketxkon hatà, toto komo, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Taa. Nekaytekon hatà, Txesusu, othoyehra hatà. Noro yokaytà yonytxetxkon hatà, àton komo, Karyeryeya yamtar hon komo, anaro rha owto hon komo, àhorye ron komo. ");
INSERT INTO hixNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ohsamnohtoho kom yaye toy hatà, Txesusu. Semaw màn yaka nowomye hatà. Àto nehxakon hatà, Semaw hetx yonà. Ekeh me nehxakon hatà, atunano wya. Taknye rma haxa nehxakon hatà. Moson enyhoryeko, ketxkon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Àhyaka haxa toy hatà, Txesusu. Àhnànkako, kekon hatà, atunano wya. Nàhnànkay hatà. Say, àtoko rma nasanàmye hatà, wosà. Natamokyakon harha tà, Txesus komo hyaka. ");
INSERT INTO hixNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kokmamye hatà. Àkokmamàtxhe, nomohtxownà hatà, toto komo. Ekeh komo yokyatxkon hatà, Txesusu hyaka. Anaro rha ke teheryanke nehxatxkon hatà, ekeh komo. Omeroro rma nekyatxkon hatà. Àhonanye rma tamorà yeryey hatà, Txesusu. Omeroro rma nenyhoryetxehkatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Worokyamo komo yowyakon xarha tà, toto komo hyaye. Thenyenohnà komo hyaye notowyatxkon hatà, worokyamo komo. Àhyayenye totownàtokonye rma, nàrwonatxkon hatà, teryewrye ro hatà. Khoryenkom muru omoro ha, ketxkon hatà. Neytxownà mak hatà, Txesusu. Àrwomra ro mak ehtxok hampànà, kekon hatà, àwyanye Kryestu me thutwanàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sa, nenmahye hatà. Toy hatà, Txesusu. Ahehnaka toy hatà. Nehoryatxkon mak hatà, toto komo. Àhyaka haxa nomohtxownà hatà. Amna hyaye àtohra exko, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Anar komo wya xarha àrwo yonyhorunu wekarymehe xaxa mak hampànà, kekon hatà. Àsok hana akayaryet kom me nay ha, Khoryenkom ha. Àro rma wekarymehe xaxa mak hampànà, anaro rha owto hon komo wya. Àsok tawro hana. Àhyakanye ekarymaxe ànyahxaho rma uro, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Àro ke, Xukneya yamtar horye tekon hatà. Anaro rha owto hon komo wya nekarymekon hatà, ohsamnohtoho kom yaw hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Anatoko, Xenesarye kuthon yohoye nehxakon hatà, Txesusu. Noro hona nohtaymetxkon hatà, toto komo, Khoryenkomo rwonà yonytxanàr xe tesnàr komo ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kanawa yonyey hatà, Txesusu. Asak nehxakon hatà, kanawa, tuna yetxehtawo. Àro yaye asanàmsah me nehxatxkon hatà, kana yaramnye ro komo. Txaruka koroketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nosonkahye hatà, Txesusu, kanawa yaka. Semaw kanawarà ryhe àro hatà. Meya nyhe txko uro arko, kekon hatà, Txesusu, Semawu wya. Dyeryey neryewtay hatà. Kanawa yaye ro rma hananàhno yeryey hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tàwya àhananàhtàkatxhenye rma, onà wyaro nkekon hatà, Semawu wya. Meya nyhe àpa txowà, àkhantaka nyhe, kekon hatà. Atxarukan komo arymatxoko, àkhantaka, owyanye kana yaramtxoho me, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Khananàhnye y, kekon hatà, Semawu, àwya. Kohsayantaha ro àhoko rma haxa amna nahko. Arampera ro mak amna nahko ha, kekon hatà. Ayano me mak amna narymehe, txaruka, kekon hatà, Semawu. ");
INSERT INTO hixNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Àro ke narymatxownà hatà. Thenyehra rma haxa kana heno yaramtxownà hatà. Nasawotekon hatà, txaruka heno. ");
INSERT INTO hixNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Àro ke, takoron komo yanyehtxownà hatà, Semaw komo. Anaro kanawa yawon komo rma yanyehtxownà hatà. Omohtxok ha, amna yakoronomaxe, ketxkon hatà, àwyanye. Àro ke totxownà hatà, àhyakanye. Anaro rha kanawa yaka nenkahyatxkon hatà. Kanawa heno nanohye hatà. Owompaya nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tàwya xenyetxhe rma, tano me ro rma nehurkay hatà, Semaw Petru, Txesus yakrataka. Rohà y, ehonomnà me xaxa manay hamà, kekon hatà, àwya. Enyhoru ro omoro hamà. Uro hxako ryhe anhà. Àro ke rohyaye àtoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Àro wyaro nkekon hatà, Semawu, toseryehokanàr ke. Akoron komo xarha, noseryehoketxkon hatà. Tàwyanye kana heno yaramtxoho hoko noseryehoketxkon hatà, Semaw komo, thenyehra rma haxa esnàr ke. ");
INSERT INTO hixNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Àro wyaro rma rha noseryehoketxkon hatà, Txaku komo, Xowaw xarha. Sekmeknew muru komo rma nyamoro ha. Semaw yakoronomanye ro me rma nehxatxkon hatà. Oseryehokahra exko, kekon mak hatà, Txesusu, Semawu wya. Oseryehokahra exko. Amnye, kana yaramtxoho hokohra harha manaha. Toto kom haxa mekyaha hampànà, rohyaka, kekon hatà, Txesusu, Semawu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Txeey katxownà hatà, àtxehtaka. Mahona tasanàmàtxhenye, tkatxhothàyamo hnànkatxownà hatà. Omeroro rma nàhnànkatxehkatxownà hatà. Txesus yakoro harha tetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Anaro owto ho nehxakon hatà, Txesusu. Àto rma ehtoko, àhyaka nomokye hatà, toto. Hunmata ymo yawo rma haxa nehxakon hatà, noro ha. Tàwya Txesusu yonyetxhe rma, akrataka nehurkay hatà, tano me ro rma. Rohà y, kekon hatà. Amna yonyhoryenye omoro hatà. Ronyhoryenàr xe oyehtoko, uro menyhoryen hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Natahoyotkay hatà, Txesusu. Dye, nahey hatà. Oyonyhoryenàr xe wehxaha, kekon hatà. Konyhoryen hampànà, kekon hatà, Txesusu. Àtoko rma nàhnànkay hatà, uhunmatathotho. ");
INSERT INTO hixNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Onà wyaro nkekon xarha tà, Txesusu, àwya. Toto komo wya oskarymahra xaxa mpànà exko ha, kekon hatà. Àtoko. Osonyhota, horykomo wya, Khoryenkom màn yonye ro wya, kekon hatà. Moyses heno nekarymatxho yawo ro, owoknàthàrà màmyaha ha, àwya, kekon hatà. Khoryenkomo wya tàmsomà rma màmyaha ha, enyhoryexah me oyesnàr ke. Àro wyaro rma muhutwamohsehe, oyonyhoryetxhàrà, toto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nekaytay mak hatà, Txesusu, thenyehra rma haxa mak hatà. Àro ke nomokyatxkon hatà, toto komo, thenyenohnà komo. Àhyaka nohsamnohyatxkon hatà, tàwyanye noro yonytxatxho me. Ekeh komo xarha nomokyatxkon hatà, àwya tonyhoryetxho menye. ");
INSERT INTO hixNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ahehnaka mak tekon hatà, Txesusu. Àto rma Khoryenkom yakoro nàrwonakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Anatoko hananàhno yeryakon hatà, Txesusu. Àto nehxatxkon xarha tà, Farysew kukur komo, àyweronàhyamano ynye ro kukur komo xarha. Anaro rha owto hoye omohxemo komo rma mokyam nehxatxkon hatà. Karyeryeya yamtar hon hoye omohxemo komo, Xukneya yamtar hon hoye omohxemo komo xarha, Xerusaryen hoye omohxemo komo xarha nyamoro hatà. Àto nehxatxkon hatà, eryewtaxemo. Kohkom yahoxet yano me, ekehàtho komo yonyhoryekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Àtoko rma nomohtxownà hatà, toto komo. Ekeh yohtxownà hatà, tahon hono rma hatà, amusnaxaho rma hatà. Txesus yakrataka noro yenyàr xe nehxatxkon hatà. Àro ke, nàmno yaka towomrà komo xe nehxatxkon haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Owompàra mak nehxatxkon hatà, thenyehra rma haxa toto komo yesnàr ke. Àro ke nekayàmtxownà hatà, nàmno mkakoso. Tàwyanye àhosokatxhe rma, nenàhtotxownà hatà. Tahon hono rma yonàhtotxownà hatà, toto komo yamrakataka. Txesus yakrataka rma nenàhtotxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Rohona xaxa nenyatxow hamà, kekon hatà, Txesusu, tàhnawo. Àro ke, onà wyaro nkekon hatà, amusnaxaho wya. Hoymo y, koseryewhokan hampànà, ayanhànàthàr hoko. Towsah me harha naha, ayanhànàthàrà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Onà wyaro mak nehutwetxkon hatà, àyweronàhyamano ynye ro komo, Farysew komo xarha. Àsok hana nay ha, mokro ha, ketxkon hatà, tàhnawonye. Khoryenkomo wàràhyakany me nay hamà. Khoryenkom marma ryhe, kanhànàthàyamo yownye me naha. Khoryenkomo wyaro nehutwen hamà, ketxkon hatà, tàhnawonye. ");
INSERT INTO hixNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ehutwatxho komo rma hutwekon hatà, Txesusu, tàhnawo. Àro ke, onà wyaro nkekon hatà, àwyanye. Àsok tawro àro wyaro màketxow haryhe, ohnawonye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Rowya, towsah me harha naha, ayanhànàthàrà, katxho ryhe, tkahoryehra nay hamà, owyanye. Asanàmko, àtok ha, katxho haxa ryhe, tkahorye rma haxa nay hamà, owyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Towsah me harha naha, ayanhànàthàrà, kany me mak wehxaha, Toto me Enusah kaxe. Tano rma yukryeka ho rma ryehtoko, àro wyaro kany me wehxaha, Khoryenkom yano me mak ha, kekon hatà. Àro wyaro kany me hak kehutwamohsosà, owyanye. Moson yeheryanàtho wowyaha hampànà, Khoryenkom yano me ryehutwamohsonàr horà, kekon hatà. Onà wyaro àkehe, owya, kekon hatà, amusnaxaho wya. Asanàmko, ayahon anàmko ha, omàn yaka àtok ha, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Àtoko rma nasanàmye hatà, amusnaxahotho. Sax, ànenyàr kom me nasanàmye hatà. Tahonà yanàmye hatà. Bàn yaka toy hatà, ohxe xaxa nay hamà, Khoryenkomo, tawro me hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Noseryehokatxehketxkon hatà, àton komo, omeroro. Ohxe xaxa nay hamà, Khoryenkomo, ketxkon hatà. Noseryehoketxkonà rma haxa mak hatà. Koo, xenyhenà rotho rma tenytxowà, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Àro tàhto rma toy hatà, Txesusu. Toto yonyey hatà. Ryefe rma noro ha. Tkayaryet komo txenyerunu yahosnye ro rma mok nehxakon hatà. Nàmno yawo nehxakon hatà, eryewtaxaho, txenyeru yahohtoho yawo rma hatà. Rakoro omok ha, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sax, nasanàmye hatà, Ryefe. Omeroro tkatxhothàrà hnànkay hatà. Txesus yakoro harha toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Taa. Ahxemtono yeryey hatà, Ryefe. Txesusu rma yahxemtekon hatà, bàn yawo. Thenyehra rma haxa nyahmano yeryey hatà. Àto nehxatxkon hatà, toto komo, thenyenohnà komo. Tkayaryet komo txenyerunu yahosnye ro komo rma mokyam nehxatxkon hatà. Anar komo xarha, àto nehxatxkon hatà. Omeroro rma, Txesus kom yakoro nasahxemtetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Txesus kom hoko nàrwonatxkon hatà, Farysew komo, àyweronàhyamano ynye ro komo xarha. Onà wyaro nketxkon hatà, Txesusu nhananàhrà ro komo wya. Àsok tawro mokyam yakoro masahxemtetxowà, ketxkon hatà. Atxke natxow hamà, mokyamo, txenyeru yahosnye ro komo rma, atxke natxhe moxamo katxho komo xarha. Àsok tawro masahxemtetxowà, anhà kom yakoro, ketxkon hatà, Farysew komo. ");
INSERT INTO hixNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Àsok hana natxow ha, eheryamnà kom ha, kekon hatà. Ohtxemano ynye ro komo hyaka àtohra natxow hamà, enyhoru komo kaxe. Teheryankem kom marma ryhe, àhyakanye tetxhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Àro wyaro rma rha, rohyaka omokhàra natxhe, ohxe natxhe moxamo katxho komo. Atxke natxhe moxamo katxho kom haxa ryhe, rohyaka nomokyatxhe. Àwyanye rma, anar me harha ayanhànàthàyamo xenytxoko, kanye uro komokye, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Onà wyaro nketxkon hatà, toto komo, Txesusu wya. Kàyweronàhyamatxho kom yawo ro natahyehnometxhe yohà, Xowawu nhananàhrà ro komo, ketxkon hatà. Khoryenkom yakoro nàrwonatxhe yoh xarha. Àro wyaro rma rha natxhe, Farysewu nhananàhrà ro komo xarha, ketxkon hatà. Onhananàhrà ro kom haxa ryhe, atahyehnomahra natxhe haryhe. Nasahxemtetxhe roro mak ha, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Onà wyaro neyuhtxownà hatà, Txesusu. Àsok hana natxow ha, ronhananàhrà ro kom ha, kekon hatà. Thetx yahosnye yakoron komo wyaro natxow hamà. Tàwya thetx yahosnàtoko, tkukur komo yanyekyan hamà, toto. Asahxemtoso nanyekyatxow hamà. Àro ke, tàhyawonye rma hak noro yehtoko, atahyehnomahra natxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amnye àhyayenye tehe, àhehtaxaho. Tàhyayenye àtotxhe rma, natahyehnometxhe hxak hakahpa harha, akoronotho komo, toseryehokanàr komo ke mak ha, kekon hatà. Àro wyaro rma rha natxhe, ronhananàhrà ro komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kuknonano me rma rha, onà wyaro nkekon xarha tà, àwyanye. Rowya ahananàhtoho komo ryhe, wom xenyeno wyaro naha, kekon hatà. Kwomunuthuyamo yenyemrà xe kehtokonye, wom xenyenohnà ke tenyemyatxow hamà. Wom xenyeno yawotohra tehxatxow hamà. Kàwyanye awotontok haxa, atxke harha nay hamà, xenyenotho, kekon hatà. Xenyeno hoyen ke kàwyanye enyemnyetoko rma, atxke rma rha naha, amnyehranotho xarha, àme ryehra tesnàr ke. Àro wyaro rma rha, oyweronàhyamatxhotho kom yawo ro rma haxa oyehtokonye, ronytxanàr xehra manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ufa xkunu wyaro xarha naha, rowya ahananàhtoho komo, kekon xarha tà. Àkawawantaxenyeno wyaro rma naha. Àkawawantaxenyen me ufa xkun yehtoko, arkahra tehxatxow hamà, enàthàrànhàr yaka, okno hutxhothonhàr yaka, amnyehranotho yaka, kekon hatà. Àrotho yaka kàwyanye arkantok haxa, tonàthàrà rakehe. Notukwamyaha hxak ha, àkawawantaxenyenotho. Enàthàrà xarha, natanàhnohyaha hxak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Xenyeno yaka ryhe tarketxow hamà, kekon hatà. Àro wyaro rma rha, rowya ahananàhtoho kom yawo ro rma haxa oyehtokonye, oyweronàhyamatxhotho kom yawo rohra harha manatxow hamà, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ufa xkun yony komo wyaro manatxhe, kekon xarha tà. Mexe àkawawantaxah yehtoko, ohxe rma haxa naha, ufa xkunu, kàwyanye. Kàwyanye enàtxhe, anaro yonyàr xehra tehxatxow hamà. Mexehra àkawawantaxah yehtoko, enàrà xehra tehxatxhe. Àro wyaro rma rha, rowya ahananàhrà komo xehra mak manatxhe, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Hokano ytxoho yawasàn ho, marataha tetxkon hatà, Txesus komo. Tàtontokonye rma, nasànasà hohtyatxkon hatà, ànhananàhrà ro komo. Hutxuhketxkon xarha tà, tamor komo ke. Nenahyatxkon xarha tà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nenytxownà hatà, Farysew kukuru komo. Ha y, ketxkon hatà. Àsok manatxow haryhe. Kàyweronàhyamatxho kom yawo rohra manatxow hamà. Hokano ytxoho yawasàn ho thothoryehra naha, kàwyanye, ketxkon hatà, Farysew komo. ");
INSERT INTO hixNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Khoryenkom karyehtan hutwahra kat manatxowà, Dafe heno kom hoko, kekon hatà. Nyamoro heno xarha, tahyehnàtokonye, kàyweronàhyamatxho kom yawo rohra rma rha nehxatxkon hatà. Nahyehyatxkonà rma haxa mak hatà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Àro ke, Khoryenkom màn yaka nowomye hatà, Dafe heno. Ekeyu yanàmye hatà. Àsoken hana mon nehxakon ha, ekeyu, kekon hatà. Khoryenkom yompataka txexahonhàràtho rma mon nehxakon hatà. Kàyweronàhyamatxho kom yawo ro àro yonahyatxkon hatà, Khoryenkom màn yonye ro kom marma mak ha. Anar komo nenahpàtorà ro mak hatà àro ha. Àrotho rma yonahye hatà, Dafe heno, tahyehrà ke mak hatà. Nàmye xarha tà, takoron komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Onà wyaro nkekon xarha tà, àwyanye. Hokano ytxoho yawasàn yoh me wehxaha, Toto me Enusah kaxe, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Anaro hokano ytxoho yawasàn ho nowomye hatà, Txesusu, ohsamnohno ytxoho ro yaka. Hananàhno yeryey hatà. Àto nehxakon hatà, toto. Amoskurumentaxaho rma mok nehxakon hatà. Howehenohnàtho, teheryanke nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Txesusu yonytxehketxkon hatà, àyweronàhyamano ynye ro komo, Farysew komo xarha. Onà wyaro ryhe nehutwetxkon hamà. Anatoko norotho yonyhoryen hana, on ho, hokano ytxoho yawasàn ho, ketxkon hamà, tàhnawonye. Onà wyaro tawro xe rma nehxatxkon haryhe mà, Txesusu wya. Atxke manaha, kàyweronàhyamatxho kom yawo rohra oyesnàr ke, tawro xe nehxatxkon hamà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ehutwatxho komo rma hutwekon hatà, Txesusu. Onà wyaro nkekon hatà, toto wya, amoskurumentaxaho wya. Asanàmko ha. Xaro omok ha, amna yamrakataka, kekon hatà, àwya. Àro ke nasanàmye hatà. Toy hatà, amrakatakanye. ");
INSERT INTO hixNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Onà wyaro nkekon hatà, Txesusu, Farysew komo wya. Kàyweronàhyamatxho kom yawo ro tehxorye tehxatxow hamà, kekon hatà, àwyanye. Àsok kat wehxano, owyanye. àro yawo ro ryehtxoho me. Hokano ytxoho yawasàn ho, àsok kat wehxano. Onyhoryeno yhera kat wehxano. Anàhnohno ynye me kat wehxano, kekon hatà. Anàmno yhera kat wehxano. Wayehkano ynye me kat wehxano. Àsok kat wehxano, owyanye, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Àhorye ronye nenytxehkatxownà hatà. Atahoyotkako, kekon hatà, toto wya. Natahoyotkay hatà. Ohxe harha nehxakon hatà, amorà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ewakhàra rma haxa nehxatxkon hatà, Farysew komo. Nosonytxetxkon hatà, nyamoro rye rma, Txesus hoko. Àsok teryatxowà, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Àro tàhto rma toy hatà, Txesusu, àh hona. Khoryenkom yakoro àrwonàmso toy hatà. Kohsayantaha ro nàrwonakon hatà, Khoryenkom yakoro. ");
INSERT INTO hixNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Sa, enmahàtxhe rma, tànhananàhrà ro komo yanyekye hatà. Àwayenye rma, 12 me wahanonkatxownà hatà. Ronànyaknyàr komo omnyamo, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Onà wyaro nehxatxkon hatà, esot komo. Anaro Semawu. Petru me harha nesohtoy hatà, Txesusu. Anaro xarha Antrye. Semaw yowtà rma noro ha. Anaro xarha Txaku. Anaro xarha Xowawu. Anaro xarha Feryepe. Anaro xarha Bahtormewu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Anaro xarha Matewsà. Anaro xarha Tome. Anaro xarha Txaku. Awfew muru rma noro ha. Anaro xarha Semawu. Serotes komo yakoronotho rma noro ha. ");
INSERT INTO hixNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Anaro xarha Xuknasà. Anaro Txaku muru rma noro ha. Anaro xarha Xuknasà Eskaryotesà. Txesusu yahohsonye rma noro ha, anhà komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Àh yonàhtotxownà harha tà, Txesus komo. Kràk, horohtxownà hatà, àh yamoronaka. Àto rma nehxatxkon hatà, ànhananàhrà ro komo xarha, thenyenohnà komo rma. Àto rma rha nehxatxkon hatà, anar komo xarha, thenyenohnà komo rma rha. Xukneya yamtar hoye omohxemo komo, Xerusaryen hoye omohxemo komo xarha, Txeru hoye omohxemo komo xarha, Seknon hoye omohxemo komo xarha, àto nehxatxkon hatà. Tuna ymo yohoyen komo rma nyamoro ha, Txeru hon komo, Seknon hon komo xarha. Omeroron komo rma, Txesusu yonytxaxe nomohtàkatxownà hatà. Àwya osonyhoryehos xarha nomohtxownà hatà, ekeh komo. ");
INSERT INTO hixNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Worokyamo neryewhamnohrà komo xarha nomohtxownà hatà. Nenyhoryetxownà hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Noro yahetxahke nehxatxkon hatà, toto komo, omeroro. Àwyanye noro yahetxhe rma, àhyaye notowyakon hatà, noro yahoxetà, enyhoryetxho komo rma. ");
INSERT INTO hixNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nosompotày hatà, Txesusu. Tànhananàhrà ro komo yonyey hatà. Àro ke, onà wyaro nkekon hatà, àwyanye. Àsok hana towakryexe manatxow ha, kekon hatà. Àkatxhomra oyehtokonye, towakryexe rma manatxhe, Khoryenkom yowto hon me oyesnàr komo ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Amnye rma ànyahpàra manatxow hana. Ànyahpàra rma oyehtokonye, towakryexe rma manatxhe, amnye tànyahke rma haxa oyesnàr komo ke mak ha, kekon hatà. Amnye rma mekhoketxow hana. Oyekhokantokonye, towakryexe rma manatxhe, amnye teryehotanàhsom me harha oyesnàr komo ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Oxehranye rma haxa natxow hana, toto komo. Axanomkahnohyatxow hana. Owàràhyaketxow hana. Atxke manatxhe ketxow hana, owyanye, Toto me Enusaho mryenon me oyesnàr komo ke mak ha. Àro wyaro rma ohxehra oyehtokonye, towakryexe rma manatxhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Àro ke teryehorye rma ehtxoko. Ekhokahra mak ehtxoko. Amnye, kahe yaw harha oyehtokonye, towakryexem me rma haxa manatxhe, kekon hatà. Àsok tawro hana. Axanhàn komo horyen heno komo xarha, àro wyaro rma rha Khoryenkomo rwonà yokarymanye ro heno komo yeryewhamnohyatxkon hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Àsok haxa hana manatxow ha. Tkatxhonke rma haxa manatxow hana, kekon xarha tà. Tkatxhonke oyehtokonye, eryehotaxah me rma manatxow hamà, tano rma hak oyehtokonye. Amnye eryehohra harha manatxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Amnye rma tànyahkemà ro me manatxow hana. Amnye haxa, ànyahpàra harha manatxhe hampànà, kekon hatà. Amnye rma tosownohsomà ro me manatxow hana. Amnye haxa mekhoketxhe harha hampànà. Owratetxhe harha hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Amnye rma, ohxe manatxhe ketxow hana, toto komo, omeroron komo, owyanye. Amnye haxa, ohxe manatxhe katxho mehra harha manatxhe hampànà, kekon hatà. Àro wyaro rma rha, ohxe manatxhe ketxkonà rma haryhe tà, àhoryen heno komo, onkuhtono ynye heno komo wya. Nyamoro heno rma nenkuhtetxkon mak hatà. Khoryenkomo rwonà yokarymanye ro uro ketxkonà rma haryhe tà, yaworohra mak hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Onà wyaro haxa àkehe, owyanye, ronytxany komo wya, kekon xarha tà. Axanhàn komo xe ehtxoko. Nyamoro rma ewakryetxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Owàràhyakany kom hoko orwonàmtxoko, Khoryenkom yakoro. Nyamoro ewakryetxoko katxoko, àwya. Oyeryewhamnohnye kom hoko xarha, orwonàmtxoko, Khoryenkom yakoro, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Anatoko oyompokyatxow hana, axanhàn komo. Ohsànàhpàra rma ehtxoko. Onà wyaro haxa katxoko, àwyanye. Uro empoxko rma katxoko, àwyanye, kekon hatà. Anatoko, owomunuthuyamo yaryatxow hana, anar komo. Ohsànàhpàra rma ehtxoko. Anarotho xarha atàhkak ha katxok haxa, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Uro nyhe txko rokatxho ha kanye ro komo eyuhtxoko. Nyamoro rma ewakryetxoko, kekon hatà. Anatoko, akatxhothàyamo yaryatxow hana, anar komo. Rokatxhotho tàmko harha rowya kahra rma ehtxoko, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Oyowakryenàr komo xe manatxow hamà, toto komo wya. Àro wyaro rma rha, anar komo ewakryetxoko, omnyam xarha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Anhà komo wyarohra ohxe oyesnàr komo xe wehxaha, kekon xarha tà. Àro ke, axan komo xe marma oyehtokonye, ohxe manatxhe kahra rma wehxaha, owyanye. Àsok tawro hana. Anhà komo xarha, tàxan komo xe natxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Owyanye oyowakryenyenhàyam marma yowakryentoko, ohxe manatxhe kahra rma wehxaha, owyanye. Àsok tawro hana. Anhà komo xarha, towakryenyenhàyamo yowakryetxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Owyanye akatxho komo yarhontoko soknàr hona ro oyehtokonye, ohxe manatxhe kahra rma wehxaha, owyanye. Àsok tawro hana. Anhà komo xarha, tkatxho komo yarhetxow hamà, tkukur komo wya, soknàr hona ro tesnàr kom horà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Onà wyaro haxa ehtxok ha, anhà komo wyarohra ohxe oyesnàr kom horà. Axanhàn komo xe xa ehtxok ha. Nyamoro rma ewakryetxoko. Àwyanye rma, akatxho komo arhotxoko. Owyanye arhontoko rma, àwyanye soknàr hona rohra ehtxoko, kekon hatà. Àro wyaro rma ohxe oyehtokonye, towakryexem me rma haxa manatxhe hampànà. Àro wyaro rma ohxe oyehtokonye, oyàm komo wyaro ohxe manatxow hamà. Omeroron komo yohono wyaro rma, ohxe manatxow hamà. Noro ryhe, anhà kom hoko towahke naha. Uro txko mewakryeko, ohxe xaxa manaha, kanyehnà kom hoko rma, towahke rma naha, oyàm komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Toto komo hnàn yawo rma haxa naha. Àro ke, noro wyaro toto komo hnàn yawo rma rha ehtxoko, omnyam xarha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Toto komo yanhànà hutwany mehra ehtxoko, kekon xarha tà. Anhàn komo hutwany mehra oyehtokonye, ayanhàn komo hutwany mehra rma rha naha, Khoryenkomo, kekon hatà. Atxke manaha kahra ehtxoko, toto komo wya. Atxke manaha kahra oyehtokonye, atxke manaha kahra rma rha naha, Khoryenkomo, owyanye, kekon hatà. Toto kom hoko oseryewhokatxoko. Oyoseryewhokantokonye, noseryewhokehe xarha, Khoryenkomo, ohokonye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Owakryeno txetxoko. Owakryeno ynye me oyehtokonye, oyowakryetxhe xarha, Khoryenkomo, kekon hatà. Thenyehra rma haxa oyowakryetxhe, amemra ro mak ha, ukuknomahnà ro me mak ha. Ukuknomatxho yoho rma haxa oyowakryetxhe, Khoryenkomo, owyanye ahohtoho yoho rma haxa, kekon hatà. Twahak hana mukuknometxow ha, omnyam ha, thenyehra hana, yakehra haxa hana. Àro wyaro owyanye ukuknomatxhàrà wyaro rma rha, oyowakryetxho komo kuknomehe xarha, Khoryenkomo, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kuknonano me onà wyaro nkekon xarha tà, àwyanye. Àsok hana natxow ha, enhun kom ha, kekon hatà. Enhura tehtokonye, anaro enhun komo yarhàra natxow hamà. Tàwyanye anàtokony haxa, ewtar yaka nehurketxow hamà, anyetho komo. Asahotho komo xarha nehurketxow hamà, kekon hatà. Àro wyaro rma rha natxhe, àhananàhpàn komo. Anar komo hananàhpàra natxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Àsok hana natxow ha, thananàhson kom ha. Thananàhnye komo yosnaka natxow hamà. Àhananàhtàkaxah me tehtokony haxa, thananàhnye komo wyaro harha natxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Kuknonano me rma rha onà wyaro nkekon xarha tà. Ohoyen komo yonuru menyatxow hana, kekon hatà, àwyanye. Enur komo kwawo uhpunu txko menyatxow hana. Hoymo y, uhpunu txko hak wowsà, oyonuru kwaye, màketxow hana, àwya. Àro wyaro owyanye tatoko rma, oyonur komo kwawo rma naha, wewe ymo. Àro ymo yonyhera mak manatxow hamà. Àro wyaro oyehtokonye, onà wyaro tehxorye manatxhe, kekon hatà. Wahoro htxero wewe ymo towtxoko, oyonur komo kwaye rma. Owyanye towàtxhe rma, ohoyen komo yonuru kwaye uhpunu txko mowyatxow hamà, tonke harha oyesnàr kom ke, kekon hatà. Àro wyaro rma rha, ayanhàn kom hoko rma hak oyehtokonye, anar komo hananàhpàrà ro mak manatxow hamà. Owyanye àhananàhnàtokony haxa, yaworonohnà ro me manatxow hamà, ayanhàn kom hokon me oyesnàr komo ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Àsok hana nay ha, nat ha, kekon xarha tà. Ohxe tehtoko, neheten hamà. Atxke haxa tehtoko, ehetahra nay hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Eherà ryhe, nat hutwamohsehe, kàwyanye. Àro ke, ewekhàrà wawo fek yeherà yonyhera tehxatxow hamà. Wakrakra yato wawo ufa yeherà yonyhera tehxatxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Àro wyaro rma rha natxhe, toto komo. Enyhoru me tehtokonye, enyhoru hokono ro me natxow hamà, tehetaxemà wyaro, tàhnawonye ohxe rma haxa tesnàr komo ke, kekon hatà. Anhà me haxa tehtokonye, anhà hokono ro me natxow hamà, ehetahnà wyaro, tàhnawonye atxke rma haxa tesnàr komo ke, kekon hatà. Kàhnawonye ohxe kehtokonye, ohxe tàrwonatxow hamà, toto kom yakoro. Kàhnawonye atxke haxa kehtokonye, atxke tàrwonatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Amna yohà y, Amna yohà y, màketxhe rma haryhe, rowya. Àsok tawro hana. Royukhura ro mak manatxhe ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Anar komo, rohyaka nomokyatxhe. Rorwonà yonytxetxhe xarha. Royukyatxhe xarha. Àsok hana natxow ha, nyamoro ha. Ukuknon komo rma wekarymehe, owyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Bàn yenyàr xe nehxakon hatà, toto. Àro ke, yuhnaka rma haxa nakay hatà. Toh hona bàn yeryey hatà, towaxke ehtxoho me. Amnye nomokye hatà, tuna heno. Nàkmay mak hatà. Dyow, dyow, dyow kekon hatà, tuna ymo, toto màn hoko. Ewuhsura ro mak nehxakon hatà, towaxke txexah me esnàr ke, kekon hatà. Àro wyaro rma rha, atanàhnohpàra ro mak natxhe, royuknye komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Anar kom haxa ryhe, rorwonà yonytxetxhe rma haryhe. Royukhura rma natxhe. Nyamoro kuknon xarha wekarymehe, owyanye, kekon hatà. Bàn yeryey xarha tà, toto, anaro. Yuhnakahra mak nakay hatà. Yukryeka ho rma neryey hatà. Ewahxera rma nehxakon hatà, àmànàthàrà. Àro hok xarha, dyow, dyow, dyow kekon hatà, tuna ymo. Mexehra nemokotoy hatà, àmànàthàrà. Natanàhnohtàkay mak hatà, omeroro, kekon hatà. Àro wyaro rma rha, natanàhnohtàketxhe hampànà, royuknyehnàtho komo, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tàwya toto komo hananàhtàkatxhenye, toy hatà, Txesusu. Kafahnaw hona nahatakay hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Àto nehxakon hatà, horykomo. Arymano ynye ro komo yohà rma mok nehxakon hatà, 100 komo yohà rma hatà. Noro yanoto rma, ekeh me nehxakon hatà. Àwayehpaya rma nehxakon hatà. Horykomo nàhnànà rma haxa mok nehxakon hatà, anoto. ");
INSERT INTO hixNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tàwya Txesusu yokaytà yonytxatxhe rma, anar komo nyakye hatà, horykomo, Txesusu hyaka. Xuknewyana komo rma nyakye hatà, Xuknewyanahnà kaxe. Horykomo komo rma nyamoro hatà, ànànyaketxhàyamo. Omok hatà, horykomo yanototho yonyhoryexe, kaxe nànyahtxownà hatà, Txesusu hyaka. ");
INSERT INTO hixNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Àhyaka tomokàtxhenye rma, onà wyaro nketxkon hatà, teryewrye ro hatà, àwya. Ohxe rma haxa manaye, horykomo, ketxkon hatà, Txesusu wya. Tanwekhoryehra manaye, ");
INSERT INTO hixNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Xuknewyana komo xan me tesnàr ke. Tàtxenyerunuthuru yàmye, amna wya amna yohsamnohtoho ymo yetxoho me, ketxkon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Àro ke toy hatà, Txesusu, akoronye. Sàh sàh sàh sàh sàh sàh. Horykomo màn hahnok haxa nehxatxkon hatà. Moxehra ehtokonye, takoro ron kukur komo nyakye hatà, horykomo, 100 komo yohà, Txesusu hyaka. Onà wyaro nketxkon hatà, ànyahxemo komo, Txesusu wya. Amna yohà y, oyeryehokanàr xehra nay hatà, horykomo, ketxkon hatà. Owomko, romàn yaka, kahra nay hatà, owya, eho rma haxa oyesnàr ke hatà, ketxkon hatà, ànyahxemo komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Àro ke, omokhàra nay hatà, ohyaka, oyosnaka rma haxa tesnàr ke hatà. Wenyhoryen hampànà kasko marma hatà, anototho hoko. Àro wyaro owya katxhe rma, ohxe harha nay hatà, àwya, ketxkon hatà, ànyahxemo komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Àsok hana nay ha, horykomo ha. Owyaro rma rha toh yano me ehonomnà me nay hatà. Àro ke arymano ynye ro komo yanotomen hatà. Àtok ha ken hatà, anaro wya. Noro rma ten hatà, ano me ro mak ha, ketxkon hatà, ànyahxemo komo. Omok ha ken xarha tà, anaro wya. Noro rma nomokyan hatà, ano me ro rma rha. On hok exko ken xarha tà, tanoto komo wya xarha. Àro hoko rma natxow hatà, nyamoro xarha, ano me ro rma rha, ketxkon hatà. Àro wyaro rma rha toyuhsom me manay hatà, omoro xarha, àwya. Àro ke, wenyhoryen hampànà katxhe rma owya, ohxe harha nay hatà, àwya, ketxkon hatà, ànyahxemo komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Àro wyaro tàwya enytxatxhe rma, koo kekon hatà, Txesusu, tàwya rma. Ehonomnà me xaxa ronyan hamà, noro ha, Xuknewyanahnà rma, kekon hatà, tàwya rma. Sara, neramay hatà. Onà wyaro nkekon hatà, toto komo wya, takoron komo wya. Onà wyaro àkehe, owyanye, kekon hatà, àwyanye. Rohona rma haxa nenyan hamà, noro ha. Ehsayewyana komo yoho rma haxa, rohona nenyaha, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Horykomo màn yaka harha totxownà hatà, ànyahxemotho komo. Towomàtxhenye rma, horykomo yanoto yonytxownà hatà. Ohxe harha nehxakon hatà, noro ha, ekehàtho rma. ");
INSERT INTO hixNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Àro tàhto rma toy hatà, Txesusu, anaro owto hona. Naen hona rma toy hatà. Akoro totxownà hatà, ànhananàhrà ro komo, anar komo xarha, thenyenohnà kom hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Owto watxan hotarà hahnohyatxkon hatà. Àhahnok ehtokonye rma, nomohtxownà hatà, toto komo, owto hoye. Toto heno yokyatxkon hatà, enamtoho me hatà. Àwayehsahotho rma yokyatxkon hatà, tehka ho. Tàyon nàhnànàtho txko rma mok nehxakon hatà, àwayehsahotho. Enyonkaxah me xarha nehxakon hatà, àyonànhàrà. Noro rma, owto hoye nomokyakon hatà. Akoro rma nomokyatxkon xarha tà, toto komo, thenyenohnà kom hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nàratekon hatà, àyonànhàrà. Tàwya noro yonyetxhe rma, àhnàn yawo rma haxa nehxakon hatà, Kohkomo. Àratahra exko, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ekehàtho yany komo hyaka haxa toy hatà. Tehka yahey hatà. Kràk, horohtxownà hatà, any komo. Onà wyaro nkekon hatà, Txesusu, ekehàtho wya. Bàryekomo y, asanàmko harha, àkehe, owya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Sax, nasanàmye hatà, ekehàtho. Nàrwonàmye harha tà. Moson harha omryethàrà, kekon hatà, Txesusu, àyonà wya. ");
INSERT INTO hixNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Noseryehoketxkonà rma haxa mak hatà, toto komo, omeroro. Ohxe xaxa nay hamà, Khoryenkomo, ketxkon hatà. Tàrwonà yokarymanye ro nyakyak hamà, kàhyakanye. Ehonomnà xaxa rma nyakyak hamà. Tàmryenon kom yowakryexe nànyakyak hamà, Khoryenkomo, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tàwya ekehàtho yanàmàthàrà hoye ro nekaytay hatà, Txesusu. Noro yokaytà yonytxetxkon hatà, Xukneya yamtar hon komo, omeroro. Anar komo xarha, Xukneya yamtar màhton komo rma, nenytxetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Txesus yokaytà yokarymatxehkatxownà hatà, Xowawu nhananàhrà ro komo, Xowawu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Àhoyenye asako nànyahtxownà hatà, Xowawu, Kohkomo hyaka. Onà wyaro màketxhe ha, Txesusu wya, kekon hatà, àwyanye, asakon komo wya. Amnye nomokyaha, Kryestu, katxhàr hona ro amna naha, màketxhe ha. Noro kat omoro ha, màketxhe ha. Anaro yomoknàr hona ro haxa katà amna naye, màketxhe ha, àwya, kekon hatà, Xowawu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Txesusu hyaka tomokàtxhenye, onà wyaro nketxkon hatà, ànyahxemo komo, àwya. Amna nyaknyo, Xowawu, aymomno ynye ro, ohyaka, ketxkon hatà. Amnye nomokyaha, Kryestu, katxhàr hona ro amna naha, kaxe amna nyaknyo. Noro kat omoro ha kaxe amna nyaknyo. Anaro yomoknàr hona ro haxa katà amna naye, kaxe amna nyaknyo, Xowawu, ohyaka, ketxkon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tàhyawo rma hak ehtokonye, ekehàtho komo yonyhoryekon hatà, Txesusu. Teheryankemàtho komo rma yonyhoryekon hatà. Worokyamo yohàtho komo xarha yonyhoryekon hatà. Enhunutho komo xarha yontanàhyakon hatà. Thenyehra rma haxa nenyhoryetxkon hatà, Txesusu, ànyahxemo komo nenyàr me hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Àro ke, onà wyaro nkekon hatà, Txesusu, ànyahxemo komo wya. Àtotxok harha, kekon hatà. Àtotxok harha. Onenyetxhàyamo mekarymetxhe ha, Xowawu wya. Onenytxatxhàyamo xarha mekarymetxhe ha, àwya. Monentetxow harha, enhunutho komo, màketxhe ha, àwya. Manataryeknohyatxow harha, àhrohnàtho komo, màketxhe xarha, kekon hatà, Txesusu. Monenyhotetxow harha, hunmata ymo yawonotho komo, màketxhe xarha, àwya. Thanak harha manatxowà, àhanahnàtho komo, màketxhe xarha, kekon hatà, Txesusu. Manasanàmyatxow harha, àwayehsahotho komo, màketxhe xarha, àwya. Àrwo yonyhorunu yonytxany me harha manatxowà, toto komo, ewakryehnàtho komo, màketxhe xarha, Xowawu wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kryestu me nay hana, àna hana, kany me kat manatxowà, rohoko. Àro wyaro kahra oyehtokonye, towakryexem me manatxhe ha, kekon hatà, Txesusu, Xowaw nànyaketxho komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Totxownà harha tà, Xowaw nànyaketxho komo. Àtotxhenye rma, onà wyaro nkekon hatà, Txesusu, Xowaw hoko, toto komo wya, ohsamnohxemo komo wya. Ahehnaka otontokonye, toto yonyxe màtetxkon hamà, kekon hatà. Àsok hana nehxakon ha, noro ha. Omamu wyarohra mak nehxakon hamà, atxowowo newusnuru wyarohra mak ha, anar me rha tehutwaxem mehra ro mak ha. ");
INSERT INTO hixNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ehonomnà komo womun yawohra mak nehxakon hamà, kekon hatà. Àsok tawro hana. Ehonomnà kom màn yawo natxow hamà, ehonomnà komo womun yawon komo. Tasahxemtosomà ro komo rma nyamoro hamà. Nyamoro wyarohra mak naha, ahehnawono. ");
INSERT INTO hixNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Àsok haxa naye, kekon hatà, Txesusu. Khoryenkomo rwonà yokarymanye ro me rma haxa nay hamà. Onà wyaro àkehe xarha, owyanye. Ekarymanye ro heno komo yoho rma haxa naha, noro ha, onenyetxhàyamo, kekon hatà, Txesusu, Xowaw hoko. ");
INSERT INTO hixNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Noro hoko rma, onà wyaro nkehe, àmenhosahonhàrà. Ranoto mosonà, kehe, Khoryenkomo. Oywaho ànyakyaha. Osonyhoryetxoko, Kohkomo yomoknàr hona, kehe hampànà, toto komo wya, kehe, Khoryenkomo. Àro wyaro rma nkehe, àmenhosahonhàrà, Xowaw hoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Onà wyaro àkehe, owyanye. Toto komo yoho rma haxa naha, Xowawu. Omeroro enuxemotho komo yoho rma haxa naha, kekon hatà. Norohnàtho kom haxa ryhe, Khoryenkomo mryenon me tehtokonye, Xowaw yoho rma haxa natxhe. Khoryenkomo wya, akayaryet kom me naha, ronànyaketxho, katxho me rma tehtokonye, Xowaw yoho rma haxa natxhe, kekon hatà. Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Àro wyaro tàwyanye enytxatxhe rma, onà wyaro nketxkon hatà, àton kukur komo. Yaworo xaxa nay hamà, Khoryenkomo, khokonye, ketxkon hatà, toto komo, txenyeru yahosnye ro komo xarha, omeroro. Xowaw naymomàthàyam kax mak nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Àna make ryhe mpe, ketxkon mak hatà, Farysew komo, àyweronàhyamano ynye ro komo xarha. Aymompàn komo kax mak nehxatxkon hatà. Khoryenkomo yehutwatxho xanomkahnohtxownà hatà. Tonyhoryetxho komo rma xanomkahnohtxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Onà wyaro nkekon xarha tà, Txesusu, toto komo wya. Àsok hana natxow ha, toto kom ha, amnyeno rma kom ha, kekon hatà. Àsok hana nay ha, ukuknon kom ha. ");
INSERT INTO hixNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bàryekomo txko yewatxarykatxho ryhe, ukuknon kom me nay hamà, kekon hatà. Yakentawo newatxaryketxow hamà, bàryekomo txko komo. Tewatxarykantokonye rma, onà wyaro nketxhe, ukukur komo, anar komo wya. Furwe amna ntxemeknyo. Àsok tawro amna yakoro àmanhohra mahtxoko, ketxhe, àwyanye. Onà wyaro nketxhe xarha. Amna nehokoynyo xarha. Àsok tawro àratahra mahtxoko, ketxhe xarha, àwyanye, tewatxarykanàr kom me, kekon hatà, Txesusu. Bàryekomo wyaro manatxhe. Eyuknyehnà komo wyaro rma manatxhe, omnyamo, amnyeno rma komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Xowawu htxero ryhe nomokye. Aymomno ynye ro rma nomokye. Noro yoyukhura mak mehxatxkonà. Natahyehnomekonà, noro ha. Ufa xkun yonhàra xarha nehxakonà. Noro hoko rma, worokyamo yoh me naha, màketxhe rma haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Toto me Enusah xarha nomokye. Noro ryhe nasahxemtehe. Ufa xkun yonyaha xarha. Noro yoyukhura xarha manatxhe. Noro hoko rma, tasahxemtosomà roro mokro hamà, màketxhe rma haryhe. Ufa xkun yonye roro mokro hamà, màketxhe xarha. Txenyeru yahosnye ro komo yakoron xarha mokro hamà, màketxhe xarha. Atxke natxhe moxamo katxho komo yakoron xarha mokro hamà, màketxhe xarha. Àro wyaro màketxhe rma haryhe, Toto me Enusah hoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Khoryenkomo yehutwatxho hoye ro ryhe, àro wyaro anar me rha nehxatxkonà, Xowaw komo, Toto me Enusah xarha. Toto wyarohra mak nehutwehe, noro ha, kekon hatà. Noro yehutwatxho hutwany kom marma ryhe, onà wyaro nketxow hamà. Yaworo xaxa nehutwen hamà, Khoryenkomo, ketxhe, nyamoro marma mak ha. ");
INSERT INTO hixNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ahxemtono yeryey hatà, toto. Farysew komo kukuru rma mok nehxakon hatà, noro ha. Omoko, emtakmaxe, kekon hatà, Txesusu wya. Àro ke toy hatà, Txesusu, noro màn yaka, Farysew màn yaka. Bo, neryewtay hatà, emtakmaxe. ");
INSERT INTO hixNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Owto ho nehxakon hatà, wosà. Tanhàn hokono rotho rma mok nehxakon hatà, noro ha. Txesus yokaytà yonytxay hatà. Mono manaye, Farysew màn yawo, monemtakmeno, tawro rma yonytxay hatà, wosà. Àro ke nomokye hatà, àmàn yaka. Ownyaku yokye hatà. Toh me nehxakon hatà, ownyaku yonà. Arakmasturu rma mon nehxakon hatà, tohu. ");
INSERT INTO hixNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Txesusu mkaye nomokye hatà, wosà. Ehoye nehxakon hatà, àhrorà yohoye. Nàratekon hatà, tanhànàthàr hoko toseryehokanàr ke. Enakru rma, Txesusu hrorà tukryemekon hatà. Àro ke, tukryenkay harha tà, wosà, tàhpotx ke. Àhrorà yamtxuhkay xarha tà. Karyey xarha tà, ownyak ke. ");
INSERT INTO hixNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nenyakon hatà, Farysewu, Txesusu yahxemtonyenhàrà rma. Tàwya xenyetoko rma, onà wyaro nehutwekon hatà, tàhnawo. Tanhàn hokono ro me nay hatà, mokro, wosà, kekon hatà, tàhnawo. Txesus mak yahehe ha. Àsok tawro hana. Atxke noro yehtxoho hutwahra nay hamà, mosonà. Khoryenkomo rwonà yokarymanye ro me tehtok haxa, wos yanhànà hutwanàràtho haryhe, àwya, kekon hatà, Farysewu, tàhnawo. ");
INSERT INTO hixNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Noro yehutwatxho rma hutwekon hatà, Txesusu. Àro ke, onà wyaro nkekon hatà, àwya. Semawu y, kekon hatà, Farysewu wya. Kàrwonaha, ayakoro, kekon hatà. Hàà, orwonàmko, khananàhnye y, kekon hatà, Farysewu. ");
INSERT INTO hixNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Àro ke, kuknonano me nàrwonàmye hatà, Txesusu. Txenyeru yehetàhketxkon hatà, toto komo, asakon komo, kekon hatà. Nehetàhketxkon hatà, horykomo wya, txenyeru yàmnyenhàràtho wya. Anaro, thenyenohnà ryhe yehetàhkekon hatà, àwya, 500 rma hatà. Anaro, yakenohnà yehetàhkekon hatà, àwya, 50 rma hatà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tàmpàra ro mak nehxatxkon hatà, nyamoro ha, àtxenyerumra tesnàr komo ke hatà. Towahke mak nehxakon hatà, horykomo, àhokonye. Ehemahra rma ehtxoko, rowya, kekon hatà, àwyanye, kekon hatà, Txesusu. Àsok muhutweno, kekon xarha tà, Farysewu wya. Onokà ryhe, horykomo xe rma haxa nehxakonà, owya, thenyenohnà yehetàhkanyenhàràtho katà, yakenohnà yehetàhkanyenhàràtho haxa katà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Hàà, thenyenohnà yehetàhkanyenhàràtho hamà, kekon hatà, Semawu. Noro rma, àxe rma haxa nehxakon hamà, thoko rma towahke rma haxa esnàr ke, thenyenohnà hoko rma ehemahra rma exko tawro ke, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yaworo màkano, kekon hatà, Txesusu, àwya. Neramay hatà, wos wetxe. Onà wyaro nkekon xarha tà, Semawu wya. Moson wosà xenyko, kekon hatà, àwya. Omàn yaka kowomno. Tuna yàmpàra mak mahko, omoro, rowya. Rohrorà korokatxho rma yàmpàra mahko. Moson haxa ryhe, rohrorà tukryemano, tonakru ke. Tukryenkan xarha, tàhpotx ke, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ramtxuhkahra mak mahko, omoro. Rowakeryemekhera rma mahko. Moson haxa ryhe, rowomàtxhe rma rohrorà yamtxuhkehe rye rma, atàknahra roro mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Rohpokaryehra mak mahko, omoro. Moson haxa ryhe, rohrorà karyeno, ownyak ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Àro ke, onà wyaro àkehe, owya. Thenyehra rma haxa nehxaknano, moson yanhànà. Anhànàthàrà rma, towtàhkaxah me harha naha, àhoko roseryewhokanàr ke. Àro ke roxan me rma haxa nosonyhono, owya, kekon hatà. Yakehra naha ranhànà kany kom haxa ryhe, roxehra natxow hamà. Yakehra nay hamà, towsomà, àwyanye. Àro ke, roxe rma natxhe haryhe, atxke txko mak ha, kekon hatà, Txesusu, Semawu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Onà wyaro nkekon xarha tà, wosà wya. Ayanhànàthàr hoko koseryewhokan hampànà. Wowtàhkan hampànà, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Àro wyaro tàwyanye enytxatxhe rma, onà wyaro nketxkon hatà, tàwyanye rma, àton komo, Txesus yakoro temtakmaxem komo rma. Koo, onok mokro ha, ketxkon hatà. Kanhànàthàyamo yownye rma haxa mokro hamà, koo, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Onà wyaro nkekon xarha tà, Txesusu, wosà wya. Enyhoryexah me harha manaha, rohona owya xenyàr ke. Ohxe àtoko, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Àro tàhto rma toy hatà, Txesusu. Anaro rha owto hona toy hatà. Owto ymo hona rma, owto txko hona xarha, toy hatà. Àrwo yonyhorunu yokarymekon hatà, toto komo wya. Àsok hana kàkayaryet kom me nay ha, Khoryenkom ha. Àro rma yokarymekon hatà, toto komo wya. Akoro rma tetxkon xarha tà, 12 komo. ");
INSERT INTO hixNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Akoro rma rha tetxkon hatà, woràskomo komo xarha. Worokyamo yohàtho komo rma mokyam nehxatxkon hatà, ekehàtho komo xarha, enyhoryexemo komo rma hatà. Anaro Maryeya. Maknara honotho katxho rma noro hatà. Noro hyaye notowye hatà, worokyamo, 7 me hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Anaro xarha Xoana. Kusa hetxe rma noro hatà. Eroknes yanoto komo yohà rma noro hatà, Kusa. Anaro xarha Susana. Anar komo xarha, woràskomo komo, Txesus yakoron komo rma, thenyehra nehxatxkon hatà. Txesus komo yomyaràhtetxkon hatà, nyamoro ha, tàtxenyerun kom hoye, tkatxho kom hoy xarha. ");
INSERT INTO hixNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Txesusu hyaka nohsamnohtxownà hatà, toto komo, thenyenohnà komo. Anaro rha owto hoye omohxemo komo rma nyamoro hatà. Tàhyaka ohsamnohàtxhenye, kuknonano me nàrwonàmye hatà, Txesusu, ànenytxanàr kom me. ");
INSERT INTO hixNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Nat yonamso toy hatà, toto, kekon hatà, àwyanye. Onà wyaro nexey hatà, natàtho. Tonamsom hoye nothahye hatà, asama yaka. Àrotho yakmehtxownà hatà, toto komo. Torono heno xarha nenahtxownà hatà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Àhoye rma nothahye xarha tà, toh hona. Nahtaye rma haryhe tà, àrotho. Tahtantoko rma, nuskurumentay hatà, tukryemra tesnàr ke, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Àhoye rma nothahye xarha tà, ewekhàr waka. Àto rye rma horymamtxownà hatà, ewekhàr yakoro. Natàtho yompoymay hatà, ewekhàrà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Àhoyeno rma, tonamsom me haxa nexey hatà, yukryeka taxeronokem waka. Àto nahtay hatà. Horymamye xarha tà. 100 me nehetay hatà, thenyehra mak hatà, kekon hatà, Txesusu. Àro wyaro tàwya katxhe rma, onà, wyaro nkekon xarha tà, teryewrye ro hatà. Uro enytxatxoko, thanak oyehtokonye. Àhanahra kat manatxowà, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Onà wyaro nketxkon hatà, ànhananàhrà ro komo, Txesusu wya. Àsok katxho me rma naye, kuknonano, ketxkon hatà. Àsok katxho me rma naye. Uhutwamohsoko, amna wya, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Àro ke, onà wyaro nkekon hatà, Txesusu, àwyanye. Àsok hana toto komo kayaryet me nay ha, Khoryenkom ha, kekon hatà. Àkayaryet kom me tehtxoho hutwamohsohra rma hak naha, noro, toto komo wya. Owyanye haxa ryhe uhutwamohsehe. Anar komo wya haxa ryhe, uhutwamohsehe rma haryhe. Kuknonano me marma wekarymehe, àwyanye, kekon hatà. Kuknonano me wekarymehe, toto komo wya, uhutwahra rma ehtxoho menye. Khoryenkom yahoxetà yonyatxhe rma haryhe. Noro ywenyeke rma natxhe ha, kekon hatà. Rorwonà yonytxetxhe rma haryhe. Uhutwahra rma natxhe ha, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Onà wyaro nkekon xarha tà, àwyanye. Kuknonano uhutwamohsehe, owyanye, kekon hatà. Natà ryhe, Khoryenkomo rwon kuknon me naha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Asama yaka othahsahotho ryhe, Khoryenkomo rwonà yonytxanyenhàyamo kuknon me naha. Àwyanye enytxatxhe rma, nomokyaha, worokyamo yohà ymo. Ewan yakanye enamsahotho yaryaha, noro ymo ha, ahohsàra rma ehtxoho menye, enyhoryehnà me rma ehtxoho menye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Toh hona othahsahotho ryhe, anar komo kuknon me naha. Khoryenkomo rwonà yonytxetxhe rma haryhe, nyamoro ha. Tàwyanye enytxatxhe rma, teryehorye nahohsatxhe rma haryhe, kekon hatà. Ewan yakanye enamsahotho rma, àmxahnà wyaro mak naha. Mexehra mak nahohsatxhe ha. Anar komo wya teryewhamnohnàtokonye, nàhnànketxhe harha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ewekhàrà waka othahsahotho ryhe, anar komo kuknon me naha. Khoryenkomo rwonà yonytxetxhe rma haryhe, nyamoro xarha. Amnye, tomyawon kom hoko roro mak natxhe ha, kekon hatà. Tkatxhonke rma haxa tesnàr komo xe natxhe xarha. Teryehotanàr kom hoko roro natxhe xarha, tano me rony mak ha. Àro hoye ro, Khoryenkomo rwonà hutwahkahtàketxhe xak hampànà, kekon hatà. Ehetahra mak natxhe ha. Ohxe roro natxhe katxho mehra ro mak natxhe ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Yukryeka taxeronokem waka enamsahotho ryhe, anar komo kuknon me naha. Khoryenkomo rwonà yonytxetxhe, nyamoro ha, kekon hatà. Tàwyanye enytxatxhe rma, ohxe nahohsatxhe, towan yawonye. Ewan komo rma ohxe naha, kekon hatà. Yaworo rma haxa naha. Àro ke, tehetaxemà wyaro ohxe roro rma haxa natxhe, mexe rma haxa mak ha, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kuknonano me xarha nàrwonàmye hatà, Txesusu. Kweyur komo wyaro naha, Khoryenkomo rwonà, kekon hatà. Kweyur komo hotuhtotxhe rma, oryen ke etahurhura tehxatxow hamà. Kahon komo yosnaka txeryhera tehxatxow hamà, kekon hatà. Ahon hona haxa teryatxow hamà. Àro rma ho ehtoko, kweyhetxow hamà. Bàn kom yaka towomsom komo xarha weyhetxow hamà. Àro wyaro rma rha, Khoryenkomo rwonà tekarymetxow hamà, toto komo wya Khoryenkomo hutwatxho me, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Àsok haxa hana nay ha, Khoryenkomo rwonà. Anatoko uhutwahnà me nay hana, kuknonano me rorwonàmrà ke. Uhutwahnàtho rma, thutwaxem me harha mpànà naha ha, amnye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Àro ke, ohxe mpànà enytxatxoko, rorwonà. Ohxe enytxanyenhàyamo wya ryhe, nenytxamohsehe rye rma haxa, Khoryenkomo, kekon hatà. Enytxanyehnàtho komo wya haxa ryhe, enytxamohsohra harha mpànà naha ha. Tàwyanye uhutwehe katxhe rma, hutwahkahyatxhe harha hampànà, nyamoro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Txesusu hyaka nomohtxownà hatà, àyon komo, ewtà komo xarha. Àhyakatho ro omokhàra mak nehxatxkon hatà, thenyehra rma haxa toto komo yesnàr ke. ");
INSERT INTO hixNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Omoknàr komo yokaytà yonytxay hatà, Txesusu. Mono natxow hatà, oyon komo, oyowtà komo xarha, ketxkon hatà, àton komo, àwya. Màmyaye rma natxow hatà. Oyonyàr xe natxow hatà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Onà wyaron komo ryhe, royon me natxhe. Rowtà me xarha natxhe, kekon hatà. Khoryenkomo rwonà yonytxany komo rma, eyuknye ro komo rma, royon me natxhe. Rowtà me xarha natxhe, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Anatoko kanawa yaka nosonkahtxownà hatà, Txesus komo, tànhananàhrà ro kom yakoro. Àpa txowà, mon hona, kekon hatà, àwyanye. Àro ke totxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tàtontokonye rma, nànàkye hatà, Txesusu. Nomokye hatà, atxowowo ymo, thenyenohnà ymotho rma haxa mak hatà. Ukuthonà ymo hoko rma haxa natxowowonakon hatà. Nataràhtekon hatà, kanawa heno. Owompaya rma haxa nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Txesusu yompakatxownà hatà. Khananàhnye y, khananàhnye y, tànoryatxow hamà, ketxkon hatà, àwya. Hakay hatà, Txesusu. Atxowowo ymo yatàknanàhkay hatà. Dà kasko, kekon xarha tà, tuna ymo wya, tekahxemaxemà ymo wya. Dà, natàknay hatà. Tatàknye rma haxa nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Àsok tawro Khoryenkom hona xenyhera mahtxoko, kekon hatà, Txesusu, àwyanye. Noseryehtxownà hatà, nyamoro ha. Noseryehoketxkon xarha tà. Onok moson haryhe, ketxkon hatà, tàwyanye rma. Atxowowo ymo komo wya, tuna ymo komo wya xarha, ayatàknako kany me nay hamà. Osken komo neyuknur me nay hamà, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Xerasa yamtar hona nahatakatxownà hatà, Txesus komo. Karyeryeya yamtar màhtono rma àro ha, mon hono rma. Txeey katxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mahona nasanàmye hatà, Txesusu. Asanàmàtxhe rma, àhyaka nomokye hatà, toto. Owto hono rma mok nehxakon hatà, noro ha. Worokyamo yohà rma mok nehxakon hatà. Mexe rma haxa àwomumra ro mak nehxakon hatà. Àmàmra xarha nehxakon hatà. Yatxetxho wawo roro haxa nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tàwya Txesusu yonyetxhe rma, nàrwonàmye hatà, teryewrye ro hatà. Tano me ro rma nehurkay hatà, akrataka. Txesusu y, kekon hatà, teryewrye ro. Khoryenkom muru omoro ha. Omeroron komo yohon muru rma omoro. Àsok manaye, rohoko, kekon hatà. Àsok manaye, rohoko. Ryeryewhamnohpàra exko hampànà, àkehe, owya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Àro wyaro rma nkekon hatà, onà wyaro kanyenhàr me rma Txesus yesnàr ke hatà. Worokyamo y, otowko ha, toto hyaye, kanyenhàr me nehxakon hatà, Txesusu. Àsok tawro hana. Yake ro tototho yanyenhàr me nehxakon hatà, worokyamo. Àro ke, watxa ymo yaka nahryemtxownà hatà, toto komo. Nenyatxkonà roro hatà, ahatakanàr hona. Nasohtotxownà xarha tà, yawaka ke. Nàhrowomtxownà xarha tà. Nakmeryekon mak hatà, noro ymo ha. Worokyamo yano me ahehnaka tekon hatà. Àro wyaro ehxah me nehxakon hatà, noro ymo ha. ");
INSERT INTO hixNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Onok omoro, oyosotà, kekon xarha tà, Txesusu, àwya. Thenyenohnà mak on ha, rosotà, kekon hatà. Àro wyaro nehxakon hatà, esotà, thenyehra worokyamo yesnàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Àtotxok harha, yuhnayen hona, oyowto kom hona, kahra exko hampànà, amna wya, kekon hatà, toto, worokyamo yano me hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Àto nehxatxkon hatà, okno komo, honyko wyaron komo. Àh yawxawo rma nehxatxkon hatà, thenyehra rma haxa mak hatà. Àto rma nasahxemtetxkon hatà. Àro ke, onà wyaro nkekon xarha tà, toto, worokyamo yano me hatà. Okno komo yowan yaka owomtxoko, kasko haxa, amna wya, kekon hatà. Àro ke neyukye hatà, Txesusu. Àtotxoko, ewan yakanye, kekon hatà, worokyamo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Toto hyaye notowtxownà hatà, worokyamo komo, thenyenohnà komo, kray. Okno komo yowan yaka haxa nowomtxownà hatà, kuru kuru kuru. Uuff, huhyakanto kàtatxownà hatà, okno heno komo. Krow, tuna ymo kwaka nowomtxownà hatà. Nànotàhkatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Omeroro nenytxownà hatà, okno yonye rotho komo. Àro ke nekahtàmtxownà hatà, owto hona. Àton komo wya nekarymatxownà hatà. Owto màhton komo wya xarha nekarymatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Àro ke exetxhàràtho yonyxe nomohtxownà hatà, toto komo. Txesusu hyaka rma nomohtxownà hatà. Worokyamo yohàtho yonytxownà hatà. Txesus yakratawo eryewtaxah harha nehxakon hatà. Twomunke harha nehxakon hatà. Tonyxerye harha nehxakon hatà. Àro ke noseryehokatxownà hatà, toto komo. ");
INSERT INTO hixNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Xenyenhàyamo ryhe nekarymatxehkatxownà hatà, àwyanye, omohxemo komo wya. Txesusu wya enyhoryetxhàrà rma yokarymatxownà hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Txesusu yahoxet hona noseryehyatxkon hatà, Xerasa yamtar hon komo, omeroro. Owto hon komo, owto màhton komo xarha, noseryehyatxkon hatà. Àro ke, onà wyaro nketxkon hatà, Txesusu wya. Àtoko, amna hyaye, ketxkon hatà, àwya. Àro ke, kanawa yaka nosonkahye hatà, Txesusu, tàtonàr horà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Txesus yakoro tàtonàr xe nehxakon hatà, worokyamo yohàtho. Ayakoro romoknàr xe wehxaha, kekon hatà, Txesusu wya. Omokhàra exko, kekon mak hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Àtok harha, omàn yaka harha. Khoryenkomo wya oyonyhoryetxhàrà ekarymako, toto komo wya, àton komo wya, kekon hatà. Towahke rma haxa nahko, Khoryenkomo, rohoko, kasko, àwyanye, kekon hatà, Txesusu, àwya. Àro ke toy hatà, worokyamo yohàtho. Noskarymekon hatà, toto komo wya, owto hon komo wya, omeroron komo wya. Txesusu ryhe ronyhoryeno. Towahke rma haxa nahko, rohoko, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","On hona harha nomokye hatà, Txesusu. Noro hona ro nehxatxkon hatà, toto komo, thenyenohnà komo. Àro ke teryehorye netakmetxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nomokye hatà, horykomo. Xayru rma noro hatà. Xuknewyana komo yohà rma mok nehxakon hatà, tohsamnohsomà ro komo yonye ro rma hatà. Tano me ro rma nehurkay hatà, Txesus yakrataka. Omoko, romàn yaka, kekon hatà, àwya, teryewrye ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Àro wyaro nkekon hatà, ekeh me rma haxa tomsàthàrà txko yesnàr ke hatà. Towenyxanotho txko me rma nehxakon hatà, emsàthàrà txko. Enuruthurunhuru rma, 12 me àtxemnyehàntaxah me nehxakon hatà. Àwayehpaya nehxakon hatà. Àro ke, noro yakoro toy hatà, Txesusu. Tàtonàr kom me, Txesus hona nohtaymetxkon hatà, toto komo. Thenyenohnà komo kax mak nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Àwawonye nehxakon hatà, wosà. Ekehà rma mok nehxakon hatà, noro ha. Tkamsukrye roro nehxakon hatà. Àro wyaro rma 12 me txemnyehàntay hatà. Tkatxhothàrà yàmtàhkanyenhàr me nehxakon hatà, omeroro hatà, ohtxemano ynye ro komo wya, tohtxe yehetho me rma haryhe tà. Ehtxemnà ro me mak nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Noro rma, Txesusu mkaye nomokye hatà. Àhonon yotxhàrà yahey hatà. Àwya ahetxhe rma, natàknay hatà, àkamsukuthuru. Eheryanàthàrà rma natàknay hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Onok mokro rahen haryhe, kekon hatà, Txesusu. Onok mokro rahen haryhe. Urohnà, urohnà, ketxkon hatà, toto komo, omeroro. Àro ke, onà wyaro nketxkon hatà, Petru komo. Khananàhnye y, àsok tawro onok mokro raheno màken harha, ketxkon hatà. Thenyehra rma haxa natxow hamà, toto komo. Nohtaymetxow hamà, ohona, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Àna matà, rahen haxa hawe, kekon hatà, Txesusu. Rohyay we notowno ha, rahoxetà, toto yonyhoryetxho, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ohtanampàra mak wehxan hamà, kekon hatà, wosà, tàwya rma. Àro ke nomokye hatà. Nàràrànakon hatà, oseryehrà. Tano me ro rma nehurkay hatà, Txesus yakrataka. Noskarymay hatà, àwya, toto komo nenytxanàr me. Ekehà rorotho uro ha, kekon hatà. Tkamsukryemà rorotho rma uro ha. Àro ke kaheno. Rowya ayahetxhe rma, ohxe harha wahko, kekon hatà, wosà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Wosà y, kekon hatà, Txesusu, àwya. Ohxe harha manaha, rohona owya xenyàr ke mak ha. Ohxe àtoko, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Wos yakoro Txesusu rwonàmnàtoko rma, nomokye hatà, toto. Horykomo màn yaye nomokye hatà, Xayru màn yaye rma hatà. Oyomsàthàr heno wayehno haxa ha, kekon hatà, Xayru wya. Khananàhnye komo yarhàra harha exko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Àro wyaro tàwya enytxatxhe rma, onà wyaro nkekon hatà, Txesusu, horykomo wya. Oseryehokahra exko, kekon hatà, àwya. Rohona rma xenyko. Ohxe rma mpànà naha ha, oyomsàrà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Horykomo màn yaka haxa nomohtxownà hatà. Horohkano yeryey hatà, Txesusu. Owompàra ehtxoko, rakoro, kekon hatà, toto komo wya. Petru kom marma yarày hatà. Noro yakoro nowomtxownà hatà, àyàm komo, àyon xarha, Petru xarha, Xowaw xarha, Txaku xarha. Nyamoro marma nowomtxownà hatà, Txesus yakoro. ");
INSERT INTO hixNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Àmàn yawo rma nehxatxkon hatà, anar komo. Nàratetxkon hatà, omeroro. Nehokoyatxkon hatà, omsamtxemo heno hnànà. Àratahra ehtxoko, kekon hatà, Txesusu, àwyanye. Àwayehpàra naha, omsamtxemo. Ànàknàrà rma onà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Newnohtxownà mak hatà, toto komo. Àna make ryhe mpe, ketxkon hatà. Àwayehsah me uhutwany komo kax mak nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Omsamtxemo yahosày hatà, Txesusu, amor hoko. Roknà y, asanàmko, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tonyxerye harha nehxakon hatà, omsamtxemo. Àtoko rma nasanàmye hatà. Ànyahrà tàmtxoko, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Noseryehoketxkon mak hatà, àyàm komo, àyon xarha. On yokarymahra xaxa mpànà ehtxok ha, toto komo wya, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","12 komo yanyekye hatà, Txesusu. Nohsamnohtàkatxownà hatà, nyamoro rye. Onà wyaro nkekon hatà, Txesusu, àwyanye. Àtotxok ha, kekon hatà. Rano me ryhe ehonomnà me manatxhe ha, owyanye worokyamo yowtoho me, owyanye teheryankemàtho komo yonyhoryetxho me xarha, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Àro wyaro rma nànyahtxownà hatà. Ekarymaxe nànyahtxownà hatà. Àsok hana kàkayaryet kom me nay ha, Khoryenkom ha. Àro rma yokarymaxe nànyahtxownà hatà, Txesusu. Ekehàtho komo yonyhoryex xarha nànyahtxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Onà wyaro nkekon xarha tà, àwyanye. Akorohra rma àtotxoko, kekon hatà. Ayahoso komo yarhàra ehtxoko. Ayamatan komo xarha yarhàra ehtxoko. Owru komo xarha yarhàra ehtxoko. Otxenyerun komo xarha yarhàra ehtxoko, kekon hatà, àwyanye. Asako owomun komo yarhàra ehtxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Onok kom màn yaka hana oyowomàtxhenye, àto rye rma hak oyonmahyatxhe ha. Owto hoye otohra ronye rma haka, àro rye yawo rma oyonmahyatxhe ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Anaro rha owto hona àtotxoko. Oyonytxahranye owto hon komo yehtoko, onà wyaro ehtxoko, anhàn komo hutwamohsonàr horà. Ewto kom hoye otontokonye, ehtahpunkatxoko, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Àro ke totxownà hatà, 12 komo. Anaro rha owto hona totxownà hatà. Àrwo yonyhorunu yokarymetxkon hatà. Othoyehra rma, ekehàtho komo yonyhoryetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Txesus yokaytà yonytxay hatà, Eroknesà. Karyeryeya yamtar hon komo kayaryetà rma mok nehxakon hatà, noro ha. Omeroro rma, Txesus yokaytà yonytxekon hatà. Noro hoko rma, onà wyaro nketxkon xarha tà, toto komo, ukukur komo rma. Àwayehxemo kom waye nasanàmyak hamà, Xowaw heno, aymomno ynye ro heno, ketxkon hatà, Txesus hoko. Àro ke noseryehokekon hatà, Eroknesà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Onà wyaro nketxkon hatà, anar komo, Txesus hoko. Eryeyas heno ryhe nosonyhek hamà, ketxkon hatà, ukukur komo. Khoryenkomo rwonà yokarymanye ro heno komo kukuru ryhe mokro hamà. Àwayehxemo kom waye nasanàmyak hamà, amnyehran heno, ketxkon hatà, anar komo, Txesus hoko. ");
INSERT INTO hixNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Àhàmkotohek haxa hawe, Xowaw heno, kekon hatà, Eroknesà. Onok komo yokaytà wenytxeno. Onokà ryhe noro ha, kekon hatà. Àro ke, Txesusu yonyàr xe nehxakon hatà, Eroknesà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Txesusu hyaka nomohtxownà harha tà, 12 komo, ànànyaketxhàyamotho rma. Noskarymatxehkatxownà hatà, àwya. Tànyeryetxhàyamo rma yokarymatxehkatxownà hatà, àwya. Betsayda hona natxownà hatà, Txesusu. Owto rma àro ha, Betsayda. Nyamoro rye rma totxownà hatà. Toto komo hyaye totxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ton hamà, ketxkon hatà, toto komo, ohsamnohxemo komo. Àpa txowà, ketxkon hatà. Àro ke, Txesus komo wenarye totxownà hatà. Teryehorye netakmetxownà hatà, Txesusu. Momohtxowà, kekon hatà, àwyanye. Nekarymekon hatà, àwyanye. Àsok hana kàkayaryet kom me nay ha, Khoryenkom ha. Àro rma yokarymekon hatà, Txesusu, toto komo wya. Àsok hana nehxatxkon ha, ukukur kom ha. Àwya tonyhoryenàr komo xe nehxatxkon hatà, ekeh me tesnàr kom ke. Àro ke nenyhoryetxownà hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Àro rma kokmamrà ro, Txesusu hyaka haxa totxownà hatà, 12 komo. Onà wyaro nketxkon hatà, àwya. Toto komo ànyahtxoko, ketxkon hatà, àwya. Ànyahtxoko, anaro rha owto hona. Owto màhton komo hyaka xarha ànyahtxoko, tosar komo yonyxe, tànyahrà komo yonyxe xarha. Ànyahtxoko, tan kesnàr kom ke, ahehnawo rma kesnàr kom ke, ketxkon hatà, 12 komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Omnyamo rma ànyahmatxoko, kekon hatà, àwyanye. Ehxera naha, ànyahrà komo, amna hyawo, ketxkon mak hatà, 12 komo. 5 me marma naha, ekeyu, amna hyawo. Kana xarha, 2 me marma naha. Àsok katà. Ànyahrà komo yehekahso katà amna nteno. Thenyehra rma haxa natxhe, toto komo, ketxkon hatà, 12 komo. ");
INSERT INTO hixNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kàrkomo komo yakenonà, 5000 me hana nehxatxkon ha. Eryewtanàhtxoko, kekon hatà, Txesusu, 12 komo wya. Eryewtanàhtxoko, asamtaha ro. 50 me rye eryewtanàhtxoko, 50 me rma rha, 50 me rma rha, omeroro eryewtanàhtxoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Àro wyaro neryewtanàhtxownà hatà, 12 komo. ");
INSERT INTO hixNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ekeyu yanàmye hatà, Txesusu. 5 me rma nanàmye hatà. Kana xarha yanàmye hatà, 2 me rma. Kakoso nosompotày hatà. Khoryenkom yakoro nàrwonàmye hatà, ekeyu hoko, kana hoko xarha. Nowye hatà. Nàmye hatà, 12 komo wya. Ekamtxoko, toto komo wya, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Omeroro rma nenahtàkatxownà hatà. Wahuramtàhkatxownà hatà. Otàkràskatxhàràtho yonàmatxownà hatà, wetxe ymo yaka. 12 me rma nenàmatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Taa. Khoryenkom yakoro nàrwonakon hatà, Txesusu, noro ro. Àhyawo rma nehxatxkon hatà, ànhananàhrà ro komo. Àro ke, onà wyaro nkekon hatà, Txesusu, àwyanye. Onok me ryhe wehxano, toto komo wya, kekon hatà. Onok me rotakyatxowà, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Onà wyaro neyuhtxownà hatà, ànhananàhrà ro komo. Xowaw heno we mokro ha, aymomno ynye ro heno we mokro ha, ketxhe haryhe, ohoko, anar komo, ketxkon hatà. Eryeyas heno haxa we mokro ha, ketxhe, anar komo xarha. Khoryenkomo rwonà yokarymanye ro heno komo kukur haxa we mokro ha, nasanàmyak hamà, amnyehran heno, àwayehxemo kom waye, ketxhe, anar komo xarha, ohoko, ketxkon hatà, ànhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Omnyam haxa, onok me ryhe uro metakyatxowà, kekon hatà, Txesusu, àwyanye. Petru ryhe neyukye hatà. Kryestu ryhe omoro, amna wya, kekon hatà. Khoryenkomo nànyaketxho ryhe omoro, amna wya, kekon hatà, Petru, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Àro yokarymahra xaxa mpànà ehtxok ha, toto komo wya, kekon hatà, Txesusu, teryewrye ro, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Thenyehra rma haxa teryewhamnohsom me naha hampànà, Toto me Enusaho, kekon xarha tà, àwyanye. Noro xanomkahnohyatxhe hampànà, horykomo komo, Khoryenkom màn yonye ro yoh komo xarha, àyweronàhyamano ynye ro komo xarha, kekon hatà. Yahkotohen hona namoyathohetxhe xarha hampànà. Twayhàtxhe, nasanàmyaha harha hampànà, Toto me Enusaho. Osorwawo ro enmahàtxhe, nasanàmyaha harha hampànà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Onà wyaro nkekon hatà, Txesusu, toto komo wya, omeroron komo wya. Rakoro otonàr komo xe oyehtokonye, onà wyaro ehtxok hampànà, kekon hatà, àwyanye. Osoxanomkahnohtxok hampànà. Oyeryewhamnohtoho komo enàmtxok hampànà, kekon hatà. Emahona ro enàmtxok hampànà. Àro wyaro enàmnye rma, rakoro àtotxok hampànà, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Anatoko oyeryewhamnohrà komo xehra manatxow hana, toto komo wya, kekon xarha tà, àwyanye. Àro ke, oyekrunhonàr xe manatxow hana, awayehrà kom hona. Oyekrunhonàrà xano rma, awayehyatxhe xak mak hampànà, kekon hatà. Àsok haxa hana manatxow ha. Mosoxanomkahnohyatxow haxa hana, twayehso ro, rox oyesnàr komo ke mak ha. Àro wyaro tosoxanomkahnohsomà rma, mekrunhetxhe harha. Karyhe roro harha manatxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Àsok hana manatxow ha, kekon xarha tà, toto komo wya. Tkatxhonke rma haxa manatxow hana. Ohyawonye rma nay hana, anaro rha katxhonano, omeroro, kekon hatà. Àro wyaro thenyehra tkatxhonkemà rma, ohxehra rma manatxhe ha. Karyhe roro harha manatxhe katxho mehra oyehtokonye, ohxehra ro mak manatxhe ha. Tanàhnohsom me xak mak manatxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Àsok hana manatxow ha, kekon xarha tà, àwyanye. Moseryehyatxow hana, toto kom hona. Txesusu mryenon uro ha kahra manatxow hana, oyoseryehrà komo ke. Txesusu rwon yawo ron uro kahra manatxow hana, oyoseryehrà komo ke mak ha, kekon hatà. Àro wyaro oyehtokonye, romryenon mosonà kahra rma rha naha hampànà, Toto me Enusaho, ohokonye, kekon hatà. Amnye ehonomnà me xaxa nomokyaha hampànà, noro ha. Tàyàmà wyaro ehonomnà me xaxa nosonyhehe hampànà. Kahe yawon komo wyaro xarha, enyhoru ro komo wyaro rma, ehonomnà me xaxa nosonyhehe hampànà, Toto me Enusaho. Tomokàtxhe rma, romryenon mosonà kahra ro mak naha hampànà, oskarymahnàtho kom hoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Onà wyaro yaworo xaxa mak àkehe, owyanye. Toto komo kayaryet me nosonyhehe xaxa mak hampànà, Khoryenkomo, kekon hatà. Àro wyaro noro yosonyhohra ro rma haka, awayehyatxhe hampànà, omnyamo, kekon hatà. Okukur kom marma ryhe, àwayehpàra rma hak natxhe hampànà. Nyamoro rma, toto komo kayaryet me noro yehtxoho yonyatxhe hampànà, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Àro wyaro nekarymay hatà, Txesusu, toto komo wya. Taa. 8 me enmahàtxhe hana toy ha, àhà ymo hona. Petru yarày hatà. Xowaw xarha yarày hatà. Txaku xarha yarày hatà. Nyamoro marma yarày hatà. Àhà ymo yawnuhtxownà hatà. Khoryenkom yakoro àrwonàmso toy hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tàrwonàmnàtoko rma, anar me tonyxem me harha nexey hatà. Anar me harha nehxakon hatà, empatarà. Àwomun xarha, tàkrokromuknye harha nehxakon hatà. Nenkahxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Àtoko rma nosonyhotxownà hatà, asakon komo, Moyses heno rma hatà, Eryeyas heno xarha hatà. Nàrwonatxkon hatà, Txesus yakoro. ");
INSERT INTO hixNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Awasànà ymo ho rma haxa nosonyhetxkon hatà. Txesusu wayehtoho hoko nàrwonatxkon hatà. Xerusaryen ho àwayehtoho hoko rma nàrwonatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nànàhtxownà hatà, Petru komo, twetun komo ke rma haxa mak hatà. Hakatxownà hatà. Txesusu yawasànà ymo yonytxownà hatà. Ànenyàr kom me rma, asak nehxatxkon hatà, akoron komo. ");
INSERT INTO hixNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Txesusu hyaye àtohaya nehxatxkon hatà. Àro ke, onà wyaro nkekon hatà, Petru, Txesusu wya. Khananàhnye y, tan kehtxoho komo ohxe nay hamà, kekon hatà. Wato hak amna nexe, osorwawo, omàn komo, Moyses màn xarha, Eryeyas màn xarha, kekon hatà, Petru. Rarah mak nehxakon hatà, toseryehokanàr ke. ");
INSERT INTO hixNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Àro wyaro Petru wya tatoko rma, nomokye hatà, kahrutunu, ehokosonye. Àro waka rma nowomtxownà hatà. Àro ke noseryehyatxkon hatà, Petru komo. ");
INSERT INTO hixNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kahrutun wawono rwonà yonytxatxownà hatà. Romuru mosonà, kay hatà. Ronwahanonkatxho rma mosonà. Noro enytxatxoko, kay hatà, kahrutun wawono. ");
INSERT INTO hixNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Àro wyaro tàwyanye enytxatxhe rma, Txesus marma yonyatxkon hatà, Petru komo. Àro wyaro texetxhenye rma, tànenyetxhàyamo yokarymahra nehxatxkon hakapa tà, anar komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sa, nenmahye hatà. Enmahàtxhe rma, àhà ymo yonàhtotxownà hatà, Txesus komo. Àwyanye enàhtotxhe, àhyakanye nomohtxownà hatà, toto komo, thenyenohnà kom hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Àwaye ronye rma nàrwonàmye hatà, toto, teryewrye ro hatà. Khananàhnye y, onà wyaro àkehe, owya, teryewrye ro, kekon hatà. Moson romurunho xenyko. Ronàhnànàtho txko noro ha, towenyxanotho txko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Worokyamo yoh me naha. Àro ke nahohsaha, noro ymo ha. Àwya tahosàtxhe rma, kowontehe, kekon hatà. Nànyerymamnohyaha, noro ymo. Àro ke wakrontehe. Thenyehra neryewhamnohyaha. Krawame rma haxa nàhnànkehe, noro ymo, kekon hatà, àyàmà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Noro ymo towtxoko romurunho txko hyaye, àkano rma haryhe, teryewrye ro, onhananàhrà ro komo wya. Townyehnà ro mak moxam hamà, kekon hatà, àyàmà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Onà wyaro haxa nkekon hatà, Txesusu, toto komo wya. Àsok hana manatxow ha, omnyam ha, amnyeno rma komo, kekon hatà. Khoryenkom hona xenyehnà omnyam hamà. Noro yanweknye rma omnyam hamà, kekon hatà. Mexe rma haxa ehxah me wehxaha, awawonye. Khoryenkom yahoxetà hutwahra rma manatxhe, kekon hatà. Mexe rma rha kramamyan hamà, awawonye rma. Khoryenkom yahoxetà hutwahra rma oyehtxoho komo wenàmyano rye rma hamà, tano, kekon hatà, toto komo wya. Omuru soko, xaro, kekon xarha tà, àyàmà wya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Omoknàtoko rma, noro yarymay hatà, worokyamo, yukryeka hona. Nànyerymamnohye xarha tà, thenyehra hatà. Worokyamo yoyey mak hatà, Txesusu. Bàryekomo yonyhoryey hatà. Moson harha omuru kekon hatà, àyàmà wya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Noseryehoketxkon hatà, toto komo, omeroro. Koo, Khoryenkom yano me ehonomnà me xaxa nay hamà, mosonà, ketxkon hatà. Noseryehoketxkonà rma hatà, toto komo. Anaro rha hoko Txesus yehtxoho hoko noseryehoketxkon hatà. Àro wyaro oseryehokantokonye rma, onà wyaro nkekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Onà ryhe enytxatxoko. Uhutwahkahpàra rma ehtxoko, kekon hatà. Tahohsosom me naha hampànà, Toto me Enusaho, toto komo wya, anhà komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Àro wyaro katxho nenkukmetxkon mak hatà. Uhutwamohsohra rma nehxakon hatà, Txesusu, àwyanye, uhutwahra rma ehtxoho menye. Uhutwamohsoko, amna wya, kahra nehxatxkon hatà, àwya, kurunye tàwyanye xenyàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Taa. Natameryeketxkon hatà, Txesusu nhananàhrà ro komo. Nyamoro rye rma natameryeketxkon hatà. Onokà ryhe, ehonomnà me nyhe naye, kwawonye, tawro hoko natameryeketxkon hatà. Onokà ryhe, anar komo yoho nyhe naye, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ehutwatxho komo rma hutwekon hatà, Txesusu. Àro ke, bàryekomo txko yokye hatà, tàhyaka. ");
INSERT INTO hixNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mosonà txko xenytxoko, kekon hatà, àwyanye. Toto komo yosnaka rma haxa nay hamà, mosonà txko. Mosonà wyarono txko komo rma ewakryetxoko. Rox oyehtokonye, ewakryetxoko. Owyanye ewakryentokonye rma, uro rma mewakryetxhe, kekon hatà. Àro wyaro owyanye rowakryentoko rma, ronyaknyenhàr haxa mewakryetxhe. Àsok tawro hana. Okukur komo yosnaka oyehtokonye, ehonomnà me manaha katxho me haxa manatxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Khananàhnye y, kekon hatà, Xowawu, àwya. Toto amna nenyako. Worokyamo yowyaknano, noro ha, ayano me rma haryhe, kekon hatà. Txesus yano me otowko ha, keknano rma haryhe, worokyamo wya. Àro ke, àro wyaro kahra exko, kek amna, àwya. Amna natàknanàhkeko, kukukur kom mehra esnàr ke, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Atàknanàhkahra ehtxoko, kekon mak hatà, Txesusu. Àsok tawro hana. Kxanhàn kom mehra tehtokonye, kukukur kom me rma natxow hamà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kahe yaka harha Txesusu yasanàmtoho hahnok haxa nehxakon hatà. Xerusaryen hona tàtonàr hona oseryehpàra mak nehxakon hatà. Àtehe ro mak ha, Xerusaryen hona, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tàywaho takoron kukur komo nyakye hatà, àwyanye tosarà yonyàr horà. Owto hona nahatakatxownà hatà, nyamoro. Samaryayana komo yowto me rma nehxakon hatà. Àto rma, Txesus yosarà yonyàr xe nehxatxkon haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Xenyhohra mak nehxatxkon hatà, àton komo, Xerusaryen hona tàtosom me Txesus yesnàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Xenyhohra ehtxoho komo yonytxatxownà hatà, Txaku komo, Xowaw xarha, Txesusu nhananàhrà ro komo. Amna yohà y, ketxkon hatà, Txesusu wya. Oyosarà yonyhohra natxow hatà, àton komo. Àsok amna neryatxowà. Kahe yay hak nomokno, weheto, aknyohtoho komo, kahra kat amna naye. Natahtxow haka, kahra kat amna naye, àhokonye, ketxkon hatà, Txaku komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Àwetxenye neramay hatà, Txesusu. Neytxownà hatà. Àro wyaro kahra ehtxoko, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Taa. Anaro owto hona totxownà hatà, Txesus komo. ");
INSERT INTO hixNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Asama yarye Txesus komo tontoko, onà wyaro nkekon hatà, toto, Txesusu wya. Ayakoro komokyaha, kekon hatà. Henta komo otontok hana, àsna rma àtehe, ayakoro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Onà wyaro nkekon mak hatà, Txesusu, àwya. Àsok hana natxow ha, onokna kom ha, torono komo xarha. Bànke natxow hamà, nyamoro ha. Towtakem me natxhe, onokna komo. Tamke natxhe, torono komo. Toto me Enusah haxa ryhe, àmàmra naha. Atakryetxho rma, ehxera naha. Àro wyaron yakoro rma otonàr xe kat manaye, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Onà wyaro nkekon xarha tà, anaro wya. Omoko, rakoro, kekon hatà, àwya. Onà wyaro haxa nkekon hatà, noro. Rohà y, omokhàra hak wehxaha, ayakoro, kekon hatà, Txesusu wya. Royàm peno wayhàtxhe, wenamyan hamà, uro ha. Rowya noro heno yonamàtxhe, àten hamà, ayakoro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Àna matà, kekon mak hatà, Txesusu, àwya. Anar kom hak àwayehsahotho yonamtxowà. Karyhe roro harha manatxhe katxhohnà komo rma hak nenamtxowà. Omoro haxa ryhe, àrwo yonyhorunu ekarymatxa. Àsok hana toto komo kayaryet me nay ha, Khoryenkom ha. Àro rma ekarymatxa, toto komo wya, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Onà wyaro nkekon hatà, anaro xarha, Txesusu wya. Rohà y, ayakoro komokyaha, kekon hatà. Romàn yaka htxero hak àtosà. Royanan komo wya, àtehe haxa hampànà, ohyayenye, àkatxano htxero haka, kekon hatà, noro. ");
INSERT INTO hixNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Àna matà, kekon mak hatà, Txesusu, àwya. Àsok hana natxow ha, bararàn hokono ro kom ha. Tàwyanye wahomyaken hamà katxhe rma, àhorohpàra natxow hamà. Nyamoro wyaro exko, kekon hatà. Ohorohnàtok haxa, Khoryenkomo mryenon mehra manay hamà. Akayaryet me Khoryenkomo hutwahra manay hamà, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Àro tàhto rma, tànhananàhrà kom waye 70 me wahanonkatxownà hatà, Kohkomo. Tàywaho nànyahtxownà hatà. Asako rye nànyahtxownà hatà, asako rma rha, asako rma rha. Àro wyaro asako rye nànyahtxownà hatà, omeroro. Anaro rha owto hona nànyahtxownà hatà, tàywaho rma. Henta ya tàtotho yehtok hana, àsna rma nànyahtxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Onà wyaro nkekon hatà, Txesusu, àwyanye. Nat yeher komo wyaro, thenyehra rma haxa natxhe, toto komo, Khoryenkomo hyaka tohsom komo, kekon hatà. Khoryenkomo hyaka soknye kom haxa ryhe, yakehra ro mak natxhe. Àsok tawro hana. Nat yohà wyaro nay hamà, Khoryenkomo, kekon hatà. Àro ke orwonàmtxoko, noro yakoro. Apa y, ayanoto komo ànyahtxoko, katxoko, àwya. Ànyahtxoko, ohyaka àwyanye toto komo yohtoho me, katxoko, àwya, kekon hatà, Txesusu, tànànyaknyàr komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Àtotxoko, kekon xarha tà, àwyanye. Àsok hana nay ha, kahneru mxekrà ha. Kamara wawo tehtoko, osowyomahra nay hamà. Àro wyaro rma rha manatxhe hampànà. Toto komo hyaka mpànà dyakyatxhe ha, kamara wyaron komo hyaka rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Otxenyerun komo yonà yarhàra ehtxoko. Ayamatan komo xarha yarhàra ehtxoko. Ohrorà womun komo xarha yarhàra ehtxoko, kekon hatà. Asama yarye otontokonye rma, toto kom yakoro orwonàmrà kom hokohra ro mak ehtxoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Toto kom màn yaka oyowomnàtokonye, onà wyaro htxero katxoko, àton komo wya, kekon xarha tà. Teryehorye hak oytxowà, Khoryenkomo, katxoko, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Teryehorye texem me ehtokonye, teryehorye neryatxow hamà, Khoryenkomo, kekon hatà. Teryehorye texem mehra haxa ehtokonye, teryehorye txeryheranye nay hamà, kekon hatà, Txesusu, tànànyaknyàr komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Anaro rha màn kom yaka àtohra ehtxoko. Onok kom màn yaka hana oyowomàtxhenye, àto rye rma hak oyonmahyatxhe ha. Nyamoro hak anyahmatxowà. Nyamoro hak owokhatxowà. Àro wyaro towakryexem me rma manatxhe ha, ranoto me oyesnàr komo ke mak ha. Àsok tawro hana. Kàhyakanye tatamoketxhenye, towakryexem me natxow hamà, toto komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Anaro rha owto hona màtetxhe ha, kekon xarha tà. Tàwyanye oyonytxantokonye, anyahmetxow hamà, owto hon komo. Ànàmrà komo rma enahtxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Àto rma oyehtokonye, ekehàtho komo enyhoryetxoko. Onà wyaro katxoko, àton komo wya. Kàkayaryet kom me Khoryenkomo nànyaketxho ryhe, omohsah me naha, katxoko, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Oyonytxahranye owto hon komo yehtok haxa, onà wyaro ehtxoko, anhàn komo hutwamohsonàr horà. Màmyaka ahatakatxoko. Onà wyaro katxoko, omeroron komo nenytxanàr me. ");
INSERT INTO hixNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Amna nehtahpunkehe, katxoko. Oyowto komo hpunutho rma amna nànomyaha, ohyawonye, atxke oyesnàr komo ke, katxoko, àwyanye, kekon hatà. Onà wyaro ryhe uhutwatxoko, katxok xarha, àwyanye. Kàkayaryet kom me Khoryenkomo nànyaketxho ryhe, omohsah me naha, katxoko, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Onà wyaro àkehe, owyanye, nyamoro hoko. Amnye, Khoryenkomo wya wahanonkano ytxoho ro ho haxa, atxke rma haxa natxhe hampànà, àton komo, oyonytxanyehnànhàyamotho. Soknoma hon heno komo yoho rma haxa, atxke natxhe hampànà, kekon hatà, Txesusu, tànànyaknyàr komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Onà wyaro nkekon xarha tà, Txesusu, anaro rha owto hon kom hoko. Onà wyaro àkehe, Korasen hon kom hoko, Betsayda hon kom hoko xarha, kekon hatà. Tanàhnohsom me rma haxa natxhe hampànà, nyamoro ha. Àsok tawro hana. Eryehokano weryaknano, ànenyàr kom me. Rahoxetà rma wenyheknano, àwyanye. Anar me harha tanhànàthàyamo yonyhera rma natxhe ha, kekon hatà. Txeru hon kom haxa ryhe, rahoxetà yonyhera nehxatxoko. Seknon hon komo xarha, eryehokano ytxoho yonyhera rma rha nehxatxoko. Tàwyanye xenyetok haxa, mexehra rma haxa anar me harha tanhànàthàyamo yonyàràtho haryhe, àwyanye. Sakatho ke harha ewomumtonàràtho kom haryhe, wàràmno waka xarha eryewtanàràtho kom haryhe, àro wyaro rma, anar me harha tanhànàthàyamo yony me ehutwamohsonàràtho kom haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Àro ke, onà wyaro àkehe, Korasen hon kom hoko, Betsayda hon kom hoko xarha. Amnye, Khoryenkomo wya wahanonkano ytxoho ro ho haxa, atxke rma haxa natxhe hampànà, nyamoro ha. Txeru honotho komo yoho rma haxa, atxke natxhe hampànà. Seknon honotho komo yoho rma haxa, atxke natxhe hampànà, nyamoro ha, Korasen hon komo rma, Betsayda hon komo xarha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Onà wyaro àkehe, Kafahnaw hon kom hoko xarha, kekon hatà. Kahe yaka tanàmsom me nosonyatxow hamà, nyamoro ha. Tanàmsom mehra mak natxhe ha, kahe yaka. Tarymaxem me haxa ryhe natxhe hampànà, yuhnayen hona, anàhnohno ytxoho ro na, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Onà wyaro nkekon xarha tà, tànànyaknyàr komo wya. Àsok hana natxow ha, oyonytxany kom ha, kekon hatà. Tàwyanye oyonytxantokonye rma, uro rma ronytxetxhe. Àsok haxa hana natxow ha, axanomkahnohnye kom ha. Tàwyanye axanomkahnohnàtokonye rma, uro rma roxanomkahnohyatxhe. Àro wyaro tàwyanye roxanomkahnohnàtoko rma, ronyaknyenhàrà rma xanomkahnohyatxhe, kekon hatà, Txesusu, tànànyaknyàr komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Amnye nomohtxownà harha tà, Txesusu nànyaketxho komo, 70 komo rma. Teryehorye rma haxa nomohtxownà hatà, Txesusu hyaka harha. Amna yohà y, ketxkon hatà. Worokyamo komo ryhe, amna yoyuknye ro me natxhe. Amna wya, Txesus yano me otowko ha katxhe rma, amna yoyukyatxhe, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Àna hamà, kekon hatà, Txesusu. Àsok hana nehxakon ha, worokyamo yohà ymo ha, Satanasà ymo. Kahe yawon komo wyaro ehonomnà me rma haxa nehxakonà, noro ymo ha. Ehonomnà mehra harha txexah me naha, kekon hatà. Sasa tatoko, mexehra nay hamà, kahe ratokoko. Àro wyaro rma rha anar me texem me nehxakonà, Satanasà ymo. Ehonomnà me ehxahotho rma, ehonomnà mehra harha texem me nehxakonà, royweroro, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Rano me ryhe tahoxerye manatxhe, ohnawonye, kekon xarha tà. Àro hoye ro anhà marymetxhe. Kàwyanye okoye yotahatxho wyaro, anhà marymetxhe. Kàwyanye txekerye yotahatxho wyaro rma, anhà yohà ymo marymetxhe, rano me mak ha. Oyeryewhamnohpàranye ro mak naha ha, noro ymo ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Àsok hana teryehorye manatxow ha. Teryehorye manatxow hamà, worokyamo komo wya oyoyuknur komo ke mak ha. On hok haxa ryhe teryehorye ehtxoko, kekon hatà. Tàmryenon yosot komo menhonyenhàr me naha, Khoryenkomo. Kahe yawo àmenhosah me rma naha, oyosot komo. Àro hoko rma teryehorye ehtxoko, kekon hatà, Txesusu, tànànyaketxhàyamotho komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Àro wyaro tàwya katxhe rma, neryehotay hatà, Txesusu, Khoryenkom yokato yano me hatà. Apa y, kekon hatà, Khoryenkomo wya. Kahe yawon komo yohà ryhe omoro. Yukryeka hon komo yoh xarha omoro, kekon hatà. Romryenon komo wya mehutwamohseko. Àro ke, ohxe xaxa manaha, àkehe, owya. Tàyweron uro ha kanyehnà komo wya mehutwamohseko, uhutwatxehkanye ro uro ha kanyehnà komo wya rma, kekon hatà. Uhutwanyehnà uro kany komo wya haxa ryhe, mehutwamohseko, bàryekomo txko wyaron komo wya rma, kekon hatà. Apa y, àwyanye rma mehutwamohseko, ayano me ro mak ha, àhokonye towahke xaxa oyesnàr ke mak ha, kekon hatà, Txesusu, Khoryenkomo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Thutwamohsony me ryeryeye, royàmà, kekon xarha tà. Buru hutwatxehkanye ro me naha, royàmà, noro marma mak ha. Khoryenkom muru hutwahra ro mak natxhe, anar komo, kekon hatà. Royàm hutwahra xarha natxhe. Uro marma, royàm hutwatxehkanye ro me wehxaha, umuru kaxe. Noro uhutwamohsehe xarha, ronwahanonkanàr komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Àro wyaro tàwya katxhe rma, neramay hatà, tànhananàhrà ro komo wetxe. Onà wyaro nkekon hatà, àwyanye, anar komo nenytxahtor me mak ha. Towakryexem me rma manatxow hamà, rahoxetà yony me oyesnàr komo ke, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Onà wyaro àkehe, owyanye. Amnyehran heno komo yoho rma haxa, towakryexem me manatxow hamà. Onenyàr komo yonyhera nehxatxkon hamà, nyamoro heno, kekon hatà. Xenyàr xe rma nehxatxkon haryhe, nyamoro heno, Khoryenkomo rwonà yokarymanye ro heno komo rma, àkayaryet heno komo xarha. Onenytxanàr komo yonytxanàr xe xarha nehxatxkonà rma haryhe. Enytxahra mak nehxatxkon hamà, nyamoro heno, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Txesusu hyaka nomokye hatà, toto. Àyweronàhyamano ynye ro komo kukuru rma mok nehxakon hatà. Txesusu kukmanàr xe rma nehxakon haryhe tà, enkukmanàr horà. Onà wyaro rma nkekon hatà, àwya. Khananàhnye y, kekon hatà. Àsoke ryhe ohxe wehxano, karyhe roro harha ryehtxoho me, kekon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Àsoke nkeno, kàyweronàhyamatxho komo, owya, kekon hatà, Txesusu, àwya. Àsoke màrwonàhyameno, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Onà wyaro neyukye hatà, àyweronàhyamano ynye ro. Onà wyaro nkehe, kekon hatà. Kohkom xe xaxa ehtxoko. Khoryenkom xe rma ehtxoko, oyowan kom ke xaxa mak ha, ohnawon kom ke xaxa mak ha, ayahoxet kom ke xaxa mak ha, oyehutwanàr kom me xaxa mak ha. Osox oyehtxoho wyaro rma, ohoyen komo xe xaxa ehtxok xarha. Àro wyaro rma nkehe, kàyweronàhyamatxho komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yaworo uro meyukno, kekon hatà, Txesusu. Àro yawo ro rma haxa exko, karyhe roro harha oyehtxoho me, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Krawamehra royukno hamà, mosonà, kekon hamà, tàhnawo, àyweronàhyamano ynye ro. Txesusu wya krawamehra toyuhtoho xehra mak nehxakon hamà. Àro ke, onà wyaro nkekon xarha tà, Txesusu wya. Onok komo ryhe, rohoyen me natxowà, àxenye ryehtxoho me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Anaro rha yana komo hoyen me noro yehtxoho hutwamohsonàr xe nehxakon hatà, Txesusu, àwya. Àro ke, anaro yana wya toto yakoronomatxhàrànhàrà yokarymay hatà, àwya. Onà wyaro nkekon hatà. Xerusaryen hoye toy hatà, toto, Xuknewyana rma, kekon hatà. Xeryko hona tekon hatà. Noro heno yahohtxownà hatà, waha komo. Womunkatxownà hatà. Netahatxownà xarha tà. Àro wyaro tàwyanye txeryetxhe rma, totxownà hatà, waha komo. Àwayehpayanotho rma nomtxownà hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Asama yarye nomokyakon hatà, Khoryenkom màn yonye ro. Àsok hana norotho yonyey ha. Nenyeye rma haryhe tà. Tàwya xenyetxhe rma, norotho hyaha rma toy hatà. Akoronomahra mak nexey hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Àto mya rma rha nomokye hatà, anaro xarha, toto. Ryefeta komo kukuru rma mok nehxakon hatà, Khoryenkom màn yonye ro komo yakoronomanye ro rma hatà. Tàwya norotho yonyetxhe, àhyaha rma rha toy hatà, Ryefeta xarha. Akoronomahra rma rha nexey hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nomokye xarha tà, anaro. Samaryayana rma mok nehxakon hatà, noro ha. Asama yarye tàtontoko rma, norotho hyaka nomokye hatà. Tàwya xenyetxhe rma, àhnàn yawo rma haxa nehxakon hatà, Samaryayana, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Àro ke, àhyaka haxa toy hatà. Nehtxemay hatà. Àkat yarkay hatà, eheryan horye. Ufa xkun xarha yarkay hatà, àhorye. Eheryan karamye xarha tà, wom ke. Àro wyaro tàwya ehtxematxhe rma, toknà mkakoso nakryey hatà. Narày hatà, hawana kom màn yaka. Àto rma tehtoko, nenyakonà rma hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Enmahàtxhe, toy xarha tà, Samaryayana. Àtohra rma hak tehtoko, tàtxenyerun hoye nàmye hatà, hawana màn komo yohà wya. 2 rma yàmye hatà, àwya. Onà otxenyerunu kekon hatà, àwya. Moson yonytxoho yehetho rma onà, kekon hatà. Ohxe mpànà xenyko, kekon xarha tà. Otxenyerun hoye màmyan hana, ohxe owya xenyàr me, kekon xarha tà. Àwararohra ronàmàtho yehtoko, wàmyaha xarha, owya, kekon xarha tà. Romokàtxhe, wàmyaha xarha, owya, kekon hatà, Samaryayana, hawana màn komo yohà wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Àsok muhutweno, kekon xarha tà, àyweronàhyamano ynye ro wya. Àsok muhutweno. 3 me nehxatxkon hamà, asama yarye àtoxemo komo. Waha komo netahatxhotho yonytxownà hamà, nyamoro, omeroro. Onok katà, rohoyen me naha, moson heno, wakoronomen hamà, kaye, owya, Khoryenkom màn yonye ro katà, Ryefeta haxa katà, Samaryayana haxa katà. Onok katà, thoyen me xaxa nenyeye, owya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Onà wyaro neyukye hatà, àyweronàhyamano ynye ro. Noro heno hnàn yawono ryhe, akoronomanyenhàrà rma, thoyen me xaxa nenyakon hamà, kekon hatà. Àna hamà, kekon hatà, Txesusu, àwya. Àro ke àtoko. Noro wyaro rma rha exko, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Asama yarye tetxkon hatà, Txesus komo. Tàtontokonye rma, owto hona nahatakatxownà hatà. Àto nehxakon hatà, wosà. Mahta rma noro ha. Omoko, romàn yaka, kekon hatà, noro, Txesusu wya. Bàn yaka narày hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Towtànke nehxakon hatà, Mahta. Maryeya rma noro ha, ewtà. Kohkomo yakrataka neryewtay hatà, Maryeya. Noro yonytxanàr xan kax mak nehxakon hatà. Txesusu wya thananàhrà xe rma haxa nehxakon hatà. Àro ke nenytxekonà roro rma hatà, Maryeya. ");
INSERT INTO hixNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mahta haxa ryhe, natamokyakon hatà. Tatamohtxoho hoye ro noseryehokekon hatà. Àro ke toy hatà, Txesusu hyaka. Rohà y, kekon hatà, àwya. Àsok tawro ronyhera manaye. Uro marma katamokyaha. Atamokhera naha, rowtà, kekon hatà. Rakoronomahra naha. Àro ke, oyowtà akoronomako kasko, àwya, kekon hatà, Mahta, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Onà wyaro haxa neyukye hatà, Kohkomo. Mahta y, kekon hatà. Mahta y, thenyehra rma haxa moseryehoken hamà. Anaro rha oyomyawon hoko moseryehoken hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Owyanye ronytxatxho ryhe, oyomyawon kom hoko oyehtxoho komo yoho rma haxa naha. Kohkomo rwon hak wenytxaxe, ken hamà, oyowtà, Maryeya. Àro ke, ronytxahra harha exko kahra ro mak wehxaha, àwya, kekon hatà, Txesusu, Mahta wya. ");
INSERT INTO hixNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Anato tehtoko, Khoryenkom yakoro nàrwonakon hatà, Txesusu. Atàknatxhe rma, onà wyaro nkekon hatà, ànhananàhrà ro komo kukuru, àwya. Amna yohà y, kekon hatà. Àsoke ryhe amna nàrwonano, Khoryenkom yakoro. Uhutwamohsoko, amna wya, kekon hatà. Àro rma hutwamohsoy hatà, Xowaw heno, tànhananàhrà rotho komo wya. Àro wyaro rma rha uhutwamohsoko, amna wya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Khoryenkom yakoro orwonàmnàtokonye, onà wyaro katxoko, kekon hatà, Txesusu, àwyanye. Apa y, enyhoru ro me naha, Khoryenkomo, kanye ro me hak nahtxoko, toto komo, omeroro, ohoko, katxoko. Apa y, amamehra nyhe rma hak oyonytxowà, toto komo, tkayaryet kom me harha, katxok xarha. ");
INSERT INTO hixNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Apa y, emahona ro amna ànyahmako, katxok xarha. ");
INSERT INTO hixNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Apa y, oseryewhokako, amna yanhànàtho hoko, katxok xarha. Apa y, amna xehra toto komo yexetxhe, amna xarha noseryewhokehe, àhokonye, àro ke oseryewhokako, amna hoko, katxok xarha. Apa y, anhà nkukmahtor me amna txeryko, katxok xarha. Àro wyaro rma Khoryenkom yakoro orwonàmtxoko, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kuknonano me nàrwonàmye xarha tà, tàwya Khoryenkomo hutwamohsotho me, koyuknye ro me noro hutwamohsotho me. Àsok hana manatxow ha, kekon hatà, tànhananàhrà ro komo wya. Anatoko onà wyaro manatxow hana. Kohsarakatawo màtetxow hana, axan komo hyaka. Onà wyaro màketxow hana, àwya. Hoymo y, ekeyu tàmko, rowya, màketxow hana. 3 me rma tàmko, ");
INSERT INTO hixNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","rohyawo ehxera esnàr ke, rohyaka hawana yomoknàr ke, màketxow hana, axan komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Àsok hana oyoyukyatxow ha, noro ha. Rompakahra exko kahra nay hamà, bàn yaye ro. Romàn mak wahuno ha kahra nay hamà. Nànàhtxow mak ha, rohokyamo, kahra nay hamà. Asanàmpàra wehxaha kahra nay hamà. Anyahrà yàmpàra wehxaha kahra nay hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Onà wyaro haxa nay hamà, noro ha. Nasanàmyan hamà. Àx oyehtxoho komo yàmyan hamà. Àsok tawro hana. Axan kom me tehtxoho hoye rohra hana oyoyukyatxow ha. Teryewrye ro rma haxa orwonàmtoho kom hoye ro ryhe, oyoyukyatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Onà wyaro àkehe, owyanye, kekon xarha tà. Apa y, uro ewakryeko kany me ehtxoko. Uro ewakryeko kany me oyehtokonye rma, oyowakryetxhe xaxa mak hampànà, Khoryenkomo, kekon hatà. Apa y, uhutwamohsoko, rowya, kany me ehtxok xarha. Uhutwamohsoko, rowya, kany me oyehtokonye rma, hutwamohsehe xaxa mak hampànà, noro ha, owyanye, kekon hatà. Àsok hana natxow ha, bàn yawon kom ha. Bàn komo hotar hoko, tey tey tey tawro yonytxatxhe rma, nahurmaketxow hamà. Àro wyaro rma rha, tàwya oyonytxatxhenye rma, oyoyukyatxhe xaxa mak hampànà, Khoryenkomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Àsok tawro hana. Uro ewakryeko kany komo rma, towakryexem me harha natxow hamà. Uhutwamohsoko, rowya, kany komo xarha, hutwetxow harha mà. Tey tey tey kany komo xarha, toyuhsom me harha natxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Àsok hana manatxow ha, kekon xarha tà. Thohke manatxow hana. Àsok hana omur komo meyukyatxow ha. Apa y, kana txko tàmko, rowya, kany me ehtokonye, okoye yàmpàra manatxow hamà, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Apa y, àhme tàmko, rowya, kany me xarha ehtokonye, txekerye yàmpàra manatxow hamà, àwyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Enyhoru marma màmyatxow hamà, ohokyamo wya. Àro wyaro rma manatxhe, omnyamo, anhà komo rma. Àsok haxa hana nay ha, oyàm kom ha, kahe yawono rma. Oyohonye rma haxa enyhoru yàmnye ro me nay hamà. Owyanye, oyokato tàmko, rowya, katxhe rma, tokato rma yàmyaha ha, noro ha, owyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Worokyamo yowye hatà, Txesusu, toto hyaye. Àrwomnà ro me toto yeryakon hatà, worokyamo. Tàhyaye otowàtxhe rma, nàrwonàmye harha tà, toto. Noseryehoketxkon hatà, toto komo. ");
INSERT INTO hixNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Onà wyaro nketxkonà rma haryhe tà, ukukur komo. Bewsekmu yano me xaxa we nowyaha ha, mokro, ketxkon hatà. Worokyamo yohà ymo yano me towsom me nay hamà, worokyamo, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Onà wyaro nketxkon xarha tà, anar komo, Txesusu wya. Kahe yawon yahoxetà xenyhoko, amna wya, yaworo xaxa manay hamà katxho me, amna wya, ketxkonà rma haryhe tà. Noro yahoxetà kukmanàr xe rma nehxatxkon haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Atxke ehutwatxho komo hutwekon mak hatà, Txesusu. Àro ke, onà wyaro nkekon hatà, àwyanye. Àsok hana natxow ha, owto hon kom ha, kekon hatà. Tosoyxemà ro me tehtokonye, natanàhnohyatxow hamà, owto hon heno komo. Àsok hana natxow ha, àro rye yawon komo xarha, kekon hatà. Tosoyxemà ro me tehtokonye, natakhahyatxow hamà, àro rye yawonotho komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Àro wyaro rma rha, tosoyxemà ro me tehtokonye, Satanasà ymo heno komo yatanàhnohràtho haryhe mà. Bewsekmu yano me worokyamo yownye me ryehtoko, worokyamo yosoynyàràtho kom haryhe mà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Okukur komo xarha, worokyamo yowyatxow hatà, kekon xarha tà. Àsok tawro hana. Bewsekmu yano me amna nowyaha kahra natxow hamà, nyamoro ha. Àro ke, Bewsekmu yano me towsom me nay hamà, worokyamo, tatoko rma owyanye, yaworohra mak màketxhe ha, ketxow hamà, okukur komo rma, owyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Khoryenkom yahoxet yano me haxa ryhe, worokyamo yowrà hoko wehxaha. Noro yano me townye me ryehtoko, onà wyaro kany me rma nay hamà, Khoryenkomo, owyanye. Akayaryet kom me naha, mosonà, ronànyaketxho, kany me nay hamà, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Àsok hana nay ha, horykomo ha. Tahoxerye ymo rma haxa nay hamà, kekon hatà. Tàyehryenke xarha nay hamà. Bànà rma yonyan hamà, waha komo yowomrà hona, kekon hatà. Àro ke ohxe nay hamà, àkatxho. Arhàn me rma nay hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Anatoko nomokyan hana, toto ymo. Bàn yonyetho yoho rma haxa tahoxerye nay hamà, noro ymo ha. Àro ke, bàn yonyetho yarymen hamà. Nàyehryenkehe xarha. Ryehrye ke kekurunhehe kanyetho rma kurunkehe. Nàyehryenkehe, omohsaho ymo. Àkatxhothàr xarha yaryaha. Tkatxho me harha neryaha, kekon hatà. Àro wyaro rma rha, rowya worokyamo yownàtoko, Satanas komo warymen hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Àsok hana manatxow ha, kekon xarha tà. Rakoro àtohra oyehtokonye, roxanhàn me rma manatxow hamà. Rohyaka toto komo yokhàra oyehtokonye, rohyaye maryatxow hamà, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Àsok hana nay ha, worokyamo ha, kekon xarha tà, Txesusu. Toto hyaye totowàtxhe rma, ahehnaha ten hamà. Tosarà yohoryan hamà. Xenyhera ro mak naha, àto. Àro ke, onà wyaro nken hamà. Toto hyaka harha àten hamà, romànàtho yaka harha, kehe, worokyamo, toto hyaye otowsahotho, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Àro ke nomokyaha harha, toto hyaka harha. Toto yowanà yonyaha. Bànàthàrà rma yonyaha. Ohxe harha naha, àmànà. Enyhoryexaho rma yonyaha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Àro wyaro tàwya xenyetxhe, tkukur komo yanyekyaha, worokyamo. 7 me nanyekyatxhe. Noro ymo yoho rma haxa, atxke natxhe, nyamoro ha, ànanyeketxhàyamo, kekon hatà. Toto yowan yaka nowomyatxhe, nyamoro ha, omeroro, àto roro tehtxoho menye. Àsok hana nay ha, tototho. Atxke rma haxa nay hamà. Amnyehra htxero, atxke nehxakon hakahpa. Àro wyaro atxke texetxhàràtho yoho rma haxa, atxke nehtxekehe haxa ha, norotho, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Àro wyaro Txesusu rwonàmnàtoko rma, teryewrye ro nàrwonàmye hatà, wosà. Toto komo waye ro, ohsamnohxemo komo waye ro, nàrwonàmye hatà. Onà wyaro nkekon hatà, Txesusu wya. Khoryenkomo newakryetxho me rma haxa nehxakon hamà, oyonà, kekon hatà. Noro newakryetxho me rma haxa nehxakon hamà, oyon me tesnàr ke mak ha, towan yawo ayanàr ke mak ha, owya àmanatàr yonàr ke mak ha, kekon hatà, wosà. ");
INSERT INTO hixNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Àna matà, kekon hatà, Txesusu. Khoryenkomo rwonà yonytxany kom haxa ryhe, noro newakryenàr me natxhe. Eyuknye ro komo rma, noro newakryenàr me xaxa mpànà natxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nohsamnohyatxkonà rma haxa hatà, toto komo, Txesusu hyaka. Onà wyaro nkekon hatà, àwyanye. Àsok hana manatxow ha, omnyamo, amnyeno rma komo, kekon hatà. Atxke rma haxa manatxow hamà. Kahe yawon yahoxetà xenyhoko, amna wya, màketxhe rma harye, rowya. Noro yahoxetà yonyhohra mak wehxaha, owyanye. Xonas heno hutwahkahpàra ehtxoko. Noro heno yanàmye hatà, Khoryenkomo, tàwya tahoxetà yonyhotho me, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Noro yanàmàthàr hoye ro, Khoryenkom yahoxetà hutwatxownà hatà, Enenefe hon heno komo. Àro wyaro rma rha Toto me Enusaho yasanàmtoho hoye ro, Khoryenkom yahoxetà muhutwetxhe hampànà, omnyamo, amnyeno rma komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Àsok hana nehxakon ha, Saromaw heno ha, kekon xarha tà. Tàywero rma haxa nehxakon hatà, noro heno, anar komo yoho rma haxa mak hatà. Àro ke, noro yonytxaxe nomokye hatà, wosà, notxwakomo. Sur yaworon heno komo notxwanà rma noro hatà. Nyamoro yowto rma, moxe rma haxa nehxakon hatà. Àsnye ro moxe rma haxa nomokye hatà, ànotxwan heno komo, Saromaw heno yonytxax mak hatà. Àsok hana manatxow ha, omnyamo, amnyeno rma komo, kekon hatà, Txesusu. Awawonye rma naha, ehonomnà xaxa. Saromaw heno yoho rma haxa ehonomnà me naha, noro ha. Noro yonytxahra mak manatxhe, omnyamo. Àro ke, amnye, Khoryenkomo wya wahanonkano ytxoho ro ho haxa, atxke rma haxa manatxhe hampànà. Àro rma ho, Sur yaworon heno komo notxwanà menyatxhe hampànà. Onà wyaro nkehe hampànà, noro ha, owyanye. Atxke rma haxa mehxatxkon hamà, rowyarohra oyesnàr komo ke, ehonomnà xaxa yonytxahra oyesnàr komo ke, kehe hampànà, Sur yaworon heno komo notxwanà, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Àro rma ho, Enenefe hon heno komo xarha menyatxhe hampànà, kekon xarha tà. Onà wyaro nketxhe hampànà, nyamoro ha, owyanye. Atxke rma haxa mehxatxkon hamà, amna wyarohra oyesnàr komo ke, ketxhe hampànà, owyanye, kekon hatà, Txesusu. Àsok tawro hana. Xonas heno yonytxatxownà hatà, Enenefe hon heno komo. Noro heno wya ekarymatxhe rma, anar me harha tanhànàthàyamo yonytxownà hatà. Nyamoro heno wyarohra mak manatxhe, omnyamo, amnyeno rma komo. Awawonye rma naha, ehonomnà xaxa. Xonas heno yoho rma haxa ehonomnà me naha. Noro yonytxahra mak manatxhe ha, omnyamo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kuknonano me nàrwonàmye xarha tà, Txesusu. Kweyur komo wyaro naha, Khoryenkomo rwonà, kekon hatà. Kweyur komo hotuhtotxhe rma, etahurhura tehxatxow hamà. Oryen yosnaka txeryhera tehxatxow hamà. Ahon hona haxa teryatxow hamà, kekon hatà. Àro rma ho ehtoko, kweyhetxow hamà. Bàn kom yaka towomsom komo xarha weyhetxow hamà. Àro wyaro rma rha Khoryenkomo rwonà tekarymetxow hamà, toto komo wya Khoryenkomo hutwatxho me, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kuknonano me rma rha nàrwonàmye xarha tà. Ohxe oyonur komo yehtoko, omeroro menyatxow hamà, kekon hatà. Tawasnye rma haxa manatxhe, ohnawonye. Ohxehra ehtok haxa, xenyhera ro mak manatxow hamà, kekon hatà. Tawanye mak manatxhe, ohnawonye. Àro wyaro rma rha, Khoryenkomo hutwahra oyehtokonye, tawanye manatxhe, ohnawonye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Khoryenkomo hutwany me wehxaha, kany me rma oyehtokonye, ohxe mpànà ehtxoko, kekon hatà. Noro hutwahra rma manatxow hana, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Khoryenkomo hutwany me oyehtokony haxa, tawasnye rma haxa manatxow hamà, ohnawonye. Awaràn wawon komo wyarohra ro mak manatxhe ha. Weyu wya kweyhontokono wyaro, tawasnye rma haxa manatxhe, ohnawonye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Txesusu rwonàmnàtoko rma, àhyaka nomokye hatà, horykomo, Farysewu rma. Omoko, rohyaka emtakmaxe, kekon hatà, àwya. Àro ke toy hatà, Txesusu, noro màn yaka. Bo, neryewtay hatà, emtakmaxe. ");
INSERT INTO hixNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Osomyakorokahra rma nemtakmekon hatà, Txesusu. Àro ke noseryehokay hatà, Farysewu. Àsok tawro harha, kàyweronàhyamatxho kom yawo rohra nay hamà, mosonà, kekon hatà, tàhnawo. ");
INSERT INTO hixNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Àro ke, onà wyaro nkekon hatà, Kohkomo, àwya. Àsok hana manatxow ha, omnyam ha, Farysew komo, kekon hatà. Àmkay marma oryenà korokaxaho wyaro manatxow hamà. Kàyweronàhyamatxho kom yawo ron me mosonyhetxhe rma haryhe, toto komo wya. Ohnawonye ryhe, àro yawo rohra mak manatxhe ha. Atxke rma haxa manatxhe, ohnawonye. Anar komo katxho hoko tehohkaxemà ro me xarha manatxhe, ohnawonye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Akàhpàn me manatxow hamà. Kàyweronàhyamanyenhàr me Khoryenkomo hutwahra manatxow hamà. Tàwya kàyweronàhyamantokonye rma, onà wyaro nkekonà, Khoryenkomo. On yawo ro ehtxoko, toto komo nenyàr me ohxe oyehtxoho menye, kekonà. Onà wyaro nkekon xarha. Ohnawony xarha, on yawo ro ehtxoko, ronenyàr me ohxe oyehtxoho menye, kekon xarha, Khoryenkomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Àro ke, onà wyaro ehtxoko. Ewakryehnàtho komo ewakryetxoko. Akatxho kom hoye tàmtxoko, àwyanye. Owyanye tàmnàkoko rma, ohnawony xarha amemra ehtxoko. Àro wyaro oyehtokonye, ohxe rma haxa manatxhe, Khoryenkomo wya, kekon hatà, Txesusu, Farysewu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Onà wyaro haxa àkehe, owyanye, Farysew komo wya, kekon xarha tà. Tanàhnohsom me manatxhe hampànà, omnyam heno. Àsok tawro hana. Anatàr komo yeher hoye desmu rma màmyatxow hamà, Khoryenkomo wya. Ohteran komo txko hoye, ahukna komo txko hoy xarha, anaro rha anatàr komo yeher hoy xarha, desmu rma màmyatxow hamà, Khoryenkomo wya, kàyweronàhyamatxho kom yawo ro oyosonyhonàr kom horà, kekon hatà. Onà wyaro kahra mak manatxhe. Àme rye rma haxa hak wehxe, toto kom hoko, kahra mak manatxhe. Khoryenkom xe rma haxa hak wehxe, kahra mak manatxhe. Àro wyaro ohxe oyehtxoho kom hok haxa tehxorye manatxhe. Àro wyarono rma, desmu yàmrà hoko xarha tehxorye manatxhe ha, Khoryenkomo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Tanàhnohsom me manatxhe hampànà, omnyam heno, Farysew komo, kekon xarha tà. Àsok tawro hana. Ohsamnohno ytxoho ro yawo oyehtokonye, ehonomnà komo yahon ho meryewtetxow hamà. Yakentawo otontokonye, Ha y, khananàhnye y tawro xe manatxow hamà, toto komo wya. Ehonomnà me oyonyàr komo xe manatxow hamà, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tanàhnohsom me manatxhe hampànà, omnyam heno, kekon xarha tà. Àsok tawro hana. Onamno ytxoho ro wyaro manatxow hamà. Xenyhera rma tehtokonye, onamno ytxoho ro yakmekyatxow hamà, toto komo, àywenyeke tesnàr komo ke. Àro wyaro rma rha, ohokonye nehohketxhe, toto komo, ayanhàn komo ywenyeke tesnàr komo ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Onà wyaro nkekon hatà, àyweronàhyamano ynye ro komo kukuru, Txesusu wya. Khananàhnye y, kekon hatà. Àro wyaro owya Farysew komo yokarymantoko, amna xarha meyan hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tanàhnohsom me rma rha manatxhe hampànà, omnyam heno xarha, àyweronàhyamano ynye ro komo, kekon hatà, Txesusu. Àsok tawro hana. Toto komo màhananàhyatxow hamà, thenyehra rma haxa mak ha, àwyanye eyuknuru yoho rma haxa mak ha. Omnyam xarha, eyukhura rma rha manatxhe. Nyamoro yakoronomahra mak manatxhe. Esnakanye nyhe rma àhananàhpàranye mak manatxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Tanàhnohsom me manatxhe hampànà, omnyam heno, kekon xarha tà. Àsok tawro hana. Ohoryen heno komo, Khoryenkom yanoto heno komo yotahetxkon hatà. Omnyamo ryhe, nyamoro heno yonamàthàràtho menyhoryetxhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Owyanye enyhoryetxho hoye ro, ohoryen heno komo yanhànà muhutwamohsetxow hamà, toto komo wya. Nyamoro heno wya etahatxhàyamonhàrà ohxe nay hamà, owyanye. Àsok tawro hana, owyanye enamàthàyamotho yonyhoryenàr ke hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Àro hoko rma, onà wyaro nkehe, Khoryenkom karyehtanà, khutwatxehkanye ro komo karyehtanà rma. Rorwonà yokarymanye ro komo ànyakyaha, romryenon komo hyaka. Ranoto komo rma ànyakyaha, àhyakanye. Ukukuthuyamo yotahetxhe hampànà. Ukukuthuyamo xarha yeryewhamnohyatxhe hampànà. Àro wyaro rma nkehe, Khoryenkom karyehtanà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Àro ke, amnyeno rma komo yanàhnohyaha hampànà, Khoryenkomo. Amnyehra thenyehra rma haxa nehxatxkon hatà, etahaxemo heno komo, Khoryenkomo rwonà yokarymanye ro heno komo, kekon hatà. Khoryenkomo wya akàhtono yeryetxhe rma, wayehye hatà, Akmew heno, totahatxho wya. Noro heno wyaro rma rha wayehtxownà hatà, Khoryenkom yanoto heno komo, thenyenohnà heno komo, totahatxho komo wya rma rha. Amnye nyhe rma àmahyakany haxa wayehye hatà, Sakaryeyas heno, totahatxho wya rma rha. Khoryenkom màn watxan yawo noro heno yotahatxownà hatà. Faka yaknyohtoho monye nyhe hatà, Khoryenkom màn màhto rma hatà, noro heno yotahatxownà hatà. Nyamoro heno yotahatxehkatxownà hatà, ohoryen heno komo, amnyeno rma horyen heno komo rma. Àro hoye ro, tanàhnohtàkaxem me rma haxa, manatxhe hampànà, omnyamo, amnyeno rma komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Tanàhnohsom me manatxhe hampànà, omnyam heno, àyweronàhyamano ynye ro komo, kekon xarha tà. Àsok tawro hana. Yaworon xaxa hutwamohsohra ro mak manatxhe ha, toto komo wya. Uhutwanyehnà komo kax mak manatxhe ha, kekon hatà. Uhutwatxahke toto komo yehtoko, onà wyaro màketxow hamà, àwyanye. Yaworonohnà àro ha, onhutwanàr komo ymo xako, màketxhe rma haryhe, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Àsnye ro toy hatà, Txesusu. Tàtonàr kom me rma, noro yakoro nàrwonatxkonà rma hatà, àyweronàhyamano ynye ro komo, Farysew komo xarha. Atxke toyuknur komo xe rma nehxatxkon haryhe tà, àwya, awexenàmrà yonytxanàr horà. Atxke màkehe, yaworohra mak màkehe, tawro xe rma nehxatxkon haryhe tà, Txesusu rwon hoko. Àro ke thenyehra nàrwonatxkon hatà, noro yakoro, anaro rha hok hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Àro wyaro Farysew komo rwonàmnàtoko, nohsamnohyatxkonà rma hatà, toto komo, Txesusu hyaka. Thenyehra rma haxa nehxatxkon hatà, yaken mew me hatà. Natakmekyatxkon hatà, thenyehra rma haxa tesnàr komo ke. Àto nehxatxkon xarha tà, Txesusu nhananàhrà ro komo. Nyamoro wya ryhe, onà wyaro nkekon hatà, Txesusu. Yaworon mehra ro mak natxhe ha, Farysew komo, kekon hatà. Yaworon mehra ehtxoho komo, katamaru wakano wyaro naha. Twakanonke rye katamaru yehtxoho wyaro, atxke rye rma haxa toto komo yeryaha, Farysew komo yanhànà, kekon hatà. Yaworon mehra ehtxoho kom hona mpànà xenytxoko. Nyamoro wyarohra mpànà ehtxoko, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yaworon mehra ehtxoho komo, toto komo nenyehtor me rma nay hamà. Amnye nenyhehe hampànà, Khoryenkomo, omeroron komo wya, kekon hatà. Àsok tawro hana. Uhutwahnàtho rma, thutwaxem me harha mpàn naha ha, amnye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Toto yakoro orwonàmnàtokonye, atxke orwonatxow hana, kekon xarha tà. Àro ke, temenye màketxow hana, anar komo wya oyonytxanàr kom hona. Ohxe mpànà ehtxoko, omnyamo, kekon hatà. Amnye, temenye orwonàmàthàyamotho yonytxamohsehe hampànà, Khoryenkomo, omeroron komo wya, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ronàhnàn komo y, onà wyaro àkehe, owyanye, kekon xarha tà. Awayehkany kom hona oseryehpàra ehtxoko. Àsok tawro hana. Tàwyanye awayehkatxhenye, oyeryewhamnohpàrany harha natxow hamà, nyamoro ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Khoryenkom hona haxa oseryehtxoko. Wayehkano ynye me naha, noro ha, kekon hatà. Tàwya wayehkano yeryetxhe rma, eryewhamnohno ytxoho ro na arymano ynye me xarha naha, noro ha. Ehonomnà xaxa kax mak naha ha. Noro hona rma oseryehtxoko. Àro wyaro àkehe, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Àsok hana nay ha, torono yehetho ha, kekon xarha tà. Ehetàhpenyehra nay hamà, torono. 5 torono txko yehetho rma, 2 kruseyrus me marma nay hamà. Ehetàhpenyenohnàtho txko rma yakoronomehe, Khoryenkomo, kekon hatà. Torono txko rma hutwahkahpàra ro mak naha. ");
INSERT INTO hixNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Àro ke, ohutwahkahpàranye rma rha naha, noro ha. Omnyam haxa ryhe, ehetàhpenye rma haxa manatxhe, torono yehetho yoho rma haxa mak ha, thenyenohnà rma yehetho yoho rma haxa mak ha, kekon hatà. Ohpotx komo yakenonà hutwany me xarha naha, noro ha. Àro ke ohutwahkahpàranye nay hamà. Àro ke oseryehpàra ehtxoko, toto kom hona, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Onà wyaro xarha àkehe, owyanye, kekon hatà. Txesusu mryenon uro kanye ro me ehtxoko, toto komo nenytxanàr me, oseryehpàra ro mak ha. Àro wyaro kanye ro me oyehtokonye, amnye onà wyaro nkehe xarha, Toto me Enusaho, owyanye, kekon hatà. Romryenon omoro kehe hampànà, kahe yawon komo nenytxanàr me, Khoryenkom yanoto komo rma nenytxanàr me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Àsok haxa hana manatxow ha. Txesusu mryenonàhnà uro màketxow hana, toto komo nenytxanàr me, àhonanye oyoseryehrà komo ke mak ha, kekon hatà. Àro wyaro owyanye tatoko, amnye onà wyaro nkehe xarha, Toto me Enusaho, owyanye. Romryenonàhnà omoro kehe hampànà, kahe yawon komo nenytxanàr me, Khoryenkom yanoto komo rma nenytxanàr me, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Àsok hana natxow ha, Toto me Enusaho wàràhyakany kom ha, kekon hatà. Noro wàràhyakanyenhàyamo hoko rma noseryewhokehe, Khoryenkomo. Tokato wàràhyakanyenhàyamotho hok haxa ryhe, oseryewhokahra ro mak naha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Àsok hana oyeryewhamnohyatxow ha, anar kom ha, kekon xarha tà. Oyeryewhamnohyatxow hamà. Ayaryatxow hamà, tohsamnohtoho kom yaka, tàwyanye oyonytxanàr kom horà. Tkayaryet komo hyaka xarha, ehonomnà komo hyaka rma, ayaryatxow hamà, àwyanye oyonytxanàr kom horà, kekon hatà. Àtoko rma, àsoke ryhe koskarymeno kahra ehtxoko. Àro hoko rma oseryehokahra ehtxoko. Àsoke ryhe roxanhàn komo weyukyatxowà kahra ehtxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Àtoko rma orwonàhyametxhe ha, Khoryenkom yokato. Orwon komo hutwamohsehe ha, noro ha, ohxe owyanye eyuhtoho menye, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ohsamnohxemo kom waye ro nàrwonàmye hatà, toto. Onà wyaro nkekon hatà, Txesusu wya. Khananàhnye y, kekon hatà. Rowtà àhananàhko. Amna yàm peno katxhotho hoye tàmpàra naha, rowya. Àro ke àhananàhko nyhe. Àhoykako, oyowtà hyaka, kasko, noro wya, kekon hatà, toto, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Àna matà, kekon mak hatà, Txesusu, àwya. Katxhonano hoko onytxano ynyehnà uro. Akatxho komo àhoykako kanyehnà uro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Onà wyaro nkekon xarha tà, Txesusu, toto komo wya. Ohxe mpànà ehtxoko, kekon hatà. Katxhonano hoko oyehohkatxho kom hona mpànà xenytxoko. Onà wyaro kahra ehtxoko. Tkatxhonke rma haxa ryehtoko, ohxe rma haxa wehxan hamà, kahra ehtxoko. Àro wyaro owyanye tatok haxa, yaworohra ro mak màketxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Àro hoko rma kuknonano me nàrwonàmye hatà. Tkatxhonke rma haxa nehxakon hatà, toto, kekon hatà. Noro natàrà ryhe, tehetaxemà ro me rma haxa nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Àro ke, onà wyaro nehutwekon hatà, tàhnawo. Ronatàrà yeherà mànàtho, àwararohra harha nay hamà. Àro ke, àsoke ryhe wehxano, kekon hatà, tàwya rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Onà wyaro haxa wehxan hamà, kekon hatà, noro ha. Ronatàrà yeherà mànàtho warymen hamà, kekon hatà. Anaro ymo harha weryan hamà, horyetho ymo haxa, kekon hatà. Àro ymo yaka wenkahyan hamà, ronatàrà yeherà, rokatxho xarha, omeroro rma, kekon hatà, tàwya rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Àro wyaro rowya enkahtàkatxhe rma, onà wyaro àken hamà, kekon xarha tà, tàwya rma. Ohxe haxa wehxaha, àken hamà, amnye. Thenyehra rma haxa naha, ronyahrà, rokatxho xarha, àken hamà, amnye, kekon hatà, tàwya rma. Yake ro rotxemnyehàntatho wararo nay hamà, àken hamà, amnye, kekon hatà, tàwya rma. Àro ke romyawon hokohra harha wehxan hamà, àken hamà, amnye. Rasahxemtonàr hoko roro harha wehxan hamà, àken hamà, kekon hatà, tàwya rma. Ryeryehotanàr hoko roro wehxan hamà, àken hamà, amnye, kekon hatà, noro ha, tàwya rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Onà wyaro haxa nkekon hatà, Khoryenkomo, noro heno wya. Tàywenyekeno rma omoro, kekon hatà, àwya. Amnye rma kohsaya awayehyaha hxak hampànà, kekon hatà, Khoryenkomo, àwya. Àsok hana nay ha, onenàmatxhàràtho ha, kekon xarha tà, àwya. Awayhàtxhe, akatxho mehra harha nay hamà, kekon hatà, àwya. Anar komo katxho me harha nay hamà, kekon hatà, Khoryenkomo, noro heno wya, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Noro heno wyaro rma rha natxow hamà, tekatxhomaxem komo, kekon xarha tà. Tkatxho komo henyekyatxow hamà, amnye ohxe tesnàr kom horà. Ewakryehnà ro me mak nyamoro yonyaha, Khoryenkomo, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Onà wyaro nkekon xarha tà, Txesusu, tànhananàhrà ro komo wya. Onà wyaro àkehe, owyanye, kekon hatà. Oseryehokahra ehtxoko, ànyahpàra oyehtxoho kom hoko. Kwayehyan hamà, ànyahpàra ryesnàr ke, kahra ro mak ehtxoko, kekon hatà. Oseryehokahra rma rha ehtxoko, àwomumra oyehtxoho kom hoko xarha. Rohunutho natanàhnohyan hamà, àwomumra ryesnàr ke, kahra ro mak ehtxoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Khoryenkom yano me àwayehpàra rma hak oyehtokonye, noro yano me rma rha tànyahmaxem me manatxow hamà. Noro yano me tuhnye rma hak oyehtokonye, noro yano me rma rha twomumtosom me manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Àsok hana nay ha, torono ha. Àhomohra nay hamà. Osowrukhura xarha nay hamà. Tànyahrà màmtohra xarha nay hamà, kekon hatà. Àsok tawro hana. Torono nyahmen hamà, Khoryenkomo, kekon hatà. Àro ke, omnyam xarha anyahmetxow hamà, noro ha. Àsok tawro hana. Torono komo yoho rma haxa noro nàhnàn me manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Oyoseryehokatxho komo rma, ohorymamnohpàranye nay hamà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Àro ke, oseryehokahra ro mak ehtxoko, ànyahpàra oyehtxoho kom hoko, àkatxhomra oyehtxoho kom hoko xarha, àwomumra oyehtxoho kom hoko xarha. Àsok make oyehtxoho kom hoko rma, oseryehokahra ro mak ehtxoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Àro hoko rma, onà wyaro nkekon xarha tà. Àsok hana nay ha, txawarkoyato ha, kekon hatà. Tomyawon hokohra nay hamà. Twomun yenyempera nay hamà. Ohxe tonyxem me mak naha, txawarkoyato, kekon hatà. Àsok hana nehxakon ha, Saromaw heno ha. Ohxe tonyxemà ro me rma haxa nehxakon hatà, noro heno. Ehonomnà womun yawo tehtoko, ohxe tonyxemà ro me nehxakon heno hatà. Onà wyaro mak àkehe, owyanye. Noro heno yoho rma haxa, ohxe tonyxem me naha, txawarkoyato, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Àsok tawro hana. Khoryenkomo ryhe, txawarkoyato yeherkotkuryen hamà. Ohxe tonyxem me neryan hamà, àwomumtonàrà wyaro mak ha, kekon hatà. Txawarkoyato ryhe, mexehra ehxah me, ehxen me harha nay hamà. Taknyohsom me rma nay hamà. Mexehra tehxemà rma womumtehe, Khoryenkomo, ohxe tonyxemà ro me ehtxoho me. Àro yoho rma haxa owomumtony kom me nay hamà, noro ha. Àsok tawro noro hona xenyhera manatxowà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Anyahrà kom hoko roro ehutwahra ehtxoko, kekon xarha tà. Owokru kom hoko roro xarha ehutwahra ehtxoko. Àro hoko rma, oseryehokahra ehtxoko, ohnawonye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Àro hoko roro nehutwetxow hamà, toto komo, anaro rha yana komo, omeroron komo. Ayahyehrà komo hutwany me mak naha, oyàmkomo, kahe yawono. Tànyahrà komo xe natxow hamà, kany me rma naha, noro ha, ohokonye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Àro ke, on hok haxa ehtxoko, omnyamo. Khoryenkomo mryenon me oyehtxoho kom hoko ehtxoko. Àro hoko rma oyehtokonye, anyahrà komo xarha yàmyaha, noro ha, owyanye, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Khoryenkomo mryenon komo ryhe omnyamo, kekon xarha tà, àwyanye. Yakenohnà komo rma omnyam hamà. Oseryehokahra mak ehtxoko, kekon hatà. Tàwyaro rma, towto yoh me rma rha oyeryatxhe ha, oyàmkomo, tano me ro mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Akatxho komo tàmtxoko, txenyeru hona, kekon xarha tà. Txenyeru rma tàmtxoko, àkatxhomnà komo wya. Àhenyekhera ehtxok hampànà, kekon hatà. Owyanye àhenyeknyetok haxa, amnye nosomtatken hamà, akatxhothàyamo. Anatoko nanhànten hana, otxenyerun komo yonàtho. Àro hoye ro nosomtatken hamà, otxenyerunuthuyamo, kekon hatà. Anatoko naryatxow hana, temenyem komo. Anatoko akatxhothàyamo yonahyan hana, hurutuhu. Àro wyaro rma nosomtatken hamà, akatxhothàyamo, onhenyeketxhàyamotho. Àro ke, kahe yawo oyowakryetxho kom hok haxa ehtxoko. Àro ryhe, osomtatkahnà ro me naha. Anhàntahnà ro me naha. Ehxera ro mak naha, any komo. Ehxera rma rha naha, hurutuhu, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Àsok tawro hana. Tano tkatxhonke oyehtokonye, tano roron me oyesnàr komo xe manatxow hamà. Kahe yaw haxa towakryexem me oyehtokonye, àtono ro me oyesnàr komo xe manatxow hamà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Onà wyaro nkekon hatà, Txesusu, tànhananàhrà ro komo wya. Horykomo yanoto komo wyaro ehtxoko, kekon hatà. Àsok hana nay ha, horykomo ha. Anatoko bàn yaye ten hamà, asahxemtoso. Thehtaxem yakoro asahxemtoso ten hamà. Àro ke, noro yomoknàr hona ro natxow hamà, anoto komo, kekon hatà. Mexehra nomokyan hamà ketxhe ha. Tomokàtxhe rma, bàn hotar hoko tey tey ken hamà, ketxhe xarha. Amamehra tahurmaketxow hamà, noro yowomtoho me, ketxhe xarha, kekon hatà. Àro ke, twomun komo yawnukyatxow hamà, anoto komo, osonyhoryenàr komo. Wey ho xarha natxow hamà. Àro wyaro thona ro rma haxa natxow hamà, kekon hatà. Nyamoro wyaro rma rha thona ro ehtxoko, omnyam xarha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Horykomo yomokàtxhe rma, towakryexem me natxow hamà, anoto komo, kekon xarha tà. Ànàkhàra rma tehtokonye, towakryexem me natxow hamà, thona ro tesnàr komo ke mak ha. Onà wyaro yaworo xaxa àkehe, owyanye, kekon hatà. Tanoto komo yanoto me harha noteryaha, horykomo, ewakryenàr kom horà. Noro ryhe twomunu yawnukyaha. Eryewtatxoko, emtakmaxe, kehe xarha, àwyanye. Noro ryhe, ànyahrà komo yaryaha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Anatoko kohsarakatawo nomokyan hana, horykomo, kekon xarha tà. Enmahpaya ehtok haxa nomokyan hana. Àsokentok hana. Àywenyeke rma natxow hamà, anoto komo. Thona roro rma tehtokonye, towakryexem me rma haxa natxow hamà, kekon hatà. Àro wyaro rma rha, thona ro oyehtokonye, towakryexem me rma haxa manatxhe, omnyamo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Onà wyaro uhutwamohsehe xarha, owyanye, kekon xarha tà. Àsok hana natxow ha, temenyem kom ha. Horykomo katxhotho yanàr xe tehtokonye, tomohtoho yokarymahra natxow hamà, noro wya. Àro ke uhutwahra rma nay hamà, horykomo, kekon hatà. Tàwya uhutwantok haxa, ànàkhàra esnàràtho haryhe mà, thona ro esnàràtho haryhe mà, bàn yaka owomrà kom hona xenyàràtho haryhe mà, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Àro wyaro rma rha, thona ro mpànà ehtxok ha, omnyam xarha. Àsokentok hana nomokyan ha, Toto me Enusaho. Owyanye omokhàra hak nay hamà tatoko rma, nomokyaha hampànà. Àro ke, thona ro mpànà ehtxok ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Amna yohà y, kekon hatà, Petru, àwya. Onok komo wya kuknonano me mekarymano, amna marma wya katà, omeroron komo wya haxa katà, kekon hatà, Petru. ");
INSERT INTO hixNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Anaro kuknonano me haxa neyukye hatà, Kohkomo. Bàn yaye tàtontoko, anotomano yeryan hamà, horykomo, kekon hatà. Tanoto komo yoh xarha wahanonken hamà. Toyuknye ro rma wahanonken hamà. Takàhsomà rma wahanonken hamà, tanoto komo yoh me noro yehtxoho me, kekon hatà. Romàn yawon komo xenyko, rohnawo, ken hamà, horykomo, àwya. Ànyahmatxok yoh hampànà, ken hamà, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Àsok hana nay ha, anoto komo yoh ha, kekon hatà. Anatoko àhoko roro nay hana, tanotomanyenhàrà rwon yawo ro mak ha. Tomokàtxhe harha, àhoko roro noro yehtxoho yonyan hamà, horykomo. Àro ke noro yowakryen hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Onà wyaro yaworo xaxa àkehe, owyanye. Tkatxho yoh me noro yeryan hamà, horykomo. Omeroron yoh me noro yeryan hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Àsok haxa hana nay ha, anoto komo yoh ha, kekon hatà. Anatoko àhokohra rma nay hana. Tanotomanyenhàrà rwonà yawo rohra harha nay hana, kekon hatà. Onà wyaro haxa nken hamà, tàwya rma. Nàramamyaha mak ha, horykomo, ken hamà. Omokhàra mak nay hamà, ken hamà, tàwya rma. Àro ke, àsok make rma haxa nay hamà, atxke tehtxoho hoko. Horykomo yanototho komo hpokyan hamà, kekon hatà. Kàrkomo komo, woràskomo komo xarha, nyamoro rma hpokyan hamà. Teryehotanàr hoko roro xarha nay hamà, tasahxemtonàr hoko roro. Tànyerhontanàr hoko roro xarha nay hamà, tanotomanyenhàr ramamrà ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Àsok tawro hana. Omokhàra mak nay hamà, horykomo, ken hamà, anoto komo yohà. Àro wyaro àwya tatoko rma, nomokyaha hampànà, horykomo, kekon hatà. Tanoto komo yohàtho yanàhnohyaha hampànà. Thenyehra rma haxa nanàhnohyaha hampànà. Toyuknyehnàtho komo hyaka neryan hamà, anàhnohno ytxoho ro na, kekon hatà. Àro ke, Toto me Enusaho yomohtoho hona ro mpànà ehtxok ha, omnyamo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Àsok hana natxow ha, anotonano kom ha, kekon xarha tà. Tanotomanye ro komo rwonàmàthàrà yoyukhura tehtokonye, tanàhnohsom me rma haxa natxow hamà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tanotomanye ro komo rwonàmàthàrà ywenyeke tehtokony haxa, tanàhnohpormaxem me natxow hamà. Atxke texetxhenye, tanàhnohpormaxem me nyhe rma natxow hamà, àywenyeke tesnàr komo ke mak ha, kekon hatà. Àro ke, Khoryenkomo rwonàmàthàrà ywero oyehtokonye, eyuhtxok xaxa mak hampànà. Anar komo yoho rma haxa eyuhtxok xaxa mak hampànà, àywero rma haxa oyesnàr komo ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Onà wyaro nkekon hatà, Txesusu. Teryewhamnohsom me rma haxa natxhe hampànà, toto komo, yukryeka hona romoknàr ke mak ha, kekon hatà. Taknyohsomà wyaro teryewhamnohsom me natxhe hampànà. Eryewhamnohpàn me rma hak natxow hamà. Teryewhamnohsom me esnàr komo xe mak wehxaha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Uro htxero mpànà teryewhamnohsom me wehxaha. Tuna kwaka toto yataymomnàtokono wyaro, ryeryewhamtoho yaka koteryaha hampànà, kekon hatà. Ryeryewhampàra ro rma haka, koseryehokehe rma haxa, rohnawo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Àsok hana màketxow ha, rohoko, kekon xarha tà. Onà wyaro màketxow hana. Yukryeka hona nomokye hamà, osohtahahra harha toto komo yehtxoho me, màketxow hana. Àro wyaro ehutwahra ehtxoko, rohoko, kekon hatà. Onà wyaro haxa àkehe, owyanye. Nosohtahetxhe xaxa mak hampànà, toto komo, yukryeka hona romoknàr ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Àro rye yawon komo ryhe, osoxehra harha natxhe hampànà. Tkukur komo xehra natxhe, anar komo, romryenon me esnàr komo ke mak ha, kekon hatà. 5 me natxow hana, àro rye yawon komo. 3 komo xehra natxhe, anar komo, 2 komo rma, romryenon me esnàr komo ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Buru komo xehra natxhe, àyàm komo, romryenon me esnàr komo ke mak ha. Tomsàr komo xehra natxhe, àyon komo, romryenon me esnàr komo ke mak ha, kekon hatà. Tàmryerà hetx komo xehra natxhe, awetxhuru komo, romryenon me esnàr komo ke mak ha. Àro wyaro osoxehra natxhe hampànà, àro rye yawon komo, yukryeka hona romoknàr ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Onà wyaro nkekon hatà, Txesusu, toto komo wya, ohsamnohxemo komo wya. Kamàmà yowomtoho nyero awarànà yomoknàtoko, tuna nomokyan hamà, kany me manatxow hamà, kekon hatà. Àro hoko yaworo màketxow hamà. Mexehra nomokyan hamà, tuna, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Anatoko, kamàmà yahkotohen nyero nomokyan hana, afefenà, sur nyero. Amnye thenyehra nay hamà, kamàmà, kany me manatxow hamà. Àro hoko yaworo rma rha màketxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tuna yomohtoho ywero manatxow hamà, kekon hatà. Amnye kamàmà yehtxoho ywero xarha manatxow hamà. Khoryenkom yano me tan ryehtxoho ywenyeke rma manatxhe. Yaworon mehra ro mak manatxhe ha, omnyamo, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Àsok hana wehxan ha, ohxe hana, ohxehra hana, màketxow hamà. Yaworo ehutwahra manatxow hamà. Yaworo tehutwahorye manatxhe haryhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Txenyeru yehetàhkanye wyaro manatxhe, Khoryenkomo wya, kekon xarha tà. Àsok hana nay ha, toto ha. Anaro wya txenyeru yehetàhken hamà, noro ha. Noro hoko ewakhàra harha nay hamà, ehemahra esnàr ke mak ha, kekon hatà. Owto yohà hyaka karyan hamà, ehemahra oyesnàr ke, ken hamà, àwya. Asama yarye tàtontokonye rma, tehemahorye nay hamà, ehetàhkatxhàràtho wya, owto yohà hyaka àwya tanàr hona, kekon hatà. Ehemahra rma ehtoko, watxa ymo yaka noro yahryempen hamà, owto yohà, tanoto wya, ahosno ynye ro wya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Onà wyaro àkehe, owyanye. Ehematxehkahra rma tehtoko, watxa ymo yawo roro nay hamà. Ahatakahra ro mak naha ha. Àro wyaro rma rha, anar me harha ayanhànàthàyamo yonyhera oyehtokonye, tanàhnohsom me manatxhe hampànà, omnyam xarha, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Àro wyaro Txesusu wya hananàhno ynyetoko rma, àhyaka nomohtxownà hatà, toto komo. Anar heno komo yokaytà yohtxownà hatà. Karyeryeya honotho heno komo yotahahetxok hatà, Peratusu, tanoto komo wya, arymano ynye ro komo wya, ketxkon hatà, Txesusu wya. Toknàthàyamo yàmyatxkenan hatà, nyamoro heno, Khoryenkomo wya. Àwyanye tàmnàtoko rma, netahetxok hatà, Peratus yano me hatà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Àsok hana muhutwetxow ha, kekon hatà, Txesusu, àwyanye. Onà wyaro muhutwetxow hamà. Atxke tehtxoho kom hoye ro wayehyatxok hamà, nyamoro heno, màketxow hamà. Tkukuthuyamo yoho rma haxa atxke nehxatxok hamà, Karyeryeya honotho heno komo, màketxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yaworohra mak màketxhe ha. Onà wyaro haxa àkehe, owyanye, kekon hatà. Anar me harha ayanhànàthàyamo yonyhera rma oyehtokonye, nyamoro heno wyaro tanàhnohsom me rma rha manatxhe hampànà, omnyam xarha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Onà wyaro nkekon xarha tà, àwyanye. Anaro heno komo yokaytà xarha menytxetxok hamà, kekon hatà. Wayehyatxok hatà, Xerusaryen hon heno komo, 18 heno komo rma. Serowe ho ehtokonye, àhonanye nemokotek hatà, nàmno ymo, kawono ymo. Àsok hana nyamoro heno muhutwetxow ha, kekon hatà. Onà wyaro muhutwetxow hamà. Atxke tehtxoho kom hoye ro wayehyatxok hamà, nyamoro heno, màketxow hamà. Tkukuthuyamo yoho rma haxa atxke nehxatxok hamà, màketxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yaworohra mak màketxhe ha. Onà wyaro haxa àkehe, owyanye, kekon hatà. Anar me harha ayanhànàthàyamo yonyhera rma oyehtokonye, nyamoro heno wyaro tanàhnohsom me rma rha manatxhe hampànà, omnyam xarha, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Taa. Ehetahnà yokarymay hatà, Txesusu. Khoryenkomo yoyuknyehnà komo kuknon me rma nàrwonakon hatà. Onà wyaro nkekon hatà. Tànatke nehxakon hatà, toto, kekon hatà. Ànatàr wawo nehxakon hatà, fek yohà, ànenamàthàrà rma. Ehetahra ro mak nehxakon hatà, fek yohàtho, kekon hatà. Fek yeher horà tàtontoko, xenyhera ro mak nehxakon hatà, noro, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Àro ke, onà wyaro nkekon hatà, tanoto wya, nat yonye ro wya. 3 me àtxemnyehàntanàr xehra yohà, fek yeher horà komokyakonà rma haryhe, kekon hatà. Ehxera ro mak naha, eherà, kekon hatà, tànatkemà. Àro ke amako yxako, kekon hatà. Amako yxako, ronatàrà yosakanàr hona, kekon hatà, tànatkemà, tanoto wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Onà wyaro haxa nkekon hatà, anoto. Rohà y, amahohra hak exko, kekon hatà. Àto rma hak nahko, kekon hatà, anoto. Àmàtkok hak wenyhoryexe, waxeronoryex haka, kekon hatà, anoto, tànatkemà wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Anaro txemnyeh wawo neheten hana, kekon xarha tà, anoto. Ehetantoko rma, ohxe nay hamà, kekon hatà. Ehetahra rma ehtok haxa, mamaheno yxak hamà, kekon hatà, anoto, tànatkemà wya, kekon hatà, Txesusu. Ehetahnà wyaro rma natxhe, Khoryenkomo yoyuknyehnà komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Taa. Hokano ytxoho yawasàn ho hananàhno ryakon hatà, Txesusu, ohsamnohno ytxoho ro yawo. ");
INSERT INTO hixNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Àto nehxakon hatà, wosà. Ekeh me rma haxa nehxakon hatà. Worokyamo yano me 18 me txemnyehàntay hatà, ekeh me roro hatà. Tkatuhke roro nehxakon hatà. Asanàmpàra ro mak nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Noro yonyey hatà, Txesusu. Nanyekye hatà, tàhyaka. Wosà y, kekon hatà, àwya. Oyonyhotan hampànà. Oyeheryanàthàrà ohnànkan hampànà, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tamorà yeryey xarha tà, àhona. Àtoko rma nasanàmye harha tà, wosà. Ohxe xaxa nay hamà, Khoryenkomo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ewakhàra mak nehxakon hatà, horykomo. Xuknewyana komo yohà rma mok nehxakon hatà, tohsamnohsomà ro komo yonye ro rma hatà. Hokano ytxoho yawasàn ho Txesusu wya wos yonyhoryetxho hoko ewakhàra nehxakon hatà. Àro ke, onà wyaro nkekon hatà, toto komo wya. 6 hona roro komyawon kom hoko tatamokhorye tehxatxhe, kekon hatà. 6 ho roro tomokhorye manatxhe, mosonà wya oyonyhoryenàr kom horà. Hokano ytxoho yawasàn ho haxa ryhe, osonyhoryehosohra momokyatxhe ha, kekon hatà, horykomo, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Onà wyaro haxa nkekon hatà, Kohkomo, àwya. Yaworon mehra manatxow hamà, omnyamo, kekon hatà. Hokano ytxoho yawasàn ho atamokhera ehtxoko kany me manatxhe. Àro wyaro kanye rma, àro rma ho matamokyatxhe, omnyamo, owoknà komo wokhanàr hoko. Àro ke, yaworon mehra manatxow hamà, kekon hatà. Owoknà komo meweketxow hamà, hokano ytxoho yawasàn ho. Maryatxow hamà, tuna yontoho me, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tonyhoryehorye rma haxa nahko hamà, mosonà, onà rma ho. Àsok tawro hana. Akmaraw yohamàtho me ryhe nay hamà, noro ha, kekon hatà. Noro yeryewhamnohyakon mak ha, Satanasà ymo. Ekeh me roro rma 18 me txemnyehàntaye. Noro rma, tonyhoryehorye rma nahko hamà, on ho, hokano ytxoho yawasàn ho, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Àro wyaro tawro hoye ro atxke tonyxem me nehxatxkon hatà, Txesus xanhàn komo. Anar kom haxa ryhe neryehotetxkon hatà, onyhoryeno ytxoho hoko rma haxa Txesus yesnàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Onà wyaro nkekon xarha tà, Txesusu. Àsok hana akayaryet kom me nay ha, Khoryenkom ha, kekon hatà. Àsok hana wekarymen ha, owyanye. Kuknonano me wekarymen hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nat horymamtoho wyaro nay hamà. Natà txko tenamyatxow hamà, mostakna nathàrà txko rma, kekon hatà. Kàwyanye enamnàtoko rma, hory mehra nay hamà, natà txko. Kàwyanye enamàtxhe, nahten hamà. Horymamyan hamà. Nasakmatahten hamà, thenyehra, kekon hatà. Amnye akmatar hona nemàmtetxow hamà, torono komo. Àro wyaro rma rha nehamyatxhe ha, Khoryenkomo mryenon komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Àsok hana akayaryet kom me nay ha, Khoryenkom ha, kekon xarha tà. Àsok hana wekarymen ha, owyanye. Kuknonano me xarha wekarymen hamà. ");
INSERT INTO hixNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wosà wya katamaru wakanomanàrà wyaro nay hamà. Yukwarà yeryan hamà, katamaru waka, kekon hatà. 3 waka hana neryan ha. Àro waw tehtoko, osonyhera harha nay hamà, yukwarà. Osonyhenà rma hoye ro twakanonke rye nay hamà, katamaru, omeroro, kekon hatà. Àro wyaro rma rha, tonyhoryetxehkaxem me natxhe, Khoryenkomo mryenon komo. Osonyhen hoye ro rma tonyhoryetxehkaxemà rye me natxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Toy xarha tà, Txesusu. Xerusaryen hona rma tekon hatà. Anaro rha owto horye tekon hatà. Hananàhno ryakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Onà wyaro nkekon hatà, toto, àwya. Rohà y, kekon hatà. Yakehra natxowà, tonyhoryexem komo, kekon hatà. Yakehra natxowà, tonyhoryexem komo. Onà wyaro haxa nkekon hatà, Txesusu, àton komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Krawame rma haxa tonyhoryexem me manatxhe, kekon hatà. Àsok hana nàmno hotayarye tàtetxow ha. Taxkàtnye ehtoko, krawame tàtetxow hamà, àro yarye. Àro wyaro rma rha krawame tonyhoryexem me manatxhe, kekon hatà. Tonyhoryexem me tesnàr komo xe rma natxhe haryhe, toto komo, thenyenohnà komo. Enyhoryehnà me rma natxhe ha. Àro ke, tonyhoryexem me oyehtxoho kom hoko rma haxa ehtxoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Àsok hana nay ha, horykomo ha, kekon xarha tà. Tàwya bàn yahurutxhe, owomtxoko kahra harha nay hamà, toto komo wya, tàhyaka omohxemotho komo wya. Màmyaye natxow hana, nyamoro ha. Tey tey tey ketxow hana. Horykomo y, ahurmakako, amna yowomtoho me, ketxow hana. Onà wyaro haxa neyukyatxow hamà, noro ha, kekon hatà, Txesusu. Onok hana omnyam ha ken hamà. Oywenyekenye wehxaha ken hamà, àwyanye. Àro wyaro rma rha manatxhe hampànà, amnye ha, kekon hatà, àton komo wya. Amna yohà y, oyowto hona amna nomokno, màketxhe hampànà. Ahurmakako, amna yowomtoho me, màketxhe hampànà. Onà wyaro haxa oyoyukyatxhe hampànà, noro ha, kekon hatà. Onok hana omnyam ha kehe hampànà. Oywenyekenye wehxaha kehe hampànà, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Onà wyaro màketxhe hampànà, àwya. Amna yohà y, ayakoro amna nemtakmekonà, màketxhe hampànà. Amna yowto ho oyehtoko, amna màhananàhyakonà, màketxhe hampànà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Onà wyaro haxa nkehe hampànà, noro ha, owyanye, kekon hatà, Txesusu. Oywenyekenye wehxaha, àkan haxa hawe, owyanye, kehe hampànà. Àtotxok ha, rohyaye, atxke rma haxa oyesnàr komo ke, kehe hampànà, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Àtoko rma owratetxhe hxak hampànà, kekon hatà. Àto rma Akmaraw menyatxhe hampànà. Esake xarha, Xako xarha, Khoryenkomo rwonà yokarymanye rotho komo xarha menyatxhe hampànà. Khoryenkom yowto ho natxhe hampànà, nyamoro ha. Omnyam haxa ryhe, owompàra ro mak manatxhe hampànà. Àro ke owratetxhe hxak hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Àto rma rha natxhe hampànà, anaro rha yana komo xarha, kamàmà yahatakatxho nyeron komo rma, kamàmà yowomtoho nyeron komo xarha, kamàmà yahkotohen nyeron komo xarha. Khoryenkom yowto ho nasahxemtetxhe hampànà, nyamoro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Àsok tawro hana, kekon xarha tà. Amnye rma ehonomnà mehra tonyxem me natxow hamà, anar komo. Amnye ehonomnà me harha nyamoro yeryaha, Khoryenkomo, kekon hatà. Anar kom haxa ryhe, amnye rma ehonomnà me tonyxem me natxow hamà. Amnye ehonomnà mehra harha mpànà nyamoro yeryaha ha, Khoryenkomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Àro wyaro Txesusu wya katxhe rma, nomohtxownà hatà, Farysew kukur komo, àhyaka. Oyotahanàr xe nay hatà, Eroknesà, ketxkon hatà, àwya. Àro ke, oyoro ro oyokahtàmyan hamà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Yawarye wyaro temenye nay hamà, Eroknesà, kekon hatà. Àtotxoko, àhyaka. Onà wyaro màketxhe ha, àwya. Worokyamo yowrà hoko rma nay hatà, Txesusu, màketxhe ha, Eroknesà wya. Onyhoryeno ynyàr hoko rma nay hatà, màketxhe ha, kekon hatà, Txesusu. Mexehra nyhe rma àhok nay hatà, màketxhe ha, àwya. Mexehra ehxah me àhokohra harha nay hatà. Àtàhkatxehkan haxa ha, àna ha, ken hatà, màketxhe ha, Eroknesà wya, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Xerusaryen hona àtehe rma, mexenohnà me mak ha. Mexehra mpànà wehxaha ha, ahatakaxah me, kekon hatà. Àsok tawro hana. Xerusaryen ho ryhe totahaxem me natxow hamà, Khoryenkomo rwonà yokarymanye ro komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Àsok hana natxow ha, Xerusaryen hon kom ha, kekon xarha tà. Amnyehran heno komo, Khoryenkomo rwonà yokarymanye ro heno komo yotahetxkonà, Xerusaryen hon heno komo rma, kekon hatà. Tàhyakanye ànyahxemotho komo rma yotahetxkonà, toh ke. Amnyeno rma komo xarha, roxehra natxhe, Xerusaryen hon komo rma. Nyamoro rma kurunhonàr xe roro wehxakon haryhe, kekon hatà. Àsok hana nay ha, apaytara ha. Tahothàrà yosnaka tàmxekrà yohamnohyan hamà, ukurunhonàr horà. Àro wyaro rma rha, Xerusaryen hon komo kurunhonàr xe roro wehxakon haryhe. Tkurunhonàr komo xehra mak natxhe, rowya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Àsok tawro hana. Àxanomkahnohsah me harha naha, Xerusaryen heno. Àto ehxera harha wehxaha. Ronyhera harha natxhe hampànà, àton komo, kekon hatà. Yukryeka hona harha romokhàra ro rma haka, ronyhera roro rma natxhe hampànà, Xerusaryen hon komo. Romokàtxhe, ronyatxhe harha, àton komo, amnyen komo. Àtoko rma, onà wyaro nketxhe hampànà. Kohkom yano me omohsaho ryhe mosonà, towakryexem me xaxa hak nahko, mosonà, ketxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Anaro hokano ytxoho yawasàn ho ryhe, toy hatà, Txesusu, horykomo màn yaka. Farysew kukur komo yoh me nehxakon hatà, noro ha. Àmàn yaka rma emtakmaxe toy hatà, Txesusu. Àto rma rha nehxatxkon hatà, àyweronàhyamano ynye ro kukur komo, Farysew kukur komo xarha. Txesusu yonytxehketxkon hatà, nyamoro ha. ");
INSERT INTO hixNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Àto rma rha nehxakon hatà, toto. Ekeh me rma haxa nehxakon hatà, xoxo ymo wya hatà. Txesusu hyaka nomokye hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Onà wyaro nkekon hatà, Txesusu, àton komo wya. Kàyweronàhyamatxho kom yawo ro tehxorye tehxatxow hamà, kekon hatà. Àsok kat wehxano, owyanye, àro yawo ro ryehtxoho me. Hokano ytxoho yawasàn ho àsok kat wehxano. Onyhoryeno kat weryano. Onyhoryeno yhera kat wehxano, owyanye, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Eyukhura mak nehxatxkon hatà, nyamoro ha. Àro ke toto yahosày hatà, Txesusu. Nenyhoryey hatà. Ohxe àtoko, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Onà wyaro nkekon xarha tà, àton komo wya. Àsok hana manatxow ha, hokano ytxoho yawasàn ho, kekon hatà. Tuna yonà ymo yaka owoknà komo yehurkatxhe, anàmpàra kat manatxowà. Àna matà, amamehra manàmyatxow hamà, hokano ytxoho yawasàn ho rma, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Noro yoyukhura nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Farysew nanyeketxhàyamo yonyakon hatà, Txesusu. Ehonomnà komo yahon hona neryewtetxkon hatà. Àro wyaro rma newahrokotetxkon hatà. Àro ke, kuknonano me hananàhtxownà hatà, Txesusu, ewahrokotohra ehtxoko tawro me hatà. Onà wyaro nkekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Anatoko ayanyekyatxow hana, thehtaxemà, kekon hatà. Asahxemtoso ayanyekyatxow hana. Àsoken hona ryhe meryewtetxowà, ehonomnà komo yahon hona katà, kekon hatà. Àna matà, àrohnà hona eryewtatxoko. Àsok tawro hana. Anyehxah me rma rha nay hana, anaro, horykomo ymo, oyohon komo rma haxa, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ehonomnà komo yahon hona oyeryewtatxheny haxa, ohyakanye nomokyan hamà, ayanyeknyenhàyamo. Ayahonàhnà moro ken hamà, owyanye, kekon hatà. Moson yahon haxa moro ken hamà, ayanyeknyenhàyamo. Àro ke atxke tonyxem me manatxow hamà, esnakan komo yahon hona harha oyeryewtanàr komo ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Onà wyaro haxa ehtxoko. Anyehxah me oyehtokonye, esnakan komo yahon hona ryhe eryewtatxoko. Àro wyaro oyehtokonye, onà wyaro nken hamà, ayanyeknyenhàyamo, owyanye, kekon hatà. Hoymo y, on hona haxa ryhe eryewtako, ehonomnà komo yahon hona, ken hamà, owyanye. Àro wyaro àwya katxhe rma, ehonomnà me oyonyatxow hamà, àton komo, ayakoronye tasahxemtosom komo rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ehonomnà me oyosonyetokonye, norohnàtho me harha oyeryatxhe hampànà, Khoryenkomo, kekon hatà. Norohnàtho me haxa oyosonyetokonye, ehonomnà me harha oyeryatxhe hampànà, noro ha, kekon hatà, Txesusu, àton komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Onà wyaro nkekon xarha tà, Farysewu wya, tanyeknyenhàrà wya. Owya ahxemtono ynyetoko, toto komo manyekyatxow hamà, kekon hatà. Manyekyatxow hamà, axan komo, oyowtà komo xarha, okukur komo xarha, tkatxhonkemà ro komo xarha. Nyamoro rma ayanyekyatxhe xarha, kekon hatà. Amnye asahxemtoso ayanyekyatxhe ha. Àro wyaro owya tahxemtothàyamo yehemetxow hamà, nyamoro ha, kekon hatà. Onà wyaro haxa àkehe, owya. Àro wyaron kom marmahnà anyehko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Norohnàtho komo xarha anyehko, àkatxhomnà ro komo rma, ekeh komo xarha, àhrohnà ro komo xarha, enhunu ro komo xarha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Àsok tawro hana. Ehemahra ro mak natxow hamà, nyamoro ha, owya, norohnàtho me tesnàr komo ke mak ha. Oyowakryehe mak hampànà, Khoryenkomo, kekon hatà. Amnye, owya nyamoro yowakryetxhàràtho yehemehe hampànà, noro ha, owya. Àwayehxemo kom waye tàwya enyhoru komo yanàmnàtoko, nehemehe hampànà, owya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Àro wyaro tàwya enytxatxhe rma, onà wyaro nkekon hatà, toto, tasahxemtosom komo kukuru rma. Khoryenkom yowto ho tasahxemtosom me kehtoko, towakryexem me rma haxa tehxan hamà, kekon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kuknonano me haxa nàrwonàmye hatà, Txesusu. Horykomo wyaro nay hamà, Khoryenkomo, ahxemtono ynyenhàrà wyaro mak ha, kekon hatà. Àsok hana ahxemtono yeryey ha, horykomo ha. Nyahà ymo yeryey hatà. Àro ke toto komo yanyekye hatà, thenyenohnà kom hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ahxemtono ytxoho hahnok ehtoko, tanoto nyakye hatà, horykomo, nyah màtmatxhàyamo hyaka. Omohtxok hatà, tasahxemtetxow haxa hatà, kekon hatà, anoto, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tàtonàr komo xehra mak nehxatxkon hatà, nyamoro ha, omeroro. Àro ke noskarymetxkonà rma haryhe tà, horykomo yanoto wya, kekon hatà. Onà wyaro htxero nkekon hatà, anaro. Romararànà wehekahtyako, kekon hatà. Omokhàra wehxan hamà, romararànà yonyxe rotonàr ke, kekon hatà. Omokhàra ryehtxoho hoko ewakàhkahpàra hak nahko, horykomo, kekon hatà, noro ha, anoto wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Onà wyaro xarha nkekon hatà, anaro. 10 me faka wehekahtyako, ranoto me ehtxoho me, kekon hatà. Omokhàra wehxan hamà, faka yonyxe rotonàr ke, kekon hatà. Omokhàra ryehtxoho hoko ewakàhkahpàra hak nahko, horykomo, kekon hatà, noro ha, anoto wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Onà wyaro xarha nkekon hatà, anaro. Tàhyem harha uro. Àro ke omokhàra wehxan hamà, kekon hatà, noro ha, horykomo yanoto wya, kekon hatà, Txesusu. Àro wyaro noskarymetxkonà rma haryhe tà, nyah màtmatxhàyamo, tàtonàr komo xehra tesnàr komo ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Àro ke, horykomo hyaka harha toy hatà, anoto, kekon hatà. Omokhàra nyamoro yehtxoho yokarymatxehkay hatà, àwya. Ewakhàra rma haxa nehxakon hatà, horykomo, nyamoro hoko, tomoknàr komo xehra esnàr komo ke mak ha, kekon hatà. Àro ke, onà wyaro nkekon hatà, horykomo, tanoto wya. Àtoko, owto horye, asama yarye rma, kekon hatà. Norohnàtho kom haxa anyehtxa ha, àkatxhomnà ro komo rma, ekeh komo xarha, enhunu ro komo xarha, àhrohnà ro komo xarha, kekon hatà. Àro wyaron komo ryhe suhta ha, asahxemtotho menye, kekon hatà, horykomo, tanoto wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Àro ke toy hatà, anoto, kekon hatà. Amnye nomokye harha tà. Onà wyaro nkekon hatà, horykomo wya. Rohà y, norohnàtho komo wekno ha, orwon yawo ro mak ha, kekon hatà. Omàn yanohkahra mak natxhe, nyamoro ha. Anaro yosar komo rma hak nay hamà, kekon hatà, anoto, horykomo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Àro ke, onà wyaro nkekon xarha tà, horykomo, tanoto wya. Meya àtoko, owto hoye, àmàtkoko rma, enatokoko rma, kekon hatà. Àton komo xarha anyehtxa ha. Omohtxoko rma haxa mak hatà, horykomo màn yaka, màkehe ha, àwyanye, monyen komo wya, kekon hatà. Asahxemtoso omohtxok hatà, màkehe ha, àwyanye, tanohke ro rma haxa romànà yehtxoho me, kekon hatà, horykomo, tanoto wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Àsok hana natxow ha, ronanyeketxhàyamotho, tomoknàrà xanhànàtho komo rma, kekon xarha tà, horykomo. Rakoro asahxemtohra ro mak natxhe hampànà, kekon hatà, horykomo, tanoto wya, kekon hatà. Horykomo wyaro rma rha norohnàtho komo yanyekyaha, Khoryenkomo, towto hona, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Taa. Txesus yakoro tetxkon hatà, toto komo, thenyenohnà komo. Àwetxenye neramay hatà, Txesusu. Onà wyaro nkekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Àsok hana manatxow ha, kekon hatà. Ronhananàhrà ro me oyesnàr komo xe manatxow hana. Ronhananàhrà ro me oyehtokonye, onà wyaro ehtxok hampànà, kekon hatà. Okukur komo hnànàytxoho yoho rma haxa rox ehtxok hampànà, oyàm komo hnànàytxoho yoho rma haxa mak ha, oyon komo hnànàytxoho yoho rma haxa mak ha, ohetx komo hnànàytxoho yoho rma haxa mak ha, onyo komo hnànàytxoho yoho rma haxa mak ha, ohokyamo hnànàytxoho yoho rma haxa mak ha, oyowtà komo hnànàytxoho yoho rma haxa mak ha, owosàn komo hnànàytxoho yoho rma haxa mak ha, oyeheka komo hnànàytxoho yoho rma haxa mak ha, rox ehtxok hampànà, kekon hatà. Rohnànàytxoho yoho nyhe nyamoro xe oyehtokony haxa, ronhananàhrà mehra ro mak manatxhe ha, kekon hatà. Oyotàhnànàytxoho yoho xarha, rox ehtxok hampànà. Rohnànàytxoho yoho nyhe osox oyehtokony haxa, ronhananàhrà mehra ro mak manatxhe ha, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Onà wyaro nkekon xarha tà, àwyanye. Oyeryewhamnohtoho komo enàmtxok hampànà, kekon hatà. Àro wyaro enàmnye rma, rakoro àtotxok hampànà, ronhananàhrà ro me oyehtxoho menye. Oyeryewhamnohtoho komo yonàmpàra oyehtokony haxa, ronhananàhrà mehra ro mak manatxhe ha, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Krawame rakoro ototho komo thutwahorye mak naha, owyanye, kekon xarha tà. Àsok hana natxow ha, nàmno ymo yeny kom ha. Nàmno ymo yenyàr xe tehtokonye, wahoro htxero onà wyaro nehutwetxow hamà, kekon hatà. Rotxenyerunu yoho rma haxa tehetàhke naye, romànà, ketxow hamà. Tàwyanye etxehtohra ro rma haka, àro wyaro nehutwetxow hamà. Tàtxenyerun komo yoho rma haxa tehetàhke ehtoko, txeryhera natxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tàwyanye txenyetok haxa àtàhkahra natxow hamà, tehetàhke rma haxa esnàr ke, kekon hatà. Àro ke newnohyatxow hamà, anar komo, àtàhkahra esnàr komo ke mak ha. ");
INSERT INTO hixNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Tàwyanye àtàhkahnàtho yonyetxhe rma, onà wyaro nketxhe hampànà. Owyanye ymo hxako, ketxhe hampànà. Bàn komo yetxehtetxok haryhe mà, mokyamo, ketxhe hampànà. Àtàhkahra yxak mak nehxatxok hamà, ketxhe hampànà, xeny komo, nyamoro hoko, kekon hatà. Àro wyaro newnohyatxhe hampànà. Àro ke, tàwyanye etxehtohra ro rma haka, tehetàhke ehtxoho thutwahorye nay hamà. Àro wyaro rma rha, rakoro otohra ronye rma haka, krawame ototho komo thutwahorye naha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Waha me owto yoh komo totho wyaro xarha nay hamà, kekon xarha tà. Anaro owto yoh kom yakoro tatarymantokonye, wahoro htxero nehutwetxow hamà, owto yoh komo, kekon hatà. Tàtohra ronye rma haka, onà wyaro nketxow hamà. Twahak hana natxow ha, kàmryenon kom yakenonà, waha kom yakenonà, ketxow hamà. 10 mew me marma natxow hamà, ketxhe xarha. Kxanhànà mryenon kom yakenon haxa ryhe, 20 mew me natxow hatà, ketxhe xarha. Àsoke ryhe tehxatxowà, ketxhe xarha. Kàwyam katà tarymetxowà, nyamoro haxa katà karymetxowà, ketxow hamà, owto yoh komo, tàtohra ronye rma haka, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Anatoko, onà wyaro nketxow hana. Karymetxow hamà, nyamoro ha, ketxow hana. Àro wyaro tàwyanye tatoko, waha me àtohra natxow hamà. Tanoto kom haxa nyakyatxow hamà, tàxanhàn komo hyaka, kekon hatà. Moxe rma haxa nyamoro yehtoko, àhyakanye nànyakyatxow hamà. Amna wahar mehra ehtxoko kaxe nànyakyatxow hamà. Àsoke ryhe amna yesnàr xe manatxowà, amna wahar mehra oyehtxoho menye, kaxe nànyakyatxow hamà, owto yoh komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Àro wyaro rma rha, rakoro otohra ronye rma haka, krawame ototho komo thutwahorye naha. Otohra ronye rma haka, onà wyaro tkahorye naha, kekon hatà. Rokatxho hnàn yawohra ro mak wehxan hamà, moson yakoro rototho me, tkahorye naha. Akatxho komo hnàn yawo rma oyehtokonye, ronhananàhrà mehra ro mak manatxhe ha, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Onà wyaro nkekon xarha tà, àwyanye. Àsok hana nay ha, xura ha, kekon hatà. Ohxe nay hamà. Anatoko nanhànten hana. Tanhàntatxhe rma, ohxehra ro mak nay hamà. Xura me harha txeryhen me nay hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Àrotho rma, datàr komo yaxeronoryehra nay hamà, anhàntaxah me tesnàr ke mak ha. Tarymaxem me haxa nay hamà, àrotho, kekon hatà. Àro wyaro rma rha, atxke harha oyesnàr kom hona mpànà xenytxoko. Uro enytxatxoko, thanak oyehtokonye. Àhanahra kat manatxowà, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Taa. Txesusu hyaka nohsamnohyatxkon hatà, txenyeru yahosnye ro komo, atxke natxhe moxamo katxho komo xarha. Noro yonytxaxe nohsamnohyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Àro ke, noro hoko nàrwonatxkon hatà, Farysew komo, àyweronàhyamano ynye ro komo xarha. Atxke natxhe moxamo katxho komo yanyekyan hamà, mokà ymo, tàhyaka, ketxkon hatà. Nemtakmen xarha hamà, akoronye, ketxkon hatà, Txesus hoko. ");
INSERT INTO hixNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Àro ke, kuknonano me onà wyaro nkekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Àsok hana owoknàthàyamo mehoryatxow ha, kekon hatà, àwyanye. Àwaymamsahotho rma mehoryatxow hamà. Ehorhàra kat manatxowà. Mehoryatxow hamà, kekon hatà. 100 me owoknà komo yehtoko, 99 komo mànomyatxow hamà. Ahehnawo rma mànomyatxow hamà, towenyxanotho txko yohonàr horà, àwaymamsahotho txko yohonàr horà. Owyanye xenyhera ro rma haka, mehoryatxowà roro rma hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Owyanye xenyetxhe rma, teryehorye rma haxa manatxow hamà. Omotakanye manàmyatxow hamà. ");
INSERT INTO hixNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Omàn kom yaka harha maryatxow hamà, kekon hatà. Okukur komo manyekyatxow hamà, ohoyen komo rma. Omohtxoko, teryehotatxe, màketxow hamà, àwyanye. Roknàtho txko wenyo ha, àro ke teryehotatxe, màketxow hamà, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Onà wyaro àkehe, owyanye. Àro wyaro rma rha neryehotetxhe ha, kahe yawon komo, toto hoko, towenyxan hoko rma. Anar me harha tanhànàthàrà yonyenhàr hoko, neryehotetxhe ha, kahe yawon komo, kekon hatà. Eryehotahra mak natxhe ha, anar kom hoko, thenyenohnà kom hoko rma. Ranhàn ehxera naha kany kom hoko rma eryehotahra natxhe ha, kekon hatà. Anar me harha tanhànàthàyamo yonyehnà kom hoko rma, eryehotahra natxhe ha, kahe yawon komo, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kuknonano me xarha nàrwonàmye hatà, Txesusu. Àsok hana tàtxenyerunuthuru txko yohoryan ha, wos ha, kekon hatà. Atarymaxahotho rma yohoryan hamà. Ehorhàra kat naye, owyanye. Nehoryan hamà. 10 me nay hana, àtxenyerunu. Towenyxanotho txko natarymen hana. Àrotho rma yohoryan hamà. Weyu hotuhten hamà, xenyàr horà. Bàn yosnyen xarha hamà, kekon hatà. Tàwya xenyhera ro rma haka nehoryan roro rma haxa hamà. ");
INSERT INTO hixNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tàwya xenyetxhe rma, neryehoten hamà. Tkukur komo yanyekyan hamà, thoyen komo rma. Omohtxoko, teryehotatxe, ken hamà, àwyanye. Rotxenyerunutho txko wenyo ha, àro ke teryehotatxe, ken hamà, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Onà wyaro àkehe, owyanye. Àro wyaro rma rha neryehotetxhe ha, kahe yawon komo, Khoryenkom yanoto komo rma, kekon hatà. Neryehotetxhe ha, toto hoko, towenyxan hoko rma. Anar me harha tanhànàthàrà yonyenhàr hoko, neryehotetxhe ha, kahe yawon komo, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kuknonano me xarha nàrwonàmye hatà, Txesusu. Onà wyaro nehxakon hatà, toto, kekon hatà. Thohke nehxakon hatà. Asak nehxatxkon hatà, umur komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Onà wyaro nkekon hatà, umuru, àmahtàkàthàrà, tàyàmà wya. Apa y, amna hoko rma thoykaxem me nay hamà, akatxhothàrà, kekon hatà. Amnye rma rokatxho yahosnàr xe wehxaha. Tàmko, rowya, kekon hatà, àmahtàkàthàrà, tàyàmà wya, kekon hatà, Txesusu. Àro ke hoykay hatà, àyàm komo. Àhoye nàmye hatà, wahoto wya. Àhoye rma rha nàmye hatà, àmahtàkàthàrà wya xarha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Àho rma rha tkatxhothàrà yàmtàhkay hatà, àmahtàkàthàrà. Txenyeru hona nàmtàhkay hatà. Tàwya txenyeru yahosàtxhe rma, toy hatà, bàn yaye, kekon hatà, Txesusu. Monyen komo yowto hona toy hatà. Àto neryehotekonà rma haxa mak hatà, tàwya tàtxenyerunuthuru yàmrà ke hatà. Netxenyerunkekonà rma haxa mak hatà, teryehotatho hoko rma haxa tesnàr ke hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Taa. Netxenyerunkatxehkay haxa hatà. Àtoko rma ànyahpàra rma haxa nehxatxkon hakahpa tà, àton komo. Àro ke, tehetàhke rma haxa nehxakon hatà, nyahà. Tànyahrà yehekathàra ro mak nehxakon hatà, noro ha, àtxenyerumra ro mak tesnàr ke hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Àro ke toy hatà, horykomo hyaka tatamohtxoho me. Àton komo kukuru rma hatà noro ha, horykomo. Noro rma nanotomay hatà. Toknà komo nyahmanàr hoko ehxe nànyakye hatà, honyko wyaron komo rma nyahmanàr hoko ehxe hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Okno nyahàtho yonahrà xe rma nehxakon haryhe tà, tahyehrà ke rma haxa mak hatà. Ànyahrà yàmpàra ro mak nehxatxkon hatà, àton komo, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Amnye nehutway harha tà. Onà wyaro nkekon hatà, tàwya rma. Apapa yanoto komo ryhe, tànyahke rma haxa natxow hamà, kekon hatà, noro ha, tàwya rma, kekon hatà, Txesusu. Enahrà yoho rma haxa tànyahke natxow hamà, nyamoro ha, kekon hatà. Urotho haxa ryhe, àwayehpaya wehxaha, rahyehrà, kekon hatà, tàwya rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Àten hamà, apapa hyaka, kekon hatà. Apa y, ranhàn hoko rma haxa wehxaknano, àken hamà, àwya, kekon hatà. Khoryenkomo wanwekyaknano, omoro xarha kanwekyaknano, àken hamà, apapa wya, kekon hatà, tàwya rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Apa y, romuru omoro katxho mehra harha tehxorye wehxaha, urotho, owya, atxke rma haxa ryesnàr ke, àken hamà, àwya, kekon hatà. Apa y, ayanoto me harha uro txeryko, àken hamà. Apa y, ohyaka tatamohxemà ro komo wyaro rma uro txeryko, àken hamà, apapa wya, kekon hatà, tàwya rma. Àro wyaro nehutway harha tà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Àro ke toy harha tà, noro ha, tàyàm màn yaka harha. Moxe ro rma nenyey hatà, àyàmà. Buru hnàn yawo rma haxa nehxakon hatà. Àro ke àhyaka kàtay hatà. Wakeryemekye hatà. Namtxuhkay xarha tà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Apa y, ranhàn hoko rma haxa wehxaknano, kekon hatà, umuru, tàyàmà wya. Khoryenkomo wanwekyaknano, omoro xarha kanwekyaknano, kekon hatà. Romuru omoro katxho mehra harha tehxorye wehxaha, urotho, owya, atxke rma haxa ryesnàr ke, kekon hatà, umuru, tàyàmà wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Onà wyaro haxa nkekon hatà, àyàmà, tanoto komo wya. Moson hononà enyhoru rma suhtatxko ha, kekon hatà, àwyanye. Romuru màhonomtetxhe ha, kekon hatà. Amor hoko manewumtetxhe xarha, màhrowomumtetxhe xarha, kekon hatà, àyàmà, tanoto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Faka mxekàtho xarha mekyatxhe ha, kekon xarha tà, àwyanye. Ehsuryexahotho txko rma mekyatxhe ha, metahetxhe xarha, kasahxemtotho menye, keryehotatho menye, kekon hatà, tanoto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Àsok tawro hana. Àwayehsaho wyaro tan ehxera nehxaknan hamà, romuru, kekon hatà. Àwayehxemo kom waye asanàmsaho wyaro tan harha naha, kekon hatà. Àwaymamsaho wyaro rma ehxera nehxaknano, ehosaho wyaro rma kàhyawony harha naha, kekon hatà, àyàmà, tanoto komo wya. Àro ke nasahxemtotxownà hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Taa. Asahxemtontokonye rma, nomokye hatà, wahoto, umuru xarha. Tàyàm mararàn hoko ehxahotho rma nomokye hatà, bàn kom yaka harha, kekon hatà. Bàn komo hahnoke tehtoko, furwe txemeknyàrà yonytxay hatà. Àmanhonàr komo xarha yonytxay hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Àro ke tanoto komo kukuru yanyekye hatà. Àsok tawro furwe txemekyatxowà, kekon hatà, àwya. Àsok tawro manhetxowà, kekon hatà, tanoto wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Oyowtà nomokno harha, kekon hatà, anoto, àwya. Faka mxekàtho yotahahono, oyàmà, kekon hatà. Ehsuryexahotho txko rma yotahahono, tàhyaka harha oyowtà yomoknàr ke, àwayehpàra esnàr ke, ohxe esnàr ke, kekon hatà, anoto, wahoto wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ewakhàra mak nehxakon hatà, wahoto, towtà hoko tatakuynyàr ke. Àro ke, bàn kom yaka owompàra ro mak nehxakon hatà, kekon hatà. Àro ke nahatakay hatà, àyàmà. Àhyaka nomokye hatà. Owomkot ha, kekon hatà, àwya, teryewrye ro hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Onà wyaro haxa tàyàmà yoyukye hatà, noro ha, kekon hatà. Mexe rma haxa tatamohxemà ro me wehxaha, uro, ohyaka, kekon hatà, noro. Owya ranotomantoko, ayanweknyehnà ro me wehxaha, kekon hatà. Rahxemtohra mak manaha, kekon hatà. Owoknà kom hoye tàmpàra ro mak manaha ha, rowya, kekon hatà. Oyeryehotatxoko, okukur kom yakoro, kahra ro mak manaha ha, rowya, kekon hatà, wahoto, tàyàmà wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nuxe haxa ryhe mahxemton hamà, kekon xarha tà. Noro ryhe, atxke nehxak hatà, onàmàthàràtho yàmtàhkek hatà, woràskomo komo wya, twayamon komo wya, kekon hatà. Omokàtxhe rma, mahxemtono yxak mak hamà, kekon hatà. Ehsuryexahotho txko metahahon hatà, owya noro ymo yahxemtotho me hatà, kekon hatà, wahoto, tàyàmà wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Kàrà y, kekon mak hatà, àyàmà, àwya. Omoro ryhe, rohyawo roro manaha, kekon hatà. Rokatxhotho ryhe, akatxho me harha mpànà naha ha, omeroro, kekon hatà, àyàmà, buru wya, wahoto wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tasahxemtohorye mak tehxatxhe, kekon xarha tà, àwya. Àsok tawro hana, àwayehsaho wyaro tan ehxera nehxaknan hamà, oyowtà, kekon hatà. Àwayehxemo kom waye asanàmsaho wyaro tan harha naha, kekon hatà. Àwaymamsaho wyaro rma ehxera nehxaknano, ehosaho wyaro rma kàhyaw harha naha, kekon hatà. Àro ke tasahxemtohorye tehxatxow hamà. Teryehotahorye rma tehxatxow hamà, kekon hatà, àyàmà, buru wya, wahoto wya, kekon hatà, Txesusu. Àro wyaro Farysew komo kuknon me ryhe wahoto yehtxoho yokarymay hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kuknonano me xarha nàrwonàmye hatà, Txesusu. Onà wyaro nkekon hatà, tànhananàhrà ro komo wya. Tkatxhonke rma haxa nehxakon hatà, toto, horykomo, kekon hatà. Àkatxho yoh me nehxakon hatà, anoto. Noro yanhànà yonytxay hatà, horykomo, kekon hatà. Akatxhonken hampànà, ayanoto, teryehotanàr ke rma haxa mak ha, tawro rma yonytxay hatà, horykomo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Àro ke tanoto yanyekye hatà, tàhyaka. Ayanhànà wenytxano, kekon hatà, horykomo, àwya, kekon hatà, Txesusu. Rokatxho hutwamohsonàr xe wehxaha, owya, kekon hatà. Àro ke, omeroro àmenhoko, owya rokatxho yahosàthàràtho, owya rokatxho yàmàthàràtho xarha, kekon hatà, tanoto wya. Rokatxho yoh mehra harha mpànà manaha ha, kekon hatà, horykomo, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Àro ke nehutwekon hatà, anoto, tàhnawo, kekon hatà. Àsoke ryhe wehxano, kekon hatà. Tkatxho yoh mehra harha ryeryan hatà, ranotomanyenhàràtho, kekon hatà, tàwya rma, kekon hatà, Txesusu. Noro hyaka atamokhera harha wehxan hamà. Àsok katà katamokyano, ronyahrà yehekahtoho me, kekon hatà. Yukryeka yakany menyxehra wehxaha, kàrhàra ryesnàr ke, kekon hatà. Uro nyhe txko ronyahrà ha tawro xehra xehxaha, anar komo wya. Àro wyaro tawro hona kàhyahamyaha, kekon hatà, horykomo yanototho, tàwya rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Onà wyaro haxa wehxan hamà, kekon hatà. Horykomo katxho yoh me rma hak ryehtoko, noro katxho yehetàhkanyenhàyamo wewakryen hamà, amnye nyamoro wya haka rha rowakryetxho me, kekon hatà, tàwya rma, kekon hatà, Txesusu. Amnye, horykomo yanoto mehra harha ryehtoko, ranyekyatxow hamà, ronewakryetxhàyamo, bàn kom yaka, tàwyanye ronyahmatxho me, kekon hatà, horykomo yanototho, tàwya rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Àro ke, horykomo katxho yehetàhkanyenhàyamo yanyekye hatà, noro ha. Osomahyaka nomohtxownà hatà, àhyaka, kekon hatà. Onà wyaro nkekon hatà, noro ha, wahoro htxero omohsaho wya. Twahak mehetàhkeko, horykomo katxho, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Hàà, oryefera katà wehetàhkeko, 100 enà ymo, kekon hatà, noro ha. Àna hamà, kekon hatà, horykomo yanototho. Tan naha, àmenhosahotho, onehetàhkatxhàràtho rma, kekon hatà. 100 enà katxhotho towko, 50 enà katxho haxa àmenhoko, amamehra rma àmenhoko, kekon hatà, horykomo yanototho, wahorono wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Twahak mehetàhkeko, omoro, kekon xarha tà, anaro wya. Hàà, nasànasà wehetàhkeko, 100 enà ymo, kekon hatà, noro ha. Àna hamà, tan naha, àmenhosahotho, onehetàhkatxhàràtho rma, kekon hatà, horykomo yanototho. 100 enà katxhotho towko, 80 enà katxho haxa àmenhoko, kekon hatà, horykomo yanototho, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Àsok hana nehxakon ha, horykomo yanototho ha, kekon hatà. Yaworohra nehxakon hamà, tanotomanyetho katxhotho hoko. Onà wyaro mak kekon hatà, horykomo, tanototho hoko. Takàhso nehxak hamà, ranototho, amnye towakryetxho hona tàwya xenyàr ke mak ha, kekon hatà, horykomo, kekon hatà, Txesusu. Onà wyaro àkehe, owyanye. Khoryenkomo hutwanyehnà komo ryhe, tosowakryetxho kom hoko takàhso rma haxa natxow hamà. Khoryenkomo hutwany komo yoho rma haxa takàhso natxhe, tosowakryetxho kom hoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Àro ke, onà wyaro xarha àkehe, owyanye. Toto komo ewakryetxoko, axan kom me nyamoro yehtxoho me. Akatxho kom hoye tàmtxoko, àwyanye. Ayanàhnohnye kom hoye rma tàmtxoko, àwyanye, kekon hatà. Àro hoye toto komo ewakryetxoko, amnye ohxe roro rma haxa oyehtxoho menye. Akatxhothàyam heno yosomtatkatxhe rma, towto hona ayanyekyatxhe hampànà, Khoryemkomo. Osomtatkahnà ro hona rma ayanyekyatxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Anar komo katxho yoh me oyehtokonye, yaworo ehtxoko, kekon hatà. Àsok tawro hana. Yakenohnà hoko yaworo oyehtokonye, yaken hoko xarha yaworo rma rha manatxow hamà, kekon hatà. Yakenohnà hoko yaworohra haxa oyehtokonye, yaken hoko xarha yaworohra rma rha manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Katxhonano hoko yaworohra oyehtokonye, oyowakryehranye nay hamà, Khoryenkomo, tkatxho hoye. Ayanàhnohnye kom hoko rma yaworohra oyehtokonye, anhàntahnà ro hoye oyowakryehranye nay hamà, noro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Anar komo katxho hoko yaworohra oyehtokonye, tkatxho hoye tàmpàra nay hamà, Khoryenkomo. Akatxho me harha tàmpàra nay hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Horykomo yanoto ro me kehtoko, anaro rha yanoto mehra tehxan hamà. Asako kanotomany komo yehtok haxa, onà wyaro tehxan hamà, kekon hatà. Anaro xehra tehxan hamà. Anaro xe tehxan hamà. Anaro tàxanomkahnohyan hamà. Anaro teyukyan hamà, kekon hatà. Àro wyaro rma rha, katxhonano hokono ro me oyehtokonye, Khoryenkom hokon mehra manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Àro wyaro katxho yonytxatxownà hatà, Farysew komo. Katxhonano yahosnàr xan komo rma mokyam nehxatxkon hatà. Àro ke, Txesusu rwonà yownohyatxkon hatà, nyamoro ha. Àna make ryhe mpe, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Yaworon me mosonyhetxhe rma haryhe, omnyamo, toto komo wya, kekon hatà. Oyehutwatxho komo hutwehe mak ha, Khoryenkomo. Ohxe toto komo nenyàrà rma, atxke tonyxem me naha, Khoryenkomo wya, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Xowaw heno yomokhàra ro rma haka, tokarymaxemà ro me nehxakon hamà, kàyweronàhyamatxho komo, Moyses heno nmenhotho rma, Khoryenkomo rwonà yokarymanye ro heno komo nmenhotho xarha, kekon hatà. Xowaw heno yomokàtxhe rma, àrwo yonyhorunu ryhe tokarymaxemà ro me harha nay hamà. Àsok hana akayaryet kom me nay ha, Khoryenkom ha, katxho rma, tokarymaxemà ro me harha nay hamà. Àro ke, noro mryenon me harha tehtxahke rma haxa natxow hamà, toto komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Onà wyaro haxa àkehe, owyanye. Enytxahnà me harha nay hamà, Moyses heno nmenhotho, kahra ehtxok hampànà. Omeroro rma, tonytxaxem me roro rma haxa naha. Kahe heno ryhe nosomtatkehe hampànà, amnye ha. Yukryeka heno xarha nosomtatkehe hampànà. Moyses heno nmenhotho haxa ryhe, tehxe roro rma haxa mpànà naha ha. Tonytxaxem me roro rma haxa mpànà naha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ohetx komo hyaye otowhàra ro mak ehtxoko, kekon xarha tà. Àhyayenye oyotownàtokonye rma, anaro wos yahohsàra ro mak ehtxoko. Owyanye anaro yahosnàtoko rma, atxke manatxhe, ohetxe ro kom mehra noro yesnàr ke mak ha, kekon hatà. Tànyonhàrà hyaye wos yotowàtxhe, ohetx kom me noro yahohsàra ro mak ehtxoko. Owyanye ahosnàtoko rma, atxke manatxhe, anaro hetx me noro yesnàr ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kuknonano me xarha nàrwonàmye hatà, Txesusu, katxhonano hokono ro mehra ehtxoko tawro me hatà. Onà wyaro nkekon hatà. Onà wyaro nehxakon hatà, toto, horykomo, kekon hatà. Tkatxhonke rma haxa nehxakon hatà. Ehetàhpenye rma haxa nehxakon hatà, àwomunu. Tànyahke rma haxa nehxakon xarha tà, noro ha, kekon hatà. Emahona ro thenyehra rma haxa nasahxemtekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Noro màn hotawo nehxakon hatà, toto. Norohnàtho rma haxa mok nehxakon hatà, àkatxhomnà ro mak hatà. Rasru rma noro hatà, kekon hatà. Ekeh me rma haxa nehxakon hatà, Rasru, kapàtko ymo wya. Tàraho roro nehxakon hatà, norotho, horykomo màn hotawo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nahyehyakonà roro hatà. Horykomo nyahrà hpunutho yonahrà xe nehxakon hatà. Arymaxahotho rma yonahrà xe nehxakon hatà, tahyehrà ke. Norotho hyaka nomokyakon hatà, kaykusu, kapàtko meryekmanàr horà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Wayehye hatà, norotho, kekon hatà. Àwayhàtxhe rma, noro yokatotho yatxownà hatà, kahe yawon komo. Akmarawu hyaka natxownà hatà, kekon hatà. Tkatxhonkemà rotho xarha wayehye hatà. Noro heno yonamtxownà hatà, ukukuthuyamo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Noro yokatotho haxa ryhe, yuhnayen hona toy hatà, anàhnohno ytxoho ro na rma hatà. Neryewhamyakonà rma haxa mak hatà, noro ha, kekon hatà. Àro ke nosompotày hatà. Akmaraw komo yonyey hatà, moxe ro. Rasru xarha yonyey hatà. Akmarawu hyawono rma yonyey hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Àro ke teryewrye ro nàrwonàmye hatà. Akmarawu y, tamutho y, rohnàn yaw exko, kekon hatà. Rasru ànyahko, rohyaka, kekon hatà. Natamohpan haka, tuna kwaka. Ronyur hak txenotmano, tuna ke, kekon hatà. Keryewhamyaha rma haxa, onà ymo wawo, weheto ymo wawo, kekon hatà, Akmarawu wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Onà wyaro haxa neyukye hatà, Akmarawu. Koknà y, onà wyaro oyexetxhàyamo muhutwen hamà, kekon hatà. Àwayehpàra rma hak oyehtoko, teryehorye rma haxa mehxakonà, omoro, kekon hatà. Rasru haxa ryhe, ohxehra rma haxa nehxakonà, kekon hatà, Akmarawu. Amnye rma teryehotanàhsom me harha naha, noro ha, tano. Omoro haxa ryhe, teryewhamnohsom me harha manaha, kekon hatà, Akmarawu, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Onà wyaro uhutwamohsehe xarha, owya, kekon xarha tà, Akmarawu, tkatxhonkemà rotho wya. Kamrakataw naha, ewtarà ymo wyarono, wahkotono ytxoho ymo, kekon hatà. Àro ke, àwetohra ro mak natxhe ha, tanon komo, ohyakanye. Àwetohra rma rha manatxhe ha, omnyam xarha, amna hyaka, kekon hatà, Akmarawu, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Onà wyaro nkekon hatà, noro ha, Akmarawu wya. Tamutho y, Rasru ànyahko xaxa hampànà, royanan komo hyaka, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tehxemà rma mokyamo, rowtà komo, 5 komo, kekon hatà. Nyamoro hyaka noro ànyahko. Onà wyaro hak kano, àwyanye, kekon hatà. Eryewhamnohno ytxoho ro na otonàr kom hona mpànà xenytxok ha, kan haka, Rasru, àwyanye, kekon hatà, tkatxhonkemà rotho. Àro wyaro hak kano, àwyanye, onà ymo na omoknàr kom hona, kekon hatà, noro ha, Akmarawu wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Àna matà, kekon mak hatà, Akmarawu, àwya. Àhyawonye rma naha, Moyses heno nmenhotho. Khoryenkomo rwonà yokarymanye ro heno komo nmenhotho xarha, àhyawonye rma naha, kekon hatà. Àrwon kom hak yonytxatxowà, oyowtà komo, eryewhamnohno ytxoho ro na àtohra tehtxoho menye, kekon hatà, Akmarawu, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Àna matà, tamutho y, Akmarawu y, kekon mak hatà, tkatxhonkemà rotho. Nyamoro heno nmenhotho yonytxahra natxow hana, kekon hatà. Tàhyakanye àwayehsahotho tontok haxa, noro yonytxetxhe hampànà, kekon hatà. Tàwyanye noro yonytxatxhe rma, anar me harha tanhànàthàyamo yonyatxhe hampànà, kekon hatà, noro ha, Akmarawu wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Onà wyaro haxa nkekon hatà, Akmarawu, àwya. Nyamoro heno nmenhotho yonytxahra tehtokonye, àwayehsahotho yonytxahra rma rha natxhe hampànà. Àwayehxemo waye asanàmsahonhàrà rma yonytxahra natxhe hampànà, kekon hatà, Akmarawu, tkatxhonkemà rotho wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Onà wyaro nkekon hatà, Txesusu, tànhananàhrà ro komo wya. Tanhàn hokon me texem me natxow hamà, toto komo, kekon hatà. Àro hokon me txenyetho komo ryhe, tanàhnohsom me rma haxa natxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tanhàn hokon me harha bàryekomo yeryhera hak nahtxoko. Romryenon komo rma yeryhera hak nahtxoko, tanhàn hokon me harha. Àro hokon me harha tàwyanye txenyetokonye, ohxehra ro mak natxhe hampànà, kekon hatà. Àro wyaro txeryhera ronye rma twayehnàtokonye, ohxe esnàràtho kom haryhe. Tuna kwaka tànonàtokonye, ohxe esnàràtho kom haryhe. Tohu ymo ke amusmexah me tànonàtokonye, àro wyaro rma twayehnàtokonye, ohxe esnàràtho kom haryhe, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ohxe mpànà ehtxoko, kekon xarha tà, àwyanye. Oyowtà wya owàràhyakantokonye, noro eytxoko. Anar me harha tanhànàthàrà yonyan hana, noro ha. Anar me harha àwya xenyetxhe, oseryewhokatxoko, noro yanhànàtho hoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Anatoko yake ro owàràhyaketxow hana, noro ha. Àro rma ho yake ro rma rha, onà wyaro nken hana, owyanye. Anar me harha ranhànàtho wenyaha, ken hana, yake ro rma rha, owyanye. Àro wyaro àwya katxhe rma, oseryewhokatxoko, noro yanhànàtho hoko, yake ro rma rha, kekon hatà Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Onà wyaro nketxkon hatà, Petru komo, 12 komo rma, Kohkomo wya. Khoryenkom hona xeny me nyhe amna txeryko, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Onà wyaro haxa neyuhtxownà hatà, Kohkomo. Anatoko Khoryenkom hona menyatxow hana, atxke txko rma, natà txko wyaro rma, mostakna nathàrà txko wyaro rma. Atxke txko noro hona owyanye xenyetoko rma, eryehokano meryatxhe rma, noro yano me mak ha, kekon hatà. Oyuyukyatxhe hampànà, wewe ymo, amoryera ymo, moro ymo. Owyanye, emorurakako, osowaxehtok harha tuna ymo kwaka, katxhe rma, oyoyukyatxhe hampànà, moro ymo, atxke txko Khoryenkom hona owyanye xenyetok mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Àsok hana ayanoto ro komo manotometxow ha, kekon hatà. Anatoko amararàn kom hok ehxe mànyakyatxow hana. Owoknà komo yonyàr hoko ehxe mànyakyatxow haxa hana, kekon hatà. Àhok ehxemotho komo nomokyatxow harha mà, omàn kom yaka. Omokàtxhenye rma, onà wyaro kahra manatxow hamà, àwyanye. Eryewtatxoko txko ha, emtakmaxe, rakoro, kahra manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Onà wyaro haxa màketxow hamà, àwyanye. Ronyahrà enyhoryetxoko hxa ha, màketxow hamà. Owomun komo awnuhtxoko hxa ha, ronyahrà sohtxoko hxa ha, màketxow hamà. Amnye memtakmetxhe omnyamo, ryemtakmatxhe mak ha, màketxow hamà, ayanoto ro komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Àwyanye oyoyukutxhenye rma, onà wyaro kahra manatxow hamà. Hàà, àna txko rma, uro txko mewakryetxowà, kahra manatxow hamà, àwyanye, ayanoto ro me esnàr kom ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ayanoto komo wya oyoyuhtoho komo wyaro, Khoryenkomo eyuhtukatxoko, omnyamo, omeroron hoko, kekon xarha tà. Owyanye eyuhtukatxhe rma, onà wyaro katxoko, àwya. Apa y, anhà rma amna, oyoyuknyehnà, katxoko. Amna oyoyukhormehe mak ha katxoko, àwya, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Taa. Asama yarye tetxkonà rma hatà, Txesus komo, Xerusaryen hona. On ho nehxakon hatà, Samarya yamtarà. Mon ho nehxakon hatà, Karyeryeya yamtarà. Àrakataha tetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Owto hahnoke ehtokonye, àhyakanye nomokyatxkon hatà, toto komo, 10 kom hatà. Hunmata ymo yawon komo rma mokyam nehxatxkon hatà. Moxe nyhe txko horohtxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Teryewrye ro nàrwonàmtxownà hatà. Txesusu y, khananàhnye y, ketxkon hatà. Amna hnàn yaw exko ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tàwya xenyetxhenye rma, onà wyaro nkekon hatà, Txesusu, àwyanye. Àtoxoko, Khoryenkom màn yonye ro komo hyaka, kekon hatà. Osonyhotatxko ha, àwyanye, kekon hatà, àwyanye. Àro ke totxownà hatà. Tàtonàr kom me rma nenyhotatxownà hatà. Hunmata ymo yawohra harha nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Horohye hatà, ukukur komo, towenyxa mak hatà. Tàwya tonyhotatho yonyetxhe rma, horohye hatà, noro marma mak ha. Nomokye harha tà. Ohxe xaxa nay hamà, Khoryenkomo, kekon hatà, teryewrye ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tano me ro rma nehurkay hatà, Txesusu yakrataka. Uro txko menyhoryeno. Ohxe xaxa manaha, kekon hatà, àwya. Samaryayana ryhe mok nehxakon hatà, Xuknewyanahnà rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Onà wyaro nkekon hatà, Txesusu. 10 mehra kat nahtxoko, enyhotaxemo komo, kekon hatà. Henta haryhe 9 komo. ");
INSERT INTO hixNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Omokhàra natxow hamà. Ohxe xaxa nay hamà, Khoryenkomo, kahra natxow hamà, 9 komo, kekon hatà. Moson marma nomokno hamà, Xuknewyanahnà rma nomokno hamà kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Onà wyaro nkekon xarha tà, noro wya, hunmata ymo yawonotho wya. Asanàmko harha, kekon hatà, àwya. Ohxe àtoko. Ohxe harha manaha, rohona owya xenyàr ke mak ha, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Taa. Onà wyaro nketxkon hatà, Farysew kukur komo, Txesusu wya. Àsokentoko nomokyano, Khoryenkomo, kàkayaryet kom me tehtxoho me, ketxkon hatà, àwya. Onà wyaro haxa neyuhtxownà hatà, Txesusu. Onenyehtor kom me nomokyaha, Khoryenkomo, akayaryet kom me tehtxoho me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Xenytxoko, moson ha kàkayaryet komo, katxho mehra nomokyaha. Mokro ha kàkayaryet komo, omohsaho rma, katxho mehra rma rha nomokyaha, Khoryenkomo, kekon hatà. Awawonye rma naha, akayaryet komo, Khoryenkomo nànyaketxho rma, kekon hatà, Txesusu, Farysew komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Onà wyaro nkekon xarha tà, tànhananàhrà ro komo wya. Amnye Toto me Enusaho yomoknàr xe rma haxa manatxhe hampànà, kekon hatà. Omoko hxa ha màketxhe hampànà. Omokhàra mak naha ha, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Onà wyaro nketxhe rma haryhe, toto komo, owyanye. Nomokyak haxa hatà, Toto me Enusaho, mono nay hatà, ketxhe rma haryhe, owyanye. Tan naha, omohtxoko xenyxe, ketxhe xarha, anar komo, owyanye. Àtohra mpànà ehtxoko, akoronye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Onà wyaro haxa ryhe nomokyaha hampànà, Toto me Enusaho. Toto komo nenytxehkanàr me mpànà nomokyaha ha, omeroron komo nenyàr me mak ha. Àsok tonyxem me hana nay ha, sasa ha, kekon hatà. Sasa tatoko rma, tonyxem me rma haxa nay hamà, kahe ratokoko. Tawasnye rma haxa tonyxem me nay hamà, sasa. Àro wyaro rma rha, tonyxem me rma haxa mpànà nomokyaha ha, Toto me Enusaho, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wahoro htxero teryewhamnohsom me rma haxa naha hampànà, noro ha, thenyehra rma haxa mak ha, kekon xarha tà. Noro xanomkahnohyatxhe hampànà, toto komo, amnyeno rma komo. Amnye haxa nomokyaha harha hampànà, Toto me Enusaho, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nowe heno yehtoko tuna ymo yomokàthàrànhàrà wyaro nomokyaha hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Àsok hana nehxatxkon ha, nyamoro heno ha, kekon hatà. Tuna ymo yomokhàra ro rma haka, tànyahrà kom hoko nehxatxkon hamà. Thehtanàr kom hoko xarha nehxatxkon hamà. Tànyontanàr kom hoko xarha nehxatxkon hamà, kekon hatà. Tkanawarà ymo kom yaka Nowe heno komo yosonkahàtxhe rma, nomokye hatà, tuna ymo. Toto heno komo yanàhnohtàkay hatà. Àro wyaro rma rha àhoko toto komo yehtoko, nomokyaha hampànà, Toto me Enusaho, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Àsok hana nehxatxkon ha, Ryo yehtokon heno kom ha, kekon xarha tà. Àro wyaro rma rha àhoko nehxatxkon hamà, nyamoro heno xarha. Tànyahrà kom hoko nehxatxkon hamà. Twarawantanàr kom hoko xarha nehxatxkon hamà. Bararàn komo homonàr hoko xarha nehxatxkon hamà. Bàn komo yenyàr hoko xarha nehxatxkon hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sa, nenmahye haxa hatà. Àro rma ho Soknoma hoye toy hatà, Ryo. Àro rma ho nomokye hatà, weheto ymo, kahe yaye. Toh me nehurkay hatà, tatahxem me rma hatà, kekon hatà. Toto heno komo yanàhnohtàkay hatà, àro ymo ha. ");
INSERT INTO hixNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Àro wyaro rma rha àhoko toto komo yehtoko, nosonyhehe hampànà, Toto me Enusaho, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Noro yomohtoho ho akatxho kom horà àtohra mpànà ehtxok ha, kekon xarha tà. Màmyaye oyehtokonye, omàn kom yaka harha àtohra mpànà ehtxok ha. Akatxho komo yanàr horà àtohra ehtxoko, kekon hatà. Amararàn kom hoko oyehtokonye, eramahra mpànà ehtxok ha. ");
INSERT INTO hixNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ryo hetx heno yeramatxhàrànhàrà hutwahkahpàra ehtxoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tekrunhotxahke oyehtokonye, awayehyatxhe xak mak hampànà. Awayehrà komo xehra rma oyehtokonye, awayehyatxhe xak mak hampànà, kekon hatà. Tosoxanomkahnohsom me oyehtokony haxa, mekrunhetxhe harha hampànà. Awayhàtxhenye rma, karyhe roro harha manatxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Onà wyaro àkehe, owyanye, kekon xarha tà. Noro yomohtoho ho, kohsaya àto rye nànàkyatxow hana, toto komo, asako. Anaro, tanàmsom me mpànà naha ha. Anaro haxa ryhe, tànomsom me mpànà naha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Àto rye xerye kyatxow hana, woràskomo, asako. Anaro, tanàmsom me mpànà naha ha. Anaro haxa ryhe, tànomsom me mpànà naha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Àto rye bararàn kom hoko natxow hana, toto komo, asako. Anaro, tanàmsom me mpànà naha ha. Anaro haxa ryhe, tànomsom me mpànà naha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Amna yohà y, henta ryhe tànomsom komo yosarà naye, ketxkon hatà, ànhananàhrà ro komo. Henta ryhe tànomsom komo yosarà naye, ketxkon hatà. Kuknonano me haxa neyuhtxownà hatà, Txesusu. Henta ya hana nohsamnohyatxow ha, kwatxenama kom ha, kekon hatà. Àmataxahotho hyaka nohsamnohyatxow hamà. Àro wyaro rma rha atxke ehxemotho komo hyaka nomokyaha hampànà, anàhnohtàkany komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kuknonano me xarha nàrwonàmye hatà, Txesusu. Nekarymay hatà, tànhananàhrà ro komo wya, Khoryenkom yakoro tàrwonyemà ro me ehtxoho menye, amotohpànà ro me ehtxoho menye. ");
INSERT INTO hixNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Onà wyaro rma nkekon hatà, àwyanye. Owto hon komo yoh me nehxakon hatà, toto, horykomo, kekon hatà. Onytxano ynye ro me nehxakon hatà. Ukurunkahnà me Khoryenkomo yonyhera mak nehxakon hatà, noro ha. Ukurunkahnà me rma rha toto yonyhera nehxakon xarha tà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Noro yowto ho nehxakon hatà, wosà, enyonkaxaho. Norotho yeryewhamnohyakon hatà, anaro toto, àxanhànà, kekon hatà. Àro ke emahona ro nomokyakon hatà, wosà, horykomo hyaka, owto hon komo yohà hyaka. Uro ukurunhoko, roxanhàn hona, kekonà roro hatà, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Noro yoyukhura mak nehxakon hatà, horykomo, mex hatà. Mex ehxah me nehutway harha tà, tàhnawo, kekon hatà. Ukurunkahnà me Khoryenkomo yonyehnà uro kekon hatà, tàwya rma. Ukurunkahnà me rma rha toto yonyehnà uro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mosonà wosà weyukyan mak hamà, kekon hatà, tàwya rma, kekon hatà, Txesusu. Mosonà ukurunhen hamà, àwya rakryehkanàr ke mak ha, kekon hatà, tàwya rma. Ukurunhohra rma ryehtoko, ramotohkatxehken hamà, rakoro tàrwonyemà ro me tesnàr ke, kekon hatà, horykomo, tàwya rma, kekon hatà, Kohkomo. ");
INSERT INTO hixNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Horykomo yehutwatxho menytxatxowà, kekon xarha tà, tànhananàhrà ro komo wya. Yaworonohnà ro me nehxakon hatà, noro ha. Wos yoyukye haxa mak hatà, kekon hatà, Kohkomo. ");
INSERT INTO hixNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Noro yoho rma haxa tàmryenon komo yoyukyaha ha, Khoryenkomo. Emahona ro noro yakoro nàrwonatxhe roro mak ha, nyamoro ha, anar komo wya teryewhamnohrà komo ke. Nyamoro kurunhohra rma kat naye, Khoryenkomo, owyanye, kekon hatà. Mex katà nàramamyano. ");
INSERT INTO hixNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Àna matà, amamehra kurunhetxow hamà, Khoryenkomo, kekon hatà. Onà wyaro haxa àkehe, owyanye. Yukryeka hona harha Toto me Enusaho yomoknàtoko, yakehra natxhe hampànà, àhona xeny komo, kekon hatà, Kohkomo, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Àto nehxatxkon xarha tà, anar komo. Enyhoru xaxa uro ha kany komo rma mokyam nehxatxkon hatà. Atxke natxhe anar komo kany komo rma mokyam nehxatxkon hatà. Nyamoro wya ryhe, kuknonano me xarha onà wyaro nkekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Khoryenkom màn yaka totxownà hatà, toto komo, asako, kekon hatà. Anaro, Farysew me nehxakon hatà. Anaro, txenyeru yahosnye ro me nehxakon hatà. Khoryenkom yakoro àrwonàmso totxownà hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Onà wyaro nàrwonàmye hatà, Farysewu, tàhnawo. Apa y, amna horyenà ro omoro ha, kekon hatà, tàhnawo. Ohxe xaxa manay hamà, rohoko, anhà komo wyarohra ryesnàr ke, kekon hatà. Apa y, toto komo katxhotho yany me natxhe, anar komo. Nyamoro wyarohra wehxaha, uro, kekon hatà, Farysewu, kekon hatà, Txesusu. Apa y, àme ryehra natxhe, anar komo, toto kom hoko. Nyamoro wyarohra wehxaha uro, kekon hatà. Apa y, anaro komo hetx hoko natxhe, anar komo. Nyamoro wyarohra wehxaha uro, kekon hatà. Apa y, moson ha txenyeru yahosnye ro hamà, noro wyarohra wehxaha uro, kekon hatà, Farysewu, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Apa y, amna yweronàhyamatxho yawo ro wehxaha uro. Tatahyehnomaxemà ro me wehxaha. Rotxenyerun hoye desmu yàmnye ro me xarha wehxaha. Àro wyaro amna yweronàhyamatxho yawo ro rma haxa wehxaha, apa y, kekon hatà, Farysewu, tàhnawo, Khoryenkomo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Àsok haxa hana nehxakon ha, txenyeru yahosnye ro ha, kekon xarha tà. Mox nehxakon hatà. Osompothàra ro mak nehxakon hatà, norohnàtho me tosonyàr ke, kekon hatà. Nosowankahekon hatà, tanhànàthàr hoko toseryehokanàr ke. Onà wyaro marma nkekon hatà, noro ha. Apa y, amna horyenà ro omoro ha. Anhà haxa urotho. Apa y, rohnàn yaw exko, kekon marma hatà, Khoryenkomo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Onà wyaro àkehe, owyanye, kekon xarha tà. Txenyeru yahosnye ro ryhe, bàn yaka harha tàtontoko, onà wyaro katxho me nehxakon ha, Khoryenkomo wya. Ronenyhoryetxho me haxa manaha, rowya, katxho me nehxakon ha, Khoryenkomo wya. Àro wyaro katxho mehra mak nehxakonà, anaro, Farysewu, kekon hatà, Txesusu. Àsok tawro hana. Ehonomnà me oyosonyetokonye, norohnàtho me harha oyeryatxhe hampànà, Khoryenkomo. Norohnàtho me haxa oyosonyetokonye, ehonomnà me harha oyeryatxhe hampànà, noro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Thokyamo txko yokyatxkon hatà, toto komo, Txesusu hyaka. Mosonà txko hona ayamorà txeryko tawro xe nehxatxkon hatà, àwya, ohxe texem me esnàr kom horà. Tàwyanye xenyetxhenye rma, horohkatxownà hatà, Txesusu nhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nekhotxownà rma hatà, Txesusu, tàhyaka. Onà wyaro nkekon hatà, tànhananàhrà ro komo wya. Bàryekomo txko kom hak nomohtxowà, rohyaka, kekon hatà. Àhorohkahranye ehtxoko. Moxamo txko wyaron komo ryhe, Khoryenkomo mryenon me natxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Onà wyaro yaworo xaxa àkehe, owyanye. Akayaryet kom me Khoryenkomo yesnàr xe oyehtokonye, bàryekomo wyaro norohnàtho me xaxa mpànà osonytxoko, kekon hatà. Àro wyarohra oyehtokonye, noro mryenon mehra ro mak manatxhe hampànà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Àto nehxakon hatà, toto, horykomo. Xuknewyana yoh komo kukuru rma mok nehxakon hatà. Onà wyaro nkekon hatà, noro, Txesusu wya. Khananàhnye y, enyhoru ryhe omoro, kekon hatà. Àsoke ryhe ohxe wehxano, karyhe roro harha ryehtxoho me, kekon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Onà wyaro neyukye hatà, Txesusu. Àsok tawro enyhoru ryhe omoro màken harha, rowya, kekon hatà, àwya. Khoryenkomo ryhe, enyhoru me naha, noro marma mak ha. Enyhoru mehra ro mak natxhe ha, toto komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Karyhe roro harha oyesnàr xe oyehtoko, kàyweronàhyamatxho kom yawo ro tehxorye manaha. Onà wyaro katxho komo hutwahra kat manaye, anar komo hetx hokohra ehtxoko katxho rma, toto yotahahra ehtxoko katxho xarha, toto katxho yarhàra ehtxoko katxho xarha, toto hoko àtemarontahra ehtxoko katxho xarha, toyuhsom me xenytxoko, oyàm komo, oyon kom xarha, katxho xarha. Àro wyaro katxho kom yawo ro tehxorye manaha, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Onà wyaro neyukye hatà, horykomo. Àro wyaro katxho kom yawo ron uro, kekon hatà. Romryen yaye ro rma àro wyaro katxho kom yawo ro ehxah uro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Àro wyaro tàwya enytxatxhe rma, onà wyaro nkekon hatà, Txesusu, àwya. Khoryenkomo yoyuhtukahra hak manaha, kekon hatà. Onà wyaro xaxa mpànà exko ha, noro yoyuhtukatxho me. Akatxhothàrà tàmko, omeroro, txenyeru hona. Txenyeru rma tàmko xarha, toto komo wya, àkatxhomnà komo wya, ànyahpàn komo wya, kekon hatà. Àro wyaro exko hampànà, kahe yawo towakryexem me oyehtxoho me. Àro wyaro oyexetxhe rma, rakoro omok ha, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Àro wyaro tàwya enytxatxhe rma, nekhokay hatà, horykomo, tkatxhonke rma haxa tesnàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ekhokaxaho rma yonyey hatà, Txesusu. Àro ke, onà wyaro nkekon xarha tà. Tkayaryet kom me Khoryenkomo hutwahra natxow hamà, tkatxhonkem komo, kekon hatà. Krawame mak natxhe, noro mryenon me harha. ");
INSERT INTO hixNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Arkurya yowtarà txko yarye àtohra nay hamà, kameru ymo. Krawame rma haxa nay hamà, àtotho, hory me ymo esnàr ke, kekon hatà. Àro yarye noro totho yoho rma haxa krawame natxhe, tkatxhonkem komo, Khoryenkomo mryenon me harha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Àro wyaro tàwyanye enytxatxhe rma, onà wyaro nketxkon hatà, àton komo. Àsok tawro harha, ketxkon hatà. Tonyhoryexem komo ehxera natxow hamà. Àsoken kom katà tonyhoryexem me natxowà, ketxkon hatà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Onà wyaro haxa nkekon hatà, noro, àwyanye. Tonyhoryetxho kom hoko tehnyaxem me natxhe ha, toto komo. Khoryenkom haxa ryhe, ehnyahnà ro me mak naha ha. Ehonomnà xaxa kax mak naha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Onà wyaro nkekon hatà, Petru, àwya. Amna ryhe, amna yomyawonotho nànomye, ayakoro amna totho me, kekon hatà, Petru. ");
INSERT INTO hixNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Àsok hana natxow ha, romryenon kom ha, kekon hatà, Txesusu, àwyanye. Onà wyaro natxow hamà. Anatoko bànàthàyamo nomyatxow hana. Anatoko thetxenhàyamo nomyatxow hana, kekon hatà. Anatoko towtànhàyamo nomyatxow hana. Anatoko tàyàmànhàyamo nomyatxow hana. Anatoko tàyonànhàyamo nomyatxow hana. Anatoko thokuthuyamo nomyatxow hana, kekon hatà. Omeroro rma nànomyatxow hana, tàwyanye àrwo yonyhorunu yokarymatxho me, àsok hana kàkayaryet kom me nay ha, Khoryenkom ha, katxho rma yokarymatxho me, kekon hatà. Onà wyaro yaworo xaxa àkehe, owyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Nyamoro ryhe, towakryexem me rma haxa mpànà natxhe ha, kekon hatà. Amnye rma, tano rma hak tehtokonye, thenyehra towakryexem me mpànà natxhe ha, tànànomàthàyamotho yoho rma haxa mak ha, kekon hatà. Amnye xarha, karyhe roro mpànà natxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Taa. 12 komo yanyekye hatà, Txesusu, tàhyaka. Onà wyaro nkekon hatà, àwyanye. Xerusaryen hona tàtetxow hamà, kekon hatà. Àto teryewhamnohsom me naha hampànà, Toto me Enusaho, àmenhosahonhàrà yawo ro tehtxoho me, Khoryenkomo rwonà yokarymanye ro heno komo nmenhotho yawo ro tehtxoho me, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tahohsosom me naha hampànà, noro ha, Xuknewyanahnà komo wya. Nyamoro rma newnohyatxhe hampànà, kekon hatà. Atxke rma haxa neryatxhe xarha hampànà. Noro horye netahtetxhe xarha hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nàhpokyatxhe xarha hampànà. Yahkotohen hona namoyathetxhe xarha hampànà. Twayhàtxhe nasanàmyaha harha hampànà, noro ha. Osorwawo ro enmahàtxhe, nasanàmyaha harha hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Àro wyaro katxho hutwahra mak nehxatxkon hatà, 12 komo. Nenkukmetxkon mak hatà. Uhutwamohsohra rma nehxakon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Taa. Owto hahnohyatxkon hatà, Txesus komo. Xeryko rma àro hatà, owto. Owto màhto nehxakon hatà, toto, asama yahetawo rma hatà. Enhunu ro rma mok nehxakon hatà. Uro nyhe txko rotxenyerun ha kanye ro me nehxakon hatà, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tàhyaha àtonàr komo yonytxekon hatà, noro ha. Thenyehra rma haxa nehxatxkon hatà, toto komo, noro hyaha tàtosom komo rma. Àro ke, onà wyaro nkekon hatà. Àsok tawro àro wyaro tetxowà, toto komo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Txesusu nomokyaha, ketxkon hatà, àton komo, àwya. Nasarye honotho rma nomokyaha. Kàhyahanye tehe, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Àro ke, teryewrye ro nàrwonàmye hatà, noro. Hay, Txesusu y, kekon hatà. Dafe heno yohamàtho omoro hatà. Rohnàn yaw exko, kekon hatà, teryewrye ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Neytxownà mak hatà, toto komo, wahoron komo. Tatàknye exko, ketxkon hatà, àwya. Tatàknye exko. Noro nàrwonakonà rma haxa mak hatà, thenyehra rma haxa mak hatà. Dafe heno yohamàtho omoro hatà. Rohnàn yaw exko, kekonà rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kràk, horohye hatà, Txesusu. Noro hak sohtxoko, rohyaka, kekon hatà, toto komo wya. Tàhyaka sokàtxhe rma, onà wyaro nkekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Àsoke oynyàr xe manaye, rowya, kekon hatà. Rohà y, kekon hatà. Rontanàhrà xe wehxaha, owya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kontanàhno hampànà, kekon hatà, Txesusu, àwya. Tonke harha manaha, rohona owya xenyàr ke, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Àtoko rma tonke harha nehxakon hatà, enhunu rotho. Txesus yakoro toy hatà. Ohxe xaxa nay hamà, Khoryenkomo, kekon hatà. Àro wyaro rma rha nektxkon hatà, toto komo xarha, xenyenhàyamo. Ohxe xaxa nay hamà, Khoryenkomo, ketxkon hatà, omeroro. ");
INSERT INTO hixNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Àpo, Xeryko hona nahatakay hatà, Txesusu. Owto horye tekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Àto nehxakon hatà, toto. Sakewu rma noro hatà. Txenyeru yahosnye ro komo yohà rma mok nehxakon hatà. Tkatxhonke rma haxa nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Onokà ryhe Txesusu, kekon hatà, tàhnawo. Xenyàr xe nehxakon hatà. Thenyehra mak nehxatxkon hatà, toto komo. Àro ke, Txesusu yonyhera nehxakon hatà, Sakewu, kawohra tesnàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Àro ke, Txesus komo ywaho toy hatà, karyhe hatà. Wewe horye nekayàmye hatà, tàwya ohxe Txesusu yonyàr horà. Wewe màtkoko tomohsom me nehxakon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Àsna tomokàtxhe rma, nosompotày hatà, Txesusu. Sakewu y, kekon hatà, àwya. Ohtok ha, amamehra. Omàn yaka àtehe hampànà, hawana me, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Àtoko rma nàhtoy hatà, Sakewu. Teryehorye rma haxa Txesusu yarày hatà, bàn yaka. ");
INSERT INTO hixNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nàrwonatxkon mak hatà, toto komo, Txesus hoko. Sakew yakoro àtonàrà yonytxownà hatà. Àro ke, onà wyaro nketxkon hatà. Atxke naha mosonà katxho màn yaka ton hamà, ketxkon hatà. Hawana me ton hamà, noro ymo màn yaka, ketxkon hatà, toto komo. ");
INSERT INTO hixNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Onà wyaro mak kekon hatà, Sakewu, Kohkomo wya, toto komo nenytxanàr me hatà. Rohà y, kekon hatà. Rokatxho hoye wàmyaha, àkatxhomnà komo wya. Yake nyhe wàmyaha, àrakataha tehxe ro, kekon hatà. Àsok tawro hana. Atxke wehxan hamà, rowya toto komo yonkuhtonàr ke. Rowya àtxenyerunuthuyamo yahosnàtoko, eho nyhe wahohsakonà, kekon hatà. Roh komo rwonàmàthàr yawo rohra eho nyhe wahohsakonà, toto komo txenyerunutho. Àro wyaro ryexetxhàr hoye ro atxke wehxan hamà, kekon hatà. Àro ke wàmtàhkehe harha, àwyanye. Àro marmahnà wàmyaha. Eho rma haxa wàmyaha. Wàmyaha xarha. Wàmyaha xarha. Wàmyaha xarha. 4 me rma wàmyaha, àwyanye, kekon hatà, Sakewu, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Onà wyaro nkekon hatà, Txesusu. Amnye rma Khoryenkomo nenyhoryetxho me harha naha, mosonà, kekon hatà. Khoryenkomo nenyhoryetxho me harha naha. Àsok tawro hana. Akmaraw heno yohamàtho me nay hamà, noro xarha, kekon hatà. Àmàn yawon komo xarha, Khoryenkomo nenyhoryetxho me rma rha natxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Enyhoruhnu komo yohony me nomokye, Toto me Enusaho, kekon hatà. Àro wyaron komo yonyhoryeny me nomokye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Àro wyaro katxho yonytxatxownà hatà, toto komo. Kuknonano me xarha nàrwonàmye hatà, Txesusu. Xerusaryen màhto nehxakon hatà. Àro ke, onà wyaro nehutwetxkonà rma haryhe tà, toto komo. Mexehra kàkayaryet kom me nosonyhen hamà, mosonà, Khoryenkomo nànyaketxho, ketxkonà rma haryhe tà, Xerusaryen màhto Txesusu yesnàr ke mak hatà. Yaworohra mak nehutwetxkon hamà. Àro ke, kuknonano me onà wyaro nkekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Toto komo kayaryet me texem me nehxakon hatà, horykomo, kekon hatà. Àro ke toy hatà, anar komo hyaka, monyen komo hyaka. Nyamoro ryhe, toto komo kayaryet me noro yeny me nehxatxkon hatà, kekon hatà. Àro ke àhyakanye toy hatà, àwyanye toto komo kayaryet me tetxoho me. Amnye toto komo kayaryet me harha tomohsom me nehxakon hatà, towto hona harha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Towto hoye tàtohra ro rma haka, tanoto komo yanyekye hatà. 10 me nanyehtxownà hatà, kekon hatà. Txenyeru yàmye hatà, 10 me hatà, àwyanye. 1 me rye rma nàmye hatà, towenyxanye, 10 komo wya. On ha rotxenyerunu, kekon hatà, àwyanye. On hona rotxenyerunu xarha ahohtxoko, twarawantaxemà ro me oyesnàr kom ke, kekon hatà, horykomo. Romokhàra ro rma haka àhoko roro ehtxoko, owyanye thenyehra nyhe rotxenyerunu yahohtoho me, kekon hatà, tanoto komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Àro wyaro tàwya katxhe rma, toy hatà, horykomo. Noro xehra mak nehxatxkon hatà, ewto hon komo, kekon hatà, Txesusu. Àro ke noro mahyaka tkukur komo nyahtxownà hatà, monyen komo hyaka. Amna kayaryet me noro yesnàr xehra amna naha kaxe nànyahtxownà hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Àkayaryet kom me noro yetxownà rma hatà. Taa. Amnye nomokye harha tà, horykomo, towto hona harha, kekon hatà. Tomokàtxhe rma, tanoto komo yanyekhoy hatà, tàhyaka. Txenyeru yahosnyenhàyamo rma yanyekhoy hatà. Àwyanye tàtxenyerunu yahosàthàrà hutwanàr xe nehxakon hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wahoro htxero nomokye hatà, anoto komo kukuru. Rohà y, kekon hatà. 1 txenyeru hona rma 10 me wahohsako, otxenyerunu, rowarawantanàr ke, kekon hatà, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Hàà, ohxe mehxak hamà, kekon hatà, horykomo, àwya. Ranoto me yaworo mehxak hamà, rotxenyerun hoko, yakenohnà txko hoko rma, kekon hatà. Àro ke, 10 me owto yoh me keryaha, omoro, kekon hatà, horykomo, tanoto wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Àhona nomokye hatà, anaro, anoto xarha. Rohà y, kekon hatà. 1 txenyeru hona rma 5 me wahohsako, otxenyerunu, rowarawantanàr ke, kekon hatà, noro ha, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Hàà, 5 me owto yoh me keryaha, omoro, kekon hatà, horykomo, àwya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nomokye hatà, anaro, anoto xarha. Rohà y, kekon hatà. On harha otxenyerunuthuru, onàmàthàràtho rma, 1 rma, kekon hatà. Wom ke àkaramyako. Ohxe weryaknano, atarymanàr hona, kekon hatà, noro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Àro wyaro ohxe weryaknano, ohona roseryehrà ke mak ha, kekon xarha tà, horykomo wya. Àsok tawro hana. Tanàhnohso ro amna manotomehe, omoro, kekon hatà. Ohoye rohra, amna hoye ro haxa, akatxhontehe. Àro wyaro rma rha anyahtehe xarha, kekon hatà. Àro ke koseryehyako, ohona. Otxenyerun ke rowarawantanàr xehra wehxaknano, ohona roseryehrà ke, kekon hatà, noro ha, horykomo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Onà wyaro haxa neyukye hatà, horykomo, kekon hatà. Atxke mehxak hamà, owya ranweknàr ke, kekon hatà, noro wya, tanoto wya. Atxke oyexetxhàrà uhutwamohsehe, owya, orwonàmàthàr hoye ro mak ha, kekon hatà, horykomo. Tanàhnohso ro amna manotomehe màkano, rohoko, kekon hatà. Ohoye rohra, amna hoye ro haxa, akatxhontehe, anyahtehe xarha, màkano, rohoko, kekon hatà, horykomo, kekon hatà, Txesusu. Àro wyaro rohutwanye me manay hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Àro ke, àsok tawro rotxenyerunu yàmpàra mexeye, txenyeru hokono ro komo wya, kekon hatà. Txenyeru yehetho yàmnye ro me natxow hamà, nyamoro, kekon hatà. Tàhyawonye rotxenyerunu yehtok haxa, rowya harha tàmràtho haryhe àwyanye, eho nyhe tàmràtho haryhe àwyanye, romokàtxhe harha, kekon hatà, horykomo, noro wya, tanototho wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Àto nehxatxkon hatà, anar komo, anoto komo xarha. Àro ke, onà wyaro nkekon hatà, horykomo, àwyanye. Rotxenyerunutho atxok ha, noro hyaye, anhàtho hyaye, kekon hatà. Anaro wya ryhe tàmtxok harha. 10 me ahosnyenhàrà wya rma tàmtxoko, kekon hatà, horykomo, tanoto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Onà wyaro haxa nketxkon hatà, nyamoro ha, àwya. Amna yohà y, tàtxenyerunke rma nay hamà noro ha. 10 me rma nay hamà, àhyawo, ketxkon hatà. Tàmporyehra nay hamà, àwya, tàtxenyerunke rma haxa esnàr ke, ketxkon hatà, horykomo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Onà wyaro haxa neyuhtxownà hatà, horykomo. Tkatxhonke rma oyehtokonye, thenyehra nyhe mahohsatxhe xarha, akatxho komo xarha, kekon hatà. Àkatxhomra oyehtokony haxa, ahohsàra ro mak manatxhe hampànà. Akatxhothàyamo rma, yakenohnàtho txko rma, natarymatxehkehe hampànà, kekon hatà, horykomo, tanoto komo wya, kekon hatà, Txesusu. Àro wyaro rma rha, towakryexem me xarha natxhe, Khoryenkomo newakryetxho komo, noro yoyuknyenhàyamo. Àro wyaro rma rha, ewakryehnà me rma natxhe hampànà, ewakryehnàtho komo, noro yoyuknyehnànhàyamotho, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Onà wyaro nkekon xarha tà, horykomo, tanoto komo wya. Àsok hana nehxatxkon ha, roxanhàn kom ha, kekon hatà. Tkayaryet kom me ryesnàr xehra nehxatxkon hatà, kekon hatà. Àro ke suhtatxko ha, xaro. Etahatxok ha, ronenyàr me, kekon hatà, horykomo, tanoto komo wya, kekon hatà, Txesusu. Àro wyaro rma rha natxhe hampànà, Khoryenkomo xanhàn komo, roxanhàn komo rma, kekon hatà, Txesusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Àro wyaro tàwya katxhe rma, wahoro toy hatà, Txesusu. Xerusaryen hona tekonà rma hatà. Akoro rma tetxkon hatà, ànhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Anaro rha owto txko hahnohtxownà hatà, Betfaxe rma hatà, Betanya xarha hatà. Oryefera yàhàn mahotur hono rma àro ha, Betfaxe, Betanya xarha. Àhahnoke rma tehtokonye, asako nànyahtxownà hatà, Txesusu. Tànhananàhrà ro kom hoye asako nànyahtxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Onà wyaro nkekon hatà, àwyanye. Owto hona àtotxoko, kekon hatà. Owto hona àtotxoko. Menyatxhe, àro hona, kekon hatà. Ayahatakatxhenye rma, xumentu mxekrà menyatxhe hampànà. Ewahtosaho rma menyatxhe. Toto komo, àmkawo àtotho mehra hak naha, kekon hatà. Meweketxhe ha. Xaro mekyatxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Àsok tawro meweketxowà ketxow hana, toto komo, owyanye. Onà wyaro meyukyatxhe ha. Kohkomo, moson xe nay hatà, màketxhe ha, kekon hatà, Txesusu, tànànyaknyàr komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Àro ke totxownà hatà, nyamoro. Txesusu rwonàmàthàrà yawo ro rma haxa nenytxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Xumentu mxekrà yewekatxownà hatà. Àwyanye ewekantoko rma, onà wyaro nketxkon hatà, esom komo, àwyanye. Àsok tawro meweketxowà, xumentu mxekrà, ketxkon hatà. Àsok tawro meweketxowà, xumentu mxekrà. ");
INSERT INTO hixNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kohkomo, moson xe nay hatà, ketxkon hatà, ànyahxemo komo, esom komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Àro ke natxownà hatà, Txesusu hyaka. Nàmkayamtotxownà hatà, twomun komo ke. Sax, dyerye, Txesusu yakryetxownà hatà, àmkakoso. ");
INSERT INTO hixNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Asama yarye toy hatà, Txesusu. Asama yaka twomun komo yatxaraketxkon hatà, toto komo. ");
INSERT INTO hixNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Xerusaryen hahnohtxownà haxa hatà. Oryefera yàhàn yonàhtetxkon hatà, owto ymo hona. Enàhtonàr me rma neryehotetxkon hatà, Txesus yakoron komo, omeroro, thenyenohnà komo rma. Ohxe xaxa nay hamà, Khoryenkomo, ketxkon hatà, teryewrye ro hatà. Txesusu yahoxetà yonyenhàyamo kax mak nehxatxkon hatà. Eryehokano ytxoho yonyenhàyamo kax mak nehxatxkon hatà, noro wya. ");
INSERT INTO hixNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kohkom yano me omohsaho ryhe mosonà, ketxkon xarha tà. Kàkayaryet komo rma mosonà. Towakryexem me xaxa hak nahko, mosonà, ketxkon hatà. Noro yano me teryehorye rma haxa natxow hamà, kahe yawon komo. Nyamoro rma, ohxe xaxa nay hamà, Khoryenkomo, kany me natxow hamà, ketxkon hatà, Txesus yakoron komo. ");
INSERT INTO hixNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Àto nehxatxkon hatà, Farysew kukur komo, thenyenohnà kom wawo rma hatà. Onà wyaro nketxkon hatà, nyamoro ha. Khananàhnye y, eytxoko, ayakoron komo, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Onà wyaro àkehe, owyanye, kekon hatà. Tatàknye moxam yehtoko, tohu txko haxa rwonàmràtho haryhe, rohoko, kekon hatà. Totohnà rma rwonàmràtho haryhe, rowakryenàr horà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Xerusaryen hahnoke rma haxa tehtoko, nosompotày hatà, Txesusu. Tàwya xenyetoko rma, nàratay hatà, owto hnàn yawo rma haxa tesnàr ke hatà, àhon komo hnàn yawo rma haxa tesnàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Onà wyaro nkekon hatà, Xerusaryen hon kom hoko. Khoryenkomo nànyaketxho me rohutwahra natxhe, kekon hatà. Tonyhoryeny kom me rma rohutwahra natxhe. Teryehorye roro teny kom me rma rohutwahra natxhe, kekon hatà. Noro me rohutwanàr xe rma wehxaha haryhe, àwyanye. Rohutwahra mak natxhe, kekon hatà, Txesusu, teryewrye ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Amnye, waha me nomokyatxhe hampànà, àxanhàn komo. Owto watxan yaka nomokyatxhe hampànà, kekon hatà. Wahkotono ytxoho yeryatxhe hampànà. Owto hon heno komo wahkotetxhe hampànà, àtonàr kom hona. Owto ymo mamtotàhketxhe hampànà, mexe rma haxa mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Owto heno yomtatkatxehketxhe hampànà. Tohu ymo heno mkawononkatxehketxhe hampànà, kekon hatà. Osomkawono ymo heno yarymatxehketxhe hampànà. Àhon heno komo xarha yanàhnohtàketxhe hampànà, kekon hatà. Àro wyaro tanàhnohtàkaxem me natxhe hampànà, Xerusaryen hon heno komo, Khoryenkomo nànyaketxho me rohutwahra tesnàr komo ke, tonyhoryeny kom me rma rohutwahra tesnàr komo ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Taa. Khoryenkom màn yaka nowomye hatà, Txesusu. Àto nehxatxkon hatà, twarawantaxemà ro komo. Nukrunyemehtxownà hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Onà wyaro nkekon hatà, àwyanye. Onà wyaro nkehe, àmenhosahonhàrà, kekon hatà. Toto komo rwonàmtoho ro me naha, romànà. Àro wyaro rma nkehe, àmenhosahonhàrà, Khoryenkom màn hoko, kekon hatà. Àro rma manàhnohyatxok harha, omnyamo. Àsok tawro hana, àro yawo rma toto komo txenyerunutho yahosnàr ke, owyanye, temenyem komo wyaro owyanye ahosnàr ke, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Emahona ro hananàhno ryakon hatà, Khoryenkom màn yawo. Noro wayehkanàr xe mak nehxatxkon hatà, Xuknewyana yoh komo, Khoryenkom màn yonye ro yoh komo rma, àyweronàhyamano ynye ro kom yakoro xarha, horykomo kom yakoro xarha. ");
INSERT INTO hixNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Noro yonytxetxkonà rma haxa mak hatà, toto komo, omeroro. Àro ke, noro wayehkahra rma hak nehxatxkon hatà, eh komo. Àsoke ryhe teryatxowà, noro ymo ha, ketxkon hatà. Uhutwahra rma nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Anatoko toto komo hananàhyakon hatà, Txesusu, Khoryenkom màn yawo. Àrwo yonyhorunu yokarymekon hatà, àwyanye. Àro wyaro àhoko ehtoko, àhyaka nomohtxownà hatà, Xuknewyana yoh komo, Khoryenkom màn yonye ro yoh komo rma, àyweronàhyamano ynye ro kom yakoro xarha, horykomo kom yakoro xarha. ");
INSERT INTO hixNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Onà wyaro nketxkon hatà, àwya. Oskarymako, amna wya, ketxkon hatà. Oskarymako, amna wya. Onok yano me ukrunyemeknyo meryak harha, on yaye, ketxkon hatà. Onokà ryhe, ukrunyemehtxoko keknano, owya, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Uro htxero onà wyaro àkehe, owyanye royuhtoho me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Onok yano me aymomno ryakonà, Xowaw heno, owyanye, kahe yawon yano me katà, toto yano me katà. Uro eyuhtxoko, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Àro ke nosonytxetxkon hatà, nyamoro rye rma. Àsoke tketxowà, ketxkon hatà, tàwyanye rma. Àsoke tketxowà. Kahe yawon yano me aymomno ryakon hamà noro heno, tketxow katà, ketxkon hatà. Àro wyaro kàwyanye tatoko, onà wyaro nken hamà, mosonà. Àsok tawro noro heno yoyukhura mehxatxkonà, ken hamà, kàwyanye, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Àsok haxa katà tketxowà. Toto yano me aymomno ryakon hamà tketxowà, ketxkon hatà. Àro wyaro kàwyanye tatoko, toh ke kotahetxow hamà, toto komo. Khoryenkomo rwonà yokarymanye ro me haxa we nehxakon heno ha kany komo kax mak natxhe ha, toto komo, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Àro ke, onà wyaro nketxkon hatà, Txesusu wya. Hàà, àna hana, ketxkon hatà. Onok yano me hana aymomno ryakon ha, noro heno ha. Uhutwahra amna naha, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Uro xarha, oyoyukhuranye wehxaha, kekon hatà, Txesusu, àwyanye. Onok yano me hana ukrunyemeknyo weryak ha. Oskarymahra ro mak wehxaha ha, owyanye, kekon hatà, Txesusu, Xuknewyana yoh komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kuknonano me xarha nàrwonàmye hatà, Txesusu. Xuknewyana yoh komo wya tàxanomkahnohtoho hutwamohsonàr xe nehxakon hatà. Àro ke, kuknonano me onà wyaro nkekon hatà, toto komo wya. Tànatàrà yeryey hatà, horykomo, kekon hatà. Ufa heno yonamye hatà. Amnye toto komo yomyaràhtoy hatà. Tànatàrà yony me nemyaràhtotxownà hatà, kekon hatà. Tàwya emyaràhtotxhenye rma, toy hatà, anar komo yowto hona, monyen komo yowto hona. Mexe rma haxa àto nehxakon hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Amnye ehetawawo tanoto nyakye hatà, horykomo, tànatàrà yony komo hyaka. Àhyakanye nànyakye hatà, eher horà, kekon hatà. Ronatàrà yeher hoye mpànà monekhetxow ha, owya, kekon hatà, tanoto wya. Àro ke toy hatà, àhyakanye. Nàhpohtxownà mak hatà, nat yony komo. Akorohra rma nànyahtxownà harha tà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Amnye anaro tanoto xarha nyakye hatà, àhyakanye. Norotho xarha hpohtxownà hatà. Atxke rma haxa netxownà hatà. Akorohra rma rha nànyahtxownà xarha tà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Amnye anaro tanoto xarha nyakye hatà, àhyakanye. Noro heno yeheryamatxownà xarha tà. Narymatxownà hatà, nat waye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Àro ke, onà wyaro nkekon hatà, horykomo, tàwya rma. Àsok wehxano, kekon hatà. Àsok wehxano. Onà wyaro wehxan hamà, kekon hatà. Romur haxa ànyakyan hamà, àhyakanye, kekon hatà. Ronàhnànà txko ànyakyan hamà. Noro hona nenyatxow hana, kekon hatà, tàwya rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Onà wyaro haxa nketxkon hatà, nat yony kom ha. Tàwyanye noro yonyetxhe rma, òna wyaro nketxkon hatà, tàwyanye rma. Moson hamà umuru, ketxkon hatà. Tàyàmànhàrà wayhàtxhe, nat yoh me harha nay hamà, umurunhuru kaxe, ketxkon hatà. Àro ke norotho tetahatxe, norohnà harha kàwyam harha nat yoh me kehtxoho menye, ketxkon hatà, tàwyanye rma, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Àro ke, noro heno yarymatxownà hatà, nat waye. Netahatxownà hatà. Wayehye hatà, noro heno, kekon hatà, Txesusu. Àsok hana nyamoro heno ymo yeryan ha, horykomo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nyamoro heno ymo yotahaxe nomokyan hamà, kekon hatà. Netahetxow hamà. Anar komo yomyaràhten hamà, tànatàrà yony me harha, kekon hatà, Txesusu. Tàwyanye enytxatxhe rma, onà wyaro nketxkon mak hatà, àton kukur komo, Xuknewyana yoh komo rma. Àna matà, nyamoro yotahahohra hak nahko, horykomo, ketxkon hatà. Àro wyaro nketxkon hatà, onà wyaro tehutwanàr komo ke. Kukuknon kom me nat yony komo yanhànà yokaryman hamà, mosonà, ketxkon hatà, tàhnawonye. ");
INSERT INTO hixNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nenytxehkatxownà mak hatà, Txesusu. Onà wyaro nkekon xarha tà, àwyanye. Àsok hana nken ha, àmenhosahonhàr ha, kekon hatà. Onà wyaro nken hamà. Toh xanomkahnohnye komo wyaro, noro xanomkahnohyatxhe hampànà, toto komo. Noro ryhe, ehonomnà me harha mpànà naha ha. Nàmno yetxehà wyaro, ehonomnà me noro yeryaha hampànà, Kohkomo. Àro wyaro rma nkehe, àmenhosahonhàrà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Àsok hana tehxan ha. Anatoko tehurken hana, tohu ymo hona. Totàkràsken hana, toh hona kehurkanàr ke mak ha. Àro wyaro rma rha, noro xanomkahnohnye heno komo natanàhnohyatxhe hampànà, kekon hatà. Anatoko keryemnukyan hana, tohu ymo, khona tothahrà ke mak ha. Àro wyaro rma rha tàxanomkahnohnye heno komo yanàhnohyaha hampànà, noro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Àto nehxatxkon hatà, Xuknewyana yoh komo, àyweronàhyamano ynye ro komo rma, Khoryenkom màn yonye ro yoh komo xarha. Txesusu rwonà yonytxatxownà hatà. Khokonye rma nàrwonàmno hamà, ketxkon hatà, tàwyanye rma. Kukuknon kom me nàrwonàmno hamà, ketxkon hatà. Àro ke, noro yahohtxahke nehxatxkon haryhe tà. Ahohsàra mak nehxatxkon hakahpa tà, toto kom hona toseryehrà komo ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Noro yahohtoho hona ro rma nehxatxkon hatà. Àro ke tkukur komo nyahtxownà hatà, àhyaka. Yaworon me nosonyhetxkonà rma haryhe tà, ànyahxemo komo, Txesusu wya. Onà wyaro tawro xe mak nehxatxkon hatà. Atxke màkehe, yaworohra mak màkehe, tawro xe nehxatxkonà rma haryhe tà, Txesusu rwon hoko. Àro wyaro katxho hoye ro noro yanàr xe nehxatxkon hatà, tkayaryet komo hyaka, Xukneya yamtar hon komo kayaryetà hyaka, ehonomnà ymo hyaka rma. ");
INSERT INTO hixNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Onà wyaro nketxkonà rma haryhe tà, ànyahxemo komo, Txesusu wya. Khananàhnye y, yaworo xaxa kany me manaha, amna wya, ketxkonà rma haryhe tà. Yaworo xaxa hananàhno meryaha, amna wya. Àme yohà rma haxa manaha, toto kom hoko. Anar me rhahra manaha, ketxkonà rma haryhe tà. Yaworo xaxa Khoryenkomo muhutwamohsehe, amna wya. Àro ke uhutwamohsoko, amna wya, ketxkonà rma haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Txenyerun kom hoye tàmporye naye, Sesa wya, Homayana komo kayaryetà wya. Tàmporyehra kat naye owya, ketxkonà rma haryhe tà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yaworon mehra ehtxoho komo hutwekon mak hatà, Txesusu. Àro ke, onà wyaro nkekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Txenyeru txko xenyhotxoko, rowya, kekon hatà. Onok kuknonà mosonà, onok yosotà onà àmenhosaho, kekon hatà, txenyeru txko hoko. Hàà, Sesa hamà, ketxkon hatà, nyamoro ha. ");
INSERT INTO hixNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hàà, yaworo màketxow hamà, kekon hatà, Txesusu. Noro katxho me nay hamà onà, kekon hatà. Àro ke noro ewakryetxoko, owyanye àkatxho yàmrà ke mak ha, kekon hatà. Àro wyaro rma rha Khoryenkom xarha ewakryetxoko, owyanye eyuknur ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Noro rwon hoko noseryehokatxownà hatà. Koo, ohxe rma haxa koyuhtxow hamà, ketxkon hatà, tàwyanye rma. Àro ke, atxke màkehe kahra nehxatxkon hatà, toto komo nenytxanàr me. Natàknatxownà haxa hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saknusew kukur komo xarha nomohtxownà hatà, Txesusu hyaka. Kwayhàtxhenye asanàmpàra ro mak tehxatxhe kany komo rma nyamoro ha. ");
INSERT INTO hixNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Khananàhnye y, ketxkon hatà, àwya. Onà wyaro nmenhoy hatà, Moyses heno, kàyweronàhyamanye ro heno komo. Towàt heno wayhàtxhe, àhokhura rma àwayhàtxhe, àhetxenhàrà hak yahosno, ewtànhàrà rma. Noro ryhe, thetx me nahohsaha, àhohtanàr horà. Towàt heno wenatàhwo hohtehe, noro ha, towàt heno hokru me. Àro wyaro rma nmenhoy hatà, Moyses heno, ketxkon hatà, Saknusew komo. ");
INSERT INTO hixNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Àro ke enytxako, ketxkon xarha tà, Txesusu wya. Tànyonye wos yexetxhàrànhàrà amna nekarymehe, owya, ketxkon hatà. 7 me nehxatxkonà, toto heno komo, ewtà rye komo rma. Wahoto heno wos yahosàye. Wayehye, noro heno. Àhokhura rma wayehye, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Àhonanotho heno ryhe, towàt heno hetxenho yahosàye. Tàwya ahosàtxhe wayehye, noro heno xarha, àhokhura rma rha, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Àro wyaro rma rha nexeye, àhonanotho xarha. Àro wyaro rma rha nehtxownà, 7 heno komo, omeroro, ketxkon hatà. Tàwyanye wos yahosàtxhe, wayehtàkatxownà. Àhohtahra rye rma wayehtàkatxownà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Amnye wos heno xarha wayehye, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Àsoke natxowà àro ke, owya, ketxkon hatà, Txesusu wya. Kwayhàtxhenye tasanàmyatxhe harha màkehe hawe, omoro. Onok hetx me ryhe naye wosà, tasanàmàtxhenye, ketxkon hatà. Onok hetx me ryhe naye, amnye ha. Tano rma hak tehtoko, 7 komo hetx me nehxakon hamà, ketxkon hatà, Saknusew komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Àna matà, kekon hatà. Twayehpàra ronye rma haka hehtetxow hamà, toto komo. Nànyontetxow hamà, woràskomo komo xarha, tano rma hak tehtokony mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Anar me mak natxhe ha, amnye ha. Àwayehxemo kom waye tanàmsom me manatxhe hampànà katxho komo ryhe, anar me natxhe, kekon hatà. Àwayehpànà ro me harha manatxhe hampànà katxho komo rma, anar me natxhe. Tasanàmàtxhenye àhehtahra ro mak natxhe ha. Ànyontahra ro mak natxhe xarha. ");
INSERT INTO hixNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Àwayehpànà ro komo kax mak natxhe ha, kekon hatà. Kahe yawon komo wyaro, àwayehpànà ro me natxhe ha. Khoryenkom hokru me natxhe ha. Àwayehxemo kom waye anàmxemo komo kax mak natxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tanàmsom me xaxa mpànà natxhe ha, àwayehxemotho komo, kekon xarha tà, àwyanye. Àwayehxemotho komo yanàmtoho rma hutwamohsoy hamà, Moyses heno. Tàwya ewekhàr yoh yokarymantoko, hutwamohsoy hamà, kekon hatà, Txesusu. Onà wyaro katxho yokarymay heno hatà, Kohkomo wya Akmaraw horyen uro ha katxho rma. Esake horyen xarha uro ha katxho xarha, Xako horyen xarha uro ha katxho xarha yokarymay heno hatà. Àro wyaro katxho yokarymantoko, àwayehxemotho komo yanàmtoho hutwamohsoy hamà, Moyses heno, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Àsok tawro hana. Ehxen komo horyen mehra ro mak naha ha, Khoryenkomo. Tehxemà rma kom haxa horyen me naha. Tehxem me rma natxhe, omeroro, noro wya. Àro ke, àwayehxemotho komo yanàmnye me nay hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Àto nehxatxkon hatà, àyweronàhyamano ynye ro kukur komo. Onà wyaro nketxkon hatà, Txesusu wya. Khananàhnye y, ohxe meyuhtxowà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Àsok naye owya kahra harha nehxatxkon hatà, Txesusu xanhàn komo, noro hona towankaranàmrà komo ke mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Onà wyaro haxa nkekon hatà, Txesusu, tàxanhàn komo wya. Dafe heno yohamàtho me nay hatà, Kryestu, Khoryenkomo nànyaknyàrà rma, katxho ryhe, yaworo naye, owyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dafe heno ryhe, toh me ryhe Kryestu yotakye. Onà wyaro nkay hatà, noro heno, tàwya wano komo menhontoko. Onà wyaro nken hatà, Kohkomo, rohà wya. Ehonomnà me xaxa eryewtako, rohanaka, ken hatà. Howehehra eryewtako, ken hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Tan oyehtoko rma haka, onà wyaro kany me axanhàn komo weryaha hampànà. Ehonomnà me xaxa manaha kany me weryatxhe hampànà, ohoko, ken hatà, Kohkomo, rohà wya. Àro wyaro rma nkay hatà, Dafe heno, Kryestu hok hatà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tohamrà rma yotakyakonà, toh me. Àsok tawro ryhe, ehamàthàrà me harha nexeye, ehà rma, owyanye, kekon hatà, Txesusu, tàxanhàn komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Onà wyaro nkekon xarha tà, tànhananàhrà ro komo wya, toto komo nenytxanàr me rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Àyweronàhyamano ynye ro komo ryhe, atxke natxow hamà, kekon hatà. Atxke ehtxoho kom hona mpànà xenytxoko, nyamoro wyarohra oyehtxoho menye. Ohxe tosonyhonàr komo xe rma natxhe haryhe. Àro ke newomumtetxhe, enyhoru ke, kawono ymo ke. Àro yawo rma tetxhe, kekon hatà. Yakentawo tàtontokonye, Hay, khananàhnye y, tawro xe natxhe haryhe, toto komo wya. Ohsamnohno ytxoho ro yawo tehtokonye, ehonomnà komo yahon ho neryewtetxhe, kekon hatà. Anar kom yakoro tasahxemtontokonye, ehonomnà me tosonyhonàr komo xe rma natxhe haryhe, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nyamoro rma, enyonkaxemo katxhotho yaryatxhe xarha, tkatxho kom me harha. Khoryenkom yakoro tàrwonàmnàtokonye, mexe rma haxa nàrwonatxhe, onkuhtono ynyàr me mak ha, ohxe tosonyhonàr kom horà mak ha, kekon hatà. Àsok hana natxow ha, nyamoro ha. Tanàhnohsom me natxhe hampànà, anar komo yoho rma haxa mak ha, kekon hatà, Txesusu, tànhananàhrà ro komo wya, toto komo nenytxanàr me rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Khoryenkom màn yawo rma nehxakon hatà, Txesusu. Nosompotày hatà. Àto nehxatxkon hatà, tàtxenyerunkem komo. Tkatxhonkemà rma haxa mokyam nehxatxkon hatà. Tàtxenyerun kom hoye nenkahyatxkon hatà, txenyeru yonkahtoho ro yaka, Khoryenkom màn yonye ro komo txenyerun yon yaka rma. Nenyatxkon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Àto nehxakon xarha tà, wosà. Enyonkaxaho rma mok nehxakon hatà, àtxenyerumnu ro mak hatà. Àro yaka rma rha nenkahye hatà, noro xarha. Asak marma txko nenkahye hatà. Ehetàhpenyenohnà rma haxa yonkahye hatà. Noro yonyey hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Onà wyaro nkekon hatà, tànhananàhrà ro komo wya. Onà wyaro yaworo xaxa àkehe, owyanye, kekon hatà. Moson wosà, enyonkaxaho, àtxenyerumnu rma. Noro nàmàtho, anar komo nàmàtho yoho rma haxa tehetàhke naha, Khoryenkomo wya. Omeroron komo yoho rma haxa nenkahno ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nyamoro nàmtxowà rma haryhe, tàtxenyerun kom hoy mak ha, thenyenohnà ymo hoy mak ha. Moson haxa ryhe nàmtàhkano, omeroro mak ha, kekon hatà. Àtxenyerumra tesnàr yoho ro rma nàmtàhkano. Tànyahrà yehekahtoho kenyehra nàmtàhkano, wosà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Taa. Khoryenkom màn hoko nosonytxetxkon hatà, Txesusu nhananàhrà ro kukur komo. Poo, ohxe tonyxem me rma haxa wenyaha, moro ymo, ketxkon hatà. Ohxe tonyxem me wenyaha, tohu ymo, enyhoryexaho ymo. Àmkawon yonyhoryexah xarha, toto komo nàmàtho rma, ohxe tonyxem me rma rha wenyaha, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Amnye nosomkawononkatxehkehe hampànà, àro ymo heno, onenyetxhàyamotho ymo, kekon hatà. Osomkawono ymo heno natarymatxehkehe hampànà, othenyekhenà ro me mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Khananàhnye y, ketxkon hatà, àwya. Àsokentoko ryhe nosomtatkatxehkeno, Khoryenkom mànà ymo heno. Àhahnoke rma haxa ehtoko, eten komo tenyatxowà, uhutwamohsotho, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Onà wyaro neyuhtxownà hatà, Txesusu. Anar komo wya oyonkuhtonàr kom hona mpànà xenytxoko, kekon hatà, àwyanye. Nomokyatxhe hampànà, onkuhtono ynye komo, anaro rha komo, thenyehra. Kryestu uro ha ketxhe rma haryhe, kekon hatà. Kryestu nomokyaha katxhàràtho nenmahno haxa ha, ketxhe rma haryhe, nyamoro ha. Àtohra mpànà ehtxoko, akoronye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wahoro htxero, waha yosohtahanàr komo yokaytà menytxetxhe hampànà, kekon hatà. Tkayaryet heno komo yarymany komo yokaytà xarha menytxetxhe hampànà. Àro wyaro owyanye enytxantoko, oseryehpàra rma ehtxoko. Àro wyaro htxero haka mpànà natxhe ha, toto komo. Osomtatkatxehkahra rma hak naha, yukryeka, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Anaro rha yana heno komo nosohtahetxhe hampànà, kekon xarha tà, àwyanye. Anaro rha owto hon heno komo nosohtahetxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Anato rha nosowuhsaha hampànà, yukryeka, thenyehra. Ehxera ro mak naha hampànà, nyahà, kekon hatà. Thenyehra rma haxa naha hampànà, eherya xarha, anato rha. Anar me naha hampànà, kahe hokono. Tàwyanye àro yonyetoko, noseryehoketxhe hampànà, toto komo. Àro hona noseryehyatxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Àro wyarohra rma hak ehtoko, àro ywaho ro rma ayahohsatxhe hampànà, axanhàn komo. Oyeryewhamnohyatxhe hampànà, kekon hatà. Xuknewyana komo ayaryatxhe hampànà, tohsamnohtoho kom yaka, toh komo wya oyonytxanàr kom horà. Watxa ymo yaka xarha ayahryemyatxhe hampànà, kekon hatà. Anaro rha tkayaryet komo hyaka ayaryatxhe hampànà, anaro rha kofehnakno komo hyaka xarha. Àwyanye ayanàhnohrà kom horà ayaryatxhe hampànà, romryenon me oyesnàr komo ke mak ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Àro wyaro rma oyehtokonye, uro mekarymetxhe ha, àwyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Àro ke, ohxe mpànà ehutwatxoko, oseryehokahra oyehtxoho menye. Àsoke ryhe weyukyatxowà, roxanhàn komo, amnye ha, kahra ehtxoko, kekon hatà. Àsoke ryhe koskarymeno, àwyanye, kahra ro mak ehtxoko, ohnawonye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Uro ryhe kàrwonàhyametxhe, tàyweron me oyehtxoho menye. Ayameryekahranye natxhe, axanhàn komo, kekon hatà. Yaworohra màketxhe kahra natxhe, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Oyàm komo xarha ayahohsetxhe hampànà, axanhàn komo wya, kekon hatà. Oyon komo xarha, oyowtà komo xarha, ayanan komo xarha, ayakoronotho komo xarha, nyamoro rma ayahohsetxhe hampànà, axanhàn komo wya. Okukuthuyamo yotahetxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Oxehranye rma haxa natxhe hampànà, toto komo, omeroro, romryenon me oyesnàr komo ke mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tkurunhosom me mak manatxhe hampànà, ohpotx komo osomtatkahra rma tehxe ro mak ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Enàmtxok mak hampànà. Owyanye enàmtoho hoye ro, karyhe roro harha manatxhe hampànà, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Onà wyaro nkekon xarha tà, àwyanye. Xerusaryen heno mamtotàhketxhe hampànà, waha komo, kekon hatà. Bamtotàhkaxe ro owyanye xenyetoko, onà wyaro katxoko. Owto ymo heno yosomtatkatxehkatxho hahnoke nay hamà, katxoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Àtoko rma, onà wyaro hak nahtxoko, àton komo. Àhà ymo hona hak nekahtàmtxowà, Xukneya yamtar hon komo, kekon hatà. Xerusaryen hoy hak totxowà, àhonotho komo. Àmàhton komo xarha, Xerusaryen hona àtohra hak nahtxoko, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Àro wyaro rma nohsànàhyaha hampànà, Khoryenkomo, kekon hatà. Xuknewyana heno komo yanàhnohyaha hampànà, tàrwonàmàthàr yawo ro tehtxoho me, àmenhosahonhàr yawo ro rma tehtxoho me, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Oko txko, mokyamo txko ha, yuhna heno komo, tonarkem heno komo xarha. Xukneya yamtar hon heno komo rma, teryewhamnohsom me rma haxa natxhe hampànà, kekon hatà. Ewakhàra Khoryenkomo yehtxoho hoye ro, tanàhnohsom me rma haxa natxhe hampànà, Xuknewyana heno komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Katxefara wyaron ke totahaxem me natxhe hampànà, anar komo. Anaro rha yana kom waka tasom me natxhe hampànà, anaro komo, asohtosah me, kekon hatà. Xuknewyanahnà komo nanàhnohrà me naha hampànà, Xerusaryen heno. Ehonomnà me roro rma hak nyamoro yehtoko, tanàhnohso roro rma naha hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Onà wyaro nkekon xarha tà. Amnye anar me harha naha hampànà, kamàmà. Nuno xarha, xeryko xarha, anar me harha naha hampànà. Eryehokano ynye rma àro ha, kekon hatà. Tuna ymo xarha neyorwaha rma haxa mak hampànà, tekahxemanàr ke mak ha. Àro hoye ro noseryehoketxhe rma haxa hampànà, yukryeka hon komo, anaro rha yana komo, omeroro, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kahe hokonotho xarha nosowuhsaha hampànà. Eten komo kohotàhketxow ha, ketxhe hampànà, toto komo. Àro ke noseryehyatxhe hampànà, thenyehra mak ha. Nenyerymamyatxhe hampànà, oseryehrà komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Àro tàhto rma Toto me Enusaho yomoknàrà yonyatxhe hampànà, kekon hatà. Kahrutun wawo nomokyaha, noro ha. Ehonomnà me xaxa nomokyaha. Ohxe xaxa tonyxem me rma nomokyaha, Toto me Enusaho, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Omokhàra rma hak noro yehtoko, eryehokano ytxoho menyatxhe hampànà. Owyanye xenyetoko rma, osompohtxoko, kekon hatà. Thona ro rma haxa ehtxoko. Oyonyhoryetxehkatxho komo hahnoke rma haxa naha, Khoryenkomo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Kuknonano me xarha nekarymay hatà. Àsok hana nay ha, nat ha, kekon hatà. Naten hamà, natà, fek yohà rma, anar komo xarha, omeroro. Owyanye atanàrà yonyetoko, onà wyaro màketxow hamà. Mexehra rma haxa tàtxemnyehàntetxow hamà, màketxhe, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Àro wyaro rma rha amnye muhutwetxhe hampànà, kekon hatà. Àro wyaro owyanye ronekarymatxho yonyetoko, onà wyaro màketxhe hampànà. Mexehra rma haxa kàkayaryet komo nyakyan hamà, Khoryenkomo, màketxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Onà wyaro yaworo xaxa àkehe, owyanye. Àwayehtàkahra natxhe hampànà, amnyeno rma kukur komo. Ehtokonye rma haka nehoryatxhe hampànà, ronekarymatxho, omeroro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nosomtatkehe hampànà, kahe heno. Yukryeka heno xarha nosomtatkehe hampànà. Rorwon haxa ryhe, osomtatkahra ro mak naha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ohxe mpànà ehtxoko, kekon xarha tà. Ayasahxemtonàr kom hoko roro manatxow hana. Onyerhontanàr kom hoko roro manatxow hana. Oyomyawon kom hoko roro manatxow hana. Àro wyaro oyehtxoho kom hoko roro mehutwetxow hana, ohnawonye, kekon hatà. Àro wyaro anaro rha hoko oyehutwantokonye, nomokyan hana, Toto me Enusaho, onhutwahtor kom ho mak ha. Àro wyaro omoknàrà hona mpànà xenytxoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Noro yomoknàrà hona rohra mak natxhe hampànà, toto komo, yukryeka hon komo, omeroro. Thona rohra rma ehtokonye, nomokyaha hampànà, Toto me Enusaho, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Omnyam haxa ryhe, thona roro rma haxa mpànà ehtxok ha. Emahona ro orwonàmtxoko, Khoryenkom yakoro, kekon hatà. Onà wyaro katxoko, àwya. Apa y, owya toto komo yeryewhamnohnàtoko, towankaryhe amna txeryko, amna wya enàmtoho me, katxoko. Apa y, amna ukurunhoko, Toto me Enusaho hyaka amna totho me, noro hyawo amna yehtxoho me, katxok xarha, Khoryenkomo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Awasnaw yohà hananàhno ryakon hatà, Txesusu, Khoryenkom màn yawo. Awanaka yohà tekon hatà, Oryefera yàhàn hona harha. Kohsaya àto nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Enmahrà ro yohà, Khoryenkom màn yaka tetxkon hatà, toto komo, omeroro. Noro yonytxaxe àsna tetxkon hatà, enmahrà ro yoh hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Xuknewyana komo yasahxemtotho hahnok nehxakon hatà. Ekeyu àwakanomnà yonahtoho katxho rma àro hatà, thoryen heno komo yohokoko àtothàrànhàrà hutwatxho rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Txesusu wayehkanàr xe nehxatxkon hatà, Xuknewyana yoh komo, Khoryenkom màn yonye ro yoh komo rma, àyweronàhyamano ynye ro komo xarha. Àsoke ryhe twayehketxowà, ketxkon hatà, tàwyanye rma. Uhutwahra mak nehxatxkon hakahpa tà, toto kom hona toseryehrà komo ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Àro wyaro ehutwantokonye rma, Satanasà ymo nowomye hatà, Xuknas yowan yaka. Eskaryotesà rma noro hatà, 12 komo kukuru rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Àro ke toy hatà, Khoryenkom màn yonye ro yoh komo hyaka. Nyamoro yakoro nàrwonàmye hatà, ahosno ynye ro yoh kom yakoro xarha. Àsoke ryhe wahohseno, mokàtho ymo, owyanye, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Àro ke teryehorye nehxatxkon hatà, nyamoro ha. Otxenyerunu amna nàmyaha, noro ymo yahohsotxhetà, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Àna hamà, kekon hatà. Wahohsen hamà, owyanye, kekon hatà, Xuknasà. Àro ke, Txesusu yahohsotxahke nehxakon hatà, àwyanye. Àsokentoko tahohsorye naye, kekon hatà, tàwya rma. Toto komo ehxera ehtoko, tahohsorye nay hamà, kekon hatà, Xuknasà, tàwya rma. ");
INSERT INTO hixNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Sa, nenmahye haxa hatà, asahxemtotho komo. Ekeyu àwakanomnà yonahtoho katxho rma àro hatà. Àro rma ho tharaxkaxem me nehxakon hatà, kahneru mxekàtho. Thoryen heno komo yohokoko àtothàrànhàrà hutwatxho rma mon nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Àro ke Petru nyakye hatà, Txesusu. Xowaw xarha nyakye hatà. Àtotxoko, kekon hatà, àwyanye. Àtotxoko. Kasahxemtotho komo enyhoryetxatxko ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Henta ryhe enyhoryenàr xe manaye, amna wya, ketxkon hatà. Henta ryhe amna nenyhoryeno. ");
INSERT INTO hixNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Owto ymo hona ayahatakatxhenye rma, toto menyatxhe, kekon hatà, Txesusu. Oryen ke tomyarkemà rma oyohoryatxhe, tuna yon ke tomyarkemà rma. Noro wenarye màtetxhe ha, nàmno yaka, kekon hatà. Àro yaka owomnàtoko, mowomyatxhe ha, omnyam xarha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Onà wyaro màketxhe ha, horykomo wya, nàmno yohà wya. Hawana me nomokyan hatà, ohyaka, khananàhnye komo, màketxhe ha. Omàn yawo nasahxemten hatà, tànhananàhrà ro kom yakoro, khoryen heno komo yohokoko àtothàrànhàrà hutwatxho me, màketxhe ha. Esarà xenyhok hatà, amna wya, màketxhe ha, horykomo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Noro ryhe, bàn yawo tahusomà ymo yonyhehe hampànà, owyanye. Kayeno rma, tahonkemà ro rma yonyhehe, owyanye. Àto rma menyhoryetxhe ha, kasahxemtotho komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Àro ke totxownà hatà, Petru komo, Xowaw xarha. Txesusu rwonàmàthàrà yawo ro rma haxa nenytxownà hatà. Tasahxemtotho komo yonyhoryetxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Taa. Tasahxemtotx haxa ha katxho to ehtoko, neryewtatxownà hatà, Txesus komo, 12 komo xarha. Amnye ànànyaknyàr komo rma mokyam nehxatxkon hatà. Asahxemtoso neryewtatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Onà wyaro nkekon hatà, Txesusu, àwyanye. Mexehra keryewhamyaha hampànà, kekon hatà. Ryeryewhampàra ro rma haka ayakoronye rasahxemtonàr xe rma haxa wehxaknano. Khoryen heno komo yohokoko àtothàrànhàrà hutwanàr xe rma haxa wehxaknano, ayakoronye, ryeryewhampàra ro rma haka, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Onà wyaro àkehe, owyanye. Onà wyaro asahxemtohra harha wehxaha. Amnye tasahxemtetxhe hakahpa harha. Àsokentok hana. Khoryenkom yowto ho harha oyehtokonye, tasahxemtetxhe hakahpa harha. Khoryen heno komo yohokoko àtothàrànhàrà hokohra harha tasahxemtetxhe. Khoryenkomo wya tàmryenon komo yonyhoryetxehkatxho hok haxa ryhe tasahxemtetxhe hakahpa harha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ufa xkun yonà yanàmye hatà. Apa y, ohxe onàmàthàrà onà, kekon hatà, Khoryenkomo wya. Nàmye hatà, àwyanye. On ekamtxoko kekon hatà. Ekamtxoko, owyanye rye rma, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Onà wyaro àkehe xarha, owyanye. Ufa xkun yonhàra harha wehxaha, kekon hatà. Khoryenkom yowto ho harha oyehtokonye, tenyatxhe hampànà. Àro hohra rma hak oyehtokonye, enhàra roro rma wehxaha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ekeyu yanàmye hatà. Apa y, ohxe onàmàthàrà onà, kekon hatà. Nàkràskay hatà. Nekamye hatà, àwyanye. Rohun kuknonà rma onà, kekon hatà. Rohunutho rma wàmyaha, rowayehrà ke. Kwayehyaha, tonyhoryexem me harha oyehtxoho menye, kekon hatà. Ekeyu kràskatxho hoko roro ehtxoko, owyanye rohutwatxho me, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Àro wyaro rma rha ufa xkun yon hoko nehxakon xarha tà, tasahxemtotxheny mak hatà. Rokamsukuru kuknonà rma onà, kekon hatà. Ryekamsuhkatxho hoye ro, onà wyaro nkehe ha, Khoryenkomo. Romryenon komo yonyhoryetxehkany me harha wehxaha, kehe ha. Àro wyaro katxho me harha manatxhe ha, ryekamsuhkatxho hoye ro, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tano rma naha, rahohsonye, kekon xarha tà. Rakoro rma nasahxemtehe. Noro rma rahohsehe hampànà, roxanhàn komo wya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Khoryenkomo yehutwatxho yano me àwayehso àtehe hampànà, Toto me Enusah kaxe. Tanàhnohsom me mak naha hampànà, rahohsonyenhàrà ymo heno, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Àro ke, onà wyaro nketxkon hatà, 12 komo, tàwyanye rma. Onokà ryhe nahohseno, àxanhàn komo wya, ketxkon hatà. Onokà kukukur komo nahohseno, àxanhàn komo wya, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Natameryekatxownà hatà, 12 komo, nyamoro rye rma. Onokà ryhe ehonomnà me nyhe naye, kwawonye, ketxkon hatà, tàwyanye rma. Àro wyaro katxho hoko natameryeketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Àro ke, onà wyaro nkekon hatà, Txesusu, àwyanye. Àsok hana natxow ha, toto kayaryet kom ha, anaro rha yana kayaryet kom ha, kekon hatà. Ehonomnà me rma haxa natxow hamà, tàmryenon komo yoho rma haxa mak ha. Àro ke thenyehra rma haxa nanotometxow hamà, kekon hatà. Onà wyaro tawro xe natxhe xarha, tàmryenon komo wya. Amna yowakryenye ro omnyamo, ehonomnà komo kaxe, tawro xe natxhe, àwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Omnyam haxa ryhe, nyamoro wyarohra mpànà ehtxoko. Bàryekomo wyaro hak nahtxoko, horykomo komo, kekon hatà. Tkukuru komo yanoto me hak nahtxoko, ehonomnà komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Onà wyaro nasahxemtetxow hamà, toto komo, kekon xarha tà. Ehonomnà komo htxero nasahxemtetxhe. Ànyahrà komo yaryatxhe, anoto komo, àhyakanye, kekon hatà. Tànyahrà yany komo yoho rma haxa natxow hamà, tasahxemtosom komo. Nyamoro wyarohra mak wehxaha, awawonye. Ayanoto kom me rma wehxaha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Onà wyaro nkekon xarha tà, àwyanye. Anar komo wya ryeryewhamnohnàtoko, rohnànkahra ro mak mehxatxkonà, omnyamo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Toto komo kayaryet me rowahanonkaye, royàmà. Rowyaro rma rha àkayaryet kom me kwahanonketxhe, omnyam xarha, rohnànkanyehnànhàrà me oyesnàr komo ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Àro ke, amnye masahxemtetxhe, rakoro. Khoryenkomo wya toto komo kayaryet me ronyaketxhe rma, masahxemtetxhe, rakoro, kekon hatà. Ehonomnà me meryewtetxhe xarha. Eryewtaxaho rma, Ehsayewyana komo màwahanonketxhe, atxke manatxhe tawro me, ohxe manatxhe tawro me xarha, kekon hatà, Txesusu, 12 komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Onà wyaro nkekon hatà, Txesusu, Semaw Petru wya. Semawu y, kekon hatà. Semawu y, okukmanàr komo xe naha, Satanasà ymo, kekon hatà. Nasànasà nyohonàrà wyaro okukmanàr komo xe naha. Nasànasà tànyohen hamà, kàwya uhpunuthuru hahrà horà. Àro wyaro rma rha okukmanàr komo xe naha, Satanasà ymo, tàwya ayanhàn komo yonyhonàr horà, kekon hatà. Ukukmaxeny haka kan hampànà, Khoryenkomo wya. Noro yano me okukmetxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Uro ryhe kàrwonàmno, Khoryenkom yakoro, ohoko, kekon hatà. Semawu y, ohoko rma kàrwonàmno, rohona xenyhera harha oyesnàr hona. Àsok tawro hana. Uro màhnànkehe htxero hakahpa, kekon hatà. Amnye meramehe hakahpa harha, rohyaka harha. Àro wyaro ohxe harha oyexetxhe, oyowtà komo makoronomehe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Rohà y, kekon mak hatà, Petru. Ayakoro tàtosomà rma uro. Watxa ymo yaka tahryemxe ro ayakoro àtehe, kekon hatà. Twayehso ro ayakoro àtehe, kekon hatà, Petru. ");
INSERT INTO hixNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Onà wyaro haxa nkekon hatà, Txesusu, àwya. Petru y, onà wyaro àkehe, owya, kekon hatà. Noro ywenyeke wehxaha màkehe hampànà, rohoko. Màkehe xarha, màkehe xarha, osorwawo ro, kekon hatà. Àro wyaro rma màkehe hampànà, amnye rma, apaytara htàmpàra ro rma haka, kekon hatà, Txesusu, Petru wya. ");
INSERT INTO hixNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Onà wyaro nkekon xarha tà, 12 komo wya. Amnyehra dyahtxownà, kekon hatà. Rowya anyaknyetokonye, onà wyaro àkekonà, owyanye. Otxenyerun komo yonà yarhàra ehtxoko, àkekonà. Ayamatan komo yarhàra ehtxoko àkekon xarha. Ohrorà womun komo yarhàra ehtxoko àkekon xarha, owyanye, kekon hatà, Txesusu. Àro wyaro akorohra otontokonye, ewakryehnà me kat mehxatxkonà, kekon hatà, Txesusu. Towakryexem me rma amna nehxakonà, ketxkon hatà, 12 komo. ");
INSERT INTO hixNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Amnye rma haxa tàxanomkahnohsom me harha wehxaha, kekon hatà, Txesusu. Àro ke tkatxhonke oyehtokonye, akatxho komo atxoko, otxenyerunu yon komo rma, ayamatan komo xarha, kekon hatà. Àwatmamra oyehtokonye, ehekahtxoko, awatman komo, katxefara wyarono, oyekrunhotho komo. Ohononàthàyamo rma tàmtxoko, txenyeru hona, owyanye awatman komo yehekahtoho me, kekon hatà, Txesusu. Àro wyaro mpànà ehtxok ha, tàxanomkahnohsom me harha ryesnàr ke. ");
INSERT INTO hixNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Onà wyaro àkehe, owyanye, kekon hatà. Tàxanomkahnohsom me wehxaha hampànà, Khoryenkom karyehtan yawo ro rma haxa ryehtxoho me. Onà wyaro nkehe, rohoko, àmenhosahonhàrà. Waha kom kukuru moson hamà katxho me naha hampànà, toto komo wya. Àro wyaro rma nkehe, àmenhosahonhàrà, rohoko, kekon hatà. Àro wyaro katxhàrànhàr yawo ro tàxanomkahnohsom me wehxaha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Amna yohà y, on xenyko, ketxkon hatà, nyamoro. On xenyko, amna watmanà, asako, katxefara wyarono, ketxkon hatà. Àna ha, kekon mak hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Taa. Owto ymo hoye toy hatà, Txesusu. Oryefera yàhàn hona toy hatà. Àsna yohà tàtosom me nehxakon hatà. Akoro rma totxownà hatà, ànhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Àsna àtehe katxho na rma totxownà hatà. Àto tehtokonye, onà wyaro nkekon hatà, Txesusu, àwyanye. Khoryenkom yakoro orwonàmtxoko, anhà nkukmahtor me oyehtxoho menye, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Àhyayenye toy hatà, meya nyhe txko hatà, toh yarymaxaho yothahtoho na rma hatà. Àto tehtoko neryewtay hatà, tosoknar ho. Khoryenkom yakoro nàrwonàmye hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Apa y, ryeryewhamtoho hona uro ukurunhoko, rokurunhonàr xe oyehtok mak ha, kekon hatà. Rano me rohra mak ryesnàr xe wehxaha. Ayano me ro ryhe ryesnàr xe wehxaha, kekon hatà, Txesusu, Khoryenkomo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Àtoko rma nosonyhoy hatà, kahe yawono, Khoryenkomo nànyaketxho rma. Txesusu wya nosonyhoy hatà. Nakoronomay hatà, tahoxerye nyhe ehtxoho me. ");
INSERT INTO hixNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Thenyehra rma haxa neryewakon hatà, Txesusu, tàhnawo. Àro ke teryewrye ro rma haxa nàrwonàmye hatà, Khoryenkom yakoro. Heramuhtekon hatà, thenyehra hatà, teryewhamrà ke mak hatà. Àheramkuru rma, kamsuku wyaro nehxakon hatà. Kahtekon hatà, yukryeka hona. ");
INSERT INTO hixNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tàrwonàmàtxhe rma, nasanàmye harha tà. Toy harha tà, tànhananàhrà ro komo hyaka. Nànàhtxownà hatà, nyamoro ha, tekhokanàr komo ke rma haxa mak hatà. Ànàhxemo rma yonytxownà hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tànàkhoryehra mahtxok haryhe, kekon hatà, àwyanye. Asanàmtxok harha. Khoryenkom yakoro orwonàmtxoko, anhà nkukmahtor me oyehtxoho menye, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Àro wyaro Txesusu wya tatoko rma nomohtxownà hatà, toto komo, thenyehra hatà. Wahoro nomokyakon hatà, Xuknasà. 12 komo kukuru rma mok nehxakon hatà. Txesusu hahnohye hatà, tàwya amtxuhkanàr horà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Onà wyaro haxa nkekon hatà, Txesusu, àwya. Àsok tawro hana Toto me Enusaho mamtxuhken ha, kekon hatà. Uro mamtxuhken hamà, waha komo wya ronytxoho me, àwyanye rahohtoho me, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Onà wyaro nehutwetxkon hatà, Txesus yakoron komo. Nahohsatxow hamà, moxamo, waha komo, ketxkon hatà, tàhnawonye. Àro ke, onà wyaro nketxkon hatà, àwya. Amna yohà y, etahahranye kat amna naye, amna watman ke, katxefara wyaron ke, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ukukur komo rma tototho hanakay hatà. Khoryenkom màn yonye ro komo yohà ymo yanototho rma hanakay hatà, txaray. Howehenohnàtho rma yawotoy hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Onà wyaro haxa nkekon hatà, Txesusu. Àro wyarohra ehtxoko, kekon hatà, takoron komo wya. Toto hanatho yahey hatà. Nenyhoryey harha tà. Hanahtoy hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Àto nehxatxkon hatà, Khoryenkom màn yonye ro yoh komo, ahosno ynye ro yoh komo xarha, horykomo komo xarha. Noro yahohso omohxemo komo rma nyamoro hatà. Onà wyaro nkekon hatà, Txesusu, àwyanye. Àsok tawro twatmanke momohtxowà, kekon hatà. Àsok tawro tkatxefaranke momohtxowà. Waha me uro menyatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Emahona ro ohyawonye wehxaknano, Khoryenkom màn yawo. Àto rma ryehtoko, rahohsàra rma mehxatxkenano, kekon hatà. Amnye rma haxa uro mahohsatxow hamà, Khoryenkomo yehutwatxho hoye ro mak ha. Amnye rma rahohsehe, owyanye, awaràn yohà ymo, Khoryenkomo yehutwatxho hoye ro mak ha, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Àro wyaro Txesusu wya katxhe rma, noro yahohtxownà hatà. Txom katxownà hatà. Natxownà hatà, nàmno ymo yaka, Khoryenkom màn yonye ro komo yohà ymo màn yaka. Àwenaryenye toy hatà, Petru, moxe nyhe hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nàmno ymo watxan yawo nehxatxkon hatà, toto komo. Weheto yarymatxownà hatà. Àto rye rma neryewtatxownà hatà. Àwawonye rma neryewtay hatà, Petru. ");
INSERT INTO hixNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Àto nehxakon hatà, omaso, anotonano. Petru yonyey hatà, weheto hona. Àto eryewtaxaho rma yonyey hatà. Nenytxehkekon hatà. Txesus yakoronotho komo kukuru moson hamà, kekon hatà, Petru hoko. ");
INSERT INTO hixNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Norohnà uro wosà y, kekon mak hatà, Petru. Noro ywenyeke wehxaha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mexehra ehxah me noro yonyey hatà, toto, anaro. Nyamoro kukuru omoro hamà, kekon hatà, àwya. Norohnà uro hoymo y, kekon mak hatà, Petru. Noro ywenyeke wehxaha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","1 ora yonatàtxhe rma, onà wyaro nkekon hatà, toto, anaro. Karyeryeya honotho me nay hamà, mosonà, kekon hatà, Petru hoko. Txesus yakoronotho me xaxa mpànà naha ha, kekon hatà, teryewrye ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Onà wyaro nkekon mak hatà, Petru. Hoymo y, àsok màken haryhe, kekon hatà. Orwon hutwahra wehxaha. Yaworohra màkehe. Noro ywenyeke wehxaha, kekon hatà, Petru. Àro wyaro àwya tatoko rma, nàhtàmye hatà, apaytara. ");
INSERT INTO hixNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Petru hyaye moxehra nehxakon hatà, Kohkomo. Àro ke neramay hatà, Petru wetxe. Noro yonytxehkekon hatà. Àro ke, Kohkomo rwonàmàthàràtho hutway harha tà, Petru. Noro ywenyeke wehxaha màkehe hampànà, rohoko, katxhàràtho rma hutway hatà. Màkehe xarha, màkehe xarha, osorwawo ro, katxhàràtho rma, àro wyaro rma màkehe hampànà amnye rma, apaytara htàmpàra ro rma haka, katxhàràtho rma hutway hatà, Petru. ");
INSERT INTO hixNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Àro ke nahatakay hatà, nàmno watxan yaye. Nàratay hatà, thenyehra. Noseryehokekonà rma haxa mak hatà, tàwya noro ywenyeke wehxaha katxhàràtho hok hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Txesusu yownohyatxkon hatà, ahosnyenhàyamo. Netahetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nempatanyohomtotxownà xarha tà. Empatanyohomtosaho wya rma, onà wyaro nketxkon hatà, tàwyanye ewnohrà me rma hatà. Onok oyotahano, etaxko mpa, ketxkon hatà, àwya. Etaxko mpa, oyotahanyenhàrà, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Anar me rha atxke nàrwonatxkon xarha tà, noro hoko, thenyehra hatà. Wàràhyaketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sa, nenmahye hatà. Nohsamnohtxownà hatà, horykomo komo, tosonytxaxemà ro komo rma. Khoryenkom màn yonye ro yoh komo xarha, àyweronàhyamano ynye ro komo xarha, omeroro rma nohsamnohtàkatxownà hatà. Tàhyakanye Txesusu yokhotxownà hatà, ahosno ynye ro komo wya. Onà wyaro nketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Oskarymako, amna wya, ketxkon hatà. Kryestu me manaye. Oskarymako, amna wya, ketxkon hatà. Onà wyaro haxa neyuhtxownà hatà, Txesusu. Rowya Kryestu uro tatoko rma, yaworo màken hamà kahra ro mak manatxhe ha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Rowya àsok wehxano, owyanye, tatoko rma, royukhura ro mak manatxhe ha, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Amnye Khoryenkom hanaka eryewtaxah harha mpànà naha ha, Toto me Enusaho, kekon hatà. Ehonomnà xaxa hanaka rma, howehehra eryewtaxah harha mpànà naha ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Àro wyaro owya tatoko, Khoryenkom muru uro màkeno rma hamà, ketxkon hatà, nyamoro ha, omeroro. Noro mehra kat manaye, ketxkon hatà. Noro me wehxan hamà, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yaworohra rma haxa noskaryman hamà, denytxanàr kom me, ketxkon hatà, tàwyanye rma. Àro ke, noro yanhànà yokarymany komo yonytxahra harha tehtxe. Noro rma atxke nàrwonàmno, Khoryenkom hoko, denytxanàr kom me, ketxkon hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nasanàmtxownà hatà, tosonytxaxemà ro komo, ohsamnohxemo komo rma. Txesusu yatxownà hatà, Peratusu hyaka, kofehnakno hyaka. ");
INSERT INTO hixNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Noro hoko atxke nàrwonatxkon hatà, Peratus yakoro. Homayana heno komo tarymatxe keknano, mosonà ymo, amna yanan komo wya, Xuknewyana komo wya, ketxkonà rma haryhe tà. Txenyerun komo yàmpàra harha tehtxe, Sesa wya, keknan xarha. Kryestu uro akayaryet komo, keknan xarha, ketxkonà rma haryhe tà. Àro wyaro àwya tatoko rma, amna nahohsako, ketxkonà rma haryhe tà, Xuknewyana yoh komo, Peratusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Onà wyaro nkekon hatà, Peratusu, Txesusu wya. Xuknewyana komo kayaryetà omoro, owya, kekon hatà. Omoro rma, Xuknewyana komo kayaryetà omoro màkano, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Onà wyaro nkekon hatà, Peratusu, àwyanye, Khoryenkom màn yonye ro yoh komo wya, toto komo wya xarha, ohsamnohxemo komo wya. Ohxe we naha ha, mosonà, rowya, kekon hatà. Ehxera we naha ha, anhànà, rowya, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Noro hoko nàrwonatxkonà rma haxa mak hatà, nyamoro ha, teryewrye ro hatà. Toto komo yeryehokehe, mosonà ymo, thenyehra, ketxkonà rma haryhe tà. Atxke hananàhyatxhe. Xukneya yamtar horye àhananàhsonye tehe, ketxkonà rma haryhe tà. Amnyehra Karyeryeya yamtar hon komo hananàhyakonà htxero hakahpa tà. Amnye rma tanon komo hananàhyaha xarha. Tàwya àhananàhtoho kom hoye ro neryehoketxhe, àwyanye ayarymanàr kom horà, ketxkonà rma haryhe tà, Peratusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Àro wyaro tàwya enytxatxhe rma, onà wyaro nkekon hatà, Peratusu, àwyanye. Karyeryeya honotho me naye, mosonà, kekon hatà. Karyeryeya honotho me naye. ");
INSERT INTO hixNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Àna hamà, Karyeryeya honotho me nay hatà, ketxkon hatà. Àro ke, onà wyaro nehutway hatà, Peratusu. Karyeryeya honotho me tehtoko, Eroknesà mryenon me nay hamà, kekon hatà, tàwya rma. Àro ke, Txesusu yarhoy hatà, Eroknesà hyaka. Xerusaryen hona omohsah me nehxakon hakahpa tà, Eroknesà. Àro ke, noro hyaka narhoy hatà, Peratusu, tanoto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tàwya Txesusu yonyetoko, teryehorye nehxakon hatà, Eroknesà. Àsok tawro hana. Mexe rma haxa Txesusu yonyàr xe nehxakon hatà. Ekaytà yonytxanyenhàr kaxe ryhe tà nehxakon ha. Àro ke noro yahoxetà yonyàr xe nehxakon hatà. Tahoxetà hutwamohsotho yenyàr xe nehxakon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Àro ke nàrwonakon hatà, Txesus yakoro, mex hatà. Àsok naye, owya, kekonà roro hatà, anaro rha hoko, thenyehra hatà. Eyukhura mak nehxakon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Àto harha nehxatxkon hatà, Khoryenkom màn yonye ro yoh komo, àyweronàhyamano ynye ro kom yakoro xarha. Atxke nàrwonatxkonà rma hatà, Txesus hoko, thenyehra rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Norohnàtho wyaro rma haxa Txesusu yeryatxkon hatà, Eroknes komo, tanoto kom yakoro xarha, arymano ynye ro kom yakoro rma. Newnohyatxkon hatà. Honomtotxownà hatà, enyhoru ke, ehonomnà komo honon ke, tàwyanye ewnohrà me rma hatà. Thononke rma narhoy harha tà, Eroknesà, Peratusu hyaka. ");
INSERT INTO hixNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Àro rma ho osox harha nehxatxkon hatà, Eroknes komo, Peratus yakoro. Amnyehra osoxehra nehxatxkonà htxero hakahpa tà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Taa. Anyeknyo yeryey hatà, Peratusu. Khoryenkom màn yonye ro yoh komo yanyekye hatà. Xuknewyana yoh komo rma, toto komo xarha yanyekye hatà. Àro ke, àhyaka nohsamnohtàkatxownà hatà, omeroro hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Onà wyaro nkekon hatà, Peratusu, àwyanye, Txesus hoko. Moson mehtxowà, rohyaka, kekon hatà. Homayana heno komo tarymatxe keknano, toto komo wya, màkatxowà, kekon hatà. Àro ke, noro yakoro kàrwonàmno, onenytxanàr kom me. Noro yanhànà ehxera ro mak nahko, rowya, kekon hatà. Onekarymatxhàyam yawo rohra mak nahko, mosonà, rowya, kekon hatà, Peratusu. ");
INSERT INTO hixNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Àro wyaro rma rha nkan hatà, Eroknes xarha, àhoko. Àro ke nekhon harha, rohyaka, kekon hatà. Twayehkahorye naha, atxke tesnàr ke, màketxhe, omnyamo. Twayehkahoryehra haxa we naha ha, rowya, anhànà ehxera esnàr ke, kekon hatà, Peratusu. ");
INSERT INTO hixNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Àro ke àhpokhehe marma, ranoto komo wya, àhanatanàhrà horà, kekon hatà. Àwyanye àhpoketxhe rma, wenampatakehe, kekon hatà, Peratusu. ");
INSERT INTO hixNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Toto kom yano me ahryemxahotho yonampatakanye ro kax mak nehxakon hatà. Asahxemtontokony yohà, towenyxa tototho yonampatakanye ro me nehxakon hatà, Peratusu, toto kom yano me hatà, àwyanye thoryen heno komo yohokoko àtothàrànhàrà hutwantok yoh hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Onà wyaro haxa nketxkon hatà, toto komo, omeroro, teryewrye ro hatà. Àwayehkahoko hxak ha, mosonàtho, ketxkon hatà. Mosonàhnà enampatakahoko. Barakmas haxa enampatakahoko, amna yano me mak ha, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Watxa ymo yaka ahryemxahonhàrà rma noro hatà, Barakmasà, Homayana heno komo tarymatxe kanyenhàr me tesnàr ke hatà. Xerusaryen ho Homayana komo yarymatxahke nexey hatà. Toto heno yotahanyenhàr me xarha nehxakon hatà, Barakmasà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Txesusu yonampatakanàr xe rma nehxakon hatà, Peratusu. Àro ke nàrwonàmye xarha tà, toto kom yakoro. ");
INSERT INTO hixNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Onà wyaro nketxkon mak hatà, nyamoro ha. Amoyathohoko, yahkotohen hona, ketxkon hatà, teryewrye ro hatà. Amoyathohoko, yahkotohen hona, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nàrwonàmye xarha tà, Peratusu. Osorwawo ro rma nàrwonàmye hatà, toto kom yakoro. Àsok ehtxoho hoye ro wamoyathoheno, kekon hatà. Àsoke ryhe naye, anhànà, owyanye. Atxke ehtoko, wamoyathohen hamà. Ehxera mak naha, anhànà, rowya, kekon hatà. Àro ke àhpokhehe marma, ranoto komo wya. Àwyanye àhpoketxhe rma, wenampatakehe, kekon hatà, Peratusu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Atàknahra ro mak nehxatxkon hatà, toto komo. Nàrwonatxkonà rma haxa mak hatà, teryewrye ro rma haxa mak hatà. Amoyathohoko, yahkotohen hona, ketxkonà rma haxa hatà. Amoyathohoko, yahkotohen hona, ketxkon hatà. Àro ke neyuhtxownà haxa hatà, Peratusu. ");
INSERT INTO hixNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Àrwonàmàthàyam yawo ro rma Txesusu yamoyathohoy hatà. Onà wyaro nkekon hatà, tanoto komo wya, arymano ynye ro komo wya. Yahkotohen hona amoyathoso atxok ha, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Watxa ymo yaka ahryemxahonhàràtho ryhe yonampatakahoy hatà, noro enampatakahoko tawro ke rma haxa mak hatà, toto komo wya. Homayana komo yarymatxahkenotho rma yonampatakahoy hatà, toto heno yotahanyenhàrà rma hatà. Txesus haxa ryhe yamoyathohoy hatà, nyamoro yano me ro rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Txesusu yatxownà hatà, arymano ynye ro komo. Tàtonàr kom me toto yahohtxownà hatà, txom. On wewe yahkotoheno arko ha, omoro, ketxkon hatà, àwya. Semawu rma noro hatà. Seryen honotho rma mok nehxakon hatà. Noro rma, owto ymo hona nomokyakon hatà. Noro motaka yahkotoheno yanàmtxownà hatà. Àro ke narày hatà, Txesus wenarye hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Àwenarye rma rha tetxkon hatà, toto komo xarha, woràskomo komo xarha, thenyenohnà komo rma. Nàratetxkon hatà, woràskomo komo. Nehokoyatxkon hatà, noro heno hnànà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Àwetxenye neramay hatà, Txesusu. Onà wyaro haxa nkekon hatà, àwyanye. Woràskomo komo y, Xerusaryen hon komo y, kekon hatà. Rohnànàhnà ryhe owratatxoko. Oyotàhnàn kom haxa owratatxoko, ohokyam komo hnàn xarha, tanàhnohsom me rma haxa oyesnàr komo ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Àsok tawro hana. Amnye, onà wyaro nketxhe hampànà, woràskomo heno komo, Xerusaryen hon heno komo. Àhokhunu ro me ryesnàr xe wehxaha haryhe, ketxhe hampànà, teryewhamnohsom me rma haxa tesnàr komo ke, kekon hatà, Txesusu. Yuhnahnà ro me rma ryesnàr xe wehxaha haryhe, enartahnà ro me rma ryesnàr xe wehxaha haryhe, ketxhe hampànà, teryewhamnohsom me rma haxa tesnàr komo ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kwayehsà haka, àhà ymo hak ryeryemnukno, àhà txko hak ronamno, ketxhe hampànà, Xerusaryen hon heno komo, teryewhamnohsom me rma haxa tesnàr komo ke, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wewe enyhoru wyaro uro wehxan hamà, ranhàn ehxera esnàr ke, kekon xarha tà. Wewe enyhoru rma yanàhnohpàra natxow hamà, toto komo. Ranàhnohyatxhe mak ha, kekon hatà. Wewe àwayehsahotho wyaro haxa ryhe natxhe, Xerusaryen hon heno komo, atxke rma haxa tesnàr komo ke. Nyamoro heno rma, tanàhnohsom me rma haxa natxhe hampànà, amnye ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Taa. Anaro heno komo xarha yaryatxkon hatà, arymano ynye ro komo. Wahanho komo rma nyamoro hatà, asak hatà. Txesusu wyaro rma rha yahkotohen hona tamoyathosom me nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Amoyathono ytxoho ro na nahatakatxownà hatà, okno yhutho yotxhotho onà katxho na rma hatà. Àto tehtokonye, Txesusu yamoyathotxownà hatà, yahkotohen hona. Wahanho heno komo xarha yamoyathotxownà hatà. Txesus hanawo nehxatxkon hatà, nyamoro heno. Anaro howehehra nehxakon hatà. Anaro xarha howehe nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Khoryenkom yakoro nàrwonàmye hatà, Txesusu, tamoyathonyenhàyam hoko. Apa y, oseryewhokako, moxam hoko, kekon hatà. Moxam hoko oseryewhokako, tanhàn komo hutwahra esnàr komo ke, kekon hatà, tamoyathonyenhàyam hoko. Txesusu womunutho yokamtxownà hatà, tàwyanye rma. Tohu txko yarymatxownà hatà, tàwyanye xenytxoho me, tàwyanye àrotho uro hamà katxho me. Àro wyaro nekamtxownà hatà, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Àto nehxatxkon hatà, toto komo. Nenyatxkon hatà. Eh komo ryhe, Txesusu yownohyatxkon hatà. Toto komo yonyhoryetxownà hatà, mosonà, ketxkon hatà. Tano me ro hak nosonyhoryeno, Kryestu me tehtoko, Khoryenkomo nànyaketxho me rma tehtoko, Khoryenkomo nwahanonkatxho me rma tehtoko, ketxkon hatà, Xuknewyana yoh komo. Àro wyaro rma newnohyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Arymano ynye ro komo xarha newnohyatxkon hatà. Àhyaka haxa totxownà hatà. Àwokru me ufa xkunu yàmtxownà haryhe tà, àwya. Tutxunyemà rma yàmtxownà haryhe tà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Onà wyaro nketxkon hatà, àwya. Xuknewyana komo kayaryet me oyehtoko, osonyhoryeko, ketxkon hatà, arymano ynye ro komo. ");
INSERT INTO hixNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Txesus yohoye nehxakon hatà, àmenhosaho. Xuknewyana komo kayaryet heno mosonà katxho rma àro hatà, àmenhosaho. ");
INSERT INTO hixNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Txesusu wàràhyakay hatà, wahanho heno komo kukuru, amposohtosah heno komo kukuru. Kryestu mehra kat manaye, kekon hatà. Kryestu me oyehtoko, osonyhoryeko, ayano me ro, àwayehpàra oyehtxoho me, kekon hatà. Amna xarha enyhoryeko, àwayehpàra rma rha amna yehtxoho me, kekon hatà, noro heno, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Neyey mak hatà, anaro heno. Khoryenkom hona toseryehporye mahko haryhe, kekon hatà, tkukur heno wya. Àsok tawro hana. Noro wyaro amoyathosah me rma rha tehxan hamà, kàwrotho xarha. Àro ke toseryehporye mahko haryhe, Khoryenkom hona, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kàwrotho rma, atxke rma haxa tehxakon hamà. Twayehkahoryem me rma haxa tehxan hamà, kekon hatà. Kanhànàthàrà yehetho rma on hamà, kwayehrà. Moson haxa ryhe, anhàn ehxera ro mak naha ha, kekon hatà, wahanhotho, tkukur heno wya. ");
INSERT INTO hixNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Onà wyaro nkekon xarha tà, Txesusu wya. Amnye ehonomnà me momokyan hatà, kekon hatà. Toto komo kayaryet me rma momokyan hatà. Àro wyaro ehonomnà me xaxa oyomoknàtoko, rohutwahkahpàra exko, kekon hatà, wahanhotho. ");
INSERT INTO hixNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Onà wyaro yaworo xaxa àkehe, owya, kekon hatà, Txesusu, àwya. Amnye rma haxa eryehotanàhsah me harha mpànà manaha ha, rowyaro rma rha Khoryenkomo hyawo oyesnàr ke, kekon hatà, Txesusu, wahanhotho wya. ");
INSERT INTO hixNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Taa. Kamàmà thataw harha nehxakon hatà. Ràà, nawanay mak hatà, yukryeka yamtar horye, omeroro hatà. Osonyhera harha nehxakon hakahpa tà, kamàm heno. 3 oras nenatày hatà, tawanye rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Àro wyaro rma hak ehtoko, Khoryenkom màn yawonotho newaraxkay hatà. Thoko rma newaraxkay hatà, wom yatxarakaxahotho, Khoryenkom màn yawonotho. ");
INSERT INTO hixNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nàrwonàmye haxa hatà, Txesusu, teryewrye ro hatà. Apa y, rokato ahosko, kekon hatà, Khoryenkomo wya. Ohyaw hak nahko, rokato, kekon hatà. Àro wyaro tàwya katxhe rma, wayehye hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Àto nehxakon hatà, arymano ynye ro komo yohà, 100 komo yohà rma. Txesusu wayehrà yonyey hatà. Tàwya xenyetxhe rma, onà wyaro nkekon hatà. Ohxe xaxa nay hamà, Khoryenkomo, kekon hatà. Enyhoru me xaxa nahko hamà, moson heno, kekon xarha tà, Txesus hoko. ");
INSERT INTO hixNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Àsok hana nehxatxkon ha, toto kom ha. Txesusu wayehrà yonyxe ohsamnohtàkaxemo komo rma mokyam nehxatxkon hatà. Tàwyanye xenytxehkatxhe rma, nosowankahetxkon hatà, toseryehokanàr komo ke hatà. Àro wyaro rma bàn kom yaka harha totxownà hatà, tosowankahanàr kom me rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Àto nehxatxkon xarha tà, Txesus yakoronotho komo, woràskomo kom yakoro xarha. Moxe ro rma, omeroro nenytxehkatxownà hatà. Woràskomo komo rma, Karyeryeya yamtar hoye omohsahotho me nehxatxkon hatà, Txesus yakoro omohxemotho komo rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Taa. Peratusu hyaka toy hatà, horykomo. Xose rma noro hatà. Arymateya honotho rma mok nehxakon hatà, Xukneya yamtar honotho rma hatà. Tosonytxaxemà ro komo kukur me nehxakon hatà. Enyhoru rma mok nehxakon hatà, yaworon xaxa hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Kàkayaryet kom me Khoryenkom nànyaknyàrà hona ro nehxakon hatà. Horykomo komo yanwekye hatà, noro ha. Txesus hoko tosonytxantokonye rma, nanwehtxownà hatà. Àwyanye twayehkahorye naha mosonà tatoko rma, àna hamà kahra ro mak nexey hatà. Àro wyaro nehxakon hatà, Xose. ");
INSERT INTO hixNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Noro rma toy hatà, Peratusu hyaka. Txesusu yekehàtho yanàr xe wehxaha, rowya enamtoho me, kekon hatà, àwya. Àro ke narhoy hatà, Peratusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Àro ke ekehàthàrà yowye hatà, yahkotohen hoye. Karamye hatà, wom ke, enyhoru rma ke. Nenamye hatà, toh yowtar yaka, onamno ytxoho yaka. Toto heno komo yonamtoho mehra hak nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hokano ytxoho yawasàn yosnaka rma tà nenamye ha, Xuknewyana komo yosonyhoryetxho yawasàn ho rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Xose wenarye totxownà hatà, woràskomo komo. Karyeryeya yamtar hoye omohxemotho komo rma mokyam nehxatxkon hatà, Txesus yakoronotho komo rma hatà. Onamno ytxoho na totxownà hatà, Xose wenarye hatà. Toh yowtarà yonytxownà hatà. Enamrà xarha yonytxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Àro wyaro tàwyanye xenyetxhe rma, totxownà harha tà, bàn kom yaka. Ownyaku thoxnyemà yonyhoryetxownà hatà, tàwyanye ekehàthàrà karyenàr horà. Hokano ytxoho yawasàn ho hokatxownà htxero hakahpa tà, tàyweronàhyamatxho kom yawo ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sa, nenmahye hatà, domenku. Enmahrà ro totxownà hatà, woràskomo komo. Onamno ytxoho na totxownà hatà. Ownyaku thoxnyemà yatxownà hatà. Tànenyhoryetxhàyamo rma yatxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tohu ymo ahutoho ymo yonytxownà hatà. Ewtar hotaye etakaxaho rma yonytxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Àro yaka nowomtxownà hatà. Ehxera mak nehxakon hatà, ekehàthàrà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Henta haryhe, ketxkon hatà. Uhutwahra nehxatxkon hatà. Àtoko rma nosonyhotxownà hatà, àwyanye, toto wyaron komo, asako. Thononke nehxatxkon hatà. Onkaxnyo ynye me nehxakon hatà, àhonon komo. ");
INSERT INTO hixNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Noseryehyatxkon hatà, woràskomo komo. Àro ke newanatxownà hatà. Osompothàra rma nehxatxkon hatà. Onà wyaro nketxkon hatà, asakon komo, àwyanye. Àsok tawro momohtxowà, xaro, ketxkon hatà. Àsok tawro momohtxowà, xaro. Onamno ytxoho yawohra nay hamà, àwayehpànà, karyheno, ketxkon hatà. Onehonàr komo rma, tan ehxera naha. ");
INSERT INTO hixNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Nasanàmno ha, àwayehxemo kom waye, ketxkon hatà. Noro rwonàmàthàràtho hutwahkahpàra ehtxoko. Karyeryeya yamtar ho rma hak tehtoko, onà wyaro oskarymahra kat nehxakonà, owyanye, ketxkon hatà. Tahohsosom me naha hampànà, Toto me Enusaho, toto komo wya, anhà komo wya, kahra kat nehxakonà, owyanye. Yahkotohen hona tamoyathosom me naha hampànà, kahra kat nehxakonà. Osorwawo ro enmahàtxhe, nasanàmyaha harha hampànà, àwayehxemo kom waye, kahra kat nehxakonà, owyanye. Muhutwahkahyatxok katà, ketxkon hatà, asakon komo, woràskomo komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Àro ke, Txesusu rwonàmàthàràtho hutwatxownà harha tà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Taa. Àsnye ro totxownà harha tà, woràskomo komo. Txesus yakoronotho komo hyaka totxownà hatà. Omeroro nekarymatxehkatxownà hatà, àwyanye, 11 komo wya, akoron komo wya xarha, omeroron komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Woràskomo rye mokyam nehxatxkon hatà, ekarymany komo. Anaro Maryeya hatà, Maknara honotho rma hatà. Anaro xarha Xoana hatà. Anaro xarha Maryeya rma rha hatà. Txaku yonà rma noro hatà. Anar komo xarha, wosà rye rma mokyam nehxatxkon hatà. Maryeya yakoron komo rma nyamoro hatà. Nekarymatxehkatxownà hatà, 11 komo wya, Txesusu nànyaknyàr komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Àro wyaro hamà kahra mak nehxatxkon hatà, 11 komo. Yaworohra màketxow hamà, ketxkon mak hatà. Àtohnawo rma haxa orwonatxow hamà, ketxkon hatà, 11 komo, woràskomo komo wya. Txesusu yasanàmàthàr hoko, yaworo xaxa nay hamà, kahra nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Petru haxa ryhe toy hatà, onamno ytxoho na. Karyhe toy hatà. Àhotawo newanay hatà, ewtar yaka tàwya xenytxoho me. Womutho marma yonyey hatà. Ekehàthàrà ehxera mak nehxakon hatà. Àro ke noseryehokekon hatà. Toseryehokanàr me rma toy hatà, bàn yaka harha, àsok tawro harha tawro me hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Àro rma ho owto txko hona tetxkon hatà, toto komo, asako. Txesus yakoronotho kukur komo rma mokyam nehxatxkon hatà. Emaws hona tetxkon hatà, owto txko hona. Xerusaryen hoye moxe nyhe nay hatà, Emawsà. 11 kerometrus me nay hatà, àmoxenonà. Àsna rma tetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Asama yarye tàtonàr kom me nosonytxetxkon hatà. Txesusu wayhàthàr hoko nosonytxetxkon hatà, asanàmàthàrà yokarymatxho hoko xarha hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Àro wyaro osonytxantokonye rma, hahnohtxownà hatà, Txesusu. Asama yarye toy hatà, akoronye. ");
INSERT INTO hixNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Txesus me noro yonyhera mak nehxatxkon hatà. Anar me tonyxem me nehxakon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Eten kom hoko mosonytxetxow harha, kekon hatà, Txesusu, àwyanye. Eten kom hoko mosonytxetxow harha, otonàr kom me, kekon hatà. Kràk, horohtxownà hatà. Ekhokaxaho rma yonytxownà hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Neyukye hatà, anaro. Kàryeyopasà rma noro hatà. Onà wyaro nkekon hatà, Txesusu wya. Eten kom hok hana amna nosonytxan ha, kekon hatà. Eten kom hana kohoryatxok ha, Xerusaryen ho. Àro kom hoko rma amna nosonytxano. Enytxahra manaye, kekon hatà. Omeroron komo rma nenytxetxok hamà. Xerusaryen hona omohxemo komo xarha nenytxetxoko, tokarymaxem me rma haxa esnàr ke. Omoro marma enytxahra manay hamà, kekon hatà, Kàryeyopasà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Eten kom hoko rma àro wyaro màken harha, kekon hatà, Txesusu, àwyanye. Txesusu yexetxhàràtho hoko ryhe àro wyaro amna nkehe, ketxkon hatà, àwya. Nasarye honotho rma noro ha. Khoryenkomo rwonà yokarymanye ro me nehxakonà. Ehonomnà me rma haxa nehxakonà, Khoryenkomo wya, toto komo wya xarha, ketxkon hatà. Ehonomnà me rma eryehokano yeryakonà. Hananàhno yeryakon xarha, ehonomnà me rma rha, ketxkon hatà, Kàryeyopas komo. ");
INSERT INTO hixNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Norotho rma yahohsetxoko, Peratusu wya, Khoryenkom màn yonye ro yoh komo, horykomo komo xarha. Nahohsetxoko, àwya twayehkahorye naha tawro horà, ketxkon hatà. Yahkotohen hona namoyathohetxoko, àwya, ketxkon hatà, Kàryeyopas komo. ");
INSERT INTO hixNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Amna ryhe, Khoryenkomo nànyaketxho me noro amna nenyaknan haryhe. Ehsayewyana komo yonyhoryeny me noro amna nenyaknan haryhe, ketxkon hatà. Onà wyaro xarha amna nkehe, owya. Osorwawo ro nenmahyako, àwayhàtxhe, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Amna yeryehokatxowà rma haxa mak ha, amna wosàn komo. Enmahrà ro totxow hatà, onamno ytxoho na, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ekehàthàr yonyhera mak nahtxok hatà. Ehxera harha nahko hatà, ketxkon hatà. Àro ke ekarymaxe nomohtxow harha, amna hyaka. Kahe yawon komo ryhe amna nenyo, katxow xarha, amna wya. Tonyxerye harha naha, Txesusu, katxow hatà, kahe yawon komo, àwyanye, ketxkon hatà, Kàryeyopas komo. ");
INSERT INTO hixNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Àro ke totxowà, amna kukur komo xarha, onamno ytxoho na. Woràskomo komo rwonàmàthàràtho yawo ro nenytxow hatà. Txesusu yonyhera rma nahtxok hatà, ketxkon hatà, Kàryeyopas komo, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Onà wyaro haxa nkekon hatà, Txesusu, àwyanye. Tàywenyeke manatxow hamà, kekon hatà. Akàhpàra rma manatxow hamà. Thenyehra rma haxa nmenhotxownà hatà, Kryestu hoko, amnyehran heno komo, Khoryenkomo rwonà yokarymanye ro heno komo. Uhutwahra mak manatxow hamà, kekon hatà. Noro hoko yaworo xaxa nay hamà, ànmenhothàyamo, kahra mak manatxow hamà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Teryewhamnohsom me xaxa mpànà nehxak ha, Kryestu, ehonomnà me harha tehtxoho me. Àro wyaro xaxa mpànà nehxak ha, nyamoro heno nmenhotho yawo ro tehtxoho me, kekon hatà, Txesusu, Kàryeyopas komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Àtoko rma Khoryenkom karyehtanà hutwamohsoy hatà, àwyanye. Thoko rma àmenhosahonhàrà rma hutwamohsoy hatà. Moyses heno nmenhotho htxero hutwamohsoy hatà, àwyanye. Khoryenkomo rwonà yokarymanye ro heno komo nmenhotho xarha hutwamohsoy hatà. Thoko rma ànmenhothàyamo hutwamohsotàhkay hatà, Txesusu, omeroro, Kàryeyopas komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Taa. Owto txko hahnohtxownà haxa hatà. Àsna àpa katxhàrà rma hahnohtxownà hatà. Txesusu ryhe, tàtosom me rma nehxakon hatà. Oknompàn me nenyatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Àro ke, onà wyaro nketxkon hatà, àwya. Tano rma exko, amna hyawo, ketxkon hatà, teryewrye ro hatà. Kokmamno hawe. Àro ke tano rma exko, amna hyawo, awanaka rma haxa esnàr ke, ketxkon hatà, àwya. Àro ke, àmàn kom yaka toy hatà, Txesusu, àhyawonye rma tesnàr horà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Akoronye nasahxemtoy hatà. Noro ryhe, ekeyu yanàmye hatà, tasahxemtontokonye. Àro hoko nàrwonàmye hatà, Khoryenkom yakoro. Nowye hatà. Nekamye hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Àtoko rma Txesus me harha nenytxownà hatà, Kàryeyopas komo. Nosomtatkay mak hatà, noro ha. Noro yonyhera harha nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Àsok hana tahko ha, ketxkon hatà, tàwyanye rma. Teryehorye rma haxa tahko hamà, kàwya noro yonytxantoko. Asama yarye komoknàtoko, teryehorye rma haxa tahko, àwya Khoryenkom karyehtanà hutwamohsontoko. Teryewrye ro rma haxa nahko, keryehotatho, kàhnawo, weheto noruknutokono wyaro mak ha, ketxkon hatà, Kàryeyopas komo, tàwyanye rma. ");
INSERT INTO hixNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Amamehra nasanàmtxownà hatà. Xerusaryen hona harha totxownà hatà. Àto nehxatxkon hatà, 11 komo, akoron komo xarha. Ohsamnohxemo komo rma yonytxownà hatà, Kàryeyopas komo. ");
INSERT INTO hixNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Onà wyaro nketxkon hatà, àton komo. Kohkomo nasanàmno hamà, àwayehxemo kom waye, ketxkon hatà. Yaworo xaxa nay hamà. Nosonyhon hatà, Semawu wya, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kàryeyopas kom haka rha nekarymatxownà hatà, àton komo wya. Asama yarye tàtothàyamotho yokarymatxownà hatà. Nekarymatxehkatxownà hatà, àwyanye. Àwya ekeyu yownàtoko ryhe, Kohkom me harha amna nenyo, ketxkon xarha tà, Kàryeyopas komo, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Àro wyaro Kàryeyopas komo wya ekarymantoko rma, Txesusu ryhe nosonyhoy hatà, àton komo wya, omeroron komo wya. Àwawony harha nehxakon hatà. Teryehorye hak nahko, oyowan komo, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Noskatokatxownà mak hatà, nyamoro ha, thenyehra rma haxa mak hatà. Mokro ymo ha okatonho, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Àsok tawro moseryehtxow harha, rohona, kekon hatà, Txesusu, àwyanye. Àsok tawro rohutwahra manatxow harha. Àsok tawro, Txesus me mokro naye, okatonho me haxa kat naye, màketxow harha, ohnawonye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xenytxoko, ramorà, rohrorà xarha. Uro ryhe uro, kekon hatà. Uro ahetxoko, owyanye noro moson hamà katxho me, kekon hatà. Okatonho ehàmra nay hamà. Àyotxehpàra nay hamà. Uro ryhe, tuhnye wehxaha. Tàyotxehke xarha wehxaha, kekon hatà, Txesusu, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Àro wyaro tàwya katxhe rma, tamorà yonyhoy hatà, àwyanye. Tàhrorà xarha yonyhoy hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Noro me naye, ketxkonà rma hatà. Ameryekahra mak àro wyaro nketxkon hatà. Teryehorye tehtxoho kom hoye ro haxa ryhe, noro me naye ketxkon hatà. Àsok tawro harha, ketxkon xarha tà. Àro ke, onà wyaro nkekon hatà, Txesusu, àwyanye. Woto ehxera naye, ohyawonye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kana hoye nàmtxownà hatà, àwya. Etxesaho rma yàmtxownà hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nahosày hatà, Txesusu. Nonoy hatà, àyweroronye. ");
INSERT INTO hixNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Taa. Onà wyaro nkekon xarha tà, Txesusu, àwyanye. Amnyehra, ohyawonye rma hak ryehtoko, koskarymekonà, owyanye, kekon hatà. Onà wyaro rma àkekonà. Rohoko àmenhosahonhàr yawo ro rma haxa wehxaha hampànà, àkekonà, owyanye, kekon hatà. Moyses heno nmenhotho yawo ro wehxaha hampànà, àkekonà. Khoryenkomo rwonà yokarymanye ro heno komo nmenhotho yawo ro xarha wehxaha hampànà, àkekonà. Wano komo karyehtan yawo ro xarha wehxaha hampànà, àkekonà, owyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Àro wyaro tàwya katxhe rma, àmenhosahonhàrà hutwamohsoy hatà, àwyanye, enkukmahrany harha ehtxoho me. Khoryenkom karyehtanà rma hutwamohsoy hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Onà wyaro katxho me rma naha, àmenhosahonhàrà, kekon hatà, àwyanye. Teryewhamnohsom me naha hampànà, Kryestu, katxho me rma naha. Osorwawo ro enmahàtxhe, nasanàmyaha harha hampànà, àwayehxemo kom waye, katxho me xarha naha, àmenhosahonhàrà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tokarymaxem me naha hampànà, Kryestu, katxho me xarha naha. Xerusaryen hon komo htxero nenytxetxhe hampànà, katxho me xarha naha. Anaro rha yana komo xarha, omeroron komo, nenytxetxhe hampànà, katxho me xarha naha, àmenhosahonhàrà, kekon hatà. Anar me harha ayanhànàthàyamo xenytxoko ketxhe hampànà, ekarymany komo, toto komo wya, katxho me xarha naha. Noseryewhokehe, Khoryenkomo, ayanhànàthàyam hoko, ketxhe hampànà, katxho me xarha naha. Àro wyaro amna nkehe, owyanye, Kryestu yano me mak ha, ketxhe hampànà, ekarymany komo, toto komo wya, omeroron komo wya, katxho me xarha naha, àmenhosahonhàrà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Àro wyaro àmenhosahonhàr yawo ro ryehtxoho menyatxoko, omnyamo. Àro ke mekarymetxhe hampànà, onenyetxhàyamo, toto komo wya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Uro ryhe, royàm nàmrà ànyakyaha hampànà, ohyakanye. Rokato wàmyaha, toto komo wya, kanyenhàr me naha, royàmà. Ànàmrà rma ànyakyaha, ohyakanye, kekon hatà. Noro yomokhàra ro rma haka tano rma hak ehtxoko, Xerusaryen ho rma haka. Kahe yaye tomohsomà rma, tahoxerye rma haxa mpànà oyeryatxhe ha, ohnawonye, kekon hatà, Txesusu, tànhananàhrà rotho komo wya. ");
INSERT INTO hixNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Taa. Xerusaryen hoye natxownà hatà, Txesusu. Betanya màtkoso natxownà hatà. Àto tehtoko, natahoyotkay hatà. Khoryenkom hak oyowakryetxowà, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Àro wyaro tàwya tatoko rma, àhyayenye toy hatà, Txesusu. Nasanàmye hatà, kahe yaka. ");
INSERT INTO hixNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Onà wyaro nketxkon hatà, ànhananàhrà rotho komo. Ehonomnà me xaxa nay hamà, Txesusu, ketxkon hatà. Taa. Xerusaryen hona harha totxownà hatà, Txesusu nhananàhrà rotho komo. Teryehorye rma haxa nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Emahona ro Khoryenkom màn yawo nehxatxkon hatà. Apa y, ohxe xaxa manaha, ketxkonà roro hatà, Khoryenkomo wya.");
INSERT INTO hixNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Khoryenkomo yehutwatxho yokarymanye mosonà katxho ryhe, amnyehra rma haxa nehxakonà, akàhtono yhera ro rma haka. Noro rma, àto rye rma nehxatxkonà, Khoryenkom yakoro. Khoryenkom me rma nehxakonà. ");
INSERT INTO hixNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Noro ryhe, Khoryenkom yakoro nehxakonà, akàhtono yhera ro rma haka. ");
INSERT INTO hixNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Akàhtono yeryeye, omeroro mak ha. Noro nakàhtohtorà ehxera ro mak naha. ");
INSERT INTO hixNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tano me ro rma karyhe naha, noro ha. Karyhe kehtxoho komo xarha, noro yano me rma rha naha. Kawasmeny kom me naha. ");
INSERT INTO hixNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Awaràn wawo kehtokonye, kawasmetxow hamà, awasànà. Àro wyaro rma rha, yaworon xaxa hutwamohsehe, noro, kàwyanye, anhàtho komo wya. Noro yarymahra ro mak naha ha, anhà. ");
INSERT INTO hixNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Toto nyakye, Khoryenkomo. Xowawu noro ha, toto yosotà. ");
INSERT INTO hixNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Noro rma, kawasmeny komo yokarymaxe nomokye. Yaworon xaxa hutwamohsonye rma yokarymaxe nomokye, toto komo wya noro hona xenytxoho me. Xowawu wya ekarymatxho hoye ro ryhe, noro hona nenyatxow hamà, toto komo, omeroro. ");
INSERT INTO hixNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Kawasmeny kom mehra mak nehxakonà, Xowawu. Noro yokarymax haxa ryhe nomokye. ");
INSERT INTO hixNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yukryeka hona nomokye, kawasmeny komo, yaworon xaxa. Omeroron komo yawasmeny me rma naha, noro ha. ");
INSERT INTO hixNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yukryeka ho harha nehxakonà. Noro rma, yukryeka yakàhtoye. Noro hutwahra mak nehxatxkonà, yukryeka hon komo. ");
INSERT INTO hixNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tànakàhtothàrà hona nomokye. Xuknewyana kom yowto hona ryhe nomokye. Noro yahohsàra mak nehxatxkonà, nyamoro, ukukuru komo rma. ");
INSERT INTO hixNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Yakenohnà kom marma, noro yahohtxownà. Noro hona harha nenytxownà. Nyamoro wya ryhe, onà wyaro nkekonà. Omnyamo ryhe, Khoryenkom hokru me harha manatxhe, kekonà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nyamoro rma nenutxownà harha. Toto yano mehra nenutxownà harha, thoryen heno kom yano mehra mak ha, toto hun yano mehra mak ha. Khoryenkom yano me haxa ryhe nenutxownà harha, ekato me, noro hokru me harha. ");
INSERT INTO hixNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Khoryenkomo yehutwatxho yokarymanye mosonà katxho rma, toto me harha natakàhtoye. Tan hak nehxakonà, kwawonye. Towahke rma haxa nehxakonà. Yaworon me rma haxa nehxakonà. Ehonomnà me xaxa ryhe noro yonyatxkon hatà, akorono ro komo. Àsok hana ehonomnà me nehxakon ha. Tàyàm muru ro me ehonomnà me xaxa nehxakon hatà, àyweroronye. ");
INSERT INTO hixNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Noro hoko rma, onà wyaro nkekon hatà, Xowawu, teryewrye ro hatà. Noro mokro ha kekon hatà, toto komo wya. Noro ryhe wekarymeknano, owyanye. Nomokyaha, anaro, rohryetayo, àkeknano, owyanye. Noro rma, roho rma haxa naha, àsok tawro hana, ronurhura ro rma haka tehxemà ro me tesnàr ke, àkeknano, kekon hatà, Xowawu, toto komo wya. ");
INSERT INTO hixNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Towahke rma haxa tehtxoho hoye ro kowakryetxownà, noro ha. Kowakryetxhe rye rma haxa. ");
INSERT INTO hixNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moyses heno wya ryhe kàyweronàhyamahotxownà, Khoryenkomo. Txesusu Kryestu wya haxa ryhe kowakryetxehkahotxownà. Noro ryhe, kowakryenye ro kom me naha. Yaworon xaxa yokarymanye ro me naha. ");
INSERT INTO hixNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Khoryenkomo yony komo ehxera ro mak naha, toto. Umuru haxa ryhe, hutwamohsoye, kàwyanye. Tàyàm muru ro rma noro ha, tàyàm nàhnànà txko. ");
INSERT INTO hixNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tkukur komo nyahtxownà hatà, Xuknewyana yoh komo, Xowawu hyaka. Khoryenkom màn yonye ro kukuru komo rma nyahtxownà hatà. Nyamoro yakoronomanye ro kukuru komo xarha nyahtxownà hatà, Ryefeta kukuru komo rma hatà. Xerusaryen hoye totxownà hatà, Xowawu hyaka. Onok omoro kaxe ànyahxemo komo rma nyamoro hatà. Àro ke noskarymay hatà, noro, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yaworo noskarymay hatà. Oskarymahra wehxan hamà, moxamo wya, kahra mak nehxakon hatà. Onà wyaro haxa noskarymay hatà, ànyahxemo komo wya. Kryestu mehra wehxaha, kekon hatà, àwyanye. Nomokyaha hampànà, Kryestu, Khoryenkomo nànyaketxho, katxhàrànhàr mehra wehxaha, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Onok me haxa manaye, ketxkon hatà. Onok me haxa manaye. Eryeyas haxa omoro. Nomokyan harha tà, noro heno. Norohnà katà omoro, ketxkon hatà. Norohnà mat uro, kekon hatà. Khoryenkomo rwonà yokarymanye ro haxa omoro, ketxkon hatà. Tomohsom me nay hatà, noro, Moyses heno nekarymatxho rma. Norohnà katà omoro, ketxkon hatà. Norohnà mat uro kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Onokà ryhe omoro, ketxkon hatà. Onokà ryhe omoro. Amna nyaknyenhàr komo yoyuknuru xe amna naha. Àro ke oskarymako, amna wya eyuhtoho menye, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Esaeyas heno nmenhothàrànhàr yawo ron uro, kekon hatà, Xowawu. Onà wyaro nkehe hampànà, ahehnawono, teryewrye ro, katxhàrànhàrà rma uro. Kohkomo ryhe nomokyan hatà, àro ke osonyhoryetxoko, kehe hampànà, toto komo wya, katxhàrànhàrà rma uro, kekon hatà. Rohoko ryhe, àro wyaro nkekonà, Esaeyas heno, Khoryenkomo rwonà yokarymanye ro heno, kekon hatà, Xowawu, ànyahxemo komo wya. ");
INSERT INTO hixNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Farysew komo nànyaketxhàyamo rma nyamoro hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Onà wyaro nketxkon xarha tà, àwya. Aymomno ynyàr hoko tehxoryehra manaha, ketxkon hatà. Kryestu mehra oyehtoko, àro hoko tehxoryehra manaha. Eryeyas heno mehra oyehtoko, Khoryenkomo rwonà yokarymanye ro mehra oyehtoko, aymomno ynyàr hoko tehxoryehra manaha. Àsok tawro aymomno meryan harha, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Onà wyaro neyuhtxownà hatà, Xowawu. Uro ryhe, tuna kwaka aymomno weryaha, kekon hatà. Awawonye naha, anaro. Noro hutwahra mak manatxhe. ");
INSERT INTO hixNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Rohryetayo ryhe noro. Àhrorà womun yasotà wompokahra wehxaha, esnaka rma haxa ryesnàr ke, kekon hatà, Xowawu, ànyahxemo komo wya. ");
INSERT INTO hixNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betanya ho tehtoko, àro wyaro nkekon hatà, àwyanye, Xoknaw mon ho tehtok hatà. Àto rma aymomno ryakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Enmahàtxhe, Txesusu yonyey hatà, Xowawu. Tàhyaka omoknàrà rma yonyey hatà. Àro ke, onà wyaro nkekon hatà, toto komo wya. Mokro ha, kekon hatà. Kahneru mxekrà wyarono mokro, totahaxem me tesnàr ke. Totahaxem me ehxe Khoryenkomo nànyaketxho rma mokro. Noro rma, toto komo yanhànàtho yownye me naha, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Noro ryhe wekarymeknano, owyanye. Nomokyaha, anaro, rohryetayo, àkeknano, owyanye. Noro rma, roho rma haxa naha, àsok tawro hana, ronurhura ro rma haka tehxemà ro me tesnàr ke, àkeknano, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Uro ryhe, noro hutwahra hak wehxakonà. Noro hutwamohsoso ryhe komokye, ronyaknyenhàr yano me. Tuna kwaka aymomno yxe komokye, toto komo wya noro hutwatxho me, Ehsayewyana komo wya noro mok hamà katxho me, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tànenyetxhàrà xarha yokarymay hatà. Khoryenkom yokato wenyako, kekon hatà. Watkuk me nehxako, ronenyàr me. Kahe yaye nàhteko, noro hona. Noro ho rma nehxaknano, mexe nyhe txko, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Noro hutwahra ehxahonhàrà rma uro. Onà wyaro kanyenhàr me mak nehxakonà, ronyaknyenhàrà. Amnye toto hona rokato htonàrà menyaha hampànà, noro ho rma naha hampànà, kanyenhàr me nehxakonà, rowya. Noro ryhe, anar me aymomno yeryaha hampànà, rokato nyakyaha hampànà, toto kom hona, aymomtoho komo rma àro ha, noro wya, kanyenhàr me nehxakonà, ronyaknyenhàrà, tuna kwaka aymomno yxe ronyaknyenhàrà rma, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Àrwonàmàthàrà yawo ro rma wenyako. Àro ke, noro hutwany me harha wehxaha. Khoryenkom muru moson hamà kany me harha wehxaha, owyanye. ");
INSERT INTO hixNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Sa, nenmahye xarha tà. Àto nehxakon hatà, Xowawu, thataw hatà. Àhyawo nehxatxkon hatà, ànhananàhrà ro komo, asako. ");
INSERT INTO hixNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Àhyahanye tekon hatà, Txesusu. Tàwya noro yonyetxhe, onà wyaro nkekon hatà, Xowawu. Mokro ha, kekon hatà. Kahneru mxekrà wyarono mokro, totahaxem me tesnàr ke. Totahaxem me ehxe Khoryenkomo nànyaketxho rma mokro, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Àro wyaro tàwyanye enytxatxhe rma, Txesus yakoro totxownà hatà, Xowawu nhananàhrà rotho komo, asakon komo rma. ");
INSERT INTO hixNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Neramay hatà, Txesusu. Takoro omoknàr komo yonyey hatà. Eten horà momokyatxowà, kekon hatà, àwyanye. Eten horà momokyatxowà. Hakme y, ketxkon hatà, àwya. Hakme y katxho rma, Khananàhnye y katxho me rma naha. Hakme y, henta oyonmahyano, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Omohtxoko, xenyxe, kekon hatà, Txesusu, àwyanye. Àro ke totxownà hatà. Txesus mànà yonytxownà hatà. Enmahrà ro rma nehxakon hatà, 10 oras me ehtok hatà. Àro ke, awasnawo rma hak nehxatxkon hatà, noro hyawo. ");
INSERT INTO hixNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Asakono rma nyamoro hatà, Txesus yakoro àtoxemo rma hatà, Xowaw yonytxanyenhàyamo rma hatà. Antrye rma anaro hatà. Noro rma, Semaw Petru yowtà me nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Amamehra toy hatà, towtà horà, Semaw horà. Nehorày haxa hatà. Meseyasà ryhe amna nenyo, kekon hatà, àwya. Meseyasà katxho rma, Kryestu katxho me rma naha, Khoryenkomo nànyaketxho katxho me rma naha. Meseyasà ryhe amna nenyo, kekon hatà, Antrye, towtà wya. ");
INSERT INTO hixNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Narày hatà, Txesusu hyaka. Txesusu nenyey hatà. Semawu omoro hamà, kekon hatà. Xowaw muru rma omoro hamà. Sefas me harha kosohtehe, kekon hatà, Txesusu, àwya. Sefas katxho rma, Petru katxho me rma naha. ");
INSERT INTO hixNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sa, nenmahye xarha tà. Nehutway hatà, Txesusu. Karyeryeya yamtar hona àten hamà, kekon hatà, tàwya rma. Tàtohra ro rma haka Feryepe yohorày hatà. Rakoro omok ha, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsayda hon me nehxakon hatà, Feryepe. Àro hon me rma rha nehxatxkon hatà, Antrye komo, Petru xarha. ");
INSERT INTO hixNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Taa. Natanayew yohorày hatà, Feryepe. Moyses heno nekarymatxho ryhe amna nenyo, kekon hatà, àwya. Noro heno wya kàyweronàhyamatxho kom yawono ryhe amna nenyo. Khoryenkomo rwonà yokarymanye ro heno komo nmenhotho yawono ryhe amna nenyo, kekon hatà. Txesusu ryhe noro hamà. Nasarye honotho rma, Xose murunho rma noro hamà, kekon hatà, Feryepe. ");
INSERT INTO hixNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Àna matà, kekon mak hatà, Natanayew, àwya. Enyhoru komo ehxera ro mak naha ha, Nasarye hon komo, kekon hatà. Omok ha xenyxe kekon hatà, Feryepe, àwya. Àro ke toy hatà, Natanayew. ");
INSERT INTO hixNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tàhyaka omoknàrà yonyey hatà, Txesusu. Xenytxoko, mokro ha, kekon hatà, àton komo wya. Ehsayewyana me nay hamà, mokro. Ehsayewyana rma, yaworon me xaxa naha. Àtemarontahnà ro me naha, kekon hatà, Txesusu, Natanayew hoko. ");
INSERT INTO hixNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Àsoke ryhe uro muhutweno, kekon hatà, noro, àwya. Àsoke ryhe uro muhutweno. Onà wyaro neyukye hatà, Txesusu. Feryepe wya oyokhàra ro rma haka konyo, kekon hatà, àwya. Fek yoh yahomyawo rma oyehtoko, konyo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Khananàhnye y, kekon hatà, Natanayew, àwya. Khoryenkom muru omoro hamà. Ehsayewyana komo kayaryetà omoro hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Onà wyaro neyukye hatà, Txesusu. Rohona menyan hamà, kekon hatà, àwya. Fek yoh yahomyawo oyehtoko konyo àkan marma, owya. Àro hoye ro marma, rohona menyan hamà. Àro yohono rma haxa menyaha hampànà, amnye, ehonomnà me xaxa owya ronytxoho me, kekon hatà, Natanayewu wya. ");
INSERT INTO hixNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Onà wyaro yaworo xaxa mpànà àkehe ha, owyanye. Kahe yatahurmakanàrà menyatxhe hampànà, kekon hatà. Kahe yawon komo menyatxhe hampànà. Khoryenkom yanoto komo rma menyatxhe hampànà. Asanàmrà komo, àhtonàr komo xarha, menyatxhe hampànà, kekon hatà. Toto me Enusah hoye nasanàmyatxhe hampànà. Noro hona nàhtetxhe xarha hampànà, onenyàr kom me, kekon hatà, Txesusu, Natanayewu wya, àton komo wya xarha. ");
INSERT INTO hixNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Asako ro enmahàtxhe, Kana ho harha nehxakon hatà, Txesusu. Karyeryeya yamtar hono rma àro ha, owto txko, Kana. Àton komo nasahxemtotxownà hatà, toto hehtatho hoko. Àhyawonye nehxakon hatà, Txesus yonà. ");
INSERT INTO hixNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Asahxemtoso anyehxah me rma rha nehxatxkon hatà, Txesus komo, ànhananàhrà ro kom yakoro xarha. ");
INSERT INTO hixNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Asahxemtontokonye, nenatày hatà, ufa xkunutho. Ehxera harha nehxakon hatà. Àro ke nekarymay hatà, àyonà, Txesusu wya. Àwokuthuyamo ehxera harha nay hatà, kekon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Eme y, kekon hatà, Txesusu. Àsok tawro mekarymen harha, rowya. Àhoko ryehtxoho mehra rma hak naha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Onà wyaro haxa nkekon hatà, àyonà, anotonano komo wya. Àsok kom hana nken ha, noro ha, owyanye, kekon hatà. Àwya onà wyaro ehtxoko katxhe rma, noro eyuhtxoko, kekon hatà, Txesus yonà, anotonano komo wya. ");
INSERT INTO hixNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Àto nehxakon hatà, oryenà ymo, toh kahsaho ymo. Àyakenonà rma, 6 me nehxakon hatà. Tuna yonà rma àro hatà, Xuknewyana komo yosomyakorokatxho rma hatà, tàyweronàhyamatxhàyamotho yawo ro osonyhoryetxho komo rma hatà. Àsok hana nehxakon ha, aràhtotho ha, 80 tutum hana, 120 tutum haxa hana. ");
INSERT INTO hixNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Àro hoko rma, onà wyaro nkekon hatà, Txesusu, anotonano komo wya. Tuna ke aràhtotàhkatxoko moro ymo, oryenà ymo, kekon hatà. Àro ke naràhtotàhkatxownà hatà, àhotaha ro rma haxa mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Àhoye rma anàmtxok ha, kekon hatà, àwyanye. Atxoko, àmàtànà hyaka, kekon hatà. Àro ke natxownà hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tuna me ehxahotho kukmay hatà, àmàtànà. Ufa xkun me harha nehxakon hatà. Tuna me exetxhàràtho hutwahra nehxakon hatà, noro. Anoto kom marma nhutwetxkon hatà, anàmnyenhàyam kaxe. Noro haxa ryhe, uhutwahra nehxakon hatà. Àro ke, thehtaxemà yanyekye hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Onà wyaro nkekon hatà, àwya. Ohxe rma haxa nay hamà, onà, kwokru komo, kekon hatà. Tasahxemtontokonye, wahoro htxero tukhoryemà yokamyatxow hamà, toto komo. Mahtuk me, àwahuramàtxhenye, àkhohnàtho harha yokamyatxhe, kekon hatà. Àro wyaro natxow hamà, toto komo, omeroro, tasahxemtontokonye. Omoro haxa ryhe, tukhoryem xaxa menhon hamà, mahtuk me. Àsok tawro hana. Ohxe rma haxa nay hamà, onà, ufa xkunu, anarotho yoho rma haxa mak ha, kekon hatà, àmàtànà, thehtaxemà wya. ");
INSERT INTO hixNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Àro wyaro htxero tahoxetà yonyhoy hatà, Txesusu, toto komo wya, Kana ho tehtok hatà, Karyeryeya yamtar hono rma ho tehtok hatà. Àro wyaro rma ehonomnà me xaxa nosonyhoy hatà. Àro ke, onà wyaro nketxkon hatà, ànhananàhrà ro komo. Noro mokro hamà, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Àro tàhto rma toy hatà, Txesusu, Kafahnaw hona. Akoro totxownà hatà, àyon komo, ewtà komo xarha, ànhananàhrà ro komo xarha. Kafahnaw ho nenmahtxownà hatà, yake rohra hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Taa. Xuknewyana komo yasahxemtotho hahnoke nehxakon hatà. Thoryen heno komo yohokoko àtothàrànhàrà hutwatxho rma àro hatà, asahxemtotho komo. Àtoko rma toy hatà, Txesusu, Xerusaryen hona. ");
INSERT INTO hixNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Khoryenkom màn yawo nehxatxkon hatà, twarawantaxemà ro komo. Faka yàmnye ro komo nyamoro hatà, kahneru yàmnye ro komo xarha hatà, watkuku yàmnye ro komo xarha hatà. Àto rma rha nehxatxkon hatà, txenyeru yomtakayonomanye ro komo xarha, tahon kom ho eryewtaxemo hatà. Omeroro nenytxownà hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Àro ke, otame màtmomye hatà, àhpohtxoho komo. Àro rma ke nukrunyemehtxownà hatà, Khoryenkom màn yaye. Omeroro nukrunyemehtxekatxownà hatà, kahneru kom hatà, faka xarha hatà, toto komo xarha hatà. Txenyerutho xarha hahye hatà. Tax, teryay, waratatho xarha matxakay hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Onà wyaro nkekon hatà, watkuku yàmnye ro komo wya. Moson atxok ha, kekon hatà. Moson atxok ha. Royàm màn yawo àwarawantahra ro mak ehtxoko, kekon hatà, àwyanye. ");
INSERT INTO hixNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nenytxownà hatà, Txesusu nhananàhrà ro komo. Àro ke, Khoryenkom karyehtan hoyeno hutwatxownà harha tà. Onà wyaro nkehe, àmenhosahonhàrà. Omàn xe rma haxa wehxaha. Ohxe esnàr xe ryehtxoho hoye ro, twayehkaxem me wehxaha hampànà. Àro wyaro rma nkehe, àmenhosahonhàrà. Àro wyaro katxhàrànhàrà rma hutwatxownà harha tà, Txesusu nhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Onà wyaro nketxkon hatà, àton kukuru komo, Xuknewyana yoh kukuru komo, Txesusu wya. Onok yano me mukrunyemehtxow harha, ketxkon hatà. Onok yano me mukrunyemehtxow harha. Noro yahoxetà xenyhoko, amna wya, ketxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Onà wyaro haxa neyuhtxownà hatà, Txesusu. Tarymatxehkaxem me hak nahko, onàtho, Khoryenkom mànàtho, kekon hatà. Atarymatxehkaxahotho rma weryaha harha. Osorwawo ro enmahàtxhe, weryaha harha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Àsok tawro harha, ketxkon hatà, Xuknewyana yoh komo. 46 me amna txemnyehàntaye, on yenyàr hoko, Khoryenkom màn yenyàr hoko. Àsok katà meryan harha, omoro, osorwawo ro enmahàtxhe, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Txesusu rwonà hutwahra mak nehxatxkon hatà. Tàwya Khoryenkom mànà tatoko rma, thoko rma nàrwonakon hatà, thun hoko rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Amnye hutwatxownà harha tà, ànhananàhrà ro komo, Txesusu wayhàtxhe mak hatà. Àwayehxemo kom waye asanàmàtxhe rma, àrwonàmàthàrànhàrà hutwatxownà harha tà. Onà wyaro katxownà harha tà. Thoko rma yaworo xaxa nkekon hamà, katxownà harha tà. Khoryenkom karyehtan hoyenotho txko hoko xarha, yaworo xaxa nken hamà, noro hoko, katxownà harha tà, ànhananàhrà ro komo. ");
INSERT INTO hixNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Xerusaryen ho roro rma nehxakon hatà, Txesusu, asahxemtontokonye rma haka. Thoryen heno komo yohokoko àtothàrànhàrà hutwatxho hoko ehtokonye rma haka, àto roro rma nehxakon hatà. Àto rma ehtoko, noro hona nenytxownà rma haryhe tà, toto komo, thenyenohnà komo, tàwyanye ahoxetà yonyàr ke mak hatà. Tahoxetà yonyhekon hatà, àwyanye, anaro rha eryehokano ytxoho hoko tesnàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ehutwamohsotàhkahra mak nehxakon hatà, àwyanye, ");
INSERT INTO hixNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","toto komo hutwatxehkanye ro kaxe. Toto yehtxoho ekarymako, rowya, kanyehnà ro me nehxakon hatà. Àsok tawro hana, toto yehutwatxho hutwanye ro me tesnàr ke hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Taa. Kohsaya toy hatà, horykomo, Txesusu hyaka. Nekoknemusu noro hatà, esotà. Farysew komo kukuru rma mok nehxakon hatà, Xuknewyana yoh komo kukuru rma hatà. Noro rma toy hatà, Txesusu hyaka, kohsaya hatà. Khananàhnye y, kekon hatà, àwya. Khoryenkomo nànyaketxho me manaha, amna wya. Noro yano me hananàhno ynye ro me manaha, amna wya, kekon hatà. Ayakoronomen hamà, Khoryenkomo. Àsok tawro hana, owya ayahoxetà yonyhonàr ke, anaro rha eryehokano ytxoho hoko oyesnàr ke. Ayakoronomahra noro yehtok haxa, àro hokohra oyesnàràtho haryhe mà, kekon hatà, Nekoknemusu. ");
INSERT INTO hixNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Onà wyaro neyukye hatà, Txesusu. Onà wyaro yaworo xaxa mpànà àkehe ha, owya, kekon hatà. Tonuhorye harha natxhe, toto komo, Khoryenkomo mryenon me harha tehtxoho menye. Enurhura tehtokonye, noro mryenon mehra ro mak natxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Àsok màken harha, kekon hatà, Nekoknemusu. Àsok màken harha. Horykomotho me kehtoko, enurhura harha tehxan hamà. Kyon yowan yaka atahohsàra harha tehxan hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Neyukye hatà, Txesusu. Onà wyaro yaworo xaxa mpànà àkehe ha, owya, kekon hatà. Tuna kwaka tataymomrà komo ke tonuhorye harha natxhe, toto komo, Khoryenkomo mryenon me harha tehtxoho menye. Khoryenkom yokato yano me tonuhorye harha natxhe, kekon hatà. Àro wyaro enurhura tehtokonye, noro mryenon mehra ro mak natxhe ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Oyon hokru me oyonutoho kom ho ye ro tuhnye manatxow hamà. Khoryenkom yokato yano me oyonutoho kom hoye ro haxa ryhe, ekato me karyhe manatxhe, ohnawonye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Àsok tawro harha kahra exko, rorwon hoko, tonuhorye harha manatxhe katxho hoko, kekon hatà, Txesusu, Nekoknemusu wya. ");
INSERT INTO hixNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Henta nyero nomokyano, atxowowo. Henta ya nteno. Uhutwahra manatxow hamà, kekon hatà. Tano me ro rma ten hamà. Fow tawro marma menytxetxhe. Àro wyaro rma rha, onhutwahtor kom me oyonuryatxhe harha, Khoryenkom yokato yano me mak ha, kekon hatà. Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Àsok tawro àro wyaro nay harha, kekon hatà, Nekoknemusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Uhutwahra manaye, kekon hatà, Txesusu. Ehsayewyana komo hananàhnye ro omoro hatà. Hananàhno ynye ro rma, uhutwahra rma manaye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Onà wyaro yaworo xaxa mpànà àkehe ha, owya. Amna nekarymanàrà ryhe, amna nhutwatxehkatxho me naha, kekon hatà. Amna nenyetxho me naha. Àro wyaro hamà kahra mak manatxhe, omnyamo, amna nekarymanàr hoko, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yukryeka ho oyehtxoho komo wekarymano, owyanye. Àro hoko rma, àro wyaro hamà kahra rma manatxhe, kekon hatà. Àro yonytxanyehnà rma, kahe yawo oyehtxoho komo yonytxahra rma rha manatxow hamà. Rowya ekarymantoko rma, àro wyaro hamà kahra rma rha manatxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kahe yawo oyehtxoho komo yokarymany komo ehxera ro mak naha ha. Àsok tawro hana. Kahe yaka asanàmxemo komo ehxera nay hamà, kekon hatà. Toto me Enusah haxa ryhe, kahe yawo ehxah me naha. Noro rma, nomokye, kahe yaye. Àro ke, kahe yawo oyehtxoho komo yokarymany me nay hamà, noro ha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ahehnawo toto heno komo yehtoko, okoye kuknonà yakryey hatà, Moyses heno. Àro wyaro rma rha, takryexem me naha hampànà, Toto me Enusaho, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Takryexem me naha hampànà, thona toto komo wya xenytxoho me. Noro hona xeny komo rma, karyhe roro harha natxhe hampànà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kxenye rma haxa nehxakon hamà, Khoryenkomo. Àro ke, buru ro txko yàmye. Towenyxanotho txko yàmye, àhona xenytxoho me, kàwyanye. Àhona xeny komo ryhe, àwayehpànà ro me natxhe ha. Karyhe roro harha natxhe ha. ");
INSERT INTO hixNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Àsok tawro hana buru nyakye ha. Yukryeka hona nànyakye hamà, kàhyakanye. Tanàhnohsom me manatxhe hampànà kaxehra nànyakye. Konyhoryexeny haxa ryhe nànyakye. ");
INSERT INTO hixNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Noro hona kàwya xenyetoko, tanàhnohsom me manatxhe hampànà katxho mehra harha tehxaha. Àhona xenyhera rma kehtok haxa, tanàhnohsom me manatxhe hampànà katxho me rma tehxaha. Àsok tawro hana, Khoryenkom muru hona xenyhera kesnàr ke, ànàhnànà txko hona xenyhera kesnàr ke. ");
INSERT INTO hixNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tanàhnohsom me natxow hamà, toto komo. Àsok tawro hana, atxke rma haxa tesnàr komo ke hamà. Yukryeka hona nomokye, kawasmeny komo, yaworon xaxa hutwamohsonye rma. Noro xehra mak nehxatxkonà, toto komo. Awaràn wawo roro tesnàr komo xe nehxatxkonà. Yaworon xaxa hutwanàr xehra mak nehxatxkonà. Awasàn ho harha tesnàr komo xehra ro mak nehxatxkonà, atxke rma haxa tesnàr komo ke. ");
INSERT INTO hixNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Àsok tawro hana. Kanhàn hoko kehtoko, awasànà xehra tehxan hamà. Kanhàn hutwamohsonye xehra tehxan hamà. Noro hyaka àtohra tehxan hamà. Noro hyaka tontok haxa, thutwaxem me harha kanhànàthàrà yesnàràtho haryhe mà. ");
INSERT INTO hixNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yaworo kehtok haxa ryhe, awasàn hona tàtehe. Yaworon xaxa hutwamohsonye hyaka rma tàtehe, yaworon me tonyxem me kesnàr horà, Khoryenkom yano me ohxe tonyxem me kesnàr horà. ");
INSERT INTO hixNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Taa. Xukneya yamtar hona toy hatà, Txesusu. Akoro rma totxownà hatà, ànhananàhrà ro komo. Mexe nyhe txko àto roro rma nehxatxkon hatà. Tuna kwaka aymomno yeryatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Xowaw xarha, aymomno yeryakonà rma hatà. Enon ho nehxakon hatà, noro, Saryen màhto rma hatà. Àto rma aymomno yeryakon hatà, tahtunye tuna yesnàr ke hatà. Àhyaka nomokyatxkon hatà, toto komo. Nataymompetxkon hatà, àwya. ");
INSERT INTO hixNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ahryempen me rma hak nehxakon hatà, Xowawu, watxa ymo yaka. ");
INSERT INTO hixNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Taa. Nosonytxetxkon hatà, Xowawu nhananàhrà ro komo, toto yakoro, Xuknewyana yakoro. Aymomno ytxoho hoko nosonytxetxkon hatà, Xuknewyana komo yosonyhoryetxho hoko rma hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Àro ke totxownà hatà, Xowawu hyaka. Khananàhnye y, ketxkon hatà, àwya. Aymomno yeryan hatà, mokà ymo, ohyawo ehxaho ymo. Xoknaw mon ho kehtokonye, ohyawo nehxaknano, ketxkon hatà. Noro yehtxoho mekarymeko, toto komo wya. Noro rma, tan harha nay hatà, aymomno ynyàr hok hatà. Omeroron komo tetxow hatà, àhyaka, ketxkon hatà. Omorohnà noro haxa hyaka tetxow hatà, àwya tataymomponàr kom horà, ketxkon hatà, ànhananàhrà ro komo, Xowawu wya. ");
INSERT INTO hixNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Neyuhtxownà hatà, noro. Àsok hana tehxan ha, ehonomnà me hana, ehonomnà mehra haxa hana, kekon hatà. Kahe yawono ryhe khutwehe. Noro yano me marma ehonomnà me xaxa tehxan hamà. Ehonomnà me hak nahko, mosonà, kahra haxa noro yehtoko, ehonomnà mehra rma tehxan hamà, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Omnyamo rma, roskarymanàrà menytxetxoko. Kryestu mehra wehxaha tawro menytxetxoko, rowya. Noro ywaho ànyahxah haxa uro tawro menytxetxoko, rowya, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Khehtantokonye, thehtaxemà ryhe thetxe yahohsan hamà, kekon xarha tà. Thehtaxem yanoto haxa ryhe, ahohsàra nay hamà. Noro ryhe, thehtaxemà rwonà yonytxehe. Àro ke, teryehorye rma haxa naha, tàwya enytxanàr ke mak ha, anoto me tesnàr ke mak ha, kekon hatà. Àro wyaro rma rha, teryehorye rma haxa wehxaha, tano noro yesnàr ke mak ha. ");
INSERT INTO hixNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ehonomnà me nyhe hak nahko, noro ha. Urotho haxa, esnaka hak wehxe, kekon hatà, Xowawu. ");
INSERT INTO hixNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Kahe yaye omohsaho ryhe, omeroron komo yoho rma haxa naha. Yukryeka hon komo ryhe, yukryeka ho tehxem kom marma hutwetxow hamà. Àro kom hok marma nàrwonatxow hamà. Kahe yaye omohsah haxa ryhe, yukryeka hona omohsaho rma, omeroron komo yoho rma haxa naha. ");
INSERT INTO hixNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Noro rma, omeroro nekarymekon hatà. Kahe yawo tànenyetxhàrà rma yokarymekon hatà. Kahe yawo tànenytxatxhàrà xarha yokarymekon hatà. Noro yonytxahra mak nehxatxkon hatà, toto komo. Àro wyaro hamà kahra mak nehxatxkon hatà, noro nekarymatxho hoko. ");
INSERT INTO hixNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ohxe enytxany kom haxa ryhe, onà wyaro kany me rma nehxatxkon hamà. Àro wyaro hamà, yaworon me xaxa nay hamà, Khoryenkomo, kany me nehxatxkon hamà. ");
INSERT INTO hixNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Khoryenkomo rwonà yokarymekon hamà, noro, Khoryenkomo nànyaketxho rma. Àsok tawro hana. Tokato rma yàmtàhkay hamà, Khoryenkomo, àwya. Rokato hoye wàmyaha, àwya, kahra mak nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Buru xe rma haxa nay hamà, noro, àyàmà. Àro ke, omeroron kom yoh me neryeye. ");
INSERT INTO hixNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Khoryenkom muru hona xeny komo ryhe, karyhe roro harha natxhe. Noro yoyuknyehnà kom haxa ryhe, karyhe roro harha manatxhe katxho mehra ro mak natxhe ha. Nyamoro hoko ewakhàra roro rma naha, Khoryenkomo, anàhnohtàkanàr kom horà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Txesus yokaytà yonytxatxownà hatà, Farysew komo. Thenyehra rma haxa natxow hamà, Txesusu nhananàhrà komo, noro naymomàthàyamo, ketxkon hatà, toto komo. Xowawu nhananàhrà komo yoho nyhe thenyehra natxow hamà, ketxkon hatà. Àro wyaro tawro yonytxatxownà hatà, Farysew komo. ");
INSERT INTO hixNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Txesusuhnu ryhe, ànhananàhrà ro kom haxa ryhe, aymomno yeryatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Oyokaytà yonytxetxok hatà, Farysew komo, tawro yonytxay hatà, Txesusu, Kohkomo, anar komo wya. Àro ke, Xukneya yamtar hoye toy hatà. Karyeryeya yamtar hona harha toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samarya yamtar horye tekon hatà, Karyeryeya nano yawo esnàr ke. ");
INSERT INTO hixNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tàtonàr me moxe ro haka owto yonyey hatà. Sekah àro hatà, owto yosotà, Samarya yamtar hono rma hatà. Àro màhto rma nehxakon hatà, Xose heno yowtotho, Xako heno nàmàthotho, buru wya tàmsahonhàràtho. ");
INSERT INTO hixNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Xako heno katxhotho xarha, àto nehxakon hatà, tuna yonà ymo hatà, yukryeka yakaxaho ymo hatà. Àro yohokoso toy hatà, Txesusu. Neryewtay hatà, tamotohrà ke hatà, moxe rma haxa omohsah me tesnàr ke hatà. Awanaka nehxakon hatà, 6 oras me hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Owto hona totxownà hatà, ànhananàhrà ro komo. Tànyahrà komo yehekahso totxownà hatà. Noknomye hatà, Txesusu. Taa. Nomokye hatà, wosà. Samaryayana rma mok nehxakon hatà. Tuna yanàmso nomokye hatà. Rowokru tàmko, tuna, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Àsok tawro àro wyaro màken harha, rowya, kekon hatà, wosà. Àsok tawro àro wyaro màken harha, rowya. Xuknewyana ryhe omoro hamà. Samaryayana haxa uro. Àsok tawro rowokru tàmko màken harha, kekon hatà. Àro wyaro nkekon hatà, wosà, Samaryayana kaxe. Àsok tawro hana. Samaryayana komo rwomtohra ro mak natxhe ha, Xuknewyana komo. ");
INSERT INTO hixNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Onà wyaro haxa neyukye hatà, Txesusu. Khoryenkomo wya oyowakryetxho komo hutwahra manay hamà, kekon hatà. Uro xarha rohutwahra manay hamà. Rowokru tàmko kanyenhàrà rma hutwahra manay hamà, kekon hatà. Owya rohutwantoko, omoro haxa rowokru tàmko kany me oyesnàràtho haryhe, rowya, kekon hatà. Owya rowokru tàmko tatoko rma, tàmràtho haryhe rowya, karyhe roro oynye komo rma yàmràtho haryhe, rowya, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tuna yonà ymo takawanke naha, kekon hatà, wosà. Tuna yanàmtoho ehxera wenyaha, ohyawo. Henta ya màteno, tuna horà, karyhe roro amna yeny horà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Xako heno yoho nyhe kat manaye, owya. Amna horyen heno yoho nyhe kat manaye, owya. Noro heno ryhe, onà tuna yonà ymo yàmye hatà, amna wya, kekon hatà. Noro heno rma, on yaye twokru yanàmyakon hatà. Umuru heno komo xarha, twokru komo yanàmyatxkon hatà, on yaye. Toknà komo wokru xarha yanàmyatxkon hatà. Noro heno yoho nyhe kat manaye, owya, kekon hatà, wosà, Txesusu wya. ");
INSERT INTO hixNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Owyanye on yawonotho yonàtxhe rma, owohtxakonatxhe xarha, amnye, kekon hatà, noro. ");
INSERT INTO hixNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Owyanye ronàmàtho yonàtxhe haxa ryhe, àwohtxakomnà ro me harha manatxhe. Àsok hana nay ha, ronàmrà ha. Tuna wyaro rma nay hamà, kekon hatà. Yukryeka yatumnaye tuna yomoknàrà wyaro, ohnawonye naha ha, karyhe roro oynye komo, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Àro ryhe tàmko, rowya, kekon hatà, wosà. Rowokru tàmko, rowya, àwohtxakomra harha ryehtxoho me, xaro omokhàra harha ryehtxoho me, on yaye anàmpàra harha ryetxoho me, kekon hatà, wosà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Onà wyaro nkekon xarha tà, Txesusu, àwya. Onyo suhtaha, kekon hatà. Onyo suhtaha. ");
INSERT INTO hixNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ànyomnà uro, kekon hatà, wosà. Yaworo màkano, kekon hatà, Txesusu. Owya ànyomnà uro tatoko rma, yaworo màkano, ànyomra harha oyesnàr ke, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tànyonye oyexetxhàràtho rma uhutwehe. 5 me nehxatxkonà, onyo komo. Nyamoro hyaye mak motowye, kekon hatà. Amnye rma anaro kàrà hyawo manaha. Onyo ro mehra mak naha, noro. Yaworo màkan hamà, kekon hatà, Txesusu, àwya. ");
INSERT INTO hixNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Khutwatxehkanye ro me manay hamà, kekon hatà, wosà. Khoryenkomo rwonà yokarymanye ro heno komo wyaro, khutwatxehkanye ro me manay hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tano, àhà ymo ho, moro ymo ho, Khoryenkomo yowakryetxkon hatà, amna horyen heno komo, Samaryayana heno komo, kekon hatà. Omnyam haxa ryhe, Xuknewyana komo rma, onà wyaro màketxhe. Xerusaryen hona tàtohorye tehxatxhe, omeroro, Khoryenkomo yowakryexe, màketxhe, kekon hatà, wosà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Wosà y, ohxe uro enytxako, àro wyaro hamà tawro horà, kekon hatà, Txesusu. Amnye, Khoryenkomo yowakryenàr xe oyehtokonye, moro ymo hona àtohra harha manatxhe hampànà. Xerusaryen hona àtohra xarha manatxhe hampànà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Khoryenkomo mewakryetxhe rma haryhe, omnyamo, Samaryayana komo. Noro hutwahra mak manatxhe, kekon hatà. Amna haxa ryhe, Xuknewyana komo rma, noro amna nhutwehe. Amna nhutwanàrà rma amna newakryehe. Àsok tawro hana. Xuknewyana komo kukuru ryhe, toto komo yonyhoryeny me naha, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Amnye, noro yowakryenàr xe xaxa tehtokonye, tàhnawonye ryhe newakryetxhe, toto komo, ekato me mak ha. Àro wyaro ewakryeny me rma natxhe, amnye rma, kekon hatà. Àro wyaro yaworo xaxa noro yowakryetxhe. Àro wyaro towakryenàr xe naha, noro, toto komo wya, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ekato me naha, Khoryenkomo, ehàmra mak ha. Àro ke, ekato me hak newakryetxowà, toto komo, tàhnawony mak ha. Àro wyaro yaworo xaxa hak newakryetxowà, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Onà wyaro nkekon hatà, wosà, àwya. Tomohsom me nay hatà, Meseyasà, Kryestu rma noro hatà, kekon hatà. Tomokàtxhe, omeroro hutwamohsotàhkehe hampànà, noro, kàwyanye, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Noro uro ha, kekon hatà, Txesusu, àwya. Noro rma, ayakoro kàrwonaha, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Àtoko rma nomohtxownà harha tà, ànhananàhrà ro komo. Onà wyaro nehutwetxkon hatà, tàhnawonye. Àsok tawro nàrwonan harha, wos yakoro, ketxkon hatà, tàhnawonye. Eten xe manaye kahra mak nehxatxkon hatà. Eten hoko orwonano, wos yakoro, kahra xarha nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Wosà ryhe, oryenà nomye hatà. Owto hona harha toy hatà. Onà wyaro nkekon hatà, àton komo wya. ");
INSERT INTO hixNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Omohtxoko, toto yonyxe, kekon hatà, àwyanye. Omohtxoko, toto yonyxe. Noro rma, omeroro ryexetxhàràtho yokarymano, rowya. Kryestu me nay hana, kekon hatà, wosà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Àro ke totxownà hatà, owto hoye. Txesusu hyaka tetxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Owto ho rma hak wos yehtoko, onà wyaro nketxkon hatà, ànhananàhrà ro komo, Txesusu wya. Khananàhnye y, on ha anyahrà, enahko ha, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Anar me naha, ronyahrà, kekon mak hatà, noro. Uhutwahra mak manatxhe, omnyamo, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Àro ke, onà wyaro nketxkon hatà, tàwyanye rma. Onokà ryhe ànyahrà yokno, ketxkon hatà. Onokà ryhe ànyahrà yokno. ");
INSERT INTO hixNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Onà wyaro haxa naha, ronyahrà, kekon hatà. Ronyaknyenhàrà weyukyaha rye rma haxa hampànà. Noro rma weyuhtukehe hampànà, rowya àtàhkatxehkanàr horà, kekon hatà. Àro wyaro rowya noro yoyuhtoho ryhe, ronyahrà me naha. Àsok tawro hana. Kàwya dyahrà yonahàtxhe rma, teryehorye tehxan hamà, kwahuramrà ke mak ha. Àro wyaro rma rha, teryehorye rma haxa wehxaha, rowya noro yoyuknur ke mak ha, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Anatoko onà wyaro kany me manatxow hana, kekon xarha tà, àwyanye. Nat yehetawawohra hak tehxatxow hamà, 4 me nuno nenahtyan hamà, ehetahra rma haka, kany me manatxow hana. Onà wyaro haxa àkehe, owyanye. Amnye rma haxa ehetawawo rma tehxatxhe. Àsok tawro hana. Toto komo ryhe, nat yeherà wyaro natxow hamà, thohsomà wyaro rma, Khoryenkomo hyaka tohsom me tesnàr komo ke, kekon hatà. Osompohtxoko. Mokyam ha tomohsom komo, thohsomà wyaro tohsom me natxow hamà, noro hyaka, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Àhotnyenhàyamo wya, tehemaxem me nay hamà, àhoko exetxhàyamo. Àro wyaro rma rha, tehemaxem me naha, toto yohtoho, soknyenhàyamo wya, kekon hatà. Karyhe roro harha ehtxoho menye ryhe nekyatxow hamà, Khoryenkomo hyaka. Àro ke, teryehorye natxow hamà, soknyenhàyamo, àhotnyenhàyamo rma, kekon hatà. Teryehorye rma rha natxhe, nat yonamnyenhàyamo xarha, Khoryenkomo rwonà yokarymanyenhàyamo rma. Àto rye neryehotetxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Àro hoko rma, onà wyaro katxho yaworo xaxa nay hamà, anar komo nenamyatxhe, anar komo nhohtyatxhe, katxho rma, kàwyanye, kekon hatà, Txesusu. ");
INSERT INTO hixNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nat yeherà hohso ronànyaketxho me manatxhe, omnyamo, kekon xarha tà, tànhananàhrà ro komo wya. Nat yonampàra mehxatxoko. Àro hoko atamokhera ro mak mehxatxoko. Anar komo ryhe natamokyatxoko, tàwyanye Khoryenkomo rwonà yokarymanàr ke, kekon hatà. Nyamoro nenamàtho rma màhohtyatxhe, omnyamo, Khoryenkomo hyaka owyanye toto komo yoknàr ke, kekon hatà, Txesusu, tànhananàhrà ro komo wya. ");
INSERT INTO hixNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Àsok hana nehxatxkon ha, owto hon kom ha, Samaryayana komo rma. Txesus hona xeny me harha nehxatxkon hatà, ukukur komo, thenyenohnà komo rma, wos yoskarymanàr ke mak hatà, àwya omeroro ryexetxhàràtho yokarymano, rowya, tawro ke mak hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Àro ke, Txesusu hyaka tàtotxhenye rma, onà wyaro nketxkon hatà, àwya. Amna yowto ho rma hak exko, amna hyawo, ketxkon hatà, àwya. Àro ke, asako ro nenmahye hatà, noro, àto, àhyawonye. ");
INSERT INTO hixNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Àto rma ehtoko, noro hona harha nenytxownà hatà, anar komo xarha, thenyenohnà komo rma rha, tàwyanye noro rwonà yonytxanàr ke. ");
INSERT INTO hixNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Àro ke, onà wyaro nketxkon hatà, wosà wya. Amna nenyaha, noro hona, ketxkon hatà. Oyoskarymatxhàrà hoye rohra harha, noro haxa yonytxatxho hoye ro amna nenyaha, àhona, ketxkon hatà, wosà wya. Àro ke, onà wyaro kany me harha amna naha. Konyhoryeny kom me xaxa mpànà naha ha, noro ha, kany me harha amna naha, ketxkon hatà, àton komo, Samaryayana komo. ");
INSERT INTO hixNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Àto rma asako ro nenmahye hatà, Txesusu. Asako ro enmahàtxhe, toy hatà, Karyeryeya yamtar hona. ");
INSERT INTO hixNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Onà wyaro kanyenhàr me nehxakon hatà. Khoryenkomo rwonà yokarymanye ro komo yonytxahra ro mak natxhe, toto komo, towto komo honotho me ehtokonye, enytxahranye ro mak natxhe ha, kanyenhàr me nehxakon hatà. Àro ke, Xerusaryen hoye omohsahotho rma, Karyeryeya yamtar hona harha toy hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Àsna ahatakatxhe rma, ohxe noro yotakmetxownà hatà, àton komo, Karyeryeya hon komo rma. Xerusaryen hona àtosahotho rma rha mokyam nehxatxkon hatà, nyamoro xarha, asahxemtoso àtosahotho rma hatà. Xerusaryen ho tehtokonye, àhok Txesus yehtxoho yonytxehkatxownà hatà. Àro wyaro xenytxehkanyenhàrà rma, ohxe noro yotakmetxownà hatà, Karyeryeya yamtar hona harha ahatakatxhe rma. ");
INSERT INTO hixNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kana hona rma toy hatà, Txesusu, Karyeryeya yamtar hono rma hona hatà. Àto rma, ufa xkun me harha tuna yenyenhàr me nehxakon hatà. Moxehra nehxakon hatà, owto, anaro, Kafahnawu. Àto nehxakon hatà, horykomo. Àton komo kayaryetà yanoto kom yohà rma mok nehxakon hatà. Umuru ryhe, ekeh me nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Txesus yokaytà yonytxay hatà, noro. Karyeryeya hona harha nomokyak hatà, Xukneya hoye, tawro yonytxay hatà, toto komo wya. Àro ke toy hatà, Txesusu hyaka. Omok haka, kekon hatà, àwya. Omoko, romurunho txko enyhoryeko to. Ohxehra txko rma haxa manaye. Àwayehpaya rma manaye, kekon hatà, teryewrye ro hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Onà wyaro haxa nkekon hatà, Txesusu, àwya. Krawame rma haxa rohona menyatxow hamà, kekon hatà. Rahoxetà hutwamohsotho yonyhera ro rma haka, rohona xenyhera roro rma manatxow hamà, kekon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Rohà y, omoko hxa ha, romurunho txko wayehpàra ro, kekon hatà, horykomo. ");
INSERT INTO hixNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Àtok harha kekon hatà, Txesusu, àwya. Àtok harha. Ohxe naha, omuru, kekon hatà. Àro wyaro tàwya enytxatxhe rma, àro wyaro hamà kekon hatà, horykomo, tàhnawo. Toy harha tà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tàtonàr me tanoto komo yonyey hatà. Nohsotxownà hatà. Ha y, ketxkon hatà, àwya. Ohxe harha manaye, omuru, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Àna txko, kekon hatà, noro. Henta kamàm yehtoko, fahfàra nehxako, kekon hatà. Oroke kohsaya, 7 oras me ehtoko, nàhnànkeko, atunuthuru, ketxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nehutwekon hatà, horykomo. 7 oras me ehtoko, ohxe naha, omuru, keknano, Txesusu, kekon hatà, tàhnawo. Àro ke, Txesus hona harha nenyey hatà. Àmàn yawon komo xarha, noro hona rma rha nenytxownà hatà, omeroro hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Àro wyaro tahoxetà yonyhoy xarha tà, Txesusu. Xukneya yamtar hoye omohsaho rma, Karyeryeya yamtar hona omohsaho rma, àro wyaro tahoxetà yonyhoy hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Taa. Xuknewyana komo yasahxemtotho hahnok xarha nehxakon hatà. Àro ke toy xarha tà, Txesusu, Xerusaryen hona. ");
INSERT INTO hixNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Xerusaryen watxan hotarà màhto nay hatà, tuna, ukuthonà txko. Àhotarà yosotà rma, kahneru katxho me nay hatà. Tuna yosot haxa, Betesata katxho me nay hatà. Xuknewyana komo rwonà àro hatà. Tuna yohoye nay hatà, toh yexaho, thatawo, 5 me hatà, bamtotàhkaxe ro hatà. Bànke xarha nay hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Àro yawo rma nehxatxkon hatà, ekeh komo, enhun komo rma hatà, àhrohnà komo xarha hatà, amusnaxaho komo xarha hatà, thenyenohnà komo rma hatà. Àro yakrotnawo rma nehxatxkon hatà, tàraho roro hatà. Tuna yatahtamanàr hona ro nehxatxkon hatà. ");
INSERT INTO hixNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Àsok tawro hana. Khoryenkom yanoto ryhe, nahtamekon hatà, kahe yaye omohsaho rma hatà. Anatoko rhanye nomokyakon hatà, ahtamanye. Atahtamaxaho kwaka towomnàtoko, nosohtxemekon hatà, toto, teheryankemàtho. Wahoro htxero towomsomà ryhe, nosohtxemekon hatà. Àro ke, atahtamanàr hona ro nehxatxkon hatà, teheryankem komo, omeroro. ");
INSERT INTO hixNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Àwawonye nehxakon hatà, toto, ekehà rma. Àhrohnà ro me nehxakon hatà. Àhrohra rma, 38 me txemnyehàntaxah me nehxakon hatà. ");
INSERT INTO hixNT_vpl VALUES ("