﻿USE sofia;
DROP TABLE IF EXISTS sofia.hincv_vpl;
CREATE TABLE hincv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hincv_vpl WRITE;
INSERT INTO hincv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","आदि में परमेश्वर ने आकाश एवं पृथ्वी को रचा. ");
INSERT INTO hincv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","पृथ्वी बिना आकार के तथा खाली थी, और पानी के ऊपर अंधकार था तथा परमेश्वर का आत्मा जल के ऊपर मंडरा रहा था. ");
INSERT INTO hincv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","उसके बाद परमेश्वर ने कहा, “प्रकाश हो जाए,” और प्रकाश हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","परमेश्वर ने प्रकाश को देखा कि अच्छा है. परमेश्वर ने प्रकाश को अंधकार से अलग किया. ");
INSERT INTO hincv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","परमेश्वर ने प्रकाश को “दिन” तथा अंधकार को “रात” कहा और शाम हुई, फिर सुबह हुई—इस प्रकार पहला दिन हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","फिर परमेश्वर ने कहा, “जल के बीच ऐसा विभाजन हो कि जल दो भागों में हो जाए.” ");
INSERT INTO hincv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","इस प्रकार परमेश्वर ने नीचे के जल और ऊपर के जल को अलग किया. यह वैसा ही हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","परमेश्वर ने इस अंतर को “आकाश” नाम दिया. और शाम हुई, फिर सुबह हुई—इस प्रकार दूसरा दिन हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","फिर परमेश्वर ने कहा, “आकाश के नीचे का पानी एक जगह इकट्ठा हो जाए और सूखी भूमि दिखाई दे” और वैसा ही हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","परमेश्वर ने सूखी भूमि को “धरती” तथा जो जल इकट्ठा हुआ उसको “सागर” कहा और परमेश्वर ने देखा कि वह अच्छा है. ");
INSERT INTO hincv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","फिर परमेश्वर ने कहा, “पृथ्वी से हरी घास तथा पेड़ उगने लगें: और पृथ्वी पर फलदाई वृक्षों में फल लगने लगें.” और वैसा हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","पृथ्वी हरी-हरी घास, बीजयुक्त पौधे, जिनमें अपनी-अपनी जाति का बीज होता है तथा फलदाई वृक्ष, जिनके फलों में अपनी-अपनी जाति के बीज होते हैं, उगने लगे. परमेश्वर ने देखा कि यह अच्छा है. ");
INSERT INTO hincv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","फिर शाम हुई, फिर सुबह हुई—इस प्रकार तीसरा दिन हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","फिर परमेश्वर ने कहा, “दिन को रात से अलग करने के लिए आकाश में ज्योतियां हों, और ये चिन्हों, समयों, दिनों एवं वर्षों के लिए होगा. ");
INSERT INTO hincv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","और आकाश में ज्योतियां हों, जिससे पृथ्वी को प्रकाश मिले,” और ऐसा ही हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","परमेश्वर ने दो बड़ी ज्योतियां बनाई—बड़ी ज्योति को दिन में तथा छोटी ज्योति को रात में राज करने हेतु बनाया. और परमेश्वर ने तारे भी बनाये. ");
INSERT INTO hincv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","इन सभी को परमेश्वर ने आकाश में स्थिर किया कि ये पृथ्वी को रोशनी देते रहें, ");
INSERT INTO hincv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ताकि दिन और रात अपना काम पूरा कर सकें और रोशनी अंधकार से अलग हो. और परमेश्वर ने देखा कि यह अच्छा है. ");
INSERT INTO hincv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","और शाम हुई, फिर सुबह हुई—इस प्रकार चौथा दिन हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","फिर परमेश्वर ने कहा, “पानी में पानी के जंतु और आकाश में उड़नेवाले पक्षी भर जायें.” ");
INSERT INTO hincv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","परमेश्वर ने बड़े-बड़े समुद्री-जीवों तथा सब जातियों के जंतुओं को भी बनाया, और समुद्र को समुद्री-जीवों से भर दिया तथा सब जाति के पक्षियों की भी सृष्टि की और परमेश्वर ने देखा कि यह अच्छा है. ");
INSERT INTO hincv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","इन्हें परमेश्वर ने यह कहकर आशीष दी, “समुद्र में सभी जंतु, तथा पृथ्वी में पक्षी भर जायें.” ");
INSERT INTO hincv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","तब शाम हुई, फिर सुबह हुई—पांचवां दिन हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","फिर परमेश्वर ने कहा, “पृथ्वी से प्रत्येक जाति के जीवित प्राणी उत्पन्‍न हों: पालतू पशु, रेंगनेवाले जंतु तथा हर एक जाति के वन पशु उत्पन्‍न हों.” ");
INSERT INTO hincv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","परमेश्वर ने हर एक जाति के वन-पशुओं को, हर एक जाति के पालतू पशुओं को तथा भूमि पर रेंगनेवाले हर एक जाति के जीवों को बनाया. और परमेश्वर ने देखा कि यह अच्छा है. ");
INSERT INTO hincv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","फिर परमेश्वर ने कहा, “हम अपने स्वरूप के अनुसार अपनी समानता में मनुष्य की रचना करें कि वे सागर की मछलियों, आकाश के पक्षियों, पालतू पशुओं, भूमि पर रेंगनेवाले हर एक जीव तथा सारी पृथ्वी पर राज करें.” ");
INSERT INTO hincv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","इसलिये परमेश्वर ने अपने स्वरूप में मनुष्य को बनाया, परमेश्वर के ही स्वरूप में परमेश्वर ने उन्हें बनाया; नर और नारी करके उसने उन्हें बनाया. ");
INSERT INTO hincv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","परमेश्वर ने उन्हें यह आशीष दी, “फूलो फलो और संख्या में बढ़ो और पृथ्वी में भर जाओ और सब पर अधिकार कर लो. सागर की मछलियों, आकाश के पक्षियों व पृथ्वी के सब रेंगनेवाले जीव-जन्तुओं पर तुम्हारा अधिकार हो.” ");
INSERT INTO hincv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","तब परमेश्वर ने उनसे कहा, “मैंने तुम्हारे खाने के लिए बीज वाले पौधे और बीज वाले फल के पेड़ आदि दिये हैं जो तुम्हारे भोजन के लिये होंगे. ");
INSERT INTO hincv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","और पृथ्वी के प्रत्येक पशुओं, आकाश के सब पक्षियों और पृथ्वी पर रेंगनेवाले सब जीव-जन्तुओं को—प्रत्येक प्राणी को जिसमें जीवन का श्वास है—मैं प्रत्येक हरे पौधे भोजन के लिये देता हूं.” और वैसा ही हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","परमेश्वर ने अपनी बनाई हर चीज़ को देखा, और वह बहुत ही अच्छी थी. और शाम हुई, फिर सुबह हुई—इस प्रकार छठवां दिन हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","इस प्रकार परमेश्वर ने आकाश और पृथ्वी के लिए सब कुछ बनाकर अपना काम पूरा किया. ");
INSERT INTO hincv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","सातवें दिन परमेश्वर ने अपना सब काम पूरा कर लिया था; जो उन्होंने शुरू किया था; अपने सभी कामों को पूरा करके सातवें दिन उन्होंने विश्राम किया. ");
INSERT INTO hincv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","परमेश्वर ने सातवें दिन को आशीष दी तथा उसे पवित्र ठहराया, क्योंकि यह वह दिन था, जब उन्होंने अपनी रचना, जिसकी उन्होंने सृष्टि की थी, पूरी करके विश्राम किया. ");
INSERT INTO hincv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","यही वर्णन है कि जिस प्रकार याहवेह परमेश्वर ने आकाश और पृथ्वी को बनाया. ");
INSERT INTO hincv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","उस समय तक पृथ्वी में कोई हरियाली और कोई पौधा नहीं उगा था, क्योंकि तब तक याहवेह परमेश्वर ने पृथ्वी पर बारिश नहीं भेजी थी. और न खेती करने के लिए कोई मनुष्य था. ");
INSERT INTO hincv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","भूमि से कोहरा उठता था जिससे सारी भूमि सींच जाती थी. ");
INSERT INTO hincv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","फिर याहवेह परमेश्वर ने मिट्टी से मनुष्य को बनाया तथा उसके नाक में जीवन की सांस फूंक दिया. इस प्रकार मनुष्य जीवित प्राणी हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","याहवेह परमेश्वर ने पूर्व दिशा में एदेन नामक स्थान में एक बगीचा बनाया और उस बगीचे में मनुष्य को रखा. ");
INSERT INTO hincv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","याहवेह परमेश्वर ने सुंदर पेड़ और जिनके फल खाने में अच्छे हैं, उगाए और बगीचे के बीच में जीवन का पेड़ और भले या बुरे के ज्ञान के पेड़ भी लगाया. ");
INSERT INTO hincv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","एदेन से एक नदी बहती थी जो बगीचे को सींचा करती थी और वहां से नदी चार भागों में बंट गई. ");
INSERT INTO hincv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","पहली नदी का नाम पीशोन; जो बहती हुई हाविलाह देश में मिल गई, जहां सोना मिलता है. ");
INSERT INTO hincv_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(उस देश में अच्छा सोना है. मोती एवं सुलेमानी पत्थर भी वहां पाए जाते हैं.) ");
INSERT INTO hincv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","दूसरी नदी का नाम गीहोन है. यह नदी कूश देश में जाकर मिलती है. ");
INSERT INTO hincv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","तीसरी नदी का नाम हिद्देकेल है; यह अश्शूर के पूर्व में बहती है. चौथी नदी का नाम फरात है. ");
INSERT INTO hincv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","याहवेह परमेश्वर ने आदम को एदेन बगीचे में इस उद्देश्य से रखा कि वह उसमें खेती करे और उसकी रक्षा करे. ");
INSERT INTO hincv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","याहवेह परमेश्वर ने मनुष्य से यह कहा, “तुम बगीचे के किसी भी पेड़ के फल खा सकते हो; ");
INSERT INTO hincv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","लेकिन भले या बुरे के ज्ञान का जो पेड़ है उसका फल तुम कभी न खाना, क्योंकि जिस दिन तुम इसमें से खाओगे, निश्चय तुम मर जाओगे.” ");
INSERT INTO hincv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","इसके बाद याहवेह परमेश्वर ने कहा, “आदम का अकेला रहना अच्छा नहीं है. मैं उसके लिए एक सुयोग्य साथी बनाऊंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","याहवेह परमेश्वर ने पृथ्वी में पशुओं तथा पक्षियों को बनाया और उन सभी को मनुष्य के पास ले आए, ताकि वह उनका नाम रखे; आदम ने जो भी नाम रखा, वही उस प्राणी का नाम हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","आदम ने सब जंतुओं का नाम रख दिया. किंतु आदम के लिए कोई साथी नहीं था, जो उसके साथ रह सके. ");
INSERT INTO hincv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","इसलिये याहवेह परमेश्वर ने आदम को गहरी नींद में डाला; जब वह सो गया, याहवेह परमेश्वर ने उसकी एक पसली निकाली और उस जगह को मांस से भर दिया. ");
INSERT INTO hincv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","फिर याहवेह परमेश्वर ने उस पसली से एक स्त्री बना दी और उसे आदम के पास ले गए. ");
INSERT INTO hincv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","आदम ने कहा, “अब यह मेरी हड्डियों में की हड्डी और मेरे मांस में का मांस है; उसे ‘नारी’ नाम दिया जायेगा, क्योंकि यह ‘नर’ से निकाली गई थी.” ");
INSERT INTO hincv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","इस कारण पुरुष अपने माता-पिता को छोड़कर अपनी पत्नी से मिला रहेगा तथा वे दोनों एक देह होंगे. ");
INSERT INTO hincv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","आदम एवं उसकी पत्नी नग्न तो थे पर लजाते न थे. ");
INSERT INTO hincv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","याहवेह परमेश्वर के बनाये सब जंतुओं में सांप सबसे ज्यादा चालाक था. उसने स्त्री से कहा, “क्या सच में परमेश्वर ने तुमसे कहा, ‘तुम इस बगीचे के किसी भी पेड़ का फल न खाना’?” ");
INSERT INTO hincv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","तब स्त्री ने उत्तर दिया, “हम बगीचे के वृक्षों के फलों को खा सकते हैं, ");
INSERT INTO hincv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","लेकिन बगीचे के बीच में जो पेड़ है, उसके बारे में परमेश्वर ने कहा है ‘न तो तुम उसका फल खाना और न ही उसको छूना, नहीं तो तुम मर जाओगे.’ ” ");
INSERT INTO hincv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","सांप ने स्त्री से कहा, “निश्चय तुम नहीं मरोगे! ");
INSERT INTO hincv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","परमेश्वर यह जानते हैं कि जिस दिन तुम इसमें से खाओगे, तुम्हारी आंखें खुल जाएंगी तथा तुम्हें भले और बुरे का ज्ञान हो जाएगा और तुम परमेश्वर के समान हो जाओगे.” ");
INSERT INTO hincv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","जब स्त्री ने उस पेड़ के फल की ओर देखा कि वह खाने में अच्छा तथा देखने में सुंदर और बुद्धि देनेवाला है, तब उसने उस पेड़ के फलों में से एक लेकर खाया. और उसने यह फल अपने पति को भी दिया, जो उसके पास ही था. उसने भी उसे खाया. ");
INSERT INTO hincv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","तब उन दोनों की आंखें खुल गईं और उन्हें महसूस हुआ कि वे नंगे हैं. इसलिये उन्होंने अंजीर की पत्तियां जोड़कर कपड़े बनाए और अपने नंगेपन को ढक दिया. ");
INSERT INTO hincv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","जब आदम और स्त्री ने दिन के ठण्डे समय में याहवेह परमेश्वर के आने की आवाज बगीचे में सुनी, तब आदम और उसकी पत्नी पेड़ों के बीच में छिप गये. ");
INSERT INTO hincv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","किंतु याहवेह परमेश्वर ने आदम को बुलाया और पूछा, “तुम कहां हो?” ");
INSERT INTO hincv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","आदम ने उत्तर दिया, “आपके आने का शब्द सुनकर हम डर गये और हम छिप गये क्योंकि हम नंगे हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","याहवेह ने कहा, “किसने तुमसे कहा कि तुम नंगे हो? कहीं ऐसा तो नहीं, कि तुमने उस पेड़ का फल खा लिया हो, जिसको खाने के लिए मैंने मना किया था?” ");
INSERT INTO hincv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","आदम ने कहा, “साथ में रहने के लिए जो स्त्री आपने मुझे दी है, उसी ने मुझे उस पेड़ से वह फल दिया, जिसे मैंने खाया.” ");
INSERT INTO hincv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","यह सुन याहवेह परमेश्वर ने स्त्री से पूछा, “यह क्या किया तुमने?” स्त्री ने उत्तर दिया, “सांप ने मुझे बहकाया, इसलिये मैंने वह फल खा लिया.” ");
INSERT INTO hincv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","याहवेह परमेश्वर ने सांप से कहा, तूने ऐसा करके गलत किया, “इसलिये तू सभी पालतू पशुओं से तथा सभी वन्य पशुओं से अधिक शापित है! तू पेट के बल चला करेगा और जीवन भर मिट्टी चाटता रहेगा. ");
INSERT INTO hincv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","मैं तेरे तथा स्त्री के बीच, तेरी संतान तथा स्त्री की संतान के बीच बैर पैदा करूंगा; वह तेरे सिर को कुचलेगा, तथा तू उसकी एड़ी को डसेगा.” ");
INSERT INTO hincv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","स्त्री से परमेश्वर ने कहा, “मैं तुम्हारी गर्भावस्था के दर्द को बहुत बढ़ाऊंगा; तुम दर्द के साथ संतान को जन्म दोगी. यह होने पर भी तुम्हारी इच्छा तुम्हारे पति की ओर होगी, और पति तुम पर अधिकार करेगा.” ");
INSERT INTO hincv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","फिर आदम से परमेश्वर ने कहा, “तुमने अपनी पत्नी की बात सुनकर उस पेड़ से फल खाया, ‘जिसे खाने के लिये मैंने तुम्हें मना किया था,’ “इस कारण यह पृथ्वी जिस पर तुम रह रहे हो, श्रापित हो गई है; तुम जीवन भर कड़ी मेहनत करके जीवन चलाओगे. ");
INSERT INTO hincv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","तुम खेती करोगे लेकिन उसमें कांटे और जंगली पेड़ उगेंगे, और तुम खेत की उपज खाओगे. ");
INSERT INTO hincv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","तुम अपने पसीने ही की रोटी खाया करोगे और अंततः मिट्टी में मिल जाओगे क्योंकि तुम मिट्टी ही हो, मिट्टी से ही बने हो.” ");
INSERT INTO hincv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","आदम ने अपनी पत्नी को हव्वा नाम दिया, क्योंकि वही सबसे पहली माता थी. ");
INSERT INTO hincv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","आदम तथा उसकी पत्नी के लिए याहवेह परमेश्वर ने चमड़े के वस्त्र बनाकर उन्हें पहना दिये. ");
INSERT INTO hincv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","फिर याहवेह परमेश्वर ने सोचा, “आदम और हव्वा ने भले और बुरे के ज्ञान का फल तो खा लिया, अब वे जीवन के पेड़ से फल खाकर सदा जीवित न रह जाएं.” ");
INSERT INTO hincv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","इस कारण याहवेह परमेश्वर ने उन्हें एदेन के बगीचे से बाहर कर दिया, ताकि वे भूमि पर खेती करें, और फल उपजायें. ");
INSERT INTO hincv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","तब उन्होंने आदम को एदेन के बगीचे से बाहर कर दिया तथा एदेन के बगीचे की निगरानी के लिए करूबों को और चारों ओर घूमनेवाली ज्वालामय तलवार को रख दिया ताकि कोई जीवन के वृक्ष को छू न सके. ");
INSERT INTO hincv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","जब आदम ने अपनी पत्नी हव्वा के साथ दाम्पतिक संबंध में प्रवेश किया, तब हव्वा गर्भवती हुई तथा उसने कयीन को जन्म दिया. हव्वा ने कहा, “याहवेह की सहायता से मैंने एक पुरुष को जन्म दिया है.” ");
INSERT INTO hincv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","फिर हव्वा ने कयीन के भाई हाबिल को जन्म दिया. हाबिल भेड़-बकरियों का चरवाहा था, किंतु कयीन खेती करता था. ");
INSERT INTO hincv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","कुछ दिनों बाद याहवेह को भेंट चढ़ाने के उद्देश्य से कयीन अपनी खेती से कुछ फल ले आया. ");
INSERT INTO hincv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","और हाबिल ने अपने भेड़-बकरियों में से पहला बच्चा भेंट चढ़ाया तथा चर्बी भी भेंट चढ़ाई. याहवेह ने हाबिल और उसकी भेंट को तो ग्रहण किया, ");
INSERT INTO hincv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","परंतु कयीन और उसकी भेंट को याहवेह ने ग्रहण नहीं किया. इससे कयीन बहुत क्रोधित हुआ तथा उसके मुख पर उदासी छा गई. ");
INSERT INTO hincv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","इस पर याहवेह ने कयीन से पूछा, “तू क्यों क्रोधित हुआ? क्यों तू उदास हुआ? ");
INSERT INTO hincv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","अगर तू परमेश्वर के योग्य भेंट चढ़ाता तो क्या तेरी भेंट ग्रहण न होती? और यदि तू सही न करे, तो पाप द्वार पर है, और उसकी लालसा तेरी ओर रहेगी. पर तू उस पर प्रभुता करना.” ");
INSERT INTO hincv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","हाबिल अपने भाई कयीन के खेत में गया तब कयीन ने हाबिल से कुछ कहा और कयीन ने हाबिल को मार दिया. ");
INSERT INTO hincv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","तब याहवेह ने कयीन से पूछा, “तेरा भाई हाबिल कहां है?” उसने उत्तर दिया, “पता नहीं. क्या मैं अपने भाई का रखवाला हूं?” ");
INSERT INTO hincv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","याहवेह ने कहा, “तूने यह क्या किया? भूमि से तेरे भाई का रक्त मुझे पुकार रहा है. ");
INSERT INTO hincv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","अब तू उस भूमि की ओर से शापित है, क्योंकि इस खेत में तेरे भाई का खून गिरा है. ");
INSERT INTO hincv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","जब तू खेती करेगा, तुझे इसकी पूरी उपज नहीं मिलेगी; तू अब पृथ्वी पर अकेला और बेसहारा होगा.” ");
INSERT INTO hincv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","कयीन ने याहवेह से कहा, “मेरा दंड मेरी सहन से बाहर है. ");
INSERT INTO hincv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","आपने आज मुझे यहां से निकाल दिया है, मैं आपके सामने से छिप जाऊंगा; मैं अकेला और बेसहारा होकर घुमूंगा तो मैं जिस किसी के सामने जाऊंगा, वे मुझे मार देंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","यह सुन याहवेह ने उससे कहा, “यदि ऐसा हुआ, तो जो कोई कयीन की हत्या करेगा, उससे सात गुणा बदला लिया जाएगा.” याहवेह ने कयीन के लिए एक विशेष चिन्ह ठहराया, ताकि कोई उसकी हत्या न कर दे. ");
INSERT INTO hincv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","इसके बाद कयीन याहवेह के पास से चला गया और नोद देश में बस गया, जो एदेन बगीचे के पूर्व में है. ");
INSERT INTO hincv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","कयीन की पत्नी ने हनोख को जन्म दिया. कयीन ने एक नगर बसाया और उस नगर को अपने पुत्र के नाम पर हनोख रखा. ");
INSERT INTO hincv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोख से इराद का जन्म हुआ, इराद से महूजाएल का तथा महूजाएल से मेथूशाएल का, मेथूशाएल से लामेख का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लामेख की दो पत्नियां थीं, एक का नाम अदाह तथा दूसरी का नाम ज़िल्लाह था. ");
INSERT INTO hincv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","अदाह ने जाबाल को जन्म दिया; वह जानवरों के पालने वालों और तंबुओं में रहनेवालों का नायक बना. ");
INSERT INTO hincv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","उसके भाई का नाम यूबाल था; वह वीणा और बांसुरी बजाने वालों का नायक बना. ");
INSERT INTO hincv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ज़िल्लाह ने तूबल-कयीन को जन्म दिया, जो कांसे एवं लोहे के सामान बनाता था. तूबल-कयीन की बहन का नाम नामाह था. ");
INSERT INTO hincv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","लामेख ने अपनी पत्नियों से कहा, “अदाह और ज़िल्लाह सुनो; तुम मेरी पत्नियां हो, मेरी बात ध्यान से सुनो, मैंने एक व्यक्ति को मारा है, क्योंकि उसने मुझ पर आक्रमण किया था. ");
INSERT INTO hincv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","जब कयीन के लिए सात गुणा बदला लिया गया था, तब तो लामेख के लिए सत्तर बार सात गुणा होगा.” ");
INSERT INTO hincv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","हव्वा ने एक और पुत्र को जन्म दिया और उसका नाम शेत यह कहकर रखा, “कयीन द्वारा हाबिल की हत्या के बाद परमेश्वर ने हाबिल के बदले मेरे लिए एक और संतान दिया है.” ");
INSERT INTO hincv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","शेत के भी एक पुत्र पैदा हुआ, जिसका उसने एनोश नाम रखा. उस समय से लोगों ने याहवेह से प्रार्थना करना शुरू किया. ");
INSERT INTO hincv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","यह आदम के वंशजों का प्रलेख है: जब परमेश्वर ने मनुष्य की सृष्टि की, तो उन्होंने मनुष्य को अपने ही रूप में बनाया. ");
INSERT INTO hincv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","परमेश्वर ने मनुष्य को नर तथा नारी कहकर उन्हें आशीष दी और परमेश्वर ने उनका नाम आदम रखा. ");
INSERT INTO hincv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","जब आदम 130 वर्ष के हुए, तब एक पुत्र पैदा हुआ, जिनका रूप स्वयं उन्हीं के समान था; उनका शेत नाम रखा गया. ");
INSERT INTO hincv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","शेत के जन्म के बाद आदम 800 वर्ष के हुए, उनके और पुत्र-पुत्रियां भी पैदा हुए. ");
INSERT INTO hincv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","इस प्रकार आदम कुल 930 साल जीवित रहे, फिर उनकी मृत्यु हो गई. ");
INSERT INTO hincv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","जब शेत 105 वर्ष के थे, तब एनोश का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","एनोश के बाद उनके और पुत्र-पुत्रियां भी पैदा हुए तथा शेत 807 वर्ष और जीवित रहे. ");
INSERT INTO hincv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","जब शेत कुल 912 साल जीवित रहे, तब उनकी मृत्यु हो गई. ");
INSERT INTO hincv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","जब एनोश 90 वर्ष के हुए, तब केनान का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","केनान के जन्म के बाद एनोश 815 वर्ष और जीवित रहे तथा उनके और पुत्र-पुत्रियां भी पैदा हुए. ");
INSERT INTO hincv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","जब एनोश कुल 905 साल जीवित रहे, तब उनकी मृत्यु हो गई. ");
INSERT INTO hincv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","जब केनान 70 वर्ष के हुए, तब माहालालेल का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","माहालालेल के जन्म के बाद, केनान 840 वर्ष और जीवित रहे तथा उनके और पुत्र-पुत्रियां भी पैदा हुए. ");
INSERT INTO hincv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","इस प्रकार केनान कुल 910 वर्ष के हुए, और उनकी मृत्यु हो गई. ");
INSERT INTO hincv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","जब माहालालेल 65 वर्ष के हुए, तब यारेद का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","यारेद के जन्म के बाद, माहालालेल 830 वर्ष और जीवित रहे तथा उनके और पुत्र-पुत्रियां भी पैदा हुए. ");
INSERT INTO hincv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","जब माहालालेल 895 वर्ष के थे, तब उनकी मृत्यु हो गई. ");
INSERT INTO hincv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","जब यारेद 162 वर्ष के हुए, तब हनोख का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","हनोख के जन्म के बाद, यारेद 800 वर्ष और जीवित रहे तथा उनके और पुत्र-पुत्रियां भी पैदा हुईं. ");
INSERT INTO hincv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","जब यारेद कुल 962 साल जीवित रहे, तब उनकी मृत्यु हो गई. ");
INSERT INTO hincv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","जब हनोख 65 वर्ष के हुए, तब मेथुसेलाह का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","मेथुसेलाह के जन्म के बाद हनोख 300 वर्ष तक परमेश्वर के साथ साथ चलते रहे. उसके अन्य पुत्र-पुत्रियां भी पैदा हुए. ");
INSERT INTO hincv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","हनोख कुल 265 साल जीवित रहे. ");
INSERT INTO hincv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनोख परमेश्वर के साथ साथ चलते रहे. और वे नहीं रहे, क्योंकि परमेश्वर ने उन्हें अपने पास उठा लिया. ");
INSERT INTO hincv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","जब मेथुसेलाह 187 वर्ष के हुए, तब लामेख का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","लामेख के जन्म के बाद, मेथुसेलाह 782 वर्ष और जीवित रहे तथा उनके और पुत्र-पुत्रियां भी पैदा हुए. ");
INSERT INTO hincv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","जब मेथुसेलाह कुल 969 साल जीवित रहे, तब उनकी मृत्यु हो गई. ");
INSERT INTO hincv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","जब लामेख 182 वर्ष के हुए, तब एक पुत्र का जन्म हुआ, ");
INSERT INTO hincv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","जिनका नाम उन्होंने नोहा यह कहकर रखा, “यह बालक हमें हमारे कामों से तथा मेहनत से, और इस शापित भूमि से शांति देगा.” ");
INSERT INTO hincv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","नोहा के जन्म के बाद लामेख 595 वर्ष और जीवित रहे, तथा उनके और पुत्र-पुत्रियां पैदा हुए. ");
INSERT INTO hincv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","जब लामेख कुल 777 साल जीवित रहे, तब उनकी मृत्यु हुई. ");
INSERT INTO hincv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","नोहा के 500 वर्ष की आयु में शेम, हाम तथा याफेत का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","फिर जब पृथ्वी पर मनुष्यों की संख्या बढ़ने लगी और उनके पुत्रियां पैदा हुई, ");
INSERT INTO hincv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","तब परमेश्वर के पुत्रों ने मनुष्यों के पुत्रियों को देखा कि वे सुंदर हैं. और उन्होंने उन्हें अपनी इच्छा अनुसार अपनी-अपनी पत्नियां बना लिया. ");
INSERT INTO hincv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","यह देखकर याहवेह ने निर्णय लिया, “मेरा आत्मा मनुष्य से हमेशा बहस करता न रहेगा क्योंकि मनुष्य केवल मांस मात्र है, वह 120 वर्ष ही जीवित रहेगा.” ");
INSERT INTO hincv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","उन दिनों में पृथ्वी पर दानव रहते थे. जब परमेश्वर के पुत्रों और मनुष्यों की पुत्रियों के संतान हुए वे बहुत बलवान और शूरवीर थे. ");
INSERT INTO hincv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","जब याहवेह ने मनुष्यों को देखा कि वे हमेशा बुराई ही करते हैं, कि उन्होंने जो कुछ भी सोचा था या कल्पना की थी वह लगातार और पूरी तरह से बुराई थी. ");
INSERT INTO hincv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","तब याहवेह पृथ्वी पर आदम को बनाकर पछताए और मन में अति दुखित हुए. ");
INSERT INTO hincv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","और याहवेह ने सोचा, “मैं पृथ्वी पर से मनुष्य को मिटा दूंगा—हर एक मनुष्य, पशु, रेंगते जंतु तथा आकाश के पक्षी, जिनको बनाकर मैं पछताता हूं.” ");
INSERT INTO hincv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","लेकिन नोहा पर याहवेह का अनुग्रह था. ");
INSERT INTO hincv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","नोहा और उनके परिवार का अभिलेख इस प्रकार है: नोहा एक धर्मी और निर्दोष व्यक्ति थे. वे परमेश्वर के साथ साथ चलते थे. ");
INSERT INTO hincv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","उनके तीन पुत्र थे शेम, हाम तथा याफेत. ");
INSERT INTO hincv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","परमेश्वर ने देखा कि पृथ्वी पर बहुत बुराई और उपद्रव बढ़ गया है. ");
INSERT INTO hincv_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","परमेश्वर ने पृथ्वी को देखा कि वह भ्रष्‍ट हो गई है; क्योंकि समस्त मानवों ने पृथ्वी पर अपना आचरण भ्रष्‍ट कर लिया था. ");
INSERT INTO hincv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","इसलिये परमेश्वर ने नोहा से कहा, “मैं पूरी पृथ्वी के लोग और जो कुछ भी उसमें है सबको नाश कर दूंगा, क्योंकि उनके कारण पृथ्वी उपद्रव से भर गई है. ");
INSERT INTO hincv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","इसलिये नोहा से याहवेह ने कहा कि तुम अपने लिए गोपेर पेड़ की लकड़ी का एक बड़ा जहाज़ बनाना; जहाज़ में कई अलग-अलग भाग बनाना, और भीतर बाहर उस पर राल लगाना. ");
INSERT INTO hincv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","जहाज़ की लंबाई एक सौ पैंतीस मीटर, चौड़ाई तेईस मीटर तथा ऊंचाई चौदह मीटर रखना. ");
INSERT INTO hincv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","इसके लिए एक छत बनाना. जहाज़ में एक खिड़की बनाना, जो ऊपर की ओर छत से आधा मीटर नीचे होगी, जहाज़ के एक तरफ दरवाजा रखना. जहाज़ में पहली, दूसरी तथा तीसरी मंजिलें बनाना. ");
INSERT INTO hincv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","क्योंकि मैं पृथ्वी को जलप्रलय से नाश कर दूंगा और कोई न बचेगा; सबको जिनमें जीवन की आत्मा है, आकाश के नीचे से मैं नाश करनेवाला हूं. ");
INSERT INTO hincv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","लेकिन मैं तुम्हारे साथ अपनी वाचा बांधूंगा—जहाज़ में तुम, तुम्हारे पुत्र, तुम्हारी पत्नी तथा तुम्हारी बहुओं सहित प्रवेश करना. ");
INSERT INTO hincv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","और प्रत्येक जीवित प्राणी के दो-दो अर्थात् नर एवं मादा को जहाज़ में ले जाना, ताकि वे तुम्हारे साथ जीवित रह सकें. ");
INSERT INTO hincv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","पक्षी भी अपनी-अपनी जाति के, पशु अपनी-अपनी जाति के, भूमि पर रेंगनेवाले जंतु अपनी-अपनी जाति के सभी जातियों के जोड़े जहाज़ में रखना, ताकि वे जीवित रह सकें. ");
INSERT INTO hincv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","और खाने के लिए सब प्रकार का भोजन रखना, जो सबके लिए होगा.” ");
INSERT INTO hincv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","नोहा ने वैसा ही किया, जैसा परमेश्वर ने उनसे कहा. ");
INSERT INTO hincv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","फिर याहवेह ने नोहा से कहा, “तुम और तुम्हारा पूरा परिवार जहाज़ में जाओ, क्योंकि इस पृथ्वी पर केवल तुम ही धर्मी हो. ");
INSERT INTO hincv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","तुम अपने साथ उन पशुओं के सात-सात जोड़े नर एवं मादा ले लो, जो शुद्ध माने जाते हैं तथा उन पशुओं का भी एक-एक जोड़ा, जो शुद्ध नहीं माने जाते. ");
INSERT INTO hincv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","इसी प्रकार आकाश के पक्षियों के सात जोड़े—नर तथा मादा, ले लो. ");
INSERT INTO hincv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","क्योंकि अब से सात दिन के बाद, मैं पृथ्वी पर जल बरसाऊंगा, चालीस दिन तथा चालीस रात तक जल बरसाता रहूंगा और भूमि पर मेरे द्वारा रचे गये सभी जीवित प्राणी नष्ट हो जायेंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","नोहा ने याहवेह की सब बातों को माना. ");
INSERT INTO hincv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","जब पृथ्वी पर जलप्रलय शुरू हुआ, तब नोहा छः सौ वर्ष के थे. ");
INSERT INTO hincv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","नोहा, उनकी पत्नी, उनके पुत्र, तथा उनकी बहुएं प्रलय से बचने के लिए जहाज़ में चले गए. ");
INSERT INTO hincv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","शुद्ध तथा अशुद्ध पशु, पक्षी तथा भूमि पर रेंगनेवाले जंतु, ");
INSERT INTO hincv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","नर एवं मादा को जोड़ों में नोहा ने जहाज़ में लिया, जैसा परमेश्वर ने नोहा से कहा था. ");
INSERT INTO hincv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","सात दिन बाद पृथ्वी पर पानी बरसना शुरू हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","नोहा के छः सौ वर्ष के दूसरे महीने के सत्रहवें दिन महासागर के सोते फूट पड़े तथा आकाश को खोल दिया गया. ");
INSERT INTO hincv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","और पृथ्वी पर चालीस दिन तथा चालीस रात लगातार बरसात होती रही. ");
INSERT INTO hincv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ठीक उसी दिन नोहा, उनके पुत्र शेम, हाम तथा याफेत, नोहा की पत्नी तथा उनकी तीनों बहुएं जहाज़ में चले गए. ");
INSERT INTO hincv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","और उनके साथ सब जाति के वन्य पशु, पालतू पशु, रेंगनेवाले जंतु, सभी प्रकार के पक्षी और वे सभी जिनके पंखे हैं, जहाज़ में गए. ");
INSERT INTO hincv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","इस प्रकार वे सभी, जिसमें जीवन था, दो-दो नोहा के पास जहाज़ में पहुंच गए. ");
INSERT INTO hincv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","नोहा को परमेश्वर के आदेश के अनुसार, जो जहाज़ में पहुंचे, वे सभी प्राणियों के नर एवं मादा थे. जहाज़ में आए सबके अंदर जाते ही याहवेह ने द्वार बंद कर दिया. ");
INSERT INTO hincv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","पृथ्वी पर चालीस दिन तथा चालीस रात तक पानी बरसता रहा. पानी ऊपर होता गया और जहाज़ भी ऊपर उठता गया. ");
INSERT INTO hincv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","पानी से पूरी पृथ्वी डूब गई, और जहाज़ पानी के ऊपर तैरता रहा. ");
INSERT INTO hincv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","जल पृथ्वी पर इतना बढ़ गया कि आकाश के नीचे के बड़े-बड़े पहाड़ भी डूब गए. ");
INSERT INTO hincv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","पानी पहाड़ के लगभग सात मीटर ऊंचा हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","पृथ्वी पर का सब कुछ नाश हो गया; प्रत्येक जीवित प्राणी जो भूमि पर चलती थी—पक्षी, पशु, जंगली जानवर, वे सभी प्राणी जो पृथ्वी पर तैरते हैं, और पूरी मानव जाति. ");
INSERT INTO hincv_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","थल के सभी जीवित प्राणी मर गये. ");
INSERT INTO hincv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","इस प्रकार याहवेह ने पृथ्वी के सभी मनुष्य, पशु, रेंगनेवाले जंतु आकाश के पक्षी, सभी को नाश कर दिया. केवल नोहा और उनका परिवार तथा जो जीव-जन्तु जहाज़ में थे, वही बचे. ");
INSERT INTO hincv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","150 दिन पृथ्वी पानी से ढकी रही. ");
INSERT INTO hincv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","फिर परमेश्वर ने नोहा और सभी जंगली जानवरों और घरेलू पशुओं को याद किया जो जहाज़ में थे और एक हवा चलाई. तब पानी सूखने लगे और धीरे धीरे पानी कम होने लगा. ");
INSERT INTO hincv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","आकाश से पानी बरसना रोक दिया गया, और पृथ्वी के नीचे से पानी का बहना भी रोक दिया गया. ");
INSERT INTO hincv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","इसलिये जलप्रलय धीरे धीरे पृथ्वी से हट गए, 150 दिन पूरे होते-होते पानी कम हो चुका था. ");
INSERT INTO hincv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","सातवें महीने के सत्रहवें दिन जहाज़ अरारात पर्वत पर जा टिका. ");
INSERT INTO hincv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","दसवें महीने तक जल उतरता गया, और दसवें महीने के पहले दिन पर्वत का ऊपरी हिस्सा दिखने लगा. ");
INSERT INTO hincv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","चालीस दिन पूरा होने पर नोहा ने जहाज़ की खिड़की को खोल दिया, जो उन्होंने बनाई थी. ");
INSERT INTO hincv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","उन्होंने एक कौवे को बाहर छोड़ दिया, जो पृथ्वी पर इधर-उधर उड़ते और जहाज़ में आते जाते रहा. ");
INSERT INTO hincv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","फिर नोहा ने एक कबूतर को यह देखने के लिये छोड़ा कि पृथ्वी से पानी कम हुआ या नहीं. ");
INSERT INTO hincv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","लेकिन कबूतर को कहीं भी बैठने की जगह नहीं मिली क्योंकि पानी अभी भी ज़मीन को ढका था; इसलिये वह वापस जहाज़ में आ गया. नोहा ने अपना हाथ बढ़ाकर कबूतर को वापस जहाज़ के अंदर ले लिया. ");
INSERT INTO hincv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","सात दिन बाद नोहा ने फिर कबूतर को छोड़ दिया. ");
INSERT INTO hincv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","कबूतर अपनी चोंच में जैतून का एक कोमल पत्ता लेकर जहाज़ में लौट आया. यह देखकर नोहा समझ गये कि पृथ्वी पर से पानी कम हो गया है. ");
INSERT INTO hincv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","नोहा ने सात दिन बाद फिर से कबूतर को बाहर छोड़ा लेकिन इस बार कबूतर वापस नहीं आया. ");
INSERT INTO hincv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","नोहा के जन्म का छः सौ और एक वर्ष के पहले महीने के पहले दिन पानी पृथ्वी पर से सूख गया. तब नोहा ने जहाज़ की छत को हटा दिया और उन्होंने देखा कि ज़मीन सूख गई है. ");
INSERT INTO hincv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","दूसरे महीने के सत्ताईसवें दिन ज़मीन पूरी तरह सूख गई. ");
INSERT INTO hincv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","तब परमेश्वर ने नोहा से कहा, ");
INSERT INTO hincv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“जहाज़ से तुम सब बाहर आ जाओ; तू और तेरी पत्नी और तेरे बेटे और उनकी पत्नियां. ");
INSERT INTO hincv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","और सभी पशु, सभी पक्षी व जानवर, पृथ्वी पर रेंगनेवाले सभी को भी बाहर लाकर छोड़ दो ताकि ये जानवर अनेक जानवर उत्पन्‍न करेंगे, और फलवंत होकर पृथ्वी को फिर भर देंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","नोहा, उनके पुत्र, नोहा की पत्नी तथा उनकी बहुएं सब बाहर आ गईं. ");
INSERT INTO hincv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","सभी पशु, रेंगनेवाले जंतु, सभी पक्षी—सभी प्राणी जो पृथ्वी पर रेंगते हैं, जहाज़ से बाहर आ गये. ");
INSERT INTO hincv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","फिर नोहा ने याहवेह के लिए एक वेदी बनाई और हर एक शुद्ध पशु तथा हर एक शुद्ध पक्षी में से वेदी पर होमबलि चढ़ाई. ");
INSERT INTO hincv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","और याहवेह बलिदान की सुगंध से प्रसन्‍न हुए और खुद से कहा, “अब मैं मनुष्य के कारण पृथ्वी को शाप नहीं दूंगा. यद्यपि मानव छोटी उम्र से ही बुरी बातें सोचता है; इसलिये जैसा मैंने अभी किया है इस तरह मैं अब कभी भी सारे प्राणियों को नाश नहीं करूंगा. ");
INSERT INTO hincv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“जब तक पृथ्वी है, फसल उगाना तथा काटना, ठंड एवं गर्मी, धूपकाल और शीतकाल, दिन और रात अखंड होते रहेंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","तब परमेश्वर ने नोहा तथा उनके पुत्रों को यह आशीष दी, “फूलो फलो और पृथ्वी में भर जाओ. ");
INSERT INTO hincv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","पृथ्वी के हर एक पशु एवं आकाश के हर एक पक्षी पर, भूमि पर रेंगनेवाले जंतु पर तथा समुद्र की समस्त मछलियों पर तुम्हारा भय बना रहेगा—ये सभी तुम्हारे अधिकार में कर दिए गए हैं. ");
INSERT INTO hincv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","सब चलनेवाले जंतु, जो जीवित हैं, तुम्हारा आहार होंगे; इस प्रकार मैं तुम्हें सभी कुछ दे रहा हूं, जिस प्रकार मैंने तुम्हें पेड़ पौधे दिए. ");
INSERT INTO hincv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“एक बात का ध्यान रखना कि मांस को लहू के साथ मत खाना. ");
INSERT INTO hincv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","मैं तुम्हारे जीवन, अर्थात् लहू, का बदला ज़रूर लूंगा. मैं उस जानवर का जीवन मांगूंगा जो किसी व्यक्ति को मारेगा. प्रत्येक मनुष्य से दूसरे मनुष्य के खून का बदला ज़रूर लूंगा. ");
INSERT INTO hincv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“जो कोई मनुष्य का रक्त बहाएगा, मनुष्य द्वारा ही उसका रक्त बहाया जाएगा; क्योंकि परमेश्वर ने अपने रूप में मनुष्य को बनाया है. ");
INSERT INTO hincv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","अब तुम पृथ्वी में रहो; फूलो फलो और बढ़ो और बस जाओ.” ");
INSERT INTO hincv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","फिर परमेश्वर ने नोहा तथा उनके पुत्रों से कहा: ");
INSERT INTO hincv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“मैं तुम्हारे वंश के साथ पक्का वायदा करता हूं. ");
INSERT INTO hincv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","यही नहीं किंतु उन सबके साथ जो इस जहाज़ से बाहर आये हैं—पक्षी, पालतू पशु तथा तुम्हारे साथ पृथ्वी के हर एक पशु, से भी वायदा करता हूं. ");
INSERT INTO hincv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","मैं तुम्हारे साथ अपनी इस वाचा को पूरी करूंगा कि अब मैं जलप्रलय के द्वारा सभी प्राणियों और पृथ्वी को कभी नाश नहीं करूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","परमेश्वर ने और कहा, “जो वायदा मैंने तुम्हारे साथ तथा तुम्हारे साथ के जीवित प्राणियों के साथ किया है, यह पीढ़ी से पीढ़ी तक स्थिर रहेगा और ");
INSERT INTO hincv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","इस बात का सबूत तुम बादलों में मेघधनुष के रूप में देखोगे, यही मेरे एवं पृथ्वी के बीच में वाचा का चिन्ह होगा. ");
INSERT INTO hincv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","जब मैं पृथ्वी के ऊपर बादल फैलाऊंगा और बादल में मेघधनुष दिखाई देगा, ");
INSERT INTO hincv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","तब मैं अपने वायदे को याद करूंगा, जो मेरे और तुम्हारे बीच किया गया है कि अब कभी भी दुबारा पृथ्वी को इस तरह जलप्रलय से नाश नहीं करूंगा. ");
INSERT INTO hincv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","जब भी यह मेघधनुष दिखेगा, मैं परमेश्वर और पृथ्वी पर रहनेवाले प्रत्येक प्राणी के बीच की हुई सनातन वाचा को याद करूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","परमेश्वर ने नोहा से कहा, “जो वायदा मैंने अपने तथा पृथ्वी के हर एक जीवधारी के बीच किया है, यही उसका चिन्ह है.” ");
INSERT INTO hincv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","जहाज़ से नोहा के साथ उनके पुत्र शेम, हाम तथा याफेत बाहर आये. (हाम कनान का पिता था.) ");
INSERT INTO hincv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ये नोहा के तीन पुत्र थे तथा इन्हीं के द्वारा फिर से पृथ्वी मनुष्य से भर गई. ");
INSERT INTO hincv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नोहा खेती करना शुरू किए, उन्होंने एक दाख की बारी लगाई. ");
INSERT INTO hincv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","एक दिन नोहा दाखमधु पीकर नशे में हो गये और अपने तंबू में नंगे पड़े थे. ");
INSERT INTO hincv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","कनान के पिता हाम ने अपने पिता को इस हालत में देखकर अपने दोनों भाइयों को बुलाया. ");
INSERT INTO hincv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","शेम तथा याफेत ने एक वस्त्र लिया, और दोनों ने उल्टे पांव चलते हुए अपने पिता के नंगे देह को ढक दिया. इस समय उनके मुख विपरीत दिशा में थे, इसलिये उन्होंने अपने पिता के नंगेपन को न देखा. ");
INSERT INTO hincv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","जब नोहा का नशा उतर गया तब उन्हें पता चला कि उनके छोटे बेटे ने उनके साथ क्या किया है. ");
INSERT INTO hincv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","और नोहा ने कहा, “शापित है कनान! वह अपने भाइयों के दासों का भी दास होगा.” ");
INSERT INTO hincv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","नोहा ने यह भी कहा, “धन्य हैं याहवेह, शेम के परमेश्वर! कनान शेम का ही दास हो जाए. ");
INSERT INTO hincv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","परमेश्वर याफेत के वंश को विस्तृत करे; वह शेम के तंबुओं में रहे, और कनान उसका दास हो जाए.” ");
INSERT INTO hincv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","जलप्रलय के बाद नोहा 350 वर्ष और जीवित रहे. ");
INSERT INTO hincv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","जब नोहा कुल 950 साल जीवित रहे, तब उनकी मृत्यु हो गई. ");
INSERT INTO hincv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","शेम, हाम और याफेत नोहा के पुत्र थे, जलप्रलय के बाद इनकी संतान पैदा हुईं. ");
INSERT INTO hincv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","याफेत के पुत्र: गोमर, मागोग, मेदिया, यावन, तूबल, मेशेख तथा तिरास थे. ");
INSERT INTO hincv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","गोमर के पुत्र: अश्केनाज, रिफात तथा तोगरमाह थे. ");
INSERT INTO hincv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","यावन के पुत्र: एलिशाह, तरशीश, कित्तिम तथा दोदानिम थे. ");
INSERT INTO hincv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(और उनके वंशज मल्लाह बनकर प्रत्येक की अपनी भाषा, गोत्र और राष्ट्र होकर विभिन्‍न देशों में बंट गये.) ");
INSERT INTO hincv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हाम के पुत्र: कूश, मिस्र, पूट तथा कनान हुए. ");
INSERT INTO hincv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","कूश के पुत्र: सेबा, हाविलाह, सबताह, रामाह और सबतेका. रामाह के पुत्र: शीबा और देदान. ");
INSERT INTO hincv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कूश उस निमरोद का पिता था जो पृथ्वी पर पहले वीर व्यक्ति के रूप में मशहूर हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","वह याहवेह की दृष्टि में पराक्रमी, शिकारी था, और ऐसा कहा जाने लगा, “निमरोद के समान याहवेह की दृष्टि में पराक्रमी शिकारी!” ");
INSERT INTO hincv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","उसके राज्य की शुरुआत शीनार देश में, बाबेल, एरेख, अक्काद तथा कालनेह से हुई. ");
INSERT INTO hincv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","वहां से वे अश्शूर में गये, वहां उन्होंने नीनवेह, रेहोबोथ-इर तथा कलाह नगर बनाए. ");
INSERT INTO hincv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","तथा रेसेन नगर को बनाए, जो नीनवेह तथा कलाह के बीच का एक बड़ा नगर है. ");
INSERT INTO hincv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिस्र के पुत्र: लूदिम, अनामिम, लेहाबिम, नाफतुहि, ");
INSERT INTO hincv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","पथरूस, कस्लूह (जिनसे फिलिस्तीनी राष्ट्र निकले) और काफ़तोर ");
INSERT INTO hincv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनान का पहला पुत्र सीदोन, फिर हित्ती, ");
INSERT INTO hincv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","यबूसी, अमोरी, गिर्गाशी, ");
INSERT INTO hincv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिव्वी, आरकी, सीनी, ");
INSERT INTO hincv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अरवादी, ज़ेमारी, हामाथी. (बाद में कनानी परिवार भी बढ़ते गए. ");
INSERT INTO hincv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","कनान के वंश की सीमा सीदोन से होकर गेरार से होती हुई अज्जाह तक थी तथा सोदोम, अमोराह, अदमाह तथा ज़ेबोईम से लाशा तक थी.) ");
INSERT INTO hincv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ये सभी गोत्रों, भाषाओं, देशों तथा उनके राष्ट्रों के अनुसार हाम के वंश में से थे. ");
INSERT INTO hincv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","शेम याफेत के बड़े भाई थे; वे एबर के वंश के गोत्रपिता हुए. ");
INSERT INTO hincv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेम के पुत्र: एलाम, अशहूर, अरफाक्साद, लूद तथा अराम थे. ");
INSERT INTO hincv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अराम के पुत्र: उज़, हूल, गेथर तथा माश थे. ");
INSERT INTO hincv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अरफाक्साद शेलाह का पिता था, शेलाह एबर का. ");
INSERT INTO hincv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","एबर के दो पुत्र हुए: एक का नाम पेलेग अर्थात् बांटना, क्योंकि उनके समय में पृथ्वी का बंटवारा हुआ. उनके भाई का नाम योकतान था. ");
INSERT INTO hincv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","योकतान के पुत्र: अलमोदाद, शेलेफ, हासारमेबेथ, जेराह, ");
INSERT INTO hincv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हादरोम, उजाल, दिखलाह, ");
INSERT INTO hincv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबीमाएल, शीबा, ");
INSERT INTO hincv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओफीर, हाविलाह और योबाब. ये सभी योकतान के पुत्र थे. ");
INSERT INTO hincv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","(ये जहां रहते थे, वहां की सीमा मेषा से लेकर पूर्व के पहाड़ के सेफार तक थी.) ");
INSERT INTO hincv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ये सभी अपने गोत्रों, भाषाओं, देशों तथा राष्ट्रों के अनुसार शेम वंश के थे. ");
INSERT INTO hincv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","अपनी-अपनी संतान और जाति के अनुसार, ये नोहा के बेटों के वंशज हैं. जलप्रलय के बाद, जाति-जाति के लोग इनसे निकलकर पृथ्वी में फैल गए. ");
INSERT INTO hincv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","पूरी पृथ्वी पर एक ही भाषा तथा एक ही बोली थी. ");
INSERT INTO hincv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","उस समय लोग पूर्व दिशा की ओर चलते हुए, शीनार देश में मैदान देखकर रुक गये और वहीं रहने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","वे आपस में कहने लगे, “हम सब मिलकर अच्छी ईंट बनाकर आग में पकायें.” उन्होंने पत्थर के स्थान पर ईंटों का और चुने के स्थान पर मिट्टी के गारे को काम में लिया. ");
INSERT INTO hincv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","और उन्होंने कहा, “आओ, हम अपने लिए एक नगर और मीनार बनाएं; मीनार इतनी ऊंची बनाएं कि आकाश तक जा पहुंचे, ताकि हम प्रसिद्ध हो जाएं. अन्यथा हम सारी पृथ्वी में इधर-उधर हो जायेंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","याहवेह उस नगर तथा मीनार को देखने उतर आए, जिसे लोग बना रहे थे. ");
INSERT INTO hincv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","याहवेह ने सोचा, “ये लोग एक झुंड हैं, इनकी एक ही भाषा है, और इन्होंने सोचकर काम करने की शुरुआत की है; अब आगे भी इस प्रकार और काम करेंगे, तो इनके लिए कोई काम मुश्किल नहीं होगा. ");
INSERT INTO hincv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","आओ, हम उनकी भाषा में गड़बड़ी लाएं ताकि वे एक दूसरे की बात को समझ न सकें.” ");
INSERT INTO hincv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","इस प्रकार याहवेह ने उन्हें अलग कर दिया और वे पृथ्वी पर अलग-अलग जगह पर चले गये और नगर व मीनार का काम रुक गया. ");
INSERT INTO hincv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","इसी कारण इस स्थान का नाम बाबेल पड़ा, क्योंकि यहीं याहवेह ने भाषा में गड़बड़ी डाली थी तथा यहीं से याहवेह ने उन्हें पूरी पृथ्वी पर फैला दिया. ");
INSERT INTO hincv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","शेम के वंश का विवरण यह है: जलप्रलय के दो साल बाद अरफाक्साद का जन्म हुआ तब शेम 100 साल के थे. ");
INSERT INTO hincv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","अरफाक्साद के जन्म के बाद शेम 500 वर्ष और जीवित रहे. इनके अतिरिक्त उनके और पुत्र-पुत्रियां पैदा हुईं. ");
INSERT INTO hincv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","जब अरफाक्साद 35 साल के हुए, तब शेलाह का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","शेलाह के जन्म के बाद अरफाक्साद 403 वर्ष और जीवित रहे तथा उनके और पुत्र-पुत्रियां पैदा हुईं. ");
INSERT INTO hincv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","जब शेलाह 30 वर्ष के हुए, तब एबर का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","एबर के जन्म के बाद शेलाह 403 वर्ष और जीवित रहे तथा उनके और पुत्र-पुत्रियां पैदा हुईं. ");
INSERT INTO hincv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","जब एबर 34 वर्ष के हुए, तब पेलेग का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","पेलेग के जन्म के बाद एबर 430 वर्ष और जीवित रहे तथा उनके और पुत्र-पुत्रियां पैदा हुईं. ");
INSERT INTO hincv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","जब पेलेग 30 वर्ष के हुए, तब रेउ का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","रेउ के जन्म के बाद पेलेग 209 वर्ष और जीवित रहे तथा उनके और पुत्र-पुत्रियां पैदा हुईं. ");
INSERT INTO hincv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","जब रेउ 32 वर्ष के हुए, तब सेरुग का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","सेरुग के जन्म के बाद रेउ 207 वर्ष और जीवित रहे तथा उनके और पुत्र-पुत्रियां पैदा हुईं. ");
INSERT INTO hincv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","जब सेरुग 30 वर्ष के हुए, तब नाहोर का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","नाहोर के जन्म के बाद सेरुग 200 वर्ष और जीवित रहे तथा उनके और पुत्र-पुत्रियां पैदा हुईं. ");
INSERT INTO hincv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","जब नाहोर 29 वर्ष के हुए, तब तेराह का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","तेराह के जन्म के बाद नाहोर 119 वर्ष और जीवित रहे तथा उनके और पुत्र-पुत्रियां पैदा हुईं. ");
INSERT INTO hincv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","जब तेराह 70 वर्ष के हुए, तब अब्राम, नाहोर तथा हारान का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेराह के वंशज ये हैं: तेराह से अब्राम, नाहोर तथा हारान का जन्म हुआ; हारान ने लोत को जन्म दिया. ");
INSERT INTO hincv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","हारान की मृत्यु उनके पिता के जीवित रहते उसकी जन्मभूमि कसदियों के ऊर में हुई. ");
INSERT INTO hincv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राम तथा नाहोर ने विवाह किया. अब्राम की पत्नी का नाम सारय तथा नाहोर की पत्नी का नाम मिलकाह था, जो हारान की पुत्री थी. हारान की अन्य पुत्री का नाम यिसकाह था. ");
INSERT INTO hincv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","सारय बांझ थी. उनकी कोई संतान न थी. ");
INSERT INTO hincv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","तेराह ने अपने पुत्र अब्राम तथा अपने पोते लोत को, जो हारान का पुत्र था तथा अब्राम की पत्नी सारय को अपने साथ लिया और वे सब कसदियों के ऊर से हारान नामक जगह पहुंचे और वहीं रहने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","हारान में तेराह की मृत्यु हो गई, तब वे 205 वर्ष के थे. ");
INSERT INTO hincv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","फिर याहवेह ने अब्राम से कहा, “अपने पिता के घर तथा अपने रिश्तेदारों को छोड़कर उस देश को चला जा, जो मैं तुम्हें दिखाऊंगा. ");
INSERT INTO hincv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“मैं तुमसे एक बड़ी जाति बनाऊंगा, मैं तुम्हें आशीष दूंगा; मैं तुम्हारा नाम बड़ा करूंगा, और तुम एक आशीष होंगे. ");
INSERT INTO hincv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","जो तुम्हें आशीष देंगे, मैं उन्हें आशीष दूंगा तथा जो तुम्हें शाप देगा; मैं उन्हें शाप दूंगा. तुमसे ही पृथ्वी के सब लोग आशीषित होंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","इसलिये याहवेह के आदेश के अनुसार अब्राम चल पड़े; लोत भी उनके साथ गये. जब अब्राम हारान से निकले, तब वे 75 वर्ष के थे. ");
INSERT INTO hincv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","अब्राम अपने साथ उनकी पत्नी सारय, उनका भतीजा लोत, उनकी पूरी संपत्ति तथा हारान देश में प्राप्‍त दास और दासियों को लेकर कनान देश पहुंचे. ");
INSERT INTO hincv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","वहां से अब्राम शेकेम में मोरेह के बांज वृक्ष तक पहुंच गए. उस समय उस देश में कनानी लोग रहते थे. ");
INSERT INTO hincv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","याहवेह ने अब्राम को दर्शन दिया और कहा, “तुम्हारे वंश को मैं यह देश दूंगा.” तब अब्राम ने उस स्थान पर याहवेह के सम्मान में, जो उन पर प्रकट हुए थे, एक वेदी बनाई. ");
INSERT INTO hincv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","फिर अब्राम वहां से बेथेल के पूर्व में पर्वत की ओर बढ़ गए, वहीं उन्होंने तंबू खड़े किए. उनके पश्चिम में बेथेल तथा पूर्व में अय नगर थे. अब्राम ने वहां याहवेह के सम्मान में वेदी बनाई और आराधना की. ");
INSERT INTO hincv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","वहां से अब्राम नेगेव की ओर बढ़े. ");
INSERT INTO hincv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","उस देश में अकाल पड़ा, तब अब्राम कुछ समय के लिये मिस्र देश में रहने के लिये चले गए, क्योंकि उनके देश में भयंकर अकाल पड़ा था. ");
INSERT INTO hincv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","जब वे मिस्र देश के पास पहुंचे, तब अब्राम ने अपनी पत्नी सारय से कहा, “सुनो, मुझे मालूम है कि तुम एक सुंदर स्त्री हो. ");
INSERT INTO hincv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","जब मिस्र के लोगों को यह पता चलेगा कि तुम मेरी पत्नी हो, तो वे मुझे मार डालेंगे और तुम्हें जीवित छोड़ देंगे. ");
INSERT INTO hincv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","इसलिये तुम यह कहना कि तुम मेरी बहन हो, ताकि तुम्हारे कारण मेरी भलाई हो और वे मुझे नहीं मारें.” ");
INSERT INTO hincv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","जब अब्राम मिस्र देश पहुंचे, तब मिस्रियों ने सारय को देखा कि वह बहुत सुंदर है. ");
INSERT INTO hincv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","और फ़रोह के अधिकारियों ने भी सारय को देखा, तो उन्होंने फ़रोह को उसकी सुंदरता के बारे में बताया और सारय को फ़रोह के महल में लाया गया. ");
INSERT INTO hincv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","फ़रोह ने सारय के कारण अब्राम के साथ अच्छा व्यवहार किया. उसने उसे भेड़ें, बैल, गधे-गधियां, ऊंट तथा दास-दासियां दिए. ");
INSERT INTO hincv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","पर याहवेह ने अब्राम की पत्नी सारय के कारण फ़रोह तथा उसके घर पर बड़ी-बड़ी विपत्तियां डाली. ");
INSERT INTO hincv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","इसलिये फ़रोह ने अब्राम को बुलवाया और उनसे कहा, “तुमने मेरे साथ यह क्या किया? तुमने मुझसे यह बात क्यों छिपाई कि यह तुम्हारी पत्नी है? ");
INSERT INTO hincv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","तुमने यह क्यों कहा, ‘यह मेरी बहन है’? इस कारण मैंने उसे अपनी पत्नी बनाने के उद्देश्य से अपने महल में रखा! इसलिये अब तुम उसे अपने साथ लेकर यहां से चले जाओ!” ");
INSERT INTO hincv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","तब फ़रोह ने अपने अधिकारियों को अब्राम के बारे में आदेश दिया और उन्होंने अब्राम को उनकी पत्नी और उनकी सब संपत्ति के साथ विदा किया. ");
INSERT INTO hincv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","अब्राम अपनी पत्नी, सारी संपत्ति और लोत को लेकर कनान देश के नेगेव में आए. ");
INSERT INTO hincv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राम के पास बहुत पशु, सोने तथा चांदी होने के कारण वे बहुत धनी हो गये थे. ");
INSERT INTO hincv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","वे नेगेव से बेथेल तक पहुंच गए, जहां वे पहले रहते थे अर्थात् बेथेल तथा अय के बीच में. ");
INSERT INTO hincv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","और जहां उन्होंने पहले एक वेदी बनाई थी वहां अब्राम ने याहवेह से प्रार्थना की. ");
INSERT INTO hincv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","लोत के पास भी बहुत भेड़-बकरियां और पशु थे. उन्होंने भी अब्राम के पास अपने तंबू लगाए. ");
INSERT INTO hincv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","पर ज़मीन की कमी के कारण वे दोनों एक साथ न रह पा रहे थे क्योंकि उनके पास बहुत अधिक संपत्ति थी. ");
INSERT INTO hincv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","और अब्राम तथा लोत के चरवाहों के बीच आपस में लड़ाई हो जाती थी. और उस समय उस देश में कनानी एवं परिज्ज़ी लोग भी रहते थे. ");
INSERT INTO hincv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","इसलिये अब्राम ने लोत से कहा, “हम दोनों के बीच और हमारे चरवाहों के बीच झगड़ा न हो, क्योंकि हम एक ही परिवार के हैं. ");
INSERT INTO hincv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","इसलिये हम दोनों अलग हो जाते हैं. यदि तुम बायीं दिशा में जाना चाहते हो, तो मैं दायीं ओर चला जाऊंगा और यदि तुम दायीं दिशा में जाना चाहते हो, तो मैं बायीं ओर चला जाऊंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","लोत ने यरदन नदी व उसके आस-पास की हरियाली को देखा; वह चारों तरफ फैली थी और ज़ोअर की दिशा में यरदन नदी भी पानी से भरी थी. वह याहवेह का बगीचा, और मिस्र देश के समान उपजाऊ थी. (यह याहवेह के द्वारा सोदोम व अमोराह को नाश करने के पहले की बात है.) ");
INSERT INTO hincv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","इसलिये लोत ने यरदन घाटी को जो, पूर्व दिशा की ओर है, चुन लिया. इस प्रकार लोत तथा अब्राम एक दूसरे से अलग हो गए. ");
INSERT INTO hincv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम कनान देश में बस गए तथा लोत यरदन घाटी के नगरों में. लोत ने अपने तंबू सोदोम नगर के निकट खड़े किए. ");
INSERT INTO hincv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सोदोम के पुरुष दुष्ट थे और याहवेह की दृष्टि में वे बहुत पापी थे. ");
INSERT INTO hincv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","लोत से अब्राम के अलग होने के बाद याहवेह ने अब्राम से कहा, “तुम जिस स्थान पर खड़े हो, वहां से चारों ओर देखो. ");
INSERT INTO hincv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","क्योंकि यह सारी भूमि, जो तुम्हें दिख रही है, मैं तुम्हें तथा तुम्हारे वंश को हमेशा के लिए दूंगा. ");
INSERT INTO hincv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","मैं तुम्हारे वंश को भूमि की धूल के कण के समान असंख्य बना दूंगा, तब यदि कोई इन कणों को गिन सके, तो तुम्हारे वंश को भी गिन पायेगा. ");
INSERT INTO hincv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","अब उठो, इस देश की लंबाई और चौड़ाई में चलो फिरो, क्योंकि यह मैं तुम्हें दूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","इसलिये अब्राम ने हेब्रोन में ममरे के बांज वृक्ष के पास अपने तंबू खड़े किए और उन्होंने वहां याहवेह के लिए एक वेदी बनाई. ");
INSERT INTO hincv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","शीनार देश के राजा अमराफेल, एलासार के राजा आरिओख, एलाम के राजा खेदोरलाओमर और गोईम के राजा तिदाल ने अपने शासनकाल में, ");
INSERT INTO hincv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","एकजुट होकर सोदोम के राजा बेरा, अमोराह के राजा बिरशा, अदमाह के राजा शीनाब, ज़ेबोईम के राजा शेमेबेर तथा बेला (अर्थात् ज़ोअर) के राजा के विरुद्ध युद्ध छेड़ दिया. ");
INSERT INTO hincv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ये सभी एक साथ होकर सिद्दिम घाटी (अर्थात् लवण-सागर) के पास इकट्‍ठे हो गए. ");
INSERT INTO hincv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","बारह वर्ष तक तो वे खेदोरलाओमर के अधीन रहे, किंतु तेरहवें वर्ष में उन्होंने विरोध किया. ");
INSERT INTO hincv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","चौदहवें वर्ष में खेदोरलाओमर तथा उसके मित्र राजाओं ने आकर अश्तेरोथ-करनाइम में रेफाइम को, हाम में ज़ुज़ीम को, शावेह-किरयथाईम में एमियों को, ");
INSERT INTO hincv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","तथा सेईर पर्वत में निर्जन प्रदेश के पास एल-पारान तक होरियों को भी हरा दिया. ");
INSERT INTO hincv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","इसके बाद वे मुड़े और एन-मिशपत (अर्थात् कादेश) आ गए और पूरे अमालेकियों को तथा हज़ज़ोन-तामार में रह रहे अमोरियों को भी हरा दिया. ");
INSERT INTO hincv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","तब सोदोम, अमोराह, अदमाह, ज़ेबोईम तथा बेला (अर्थात् ज़ोअर) के राजा बाहर निकल गए और उन्होंने सिद्दिम की घाटी में उनके विरुद्ध युद्ध किया. ");
INSERT INTO hincv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","यह लड़ाई एलाम के राजा खेदोरलाओमर, गोईम के राजा तिदाल, शीनार के राजा अमराफेल तथा एलासार के राजा आरिओख—ये चार राजा उन पांच राजाओं से लड़ रहे थे. ");
INSERT INTO hincv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","सिद्दिम घाटी में सब जगह गड्ढे थे. जब सोदोम तथा अमोराह के राजा युद्ध से भाग रहे थे, तो कुछ लोग गड्ढों में जा गिरे और बाकी बचे लोग पर्वत पर की बस्ती में भाग गए. ");
INSERT INTO hincv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","तब चारों राजाओं ने सोदोम तथा अमोराह से सब कुछ ले लिया और खाने का सब सामान भी ले गए. ");
INSERT INTO hincv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","वे अपने साथ अब्राम के भतीजे लोत एवं उसकी पूरी संपत्ति भी ले गए, क्योंकि लोत उस समय सोदोम में रह रहा था. ");
INSERT INTO hincv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","और युद्ध क्षेत्र से भागकर एक व्यक्ति ने इब्री अब्राम को ये बातें बताई. अब्राम तो उस समय ममरे नामक व्यक्ति, जो अमोरी जाति का था, उसके बड़े बलूत पेड़ों के पास रहता था. ममरे, एशकोल एवं ऐनर का भाई था; और इन्होंने अब्राम से वाचा बांधी थी. ");
INSERT INTO hincv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","जब अब्राम को यह पता चला कि लोत को बंदी बना लिया गया है, तो उसने अपने पूरे परिवार को इकट्ठा किया और 318 जो युद्ध सीखे हुए वीर थे, साथ लेकर दान नामक स्थान तक उनका पीछा किया. ");
INSERT INTO hincv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","रात्रि में अब्राम ने अपने लोगों को उनके ऊपर हमला करने के लिये बांट दिया और अब्राम तथा उनके सेवकों ने उन्हें पराजित कर दिया तथा दमेशेक के उत्तर में स्थित होबाह नगर तक उनका पीछा किया. ");
INSERT INTO hincv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","अब्राम ने उन लोगों से सब सामान वापस ले लिया और लोत, उसके सभी लोग और उसकी संपत्ति भी उनसे ले ली. ");
INSERT INTO hincv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","जब अब्राम खेदोरलाओमर तथा उनके मित्र राजाओं को हरा कर लौट रहे थे, सोदोम का राजा शावेह घाटी (जिसे राजा की घाटी भी कहा जाता है) में अब्राम से मिलने आया. ");
INSERT INTO hincv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","शालेम के राजा मेलखीज़ेदेक, जो परमेश्वर के पुरोहित थे, भोजन एवं दाखरस लेकर आये. ");
INSERT INTO hincv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","उन्होंने अब्राम को आशीष देते हुए कहा, “स्वर्ग और पृथ्वी को बनानेवाले, परम प्रधान परमेश्वर की ओर से तुम धन्य हो, ");
INSERT INTO hincv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","धन्य हैं परम प्रधान परमेश्वर, जिन्होंने आपके शत्रुओं को आपके अधीन कर दिया है.” अब्राम ने मेलखीज़ेदेक को सबका दशमांश दिया. ");
INSERT INTO hincv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","सोदोम के राजा ने अब्राम से कहा, “मुझे इन्सानों को दे दीजिए, सामान सब आप रख लीजिए.” ");
INSERT INTO hincv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","सोदोम के राजा को अब्राम ने उत्तर दिया, “मैंने स्वर्ग और पृथ्वी के अधिकारी, याहवेह परमेश्वर के सामने शपथ ली है, ");
INSERT INTO hincv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","कि मैं आपकी संपत्ति में से एक भी वस्तु, यहां तक कि एक धागा या जूती का बंधन तक न लूंगा, ताकि इन चीज़ों को देकर आप यह न कहने लगें, ‘मैंने अब्राम को धनी बनाया है.’ ");
INSERT INTO hincv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","मैं आपसे कुछ नहीं लूंगा पर सिर्फ खाना, जिसे मेरे लोगों ने खा लिया है और उनका हिस्सा, जो मेरे साथ गये थे याने ऐनर, एशकोल तथा ममरे का हिस्सा, मैं आपको नहीं लौटाऊंगा. उन्हें उनके हिस्सा रखने दीजिये.” ");
INSERT INTO hincv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","इन बातों के बाद अब्राम को एक दर्शन में याहवेह का यह संदेश मिला: “अब्राम, भयभीत न हो, मैं तुम्हारी ढाल, और तुम्हारा सबसे बड़ा प्रतिफल हूं.” ");
INSERT INTO hincv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","अब्राम ने उत्तर दिया, “हे प्रभु याहवेह, आप मुझे क्या दे सकते हैं, क्योंकि मेरी कोई संतान नहीं है, और मेरा वारिस दमेशेक का एलिएज़र होगा?” ");
INSERT INTO hincv_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","अब्राम ने यह भी कहा, “आपकी ओर से तो मुझे कोई संतान नहीं मिली; इसलिये मेरे घर में एक सेवक मेरा वारिस होगा.” ");
INSERT INTO hincv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","तब अब्राम के पास याहवेह का यह वचन आया, “तुम्हारा वारिस यह दास नहीं, परंतु एक पुत्र जो तुम्हारा ही मांस और खून है, तुम्हारा वारिस होगा.” ");
INSERT INTO hincv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","याहवेह अब्राम को बाहर ले गए और अब्राम से कहने लगे, “आकाश की ओर देखो. और तारों की गिनती करो.” याहवेह ने अब्राम से कहा, “ऐसे ही तुम्हारा वंश होगा, जिनको कोई गिन नहीं पायेगा.” ");
INSERT INTO hincv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","अब्राम ने याहवेह पर विश्वास किया; याहवेह ने इस बात को उसकी धार्मिकता मानी. ");
INSERT INTO hincv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","याहवेह ने अब्राम को आश्वासन दिया “मैं वही याहवेह हूं, जिसने तुम्हें कसदियों के ऊर नगर से बाहर निकाला, ताकि तुम्हें यह देश मिले और तुम इस देश पर अधिकार करे.” ");
INSERT INTO hincv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","अब्राम ने कहा, “हे प्रभु याहवेह, मैं कैसे जानूं कि आप मुझे यह देश देंगे?” ");
INSERT INTO hincv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","इसलिये परमेश्वर ने अब्राम से कहा, “मेरे लिए तीन वर्ष की एक कलोर, तीन वर्ष की एक बकरी, तीन वर्ष का एक मेढ़ा, एक पिण्डुक तथा एक कबूतर का बच्चा ले आओ.” ");
INSERT INTO hincv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","अब्राम याहवेह के लिए ये सब ले आए, इन सभी चीज़ों को काटकर दो-दो टुकड़े किए तथा हर एक टुकड़े को आमने-सामने रख दिये, पर उन्होंने पक्षियों के टुकड़े नहीं किए. ");
INSERT INTO hincv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","इन टुकड़ों को देख गिद्ध नीचे उतर आए, किंतु अब्राम ने उन्हें भगा दिया. ");
INSERT INTO hincv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","जब सूरज डूब रहा था, तब अब्राम गहरी नींद में सो गए और पूरा अंधेरा हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","तब याहवेह ने अब्राम से कहा, “यह सच है तुम्हारे वंश के लोग पराए देश में परदेशी होकर रहेंगे, जहां उन्हें दास बना लिया जाएगा, और वे उन्हें चार सौ वर्ष तक दुःख देंगे. ");
INSERT INTO hincv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","फिर जिस देश के वे दास होंगे, उस देश के लोगों को मैं दंड दूंगा, फिर तुम्हारे वंश के लोग वहां से बहुत धन लेकर निकलेंगे. ");
INSERT INTO hincv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","पर तुम्हारा अंत बहुत शांति से होगा और तुम अपनी पूरे बुढ़ापे की आयु में अपने पुरखों के पास दफनाए जाओगे. ");
INSERT INTO hincv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","तुम्हारा वंश, चौथी पीढ़ी में यहां फिर लौट आयेगा, क्योंकि अमोरियों का अधर्म अब तक पूरा नहीं हुआ.” ");
INSERT INTO hincv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","शाम ढलकर रात बहुत हो गई थी तब एक अंगीठी जिससे धुआं निकल रहा था और उसमें से एक जलता हुआ पतीला उन टुकड़ों के बीच में से गुजरा. ");
INSERT INTO hincv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","और उसी दिन याहवेह ने अब्राम से एक वाचा बांधी और कहा, “मैं तुम्हारे वंश को मिस्र के नदी से लेकर फरात महानदी तक दूंगा, ");
INSERT INTO hincv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","जो कि केनी, कनिज्ज़ी, कदमोनी, ");
INSERT INTO hincv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्ती, परिज्ज़ी, रेफाइम, ");
INSERT INTO hincv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","अमोरी, कनानी, गिर्गाशी तथा यबूसियों का देश है.” ");
INSERT INTO hincv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब्राम की पत्नी सारय निःसंतान थी. उसकी हागार नामक एक दासी थी, जो मिस्री थी; ");
INSERT INTO hincv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","सारय ने अब्राम से कहा, “मैं तो मां नहीं बन सकती क्योंकि मैं बांझ हूं इसलिये कृपा करके आप मेरी दासी को स्वीकारें, संभवतः उसके द्वारा संतान का सुख पा सकूं.” अब्राम ने सारय के इस बात को मान लिया. ");
INSERT INTO hincv_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","अब्राम को कनान देश में रहते हुए दस साल हो चुके थे. अब्राम की पत्नी सारय ने अपनी दासी हागार को अब्राम की पत्नी होने के लिए उनको सौंप दिया. ");
INSERT INTO hincv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","अब्राम ने हागार के साथ शारीरिक संबंध बनाए; इस प्रकार हागार गर्भवती हुई तब हागार सारय को तुच्छ समझने लगी. ");
INSERT INTO hincv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","सारय ने अब्राम से कहा, “मेरे साथ हो रहे उपद्रव का कारण आप हैं. मैंने अपनी दासी को केवल वारिस पाने के लिए आपको सौंपा था लेकिन हागार गर्भवती होते ही मुझे तुच्छ समझने लगी. अब याहवेह ही आपके तथा मेरे बीच न्याय करें.” ");
INSERT INTO hincv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","अब्राम ने सारय से कहा, “सुनो, तुम्हारी दासी पर तुम्हारा ही अधिकार है. तुम जैसा चाहो उसके साथ करो.” तब सारय हागार को तंग करने लगी. हागार परेशान होकर सारय के सामने से भाग गई. ");
INSERT INTO hincv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","जब याहवेह के दूत ने उसे निर्जन प्रदेश में एक सोते के पास देखा जो शूर के मार्ग पर था. ");
INSERT INTO hincv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","तब स्वर्गदूत ने उससे पूछा, “हे सारय की दासी हागार, तुम कहां से आ रही हो? और कहां जा रही हो?” हागार ने उत्तर दिया, “मैं अपनी स्वामिनी सारय के पास से भागकर आई हूं.” ");
INSERT INTO hincv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","याहवेह के दूत ने कहा, “अपनी स्वामिनी के पास वापस चली जाओ और उसके अधीन में रहो.” ");
INSERT INTO hincv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","और याहवेह के दूत ने कहा, “मैं तुम्हारे वंश को बहुत बढाऊंगा, इतना कि उनकी गिनती करना मुश्किल होगा.” ");
INSERT INTO hincv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","याहवेह के दूत ने यह भी कहा: “देखो, तुम गर्भवती होगी और एक पुत्र को जन्म दोगी. उसका नाम तुम इशमाएल रखना, क्योंकि याहवेह ने तुम्हारे रोना सुना है. ");
INSERT INTO hincv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","वह जंगली गधे की प्रकृति का पुरुष होगा; सभी से उसकी दुश्मनी होगी और सबको उससे दुश्मनी होगी, और वह अपने संबंधियों के साथ शत्रुतापूर्ण वातावरण में जीवन व्यतीत करेगा.” ");
INSERT INTO hincv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","तब हागार ने याहवेह का जिन्होंने उससे बात की थी, यह नाम रखा: “अत्ता-एल-रोई,” (अर्थात् आप मुझे देखनेवाला परमेश्वर हैं) उसने यह भी कहा, “मैंने अब उसको देखा है जो मुझे देखता है.” ");
INSERT INTO hincv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","इस घटना के कारण उस कुएं का नाम बएर-लहाई-रोई पड़ा, जो कादेश तथा बेरेद के बीच में है. ");
INSERT INTO hincv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","अब्राम से हागार का एक बेटा हुआ तथा अब्राम ने हागार से जन्मे अपने इस बेटे का नाम इशमाएल रखा. ");
INSERT INTO hincv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","अब्राम छियासी वर्ष के थे, जब इशमाएल पैदा हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","जब अब्राम निन्यानबे वर्ष के हुए तब याहवेह उन पर प्रकट हुए और उनसे कहा, “मैं सर्वशक्तिमान परमेश्वर हूं; तुम मेरे सामने विश्वासयोग्यता से चलो और निर्दोष रहो. ");
INSERT INTO hincv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","मैं अपने और तुम्हारे बीच अपना करार स्थापित करूंगा और तुम्हारे वंश को बहुत बढ़ाऊंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","तब अब्राम ने झुककर परमेश्वर को प्रणाम किया और परमेश्वर ने उनसे कहा, ");
INSERT INTO hincv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“तुम्हारे साथ मेरी वाचा यह है: तुम अनेक जातियों के गोत्रपिता होंगे. ");
INSERT INTO hincv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","अब से तुम्हारा नाम अब्राम न रहेगा, पर अब्राहाम होगा; क्योंकि मैंने तुम्हें अनेक जातियों का गोत्रपिता बनाया है. ");
INSERT INTO hincv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","मैं तुम्हें बहुत फलवंत करूंगा; तुम्हें जाति-जाति का मूल बनाऊंगा, और तुम्हारे वंश में राजा पैदा होंगे. ");
INSERT INTO hincv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","मैं तेरे और आनेवाले तेरे वंश के साथ पीढ़ी-पीढ़ी की यह वाचा बांधूंगा कि मैं तुम्हारा और तुम्हारे बाद तुम्हारे वंश का परमेश्वर रहूंगा. ");
INSERT INTO hincv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","यह कनान देश, जिसमें तुम पराये होकर रहते हो, यह देश तुमको और तुम्हारे बाद तुम्हारे वंशजों को सदाकाल के लिये अधिकार में दे दूंगा; और मैं उनका परमेश्वर रहूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","परमेश्वर ने अब्राहाम से फिर कहा, “तुम और तुम्हारे बाद तुम्हारे वंश के लोग मेरी वाचा को सच्चाई से मानते रहना. ");
INSERT INTO hincv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","तुम्हारे और तुम्हारे बाद तुम्हारे वंश के साथ मेरी वाचा यह है, जिसे तुम्हें मानना ज़रूरी है: तुम्हारे बीच में प्रत्येक पुरुष का ख़तना किया जाये. ");
INSERT INTO hincv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","और यह ख़तना तुम्हारे खलड़ी (त्वचा) का किया जाये. यही मेरे एवं तुम्हारे बीच की गई वाचा का चिन्ह होगा. ");
INSERT INTO hincv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","तुम्हारे वंश में सभी पीढ़ियों में हर लड़के के आठ दिन के होने पर उसका ख़तना करना, तुम्हारे घर का वह सेवक जिसका जन्म तुम्हारे घर में हुआ है अथवा जिसे किसी परदेशी से मूल्य देकर खरीदा गया हो, चाहे वे तुम्हारे वंश में से न हों. ");
INSERT INTO hincv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","तुम्हारे घर में पैदा हुए हों या फिर पैसा देकर खरीदे गये हों, उन सबका ख़तना करना ज़रूरी है. तुम्हारे मांस में मेरी यह वाचा सदाकाल की वाचा है. ");
INSERT INTO hincv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","परंतु जो पुरुष बिना ख़तना किए रहेगा, उसे समाज से अलग कर दिया जाएगा, क्योंकि उसने मेरी वाचा को तोड़ा है.” ");
INSERT INTO hincv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","परमेश्वर ने अब्राहाम से यह भी कहा, “तुम्हारी पत्नी सारय को तुम अब सारय नहीं कहना; परंतु अब उसका नाम साराह होगा. ");
INSERT INTO hincv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","मैं उसे आशीष दूंगा और मैं तुम्हें उसके द्वारा एक बेटा दूंगा. मैं उसे आशीष दूंगा. जिससे वह जाति-जाति की मूलमाता होगी; और राजाओं का जन्म उसके वंश में होगा.” ");
INSERT INTO hincv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","यह सुनकर अब्राहाम ने झुककर प्रणाम किया; वह हंसने लगा और मन में कहने लगा, “क्या सौ साल के व्यक्ति से बेटा पैदा हो सकता है? साराह, जो नब्बे साल की है, क्या वह बेटा जन्म दे सकती है?” ");
INSERT INTO hincv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","और अब्राहाम ने परमेश्वर से कहा, “अच्छा हो कि इशमाएल आपसे आशीष पाये!” ");
INSERT INTO hincv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","तब परमेश्वर ने अब्राहाम से कहा, “नहीं! तुम्हारी पत्नी साराह से एक बेटा होगा, और तुम उसका नाम यित्सहाक रखना. मैं उसके साथ ऐसी वाचा बांधूंगा, जो उसके बाद आनेवाली पीढ़ी-पीढ़ी तक सदाकाल की वाचा होगी. ");
INSERT INTO hincv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","और इशमाएल के बारे में, मैंने तुम्हारी बात सुनी है: मैं उसे ज़रूर आशीष दूंगा; मैं उसे फलवंत करूंगा और उसको संख्या में बहुत बढ़ाऊंगा. वह बारह शासकों का पिता होगा, और मैं उससे एक बड़ी जाति बनाऊंगा. ");
INSERT INTO hincv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","परंतु मैं अपनी वाचा यित्सहाक के साथ बांधूंगा, जिसे साराह तेरे लिए अगले साल इसी समय जन्म देगी.” ");
INSERT INTO hincv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","जब परमेश्वर अब्राहाम से अपनी बात कह चुके, तब वे चले गए. ");
INSERT INTO hincv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","तब अब्राहाम ने उसी दिन परमेश्वर के आदेश के अनुसार अपने पुत्र इशमाएल तथा अपने उन सेवकों का, जिनका जन्म उनके परिवार में हुआ था या जिन्हें अब्राहाम ने धन देकर खरीदा था, परिवार के हर एक पुरुष लेकर परमेश्वर के कहे अनुसार उनका ख़तना किया. ");
INSERT INTO hincv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","अब्राहाम के खलड़ी के खतने के समय उनकी उम्र निन्यानवे वर्ष थी, ");
INSERT INTO hincv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","और खतने के समय उनका पुत्र इशमाएल तेरह वर्ष का था. ");
INSERT INTO hincv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","अब्राहाम तथा उनके पुत्र इशमाएल का ख़तना एक ही दिन किया गया. ");
INSERT INTO hincv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","और उनके परिवार के सब पुरुष, जो उनके घर में पैदा हुए थे अथवा जो किसी विदेशी से धन देकर खरीदे गये थे, उन सबका ख़तना उनके साथ किया गया. ");
INSERT INTO hincv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","याहवेह ने ममरे के बांज वृक्षों के पास अब्राहाम को दर्शन दिया, तब अब्राहाम दिन की कड़ी धूप में अपने तंबू के द्वार पर बैठे हुए थे. ");
INSERT INTO hincv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","अब्राहाम ने आंखें ऊपर उठाकर देखा कि उनके सामने तीन व्यक्ति खड़े हैं. जब उन्होंने इन व्यक्तियों को देखा, तब वे उनसे मिलने के लिये तंबू के द्वार से दौड़कर उनके पास गए, और झुककर उनको प्रणाम किया. ");
INSERT INTO hincv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","अब्राहाम ने उनसे कहा, “मेरे स्वामी, यदि मुझ पर आपकी कृपादृष्टि हो, तो अपने सेवक के यहां रुके बिना न जाएं. ");
INSERT INTO hincv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","आप इस पेड़ के नीचे बैठिये, मैं पानी लेकर आता हूं, ताकि आप अपने पांव धो सकें.” ");
INSERT INTO hincv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","मैं आपके लिए भोजन तैयार करता हूं, ताकि आप खाकर तरो ताजा हो सकें और फिर अपनी आगे की यात्रा में जाएं—क्योंकि आप अपने सेवक के यहां आए हैं. उन्होंने अब्राहाम से कहा, “वैसा ही करो, जैसा कि तुमने कहा है.” ");
INSERT INTO hincv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","अब्राहाम जल्दी तंबू में साराह के पास गए और कहा, “तुरंत, तीन माप मैदा गूंधकर कुछ रोटियां बनाओ.” ");
INSERT INTO hincv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","अब्राहाम दौड़कर अपने गाय-बैल के झुंड के पास गए और एक कोमल अच्छा बछड़ा छांट कर अपने सेवक को दिया और उससे कहा, जल्दी से खाना तैयार करो. ");
INSERT INTO hincv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","फिर अब्राहाम ने दही, दूध तथा बछड़ा जो तैयार करवाया था, उनको खिलाया. जब वे तीनों भोजन कर रहे थे, अब्राहाम पेड़ की छाया में उनके पास खड़े रहे. ");
INSERT INTO hincv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","उन्होंने अब्राहाम से पूछा, “तुम्हारी पत्नी साराह कहां है?” अब्राहाम ने कहा, “वह तंबू में है.” ");
INSERT INTO hincv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","इस पर उनमें से एक ने कहा, “अगले वर्ष, इसी वसन्त ऋतु समय में, मैं निश्चय वापस आऊंगा, तब तुम्हारी पत्नी साराह पुत्रवती होगी.” अब्राहाम की पीठ तंबू की ओर थी, और तंबू के द्वार पर साराह यह बात सुन रही थी. ");
INSERT INTO hincv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","अब्राहाम तथा साराह बहुत बूढ़े थे, और साराह बच्चा पैदा करने की उम्र को पार कर चुकी थी. ");
INSERT INTO hincv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","इसलिये साराह मन ही मन हंसते हुए सोचने लगी, “मैं कमजोर हो चुकी और मेरे स्वामी बहुत बूढ़े है, अब क्या यह खुशी हमारे जीवन में आयेगी?” ");
INSERT INTO hincv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","तब याहवेह ने अब्राहाम से प्रश्न किया, “साराह यह कहकर क्यों हंस रही है कि क्या मैं वास्तव में एक बच्‍चे को जन्म दूंगी, जबकि मैं तो एक बूढ़ी हूं? ");
INSERT INTO hincv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","क्या याहवेह के लिए कोई काम कठिन है? मैं अगले साल इसी निर्धारित समय तुमसे मिलने आऊंगा, तब साराह पुत्रवती होगी.” ");
INSERT INTO hincv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","तब साराह डर गयी, और यह कहकर झूठ बोलने लगी, “मैं नहीं हंसी थी.” तब परमेश्वर के दूत ने कहा, “तुम ज़रूर हंसी थी.” ");
INSERT INTO hincv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","इसके बाद वे व्यक्ति जाने के लिए उठे और सोदोम की ओर देखने लगे, अब्राहाम उनको विदा करने के लिए उनके साथ साथ चल रहे थे. ");
INSERT INTO hincv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","तब याहवेह ने सोचा, “जो काम मैं करनेवाला हूं, क्या मैं अब्राहाम से छिपा रखूं? ");
INSERT INTO hincv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","अब्राहाम से तो निश्चय एक बड़ी और सामर्थी जाति होगी तथा उससे ही पृथ्वी की सारी जातियां आशीष पाएंगी ");
INSERT INTO hincv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","क्योंकि मैंने उन्हें इसलिये चुना कि वे अपने बच्चों एवं घर के लोगों को सही और न्याय की बात सिखायें और वे याहवेह के मार्ग में स्थिर रहें, ताकि याहवेह अब्राहाम से किए गए वायदे को पूरा करें.” ");
INSERT INTO hincv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","तब याहवेह ने बताया, “सोदोम तथा अमोराह की चिल्लाहट बढ़ गई है, उनका पाप बहुत बढ़ गया है ");
INSERT INTO hincv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","इसलिये मैं वहां जाकर देखूंगा कि उनके काम उस चिल्लाहट के मुताबिक बुरे हैं या नहीं. यदि नहीं, तो मैं समझ लूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","फिर उनमें से दो व्यक्ति वहां से मुड़कर सोदोम की ओर चले गए, जबकि अब्राहाम याहवेह के सामने रुके रहे. ");
INSERT INTO hincv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","अब्राहाम ने याहवेह से कहा: “क्या आप सचमुच बुरे लोगों के साथ धर्मियों को भी नाश करेंगे? ");
INSERT INTO hincv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","यदि उस नगर में पचास धर्मी हों, तो क्या आप उस नगर को नाश करेंगे? क्या उन पचास धर्मियों के कारण बाकी सब लोग बच नहीं सकते? ");
INSERT INTO hincv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","इस प्रकार का काम करना आपसे दूर रहे—दुष्ट के साथ धर्मी को मार डालना, दुष्ट और धर्मी के साथ एक जैसा व्यवहार करना. ऐसा करना आपसे दूर रहे! क्या सारी पृथ्वी का न्यायी न्याय न करे?” ");
INSERT INTO hincv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","याहवेह ने कहा, “यदि मुझे सोदोम शहर में पचास धर्मी व्यक्ति मिल जाएं, तो मैं उनके कारण पूरे शहर को छोड़ दूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","अब्राहाम ने फिर कहा: “हालाकि मैं केवल मिट्टी और राख हूं, फिर भी मैंने प्रभु से बात करने की हिम्मत की है, ");
INSERT INTO hincv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","यदि वहां पचास में से पांच धर्मी कम हो जायें, तो क्या आप पांच धर्मी कम होने के कारण पूरे नगर का नाश करेंगे?” याहवेह ने उत्तर दिया, “यदि मुझे वहां पैंतालीस भी मिल जाएं, तो मैं उस नगर को नाश नहीं करूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","एक बार फिर अब्राहाम ने याहवेह से कहा, “यदि वहां चालीस ही धर्मी पाए जाएं तो?” याहवेह ने उत्तर दिया, “उन चालीस के कारण भी मैं नाश न करूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","तब अब्राहाम ने कहा, “प्रभु, आप मुझ पर नाराज न होएं, पर मुझे बोलने दें. यदि वहां तीस ही धर्मी पाए जाएं तो?” याहवेह ने उत्तर दिया, “यदि मुझे वहां तीस भी मिल जाएं, तो मैं नाश न करूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","अब्राहाम ने कहा, “प्रभु, मैंने आपसे बात करने की हिम्मत तो कर ही ली है; यह भी हो सकता है कि वहां बीस ही पाए जाएं तो?” याहवेह ने उत्तर दिया, “मैं उन बीस के कारण उस नगर को नाश न करूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","फिर अब्राहाम ने कहा, “हे प्रभु, आप क्रोधित न हों, आखिरी बार आपसे विनती करता हूं. यदि वहां दस ही पाए जाएं तो?” याहवेह ने उत्तर दिया, “मैं उन दस के कारण उस नगर को नाश न करूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","जब याहवेह अब्राहाम से बात कर चुके, तो वे वहां से चले गये, और अब्राहाम अपने घर वापस चला गया. ");
INSERT INTO hincv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","संध्या होते-होते वे दो स्वर्गदूत सोदोम पहुंचे. इस समय लोत सोदोम के प्रवेश द्वार पर ही बैठे हुए थे. स्वर्गदूतों पर दृष्टि पड़ते ही लोत उनसे भेंटकरने के लिए खड़े हुए और उनको झुककर दंडवत किया. ");
INSERT INTO hincv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","और कहा, “हे मेरे प्रभुओ, आप अपने सेवक के घर पर आएं. आप अपने पैर धोकर रात्रि यहां ठहरें और तड़के सुबह अपनी यात्रा पर आगे जाएं.” किंतु उन्होंने उत्तर दिया, “नहीं, रात तो हम यहां नगर के चौक में व्यतीत करेंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","किंतु लोत उनसे विनतीपूर्वक आग्रह करते रहे. तब वे लोत के आग्रह को स्वीकार कर उसके साथ उसके घर में चले गए. लोत ने उनके लिए भोजन, खमीर रहित रोटी, तैयार की और उन्होंने भोजन किया. ");
INSERT INTO hincv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","इसके पूर्व वे बिछौने पर जाते, नगर के पुरुष, सोदोम के लोगों ने आकर लोत के आवास को घेर लिया, ये सभी युवा एवं वृद्ध नगर के हर एक भाग से आए थे. ");
INSERT INTO hincv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","वे ऊंची आवाज में पुकारकर लोत से कहने लगे, “कहां हैं वे पुरुष, जो आज रात्रि के लिए तुम्हारे यहां ठहरे हुए हैं? उन्हें बाहर ले आओ कि हम उनसे संभोग करें.” ");
INSERT INTO hincv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","लोत बाहर निकले और उन्होंने द्वार को बंद कर ");
INSERT INTO hincv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","उनसे निवेदन किया, “हे मेरे भाइयो, मेरा आग्रह है, ऐसा अनैतिक कार्य न करें. ");
INSERT INTO hincv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","देखिए, मेरी दो बेटियां हैं, जिनका संसर्ग किसी पुरुष से नहीं हुआ है. मैं उन्हें यहां बाहर ले आता हूं. आप उनसे अपनी अभिलाषा पूरी कर लीजिए; बस, इन व्यक्तियों के साथ कुछ न कीजिए, क्योंकि वे मेरे अतिथि हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","किंतु वे चिल्लाने लगे, “पीछे हट! यह परदेशी हमारे मध्य आ बसा है और देखो, अब हमारा शासक बनना चाहता है! हम तुम्हारी स्थिति उन लोगों से भी अधिक दयनीय बना देंगे.” वे लोत पर दबाव डालने लगे और दरवाजे को तोड़ने के लिये आगे बढ़ने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","पर उन अतिथियों ने हाथ बढ़ाकर लोत को आवास के भीतर खींच लिया और द्वार बंद कर दिया. ");
INSERT INTO hincv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","उन अतिथियों ने उन सभी को, जो द्वार पर थे, छोटे से लेकर बड़े तक, अंधा कर दिया, जिसका परिणाम यह हुआ कि द्वार को खोजते-खोजते वे थक गए. ");
INSERT INTO hincv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","तब उन दो अतिथियों ने लोत से कहा, “यहां तुम्हारे और कौन-कौन संबंधी हैं? दामाद, पुत्र तथा तुम्हारी पुत्रियां अथवा इस नगर में तुम्हारे कोई भी रिश्तेदार हो, उन्हें इस स्थान से बाहर ले जाओ, ");
INSERT INTO hincv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","क्योंकि हम इस स्थान को नष्ट करने पर हैं. याहवेह के समक्ष उसके लोगों के विरुद्ध चिल्लाहट इतनी ज्यादा हो गई है कि याहवेह ने हमें इसका सर्वनाश करने के लिए भेजा है.” ");
INSERT INTO hincv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","लोत ने जाकर अपने होनेवाले उन दामादों से बात की, जिनसे उनकी बेटियों की सगाई हो गई थी. उन्होंने कहा, “उठो, यहां से निकल चलो, याहवेह इस नगर का सर्वनाश करने पर हैं!” किंतु लोत के दामादों ने समझा कि वे मजाक कर रहे हैं. ");
INSERT INTO hincv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","जब पौ फटने लगी, तब उन स्वर्गदूतों ने लोत से आग्रह किया, “उठो! अपनी पत्नी एवं अपनी दोनों पुत्रियों को, जो इस समय यहां हैं, अपने साथ ले लो, कहीं तुम भी नगर के साथ उसके दंड की चपेट में न आ जाओ.” ");
INSERT INTO hincv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","किंतु लोत विलंब करते रहे. तब उन अतिथियों ने उनका, उनकी पत्नी तथा उनकी दोनों पुत्रियों का हाथ पकड़कर उन्हें सुरक्षित बाहर ले गये, क्योंकि याहवेह की दया उन पर थी. ");
INSERT INTO hincv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","जब वे उन्हें बाहर ले आए, तो उनमें से एक ने उन्हें आदेश दिया, “अपने प्राण बचाकर भागो! पलट कर मत देखना तथा मैदान में कहीं मत रुकना! पहाड़ों पर चले जाओ, अन्यथा तुम सभी इसकी चपेट में आ जाओगे.” ");
INSERT INTO hincv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","किंतु लोत ने उनसे आग्रह किया, “हे मेरे प्रभुओ, ऐसा न करें! ");
INSERT INTO hincv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","जब आपके सेवक ने आपकी कृपादृष्टि प्राप्‍त कर ही ली है और आपने मेरे जीवन को सुरक्षा प्रदान करने के द्वारा अपनी प्रेममय कृपा को बढ़ाया है; तो पर्वतों में जा छिपना मेरे लिए संभव न होगा, क्योंकि इसमें इस महाविनाश से हमारा घिर जाना निश्चित ही है तथा मेरी मृत्यु हो जाएगी. ");
INSERT INTO hincv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","तब देखिए, यहां पास में एक नगर है, जहां दौड़कर जाया जा सकता है और यह छोटा है. कृपया मुझे वहीं जाने की अनुमति दे दीजिए. यह बहुत छोटा नगर भी है. तब मेरा जीवन सुरक्षित रहेगा.” ");
INSERT INTO hincv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","उन्होंने लोत से कहा, “चलो, मैं तुम्हारा यह अनुरोध भी मान लेता हूं; मैं इस नगर को, जिसका तुम उल्लेख कर रहे हो, नष्ट नहीं करूंगा. ");
INSERT INTO hincv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","किंतु बिना देर किए, भागकर वहां चले जाओ, क्योंकि जब तक तुम वहां पहुंच न जाओ, तब तक मैं कुछ नहीं कर सकूंगा.” (इसी कारण उस नगर का नाम ज़ोअर पड़ा.) ");
INSERT INTO hincv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","लोत के ज़ोअर पहुंचते-पहुंचते सूर्योदय हो चुका था. ");
INSERT INTO hincv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","तब याहवेह ने सोदोम तथा अमोराह पर आकाश से गंधक एवं आग की बारिश की. ");
INSERT INTO hincv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","याहवेह ने उन नगरों को, उस संपूर्ण मैदान, भूमि के सभी उत्पादों तथा उन नगरों के सभी निवासियों को पूरी तरह नाश कर दिया. ");
INSERT INTO hincv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","परंतु लोत के पत्नी ने मुड़कर पीछे देखा और परिणामस्वरूप वह नमक का खंभा बन गई. ");
INSERT INTO hincv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","अगले दिन अब्राहाम बड़े सुबह उठे और उस जगह को गये, जहां वे याहवेह के सामने खड़े हुए थे. ");
INSERT INTO hincv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","उन्होंने सोदोम, अमोराह तथा संपूर्ण मैदान की ओर दृष्टि की, तो उन्हें संपूर्ण प्रदेश से धुआं उठता दिखाई दिया, जो ऐसा उठ रहा था, जैसा भट्टी का धुआं. ");
INSERT INTO hincv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","जब परमेश्वर ने मैदान के नगरों का सर्वनाश किया, तो उन्होंने अब्राहाम को याद किया और उन्होंने लोत को उस विपदा में से सुरक्षित बाहर निकाल लिया, उन नगरों को नाश कर दिया, जहां लोत निवास करते थे. ");
INSERT INTO hincv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","लोत अपनी दोनों बेटियों के साथ ज़ोअर को छोड़कर पहाड़ों में रहने चले गये, क्योंकि वह ज़ोअर में रहने से डरते थे. वे और उनकी दोनों बेटियां गुफाओं में रहते थे. ");
INSERT INTO hincv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","एक दिन बड़ी बेटी ने छोटी से कहा, “हमारे पिता तो बूढ़े हो गये हैं और यहां आस-पास ऐसा कोई पुरुष नहीं है, जो हमें बच्चा दे सके—जैसे कि पूरी धरती पर यह रीति है. ");
INSERT INTO hincv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","इसलिये आ, हम अपने पिता को दाखमधु पिलाएं और उनके साथ संभोग करें और अपने पिता के द्वारा अपने परिवार के वंशक्रम आगे बढ़ाएं.” ");
INSERT INTO hincv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","उस रात उन्होंने अपने पिता को दाखमधु पिलाया, और बड़ी बेटी अपने पिता के पास गयी और उसके साथ सोई. लोत को यह पता न चला कि कब वह उसके साथ सोई और कब वह उठकर चली गई. ");
INSERT INTO hincv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","उसके दूसरे दिन बड़ी बेटी ने छोटी से कहा, “कल रात मैं अपने पिता के साथ सोई थी. आ, आज रात उन्हें फिर दाखमधु पिलाएं, तब तुम जाकर उनके साथ सोना, ताकि हम अपने पिता के ज़रिये अपने परिवार के वंशक्रम को आगे बढ़ा सकें.” ");
INSERT INTO hincv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","इसलिये उन्होंने उस रात भी अपने पिता को दाखमधु पिलाया और छोटी बेटी अपने पिता के पास गयी और उसके साथ सोई. लोत को फिर पता न चला कि कब वह उनके साथ सोई और कब वह उठकर चली गई. ");
INSERT INTO hincv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","इस प्रकार लोत की दोनों बेटियां अपने पिता से गर्भवती हुईं. ");
INSERT INTO hincv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","बड़ी बेटी ने एक बेटे को जन्म दिया, और उसने उसका नाम मोआब रखा; वह आज के मोआबी जाति का गोत्रपिता है. ");
INSERT INTO hincv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","छोटी बेटी का भी एक बेटा हुआ, और उसने उसका नाम बेन-अम्मी रखा; वह आज के अम्मोन जाति का गोत्रपिता है. ");
INSERT INTO hincv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","फिर अब्राहाम नेगेव देश की ओर गये तथा कादेश और शूर के बीच में रहने लगे, कुछ समय तक वे गेरार में रहे, ");
INSERT INTO hincv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","और वहां अब्राहाम ने अपनी पत्नी साराह के विषय में कहा, “वह मेरी बहन है.” और गेरार के राजा अबीमेलेक ने साराह को बुलवाया तथा अपने महल में रखा. ");
INSERT INTO hincv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","परंतु एक रात परमेश्वर ने स्वप्न में अबीमेलेक से कहा, “तू एक मृत व्यक्ति की तरह है, क्योंकि जिस स्त्री को तुमने ले लिया है, वह एक विवाहित स्त्री है.” ");
INSERT INTO hincv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","फिर अबीमेलेक ने परमेश्वर से कहा, “हे प्रभु, क्या आप एक निर्दोष जाति को नाश करेंगे? ");
INSERT INTO hincv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","क्या अब्राहाम ने मुझसे नहीं कहा, ‘वह मेरी बहन है,’ और क्या साराह ने भी नहीं कहा, ‘वह मेरा भाई है’? मैंने यह काम साफ विवेक और स्वच्छ मन से किया है.” ");
INSERT INTO hincv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","तब स्वप्न में ही परमेश्वर ने उससे कहा, “मुझे मालूम है कि तुमने यह काम साफ मन से किया है, इसलिये मैंने तुमको मेरे विरुद्ध में पाप करने से रोक रखा है. इसी कारण से मैंने तुम्हें उसे छूने नहीं दिया है. ");
INSERT INTO hincv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","अब तुम उनकी पत्नी को उन्हें लौटा दो, क्योंकि वे एक भविष्यद्वक्ता हैं. वे तुम्हारे लिए प्रार्थना करेंगे और तुम जीवित रहोगे. पर यदि तुम उनकी पत्नी को न लौटाओगे, तो तुम यह निश्चित जान लो कि तुम और तुम्हारे सारे लोग मर जायेंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","अबीमेलेक ने अगले दिन बड़े सुबह अपने सब कर्मचारियों को बुलवाया, और उन्हें सब बातें बताई, जिसे सुनकर वे बहुत डर गये. ");
INSERT INTO hincv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","तब अबीमेलेक ने अब्राहाम को भीतर बुलवाया और उनसे कहा, “तुमने हमसे ये क्या किया? मैंने तुम्हारा क्या बिगाड़ा है कि तुमने मेरे और मेरे राज्य को इस मुसीबत में डाल दिया है? तुमने मेरे साथ ऐसा काम किया है जो कभी नहीं करना चाहिए.” ");
INSERT INTO hincv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","अबीमेलेक ने अब्राहाम से यह भी पूछा, “ऐसा करने का कारण क्या है?” ");
INSERT INTO hincv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्राहाम ने कहा, “मैंने अपने मन में सोचा, ‘इस नगर में निश्चित रूप से कोई परमेश्वर से नहीं डरता, और वे लोग मुझे मेरी पत्नी के कारण मार डालेंगे.’ ");
INSERT INTO hincv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","इसके बावजूद, वह सही में मेरी बहन ही है, मेरे पिता की बेटी है, पर मेरी मां की बेटी नहीं है; और वह मेरी पत्नी हो गई. ");
INSERT INTO hincv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","और जब परमेश्वर ने मुझे अपने पिता का घर छोड़कर निकलने को कहा, तब मैंने ही अपनी पत्नी से यह कहा, ‘तुम इस प्रकार से अपना प्रेम मेरे प्रति दिखा सकती हो: जहां भी हम जाएं, तुम मेरे बारे में यही कहना, “यह मेरा भाई है.” ’ ” ");
INSERT INTO hincv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","तब अबीमेलेक ने भेड़, बछड़े, सेवक तथा सेविकाएं लाकर अब्राहाम को दिया, और उनकी पत्नी साराह को भी उन्हें लौटा दिया. ");
INSERT INTO hincv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","और अबीमेलेक ने अब्राहाम से कहा, “मेरा पूरा देश तुम्हारे सामने है; तुम जहां चाहे, वहां रह सकते हो.” ");
INSERT INTO hincv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","साराह से उसने कहा, “मैं तुम्हारे भाई को चांदी के एक हजार टुकड़े दे रहा हूं. यह तेरे साथ के लोगों के सामने उस अपराध की भरपाई है, जिसे मैंने तेरे विरुद्ध किया है; तू पूरी तरह से निर्दोष है.” ");
INSERT INTO hincv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","तब अब्राहाम ने परमेश्वर से प्रार्थना की, और परमेश्वर ने अबीमेलेक, उसकी पत्नी तथा उसकी सेविकाओं को चंगा किया कि वे फिर से संतान पैदा करने लगें, ");
INSERT INTO hincv_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","क्योंकि याहवेह ने अब्राहाम की पत्नी साराह के कारण अबीमेलेक के परिवार की सभी स्त्रियों की कोखों को बंद कर दिया था. ");
INSERT INTO hincv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","याहवेह ने अपने कहे वचन के मुताबिक साराह पर अनुग्रह किया, और उन्होंने साराह से जो वायदा किया था, उसे पूरा किया. ");
INSERT INTO hincv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","साराह गर्भवती हुई और उसने अब्राहाम के बुढ़ापे में, परमेश्वर के नियुक्त किए गये समय में एक बेटे को जन्म दिया. ");
INSERT INTO hincv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","अब्राहाम ने साराह से जन्मे इस पुत्र का नाम यित्सहाक रखा. ");
INSERT INTO hincv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","जब उसका बेटा यित्सहाक आठ दिन का हुआ, तब अब्राहाम ने परमेश्वर की आज्ञा के अनुसार उसका ख़तना किया. ");
INSERT INTO hincv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","यित्सहाक के जन्म के समय अब्राहाम की आयु एक सौ वर्ष की थी. ");
INSERT INTO hincv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","साराह ने कहा, “मुझे परमेश्वर ने हंसी से भर दिया और जो कोई यह बात सुनेगा, वह भी मेरे साथ हंसेगा.” ");
INSERT INTO hincv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","और उसने यह भी कहा, “अब्राहाम से कौन कहता था कि साराह बच्‍चे को दूध पिला पायेगी? किंतु मैंने उनके बुढ़ापे में उनको एक पुत्र दिया.” ");
INSERT INTO hincv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","साराह का बेटा बड़ा होता गया और उसका दूध छुड़ाया गया, और जिस दिन यित्सहाक का दूध छुड़ाया गया, उस दिन अब्राहाम ने एक बड़ा भोज दिया. ");
INSERT INTO hincv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","पर साराह ने देखा कि मिस्री हागार का बेटा, जो अब्राहाम से जन्मा था, उपहास कर रहा है, ");
INSERT INTO hincv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","तो साराह ने अब्राहाम से कहा, “इस दासी तथा इसके पुत्र को यहां से निकाल दो, क्योंकि इस दासी का पुत्र मेरे पुत्र यित्सहाक के साथ वारिस कभी नहीं हो सकता.” ");
INSERT INTO hincv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","इस बात ने अब्राहाम को बहुत दुखित कर दिया, क्योंकि यह बात अपने पुत्र इशमाएल के सम्‍बन्‍ध में थी. ");
INSERT INTO hincv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","किंतु परमेश्वर ने अब्राहाम से कहा, “उस लड़के और दासी के बारे में सोचकर परेशान मत हो जो कुछ साराह तुमसे कहे, उसे सुन लो क्योंकि तुम्हारे वंशज यित्सहाक के माध्यम से नामित होंगे. ");
INSERT INTO hincv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","दासी के पुत्र से भी मैं एक जाती बनाऊंगा, क्योंकि वह तुम्हारा है.” ");
INSERT INTO hincv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","तब अब्राहाम ने जल्दी उठकर खाना और पानी देकर हागार और उसके पुत्र को वहां से चले जाने को कहा हागार वहां से निकल गई और बेअरशेबा के सुनसान रास्ते में भटकती रही. ");
INSERT INTO hincv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","और जब पानी खत्म हो गया, उसने अपने बेटे को एक झाड़ी की छांव में लेटा दिया. ");
INSERT INTO hincv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","वह स्वयं एक तीर की दूरी में जाकर बैठ गई, क्योंकि वह सोच रही थी, “मैं अपने बेटे का रोना और उसकी परेशानी नहीं देख पाऊंगी.” और वहां बैठते ही वह फूट-फूटकर रोने लगी. ");
INSERT INTO hincv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","परमेश्वर ने उस बेटे का रोना सुना और स्वर्ग से परमेश्वर के दूत ने हागार से पूछा, “हे हागार, क्या हुआ तुम्हें? डरो मत; क्योंकि जहां तेरा बेटा पड़ा है, वहां से परमेश्वर ने उसके रोने को सुन लिया हैं. ");
INSERT INTO hincv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","अब उठो, अपने बेटे को उठाओ, क्योंकि मैं उससे एक बड़ी जाति बनाऊंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","यह कहते हुए परमेश्वर ने हागार को एक कुंआ दिखाया. उसने उस कुएं से पानी लेकर अपने बेटे को पिलाया. ");
INSERT INTO hincv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","वह बेटा परमेश्वर के अनुग्रह से बड़ा हो गया और वह धनुर्धारी बना. ");
INSERT INTO hincv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","वह पारान के निर्जन देश में रहता था. उसकी माता ने उसके लिए मिस्र देश से ही शादी के लिए लड़की ढूंढ़ ली. ");
INSERT INTO hincv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","अबीमेलेक तथा उसकी सेना के सेनापति फीकोल ने अब्राहाम से कहा, “आपके सब कामों में परमेश्वर की आशीष रही है. ");
INSERT INTO hincv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","इसलिये आप हमसे वायदा कीजिये कि आप मुझे, मेरे वंशजों से अथवा मेरी भावी पीढ़ियों से कभी धोखा नहीं करेंगे, लेकिन आप हम सब पर दया करना-जैसा मैंने आपसे किया था.” ");
INSERT INTO hincv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","अब्राहाम ने कहा, “मैं आपसे वायदा करता हूं.” ");
INSERT INTO hincv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","और अब्राहाम ने अबीमेलेक से उस कुएं के विषय में कहा, जिसे अबीमेलेक के सेवकों ने ले लिया था. ");
INSERT INTO hincv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","अबीमेलेक ने उत्तर दिया, “न तो आपने मुझे इसके विषय में कभी बताया, न आज तक मैंने इस विषय में सुना है और न मुझे यह बात मालूम है.” ");
INSERT INTO hincv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","अब्राहाम ने अबीमेलेक को भेंट में भेड़ें एवं बछड़े दिए तथा दोनों ने वायदा किया. ");
INSERT INTO hincv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","फिर अब्राहाम ने सात मेमनों को अलग किया, ");
INSERT INTO hincv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","अबीमेलेक ने अब्राहाम से पूछा, “क्या मतलब है इन सात मेमनों को अलग करने का?” ");
INSERT INTO hincv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","अब्राहाम ने कहा, “कि आप ये सात मेमने लें ताकि यह हमारे बीच सबूत होगा, कि यह कुंआ मैंने खोदा है.” ");
INSERT INTO hincv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","इसलिये अब्राहाम ने उस स्थान का नाम बेअरशेबा रखा, क्योंकि यहां उन दोनों ने यह शपथ ली थी. ");
INSERT INTO hincv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","अतः उन दोनों ने बेअरशेबा में यह वाचा स्थापित की. फिर अबीमेलेक तथा उसका सेनापति फीकोल फिलिस्तिया देश चले. ");
INSERT INTO hincv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","अब्राहाम ने बेअरशेबा में एक झाऊ का पेड़ लगाया और वहां उसने याहवेह, सनातन परमेश्वर की आराधना की. ");
INSERT INTO hincv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","और बहुत समय तक अब्राहाम फिलिस्तिया देश में रहा. ");
INSERT INTO hincv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","कुछ समय के बाद, परमेश्वर ने अब्राहाम की परीक्षा ली. परमेश्वर ने उनसे कहा, “हे अब्राहाम!” उन्होंने उत्तर दिया, “हे प्रभु! मैं यहां हूं.” ");
INSERT INTO hincv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","परमेश्वर ने कहा, “अपने एकलौते पुत्र यित्सहाक को, जो तुम्हें प्रिय है, साथ लेकर मोरियाह देश को जाओ. वहां उसे एक पर्वत पर, जिसे मैं बताऊंगा, होमबलि करके चढ़ाओ.” ");
INSERT INTO hincv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","अगले दिन अब्राहाम ने सुबह जल्दी उठकर अपने गधे पर काठी कसी. उन्होंने अपने साथ दो सेवकों तथा अपने पुत्र यित्सहाक को लिया. जब उन्होंने होमबलि के लिये पर्याप्‍त लकड़ी काट ली, तब वे उस स्थान की ओर चले, जिसके बारे में परमेश्वर ने उन्हें बताया था. ");
INSERT INTO hincv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","तीसरे दिन अब्राहाम ने अपनी आंखें ऊपर उठाईं और दूर से उस जगह को देखा. ");
INSERT INTO hincv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","अब्राहाम ने अपने सेवकों से कहा, “गधे के साथ यहीं रुको. मैं और मेरा बेटा वहां जायेंगे और परमेश्वर की आराधना करके तुम्हारे पास लौट आएंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","अब्राहाम ने होमबलि के लिए तैयार की गई लकड़ियां लीं और यित्सहाक को पकड़ा दिया और स्वयं आग एवं छुरा ले लिया. जब दोनों आगे जा रहे थे, ");
INSERT INTO hincv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","तब यित्सहाक ने अपने पिता अब्राहाम से पूछा, “पिताजी?” अब्राहाम ने उत्तर दिया, “हां, बेटा?” यित्सहाक ने कहा, “आग और लकड़ी तो यहां है, पर होमबलि के लिए मेमना कहां है?” ");
INSERT INTO hincv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहाम ने जवाब दिया, “हे मेरे पुत्र, परमेश्वर खुद होमबलि के लिये मेमने का इंतजाम करेंगे.” और वे दोनों एक साथ आगे बढ़ गये. ");
INSERT INTO hincv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","जब वे उस स्थल पर पहुंचे, जिसे परमेश्वर ने उन्हें बताया था, तब वहां अब्राहाम ने एक वेदी बनाई और उस पर लकड़ियां रखीं. उन्होंने अपने पुत्र यित्सहाक को बांधकर उसे उन लकड़ियों के ऊपर वेदी पर लिटा दिया. ");
INSERT INTO hincv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","फिर अब्राहाम ने अपने बेटे को मार डालने के लिये हाथ में छुरा लिया. ");
INSERT INTO hincv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","पर स्वर्ग से याहवेह के दूत ने उन्हें पुकारकर कहा, “हे अब्राहाम! हे अब्राहाम!” अब्राहाम ने कहा, “हे प्रभु! मैं यहां हूं.” ");
INSERT INTO hincv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","याहवेह ने कहा, “उस लड़के पर हाथ मत उठाओ; उसे कुछ मत करो. अब मुझे यह मालूम हो चुका है कि तुम परमेश्वर का भय मानते हो, क्योंकि तुम मेरे लिये अपने एकलौते पुत्र तक को बलिदान करने के लिये तैयार हो गये.” ");
INSERT INTO hincv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","उसी समय अब्राहाम ने अपनी आंखें ऊपर उठाईं तो झाड़ी में एक मेढ़ा दिखा जिसका सींग झाड़ी में फंसा हुआ था. अब्राहाम जाकर उस मेढ़े को लाए और अपने पुत्र के बदले में उसे होमबलि चढ़ाए. ");
INSERT INTO hincv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","अब्राहाम ने उस जगह का नाम “याहवेह यिरेह” रखा अर्थात् याहवेह उपाय करनेवाले. इसलिये आज भी यह कहा जाता है, “याहवेह के पहाड़ पर उपाय किया जाएगा.” ");
INSERT INTO hincv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","फिर स्वर्ग से याहवेह के दूत ने दूसरी बार अब्राहाम को पुकारकर कहा, ");
INSERT INTO hincv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“याहवेह अपनी ही शपथ खाकर कहते हैं, क्योंकि तुमने यह किया है और अपने एकलौते पुत्र तक को बलिदान करने के लिये तैयार हो गये, ");
INSERT INTO hincv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","तो मैं निश्चचय रूप से तुम्हें आशीष दूंगा और तुम्हारे वंश को आकाश के तारे और समुद्र के बालू के कण के समान अनगिनत करूंगा. तुम्हारा वंश अपने शत्रुओं के शहरों को अपने अधिकार में ले लेगा, ");
INSERT INTO hincv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","और तुम्हारे वंश के ज़रिये पृथ्वी की सारी जातियां आशीष पाएंगी, क्योंकि तुमने मेरी बात को माना है.” ");
INSERT INTO hincv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","तब अब्राहाम अपने सेवकों के पास लौट आये और वे सब बेअरशेबा चले गए. और अब्राहाम बेअरशेबा में रहने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","कुछ समय के बाद, अब्राहाम को यह बताया गया, “मिलकाह भी मां बन गई है; उसने तुम्हारे भाई नाहोर के लिये बेटों को जन्म दिया है: ");
INSERT INTO hincv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","बड़ा बेटा उज़, उसका भाई बुज़, केमुएल (अराम का पिता), ");
INSERT INTO hincv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","फिर केसेद, हाज़ो, पिलदाश, यिदलाफ तथा बेथुएल.” ");
INSERT INTO hincv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","बेथुएल रेबेकाह का पिता हुआ. अब्राहाम के भाई नाहोर से मिलकाह के द्वारा ये आठ पुत्र पैदा हुए. ");
INSERT INTO hincv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","नाहोर की रखैल रियूमाह के भी ये पुत्र हुए: तेबाह, गाहम, ताहाश तथा माकाह. ");
INSERT INTO hincv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","साराह एक सौ सत्ताईस वर्ष की हुई. ");
INSERT INTO hincv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","तब उसकी मृत्यु किरयथ-अरबा (अर्थात् हेब्रोन) में हुई, जो कनान देश में है. अब्राहाम साराह के लिए विलाप किया और रोया. ");
INSERT INTO hincv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","तब अब्राहाम ने अपनी पत्नी के शव के पास से उठकर हित्तियों से कहा; ");
INSERT INTO hincv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“मैं तो तुम्हारे बीच एक परदेशी और अजनबी हूं. मुझे कब्रस्थान के लिये बिक्री में कुछ ज़मीन दीजिये ताकि मैं अपने मृत लोगों को गाड़ सकूं.” ");
INSERT INTO hincv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","हित्तियों ने अब्राहाम से कहा, ");
INSERT INTO hincv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“महोदय, आप हमारी बात सुनें. आप हमारे बीच में एक बड़े प्रधान हैं. आप जहां चाहें अपनी पत्नी को हमारे अच्छे कब्रों में गाड़ सकते हैं. हममें से कोई भी आपको अपनी पत्नी को गाड़ने के लिये अपनी कब्र देने से मना नहीं करेगा.” ");
INSERT INTO hincv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","तब अब्राहाम उठे और उस देश के लोगों को अर्थात् हित्तियों को झुककर प्रणाम किया ");
INSERT INTO hincv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","और उनसे कहा, “यदि आप चाहते हैं कि मैं अपनी पत्नी को मिट्टी दूं, तब मेरी एक बात और मान लीजिये और आप ज़ोहार के पुत्र एफ्रोन से मेरी तरफ से बात कीजिये ");
INSERT INTO hincv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ताकि वह माखपेलाह की गुफा को, जो उसकी है और उसके खेत की आखिरी छोर में है, दाम लेकर मुझे बेच दे. उससे कहिये कि वह उस जगह का पूरा दाम लेकर मुझे बेच दे ताकि वह तुम्हारे बीच में हमारे लिये एक कब्रस्थान की जगह हो.” ");
INSERT INTO hincv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","हित्ती एफ्रोन अपने लोगों के साथ वहां बैठा था. जो हित्ती उसके शहर के फाटक पर एकत्रित हुए थे, उनके सामने एफ्रोन ने अब्राहाम से कहा, ");
INSERT INTO hincv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“हे मेरे स्वामी; मेरी बात सुनिये; मैं आपको वह गुफा खेत सहित मेरे संबंधियों के सामने दे रहा हूं. आप इसमें अपनी पत्नी को गाड़ दीजिये.” ");
INSERT INTO hincv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","अब्राहाम ने फिर से उन लोगों को झुककर प्रणाम किया ");
INSERT INTO hincv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","और लोगों के सुनते में एफ्रोन से कहा, “मेरी बात सुनिये, आपको मैं उस खेत का दाम चुकाऊंगा, आप इसे स्वीकार कर लीजिये ताकि मैं अपनी पत्नी को वहां गाड़ सकूं.” ");
INSERT INTO hincv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","यह सुन एफ्रोन ने अब्राहाम से कहा, ");
INSERT INTO hincv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“हे मेरे स्वामी, मेरी बात सुनिये; इस खेत का दाम सिर्फ चार सौ शेकेल चांदी है, पर यह आपके और मेरे लिए कुछ नहीं है. आप अपनी पत्नी को मिट्टी दे दीजिये.” ");
INSERT INTO hincv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","अब्राहाम ने एफ्रोन की बात मानकर उसको उतने मूल्य की चांदी तौलकर दे दी, जितना उसने हित्तियों के सुनते में कहा था: चार सौ शेकेल चांदी जो उस समय व्यापारियों के बीच में चलती थी. ");
INSERT INTO hincv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","इसलिये उन्होंने एफ्रोन का वह खेत और गुफा, जो माखपेलाह में ममरे के पास था, और खेत के सभी पेड़ जो उसमें और उसके चारों ओर सीमा के अंदर थे, ");
INSERT INTO hincv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","सब अब्राहाम को दे दिया. जितने हित्ती शहर के फाटक पर एकत्रित हुए थे, उन सभों के सामने वह संपत्ति अब्राहाम के अधिकार में पक्की रीति से आ गई. ");
INSERT INTO hincv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","उसके बाद अब्राहाम ने अपनी पत्नी साराह को माखपेलाह के खेत की गुफा में गाड़ दिया, जो कनान देश में ममरे के पास (अर्थात् हेब्रोन) में था. ");
INSERT INTO hincv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","इस प्रकार हित्तियों के द्वारा वह खेत और उसमें की गुफा कब्रस्थान के रूप में अब्राहाम के अधिकार में दे दी गई. ");
INSERT INTO hincv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","अब्राहाम बहुत बूढ़े हो गये थे, और याहवेह ने उन्हें सब प्रकार से आशीषित किया था. ");
INSERT INTO hincv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","अब्राहाम ने अपने पुराने सेवक से, जो घर की और पूरे संपत्ति की देखभाल करता था, कहा, “तुम अपना हाथ मेरी जांघ के नीचे रखो. ");
INSERT INTO hincv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","मैं चाहता हूं कि तुम स्वर्ग एवं पृथ्वी के परमेश्वर याहवेह की शपथ खाओ कि तुम इन कनानियों की पुत्रियों में से, जिनके बीच हम रह रहे हैं, मेरे बेटे की शादी नहीं कराओगे, ");
INSERT INTO hincv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","परंतु तुम मेरे देश में मेरे रिश्तेदारों में से मेरे बेटे यित्सहाक के लिए पत्नी लाओगे.” ");
INSERT INTO hincv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","उस सेवक ने अब्राहाम से पूछा, “उस स्थिति में मैं क्या करूं, जब वह स्त्री इस देश में आना ही न चाहे; क्या मैं आपके पुत्र को उस देश में ले जाऊं, जहां से आप आए हैं?” ");
INSERT INTO hincv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","इस पर अब्राहाम ने कहा, “तुम मेरे पुत्र को वहां कभी नहीं ले जाना. ");
INSERT INTO hincv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","याहवेह, जो स्वर्ग के परमेश्वर हैं, जो मुझे मेरे पिता के परिवार और मेरी जन्मभूमि से लाये हैं और जिन्होंने शपथ खाकर मुझसे यह वायदा किया, ‘यह देश मैं तुम्हारे वंश को दूंगा’—वे ही स्वर्गदूत को तुम्हारे आगे-आगे भेजेंगे और तुम मेरे पुत्र के लिए वहां से एक पत्नी लेकर आओगे. ");
INSERT INTO hincv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","अगर कन्या तुम्हारे साथ आने के लिए मना करे, तब तुम मेरी इस शपथ से मुक्त हो जाओगे. लेकिन ध्यान रखना कि तुम मेरे पुत्र को वापस वहां न ले जाना.” ");
INSERT INTO hincv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","इसलिये उस सेवक ने अपने स्वामी अब्राहाम की जांघ के नीचे अपना हाथ रखा और इस बारे में शपथ खाकर अब्राहाम से वायदा किया. ");
INSERT INTO hincv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","तब उस सेवक ने अपने स्वामी के ऊंट के झुंड में से दस ऊंटों को लिया और उन पर अपने स्वामी की ओर से विभिन्‍न उपहार लादा और नाहोर के गृहनगर उत्तर-पश्चिम मेसोपोतामिया की ओर प्रस्थान किया. ");
INSERT INTO hincv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","नगर के बाहर पहुंचकर उसने ऊंटों को कुएं के पास बैठा दिया; यह शाम का समय था. इसी समय स्त्रियां पानी भरने बाहर आया करती थीं. ");
INSERT INTO hincv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","तब सेवक ने प्रार्थना की, “याहवेह, मेरे स्वामी अब्राहाम के परमेश्वर, मेरे काम को सफल करें और मेरे स्वामी अब्राहाम पर दया करें. ");
INSERT INTO hincv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","आप देख रहे हैं कि मैं इस पानी के सोते के निकट खड़ा हूं, और इस नगरवासियों की कन्याएं पानी भरने के लिए निकलकर आ रही हैं. ");
INSERT INTO hincv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","आप कुछ ऐसा कीजिए कि जिस कन्या से मैं यह कहूं, ‘अपना घड़ा झुकाकर कृपया मुझे पानी पिला दे,’ और वह कन्या कहे, ‘आप पानी पी लीजिए, और फिर मैं आपके ऊंटों को भी पानी पिला दूंगी’—यह वही कन्या हो जिसे आपने अपने सेवक यित्सहाक के लिए चुना है. इसके द्वारा मुझे यह विश्वास हो जाएगा कि आपने मेरे स्वामी पर अपनी करुणा दिखाई है.” ");
INSERT INTO hincv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","इसके पूर्व कि उसकी प्रार्थना खत्म होती, रेबेकाह नगर के बाहर अपने कंधे पर घड़ा लेकर पानी भरने आई. वह मिलकाह के पुत्र बेथुएल की पुत्री थी और मिलकाह अब्राहाम के भाई नाहोर की पत्नी थी. ");
INSERT INTO hincv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","रेबेकाह बहुत सुंदर थी, कुंवारी थी; अब तक किसी पुरुष से उसका संसर्ग नहीं हुआ था. वह नीचे सोते पर गई, अपना घड़ा पानी से भरा और फिर ऊपर आ गई. ");
INSERT INTO hincv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","सेवक दौड़कर उसके निकट आया और उससे कहा, “कृपया अपने घड़े से मुझे थोड़ा पानी पिला दो.” ");
INSERT INTO hincv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","रेबेकाह ने कहा, “हे मेरे प्रभु लीजिए, पीजिये” और उसने तुरंत घड़े को नीचे करके उसे पानी पिलाया. ");
INSERT INTO hincv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","जब वह सेवक को पानी पिला चुकी, तब रेबेकाह ने उससे कहा, “मैं आपके ऊंटों के लिए भी पानी लेकर आती हूं, जब तक वे पूरे तृप्‍त न हो जाएं.” ");
INSERT INTO hincv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","उसने बिना देर किए घड़े का पानी हौदे में उंडेलकर वापस सोते पर और पानी भरने गई, और उसके सारे ऊंटों के लिये पर्याप्‍त पानी ले आई. ");
INSERT INTO hincv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","जब यह सब हो रहा था, बिना एक शब्द कहे, उस सेवक ध्यान से रेबेकाह को देखकर सोच रहा था कि याहवेह ने उसकी यात्रा को सफल किया है या नहीं. ");
INSERT INTO hincv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","जब ऊंटों ने पानी पी लिया, तब सेवक ने आधा शेकेल सोने की एक नथ और दस शेकेल सोने के दो कंगन निकाला. ");
INSERT INTO hincv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","और रेबेकाह को देकर उससे पूछा, “तुम किसकी बेटी हो? कृपया मुझे बताओ, क्या तुम्हारे पिता के घर में इस रात ठहरने के लिए जगह है?” ");
INSERT INTO hincv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","रेबेकाह ने उत्तर दिया, “मैं नाहोर तथा मिलकाह के पुत्र बेथुएल की बेटी हूं.” ");
INSERT INTO hincv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","और उसने यह भी कहा, “हमारे यहां घास और चारा बहुत है, और रात में ठहरने के लिये जगह भी है.” ");
INSERT INTO hincv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","तब उस सेवक ने झुककर और यह कहकर याहवेह की आराधना की, ");
INSERT INTO hincv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“धन्य हैं याहवेह, मेरे स्वामी अब्राहाम के परमेश्वर, जिन्होंने मेरे स्वामी के प्रति अपने प्रेम और करुणा को नहीं हटाया. याहवेह मुझे सही जगह पर लाये जो मेरे स्वामी के रिश्तेदारों का ही घर है.” ");
INSERT INTO hincv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","वह कन्या दौड़कर अपने घर गई और अपनी माता के घर के लोगों को सब बातें बताई. ");
INSERT INTO hincv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","रेबेकाह के भाई लाबान दौड़कर कुएं के पास गए जहां सेवक था. ");
INSERT INTO hincv_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","जब उसने नथ और अपनी बहन के हाथों में कंगन देखा और जो बात सेवक ने कही थी, उसे सुनी, तब वह उस सेवक के पास गया, और देखा कि वह सेवक सोते के निकट ऊंटों के बाजू में खड़ा है. ");
INSERT INTO hincv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","लाबान ने सेवक से कहा, “हे याहवेह के आशीषित जन, मेरे साथ चलिए! आप यहां बाहर क्यों खड़े हैं? मैंने घर को, और ऊंटों के ठहरने के लिये भी जगह तैयार की है.” ");
INSERT INTO hincv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","वह सेवक लाबान के साथ घर आया और ऊंटों पर से सामान उतारा गया. ऊंटों के लिये पैंरा और चारा लाया गया. सेवक तथा उसके साथ के लोगों के लिये पैर धोने हेतु पानी दिया गया. ");
INSERT INTO hincv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","तब सेवक को खाना दिया गया, पर उसने कहा, “मैं तब तक भोजन न करूंगा, जब तक कि मैं अपने आने का प्रयोजन न बता दूं.” लाबान ने कहा, “ठीक है, बता दें.” ");
INSERT INTO hincv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","तब उसने कहा, “मैं अब्राहाम का सेवक हूं. ");
INSERT INTO hincv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","याहवेह ने मेरे स्वामी को बहुत आशीष दी हैं, जिससे वे धनवान हो गए हैं. याहवेह ने उन्हें बहुत भेड़-बकरी और पशु, सोना और चांदी, सेवक और सेविकाएं तथा ऊंट और गधे दिये हैं. ");
INSERT INTO hincv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","मेरे स्वामी की पत्नी साराह को वृद्धावस्था में एक बेटा पैदा हुआ, और अब्राहाम ने उसे अपना सब कुछ दे दिया है. ");
INSERT INTO hincv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","और मेरे स्वामी ने मुझे शपथ दिलाकर कहा, ‘तुम मेरे पुत्र की पत्नी बनने के लिए कनानियों की किसी बेटी को, जिनके बीच मैं रहता हूं, न लाना, ");
INSERT INTO hincv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","पर तुम मेरे पिता के परिवार, मेरे अपने वंश में जाना, और मेरे पुत्र के लिए एक पत्नी लाना.’ ");
INSERT INTO hincv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“तब मैंने अपने स्वामी से पूछा, ‘यदि वह युवती मेरे साथ आना नहीं चाहेगी, तब क्या?’ ");
INSERT INTO hincv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“मेरे स्वामी ने कहा, ‘याहवेह, जिनके सामने मैं ईमानदारी से चलता आया हूं, वे अपने स्वर्गदूत को तुम्हारे साथ भेजेंगे और तुम्हारी यात्रा को सफल करेंगे, ताकि तुम मेरे पुत्र के लिए मेरे अपने वंश और मेरे पिता के परिवार से एक पत्नी ला सको. ");
INSERT INTO hincv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","तुम मेरे इस शपथ से तब ही छूट पाओगे, जब तुम मेरे वंश के लोगों के पास जाओगे, और यदि वे उस कन्या को तुम्हारे साथ भेजने के लिए मना करें—तब तुम मेरे शपथ से छूट जाओगे.’ ");
INSERT INTO hincv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“आज जब मैं कुएं के पास पहुंचा, तो मैंने यह प्रार्थना की, ‘याहवेह, मेरे स्वामी अब्राहाम के परमेश्वर, मैं जिस उद्देश्य से यहां आया हूं, वह काम पूरा हो जाये. ");
INSERT INTO hincv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","देखिये, मैं इस कुएं के किनारे खड़ा हूं. यदि कोई कन्या निकलकर पानी भरने के लिये आती है और मैं उससे कहता हूं, “कृपा करके मुझे अपने घड़े से थोड़ा पानी पिला दे,” ");
INSERT INTO hincv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","और यदि वह मुझसे कहती है, “पीजिये, और मैं आपके ऊंटों के लिये भी पानी लेकर आती हूं,” तो वह वही कन्या हो, जिसे याहवेह ने मेरे मालिक के बेटे के लिये चुना है.’ ");
INSERT INTO hincv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“इसके पहले कि मैं अपने मन में यह प्रार्थना खत्म करता, रेबेकाह अपने कंधे पर घड़ा लिये निकलकर आई. वह नीचे सोते के पास जाकर पानी भरने लगी, और मैंने उससे कहा, ‘कृपया मुझे थोड़ा पानी पिला दो.’ ");
INSERT INTO hincv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“तब उसने तुरंत अपने कंधे में से घड़े को झुकाकर कहा, ‘पी लीजिये, और फिर मैं आपके ऊंटों को भी पानी पिला दूंगी.’ तब मैंने पानी पिया, और उसने ऊंटों को भी पानी पिलाया. ");
INSERT INTO hincv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“तब मैंने उससे पूछा, ‘तुम किसकी बेटी हो?’ “उसने कहा, ‘मैं बेथुएल की बेटी हूं, जो नाहोर तथा मिलकाह के पुत्र है.’ “तब मैंने उसके नाक में नथ तथा उसके हाथों में कंगन पहना दिए, ");
INSERT INTO hincv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","और मैंने झुककर याहवेह की आराधना की. मैंने याहवेह, अपने मालिक अब्राहाम के परमेश्वर की महिमा की, जिन्होंने मुझे सही मार्ग में अगुवाई की, ताकि मैं अपने मालिक के भाई की नतनिन को अपने मालिक के बेटे के लिये पत्नी के रूप में ले जा सकूं. ");
INSERT INTO hincv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","इसलिये अब, यदि आप मेरे मालिक के प्रति दया और सच्चाई दिखाना चाहते हैं, तो मुझे बताईये; और यदि नहीं, तो वह भी बताईये, कि किस रास्ते पर मुड़ना है.” ");
INSERT INTO hincv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","यह सब सुनकर लाबान एवं बेथुएल ने कहा, “यह सब याहवेह की ओर से हुआ है; हम तुमसे अच्छा या बुरा कुछ नहीं कह सकते. ");
INSERT INTO hincv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","रेबेकाह तुम्हारे सामने है; इसे अपने साथ ले जाओ, ताकि वह तुम्हारे स्वामी के पुत्र की पत्नी हो जाए, जैसा कि याहवेह ने निर्देश दिया है.” ");
INSERT INTO hincv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","उनकी बातों को सुनकर अब्राहाम के सेवक ने भूमि पर झुककर याहवेह को दंडवत किया. ");
INSERT INTO hincv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","तब सेवक ने सोने और चांदी के गहने तथा वस्त्र निकालकर रेबेकाह को दिए; उसने रेबेकाह के भाई और उसकी माता को भी बहुमूल्य वस्तुएं दी. ");
INSERT INTO hincv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","फिर उसने तथा उसके साथ के लोगों ने खाया पिया और वहां रात बिताई. अगले दिन सुबह जब वे सोकर उठे तो सेवक ने कहा, “मुझे अपने स्वामी के पास वापस जाने के लिए विदा कीजिये.” ");
INSERT INTO hincv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","पर रेबेकाह के भाई और उसकी मां ने कहा, “कन्या को हमारे साथ कुछ दिन अर्थात् कम से कम दस दिन रहने दो; तब उसे ले जाना.” ");
INSERT INTO hincv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","पर सेवक ने उनसे कहा, “मुझे मत रोकिए; क्योंकि याहवेह ने मेरी इस यात्रा को सफल किया है. मुझे अपने स्वामी के पास लौट जाने के लिये विदा कीजिए.” ");
INSERT INTO hincv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","तब उन्होंने कहा, “हम रेबेकाह को बुलाकर इसके बारे में उससे पूछते हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","तब उन्होंने रेबेकाह को बुलाकर उससे पूछा, “क्या तुम इस व्यक्ति के साथ जाओगी?” उसने कहा, “हां, मैं जाऊंगी.” ");
INSERT INTO hincv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","इसलिये उन्होंने अपनी बहन रेबेकाह को उसकी परिचारिका और अब्राहाम के सेवक और उसके लोगों के साथ विदा किया. ");
INSERT INTO hincv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","और उन्होंने रेबेकाह को आशीर्वाद देते हुए कहा, “हे हमारी बहन, तुम्हारा वंश हजारों हजार की संख्या में बढ़े; तुम्हारा वंश अपने शत्रुओं के नगर पर अधिकार करने पाये.” ");
INSERT INTO hincv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","तब रेबेकाह और उसकी परिचारिकाएं तैयार हुईं और ऊंटों पर चढ़कर उस व्यक्ति के साथ गईं और वह सेवक रेबेकाह को लेकर रवाना हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","यित्सहाक बएर-लहाई-रोई से आकर अब नेगेव में निवास कर रहे थे. ");
INSERT INTO hincv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","एक शाम जब वे चिंतन करने मैदान में गये थे, तब उन्होंने ऊंटों को आते हुए देखा. ");
INSERT INTO hincv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रेबेकाह ने भी आंख उठाकर यित्सहाक को देखा और वह अपने ऊंट पर से नीचे उतरी ");
INSERT INTO hincv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","और सेवक से पूछा, “मैदान में वह कौन व्यक्ति है, जो हमसे मिलने आ रहे हैं?” सेवक ने उत्तर दिया, “वे मेरे स्वामी हैं.” यह सुनकर रेबेकाह ने अपना घूंघट लिया और अपने आपको ढांप लिया. ");
INSERT INTO hincv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","तब सेवक ने यित्सहाक को वे सब बातें बताई, जो उसने किया था. ");
INSERT INTO hincv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","तब यित्सहाक रेबेकाह को अपनी मां साराह के तंबू में ले आया, और उसने रेबेकाह से शादी की. वह उसकी पत्नी हो गई, और उसने उससे प्रेम किया; इस प्रकार यित्सहाक को उसकी माता की मृत्यु के बाद सांत्वना मिली. ");
INSERT INTO hincv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","अब्राहाम ने केतुराह नामक एक और स्त्री से विवाह कर लिया था. ");
INSERT INTO hincv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","उससे अब्राहाम के जो पुत्र हुए, उनका नाम था ज़िमरान, योकशान, मेदान, मिदियान, इशबक और शुआह. ");
INSERT INTO hincv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","योकशान शीबा तथा देदान के पिता थे. देदान के वंश में असशुरिम, लेतुशिम तथा लेउम्मिम लोगों का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिदियान के पुत्र: एफाह, एफ़र, हनोख, अविदा तथा एलदाह थे. ये सब केतुराह से पैदा हुए थे. ");
INSERT INTO hincv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","अब्राहाम ने अपनी पूरी संपत्ति यित्सहाक को सौंप दी थी. ");
INSERT INTO hincv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","किंतु अब्राहाम ने अपनी रखैलों की संतानों को अपने जीवनकाल में ही उपहार देकर उन्हें अपने पुत्र यित्सहाक से दूर पूर्व के देश में भेज दिया था. ");
INSERT INTO hincv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","अब्राहाम की उम्र एक सौ पचहत्तर साल की थी. ");
INSERT INTO hincv_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","तब अब्राहाम ने अपनी पूरी वृद्धावस्था में आखिरी सांस ली, एक वृद्ध व्यक्ति के रूप में उनकी पूरी आयु में मृत्यु हुई; और वे अपने लोगों में जा मिले. ");
INSERT INTO hincv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","उनके पुत्र यित्सहाक और इशमाएल ने उन्हें ममरे के पास माखपेलाह के गुफा में मिट्टी दी, जो हित्ती ज़ोहार के पुत्र एफ्रोन के खेत में थी, ");
INSERT INTO hincv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","यह वही खेत था, जिसे अब्राहाम ने हित्तियों से खरीदा था. वहां उनकी पत्नी साराह के पास अब्राहाम दफनाया गया. ");
INSERT INTO hincv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहाम की मृत्यु के बाद, परमेश्वर ने उनके पुत्र यित्सहाक को आशीष दी, जो उस समय बएर-लहाई-रोई में रहता था. ");
INSERT INTO hincv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","अब्राहाम के पुत्र इशमाएल, जो साराह के मिस्र की दासी हागार से पैदा हुआ था, उसकी वंशावली इस प्रकार है. ");
INSERT INTO hincv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","जन्म के अनुसार इशमाएल के बेटों का नाम इस प्रकार है: इशमाएल का बड़ा बेटा नेबाइयोथ, फिर केदार, अदबील, मिबसाम, ");
INSERT INTO hincv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिशमा, दूमाह, मास्सा, ");
INSERT INTO hincv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, येतुर, नाफिश और केदेमाह. ");
INSERT INTO hincv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ये इशमाएल के पुत्र थे, और ये उन बारह जाति के प्रधानों के नाम हैं जो उनके बंदोबस्त और छावनियों के अनुसार रखे गये. ");
INSERT INTO hincv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इशमाएल एक सौ सैंतीस वर्ष तक जीवित रहा. तब उसकी मृत्यु हो गई, और वह अपने लोगों में जा मिला. ");
INSERT INTO hincv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","उसके वंशज मिस्र देश के पूर्वी सीमा के नजदीक अश्शूर की दिशा में हाविलाह से लेकर शूर तक के क्षेत्र में बस गए और वे उनसे संबंधित सभी गोत्रों से बैर रखते थे. ");
INSERT INTO hincv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","अब्राहाम के पुत्र यित्सहाक की वंशावली इस प्रकार है: अब्राहाम से यित्सहाक का जन्म हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","पद्दन-अरामवासी अरामी बेथुएल की पुत्री और अरामी लाबान की बहन रेबेकाह से विवाह करते समय यित्सहाक की आयु चालीस वर्ष थी. ");
INSERT INTO hincv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","यित्सहाक ने अपनी पत्नी की ओर से याहवेह से प्रार्थना की, क्योंकि वह बांझ थी. याहवेह ने उसकी प्रार्थना सुन ली और उसकी पत्नी रेबेकाह गर्भवती हुई. ");
INSERT INTO hincv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","बच्‍चे उसके गर्भ में एक दूसरे को धक्का देते रहते थे. तब रेबेकाह ने कहा, “यह क्या हो रहा है मेरे साथ?” और वह याहवेह से पूछने गई. ");
INSERT INTO hincv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","याहवेह ने उससे कहा, “तुम्हारे गर्भ में दो जातियां हैं, तुममें से दो जनता के लोग निकलकर अलग होंगे; एक समूह के लोग दूसरे से अधिक बलवान होंगे, और बड़ा छोटे की सेवा करेगा.” ");
INSERT INTO hincv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","जब उसके प्रसव का समय आया. उसके गर्भ में जुड़वां बच्‍चे थे. ");
INSERT INTO hincv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","जो पहला बेटा हुआ वह लाल था, और उसका पूरा शरीर बालों से भरा था; इस कारण उसका नाम एसाव रखा गया. ");
INSERT INTO hincv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","इसके बाद, उसके भाई का जन्म हुआ, जो अपने हाथ से अपने भाई एसाव की एड़ी पकड़े हुए था; तब उसका नाम याकोब रखा गया. जब रेबेकाह ने बच्चों को जन्म दिया, तब यित्सहाक की उम्र साठ वर्ष थी. ");
INSERT INTO hincv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","दोनों बच्‍चे बड़े होते गये, और एसाव खुले मैदान का एक कुशल शिकारी बन गया, जबकि याकोब घर में तंबुओं के बीच रहकर संतुष्ट रहता था. ");
INSERT INTO hincv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","एसाव यित्सहाक का प्रिय था क्योंकि यित्सहाक को आखेट का मांस बहुत अच्छा लगता था, पर याकोब रेबेकाह का प्रिय था. ");
INSERT INTO hincv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","एक बार जब याकोब धीमी आंच में कुछ पका रहा था, तब एसाव बाहर मैदान से आया और वह बहुत भूखा था. ");
INSERT INTO hincv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","उसने याकोब से कहा, “मुझे बहुत भूख लगी है; तुम जो पका रहे हो, जल्दी करके उसमें से मुझे कुछ खाने को दो.” (यही कारण है कि उसे एदोम भी कहा गया.) ");
INSERT INTO hincv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","किंतु याकोब ने उससे कहा, “पहले आप अपने पहलौठे का अधिकार मुझे दे दो.” ");
INSERT INTO hincv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसाव ने कहा, “देख, भूख से मेरे प्राण निकल रहे हैं; पहलौठे के अधिकार से मुझे क्या फायदा है?” ");
INSERT INTO hincv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","पर याकोब ने कहा, “तो पहले आप मुझसे शपथ खाईये.” तब एसाव ने शपथ खाकर अपने पहलौठे का अधिकार याकोब के हाथ बेच दिया. ");
INSERT INTO hincv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","तब याकोब ने एसाव को कुछ रोटी और पकाई हुई दाल दी. एसाव ने खाया पिया, और उठकर चला गया. इस प्रकार एसाव ने अपने पहलौठे के अधिकार को तुच्छ समझा. ");
INSERT INTO hincv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","उस देश में अकाल पड़ा. ऐसा ही अकाल अब्राहाम के समय में भी पड़ा था. यित्सहाक गेरार में फिलिस्तीनियों के राजा अबीमेलेक के पास गया. ");
INSERT INTO hincv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","याहवेह ने यित्सहाक को दर्शन देकर कहा, “मिस्र देश को मत जाओ; लेकिन उस देश में रहो, जहां मैं बताऊंगा. ");
INSERT INTO hincv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","कुछ समय के लिये इस देश में रहो, और मैं तुम्हारे साथ रहूंगा और तुम्हें आशीष दूंगा. मैं यह पूरा देश तुम्हें और तुम्हारे वंश को दूंगा और तुम्हारे पिता अब्राहाम से किए अपने वायदे को मैं पूरा करूंगा, ");
INSERT INTO hincv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","मैं तुम्हारे वंश को आकाश के तारों के समान अनगिनत करूंगा और यह पूरा देश उन्हें दूंगा, और तुम्हारे वंश के द्वारा पृथ्वी की सारी जनता आशीषित होंगी, ");
INSERT INTO hincv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","क्योंकि अब्राहाम ने मेरी बात मानी और मेरी आज्ञाओं, नियमों और निर्देशों का ध्यान रखते हुए उसने वह सब किया जिसे मैंने उसे करने को कहा था.” ");
INSERT INTO hincv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","इसलिये यित्सहाक गेरार में ही रहने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","जब उस स्थान के लोगों ने उससे उसके पत्नी के बारे में पूछा, तो उसने कहा, “वह मेरी बहन है,” क्योंकि वह यह कहने से डरता था, “वह मेरी पत्नी है.” वह सोचता था, “इस स्थान के लोग रेबेकाह के कारण शायद मुझे मार डालेंगे, क्योंकि वह सुंदर है.” ");
INSERT INTO hincv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","जब यित्सहाक को वहां रहते हुए काफ़ी समय हो गया, तो एक दिन फिलिस्तीनियों के राजा अबीमेलेक ने खिड़की से नीचे झांककर देखा कि यित्सहाक अपनी पत्नी रेबेकाह से प्रेम कर रहा है. ");
INSERT INTO hincv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","इसलिये अबीमेलेक ने यित्सहाक को बुलवाया और कहा, “निश्चय ही वह तुम्हारी पत्नी है! फिर तुमने यह क्यों कहा, ‘वह मेरी बहन है’?” यित्सहाक ने उत्तर दिया, “क्योंकि मैंने सोचा कि उसके कारण कहीं मुझे अपनी जान गंवानी न पड़े.” ");
INSERT INTO hincv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","तब अबीमेलेक ने कहा, “तुमने हमसे यह क्या किया? हमारी प्रजा में से कोई भी पुरुष तुम्हारी पत्नी के साथ सो सकता था, और तुम हमको पाप का भागीदार बनाते हो.” ");
INSERT INTO hincv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","इसलिये अबीमेलेक ने सब लोगों को आज्ञा दी: “जो कोई इस पुरुष तथा उसकी पत्नी की हानि करेगा, वह निश्चित रूप से मार डाला जाएगा.” ");
INSERT INTO hincv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","यित्सहाक ने उस देश में खेती की और उसे उसी वर्ष सौ गुणा उपज मिली, क्योंकि याहवेह ने उसे आशीष दी. ");
INSERT INTO hincv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","वह धनवान हो गया; उसका धन बढ़ता गया और वह बहुत धनवान हो गया. ");
INSERT INTO hincv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","उसके पास इतनी भेड़-बकरी, पशु और सेवक हो गये कि फिलिस्तीनी उससे जलन करने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","इसलिये उन सभी कुंओं को, जो उसके पिता अब्राहाम के सेवकों ने उसके पिता के समय में खोदे थे, फिलिस्तीनियों ने मिट्टी से पाटकर बंद कर दिया. ");
INSERT INTO hincv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","तब अबीमेलेक ने यित्सहाक से कहा, “तुम हमारे पास से दूर चले जाओ, क्योंकि तुम हमसे बहुत ज्यादा बलवान हो गये हो.” ");
INSERT INTO hincv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","इसलिये यित्सहाक वहां से चला गया और गेरार घाटी में तंबू खड़ा करके वहां रहने लगा. ");
INSERT INTO hincv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","यित्सहाक ने उन कुंओं को फिर खोदवाया, जो उसके पिता के समय में खोदे गये थे, और जिन्हें फिलिस्तीनियों ने अब्राहाम की मृत्यु के बाद मिट्टी से पाट दिया था, और उसने उन कुंओं के वही नाम रखे जो उसके पिता ने रखे थे. ");
INSERT INTO hincv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","यित्सहाक के सेवकों को घाटी में खुदाई करते समय वहां एक मीठे पानी का कुंआ मिला. ");
INSERT INTO hincv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","इस पर गेरार के चरवाहों ने यित्सहाक के चरवाहों से झगड़ा किया और कहा, “यह पानी हमारा है!” इसलिये यित्सहाक ने उस कुएं का नाम ऐसेक रखा, क्योंकि उन्होंने उससे झगड़ा किया था. ");
INSERT INTO hincv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","तब उन्होंने दूसरा कुंआ खोदा, पर उन्होंने उस पर भी झगड़ा किया; इसलिये यित्सहाक ने उस कुएं का नाम सितनाह रखा. ");
INSERT INTO hincv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","तब वह वहां से चला गया और एक और कुंआ खोदा, और इस पर किसी ने झगड़ा नहीं किया. यित्सहाक ने यह कहकर उस कुएं का नाम रेहोबोथ रखा, “अब याहवेह ने हमें बहुत स्थान दिया है और हम लोग इस देश में उन्‍नति करेंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","फिर यित्सहाक वहां से बेअरशेबा चला गया. ");
INSERT INTO hincv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","उसी रात याहवेह ने उसे दर्शन देकर कहा, “मैं तुम्हारे पिता अब्राहाम का परमेश्वर हूं. मत डरो, क्योंकि मैं तुम्हारे साथ हूं; मैं तुम्हें अपने सेवक अब्राहाम के कारण आशीष दूंगा और तुम्हारे वंश को बढ़ाऊंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","तब यित्सहाक ने वहां एक वेदी बनाई और याहवेह की आराधना की. वहां उसने अपना तंबू खड़ा किया और वहां उसके सेवकों ने एक कुंआ खोदा. ");
INSERT INTO hincv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","इसी बीच अबीमेलेक गेरार से यित्सहाक से मिलने आये. उनके साथ उनका सलाहकार अहुज्ज़ाथ और उनकी सेना के सेनापति फीकोल भी थे. ");
INSERT INTO hincv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","यित्सहाक ने उनसे पूछा, “आप लोग मेरे पास क्यों आये हैं, जबकि आपने मुझसे बैर करके मुझे दूर जाने को कहा था?” ");
INSERT INTO hincv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","उन्होंने उत्तर दिया, “हमने साफ-साफ देखा कि याहवेह तुम्हारे साथ है; इसलिये हमने कहा, ‘तुम्हारे और हमारे बीच में शपथपूर्वक वाचा होनी चाहिये.’ इसलिये हम तुमसे एक संधि करना चाहते हैं ");
INSERT INTO hincv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","कि तुम हमारी कोई हानि नहीं करोगे, जैसे कि हमने भी तुम्हारी कोई हानि नहीं की, पर हमेशा तुमसे अच्छा व्यवहार किया और शांतिपूर्वक तुम्हें जाने को कहा. और अब तुम याहवेह के आशीषित भी हो.” ");
INSERT INTO hincv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","तब यित्सहाक ने उनके लिये एक भोज का आयोजन किया, और उन्होंने खाया और पिया. ");
INSERT INTO hincv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","अगले दिन वे बड़े सबेरे उठकर एक दूसरे के साथ शपथ खाई. तब यित्सहाक ने उन्हें विदा किया, और वे शांतिपूर्वक चले गये. ");
INSERT INTO hincv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","उस दिन यित्सहाक के सेवकों ने आकर उसे उस कुएं के बारे में बताया, जिसे उन्होंने खोदा था. उन्होंने कहा, “हमें पानी मिल गया है!” ");
INSERT INTO hincv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","यित्सहाक ने उस कुएं का नाम शिबाह रखा, और आज तक उस नगर का नाम बेअरशेबा है. ");
INSERT INTO hincv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","जब एसाव चालीस वर्ष के हुए, तो उसने हित्ती बएरी की बेटी यूदित, और हित्ती एलोन की पुत्री बसेमाथ से भी विवाह किया. ");
INSERT INTO hincv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ये स्त्रियां यित्सहाक और रेबेकाह के दुःख का कारण बनीं. ");
INSERT INTO hincv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","जब यित्सहाक वृद्ध हो गये थे और उनकी आंखें इतनी कमजोर हो गईं कि वह देख नहीं सकते थे, तब उन्होंने अपने बड़े बेटे एसाव को बुलाया और कहा, “हे मेरे पुत्र.” उन्होंने कहा, “क्या आज्ञा है पिताजी?” ");
INSERT INTO hincv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","यित्सहाक ने कहा, “मैं तो बूढ़ा हो गया हूं और नहीं जानता कि कब मर जाऊंगा. ");
INSERT INTO hincv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","इसलिये अब तुम अपना हथियार—अपना तरकश और धनुष लो और खुले मैदान में जाओ और मेरे लिये कोई वन पशु शिकार करके ले आओ. ");
INSERT INTO hincv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","और मेरी पसंद के अनुसार स्वादिष्ट भोजन बनाकर मेरे पास ले आना कि मैं उसे खाऊं और अपने मरने से पहले तुम्हें आशीष दूं.” ");
INSERT INTO hincv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","जब यित्सहाक अपने पुत्र एसाव से बातें कर रहे थे, तब रेबेकाह उनकी बातों को सुन रही थी. जब एसाव खुले मैदान में शिकार लाने के लिए चला गया, ");
INSERT INTO hincv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","तब रेबेकाह ने अपने पुत्र याकोब से कहा, “देख, मैंने तुम्हारे पिता को तुम्हारे भाई एसाव से यह कहते हुए सुना है, ");
INSERT INTO hincv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘शिकार करके मेरे लिये स्वादिष्ट भोजन बनाकर ला कि मैं उसे खाऊं और अपने मरने से पहले याहवेह के सामने तुम्हें आशीष दूं.’ ");
INSERT INTO hincv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","इसलिये, हे मेरे पुत्र, अब ध्यान से मेरी बात सुन और जो मैं कहती हूं उसे कर: ");
INSERT INTO hincv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","जानवरों के झुंड में जाकर दो अच्छे छोटे बकरे ले आ, ताकि मैं तुम्हारे पिता के लिए उनके पसंद के अनुसार स्वादिष्ट भोजन बना दूं. ");
INSERT INTO hincv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","तब तुम उस भोजन को अपने पिता के पास ले जाना, ताकि वह उसे खाकर अपने मरने से पहले तुम्हें अपनी आशीष दें.” ");
INSERT INTO hincv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","याकोब ने अपनी माता रेबेकाह से कहा, “पर मेरे भाई के शरीर में पूरे बाल हैं, लेकिन मेरी त्वचा चिकनी है. ");
INSERT INTO hincv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","यदि मेरे पिता मुझे छुएंगे तब क्या होगा? मैं तो धोखा देनेवाला ठहरूंगा और आशीष के बदले अपने ऊपर शाप लाऊंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","तब उसकी मां ने कहा, “मेरे पुत्र, तुम्हारा शाप मुझ पर आ जाए. मैं जैसा कहती हूं तू वैसा ही कर; जा और उनको मेरे लिये ले आ.” ");
INSERT INTO hincv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","इसलिये याकोब जाकर उनको लाया और अपनी मां को दे दिया, और उसने याकोब के पिता की पसंद के अनुसार स्वादिष्ट भोजन तैयार किया. ");
INSERT INTO hincv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","तब रेबेकाह ने अपने बड़े बेटे एसाव के सबसे अच्छे कपड़े घर से लाकर अपने छोटे बेटे याकोब को पहना दिए. ");
INSERT INTO hincv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","उसने बकरी के खालों से उसके चिकने भाग और गले और गले के चिकने भाग को भी ढंक दिया. ");
INSERT INTO hincv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","तब उसने अपनी पकाई स्वादिष्ट मांस को और रोटी लेकर याकोब को दी. ");
INSERT INTO hincv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","अपने पिता के पास जाकर याकोब ने कहा, “पिताजी.” यित्सहाक ने उत्तर दिया, “हां बेटा, कौन हो तुम?” ");
INSERT INTO hincv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकोब ने अपने पिता को उत्तर दिया, “मैं आपका बड़ा बेटा एसाव हूं. मैंने वह सब किया है, जैसा आपने कहा था. कृपया बैठिये और मेरे शिकार से पकाया भोजन कीजिये और मुझे अपनी आशीष दीजिये.” ");
INSERT INTO hincv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","यित्सहाक ने अपने पुत्र से पूछा, “मेरे पुत्र, यह तुम्हें इतनी जल्दी कैसे मिल गया?” याकोब ने कहा, “याहवेह आपके परमेश्वर ने मुझे सफलता दी.” ");
INSERT INTO hincv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","तब यित्सहाक ने याकोब से कहा, “हे मेरे पुत्र, मेरे पास आ, ताकि मैं तुम्हें छूकर जान सकूं कि तू सही में मेरा पुत्र एसाव है या नहीं.” ");
INSERT INTO hincv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","तब याकोब अपने पिता यित्सहाक के पास गया, जिसने उसे छुआ और कहा, “आवाज तो याकोब की है किंतु हाथ एसाव के हाथ जैसे हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","यित्सहाक ने उसे नहीं पहचाना, क्योंकि उसके हाथ में वैसे ही बाल थे जैसे एसाव के थे. इसलिए यित्सहाक उसे आशीष देने के लिए आगे बढ़ा. ");
INSERT INTO hincv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","यित्सहाक ने पूछा, “क्या तू सही में मेरा पुत्र एसाव है?” याकोब ने उत्तर दिया, “मैं हूं.” ");
INSERT INTO hincv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","तब यित्सहाक ने कहा, “हे मेरे पुत्र, अपने शिकार से पकाये कुछ भोजन मेरे खाने के लिये ला, ताकि मैं तुम्हें अपनी आशीष दूं.” याकोब अपने पिता के पास खाना लाया और उसने खाया; और वह दाखरस भी लाया और उसने पिया. ");
INSERT INTO hincv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","तब उसके पिता यित्सहाक ने उससे कहा, “हे मेरे पुत्र, यहां आ और मुझे चूम.” ");
INSERT INTO hincv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","इसलिये याकोब उसके पास गया और उसे चूमा. जब यित्सहाक को उसके कपड़ों से एसाव की गंध आई, इसलिये उसने उसे आशीष देते हुए कहा, “मेरे बेटे की खुशबू याहवेह की आशीष से मैदान में फैल गई है. ");
INSERT INTO hincv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","अब परमेश्वर तुम्हें आकाश की ओस, पृथ्वी की अच्छी उपज तथा अन्‍न और नये दाखरस से आशीषित करेंगे. ");
INSERT INTO hincv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","सभी राष्ट्र तुम्हारी सेवा करेंगे, जाति-जाति के लोग तुम्हारे सामने झुकेंगे, तुम अपने भाइयों के ऊपर शासक होंगे; तुम्हारी मां के पुत्र तुम्हारे सामने झुकेंगे. जो तुम्हें शाप देंगे वे स्वयं शापित होंगे और जो तुम्हें आशीष देंगे वे आशीष पायेंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","जैसे ही यित्सहाक याकोब को आशीष दे चुके तब उनका भाई एसाव शिकार करके घर आया. ");
INSERT INTO hincv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","उन्होंने जल्दी स्वादिष्ट खाना तैयार किया और अपने पिता से कहा “पिताजी, उठिए और स्वादिष्ट खाना खाकर मुझे अपनी आशीष दीजिए.” ");
INSERT INTO hincv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","उसके पिता यित्सहाक ने उनसे पूछा, “कौन हो तुम?” उसने कहा, “मैं आपका बेटा हूं, आपका बड़ा बेटा एसाव.” ");
INSERT INTO hincv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","यह सुन यित्सहाक कांपते हुए बोले, “तो वह कौन था, जो मेरे लिए भोजन लाया था? और मैंने उसे आशीषित भी किया, अब वह आशीषित ही रहेगा!” ");
INSERT INTO hincv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","अपने पिता की ये बात सुनकर एसाव फूट-फूटकर रोने लगा और अपने पिता से कहा, “पिताजी, मुझे आशीष दीजिए, मुझे भी!” ");
INSERT INTO hincv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","यित्सहाक ने कहा, “तुम्हारे भाई ने धोखा किया और आशीष ले ली.” ");
INSERT INTO hincv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","एसाव ने कहा, “उसके लिए याकोब नाम सही नहीं है? दो बार उसने मेरे साथ बुरा किया: पहले उसने मेरे बड़े होने का अधिकार ले लिया और अब मेरी आशीष भी छीन ली!” तब एसाव ने अपने पिता से पूछा, “क्या आपने मेरे लिए एक भी आशीष नहीं बचाई?” ");
INSERT INTO hincv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","यित्सहाक ने एसाव से कहा, “मैं तो उसे तुम्हारा स्वामी बना चुका हूं. और सभी संबंधियों को उसका सेवक बनाकर उसे सौंप दिया और उसे अन्‍न एवं नये दाखरस से भरे रहने की आशीष दी हैं. अब मेरे पुत्र, तुम्हारे लिए मैं क्या करूं?” ");
INSERT INTO hincv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","एसाव ने अपने पिता से पूछा, “पिताजी, क्या आपके पास मेरे लिए एक भी आशीष नहीं? और वह रोता हुआ कहने लगा कि पिताजी मुझे भी आशीष दीजिए!” ");
INSERT INTO hincv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","तब यित्सहाक ने कहा, “तुम्हारा घर अच्छी उपज वाली भूमि पर हो और उस पर आकाश से ओस गिरे. ");
INSERT INTO hincv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तुम अपनी तलवार की ताकत से जीवित रहोगे. तुम अपने भाई की सेवा करोगे; किंतु हां, किंतु तुम आज़ादी के लिए लड़ोगे, और तुम अपने ऊपर पड़े उसके प्रतिबन्ध को तोड़ फेंकोगे.” ");
INSERT INTO hincv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","एसाव अपने भाई याकोब से नफ़रत करने लगा और मन में ऐसा सोचने लगा, “पिता की मृत्यु शोक के दिन नज़दीक है, उनके बाद मैं याकोब की हत्या कर दूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","जब रेबेकाह को अपने बड़े बेटे की ये बातें बताई गईं तब उसने सेवक भेजकर अपने छोटे पुत्र याकूब को बुलवाकर उससे कहा, “तुम्हारे भाई एसाव के मन में तुम्हारे लिए बहुत नफ़रत हैं. सुनो, तुम्हारा भाई एसाव तुम्हें मारने का षड़्‍यंत्र कर रहा है. ");
INSERT INTO hincv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","इसलिये तुम यहां से भागकर मेरे भाई लाबान के यहां चले जाओ. ");
INSERT INTO hincv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","वहां जाकर कुछ समय रहो, जब तक तुम्हारे भाई का गुस्सा खत्म न हो जाए. ");
INSERT INTO hincv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","जब तुम्हारे भाई का गुस्सा खत्म होगा, और भूल जायेगा कि तुमने उसके साथ क्या किया, तब मैं तुम्हें वहां से बुला लूंगी. मैं एक ही दिन तुम दोनों को क्यों खो दूं?” ");
INSERT INTO hincv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","एक दिन रेबेकाह ने यित्सहाक से कहा, “हेथ की इन पुत्रियों ने मेरा जीवन दुःखी कर दिया है. यदि याकोब भी हेथ की पुत्रियों में से किसी को, अपनी पत्नी बना लेगा तो मेरे लिए जीना और मुश्किल हो जाएगा?” इसलिये याकोब को उसके मामा के घर भेज दो. ");
INSERT INTO hincv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","इसलिये यित्सहाक ने याकोब को आशीष दी और कहा: “कनानी कन्याओं से शादी मत करना. ");
INSERT INTO hincv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","पर पद्दन-अराम में अपने नाना बेथुएल के यहां चले जाओ. और वहां अपने मामा लाबान की पुत्रियों में से किसी से विवाह कर लेना. ");
INSERT INTO hincv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","सर्वशक्तिमान परमेश्वर की दया तुम पर बनी रहे तथा सुख और शांति से आगे बढ़ो. ");
INSERT INTO hincv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","परमेश्वर तुम्हें वे आशीषें दें, जिन्हें उन्होंने अब्राहाम को दी थी, तुम्हें और तुम्हारे वंश को, उस देश का अधिकारी बनाये.” ");
INSERT INTO hincv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","इन सब आशीषित वचन के साथ यित्सहाक ने याकोब को विदा किया. याकोब अपनी और एसाव की माता रेबेकाह के भाई अरामवासी लाबान के यहां चले गए, जो पद्दन-अराम के बेथुएल के पुत्र थे. ");
INSERT INTO hincv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","एसाव को मालूम हो गया था कि यित्सहाक ने याकोब को आशीष देकर पद्दन-अराम में भेजा है ताकि वह अपने लिए पत्नी चुने, और आदेश भी दिया है कि वह कनानी स्त्री से विवाह न करे, ");
INSERT INTO hincv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","और याकोब अपने पिता एवं माता की बात को मानते हुए पद्दन-अराम में चले गये. ");
INSERT INTO hincv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","तब एसाव को यह समझ में आ गया, कि उसके पिता को कनान देश की कन्याएं पसंद नहीं हैं. ");
INSERT INTO hincv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","इसलिये एसाव ने अपनी पत्नियों के अलावा अब्राहाम के पुत्र इशमाएल की पुत्री माहालाथ से, जो नेबाइयोथ की बहन थी, विवाह कर लिया. ");
INSERT INTO hincv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याकोब बेअरशेबा से हारान की ओर गए. ");
INSERT INTO hincv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","जब वह एक जगह पहुंचा तब रात को उन्हें वहां रुकना पड़ा, क्योंकि तब तक सूरज ढल चुका था. उन्होंने एक पत्थर अपने सिर के नीचे रखा और लेट गए. ");
INSERT INTO hincv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","तब उन्होंने एक स्वप्न देखा: एक सीढ़ी पृथ्वी पर खड़ी है, उसका दूसरा सिरा स्वर्ग तक पहुंचा हुआ था. उन्होंने देखा कि परमेश्वर के स्वर्गदूत इस पर चढ़ रहे और उतर रहे हैं. ");
INSERT INTO hincv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","उन्होंने देखा कि ऊपर याहवेह खड़े हैं, और कह रहे हैं, “मैं ही याहवेह हूं, तुम्हारे पिता अब्राहाम तथा यित्सहाक का परमेश्वर. जिस भूमि पर तुम इस समय लेटे हुए हो, मैं वह भूमि तुम्हें तथा तुम्हारे वंश को दूंगा. ");
INSERT INTO hincv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","तुम्हारा वंश भूमि की धूल के समान आशीषित होकर पृथ्वी के चारों दिशाओं में फैल जायेगा. पृथ्वी पर सभी लोग तुम्हारे और तुम्हारे वंश के द्वारा आशीषित होंगे. ");
INSERT INTO hincv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","मैं तुम्हारे साथ रहूंगा और जहां कहीं तुम जाओगे, मैं तुम्हारी रक्षा करूंगा. और तुम्हें इसी देश में लौटा ले आऊंगा. जब तक मैं अपनी बात पूरी न कर लूं तब तक तुम्हें न छोडूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","अचानक याकोब की नींद खुल गई और कहा, “निश्चय इस स्थान पर याहवेह की उपस्थिति है और मुझे यह मालूम ही न था.” ");
INSERT INTO hincv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","याकोब भयभीत होकर कहने लगे, “अनोखा है यह स्थान! यह परमेश्वर के भवन के अलावा कुछ और नहीं हो सकता; ज़रूर यह स्वर्ग का द्वार ही होगा.” ");
INSERT INTO hincv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","याकोब ने उस पत्थर को, जिसे उसने अपने सिर के नीचे रखा था, एक स्तंभ के जैसे खड़ा कर उस पर तेल डाला, ");
INSERT INTO hincv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","याकोब ने उस स्थान का नाम बेथेल रखा; जबकि उस स्थान का नाम लूज़ था. ");
INSERT INTO hincv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","फिर याकोब ने प्रण लिया, “यदि परमेश्वर की उपस्थिति मेरे साथ साथ बनी रहेगी, और मुझे सुरक्षित रखेंगे, मुझे भोजन एवं वस्त्रों की कमी नहीं होगी ");
INSERT INTO hincv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","और मुझे मेरे पिता के घर तक सुरक्षित पहुंचा देंगे, तो याहवेह ही मेरे परमेश्वर होंगे. ");
INSERT INTO hincv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","यह पत्थर, जिसे मैंने स्तंभ बनाकर खड़ा किया है, परमेश्वर का भवन होगा तथा आप मुझे जो कुछ देंगे, निश्चयतः मैं उसका दशमांश आपको ही समर्पित करूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","याकोब अपनी यात्रा में आगे बढ़ते गए और पूर्वी देश में जा पहुंचे. ");
INSERT INTO hincv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","तब उन्हें मैदान में एक कुंआ और भेड़-बकरियों के तीन झुंड बैठे नज़र आये और उन्होंने देखा कि जिस कुएं से भेड़-बकरियों को पानी पिलाते थे उस कुएं पर बड़ा पत्थर रखा हुआ था. ");
INSERT INTO hincv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","जब भेड़-बकरियां एक साथ इकट्ठी हो जातीं तब कुएं से पत्थर हटाकर भेड़-बकरियों को पानी पिलाया जाता था, फिर पत्थर कुएं पर वापस लुढ़का दिया जाता था. ");
INSERT INTO hincv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","याकोब ने चरवाहों से पूछा, “मेरे भाइयो, आप कहां से आए हैं?” उन्होंने कहा, “हम हारान के हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","याकोब ने पूछा, “क्या आप नाहोर के पोते लाबान को जानते हैं?” उन्होंने कहा, “हां, हम जानते हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","फिर याकोब ने पूछा, “क्या वे ठीक हैं?” उन्होंने कहा, “वे ठीक हैं और उनकी बेटी राहेल अपनी भेड़ों के साथ यहां आ रही है.” ");
INSERT INTO hincv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","याकोब ने कहा, “देखो, सूरज अभी भी ऊंचा है, अभी तो शाम नहीं हुई फिर इतनी जल्दी भेड़-बकरियों को क्यों इकट्ठा कर रहे हो, अभी उन्हें पानी पिलाकर चरने दो.” ");
INSERT INTO hincv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","लेकिन उन्होंने कहा, “नहीं, सब भेड़-बकरियां एक साथ आने पर ही कुएं से पत्थर हटाकर भेड़-बकरियों को जल पिलाया जाता है.” ");
INSERT INTO hincv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","जब वे बात कर रहे थे, राहेल अपने पिता की भेड़ें लेकर वहां आ गई, क्योंकि वह पशु चराया करती थी. ");
INSERT INTO hincv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","जब याकोब ने अपनी माता के भाई लाबान की पुत्री तथा भेड़-बकरी को देखा, तो उन्होंने जाकर कुएं के मुख से पत्थर हटाया और भेड़-बकरियों को पानी पिलाने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","तब याकोब ने राहेल को चुंबन दिया और रोने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","याकोब ने राहेल को बताया, कि वह उसके पिता के संबंधी हैं, और रेबेकाह के पुत्र हैं. राहेल दौड़ती हुई अपने पिता को यह बताने गई. ");
INSERT INTO hincv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","जब लाबान ने अपनी बहन के पुत्र याकोब के बारे में सुना, वह भी दौड़कर उनसे मिलने आये. उन्होंने याकोब को चुंबन दिया और उन्हें अपने घर पर लाए. याकोब ने लाबान को अपने बारे में बताया. ");
INSERT INTO hincv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","लाबान ने याकोब से कहा, “निःसंदेह तुम मेरी ही हड्डी एवं मांस हो.” याकोब वहां एक महीने रुके. ");
INSERT INTO hincv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","तब लाबान ने याकोब से कहा, “यद्यपि तुम मेरे संबंधी हो, यह अच्छा नहीं कि मेरे लिए तुम बिना वेतन के काम करते रहो! इसलिये तुम वेतन लेकर ही काम करना!” ");
INSERT INTO hincv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबान की दो पुत्रियां थीं. बड़ी का नाम लियाह तथा छोटी का नाम राहेल था. ");
INSERT INTO hincv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लियाह की आंखें धुंधली थी पर राहेल सुंदर थी. ");
INSERT INTO hincv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याकोब राहेल को चाहने लगे, याकोब ने लाबान से कहा, “आपकी छोटी बेटी राहेल को पाने के लिए मैं सात वर्ष आपकी सेवा करने को तैयार हूं.” ");
INSERT INTO hincv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबान ने कहा, “मैं राहेल को किसी अन्य पुरुष को देने से तुमको देना बेहतर है. तुम यहीं हमारे साथ रहो.” ");
INSERT INTO hincv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","इसलिये याकोब ने राहेल को पाने के लिए सात वर्ष सेवा की, लेकिन उसे यह समय बहुत कम लगा क्योंकि वह राहेल से बहुत प्रेम करता था. ");
INSERT INTO hincv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","फिर याकोब ने लाबान से कहा, “सात वर्ष हो गये; अब आपकी बेटी राहेल मुझे दीजिए ताकि उससे मेरी शादी हो जाये.” ");
INSERT INTO hincv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","लाबान ने अपने समाज के लोगों को बुलाकर सबको खाना खिलाया. ");
INSERT INTO hincv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","शाम को उसने अपनी बेटी लियाह को याकोब को सौंप दी और याकोब ने उसके साथ विवाह किया. ");
INSERT INTO hincv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","लाबान ने अपनी दासी ज़िलपाह को भी लियाह को उसकी दासी होने के लिए दिया. ");
INSERT INTO hincv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","जब याकोब को मालूम पड़ा कि वह तो लियाह थी, याकोब ने लाबान से पूछा, “यह क्या किया आपने मेरे साथ? मैं आपकी सेवा राहेल के लिए कर रहा था? फिर आपने मेरे साथ ऐसा धोखा क्यों किया?” ");
INSERT INTO hincv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबान ने कहा, “हमारे समाज में बड़ी को छोड़ पहले छोटी की शादी नहीं कर सकते. ");
INSERT INTO hincv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","विवाह के उत्सव को पूरे सप्‍ताह मनाते रहो और मैं राहेल को भी तुम्हें विवाह के लिए दूंगा; परंतु तुम्हें और सात वर्ष तक मेरी सेवा करनी पड़ेगी.” ");
INSERT INTO hincv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","इसलिये याकोब ने ऐसा ही किया. और समारोह का वह सप्‍ताह पूरा किया, तब लाबान ने याकोब को राहेल पत्नी स्वरूप सौंप दी. ");
INSERT INTO hincv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","लाबान ने अपनी दासी बिलहाह को भी राहेल की दासी होने के लिए उसे सौंप दिया. ");
INSERT INTO hincv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","याकोब राहेल के पास गया और उसे राहेल लियाह से अधिक प्रिय थी. और उसने लाबान के लिए और सात साल सेवा की. ");
INSERT INTO hincv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","जब याहवेह ने देखा कि लियाह को प्यार नहीं मिल रहा, याहवेह ने लियाह को गर्भ से आशीषित किया और राहेल को बांझ कर दिया. ");
INSERT INTO hincv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","लियाह गर्भवती हुई और उसने एक बेटे को जन्म दिया और उसका नाम रियूबेन यह कहकर रखा, “याहवेह ने मेरे दुःख को देखा, और अब मेरे पति ज़रूर मुझसे प्रेम करेंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","लियाह का एक और पुत्र पैदा हुआ. उसने कहा, “क्योंकि याहवेह ने यह सुन लिया कि मैं प्रिय नहीं हूं और मुझे यह एक और पुत्र दिया.” उसने उसका नाम शिमओन रखा. ");
INSERT INTO hincv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","लियाह फिर से गर्भवती हुई और जब उसका एक पुत्र पैदा हुआ तब उसने कहा, “अब मेरे पति मुझसे जुड़ जायेंगे क्योंकि मैनें उनके तीन पुत्रों को जन्म दिया है.” इसलिये लियाह ने तीसरे बेटे का नाम लेवी रखा. ");
INSERT INTO hincv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","उसने एक और बेटे को जन्म दिया और कहा, “अब मैं याहवेह की स्तुति करूंगी,” इसलिये उसने उस बेटे का नाम यहूदाह रखा. उसके बाद लियाह के बच्‍चे होने बंद हो गए. ");
INSERT INTO hincv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","राहेल ने यह देखा कि याकोब के लिए उसके द्वारा कोई संतान नहीं हुई, तो उसे अपनी बहन से नफ़रत हो गई. वह याकोब से झगड़ने लगी, “मुझे संतान दीजिए, नहीं तो मैं मर जाऊंगी!” ");
INSERT INTO hincv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","यह सुन याकोब गुस्से से चिल्लाए और कहा, “क्या मैं परमेश्वर के स्थान में हूं कि तुम्हारी बंद कोख खोलूं?” ");
INSERT INTO hincv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","यह सुन उसने कहा, “तो मेरी दासी बिलहाह के पास जाइए, ताकि उसके द्वारा मैं मां बन सकूं.” ");
INSERT INTO hincv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","इसलिये राहेल ने याकोब को पत्नी स्वरूप में अपनी दासी सौंप दी, और याकोब ने बिलहाह से वैवाहिक संबंध बनाया. ");
INSERT INTO hincv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","बिलहाह गर्भवती हुई और उसका एक बेटा हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","तब राहेल ने कहा, “परमेश्वर ने मेरा न्याय किया और मेरी दुहाई सुन ली और मुझे बेटा दिया.” उसने उसका नाम दान रखा. ");
INSERT INTO hincv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","फिर राहेल की दासी बिलहाह से एक और बेटा हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","तब राहेल ने कहा, “मैंने अपनी बहन के साथ बड़ा संघर्ष किया है और अब मैं जीत गई हूं.” इसलिये इस बेटे का नाम नफताली रखा गया. ");
INSERT INTO hincv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","जब लियाह ने देखा कि उसके और बच्‍चे होने रुक गये है, तब उसने अपनी दासी ज़िलपाह को याकोब को पत्नी स्वरूप में दे दी. ");
INSERT INTO hincv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","लियाह की दासी ज़िलपाह ने याकोब से एक बेटे को जन्म दिया. ");
INSERT INTO hincv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","लियाह ने सोचा, “कैसी धन्यता है यह!” इसलिये उस बेटे का नाम गाद रखा. ");
INSERT INTO hincv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","लियाह की दासी ज़िलपाह से एक और बेटा हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","तब लियाह ने सोचा, “मैं धन्य हूं और स्त्रियां मुझे धन्य कहेंगी.” इसलिये इस पुत्र का नाम आशेर रखा. ");
INSERT INTO hincv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","खेत में गेहूं की कटाई के समय रियूबेन जब खेत में गया उसे दूदाईम नामक कुछ विशेष पौधा मिला, जिन्हें वह अपनी मां लियाह के पास ले आया. राहेल ने लियाह से कहा, “मुझे भी थोड़ा दूदाईम दे दो.” ");
INSERT INTO hincv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","लियाह ने राहेल से कहा, “क्या यह काफ़ी नहीं कि तुमने मुझसे मेरा पति छीन लिया? और अब मेरे पुत्र द्वारा लाए दूदाईम भी लेना चाहती हो?” तब राहेल ने उससे कहा, “यदि तुम मुझे यह पौधा दोगी, तो मैं आज की रात तुम्हें याकोब के साथ व्यतीत करने दूंगी.” ");
INSERT INTO hincv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","जब शाम को याकोब खेत से आये तब लियाह ने याकोब से कहा, “मैंने आपको अपने बेटे द्वारा लाए गये दूदाईम देकर किराये में लिया है.” ");
INSERT INTO hincv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","परमेश्वर ने लियाह की सुन ली. उसने गर्भधारण किया तथा याकोब को पांचवां पुत्र दिया. ");
INSERT INTO hincv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","इस पर लियाह ने कहा, “परमेश्वर ने मुझे मेरी मजदूरी दी है क्योंकि मैंने अपनी दासी मेरे पति को दी.” और इसलिये उसका नाम इस्साखार रखा. ");
INSERT INTO hincv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","फिर लियाह ने छठे पुत्र को जन्म दिया. ");
INSERT INTO hincv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","लियाह ने कहा, “परमेश्वर ने मुझे एक उत्तम भेंट से सम्मानित किया है. अब मेरे पति मेरी कद्र करेंगे, क्योंकि मैंने उनको छः पुत्र दिये हैं.” और इसलिये उस पुत्र का नाम ज़ेबुलून रखा. ");
INSERT INTO hincv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","फिर कुछ समय बाद लिया की एक बेटी हुई, उसका नाम दीनाह रखा. ");
INSERT INTO hincv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","इसके बाद परमेश्वर ने राहेल पर दया की. परमेश्वर ने उसे गर्भधारण करने के लिए सक्षम किया. ");
INSERT INTO hincv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","उसे एक बेटा हुआ, और उसने कहा, “परमेश्वर ने मेरा कलंक मिटा दिया है.” ");
INSERT INTO hincv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","यह कहते हुए उसे योसेफ़ नाम दिया कि याहवेह मुझे एक और पुत्र दें. ");
INSERT INTO hincv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","जब राहेल ने योसेफ़ को जन्म दिया, तब याकोब ने लाबान से कहा, “अब मुझे मेरे देश जाने दीजिए. ");
INSERT INTO hincv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","मुझे मेरी पत्नियां एवं संतान दे दीजिए, जिसके लिए मैंने इतने वर्ष आपकी सेवा की है. जो सेवा मैं आपके लिए करता रहा हूं, वह आपको मालूम है.” ");
INSERT INTO hincv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","किंतु लाबान ने कहा, “याहवेह की ओर से मुझे यह मालूम हुआ है, कि मुझे जो आशीष मिली है, वह तुम्हारे ही कारण मिली है. इसलिये तुम मुझसे नाराज नहीं हो, तो मेरे यहां ही रहो.” ");
INSERT INTO hincv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","लाबान ने कहा, “सेवा के बदले तुम क्या चाहते हो, मैं तुम्हें वही दूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","किंतु याकोब ने लाबान से कहा, “मैंने आपकी सेवा कैसे की है, यह बात आपसे छिपी नहीं है, और आपके पशु की देखरेख भी मैंने कैसे की हैं. ");
INSERT INTO hincv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","पहले पशु कम थे लेकिन अब बहुत ज्यादा हो गये हैं. मैंने जो भी काम किया, उसमें याहवेह ने आशीष दी है. लेकिन अब मैं अपने घराने के बारे में सोचना चाहता हूं.” ");
INSERT INTO hincv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","तब लाबान ने पूछा, “तुम्हारी मजदूरी क्या होगी?” याकोब ने कहा, “आप मुझे कुछ न दीजिए. लेकिन, आप चाहें तो आपके पशुओं की चरवाही तथा देखभाल करता रहूंगा: ");
INSERT INTO hincv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","आज मैं भेड़-बकरियों में से, धारी वाले सब एक तरफ और बिना धारी वाले एक तरफ करके अलग करूंगा और इस तरह दोनों को अलग रखकर उनकी देखरेख करूंगा. ");
INSERT INTO hincv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","जब आप मेरी मजदूरी देने आएंगे तब इन भेड़-बकरियों को जो अलग करके रखी हैं आप देखना और यदि इन भेड़-बकरियों में से कोई धारी वाली और चितकबरी न हो वह दिखे तो उसे चोरी किया हुआ मान लेना.” ");
INSERT INTO hincv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","लाबान ने उत्तर दिया, “ठीक हैं, तुम जैसा चाहते हो वैसा करो.” ");
INSERT INTO hincv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","पर उस दिन लाबान ने धारी वाले तथा धब्बे युक्त बकरों तथा सभी चित्तीयुक्त एवं धब्बे युक्त बकरियों को अलग कर दिया तथा हर एक, जिस पर श्वेत रंग पाया गया तथा भेड़ों में से सभी काली भेड़ अलग कर इन सभी को अपने पुत्रों को सौंप दिया. ");
INSERT INTO hincv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","तब उन्होंने अपने व याकोब के बीच तीन दिन की यात्रा की दूरी बना ली. अब याकोब लाबान की बच गई भेड़-बकरियों की चरवाही करने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","कुछ समय बाद याकोब ने चिनार, बादाम तथा अर्मोन वृक्ष की टहनियां लेकर उनकी छाल छील कर उन पर सफेद धारियां बनाई इससे उन टहनियों के अंदर का सफेद भाग दिखने लगा. ");
INSERT INTO hincv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","फिर याकोब ने इन छड़ियों को हौदों में सजा दिया, ताकि वे सीधे भेड़-बकरियों के सामने हों जहां वे भेड़ें पानी पिया करती थीं. ");
INSERT INTO hincv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","वे छड़ियों के सामने समागम किया और बकरियां गाभिन हुईं, और जब बच्‍चे होते थे तो वे धारीयुक्त, चित्तीयुक्त अथवा धब्बे युक्त होते थे. ");
INSERT INTO hincv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","याकोब उनको अलग करते जाते थे. साथ ही वे भेड़ों का मुख लाबान की धारीयुक्त तथा पूरी काली भेड़ों की ओर कर देते थे. इस प्रकार वह अपने पशु तथा लाबान के पशु को अलग रखते थे. ");
INSERT INTO hincv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","जब ताकतदार भेड़े समागम करते थे, याकोब उन्हीं के समक्ष नांदों में वे छड़ियां रख देते थे, कि उनका समागम उन्हीं छड़ियों के समक्ष हो, ");
INSERT INTO hincv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","किंतु जब उनके समक्ष दुर्बल भेड़ें होती थीं, तब वह उन छड़ियों को उनके समक्ष नहीं रखते थे. परिणामस्वरूप, समस्त दुर्बल भेड़ें लाबान के पक्ष में तथा सशक्त भेड़ें याकोब के पक्ष में आ जाती थी. ");
INSERT INTO hincv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","इसलिये याकोब बहुत धनी हो गये, उनके पास बहुत भेड़-बकरियां दास-दासियां, ऊंट तथा गधे भी थे. ");
INSERT INTO hincv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","याकोब के कानों में यह समाचार पड़ा कि लाबान के पुत्र बड़बड़ा रहे थे, “याकोब ने तो वह सब हड़प लिया है, जो हमारे पिता का था और अब वह हमारे पिता ही की संपत्ति के आधार पर समृद्ध बना बैठा है.” ");
INSERT INTO hincv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","यहां याकोब ने पाया कि लाबान की अभिवृत्ति उनके प्रति अब पहले जैसी नहीं रह गई थी. ");
INSERT INTO hincv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","इस स्थिति के प्रकाश में याहवेह ने याकोब को आदेश दिया, “अपने पिता एवं अपने संबंधियों के देश को लौट जाओ. मैं इसमें तुम्हारे पक्ष में हूं.” ");
INSERT INTO hincv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","इसलिये याकोब ने राहेल तथा लियाह को वहीं बुला लिया, जहां वे भेड़-बकरियों के साथ थे. ");
INSERT INTO hincv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","उन्होंने उनसे कहा, “मैं तुम्हारे पिता की अभिवृत्ति स्पष्ट देख रहा हूं; अब यह मेरे प्रति पहले जैसी सौहार्दपूर्ण नहीं रह गई; किंतु मेरे पिता के परमेश्वर मेरे साथ रहे हैं. ");
INSERT INTO hincv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","तुम दोनों को ही यह उत्तम रीति से ज्ञात है कि मैंने यथाशक्ति तुम्हारे पिता की सेवा की है. ");
INSERT INTO hincv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","इतना होने पर भी तुम्हारे पिता ने मेरे साथ छल किया और दस अवसरों पर मेरे पारिश्रमिक में परिवर्तन किए हैं; फिर भी परमेश्वर ने उन्हें मेरी कोई हानि न करने दी. ");
INSERT INTO hincv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","यदि उन्होंने कहा, ‘चित्तीयुक्त पशु तुम्हारे पारिश्रमिक होंगे,’ तो सभी भेड़ चित्तीयुक्त मेमने ही पैदा करने लगे; यदि उन्होंने कहा, ‘अच्छा, धारीयुक्त पशु तुम्हारा पारिश्रमिक होंगे,’ तो भेड़ धारीयुक्त मेमने उत्पन्‍न करने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","यह तो परमेश्वर का ही कृत्य था, जो उन्होंने तुम्हारे पिता के ये पशु मुझे दे दिए हैं. ");
INSERT INTO hincv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“तब पशुओं के समागम के अवसर पर मैंने एक स्वप्न देखा कि वे बकरे, जो संभोग कर रहे थे, वे धारीयुक्त, चित्तीयुक्त एवं धब्बे युक्त थे. ");
INSERT INTO hincv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","परमेश्वर के दूत ने स्वप्न में मुझसे कहा, ‘याकोब,’ मैंने कहा, ‘क्या आज्ञा है, प्रभु?’ ");
INSERT INTO hincv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","और उसने कहा, ‘याकोब, देखो-देखो, जितने भी बकरे इस समय संभोग कर रहे हैं, वे धारीयुक्त हैं, चित्तीयुक्त हैं तथा धब्बे युक्त हैं; क्योंकि मैंने वह सब देख लिया है, जो लाबान तुम्हारे साथ करता रहा है. ");
INSERT INTO hincv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","मैं बेथेल का परमेश्वर हूं, जहां तुमने उस शिलाखण्ड का अभ्यंजन किया था, जहां तुमने मेरे समक्ष संकल्प लिया था; अब उठो. छोड़ दो इस स्थान को और अपने जन्मस्थान को लौट जाओ.’ ” ");
INSERT INTO hincv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","राहेल तथा लियाह ने उनसे कहा, “क्या अब भी हमारे पिता की संपत्ति में हमारा कोई अंश अथवा उत्तराधिकार शेष रह गया है? ");
INSERT INTO hincv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","क्या अब हम उनके आंकलन में विदेशी नहीं हो गई हैं? उन्होंने हमें बेच दिया है, तथा हमारे अंश की धनराशि भी हड़प ली है. ");
INSERT INTO hincv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","निःसंदेह अब तो, जो संपत्ति परमेश्वर ने हमारे पिता से छीन ली है, हमारी तथा हमारी संतान की हो चुकी है. तो आप वही कीजिए, जिसका निर्देश आपको परमेश्वर दे चुके हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","तब याकोब ने अपने बालकों एवं पत्नियों को ऊंटों पर बैठा दिया, ");
INSERT INTO hincv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","याकोब ने अपने समस्त पशुओं को, अपनी समस्त संपत्ति को, जो उनके वहां रहते हुए संकलित होती गई थी तथा वह पशु धन, जो पद्दन-अराम में उनके प्रवासकाल में संकलित होता चला गया था, इन सबको लेकर अपने पिता यित्सहाक के आवास कनान की ओर प्रस्थान किया. ");
INSERT INTO hincv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","जब लाबान ऊन कतरने के लिए बाहर गया हुआ था, राहेल ने अपने पिता के गृहदेवता—प्रतिमाओं की चोरी कर ली. ");
INSERT INTO hincv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","तब याकोब ने भी अरामी लाबान के साथ प्रवंचना की; याकोब ने लाबान को सूचित ही नहीं किया कि वे पलायन कर रहे थे. ");
INSERT INTO hincv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","इसलिये याकोब अपनी समस्त संपत्ति को लेकर पलायन कर गए. उन्होंने फरात नदी पार की और पर्वतीय प्रदेश गिलआद की दिशा में आगे बढ़ गए. ");
INSERT INTO hincv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","तीसरे दिन जब लाबान को यह सूचना दी गई कि याकोब पलायन कर चुके हैं, ");
INSERT INTO hincv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","तब लाबान ने अपने संबंधियों को साथ लेकर याकोब का पीछा किया. सात दिन पीछा करने के बाद वे गिलआद के पर्वतीय प्रदेश में उनके निकट पहुंच गए. ");
INSERT INTO hincv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","परमेश्वर ने अरामी लाबान पर रात्रि में स्वप्न में प्रकट होकर उसे चेतावनी दी, “सावधान रहना कि तुम याकोब से कुछ प्रिय-अप्रिय न कह बैठो.” ");
INSERT INTO hincv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","लाबान याकोब तक जा पहुंचा. याकोब के शिविर पर्वतीय क्षेत्र में थे तथा लाबान ने भी अपने शिविर अपने संबंधियों सदृश गिलआद के पर्वतीय क्षेत्र में खड़े किए हुए थे. ");
INSERT INTO hincv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","लाबान ने याकोब से कहा, “यह क्या कर रहे हो तुम? यह तो मेरे साथ छल है! तुम तो मेरी पुत्रियों को ऐसे लिए जा रहे हो, जैसे युद्धबन्दियों को तलवार के आतंक में ले जाया जाता है. ");
INSERT INTO hincv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","क्या आवश्यकता थी ऐसे छिपकर भागने की, मुझसे छल करने की? यदि तुमने मुझे इसकी सूचना दी होती, तो मैं तुम्हें डफ तथा किन्‍नोर की संगत पर गीतों के साथ सहर्ष विदा करता! ");
INSERT INTO hincv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","तुमने तो मुझे सुअवसर ही न दिया कि मैं अपने पुत्र-पुत्रियों को चुंबन के साथ विदा कर सकता. तुम्हारा यह कृत्य मूर्खतापूर्ण है. ");
INSERT INTO hincv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","मुझे यह अधिकार है कि तुम्हें इसके लिए प्रताड़ित करूं; किंतु तुम्हारे पिता के परमेश्वर ने कल रात्रि मुझ पर प्रकट होकर मुझे आदेश दिया है कि मैं तुमसे कुछ भी प्रिय-अप्रिय न कहूं. ");
INSERT INTO hincv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ठीक है, तुम्हें अपने पिता के निकट रहने की इच्छा है, मान लिया; किंतु क्या आवश्यकता थी तुम्हें मेरे गृह-देवताओं की चोरी करने की?” ");
INSERT INTO hincv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","तब याकोब ने लाबान को उत्तर दिया, “मेरे इस प्रकार आने का कारण थी मेरी यह आशंका, कि आप मुझसे अपनी पुत्रियां बलात छीन लेते. ");
INSERT INTO hincv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","किंतु आपको जिस किसी के पास से वे गृहदेवता प्राप्‍त होंगे, उसे जीवित न छोड़ा जाएगा. आपके ही संबंधियों की उपस्थिति में आप हमारी संपत्ति में से जो कुछ आपका है, ले लीजिए.” याकोब को इस तथ्य का कोई संज्ञान न था कि राहेल ने उन गृह-देवताओं की मूर्तियों को चुराई हैं. ");
INSERT INTO hincv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","इसलिये लाबान याकोब के शिविर के भीतर गया, उसके बाद लियाह के शिविर में, और उसके बाद परिचारिकाओं के शिविर में. किंतु वह देवता उसे वहां प्राप्‍त न हुआ. तब वह लियाह के शिविर से निकलकर राहेल के शिविर में गया. ");
INSERT INTO hincv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राहेल ने ही वे गृहदेवता छिपाए हुए थे, जिन्हें उसने ऊंट की काठी में रखा हुआ था. वह स्वयं उन पर बैठ गई थी. लाबान ने समस्त शिविर में खोज कर ली थी, किंतु उसे कुछ प्राप्‍त न हुआ था. ");
INSERT INTO hincv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","उसने अपने पिता से आग्रह किया, “पिताजी, आप क्रुद्ध न हों. मैं आपके समक्ष खड़ी होने के असमर्थ हूं; क्योंकि इस समय मैं रजस्वला हूं.” तब लाबान के खोजने पर भी उसे वे गृह-देवताओं की मूर्तियां नहीं मिलीं. ");
INSERT INTO hincv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","तब याकोब का क्रोध उद्दीप्‍त हो उठा. वह लाबान से तर्क-वितर्क करने लगे, “क्या अपराध है मेरा?” क्या पाप किया है मैंने, जो आप इस प्रकार मेरा पीछा करते हुए आ रहे हैं? ");
INSERT INTO hincv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","आपने मेरी समस्त वस्तुओं में उन देवताओं की खोज कर ली है, किंतु आपको कोई भी अपनी वस्तु प्राप्‍त हुई है? आपके तथा मेरे संबंधियों के समक्ष यह स्पष्ट हो जाए, कि वे हम दोनों के मध्य अपना निर्णय दे सकें. ");
INSERT INTO hincv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“इन बीस वर्षों तक मैं आपके साथ रहा हूं. आपकी भेड़ों एवं बकरियों में कभी गर्भपात नहीं हुआ. अपने भोजन के लिए मैंने कभी आपके पशुवृन्द में से मेढ़े नहीं उठाए. ");
INSERT INTO hincv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","जब कभी किसी वन्य पशु ने हमारे पशु को फाड़ा, मैंने उसे कभी आपके वृन्द में सम्मिलित नहीं किया; इसे मैंने अपनी ही हानि में सम्मिलित किया था. चाहे कोई पशु दिन में चोरी हुआ अथवा रात्रि में, आपने मुझसे भुगतान की मांग की. ");
INSERT INTO hincv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","मेरी स्थिति तो ऐसी रही कि दिन में मुझ पर ऊष्मा का प्रहार होता रहा तथा रात्रि में ठंड का. मेरे नेत्रों से निद्रा दूर ही दूर रही. ");
INSERT INTO hincv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","इन बीस वर्षों में मैं आपके परिवार में रहा हूं; चौदह वर्ष आपकी पुत्रियों के लिए तथा छः वर्ष आपके भेड़-बकरियों के लिए. इन वर्षों में आपने दस बार मेरा पारिश्रमिक परिवर्तित किया है. ");
INSERT INTO hincv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","यदि मेरे पिता के परमेश्वर, अब्राहाम तथा यित्सहाक के परमेश्वर का भय मेरे साथ न होता, तो आपने तो मुझे रिक्त हस्त ही विदा कर दिया होता. परमेश्वर ने मेरे कष्ट एवं मेरे हाथों के परिश्रम को देखा है, और उसका प्रतिफल उन्होंने मुझे कल रात में प्रदान कर दिया है.” ");
INSERT INTO hincv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","यह सब सुनकर लाबान ने याकोब को उत्तर दिया, “ये स्त्रियां मेरी पुत्रियां हैं, ये बालक मेरे बालक हैं, ये भेड़-बकरियां भी मेरी ही हैं, तथा जो कुछ तुम्हें दिखाई दे रहा है, वह मेरा ही है; किंतु अब मैं अपनी पुत्रियों एवं इन बालकों का क्या करूं, जो इनकी सन्तति हैं? ");
INSERT INTO hincv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","इसलिये आओ, हम परस्पर यह वाचा स्थापित कर लें, तुम और मैं, और यही हमारे मध्य साक्ष्य हो जाए.” ");
INSERT INTO hincv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","इसलिये याकोब ने एक शिलाखण्ड को स्तंभ स्वरूप खड़ा किया. ");
INSERT INTO hincv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","याकोब ने अपने संबंधियों से कहा, “पत्थर एकत्र करो.” इसलिये उन्होंने पत्थर एकत्र कर एक ढेर बना दिया तथा उस ढेर के निकट बैठ उन्होंने भोजन किया. ");
INSERT INTO hincv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","लाबान ने तो इसे नाम दिया येगर-सहदूथा किंतु याकोब ने इसे गलएद कहकर पुकारा. ");
INSERT INTO hincv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबान ने कहा, “पत्थरों का यह ढेर आज मेरे तथा तुम्हारे मध्य एक साक्ष्य है.” इसलिये इसे गलएद तथा मिज़पाह नाम दिया गया, ");
INSERT INTO hincv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","क्योंकि उनका कथन था, “जब हम एक दूसरे की दृष्टि से दूर हों, याहवेह ही तुम्हारे तथा मेरे मध्य चौकसी बनाए रखें. ");
INSERT INTO hincv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","यदि तुम मेरी पुत्रियों के साथ दुर्व्यवहार करो अथवा मेरी पुत्रियों के अतिरिक्त पत्नियां ले आओ, यद्यपि कोई मनुष्य यह देख न सकेगा, किंतु स्मरण रहे, तुम्हारे तथा मेरे मध्य परमेश्वर साक्ष्य हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","लाबान ने याकोब से कहा, “इस ढेर को तथा इस स्तंभ को देखो, जो मैंने तुम्हारे तथा मेरे मध्य में स्थापित किया है. ");
INSERT INTO hincv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","यह स्तंभ तथा पत्थरों का ढेर साक्ष्य है, कि मैं इसके निकट से होकर तुम्हारी हानि करने के लक्ष्य से आगे नहीं बढ़ूंगा, वैसे ही तुम भी इस ढेर तथा इस स्तंभ के निकट से होकर मेरी हानि के उद्देश्य से आगे नहीं बढ़ोगे. ");
INSERT INTO hincv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","इसके लिए अब्राहाम के परमेश्वर, नाहोर के परमेश्वर तथा उनके पिता के परमेश्वर हमारा न्याय करें.” इसलिये याकोब ने अपने पिता यित्सहाक के प्रति भय-भाव में शपथ ली. ");
INSERT INTO hincv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","फिर याकोब ने उस पर्वत पर ही बलि अर्पित की तथा अपने संबंधियों को भोज के लिए आमंत्रित किया. उन्होंने भोजन किया तथा पर्वत पर ही रात्रि व्यतीत की. ");
INSERT INTO hincv_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","बड़े तड़के लाबान उठा, अपने पुत्र-पुत्रियों का चुंबन लिया तथा उन्हें आशीर्वाद दिया. फिर लाबान स्वदेश लौट गया. ");
INSERT INTO hincv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","जब याकोब अपने देश की ओर निकले तब रास्ते में उनकी भेंट परमेश्वर के दूत से हुई. ");
INSERT INTO hincv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","उन्हें देखकर याकोब ने कहा, “यह परमेश्वर का शिविर है!” उन्होंने उस जगह को माहानाईम नाम दिया. ");
INSERT INTO hincv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","याकोब ने अपने भाई एसाव के पास एदोम के सेईर देश में दूत भेजे, ");
INSERT INTO hincv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","और उनसे कहा कि मेरा स्वामी एसाव से यह कहना कि आपके सेवक याकोब कहता है, “मैं लाबान के यहां पराये होकर अब तक वहीं रहा. ");
INSERT INTO hincv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","अब मेरे पास बैल, गधे तथा स्त्री-पुरुष व दासियां हैं. मेरे अधिपति एसाव के पास दूत भेजने का कारण यह था कि आपकी कृपादृष्टि मुझ पर बनी रहे.” ");
INSERT INTO hincv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","जब वे दूत लौटकर याकोब के पास आए और उन्हें बताया, “हम आपके भाई से मिले. वे आपसे मिलने यहां आ रहे हैं और उनके साथ चार सौ व्यक्तियों का झुंड भी है.” ");
INSERT INTO hincv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","यह सुन याकोब बहुत डर गये एवं व्याकुल हो गए. उन्होंने अपने साथ चल रहे लोगों को दो भागों में बांट दिया तथा भेड़-बकरियों, गाय-बैलों तथा ऊंटों के दो समूह बना दिए. ");
INSERT INTO hincv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","यह सोचकर कि, अगर एसाव आकर एक झुंड पर आक्रमण करेगा, तो दूसरा झुंड बचकर भाग जायेगा. ");
INSERT INTO hincv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","याकोब ने कहा, “हे याहवेह, मेरे पिता अब्राहाम तथा यित्सहाक के परमेश्वर, आपने ही मुझे अपने देश जाने को कहा और कहा कि मैं तुम्हें आशीषित करूंगा. ");
INSERT INTO hincv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","आपने मुझे जितना प्रेम किया, बढ़ाया और आशीषित किया, मैं उसके योग्य नहीं हूं, क्योंकि जाते समय मेरे पास एक छड़ी ही थी जिसको लेकर मैंने यरदन नदी पार की थी और ");
INSERT INTO hincv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","अब मैं इन दो समूहों के साथ लौट रहा हूं. प्रभु, मेरी बिनती है कि आप मुझे मेरे भाई एसाव से बचाएं. मुझे डर है कि वह आकर मुझ पर, व इन माताओं और बालकों पर आक्रमण करेगा. ");
INSERT INTO hincv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","आपने कहा था कि निश्चय मैं तुम्हें बढ़ाऊंगा तथा तुम्हारे वंश की संख्या सागर तट के बालू समान कर दूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","याकोब ने रात वहीं बिताई. और उन्होंने अपनी संपत्ति में से अपने भाई एसाव को उपहार देने के लिए अलग किया: ");
INSERT INTO hincv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","दो सौ बकरियां तथा बीस बकरे, दो सौ भेड़ें तथा बीस मेढ़े, ");
INSERT INTO hincv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","तीस दुधार ऊंटनियां तथा उनके शावक, चालीस गायें तथा दस सांड़, बीस गधियां तथा दस गधे. ");
INSERT INTO hincv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","याकोब ने पशुओं के अलग-अलग झुंड बनाकर अपने सेवकों को सौंप दिए, और उन्होंने अपने सेवकों से कहा, “मेरे आगे-आगे चलते जाओ तथा हर एक झुंड के बीच थोड़ी जगह छोड़ना.” ");
INSERT INTO hincv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","जो सबसे आगे था उनसे कहा: “जब तुम मेरे भाई एसाव से मिलोगे और वह तुमसे पूछेगा, ‘कौन है तुम्हारा स्वामी और कहां जा रहे हो? और ये सब पशु, जो आगे जा रहे हैं, किसके हैं?’ ");
INSERT INTO hincv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","तब तुम उनसे कहना, ‘ये सभी आपके भाई याकोब के हैं, जो उपहार में उनके अधिपति एसाव को दिए जा रहे हैं. और याकोब हमारे पीछे आ रहे हैं.’ ” ");
INSERT INTO hincv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","याकोब ने यही बात दूसरे तथा तीसरे तथा उन सभी को कही, जो उनके पीछे-पीछे आ रहे थे. ");
INSERT INTO hincv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","“तुम यह कहना, ‘आपके सेवक याकोब पीछे आ रहे हैं.’ ” क्योंकि याकोब ने सोचा, “इतने उपहार देकर मैं एसाव को खुश कर दूंगा. इसके बाद मैं उनके साथ जाऊंगा. तब ज़रूर, वह मुझे स्वीकार कर लेंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","और इसी तरह सब उपहार आगे बढ़ते गये, और याकोब तंबू में रहे. ");
INSERT INTO hincv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","उस रात याकोब उठे और अपनी दोनों पत्नियों, दोनों दासियों एवं बालकों को लेकर यब्बोक के घाट के पार चले गए. ");
INSERT INTO hincv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","याकोब ने सबको नदी की दूसरी तरफ भेज दिया. ");
INSERT INTO hincv_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","और याकोब वहीं रुक गये. एक व्यक्ति वहां आकर सुबह तक उनसे मल्ल-युद्ध करता रहा. ");
INSERT INTO hincv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","जब उस व्यक्ति ने यह देखा कि वह याकोब को हरा नहीं सका तब उसने याकोब की जांघ की नस को छुआ और मल्ल-युद्ध करते-करते ही उनकी नस चढ़ गई. ");
INSERT INTO hincv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","यह होने पर उस व्यक्ति ने याकोब से कहा, “अब मुझे जाने दो.” किंतु याकोब ने उस व्यक्ति से कहा, “नहीं, मैं आपको तब तक जाने न दूंगा, जब तक आप मुझे आशीष न देंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","तब उसने याकोब से पूछा, “तुम्हारा नाम क्या है?” उसने कहा, “याकोब.” ");
INSERT INTO hincv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","तब उस व्यक्ति ने उनसे कहा, “अब से तुम्हारा नाम याकोब नहीं बल्कि इस्राएल होगा, क्योंकि परमेश्वर से तथा मनुष्यों से संघर्ष करते हुए तुम जीत गए हो.” ");
INSERT INTO hincv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","तब याकोब ने उस व्यक्ति से कहा, “कृपया आप मुझे अपना नाम बताइए.” उस व्यक्ति ने उत्तर दिया, “क्या करोगे मेरा नाम जानकर?” और तब उस व्यक्ति ने वहीं याकोब को आशीष दी. ");
INSERT INTO hincv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","जहां यह सब कुछ हुआ याकोब ने उस स्थान का नाम पनीएल रखा, यह कहकर कि “मैंने परमेश्वर को आमने-सामने देखा, फिर भी मेरा जीवन बच गया!” ");
INSERT INTO hincv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","जब याकोब पनीएल से निकले तब सूरज उसके ऊपर उग आया था. वह अपनी जांघ के कारण लंगड़ा रहे थे. ");
INSERT INTO hincv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","इस घटना का स्मरण करते हुए इस्राएल वंश आज तक जांघ की पुट्ठे की मांसपेशी को नहीं खाते क्योंकि उस व्यक्ति ने याकोब के जांघ की इसी मांसपेशी पर छुआ था. ");
INSERT INTO hincv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","याकोब ने देखा कि दूर एसाव अपने चार सौ साथियों के साथ आ रहे थे; याकोब ने अपने बालकों को लियाह, राहेल तथा दोनों दासियों को दो भागों में कर दिये. ");
INSERT INTO hincv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","उन्होंने दोनों दासियों तथा उनके बालकों को सबसे आगे कर दिया, उनके पीछे लियाह और उसकी संतान तथा राहेल और योसेफ़ सबसे पीछे थे. ");
INSERT INTO hincv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","याकोब सबसे आगे थे और एसाव को देखते ही सात बार भूमि पर गिरकर दंडवत किया और एसाव के पास पहुंचे. ");
INSERT INTO hincv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","एसाव दौड़ते हुए आए और याकोब को गले लगाया और चुंबन किया. और दोनो रोने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","एसाव ने स्त्रियों एवं बालकों को देखा. उसने पूछा, “तुम्हारे साथ ये सब कौन हैं?” याकोब ने कहा ये बालक, “जो परमेश्वर ने अपनी कृपा से आपके दास को दिये हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","और दासियां अपने-अपने बालकों के साथ पास आई और झुककर प्रणाम किया. ");
INSERT INTO hincv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","वैसे ही लियाह अपने बालकों के साथ पास आई, उसने भी झुककर प्रणाम किया और फिर राहेल के साथ योसेफ़ भी आया और प्रणाम किया. ");
INSERT INTO hincv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","एसाव ने याकोब से पूछा, “ये गाय, बैल मुझे क्यों दिया, समझ में नहीं आया.” याकोब बोले, “मेरे अधिपति, मैं इसके द्वारा आपकी दया पाना चाहता हूं.” ");
INSERT INTO hincv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","एसाव ने कहा, “हे मेरे भाई मेरे पास सब कुछ है. और जो कुछ तुम्हारा है, उसे अपने ही पास रहने दो.” ");
INSERT INTO hincv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकोब ने कहा, “नहीं! यदि आपका अनुग्रह मुझ पर है, तो मेरी ओर से इन उपहारों को स्वीकार कर लीजिए; क्योंकि आपको देखकर लगा कि मैंने परमेश्वर के दर्शन पा लिये, और आपने मुझे दिल से स्वीकारा भी है. ");
INSERT INTO hincv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","कृपा कर आप मेरे द्वारा प्रस्तुत इस भेंट को स्वीकार कर लीजिए, जो मैं आपके लिए लाया हूं, क्योंकि मेरे प्रति परमेश्वर अत्यंत कृपालु रहे हैं तथा मेरे पास बहुत है.” जब याकोब ने ज़बरदस्ती की, एसाव ने वह भेंट स्वीकार कर ली. ");
INSERT INTO hincv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","फिर एसाव ने कहा, “चलो, यहां से अपने घर चलें. मैं तुम्हारे आगे-आगे चलूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","इस पर याकोब ने एसाव से कहा, “मेरे स्वामी, आप जानते हैं कि बालक कमजोर हैं भेड़-बकरी एवं गायें जो दूध देनेवाली हैं, उनका ध्यान रखना बहुत ज़रूरी है. ");
INSERT INTO hincv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","इसलिये मेरे स्वामी, आप आगे चलिये और मैं आपके पीछे-पीछे धीरे से, भेड़-बकरी एवं गायों का ध्यान रखते हुए उनकी रफ़्तार में चलूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","तब एसाव ने याकोब से कहा, “मैं अपने साथियों को आपके पास छोड़ देता हूं.” तब याकोब ने कहा, “क्या इसकी ज़रूरत है? मुझ पर मेरे स्वामी की दया बनी रहे, यही काफ़ी है.” ");
INSERT INTO hincv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","इसलिये एसाव उसी दिन सेईर चले गये. ");
INSERT INTO hincv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","याकोब सुक्कोथ की दिशा में आगे बढ़े. वहीं उन्होंने अपने लिए एक घर बनाया तथा पशुओं के रहने के लिए प्रबंध किया. इसलिये इस स्थान का नाम सुक्कोथ पड़ गया. ");
INSERT INTO hincv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","पद्दन-अराम से यात्रा करते हुए याकोब कनान देश के शेकेम नगर पहुंचे और उन्होंने नगर के पास तंबू खड़े किए. ");
INSERT INTO hincv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","जिस स्थान पर उन्होंने तंबू खड़े किए, उस ज़मीन को उन्होंने शेकेम के पिता, हामोर के पुत्रों से एक सौ चांदी की मुद्राएं देकर खरीदा था. ");
INSERT INTO hincv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","फिर याकोब ने वहां एक वेदी बनाई, जिसे उन्होंने एल-एलोहे-इस्राएल नाम रखा. ");
INSERT INTO hincv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","लियाह की पुत्री दीनाह उस देश की लड़कियों के साथ स्त्रियों को देखने के लिए बाहर गई. ");
INSERT INTO hincv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","उस देश के शासक हिव्वी हामोर के पुत्र शेकेम ने उसे देखा, वह उसे अपने साथ ले गया उसने उसे पकड़ लिया और उसने उसके साथ बलात्कार किया. ");
INSERT INTO hincv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","याकोब की पुत्री दीनाह से उसे प्रेम था और उसके प्रति उसका व्यवहार अच्छा था. ");
INSERT INTO hincv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","शेकेम ने अपने पिता हामोर से कहा, “मेरा विवाह इस युवती से कर दीजिए.” ");
INSERT INTO hincv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","जब याकोब को पता चला कि शेकेम ने उनकी पुत्री को दूषित कर दिया है, उस समय उनके पुत्र पशुओं के साथ मैदान में थे; इसलिये याकोब उनके लौटने तक शांत रहे. ");
INSERT INTO hincv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","इसी समय शेकेम का पिता हामोर याकोब से मिलने आये. ");
INSERT INTO hincv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","जब याकोब के पुत्र लौटे और उन्हें सब बात पता चली तब वे बहुत उदास और नाराज हुए, क्योंकि उसने याकोब की पुत्री से संभोग द्वारा इस्राएल में मूर्खता का काम कर डाला था, एक ऐसा काम, जो अनुचित था. ");
INSERT INTO hincv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","किंतु हामोर ने उनसे कहा, “मेरा पुत्र शेकेम आपकी पुत्री को चाहता है. कृपया उसका विवाह मेरे पुत्र से कर दीजिए. ");
INSERT INTO hincv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","हमारे साथ वैवाहिक संबंध बना लीजिए आप हमें अपनी पुत्रियां दीजिए और आप हमारी पुत्रियां लीजिए. ");
INSERT INTO hincv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","इस प्रकार आप हमारे साथ इस देश में मिलकर रह पायेंगे. आप इस देश में रहिये, व्यवसाय कीजिए तथा संपत्ति प्राप्‍त करते जाइए.” ");
INSERT INTO hincv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","शेकेम ने दीनाह के पिता तथा उसके भाइयों से यह भी कहा, “यदि मैंने आपकी कृपादृष्टि प्राप्‍त कर ली है, तो आप अपने मन की बात कह दीजिए कि मैं उसे पूरा कर सकूं. ");
INSERT INTO hincv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","आप वधू के लिए जो भी मांगेंगे उसे मैं पूरा करूंगा. किंतु मेरा विवाह उसी युवती से कीजिए.” ");
INSERT INTO hincv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","तब याकोब के पुत्रों ने शेकेम को तथा उसके पिता हामोर को छलपूर्ण उत्तर दिया, क्योंकि शेकेम ने उनकी बहन दीनाह को दूषित कर दिया था. ");
INSERT INTO hincv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","उन्होंने उन्हें उत्तर दिया, “यह हमारे लिए संभव नहीं है कि हम किसी ख़तना रहित को अपनी बहन दे सकें. क्योंकि यह हमारे लिए शर्मनाक है. ");
INSERT INTO hincv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","एक ही शर्त पर यह बात हो सकती है: आपके देश के हर एक पुरुष का ख़तना किया जाए, ताकि आप हमारे समान हो जाएं. ");
INSERT INTO hincv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","तब हममें पुत्रियों का लेना देना हो सकेगा और हम आपके बीच रह सकेंगे, और हम एक ही लोग बन जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","यदि आपको हमारी बात सही नहीं लगी, तो हम अपनी पुत्री को लेकर यहां से चले जाएंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","उनकी यह बात हामोर तथा उसके पुत्र शेकेम को पसंद आई. ");
INSERT INTO hincv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","याकोब की पुत्री शेकेम को बहुत पसंद थी कि उसने इस काम को करने में देरी नहीं की. अपने पिता के परिवार में वह सम्मानित व्यक्ति था. ");
INSERT INTO hincv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","इसलिये हामोर एवं उसके पुत्र शेकेम ने नगर में जाकर नगर के सब लोगों से कहा, ");
INSERT INTO hincv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ये लोग हमारे साथ हैं, इसलिये हम इन्हें इस देश में रहने देंगे, इनके साथ व्यापार करेंगे, क्योंकि हमारा देश इनके लिए पर्याप्‍त है. हम इनकी कन्याएं लें तथा अपनी कन्याएं इन्हें दे. ");
INSERT INTO hincv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ये एक ही शर्त पर हमारे साथ रहने के लिए सहमत हुए हैं, कि हम सभी पुरुषों का ख़तना किया जाए, जैसा उनका किया जाता है कि हम सभी एक हो जाएं. ");
INSERT INTO hincv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","तब इनका पशु धन, इनकी संपत्ति तथा इनके समस्त पशु हमारे ही तो हो जाएंगे न? बस, हम उनसे यहां सहमत हो जाएं, कि वे हमारे साथ ही निवास करने लगें.” ");
INSERT INTO hincv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","उन सभी ने, जो नगर से निकल रहे थे, हामोर तथा उसके पुत्र शेकेम की बात मान ली. उस नगर द्वार से बाहर निकलते हुए हर एक पुरुष का ख़तना कर दिया गया. ");
INSERT INTO hincv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","तीन दिन बाद, जब नगर का हर एक पुरुष पीड़ा में था, याकोब के दोनों बेटे शिमओन और लेवी ने, जो दीनाह के भाई थे, अचानक हमला कर दिया तथा हर एक पुरुष की हत्या कर दी. ");
INSERT INTO hincv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","उन्होंने तलवार से हामोर तथा उसके पुत्र शेकेम की हत्या की और शेकेम के घर से दीनाह को लेकर आये. ");
INSERT INTO hincv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","और याकोब के अन्य पुत्रों ने नगर को लूट लिया, क्योंकि उन्होंने उनकी बहन को दूषित कर दिया था. ");
INSERT INTO hincv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","उन्होंने नगर के लोग भेड़-बकरी, उनके पशु, गधे, नगर में जो कुछ उनका था जो कुछ खेतों में था, सभी कुछ ले लिया. ");
INSERT INTO hincv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","उन्होंने उनकी पूरी संपत्ति पर अधिकार करके उसे लूट लिया, यहां तक कि उन्होंने उनकी पत्नियों एवं उनके बालकों को बंदी बनाकर सभी कुछ, जो उनके घरों में था, लूट लिया. ");
INSERT INTO hincv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","यह सब देख याकोब ने शिमओन तथा लेवी से कहा, “तुमने तो मुझे इन देशवासियों के लिए दुश्मन बनाकर कनानियों एवं परिज्ज़ियों के बीच विपत्ति में डाल दिया है. यदि वे सब एकजुट होकर मुझ पर आक्रमण कर देंगे, तो मैं नष्ट हो जाऊंगा, मैं और मेरा संपूर्ण परिवार, क्योंकि हम गिनती में कम हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","उन्होंने कहा, “क्या हमारी बहन से उन्होंने जो एक वेश्या के समान बर्ताव किया; क्या वह सही था?” ");
INSERT INTO hincv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","परमेश्वर ने याकोब से कहा, “उठो और जाकर बेथेल में बस जाओ. वहां परमेश्वर के लिए एक वेदी बनाओ, जिसने तुझे उस समय दर्शन दिया जब तू अपने भाई एसाव के डर से भाग रहा था.” ");
INSERT INTO hincv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","इसलिये याकोब ने अपने पूरे घर-परिवार तथा उन सभी व्यक्तियों को, जो उनके साथ थे, कहा, “इस समय तुम्हारे पास जो पराए देवता हैं, उन्हें दूर कर दो और अपने आपको शुद्ध कर अपने वस्त्र बदल दो. ");
INSERT INTO hincv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","उठो, हम बेथेल को चलें ताकि वहां मैं परमेश्वर के लिए एक वेदी बनाऊं, जिन्होंने संकट की स्थिति में मेरी दोहाई सुनी तथा जहां-जहां मैं गया जिनकी उपस्थिति मेरे साथ साथ रही.” ");
INSERT INTO hincv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","यह सुन उन्होंने याकोब को सब पराए देवता दे दिए, जो उन्होंने अपने पास रखे थे. इसके अलावा कानों के कुण्डल भी दिये. याकोब ने इन सभी को उस बांज वृक्ष के नीचे दफना दिया, जो शेकेम के पास था. ");
INSERT INTO hincv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","जब वे वहां से निकले तब पूरे नगर पर परमेश्वर का भय छाया हुआ था. किसी ने भी याकोब के पुत्रों का पीछा नहीं किया. ");
INSERT INTO hincv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","इस प्रकार याकोब तथा उनके साथ के सभी लोग कनान देश के लूज़ (अर्थात् बेथेल) नगर पहुंच गए. ");
INSERT INTO hincv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","याकोब ने वहां एक वेदी बनाई और उस स्थान का नाम एल-बेथेल रखा, क्योंकि इसी स्थान पर परमेश्वर ने स्वयं को उन पर प्रकट किया था, जब वह अपने भाई से बचकर भाग रहे थे. ");
INSERT INTO hincv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","उसी समय रेबेकाह की धाय दबोरा की मृत्यु हो गई, उसे बेथेल के बाहर बांज वृक्ष के नीचे दफ़ना दिया. उस वृक्ष का नाम अल्लोन-बाकूथ रखा गया (अर्थात् रोने का बांज वृक्ष). ");
INSERT INTO hincv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","जब याकोब पद्दन-अराम से आए, परमेश्वर दुबारा याकोब पर प्रकट हुए. परमेश्वर ने उनको आशीष दी. ");
INSERT INTO hincv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","और कहा, “तुम्हारा नाम याकोब है, अब से तुम्हारा नाम इस्राएल होगा.” इस प्रकार परमेश्वर ने उन्हें इस्राएल नाम दे दिया. ");
INSERT INTO hincv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","परमेश्वर ने उनसे यह भी कहा, “मैं एल शद्दय अर्थात् सर्वशक्तिमान परमेश्वर हूं; तुम फूलो फलो और बढ़ते जाओ. तुम एक राष्ट्र तथा एक जनता का समूह भी होंगे, तुम्हारे वंश में राजा पैदा होंगे. ");
INSERT INTO hincv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","जो देश मैंने अब्राहाम तथा यित्सहाक को दिया था, वह मैं तुम्हें भी दूंगा, तथा यही देश तुम्हारे बाद तुम्हारे वंश को दूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","इसके बाद परमेश्वर उस स्थान से ऊपर चढ़ गए, जिस स्थान पर उन्होंने याकोब से बातचीत की थी. ");
INSERT INTO hincv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","याकोब ने उस स्थान पर, जहां परमेश्वर से उनकी बात हुई थी, वहां खंभा खड़ा किया—यह एक पत्थर था. याकोब ने इस पर पेय बलि चढ़ाई तथा उस पर तेल भी उंडेला. ");
INSERT INTO hincv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","जिस स्थान पर परमेश्वर ने उनसे बात की थी, उस स्थान का नाम उन्होंने बेथेल रखा. ");
INSERT INTO hincv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","फिर वे बेथेल से चलना शुरू करके एफ़राथा नामक जगह के पास थे, कि राहेल की तबियत खराब हो गई. ");
INSERT INTO hincv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","जब वह इस प्रसव पीड़ा में ही थी, धाय ने कहा, “डरो मत, अब तो तुम एक और पुत्र को जन्म दे चुकी हो.” ");
INSERT INTO hincv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","जब उसके प्राण निकल ही रहे थे, उसने इस पुत्र का नाम बेन-ओनी रखा. किंतु उसके पिता ने उसे बिन्यामिन कहकर पुकारा. ");
INSERT INTO hincv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","और वहां इस प्रकार राहेल की मृत्यु हुई तथा उसे एफ़राथा (अर्थात् बेथलेहेम) में दफ़ना दिया. ");
INSERT INTO hincv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","याकोब ने उसकी कब्र पर एक स्तंभ खड़ा किया, राहेल की कब्र का यह स्तंभ आज तक वहां स्थित है. ");
INSERT INTO hincv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","फिर इस्राएल ने अपनी यात्रा शुरू की और उन्होंने ऐदेर के स्तंभ से आगे बढ़कर तंबू डाला. ");
INSERT INTO hincv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","जब इस्राएल उस देश में रह रहे थे, तब रियूबेन ने अपने पिता की रखेल बिलहाह से संभोग किया, जो इस्राएल से छिपा न रहा. याकोब के पुत्र संख्या में बारह थे. ");
INSERT INTO hincv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","इनमें लियाह के पुत्र: याकोब का बड़ा बेटा रियूबेन, फिर शिमओन, लेवी, यहूदाह, इस्साखार तथा ज़ेबुलून थे. ");
INSERT INTO hincv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","राहेल के पुत्र: योसेफ़ तथा बिन्यामिन. ");
INSERT INTO hincv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","राहेल की दासी बिलहाह के पुत्र: दान तथा नफताली. ");
INSERT INTO hincv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","लियाह की दासी ज़िलपाह के पुत्र: गाद तथा आशेर. पद्दन-अराम में ही याकोब के ये पुत्र पैदा हुए थे. ");
INSERT INTO hincv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","याकोब अपने पिता यित्सहाक के पास पहुंच गए, जो किरयथ-अरबा (अर्थात् हेब्रोन) के ममरे में रहते थे. अब्राहाम तथा यित्सहाक यहीं रहते थे. ");
INSERT INTO hincv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","यित्सहाक की आयु एक सौ अस्सी वर्ष की हुई. ");
INSERT INTO hincv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","तब उनकी मृत्यु हुई. उनके पुत्र एसाव तथा याकोब ने उन्हें वहीं दफनाया जहां उनके पिता को दफनाया गया था. ");
INSERT INTO hincv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसाव (अर्थात् एदोम) के वंशज इस प्रकार है: ");
INSERT INTO hincv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसाव ने कनान देश की ही कन्याओं से विवाह कर लिया. हित्ती एलोन की पुत्री अदाह, अनाह की पुत्री तथा हिव्वी ज़िबेओन की पौत्री ओहोलिबामाह थे. ");
INSERT INTO hincv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","इसके अलावा उन्होंने इशमाएल की पुत्री नेबाइयोथ की बहन बसेमाथ से भी विवाह किया था. ");
INSERT INTO hincv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","एसाव से अदाह ने एलिफाज़ को जन्म दिया तथा बसेमाथ ने रियुएल को जन्म दिया, ");
INSERT INTO hincv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ओहोलिबामाह ने योउश, यालम तथा कोराह को जन्म दिया. कनान देश में ही एसाव के ये पुत्र पैदा हुए. ");
INSERT INTO hincv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","इसके बाद एसाव अपनी पत्नियों, पुत्र-पुत्रियों, अपने संपूर्ण घर-परिवार, अपने पशु, तथा अपनी समस्त संपत्ति को लेकर, जो उसने कनान देश में पाई थी, अपने भाई याकोब से दूर देश में जाकर रहा. ");
INSERT INTO hincv_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","उन दोनों की संपत्ति इतनी अधिक थी कि दोनों का एक साथ रहना मुश्किल था; वह भूमि दोनों परिवारों के पोषण के लिए काफ़ी नहीं थी. उनके पास अत्यधिक पशु थे. ");
INSERT INTO hincv_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","इसलिये एसाव (अर्थात् एदोम) सेईर के पर्वतीय क्षेत्र में रहने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","सेईर के पर्वतीय क्षेत्र में बसे हुए एदोमियों के वंश एसाव की पीढ़ियां इस प्रकार हैं. ");
INSERT INTO hincv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसाव के पुत्र थे: एसाव की पत्नी अदाह से जन्मे एलिफाज़, एसाव दूसरी की पत्नी बसेमाथ का पुत्र रियुएल. ");
INSERT INTO hincv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","एलिफाज़ के पुत्र: तेमान, ओमर, ज़ेफो, गाताम तथा केनाज़ थे. ");
INSERT INTO hincv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एसाव के पुत्र एलिफाज़ की दासी का नाम तिम्ना था, जिसने एलिफाज़ से अमालेक को जन्म दिया. ये एसाव की पत्नी अदाह की संतान हैं. ");
INSERT INTO hincv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रियुएल के पुत्र थे: नाहाथ, ज़ेराह, शम्माह तथा मिज्जाह. ये एसाव की पत्नी बसेमाथ द्वारा पैदा हुए थे. ");
INSERT INTO hincv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","अनाह की पुत्री, ज़िबेओन की पौत्री, एसाव की पत्नी ओहोलिबामाह के पुत्र योउश, यालम तथा कोराह थे. ");
INSERT INTO hincv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसाव के पुत्रों में प्रमुख ये थे: एसाव के बड़े बेटे एलिफाज़ के पुत्र: तेमान, ओमर, ज़ेफो, केनाज़, ");
INSERT INTO hincv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोराह, गाताम, अमालेक. एदोम देश में एलिफाज़ के ये पुत्र थे; ये सभी अदाह वंश के थे. ");
INSERT INTO hincv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसाव के पुत्र रियुएल के पुत्र: नाहाथ, ज़ेराह, शम्माह, मिज्जाह. ये वे प्रधान हैं, जो एदोम देश में रियुएल द्वारा जन्मे थे—ये वे हैं, जो एसाव की पत्नी बसेमाथ से पैदा हुए थे. ");
INSERT INTO hincv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसाव की पत्नी ओहोलिबामाह से पुत्र हैं: योउश, यालम, कोराह. ये एसाव की पत्नी अनाह की पुत्री ओहोलिबामाह के द्वारा जन्मे हैं. ");
INSERT INTO hincv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ये एसाव (अर्थात् एदोम) के पुत्र तथा उनके प्रधान हैं. ");
INSERT INTO hincv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ये उस देश के होरी सेईर के पुत्र हैं: लोतन, शोबल, ज़िबेओन, अनाह, ");
INSERT INTO hincv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दिशोन, एज़र तथा दिशान. ये सभी एदोम देश के वे प्रधान हैं. जो होरियों के वंश के सेईर के पुत्र हैं. ");
INSERT INTO hincv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतन के पुत्र: होरी तथा होमाम, तथा तिम्ना लोतन की बहन थी. ");
INSERT INTO hincv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबल के पुत्र थे: अलवान, मानाहाथ, एबल, शेफो तथा ओनम. ");
INSERT INTO hincv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ज़िबेओन के पुत्र ये है: अइयाह तथा अनाह (यह वही अनाह है, जिसने निर्जन देश में, अपने पिता ज़िबेओन के गधों को चराते हुए गर्म पानी के झरने की खोज की थी.) ");
INSERT INTO hincv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अनाह की संतान हैं: दिशोन तथा ओहोलिबामाह, जो अनाह की पुत्री थी. ");
INSERT INTO hincv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दिशोन के पुत्र: हेमदान, एशबान, इथरान तथा चेरन. ");
INSERT INTO hincv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एज़र के पुत्र: बिलहान, त्सावन और आकन. ");
INSERT INTO hincv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दिशान के पुत्र: उज़ और अरान. ");
INSERT INTO hincv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","वे प्रधान, जो होरियों वंश के, ये है: लोतन, शोबल, ज़िबेओन, अनाह, ");
INSERT INTO hincv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दिशोन, एज़र तथा दिशान. सेईर देश में होरी जाति के लोग प्रधान बने. ");
INSERT INTO hincv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","इसके पहले कि इस्राएल पर किसी राजा का शासन होता, एदोम देश पर राज्य करनेवाले राजा ये थे: ");
INSERT INTO hincv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बेओर का पुत्र बेला एदोम का राजा बना, तथा उसके द्वारा शासित नगर का नाम था दिनहाबाह. ");
INSERT INTO hincv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बेला के मरने के बाद, उसके स्थान पर बोज़राहवासी ज़ेराह का पुत्र योबाब राजा बना. ");
INSERT INTO hincv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","योबाब के मरने के बाद, उसके स्थान पर तेमानियों के देश का व्यक्ति हुशम राजा बना. ");
INSERT INTO hincv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","हुशम के मरने के बाद, उसके स्थान पर बेदद का पुत्र हदद राजा बना. उसने मोआब देश में मिदियानी सेना को हरा दिया. उसके द्वारा शासित नगर का नाम था आविथ. ");
INSERT INTO hincv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","हदद के मरने के बाद, उसके स्थान पर मसरेकाह का सामलाह राजा बना. ");
INSERT INTO hincv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","सामलाह के मरने के बाद, फरात नदी पर बसे रेहोबोथ का निवासी शाऊल उनके स्थान पर राजा बना. ");
INSERT INTO hincv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","शाऊल के मरने के बाद, उसके स्थान पर अखबोर का पुत्र बाल-हनन राजा बना. ");
INSERT INTO hincv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","अखबोर के पुत्र बाल-हनन के मरने के बाद, उसके स्थान पर हदद राजा बना. उस नगर का नाम पाऊ था तथा उसकी पत्नी का नाम मेहेताबेल था. वह मातरेद की पुत्री, और मातरेद मेत्साहब की पुत्री थी. ");
INSERT INTO hincv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","एसाव के वंश में जो प्रधान थे उनके नाम: तिम्ना, अलवाह, यथेथ, ");
INSERT INTO hincv_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ओहोलिबामाह, एलाह, पिनोन, ");
INSERT INTO hincv_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","केनाज़, तेमान, मिबज़ार, ");
INSERT INTO hincv_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","मगदिएल, इराम. ये सभी एदोम देश के प्रधान हुए. एक प्रदेश में जो रहा, उस प्रदेश का नाम भी वही था जो उनका पारिवारिक नाम था. यह एसाव, जो एदोमियों का गोत्रपिता था, उसका परिवार है. ");
INSERT INTO hincv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकोब कनान देश में रहते थे. वहीं तो उनके पिता परदेशी होकर रहे थे. ");
INSERT INTO hincv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","यह है याकोब के परिवार का इतिहास. याकोब के वंश में योसेफ़ जब सत्रह वर्ष के थे वह अपने भाइयों के साथ भेड़-बकरियों को चराते थे, उनके पिता की पत्नियों बिलहाह तथा ज़िलपाह के पुत्र भी उनके साथ ही थे. योसेफ़ अपने पिता को अपने भाइयों की गलत आदतों के बारे में बताया करते थे. ");
INSERT INTO hincv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","इस्राएल अपने सभी बच्चों से ज्यादा योसेफ़ को प्यार करते थे; क्योंकि वह उनके बुढ़ापे की संतान थी. याकोब ने योसेफ़ के लिए रंग बिरंगा वस्त्र बनवाया था. ");
INSERT INTO hincv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","योसेफ़ के भाइयों ने देखा कि उनके पिता उनसे ज्यादा योसेफ़ को प्यार करते हैं; इसलिये वे योसेफ़ से नफ़रत करने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","योसेफ़ ने एक स्वप्न देखा था, जिसे उसने अपने भाइयों को बताया. योसेफ़ के भाई योसेफ़ से ज्यादा नफ़रत करने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","योसेफ़ ने अपने भाइयों से कहा, “कृपया मेरा स्वप्न सुनिए. ");
INSERT INTO hincv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","हम सब खेत में पूला बांध रहे थे. मैंने देखा कि मेरा पूला उठकर सीधा खड़ा हो गया. और आपके पूले मेरे पूले के आस-पास एकत्र हो गये और मेरे पूले को प्रणाम करने लगे.” ");
INSERT INTO hincv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","यह सुन उनके भाई कह उठे, “तो क्या तुम हम पर अधिकार करने का विचार कर रहे हो? क्या तुम सच में हम पर अधिकार कर लोगे?” इसके बाद वे योसेफ़ से और ज्यादा नफ़रत करने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","फिर योसेफ़ ने दूसरा सपना देखा. योसेफ़ ने कहा, “मैंने दूसरा सपना देखा है; मैंने सूरज, चांद और ग्यारह नक्षत्रों को मुझे प्रणाम करते देखा.” ");
INSERT INTO hincv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","यह स्वप्न योसेफ़ ने अपने पिता एवं भाइयों को बताया, जिसे सुन उनके पिता ने उसे डांटते हुए कहा, “यह कैसा स्वप्न देखते हो तुम! क्या यह वास्तव में संभव है कि मैं, तुम्हारी माता एवं तुम्हारे भाई तुम्हारे पास आएंगे और तुम्हें प्रणाम करेंगे?” ");
INSERT INTO hincv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","योसेफ़ के भाई उससे लगातार ईर्ष्या करते रहे. किंतु योसेफ़ के पिता ने इन सभी बातों को अपने मन में रखा. ");
INSERT INTO hincv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","योसेफ़ के भाई अपने पिता की भेड़-बकरियों को चराने के लिए शेकेम गए थे. ");
INSERT INTO hincv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","इस्राएल ने योसेफ़ से कहा, “तुम्हारे भाई शेकेम में भेड़-बकरी चरा रहे हैं न? मैं तुम्हें उनके पास भेजना चाहता हूं.” योसेफ़ ने कहा, “मैं चला जाता हूं.” ");
INSERT INTO hincv_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","याकोब ने योसेफ़ से कहा, “तुम जाओ और अपने भाइयों का हाल पता करके आओ और मुझे बताओ.” योसेफ़ को याकोब ने हेब्रोन घाटी से रवाना किया. और योसेफ़ शेकेम पहुंचे, ");
INSERT INTO hincv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","जब योसेफ़ एक मैदान में इधर-उधर देख रहे थे, तब एक व्यक्ति उन्हें मिला, जिसने उससे पूछा, “क्या ढूंढ़ रहे हो तुम?” ");
INSERT INTO hincv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","योसेफ़ ने कहा, “मैं अपने भाइयों को ढूंढ़ रहा हूं. क्या आप कृपा कर मुझे बताएंगे वे अपनी भेड़-बकरियां कहां चरा रहे हैं?” ");
INSERT INTO hincv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","उस व्यक्ति ने कहा, “वे तो यहां से जा चुके हैं, क्योंकि मैंने उन्हें यह कहते सुना था, ‘चलो, अब दोथान जायें.’ ” इसलिये योसेफ़ अपने भाइयों को ढूंढ़ते दोथान पहुंचे. ");
INSERT INTO hincv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","जब भाइयों ने दूर से योसेफ़ को आते देखा, उसके नज़दीक आने के पहले ही उन्होंने उसको मार डालने का विचार किया. ");
INSERT INTO hincv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","उन्होंने कहा, “यह लो, आ गया स्वप्न देखनेवाला! ");
INSERT INTO hincv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","चलो, उसकी हत्या कर यहां किसी गड्ढे में फेंक दें, और हम कह देंगे, कि उसे किसी जंगली जानवर ने खा लिया; फिर हम देखते हैं उसके स्वप्न का क्या होता है.” ");
INSERT INTO hincv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","किंतु रियूबेन योसेफ़ को बचाना चाहता था. इसलिये रियूबेन ने कहा “हम योसेफ़ को जान से नहीं मारेंगे; ");
INSERT INTO hincv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","बल्कि हम उसे बंजर भूमि के किसी गड्ढे में डाल देते हैं,” रियूबेन ने ऐसा इसलिये कहा कि वह योसेफ़ को बचाकर पिता को सौंप देना चाहता था. ");
INSERT INTO hincv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","जैसे ही योसेफ़ अपने भाइयों के पास आये, उन्होंने योसेफ़ का रंग बिरंगा वस्त्र, जो वह पहने हुए थे उतार दिया, ");
INSERT INTO hincv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","और योसेफ़ को एक सूखे गड्ढे में डाल दिया, गड्ढा खाली था; उसमें पानी नहीं था. ");
INSERT INTO hincv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","यह करके वे भोजन करने बैठे. तभी उन्होंने देखा कि गिलआद की ओर से इशमाएलियों का एक समूह आ रहा था. उनके ऊंटों पर सुगंध गोंद, बलसान तथा गन्धरस लदे हुए थे. यह सब वे मिस्र ले जा रहे थे. ");
INSERT INTO hincv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","यहूदाह ने अपने भाइयों से कहा, “अपने भाई की हत्या कर उसे छुपाने से हमें कुछ नहीं मिलेगा. ");
INSERT INTO hincv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","हम इसे इन इशमाएलियों को बेच दें. हम इसकी हत्या न करें; अंततः वह हमारा भाई ही है, हमारा अपना खून.” भाइयों को यह बात ठीक लगी. ");
INSERT INTO hincv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","उसी समय कुछ मिदियानी व्यापारी वहां से निकले, तब उन्होंने उनकी सहायता से योसेफ़ को गड्ढे से ऊपर खींच निकाला और उसे इशमाएलियों को बीस चांदी के सिक्कों में बेच दिया. ");
INSERT INTO hincv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","जब रियूबेन उस गड्ढे पर लौटा, तब उसने देखा कि योसेफ़ वहां नहीं हैं. यह देख उसने अपने वस्त्र फाड़ लिए. ");
INSERT INTO hincv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","उसने अपने भाइयों के पास जाकर पूछा, “वह तो वहां नहीं हैं! मुझे समझ नहीं आ रहा, अब मैं क्या करूं?” ");
INSERT INTO hincv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","भाइयों ने एक बकरी को मारा और उसके खून में योसेफ़ के सुंदर अंगरखे को डुबो दिया ");
INSERT INTO hincv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","और उस वस्त्र को अपने पिता के पास ले जाकर कहा, “हमें यह वस्त्र मिला; क्या यह आपके पुत्र का वस्त्र तो नहीं?” ");
INSERT INTO hincv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","याकोब ने वस्त्र देखकर कहा, “यह मेरे पुत्र का ही वस्त्र है. किसी जंगली पशु ने उसे खा लिया है.” ");
INSERT INTO hincv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","तब याकोब ने अपने वस्त्र फाड़े, टाट पहन लिए और कई दिनों तक अपने बेटे के लिए रोते रहे. ");
INSERT INTO hincv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","सबने याकोब को दिलासा देने की कोशिश की, पर याकोब का दुःख कम न हुआ, और वे योसेफ़ के लिए रोते ही रहे. याकोब ने कहा, “मैं मरने के दिन तक (शीयोल तक) अपने पुत्र योसेफ़ के शोक में डूबा रहूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","वहां, मिदियानियों ने मिस्र पहुंचकर योसेफ़ को पोतिफर को बेच दिया, जो फ़रोह का एक अधिकारी, अंगरक्षकों का प्रधान था. ");
INSERT INTO hincv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","जब उन्हीं दिनों यहूदाह अपने भाइयों के बीच से निकलकर हीराह नामक अदुल्लामवासी व्यक्ति के साथ रहने चले गये. ");
INSERT INTO hincv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","तब शुआ नामक एक कनानी व्यक्ति की पुत्री से मिले और उन्होंने उससे विवाह कर लिया और उससे प्रेम किया; ");
INSERT INTO hincv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","और उसने एक पुत्र को जन्म दिया, जिसका एर नाम रखा. ");
INSERT INTO hincv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","उसने एक और पुत्र को जन्म दिया और उसका नाम ओनान रखा. ");
INSERT INTO hincv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","उसने एक और पुत्र को जन्म दिया, जिसका शेलाह नाम रखा. तब यहूदाह केज़ीब में रहते थे. ");
INSERT INTO hincv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","यहूदाह ने एर, का विवाह तामार नामक स्त्री से किया. ");
INSERT INTO hincv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","यहूदाह का बड़ा बेटा याहवेह के दृष्टि में दुष्ट था; इसलिये याहवेह ने उसे मार डाला. ");
INSERT INTO hincv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","यहूदाह ने ओनान से कहा, “अपने भाई की पत्नी के साथ देवर का कर्तव्य पूरा करके अपने भाई के लिए संतान पैदा करो.” ");
INSERT INTO hincv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ओनान ने कहा, ये संतान मेरी नहीं होगी; इसलिये जब कभी वह समागम करता, अपना वीर्य भूमि पर गिरा देता था कि उससे उसके भाई के लिए कोई संतान पैदा न हो सके. ");
INSERT INTO hincv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","उसका यह काम याहवेह को अच्छा नहीं लगा, इसलिये याहवेह ने उसके प्राण ले लिए. ");
INSERT INTO hincv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","यह देख यहूदाह ने अपनी बहू तामार से कहा, “जब तक मेरा पुत्र शेलाह, विवाह के योग्य न हो जाए, अपने पिता के घर विधवा बनकर रहना.” यहूदाह को डर था कि इस पुत्र की भी मृत्यु उसके भाइयों के समान हो जाए. इसलिये तामार अपने पिता के घर चली गई. ");
INSERT INTO hincv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","बहुत समय बाद शुआ की पुत्री अर्थात् यहूदाह की पत्नी की मृत्यु हो गई. यहूदाह अपने शोक के समय के बाद अपनी भेड़ों के ऊन कतरने वालों के पास तिमनाह को गया. उसके साथ उसका मित्र अदुल्लामी हीराह भी था. ");
INSERT INTO hincv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","जब तामार को यह बताया गया, “तुम्हारे ससुर तिमनाह जा रहे हैं,” ");
INSERT INTO hincv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","तब तामार ने अपने विधवा के वस्त्र उतार दिए, और अपना मुंह घूंघट से छिपाकर एक चादर लपेट ली तथा तिमनाह के मार्ग पर एनाइम के प्रवेश द्वार पर बैठ गई. यह इसलिये किया क्योंकि उसका देवर शेलाह जवान हो चुका था तथा उससे उसका विवाह नहीं किया गया था. ");
INSERT INTO hincv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","वहां से निकलते हुए उसे देख यहूदाह ने उसे वेश्या समझा, क्योंकि उसने मुंह ढक रखा था. ");
INSERT INTO hincv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","इसलिये यहूदाह उसके पास गया और उससे कहा, “मुझे तुम्हारे साथ संभोग करना है.” यहूदाह को यह मालूम नहीं था कि वह उसकी ही बहू थी. उसने पूछा, “क्या मजदूरी दोगे?” ");
INSERT INTO hincv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","यहूदाह ने उत्तर दिया, “मैं तुम्हें अपने झुंड में से एक बकरी भिजवा दूंगा.” तब तामार ने कहा, “उसे भिजवाने तक उसके बदले में क्या दोगे?” ");
INSERT INTO hincv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","यहूदाह ने पूछा, “क्या चाहती हो?” उसने उत्तर दिया, “तुम्हारी मुद्रामोहर, तुम्हारा बाजूबन्द तथा तुम्हारे हाथ की लाठी.” तब यहूदाह ने उसे ये देकर उससे संभोग किया और चला गया. तामार यहूदाह से गर्भवती हो गई. ");
INSERT INTO hincv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","तामार ने घर जाकर अपना विधवा वस्त्र वापस पहन लिया. ");
INSERT INTO hincv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","जब यहूदाह ने अपने अदुल्लामी मित्र के हाथ वह शावक बकरी उस स्त्री के लिए भेजी, तो वहां उसे वह स्त्री नहीं मिली. ");
INSERT INTO hincv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","उसने आस-पास लोगों से पूछा, “वह वेश्या कहां है, जो एनाइम मार्ग पर बैठा करती है?” उन्होंने कहा, “यहां कोई वेश्या कभी थी ही नहीं.” ");
INSERT INTO hincv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","इसलिये वह यहूदाह के पास लौट गया और उसे बताया, “वह मुझे नहीं मिली. इतना ही नहीं, वहां लोगों ने बताया कि वहां तो कभी कोई वेश्या थी ही नहीं.” ");
INSERT INTO hincv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","यह सुन यहूदाह ने उससे कहा, “तब तो उसे वे चीज़ें रख लेने दो अन्यथा तुच्छ हम ही बन जाएंगे. मैंने तो उसके लिए बकरी भिजवा दी थी, किंतु हम उसका पता नहीं लगा सके.” ");
INSERT INTO hincv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","लगभग तीन माह बाद यहूदाह को बताया गया, “तुम्हारी बहू ने व्यभिचार किया है और वह गर्भवती है.” यहूदाह ने कहा, “उसे बाहर लाओ ताकि उसे जला दें!” ");
INSERT INTO hincv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","जब उसे बाहर ला रहे थे, तो उसने अपने ससुर को यह संदेश भेजा, “मैं उस व्यक्ति से गर्भवती हूं जिसकी ये वस्तुएं हैं.” तामार ने कहा, “देखो, कि यह मुद्रामोहर, बाजूबन्द तथा लाठी किसकी है?” ");
INSERT INTO hincv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदाह ने ये वस्तुएं देखते ही पहचान लीं और कहा, “वह तो मुझसे कम दोषी है, क्योंकि मैंने ही उसे शेलाह की पत्नी होने से रोका था.” यहूदाह ने उससे पुनः संभोग नहीं किया. ");
INSERT INTO hincv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","जब प्रसव का समय आया तब पता चला कि उसके गर्भ में जुड़वां बच्‍चे हैं. ");
INSERT INTO hincv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","जब प्रसव पीड़ा हो रही थी एक ने हाथ बाहर निकाला तो धाय ने उसके हाथ में यह कहते हुए लाल डोरी बांध दी, “कि यह पहले जन्मा है.” ");
INSERT INTO hincv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","लेकिन उसने अपना हाथ अंदर खींच लिया और उसके भाई का जन्म उससे पहले हुआ. तब धाय ने कहा, “तुम ही पहले बाहर निकलने में समर्थ हुए!” इसलिये उसका नाम पेरेज़ रखा. ");
INSERT INTO hincv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","फिर उसके भाई का जन्म हुआ, जिसके हाथ पर वह लाल डोर बांधी गई थी. उसका नाम ज़ेराह रखा. ");
INSERT INTO hincv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","जब योसेफ़ को मिस्र ले गये, तब फ़रोह के अंगरक्षकों के प्रधान मिस्री पोतिफर ने उसे उन इशमाएलियों से मोल ले लिया जो उसे वहां लाए थे. ");
INSERT INTO hincv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","योसेफ़ पर याहवेह की कृपा थी, इसलिये वह सफल व्यक्ति बन गये. वह मिस्री स्वामी के घर में रहते थे. ");
INSERT INTO hincv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","योसेफ़ के स्वामी ने यह समझ लिया था कि योसेफ़ पर याहवेह की कृपा है, वह जो भी काम करते हैं, याहवेह उस काम को सफल कर देते थे. ");
INSERT INTO hincv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","इस कारण योसेफ़ उनके कृपापात्र बन उनकी सेवा में लग गये. पोतिफर ने उन्हें अब अपने पूरे घर का तथा संपत्ति का अधिकारी बना दिया था. ");
INSERT INTO hincv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","और जब से योसेफ़ को संपत्ति का अधिकारी बनाया याहवेह ने योसेफ़ के कारण उस मिस्री घर को बहुत आशीष दी. याहवेह की आशीष पोतिफर के घर में और उसके खेतों में थी. ");
INSERT INTO hincv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","इसलिये पोतिफर ने अपनी पूरी संपत्ति योसेफ़ को सौंप दी. पोतिफर अपने भोजन के अलावा किसी भी चीज़ पर ध्यान नहीं देता था. योसेफ़ सुंदर व रूपवान युवक थे, ");
INSERT INTO hincv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","और कुछ समय बाद पोतिफर की पत्नी योसेफ़ के प्रति गलत सोच रखने लगी और उससे कहा, “मुझसे समागम करो!” ");
INSERT INTO hincv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","किंतु योसेफ़ ने मना किया और अपनी स्वामिनी से कहा, “यह समझने की कोशिश कीजिए कि इस घर में मेरे स्वामी किसी भी विषय की चिंता नहीं करते, उन्होंने तो अपनी पूरी संपत्ति ही मेरे पास छोड़ दी है. ");
INSERT INTO hincv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","इस घर में कोई भी मुझसे बड़ा नहीं है. मेरे स्वामी ने मुझे आपके अलावा किसी भी वस्तु से अलग नहीं रखा है, क्योंकि आप उनकी पत्नी हैं. इसलिये यह कैसे संभव है कि मैं ऐसी दुष्टता कर परमेश्वर के विरुद्ध पाप करूं?” ");
INSERT INTO hincv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","वह दिन-प्रतिदिन योसेफ़ से समागम के लिए आग्रह करती रही, योसेफ़ न तो समागम के लिए तत्पर हुए और न ही उसके पास रहने के लिए तैयार हुए. ");
INSERT INTO hincv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","एक दिन जब घर में कोई भी सेवक नहीं था और योसेफ़ घर में अपने काम करने गये. ");
INSERT INTO hincv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","पोतिफर की पत्नी ने योसेफ़ के वस्त्र पकड़ लिए और उनसे आग्रह करने लगी, “मुझसे संभोग करो!” योसेफ़ अपना वस्त्र उसी के हाथ में छोड़कर भागकर बाहर आ गये. ");
INSERT INTO hincv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","जब उस स्त्री ने देखा कि योसेफ़ अपना वस्त्र उसके हाथों में छोड़कर बाहर भाग गए, ");
INSERT INTO hincv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","उसने सब सेवकों को बुलाया और कहा, “यह देखो, मेरे पति ने इस इब्री को हमारी देखभाल के लिए रखा है लेकिन वह मुझे दूषित करने मेरे पास आया तब मैं चिल्ला पड़ी. ");
INSERT INTO hincv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","जैसे ही उसने मेरी चिल्लाहट सुनी, वह अपना वस्त्र मेरे साथ छोड़कर बाहर भाग गया.” ");
INSERT INTO hincv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","योसेफ़ का वह वस्त्र अपने पति के लौटने तक अपने पास रखा. ");
INSERT INTO hincv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","पति के आने पर उसने बताया: “आप जिस इब्री दास को यहां लाए हैं, वह मेरा अपमान करने यहां आया था. ");
INSERT INTO hincv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","जैसे ही मैं चिल्लाई, वह अपना वस्त्र छोड़कर बाहर भाग गया.” ");
INSERT INTO hincv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","जब योसेफ़ के स्वामी ने अपनी पत्नी की यह बात सुनी, ‘आपके सेवक ने मुझसे ऐसा व्यवहार किया’ तब उसे बहुत गुस्सा आया. ");
INSERT INTO hincv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","योसेफ़ के स्वामी ने उसे कारागार में डाल दिया, यह वही स्थान था जहां राजा के अपराधी रखे जाते थे. योसेफ़ इसी कारागार में थे, ");
INSERT INTO hincv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","किंतु योसेफ़ पर याहवेह की कृपा थी और इसलिये कारागार के अधिकारी योसेफ़ का पूरा ध्यान रखते थे. ");
INSERT INTO hincv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","कारागार के अधिकारी ने योसेफ़ को कारागार की पूरी जवाबदारी सौंप दी; कारागार में जो कुछ होता था योसेफ़ के कहने से ही होता था. ");
INSERT INTO hincv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","कारागार के अधिकारी जानते थे कि योसेफ़ पर याहवेह की कृपा है और योसेफ़ जो कुछ करते थे, याहवेह उस काम को सफल करते थे. ");
INSERT INTO hincv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","कुछ समय बाद राजा फ़रोह के कटोरा-वाहक और उनके खाना बनानेवाले ने अपने स्वामी फ़रोह के विरुद्ध कुछ गलती की. ");
INSERT INTO hincv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","और प्रधान खानसामे और प्रधान पिलाने वाले दोनों पर राजा गुस्सा हुए, ");
INSERT INTO hincv_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","इसलिये राजा ने उन दोनों को कारावास में डाल दिया, जहां योसेफ़ भी बंदी थे. ");
INSERT INTO hincv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","अंगरक्षकों के प्रधान ने योसेफ़ के हाथ उन दोनों को सौंप दिया. योसेफ़ उनका ध्यान रखते थे. और वे दोनों कुछ समय तक कारावास में रहे, ");
INSERT INTO hincv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","तब एक रात दोनों ने अलग-अलग सपना देखा, और हर एक सपने का अपना अलग-अलग अर्थ था. ");
INSERT INTO hincv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","जब सुबह योसेफ़ वहां आए और उन दोनों को देखा कि वे उदास थे. ");
INSERT INTO hincv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","योसेफ़ ने जो उसके साथ उसके स्वामी के घर में कारावास में थे, उनसे पूछा: “आप दोनो ऐसे उदास क्यों हैं?” ");
INSERT INTO hincv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","उन्होंने कहा, “हम दोनों ही ने स्वप्न देखा है, किंतु कोई भी नहीं है, जो उसका मतलब बता सके.” यह सुनकर योसेफ़ ने कहा, “क्या आप नहीं जानते कि स्वप्न की व्याख्या परमेश्वर की ओर से होती है? कृपया आप मुझे अपना स्वप्न बताएं.” ");
INSERT INTO hincv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","तब प्रधान पिलाने वाले ने योसेफ़ से कहा, “अपने स्वप्न में मैंने देखा कि मेरे पास एक दाखलता है, ");
INSERT INTO hincv_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","जिसमें तीन शाखाएं हैं. जैसे ही इन पर कलियां खिली, उनमें फूल खिलें और अंगूर लगकर पक गए. ");
INSERT INTO hincv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","और मैं फ़रोह का प्याला मेरे हाथ में था, और मैंने अंगूर लेकर प्याले में रस निचोड़ा. फिर मैंने प्याला फ़रोह के हाथों में दिया.” ");
INSERT INTO hincv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","स्वप्न सुनकर योसेफ़ ने कहा, “वे तीन शाखाएं तीन दिन हैं. ");
INSERT INTO hincv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","और तीन दिन में फ़रोह आपको वापस बुला लेंगे और आपका काम दुबारा आपको सौंप देंगे और आप फिर से पिलाने का काम शुरू करेंगे. ");
INSERT INTO hincv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","योसेफ़ ने उनसे कहा जब आप फ़रोह राजा के पास जायेंगे तब मुझे मत भूलना, लेकिन राजा को मेरे बारे में बताना और मुझे कारावास से बाहर निकलवाना. ");
INSERT INTO hincv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","मुझे अपने घर इब्रियों के देश से ज़बरदस्ती से लाया गया था और यहां पर भी मैंने ऐसा कोई अपराध नहीं किया है जिसके लिये मुझे इस काल-कोठरी में डाला गया.” ");
INSERT INTO hincv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","फिर प्रधान खाना बनानेवाले ने देखा कि दूसरे नौकर के स्वप्न की व्याख्या उनके पक्ष में थी, तब उसने योसेफ़ से कहा, “मैंने भी एक स्वप्न देखा है: मैंने देखा कि मेरे सिर पर सफ़ेद रोटी की तीन टोकरियां रखी हैं. ");
INSERT INTO hincv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","सबसे ऊपर की टोकरी में फ़रोह के लिए तैयार किए गए सभी प्रकार के व्यंजन थे, टोकरी सिर पर रखी हुई थी; पक्षी उसमें से खाते जा रहे थे.” ");
INSERT INTO hincv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","स्वप्न सुनकर योसेफ़ ने अर्थ बताया: “वे तीन टोकरियां तीन दिन हैं. ");
INSERT INTO hincv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","इन तीन दिनों में फ़रोह तुम्हारा सिर काट देंगे और शरीर को पेड़ पर लटका देंगे और पक्षी आकर तुम्हारे शरीर को नोचेंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","यही हुआ. तीसरे दिन फ़रोह का जन्मदिन था उसने अपने सभी सेवकों को भोज दिया उस दिन प्रधान पिलाने वाले और प्रधान पकाने वाले दोनों को कारावास से बाहर लाया गया. ");
INSERT INTO hincv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","प्रधान पिलाने वाले को फिर से उसकी जवाबदारी दे दी गई; वह फ़रोह के हाथ में फिर से प्याला देने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","लेकिन प्रधान पकाने वाले को फांसी पर लटका दिया; सब कुछ वैसा ही हुआ जैसा योसेफ़ ने बताया था. ");
INSERT INTO hincv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","यह सब देखकर भी प्रधान पिलाने वाले ने योसेफ़ को याद न किया; पर भूल गया. ");
INSERT INTO hincv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","पूरे दो साल बाद फ़रोह ने एक स्वप्न देखा: वे नील नदी के किनारे खड़े हैं. ");
INSERT INTO hincv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","नदी में से सात सुंदर एवं मोटी गायें निकली और घास चरने लगीं. ");
INSERT INTO hincv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","फिर और सात गायें नील नदी में से निकलीं, जो कुरूप तथा पतली थीं. ये नदी के किनारे उन मोटी गायों के पास आकर खड़ी हो गईं. ");
INSERT INTO hincv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","और कुरूप एवं दुर्बल गायों ने उन सुंदर एवं मोटी गायों को खा लिया. इससे फ़रोह की नींद खुल गई. ");
INSERT INTO hincv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","जब उन्हें फिर नींद आई, तब उन्होंने एक और स्वप्न देखा: एक ही तने में से सात बालें उगीं, जो अच्छी और मोटी मोटी थीं. ");
INSERT INTO hincv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","फिर सात और बालें उगीं जो पतली और मुरझाई हुई थीं, ");
INSERT INTO hincv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","तब पतली बालों ने मोटी बालों को निगल लिया. इससे फ़रोह की नींद खुल गई और वह समझ गये कि यह स्वप्न था. ");
INSERT INTO hincv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","सुबह होने पर राजा मन में बेचैन हुए, इसलिये इनका अर्थ जानने के लिए मिस्र देश के सब ज्योतिषियों एवं पंडितों को बुलवाया और फ़रोह ने उन्हें अपने दोनों स्वप्न बताये लेकिन कोई भी उनका अर्थ नहीं बता पाया. ");
INSERT INTO hincv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","तब प्रधान पिलाने वाले ने फ़रोह से कहा, “आज मुझे अपनी गलती याद आ रही है. ");
INSERT INTO hincv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","एक बार फ़रोह अपने नौकरों से क्रुद्ध हुए और मुझे और प्रधान खानसामे को अंगरक्षकों के नायक के घर के बंदीगृह में डाला. ");
INSERT INTO hincv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","हमने उस कारावास में स्वप्न देखा, और दोनों ही स्वप्न का अपना अलग अर्थ था. ");
INSERT INTO hincv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","एक इब्री युवक वहां था, वह अंगरक्षकों के नायक का सेवक था. जब हमने उसे अपना स्वप्न बताया उसने हमारे हर एक के स्वप्न की व्याख्या की. ");
INSERT INTO hincv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","जैसा उसने बताया था वैसा ही हुआ: फ़रोह ने मुझे तो अपना पद सौंप दिया, और खानसामें को प्राण-दंड दे दिया.” ");
INSERT INTO hincv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","यह सुनकर फ़रोह ने कहा कि योसेफ़ को मेरे पास लाओ. उन्होंने जल्दी योसेफ़ को कारागार से बाहर निकाला. और उसके बाल कटाकर उसके कपड़े बदलकर फ़रोह के पास लेकर आये. ");
INSERT INTO hincv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फ़रोह ने योसेफ़ से कहा, “मैंने एक स्वप्न देखा है, उसका अर्थ कोई नहीं बता पा रहे हैं, लेकिन मैंने तुम्हारे बारे में सुना है कि तुम स्वप्न का अर्थ बता सकते हो.” ");
INSERT INTO hincv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","योसेफ़ ने यह सुनकर फ़रोह से कहा, “अर्थ मैं नहीं, बल्कि स्वयं परमेश्वर ही देंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","तब फ़रोह ने कहा, “मैंने स्वप्न में देखा कि मैं नील नदी के किनारे खड़ा हूं. ");
INSERT INTO hincv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","वहां मैंने सात मोटी एवं सुंदर गायों को नील नदी से निकलते देखा. और वे घास चर रही थीं. ");
INSERT INTO hincv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","तभी मैंने देखा कि सात और गायें निकलीं—जो दुबली, पतली और कुरूप थीं. ऐसी कुरूप गायें मैंने मिस्र देश में कभी नहीं देखीं. ");
INSERT INTO hincv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","दुर्बल एवं कुरूप गायों ने उन सात मोटी एवं सुंदर गायों को खा लिया. ");
INSERT INTO hincv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","इतना होने पर भी यह समझ नहीं पाये कि इन्होंने उन सात मोटी गायों को कैसे खा लिया; लेकिन वे अब भी वैसी ही कुरूप बनी हुई थीं. और मेरी नींद खुल गई. ");
INSERT INTO hincv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“मैंने एक और स्वप्न देखा: एक ही तने में से सात मोटी एवं अच्छी बालें उगीं. ");
INSERT INTO hincv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","तभी मैंने देखा कि कमजोर और मुरझाई, और पूर्वी वायु से झुलसी बालें उगीं. ");
INSERT INTO hincv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","तथा कमजोर बालों ने उन मोटी बालों को निगल लिया. मैंने अपने ज्योतिषियों से ये स्वप्न बताये, लेकिन अर्थ कोई नहीं बता पाया.” ");
INSERT INTO hincv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","तब योसेफ़ ने फ़रोह से कहा, “आपके दोनों स्वप्न एक ही हैं. इनमें परमेश्वर ने फ़रोह को बताया हैं कि परमेश्वर क्या करने जा रहे हैं. ");
INSERT INTO hincv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","सात सुंदर और मोटी गायें सात वर्ष हैं, सात अच्छी बालें भी सात वर्ष हैं; दोनों ही स्वप्न एक ही हैं. ");
INSERT INTO hincv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","कमजोर एवं कुरूप गायें, सात वर्ष हैं, और मुरझाई हुई बालें जो देखी वे भी सात वर्ष; वे अकाल के होंगे. ");
INSERT INTO hincv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“जैसा मैंने फ़रोह को बताया, ठीक वैसा ही होगा; परमेश्वर ने आपको यह दिखा दिया है कि जल्दी ही क्या होनेवाला है. ");
INSERT INTO hincv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","मिस्र देश में सात वर्ष बहुत ही अच्छी फसल होगी, ");
INSERT INTO hincv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","और उसके बाद सात वर्ष का अकाल होगा. तब मिस्र देश के लोग सारी उपज को भूल जायेंगे, और अकाल से देश का नाश होगा. ");
INSERT INTO hincv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","अकाल इतना भयानक होगा कि अच्छी फसल और उपज किसी को याद तक नहीं रहेगी. ");
INSERT INTO hincv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","फ़रोह आपने एक ही बात के विषय दो बार स्वप्न देखे; यह इस बात को दिखाता है कि परमेश्वर निश्चय ही ऐसा होने देंगे और परमेश्वर जल्दी ही इसे पूरा करेंगे. ");
INSERT INTO hincv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“इसलिये फ़रोह जल्दी किसी समझदार एवं बुद्धिमान व्यक्ति को मिस्र देश का अधिकारी बनाएं. ");
INSERT INTO hincv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","और फ़रोह सारे मिस्र देश में सर्वेक्षकों को नियुक्त करे और सात वर्ष जो अच्छी फसल और उपज का है, उस समय भूमि की उपज का पंचमांश इकट्ठा करें. ");
INSERT INTO hincv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","तब अच्छी फसल के सात वर्षों में सारी भोजन वस्तु एकत्रित की जाये और अनाज को फ़रोह के अधिकार में भंडार नगरों में सुरक्षित रखते जायें. ");
INSERT INTO hincv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","और यह भोजन सात वर्ष के अकाल से बचने के लिए पूरे मिस्र देश को देने के लिए इकट्ठा करे ताकि लोग भोजन के अभाव में नहीं मरें.” ");
INSERT INTO hincv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","फ़रोह तथा सब कर्मचारियों को लगा कि यह जवाबदारी योसेफ़ को ही दी जाये. ");
INSERT INTO hincv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","फ़रोह ने अपने सेवकों से पूछा, “क्या हमें ऐसा कोई व्यक्ति मिल सकता है जिसमें परमेश्वर का आत्मा हो?” ");
INSERT INTO hincv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","फिर फ़रोह ने योसेफ़ से कहा, “इसलिये कि परमेश्वर ने ही तुम पर यह सब प्रकट किया है, तुम यह जवाबदारी लो क्योंकि तुम जैसा समझदार तथा बुद्धिमान कोई नहीं. ");
INSERT INTO hincv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","और तुम मेरे महल के अधिकारी होंगे तथा मेरी प्रजा तुम्हारे ही आदेश का पालन करेगी. मैं सिंहासन पर बैठने के कारण राजा होकर तुमसे बड़ा रहूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","और फ़रोह ने योसेफ़ से कहा, “मैंने तुम्हें सारे मिस्र देश पर अधिकार दे दिया है.” ");
INSERT INTO hincv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","यह कहते हुए फ़रोह ने अपनी राजमुद्रा वाली अंगूठी उतारकर योसेफ़ को पहना दी, और मलमल के वस्त्र तथा गले में सोने की माला भी पहना दी. ");
INSERT INTO hincv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","फिर फ़रोह ने योसेफ़ को अपने दूसरे रथ में चढ़ाकर सम्मान दिया. रथों के आगे-आगे चल रहे अधिकारी बोल रहे थे, “घुटने टेको!” इस प्रकार फ़रोह ने योसेफ़ को संपूर्ण मिस्र का अधिकार सौंप दिया. ");
INSERT INTO hincv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","और फ़रोह ने योसेफ़ से कहा, “फ़रोह तो मैं हूं, किंतु अब से सारे मिस्र देश में बिना तुम्हारी आज्ञा के कोई भी न तो हाथ उठा सकेगा और न ही पांव.” ");
INSERT INTO hincv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","फ़रोह ने योसेफ़ का नया नाम ज़ाफेनाथ-पानियाह रखा तथा उनका विवाह ओन के पुरोहित पोतिफेरा की पुत्री असेनाथ से कर दिया. इस प्रकार अब योसेफ़ समस्त मिस्र देश के प्रशासक हो गए. ");
INSERT INTO hincv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","जब योसेफ़ को मिस्र के राजा फ़रोह के पास लाया गया, तब वे तीस वर्ष के थे. फ़रोह से अधिकार पाकर योसेफ़ समस्त मिस्र देश का निरीक्षण करने के लिए निकले. ");
INSERT INTO hincv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","पहले सात वर्षों में बहुत उपज हुई. ");
INSERT INTO hincv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","और योसेफ़ ने इन सात वर्षों में बहुत भोजन वस्तुएं जमा की, जो मिस्र देश में उत्पन्‍न हो रही थीं. वह सब अन्‍न योसेफ़ नगरों में जमा करते गए. जिस नगर के पास खेत था उसकी उपज वहीं जमा करते गए. ");
INSERT INTO hincv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","इस तरह योसेफ़ ने सागर तट के बालू समान अनाज जमा कर लिया कि उसको गिनना ही छोड़ दिया, क्योंकि उपज असंख्य हो चुकी थी. ");
INSERT INTO hincv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","इससे पहले कि अकाल के वर्ष शुरू हों, ओन के पुरोहित पोतिफेरा की पुत्री असेनाथ से योसेफ़ के दो पुत्र पैदा हुए. ");
INSERT INTO hincv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","पहले बेटे का नाम योसेफ़ ने मनश्शेह रखा क्योंकि उन्होंने विचार किया, “परमेश्वर ने सभी कष्टों एवं मेरे पिता के परिवार को भुलाने में मेरी सहायता की है.” ");
INSERT INTO hincv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","उन्होंने दूसरे पुत्र का नाम एफ्राईम रखा, क्योंकि उनका कहना था, “दुःख मिलने की जगह इस देश में परमेश्वर ने मुझे फलवंत किया.” ");
INSERT INTO hincv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","जब मिस्र देश में फसल के वे सात वर्ष खत्म हुए, ");
INSERT INTO hincv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","तब अकाल के सात वर्षों की शुरुआत हुई, जैसा योसेफ़ ने कहा था. सभी देशों में अकाल था, किंतु मिस्र देश में अन्‍न की कोई कमी न थी. ");
INSERT INTO hincv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","जब मिस्र देश में भोजन की कमी होने लगी तब लोग फ़रोह से भोजन मांगने लगे. फ़रोह ने मिस्र की प्रजा से कहा, “तुम योसेफ़ के पास जाओ. वह जो कुछ कहे, वही करना.” ");
INSERT INTO hincv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","जब पूरे देश में अकाल पड़ा, तब योसेफ़ ने अपने भंडार खोलकर मिस्रवासियों को अन्‍न बेचना शुरू किया, क्योंकि अकाल भयानक था. ");
INSERT INTO hincv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","पृथ्वी के अलग-अलग देश से लोग योसेफ़ से अन्‍न खरीदने आने लगे, क्योंकि सारी पृथ्वी पर अकाल भयंकर हो चुका था. ");
INSERT INTO hincv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","जब याकोब को यह पता चला कि मिस्र देश में अन्‍न मिल रहा है, तो उन्होंने अपने बेटों से कहा, “क्यों एक दूसरे का मुख ताक रहे हो? ");
INSERT INTO hincv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","मिस्र देश में अन्‍न मिल रहा है. जाओ और वहां से अन्‍न खरीद कर लाओ, कि हम जीवित रह सकें.” ");
INSERT INTO hincv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","तब योसेफ़ के दस भाई अन्‍न खरीदने मिस्र देश आये. ");
INSERT INTO hincv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","किंतु याकोब ने योसेफ़ के भाई बिन्यामिन को नहीं भेजा क्योंकि उन्हें यह डर था कि कहीं उस पर कोई कष्ट न आ पड़े. ");
INSERT INTO hincv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","इसलिये इस्राएल के पुत्र अन्‍न खरीदने मिस्र पहुंचे, क्योंकि कनान देश में भी अकाल था. ");
INSERT INTO hincv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","योसेफ़ मिस्र देश के प्रशासक थे. वही पूरे राष्ट्र को अन्‍न बेचते थे. योसेफ़ के भाई वहां पहुंचे और उनको प्रणाम किया और उनका मुह ज़मीन की ओर था. ");
INSERT INTO hincv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","योसेफ़ अपने भाइयों को देखते ही पहचान गए; लेकिन अनजान बनकर वह अपने भाइयों से कठोरता से बात कर रहे थे. योसेफ़ ने उनसे पूछा, “तुम लोग कहां से आए हो?” उन्होंने कहा, “कनान देश से, अन्‍न खरीदने के लिए आए हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","योसेफ़ ने तो अपने भाइयों को पहचान लिया था, किंतु भाइयों ने उन्हें नहीं पहचाना था. ");
INSERT INTO hincv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","तब योसेफ़ को अपने स्वप्न याद आये, जो उन्होंने उनके विषय में देखे थे. उन्होंने अपने भाइयों से कहा, “तुम लोग भेदिए हो और तुम यहां हमारे देश की दुर्दशा देखने आए हो.” ");
INSERT INTO hincv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","उन्होंने कहा, “नहीं, अधिपति महोदय, आपके ये सेवक अन्‍न खरीदने यहां आए हैं. ");
INSERT INTO hincv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","हम सभी एक ही पिता की संतान हैं. हम, सीधे और सच्चे लोग हैं, कोई जासूस नहीं.” ");
INSERT INTO hincv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","योसेफ़ ने फिर भी उनसे कहा, “मैं नहीं मान सकता. तुम लोग अवश्य हमारे देश की दुर्दशा देखने आए हो!” ");
INSERT INTO hincv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","किंतु वे बार-बार कहते रहे, “आपके ये सेवक बारह भाई हैं, जो एक ही पिता की संतान हैं, हम कनान के रहनेवाले हैं. हमारा छोटा भाई हमारे पिता के साथ ही है. हमारा एक भाई अब जीवित नहीं है.” ");
INSERT INTO hincv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","योसेफ़ ने उनसे कहा, “कुछ भी हो, मैं जानता हूं कि तुम लोग जासूस ही हो! ");
INSERT INTO hincv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","अब तुम्हें जांचने का एक ही तरीका हैं: फ़रोह के जीवन की शपथ, तुम्हारे छोटे भाई को यहां आना होगा. ");
INSERT INTO hincv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","तुममें से कोई जाकर अपने भाई को यहां लेकर आओ; फ़रोह की शपथ, तब तक तुम सभी बंदी बनकर यहीं रहोगे, और तुमने कितना सच कहा है वह पता चल जायेगा.” ");
INSERT INTO hincv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","तब योसेफ़ ने उन्हें तीन दिन के लिए बंदीगृह में डाल दिया. ");
INSERT INTO hincv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तीसरे दिन योसेफ़ ने उनसे कहा, “यदि जीवित रहना चाहते हो, तो तुम्हें यह करना होगा; क्योंकि मुझमें परमेश्वर का भय है: ");
INSERT INTO hincv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","यदि तुम सच्चे हो, तो तुममें से एक भाई कारागार में रहे और बाकी तुम लोग वापस घर जाओ और अपने परिवार को अकाल से बचाने के लिए अन्‍न ले जाओ. ");
INSERT INTO hincv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","और अपने छोटे भाई को यहां लेकर आना, ताकि वह तुम्हारे शब्दों को साबित कर सके और तुम्हारी मृत्यु न हो!” उन्होंने इस बात को माना. ");
INSERT INTO hincv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","तब वे आपस में बात करने लगे, “हम अपने भाई के प्रति दोषी हैं, क्योंकि जब वह हमसे लगातार दया मांगी, और उसके प्राणों की वेदना दिख रही थी, किंतु हमने ही अपना मन कठोर बना लिया था. यही कारण कि आज हम पर यह कष्ट आ पड़ा है.” ");
INSERT INTO hincv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","रियूबेन ने कहा, “क्या मैं नहीं कह रहा था, लड़के के विरुद्ध कोई अपराध मत करो? तुमने मेरी बात न सुनी. अब समय आ गया है; उसकी हत्या का बदला पाने का.” ");
INSERT INTO hincv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","उन्हें मालूम नहीं पड़ा कि योसेफ़ उनकी बात को समझ रहे थे. ");
INSERT INTO hincv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","योसेफ़ उनके सामने से अलग जाकर रोने लगे; फिर वापस आकर उन्होंने उन्हीं के सामने शिमओन को पकड़ा और बांध दिया. ");
INSERT INTO hincv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","फिर योसेफ़ ने आदेश दिया कि उनके बोरों को अन्‍न से भर दिया जाए और जो दाम दिया है, वह भी उसी के बोरे में रख दिया जाए. और योसेफ़ ने कहा कि उनकी यात्रा के लिए आवश्यक सामान भी उन्हें दे दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","तब भाइयों ने अपने-अपने गधों पर अन्‍न के बोरे रखे और वहां से चल पड़े. ");
INSERT INTO hincv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","जब रास्ते में गधे को चारा देने के उद्देश्य से उनमें से एक ने बोरा खोला, तो उसे वही रुपया दिखा जिसे उसने उन्हें दिया था. ");
INSERT INTO hincv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","यह उसने अपने भाइयों को बताया, “मैंने जो रुपया दिया था वह मेरे बोरे में मिला है.” वे सभी आश्चर्य करने लगे. और कांपने लगे तथा एक दूसरे की ओर देखते हुए कहने लगे, “परमेश्वर ने हमारे साथ यह क्या कर दिया है?” ");
INSERT INTO hincv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","जब वे कनान देश में अपने पिता याकोब के पास पहुंचे, तब उन्होंने अपने पिता को पूरी घटना बताई. ");
INSERT INTO hincv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","और कहा, “उस देश का अधिपति हमसे कठोर होकर बात कर रहा था. उसने हमें अपने देश का जासूस समझा. ");
INSERT INTO hincv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","हमने उन्हें समझाया, ‘हम सच्चे लोग हैं; जासूस नहीं. ");
INSERT INTO hincv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","और बताया कि हम बारह भाई हैं, एक ही पिता की संतान. एक भाई अब जीवित नहीं रहा, तथा हमारा छोटा भाई पिता के साथ कनान देश में ही है.’ ");
INSERT INTO hincv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“उस देश के अधिपति ने हमसे कहा, ‘तुम्हारी सच्चाई तब प्रकट होगी जब तुम अपने भाइयों में से एक को मेरे पास छोड़कर जाओगे; और अब अकाल में अपने परिवारों के लिए अन्‍न लेकर जाओ. ");
INSERT INTO hincv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","जब तुम अपने छोटे भाई को मेरे पास लाओगे, तब मालूम पड़ेगा कि तुम जासूस नहीं हो, फिर मैं तुम्हारे भाई को छोड़ दूंगा और तुम इस देश में व्यापार कर सकोगे.’ ” ");
INSERT INTO hincv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","जब वे अपने-अपने बोरे खाली कर रहे थे, उन सभी ने देखा कि सबके बोरों में उनके रुपये की थैलियां रखी हुई है! जब उन्होंने तथा उनके पिता ने रुपये की थैली देखी, तब वे डर गए. ");
INSERT INTO hincv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","उनके पिता याकोब ने उनसे कहा, “तुम लोगों ने तो मुझसे मेरी संतान ही छीन ली है. योसेफ़ नहीं रहा और अब तुम लोग बिन्यामिन को ले जा रहे हो. यह सब मेरे विरुद्ध ही हो रहा है!” ");
INSERT INTO hincv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","रियूबेन ने अपने पिता को यह आश्वासन दिया, “अगर मैं बिन्यामिन को यहां वापस न लाऊं, तो आप मेरे दोनों पुत्रों की हत्या कर देना. आप बिन्यामिन को मेरे हाथों में सौंप दीजिए, मैं उसे वापस लाऊंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","किंतु याकोब कहते रहे, “मेरा पुत्र तुम्हारे साथ न जाएगा; क्योंकि उसके भाई की मृत्यु हो ही चुकी है, इसलिये वह अकेला ही रह गया है. यदि इस यात्रा में उसके साथ कुछ अनर्थ हुआ तो तुम इस बुढ़ापे में मुझे घोर वेदना के साथ कब्र में नीचे उतारोगे.” ");
INSERT INTO hincv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","देश में अब भी अकाल बहुत भयंकर था. ");
INSERT INTO hincv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","जब उनके द्वारा मिस्र देश से लाया हुआ अन्‍न खत्म होने लगा, तब उनके पिता ने कहा, “जाओ, थोड़ा और अनाज खरीद कर लाओ.” ");
INSERT INTO hincv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","किंतु यहूदाह ने उनसे कहा, “बड़ी गंभीरता पूर्वक उस प्रशासक ने हमें चेतावनी दी थी, ‘यदि तुम अपने साथ अपने भाई को न लाओ तो मुझे अपना मुख न दिखाना.’ ");
INSERT INTO hincv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","अन्‍न मोल लेने हम तब ही वहां जायेंगे, जब आप हमारे साथ हमारे भाई को भी भेजेंगे. ");
INSERT INTO hincv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","यदि आप उसे हमारे साथ नहीं भेजेंगे, तो हम भी नहीं जाएंगे. क्योंकि उस अधिपति ने कहा था, ‘मेरे सामने ही न आना, यदि तुम्हारा भाई तुम्हारे साथ न होगा.’ ” ");
INSERT INTO hincv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","इस्राएल ने कहा, “क्यों तुम लोगों ने उसे यह बताकर मेरा अनर्थ कर दिया कि तुम्हारा एक भाई और भी है?” ");
INSERT INTO hincv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","किंतु उन्होंने अपने पिता को यह बताया, “वह व्यक्ति ही हमसे हमारे विषय में तथा हमारे संबंधियों के विषय में पूछ रहा था, ‘क्या तुम्हारा पिता अब भी जीवित है? क्या तुम्हारा कोई अन्य भाई भी है?’ हम केवल उसके प्रश्नों का उत्तर दे रहे थे. हमें क्या मालूम था कि वह हमसे ऐसा कहेंगे ‘अपने उस भाई को यहां ले आओ?’ ” ");
INSERT INTO hincv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","यहूदाह ने अपने पिता इस्राएल से कहा, “इस लड़के को मेरे साथ भेज दीजिए, तब हम यहां से जाएंगे, ताकि अकाल में हमारी मृत्यु न हो जाए और आप, और हमारे बच्‍चे नहीं मरें और सब जीवित रह सकें. ");
INSERT INTO hincv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","मैं इस लड़के की जवाबदारी अपने ऊपर लेता हूं; अगर उसे आपके पास लौटा न लाऊं, तो मैं सदा-सर्वदा आपका दोषी बना रहूंगा. ");
INSERT INTO hincv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","यदि हम देरी न करते तो हम वहां दो बार जाकर आ गए होते.” ");
INSERT INTO hincv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","यह सुन उनके पिता इस्राएल ने उनसे कहा, “अगर यही बात है, तो ठीक है, यही करो. लेकिन आप लोग अपने-अपने बोरों में उस व्यक्ति के लिए उपहार स्वरूप बलसान, मधु, गोंद, गन्धरस, पिस्ता तथा बादाम ले जाओ. ");
INSERT INTO hincv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","दो गुणा रुपया भी ले जाओ और जो रुपया तुम्हारे बोरे में वहां से आया था वह भी वापस कर देना, शायद भूल हो गई होगी. ");
INSERT INTO hincv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","अपने भाई को अपने साथ ले जाओ, देरी न करो. ");
INSERT INTO hincv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","प्रार्थना है कि सर्वशक्तिमान परमेश्वर उस व्यक्ति के दिल में दया डाले ताकि वह तुम्हारे उस भाई बिन्यामिन को छोड़ दे. अगर बिछड़ना ही है, तो ऐसा ही होने दो.” ");
INSERT INTO hincv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","तब उन्होंने उपहार, दो गुणा रुपया तथा अपने साथ बिन्यामिन को लिया और मिस्र के लिए रवाना हुए, और योसेफ़ के पास पहुंचे. ");
INSERT INTO hincv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","जब योसेफ़ ने अपने भाइयों के साथ बिन्यामिन को देखा, तब उन्होंने अपने घर के सेवक से कहा, “इन लोगों को मेरे घर ले जाओ, एक पशु का वध कर भोजन तैयार करो. ये सभी दोपहर का भोजन मेरे साथ करेंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","सेवक से जैसा कहा गया उसने वैसा ही किया और इन भाइयों को योसेफ़ के घर पर ले गए. ");
INSERT INTO hincv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","योसेफ़ के घर आकर सब डर गए. सबने सोचा, “जो रुपया हम सबके बोरे में था, वे हम लोगों को अपराधी सिद्ध करने लिए उनका उपयोग करेंगे. तब वे हम लोगों के गधों को ले लेंगे और हम लोगों को दास बनाएंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","इसलिये घर के पास आकर उन्होंने योसेफ़ के गृह सेवक से कहा, ");
INSERT INTO hincv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“महोदय, विश्वास कीजिए, जब हम पिछले बार भी मात्र अनाज खरीदने ही आये थे ");
INSERT INTO hincv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","तब हमने धर्मशाला पहुंचकर अपने-अपने बोरे खोले, तो हमने देखा कि जो रुपया हमने यहां अनाज के लिए दिया था वह वापस हमारे बोरे में रखा गया; तब हम वह रुपया अपने साथ लाए हैं. ");
INSERT INTO hincv_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","दुबारा खरीदने के लिए भी रुपया लाए हैं. हमें कुछ भी नहीं पता कि किसने रुपया हमारे बोरों में रखा था.” ");
INSERT INTO hincv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","उस सेवक ने उनसे कहा, “शांत हो जाइए, डरिये नहीं, आपके परमेश्वर, तुम्हारे पिता के परमेश्वर ने आपके बोरों में रुपया रखा होगा. मुझे तो रुपया मिल चुका है.” यह कहते हुए वह शिमओन को उनके पास बाहर लाए. ");
INSERT INTO hincv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","जब सेवक उन्हें योसेफ़ के घर के भीतर ले गये, उसने उन्हें पांव धोने के लिए पानी दिया, सबने अपने पांव धोए, सेवक ने उनके गधों को चारा भी दिया. ");
INSERT INTO hincv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","दोपहर में योसेफ़ के घर पहुंचने से पहले योसेफ़ को देने के लिए जो भेंट वे लाए थे उन्हें तैयार किया क्योंकि योसेफ़ इन सबके साथ खाना खाने आनेवाले थे. ");
INSERT INTO hincv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","योसेफ़ के घर पहुंचते ही जो भेंट वे उनके लिए लाए थे उन्हें उनको दिया और प्रणाम किया. ");
INSERT INTO hincv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","योसेफ़ ने सबका हाल पूछा और कहा, “क्या तुम्हारे बूढ़े पिता जिनके विषय में तुमने मुझे बताया था वह जीवित हैं?” ");
INSERT INTO hincv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","उन्होंने कहा, “हमारे पिता ठीक हैं, अभी तक जीवित हैं.” और आदर के साथ सिर झुकाकर प्रणाम किया. ");
INSERT INTO hincv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","तब योसेफ़ ने बिन्यामिन को देखा, योसेफ़ ने पूछा, “क्या यही तुम्हारा छोटा भाई है, जिसके विषय में तुमने मुझसे बताया था?” योसेफ़ ने कहा, “मेरे पुत्र, तुम पर परमेश्वर की कृपा बनी रहे.” ");
INSERT INTO hincv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","यह कहकर योसेफ़ एकदम उठकर चले गए, क्योंकि अपने भाई को देखकर प्यार से उनकी आंखें भर आईं और एकांत में जाकर रोने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","वे अपना मुंह धोकर वापस बाहर आये और अपने आपको संभाला और कहा, “खाना परोसो.” ");
INSERT INTO hincv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","योसेफ़ खाना खाने अलग बैठ गए और भाइयों को दूसरी ओर अलग बिठाया, क्योंकि मिस्री और इब्री एक साथ भोजन नहीं कर सकते. ");
INSERT INTO hincv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","योसेफ़ के भाइयों को उनके सामने ही अपनी-अपनी आयु के क्रम से पंक्ति में बैठा गया; सबके पहले सबसे बड़ा, फिर उसका छोटा, फिर उसका छोटा. सभी भाई एक दूसरे को आश्चर्य से देखते रहे. ");
INSERT INTO hincv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","योसेफ़ ने अपने लिए परोसे गए भोजन में से सबको दिया, लेकिन बिन्यामिन को पांच गुणा ज्यादा दिया गया. सबने योसेफ़ के साथ भरपेट खाया और पिया. ");
INSERT INTO hincv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","योसेफ़ ने अपने घर के भंडारी को आदेश दिया: “इनके बोरों को जितना वे ले जा सकते हैं उतने अन्‍न से भर दो और हर एक का दिया गया धन उसी के बोरे में डाल देना. ");
INSERT INTO hincv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","तब सबसे छोटे भाई के बोरे में मेरा चांदी का कटोरा तथा अन्‍न के लिए लिया गया धन भी रख देना.” भंडारी ने योसेफ़ के आदेश के अनुरूप ही किया. ");
INSERT INTO hincv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","भोर होते ही उन्हें उनके अपने-अपने गधों के साथ विदा कर दिया गया. ");
INSERT INTO hincv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","वे नगर के बाहर निकले ही थे कि योसेफ़ ने अपने घर के भंडारी को आदेश दिया, “उठो, उनका पीछा करो. जब तुम उन तक पहुंच जाओ, तो उनसे कहना, ‘भलाई का बदला तुम बुरे से क्यों दे रहे हो? ");
INSERT INTO hincv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","क्या यह वही पात्र नहीं है, जिससे हमारे स्वामी पीते हैं, जिससे वह भावी जानते हैं? आप लोगों ने यह उचित नहीं किया है.’ ” ");
INSERT INTO hincv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","वह भंडारी उन तक जा पहुंचा और उनसे वही सब कह दिया. ");
INSERT INTO hincv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","उन्होंने उसे उत्तर दिया, “मेरे स्वामी, आप यह क्या कह रहे हैं? आपके सेवक ऐसा कुछ भी नहीं कर सकते! ");
INSERT INTO hincv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","आप देख लीजिए कि वह राशि, जो हमारे साथ चली गई थी, कनान देश से हमने आपको लौटा दी है. तो हम आपके स्वामी के आवास से चांदी अथवा स्वर्ण क्यों चुराते? ");
INSERT INTO hincv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","जिस किसी के पास वह पात्र पाया जाए, उसे प्राण-दंड दे दिया जाए, और हम सभी आपके अधिपति के दास बन जाएंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","भंडारी ने उनसे कहा, “ठीक है, जैसा तुम लोगों ने कहा है, वैसा ही होगा, जिसके पास से वह पात्र पाया जाएगा, वह मेरा दास हो जाएगा, शेष निर्दोष होंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","शीघ्र ही उन्होंने अपने-अपने बोरे नीचे उतारे. हर एक ने अपना बोरा खोल दिया. ");
INSERT INTO hincv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","उसने खोजना प्रारंभ किया, सबसे बड़े से सबसे छोटे के क्रम में, और कटोरा बिन्यामिन के बोरे में पाया गया. ");
INSERT INTO hincv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","यह देख हर एक ने अपने-अपने वस्त्र फाड़ डाले, गधों पर सामग्री लादी और नगर को लौट गए. ");
INSERT INTO hincv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","जब यहूदाह तथा उसके भाई योसेफ़ के आवास पर पहुंचे, योसेफ़ वहीं थे. वे उनके समक्ष नत हुए. ");
INSERT INTO hincv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","योसेफ़ ने उनसे कहा, “यह क्या किया है आप लोगों ने? क्या आपको यह बोध नहीं कि मैं अपने इस पद पर होने के कारण वास्तव में भविष्य ज्ञात कर सकता हूं?” ");
INSERT INTO hincv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","इसका उत्तर यहूदाह ने दिया, “हम अपने स्वामी से क्या कहें? हमारे पास तो कहने के लिए शब्द ही नहीं हैं. हम स्वयं को निर्दोष प्रमाणित ही नहीं कर सकते. परमेश्वर ही ने आपके सेवकों की पापिष्ठता ज्ञात कर ली है. देखिए, हम अपने अधिपति के दास होने के लिए तैयार हैं; हम सभी तथा वह जिसके बोरे में वह कटोरा पाया गया है.” ");
INSERT INTO hincv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","योसेफ़ ने उत्तर दिया, “मैं ऐसा कभी नहीं कर सकता. मेरा दास वही व्यक्ति बनाया जाएगा, जिसके बोरे में वह कटोरा पाया गया है. शेष आप सभी अपने पिता के पास शांतिपूर्वक लौट जाएं.” ");
INSERT INTO hincv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","यह सुन यहूदाह योसेफ़ के निकट गए और उनसे आग्रह किया, “मेरे अधिपति महोदय, क्या आप अपने सेवक को अपने कानों में कुछ कहने की अनुमति प्रदान करेंगे? कृपया आप मुझ अपने सेवक पर क्रुद्ध न हों, क्योंकि आप तो पद में फ़रोह के समान हैं. ");
INSERT INTO hincv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","मेरे अधिपति, आपने अपने सेवकों से पूछा था, ‘क्या तुम्हारे पिता अथवा भाई हैं?’ ");
INSERT INTO hincv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","हमने अपने अधिपति को उत्तर दिया था, ‘हमारे वयोवृद्ध पिता हैं तथा उनकी वृद्धावस्था में एक बालक भी है. हां, उसके भाई की मृत्यु हो चुकी है. अब वह अपनी माता का एकमात्र पुत्र रह गया है. वह अपने पिता का अत्यंत प्रिय पुत्र है.’ ");
INSERT INTO hincv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“तब महोदय ने अपने इन सेवकों को आदेश दिया था, ‘उस पुत्र को यहां ले आओ, कि मैं उसे देख सकूं.’ ");
INSERT INTO hincv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","किंतु हमने अपने अधिपति से निवेदन किया था, ‘यह किशोर अपने पिता से दूर नहीं रह सकता, क्योंकि यदि उसे पिता से दूर किया जाएगा, तो उसके पिता की मृत्यु हो जाएगी.’ ");
INSERT INTO hincv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","किंतु आपने तो अपने इन सेवकों से कहा था, ‘यदि तुम्हारा वह कनिष्ठ भाई तुम्हारे साथ यहां नहीं आएगा, तो तुम मेरा मुख न देखोगे.’ ");
INSERT INTO hincv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","तब हुआ यह कि जब हम लौटकर अपने पिता के यहां पहुंचे, हमने उन्हें अपने अधिपति, आप का आदेश सुना दिया. ");
INSERT INTO hincv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“हमारे पिता का आदेश था, ‘पुनः मिस्र जाकर हमारे उपभोग के लिए कुछ अन्‍न ले आओ.’ ");
INSERT INTO hincv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","हमने प्रतिवाद किया, ‘हम वहां बिना हमारे कनिष्ठ भाई के नहीं जा सकते; क्योंकि हम अधिपति की उपस्थिति में बिना अपने कनिष्ठ भाई के प्रवेश कर ही नहीं सकेंगे.’ ");
INSERT INTO hincv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“आपके सेवक हमारे पिता ने हमें स्मरण दिलाया, ‘तुम्हें स्मरण ही है कि मेरी पत्नी से मुझे दो पुत्र पैदा हुए थे, ");
INSERT INTO hincv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","एक तो मैं खो चुका हूं. निश्चय ही वह कोई हिंसक पशु द्वारा फाड़ डाला गया है, तब से मैंने उसे नहीं देखा है. ");
INSERT INTO hincv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","अब यदि तुम इस कनिष्ठ को भी मुझसे दूर ले जाना चाह रहे हो और यदि उसका भी कुछ अनिष्ट हो जाता है, तो इस वृद्धावस्था में तुम मुझ पर विषादपूर्ण मृत्यु ले आओगे.’ ");
INSERT INTO hincv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“इसलिये अब आपके सेवक मेरे पिता के पास लौटूंगा और यदि यह किशोर हमारे साथ न होगा तो; वस्तुस्थिति यह है कि हमारे पिता का प्राण इस किशोर के प्राणों से संयुक्त है, ");
INSERT INTO hincv_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","जब वह यह पाएंगे, कि हम इस किशोर को साथ लेकर नहीं लौटे हैं, तो उनके प्राण ही निकल जाएंगे. हम, आपके सेवक, हमारे पिता को उनकी वृद्धावस्था में घोर शोक के साथ अधोलोक भेज देंगे. ");
INSERT INTO hincv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","मैं आपका सेवक, अपने पिता के समक्ष इस किशोर के लिए प्रतिभूति होकर आया हूं. मैंने पिता को आश्वासन दिया था, ‘यदि मैं उसे लौटाकर आपके समक्ष लाने में असमर्थ पाया जाऊं, तो मैं अपने पिता के समक्ष सदा-सर्वदा के लिए दोषी बना रहूंगा.’ ");
INSERT INTO hincv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“तब हे स्वामी, अब कृपा कर इस किशोर के स्थान पर मुझे अपना दास बना लीजिए. ");
INSERT INTO hincv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","क्योंकि मैं अब अपने पिता के समक्ष कैसे जा सकता हूं, यदि यह किशोर हमारे साथ न होगा? मुझे भय है कि इससे मेरे पिता पर अनिष्ट ही आ पड़ेगा!” ");
INSERT INTO hincv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","यहां तक आकर योसेफ़ का नियंत्रण टूट गया. वह वहां उपस्थित सभी व्यक्तियों के समक्ष चिल्ला उठे, “सब यहां से बाहर चले जाएं.” सब वहां से बाहर चले गए. तब योसेफ़ ने स्वयं को अपने भाइयों पर अपने वास्तविक रूप में प्रकट किया. ");
INSERT INTO hincv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","योसेफ़ का क्रंदन इतना प्रबल था कि बाहर मिस्री अधिकारियों ने इसे सुन लिया तथा इसके विषय में फ़रोह के परिवार ने भी सुन लिया. ");
INSERT INTO hincv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","तब योसेफ़ ने अपने भाइयों से कहा, “मैं योसेफ़ हूं! क्या मेरा पिताजी अब भी जीवित हैं?” किंतु उनके भाई अवाक रह गए थे, उनके लिए योसेफ़ के समक्ष कुछ भी कहना असंभव हो गया था. ");
INSERT INTO hincv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","तब योसेफ़ ने अपने भाइयों से अनुरोध किया, “मेरे निकट आइए” वे उनके निकट गए तब योसेफ़ ने उनसे कहा, मैं आपका भाई योसेफ़ हूं, जिसे आप लोगों ने मिस्र देश से आनेवाले व्यापारियों के हाथों में बेच दिया था! ");
INSERT INTO hincv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","अब आप न तो स्वयं के लिए शोकित हों और न ही क्रुद्ध, कि आपने मुझे यहां के लिए विक्रीत कर दिया था; क्योंकि परमेश्वर ही मुझे आपके पूर्व यहां ले आए हैं, कि जीवन बचाए जाएं. ");
INSERT INTO hincv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","क्योंकि दो वर्ष से संपूर्ण देश में अकाल व्याप्‍त है तथा यह पांच वर्ष और भी व्याप्‍त रहेगा. तब इन वर्षों में न तो हल चलाए जा सकेंगे और न ही किसी प्रकार की कटनी संभव हो सकेगी. ");
INSERT INTO hincv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","परमेश्वर ने मुझे आप लोगों के पूर्व ही यहां भेज दिया था, कि वह आप लोगों के लिए पृथ्वी पर एक शेषांश बचा रखें, आपको एक बड़ा बचाव द्वारा जीवित रखा जा सके. ");
INSERT INTO hincv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“इसलिये, वास्तव में, मुझे यहां आप लोगों के द्वारा नहीं, परंतु परमेश्वर द्वारा भेजा गया था. परमेश्वर ने ही मुझे फ़रोह के पिता का स्थान दिया है, मुझे फ़रोह की समस्त गृहस्थी का प्रभारी तथा पूरे मिस्र देश पर प्रशासक नियुक्त कर दिया है. ");
INSERT INTO hincv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","अब आप लोग अविलम्ब मेरे पिता के पास जाकर उनसे कहें, ‘आपके पुत्र योसेफ़ का यह आग्रह है: परमेश्वर ने मुझे समग्र मिस्र देश का प्रशासक नियुक्त किया है. आप यहां मेरे पास आ जाएं. अब विलंब न करें. ");
INSERT INTO hincv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","आप लोग आकर गोशेन प्रदेश में बस जाएं और मेरे निकट ही आप, आपकी संतान, आपकी संतान की संतान, आपके पशुवृन्द, आपकी भेड़-बकरी तथा आपकी संपूर्ण संपत्ति भी. ");
INSERT INTO hincv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","वहां मैं आपके लिए भोजन की व्यवस्था करता रहूंगा, क्योंकि अकाल अभी पांच वर्ष और रहेगा, जिसके कारण आप वहां आपकी संपूर्ण गृहस्थी के साथ पूर्णतः साधन विहीन हो जाएंगे.’ ");
INSERT INTO hincv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“अब आप लोग स्वयं देख लीजिए और यहां स्वयं मेरा भाई बिन्यामिन भी यह देख रहा है कि यह स्वयं मैं आपसे कह रहा हूं. ");
INSERT INTO hincv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","अब आप लोग जाइए और जाकर मिस्र में मेरे इस वैभव का उल्लेख वहां मेरे पिता से कीजिए तथा उस सबका भी, जो स्वयं आपने यहां देखा है. आवश्यक है कि अब आप अति शीघ्र जाएं और मेरे पिता को यहां ले आएं.” ");
INSERT INTO hincv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","तब योसेफ़ अपने भाई बिन्यामिन को गले लगाकर रोते रहे तथा बिन्यामिन भी उनसे गले लगकर रोते रहे. ");
INSERT INTO hincv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","फिर योसेफ़ ने अपने सभी भाइयों का चुंबन लिया और उनके साथ रोते रहे; इसके बाद ही उनके भाइयों ने योसेफ़ के साथ बात करना आरंभ किया. ");
INSERT INTO hincv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","फ़रोह के परिवार में भी यह समाचार सुना गया कि योसेफ़ के भाई आए हुए हैं, जिसे सुनकर फ़रोह तथा उसके दासों में उल्लास की लहर दौड़ गई. ");
INSERT INTO hincv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","तब फ़रोह ने योसेफ़ के समक्ष प्रस्ताव रखा, “अपने भाइयों से यह कहो, ‘अपने-अपने गधों पर सामान रखें और कनान देश चले जाएं, ");
INSERT INTO hincv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","वहां से अपने पिता एवं समस्त गृहस्थी लेकर यहां मेरे पास आ जाएं, मैं उन्हें मिस्र देश का सर्वोत्तम ही प्रदान करूंगा और उनका भोजन इस देश की प्रचुरता में से ही होगा.’ ");
INSERT INTO hincv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“और अब, योसेफ़ तुम्हारे लिए आदेश यह है; ‘ऐसा करो: यहां मिस्र देश से स्त्रियों एवं बालकों के लिए वाहन ले जाओ और अपने पिता को यहां ले आओ. ");
INSERT INTO hincv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","अपने सामान की चिंता न करना, क्योंकि मिस्र देश में जो कुछ सर्वोत्तम है, वह सब तुम्हारा ही है.’ ” ");
INSERT INTO hincv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","इस्राएल के पुत्रों ने ठीक यही किया. फ़रोह के आदेश के अनुरूप योसेफ़ ने उन्हें वाहन प्रदान कर दिए तथा यात्रा के लिए आवश्यक सामग्री भी दी. ");
INSERT INTO hincv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","योसेफ़ ने हर एक को एक-एक जोड़ी वस्त्र भी दिया, किंतु बिन्यामिन को तीन सौ चांदी मुद्राएं और पांच जोड़ी वस्त्र दिये. ");
INSERT INTO hincv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","अपने पिता के लिए योसेफ़ ने ये सभी वस्तुएं भेजीं: दस गधे, जिन पर मिस्र की सर्वोत्तम वस्तुएं रख दी गई थीं, दस गधियां, जिन पर भोज्य सामग्री तथा अन्‍न रख दिया गया था, कि यात्रा के समय उनके पिता का भरण-पोषण होता रहे. ");
INSERT INTO hincv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","इस प्रकार योसेफ़ ने अपने भाइयों को कनान देश के लिए भेज दिया. जब वे विदा हो ही रहे थे, तब योसेफ़ ने उनसे आग्रह किया, “यात्रा मध्य आपस में झगड़ना नहीं.” ");
INSERT INTO hincv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","इसलिये वे मिस्र देश से अपने पिता के पास कनान में पहुंच गए, ");
INSERT INTO hincv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","उन्होंने अपने पिता को सूचित किया, “योसेफ़ जीवित है! और सत्य तो यह है कि वह समस्त मिस्र देश का प्रशासक है.” यह सुन याकोब अवाक रह गए—उन्हें अपने पुत्रों की बातों पर विश्वास ही न हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","तब उन्होंने अपने पिता को योसेफ़ की कही हुई वह सारी बातें बताई जो उन्होंने उनसे कही थीं. जब उन्होंने योसेफ़ द्वारा भेजें वाहन देखे, जो उनको ले जाने के लिए भेजे गए थे, तब उनके पिता याकोब के जी में जी आया. ");
INSERT INTO hincv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","तब इस्राएल ने कहा, “मैं आश्वस्त हूं! मेरा पुत्र योसेफ़ जीवित है, अपनी मृत्यु के पूर्व वहां जाकर मैं उसे देखूंगा.” ");
INSERT INTO hincv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","इस्राएल अपनी पूरी संपत्ति लेकर वहां से रवाना हुए. जब वे बेअरशेबा पहुंचे, उन्होंने अपने पिता यित्सहाक के परमेश्वर को बलि चढ़ाई. ");
INSERT INTO hincv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","उस रात परमेश्वर ने इस्राएल को दर्शन में कहा “हे, याकोब! याकोब!” उसने कहा, “कहिये, क्या आज्ञा है?” ");
INSERT INTO hincv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","उन्होंने कहा, “मैं परमेश्वर, तुम्हारे पिता का परमेश्वर हूं; मिस्र जाने से मत डरो, तुम वहां जाओ और मैं वहां तुमसे एक बड़ी जाति बनाऊंगा. ");
INSERT INTO hincv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","मिस्र तक मैं तुम्हारे साथ साथ चलूंगा और निश्चयतः मैं ही तुम्हें वहां से लौटा भी लाऊंगा. तुम्हारी मृत्यु के समय योसेफ़ तुम्हारे पास होगा.” ");
INSERT INTO hincv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","तब इस्राएल के पुत्रों ने अपने पिता याकोब, अपने-अपने बालकों एवं अपनी-अपनी पत्नियों को उस गाड़ी में बैठा दिया, जिसे फ़रोह ने भेजी थी. ");
INSERT INTO hincv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","इन्होंने अपने साथ अपने पशु एवं पूरी संपत्ति ले ली थी, जो कनान देश में उन्होंने अर्जित थी. याकोब तथा उनके सभी लोग मिस्र देश पहुंच गये. ");
INSERT INTO hincv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","याकोब अपने पुत्र तथा उनके पौत्र, उनकी पुत्रियां तथा उनकी पौत्रियां—सभी को अपने साथ मिस्र लेकर आये. ");
INSERT INTO hincv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","इस्राएल के पुत्रों के नाम (याकोब तथा उनके पुत्र) जो मिस्र देश में आए थे: रियूबेन, याकोब का बड़ा बेटा. ");
INSERT INTO hincv_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","रियूबेन के पुत्र: हनोख, पल्लू, हेज़रोन तथा कारमी. ");
INSERT INTO hincv_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमओन के पुत्र: येमुएल, यामिन, ओहद, याकिन, ज़ोहार, तथा एक कनानी स्त्री से पैदा शाऊल. ");
INSERT INTO hincv_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवी के पुत्र: गेरशोन, कोहाथ तथा मेरारी. ");
INSERT INTO hincv_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदाह के पुत्र: एर, ओनान, शेलाह, पेरेज़ तथा ज़ेराह (किंतु एर तथा ओनान की मृत्यु कनान देश में ही हो चुकी थी). पेरेज़ के पुत्र: हेज़रोन एवं हामुल. ");
INSERT INTO hincv_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्साखार के पुत्र: तोला, पुव्वाह, याशूब तथा शिम्रोन. ");
INSERT INTO hincv_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ज़ेबुलून के पुत्र: सेरेद, एलोन तथा याहलील. ");
INSERT INTO hincv_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ये सभी लियाह के पुत्र थे जो याकोब से पद्दन-अराम में पैदा हुए थे; इनके अतिरिक्त उनकी एक पुत्री दीनाह भी थी. उनके पुत्र-पुत्रियों की संख्या तैंतीस थी. ");
INSERT INTO hincv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","गाद के पुत्र: ज़िफिओन, हग्गी, शूनी, एज़बोन, एरी, अरोदी तथा अरेली. ");
INSERT INTO hincv_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशेर के पुत्र: इमनाह, इशवाह, इशवी, बेरियाह तथा उनकी बहन सेराह. बेरियाह के पुत्र: हेबेर तथा मालखिएल. ");
INSERT INTO hincv_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ये सभी ज़िलपाह से जन्मे पुत्र हैं. ज़िलपाह लाबान द्वारा अपनी पुत्री लियाह को दी गईं दासी थी. उससे याकोब के सोलह जन पैदा हुए थे. ");
INSERT INTO hincv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","याकोब की पत्नी राहेल: योसेफ़ तथा बिन्यामिन जन्मे. ");
INSERT INTO hincv_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","मिस्र देश में योसेफ़ के दो पुत्र मनश्शेह तथा एफ्राईम जन्मे. ये सभी योसेफ़ की पत्नी असेनाथ से जन्मे थे जो ओन के पुरोहित पोतिफेरा की पुत्री थी. ");
INSERT INTO hincv_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बिन्यामिन के पुत्र: बेला, बेकेर, अशबेल, गेरा, नामान, एही, रोश, मुप्पिम, हुप्पिम तथा अर्द. ");
INSERT INTO hincv_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ये राहेल द्वारा याकोब के पुत्र हैं, जो चौदह व्यक्ति थे. ");
INSERT INTO hincv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","दान का पुत्र: हुषीम. ");
INSERT INTO hincv_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नफताली के पुत्र: यहसेल, गूनी, येसेर तथा शिल्लेम. ");
INSERT INTO hincv_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ये सभी अपनी पुत्री राहेल को लाबान द्वारा दी गईं दासी बिलहाह से जन्मे याकोब के पुत्र थे. ये सभी कुल सात व्यक्ति थे. ");
INSERT INTO hincv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","याकोब के परिवार के लोग जो मिस्र देश में आ गए थे—जो उनके वंश में जन्मे थे. इनमें याकोब की बहुएं गिनी गयी नहीं थीं. ये सभी छियासठ व्यक्ति थे ");
INSERT INTO hincv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","योसेफ़ के पुत्र, जो मिस्र देश में जन्मे हुए थे वह दो थे. याकोब के पूरे परिवार के लोग जो मिस्र देश में आये थे, वे कुल सत्तर थे. ");
INSERT INTO hincv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","याकोब ने यहूदाह को पहले योसेफ़ के पास गोशेन के लिए मार्गदर्शन पाने के लिए भेजा. जब यहूदाह गोशेन प्रदेश में पहुंच गया, ");
INSERT INTO hincv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","तब योसेफ़ ने अपना रथ तैयार करवाया कि वह अपने पिता इस्राएल से भेंट करने गोशेन पहुंच जाएं. जैसे ही उनके पिता उनके पास आये, वह उनके गले लगकर बहुत देर तक रोते रहे. ");
INSERT INTO hincv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","फिर इस्राएल ने योसेफ़ से कहा, “अब मैं शांतिपूर्वक अपने प्राण त्याग सकता हूं, क्योंकि मैंने तुम्हें देख लिया है, कि तुम जीवित हो.” ");
INSERT INTO hincv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","योसेफ़ ने अपने भाइयों तथा अपने पिता के सभी लोगों से कहा, “मैं जाकर फ़रोह को बताता हूं, ‘कनान देश से मेरे भाई तथा मेरे पिता का परिवार यहां पहुंच चुका है. ");
INSERT INTO hincv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","वे सभी चरवाहे हैं; और पशु पालते हैं. वे अपने साथ पशु, भेड़-बकरी तथा अपनी पूरी संपत्ति लेकर आए हैं.’ ");
INSERT INTO hincv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","योसेफ़ ने अपने पिता एवं भाइयों से कहा कि अगर फ़रोह आप लोगों से पूछे, ‘आप लोग क्या करते हैं?’ ");
INSERT INTO hincv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","तो कहना कि हम चरवाहे हैं, और ‘हमारे पूर्वज यही काम करते थे.’ इससे आपके लिए गोशेन में रहना आसान हो जाएगा. क्योंकि मिस्र के लोग चरवाहों से नफ़रत करते हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","योसेफ़ ने जाकर फ़रोह को बताया, “मेरे पिता तथा मेरे भाई अपने सब भेड़-बकरी, पशु तथा अपनी पूरी संपत्ति लेकर कनान देश से आ चुके हैं तथा वे गोशेन देश में हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","योसेफ़ ने अपने पांच भाइयों को फ़रोह के सामने प्रस्तुत किया. ");
INSERT INTO hincv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फ़रोह ने उनके भाइयों से पूछा, “आप लोग क्या काम करते हैं?” उन्होंने फ़रोह से कहा, “हम हमारे पूर्वजों की ही तरह पशु पालते हैं. ");
INSERT INTO hincv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","अब इस देश में कुछ समय के लिये रहने आए हैं, क्योंकि कनान में भयंकर अकाल होने के कारण आपके दासों के पशुओं के लिए चारा नहीं है. तब कृपा कर हमें गोशेन में रहने की अनुमति दे दीजिए.” ");
INSERT INTO hincv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","फ़रोह ने योसेफ़ से कहा, “तुम्हारे पिता एवं तुम्हारे भाई तुम्हारे पास आए हैं, ");
INSERT INTO hincv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","पूरा मिस्र देश तुम्हारे लिए खुला है; अपने पिता एवं अपने भाइयों को गोशेन के सबसे अच्छे भाग में रहने की सुविधा दे दो. और भाइयों में से कोई समझदार हो तो उसे मेरे पशुओं की देखभाल की पूरी जवाबदारी दे दो.” ");
INSERT INTO hincv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","फिर योसेफ़ पिता याकोब को भी फ़रोह से मिलाने लाए. याकोब ने फ़रोह को आशीष दी. ");
INSERT INTO hincv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","फ़रोह ने याकोब से पूछा, “आपकी उम्र क्या है?” ");
INSERT INTO hincv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकोब ने फ़रोह को बताया “मेरी तीर्थ यात्रा के वर्ष एक सौ तीस रहे हैं. मेरी आयु बहुत छोटी और कष्टभरी रही है और वह मेरे पूर्वजों सी लंबी नहीं रही है!” ");
INSERT INTO hincv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","याकोब फ़रोह को आशीष देकर वहां से चले गये. ");
INSERT INTO hincv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","योसेफ़ ने अपने पिता एवं भाइयों को फ़रोह की आज्ञा अनुसार मिस्र में सबसे अच्छी जगह रामेसेस में ज़मीन दी. ");
INSERT INTO hincv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","योसेफ़ ने अपने पिता, अपने भाइयों तथा पिता के पूरे परिवार को उनके बच्चों की गिनती के अनुसार भोजन उपलब्ध कराया. ");
INSERT INTO hincv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","पूरे देश में अकाल के कारण भोजन की कमी थी. मिस्र देश तथा कनान देश अकाल के कारण भूखा पड़ा था. ");
INSERT INTO hincv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","मिस्र देश तथा कनान देश का सारा धन योसेफ़ ने फ़रोह के राजमहल में अनाज के बदले इकट्ठा कर लिया था. ");
INSERT INTO hincv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","जब लोगों के पास अनाज खरीदने के लिए रुपया नहीं था तब वह योसेफ़ के पास आकर बिनती करने लगे, “हमें खाने को भोजन दीजिए. हम आपकी आंखों के सामने क्यों मरें? हमारा रुपया सब खत्म हो गया है.” ");
INSERT INTO hincv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","योसेफ़ ने कहा, “यदि तुमारा रुपया खत्म हो गया हैं तो तुम अपने पशु हमें देते जाओ और हम तुम्हें उसके बदले अनाज देंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","इसलिये वे अपने पशु योसेफ़ को देने लगे; और योसेफ़ उन्हें उनके घोड़े, पशुओं, भेड़-बकरी तथा गधों के बदले में अनाज देने लगे. योसेफ़ ने उस वर्ष उनके समस्त पशुओं के बदले में उनकी भोजन की व्यवस्था की. ");
INSERT INTO hincv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","जब वह वर्ष खत्म हुआ तब अगले वर्ष वह योसेफ़ के पास आए और उनसे कहा, “स्वामी यह सच्चाई आपसे छुपी नहीं रह सकती कि हमारा सारा रुपया खर्च हो गया हैं और पशु भी आपके हो गये है; अब हमारा शरीर और हमारी ज़मीन ही बच गई है. ");
INSERT INTO hincv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","क्या हम और हमारी ज़मीन आपकी आंखों के सामने नाश हो जायेंगी? अब भोजन के बदले आप हमारी ज़मीन को ही खरीद लीजिए, और हम अपनी ज़मीन के साथ फ़रोह के दास बन जाएंगे. हमें सिर्फ बीज दे दीजिये कि हम नहीं मरें परंतु जीवित रहें कि हमारी भूमि निर्जन न हो.” ");
INSERT INTO hincv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","इस प्रकार योसेफ़ ने मिस्र देश की पूरी ज़मीन फ़रोह के लिये खरीद ली. सभी मिस्रवासियों ने अपनी भूमि बेच दी क्योंकि अकाल भयंकर था और ज़मीन फ़रोह की हो गई. ");
INSERT INTO hincv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","योसेफ़ ने मिस्र के एक छोर से दूसरे छोर तक लोगों को, दास बना दिया. ");
INSERT INTO hincv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","सिर्फ पुरोहितों की भूमि को नहीं खरीदा, क्योंकि उनको फ़रोह की ओर से निर्धारित भोजन मिलता था और वह उनके जीने के लिये पर्याप्‍त था, इसलिये उन्होंने अपनी ज़मीन नहीं बेची. ");
INSERT INTO hincv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","योसेफ़ ने लोगों से कहा, “मैंने फ़रोह के लिए आपको तथा आपकी भूमि को आज खरीद लिया है, अब आपके लिये यह बीज दिया है कि आप अपनी ज़मीन पर इस बीज को बोना और खेती करना. ");
INSERT INTO hincv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","और जब उपज आयेगी उसमें से फ़रोह को पांचवां भाग देना होगा और शेष चार भाग आपके होंगे; ज़मीन में बोने के बीज के लिये और आप, आपके परिवार और आपके बच्चों के भोजन के लिये होंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","तब लोगों ने कहा, “आपने हमारा जीवन बचा लिया; यदि हमारे स्वामी की दया हम पर बनी रहे और हम फ़रोह के दास बने रहेंगे.” ");
INSERT INTO hincv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","योसेफ़ ने जो नियम बनाया था कि उपज का पांचवां भाग फ़रोह को देना ज़रूरी है वह आज भी स्थापित है. सिर्फ पुरोहितों की भूमि फ़रोह की नहीं हुई. ");
INSERT INTO hincv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","इस्राएल मिस्र देश के गोशेन नामक जगह पर रह रहे थे, वहां वे फलते फूलते धन-संपत्ति अर्जित करते गये और संख्या में कई गुणा बढ़ते गये. ");
INSERT INTO hincv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","मिस्र में याकोब को सत्रह साल हो चुके थे, और वे एक सौ सैंतालीस वर्ष तक रहे. ");
INSERT INTO hincv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","जब इस्राएल मरने पर थे, उन्होंने अपने पुत्र योसेफ़ को पास बुलाया और कहा, “यदि तुम मुझसे प्रेम करते हो तो मेरी जांघ के नीचे अपना हाथ रखकर शपथ लो, कि तुम मुझसे करुणा और विश्वास का बर्ताव करोगे और मुझे मिस्र में नहीं दफ़नाओगे, ");
INSERT INTO hincv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","जब मैं चिर-निद्रा में अपने पूर्वजों से जा मिलूं, तब मुझे मिस्र देश से ले जाना और पूर्वजों के साथ उन्हीं के पास मुझे दफ़नाना.” योसेफ़ ने कहा, “मैं ऐसा ही करूंगा जैसा आपने कहा है.” ");
INSERT INTO hincv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","याकोब ने कहा, “मुझसे वायदा करो!” योसेफ़ ने उनसे वायदा किया और इस्राएल खाट के सिरहाने की ओर झुक गए. ");
INSERT INTO hincv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","कुछ दिन बाद योसेफ़ को बताया गया, “आपके पिता की तबियत ठीक नहीं है.” यह सुन योसेफ़ अपने दोनो पुत्रों; मनश्शेह तथा एफ्राईम को लेकर अपने पिता से मिलने निकल पड़े. ");
INSERT INTO hincv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","किसी ने याकोब को बता दिया, “योसेफ़ आपसे मिलने आ रहे हैं.” तब इस्राएल अपनी सारी शक्ति समेटकर खाट से उठकर बैठ गये. ");
INSERT INTO hincv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","और योसेफ़ से बात करने लगे और कहा, “कनान देश के लूज़ में सर्वशक्तिमान परमेश्वर ने मुझे दर्शन देकर आशीष दी. ");
INSERT INTO hincv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","और कहा, ‘मैं तुम्हें फलवंत करूंगा और तुझे राज्य-राज्य के समूह का मुखिया बनाऊंगा और यह देश तुम्हें और बाद में तुम्हारे वंश को सदाकाल के लिये दूंगा.’ ");
INSERT INTO hincv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“तुम्हारे ये दोनो पुत्र, जिनका जन्म मिस्र में मेरे आने से पहले हुआ है, वे मेरी संतान हैं; एफ्राईम तथा मनश्शेह मेरे कहलाएंगे, जैसे रियूबेन तथा शिमओन मेरे हैं. ");
INSERT INTO hincv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","किंतु तुम्हारी संतान, जो इन दोनों के बाद जन्मेगी, वह तुम्हारी कहलाएगी. वे अपने भाइयों के प्रदेशों के भीतर मीरास प्राप्‍त करेंगे. ");
INSERT INTO hincv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","जब मैं पद्दन से आ रहा था और एफ़राथा पहुंचने ही वाले थे कि राहेल की मृत्यु का दुःख मुझ पर आन पड़ा. मैंने उन्हें एफ़राथा के रास्ते अर्थात् बेथलेहेम में दफनाया.” ");
INSERT INTO hincv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","योसेफ़ के पुत्रों को देखकर इस्राएल ने पूछा, “कौन हैं ये?” ");
INSERT INTO hincv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","योसेफ़ ने अपने पिता से कहा, “ये मेरे पुत्र हैं, जो मुझे इस देश में परमेश्वर ने दिये.” तब याकोब ने कहा, “मेरे पास उन्हें लाओ, कि मैं उन्हें आशीष दूं.” ");
INSERT INTO hincv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","इस्राएल की आंखें उम्र के कारण कमजोर हो गयीं थीं कि वे देख नहीं सकते थे. योसेफ़ अपने पुत्रों को अपने पिता के पास ले गए. याकोब ने उन्हें चूमा और उन्हें गले लगाया. ");
INSERT INTO hincv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","योसेफ़ को देखते हुए इस्राएल ने कहा, “मैंने यह न सोचा था कि तुम्हें फिर से देख पाऊंगा, किंतु परमेश्वर ने मुझे तुम्हारी संतान तक देखने का सौभाग्य दिया.” ");
INSERT INTO hincv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","योसेफ़ ने अपने पुत्रों को अपने पिता की गोद से उतारा और झुककर मुंह के बल प्रणाम किया. ");
INSERT INTO hincv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","फिर योसेफ़ दोनों को इस्राएल के नजदीक ले गये; दाएं हाथ से वह एफ्राईम तथा बाएं हाथ से मनश्शेह को पकड़े हुए थे. एफ्राईम इस्राएल के बाईं ओर था तथा मनश्शेह इस्राएल के दाईं ओर. ");
INSERT INTO hincv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","किंतु इस्राएल ने अपना दायां हाथ छोटे बेटे एफ्राईम के सिर पर तथा अपना बायां हाथ मनश्शेह के सिर पर रखा. याकोब ने जानबूझकर ऐसा किया. ");
INSERT INTO hincv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","योसेफ़ को आशीष देते हुए इस्राएल ने कहा, “परमेश्वर, जिसके सम्मुख मेरे पूर्वज अब्राहाम तथा यित्सहाक चलते थे, वही परमेश्वर, जीवन भर आज तक मेरा चरवाहा बनकर रहे हैं, ");
INSERT INTO hincv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","वह स्वर्गदूत, जिसने हर पल मेरी रक्षा की है, वही दोनों बच्चों को आशीषित करें. और ये दोनों मेरे, मेरे पिता अब्राहाम तथा मेरे पिता यित्सहाक, के नाम को ऊंचा करें. और पृथ्वी में बढ़ते जाये.” ");
INSERT INTO hincv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","जब योसेफ़ ने देखा कि उनके पिता ने अपना दायां हाथ एफ्राईम के सिर रखा है तो उन्हें अच्छा नहीं लगा वे अपने पिता का दायां हाथ पकड़कर एफ्राईम के सिर पर से हटाकर मनश्शेह के सिर पर रखने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","योसेफ़ ने अपने पिता से कहा, “वह नहीं, पिताजी, बड़ा बेटा यह है; आप अपना दायां हाथ इस पर रख दीजिए.” ");
INSERT INTO hincv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","किंतु उनके पिता ने कहा, “मुझे पता है मेरे पुत्र; यह भी महान बन जाएगा, और बढ़ेगा तो भी उसका छोटा भाई उससे महान हो जाएगा तथा उससे कई जातियां निकलेंगी.” ");
INSERT INTO hincv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","उस दिन इस्राएल ने उन्हें आशीष दी और कहा, “इस्राएल के लोग तुम्हारा नाम लेकर ऐसे कहेंगे: ‘परमेश्वर तुम्हें एफ्राईम तथा मनश्शेह के समान बना दें.’ ” यह कहते हुए याकोब ने एफ्राईम को मनश्शेह से अधिक श्रेष्ठ स्थान दे दिया. ");
INSERT INTO hincv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","फिर इस्राएल ने योसेफ़ से कहा, “सुनो, अब मेरी मृत्यु का समय आ गया है, लेकिन परमेश्वर तुम्हारे साथ साथ रहेंगे और तुम्हें अपने पूर्वजों के देश में वापस ले जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","मैं तुम्हें तुम्हारे भाइयों से बढ़कर हिस्सा ज्यादा दे रहा हूं—वह भाग, जो मैंने अमोरियों से अपनी तलवार एवं धनुष के द्वारा पाया था.” ");
INSERT INTO hincv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","तब याकोब ने अपने बेटों को बुलाकर उनसे कहा: “तुम सब एक साथ आओ, ताकि तुम्हें बता सकूं कि तुम्हारे साथ अब क्या-क्या होगा. ");
INSERT INTO hincv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“याकोब के पुत्रो, सुनो तथा अपने पिता इस्राएल की बातों पर ध्यान दो. ");
INSERT INTO hincv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“रियूबेन, तुम तो मेरे बड़े बेटे, मेरे बल एवं मेरे पौरुष का फल हो, प्रतिष्ठा और शक्ति का उत्तम भाग तुम ही हो. ");
INSERT INTO hincv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","जो अशांत पानी के समान उग्र हैं, इसलिये तुम महान न बनोगे, क्योंकि तुमने अपने पिता के बिछौने को अशुद्ध किया. ");
INSERT INTO hincv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“शिमओन तथा लेवी भाई-भाई हैं; उनकी तलवारें हिंसा का साधन हैं. ");
INSERT INTO hincv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ऐसा कभी न हो कि मुझे उनकी सभा में जाना पड़े, मैं उनकी सभाओं से न जुडूं, क्योंकि गुस्से में उन्होंने मनुष्यों को मार डाला तथा सनक में उन्होंने बैलों की नसें काट दी. ");
INSERT INTO hincv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","शापित है उनका क्रोध जो भीषण हैं और उनका ऐसा गुस्सा, जो निर्दयी और क्रूर है! मैं उन्हें याकोब में बांट दूंगा. और उन्हें इस्राएल में तितर-बितर कर दूंगा. ");
INSERT INTO hincv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“यहूदाह, तुम्हारे भाई तुम्हारी प्रशंसा करेंगे; तुम्हारा हाथ तुम्हारे शत्रुओं की गर्दन पर पड़ेगा; तुम्हारे पिता की अन्य संतान तुम्हारे सम्मान में झुक जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदाह तो जवान सिंह के समान है; हे मेरे पुत्र, तुम अपने शिकार पर खड़े शेर के समान हो जो आराम करने के लिए लेटता है, किसमें उसे छेड़ने का साहस है? ");
INSERT INTO hincv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","यहूदाह से राजदंड कभी भी अलग न होगा और न ही उसके वंश से शासन का राजदंड, दूर होगा, जब तक वह न आ जाये और राज्य-राज्य के लोग उसके अधीन रहेंगे. ");
INSERT INTO hincv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","अपने गधे को दाखलता से बांध देता है, तथा गधे के बच्‍चे को उत्तम दाखलता पर बांधेगा; उसने अपना वस्त्र दाखमधु में धोया है, तथा बाहरी वस्त्र दाखरस में धोया है. ");
INSERT INTO hincv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","उसकी आंखें दाखमधु से चमकीली तथा, उसके दांत दूध से भी अधिक सफेद होंगे. ");
INSERT INTO hincv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“ज़ेबुलून सागर के किनारे रहेगा और इसका समुद्री तट जहाजों के लिए सुरक्षित होगा, और उसकी सीमा सीदोन देश तक फैल जायेगी. ");
INSERT INTO hincv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“इस्साखार एक बलवंत गधा है, वह पशुओं के बाड़े के बीच रहता है. ");
INSERT INTO hincv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","जब उसने देखा कि आराम करने की जगह ठीक है, कि भूमि सुखदाई है, तब उसने अपने कंधे को बोझ उठाने के लिए झुका दिया और वह बेगार का दास बन जायेगा. ");
INSERT INTO hincv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“दान अपने लोगों का न्याय इस्राएल के एक गोत्र जैसा करेगा. ");
INSERT INTO hincv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान मार्ग का एक सांप होगा, पथ पर एक सर्प! वह घोड़े की एड़ी को डसता है, और सवार अचानक गिर जाता है. ");
INSERT INTO hincv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“हे याहवेह, मैं आपके उद्धार की बाट जोहता हूं. ");
INSERT INTO hincv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“गाद पर छापामार छापा मारेंगे, किंतु वह भी उनकी एड़ी पर मारेगा. ");
INSERT INTO hincv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“आशेर का अन्‍न बहुत उत्तम होगा और वह राजसी भोजन उपलब्ध कराएगा. ");
INSERT INTO hincv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“नफताली छोड़ी हुई हिरणी के समान है जो सुंदर बच्चों को जन्म देती है. ");
INSERT INTO hincv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“योसेफ़ तो फल से भरी एक शाखा है जो सोते के पास लगी हुई फलवंत लता की एक शाखा है जो बाड़े के सहारे चढ़ी हैं. ");
INSERT INTO hincv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","धनुष चलानेवाले ने धनुष चलाया और तीर छोड़ा और लगकर दर्द हुआ. ");
INSERT INTO hincv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","परंतु उसका धनुष दृढ़ रहा, उसकी बांहें मजबूत रहीं, यह याकोब के सर्वशक्तिमान परमेश्वर की ओर से था, जो इस्राएल के चरवाहे तथा चट्टान हैं. ");
INSERT INTO hincv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","तुम्हारे पिता के परमेश्वर की ओर से, जो तुम्हारे सहायक हैं तथा उस सर्वशक्तिमान से जो स्वर्गीय आशीषों से तुम्हें आशीषित करेंगे, वे आशीषें, जो नीचे गहराइयों से आती हैं, स्तनों तथा गर्भ की आशीषें देगा. ");
INSERT INTO hincv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","तुम्हारे पिता की आशीषें तो मेरे पूर्वजों के पहाड़ों से बढ़कर हैं ये अनंत पर्वतों से संबंधित आशीषों से बढ़कर हैं. ये ही आशीषें योसेफ़ पर प्रकट होकर उसके सिर का मुकुट बनें, जो सब भाइयों से प्रतिष्ठित हुआ है. ");
INSERT INTO hincv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“बिन्यामिन एक क्रूर भेड़िया है; सवेरे वह अहेर का सेवन करता है, शाम को वह लूट सामग्री बांटा करता है.” ");
INSERT INTO hincv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ये सभी इस्राएल के बारह गोत्र हैं उनके पिता ने उनके बारे में तब कहा जब वह उन्हें आशीष दे रहे थे, और उनमें से एक-एक को इन्हीं वचनों से आशीष दी. ");
INSERT INTO hincv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","तब इस्राएल ने कहा, “मुझे मेरे पूर्वजों की उसी गुफ़ा में दफनाना, जो एफ्रोन हित्ती के खेत में है, ");
INSERT INTO hincv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","कनान देश में उस कब्रस्थान में, जो माखपेलाह के खेत में, ममरे के पास है, जिसे अब्राहाम ने हित्ती एफ्रोन से खरीदा था. ");
INSERT INTO hincv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","वहां उन्होंने अब्राहाम तथा उनकी पत्नी साराह को दफनाया था, वहीं उन्होंने यित्सहाक तथा उनकी पत्नी रेबेकाह को दफनाया तथा वहीं मैंने लियाह को भी दफनाया है; ");
INSERT INTO hincv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","वह खेत गुफा सहित हित्तियों से खरीदा है.” ");
INSERT INTO hincv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","जब याकोब अपने पुत्रों को ये आदेश दे चुके, तब उन्होंने अपने पैर अपने बिछौने पर कर लिए तथा आखिरी सांस ली, वे अपने पूर्वजों से जा मिले. ");
INSERT INTO hincv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","योसेफ़ अपने पिता से लिपट कर बहुत रोये. ");
INSERT INTO hincv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","योसेफ़ ने अपने सेवकों से, जो वैद्य थे उनसे कहा कि वे पिता के शव में सुगंध द्रव्य भर दें. वैद्यों ने इस्राएल के शव का संलेपन किया. ");
INSERT INTO hincv_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","इस काम में चालीस दिन लग जाते थे. मिस्रवासियों ने याकोब के लिए सत्तर दिन तक शोक मनाया. ");
INSERT INTO hincv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","जब शोक के दिन पूरे हुए तब योसेफ़ ने जाकर फ़रोह के परिवार से कहा, “यदि आपका अनुग्रह मुझ पर है तो फ़रोह से कहिये, ");
INSERT INTO hincv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘मेरे पिता ने मरने से पहले मुझसे यह शपथ करवाई: उन्होंने कहा, मैं मरने पर हूं मुझे कनान देश में उस कब्र में दफनाना, जो मैंने अपने लिये खोदी है, इसलिये मुझे अपने पिता के शव को कनान देश ले जाने की आज्ञा दें ताकि मैं वहां जाकर अपने पिता को दफनाकर लौट आऊं.’ ” ");
INSERT INTO hincv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","फ़रोह ने कहा, “जाकर अपने पिता को जैसी उन्होंने तुमसे शपथ करवाई थी, वैसे दफनाकर आओ.” ");
INSERT INTO hincv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","इसलिये योसेफ़ अपने पिता के शव को लेकर रवाना हुए और फ़रोह के सब सेवक उनके साथ गये. उनके साथ उनके परिवार के तथा मिस्र देश के सारे प्रधान थे. ");
INSERT INTO hincv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","योसेफ़ का पूरा परिवार, उनके भाई तथा उनके पिता का परिवार भी था. वे गोशेन में बच्चों और अपने भेड़-बकरी तथा पशुओं को छोड़कर गये. ");
INSERT INTO hincv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","उनके साथ घोड़े तथा रथ और लोगों की बड़ी भीड़ थी. ");
INSERT INTO hincv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","जब वे अताद के खलिहान तक जो यरदन के पार है, पहुंचे; तब वे बड़े दुःखी हुए और रोने लगे; उन्होंने वहां अपने पिता के लिए सात दिन का शोक रखा. ");
INSERT INTO hincv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","जब कनान के लोगों ने अताद के खलिहान में यह विलाप देखा तो कहा, “मिस्रवासियों के लिए यह वास्तव में गहरा शोक है.” इसलिये यरदन पार उस स्थान का नाम अबेल-मिस्रईम रखा गया. ");
INSERT INTO hincv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","इस प्रकार याकोब के पुत्रों ने उनके लिए ठीक वैसा ही किया, जैसा याकोब ने कहा था: ");
INSERT INTO hincv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","याकोब के पुत्रों ने उन्हें कनान देश में ममरे के पास माखपेलाह के खेत की गुफा में दफना दिया, जो अब्राहाम ने कब्रस्थान के लिए हित्ती एफ्रोन से खरीदी थी. ");
INSERT INTO hincv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","अपने पिता को दफनाने के बाद योसेफ़ मिस्र देश लौट गए. उनके साथ उनके भाई भी लौट गए तथा वे सब भी, जो उनके साथ यहां आए थे. ");
INSERT INTO hincv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","जब योसेफ़ के भाइयों ने सोचा, “हमारे पिता का निधन हो चुका है, अब यदि योसेफ़ हमसे नफरत करके पिछली बातों का बदला लेगा तो हम क्या करेंगे?” ");
INSERT INTO hincv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","इसलिये उन्होंने योसेफ़ से कहा: “पिता ने हमसे कहा था कि ");
INSERT INTO hincv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘योसेफ़ से कहना कि कृपा कर अपने भाइयों के अत्याचार और गलतियों को माफ कर दो जो उन्होंने तुमसे किए थे,’ इसलिये अब, कृपा कर अपने पिता के परमेश्वर के नाम से हमारी गलतियों को माफ कर दो.” योसेफ़ उनकी यह बात सुनकर रोने लगे. ");
INSERT INTO hincv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","तब उनके भाई भी रोने लगे और योसेफ़ के सामने झुककर कहने लगे, “हम सभी आपके दास हैं.” ");
INSERT INTO hincv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","किंतु योसेफ़ ने उनसे कहा, “आप लोग मत डरो. क्या मैं कोई परमेश्वर हूं? ");
INSERT INTO hincv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","मैं जानता हूं कि आप लोगों ने भले ही मेरी हानि की योजना बनाई हो, लेकिन परमेश्वर ने उसे अच्छे के लिये किया कि बहुतों का जीवन बचा लिया गया! ");
INSERT INTO hincv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","इसलिये भयभीत न हो; मैं स्वयं तुम्हें और तुम्हारे बच्चों को भोजन दूंगा.” इस प्रकार योसेफ़ ने अपने भाइयों को सांत्वना दी और उनसे कोमलता से बातें की. ");
INSERT INTO hincv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","योसेफ़ मिस्र में अपने पिता के पूरे परिवार के साथ रहे. योसेफ़ की उम्र एक सौ दस वर्ष हुई. ");
INSERT INTO hincv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","योसेफ़ ने एफ्राईम की तीसरी पीढ़ी भी देखी तथा मनश्शेह के पोते, जो माखीर के पुत्र थे, उन्हें भी जन्म के बाद योसेफ़ के घुटनों पर रखा गया. ");
INSERT INTO hincv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","योसेफ़ ने अपने भाइयों को कहा, “मैं अब मरने पर हूं, लेकिन परमेश्वर अवश्य आप सब की रक्षा करेंगे और वही तुम्हें इस देश से उस देश में ले जाएंगे, जिसकी शपथ उन्होंने अब्राहाम, यित्सहाक तथा याकोब से की थी.” ");
INSERT INTO hincv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","तब योसेफ़ ने इस्राएल के पुत्रों से शपथ ली, “परमेश्वर आप सभी की मदद के लिये आएंगे और तब आप लोग मेरी हड्डियों को यहां से लेकर जाना.” ");
INSERT INTO hincv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","योसेफ़ की मृत्यु एक सौ दस वर्ष में हुई. उनके शव को सुगंध द्रव्य से भरा गया और उन्हें मिस्र देश में ही एक संदूक में रख दिया गया.");
INSERT INTO hincv_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","याकोब के साथ मिस्र में अपने-अपने घराने के साथ आकर रहनेवाले इस्राएलियों के नाम निम्न लिखित हैं: ");
INSERT INTO hincv_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रियूबेन, शिमओन, लेवी और यहूदाह; ");
INSERT INTO hincv_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साखार, ज़ेबुलून तथा बिन्यामिन; ");
INSERT INTO hincv_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान एवं नफताली; गाद एवं आशेर. ");
INSERT INTO hincv_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","याकोब के वंश में सत्तर जन थे, योसेफ़ पहले ही मिस्र में थे. ");
INSERT INTO hincv_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","वहां योसेफ़ और उनके सभी भाई तथा पूरी पीढ़ी के लोगों की मृत्यु हो गई थी. ");
INSERT INTO hincv_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","इस्राएली बहुत फलवंत थे और वे बढ़ते चले गए, और बहुत सामर्थ्यी होकर पूरे देश में भर गए. ");
INSERT INTO hincv_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","फिर मिस्र में एक नया राजा बना, जो योसेफ़ को नहीं जानता था. ");
INSERT INTO hincv_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","उसने अपनी प्रजा से यह कहा, “इस्राएल के लोग संख्या में और बल में हमसे अधिक हैं. ");
INSERT INTO hincv_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","इसलिये हम समझदारी से रहें, ये लोग तो बढ़ते जाएंगे! ऐसा न हो कि युद्ध की स्थिति में हमारे शत्रुओं के साथ मिलकर, हमसे ही युद्ध करने लगें और देश छोड़कर चले जाएं.” ");
INSERT INTO hincv_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","इस विचार से उन्होंने इस्राएलियों को कड़ी मेहनत कराने के उद्देश्य से ठेकेदार नियुक्त कर दिए. तब फ़रोह के लिए पिथोम तथा रामेसेस नामक भण्डारगृह नगरों को बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","जितना इस्राएलियों को कष्ट दिया गया, उतने ही वे बढ़ते और देश में फैलते गए, इसलिये इस्राएली मिस्रवासियों के लिए डर का कारण बन गये. ");
INSERT INTO hincv_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","मिस्री इस्राएलियों से कठोर मेहनत कराते रहे. ");
INSERT INTO hincv_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","इस प्रकार मिस्रियों ने इस्राएलियों के जीवन को दुःखपूर्ण कर दिया. उन्हें गारे तथा ईंट के लिए कड़ी मेहनत करनी पड़ती थी. सभी कामों में उन्हें दुःखी कर सताया जाता था. ");
INSERT INTO hincv_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","यह देख मिस्र देश के राजा ने इब्री धायों को बुलवाया. इनमें एक का नाम शिफ्राह तथा दूसरी का पुआह था. ");
INSERT INTO hincv_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","राजा ने उनसे कहा, “इब्री स्त्रियों का प्रसव कराते समय जैसे ही तुम्हें यह पता चली कि लड़का है, तुम उसकी हत्या कर देना; किंतु यदि वह पुत्री हो, तो उसे जीवित रहने देना.” ");
INSERT INTO hincv_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","किंतु धायें परमेश्वर का भय मानने वालीं थीं. इस कारण उन्होंने राजा की बात नहीं मानी; वे पुत्रों को जीवित छोड़ती चली गईं. ");
INSERT INTO hincv_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","इसलिये राजा ने धायों को बुलवाया और उनसे पूछा, “तुम ऐसा क्यों कर रही हो? क्यों लड़कों को जीवित छोड़ रही हो?” ");
INSERT INTO hincv_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","उन्होंने फ़रोह को उत्तर दिया, “इब्री स्त्रियां मिस्री स्त्रियों के समान नहीं होती; वे हृष्ट-पुष्ट होती हैं, इसलिये हमारे पहुंचने से पहले ही प्रसव कर चुकी होती हैं.” ");
INSERT INTO hincv_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","इस कारण परमेश्वर की दया उन धायों पर बनी रही, इस्राएली बढ़ते और शक्तिशाली होते गए. ");
INSERT INTO hincv_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","धायों के मन में परमेश्वर का भय था, इस कारण परमेश्वर ने उनको अपने परिवार दिये. ");
INSERT INTO hincv_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","फिर फ़रोह ने सब लोगों से कहा, “हर नवजात पुत्र को, जो तुम्हारे आस-पास जन्म लेता है, उन्हें नील नदी में फेंक दिया करना, किंतु पुत्री को जीवित रहने देना.” ");
INSERT INTO hincv_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","लेवी गोत्र के एक व्यक्ति ने लेवी गोत्र की एक कन्या से विवाह किया. ");
INSERT INTO hincv_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","उस कन्या ने गर्भधारण किया और एक बच्‍चे को जन्म दिया, और वह बहुत सुंदर था, उसने उसे तीन महीने तक छिपाए रखा. ");
INSERT INTO hincv_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","किंतु जब बच्‍चे को छिपाए रखना उसके लिए मुश्किल हो गया तब उसने एक टोकरी बनाई और उस पर तारकोल और पीच का लेप किया. उसने बच्‍चे को टोकरी में रख उस टोकरी को नील नदी के किनारे लंबी घासों के बीच में रख दिया. ");
INSERT INTO hincv_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","उस बच्‍चे की बहन बच्‍चे के साथ क्या होगा यह देखने के लिए दूर खड़ी हुई थी. ");
INSERT INTO hincv_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","फ़रोह की पुत्री नील नदी में स्‍नान करने आई और उसकी दासियां नदी के किनारे चल रही थीं. फ़रोह की पुत्री की नजर उस टोकरी पर पड़ी. उसने अपनी दासियों को वह टोकरी लाने को कहा. ");
INSERT INTO hincv_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","उस टोकरी को खोलने पर उसकी नजर उस बच्‍चे पर पड़ी, जो उस समय रो रहा था. बच्‍चे पर उसको दया आई और वह समझ गई कि यह किसी इब्री का ही बच्चा है. ");
INSERT INTO hincv_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","उस बच्‍चे की बहन ने फ़रोह की पुत्री से पूछा, “क्या मैं जाकर इसके लिए इब्री धायों में से किसी को ले आऊं जो इसे दूध पिला सके?” ");
INSERT INTO hincv_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फ़रोह की पुत्री ने उससे कहा, “जाओ!” तब वह लड़की जाकर बच्‍चे की मां को ही बुला लाई. ");
INSERT INTO hincv_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फ़रोह की पुत्री ने उससे कहा, “इस बच्‍चे को ले जाओ और इसका पालन पोषण करो. इसके लिए मैं तुम्हें मजदूरी दूंगी.” तब वह स्त्री उस बच्‍चे को ले गई और उसका पालन पोषण किया. ");
INSERT INTO hincv_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","जब बच्चा बड़ा हो गया तब वह बच्‍चे को फ़रोह की पुत्री के पास ले गई और फ़रोह की पुत्री ने उसे अपना पुत्र मान लिया. उसने उसका नाम मोशेह रखा. उसका मतलब था, “मैंने उसे जल में से पाया है.” ");
INSERT INTO hincv_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","जब मोशेह जवान हुए, तब वह अपने लोगों से मिलने उनके पास गए तो देखा कि वे कड़ी मेहनत कर रहे थे. उसी समय उन्होंने देखा कि एक मिस्री किसी इब्री को मार रहा था. ");
INSERT INTO hincv_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","इसलिये मोशेह ने उस मिस्री को मार दिया और उसे रेत में छिपा दिया. ");
INSERT INTO hincv_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","अगले दिन मोशेह ने देखा कि दो इब्री आपस में लड़ रहे हैं. इसलिये मोशेह ने उनसे पूछा, “क्यों आपस में लड़ रहे हो?” ");
INSERT INTO hincv_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","उस व्यक्ति ने मोशेह को जवाब दिया, “किसने तुम्हें हम पर राजा और न्याय करनेवाला ठहराया है? कहीं तुम्हारा मतलब कल उस मिस्री जैसे मेरी भी हत्या का तो नहीं है?” यह सुनकर मोशेह डर गए और उन्होंने सोचा, “अब यह भेद खुल चुका है.” ");
INSERT INTO hincv_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","जब फ़रोह को यह मालूम हुआ, तब उसने मोशेह की हत्या करने को सोचा, किंतु मोशेह फ़रोह के सामने से भागकर मिदियान देश में रहने लगे, वहां एक कुंआ था. ");
INSERT INTO hincv_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","मिदियान के पुरोहित की सात पुत्रियां थीं. वे उस कुएं में जल भरने आईं तथा उन्होंने अपने पिता की भेड़-बकरियों के लिए नांदों में जल भरा. ");
INSERT INTO hincv_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","तभी कुछ चरवाहे आए और उन कन्याओं को वहां से भगा दिया; तब मोशेह वहां आए और उन कन्याओं का बचाव किया तथा उनकी भेड़-बकरियों को जल पिलाया. ");
INSERT INTO hincv_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","जब वे घर लौटीं, तो उनके पिता रियुएल ने उनसे पूछा, “आज इतनी जल्दी कैसे घर लौट आई हो?” ");
INSERT INTO hincv_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","उन्होंने उत्तर दिया, “एक मिस्री ने उन चरवाहों से हमारी रक्षा की. यही नहीं, उसने कुएं से जल निकालकर हमें और हमारी भेड़-बकरियों को भी पिलाया.” ");
INSERT INTO hincv_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","रियुएल ने अपनी पुत्रियों से पूछा, “वह व्यक्ति कहां है? तुम उसे वहीं क्यों छोड़ आई? उसे भोजन के लिए बुला लाओ!” ");
INSERT INTO hincv_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","मोशेह उनके साथ रहने के लिए तैयार हो गए. रियुएल ने अपनी पुत्री ज़ीप्पोराह का विवाह मोशेह के साथ कर दिया. ");
INSERT INTO hincv_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","उन्होंने एक पुत्र को जन्म दिया. मोशेह ने उसका नाम गेरशोम रखा, उसका मतलब था, “मैं परदेश में एक अजनबी हूं.” ");
INSERT INTO hincv_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","उस लंबे समयकाल के बाद मिस्र देश के राजा की मृत्यु हो गई. इस्राएली अपने दासत्व में कराह रहे थे और दुहाई दे रहे थे. वे सहायता की गुहार कर रहे थे और उनके दासत्व की यह गुहार परमेश्वर तक पहुंची. ");
INSERT INTO hincv_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","परमेश्वर ने उनकी कराहट सुनी, और अब्राहाम, यित्सहाक तथा याकोब के साथ की गई अपनी वाचा को याद किया. ");
INSERT INTO hincv_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","परमेश्वर ने इस्राएल की ओर दृष्टि की तथा उनकी स्थिति पर ध्यान दिया. ");
INSERT INTO hincv_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","मोशेह अपने ससुर, मिदियान के पुरोहित येथ्रो की भेड़-बकरियां चराते हुए निर्जन क्षेत्र के पश्चिम में परमेश्वर के पर्वत होरेब पर पहुंच गए. ");
INSERT INTO hincv_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","वहां उन झाड़ियों के बीच में से आग की लौ में याहवेह के दूत ने उनको दर्शन दिया, उन्होंने देखा कि झाड़ी जल रही थी, पर भस्म नहीं होती. ");
INSERT INTO hincv_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","इसलिये मोशेह ने सोचा, “मैं जाकर जलती हुई झाड़ी को देखूं कि झाड़ी जलकर भस्म क्यों नहीं होती.” ");
INSERT INTO hincv_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","जब याहवेह ने यह देखा कि मोशेह यह देखने आगे बढ़ रहे हैं, परमेश्वर ने उस झाड़ी से उन्हें बुलाया, “मोशेह, मोशेह!” उन्होंने उत्तर दिया, “कहिए प्रभु.” ");
INSERT INTO hincv_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","याहवेह ने कहा, “पास न आओ, अपनी पैरों से जूते उतार दो, क्योंकि यह स्थान, जिस पर तुम खड़े हो, पवित्र है.” ");
INSERT INTO hincv_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","याहवेह ने यह कहा, “मैं ही तुम्हारे पूर्वजों के पिता अर्थात् अब्राहाम का, यित्सहाक तथा याकोब का परमेश्वर हूं.” यह सुन मोशेह ने अपना मुंह छिपा लिया, क्योंकि वह परमेश्वर की ओर देखने से डरता था. ");
INSERT INTO hincv_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","याहवेह परमेश्वर ने मोशेह से कहा, “मिस्र देश में मेरे लोगों की हालत मैंने देखी है; उनके कष्टकर मेहनत कराने वालों के कारण उनका रोना मैंने सुना है और उनके कष्ट को जानता हूं, ");
INSERT INTO hincv_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","इसलिये अब मैं उन्हें मिस्रियों के अधिकार से छुड़ाने उतर आया हूं, ताकि उन्हें उस देश से निकालकर एक उत्तम देश में ले जाऊं, जहां दूध एवं मधु बहता है, जो कनानियों, हित्तियों, अमोरियों, परिज्ज़ियों, हिव्वियों तथा यबूसियों का देश है. ");
INSERT INTO hincv_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","अब सुन लो: इस्राएलियों की प्रार्थना मुझ तक पहुंची है; इसके अलावा मिस्रियों द्वारा उन पर किए जा रहे अत्याचार भी मैंने देख लिए हैं. ");
INSERT INTO hincv_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","इसलिये अब मैं तुम्हें फ़रोह के पास भेजूंगा कि तुम मेरी प्रजा इस्राएलियों को मिस्र देश से निकाल लाए.” ");
INSERT INTO hincv_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","किंतु मोशेह ने परमेश्वर से कहा, “मैं कौन हूं जो फ़रोह के पास जाऊं और इस्राएलियों को मिस्र देश से निकालूं?” ");
INSERT INTO hincv_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","किंतु परमेश्वर ने मोशेह से कहा, “मैं तुम्हारे साथ साथ रहूंगा, तथा इस बात का सबूत स्वयं मैं हूं, जब तुम मेरी प्रजा को मिस्र देश से निकाल चुके होंगे, तब तुम इसी पर्वत पर परमेश्वर की आराधना करोगे.” ");
INSERT INTO hincv_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","यह सुन मोशेह ने परमेश्वर को उत्तर दिया, “यदि मैं इस्राएलियों के पास जाकर उनसे कहूं, ‘तुम्हारे ही पूर्वजों के परमेश्वर ने मुझे तुम्हारे पास भेजा है.’ और वे मुझसे पूछें, ‘क्या है उस परमेश्वर का नाम?’ तो मैं उन्हें क्या नाम बताऊं?” ");
INSERT INTO hincv_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","परमेश्वर ने मोशेह को उत्तर दिया, “मैं वही हूं, जो मैं हूं.” परमेश्वर ने आगे यह कहा, “तुम्हें इस्राएलियों से यह कहना होगा: जिसका नाम ‘मैं हूं है, उन्हीं ने मुझे भेजा है.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","फिर परमेश्वर ने मोशेह से कहा, “तुम इस्राएलियों से यह कहना ‘याहवेह, तुम्हारे पूर्वजों के परमेश्वर, अब्राहाम, यित्सहाक तथा याकोब के परमेश्वर ही ने मुझे तुम्हारे पास भेजा है.’ “यही मेरा स्थिर नाम है, सब पीढ़ी से पीढ़ी तक स्मरण रखने का मेरा नाम यही है. ");
INSERT INTO hincv_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“अब तुम जाओ और इस्राएलियों से कहो: ‘याहवेह परमेश्वर जो तुम्हारे पूर्वजों के परमेश्वर अब्राहाम, यित्सहाक तथा याकोब के परमेश्वर जो मुझ पर प्रकट हुए और मुझसे कहा कि मैंने तुम पर नजर रखी है, और मिस्र देश में तुम्हारे साथ जो कुछ किया गया है उसको मैंने देखा है. ");
INSERT INTO hincv_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","इसलिये मैंने यह वायदा किया कि मैं तुम्हें मिस्र देश में हो रहे कष्ट से बाहर निकालूंगा और कनानियों, हित्तियों, अमोरियों, परिज्ज़ीर, हिव्वियों तथा यबूसियों के देश में ले आऊंगा, जहां दूध एवं मधु की धारा बहती है.’ ");
INSERT INTO hincv_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“इस्राएल के प्रधान तुम्हारी बातों को सुनेंगे. तब तुम इस्राएल के प्रधानों के साथ मिस्र देश के राजा के सामने जाना और उससे कहना कि याहवेह, जो इब्रियों के परमेश्वर हैं, हम पर प्रकट हुए हैं. अब हमें तीन दिन की यात्रा की दूरी तक निर्जन प्रदेश में जाने दे, ताकि हम याहवेह को, जो हमारे परमेश्वर हैं, बलि अर्पित कर सकें; ");
INSERT INTO hincv_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","लेकिन मुझे मालूम है कि मिस्र देश का राजा तुम्हें तब तक जाने नहीं देगा, जब तक उसे एक शक्तिशाली हाथ मजबूर न करे. ");
INSERT INTO hincv_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","इसलिये मैं अब अपना हाथ बढ़ाकर मिस्र देश में अलग-अलग तरीक़ों के चमत्कारी कार्य करके उन पर वार करूंगा, तब ही वे तुम्हें जाने देंगे. ");
INSERT INTO hincv_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“मैं अपनी इस प्रजा को मिस्रियों से अनुग्रहित करवाऊंगा; जब तुम वहां से निकलोगे, तुम खाली हाथ न निकलोगे. ");
INSERT INTO hincv_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","हर एक इब्री स्त्री अपने पास रह रहे मिस्री पड़ोसी स्त्री से सोने, चांदी के जेवर तथा वस्त्र मांगकर अपने पुत्र-पुत्रियों को पहना दे. इस प्रकार तुम मिस्रियों को लूट लेना.” ");
INSERT INTO hincv_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","यह सुन मोशेह ने पूछा, “क्या होगा जब वे मेरी बात का न विश्वास करें और न मानें, और कहें, ‘यह असंभव है कि याहवेह तुम पर प्रकट हुए हों?’ ” ");
INSERT INTO hincv_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","याहवेह ने उन्हें उत्तर दिया, “तुम्हारे हाथ में क्या है?” मोशेह ने उत्तर दिया, “एक लाठी.” ");
INSERT INTO hincv_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","याहवेह ने कहा, “उसे भूमि पर डाल दो!” तब मोशेह ने उसे भूमि पर डाल दी. वह लाठी सांप बन गई, मोशेह डरकर दूर चले गए. ");
INSERT INTO hincv_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","याहवेह ने मोशेह से कहा, “अपना हाथ बढ़ाकर उसकी पूंछ पकड़ लो!” तब मोशेह ने अपना हाथ बढ़ाकर उसे पकड़ लिया और वह उनके हाथ में आते ही लाठी बन गई! ");
INSERT INTO hincv_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","याहवेह ने कहा, “यह देखकर वे विश्वास करेंगे कि तुम्हारे पूर्वजों के परमेश्वर, अब्राहाम, यित्सहाक तथा याकोब के परमेश्वर ही, तुम पर प्रकट हुए हैं.” ");
INSERT INTO hincv_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","फिर याहवेह ने मोशेह से दुबारा कहा “अब अपना हाथ वस्त्र के भीतर अपनी छाती पर रखो.” मोशेह ने अपना हाथ अपनी छाती पर रखकर बाहर निकाला, तुरंत उनका हाथ कुष्ठ के कारण हिम जैसा श्वेत हो गया. ");
INSERT INTO hincv_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","तब याहवेह ने उनसे कहा, “अपना हाथ वापस अपनी छाती पर रखो!” मोशेह ने अपना हाथ वापस अपनी छाती पर रखा; और जब उन्होंने अपना हाथ छाती से बाहर निकाला, वह वापस पहले जैसा सही हो गया. ");
INSERT INTO hincv_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“यदि वे तुम्हारी बात का विश्वास न करें या उस पहले वाले चिन्ह को न मानें, हो सकता है कि वे दूसरे चिन्ह पर विश्वास कर लें. ");
INSERT INTO hincv_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","किंतु यदि वे इन दोनों चिन्हों पर भी विश्वास न करें और तुम्हारी बात को भी न माने, तब तुम नील नदी से कुछ जल लेकर सूखी भूमि पर डाल देना; नील नदी से लिया गया वह जल सूखी भूमि पर डालते ही खून बन जाएगा.” ");
INSERT INTO hincv_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","तब मोशेह ने याहवेह से कहा, “याहवेह परमेश्वर, मुझे माफ करें, मैं अच्छी तरह से बोल नहीं सकता हूं, पहले भी नहीं बोल सकता था, और न जब से आपने अपने दास से बात की थी, मेरी ज़ुबान तुतली और धीमी है!” ");
INSERT INTO hincv_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","याहवेह ने उनसे पूछा, “किसने मनुष्य का मुंह बनाया है? कौन उसे गूंगा या बहिरा बनाता है? कौन है जो उसको बोलने की शक्ति या देखने के लिए रोशनी देता है? क्या मैं, स्वयं याहवेह नहीं? ");
INSERT INTO hincv_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","अब जाओ. मैं, हां, मैं तुम्हें बोलने की मदद करूंगा, और बताऊंगा, कि तुम्हें क्या बोलना है.” ");
INSERT INTO hincv_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","किंतु मोशेह ने मना किया और कहा, “प्रभु, अपने दास को माफ कर दे, कृपया आप किसी दूसरे को भेज दीजिए.” ");
INSERT INTO hincv_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","याहवेह मोशेह से नाराज हुए. उन्होंने मोशेह से कहा, “तुम्हारा भाई, अहरोन, जो लेवी है, वह तुमसे मिलने यहीं आ रहा है. तुम्हें देखकर वह खुश हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","तुम उसे यह सब बताना और उसके मुंह में बातें डालना इसके अलावा मैं—हां मैं, तुम दोनों की बोलने में सहायता करूंगा, मैं तुम दोनों को सही मार्ग पर चलना सिखाऊंगा. ");
INSERT INTO hincv_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","वह तुम्हारी ओर से लोगों से बात करेगा व तुम अहरोन के परमेश्वर समान होंगे. ");
INSERT INTO hincv_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","इस लाठी को तुम अपने हाथ में ही रखना, इसी से तुम अद्भुत काम कर पाओगे.” ");
INSERT INTO hincv_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","मोशेह वहां से आकर अपने ससुर येथ्रो से मिलने गए और उनसे कहा, “कृपया मुझे जाने दीजिए ताकि मैं मिस्र देश में अपने भाई-बंधुओं से मिलकर पता करूं कि उनमें से कोई अब भी ज़िंदा है या नहीं.” येथ्रो ने उनसे कहा, “तुम शांति से जाओ.” ");
INSERT INTO hincv_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","मिदियान देश में ही मोशेह को याहवेह की ओर से यह आदेश मिल चुका था, “मिस्र देश को लौट जाओ, क्योंकि उन सभी की मृत्यु हो चुकी है, जो तुम्हारी हत्या करना चाहते थे.” ");
INSERT INTO hincv_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","फिर मोशेह अपनी पत्नी एवं पुत्रों को गधे पर बैठाकर मिस्र देश को लौट गए. परमेश्वर के कहे अनुसार मोशेह परमेश्वर की लाठी अपने हाथ में ली हुई थी. ");
INSERT INTO hincv_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","याहवेह ने मोशेह से कहा, “मिस्र देश पहुंचकर तुम वे सभी चिन्ह फ़रोह को दिखाना जो मैंने तुम्हारे वश में किए हैं, परंतु मैं फ़रोह के मन को कठोर कर दूंगा, और वह इस्राएलियों को जाने न देगा. ");
INSERT INTO hincv_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","तब तुम फ़रोह से कहना, ‘याहवेह का संदेश यह है: इस्राएल मेरा पुत्र—मेरा पहलौठा है. ");
INSERT INTO hincv_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","यह मेरा आदेश है कि मेरे पुत्र को जाने दो, कि वह मेरी आराधना कर सके; परंतु तुम उन्हें जाने नहीं दे रहे हो. इस कारण मैं तुम्हारे बड़े बेटे को मार दूंगा.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","मार्ग में सराय पर याहवेह मोशेह के पास आए कि उनको मार दें. ");
INSERT INTO hincv_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","लेकिन ज़ीप्पोराह ने एक नुकीले पत्थर से अपने पुत्र की खलड़ी को काटकर मोशेह के पैरों पर डाल दिया और कहा, “आप लहू बहानेवाले मेरे दूल्हा हैं!” ");
INSERT INTO hincv_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","इसलिये याहवेह ने मोशेह को नहीं छुआ. यही वह समय था जब ज़ीप्पोराह ने कहा था, “आप वास्तव में रक्त बहानेवाले दूल्हा हैं,” क्योंकि उसी समय ख़तना किया था. ");
INSERT INTO hincv_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","याहवेह ने अहरोन से कहा, “निर्जन प्रदेश में जाकर मोशेह से मिलो.” और अहरोन परमेश्वर के पर्वत पर गये और मोशेह से मिले. अहरोन ने मोशेह का चुंबन किया. ");
INSERT INTO hincv_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","मोशेह ने अहरोन को वह सब बातें बताईं जिन्हें कहने के लिये याहवेह ने उसे भेजा था. मोशेह ने वह अद्भुत चिन्ह भी बताए, जिन्हें याहवेह ने मोशेह को करने की आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","मोशेह तथा अहरोन ने इस्राएलियों के सब प्रधानों को बुलाया. ");
INSERT INTO hincv_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","अहरोन ने उनको वह सब बात बताई, जो याहवेह ने मोशेह से कही थी. फिर उन्होंने सब लोगों के सामने वह चिन्ह भी दिखाये. ");
INSERT INTO hincv_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","चिन्ह देखकर लोगों ने उनका विश्वास किया और जब उन्हें यह पता चला कि याहवेह ने इस्राएलियों की ओर कान लगाया है और उनके दुखों की ओर ध्यान दिया है, तब उन्होंने झुककर प्रणाम किया और परमेश्वर की आराधना की. ");
INSERT INTO hincv_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","इसके बाद मोशेह तथा अहरोन गये व फ़रोह से कहा, “याहवेह, जो इस्राएल के परमेश्वर हैं, उनका कहना है, ‘मेरी प्रजा को जाने दो कि वे निर्जन प्रदेश में जाकर मेरे सम्मान में एक उत्सव मना सकें.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","किंतु फ़रोह ने उत्तर दिया, “कौन है याहवेह, जिसकी बात मैं मानूं और इस्राएल को यहां से जाने दूं? मैं याहवेह को नहीं जानता और मैं इस्राएल को यहां से जाने नहीं दूंगा.” ");
INSERT INTO hincv_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","यह सुनकर उन्होंने कहा, “इब्रियों के परमेश्वर ने हमसे कहा है. इसलिये कृपा कर हमें निर्जन प्रदेश में तीन दिन की यात्रा पर जाने दीजिए, कि हम याहवेह, अपने परमेश्वर के लिए बलि चढ़ाएं, ऐसा न हो कि वे हमसे नाराज़ हो जाएं और हम पर महामारी या तलवार से वार करें.” ");
INSERT INTO hincv_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","किंतु मिस्र देश के राजा ने उन्हें उत्तर दिया, “मोशेह और अहरोन, तुम लोग इस प्रजा को उनके काम से दूर क्यों करना चाह रहे हो? जाओ, तुम सब अपना अपना काम करो!” ");
INSERT INTO hincv_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","फ़रोह ने उनसे दुबारा कहा, “सुनो, देश में लोग बहुत बढ़ गये हैं और अब तुम उन्हें उनके काम से अलग करना चाहते हो!” ");
INSERT INTO hincv_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","उसी दिन फ़रोह ने अपने दासों के निरीक्षकों और अधिकारियों से कहा: ");
INSERT INTO hincv_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“अब तक तुम इन लोगों को ईंट बनाने का सामान, भूसा, सब कुछ लाकर देते थे. लेकिन अब से ये लोग खुद अपना सामान लायेंगे; ");
INSERT INTO hincv_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","और उतनी ही ईंट बनाएंगे जितनी पहले बनाते थे; इससे कम नहीं किया जायेगा; ये लोग आलसी हैं, इसलिये यहां से जाने के लिए पूछ रहे हैं, ‘हम अपने परमेश्वर के लिए बलि अर्पित कर सकें.’ ");
INSERT INTO hincv_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","इनके काम और बढ़ा दो और उन्हें ज्यादा व्यस्त कर दो, ताकि उनका ध्यान कहीं ओर न जाए.” ");
INSERT INTO hincv_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","दास-स्वामियों और निरीक्षकों ने बाहर जाकर लोगों से कहा, “फ़रोह ने कहा है, ‘अब से तुम्हें ईंट बनाने का सामान; भूसा, नहीं दिया जायेगा. ");
INSERT INTO hincv_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","यह तुम्हें ही लाना होगा—और तुम्हारे काम में कोई कमी न हो.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","इस कारण इस्राएली लोग पूरे मिस्र देश में फैल गये, और ईंट बनाने का सामान: भूसा, ढूंढने की कोशिश करने लगे. ");
INSERT INTO hincv_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","काम करनेवालों की देखरेख करनेवाले उन पर ज्यादा दबाव डालते हुए कहने लगे, “ईंटों की गिनती में कमी नहीं होनी चाहिए, पहले जितनी बनाते थे उतनी ही अब भी बनानी हैं.” ");
INSERT INTO hincv_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","इस्राएलियों के ऊपर नियुक्त फ़रोह के दास-स्वामियों ने इस्राएली निरीक्षकों की पिटाई की और उनसे ईंटों की गिनती पूछते रहे! ");
INSERT INTO hincv_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","इन सब सताव के कारण इस्राएलियों का पर्यवेक्षक फ़रोह के पास जाकर पूछने लगे, “आप सेवकों से ऐसा व्यवहार क्यों कर रहे हैं? ");
INSERT INTO hincv_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ईंट बनाने का सामान कुछ नहीं दिया जा रहा है, फिर भी कहा जा रहा है, ‘ईंट बनाओ, ईंट बनाओ!’ और सेवकों की पिटाई की जा रही है; जबकि दोष तो आपके लोगों का है.” ");
INSERT INTO hincv_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फ़रोह ने उत्तर दिया, “तुम लोग आलसी हो—अत्यंत आलसी; इसलिये यह कह रहे हो, ‘हमें जाने दीजिए कि हम यहां से जाकर याहवेह को बलि अर्पित करें.’ ");
INSERT INTO hincv_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","अब जाओ और अपने काम करो. तुम्हें कुछ नहीं दिया जाएगा, लेकिन जितना तुम पहले बनाते थे उतनी ही ईंट अब भी बनाओगे.” ");
INSERT INTO hincv_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","इस्राएली लोग यह समझ गए थे कि उनकी परेशानी बहुत बढ़ गई है; क्योंकि उन्हें कहा गया था कि रोज जितनी ईंटें बनाने के लिए बोला गया है, उसमें कोई कमी नहीं आएगी. ");
INSERT INTO hincv_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","जब वे फ़रोह के पास से बाहर आए, तो उनको मोशेह एवं अहरोन मिले, जो वहां उन्हीं के लिए रुके हुए थे. ");
INSERT INTO hincv_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","इस्राएलियों ने मोशेह तथा अहरोन से कहा, “अब याहवेह ही हमें बचा सकते हैं: क्योंकि आप ही के कारण मिस्री हमसे नफ़रत करने लगे हैं, आप ही ने हमें उनके हाथों में छोड़ दिया है.” ");
INSERT INTO hincv_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","तब मोशेह याहवेह के पास गए और उनसे बिनती की, “आपने अपने लोगों को परेशानी में डालने के लिए मुझे क्यों चुना है? ");
INSERT INTO hincv_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","जब मैंने फ़रोह से याहवेह के बारे में बात की, तब से फ़रोह ने इस्राएलियों को परेशान करना शुरू किया. इस स्थिति में आपने अपने लोगों को नहीं बचाया!” ");
INSERT INTO hincv_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","इस पर याहवेह ने मोशेह से कहा, “अब तुम देखना कि मैं फ़रोह के साथ क्या करूंगा; मेरे पराक्रमी हाथ की वजह से उसे तुम सबको छोड़ना ही पड़ेगा, मेरे पराक्रमी हाथ की वजह से ही फ़रोह इतना परेशान हो जाएगा, कि वह अपने देश से सबको निकाल देगा.” ");
INSERT INTO hincv_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","परमेश्वर ने मोशेह से यह भी कहा, “मैं ही याहवेह हूं; ");
INSERT INTO hincv_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","अब्राहाम, यित्सहाक तथा याकोब पर मैं ही सर्वसामर्थी होकर प्रकट हुआ था; परंतु, याहवेह के नाम से कभी अपने आपको प्रकट नहीं किया. ");
INSERT INTO hincv_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","मैंने कनान देश, जहां वे पराये होकर रहते थे, उनको देने का पक्का वायदा भी किया था. ");
INSERT INTO hincv_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","परमेश्वर ने इस्राएलियों का रोना सुना है, क्योंकि मिस्रियों ने उन्हें बंदी बना रखा है और मुझे मेरा वायदा जो मैं ने इस्राएलियों से किया था याद है. ");
INSERT INTO hincv_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“इस कारण इस्राएलियों से यह कहना: ‘मैं ही याहवेह हूं. मैं ही तुम्हें मिस्रियों की परेशानी से निकालूंगा. मैं तुम्हें उनके बंधन से छुड़ाऊंगा. मैं तुम्हें अपनी बाहों में लेकर तथा उन्हें दंड देकर तुम्हें छुड़ा लूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","फिर तुम मेरे लोग ठहरोगे और मैं तुम्हारा परमेश्वर. और तुम्हें तसल्ली मिलेगी कि मैं ही याहवेह, तुम्हारा परमेश्वर हूं, जिसने तुम्हें मिस्रियों के दबाव और बोझ से निकाला है. ");
INSERT INTO hincv_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","मैं तुम्हें उस देश में लाऊंगा, जिसे देने का शपथ मैंने हाथ उठाकर अब्राहाम, यित्सहाक तथा याकोब से ली थी, और वह देश तुम्हारा ही हो जाएगा. मैं ही वह याहवेह हूं.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","मोशेह ने वह सब बात जो याहवेह ने कही थी, सबको बता दी, लेकिन इस्राएलियों ने फ़रोह के द्वारा हो रहे अत्याचार के कारण इन पर विश्वास नहीं किया. ");
INSERT INTO hincv_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","याहवेह मोशेह के पास आए और उनसे कहा, ");
INSERT INTO hincv_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“जाकर मिस्र देश के राजा फ़रोह से कहो कि वह इस्राएलियों को इस देश से बाहर जाने दे.” ");
INSERT INTO hincv_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","मोशेह ने याहवेह से कहा, “इस्राएलियों ने मेरी बात नहीं मानी है, तो फ़रोह कैसे मेरी बात मानेगा, मैं तो हकलाता बात करता हूं.” ");
INSERT INTO hincv_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","फिर याहवेह ने मोशेह तथा अहरोन से इस्राएल एवं मिस्र के राजा फ़रोह के लिए यह आदेश दिया कि इस्राएली मिस्र देश से निकाले जाएं. ");
INSERT INTO hincv_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","इस्राएल के परिवार के मुखिया इस प्रकार थे: इस्राएल का पहला बेटा रियूबेन. रियूबेन के पुत्र: हनोख, पल्लू, हेज़रोन, कारमी; ये सभी रियूबेन के परिवार के लोग हैं. ");
INSERT INTO hincv_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","शिमओन के पुत्र: येमुएल, यामिन, ओहद, याकिन, ज़ोहार तथा शाऊल, जो एक कनानी स्त्री से जन्मे थे; ये सभी शिमओन के परिवार के लोग हैं. ");
INSERT INTO hincv_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लेवी के पुत्रों के नाम: गेरशोन, कोहाथ तथा मेरारी. (लेवी की कुल आयु एक सौ सैंतीस वर्ष की हुई.) ");
INSERT INTO hincv_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेरशोन के पुत्र उनके परिवारों के अनुसार: लिबनी और शिमेई. ");
INSERT INTO hincv_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कोहाथ के पुत्र: अमराम, इज़हार, हेब्रोन तथा उज्ज़िएल. (कोहाथ की कुल आयु एक सौ सैंतीस वर्ष की हुई.) ");
INSERT INTO hincv_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मेरारी के पुत्र: माहली तथा मूशी. ये उनकी पीढ़ियों के अनुसार लेवियों के परिवार हैं. ");
INSERT INTO hincv_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अमराम ने अपने पिता की बहन से विवाह किया, जिससे अहरोन एवं मोशेह पैदा हुए. (अमराम की कुल आयु एक सौ सैंतीस वर्ष की हुई.) ");
INSERT INTO hincv_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","इज़हार के पुत्र: कोराह, नेफ़ेग तथा ज़ीकरी. ");
INSERT INTO hincv_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्ज़िएल के पुत्र: मिषाएल, एलज़ाफन तथा सिथरी. ");
INSERT INTO hincv_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","अहरोन ने अम्मीनादाब की पुत्री, नाहशोन की बहन एलिशेबा से विवाह किया, जिसने नादाब, अबीहू, एलिएज़र तथा इथामार को जन्म दिया. ");
INSERT INTO hincv_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोराह के पुत्र: अस्सिर, एलकाना तथा अबीयासाफ़. कोराह के वंशजों के परिवार ये हैं. ");
INSERT INTO hincv_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","अहरोन के पुत्र एलिएज़र ने पुतिएल की पुत्री से विवाह किया, जिससे फिनिहास पैदा हुए. ये लेवी वंश के कुलों के मुखिया थे. ");
INSERT INTO hincv_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ये अहरोन तथा मोशेह थे, जिन्हें याहवेह द्वारा कहा गया था, “इस्राएलियों को अपनी समझदारी से मिस्र देश से निकाल लाओ.” ");
INSERT INTO hincv_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","मोशेह और अहरोन, जो इस्राएलियों को मिस्र देश से निकालने के लिए फ़रोह से बार-बार कहते रहे. ");
INSERT INTO hincv_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","जिस दिन याहवेह ने मिस्र देश में मोशेह से बात की, ");
INSERT INTO hincv_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","और कहा, “मैं ही याहवेह हूं. और जो कुछ मैं तुमसे कहता हूं, वह सब तुम मिस्र देश के राजा फ़रोह से कहना.” ");
INSERT INTO hincv_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","लेकिन मोशेह ने याहवेह से कहा, “मैं अच्छी तरह बोल नहीं सकता; फ़रोह मेरी बात क्यों सुनेगा?” ");
INSERT INTO hincv_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","यह सुनकर याहवेह ने मोशेह से कहा, “अब देखना कि मैं तुम्हें कैसे फ़रोह के सामने ईश्वर-समान बना देता हूं. और तुम्हारा भाई अहरोन तुम्हारा प्रवक्ता होगा. ");
INSERT INTO hincv_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","जो जो बात मैं तुम्हें बताऊंगा, वह सब बात तुम अहरोन से कहना और अहरोन वही सब फ़रोह से कह देगा, तब फ़रोह इस्राएलियों को अपने देश से जाने देगा. ");
INSERT INTO hincv_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","लेकिन मैं फ़रोह के मन को कठोर बना दूंगा, ताकि मैं मिस्र देश में और ज्यादा चिन्ह और अद्भुत काम कर सकूं. ");
INSERT INTO hincv_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","फिर भी फ़रोह उन सब बातों पर ध्यान नहीं देगा. तब मैं मिस्र देश को बड़ा कष्ट और दंड दूंगा और मिस्र से इस्राएल के लोगों को बाहर निकालूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","मिस्र के लोग यह जान जाएंगे कि मैं ही याहवेह हूं, जिसने मिस्र देश पर अपना हाथ बढ़ाया है और मैंने ही इस्राएलियों को उसके बीच से निकाला है.” ");
INSERT INTO hincv_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","तब मोशेह एवं अहरोन ने ऐसा ही किया—जैसा याहवेह ने उनसे कहा था. ");
INSERT INTO hincv_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","जब मोशेह और अहरोन फ़रोह के पास गए, तब मोशेह की उम्र अस्सी वर्ष तथा अहरोन की तेरासी वर्ष थी. ");
INSERT INTO hincv_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","तब याहवेह ने मोशेह तथा अहरोन को यह आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“जब फ़रोह तुमसे चमत्कार दिखाने को कहे, तब तुम अहरोन से कहना, ‘अपनी लाठी फ़रोह के सामने डाल दे, ताकि वह सांप बन जाए.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","इसलिये मोशेह तथा अहरोन फ़रोह के पास गए और ठीक वही किया, जो याहवेह ने कहा था. अहरोन ने अपनी लाठी फ़रोह एवं उसके सेवकों के सामने डाल दी और वह सांप बन गई. ");
INSERT INTO hincv_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","यह देख फ़रोह ने भी पंडितों तथा ओझों को बुलवाया और मिस्र देश के जादूगरों ने भी वैसा ही किया. ");
INSERT INTO hincv_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","उन सबने अपनी-अपनी लाठी फेंकी जो सांप बन गईं. पर अहरोन की लाठी ने उन सभी की लाठियों को निगल लिया. ");
INSERT INTO hincv_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","इससे फ़रोह का मन और कठोर हो गया और उसने उनकी बात नहीं मानी, जैसा ही याहवेह ने कहा था. ");
INSERT INTO hincv_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","तब याहवेह ने मोशेह से कहा, “फ़रोह का मन बहुत कठोर हो गया है, वह लोगों को जाने नहीं देगा. ");
INSERT INTO hincv_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","सुबह जब फ़रोह नदी की ओर जाएगा, तब तुम नदी पर उनसे मिलना और तुम्हारे हाथ में वही लाठी रखना, जो सांप बन गई थी. ");
INSERT INTO hincv_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","तुम फ़रोह से यह कहना ‘याहवेह ने, जो इब्रियों के परमेश्वर हैं, मुझे तुमको यह कहने के लिए भेजा है कि मेरे लोगों को जाने दो कि वे निर्जन प्रदेश में जाकर मेरी आराधना कर सकें; लेकिन अभी तक तुमने यह बात नहीं मानी है. ");
INSERT INTO hincv_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","याहवेह ने यह कहा है कि तुम जान जाओगे कि मैं ही याहवेह हूं, तुम देखना कि नदी के जल पर मैं इस लाठी से, जो मेरे हाथ में है, मारूंगा और पानी खून बन जाएगा. ");
INSERT INTO hincv_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","और उसमें सब मछलियां मर जायेंगी और नदी से बदबू आएगी और मिस्र के लोग नील नदी से पानी नहीं पी पायेंगे.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","फिर याहवेह ने मोशेह से कहा, “अहरोन से यह कहो: ‘अपनी लाठी मिस्र देश की नदियों, नालों, तालाबों और जल-कुं‍डों की ओर बढ़ाए ताकि सारा पानी लहू बन जाये—चाहे पानी बर्तन में हो या पत्थर के पात्र में.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","मोशेह तथा अहरोन ने वैसा ही किया, जैसा याहवेह ने उनसे कहा. उन्होंने लाठी उठाई और नील नदी के जल पर मारा. फ़रोह एवं उसके सेवक यह सब देख रहे थे. एकदम नील नदी का पूरा पानी लहू बन गया. ");
INSERT INTO hincv_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","नील नदी में जो मछलियां थी, मर गईं. नदी में इतनी दुर्गंध थी कि मिस्र के लोग नील नदी का पानी नहीं पी सकते थे. पूरे मिस्र देश में रक्त फैल गया. ");
INSERT INTO hincv_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","अपने तंत्र मंत्र से मिस्र के जादूगरों ने भी यही कर दिखाया; तौभी फ़रोह का मन और कठोर हो गया और उसने उनकी बात नहीं मानी. ");
INSERT INTO hincv_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","फ़रोह पर इन सब बातों का कोई असर नहीं हुआ और वह अपने घर चला गया. ");
INSERT INTO hincv_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","मिस्र के लोग पीने के पानी के लिए नील नदी के पास गड्ढे खोदने लगे, क्योंकि नील नदी का पानी पीने योग्य नहीं रहा था. ");
INSERT INTO hincv_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","याहवेह द्वारा नील नदी के पानी को लहू बनाए सात दिन हो चुके थे. ");
INSERT INTO hincv_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","फिर याहवेह ने मोशेह से कहा, “फ़रोह से कहो कि, याहवेह की ओर से यह आदेश है, ‘मेरे लोगों को जाने दो, ताकि वे मेरी वंदना कर सकें. ");
INSERT INTO hincv_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","यदि तुम उन्हें जाने न दोगे, तो पूरा देश मेंढकों से भर जायेगा. ");
INSERT INTO hincv_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","नील नदी मेंढकों से भर जाएगी, मेंढक नदी में से निकलकर तुम्हारे घरों में, तुम्हारे बिछौनों पर, तुम्हारे सेवकों के घरों में और पूरी प्रजा के घरों में भी भर जाएंगे—यहां तक कि तुम्हारे तंदूरों में तथा तुम्हारे आटा गूंथने के बर्तनों में भी भर जायेंगे! ");
INSERT INTO hincv_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","तुम पर, तुम्हारी प्रजा पर तथा तुम्हारे सभी सेवकों पर मेढक चढ़ जायेंगे.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","फिर याहवेह ने मोशेह से कहा, “अहरोन से कहो, ‘अपने हाथ में वह लाठी लेकर उसे नदियों, तालाबों तथा नालों की ओर बढ़ाए, ताकि मेंढक मिस्र देश में भर जाएं.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","तब अहरोन ने यही किया. मेंढक ऊपर तक आ गए तथा समस्त मिस्र देश पर छा गए. ");
INSERT INTO hincv_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","जादूगरों ने भी अपनी गुप्‍त कला से वही कर दिखाया, वे भी मिस्र देश में मेंढक ले आए. ");
INSERT INTO hincv_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","फ़रोह ने मोशेह तथा अहरोन को बुलवाया और उनसे कहा, “याहवेह से बिनती करो कि वह इन मेंढकों को मुझसे तथा मेरी प्रजा से दूर कर दें, तब मैं तुम लोगों को यहां से जाने दूंगा, ताकि याहवेह को बलि चढ़ा सको.” ");
INSERT INTO hincv_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मोशेह ने फ़रोह को उत्तर दिया, “तुम ही मुझे बताओ कि कब मैं आपके लिये प्रार्थना करूं कि ये मेंढक तुम्हारे तथा तुम्हारे घरों से निकल जाएं और सिर्फ नील नदी में रह जाएं?” ");
INSERT INTO hincv_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","फ़रोह ने जवाब दिया, “कल प्रार्थना करना.” मोशेह बोले, “वैसा ही होगा, जैसा तुमने कहा है, ताकि तुमको यह मालूम हो जाए, कि याहवेह, हमारे परमेश्वर, के तुल्य दूसरा कोई नहीं है. ");
INSERT INTO hincv_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","मेंढक तुमसे, तुम्हारे घरों से, तुम्हारे सेवकों तथा तुम्हारी प्रजा से दूर कर दिए जाएंगे और केवल नील नदी में दिखेंगे.” ");
INSERT INTO hincv_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","यह कहकर मोशेह तथा अहरोन फ़रोह के पास से चले गए. फिर मोशेह ने मेढकों के जाने के बारे में जैसा फ़रोह ने कहा था, याहवेह से प्रार्थना की. ");
INSERT INTO hincv_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","याहवेह ने मोशेह की बात मानी, और घरों से, महल तथा खेतों के सब मेंढक मर गये. ");
INSERT INTO hincv_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","तब लोगों ने मरे हुए सब मेंढकों को एक तरफ इकट्ठा किया, जिससे पूरे देश में बदबू फैल गई. ");
INSERT INTO hincv_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","जैसे ही फ़रोह ने यह देखा कि मेंढक सब मर गये और परेशानी सब दूर हो गई, उसने अपना मन फिर कठोर कर लिया और उनकी बात नहीं सुनी. ");
INSERT INTO hincv_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","फिर याहवेह ने मोशेह से कहा, “अहरोन से कहो कि वह अपनी लाठी बढ़ाए तथा ज़मीन पर मारे, ताकि पूरा मिस्र देश पिस्सुओं से भर जायें.” ");
INSERT INTO hincv_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","अहरोन ने लाठी को ज़मीन पर मारा, जिससे पिस्सू मनुष्यों एवं पशुओं पर छा गए और पूरे मिस्र देश की भूमि की धूल पिस्सू बन गई. ");
INSERT INTO hincv_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ऐसा ही जादू-टोना दिखाने वाले जादूगरों ने भी करने की कोशिश की, लेकिन नहीं कर पाये; तब मनुष्यों एवं पशुओं को पिस्सू ने परेशान कर दिया. ");
INSERT INTO hincv_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","तब जादूगरों ने फ़रोह से कहा “यह तो सचमुच परमेश्वर का काम है!” इस पर फ़रोह का मन और कठोर हो गया, जैसा याहवेह ने कहा था, इसलिये उसने उनकी ओर ध्यान नहीं दिया. ");
INSERT INTO hincv_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","फिर याहवेह ने मोशेह से कहा, “सुबह जल्दी उठकर फ़रोह से मिलने जाना जब वह नदी की ओर जाए तब उससे कहना, ‘याहवेह का आदेश है: मेरे लोगों को जाने दे, कि वे मेरी आराधना करें. ");
INSERT INTO hincv_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","अगर तुम मेरी प्रजा को जाने न दो, तो मैं तुम पर, तुम्हारे सेवकों, तुम्हारी प्रजा तथा तुम्हारे घरों में कीटों के झुंड को भेजूंगा. मिस्र के लोगों का घर और पूरा मिस्र कीटों से भर जाएगा. ");
INSERT INTO hincv_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘लेकिन गोशेन देश, जहां मेरी प्रजा रहती है; वहां कीट नहीं होगा, ताकि तुम्हें यह मालूम हो जाए कि मैं, याहवेह हूं, और इस देश में मेरा अधिकार है. ");
INSERT INTO hincv_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","मैं कल अपनी प्रजा तथा तुम्हारी प्रजा को अलग कर दूंगा.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","अगले दिन याहवेह ने वही किया. फ़रोह के राजमहल में तथा उसके सेवकों के घरों को, कीटों से भर दिया. पूरा मिस्र देश कीटों के कारण नाश हो गया. ");
INSERT INTO hincv_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","फ़रोह ने मोशेह तथा अहरोन को बुलवाया और उनसे कहा कि तुम लोग जाओ और “अपने परमेश्वर को बलि चढ़ाओ, लेकिन मिस्र में ही रहना इससे बाहर मत जाना.” ");
INSERT INTO hincv_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","लेकिन मोशेह ने जवाब दिया, “हम, याहवेह अपने परमेश्वर को बलि मिस्र में रहकर नहीं कर सकते हैं. यदि हम मिस्रियों के सामने बलि अर्पण करेंगे, तो क्या वे हमारा पथराव न कर देंगे? ");
INSERT INTO hincv_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","हमें तो निर्जन देश में तीन दिन की दूरी पर जाना ही होगा, कि हम वहां याहवेह, अपने परमेश्वर, को उन्हीं के आदेश के अनुसार बलि अर्पित कर सकें.” ");
INSERT INTO hincv_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","फ़रोह ने उत्तर दिया, “ठीक है, मैं तुम्हें जाने देता हूं, कि तुम निर्जन प्रदेश में जाकर याहवेह, अपने परमेश्वर को बलि चढ़ाओ, लेकिन बहुत दूर न जाना. वहां मेरे लिए भी प्रार्थना करना.” ");
INSERT INTO hincv_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","यह सुन मोशेह ने उत्तर दिया, “अब मैं यहां से जा रहा हूं. और मैं याहवेह से बिनती करूंगा, कि कीटों को फ़रोह, उसके सेवकों तथा उसकी प्रजा से दूर कर दें; ऐसा न हो कि फ़रोह वापस चालाकी से प्रजा को रोकने की कोशिश करे.” ");
INSERT INTO hincv_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","तब मोशेह फ़रोह के पास से चले गए और याहवेह से बिनती की और ");
INSERT INTO hincv_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","याहवेह ने कीटों के समूहों को फ़रोह, उसके सेवकों तथा उसकी प्रजा से हटा लिया, और एक भी न बचा. ");
INSERT INTO hincv_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","फिर फ़रोह ने अपना मन कठोर कर लिया और प्रजा को जाने नहीं दिया. ");
INSERT INTO hincv_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","फिर परमेश्वर ने मोशेह से कहा, “जाकर फ़रोह को यह बता दो, ‘इब्रियों के परमेश्वर याहवेह ने यह कहा है, “मेरी प्रजा को यहां से जाने दो, ताकि वे मेरी वंदना कर सकें.” ");
INSERT INTO hincv_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","यदि तुम उन्हें जाने नहीं दोगे ");
INSERT INTO hincv_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","तो याहवेह का हाथ तुम्हारे पशुओं, घोड़ों, गधों, ऊंटों, गायों एवं भेड़-बकरियों पर बढ़ेगा और बड़ी महामारी फैल जायेगी. ");
INSERT INTO hincv_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","याहवेह मिस्रियों के पशुओं में महामारी फैलायेंगे, लेकिन इस्राएल के पशुओं को कुछ नहीं होगा—जिसके कारण इस्राएल वंश के एक भी पशु की मृत्यु न होगी.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","याहवेह ने एक समय ठहराकर यह कह दिया: “अगले दिन याहवेह इस देश में महामारी फैलायेंगे.” ");
INSERT INTO hincv_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","तब याहवेह ने अगले दिन वही किया—मिस्र देश के सभी पशु मर गए; किंतु इस्राएल वंश में एक भी पशु नहीं मरा. ");
INSERT INTO hincv_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","फ़रोह ने सच्चाई जानने के लिए सेवक को भेजा. तब उन्होंने देखा कि इस्राएल में एक भी पशु की मृत्यु नहीं हुई थी. यह देख फ़रोह का मन और कठोर हो गया, उसने प्रजा को जाने नहीं दिया. ");
INSERT INTO hincv_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","फिर याहवेह ने मोशेह और अहरोन से कहा, “अपने-अपने हाथों में मुट्ठी भरके राख लेना, और उस राख को फ़रोह के सामने आकाश की ओर फेंकना. ");
INSERT INTO hincv_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","यह राख पूरे देश पर रेत में बदल जाएगी, जिससे पूरे मिस्रवासियों एवं पशुओं के शरीर पर फोड़े फुंसी हो जायेंगे.” ");
INSERT INTO hincv_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","इसलिये मोशेह तथा अहरोन ने भट्ठे से राख उठाई और फ़रोह के सामने गए. मोशेह ने राख को आकाश की ओर उछाला, जिसके कारण मनुष्यों और पशुओं के शरीर पर फोड़े निकल आए. ");
INSERT INTO hincv_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","इन फोड़ों के कारण जादूगर मोशेह के सामने खड़े न रह सके, क्योंकि फोड़े न केवल मिस्रवासियों की देह पर निकल आए थे किंतु जादूगरों के शरीर भी फोड़े से भर गये थे! ");
INSERT INTO hincv_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","याहवेह ने फ़रोह के मन को कठोर बना दिया, और फ़रोह ने मोशेह की बात नहीं मानी; यह बात याहवेह ने मोशेह से पहले ही कह दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","तब याहवेह ने मोशेह से कहा, “सुबह जल्दी उठकर फ़रोह के पास जाकर यह कहना, ‘याहवेह, इब्रियों के परमेश्वर की यह आज्ञा है कि मेरी प्रजा को यहां से जाने दो, ताकि वे मेरी वंदना कर सकें. ");
INSERT INTO hincv_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","क्योंकि इस बार मैं और ज्यादा परेशानियां तुम पर, तुम्हारे सेवकों पर तथा तुम्हारी प्रजा पर डाल दूंगा, जिससे तुम्हें यह मालूम हो जाए कि पूरे पृथ्वी पर मेरे तुल्य कोई भी नहीं है. ");
INSERT INTO hincv_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","क्योंकि अब तक मैं अपना हाथ बढ़ाकर तुम और तुम्हारी प्रजा पर बहुत बड़ी विपत्तियां डालकर तुम्हें मिटा देता. ");
INSERT INTO hincv_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","तुम्हारी उत्पत्ति के पीछे मेरा एकमात्र उद्देश्य था कि तुमको मेरे प्रताप का प्रदर्शन करूं, और सारी पृथ्वी में मेरे नाम का प्रचार हो. ");
INSERT INTO hincv_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","लेकिन तुमने मेरी प्रजा को यहां से जाने की अनुमति न देकर अपने आपको महान समझा है! ");
INSERT INTO hincv_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","अब देखना, कल इसी समय मैं बड़े-बड़े ओले बरसाऊंगा—ऐसा मिस्र देश में आज तक नहीं देखा गया है, ");
INSERT INTO hincv_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","इसलिये अब सबको बता दो कि मैदानों से अपने पशुओं को तथा जो कुछ इस समय खेतों में रखा हुआ है, सुरक्षित स्थान पर ले जाएं. अगर कोई मनुष्य या पशु, ओले गिरने से पहले अपने घरों में न पहुंचें, वे अवश्य मर जायेंगे.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","तब फ़रोह के उन सेवकों ने, जिन्होंने याहवेह की बात पर ध्यान दिया वे सब जल्दी अपने-अपने लोगों एवं पशुओं को लेकर घर चले गये ");
INSERT INTO hincv_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","और जिन्होंने उस बात पर ध्यान नहीं दिया, वे सेवक एवं उनके पशु मैदान में ही रह गए. ");
INSERT INTO hincv_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","याहवेह ने मोशेह को आदेश दिया, “अपना हाथ आकाश की ओर बढ़ाओ, ताकि पूरे मिस्र देश पर, मनुष्य एवं पशु, और मैदान के हर एक वृक्ष पर ओले गिरना शुरू हो जाएं.” ");
INSERT INTO hincv_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","मोशेह ने अपनी लाठी आकाश की ओर बढ़ाई, और याहवेह ने आकाश से बादल गरजाये और ओले बरसाए और ओलों के साथ बिजली भी पृथ्वी पर गिरने लगी. ");
INSERT INTO hincv_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ओलों के साथ बिजली भी गिर रही थी; ऐसी दशा मिस्र देश में इससे पहले कभी नहीं हुई थी. ");
INSERT INTO hincv_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ओले उन सब पर गिरे, जो मैदानों में थे—ओले पौधे तथा वृक्ष पर भी गिरे जो पूरे नष्ट हो गये. ");
INSERT INTO hincv_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","केवल गोशेन प्रदेश में जहां इस्राएली रहते थे, ओले नहीं गिरे. ");
INSERT INTO hincv_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","तब फ़रोह ने मोशेह एवं अहरोन को बुलवाया और उनके सामने मान लिया: “मैंने पाप किया है, याहवेह ही महान परमेश्वर हैं, मैं तथा मेरी प्रजा अधर्मी है. ");
INSERT INTO hincv_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","तुम याहवेह से बिनती करो! बहुत हो चुका गरजना और ओले बरसना. मैं तुमको यहां से जाने दूंगा, तुम यहां मत रुको.” ");
INSERT INTO hincv_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मोशेह ने फ़रोह को उत्तर दिया, “जैसे ही मैं नगर से बाहर निकलूंगा, मैं अपनी भुजाएं याहवेह की ओर उठाऊंगा; तब आग तथा ओले गिरना रुक जाएंगे, तब तुमको मालूम हो जाएगा कि पृथ्वी पर याहवेह का ही अधिकार है. ");
INSERT INTO hincv_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","लेकिन तुम तथा तुम्हारे सेवकों के विषय में मुझे मालूम है कि अब भी तुममें याहवेह परमेश्वर के प्रति भक्ति नहीं है.” ");
INSERT INTO hincv_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(इस समय सन एवं जौ की फसल नष्ट हो चुकी थी, क्योंकि जौ की बालें आ चुकी थीं तथा सन में कलियां खिल रही थीं; ");
INSERT INTO hincv_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","लेकिन गेहूं नष्ट नहीं हुआ था, क्योंकि उसका उपज देर से होता है.) ");
INSERT INTO hincv_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","तब मोशेह फ़रोह के पास से निकलकर नगर के बाहर चले गए और उन्होंने याहवेह की ओर अपने हाथ उठाए; और तुरंत बादल गरजना एवं ओला गिरना रुक गया, भूमि पर हो रही वर्षा भी रुक गई. ");
INSERT INTO hincv_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","जैसे ही फ़रोह ने देखा कि ओले गिरना तथा बादल गरजना रुक गया, उन्होंने पाप किया और उसने और उसके सेवकों ने अपना मन कठोर कर लिया. ");
INSERT INTO hincv_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","कठोर मन से फ़रोह ने इस्राएलियों को जाने नहीं दिया—मोशेह को याहवेह ने पहले ही बता दिया था कि फ़रोह किस प्रकार अपने मन को फिर कठोर करेंगे. ");
INSERT INTO hincv_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","फिर याहवेह ने मोशेह से कहा, “फ़रोह के पास जाओ. मैंने ही उसका तथा उसके सेवकों का मन कठोर कर दिया है, ताकि मैं उनके बीच में अपने चिन्ह को दिखांऊ, ");
INSERT INTO hincv_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","कि तुम खुद अपने पुत्र एवं पोतों से कह सको कि मैंने किस तरह से मिस्रवासियों को अपमानित करते हुए उनके बीच अपने चिन्ह दिखाए ताकि तुम लोग सुरक्षित मिस्र से निकल सको और समझ सको कि मैं ही याहवेह हूं.” ");
INSERT INTO hincv_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","मोशेह एवं अहरोन ने फ़रोह के पास जाकर उससे यह कहा, “याहवेह, जो इब्रियों के परमेश्वर हैं, तुमसे कहते हैं, ‘तुम कब तक परमेश्वर के सामने अपने आपको नम्र नहीं करोगे? मेरी प्रजा को यहां से जाने दो, ताकि वे मेरी आराधना कर सकें. ");
INSERT INTO hincv_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","और यदि तुम मेरी प्रजा को जाने नहीं दोगे तो, कल मैं तुम्हारे देश में टिड्डियां ले आऊंगा. ");
INSERT INTO hincv_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","वे देश में ऐसे भर जाएंगी कि किसी को भी भूमि दिखाई न देगी. ये टिड्डियां वह सब नष्ट कर देंगी, जो कुछ ओलों के गिरने से बचा हुआ है और मैदान में लगे हर पेड़ को भी सूखा देंगी. ");
INSERT INTO hincv_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","फिर तुम्हारे तथा तुम्हारे सेवकों तथा पूरे मिस्रवासियों के घरों में टिड्डियां भर जाएंगी. ऐसा तो तुम्हारे पिता ने और उनके पूर्वजों ने जन्म से लेकर अब तक कभी नहीं देखा होगा.’ ” यह कहने के बाद मोशेह फ़रोह के पास से चले गए. ");
INSERT INTO hincv_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","फ़रोह के मंत्रियों ने फ़रोह से पूछा, “और कब तक यह व्यक्ति हमारे लिए परेशानी का कारण बनेगा? इन्हें जाने दो ताकि वे याहवेह, अपने परमेश्वर की आराधना कर सकें. क्या आपको नहीं मालूम कि मिस्र देश नष्ट हो चुका है?” ");
INSERT INTO hincv_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","मोशेह तथा अहरोन को फ़रोह के पास लाया गया. फ़रोह ने उनसे कहा, “जाओ और याहवेह, अपने परमेश्वर की आराधना करो! कौन-कौन हैं, जो तुम्हारे साथ जाएंगे?” ");
INSERT INTO hincv_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मोशेह ने उत्तर दिया, “हमारे साथ हमारे बालक और हमारे वृद्ध, हमारे पुत्र-पुत्रियां, हमारे पशु एवं भेड़-बकरियां सब जायेंगे, क्योंकि हम याहवेह के सम्मान में उत्सव मनाएंगे.” ");
INSERT INTO hincv_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","फ़रोह ने कहा, “याहवेह तुम्हारे साथ रहें, लेकिन मुझे लगता है कि तुम्हारे मन में कोई ओर योजना छिपी हुई है! ");
INSERT INTO hincv_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","केवल पुरुषों को ही लेकर याहवेह की वंदना करो, क्योंकि यही तुम्हारी इच्छा है.” ऐसा कहकर वहां से मोशेह तथा अहरोन को उनके सामने से निकाल दिया. ");
INSERT INTO hincv_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","तब याहवेह ने मोशेह से कहा, “मिस्र की ओर अपना हाथ बढ़ाओ कि टिड्डियां आकर मिस्र देश पर छा जाएं तथा हर पौधे को नष्ट कर दें.” ");
INSERT INTO hincv_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","तब मोशेह ने अपनी लाठी मिस्र देश की ओर बढ़ाई तब याहवेह ने मिस्र देश में पूरा दिन और पूरी रात तेज हवा चलाई. और सुबह हवा के साथ टिड्डियां भी आईं. ");
INSERT INTO hincv_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","टिड्डियां पूरे मिस्र देश पर फैल गईं, वे असंख्य थीं. इससे पहले इतनी टिड्डियां कभी देखी नहीं गई थीं. और न ही इसके बाद ये ऐसी बड़ी संख्या में देखी जाएंगी. ");
INSERT INTO hincv_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","इन टिड्डियों ने पूरे देश की धरती को भर दिया था, जिससे देश में अंधेरा सा हो गया. इन्होंने देश के हर पौधे को तथा सभी वृक्षों के फलों को, जो ओलों से बचे थे नष्ट कर दिया. इस कारण पूरे मिस्र देश में वृक्षों तथा मैदान के पौधों में कोई भी फल फूल न बचे. ");
INSERT INTO hincv_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","तब फ़रोह ने जल्दी से मोशेह तथा अहरोन को बुलवाया और उनसे कहा, “मैंने याहवेह, तुम्हारे परमेश्वर तथा तुम्हारे विरुद्ध पाप किया है. ");
INSERT INTO hincv_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","इसलिये कृपा कर मेरे पाप क्षमा कर दो और याहवेह, अपने परमेश्वर से विनती करो, कि वह इस मृत्यु को मुझसे दूर कर दें.” ");
INSERT INTO hincv_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","मोशेह फ़रोह के पास से बाहर चले गए और उन्होंने याहवेह से विनती की, ");
INSERT INTO hincv_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","तब याहवेह ने हवा की दिशा को बदलकर, टिड्डियों को लाल सागर में डाल दिया—तब पूरे देश में एक भी टिड्डी नहीं बची. ");
INSERT INTO hincv_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","किंतु याहवेह ने फ़रोह के मन को कठोर बना दिया. उसने इस्राएलियों को जाने नहीं दिया. ");
INSERT INTO hincv_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","तब याहवेह ने मोशेह से कहा, “अपना हाथ आकाश की ओर बढ़ाओ, ताकि पूरे मिस्र देश पर अंधेरा छा जाए—इतना गहरा अंधकार कि उसे स्पर्श कर सके.” ");
INSERT INTO hincv_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","तब मोशेह ने अपना हाथ आकाश की ओर बढ़ाया और पूरे मिस्र देश में तीन दिनों के लिए घोर अंधकार छाया रहा. ");
INSERT INTO hincv_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","कोई भी एक दूसरे को देख नहीं पाया और कोई भी अपनी जगह से तीन दिन तक नहीं हटा, लेकिन पूरे इस्राएलियों के घर में रोशनी थी. ");
INSERT INTO hincv_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","फ़रोह ने मोशेह को बुलवाया और कहा, “जाओ, याहवेह की वंदना करो! लेकिन अपने पशुओं और भेड़-बकरी यहीं छोड़ जाना. तुम्हारे बालक भी तुम्हारे साथ जा सकते हैं.” ");
INSERT INTO hincv_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","किंतु मोशेह ने उत्तर दिया, “हमें बलि तथा होमबलि के लिए पशु और भेड़-बकरी ले जाना ज़रूरी है ताकि हम याहवेह अपने परमेश्वर को बलि चढ़ा सकें. ");
INSERT INTO hincv_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","इसलिये हमारे पशु भी हमारे ही साथ जाएंगे; हम कुछ भी यहां नहीं छोड़ेंगे. जब तक हम अपनी जगह नहीं पहुंच जाते, हमें नहीं मालूम कि हमें याहवेह हमारे परमेश्वर की आराधना किस प्रकार करनी होगी.” ");
INSERT INTO hincv_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","किंतु याहवेह ने फ़रोह का मन कठोर बना दिया. वह उन्हें जाने नहीं दे रहा था. ");
INSERT INTO hincv_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","फ़रोह ने उनसे कहा, “दूर हो जाओ मेरे सामने से! फिर मत आना मेरे सामने! जिस दिन तुम मेरा मुंह देखोगे, तुम अवश्य मर जाओगे!” ");
INSERT INTO hincv_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","मोशेह ने जवाब दिया, “ठीक कहा तुमने! अब मैं तुम्हारा मुंह कभी न देखूंगा!” ");
INSERT INTO hincv_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","याहवेह ने मोशेह से कहा, “फ़रोह तथा मिस्र पर मैं एक और कष्ट भेजूंगा. इसके बाद वह तुम्हें यहां से जाने देगा; और वह ज़रूर तुम्हें यहां से निकालेगा. ");
INSERT INTO hincv_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","इस्राएलियों से यह कहो कि प्रत्येक पुरुष एवं स्त्री अपने-अपने पड़ोसी से सोना एवं चांदी मांग ले.” ");
INSERT INTO hincv_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","याहवेह ही ने मिस्रियों को इस्राएलियों के प्रति दयालु बना दिया. इसके अलावा मोशेह भी मिस्र देश में फ़रोह के सेवकों तथा मिस्री लोगों में महान बने थे. ");
INSERT INTO hincv_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","मोशेह ने कहा, “याहवेह का संदेश है, ‘आधी रात को मैं मिस्र देश के बीच में से निकल जाऊंगा. ");
INSERT INTO hincv_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","और मिस्र देश के हर पहले बेटे की मृत्यु हो जाएगी. फ़रोह के पहले बेटे से लेकर चक्की पीसने वाली का पहला बेटा और सब पशुओं का भी पहिलौठा मर जाएगा. ");
INSERT INTO hincv_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","तब पूरे देश में दुःख का माहौल होगा; ऐसा न तो कभी इससे पहले हुआ, न ऐसा फिर कभी होगा. ");
INSERT INTO hincv_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","पर इस्राएली मनुष्यों पर और उनके किसी पशु पर कोई कुत्ता न भौंकेगा ताकि यह समझ आ जाये कि यह याहवेह ही हैं जिन्होंने इस्राएलियों तथा मिस्रियों के बीच अंतर रखा है.’ ");
INSERT INTO hincv_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","तुम्हारे ये सभी सेवक मेरे पास आकर मुझे प्रणाम करेंगे और कहेंगे, आप चले जाइए और अपने सब लोगों को भी अपने साथ ले जाइए!” यह कहते हुए मोशेह बहुत गुस्से में फ़रोह के पास से निकल गए. ");
INSERT INTO hincv_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","इसके बाद याहवेह ने मोशेह से कहा, “फ़रोह तो अब भी तुम्हारी न सुनेगा, क्योंकि मैं मिस्र देश में और अद्भुत काम दिखाना चाहता हूं.” ");
INSERT INTO hincv_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","मोशेह तथा अहरोन ने सभी चमत्कार फ़रोह को दिखाए. फिर भी याहवेह ने फ़रोह का मन कठोर बनाए रखा, और फ़रोह इस्राएलियों को मिस्र देश से निकलने के लिए रोकता रहा. ");
INSERT INTO hincv_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","याहवेह ने मोशेह तथा अहरोन से कहा, ");
INSERT INTO hincv_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“तुम्हारे लिए यह महीना साल का पहला महीना होगा. ");
INSERT INTO hincv_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","सब इस्राएलियों को बता दो कि इस महीने की दस तारीख को अपने-अपने परिवार के लिए एक-एक मेमना चुनकर अलग कर ले. ");
INSERT INTO hincv_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","यदि एक परिवार एक पूरे जानवर को खाने के लिए बहुत छोटा है, तो उसे पड़ोस में दूसरे परिवार के साथ विभाग करना. प्रत्येक परिवार के आकार के अनुसार जानवर को विभाजित करें जितना वे खा सकते हैं. ");
INSERT INTO hincv_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","मेमना एक साल का नर हो, मेमने में कोई दोष न हो और यह भेड़ में से या बकरियों में से लिया जा सकता है. ");
INSERT INTO hincv_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","लेकिन इसी महीने के चौदहवें दिन तक मेमने का खास ध्यान रखना. फिर पूरे इस्राएली लोग मिलकर सूरज ढलने पर इसे बलि चढ़ाना. ");
INSERT INTO hincv_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","वे जिस घर में मेमने को खाएंगे, उस घर के दरवाजे के दोनों तरफ और दरवाजे के माथे पर मेमने का खून लगाएं. ");
INSERT INTO hincv_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ज़रूरी है कि इस मेमने का मांस उसी रात को आग में भूनकर, बिना खमीर की रोटी और कड़वी सब्जी के साथ खाएं. ");
INSERT INTO hincv_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","यह मांस न तो कच्चा खाएं और न उबाल कर, इसको आग में भूनकर इसके सिर, पांव तथा अंतड़ियां खानी है. ");
INSERT INTO hincv_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","इसमें से दूसरे दिन के लिए कुछ भी नहीं बचाना और अगर बच जाता है तो उसे पूरा आग में जलाकर राख कर देना. ");
INSERT INTO hincv_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","इसको खाते समय कमर पर कमरबंध बांधे, पांवों में जूते पहनकर हाथ में अपनी लाठी लेकर जल्दी से खाना; यही याहवेह का फ़सह पर्व होगा. ");
INSERT INTO hincv_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“क्योंकि उस रात मैं मिस्र देश में से होकर निकलूंगा और मिस्र देश की सभी पहली संतान—चाहे मनुष्य का हो या पशु का, सबको मार दूंगा; मैं ही याहवेह हूं और मैं मिस्र देश के सब देवताओं का भी न्याय करूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","जिस घर के दरवाजे पर मेमने के रक्त का निशान होगा उस घर को मैं छोड़ दूंगा किंतु मिस्र का नाश होगा. ");
INSERT INTO hincv_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“याद रहे कि यह दिन तुम्हारे लिए एक यादगार दिन हो. यह दिन याहवेह के उत्सव के रूप में मनाया करना और—यह तुम्हारी पीढ़ी से पीढ़ियों के लिए हमेशा मनाए जाते रहने के लिए एक नियम बनाया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","पहले दिन सब अपने-अपने घर से खमीर निकालकर फेंक देना और सात दिन तक बिना खमीर की रोटी खाना. अगर कोई इन सात दिनों में खमीर वाली रोटी खाएगा तो उसे इस्राएलियों के बीच से काट दिया जाएगा. ");
INSERT INTO hincv_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","पहले और सातवें दिन पवित्र सभा होगी. इन दोनों दिनों में कोई भी काम न करना; केवल वे ही व्यक्ति काम करें जिन्हें खाना बनाना हो. ");
INSERT INTO hincv_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“तुम्हारा अखमीरी रोटी का पर्व मनाना ज़रूरी है; क्योंकि यही वह दिन है, जिस दिन मैंने तुम्हें मिस्र देश से बाहर निकाला. यह एक यादगार दिन बनकर इन सब बातों को याद करते हुए यह उत्सव पीढ़ी से पीढ़ी तक मनाया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","पहले महीने की चौदहवी तारीख को शाम को बिना खमीर रोटी खाना होगा और यही खाना इक्कीसवीं तारीख की शाम तक खाना. ");
INSERT INTO hincv_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","इन सात दिनों में तुम्हारे घर में खमीर न रखना. और यदि कोई व्यक्ति खमीर वाला भोजन करता हुआ पाया गया, तो उसे इस्राएली प्रजा में से मिटा दिया जाएगा—चाहे वह विदेशी हो या स्वदेशी. ");
INSERT INTO hincv_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","किसी भी प्रकार का खमीर वाला भोजन करना मना है. अपने घरों में बिना खमीर की रोटी ही खाना.” ");
INSERT INTO hincv_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","तब मोशेह ने इस्राएलियों के सब प्रधानों को बुलाया और उनसे कहा, “जाकर अपने-अपने परिवारों के अनुसार एक-एक मेमना अलग कर लो, और फ़सह के मेमने की बलि करना. ");
INSERT INTO hincv_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","जूफ़ा नामक झाड़ी का गुच्छा लेकर उसे मेमने के रक्त में डुबोना, और दरवाजे के दोनों तरफ तथा ऊपर लगाना. तुममें से कोई भी सुबह तक इस दरवाजे से बाहर नहीं निकले, ");
INSERT INTO hincv_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","क्योंकि याहवेह उस समय मिस्रियों को मारते हुए निकल रहे होंगे. जिस घर के दरवाजे के दोनों तरफ और माथे पर मेमने का खून दिखेगा, उसे छोड़ते हुए आगे निकल जाएंगे और अंदर आकर किसी को नहीं मारेंगे. ");
INSERT INTO hincv_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“हमेशा तुम तथा तुम्हारी संतान इसे एक यादगार दिन के रूप में मनाया करना. ");
INSERT INTO hincv_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","जब तुम उस देश में जाओगे, जिसे याहवेह तुम्हें देंगे, वहां भी तुम इन बातों को मानना. ");
INSERT INTO hincv_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","जब तुम्हारे बालक तुमसे यह पूछें, ‘क्या मतलब है इस पर्व का जो मनाया जाता है?’ ");
INSERT INTO hincv_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तब तुम उन्हें उत्तर देना, ‘यह याहवेह के लिए फ़सह का बलिदान है, जिन्होंने मिस्रियों को मारते हुए हम इस्राएलियों को सुरक्षित रखा, अतः इसी कारण यह पर्व मनाया जाता है.’ ” फिर लोगों ने झुककर प्रणाम किया और परमेश्वर की आराधना की! ");
INSERT INTO hincv_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","इस्राएलियों ने वैसा ही किया; जैसा याहवेह ने मोशेह एवं अहरोन से कहा था. ");
INSERT INTO hincv_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","लगभग आधी रात को याहवेह ने मिस्र देश में सभी पहिलौंठों को मार दिया, फ़रोह से लेकर तथा जो बंदीगृह में थे और पशुओं के भी पहलौठे को मार दिया. ");
INSERT INTO hincv_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","रात में फ़रोह, उसके सेवक तथा सब मिस्रवासी जाग उठे क्योंकि पूरे मिस्र देश में रोने का शब्द सुनाई दे रहा था, कोई भी ऐसा परिवार न था, जहां किसी की मृत्यु न हुई हो. ");
INSERT INTO hincv_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","अतः फ़रोह ने रात में ही मोशेह तथा अहरोन को बुलवाया और उनसे कहा, “यहां से निकल जाओ और जैसा तुम चाहते हो, तुम इस्राएलियों समेत जाकर याहवेह की वंदना करो. ");
INSERT INTO hincv_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","अपने पशु एवं भेड़-बकरी भी अपने साथ ले जाओ, और मुझे आशीर्वाद देते जाना.” ");
INSERT INTO hincv_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","मिस्रवासी इस्राएलियों को जल्दी अपने बीच से भेज देना चाहते थे, क्योंकि उनको डर था कि कहीं उनकी भी मृत्यु न हो जाये. ");
INSERT INTO hincv_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","इससे पहले कि इस्राएलियों का गूंधा हुआ आटा खमीर हो जाये, उन्होंने उसे कटोरे में रखकर और कपड़ों में बांधकर अपने कंधों पर उठा लिया. ");
INSERT INTO hincv_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","इस्राएल वंश ने बिलकुल वही किया, जैसा उनसे मोशेह ने कहा था. उन्होंने मिस्र के लोगों से सोने-चांदी के गहने और वस्त्र मांग लिए थे. ");
INSERT INTO hincv_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","याहवेह ने इस्राएलियों को मिस्र के लोगों के मन में उनके प्रति ऐसी मनोवृत्ति दी कि मिस्रवासी इस्राएलियों की इच्छा पूरी करते गए. इस प्रकार इस्राएलियों ने पूरे मिस्रवासियों को लूट लिया. ");
INSERT INTO hincv_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","इस्राएली रामेसेस नामक स्थान से पैदल चलकर सुक्कोथ तक पहुंचे. इनमें स्त्रियों और बच्चों के अलावा छः लाख पुरुष थे. ");
INSERT INTO hincv_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","इन इस्राएलियों के साथ बहुत से मिश्रित वर्ग के लोग भी निकले और भेड़-बकरी, गाय-बैल और बहुत से पशु थे. ");
INSERT INTO hincv_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","उन्होंने गूंधे हुए आटे से, जो वे मिस्र देश से अपने साथ लाए थे, अपने लिए अखमीरी रोटियां बनाईं. क्योंकि वे मिस्र देश से बहुत जल्दी में निकाले गए थे, उनको वहां रुकने की और हिम्मत नहीं थी. वे तुरंत वहां से निकले और उन्हें अपने लिए खाना बनाने का भी समय नहीं मिला. ");
INSERT INTO hincv_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","मिस्र देश में इस्राएली चार सौ तीस वर्ष तक रहे. ");
INSERT INTO hincv_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","जिस दिन चार सौ तीस वर्ष पूरे हुए, उसी दिन याहवेह की सारी सेना मिस्र देश से निकल गई. ");
INSERT INTO hincv_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","जिस रात वे सब मिस्र से निकले वह रात उनके लिए विशेष रात कहलाई, यह याहवेह की महिमा की रात थी. जिसे, इस्राएल के सभी लोगों को तथा उनकी पूरी पीढ़ियों को, उस दिन को महत्व देना ज़रूरी था. ");
INSERT INTO hincv_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","याहवेह ने मोशेह एवं अहरोन को फ़सह का नियम समझाया: “इस्राएलियों के अलावा कोई भी परदेशी इस भोजन को न खाए. ");
INSERT INTO hincv_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","लेकिन जिस व्यक्ति को दाम देकर दास के रूप में खरीदा हो और उसका ख़तना कर लिया हो, वह व्यक्ति इस भोजन को खा सकता है. ");
INSERT INTO hincv_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","कोई भी परदेशी और मज़दूर इसमें शामिल न किया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“खाना एक ही घर में रहकर खाया जाए, और मांस का कोई भी टुकड़ा घर के बाहर न ले जाया जाए और मेमने की हड्डी भी न तोड़ी जाए. ");
INSERT INTO hincv_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","सभी इस्राएली इस उत्सव में शामिल हों. ");
INSERT INTO hincv_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“यदि कोई परदेशी मेहमान इस फ़सह में शामिल होना चाहता है तो, पहले सारे पुरुषों का ख़तना करके याहवेह के उस पर्व में उसे साथ लिया जा सकता है; तब वह उस देश के ही लोग समान हो जाएगा; लेकिन कोई भी बिना ख़तना किए इसमें शामिल न हो. ");
INSERT INTO hincv_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","नियम स्वदेशी और विदेशी सबके लिए एक जैसा ही हो.” ");
INSERT INTO hincv_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","सभी इस्राएलियों ने जैसा मोशेह तथा अहरोन को याहवेह ने आदेश दिया वैसा ही किया. ");
INSERT INTO hincv_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","यह वही दिन था, जब याहवेह ने इस्राएलियों को मिस्र देश से बाहर निकाला था. ");
INSERT INTO hincv_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","फिर याहवेह ने मोशेह से कहा: ");
INSERT INTO hincv_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“मनुष्य एवं पशु की पहली संतान मेरे लिए अलग करो. सब बच्‍चे, जो इस्राएल में पहिलौठे हैं, चाहे मनुष्य के हों, या पशु के, उन सभी पर मेरा ही अधिकार होगा.” ");
INSERT INTO hincv_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","मोशेह ने लोगों से कहा, “यह दिन याद रखना, जब तुम मिस्र से निकले थे—जब तुम ग़ुलामी में थे तब याहवेह ही ने अपने सामर्थ्यी हाथों द्वारा उस जगह से तुम्हें बाहर निकाला; इस कारण खमीर वाली कोई भी चीज़ न रखना. ");
INSERT INTO hincv_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","अबीब के महीने में आज के दिन तुम निकले हो. ");
INSERT INTO hincv_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","जब याहवेह तुम्हें तुम्हारे पूर्वजों से किए गए वायदे के अनुसार कनानी, हित्ती, अमोरी, हिव्वी तथा यबूसी जाति के देशों में पहुंचा देंगे, जहां दूध एवं मधु की धाराएं बहती हैं, तब तुम्हें इस दिन को मनाना ज़रूरी होगा. ");
INSERT INTO hincv_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","सात दिन बिना खमीर की रोटी खाना और सातवें दिन याहवेह के लिए उत्सव का दिन होगा. ");
INSERT INTO hincv_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","सातों दिन बिना खमीर की रोटी ही खाना. तुम्हारे बीच खमीर की कोई भी चीज़ न हो और पूरे देश से भी खमीर की कोई वस्तु न लाना. ");
INSERT INTO hincv_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","तुम अपने बच्चों को भी सच्चाई बताना, ‘यह सब इसलिये किया जाता है, क्योंकि जब हम मिस्र देश से निकले तब याहवेह ने हमारे लिए यह सब किया था.’ ");
INSERT INTO hincv_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","इस कारण तुम्हें भी इस दिन को उतना ही मनाना और याद रखना होगा, और याहवेह के नियम और व्यवस्था को कभी नहीं भूलना. यह हमेशा अपने माथे पर याद कराने वाली बात ठहरे और तुम्हारे हाथ में एक चिन्ह होगा, क्योंकि याहवेह ने अपनी सामर्थ्य के द्वारा तुम्हें मिस्र देश से बाहर निकाला था. ");
INSERT INTO hincv_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","इस कारण हर वर्ष इस विधि का सही समय पर पालन करना. ");
INSERT INTO hincv_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“तब याहवेह पूर्वजों से किए गए वायदे के अनुसार तुम्हें कनानियों के देश में पहुंचा कर तुम्हें उसका अधिकार देंगे, ");
INSERT INTO hincv_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","तब घर की हर पहली संतान को याहवेह को अर्पित करना ज़रूरी होगा, हर पशु का भी पहिलौठा याहवेह का होगा. हर एक पहिलौठे नर पर परमेश्वर का अधिकार होगा. ");
INSERT INTO hincv_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","गधी के पहिलौठे के बदले में मेमने को अलग कर सकते हो, और अगर मेमना न देना चाहो तो गदही के पहिलौठे का गला तोड़ देना. पर हर एक पहिलौठे पुत्र का बदला देकर छुड़ाना. ");
INSERT INTO hincv_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“जब, तुम्हारे पुत्र इसके बारे में तुमसे पूछें तब तुम बताना, ‘जब तुम गुलाम थे तब याहवेह ने कैसे अपनी सामर्थ्य से तुम्हें मिस्र देश से निकाला. ");
INSERT INTO hincv_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","मिस्र देश से फ़रोह हमें निकलने नहीं दे रहा था, तब याहवेह ने मिस्र देश में प्रत्येक पहिलौठे को मार दिया—चाहे वह मनुष्य का था या पशु का. इसलिये पशु के पहलौठे नर को याहवेह के लिए बलि करते हैं, किंतु मनुष्य के पहिलौठे को बदला देकर छुड़ा देते हैं.’ ");
INSERT INTO hincv_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","अब यह तुम्हारे हाथ पर चिन्ह के समान होगा तथा तुम्हारे माथे पर टीका समान होगा—क्योंकि याहवेह ने हमें मिस्र देश से अपने सामर्थ्यी हाथों के द्वारा निकाला था.” ");
INSERT INTO hincv_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","जब फ़रोह ने प्रजा को वहां से जाने को कहा, तब परमेश्वर उन्हें फिलिस्तीनियों के देश में से होकर नहीं ले गए, यह रास्ता बहुत छोटा था. लेकिन परमेश्वर का कहना था, “लड़ाई देखकर लोग मिस्र देश वापस चले न जाएं.” ");
INSERT INTO hincv_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","परमेश्वर उन्हें घुमाकर रेगिस्तानी रास्ते से लाल सागर की ओर ले गए ताकि मिस्र देश से निकलकर इस्राएली युद्ध के लिए तैयार होकर आगे बढ़ें. ");
INSERT INTO hincv_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","मोशेह ने अपने साथ योसेफ़ की अस्थियां भी ले लीं थी. क्योंकि योसेफ़ ने इस्राएलियों से शपथ करवाई थी, “निश्चय परमेश्वर तुम्हारी दशा पर ध्यान देंगे और जब तुम यहां से जाओ तब मेरी अस्थियों को भी अपने साथ ले जाना.” ");
INSERT INTO hincv_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","इस्राएलियों ने सुक्कोथ से चलना शुरू किया और एथाम में रुक गये, जो रेगिस्तान के किनारे पर ही था. ");
INSERT INTO hincv_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","याहवेह उन्हें मार्ग दिखाकर उनके आगे-आगे चले; दिन में बादल तथा रात में आग की रोशनी देकर उनको चलाया, ताकि वे दिन में तथा रात में भी आराम से चल सकें. ");
INSERT INTO hincv_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","दिन में बादल और रात में आग का खंभा लोगों के आगे-आगे चलता रहा याहवेह ने उनसे कभी दूर न हुए. ");
INSERT INTO hincv_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","याहवेह ने मोशेह से कहा, ");
INSERT INTO hincv_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इस्राएलियों को आदेश दो, कि वे मुड़ जाएं तथा पी-हाहीरोथ के पास, जो मिगदोल तथा सागर के बीच में है, अपना तंबू डालें. तंबू सागर तट पर बाल-जेफोन के विपरीत खड़े करना ");
INSERT INTO hincv_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ताकि फ़रोह यह समझे कि इस्राएली देश के उलझन से मरुस्थल में भटक रहे हैं. ");
INSERT INTO hincv_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","तब मैं फ़रोह के मन को कठोर कर दूंगा और वह इस्राएलियों का पीछा करता हुआ आएगा. तब मैं फ़रोह तथा उसकी सेना के द्वारा मेरी महिमा कराऊंगा, जिससे मिस्रवासियों को यह मालूम हो जाएगा कि मैं ही याहवेह हूं.” ");
INSERT INTO hincv_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","जब मिस्र के राजा को यह मालूम पड़ा कि वे लोग भाग गए हैं, तब फ़रोह तथा उसके सेवकों का मन बदल गया. वे आपस में कहने लगे: “हमने यह क्या कर दिया; हमने इस्राएलियों को जाने दिया?” ");
INSERT INTO hincv_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","फ़रोह ने अपना रथ तैयार करवाया और अपनी सेना को अपने साथ लिया. ");
INSERT INTO hincv_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","फ़रोह ने छः सौ अच्छे रथ अपने साथ लिए तथा अपने अधिकारियों को कहा कि मिस्र देश के सभी रथ एवं उनके चालक भी साथ आएं. ");
INSERT INTO hincv_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","याहवेह ने मिस्र देश के राजा फ़रोह का मन कठोर बना दिया. इस्राएली निश्चिंत होकर चले जा रहे थे; फ़रोह ने उनका पीछा किया. ");
INSERT INTO hincv_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","पर मिस्री अपने सब घोड़ों, रथों, चालकों तथा सेना को साथ लेकर इस्राएलियों का पीछा करते हुए सागर तट पर उनके तंबू के पास जा पहुंचे, जो पी-हाहीरोथ में बाल-जेफोन के विपरीत था. ");
INSERT INTO hincv_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","जब फ़रोह उनके निकट पहुंचा तो इस्राएलियों ने देखा कि मिस्री उनका पीछा करते हुए आ रहे हैं, तब वे बहुत डर गए और याहवेह को पुकारने लगे. ");
INSERT INTO hincv_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","वे मोशेह से लड़ने लगे, और कहने लगे, “क्या मिस्र देश में कब्र नहीं थी, जो आप हमें यहां ले आए हैं, कि हमारी मृत्यु यहां मरुभूमि में हो जाए? आपने हमसे ऐसा क्यों किया—क्यों आप हमें मिस्र देश से निकाल लाए? ");
INSERT INTO hincv_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","क्या हमने मिस्र में आपसे नहीं कहा था, ‘हमें यहीं रहने दीजिए, कि हम मिस्रियों की सेवा करते रहें’? इस निर्जन प्रदेश में मरने से अच्छा था कि हम मिस्रियों की सेवा करते रहते!” ");
INSERT INTO hincv_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","मोशेह ने लोगों से कहा: “मत डरो! स्थिर खड़े रहो और याहवेह का अद्भुत काम देखो, जो वह तुम्हारे लिए करेंगे; क्योंकि तुम आज जिन मिस्रियों को देख रहे हो, इसके बाद उन्हें फिर कभी भी न देखोगे. ");
INSERT INTO hincv_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","तुम चुप रहो, याहवेह ही तुम्हारे लिए लड़ेंगे.” ");
INSERT INTO hincv_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","तब याहवेह ने मोशेह से कहा, “क्यों मेरी दोहाई दे रहे हो? इस्राएलियों से कहो कि वे आगे बढ़ें. ");
INSERT INTO hincv_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","तुम्हारे लिए मेरा आदेश है कि अपनी लाठी समुद्र के ऊपर बढ़ाओ और जल दो भाग हो जाएंगे, जिससे इस्राएली सूखी भूमि से होकर चले जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","मैं मिस्रियों के मन को कठोर बना दूंगा और वे उनका पीछा करते हुए आएंगे. तब मैं फ़रोह की सेना, उसके रथों एवं सवारियों के ज़रिये अपनी महिमा करवाऊंगा. ");
INSERT INTO hincv_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","जब फ़रोह की सेना, उसके रथों एवं सवारियों के ज़रिये मेरी महिमा होगी तब मिस्र के लोग समझ जायेंगे कि मैं ही याहवेह हूं.” ");
INSERT INTO hincv_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","फिर परमेश्वर का स्वर्गदूत, जो अब तक इस्राएलियों के आगे-आगे जा रहा था, उनके पीछे आ गया तथा बादल भी आगे से हटकर उनके पीछे आ गए. ");
INSERT INTO hincv_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","इस प्रकार स्वर्गदूत और बादल इस्राएलियों तथा मिस्रियों के बीच आ गए. बादल के कारण एक ओर तो अंधकार था, लेकिन रात में उन्हें रोशनी भी मिलती रही. ");
INSERT INTO hincv_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","मोशेह ने समुद्र के ऊपर अपना हाथ बढ़ाया और याहवेह ने रात भर तेज हवा बहाई और समुद्र को दो भाग करके जल को पीछे हटा दिया, जिससे बीच की ज़मीन सूखी हो गयी. ");
INSERT INTO hincv_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","इस्राएली सूखी ज़मीन पर चलकर दूसरी ओर आ गए, क्योंकि जल उनके दोनों ओर दीवार बनकर खड़ा हो गया था. ");
INSERT INTO hincv_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","तब मिस्रियों ने इस्राएलियों का पीछा किया और फ़रोह के सभी घोड़े, उसके रथ तथा उनके चालक उनका पीछा करते हुए समुद्र के बीच आ गये. ");
INSERT INTO hincv_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","सुबह के समय याहवेह ने आग तथा बादल में से होकर मिस्री सेना को देखा. ");
INSERT INTO hincv_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","और उनके रथों के पहिये फंसा दिये ताकि वे आगे बढ़ नहीं पायें. मिस्री आपस में कहने लगे, “चलो, हम इस्राएलियों का पीछा करना छोड़कर भाग चलें—क्योंकि स्वयं याहवेह उनकी ओर से हमारे विरुद्ध लड़ रहे हैं.” ");
INSERT INTO hincv_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","फिर याहवेह ने मोशेह से कहा, “समुद्र के ऊपर अपना हाथ बढ़ा दो कि जल मिस्रियों, उनके रथों और उनके घुड़सवारों के ऊपर लौट आये.” ");
INSERT INTO hincv_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","मोशेह ने समुद्र पर अपना हाथ बढ़ाया और सुबह होने पर समुद्र पहले जैसा बहने लगा. तब तक मिस्री जल के बीच में आ गये थे. वे जब भाग रहें थे, तब याहवेह ने उन्हें समुद्र के बीच में ही डुबो दिया. ");
INSERT INTO hincv_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","समुद्र के बहाव ने रथों, चालकों तथा फ़रोह की पूरी सेना को डुबो दिया, जो इस्राएलियों का पीछा करते हुए समुद्र में पहुंची थी. उनमें से एक भी व्यक्ति जीवित न रहा. ");
INSERT INTO hincv_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","किंतु इस्राएली समुद्र के बीच में से सूखी भूमि पर चलते हुए पार हो गए. ");
INSERT INTO hincv_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","याहवेह ने उस दिन इस्राएल को मिस्रियों से बचाया. इस्राएलियों ने समुद्र में मिस्रियों के शव देखे. ");
INSERT INTO hincv_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","जब इस्राएलियों ने उस ताकतवर काम पर ध्यान दिया, जो याहवेह ने मिस्रियों से किया, वे याहवेह के प्रति श्रद्धापूर्ण डर से भर गए और उन्होंने याहवेह तथा उनके दास मोशेह पर विश्वास किया. ");
INSERT INTO hincv_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","तब मोशेह तथा इस्राएलियों ने याहवेह के लिए यह गीत गाया: “मैं याहवेह के लिए गीत गाऊंगा, क्योंकि वे अति महान परमेश्वर हैं. घोड़ों एवं चालकों को उन्होंने समुद्र में डाल दिया. ");
INSERT INTO hincv_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“याहवेह मेरा बल और मेरा गीत हैं, वही मेरा उद्धार बना हैं. यही हैं मेरे परमेश्वर, मैं उनकी स्तुति करूंगा; मेरे पिता के परमेश्वर, उनकी मैं प्रशंसा करूंगा, ");
INSERT INTO hincv_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","याहवेह योद्धा हैं और उनका नाम याहवेह है. ");
INSERT INTO hincv_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","याहवेह ने फ़रोह के रथों एवं उसकी सेना को समुद्र में फेंक दिया; उसके सभी अधिकारी लाल सागर में डूब गए, ");
INSERT INTO hincv_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","वे पत्थर के समान गहराइयों में डूब गये, और गहरा पानी ने उन्हें ढंक दिया. ");
INSERT INTO hincv_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","हे याहवेह, आपका दायां हाथ सामर्थ्य से भरा है. और आपका बायां हाथ शत्रु को चूर-चूर कर देता है. ");
INSERT INTO hincv_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“शत्रुओं को अपने बड़े पराक्रम से आप पराजित कर देते हैं, जो आपके विरुद्ध सिर उठाते हैं; आप उन पर अपना क्रोध प्रकट करते हैं. और उन्हें भूसे के समान जला देते है. ");
INSERT INTO hincv_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","आपके नथुनों की सांस से समुद्र का जल इकट्ठा हो गया और जल का बहाव रुक जाता है. बढ़ता पानी दीवार की तरह उठ खड़ा हुआ, समुद्र के हृदय में गहरा जल जमा हो गया! ");
INSERT INTO hincv_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","शत्रु ने कहा था, ‘मैं पीछा करूंगा, मैं उन्हें पकड़ लूंगा और लूटकर चीज़ों को बांट लूंगा तब मुझे तसल्ली मिलेगी, मैं तलवार निकालूंगा और अपने हाथ से उन्हें नष्ट कर दूंगा.’ ");
INSERT INTO hincv_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","आपने अपना सांस फूंका तब सागर ने उन्हें ढंक लिया. वे महा समुद्र में सीसे के समान डूब गए. ");
INSERT INTO hincv_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","हे याहवेह, देवताओं में आपके तुल्य कौन है? कौन है आपके समान, पवित्रता में सर्वोपरि, स्तुति के योग्य और अनोखे काम करनेवाले? ");
INSERT INTO hincv_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“आपने अपना दायां हाथ बढ़ाया और पृथ्वी ने उन्हें निगल लिया. ");
INSERT INTO hincv_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","आपने अपनी कृपा से छुड़ाए हुए लोगों को चलाया, आप अपने सामर्थ्य से उन्हें अपनी पवित्रता के स्थान में ले गए. ");
INSERT INTO hincv_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","देश-देश के लोग यह सब सुनकर घबरा जाएंगे; फिलिस्तीनियों पर डर छा जाएगा, ");
INSERT INTO hincv_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","एदोम के प्रधान निराश हो जायेंगे; मोआब के ताकतवर कांपने लगेंगे; कनान के निवासी उदास हो जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","याहवेह, जब तक आपकी प्रजा वहां से निकल न जाए, जब तक आपके द्वारा बचाये हुए लोग वहां से आ न जाए तब तक उनमें डर बना रहेगा; आपके बाहों की ताकत से वे अब पत्थर समान बन जाएंगे; ");
INSERT INTO hincv_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","आप उन्हें लाकर अपने पहाड़ पर बसाएंगे. उस स्थान पर, हे याहवेह, जो आपने अपने लिए अलग किया है; वही पवित्र स्थान, जिसे आपने अपने हाथों से बनाया है. ");
INSERT INTO hincv_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“याहवेह का राज्य सदा-सर्वदा स्थिर रहेगा.” ");
INSERT INTO hincv_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","जब फ़रोह के घोड़े, उसके रथों तथा चालकों के साथ सब समुद्र में डूब गए और याहवेह समुद्र के जल को उनके ऊपर ले आए—लेकिन इस्राएली समुद्र के बीच से सूखी भूमि पर चलते हुए निकल गए. ");
INSERT INTO hincv_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","तब अहरोन की बहन मिरियम ने, जो नबिया थी, खंजरी उठाई और उसके साथ सभी स्त्रियां अपने-अपने हाथों में खंजरी लेकर नाचने लगीं. ");
INSERT INTO hincv_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","मिरियम खुशी से गाने लगी, “याहवेह का गीत गाओ, क्योंकि वे अति महान हैं; उन्होंने तो घोड़ों को चालकों सहित समुद्र में डूबा दिया.” ");
INSERT INTO hincv_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","फिर मोशेह इस्राएलियों को लाल सागर से शूर के निर्जन देश में ले गए. वे तीन दिन पानी ढूंढ़ते रहे, किंतु उन्हें कहीं भी पानी का सोता नहीं दिखा. ");
INSERT INTO hincv_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","वे माराह नामक स्थान पर पहुंचे, किंतु माराह का पानी कड़वा था; इस कारण इस स्थान का नाम माराह पड़ा; ");
INSERT INTO hincv_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","इसलिये लोग मोशेह पर बड़बड़ाने लगे. वे कहने लगे, “हम क्या पिएंगे?” ");
INSERT INTO hincv_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","मोशेह ने याहवेह को पुकारा और याहवेह ने उन्हें एक लकड़ी का टुकड़ा दिखाया. जब मोशेह ने उस पेड़ को पानी में डाला, पानी मीठा बन गया. उसी जगह याहवेह ने उनके लिए एक नियम और विधि बनाई. ");
INSERT INTO hincv_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","याहवेह ने उनसे कहा, “यदि तुम याहवेह, तुम्हारे परमेश्वर के वचन को पूरे मन से मानोगे और सही काम करोगे, उनकी बातों पर ध्यान दोगे तथा उनके सब नियमों को मानोगे तो मिस्रियों के साथ घटित, ऐसी कोई परेशानी तुम पर नहीं आने दूंगा; क्योंकि मैं याहवेह राफ़ा हूं, अर्थात् चंगा करनेवाला हूं.” ");
INSERT INTO hincv_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","तब वे एलिम नामक स्थान पर पहुंचे, जहां बारह झरने तथा सत्तर खजूर के पेड़ थे. इस्राएलियों ने जल के स्रोतों के पास ही अपना पड़ाव डाला. ");
INSERT INTO hincv_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","फिर इस्राएली एलिम से चलकर सिन नामक निर्जन देश पहुंचे. यह एलिम एवं सीनायी के बीच में था. मिस्र देश से निकले दो महीने तथा पन्द्रह दिन हो चुके थे. ");
INSERT INTO hincv_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","इस निर्जन क्षेत्र में सभी इस्राएली मोशेह तथा अहरोन से नाराज होने लगे. ");
INSERT INTO hincv_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","इस्राएली कहने लगे, “अच्छा होता कि याहवेह ने हम लोगों को मिस्र में ही मार डाला होता, वहां हम मांस की हांडियों के पास बैठते थे और पेट भरकर रोटी खाते थे; आप तो हमें इस निर्जन देश में इसलिये ले आए हैं कि हम सारे लोग भूख से मर जाएं.” ");
INSERT INTO hincv_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","इस पर याहवेह ने मोशेह से कहा, “सुनो, मैं तुम्हारे लिए स्वर्ग से रोटी बरसाऊंगा, और प्रतिदिन लोग बाहर जाकर रोज अपनी ज़रूरत के अनुसार रोटी बटोर लें, मैं उन्हें जाचूंगा और देखूंगा कि वे मेरी आज्ञा मानते हैं या नहीं. ");
INSERT INTO hincv_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","छठे दिन जब वह बटोरे हुए भोजन वस्तु से खाना बनाएं तब वह अन्य दिनों से दुगना होगा.” ");
INSERT INTO hincv_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","मोशेह एवं अहरोन ने सब इस्राएलियों को कहा, “शाम को तुम समझ जाओगे कि याहवेह ही ने तुम्हें मिस्र देश से निकाला है. ");
INSERT INTO hincv_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","सुबह तुम्हें याहवेह का तेज दिखाई देगा, क्योंकि याहवेह ने तुम्हारा बड़बड़ाना सुन लिया है—हम कौन हैं, जो तुम इतना गुस्सा दिखा रहे हो?” ");
INSERT INTO hincv_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","मोशेह ने कहा, “अब याहवेह तुम्हें शाम को मांस और सुबह रोटी देंगे, क्योंकि याहवेह ने उनके विरुद्ध तुम्हारा बड़बड़ाना सुन लिया हैं. हम कौन होते हैं? तुम्हारा गुस्सा हम पर नहीं, परंतु याहवेह पर होता है.” ");
INSERT INTO hincv_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","फिर मोशेह ने अहरोन से कहा, “सभी इस्राएलियों से कहो, ‘याहवेह के पास आओ, क्योंकि उन्होंने तुम्हारा बड़बड़ाना सुन लिया है.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","जब अहरोन सभी इस्राएलियों से बात कर रहे थे, तब उन्होंने निर्जन देश की ओर देखा और उनको याहवेह का तेज बादल में दिखाई दिया. ");
INSERT INTO hincv_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","याहवेह ने मोशेह से कहा, ");
INSERT INTO hincv_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“मैंने इस्राएलियों का बड़बड़ाना सुन लिया है; उन्हें बता दो, ‘शाम को तुम्हें मांस और सुबह तुम्हें रोटी, पेट भरकर मिलेगी; तब तुम जान जाओगे कि मैं ही याहवेह, तुम्हारा परमेश्वर हूं.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","सायंकाल बटेरें उड़ती हुई आईं और छावनी को ढक लिया तथा सुबह छावनी के आस-पास ओस की एक परत पड़ी हुई दिखी. ");
INSERT INTO hincv_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","जब ओस की परत उठ गई, तब उन्होंने देखा कि ज़मीन पर एक पतली परत पड़ी हुई है, जैसे बर्फ. ");
INSERT INTO hincv_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","वे आपस में कहने लगे, “क्या है यह?” वे समझ नहीं पा रहे थे कि वह क्या चीज़ है! मोशेह ने बताया, “यही है वह रोटी, जो तुम्हारे खाने के लिए याहवेह ने दी है. ");
INSERT INTO hincv_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","और याहवेह की आज्ञा है, ‘हर व्यक्ति जितना खा सके उतना ही ले सब व्यक्ति अपने-अपने तंबू में हर व्यक्ति के लिये एक ओमेर के हिसाब से ले.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","इस्राएलियों ने वैसा ही किया. किसी ने कम तो किसी ने ज्यादा लिया. ");
INSERT INTO hincv_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","जिसने अधिक मात्रा में इकट्ठा कर लिया, उसने कुछ भी ज्यादा नहीं पाया और जिसने कम इकट्ठा किया, उसे कोई कमी न हुई. ");
INSERT INTO hincv_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","मोशेह ने उनसे कहा, “कोई भी व्यक्ति इस भोजन को दूसरे दिन के लिए मत रखना.” ");
INSERT INTO hincv_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","लेकिन कुछ लोगों ने मोशेह की बात नहीं मानी; और दूसरे दिन के लिए कुछ बचा रखा. दूसरे दिन उन्होंने देखा कि उसमें पूरे कीड़े पड़ गए और बदबू आने लगी. मोशेह ने उन पर गुस्सा किया. ");
INSERT INTO hincv_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","फिर रोज सुबह जितनी उनको ज़रूरत होती थी उतना ही वे लेते थे. ");
INSERT INTO hincv_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","और छठवें दिन हर व्यक्ति ने अगले दिन का भी खाना अपने-अपने लिए लिया और सभी ने जाकर मोशेह को बताया. ");
INSERT INTO hincv_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","यह सुनकर मोशेह ने उन्हें समझाया: “याहवेह ने यही कहा था: क्योंकि ‘कल विश्राम दिन है जो याहवेह को समर्पित महा पवित्र दिन, इसलिये आज ही जो कुछ पकाना है पका लो, और जो कुछ उबालना है उबाल लो और जो बच जाता है उसे अगले दिन के लिए अलग रख देना.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","उन्होंने बचा हुआ अगले दिन के लिए अलग रख दिया—जैसे मोशेह ने कहा. इसमें न तो बदबू आई और न कीड़े लगे. ");
INSERT INTO hincv_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","फिर मोशेह ने उनसे कहा, “आज तुम इसे खा लो, क्योंकि आज याहवेह को समर्पित विश्राम का पवित्र दिन है; आज बाहर खाना नहीं मिलेगा. ");
INSERT INTO hincv_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","तुम्हें छः दिन ऐसा ही करना होगा किंतु सातवें दिन, विश्राम का दिन है, उस दिन यह नहीं मिलेगा.” ");
INSERT INTO hincv_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","कुछ व्यक्ति सातवें दिन भी खाना बटोरने गये लेकिन उन्हें कुछ नहीं मिला. ");
INSERT INTO hincv_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","तब याहवेह ने मोशेह से कहा, “तुम और कब तक मेरे आदेशों और नियमों को नहीं मानोगे? ");
INSERT INTO hincv_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","यह विश्राम का दिन, याहवेह ने, अलग किया हुआ दिन है; याहवेह ही तुम्हें छठे दिन दो दिन का खाना देते हैं. और सातवें दिन सब अपने-अपने घर पर ही रहें—सातवें दिन कोई भी व्यक्ति अपने घर से बाहर न जाए.” ");
INSERT INTO hincv_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","इस्राएलियों ने सातवें दिन विश्राम का दिन मानना शुरू किया. ");
INSERT INTO hincv_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इस्राएलियों ने इस वस्तु को मन्‍ना नाम दिया. यह धनिये के बीज जितना सफेद और स्वाद शहद से बने पुओं के जैसा मीठा था. ");
INSERT INTO hincv_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","फिर मोशेह ने उनसे कहा, “याहवेह की यह आज्ञा है: ‘पीढ़ी से पीढ़ी तक सबको यह बताने और दिखाने के लिए एक ओमेर माप मन्‍ना रख लो ताकि तुम उनको बता सको कि जब मैं ने तुम्हें मिस्र देश से निकालकर लाया तब निर्जन देश में यही खाना खिलाया था.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","मोशेह ने अहरोन से कहा, “एक बर्तन में मन्‍ना लेकर याहवेह के सामने रखना ताकि आनेवाली पीढ़ियों के लिए वह यादगार रहे.” ");
INSERT INTO hincv_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","याहवेह के द्वारा मोशेह को दिए गए आदेश के अनुसार अहरोन ने मन्‍ना को वाचा के संदूक के पास रख दिया. ");
INSERT INTO hincv_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इस्राएली मन्‍ना तब तक खाते रहे जब तक उस प्रदेश में नहीं आ गए जहां उन्हें बसना था. वे कनान की सीमा जब तक नहीं पहुंच गए, तब तक उसे खाते रहे. ");
INSERT INTO hincv_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(एक माप ओमेर एफाह का दसवां भाग है.) ");
INSERT INTO hincv_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","फिर इस्राएल के सभी लोग सिन के निर्जन देश से निकले और एक स्थान से दूसरे स्थान पर कई चरणों में यात्रा करते गए, जैसा याहवेह ने आज्ञा दी थी. उन्होंने रेफीदीम में तंबू डाले. यहां उनको पीने के लिए पानी नहीं मिला. ");
INSERT INTO hincv_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","फिर वे मोशेह से यह कहते हुए झगड़ा करना शुरू कर दिया, “हमें पीने के लिए पानी दें!” मोशेह ने उनसे कहा, “क्यों मुझसे लड़कर याहवेह की परीक्षा करते हो?” ");
INSERT INTO hincv_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","लेकिन लोग बहुत प्यासे थे और वे मोशेह से कहते रहे, “आप हमें मिस्र देश से क्यों लाए हैं—क्या हमारे बच्‍चे और हमारे पशु प्यास से मर जायें?” ");
INSERT INTO hincv_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","तब मोशेह ने याहवेह से कहा, “मैं इन लोगों का क्या करूं? कुछ देर में तो ये मेरे ऊपर पथराव ही कर डालेंगे.” ");
INSERT INTO hincv_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","तब याहवेह ने मोशेह से कहा, “अपने साथ इस्राएल के कुछ लोगों को ले लो और उसी लाठी को जिससे नील नदी पर मारा था, लेकर आगे बढ़ो ");
INSERT INTO hincv_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","और मैं होरेब पर्वत की एक चट्टान पर तुम्हारे पास खड़ा रहूंगा. तुम उस चट्टान पर अपनी लाठी से मारना, तब उसमें से पानी निकलेगा ताकि लोग उससे पी सकें.” मोशेह ने वैसा ही किया. ");
INSERT INTO hincv_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","और उन्होंने उस स्थान का नाम मस्साह तथा मेरिबाह रख दिया, क्योंकि यहां इस्राएलियों ने बहस की और यह कहते हुए याहवेह को परखा था, “हमारे साथ याहवेह हैं या नहीं?” ");
INSERT INTO hincv_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","तब रेफीदीम में अमालेक इस्राएलियों से लड़ने लगे. ");
INSERT INTO hincv_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","मोशेह ने यहोशू से कहा, “अपनी ओर से युद्ध के लिए कुछ पुरुषों को अलग करे, ताकि वे जाकर अमालेकियों से युद्ध करें. कल मैं परमेश्वर की लाठी लेकर इस पहाड़ी के ऊपर खड़ा रहूंगा.” ");
INSERT INTO hincv_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","यहोशू ने वैसा ही किया और वे अमालेकियों से लड़ने गए उस समय मोशेह, अहरोन तथा हूर पहाड़ी के ऊपर पहुंच गए. ");
INSERT INTO hincv_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","जब मोशेह का हाथ ऊपर रहता, इस्राएली जीत जाते, और जब मोशेह अपना हाथ नीचे करते, अमालेक जीत जाते. ");
INSERT INTO hincv_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","जब मोशेह के हाथ थक गये तब उन्होंने एक पत्थर लाकर वहां रखा और मोशेह उस पर बैठ गए और अहरोन और हूर ने उनके दोनों हाथों को ऊपर उठाए रखा. शाम तक मोशेह का हाथ ऊपर रहा. ");
INSERT INTO hincv_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","इस प्रकार यहोशू ने अमालेकियों को तलवार की ताकत से हरा दिया. ");
INSERT INTO hincv_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","फिर याहवेह ने मोशेह से कहा, “इस बात को याद रखने के लिए किताब में लिख दो और यहोशू को पढ़कर सुनाना कि मैं पृथ्वी पर से अमालेकियों को मिटा डालूंगा.” ");
INSERT INTO hincv_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","मोशेह ने एक वेदी बनाई और उसका नाम याहवेह निस्सी रखा. ");
INSERT INTO hincv_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","मोशेह ने कहा, “याहवेह पीढ़ी से पीढ़ी तक अमालेकियों से युद्ध करते रहेंगे, क्योंकि उन्होंने याहवेह के सिंहासन के विरुद्ध हाथ उठाया हैं.” ");
INSERT INTO hincv_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","मिदियान के पुरोहित, मोशेह के ससुर येथ्रो को यह सब बात मालूम पड़ी कि कैसे परमेश्वर ने मोशेह तथा अपनी प्रजा इस्राएलियों को याहवेह ने मिस्र देश से बाहर निकाला. ");
INSERT INTO hincv_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","मोशेह ने अपनी पत्नी ज़ीप्पोराह और दोनों बेटों को उनके पिता येथ्रो के पास छोड़ दिया था, ");
INSERT INTO hincv_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","उनके एक पुत्र का नाम गेरशोम रखा क्योंकि मोशेह ने कहा, “मैं दूसरे देश में परदेशी हो गया!” ");
INSERT INTO hincv_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","दूसरे पुत्र का नाम एलिएज़र रखा, क्योंकि मोशेह ने यह कहा था, “मेरे पिता के परमेश्वर मेरे सहायक रहे हैं, जिन्होंने मुझे फ़रोह की तलवार से बचाया है.” ");
INSERT INTO hincv_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","इस निर्जन प्रदेश में जहां इस्राएलियों ने परमेश्वर के पर्वत पर तंबू डाला हुआ था, वहां मोशेह के ससुर, मोशेह की पत्नी तथा दोनों पुत्रों को अपने साथ लेकर आया. ");
INSERT INTO hincv_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","येथ्रो ने मोशेह से कहा, “मैं येथ्रो, तुम्हारा ससुर, तुम्हारी पत्नी एवं दोनों पुत्रों को लेकर तुमसे मिलने आया हूं.” ");
INSERT INTO hincv_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","यह सुन मोशेह अपने ससुर से मिलने तंबू से बाहर आये, उनको प्रणाम करके चुंबन किया, और एक दूसरे का हाल पूछा और मोशेह उन्हें अपने तंबू में ले गए. ");
INSERT INTO hincv_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","मोशेह ने अपने ससुर को सब बातें बताई, जो इस्राएलियों के लिए याहवेह ने फ़रोह तथा मिस्रियों के साथ की थी. मोशेह ने उन्हें सब परेशानियां भी बताईं, जिनका सामना उन्होंने इस यात्रा में किया था, तथा यह भी कि याहवेह ने किस तरह से उनको रास्ते भर बचाया. ");
INSERT INTO hincv_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","येथ्रो ने जब सुना कि याहवेह ने कैसे इस्राएलियों को संभाला. वे बहुत खुश हुए, कि याहवेह ने इस्राएलियों पर अपनी भलाई की और मिस्रियों से छुड़ाया. ");
INSERT INTO hincv_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","तब येथ्रो ने कहा, “धन्य हैं याहवेह, जिन्होंने तुम्हें मिस्रियों एवं फ़रोह के अधिकार से छुड़ाया और उनके बंधन से आज़ाद कराया. ");
INSERT INTO hincv_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","अब मैं जान गया हूं कि याहवेह ही अन्य सभी देवताओं से अधिक शक्तिशाली और बड़े हैं. यह तो उसी समय प्रमाणित हो गया था, जब मिस्रियों ने इस्राएलियों पर अपना अहंकार दिखाया था.” ");
INSERT INTO hincv_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","तब मोशेह के ससुर येथ्रो ने परमेश्वर के लिए होमबलि एवं मेल बलि चढ़ाई तथा अहरोन सभी इस्राएलियों और मोशेह के ससुर के साथ मिलकर परमेश्वर के आगे भोजन करने आये. ");
INSERT INTO hincv_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","दूसरे दिन मोशेह लोगों के न्याय करने के लिये न्यायाधीश के आसन पर बैठे हुए थे और लोग सुबह से शाम तक मोशेह के आस-पास खड़े रहे. ");
INSERT INTO hincv_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","जब मोशेह के ससुर ने मोशेह को देखा, तो उन्होंने मोशेह से पूछा, “तुम यह सब इस प्रकार क्यों कर रहे हो? जब ये सारे लोग सुबह से शाम तक तुम्हारे आस-पास खड़े थे, तुम अकेले ही सब क्यों संभाल रहे हो?” ");
INSERT INTO hincv_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मोशेह ने जवाब दिया, “लोग मेरे पास आते हैं क्योंकि वे अपने लिए परमेश्वर की इच्छा जानना चाहते हैं. ");
INSERT INTO hincv_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","यदि किसी व्यक्ति की अपने पड़ोसी से कोई बहस होती है और वे मेरे पास आते हैं, तब मैं उस व्यक्ति तथा उसके पड़ोसी के विषय में फैसला करके उनको परमेश्वर के नियम तथा उनकी विधियां बता देता हूं.” ");
INSERT INTO hincv_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","मोशेह के ससुर ने जवाब दिया: “तुम्हारा काम सही नहीं हैं. ");
INSERT INTO hincv_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","तुम और ये लोग जो तुम्हारे साथ हैं, परेशान हो जाएंगे, क्योंकि यह काम बहुत बड़ा है और तुम अकेले यह सब नहीं कर पाओगे. ");
INSERT INTO hincv_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","इसलिये मेरी बात सुनो, मैं तुम्हें यह सलाह देना चाहता हूं कि परमेश्वर तुम्हारे साथ रहें—तुम परमेश्वर के सम्मुख लोगों के प्रतिनिधि रहो और उनके विवाद परमेश्वर के सम्मुख लाओ. ");
INSERT INTO hincv_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","तुम उन्हें नियमों और व्यवस्था की बातें सिखाते जाओ और उन्हें किस तरह रहना हैं और उनकी आदतें कैसी हों यह सिखाओ, और कौन-कौन से काम उन्हें करने हैं यह बताते जाओ. ");
INSERT INTO hincv_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","साथ ही तुम इन लोगों में से कुछ ऐसे लोगों को चुन लो—जो सच्चाई से परमेश्वर के भय और श्रद्धा में जीने वाले हों, तथा अन्याय के लाभ से नफरत करते हों. इस प्रकार के व्यक्तियों को अलग करके, लोगों को झुंड में बांटकर, जवाबदारी उनको दे दो, जो हजार-हजार, सौ-सौ, पचास-पचास तथा दस-दस लोगों का झुंड हो. ");
INSERT INTO hincv_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ये ज़िम्मेदार व्यक्ति ही उन लोगों की बात सुनें और सुलझायें और जो बात न सुलझ पाए तब ही वे तुम्हारे पास आएं. तब तुम्हारा बोझ हल्का हो जाएगा और पूरे लोगों पर अच्छी तरह नियंत्रण रख पाओगे. ");
INSERT INTO hincv_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","यदि परमेश्वर ऐसा करने की आज्ञा देते हैं, तो ऐसा ही करना, तब तुम्हारा काम आसान हो जाएगा तथा ये लोग भी शांति से अपनी जगह पहुंच सकेंगे.” ");
INSERT INTO hincv_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","मोशेह ने अपने ससुर की बात पर ध्यान दिया और वैसा ही किया. ");
INSERT INTO hincv_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","सभी इस्राएलियों में से उन्होंने सक्षम व्यक्तियों को अगुआ बनाया; जो हजार-हजार, सौ-सौ, पचास-पचास तथा दस-दस लोगों के समूह के ऊपर अधिकारी थे. ");
INSERT INTO hincv_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","वे अधिकारी सभी समय लोगों का न्याय करते थे, केवल बहुत मुश्किल विवाद ही मोशेह के पास लाते थे, लेकिन साधारण मामलों का समाधान वे ही करते थे. ");
INSERT INTO hincv_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","मोशेह ने अपने ससुर को विदा कर दिया. वह विदा होकर अपने घर लौट गये. ");
INSERT INTO hincv_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","इस्राएलियों के मिस्र छोड़ने के तीसरे महीने के पहले दिन वे सीनायी के रेगिस्तान में आए, उसी दिन जब उन्हें मिस्र से निकलकर दो महीने पूरे हो गये थे. ");
INSERT INTO hincv_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","पहले वे रेफीदीम नामक स्थान में गये, फिर वहां से वह सीनायी के निर्जन देश में आये, फिर उन्होंने अपना पड़ाव निर्जन देश में डाला जो पर्वत के सामने था. ");
INSERT INTO hincv_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","मोशेह परमेश्वर के पास पर्वत पर गये, याहवेह ने मोशेह को पर्वत से बुलाया. याहवेह ने मोशेह से कहा, “याकोब के घराने से व इस्राएल से कहना: ");
INSERT INTO hincv_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘तुमने देखा है कि मैंने मिस्रियों के साथ क्या-क्या किया, और किस प्रकार मैं तुम्हें उकाब के तरह पंखों में बैठाकर यहां अपने पास ले आया हूं. ");
INSERT INTO hincv_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","अब यदि तुम वास्तव में मेरे आदेशों को मानोगे, तथा मेरी वाचा का पालन करोगे, तब सब जनता के बीच तुम मेरी अपनी प्रजा कहलाओगे—क्योंकि पूरी पृथ्वी ही मेरी है. ");
INSERT INTO hincv_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","तुम मेरे लिये राजकीय पुरोहित तथा पवित्र राष्ट्र माने जाओगे.’ तुम यह बातें इस्राएल से कहना!” ");
INSERT INTO hincv_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","तब मोशेह पर्वत से उतरे और सभी अधिकारियों को बुलवाया और उनसे याहवेह की सब बातें बताई जो पर्वत पर याहवेह ने कही थी. ");
INSERT INTO hincv_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","फिर सब मिलकर एक साथ बोले, “हम सब बात मानेंगे जो याहवेह ने कहा है!” मोशेह ने जाकर लोगों का जवाब याहवेह को बता दिया. ");
INSERT INTO hincv_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","याहवेह ने मोशेह से कहा, “अब सुनो, मैं एक बादल के अंधियारें में से होकर तुमसे बात करूंगा और जब मैं तुमसे बात करूंगा, तब सब लोग मेरी आवाज को सुनें और उनका विश्वास तुम पर बढ़ जाये.” तब मोशेह ने परमेश्वर को वे सभी बातें बताई जो लोगों ने कहीं थीं. ");
INSERT INTO hincv_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","याहवेह ने मोशेह से कहा, “लोगों के पास जाओ और उन्हें आज और कल पवित्र करना. वे सब अपने-अपने वस्त्र धोएं, ");
INSERT INTO hincv_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","और तीसरे दिन अपने आपको तैयार करें; क्योंकि तीसरे दिन याहवेह सीनायी पर्वत पर लोगों के सामने उतरेंगे. ");
INSERT INTO hincv_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","और तुम लोगों के चारों तरफ बाड़ा बांध देना और कोई भी पर्वत पर न चढ़े और इसकी सीमा को भी न छुए और यदि कोई उसे छुएगा वह मर जायेगा. ");
INSERT INTO hincv_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","और कोई भी उस व्यक्ति को न छुए. अगर कोई उस व्यक्ति को छुएगा उसे पत्थर से या तीर से मार दिया जाये—चाहे वह पशु हो या मनुष्य, उसे जीवित नहीं छोड़ा जाए. जब तुरही का शब्द देर तक सुनाई दे, तब सब पर्वत के पास आ जाएं.” ");
INSERT INTO hincv_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","तब मोशेह पर्वत से उतरकर लोगों के बीच आ गए और लोगों को पवित्र किया और सबने अपने वस्त्र धो लिए. ");
INSERT INTO hincv_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","लोगों से मोशेह ने कहा, “तीसरे दिन के लिए अपने आपको तैयार करो. इस समय स्त्री-पुरुष आपस में न मिलें.” ");
INSERT INTO hincv_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","तीसरे दिन, सुबह होते ही, पर्वत पर अंधकार छा गया, बादल गरजने और बिजली चमकने लगी, फिर नरसिंगे की तेज आवाज सुनाई दी और सभी लोग कांपने लगे. ");
INSERT INTO hincv_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","मोशेह सभी को परमेश्वर से मिलाने छावनी से बाहर लाए. वे सभी पर्वत के नीचे खड़े हुए. ");
INSERT INTO hincv_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","पूरा सीनायी पर्वत धुएं से भरा था, क्योंकि याहवेह आग में होकर उतरे थे और धुआं ऊपर उठ रहा था, जिस प्रकार भट्टी का धुआं ऊपर उठता है. पूरा पर्वत बहुत कांप रहा था. ");
INSERT INTO hincv_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","फिर जब नरसिंगे का शब्द तेज होता गया, तब मोशेह ने परमेश्वर से बात की और परमेश्वर ने उन्हें जवाब दिया. ");
INSERT INTO hincv_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","याहवेह सीनायी पर्वत के ऊपर उतरे और परमेश्वर ने मोशेह को ऊपर आने को कहा और मोशेह ऊपर गए. ");
INSERT INTO hincv_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","तब याहवेह ने मोशेह से कहा, “नीचे जाकर सबसे कहो कि मुझे देखने की इच्छा में सीमा पार न कर दें, और सब नष्ट न हो जाएं. ");
INSERT INTO hincv_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","और पुरोहित भी, जो मेरे पास आने के लिए अलग किए गए हैं, वे भी अपने आपको पवित्र करें, ताकि याहवेह उन्हें नष्ट न करें.” ");
INSERT INTO hincv_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मोशेह ने याहवेह से कहा, “लोग सीनायी पर्वत पर नहीं आएंगे, क्योंकि आप पहले ही बता चुके हैं कि पर्वत के आस-पास बाड़ा लगाकर उसे पवित्र रखना.” ");
INSERT INTO hincv_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","याहवेह ने मोशेह से कहा, “तुम नीचे जाओ और फिर तुम और अहरोन दोनों पर्वत पर आना. परंतु इस्राएली और पुरोहित सीमा पार न करने पाएं.” ");
INSERT INTO hincv_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","मोशेह पर्वत से नीचे आए और लोगों को सब बातें बताईं. ");
INSERT INTO hincv_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","तब परमेश्वर ने कहा: ");
INSERT INTO hincv_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“मैं ही हूं याहवेह, तुम्हारा परमेश्वर, जिसने तुम्हें मिस्र देश के बंधन से छुड़ाया. ");
INSERT INTO hincv_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“मेरे अलावा तुम किसी दूसरे को ईश्वर नहीं मानोगे. ");
INSERT INTO hincv_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","तुम अपने लिए न तो आकाश की, न पृथ्वी की, और न जल की किसी वस्तु की मूर्ति बनाना. ");
INSERT INTO hincv_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","न इनमें से किसी को दंडवत करना और न उसकी आराधना करना—मैं, याहवेह, जो तुम्हारा परमेश्वर हूं, जलन रखनेवाला परमेश्वर हूं, जो मुझे अस्वीकार करते हैं, मैं उनके पापों का प्रतिफल उनके बेटों को, पोतों और परपोतों को तक दूंगा, ");
INSERT INTO hincv_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","किंतु उन हजारों पीढ़ियों पर, जिन्हें मुझसे प्रेम है तथा जो मेरे आदेशों का पालन करते हैं, अपनी करुणा प्रकट करता रहूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","तुम याहवेह, अपने परमेश्वर के नाम का गलत इस्तेमाल नहीं करोगे, क्योंकि याहवेह उस व्यक्ति को बिना दंड दिए नहीं छोड़ेंगे, जो याहवेह का नाम व्यर्थ में लेता है. ");
INSERT INTO hincv_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","शब्बाथ को पवित्र दिन के रूप में मानने को याद रखो. ");
INSERT INTO hincv_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","छः दिन मेहनत करते हुए तुम अपने सारे काम पूरे कर लोगे, ");
INSERT INTO hincv_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","मगर सातवां दिन याहवेह तुम्हारे परमेश्वर का शब्बाथ है; इस दिन तुम कोई भी काम नहीं करोगे; तुम, तुम्हारे पुत्र-पुत्रियां, तुम्हारे पुरुष अथवा महिला सेवक न तुम्हारे सारे पशु अथवा तुम्हारे यहां रहनेवाले विदेशी, तुम्हारे सेवक-सेविकाएं भी तुम्हारे समान विश्राम करें. ");
INSERT INTO hincv_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","क्योंकि याहवेह ने इन छः दिनों में आकाशमंडल और पृथ्वी, तथा समुद्र और सभी की सृष्टि की, तथा सातवें दिन याहवेह ने कोई काम नहीं किया; तब याहवेह ने सातवें दिन को पवित्र ठहराया. ");
INSERT INTO hincv_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","तुम अपने पिता एवं अपनी माता का आदर करना, ताकि वह देश, जो याहवेह तुम्हारे परमेश्वर, तुम्हें देनेवाले हैं, उसमें तुम बहुत समय तक रह पाओ. ");
INSERT INTO hincv_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","तुम मानव हत्या नहीं करना. ");
INSERT INTO hincv_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","तुम व्यभिचार नहीं करना. ");
INSERT INTO hincv_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","तुम चोरी नहीं करना. ");
INSERT INTO hincv_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","तुम अपने पड़ोसी के विरुद्ध झूठी गवाही नहीं देना. ");
INSERT INTO hincv_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","तुम अपने पड़ोसी के घर का लालच नहीं करना; तुम अपने पड़ोसी की पत्नी का लालच नहीं करना; न किसी सेवक, सेविका का; अथवा उसके बैल अथवा गधे का—उसकी किसी भी वस्तु का लालच नहीं करना.” ");
INSERT INTO hincv_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","सभी इस्राएली बादल के गरजने तथा बिजली के चमकने तथा नरसिंगे के शब्द एवं पर्वत से धुंआ उठते हुए देखते रहे, और डरते और कांपते हुए दूर खड़े रहे. ");
INSERT INTO hincv_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","उन्होंने मोशेह से कहा, “स्वयं आप ही हमसे बात कीजिए, किंतु परमेश्वर को हमसे बात न करने दीजिए. कहीं ऐसा न हो, कि हम मर जाएं.” ");
INSERT INTO hincv_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मोशेह ने लोगों से कहा, “डरो मत; क्योंकि परमेश्वर यहां इसलिये आए हैं कि वह तुम्हें जांचें, ताकि उनके प्रति तुम्हारे मन में भय और श्रद्धा हो और तुम पाप न करो.” ");
INSERT INTO hincv_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","तब लोग दूर ही खड़े रहे, किंतु मोशेह उस घने बादल की ओर बढ़ते गए, जहां परमेश्वर की उपस्थिति थी. ");
INSERT INTO hincv_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","तब याहवेह ने मोशेह से कहा, “इस्राएलियों से यह कहना कि तुमने देखा कि याहवेह ने स्वर्ग से कैसे बात की है. ");
INSERT INTO hincv_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","तुम मेरे सिवाय किसी भी अन्य देवता को न मानना, और अपने लिए न चांदी की, न सोने की मूर्ति बनाना. ");
INSERT INTO hincv_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ मेरे लिए तुम मिट्टी से वेदी बनाना. इसी पर तुम गाय-बैलों तथा बछड़ों की होमबलि एवं मेल बलि चढ़ाना. और मेरी महिमा करना और मैं आकर तुम्हें आशीष दूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","यदि तुम्हें पत्थर से वेदी बनानी पड़े, तो ऐसा पत्थर लेना जिस पर कभी हथियार नहीं चलाया गया हो, ");
INSERT INTO hincv_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","सीढ़ियों से वेदी पर चढ़ना नहीं, चढ़े तो लोग तुम्हारी नग्नता को देख सकेंगे.” ");
INSERT INTO hincv_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“ये और जो नियम, तुम्हें उनको बताने हैं वे ये है: ");
INSERT INTO hincv_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“यदि तुम दास के लिए किसी इब्री को खरीदो तब वह छः वर्ष तक सेवा करे; और सातवें वर्ष वह दाम बिना चुकाए भी जा सकता है. ");
INSERT INTO hincv_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","यदि वह अकेला ही आया हो, तो अकेला ही जाये. यदि वह किसी स्त्री का पति है, तो उसकी पत्नी भी उसी के साथ लौट जाएगी. ");
INSERT INTO hincv_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","यदि उस दास की पत्नी होने के लिए स्त्री को मालिक ने भेजा हो और उस स्त्री के पुत्र-पुत्रियां पैदा हो गई हों, तो दास अकेला ही जाये किंतु उसकी पत्नी एवं संतान मालिक के ही रहेंगे. ");
INSERT INTO hincv_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“यदि वह दास कहे कि मुझे तो, मेरे मालिक, मेरी पत्नी एवं मेरी संतान प्रिय हैं; मैं जाना नहीं चाहता, तो ");
INSERT INTO hincv_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","उसका मालिक उसे लेकर परमेश्वर के पास आए, और उस दास को दरवाजे के पास ले जाये और उसका मालिक उसके कान को सुई से छेद दे. इसके बाद वह दास उस मालिक का सेवक हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“यदि कोई व्यक्ति अपनी पुत्री को दासी होने के लिए देता है, तो उसे दासी के समान न छोड़े. ");
INSERT INTO hincv_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","यदि उसका मालिक, जिसने उसे खरीदा है, उससे प्रसन्‍न नहीं है, तो मालिक उसे दाम देकर छोड़ दे. लेकिन मालिक को यह अधिकार नहीं है कि वह दासी को विदेशियों में बेच दे, क्योंकि उसने उसके साथ विश्वासघात किया है. ");
INSERT INTO hincv_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","यदि वह व्यक्ति इस दासी को अपने पुत्र की पत्नी होने के लिए चाहता है, तो उसे बेटियों के समान हक भी देना ज़रूरी है. ");
INSERT INTO hincv_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","यदि वह किसी अन्य स्त्री से विवाह कर लेता है, तो वह इस दासी को भोजन, वस्त्र तथा उसके वैवाहिक अधिकारों से दूर नहीं रख सकता. ");
INSERT INTO hincv_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","यदि मालिक उसके विषय में उन तीनों अधिकारों को पूरा न करे, तब वह दासी बिना दाम दिये उसे छोड़कर जा सकती है. ");
INSERT INTO hincv_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“यदि कोई व्यक्ति किसी पर ऐसा हमला करे कि उसकी मृत्यु हो जाए, तब अवश्य उस व्यक्ति को मृत्यू-दंड ही दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","किंतु यदि यह हत्या पहले से नियोजित नहीं की गई हो, किंतु यह मृत्यु परमेश्वर की इच्छा से हुई हो, तब मैं तुम्हारे लिए एक ऐसी जगह बनाऊंगा, जहां तुम भागकर जा सकोगे. ");
INSERT INTO hincv_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","किंतु यदि कोई व्यक्ति किसी को पूर्व नियोजित तरीके से छलपूर्वक, गुस्से से उसकी हत्या कर देता है, तो तुम उस व्यक्ति को, मेरी वेदी से मृत्यु दंड देने के लिए ले जा सकते हो. ");
INSERT INTO hincv_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“यदि कोई अपने पिता अथवा अपनी माता को मारे, तो उसे मृत्यु दंड दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“जो किसी मनुष्य का अपहरण करता है, चाहे वह अपहृत को बेच दें या उसके पास हो, तो भी उसे मृत्यु दंड दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“जो अपने पिता अथवा अपनी माता को शाप देता है, उसे निश्चयतः मृत्यु दंड दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“यदि दो व्यक्तियों में झगड़ा हो जाए, वह एक दूसरे को पत्थर अथवा घूंसे से मारे, जिससे उसकी मृत्यु न हुई हो लेकिन वह चल फिर न सके, ");
INSERT INTO hincv_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","यदि वह व्यक्ति लाठी के सहारे चल फिर सके, तब जिसने उसको मारा था, वह दंड के योग्य न होगा—लेकिन उसे ठीक होने तक उसके देखरेख का ख़र्चा उसे देना होगा. ");
INSERT INTO hincv_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“यदि कोई व्यक्ति दंड देते हुए अपने दास या दासी पर लाठी से मार दे और उसकी मृत्यु हो जाए, तो उसे उसके लिए सजा दी जाए. ");
INSERT INTO hincv_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","किंतु यदि वह व्यक्ति मार खाने के बाद एक-दो दिन बाद ठीक हो जाये, तो उसे सजा न दी जाये; क्योंकि दास या दासी उसी की संपत्ति है. ");
INSERT INTO hincv_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“यदि लोगों के झगड़े में गर्भवती स्त्री को चोट लग जाये और उसका समय से पूर्व प्रसव हो जाए, किंतु कोई नुकसान न हुआ हो, तो निश्चयतः उस व्यक्ति को, जिसने मारा है, उस स्त्री का पति जो भी मांगे और पंच जो भी फैसला करें और जो भी निर्णय होता है वह उसे चुकाए. ");
INSERT INTO hincv_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","और यदि चोट ज्यादा है तो, पंच प्राण के बदले प्राण का भी फैसला कर सकते हैं, ");
INSERT INTO hincv_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","आंख के लिए आंख, दांत के लिए दांत, हाथ के लिए हाथ, पैर के लिए पैर, ");
INSERT INTO hincv_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","दाह के लिए दाह, घाव के लिए घाव तथा मार के बदले मार का दंड हो. ");
INSERT INTO hincv_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“यदि किसी व्यक्ति की मार से उसके दास अथवा दासी की आंख नष्ट हो जाये, तो उसे उसकी आंख के बदले उस दास अथवा दासी को छोड़ दे. ");
INSERT INTO hincv_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","यदि झगड़े में उसके दास अथवा दासी का दांत टूट जाये, तो उसे इस नुकसान के कारण उस दास अथवा दासी को छोड़ देना होगा. ");
INSERT INTO hincv_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“यदि कोई बैल के सींग से किसी पुरुष अथवा स्त्री की मृत्यु हो जाती है, तो निश्चयतः उस बैल को पत्थर से मार दें तथा उसके मांस को काम में न लें; लेकिन उस बैल के मालिक को कोई दंड न दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","किंतु यदि कोई ऐसा बैल है, जो हमेशा लोगों को सींग मारकर नुकसान पहुंचाता है और बैल के मालिक को बताया गया हो और बैल को बांधकर नहीं रखा और उस बैल ने किसी पुरुष अथवा स्त्री की हत्या कर दी है, तो इस स्थिति में वह बैल तथा उसके मालिक, दोनों ही का पथराव किया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","यदि बैल का स्वामी छुड़ाई देना चाहे तो धनराशि जो इसके लिए ठहराई गई है, पूरा देकर छूट सकता है. ");
INSERT INTO hincv_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","चाहे बैल ने पुत्र को मार डाला हो अथवा पुत्री को, उसके साथ नियम के अनुसार फैसला किया जाएगा. ");
INSERT INTO hincv_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","यदि बैल किसी दास अथवा दासी को मार डाले, तो बैल के मालिक को उस दास अथवा दासी के मालिक को चांदी के तीस सिक्‍के देने होंगे, तथा बैल का पथराव किया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“यदि कोई व्यक्ति गड्ढा खोदे और उसे न ढंके और उस गड्ढे में कोई बैल अथवा गधा जा गिरे, ");
INSERT INTO hincv_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","तो उस गड्ढे के मालिक को इसका दाम चुकाना होगा और वह मृत पशु गड्ढे वाले का हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“यदि किसी व्यक्ति का बैल अन्य व्यक्ति के बैल को मारे और बैल मर जाये तो बचे जीवित बैल को बेचकर उसका दाम आपस में बांट लें और मरे हुए बैल को भी आधा-आधा बांट लें. ");
INSERT INTO hincv_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","अथवा यदि वह बैल हमेशा ही सबको सींग मारता है और उसके मालिक ने उसे बांधकर नहीं रखा, तो निश्चय वह व्यक्ति बैल के बदले बैल ही दे. तब मृत बैल उसकी संपत्ति हो जाएगी. ");
INSERT INTO hincv_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“यदि कोई व्यक्ति किसी बैल अथवा भेड़-बकरी की चोरी कर उसको मार दे अथवा उसको बेच दे, तो उसे उस बैल के बदले पांच बैल तथा भेड़-बकरी के बदले चार भेड़-बकरी देने होंगे. ");
INSERT INTO hincv_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“यदि चोर चोरी करते हुए पकड़ा जाए और उसे मारते समय उसकी मृत्यु हो जाए, तब उस स्थिति में उसकी मृत्यु का दोष किसी पर न आए. ");
INSERT INTO hincv_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","किंतु सूर्य निकलने के बाद उसने चोरी की हो तो मृत्यु का दोष लगेगा. “ज़रूरी होगा कि चोर उस नुकसान को भर दे. यदि वह नहीं भर सकता है, तो वह इस चोरी के कारण बेच दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","यदि चोरी की गई वस्तु—बैल, गधा, अथवा भेड़-बकरी—ज़िंदा उसके पास है तो, उसे उसका दो गुणा दाम देना होगा. ");
INSERT INTO hincv_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“यदि कोई व्यक्ति अपना पशु खुला छोड़ दे, और वह किसी का खेत अथवा दाख की बारी खा जाएं, तो वह अपने ही खेत तथा दाख की बारी में से सबसे अच्छा हिस्सा उन्हें दे. ");
INSERT INTO hincv_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“यदि कोई आग जलाए और आग फैलकर झाड़ियों में लग जाये और जमा किया हुआ अनाज, तथा पूरी उपज और खेत जलकर राख हो जाए, तो जिस व्यक्ति ने आग लगाई, वह खेत के नुकसान को चुकाए. ");
INSERT INTO hincv_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“यदि कोई अपने पड़ोसी को धन अथवा सोना-चांदी संभालने के लिये देता है और कोई इन चीज़ों की चोरी कर लेता है, और चोर पकड़ा जाता है, तो चोर को उसका दो गुणा धन देना होगा ");
INSERT INTO hincv_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","यदि चोर पकड़ा न जाये, तब उस घर के मालिक को फैसला करनेवालों के सामने लाया जाये, ताकि यह मालूम हो जाये कि कहीं उसने ही पड़ोसी के धन पर हाथ न धरा हो. ");
INSERT INTO hincv_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","चाहे वह बैल, गधे, भेड़-बकरी, वस्त्र अथवा किसी भी खोई हुई वस्तु के संबंध में हो, जिसके विषय में कोई यह कहे, ‘यह तो मेरा है!’ जब किसी चीज़ को लेकर आपस में झगड़ा करें कि यह मेरा है तब फैसला करनेवाले सही फैसला करके दोषी को सजा दें और दोषी व्यक्ति दो गुणा दाम उसको लौटाये. ");
INSERT INTO hincv_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“यदि कोई व्यक्ति अपने पड़ोसी को गधा, बैल, भेड़-बकरी अथवा अन्य कोई भी पशु उसके घर रखने के लिए देता है, और तब उस पशु की मृत्यु हो जाती है, और किसी ने नहीं देखा कि कैसे मरा था, और क्या हुआ ");
INSERT INTO hincv_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","तब याहवेह के सामने उन दोनों से पूछें कि उसने अपने पड़ोसी की संपत्ति पर अधिकार तो नहीं कर लिया है, तब उस पशु के मालिक को उसकी बात पर विश्वास करना होगा. और उसे कोई दाम नहीं चुकाना होगा. ");
INSERT INTO hincv_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","किंतु यदि वास्तव में चोरी की गई है, तब उसे अपने पड़ोसी को दाम चुकाना होगा. ");
INSERT INTO hincv_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","यदि पशु को कोई जंगली जानवर मारकर टुकड़े-टुकड़े कर दे तो उस पशु के लिए किसी को भी दाम नहीं चुकाना होगा. ");
INSERT INTO hincv_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“यदि कोई व्यक्ति अपने पड़ोसी से कोई पशु अपनी मदद के लिए लेता है, और जब उसका मालिक वहां नहीं हो और तब उस पशु को चोट लगे या उसकी मृत्यु हो जाये तो उसे उसका दाम चुकाना होगा. ");
INSERT INTO hincv_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","और यदि मालिक के सामने ही पशु को कुछ भी होता है तो पशु का दाम चुकाने की ज़रूरत नहीं है. ");
INSERT INTO hincv_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“यदि कोई पुरुष किसी कुंवारी को भ्रष्‍ट करता है, और उसके साथ संभोग करता है, तो वह उसका मोल देकर उसके साथ विवाह करे. ");
INSERT INTO hincv_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","और यदि उस लड़की का पिता विवाह के लिए तैयार नहीं होता है, तब उस पुरुष को कुंवारियों के लिए तय किया गया दाम देना होगा. ");
INSERT INTO hincv_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“तुम तांत्रिक स्त्री को जीवित न रहने देना. ");
INSERT INTO hincv_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“यदि कोई व्यक्ति किसी पशु के साथ मैथुन करे, निश्चयतः उस व्यक्ति को मार दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“जो कोई याहवेह को छोड़े और किसी और देवता को बलि चढ़ाये उसे नष्ट कर दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“तुम किसी अनजान व्यक्ति को परेशान न करना और न उस पर अत्याचार करना—क्योंकि तुम भी मिस्र देश में अनजान थे. ");
INSERT INTO hincv_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“तुम किसी विधवा अथवा अनाथ बालक को दुःख न देना. ");
INSERT INTO hincv_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","यदि तुम उन्हें किसी भी तरह से दुःख दोगे और उस दुःख में वे मुझे पुकारेंगे, तो मैं निश्चयतः उन्हीं की पुकार सुनूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","और मैं बहुत क्रोधित होऊंगा और तुम्हें तलवार से मार दूंगा और तुम्हारी पत्नी विधवा तथा तुम्हारे बच्‍चे अनाथ हो जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“यदि तुम मेरे लोगों में से किसी को रकम उधार में दोगे तो उनसे ब्याज मत लेना. ");
INSERT INTO hincv_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","यदि तुम कभी अपने पड़ोसी या भाई बहनों से पहनने के लिए कपड़ा मांगो तो शाम से पहले उन्हें वापस दे देना. ");
INSERT INTO hincv_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","क्योंकि हो सकता हैं उसके पास पहनने के लिए एक ही जोड़ा कपड़ा हो और, यदि वह मुझे पुकारे तब, मैं उसी की सुनूंगा, क्योंकि मैं दयालु परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“तुम परमेश्वर की निंदा न करना, और न अपने प्रधानों को शाप देना. ");
INSERT INTO hincv_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“अपनी उपज तथा अपने फलों में से भेंट अर्पण करने में देरी न करना. “तुम अपने पुत्रों में से पहिला मुझे अर्पण करना. ");
INSERT INTO hincv_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","और बैलों तथा गायों के पहलौंठे भी मुझे अर्पण करना, बच्चा सात दिन तक मां के साथ रहें और आठवें दिन वह मुझे अर्पण किया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“तुम लोग मेरे लिए अपने आपको पवित्र रखना. जो पशु मैदान में मरा हुआ मिले, उसका मांस न खाना; तुम उसे कुत्तों को खिला देना. ");
INSERT INTO hincv_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“तुम झूठी बात न फैलाना. बुरे व्यक्ति की सहायता के लिए झूठी गवाही न देना. ");
INSERT INTO hincv_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“बुराई करने के लिए न तो भीड़ में जाना, और न किसी झगड़े में भीड़ के साथ मिलकर झूठ कहना; ");
INSERT INTO hincv_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","मुकदमे में अनुचित रूप से गरीब का पक्ष न लेना. ");
INSERT INTO hincv_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“यदि तुम्हें अपने शत्रु का बैल अथवा गधा भटकता हुआ मिले, तो तुम उसे उसके मालिक को लौटा देना. ");
INSERT INTO hincv_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","यदि तुम्हें अपने शत्रु का गधा बोझ से दबा हुआ दिखे, तो उसे वहां मत छोड़ना और सुनिश्चित उसे बोझ से छुड़ाने की कोशिश करना. ");
INSERT INTO hincv_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“मुकदमे में गरीब हैं यह सोचकर न्याय न बिगाड़ना. ");
INSERT INTO hincv_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","झूठे आरोपों से दूर ही रहना और निर्दोष तथा धर्मी की हत्या न करना, क्योंकि मैं किसी दोषी को निर्दोष न जाने दूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“तुम कभी घूस नहीं लेना, क्योंकि घूस उस व्यक्ति को, जिसको दृष्टि हैं, अंधा बना देती है तथा धर्मियों के शब्दों को खराब कर देती है. ");
INSERT INTO hincv_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“पराये लोगों पर अत्याचार नहीं करना, तुम पराये लोगों की भावनाओं को जानते हो, क्योंकि मिस्र देश में तुम भी पराये थे. ");
INSERT INTO hincv_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“तुम अपनी भूमि पर छः वर्ष तक खेती करना और उपज को एक साथ इकट्ठा करना, ");
INSERT INTO hincv_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","लेकिन सातवें वर्ष में कुछ नहीं करना सब कुछ वैसा ही छोड़ देना. तुममें जो गरीब हैं, वह उस वर्ष की उपज लें, और जो बच जाता हैं, वह पशुओं को खाने दें. अंगूर और जैतून के बगीचे को भी ऐसे ही छोड़ देना. ");
INSERT INTO hincv_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“छः दिन तक तुम काम करना, लेकिन सातवें दिन कोई काम न करना, जिससे तुम्हारे बैल तथा गधे भी आराम कर सकें. तुम्हारे दास तथा तुम्हारे बीच में रह रहे विदेशी भी आराम कर सकें. ");
INSERT INTO hincv_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“मैंने जो कुछ तुमसे कहा है, उन बातों का ध्यान रखना. दूसरे देवताओं के नामों का आव्हान न करना; न ही उनके बारे में अपने मुंह से कुछ कहना. ");
INSERT INTO hincv_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“हर साल तीन बार मेरे लिए उत्सव मनाना. ");
INSERT INTO hincv_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“तुम बिना खमीर की रोटी का उत्सव मनाना; सात दिन तक बिना खमीर का खाना खाना, मेरे बताये अनुसार अबीब महीने के निश्चित समय पर ही यह उत्सव मनाना. क्योंकि इसी महीने में तुम मिस्र देश से निकले थे. “तुममें से कोई भी मेरे सामने खाली हाथ न आए. ");
INSERT INTO hincv_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“जब फसल तैयार हो जाये, तब कटनी का उत्सव मनाना. खेत में उगाई गई फसल की पहली उपज जब तैयार हो जाये, तब कटनी का उत्सव मनाना. “और पूरी उपज को एक साथ एक जगह पर जमा करके संग्रह का उत्सव मनाना. ");
INSERT INTO hincv_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“तुममें से हर एक पुरुष साल में इन तीन अवसरों पर प्रभु याहवेह के पास जाएगा. ");
INSERT INTO hincv_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“किसी भी बलि पशु को खमीर वाली रोटी के साथ याहवेह को भेंट न चढ़ाना. “और न भेंट की वस्तु दूसरे दिन के लिए बचाना. ");
INSERT INTO hincv_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“तुम अपने खेत की उपज का पहला भाग याहवेह तुम्हारे परमेश्वर के घर में ले आना.” तुम बकरी के बच्‍चे को उसकी मां के दूध में नहीं पकाना. ");
INSERT INTO hincv_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“सुनो, मैं एक स्वर्गदूत तुम्हारी अगुवाई करने के लिए तुम्हारे आगे-आगे भेज रहा हूं. वह मार्ग में तुम्हारी रक्षा करेगा तथा वही तुम्हें उस स्थान में पहुंचाएगा, जिसे मैंने तुम्हारे लिए तैयार किया है. ");
INSERT INTO hincv_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","तुम उस स्वर्गदूत के सामने सावधान रहना, उसकी बातों को मानना, कोई विरोध नहीं करना, क्योंकि वह तुम्हारी गलती को माफ नहीं करेगा, क्योंकि उसमें मेरा नाम रहता है. ");
INSERT INTO hincv_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","यदि तुम दीनता से उसकी बातों को मानोगे तथा वह सब करोगे जो मैंने कहा है, तब मैं तुम्हारे शत्रुओं का शत्रु तथा तुम्हारे विरोधियों का विरोधी बन जाऊंगा. ");
INSERT INTO hincv_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","क्योंकि मेरा स्वर्गदूत तुम्हारे आगे-आगे चलकर तुम्हें अमोरियों, हित्तियों, परिज्ज़ियों, कनानियों, हिव्वियों तथा यबूसियों के देश में पहुंचाएगा. ");
INSERT INTO hincv_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","तुम उनके देवताओं की आराधना मत करना, न उनकी सेवा करना, और न उनकी बातों को मानना. तुम उनके पूजा स्थान को नाश कर देना और उनके पूजा के पत्थरों को टुकड़े-टुकड़े कर देना. ");
INSERT INTO hincv_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","तुम याहवेह, अपने परमेश्वर ही की आराधना करना और याहवेह तुम्हारे अन्‍न और जल को आशीष देंगे. मैं तुम्हारे बीच से रोगों को दूर कर दूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","तुम्हारे देश में न तो गर्भपात होगा, न कोई स्त्री बांझ होगी; और मैं तुम्हारी आयु को पूरी करूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“जिन-जिन लोगों के बीच तुम जाओगे मेरा डर सबके बीच छा जायेगा और सबको भ्रमित कर दूंगा और सब शत्रु पीठ दिखाकर भाग जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","मैं तुम्हारे आगे-आगे बर्रों को भेजूंगा जो तुम्हारे सामने से हिव्वियों, कनानियों तथा हित्तियों को भगा देंगे. ");
INSERT INTO hincv_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","मैं उन्हें तुम्हारे आगे से एक ही वर्ष में न निकालूंगा, नहीं तो पृथ्वी में लोग कम पड़ते जायेंगे और जंगली पशु बढ़ते जायेंगे जिससे परेशानी बढ़ जायेगी. ");
INSERT INTO hincv_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","मैं उनको थोड़ा-थोड़ा करके निकालूंगा जब तक तुम देश को अपने अधिकार में न कर लो. ");
INSERT INTO hincv_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“मैं लाल सागर से फिलिस्तीनियों के सागर तक तथा निर्जन प्रदेश से फरात नदी तक तुम्हें दे दूंगा. और उस देश के लोगों को भी तुम्हें सौंप दूंगा और तुम ही उन्हें अपने सामने से निकाल देना. ");
INSERT INTO hincv_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","तुम उनके देवताओं के साथ कोई भी वायदा नहीं करना. ");
INSERT INTO hincv_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","वे तुम्हारे साथ नहीं रहेंगे, क्योंकि वे तुम्हें मेरे विरुद्ध पाप करने के लिए मजबूर करेंगे; और यदि तुम उनके देवताओं की सेवा करोगे, तो तुम मुसीबत में पड़ जाओगे.” ");
INSERT INTO hincv_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","फिर याहवेह ने मोशेह से कहा, “तुम और अहरोन, नादाब, अबीहू और इस्राएल के सत्तर अगुए याहवेह के पास ऊपर आकर दूर से याहवेह को दंडवत करना. ");
INSERT INTO hincv_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","केवल मोशेह ही याहवेह के पास जायेंगे और कोई नहीं. अन्य लोगों में से कोई भी पास नहीं आये, अन्य कोई जन उनके साथ ऊपर न आये.” ");
INSERT INTO hincv_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","मोशेह नीचे उतर आए तथा जब उन्होंने लोगों को याहवेह द्वारा कही सब बातें बताई तब सबने एक साथ कहा कि याहवेह की कही सब बातों के अनुसार ही हम करेंगे. ");
INSERT INTO hincv_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","तब मोशेह ने याहवेह की कही सब बातों को लिख लिया. मोशेह ने सुबह जल्दी उठकर पर्वत के नीचे एक वेदी बनाई, और इस्राएल के बारह गोत्रों के अनुसार बारह खंभे भी खड़े किए. ");
INSERT INTO hincv_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","उन्होंने इस्राएलियों में से जवानों को भेजा और उन्होंने याहवेह के लिए होमबलि तथा मेल बलि चढ़ाई. ");
INSERT INTO hincv_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","मोशेह ने आधा रक्त बर्तन में रखा और आधा वेदी पर छिड़क दिया. ");
INSERT INTO hincv_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","फिर मोशेह ने वाचा की किताब लेकर सबको पढ़कर सुनाया. उसे सुनकर लोगों ने कहा “हम याहवेह की सब बात मानेंगे और उनके साथ चलेंगे!” ");
INSERT INTO hincv_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","तब मोशेह ने रक्त लेकर लोगों पर छिड़का और कहा, “यह उस वाचा का रक्त है, जो तुम्हारे साथ याहवेह ने बांधी हैं.” ");
INSERT INTO hincv_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","फिर मोशेह, अहरोन, नादाब तथा अबीहू और इस्राएल के सत्तर अगुओं को साथ लेकर ऊपर गए. ");
INSERT INTO hincv_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","वहां उन्होंने इस्राएल के परमेश्वर का दर्शन किया. उनके पांव के नीचे आकाश के जैसा साफ़ नीलमणि था. ");
INSERT INTO hincv_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","परमेश्वर ने उन लोगों पर अपना हाथ नहीं बढ़ाया. उन्होंने परमेश्वर को देखा और खाया पिया. ");
INSERT INTO hincv_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","याहवेह ने मोशेह से कहा, “तुम यहां पर्वत के ऊपर मेरे पास आओ और, मैं तुम्हें मेरे नियम लिखी हुई पट्टिया दूंगा, उसे लेकर तुम इन सबको सिखाना.” ");
INSERT INTO hincv_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","तब मोशेह यहोशू को साथ लेकर परमेश्वर के पर्वत पर गए. ");
INSERT INTO hincv_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","किंतु मोशेह ने अगुओं से कहा, “तुम लोग हमारे वापस आने तक यहीं रहना. अहरोन तथा हूर यहां तुम्हारे साथ हैं. यदि कोई विवाद हो तो उनको बताना.” ");
INSERT INTO hincv_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","यह कहकर मोशेह पर्वत पर चले गए और बादल ने पर्वत को ढक दिया. ");
INSERT INTO hincv_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","सीनायी पर्वत पर याहवेह का प्रकाश छा गया. छः दिन तक बादल उस पर्वत को ढके रहा. सातवें दिन याहवेह ने बादलों के बीच से मोशेह को बुलाया. ");
INSERT INTO hincv_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","इस्राएलियों को याहवेह का प्रकाश, पर्वत पर भस्म करनेवाली आग के समान दिख रहा था. ");
INSERT INTO hincv_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","मोशेह पर्वत पर बादलों के बीच से होते हुए चढ़ गए और चालीस दिन और चालीस रात वहां रहे. ");
INSERT INTO hincv_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","फिर याहवेह ने मोशेह से कहा: ");
INSERT INTO hincv_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“इस्राएलियों से कहो कि वे मेरे लिए भेंट लाएं. और तुम यह भेंट उन्हीं से लेना जो अपनी इच्छा से दे. ");
INSERT INTO hincv_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“ये हैं भेंटें जिन्हें तुम उनसे प्राप्‍त करोगे: “सोना, चांदी, कांसे; ");
INSERT INTO hincv_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","नीले, बैंगनी तथा लाल सूक्ष्म मलमल; बकरे के रोम; ");
INSERT INTO hincv_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","मेमने की रंगी हुई लाल खाल, सूंस की खाल, बबूल की लकड़ी, ");
INSERT INTO hincv_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","दीपक के लिए तेल; अभिषेक का तेल एवं सुगंधधूप के लिए सुगंध द्रव्य; ");
INSERT INTO hincv_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","एफ़ोद तथा सीनाबंद में जड़ने के लिए सुलेमानी गोमेद नाग तथा अन्य नग, ");
INSERT INTO hincv_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“और मेरे लिए एक पवित्र स्थान बनाना. ताकि मैं उनके बीच रहूं. ");
INSERT INTO hincv_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","पवित्र निवास स्थान के लिये जैसा मैं तुमको बताऊं वैसा ही सामान लेना और उसी तरीके से बनाना. ");
INSERT INTO hincv_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“उन्हीं बबूल की लकड़ी से एक संदूक बनाना, जिसकी लंबाई एक सौ दस सेंटीमीटर तथा चौड़ाई और ऊंचाई सत्तर-सत्तर सेंटीमीटर हों. ");
INSERT INTO hincv_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","और संदूक के अंदर और बाहर सोना लगाना. और संदूक के ऊपर चारों तरफ सोने की किनारी लगाना. ");
INSERT INTO hincv_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","इसके चारों पायों पर लगाने के लिए सोने के चार कड़े बनाना; सोने के कड़ों को चारों कोनों पर लगाना—दो कड़े एक तरफ और, दो कड़े दूसरी तरफ हों. ");
INSERT INTO hincv_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","फिर बबूल की लकड़ी से डंडे बनवाना, उस पर भी सोना लगाना. ");
INSERT INTO hincv_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","डंडों को दोनों तरफ के कड़ों में डालना ताकि संदूक को उठाना आसान हो. ");
INSERT INTO hincv_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","डंडे को संदूक की कड़ों में से न हटाना. ");
INSERT INTO hincv_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","मैं तुम्हें एक साक्षी पट्टिया दूंगा, उसे उस संदूक में रखना. ");
INSERT INTO hincv_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“सोने से करुणासन बनाना, जो एक सौ दस सेंटीमीटर लंबा तथा सत्तर सेंटीमीटर चौड़ा होगा. ");
INSERT INTO hincv_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","सोने के पत्रों से दो करूबों को बनाकर करुणासन के दोनों ओर लगाना. ");
INSERT INTO hincv_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","एक करूब एक तरफ तथा दूसरा करूब दूसरी तरफ लगाना. ये करूब करुणासन के साथ ऐसे जुड़े हों, मानो यह एक ही हो. ");
INSERT INTO hincv_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","करूबों के पंख ऊपर से ऐसे खुले हों जिससे करुणासन उनसे ढका रह सके और वे एक दूसरे के आमने-सामने तथा उनके मुंह करुणासन की ओर झुके हुए हों. ");
INSERT INTO hincv_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","करुणासन को संदूक के ऊपर लगाना और साक्षी पट्टिया जो मैं तुम्हें दूंगा उसे संदूक के अंदर रखना. ");
INSERT INTO hincv_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","और मैं करुणासन के ऊपर से तुमसे मिलूंगा और इस्राएलियों के लिए जितनी आज्ञा मैं तुम्हें दूंगा वह संदूक के अंदर रखना. ");
INSERT INTO hincv_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“तुम बबूल की लकड़ी से एक मेज़ बनाना. जो नब्बे सेंटीमीटर लंबी, पैंतालीस सेंटीमीटर चौड़ी और साढ़े सड़सठ सेंटीमीटर ऊंची होगी. ");
INSERT INTO hincv_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","मेज़ पर पूरा सोना लगाना मेज़ की किनारी भी सोने की बनाना. ");
INSERT INTO hincv_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","मेज़ के चारों ओर सोने की साढ़े सात सेंटीमीटर चौड़ी पट्टी लगाना और चारों तरफ से इस पट्टी को सोने से मढ़ना. ");
INSERT INTO hincv_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","मेज़ के लिए सोने के चार कड़े बनाना और मेज़ के चारों पैरों के ऊपर के कोनों पर इन सोने के कड़ों को लगाना. ");
INSERT INTO hincv_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","कड़े पट्टी के पास लगाना ताकि मेज़ उठाने के लिये डंडे इन कड़ों में डाले जा सके. ");
INSERT INTO hincv_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","डंडे बबूल की लकड़ी से बनाकर उस पर सोना चढ़ाना. डंडे के सहारे से ही मेज़ को उठाया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","तुम धूप के लिए थालियों, तवों, कटोरियों तथा सुराहियां, चम्मच सब सोने से बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","मेज़ पर मेरे सामने भेंट की रोटी हमेशा रखना. ");
INSERT INTO hincv_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“फिर शुद्ध सोने का एक दीपस्तंभ बनाना. उसके आधार तथा उसके डंडे को बनाना, और उसमें फूलों के समान प्याले बनाना. प्यालों के साथ कलियां और खिले हुए पुष्प हों. ये सभी चीज़ें सोना पीटकर एक ही इकाई में परस्पर जुड़ी हुई हो. ");
INSERT INTO hincv_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","दीये से छः डालियां निकलें, तीन एक तरफ और तीन दूसरी तरफ रखना. ");
INSERT INTO hincv_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","हर डाली में बादाम के फूल जैसी तीन कलियां और एक गांठ हों, और एक फूल दीये से बाहर निकली हुई, पूरी छः डालियों को इसी आकार से बनाना. ");
INSERT INTO hincv_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","दीये की डंडी में चार फूल बनाना, जिसमें बादाम के फूल के समान कलियां तथा पंखुड़ियां बनाना. ");
INSERT INTO hincv_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","दीये से निकली हुई छः डालियों में से दो-दो डालियों के नीचे एक-एक गांठ हों और दीये समेत एक ही टुकड़े से बने हो. ");
INSERT INTO hincv_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","कलियां, शाखाएं और दीप का स्तंभ शुद्ध सोने को पीटकर बने हो. ");
INSERT INTO hincv_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“सात दीये बनाना और सातों दीयों को जलाए रखना ताकि वे रोशनी दे सकें. ");
INSERT INTO hincv_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","चिमटियां तथा इन्हें रखने के बर्तन भी सोने के हों. ");
INSERT INTO hincv_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ये पूरा सामान लगभग पैंतीस किलो सोने से बना हो. ");
INSERT INTO hincv_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","सावधानी से इन सभी चीज़ों को बिलकुल वैसा ही बनाना जैसा तुम्हें पर्वत पर दिखाया गया था. ");
INSERT INTO hincv_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“फिर पवित्र स्थान के लिए कुशल कारीगरों द्वारा दस पर्दे बनाना, जो बंटी हुई मलमल और नीले, बैंगनी और लाल रंग के कपड़ों से बने हों और उस पर कढ़ाई के काम किए हुए करूबों के चित्र हों. ");
INSERT INTO hincv_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","हर पर्दे की लंबाई बारह मीटर साठ सेंटीमीटर और चौड़ाई एक मीटर अस्सी सेंटीमीटर हो. हर पर्दा एक ही नाप का हो. ");
INSERT INTO hincv_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","पांच पर्दों को एक साथ जोड़ना और इसी प्रकार दूसरे पांच पर्दे भी एक साथ जुड़े. ");
INSERT INTO hincv_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","फिर पहले पांच पर्दे के किनारी पर तथा इसी तरह दूसरी पांच पर्दे के किनारी पर भी नीले रंग का फंदा बनाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","एक पर्दे में पचास फंदे और दूसरे में भी पचास फंदे. वे फंदे एक दूसरे के सामने बनाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","फिर, सोने के पचास अंकुड़े बनवाना. और उन अंकुड़ों से दोनों पर्दों को मिलाना, जिससे पवित्र स्थान मिलकर एक हो जाए. ");
INSERT INTO hincv_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“फिर बकरे के रोमों से ग्यारह पर्दे बनवाना जो पवित्र स्थान के ऊपर का हिस्सा है. ");
INSERT INTO hincv_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","हर पर्दे की लंबाई साढ़े तेरह मीटर और चौड़ाई एक मीटर अस्सी सेंटीमीटर हो. ग्यारहों पर्दे एक ही नाप के हों. ");
INSERT INTO hincv_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","उन पर्दों में पांच को जोड़कर एक पर्दा बनवाना. और बाकी छः पर्दों को जोड़कर एक और पर्दा बनवाना. छठे पर्दे को तंबू के सामने मोड़ देना. ");
INSERT INTO hincv_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","और दोनों अलग-अलग पर्दों की एक-एक किनारी पर पचास-पचास फंदे लगाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","फिर कांसे के पचास अंकुड़े बनवाना. उन अंकुड़ों में फंदे लगवाना और तंबू के दोनों तरफ इस प्रकार जोड़ना कि वे एक बन जाए. ");
INSERT INTO hincv_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","पर्दों का जो भाग बचा है, उसका आधा भाग पवित्र स्थान के पीछे लटका देना ");
INSERT INTO hincv_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","और पर्दों की लंबाई में बचा हुआ भाग पवित्र स्थान के दोनों तरफ ढकने के लिए पैंतालीस-पैंतालीस सेंटीमीटर दोनों ओर लटका हुआ छोड़ देना. ");
INSERT INTO hincv_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","तंबू के लिए लाल रंग से रंगी हुई भेडों की खाल का एक ओढ़ना बनवाना और फिर उसके ऊपर लगाने के लिए सूस के चमड़े का एक और ओढ़ना बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“फिर पवित्र स्थान को खड़ा करने के लिए बबूल की लकड़ी के तख्ते बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","हर तख्ते की लंबाई साढ़े चार मीटर और चौड़ाई साढ़े सड़सठ सेंटीमीटर की हो. ");
INSERT INTO hincv_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","तख्ते को जोड़ने के लिए दो समानांतर चूल्हे हों. पवित्र स्थान के सब तख्ते इसी तरह बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","पवित्र स्थान के लिए बीस तख्ते दक्षिण की ओर बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","उनके नीचे चांदी की चालीस कुर्सियां बनवाना जो तख्तों के नीचे रखी जायेंगी. हर तख्ते के नीचे उसकी दो चूलों के लिए दो कुर्सियां बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","और इसी प्रकार उत्तर की ओर भी बीस तख्ते बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","और चांदी की चालीस कुर्सियां, हर एक तख्ते के नीचे दो कुर्सियां बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","पवित्र स्थान के पीछे पश्चिम की ओर छः तख्ते बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","और पीछे के भाग के कोनों के लिए दो तख्ते बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","कोने के दोनों तख्ते एक साथ जोड़ देना चाहिए. तले में दोनों तख्तों की खूंटियां चांदी के एक ही आधार में लगेंगी और दोनों भाग ऊपर से जुड़े हों, और नीचे का भाग अलग हो. ");
INSERT INTO hincv_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","इस प्रकार आठ तख्ते बनवाना, जिनके नीचे चांदी की सोलह कुर्सियां हों, हर तख्ते के नीचे दो कुर्सियां हों. ");
INSERT INTO hincv_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“फिर बबूल की लकड़ी की छड़ें बनवाना. अर्थात् पवित्र स्थान की एक तरफ के तख्तों के लिए पांच छड़ें हों, ");
INSERT INTO hincv_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","और तथा पवित्र स्थान की दूसरी तरफ के तख्तों के लिए पांच कड़े तथा पवित्र स्थान के पश्चिमी दिशा के तख्ते के लिए पांच कड़े बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","तख्ते के एक तरफ से दूसरी तरफ जाने के लिए तख्ते के बीच में कड़े बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","तख्तों के ऊपर सोना लगवाना और कड़े में भी सोना लगवाना. लकड़े की डंड़ियों को भी सोना लगवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“इसी प्रकार पवित्र स्थान को बनाना, जैसे तुमको पर्वत पर दिखाया गया था. ");
INSERT INTO hincv_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“फिर नीले, बैंगनी और लाल रंग के कपड़ों से और बंटी हुई मलमल से एक बीच वाला पर्दा बनवाना, जिस पर कढ़ाई के काम द्वारा करूबों के रूप बने हुए हों. ");
INSERT INTO hincv_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","बबूल की लकड़ी के चार खंभे बनवाना और उनके ऊपर सोना लगाना. इन खंभों पर पर्दों के लिए सोने की कड़ियां और चांदी की चार कुर्सियां बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","बीचवाले पर्दे को अंकुड़ियों के नीचे लटकाकर उसकी आड़ में साक्षी पत्र का संदूक अंदर रखना. बीचवाले पर्दे के एक तरफ पवित्र स्थान तथा दूसरी तरफ परम पवित्र स्थान होगा. ");
INSERT INTO hincv_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","परम पवित्र स्थान में साक्षी पत्र के संदूक के ऊपर करुणासन को रखना. ");
INSERT INTO hincv_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","पर्दे के बाहर पवित्र स्थान के उत्तरी भाग में मेज़ रखना और उसके दक्षिण की ओर मेज़ के सामने दीया रखना. ");
INSERT INTO hincv_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“तंबू के द्वार के लिए नीले, बैंगनी और लाल रंग के कपड़ों का तथा बंटी हुई बारीक़ सनी वाले कपड़ो की कढ़ाई का काम किया हुआ एक पर्दा बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","इस पर्दे को लटकाने के लिए बबूल की लकड़ी के सोने से मढ़े हुए पांच खंभे बनवाना. उनकी कुण्डियां सोने की हों और उनके लिए कांसे की पांच कुर्सियां बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“बबूल की लकड़ी से एक वेदी बनवाना, तथा उसकी ऊंचाई एक मीटर पैंतीस सेंटीमीटर हो, वह वेदी चौकोर हो, सवा दो मीटर लंबी और सवा दो मीटर चौड़ी हो. ");
INSERT INTO hincv_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","उसके चारों कोनों पर सींग बनवाना, वेदी और सींग एक ही टुकड़े से बने हों और उसमें कांसा लगवाना. ");
INSERT INTO hincv_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","वेदी से राख उठाने का बर्तन, फावड़े, कटोरे, कांटे और अंगीठियां कांसे से बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","वेदी के लिए कांसे की जाली की एक झंझरी बनवाना और जाली के चारों कोनों पर कांसे के चार कड़े बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","उसे वेदी के नीचे इस प्रकार लगवाना कि वह वेदी की आधी ऊंचाई तक आए. ");
INSERT INTO hincv_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","वेदी के लिए डंडे बबूल की लकड़ी के ही बनवाना और उसमें कांसे लगवाना. ");
INSERT INTO hincv_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","वे डंडे कड़ों में डालें ताकि जब वेदी को उठाएं तब डंडे उसके दोनों ओर हों. ");
INSERT INTO hincv_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","वेदी को तख्तों से इस प्रकार बनाना कि वह अंदर से खोखली रहे. जैसे तुमको पर्वत पर दिखाया गया था, ठीक वैसी ही बनाना. ");
INSERT INTO hincv_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“फिर पवित्र स्थान के आंगन को बनवाना. आंगन के दक्षिण हिस्से में बंटी हुई बारिक सनी के कपड़े का पर्दा हो, जिनकी लंबाई पैंतालीस मीटर हो. ");
INSERT INTO hincv_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","तथा बीस खंभे और कांसे की बीस कुर्सियां बनवाना. खंभों के कुण्डे और पट्टियां चांदी की हों. ");
INSERT INTO hincv_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","इसी प्रकार उत्तरी हिस्से के लिए भी पैंतालीस मीटर लंबे पर्दे बनवाना. उनके लिए बीस खंभे और कांसे की बीस कुर्सियां बनवाना. मीनारों के कड़े और पट्टियां चांदी की हों. ");
INSERT INTO hincv_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“आंगन का पश्चिमी हिस्सा साढ़े बाईस मीटर लंबा हो तथा उसके लिए पर्दे, दस खंभे और दस कुर्सियां बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","आंगन का पूर्वी किनारा भी साढ़े बाईस मीटर का हो. ");
INSERT INTO hincv_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","द्वार के एक तरफ के पर्दे छः मीटर पचहत्तर सेंटीमीटर के हों, और तीन खंभे और तीन कुर्सियां हों, ");
INSERT INTO hincv_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","दूसरी ओर के पर्दे छः मीटर पचहत्तर सेंटीमीटर के हों, तथा तीन खंभे और तीन कुर्सियां हों. ");
INSERT INTO hincv_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“आंगन के द्वार के लिए नौ मीटर लंबा नीले, बैंगनी और लाल रंग का कपड़ा तथा बंटा हुआ मलमल का पर्दा बनवाना उसमें चार खंभे और चार कुर्सियां हों. ");
INSERT INTO hincv_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","आंगन के चारों ओर के सब खंभे चांदी की पट्टियों से जुड़े हुए हों. उनके कुण्डे चांदी के और उनकी खानें कांसे की हों. ");
INSERT INTO hincv_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","आंगन की लंबाई पैंतालीस मीटर तथा चौड़ाई साढ़े बाईस मीटर तथा ऊंचाई दो मीटर तीस सेंटीमीटर ऊंचे हों और उनकी कुर्सियां कांसे की हों. ");
INSERT INTO hincv_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","पवित्र स्थान के उपयोग का सारा सामान, उसकी सब खूंटियां और आंगन की सब खूंटियां कांसे की हों. ");
INSERT INTO hincv_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“इस्राएलियों को कहना कि वे दीये के लिए जैतून का निकाला हुआ शुद्ध तेल लायें, जिससे दिया हमेशा जलता रहे, ");
INSERT INTO hincv_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","जो मिलनवाले तंबू के बीचवाले पर्दे से बाहर जो साक्षी पर्दे के सामने हैं. अहरोन और उसके पुत्र, सुबह से शाम तक, उस दीये को याहवेह के सामने जलता हुआ रखें. यह इस्राएलियों के लिए पीढ़ी से पीढ़ी तक बना रहनेवाला आदेश है. ");
INSERT INTO hincv_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“इस्राएलियों में से अपने भाई अहरोन और उसके पुत्र नादाब और अबीहू, एलिएज़र और इथामार को बुलाना, ताकि वे मेरे लिए पुरोहित का काम करें. ");
INSERT INTO hincv_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","अपने भाई अहरोन के लिए, उसकी मर्यादा और शोभा के लिए, पवित्र वस्त्र बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","उन सब कुशल शिल्पकारों को, जिन्हें मैंने इस काम के लिए चुना है, वे अहरोन के अभिषेक के लिए वस्त्र बनाएं, जिसे पहनकर वह मेरे लिए पुरोहित का काम कर सके. ");
INSERT INTO hincv_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","उन्हें वक्षपेटिका, एफ़ोद, अंगरखा, बेलबूटेदार कुर्ता, पगड़ी और कमरबंध आदि वस्त्र बनाना होगा. वे तुम्हारे भाई अहरोन और उसके पुत्रों के लिए पवित्र वस्त्र बनाएं, वे इन्हें पहनकर मेरे लिए पुरोहित का काम करें. ");
INSERT INTO hincv_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","वे सुनहरे, नीले, बैंगनी और लाल रंग के कपड़े और मलमल का उपयोग करें. ");
INSERT INTO hincv_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“तुम एक कुशल शिल्पकार द्वारा सोने के तारों से, नीले, बैंगनी और लाल रंग के कपड़ों तथा बंटी हुई मलमल से, एफ़ोद बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","एफ़ोद को जोड़ने के लिए कंधों की पट्टियां बनाना और कंधे की इन पट्टियों को एफ़ोद के कंधे से उसके दोनों भाग जोड़ देना. ");
INSERT INTO hincv_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","कमरबंध एफ़ोद के साथ बुना हुआ हो और एक ही प्रकार की सामग्री से बना हो, अर्थात् सुनहरे, नीले, बैंगनी और लाल रंग के कपड़ों से और बंटी हुई मलमल से बनाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“सुलेमानी दो मणियों पर इस्राएल के पुत्रों के नाम खुदवाना, ");
INSERT INTO hincv_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","उनके जन्म के अनुसार, एक मणि पर छः नाम और दूसरी मणि पर बाकी छः नाम खुदवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","जिस प्रकार जौहरी मुद्राओं को खोदता है, उसी प्रकार इन दोनों मणियों पर इस्राएल के पुत्रों के नाम खुदवाना. उन्हें सोने के खांचों में जड़वा देना. ");
INSERT INTO hincv_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","इन दोनों मणियों को इस्राएल के पुत्रों के यादगार मणियों के रूप में एफ़ोद के कंधे में लगवाना. अहरोन अपने दोनों कंधों पर उनके नाम याहवेह के सामने याद कराने वाली ये मणि हो. ");
INSERT INTO hincv_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","फिर सोने के खाने बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","और रस्सियों के समान गुंथी हुई कुन्दन की दो जंजीरें बनवाना और इन गुंथी हुई जंजीरों को खांचों में लगवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“तुम एक कुशल शिल्पकार द्वारा न्याय की पेटी बनवाना, उसे बेलबूटेदार एफ़ोद के समान बनवाना. उसे सुनहरे, नीले, बैंगनी और लाल रंग के कपड़े तथा बंटी हुई मलमल से बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","वक्ष पटल को मोड़कर दो भाग बनाना. और इसका आकार चौकोर हो, और यह साढ़े बाईस सेंटीमीटर लंबा तथा साढ़े बाईस सेंटीमीटर चौड़ा हो. ");
INSERT INTO hincv_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","उसमें मणियों की चार पंक्तियां लगवाना. पहली पंक्ति में एक माणिक्य, एक पुखराज और एक मरकत हो. ");
INSERT INTO hincv_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दूसरी पंक्ति में एक लाल मणि, एक नीलम और एक हीरा हो. ");
INSERT INTO hincv_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तीसरी पंक्ति में एक तृणमणि, एक यशब और एक याकूत. ");
INSERT INTO hincv_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","चौथी पंक्ति में एक स्वर्णमणि, एक सुलेमानी और एक सूर्यकांत मणि इन्हें नक्काशी किए हुए सोने के खांचों में लगवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","इस्राएल के बारह पुत्रों के अनुसार बारह मणियां हों. हर मणि पर बारह गोत्रों में से एक नाम लिखा हो जिस तरह मोहरों पर होता है. ");
INSERT INTO hincv_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“वक्षपेटिका के लिए बंटी हुई डोरियों के रूप में सोने की गुंथी हुई जंजीर बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","वक्षपेटिका के लिए सोने के दो कड़े भी बनवाना और इन दोनों कड़ों को वक्षपेटिका के दोनों सिरों पर लगवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","इसके बाद सोने की इन दोनों डोरियों को वक्षपेटिका के सिरों में लगे हुए दोनों कड़ों में लगवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","दोनों डोरियों के दूसरे सिरों को नक्काशी किए हुए दोनों खांचों में जुड़वाना. उन्हें एफ़ोद के कंधों में सामने की ओर लगवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","फिर सोने के दो और कड़े बनवाकर इन्हें वक्षपेटिका के सिरों पर अंदर की ओर एफ़ोद से सटाकर लगवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","दो कड़े बनवाना और उन्हें एफ़ोद के कंधों की तरफ़ की छोर के सामने की तरफ़ से मिला देना, जो एफ़ोद के बुनी हुई पट्टी के पास से हो. ");
INSERT INTO hincv_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","वक्ष पटल को उसके कड़ों के द्वारा एफ़ोद के कड़ों से एक नीले रंग की रस्सी द्वारा बांधना, जिससे यह अब एफ़ोद के बुने हुए भाग पर जुड़ जायें ताकि वक्ष पटल एवं एफ़ोद एक दूसरे से जुड़े रहेंगे. ");
INSERT INTO hincv_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“जब अहरोन पवित्र स्थान में जाएगा, तब वह न्याय पेटी पर लिखे इस्राएल के नाम अपने हृदय पर लगाकर रखें जिससे याहवेह के सामने हमेशा उसे याद करते रहे. ");
INSERT INTO hincv_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","न्याय पेटी में उरीम और थुम्मीम को रखना, जिससे अहरोन उन्हें अपने हृदय पर लिए हुए याहवेह के सामने आए. इस प्रकार अहरोन याहवेह के सामने आते समय इस्राएल को हमेशा अपने हृदय पर लगाए रखे. ");
INSERT INTO hincv_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“एफ़ोद का पूरा अंगरखा नीले कपड़े का बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","बीच में सिर के लिए एक छेद हो और उस छेद के चारों ओर गिरेबां जैसी एक गोट हो, जिससे वह फटे नहीं. ");
INSERT INTO hincv_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","इस वस्त्र की किनारी पर नीली, बैंगनी तथा लाल सूक्ष्म बंटी हुई सन के रेशों से अनार बनवाना. सोने की घंटियां भी बनवाना और इन्हें वस्त्र की किनारी के चारों ओर अनारों के बीच में लगा देना. ");
INSERT INTO hincv_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","अंगरखे के निचले घेरे में एक अनार के बाद सोने की एक घंटी हो, फिर एक अनार के बाद फिर एक सोने की घंटी. ");
INSERT INTO hincv_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","अहरोन सेवा करते समय उसे पहन लेगा जब वह याहवेह के सामने पवित्र स्थान में जाएगा और उसमें से निकल आएगा, तो घण्टियों का शब्द सुनाई देगा, ऐसा नहीं होने पर उसकी मृत्यु हो जाएगी. ");
INSERT INTO hincv_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“शुद्ध सोने की एक पट पर मुहर के समान ये अक्षर खोदे जायें: याहवेह के लिए पवित्र ");
INSERT INTO hincv_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","तुम उसे नीला फीता से सामने की ओर पगड़ी में बांधना ");
INSERT INTO hincv_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","अहरोन उसे अपने सिर पर रखे और इससे वह इस्राएलियों द्वारा चढ़ाए पवित्र चढ़ावों का दोष अहरोन अपने ऊपर उठाए रखे. वह उस पटिए को सदा अपने सिर पर उठाए रखे, जिससे याहवेह उससे खुश रहे. ");
INSERT INTO hincv_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“कुर्ता और पगड़ी मलमल के और कमरबंध बेलबूटेदार हों. ");
INSERT INTO hincv_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","अहरोन के पुत्रों की मर्यादा और शोभा के लिए कुर्ता, कमरबंध ओर टोपी बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","अपने भाई अहरोन और उसके पुत्रों को उन्हें पहनाना और उनका पुरोहित के रूप में अभिषेक करना. उन्हें पवित्र करना, जिससे वे मेरे लिए पुरोहित का काम कर सकें. ");
INSERT INTO hincv_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“उनके शरीर ढकने के लिए मलमल के जांघिये बनवाना. ");
INSERT INTO hincv_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","उनकी लंबाई कमर से जांघ तक हो जब अहरोन और उसके पुत्र मिलनवाले तंबू में जायें अथवा पवित्र स्थान में सेवा करने के लिए वेदी के पास जायें, तब वे उस वस्त्र को पहनें, जिससे वे अपराधी न बनें और उनकी मृत्यु न हो. “यह उसके और उसके बाद होनेवाले उसके वंश के लिए स्थिर आदेश है. ");
INSERT INTO hincv_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“अब तुम उनको पवित्र करने के लिए एक निर्दोष बछड़ा तथा दो मेढ़ों को लाना. ");
INSERT INTO hincv_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","उनको लेकर बिना खमीर रोटी तथा तेल से बनी बिना खमीर की पूरियां, तेल लगाई हुई बिना खमीर की रोटियां जिन्हें मैदे से तैयार किया गया हो, लेना. ");
INSERT INTO hincv_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","इन सभी को तुम एक टोकरी में रखकर तथा बछड़े एवं मेढ़ों के साथ चढ़ाना. ");
INSERT INTO hincv_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","तब तुम अहरोन और उसके पुत्रों को मिलनवाले तंबू के द्वार पर लाकर उनको नहलाना. ");
INSERT INTO hincv_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","और अहरोन को कुर्ता तथा एफ़ोद का परिधान, एफ़ोद तथा वक्ष पटल पहनाकर उसे एफ़ोद के फ़ीते से बांध देना; ");
INSERT INTO hincv_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","उसके सिर पर वह पगड़ी रखना तथा उस पगड़ी पर पवित्र मुकुट रख देना. ");
INSERT INTO hincv_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","तब अभिषेक का तेल लेकर उसके सिर पर डालकर उसका अभिषेक करना. ");
INSERT INTO hincv_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","फिर उसके पुत्रों को कुर्ते पहनाना. ");
INSERT INTO hincv_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","अहरोन तथा उनके पुत्रों की कमर बांधकर उनके सिर पर टोपियां रख देना. ऐसे पुरोहित पद पर हमेशा उनका अधिकार हो जाएगा. “इस तरह अहरोन तथा उसके पुत्रों का अभिषेक करना. ");
INSERT INTO hincv_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“इसके बाद बछड़े को मिलनवाले तंबू के सामने लाना और अहरोन के पुत्र उस बछड़े के सिर पर अपना हाथ रखें. ");
INSERT INTO hincv_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","तब उस बछड़े को याहवेह के सामने मिलनवाले तंबू के द्वार पर बलि चढ़ाना. ");
INSERT INTO hincv_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","तुम उस बछड़े का लहू अपनी उंगली पर लेकर वेदी के सींगों पर लगाना और बाकी बचे हुए लहू को वेदी पर डाल देना. ");
INSERT INTO hincv_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","उसकी अंतड़ियां के ऊपर की तथा कलेजे के ऊपर की चर्बी, तथा दोनों गुर्दों के ऊपर की चर्बी को वेदी पर जला देना. ");
INSERT INTO hincv_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","किंतु बैल, उसकी खाल, मांस और इस प्रक्रिया में उत्पन्‍न गोबर को छावनी के बाहर अग्नि में जला देना, क्योंकि यह पापबलि है. ");
INSERT INTO hincv_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“फिर एक मेढ़ा भी लेना और अहरोन तथा उसके पुत्र अपना हाथ उस मेढ़े के सिर पर रखें; ");
INSERT INTO hincv_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","फिर उस मेढ़े की बलि करके उसके लहू को एक साथ लेकर वेदी के आस-पास छिड़क देना. ");
INSERT INTO hincv_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","फिर उस मेढ़े के टुकड़े-टुकड़े करके, उसके आंतरिक अंगों तथा टांगों को धोकर, इन सबको सिर के साथ रख देना. ");
INSERT INTO hincv_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","और पूरे मेढ़े को वेदी पर जला देना. यह याहवेह के लिए होमबलि होगी, और याहवेह के लिए अग्नि में समर्पित सुखदायक सुगंध होगा. ");
INSERT INTO hincv_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“इसके बाद दूसरा मेढ़ा अर्थात् संस्कार का मेढ़ा प्रस्तुत किया जाये और अहरोन और उनके पुत्र उस मेढ़े के सिर पर अपने हाथ रखें. ");
INSERT INTO hincv_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","फिर उस मेढ़े को बलि करना, उसका कुछ रक्त लेकर अहरोन के दहिने कान पर तथा उनके दाएं हाथ एवं पांव के दाएं अंगूठों पर लगा देना तथा बाकी बचे हुए लहू को वेदी के चारों ओर छिड़क देना. ");
INSERT INTO hincv_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","फिर वेदी से थोड़ा लहू और अभिषेक का तेल लेकर अहरोन और उसके पुत्रों के ऊपर और उनके कपड़ों पर छिड़क देना; इससे अहरोन और उसके कपड़े तथा उसके पुत्र और उनके कपड़े पवित्र हो जायेंगे. ");
INSERT INTO hincv_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“मेढ़े को अभिषेक वाला मानकर उसकी चर्बी, उसकी पूंछ, अंतड़ियां तथा कलेजे के ऊपर की चर्बी, दोनों गुर्दे तथा उसकी चर्बी और मेढ़े की दायीं जांघ लेना—क्योंकि यह अभिषेक का मेढ़ा है, ");
INSERT INTO hincv_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","और एक रोटी, तेल से चुपड़ी एक पूरी, बिना खमीर रोटी की टोकरी में से एक पपड़ी, जो याहवेह के सामने रखी गई थी; ");
INSERT INTO hincv_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ये सभी वस्तुएं अहरोन एवं उसके पुत्रों के हाथों में रखकर इन्हें याहवेह को चढ़ाने की भेंट मानकर याहवेह के आगे लहराया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","फिर वह इन वस्तुओं को लेकर होमबलि के लिए वेदी पर जलाए ताकि यह याहवेह के लिए सुखदायक सुगंध हो. यह याहवेह के लिए अग्निबलि होगी. ");
INSERT INTO hincv_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","फिर अहरोन के अभिषेक के मेढ़े की छाती को लेकर याहवेह के सामने लहर की भेंट के रूप में लहराए. और वह तुम्हारा हिस्सा होगा. ");
INSERT INTO hincv_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“मेढ़े के लहराए जाने की भेंट वाली छाती तथा उठाए जाने की भेंट वाला जांघ, जिसे लहराया गया था, और जिसे अभिषेक के मेढ़े में से चढ़ाया था, जो अहरोन एवं उसके पुत्रों के हिस्से में से था, पवित्र करना. ");
INSERT INTO hincv_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","यह इस्राएल वंश से सदा के लिए अहरोन एवं उसके पुत्रों के लिए उनका हिस्सा होगा, क्योंकि यह उठाए जाने की भेंट है; यह इस्राएलियों की ओर से उनकी मेल बलियों में से याहवेह के लिए उठाए जाने की भेंट हो. ");
INSERT INTO hincv_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“अहरोन के बाद अहरोन के पवित्र कपड़े उसके पुत्र के होंगे, ताकि इन्हीं कपड़ों में उनको पवित्र एवं अभिषेक किया जा सके. ");
INSERT INTO hincv_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","अहरोन के बाद उसके पुत्रों में से जो पुरोहित बनेगा जब वह पवित्र स्थान में सेवा करने मिलनवाले तंबू में जाएगा तब अहरोन के कपड़ो को उसे सात दिन तक पहनना होगा. ");
INSERT INTO hincv_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“फिर अभिषेक के उस मेढ़े को तथा उसके मांस को एक पवित्र स्थान पर पकाना. ");
INSERT INTO hincv_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","अहरोन एवं उसके पुत्र, उस मेढ़े के मांस एवं उस टोकरी की रोटी दोनों को मिलनवाले तंबू के द्वार पर खाएं. ");
INSERT INTO hincv_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","इस प्रकार वे अभिषेक तथा पवित्र की गई वस्तुओं को खाएं, जिनके द्वारा प्रायश्चित किया गया था. लेकिन सामान्य व्यक्ति इसे न खाएं, क्योंकि ये वस्तुएं पवित्र हैं. ");
INSERT INTO hincv_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","यदि अभिषेक के मांस में से कुछ मांस एवं रोटी बच जाती है तो उसे आग में जला देना, क्योंकि ये पवित्र वस्तुएं हैं. ");
INSERT INTO hincv_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“अहरोन तथा उसके पुत्रों के साथ वही करना जो उनके साथ करने के लिए मैंने तुमसे कहा हैं; सात दिन तक उनको पवित्र करते रहना. ");
INSERT INTO hincv_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","रोज तुम पापबलि के लिए एक बछड़ा प्रायश्चित के लिए चढ़ाना. प्रायश्चित करने के समय वेदी को भी साफ़ करना. और उसे पवित्र करने के लिए उसका अभिषेक करना. ");
INSERT INTO hincv_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","सात दिन तक वेदी के लिए तुम प्रायश्चित करके उसे पवित्र करना तब यह वेदी महा पवित्र हो जाएगी. जो कोई इस वेदी को छुएगा पवित्र हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“और एक-एक साल के दो मेमने वेदी पर रोज चढ़ाना. ");
INSERT INTO hincv_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","एक मेमना सुबह तथा दूसरा शाम को चढ़ाना. ");
INSERT INTO hincv_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","पहले मेमने के साथ पेरकर निकाले गए एक लीटर तेल में मिला हुआ डेढ़ किलो मैदा तथा पेय बलि के लिए एक लीटर दाखरस चढ़ाना ");
INSERT INTO hincv_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","तथा दूसरे मेमने के साथ शाम को अन्‍नबलि और पेय बलि चढ़ाना होगा, जो याहवेह के लिए चढ़ाया गया एक सुखदायक सुगंध हो जाए. ");
INSERT INTO hincv_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“यह याहवेह के सामने, मिलनवाले तंबू के द्वार पर जहां मैं तुमसे मिलकर बातें करूंगा, तुम्हारी समस्त पीढ़ियों द्वारा याहवेह के लिए मिलनवाले तंबू के द्वार पर नियमित रूप से होमबलि चढ़ाई जाएगी. ");
INSERT INTO hincv_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","वहां मैं इस्राएलियों से मिलूंगा और वह तंबू मेरे तेज से पवित्र किया जायेगा. ");
INSERT INTO hincv_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“मैं मिलनवाले तंबू और वेदी को पवित्र करूंगा और अहरोन एवं उसके पुत्रों को भी पुरोहित के रूप में सेवा के लिए पवित्र करूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","मैं इस्राएलियों के साथ रहूंगा तथा मैं उनका परमेश्वर ठहरूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","तब वे जान लेंगे कि मैं याहवेह उनका परमेश्वर हूं, जिसने उन्हें मिस्र देश से निकाला ताकि मैं उनके साथ रहूं. मैं याहवेह उनका परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“धूप जलाने के लिए बबूल की लकड़ी की एक वेदी बनाना. ");
INSERT INTO hincv_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","वेदी चौकोर हो, उसकी लंबाई तथा चौड़ाई पैंतालीस-पैंतालीस सेंटीमीटर तथा ऊंचाई नब्बे सेंटीमीटर की हो, उसकी सींग उसी टुकड़े में से बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","वेदी के अंदर-बाहर, ऊपर-नीचे, चारों ओर सोना लगवाना—सींग में भी सोना लगवाना. इसके चारों ओर तुम सोने की किनारी लगवाना. ");
INSERT INTO hincv_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","इसकी किनारियों के नीचे सोने के दो-दो कड़े लगवाना. और इसको इन डंडे के द्वारा उठाने के लिए ही दोनों तरफ कड़े लगवाना जो आमने-सामने हो. ");
INSERT INTO hincv_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","डंडे बबूल की लकड़ी से बनाकर उसमें सोना लगाना. ");
INSERT INTO hincv_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","वेदी को उस पर्दे के सामने रखना, जो साक्षी पट्टिया के संदूक के पास है, अर्थात् करुणासन के आगे जो साक्षी पत्र के ऊपर है, वहीं मैं तुमसे मिला करूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“अहरोन इसी वेदी पर सुगंधधूप जलाया करे, वह हर रोज सुबह दीये को ठीक करके फिर दिया जलाए. ");
INSERT INTO hincv_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","अहरोन शाम के समय जब दीयों को जलाए तब धूप भी जलाए; यह धूप याहवेह के सामने पीढ़ी से पीढ़ी तक लगातार जलाया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","तुम उस वेदी पर और किसी प्रकार की धूप न जलाना और न उस पर होमबलि अथवा अन्‍नबलि चढ़ाना तथा न तुम इस वेदी पर कोई पेय बलि उण्डेलना. ");
INSERT INTO hincv_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","साल में एक बार अहरोन इस वेदी के सींगों पर प्रायश्चित किया करेगा. वह वर्ष में एक ही बार पीढ़ी से पीढ़ी तक पापबलि के लहू से प्रायश्चित किया करेगा. यह याहवेह के लिए परम पवित्र है.” ");
INSERT INTO hincv_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","याहवेह ने मोशेह से कहा ");
INSERT INTO hincv_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“जब तुम इस्राएलियों को गिनने लगो, और जिनकी गिनती हो चुकी हो वे अपने लिए याहवेह को प्रायश्चित दें ताकि गिनती करते समय कोई परेशानी न आ जाये. ");
INSERT INTO hincv_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","हर एक व्यक्ति, जिसको गिना जा रहा है, वह व्यक्ति पवित्र स्थान की नाप के अनुसार याहवेह के लिए चांदी का आधा शेकेल दे. एक शेकेल बीस गेराह है. ");
INSERT INTO hincv_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","हर एक पुरुष, जो बीस वर्ष से ऊपर का हो चुका है, और जिसकी गिनती की जा रही है, वह याहवेह को भेंट दे. ");
INSERT INTO hincv_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","जब कभी तुम अपने प्रायश्चित के लिए याहवेह को भेंट दो तब न तो धनी व्यक्ति आधे शेकेल से ज्यादा दे और न गरीब आधे शेकेल से कम दे. ");
INSERT INTO hincv_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","तुम इस्राएलियों से प्रायश्चित का रुपया लेकर मिलनवाले तंबू के कामों में लेना ताकि यह इस्राएलियों के लिए याहवेह के सामने यादगार बन जाए, और अपने प्राण का प्रायश्चित भी हो जाए.” ");
INSERT INTO hincv_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","फिर याहवेह ने मोशेह से कहा, ");
INSERT INTO hincv_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“तुम्हें कांसे की एक हौद भी बनानी होगी. उसका पाया कांसे का बनाना. यह हाथ-पैर धोने के लिए काम में लिया जायेगा. उसे मिलनवाले तंबू और वेदी के बीच में रखकर उसमें पानी भरना. ");
INSERT INTO hincv_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","अहरोन तथा उसके पुत्र इसी पानी में अपने हाथ एवं पांव धोया करें. ");
INSERT INTO hincv_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","जब-जब वे मिलनवाले तंबू में जायें तब-तब वे हाथ-पांव धोकर ही जाएं, और जब वे वेदी के समीप याहवेह की सेवा करने या धूप जलाने जाएं; ");
INSERT INTO hincv_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","तब वे हाथ-पांव धोकर ही जाएं ऐसा नहीं करने से वे मर जायेंगे. अहरोन एवं उसके वंश को पीढ़ी से पीढ़ी के लिए सदा यही विधि माननी है.” ");
INSERT INTO hincv_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","और याहवेह ने मोशेह से कहा ");
INSERT INTO hincv_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“तुम उत्तम से उत्तम सुगंध द्रव्य, पवित्र स्थान की माप के अनुसार साढ़े पांच किलो, गन्धरस, पौने तीन किलो सुगंधित दालचीनी, पौने तीन किलो सुगंधित अगर, ");
INSERT INTO hincv_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","साढ़े पांच किलो दालचीनी तथा पौने चार लीटर जैतून का तेल. ");
INSERT INTO hincv_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","इन सबको लेकर अभिषेक का पवित्र तेल तैयार करना, ऐसा कार्य जैसा इत्र बनानेवाले का हो; और यह अभिषेक का पवित्र तेल कहलायेगा. ");
INSERT INTO hincv_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","और इसी तेल से मिलनवाले तंबू, साक्षी पत्र के संदूक, ");
INSERT INTO hincv_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","मेज़ और उसकी सारी चीज़ें, दीया और उसकी सारी चीज़ें, तथा सुगंधधूप वेदी, ");
INSERT INTO hincv_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","होमबलि की वेदी, पाए के साथ हौदी का अभिषेक करना. ");
INSERT INTO hincv_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","तुम इन सबको पवित्र करना, ताकि ये सब अति पवित्र हो जाएं. जो कोई इनको छुएगा, वह पवित्र हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“तुम अहरोन एवं उसके पुत्रों को अभिषेक करके पवित्र करना, ताकि वे मेरे पुरोहित होकर मेरी सेवा किया करें. ");
INSERT INTO hincv_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","तुम इस्राएलियों से यह कहना, ‘यह पीढ़ी से पीढ़ी तक मेरे लिए पवित्र अभिषेक का तेल होगा. ");
INSERT INTO hincv_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","यह किसी भी मनुष्य के शरीर पर न डालना और न ही तुम कभी भी इसके समान कोई और तेल बनाना. यह पवित्र तेल है. यह तुम्हारे लिए पवित्र रहेगा. ");
INSERT INTO hincv_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","जो कोई उस पवित्र तेल के समान कोई और तेल बनाने की कोशिश करे या उसमें से किसी अन्य व्यक्ति को दे, तो उसे अपने लोगों के बीच से निकाल दिया जाये.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","फिर याहवेह ने मोशेह से कहा, “तुम गन्धरस, नखी, गन्धाबिरोजा, सुगंध द्रव्य तथा शुद्ध लोबान, ये सब बराबर मात्रा में लेना, और ");
INSERT INTO hincv_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","इन्हें लेकर एक सुगंधधूप बनाना—जैसे लवण के साथ, विशुद्ध तथा पवित्र हवन सामग्री को बनाता है. ");
INSERT INTO hincv_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","इसमें से छोटा टुकड़ा लेकर बारिक पीसकर थोड़ा मिलनवाले तंबू में साक्षी पत्र के आगे रखना, जहां मैं तुमसे भेंट करूंगा. वह तुम्हारे लिए परम पवित्र होगा. ");
INSERT INTO hincv_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","जो धूप तुम बनाओगे, उसमें अपनी इच्छा से कुछ मिलावट न करना बल्कि इसे याहवेह के लिए पवित्र रखना. ");
INSERT INTO hincv_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","जो कोई धूप के लिए अपनी मर्जी से कुछ भी मिलायेगा तो उसे निकाल दिया जाये.” ");
INSERT INTO hincv_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","फिर याहवेह ने मोशेह से कहा, ");
INSERT INTO hincv_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“सुनो, मैंने यहूदाह गोत्र के हूर के पौत्र, उरी के पुत्र बसलेल को नाम लेकर बुलाया है. ");
INSERT INTO hincv_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","मैंने उसे मेरे आत्मा से प्रवीणता, समझ, बुद्धि और सब कामों की समझ देकर भर दिया है, ");
INSERT INTO hincv_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ताकि वह सोना, चांदी एवं कांसे पर कलात्मक रचना कर सके, ");
INSERT INTO hincv_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","जड़ने के उद्देश्य से पत्थर काटने में कुशल तथा लकड़ी के खोदने में बुद्धि से कलाकारी का काम कर सके. ");
INSERT INTO hincv_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","और मैंने उसके साथ दान गोत्र के अहीसामक के पुत्र ओहोलियाब को सहायक चुना है. “तथा उन सभी में जो योग्य हैं, उनको मैं समझ देता हूं कि वे वह सब बनाएं, जो मैंने तुमसे कहा. ");
INSERT INTO hincv_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“जैसे मिलनवाले तंबू, साक्षी पत्र का संदूक, उसके ऊपर करुणासन, और तंबू का सारा सामान, ");
INSERT INTO hincv_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","मेज़ तथा उसका सारा सामान, सोने का दीया तथा उसका सारा सामान, तथा धूप वेदी, ");
INSERT INTO hincv_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","होमबलि की वेदी तथा उसका सारा सामान, तथा पाया सहित उसकी हौदी, ");
INSERT INTO hincv_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","बुने हुए वस्त्र, तथा पुरोहित अहरोन तथा उसके पुत्रों के पवित्र वस्त्र, जो वे पुरोहित का काम करते वक्त पहनेंगे; ");
INSERT INTO hincv_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","अभिषेक का तेल और सुगंधित धूप, जो पवित्र स्थान के लिए है, “इन सब चीज़ों को वे परमेश्वर की आज्ञा के अनुसार तैयार करें.” ");
INSERT INTO hincv_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","फिर याहवेह ने मोशेह से कहा, ");
INSERT INTO hincv_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“तुम इस्राएलियों से कहना, ‘तुम मेरे विश्राम दिन को मानना; क्योंकि यह तुम्हारे पीढ़ी से पीढ़ी तक मेरे एवं तुम्हारे बीच में एक चिन्ह होगा, ताकि तुम यह जान लो कि मैं ही याहवेह हूं, जो तुम्हें पवित्र करता हूं. ");
INSERT INTO hincv_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘तुम्हें विश्राम दिन को मानना ही है, क्योंकि यह तुम्हारे लिए पवित्र है. और जो इसे अपवित्र करेगा, वह निश्चय मार डाला जायेगा; जो कोई विश्राम दिन पर कोई भी काम करेगा, वह व्यक्ति उसके समाज में से मिटा दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","छः दिन तुम काम कर सकते हो, परंतु सातवां दिन पूरा विश्राम का दिन होगा जो याहवेह के लिए पवित्र है. ");
INSERT INTO hincv_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","इस्राएलियों में इस दिन को विश्राम दिन मानकर उनकी सारी पीढ़ी हमेशा इस वाचा को याद रखते हुए इस दिन को माने. ");
INSERT INTO hincv_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","यह मेरे तथा इस्राएलियों के बीच में पक्का वादा और चिन्ह है; क्योंकि छः दिनों में याहवेह ने स्वर्ग तथा पृथ्वी को बनाया, लेकिन सातवें दिन उन्होंने आराम किया.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","जब याहवेह सीनायी पर्वत पर मोशेह से बात कर चुके, तब परमेश्वर ने मोशेह को अपने हाथ से लिखी हुई साक्षी की दो पत्थर की पट्टियां दीं. ");
INSERT INTO hincv_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","जब लोगों ने देखा कि पर्वत से आने में मोशेह विलम्‍ब कर रहे हैं, तब लोगों ने अहरोन के पास जाकर उनसे कहा, “हमारे लिए एक देवता बनाइए जो हमारे आगे-आगे चलकर हमारी अगुवाई करे, क्योंकि मोशेह हमें मिस्र से तो निकालकर ले आये, परंतु अब मोशेह का कोई पता नहीं. अब आगे क्या होगा नहीं मालूम.” ");
INSERT INTO hincv_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","यह सुनकर अहरोन ने कहा, “अपनी-अपनी पत्नियों और पुत्र, पुत्रियों के गहने उतारकर यहां ले आओ.” ");
INSERT INTO hincv_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","सभी अपने-अपने कानों से गहने उतारकर अहरोन के पास ले आए. ");
INSERT INTO hincv_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","अहरोन ने उनसे सोना ले लिया और एक औज़ार से उसे बछड़े का एक रूप ढाल लिया, सबने यह नारा लगाया: “इस्राएल, यह है तुम्हारे देवता, जो तुम्हें मिस्र देश से निकाल लाए है.” ");
INSERT INTO hincv_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","तब अहरोन ने इस बछड़े के लिए एक वेदी बनाई और कहा, “कल याहवेह के लिए एक उत्सव होगा.” ");
INSERT INTO hincv_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","दूसरे दिन वे सब जल्दी उठ गए और उन्होंने होमबलि चढ़ाई, और वे मेल बलियां लाए और खाने-पीने बैठ गए; और खड़े होकर रंगरेलियां मनाने लगे. ");
INSERT INTO hincv_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","याहवेह ने मोशेह से कहा, “जल्दी नीचे जाओ, क्योंकि लोगों ने, जिन्हें तुम मिस्र देश से निकालकर लाए, अपने आपको अपवित्र कर दिया है. ");
INSERT INTO hincv_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","वे इतनी जल्दी उन सब विधियों को भूल गये, जिन्हें मैंने बताई थी. उन्होंने अपने लिए एक बछड़ा बनाया और उसकी उपासना करने लगे. उन्होंने इसके लिए बलि चढ़ाई और कहा, ‘इस्राएल, तुम्हारे देवता यही है जो तुम्हें मिस्र देश से निकालकर लाए हैं!’ ” ");
INSERT INTO hincv_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","याहवेह ने मोशेह से कहा, “मैंने इन लोगों को देख लिया कि उन्होंने क्या किया है; ये हठीले लोग हैं. ");
INSERT INTO hincv_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","तुम अब मुझे मत रोकना मेरा गुस्सा उनके लिए बहुत बढ़ गया है और उन्हें नष्ट कर डालूंगा. लेकिन मैं तुम्हारे द्वारा एक बड़ी जाति बनाऊंगा.” ");
INSERT INTO hincv_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","तब मोशेह, याहवेह अपने परमेश्वर से बिनती करने लगे, “हे याहवेह, आपकी क्रोधाग्‍नि उन पर क्यों भड़क रही है जिनको आपने अपनी सामर्थ्य और बड़ी शक्ति से मिस्र से निकाला है? ");
INSERT INTO hincv_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","मिस्रियों को यह कहने का क्यों दें, कि याहवेह उन्हें मिस्र से इसलिये निकाल ले गये कि उन्हें पहाड़ पर मार डालें, और उन्हें पृथ्वी के ऊपर से मिटा डालें? आप अपने गुस्से को शांत करें और लोगों को नष्ट करने की सोच छोड़ दीजिए. ");
INSERT INTO hincv_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","अपने दास अब्राहाम, यित्सहाक तथा इस्राएल से अपने नाम से की गई शपथ को याद कीजिये. आपने उनसे कहा था, ‘मैं तुम्हारे वंश को आकाश के तारों जितना बढ़ा दूंगा, और सारा देश तुम्हें दूंगा और वे इस देश के अनंत अधिकारी होंगे.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","यह सुनकर याहवेह ने पछताया और अपने लोगों पर वह विपत्ति न लाई, जिसकी उन्होने धमकी दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","और मोशेह मुड़कर पर्वत से नीचे उतर आए. वह अपने हाथों में व्यवस्था की दो पट्टियां लिए हुए थे. इन पट्टियों में दोनों तरफ लिखा हुआ था, आगे और पीछे. ");
INSERT INTO hincv_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ये पट्टियां परमेश्वर ने बनाई थी और उसमें जो खोदकर लिखा हुआ था वह परमेश्वर का लिखा हुआ था. ");
INSERT INTO hincv_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","जब यहोशू ने लोगों के चिल्लाने की आवाज सुनी; तब उन्होंने मोशेह से कहा, “छावनी से लड़ाई की आवाज सुनाई दे रही है.” ");
INSERT INTO hincv_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","किंतु मोशेह ने कहा, “यह न तो जीत की खुशी की आवाज हैं, और न हार के दुःख की, लेकिन मुझे तो गाने की आवाज सुनाई दे रही है.” ");
INSERT INTO hincv_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","और जैसे ही मोशेह पड़ाव के पास पहुंचे, उन्होंने बछड़े के सामने लोगों को नाचते हुए देखा. गुस्से में मोशेह ने याहवेह की दी हुई पट्टियां नीचे फेंक दीं और पटियां चूर-चूर हो गई. ");
INSERT INTO hincv_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","मोशेह ने वह बछड़ा जिसे लोगों ने बनाया था, उसे आग में जला दिया और उसकी राख लेकर पानी में मिला दिया, तथा वह पानी इस्राएलियों को पीने के लिए मजबूर किया. ");
INSERT INTO hincv_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","मोशेह ने अहरोन से कहा, “इन लोगों ने तुम्हारे साथ क्या किया कि तुमने उनसे इतना बड़ा पाप करवाया?” ");
INSERT INTO hincv_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","अहरोन ने जवाब दिया, “मेरे प्रभु आप नाराज मत होइए, आप इन लोगों को अच्छी तरह जानते हो कि ये पाप करने के लिये कितने इच्छुक रहते हैं! ");
INSERT INTO hincv_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","उन्होंने मुझसे कहा, ‘हमारे लिए एक ऐसे देवता बनाइए, जो हमारी अगुवाई कर सके; क्योंकि मोशेह, जो हमें मिस्र से निकाल लाए, उनका कुछ पता नहीं.’ ");
INSERT INTO hincv_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","तब मैंने उनसे कहा, ‘जिस किसी के पास सोना है, वह उसे यहां ले आए.’ वे सोना मेरे पास ले आए, मैंने सोने को आग में डाला और आग से यह बछड़ा बाहर निकल आया.” ");
INSERT INTO hincv_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","मोशेह ने देखा कि लोग जंगलीपन पर उतर आये हैं और अहरोन ने उन्हें इतनी छूट दे दी कि वह अपने बैरियों के हास्य पात्र बन गये. ");
INSERT INTO hincv_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","तब मोशेह ने छावनी के द्वार पर खड़े होकर कहा, “जो कोई याहवेह की ओर का है, वह मेरे पास आए!” सभी लेवी वंश के लोग मोशेह के पास आ गए. ");
INSERT INTO hincv_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","मोशेह ने उनसे कहा, “इस्राएल का परमेश्वर, याहवेह यों कहते हैं, ‘तुममें से हर एक पुरुष अपनी-अपनी तलवार उठाए, छावनी के एक छोर से दूसरे छोर तक जाए, और जाते-जाते तुममें से हर एक व्यक्ति अपने भाई को, मित्र तथा पड़ोसी को मारता हुए जाए.’ ” ");
INSERT INTO hincv_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","तब लेवियों ने वही किया, जैसा मोशेह ने कहा. उस दिन लगभग तीन हजार लोग मारे गए. ");
INSERT INTO hincv_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","फिर मोशेह ने कहा, “आज तुम्हें याहवेह के लिए अलग किया गया है, क्योंकि हर एक ने अपने पुत्र तथा अपने भाई का विरोध किया और इसलिये याहवेह ने तुमको आशीष दी है.” ");
INSERT INTO hincv_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","अगले दिन मोशेह ने लोगों से कहा कि तुम सबने बहुत बड़ा पाप किया है. और मैं अब याहवेह के सम्मुख प्रायश्चित करने जा रहा हूं. ");
INSERT INTO hincv_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","यह कहकर मोशेह याहवेह के पास गए और कहा, “लोगों ने बहुत बड़ा पाप किया है. उन्होंने अपने लिए सोने का देवता बनाया. ");
INSERT INTO hincv_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","लेकिन आप चाहें तो उनका पाप क्षमा कर दीजिए—यदि नहीं, तो कृपा कर मेरा नाम अपनी उस किताब से हटा दीजिए, जो आपने लिखी है!” ");
INSERT INTO hincv_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","याहवेह ने मोशेह से कहा, “अपनी किताब से मैं उसी व्यक्ति का नाम मिटाऊंगा जिसने मेरे विरुद्ध पाप किया है. ");
INSERT INTO hincv_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","किंतु अब तुम जाओ. इन लोगों को उस जगह पर ले जाओ जो मैंने तुमसे कहा था; मेरा स्वर्गदूत तुम्हारे आगे-आगे चलेगा. लेकिन जब उनको दंड देने का समय आएगा, मैं उनके पाप का दंड उन्हें ज़रूर दूंगा.” ");
INSERT INTO hincv_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","याहवेह ने लोगों के बीच एक महामारी भेजी, क्योंकि उन लोगों ने अहरोन से कहकर बछड़ा बनवाया था और उसकी उपासना की थी. ");
INSERT INTO hincv_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","फिर याहवेह ने मोशेह से कहा, “इन लोगों को, जिन्हें मैं मिस्र देश से छुड़ाकर लाया हूं—उन्हें उस देश में ले जाओ, जिसका वायदा मैंने अब्राहाम, यित्सहाक तथा याकोब से किया था. ");
INSERT INTO hincv_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","मैं तुम्हारे आगे स्वर्गदूत भेजूंगा. मैं उन कनानियों, अमोरियों, हित्तियों, परिज्ज़ियों, हिव्वियों तथा यबूसियों को वहां से निकाल दूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","और तुम्हें ऐसे देश में ले जाऊंगा, जिसमें दूध और मधु की धारा बहती है. और मैं तुम्हारे साथ नहीं चलूंगा, क्योंकि तुम लोग पापी हो और कहीं गुस्से में होकर मैं तुमको नाश न कर दूं.” ");
INSERT INTO hincv_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","याहवेह की इन क्लेशकारी बातों को सुनकर लोग दुःखी हुए और रोने लगे, और किसी ने भी गहने नहीं पहने; ");
INSERT INTO hincv_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","क्योंकि मोशेह से याहवेह ने कहा था, “इस्राएलियों से कह दो कि तुम हठीले हो. और यदि मैं तुम्हारे साथ एक क्षण भी चलूं, तो हो सकता है कि तुम्हें मैं नाश कर दूं, इसलिये अब तुम सब अपने गहने उतार दो और मुझे सोचने दो कि मैं तुम्हारे साथ क्या करूं.” ");
INSERT INTO hincv_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","इस्राएलियों ने जो गहने पहने थे उन्हें होरेब पर्वत में उतार दिये. ");
INSERT INTO hincv_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","मोशेह ने छावनी से दूर एक तंबू खड़ा किया और उसका नाम मिलनवाले तंबू, रखा. जिस किसी को भी याहवेह से मिलने की इच्छा होती, वे छावनी के बाहर मिलनवाले तंबू के पास चले जाते. ");
INSERT INTO hincv_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","और जब मोशेह मिलनवाले तंबू में जाने के लिए उनके सामने से होकर निकलते, तब सब लोग खड़े हो जाते और मोशेह को तब तक देखते रहते, जब तक मोशेह मिलनवाले तंबू के अंदर न चले जाते. ");
INSERT INTO hincv_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","जैसे ही मोशेह मिलनवाले तंबू में चले जाते, बादल का खंभा मिलनवाले तंबू के द्वार पर रुक जाता था और याहवेह मोशेह से बातें करते थे. ");
INSERT INTO hincv_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","तब सब लोग मिलनवाले तंबू पर बादल का खंभा देखकर सब अपने-अपने तंबू से दंडवत करते थे. ");
INSERT INTO hincv_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","याहवेह मोशेह से इस प्रकार बात करते, जैसे अपने मित्र से बात कर रहे हों. फिर मोशेह वापस छावनी में आ जाते थे; परंतु नून के पुत्र यहोशू, जो मोशेह के सेवक था, वह मिलनवाले तंबू को नहीं छोड़ता था. ");
INSERT INTO hincv_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मोशेह ने याहवेह से कहा, “आपने मुझे यह जवाबदारी दी कि इन लोगों को उस देश में ले जाऊं! लेकिन आपने मुझे यह नहीं बताया कि आप किसे मेरे साथ वहां भेजेंगे. और आपने यह आश्वासन भी दिया है कि तुम्हें तो मैं तुम्हारे नाम से जानता हूं और मेरा अनुग्रह तुम्हारे साथ है. ");
INSERT INTO hincv_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","अब, मुझ पर आपका अनुग्रह हैं तो, मुझे आपकी गति समझा दीजिए, ताकि मैं आपको समझ सकूं तथा आपका अनुग्रह जो मुझ पर हैं, वह हमेशा रहे और यह भी याद रखे कि यह जाति भी आपके लोग है.” ");
INSERT INTO hincv_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","याहवेह ने कहा, “तुम्हारे साथ मेरी उपस्थिति बनी रहेगी तथा मैं तुम्हें शांति और सुरक्षा दूंगा.” ");
INSERT INTO hincv_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","यह सुन मोशेह ने कहा, “यदि आप हमारे साथ नहीं होंगे, तो हमें यहां से आगे नहीं जाने दें. ");
INSERT INTO hincv_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","अब यदि आपकी उपस्थिति हमारे साथ नहीं रहेगी, तो सब लोग यह कैसे जानेंगे कि आपका अनुग्रह मुझ पर और इन लोगों के साथ है? और कौन सी ऐसी बात है जो हमें दूसरे लोगों के सामने अलग दिखाएगी?” ");
INSERT INTO hincv_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","याहवेह ने मोशेह से कहा, “मैं तुम्हारी इस बात को भी मानूंगा, जो तुमने मुझसे कही; क्योंकि तुम मेरे प्रिय हो और मेरा अनुग्रह तुम्हारे साथ हैं और तुम्हारा नाम मेरे ह्रदय में बसा है.” ");
INSERT INTO hincv_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","यह सुन मोशेह ने कहा, “मुझे अपना प्रताप दिखायें!” ");
INSERT INTO hincv_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","याहवेह ने कहा, “मैं तुम्हारे सामने से चलते हुए अपनी भलाई तुम्हें दिखांऊगा और मेरे नाम की घोषणा करूंगा और मैं जिस किसी पर चाहूं, कृपादृष्टि करूंगा, और जिस किसी पर चाहूं; करुणा.” ");
INSERT INTO hincv_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","फिर याहवेह ने कहा, “तुम मेरा मुख नहीं देख सकते, क्योंकि कोई भी मनुष्य मुझे देखने के बाद जीवित नहीं रह सकता!” ");
INSERT INTO hincv_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","फिर याहवेह ने कहा, “जहां मैं हूं, इस स्थान के पासवाली चट्टान पर खड़ा होना. ");
INSERT INTO hincv_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","जब मेरा प्रताप वहां से होकर आगे बढ़ेगा, मैं तुम्हें चट्टान की दरार में छिपा दूंगा और वहां से निकलने तक तुम्हें अपने हाथ से ढांपे रखूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","फिर मैं अपना हाथ हटा लूंगा. तुम उस समय मेरी पीठ को देख पाओगे—मेरा मुख तुम्हें दिखाई नहीं देगा.” ");
INSERT INTO hincv_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","याहवेह ने मोशेह से कहा, “पहले के ही समान दो पट्टियां मेरे पास लाओ; मैं दुबारा उन दोनों पर वही वचन लिखूंगा जो प्रथम पट्टियों पर लिखे थे और जिन्हें तुमने तोड़ दिए थे. ");
INSERT INTO hincv_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","सबेरे तुम तैयार रहना और सीनायी पर्वत पर चढ़ आना, वहां मेरे समक्ष तुम प्रस्तुत होना. ");
INSERT INTO hincv_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","कोई भी व्यक्ति तुम्हारे साथ न आए और न किसी भी व्यक्ति को पर्वत पर लाना—यहां तक कि भेड़-बकरी तथा अन्य पशुओं को भी पर्वत के सामने चरने न दिया जाए.” ");
INSERT INTO hincv_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","इसलिये मोशेह ने पत्थर की दो पट्टियां तराशी और उन्हें लेकर सबेरे सीनायी पर्वत पर गए, जैसा याहवेह ने कहा था; वह उन पट्टियों को अपने हाथ में लिये थे. ");
INSERT INTO hincv_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","तब याहवेह बादल में मोशेह के पास खड़े हो गए तथा अपने नाम “याहवेह” की घोषणा की. ");
INSERT INTO hincv_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","याहवेह मोशेह के पास से होकर निकले और कहा, “याहवेह, जो याहवेह परमेश्वर वह, दयालु, कृपालु, क्रोध करने में धीरजवंत तथा अति करुणामय एवं सत्य से परिपूर्ण हैं, ");
INSERT INTO hincv_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","हजारों पीढ़ियों तक करुणा करनेवाले, जो अधर्म, अपराध और पाप का क्षमा करनेवाले हैं; परंतु दोषी को किसी भी स्थिति में बिना दंड दिए नहीं छोड़ते. पूर्वजों के अधर्म का दंड उनके बेटों, पोतों और परपोतों तक को देते हैं.” ");
INSERT INTO hincv_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","मोशेह ने भूमि पर झुककर आराधना की. ");
INSERT INTO hincv_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","उन्होंने कहा, “हे प्रभु, यदि आपकी दया मुझ पर है, तो आप हमारे साथ चलिये, यद्यपि ये लोग पापी और हठीले हैं, तो भी हमारे अधर्म और पाप को क्षमा कीजिये तथा हमें अपना मानकर स्वीकार कीजिये.” ");
INSERT INTO hincv_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","फिर याहवेह ने कहा, “सुनो, मैं एक वाचा बांधता हूं कि मैं सब लोगों के सामने अनोखे काम करूंगा, जो इससे पहले पृथ्वी पर और न किसी जाति के बीच में कभी हुए हैं. वे सब लोग जो तुम्हारे बीच रहते हैं, इन कामों को देखेंगे, क्योंकि मैं तुम्हारे साथ एक भयानक काम करूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","आज जो कुछ मैं तुमसे कह रहा हूं, तुम उसे मानना. तुम्हारे बीच से अमोरियों, कनानियों, हित्तियों, परिज्ज़ियों, हिव्वियों तथा यबूसियों को मैं निष्कासित कर दूंगा. ");
INSERT INTO hincv_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","इसलिये ध्यान रखना; जिस देश में तुम रहने जा रहे हो, तुम उस देश के लोगों से वाचा नहीं बांधो, कहीं ऐसा न हो कि यही तुम्हारे लिए फंदा बन जाए. ");
INSERT INTO hincv_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","लेकिन तुम उनकी वेदी गिरा देना, उनके पूजा के खंभों को तोड़ देना तथा उनकी अशेरा नामक मूर्ति को काट डालना. ");
INSERT INTO hincv_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","तुम किसी भी देवता को दंडवत नहीं करना, क्योंकि याहवेह, जिसका नाम जलनशील है, वह वास्तव में जलनशील परमेश्वर हैं! ");
INSERT INTO hincv_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“ऐसा न हो कि तुम उस देश के लोगों से वाचा बांधो और वे देवताओं के संग व्यभिचार पूजा करके तुम्हें न्योता दें, और देवताओं को बलि चढ़ाई हुई वस्तु को खाने के लिए कहें. ");
INSERT INTO hincv_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","तुम उनकी बेटियों को अपने बेटों की पत्नियां न बनाना, क्योंकि उनकी बेटियां देवताओं के संग व्यभिचार करनेवाली होंगी और तुम्हारे बेटों को भी उस राह पर ले जाएंगी. ");
INSERT INTO hincv_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“तुम कभी कोई देवताओं की मूर्ति न बनाना. ");
INSERT INTO hincv_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“तुम खमीर रहित रोटी का उत्सव मनाया करना. तुम सात दिन बिना खमीर रोटी खाना, इसे अबीब महीने में मनाना, क्योंकि तुम अबीब महीने में ही मिस्र देश से निकले थे. ");
INSERT INTO hincv_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“किसी भी स्त्री का पहलौठा मेरा है. पहलौठा जानवर भी; तुम्हारी गाय, बकरियों या भेड़ों से जो पहलौठा उत्पन्‍न होता है, वे सब मेरे है. ");
INSERT INTO hincv_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","गधे के पहलौठे के बदले मेमने का पहलौठा दे सकते हो. यदि तुम यह न करो, तो तुम्हें उसकी गर्दन तोड़नी होगी. तुम्हें अपने पहले बेटों को बदला देकर छुड़ाना होगा. “मेरे पास कोई भी खाली हाथ न आये. ");
INSERT INTO hincv_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“तुम छः दिन तो काम करना, परंतु सातवें दिन कोई काम न करना, न खेत जोतने के समय न फसल कटने के समय. ");
INSERT INTO hincv_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“गेहूं की पहली उपज की कटनी के समय सप्‍ताहों के उत्सव को मनाना और साल के अंत में जमा करने का पर्व भी मनाना. ");
INSERT INTO hincv_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","तुममें से हर एक पुरुष साल में इन तीन अवसरों पर इस्राएल के परमेश्वर प्रभु याहवेह के सम्मुख उपस्थित हों. ");
INSERT INTO hincv_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","क्योंकि मैं वहां से सारी जनता को निकालूंगा और तुम्हारे राज्य की सीमाओं को बढ़ाऊंगा, और जब तुम साल में तीन बार याहवेह अपने परमेश्वर के पास आओगे, तब कोई भी तुम्हारी ज़मीन का लालच न करेगा. ");
INSERT INTO hincv_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“तुम मेरी बलि के रक्त को किसी भी खमीर के साथ न चढ़ाना और फ़सह के पर्व की बलि में से सुबह तक के लिए कुछ न बचाना. ");
INSERT INTO hincv_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“तुम अपने खेत की उपज का पहला भाग याहवेह तुम्हारे परमेश्वर के घर में ले आना. “तुम बकरी के बच्‍चे को उसकी मां के दूध में नहीं पकाना.” ");
INSERT INTO hincv_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","फिर याहवेह ने मोशेह से कहा, “मेरी इस बात को लिख लो, क्योंकि इसी बात के अनुसार मैंने तुमसे तथा इस्राएलियों से वायदा किया है.” ");
INSERT INTO hincv_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मोशेह याहवेह के साथ चालीस दिन तथा चालीस रात रहे. उन्होंने न तो रोटी खाई और न पानी पिया. उन्होंने उन पट्टियों पर परमेश्वर की वाचा अथवा दस आज्ञाएं लिखीं. ");
INSERT INTO hincv_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","सीनायी पर्वत से उतरते समय, मोशेह के हाथ में साक्षी की दोनों पट्टियां थीं, तथा याहवेह के साथ रहने के कारण उनके चेहरे से किरणें निकल रही थीं, पर वे यह बात नहीं जानते थे. ");
INSERT INTO hincv_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","जब अहरोन तथा सभी इस्राएलियों ने उनकी ओर देखा, तब उन्होंने उनके चेहरे पर किरणें देखीं और वे उनके पास जाने के लिए डर रहे थे. ");
INSERT INTO hincv_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","किंतु मोशेह ने उन्हें अपने पास बुलाया; अहरोन एवं सभी प्रधान मोशेह के पास गए. ");
INSERT INTO hincv_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","सभी इस्राएलियों को भी पास बुलाकर मोशेह ने उन्हें सीनायी पर्वत पर याहवेह द्वारा कही बातों को मानने के लिए कहा. ");
INSERT INTO hincv_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","जब मोशेह अपनी बात पूरी कह चुके, तब उन्होंने अपने मुंह को ढंक लिया. ");
INSERT INTO hincv_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","मोशेह जब कभी भी याहवेह के पास जाते तब मुंह बिना ढंके जाते, लेकिन जब बाहर लोगों के पास आते और जो आज्ञा याहवेह ने दी हैं उन्हें वैसा ही इस्राएलियों से कह देते, ");
INSERT INTO hincv_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","तब इस्राएली मोशेह का चेहरा देखते थे कि कैसे मोशेह के चेहरे से किरणें निकलती थीं. फिर जब तक मोशेह याहवेह के पास अंदर न जाते, तब तक अपना चेहरा ढंक कर रखते थे. ");
INSERT INTO hincv_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मोशेह ने सभी इस्राएलियों से कहा, “जो काम याहवेह ने करने के लिए कहा वह यह है: ");
INSERT INTO hincv_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","छः दिन तुम काम करना, लेकिन सातवां दिन पवित्र और याहवेह के लिए परम विश्राम का दिन मानना. जो कोई इस दिन काम करते हुए पाया जाए, उसे मार डाला जाए. ");
INSERT INTO hincv_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","किसी भी घर में विश्राम के दिन आग तक न जलाएं.” ");
INSERT INTO hincv_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","मोशेह ने सभी इस्राएलियों को कहा, “याहवेह कहते हैं ");
INSERT INTO hincv_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","कि तुम सब मिलकर याहवेह के लिए भेंट लाओ. जो कोई अपनी इच्छा से देना चाहे वे; “सोना, चांदी, कांसे; ");
INSERT INTO hincv_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","नीले, बैंगनी तथा लाल सूक्ष्म मलमल; बकरे के रोम; ");
INSERT INTO hincv_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","मेढ़े की रंगी हुई लाल खाल; सूंस की खाल बबूल की लकड़ी; ");
INSERT INTO hincv_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","दीपक के लिए तेल; अभिषेक का तेल एवं सुगंधधूप के लिए सुगंध द्रव्य; ");
INSERT INTO hincv_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","सुलेमानी गोमेद नाग तथा अन्य नग एफ़ोद तथा सीनाबंद में जड़ने के लिए दें. ");
INSERT INTO hincv_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“तुममें से जो कुशल कारीगर हैं, वे आये और याहवेह ने जिन चीज़ों को बनाने की आज्ञा दी है, उन चीज़ों को बनाएं: ");
INSERT INTO hincv_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“तंबू, ओहार समेत निवास उसकी घुंड़ी, उसके लिए आवश्यक तख्ते, बड़े, छड़, खंभे तथा कुर्सियां; ");
INSERT INTO hincv_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","संदूक, डंडों समेत करुणासन, बीच वाला पर्दा; ");
INSERT INTO hincv_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","मेज़ और उसके सभी सामान और डंडे, भेंट की रोटी; ");
INSERT INTO hincv_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","प्रकाश के लिए दीया, उससे संबंधित पात्र, दीप एवं उनके लिए आवश्यक तेल; ");
INSERT INTO hincv_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","धूप वेदी डंडों समेत, अभिषेक का तेल तथा सुगंधधूप; आंगन के प्रवेश द्वार के लिए पर्दा; ");
INSERT INTO hincv_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","होमबलि की वेदी और उसकी कांसे की झंझरी, उसके डंडे तथा उसके सामान; कांसे की हौदी, ");
INSERT INTO hincv_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","आंगन के लिए पर्दा, खंभे और कुर्सियां, और आंगन के द्वार का पर्दा; ");
INSERT INTO hincv_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","निवास और आंगन दोनों की खूंटियां तथा रस्सियां; ");
INSERT INTO hincv_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","पवित्र स्थान में सेवा के अवसर पर बुने हुए वस्त्र, अहरोन तथा उनके पुत्रों के लिए पवित्र वस्त्र, जो पुरोहित के पद पर कार्य करते समय पहना जायेगा.” ");
INSERT INTO hincv_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","इसके बाद इस्राएल के सारे लोग मोशेह के पास से चले गये. ");
INSERT INTO hincv_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","जिसका मन आनंद से भर गया वे अपनी इच्छा से मिलनवाले तंबू के बनाने के कार्य के लिये और सेवकाई में और पवित्र वस्त्र बनाने के लिए याहवेह के लिए भेंट लाने लगे. ");
INSERT INTO hincv_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","तब वे सभी स्त्री-पुरुष, अपनी इच्छा से अपने-अपने गहने, नथुनी, अंगूठी, कंगन और सोने के गहने लाए और हर एक पुरुष ने याहवेह को सोना भेंट किया. ");
INSERT INTO hincv_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","हर व्यक्ति, जिसके पास नीले बैंगनी तथा लाल वस्त्र, बकरे के रोम, लाल रंग में रंगी गई मेढ़े की खाल तथा सूंस की खाल थी, सब ले आए. ");
INSERT INTO hincv_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","और जो चांदी तथा कांसे भेंट करना चाहते थे उन्होंने याहवेह के लिए वह दी, जिनके पास बबूल की लकड़ी थी, जो सेवकाई में काम आ सके उन्होंने वही दिया. ");
INSERT INTO hincv_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","प्रत्येक निपुण स्त्रियां अपने हाथों से कात कर जो उनके पास था उसे ले आईं—नीले, बैंगनी तथा लाल सूत और सन, ");
INSERT INTO hincv_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","और जो स्त्रियां इच्छुक थीं और कातने में निपुण थीं, उन्होंने बकरे के रोम के सूत काते. ");
INSERT INTO hincv_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","प्रधान जन सुलेमानी गोमेद और दूसरे वे सारे रत्न जो एफ़ोद और सीनाबंद के लिये थे, वे ले आये. ");
INSERT INTO hincv_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","लोग सुगंध द्रव्य और जैतून का तेल दीपकों के लिए, अभिषेक के तेल के लिए तथा सुगंधित धूप बनाने के लिए ले आए. ");
INSERT INTO hincv_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","सभी इस्राएली स्त्री-पुरुष जिनकी इच्छा थी, याहवेह के लिये मोशेह को दी गई आज्ञा के अनुसार सारे कार्य करने के लिये याहवेह के लिए भेंट लाए. ");
INSERT INTO hincv_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","तब मोशेह ने इस्राएलियों से कहा, “सुनो, याहवेह ने यहूदाह गोत्र से हूर के पौत्र उरी के पुत्र बसलेल को चुना है, ");
INSERT INTO hincv_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","और परमेश्वर ने उन्हें अपने आत्मा से प्रवीणता, समझ, बुद्धि और सब कामों की समझ देकर भर दिया है. ");
INSERT INTO hincv_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ताकि वह सोना, चांदी एवं कांसे पर कलात्मक रचना कर सकें, ");
INSERT INTO hincv_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","और जड़ने के उद्देश्य से पत्थर काटने में कुशल तथा लकड़ी के खोदने में बुद्धि से कलाकारी का काम कर सकें. ");
INSERT INTO hincv_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","याहवेह ने बसलेल तथा दान के गोत्र के अहीसामक के पुत्र ओहोलियाब को दूसरों को सिखाने की शक्ति दी. ");
INSERT INTO hincv_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","याहवेह ने उन्हें कौशल से भर दिया है कि वह एक कारीगर के किए जानेवाले सारे कामों को कर सके; खोदने, गढ़ने, नीले, बैंगनी तथा लाल रंग के मलमल पर कशीदाकारी करने और बुनने वाले वस्त्र को नए-नए तरीके से बनाएं. ");
INSERT INTO hincv_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","बसलेल, ओहोलियाब और उन सारे लोगों को जिन्हें याहवेह ने कौशल, समझ, बुद्धि और ज्ञान दिया है कि वह पवित्र स्थान को बनाने के कार्य को कैसे करना है. वे उन कामों को उसी प्रकार से करेंगे जैसे याहवेह ने आज्ञा दी है.” ");
INSERT INTO hincv_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","तब मोशेह ने बसलेल, ओहोलियाब और उन सारे लोगों को जिन्हें याहवेह ने कौशल दिया, और जो अपनी इच्छा से सेवकाई करना चाहते थे, बुलवाया. ");
INSERT INTO hincv_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","इन्होंने मोशेह से इस्राएलियों द्वारा पवित्र स्थान को बनाने के लिये जो भी भेंट लाई गई थी, उन चीज़ों को लिया, और लोग सुबह दर सुबह स्वेच्छा से वस्तुएं लाते गये. ");
INSERT INTO hincv_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","पवित्र स्थान को बनाने में जितने भी योग्य कारीगर थे वह अपने कार्य को छोड़ मोशेह के पास आये. ");
INSERT INTO hincv_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","उन्होंने मोशेह से कहा, “पवित्र स्थान, जैसे याहवेह ने कहा है, वैसे बनाने में जितने सामान की ज़रूरत थी, लोग उससे कहीं ज्यादा हमारे पास ला रहे हैं.” ");
INSERT INTO hincv_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","तब मोशेह ने आज्ञा दी और इस बात की पूरी छावनी में घोषणा हुई कि कोई भी स्त्री या पुरुष अब पवित्र स्थान के लिये भेंट स्वरूप कुछ न लाये. इस प्रकार लोगों को कुछ और न लाने के लिये पाबंद किया गया. ");
INSERT INTO hincv_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","क्योंकि अब उनके पास ज़रूरत से ज्यादा सामान हो गया था. ");
INSERT INTO hincv_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","फिर पवित्र स्थान बनाया गया जिसमें दस पर्दे बनाये गये थे, जो बंटी हुई मलमल और नीले, बैंगनी और लाल रंग के कपड़ों से बने थे, और इन पर्दों पर कुशल कारीगरों द्वारा करूबों का चित्र बुना हुआ था. ");
INSERT INTO hincv_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","हर पर्दे की लंबाई बारह मीटर साठ सेंटीमीटर और चौड़ाई एक मीटर अस्सी सेंटीमीटर थी. हर पर्दा एक ही नाप का था. ");
INSERT INTO hincv_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","उन्होंने पांच पर्दों को एक साथ जोड़कर पांच पांच के दो पर्दे बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","पहले पांच पर्दों की किनारी पर तथा इसी तरह दूसरे पांच पर्दों की किनारी पर नीले रंग का फंदा बनाया. ");
INSERT INTO hincv_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","एक पर्दे में पचास फंदे और दूसरे में भी पचास फंदे. वे फंदे एक दूसरे के सामने बनाया. ");
INSERT INTO hincv_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","फिर सोने की पचास अंकुड़े बनाईं और दोनों पर्दों को एक दूसरे से जोड़ दिया; इस प्रकार पवित्र स्थान बन गया. ");
INSERT INTO hincv_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","फिर बकरे के रोमों से ग्यारह पर्दे बनाए जो पवित्र स्थान के ऊपर का हिस्सा था. ");
INSERT INTO hincv_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","हर एक पर्दे की लंबाई साढ़े तेरह मीटर तथा चौड़ाई एक मीटर अस्सी सेंटीमीटर थी. सभी ग्यारह पर्दे एक ही नाप के थे. ");
INSERT INTO hincv_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","उन्होंने ऐसे पांच पर्दों को एक साथ तथा बाकी छः पर्दों को एक साथ जोड़कर बड़ा कर दिया. ");
INSERT INTO hincv_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","और दोनों अलग-अलग पर्दों की एक-एक किनारी पर पचास-पचास फंदे लगाए. ");
INSERT INTO hincv_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","और दोनों पर्दों को जोड़ने के लिए कांसे के पचास अंकुड़े बनाए और उन कड़ों पर पर्दा लगाकर पूरा एक हिस्सा बना दिया. ");
INSERT INTO hincv_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","तंबू के लिए लाल रंग से रंगी हुई भेडों की खाल का एक ओढ़ना बनाया, और फिर उसके ऊपर लगाने के लिए सूस के चमड़े का एक और ओढ़ना बनाया. ");
INSERT INTO hincv_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","फिर पवित्र स्थान को खड़ा करने के लिए बबूल की लकड़ी के तख्ते बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","हर तख्ते की लंबाई साढ़े चार मीटर तथा चौड़ाई साढ़े सड़सठ सेंटीमीटर थी. ");
INSERT INTO hincv_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","तख्ते को जोड़ने के लिए दो समानांतर चूलें थीं. पवित्र स्थान के सब तख्ते इसी तरह बनवाये. ");
INSERT INTO hincv_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","उन्होंने पवित्र स्थान के दक्षिण दिशा के लिए बीस तख्ते बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","उनके नीचे चांदी की चालीस कुर्सियां बनवाईं, जो तख्तों के नीचे रखी गई थीं. हर तख्ते के नीचे उसकी दो चूलों के लिए दो कुर्सियां बनवाईं. ");
INSERT INTO hincv_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","और इसी प्रकार उत्तर की ओर भी बीस तख्ते बनाये, ");
INSERT INTO hincv_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","और चांदी की चालीस कुर्सियां हर एक तख्ते के नीचे दो कुर्सियां बनाईं. ");
INSERT INTO hincv_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","पवित्र स्थान के पीछे पश्चिम की ओर छः तख्ते बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","और पीछे के भाग के कोनों के लिए दो तख्ते बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","कोने के दोनों तख्ते एक साथ जोड़ दिए. तले में दोनों तख्तों की खूंटियां चांदी के एक ही आधार में लगाई और दोनों भाग ऊपर से जुड़ा हुआ और नीचे का भाग अलग था. ");
INSERT INTO hincv_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","इस प्रकार आठ तख्ते बनवाये, जिसके नीचे चांदी की सोलह कुर्सियां थीं, हर तख्ते के नीचे दो कुर्सियां थीं. ");
INSERT INTO hincv_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","फिर बबूल की लकड़ी की छड़ें बनाए, पवित्र स्थान की एक तरफ के तख्तों के लिए पांच छड़ें बनवाए ");
INSERT INTO hincv_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","तथा पवित्र स्थान की दूसरी तरफ के तख्तों के लिए पांच कड़े तथा पवित्र स्थान के पश्चिमी दिशा के तख्ते के लिए पांच कड़े बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","तख्ते के एक तरफ से दूसरी तरफ जाने के लिए तख्ते के बीच में कड़े बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","तख्तों के ऊपर सोना लगवाया और कड़े में भी सोना लगवाया. लकड़ी की डंड़ीयों को भी सोना लगवाया. ");
INSERT INTO hincv_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","फिर नीले, बैंगनी और लाल रंग के कपड़ों से और बंटी हुई मलमल से एक बीच वाला पर्दा बनाए, जिस पर कढ़ाई के काम द्वारा करूबों के रूप बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","उसने बबूल की लकड़ी के चार खंभे बनाए और उसके ऊपर सोना लगाया. इन खंभों पर पर्दों के लिए सोने की कड़ियां और चांदी की चार कुर्सियां बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","तंबू के द्वार के लिए नीले, बैंगनी और लाल रंग के कपड़ों का, तथा बंटी हुई बारीक़ सनी वाले कपड़ों की कढ़ाई का काम किया हुआ एक पर्दा बनवाया. ");
INSERT INTO hincv_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","और पांच खंभे बनाए. खंभे के ऊपर और नीचे के हिस्से में सोना लगाया, उनकी पट्टियां सोने से बनाई गई तथा उनकी पांचों कुर्सियां कांसे की बनाई. ");
INSERT INTO hincv_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","फिर बसलेल ने बबूल की लकड़ी से संदूक बनाया. इसकी लंबाई एक सौ दस सेंटीमीटर तथा चौड़ाई और ऊंचाई सत्तर-सत्तर सेंटीमीटर थी. ");
INSERT INTO hincv_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","संदूक के अंदर और बाहर सोना लगाया और चारों तरफ सोने की किनारी लगाई. ");
INSERT INTO hincv_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","इसके चारों पायों पर लगाने के लिए सोने के चार कड़े बनाए—दो कड़े एक तरफ और, दो कड़े दूसरी तरफ थे. ");
INSERT INTO hincv_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","5","उसने बबूल की लकड़ी के डंडे बनाए और उस पर सोना लगाया तथा इन्हें संदूक के दोनों तरफ लगे कड़ों में डाल दिया ताकि संदूक को उठाना आसान हो. ");
INSERT INTO hincv_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","फिर सोने से करुणासन बनाया जो एक सौ दस सेंटीमीटर लंबा तथा सत्तर सेंटीमीटर चौड़ा था. ");
INSERT INTO hincv_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","उन्होंने सोने के पत्रों से दो करूबों को करुणासन के दोनों तरफ बनाया. ");
INSERT INTO hincv_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","एक करूब एक तरफ तथा दूसरा करूब दूसरी तरफ बनाया और करूब को करुणासन के साथ एक ही टुकड़े से बनाया. ");
INSERT INTO hincv_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","करूबों के पंख ऊपर से ऐसे खुले थे जिससे करुणासन उनसे ढंका रहा और वे एक दूसरे के आमने-सामने करुणासन की ओर थे, तथा उनका मुंह करुणासन की ओर झुका हुआ था. ");
INSERT INTO hincv_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","बसलेल ने बबूल की लकड़ी की एक मेज़ बनाई, जो नब्बे सेंटीमीटर लंबी, पैंतालीस सेंटीमीटर चौड़ी थी तथा साढ़े सड़सठ सेंटीमीटर ऊंची थी. ");
INSERT INTO hincv_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","उसमें सोना लगाकर उसके चारों ओर इसकी किनारियां सोने की बनाई. ");
INSERT INTO hincv_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","उन्होंने इसके चारों ओर साढ़े सात सेंटीमीटर चौड़ी पट्टी बनाई—इस पट्टी के चारों ओर सोने की किनारियां लगाई गईं. ");
INSERT INTO hincv_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","मेज़ के लिए सोने के चार कड़े बनाये और इन कड़ों को मेज़ के चारों पैरों के ऊपर के कोनों पर इन सोने के कड़ों को लगा दिया. ");
INSERT INTO hincv_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","कड़े पट्टी के पास लगाये ताकि मेज़ उठाने के लिये डंडे इन कड़ों में डाले जा सकें. ");
INSERT INTO hincv_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","डंडे बबूल की लकड़ी के बनाए गए थे तथा ऊपर सोना लगा दिया गया. ");
INSERT INTO hincv_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","इस मेज़ पर रखे जानेवाले समान अर्थात्, थालियां, तवे, कटोरियां तथा पेयार्पण डालने के लिए बर्तन, ये सब सोने के बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","फिर उन्होंने शुद्ध सोने का एक दीपस्तंभ बनाया. उसे पीटकर आधार तथा उसके डंडे को बनाया, और उसने फूलों के समान दिखनेवाले प्याले बनाए. प्यालों के साथ कलियां और खिले हुए पुष्प थे. ये सभी चीज़ें एक ही इकाई में परस्पर जुड़ी हुई थीं. ");
INSERT INTO hincv_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","दीये से छः डालियां निकलीं, तीन एक तरफ और तीन दूसरी तरफ रखीं. ");
INSERT INTO hincv_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","हर डाली में कलियों और फूलों के साथ बादाम के फूलों के आकार के तीन पुष्‍पकोष और एक गांठ थे. पूरे छः डालियों को, जो दीये से निकलीं, इसी आकार से बनाई. ");
INSERT INTO hincv_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","दीये की डंडी में चार फूल बने थे, जिसमें बादाम के फूल के समान कलियां तथा पंखुड़ियां बनी थीं. ");
INSERT INTO hincv_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","दीये से निकली हुई छः डालियों में से दो-दो डालियों के नीचे एक-एक गांठ और दीये समेत एक ही टुकड़े से बने थे. ");
INSERT INTO hincv_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ये सभी कलियां, शाखाएं और दीप का स्तंभ शुद्ध सोने को पीटकर बने थे. ");
INSERT INTO hincv_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","उन्होंने वे सातों दीये, इनके बुझाने के साधन तथा रखने के बर्तन सोने से बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","दीये और उसके साथ सभी सामान को लगभग पैंतीस किलो सोने से बनाया गया. ");
INSERT INTO hincv_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","फिर बबूल की लकड़ी से धूप वेदी बनाई; यह चौकोर थी, जिसकी लंबाई पैंतालीस सेंटीमीटर तथा चौड़ाई भी पैंतालीस सेंटीमीटर थी, व ऊंचाई नब्बे सेंटीमीटर, तथा इसकी सींग एक ही टुकड़े से बनाई गई थी. ");
INSERT INTO hincv_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","पूरी धूप वेदी का ऊपरी हिस्सा इसके चारों परत तथा इसके सींग और चारों ओर की किनारी सोने की बनाई. ");
INSERT INTO hincv_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","इसकी किनारियों के नीचे सोने के दो-दो कड़े लगाए. इसको इन डंडे के द्वारा उठाने के लिए ही दोनों तरफ आमने-सामने कड़े लगवाया. ");
INSERT INTO hincv_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","इन डंडों को बबूल की लकड़ी से बनाकर उसमें सोने की परत चढ़ाई. ");
INSERT INTO hincv_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","बसलेल ने अभिषेक का पवित्र तेल और सुगंध द्रव्य भी बनाया, जिस प्रकार से कोई निपुण इत्र बनानेवाला बनाता है. ");
INSERT INTO hincv_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","और बसलेल ने बबूल की लकड़ी से होमबलि के लिए चौकोर वेदी बनाई. यह दो मीटर पच्चीस सेंटीमीटर लंबी तथा इतनी ही चौड़ी थी. इसकी ऊंचाई एक मीटर सैंतीस सेंटीमीटर थी. ");
INSERT INTO hincv_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","और इसके चारों कोनों पर एक-एक सींग बनाया, जो वेदी के साथ एक ही टुकड़े में कांसे से बनाये गये. ");
INSERT INTO hincv_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","डोल, बेलचे, छिड़काव कटोरे, कांटे तथा तवे जैसी वेदी में काम आनेवाली सभी चीज़ों को कांसे से बनाया. ");
INSERT INTO hincv_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","वेदी के लिए कांसे की जाली की एक झंझरी बनाई, जो वेदी की आधी ऊंचाई पर लगाई गई थी. ");
INSERT INTO hincv_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","कांसे की झंझरी के चारों कोनों पर चार कड़े लगाए, ताकि इनके बीच से डंडों को लगा सकें. ");
INSERT INTO hincv_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","डंडे बबूल की लकड़ी से बनाकर उस पर कांसे लगवा दी. ");
INSERT INTO hincv_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","उसने उन डंडों को उन कड़ों में डाल दिया ताकि वेदी को उठाया जा सके. वेदी भीतर से खोखली थी और तख्ते जोड़कर बनाई गई थी. ");
INSERT INTO hincv_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","इसकी हौदी और पाये दोनों कांसे के बनाए. इसे उन स्त्रियों के दर्पणों से बनाया, जो मिलनवाले तंबू के द्वार पर सेवा करती थीं. ");
INSERT INTO hincv_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","फिर पवित्र स्थान के आंगन को बनाया. आंगन के दक्षिण हिस्से में बंटी हुई बारिक सनी के कपड़े का पर्दा था, जिसकी लंबाई पैंतालीस मीटर थी, ");
INSERT INTO hincv_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","तथा बीस खंभे और कांसे की बीस कुर्सियां बनवाईं. खंभों के कुण्डे और पट्टियां चांदी की थी. ");
INSERT INTO hincv_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","आंगन के उत्तरी दिशा के लिए भी पैंतालीस मीटर लंबे पर्दे बनाए गए और इसके लिए कांसे के बीस खंभे और बीस कुर्सियां बनाई गईं. मीनारों की कड़ियां तथा उसकी पट्टियां चांदी की थीं. ");
INSERT INTO hincv_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","पश्चिम दिशा के पर्दे साढ़े बाईस मीटर लंबे थे, तथा इसके लिए दस खंभे एवं दस कुर्सियां बनाई गई थी. मीनारों की कड़ियां तथा पट्टियां चांदी की थी. ");
INSERT INTO hincv_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","पूर्वी दिशा के पर्दे भी साढ़े बाईस मीटर लंबे थे. ");
INSERT INTO hincv_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","द्वार के एक तरफ के पर्दे छः मीटर पचहत्तर सेंटीमीटर के थे, और तीन खंभे और तीन कुर्सियां बनाई गयीं. ");
INSERT INTO hincv_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","आंगन के प्रवेश द्वार की दूसरी ओर के पर्दे छः मीटर पचहत्तर सेंटीमीटर के थे, तथा और तीन खंभे और तीन कुर्सियां बनाई गयीं. ");
INSERT INTO hincv_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","आंगन के चारों ओर के पर्दे सूक्ष्म बंटी हुई सन के थे. ");
INSERT INTO hincv_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","मीनारों की कुर्सियां कांसे की बनाई गई थी, मीनारों की कड़ियां तथा उनकी पट्टियां चांदी की थीं. उनका ऊपरी हिस्सा चांदी का था तथा आंगन के सभी मीनारों पर चांदी की पट्टियां लगाई गई थीं. ");
INSERT INTO hincv_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","आंगन के प्रवेश द्वार के पर्दे सन के उत्तम रेशों के नीले, बैंगनी तथा लाल कपड़े के बने थे. इस पर कढ़ाई कढ़ी हुई थी. इसकी लंबाई नौ मीटर तथा ऊंचाई सवा दो मीटर थी, जो आंगन के दूसरे पर्दे के बराबर थी. ");
INSERT INTO hincv_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","इनके चारों खंभे तथा उनकी चारों कुर्सियां कांसे की थीं. इनकी कड़ियां तथा ऊपरी हिस्सा तथा उनकी पट्टियां चांदी की थीं. ");
INSERT INTO hincv_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","पवित्र स्थान और उसके चारों ओर के आंगन की सभी खूंटियां कांसे की थीं. ");
INSERT INTO hincv_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","मोशेह के आदेश के अनुसार बनाए गए पवित्र स्थान और वाचा के पवित्र स्थान के निर्माण में जो जो सामग्रियां उपयोग में आई थीं, उन सभी की गिनती, जो पुरोहित अहरोन के पुत्र इथामार के नेतृत्व में लेवियों द्वारा की गई, वह इस प्रकार है: ");
INSERT INTO hincv_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","जिन वस्तुओं को बनाने की आज्ञा याहवेह द्वारा मोशेह को दी गई थी, वह यहूदाह गोत्र के बसलेल ने बना दी—बसलेल उरी के पुत्र, हूर के पोते थे. ");
INSERT INTO hincv_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","उनके साथ दान गोत्र के अहीसामक के पुत्र ओहोलियाब थे, जो नक्काशी और शिल्पकार तथा कढ़ाई करने तथा सूक्ष्म बंटी हुई सन और नीले, बैंगनी तथा लाल वस्त्रों के बनाने में निपुण थे. ");
INSERT INTO hincv_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","पवित्र स्थान को बनाने में जितना सोना भेंट चढ़ा था, वह सोना पवित्र स्थान की तौल के अनुसार कुल एक हजार दो किलो था. ");
INSERT INTO hincv_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","इस्राएलियों ने पवित्र स्थान के लिए जो चांदी भेंट दी थी, वह पवित्र स्थान की तौल के अनुसार लगभग तीन हजार पांच सौ बीस किलो थी. ");
INSERT INTO hincv_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","जो इस्राएली बीस वर्ष की उम्र से ज्यादा के थे, वे संख्या में कुल छः लाख तीन हजार पांच सौ पचास व्यक्ति थे, उन्होंने पवित्र स्थान की तौल के अनुसार आधा शेकेल, अर्थात् छः ग्राम भेंट दी. ");
INSERT INTO hincv_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","पवित्र स्थान तथा बीच के पर्दों के लिए लगभग साढ़े तीन हजार किलो चांदी उपयोग की गई थी—एक सौ कुर्सियां साढ़े तीन हजार किलो चांदी से बनीं—एक कुर्सी के लिए लगभग पैंतीस किलो चांदी लगी. ");
INSERT INTO hincv_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","जो बीस किलो चांदी बच गई, उससे मीनारों के लिए कड़ियां बनाई और ऊपरी हिस्से की पट्टियां भी बना दीं. ");
INSERT INTO hincv_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","भेंट में चढ़ाया गया कांस्य लगभग दो हजार सवा चार सौ किलो था. ");
INSERT INTO hincv_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","उससे मिलनवाले तंबू के द्वार के लिए कुर्सियां, कांसे की वेदी तथा इसकी जाली तथा वेदी का सारा सामान, ");
INSERT INTO hincv_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","आंगन के चारों ओर की कुर्सियां तथा उसके द्वार की कुर्सियां तथा निवास और आंगन के चारों ओर की खूंटियां भी बनाई गईं. ");
INSERT INTO hincv_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","नीले, बैंगनी और लाल रंग के सूत से पवित्र स्थान में सेवा के अवसर पर पहनने के लिए वस्त्र बनाए, और अहरोन के लिए पवित्र वस्त्र, जैसा याहवेह ने मोशेह को आज्ञा दी, वैसा ही बनाया. ");
INSERT INTO hincv_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","उन्होंने एफ़ोद को सुनहरे और नीले बैंगनी तथा लाल रंग के कपड़े का और सूक्ष्म बंटे हुए सन के कपड़े का बनाया. ");
INSERT INTO hincv_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","उन्होंने सोने को पीटकर उसकी पत्तियां बनाई तथा इन्हें काटकर इनके धागे बनाए ताकि इन्हें नीले, बैंगनी तथा लाल रंग के सूत के उत्तम रेशों में बुना जा सके, जो एक कुशल कारीगर का काम था. ");
INSERT INTO hincv_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","उन्होंने एफ़ोद के जोड़ने के लिए कंधों की पट्टियां बनाईं और कंधे की इन पट्टियों को एफ़ोद के कंधे पर टांका ");
INSERT INTO hincv_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","कमरबंध एफ़ोद के साथ बुना हुआ बनाया, और एक ही प्रकार की सामग्री से बनाया, अर्थात् सुनहरे, नीले, बैंगनी और लाल रंग के कपड़ों और बंटी हुई मलमल से बनाया, जैसा ही याहवेह ने मोशेह को आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","उन्होंने सुलेमानी गोमेद को सोने की महीन जालियों में जड़ा और उनमें इस्राएली पुत्रों के नाम मुहर जैसे खोदकर सोने के खानों में लगा दिये. ");
INSERT INTO hincv_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","इन दोनों मणियों को इस्राएल के पुत्रों के यादगार मणियों के रूप में एफ़ोद के कंधों में लगाया, जैसा मोशेह को याहवेह ने आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","उन्होंने एक कुशल शिल्पकार द्वारा न्याय की पेटी बनवाई, उसे बेलबूटेदार एफ़ोद के समान बनवाया. उसे सुनहरे, नीले, बैंगनी और लाल रंग के कपड़े तथा बंटी हुई मलमल से बनवाया. ");
INSERT INTO hincv_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","इसे मोड़कर दो भाग बनाए, और इसका आकार चौकोर था, यह साढ़े बाईस सेंटीमीटर लंबा तथा साढ़े बाईस सेंटीमीटर चौड़ा था. ");
INSERT INTO hincv_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","इस पर उन्होंने मणियों की चार पंक्तियां बनाई. पहली पंक्ति में एक माणिक्य, एक पुखराज और एक मरकत थे. ");
INSERT INTO hincv_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","दूसरी पंक्ति में एक लाल मणि, एक नीलम और एक हीरा लगाए. ");
INSERT INTO hincv_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","तीसरी पंक्ति में एक तृणमणि, एक यशब और एक याकूत. ");
INSERT INTO hincv_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","चौथी पंक्ति में एक स्वर्णमणि, एक सुलेमानी और एक सूर्यकांत मणि; इन्हें नक्काशी किए हुए सोने के खांचों में लगा दिये. ");
INSERT INTO hincv_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ये इस्राएल के बारह पुत्रों के अनुसार बारह मणियां थी. हर मणि पर बारह गोत्रों में से एक नाम लिखे गये, जिस तरह एक कारीगर मुहर पर खोदता है. एक मणि पर इस्राएल के बारह गोत्रों में से एक का नाम था. ");
INSERT INTO hincv_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","वक्षपेटिका के लिए बंटी हुई डोरियों के रूप में सोने की गुंथी हुई जंजीर बनवाया. ");
INSERT INTO hincv_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","वक्षपेटिका के लिए सोने के दो कड़े भी बनवाये, और इन दोनों कड़ों को वक्षपेटिका के दोनों सिरों पर लगवाये. ");
INSERT INTO hincv_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","इसके बाद सोने की इन दोनों डोरियों को वक्षपेटिका के सिरों में लगे हुए दोनों कड़ों में लगवाये. ");
INSERT INTO hincv_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","उन्होंने दोनों डोरियों के दूसरे सिरों को नक्काशी किए हुए दोनों खांचों में जुड़वाये. उन्हें एफ़ोद के कंधों में सामने की ओर लगवाये. ");
INSERT INTO hincv_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","उन्होंने फिर सोने के दो और कड़े बनाकर इन्हें वक्षपेटिका के सिरों पर अंदर की ओर एफ़ोद से सटाकर लगवाये. ");
INSERT INTO hincv_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","फिर उन्होंने दो कड़े बनाए और उन्हें एफ़ोद के कंधों की तरफ़ की छोर के सामने की तरफ़ से मिला दिया, जो एफ़ोद की बुनी हुई पट्टी के पास से थी. ");
INSERT INTO hincv_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","उन्होंने वक्ष पटल को उसके कड़ों के द्वारा एफ़ोद के कड़ों से एक नीले रंग की रस्सी द्वारा बांध दिया, जिससे यह अब एफ़ोद के बुने हुए भाग पर जुड़ गया, जिससे वक्ष पटल एवं एफ़ोद एक दूसरे से जुड़े रहते थे. यह सब याहवेह द्वारा मोशेह से कहे गये वचन के अनुसार किया गया. ");
INSERT INTO hincv_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","फिर उन्होंने एफ़ोद का पूरा अंगरखा नीले कपड़े का बनवाया. ");
INSERT INTO hincv_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","इस वस्त्र के बीच में एक छेद था. छेद के चारों ओर एक कोर बनाया ताकि वह फट न पाए. ");
INSERT INTO hincv_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","इस वस्त्र की किनारी पर नीली, बैंगनी तथा लाल, सूक्ष्म बंटी हुई सन के रेशों से अनार बनाए. ");
INSERT INTO hincv_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","उन्होंने सोने की घंटियां भी बनाईं और इन्हें वस्त्र की किनारी के चारों ओर अनारों के बीच में लगा दिया. ");
INSERT INTO hincv_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","वस्त्र में एक अनार, फिर एक घंटी, और एक अनार फिर एक घंटी लगाई गई कि वह वस्त्र पहनकर सेवा का काम करें. यह वैसा ही किया जैसा याहवेह ने मोशेह से कहा था. ");
INSERT INTO hincv_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","अहरोन एवं उनके पुत्रों के लिए उन्होंने मलमल के कुर्ते, ");
INSERT INTO hincv_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","पगड़ियां एवं टोपियां और जांघिया बनाई. ");
INSERT INTO hincv_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","उन्होंने नीले, बैंगनी तथा लाल रंग के मलमल से पगड़ी बनाई, जैसा याहवेह ने मोशेह को आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","शुद्ध सोने की एक पट पर मुहर के समान ये अक्षर खोदे गए: याहवेह के लिए पवित्र. ");
INSERT INTO hincv_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","उन्होंने उसमें एक नीला फीता लगाया कि वह पगड़ी के ऊपर रहे—जैसा याहवेह ने मोशेह को आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","इस प्रकार मिलनवाले तंबू और पवित्र स्थान का काम पूरा हुआ. इस्राएलियों ने सब कुछ वैसा ही किया, जैसे जैसे याहवेह ने मोशेह को आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","फिर वे पवित्र स्थान की सब वस्तुएं मोशेह के पास लाए: अर्थात् तंबू, इसकी अंकुड़ियों, तख्ते, छड़ें, खंभे तथा कुर्सियां; ");
INSERT INTO hincv_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","मेढ़े की खालों का ओढ़ना जो लाल रंग से रंगी गई थी, सूंस की खाल का ओढ़ना तथा पर्दा; ");
INSERT INTO hincv_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","संदूक, डंडों समेत करुणासन, बीच वाला पर्दा; ");
INSERT INTO hincv_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","मेज़ और उसके सभी सामान, भेंट की रोटी, ");
INSERT INTO hincv_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","सारे सामान सहित, दीवट उसकी सजावट के दीपक, और दीये के लिए तेल, ");
INSERT INTO hincv_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","सोने की वेदी और अभिषेक का तेल, सुगंधधूप और तंबू के द्वार का पर्दा; ");
INSERT INTO hincv_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","कांसे की वेदी और उसकी कांसे की झंझरी, उसके डंडे तथा उसके सामान; कांसे की हौदी; ");
INSERT INTO hincv_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","आंगन के द्वार का पर्दा, उसके खंभे और कुर्सियां सहित आंगन का पर्दा; उसकी डोरियां, उसकी खूंटियां; तथा मिलनवाले तंबू के पवित्र स्थान का सारा सामान; ");
INSERT INTO hincv_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","पवित्र स्थान में सेवा के अवसर पर पहनने के बुने हुए वस्त्र, अहरोन तथा उनके पुत्रों के लिए पवित्र वस्त्र, जो पुरोहित के पद पर कार्य करते समय पहनकर जाना था. ");
INSERT INTO hincv_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","इस प्रकार इस्राएलियों ने वह सब काम पूरा किया, जिसकी याहवेह ने मोशेह को आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","मोशेह ने उन सब कामों को जांचा जो उन्होंने किया था, और सब काम जैसी याहवेह की आज्ञा थी, उसी के अनुसार ही किया गया था. फिर मोशेह ने सबको आशीष दी. ");
INSERT INTO hincv_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","फिर याहवेह ने मोशेह से कहा: ");
INSERT INTO hincv_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“पहले महीने के पहले दिन मिलनवाले तंबू के पवित्र स्थान को खड़ा कर देना. ");
INSERT INTO hincv_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","उसमें साक्षी पत्र के संदूक को रखकर बीचवाले पर्दे के पीछे रख देना. ");
INSERT INTO hincv_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","मेज़ का सारा सामान लेकर उसे अंदर ले आना, फिर दीप स्तंभों को ले आना और दीयों को जला देना. ");
INSERT INTO hincv_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","साक्षी पत्र के संदूक के सामने सोने की वेदी को, जो धूप के लिए है, उसे रखना और पवित्र स्थान के पर्दे को लगा देना. ");
INSERT INTO hincv_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“और पवित्र स्थान के प्रवेश द्वार पर, अर्थात् मिलनवाले तंबू के सामने, होमबलि की वेदी को रखना. ");
INSERT INTO hincv_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","मिलनवाले तंबू और वेदी के बीच हौद में पानी भरकर रखना. ");
INSERT INTO hincv_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","तुम इसके चारों तरफ आंगन बनाना और आंगन के द्वार पर पर्दा लगाना. ");
INSERT INTO hincv_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“फिर अभिषेक का तेल लेकर पवित्र स्थान और जो कुछ उसमें हैं, सबका अभिषेक करना और पवित्र करना. ");
INSERT INTO hincv_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","तुम होमबलि की वेदी और उसके सब सामान को अभिषेक करना, तब वेदी महा पवित्र हो जायेगी. ");
INSERT INTO hincv_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","और पाए समेत हौदी का भी अभिषेक करके पवित्र करना. ");
INSERT INTO hincv_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“फिर अहरोन एवं उनके पुत्रों को मिलनवाले तंबू के द्वार पर नहलाना. ");
INSERT INTO hincv_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","और अहरोन को पवित्र वस्त्र पहनाना, और उनका अभिषेक करके उनको पवित्र करना, ताकि वह मेरे लिए पुरोहित होकर मेरी सेवा करे. ");
INSERT INTO hincv_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","फिर उनके पुत्रों को उनके वस्त्र पहनाना. ");
INSERT INTO hincv_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","और उनका भी अभिषेक उसी प्रकार करना, जिस प्रकार उनके पिता का किया था, ताकि वे भी मेरी सेवा कर सकें. उनका यह अभिषेक उनकी पीढ़ी से पीढ़ी तक पुरोहित होकर मेरी सेवा का चिन्ह रहेगा.” ");
INSERT INTO hincv_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","मोशेह ने सब काम वैसे ही किया, जैसा याहवेह ने उनको आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","दूसरे साल के पहले महीने के पहले दिन में पवित्र स्थान को खड़ा किया गया. ");
INSERT INTO hincv_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","मोशेह ने जब पवित्र स्थान को खड़ा किया, तब कुर्सियों पर तख्ते रखकर उनमें कड़े डाले और मीनारों को खड़ा किया. ");
INSERT INTO hincv_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","मोशेह ने पवित्र स्थान के ऊपर तंबू बिछाया और तंबू के ऊपर ओढ़नी लगाई जैसे याहवेह ने मोशेह को आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","मोशेह ने साक्षी पट्टियों को संदूक में रखा और संदूक में डंडों को लगाकर उसके ऊपर करुणासन से ढंका. ");
INSERT INTO hincv_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","मोशेह ने संदूक को पवित्र स्थान में रखवाया और बीचवाले पर्दे को टांग दिया और साक्षी पत्र के संदूक को अंदर पर्दे की आड़ में किया, जैसे याहवेह ने मोशेह को आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","फिर मिलनवाले तंबू में पवित्र स्थान के उत्तर दिशा पर बीच के पर्दे के बाहर मेज़ लगवाया. ");
INSERT INTO hincv_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","मेज़ पर मोशेह ने रोटियों को याहवेह के सम्मुख जमाया, जैसा याहवेह ने मोशेह को आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","मोशेह ने मिलनवाले तंबू में मेज़ के सामने दक्षिण दिशा में दीपस्तंभ को रख दिया. ");
INSERT INTO hincv_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","और दीयों को याहवेह के सामने जला दिया, जैसा याहवेह ने मोशेह को आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","फिर मोशेह ने मिलनवाले तंबू के भीतर, बीच के पर्दे के सामने, सोने की वेदी को रखा. ");
INSERT INTO hincv_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","और उस पर सुगंधित धूप जलाया, जैसा याहवेह ने मोशेह को आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","मोशेह ने फिर पवित्र स्थान के द्वार पर पर्दा लगाया, ");
INSERT INTO hincv_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","और मिलनवाले तंबू के पवित्र स्थान के द्वार पर होमबलि की वेदी रखकर उस पर होमबलि और अन्‍नबलि चढ़ाई, जैसी याहवेह ने उन्हें आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","मिलनवाले तंबू और वेदी के बीच हौदी रखी, और उसमें पानी भर दिया. ");
INSERT INTO hincv_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","इसमें से पानी लेकर मोशेह, अहरोन तथा उनके पुत्र अपने हाथ एवं पांव धोते थे. ");
INSERT INTO hincv_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","जब भी वे मिलनवाले तंबू तथा वेदी के पास जाते थे, वे अपना हाथ-पांव धोकर ही जाते थे, जैसी याहवेह ने मोशेह को आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","पवित्र स्थान और वेदी के चारों ओर आंगन बनाया और आंगन के द्वार पर पर्दा लगाया. इस प्रकार मोशेह ने काम पूरा किया. ");
INSERT INTO hincv_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","तब बादल मिलनवाले तंबू पर फैल गया और याहवेह का तेज पवित्र स्थान में भर गया. ");
INSERT INTO hincv_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","मोशेह तंबू में न जा सके, क्योंकि मिलनवाले तंबू के ऊपर बादल था और याहवेह का तेज पवित्र स्थान में भरा हुआ था. ");
INSERT INTO hincv_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","इस्राएलियों की पूरी यात्रा में, जब-जब बादल पवित्र स्थान के ऊपर से उठता, तब-तब वे वहां से निकलते. ");
INSERT INTO hincv_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","अगर बादल पवित्र स्थान से नहीं हटता, तब तक इस्राएली लोग कुछ नहीं करते; जब तक बादल उठ नहीं जाता. ");
INSERT INTO hincv_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","इस्राएलियों की सारी यात्राओं में याहवेह उनके लिए दिन में पवित्र स्थान के ऊपर बादल से उनको छाया देते, और रात में बादल में आग से उन्हें रोशनी दिखाई देती थी.");
INSERT INTO hincv_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","याहवेह ने मोशेह को आह्वान कर उन्हें मिलनवाले तंबू में से यह आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“इस्राएल की प्रजा को यह आदेश दो: ‘जब कभी तुममें से कोई व्यक्ति याहवेह के लिए बलि अर्पण करें, वह यह बलि किसी गाय-बैलों या भेड़-बकरियों में से लेकर आए. ");
INSERT INTO hincv_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘यदि उसकी होमबलि ढोरों से है, तो वह एक निर्दोष नर पशु को बलि करे, वह इस निर्दोष नर पशु को मिलनवाले तंबू के प्रवेश द्वार पर बलि करे कि वह याहवेह द्वारा स्वीकृत हो. ");
INSERT INTO hincv_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","वह व्यक्ति अपना हाथ इस पशु के सिर पर रखे कि यह उसके पक्ष में प्रायश्चित बलि के रूप में स्वीकार की जाए. ");
INSERT INTO hincv_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","वह याहवेह के सामने इस बछड़े को बलि करे और अहरोन के पुत्र, जो पुरोहित हैं, इसके रक्त को उस वेदी के चारों ओर छिड़क दें, जो मिलनवाले तंबू के प्रवेश पर स्थित है. ");
INSERT INTO hincv_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","फिर तुम इस पशु की खाल उतारकर इसे टुकड़ों में काट देना. ");
INSERT INTO hincv_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","अहरोन के पुत्र, जो पुरोहित हैं, वेदी पर अग्नि रखें और इस अग्नि पर लकड़ियों को सजाकर रखें. ");
INSERT INTO hincv_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","अहरोन के पुत्र, जो पुरोहित हैं; टुकड़ों, सिर और चर्बी को जलती हुई लकड़ियों पर, जो वेदी पर हैं, सजाकर रखें. ");
INSERT INTO hincv_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","किंतु तुम उस पशु की आंतों और टांगों को जल से धोना और पुरोहित इन सभी को होमबलि के लिए वेदी पर दहन करे. यह याहवेह के लिए सुखद-सुगंध की होमबलि होगी. ");
INSERT INTO hincv_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘किंतु यदि उसकी होमबलि भेड़-बकरियों में से है, तो वह एक निर्दोष नर पशु को अर्पण करे. ");
INSERT INTO hincv_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","वह उसका वध याहवेह के सामने वेदी के उस ओर करे, जो उत्तरी दिशा की ओर है, और अहरोन के पुत्र, जो पुरोहित हैं, इसके रक्त को वेदी के चारों ओर छिड़क दें. ");
INSERT INTO hincv_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","फिर वह इसके सिर और इसकी चर्बी को टुकड़ों में काट दे, और पुरोहित इन्हें उन लकड़ियों पर जो अग्नि पर हैं, सजाकर रखें, ");
INSERT INTO hincv_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","किंतु आंतों और पैरों को वह जल से धोए और पुरोहित इन सभी को होमबलि के लिए वेदी पर जलाए, यह याहवेह के लिए सुखद-सुगंध की होमबलि होगी. ");
INSERT INTO hincv_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘किंतु यदि वह याहवेह के लिए पक्षियों की होमबलि चढ़ाता है, तो वह अपनी बलि के लिए कपोत अथवा कबूतर के बच्‍चे लेकर आए. ");
INSERT INTO hincv_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","पुरोहित इसे वेदी पर लाए; उसका सिर मरोड़ कर उसका वध करे, तथा उसे वेदी पर जलाए. इसका रक्त वेदी की एक ओर बहाए जाए. ");
INSERT INTO hincv_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","वह उसके गले की थैली और परों को वेदी के पूर्वी ओर, जो राख डालने का स्थान है, फेंक दे. ");
INSERT INTO hincv_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","फिर वह उसके पंख पकड़कर फाड़े, किंतु उसे अलग न करे और पुरोहित इन सभी को होमबलि के लिए वेदी पर जलाए. यह याहवेह के लिए सुखद-सुगंध की होमबलि होगी. ");
INSERT INTO hincv_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘जब याहवेह के लिए बलि के रूप में कोई अन्‍नबलि लेकर आए, तो यह भेंट महीन आटे की हो. वह इस पर तेल उण्डेले और लोबान रखे. ");
INSERT INTO hincv_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","फिर वह इसे अहरोन के पुत्रों के पास, जो पुरोहित हैं, लाए. वह उसमें से एक मुट्ठी भर महीन आटा, तेल एवं लोबान ले. पुरोहित उसको स्मरण दिलाने वाले भाग के रूप में वेदी पर जलाए. यह अग्निबलि याहवेह के लिए सुखद-सुगंध होगी. ");
INSERT INTO hincv_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","अन्‍नबलि का बचा हुआ भाग अहरोन व उनके पुत्रों के लिए निर्धारित है; यह याहवेह के लिए अग्निबलियों का परम पवित्र भाग है. ");
INSERT INTO hincv_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘यदि तुम्हारी बलि भट्टी में पकी हुई अन्‍नबलि हो, तो यह सबसे अच्छे आटे से बनी हो. यह तेल में गूंधी हुई, खमीर रहित रोटी या तेल से चुपड़ी हुई खमीर रहित पपड़ी हो. ");
INSERT INTO hincv_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","यदि तुम्हारी बलि तवे पर पकी हुई अन्‍नबलि है, तो यह तेल में गूंधे हुए खमीर रहित, महीन आटे की हो. ");
INSERT INTO hincv_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","तुम इसे टुकड़े-टुकड़े कर इस पर तेल उण्डेलना. यह एक अन्‍नबलि है. ");
INSERT INTO hincv_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","यदि तुम्हारी बलि कड़ाही में पकी हुई अन्‍नबलि है, तो यह तेल में गूंधे हुए महीन आटे की हो. ");
INSERT INTO hincv_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","जब तुम याहवेह के सामने इन वस्तुओं से बनी अन्‍नबलि लेकर आओ, तो यह पुरोहित के पास लाया जाए और वह इसे वेदी पर लेकर आए. ");
INSERT INTO hincv_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","फिर पुरोहित इस अन्‍नबलि से इसका स्मरण दिलाने वाला भाग लेकर वेदी पर अग्निबलि के रूप में जलाए. यह याहवेह के लिए सुखद-सुगंध की अग्निबलि होगी. ");
INSERT INTO hincv_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","अन्‍नबलि का बचा हुआ भाग अहरोन व उनके पुत्रों के लिए निर्धारित है; यह याहवेह के लिए अग्निबलियों का परम पवित्र भाग है. ");
INSERT INTO hincv_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘कोई भी अन्‍नबलि, जो तुम याहवेह के सामने लेकर आओ, वह खमीर के साथ न बनाई जाये, क्योंकि तुम याहवेह को न तो खमीर की और न ही मधु की अग्निबलि भेंट करना. ");
INSERT INTO hincv_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","तुम इन्हें याहवेह के सामने पहली उपज की बलि के रूप में भेंट करना. किंतु ये वेदी पर याहवेह को सुखद-सुगंध के लिए भेंट न की जाएं. ");
INSERT INTO hincv_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","तुम अपनी सब अन्‍न बलियों में नमक चढ़ाना. तुम्हारी अन्‍नबलि से तुम्हारे परमेश्वर की वाचा का नमक अलग न रहे, अपनी सब बलियों के साथ तुम नमक भेंट करना. ");
INSERT INTO hincv_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘यदि तुम याहवेह को पहले फल की बलि भेंट करो, तो अपनी पहले फल बलि में अग्निबलि के लिए अग्नि में भुने गए नए अन्‍न की बालें लेकर आना. ");
INSERT INTO hincv_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","तुम इस पर तेल लगाना और लोबान रखना; यह एक अन्‍नबलि है. ");
INSERT INTO hincv_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","पुरोहित इसके स्मरण के लिए निर्धारित अंश, छिलका निकाला गया अन्‍न, तेल और इसके सारे लोबान के साथ जलाकर अग्निबलि के रूप में याहवेह को भेंट कर दे. ");
INSERT INTO hincv_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘यदि उसकी बलि एक मेल बलि है और यदि वह गाय-बैलों से एक पशु की बलि करता है, चाहे वह नर हो अथवा मादा, तो वह निर्दोष पशु को याहवेह के सामने भेंट करे. ");
INSERT INTO hincv_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","वह अपना हाथ इस बलि के सिर पर रखे और मिलनवाले तंबू के द्वार पर इसका वध करे, फिर अहरोन के पुत्र, जो पुरोहित हैं, इसका रक्त वेदी के चारों ओर छिड़क दें. ");
INSERT INTO hincv_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","मेल बलि के अर्पण द्वारा वह याहवेह को अग्निबलि स्वरूप यह अर्पित करे; अर्थात् वह चर्बी जो आंतों को ढांपती है और वह चर्बी, जो आंतों पर लिपटी हुई है, ");
INSERT INTO hincv_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","दोनों गुर्दों के साथ उनकी चर्बी जो कमर पर होती है, तथा कलेजे के ऊपर की झिल्ली, इन्हें वह गुर्दों सहित अलग कर दे. ");
INSERT INTO hincv_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","फिर अहरोन के पुत्र इसे वेदी पर अग्निबलि के ऊपर रखकर जलाएं जो आग पर रखी हुई है. यह याहवेह के लिए सुखद-सुगंध की अग्निबलि है. ");
INSERT INTO hincv_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘किंतु यदि याहवेह के लिए मेल बलि के रूप में उसकी बलि भेड़-बकरियों में से है, तो वह इसमें से निर्दोष नर अथवा मादा को बलि करे. ");
INSERT INTO hincv_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","यदि वह बलि के लिए एक मेमने को भेंट कर रहा है, तो वह इसे याहवेह को इस प्रकार भेंट करें: ");
INSERT INTO hincv_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","वह इस बलि के सिर पर अपना हाथ रखे और मिलनवाले तंबू के सामने इसका वध करे, अहरोन के पुत्र इसके रक्त को वेदी के चारों ओर छिड़क दें. ");
INSERT INTO hincv_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","मेल बलि की बलि से वह याहवेह के लिए अग्निबलि के रूप में यह अर्पित करे: इसकी चर्बी व मोटी पूंछ को वह रीढ़ से अलग करेगा, वह चर्बी जो आंतों को ढांपती है, वह संपूर्ण चर्बी, जो आंतों पर है, ");
INSERT INTO hincv_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","दोनों गुर्दे उस चर्बी के साथ जो कमर पर है तथा कलेजे के ऊपर की झिल्ली जिसे वह गुर्दों सहित अलग करेगा. ");
INSERT INTO hincv_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","फिर पुरोहित इसे वेदी पर अग्नि में आहार स्वरूप जलाए. यह याहवेह के लिए अग्निबलि है. ");
INSERT INTO hincv_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘यदि वह बलि में एक बकरी भेंट कर रहा है, तो वह इसे याहवेह के सामने भेंट करे, ");
INSERT INTO hincv_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","वह अपना हाथ इसके सिर पर रखे और मिलनवाले तंबू के सामने इसका वध करे, अहरोन के पुत्र इसके रक्त को वेदी के चारों ओर छिड़क दें. ");
INSERT INTO hincv_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","इसमें से वह याहवेह के लिए अग्निबलि के रूप में ये प्रस्तुत करे: वह चर्बी जो आंतों को ढांपती है, वह पूरी चर्बी जो आंतों पर है, ");
INSERT INTO hincv_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","दोनों गुर्दे उस चर्बी के साथ जो कमर पर है, तथा कलेजे के ऊपर की झिल्ली जिसे वह गुर्दों सहित अलग करेगा. ");
INSERT INTO hincv_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","फिर पुरोहित इसे वेदी पर आहार स्वरूप, जलते हुए धुएं में भेंट करे; सुखद-सुगंध के लिए एक अग्निबलि. पूरी चर्बी याहवेह की है. ");
INSERT INTO hincv_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘यह तुम्हारी पीढ़ियों तथा तुम्हारे निवासों में एक हमेशा की विधि है, तुम चर्बी को और रक्त को कभी न खाओगे.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","याहवेह ने मोशेह को आज्ञा दी: ");
INSERT INTO hincv_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“इस्राएल की प्रजा को यह आज्ञा दो, ‘यदि कोई व्यक्ति अनजाने में उन कार्यों को करता है, जो याहवेह की व्यवस्थाओं में मना हैं— ");
INSERT INTO hincv_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘यदि कोई अभिषिक्त पुरोहित पाप करता है, जिससे कि वह प्रजा पर भी दोष ले आता है, तब वह उस पाप के लिए, जो उसने किया है, याहवेह के सामने एक निर्दोष बछड़े को पापबलि के रूप में भेंट करे! ");
INSERT INTO hincv_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","उस बैल को वह याहवेह के सामने, मिलनवाले तंबू के द्वार पर, लेकर आए, अपना हाथ उस बैल के सिर पर रखे और याहवेह के सामने उसका वध करे. ");
INSERT INTO hincv_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","फिर वह अभिषिक्त पुरोहित उस बैल के रक्त में से कुछ रक्त लेकर उसे मिलनवाले तंबू में लेकर आए, ");
INSERT INTO hincv_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","पुरोहित अपनी उंगली उस रक्त में डुबोकर उसमें से कुछ रक्त को सात बार याहवेह के सामने पवित्र स्थान के पर्दे के सामने छिड़के. ");
INSERT INTO hincv_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","पुरोहित कुछ रक्त को सुगंधधूप वेदी के सींगों पर भी डाले, जो याहवेह के सामने मिलनवाले तंबू में है. पुरोहित बैल के पूरे रक्त को होमबलि की वेदी के आधार पर उंडेल दे, जो मिलनवाले तंबू के द्वार पर है. ");
INSERT INTO hincv_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","वह पापबलि के लिए प्रयोग किए जानेवाले बैल की पूरी चर्बी उससे हटा दे; वह चर्बी, जो आंतों को ढकती है, वह पूरी चर्बी, जो आंतों पर है, ");
INSERT INTO hincv_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","दोनों गुर्दे उस चर्बी के साथ, जो कमर पर है तथा कलेजे के ऊपर की झिल्ली, जिसे वह गुर्दों सहित अलग करेगा. ");
INSERT INTO hincv_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ठीक वैसे ही जैसे वह मेल बलि के लिए प्रयोग किए जानेवाले बैल से हटाई गई; पुरोहित होमबलि की वेदी पर इसे धुएं में भेंट करे, ");
INSERT INTO hincv_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","किंतु बैल की खाल और इसका सारा मांस, सिर, टांगें, आंतें तथा इस प्रक्रिया में उत्पन्‍न गंदगी, ");
INSERT INTO hincv_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","तथा बैल के शेष अंश को छावनी के बाहर, एक साफ़ स्थान पर, जहां राख फेंक दी जाती है, लेकर आए. यहां वह लकड़ियों पर इसको जलाए. ");
INSERT INTO hincv_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘यदि इस्राएली प्रजा कोई विसंगत कार्य करे, जिसके विषय में सभा अनजान है, और वे उन कार्यों के कारण दोषी ठहरें, जो याहवेह की ओर से मना हैं; ");
INSERT INTO hincv_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","जब सभा के सामने पाप प्रकट हो जाए, तब सभा पापबलि के लिए ढोरों में से एक बैल को मिलनवाले तंबू के सामने लेकर आए. ");
INSERT INTO hincv_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","सभा के प्रधान याहवेह के सामने अपना हाथ बैल के सिर पर रखें और वह याहवेह के सामने बैल का वध करे. ");
INSERT INTO hincv_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","अभिषिक्त पुरोहित बैल के रक्त में से कुछ रक्त मिलनवाले तंबू में लेकर आए. ");
INSERT INTO hincv_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","पुरोहित अपनी उंगली बैल के रक्त में डुबाकर उसमें से कुछ रक्त को सात बार याहवेह के सामने पवित्र स्थान के पर्दे के सामने छिड़के. ");
INSERT INTO hincv_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","पुरोहित कुछ रक्त को उस वेदी की सींगों पर भी डाले, जो याहवेह के सामने मिलनवाले तंबू में है, पुरोहित बैल के सारे रक्त को होमबलि की वेदी के आधार पर उंडेल दे, जो मिलनवाले तंबू के द्वार पर है. ");
INSERT INTO hincv_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","वह उस बैल से उसकी सारी चर्बी को हटाकर उस चर्बी को वेदी पर जलाए. ");
INSERT INTO hincv_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","वह इस बैल के साथ भी ठीक वैसा ही करे, जैसा उसने पापबलि के बैल के साथ किया था. पुरोहित प्रजा के लिए प्रायश्चित करे; और उन्हें क्षमा की जाएगी. ");
INSERT INTO hincv_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","फिर वह इस बैल को छावनी के बाहर लेकर आए और इसको उसी प्रकार जलाए, जैसे उसने पहले बैल को जलाया था; यह सभा के लिए पापबलि है. ");
INSERT INTO hincv_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘जब कोई प्रधान पुरुष अनजाने में पाप करता है, यानी वे कार्य करता है, जो याहवेह अपने परमेश्वर की ओर से मना हैं, और जब उसे पाप-बोध होता है, ");
INSERT INTO hincv_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","और जो पाप उसने किया है, वह प्रकट हो जाता है, तो वह अपनी बलि के लिए एक निर्दोष रोमयुक्त बकरा लेकर आए, ");
INSERT INTO hincv_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","वह अपना हाथ उस बकरे के सिर पर रखे और उस स्थान पर उसको बलि कर दे, जहां वे याहवेह के सामने होमबलि के पशु को बलि करते हैं; यह एक पापबलि है. ");
INSERT INTO hincv_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","फिर पुरोहित अपनी उंगली से उस पापबलि से कुछ रक्त लेकर होमबलि की वेदी की सींगों पर लगाए और इसके बचे हुए रक्त को वह होमबलि की वेदी के आधार पर उंडेल दे. ");
INSERT INTO hincv_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","वह इसकी सारी चर्बी को ठीक वैसे ही वेदी पर जला दे, जैसे उसने मेल बलि को की थी. इस प्रकार पुरोहित उस प्रधान द्वारा किए गए पाप के लिए प्रायश्चित करे; और उसे क्षमा प्रदान कर दी जाएगी. ");
INSERT INTO hincv_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘जब कोई जनसाधारण व्यक्ति अनजाने में उन कार्यों को करने के द्वारा पाप करता है, जो याहवेह ने न करने की आज्ञा दी है, और इसके द्वारा वह दोषी हो जाता है, ");
INSERT INTO hincv_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","तथा उसका वह पाप, जो उससे हो गया है उस पर प्रकट कर दिया जाता है, तो वह अपने उस पाप की बलि के लिए, जो उसने किया है, एक निर्दोष बकरी लेकर आए. ");
INSERT INTO hincv_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","वह अपना हाथ उस पापबलि के सिर पर रखे तथा होमबलि के स्थान पर इस पापबलि का बलिदान करे दे. ");
INSERT INTO hincv_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","फिर पुरोहित अपनी उंगली से इसके कुछ रक्त को लेकर होमबलि वेदी की सींगों पर लगाए और इसके बचे हुए रक्त को होमबलि की वेदी के आधार पर उंडेल दे. ");
INSERT INTO hincv_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","फिर वह इसकी सारी चर्बी को हटा दे, ठीक जैसे मेल बलि पर से चर्बी हटाई गई थी, पुरोहित याहवेह को सुखद-सुगंध के लिए इसे वेदी पर अग्नि में भेंट कर दे. इस प्रकार पुरोहित उसके लिए प्रायश्चित करेंगे, और उसे पाप क्षमा दी जाएगी. ");
INSERT INTO hincv_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘किंतु यदि वह बलि स्वरूप एक मेमना पापबलि के लिए लेकर आता है, तो यह एक निर्दोष मादा हो. ");
INSERT INTO hincv_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","वह अपना हाथ उस पशु के सिर पर रखे तथा पापबलि के लिए इसकी बलि उस स्थान पर कर दे, जहां होमबलि पशु को बलि किया जाता है. ");
INSERT INTO hincv_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","पुरोहित इस पापबलि के कुछ रक्त में से अपनी उंगली से होमबलि की वेदी के सींगों पर लगाए और इसके बचे हुए रक्त को वह वेदी के आधार पर उंडेल दे. ");
INSERT INTO hincv_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","फिर वह इसकी सारी चर्बी को हटा दे, ठीक जैसे मेल बलि के मेमने से चर्बी हटाई गई थी, पुरोहित इसे याहवेह को होमबलि के लिए वेदी पर अग्नि में भेंट कर दे. इस प्रकार पुरोहित उसके इस पाप के लिए उसका प्रायश्चित करेगा और उसे क्षमा दे दी जाएगी. ");
INSERT INTO hincv_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘यदि कोई व्यक्ति किसी पाप का गवाह है, जिसे उसने होते हुए देखा है, अथवा उसे इसका अहसास है और सार्वजनिक रूप से शपथ दिए जाने के बाद भी वह इसके विषय में मौन रहता है, तो वह उस अपराध का भार स्वयं उठाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘यदि कोई व्यक्ति किसी अशुद्ध वस्तु का स्पर्श करे, चाहे वह किसी अशुद्ध जंगली पशु का शव हो, अथवा किसी अन्य पालतू पशु का शव अथवा किसी ऐसे अशुद्ध जीव का शव हो जो रेंगता हो, और यदि वह इससे अनजान है कि वह अशुद्ध हो चुका है, किंतु इसके बाद उसे इसका अहसास हो जाता है, तो वह दोषी हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","यदि वह किसी मानव मलिनता का स्पर्श करे, चाहे वह किसी भी प्रकार की मलिनता हो और वह इससे अशुद्ध हो जाता है और वह इससे अनजान है, किंतु इसके बाद उसे इसका अहसास हो जाता है, तो वह दोषी हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","अथवा यदि कोई व्यक्ति बिना सोचे विचारे, भले अथवा बुरे की शपथ लेता है, चाहे कोई भी विषय हो, कोई व्यक्ति बिना सोचे विचारे, शपथ लेता है तथा यह उसे मालूम नहीं है, और इसके बाद यह उस पर प्रकट हो जाता है, तो इसमें से किसी एक विषय में वह दोषी हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","जब इसमें से किसी भी विषय के दोष का उसे अहसास होता है, और वह उस पाप को स्वीकार करे, जो उसने किया है, ");
INSERT INTO hincv_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","तो जो पाप उसने किया है, उसके लिए वह याहवेह के सामने अपनी दोष बलि लेकर आए. वह भेड़-बकरियों से एक मादा मेमना, अथवा एक बकरी पापबलि के लिए लेकर आए कि पुरोहित उसके द्वारा उसके पाप के लिए प्रायश्चित करे. ");
INSERT INTO hincv_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘किंतु यदि उसके लिए एक मेमना भेंट करना संभव नहीं है, तो जो पाप उसने किया है, उसके लिए वह याहवेह के सामने अपनी दोष बलि के लिए दो कपोत अथवा दो कबूतर के बच्‍चे लेकर आए; एक पापबलि के लिए और दूसरा होमबलि के लिए. ");
INSERT INTO hincv_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","वह इसे पुरोहित के पास लाए, वह सर्वप्रथम उसे भेंट करे, जो पापबलि के लिए निर्धारित है. वह इसका सिर इसके गर्दन के पास से मरोड़ दे, किंतु पूरी तरह अलग न करे. ");
INSERT INTO hincv_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","वह पापबलि का कुछ रक्त वेदी के दूसरे सिरे पर छिड़क दे, जबकि बचा हुआ रक्त वेदी के आधार पर बहा दिया जाए. यह एक पापबलि है. ");
INSERT INTO hincv_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","फिर वह विधि के अनुसार होमबलि के रूप में दूसरे पक्षी को तैयार करे, कि पुरोहित उसके द्वारा उसके पाप के लिए, जो उस व्यक्ति ने किया है, प्रायश्चित करे, और उसका यह पाप क्षमा कर दिया जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘किंतु यदि उसके लिए दो कपोत अथवा दो कबूतर के बच्‍चे भी भेंट करने के लिए पर्याप्‍त साधन नहीं हैं, तो जो पाप उसने किया है, उसकी बलि के लिए वह डेढ़ किलो महीन आटा पापबलि के लिए लेकर आए. किंतु इस पर तेल न लगाए और न ही इस पर लोबान रखे, क्योंकि यह एक पापबलि है. ");
INSERT INTO hincv_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","वह इसे पुरोहित के पास लेकर आए और पुरोहित इसमें से मुट्ठी भर महीन आटे को इसके स्मरण दिलाने वाले भाग के रूप में लेकर याहवेह की अन्य अग्निबलियों के साथ वेदी पर जलाए. यह एक पापबलि है. ");
INSERT INTO hincv_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","इस प्रकार पुरोहित इनमें से किसी भी पाप के लिए, जो उस व्यक्ति ने किया है, प्रायश्चित करे, और उसका यह पाप क्षमा कर दिया जाएगा. इसका शेष भाग अन्‍नबलि के समान पुरोहित का होगा.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","फिर याहवेह ने मोशेह को यह आदेश दिया: ");
INSERT INTO hincv_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“यदि कोई व्यक्ति विश्वासघात करे तथा अनजाने में याहवेह की पवित्र वस्तुओं के संदर्भ में पाप करे, तो वह अपने द्वारा किए गए विश्वासघात के लिए याहवेह के सामने दोष बलि के रूप में भेड़-बकरियों में से एक निर्दोष मेढ़े भेंट करे, जिसका मूल्य पवित्र स्थान के शेकेल के अनुसार चांदी का एक शेकेल हो; यह दोष बलि है. ");
INSERT INTO hincv_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","उसने जिस पवित्र वस्तु के संदर्भ में पाप किया है, उसके लिए वह नुकसान की भरपाई करे. वह इसमें इसके पांचवें भाग को जोड़कर पुरोहित को सौंप दे. पुरोहित दोष बलि के मेढ़े के साथ उसके लिए प्रायश्चित करे, और उसका यह पाप क्षमा कर दिया जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“यदि कोई व्यक्ति पाप करता है, और कोई भी वह कार्य करता है, जो याहवेह की ओर से मना किया गया है, यद्यपि वह इससे अनजान है, तो भी वह दोषी है और अपने दंड का भार उठाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","फिर वह दोष बलि के लिए भेड़-बकरियों में से उपयुक्त मूल्य का एक निर्दोष मेंढ़ा ले आए कि पुरोहित उस व्यक्ति द्वारा किए गए उस विश्वासघात के लिए, जो उसने अनजाने में किया है, प्रायश्चित करे, और उसका यह विश्वासघात क्षमा कर दिया जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","यह एक दोष बलि है; निःसंदेह वह याहवेह की दृष्टि में दोषी था.” ");
INSERT INTO hincv_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","याहवेह ने मोशेह को कहा, ");
INSERT INTO hincv_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“जब कोई व्यक्ति पाप करे, याहवेह के विरुद्ध विश्वासघात करे, तथा अपने पड़ोसी द्वारा सौंपी गई धरोहर अथवा सुरक्षा के संदर्भ में उससे छल करे, अथवा उसे लूटे, अथवा अपने पड़ोसी को सताए, ");
INSERT INTO hincv_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","अथवा उसे कोई खोई हुई वस्तु प्राप्‍त हुई हो और वह इसके विषय में झूठ बोल कर झूठी शपथ खाए, यानी इनमें से किसी भी कार्य को करने के द्वारा पाप करे; ");
INSERT INTO hincv_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","इसका प्रावधान यह होगा: जब वह पाप करे और उसे इसका अहसास हो जाए, तब वह लूटी गई सामग्री, अथवा वह जो उत्पीड़न से प्राप्‍त किया गया है, अथवा जो धरोहर उसे सौंपी गई थी, अथवा जो खोई हुई वस्तु उसे प्राप्‍त हुई थी, ");
INSERT INTO hincv_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","अथवा किसी ऐसी वस्तु के संदर्भ में जिसके लिए उसने झूठी शपथ खाई थी; उसे इसकी पूरी भरपाई करनी होगी, और उसे इसका पांचवां भाग अतिरिक्त देना होगा. जिस दिन वह अपनी दोष बलि भेंट करे, उस दिन वह उस व्यक्ति को ये सब वस्तुएं लौटा दे जिसकी ये वस्तुएं थीं. ");
INSERT INTO hincv_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","तब वह उपयुक्त मूल्य का निर्दोष मेढ़ा दोष बलि के रूप में याहवेह के लिए भेड़-बकरियों में से पुरोहित के पास लेकर आए, यह दोष बलि है, ");
INSERT INTO hincv_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","और पुरोहित याहवेह के सामने उसके लिए प्रायश्चित सम्पन्‍न करे. इस प्रकार उसे इनमें से किसी भी दोष के लिए क्षमा प्रदान कर दी जाएगी.” ");
INSERT INTO hincv_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","याहवेह ने मोशेह को यह आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“अहरोन और उनके पुत्रों को यह आदेश दो, ‘होमबलि के लिए विधि यह है: होमबलि पूरी रात से लेकर सुबह तक वेदी वेदी के चूल्हे पर ही रहे, और वेदी पर अग्नि जलती रहे. ");
INSERT INTO hincv_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","पुरोहित अपने सफ़ेद मलमल के वस्त्र और अपनी देह पर मलमल की जांघिया पहने; वह वेदी की राख, जो अग्नि द्वारा जलाई गई है, उठाए और उसे वेदी की एक ओर रख दे. ");
INSERT INTO hincv_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","इसके बाद वह अपने ये वस्त्र उतार दूसरे वस्त्र पहने और राख को छावनी के बाहर एक स्वच्छ स्थान पर ले जाए. ");
INSERT INTO hincv_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","वेदी पर अग्नि जलती रहे. यह बुझने न पाए, किंतु पुरोहित हर सुबह इस पर लकड़ियां रख दे; इन पर होमबलि को रखे, और इस पर मेल बलि के चर्बी वाले भाग को अग्नि में जलाया करे. ");
INSERT INTO hincv_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","वेदी पर अग्नि लगातार जलती रहे. यह बुझने न पाए. ");
INSERT INTO hincv_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘अन्‍नबलि के लिए विधि यह है: अहरोन के पुत्र इसे याहवेह के लिए वेदी के सामने प्रस्तुत करें. ");
INSERT INTO hincv_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","उनमें से एक पुरोहित इस अन्‍नबलि में से एक मुट्ठी भर आटा, तेल तथा इस पर रखे सारे लोबान को ले, और इसे वेदी की अग्नि में जलाए. यह याहवेह को स्मरण बलि के लिए भेंट की गई सुखद-सुगंध है. ");
INSERT INTO hincv_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","इसमें से जो भाग बच जाए, अहरोन और उसके पुत्र उसका इस्तेमाल करें. इसका इस्तेमाल पवित्र स्थान में बिना खमीर की रोटी के रूप में किया जाए; उन्हें इसका इस्तेमाल मिलनवाले तंबू के आंगन में ही करना है. ");
INSERT INTO hincv_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","इसे खमीर के साथ पकाया न जाए; मैंने इसे उनके भाग के रूप में अपनी होमबलि में से प्रदान किया है, यह पापबलि तथा दोष बलि के समान परम पवित्र है. ");
INSERT INTO hincv_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","अहरोन के पुत्रों में से हर एक इसका इस्तेमाल करे; याहवेह को भेंट की गई होमबलियों में से तुम्हारी पीढ़ियों के लिए यह हमेशा की विधि है. जो कोई इन बलियों को छुएगा, वह अपने आप पवित्र हो जाएगा.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","याहवेह ने मोशेह को यह भी आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“जब कभी अहरोन की पौरोहितिक परंपरा के अंतर्गत किसी पुरोहित का अभिषेक किया जाए, तो अहरोन और उनके पुत्र याहवेह को यह बलि भेंट करें; उस बलि में नियमित अन्‍नबलि के रूप में सबसे उत्तम डेढ़ किलो आटा भेंट किया जाए; आधा सुबह और आधा शाम को. ");
INSERT INTO hincv_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","इसे तवे पर तेल के साथ पकाया जाए. जब यह पूरी तरह पक जाए, तब तुम उसे लाकर टुकड़ों में याहवेह को सुखद-सुगंध के रूप में अन्‍नबलि चढ़ाना. ");
INSERT INTO hincv_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","उसके पुत्रों में से जो उसके स्थान पर पुरोहित अभिषिक्त किया जाएगा, वह उस भेंट चढ़ाए. यह याहवेह के लिए अग्नि में जलाई हुई हमेशा की विधि के रूप में भेंट पूरी अन्‍नबलि भेंट हो. ");
INSERT INTO hincv_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","पुरोहित की हर एक अन्‍नबलि; यह पूरी तरह से जलाई जाए. इसको खाया न जाए.” ");
INSERT INTO hincv_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","याहवेह ने मोशेह को यह आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“अहरोन और उसके पुत्रों को यह आदेश दो, ‘पापबलि के लिए विधि यह है: जिस स्थान पर होमबलि के लिए निर्धारित पशु का वध किया जाता है, उसी स्थान पर याहवेह के सामने पापबलि के लिए निर्धारित पशु का वध किया जाए; यह परम पवित्र है. ");
INSERT INTO hincv_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","इसको वही पुरोहित खाए, जो इसे पाप के लिए भेंट करता है. ज़रूरी है कि इसको सिर्फ़ पवित्र स्थान में ही खाया जाए; मिलाप वाले तंबू के आंगन में ही. ");
INSERT INTO hincv_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","जो कोई इसके मांस को छू लेगा, वह पवित्र हो जाएगा; यदि उसके रक्त के छींटे किसी वस्त्र पर आ पड़ें, तो ज़रूरी है कि इसे किसी पवित्र स्थान में ही धो दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","मिट्टी के जिस बर्तन में इसे पकाया गया था, उसे तोड़ दिया जाए; यदि इसे पीतल के बर्तन में पकाया गया हो, तो उस पात्र को रगड़-रगड़ कर पानी से धो दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","अहरोन के पुत्रों में से हर एक पुरुष इसको खा सकता है; यह परम पवित्र है. ");
INSERT INTO hincv_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","किंतु, किसी पापबलि को न खाया जाए, जिसका रक्त पवित्र स्थान के मिलनवाले तंबू में प्रायश्चित के लिए लाया गया है, उसको, इस अग्नि में जला दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘दोष बलि जो कि परम पवित्र है, उसके लिए तय की गयी विधि यह है: ");
INSERT INTO hincv_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","जिस स्थान पर वे होमबलि के लिए निर्धारित पशु का वध करते हैं, उसी स्थान पर दोष बलि के लिए निर्धारित पशु का भी वध किया जाए और वह उसके रक्त को वेदी के चारों ओर छिड़क दे. ");
INSERT INTO hincv_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","फिर वह इसकी सारी चर्बी अर्थात् मोटी पूंछ तथा वह चर्बी, जो आंतों को ढकती है, ");
INSERT INTO hincv_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","दोनों गुर्दे चर्बी के साथ, जो कमर पर है, तथा कलेजे की ऊपर की झिल्ली, गुर्दों सहित अलग कर भेंट करें. ");
INSERT INTO hincv_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","पुरोहित याहवेह को इसे होमबलि के रूप में वेदी पर अग्नि में जला दे; यह दोष बलि है. ");
INSERT INTO hincv_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","पुरोहितों में से हर एक पुरुष इसको खा सकता है. इसको पवित्र स्थान में ही खाया जाए; यह परम पवित्र है. ");
INSERT INTO hincv_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘दोष बलि पापबलि के ही समान है, उनके लिए एक ही विधि है; इसको वही पुरोहित खाए, जो इसके द्वारा प्रायश्चित पूरा करता है. ");
INSERT INTO hincv_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","वह पुरोहित, जो किसी व्यक्ति के लिए होमबलि भेंट करता है, होमबलि के उस पशु की खाल, जो उसने भेंट की है, स्वयं के लिए रख ले. ");
INSERT INTO hincv_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","उसी प्रकार हर एक अन्‍नबलि, जो तंदूर या कड़ाही में, अथवा तवे पर पकाया गया है, वे सभी कुछ उसी पुरोहित की होगी, जो उसे भेंट करता है. ");
INSERT INTO hincv_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","हर एक अन्‍नबलि, चाहे तेल मिली हो, या तेल रहित, अहरोन के सभी पुत्रों को समान मात्रा में मिलेगी. ");
INSERT INTO hincv_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘उन मेल बलियों के लिए, जो याहवेह के सामने चढ़ाई जाएं, उनके लिए विधि यह है: ");
INSERT INTO hincv_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘यदि वह इसे आभार के रूप में भेंट करता है, तो वह आभार-बलि के साथ तेल से सनी हुई खमीर रहित रोटी, तेल से चुपड़ी पपड़ी तथा तेल से सनी हुई मैदे की रोटी भेंट करे. ");
INSERT INTO hincv_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","आभार के रूप में भेंट की गई अपनी मेल बलियों के बलि पशु के साथ वह खमीर युक्त रोटी भी भेंट करे. ");
INSERT INTO hincv_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","वह ऐसी हर एक बलि में से एक-एक रोटी याहवेह को अंशदान के रूप में भेंट करे; यह उसी पुरोहित की होगी, जो मेल बलि के पशु के रक्त को छिड़कता है. ");
INSERT INTO hincv_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","आभार के रूप में भेंट की गई मेल बलियों की बलि के मांस को उसकी बलि के दिन ही खा लिया जाए. वह प्रातः तक इसमें से कुछ भी बचाकर न रखे. ");
INSERT INTO hincv_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘किंतु यदि उसकी बलि एक मन्नत अथवा स्वेच्छा बलि है, तो उसको उस दिन खाया जाए जिस दिन उसने इसे अर्पित किया हो, तथा शेष अंश को अगले दिन खाया जा सकता है. ");
INSERT INTO hincv_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","किंतु यदि उस बलि के मांस में से तीसरे दिन कुछ बचा रह गया है, तो अग्नि में उसे जला दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","इसलिये यदि वह मेल बलि के पशु के मांस को तीसरे दिन खा लेता है, जिसने उसे भेंट किया है, न तो वह बलि स्वीकार होगी और न ही उसके लिए लाभदायक. यह एक आपत्तिजनक कार्य है, और जो कोई व्यक्ति इसको खाता है, वह स्वयं अपना दोष उठाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘जिस मांस का स्पर्श किसी अपवित्र वस्तु से हो जाए, उसको खाया न जाए; इसे अग्नि में जला दिया जाए. हर एक, जो शुद्ध है इसको खा सकता है, ");
INSERT INTO hincv_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","किंतु अपनी अशुद्धता में कोई व्यक्ति मेल बलियों की बलि के उस मांस को खा लेता है, जो याहवेह का है, तो उसे लोगों के मध्य से हटा दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","यदि कोई व्यक्ति किसी अशुद्ध वस्तु का स्पर्श कर लेता है; चाहे वह मानव मलिनता हो अथवा कोई अशुद्ध पशु अथवा कोई अशुद्ध घृणित वस्तु हो, और वह मेल बलियों की बलि के उस मांस को खा लेता है, जो याहवेह को अर्पित है, तो उसे उसके लोगों के मध्य से हटा दिया जाए.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","याहवेह ने मोशेह को यह आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“इस्राएल की प्रजा को यह आदेश दो, ‘तुम किसी बैल, भेड़ अथवा बकरी की चर्बी को न खाना. ");
INSERT INTO hincv_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","उस पशु की चर्बी को भी, जिसकी स्वाभाविक मृत्यु हो चुकी है, या जो वन-पशुओं द्वारा मार डाला गया है. तुम उसे किसी अन्य उपयोग के लिए तो रख सकते हो, किंतु निश्चयतः उसको खाना मना है. ");
INSERT INTO hincv_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","जो व्यक्ति उस पशु की चर्बी को खाता है, जिसे याहवेह को अग्निबलि के रूप में भेंट किया गया है, उसे उसके लोगों के मध्य से हटा दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","तुम अपने घर में किसी पशु अथवा पक्षी के रक्त को न खाना. ");
INSERT INTO hincv_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","जो भी व्यक्ति किसी भी रक्त को खाता है, उसे भी उसके लोगों के मध्य से हटा दिया जाए.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","याहवेह ने मोशेह को यह आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“इस्राएल की प्रजा को यह आदेश दो, ‘वह व्यक्ति, जो याहवेह को अपनी मेल बलियां भेंट करता है, याहवेह को उसी मेल बलि में से एक हिस्सा अपनी भेंट के रूप में चढ़ाए, ");
INSERT INTO hincv_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","और वह स्वयं अपने हाथों में याहवेह को होमबलि के लिए चर्बी एवं छाती लेकर आए, कि छाती याहवेह के सामने लहराने की बलि के रूप में भेंट की जाए. ");
INSERT INTO hincv_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","पुरोहित चर्बी को तो वेदी पर अग्नि में जला दे, किंतु छाती अहरोन और उनके पुत्रों की है. ");
INSERT INTO hincv_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","तुम अपनी मेल बलियों की बलियों में से दाहिनी जांघ पुरोहित को दे देना. ");
INSERT INTO hincv_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","अहरोन के पुत्रों के मध्य से जो पुत्र मेल बलियों के रक्त और चर्बी को भेंट करता है, दाहिनी जांघ उसके अंशदान के रूप में उसी की होगी. ");
INSERT INTO hincv_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","क्योंकि इस्राएल की प्रजा से मैंने उनकी मेल बलियों की बलियों में से लहराने की बलि के रूप में भेंट की गई छाती, और अंशदान की जांघ को लेकर उसे पुरोहित अहरोन और उनके पुत्रों को दिया गया है. यह इस्राएल की प्रजा से सर्वदा के लिए पुरोहित अहरोन और उनके पुत्रों को अधिकार के रूप में दे दिया है.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","यह वह अंश है, जो याहवेह की अग्निबलियों में से अहरोन और उनके पुत्रों के लिए है; जिस दिन से उसने उन्हें याहवेह के सामने पौरोहितिक सेवा के लिए प्रस्तुत किया. ");
INSERT INTO hincv_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","जिस दिन उनका अभिषेक किया गया, उस दिन याहवेह ने इस्राएल की प्रजा से उन्हें यह वस्तुएं देने का आदेश दिया है. पीढ़ियों से पीढ़ियों तक सर्वदा के लिए यह उनका अधिकार है. ");
INSERT INTO hincv_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","उपरोक्त विधि; होमबलि, अन्‍नबलि, पापबलि, दोष बलि, संस्कार बलि तथा मेल बलियों के भेंट के लिए है. ");
INSERT INTO hincv_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","इसके विषय में आदेश याहवेह ने मोशेह को सीनायी पर्वत पर उस दिन दिए थे, जिस दिन याहवेह ने इस्राएल की प्रजा को सीनायी की मरुभूमि में याहवेह के लिए अपनी बलियां प्रस्तुत करने का आदेश दिया था. ");
INSERT INTO hincv_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","फिर याहवेह ने मोशेह को यह आदेश दिया कि ");
INSERT INTO hincv_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","वह अपने साथ अहरोन और उनके पुत्र, और साथ में उनके वस्त्र, अभिषेक का तेल, पापबलि के लिए निर्धारित बैल, दो मेढ़े और एक टोकरी में खमीर रहित रोटी ले, ");
INSERT INTO hincv_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","और मिलनवाले तंबू के द्वार पर सारी सभा को इकट्ठा करे. ");
INSERT INTO hincv_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","तब मोशेह ने याहवेह के आदेश के अनुसार वैसा ही किया. जब सभा मिलनवाले तंबू के द्वार पर इकट्ठी हुई, ");
INSERT INTO hincv_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","तब मोशेह ने सभा को इस प्रकार संबोधित किया, “जिस कार्य को पूरा करने का आदेश याहवेह ने दिया है, वह यह है.” ");
INSERT INTO hincv_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","फिर मोशेह ने अहरोन और उनके पुत्रों को अपने निकट बुलाया और जल से उनको नहलाया. ");
INSERT INTO hincv_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","मोशेह ने अहरोन को कुर्ता तथा एफ़ोद पहनाकर उस पर कलात्मक रूप से बुनी हुई कोष बांध दी. ");
INSERT INTO hincv_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","फिर उन्होंने अहरोन को सीनाबंद पहनाया और उसमें उरीम एवं थुम्मीम लगा दिए. ");
INSERT INTO hincv_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","उन्होंने उसके सिर पर पगड़ी भी पहना दी, और उस पगड़ी के सामने की ओर सोने के टीके अर्थात् पवित्र मुकुट को लगाया, ठीक जैसा आदेश याहवेह ने मोशेह को दिया था. ");
INSERT INTO hincv_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","मोशेह ने अभिषेक का तेल लेकर पवित्र स्थान और उसके भीतर जो कुछ भी था, उसका अभिषेक कर उन्हें परम पवित्र किया. ");
INSERT INTO hincv_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","उन्होंने कुछ तेल वेदी पर सात बार छिड़क दिया, वेदी और इसके सारे पात्रों, चिलमची और उसके आधार को पवित्र करने के लिए उनका अभिषेक किया. ");
INSERT INTO hincv_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","फिर उन्होंने अभिषेक का कुछ तेल अहरोन के सिर पर उंडेलकर उन्हें पवित्र करने के लिए उनका अभिषेक किया. ");
INSERT INTO hincv_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","इसके बाद मोशेह ने अहरोन के पुत्रों को अपने पास बुलाया और उन्हें अंगरखे पहनाकर उन पर कटिबंध बांधे तथा उन्हें टोपियां पहना दीं; ठीक वैसा ही, जैसा आदेश याहवेह ने मोशेह को दिया था. ");
INSERT INTO hincv_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","मोशेह पापबलि के लिए निर्धारित बैल लेकर आए और अहरोन और उनके पुत्रों ने पापबलि के इस बैल के सिर पर अपने हाथ रखे. ");
INSERT INTO hincv_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","मोशेह ने इस बैल का वध किया और वेदी को पाप दोष से हटाने के लिए अपनी उंगली से उसका कुछ रक्त लेकर वेदी के सींगों पर लगाया. उसके बाद इसके बचे हुए रक्त को वेदी के आधार पर उंडेल दिया और प्रायश्चित पूरा करने के लिए उसे परम पवित्र किया. ");
INSERT INTO hincv_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","मोशेह ने आंतों की सारी चर्बी, कलेजे के ऊपर की झिल्ली तथा दोनों गुर्दों के साथ उनकी चर्बी को लिया और उसे वेदी पर अग्नि में जलाकर भेंट कर दिया. ");
INSERT INTO hincv_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","किंतु बैल, उसकी खाल, मांस और इस प्रक्रिया में उत्पन्‍न गोबर इन चीज़ों को छावनी के बाहर अग्नि में जला दिया; ठीक जैसा आदेश याहवेह ने मोशेह को दिया था, वैसा ही. ");
INSERT INTO hincv_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","फिर मोशेह ने होमबलि के लिए तय मेढ़े को प्रस्तुत किया. अहरोन और उनके पुत्रों ने उस मेढ़े के सिर पर अपने हाथ रखे. ");
INSERT INTO hincv_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","मोशेह ने मेढ़े को बलि की, और इसके रक्त को वेदी के चारों ओर छिड़क दिया. ");
INSERT INTO hincv_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","उन्होंने इस मेढ़े को टुकड़े किए और इसके सिर, टुकड़ों और ठोस चर्बी को जला दिया. ");
INSERT INTO hincv_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","मोशेह ने आंतों और टांगों को जल से धोकर पूरे मेढ़े को वेदी पर अग्नि में जलाकर भेंट कर दिया. सुखद-सुगंध के लिए यह एक होमबलि; हां याहवेह को भेंट एक अग्निबलि थी; ठीक जैसा आदेश याहवेह ने मोशेह को दिया था, वैसा ही. ");
INSERT INTO hincv_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","इसके बाद मोशेह ने दूसरा मेढ़ा, अर्थात् संस्कार का मेढ़ा प्रस्तुत किया, और अहरोन और उनके पुत्रों ने उस मेढ़े के सिर पर अपने हाथ रखे. ");
INSERT INTO hincv_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","मोशेह ने मेढ़े को बलि किया; और अहरोन के दायें कान, उनके दायें हाथ और दायें पैर के अंगूठे पर उसका कुछ रक्त लगा दिया. ");
INSERT INTO hincv_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","मोशेह ने अहरोन के पुत्रों को भी पास बुलाकर उनके दायें कान, उनके दायें हाथ के अंगूठे और दायें पैर के अंगूठे पर उसका कुछ रक्त लगा दिया. उसके बाद मोशेह ने शेष रक्त को वेदी के चारों ओर छिड़क दिया. ");
INSERT INTO hincv_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","मोशेह ने उस मेढ़े की चर्बी, मोटी पूंछ, आंतों पर की चर्बी, कलेजे के ऊपर की झिल्ली, दोनों गुर्दे तथा उनकी चर्बी और दायीं जांघ ली; ");
INSERT INTO hincv_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","उन्होंने याहवेह के सामने रखी खमीर रहित रोटी की टोकरी से एक खमीर रहित रोटी, तेल सनी हुई रोटी और एक पपड़ी ली और उन्हें चर्बी के भाग एवं दायीं जांघ पर रख दिया. ");
INSERT INTO hincv_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ये सभी वस्तुएं अहरोन एवं उसके पुत्रों के हाथों में रखकर इन्हें याहवेह को चढ़ाने की भेंट मानकर याहवेह के आगे लहराया. ");
INSERT INTO hincv_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","मोशेह ने इन्हें उनके हाथों से लेकर होमबलि के साथ इन्हें वेदी पर जला दिया. ये याहवेह को भेंट की गयी सुखद-सुगंध के लिए अग्निबलि के रूप में संस्कार की बलि थी. ");
INSERT INTO hincv_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","मोशेह ने मेढ़े की छाती भी ली, यह संस्कार के मेढ़े में से मोशेह का अंश था, और इसे याहवेह के सामने लहराने की बलि के रूप में प्रस्तुत किया; ठीक जैसा आदेश याहवेह ने मोशेह को दिया था, वैसा ही. ");
INSERT INTO hincv_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","मोशेह ने अभिषेक के तेल और वेदी पर के रक्त में से कुछ रक्त लेकर इसे अहरोन, उनके वस्त्रों, उनके पुत्रों और उनके वस्त्रों पर छिड़क दिया. इस प्रकार मोशेह ने अहरोन, उनके वस्त्रों, उनके पुत्रों और उनके पुत्रों के वस्त्रों को परम पवित्र किया. ");
INSERT INTO hincv_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","इसके बाद मोशेह ने अहरोन और उनके पुत्रों को यह आदेश दिया “मिलनवाले तंबू के द्वार पर मांस को उबालो और इसे उस रोटी के साथ खाओ, जो रोटी संस्कार बलि की टोकरी में है, ठीक जैसा आदेश मैंने दिया था कि, अहरोन और उनके पुत्र इसको खाएं. ");
INSERT INTO hincv_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","शेष मांस और रोटी को तुम अग्नि में जला देना. ");
INSERT INTO hincv_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","सात दिनों के लिए तुम मिलनवाले तंबू के द्वार के बाहर न जाना, जब तक तुम्हारा संस्कार का क्रिया काल पूरा न हो जाए; क्योंकि तुम्हारा संस्कार का क्रिया काल सात दिन का होगा. ");
INSERT INTO hincv_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","तुम्हारे लिए प्रायश्चित पूरा करने के लिए वही किया जाना ज़रूरी है, जैसा आज किया गया है, ठीक जैसा आदेश याहवेह ने दिया है. ");
INSERT INTO hincv_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","इसके अतिरिक्त तुम्हें मिलनवाले तंबू के द्वार पर सात दिनों के लिए दिन-रात ठहरे रहना है, याहवेह द्वारा दिए गए आदेशों का पालन करना ज़रूरी है कि तुम्हारी मृत्यु न हो, क्योंकि मुझे ऐसा ही आदेश दिया गया है.” ");
INSERT INTO hincv_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","इस प्रकार अहरोन और उनके पुत्रों ने वे सारे कार्य किए, जिनका आदेश याहवेह ने मोशेह के द्वारा दिया था. ");
INSERT INTO hincv_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","फिर आठवें दिन मोशेह ने अहरोन, उनके पुत्रों और इस्राएल के प्रधानों को बुलाया. ");
INSERT INTO hincv_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","मोशेह ने अहरोन को यह आदेश दिया, “अपने लिए गाय-बैलों से पापबलि के लिए एक निर्दोष बछड़ा और होमबलि के लिए एक निर्दोष मेढ़ा लो, और उन्हें याहवेह को भेंट करो. ");
INSERT INTO hincv_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","उसके बाद तुम इस्राएल की प्रजा को यह आदेश दो, ‘पापबलि के लिए एक बकरा और होमबलि के लिए एक साल का निर्दोष बछड़ा और एक निर्दोष मेमना, ");
INSERT INTO hincv_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","मेल बलि के लिए याहवेह के सम्मुख भेंट चढ़ाने के हेतु एक बैल व एक मेढ़ा तथा तेल से सनी हुई अन्‍नबलि लो; क्योंकि आज याहवेह तुम पर प्रकट होंगे.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","फिर वे उन सब वस्तुओं को मिलनवाले तंबू के सामने ले आए, जिसका आदेश मोशेह ने उन्हें दिया था, और सारी सभा निकट आकर याहवेह के सामने खड़ी हो गई. ");
INSERT INTO hincv_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","मोशेह ने उन्हें संबोधित किया, “ये हैं वे कार्य, जिन्हें करने का आदेश याहवेह ने तुम्हें दिया है कि याहवेह के प्रताप का तुम पर प्रकाशन हो.” ");
INSERT INTO hincv_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","इसके बाद मोशेह ने अहरोन को यह आदेश दिया, “वेदी के निकट आ जाओ, और अपनी पापबलि और होमबलि भेंट करो कि तुम स्वयं के लिए और प्रजा के लिए प्रायश्चित पूरा कर सको; इसके बाद प्रजा के लिए बलि अर्पण करो कि उनके लिए प्रायश्चित पूरा कर सको, ठीक जैसा आदेश याहवेह ने दिया है.” ");
INSERT INTO hincv_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","फिर अहरोन ने वेदी के निकट आकर अपनी पापबलि के लिए निर्धारित उस बछड़े का वध किया. ");
INSERT INTO hincv_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","अहरोन के पुत्रों ने उनके सामने रक्त प्रस्तुत किया और उन्होंने इसमें अपनी उंगली डुबोकर कुछ रक्त वेदी की सींगों पर लगाया और शेष रक्त को वेदी के आधार पर उंडेल दिया. ");
INSERT INTO hincv_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","फिर उन्होंने पापबलि के लिए निर्धारित चर्बी, गुर्दे, और कलेजे के ऊपर की झिल्ली को वेदी पर अग्नि में जला दिया, ठीक जैसा आदेश याहवेह ने मोशेह को दिया था. ");
INSERT INTO hincv_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","किंतु उन्होंने खाल और मांस को छावनी के बाहर अग्नि में जला दिया. ");
INSERT INTO hincv_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","इसके बाद उन्होंने होमबलि के पशु का वध किया; अहरोन के पुत्रों ने उन्हें रक्त सौंप दिया और उन्होंने इसे वेदी के चारों ओर छिड़क दिया. ");
INSERT INTO hincv_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","उन्होंने होमबलि के पशु को टुकड़ों में उसके सिर के साथ अहरोन को सौंप दिया और अहरोन ने उन्हें वेदी पर अग्नि में जलाकर भेंट कर दिया. ");
INSERT INTO hincv_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","उन्होंने आंतों और टांगों को भी धो करके उन्हें होमबलि के साथ वेदी पर अग्नि में जलाकर भेंट कर दिया. ");
INSERT INTO hincv_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","फिर उन्होंने प्रजा के लिए निर्धारित बलि को प्रस्तुत किया. उन्होंने उस बकरे को लेकर, जो प्रजा के लिए निर्धारित पापबलि के लिए था, इसका वध करके पहले बलि के पशु समान भेंट कर दिया. ");
INSERT INTO hincv_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","उन्होंने होमबलि के पशु को भी प्रस्तुत कर विधि के अनुसार इसे भेंट किया. ");
INSERT INTO hincv_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","इसके बाद उन्होंने अन्‍नबलि को प्रस्तुत किया, प्रातःकाल की होमबलि के अतिरिक्त उन्होंने इसमें से भी मुट्ठी भर भाग लेकर वेदी पर अग्नि में जलाकर भेंट किया. ");
INSERT INTO hincv_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","इसके बाद उन्होंने प्रजा के लिए मेल बलि के लिए निर्धारित बैल और मेढ़े का वध किया, और अहरोन के पुत्रों ने अहरोन को रक्त सौंप दिया, जिसे उन्होंने वेदी के चारों ओर छिड़क दिया. ");
INSERT INTO hincv_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","उन्होंने बैल तथा मेढ़े की चर्बी के भाग, मोटी पूंछ, वह चर्बी जो आंतों को ढकती है, गुर्दे और कलेजे के ऊपर की झिल्ली भी उन्हें सौंप दी, ");
INSERT INTO hincv_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","उन्होंने चर्बी के भाग को छाती पर रखा और अहरोन ने उन्हें वेदी पर अग्नि में जलाकर भेंट कर दिया. ");
INSERT INTO hincv_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","किंतु छाती और दायीं जांघ को अहरोन ने लहराने की बलि के रूप याहवेह के सामने प्रस्तुत किया; ठीक जैसा मोशेह ने आदेश दिया था. ");
INSERT INTO hincv_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","इसके बाद अहरोन ने प्रजा की ओर अपने हाथ उठाकर उनके लिए आशीष वचन बोले और पापबलि, होमबलि और मेल बलि भेंट करने के बाद नीचे उतर आए. ");
INSERT INTO hincv_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","मोशेह और अहरोन मिलनवाले तंबू में चले गए, और जब उन्होंने मिलनवाले तंबू से बाहर आकर प्रजा के लिए आशीष वचन बोले, तो याहवेह का प्रताप सारी प्रजा को दिखाई दिया. ");
INSERT INTO hincv_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","तब याहवेह की उपस्थिति की अग्नि ने प्रकट होकर होमबलि और वेदी पर की चर्बी के भागों को भस्म कर दिया. यह देख सारी प्रजा जय जयकार के नारे के साथ भूमि की ओर नतमस्तक हो गई. ");
INSERT INTO hincv_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","अहरोन के पुत्र नादाब और अबीहू ने अपने-अपने धूपदान लिए और उनमें अग्नि रखने के बाद लोबान भी रखा. इस प्रकार उन्होंने याहवेह के सामने बिना आज्ञा की अपवित्र अग्नि भेंट की; याहवेह की ओर से इसका आदेश न था. ");
INSERT INTO hincv_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","याहवेह की उपस्थिति से अग्नि निकलकर उन्हें भस्म कर दिया, और याहवेह के सामने ही उनकी मृत्यु हो गई. ");
INSERT INTO hincv_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","मोशेह ने अहरोन से कहा, “याहवेह के यही विचार थे, “ ‘उनके द्वारा, जो मेरे निकट आते हैं, मैं पवित्र ठहराया जाऊं, तथा सारी प्रजा के सामने मेरी महिमा हो.’ ” इस पर अहरोन शांत ही रहे. ");
INSERT INTO hincv_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","मोशेह ने अहरोन के चाचा उज्ज़िएल के पुत्र मिषाएल और एलज़ाफन को भी बुलाकर उन्हें यह आदेश दिया, “निकट आ जाओ और अपने भाइयों के लाश पवित्र स्थान के सामने से हटा लो और छावनी के बाहर ले जाओ.” ");
INSERT INTO hincv_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","तब वे निकट आए और लाशों को उनके अंगरखों सहित छावनी से बाहर ले गए, ठीक जैसा मोशेह ने आदेश दिया था. ");
INSERT INTO hincv_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","इसके बाद मोशेह ने अहरोन और उनके पुत्र एलिएज़र और इथामार को यह आदेश दिया, “अपने सिर के बालों को न मुंडाओ और न ही अपने वस्त्र फाड़ो, ऐसा न हो कि तुम्हारी मृत्यु हो जाए और याहवेह का क्रोध सारी सभा पर भड़क उठे. केवल तुम्हारे भाई अर्थात् इस्राएल की सारी प्रजा याहवेह के द्वारा लगाई हुई इस आग के लिए विलाप करे. ");
INSERT INTO hincv_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","तुम तो मिलनवाले तंबू के द्वार से बाहर भी न जाना, अन्यथा तुम्हारी भी मृत्यु हो जाएगी, क्योंकि तुम पर याहवेह के तेल का अभिषेक है.” तब उन्होंने मोशेह के आदेश के अनुसार ही किया. ");
INSERT INTO hincv_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","इसके बाद याहवेह ने अहरोन को यह आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“जब तुम मिलनवाले तंबू में प्रवेश करो, तो न तो तुम और न ही तुम्हारे पुत्र दाखरस अथवा दाखमधु का उपभोग करें, कि तुम्हारी मृत्यु न हो जाए. यह तुम्हारी आनेवाली सारी पीढ़ियों के लिए हमेशा के लिए विधि है, ");
INSERT INTO hincv_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","कि तुम पवित्र और अपवित्र के बीच, शुद्ध और अशुद्ध के बीच भेद कर सको. ");
INSERT INTO hincv_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","इस्राएल की प्रजा को उन सारी विधियों की शिक्षा देनी अनिवार्य है, जिनको याहवेह ने तुम्हें मोशेह के द्वारा दिया है.” ");
INSERT INTO hincv_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","फिर मोशेह ने अहरोन और उनके दोनों बचे हुए पुत्रों, एलिएज़र और इथामार को यह आदेश दिया, “याहवेह को अग्नि में अर्पित अन्‍नबलि में से शेष रह गए भाग, जो खमीर रहित है, उसको लेकर वेदी के निकट ही खाओ, क्योंकि यह परम पवित्र है. ");
INSERT INTO hincv_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","तुम इसको पवित्र स्थान में ही खाना, क्योंकि यह याहवेह को अर्पित बलि में से तुम्हारा और तुम्हारे पुत्रों के लिए निर्धारित भाग है, क्योंकि मुझे ऐसा ही आदेश दिया गया है. ");
INSERT INTO hincv_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","किंतु तुम तथा तुम्हारी सन्तति लहराने की बलि स्वरूप भेंट, छाती और जांघ को किसी स्वच्छ स्थान में खा सकते हो; क्योंकि यह इस्राएल की प्रजा की मेल बलियों में से तुम्हारे और तुम्हारे पुत्रों एवं पुत्रियों के लिए निर्धारित भाग के रूप में तुम्हें दिया गया है. ");
INSERT INTO hincv_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","वे अग्निबलि के लिए निर्धारित चर्बी के भाग के साथ जांघ को ऊंचा उठाते, और छाती को लहराते हुए याहवेह के सामने लहराने की बलि के रूप में लाएंगे; यह तुम्हारे और तुम्हारे पुत्रों के लिए स्थायी भाग है, ठीक जैसा आदेश याहवेह ने दिया था वैसा ही.” ");
INSERT INTO hincv_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","किंतु मोशेह ने पापबलि के लिए निर्धारित बकरे के विषय में खोजबीन की, तो मालूम हुआ कि उसको तो जलाया जा चुका है! इसलिये मोशेह अहरोन के बचे हुए पुत्रों एलिएज़र तथा इथामार पर क्रोधित हो गए. मोशेह ने उनसे यह प्रश्न किया, ");
INSERT INTO hincv_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“तुमने पापबलि के पशु को पवित्र स्थान में क्यों नहीं खाया? क्योंकि यह तो परम पवित्र है, तथा याहवेह ने यह तुम्हें प्रजा के दोष अपने ऊपर उठाकर और याहवेह के सामने उनके लिए प्रायश्चित पूरा करने के लिए दिया था. ");
INSERT INTO hincv_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","इसका तो रक्त तक पवित्र स्थान के भीतरी कक्ष में नहीं लाया गया, ज़रूरी था कि तुम इसको पवित्र स्थान में खाते; ठीक जैसा आदेश मैंने दिया था.” ");
INSERT INTO hincv_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","किंतु अहरोन ने मोशेह को उत्तर दिया, “सुनिए, आज ही उन्होंने याहवेह के सामने अपनी पापबलि और होमबलि चढ़ाई है, फिर भी मेरे साथ यह सब घटित हो गया है! यदि आज मैं पापबलि के पशु को खा लेता, तो क्या यह याहवेह की दृष्टि में भला होता?” ");
INSERT INTO hincv_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","जब मोशेह ने यह सुना, तो यह उन्हें सही ही जान पड़ा. ");
INSERT INTO hincv_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","याहवेह ने मोशेह और अहरोन को आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“इस्राएल की प्रजा को यह आदेश दो, ‘पृथ्वी पर के सारे पशुओं में से ");
INSERT INTO hincv_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","कोई भी पशु, जिसके खुर अलग हैं, जिसके खुर फटे हों और वह पागुर करता है, तुम्हारे लिए भोज्य है. ");
INSERT INTO hincv_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘परंतु वे पशु, जो पागुर करते हैं अथवा जिनके खुर चिरे हैं, उनमें से ये पशु तुम्हारे खाने योग्य नहीं हैं: ऊंट, क्योंकि यह पागुर तो करता है, किंतु इसके खुर चिरे नहीं, यह तुम्हारे लिए अशुद्ध है; ");
INSERT INTO hincv_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","इसी प्रकार चट्टानी बिज्जू क्योंकि यद्यपि यह पागुर करता है, परंतु इसके खुर चिरे नहीं होते, यह तुम्हारे लिए अशुद्ध है; ");
INSERT INTO hincv_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","इसी प्रकार खरगोश भी, यह पागुर तो करता है, परंतु इसके खुर चिरे नहीं होते, यह तुम्हारे लिए अशुद्ध है, ");
INSERT INTO hincv_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","और सूअर क्योंकि यद्यपि इसके खुर चिरे अर्थात् इसके खुर दो भागों में तो हैं, किंतु यह पागुर नहीं करता; तब यह तुम्हारे लिए अशुद्ध है. ");
INSERT INTO hincv_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","तुम्हें न तो उनके मांस को खाना है और न ही उनके शवों का स्पर्श; वे तुम्हारे लिए अशुद्ध हैं. ");
INSERT INTO hincv_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘तुम इन जलचरों को खा सकते हो: समुद्र अथवा नदियों के वे सारे जलचर जिनके पक्ष और शल्क हैं, तुम उनको खा सकते हो. ");
INSERT INTO hincv_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","किंतु समुद्र और नदियों के वे जलचर, अर्थात् जल के वे जंतु, जो समूहों में रहते हैं और जल के समस्त प्राणी, जिनके न तो पंख हैं और न छिलके, वे तुम्हारे लिए घृणित हैं, ");
INSERT INTO hincv_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","और क्योंकि वे तुम्हारे लिए घृणित हैं, तुम उनके मांस को खा नहीं सकते और उनके शव तुम्हारे लिए घृणित वस्तु हों. ");
INSERT INTO hincv_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","जल के कोई भी जीव, जिसके पक्ष और शल्क नहीं हैं, वह तुम्हारे लिए घृणित है. ");
INSERT INTO hincv_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘पक्षियों में से तुम्हारे लिए घृणित ये हैं; और जिनको खाना मना है; वे ये है: गरुड़, गिद्ध, काला गिद्ध, ");
INSERT INTO hincv_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","लाल चील और काली चील और समस्त प्रकार की चीलें, ");
INSERT INTO hincv_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","समस्त प्रकार के कौवे, ");
INSERT INTO hincv_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","शुतुरमुर्ग, उल्लू, सागर काक और शिकारे की सभी प्रजातियां, ");
INSERT INTO hincv_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","छोटी प्रजाति के उल्लू, जलकौए और बड़ी प्रजाति के उल्लू, ");
INSERT INTO hincv_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","बख़ारी उल्लू, जल मुर्गी और शवभक्षी गिद्ध, ");
INSERT INTO hincv_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","छोटा गरुड़, सभी प्रकार के बगुले, टिटिहरी और चमगादड़. ");
INSERT INTO hincv_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘सभी प्रकार के पंख वाले कीड़े, जो अपने चारों पैरों पर चलते हैं, तुम्हारे लिए घृणित हैं. ");
INSERT INTO hincv_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","फिर भी वे उड़ते हुए कीड़े, जो अपने चारों पैरों पर चलते हैं, तथा जिनके पैरों के ऊपर एक मुड़ी हुई टांग होती है, जिसके बल पर वे भूमि पर कूदते हैं, उनको तुम खा सकते हो. ");
INSERT INTO hincv_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","तुम उनमें से इनको खा सकते हो: सभी प्रकार की टिड्डियां, सभी प्रकार के पतंगे, सभी प्रकार के झींगुर और सभी प्रकार के टिड्डे. ");
INSERT INTO hincv_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","किंतु सभी प्रकार के उड़ते हुए कीड़े, जो चार पैरों पर चलते हैं, वे तुम्हारे लिए घृणित हैं. ");
INSERT INTO hincv_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘इन सभी जीवों के कारण भी तुम अशुद्ध हो जाओगे; जो कोई इनके शव को छू लेगा, वह संध्या तक अशुद्ध रहेगा, ");
INSERT INTO hincv_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","और जो कोई इनके शव को हटाता है, वह अपने वस्त्रों को धो डाले, वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘उन पशुओं के विषय में, जिनके खुर चिरे तो हैं किंतु पूरी तरह दो भागों में नहीं हैं, और पागुर भी नहीं करते, वे तुम्हारे लिए अशुद्ध हैं. जो कोई उनको छू लेगा, वह अशुद्ध हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","सभी चौपायों में वे प्राणी, जो अपने पंजों पर चलते हैं, तुम्हारे लिए अशुद्ध हैं, जो कोई उनके शव को छू लेगा, वह शाम तक अशुद्ध रहेगा, ");
INSERT INTO hincv_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","और जो कोई इनके शव को हटाता है, वह अपने वस्त्रों को धो ले. वह शाम तक अशुद्ध रहेगा; वे पशु तुम्हारे लिए अशुद्ध हैं. ");
INSERT INTO hincv_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘भूमि पर जो जंतु रेंगते हैं, वे तुम्हारे लिए अशुद्ध हैं. वे ये है: छछूंदर, चूहा, सभी प्रकार की गोह, ");
INSERT INTO hincv_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","छिपकली, मगरमच्छ, टिकटिक, साण्डा और गिरगिट. ");
INSERT INTO hincv_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","वे जंतु, जो रेंगते हैं, इनमें से वे सभी तुम्हारे लिए अशुद्ध हैं. जो कोई इनके शव को छू लेता है, वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","इनमें से उनका शव यदि किसी वस्तु पर गिर जाता है, तो वह वस्तु अशुद्ध हो जाएगी, चाहे वह लकड़ी की हो अथवा वस्त्र, खाल अथवा टाट की और किसी भी कार्य में इस्तेमाल की जाती हो. इसे जल में रख देना और शाम तक यह अशुद्ध रहे, इसके बाद यह वस्तु शुद्ध मानी जाए. ");
INSERT INTO hincv_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","यदि किसी मिट्टी के पात्र में इन जंतुओं का शव गिर जाता है, उस पात्र में जो कुछ भी हो, वह अशुद्ध हो जाएगा. उस पात्र को तोड़ दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","यदि इस पात्र का जल किसी भी खाने की वस्तु पर गिर जाए, तो वह खाना अशुद्ध माना जाएगा, और इसी प्रकार यदि यह जल किसी पीने के पदार्थ पर गिर जाए, तो वह पीने का पदार्थ अशुद्ध माना जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","कोई भी वस्तु, जिस पर इन जंतुओं के शव का भाग गिर जाए, वह वस्तु अशुद्ध मानी जाएगी; चाहे वह कोई भट्टी हो अथवा चूल्हा, इसे चूर-चूर कर दिया जाए; वे अशुद्ध हैं, और तुम्हारे लिए अशुद्ध बनी रहेंगी. ");
INSERT INTO hincv_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","फिर भी झरना अथवा जल कुंड, जहां जल इकट्ठा किया जाता है, वह तो शुद्ध रहेगा, किंतु जो कोई इनके शव को छू लेगा, वह अशुद्ध होगा. ");
INSERT INTO hincv_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","जिस बीज को बोया जाना है, यदि इन जंतुओं के शव का कोई भाग उन बीजों में गिर जाता है, तो उस बीज को स्वच्छ ही माना जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","किंतु यदि उन बीजों पर जल डाला गया है और इन जंतुओं के शव का कोई भाग उस पर गिर जाता है, तो वे बीज तुम्हारे लिए अशुद्ध होंगे. ");
INSERT INTO hincv_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘यदि उन पशुओं में से, जो तुम्हारे लिए खाने योग्य हैं, किसी पशु की मृत्यु हो जाए और कोई उसके शव को छू ले, तो वह व्यक्ति शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","जो इस पशु के शव में से कुछ भाग को खा लेता है, वह व्यक्ति भी अपने वस्त्रों को धो डाले और वह शाम तक अशुद्ध रहेगा. जो इसके शव को हटाए, वह व्यक्ति भी अपने वस्त्रों को धो डाले और वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘हर एक जंतु, जो भूमि पर रेंगता है, वह तुम्हारे लिए घृणित है और उसको खाया न जाए. ");
INSERT INTO hincv_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","वे जंतु, जो भूमि पर रेंगते हैं, उसमें से हर एक जो अपने पेट पर रेंगता है, जो चार पैरों पर चलता है और जो बहुत पैर वाले हैं, तुम उनको न खाना, क्योंकि वे घृणित हैं. ");
INSERT INTO hincv_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","कोई भी जंतु, जो रेंगता है, उसके द्वारा तुम स्वयं को घृणित न करना और न ही स्वयं को अशुद्ध करना, जिससे कि तुम अशुद्ध हो जाओ. ");
INSERT INTO hincv_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","क्योंकि मैं वही याहवेह, तुम्हारा परमेश्वर हूं, इसलिये स्वयं को शुद्ध करो और पवित्र बनो, क्योंकि मैं पवित्र हूं. उन जंतुओं के द्वारा स्वयं को अशुद्ध न करना, जो भूमि पर रेंगते हैं. ");
INSERT INTO hincv_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","क्योंकि मैं ही याहवेह हूं, जिसने तुम्हें मिस्र देश से इसलिये निकाला, कि तुम्हारा परमेश्वर हो जाऊं; इसलिये ज़रूरी है, कि तुम पवित्र बनो, क्योंकि मैं पवित्र हूं. ");
INSERT INTO hincv_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘पशुओं तथा पक्षियों और हर एक प्राणी, जो जल में हैं तथा जो भूमि पर रेंगते हैं, उनके लिए यही विधि है, ");
INSERT INTO hincv_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","जिससे शुद्ध अथवा अशुद्ध और खाने तथा न खाने की वस्तुओं में भेद किया जा सके.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","याहवेह ने मोशेह को कहा, ");
INSERT INTO hincv_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“इस्राएल की प्रजा को यह आदेश दो: ‘जब कोई स्त्री पुत्र को जन्म दे, तो वह सात दिन के लिए अशुद्ध रहेगी, जैसे ऋतुस्राव में अशुद्ध रहती है. ");
INSERT INTO hincv_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","आठवें दिन उस बालक के खाल का ख़तना कर दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","वह स्त्री रक्तस्राव के नियत तैंतीस दिन तक शुद्ध होने की क्रिया में रहेगी, जब तक उसके शुद्ध होने के दिन पूरे न हो जाएं, वह न तो किसी पवित्र वस्तु को छुएगी और न ही पवित्र स्थान में प्रवेश करेगी. ");
INSERT INTO hincv_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","किंतु यदि वह पुत्री को जन्म दे, तो वह दो सप्‍ताह तक अशुद्ध रहेगी, जैसे वह ऋतुस्राव में होती है. वह स्त्री रक्तस्राव के नियत छियासठ दिन तक शुद्ध होने की क्रिया में रहेगी. ");
INSERT INTO hincv_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘जब उस स्त्री की शुद्ध होने की क्रिया पूर्ण हो जाए, चाहे वह पुत्र के लिए हो अथवा पुत्री के लिए, वह मिलनवाले तंबू के द्वार पर पुरोहित के सामने होमबलि के लिए एक वर्ष का मेमना तथा पापबलि के लिए एक कबूतर का बच्चा अथवा एक कपोत का बच्चा लेकर आए. ");
INSERT INTO hincv_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","तब पुरोहित इसे उस स्त्री के प्रायश्चित्त पूरा करने के लिए याहवेह को भेंट करे. और वह अपने रक्तस्राव से शुद्ध हो जाएगी. “ ‘यह विधि हर एक प्रसूता के लिए है, चाहे वह पुत्र को जन्मे अथवा पुत्री को. ");
INSERT INTO hincv_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","किंतु यदि वह स्त्री एक मेमना खरीदने में असमर्थ है, तो वह दो कपोत अथवा दो कबूतर के बच्‍चे लेकर आए; एक होमबलि के लिए और अन्य पापबलि के लिए. इस प्रकार पुरोहित उस स्त्री के लिए प्रायश्चित्त पूरा करे और वह स्त्री पवित्र हो जाएगी.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","याहवेह ने मोशेह और अहरोन को यह आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“यदि किसी व्यक्ति की त्वचा पर सूजन, चकत्ते अथवा कोई चमकीला धब्बा हो, और यदि यह उसकी त्वचा पर कोढ़ का संक्रमण बन जाए, तब उस व्यक्ति को पुरोहित अहरोन अथवा उनके किसी पुरोहित पुत्र के सामने लाया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","पुरोहित उस व्यक्ति की त्वचा पर के धब्बे का निरीक्षण करेगा और यदि उस संक्रमित स्थान के रोएं सफेद हो गए हों, और संक्रमण त्वचा से गहरा ज्ञात होता हो, तो यह निश्चित ही कोढ़ का संक्रमण है. फिर जब पुरोहित उस व्यक्ति का निरीक्षण पूरा कर ले, तब उसे अशुद्ध घोषित कर दे. ");
INSERT INTO hincv_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","यदि त्वचा पर का धब्बा सफेद तो है, किंतु संक्रमण त्वचा से गहरा मालूम नहीं होता है, और इस स्थान के रोएं भी सफेद नहीं हुए हैं, तो पुरोहित उस संक्रमित व्यक्ति को सात दिन के लिए अलग रखे. ");
INSERT INTO hincv_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","सातवें दिन पुरोहित उस व्यक्ति का निरीक्षण करे और यदि उसे प्रतीत हो कि संक्रमण तो ज्यों का त्यों है, किंतु वह त्वचा में फैला नहीं है, तो पुरोहित उस व्यक्ति को और सात दिन के लिए अलग रखे. ");
INSERT INTO hincv_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","सातवें दिन पुरोहित दोबारा उस व्यक्ति का निरीक्षण करे; यदि संक्रमित स्थान का सुधार होने के कारण उसका रंग हल्का हो गया है, और वह त्वचा पर नहीं फैला है; तो पुरोहित उसे शुद्ध घोषित कर दे; यह एक चकत्ते मात्र है. वह व्यक्ति अपने वस्त्र धो ले और शुद्ध हो जाए. ");
INSERT INTO hincv_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","किंतु यदि पुरोहित के सामने शुद्ध प्रमाणित होने के बाद वह धब्बा त्वचा पर फैलने लगे, तो वह व्यक्ति स्वयं को दोबारा पुरोहित के सामने प्रस्तुत करे. ");
INSERT INTO hincv_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","पुरोहित इसका निरीक्षण करे और यदि उसे यह जान पड़े कि त्वचा पर धब्बा फैल रहा है, तो पुरोहित उस व्यक्ति को अशुद्ध घोषित कर दे; यह कोढ़ का रोग है. ");
INSERT INTO hincv_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“यदि कोढ़ का संक्रमण किसी पुरुष पर है, तो उसे पुरोहित के सामने लाया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","पुरोहित उसका निरीक्षण करे. यदि उसकी त्वचा में सफेद रंग की सूजन है और उसके उस स्थान के रोएं भी सफेद हो गए हैं तथा सूजन में खुला घाव है, ");
INSERT INTO hincv_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","तो यह उस व्यक्ति की त्वचा पर पुराना कोढ़ का रोग है, पुरोहित उस व्यक्ति को अशुद्ध घोषित कर दे, किंतु वह उस व्यक्ति को इसलिये दूसरे लोगों से अलग न करे, कि वह अशुद्ध है. ");
INSERT INTO hincv_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“यदि कोढ़ त्वचा में और अधिक फूट जाए और कोढ़ उस व्यक्ति के सिर से लेकर पांव तक पूरी देह में फैल जाए, जहां तक पुरोहित इसको देख सके, ");
INSERT INTO hincv_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","जब पुरोहित इसको बारीकी से देख ले कि कोढ़ उस व्यक्ति के पूरे शरीर में फैल गया है, तो वह उस व्यक्ति को इस रोग से शुद्ध घोषित कर दे; क्योंकि यह पूरी तरह से सफेद रंग का हो गया है, इसलिये वह व्यक्ति शुद्ध होगा. ");
INSERT INTO hincv_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","किंतु यदि उसे त्वचा पर घाव दिखाई दें, तो वह व्यक्ति अशुद्ध होगा. ");
INSERT INTO hincv_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","पुरोहित त्वचा के उस घाव को ध्यान से देखे और उस व्यक्ति को अशुद्ध घोषित कर दे; बिना चमड़ी का मांस अशुद्ध है और यह कोढ़ का रोग है. ");
INSERT INTO hincv_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","किंतु यदि त्वचा का घाव दोबारा सफेद रंग का हो जाए, तो वह व्यक्ति पुरोहित के सामने आए, ");
INSERT INTO hincv_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","पुरोहित इसको ध्यान से देखे और यदि वह धब्बा सफेद रंग का हो गया है, तो पुरोहित उस संक्रमित व्यक्ति को शुद्ध घोषित कर दे; वह शुद्ध है. ");
INSERT INTO hincv_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“जब किसी व्यक्ति की त्वचा पर फोड़ा हो गया है और वह फोड़ा स्वस्थ हो जाए, ");
INSERT INTO hincv_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","तथा उस फोड़े के स्थान पर सफेद अथवा लालिमा युक्त सफेद रंग की सूजन हो जाए, तब पुरोहित को इसको दिखवाया जाए; ");
INSERT INTO hincv_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","पुरोहित इसको ध्यान से देखे; यदि उसे यह लगे कि यह त्वचा में फैल रहा है और इसके रोएं भी सफेद हो गए हैं, तब पुरोहित उस व्यक्ति को अशुद्ध घोषित कर दे; यह कोढ़ का संक्रमण है, जिसकी शुरुआत फोड़े से हुई है. ");
INSERT INTO hincv_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","किंतु यदि पुरोहित इसको ध्यान से देखे और पाए, कि त्वचा के रोएं सफेद नहीं हुए हैं, और यह त्वचा में फैल नहीं रहा है तथा त्वचा का रंग हल्का हो रहा है, तो पुरोहित उस व्यक्ति को सात दिन अलग रखे; ");
INSERT INTO hincv_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","यदि यह त्वचा में और अधिक फैल रहा है, तो पुरोहित उस व्यक्ति को अशुद्ध घोषित कर दे; यह एक संक्रमण है. ");
INSERT INTO hincv_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","किंतु यदि सफेद रंग का धब्बा त्वचा पर तो है, परंतु यह त्वचा में फैल नहीं रहा है, तो यह फोड़े का चिन्ह मात्र है, तब पुरोहित उस व्यक्ति को शुद्ध घोषित कर दे. ");
INSERT INTO hincv_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“यदि किसी की त्वचा अग्नि से जल गई है, और त्वचा पर घाव से एक सफेद अथवा लालिमा युक्त सफेद धब्बा हो गया है, ");
INSERT INTO hincv_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","तो पुरोहित इसको ध्यान से देखे और यदि इस धब्बे पर के रोएं सफेद हो गए हैं और संक्रमण त्वचा से गहरा मालूम होता हो, तो यह कोढ़ का रोग है. जिसकी शुरुआत जलने के घाव से हुई है, पुरोहित उस व्यक्ति को अशुद्ध घोषित कर दे; यह कोढ़ का संक्रमण है. ");
INSERT INTO hincv_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","किंतु यदि पुरोहित इसको जांचता है और यह पाता है कि उस धब्बे पर के रोएं सफेद नहीं हुए हैं और संक्रमण त्वचा से गहरा नहीं है, परंतु इसका रंग हल्का पड़ गया है, तो पुरोहित उस व्यक्ति को सात दिन अलग रखे. ");
INSERT INTO hincv_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","सातवें दिन पुरोहित उसको दोबारा जांचे. यदि यह त्वचा में फैल रहा है, तो पुरोहित उस व्यक्ति को अशुद्ध घोषित कर दे; यह कोढ़ का संक्रमण है. ");
INSERT INTO hincv_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","किंतु यदि धब्बा तो त्वचा पर ज्यों का त्यों है, परंतु वह त्वचा में फैला नहीं हैं परंतु उसका रंग हल्का पड़ गया है, तो यह जलने के घाव से उत्पन्‍न सूजन है; पुरोहित उस व्यक्ति को तब शुद्ध घोषित कर दे, क्योंकि यह तो जलने से उत्पन्‍न हुआ चिन्ह मात्र है. ");
INSERT INTO hincv_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“यदि किसी पुरुष अथवा महिला के सिर या दाढ़ी पर रोग का संक्रमण हो, ");
INSERT INTO hincv_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","तो पुरोहित इसका निरीक्षण करे और यदि संक्रमण त्वचा में गहरा मालूम हो और उस स्थान के रोम महीन भूरे रंग के हो गए हों, तो पुरोहित उसे अशुद्ध घोषित कर दे, यह सेहुंआ है, सिर एवं दाढ़ी का कोढ़. ");
INSERT INTO hincv_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","किंतु यदि पुरोहित इस घाव के संक्रमण की जांच करे और यह पाए कि संक्रमण त्वचा से गहरा नहीं है और न ही उस स्थान में काले रोएं हैं, तो पुरोहित उस व्यक्ति को घाव के संक्रमण के कारण सात दिन अलग रखे. ");
INSERT INTO hincv_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","सातवें दिन पुरोहित संक्रमण की जांच करे और यदि सेहुंआ त्वचा में नहीं फैला है और उस स्थान पर भूरे रोएं भी नहीं हैं, तथा सेहुंए के कारण संक्रमण त्वचा से गहरा नहीं है, ");
INSERT INTO hincv_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","तो वह व्यक्ति अपना सिर मुंड़ा ले किंतु वह अपने सेहुंए पर उस्तरा न चलाए. तब पुरोहित उस व्यक्ति को सात दिन और अलग रखे. ");
INSERT INTO hincv_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","फिर सातवें दिन पुरोहित उस सेहुंए की जांच करे; यदि सेहुंआ त्वचा में और अधिक नहीं फैल रहा है और यह त्वचा में गहरा मालूम नहीं होता, तो पुरोहित उस व्यक्ति को शुद्ध घोषित कर दे; वह व्यक्ति अपने वस्त्रों को धोकर शुद्ध हो जाए. ");
INSERT INTO hincv_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","किंतु यदि उसके शुद्ध होने के बाद वह सेहुंआ उसकी त्वचा में और अधिक फैलता जाता है, ");
INSERT INTO hincv_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","तो पुरोहित उसकी जांच करे और यदि यह पाए कि यह त्वचा में फैल गया है, तो वह रोम के भूरे होने की प्रतीक्षा न करे; वह व्यक्ति अशुद्ध है. ");
INSERT INTO hincv_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","किंतु यदि उसकी जांच के अनुसार सेहुंए में कोई बदलाव नहीं है, किंतु उसमें काले रोएं उग आए हैं, तो वह सेहुंआ स्वस्थ हो गया है, वह व्यक्ति शुद्ध है और पुरोहित उसे शुद्ध घोषित कर दे. ");
INSERT INTO hincv_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“जब किसी पुरुष अथवा स्त्री की त्वचा पर सफेद चमकदार धब्बे हों, ");
INSERT INTO hincv_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","तो पुरोहित इसकी जांच करे और यदि त्वचा पर यह चमकदार धब्बे हल्के सफेद रंग के हों, तो यह दाद हैं, जो त्वचा में फूट निकले हैं; वह व्यक्ति शुद्ध है. ");
INSERT INTO hincv_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“यदि किसी पुरुष के बाल झड़ गए हों, तो वह गंजापन है, किंतु वह शुद्ध है. ");
INSERT INTO hincv_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","किंतु यदि उसके सिर के सामने के और सिर के दोनों ओर के बाल झड़ गए हैं और उसका माथा चंदला हो गया है, तो वह शुद्ध है. ");
INSERT INTO hincv_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","परंतु यदि उसका सिर अथवा माथा चंदला हो गया है और उस पर लालिमा युक्त सफेद रंग का संक्रमण हो गया है, तो यह कोढ़ है, जो उसके चंदूले माथे और सिर से फूट निकला है. ");
INSERT INTO hincv_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","तब पुरोहित इसकी जांच करे और यदि सिर अथवा बाल के संक्रमण की सूजन त्वचा पर कोढ़ की लालिमा युक्त सफेद रंग की सूजन के समान है, ");
INSERT INTO hincv_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","तो वह व्यक्ति कोढ़ का रोगी है, तब अशुद्ध है. निश्चित ही पुरोहित उसे अशुद्ध घोषित कर दे; क्योंकि संक्रमण उसके सिर पर हुआ है. ");
INSERT INTO hincv_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“वह व्यक्ति, जो कोढ़ के रोग से संक्रमित हुआ है, उसके वस्त्र फाड़ दिए जाएं, उसका सिर उघाड़ दिया जाए और वह अपने मुख का निचला भाग ढक कर ऊंचे स्वर में कहे, ‘अशुद्ध! अशुद्ध!’ ");
INSERT INTO hincv_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","अपने संक्रमण की पूरी अवधि में वह अशुद्धि की स्थिति में ही होगा; वह अशुद्ध है तथा अकेले में रहेगा; उसका निवास छावनी के बाहर ही होगा. ");
INSERT INTO hincv_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“यदि किसी वस्त्र में कोढ़ की फफूंदी पाई जाती है, चाहे वह वस्त्र ऊनी हो अथवा मलमल का, ");
INSERT INTO hincv_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","मलमल अथवा ऊन के ताने-बाने का हो, चमड़ा हो या चमड़े से बनी कोई वस्तु हो, ");
INSERT INTO hincv_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","यदि यह संक्रमण वस्त्र अथवा चमड़े के वस्त्र में अथवा ताने में अथवा बाने में हो, या चमड़े से बनी किसी वस्तु में हरे रंग की अथवा लालिमा हो, तो यह कोढ़ है और इसे पुरोहित को दिखाया जाना आवश्यक है. ");
INSERT INTO hincv_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","तब पुरोहित उस चिन्ह की जांच करे और इस संक्रमित वस्तु को सात दिन अलग रखे. ");
INSERT INTO hincv_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","सातवें दिन पुरोहित इस चिन्ह की दोबारा जांच करे और यदि संक्रमण वस्त्र में, ताने में अथवा बाने में अथवा चमड़े में फैल गया हो और चाहे वह चमड़ा किसी भी काम के लिए इस्तेमाल किया जाता हो, तो यह असाध्य कुष्ठ रोग का लक्षण है. यह अशुद्ध है. ");
INSERT INTO hincv_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","जिस वस्त्र, ताने-बाने, ऊन, मलमल अथवा चमड़े की किसी वस्तु में यह संक्रमण पाया जाए, तो आवश्यक है कि उसको जला दिया जाए, क्योंकि यह असाध्य कोढ़ है; आवश्यक है कि इसको अग्नि में जला दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“किंतु यदि पुरोहित इसकी जांच करे और यह पाए कि संक्रमण वस्त्र में, ताने-बाने में अथवा चमड़े की वस्तु में नहीं फैला है, ");
INSERT INTO hincv_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","तो पुरोहित उस संक्रमित वस्त्र को धोने का आदेश दे तथा और सात दिन के लिए उसे अलग कर दे. ");
INSERT INTO hincv_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","जब जिस वस्त्र में संक्रमण पाया गया है और उसको धो लिया गया है, तो पुरोहित इसकी दोबारा जांच करे और यदि इस वस्तु में मौजूद धब्बे में कोई बदलाव नहीं हुआ है और यह फैला भी नहीं है, तो यह अशुद्ध ही माना जाएगा, और आवश्यक है कि तुम अग्नि में इसको जला दे, चाहे यह फफूंद पीछे के भाग में हो अथवा आगे. ");
INSERT INTO hincv_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","यदि पुरोहित इसकी जांच करे और उसे यह मालूम हो कि धोने के बाद इसकी चमक कम नहीं हुई है, तब पुरोहित उसे उस वस्त्र या चमड़े में से फाड़कर निकाल दे; ");
INSERT INTO hincv_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","किंतु यदि यह चिन्ह वस्त्र, ताने अथवा बाने और चमड़े पर दोबारा उभर आए, तो यह उसमें फैल रहा है. आवश्यक है कि उस संक्रमित वस्तु को आग में जला दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","जब तुमने उस संक्रमित वस्त्र, ताने अथवा बाने अथवा चमड़े की वस्तु को धो दिया है, तो इसको दूसरी बार धो दिया जाए और यह शुद्ध माना जाएगा.” ");
INSERT INTO hincv_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","यह किसी कोढ़ से संक्रमित ऊन या मलमल के वस्त्र, ताने अथवा बाने अथवा चमड़े की किसी वस्तु को शुद्ध अथवा अशुद्ध घोषित करने की विधि है. ");
INSERT INTO hincv_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","याहवेह ने मोशेह को यह आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“किसी कोढ़ी के शुद्ध हो जाने की पुष्टि की विधि यह है: जब उसे पुरोहित के सामने लाया जाए, ");
INSERT INTO hincv_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","पुरोहित छावनी के बाहर जाकर इसकी जांच करे और यदि उस कोढ़ी की व्याधि स्वस्थ हो गयी है, ");
INSERT INTO hincv_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","तब पुरोहित उस व्यक्ति के लिए, जिसको शुद्ध किया जाना है, दो जीवित शुद्ध पक्षी, देवदार की लकड़ी, जूफ़ा और लाल डोरी लाने का आदेश दे. ");
INSERT INTO hincv_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","फिर पुरोहित बहते हुए जल पर मिट्टी के एक पात्र में एक पक्षी को बलि करने का आदेश भी दे. ");
INSERT INTO hincv_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","इसके बाद वह उस जीवित पक्षी को देवदार की लकड़ी, लाल डोरी और जूफ़ा के साथ लेकर उन्हें, तथा उस जीवित पक्षी को उस पक्षी के लहू में डूबा दे, जिसे बहते हुए जल पर बलि किया गया था. ");
INSERT INTO hincv_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","पुरोहित इसे सात बार उस व्यक्ति पर छिड़क दे, जिसे कोढ़ से शुद्ध किया जा रहा है. फिर पुरोहित उस व्यक्ति को शुद्ध घोषित कर दे और उस जीवित पक्षी को खुले मैदान में छोड़ दे. ");
INSERT INTO hincv_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“फिर वह व्यक्ति जिसे शुद्ध किया जा रहा है, अपने वस्त्रों को धो डाले, अपने सारे बाल मुंडवा ले और स्‍नान करके शुद्ध हो जाए. इसके बाद वह छावनी में तो प्रवेश कर सकता है किंतु सात दिन तक वह अपने घर से बाहर ही निवास करे. ");
INSERT INTO hincv_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","सातवें दिन वह अपने सिर के बाल, दाढ़ी तथा भौंहें, और हां, अपने समस्त बाल मुंडवा ले; अपने वस्त्रों को धो डाले और स्‍नान कर स्वच्छ हो जाए. ");
INSERT INTO hincv_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“आठवें दिन वह एक वर्षीय दो निर्दोष नर मेमने, एक वर्षीय निर्दोष मादा भेड़, अन्‍नबलि के लिए तेल मिला हुआ पांच किलो मैदा और एक तिहाई लीटर तेल ले; ");
INSERT INTO hincv_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","फिर जो पुरोहित उस व्यक्ति को शुद्ध घोषित कर रहा है, वह मिलनवाले तंबू के प्रवेश स्थल पर उस व्यक्ति और इन वस्तुओं को याहवेह के सामने भेंट करे. ");
INSERT INTO hincv_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“फिर पुरोहित एक नर मेमने और एक तिहाई लीटर तेल को दोष बलि स्वरूप लेकर लहराने की बलि के रूप में याहवेह के सामने भेंट करे. ");
INSERT INTO hincv_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","इसके बाद पुरोहित उस नर मेमने का पवित्र स्थान के उस स्थान में वध करे, जहां पापबलि और होमबलि वध की जाती हैं; क्योंकि दोष बलि, पापबलि के समान पुरोहित का निर्धारित अंश है; यह परम पवित्र है. ");
INSERT INTO hincv_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","पुरोहित उस दोष बलि के रक्त का कुछ भाग लेकर उसे उस व्यक्ति के दाएं कान के सिरे पर, दाएं हाथ के अंगूठे और दाएं पांव के अंगूठे पर लगा दे, जिसको शुद्ध किया जा रहा है. ");
INSERT INTO hincv_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","इसके बाद पुरोहित उस एक तिहाई तेल में से कुछ भाग लेकर उसे अपने बायीं हथेली पर उंडेल दे; ");
INSERT INTO hincv_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","फिर पुरोहित अपनी बायीं हथेली में रखे बचे हुए तेल में अपने दाएं हाथ की उंगली डुबाकर याहवेह के सामने उस तेल में से कुछ तेल को सात बार छिड़क दे. ");
INSERT INTO hincv_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","अब जो तेल उसकी हथेली में बचा रह गया है, पुरोहित शुद्ध होनेवाले व्यक्ति के दाएं कान के सिरे पर, दाएं हाथ के अंगूठे और दाएं पांव के अंगूठे पर लगा दे, जिन पर दोष बलि का रक्त लगा हुआ है; ");
INSERT INTO hincv_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","जबकि पुरोहित की हथेली में रखे बचे हुए तेल को पुरोहित उस व्यक्ति के सिर पर भी लगा दे, जिसे शुद्ध किया जा रहा है. फिर पुरोहित उस व्यक्ति की ओर से याहवेह के सामने प्रायश्चित करे. ");
INSERT INTO hincv_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“इसके बाद पुरोहित पापबलि भेंट करे, और उस व्यक्ति के लिए प्रायश्चित करे, जिसे उसकी अशुद्धता से परिशोधन किया जा रहा है. यह सब करने के बाद वह होमबलि पशु का वध कर दे. ");
INSERT INTO hincv_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","पुरोहित उस होमबलि एवं अन्‍नबलि को वेदी पर भेंट कर दे. इस प्रकार पुरोहित उस व्यक्ति के लिए प्रायश्चित करे, और वह व्यक्ति शुद्ध हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“किंतु यदि वह व्यक्ति दरिद्र और लाने के लायक न हो, तो वह अपने लिए प्रायश्चित के लिए, हिलाने की बलि के रूप में भेंट दोष बलि के लिए एक नर मेमना और अन्‍नबलि के लिए तेल मिला हुआ डेढ़ किलो मैदा और एक तिहाई लीटर तेल, ");
INSERT INTO hincv_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","दो कबूतर अथवा दो कबूतर के बच्‍चे; एक पापबलि के लिए तथा एक होमबलि के लिए, इनमें से वह जो कुछ भी देने में समर्थ हो, ले लें. ");
INSERT INTO hincv_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“आठवें दिन अपने शुद्ध होने के लिए वह इन्हें मिलनवाले तंबू के द्वार पर याहवेह के सामने पुरोहित के पास लेकर आए. ");
INSERT INTO hincv_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","पुरोहित दोष बलि के इस मेमने और एक तिहाई लीटर तेल को ले और याहवेह के सामने लहराने की बलि के रूप में भेंट करे. ");
INSERT INTO hincv_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","फिर पुरोहित दोष बलि के इस मेमने का वध करे; पुरोहित इस दोष बलि के लहू में से कुछ लहू को लेकर उस व्यक्ति के दाएं कान के सिरे पर, दाएं हाथ के अंगूठे और दाएं पांव के अंगूठे पर लगा दे, जिसको शुद्ध किया जाना है. ");
INSERT INTO hincv_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","पुरोहित अपनी बायीं हथेली में कुछ तेल उण्डेले; ");
INSERT INTO hincv_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","और अपनी दाएं हाथ की उंगली से अपनी बायीं हथेली में रखे तेल में से कुछ तेल को सात बार याहवेह के सामने छिड़के. ");
INSERT INTO hincv_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","अब पुरोहित जो तेल उसकी हथेली में बचा रह गया है, उससे कुछ तेल जिस व्यक्ति को शुद्ध किया जा रहा है उसके दाएं कान के सिरे पर लगाएगा, कुछ तेल व्यक्ति के दाएं हाथ के अंगूठे और उसके दाएं पैर के अंगूठे पर लगाएगा. दोष बलि के खून लगे स्थान पर ही पुरोहित तेल लगाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","पुरोहित की हथेली में रखे बचे हुए तेल को पुरोहित उस व्यक्ति के सिर पर लगा दे, जिसको शुद्ध किया जा रहा है कि पुरोहित उस व्यक्ति की ओर से याहवेह के सामने प्रायश्चित करे. ");
INSERT INTO hincv_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","इसके बाद पुरोहित एक कबूतर अथवा एक युवा कबूतर, जो भी वह व्यक्ति देने में समर्थ हो, भेंट करे; ");
INSERT INTO hincv_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","अन्‍नबलि के साथ, पापबलि के लिए एक तथा होमबलि के लिए एक. फिर पुरोहित उस व्यक्ति की ओर से याहवेह के सामने प्रायश्चित करे, जिसको शुद्ध किया जाना है. ");
INSERT INTO hincv_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","“यह उस व्यक्ति के लिए एक विधि है, जिसमें कोढ़ रोग का संक्रमण है और जिसके अपने शुद्ध होने की आवश्यकताओं के लिए साधन सीमित हैं.” ");
INSERT INTO hincv_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","फिर याहवेह ने मोशेह और अहरोन को यह आदेश दिया ");
INSERT INTO hincv_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“जब तुम कनान देश में प्रवेश करो, जिसका अधिकारी मैंने तुम्हें बनाया है, तुम्हारे आधिपत्य देश के एक आवास में कोढ़ रोग की फफूंदी मैं लगा दूंगा, ");
INSERT INTO hincv_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","तब वह गृहस्वामी पुरोहित के पास आकर यह सूचना देगा, ‘मुझे अपने घर में कोढ़ रोग के समान एक चिन्ह दिखाई दिया है.’ ");
INSERT INTO hincv_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","इससे पहले कि पुरोहित उस घर में जाकर उस चिन्ह की जांच करे, वह यह आदेश दे कि वे उस घर को खाली कर दें, ऐसा न हो कि उस आवास में मौजूद सारी वस्तुएं अशुद्ध हो जाएं. उसके बाद पुरोहित उस आवास में प्रवेश कर उसकी जांच करे. ");
INSERT INTO hincv_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","वह उस चिन्ह की जांच करे और यदि घर की दीवारों पर यह चिन्ह हरी अथवा लाल सतह से नीचे दबी हुई प्रतीत हो, ");
INSERT INTO hincv_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","तो पुरोहित उस घर से बाहर निकलकर प्रवेश द्वार पर आकर उस घर को सात दिन के लिए उसे बंद कर दे. ");
INSERT INTO hincv_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","सातवें दिन पुरोहित उसको दोबारा जांचे. यदि वास्तव में वह चिन्ह घर की दीवारों में फैल गया है, ");
INSERT INTO hincv_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","तो पुरोहित उन्हें यह आदेश दे कि वे उन चिन्हयुक्त पत्थरों को निकालकर नगर से बाहर कूड़े के ढेर पर फेंक दें. ");
INSERT INTO hincv_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","इसके बाद पुरोहित उस संपूर्ण घर को भीतर से खुरचवा दे और वे उस खुरचन को नगर के बाहर अशुद्ध स्थान पर फेंक दें. ");
INSERT INTO hincv_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","फिर वे दूसरे पत्थर लेकर उन्हें निकाले गए पत्थरों के स्थान पर लगा दें और गारा लेकर उस आवास की पुनः लीपाई-पोताई कर दें. ");
INSERT INTO hincv_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“किंतु यदि उसके द्वारा पत्थरों को निकालवाए जाने, घर को खुरचे जाने तथा पुनः पलस्तर लीपे पोते जाने के बाद उस घर में वह फफूंदी फूट पड़ती है, ");
INSERT INTO hincv_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","तो पुरोहित उसमें प्रवेश कर उसकी जांच करे. यदि उसे यह प्रतीत होता है कि वास्तव में वह चिन्ह आवास में फैल गया है, तो यह उस आवास में एक असाध्य रोग है; यह अशुद्ध है. ");
INSERT INTO hincv_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","इसलिये उस आवास को ढाह दिया जाए, वह उसके पत्थर, लकड़ी और संपूर्ण पलस्तर को नगर के बाहर अशुद्ध स्थान पर ले जाए. ");
INSERT INTO hincv_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“इसके अतिरिक्त, यदि कोई व्यक्ति उस समय में उस घर में प्रवेश कर ले, जिसे पुरोहित ने बंद कर दिया था, तो वह व्यक्ति शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","इसी प्रकार जो कोई व्यक्ति उस घर में विश्राम करता है, या भोजन कर लेता है, वह भी अपने वस्त्रों को शुद्ध करे. ");
INSERT INTO hincv_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“यदि इसके विपरीत, पुरोहित उस आवास में प्रवेश कर निरीक्षण करे, और यह पाए कि उस घर की पुनः पलस्तर करने के बाद वह फफूंदी वास्तव में नहीं फैली है, तो पुरोहित उस आवास को शुद्ध घोषित कर दे, क्योंकि यह रोग उसमें पुनः प्रकट नहीं हुआ है. ");
INSERT INTO hincv_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","तब पुरोहित उस आवास को शुद्ध करने के लिए दो पक्षी, देवदार की लकड़ी, जूफ़ा और लाल डोरी लेकर, ");
INSERT INTO hincv_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","एक पक्षी को बहते हुए जल पर मिट्टी के एक पात्र में बलि करे. ");
INSERT INTO hincv_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","इसके बाद वह उस जीवित पक्षी के साथ देवदार की लकड़ी, जूफ़ा और लाल डोरी को उस बलि किए हुए पक्षी के रक्त तथा बहते हुए जल में डुबाकर उस घर पर सात बार छिड़के. ");
INSERT INTO hincv_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","इस प्रकार वह उस घर का शुद्धीकरण उस पक्षी के लहू तथा बहते हुए जल के साथ साथ देवदार की लकड़ी, जूफ़ा तथा लाल डोरी के साथ करे. ");
INSERT INTO hincv_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","फिर वह उस जीवित पक्षी को नगर के बाहर खुले मैदान में छोड़ दे. इस प्रकार वह उस घर के लिए प्रायश्चित पूरा करे और वह आवास शुद्ध हो जाएगा.” ");
INSERT INTO hincv_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","किसी भी प्रकार के कोढ़ के रोग के लिए यही विधि है; सेहुंआ के लिए, ");
INSERT INTO hincv_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","कोढ़ से संक्रमित वस्त्र अथवा घर के लिए, ");
INSERT INTO hincv_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","सूजन के लिए, पपड़ी के लिए अथवा किसी भी प्रकार के चमकदार धब्बे के लिए; ");
INSERT INTO hincv_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","उन पर यह प्रकट हो जाए कि क्या अशुद्ध है अथवा क्या शुद्ध. कोढ़ रोग के लिए यही विधि है. ");
INSERT INTO hincv_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","याहवेह ने मोशेह और अहरोन को ये आदेश दिए: ");
INSERT INTO hincv_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“इस्राएल वंशजों को यह आदेश दो, ‘यदि किसी व्यक्ति की देह से कोई स्राव हो रहा हो, वह स्राव अशुद्ध है. ");
INSERT INTO hincv_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","यह उसकी अशुद्धता ही मानी जाएगी, चाहे उसकी देह से स्राव हो रहा हो, अथवा स्राव रुक गया हो. ");
INSERT INTO hincv_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘स्रावग्रस्त व्यक्ति जिस बिछौने पर विश्राम करता है, वह बिछौना अशुद्ध हो जाता है, और हर एक वस्तु जिस पर वह बैठ जाता है, वह भी अशुद्ध हो जाती है. ");
INSERT INTO hincv_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","इसके अलावा यदि कोई व्यक्ति उसके बिछौने को छू लेता है, तो वह व्यक्ति अपने वस्त्रों को धोकर स्‍नान करे और वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","यदि कोई व्यक्ति उस वस्तु पर बैठ जाता है जिस पर वह स्रावग्रस्त व्यक्ति बैठता रहा है, तो वह अपने वस्त्रों को धोकर स्‍नान करे तथा वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘और यदि कोई व्यक्ति उस स्रावग्रस्त व्यक्ति को छू लेता है, तो वह व्यक्ति अपने वस्त्रों को धोकर स्‍नान करे, तथा वह शाम तक अशुद्ध रहे. ");
INSERT INTO hincv_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘अथवा वह स्रावग्रस्त व्यक्ति किसी शुद्ध व्यक्ति पर थूक देता है, तो वह शुद्ध व्यक्ति भी अपने वस्त्रों को धोकर स्‍नान करे तथा वह शाम तक अशुद्ध रहे. ");
INSERT INTO hincv_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘हर एक काठी, जिस पर वह सवारी करता है, वह काठी अशुद्ध हो जाती है. ");
INSERT INTO hincv_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","यदि कोई व्यक्ति उन वस्तुओं में से किसी को भी छू लेता है, जो स्रावग्रस्त व्यक्ति के नीचे रही हैं, तो वह शाम तक अशुद्ध रहेगा और जो कोई व्यक्ति उनका वहन करता है, तो वह अपने वस्त्रों को धो डाले, स्‍नान करे तथा वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘इसी प्रकार स्रावग्रस्त व्यक्ति अपने हाथों को बिना धोए यदि किसी व्यक्ति को छू लेता है, तो वह व्यक्ति अपने वस्त्रों को धोकर स्‍नान करे तथा वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘यदि स्रावग्रस्त व्यक्ति किसी मिट्टी के पात्र को छू लेता है, तो उस पात्र को तोड़ डाला जाए, किंतु यदि पात्र लकड़ी का है, तो उसे जल में धोया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘जब स्रावग्रस्त व्यक्ति अपने स्राव से शुद्ध हो गए है, तो वह अपने शुद्ध होने के लिए सात दिनों की गिनती कर ले; तब वह अपने वस्त्रों को धो डाले और बहते हुए जल में स्‍नान करे, तब वह शुद्ध हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","आठवें दिन वह अपने लिए दो कपोत अथवा कबूतर के दो बच्‍चे लेकर मिलनवाले तंबू के द्वार पर याहवेह के सामने आए और इन्हें पुरोहित को दे दे; ");
INSERT INTO hincv_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","पुरोहित इनमें से एक को पापबलि के लिए तथा दूसरे को होमबलि के लिए भेंट करे. इस प्रकार पुरोहित उसके लिए उसके स्राव के कारण याहवेह के सामने प्रायश्चित पूरा करे. ");
INSERT INTO hincv_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘यदि किसी व्यक्ति का वीर्य-उत्सर्जन हो गया है, तो वह स्‍नान के द्वारा सारे शरीर को धो डाले और वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","जहां तक वस्त्र अथवा चर्मवस्त्र का संबंध है, जिस पर वीर्य गिरा हुआ हो, उस वस्त्र को जल से धो डाला जाए तथा वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","यदि कोई पुरुष किसी स्त्री से संभोग करे और इस प्रक्रिया में उसका वीर्य-उत्सर्जन हुआ हो, तो वे दोनों स्‍नान करें-वे शाम तक अशुद्ध रहेंगे. ");
INSERT INTO hincv_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘जब किसी स्त्री से स्राव हो रहा हो, और यदि वह स्राव रक्त है, तो वह स्त्री अपनी ऋतुस्राव-अशुद्धता की अवधि में सात दिन के लिए होगी, और जो कोई उस स्त्री को छुए, वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘हर एक वह वस्तु अशुद्ध होगी जिस पर वह अपने ऋतुस्राव-अशुद्धता की अवधि में लेटती है, तथा वह वस्तु भी जिस पर वह बैठती है. ");
INSERT INTO hincv_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","जो कोई भी उसके बिछौने को छू लेता है, वह अपने वस्त्रों को धोकर स्‍नान करे, वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","जो कोई उस वस्तु को छू लेता है जिस पर वह बैठती है, तो वह अपने वस्त्रों को धो डाले तथा स्‍नान करे, वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","चाहे यह उसका बिछौना अथवा कोई भी वस्तु है जिस पर वह बैठती है, यदि कोई उसको छू लेता है, तो वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘यदि कोई पुरुष उसके साथ वास्तव में संभोग कर लेता है, और इस प्रकार उस स्त्री की ऋतुस्राव की अशुद्धता उस पुरुष पर आ जाती है, तो वह सात दिनों के लिए अशुद्ध होगा, और हर एक बिछौना जिस पर वह लेटता है, अशुद्ध हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘यदि किसी स्त्री को रक्त का स्राव उसके ऋतुस्राव-अशुद्धता की अवधि में ही नहीं बल्कि उसके अलावा भी अनेक दिनों तक होता रहे, तो वह ऋतुस्राव की अशुद्धता की अवधि के समान अपने इस अशुद्ध स्राव में भी अशुद्ध रहेगी. ");
INSERT INTO hincv_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","कोई भी वह बिछौना जिस पर वह अपने स्राव के पूरे दिनों में लेटती है, वह उसके ऋतुस्राव के अशुद्ध बिछौने के समान होगा और हर एक वह वस्तु जिस पर वह बैठती है, वह उसके ऋतुस्राव के समान अशुद्ध होगी. ");
INSERT INTO hincv_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","उसी प्रकार जो कोई उसको छू लेता है, वह अशुद्ध होगा और वह अपने वस्त्रों को धो डाले तथा स्‍नान करे, वह शाम तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘जब वह स्त्री अपने स्राव से शुद्ध हो जाती है, तो वह अपने शुद्ध होने के लिए सात दिनों की गिनती कर ले, उसके बाद वह शुद्ध होगी. ");
INSERT INTO hincv_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","आठवें दिन वह अपने लिए दो कपोत अथवा दो कबूतर के बच्‍चे लेकर उन्हें मिलनवाले तंबू के द्वार पर पुरोहित के सामने लाए. ");
INSERT INTO hincv_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","पुरोहित उनमें से एक को पापबलि तथा दूसरे को होमबलि के लिए भेंट करे. इस प्रकार उसके स्राव के कारण पुरोहित उसके लिए याहवेह के सामने प्रायश्चित करे.’ ");
INSERT INTO hincv_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘इस प्रकार तुम इस्राएल वंशजों को उनकी अशुद्धता से अलग रखोगे, ऐसा न हो कि वे मेरे मिलनवाले तंबू को, जो उनके बीच में है, अशुद्ध करें और उनकी अशुद्धता के कारण उनकी मृत्यु हो जाए.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","यह विधि उस व्यक्ति के लिए है, जिसका स्राव हो रहा है और जिस व्यक्ति का वीर्य-उत्सर्जन हो गया है; जिससे वह अशुद्ध हो जाता है, ");
INSERT INTO hincv_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","और उस स्त्री के लिए भी, जो अपनी ऋतुस्राव-अशुद्धता के कारण अस्वस्थ है. हां, उसके लिए, जिससे स्राव हो रहा हो, चाहे वह पुरुष हो अथवा स्त्री; अथवा उस पुरुष के लिए भी, जो उस स्त्री से संभोग कर लेता है, जो अशुद्धता की स्थिति में है. ");
INSERT INTO hincv_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","जब अहरोन के दोनों पुत्रों की मृत्यु के बाद, उनके याहवेह की उपस्थिति में प्रवेश के कारण उनकी मृत्यु हो गई थी, तब मोशेह को याहवेह का यह संदेश प्राप्‍त हुआ. ");
INSERT INTO hincv_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","याहवेह ने मोशेह से कहा, “अपने भाई अहरोन को चेता दो कि वह पर्दे के भीतर परम पवित्र स्थान में संदूक के ऊपर के करुणासन के सामने कभी भी अपनी इच्छा से प्रवेश न करे; नहीं तो उसकी मृत्यु हो जाएगी; क्योंकि मैं करुणासन पर बादलों में प्रकट हुआ करूंगा. ");
INSERT INTO hincv_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“इन निर्देशों का पूरी तरह से पालन करने के बाद ही अहरोन परम पवित्र स्थान में प्रवेश करेगा: पापबलि के लिए एक बछड़ा और होमबलि के लिए एक मेढ़ा लाना है. ");
INSERT INTO hincv_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","वह मलमल का पवित्र अंगरखा पहने, अपनी देह पर मलमल की जांघिया पहने, मलमल का कमरबंध कसे और मलमल की पगड़ी बांधे. ये पवित्र वस्त्र हैं. पुरोहित इन्हें पूर्ण स्‍नान के बाद ही पहने. ");
INSERT INTO hincv_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","वह इस्राएली सभा से पापबलि के लिए दो बकरे और होमबलि के लिए एक मेढ़ा ले. ");
INSERT INTO hincv_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“इसके बाद अहरोन उस बछड़े को पापबलि के लिए भेंट करे, जो उसके स्वयं के लिए तय की गई है कि इसके द्वारा वह स्वयं के लिए तथा अपने परिवार के लिए प्रायश्चित पूरा करे. ");
INSERT INTO hincv_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","इसके बाद वह दो बकरे ले, और उन्हें मिलनवाले तंबू के प्रवेश पर याहवेह के सामने प्रस्तुत करे. ");
INSERT INTO hincv_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","अहरोन उन दोनों बकरों के लिए पासे फेंके, एक पासा तो याहवेह के लिए तथा दूसरा अज़ाज़ेल बकरे के लिए. ");
INSERT INTO hincv_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","फिर अहरोन उस बकरे को, जिस पर याहवेह के लिए पासा पड़ा था पापबलि के रूप में भेंट कर दे. ");
INSERT INTO hincv_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","किंतु वह बकरा, जिस पर अज़ाज़ेल बकरे के लिए पासा पड़ा, वह याहवेह के सामने जीवित लाया जाए कि उस पर प्रायश्चित पूरा करके उसे निर्जन प्रदेश में अज़ाज़ेल के लिए छोड़ दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“फिर अहरोन पापबलि के बछड़े को, जो स्वयं उसके लिए तय है, भेंट करे और वह स्वयं के लिए एवं अपने परिवार के लिए प्रायश्चित पूरा करे. वह पापबलि के इस बछड़े का वध करे, जो स्वयं उसके लिए तय है. ");
INSERT INTO hincv_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","वह याहवेह के सामने वेदी पर से कोयलों से भरा हुआ धूपदान और दो मुट्ठी भर बहुत ही महीन पीसा हुआ सुगंधधूप पर्दे के अंदर लेकर आए. ");
INSERT INTO hincv_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","वह इस धूप को याहवेह के सामने आग पर डाल दे कि धुएं का बादल करुणासन को ढांक ले, जो साक्षी पट्टिया की संदूक पर है, नहीं तो उसकी मृत्यु हो जाएगी. ");
INSERT INTO hincv_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","इसके अलावा वह इस बैल का लहू लेकर उसे पूर्व दिशा की ओर करुणासन के सामने अपनी उंगली से छिड़क दे; हां, करुणासन के समक्ष इसके कुछ रक्त को अपनी उंगली से सात बार छिड़क दे. ");
INSERT INTO hincv_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“फिर अहरोन पापबलि के उस बकरे की बलि करे, जो प्रजा के लिए है और इसके लहू को पर्दे के भीतर लाकर इसके साथ वैसा ही करे, जैसा उसने बछड़े के लहू के साथ किया था; इसे करुणासन के सामने लाकर करुणासन पर छिड़क दे. ");
INSERT INTO hincv_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","वह परम पवित्र स्थान के लिए इस्राएल वंशजों की अशुद्धता तथा उनके सारे पापों के संबंध में किए गए अपराध के लिए प्रायश्चित पूरा करे, और इसी प्रकार वह मिलनवाले तंबू के लिए भी करे, जो उनकी अशुद्धताओं के बीच उनके साथ रहता है. ");
INSERT INTO hincv_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","जब वह प्रायश्चित पूरा करने के लिए परम पवित्र स्थान में जाता है, तब तक मिलनवाले तंबू में कोई भी व्यक्ति न रहने पाए, जब तक वह बाहर न आ जाए कि वह अपने लिए, अपने परिवार तथा इस्राएल की सारी सभा के लिए प्रायश्चित पूरा कर सके. ");
INSERT INTO hincv_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“फिर वह बाहर उस वेदी के पास जाए, जो याहवेह के सामने है, और इसके लिए प्रायश्चित पूरा करे. वह बछड़े का कुछ लहू और बकरे का कुछ लहू लेकर इसे वेदी के सभी सींगों पर लगा दे, ");
INSERT INTO hincv_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","तथा अपनी उंगली से इस पर सात बार लहू को छिड़क कर इसको पवित्र करे, और इस प्रकार वह इस्राएल वंशजों की अशुद्धियों की स्थिति में से इसे पवित्र करे. ");
INSERT INTO hincv_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“वह परम पवित्र स्थान, मिलनवाले तंबू तथा वेदी के लिए प्रायश्चित पूरा करने के बाद, एक जीवित बकरे को भेंट करे. ");
INSERT INTO hincv_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","अहरोन उस जीवित बकरे के सिर पर अपने दोनों हाथ रखकर इस्राएल वंशजों के सारे अधर्म के कामों और उनके सारे अपराधों, और पापों को स्वीकार करे और इन्हें इस बकरे के सिर पर लादकर इसे इस कार्य के लिए नियुक्त व्यक्ति के द्वारा निर्जन प्रदेश में छोड़ दे. ");
INSERT INTO hincv_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","यह बकरा बीहड़ जगह में उनके सारे अधर्म के कामों को उठा लेगा; वह व्यक्ति उस बकरे को निर्जन प्रदेश में छोड़कर आए. ");
INSERT INTO hincv_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“इसके बाद अहरोन मिलनवाले तंबू में आकर उन मलमल के कपड़ों को उतार दे, जो उसने परम पवित्र स्थान में प्रवेश करने के पहले पहने थे, वह उन वस्त्रों को वहीं छोड़ दे. ");
INSERT INTO hincv_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","वह पवित्र स्थान में ही स्‍नान कर अपने वस्त्र पहन ले और पवित्र स्थान से बाहर आकर अपने लिए तय होमबलि और प्रजा के लिए तय होमबलि चढ़ाकर स्वयं के लिए तथा प्रजा के लिए प्रायश्चित पूरा करे. ");
INSERT INTO hincv_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","फिर वह पापबलि की चर्बी को वेदी पर आग में जलाकर भेंट कर दे. ");
INSERT INTO hincv_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“वह व्यक्ति, जो अज़ाज़ेल को छोड़कर आया था, अपने वस्त्रों को धो डाले, स्‍नान करे; इसके बाद वह छावनी में प्रवेश करे. ");
INSERT INTO hincv_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ज़रूरी है कि पापबलि के बैल को तथा पापबलि के बकरे को, जिनका लहू परम पवित्र स्थान में प्रायश्चित पूरा करने के लिए लाया गया था, छावनी से बाहर ले जाए. वे उनकी खाल, उनके मांस और उनके गोबर को आग में जला दें. ");
INSERT INTO hincv_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","वह व्यक्ति, जो उनको जलाता है, अपने वस्त्रों को धो डाले, स्‍नान करे; इसके बाद ही छावनी में प्रवेश करे. ");
INSERT INTO hincv_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“तुम्हारे लिए सदा की विधि यह होगी: सातवें महीने में, उस महीने के दसवें दिन अपने-अपने जीव को दुःख देने के अंतर्गत तुम—स्वदेशी अथवा विदेशी जो तुम्हारे बीच में रहते हैं—कोई भी कार्य न करना; ");
INSERT INTO hincv_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","क्योंकि यही वह दिन है, जिस दिन तुम्हारे शुद्ध करने के लिए प्रायश्चित पूरा किया जाएगा, और तुम याहवेह के सामने अपने सारे पापों से शुद्ध हो जाओगे. ");
INSERT INTO hincv_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","यह तुम्हारे लिए एक विशेष विश्राम शब्बाथ होगा कि तुम अपने-अपने जीव को दुःख दो; यह एक सदा की विधि है. ");
INSERT INTO hincv_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","मलमल के पवित्र वस्त्र पहनकर प्रायश्चित प्रक्रिया वह पुरोहित पूरा करेगा, जिसे उसके पिता के स्थान पर पुरोहित सेवा के लिए संस्कृत तथा अभिषिक्त किया गया है. ");
INSERT INTO hincv_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","वह परम पवित्र स्थान के लिए, मिलनवाले तंबू के लिए और वेदी के लिए प्रायश्चित पूरा करेगा. वही पुरोहित, सभी पुरोहितों और सभा की सारी प्रजा के लिए भी प्रायश्चित पूरा करेगा. ");
INSERT INTO hincv_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“यह तुम्हारे लिए सदा की विधि होगी कि इस्राएली प्रजा के लिए उसके सभी पापों के कारण वर्ष में एक बार प्रायश्चित पूरा किया जाए.” मोशेह ने ठीक वैसा ही किया, जैसा याहवेह ने आदेश दिया था. ");
INSERT INTO hincv_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","याहवेह ने मोशेह को यह आज्ञा दी: ");
INSERT INTO hincv_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“अहरोन, उसके पुत्रों तथा इस्राएल वंशजों को यह संदेश दो, ‘यह वह आदेश है, जो याहवेह के द्वारा निकाला गया है: ");
INSERT INTO hincv_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","इस्राएल वंशजों में से कोई भी पुरुष, जो किसी बछड़े, मेमने अथवा किसी बकरे का वध छावनी के भीतर अथवा छावनी के बाहर करे, ");
INSERT INTO hincv_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","और वह इसे मिलनवाले तंबू के द्वार पर याहवेह के तंबू के सामने याहवेह के लिए बलि के रूप में भेंट करने के लिए न लाए, तो उस व्यक्ति को हत्या का आरोपी माना जाएगा. उस व्यक्ति ने लहू बहाया है और उस व्यक्ति को प्रजा से बाहर निकाल दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ऐसा करने का कारण यह है कि इस्राएल वंशज उनकी वे बलियां, जिनका बलिदान वे खुले मैदान में कर रहे थे, इन बलियों को पुरोहित के पास मिलनवाले तंबू के द्वार पर याहवेह के सामने लाकर उन्हें याहवेह को मेल बलि के रूप में भेंट करें. ");
INSERT INTO hincv_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","पुरोहित लहू को मिलनवाले तंबू के द्वार पर स्थित याहवेह की वेदी पर छिड़क दे और चर्बी को सुखद-सुगंध के रूप में आग में जलाकर याहवेह को भेंट कर दे. ");
INSERT INTO hincv_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","अब इसके बाद वे अपना बलि बकरा-देवता को भेंट न किया करें, जिनका यह काम व्यभिचार के समान था. यह उनके लिए तथा उनकी सारी पीढ़ियों के लिए सदा की एक विधि होगी.’ ");
INSERT INTO hincv_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“तुम उन्हें यह संदेश देना, ‘इस्राएल वंशजों में से, अथवा विदेशियों में से यदि कोई व्यक्ति, जो उनके बीच में रहते हैं, बलि अथवा होमबलि भेंट करें, ");
INSERT INTO hincv_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","और उसे मिलनवाले तंबू के द्वार पर याहवेह के लिए भेंट करने के लिए न लाए, तो उस व्यक्ति को भी प्रजा से बाहर निकाल दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘इस्राएल वंशजों में से अथवा विदेशियों में से कोई व्यक्ति, जो उनके बीच में रहता है, तथा लहू को खाता हो, मैं उस व्यक्ति के विरुद्ध हो जाऊंगा, जिसने लहू को खाया है, तथा उसे प्रजा से बाहर कर दूंगा, ");
INSERT INTO hincv_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","क्योंकि देह का जीवन लहू में रहता है और मैंने तुम्हें यह इसलिये दिया है कि, तुम इसके द्वारा वेदी पर प्रायश्चित पूरा कर सको.’ ");
INSERT INTO hincv_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","अतःएव, मैंने इस्राएल वंशजों को यह आदेश दिया, ‘न तुममें से कोई, और न ही कोई विदेशी, जो तुम्हारे बीच में रहता है, लहू को खाए.’ ");
INSERT INTO hincv_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“इस्राएल वंशजों में से अथवा विदेशियों में से किसी व्यक्ति के हाथ में, जो उनके बीच में रहते हैं, यदि शिकार में कोई खाने योग्य पक्षी अथवा खाने योग्य पशु आ जाए, तो वह उसके लहू को बह जाने दे, तथा इस लहू को धूलि से ढांक दे. ");
INSERT INTO hincv_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","क्योंकि सभी प्राणियों की देह का जीवन लहू में रहता है. इसलिए मैंने इस्राएल वंशजों को यह आदेश दिया है, ‘यह ज़रूरी है कि तुम किसी भी देह के लहू को न खाया करो, क्योंकि देह का जीवन लहू में ही रहता है; उसे, जो इसको खाएगा, वह बाहर कर दिया जाएगा.’ ");
INSERT INTO hincv_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘यदि कोई व्यक्ति, स्वदेशी अथवा विदेशी, उस पशु को खा ले, जिसे वन्य पशुओं द्वारा फाड़ डाला गया हो, तो वह अपने वस्त्रों को धोकर, स्‍नान करे, वह शाम तक अशुद्ध रहेगा; इसके बाद वह शुद्ध हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","किंतु यदि वह उनको न ही धोता और न ही स्‍नान करता है, तो वह अपने दोष का भार स्वयं उठाएगा.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","याहवेह ने मोशेह को यह आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“इस्राएल वंशजों को यह संदेश दो, ‘मैं याहवेह, तुम्हारा परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","तुम मिस्र देश के कार्यों के अनुसार व्यवहार नहीं करोगे, जहां तुम रहा करते थे, और न ही कनान देश के कार्यों का, जहां मैं तुम्हें लिए जा रहा हूं; तुम उनकी विधियों का पालन नहीं करोगे. ");
INSERT INTO hincv_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","तुम मेरे नियमों का पालन करना, और मेरी विधियों का पालन करते हुए उनका अनुसरण करना. मैं याहवेह, तुम्हारा परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","तुम मेरे नियमों और विधियों का पालन करोगे; जो इनका अनुसरण करेगा, वह इनके कारण जीवित रहेगा; मैं ही वह याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘तुममें से कोई भी अपने कुटुंबी से संभोग न करे; मैं ही वह याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘अपनी माता से संभोग करके तुम अपने पिता का अपमान न करना. वह तुम्हारी जन्म देनेवाली माता है; तुम उससे संभोग न करना. ");
INSERT INTO hincv_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘तुम अपने पिता की पत्नी से संभोग न करना; यह तुम्हारे पिता का अपमान होगा. ");
INSERT INTO hincv_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘तुम अपनी बहन से संभोग न करना, चाहे वह तुम्हारे पिता से पैदा हुई हो अथवा तुम्हारी माता से पैदा हुई हो, चाहे उसका पालन पोषण तुम्हारे साथ हुआ हो अथवा किसी अन्य परिवार में; तुम उनसे संभोग न करना. ");
INSERT INTO hincv_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘अपनी पोती अथवा अपनी नातिन से संभोग न करना, तुम उनसे संभोग न करना क्योंकि यह तुम्हारा स्वयं का ही अपमान होगा. ");
INSERT INTO hincv_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘तुम अपनी सौतेली माता की कन्या से संभोग न करना, तुम्हारे पिता से जन्मी कन्या से, वह तुम्हारी सौतेली बहन है, तुम उससे संभोग न करना. ");
INSERT INTO hincv_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘तुम अपने पिता की बहन से संभोग न करना; वह तुम्हारे पिता की कुटुंबी है. ");
INSERT INTO hincv_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘तुम अपनी मौसी से संभोग न करना क्योंकि वह तुम्हारी माता की कुटुंबी है. ");
INSERT INTO hincv_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘तुम अपने पिता के भाई का अपमान उसकी पत्नी से संभोग करने के द्वारा न करना, न इसका प्रयास ही करना, वह तुम्हारी चाची है. ");
INSERT INTO hincv_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘तुम अपनी बहू से संभोग न करना; वह तुम्हारे पुत्र की पत्नी है, तुम उससे संभोग न करना. ");
INSERT INTO hincv_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘तुम अपने भाई की पत्नी से संभोग न करना; यह तुम्हारे भाई का अपमान होगा. ");
INSERT INTO hincv_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘तुम किसी महिला और उसकी पुत्री से भी संभोग न करना और न ही उसके पुत्र की कन्या से और न ही उसकी पुत्री की कन्या से संभोग करना; वे कुटुंबी हैं. यह व्यभिचार है. ");
INSERT INTO hincv_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘तुम अपनी पत्नी की बहन से विवाह न करना, जब तक तुम्हारी पत्नी जीवित है, तुम उससे संभोग न करना. ");
INSERT INTO hincv_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘तुम किसी महिला के मासिक स्राव की अशुद्धता के काल में संभोग के उद्देश्य से न जाना. ");
INSERT INTO hincv_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘तुम अपने पड़ोसी की पत्नी के साथ संभोग करके उसके साथ स्वयं को भ्रष्‍ट न करना. ");
INSERT INTO hincv_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘तुम अपनी संतानों में से किसी को भी मोलेख को भेंट न करना और न ही अपने परमेश्वर के नाम को कलंकित करना; मैं ही वह याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘तुम स्त्री से संभोग करने के समान किसी पुरुष से संभोग न करना; यह एक घृणित कार्य है. ");
INSERT INTO hincv_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘तुम किसी पशु से भी संभोग करके स्वयं को भ्रष्‍ट न करना और न ही कोई स्त्री संभोग के उद्देश्य से किसी पशु के सम्मुख जाए; यह अनर्थ है. ");
INSERT INTO hincv_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘इन कार्यों में से किसी भी कार्य को करने के द्वारा तुम स्वयं को भ्रष्‍ट न करना; क्योंकि इन्हीं कार्यों के कारण सभी जनता ने, जिन्हें मैं तुम्हारे सामने से खदेड़ने पर हूं, स्वयं को भ्रष्‍ट कर लिया है. ");
INSERT INTO hincv_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","क्योंकि देश भ्रष्‍ट हो गया है, इसलिये मैं इसकी दण्डाज्ञा इस पर ले आया और देश ने इसके निवासियों को निकाल फेंका. ");
INSERT INTO hincv_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","किंतु तुम मेरी विधियों और नियमों का पालन करना और ये घृणित कार्य न करना, न तो स्वदेशी और न ही तुम्हारे बीच रह रहे विदेशी, जो तुम्हारे बीच में रहते हैं; ");
INSERT INTO hincv_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","क्योंकि तुम्हारे सामने इस देश के निवासियों ने ये समस्त घृणित कार्य किए हैं, और देश भ्रष्‍ट हो गया है; ");
INSERT INTO hincv_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ऐसा न हो कि तुम इसे भ्रष्‍ट कर दो और यह तुम्हें निकाल फेंके, जिस प्रकार इसने उस जनता को निकाल फेंका था, जो तुम्हारे सामने था. ");
INSERT INTO hincv_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘यदि कोई इन घृणित कार्यों में से कोई भी कार्य करता है, तो उन्हें जो ऐसा करते हैं, प्रजा से बाहर कर दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","तब तुम मेरे आदेश का पालन करो कि तुम किसी भी घिनौनी रीति का पालन न करो, जिनका पालन तुम्हारे सामने होता रहा था, कि तुम उनसे स्वयं को अशुद्ध न कर बैठो; मैं ही वह याहवेह तुम्हारा परमेश्वर हूं.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","याहवेह ने मोशेह को यह आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“इस्राएल वंशजों की पूरी सभा को यह आदेश दो, ‘पवित्र बनो, क्योंकि मैं याहवेह, तुम्हारा परमेश्वर पवित्र हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘तुममें से हर एक अपने माता-पिता का सम्मान करे और मेरे शब्बाथों का पालन करे; मैं याहवेह ही तुम्हारा परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘मूरतों की ओर न फिरना, और न स्वयं के लिए धातु के देवता गढ़ना; मैं याहवेह ही तुम्हारा परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘जब तुम याहवेह को मेल बलि भेंट करो, तो इसे इस रीति से भेंट करो कि वह स्वीकार किए जाओ. ");
INSERT INTO hincv_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","जिस दिन तुम इसे भेंट करो, उसी दिन तथा उसके अगले दिन इसको खाया जाए, किंतु जो तीसरे दिन तक बचा हुआ है, उसको आग में जला दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","पर तीसरे दिन तक बचा हुआ मांस को खाया जाना स्वीकार नही किया जाएगा, क्योंकि यह अशुद्ध है. ");
INSERT INTO hincv_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ऐसा हर एक व्यक्ति, जो इसको खाता है, वह अपने अधर्म का भार स्वयं उठाएगा, क्योंकि उसने याहवेह की पवित्र वस्तु को अशुद्ध किया है, तब उस व्यक्ति को प्रजा से बाहर निकाल दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘जब तुम अपने देश में पहुंचने के बाद, उपज इकट्ठा करोगे, तो तुम अपने खेतों के कोने-कोने तक की उपज इकट्ठा न कर लेना, न ही उपज की सिल्ला. ");
INSERT INTO hincv_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","न ही अपनी अंगूर की बारी से सारे अंगूर इकट्ठा कर लेना, और न ही अपनी अंगूर की बारी के नीचे गिरे हुए फलों को इकट्ठा करना; तुम उन्हें दरिद्रों तथा विदेशियों के लिए छोड़ देना. मैं याहवेह ही तुम्हारा परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘तुम चोरी न करना. “ ‘न ही धोखा देना. “ ‘न एक दूसरे से झूठ बोलना. ");
INSERT INTO hincv_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘तुम मेरे नाम की झूठी शपथ न लेना और इस प्रकार अपने परमेश्वर का नाम अशुद्ध न करना; मैं ही याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘तुम अपने पड़ोसी को न लूटना. “ ‘न ही उसकी किसी वस्तु को ज़बरदस्ती छीनना. भाड़े पर लाए गए किसी मज़दूर की मजदूरी तुम्हारे पास रात से सुबह तक रखी न रह जाए. ");
INSERT INTO hincv_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘तुम किसी बहिरे को शाप न देना, न ही अंधे के सामने ठोकर का पत्थर रखना, परंतु अपने परमेश्वर की आज्ञा का पालन करना; मैं ही याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘तुम निर्णय देने में अन्याय न करना; तुम दरिद्र के प्रति भेद-भाव न करना, न ही ऊंचे लोगों का सम्मान तुम्हारे निर्णय को प्रभावित करने पाए, परंतु तुम अपने पड़ोसी का सही प्रकार से न्याय करना. ");
INSERT INTO hincv_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘तुम अपने लोगों के बीच निंदा करते न फिरना. “ ‘यदि तुम्हारे पड़ोसी का जीवन खतरे में हो तो तुम शांत न बने रहना; मैं ही याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘अपने भाई से घृणा न करना; तुम अपने पड़ोसी को फटकार अवश्य लगाना; ऐसा न हो कि उसके पाप के दोष तुम पर आ जाए. ");
INSERT INTO hincv_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘बदला न लेना, और न ही अपने लोगों की संतान से कोई बैर रखना, परंतु तुम अपने पड़ोसी से वैसा ही प्रेम करना, जैसा प्रेम तुम्हें स्वयं से है; मैं ही याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘मेरी विधियों का पालन करना. “ ‘तुम अपने पशुओं में दो भिन्‍न प्रकार के पशुओं का मेल न कराना; “ ‘तुम अपने खेत में दो भिन्‍न प्रकार के बीज न बोना. “ ‘न ही वह वस्त्र पहनना, जिसमें दो प्रकार की सामग्रियों का मिश्रण किया गया हो. ");
INSERT INTO hincv_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘यदि कोई व्यक्ति उस स्त्री से, जो दासी है और किसी अन्य की मंगेतर है, तथा किसी भी प्रकार से उसका दाम नहीं चुकाया गया, न ही उसे स्वतंत्र किया गया है, सहवास कर लेता है, तब उन्हें दंड तो दिया जाएगा किंतु मृत्यु दंड नहीं, क्योंकि वह स्त्री उस समय दासत्व में थी. ");
INSERT INTO hincv_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","वह व्यक्ति मिलनवाले तंबू के द्वार पर दोष बलि के लिए एक मेढ़ा याहवेह को भेंट करे. ");
INSERT INTO hincv_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","फिर पुरोहित दोष बलि के उस मेढ़े के साथ याहवेह के सामने उस व्यक्ति तथा उसके द्वारा किए गए पाप के लिए प्रायश्चित पूरा करे, तब उसके द्वारा किया गया पाप क्षमा कर दिया जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘जब तुम उस देश में प्रवेश करके सभी प्रकार के खानेवाले फलों के वृक्षों को उगाओगे, तो याद रहे कि इन बोए हुए वृक्षों के फल तुम्हारे लिए वर्जित होंगे. पहले तीन वर्षों के लिए ये फल तुम्हारे लिए वर्जित होंगे; इनको न खाया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","किंतु चौथे वर्ष इसके सारे फल याहवेह की स्तुति में भेंट पवित्र फल होंगे. ");
INSERT INTO hincv_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","पांचवें वर्ष तुम इनको खा सकते हो कि यह तुम्हें बहुत मात्रा में फल दे सके; याहवेह तुम्हारा परमेश्वर मैं ही हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘तुम किसी भी वस्तु को लहू के साथ न खाना. “ ‘न ही शकुन विचारना अथवा जादू-टोना करना. ");
INSERT INTO hincv_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘तुम अपनी कनपटी के बाल न कतरना और न अपनी दाढ़ी को किनारों से काटना. ");
INSERT INTO hincv_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘मृतकों के लिए तुम अपनी देह में कोई चीरा न लगवाना, न ही कोई चिन्ह गुदवाना: मैं ही याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘अपनी पुत्री को वेश्या बनाकर उसे भ्रष्‍ट न करना, ऐसा न हो कि देश में वेश्यावृत्ति भर जाए, और यह कामुकता से परिपूर्ण हो जाए. ");
INSERT INTO hincv_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘तुम मेरे शब्बाथों का पालन करो और मेरे पवित्र स्थान का सम्मान; मैं ही याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘तुम ओझाओं और तांत्रिकों की ओर न फिरना; उनकी खोज करने के द्वारा तुम स्वयं को दूषित न कर लेना. मैं ही याहवेह तुम्हारा परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘तुम बूढ़े व्यक्ति के सामने खड़े हुआ करो, और बूढ़ों की उपस्थिति का सम्मान करना, तथा अपने परमेश्वर का भय मानना; मैं ही याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘जब कोई अपरिचित तुम्हारे बीच तुम्हारे देश में रहता है, तो तुम उसके साथ अन्याय न करना. ");
INSERT INTO hincv_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","जो अपरिचित तुम्हारे बीच में रह रहा है, तुम्हारे लिए वह तुम्हारे मध्य एक स्वदेशी के समान हो, और तुम उससे वैसा ही प्रेम करना; जैसा तुम स्वयं से करते हो, क्योंकि मिस्र देश में तुम परदेशी थे; मैं याहवेह ही तुम्हारा परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘तुम न्याय करने, नापतोल तथा मात्रा में अन्याय न करना. ");
INSERT INTO hincv_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","तुम्हारी तुला, बाट, किलो और लीटर यथार्थ हों; मैं याहवेह ही तुम्हारा परमेश्वर हूं, जो तुम्हें मिस्र देश से निकालकर लाया हूं. ");
INSERT INTO hincv_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘फिर तुम मेरी विधियों और सभी नियमों का पालन करना और उनको मानते रहना; मैं ही याहवेह हूं.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","याहवेह ने मोशेह को यह आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“इस्राएल वंशजों को तुम ये आदेश भी देना: ‘इस्राएल वंशजों में से कोई भी व्यक्ति अथवा इस्राएल में रह रहे परदेशियों में से कोई भी, जो अपनी संतान में से किसी को भी मोलेख को भेंट करता है, निश्चयतः उसका वध कर दिया जाए; उस देश के निवासी उस पर पथराव करें. ");
INSERT INTO hincv_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","मैं भी उस व्यक्ति से मुंह फेर लूंगा और उसे प्रजा से निकाल बाहर कर दूंगा, क्योंकि उसने अपनी संतानों में से कुछ को मेरे पवित्र स्थान को अशुद्ध और मेरे पवित्र नाम को भ्रष्‍ट करने के लिए मोलेख के लिए भेंट किया है. ");
INSERT INTO hincv_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","यदि उस देश के निवासी उस व्यक्ति को अनदेखा कर दें, जिसने अपनी संतान में से किसी को मोलेख को भेंट किया है, और उसका वध न करें, ");
INSERT INTO hincv_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","तो मैं स्वयं उस व्यक्ति एवं उसके परिवार से मुंह फेर लूंगा और उन्हें प्रजा से निकाल बाहर कर दूंगा; उस व्यक्ति को और उन सभी लोगों को, जो मोलेख के प्रति श्रद्धा दिखा करके मेरे साथ विश्वास को तोड़ने में उस व्यक्ति का साथ देते हैं. ");
INSERT INTO hincv_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘जहां तक उस व्यक्ति का प्रश्न है, जो तांत्रिकों और ओझाओं की ओर फिर गया हो, मेरे साथ विश्वास तोड़ने में उनका साथ देता है, मैं उस व्यक्ति से भी मुंह फेर लूंगा और उसे मेरी प्रजा से अलग कर दूंगा. ");
INSERT INTO hincv_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘इसलिये तुम स्वयं को शुद्ध करो और पवित्र बनो, क्योंकि मैं याहवेह ही तुम्हारा परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","तुम मेरी विधियों का पालन करते हुए उनको मानना; मैं ही वह याहवेह हूं, जो तुम्हें शुद्ध करता हूं. ");
INSERT INTO hincv_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘यदि कोई ऐसा व्यक्ति है, जो अपने पिता अथवा अपनी माता को शाप देता है, तो निश्चय ही उसका वध कर दिया जाए; उसने अपने पिता और माता को शाप दिया है; उसके लहू का दोष उसी पर होगा. ");
INSERT INTO hincv_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘यदि कोई व्यक्ति किसी अन्य व्यक्ति की पत्नी से व्यभिचार करता है, तो जिसने अपने मित्र की पत्नी के साथ व्यभिचार किया है, निश्चय ही उस व्यभिचारी और उस व्यभिचारिणी दोनों का वध किये जाए. ");
INSERT INTO hincv_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘यदि कोई व्यक्ति अपने पिता की पत्नी से सहवास कर लेता है, तो उसने अपने पिता का अपमान किया है; इसलिये अवश्य है कि उन दोनों का वध कर दिया जाए; उन दोनों के लहू का दोष उन्हीं पर होगा. ");
INSERT INTO hincv_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘यदि कोई व्यक्ति अपनी बहू से सहवास करता है, तो निश्चय ही उन दोनों का वध कर दिया जाए; उन्होंने पारिवारिक व्यभिचार किया है, उनके लहू का दोष उन्हीं पर होगा. ");
INSERT INTO hincv_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘यदि कोई पुरुष किसी पुरुष के साथ वैसा ही सहवास करता है जैसा किसी स्त्री के साथ, तो उन्होंने एक घृणित काम किया है; निश्चित ही उन दोनों का वध कर दिया जाए. उनके लहू का दोष उन्हीं पर होगा. ");
INSERT INTO hincv_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘यदि कोई पुरुष किसी स्त्री एवं उसकी माता से विवाह करता है, तो यह महापाप है; उसको एवं उन दोनों स्त्रियों को आग में जला दिया जाए, कि तुम्हारे बीच कोई महापाप न रह जाए. ");
INSERT INTO hincv_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘यदि कोई व्यक्ति किसी पशु से सहवास करता है, तो निश्चित ही उस व्यक्ति का वध कर दिया जाए, और निश्चित ही उस पशु का भी. ");
INSERT INTO hincv_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘यदि कोई स्त्री किसी पशु से सहवास करती है, तो तुम उस स्त्री एवं पशु का वध कर देना; निश्चित ही उनका वध कर दिया जाए. उनके लहू का दोष उन्हीं पर होगा. ");
INSERT INTO hincv_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘यदि कोई अपनी बहन से अर्थात् अपने पिता की पुत्री अथवा अपनी सौतेली माता की पुत्री से विवाह करता है, जिसके कारण वह उस कन्या को बिना वस्त्र के देख लेता है, तथा वह कन्या उसको बिना वस्त्र के देख लेती है, तो यह लज्जा जनक कार्य है, और उन्हें लोगों के बीच में से निकाल दिया जाए. वह व्यक्ति, जिसने अपनी बहन की लज्जा को उघाड़ा है; अपने अधर्म का बोझ स्वयं उठाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘यदि कोई व्यक्ति किसी ऋतुमती से संभोग कर उसकी लज्जा को उघाड़ता है, उसने उसके ऋतुस्राव के स्रोत को उघाड़ा है और उस स्त्री ने अपने रक्त प्रवाह को उघाड़ा है, उन दोनों को लोगों के बीच में से निकाल दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘तुम अपनी मौसी अथवा अपनी फूफी की लज्जा को न उघाड़ना, क्योंकि ऐसे व्यक्ति ने अपने कुटुंबी को नग्न किया है; वे अपने अधर्म का बोझ स्वयं उठाएंगे. ");
INSERT INTO hincv_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘यदि कोई व्यक्ति अपनी चाची से संभोग करता है, तो उसने अपने चाचा की लज्जा को उघाड़ा है; वे अपने पाप का बोझ स्वयं उठाएंगे. उनकी मृत्यु निसंतान होगी. ");
INSERT INTO hincv_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘यदि कोई व्यक्ति अपनी भाभी से विवाह करता है, यह घिनौना काम है, उसने अपने भाई की लज्जा को उघाड़ा है. वे निसंतान ही रह जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘तुम मेरी सभी विधियों और मेरे सभी नियमों का पालन करते हुए उनका अनुसरण करना, कि वह देश तुम्हें निकाल न फेंके, जिसमें मैं तुम्हें बस जाने के लिए ले जा रहा हूं. ");
INSERT INTO hincv_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","इसके अलावा तुम उन जनताओं की रीति रस्मों पर मत चलना, जिन्हें मैं तुम्हारे सामने से निकाल दूंगा, क्योंकि उन्होंने ये सब कुकर्म किए, इसलिये मैंने उनसे घृणा की है. ");
INSERT INTO hincv_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","अतःएव मैंने तुम्हें आदेश दिया, “तुम्हें उनके देश पर अधिकार कर लेना है, मैं स्वयं इस देश को तुम्हारे अधिकार में कर दूंगा, जहां दूध और शहद की बहुतायत है.” मैं याहवेह ही तुम्हारा परमेश्वर हूं, जिसने तुम्हें उन लोगों से अलग किया है. ");
INSERT INTO hincv_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘तुम्हें शुद्ध एवं अशुद्ध पशुओं, शुद्ध एवं अशुद्ध पक्षियों के बीच भेद स्पष्ट रखना होगा; किसी पशु, पक्षी अथवा कोई भी प्राणी, जो भूमि पर रेंगता है, जिसे मैंने उसकी अशुद्धता के कारण तुमसे अलग किया है, उसके कारण तुम स्वयं को अशुद्ध न करना. ");
INSERT INTO hincv_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","इस प्रकार ज़रूरी है कि तुम मेरे प्रति पवित्र रहो, क्योंकि मैं ही याहवेह हूं, जो पवित्र हूं; मैंने तुम्हें मेरी प्रजा होने के लिए लोगों से अलग किया है. ");
INSERT INTO hincv_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘यदि कोई तांत्रिक एवं ओझा है, तो निश्चित ही उसका वध कर दिया जाए. उन पर पथराव किया जाए, उनके लहू का दोष उन्हीं पर है.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","याहवेह ने मोशेह को यह आज्ञा दी, “अहरोनवंशी पुरोहितों को यह आज्ञा दो: ‘कोई पुरोहित अपने लोगों के बीच किसी मृतक के लिए स्वयं को अशुद्ध न करे, ");
INSERT INTO hincv_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","केवल उसके निकटतम संबंधियों के अर्थात् माता, पिता, उसके पुत्र, पुत्री, भाई, ");
INSERT INTO hincv_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","तथा उसकी कुंवारी बहन, जो उस पर आश्रित है, क्योंकि अब तक उसके कोई पति हुआ ही नहीं; इनके लिए वह पुरोहित स्वयं को अशुद्ध कर सकता है. ");
INSERT INTO hincv_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","घर का मालिक होने के कारण वह स्वयं को अशुद्ध न करे; हां, इस प्रकार वह स्वयं को भ्रष्‍ट न करे. ");
INSERT INTO hincv_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘वे अपना सिर न मुंडवाएं, न ही अपनी दाढ़ी के किनारे कतरें, न ही अपनी देह में चीरा लगायें. ");
INSERT INTO hincv_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","वे अपने परमेश्वर के प्रति पवित्र रहें और अपने परमेश्वर के नाम को अशुद्ध न करें क्योंकि वे आग के बीच से याहवेह, अपने परमेश्वर का भोजन अर्थात् बलि भेंट कर रहे होते हैं; इसलिये ज़रूरी है कि वे पवित्र रहें. ");
INSERT INTO hincv_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘वे वेश्यावृत्ति से अशुद्ध स्त्री से विवाह न करे, न ही उस स्त्री से जिसका उसके पति से तलाक हो गया है, क्योंकि पुरोहित उसके परमेश्वर के लिए पवित्र है. ");
INSERT INTO hincv_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","तुम उसे पवित्र करना, क्योंकि वह तुम्हारे परमेश्वर को भोजन भेंट करता है, वह तुम्हारे लिए पवित्र रहे, क्योंकि मैं याहवेह, जो तुम्हें पवित्र करता हूं, पवित्र हूं. ");
INSERT INTO hincv_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘पुरोहित की कोई पुत्री, यदि स्वयं को वेश्यावृत्ति से अशुद्ध करती है, तो वह अपने पिता को अशुद्ध करती है; उसे आग में जला दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘वह पुरोहित, जो अपने भाइयों में प्रधान है, जिसके सिर पर अभिषेक का तेल उंडेला गया है, जिसे पुरोहित वस्त्र धारण करने के लिए पवित्र किया गया है, वह पुरोहित अपने सिर को न उघाड़े, न ही अपने वस्त्र फाड़े; ");
INSERT INTO hincv_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","न ही वह किसी शव के निकट जाए, न ही स्वयं को अपने पिता और अपनी माता के लिए अशुद्ध करे; ");
INSERT INTO hincv_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","वह पवित्र स्थान से बाहर न जाए और न अपने परमेश्वर के पवित्र स्थान को अपवित्र करे क्योंकि परमेश्वर के अभिषेक का तेल उस पर है; मैं ही याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘वह कुंवारी कन्या से ही विवाह करे. ");
INSERT INTO hincv_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","वह इनमें किसी से विवाह न करे: एक विधवा अथवा जिसका तलाक हो गया हो, अथवा उस कन्या से जो वेश्यावृत्ति द्वारा अशुद्ध हो गई हो, परंतु वह अपने लोगों में से ही किसी कुंवारी से विवाह करे, ");
INSERT INTO hincv_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","कि वह अपने लोगों में अपनी संतानों को अशुद्ध न कर दे; क्योंकि मैं ही याहवेह हूं, जो उसे पवित्र करता हूं.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","इसके बाद याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“अहरोन को यह संदेश दो, ‘तुम्हारी संतानों में से उनकी पीढ़ियों तक कोई भी व्यक्ति, जिसमें कोई अंग खराब पाया जाता है, वह अपने परमेश्वर को भोजन भेंट करने का प्रयास न करे. ");
INSERT INTO hincv_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","हां, इनमें से कोई भी व्यक्ति, यह प्रयास न करे: अंधा, लंगड़ा, चपटी नाक वाला, या अधिक अंग वाला हो, ");
INSERT INTO hincv_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","जिसका पांव अथवा बांह की कोई हड्डी टूटी हो, ");
INSERT INTO hincv_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","कुबड़ा, बौना, जिसकी आंख में कोई खराबी हो, जो खुजली से पीड़ित हो अथवा उसकी त्वचा पर चकते हों तथा जिसके अंडकोश कुचले हुए हों. ");
INSERT INTO hincv_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","अहरोन की संतानों में से कोई व्यक्ति, जिसमें कोई खराबी हो, वह आग में याहवेह को बलि भेंट करने का प्रयास न करे; इसलिये कि उस व्यक्ति में वह खराबी है, वह अपने परमेश्वर के भोजन को भेंट करने का प्रयास न करे. ");
INSERT INTO hincv_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","वह परम पवित्र तथा पवित्र स्थान, दोनों ही स्थानों के अपने परमेश्वर के भोजन को खा तो सकता है, ");
INSERT INTO hincv_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","किंतु वह पर्दे के भीतर न जाए और न ही वेदी के निकट, क्योंकि उसके अंगों में खराबी है, और इसके द्वारा वह मेरे पवित्र स्थानों को अशुद्ध न कर बैठे. क्योंकि मैं ही याहवेह हूं, जो उन्हें पवित्र करता हूं.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","इस प्रकार मोशेह ने अहरोन, उनके पुत्रों और सारे इस्राएल के घराने को ये आज्ञाएं दीं. ");
INSERT INTO hincv_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","याहवेह ने मोशेह को ये आदेश दिए, ");
INSERT INTO hincv_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“अहरोन और उसके पुत्रों को इस्राएल के घराने के उन उपहारों के प्रति, जो उपहार वे मुझे भेंट करते हैं, सावधान रहने को बता दो; कि इसके द्वारा वे मेरे पवित्र नाम को अपवित्र न कर दें; मैं ही याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“उन्हें यह आज्ञा दो, ‘तुम्हारी सारी पीढ़ियों तक, यदि तुम्हारे बीच में से कोई भी व्यक्ति जब वह अशुद्ध है, तब उन भेंटों के समीप आ जाता है, जो इस्राएल के घराने के द्वारा मुझे भेंट किए गए थे, तो उस व्यक्ति को मेरे सामने से अलग कर दिया जाए; मैं ही वह याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘अहरोन के घराने में से कोई भी व्यक्ति, जो कोढ़ी है, अथवा जिसे किसी प्रकार का स्राव हो रहा हो, तब तक मेरी पवित्र भेंटों में से कुछ न खाए, जब तक वह शुद्ध न हो जाए. और यदि कोई व्यक्ति उस वस्तु को छू लेता है, जो किसी शव को छूने के द्वारा अशुद्ध हो गई है, अथवा यदि किसी व्यक्ति का वीर्य स्खलन हुआ है, ");
INSERT INTO hincv_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","अथवा यदि कोई व्यक्ति किसी अशुद्ध वस्तु को छू लेता है और उसके द्वारा वह अशुद्ध हो जाता है, अथवा वह किसी अन्य अशुद्ध व्यक्ति के द्वारा अशुद्ध हो जाता है, तो चाहे उसकी कैसी भी अशुद्धता हो; ");
INSERT INTO hincv_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","तो वह व्यक्ति, जो ऐसी किसी भी वस्तु को छू लेता है, वह शाम तक अशुद्ध रहेगा और स्‍नान करने तक वह पवित्र भेंटों में से किसी वस्तु को न खाए. ");
INSERT INTO hincv_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","किंतु सूर्य अस्त होने पर वह व्यक्ति शुद्ध हो जाएगा; इसके बाद वह पवित्र भेंटों में से खा सकता है, क्योंकि यह उसका भोजन है. ");
INSERT INTO hincv_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","वह उस मरे हुए पशु के मांस को न खाए, जिसकी स्वाभाविक मृत्यु हुई हो, अथवा जिसे किसी जंगली जानवर ने फाड़ डाला हो, ऐसा करके वह स्वयं को अशुद्ध न बनाए; क्योंकि मैं ही याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘वे मेरे इस नियम का पालन करें कि उन्हें पाप का भार न उठाना पड़े और मेरे नियम को अपवित्र करने के द्वारा उनकी मृत्यु न हो जाए; क्योंकि मैं ही याहवेह हूं, जो उन्हें पवित्र करता हूं. ");
INSERT INTO hincv_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘कोई भी, जो पुरोहित के परिवार के बाहर का हो, किसी पवित्र भेंट को न खाए; किसी पुरोहित के साथ रह रहा कोई पराए कुल का रहवासी, अथवा किराये पर लिया गया कोई मज़दूर पवित्र भेंट में से न खाए. ");
INSERT INTO hincv_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","किंतु यदि कोई पुरोहित धन देकर किसी दास को खरीद लेता है, तो वह दास पवित्र भेंट में से खा सकता है, और वे सब भी जिनका जन्म उसके परिवार में हुआ है, उसके भोजन से खा सकते हैं. ");
INSERT INTO hincv_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","यदि किसी पुरोहित की पुत्री का विवाह किसी ऐसे व्यक्ति से हो जाए, जो पुरोहित न हो, तो वह कन्या उन चढ़ाई हुई भेंटों में से न खाए. ");
INSERT INTO hincv_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","किंतु यदि किसी पुरोहित की पुत्री विधवा हो जाए, अथवा उसका तलाक हो जाए, और वह युवावस्था में ही निःसंतान ही अपने पिता के घर लौट आए, तो वह अपने पिता के भोजन में से खा सकती है; किंतु कोई व्यक्ति जो पुरोहित न हो वह इसमें से न खाए. ");
INSERT INTO hincv_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘यदि कोई व्यक्ति अनजाने में पवित्र भेंटों में से खा ले, तो वह इसका पांच गुणा मिलाकर उस पवित्र भेंट को पुरोहित को दे दे. ");
INSERT INTO hincv_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","वे इस्राएल के घराने द्वारा याहवेह को चढ़ाई हुई पवित्र भेंटों को अपवित्र न करें ");
INSERT INTO hincv_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","और इस प्रकार उनकी पवित्र भेंटों को खाने के द्वारा दंड उठाने का कारण न बनें; क्योंकि मैं ही याहवेह हूं, जो उन्हें पवित्र करता हूं.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“अहरोन, उसके पुत्रों और सारे इस्राएल के घराने को यह आज्ञा दो, ‘इस्राएल के घराने में से कोई व्यक्ति अथवा इस्राएल में कोई परदेशी जब बलि चढ़ाए, चाहे यह बलि किसी शपथ के लिए हो, अथवा उनकी स्वेच्छा बलि हो, वे याहवेह को वह होमबलि के रूप में चढ़ाएं. ");
INSERT INTO hincv_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","वह तुम्हारे लिए ग्रहण योग्य हो सके, तो ज़रूरी है कि यह बलि निर्दोष नर पशु की हो, चाहे बछड़ा अथवा मेढ़ा अथवा बकरा. ");
INSERT INTO hincv_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","उस पशु को न चढ़ाया जाए, जिसमें कोई खराबी हो, क्योंकि तुम्हारे पक्ष में यह याहवेह द्वारा ग्रहण नहीं होगा. ");
INSERT INTO hincv_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","जब कोई व्यक्ति बैलों अथवा भेड़-बकरियों में से किसी विशेष शपथ को पूरा करने, अथवा स्वेच्छा बलि के लिए याहवेह को मेल बलि चढ़ाता है, तो ज़रूरी है कि ग्रहण करने के लिए यह निर्दोष हो; ध्यान रहे कि इसमें कोई खराबी न हो. ");
INSERT INTO hincv_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ऐसे पशुओं को, जो अंधे हों, जिनकी हड्डी टूटी हो, जो विकलांग हों, जिसके घावों से स्राव हो रहा हो, जिन्हें चकते हो गए अथवा खाज-खुजली वाले हों, याहवेह को न चढ़ाना और न ही उन्हें वेदी पर अग्निबलि स्वरूप याहवेह के लिए चढ़ाना. ");
INSERT INTO hincv_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","तुम किसी ऐसे बछड़े अथवा मेमने को स्वेच्छा बलि के लिए चढ़ा सकते हो, जिसका कोई अंग बड़ा अथवा छोटा हो गया हो, किंतु किसी शपथ के लिए यह ग्रहण नहीं होगा. ");
INSERT INTO hincv_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","किसी भी ऐसे पशु को जिसके अंडकोश चोटिल, कुचले, फटे अथवा कटे हों, याहवेह को न चढ़ाना, और न ही अपने देश में उनकी बलि देना, ");
INSERT INTO hincv_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","और न ही किसी विदेशी से इसे परमेश्वर के भोजन के रूप में चढ़ाने के लिए ग्रहण करना; क्योंकि उनमें तो उनका बिगड़ा आकार है ही. उनमें दोष है वे तुम्हारे पक्ष में ग्रहण नहीं होंगे.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“जब किसी बछड़े, भेड़ अथवा बकरी का जन्म हो, यह सात दिन तक अपनी माता के साथ में रहे, और आठवें दिन के बाद से यह याहवेह के लिए अग्निबलि के रूप में ग्रहण हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","किंतु चाहे यह बछड़ा हो अथवा भेड़, तुम माता तथा उसके बच्‍चे दोनों का एक ही दिन में वध न करना. ");
INSERT INTO hincv_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“जब तुम याहवेह को आभार-बलि चढ़ाओ, तो तुम इसे इस प्रकार भेंट करो कि यह याहवेह को ग्रहण हो. ");
INSERT INTO hincv_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","इसको उसी दिन खा लिया जाए, तुम सुबह तक इसमें से कुछ भी बचाकर न रखना; मैं ही याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“तुम मेरी आज्ञाओं का पालन कर उनका अनुसरण करना; मैं ही याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","तुम मेरे पवित्र नाम को अशुद्ध न करना; मैं इस्राएल के घराने में पवित्र किया जाऊंगा; मैं ही याहवेह हूं, जो तुम्हें पवित्र करता हूं, ");
INSERT INTO hincv_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","तुम्हें मिस्र से निकालकर लाया हूं, कि तुम्हारे लिए तुम्हारा परमेश्वर हो जाऊं; मैं ही याहवेह हूं.” ");
INSERT INTO hincv_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","याहवेह ने मोशेह को दोबारा आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“इस्राएल के घराने को यह आज्ञा दो: ‘ये याहवेह के वे ठहराए हुए उत्सव हैं, जिन्हें तुम पवित्र समारोह घोषित करोगे; मेरे द्वारा निर्धारित उत्सव ये हैं: ");
INSERT INTO hincv_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘छः दिन तो कार्य किया जा सकता है, किंतु सातवां दिन पूर्ण विश्राम का दिन, शब्बाथ है, एक पवित्र समारोह. तुम कोई कार्य न करना; यह तुम्हारे सारे घराने में याहवेह के लिए एक शब्बाथ होगा. ");
INSERT INTO hincv_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘ये याहवेह के ठहराए गए उत्सव हैं—पवित्र समारोह, जिनकी घोषणा तुम्हें उनके तय किए गए समय पर करनी है. ");
INSERT INTO hincv_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","याहवेह के फ़सह का निर्धारित समय पहले माह के चौदहवें दिन संध्या समय है. ");
INSERT INTO hincv_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","उसी माह के पन्द्रहवें दिन याहवेह के लिए खमीर रहित रोटी का उत्सव होगा; सात दिन तक खमीर रहित रोटी ही खाई जाए. ");
INSERT INTO hincv_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","पहले दिन पवित्र सभा होगी तथा तुम किसी भी प्रकार की मेहनत न करना. ");
INSERT INTO hincv_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","किंतु सातों दिनों तुम याहवेह को अग्निबलि चढ़ाना. सातवें दिन पवित्र सभा होगी, इस दिन तुम किसी भी प्रकार की मेहनत न करना.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इस्राएल के घराने को यह आज्ञा दो, ‘जब तुम उस देश में प्रवेश करो, जो मैं तुम्हें देनेवाला हूं तथा उसकी उपज इकट्ठी करो, तो तुम अपनी पहली उपज की पूलियों को पुरोहित के सामने लेकर आना. ");
INSERT INTO hincv_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","पुरोहित इन पूलियों को याहवेह के सामने हिलाने की बलि के रूप में चढ़ाए कि यह तुम्हारे लिए ग्रहण किया जाए; पुरोहित इसे शब्बाथ के अगले दिन हिलाए. ");
INSERT INTO hincv_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","उसी दिन, जिस दिन पूलियों को हिलाने की मुद्रा बलि के रूप में चढ़ाया जाए, एक वर्षीय नर मेमने की होमबलि याहवेह को चढ़ाई जाए. ");
INSERT INTO hincv_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","इसके साथ अन्‍नबलि में तेल और तीन किलो मैदा मिलाकर याहवेह के लिए सुखदायी सुगंध के रूप में आग में चढ़ाया जाए. इसके अलावा उसके साथ पेय बलि के लिए एक लीटर दाखरस भी. ");
INSERT INTO hincv_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","उस दिन तक तथा जब तक तुम्हारे परमेश्वर के लिए निर्धारित बलि न चढ़ा दी जाए, तब तक न तो रोटी और न ही भुने अथवा कच्चे अन्‍न को खाया जाए. यह तुम्हारे सारे घराने में तुम्हारी सारी पीढ़ियों के लिए सदा-सर्वदा के लिए एक विधि है. ");
INSERT INTO hincv_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘तुम शब्बाथ के अगले दिन से, जब लहराने की बलि के रूप में चढ़ाने के लिए पुलियां लाई जाएं, गिनती करना; ये पूरे सात शब्बाथ होंगे. ");
INSERT INTO hincv_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","सातवें शब्बाथ के अगले दिन से पचास दिनों की गिनती करना; फिर याहवेह को नया अन्‍नबलि चढ़ाया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","तुम अपने निवास स्थानों से लहराने की बलि के रूप में चढ़ाने के लिए दो किलो मैदे की रोटियां लाना; जो याहवेह को प्रथम फल के रूप में चढ़ाने के लिए खमीर के साथ बनाई जाएं. ");
INSERT INTO hincv_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","रोटियों के साथ साथ सात एक-एक वर्षीय निर्दोष मेमने, पशुओं से एक बछड़ा और दो मेढ़े चढ़ाना; ये सब याहवेह के लिए होमबलि हैं, जो उनकी अन्‍नबलि तथा उनकी पेय बलि सहित अग्निबलि द्वारा याहवेह को सुखद-सुगंध होंगे. ");
INSERT INTO hincv_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","पापबलि के लिए एक बकरा और मेल बलि के लिए एक-एक वर्षीय दो मेमने भी अर्पित करना. ");
INSERT INTO hincv_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","पुरोहित इन्हें लहराने की बलि के समान बलि चढ़ाने के लिए पहली उपज की रोटियों और मेमनों के साथ याहवेह के सामने लहराए. ये याहवेह के लिए पवित्र तथा पुरोहित का ठहराया हुआ भाग हैं. ");
INSERT INTO hincv_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","उसी दिन तुम एक पवित्र समारोह भी मनाने की घोषणा करना. उस दिन किसी भी प्रकार का परिश्रम न करना. यह तुम्हारे सारे घरानों में तुम्हारी सारी पीढ़ियों के लिए सदा-सर्वदा के लिए एक विधि है. ");
INSERT INTO hincv_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘जब तुम अपने देश में उपज इकट्ठी करो, तो तुम अपने खेतों से कोने-कोने तक की उपज इकट्ठा न करना, न ही अपनी उपज की सिल्ला इकट्ठी करना; तुम उन्हें दीनों तथा विदेशियों के लिए छोड़ देना. मैं याहवेह ही तुम्हारा परमेश्वर हूं.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","याहवेह ने मोशेह को दोबारा आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इस्राएल के घराने को यह आज्ञा दो, ‘सातवें माह का प्रथम दिन शब्बाथ का विश्राम दिन होगा, तुरही फूंकने के द्वारा इसका स्मरण दिलाना. यह एक पवित्र समारोह है. ");
INSERT INTO hincv_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","इस दिन तुम किसी प्रकार का परिश्रम न करना, और याहवेह को अग्निबलि चढ़ाना.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","याहवेह ने मोशेह को निर्देश दिया, ");
INSERT INTO hincv_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“इस माह का दसवां दिन प्रायश्चित का दिन होगा, यह तुम्हारे लिए पवित्र समारोह होगा और इस दिन अपने हृदयों को नम्र बनाकर याहवेह को अग्निबलि चढ़ाई जाए. ");
INSERT INTO hincv_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","इस दिन तुम किसी भी प्रकार का परिश्रम न करना, क्योंकि यह प्रायश्चित का दिन है कि याहवेह तुम्हारे परमेश्वर के सामने तुम्हारे लिए प्रायश्चित पूरा किया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","जो व्यक्ति इस दिन स्वयं को नम्र नहीं करता, उसे उसके परिवार से बाहर निकाल दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","जो व्यक्ति इस दिन परिश्रम करता है, मैं उस व्यक्ति को उसके परिवार के बीच से नाश कर दूंगा. ");
INSERT INTO hincv_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","तुम इस दिन किसी भी प्रकार का परिश्रम नहीं करोगे. यह तुम्हारे सारे घरानों में तुम्हारी सारी पीढ़ियों के लिए हमेशा के लिए एक विधि है. ");
INSERT INTO hincv_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","यह तुम्हारे लिए संपूर्ण विश्राम का शब्बाथ है, इस दिन तुम अपने हृदयों को नम्र करोगे; माह के नौवें दिन शाम से शाम तक शब्बाथ का पालन करोगे.” ");
INSERT INTO hincv_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","याहवेह ने मोशेह को दोबारा आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“इस्राएल के घराने को यह आज्ञा दो, ‘सातवें माह के पन्द्रहवें दिन से याहवेह के लिए सात दिनों के लिए झोपड़ी का उत्सव होगा. ");
INSERT INTO hincv_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","प्रथम दिवस पवित्र समारोह होगा; तुम इस दिन किसी भी प्रकार का परिश्रम नहीं करोगे. ");
INSERT INTO hincv_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","तुम इन सातों दिन याहवेह को अग्निबलि चढ़ाना. आठवें दिन तुम पवित्र समारोह का आयोजन करोगे और इस दिन याहवेह को एक अग्निबलि चढ़ाओगे; यह एक औपचारिक आयोजन होगा. तुम किसी भी प्रकार का परिश्रम नहीं करोगे. ");
INSERT INTO hincv_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘ये याहवेह के वे नियत उत्सव हैं, जिन्हें तुम याहवेह के लिए अग्निबलियां प्रस्तुत करने के लिए पवित्र सभा घोषित करना. होमबलियां, अन्‍नबलियां, अन्य बलियां तथा पेय बलियां, हर एक अपने-अपने नियत दिन पर अर्पित करने के लिए हैं. ");
INSERT INTO hincv_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ये दिन याहवेह के शब्बाथों के अलावा तथा ये बलियां तुम्हारी उन भेंटों, शपथ और स्वेच्छा बलि के अतिरिक्त हैं, जो तुम याहवेह के लिए चढ़ाते हो. ");
INSERT INTO hincv_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘सातवें माह के पन्द्रहवें दिन, जब तुम देश की उपज इकट्ठी कर चुकोगे, तब सात दिनों के लिए याहवेह के लिए उत्सव मनाना. इसमें प्रथम दिन तथा आठवां दिन शब्बाथ होगा. ");
INSERT INTO hincv_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","प्रथम दिन तुम स्वयं अपने लिए हरे-भरे वृक्षों के फल, खजूर वृक्ष की शाखाएं, घने वृक्षों की शाखा और नदी के किनारे के मजनूं वृक्ष लेकर सात दिन तक याहवेह तुम्हारे परमेश्वर के सामने आनंद करना. ");
INSERT INTO hincv_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","तुम हर साल याहवेह के लिए सात दिन यह उत्सव मनाओगे. यह उत्सव सातवें माह में मनाया जाए. यह तुम्हारी सारी पीढ़ियों में हमेशा के लिए एक विधि है. ");
INSERT INTO hincv_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","तुम सात दिन झोंपड़ियों में रहोगे; इस्राएल के सारे मूल निवासी झोंपड़ियों में रहेंगे, ");
INSERT INTO hincv_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ताकि तुम्हारी आनेवाली पीढ़ियों को यह अहसास हो जाए कि जब मैंने इस्राएल के घराने को मिस्र से निकाला था, मैंने उन्हें झोंपड़ियों में टिकाया था. मैं ही याहवेह तुम्हारा परमेश्वर हूं.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","इस प्रकार मोशेह ने इस्राएल के घराने के सामने याहवेह के निर्धारित उत्सवों का विवरण दिया. ");
INSERT INTO hincv_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","फिर याहवेह ने मोशेह को यह आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“इस्राएलियों को कहना कि वे दीये के लिए जैतून का निकाला हुआ शुद्ध तेल लायें, जिससे दिया हमेशा जलता रहे, ");
INSERT INTO hincv_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","अहरोन इसे शाम से सुबह तक नियमित रूप से मिलनवाले तंबू में साक्षी पर्दे के बाहर याहवेह के सामने सजाकर रखा करे; यह तुम्हारी सारी पीढ़ियों के लिए हमेशा के लिए एक विधि है. ");
INSERT INTO hincv_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","अहरोन दीपकों को याहवेह के सामने कुन्दन के दीपदान पर सजाकर नियमित रूप से रखे. ");
INSERT INTO hincv_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“इसके बाद तुम मैदा लेकर इससे बारह बाटियां बनाना; हर एक बाटी दो किलो मैदे से बनाई जाए. ");
INSERT INTO hincv_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","तुम इन्हें याहवेह के सामने कुन्दन की मेज़ पर क्रमानुसार दो पंक्तियों में रखना; हर एक पंक्ति में छः-छः. ");
INSERT INTO hincv_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","हर एक पंक्ति पर शुद्ध लोबान रखना कि यह बाटी के लिए स्मरण दिलाने वाली याहवेह के लिए अग्निबलि हो जाए. ");
INSERT INTO hincv_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","वह हर एक शब्बाथ इसे याहवेह के सामने सुव्यवस्थित रीति से नियमित रूप से रखे; इस्राएल के घराने के लिए यह एक हमेशा की विधि है. ");
INSERT INTO hincv_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","यह भोजन अहरोन तथा उनके पुत्रों के लिए होगा, और वे इसको पवित्र स्थान में ही खाएंगे क्योंकि यह याहवेह की अग्निबलियों में से उनके लिए परम पवित्र है, उनका सदैव का भाग है.” ");
INSERT INTO hincv_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","तभी अचानक यह हुआ कि एक इस्राएली स्त्री का पुत्र, जिसका पिता एक मिस्री था, इस्राएल के घराने के बीच जा पहुंचा और छावनी में ही उस इस्राएली स्त्री के पुत्र और एक इस्राएली पुरुष के बीच मार-पीट हो गई. ");
INSERT INTO hincv_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","उस इस्राएली स्त्री के पुत्र ने परमेश्वर की निंदा करके परमेश्वर को शाप दिया. तब उसे मोशेह के सामने लाया गया. उस युवक की माता का नाम शेलोमीथ था, जो दान के गोत्र के दिबरी की पुत्री थी. ");
INSERT INTO hincv_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","उन्होंने उसे हवालात में रख लिया कि उसके सामने याहवेह की आज्ञा स्पष्ट की जा सके. ");
INSERT INTO hincv_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","इसके बाद याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“जिसने परमेश्वर को शाप दिया है, उसे छावनी से बाहर लाया जाए, और जिन्होंने उसे ऐसा कहते हुए सुना है, वे उसके सिर पर अपने हाथ रखें; इसके बाद सारी सभा उसका पथराव करे. ");
INSERT INTO hincv_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","इस्राएल के घराने को यह आज्ञा दी जाए, ‘जो अपने परमेश्वर को शाप देता है, वह स्वयं अपने पाप का बोझ उठाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","उसे, जो याहवेह के नाम की निंदा करता है; निश्चित ही मृत्यु दंड दिया जाए; निःसंदेह सारी सभा उसका पथराव करे. चाहे कोई परदेशी हो या देशी, इस प्रकार जब कोई याहवेह के नाम की निंदा करता है, तो उसे मृत्यु दंड दिया ही जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘यदि कोई व्यक्ति किसी दूसरे मनुष्य की हत्या कर देता है, तो निश्चित ही उसे मृत्यु दंड दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","यदि कोई व्यक्ति किसी पशु की हत्या कर देता है, तो वह इसके नुकसान की भरपाई करे, प्राण के बदले प्राण. ");
INSERT INTO hincv_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","यदि कोई व्यक्ति अपने पड़ोसी को चोट पहुंचाता है, तो जैसा उसने किया है, उसके साथ ठीक वैसा ही किया जाए: ");
INSERT INTO hincv_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","अंग-भंग के बदले अंग-भंग; आंख के बदले आंख, दांत के बदले दांत; जैसे उसने एक व्यक्ति को चोट पहुंचाई है, उसे भी ठीक वैसे ही चोट पहुंचाई जाए. ");
INSERT INTO hincv_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","इसी प्रकार वह व्यक्ति जिसने किसी पशु की हत्या की थी, वह इसके नुकसान की भरपाई करेगा, किंतु उसे, जो किसी मनुष्य की हत्या कर देता है, मृत्यु दंड दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","तुम्हारे बीच एक ही नियम हो, परदेशी तथा देशी, दोनों के लिए एक, क्योंकि मैं याहवेह ही तुम्हारा परमेश्वर हूं.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","इसके बाद मोशेह ने इस्राएल के घराने को आदेश दिया और वे उस व्यक्ति को छावनी के बाहर ले आए, जिसने परमेश्वर को शाप दिया था, उसका पथराव किया. इस प्रकार इस्राएल के घराने ने वैसा ही किया, ठीक जैसी आज्ञा याहवेह ने मोशेह को दी थी. ");
INSERT INTO hincv_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","याहवेह ने मोशेह को सीनायी पर्वत पर आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“इस्राएल के घराने को यह आज्ञा दो: ‘जब तुम उस देश में प्रवेश करोगे, जो मैं तुम्हें दूंगा, तब याहवेह के लिए उस देश में एक शब्बाथ होगा. ");
INSERT INTO hincv_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","तुम छः वर्ष तो अपने खेत में बीज बोओगे और अंगूर की बारी की छंटाई तथा उसकी उपज इकट्ठा करोगे, ");
INSERT INTO hincv_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","किंतु सातवें वर्ष में भूमि के लिए शब्बाथ-विश्राम होगा याहवेह के लिए शब्बाथ; न तो तुम अपने खेतों में बीज बोना और न ही अपनी अंगूर की बारी की छंटाई करना. ");
INSERT INTO hincv_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","उपज इकट्ठा करने के बाद अपने आप उगी हुई उपज इकट्ठा न करना; यह भूमि के लिए शब्बाथ वर्ष होगा. ");
INSERT INTO hincv_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","7","शब्बाथ काल में भूमि से उत्पन्‍न उपज तुम सभी के भोजन के लिए होंगी—तुम्हारे लिए, तुम्हारे दासों और दासियों के लिए, मजदूरों के लिए, तुम्हारे बीच रह रहे विदेशियों के लिए, तुम्हारे पशुओं और तुम्हारे देश के जंगली पशुओं के लिए; यह उपज सभी के भोजन के लिए होगी. ");
INSERT INTO hincv_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘तुम सात शब्बाथ वर्षों की भी गिनती करना; सात गुणा सात वर्ष, कि ये सात शब्बाथ वर्ष अर्थात् उनचास वर्ष हों. ");
INSERT INTO hincv_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","सातवें माह के दसवें दिन ऊंची आवाज से तुरही फूंकोगे. प्रायश्चित दिवस पर पूरे देश में तुरही फूंकोगे. ");
INSERT INTO hincv_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","तुम्हें पचासवें वर्ष को पवित्र करना होगा और सारे देश के निवासियों के लिए छुटकारे की घोषणा करनी होगी. यह वर्ष तुम्हारे लिए योवेल वर्ष कहलाएगा और तुममें से हर एक की पैतृक संपत्ति अपने-अपने परिवार को लौट आएगा. ");
INSERT INTO hincv_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","पचासवां वर्ष योवेल वर्ष के रूप में मनाया जाए; इस वर्ष न तो तुम बीज बोना, न अपने आप उगी हुई फसल इकट्ठी करोगे और न उन अंगूर की लताओं से अंगूर इकट्ठा करोगे, जिन्हें छांटा न गया हो. ");
INSERT INTO hincv_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","क्योंकि यह योवेल है; यह तुम्हारे लिए पवित्र होगा. तुम खेतों की उपज को खा सकते हो. ");
INSERT INTO hincv_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘इस योवेल वर्ष में तुममें से हर एक अपनी पैतृक भूमि को लौट जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘यदि तुम अपने पड़ोसी को कुछ भी बेचो अथवा उससे कुछ भी खरीदो, तो तुम एक दूसरे से छल न करना. ");
INSERT INTO hincv_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","जब तुम अपने पड़ोसी से भूमि खरीदो, तो उसका मूल्य पिछले योवेल के बाद के वर्षों के अनुसार होना आवश्यक है, तथा बेचनेवाला भी इसका मूल्य अगले योवेल के पहले के वर्षों का ध्यान रखकर करे. ");
INSERT INTO hincv_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","यदि अगले योवेल तक के वर्षों की संख्या अधिक है, तो मूल्य बढ़ेगा, यदि वर्षों की संख्या कम है, तो मूल्य भी कम होगा. वस्तुतः वह व्यक्ति, जो भूमि को बेच रहा है, तुम्हें कटनियों की संख्या बेच रहा है. ");
INSERT INTO hincv_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","इसलिये तुम एक दूसरे से छल न करना, परंतु अपने परमेश्वर के प्रति श्रद्धा की भावना रखना; क्योंकि मैं याहवेह ही तुम्हारा परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘इसलिये तुम मेरी विधियों को मानना और मेरी आज्ञाओं का पालन कर उन्हें व्यवहार में लाना कि इस प्रकार तुम इस देश में सुरक्षापूर्वक निवास कर सको. ");
INSERT INTO hincv_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","तब भूमि अपनी उपज उत्पन्‍न करेगी, ताकि तुम इसको भरपेट खाया करो, और इस प्रकार तुम इस देश में सुरक्षापूर्वक रह सको. ");
INSERT INTO hincv_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","किंतु यदि तुम्हारा विचार यह हो, “यदि हमने सातवें वर्ष बीज नहीं बोया और उपज इकट्ठा नहीं की तो हम उस वर्ष क्या खाएंगे?” ");
INSERT INTO hincv_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","तब छठे वर्ष में मैं तुम्हारे लिए अपनी आशीषों को आदेश दूंगा कि भूमि तीन वर्षों के लिए पर्याप्‍त उपज उत्पन्‍न करे. ");
INSERT INTO hincv_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","जब तुम आठवें वर्ष बीज बोओगे, तो तब भी तुम बीते वर्षों में इकट्ठा की गई उपज को खा सकोगे, आठवें वर्ष की उपज आने पर भी तुम नौवें वर्ष तक इसको खा सकोगे. ");
INSERT INTO hincv_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘भूमि सदा के लिए बेची न जाए, क्योंकि भूमि तो मेरी है; तुम तो मेरे साथ परदेशी और बाहरी मात्र हो. ");
INSERT INTO hincv_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","जब भी भूमि को खरीदो, तो खरीददार यह ध्यान रखे कि बेचनेवाले को इसके छुड़ाने का अधिकार है. ");
INSERT INTO hincv_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘यदि तुम्हारा कोई संबंधी इतना निर्धन हो जाता है कि उसे अपनी संपत्ति के अंश को बेचना पड़ता है, तो उसके नज़दीकी छुड़ाने वाला आकर उस संपत्ति को खरीद ले, जो उसके संबंधी द्वारा बेची गई है. ");
INSERT INTO hincv_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","और यदि उस व्यक्ति का कोई छुड़ाने वाला नहीं है, किंतु वह स्वयं ही इतना समृद्ध हो गया है, और अपनी भूमि को छुड़ाने के लिए उसके पास पर्याप्‍त धन है, ");
INSERT INTO hincv_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","तो वह इसके बेचे गए वर्षों से गिनती करे और जिस व्यक्ति को उसने यह बेचा था, उसे इसका बाकी मूल्य चुका दे, और इस प्रकार उसे अपनी संपत्ति दोबारा प्राप्‍त हो जाएगी. ");
INSERT INTO hincv_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","किंतु, यदि उसके पास इसे दोबारा प्राप्‍त करने के लिए पर्याप्‍त धन नहीं है, तब जो कुछ उसने बेचा है, वह सब योवेल वर्ष तक उसके खरीददार के पास ही रहेगा; किंतु योवेल वर्ष में यह छूटकर इसके असली स्वामी के पास लौट जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘इसी प्रकार यदि कोई व्यक्ति शहरपनाह वाले नगर में अपने घर को बेचता है, तो उसके छुड़ाने का अधिकार उसके बेचने के दिन से एक वर्ष तक मान्य रहेगा; छुड़ाने का उसका अधिकार पूरे एक वर्ष तक बना रहेगा. ");
INSERT INTO hincv_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","किंतु यदि पूरे एक वर्ष की अवधि में इसको नहीं खरीदा गया, तब उस शहरपनाह वाले नगर में उस घर का अधिकार स्थायी रूप से उसके खरीददार और उसकी आनेवाली सभी पीढ़ियों का हो जाएगा; यह घर योवेल वर्ष में छुड़ाया नहीं जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","किंतु बिना शहरपनाह वाले गांवों के घरों को खेतों के बराबर समझा जाए; इनको छुड़ाया जा सकता है, और वे योवेल वर्ष में छुड़ा दिए जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘जहां तक लेवियों के नगरों का संबंध है, लेवियों को अपने नगरों के घरों के, जो उनकी संपत्ति हैं, छुड़ाने का स्थायी अधिकार है. ");
INSERT INTO hincv_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","इसलिये जो कुछ भी लेवियों का है, उसको छुड़ाया जा सकता है और नगर में उनकी संपत्ति से बेचा गया वह घर योवेल वर्ष में छुड़ा दिया जाएगा, क्योंकि इस्राएल के घराने के बीच लेवियों के नगरों के घर उनकी संपत्ति हैं. ");
INSERT INTO hincv_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","किंतु उनके नगरों के चारों ओर की चराई की भूमि को न बेचा जाए, क्योंकि यह उनकी स्थायी संपत्ति है. ");
INSERT INTO hincv_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘यदि तुम्हारा कोई भाई-बन्धु कंगाल हो जाए, और यदि वह अपना हाथ तुम्हारे सामने फैलाए, तो तुम उसकी ठीक उसी प्रकार सहायता करना, मानो वह कोई विदेशी अथवा यात्री हो ताकि वह तुम्हारे साथ रह सके. ");
INSERT INTO hincv_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","उससे ब्याज अथवा लाभ न लिया जाए, बल्कि तुम अपने परमेश्वर के प्रति श्रद्धा रखना कि तुम्हारा भाई-बन्धु तुम्हारे साथ रह सके. ");
INSERT INTO hincv_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","तुम उसे न तो अपना धन ब्याज पर दोगे और न ही भोजन लाभ कमाने के लालच से. ");
INSERT INTO hincv_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","मैं याहवेह ही तुम्हारा परमेश्वर हूं, जो तुम्हें मिस्र देश से इसलिये निकालकर लाया हूं, कि तुम्हें कनान देश प्रदान करूं, और तुम्हारे लिए तुम्हारा परमेश्वर हो जाऊं. ");
INSERT INTO hincv_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘यदि तुम्हारा कोई भाई-बन्धु इतना कंगाल हो जाए कि स्वयं को तुम्हें बेच दे, तो तुम उससे दास के समान सेवा न लेना. ");
INSERT INTO hincv_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","वह तुम्हारे साथ मजदूरी पानेवाले व्यक्ति के समान रहे, मानो कि वह कोई यात्री हो. वह तुम्हारे साथ योवेल वर्ष तक काम करेगा. ");
INSERT INTO hincv_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","फिर वह तुम्हारे अधिकार से मुक्त हो जाएगा, वह और उसके साथ उसकी संतान अपने गोत्र और अपने पूर्वजों की संपत्ति को लौट जाएगी. ");
INSERT INTO hincv_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","क्योंकि इस्राएल तो मेरे सेवक हैं, जिन्हें मैं मिस्र से निकालकर लाया था; उनको दास के समान बेचा न जाए. ");
INSERT INTO hincv_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","तुम उस पर कठोरता पूर्वक शासन न करना, बल्कि अपने परमेश्वर के प्रति श्रद्धा बनाए रखना. ");
INSERT INTO hincv_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘जहां तक तुम्हारे दास-दासियों का संबंध है, तुम अपने पड़ोसी गैर-यहूदी देशों से दास और दासियां प्राप्‍त कर सकते हो. ");
INSERT INTO hincv_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","तुम अपने बीच रह रहे यात्रियों से भी दासों को कर सकते हो तथा उनके गोत्रों से भी जिनका जन्म तुम्हारे देश में ही हुआ है, और वे तुम्हारे बीच ही रह रहे हैं; वे भी तुम्हारी संपत्ति हो सकते हैं. ");
INSERT INTO hincv_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","तुम उन्हें संपत्ति के समान अपने पुत्रों के अधिकार में स्थायी मीरास के रूप में भी दे सकते हो; तथा उनका प्रयोग स्थायी दासों के समान कर सकते हो. किंतु तुम इस्राएल के घराने में से अपने भाई-बंधुओं पर कठोरता पूर्वक शासन न करना. ");
INSERT INTO hincv_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘यदि तुम्हारे साथ का कोई विदेशी अथवा यात्री धनी हो जाए, और तुम्हारा कोई भाई-बन्धु कंगाल तथा वह स्वयं को उस विदेशी अथवा यात्री, या उस विदेशी के कुल को बेच दे, ");
INSERT INTO hincv_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","तो उसके बिकने के बाद उसको निकाला जा सकता है. उसके भाई-बंधुओं में से कोई एक भाई उसको छुड़ा सकता है, ");
INSERT INTO hincv_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","उसका चाचा अथवा उसके चाचा का पुत्र और उसके परिवार से कोई उसका कोई सगा संबंधी उसको छुड़ा सकता है, अथवा यदि वह धनी हो जाए, तो वह स्वयं को ही छुड़ा सकता है. ");
INSERT INTO hincv_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","वह अपने खरीददार के साथ अपने बिकने के दिन से लेकर योवेल वर्ष तक के समय की गिनती करे; उसके बिकने का मूल्य उसके द्वारा पिछले वर्षों के अनुसार हो. उसके द्वारा उसके स्वामी के साथ बिताया गया समय किसी मज़दूर द्वारा बिताए गए समय के समान ही है. ");
INSERT INTO hincv_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","किंतु यदि योवेल वर्ष तक अभी अनेक वर्ष बाकी हैं, तो वह अपने छुड़ाए जाने के लिए अपने बिकने के दाम के बराबर में लौटा दे. ");
INSERT INTO hincv_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","और यदि योवेल वर्ष में अभी कुछ ही वर्ष बाकी रह गए हैं, तो वह अपने स्वामी के साथ इनकी गिनती करे और उन वर्षों के अनुसार अपने छुड़ाने के मूल्य को लौटा दे. ");
INSERT INTO hincv_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","वह उसके साथ हर एक वर्ष मज़दूर के अनुसार ही रहेगा और वह तुम्हारे सामने उस पर कठोरता पूर्वक शासन न करे. ");
INSERT INTO hincv_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘किंतु यदि इनमें से किसी भी रीति से उसको छुड़ाया नहीं गया, तो योवेल वर्ष में वह छूट जाएगा; वह और उसके साथ उसकी संतान भी. ");
INSERT INTO hincv_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","क्योंकि इस्राएल का घराना मेरा दास है; ये मेरे वे दास हैं, जिन्हें मैं मिस्र देश से छुड़ाकर लाया हूं. मैं याहवेह ही तुम्हारा परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘न तो तुम अपने लिए मूरतें बनाओगे और न ही किसी खुदी हुई मूरत अथवा पवित्र पत्थर बनाओगे और न ही उसके सामने झुकने के उद्देश्य से किसी पत्थर में से मूरत गढ़ोगे; क्योंकि मैं याहवेह ही तुम्हारा परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘तुम मेरे शब्बाथों का पालन करो और मेरे पवित्र स्थान का सम्मान; मैं ही याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘यदि तुम मेरी विधियों का पालन करोगे और मेरी आज्ञाओं का पालन कर उन्हें व्यवहार में लाओगे, ");
INSERT INTO hincv_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","तो मैं वर्षा ऋतु में तुम्हें बारिश दिया करूंगा, जिसके परिणामस्वरूप भूमि अपनी उपज और मैदान के वृक्ष फल उत्पन्‍न करेंगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","तुम्हारी दांवनी तुम्हारी अंगूर की उपज इकट्ठा करने तक चलेगी और तुम्हारी अंगूर की उपज, बीज बोने तक. इस प्रकार तुम भरपेट भोजन करोगे और इस प्रकार तुम इस देश में सुरक्षापूर्वक निवास कर सकोगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘देश में मेरे द्वारा दी गई शांति बसेगी, जिससे कि तुम आराम कर सको. कोई तुम्हें भयभीत न करेगा. मैं उस देश से हिंसक पशुओं को भी दूर कर दूंगा और तुम्हारे देश में कोई भी तलवार से मारा न जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","किंतु तुम अपने शत्रुओं का पीछा करोगे और वे तलवार के वार से तुम्हारे सामने मारे जाएंगे; ");
INSERT INTO hincv_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","तुममें से पांच एक सौ को और एक सौ दस हज़ार को खदेड़ डालेंगे और तुम्हारे शत्रु तलवार के वार से तुम्हारे सामने मारे जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘फिर मैं तुम्हारी ओर कृपादृष्टि करूंगा और तुम्हें फलवंत कर तुम्हारी संख्या बहुत बढ़ाऊंगा और तुम्हारे साथ की गई मेरी वाचा को पूरी करूंगा. ");
INSERT INTO hincv_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","तुम पुरानी उपज को खाओगे और नई उपज को स्थान देने के उद्देश्य से पुरानी को हटा दोगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","इसके अलावा मैं तुम्हारे बीच निवास करूंगा और मेरा प्राण तुमसे घृणा न करेगा. ");
INSERT INTO hincv_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","मैं तुम्हारे बीच चला फिरा भी करूंगा. मैं तुम्हारा परमेश्वर हो जाऊंगा और तुम मेरी प्रजा. ");
INSERT INTO hincv_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","मैं याहवेह ही तुम्हारा परमेश्वर हूं, जो तुम्हें मिस्र देश से निकालकर लाया है कि तुम मिस्रियों के दास न बने रह जाओ, मैंने तुम्हारे जूए की पट्टियों को तोड़ दिया है और तुम्हें सीधा होकर चलने में समर्थ किया है. ");
INSERT INTO hincv_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘किंतु यदि तुम मेरी न सुनोगे और इन सारी आज्ञाओं का पालन नहीं करोगे, ");
INSERT INTO hincv_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","यदि तुम मेरी विधियों को नकार दोगे; तुम्हारे प्राण मेरे निर्णयों को इतना तुच्छ जानें कि तुम मेरी सारी आज्ञाओं का पालन करना ही छोड़ दो और इस प्रकार मेरी वाचा को तोड़ ही डालो, ");
INSERT INTO hincv_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","तो निश्चित ही मैं तुम्हारे साथ यह करूंगा कि मैं तुमको अचानक ही आतंक, क्षय रोग और ज्वर-पीड़ित कर दूंगा, जिसके कारण तुम्हारी आंखें धुंधली हो जाएंगी तथा तुम्हारे प्राण मुरझा जाएंगे, तुम्हारा बीजारोपण भी व्यर्थ ही होगा क्योंकि तुम्हारे शत्रु इसको खा लेंगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","मैं तुम्हारे विरुद्ध हो जाऊंगा, जिससे तुम्हारे शत्रु तुम्हें हरा देंगे और जो तुमसे घृणा करते हैं, वे तुम पर शासन करेंगे. जब तुम्हारा पीछा कोई भी न कर रहा होगा, तब भी तुम भागते रहोगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘इतना सब होने पर भी यदि तुम मेरी आज्ञा नहीं मानोगे, तो मैं तुम्हें तुम्हारे पापों का सात गुणा दंड दूंगा. ");
INSERT INTO hincv_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","मैं तुम्हारे बल के घमण्ड़ को समाप्‍त कर दूंगा और तुम्हारे आकाश को लोहे के समान और तुम्हारी भूमि को कांसे के समान बना दूंगा. ");
INSERT INTO hincv_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","तुम्हारे द्वारा की गई मेहनत बेकार होगी क्योंकि तुम्हारी भूमि अपनी उपज पैदा न करेगी और न ही देश के वृक्ष अपना फल उत्पन्‍न करेंगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘इतना होने पर भी यदि तुम अपना स्वभाव मेरे विरुद्ध ही रखोगे और मेरी आज्ञा न मानोगे, तो मैं तुम्हारे पापों के अनुसार तुम पर महामारी में सात गुणा वृद्धि कर दूंगा. ");
INSERT INTO hincv_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","मैं तुम पर जंगली जानवर भेज दूंगा, जो तुम्हें संतानहीन बना डालेंगे और तुम्हारे पशुओं को नष्ट कर डालेंगे. वे तुम्हारी संख्या इतनी कम कर देंगे, कि तुम्हारे रास्ते निर्जन रह जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘यदि इस ताड़ना के बाद भी तुम मेरी ओर न मुड़े, बल्कि मेरे विरुद्ध शत्रुता भाव ही बनाए रखा, ");
INSERT INTO hincv_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","तो मैं भी तुमसे शत्रुता भाव रखूंगा और मैं, हां मैं, तुम्हारे पापों के कारण तुम पर सात गुणा आक्रमण करूंगा. ");
INSERT INTO hincv_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","मैं तुम पर एक तलवार भेजूंगा, जो वाचा को तोड़ने का पूरा बदला लेगी. जब तुम अपने नगरों में इकट्‍ठे होंगे, मैं तुम्हारे बीच महामारी भेजूंगा, और तुम शत्रुओं के अधीन कर दिए जाओ. ");
INSERT INTO hincv_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","जब मैं तुम्हारे भोजन के आधार को दूर कर दूंगा, तब दस महिलाएं एक ही चूल्हे पर रोटी सेकेंगी और वे इन्हें तोल-तोल कर छोटी संख्या में बांट देंगी, कि तुम उनको खाओगे, परंतु तृप्‍त न होंगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘इतना सब होने पर भी यदि तुम मेरी आज्ञा का पालन नहीं करोगे, बल्कि मेरे विरुद्ध शत्रु सा व्यवहार ही बनाए रखोगे, ");
INSERT INTO hincv_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","तब मैं अत्यंत क्रोधित होकर तुमसे शत्रुता रखूंगा और मैं, हां मैं, तुम्हारे पापों के लिए तुम्हें सात गुणा दंड दूंगा. ");
INSERT INTO hincv_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","तुम अपने पुत्रों के मांस को खाओगे और हां, तुम अपनी पुत्रियों के मांस को खाओगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","मैं तुम्हारे ऊंचे पूजा स्थलों को नाश कर, तुम्हारी धूप वेदियों को तोड़ दूंगा, मैं तुम्हारे शवों को तुम्हारी मूर्तियों के ढेर पर फेंक दूंगा, और मेरा आत्मा तुमसे घृणा करेगा. ");
INSERT INTO hincv_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","मैं तुम्हारे नगरों को भी उजाड़ दूंगा और तुम्हारे पवित्र स्थानों को सूना कर दूंगा, मैं तुम्हारी सुखद-सुगंध को स्वीकार नहीं करूंगा. ");
INSERT INTO hincv_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","मैं तुम्हारे नगरों को सूना बना दूंगा जिससे कि तुम्हारे शत्रु जो वहां बसने आएंगे, इसे देख भयभीत हो जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","तुम जाति-जाति के बीच बिखर जाओगे और तलवार तुम्हारा पीछा करेगी, तुम्हारा देश निर्जन और तुम्हारे नगर उजाड़ हो जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","तुम्हारे इस भूमि पर निवास करने की स्थिति में, भूमि को जो विश्राम तुम्हारे शब्बाथों में प्राप्‍त नहीं हुआ था, वह उस विश्राम अब, इस पूरे खाली समय की अवधि में, प्राप्‍त होगा. इस प्रकार भूमि को अपने शब्बाथ प्राप्‍त हो जाएंगे. जब तुम अपने शत्रुओं के देश में जाओगे, तब सूनेपन की अवस्था में भूमि अपने शब्बाथों का आनंद उठाएगी. ");
INSERT INTO hincv_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘तुममें जो बचे रह गए होंगे, मैं उनके शत्रुओं के देश में उनका मनोबल इतना कमजोर कर दूंगा कि वे हवा के द्वारा छितराए पत्ते की खड़खड़ाहट सुनकर भाग खड़े होंगे. जब कोई उनका पीछा भी नहीं कर रहा होगा, तो भी वे भाग खड़े होंगे, मानो कोई तलवार लिए उनका पीछा कर रहा हो और वे गिर-गिर पड़ेंगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","वे लड़खड़ा कर एक दूसरे पर ऐसे गिरेंगे, मानो वे तलवार से भाग रहे हों, जबकि कोई भी उनका पीछा नहीं कर रहा होगा; तुम्हारे शत्रुओं के सामने खड़ा होने के लिए तुम्हारे अंदर शक्ति न बचेगी. ");
INSERT INTO hincv_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","तुम बंधुआई में देशों के बीच नाश हो जाओगे और तुम्हारे शत्रुओं का देश तुम्हें चट कर डालेगा; ");
INSERT INTO hincv_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","तुममें से जो बचे रह जाएंगे, वे अपने और उनके पुरखों के अधर्म के कारण उनके शत्रुओं के देश में गल जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘यदि वे अपनी और अपने पूर्वजों के उन अधर्मों को स्वीकार कर लेंगे, जो उन्होंने अपने विश्वासघात और मेरे विरुद्ध शत्रु के भाव की स्थिति में की थी, ");
INSERT INTO hincv_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","जिससे मैंने भी उनके विरुद्ध हो उन्हें उनके शत्रुओं के देश में बसा दिया; अथवा उनका खतना-रहित हृदय इस प्रकार दब जाए कि वे अपने अधर्मों के लिए प्रायश्चित्त कर लें, ");
INSERT INTO hincv_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","तो मैं याकोब के साथ अपनी वाचा को, यित्सहाक के साथ अपनी वाचा को और अब्राहाम के साथ अपनी वाचा को, और इस देश को भी स्मरण करूंगा. ");
INSERT INTO hincv_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","किंतु उनके निकल जाने के कारण यह देश सूना हो जाएगा, कि यह भूमि अपने शब्बाथों के नुकसान की पूर्ति कर ले. इसी अवधि में वे अपने अधर्मों के लिए प्रायश्चित करेंगे; क्योंकि उन्होंने मेरे नियमों को नकार दिया था और मेरी विधियों से घृणा की थी. ");
INSERT INTO hincv_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","इतना होने पर भी, जब वे अपने शत्रुओं के देश में होंगे, तब भी मैं उनको नहीं छोडूंगा और न ही उनसे इतनी घृणा करूंगा कि मैं उनका नाश कर दूं और उनके साथ अपनी वाचा को भंग करूं. मैं ही याहवेह, उनका परमेश्वर हूं. ");
INSERT INTO hincv_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","मैं उनके उन पूर्वजों से की गई वाचा को स्मरण करूंगा, जिन्हें मैं जातियों के देखते-देखते मिस्र से निकालकर लाया था कि मैं उनका परमेश्वर हो जाऊं. मैं ही याहवेह हूं.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","यही वे विधियां, व्यवस्था और नियम हैं, जिन्हें याहवेह ने, मोशेह के द्वारा सीनायी पर्वत पर अपने और इस्राएल के घराने के बीच ठहराई. ");
INSERT INTO hincv_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","याहवेह ने मोशेह को यह आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“इस्राएल के घराने को यह आज्ञा दो: ‘जब कोई किसी व्यक्ति को याहवेह के लिए भेंट करने की विशेष मन्नत माने, तो उस व्यक्ति के ठहराए हुए मूल्य को इस प्रकार तय किया जाए: ");
INSERT INTO hincv_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","बीस वर्ष से साठ वर्ष तक की आयु के पुरुष के लिए पवित्र स्थान के शेकेल के अनुसार चांदी के पचास शेकेल; ");
INSERT INTO hincv_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","यदि कोई स्त्री है, तो उसके लिए तीस शेकेल; ");
INSERT INTO hincv_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","पांच वर्ष से बीस वर्ष तक की आयु के युवक के लिए बीस शेकेल तथा युवती के लिए दस शेकेल; ");
INSERT INTO hincv_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","एक माह से पांच वर्ष तक की आयु के बालक के लिए चांदी के पांच शेकेल तथा बालिका के लिए चांदी के तीन शेकेल; ");
INSERT INTO hincv_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","साठ वर्ष और इससे ऊपर की आयु के पुरुष के लिए पन्द्रह शेकेल तथा स्त्री के लिए दस शेकेल. ");
INSERT INTO hincv_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","किंतु यदि कोई इतना कंगाल है कि वह ठहराया हुआ मूल्य न दे पाए, तो उसे पुरोहित के सामने ले जाए और पुरोहित उसका मूल्य तय करे. पुरोहित उस व्यक्ति के साधनों के अनुसार ही उसका मूल्य तय करेगा, जिसने मन्नत मानी है. ");
INSERT INTO hincv_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘यदि मन्नत के रूप में याहवेह को एक पशु भेंट किया जाना है, तो याहवेह को चढ़ाया गया पशु पवित्र माना जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","वह न तो इसको बदले, न तो अच्छे के लिए बुरा और न ही बुरे के लिए अच्छा. किंतु यदि कोई ऐसा बदला कर भी लेता है, तो वह पशु और उसके बदले दूसरा पशु दोनों ही पवित्र माने जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","किंतु यदि मन्नत का पशु अशुद्ध हो और याहवेह को बलि देने योग्य न हो, तो वह उस पशु को पुरोहित के सामने लाए. ");
INSERT INTO hincv_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","पुरोहित उसे अच्छा या बुरा ठहराए और जो पुरोहित तय करेगा, वही मान्य होगा. ");
INSERT INTO hincv_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","यदि वह उसको छुड़ाना चाहे, तो तय मूल्य के अलावा उसका पांचवा भाग भी चुकाए. ");
INSERT INTO hincv_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘यदि कोई अपना घर पवित्र कर याहवेह के लिए अलग करे, तो पुरोहित द्वारा इसको अच्छा या बुरा ठहराया जाए और जो पुरोहित तय करेगा, वह मान्य होगा. ");
INSERT INTO hincv_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","यदि वह व्यक्ति, जिसने इसे पवित्र किया है, वह अपने घर को छुड़ाना चाहे, तो तय मूल्य के अलावा उसका पांचवा भाग भी चुकाए, जिससे वह घर उसका हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘यदि कोई अपनी पैतृक संपत्ति के खेतों को याहवेह के लिए पवित्र करे, तो उसका मूल्य उसमें लगे बीज के अनुसार ठहराया जाए; बोने के लिए दस एफाह बीज के लिए चांदी के पचास शेकेल. ");
INSERT INTO hincv_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","यदि वह योवेल वर्ष से ही अपना खेत पवित्र करे, तो ठहराया गया मूल्य पूरा-पूरा दिया जाए; ");
INSERT INTO hincv_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","किंतु यदि वह योवेल वर्ष के बाद अपना खेत पवित्र करे, तो पुरोहित आनेवाले योवेल वर्ष तक जितने वर्ष बचे हैं, उनकी संख्या के अनुसार खेत का ठहराया हुआ मूल्य कम कर दे. ");
INSERT INTO hincv_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","यदि वह व्यक्ति, जिसने इसे पवित्र किया है, स्वयं इसे छुड़ाना चाहता है, तो ठहराए गए मूल्य के अलावा उसका पांचवा अंश भी चुकाए, कि वह खेत उसे लौटा दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","किंतु यदि वह उस खेत को नहीं छुड़ाना चाहता और उसे किसी दूसरे को बेच देता है, तब उस खेत को नहीं छुड़ाया जा सकता. ");
INSERT INTO hincv_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","यदि योवेल वर्ष में वह खेत छूट जाता है, तो वह याहवेह के लिए पवित्र खेत के समान अलग माना जाएगा. वह खेत पुरोहित की संपत्ति हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘यदि कोई व्यक्ति याहवेह के लिए ऐसा खेत पवित्र करे, जिसे उसने खरीदा हो और जो उसकी पैतृक संपत्ति का भाग न हो, ");
INSERT INTO hincv_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","तो पुरोहित योवेल वर्ष तक जितने वर्ष रह गए हों, उसके आधार पर उस खेत का मूल्य तय करे. और उस दिन पुरोहित तुम्हारे इस बेचने के दाम को याहवेह के लिए पवित्र दान के स्वरूप दे दे. ");
INSERT INTO hincv_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","योवेल वर्ष में वह खेत उस व्यक्ति को छोड़ दिया जाए जिससे उसने वह खेत खरीदा था, अर्थात् उस व्यक्ति को, जो उस खेत का असली स्वामी है. ");
INSERT INTO hincv_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","तुम्हारा हर एक बेचने का दाम ठहराए गए पवित्र स्थान के शेकेल के अनुसार ही हो. और एक शेकेल बीस गेरा का हो. ");
INSERT INTO hincv_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘किंतु पशुओं के पहलौठे पर सिर्फ याहवेह का अधिकार है, कोई भी उसे समर्पण न करे; चाहे वह बैल हो अथवा मेढ़ा, उस पर याहवेह का अधिकार है. ");
INSERT INTO hincv_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","किंतु अशुद्ध पशुओं के पहिलौठे के लिए वह ठहराए गए मूल्य के अलावा पांचवा अंश भी जोड़कर भुगतान कर उसको छुड़ा ले, यदि इसको छुड़ाया न गया हो, तो वह तुम्हारे ठहराए गए मूल्य पर बेच दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘परंतु यदि कोई व्यक्ति अपनी सारी संपत्ति में से, जो कुछ भी याहवेह के लिए अलग करता है—मनुष्य, पशु या पैतृक संपत्ति में से खेत; उसको न तो बेचा जाए और न ही उसको छुड़ाया जाए. जो कुछ याहवेह को पूरी तरह से समर्पित है, वह याहवेह के लिए परम पवित्र है. ");
INSERT INTO hincv_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘जो मनुष्य याहवेह के लिए अलग किया गया है, उसे छुड़ाया न जाए. ज़रूरी है कि उसका वध कर दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘भूमि का दसवां अंश, चाहे वह खेत की उपज का हो या वृक्षों के फलों का, उस पर याहवेह का अधिकार है. वह याहवेह के लिए पवित्र है. ");
INSERT INTO hincv_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","इसलिये यदि कोई अपने दसवें अंश का कुछ छुड़ाना चाहे, तो वह उसमें उसके ठहराए गए मूल्य का पांचवा अंश भी जोड़ दे. ");
INSERT INTO hincv_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","गाय-बैलों और भेड़-बकरियों का हर एक दसवां पशु, जो चरवाहे की लाठी के नीचे से निकलता है, वह याहवेह के लिए पवित्र है. ");
INSERT INTO hincv_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","वह उनमें अच्छे और बुरे पशु में भेद न करे और न उनको बदले. किंतु यदि कोई ऐसे बदल भी लेता है, तो वह पशु और उसके बदले के पशु दोनों ही पवित्र माने जाएंगे. इनको छुड़ाये न जाए.’ ” ");
INSERT INTO hincv_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","यही वे आदेश हैं, जिन्हें याहवेह ने मोशेह को इस्राएल के घराने के लिए सीनायी पर्वत पर दिए.");
INSERT INTO hincv_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","इस्राएल के घराने के मिस्र देश से निकल जाने के बाद दूसरे वर्ष के दूसरे महीने की पहली तारीख पर सीनायी के निर्जन प्रदेश में मिलनवाले तंबू में याहवेह ने मोशेह को यह आज्ञा दी: ");
INSERT INTO hincv_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“इस्राएल के घराने की सारी सभा की, उनके परिवारों की, उनके पितरों के अनुसार हर एक पुरुष की, व्यक्तिगत रूप से गिनती करना. ");
INSERT INTO hincv_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","यह आलेख उन सभी का होगा, जिनकी अवस्था बीस वर्ष तथा इससे अधिक की है, इस्राएल में जो भी युद्ध के लिए योग्य हैं, तुम तथा अहरोन उनके दल के अनुसार उनकी गिनती करोगे. ");
INSERT INTO hincv_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","इसके अलावा तुम्हारे साथ हर एक गोत्र का एक व्यक्ति पितरों का प्रधान रहेगा. ");
INSERT INTO hincv_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“तुम्हारी सहायता के लिए ठहराए गए पुरुषों के नाम ये हैं: “रियूबेन से शेदेउर का पुत्र एलिज़ुर; ");
INSERT INTO hincv_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","शिमओन से ज़ुरीशद्दाय का पुत्र शेलुमिएल; ");
INSERT INTO hincv_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","यूदाह से अम्मीनादाब का पुत्र नाहशोन; ");
INSERT INTO hincv_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","इस्साखार से ज़ुअर का पुत्र नेथानेल; ");
INSERT INTO hincv_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ज़ेबुलून से हेलोन का पुत्र एलियाब; ");
INSERT INTO hincv_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","योसेफ़ के पुत्रों में से: एफ्राईम में से अम्मीहूद का पुत्र एलीशामा; मनश्शेह में से पेदाहज़ुर का पुत्र गमालिएल; ");
INSERT INTO hincv_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","बिन्यामिन से गिदयोनी का पुत्र अबीदान; ");
INSERT INTO hincv_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","दान से अम्मीशद्दाय का पुत्र अहीएज़र; ");
INSERT INTO hincv_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","आशेर से ओखरन का पुत्र पागिएल; ");
INSERT INTO hincv_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","गाद से देउएल का पुत्र एलियासाफ़; ");
INSERT INTO hincv_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","नफताली से एनन का पुत्र अहीरा.” ");
INSERT INTO hincv_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ये वे व्यक्ति थे, जिनका चुनाव सारी सभा में किया गया. ये पैतृक गोत्रों के प्रधान तथा इस्राएल के गोत्र के प्रमुख थे. ");
INSERT INTO hincv_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","फिर मोशेह तथा अहरोन ने इन चुने हुए व्यक्तियों को अपने साथ लिया, ");
INSERT INTO hincv_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","तथा उन्होंने सारी सभा को इकट्ठा कर लिया, यह दूसरे महीने की पहली तारीख थी. फिर सभी ने अपने पूर्वजों के नाम के अनुसार और अपने गोत्रों एवं परिवारों के अनुसार, जितने भी बीस वर्ष अथवा इससे अधिक आयु के थे, व्यक्तिगत रूप से अपना अपना पंजीकरण करवाया, ");
INSERT INTO hincv_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ठीक जैसा याहवेह ने मोशेह को आदेश दिया था. इस प्रकार मोशेह द्वारा सीनायी निर्जन प्रदेश में यह जनगणना पूरी हुई. ");
INSERT INTO hincv_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","इस्राएल के प्रथमजात रियूबेन के वंशज: बीस अथवा इससे अधिक आयु के वे पुरुष, जो युद्ध के लिए योग्य थे, उनके पितरों के कुटुंब, एवं परिवारों के अनुसार. ");
INSERT INTO hincv_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","इस प्रकार रियूबेन के गोत्र के 46,500 पुरुष नामांकित कर लिए गए. ");
INSERT INTO hincv_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","शिमओन के वंशज: बीस अथवा इससे अधिक आयु के वे सारे पुरुष, जो युद्ध के लिए योग्य थे, उनके कुटुंब, उनके पितरों एवं परिवारों के अनुसार; ");
INSERT INTO hincv_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","शिमओन के गोत्र से 59,300. ");
INSERT INTO hincv_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","गाद के वंशज: बीस अथवा इससे अधिक आयु के वे सारे पुरुष, जो युद्ध के लिए योग्य थे, उनके कुटुंब, उनके पितरों एवं परिवारों के अनुसार, ");
INSERT INTO hincv_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","गाद के गोत्र से 45,650. ");
INSERT INTO hincv_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","यहूदाह के वंशज: बीस अथवा इससे अधिक आयु के वे सारे पुरुष, जो युद्ध के लिए योग्य थे, उनके कुटुंब, उनके पितरों एवं परिवारों के अनुसार, ");
INSERT INTO hincv_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","यहूदाह के गोत्र से 74,600. ");
INSERT INTO hincv_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","इस्साखार के वंशज: बीस अथवा इससे अधिक आयु के वे सारे पुरुष, जो युद्ध के लिए योग्य थे, उनके कुटुंब, उनके पितरों एवं परिवारों के अनुसार, ");
INSERT INTO hincv_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","इस्साखार के गोत्र से 54,400. ");
INSERT INTO hincv_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ज़ेबुलून के वंशज: बीस अथवा इससे अधिक आयु के वे सारे पुरुष, जो युद्ध के लिए योग्य थे, उनके कुटुंब, उनके पितरों एवं परिवारों के अनुसार, ");
INSERT INTO hincv_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ज़ेबुलून के गोत्र से 57,400. ");
INSERT INTO hincv_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","योसेफ़-पुत्र: एफ्राईम के वंशज: बीस अथवा इससे अधिक आयु के वे सारे पुरुष, जो युद्ध के लिए योग्य थे, उनके कुटुंब, उनके पितरों एवं परिवारों के अनुसार, ");
INSERT INTO hincv_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","एफ्राईम के गोत्र से 40,500. ");
INSERT INTO hincv_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","योसेफ़-पुत्र मनश्शेह के वंशज: बीस अथवा इससे अधिक आयु के वे सारे पुरुष, जो युद्ध के लिए योग्य थे, उनके कुटुंब, उनके पितरों एवं परिवारों के अनुसार, ");
INSERT INTO hincv_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","मनश्शेह के गोत्र से 32,200. ");
INSERT INTO hincv_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","बिन्यामिन के वंशज: बीस अथवा इससे अधिक आयु के वे सारे पुरुष, जो युद्ध के लिए योग्य थे, उनके कुटुंब, उनके पितरों एवं परिवारों के अनुसार, ");
INSERT INTO hincv_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","बिन्यामिन के गोत्र से 35,400. ");
INSERT INTO hincv_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","दान के वंशज: बीस अथवा इससे अधिक आयु के वे सारे पुरुष, जो युद्ध के लिए योग्य थे, उनके कुटुंब, उनके पितरों एवं परिवारों के अनुसार, ");
INSERT INTO hincv_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","दान के गोत्र से 62,700. ");
INSERT INTO hincv_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","आशेर के वंशज: बीस अथवा इससे अधिक आयु के वे सारे पुरुष, जो युद्ध के लिए योग्य थे, उनके कुटुंब, उनके पितरों एवं परिवारों के अनुसार, ");
INSERT INTO hincv_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","आशेर के गोत्र से 41,500. ");
INSERT INTO hincv_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","नफताली के वंशज: बीस अथवा इससे अधिक आयु के वे सारे पुरुष, जो युद्ध के लिए योग्य थे, उनके कुटुंब, उनके पितरों एवं परिवारों के अनुसार, ");
INSERT INTO hincv_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","नफताली के गोत्र से 53,400. ");
INSERT INTO hincv_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ये सभी वे हैं, जो मोशेह तथा अहरोन और इस्राएल के बारह गोत्र के प्रधानों द्वारा जो अपने-अपने परिवारों का प्रतिनिधित्व करते हैं, इस गणना में गिने गए थे. ");
INSERT INTO hincv_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","फिर उनके पितरों के अनुसार बीस वर्ष तथा इससे अधिक अवस्था के युद्ध के लिए योग्य इस्राएल के सभी पुरुषों की गिनती की गई. ");
INSERT INTO hincv_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","गणित पुरुषों की संख्या कुल 6,03,550 हुई. ");
INSERT INTO hincv_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","किंतु लेवियों के गोत्र की गिनती उनके पितरों के अनुसार उनमें नहीं की गई. ");
INSERT INTO hincv_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","क्योंकि याहवेह मोशेह को यह संदेश दे चुके थे: ");
INSERT INTO hincv_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“मात्र लेवी गोत्र की गिनती न की जाए, वे इस्राएल के घराने की गिनती में शामिल नहीं होंगे. ");
INSERT INTO hincv_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","किंतु तुम लेवियों को साक्षी के तंबू, इससे संबंधित सारी सज्जा तथा इसकी सारी सामग्री के लिए नियुक्त करोगे. वे ही साक्षी के तंबू तथा इससे संबंधित सारी वस्तुओं को उठाया करेंगे, वे ही इनके रख रखाव के अधिकारी होंगे. इसके अलावा वे साक्षी के तंबू के आस-पास पड़ाव डाला करेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","जब कभी साक्षी के तंबू को यात्रा के पहले गिराना आवश्यक हो, तब लेवी ही इसे गिराएंगे, तथा जब कभी पड़ाव डालना ज़रूरी हो जाए, तो लेवी ही इसे खड़ा करेंगे. इस अवसर पर यदि कोई सामान्य व्यक्ति निकट आ जाए, उसे मृत्युदण्ड दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","सारा इस्राएल अपने-अपने दल के अनुसार डेरा डालेगा, हर एक अपने-अपने ठहराए गए समूह में तथा अपने-अपने झंडे के निकट डेरा डाला करेगा. ");
INSERT INTO hincv_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","किंतु लेवी हमेशा ही साक्षी के तंबू के आस-पास ही पड़ाव डाला करेंगे कि इस्राएल के घराने पर मेरा क्रोध न भड़के. तब लेवी ही साक्षी के तंबू के अधिकारी होंगे.” ");
INSERT INTO hincv_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","इस्राएल के घराने ने यही किया, जैसा याहवेह द्वारा मोशेह को आज्ञा दी गई थी. ");
INSERT INTO hincv_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","याहवेह ने मोशेह तथा अहरोन को यह आज्ञा दी: ");
INSERT INTO hincv_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“इस्राएल के वंश प्रत्येक अपने-अपने झंडे के नीचे ही पड़ाव डाला करेंगे. ये झंडे उनके पिता के गोत्रों की निशानी होंगे. वे मिलनवाले तंबू के आस-पास उसकी ओर मुख किए हुए अपने-अपने शिविर खड़े करेंगे.” ");
INSERT INTO hincv_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","वे, जो अपने शिविर सूर्योदय की दिशा, पूर्व में स्थापित करेंगे, वह होगा यहूदाह गोत्र, वे अपने शिविर अपने झंडे के नीचे स्थापित करेंगे. यहूदाह के गोत्र का प्रधान होगा अम्मीनादाब का पुत्र नाहशोन. ");
INSERT INTO hincv_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","उनके सैनिकों की संख्या है 74,600. ");
INSERT INTO hincv_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","उनके निकट होगा इस्साखार का शिविर. इस्साखार के गोत्र का प्रधान होगा ज़ुअर का पुत्र नेथानेल. ");
INSERT INTO hincv_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","उसके सैनिकों की संख्या है 54,400. ");
INSERT INTO hincv_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","इसके बाद होगा ज़ेबुलून का शिविर. ज़ेबुलून गोत्र का प्रधान होगा हेलोन का पुत्र एलियाब ");
INSERT INTO hincv_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","उसके सैनिकों की संख्या है 57,400. ");
INSERT INTO hincv_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","यहूदाह के शिविर के लिए गिने गए सैनिक, जिन्हें उनके दलों के अनुसार तैयार किया गया था, वे गिनती में 1,86,400 थे. वे सबसे पहले कूच करेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","दक्षिण दिशा: ये रियूबेन के झंडे के नीचे उसके सैनिकों का शिविर होगा तथा रियूबेन गोत्र का प्रधान शेदेउर का पुत्र एलिज़ुर होगा. ");
INSERT INTO hincv_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","उसके सैनिकों की संख्या है 46,500. ");
INSERT INTO hincv_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","इसके पास वाला शिविर होगा शिमओन गोत्र का, तथा उनका प्रधान होगा ज़ुरीशद्दाय का पुत्र शेलुमिएल. ");
INSERT INTO hincv_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","इनके सैनिकों की संख्या है 59,300. ");
INSERT INTO hincv_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","इसके बाद गाद का गोत्र, और इनका प्रधान था देउएल का पुत्र एलियासाफ़. ");
INSERT INTO hincv_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","इसके सैनिकों की संख्या है 45,650. ");
INSERT INTO hincv_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","रियूबेन के शिविर के गिने गए सैनिकों की संख्या है 1,51,450. ये कूच करते हुए दूसरे स्थान पर रहा करेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","इनके बाद मिलन वाला तंबू और लेवियों का शिविर कूच करेगा. लेवियों का शिविर सारे शिविरों के बीच होगा. जिस प्रकार वे अपने शिविर स्थापित करते हैं, उसी क्रम में वे कूच करेंगे; अपने-अपने झंडों के साथ. ");
INSERT INTO hincv_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","पश्चिमी दिशा में: उनके झंडे के नीचे एफ्राईम गोत्र की सेना का शिविर होगा. इनका प्रधान होगा अम्मीहूद का पुत्र एलीशामा. ");
INSERT INTO hincv_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","उसकी सेना की, गिन कर लिखी गई संख्या है 40,500. ");
INSERT INTO hincv_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","उसके पास होंगे मनश्शेह के गोत्र. उनका प्रधान था पेदाहज़ुर का पुत्र गमालिएल. ");
INSERT INTO hincv_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","उनके सैनिकों की संख्या है 32,200. ");
INSERT INTO hincv_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","इसके बाद बिन्यामिन गोत्र के लोग. उनका प्रधान था गिदयोनी का पुत्र अबीदान. ");
INSERT INTO hincv_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","उसके सैनिकों की संख्या 35,400 गिनी गई. ");
INSERT INTO hincv_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","एफ्राईम गोत्र के दलों के अनुसार की गई सैनिकों की गिनती में संख्या है, 1,08,100. यात्रा के अवसर पर वे तीसरे स्थान पर रहेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","उत्तर दिशा में उनके झंडे के नीचे दान गोत्र के सैनिकों का स्थान होगा. इनका प्रधान था अम्मीशद्दाय का पुत्र अहीएज़र. ");
INSERT INTO hincv_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","उसके सैनिकों की संख्या है 62,700. ");
INSERT INTO hincv_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","इनसे लगा हुआ दूसरा शिविर आशेर गोत्र का होगा. इनका प्रधान था ओखरन का पुत्र पागिएल. ");
INSERT INTO hincv_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","इसके गिने हुए सैनिकों की संख्या है 41,500 ");
INSERT INTO hincv_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","इसके बाद होगा नफताली गोत्र का शिविर. इनका प्रधान था एनन का पुत्र अहीरा. ");
INSERT INTO hincv_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","उसके सैनिक गिनती में 53,400 थे. ");
INSERT INTO hincv_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","दान के सैनिकों की संख्या हुई 1,57,600. वे सभी अपने-अपने झंडे के नीचे सबसे पीछे चला करेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ये ही थे सारे इस्राएली, जिनकी गिनती उनके गोत्रों के अनुसार की गई थी. वे सभी, जिनकी गिनती उनके दलों के अनुसार की गई थी, संख्या में 6,03,550 थे. ");
INSERT INTO hincv_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","किंतु इस गिनती में लेवी नहीं गिने गए, क्योंकि यह मोशेह को दी गई याहवेह की आज्ञा थी. ");
INSERT INTO hincv_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","इस्राएल के घराने ने यह प्रक्रिया पूरी कर ली. वे मोशेह को दी गई याहवेह की आज्ञा के अनुसार शिविर डाला करते थे, इसी क्रम में अपने-अपने गोत्र के अनुसार अपने-अपने गोत्र और कुटुंब में यात्रा करते थे. ");
INSERT INTO hincv_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","जब याहवेह ने मोशेह से सीनायी पर्वत पर बातें की, तब मोशेह तथा अहरोन की पीढ़ियां इस प्रकार थीं: ");
INSERT INTO hincv_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","अहरोन के पुत्रों के नाम: जेठा पुत्र नादाब फिर अबीहू, एलिएज़र तथा इथामार. ");
INSERT INTO hincv_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","अहरोन के ये पुत्र अभिषिक्त पुरोहित थे. इन्हें अहरोन ने ही पुरोहित होने के लिए अभिषिक्त किया था. ");
INSERT INTO hincv_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","इनमें नादाब तथा अबीहू की मृत्यु उस परिस्थिति में याहवेह के ही सामने हो गई थी, जब उन्होंने सीनायी के निर्जन प्रदेश के रास्ते याहवेह को भेंट चढ़ाई, किंतु उन्होंने अपवित्र आग का उपयोग किया. ये दोनों निस्संतान थे. इस कारण एलिएज़र तथा इथामार ही अपने पिता अहरोन के जीवनकाल में पुरोहित का काम करते रहे. ");
INSERT INTO hincv_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","फिर याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“लेवी गोत्र को बुलाकर उन्हें अहरोन की उपस्थिति में ले जाओ ताकि वे पुरोहित अहरोन की सहायता के लिए तैयार रहें. ");
INSERT INTO hincv_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","वे मिलनवाले तंबू के सामने उपस्थित रहते हुए अहरोन तथा सारे इस्राएल के लिए अपनी सेवा किया करें, जिससे यह उनके लिए साक्षी के तंबू की सेवा हो. ");
INSERT INTO hincv_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","इस्राएलियों से ज़िम्मेदारियों को निभाने के अलावा वे मिलनवाले तंबू की वस्तुओं का ध्यान रखेंगे, यह उनकी साक्षी के तंबू संबंधित सेवा होगी. ");
INSERT INTO hincv_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","इस प्रबंध के अंतर्गत तुम सारे लेवियों को अहरोन तथा उनके पुत्रों के अधीन कर दोगे, वे सारे इस्राएल में से उन्हें सौंप दिए गए हैं. ");
INSERT INTO hincv_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","इस प्रकार तुम अहरोन तथा उसके पुत्रों को नियुक्त कर दोगे, कि वे पुरोहित के रूप में सेवा करते रहें, किंतु जो भी साधारण व्यक्ति साक्षी के तंबू के निकट आ जाए, उसे प्राण-दंड दे दिया जाए.” ");
INSERT INTO hincv_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","याहवेह ने मोशेह को यह आदेश भी दिया, ");
INSERT INTO hincv_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“अब यह देखो, मैंने लेवी को, सारे इस्राएल में से प्रत्येक पहलौठे के स्थान पर, अर्थात् उस संतान के स्थान पर, जो गर्भ का प्रथम फल होता है, अलग कर लिया है, कि लेवी सिर्फ मेरे होकर रहें. ");
INSERT INTO hincv_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","क्योंकि सभी पहलौठे मेरे हैं. जिस दिन मैंने मिस्र देश में सारे पहिलौठों को मारा, मैंने इस्राएल के घराने में से सभी पहिलौठों को अपने लिए अलग कर लिया था; मनुष्यों एवं पशुओं, दोनों में से. वे मेरे रहेंगे. मैं याहवेह हूं.” ");
INSERT INTO hincv_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","इसके बाद याहवेह ने सीनायी के निर्जन प्रदेश में मोशेह को यह आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“तुम लेवी के वंश की, उनके गोत्र तथा उनके परिवारों के अनुसार, गिनती करोगे; हर एक नर बालक की जिसकी आयु एक महीने से अधिक है.” ");
INSERT INTO hincv_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","इसलिये मोशेह ने उन्हें जैसी आज्ञा दी थी, याहवेह की आज्ञा के अनुसार उनकी गिनती की. ");
INSERT INTO hincv_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","उनके नामों के अनुसार लेवी के पुत्र इस प्रकार थे: गेरशोन, कोहाथ, तथा मेरारी. ");
INSERT INTO hincv_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","परिवारों के अनुसार गेरशोन के पुत्र: लिबनी तथा शिमेई. ");
INSERT INTO hincv_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","परिवारों के अनुसार कोहाथ के पुत्र: अमराम, इज़हार, हेब्रोन तथा उज्ज़िएल. ");
INSERT INTO hincv_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","परिवारों के अनुसार मेरारी के पुत्र: माहली तथा मूशी ये ही हैं. लेवियों के परिवार उनके पितरों के घरानों के अनुसार. ");
INSERT INTO hincv_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","गेरशोन से लिबनियों तथा शिमेईयों के परिवारों का गोत्र निकला और ये गेरशोनियों का परिवार कहलाए. ");
INSERT INTO hincv_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","जब एक माह से ऊपर की अवस्था के नर गिने गए; उनकी संख्या 7,500 थी. ");
INSERT INTO hincv_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","गेरशोनियों के परिवारों के लिए यह तय किया गया कि वे साक्षी के तंबू के पीछे पश्चिम दिशा में अपने शिविर डाला करेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","गेरशोनियों के घराने का प्रधान था लाएल का पुत्र एलियासाफ़. ");
INSERT INTO hincv_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","गेरशोन-वंशजों के लिए मिलनवाले तंबू के संबंध में निर्धारित कार्य था साक्षी के तंबू का आंगन, उसके आवरण तथा मिलनवाले तंबू के द्वार का पर्दा, ");
INSERT INTO hincv_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","आंगन के पर्दे, उस आंगन के द्वार का पर्दा, जो वेदी एवं साक्षी के तंबू के चारों ओर है, उसकी डोरियां, जो इनसे संबंधित विधियों के अनुसार प्रयोग की जाती हैं. ");
INSERT INTO hincv_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","कोहाथ से अमरामियों का, इज़हारियों का, हेब्रोनियों का तथा उज्जिएलियों के परिवारों का कुल निकला; ये ही कोहाथियों के परिवार थे. ");
INSERT INTO hincv_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","जब एक महीने से अधिक आयु के हर एक पुरुष की गिनती की गई, तो संख्या 8,600 पाई गई. ये पवित्र स्थान से संबंधित कार्य किया करते थे. ");
INSERT INTO hincv_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","इनके शिविर डालने के लिए ठहराया हुआ स्थान साक्षी के तंबू का दक्षिणी इलाका था. ");
INSERT INTO hincv_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","कोहाथियों के गोत्रों के परिवारों का प्रधान था उज्ज़िएल का पुत्र एलिज़ाफ़ान. ");
INSERT INTO hincv_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","इनके लिए ठहराई हुई ज़िम्मेदारी थी: वाचा का संदूक, मेज़, दीवट, वेदियां, उन्हीं के द्वारा उपयोग किए जानेवाले पवित्र स्थान के सारे बर्तन, पर्दे तथा उनसे संबंधित सारी सेवाएं. ");
INSERT INTO hincv_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","लेवियों का प्रमुख प्रधान था पुरोहित अहरोन का पुत्र एलिएज़र. इसे ही पवित्र स्थान से संबंधित सारी सेवाओं की देखभाल करनी होती थी. ");
INSERT INTO hincv_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","मेरारी से माहलियों तथा मुशियों के परिवारों का कुल निकला, जो मेरारी के परिवार कहलाए. ");
INSERT INTO hincv_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","जब एक महीने से ऊपर की आयु के पुरुष गिने गए; उनकी संख्या 6,200 थी. ");
INSERT INTO hincv_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","मेरारी के कुल के परिवारों का प्रधान था अबीहाइल का पुत्र ज़ूरिएल. इनके शिविर के लिए ठहराया हुआ स्थान साक्षी के तंबू के उत्तर में था. ");
INSERT INTO hincv_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","मेरारी के वंशजों के लिए ठहराया हुआ कार्य यह था: साक्षी के तंबू के चौखट, उसकी छड़ें, उसके खंभे, उसके आधारपात्र, उसका सारा सामान तथा इन सबसे संबंधित सारे कार्य, ");
INSERT INTO hincv_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","तथा आंगन के आस-पास के खंभे तथा उनके आधारपात्र, उनकी खूंटियां तथा उनकी डोरियां. ");
INSERT INTO hincv_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","वे, जिन्हें सूर्योदय की दिशा, साक्षी के तंबू के पूर्व में मिलनवाले तंबू के सामने शिविर डालने के लिए नियुक्त किया गया था, वे मोशेह एवं अहरोन तथा उनके पुत्र हैं. वे पवित्र स्थान से संबंधित कार्यों की रखवाली करेंगे, जो इस्राएल के प्रति उनका कर्तव्य होगा. किंतु यदि कोई साधारण व्यक्ति पवित्र स्थान के निकट आए, तो उसको मार दिया जायेगा. ");
INSERT INTO hincv_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","याहवेह द्वारा मोशेह एवं अहरोन को दी गई आज्ञा के अंतर्गत, जो गिनती उनके परिवारों के अनुसार की गई थी, हर एक महीने से ऊपर की आयु के पुरुष की गिनती से प्राप्‍त कुल संख्या थी 22,000. ");
INSERT INTO hincv_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","इसके बाद याहवेह ने मोशेह को आज्ञा दी, “इस्राएल में एक महीने से अधिक आयु के हर एक पुरुष की गिनती करो तथा उनके नामों की सूची बनाओ. ");
INSERT INTO hincv_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","इस्राएल के घराने के पहिलौठों के तथा इस्राएल के पशुओं के पहिलौठों के स्थान पर तुम मेरे लिए लेवियों को अलग कर लोगे. मैं ही वह याहवेह हूं.” ");
INSERT INTO hincv_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","इसलिये मोशेह ने इस्राएल के घराने के सभी पहिलौंठों की गिनती की, जैसा कि उन्हें याहवेह की ओर से आज्ञा दी गई थी. ");
INSERT INTO hincv_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ये सभी एक महीने से अधिक आयु के पुरुष थे, जिनकी गिनती नामों एवं संख्या के आधार पर की गई. इनकी संख्या कुल 22,273 हुई. ");
INSERT INTO hincv_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","इसके बाद याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“इस्राएल के घराने के सभी पहिलौठों के स्थान पर, लेवियों एवं उनके पशुओं को अलग कर लो. लेवी मेरे होंगे. मैं ही वह याहवेह हूं. ");
INSERT INTO hincv_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","इस्राएल के घराने के 273 पहिलौठों की छुड़ौती के लिए, जो लेवियों की संख्या से अधिक हैं, ");
INSERT INTO hincv_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","तुम प्रति व्यक्ति पांच शेकेल लोगे; तथा ये शेकेल पवित्र स्थान के मानक शेकेल होंगे एक शेकेल में बीस गेराह. ");
INSERT INTO hincv_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","तुम यह छुड़ौती की राशि अहरोन तथा उसके पुत्रों को सौंप दोगे.” ");
INSERT INTO hincv_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","इसलिये मोशेह ने उन व्यक्तियों से, जो लेवियों की संख्या के अलावा थे, वह छुड़ौती की राशि इकट्ठी कर ली, उनके अलावा, जो लेवियों की संख्या के अलावा थे. ");
INSERT INTO hincv_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","इस्राएल के पहिलौठों से उन्होंने पवित्र स्थान के मानक शेकेल में धनराशि इकट्ठी कर ली, जो 1,365 शेकेल थी. ");
INSERT INTO hincv_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","यह राशि मोशेह ने अहरोन एवं उसके पुत्रों को, याहवेह के आदेश के अनुसार, जैसा आदेश उन्होंने मोशेह को दिया था, सौंप दी. ");
INSERT INTO hincv_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","इसके बाद याहवेह ने मोशेह तथा अहरोन को यह आज्ञा दी: ");
INSERT INTO hincv_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“लेवी के घराने में से, परिवारों के अनुसार कोहाथ के घराने की गिनती उनके कुल और परिवारों के अनुसार करो. ");
INSERT INTO hincv_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","तीस से पचास वर्ष की आयु के सभी पुरुषों की गणना करोगे. ये वे सभी होंगे, जो मिलनवाले तंबू में सेवा करने के लिए चुने जाते हैं. ");
INSERT INTO hincv_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“कोहाथ के घराने के लिए मिलनवाले तंबू में परम पवित्र वस्तुओं के उपयोग से संबंधित कार्य यह होगा. ");
INSERT INTO hincv_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","जब यात्रा के लिए छावनी कूच करने पर हो, तब अहरोन एवं उसके पुत्र भीतर जाकर ढंकने वाले पर्दे को उतारेंगे और साक्षी पत्र के संदूक को इससे ढांक देंगे. ");
INSERT INTO hincv_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","इसके बाद वे इस पर सूंस की खाल फैला देंगे तथा इस पर वे संपूर्ण नीले रंग के वस्त्र को फैलाकर संदूक के दोनों डंड़े उनके स्थानों में पिरो देंगे. ");
INSERT INTO hincv_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“उपस्थिति रोटी की मेज़ पर भी वे एक संपूर्ण नीले रंग का वस्त्र फैला देंगे और इस पर वे बर्तन, बलि के कटोरे तथा पेय बलि की सुराहियां रख देंगे. उस पर वहां सदैव रखी जाने के लिए नियत रोटी भी रखी जाना ज़रूरी है. ");
INSERT INTO hincv_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","इन सबके ऊपर वे एक लाल रंग का वस्त्र फैला देंगे तथा इसके भी ऊपर होगी सूंस की खाल. इसके बाद वे इसके डंड़े उनके स्थान पर पिरो देंगे. ");
INSERT INTO hincv_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“फिर वे एक नीले रंग के वस्त्र से दीवट को इसके दीपों एवं इन्हें बुझाने के उपकरण के साथ ही ढांक देंगे, इसके अलावा इसके साथ उपयोग होनेवाले बर्तन, तेल के बर्तन, जो इसके साथ ही इस्तेमाल किए जाते हैं. ");
INSERT INTO hincv_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","इन सभी बर्तनों को वे सूंस की खाल से ढांक देंगे तथा इसे वे उठानेवाले डंडों पर रख देंगे. ");
INSERT INTO hincv_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“सोने की वेदी पर वे एक नीले रंग का वस्त्र फैला देंगे इसके बाद वे इसे सूंस की खाल से ढांक कर और फिर डंडों को इसमें पिरो देंगे. ");
INSERT INTO hincv_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“इसके बाद वे पवित्र स्थान में प्रयोग के लिए ठहराए गए सभी बर्तन लेकर उन्हें एक नीले रंग के वस्त्र में रख देंगे, इसे सूंस की खाल से ढांक देंगे, और तब उठाने के डंड़े इसमें पिरो देंगे. ");
INSERT INTO hincv_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“वे वेदी की राख को हटाकर उसे एक बैंगनी वस्त्र से ढांक देंगे. ");
INSERT INTO hincv_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","वे इसके साथ ही इससे संबंधित सारे बर्तन उस पर रख देंगे: अग्नि पात्र, अंगीठियां, कांटे, फावड़े, चिलमचियां तथा वेदी से संबंधित पात्र तथा इन सब पर वे सूंस की खाल फैला देंगे और तब उठाने के डंड़े उसके स्थान पर पिरो देंगे. ");
INSERT INTO hincv_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“जब अहरोन एवं उसके पुत्र पवित्र वस्तुओं तथा पवित्र स्थान के वस्त्रों को ढांक चुकें, और छावनी कूच के लिए तैयार हो, कोहाथ के पुत्र उनको उठाने जाएं, वे यह ध्यान रखें कि किसी भी पवित्र वस्तु से वे छू न जाएं; नहीं तो उनकी मृत्यु तय है. कोहाथ के घराने की यह ज़िम्मेदारी है कि वे मिलनवाले तंबू की इन वस्तुओं को उठाया करें. ");
INSERT INTO hincv_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“अहरोन के पुत्र पुरोहित एलिएज़र को, दीपों के लिए उपयोग में लाए जानेवाले तेल, सुगंधधूप, नित्य अन्‍नबलि, अभिषेक के तेल; अर्थात् पूरे साक्षी के तंबू तथा उसमें रखी वस्तुओं, पवित्र स्थान तथा संबंधित वस्तुओं की पूरी ज़िम्मेदारी होगी.” ");
INSERT INTO hincv_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","इसके बाद याहवेह ने मोशेह तथा अहरोन को यह आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“यह ध्यान रखना कि लेवियों में से कोहाथियों के परिवार नष्ट न हो जाएं. ");
INSERT INTO hincv_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","किंतु जब वे पवित्र वस्तुओं के निकट जाएं, तो उनके जीवन की सुरक्षा की दृष्टि से यह अवश्य किया जाए: अहरोन तथा उसके पुत्र उनके साथ भीतर जाकर हर एक को उसके लिए ठहराया हुआ कार्य सौंप दें; ");
INSERT INTO hincv_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","किंतु किसी भी परिस्थिति में, कोहाथियों भीतर जाकर एक क्षण के लिए भी पवित्र वस्तुओं पर दृष्टि करना उनके लिए घातक सिद्ध होगा.” ");
INSERT INTO hincv_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","फिर याहवेह ने मोशेह को यह आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“अब गेरशोन के घराने की गिनती उनके परिवारों एवं कुल के अनुसार करो. ");
INSERT INTO hincv_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","तीस से पचास वर्ष की आयु के सभी पुरुषों की गिनती करनी है. ये सभी वे होंगे, जो मिलनवाले तंबू में सेवा के लिए चुने जाते हैं. ");
INSERT INTO hincv_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“गेरशोनियों के परिवारों के लिए ठहराई हुई सेवा इस प्रकार है: सेवा करना तथा भार उठाना. ");
INSERT INTO hincv_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","वे साक्षी तंबू, अर्थात् मिलनवाले तंबू के पर्दे एवं ढकने वाले वस्त्र, सूंस के चमड़े का पर्दा, मिलनवाले तंबू के द्वार के लिए पर्दा, ");
INSERT INTO hincv_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","उस आंगन के पर्दे जो साक्षी तंबू और वेदी के चारों ओर है, उसके द्वार का पर्दा, पर्दों की डोरें तथा काम में आनेवाले सभी सामान तथा वह सब जो सामान्यतः किया जाता है, वे करते रहेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","गेरशोनियों के लिए जो भी सेवाएं, तथा सामग्री सामान उठाने से संबंधित जवाबदारी ठहराई गई है, उनको वे सिर्फ अहरोन एवं उसके पुत्र के आदेश पर ही किया करेंगे, तथा तुम भार उठाने से संबंधित जवाबदारी उन्हें सौंप दोगे. ");
INSERT INTO hincv_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","गेरशोनियों का उनके परिवारों के अनुसार मिलनवाले तंबू में किए जाने के कार्यों का विवरण यही है, तथा उनकी सेवाओं के विषय में निर्देश पुरोहित अहरोन के पुत्र इथामार द्वारा प्रदान किए जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“मेरारी के पुत्रों की गिनती उनके परिवारों के अनुसार उनके पितरों के घराने में करोगे. ");
INSERT INTO hincv_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","तीस से पचास वर्ष की आयु के सभी पुरुषों की गिनती करनी है. ये वे होंगे, जिन्हें मिलनवाले तंबू में सेवा के लिए भर्ती किया जाता है. ");
INSERT INTO hincv_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","उनके द्वारा मिलनवाले तंबू की सेवा में उठाने का कार्य इस प्रकार किया जाएगा: साक्षी तंबू के पल्ले, छड़ें, खंभे, तथा आधार, ");
INSERT INTO hincv_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","आंगन के चारों ओर के खंभे, उनके आधार, उनकी खूंटियां, उनकी डोरियां तथा उनके उपकरण, उनके उपयोग से जुड़ी हर चीज़. तुम हर एक व्यक्ति को उसका नाम लेकर वे वस्तुएं सौंपोगे, जिनका भार वह उठाया करेगा. ");
INSERT INTO hincv_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","मिलनवाले तंबू में पुरोहित अहरोन के पुत्र इथामार के निर्देश में मेरारी के वंशजों के परिवारों द्वारा की जाने के लिए निर्धारित सेवा यही होगी.” ");
INSERT INTO hincv_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","फिर मोशेह अहरोन, तथा सारी सभा के प्रधानों ने कोहाथ के घराने के परिवारों के अंतर्गत उनके पितरों और कुलों के अनुसार उनकी गिनती की. ");
INSERT INTO hincv_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","वे सभी, जो आयु में तीस से पचास वर्ष के पुरुष हैं, जिनकी नियुक्ति मिलनवाले तंबू की सेवा के लिए की गई थी, इसमें गिने गए. ");
INSERT INTO hincv_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","परिवारों के अनुसार इनकी कुल संख्या 2,750 थी. ");
INSERT INTO hincv_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ये सभी कोहाथियों के परिवारों से गिने गए लोग थे; हर एक, जो मिलनवाले तंबू में सेवारत था, जिनकी गिनती मोशेह एवं अहरोन ने मोशेह को याहवेह द्वारा दिए गए आदेश के अनुसार की थी. ");
INSERT INTO hincv_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","गेरशोन के परिवारों के अंतर्गत पितरों और कुलों के अनुसार सभी व्यक्तियों की गिनती की गई. ");
INSERT INTO hincv_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","वे व्यक्ति, जिनकी आयु तीस वर्ष से ऊपर तथा तीस से पचास वर्ष है, हर एक पुरुष, जिसे मिलनवाले तंबू में सेवा के लिए चुना गया, ");
INSERT INTO hincv_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","परिवारों के अंतर्गत, पितरों और कुलों के अनुसार गिने गए व्यक्तियों की संख्या 2,630 थी. ");
INSERT INTO hincv_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ये गेरशोन के घराने के परिवारों के गिने गए समस्त व्यक्ति थे; हर एक, जो मिलनवाले तंबू में सेवा करता था. जिनकी गिनती याहवेह के आदेश के अंतर्गत मोशेह तथा अहरोन ने की. ");
INSERT INTO hincv_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","मेरारी के घराने की उनके परिवारों के अंतर्गत उनके पितरों और कुलों के अनुसार गिने गए. ");
INSERT INTO hincv_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","हर एक पुरुष, जिसकी आयु तीस वर्ष से अधिक तथा तीस से पचास वर्ष है, जिसे मिलनवाले तंबू की सेवा के लिए चुना गया था, ");
INSERT INTO hincv_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","परिवारों के अनुसार उनकी संख्या थी 3,200. ");
INSERT INTO hincv_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ये मेरारी के घराने के परिवारों के अनुसार गिने गए समस्त व्यक्ति हैं, जिनकी गिनती मोशेह तथा अहरोन ने याहवेह के मोशेह को दिए आदेश के अंतर्गत की थी. ");
INSERT INTO hincv_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","मोशेह, अहरोन तथा इस्राएल के प्रधानों द्वारा सभी लेवी पुरुषों की, ");
INSERT INTO hincv_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","हर एक पुरुष जिनकी आयु तीस से पचास वर्ष है, जो मिलनवाले तंबू में सेवा के लिए उनके परिवारों तथा पितरों और कुलों के अनुसार गिनती की गई. ");
INSERT INTO hincv_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","उनकी संख्या 8,580 थी. ");
INSERT INTO hincv_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","यह गिनती मोशेह को याहवेह द्वारा दी गई आज्ञा के अंतर्गत की गई. हर एक व्यक्ति की गिनती की गई, जो सेवा करता था, अथवा भार उठानेवाला था. इस प्रकार ये सभी गिने गए व्यक्ति थे; मोशेह को याहवेह द्वारा दी गई आज्ञा यही है. ");
INSERT INTO hincv_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“इस्राएल के घराने को यह आज्ञा दो कि वे हर एक कुष्ठरोगी, हर एक ऐसे व्यक्ति को, जिसे स्राव हो रहा हो तथा हर एक को, जो किसी शव को छूने के कारण अशुद्ध हो चुका है, ");
INSERT INTO hincv_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","उसे शिविर के बाहर कर दें, चाहे वह स्त्री हो अथवा पुरुष; तुम इन्हें शिविर के बाहर इसलिये कर दोगे कि वह शिविर, जहां मैं इनके बीच निवास करता हूं, दूषित न हो जाए.” ");
INSERT INTO hincv_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","इस्राएल के घराने ने यही किया तथा ऊपर लिखे व्यक्तियों को शिविर के बाहर कर दिया; ठीक जैसा याहवेह ने मोशेह को आज्ञा दी थी. इस्राएल के घराने ने इस आज्ञा का पालन किया. ");
INSERT INTO hincv_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“इस्राएल के घराने को यह सूचित करो: ‘जब कोई स्त्री अथवा पुरुष किसी के साथ गलत व्यवहार करता है, जो याहवेह के विरुद्ध विश्वासघात है, अर्थात् वह व्यक्ति दोषी है, ");
INSERT INTO hincv_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","तब वह अपना पाप स्वीकार करे, अपनी इस भूल की पूरी-पूरी भरपाई करे, तथा इसके अलावा उस राशि में उसका पांचवा अंश भी जोड़े और उस व्यक्ति को सौंप दे, जिसके साथ उसने यह दुर-व्यवहार किया है. ");
INSERT INTO hincv_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","किंतु उस स्थिति में, जब उस व्यक्ति का कोई संबंधी नहीं हो, जिसके साथ दुर-व्यवहार हुआ है, तब भरपाई याहवेह को दी जाए जिसे पुरोहित स्वीकार करेगा. यह उस मेढ़े के अतिरिक्त होगी, जो प्रायश्चित के लिए ठहराया जाता है. ");
INSERT INTO hincv_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","सारी पवित्र भेंट वस्तुओं से संबंधित सारा दसवां अंश, जो इस्राएल का घराना पुरोहित को दिया करता है, वह पुरोहित का होगा. ");
INSERT INTO hincv_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","इस प्रकार हर एक व्यक्ति द्वारा चढ़ाई गई पवित्र भेंटें पुरोहित की होंगी, जो कुछ कोई भी व्यक्ति पुरोहित को भेंट करता है, वह पुरोहित ही का हो जाता है.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","इसके बाद याहवेह ने मोशेह को यह आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“इस्राएल के घराने को यह सूचित करो: यदि किसी व्यक्ति की पत्नी बुरी चाल चलकर वैवाहिक जीवन में विश्वासघात कर देती है, ");
INSERT INTO hincv_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","किसी ने उससे संभोग किया है, और उसके पति को इस बात की कोई भी जानकारी नहीं है, तथा वह उजागर नहीं है, जबकि वह अपवित्र हो चुकी है, (किंतु इस विषय में कोई गवाह भी नहीं है. उसे संभोग करते हुए किसी ने भी नहीं देखा है), ");
INSERT INTO hincv_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","यदि पति को पत्नी पर संदेह हो जाता है, क्योंकि उसने स्वयं को अपवित्र कर लिया है. दूसरी स्थिति में, पति अपनी पत्नी पर संदेह करने लगता है, उसे पत्नी पर संदेह हो जाता है, जबकि पत्नी ने स्वयं को दूषित किया ही नहीं है, ");
INSERT INTO hincv_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","तब पति अपनी पत्नी को पुरोहित के सामने लाएगा. वह अपनी पत्नी से संबंधित भेंट चढ़ाने के लिए एक एफाह का दसवां भाग जौ का आटा साथ लाएगा. वह इस पर न तो तेल उण्डेलेगा और न लोबान डालेगा, क्योंकि यह संदेह के लिए अर्पित की जा रही बलि है. यह स्मरण अन्‍नबलि है, अधर्म के स्मरण की बलि. ");
INSERT INTO hincv_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘इसके बाद वह स्त्री को अपने निकट बुलाकर याहवेह के सामने खड़ा कर देगा. ");
INSERT INTO hincv_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","पुरोहित मिट्टी के पात्र में पवित्र जल लेकर साक्षी तंबू की भूमि पर से कुछ धूल लेकर उस जल में मिला देगा. ");
INSERT INTO hincv_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","फिर पुरोहित उस स्त्री को याहवेह के सामने खड़ा करेगा तथा उस स्त्री के बाल खोल देने की आज्ञा देगा. इसके बाद वह स्मरण की अन्‍नबलि उसके हाथों में दे देगा, जो वास्तव में संदेह की बलि है. पुरोहित के हाथों में इस समय वह कड़वाहट का जल होगा, जो शाप लगने का कारण होता है. ");
INSERT INTO hincv_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","पुरोहित उस स्त्री को शपथ लेने का आदेश देकर कहेगा, “अपने पति के साथ वैवाहिक जीवन में रहते हुए यदि किसी पराए पुरुष ने तुम्हारे साथ संभोग नहीं किया है तथा तुम यदि कुकर्म में अपवित्र नहीं हुई हो, तो इस कड़वाहट के जल से आनेवाले शाप का तुम पर कोई प्रभाव न होगा. ");
INSERT INTO hincv_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","किंतु, यदि अपने पति के साथ होते हुए भी, वैवाहिक जीवन में भ्रष्‍ट हो चुकी हो, यदि तुमने अपने पति के अलावा किसी पराए पुरुष से संभोग करने के द्वारा स्वयं को अपवित्र कर लिया है”— ");
INSERT INTO hincv_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","फिर पुरोहित उस स्त्री को शाप की शपथ लेने का आदेश देगा, और उससे कहेगा, “याहवेह लोगों के बीच तुम्हें इस झूठी शपथ का शाप बना दें, याहवेह तुम्हारी जांघ को गला दें, तुम्हारा पेट फूल जाए, ");
INSERT INTO hincv_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","जब तुम यह जल जो श्राप लानेवाला है, पियोगी तो तुम्हारा पेट फूल जाएगा, तथा तुम्हारी जांघ गल जाएगी.” “ ‘वह स्त्री कहेगी, “आमेन, आमेन.” ");
INSERT INTO hincv_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘तब वह पुरोहित ये शाप एक चमड़े के पत्र पर लिख देगा और इन्हें उस कड़वाहट के जल में धो देगा. ");
INSERT INTO hincv_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","इसके बाद वह यह शाप लानेवाला कड़वाहट का जल उस स्त्री को पीने के लिए दे देगा; वह इसे पी लेगी और यह जल कड़वाहट पैदा कर देगा. ");
INSERT INTO hincv_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","फिर पुरोहित उस स्त्री के हाथों से वह संदेह की अन्‍नबलि ले लेगा तथा इसे याहवेह के सामने हिलाएगा और इसे वेदी पर ले जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","वह इसमें से एक मुट्ठी भर स्मरण अन्‍नबलि लेकर वेदी की आग में डालकर इसे जलाएगा तथा उस स्त्री को वह जल पीने की आज्ञा देगा. ");
INSERT INTO hincv_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","जब वह उसे जल पिलाया जा चुके तब यह होगा, कि यदि उसने अपने वैवाहिक जीवन में विश्वासघात किया है; वह शाप लानेवाला जल उसके पेट में जाकर कड़वाहट पैदा करेगा, उसका पेट फूल जाएगा तथा उसकी जांघ गल जाएगी और वह स्त्री अपने लोगों के बीच शापित घोषित हो जाएगी. ");
INSERT INTO hincv_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","किंतु यदि उस स्त्री ने स्वयं को अपवित्र नहीं किया है, वह शुद्ध है, वह इससे निर्दोष होकर गर्भधारण करती रहेगी. ");
INSERT INTO hincv_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘संदेह से संबंधित विधि यही होगी: यदि वैवाहिक जीवन में होते हुए कोई स्त्री भ्रष्‍ट होकर स्वयं को अपवित्र कर लेती है, ");
INSERT INTO hincv_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","अथवा यदि किसी पुरुष में अपनी पत्नी के प्रति संदेह के भाव पैदा हो जाते हैं, वह स्त्री को याहवेह के सामने उपस्थित करेगा तथा पुरोहित यह सारी प्रक्रिया की विधि उसके साथ पूरी करेगा. ");
INSERT INTO hincv_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","इसके अलावा, वह पुरुष दोष मुक्त रहेगा, किंतु वह स्त्री अपने अधर्म का भार स्वयं उठाएगी.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“इस्राएल के घराने को बुलाकर उन्हें यह आज्ञा दो: ‘जब कोई स्त्री अथवा कोई पुरुष नाज़ीरी संकल्प करता है, तथा यह संकल्प समर्पण के विषय में हो कि वह स्वयं को याहवेह के लिए समर्पित करता है, ");
INSERT INTO hincv_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","वह दाखमधु से अलग रहे, सिरके का सेवन न करे, चाहे वह अंगूर के रस से बना हुआ हो अथवा किसी नशीले द्रव्य का. वह अंगूर के रस का भी सेवन न करे, वह न तो वाटिका से लाए गए अंगूरों का सेवन करे और न ही सुखाए हुए अंगूरों का. ");
INSERT INTO hincv_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","अपने पूरे संकल्प किए हुए समय में वह किसी भी ऐसी वस्तु को न खाए, जो अंगूर से बनी हो, यहां तक कि न तो अंगूर के बीज से लेकर अंगूर के छिलकों का. ");
INSERT INTO hincv_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘जब तक उसके संकल्प का समय है, उसके सिर पर उस्तरा न फेरा जाएगा. जिस समय के लिए उसने संकल्प किया है वह याहवेह के लिए अलग तथा पवित्र बना रहेगा; वह अपने बाल लंबे होते जाने देगा. ");
INSERT INTO hincv_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘याहवेह के लिए अलग रहने के समय में वह कभी भी किसी शव के पास नहीं जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","वह स्वयं को अपने माता-पिता अथवा भाई-बहन की मृत्यु होने पर भी अशुद्ध नहीं करेगा क्योंकि वह अपनी देह सहित परमेश्वर के लिए अलग किया गया है. ");
INSERT INTO hincv_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","अलग रहने के पूरे समय तक वह याहवेह के लिए पवित्र है. ");
INSERT INTO hincv_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘किंतु यदि उसके निकट ही किसी व्यक्ति की मृत्यु अचानक हो गई हो, जिसके परिणामस्वरूप वह अपने समर्पित बालों को अशुद्ध कर देता है, तब वह उस दिन, जब वह स्वयं को अलग कर लेता है, अपने बाल मुंडवा ले. ");
INSERT INTO hincv_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","आठवें दिन वह दो पण्डुक अथवा दो कबूतर के बच्‍चे तंबू के द्वार पर लाकर पुरोहित को सौंप देगा. ");
INSERT INTO hincv_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","पुरोहित एक पक्षी को पापबलि के लिए तथा अन्य पक्षी होमबलि के लिए भेंट करके उसके लिए प्रायश्चित विधि पूरी करेगा, क्योंकि वह उस व्यक्ति के शव के कारण अशुद्ध हो गया था. उसी दिन वह व्यक्ति अपने सिर को पवित्र करेगा, ");
INSERT INTO hincv_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","तथा वह याहवेह के सामने नाज़री होने की अवधि को भेंट करेगा. फिर वह एक वर्ष का मेमना दोष बलि के रूप में भेंट करेगा. उसके संकल्प की पूरी अवधि उसके अशुद्ध हो जाने के कारण मान्य नहीं होगी. ");
INSERT INTO hincv_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘संकल्प लेने के दिन पूरे होने पर उस नाज़ीर के लिए विधि इस प्रकार है: वह अपनी भेंट मिलनवाले तंबू के द्वार पर ले आएगा. ");
INSERT INTO hincv_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","वह अपनी यह भेंट याहवेह को चढ़ाएगा: एक वर्ष का निर्दोष मेमना, एक वर्ष की भेड़ पापबलि के लिए, तथा एक निर्दोष मेढ़ा मेल बलि के लिए. ");
INSERT INTO hincv_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","इनके अलावा मैदे की तेल मिली हुई अखमीरी रोटी एक टोकरी, तथा अखमीरी पपड़ियां, जिन पर तेल चुपड़ दिया गया हो. इनके साथ अन्‍नबलि तथा अर्घ भी. ");
INSERT INTO hincv_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘यह सब पुरोहित याहवेह के सामने लाकर भेंट करेगा; इनमें अखमीरी रोटियां भी शामिल होंगी. पुरोहित अन्‍नबलि एवं अर्घ भी भेंट करेगा. ");
INSERT INTO hincv_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","वह याहवेह को मेल बलि के लिए अखमीरी रोटी की टोकरी के साथ मेढ़ा भी भेंट करेगा. इसी प्रकार अन्‍नबलि एवं अर्घ भी. ");
INSERT INTO hincv_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘इसके बाद वह नाज़ीर अपने सिर के बाल मिलनवाले तंबू के प्रवेश द्वार पर जाकर मुंडवाएगा, तथा अपने भेंट किए हुए बालों को उस आग में डाल देगा, जो मेल बलियों के बलि पशु के नीचे जलती है. ");
INSERT INTO hincv_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘जब वह नाज़ीर अपना सिर मुंडवा चुके, तब पुरोहित उसके हाथों में उस मेढ़े के कंधे, जो इस समय उबाले जा चुके होंगे, टोकरी से एक अखमीरी रोटी तथा एक अखमीरी पपड़ी रख देगा. ");
INSERT INTO hincv_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","इसके बाद पुरोहित इन्हें याहवेह के सामने हिलाने की बलि के रूप में हिलाएगा. हिलाने के लिए ठहराए हुए भेंट के मेढ़े का सीना तथा ऊपर उठाकर भेंट करने के लिए ठहराई हुई जांघ उस पुरोहित के लिए पवित्र होगी. यह सब हो जाने के बाद उस नाज़ीर के लिए दाखमधु पीना वर्जित न रहेगा.’ ");
INSERT INTO hincv_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘यही है उस नाज़ीर से संबंधित विधि, उसके अलावा, जो कुछ उसके लिए संभव है! जो अपने अलग रहने के द्वारा याहवेह के सामने संकल्प लेता है, उसने जो कुछ संकल्प किया है, उसे वह अपने अलग रहने की विधि के अनुसार अवश्य पूरी करे.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","फिर याहवेह ने मोशेह को यह आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“अहरोन एवं उसके पुत्रों को यह आज्ञा दो, ‘जब तुम इस्राएल के घराने को आशीर्वाद दो, तो उनसे इस प्रकार कहना: ");
INSERT INTO hincv_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “याहवेह तुम्हें आशीष प्रदान करें, तथा तुम्हें सुरक्षित रखें; ");
INSERT INTO hincv_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","याहवेह तुम पर अपने मुख का प्रकाश चमकाकर तुम पर अनुग्रह करें; ");
INSERT INTO hincv_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","याहवेह तुम्हारी ओर मुड़कर तुम्हें शांति प्रदान करें.” ’ ");
INSERT INTO hincv_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“जब वे इस्राएल के घराने पर मेरा नाम रखेंगे, तब मैं उनका भला करूंगा.” ");
INSERT INTO hincv_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","जिस दिन मोशेह ने पवित्र स्थान से संबंधित सारा काम पूरा किया, उन्होंने इसका अभिषेक किया, इसे उसकी सारी वस्तुओं सहित पवित्र किया; वेदी एवं उस पर के सारे बर्तन. मोशेह ने इनका अभिषेक किया तथा इसके बाद इनको पवित्र किया. ");
INSERT INTO hincv_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","फिर इस्राएल के प्रधानों ने, जो उनके पितरों के प्रधान थे, भेंटें चढ़ाईं. ये सभी गोत्रों के प्रधान थे, वे ही जो गिने गए व्यक्तियों के नेता ठहराए गए थे. ");
INSERT INTO hincv_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","जब उन्होंने याहवेह के सामने अपनी भेंटें प्रस्तुत की, तब वे ये चारों ओर से बंद छः गाड़ियां, बारह बैल, दो नेताओं के बीच एक गाड़ी तथा प्रधान के लिए एक बैल. ये सभी उन्होंने पवित्र स्थान के सामने भेंट कर दी. ");
INSERT INTO hincv_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","फिर याहवेह ने मोशेह को यह आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“उन लोगों से ये भेंटें स्वीकार कर लो कि इनका प्रयोग मिलनवाले तंबू के कार्यों के लिए किया जा सके. ये तुम लेवियों को दे दोगे, हर एक व्यक्ति को उसके लिए ठहराए गए कार्य के अनुसार.” ");
INSERT INTO hincv_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","फिर मोशेह ने वे गाड़ियां तथा वे बैल लेवियों को सौंप दिए. ");
INSERT INTO hincv_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","दो गाड़ियां एवं चार बैल गेरशोन के घराने को, जो उनकी सेवाओं के अनुसार थे, ");
INSERT INTO hincv_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","चार गाड़ियां तथा आठ बैल मेरारी के घराने को, उनके कार्य के अनुसार सौंप दिए. वे ये सेवा पुरोहित अहरोन के पुत्र इथामार की देखभाल में करते थे. ");
INSERT INTO hincv_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","मोशेह ने कोहाथ के घराने को कुछ भी नहीं दिया, क्योंकि उनकी जवाबदारी थी, पवित्र वस्तुओं से संबंधित कार्य, जिनका भार वे अपने कंधों पर उठाया करते थे. ");
INSERT INTO hincv_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","प्रधानों ने वेदी का अभिषेक किया और वेदी के लिए चढ़ाई भेंट अर्पित की तथा प्रधानों ने अपनी-अपनी भेंटें वेदी के सामने चढ़ा दी. ");
INSERT INTO hincv_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","फिर याहवेह ने मोशेह को आज्ञा दी, “वेदी के समर्पण के लिए प्रतिदिन एक ही प्रधान अपनी भेंट चढ़ाए.” ");
INSERT INTO hincv_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","जिस व्यक्ति ने पहले दिन भेंट चढ़ाई, वह यहूदाह गोत्र से अम्मीनादाब का पुत्र नाहशोन था. ");
INSERT INTO hincv_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","भेंट में उसने अन्‍नबलि के लिए चांदी की एक परात एवं एक चांदी की कटोरी भेंट की, जिनमें तेल मिला हुआ मैदा भरा गया था. पात्र पवित्र स्थान की तौल के अनुसार एक सौ तीस शेकेल तथा कटोरी सत्तर शेकेल की थी; ");
INSERT INTO hincv_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","सुगंधित धूप से भरा हुआ दस शेकेल सोने का धूपदान; ");
INSERT INTO hincv_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","होमबलि के लिए एक बछड़ा, एक मेढ़ा, एक, एक वर्ष का नर मेमना; ");
INSERT INTO hincv_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","पापबलि के लिए एक बकरा; ");
INSERT INTO hincv_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","मेल बलि के लिए दो बछड़े, पांच मेढ़े, पांच बकरे तथा पांच एक वर्ष के नर मेमने. यही अम्मीनादाब के पुत्र नाहशोन द्वारा चढ़ाई गई भेंट थी. ");
INSERT INTO hincv_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","दूसरे दिन इस्साखार गोत्र के प्रधान ज़ुअर के पुत्र नेथानेल ने भेंट चढ़ाई. ");
INSERT INTO hincv_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","उसकी भेंट यह थी: एक सौ तीस शेकेल की एक चांदी की परात, सत्तर शेकेल की एक चांदी की कटोरी; ये दोनों ही पवित्र स्थान की तौल के शेकेल के अनुसार थे. इन दोनों ही में अन्‍नबलि के लिए तेल मिला हुआ मैदा भरा था; ");
INSERT INTO hincv_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","सुगंधित धूप से भरा हुआ दस शेकेल सोने का धूपदान; ");
INSERT INTO hincv_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","होमबलि के लिए एक बछड़ा, एक मेढ़ा, एक वर्ष का एक नर मेमना; ");
INSERT INTO hincv_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","पापबलि के लिए एक बकरा; ");
INSERT INTO hincv_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","मेल बलि चढ़ाने के लिए दो बछड़े, पांच मेढ़े, पांच बकरे, एक वर्ष के पांच नर मेमने. यह थी ज़ुअर के पुत्र नेथानेल द्वारा चढ़ाई गई भेंटें. ");
INSERT INTO hincv_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","तीसरे दिन ज़ेबुलून के गोत्र से हेलोन के पुत्र एलियाब ने भेंटें चढ़ाईं. ");
INSERT INTO hincv_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","उसने पवित्र स्थान की तौल के अनुसार एक सौ तीस शेकेल की चांदी की परात तथा सत्तर शेकेल की चांदी की कटोरी में अन्‍नबलि के लिए तेल मिला हुआ मैदा; ");
INSERT INTO hincv_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","सुगंधित धूप से भरा हुआ दस शेकेल सोने का धूपदान; ");
INSERT INTO hincv_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","होमबलि के लिए एक बछड़ा, एक मेढ़ा, एक वर्ष का एक नर मेमना; ");
INSERT INTO hincv_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","पापबलि के लिए एक बकरा; ");
INSERT INTO hincv_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","मेल बलि के लिए दो बछड़े, पांच मेढ़े, पांच बकरे, और एक वर्ष के पांच नर मेमने भेंट किए. यह सब हेलोन के पुत्र एलियाब ने भेंट किए. ");
INSERT INTO hincv_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","चौथे दिन शेदेउर के पुत्र एलिज़ुर ने जो रियूबेन गोत्र का प्रधान था, अपनी भेंटे चढ़ाई. ");
INSERT INTO hincv_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","उसने पवित्र स्थान की तौल के अनुसार एक सौ तीस शेकेल की चांदी की परात तथा सत्तर शेकेल का चांदी का कटोरा और इन दोनों ही में ज़ैतून के तेल मिला हुआ महीन आटा, ");
INSERT INTO hincv_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","सुगंधित धूप से भरा हुआ दस शेकेल सोने का धूपदान; ");
INSERT INTO hincv_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","होमबलि के लिए एक बछड़ा, एक मेढ़ा, एक, एक वर्ष का नर मेमना; ");
INSERT INTO hincv_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","पापबलि के लिए एक बकरा; ");
INSERT INTO hincv_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","मेल बलि चढ़ाने के लिए दो बछड़े, पांच मेढ़े, पांच बकरे, और एक वर्ष के पांच नर मेमने चढ़ाए. शेदेउर के पुत्र एलिज़ुर द्वारा यह भेंट चढ़ाई गई. ");
INSERT INTO hincv_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","पांचवें दिन ज़ुरीशद्दाय के पुत्र शेलुमिएल ने जो शिमओन गोत्र का प्रधान था, उसने भेंट चढ़ाई. ");
INSERT INTO hincv_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","उसने पवित्र स्थान की तौल के अनुसार एक सौ तीस शेकेल चांदी की परात तथा सत्तर शेकेल की चांदी की कटोरी में अन्‍नबलि के रूप में तेल मिला हुआ मैदा, ");
INSERT INTO hincv_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","सुगंधित धूप से भरा हुआ दस शेकेल सोने का धूपदान; ");
INSERT INTO hincv_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","होमबलि के लिए एक बछड़ा, एक मेढ़ा, एक, एक वर्ष का नर मेमना; ");
INSERT INTO hincv_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","पापबलि के लिए एक बकरा; ");
INSERT INTO hincv_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","मेल बलि चढ़ाने के लिए दो बछड़े, पांच मेढ़े, पांच बकरे, और एक वर्ष के पांच नर मेमने चढ़ाए. यह ज़ुरीशद्दाय के पुत्र शेलुमिएल द्वारा चढ़ाई गई थी. ");
INSERT INTO hincv_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","छठवें दिन देउएल के पुत्र एलियासाफ़ ने, जो गाद के गोत्र का प्रधान था, भेंट चढ़ाई. ");
INSERT INTO hincv_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","उसने पवित्र स्थान की नाप के अनुसार एक सौ तीस शेकेल चांदी की परात तथा सत्तर शेकेल चांदी का कटोरा तथा सत्तर शेकेल चांदी की कटोरी में तेल मिला हुआ मैदा ");
INSERT INTO hincv_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","दस शेकेल सोने के धूपदान में सुगंधित धूप; ");
INSERT INTO hincv_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","होमबलि के लिए एक बछड़ा, एक मेढ़ा, एक वर्ष का एक नर मेमना; ");
INSERT INTO hincv_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","पापबलि के लिए एक बकरा; ");
INSERT INTO hincv_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","मेल बलि चढ़ाने के लिए दो बछड़े, पांच मेढ़े, पांच बकरे, एक वर्ष के पांच नर मेमने चढ़ाए. यह भेंट देउएल के पुत्र एलियासाफ़ द्वारा चढ़ाई गई थी. ");
INSERT INTO hincv_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","सातवें दिन अम्मीहूद के पुत्र एलीशामा ने जो एफ्राईम गोत्र का प्रधान था, भेंट चढ़ाई. ");
INSERT INTO hincv_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","उसने पवित्र स्थान की तौल के अनुसार एक सौ तीस शेकेल चांदी की परात तथा सत्तर शेकेल चांदी का कटोरा तथा सत्तर शेकेल चांदी की कटोरी में तेल मिला हुआ मैदा ");
INSERT INTO hincv_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","दस शेकेल सोने के धूपदान में सुगंधित धूप; ");
INSERT INTO hincv_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","होमबलि के लिए एक बछड़ा, एक मेढ़ा, एक वर्ष का एक नर मेमना; ");
INSERT INTO hincv_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","पापबलि के लिए एक बकरा; ");
INSERT INTO hincv_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","मेल बलि चढ़ाने के लिए दो बछड़े, पांच मेढ़े, पांच बकरे, एक वर्ष के पांच नर मेमने चढ़ाए. यह अम्मीहूद के पुत्र एलीशामा द्वारा चढ़ाई गई थी. ");
INSERT INTO hincv_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","आठवें दिन पेदाहज़ुर के पुत्र गमालिएल ने जो मनश्शेह के गोत्र का प्रधान था, भेंट चढ़ाई: ");
INSERT INTO hincv_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","उसने पवित्र स्थान की तौल के अनुसार एक सौ तीस शेकेल चांदी की परात तथा सत्तर शेकेल चांदी का कटोरा तथा दोनों ही जैतून के तेल मिले महीन आटे से भरे हुए; ");
INSERT INTO hincv_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","दस शेकेल सोने के धूपदान में सुगंधित धूप; ");
INSERT INTO hincv_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","होमबलि के लिए एक बछड़ा, एक मेढ़ा, एक वर्ष का एक नर मेमना; ");
INSERT INTO hincv_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","पापबलि के लिए एक बकरा; ");
INSERT INTO hincv_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","मेल बलि चढ़ाने के लिए दो बछड़े, पांच मेढ़े, पांच बकरे, तथा एक वर्ष के पांच नर मेमने चढ़ाए. यह पेदाहज़ुर के पुत्र गमालिएल द्वारा चढ़ाई गई भेंट थी. ");
INSERT INTO hincv_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","नौवें दिन गिदयोनी का पुत्र अबीदान जो बिन्यामिन के गोत्र का प्रधान था अपनी भेंट लाया: ");
INSERT INTO hincv_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","उसने पवित्र स्थान की तौल के अनुसार एक सौ तीस शेकेल चांदी की परात तथा सत्तर शेकेल चांदी का कटोरा तथा सत्तर शेकेल चांदी की कटोरी में तेल मिला हुआ मैदा तथा ");
INSERT INTO hincv_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","दस शेकेल सोने के धूपदान में सुगंधित धूप; ");
INSERT INTO hincv_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","होमबलि के लिए एक बछड़ा, एक मेढ़ा, एक वर्ष का एक नर मेमना; ");
INSERT INTO hincv_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","पापबलि के लिए एक बकरा; ");
INSERT INTO hincv_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","मेल बलि चढ़ाने के लिए दो बछड़े, पांच मेढ़े, पांच बकरे, एक वर्ष के पांच नर मेमने चढ़ाए. यह गिदयोनी के पुत्र अबीदान द्वारा चढ़ाई गई भेंट थी. ");
INSERT INTO hincv_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","दसवें दिन अम्मीशद्दाय के पुत्र अहीएज़र ने, जो दान के गोत्र का प्रधान था, भेंट चढ़ाई. ");
INSERT INTO hincv_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","उसने पवित्र स्थान की तौल के अनुसार एक सौ तीस शेकेल चांदी की परात तथा सत्तर शेकेल चांदी का कटोरा और दोनों ही में बेहतरीन आटे में जैतून का तेल मिला हुआ; ");
INSERT INTO hincv_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","दस शेकेल सोने के धूपदान में सुगंधित धूप; ");
INSERT INTO hincv_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","होमबलि के लिए एक बछड़ा, एक मेढ़ा, एक वर्ष का एक नर मेमना; ");
INSERT INTO hincv_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","पापबलि के लिए एक बकरा; ");
INSERT INTO hincv_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","मेल बलि चढ़ाने के लिए दो बछड़े, पांच मेढ़े, पांच बकरे, एक वर्ष के पांच नर मेमने चढ़ाए. यह अम्मीशद्दाय के पुत्र अहीएज़र द्वारा चढ़ाई गई थी. ");
INSERT INTO hincv_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ग्यारहवें दिन ओखरन का पुत्र पागिएल ने जो आशेर के गोत्र का प्रधान था अपनी भेंट चढ़ाई. ");
INSERT INTO hincv_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","उसने पवित्र स्थान की तौल के अनुसार एक सौ तीस शेकेल चांदी की परात तथा सत्तर शेकेल चांदी का कटोरा और दोनों ही में बेहतरीन आटे में ज़ैतून का तेल मिला हुआ; ");
INSERT INTO hincv_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","दस शेकेल सोने के धूपदान में सुगंधित धूप; ");
INSERT INTO hincv_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","होमबलि के लिए एक बछड़ा, एक मेढ़ा, एक वर्ष का एक नर मेमना; ");
INSERT INTO hincv_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","पापबलि के लिए एक बकरा; ");
INSERT INTO hincv_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","मेल बलि चढ़ाने के लिए दो बछड़े, पांच मेढ़े, पांच बकरे, एक वर्ष के पांच नर मेमने चढ़ाए. यह ओखरन के पुत्र पागिएल द्वारा चढ़ाई गई थी. ");
INSERT INTO hincv_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","बारहवें दिन, नफताली गोत्र से एनन का पुत्र अहीरा जो प्रधान था, ");
INSERT INTO hincv_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","उसने पवित्र स्थान की तौल के अनुसार एक सौ तीस शेकेल चांदी की परात तथा सत्तर शेकेल चांदी का कटोरा तथा सत्तर शेकेल चांदी की कटोरी में तेल मिला हुआ मैदा; ");
INSERT INTO hincv_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","दस शेकेल सोने के धूपदान में सुगंधित धूप; ");
INSERT INTO hincv_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","होमबलि के लिए एक बछड़ा, एक मेढ़ा, एक वर्ष का एक नर मेमना; ");
INSERT INTO hincv_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","पापबलि के लिए एक बकरा; ");
INSERT INTO hincv_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","मेल बलि चढ़ाने के लिए दो बछड़े, पांच मेढ़े, पांच बकरे, एक वर्ष के पांच नर मेमने चढ़ाए. यह एनन के पुत्र अहीरा द्वारा चढ़ाई गई थी. ");
INSERT INTO hincv_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","इस्राएल के प्रधानों द्वारा वेदी का अभिषेक किए जाने के समय चढ़ाई गई संस्कार भेंट यह थी: बारह चांदी की परात, बारह चांदी की कटोरियां, बारह सोने के धूपदान; ");
INSERT INTO hincv_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","हर एक चांदी की परात पवित्र स्थान की तौल के अनुसार एक सौ तीस शेकेल, हर एक चांदी की कटोरी सत्तर शेकेल! तब पवित्र स्थान की तौल के अनुसार सारे बर्तन कुल 2,400 शेकेल हुए. ");
INSERT INTO hincv_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","सुगंधित धूप के साथ बारह सोने के हर एक धूपदान, पवित्र स्थान की नाप के अनुसार दस शेकेल; तब कुल एक सौ बीस शेकेल. ");
INSERT INTO hincv_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","होमबलि के लिए कुल बारह बछड़े, बारह मेढ़े, अन्‍नबलि के लिए बारह एक वर्ष के नर मेमने तथा पापबलि के लिए बारह बकरे. ");
INSERT INTO hincv_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","मेल बलि के लिए कुल चौबीस बछड़े, कुल साठ मेढ़े, कुल साठ बकरे तथा एक वर्ष के साठ नर मेमने. यह अभिषेक के बाद वेदी के लिए चढ़ाई गई भेंट थी. ");
INSERT INTO hincv_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","जब मोशेह मिलनवाले तंबू में याहवेह से बातचीत करने गए, तब उन्होंने वाचा के संदूक के ऊपर करुणासन से, दोनों करूबों के बीच से, एक आवाज सुनी, जो उन्हें संबोधित कर रही थी; इस प्रकार याहवेह ने उनसे यह बातें की थी. ");
INSERT INTO hincv_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","तब याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“अहरोन को यह आज्ञा दो, ‘जब-जब तुम दीपों को दीपदान पर रखो, ये सातों दीप सामने की तरफ़ प्रकाश देंगे.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","अहरोन ने यही किया. उसने दीपों को दीपदान के सामने की ओर रखा, जैसा याहवेह ने मोशेह द्वारा आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","इस दीपदान की बनावट इस प्रकार की गई थी: यह पीटे हुए सोने से बनाया गया था. यह इसके आधार से दीप फूलों तक पीटे हुए सोने से बना था. यह ठीक याहवेह द्वारा मोशेह को दिए गए नमूने के अनुसार था, तब उसने दीपदान को उसी के अनुसार बनाया था. ");
INSERT INTO hincv_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","याहवेह ने मोशेह को दोबारा आज्ञा दी: ");
INSERT INTO hincv_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“सारे इस्राएल के घराने में से लेवियों को अलग करो तथा उन्हें पवित्र करो. ");
INSERT INTO hincv_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","उनके शुद्ध करने की प्रक्रिया यह होगी: उन पर पवित्र जल का छिड़काव करो, तथा वे अपनी पूरी देह पर उस्तरा चलाएं, वस्त्रों को धो डालें और वे स्वच्छ हो जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","फिर वे एक बछड़ा लेकर तेल से सने मैदे के साथ अन्‍नबलि के रूप में चढ़ाएं तथा एक अन्य बछड़ा तुम पापबलि के रूप में चढ़ाओगे. ");
INSERT INTO hincv_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","तुम लेवियों को इस प्रकार मिलनवाले तंबू के सामने प्रस्तुत करोगे. तुम समस्त इस्राएल को इकट्ठा करोगे, ");
INSERT INTO hincv_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","तथा लेवियों को याहवेह के सामने प्रस्तुत करोगे तथा इस्राएल के घराने लेवियों पर अपने हाथ रखेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","अहरोन लेवियों को याहवेह के सामने इस्राएलियों की ओर हिलायी हुई भेंट चढ़ाएगा ताकि वे याहवेह की सेवा के लिए ठहर सकें. ");
INSERT INTO hincv_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“फिर लेवी अपने हाथ उन बछड़ों पर रखेंगे और एक को याहवेह के लिए पापबलि तथा अन्य को होमबलि के रूप में भेंट कर देंगे ताकि इससे यह लेवियों के लिए प्रायश्चित बलि होगी. ");
INSERT INTO hincv_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","तुम लेवियों को अहरोन तथा उसके पुत्रों के सामने खड़ा होने के लिए कहोगे, कि वे याहवेह के सामने हिलाने की भेंट के लिए अर्पण किए जाएं. ");
INSERT INTO hincv_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","इस प्रकार तुम लेवियों को इस्राएल के घराने से अलग करोगे. लेवी मेरे रहेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“यह सब पूरा हो जाने पर लेवी जाकर मिलनवाले तंबू में अपनी-अपनी ठहराई गई सेवाओं में लग सकते हैं; मगर ज़रूरी है कि तुम उन्हें पवित्र कर उन्हें हिलाने वाली भेंट के रूप में अर्पण करोगे; ");
INSERT INTO hincv_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","क्योंकि वे इस्राएल के घराने में से पूरी तरह मुझे दे दिए गए हैं. मैंने ही उन्हें इस्राएल के घराने में से हर एक स्त्री के गर्भ के पहलौंठों के स्थान पर अपने लिए ले लिया है. ");
INSERT INTO hincv_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","क्योंकि इस्राएल के घराने में से हर एक पहलौठा मेरा है; चाहे मनुष्य हो अथवा पशु. जिस दिन मैंने मिस्र देश में हर एक पहलौठे को मारा था, मैंने लेवियों को अपने लिए अलग कर लिया था. ");
INSERT INTO hincv_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","किंतु मैंने लेवियों को इस्राएल के घराने के हर एक पहिलौठों के स्थान पर ले लिया है. ");
INSERT INTO hincv_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","मैंने लेवी वंशजों को इस्राएल के घराने में से अहरोन तथा उसके पुत्रों को भेंट के रूप में दे दिया है कि वे इस्राएल के घराने के लिए मिलनवाले तंबू की सेवा किया करें तथा इस्राएल के घराने के लिए प्रायश्चित करें, कि इस्राएल के घराने पर पवित्र स्थान के निकट आने पर महामारी न आ पड़े.” ");
INSERT INTO hincv_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","फिर मोशेह, अहरोन तथा इस्राएल के घराने की पूरी सभा ने लेवियों के संबंध में यही किया जैसा आदेश याहवेह ने मोशेह को लेवियों के संबंध में दिया था. ");
INSERT INTO hincv_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","दूसरी ओर, लेवियों ने भी स्वयं को अपने पापों से पवित्र किया तथा अपने वस्त्र धो डाले. अहरोन ने उन्हें याहवेह के सामने हिलायी हुई भेंट के रूप में चढ़ाया. अहरोन ने उन्हें शुद्ध करने के उद्देश्य से उनके लिए प्रायश्चित भी किया. ");
INSERT INTO hincv_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","इसके बाद लेवी मिलनवाले तंबू में अहरोन एवं उसके पुत्रों के साथ अपनी-अपनी ठहराई हुई सेवाएं करने के लिए प्रवेश हुए, जैसा कि लेवियों के विषय में मोशेह को याहवेह की आज्ञा थी. यह सब वैसा ही पूरा कर दिया गया. ");
INSERT INTO hincv_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","इसके बाद याहवेह ने मोशेह से कहा, ");
INSERT INTO hincv_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“लेवी सेवा के लिए यह विधि लागू होगी: पच्चीस वर्ष की आयु से ऊपर वे मिलनवाले तंबू में सेवा प्रारंभ किया करेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","पचास वर्ष की अवस्था होने पर वे यह सेवा समाप्‍त कर सेवा निवृत्त हो जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","हां, तब मिलनवाले तंबू में अपने भाइयों की सहायता अवश्य कर सकते हैं ताकि सेवा बिना किसी रुकावट के चलती रहे, किंतु वे स्वयं कोई कार्य नहीं करेंगे.” ");
INSERT INTO hincv_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","मिस्र देश से निकलने के बाद दूसरे वर्ष के पहले महीने में सीनायी के निर्जन प्रदेश में याहवेह ने मोशेह को यह आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“अब यह संभव है कि इस्राएल का घराना ठहराए गए समय पर फ़सह उत्सव को मनाया करे. ");
INSERT INTO hincv_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","इसी माह के चौदहवें दिन पर गोधूली के अवसर पर ठहराए गए समय पर तुम फ़सह उत्सव मनाया करोगे. तुम यह इसकी सारी विधियों एवं नियमों के अनुसार करोगे.” ");
INSERT INTO hincv_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","फिर मोशेह ने सारे इस्राएल के घराने को फ़सह उत्सव मनाने का आदेश दिया, ");
INSERT INTO hincv_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","इस्राएल के घराने ने पहले माह के चौदहवें दिन सूर्यास्त के समय में सीनायी के निर्जन प्रदेश में मोशेह को दिए गए याहवेह के आदेश के अनुसार इस उत्सव को मनाया. ");
INSERT INTO hincv_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","किंतु उनमें कुछ व्यक्ति ऐसे भी थे, जो शव को छूने के कारण इस अवसर पर अशुद्ध हो चुके थे. परिणामस्वरूप वे उस दिन उनके लिए फ़सह उत्सव न मना सके; तब वे उसी समय मोशेह तथा अहरोन से पूछताछ करने पहुंचे. ");
INSERT INTO hincv_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","उन्होंने अपना पक्ष इस प्रकार रखा, “यद्यपि हम शव छूने के कारण इस समय अपवित्र हैं, हमें अन्य इस्राएल के घराने के साथ याहवेह को भेंट चढ़ाने से दूर क्यों रखा जा रहा है?” ");
INSERT INTO hincv_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","मोशेह ने उन्हें उत्तर दिया, “धीरज रखो. मैं इस विषय में याहवेह की इच्छा मालूम करूंगा.” ");
INSERT INTO hincv_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","याहवेह ने मोशेह से कहा, ");
INSERT INTO hincv_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“इस्राएल के घराने को सूचित करो, ‘यदि तुम्हारे बीच कोई व्यक्ति शव को छूने से अपवित्र हो जाता है, अथवा यदि कोई यात्रा में दूसरे स्थान पर है, वह फिर भी याहवेह के लिए फ़सह उत्सव को मना सकेगा, ");
INSERT INTO hincv_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","परंतु द्वितीय महीने की चौदहवीं तिथि पर सूर्यास्त के समय में. वे इसको खमीर रहित रोटी तथा कड़वे साग-पात के साथ खाने के द्वारा मना सकेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","वे कोई भी अंश सुबह के समय तक बचा न रहने देंगे, और न ही पशु की कोई हड्डी तोड़ी जाए. वे फ़सह उत्सव की सभी विधियों का पालन करेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","किंतु वह व्यक्ति, जो सांस्कारिक रूप से शुद्ध है तथा जो यात्रा पर भी नहीं है और फिर भी वह फ़सह उत्सव को नहीं मनाता है, उस व्यक्ति को अपने लोगों के बीच से मिटा दिया जाए, क्योंकि उसने ठहराए गए अवसर पर याहवेह के लिए बलि नहीं चढ़ाई. वह व्यक्ति स्वयं ही अपने पाप का भार उठाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘तुम्हारे बीच रह रहे विदेशी एवं देशी सभी लोगों के लिए एक ही विधि लागू होगी. यदि तुम्हारे बीच में कोई विदेशी रह रहा है, और वह फ़सह उत्सव से संबंधित विधियां एवं नियम के अनुसार याहवेह के लिए फ़सह उत्सव को मनाने की इच्छा रखता है, तो उसे यह करने दिया जाए.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","जिस दिन पवित्र निवास स्थान, यानी साक्षी तंबू, की स्थापना पूरी हुई एक विशेष बादल ने उस पवित्र निवास स्थान को छा लिया. सूर्यास्त के बाद से लेकर सुबह तक यह पवित्र निवास स्थान पर आग के समान दिखाई देता रहा. ");
INSERT INTO hincv_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","यह दृश्य नित्य होने लगा: दिन के समय बादल छा जाना, तथा रात में आग का दर्शन. ");
INSERT INTO hincv_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","इस्राएलियों की पूरी यात्रा में जब-जब बादल साक्षी तंबू के ऊपर से उठता, तब-तब वे वहां से कूच करने का संदेश हुआ करता था, तथा जहां कहीं वह बादल रुक जाता था, वहां इस्राएली डेरा डाल देते थे. ");
INSERT INTO hincv_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","याहवेह के आदेश पर ही इस्राएली कूच कर देते तथा याहवेह के आदेश पर ही वे डेरा डाला करते थे. जब यह बादल साक्षी तंबू पर स्थिर रहता था तब वे डेरा डाले रहते थे. ");
INSERT INTO hincv_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","यहां तक कि जब यह बादल बहुत समय के लिए साक्षी तंबू पर ठहरा रहता था, वे वहीं डेरा डाले रहते थे. ");
INSERT INTO hincv_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","यदि वह बादल साक्षी तंबू पर कुछ ही दिन के लिए ठहरा रहता था, तो वे याहवेह के आदेश के अनुसार डेरा डाले रहते थे और जब चलने के लिए याहवेह का आदेश होता था, वे कूच कर देते थे. ");
INSERT INTO hincv_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","यदि किसी परिस्थिति में यह बादल सिर्फ शाम के समय से सुबह तक ठहरता था और यदि यह बादल सुबह उठ जाता था, तो वे कूच कर देते थे; अथवा यदि यह दिन में तथा रात में ठहरा रहता था, जब कभी यह बादल उठता था, वे कूच कर देते थे. ");
INSERT INTO hincv_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","चाहे यह बादल साक्षी तंबू पर दो दिन ठहरे, या एक महीना, या इससे भी अधिक, इस्राएली डेरा डाले हुए रहते थे, कूच नहीं करते थे; किंतु जब यह बादल ऊपर उठ जाता था, वे कूच कर देते थे. ");
INSERT INTO hincv_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","वे याहवेह के आदेश पर डेरा डालते थे, याहवेह के ही आदेश पर कूच करते थे. वे याहवेह के आदेश के प्रति सतर्क थे, उस आदेश के विषय में, जो मोशेह द्वारा याहवेह ने दिया था. ");
INSERT INTO hincv_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","याहवेह ने मोशेह से और कहा: ");
INSERT INTO hincv_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“पीटी गई चांदी की परत से दो तुरहियां बनाओ, तुम इनका प्रयोग सभा को बुलाने में करोगे, कि वे कूच के लिए शिविर को तैयार करें. ");
INSERT INTO hincv_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","जब ये दोनों साथ साथ बजाए जाएंगे, तब सारी सभा तुम्हारे सामने मिलनवाले तंबू के द्वार पर हो जाएगी. ");
INSERT INTO hincv_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","किंतु यदि सिर्फ एक ही तुरही बजाई जाएगी, तब प्रधान तथा इस्राएल के दलों के प्रधान तुम्हारे सामने इकट्ठा होंगे. ");
INSERT INTO hincv_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","किंतु जब तुम चेतावनी का बिगुल बजाओगे, तब शिविर के पूर्वी दिशा के शिविर कूच करेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","जब कभी तुम दोबारा चेतावनी का बिगुल बजाओगे, वे शिविर, जो दक्षिण दिशा में हैं, कूच करेंगे; आवश्यक है कि उनका कूच शुरू करने के लिए चेतावनी का बिगुल बजाया जाए. ");
INSERT INTO hincv_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","जब कभी सभा इकट्ठी की जाए, तुम बिना किसी चेतावनी नाद के तुरही बजाओगे. ");
INSERT INTO hincv_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“अहरोन के पुरोहित पुत्र इसके अलावा तुरही नाद करेंगे; यह तुम्हारी आनेवाली सभी पीढ़ियों के लिए हमेशा की विधि है. ");
INSERT INTO hincv_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","जब तुम अपने विरोधी से युद्ध करो, जिसने तुम पर आक्रमण किया है, तब तुम इन तुरहियों से चेतावनी का बिगुल बजाओगे, कि याहवेह तुम्हारे परमेश्वर के सामने तुम्हारा स्मरण किया जाए और शत्रुओं से तुम्हारी रक्षा हो सके. ");
INSERT INTO hincv_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","इसके अलावा आनंद के अवसरों पर, तुम्हारे ठहराए गए आनंद मनाने के अवसरों पर, तुम्हारे ठहराए गए उत्सवों पर तथा हर एक महीने की पहली तारीख पर तुम अपनी होमबलियों, अपनी मेल बलियों के अवसर पर तुरही फूंकोगे; तब वे तुम्हारे परमेश्वर के सामने एक स्मरण का कार्य करेंगे. मैं ही हूं वह याहवेह, तुम्हारा परमेश्वर.” ");
INSERT INTO hincv_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","दूसरे वर्ष के दूसरे महीने में बीसवीं तारीख को यह बादल साक्षी तंबू से ऊपर की ओर उठ गया. ");
INSERT INTO hincv_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","इस्राएल के घराने ने सीनायी के निर्जन प्रदेश से अपनी यात्राएं शुरू कर दी. यह बादल पारान के निर्जन प्रदेश में जा ठहर गया. ");
INSERT INTO hincv_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","यह ऐसा पहला अवसर था, जब उन्होंने मोशेह को दिए गए याहवेह के आदेश के अनुसार यात्रा शुरू की थी. ");
INSERT INTO hincv_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","यहूदाह के वंश की छावनी के झंडे, उनके सैन्य व्यवस्था के अनुसार चल रहे थे. अम्मीनादाब का पुत्र नाहशोन सेनापति था. ");
INSERT INTO hincv_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","तब ज़ुअर का पुत्र नेथानेल इस्साखार गोत्र की सेना का सेनापति था. ");
INSERT INTO hincv_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ज़ेबुलून गोत्र की सेना का सेनापति था हेलोन का पुत्र एलियाब. ");
INSERT INTO hincv_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","इसके बाद साक्षी तंबू उतारा गया और गेरशोन तथा मेरारी के पुत्रों ने साक्षी तंबू को उठाते हुए कूच किया. ");
INSERT INTO hincv_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","इनके बाद रियूबेन गोत्र की छावनी के झंडे के साथ शेदेउर के पुत्र एलिज़ुर के नेतृत्व में सेना ने कूच किया. ");
INSERT INTO hincv_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","इनके साथ थे शिमओन के गोत्र की सेना, जिनका सेनापति था ज़ुरीशद्दाय का पुत्र शेलुमिएल. ");
INSERT INTO hincv_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","गाद के गोत्र की सेना का सेनापति था देउएल का पुत्र एलियासाफ़. ");
INSERT INTO hincv_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","इनके बाद कोहाथियों ने पवित्र वस्तुओं के साथ कूच किया, कि उनके वहां पहुंचने के पहले ही साक्षी तंबू खड़ा किया जा सके. ");
INSERT INTO hincv_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","इसके बाद एफ्राईम गोत्र के घराने की सेना ने उनकी छावनी के झंडे के साथ चलना शुरू किया. उनका सेनापति अम्मीहूद का पुत्र एलीशामा था. ");
INSERT INTO hincv_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","मनश्शेह गोत्र के घराने की सेना का सेनापति पेदाहज़ुर का पुत्र गमालिएल था, ");
INSERT INTO hincv_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","बिन्यामिन गोत्र की सेना का सेनापति गिदियोनी का पुत्र अबीदान था. ");
INSERT INTO hincv_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","इसके बाद उनकी सेना के अनुसार दान गोत्र के घराने की छावनी का झंडा था. कूच करते हुए यह सारी छावनी के लिए प्राण रक्षक सेना हुई. इस सेना का सेनापति अम्मीशद्दाय का पुत्र अहीएज़र था. ");
INSERT INTO hincv_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","आशेर गोत्र के घराने की सेना का सेनापति ओखरन का पुत्र पागिएल था. ");
INSERT INTO hincv_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","नफताली गोत्र के घराने की सेना का सेनापति एनन का पुत्र अहीरा था. ");
INSERT INTO hincv_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","कूच करते हुए इस्राएल के घराने की सेनाओं के अनुसार यही क्रम हुआ करता था. ");
INSERT INTO hincv_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","अंत में मोशेह ने अपनी पत्नी के भाई, होबाब से, अर्थात् अपने मिदियानी ससुर रियुएल के पुत्र से कहा, “हम उस स्थान की ओर आगे बढ़ रहे हैं, जिसका वर्णन याहवेह ने इन शब्दों में किया था: ‘यह मैं तुम्हें दे दूंगा.’ तुम भी हमारे साथ आ जाओ. हम तुम्हारा ध्यान रखेंगे; क्योंकि याहवेह ने इस्राएल की भलाई की प्रतिज्ञा की है.” ");
INSERT INTO hincv_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","किंतु होबाब ने उन्हें उत्तर दिया, “मैं आपके साथ नहीं जा सकता; मेरे लिए सही यही है कि मैं अपने संबंधियों के पास अपने देश लौट जाऊं.” ");
INSERT INTO hincv_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","तो मोशेह ने उससे निवेदन किया, “कृपा कर हमारा साथ मत छोड़ो. तुम जानते हो कि इस मरुभूमि मे पड़ाव डालने के लिए अच्छी जगह कहां-कहां होगी; तुम तो हमारे लिए हमारी आंखें हो सकोगे. ");
INSERT INTO hincv_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","हम आश्वासन देते हैं कि यदि तुम हमारे साथ चलोगे, तो जितनी भी भलाई याहवेह हमारे लिए करेंगे, उसमें हम तुमको शामिल कर लेंगे.” ");
INSERT INTO hincv_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","इस प्रकार उन्होंने याहवेह के पर्वत से अपनी यात्रा प्रारंभ की और तीन दिन यात्रा करते रहे. याहवेह की वाचा का संदूक तीन दिनों तक उनके आगे-आगे रहा कि इस्राएल के डेरे के लिए सही विश्राम का स्थान तय किया जा सके. ");
INSERT INTO hincv_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","जब उन्होंने छावनी के स्थान से यात्रा शुरू की थी, दिन के समय याहवेह का बादल उनके ऊपर-ऊपर बना रहता था. ");
INSERT INTO hincv_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","इसके बाद, जब भी संदूक के साथ यात्रा आरंभ करते थे, मोशेह का यह वचन था: “याहवेह सक्रिय हो जाइए! आपके शत्रु बिखर जाएं; जिन्हें आपसे घृणा है आपके सामने से भाग जाएं.” ");
INSERT INTO hincv_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","जब भी संदूक ठहर जाता, मोशेह कहते थे, “याहवेह, हज़ारों हज़ार इस्राएलियों के निकट लौट आइए.” ");
INSERT INTO hincv_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","अब इस्राएली कठिन परिस्थिति में याहवेह के सामने शिकायत करने लगे. जब याहवेह को उनका बड़बड़ाना सुनाई पड़ा, तब उनका क्रोध भड़क उठा और उनके बीच में याहवेह की आग जल उठी, परिणामस्वरूप छावनी के किनारे जल गए. ");
INSERT INTO hincv_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","लोगों ने मोशेह से विनती की और मोशेह ने याहवेह से विनती की, जिससे यह आग शांत हो गई. ");
INSERT INTO hincv_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","उन्होंने उस स्थान का नाम दिया ताबेराह, क्योंकि उनके बीच याहवेह की आग जल उठी थी. ");
INSERT INTO hincv_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","इस्राएलियों के बीच में जो सम्मिश्र लोग मिस्र देश से साथ हो लिए थे, वे अन्य भोजन वस्तुओं की कामना करने लगे. उनके साथ मिलकर इस्राएल का घराना भी रोने और बड़बड़ाने लगा, “हमारे खाने के लिए कौन हमें मांस देगा! ");
INSERT INTO hincv_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","मिस्र देश में तो हमें बहुतायत से खाने के लिए मुफ़्त में मछलियां मिल जाती थीं. हमें वहां के खीरे, खरबूजे, कंद, प्याज तथा लहसुन स्मरण आ रहे हैं. ");
INSERT INTO hincv_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","यहां तो हमारा जी घबरा रहा है; अब तो यहां यह मन्‍ना ही मन्‍ना बचा रह गया है!” ");
INSERT INTO hincv_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","मन्‍ना का स्वरूप धनिया के बीज के समान तथा रंग मोती के समान था. ");
INSERT INTO hincv_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","लोग इसे इकट्ठा करने जाते थे, इसे चक्की में पीसते अथवा ओखली में कूट लिया करते थे. इसके बाद इसे बर्तन में उबाल कर इसके व्यंजन बना लिया करते थे. इसका स्वाद तेल में तले हुए पुए के समान था. ");
INSERT INTO hincv_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","रात में जब ओस पड़ती थी, सारे पड़ाव पर इसी के साथ मन्‍ना भी पड़ा करता था. ");
INSERT INTO hincv_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","मोशेह को इस्राएलियों का रोना सुनाई दे रहा था; हर एक गोत्र अपनी-अपनी छावनी के द्वार पर खड़ा हुआ था. याहवेह का क्रोध बहुत अधिक भड़क उठा. यह मोशेह के लिए चिंता का विषय हो गया. ");
INSERT INTO hincv_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","मोशेह ने याहवेह से विनती की, “आपने अपने दास से यह बुरा व्यवहार क्यों किया है? क्यों मुझ पर आपकी कृपादृष्टि न रही है, जो आपने इन सारे लोगों का भार मुझ पर लाद दिया है? ");
INSERT INTO hincv_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","क्या मैंने इन लोगों को गर्भ में धारण किया है? क्या मैंने इन्हें जन्म दिया है, जो आप मुझे यह आदेश दे रहे हैं ‘इन्हें अपनी गोद में लेकर चलो, जैसे माता अपने दूध पीते बच्‍चे को लेकर चलती है’ उस देश की ओर जिसे देने की प्रतिज्ञा आपने इनके पूर्वजों से की थी? ");
INSERT INTO hincv_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","इन सबके लिए मैं मांस कहां से लाऊं? वे लगातार मेरे सामने शिकायत कर कहते हैं, ‘हमें खाने के लिए मांस दो!’ ");
INSERT INTO hincv_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","मेरे लिए यह संभव नहीं कि मैं इन सबका भार अकेला उठाऊं; मेरे लिए यह असंभव बोझ सिद्ध हो रहा है. ");
INSERT INTO hincv_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","इसलिये यदि आपका व्यवहार मेरे प्रति यही रहेगा तथा मुझ पर आपकी कृपादृष्टि बनी है, तो आप इसी क्षण मेरे प्राण ले लीजिए ताकि मैं अपनी दुर्दशा का सामना करने के लिए जीवित ही न रहूं.” ");
INSERT INTO hincv_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","यह सुन याहवेह ने मोशेह को यह आज्ञा दी: “इस्राएल में से मेरे सामने सत्तर पुरनिये इकट्‍ठे करो. ये लोग ऐसे हों, जिन्हें तुम जानते हो, जो लोगों में से पुरनिये और अधिकारी हैं. इन्हें तुम मिलनवाले तंबू के सामने अपने साथ लेकर खड़े रहना. ");
INSERT INTO hincv_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","तब मैं वहां आकर तुमसे बातचीत करूंगा मैं तुम्हारे अंदर की आत्मा को उनके अंदर कर दूंगा. वे तुम्हारे साथ मिलकर इन लोगों का भार उठाएंगे; तब तुम अकेले इस बोझ को उठानेवाले न रह जाओगे. ");
INSERT INTO hincv_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“लोगों को आज्ञा दो: ‘आनेवाले कल के लिए स्वयं को पवित्र करो. कल तुम्हें मांस का भोजन प्राप्‍त होगा; क्योंकि तुम्हारा रोना याहवेह द्वारा सुन लिया गया है. तुम कामना कर रहे थे, “कैसा होता यदि कोई हमें मांस का भोजन ला देता! हम मिस्र देश में ही भले थे!” याहवेह अब तुम्हें मांस का भोजन देंगे और तुम उसको खाओगे भी. ");
INSERT INTO hincv_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","तुम एक दिन नहीं, दो दिन नहीं, पांच दिन नहीं, दस दिन नहीं, बीस दिन नहीं, ");
INSERT INTO hincv_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","बल्कि एक पूरे महीने खाओगे, कि यह तुम्हारे नथुनों से बाहर निकलने लगेगा तथा स्वयं तुम्हारे लिए यह घृणित हो जाएगा; क्योंकि तुमने याहवेह को, जो तुम्हारे बीच में रहता है तुच्छ समझा. तुम उनके सामने यह कहते हुए रोते रहे: “हम मिस्र देश से क्यों निकलकर आए?” ’ ” ");
INSERT INTO hincv_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","किंतु मोशेह ने इस पर कहा, “जिन लोगों का यहां वर्णन हो रहा है, वे छः लाख पदयात्री हैं; फिर भी आप कह रहे हैं, ‘मैं उन्हें मांस का भोजन दूंगा, कि वे एक महीने तक इसको खाते रहें!’ ");
INSERT INTO hincv_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","क्या सारी भेड़-बकरियों एवं पशुओं का वध किया जाने पर भी इनके लिए काफ़ी होगा? क्या समुद्र की सारी मछलियों को इकट्ठा किया जाने पर भी इनके लिये काफ़ी होगा?” ");
INSERT INTO hincv_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","याहवेह ने मोशेह को उत्तर दिया, “क्या याहवेह का हाथ छोटा हो गया है? अब तो तुम यह देख ही लोगे कि तुम्हारे संबंध में मेरा वचन पूरा होता है या नहीं.” ");
INSERT INTO hincv_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","मोशेह बाहर गए तथा याहवेह के ये शब्द लोगों के सामने दोहरा दिए. इसके अलावा उन्होंने लोगों में से चुने हुए वे सत्तर भी अपने साथ लेकर उन्हें मिलनवाले तंबू के चारों ओर खड़ा कर दिया. ");
INSERT INTO hincv_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","तब याहवेह उस बादल में प्रकट हुए और मोशेह के सामने आए. याहवेह ने मोशेह पर रहनेवाले आत्मा की सामर्थ्य को लेकर उन सत्तर पर समा दिया, जब आत्मा उन सत्तर प्रधानों पर उतरा तब उन सत्तर ने भविष्यवाणी की, किंतु उन्होंने इसको दोबारा नहीं किया. ");
INSERT INTO hincv_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","किंतु इनमें से दो प्रधान अपने-अपने शिविरों में ही छूट गए थे; एक का नाम था एलदाद तथा अन्य का मेदाद, आत्मा उन पर भी उतरी. ये दोनों के नाम पुरनियों की सूची में थे, किंतु ये उन सत्तर के साथ मोशेह के बुलाने पर तंबू के निकट नहीं गए थे, इन्होंने अपने-अपने शिविरों में ही भविष्यवाणी की. ");
INSERT INTO hincv_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","एक युवक ने दौड़कर मोशेह को सूचना दी, “शिविरों में एलदाद एवं मेदाद भविष्यवाणी कर रहे हैं.” ");
INSERT INTO hincv_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","यह सुन नून का पुत्र यहोशू, जो बचपन से ही मोशेह का सहायक हो चुका था, कहने लगा, “मेरे गुरु मोशेह, उन्हें रोक दीजिए!” ");
INSERT INTO hincv_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","किंतु मोशेह ने उससे कहा, “क्या तुम मेरे लिए उनसे ईर्ष्या कर रहो? मेरी इच्छा है कि याहवेह अपने आत्मा को अपनी सारी प्रजा पर उतरने दें, तथा सभी भविष्यद्वक्ता हो जाएं!” ");
INSERT INTO hincv_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","इसके बाद मोशेह तथा इस्राएल के वे प्रधान अपने-अपने शिविरों को लौट गए. ");
INSERT INTO hincv_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","याहवेह की ओर से एक ऐसी प्रचंड आंधी आई, कि समुद्रतट से बटेरें आकर छावनी के निकट गिरने लगीं. इनका क्षेत्र छावनी के इस ओर एक दिन की यात्रा की दूरी तक तथा उस ओर एक दिन की यात्रा की दूरी तक; छावनी के चारों ओर था. ये बटेरें ज़मीन से लगभग एक मीटर की ऊंचाई तक उड़ती हुई पाई गईं. ");
INSERT INTO hincv_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","इन बटेरों को इकट्ठा करने में लोगों ने सारा दिन, सारी रात तथा अगला सारा दिन लगा दिया. जिस व्यक्ति ने कम से कम इकट्ठा किया था उसका माप था लगभग एक हज़ार छः सौ किलो. इन्हें लोगों ने सुखाने के उद्देश्य से फैला दिया. ");
INSERT INTO hincv_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","जब वह मांस उनके मुख में ही था, वे इसे चबा भी न पाए थे कि याहवेह का क्रोध इन लोगों के प्रति भड़क उठा और उन्होंने इन लोगों पर अत्यंत घोर महामारी ड़ाल दी. ");
INSERT INTO hincv_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","इसके फलस्वरूप वह स्थान किबरोथ-हत्ताआवह नाम से मशहूर हो गया, क्योंकि उस स्थान पर इस्राएलियों ने अपने मृतकों को भूमि में गाड़ा था, जिन्होंने इस भोजन के लिए लालसा की थी. ");
INSERT INTO hincv_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","किबरोथ-हत्ताआवह से लोगों ने हाज़ोरौथ की ओर कूच किया तथा वे वहीं डेरा डाले रहे. ");
INSERT INTO hincv_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","मोशेह ने कूश देश की स्त्री से विवाह किया था, और उनका इस स्त्री से विवाह करना मिरियम तथा अहरोन का उनके विरुद्ध हो जाने का कारण बन गया. ");
INSERT INTO hincv_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","उन्होंने यह कहना शुरू कर दिया, “क्या यह सच है कि याहवेह ने सिर्फ मोशेह के द्वारा ही बातचीत की है? क्या उन्होंने हमारे द्वारा भी बातें नहीं की?” याहवेह ने उनकी ये बातें सुन लीं. ");
INSERT INTO hincv_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(सब जानते थे कि मोशेह अपने स्वभाव में बहुत ही विनीत थे; पृथ्वी पर किसी भी व्यक्ति से कहीं अधिक.) ");
INSERT INTO hincv_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","इसलिये अचानक याहवेह ने मोशेह, अहरोन तथा मिरियम से कहा, “तुम तीनों मिलनवाले तंबू के पास आ जाओ.” तब वे तीनों बाहर आ गए. ");
INSERT INTO hincv_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","तब याहवेह बादल के खंभे में उतरकर उस तंबू के द्वार पर खड़े हो गए और अहरोन तथा मिरियम को बुलाया. जब वे दोनों पास आ गए, ");
INSERT INTO hincv_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","तब याहवेह ने कहा, “अब तुम मेरी बात सुनो: “यदि तुम्हारे बीच कोई भविष्यद्वक्ता है, मैं, याहवेह, उस पर दर्शन के द्वारा स्वयं को प्रकट करूंगा, मैं स्वप्न में उससे बातचीत करना सही समझूंगा. ");
INSERT INTO hincv_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","किंतु मेरे सेवक मोशेह के साथ नहीं; मेरे सारे परिवार में वही विश्वासयोग्य है. ");
INSERT INTO hincv_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","मोशेह के साथ मेरी बातचीत आमने-सामने हुआ करती है, इतना ही नहीं, हमारी बातचीत में कुछ भी गुप्‍त नहीं होता है, और न पहेली के समान, उसे तो मुझ याहवेह का स्वरूप दिखाई देता है. फिर तुम्हें मेरे सेवक मोशेह के विरुद्ध यह सब कहते हुए भय क्यों न लगा?” ");
INSERT INTO hincv_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","तब याहवेह का क्रोध उन पर भड़क गया और वह उन्हें छोड़कर चले गए. ");
INSERT INTO hincv_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","जब तंबू के ऊपर का वह बादल गायब हो गया, तब उन्होंने देखा कि मिरियम कोढ़ से भरकर हिम के समान सफेद हो चुकी थी. जब अहरोन ने मिरियम की ओर दृष्टि की, तो पाया कि वह कोढ़ रोग से भर गई थी. ");
INSERT INTO hincv_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","इस पर अहरोन ने मोशेह से विनती की, “मेरे गुरु, मेरी आपसे विनती है, यह पाप हम पर न लगने दीजिए. यह हमारी निरी मूर्खता थी, जो हम यह पाप कर बैठे. ");
INSERT INTO hincv_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ओह, उसे उस स्थिति में न छोड़ दीजिए, जो मृत-जात शिशु के समान, मानो प्रसव होते-होते उसकी आधी देह गल गई हो!” ");
INSERT INTO hincv_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","मोशेह ने याहवेह की दोहाई दी, “परमेश्वर, मेरी प्रार्थना है, उसे शुद्ध कर दीजिए!” ");
INSERT INTO hincv_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","किंतु याहवेह का मोशेह को उत्तर यह था: “यदि उसके पिता ने उसके मुंह पर थूक दिया होता, तो क्या वह सात दिन तक लज्जा की स्थिति में न रहती? रहने दो उसे इस लज्जा की स्थिति में छावनी के बाहर सात दिनों तक. इसके बाद वह छावनी में स्वीकार कर ली जाए.” ");
INSERT INTO hincv_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","तब मिरियम को सात दिनों के लिए छावनी के बाहर कर दिया गया. प्रजा ने उस स्थान से तब तक कूच नहीं किया, जब तक मिरियम को छावनी में वापस न ले लिया गया. ");
INSERT INTO hincv_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","किंतु इसके बाद इस्राएली प्रजा ने हाज़ोरौथ से कूच किया तथा पारान नामक मरुभूमि में डेरा डाल दिया. ");
INSERT INTO hincv_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“भेद लेने के उद्देश्य से अपने कुछ व्यक्ति कनान देश को भेज दो; कनान जो मैं इस्राएल के घराने को देने जा रहा हूं. हर एक गोत्र से एक-एक प्रधान को भेजना.” ");
INSERT INTO hincv_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","फिर मोशेह ने याहवेह के आदेश के अनुसार इन्हें पारान के निर्जन प्रदेश से भेज दिया. ये सभी इस्राएल के घराने के प्रधान थे. ");
INSERT INTO hincv_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","उनके नाम इस प्रकार थे: रियूबेन के गोत्र से ज़क्‍कूर का पुत्र शम्मुआ; ");
INSERT INTO hincv_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","शिमओन के गोत्र से होरी का पुत्र शाफात; ");
INSERT INTO hincv_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","यहूदिया के गोत्र से येफुन्‍नेह का पुत्र कालेब; ");
INSERT INTO hincv_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","इस्साखार के गोत्र से योसेफ़ का पुत्र यिगाल; ");
INSERT INTO hincv_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","एफ्राईम के गोत्र से नून का पुत्र होशिया; ");
INSERT INTO hincv_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","बिन्यामिन के गोत्र से राफू का पुत्र पालती; ");
INSERT INTO hincv_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ज़ेबुलून के गोत्र से सोदी का पुत्र गद्दिएल; ");
INSERT INTO hincv_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","योसेफ़ के गोत्र से अर्थात् मनश्शेह के गोत्र से सुसी का पुत्र गद्दी; ");
INSERT INTO hincv_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","दान के गोत्र से गमेली का पुत्र अम्मिएल; ");
INSERT INTO hincv_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","आशेर के गोत्र से मिखाएल का पुत्र सेथुर; ");
INSERT INTO hincv_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","नफताली के गोत्र से वोफसी का पुत्र नाहबी; ");
INSERT INTO hincv_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","तथा गाद के गोत्र से माखी का पुत्र गेउएल. ");
INSERT INTO hincv_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ये नाम उन व्यक्तियों के हैं, जिन्हें मोशेह ने उस देश का भेद लेने के उद्देश्य से भेजा था. (मोशेह नून के पुत्र होशिया को यहोशू बुलाते थे.) ");
INSERT INTO hincv_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","कनान देश में भेद लेने के उद्देश्य से भेजते हुए मोशेह ने उन्हें यह आज्ञा दी, “तुम उस नेगेव प्रदेश में जाओ; उसके बाद पर्वतीय प्रदेश में जाना. ");
INSERT INTO hincv_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","देखना कि वह देश किस प्रकार का है, वहां के निवासी बलवान हैं या कमजोर, संख्या में कम हैं या बहुत. ");
INSERT INTO hincv_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","वह देश, जहां लोग निवास करते हैं, कैसा है वह देश, अच्छा या बुरा? कैसे हैं वे नगर, जहां वे निवास करते हैं, क्या ये नगर खुले में हैं अथवा वे क़िले में बसे हैं? ");
INSERT INTO hincv_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","वहां की भूमि कैसी है, उपजाऊ या बंजर? वहां वृक्ष हैं या नहीं? इसके बाद तुम उस देश के कुछ फल साथ ले आने की कोशिश करना.” (यह अंगूरों की पहली पकी फसल का समय है.) ");
INSERT INTO hincv_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","तब वे चले गए. उन्होंने ज़िन के निर्जन प्रदेश से लेकर लबो-हामाथ के रेहोब तक उस प्रदेश का भेद लिया. ");
INSERT INTO hincv_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","उन लोगों ने जब नेगेव में प्रवेश किया, वे हेब्रोन पहुंच गए, जहां अनाक के घराने के अहीमान, शेशाइ तथा तालमाई निवास करते थे. (हेब्रोन नगर मिस्र देश के ज़ोअन के सात वर्ष पहले बन चुका था.) ");
INSERT INTO hincv_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","इसके बाद वे एशकोल घाटी में जा पहुंचे. वहां उन्होंने एक डाली काट ली, जिसमें अंगूरों का एक ही गुच्छा था. इसे उन्होंने एक लाठी पर लादा और दो व्यक्तियों ने उसको उठा लिया. इसके अलावा वे कुछ अनार एवं अंजीर भी ले आए. ");
INSERT INTO hincv_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","वह स्थान एशकोल घाटी के नाम से मशहूर हो गया, क्योंकि इस्राएल के घराने वहां से वह अंगूर का गुच्छा साथ ले गए थे. ");
INSERT INTO hincv_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","चालीस दिन के बाद वे उस देश का भेद लेकर लौटे. ");
INSERT INTO hincv_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","वे पारान के निर्जन प्रदेश के कादेश में मोशेह, अहरोन तथा इस्राएल के घराने की सारी सभा के सामने उपस्थित हुए. उन्होंने उस देश के फल उनके सामने दिखाते हुए सारी सभा के सामने अपना संदेश रख दिया. ");
INSERT INTO hincv_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","अपने संदेश में उन्होंने यह कहा: “आपके द्वारा बताए गए देश में हम गए थे. इसमें कोई संदेह नहीं कि इस देश में दूध एवं मधु का भण्ड़ार है. हम वहां से ये फल भी लाए हैं. ");
INSERT INTO hincv_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","किंतु, उस देश के निवासी बलवान हैं, नगर किले में बसे हैं, तथा आकार में बहुत बड़े हैं. इसके अलावा हमने वहां अनाक के घराने के लोग भी देखे हैं. ");
INSERT INTO hincv_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","वहां नेगेव में तो अमालेक का निवास है, तथा पर्वतीय क्षेत्र में हित्ती, यबूसी तथा अमोरियों का; समुद्र के पास वाले क्षेत्र में तथा यरदन के इस ओर कनानी निवास करते हैं.” ");
INSERT INTO hincv_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","मोशेह के सामने ही कालेब ने लोगों को शांत हो जाने की विनती की तथा उन्हें इस प्रकार कहा, “हर परिस्थिति में हमें वहां जाकर इस देश पर अधिकार कर लेना अच्छा होगा, क्योंकि हम निश्चय उस पर अधिकार कर लेंगे.” ");
INSERT INTO hincv_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","किंतु अन्य पुरुष, जो कालेब के साथ वहां गए थे, कहने लगे, “हम लोग उन लोगों पर आक्रमण करने योग्य हैं ही नहीं, क्योंकि वे लोग हमारी अपेक्षा ज्यादा बलवान हैं.” ");
INSERT INTO hincv_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","इस प्रकार उन्होंने इस्राएल के घराने के सामने उस देश की, जिसका वे भेद लेकर आए थे, खराब राय दी! वे कह रहे थे, “जिस देश में हम भेद लेने के उद्देश्य से गए थे, एक ऐसा देश है, जो अपने निवासियों को निगल लेता है. हमने वहां जितने भी पुरुष देखे, वे सभी बड़े डीलडौल वाले पुरुष ही थे. ");
INSERT INTO hincv_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","हमने तो वहां नैफ़िलिन भी देखे हैं, (अनाक की संतान भी नैफ़िलिन के संबंधी ही हैं). उनकी ओर दृष्टि करते हुए हम अपनी दृष्टि में टिड्डियों के समान लग रहे थे, तथा जब वे हमें देखते थे तो वे हमें टिड्डियां समझ रहे थे.” ");
INSERT INTO hincv_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","तब सारा समुदाय ऊंची आवाज में रोने लगा. उस रात वे सभी रोते रहे. ");
INSERT INTO hincv_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","हर एक इस्राएली मोशेह तथा अहरोन के विरुद्ध बड़बड़ा रहा था. एक स्वर में उन्होंने मोशेह तथा अहरोन से कहा, “अच्छा होता हमारी मृत्यु मिस्र देश में ही हो गई होती, यदि वहां नहीं तो इस निर्जन प्रदेश में! ");
INSERT INTO hincv_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","याहवेह हमें क्यों इस देश में ले जाने पर उतारू हैं, क्या तलवार से मरवाने के लिए? हमारी पत्नियां एवं हमारे बच्‍चे वहां उनकी लूट सामग्री होकर रह जाएंगे. क्या भला न होगा कि हम मिस्र देश ही लौट जाएं?” ");
INSERT INTO hincv_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","उन्होंने आपस में यह विचार-विमर्श किया, “चलो, हम अपने लिए एक प्रधान को नियुक्त करें और लौट जाएं, मिस्र देश को.” ");
INSERT INTO hincv_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","यह सुन मोशेह एवं अहरोन सारी इस्राएली मण्डली के सामने मुंह के बल गिर पड़े. ");
INSERT INTO hincv_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","नून के पुत्र यहोशू तथा येफुन्‍नेह के पुत्र कालेब ने, जो इस देश में भेद लेने के लिए गए थे, अपने वस्त्र फाड़ दिए. ");
INSERT INTO hincv_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","सारे इस्राएल के घराने को संबोधित कर उन्होंने कहा, “वह देश, जिसकी सारी भूमि का हमने भेद लिया है, बहुत ही उपजाऊ भूमि है. ");
INSERT INTO hincv_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","यदि याहवेह की हम पर कृपादृष्टि बनी रहती है, तो वह हमें इस देश में ले जाएंगे तथा यह हमें दे देंगे; ऐसा देश जिसमें दूध एवं मधु का भण्ड़ार है. ");
INSERT INTO hincv_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","बस याहवेह के प्रति विद्रोह न करो. उस देश के निवासियों से भयभीत न हो जाओ, क्योंकि उन्हें तो हमारा शिकार होना ही है. उन पर से उनकी सुरक्षा हटाई जा चुकी है, तथा याहवेह हमारे साथ हैं. मत डरो उनसे.” ");
INSERT INTO hincv_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","किंतु सारी मण्डली उन पर पथराव करने पर उतारू हो गई. तब मिलनवाले तंबू पर सारे इस्राएल के घराने पर याहवेह की ज्योति प्रकाशमान हुई. ");
INSERT INTO hincv_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","याहवेह ने मोशेह से प्रश्न किया, “और कब तक ये लोग मेरा तिरस्कार करते रहेंगे? कब तक वे मुझमें विश्वास न करेंगे, जबकि मैं उनके बीच में ये सारे चिन्ह दिखा चुका हूं? ");
INSERT INTO hincv_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","मैं उन पर महामारी डालकर उनको बाहर निकाल दूंगा. इसके बाद मैं तुमसे एक ऐसे राष्ट्र को उत्पन्‍न करूंगा, जो इनसे अधिक संख्या में और बलवान होगा.” ");
INSERT INTO hincv_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","किंतु मोशेह ने निवेदन करते हुए याहवेह से कहा, “तब तो मिस्रवासी इस विषय में सुन ही लेंगे, क्योंकि आपने अपने भुजबल के द्वारा इन लोगों को उनके बीच में से निकाला है. ");
INSERT INTO hincv_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","वे इसका वर्णन यहां के निवासियों से करेंगे. उन्हें यह मालूम है कि आप याहवेह, हम लोगों के बीच में ही हैं. याहवेह, जब आपका बादल उन पर छाया करता था, यह उनके द्वारा आमने-सामने देखा जा चुका है, तथा यह भी कि आप दिन के समय बादल का खंभा तथा रात में आग का खंभा बनकर इनके आगे-आगे चल रहे हैं. ");
INSERT INTO hincv_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","यदि आप इस राष्ट्र को इस रीति से खत्म कर देंगे, मानो यह जनता एक ही व्यक्ति है, तब जिन राष्ट्रों ने आपकी कीर्ति के विषय में सुन रखा है, यही कहेंगे, ");
INSERT INTO hincv_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘यह इसलिये हुआ है कि याहवेह इस राष्ट्र को अपनी शपथ के साथ की गई प्रतिज्ञा के अनुसार उस देश में ले जाने में सफल नहीं रह पाए हैं, इसलिये उन्होंने इस राष्ट्र को निर्जन प्रदेश में ही मार डाला.’ ");
INSERT INTO hincv_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“किंतु अब, मेरे प्रभु, आपसे मेरी यह विनती है, आपकी सामर्थ्य की महिमा आपके कहने के अनुसार हो: ");
INSERT INTO hincv_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘याहवेह क्रोध करने में धीरजवंत तथा अति करुणामय, वह अधर्म एवं अपराध के लिए क्षमा करनेवाले हैं, किंतु वह किसी भी स्थिति में दोषी को बिना दंड दिए नहीं छोड़ते. वह पूर्वजों के अधर्म का दंड उनके बेटों, पोतों और परपोतों तक को देते हैं.’ ");
INSERT INTO hincv_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","याहवेह, आपके कभी न बदलनेवाले प्रेम की बहुतायत के अनुसार, मेरी विनती है, अपनी प्रजा के अपराध को क्षमा कर दीजिए, ठीक जिस प्रकार आप मिस्र से निकालने से लेकर अब तक अपनी प्रजा को क्षमा करते रहे हैं.” ");
INSERT INTO hincv_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","फिर याहवेह ने उन्हें उत्तर दिया, “तुम्हारी विनती के अनुसार मैं उन्हें क्षमा कर चुका हूं. ");
INSERT INTO hincv_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","किंतु याद रहे, शपथ मेरे जीवन की, सारी धरती याहवेह की महिमा से भर जाएगी, ");
INSERT INTO hincv_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","उन सभी व्यक्तियों ने, जिन्होंने मेरी महिमा और मेरे द्वारा दिखाए गए चिन्हों को देख लिया है, जो मैंने मिस्र देश में तथा यहां निर्जन प्रदेश में दिखाए हैं, फिर भी दस अवसरों पर मेरे आदेशों की उपेक्षा की और मेरी परीक्षा की है, ");
INSERT INTO hincv_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","वे किसी भी रीति से उस देश को देख न पाएंगे, जिसकी शपथ मैंने उनके पूर्वजों से की थी, वैसे ही वे भी इस देश को न देख पाएंगे, जिन्होंने मेरा इनकार किया है. ");
INSERT INTO hincv_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","किंतु मेरे सेवक कालेब में, एक अलग आत्मा है और जिसने पूरी-पूरी रीति से मेरा अनुसरण किया है, उसे ही मैं उस देश में ले जाऊंगा, जिसका वह भेद ले चुका है, उसके वंशज उस देश पर अधिकार कर लेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","इस समय उन घाटियों में अमालेकियों तथा कनानियों का निवास है. कल तुम लाल सागर के मार्ग से निर्जन प्रदेश की ओर कूच करना.” ");
INSERT INTO hincv_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","याहवेह ने मोशेह तथा अहरोन को संबोधित किया: ");
INSERT INTO hincv_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“बताओ, मैं कब तक इस कुटिल सभा के प्रति सहानुभूति दिखाता रहूं, जो मेरे विरुद्ध बड़बड़ा रहे हैं? इस्राएल के घराने के अपशब्द मेरे कानों तक पहुंच चुके हैं, वे अपशब्द, जो वे मेरे विरुद्ध कह रहे हैं. ");
INSERT INTO hincv_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","तुम उनसे यह कहो, ‘मेरे जीवन की शपथ,’ यह याहवेह का वचन है, ‘ठीक जैसा जैसा तुमने मेरे सुनने में बातें की हैं,’ निश्चित ही तुम्हारे लिए मैं ठीक वैसा ही कर दूंगा. ");
INSERT INTO hincv_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","तुम्हारे शव इस निर्जन प्रदेश में धराशाई पड़े रहेंगे; उन सब की जिनकी गिनती की जा चुकी है. बीस वर्ष से ऊपर की आयु के सभी व्यक्ति, जिन्होंने मेरे विरुद्ध आवाज उठाकर बड़बड़ की है. ");
INSERT INTO hincv_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","निश्चित ही तुम सब उस देश में प्रवेश नहीं करोगे, जिसमें तुम्हें बसा देने की शपथ मैंने तुमसे की थी; सिर्फ येफुन्‍नेह के पुत्र कालेब तथा नून के पुत्र यहोशू के अलावा. ");
INSERT INTO hincv_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","हां, तुम्हारी संतान, जिनके विषय में तुमने कहा था कि वे उनके भोजन हो जाएंगे, उन्हें मैं उस देश में ले जाऊंगा. वे ही उस देश पर अधिकार करेंगे, जिसे तुमने ठुकरा दिया है. ");
INSERT INTO hincv_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","किंतु तुम्हारे लिए तो यही तय हो चुका है तुम्हारे शव इस निर्जन प्रदेश में पड़े रहेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","तुम्हारे वंशज चालीस वर्ष इस निर्जन प्रदेश में चरवाहे होंगे तथा वे तुम्हारे द्वारा किए गए इस विश्वासघात के लिए कष्ट भोगेंगे और तुम्हारे शव निर्जन प्रदेश में पड़े पाए जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","यह उसी अनुपात में होगा, जितने दिन तुमने उस देश का भेद लिया था; चालीस दिन-भेद लेने के, एक दिन के लिए इस निर्जन प्रदेश में एक वर्ष, कुल चालीस वर्ष. तब तुम अपने पाप के कारण कष्ट भोगोगे और मुझसे विरोध का परिणाम समझ जाओगे. ");
INSERT INTO hincv_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","मैं, याहवेह ने, यह घोषणा कर दी है, मैं इस पूरी बुरी सभा के साथ निश्चित ही यह करूंगा, जो मेरे विरुद्ध एकजुट हो गए हैं. इसी निर्जन प्रदेश में नष्ट हो जाएंगे; यहीं उनकी मृत्यु हो जाएगी.” ");
INSERT INTO hincv_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","वैसे उन लोगों की नियति, जिन्हें मोशेह ने उस देश का भेद लेने के उद्देश्य से भेजा था और जिन्होंने लौटने पर उस देश का उलटा चित्रण किया था, जिन्होंने सारी सभा को बड़बड़ाने के लिए उभार दिया था, ");
INSERT INTO hincv_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ये वे ही थे, जिन्होंने उस देश का अत्यंत भयानक चित्र प्रस्तुत किया था, याहवेह ही के सामने महामारी से उनकी मृत्यु हो गई. ");
INSERT INTO hincv_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","किंतु नून के पुत्र यहोशू तथा येफुन्‍नेह के पुत्र कालेब ही उनमें से जीवित रहे, जो उस देश का भेद लेने के लिए गए हुए थे. ");
INSERT INTO hincv_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","जब मोशेह ने सभी इस्राएलियों के सामने यह बातें दोहराई, वे घोर विलाप करने लगे. ");
INSERT INTO hincv_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","फिर भी, वे बड़े तड़के उठे और इस विचार से, “निश्चयतः हमने पाप किया है. अब हम यहां तक पहुंच चुके हैं, हम याहवेह के प्रतिज्ञा किए हुए देश को चले जाएंगे!” ");
INSERT INTO hincv_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","किंतु मोशेह ने आपत्ति की, “तुम लोग याहवेह के आदेश का उल्लंघन करने पर उतारू क्यों हो? यह कार्य हो ही नहीं सकता! ");
INSERT INTO hincv_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","मत जाओ वहां, नहीं तो तुम शत्रुओं द्वारा हरा दिए जाओगे, क्योंकि अब तुम पर याहवेह का आश्रय नहीं रहा, ");
INSERT INTO hincv_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","वहां तुम स्वयं को अमालेकियों एवं कनानियों के सामने पाओगे और तुम तलवार से मार दिए जाओगे, क्योंकि तुमने याहवेह का अनुसरण करने को तुच्छ जाना है. यहां याहवेह तुम्हारे साथ न रहेंगे.” ");
INSERT INTO hincv_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","किंतु वे मोशेह की चेतावनी को न मानते हुए उस पर्वतीय क्षेत्र के टीले पर चढ़ गए. न तो मोशेह ने छावनी छोड़ी थी और न ही वाचा के संदूक को छावनी के बाहर लाया गया था. ");
INSERT INTO hincv_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","तब उस पर्वतीय क्षेत्र के निवासी अमालेकी तथा कनानी उन पर टूट पड़े और होरमाह नामक स्थान तक उनका पीछा करते हुए उनको मारते चले गए. ");
INSERT INTO hincv_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“इस्राएल के घराने को यह आज्ञा दो: ‘जब तुम उस देश में प्रवेश करोगे, जहां तुम्हें बस जाना है, जो मैं तुम्हें देने जा रहा हूं, ");
INSERT INTO hincv_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","तब तुम वहां याहवेह के लिए अपनी भेड़-बकरियां और गाय-बैलों में से आग के द्वारा बलि चढ़ाना; होमबलि अथवा विशेष मन्नत पूरी करने के लिए या स्वेच्छा बलि या निर्धारित अवसरों से संबंधित बलि, कि यह याहवेह के सामने सुगंध हो जाए. ");
INSERT INTO hincv_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","वह, जो याहवेह को भेंट बलि अर्पण करेगा, वह डेढ़ किलो मैदे को एक लीटर तेल में मिलाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","हर एक मेमने की बलि अथवा होमबलि के साथ तुम पेय बलि के लिए एक लीटर दाखमधु भेंट करोगे. ");
INSERT INTO hincv_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘अथवा मेढ़े की बलि चढ़ाने के लिए तुम तीन किलो मैदा, 1.30 लीटर तेल में मिलाओगे. ");
INSERT INTO hincv_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","पेय बलि के रूप में तुम याहवेह को सुखद-सुगंध के लिए एक लीटर दाखमधु चढ़ाओगे. ");
INSERT INTO hincv_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘जब तुम याहवेह को विशेष मन्नत पूरी करने के रूप में या मेल बलि स्वरूप होमबलि या बलि के लिए बछड़े को तैयार करो, ");
INSERT INTO hincv_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","तब तुम उस बछड़े के साथ पांच किलो मैदे के साथ 1.9 लीटर तेल का मिश्रण चढ़ाओगे. ");
INSERT INTO hincv_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","इसके अलावा तुम डेढ़ लीटर दाखमधु याहवेह के लिए सुखद-सुगंध चढ़ाओगे. ");
INSERT INTO hincv_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","हर एक बछड़े, हर एक मेढ़े, हर एक मेमने अथवा हर एक बकरे के लिए यही विधि ठहराई गई है. ");
INSERT INTO hincv_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","हर एक पशु की संख्या के अनुसार हर एक के लिए यही किया जाना ज़रूरी है. ");
INSERT INTO hincv_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘हर एक, जो देश का निवासी है, इस विधि के अनुसार यह किया करेगा, कि आग के द्वारा भेंट यह याहवेह के लिए सुखद-सुगंध हो जाए. ");
INSERT INTO hincv_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","यदि तुम्हारे बीच कोई परदेशी है, चाहे थोड़े समय से या स्थायी रूप से, पीढ़ी-पीढ़ी से, और वह अग्निबलि भेंट करना चाहता है, कि यह याहवेह के लिए सुखद-सुगंध हो जाए, वह भी ठीक यही करेगा. ");
INSERT INTO hincv_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","पूरी सभा के लिए, चाहे तुम हो अथवा कोई परदेशी, एक ही विधि लागू होगी. यही तुम्हारी सारी पीढ़ियों के लिए स्थायी विधि होगी. याहवेह के सामने तुम सब परदेशी के समान हो. ");
INSERT INTO hincv_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","तुम्हारे लिए तथा उस परदेशी के लिए एक ही नियम तथा एक ही विधि होनी ज़रूरी है.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","फिर याहवेह ने मोशेह को यह आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“इस्राएल के घराने को संबोधित कर उन्हें आदेश दो, ‘जब तुम उस देश में प्रवेश करो, जहां मैं तुम्हें ले जा रहा हूं, ");
INSERT INTO hincv_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","और जब तुम उस देश की उपज को खाने लगो, उसका एक अंश तुम याहवेह को भेंट करोगे. ");
INSERT INTO hincv_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","यह खलिहान का अर्पित किया हुआ अंश होगा. यह तुम याहवेह को चढ़ाओगे. ");
INSERT INTO hincv_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","अपने पहले गूंधे हुए आटे के अंश को तुम अपनी सारी पीढ़ियों में याहवेह को भेंट करते रहोगे. ");
INSERT INTO hincv_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘किंतु भूल से तुम इन आदेशों के पालन में असफल हो जाते हो, जो याहवेह ने मोशेह को बताए हैं, ");
INSERT INTO hincv_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","अर्थात् वह सभी, जो याहवेह ने तुम्हें मोशेह के द्वारा आज्ञा देकर पालन करने का आदेश दिया है, उस दिन से ले, जब ये आदेश दिए गए थे, तुम्हारी सारी पीढ़ियों तक, ");
INSERT INTO hincv_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","यदि यह भूल से किया गया हो तथा जिसके विषय में सारी इस्राएली सभा को कोई जानकारी नहीं हो पाई है, तब सारी सभा गाय-बैलों से होमबलि के लिए एक बछड़ा भेंट करेगी, इसकी अन्‍नबलि तथा पेय बलि के साथ यह याहवेह के लिए नियम के अनुसार एक सुखद-सुगंध हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","फिर पुरोहित सारे इस्राएल के घराने की ओर से प्रायश्चित बलि भेंट करेगा और इससे उन्हें क्षमा दी जाएगी; क्योंकि यह अनजाने में की गई भूल थी; इसलिये उन्होंने यह भेंट चढ़ाई है. आग के द्वारा याहवेह को अर्पित बलि तथा अपनी भूल के लिए भेंट पापबलि. ");
INSERT INTO hincv_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","इस प्रकार इस्राएल के घराने की सारी सभा को क्षमा दे दी जाएगी-इसमें वह परदेशी भी शामिल होगा, जो उनके बीच रह रहा होगा, क्योंकि सभी इस्राएलियों में यह अनजाने में हुआ कार्य था. ");
INSERT INTO hincv_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘इसके अलावा यदि कोई व्यक्ति भूल से पाप कर बैठता है, वह एक वर्षीय बकरी पापबलि के लिए भेंट करे. ");
INSERT INTO hincv_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","पुरोहित याहवेह के सामने जाकर उस व्यक्ति के लिए प्रायश्चित करे, जो भूल से पाप कर बैठता है, जो रास्ते से भटक जाता है, पुरोहित ऐसे व्यक्ति के लिए प्रायश्चित करे, कि उस व्यक्ति को क्षमा प्राप्‍त हो जाए. ");
INSERT INTO hincv_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","कोई भी व्यक्ति, जो भूल से कोई भी पाप कर बैठता है, उस पर एक ही नियम लागू किया जाए; वह, जो स्वदेशी है, और वह जो तुम्हारे बीच रह रहा विदेशी है. ");
INSERT INTO hincv_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘किंतु वह व्यक्ति, जो ढिठाई करता है, चाहे वह स्वदेशी हो या तुम्हारे बीच रह रहा विदेशी, वह यह करते हुए याहवेह की निंदा कर रहा होता है, ऐसा व्यक्ति अपने लोगों के बीच से नाश कर दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","उसने याहवेह के आदेश को तुच्छ समझा और उनके आदेश को टाला है. उसे पूरी तरह नाश कर दिया जाए; इसके लिए वह स्वयं ही दोषी होगा.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","जब इस्राएली निर्जन प्रदेश में रहते थे, एक ऐसे व्यक्ति से उनकी भेंट हुई, जो शब्बाथ के दिन ईंधन-लकड़ी इकट्ठी कर रहा था. ");
INSERT INTO hincv_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","जिन्होंने उसे यह करते देखा, वे उसे मोशेह, अहरोन तथा सारी सभा के सामने ले आए. ");
INSERT INTO hincv_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","जब तक उसके विषय में कोई निर्णय नहीं लिया गया, तब तक उसे बंदी बनाकर रखा गया. ");
INSERT INTO hincv_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","याहवेह ने मोशेह को यह आज्ञा दी: “अवश्य है कि उस व्यक्ति को निश्चित ही मृत्यु दंड दिया जाए. छावनी के बाहर ले जाकर सारी सभा उस पर पत्थराव करे.” ");
INSERT INTO hincv_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","तब सारी सभा ने उसे छावनी से दूर ले जाकर पत्थराव कर दिया, जैसा याहवेह ने मोशेह को आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","याहवेह ने मोशेह को यह आज्ञा भी दी, ");
INSERT INTO hincv_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“सारे इस्राएल को आज्ञा दो कि वे अपने-अपने वस्त्रों के किनारों पर पीढ़ी से पीढ़ी फुंदने लगाया करें तथा फुन्दनों के कोनों पर नीली डोरी हो. ");
INSERT INTO hincv_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","यह फुंदना तुम्हारे लिए याहवेह की आज्ञा का चिन्ह होगा, कि तुम अपनी-अपनी मान्यताओं के अनुसार चलने न लगो, जैसा करके तुमने परमेश्वर के साथ दाम्पत्य विश्वासघात के समान काम किया था. ");
INSERT INTO hincv_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","तुम्हें मेरी सारी आज्ञाओं का पालन करना याद रहे, और तुम अपने परमेश्वर के सामने पवित्र बने रहो. ");
INSERT INTO hincv_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","मैं तुम्हारा वही परमेश्वर, याहवेह हूं, मैंने तुम्हें मिस्र देश से इसलिये निकाला है, कि मैं तुम्हारा परमेश्वर ठहरूं. मैं ही तुम्हारा वह याहवेह परमेश्वर हूं!” ");
INSERT INTO hincv_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","इस समय कोराह, जिसका पिता इज़हार था, जिसका पिता कोहाथ था, जो लेवी का पुत्र था; तथा दाथान और अबीराम, जो एलियाब के पुत्र थे, तथा ओन, जो पेलेथ का पुत्र था, आज्ञा न माननेवाले हो गए. ");
INSERT INTO hincv_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","इन्होंने मोशेह के विरुद्ध अपनी आवाज उठाई. इनके साथ इस्राएल में से 250 व्यक्ति भी शामिल हो गए, जो सभा के चुने हुए तथा नामी प्रधान थे. ");
INSERT INTO hincv_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ये सभी मोशेह एवं अहरोन के विरोध में एकजुट होकर उनसे कहने लगे, “आप लोग तो बहुत ऊंचे उड़ने लगे हैं! इस्राएली समाज में हममें से हर एक ही पवित्र व्यक्ति है तथा उन सभी के बीच परमेश्वर का वास है. फिर आप ही स्वयं को याहवेह की प्रजा में सबके ऊपर क्यों दिखाते हैं?” ");
INSERT INTO hincv_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","जब यह बातें मोशेह ने सुनी, वह मुंह के बल गिर पड़े. ");
INSERT INTO hincv_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","तथा उन्होंने कोराह एवं उसकी सारी मण्डली को संबोधित करते हुए कहा, “कल सुबह याहवेह यह स्पष्ट कर देंगे कि वह किसके पक्ष में हैं, कौन पवित्र है तथा वही उसे अपने निकट बुलाएंगे. याहवेह जिस किसी को चुनेंगे, उसे ही अपने निकट बुला लेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","तुम्हें यह करना होगा: तुम सभी कोराह के घराने के लोग धूपदान तैयार रखना, ");
INSERT INTO hincv_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","तुम कल याहवेह के सामने उनमें आग रख उस पर धूप डाल देना. जिस किसी को याहवेह चुनेंगे, वही होगा वह पवित्र व्यक्ति. ओ तुम लेवी के घराने, फूले जा रहे हो!” ");
INSERT INTO hincv_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","इसके बाद मोशेह ने यह कहा, “लेवी के घराने, अब यह सुन लो! ");
INSERT INTO hincv_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","क्या तुम्हारी समझ से यह कोई छोटा विषय है कि सारे इस्राएल के घराने में से इस्राएल के परमेश्वर ने तुम्हें अलग करना सही समझा है, कि वह तुम्हें अपने पास रखें, ताकि याहवेह के साक्षी तंबू संबंधी सेवा किया करें, तथा इस्राएल की सारी सभा के सामने उपस्थित होकर उनकी सेवा करें, ");
INSERT INTO hincv_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","तथा याहवेह ने तुम्हें और तुम्हारे सभी भाइयों को, जो लेवी के घराने के हैं, तुम्हारे साथ अपने पास रखा है? ");
INSERT INTO hincv_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","फिर तुम एवं तुम्हारे ये सारे साथी आज वस्तुतः स्वयं याहवेह के विरुद्ध खड़े हो गए हो. अहरोन है ही कौन, जो तुम उसके विरुद्ध बड़बड़ा रहे हो?” ");
INSERT INTO hincv_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","मोशेह ने आज्ञा दी कि एलियाब के पुत्र दाथान तथा अबीराम उनके सामने लाए जाएं. उन्होंने उत्तर दिया, “हम नहीं आएंगे! ");
INSERT INTO hincv_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","क्या यह कोई छोटा विषय है कि आप हमें एक ऐसे देश से, जिसमें दूध और मधु का भण्ड़ार है, निकालकर यहां निर्जन प्रदेश में मरने के लिए ले आए हैं, कि आप स्वयं को हम पर शासक बना बैठें? ");
INSERT INTO hincv_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","इसके अलावा, आप हमें ऐसे किसी देश में नहीं ले आए हैं, जहां दूध और मधु का भण्ड़ार है, और न ही आपने हमें ऐसी मीरास दी है, जहां खेत तथा अंगूरों के बगीचे हैं. क्या मतलब है आपका, आप इनकी आंखें निकालना चाह रहे हैं? हम वहां नहीं आएंगे!” ");
INSERT INTO hincv_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","मोशेह बहुत ही क्रोधित हो गए. उन्होंने याहवेह से कहा, “उनकी भेंट स्वीकार न कीजिए. मैंने न तो उनसे एक गधा भी लिया है, न मैंने उनमें से एक की भी कोई हानि की है.” ");
INSERT INTO hincv_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","मोशेह ने कोराह को आज्ञा दी, “कल तुम तथा तुम्हारे सभी साथी याहवेह के सामने उपस्थित होंगे—तुम तथा तुम्हारे साथी एवं अहरोन. ");
INSERT INTO hincv_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","तुममें से हर एक अपने-अपने धूपदान में धूप रखे और हर एक अपना अपना धूपदान याहवेह के सामने ले आए, ये सब 250 धूपदान होंगे, तुम्हारे और अहरोन के धूपदान भी होंगे.” ");
INSERT INTO hincv_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","तब इनमें से हर एक ने अपना अपना धूपदान लिया, उसमें आग रखी तथा आग पर धूप. तब वे सभी मोशेह एवं अहरोन के साथ मिलनवाले तंबू के सामने खड़े हो गए. ");
INSERT INTO hincv_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","कोराह ने मिलनवाले तंबू के सामने सारे इस्राएल के घराने को इकट्ठा कर लिया. तब याहवेह का प्रताप सारी इस्राएली सभा पर प्रकाशमान हुआ. ");
INSERT INTO hincv_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","याहवेह ने मोशेह तथा अहरोन को संबोधित किया, ");
INSERT INTO hincv_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“तुम दोनों स्वयं को इस समूह से अलग कर लो कि मैं इन्हें पलक झपकते ही भस्म कर दूं.” ");
INSERT INTO hincv_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","यह सुन वे दोनों मुंह के बल गिर पड़े. उन्होंने याहवेह से विनती की, “परमेश्वर, आप, जो सभी मनुष्यों की आत्माओं के परमेश्वर हैं, क्या आप इस व्यक्ति के पाप का दंड पूरे समाज को दे देंगे?” ");
INSERT INTO hincv_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","याहवेह ने मोशेह को उत्तर दिया, ");
INSERT INTO hincv_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“सारी इस्राएली सभा को आज्ञा दो, ‘वे कोराह, दाथान तथा अबीराम के तंबुओं से दूर चले जाएं.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","फिर मोशेह दाथान एवं अबीराम की ओर बढ़े और इस्राएल के पुरनिये उनके पीछे-पीछे चलने लगे. ");
INSERT INTO hincv_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","मोशेह ने इस्राएली सभा को आज्ञा दी, “कृपा कर इन दुष्ट व्यक्तियों के शिविरों से दूर हो जाओ तथा उनकी किसी भी वस्तु को नहीं छूना, नहीं तो तुम भी उनके सारे पापों के साथ समेट लिए जाओगे.” ");
INSERT INTO hincv_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","तब वे कोराह, दाथान तथा अबीराम के तंबुओं से दूर हट गए. दाथान तथा अबीराम बाहर आकर अपनी-अपनी पत्नियों तथा बच्चों के साथ शिविर के द्वार पर खड़े हो गए. ");
INSERT INTO hincv_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","मोशेह ने घोषणा की, “अब तुम्हें यह अहसास हो जाएगा, कि ये सारे काम करने की जवाबदारी मुझे स्वयं याहवेह द्वारा सौंपी गई है, यह मेरी बनाई योजना नहीं हैं. ");
INSERT INTO hincv_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","यदि इन व्यक्तियों का निधन अन्य मनुष्यों के समान स्वाभाविक रीति से हो जाए या इनकी नियति सारी मानव जाति के समान हो, तब समझ लेना कि मैं याहवेह का भेजा हुआ नहीं हूं. ");
INSERT INTO hincv_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","किंतु यदि याहवेह आज कुछ असाधारण काम कर दिखाते हैं, यदि आज भूमि अपना मुख खोल इन्हें, इनकी सारी संपत्ति को निगल लेती है, कि वे जीवित ही भूमि में समा जाएं, तब तुम्हें यह निश्चय हो जाएगा, कि इन लोगों ने याहवेह को तुच्छ समझा है.” ");
INSERT INTO hincv_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","जैसे ही मोशेह का यह कहना समाप्‍त हुआ, उनके नीचे भूमि फटकर खुल गई; ");
INSERT INTO hincv_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","पृथ्वी ने, मानो अपना मुंह खोल, उन्हें निगल लिया; उनके घर-परिवारों को, कोराह के सभी संबंधियों को उन सब की संपत्ति सहित. ");
INSERT INTO hincv_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","तब वे तथा उनकी सारी संपदा जीवित ही भूमि के गर्भ में समा गए और भूमि उनके ऊपर अपनी पहले की सी स्थिति में आ गई, वे इस्राएल की सभा के बीच से मिट गए. ");
INSERT INTO hincv_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","उनके आस-पास के सारे इस्राएली उनकी चिल्लाहट सुनकर वहां से भाग गए, इस भय से, “कहीं भूमि हमें भी अपना कौर न बना ले!” ");
INSERT INTO hincv_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","तब याहवेह की ओर से भेजी गई आग ने उन ढाई सौ व्यक्तियों को भस्म कर दिया, जो धूप भेंट कर रहे थे. ");
INSERT INTO hincv_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“पुरोहित अहरोन के पुत्र एलिएज़र को आज्ञा दो, कि वह इस जलती हुई आग के बीच में से धूपदानों को इकट्ठा कर ले, क्योंकि वे पवित्र वस्तुएं हैं. उनमें के जलते हुए अंगारों को इधर-उधर बिखरा दो. ");
INSERT INTO hincv_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","उन व्यक्तियों ने अपने प्राणों के मूल्य पर यह पाप किया है, उनके धूपदानों को इकट्ठा कर उन्हें पीट-पीटकर पत्रक बना लो ताकि वे वेदी पर मढ़ने के लिए इस्तेमाल किए जाएं. वे पवित्र वस्तुएं हैं, क्योंकि उन्होंने इन्हें याहवेह को भेंट किया था. यह इस्राएल के घराने के सामने एक चिन्ह हो जाएगा.” ");
INSERT INTO hincv_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","तब उन व्यक्तियों के द्वारा भेंट धूपदानों को, जो इस आग में नाश हो चुके थे, एलिएज़र ने इकट्ठा किया और उन्होंने इन्हें पीट-पीटकर वेदी पर मढ़ने का पत्रक बना डाला. ");
INSERT INTO hincv_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","यह सारे इस्राएल के सामने एक चेतावनी थी, कि कोई भी व्यक्ति, जो अहरोन के वंश का नहीं है, वह याहवेह के सामने आकर धूप न चढ़ाए, कि उसकी दशा वह न हो जो कोराह एवं उसके साथियों की हुई, ठीक जैसी पूर्वघोषणा मोशेह के द्वारा याहवेह ने की थी. ");
INSERT INTO hincv_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","किंतु दूसरे ही दिन सारा इस्राएल का घराना मोशेह एवं अहरोन के विरोध में इस प्रकार बड़बड़ाने लगा. “तुम दोनों ही के कारण याहवेह के इन चुने हुओं की मृत्यु हुई है.” ");
INSERT INTO hincv_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","किंतु उसी समय हुआ यह, कि जब सारी सभा मोशेह एवं अहरोन के विरोध में खड़ी हो चुकी थी, वे मिलनवाले तंबू की दिशा में आगे बढ़ रहे थे, यह सामने देखा गया कि मिलनवाले तंबू पर वह बादल छा गया तथा वहां याहवेह का प्रताप प्रकट हो गया. ");
INSERT INTO hincv_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","फिर मोशेह एवं अहरोन मिलनवाले तंबू के सामने जा खड़े हुए. ");
INSERT INTO hincv_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","याहवेह ने मोशेह को संबोधित कर कहा, ");
INSERT INTO hincv_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“इस सभा से दूर चले जाओ कि मैं इन्हें इसी क्षण भस्म कर दूं.” वे यह सुन मुंह के बल गिर पड़े. ");
INSERT INTO hincv_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","मोशेह ने अहरोन को आज्ञा दी, “अपने धूपदान में वेदी की आग डालकर उस पर धूप डाल दो और बिना देर किए इसे सभा के निकट लाकर उनके लिए प्रायश्चित करो, क्योंकि याहवेह का क्रोध उन पर भड़क चुका है, महामारी शुरू हो चुकी है.” ");
INSERT INTO hincv_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","अहरोन ने ठीक यही किया. वह दौड़ता हुआ सभा के बीच जा पहुंचा, क्योंकि यह दिख रहा था कि लोगों के बीच में महामारी शुरू हो चुकी थी. फिर अहरोन ने धूप जलाकर लोगों के लिए प्रायश्चित किया. ");
INSERT INTO hincv_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","वह मरे हुओं और जीवितों के बीच में खड़ा हो गया, जिससे महामारी शांत हो गई. ");
INSERT INTO hincv_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","किंतु फिर भी, जिनकी मृत्यु इस महामारी से हुई थी उनकी संख्या 14,700 हो चुकी थी. यह उनके अलावा थी, जो कोराह के कारण हो चुकी थी. ");
INSERT INTO hincv_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","फिर अहरोन मोशेह के पास लौट गया, जो इस समय मिलनवाले तंबू के द्वार पर खड़े हुए थे, क्योंकि अब महामारी शांत हो चुकी थी. ");
INSERT INTO hincv_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","फिर याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“इस्राएल के घराने को आज्ञा दो कि हर एक पूर्वजों के घराने से वे एक-एक लाठी लेकर आएं; उनके पिता के सारे घर-परिवारों से एक-एक प्रधान. हर एक लाठी पर तुम उस नायक का नाम लिख देना. ");
INSERT INTO hincv_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","लेवी वंश की ओर से जो लाठी आएगी उस पर अहरोन का नाम लिख देना; क्योंकि हर एक गोत्र के प्रधान के नाम से एक-एक लाठी ठहराई गई है. ");
INSERT INTO hincv_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","फिर तुम ये लाठियां मिलनवाले तंबू के साक्षी पत्र के संदूक के सामने खड़ी कर देना, जहां मैं तुमसे भेंट करूंगा. ");
INSERT INTO hincv_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","तब होगा यह कि उस व्यक्ति की लाठी, जो मेरा चुना हुआ होगा, अंकुरित होने लगेगी. इस कार्य के द्वारा मैं इस्राएलियों द्वारा मुझ पर की जा रही बड़बड़ाहट को कम कर सकूंगा, क्योंकि इस्राएली इस समय बड़बड़ा रहे हैं.” ");
INSERT INTO hincv_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","फिर मोशेह ने इस्राएल के घराने से तथा उसके सारे प्रधानों से यह कहकर उनमें से हर एक से एक-एक लाठी इकट्ठी कर ली. ये हर एक प्रधान की उसके गोत्र के अनुसार इकट्ठी की गई बारह लाठियां थी, अहरोन की लाठी भी इनमें से एक थी. ");
INSERT INTO hincv_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","मोशेह ने ये लाठियां साक्षी के तंबू में याहवेह के सामने खड़ी कर दीं. ");
INSERT INTO hincv_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","अगले दिन मोशेह साक्षी के तंबू में गए. वहां उन्होंने ध्यान दिया कि लेवी के गोत्र में से अहरोन की लाठी अंकुरित हो चुकी थी तथा उसमें कलियां आ गईं तथा फूल खिल रहे थे, और उसमें पके बादाम भी आ गए थे. ");
INSERT INTO hincv_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","मोशेह याहवेह की उपस्थिति में से वे सारी लाठियां उठाकर इस्राएल के घराने के सामने ले आए. उन सभी ने यह देखा और हर एक ने अपनी-अपनी लाठी उठाकर रख ली. ");
INSERT INTO hincv_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","किंतु याहवेह ने मोशेह को आज्ञा दी, “अहरोन की लाठी को साक्षी के संदूक के सामने रख दो कि यह उन विद्रोहियों के लिए एक चिन्ह होकर रह जाए, कि तुम उनके द्वारा मेरे विरोध में की जा रही बड़बड़ाहट ही समाप्‍त कर दो और वे अकाल मृत्यु के कौर न हो जाएं.” ");
INSERT INTO hincv_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","मोशेह ने याहवेह की आज्ञा के एक-एक वचन का पालन किया. ");
INSERT INTO hincv_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","इसके बाद इस्राएल के घराने ने मोशेह से कहा, “सुनिए, हम तो नाश हुए जा रहे हैं, हमारी मृत्यु हो रही है, हम सभी की मृत्यु! ");
INSERT INTO hincv_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","हर एक व्यक्ति, जो साक्षी तंबू के निकट आएगा, उसके लिए मृत्यु दंड अवश्य आनी है. क्या हमारा विनाश निश्चित ही है?” ");
INSERT INTO hincv_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","लेवियों के लिए ठहराई गई ज़िम्मेदारी: इसके बाद याहवेह ने अहरोन से कहा, “तुम, तुम्हारे पुत्र एवं तुम्हारा घराना पवित्र स्थान से संबंधित अधर्म का भार उठाएंगे, वैसे ही तुम, तुम्हारे पुत्र तुम्हारे साथ पुरोहित ज़िम्मेदारियों से संबंधित अधर्म के लिए भार उठाएंगे. ");
INSERT INTO hincv_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","किंतु लेवी के गोत्र, अर्थात् तुम, अपने पिता के गोत्र में से अपने भाइयों को भी अपने साथ ले आना कि जब तुम एवं तुम्हारे पुत्र तुम्हारे साथ साक्षी के तंबू के सामने ठहरे हुए हों, तब वे तुम्हारे साथ ही सेवा में शामिल हो जाएं. ");
INSERT INTO hincv_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","इस प्रकार वे तुम्हारे प्रति एवं साक्षी तंबू के प्रति अपनी ज़िम्मेदारी को उठाएंगे, किंतु वे पवित्र स्थान की वस्तुओं और वेदी के पास नहीं आएंगे, नहीं तो उनकी एवं तुम्हारी मृत्यु तय है. ");
INSERT INTO hincv_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","वे तुम्हारे साथ मिलकर मिलनवाले तंबू से संबंधित सभी कार्यों को भी निभायेंगे; किंतु किसी भी अन्य व्यक्ति को तुम्हारे निकट आने की अनुमति नहीं है. ");
INSERT INTO hincv_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“पवित्र स्थान एवं वेदी से संबंधित कार्यों को निभाना तुम्हारी ज़िम्मेदारी है कि इस्राएल के घराने पर दोबारा क्रोध न आने पाए. ");
INSERT INTO hincv_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","यह ध्यान रहे, स्वयं मैंने सारे इस्राएल में से तुम्हारे साथी लेवियों को अपने लिए अलग कर लिया है. वे तुम्हारे लिए भेंट हैं. वे याहवेह को समर्पित हैं, कि वे मिलनवाले तंबू से संबंधित सेवाएं समर्पित करते रहें. ");
INSERT INTO hincv_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","किंतु तुम तथा तुम्हारे साथ तुम्हारे पुत्र तुम्हारे पुरोहित पद में, वेदी से संबंधित कार्य में, तुम्हारे सहायक रहेंगे, जबकि तुम इन सेवकों से सम्बद्ध रहोगे, यह पुरोहित पद तुम्हारे लिए मेरे द्वारा दी गई ज़िम्मेदारी है, किंतु यदि कोई भी दूसरा व्यक्ति वेदी अथवा पर्दे के निकट जा पहुंचता है, उसके लिए मृत्युदण्ड ठहराया गया है.” ");
INSERT INTO hincv_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","इसके बाद याहवेह ने अहरोन पर यह स्पष्ट किया, “अब तुम यह भी समझ लो: स्वयं मैंने तुम्हें उन सारी भेंटों का ज़िम्मेदार नियुक्त किया है, जो इस्राएल के घराने के द्वारा मुझे भेंट की जाती है. ये सभी मैंने तुम्हें तथा तुम्हारे पुत्रों को हमेशा का अंश बनाकर दे दिया है. ");
INSERT INTO hincv_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","यह तुम्हारे लिए निर्धारित अंश होगा, जो अति पवित्र भेंटों में से आग से बचा रखी जाती है. यह इस्राएल के घराने के द्वारा प्रस्तुत हर एक भेंट में से तुम्हारा अंश होगा, हर एक अन्‍नबलि में से, हर एक पापबलि में से, हर एक दोष बलि में से, जो वे मुझे अर्पण करेंगे, तुम्हारे लिए, तुम्हारे पुत्रों के लिए अति पवित्र भेंटें होंगी. ");
INSERT INTO hincv_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","तुम इनको अति पवित्र भेंटों के रूप में खाया करोगे. यह हर एक पुरुष के लिए पवित्र अंश होगा. ");
INSERT INTO hincv_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“इनके अलावा यह भी तुम्हारा ही अंश होगा: उनके द्वारा अर्पण भेंटें तथा इस्राएल के घराने द्वारा लहर की भेंटें. यह मैंने तुम्हारे लिए तुम्हारे पुत्रों, पुत्रियों के लिए तुम्हारे साथ हमेशा का अंश ठहरा दिया है. तुम्हारे घर-परिवार का हर एक सदस्य जो सांस्कारिक रीति से पवित्र है इसको खा सकता है. ");
INSERT INTO hincv_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“सारे नए तेल में से सबसे अच्छा, नए दाखरस में से सबसे अच्छा, नई उपज में से, पहले फलों में से, जो उनके द्वारा याहवेह को अर्पण किए जाते हैं, मैं तुम्हें दे रहा हूं. ");
INSERT INTO hincv_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","इनके देश में जो सबसे पहला पका फल होगा, जिसे वे याहवेह को अर्पण करने के लिए लाते हैं, तुम्हारा होगा. तुम्हारे घर-परिवार का हर एक सदस्य जो सांस्कारिक रीति से पवित्र है, इसको खा सकता है. ");
INSERT INTO hincv_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“इस्राएल देश में बलि के लिए ठहराई गई हर एक वस्तु तुम्हारी होगी. ");
INSERT INTO hincv_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","हर एक जीवधारी का पहलौठा, चाहे वह मनुष्य का हो या पशु का, जिसे वे याहवेह को अर्पण करने लाते हैं, तुम्हारा होगा; फिर भी मनुष्य का पहलौठा तुम दाम लेकर छोड़ दोगे, वैसे ही अपवित्र घोषित पशुओं के पहलौठे को भी तुम दाम लेकर छोड़ देना. ");
INSERT INTO hincv_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","एक महीने के ऊपर की आयु के पशु के लिए तुम अपने आंकलन के आधार पर छुड़ाने का मूल्य तय करोगे; जो पवित्र स्थान की तौल के अनुसार चांदी के पांच शेकेल होंगे, जो बीस गेराह के बराबर होता है. ");
INSERT INTO hincv_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“किंतु बैल, भेड़ अथवा बकरी के पहलौठे को दाम लेकर मत छोड़ना, ये सब पवित्र पशु हैं. तुम इनका रक्त वेदी पर छिड़कोगे तथा उनकी चर्बी अग्निबलि में जला दोगे, जो याहवेह के सामने सुखद-सुगंध हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","इन पशुओं का मांस तुम्हारे खाने के लिए होगा, जिस प्रकार लहराए जानेवाली बलि की छाती तथा दायीं जांघ. ");
INSERT INTO hincv_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","वे सभी पवित्र भेंटें, जो इस्राएली याहवेह को चढ़ाते हैं, मैंने तुम्हारे लिए एवं तुम्हारे पुत्र-पुत्रियों के लिए हमेशा का अंश ठहरा दिया है. यह तुम्हारे तथा तुम्हारे साथ तुम्हारे वंशजों की याहवेह के सामने हमेशा की नमक की वाचा होगी.” ");
INSERT INTO hincv_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","इसके बाद याहवेह ने अहरोन से उसके सामने कहा, “जो देश इस्राएल के घराने को दिया जा रहा है, उसमें तुम्हारी कोई भी मीरास नहीं रहेगी, और उसमें न ही तुम्हारा कोई भाग होगा. तुम्हारा भाग मैं हूं, इस्राएल के घराने के बीच में मैं ही तुम्हारी मीरास हूं. ");
INSERT INTO hincv_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“याद रहे, लेवी के वंशजों को मैंने उनके द्वारा मिलनवाले तंबू में की जा रही सेवा के प्रतिफल के रूप में, पूरा दसवां अंश मीरास समान दे दिया है. ");
INSERT INTO hincv_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","इस्राएली इसके बाद मिलनवाले तंबू के पास नहीं आएंगे; नहीं तो इसके दोषी होने के कारण वे इसका दंड जो मृत्यु है, भोगेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","मिलनवाले तंबू से संबंधित सेवाएं सिर्फ लेवियों का कार्य है. अपने अधर्म का दंड वे ही भोगेंगे. यह तुम्हारी सारी पीढ़ियों के लिए ठहराया गया हमेशा का नियम है. इस्राएल के घराने के बीच उनके लिए कोई भी हिस्सा नहीं बांटा है. ");
INSERT INTO hincv_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","क्योंकि इस्राएलियों का दसवां अंश, जो वे भेंट के रूप में याहवेह को चढ़ाते हैं, मैंने लेवियों को दे दिया है; इसलिये मैंने उनके विषय में यह कहा है ‘इस्राएल के घराने के बीच में उनके लिए कोई भी हिस्सा नहीं रखा गया हैं.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","इसके बाद याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“इसके अलावा तुम लेवियों को यह सूचित करोगे: ‘जब तुम इस्राएल के घराने से वह दसवां अंश ग्रहण करते हो, जो मैंने उनसे लेकर तुम्हें तुम्हारे हिस्से के रूप में दिया है, तब तुम उसमें से एक अंश याहवेह को भेंट करोगे; दसवें अंश में से दसवां अंश. ");
INSERT INTO hincv_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","तुम्हारी यह भेंट खलिहान पर से इकट्ठी की गई अन्‍न, या दाखरस कुंड की पूरी उत्पाद मानी जाएगी. ");
INSERT INTO hincv_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","इस प्रकार तुम भी याहवेह को अपने दसवें अंश में से एक अंश भेंट के रूप में चढ़ाओगे, जो तुमने इस्राएल के घराने से प्राप्‍त किया था. तुम इस अंश में से पुरोहित अहरोन को याहवेह के लिए चढ़ाई भेंट दिया करोगे. ");
INSERT INTO hincv_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","अपनी सभी भेंटों में से याहवेह के लिए ठहराई गई हर एक भेंट चढ़ाओगे; उन सब में से, जो सबसे उत्तम है, जो उनमें एक पवित्र अंश है.’ ");
INSERT INTO hincv_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“तुम उन्हें सूचित करोगे, ‘जब तुमने इसमें से सबसे उत्तम भेंट दिया है, तब जो शेष रह जाएगा, वह लेवियों के लिए खलिहान का उत्पाद तथा दाखरस कुंड का उत्पाद माना जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","तुम इसको कहीं भी खा सकते हो, तुम तथा तुम्हारे घर-परिवार; क्योंकि यह मिलनवाले तंबू के लिए तुम्हारे द्वारा की जा रही सेवा के बदले में होगा. ");
INSERT INTO hincv_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","जब तक तुम इसमें से सर्वोत्तम भेंट करते रहोगे, तुम दोषी नहीं पाए जाओगे; किंतु तुम किसी भी रीति से उन पवित्र भेंटों को अपवित्र नहीं करोगे; जो इस्राएल के घराने के द्वारा चढ़ाई गई हैं, नहीं तो तुम्हारी मृत्यु निश्चित है.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","इसके बाद याहवेह ने मोशेह तथा अहरोन को आज्ञा दी: ");
INSERT INTO hincv_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“इस व्यवस्था की विधि जो याहवेह ने दी, वह इस प्रकार है: इस्राएल के घराने को आज्ञा दो कि वे एक ऐसी बछिया लेकर आएं, जो लाल रंग की हो, जिसमें किसी प्रकार का दोष न हो तथा जिस पर जूआ कभी भी न रखा गया हो. ");
INSERT INTO hincv_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","तुम ऐसी बछिया पुरोहित एलिएज़र को सौंपोगे. फिर यह बछिया छावनी के बाहर ले जाई जाएगी, तथा एलिएज़र की उपस्थिति में उसका वध किया जाए. ");
INSERT INTO hincv_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","इसके बाद पुरोहित एलिएज़र उसके रक्त की कुछ मात्रा अपनी उंगली में लेकर कुछ रक्त मिलनवाले तंबू के सामने की ओर सात बार छिड़केगा. ");
INSERT INTO hincv_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","इसके बाद उसके देखते-देखते वह बछिया जला दी जाएगी. ");
INSERT INTO hincv_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","इस अवसर पर पुरोहित देवदार की लकड़ी, जूफ़ा झाड़ी तथा लाल रंग की डोरी उस भस्म हो रही बछिया में डाल देगा. ");
INSERT INTO hincv_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","फिर पुरोहित अपने वस्त्र धोकर स्‍नान करेगा और शिविर में लौट आएगा, किंतु शाम तक वह सांस्कारिक रूप से अपवित्र रहेगा. ");
INSERT INTO hincv_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","वह व्यक्ति, जो बछिया को जलाता है, वह अपने वस्त्रों को धोएगा तथा स्‍नान करेगा तथा शाम तक सांस्कारिक रूप से अपवित्र रहेगा. ");
INSERT INTO hincv_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“इसके बाद एक ऐसा व्यक्ति, जो सांस्कारिक रूप से शुद्ध है, उस बछिया की राख इकट्ठा कर शिविर के बाहर स्वच्छ स्थान पर रख देगा. इस्राएलियों की सभा इसका इस्तेमाल अपवित्रता दूर करने के लिए उसी प्रकार करेंगे, जिस प्रकार जल अशुद्धता दूर करने के लिए इस्तेमाल करते हैं; यह पाप शुद्धि के लिए प्रयोग होगा. ");
INSERT INTO hincv_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","वह व्यक्ति, जो बछिया की राख इकट्ठा करता है, अपने वस्त्रों को धोएगा तथा वह शाम तक सांस्कारिक रूप से अपवित्र रहेगा. यह इस्राएलियों के लिए तथा उनके बीच रह रहे विदेशियों के लिए हमेशा की विधि रहेगी. ");
INSERT INTO hincv_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“यदि कोई व्यक्ति किसी के शव से छू जाए तो वह सांस्कारिक रूप से सात दिन तक अपवित्र रहेगा. ");
INSERT INTO hincv_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","वह अपनी इस अपवित्रता को तीसरे दिन तथा सातवें दिन जल से दूर करेगा और उसकी अपवित्रता दूर हो जाएगी; किंतु यदि वह तीसरे एवं सातवें दिन स्वयं को शुद्ध न कर सके, वह अपवित्र ही रह जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","कोई भी जब किसी मरे हुए व्यक्ति की देह को छू लेता है और शुद्ध होने की प्रक्रिया पूर्ण नहीं करता, वह याहवेह के मिलनवाले तंबू को अपवित्र करता है; ऐसे व्यक्ति को इस्राएल से निकाल दिया जाए. इसलिये कि उस पर अपवित्रता से छुड़ानेवाले जल का छिड़काव नहीं किया गया था, वह अपवित्र ही रहेगा, उस पर उसकी अपवित्रता बनी हुई है. ");
INSERT INTO hincv_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“शिविर में हुई किसी व्यक्ति की मृत्यु से संबंधित विधि यह है: हर एक व्यक्ति, जो उस शिविर में प्रवेश करता है, तथा हर एक, जो उस शिविर का निवासी है, सात दिन तक अशुद्ध रहेगा. ");
INSERT INTO hincv_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","हर एक बर्तन, जिस पर न तो ढक्कन रखा हुआ हो और न जिसका मुख बांधकर बंद किया गया हो, अपवित्र माना जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“इसके अलावा यदि कोई व्यक्ति खुले मैदान अथवा खेत में किसी ऐसे व्यक्ति को छू लेता है, जो तलवार द्वारा मारा गया है या जिसकी मृत्यु स्वाभाविक रीति से हो चुकी है, अथवा उस व्यक्ति का स्पर्श किसी मनुष्य की हड्डी या किसी कब्र से हो जाता है, वह व्यक्ति सात दिन तक सांस्कारिक रूप से अपवित्र समझा जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“उस अशुद्ध व्यक्ति के लिए वे जलाई गई पापबलि की राख लेकर एक बर्तन में बहते हुए जल के साथ मिलाएंगे. ");
INSERT INTO hincv_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","फिर सांस्कारिक रूप से शुद्ध व्यक्ति एक जूफ़ा लेकर इस मिश्रण में डुबोएगा और उसके शिविर पर, सारी सामग्री पर तथा उन सभी व्यक्तियों पर, जो वहां उपस्थित थे, तथा उस व्यक्ति पर छिड़काव कर देगा, जिसका स्पर्श उस हड्डी से या उस मारे हुए व्यक्ति से या स्वाभाविक रूप से मरे हुए व्यक्ति से या कब्र से हो गया था. ");
INSERT INTO hincv_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","तब वह शुद्ध व्यक्ति अशुद्ध व्यक्ति पर तीसरे दिन भी छिड़काव करेगा तथा सातवें दिन भी. सातवें दिन वह उस अशुद्धता से पवित्र करने की प्रक्रिया पूरी कर चुकेगा. वह अपने वस्त्रों को धोएगा तथा स्‍नान करेगा तथा वह शाम तक पूरी तरह से शुद्ध हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","किंतु वह व्यक्ति, जो सांस्कारिक रूप से अशुद्ध है और वह स्वयं को अपनी अशुद्धि से पवित्र नहीं करता, वह व्यक्ति इस्राएली समाज से निकाल दिया जाएगा, क्योंकि उसने याहवेह के पवित्र स्थान को दूषित किया है. उस पर अशुद्धता से छुड़ानेवाले जल का छिड़काव नहीं किया गया है, वह अपवित्र है. ");
INSERT INTO hincv_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","तब यह उनके लिए एक सदा की विधि होगी. “वह जो इस जल का छिड़काव करता है, अपने वस्त्र धोएगा, जो कोई उस जल को छूता है, शाम तक सांस्कारिक रूप से अपवित्र रहेगा. ");
INSERT INTO hincv_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","इसके अलावा हर एक वस्तु, जो उस अशुद्ध व्यक्ति द्वारा छुई गई हो, वह अपवित्र होगी, तथा वह व्यक्ति जो उसे छूता है शाम तक अपवित्र रहेगा.” ");
INSERT INTO hincv_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","पहले महीने में सारे इस्राएल के घराने के लोग ज़िन के निर्जन प्रदेश में पहुंच गए. उन्होंने कादेश में पड़ाव डाला. यहां मिरियम की मृत्यु हो गई और उसे वहीं मिट्टी दी गई. ");
INSERT INTO hincv_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","इस्राएल के घराने के पीने के लिए वहां जल उपलब्ध ही न था. वे लोग मोशेह तथा अहरोन के विरोध में एकजुट हो गए. ");
INSERT INTO hincv_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","लोगों ने मोशेह से यह कहते हुए झगड़ा करना शुरू कर दिया, “सही होता कि हम भी उसी अवसर पर नाश हो गए होते, जब हमारे भाई याहवेह के सामने नाश हुए जा रहे थे! ");
INSERT INTO hincv_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","क्यों आप याहवेह की प्रजा को इस निर्जन प्रदेश में ले आए हैं, कि हम और हमारे पशु सभी मृत्यु के कौर हो जाएं? ");
INSERT INTO hincv_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","क्यों आपने हमें मिस्र देश से निकलने के लिए मजबूर किया; क्या इस बेमतलब के स्थान में लाकर छोड़ने के लिए? यह तो अन्‍न या, अंजीरों या दाख-लताओं या अनारों का देश है ही नहीं, और न ही यहां हमारे लिए पीने का पानी उपलब्ध है!” ");
INSERT INTO hincv_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","यह सुन मोशेह तथा अहरोन इस्राएली सभा के सामने से निकलकर मिलनवाले तंबू के प्रवेश के सामने आकर मुंह के बल गिर पड़े. यहां उन्हें याहवेह की महिमा के दर्शन हुआ. ");
INSERT INTO hincv_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“अपनी लाठी अपने साथ लेकर तुम और तुम्हारा भाई अहरोन, सारी सभा को इकट्ठा कर उनकी दृष्टि में उस चट्टान से बात करो कि वह अपना जल निकाल दे. ऐसा करके तुम उस चट्टान में से उनके लिए जल निकालोगे कि सारी सभा तथा उनके पशु जल पी सकें.” ");
INSERT INTO hincv_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","फिर मोशेह ने याहवेह के सामने से वह लाठी उठा ली, ठीक जैसा आदेश उन्हें याहवेह की ओर से मिला था. ");
INSERT INTO hincv_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","मोशेह एवं अहरोन ने सारी सभा को उस चट्टान के सामने इकट्ठा किया और उनसे कहा, “विद्रोहियो, अब मेरी सुनो. क्या अब हमें तुम्हारे लिए इस चट्टान से जल निकालना होगा?” ");
INSERT INTO hincv_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","यह कहते हुए मोशेह ने अपनी बांह ऊंची उठाकर अपनी लाठी से उस चट्टान पर दो बार वार किया और बहुत मात्रा में जल निकलने लगा. सारी सभा एवं पशुओं ने अपनी प्यास बुझा ली. ");
INSERT INTO hincv_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","किंतु याहवेह ने मोशेह एवं अहरोन से कहा, “तुमने मुझमें विश्वास न करके इस्राएल के घराने के सामने मेरी पवित्रता की पुष्टि नहीं की, इसलिये तुम इस सभा को मेरे द्वारा दिए हुए देश में नहीं ले जाओगे.” ");
INSERT INTO hincv_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","यह मेरिबाह का सोता था जहां इस्राएल के घराने ने याहवेह से झगड़ा किया था और यहां याहवेह ने स्वयं को उनके बीच पवित्र सिद्ध कर दिया. ");
INSERT INTO hincv_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","मोशेह ने कादेश से एदोम के राजा को संदेशवाहकों के द्वारा यह संदेश भेजा: “आपके भाई इस्राएल की विनती यह है: आप तो हम पर आई कठिनाइयों को जानते हैं. ");
INSERT INTO hincv_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","हमारे पूर्वजों ने मिस्र देश में प्रवास किया और हम वहां बहुत समय तक रहते रहे. मिस्रियों ने हमारे साथ तथा हमारे पूर्वजों के साथ क्रूरतापूर्वक व्यवहार किया, ");
INSERT INTO hincv_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","हमने इस पर याहवेह की गुहार लगाई और उन्होंने हमारी सुन ली, तथा अपना एक स्वर्गदूत भेजकर हमें मिस्र देश से निकाल लिया. “अब हम कादेश तक आ पहुंचे हैं, जो आपके देश की सीमा से लगा हुआ है. ");
INSERT INTO hincv_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","कृपया हमें अपने देश में से होकर निकल जाने की अनुमति दे दीजिए. हम न तो आपके किसी खेत में से होकर जाएंगे और न किसी दाख की बारी में से; यहां तक कि हम तो किसी कुएं के जल का भी उपयोग नहीं करेंगे. हम सिर्फ राजमार्ग का ही प्रयोग करेंगे, जब तक हम आपकी सीमा से पार न हो जाएं, हम न दायीं ओर जाएंगे, न बायीं ओर.” ");
INSERT INTO hincv_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","किंतु इस विषय में एदोम का जवाब था: “आप लोग हमारे देश में से होकर नहीं जाएंगे, नहीं तो हम आपको तलवार से रोकेंगे.” ");
INSERT INTO hincv_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","इस्राएलियों ने उससे दोबारा विनती की: “हम सिर्फ राजमार्ग से ही यात्रा करेंगे और यदि हमारे पशु आपका ज़रा सा भी जल पिएंगे, तब हम इसका मूल्य भुगतान कर देंगे. हमें सिर्फ यहां से पैदल ही पैदल जाने की अनुमति दे दीजिए, इसके अलावा कुछ भी नहीं.” ");
INSERT INTO hincv_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","किंतु उसका उत्तर यही था: “तुम यहां से होकर नहीं जाओगे.” तब एदोम उनके विरुद्ध एक मजबूत सेना तथा पक्‍के इरादे के साथ खड़ा हो गया. ");
INSERT INTO hincv_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","एदोम ने इस्राएल को अपने देश में से होकर जाने की अनुमति नहीं दी; इसलिये इस्राएल ने उस देश से होकर जाने का विचार छोड़ दिया. ");
INSERT INTO hincv_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","इस्राएल के घराने ने कादेश से कूच किया, और पूरी इस्राएली सभा होर पर्वत तक पहुंच गई. ");
INSERT INTO hincv_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","एदोम की सीमा पर होर पर्वत पर याहवेह ने मोशेह तथा अहरोन को सूचित किया, ");
INSERT INTO hincv_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“अहरोन को उसके पूर्वजों में मिल जाना है; क्योंकि वह उस देश में प्रवेश नहीं करेगा, जो मैंने इस्राएल के घराने को दिया है, क्योंकि तुम दोनों ने मेरिबाह के जल पर मेरे आदेश का विद्रोह किया था. ");
INSERT INTO hincv_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","अहरोन तथा उसके पुत्र एलिएज़र को होर पर्वत पर ले जाओ. ");
INSERT INTO hincv_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","वहां अहरोन के पुरोहित वस्त्र उतारकर उसके पुत्र एलिएज़र को पहना देना. फिर अहरोन अपने लोगों में मिल जाएगा; वहां उसका देहांत हो जाएगा.” ");
INSERT INTO hincv_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","तब मोशेह ने ठीक वही किया, जैसा याहवेह ने आदेश दिया था: वे सारी सभा की दृष्टि में होर पर्वत पर चढ़ गए. ");
INSERT INTO hincv_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","जब मोशेह ने वे कपड़े अहरोन से उतारकर उसके पुत्र एलिएज़र को पहनाए, तब अहरोन ने वहां पर्वत शिखर पर अपने प्राणों को त्याग दिया. इसके बाद मोशेह एवं एलिएज़र पर्वत से नीचे उतर गए, ");
INSERT INTO hincv_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","जब सारी सभा को यह मालूम चला कि अहरोन की मृत्यु हो चुकी है, तब सारे इस्राएल के घराने ने तीस दिन अहरोन के लिए विलाप किया. ");
INSERT INTO hincv_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","जब नेगेव निवासी कनानी अराद के राजा ने यह सुना कि इस्राएली अथारीम मार्ग से बढ़े चले आ रहे हैं, तब उसने इस्राएल पर आक्रमण कर दिया, तथा कुछ को बंदी बना लिया. ");
INSERT INTO hincv_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","फिर इस्राएल ने याहवेह के सामने यह शपथ की: “यदि आप वास्तव में शत्रुओं को हमारे अधीन कर देंगे, तो हम इनके नगरों को पूरी तरह से नाश कर देंगे.” ");
INSERT INTO hincv_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","याहवेह ने उनकी दोहाई स्वीकार कर ली और कनानियों को उनके अधीन कर दिया. इस्राएलियों ने उनके नगरों को पूरी तरह से नाश कर दिया. परिणामस्वरूप वह स्थान होरमाह के नाम से मशहूर हो गया. ");
INSERT INTO hincv_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","इसके बाद उन्होंने होर पर्वत से कूच किया और लाल सागर का मार्ग लिया कि उन्हें एदोम से होते हुए जाना न पड़े. इस यात्रा ने प्रजा का धीरज खत्म कर दिया. ");
INSERT INTO hincv_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","प्रजा ने परमेश्वर एवं मोशेह के विरुद्ध बड़बड़ाना शुरू कर दिया, “आपने हमें मिस्र देश से क्यों निकाला है, कि हम इस निर्जन प्रदेश में अपने प्राण गवां दें? यहां तो न भोजन है न जल! और जो नीरस भोजन हमें दिया जा रहा है, वह हमारे लिए घृणित हो चुका है.” ");
INSERT INTO hincv_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","याहवेह ने उन लोगों के बीच में विषैले सांप भेज दिए, जिनके द्वारा डसे जाने पर अनेक इस्राएलियों की मृत्यु हो गई. ");
INSERT INTO hincv_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","तब वे लोग मोशेह के पास आकर कहने लगे, “हमने पाप किया है, क्योंकि हमने याहवेह तथा आपके विरुद्ध बड़बड़ाया है. आप उनसे हमारे लिए विनती कीजिए कि वह इन सांपों को हमसे दूर कर दें.” मोशेह ने लोगों के लिए विनती की. ");
INSERT INTO hincv_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","तब याहवेह ने मोशेह को आज्ञा दी, “विषैले सांप की प्रतिमा बनाकर एक खंभे पर खड़ी कर दो तब होगा यह, कि जो कोई सांप का डसा हुआ व्यक्ति आकर इस प्रतिमा को देखेगा, वह जीवन प्राप्‍त करेगा.” ");
INSERT INTO hincv_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","मोशेह ने सांप की प्रतिमा गढ़ कर एक खंभे पर खड़ी कर दी. तब यह होने लगा कि यदि कोई सांप का डसा हुआ व्यक्ति आकर उस कांसे के सांप की ओर देख लेता था, तो मृत्यु से बच जाता था. ");
INSERT INTO hincv_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","फिर इस्राएलियों ने यात्रा शुरू की और ओबोथ नामक स्थान पर शिविर डाल दिया. ");
INSERT INTO hincv_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ओबोथ से कूच कर उन्होंने इये-आबारिम के निर्जन प्रदेश में डेरा डाला, जो पूर्व दिशा की ओर मोआब के सामने है. ");
INSERT INTO hincv_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","वहां से कूच कर उन्होंने ज़ेरेद की वादी में डेरा डाल दिया. ");
INSERT INTO hincv_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","वहां से यात्रा करते हुए उन्होंने आरनोन के दूसरी ओर डेरा डाला. यह वह स्थान था, जो अमोरियों की सीमा पर निर्जन प्रदेश में है. आरनोन मोआब की सीमा तय करता है, मोआबियों एवं अमोरियों के बीच की. ");
INSERT INTO hincv_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","इस बात का वर्णन याहवेह के युद्ध, नामक ग्रंथ में इस रीति से किया गया है: “सूफाह वाहेब तथा आरनोन की वादियां, ");
INSERT INTO hincv_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","तथा वादियों की वे ढलान, जो आर के क्षेत्र तक फैली होती है, तथा जो मोआब की सीमा तक पहुंची हुई है.” ");
INSERT INTO hincv_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","वहां से वे बीर तक पहुंचे, उस कुएं तक, जहां याहवेह ने मोशेह को आज्ञा दी थी, “इकट्ठा करो लोगों को, कि मैं उनके लिए जल दे सकूं.” ");
INSERT INTO hincv_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","फिर इस्राएलियों ने यह गीत गाया: “कुएं भरने लगो, सभी! यह गाएं. ");
INSERT INTO hincv_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","वह कुंआ, जिसको प्रधानों ने खोदा था, जिसे कुलीन व्यक्तियों ने खोदा है, जिसके लिए राजदंड तथा उनकी लाठियों का प्रयोग किया गया था.” फिर उन्होंने निर्जन प्रदेश से मत्तानाह की ओर कूच किया और ");
INSERT INTO hincv_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","मत्तानाह से नाहालिएल की ओर और फिर वहां से बामोथ की ओर, ");
INSERT INTO hincv_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","बामोथ से उस घाटी की ओर, जो मोआब देश में है तथा पिसगाह पर्वत शिखर, जो निर्जन प्रदेश के सामने है. ");
INSERT INTO hincv_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","यहां पहुंचकर इस्राएल ने अमोरियों के राजा सीहोन के लिए अपने संदेशवाहक को इस संदेश के साथ भेजे: ");
INSERT INTO hincv_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“हमें अपने देश में से होकर जाने की अनुमति दे दीजिए. हम न तो मार्ग के खेतों में प्रवेश करेंगे और न अंगूर के बगीचों में. हम कुंओं का जल भी न पियेंगे. हम आपके देश को पार करते हुए सिर्फ राजमार्ग का ही प्रयोग करेंगे.” ");
INSERT INTO hincv_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","किंतु राजा सीहोन ने इस्राएल को अपनी सीमा में से होकर जाने की अनुमति ही न दी, बल्कि उसने अपनी सारी प्रजा को इकट्ठा कर निर्जन प्रदेश में इस्राएल पर आक्रमण कर दिया. याहज़ नामक स्थान पर दोनों में युद्ध छिड़ गया. ");
INSERT INTO hincv_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","इस्राएल ने उन पर तलवार के प्रहार से अम्मोन देश की सीमा तक, आरनोन से यब्बोक तक के क्षेत्र पर अधिकार कर लिया, क्योंकि जाज़ेर अम्मोन के घराने की सीमा पर था. ");
INSERT INTO hincv_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","इस्राएल ने इन सभी नगरों पर अधिकार कर लिया तथा हेशबोन एवं इसके सभी गांवों में, जो अमोरियों के नगर थे, इस्राएली वहां रहने लगे. ");
INSERT INTO hincv_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","हेशबोन अमोरियों के राजा सीहोन का मुख्यालय था, जिसने मोआब के पहले के राजा से युद्ध कर उससे आरनोन तक उसका सारा देश छीन लिया था. ");
INSERT INTO hincv_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","तब यह कहावत मशहूर हो गई: “हेशबोन आ जाइए! हम इसको दोबारा बनाएंगे; कि सीहोन का नगर स्थापित कर दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“हेशबोन से एक आग की लपट निकली, सीहोन के नगर से एक आग की लौ. इसने मोआब के आर को भस्म कर लिया, उन्हें, जो आरनोन के प्रमुख शिखर थे. ");
INSERT INTO hincv_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","मोआब, धिक्कार है तुम पर! तुम तो खत्म हो चुके, खेमोश के निवासियो! उसने अमोरी राजा सीहोन को अपने पुत्रों को भगौड़े बनाकर तथा पुत्रियों को बंदी बनाकर उसे सौंप दिया है. ");
INSERT INTO hincv_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“किंतु हमने उन्हें धूल में मिला दिया है; दीबोन तक हेशबोन नाश होकर खंडहर बन चुके हैं, इसके बाद हमने नोपाह तक, जो मेदेबा की सीमा तक फैला हुआ क्षेत्र का है, उजाड़ दिया है.” ");
INSERT INTO hincv_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","इस प्रकार इस्राएल अमोरियों के देश में बस गया. ");
INSERT INTO hincv_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","मोशेह ने याज़र की जासूसी करने की आज्ञा दी. उन्होंने जाकर वहां के गांवों को अपने अधिकार में कर लिया, तथा वहां निवास कर रहे अमोरियों को वहां से खदेड़ दिया. ");
INSERT INTO hincv_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","तब वे मुड़कर बाशान के मार्ग से आगे बढ़ गए. बाशान का राजा ओग अपनी सारी सेना लेकर उनसे युद्ध करने एद्रेइ पहुंच गया. ");
INSERT INTO hincv_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","याहवेह की ओर से मोशेह को यह आश्वासन मिला, “तुम्हें उससे डरने की कोई आवश्यकता नहीं है, क्योंकि मैंने उसे, उसकी सारी सेना तथा प्रजा को, तुम्हारे अधीन कर दिया है. तुम उसके साथ वही सब करोगे, जो तुमने हेशबोन निवासी अमोरियों के राजा सीहोन के साथ किया था.” ");
INSERT INTO hincv_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","फिर उन्होंने बाशान के राजा ओग को, उसके पुत्रों तथा उसकी सारी प्रजा का नाश कर दिया, जिससे वहां कोई भी बचा न रह गया, और इस्राएलियों ने उस देश पर अधिकार कर लिया. ");
INSERT INTO hincv_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","इसके बाद इस्राएली यात्रा करते हुए मोआब के मैदानों में आ पहुंचे, जो यरदन पार येरीख़ो के सामने है, यहां उन्होंने डेरा डाल दिया. ");
INSERT INTO hincv_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ज़ीप्पोर के पुत्र बालाक की जानकारी में वह सब था, जो इस्राएल द्वारा अमोरियों के साथ किया गया था. ");
INSERT INTO hincv_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","तब मोआब देश इस्राएलियों की विशाल संख्या के कारण बहुत ही डर गया, इस्राएल मोआब के लिए आतंक का विषय हो गया. ");
INSERT INTO hincv_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","मोआब ने मिदियान के प्राचीनों के सामने अपने विचार इस प्रकार रखे, “अब तो यह विशाल जनसमूह हमारे आस-पास की वस्तुओं को इस प्रकार चट कर जाएगा, जिस प्रकार बैल मैदान के घास को चट कर जाता है.” इस अवसर पर ज़ीप्पोर का पुत्र बालाक जो मोआब देश का राजा था, ");
INSERT INTO hincv_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","उसने पेथोर नगर को, जो फरात नदी के निकट है, उस नगर का रहवासी, बेओर के पुत्र बिलआम के पास अपने दूतों के द्वारा यह आमंत्रण भेजा: “सुनिए, मिस्र देश से यह जनसमूह यहां आ गया है. ये लोग इतनी बड़ी संख्या में हैं कि वे भूमि पर छा गए हैं और इन्होंने हमारे देश के सामने ही पड़ाव डाल रखा है. ");
INSERT INTO hincv_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","तब कृपा कर यहां पधारिए, मेरी ओर से इन्हें शाप दीजिए, क्योंकि ये हमारी तुलना में बहुत ही शक्तिशाली हैं. तब मेरे लिए यह संभव हो जाएगा कि मैं उन्हें पराजित कर हमारे देश से बाहर खदेड़ सकूं. क्योंकि इतना मुझे मालूम है कि आप जिनको आशीर्वाद देते हैं, वे फलवंत हो जाते हैं, तथा जिन्हें आप शाप देते हैं, वे शापित ही रह जाते हैं.” ");
INSERT INTO hincv_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","फिर मोआब तथा मिदियान के प्राचीन अपने साथ भविष्य बताने का उपहार लेकर उपस्थित हुए. बिलआम के घर पर पहुंचकर उन्होंने उसके सामने बालाक का आग्रह दोहरा दिया. ");
INSERT INTO hincv_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","बिलआम ने उनके सामने प्रस्ताव रखा, “आप यहां रात्रि के लिए ठहर कर विश्राम कीजिए. जब याहवेह मुझसे बातें करेंगे, मैं आपको उनका संदेश दे दूंगा.” मोआब के वे प्रधान बिलआम के यहां ठहर गए. ");
INSERT INTO hincv_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","परमेश्वर बिलआम पर प्रकट हुए तथा उससे प्रश्न किया, “कौन हैं ये व्यक्ति, जो तुम्हारे साथ हैं?” ");
INSERT INTO hincv_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","बिलआम ने परमेश्वर को उत्तर दिया, “ज़ीप्पोर के पुत्र बालाक ने, जो मोआब का राजा है, मेरे लिए संदेश भेजा है: ");
INSERT INTO hincv_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘सुनिए, मिस्र से ये लोग निकलकर आए हुए हैं. ये लोग तो भूमि पर छा गए हैं. अब आकर मेरी ओर से इन्हें शाप दे दो. तब संभवतः मैं उनसे युद्ध कर उन्हें यहां से खदेड़ सकूंगा.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","परमेश्वर ने बिलआम को आज्ञा दी, “मत जाओ उनके साथ. तुम उन लोगों को शाप नहीं दोगे, क्योंकि वे लोग आशीषित लोग हैं.” ");
INSERT INTO hincv_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","फिर सुबह होते ही बिलआम ने बालाक के प्रधानों को उत्तर दिया, “आप लोग अपने देश लौट जाइए, क्योंकि याहवेह ने मुझे आप लोगों के साथ जाने के लिए मना कर दिया है.” ");
INSERT INTO hincv_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","मोआब के उन प्रधानों ने लौटकर बालाक को यह सूचना दे दी, “बिलआम ने हमारे साथ यहां आने से मना कर दिया है.” ");
INSERT INTO hincv_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","फिर बालाक ने दोबारा इन प्रधानों से अधिक संख्या में तथा अधिक सम्मानजनक प्रधानों को बिलआम के पास भेज दिया. ");
INSERT INTO hincv_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","बिलआम के सामने जाकर उन्होंने विनती की, “ज़ीप्पोर के पुत्र बालाक की विनती है, ‘आपको मेरे पास आने में कोई भी बाधा न हो, ");
INSERT INTO hincv_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","विश्वास कीजिए मैं आपको अपार धन से सम्मानित कर दूंगा, आप जो कुछ कहेंगे, मैं वही करने के लिए तैयार हूं. बस, आप कृपा कर यहां आ जाइए और मेरी ओर से इन लोगों को शाप दे दीजिए.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","बिलआम ने बालाक के लोगों को उत्तर दिया, “यदि बालाक मेरे घर को चांदी और सोने से भर भी दें, मेरे लिए कुछ भी करना संभव न होगा, चाहे यह विनती छोटी हो या बड़ी. मैं याहवेह, मेरे परमेश्वर के आदेश के विपरीत कुछ नहीं कर सकता. ");
INSERT INTO hincv_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","फिर अब, आप रात्रि में मेरे यहां विश्राम कीजिए. मैं मालूम करूंगा, कि याहवेह इस विषय में मुझसे और क्या कहना चाहेंगे.” ");
INSERT INTO hincv_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","रात में परमेश्वर ने बिलआम के सामने आकर उसे आज्ञा दी, “यदि वे तुम्हें अपने साथ ले जाने के उद्देश्य से आ ही गए हैं, तो जाओ उनके साथ; किंतु तुम सिर्फ वही कहोगे, जो मैं तुमसे कहूंगा, वही करना.” ");
INSERT INTO hincv_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","फिर सुबह बिलआम उठा, अपनी गधी की काठी कसी तथा मोआब के प्रधानों के साथ चल दिया. ");
INSERT INTO hincv_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","बिलआम के उनके साथ चले जाने पर परमेश्वर अप्रसन्‍न हो गए. याहवेह का दूत बिलआम के मार्ग में शत्रु के समान विरोधी बनकर खड़ा हो गया. बिलआम अपनी गधी पर बैठा हुआ था, तथा उसके साथ उसके दो सेवक भी थे. ");
INSERT INTO hincv_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","जैसे ही गधी की दृष्टि हाथ में तलवार लिए हुए, मार्ग में खड़े हुए याहवेह के दूत पर पड़ी, वह मार्ग छोड़ खेत में चली गई. बिलआम ने गधी को प्रहार किए, कि वह दोबारा मार्ग पर आ जाए. ");
INSERT INTO hincv_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","फिर याहवेह का दूत अंगूर के बगीचे के बीच की संकरी पगडंडी पर जा खड़ा हुआ, जिसके दोनों ओर दीवार थी. ");
INSERT INTO hincv_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","जब गधी की दृष्टि याहवेह के दूत पर पड़ी वह दीवार से सट गई, जिससे बिलआम का पैर दीवार से दब गया. बिलआम ने दोबारा उस गधी पर प्रहार किया. ");
INSERT INTO hincv_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","याहवेह का वह दूत आगे चला गया तथा एक ऐसे संकरे स्थान पर जा खड़ा हुआ जहां न तो दाएं मुड़ने का कोई स्थान था, न बाएं मुड़ने का. ");
INSERT INTO hincv_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","जब उस गधी ने याहवेह के दूत को देखा तो वह बिलआम के नीचे पसर गई. बिलआम क्रोधित हो गया तथा उसने अपनी लाठी से उस गधी पर वार किया. ");
INSERT INTO hincv_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","तब याहवेह ने उस गधी को बोलने की क्षमता प्रदान कर दी. वह बिलआम से कहने लगी, “मैंने ऐसा क्या किया है, जो आपने मुझ पर इस प्रकार तीन बार वार किया है?” ");
INSERT INTO hincv_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","बिलआम ने उसे उत्तर दिया, “इसलिये कि तुमने मुझे हंसी का पात्र बना रखा है! यदि मेरे हाथ में तलवार होती, मैं अब तक तुम्हारा वध कर चुका होता.” ");
INSERT INTO hincv_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","उस गधी ने उसे उत्तर दिया, “क्या मैं आपकी वही गधी नहीं रही हूं, जिस पर आप आजीवन यात्रा करते रहे हैं, जैसे कि आज भी? क्या मैंने भी आपके साथ कभी ऐसा व्यवहार किया है?” बिलआम ने उत्तर दिया, “नहीं तो?” ");
INSERT INTO hincv_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","फिर याहवेह ने बिलआम को वह दृष्टि प्रदान की, कि उसे याहवेह का वह दूत दिखाई देने लगा, जो मार्ग में तलवार लिए हुए खड़ा था. बिलआम उसके सामने गिर पड़ा. ");
INSERT INTO hincv_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","याहवेह के दूत ने बिलआम से पूछा, “तुमने तीन बार इस गधी पर वार क्यों किया है? यह समझ लो कि मैं तुम्हारा विरोध करने आ गया हूं, क्योंकि तुम्हारी चाल मुझसे ठीक विपरीत है. ");
INSERT INTO hincv_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","इस गधी ने मुझे देख लिया और इन तीनों बार मुझसे दूर चली गई; यदि उसने ऐसा न किया होता तो निश्चित ही इस समय मैं तुम्हारा नाश कर चुका होता, और उसे जीवित ही रहने देता.” ");
INSERT INTO hincv_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","बिलआम ने याहवेह के उस दूत के सामने यह स्वीकार किया, “मैंने पाप किया है. मैं इस बात से अनजान था, कि मार्ग में खड़े हुए आप मेरा सामना कर रहे थे. फिर अब, यदि यह आपके विरुद्ध हो रहा है, मैं लौट जाना चाहूंगा.” ");
INSERT INTO hincv_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","किंतु याहवेह के दूत ने बिलआम से कहा, “अब तो तुम इन लोगों के साथ चले जाओ, किंतु तुम वही कहोगे, जो मैं तुम्हें कहने के लिए प्रेरित करूंगा.” फिर बिलआम बालाक के उन प्रधानों के साथ चला गया. ");
INSERT INTO hincv_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","जब बालाक को यह मालूम हुआ, कि बिलआम आ रहा है, वह उससे भेंट करने मोआब के उस नगर के लिए निकल पड़ा, जो आरनोन की सीमा पर स्थित है; सीमा के दूर वाले छोर पर. ");
INSERT INTO hincv_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","भेंट होने पर बालाक ने बिलआम से कहा, “क्या मैंने आपको अत्यंत आवश्यक विनती के साथ आमंत्रित न किया था? आप फिर क्यों न आए? क्या मेरे लिए आपका उचित सम्मान करना असंभव था?” ");
INSERT INTO hincv_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","बिलआम ने बालाक को उत्तर दिया, “देखिए अब तो मैं आपके लिए प्रस्तुत हूं. क्या मुझमें ऐसी कोई क्षमता है, कि मैं कुछ भी कह सकूं? मैं तो वही कहूंगा, जो परमेश्वर मेरे मुख में डालेंगे.” ");
INSERT INTO hincv_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","यह कहते हुए बिलआम बालाक के साथ चला गया और वे किरयथ-हुज़ोथ नामक स्थल पर पहुंचे. ");
INSERT INTO hincv_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","वहां बालाक ने बछड़ों तथा भेड़ों की बलि भेंट की. इसका कुछ अंश उसने बिलआम तथा उसके साथ आए प्रधानों को दे दिया. ");
INSERT INTO hincv_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","सुबह होते ही बालाक बिलआम को बामोथ-बाल के पूजा-स्थल पर ले गया, जहां से इस्राएली प्रजा का एक अंश दिखाई दे रहा था. ");
INSERT INTO hincv_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","तब बिलआम ने बालाक से विनती की, “मेरे लिए यहां सात वेदियां बनवाइए, और वहां मेरे लिए सात बछड़े एवं सात मेढ़े तैयार रखिए.” ");
INSERT INTO hincv_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","बालाक ने यही किया. फिर बालाक एवं बिलआम ने मिलकर हर एक वेदी पर एक-एक बछड़ा एवं मेढ़ा भेंट किया. ");
INSERT INTO hincv_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","फिर बिलआम ने बालाक से विनती की, “आप अपनी होमबलि के निकट ठहरे रहिए, मैं याहवेह के सामने जाऊंगा, हो सकता है कि याहवेह मुझसे भेंट करने आएं. वह मुझ पर, जो कुछ स्पष्ट करेंगे, मैं आप पर प्रकट कर दूंगा.” यह कहकर बिलआम एक सुनसान पहाड़ी पर चला गया. ");
INSERT INTO hincv_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","यहां बिलआम ने परमेश्वर से बातें करनी शुरू की, “मैंने सात वेदियां बनवाई हैं, और मैंने हर एक पर एक-एक बछड़ा तथा मेढ़ा भेंट चढ़ाया है.” ");
INSERT INTO hincv_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","याहवेह ने बिलआम को वह वचन सौंप दिया और उसे आज्ञा दी, “बालाक के पास जाओ तथा उससे यही कह देना.” ");
INSERT INTO hincv_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","फिर बिलआम बालाक के पास लौट गया. बालाक अपनी होमबलि के पास खड़ा हुआ था, उसके साथ मोआब के सारे प्रधान भी थे. ");
INSERT INTO hincv_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","बिलआम ने अपना वचन शुरू किया, “अराम देश से बालाक मुझे यहां ले आया है, बालाक, जो पूर्वी पर्वतों में से मोआब का राजा है, उसका आदेश है, ‘मेरी ओर से याकोब को शाप दो; यहां आकर इस्राएल की बुराई करो.’ ");
INSERT INTO hincv_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","मैं उन्हें शाप कैसे दे दूं, जिन्हें परमेश्वर ने शापित नहीं किया? मैं उनकी बुराई कैसे करूं, जिनकी बुराई याहवेह ने नहीं की है? ");
INSERT INTO hincv_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","मैं यहां चट्टानों के शिखर से उन्हें देख रहा हूं, मैं यहां पहाड़ियों से उन्हें देख रहा हूं; ये वे लोग हैं, जो सबसे अलग हैं, ये अन्य देशों में मिलाए नहीं जा सकते. ");
INSERT INTO hincv_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","किसमें क्षमता है, याकोब के धूलि के कणों की गिनती करने की, या इस्राएल के एक चौथाई भाग की गिनती करने की भी? मेरी कामना यही है कि मैं धर्मी की मृत्यु को प्राप्‍त हो जाऊं. हां, ऐसा ही हो मेरा अंत!” ");
INSERT INTO hincv_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","यह सुन बालाक ने बिलआम से कहा, “आपने मेरे साथ यह क्या कर डाला है? मैंने तो आपको यहां इसलिये आमंत्रित किया था, कि आप मेरे शत्रुओं को शाप दें, किंतु आपने तो वस्तुतः उन्हें आशीर्वाद दे दिया है!” ");
INSERT INTO hincv_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","बिलआम ने उत्तर दिया, “क्या, ज़रूरी नहीं कि मैं वही कहूं, जो याहवेह ने मुझे बोलने के लिए सौंपा है?” ");
INSERT INTO hincv_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","फिर बालाक ने बिलआम से आग्रह किया, “कृपा कर आप इस दूसरी जगह पर आ जाइए, जहां से ये लोग आपको दिखाई दे सकें, हालांकि यहां से आप उनका पास वाला छोर ही देख सकेंगे, पूरे समूह को नहीं. आप उन्हें वहीं से शाप दे दीजिए.” ");
INSERT INTO hincv_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","तब बालाक बिलआम को ज़ोफिम के मैदान में, पिसगाह की चोटी पर ले गया. वहां उसने सात वेदियां बनवाई और हर एक पर एक-एक बछड़ा तथा एक-एक मेढ़ा भेंट चढ़ाया. ");
INSERT INTO hincv_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","फिर वहां बिलआम ने बालाक से कहा, “आप यहीं होमबलि के निकट ठहरिए और मैं वहां आगे जाकर याहवेह से भेंट करूंगा.” ");
INSERT INTO hincv_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","वहां याहवेह ने बिलआम से भेंट की तथा उसके मुख में अपने शब्द भर दिए और याहवेह ने बिलआम को यह आज्ञा दी, “बालाक के पास लौटकर तुम यह कहोगे.” ");
INSERT INTO hincv_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","बिलआम बालाक के पास लौट आया, जो इस समय होमबलि के निकट खड़ा हुआ था, तथा मोआब के प्रधान भी उसके पास खड़े हुए थे. बालाक ने उससे पूछा, “क्या कहा है याहवेह ने तुमसे?” ");
INSERT INTO hincv_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","तब बिलआम ने उसे सौंपा गया वचन दोहरा दिया: “उठो, बालाक, सुन लो; ज़ीप्पोर के पुत्र, मेरी ओर ध्यान दो! ");
INSERT INTO hincv_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","परमेश्वर मनुष्य तो हैं नहीं, कि झूठी बात करें, न ही वह मानव की संतान हैं, कि उन्हें अपना मन बदलना पड़े. क्या, यह संभव है कि उन्होंने कुछ कहा है? और उन्हें वह पूरा करना असंभव हो गया? ");
INSERT INTO hincv_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","सुन लीजिए, मुझे तो आदेश मिला है इन्हें आशीर्वाद देने का; जब याहवेह ने आशीर्वाद दे दिया है, तो उसे पलटा नहीं जा सकता. ");
INSERT INTO hincv_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“याहवेह ने याकोब में अनर्थ नहीं पाया, न उन्हें इस्राएल में विपत्ति दिखी है; याहवेह, जो उनके परमेश्वर हैं, उनके साथ हैं; उनके साथ राजा की ललकार रहती है. ");
INSERT INTO hincv_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","परमेश्वर ही हैं, मिस्र से उन्हें निकालने वाले; उनमें जंगली सांड़ के समान ताकत है. ");
INSERT INTO hincv_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","कोई अपशकुन नहीं है याकोब के विरुद्ध, न ही इस्राएल के विरुद्ध कोई भावी घोषणा. सही अवसर पर याकोब के विषय में कहा जाएगा, इस्राएल के विषय में कहा जाएगा, ‘याहवेह ने कैसा महान कार्य किया है!’ ");
INSERT INTO hincv_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","देखो, सिंहनी के समान यह दल उभर रहा है, एक शेर के समान यह स्वयं को खड़ा कर रहा है; जब तक वह आहार को खा न ले, वह विश्राम न करेगा, हां, तब तक, जब तक वह मारे हुओं का लहू न पी ले.” ");
INSERT INTO hincv_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","यह सुन बालाक ने बिलआम से कहा, “ऐसा करो, अब न तो शाप दो और न ही आशीर्वाद!” ");
INSERT INTO hincv_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","किंतु बिलआम ने बालाक को उत्तर दिया, “क्या मैंने आपको बताया न था, जो कुछ याहवेह मुझसे कहेंगे, वही करना मेरे लिए ज़रूरी है?” ");
INSERT INTO hincv_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","तब बालाक ने बिलआम से विनती की, “कृपा कर आइए, मैं आपको एक दूसरी जगह पर ले चलूंगा. हो सकता है यह परमेश्वर को ठीक लगे और आप मेरी ओर से उन्हें शाप दे दें.” ");
INSERT INTO hincv_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","फिर बालाक बिलआम को पेओर की चोटी पर ले गया, जहां से उजाड़ क्षेत्र दिखाई देता है. ");
INSERT INTO hincv_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","बिलआम ने बालाक को उत्तर दिया, “अब आप यहां मेरे लिए सात वेदियां बना दीजिए तथा मेरे लिए यहां सात बछड़े एवं सात मेढ़े तैयार कीजिए.” ");
INSERT INTO hincv_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","बालाक ने ठीक वैसा ही किया, जैसा बिलआम ने विनती की थी. उसने हर एक वेदी पर एक-एक मेढ़ा चढ़ाया. ");
INSERT INTO hincv_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","जब बिलआम ने यह ध्यान दिया कि इस्राएल को आशीर्वाद देने पर याहवेह प्रसन्‍न होते हैं, उसने पूर्व अवसरों के समान शकुन ज्ञात करने का प्रयास नहीं किया. उसने निर्जन प्रदेश की ओर अपना मुख स्थिर किया. ");
INSERT INTO hincv_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","जब बिलआम ने दृष्टि की, तो उसे गोत्र के अनुसार व्यवस्थित इस्राएली डेरे डाले हुए दिखाई दिए. परमेश्वर का आत्मा उस पर उतरा. ");
INSERT INTO hincv_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","उसने अपना वचन शुरू कर दिया: “बेओर के पुत्र बिलआम की वाणी, उस व्यक्ति की वाणी, जिसे दृष्टि दी गई है, ");
INSERT INTO hincv_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","यह उसकी वाणी है, जो परमेश्वर के वचन सुनता है, जो सर्वशक्तिमान का दर्शन देखा करता है, वह भूमि पर दंडवत पड़ा है, उसकी दृष्टि खुली है: ");
INSERT INTO hincv_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“याकोब कैसे सुंदर लग रहे हैं, तुम्हारे शिविर, इस्राएल, तुम्हारे डेरे! ");
INSERT INTO hincv_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“जो फैली हुई घाटी के समान है, जो नदी तट के बगीचे के समान है, जो याहवेह द्वारा रोपित अगरू पौधे के समान, जो जल के निकट के देवदार वृक्ष के समान है. ");
INSERT INTO hincv_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","जल उसके जल पात्रों से हमेशा बहता रहेगा, उसका बीज जल भरे खेतों के निकट होगा. “उसका राजा, अगाग से भी अधिक महान होगा, उसका राज्य बढ़ता जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“परमेश्वर उसे मिस्र देश से निकाल लाए; उसके लिए परमेश्वर जंगली सांड़ के सींग के समान हैं, वह उन राष्ट्रों को चट कर जाएगा, जो उसके विरुद्ध हैं, उनकी हड्डियां चूर-चूर हो जाएंगी, वह अपने बाणों से उन्हें नाश कर देगा. ");
INSERT INTO hincv_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","वह शेर के समान लेटता तथा विश्राम करता है, किसमें साहस है कि इस शेर को छेड़ें? “सराहनीय हैं वे सब, जो उसे आशीर्वाद देते हैं, शापित हैं, वे सब जो उसे शाप देते हैं!” ");
INSERT INTO hincv_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","बिलआम के प्रति बालाक का क्रोध भड़क उठा, अपने हाथ पीटते हुए बिलआम से कहा, “मैंने तुम्हें अपने शत्रुओं को शाप देने के उद्देश्य से यहां बुलाया था और अब देख लो, तुमने उन्हें तीनों बार आशीष ही देने की हठ की है. ");
INSERT INTO hincv_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","इसलिये अब भाग जाओ यहां से अपने देश को. मैंने चाहा था, तुम्हें बहुत ही सम्मानित करूंगा; किंतु देख लो, याहवेह ने यह सम्मान भी तुमसे दूर ही रखा है.” ");
INSERT INTO hincv_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","बिलआम ने बालाक को उत्तर दिया, “क्या, मैंने आपके द्वारा भेजे गए दूतों के सामने यह स्पष्ट न किया था, ");
INSERT INTO hincv_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘चाहे बालाक मेरे घर को चांदी-सोने से भर दे, मेरे लिए याहवेह के आदेश के विरुद्ध अपनी ओर से अच्छाई या बुराई करना असंभव होगा. मैं तो वही कहूंगा, जो याहवेह मुझसे कहेंगे’? ");
INSERT INTO hincv_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","फिर अब यह सुन लीजिए: मैं अपने लोगों के बीच में लौट रहा हूं, मैं आपको चेतावनी दूंगा कि भविष्य में ये लोग आपकी प्रजा के साथ क्या-क्या करने पर हैं.” ");
INSERT INTO hincv_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","उसने अपना वचन इस प्रकार शुरू किया: “बेओर के पुत्र बिलआम की वाणी, उस व्यक्ति की वाणी, जिसे दृष्टि प्रदान कर दी गई है, ");
INSERT INTO hincv_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","उस व्यक्ति की वाणी, जो परमेश्वर का वचन सुनता है, जिसे उन परम प्रधान के ज्ञान की जानकारी है, जो सर्वशक्तिमान के दिव्य दर्शन देखता है, वह है तो भूमि पर दंडवत, किंतु उसकी आंखें खुली हैं: ");
INSERT INTO hincv_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“मैं उन्हें देख अवश्य रहा हूं, किंतु इस समय नहीं; मैं उनकी ओर दृष्टि तो कर रहा हूं, किंतु वह निकट नहीं है. याकोब से एक तारा उदय होगा; इस्राएल से एक राजदंड उभरेगा, जो मोआब के मुंह को कुचल देगा, वह शेत के सभी वंशजों को फाड़ देगा. ");
INSERT INTO hincv_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","एदोम अधीनता में जा पड़ेगा; सेईर भी, जो इसके शत्रु हैं, अधीन हो जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","याकोब के घराने में से एक महान अधिकारी हो जाएगा, वही इस नगर के बचे हुए भाग को नाश कर देगा.” ");
INSERT INTO hincv_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","उसने अमालेकियों की ओर दृष्टि की और यह वचन शुरू किया: “अमालेक उन राष्ट्रों में आगे था, किंतु उसका अंत विनाश ही है.” ");
INSERT INTO hincv_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","इसके बाद बिलआम ने केनियों की ओर अपनी दृष्टि उठाई, तथा अपना वचन इस प्रकार ज़ारी रखा: “तुम्हारा निवास तो अति दृढ़ है, तुम्हारा बसेरा चट्टान की सुरक्षा में बसा है; ");
INSERT INTO hincv_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","यह होने पर भी केनी उजड़ हो जाएगा; अश्शूर तुम्हें कब तक बंदी रखेगा?” ");
INSERT INTO hincv_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","इसके बाद बिलआम ने अपने वचन में यह कहा: “परमेश्वर द्वारा ठहराए गए के अलावा जीवित कौन रह सकता है? ");
INSERT INTO hincv_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","किंतु जहाज़ कित्तिम तट से आते रहेंगे; वे अश्शूर को ताड़ना देंगे, एबर को ताड़ना देंगे, इस प्रकार उनका अंत भी नाश ही होगा.” ");
INSERT INTO hincv_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","इसके बाद बिलआम अपने नगर को लौट गया तथा बालाक भी अपने स्थान पर लौट गया. ");
INSERT INTO hincv_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","जब इस्राएली शित्तीम में डेरे डाले हुए थे, तब वे मोआब की उन युवतियों के साथ कुकर्म करने लगे, ");
INSERT INTO hincv_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","जिन्होंने उन्हें देवताओं के लिए बलि अर्पण-उत्सव में आमंत्रित करना शुरू कर दिया था. इस्राएलियों ने उनके देवताओं के सामने भोजन करना एवं दंडवत करना शुरू कर दिया था. ");
INSERT INTO hincv_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","इस प्रकार इस्राएलियों ने पेओर के बाल के साथ स्वयं को जोड़ लिया था. इससे याहवेह इस्राएल पर क्रोधित हो गए. ");
INSERT INTO hincv_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","याहवेह ने मोशेह को आज्ञा दी, “दिन के प्रकाश में याहवेह के सामने सारी प्रजा के प्रधानों को फांसी दे दो, ताकि इस्राएल पर से याहवेह का भड़का हुआ क्रोध शांत हो सके.” ");
INSERT INTO hincv_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","फिर मोशेह ने इस्राएल के न्यायियों को आदेश दिया, “तुममें से हर एक अपने-अपने गोत्र के ऐसे हर एक व्यक्ति को मार डालें, जो पेओर के बाल का भक्त हो चुका है.” ");
INSERT INTO hincv_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","उसी समय यह देखा गया: सारी इस्राएली प्रजा एवं मोशेह के देखते-देखते, जब वे सब मिलनवाले तंबू के द्वार के सामने रो रहे थे, तब एक इस्राएली व्यक्ति अपने संबंधियों के सामने एक मिदियानी स्त्री ले आया. ");
INSERT INTO hincv_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","जब पुरोहित अहरोन के पौत्र एलिएज़र के पुत्र फिनिहास ने यह देखा, तब वह सारी सभा के सामने उठा, अपने हाथ में एक बर्छी ली, ");
INSERT INTO hincv_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","उस शिविर के भीतर जाकर उस इस्राएली पुरुष तथा मिदियानी स्त्री, दोनों को बेध डाला, बर्छी दोनों ही की देह को बेध कर पार निकल गई. इससे इस्राएल पर आई यह महामारी थम गई; ");
INSERT INTO hincv_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","महामारी से मरने वालों की संख्या 24,000 पहुंच गई. ");
INSERT INTO hincv_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","याहवेह ने मोशेह पर यह सत्य प्रकट किया, ");
INSERT INTO hincv_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“पुरोहित अहरोन के पुत्र एलिएज़र के पुत्र फिनिहास ने इस्राएल के घराने पर भड़के मेरे क्रोध को शांत कर दिया है. उन लोगों के बीच वही था जिसमें वही जलन थी, जो मुझमें थी. इसलिए मैंने अपनी जलन में इस्राएल के घराने को नाश नहीं कर डाला. ");
INSERT INTO hincv_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","तुम उसे सूचित करो: यह समझ लो कि मैं उसके साथ अपनी शांति की वाचा स्थापित कर रहा हूं. ");
INSERT INTO hincv_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","इसका संबंध उससे तथा उसके वंशजों से है, यह सदा के लिए पुरोहित पद की वाचा है, क्योंकि उसमें उसके परमेश्वर के लिए जलन थी. उसने इस्राएल के घराने के लिए प्रायश्चित पूरा कर दिया है.” ");
INSERT INTO hincv_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","उस इस्राएली व्यक्ति का नाम, जिसको उस मिदियानी स्त्री के साथ मारा गया था, ज़िमरी था, जिसका पिता सालू था, जो शिमओन के गोत्र से उनके घराने का प्रधान था. ");
INSERT INTO hincv_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","उस मारी गई मिदियानी स्त्री का नाम कोज़बी था, वह ज़ुर नामक व्यक्ति की पुत्री थी, जो मिदियानी प्रजा में घराने का प्रधान था. ");
INSERT INTO hincv_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","इसके बाद याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“मिदियानियों के प्रति शत्रुता बनाए रखो तथा उनका नाश कर दो. ");
INSERT INTO hincv_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","क्योंकि वे तुम्हारे साथ छल करते हुए तुम्हारे शत्रु बने रहे हैं, इसी के विषय में उन्होंने पेओर की घटना में तुमसे छल किया तथा कोज़बी, मिदियानी प्रधान की पुत्री के संदर्भ में भी, जो उनकी जाति की थी, जिसको पेओर की घटना के कारण महामारी के दिन मारा गया था.” ");
INSERT INTO hincv_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","इस महामारी के बाद याहवेह ने मोशेह तथा पुरोहित अहरोन के पुत्र एलिएज़र को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“पितरों के अनुसार बीस वर्ष से अधिक आयु के हर एक इस्राएली की, जो युद्ध के लिए सक्षम हो, गिनती करो.” ");
INSERT INTO hincv_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","फिर मोशेह तथा पुरोहित एलिएज़र ने मोआब के मैदानों में उन्हें यरदन तट पर, जो येरीख़ो के निकट है, यह आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“बीस वर्ष से अधिक आयु के व्यक्तियों की गिनती की जाए, जैसा कि याहवेह द्वारा मोशेह को आदेश दिया गया है.” इस अवसर पर मिस्र देश से निकाले गए इस्राएल वंशज ये थे: ");
INSERT INTO hincv_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","इस्राएल का पहलौठा, रियूबेन, रियूबेन के पुत्र हनोख से हनोखी परिवार; पल्लू से पल्लुई परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","हेज़रोन से हेज़रोनी परिवार; कारमी से कारमी परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","रियूबेन के परिवार में यह ही परिवार समूह थे, और इनसे जो गिने गये वे 43,730 थे. ");
INSERT INTO hincv_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","पल्लू का पुत्र एलियाब था, ");
INSERT INTO hincv_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","एलियाब के तीन पुत्र थे—नमूएल, दाथान और अबीराम. याद रखो कि दाथान और अबीराम वे दो नेता थे, जो मोशेह और अहरोन के विरोधी हो गए थे. वे कोराह के अनुयायी थे और कोराह याहवेह का विरोधी हो गया था. ");
INSERT INTO hincv_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","वही समय था जब भूमि विभाजित हो गई थी और कोराह एवं उसके सभी अनुयायियों को निगल गई थी. कुल दो सौ पचास पुरुष मर गये थे. यह इस्राएल के सभी लोगों के लिए एक संकेत और चेतावनी थी. ");
INSERT INTO hincv_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","किंतु कोराह के सारे वंशज नहीं मरे. ");
INSERT INTO hincv_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","शिमओन के गोत्र के ये परिवार थे: नमूएल से नमूएल के परिवार; यामिन से यामिन परिवार; याकिन से याकिन परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ज़ेराह से जेराही परिवार; शाऊल से शाऊल परिवार. ");
INSERT INTO hincv_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","शिमओन के परिवार समूह में वे परिवार थे; इसमें कुल 22,200 पुरुष थे. ");
INSERT INTO hincv_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","गाद के परिवार समूह के ये परिवार हैं: ज़ेफोन से ज़ेफोन परिवार; हग्गी से हग्गी परिवार; शूनी से शूनी परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ओजनी से ओजनी परिवार; एरी से एरी परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","अरोद से अरोद परिवार; अरेली से अरेली परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","गाद के परिवार समहू के वे परिवार थे; इनमें कुल 40,500 पुरुष थे. ");
INSERT INTO hincv_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","यहूदाह के दो पुत्र एर और ओनान, कनान में मर गए थे. ");
INSERT INTO hincv_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","यहूदाह के परिवार समूह के ये परिवार हैं: शेलाह से शेलाह परिवार; पेरेज़ से पेरेज़ परिवार; ज़ेराह से ज़ेराह परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","पेरेज़ के ये परिवार हैं: हेज़रोन से हेज़रोनी परिवार; हामुल से हामूली परिवार. ");
INSERT INTO hincv_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","यहूदाह के परिवार समूह के वे परिवार थे. इनके कुल पुरुषों की संख्या 76,500 थी. ");
INSERT INTO hincv_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","इस्साखार के परिवार समूह के परिवार ये थे: तोला से तोला परिवार; पुव्वाह से पुव्वा परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","याशूब से याशूब परिवार; शिम्रोन से शिम्रोन परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","इस्साखार के परिवार समूह के वे परिवार थे; इनमें कुल पुरुषों की संख्या 64,300 थी. ");
INSERT INTO hincv_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ज़ेबुलून के परिवार समूह के परिवार ये थे: सेरेद से सेरेद परिवार; एलोन से एलोन परिवार; याहलील से याहलील परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ज़ेबुलून के परिवार समूह के वे परिवार थे; इनमें कुल पुरुषों की संख्या 60,500 थी. ");
INSERT INTO hincv_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","योसेफ़ के दो पुत्र मनश्शेह और एफ्राईम थे. हर एक पुत्र अपने परिवारों के साथ परिवार समूह बन गया था. ");
INSERT INTO hincv_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","मनश्शेह के परिवार में ये थे: माखीर से माखीर परिवार (माखीर गिलआद का पिता था); गिलआद से गिलआद परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","गिलआद के परिवार ये थे: ईएजेर से ईएजेर परिवार; हेलेक से हेलेकी परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","अस्रीएल से अस्रीएल परिवार; शेकेम से शेकेमी परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","शेमीदा से शेमीदा परिवार; हेफेर से हेफेर परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(हेफेर का पुत्र ज़लोफेहाद था. किंतु उसका कोई पुत्र न था; केवल पुत्री थी. उसकी पुत्रियों के नाम महलाह, नोआ, होगलाह, मिलकाह, और तिरज़ाह थे.) ");
INSERT INTO hincv_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","मनश्शेह परिवार समूह के ये परिवार हैं; इनमें कुल पुरुष 52,700 थे. ");
INSERT INTO hincv_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","एफ्राईम के परिवार समूह के ये परिवार थे: शूतेलाह से शूतेलाही परिवार; बेकेर से बेकेरी परिवार; तहान से तहानी परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","एरान शूतेलाह परिवार का था: उसका परिवार एरनी था. ");
INSERT INTO hincv_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","एफ्राईम के परिवार समूह में ये परिवार थे; कुल पुरुषों की संख्या इसमें 32,500 थी. वे ऐसे सभी लोग हैं जो योसेफ़ के परिवार समूहों के हैं. ");
INSERT INTO hincv_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","बिन्यामिन के परिवार समूह के परिवार ये थे: बेला से बेला परिवार; अशबेल से अशबेली परिवार; अहीराम से अहीरामी परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","शपूआमि से शपूआमि परिवार; हूपाम से हूपामी परिवार. ");
INSERT INTO hincv_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","बेला के परिवार में अर्द और नामान थे: अर्द से अर्दी परिवार; नामान से नामानी परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","बिन्यामिन के परिवार समूह के ये सभी परिवार थे; इसमें पुरुषों की कुल संख्या 45,600 थी. ");
INSERT INTO hincv_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","दान के परिवार समूह में ये परिवार थे: शूहाम से शूहाम परिवार समूह. दान के परिवार समूह से वह परिवार समूह था: ");
INSERT INTO hincv_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","शूहाम परिवार समूह में बहुत से परिवार थे. इनमें पुरुषों की कुल संख्या 64,400 थी. ");
INSERT INTO hincv_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","आशेर के परिवार समूह के ये परिवार हैं: इमनाह से इम्नी परिवार; इशवी से इशवी परिवार; बेरियाह से बेरिय परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","बेरियाह के ये परिवार हैं: हेबेर से हेबेरी परिवार; मालखिएल से मालखिएल परिवार. ");
INSERT INTO hincv_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","आशेर की एक पुत्री सेराह नाम की थी. ");
INSERT INTO hincv_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","आशेर के परिवार समूह में वे परिवार थे; इसमें पुरुषों की संख्या 53,400 थी. ");
INSERT INTO hincv_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","नफताली के परिवार समूह के ये परिवार थे: यहसेल, जिससे यहसेली परिवार; गूनी, जिससे गूनी परिवार; ");
INSERT INTO hincv_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","येसेर, जिससे येसेरी परिवार; शिल्लेम, जिससे शिल्लेमी परिवार. ");
INSERT INTO hincv_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","नफताली के परिवार समूह के ये परिवार थे. इसमें पुरुषों की कुल संख्या 45,400 थी. ");
INSERT INTO hincv_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","इस प्रकार इस्राएल के पुरुषों की कुल संख्या 6,01,730 थी. ");
INSERT INTO hincv_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","याहवेह ने मोशेह से कहा, ");
INSERT INTO hincv_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“हर एक परिवार समूह के लिये, जिन्हें गिना गया है, मीरास में पर्याप्‍त भूमि दी जाएगी. ");
INSERT INTO hincv_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","बड़ा परिवार समूह अधिक भूमि पाएगा, और छोटा परिवार समूह कम भूमि पाएगा. किंतु हर एक परिवार समूह को भूमि मिलेगी जिसके लिए मैंने वचन दिया है, और जो भूमि वे पाएंगे वह उनकी गिनी गई संख्या के बराबर होगी. ");
INSERT INTO hincv_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","हर एक परिवार समूह को लाटरी के आधार पर निश्चय करके धरती दी जाएगी और उस प्रदेश का वही नाम होगा जो उस परिवार समूह का होगा. ");
INSERT INTO hincv_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","वह प्रदेश बड़े और छोटे परिवार समूहों को पासे फेंककर मीरास बांट दिया जाएगा.” ");
INSERT INTO hincv_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","लेवी का परिवार समूह भी गिना गया. लेवी के परिवार समूह के ये परिवार हैं: गेरशोन से गेरशोनी परिवार; कोहाथ से कोहाथ परिवार; मेरारी से मेरारी परिवार. ");
INSERT INTO hincv_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","लेवी के परिवार समूह से ये परिवार भी थे: लिबनी परिवार, हेब्रोनी परिवार, माहली परिवार, मूशी परिवार, कोहाथ परिवार, (अमराम कहात के परिवार समूह का था; ");
INSERT INTO hincv_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","अमराम की पत्नी का नाम योकेबेद था. वह भी लेवी के परिवार समूह की थी. उसका जन्म मिस्र में हुआ था. अमराम और योकेबेद के दो पुत्र अहरोन और मोशेह थे. उनकी एक पुत्री मिरियम भी थी. ");
INSERT INTO hincv_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","नादाब, अबीहू, एलिएज़र तथा इथामार का पिता था अहरोन. ");
INSERT INTO hincv_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","किंतु नादाब और अबीहू मर गए; क्योंकि उन्होंने याहवेह को उस आग से भेंट चढ़ाई जो उनके लिए स्वीकृत नहीं थी.) ");
INSERT INTO hincv_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","लेवी परिवार समूह के सभी पुरुषों की संख्या 23,000 थी. किंतु ये लोग इस्राएल के अन्य लोगों के साथ नहीं गिने गए थे. वे भूमि नहीं पा सके, जिसे अन्य लोगों को देने का वचन याहवेह ने दिया था. ");
INSERT INTO hincv_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","मोशेह और पुरोहित एलिएज़र ने इन सभी लोगों को गिना. उन्होंने इस्राएल के लोगों को मोआब के मैदान में गिना. यह येरीख़ो से यरदन नदी के पार था. ");
INSERT INTO hincv_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","बहुत समय पहले, मोशेह और पुरोहित अहरोन ने इस्राएल के लोगों को सीनायी मरुभूमि में गिना था. किंतु वे सभी लोग मर चुके थे. मोआब के मैदान में मोशेह ने जिन लोगों को गिना, वे पहले गिने गए लोगों से भिन्‍न थे. ");
INSERT INTO hincv_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","यह इसलिये हुआ कि याहवेह ने इस्राएल के लोगों से यह कहा था कि वे सभी मरुभूमि में मरेंगे. जो केवल दो जीवित बचे थे; येफुन्‍नेह का पुत्र कालेब और नून का पुत्र यहोशू! ");
INSERT INTO hincv_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","तब योसेफ़ के पुत्र मनश्शेह के परिवार से माखीर के पुत्र गिलआद के पुत्र हेफेर के पुत्र ज़लोफेहाद की पुत्रियां, जिनके नाम महलाह, नोहा, होगलाह, मिलकाह तथा तिरज़ाह थे, ");
INSERT INTO hincv_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","मोशेह, एलिएज़र तथा प्रधानों एवं सारी सभा की उपस्थिति में मिलनवाले तंबू के द्वार पर एकत्र हुईं. उन्होंने यह विनती की, ");
INSERT INTO hincv_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“हमारे पिता की मृत्यु तो बंजर भूमि में ही हो चुकी थी. वह उनमें शामिल नहीं थे, जो कोराह के साथ मिलकर याहवेह के विरुद्ध हो गए थे, उनकी मृत्यु उन्हीं के पाप में हो गई. उनके कोई पुत्र न था. ");
INSERT INTO hincv_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","उनके कोई पुत्र न होने के कारण भला उनके परिवार में से उनका नाम क्यों मिट जाए? कृपया हमारे भाइयों के बीच में से हमें एक भाग दिया जाए.” ");
INSERT INTO hincv_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","फिर मोशेह ने यह विषय याहवेह के सामने रख दिया, ");
INSERT INTO hincv_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","तब याहवेह ने मोशेह को यह उत्तर दिया, ");
INSERT INTO hincv_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“ज़लोफेहाद की पुत्रियों ने सुसंगत विषय प्रस्तुत किए हैं. ज़रूरी है कि तुम उन्हें उनके पिता के भाइयों के बीच में एक मीरास का अंश प्रदान करो. तुम उनके पिता की मीरास उनके नाम लिख दोगे. ");
INSERT INTO hincv_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“तुम इस्राएल के घराने को यह भी सूचित करोगे, ‘यदि किसी ऐसे व्यक्ति की मृत्यु हो जाए, जिसके कोई पुत्र ही नहीं है, तब उसकी मीरास उसकी पुत्री के नाम कर देना. ");
INSERT INTO hincv_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","यदि उसके कोई पुत्री भी न हो, तब तुम उसकी मीरास उसके भाइयों के नाम कर दोगे. ");
INSERT INTO hincv_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","यदि उसके कोई भाई भी नहीं हो, तब तुम उसके पिता के भाइयों को उसकी मीरास प्रदान कर दोगे. ");
INSERT INTO hincv_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","यदि उसके पिता के कोई भाई भी न हो, तब तुम उसकी मीरास उसके परिवार में उसके ही निकटतम संबंधी को प्रदान कर दोगे, वह मीरास उसकी हो जाएगी. यह इस्राएल के घराने के लिए न्याय की विधि होगी, ठीक जैसा आदेश याहवेह द्वारा मोशेह को दिया गया था.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","इसके बाद याहवेह ने मोशेह को आज्ञा दी, “तुम इस अबारिम पर्वत पर जाओ और उस देश पर दृष्टि डाल लो, जो मैंने इस्राएल के घराने को दे दिया है. ");
INSERT INTO hincv_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","जब तुम इस देश को देख लोगे, तुम भी अपने भाई अहरोन के समान अपने लोगों में मिला लिए जाओगे, ");
INSERT INTO hincv_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","इसलिये, कि तुमने ज़िन के निर्जन प्रदेश में उस सोते के पास सारी सभा के सामने उनके द्वारा पैदा की गई विद्रोह की स्थिति में मेरी पवित्रता को प्रतिष्ठित करने के मेरे आदेश के विपरीत तुमने काम किया था.” (कादेश के ज़िन के निर्जन प्रदेश में यही था वह मेरिबाह का सोता.) ");
INSERT INTO hincv_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","फिर मोशेह ने याहवेह से विनती की, ");
INSERT INTO hincv_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“सभी मनुष्यों की आत्माओं के परमेश्वर, याहवेह, इस सभा के लिए एक अगुए को नियुक्त कर दें. ");
INSERT INTO hincv_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","वही उनके हक में सही रहेगा. वही उनका अगुआ होकर इस देश में प्रवेश करवाएगा, जिससे याहवेह की प्रजा की स्थिति वैसी न हो जाए, जैसी बिना चरवाहे की भेड़-बकरियों की हो जाती है.” ");
INSERT INTO hincv_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","मोशेह के लिए याहवेह का उत्तर यह था, “नून के पुत्र यहोशू पर अपना हाथ रख दो-वह एक ऐसा व्यक्ति है, जिसमें पवित्र आत्मा का वास है. ");
INSERT INTO hincv_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","उसे पुरोहित एलिएज़र तथा सारी सभा के सामने खड़ा करना और उन सबके सामने उसे नियुक्त करना. ");
INSERT INTO hincv_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","अपने अधिकार का एक भाग तुम उस पर दे देना, कि इस्राएल के घराने की सारी सभा में उसके प्रति आज्ञाकारिता की भावना भर जाए. ");
INSERT INTO hincv_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","इसके अलावा, वह पुरोहित एलिएज़र पर निर्भर रहेगा, कि एलिएज़र उरीम के द्वारा उसके लिए याहवेह की इच्छा मालूम किया करेगा. उसी के आदेश पर वे कूच करेंगे, उसी की आज्ञा पर वे प्रवेश कर सकेंगे, दोनों ही स्वयं वह तथा इस्राएली, अर्थात् सारी सभा.” ");
INSERT INTO hincv_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","मोशेह ने याहवेह की आज्ञा का पूरा-पूरा पालन किया. उन्होंने यहोशू को अपने साथ ले जाकर पुरोहित एलिएज़र तथा सारी सभा के सामने खड़ा कर दिया. ");
INSERT INTO hincv_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","तब मोशेह ने योशुआ पर अपने हाथ रखे और उसे उत्तराधिकारी नियुक्त किया, ठीक जैसी आज्ञा उन्हें याहवेह से प्राप्‍त हुई थी. ");
INSERT INTO hincv_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“इस्राएल के घराने को यह आज्ञा दे दो: ‘मुझे भेंट चढ़ाने के लिए तुम सावधान रहोगे, ठीक समय पर आग द्वारा चढ़ाया मेरा भोजन, एक सुखद-सुगंध.’ ");
INSERT INTO hincv_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","तुम उन्हें यह साफ़-साफ़ कहोगे: यह वह भेंट है, जो तुम याहवेह को आग के माध्यम से भेंट करोगे: एक वर्ष के दो मेमने, जो दोषहीन होने अवश्य हैं, जिन्हें तुम प्रतिदिन नियमित होमबलि में भेंट करोगे. ");
INSERT INTO hincv_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","तुम एक मेमना भोर को, तथा दूसरा शाम के समय में; ");
INSERT INTO hincv_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","इसके अलावा अन्‍नबलि के लिए डेढ़ किलो मैदा, जिसे पेरकर निकाले गए एक लीटर तेल में मिलाया गया हो. ");
INSERT INTO hincv_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","यह सीनायी पर्वत पर एक सुखद-सुगंध के लिए ठहराया गया था, कि यह याहवेह के लिए एक भेंट हो जाए. ");
INSERT INTO hincv_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","इसके बाद पेय बलि के लिए, हर एक मेमने के साथ एक लीटर दाखमधु होगी. तुम पवित्र स्थान में याहवेह के लिए बलि उंडेल दोगे. ");
INSERT INTO hincv_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","वह अन्य मेमना तुम शाम के समय में भेंट करोगे. इसकी विधि ठीक वैसी ही होगी, जैसी सुबह की अन्‍नबलि की थी. तथा उसी प्रकार जैसी पेय बलि की थी. तुम इसे आग में भेंट करोगे, जो याहवेह के लिए सुखद-सुगंध होगी. ");
INSERT INTO hincv_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘इसके बाद शब्बाथ पर याहवेह के लिए होमबलि में एक वर्ष के, दोष रहित दो मेमने भेंट किए जाएं, तथा अन्‍नबलि के लिए तेल मिला हुआ तीन किलो मैदा तथा इसकी पेय बलि. ");
INSERT INTO hincv_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","यह नियमित रूप से भेंट की जाती होमबलि एवं इसकी पेय बलि के अलावा हर शब्बाथ के लिए ठहराई गई होमबलि होगी. ");
INSERT INTO hincv_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘फिर तुम्हारे हर एक महीने की शुरुआत में तुम याहवेह के लिए यह होमबलि भेंट करोगे: दो बछड़े एवं बैल, दोषहीन एक-एक वर्ष के सात मेमने, ");
INSERT INTO hincv_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","तथा हर एक बैल के साथ अन्‍नबलि के लिए तेल मिला हुआ पांच किलो मैदा; तथा हर एक बछड़े के साथ अन्‍नबलि के लिए तेल मिला हुआ तीन किलो मैदा, ");
INSERT INTO hincv_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","हर एक मेमने के साथ तेल मिला हुआ डेढ़ किलो मैदा अन्‍नबलि के लिए, होमबलि के लिए ये आग के द्वारा याहवेह को सुखद-सुगंध के लिए भेंट किए जाएं. ");
INSERT INTO hincv_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","इनके लिए भेंट की जाने के लिए पेय बलि होगी, एक बछड़े के साथ तीन लीटर दाखमधु, मेढ़े के साथ दो लीटर दाखमधु तथा एक मेमने के साथ एक लीटर दाखमधु. यह पूरे वर्ष के हर एक माह में भेंट की जाने के लिए निर्धारित बलियां हैं. ");
INSERT INTO hincv_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","याहवेह के लिए पापबलि होगी एक बकरा, जिसे नियमित होमबलि के अलावा इसकी पेय बलि के साथ भेंट किया जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘इसके बाद पहले महीने की चौदहवीं तारीख पर याहवेह का फ़सह होगा. ");
INSERT INTO hincv_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","इस माह के चौदहवें दिन उत्सव होगा. सात दिन खमीर रहित रोटी को ही खाया जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","पहले दिन पवित्र सभा होगी; तथा तुम किसी भी प्रकार की मेहनत न करना. ");
INSERT INTO hincv_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","उस दिन तुम याहवेह के लिए आग के द्वारा बलि भेंट होमार्पण चढ़ाना. उसमें ये भी शामिल हों: दो बछड़े, एक मेढ़ा तथा एक वर्ष के सात निर्दोष मेमने. ");
INSERT INTO hincv_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","उनका अन्‍नबलि हर एक बैल के साथ तेल मिला हुआ पांच किलो मैदा; तथा हर एक मेढ़े के साथ अन्‍नबलि के लिए तेल मिला हुआ तीन किलो मैदा, ");
INSERT INTO hincv_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","हर एक मेमने के साथ तेल में मिला हुआ डेढ़ किलो मैदा अन्‍नबलि के लिए. ");
INSERT INTO hincv_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","इसके अलावा अपने प्रायश्चित के लिए पापबलि स्वरूप एक बकरा. ");
INSERT INTO hincv_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","तुम ये सभी बलियां नियमित प्रस्तुत की जा रही भोर की होमबलियों के अलावा भेंट करोगे. ");
INSERT INTO hincv_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","तुम सातों दिन, प्रतिदिन इसी रीति से बलियां भेंट किया करोगे; आग के द्वारा चढ़ाया वह भोजन, जो याहवेह के लिए सुखद-सुगंध होगा. यह नियमित होमबलि के अलावा इसकी पेय बलि के साथ भेंट किया जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","तथा सातवें दिन पवित्र सभा होगी, इस दिन तुम किसी भी प्रकार की मेहनत न करना. ");
INSERT INTO hincv_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘पहले फल के दिन भी, जब तुम अपने सप्‍ताहों के उत्सव में याहवेह को नई अन्‍नबलि भेंट करोगे, तब तुम पवित्र सभा करोगे. तुम कोई मेहनत न करोगे. ");
INSERT INTO hincv_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","तुम याहवेह को सुखद-सुगंध के लिए यह होमबलि भेंट करोगे: दो बछड़े, एक मेढ़ा एक वर्ष के सात मेमने; ");
INSERT INTO hincv_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","उनकी अन्‍नबलि होगी, हर एक बछड़े के साथ तेल मिला हुआ अढ़ाई किलो मैदा तथा हर एक मेढ़े के साथ दो किलो ");
INSERT INTO hincv_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","तथा हर एक मेमने के साथ एक किलो तेल मिला हुआ मैदा. ");
INSERT INTO hincv_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","इसके अलावा अपने प्रायश्चित के लिए एक बकरा. ");
INSERT INTO hincv_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","नियमित होमबलि एवं इससे संबंधित अन्‍नबलि के अलावा तुम उन्हें उनकी पेय बलि के साथ भेंट करोगे. ज़रूरी है कि ये निर्दोष हों. ");
INSERT INTO hincv_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘पहले महीने की पहली तारीख पर तुम पवित्र सभा आयोजित करोगे. इस दिन तुम कोई भी मेहनत न करोगे. यह वह दिन होगा, जिसे तुम तुरही बजाने के लिए प्रयोग करोगे. ");
INSERT INTO hincv_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","तुम याहवेह को सुखद-सुगंध भेंट करने के लिए यह होमबलि भेंट करोगे: एक बछड़ा, एक मेढ़ा तथा सात एक वर्ष के निर्दोष मेमने. ");
INSERT INTO hincv_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","इनके अलावा उनकी अन्‍नबलि भी; तेल मिला हुआ मैदा; बछड़ों के साथ ढाई किलो, मेढ़े के साथ दो किलो; ");
INSERT INTO hincv_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","तथा हर एक मेमने के साथ एक-एक किलो तेल मिला हुआ मैदा, ");
INSERT INTO hincv_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","साथ में अपने प्रायश्चित के लिए पापबलि में एक बकरा. ");
INSERT INTO hincv_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","नए चांद के लिए होमबलि तथा इससे संबंधित अन्‍नबलि के लिए नियमित होमबलि तथा अन्‍नबलि तथा उससे संबंधित पेय बलियां, जैसा उनके विषय में याहवेह ने आज्ञा दी थी, वैसे भेंट किए जाएं. ");
INSERT INTO hincv_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘इसी महीने की दसवीं तारीख पर तुम एक पवित्र सभा आयोजित करोगे; तुम स्वयं को नम्र करोगे, तुम किसी प्रकार की मेहनत नहीं करोगे. ");
INSERT INTO hincv_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","सुखद-सुगंध के लिए तुम याहवेह के लिए यह होमबलि भेंट करोगे: एक बछड़ा, एक मेढ़ा तथा एक वर्ष के सात निर्दोष मेमने. ");
INSERT INTO hincv_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","उनके साथ अन्‍नबलि होगी: तेल मिला हुआ मैदा; बछड़े के साथ ढाई किलो, मेढ़े के साथ दो किलो; ");
INSERT INTO hincv_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","तथा हर एक मेमने के साथ एक-एक किलो मैदा. ");
INSERT INTO hincv_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","प्रायश्चित के लिए पापबलि, नियमित होमबलि तथा अन्‍नबलि एवं पेय बलियां के अलावा पापबलि के लिए एक बकरा भी भेंट किया जाए. ");
INSERT INTO hincv_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘इसके बाद सातवें महीने की पन्द्रहवीं तारीख पर तुम एक पवित्र सभा आयोजित करोगे. तुम इसमें कोई भी मेहनत न करोगे, और याहवेह के लिए सात दिन उत्सव मनाओगे. ");
INSERT INTO hincv_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","तुम याहवेह के लिए सुखद-सुगंध के लिए आग के द्वारा यह होमबलि भेंट करो: तेरह बछड़े, दो मेढ़े, चौदह एक वर्ष के निर्दोष मेमने. ");
INSERT INTO hincv_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","उन तेरह बछड़ों के साथ यह अन्‍नबलि होगी: तेल मिला हुआ मैदा ढाई किलो, मेढ़े के साथ तेल मिला हुआ मैदा दो किलो, ");
INSERT INTO hincv_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","तथा हर एक मेमने के साथ एक-एक किलो तेल मिला हुआ मैदा. ");
INSERT INTO hincv_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","नियमित होमबलि, अन्‍नबलि तथा पेय बलि के अलावा पापबलि के लिए एक बकरा भेंट किया जाए. ");
INSERT INTO hincv_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘इसके बाद अगले दिन पशुओं में से बारह बछड़े, दो मेढ़े, एक वर्ष के चौदह निर्दोष मेमने. ");
INSERT INTO hincv_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","इनके अलावा अन्‍नबलि और पेय बलि चढ़ाना; जो बछड़ों, मेढ़ों तथा मेमनों के लिए उनकी संख्या के अनुरूप, नियम के अनुसार हो. ");
INSERT INTO hincv_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","तथा नियमित होमबलि के अलावा पापबलि के लिए एक बकरा तथा इसके साथ अन्‍नबलि तथा उनकी पेय बलियां. ");
INSERT INTO hincv_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘तीसरे दिन ग्यारह बछड़े, दो मेढ़े, एक वर्ष के चौदह निर्दोष मेमने. ");
INSERT INTO hincv_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","इनके अलावा अन्‍नबलि और पेय बलि चढ़ाना जो बछड़ों, मेढ़ों तथा मेमनों के साथ उनकी संख्या के अनुरूप, नियम के अनुसार हो. ");
INSERT INTO hincv_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","तथा नियमित होमबलि के अलावा पापबलि के लिए एक बकरा तथा इसके लिए अन्‍नबलि तथा उनकी पेय बलियां. ");
INSERT INTO hincv_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘चौथे दिन दस बछड़े, दो मेढ़े, एक वर्ष के चौदह निर्दोष मेमने. ");
INSERT INTO hincv_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","इनके अलावा अन्‍नबलि और पेय बलि चढ़ाना जो बछड़ों, मेढ़ों तथा मेमनों के साथ उनकी संख्या के अनुरूप, नियम के अनुसार हो. ");
INSERT INTO hincv_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","नियमित होमबलि, अन्‍नबलि तथा पेय बलि के अलावा पापबलि के लिए एक बकरा भेंट किया जाए. ");
INSERT INTO hincv_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘पांचवें दिन नौ बछड़े, दो मेढ़े, एक वर्ष के चौदह निर्दोष मेमने. ");
INSERT INTO hincv_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","इनके अलावा अन्‍नबलि और पेय बलि चढ़ाना जो बछड़ों, मेढ़ों तथा मेमनों के साथ उनकी संख्या के अनुरूप, नियम के अनुसार हो. ");
INSERT INTO hincv_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","नियमित होमबलि तथा अन्‍नबलि तथा पेय बलि के अलावा एक बकरा पापबलि के लिए चढ़ाया जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘छठवें दिन आठ बछड़े, दो मेढ़े, एक वर्ष के चौदह निर्दोष मेमने. ");
INSERT INTO hincv_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","इनके अलावा अन्‍नबलि और पेय बलि चढ़ाना जो बछड़ों, मेढ़ों तथा मेमनों के साथ उनकी संख्या के अनुरूप, नियम के अनुसार हो. ");
INSERT INTO hincv_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","तथा नियमित होमबलि के अलावा पापबलि के लिए एक बकरा तथा इसके लिए अन्‍नबलि तथा उनकी पेय बलियां. ");
INSERT INTO hincv_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘सातवें दिन सात बछड़े दो मेढ़े, एक वर्ष के चौदह निर्दोष मेमने. ");
INSERT INTO hincv_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","इनके अलावा अन्‍नबलि और पेय बलि चढ़ाना जो बछड़ों, मेढ़ों तथा मेमनों के साथ उनकी संख्या के अनुरूप, नियम के अनुसार हो. ");
INSERT INTO hincv_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","तथा नियमित होमबलि के अलावा पापबलि के लिए एक बकरा तथा इसके लिए अन्‍नबलि तथा उनकी पेय बलियां. ");
INSERT INTO hincv_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘आठवें दिन तुम एक पवित्र सभा आयोजित करोगे. इस दिन तुम कोई भी मेहनत न करोगे. ");
INSERT INTO hincv_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","किंतु तुम होमबलि, आग के द्वारा भेंट बलि चढ़ाओगे, जो याहवेह के लिए सुखद-सुगंध होगी: एक बछड़ा, एक मेढ़ा, एक वर्ष के, निर्दोष सात मेमने. ");
INSERT INTO hincv_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","बछड़े, मेढ़े तथा मेमनों के साथ उनकी संख्या के अनुसार उनकी अन्‍नबलि तथा उनकी पेय बलि. ");
INSERT INTO hincv_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","नियमित होमबलि तथा अन्‍नबलि तथा पेय बलि के अलावा एक बकरा पापबलि के लिए चढ़ाया जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘ठहराए गए अवसरों पर तुम ये सब याहवेह के सामने प्रस्तुत करोगे. तुम्हारी संकल्प की गई तथा स्वेच्छा बलियों के अलावा तुम्हारी होमबलियां, अग्निबलियां, पेय बलियां तथा मेल बलियां भी चढ़ाना होंगे.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","मोशेह ने यह सब याहवेह द्वारा उन्हें दी गई आज्ञा के अनुसार इस्राएल के घराने पर प्रकट कर दिया. ");
INSERT INTO hincv_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","इसके बाद मोशेह इस्राएलियों के गोत्रों के प्रधानों के सामने आए और उन्होंने उनसे कहा: “याहवेह द्वारा दी गई आज्ञा यह है: ");
INSERT INTO hincv_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","यदि कोई व्यक्ति याहवेह के लिए कोई संकल्प लेता है, अथवा वह स्वयं को शपथ लेकर किसी ज़रूरी वाचा से बांध लेता है, वह अपनी शपथ को नहीं तोड़ेगा. वह अपने मुख से बोले हुए वचनों के अनुसार करेगा. ");
INSERT INTO hincv_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“यदि कोई स्त्री याहवेह के लिए संकल्प करती है, वह युवावस्था में अपने पिता के घर में ही निवास करते हुए स्वयं को ज़रूरी वाचा में बांध लेती है, ");
INSERT INTO hincv_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","और उसका पिता उसके इस संकल्प और वाचा को सुन लेता है, जिसमें उसने स्वयं को बांध लिया है. उसके पिता को इस विषय में कोई आपत्ति नहीं होती, तब उसके सारे संकल्प मान्य रहेंगे, तथा वे सारी वाचाएं स्थायी हो जाएंगी. ");
INSERT INTO hincv_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","किंतु यदि उसका पिता इन संकल्पों को सुनकर उन्हें मना कर देता है, जैसे ही वह इन संकल्पों की सुनता है, उसका कोई भी संकल्प, जिसे उसने वाचा में बांधकर रखा है, प्रभावी न रह जाएगा; याहवेह भी उसे क्षमा कर देंगे क्योंकि उसके पिता ने उसे इनके विषय में मना कर दिया था. ");
INSERT INTO hincv_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“फिर भी, यदि उसके द्वारा लिया गया संकल्प एवं सोच-विचार बिना कहे गए वचन में सीमित स्थिति में ही उसे विवाह करना पड़ जाता है, ");
INSERT INTO hincv_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","और उसके पति को इस बात का पता चल जाता है, किंतु उस अवसर पर यह सुनने पर भी उसकी ओर से कोई प्रतिक्रिया नहीं होती है, तब उसके द्वारा किए गए संकल्प तथा वाचा स्थिर बने रहेंगे, जिनमें उसने स्वयं को बांधा हुआ है. ");
INSERT INTO hincv_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","किंतु यदि उस अवसर पर उसके पति को इसका पता चल जाता है, वह अपनी पत्नी को इस विषय में मना कर देता है, तब वह अपनी पत्नी के संकल्प को खत्म कर देगा, जिसमें उसने स्वयं को बांध लिया था, जो उसके द्वारा बिना सोचे समझे कहा गया वचन था. याहवेह उसे इस विषय में क्षमा कर देंगे. ");
INSERT INTO hincv_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“किंतु, यदि संकल्प किसी विधवा या किसी तलाकशुदा स्त्री द्वारा किया गया है, तो उसने जितने भी संकल्पों और मन्‍नतों में बांधी हुई रहेगी, ");
INSERT INTO hincv_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“किंतु यदि वह विवाहित स्थिति में अपने पति के आवास में ही है, और उसने संकल्प किए है, शपथ ली हुईं है, ");
INSERT INTO hincv_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","और उसके पति को इसका पता चल चुका है, किंतु उसने इस पर उससे कुछ भी नहीं किया, उसने उसे इस विषय में कुछ मना भी नहीं किया, तब उसके सारे संकल्प सदा बने रहेंगे, तथा उसकी वे सभी वाचाएं जिनमें उसने स्वयं को बांधकर रखा था, सदा बने रहेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","किंतु यदि उसका पति इन्हें सुनते ही इन्हें खत्म कर देता है, तब उस स्त्री के द्वारा लिया गया संकल्प एवं उसके द्वारा स्वयं पर लगाई हुई वाचा खत्म हो जाएंगी; उसके पति द्वारा वे खत्म कर दिए गए हैं. याहवेह उन्हें क्षमा कर देंगे. ");
INSERT INTO hincv_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","हर एक संकल्प तथा हर एक वाचा जो उसने स्वयं को विनम्र रखने के लिए शुरू की है, उसके पति के द्वारा सदा के लिए रखा जा सकता है, या खत्म किया जा सकता है. ");
INSERT INTO hincv_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","किंतु यदि वास्तव में उसका पति दैनिक जीवन में इसका वर्णन ही नहीं करता है, तब इसके द्वारा पति अपनी पत्नी से किए गए संकल्पों एवं वाचाओं की पुष्टि करता है, जो उसने जवाबदारी के रूप में स्वयं पर लागू किए हुए हैं. उसने इस विषय का ज्ञान होने पर भी अपनी कोई भी प्रतिक्रिया ज़ाहिर नहीं की है. इसलिये यह उसके द्वारा की गई पुष्टि होगी. ");
INSERT INTO hincv_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","किंतु यदि उसने यह सुनने के बाद, इन्हें तोड़ दिया हो, तो वही अपनी पत्नी के दोष का भार उठाएगा.” ");
INSERT INTO hincv_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ये वे विधियां हैं, जो याहवेह द्वारा मोशेह को दी गई हैं, जिनका संबंध पति-पत्नी के पारस्परिक संबंध से, तथा पिता-पुत्री के पारस्परिक संबंध से है, जब पुत्री युवावस्था तक पिता के घर पर रह रही होती है. ");
INSERT INTO hincv_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","फिर मोशेह के लिए याहवेह का आज्ञा थी, ");
INSERT INTO hincv_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“मिदियानियों से इस्राएलियों का पूरा बदला ले डालो, इसके बाद तुम अपने पूर्वजों में मिला लिए जाओगे.” ");
INSERT INTO hincv_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","मोशेह ने लोगों को आज्ञा दी, “अपने बीच लोगों को युद्ध के लिए तैयार करो, कि वे मिदियान पर आक्रमण कर मिदियान पर याहवेह का बदला पूरा करें. ");
INSERT INTO hincv_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","इस्राएल के सारे गोत्रों से हर एक कुल में से एक-एक हज़ार को तुम युद्ध के लिए भेजोगे.” ");
INSERT INTO hincv_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","इसलिये सारी इस्राएली प्रजा में से हर एक गोत्र से एक-एक हज़ार योद्धा भर्ती किए गए; बारह हज़ार युद्ध के लिए तैयार योद्धा. ");
INSERT INTO hincv_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","मोशेह ने इन्हें हर एक गोत्र से एक-एक हज़ार योद्धा को युद्ध के लिए भेज दिया. पुरोहित एलिएज़र का पुत्र फिनिहास युद्ध के लिए इनके साथ था. वह अपने हाथ में पवित्र पात्र एवं तुरहियां लिए हुए था कि इनसे चेतावनी नाद किया जा सके. ");
INSERT INTO hincv_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","उन्होंने याहवेह द्वारा मोशेह को दिखाए गए आदेश के अनुसार मिदियान पर आक्रमण कर दिया तथा हर एक पुरुष की हत्या कर दी. ");
INSERT INTO hincv_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","उन्होंने अन्य लोगों के साथ मिदियान के इन पांच राजाओं का भी वध कर दिया: एवी, रेकेम, ज़ुर, हूर, तथा रेबा. इनके अलावा इस्राएलियों ने बेओर के पुत्र बिलआम का वध भी तलवार से कर दिया. ");
INSERT INTO hincv_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","इस्राएलियों ने मिदियानी स्त्रियों एवं बालकों को तथा पशुओं एवं भेड़ों को बंदी बनाकर उनकी सारी सामग्री लूट ली. ");
INSERT INTO hincv_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","इसके बाद उन्होंने उनके द्वारा बसाए गए सभी नगरों को जला दिया तथा उनके शिविरों को आग में झोंक दिया. ");
INSERT INTO hincv_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","तब उन्होंने लूट की सारी सामग्री, सारे बंदी मनुष्यों तथा पशुओं को ले जाकर ");
INSERT INTO hincv_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","मोशेह, पुरोहित एलिएज़र तथा इस्राएलियों की सारी सभा के सामने इन बंदियों, पशुओं तथा लूट की सामग्री को प्रस्तुत कर दिया. वे इस अवसर पर मोआब के मैदानों में डेरे डाले हुए थे, जो येरीख़ो के सामने यरदन नदी के तट पर हैं. ");
INSERT INTO hincv_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","उनसे भेंट करने के उद्देश्य से मोशेह, पुरोहित एलिएज़र तथा सभा के सारे प्रधान शिविर के बाहर निकल आए. ");
INSERT INTO hincv_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","मोशेह सैन्य अधिकारियों से अप्रसन्‍न थे—वे जो हज़ारों पर तथा सैकड़ों पर नियुक्त किए गए थे—जो युद्ध से लौट रहे थे. ");
INSERT INTO hincv_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","मोशेह ने उनसे प्रश्न किया, “क्या तुमने सभी स्त्रियों को जीवित छोड़ दिया है? ");
INSERT INTO hincv_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ये ही तो थीं वे, जिन्होंने पेओर में बिलआम की सलाह पर इस्राएलियों को याहवेह के विरुद्ध बलवा के लिए उकसाया था, जिसके कारण याहवेह की सभा में महामारी फैल गई थीं. ");
INSERT INTO hincv_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","इसलिये अब हर एक बालक का वध कर डालो तथा हर एक विवाहित स्त्री का भी. ");
INSERT INTO hincv_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","हां, उन कन्याओं को अपने लिए जीवित छोड़ देना, जिनका किसी पुरुष से यौन संपर्क नहीं हुआ है. ");
INSERT INTO hincv_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“सात दिन शिविर के बाहर डेरा डालना ज़रूरी है. जिस किसी ने किसी व्यक्ति का वध किया है, जिस किसी ने किसी मरे हुए व्यक्ति को छुआ है, स्वयं को तथा अपने बंदियों को तीसरे एवं सातवें दिन पवित्र करे. ");
INSERT INTO hincv_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","तुम स्वयं को, हर एक वस्त्र को, हर एक चमड़े की वस्तु को, बकरे के रोम से बनी वस्तुओं को तथा लकड़ी की सभी वस्तुओं को पवित्र करोगे.” ");
INSERT INTO hincv_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","फिर पुरोहित एलिएज़र ने उन्हें जो युद्ध कर लौटे थे, संबोधित करते हुए कहा, “याहवेह द्वारा मोशेह को दी गई आज्ञा यह है: ");
INSERT INTO hincv_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","सिर्फ सोना, चांदी, कांसा, लोहा, रांगा तथा सीसा, ");
INSERT INTO hincv_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","हर एक वस्तु, जिसे आग में से होकर निकाला जा सकता है, तुम आग में से निकालोगे कि वह शुद्ध हो जाए, किंतु जो वस्तु आग में से निकाली नहीं जा सकती, उनको पवित्र करने के लिए तुम इन्हें जल से शुद्ध करोगे. ");
INSERT INTO hincv_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","पवित्र करने के लिए तुम सातवें दिन अपने वस्त्रों को धोओगे, इसके बाद तुम शिविरों में प्रवेश कर सकते हो.” ");
INSERT INTO hincv_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“तुम, पुरोहित एलिएज़र तथा प्रजा में गोत्रों के प्रधान सारे लूट के सामान की गिनती करें, चाहे ये मनुष्य हों अथवा पशु. ");
INSERT INTO hincv_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","तब सारी लूट की सामग्री का बंटवारा युद्ध में गए योद्धाओं तथा सारी सभा के बीच कर दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","योद्धाओं पर याहवेह के लिए कर ठहराया जाए, जो युद्ध में गए थे, पांच सौ व्यक्तियों तथा पशुओं, गधों तथा भेड़ों के लिए एक-एक प्राणी अलग रखते जाना. ");
INSERT INTO hincv_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","इसे उनके आधे भाग के दसवें अंश से लेकर याहवेह को चढ़ाने के उद्देश्य से पुरोहित एलिएज़र को दे देना. ");
INSERT INTO hincv_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","इस्राएलियों के आधे भाग के दसवें अंश से हर एक पचास व्यक्तियों, पशुओं, गधों, भेड़ों, सभी पशुओं में से एक-एक लेकर उन लेवियों को सौंप देना, जो याहवेह के साक्षी तंबू के अधिकारी हैं.” ");
INSERT INTO hincv_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","मोशेह तथा पुरोहित एलिएज़र ने मोशेह को दी गई याहवेह की आज्ञा का पूरा-पूरा पालन किया. ");
INSERT INTO hincv_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","सैनिकों द्वारा लूटी गई सामग्री में से शेष यह था: 6,75,000 भेड़ें, ");
INSERT INTO hincv_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72,000 पशु, ");
INSERT INTO hincv_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61,000 गधे ");
INSERT INTO hincv_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","तथा 32,000 स्त्रियां जिनका किसी पुरुष से यौन संपर्क नहीं हुआ था. ");
INSERT INTO hincv_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","वे, जो युद्ध पर गए थे, उनके आधे का दसवां अंश इस प्रकार था: भेड़ों की संख्या 3,37,500, ");
INSERT INTO hincv_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","इनमें से याहवेह के लिए निकाली भेड़ें 675; ");
INSERT INTO hincv_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","पशुओं की संख्या 36,000 जिनमें से याहवेह का भाग था 72; ");
INSERT INTO hincv_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","गधों की संख्या 30,500 थी, जिनमें याहवेह का भाग था 61; ");
INSERT INTO hincv_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","इनमें मनुष्य प्राणी थे 16,000, जिनमें याहवेह का ठहराया गया भाग था 32. ");
INSERT INTO hincv_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","मोशेह ने पुरोहित एलिएज़र को याहवेह के लिए ठहराया भाग सौंप दिया, ठीक जैसी याहवेह की आज्ञा थी. ");
INSERT INTO hincv_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","मोशेह ने जिन इस्राएलियों को, जो युद्ध से लौटे थे, उनके आधे भाग के दसवें अंश के संबंध में: ");
INSERT INTO hincv_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","सारी इस्राएली सभा के आधे भाग का दसवां अंश था 3,37,500 भेड़ें, ");
INSERT INTO hincv_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 पशु, ");
INSERT INTO hincv_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 गधे ");
INSERT INTO hincv_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","तथा मानव प्राणी थे 16,000. ");
INSERT INTO hincv_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","तथा इस्राएलियों के आधे भाग के दसवें अंश में से, मोशेह ने हर एक पचास में से, चाहे मनुष्य हों अथवा पशु, लेकर उन लेवियों को सौंप दिया, जो याहवेह के साक्षी तंबू के अधिकारी थे, ठीक जैसा मोशेह को याहवेह ने आज्ञा दी थी. ");
INSERT INTO hincv_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","फिर वे अधिकारी—हज़ारों के सेनापति, सैकड़ों के प्रधान—मोशेह के पास आए. ");
INSERT INTO hincv_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","उन्होंने मोशेह से विनती की, “आपके सेवकों ने हमें सौंपे गए योद्धाओं की गिनती कर ली है. कोई भी व्यक्ति छूट नहीं रहा. ");
INSERT INTO hincv_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","इसलिये हममें से हर एक व्यक्ति याहवेह को भेंट करने के लिए सोने के गहने-बाजूबंद, कंगन, अंगूठियां, कर्णफूल, गले के हार लेकर आया है, जैसा जैसा जिसे प्राप्‍त हुआ है कि हम याहवेह के सामने अपने लिए प्रायश्चित कर सकें.” ");
INSERT INTO hincv_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","मोशेह तथा पुरोहित एलिएज़र ने उनसे ये सोने के गहने इकट्‍ठे कर लिए, जो उनके द्वारा लाए गए थे. ");
INSERT INTO hincv_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","भेंट में दिए गए सारे गहनों का तौल, जो उन्होंने याहवेह को चढ़ाया था, जो हज़ारों तथा सैकड़ों के अधिकारियों द्वारा प्राप्‍त हुआ था, 16,750 शेकेल हुआ. ");
INSERT INTO hincv_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","योद्धाओं ने अपने लिए लूट सामग्री इकट्ठी कर ली थी. ");
INSERT INTO hincv_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","मोशेह तथा पुरोहित एलिएज़र ने, हज़ारों एवं सैंकड़ों पर चुने हुए अधिकारियों से सोने के गहने स्वीकार कर लिए तथा इन्हें मिलनवाले तंबू पर ले गए, कि यह याहवेह के सामने इस्राएलियों के लिए चिन्ह हो जाए. ");
INSERT INTO hincv_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","इस समय तक रियूबेन तथा गाद के वंशजों का पशु धन बहुत विशाल संख्या में हो चुका था. फिर जब उन्होंने याज़र देश तथा गिलआद देश का विचार किया, तो उन्होंने इसे हर एक रीति से पशु धन के लिए उपयुक्त पाया. ");
INSERT INTO hincv_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","रियूबेन के वंशज तथा गाद के वंशज मोशेह, पुरोहित एलिएज़र तथा सभा के प्रधानों के पास अपनी विनती ले पहुंच गए. ");
INSERT INTO hincv_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“अतारोथ, दीबोन, याज़र, निमराह, हेशबोन, एलिआलेह, सेबाम, नेबो तथा बेओन, ");
INSERT INTO hincv_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","वह देश, जिसे याहवेह ने इस्राएली सभा के लिए हरा दिया है, पशु धन के लिए अच्छा है और हम, आपके सेवक पशुधनधारी हैं.” ");
INSERT INTO hincv_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","तब उन्होंने यह भी कहा, “यदि हम पर आपकी कृपादृष्टि बनी है, हम, आपके सेवकों को यह भूमि का भाग दे दिया जाए; हमें अपने साथ यरदन के पार न ले जाइए.” ");
INSERT INTO hincv_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","किंतु मोशेह ने इनकार किया, “कैसे संभव है कि तुम्हारे भाई तो युद्ध में जाएंगे और तुम लोग यहां आराम से बैठे रहोगे? ");
INSERT INTO hincv_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","तुम लोग यहीं इस्राएलियों को याहवेह द्वारा दिए गए देश के लिए यरदन पार करने में हतोत्साहित क्यों कर रहे हो? ");
INSERT INTO hincv_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","तुम्हारे पूर्वजों ने भी उस अवसर पर यही किया था, जब मैंने उन्हें कादेश-बरनेअ से उस देश का भेद लेने के उद्देश्य से भेजा था. ");
INSERT INTO hincv_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","वे एशकोल घाटी में थे और वहां से उन्होंने उस देश को देखा, लौटकर उन्होंने इस्राएलियों को हतोत्साहित कर दिया, कि वे उस देश में प्रवेश न करें, जो उन्हें याहवेह द्वारा दिया जा चुका था. ");
INSERT INTO hincv_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","परिणाम यह हुआ कि उस दिन याहवेह का क्रोध भड़क उठा और उन्होंने यह शपथ ले ली: ");
INSERT INTO hincv_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘मिस्र देश से निकलकर आए बीस वर्ष तथा इससे अधिक आयु का कोई भी व्यक्ति उस देश का दर्शन ही न कर पाएगा जिसे देने के शपथ मैंने अब्राहाम, यित्सहाक तथा याकोब से की थी; क्योंकि उन्होंने पूरी तरह से मेरा अनुसरण नहीं किया; ");
INSERT INTO hincv_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","सिर्फ कनिज्ज़ी येफुन्‍नेह के पुत्र कालेब, तथा नून के पुत्र यहोशू के सिवाय, क्योंकि ये दो ही याहवेह का अनुसरण करने में ईमानदार बने रहे थे.’ ");
INSERT INTO hincv_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","याहवेह का क्रोध इस्राएल पर भड़क उठा और उन्होंने उन्हें निर्जन प्रदेश में चालीस वर्षों तक भटकते रहने के लिए छोड़ दिया, कि वह सारी पीढ़ी, जिन्होंने याहवेह के विरुद्ध यह बुराई की थी, नाश हो जाए. ");
INSERT INTO hincv_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“अब देख लो, तुम लोग पापियों की संतान होकर अपने-अपने पूर्वजों के समान व्यवहार कर रहे हो, कि याहवेह के भड़के हुए क्रोध को इस्राएल के विरुद्ध और अधिक भड़का सको. ");
INSERT INTO hincv_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","क्योंकि यदि तुम रियूबेन और गाद के वंशजों का अनुसरण करना छोड़ दोगे, तो वह एक बार फिर उन्हें निर्जन प्रदेश में अकेला छोड़ देंगे और तुम दोनों इन सब लोगों को नाश कर दोगे.” ");
INSERT INTO hincv_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","तब वे मोशेह की उपस्थिति में आकर कहने लगे, “हम यहां अपने पशु धन के लिए भेड़शालाओं का तथा अपनी संतान के लिए नगर बनाएंगे. ");
INSERT INTO hincv_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","किंतु स्वयं हम इस्राएलियों के आगे-आगे युद्ध के लिए शस्त्रों से तैयार हो जाया करेंगे, जब तक हम उन्हें उस देश में न पहुंचा दें, जबकि हमारी संतान इस देश के वासियों के कारण गढ़ नगरों में निवास कर रही होगी. ");
INSERT INTO hincv_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","हम उस समय तक अपने-अपने घरों में नहीं लौटेंगे, जब तक हर एक इस्राएली अपने-अपने भाग के अधिकार को प्राप्‍त नहीं कर लेता है. ");
INSERT INTO hincv_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","क्योंकि हम यरदन के उस पार तथा उससे भी दूर तक किसी भी भाग के अधिकार का दावा नहीं करेंगे, क्योंकि हमारा उत्तराधिकार हमें यरदन के इसी ओर, पूर्व दिशा में मिल चुका है.” ");
INSERT INTO hincv_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","यह सुन मोशेह ने उत्तर दिया, “यदि तुम यही करोगे; तुम याहवेह के सामने स्वयं को युद्ध के लिए तैयार कर लोगे, ");
INSERT INTO hincv_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","तुम सभी युद्ध के लिए सशस्त्र योद्धा याहवेह के सामने यरदन नदी पार करोगे, जब तक तुम याहवेह के सामने से उनके शत्रुओं को खदेड़ न दोगे, ");
INSERT INTO hincv_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","तथा वह देश याहवेह के सामने अधीन न हो जाए; यह पूरा हो जाने के बाद ही तुम लौट सकोगे, तथा याहवेह एवं इस्राएल के प्रति इस वाचा से छूट जाओगे और यह देश याहवेह के सामने तुम्हारा निज भाग हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“किंतु यदि तुम ऐसा न करो, तो देख लेना, तुम याहवेह के प्रति पाप कर चुके होगे; यह तय समझो कि तुम्हारा पाप ही तुम्हें पकड़वा देगा. ");
INSERT INTO hincv_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","अपनी संतान के लिए नगरों का निर्माण करो, भेड़ों के लिए भेड़-शालाएं भी तथा वही करो, जिसकी प्रतिज्ञा तुमने की है.” ");
INSERT INTO hincv_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","गाद एवं रियूबेन के वंशजों ने मोशेह से कहा, “आपके सेवक ठीक वही करेंगे, जैसा आदेश हमारे स्वामी देंगे. ");
INSERT INTO hincv_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","हमारी संतान, हमारी पत्नियां, हमारा पशु धन तथा हमारे सारे पशु गिलआद के इन्हीं नगरों में रह जाएंगे. ");
INSERT INTO hincv_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","जब आपके सेवक, हर एक, जो युद्ध के लिए तैयार है, युद्ध के लिए याहवेह के सामने इस नदी के पार जाएगा-ठीक जैसा हमारे स्वामी का आदेश है.” ");
INSERT INTO hincv_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","तब मोशेह ने इनके विषय में पुरोहित एलिएज़र तथा नून के पुत्र यहोशू तथा इस्राएलियों के गोत्रों के प्रधानों को आदेश दिया. ");
INSERT INTO hincv_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","मोशेह ने उनसे कहा, “यदि गाद एवं रियूबेन के ये वंशज, हर एक, जो युद्ध के लिए तैयार है, याहवेह के सामने यरदन नदी को पार करेगा तथा वह देश तुम्हारे वश में कर दिया जाता है, तब तुम उन्हें स्वामित्व के लिए गिलआद प्रदान कर दोगे. ");
INSERT INTO hincv_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","किंतु यदि वे शस्त्रों से तैयार हो तुम्हारे साथ नदी के पार न जाएं, तब उन्हें कनान देश में ही तुम्हारे बीच भूमि बांटी जाएगी.” ");
INSERT INTO hincv_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","गाद एवं रियूबेन के वंशजों ने उत्तर दिया, “आपके इन सेवकों को याहवेह ने जैसा आदेश दिया है, हम ठीक वैसा ही करेंगे. ");
INSERT INTO hincv_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","हम स्वयं याहवेह की उपस्थिति में सशस्त्र कनान देश में प्रवेश करेंगे तथा हमारी निज भूमि हमारे लिए यरदन के इसी पार रहेगी.” ");
INSERT INTO hincv_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","इसलिये मोशेह ने गाद, रियूबेन तथा योसेफ़ के पुत्र मनश्शेह के आधे गोत्र को अमोरियों के राजा सीहोन तथा बाशान के राजा ओग का राज्य, सारे देश इनके नगर तथा इनकी सीमाएं तथा निकटवर्ती देशों के नगर दे दिए. ");
INSERT INTO hincv_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","गाद के वंशजों ने दीबोन, अतारोथ, अरोअर, ");
INSERT INTO hincv_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","अतारोथ-षोपान, याज़र, योगबेहाह ");
INSERT INTO hincv_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","बेथ-निमराह तथा बेथ-हारान को गढ़ नगरों के रूप में बना दिया, साथ ही भेड़ों के लिए भेड़-शालाएं भी बना दीं. ");
INSERT INTO hincv_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","रियूबेन के वंशजों ने हेशबोन, एलिआलेह, किरयथाईम, ");
INSERT INTO hincv_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","नेबो, बाल-मेओन (इन नामों को बदल दिया गया) और सिबमाह नगर बसाए. उन नगरों को उन्होंने नए नाम दिए, जिनका वे निर्माण करते रहे थे. ");
INSERT INTO hincv_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","मनश्शेह के पुत्र माखीर के वंशजों ने गिलआद जाकर उस पर अधिकार कर लिया और उसमें रह रहे अमोरियों को वहां से निकाल दिया. ");
INSERT INTO hincv_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","तब मोशेह ने गिलआद को मनश्शेह के पुत्र माखीर के नाम कर दिया और वे वहां बस गए. ");
INSERT INTO hincv_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","मनश्शेह के पुत्र याईर ने जाकर इस क्षेत्र के नगरों पर अधिकार कर लिया और उन्हें हव्वोथ-याईर नाम दे दिया. ");
INSERT INTO hincv_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","नोबाह ने जाकर केनाथ तथा इसके गांवों पर अधिकार करके उसे अपना ही नाम, नोबाह, दे दिया. ");
INSERT INTO hincv_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","यह उस यात्रा का वर्णन है, जो इस्राएलियों द्वारा मिस्र देश से निकलकर उनकी सेना के द्वारा मोशेह तथा अहरोन के नेतृत्व में की गई थी. ");
INSERT INTO hincv_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","याहवेह के आदेश पर मोशेह ने उनकी यात्रा के प्रारंभिक स्थानों का लेखा रखा था. ये यात्राएं उनके प्रारंभिक स्थानों के अनुसार लिख दी गई हैं: ");
INSERT INTO hincv_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","उन्होंने पहले महीने की पन्द्रहवीं तारीख पर रामेसेस से अपनी यात्रा शुरू की. दूसरे दिन, फ़सह उत्सव के बाद इस्राएलियों ने सारे मिस्रवासियों के देखते-देखते बड़ी निडरता से कूच कर दिया. ");
INSERT INTO hincv_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","इस समय मिस्रवासी याहवेह द्वारा मारे गए अपने सारे पहलौंठों को मिट्टी देने में व्यस्त थे; याहवेह ने मिस्रवासियों के देवताओं पर भी दंड दिए थे. ");
INSERT INTO hincv_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","इसके बाद इस्राएलियों ने रामेसेस से यात्रा शुरू कर सुक्कोथ में अपने डेरे डाले. ");
INSERT INTO hincv_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","उन्होंने सुक्कोथ से यात्रा की और एथाम में डेरे डाले, यह स्थान निर्जन प्रदेश की सीमा से लगा हुआ है. ");
INSERT INTO hincv_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","उन्होंने एथाम से यात्रा शुरू की और पी-हाहीरोथ की दिशा में लौटे, जो बाल-जेफोन के सामने है. उन्होंने मिगदोल में डेरे डाले. ");
INSERT INTO hincv_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","उन्होंने पी-हाहीरोथ से यात्रा शुरू की और लाल सागर से होते हुए निर्जन प्रदेश में जा पहुंचे, और उन्होंने एथाम के निर्जन प्रदेश में तीन दिन की यात्रा की और माराह में डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","माराह से यात्रा शुरू कर वे एलिम पहुंचे. एलिम में बारह जल के सोते तथा सत्तर खजूर के पेड़ थे. उन्होंने वहीं डेरा डाल दिया. ");
INSERT INTO hincv_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","एलिम से यात्रा शुरू कर उन्होंने लाल सागर तट पर डेरे डाले. ");
INSERT INTO hincv_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","लाल सागर तट से यात्रा शुरू कर उन्होंने सिन के निर्जन प्रदेश में डेरे डाले. ");
INSERT INTO hincv_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","सिन के निर्जन प्रदेश से कूच कर उन्होंने दोफकाह में डेरे डाले. ");
INSERT INTO hincv_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","दोफकाह से यात्रा शुरू कर उन्होंने अलूष में डेरे डाले. ");
INSERT INTO hincv_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","अलूष से यात्रा शुरू कर उन्होंने रेफीदीम में डेरे डाले. यही वह स्थान था, जहां उनके लिए पीने का पानी उपलब्ध न था. ");
INSERT INTO hincv_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","उन्होंने रेफीदीम से यात्रा शुरू कर सीनायी के निर्जन प्रदेश में डेरे डाले. ");
INSERT INTO hincv_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","उन्होंने सीनायी के निर्जन प्रदेश से यात्रा शुरू की और किबरोथ-हत्ताआवह में डेरे डाले. ");
INSERT INTO hincv_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","उन्होंने किबरोथ-हत्ताआवह से यात्रा शुरू की और हाज़ोरौथ में डेरे डाले. ");
INSERT INTO hincv_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","उन्होंने हाज़ोरौथ से यात्रा शुरू की तथा रिथमाह में डेरे डाले. ");
INSERT INTO hincv_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","उन्होंने रिथमाह से यात्रा शुरू की और रिम्मोन-पेरेज़ में डेरे डाले. ");
INSERT INTO hincv_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","उन्होंने रिम्मोन-पेरेज़ से यात्रा शुरू की और लिबनाह में डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","लिबनाह से यात्रा शुरू कर उन्होंने रिस्साह पहुंचकर वहां डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","रिस्साह से यात्रा शुरू कर उन्होंने केहेलाथाह पहुंचकर डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","उन्होंने केहेलाथाह से कूच किया, यात्रा करते हुए शेफर पर्वत पहुंचकर वहां डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","शेफर पर्वत से यात्रा शुरू कर हारादाह पहुंचे, और वहां उन्होंने डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","उन्होंने हारादाह से यात्रा शुरू की, और मखेलौथ पहुंचकर डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","उन्होंने मखेलौथ से यात्रा शुरू की और ताहाथ पहुंचकर डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","उन्होंने ताहाथ से यात्रा शुरू की और तेराह पहुंचकर डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","उन्होंने तेराह से यात्रा शुरू की और मितखाह पहुंचकर डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","उन्होंने मितखाह से यात्रा शुरू की और हाषमोनाथ पहुंचकर डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","हाषमोनाथ से यात्रा शुरू कर वे मोसेराह पहुंचे, और वहां उन्होंने डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","मोसेराह से यात्रा शुरू कर उन्होंने बेने-जाआकन पहुंचकर डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","उन्होंने बेने-जाआकन से यात्रा शुरू कर होर-हग्गीदगाद पहुंचकर डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","उन्होंने होर-हग्गीदगाद से कूच कर योतबाथाह पहुंचकर डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","उन्होंने योतबाथाह से यात्रा शुरू की और आबरोनाह पहुंचकर डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","उन्होंने आबरोनाह से यात्रा शुरू की और एज़िओन-गेबेर में डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","उन्होंने एज़िओन-गेबेर से यात्रा शुरू की और ज़िन के निर्जन प्रदेश अर्थात् कादेश में पहुंचकर डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","उन्होंने कादेश से यात्रा शुरू की और होर पर्वत पहुंचकर वहां डेरे डाल दिए. यह स्थान एदोम की सीमा पर है. ");
INSERT INTO hincv_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","इसके बाद पुरोहित अहरोन याहवेह के आदेश पर होर पर्वत पर चढ़ गया और वहीं उसकी मृत्यु हो गई. यह इस्राएलियों के मिस्र देश से निकलने का चालीसवां वर्ष था. यह पांचवें महीने की पहली तारीख थी. ");
INSERT INTO hincv_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","अहरोन की आयु इस अवसर पर एक सौ तेईस वर्ष थी, जब होर पर्वत पर उसकी मृत्यु हुई. ");
INSERT INTO hincv_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","इसी समय कनान देश के नेगेव में कनानी राजा अराद को यह मालूम हो चुका था कि इस्राएली इस दिशा में आ रहे हैं. ");
INSERT INTO hincv_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","फिर उन्होंने होर पर्वत से प्रस्थान किया, और ज़ालमोनाह में डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","उन्होंने ज़ालमोनाह से यात्रा शुरू की और पुनोन में डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","उन्होंने पुनोन से यात्रा शुरू की और ओबोथ में डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ओबोथ से यात्रा शुरू कर उन्होंने मोआब देश की सीमा पर स्थित स्थान इये-आबारिम पर डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","इय्यीम-आबारिम से कूच कर उन्होंने दीबोन-गाद में डेरे डाले. ");
INSERT INTO hincv_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","दीबोन-गाद से यात्रा शुरू कर उन्होंने आलमोन-दिबलाथाइम में डेरे डाले. ");
INSERT INTO hincv_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","आलमोन-दिबलाथाइम से यात्रा शुरू कर उन्होंने नेबो के पास वाले अबारिम पर्वतों के पास डेरा डाला. ");
INSERT INTO hincv_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","अबारिम पर्वतों से कूच कर येरीख़ो के सामने मोआब में यरदन के मैदानों में डेरे डाल दिए. ");
INSERT INTO hincv_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","मोआब के मैदानों में उन्होंने यरदन तट पर डेरे डाले थे, जिसका फैलाव बेथ-यशिमोथ से लेकर आबेल-शित्तिम तक था. ");
INSERT INTO hincv_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","फिर याहवेह यरदन तट पर येरीख़ो के सामने मोआब के मैदानों में मोशेह के सामने आए और उनसे यह बातें की: ");
INSERT INTO hincv_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“इस्राएलियों पर यह स्पष्ट कर दो, ‘जब तुम यरदन पार कर कनान देश में प्रवेश करोगे, ");
INSERT INTO hincv_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","तुम अपने सामने आए हर एक कनानवासी को खदेड़ दोगे, उनकी ढाली हुई सारी धातु की मूर्तियों को नष्ट कर दोगे तथा उनके सभी पूजा स्थलों को भी. ");
INSERT INTO hincv_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","तुम इस देश को अधिकार में करके इसमें बस जाओगे; क्योंकि यह देश मैंने तुम्हें अधिकार करने के लक्ष्य से दिया है. ");
INSERT INTO hincv_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","तुम अपने-अपने परिवारों के अनुसार पासा फेंक देश को बांट लेना. बड़े गोत्र को भूमि का बड़ा भाग तथा छोटे को भूमि का छोटा भाग. पासा, जो भी दिखाए वही उसका अंश होगा. तुम्हारा उत्तराधिकार तुम्हारे पितरों के कुलों के अनुसार ही होगा. ");
INSERT INTO hincv_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘किंतु यदि तुम उस देश के निवासियों को वहां से न खदेड़ोगे, तब तो वे, जो वहां रह जाएंगे, तुम्हारी आंखों की किरकिरी तथा तुम्हारे पंजरों में कीलों के समान साबित हो जाएंगे. तब उस देश में, जहां तुम बस जाओगे, वे ही तुम्हारे संकट का कारण साबित होंगे. ");
INSERT INTO hincv_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","जो कुछ मैंने उनके साथ करने का वचन किया है, मैं वही सब तुम्हारे साथ करूंगा.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","इसके बाद याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“तुम इस्राएलियों को यह आदेश दो: ‘जब तुम कनान देश में प्रवेश करो, तो यही वह देश होगा, जो तुम्हारे उत्तराधिकार के लिए ठहराया गया है—हां, कनान देश उसकी सीमाओं सहित: ");
INSERT INTO hincv_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘तुम्हारे देश का दक्षिण क्षेत्र ज़िन के निर्जन प्रदेश से एदोम की सीमा तक पूर्व में लवण-सागर तक होगी. ");
INSERT INTO hincv_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","तब तुम्हारी सीमा मुड़कर दक्षिण से अक्रब्बीम की चढ़ाई की ओर होगी और ज़िन की दिशा में बढ़ती जाएगी और इसका अंत होगा कादेश-बरनेअ का दक्षिण. यह हाज़ार अद्दार पहुंचकर आज़मोन से ");
INSERT INTO hincv_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","मिस्र की नदी की ओर हो जाएगी और सागर तट पर जाकर खत्म हो जाएगी. ");
INSERT INTO hincv_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","पश्चिमी सीमा के विषय में, महासागर अर्थात् इसका सारा तट यही तुम्हारी पश्चिमी सीमा होगी. ");
INSERT INTO hincv_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","तुम्हारी उत्तरी सीमा: तुम अपनी सीमा रेखा भूमध्य-सागर से लेकर होर पर्वत तक डालोगे. ");
INSERT INTO hincv_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","तब तुम होर पर्वत से लबो-हामाथ तक सीमा रेखा डालोगे और सीमा का समापन होगा ज़ेदाद पर. ");
INSERT INTO hincv_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","सीमा रेखा ज़िफरोन की दिशा में आगे बढ़ेगी और इसका समापन होगा हाज़ार-एनान पर; यह होगी तुम्हारी उत्तरी सीमा. ");
INSERT INTO hincv_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","पूर्वी सीमा के लिए तुम हाज़ार-एनान से शेफम तक रेखा डालोगे, ");
INSERT INTO hincv_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","सीमा रेखा शेफम से रिबलाह, जो एइन के पूर्व में है, की दिशा में बढ़ेगी. यह सीमा नीचे की ओर आगे बढ़कर किन्‍नेरेथ झील की ढलान पर पहुंचेगी. ");
INSERT INTO hincv_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","फिर सीमा यरदन की दिशा में जाएगी और लवण-सागर पर जा समाप्‍त हो जाएगी. “ ‘यही होगी हर एक दिशा से सीमाओं के अनुसार तुम्हें दिया गया वह देश.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","फिर मोशेह ने इस्राएलियों को यह आदेश दिया: “यही है, वह देश, जिसका बंटवारा तुम्हें पासा फेंककर अधिकार के लिए करना है, जिसे याहवेह ने साढ़े नौ गोत्रों को देने का आदेश दिया है. ");
INSERT INTO hincv_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","रियूबेन गोत्र के वंशजों ने अपने पितरों के कुलों के अनुसार अपना अंश प्राप्‍त कर लिया है, वैसे ही गाद गोत्र के वंशजों ने और मनश्शेह के आधे गोत्र ने भी अपना अंश प्राप्‍त कर लिया है. ");
INSERT INTO hincv_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","यरदन के इसी ओर, येरीख़ो के सामने भूमि के भाग पर सूर्योदय की दिशा, पूर्व में, इन ढाई गोत्रों ने अपना अपना निर्धारित भाग प्राप्‍त कर लिया है.” ");
INSERT INTO hincv_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“मीरास के रूप में भूमि बांटने के लिए चुने गए व्यक्ति ये हैं: पुरोहित एलिएज़र तथा नून के पुत्र यहोशू. ");
INSERT INTO hincv_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","मीरास बांटने के लिए तुम हर एक गोत्र में से एक प्रधान चुनोगे. ");
INSERT INTO hincv_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“चुने गए व्यक्ति ये हैं: “यूदाह गोत्र से येफुन्‍नेह का पुत्र कालेब; ");
INSERT INTO hincv_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","शिमओन के वंशजों में से अम्मीहूद का पुत्र शमुएल; ");
INSERT INTO hincv_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","बिन्यामिन के वंशजों में से कीसलोन का पुत्र एलिदाद; ");
INSERT INTO hincv_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","दान के वंशजों में से योगली का पुत्र बुक्की प्रधान था; ");
INSERT INTO hincv_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","योसेफ़ के वंशजों में से, मनश्शेह के वंशजों का प्रधान था एफ़ोद का पुत्र हन्‍निएल; ");
INSERT INTO hincv_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","योसेफ़ के पुत्र एफ्राईम के गोत्र में से नेता शिफतन के पुत्र केमुएल थे; ");
INSERT INTO hincv_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","एफ्राईम के वंशजों में से प्रधान था पारनाख का पुत्र एलिज़ाफ़ान; ");
INSERT INTO hincv_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","इस्साखार के वंशजों में से चुना गया प्रधान था, अज्जान का पुत्र पालतिएल; ");
INSERT INTO hincv_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","आशेर के वंशजों से चुना गया प्रधान था शेलोमी का पुत्र अहीहूद; ");
INSERT INTO hincv_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","नफताली के वंशजों में से चुना गया प्रधान था अम्मीहूद का पुत्र पेदेहेल.” ");
INSERT INTO hincv_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ये सब वे हैं, जिन्हें इस्राएलियों को कनान देश में मीरास की भूमि बांटने का आदेश दिया गया था. ");
INSERT INTO hincv_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","इसके बाद याहवेह ने मोआब के मैदानों में येरीख़ो के सामने मोशेह को ये निर्देश दिए, ");
INSERT INTO hincv_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“इस्राएलियों को यह आदेश दे देना कि वे अपनी मीरास में से अपने निज भाग की भूमि में से लेवियों को दे दें, कि वे उनमें रह सकें. तुम लेवियों को नगरों के आस-पास चराइयां भी दे दोगे. ");
INSERT INTO hincv_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","वे नगर उनके रहने के लिए हो जाएंगे तथा चराइयां उनके पशुओं, भेड़ों तथा सारे पशुओं के लिए. ");
INSERT INTO hincv_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“वे, चराइयां, जो इन नगरों के चरागाह, जो तुम लेवियों को दे दोगे, उनका फैलाव होगा नगर की दीवार से लेकर बाहर की ओर चारों ओर साढ़े चार सौ मीटर होगा. ");
INSERT INTO hincv_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","तुम नगर के बाहर, उत्तर दिशा में नौ सौ मीटर, दक्षिण दिशा में नौ सौ मीटर, पूर्व दिशा में नौ सौ मीटर, तथा पश्चिम दिशा में नौ सौ मीटर प्रमाण नापोगे, जिससे वह नगर इस पूरे क्षेत्र के बीच में हो जाएगा. यह क्षेत्र उस नगर से संबंधित उनकी चराई हो जाएगा. ");
INSERT INTO hincv_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“वे नगर, जो तुम लेवियों को दे दोगे, छः शरण शहर होंगे, जो तुम उस खूनी के लिए रख दोगे, जो भागकर यहां आएगा. इनके अलावा तुम बयालीस नगर और भी दे दोगे. ");
INSERT INTO hincv_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","लेवियों को दिए गए सारे नगरों की संख्या होगी अड़तालीस; और इनके साथ उनकी चराइयां भी शामिल हैं. ");
INSERT INTO hincv_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","यह ध्यान रहे कि तुम वे नगर, जो इस्राएलियों से लेकर लेवियों को दोगे, बहुत बड़े क्षेत्रफल के कुलों से अधिक नगर तथा छोटे क्षेत्रफल के कुलों से कम नगर बांट दोगे, हर एक गोत्र अपनी-अपनी मीरास के अनुपात में कुछ नगर लेवियों के लिए दान करेगा.” ");
INSERT INTO hincv_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","इसके बाद याहवेह ने मोशेह को आज्ञा दी, ");
INSERT INTO hincv_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“इस्राएलियों से यह कहो: ‘जब तुम यरदन पार कर कनान देश में प्रवेश करोगे, ");
INSERT INTO hincv_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","तब तुम स्वयं वे नगर ठहराना, जो तुम्हारे शरण शहर होंगे, कि जब किसी व्यक्ति द्वारा किसी व्यक्ति की हत्या भूल से हो गई हो, वह भागकर इन नगरों में आ छिपे. ");
INSERT INTO hincv_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ये नगर तुम्हारे लिए पलटा लेनेवाले से सुरक्षा के शरण होंगे, कि सभा के सामने बिना न्याय का कार्य पूरा हुए उस हत्यारे को प्राण-दंड न दे दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","वे नगर, जो तुम इस उद्देश्य से दोगे, तुम्हारे लिए छः शरण शहर नगर लिखे होंगे. ");
INSERT INTO hincv_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","तीन नगर तो तुम यरदन के पार दोगे तथा तीन कनान देश में; ये सभी शरण शहर होंगे. ");
INSERT INTO hincv_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ये छः नगर इस्राएलियों के लिए तथा विदेशी के लिए तथा उनके बीच बसे लोगों के लिए शरण नगर ठहरेंगे, कि वह व्यक्ति, जिससे किसी की हत्या भूल से हो गई है, भागकर यहां शरण ले. ");
INSERT INTO hincv_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘किंतु यदि उसने वार के लिए लोहे का इस्तेमाल किया था, जिससे वह मृत्यु का कारण हो गया, वह व्यक्ति हत्यारा है. हत्यारे का दंड मृत्यु ही है. ");
INSERT INTO hincv_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","यदि उस व्यक्ति ने हाथ में पत्थर लेकर उससे वार किया था, कि उसकी मृत्यु हो जाए और उसकी मृत्यु हो ही गई, वह व्यक्ति हत्यारा है; हत्यारे को निश्चित ही मृत्यु दंड दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","अथवा उसने अपने हाथ में कोई लकड़ी की वस्तु लेकर वार किया हो, कि इससे उसकी मृत्यु हो जाए और परिणामस्वरूप इस व्यक्ति की मृत्यु हो ही गई है, ");
INSERT INTO hincv_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","तो वह व्यक्ति हत्यारा है; हत्यारे को निःसंदेह मृत्यु दंड दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","यदि घृणा के कारण उसने उस व्यक्ति को धक्का दे दिया है या घात लगाकर कोई वस्तु उस पर फेंकी है, जिससे उसकी मृत्यु हो गई, ");
INSERT INTO hincv_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","या शत्रुता में उसने उस पर अपने हाथ से ही वार कर दिया हो, परिणामस्वरूप उसकी मृत्यु हो गई है; तो जिस व्यक्ति ने ऐसा वार किया है, उसे निश्चित ही मृत्यु दंड दे दिया जाए; वह हत्यारा है, जैसे ही बदला लेनेवाला उसे पाए, उसकी हत्या कर दे. ");
INSERT INTO hincv_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘किंतु यदि बिना किसी शत्रुता के, उसके द्वारा भूल से धक्का लगने पर या बिना घात लगाए उसने उस पर कोई वस्तु फेंक दी हो, ");
INSERT INTO hincv_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","या कोई भी पत्थर की घातक वस्तु को उसने बिना स्थिति का ध्यान रखे ऊंचे स्थान से नीचे गिरा दिया है और उस व्यक्ति की मृत्यु हो जाती है, जबकि न तो उससे उसकी शत्रुता थी और न उसकी मंशा उसकी हानि करने की थी, ");
INSERT INTO hincv_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","इस स्थिति में सारी सभा इन्हीं नियमों के आधार पर हत्यारे तथा बदला लेनेवाले के बीच न्याय करेगी. ");
INSERT INTO hincv_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","सारी सभा हत्यारे को बदला लेनेवाले से छुड़ाकर उसे शरण शहर में लौटा देगी, जहां वह तत्कालीन, पवित्र तेल से अभिषिक्त महापुरोहित की मृत्यु तक निवास करता रहेगा. ");
INSERT INTO hincv_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘किंतु यदि हत्यारा किसी भी अवसर पर अपने इस शरण शहर की सीमा से बाहर निकल जाए, जहां वह भागकर आया हुआ था ");
INSERT INTO hincv_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","और इस स्थिति में बदला लेनेवाला उसे नगर सीमा के बाहर पकड़ लेता है और वहीं उसकी हत्या कर देता है, तो बदला लेनेवाले को हत्या का दोषी नहीं माना जा सकेगा. ");
INSERT INTO hincv_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","क्योंकि सही तो यही था कि वह शरण शहर में ही महापुरोहित की मृत्यु होने तक सीमित रहता. महापुरोहित की मृत्यु के बाद ही वह अपने मीरास के नगर को लौट सकता था. ");
INSERT INTO hincv_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘ये सभी तुम्हारे लिए सारी पीढ़ियों के लिए तुम्हारे सारे घरों में न्याय की विधि होगी. ");
INSERT INTO hincv_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘कोई भी व्यक्ति यदि किसी की हत्या कर देता है, गवाहों की गवाही के आधार पर हत्यारे को मृत्यु दंड दिया जाए, किंतु एक व्यक्ति की गवाही पर किसी को भी मृत्यु दंड न दिया जाए. ");
INSERT INTO hincv_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘इसके अलावा, हत्या के दोषी से तुम उसके प्राण दान के बदले मूल्य स्वीकार नहीं करोगे. तुम उसे निश्चय ही मृत्यु दंड दोगे. ");
INSERT INTO hincv_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘तुम उस व्यक्ति से बदले में मूल्य नहीं लोगे, जो अपने शरण शहर से भागा हुआ है, कि वह महापुरोहित की मृत्यु के पहले ही अपने देश जाकर रह सके. ");
INSERT INTO hincv_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘इसलिये तुम उस देश को अपवित्र न करो, जिसमें तुम रह रहे हो; क्योंकि रक्त भूमि को अपवित्र करता है और उस भूमि के लिए कोई भी प्रायश्चित किया जाना संभव नहीं है, जिस पर रक्त बहा दिया गया है, सिवाय उसी के रक्त के, जिसके द्वारा वह रक्त बहाया गया था. ");
INSERT INTO hincv_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","तुम उस देश में निवास करते हो, तुम उसे अपवित्र नहीं करोगे, जिसके बीच में मेरा निवास है; क्योंकि मैं, वह याहवेह हूं, जिनका निवास इस्राएलियों के बीच में है.’ ” ");
INSERT INTO hincv_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","योसेफ़ के पुत्रों के परिवारों में से मनश्शेह के पौत्र, माखीर के पुत्र गिलआद के वंशजों के प्रधानों ने मोशेह, प्रधानों, जो इस्राएलियों के परिवारों के प्रधान थे, के सामने आकर विनती की: ");
INSERT INTO hincv_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“याहवेह ने मेरे स्वामी को आज्ञा दी है, कि इस्राएलियों को मीरास में भूमि दे दी जाए. मेरे स्वामी को याहवेह से आज्ञा प्राप्‍त हुई थी, कि हमारे भाई ज़लोफेहाद की मीरास उसकी पुत्रियों को दे दी जाए. ");
INSERT INTO hincv_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","किंतु यदि वे इस्राएलियों में से किसी दूसरे गोत्र के पुत्रों में विवाह करती हैं, उनकी मीरास तो उस गोत्र में मिल जाएगी, जो उनके पतियों के है. ");
INSERT INTO hincv_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","इस प्रकार योवेल वर्ष में उन युवतियों के गोत्र की मीरास हमारे पूर्वजों की मीरास में से घटती चली जाएगी.” ");
INSERT INTO hincv_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","इसलिये मोशेह ने याहवेह की आज्ञा के अनुसार इस्राएलियों को आदेश दिया, “योसेफ़ गोत्र के वंशज सही बात कह रहे हैं. ");
INSERT INTO hincv_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","याहवेह ने ज़लोफेहाद की पुत्रियों के विषय में यह आदेश दिया है, ‘उन्हें अपनी इच्छा के वर से विवाह कर लेने दिया जाए; सिर्फ ध्यान रहे कि वे अपने पिता के गोत्र के परिवार में ही विवाह करें.’ ");
INSERT INTO hincv_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","8","परिणामस्वरूप इस्राएलियों में मीरास एक गोत्र से दूसरे गोत्र में न मिल सकेगी. ज़रूरी है कि हर एक इस्राएली अपने-अपने पिता के गोत्र की मीरास को अपने अधिकार में बनाए रखे. ");
INSERT INTO hincv_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","इस प्रक्रिया से कोई भी मीरास एक गोत्र से अन्य गोत्र में न मिल पाएगी; क्योंकि इस्राएलियों के लिए ज़रूरी है कि हर एक अपनी-अपनी मीरास को अपने ही अधिकार में बनाए रखे.” ");
INSERT INTO hincv_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","जैसा आदेश याहवेह ने मोशेह को दिया था, ज़लोफेहाद की पुत्रियों ने ठीक वैसा ही किया. ");
INSERT INTO hincv_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","महलाह, तिरज़ाह, होगलाह, मिलकाह, तथा नोहा ने, जो ज़लोफेहाद की पुत्रियां थी, अपने ही गोत्र में से अपनी-अपनी पसंद के वर से विवाह कर लिया. ");
INSERT INTO hincv_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","उन्होंने योसेफ़ के पुत्र मनश्शेह के पुत्रों के परिवार में से ही विवाह कर लिया, जिससे उनकी मीरास उन्हीं के गोत्र में उनके पिता के परिवारों ही के अधिकार में बनी रही. ");
INSERT INTO hincv_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ये सभी वे आदेश तथा नियम हैं, जो मोशेह के द्वारा याहवेह ने इस्राएलियों को येरीख़ो के पास यरदन नदी के निकट मोआब के मैदानों में दिए थे.");
INSERT INTO hincv_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","मोशेह द्वारा सारे इस्राएल को कहे गए वचन, जो यरदन के पूर्व निर्जन प्रदेश—अराबाह—में दिये गये, जो सूफ के सामने के मैदान में पारान, तोफेल, लाबान, हाज़ोरौथ और दी-ज़ाहाब के पास है. ");
INSERT INTO hincv_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(होरेब पर्वत से सेईर पर्वत होते हुए कादेश-बरनेअ तक यात्रा में सिर्फ ग्यारह दिन ही लगते हैं.) ");
INSERT INTO hincv_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","चालीसवें साल के, ग्यारहवें महीने के पहले दिन मोशेह ने इस्राएलियों को वह सब कह दिया, जिसका आदेश उन्हें याहवेह से मिला था. ");
INSERT INTO hincv_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","इस समय वह हेशबोनवासी अमोरियों के राजा सीहोन और अश्तारोथ और एद्रेइ के शासक बाशान के राजा ओग को हरा चुके थे. ");
INSERT INTO hincv_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","जब वे यरदन के पूर्व मोआब देश में ही थे, मोशेह ने व्यवस्था की व्याख्या करना यह कहते हुए शुरू किया कि: ");
INSERT INTO hincv_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","होरेब पर्वत पर याहवेह हमारे परमेश्वर ने यह कहा था, “पूरी हुई इस पर्वत पर तुम्हारी शांति. ");
INSERT INTO hincv_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","अब अपनी यात्रा शुरू करो. तुम्हें अमोरियों के पहाड़ी प्रदेश, अराबाह के पास के सारे क्षेत्रों को जो पर्वतों और नेगेव की घाटियों और सागर के किनारे के इलाकों तक, कनानियों के देश और महानद फरात तक फैले हुए लबानोन की ओर निशाना करना है. ");
INSERT INTO hincv_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","यह समझ लो, कि मैंने यह ज़मीन तुम्हारे सामने रख दी है. इसमें प्रवेश करो और उस ज़मीन पर अपना अधिकार कर लो, जिसे देने की प्रतिज्ञा मैं, याहवेह ने, तुम्हारे पूर्वज अब्राहाम, यित्सहाक और याकोब से और उनके बाद उनके घराने से की थी.” ");
INSERT INTO hincv_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","उसी समय मैं तुम पर यह प्रकट कर चुका था, “मुझमें यह सामर्थ्य नहीं कि मैं अकेला तुम्हारा भार उठा सकूं. ");
INSERT INTO hincv_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","याहवेह, तुम्हारे परमेश्वर ने तुम्हारी गिनती इस हद्द तक बढ़ा दी है, कि अब तुम्हीं देख लो, कि तुम आकाश के तारों के समान अनगिनत हो चुके हो. ");
INSERT INTO hincv_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","याहवेह, तुम्हारे पूर्वजों के परमेश्वर तुम्हारी गिनती में हज़ार गुणा और बढ़ाकर तुम्हें समृद्ध बना दें; ठीक जैसी प्रतिज्ञा उन्होंने तुमसे की है! ");
INSERT INTO hincv_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","मैं अकेला ही कैसे तुम्हारा बोझ और तुम्हारे विवादों के बोझ को उठा सकता हूं? ");
INSERT INTO hincv_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","अपने ही गोत्रों में से बुद्धिमान, समझदार और अनुभवी व्यक्तियों को चुन लो, तो मैं उन्हें तुम्हारे लिए मुखिया बना दूंगा.” ");
INSERT INTO hincv_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","तुम्हारा उत्तर था, “आपका प्रस्ताव बढ़िया है.” ");
INSERT INTO hincv_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","फिर मैंने तुम्हारे गोत्रों के अध्यक्षों को, जो बुद्धिमान और अनुभवी व्यक्ति थे, तुम्हारे लिए अगुए बना दिये. इन्हें हजार-हजार, सौ-सौ, पचास-पचास तथा दस-दस लोगों के समूह के ऊपर अधिकारी नियुक्त किए. ");
INSERT INTO hincv_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","उसी समय मैंने तुम्हारे न्यायाध्यक्षों को ये आदेश दिए: “अपनी जाति के लोगों के विवाद ध्यान से सुनो और उन्हें निष्पक्ष न्याय दो, चाहे यह विवाद दो सहजातियों के बीच हो या किसी सजातीय और उनके बीच रह रहे परदेशी के बीच. ");
INSERT INTO hincv_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","न्याय में पक्षपात कभी न हो. सामान्य और विशेष का विवाद तुम एक ही नज़रिए से करोगे. तुम्हें किसी भी मनुष्य का भय न हो, क्योंकि न्याय परमेश्वर का है. वे विवाद, जो कठिन महसूस हों, तुम मेरे सामने लाओगे, ताकि मैं खुद उन्हें सुनूं.” ");
INSERT INTO hincv_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","तुम्हें क्या-क्या करना है, यह मैं तुम पर पहले ही स्पष्ट कर चुका हूं. ");
INSERT INTO hincv_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","ठीक जैसा आदेश याहवेह हमारे परमेश्वर ने दिया था, हमने होरेब पर्वत से कूच किया और उस विशाल और भयानक निर्जन प्रदेश से होते हुए, जो खुद तुमने अमोरियों के पर्वतीय क्षेत्र के मार्ग पर देखा था; हम कादेश-बरनेअ पहुंच गए. ");
INSERT INTO hincv_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","मैंने तुम्हें सूचित किया, “तुम अमोरियों के पर्वतीय प्रदेश में आ पहुंचे हो, जो याहवेह, हमारे परमेश्वर हमें देने पर हैं. ");
INSERT INTO hincv_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","देख लो, याहवेह तुम्हारे परमेश्वर ने यह ज़मीन तुम्हारे सामने रख दी है. आगे बढ़ो और उस पर अधिकार कर लो. यही तो याहवेह, तुम्हारे पूर्वजों के परमेश्वर ने तुमसे कह रखा है. तुम न तो भयभीत होना और न ही निराश.” ");
INSERT INTO hincv_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","यह सुन तुम सभी मेरे पास आ गए और मेरे सामने यह प्रस्ताव रखा, “सही होगा कि हम अपने पहले वहां कुछ व्यक्तियों को उस देश का पता करने के उद्देश्य से भेज दें, कि वे उस देश का समाचार लेकर हमें सही स्थिति बताएं, ताकि हम सही रास्ते से उन नगरों में प्रवेश कर सकें.” ");
INSERT INTO hincv_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","यह प्रस्ताव मुझे सही लगा. मैंने हर एक गोत्र से एक-एक व्यक्ति लेकर तुममें से बारह व्यक्ति चुन दिए. ");
INSERT INTO hincv_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","वे पर्वतीय प्रदेश की ओर चले गए. वे एशकोल घाटी में जा पहुंचे और उसका भेद ले लिया. ");
INSERT INTO hincv_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","इसके बाद उन्होंने उस देश के कुछ फल इकट्‍ठे किए और वे हमें दिखाने के लिए ले आए. वे जो विवरण लेकर आए थे, वह इस प्रकार था: “वह देश जो याहवेह, हमारे परमेश्वर हमें देने जा रहे हैं, वास्तव में एक बढ़िया देश है.” ");
INSERT INTO hincv_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","फिर भी तुम आगे बढ़ने के लिए तैयार न हुए, बल्कि तुमने तो याहवेह, तुम्हारे परमेश्वर के आदेश के विरुद्ध विद्रोह ही कर दिया. ");
INSERT INTO hincv_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","तुम अपने-अपने शिविर में यह कहते हुए बड़बड़ाते रहे, “क्योंकि याहवेह को हमसे घृणा है, इसलिये तो वह हमें मिस्र देश से यहां ले आए हैं, कि हमें अमोरियों के द्वारा नाश करवा दें. ");
INSERT INTO hincv_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","हम वहां कैसे जा सकते हैं? हमारे बंधुओं ने तो यह सूचित कर हमारा मनोबल खत्म कर दिया है, ‘वहां के निवासी डीलडौल में हमसे बहुत बड़े और शक्तिमान हैं. नगर विशाल हैं और शहरपनाहें गगन को चूमती हैं, इसके अलावा हमने वहां अनाक के वंशज भी देखे हैं.’ ” ");
INSERT INTO hincv_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","फिर मैंने तुम्हें आश्वस्त किया, “न तो इससे हैरान हो जाओ और न डरो. ");
INSERT INTO hincv_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","याहवेह, तुम्हारे परमेश्वर, जो तुम्हारे अगुए हैं, खुद तुम्हारी ओर से युद्ध करेंगे; ठीक जैसा उन्होंने तुम्हारे देखते ही देखते मिस्र देश में तुम्हारे लिए किया था. ");
INSERT INTO hincv_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","और निर्जन प्रदेश में भी, जहां तुमने देख लिया, कि कैसे याहवेह, तुम्हारे परमेश्वर पूरे मार्ग में, जिस पर चलते हुए तुम यहां तक आ पहुंचे हो, इस रीति से तुम्हें उठाए रहा, जिस प्रकार कोई व्यक्ति अपने पुत्र को उठाता है.” ");
INSERT INTO hincv_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","मगर इतना सब होने पर भी, तुमने याहवेह, अपने परमेश्वर पर विश्वास नहीं किया, ");
INSERT INTO hincv_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","जो तुम्हारे ही मार्ग पर तुम्हारे आगे-आगे चलते हुए जा रहे हैं, कि तुम्हारे लिए ऐसा सही स्थान तय करें, जहां तुम पड़ाव डाल सको. वह रात में तो आग के द्वारा और दिन में बादल के द्वारा तुम्हारे मार्गदर्शक हुआ करते थे. ");
INSERT INTO hincv_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","याहवेह ने तुम्हारी बड़बड़ाहट सुन ली. वह क्रोधित हो गए और तब उन्होंने यह शपथ ली: ");
INSERT INTO hincv_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“इस बुरी पीढ़ी में से एक भी व्यक्ति उस अच्छे देश को देख न सकेगा, जिसकी प्रतिज्ञा मैंने तुम्हारे पूर्वजों से की थी, ");
INSERT INTO hincv_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","सिवाय येफुन्‍नेह के पुत्र कालेब के; वह इस देश में प्रवेश करेगा. उसे और उसकी संतान को मैं यह देश दे दूंगा, जिस पर उसके कदम पड़े थे; क्योंकि उसका मन पूरी तरह याहवेह के प्रति विश्वासयोग्य बना रहा है.” ");
INSERT INTO hincv_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","तुम्हारे कारण याहवेह मुझ पर ही क्रोधित हो गए और उन्होंने मुझसे कहा, “तुम भी उस देश में प्रवेश न करोगे. ");
INSERT INTO hincv_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","मगर नून का पुत्र यहोशू, जो तुम्हारा सेवक है, उस देश में प्रवेश करेगा. तुम उसकी हिम्मत बनाए रखो. वही इस्राएल को उस देश पर अधिकार करने के लिए प्रेरित करेगा. ");
INSERT INTO hincv_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","इनके अलावा तुम्हारे बालक, जिनके लिए तुम यह कहते रहे हो, कि वे तो उनके शिकार हो जाएंगे, और तुम्हारी वह संतान, जिन्हें आज सही गलत का पता ही नहीं है, उस देश में प्रवेश करेंगी; मैं उन्हें यह देश दे दूंगा और वे इस पर अधिकार कर लेंगे. ");
INSERT INTO hincv_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","मगर तुम मुड़कर लाल सागर पथ पर निर्जन प्रदेश की ओर लौट जाओ.” ");
INSERT INTO hincv_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","तब तुमने मेरे सामने यह स्वीकार किया, “हमने याहवेह के विरुद्ध पाप किया है; अब हम पहाड़ी प्रदेश पर चढ़ेंगे, और ठीक जैसा आदेश याहवेह हमारे परमेश्वर ने दिया है, उन जातियों से युद्ध करेंगे.” तुममें से हर एक ने हथियार धारण कर लिए. तुम्हें तो पहाड़ी क्षेत्र में जाकर हमला करना सरल प्रतीत हो रहा था. ");
INSERT INTO hincv_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","मगर मुझे याहवेह की ओर से यह आदेश मिला: “उनसे यह कहो, ‘न तो वहां जाना और न ही उनसे युद्ध करना, क्योंकि इसमें मैं तुम्हारे साथ नहीं हूं; नहीं तो तुम अपने शत्रुओं द्वारा हरा दिए जाओगे.’ ” ");
INSERT INTO hincv_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","इसलिये मैंने तुम्हारे सामने ये बातें रख दीं, मगर तुमने इसकी उपेक्षा करके याहवेह के आदेश के विरुद्ध विद्रोह कर दिया. अपने हठ में तुम उस पर्वतीय क्षेत्र में पहुंच गए. ");
INSERT INTO hincv_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","उस क्षेत्र के अमोरी बाहर निकल आए और तुम्हें इस रीति से खदेड़ दिया मानो तुम्हारे पीछे मधुमक्खियां लगी हों. वे तो तुम्हें सेईर से होरमाह तक कुचलते गए. ");
INSERT INTO hincv_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","तुम लौट आए और याहवेह के सामने रोते रहे; मगर याहवेह पर तुम्हारे इस रोने का कोई असर न पड़ा. ");
INSERT INTO hincv_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","फलस्वरूप तुम्हें कादेश में ही लंबे समय तक ठहरना पड़ा. ऐसे ही रहे वहां तुम्हारे दिन. ");
INSERT INTO hincv_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","याहवेह के आदेश के अनुसार तब हमने लाल सागर की दिशा में कूच किया, जो निर्जन प्रदेश की ओर गया है. हम लंबे समय तक सेईर पर्वत के चारों ओर घूमते रहे. ");
INSERT INTO hincv_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","फिर याहवेह ने मुझसे कहा, ");
INSERT INTO hincv_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“बहुत हो चुका तुम्हारा इस पर्वत के चारों ओर घूमना; अब उत्तर दिशा की ओर घूम जाओ. ");
INSERT INTO hincv_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","तब तुम इन लोगों को आदेश दो: ‘तुम अपने भाइयों सेईरवासियों, एसाव वंशजों के क्षेत्र से होकर निकल जाओ; उन पर तुम्हारा भय होगा, तब तुम बहुत सावधान रहना. ");
INSERT INTO hincv_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","उन्हें उकसाना मत, क्योंकि मैं तुम्हें उनकी भूमि से ज़रा भी नहीं दूंगा, इतनी भी नहीं कि तुम उस पर पैर रख सको; क्योंकि एसाव को मैं सेईर पर्वत मीरास के रूप में दे चुका हूं. ");
INSERT INTO hincv_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","तुम रुपया देकर उनसे भोजन ख़रीदोगे, कि तुम अपनी भूख मिटा सको; तुम जल भी रुपया देकर ख़रीदोगे, कि तुम जल पीकर अपनी प्यास बुझा सको.’ ” ");
INSERT INTO hincv_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","क्योंकि याहवेह तुम्हारे परमेश्वर ने तुम्हारे हर एक काम में आशीष प्रदान की है. इस विशाल निर्जन प्रदेश में तुम्हारा भटकना वह जानता है. याहवेह, तुम्हारे परमेश्वर इन चालीस सालों में तुम्हारे साथ साथ रहे हैं; तुम्हें किसी भी रूप में कुछ भी कम नहीं हुआ है. ");
INSERT INTO hincv_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","फिर हम सेईरवासी अपने भाइयों से दूर ही दूर, अराबाह मार्ग से दूर, एलाथ और एज़िओन-गेबेर से दूर ही दूर रहते हुए वहां से निकल गए. ");
INSERT INTO hincv_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","फिर याहवेह ने मुझे आदेश दिया, “मोआब को उत्पीड़ित न करना, न ही उन्हें युद्ध के लिए उकसाना, क्योंकि मैं तुम्हें रहने के लिए वहां ज़रा सी भूमि भी न दूंगा, क्योंकि मैं लोत की संतानों को आर निज भाग के रूप में दे चुका हूं.” ");
INSERT INTO hincv_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(यहां के मूल निवासी एमिम थे, जो डीलडौल में अनाकियों के समान लंबे और अनगिनत थे. ");
INSERT INTO hincv_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","अनाकियों के समान उन्हें रेफाइम भी माना जाता है, मगर मोआबी उन्हें एमिम ही कहकर पुकारते हैं. ");
INSERT INTO hincv_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","इसके पहले सेईर में होरी लोग ही बसे थे, मगर एसाव के वंशजों ने आकर देखते ही देखते उनसे यह देश छीनकर उन्हें नाश कर दिया और उनके स्थान पर वहां रहने लगे, ठीक उसी प्रकार, जिस प्रकार इस्राएलियों ने याहवेह के दिए हुए उस देश के साथ किया था.) ");
INSERT INTO hincv_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","याहवेह ने कहा, “अब ज़ेरेद नदी को पार करने के लिए तैयार हो जाओ.” तब हम ज़ेरेद नदी के पार चले गए. ");
INSERT INTO hincv_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","कादेश-बरनेअ से यात्रा शुरू कर ज़ेरेद नदी के पार उतरने के बीच का समय था अड़तीस साल, जब तक इस पीढ़ी के सारे योद्धा इस्राएली समुदाय से नाश न हो गए, जैसा याहवेह द्वारा ली गई शपथ में कहा गया था. ");
INSERT INTO hincv_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","इसके अलावा याहवेह का हाथ उनके विरुद्ध हो चुका था, कि उन्हें छावनी से नाश कर दिया जाए, कि वे सभी मिट जाएं. ");
INSERT INTO hincv_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","फिर जब इस्राएली समुदाय से अंत में सभी योद्धा मिट गए, ");
INSERT INTO hincv_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","तब याहवेह ने मुझसे कहा, ");
INSERT INTO hincv_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“आज तुम आर अर्थात् मोआब की सीमा के पार निकल जाओगे. ");
INSERT INTO hincv_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","जब तुम वहां अम्मोनियों के सामने पहुंच जाओगे, तब न तो तुम उन्हें सताना और न उन्हें उकसाना, क्योंकि मैं तुम्हें अम्मोनियों की भूमि में से निज भूमि के लिए कुछ भी न दूंगा; क्योंकि यह मैं लोत के वंशजों को मीरास के रूप में दे चुका हूं.” ");
INSERT INTO hincv_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(इसे रेफाइम का देश भी माना जाता है, क्योंकि इसके पूर्व यहां उन्हीं का निवास था; मगर अम्मोनी उन्हें ज़मज़ुम्मिम पुकारते हैं. ");
INSERT INTO hincv_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ये लोग वह प्रजाति हैं, जो बलवान, अनगिनत और डीलडौल में लंबे हैं, अनाकियों के समान, मगर याहवेह ने इन रेफ़ाइयों को अम्मोनियों के सामने से नाश कर दिया. फलस्वरूप वे इन्हें हटाकर उनके देश में बस गए. ");
INSERT INTO hincv_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","ठीक जैसा उन्होंने एसाव के वंशजों के लिए किया था, जो सेईर में रहते थे. याहवेह ने उनके सामने से होरियों को नाश कर दिया था. वे इन्हें वहां से निकालकर उनके स्थान पर बस गए और आज तक वे उसी स्थान पर रह रहे हैं. ");
INSERT INTO hincv_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","वैसे ही अव्वी भी अज्जाह तक विभिन्‍न ग्रामों में बस गए हैं, काफ़तोरवासी आए और उन्हें नाश कर उनके नगरों में बस गए.) ");
INSERT INTO hincv_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“अब कूच करो और आरनोन घाटी में से होकर आगे बढ़ो. देखो, मैंने अमोरी सीहोन, जो हेशबोन का राजा है, उसे और उसके देश को तुम्हारे अधीन कर दिया है. उससे युद्ध करना शुरू करके उसके देश पर अधिकार करना शुरू कर दो. ");
INSERT INTO hincv_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","आज से मैंने सारी पृथ्वी के जनताओं पर, तुम्हारा भय और थरथराहट पैदा कर दी है, कि वे जैसे ही तुम्हारा नाम सुनेंगे, वे तुम्हारे कारण डर और शिथिल होने की स्थिति में जा पड़ेंगे.” ");
INSERT INTO hincv_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","फिर मैंने केदेमोथ के निर्जन प्रदेश से हेशबोन के राजा सीहोन के दूतों के द्वारा संधि का संदेश भेजा, ");
INSERT INTO hincv_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“मुझे अपने देश की भूमि पर से होकर आगे बढ़ने की आज्ञा दे दीजिए. मैं सिर्फ राजमार्ग पर ही यात्रा करूंगा; मैं इस मार्ग से न तो बाएं मुड़ुंगा न दाएं. ");
INSERT INTO hincv_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","आप मुझे खाने के लिए भोजन और पीने के लिए जल बेचेंगे. सिर्फ कृपा कर आप हमें यहां से पैदल निकल जाने की अनुमति दे दीजिए, ");
INSERT INTO hincv_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","ठीक जिस प्रकार सेईरवासी एसाव और आर के निवासी मोआबियों ने हमें यह सुविधा प्रदान की थी, कि हम यरदन को पार कर उस देश में पहुंच सकें, जो याहवेह, हमारे परमेश्वर हमें दे रहे हैं.” ");
INSERT INTO hincv_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","मगर हेशबोन का राजा सीहोन हमें अपने देश में से होकर निकल जाने देने के बारे में राज़ी न हुआ; क्योंकि याहवेह, तुम्हारे परमेश्वर ने उसकी आत्मा को कठोर बनाकर उसके हृदय को इस उद्देश्य से हठीला बना दिया था, कि उसे तुम्हारे अधीन कर दें; जैसा वह आज भी है. ");
INSERT INTO hincv_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","याहवेह ने मुझे संकेत दिया, “अब देखो, मैंने सीहोन और उसके देश को तुम्हारे अधीन करने का काम शुरू कर दिया है. भूमि अपने अधिकार में लेना शुरू कर दो, कि उसका देश तुम्हारे अधिकार में आ जाए.” ");
INSERT INTO hincv_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","तब सीहोन अपनी सारी सेना को लेकर हमसे युद्ध करने के उद्देश्य से याहज़ नामक स्थान पर आ गया, ");
INSERT INTO hincv_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","याहवेह, हमारे परमेश्वर ने उसे हमारे अधीन कर दिया, हमने उसे और उसके पुत्रों को सारी सेना के साथ हरा दिया. ");
INSERT INTO hincv_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","तब हमने उसी समय उसके हर एक नगर को अपने अधीन कर नगर के सारे स्त्री-पुरुषों और बालकों को पूरी तरह से नाश कर दिया. हमने एक भी उत्तरजीवी शेष न रहने दिया. ");
INSERT INTO hincv_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","हमने सिर्फ पशु और नगरों से प्राप्‍त सामग्री को अपने लिए रख लिया. ");
INSERT INTO hincv_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","आरनोन घाटी की सीमा के अरोअर से और घाटों में स्थित नगर से गिलआद तक कोई भी नगर ऐसा न था, जिसकी दीवार हमारे सामने छोटी साबित हुई हो. याहवेह, हमारे परमेश्वर ने सभी को हमारे अधीन कर दिया. ");
INSERT INTO hincv_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","तुम सिर्फ अम्मोन के वंशजों के देश के निकट नहीं गए और न ही यब्बोक नदी के तट तक और न पर्वतीय क्षेत्रों तक, जहां कहीं याहवेह, हमारे परमेश्वर ने हमें न जाने का आदेश दिया था. ");
INSERT INTO hincv_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","फिर हमने मुड़कर बाशान के मार्ग से आगे बढ़ गए. बाशान का राजा ओग अपनी सारी सेना लेकर हमसे युद्ध करने एद्रेइ जा पहुंचा. ");
INSERT INTO hincv_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","मगर याहवेह ने मुझे यह आश्वासन दिया, “उससे डरने की कोई आवश्यकता नहीं है, क्योंकि मैंने उसे, उसकी सारी सेना तथा प्रजा को तुम्हारे अधीन कर दिया है. तुम उसके साथ वही सब करोगे, जो तुमने हेशबोन निवासी अमोरियों के राजा सीहोन के साथ किया था.” ");
INSERT INTO hincv_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","इसी प्रकार याहवेह, हमारे परमेश्वर ने बाशान के राजा ओग को भी उसकी सारी सेना सहित हमारे अधीन कर दिया. हम उनका नाश इस सीमा तक करते चले गए कि कोई भी जीवित न रहा. ");
INSERT INTO hincv_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","उस समय हमने उसके सारे नगर अपने अधिकार में कर लिए; एक भी नगर ऐसा न रहा, जो हमने उनसे न छीना हो: साठ नगर, बाशान में ओग का साम्राज्य अर्थात् अरगोब का सारा क्षेत्र. ");
INSERT INTO hincv_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","इन सभी नगरों की दीवारें ऊंची-ऊंची थीं, इनमें फाटक और छड़ें थीं. इनके अलावा कुछ नगर ऐसे भी थे, जिनकी दीवारें न थीं. ");
INSERT INTO hincv_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","हमने इन सभी को पूरी तरह गिरा दिया, ठीक जिस प्रकार हमने हेशबोन के राजा सीहोन के साथ किया था-पुरुषों, स्त्रियों और बालकों को हर एक नगर में पूरी तरह नाश कर डाला. ");
INSERT INTO hincv_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","मगर हमने सभी पशुओं और नगरों से इकट्ठा की गई सामग्री को अपने लिए रख लिया. ");
INSERT INTO hincv_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","इस प्रकार हमने यरदन के पार के दो अमोरी राजाओं की अधीनता से, आरनोन की घाटी से लेकर हरमोन पर्वत तक की भूमि को अपने अधिकार में ले लिया. ");
INSERT INTO hincv_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(सीदोनवासी हरमोन को सिरिओन और अमोरी इसे सेनीर कहकर पुकारते हैं.) ");
INSERT INTO hincv_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","इनके अलावा पठार के सारे नगर, सारे गिलआद, सारे बाशान, सलेकाह और एद्रेइ, जो बाशान में ओग के राज्य में थे. ");
INSERT INTO hincv_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(रेफाइम के बचे हुए भाग में केवल बाशान का राजा ही शेष रह गया था. उल्लेखनीय बात यह है कि उसकी चारपाई लौह की थी; यह अब तक अम्मोनियों के रब्बाह में स्थापित है. यह लगभग चार मीटर लंबी और डेढ़ मीटर चौड़ी है.) ");
INSERT INTO hincv_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","फिर हमने उसी समय इस देश को अपने अधिकार में कर लिया. यह आरनोन की घाटी अरोअर से गिलआद के आधे क्षेत्र और इसमें स्थित नगरों का क्षेत्र है, जो मैंने रियूबेन और गाद के घराने को दे दिया. ");
INSERT INTO hincv_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","बचा हुआ गिलआद, सारा बाशान अर्थात् जो ओग का साम्राज्य था, मैंने मनश्शेह के आधे गोत्र को दे दिया. (यह था अरगोब का पूरा क्षेत्र. सारे बाशान के बारे में कहा जाता है, कि यह रेफाइम का देश है. ");
INSERT INTO hincv_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","मनश्शेह के पुत्र याईर ने गेशूरियों और माकाहथियों की सीमाओं तक पूरा क्षेत्र अपने अधिकार में कर लिया, अर्थात् अपने नाम के अनुरूप बाशान और हव्वोथ-याईर, जो उसका आधुनिक नाम है.) ");
INSERT INTO hincv_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","माखीर को मैंने गिलआद दे दिया. ");
INSERT INTO hincv_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","रियूबेन और गाद के घराने को मैंने गिलआद का वह क्षेत्र दे दिया, जो आरनोन की घाटी तक फैला है (इसकी सीमा घाटी के बीच तक थी) और यब्बोक नदी तक, जो अम्मोनियों की सीमा भी थी. ");
INSERT INTO hincv_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","इसके अलावा अराबाह भी, जिसकी सीमा यरदन हो गई, किन्‍नेरेथ से लेकर अराबाह सागर तक, लवण-सागर, जिसके पूर्व में पिसगाह की ढलान की तलहटी है. ");
INSERT INTO hincv_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","इसके बाद मैंने उस समय तुम्हें यह आदेश दिया, “याहवेह, तुम्हारे परमेश्वर ने तुम्हें यह देश अपने अधिकार में करने के उद्देश्य से दे दिया. तुम्हारे सारे वीर योद्धा शस्त्रों से सुसज्जित हो इस्राएल वंशज तुम्हारे भाइयों के आगे-आगे नदी पार करेंगे. ");
INSERT INTO hincv_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","मगर तुम्हारी पत्नियां, तुम्हारे बालक और तुम्हारे पशु मुझे मालूम है कि तुम्हारे पास बहुत पशु धन है, तुम्हारे साथ उसी समय तक उन्हीं नगरों में रहेंगे, जो मैंने तुम्हें दे दिए हैं, ");
INSERT INTO hincv_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","जब तक याहवेह तुम्हारे बंधुओं को तुम्हारे समान शांति और विश्राम न दे दें, और वे भी उस देश को अपने अधिकार में न कर लें, जो याहवेह, तुम्हारे परमेश्वर तुम्हें यरदन पार देने पर हैं. यह सब होने पर तुममें से हर एक मेरे द्वारा तुम्हें सौंपी गई संपत्ति को लौटाओगे.” ");
INSERT INTO hincv_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","उस समय मैंने यहोशू को यह आदेश दिया, “तुमने तो खुद ही यह देख लिया है, कि याहवेह तुम्हारे परमेश्वर ने इन दो राजाओं के साथ क्या किया है; यही सब याहवेह उन सभी साम्राज्यों के साथ भी करेंगे, जिनसे होकर तुम निकलोगे. ");
INSERT INTO hincv_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","तुम उनसे कदापि भयभीत न होना; क्योंकि यह युद्ध वह है, जो याहवेह, तुम्हारे परमेश्वर तुम्हारी ओर से लड़ेंगे.” ");
INSERT INTO hincv_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","मैंने उस समय याहवेह से यह विनती की: ");
INSERT INTO hincv_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“प्रभु याहवेह, आपने अपने सेवक पर अपनी महिमा और सामर्थ्य दिखाना शुरू किया है. क्योंकि स्वर्ग और पृथ्वी पर कौन है ऐसा देवता, जो आपके समान ऐसे काम और सामर्थ्य से भरे काम पूरे कर सके? ");
INSERT INTO hincv_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","प्रभु, मेरी विनती है, कृपा कर मुझे यरदन के पार जाकर उस श्रेष्ठ देश को सिर्फ देख लेने दीजिए, उस सुहावने पर्वतीय प्रदेश और लबानोन को.” ");
INSERT INTO hincv_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","मगर याहवेह तुम्हारे कारण मुझसे क्रोधित थे. उन्होंने मेरी इस विनती को अनसुनी की. उन्होंने कहा, “बहुत हो चुका, अब मुझसे इस विषय का वर्णन न करना. ");
INSERT INTO hincv_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","पिसगाह पर्वत शिखर पर चले जाओ, पश्चिम, उत्तर, पूर्व और दक्षिण दिशा की ओर दृष्टि कर उसको देख लो, क्योंकि यरदन के पार तो तुम जा ही न सकोगे. ");
INSERT INTO hincv_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","हां, यहोशू को नियुक्त करो, उसे प्रोत्साहित करो, उसे दृढ़ बनाओ, क्योंकि वही इन लोगों का अगुआ होकर यरदन के पार जाएगा और वही उन्हें मीरास में वह देश प्रदान करेगा, जिसे तुम देखने पर हो.” ");
INSERT INTO hincv_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","तब हम बेथ-पिओर के पास की घाटी में ही ठहरे रहे. ");
INSERT INTO hincv_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","हे इस्राएल, उन विधियों और नियमों को ध्यान से सुन लो, जिनका पालन करने की शिक्षा मैं तुम्हें दे रहा हूं, कि तुम जीवित रहते हुए उस देश में प्रवेश कर उस पर अधिकार कर लो, जो तुम्हारे पूर्वजों के परमेश्वर याहवेह तुम्हें दे रहे हैं. ");
INSERT INTO hincv_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","तुम मेरी बातों में, जिसका आदेश मैं तुम्हें आज दे रहा हूं, न तो कुछ जोड़ोगे और न ही घटाओगे, कि तुम याहवेह, तुम्हारे परमेश्वर के आदेशों का पालन कर सको, जो मैंने भेज रखा है. ");
INSERT INTO hincv_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","यह तो तुमने खुद ही देख लिया है कि याहवेह ने बाल-पिओर के साथ क्या किया है. जितनों ने बाल-पिओर के पीछे चलने का निश्चय किया, याहवेह तुम्हारे परमेश्वर ने उन्हें तुम्हारे बीच से नाश कर दिया, ");
INSERT INTO hincv_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","मगर तुम, जो याहवेह, तुम्हारे परमेश्वर के प्रति सच्चे बने रहे, तुममें से सबके सब आज भी जीवित हो. ");
INSERT INTO hincv_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","याद रहे, मैं तुम्हें नियमों और विधियों की शिक्षा दे चुका हूं, ठीक जैसा, मेरे लिए याहवेह, मेरे परमेश्वर का आदेश था, कि तुम्हारा चालचलन उस देश में, जहां तुम उस पर अधिकार के उद्देश्य से प्रवेश करने पर हो, इन्हीं के अनुसार हो. ");
INSERT INTO hincv_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","तब इनका पालन करो; क्योंकि इनका पालन करना और इन पर चलना ही उन लोगों की दृष्टि में तुम्हारी समझ और बुद्धिमानी होगी, जो इन विधियों का वर्णन सुनेंगे और तब उनके शब्द होंगे, “निश्चय यह सम्पन्‍न राष्ट्र एक बुद्धिमान और ज्ञानवान राष्ट्र है.” ");
INSERT INTO hincv_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","क्योंकि किस सम्पन्‍न राष्ट्र का ऐसा ईश्वर है, जो उसके ऐसे पास रहता है, जैसे याहवेह, हमारे परमेश्वर उस मौके पर होते हैं, जब हम उन्हें पुकारते हैं? ");
INSERT INTO hincv_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","अथवा ऐसा कौन सम्पन्‍न राष्ट्र है, जिसकी विधियां और नियम ऐसे रीत हैं जैसे इस सारी व्यवस्था के हैं, जो आज मैं तुम्हारे सामने रखने जा रहा हूं? ");
INSERT INTO hincv_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","सिर्फ सावधानी बनाए रखो और बड़ी ही चौकसी से अपने भले की सुरक्षा बनाए रखो, कि तुम्हारी आंखों से खुद तुम्हारे द्वारा देखा गया घटनाक्रम गायब न हो जाए, कि आजीवन वे तुम्हारे हृदय से न निकलें, बल्कि तुम अपने पुत्र और पोतों को इन्हें सिखाते रहो. ");
INSERT INTO hincv_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","वह दिन भूल न जाओ जिस दिन तुम होरेब पर्वत पर याहवेह, तुम्हारे परमेश्वर के सामने उपस्थित हुए थे, जब याहवेह ने मुझे संबोधित किया, “मेरे सामने लोगों को इकट्ठा करो, कि मैं उन्हें अपनी आवाज सुना सकूं, कि फलस्वरूप उनमें आजीवन मेरे प्रति श्रद्धा और भय बना रह जाए; और वे अपनी संतान को इसकी शिक्षा दे सकें.” ");
INSERT INTO hincv_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","तुम सब पास आकर पर्वत के नीचे इकट्ठा हो गए. पर्वत पर आग की लपटें आकाश चूम रही थीं. हर जगह अंधकार, मेघ और घना धुआं फैल चुका था. ");
INSERT INTO hincv_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","तब याहवेह ने आग में से तुमसे बातें की. तुम्हें शब्द और आवाज तो सुनाई दे रहे थे, मगर किसी भी प्रकार का स्वरूप दिखाई नहीं दे रहा था-वहां सिर्फ आवाज ही सुनाई दे रही थी. ");
INSERT INTO hincv_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","वहां याहवेह ने अपनी उस वाचा की घोषणा, जिसके पालन करने का आदेश उन्होंने तुम्हें दिया था, अर्थात् वे दस आदेश. ये आदेश याहवेह ने दो पट्टियों पर उकेर दिए थे. ");
INSERT INTO hincv_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","उस समय याहवेह का यही आदेश था, कि मैं तुम्हें इन विधियों और नियमों की शिक्षा दूं, कि तुम उस देश में पहुंचकर इनका पालन कर सको, जिस देश में जाकर तुम उस पर अधिकार करने पर हो. ");
INSERT INTO hincv_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","इसलिये बहुत सावधान रहो, क्योंकि जिस दिन होरेब पर्वत पर याहवेह आग के बीच से तुमसे अभिमुख हुए थे. तुम्हें उनका कोई भी स्वरूप दिखाई नहीं दिया था, ");
INSERT INTO hincv_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","कि तुम्हारा चरित्र दूषित न हो जाए और तुम अपने लिए किसी भी स्वरूप में मूर्ति न ढाल लो, नर अथवा नारी के रूप में, ");
INSERT INTO hincv_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","अथवा पृथ्वी तल पर के किसी पशु की मूर्ति, अथवा आकाश में उड़ते पक्षी की, ");
INSERT INTO hincv_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","या किसी रेंगते जंतु की, किसी मछली की मूर्ति न ढाल लो जो पृथ्वी सतह से नीचे जल में पाई जाती है. ");
INSERT INTO hincv_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","सावधान रहो, कि तुम अपनी दृष्टि आकाश की ओर उठाकर सूर्य, चंद्रमा और तारों; हां, नक्षत्रों की ओर उठाकर उनकी ओर आकर्षित हो जाओ और उनकी आराधना और स्तुति करना शुरू कर दो. इन्हें तो याहवेह तुम्हारे परमेश्वर ने सारी पृथ्वी की जनताओं के हित में प्रदान किए हैं. ");
INSERT INTO hincv_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","मगर सच यह है कि मिस्र देश में से याहवेह मानो आग की भट्टी से तुम्हें निकालकर लाए हैं, कि तुम जैसा आज देख ही रहे हो, तुम याहवेह ही की संपत्ति होकर रहो. ");
INSERT INTO hincv_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","तुम्हारे कारण मैं याहवेह के क्रोध का शिकार हो गया! उन्होंने यह शपथ ली, कि मैं यरदन नदी के पार नहीं जा सकूंगा, कि मैं उस उत्तम देश में प्रवेश नहीं करूंगा, जो याहवेह तुम्हारे परमेश्वर तुम्हें मीरास के रूप में दे रहे हैं. ");
INSERT INTO hincv_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","मेरी मृत्यु इसी देश में होनी तय है. मैं यरदन नदी के पार नहीं जाऊंगा पर तुम लोग जाओगे और इस श्रेष्ठ भूमि पर अधिकार करोगे. ");
INSERT INTO hincv_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","इसलिये सावधान रहो; कि तुम उस वाचा को भुला न डालो, जो याहवेह तुम्हारे परमेश्वर ने तुम्हारे साथ बांधी है. इसलिये अपने लिए उनमें से किसी भी प्रकार की मूर्ति न बनाना, जिसके लिए याहवेह, तुम्हारे परमेश्वर की ओर से मनाही की गई है. ");
INSERT INTO hincv_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","क्योंकि याहवेह, तुम्हारे परमेश्वर भस्म करनेवाली आग हैं, एक जलन रखनेवाला परमेश्वर. ");
INSERT INTO hincv_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","जब तुम्हारे संतान उत्पन्‍न होगी और फिर उनकी भी संतान पैदा होगी और उस देश में तुम पीढ़ी से पीढ़ी तक निवास कर चुके होगे और तब अपना चालचलन बिगाड़कर किसी भी वस्तु की मूर्ति बना लो, जो कि याहवेह, तुम्हारे परमेश्वर की दृष्टि में गलत है और इसके द्वारा तुम उनको क्रोध से भर दो, ");
INSERT INTO hincv_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","तो मैं तुम्हारे विरुद्ध गवाह होने के लिए आज आकाश और पृथ्वी को बुला रहा हूं, कि तुम निःसंदेह उस देश में, जहां तुम यरदन के पार उतरकर उस पर अधिकार करने पर हो, शीघ्र ही पूरी तरह नाश हो जाओगे. ");
INSERT INTO hincv_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","याहवेह तुम्हें राष्ट्रों के बीच तितर-बितर कर देंगे. याहवेह तुम्हें जिन जनताओं में ठहराएंगे, तुम वहां थोड़ी गिनती में होकर रह जाओगे. ");
INSERT INTO hincv_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","तुम उन राष्ट्र