﻿USE sofia;
DROP TABLE IF EXISTS sofia.hin2017_vpl;
CREATE TABLE hin2017_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hin2017_vpl WRITE;
INSERT INTO hin2017_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","आदि में परमेश्वर ने आकाश और पृथ्वी की सृष्टि की। (इब्रा. 1:10, इब्रा. 11:3) ");
INSERT INTO hin2017_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","पृथ्वी बेडौल और सुनसान पड़ी थी, और गहरे जल के ऊपर अंधियारा था; तथा परमेश्वर का आत्मा जल के ऊपर मण्डराता था। (2 कुरि. 4:6) ");
INSERT INTO hin2017_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","तब परमेश्वर ने कहा, “उजियाला हो,” तो उजियाला हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","और परमेश्वर ने उजियाले को देखा कि अच्छा है; और परमेश्वर ने उजियाले को अंधियारे से अलग किया। ");
INSERT INTO hin2017_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","और परमेश्वर ने उजियाले को दिन और अंधियारे को रात कहा। तथा साँझ हुई फिर भोर हुआ। इस प्रकार पहला दिन हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","फिर परमेश्वर ने कहा, “जल के बीच एक ऐसा अन्तर हो कि जल दो भाग हो जाए।” ");
INSERT INTO hin2017_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","तब परमेश्वर ने एक अन्तर करके उसके नीचे के जल और उसके ऊपर के जल को अलग-अलग किया; और वैसा ही हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","और परमेश्वर ने उस अन्तर को आकाश कहा। तथा साँझ हुई फिर भोर हुआ। इस प्रकार दूसरा दिन हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","फिर परमेश्वर ने कहा, “आकाश के नीचे का जल एक स्थान में इकट्ठा हो जाए और सूखी भूमि दिखाई दे,” और वैसा ही हो गया। (2 पत. 3:5) ");
INSERT INTO hin2017_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","और परमेश्वर ने सूखी भूमि को पृथ्वी कहा, तथा जो जल इकट्ठा हुआ उसको उसने समुद्र कहा; और परमेश्वर ने देखा कि अच्छा है। ");
INSERT INTO hin2017_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","फिर परमेश्वर ने कहा, “पृथ्वी से हरी घास, तथा बीजवाले छोटे-छोटे पेड़, और फलदाई वृक्ष भी जिनके बीज उन्हीं में एक-एक की जाति के अनुसार होते हैं पृथ्वी पर उगें,” और वैसा ही हो गया। (1 कुरि. 15:38) ");
INSERT INTO hin2017_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","इस प्रकार पृथ्वी से हरी घास, और छोटे-छोटे पेड़ जिनमें अपनी-अपनी जाति के अनुसार बीज होता है, और फलदाई वृक्ष जिनके बीज एक-एक की जाति के अनुसार उन्हीं में होते हैं उगें; और परमेश्वर ने देखा कि अच्छा है। ");
INSERT INTO hin2017_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","तथा साँझ हुई फिर भोर हुआ। इस प्रकार तीसरा दिन हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","फिर परमेश्वर ने कहा, “दिन को रात से अलग करने के लिये आकाश के अन्तर में ज्योतियाँ हों; और वे चिन्हों, और नियत समयों, और दिनों, और वर्षों के कारण हों; ");
INSERT INTO hin2017_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","और वे ज्योतियाँ आकाश के अन्तर में पृथ्वी पर प्रकाश देनेवाली भी ठहरें,” और वैसा ही हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","तब परमेश्वर ने दो बड़ी ज्योतियाँ बनाईं; उनमें से बड़ी ज्योति को दिन पर प्रभुता करने के लिये, और छोटी ज्योति को रात पर प्रभुता करने के लिये बनाया; और तारागण को भी बनाया। ");
INSERT INTO hin2017_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","परमेश्वर ने उनको आकाश के अन्तर में इसलिए रखा कि वे पृथ्वी पर प्रकाश दें, ");
INSERT INTO hin2017_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","तथा दिन और रात पर प्रभुता करें और उजियाले को अंधियारे से अलग करें; और परमेश्वर ने देखा कि अच्छा है। ");
INSERT INTO hin2017_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","तथा साँझ हुई फिर भोर हुआ। इस प्रकार चौथा दिन हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","फिर परमेश्वर ने कहा, “जल जीवित प्राणियों से बहुत ही भर जाए, और पक्षी पृथ्वी के ऊपर आकाश के अन्तर में उड़ें।” ");
INSERT INTO hin2017_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","इसलिए परमेश्वर ने जाति-जाति के बड़े-बड़े जल-जन्तुओं की, और उन सब जीवित प्राणियों की भी सृष्टि की जो चलते फिरते हैं जिनसे जल बहुत ही भर गया और एक-एक जाति के उड़नेवाले पक्षियों की भी सृष्टि की; और परमेश्वर ने देखा कि अच्छा है। ");
INSERT INTO hin2017_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","परमेश्वर ने यह कहकर उनको आशीष दी, “फूलो-फलो, और समुद्र के जल में भर जाओ, और पक्षी पृथ्वी पर बढ़ें।” ");
INSERT INTO hin2017_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","तथा साँझ हुई फिर भोर हुआ। इस प्रकार पाँचवाँ दिन हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","फिर परमेश्वर ने कहा, “पृथ्वी से एक-एक जाति के जीवित प्राणी, अर्थात् घरेलू पशु, और रेंगनेवाले जन्तु, और पृथ्वी के वन पशु, जाति-जाति के अनुसार उत्पन्न हों,” और वैसा ही हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","इस प्रकार परमेश्वर ने पृथ्वी के जाति-जाति के वन-पशुओं को, और जाति-जाति के घरेलू पशुओं को, और जाति-जाति के भूमि पर सब रेंगनेवाले जन्तुओं को बनाया; और परमेश्वर ने देखा कि अच्छा है। ");
INSERT INTO hin2017_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","फिर परमेश्वर ने कहा, “हम मनुष्य को अपने स्वरूप के अनुसार अपनी समानता में बनाएँ; और वे समुद्र की मछलियों, और आकाश के पक्षियों, और घरेलू पशुओं, और सारी पृथ्वी पर, और सब रेंगनेवाले जन्तुओं पर जो पृथ्वी पर रेंगते हैं, अधिकार रखें।” (याकू. 3:9) ");
INSERT INTO hin2017_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","तब परमेश्वर ने अपने स्वरूप में मनुष्य को रचा, अपने ही स्वरूप में परमेश्वर ने मनुष्य की रचना की; नर और नारी के रूप में उसने मनुष्यों की सृष्टि की। (मत्ती 19:4, मर. 10:6, प्रेरि. 17:29, 1 कुरि. 11:7, कुलु. 3:10, 1 तीमु. 2:13) ");
INSERT INTO hin2017_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","और परमेश्वर ने उनको आशीष दी; और उनसे कहा, “फूलो-फलो, और पृथ्वी में भर जाओ, और उसको अपने वश में कर लो; और समुद्र की मछलियों, तथा आकाश के पक्षियों, और पृथ्वी पर रेंगनेवाले सब जन्तुओं पर अधिकार रखो।” ");
INSERT INTO hin2017_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","फिर परमेश्वर ने उनसे कहा, “सुनो, जितने बीजवाले छोटे-छोटे पेड़ सारी पृथ्वी के ऊपर हैं और जितने वृक्षों में बीजवाले फल होते हैं, वे सब मैंने तुम को दिए हैं; वे तुम्हारे भोजन के लिये हैं; (रोम. 14:2) ");
INSERT INTO hin2017_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","और जितने पृथ्वी के पशु, और आकाश के पक्षी, और पृथ्वी पर रेंगनेवाले जन्तु हैं, जिनमें जीवन का प्राण हैं, उन सब के खाने के लिये मैंने सब हरे-हरे छोटे पेड़ दिए हैं,” और वैसा ही हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","तब परमेश्वर ने जो कुछ बनाया था, सब को देखा, तो क्या देखा, कि वह बहुत ही अच्छा है। तथा साँझ हुई फिर भोर हुआ। इस प्रकार छठवाँ दिन हो गया। (1 तीमु. 4:4) ");
INSERT INTO hin2017_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","इस तरह आकाश और पृथ्वी और उनकी सारी सेना का बनाना समाप्त हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","और परमेश्वर ने अपना काम जिसे वह करता था सातवें दिन समाप्त किया, और उसने अपने किए हुए सारे काम से सातवें दिन विश्राम किया। (इब्रा. 4:4) ");
INSERT INTO hin2017_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","और परमेश्वर ने सातवें दिन को आशीष दी और पवित्र ठहराया; क्योंकि उसमें उसने सृष्टि की रचना के अपने सारे काम से विश्राम लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","आकाश और पृथ्वी की उत्पत्ति का वृत्तान्त यह है कि जब वे उत्पन्न हुए अर्थात् जिस दिन यहोवा परमेश्वर ने पृथ्वी और आकाश को बनाया। ");
INSERT INTO hin2017_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","तब मैदान का कोई पौधा भूमि पर न था, और न मैदान का कोई छोटा पेड़ उगा था, क्योंकि यहोवा परमेश्वर ने पृथ्वी पर जल नहीं बरसाया था, और भूमि पर खेती करने के लिये मनुष्य भी नहीं था। ");
INSERT INTO hin2017_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","लेकिन कुहरा पृथ्वी से उठता था जिससे सारी भूमि सिंच जाती थी। ");
INSERT INTO hin2017_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","तब यहोवा परमेश्वर ने आदम को भूमि की मिट्टी से रचा, और उसके नथनों में जीवन का श्वास फूँक दिया; और आदम जीवित प्राणी बन गया। (1 कुरि. 15:45) ");
INSERT INTO hin2017_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","और यहोवा परमेश्वर ने पूर्व की ओर, अदन में एक वाटिका लगाई; और वहाँ आदम को जिसे उसने रचा था, रख दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","और यहोवा परमेश्वर ने भूमि से सब भाँति के वृक्ष, जो देखने में मनोहर और जिनके फल खाने में अच्छे हैं, उगाए, और वाटिका के बीच में जीवन के वृक्ष को और भले या बुरे के ज्ञान के वृक्ष को भी लगाया। (प्रका. 2:7, प्रका. 22:14) ");
INSERT INTO hin2017_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","उस वाटिका को सींचने के लिये एक महानदी अदन से निकली और वहाँ से आगे बहकर चार नदियों में बँट गई। (प्रका. 22:2) ");
INSERT INTO hin2017_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","पहली नदी का नाम पीशोन है, यह वही है जो हवीला नाम के सारे देश को जहाँ सोना मिलता है घेरे हुए है। ");
INSERT INTO hin2017_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","उस देश का सोना उत्तम होता है; वहाँ मोती और सुलैमानी पत्थर भी मिलते हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","और दूसरी नदी का नाम गीहोन है; यह वही है जो कूश के सारे देश को घेरे हुए है। ");
INSERT INTO hin2017_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","और तीसरी नदी का नाम हिद्देकेल है; यह वही है जो अश्शूर के पूर्व की ओर बहती है। और चौथी नदी का नाम फरात है। ");
INSERT INTO hin2017_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","तब यहोवा परमेश्वर ने आदम को लेकर अदन की वाटिका में रख दिया, कि वह उसमें काम करे और उसकी रखवाली करे। ");
INSERT INTO hin2017_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","और यहोवा परमेश्वर ने आदम को यह आज्ञा दी, “तू वाटिका के किसी भी वृक्षों का फल खा सकता है; ");
INSERT INTO hin2017_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","पर भले या बुरे के ज्ञान का जो वृक्ष है, उसका फल तू कभी न खाना: क्योंकि जिस दिन तू उसका फल खाएगा उसी दिन अवश्य मर जाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","फिर यहोवा परमेश्वर ने कहा, “आदम का अकेला रहना अच्छा नहीं; मैं उसके लिये एक ऐसा सहायक बनाऊँगा जो उसके लिये उपयुक्त होगा।” (1 कुरि. 11:9) ");
INSERT INTO hin2017_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","और यहोवा परमेश्वर भूमि में से सब जाति के जंगली पशुओं, और आकाश के सब भाँति के पक्षियों को रचकर आदम के पास ले आया कि देखे, कि वह उनका क्या-क्या नाम रखता है; और जिस-जिस जीवित प्राणी का जो-जो नाम आदम ने रखा वही उसका नाम हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","अतः आदम ने सब जाति के घरेलू पशुओं, और आकाश के पक्षियों, और सब जाति के जंगली पशुओं के नाम रखे; परन्तु आदम के लिये कोई ऐसा सहायक न मिला जो उससे मेल खा सके। ");
INSERT INTO hin2017_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","तब यहोवा परमेश्वर ने आदम को गहरी नींद में डाल दिया, और जब वह सो गया तब उसने उसकी एक पसली निकालकर उसकी जगह माँस भर दिया। (1 कुरि. 11:8) ");
INSERT INTO hin2017_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","और यहोवा परमेश्वर ने उस पसली को जो उसने आदम में से निकाली थी, स्त्री बना दिया; और उसको आदम के पास ले आया। (1 तीमु. 2:13) ");
INSERT INTO hin2017_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","तब आदम ने कहा, “अब यह मेरी हड्डियों में की हड्डी और मेरे माँस में का माँस है; इसलिए इसका नाम नारी होगा, क्योंकि यह नर में से निकाली गई है।” ");
INSERT INTO hin2017_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","इस कारण पुरुष अपने माता-पिता को छोड़कर अपनी पत्नी से मिला रहेगा और वे एक ही तन बने रहेंगे। (मत्ती 19:5, मर. 10:7,8, इफि. 5:31) ");
INSERT INTO hin2017_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","आदम और उसकी पत्नी दोनों नंगे थे, पर वे लज्जित न थे। ");
INSERT INTO hin2017_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","यहोवा परमेश्वर ने जितने जंगली पशु बनाए थे, उन सब में सर्प धूर्त था, और उसने स्त्री से कहा, “क्या सच है, कि परमेश्वर ने कहा, ‘तुम इस वाटिका के किसी वृक्ष का फल न खाना’?” (प्रका. 12:9, प्रका. 20:2) ");
INSERT INTO hin2017_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","स्त्री ने सर्प से कहा, “इस वाटिका के वृक्षों के फल हम खा सकते हैं; ");
INSERT INTO hin2017_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","पर जो वृक्ष वाटिका के बीच में है, उसके फल के विषय में परमेश्वर ने कहा है कि न तो तुम उसको खाना और न ही उसको छूना, नहीं तो मर जाओगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","तब सर्प ने स्त्री से कहा, “तुम निश्चय न मरोगे ");
INSERT INTO hin2017_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","वरन् परमेश्वर आप जानता है कि जिस दिन तुम उसका फल खाओगे उसी दिन तुम्हारी आँखें खुल जाएँगी, और तुम भले बुरे का ज्ञान पाकर परमेश्वर के तुल्य हो जाओगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","अतः जब स्त्री ने देखा कि उस वृक्ष का फल खाने में अच्छा, और देखने में मनभाऊ, और बुद्धि देने के लिये चाहने योग्य भी है, तब उसने उसमें से तोड़कर खाया; और अपने पति को भी दिया, जो उसके साथ था और उसने भी खाया। (1 तीमु. 2:14) ");
INSERT INTO hin2017_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","तब उन दोनों की आँखें खुल गईं, और उनको मालूम हुआ कि वे नंगे हैं; इसलिए उन्होंने अंजीर के पत्ते जोड़-जोड़कर लंगोट बना लिये। ");
INSERT INTO hin2017_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","तब यहोवा परमेश्वर, जो दिन के ठंडे समय वाटिका में फिरता था, उसका शब्द उनको सुनाई दिया। तब आदम और उसकी पत्नी वाटिका के वृक्षों के बीच यहोवा परमेश्वर से छिप गए। ");
INSERT INTO hin2017_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","तब यहोवा परमेश्वर ने पुकारकर आदम से पूछा, “तू कहाँ है?” ");
INSERT INTO hin2017_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","उसने कहा, “मैं तेरा शब्द वाटिका में सुनकर डर गया, क्योंकि मैं नंगा था; इसलिए छिप गया।” ");
INSERT INTO hin2017_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","यहोवा परमेश्वर ने कहा, “किसने तुझे बताया कि तू नंगा है? जिस वृक्ष का फल खाने को मैंने तुझे मना किया था, क्या तूने उसका फल खाया है?” ");
INSERT INTO hin2017_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","आदम ने कहा, “जिस स्त्री को तूने मेरे संग रहने को दिया है उसी ने उस वृक्ष का फल मुझे दिया, और मैंने खाया।” ");
INSERT INTO hin2017_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","तब यहोवा परमेश्वर ने स्त्री से कहा, “तूने यह क्या किया है?” स्त्री ने कहा, “सर्प ने मुझे बहका दिया, तब मैंने खाया।” (रोम. 7:11, 2 कुरि. 11:3, 1 तीमु. 2:14) ");
INSERT INTO hin2017_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","तब यहोवा परमेश्वर ने सर्प से कहा, “तूने जो यह किया है इसलिए तू सब घरेलू पशुओं, और सब जंगली पशुओं से अधिक श्रापित है; तू पेट के बल चला करेगा, और जीवन भर मिट्टी चाटता रहेगा; ");
INSERT INTO hin2017_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","और मैं तेरे और इस स्त्री के बीच में, और तेरे वंश और इसके वंश के बीच में बैर उत्पन्न करूँगा, वह तेरे सिर को कुचल डालेगा, और तू उसकी एड़ी को डसेगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","फिर स्त्री से उसने कहा, “मैं तेरी पीड़ा और तेरे गर्भवती होने के दुःख को बहुत बढ़ाऊँगा; तू पीड़ित होकर बच्चे उत्पन्न करेगी; और तेरी लालसा तेरे पति की ओर होगी, और वह तुझ पर प्रभुता करेगा।” (1 कुरि. 11:3, इफि. 5:22, कुलु. 3:18) ");
INSERT INTO hin2017_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","और आदम से उसने कहा, “तूने जो अपनी पत्नी की बात सुनी, और जिस वृक्ष के फल के विषय मैंने तुझे आज्ञा दी थी कि तू उसे न खाना, उसको तूने खाया है, इसलिए भूमि तेरे कारण श्रापित है। तू उसकी उपज जीवन भर दुःख के साथ खाया करेगा; (इब्रा. 6:8) ");
INSERT INTO hin2017_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","और वह तेरे लिये काँटे और ऊँटकटारे उगाएगी, और तू खेत की उपज खाएगा; ");
INSERT INTO hin2017_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","और अपने माथे के पसीने की रोटी खाया करेगा, और अन्त में मिट्टी में मिल जाएगा; क्योंकि तू उसी में से निकाला गया है, तू मिट्टी तो है और मिट्टी ही में फिर मिल जाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","आदम ने अपनी पत्नी का नाम हव्वा रखा; क्योंकि जितने मनुष्य जीवित हैं उन सब की मूलमाता वही हुई। ");
INSERT INTO hin2017_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","और यहोवा परमेश्वर ने आदम और उसकी पत्नी के लिये चमड़े के वस्त्र बनाकर उनको पहना दिए। ");
INSERT INTO hin2017_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","फिर यहोवा परमेश्वर ने कहा, “मनुष्य भले बुरे का ज्ञान पाकर हम में से एक के समान हो गया है: इसलिए अब ऐसा न हो, कि वह हाथ बढ़ाकर जीवन के वृक्ष का फल भी तोड़कर खा ले और सदा जीवित रहे।” (प्रका. 2:7, प्रका. 22:2,14,19, उत्प. 3:24, प्रका. 2:7) ");
INSERT INTO hin2017_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","इसलिए यहोवा परमेश्वर ने उसको अदन की वाटिका में से निकाल दिया कि वह उस भूमि पर खेती करे जिसमें से वह बनाया गया था। ");
INSERT INTO hin2017_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","इसलिए आदम को उसने निकाल दिया और जीवन के वृक्ष के मार्ग का पहरा देने के लिये अदन की वाटिका के पूर्व की ओर करूबों को, और चारों ओर घूमनेवाली अग्निमय तलवार को भी नियुक्त कर दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","जब आदम अपनी पत्नी हव्वा के पास गया तब उसने गर्भवती होकर कैन को जन्म दिया और कहा, “मैंने यहोवा की सहायता से एक पुत्र को जन्म दिया है।” ");
INSERT INTO hin2017_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","फिर वह उसके भाई हाबिल को भी जन्मी, हाबिल तो भेड़-बकरियों का चरवाहा बन गया, परन्तु कैन भूमि की खेती करनेवाला किसान बना। ");
INSERT INTO hin2017_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","कुछ दिनों के पश्चात् कैन यहोवा के पास भूमि की उपज में से कुछ भेंट ले आया। (यहू. 1:11) ");
INSERT INTO hin2017_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","और हाबिल भी अपनी भेड़-बकरियों के कई एक पहलौठे बच्चे भेंट चढ़ाने ले आया और उनकी चर्बी भेंट चढ़ाई; तब यहोवा ने हाबिल और उसकी भेंट को तो ग्रहण किया, (इब्रा. 11:4) ");
INSERT INTO hin2017_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","परन्तु कैन और उसकी भेंट को उसने ग्रहण न किया। तब कैन अति क्रोधित हुआ, और उसके मुँह पर उदासी छा गई। ");
INSERT INTO hin2017_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","तब यहोवा ने कैन से कहा, “तू क्यों क्रोधित हुआ? और तेरे मुँह पर उदासी क्यों छा गई है? ");
INSERT INTO hin2017_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","यदि तू भला करे, तो क्या तेरी भेंट ग्रहण न की जाएगी? और यदि तू भला न करे, तो पाप द्वार पर छिपा रहता है, और उसकी लालसा तेरी ओर होगी, और तुझे उस पर प्रभुता करनी है।” ");
INSERT INTO hin2017_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","तब कैन ने अपने भाई हाबिल से कुछ कहा; और जब वे मैदान में थे, तब कैन ने अपने भाई हाबिल पर चढ़कर उसकी हत्या कर दी। ");
INSERT INTO hin2017_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","तब यहोवा ने कैन से पूछा, “तेरा भाई हाबिल कहाँ है?” उसने कहा, “मालूम नहीं; क्या मैं अपने भाई का रखवाला हूँ?” ");
INSERT INTO hin2017_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","उसने कहा, “तूने क्या किया है? तेरे भाई का लहू भूमि में से मेरी ओर चिल्लाकर मेरी दुहाई दे रहा है! (इब्रा. 12:24) ");
INSERT INTO hin2017_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","इसलिए अब भूमि जिसने तेरे भाई का लहू तेरे हाथ से पीने के लिये अपना मुँह खोला है, उसकी ओर से तू श्रापित है। ");
INSERT INTO hin2017_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","चाहे तू भूमि पर खेती करे, तो भी उसकी पूरी उपज फिर तुझे न मिलेगी, और तू पृथ्वी पर भटकने वाला और भगोड़ा होगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","तब कैन ने यहोवा से कहा, “मेरा दण्ड असहनीय है। ");
INSERT INTO hin2017_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","देख, तूने आज के दिन मुझे भूमि पर से निकाला है और मैं तेरी दृष्टि की आड़ में रहूँगा और पृथ्वी पर भटकने वाला और भगोड़ा रहूँगा; और जो कोई मुझे पाएगा, मेरी हत्या करेगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","इस कारण यहोवा ने उससे कहा, “जो कोई कैन की हत्या करेगा उससे सात गुणा बदला लिया जाएगा।” और यहोवा ने कैन के लिये एक चिन्ह ठहराया ऐसा न हो कि कोई उसे पाकर मार डाले। ");
INSERT INTO hin2017_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","तब कैन यहोवा के सम्मुख से निकल गया और नोद नामक देश में, जो अदन के पूर्व की ओर है, रहने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","जब कैन अपनी पत्नी के पास गया तब वह गर्भवती हुई और हनोक को जन्म दिया; फिर कैन ने एक नगर बसाया और उस नगर का नाम अपने पुत्र के नाम पर हनोक रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोक से ईराद उत्पन्न हुआ, और ईराद से महूयाएल उत्पन्न हुआ और महूयाएल से मतूशाएल, और मतूशाएल से लेमेक उत्पन्न हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लेमेक ने दो स्त्रियाँ ब्याह लीं: जिनमें से एक का नाम आदा और दूसरी का सिल्ला है। ");
INSERT INTO hin2017_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदा ने याबाल को जन्म दिया। वह उन लोगों का पिता था जो तम्बुओं में रहते थे और पशुओं का पालन करके जीवन निर्वाह करते थे। ");
INSERT INTO hin2017_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","उसके भाई का नाम यूबाल था: वह उन लोगों का पिता था जो वीणा और बाँसुरी बजाते थे। ");
INSERT INTO hin2017_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","और सिल्ला ने भी तूबल-कैन नामक एक पुत्र को जन्म दिया: वह पीतल और लोहे के सब धारवाले हथियारों का गढ़नेवाला हुआ। और तूबल-कैन की बहन नामाह थी। ");
INSERT INTO hin2017_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","लेमेक ने अपनी पत्नियों से कहा, “हे आदा और हे सिल्ला मेरी सुनो; हे लेमेक की पत्नियों, मेरी बात पर कान लगाओ: मैंने एक पुरुष को जो मुझे चोट लगाता था, अर्थात् एक जवान को जो मुझे घायल करता था, घात किया है। ");
INSERT INTO hin2017_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","जब कैन का बदला सात गुणा लिया जाएगा। तो लेमेक का सतहत्तर गुणा लिया जाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","और आदम अपनी पत्नी के पास फिर गया; और उसने एक पुत्र को जन्म दिया और उसका नाम यह कहकर शेत रखा कि “परमेश्वर ने मेरे लिये हाबिल के बदले, जिसको कैन ने मारा था, एक और वंश प्रदान किया।” (उत्प. 5:3,4) ");
INSERT INTO hin2017_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","और शेत के भी एक पुत्र उत्पन्न हुआ और उसने उसका नाम एनोश रखा। उसी समय से लोग यहोवा से प्रार्थना करने लगे। ");
INSERT INTO hin2017_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","आदम की वंशावली यह है। जब परमेश्वर ने मनुष्य की सृष्टि की तब अपने ही स्वरूप में उसको बनाया। (मत्ती 1:1, 1 कुरि. 11:7) ");
INSERT INTO hin2017_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","उसने नर और नारी करके मनुष्यों की सृष्टि की और उन्हें आशीष दी, और उनकी सृष्टि के दिन उनका नाम आदम रखा। (मत्ती 19:4, मर. 10:6) ");
INSERT INTO hin2017_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","जब आदम एक सौ तीस वर्ष का हुआ, तब उसके द्वारा उसकी समानता में उस ही के स्वरूप के अनुसार एक पुत्र उत्पन्न हुआ। उसने उसका नाम शेत रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","और शेत के जन्म के पश्चात् आदम आठ सौ वर्ष जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","इस प्रकार आदम की कुल आयु नौ सौ तीस वर्ष की हुई, तत्पश्चात् वह मर गया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","जब शेत एक सौ पाँच वर्ष का हुआ, उससे एनोश उत्पन्न हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","एनोश के जन्म के पश्चात् शेत आठ सौ सात वर्ष जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","इस प्रकार शेत की कुल आयु नौ सौ बारह वर्ष की हुई; तत्पश्चात् वह मर गया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","जब एनोश नब्बे वर्ष का हुआ, तब उसने केनान को जन्म दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","केनान के जन्म के पश्चात् एनोश आठ सौ पन्द्रह वर्ष जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","इस प्रकार एनोश की कुल आयु नौ सौ पाँच वर्ष की हुई; तत्पश्चात् वह मर गया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","जब केनान सत्तर वर्ष का हुआ, तब उसने महललेल को जन्म दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","महललेल के जन्म के पश्चात् केनान आठ सौ चालीस वर्ष जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","इस प्रकार केनान की कुल आयु नौ सौ दस वर्ष की हुई; तत्पश्चात् वह मर गया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","जब महललेल पैंसठ वर्ष का हुआ, तब उसने येरेद को जन्म दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","येरेद के जन्म के पश्चात् महललेल आठ सौ तीस वर्ष जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","इस प्रकार महललेल की कुल आयु आठ सौ पंचानबे वर्ष की हुई; तत्पश्चात् वह मर गया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","जब येरेद एक सौ बासठ वर्ष का हुआ, तब उसने हनोक को जन्म दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","हनोक के जन्म के पश्चात् येरेद आठ सौ वर्ष जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","इस प्रकार येरेद की कुल आयु नौ सौ बासठ वर्ष की हुई; तत्पश्चात् वह मर गया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","जब हनोक पैंसठ वर्ष का हुआ, तब उसने मतूशेलह को जन्म दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","मतूशेलह के जन्म के पश्चात् हनोक तीन सौ वर्ष तक परमेश्वर के साथ-साथ चलता रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","इस प्रकार हनोक की कुल आयु तीन सौ पैंसठ वर्ष की हुई। ");
INSERT INTO hin2017_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनोक परमेश्वर के साथ-साथ चलता था; फिर वह लोप हो गया क्योंकि परमेश्वर ने उसे उठा लिया। (इब्रा. 11:5) ");
INSERT INTO hin2017_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","जब मतूशेलह एक सौ सत्तासी वर्ष का हुआ, तब उसने लेमेक को जन्म दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","लेमेक के जन्म के पश्चात् मतूशेलह सात सौ बयासी वर्ष जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","इस प्रकार मतूशेलह की कुल आयु नौ सौ उनहत्तर वर्ष की हुई; तत्पश्चात् वह मर गया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","जब लेमेक एक सौ बयासी वर्ष का हुआ, तब उससे एक पुत्र का जन्म हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","उसने यह कहकर उसका नाम नूह रखा, कि “यहोवा ने जो पृथ्वी को श्राप दिया है, उसके विषय यह लड़का हमारे काम में, और उस कठिन परिश्रम में जो हम करते हैं, हमें शान्ति देगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","नूह के जन्म के पश्चात् लेमेक पाँच सौ पंचानबे वर्ष जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","इस प्रकार लेमेक की कुल आयु सात सौ सतहत्तर वर्ष की हुई; तत्पश्चात् वह मर गया। ");
INSERT INTO hin2017_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","और नूह पाँच सौ वर्ष का हुआ; और नूह से शेम, और हाम और येपेत का जन्म हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","फिर जब मनुष्य भूमि के ऊपर बहुत बढ़ने लगे, और उनके बेटियाँ उत्पन्न हुईं, ");
INSERT INTO hin2017_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","तब परमेश्वर के पुत्रों ने मनुष्य की पुत्रियों को देखा, कि वे सुन्दर हैं; और उन्होंने जिस-जिसको चाहा उनसे ब्याह कर लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","तब यहोवा ने कहा, “मेरा आत्मा मनुष्य में सदा के लिए निवास न करेगा, क्योंकि मनुष्य भी शरीर ही है; उसकी आयु एक सौ बीस वर्ष की होगी।” ");
INSERT INTO hin2017_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","उन दिनों में पृथ्वी पर दानव रहते थे; और इसके पश्चात् जब परमेश्वर के पुत्र मनुष्य की पुत्रियों के पास गए तब उनके द्वारा जो सन्तान उत्पन्न हुए, वे पुत्र शूरवीर होते थे, जिनकी कीर्ति प्राचीनकाल से प्रचलित है। ");
INSERT INTO hin2017_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","यहोवा ने देखा कि मनुष्यों की बुराई पृथ्वी पर बढ़ गई है, और उनके मन के विचार में जो कुछ उत्पन्न होता है वह निरन्तर बुरा ही होता है। (भज. 53:2) ");
INSERT INTO hin2017_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","और यहोवा पृथ्वी पर मनुष्य को बनाने से पछताया, और वह मन में अति खेदित हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","तब यहोवा ने कहा, “मैं मनुष्य को जिसकी मैंने सृष्टि की है पृथ्वी के ऊपर से मिटा दूँगा; क्या मनुष्य, क्या पशु, क्या रेंगनेवाले जन्तु, क्या आकाश के पक्षी, सब को मिटा दूँगा, क्योंकि मैं उनके बनाने से पछताता हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","परन्तु यहोवा के अनुग्रह की दृष्टि नूह पर बनी रही। ");
INSERT INTO hin2017_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","नूह की वंशावली यह है। नूह धर्मी पुरुष और अपने समय के लोगों में खरा था; और नूह परमेश्वर ही के साथ-साथ चलता रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","और नूह से शेम, और हाम, और येपेत नामक, तीन पुत्र उत्पन्न हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","उस समय पृथ्वी परमेश्वर की दृष्टि में बिगड़ गई थी, और उपद्रव से भर गई थी। ");
INSERT INTO hin2017_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","और परमेश्वर ने पृथ्वी पर जो दृष्टि की तो क्या देखा कि वह बिगड़ी हुई है; क्योंकि सब प्राणियों ने पृथ्वी पर अपना-अपना चाल-चलन बिगाड़ लिया था। ");
INSERT INTO hin2017_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","तब परमेश्वर ने नूह से कहा, “सब प्राणियों के अन्त करने का प्रश्न मेरे सामने आ गया है; क्योंकि उनके कारण पृथ्वी उपद्रव से भर गई है, इसलिए मैं उनको पृथ्वी समेत नाश कर डालूँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","इसलिए तू गोपेर वृक्ष की लकड़ी का एक जहाज बना ले, उसमें कोठरियाँ बनाना, और भीतर-बाहर उस पर राल लगाना। ");
INSERT INTO hin2017_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","इस ढंग से तू उसको बनाना: जहाज की लम्बाई तीन सौ हाथ, चौड़ाई पचास हाथ, और ऊँचाई तीस हाथ की हो। ");
INSERT INTO hin2017_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","जहाज में एक खिड़की बनाना, और उसके एक हाथ ऊपर से उसकी छत बनाना, और जहाज की एक ओर एक द्वार रखना, और जहाज में पहला, दूसरा, तीसरा खण्ड बनाना। ");
INSERT INTO hin2017_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","और सुन, मैं आप पृथ्वी पर जल-प्रलय करके सब प्राणियों को, जिनमें जीवन का श्वास है, आकाश के नीचे से नाश करने पर हूँ; और सब जो पृथ्वी पर हैं मर जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","परन्तु तेरे संग मैं वाचा बाँधता हूँ; इसलिए तू अपने पुत्रों, स्त्री, और बहुओं समेत जहाज में प्रवेश करना। ");
INSERT INTO hin2017_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","और सब जीवित प्राणियों में से, तू एक-एक जाति के दो-दो, अर्थात् एक नर और एक मादा जहाज में ले जाकर, अपने साथ जीवित रखना। ");
INSERT INTO hin2017_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","एक-एक जाति के पक्षी, और एक-एक जाति के पशु, और एक-एक जाति के भूमि पर रेंगनेवाले, सब में से दो-दो तेरे पास आएँगे, कि तू उनको जीवित रखे। ");
INSERT INTO hin2017_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","और भाँति-भाँति का भोजन पदार्थ जो खाया जाता है, उनको तू लेकर अपने पास इकट्ठा कर रखना; जो तेरे और उनके भोजन के लिये होगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","परमेश्वर की इस आज्ञा के अनुसार नूह ने किया। ");
INSERT INTO hin2017_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","तब यहोवा ने नूह से कहा, “तू अपने सारे घराने समेत जहाज में जा; क्योंकि मैंने इस समय के लोगों में से केवल तुझी को अपनी दृष्टि में धर्मी पाया है। ");
INSERT INTO hin2017_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","सब जाति के शुद्ध पशुओं में से तो तू सात-सात जोड़े, अर्थात् नर और मादा लेना: पर जो पशु शुद्ध नहीं हैं, उनमें से दो-दो लेना, अर्थात् नर और मादा: ");
INSERT INTO hin2017_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","और आकाश के पक्षियों में से भी, सात-सात जोड़े, अर्थात् नर और मादा लेना, कि उनका वंश बचकर सारी पृथ्वी के ऊपर बना रहे। ");
INSERT INTO hin2017_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","क्योंकि अब सात दिन और बीतने पर मैं पृथ्वी पर चालीस दिन और चालीस रात तक जल बरसाता रहूँगा; और जितने प्राणी मैंने बनाए हैं उन सब को भूमि के ऊपर से मिटा दूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","यहोवा की इस आज्ञा के अनुसार नूह ने किया। ");
INSERT INTO hin2017_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","नूह की आयु छः सौ वर्ष की थी, जब जल-प्रलय पृथ्वी पर आया। ");
INSERT INTO hin2017_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","नूह अपने पुत्रों, पत्नी और बहुओं समेत, जल-प्रलय से बचने के लिये जहाज में गया। ");
INSERT INTO hin2017_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","शुद्ध, और अशुद्ध दोनों प्रकार के पशुओं में से, पक्षियों, ");
INSERT INTO hin2017_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","और भूमि पर रेंगनेवालों में से भी, दो-दो, अर्थात् नर और मादा, जहाज में नूह के पास गए, जिस प्रकार परमेश्वर ने नूह को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","सात दिन के उपरान्त प्रलय का जल पृथ्वी पर आने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","जब नूह की आयु के छः सौवें वर्ष के दूसरे महीने का सत्रहवाँ दिन आया; उसी दिन बड़े गहरे समुद्र के सब सोते फूट निकले और आकाश के झरोखे खुल गए। ");
INSERT INTO hin2017_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","और वर्षा चालीस दिन और चालीस रात निरन्तर पृथ्वी पर होती रही। ");
INSERT INTO hin2017_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ठीक उसी दिन नूह अपने पुत्र शेम, हाम, और येपेत, और अपनी पत्नी, और तीनों बहुओं समेत, ");
INSERT INTO hin2017_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","और उनके संग एक-एक जाति के सब जंगली पशु, और एक-एक जाति के सब घरेलू पशु, और एक-एक जाति के सब पृथ्वी पर रेंगनेवाले, और एक-एक जाति के सब उड़नेवाले पक्षी, जहाज में गए। ");
INSERT INTO hin2017_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","जितने प्राणियों में जीवन का श्वास था उनकी सब जातियों में से दो-दो नूह के पास जहाज में गए। ");
INSERT INTO hin2017_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","और जो गए, वह परमेश्वर की आज्ञा के अनुसार सब जाति के प्राणियों में से नर और मादा गए। तब यहोवा ने जहाज का द्वार बन्द कर दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","पृथ्वी पर चालीस दिन तक जल-प्रलय होता रहा; और पानी बहुत बढ़ता ही गया, जिससे जहाज ऊपर को उठने लगा, और वह पृथ्वी पर से ऊँचा उठ गया। ");
INSERT INTO hin2017_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","जल बढ़ते-बढ़ते पृथ्वी पर बहुत ही बढ़ गया, और जहाज जल के ऊपर-ऊपर तैरता रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","जल पृथ्वी पर अत्यन्त बढ़ गया, यहाँ तक कि सारी धरती पर जितने बड़े-बड़े पहाड़ थे, सब डूब गए। ");
INSERT INTO hin2017_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","जल तो पन्द्रह हाथ ऊपर बढ़ गया, और पहाड़ भी डूब गए। ");
INSERT INTO hin2017_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","और क्या पक्षी, क्या घरेलू पशु, क्या जंगली पशु, और पृथ्वी पर सब चलनेवाले प्राणी, और जितने जन्तु पृथ्वी में बहुतायत से भर गए थे, वे सब, और सब मनुष्य मर गए। ");
INSERT INTO hin2017_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","जो-जो भूमि पर थे उनमें से जितनों के नथनों में जीवन का श्वास था, सब मर मिटे। ");
INSERT INTO hin2017_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","और क्या मनुष्य, क्या पशु, क्या रेंगनेवाले जन्तु, क्या आकाश के पक्षी, जो-जो भूमि पर थे, सब पृथ्वी पर से मिट गए; केवल नूह, और जितने उसके संग जहाज में थे, वे ही बच गए। ");
INSERT INTO hin2017_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","और जल पृथ्वी पर एक सौ पचास दिन तक प्रबल रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","परमेश्वर ने नूह और जितने जंगली पशु और घरेलू पशु उसके संग जहाज में थे, उन सभी की सुधि ली: और परमेश्वर ने पृथ्वी पर पवन बहाई, और जल घटने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","गहरे समुद्र के सोते और आकाश के झरोखे बंद हो गए; और उससे जो वर्षा होती थी वह भी थम गई। ");
INSERT INTO hin2017_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","और एक सौ पचास दिन के पश्चात् जल पृथ्वी पर से लगातार घटने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","सातवें महीने के सत्रहवें दिन को, जहाज अरारात नामक पहाड़ पर टिक गया। ");
INSERT INTO hin2017_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","और जल दसवें महीने तक घटता चला गया, और दसवें महीने के पहले दिन को, पहाड़ों की चोटियाँ दिखाई दीं। ");
INSERT INTO hin2017_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","फिर ऐसा हुआ कि चालीस दिन के पश्चात् नूह ने अपने बनाए हुए जहाज की खिड़की को खोलकर, ");
INSERT INTO hin2017_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","एक कौआ उड़ा दिया: जब तक जल पृथ्वी पर से सूख न गया, तब तक कौआ इधर-उधर फिरता रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","फिर उसने अपने पास से एक कबूतरी को भी उड़ा दिया कि देखे कि जल भूमि से घट गया कि नहीं। ");
INSERT INTO hin2017_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","उस कबूतरी को अपने पैर टेकने के लिये कोई आधार न मिला, तो वह उसके पास जहाज में लौट आई: क्योंकि सारी पृथ्वी के ऊपर जल ही जल छाया था तब उसने हाथ बढ़ाकर उसे अपने पास जहाज में ले लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","तब और सात दिन तक ठहरकर, उसने उसी कबूतरी को जहाज में से फिर उड़ा दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","और कबूतरी साँझ के समय उसके पास आ गई, तो क्या देखा कि उसकी चोंच में जैतून का एक नया पत्ता है; इससे नूह ने जान लिया, कि जल पृथ्वी पर घट गया है। ");
INSERT INTO hin2017_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","फिर उसने सात दिन और ठहरकर उसी कबूतरी को उड़ा दिया; और वह उसके पास फिर कभी लौटकर न आई। ");
INSERT INTO hin2017_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","नूह की आयु के छः सौ एक वर्ष के पहले महीने के पहले दिन जल पृथ्वी पर से सूख गया। तब नूह ने जहाज की छत खोलकर क्या देखा कि धरती सूख गई है। ");
INSERT INTO hin2017_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","और दूसरे महीने के सताईसवें दिन को पृथ्वी पूरी रीति से सूख गई। ");
INSERT INTO hin2017_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","तब परमेश्वर ने नूह से कहा, ");
INSERT INTO hin2017_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“तू अपने पुत्रों, पत्नी और बहुओं समेत जहाज में से निकल आ। ");
INSERT INTO hin2017_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","क्या पक्षी, क्या पशु, क्या सब भाँति के रेंगनेवाले जन्तु जो पृथ्वी पर रेंगते हैं; जितने शरीरधारी जीव-जन्तु तेरे संग हैं, उन सब को अपने साथ निकाल ले आ कि पृथ्वी पर उनसे बहुत बच्चे उत्पन्न हों; और वे फूलें-फलें, और पृथ्वी पर फैल जाएँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","तब नूह और उसके पुत्र और पत्नी और बहुएँ, निकल आईं। (2 पत. 2:5) ");
INSERT INTO hin2017_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","और सब चौपाए, रेंगनेवाले जन्तु, और पक्षी, और जितने जीवजन्तु पृथ्वी पर चलते फिरते हैं, सब जाति-जाति करके जहाज में से निकल आए। ");
INSERT INTO hin2017_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","तब नूह ने यहोवा के लिये एक वेदी बनाई; और सब शुद्ध पशुओं, और सब शुद्ध पक्षियों में से, कुछ कुछ लेकर वेदी पर होमबलि चढ़ाया। ");
INSERT INTO hin2017_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","इस पर यहोवा ने सुखदायक सुगन्ध पाकर सोचा, “मनुष्य के कारण मैं फिर कभी भूमि को श्राप न दूँगा, यद्यपि मनुष्य के मन में बचपन से जो कुछ उत्पन्न होता है वह बुरा ही होता है; तो भी जैसा मैंने सब जीवों को अब मारा है, वैसा उनको फिर कभी न मारूँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","अब से जब तक पृथ्वी बनी रहेगी, तब तक बोने और काटने के समय, ठंडा और तपन, धूपकाल और शीतकाल, दिन और रात, निरन्तर होते चले जाएँगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","फिर परमेश्वर ने नूह और उसके पुत्रों को आशीष दी और उनसे कहा, “फूलो-फलो और बढ़ो और पृथ्वी में भर जाओ। ");
INSERT INTO hin2017_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","तुम्हारा डर और भय पृथ्वी के सब पशुओं, और आकाश के सब पक्षियों, और भूमि पर के सब रेंगनेवाले जन्तुओं, और समुद्र की सब मछलियों पर बना रहेगा वे सब तुम्हारे वश में कर दिए जाते हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","सब चलनेवाले जन्तु तुम्हारा आहार होंगे; जैसे तुम को हरे-हरे छोटे पेड़ दिए थे, वैसे ही तुम्हें सब कुछ देता हूँ। (उत्प. 1:29,30) ");
INSERT INTO hin2017_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","पर माँस को प्राण समेत अर्थात् लहू समेत तुम न खाना। (व्यव. 12:23) ");
INSERT INTO hin2017_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","और निश्चय मैं तुम्हारा लहू अर्थात् प्राण का बदला लूँगा: सब पशुओं, और मनुष्यों, दोनों से मैं उसे लूँगा; मनुष्य के प्राण का बदला मैं एक-एक के भाई-बन्धु से लूँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","जो कोई मनुष्य का लहू बहाएगा उसका लहू मनुष्य ही से बहाया जाएगा क्योंकि परमेश्वर ने मनुष्य को अपने ही स्वरूप के अनुसार बनाया है। (लैव्य. 24:17) ");
INSERT INTO hin2017_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","और तुम तो फूलो-फलो और बढ़ो और पृथ्वी पर बहुतायत से सन्तान उत्पन्न करके उसमें भर जाओ।” ");
INSERT INTO hin2017_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","फिर परमेश्वर ने नूह और उसके पुत्रों से कहा, ");
INSERT INTO hin2017_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“सुनो, मैं तुम्हारे साथ और तुम्हारे पश्चात् जो तुम्हारा वंश होगा, उसके साथ भी वाचा बाँधता हूँ; ");
INSERT INTO hin2017_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","और सब जीवित प्राणियों से भी जो तुम्हारे संग हैं, क्या पक्षी क्या घरेलू पशु, क्या पृथ्वी के सब जंगली पशु, पृथ्वी के जितने जीवजन्तु जहाज से निकले हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","और मैं तुम्हारे साथ अपनी यह वाचा बाँधता हूँ कि सब प्राणी फिर जल-प्रलय से नाश न होंगे और पृथ्वी का नाश करने के लिये फिर जल-प्रलय न होगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","फिर परमेश्वर ने कहा, “जो वाचा मैं तुम्हारे साथ, और जितने जीवित प्राणी तुम्हारे संग हैं उन सब के साथ भी युग-युग की पीढ़ियों के लिये बाँधता हूँ; उसका यह चिन्ह है: ");
INSERT INTO hin2017_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","कि मैंने बादल में अपना धनुष रखा है, वह मेरे और पृथ्वी के बीच में वाचा का चिन्ह होगा। ");
INSERT INTO hin2017_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","और जब मैं पृथ्वी पर बादल फैलाऊं तब बादल में धनुष दिखाई देगा। ");
INSERT INTO hin2017_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","तब मेरी जो वाचा तुम्हारे और सब जीवित शरीरधारी प्राणियों के साथ बंधी है; उसको मैं स्मरण करूँगा, तब ऐसा जल-प्रलय फिर न होगा जिससे सब प्राणियों का विनाश हो। ");
INSERT INTO hin2017_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","बादल में जो धनुष होगा मैं उसे देखकर यह सदा की वाचा स्मरण करूँगा, जो परमेश्वर के और पृथ्वी पर के सब जीवित शरीरधारी प्राणियों के बीच बंधी है।” ");
INSERT INTO hin2017_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","फिर परमेश्वर ने नूह से कहा, “जो वाचा मैंने पृथ्वी भर के सब प्राणियों के साथ बाँधी है, उसका चिन्ह यही है।” ");
INSERT INTO hin2017_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","नूह के जो पुत्र जहाज में से निकले, वे शेम, हाम और येपेत थे; और हाम कनान का पिता हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","नूह के तीन पुत्र ये ही हैं, और इनका वंश सारी पृथ्वी पर फैल गया। ");
INSERT INTO hin2017_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नूह किसानी करने लगा: और उसने दाख की बारी लगाई। ");
INSERT INTO hin2017_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","और वह दाखमधु पीकर मतवाला हुआ; और अपने तम्बू के भीतर नंगा हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","तब कनान के पिता हाम ने, अपने पिता को नंगा देखा, और बाहर आकर अपने दोनों भाइयों को बता दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","तब शेम और येपेत दोनों ने कपड़ा लेकर अपने कंधों पर रखा और पीछे की ओर उलटा चलकर अपने पिता के नंगे तन को ढाँप दिया और वे अपना मुख पीछे किए हुए थे इसलिए उन्होंने अपने पिता को नंगा न देखा। ");
INSERT INTO hin2017_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","जब नूह का नशा उतर गया, तब उसने जान लिया कि उसके छोटे पुत्र ने उसके साथ क्या किया है। ");
INSERT INTO hin2017_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","इसलिए उसने कहा, “कनान श्रापित हो: वह अपने भाई-बन्धुओं के दासों का दास हो।” ");
INSERT INTO hin2017_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","फिर उसने कहा, “शेम का परमेश्वर यहोवा धन्य है, और कनान शेम का दास हो। ");
INSERT INTO hin2017_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","परमेश्वर येपेत के वंश को फैलाए; और वह शेम के तम्बुओं में बसे, और कनान उसका दास हो।” ");
INSERT INTO hin2017_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","जल-प्रलय के पश्चात् नूह साढ़े तीन सौ वर्ष जीवित रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","इस प्रकार नूह की कुल आयु साढ़े नौ सौ वर्ष की हुई; तत्पश्चात् वह मर गया। ");
INSERT INTO hin2017_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","नूह के पुत्र शेम, हाम और येपेत थे; उनके पुत्र जल-प्रलय के पश्चात् उत्पन्न हुए: उनकी वंशावली यह है। ");
INSERT INTO hin2017_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","येपेत के पुत्र: गोमेर, मागोग, मादै, यावान, तूबल, मेशेक और तीरास हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","और गोमेर के पुत्र: अश्कनज, रीपत और तोगर्मा हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","और यावान के वंश में एलीशा और तर्शीश, और कित्ती, और दोदानी लोग हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","इनके वंश अन्यजातियों के द्वीपों के देशों में ऐसे बँट गए कि वे भिन्न-भिन्न भाषाओं, कुलों, और जातियों के अनुसार अलग-अलग हो गए। ");
INSERT INTO hin2017_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","फिर हाम के पुत्र: कूश, मिस्र, पूत और कनान हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","और कूश के पुत्र सबा, हवीला, सबता, रामाह, और सब्तका हुए। और रामाह के पुत्र शेबा और ददान हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कूश के वंश में निम्रोद भी हुआ; पृथ्वी पर पहला वीर वही हुआ है। ");
INSERT INTO hin2017_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","वही यहोवा की दृष्टि में पराक्रमी शिकार खेलनेवाला ठहरा, इससे यह कहावत चली है; “निम्रोद के समान यहोवा की दृष्टि में पराक्रमी शिकार खेलनेवाला।” ");
INSERT INTO hin2017_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","उसके राज्य का आरम्भ शिनार देश में बाबेल, एरेख, अक्कद, और कलने से हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","उस देश से वह निकलकर अश्शूर को गया, और नीनवे, रहोबोतीर और कालह को, ");
INSERT INTO hin2017_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","और नीनवे और कालह के बीच जो रेसेन है, उसे भी बसाया; बड़ा नगर यही है। ");
INSERT INTO hin2017_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिस्र के वंश में लूदी, अनामी, लहाबी, नप्तूही, ");
INSERT INTO hin2017_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","और पत्रूसी, कसलूही, और कप्तोरी लोग हुए, कसलूहियों में से तो पलिश्ती लोग निकले। ");
INSERT INTO hin2017_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनान के वंश में उसका ज्येष्ठ पुत्र सीदोन, तब हित्त, ");
INSERT INTO hin2017_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","यबूसी, एमोरी, गिर्गाशी, ");
INSERT INTO hin2017_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिब्बी, अर्की, सीनी, ");
INSERT INTO hin2017_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अर्वदी, समारी, और हमाती लोग भी हुए; फिर कनानियों के कुल भी फैल गए। ");
INSERT INTO hin2017_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","और कनानियों की सीमा सीदोन से लेकर गरार के मार्ग से होकर गाज़ा तक और फिर सदोम और गमोरा और अदमा और सबोयीम के मार्ग से होकर लाशा तक हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","हाम के वंश में ये ही हुए; और ये भिन्न-भिन्न कुलों, भाषाओं, देशों, और जातियों के अनुसार अलग-अलग हो गए। ");
INSERT INTO hin2017_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","फिर शेम, जो सब एबेरवंशियों का मूलपुरुष हुआ, और जो येपेत का ज्येष्ठ भाई था, उसके भी पुत्र उत्पन्न हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेम के पुत्र: एलाम, अश्शूर, अर्पक्षद, लूद और अराम हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अराम के पुत्र: ऊस, हूल, गेतेर और मश हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","और अर्पक्षद ने शेलह को, और शेलह ने एबेर को जन्म दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","और एबेर के दो पुत्र उत्पन्न हुए, एक का नाम पेलेग इस कारण रखा गया कि उसके दिनों में पृथ्वी बँट गई, और उसके भाई का नाम योक्तान था। ");
INSERT INTO hin2017_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","और योक्तान ने अल्मोदाद, शेलेप, हसर्मावेत, येरह, ");
INSERT INTO hin2017_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हदोराम, ऊजाल, दिक्ला, ");
INSERT INTO hin2017_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबीमाएल, शेबा, ");
INSERT INTO hin2017_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओपीर, हवीला, और योबाब को जन्म दिया: ये ही सब योक्तान के पुत्र हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","इनके रहने का स्थान मेशा से लेकर सपारा, जो पूर्व में एक पहाड़ है, उसके मार्ग तक हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","शेम के पुत्र ये ही हुए; और ये भिन्न-भिन्न कुलों, भाषाओं, देशों और जातियों के अनुसार अलग-अलग हो गए। ");
INSERT INTO hin2017_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","नूह के पुत्रों के घराने ये ही है: और उनकी जातियों के अनुसार उनकी वंशावलियाँ ये ही हैं; और जल-प्रलय के पश्चात् पृथ्वी भर की जातियाँ इन्हीं में से होकर बँट गईं। ");
INSERT INTO hin2017_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","सारी पृथ्वी पर एक ही भाषा, और एक ही बोली थी। ");
INSERT INTO hin2017_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","उस समय लोग पूर्व की ओर चलते-चलते शिनार देश में एक मैदान पाकर उसमें बस गए। ");
INSERT INTO hin2017_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","तब वे आपस में कहने लगे, “आओ, हम ईंटें बना-बनाकर भली भाँति आग में पकाएँ।” और उन्होंने पत्थर के स्थान पर ईंट से, और मिट्टी के गारे के स्थान में चूने से काम लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","फिर उन्होंने कहा, “आओ, हम एक नगर और एक मीनार बना लें, जिसकी चोटी आकाश से बातें करे, इस प्रकार से हम अपना नाम करें, ऐसा न हो कि हमको सारी पृथ्वी पर फैलना पड़े।” ");
INSERT INTO hin2017_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","जब लोग नगर और गुम्मट बनाने लगे; तब उन्हें देखने के लिये यहोवा उतर आया। ");
INSERT INTO hin2017_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","और यहोवा ने कहा, “मैं क्या देखता हूँ, कि सब एक ही दल के हैं और भाषा भी उन सब की एक ही है, और उन्होंने ऐसा ही काम भी आरम्भ किया; और अब जो कुछ वे करने का यत्न करेंगे, उसमें से कुछ भी उनके लिये अनहोना न होगा। ");
INSERT INTO hin2017_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","इसलिए आओ, हम उतरकर उनकी भाषा में बड़ी गड़बड़ी डालें, कि वे एक दूसरे की बोली को न समझ सकें।” ");
INSERT INTO hin2017_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","इस प्रकार यहोवा ने उनको वहाँ से सारी पृथ्वी के ऊपर फैला दिया; और उन्होंने उस नगर का बनाना छोड़ दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","इस कारण उस नगर का नाम बाबेल पड़ा; क्योंकि सारी पृथ्वी की भाषा में जो गड़बड़ी है, वह यहोवा ने वहीं डाली, और वहीं से यहोवा ने मनुष्यों को सारी पृथ्वी के ऊपर फैला दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","शेम की वंशावली यह है। जल-प्रलय के दो वर्ष पश्चात् जब शेम एक सौ वर्ष का हुआ, तब उसने अर्पक्षद को जन्म दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","और अर्पक्षद के जन्म के पश्चात् शेम पाँच सौ वर्ष जीवित रहा; और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","जब अर्पक्षद पैंतीस वर्ष का हुआ, तब उसने शेलह को जन्म दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","और शेलह के जन्म के पश्चात् अर्पक्षद चार सौ तीन वर्ष और जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","जब शेलह तीस वर्ष का हुआ, तब उसके द्वारा एबेर का जन्म हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","और एबेर के जन्म के पश्चात् शेलह चार सौ तीन वर्ष और जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","जब एबेर चौंतीस वर्ष का हुआ, तब उसके द्वारा पेलेग का जन्म हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","और पेलेग के जन्म के पश्चात् एबेर चार सौ तीस वर्ष और जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","जब पेलेग तीस वर्ष का हुआ, तब उसके द्वारा रू का जन्म हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","और रू के जन्म के पश्चात् पेलेग दो सौ नौ वर्ष और जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","जब रू बत्तीस वर्ष का हुआ, तब उसके द्वारा सरूग का जन्म हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","और सरूग के जन्म के पश्चात् रू दो सौ सात वर्ष और जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","जब सरूग तीस वर्ष का हुआ, तब उसके द्वारा नाहोर का जन्म हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","और नाहोर के जन्म के पश्चात् सरूग दो सौ वर्ष और जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","जब नाहोर उनतीस वर्ष का हुआ, तब उसके द्वारा तेरह का जन्म हुआ; ");
INSERT INTO hin2017_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","और तेरह के जन्म के पश्चात् नाहोर एक सौ उन्नीस वर्ष और जीवित रहा, और उसके और भी बेटे-बेटियाँ उत्पन्न हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","जब तक तेरह सत्तर वर्ष का हुआ, तब तक उसके द्वारा अब्राम, और नाहोर, और हारान उत्पन्न हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेरह की वंशावली यह है: तेरह ने अब्राम, और नाहोर, और हारान को जन्म दिया; और हारान ने लूत को जन्म दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","और हारान अपने पिता के सामने ही, कसदियों के ऊर नाम नगर में, जो उसकी जन्म-भूमि थी, मर गया। ");
INSERT INTO hin2017_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राम और नाहोर दोनों ने विवाह किया। अब्राम की पत्नी का नाम सारै, और नाहोर की पत्नी का नाम मिल्का था। यह उस हारान की बेटी थी, जो मिल्का और यिस्का दोनों का पिता था। ");
INSERT INTO hin2017_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","सारै तो बाँझ थी; उसके सन्तान न हुई। ");
INSERT INTO hin2017_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","और तेरह अपने पुत्र अब्राम, और अपने पोते लूत, जो हारान का पुत्र था, और अपनी बहू सारै, जो उसके पुत्र अब्राम की पत्नी थी, इन सभी को लेकर कसदियों के ऊर नगर से निकल कनान देश जाने को चला; पर हारान नामक देश में पहुँचकर वहीं रहने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","जब तेरह दो सौ पाँच वर्ष का हुआ, तब वह हारान देश में मर गया। ");
INSERT INTO hin2017_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","यहोवा ने अब्राम से कहा, “अपने देश, और अपनी जन्म-भूमि, और अपने पिता के घर को छोड़कर उस देश में चला जा जो मैं तुझे दिखाऊँगा। (प्रेरि. 7:3, इब्रा. 11:8) ");
INSERT INTO hin2017_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","और मैं तुझ से एक बड़ी जाति बनाऊँगा, और तुझे आशीष दूँगा, और तेरा नाम महान करूँगा, और तू आशीष का मूल होगा। ");
INSERT INTO hin2017_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","और जो तुझे आशीर्वाद दें, उन्हें मैं आशीष दूँगा; और जो तुझे कोसे, उसे मैं श्राप दूँगा; और भूमण्डल के सारे कुल तेरे द्वारा आशीष पाएँगे।” (प्रेरि. 3:25, गला. 3:8) ");
INSERT INTO hin2017_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","यहोवा के इस वचन के अनुसार अब्राम चला; और लूत भी उसके संग चला; और जब अब्राम हारान देश से निकला उस समय वह पचहत्तर वर्ष का था। ");
INSERT INTO hin2017_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","इस प्रकार अब्राम अपनी पत्नी सारै, और अपने भतीजे लूत को, और जो धन उन्होंने इकट्ठा किया था, और जो प्राणी उन्होंने हारान में प्राप्त किए थे, सब को लेकर कनान देश में जाने को निकल चला; और वे कनान देश में आ गए। (प्रेरि. 7:4) ");
INSERT INTO hin2017_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","उस देश के बीच से जाते हुए अब्राम शेकेम में, जहाँ मोरे का बांज वृक्ष है पहुँचा। उस समय उस देश में कनानी लोग रहते थे। ");
INSERT INTO hin2017_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","तब यहोवा ने अब्राम को दर्शन देकर कहा, “यह देश मैं तेरे वंश को दूँगा।” और उसने वहाँ यहोवा के लिये, जिसने उसे दर्शन दिया था, एक वेदी बनाई। (गला. 3:16) ");
INSERT INTO hin2017_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","फिर वहाँ से आगे बढ़कर, वह उस पहाड़ पर आया, जो बेतेल के पूर्व की ओर है; और अपना तम्बू उस स्थान में खड़ा किया जिसके पश्चिम की ओर तो बेतेल, और पूर्व की ओर आई है; और वहाँ भी उसने यहोवा के लिये एक वेदी बनाई: और यहोवा से प्रार्थना की। ");
INSERT INTO hin2017_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","और अब्राम आगे बढ़ करके दक्षिण देश की ओर चला गया। ");
INSERT INTO hin2017_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","उस देश में अकाल पड़ा: इसलिए अब्राम मिस्र देश को चला गया कि वहाँ परदेशी होकर रहे क्योंकि देश में भयंकर अकाल पड़ा था। ");
INSERT INTO hin2017_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","फिर ऐसा हुआ कि मिस्र के निकट पहुँचकर, उसने अपनी पत्नी सारै से कहा, “सुन, मुझे मालूम है, कि तू एक सुन्दर स्त्री है; ");
INSERT INTO hin2017_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","और जब मिस्री तुझे देखेंगे, तब कहेंगे, ‘यह उसकी पत्नी है,’ इसलिए वे मुझ को तो मार डालेंगे, पर तुझको जीवित रख लेंगे। ");
INSERT INTO hin2017_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","अतः यह कहना, ‘मैं उसकी बहन हूँ,’ जिससे तेरे कारण मेरा कल्याण हो और मेरा प्राण तेरे कारण बचे।” ");
INSERT INTO hin2017_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","फिर ऐसा हुआ कि जब अब्राम मिस्र में आया, तब मिस्रियों ने उसकी पत्नी को देखा कि वह अति सुन्दर है। ");
INSERT INTO hin2017_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","और मिस्र के राजा फ़िरौन के हाकिमों ने उसको देखकर फ़िरौन के सामने उसकी प्रशंसा की: इसलिए वह स्त्री फ़िरौन के महल में पहुँचाई गई। ");
INSERT INTO hin2017_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","और फ़िरौन ने उसके कारण अब्राम की भलाई की; और उसको भेड़-बकरी, गाय-बैल, दास-दासियाँ, गदहे-गदहियाँ, और ऊँट मिले। ");
INSERT INTO hin2017_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","तब यहोवा ने फ़िरौन और उसके घराने पर, अब्राम की पत्नी सारै के कारण बड़ी-बड़ी विपत्तियाँ डाली। ");
INSERT INTO hin2017_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","तब फ़िरौन ने अब्राम को बुलवाकर कहा, “तूने मेरे साथ यह क्या किया? तूने मुझे क्यों नहीं बताया कि वह तेरी पत्नी है? ");
INSERT INTO hin2017_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","तूने क्यों कहा कि वह तेरी बहन है? मैंने उसे अपनी ही पत्नी बनाने के लिये लिया; परन्तु अब अपनी पत्नी को लेकर यहाँ से चला जा।” ");
INSERT INTO hin2017_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","और फ़िरौन ने अपने आदमियों को उसके विषय में आज्ञा दी और उन्होंने उसको और उसकी पत्नी को, सब सम्पत्ति समेत जो उसका था, विदा कर दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","तब अब्राम अपनी पत्नी, और अपनी सारी सम्पत्ति लेकर, लूत को भी संग लिये हुए, मिस्र को छोड़कर कनान के दक्षिण देश में आया। ");
INSERT INTO hin2017_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राम भेड़-बकरी, गाय-बैल, और सोने-चाँदी का बड़ा धनी था। ");
INSERT INTO hin2017_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","फिर वह दक्षिण देश से चलकर, बेतेल के पास उसी स्थान को पहुँचा, जहाँ पहले उसने अपना तम्बू खड़ा किया था, जो बेतेल और आई के बीच में है। ");
INSERT INTO hin2017_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","यह स्थान उस वेदी का है, जिसे उसने पहले बनाया था, और वहाँ अब्राम ने फिर यहोवा से प्रार्थना की। ");
INSERT INTO hin2017_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","लूत के पास भी, जो अब्राम के साथ चलता था, भेड़-बकरी, गाय-बैल, और तम्बू थे। ");
INSERT INTO hin2017_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","इसलिए उस देश में उन दोनों के लिए पर्याप्त स्थान न था कि वे इकट्ठे रहें क्योंकि उनके पास बहुत सम्पत्ति थी इसलिए वे इकट्ठे न रह सके। ");
INSERT INTO hin2017_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","सो अब्राम, और लूत की भेड़-बकरी, और गाय-बैल के चरवाहों में झगड़ा हुआ। उस समय कनानी, और परिज्जी लोग, उस देश में रहते थे। ");
INSERT INTO hin2017_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","तब अब्राम लूत से कहने लगा, “मेरे और तेरे बीच, और मेरे और तेरे चरवाहों के बीच में झगड़ा न होने पाए; क्योंकि हम लोग भाई-बन्धु हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","क्या सारा देश तेरे सामने नहीं? सो मुझसे अलग हो, यदि तू बाईं ओर जाए तो मैं दाहिनी ओर जाऊँगा; और यदि तू दाहिनी ओर जाए तो मैं बाईं ओर जाऊँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","तब लूत ने आँख उठाकर, यरदन नदी के पास वाली सारी तराई को देखा कि वह सब सिंची हुई है। जब तक यहोवा ने सदोम और गमोरा को नाश न किया था, तब तक सोअर के मार्ग तक वह तराई यहोवा की वाटिका, और मिस्र देश के समान उपजाऊ थी। ");
INSERT INTO hin2017_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","सो लूत अपने लिये यरदन की सारी तराई को चुन के पूर्व की ओर चला, और वे एक दूसरे से अलग हो गये। ");
INSERT INTO hin2017_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम तो कनान देश में रहा, पर लूत उस तराई के नगरों में रहने लगा; और अपना तम्बू सदोम के निकट खड़ा किया। ");
INSERT INTO hin2017_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोम के लोग यहोवा की दृष्टि में बड़े दुष्ट और पापी थे। ");
INSERT INTO hin2017_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","जब लूत अब्राम से अलग हो गया तब उसके पश्चात् यहोवा ने अब्राम से कहा, “आँख उठाकर जिस स्थान पर तू है वहाँ से उत्तर-दक्षिण, पूर्व-पश्चिम, चारों ओर दृष्टि कर। ");
INSERT INTO hin2017_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","क्योंकि जितनी भूमि तुझे दिखाई देती है, उस सब को मैं तुझे और तेरे वंश को युग-युग के लिये दूँगा। (प्रेरि. 7:5) ");
INSERT INTO hin2017_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","और मैं तेरे वंश को पृथ्वी की धूल के किनकों के समान बहुत करूँगा, यहाँ तक कि जो कोई पृथ्वी की धूल के किनकों को गिन सकेगा वही तेरा वंश भी गिन सकेगा। ");
INSERT INTO hin2017_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","उठ, इस देश की लम्बाई और चौड़ाई में चल फिर; क्योंकि मैं उसे तुझी को दूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","इसके पश्चात् अब्राम अपना तम्बू उखाड़कर, मम्रे के बांजवृक्षों के बीच जो हेब्रोन में थे, जाकर रहने लगा, और वहाँ भी यहोवा की एक वेदी बनाई। ");
INSERT INTO hin2017_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","शिनार के राजा अम्रापेल, और एल्लासार के राजा अर्योक, और एलाम के राजा कदोर्लाओमेर, और गोयीम के राजा तिदाल के दिनों में ऐसा हुआ, ");
INSERT INTO hin2017_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","कि उन्होंने सदोम के राजा बेरा, और गमोरा के राजा बिर्शा, और अदमा के राजा शिनाब, और सबोयीम के राजा शेमेबेर, और बेला जो सोअर भी कहलाता है, इन राजाओं के विरुद्ध युद्ध किया। ");
INSERT INTO hin2017_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","इन पाँचों ने सिद्दीम नामक तराई में, जो खारे नदी के पास है, एका किया। ");
INSERT INTO hin2017_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","बारह वर्ष तक तो ये कदोर्लाओमेर के अधीन रहे; पर तेरहवें वर्ष में उसके विरुद्ध उठे। ");
INSERT INTO hin2017_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","चौदहवें वर्ष में कदोर्लाओमेर, और उसके संगी राजा आए, और अश्तारोत्कनम में रापाइयों को, और हाम में जूजियों को, और शावे-किर्यातैम में एमियों को, ");
INSERT INTO hin2017_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","और सेईर नामक पहाड़ में होरियों को, मारते-मारते उस एल्पारान तक जो जंगल के पास है, पहुँच गए। ");
INSERT INTO hin2017_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","वहाँ से वे लौटकर एन्मिशपात को आए, जो कादेश भी कहलाता है, और अमालेकियों के सारे देश को, और उन एमोरियों को भी जीत लिया, जो हसासोन्तामार में रहते थे। ");
INSERT INTO hin2017_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","तब सदोम, गमोरा, अदमा, सबोयीम, और बेला, जो सोअर भी कहलाता है, इनके राजा निकले, और सिद्दीम नामक तराई में, उनके साथ युद्ध के लिये पाँति बाँधी: ");
INSERT INTO hin2017_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","अर्थात् एलाम के राजा कदोर्लाओमेर, गोयीम के राजा तिदाल, शिनार के राजा अम्रापेल, और एल्लासार के राजा अर्योक, इन चारों के विरुद्ध उन पाँचों ने पाँति बाँधी। ");
INSERT INTO hin2017_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","सिद्दीम नामक तराई में जहाँ लसार मिट्टी के गड्ढे ही गड्ढे थे; सदोम और गमोरा के राजा भागते-भागते उनमें गिर पड़े, और जो बचे वे पहाड़ पर भाग गए। ");
INSERT INTO hin2017_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","तब वे सदोम और गमोरा के सारे धन और भोजनवस्तुओं को लूट-लाट कर चले गए। ");
INSERT INTO hin2017_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","और अब्राम का भतीजा लूत, जो सदोम में रहता था; उसको भी धन समेत वे लेकर चले गए। ");
INSERT INTO hin2017_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","तब एक जन जो भागकर बच निकला था उसने जाकर इब्री अब्राम को समाचार दिया; अब्राम तो एमोरी मम्रे, जो एशकोल और आनेर का भाई था, उसके बांजवृक्षों के बीच में रहता था; और ये लोग अब्राम के संग वाचा बाँधे हुए थे। ");
INSERT INTO hin2017_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","यह सुनकर कि उसका भतीजा बन्दी बना लिया गया है, अब्राम ने अपने तीन सौ अठारह प्रशिक्षित, युद्ध कौशल में निपुण दासों को लेकर जो उसके कुटुम्ब में उत्पन्न हुए थे, अस्त्र-शस्त्र धारण करके दान तक उनका पीछा किया। ");
INSERT INTO hin2017_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","और अपने दासों के अलग-अलग दल बाँधकर रात को उन पर चढ़ाई करके उनको मार लिया और होबा तक, जो दमिश्क की उत्तर की ओर है, उनका पीछा किया। ");
INSERT INTO hin2017_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","और वह सारे धन को, और अपने भतीजे लूत, और उसके धन को, और स्त्रियों को, और सब बन्दियों को, लौटा ले आया। ");
INSERT INTO hin2017_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","जब वह कदोर्लाओमेर और उसके साथी राजाओं को जीतकर लौटा आता था तब सदोम का राजा शावे नामक तराई में, जो राजा की तराई भी कहलाती है, उससे भेंट करने के लिये आया। ");
INSERT INTO hin2017_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","तब शालेम का राजा मलिकिसिदक, जो परमप्रधान परमेश्वर का याजक था, रोटी और दाखमधु ले आया। ");
INSERT INTO hin2017_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","और उसने अब्राम को यह आशीर्वाद दिया, “परमप्रधान परमेश्वर की ओर से, जो आकाश और पृथ्वी का अधिकारी है, तू धन्य हो। ");
INSERT INTO hin2017_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","और धन्य है परमप्रधान परमेश्वर, जिसने तेरे द्रोहियों को तेरे वश में कर दिया है।” तब अब्राम ने उसको सब का दशमांश दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","तब सदोम के राजा ने अब्राम से कहा, “प्राणियों को तो मुझे दे, और धन को अपने पास रख।” ");
INSERT INTO hin2017_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","अब्राम ने सदोम के राजा से कहा, “परमप्रधान परमेश्वर यहोवा, जो आकाश और पृथ्वी का अधिकारी है, ");
INSERT INTO hin2017_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","उसकी मैं यह शपथ खाता हूँ, कि जो कुछ तेरा है उसमें से न तो मैं एक सूत, और न जूती का बन्धन, न कोई और वस्तु लूँगा; कि तू ऐसा न कहने पाए, कि अब्राम मेरे ही कारण धनी हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","पर जो कुछ इन जवानों ने खा लिया है और उनका भाग जो मेरे साथ गए थे; अर्थात् आनेर, एशकोल, और मम्रे मैं नहीं लौटाऊँगा वे तो अपना-अपना भाग रख लें।” ");
INSERT INTO hin2017_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","इन बातों के पश्चात् यहोवा का यह वचन दर्शन में अब्राम के पास पहुँचा “हे अब्राम, मत डर; मैं तेरी ढाल और तेरा अत्यन्त बड़ा प्रतिफल हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","अब्राम ने कहा, “हे प्रभु यहोवा, मैं तो सन्तानहीन हूँ, और मेरे घर का वारिस यह दमिश्कवासी एलीएजेर होगा, अतः तू मुझे क्या देगा?” ");
INSERT INTO hin2017_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","और अब्राम ने कहा, “मुझे तो तूने वंश नहीं दिया, और क्या देखता हूँ, कि मेरे घर में उत्पन्न हुआ एक जन मेरा वारिस होगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","तब यहोवा का यह वचन उसके पास पहुँचा, “यह तेरा वारिस न होगा, तेरा जो निज पुत्र होगा, वही तेरा वारिस होगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","और उसने उसको बाहर ले जाकर कहा, “आकाश की ओर दृष्टि करके तारागण को गिन, क्या तू उनको गिन सकता है?” फिर उसने उससे कहा, “तेरा वंश ऐसा ही होगा।” (रोम. 4:18) ");
INSERT INTO hin2017_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","उसने यहोवा पर विश्वास किया; और यहोवा ने इस बात को उसके लेखे में धार्मिकता गिना। (रोम. 4:3) ");
INSERT INTO hin2017_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","और उसने उससे कहा, “मैं वही यहोवा हूँ जो तुझे कसदियों के ऊर नगर से बाहर ले आया, कि तुझको इस देश का अधिकार दूँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","उसने कहा, “हे प्रभु यहोवा मैं कैसे जानूँ कि मैं इसका अधिकारी होऊँगा?” ");
INSERT INTO hin2017_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","यहोवा ने उससे कहा, “मेरे लिये तीन वर्ष की एक बछिया, और तीन वर्ष की एक बकरी, और तीन वर्ष का एक मेढ़ा, और एक पिण्डुक और कबूतर का एक बच्चा ले।” ");
INSERT INTO hin2017_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","और इन सभी को लेकर, उसने बीच से दो टुकड़े कर दिया और टुकड़ों को आमने-सामने रखा पर चिड़ियों के उसने टुकड़े नहीं किए। ");
INSERT INTO hin2017_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","जब माँसाहारी पक्षी लोथों पर झपटे, तब अब्राम ने उन्हें उड़ा दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","जब सूर्य अस्त होने लगा, तब अब्राम को भारी नींद आई; और देखो, अत्यन्त भय और महा अंधकार ने उसे छा लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","तब यहोवा ने अब्राम से कहा, “यह निश्चय जान कि तेरे वंश पराए देश में परदेशी होकर रहेंगे, और उस देश के लोगों के दास हो जाएँगे; और वे उनको चार सौ वर्ष तक दुःख देंगे; ");
INSERT INTO hin2017_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","फिर जिस देश के वे दास होंगे उसको मैं दण्ड दूँगा: और उसके पश्चात् वे बड़ा धन वहाँ से लेकर निकल आएँगे। (निर्ग. 12:36) ");
INSERT INTO hin2017_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","तू तो अपने पितरों में कुशल के साथ मिल जाएगा; तुझे पूरे बुढ़ापे में मिट्टी दी जाएगी। ");
INSERT INTO hin2017_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","पर वे चौथी पीढ़ी में यहाँ फिर आएँगे: क्योंकि अब तक एमोरियों का अधर्म पूरा नहीं हुआ हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","और ऐसा हुआ कि जब सूर्य अस्त हो गया और घोर अंधकार छा गया, तब एक अँगीठी जिसमें से धुआँ उठता था और एक जलती हुई मशाल दिखाई दी जो उन टुकड़ों के बीच में से होकर निकल गई। ");
INSERT INTO hin2017_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","उसी दिन यहोवा ने अब्राम के साथ यह वाचा बाँधी, “मिस्र के महानद से लेकर फरात नामक बड़े नद तक जितना देश है, ");
INSERT INTO hin2017_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","अर्थात्, केनियों, कनिज्जियों, कदमोनियों, ");
INSERT INTO hin2017_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्तियों, परिज्जियों, रापाइयों, ");
INSERT INTO hin2017_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","एमोरियों, कनानियों, गिर्गाशियों और यबूसियों का देश, मैंने तेरे वंश को दिया है।” ");
INSERT INTO hin2017_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब्राम की पत्नी सारै के कोई सन्तान न थी: और उसके हागार नाम की एक मिस्री दासी थी। (गला. 4:22) ");
INSERT INTO hin2017_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","सारै ने अब्राम से कहा, “देख, यहोवा ने तो मेरी कोख बन्द कर रखी है इसलिए मैं तुझ से विनती करती हूँ कि तू मेरी दासी के पास जा; सम्भव है कि मेरा घर उसके द्वारा बस जाए।” सारै की यह बात अब्राम ने मान ली। ");
INSERT INTO hin2017_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","इसलिए जब अब्राम को कनान देश में रहते दस वर्ष बीत चुके तब उसकी स्त्री सारै ने अपनी मिस्री दासी हागार को लेकर अपने पति अब्राम को दिया, कि वह उसकी पत्नी हो। ");
INSERT INTO hin2017_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","वह हागार के पास गया, और वह गर्भवती हुई; जब उसने जाना कि वह गर्भवती है, तब वह अपनी स्वामिनी को अपनी दृष्टि में तुच्छ समझने लगी। ");
INSERT INTO hin2017_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","तब सारै ने अब्राम से कहा, “जो मुझ पर उपद्रव हुआ वह तेरे ही सिर पर हो। मैंने तो अपनी दासी को तेरी पत्नी कर दिया; पर जब उसने जाना कि वह गर्भवती है, तब वह मुझे तुच्छ समझने लगी, इसलिए यहोवा मेरे और तेरे बीच में न्याय करे।” ");
INSERT INTO hin2017_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","अब्राम ने सारै से कहा, “देख तेरी दासी तेरे वश में है; जैसा तुझे भला लगे वैसा ही उसके साथ कर।” तब सारै उसको दुःख देने लगी और वह उसके सामने से भाग गई। ");
INSERT INTO hin2017_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","तब यहोवा के दूत ने उसको जंगल में शूर के मार्ग पर जल के एक सोते के पास पाकर कहा, ");
INSERT INTO hin2017_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“हे सारै की दासी हागार, तू कहाँ से आती और कहाँ को जाती है?” उसने कहा, “मैं अपनी स्वामिनी सारै के सामने से भाग आई हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","यहोवा के दूत ने उससे कहा, “अपनी स्वामिनी के पास लौट जा और उसके वश में रह।” ");
INSERT INTO hin2017_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","और यहोवा के दूत ने उससे कहा, “मैं तेरे वंश को बहुत बढ़ाऊँगा, यहाँ तक कि बहुतायत के कारण उसकी गिनती न हो सकेगी।” ");
INSERT INTO hin2017_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","और यहोवा के दूत ने उससे कहा, “देख तू गर्भवती है, और पुत्र जनेगी; तू उसका नाम इश्माएल रखना; क्योंकि यहोवा ने तेरे दुःख का हाल सुन लिया है। ");
INSERT INTO hin2017_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","और वह मनुष्य जंगली गदहे के समान होगा, उसका हाथ सब के विरुद्ध उठेगा, और सब के हाथ उसके विरुद्ध उठेंगे; और वह अपने सब भाई-बन्धुओं के मध्य में बसा रहेगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","तब उसने यहोवा का नाम जिसने उससे बातें की थीं, अत्ताएलरोई रखकर कहा, “क्या मैं यहाँ भी उसको जाते हुए देखने पाई और देखने के बाद भी जीवित रही?” ");
INSERT INTO hin2017_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","इस कारण उस कुएँ का नाम बएर-लहई-रोई कुआँ पड़ा; वह तो कादेश और बेरेद के बीच में है। ");
INSERT INTO hin2017_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","हागार को अब्राम के द्वारा एक पुत्र हुआ; और अब्राम ने अपने पुत्र का नाम, जिसे हागार ने जन्म दिया था, इश्माएल रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","जब हागार ने अब्राम के द्वारा इश्माएल को जन्म दिया उस समय अब्राम छियासी वर्ष का था। ");
INSERT INTO hin2017_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","जब अब्राम निन्यानवे वर्ष का हो गया, तब यहोवा ने उसको दर्शन देकर कहा, “मैं सर्वशक्तिमान परमेश्वर हूँ; मेरी उपस्थिति में चल और सिद्ध होता जा। ");
INSERT INTO hin2017_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","मैं तेरे साथ वाचा बाँधूँगा, और तेरे वंश को अत्यन्त ही बढ़ाऊँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","तब अब्राम मुँह के बल गिरा और परमेश्वर उससे यह बातें करता गया, ");
INSERT INTO hin2017_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“देख, मेरी वाचा तेरे साथ बंधी रहेगी, इसलिए तू जातियों के समूह का मूलपिता हो जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","इसलिए अब से तेरा नाम अब्राम न रहेगा परन्तु तेरा नाम अब्राहम होगा; क्योंकि मैंने तुझे जातियों के समूह का मूलपिता ठहरा दिया है। ");
INSERT INTO hin2017_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","मैं तुझे अत्यन्त फलवन्त करूँगा, और तुझको जाति-जाति का मूल बना दूँगा, और तेरे वंश में राजा उत्पन्न होंगे। ");
INSERT INTO hin2017_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","और मैं तेरे साथ, और तेरे पश्चात् पीढ़ी-पीढ़ी तक तेरे वंश के साथ भी इस आशय की युग-युग की वाचा बाँधता हूँ, कि मैं तेरा और तेरे पश्चात् तेरे वंश का भी परमेश्वर रहूँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","और मैं तुझको, और तेरे पश्चात् तेरे वंश को भी, यह सारा कनान देश, जिसमें तू परदेशी होकर रहता है, इस रीति दूँगा कि वह युग-युग उनकी निज भूमि रहेगी, और मैं उनका परमेश्वर रहूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","फिर परमेश्वर ने अब्राहम से कहा, “तू भी मेरे साथ बाँधी हुई वाचा का पालन करना; तू और तेरे पश्चात् तेरा वंश भी अपनी-अपनी पीढ़ी में उसका पालन करे। ");
INSERT INTO hin2017_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","मेरे साथ बाँधी हुई वाचा, जिसका पालन तुझे और तेरे पश्चात् तेरे वंश को करना पड़ेगा, वह यह है: तुम में से एक-एक पुरुष का खतना हो। ");
INSERT INTO hin2017_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","तुम अपनी-अपनी खलड़ी का खतना करा लेना: जो वाचा मेरे और तुम्हारे बीच में है, उसका यही चिन्ह होगा। ");
INSERT INTO hin2017_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","पीढ़ी-पीढ़ी में केवल तेरे वंश ही के लोग नहीं पर जो तेरे घर में उत्पन्न हुआ हो, अथवा परदेशियों को रूपा देकर मोल लिया जाए, ऐसे सब पुरुष भी जब आठ दिन के हो जाएँ, तब उनका खतना किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","जो तेरे घर में उत्पन्न हो, अथवा तेरे रूपे से मोल लिया जाए, उसका खतना अवश्य ही किया जाए; इस प्रकार मेरी वाचा जिसका चिन्ह तुम्हारी देह में होगा वह युग-युग रहेगी। ");
INSERT INTO hin2017_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","जो पुरुष खतनारहित रहे, अर्थात् जिसकी खलड़ी का खतना न हो, वह प्राणी अपने लोगों में से नाश किया जाए, क्योंकि उसने मेरे साथ बाँधी हुई वाचा को तोड़ दिया।” ");
INSERT INTO hin2017_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","फिर परमेश्वर ने अब्राहम से कहा, “तेरी जो पत्नी सारै है, उसको तू अब सारै न कहना, उसका नाम सारा होगा। ");
INSERT INTO hin2017_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","मैं उसको आशीष दूँगा, और तुझको उसके द्वारा एक पुत्र दूँगा; और मैं उसको ऐसी आशीष दूँगा, कि वह जाति-जाति की मूलमाता हो जाएगी; और उसके वंश में राज्य-राज्य के राजा उत्पन्न होंगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","तब अब्राहम मुँह के बल गिर पड़ा और हँसा, और मन ही मन कहने लगा, “क्या सौ वर्ष के पुरुष के भी सन्तान होगी और क्या सारा जो नब्बे वर्ष की है पुत्र जनेगी?” ");
INSERT INTO hin2017_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","और अब्राहम ने परमेश्वर से कहा, “इश्माएल तेरी दृष्टि में बना रहे! यही बहुत है।” ");
INSERT INTO hin2017_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","तब परमेश्वर ने कहा, “निश्चय तेरी पत्नी सारा के तुझ से एक पुत्र उत्पन्न होगा; और तू उसका नाम इसहाक रखना; और मैं उसके साथ ऐसी वाचा बाँधूँगा जो उसके पश्चात् उसके वंश के लिये युग-युग की वाचा होगी। (गला. 4:7,8) ");
INSERT INTO hin2017_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","इश्माएल के विषय में भी मैंने तेरी सुनी है; मैं उसको भी आशीष दूँगा, और उसे फलवन्त करूँगा और अत्यन्त ही बढ़ा दूँगा; उससे बारह प्रधान उत्पन्न होंगे, और मैं उससे एक बड़ी जाति बनाऊँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","परन्तु मैं अपनी वाचा इसहाक ही के साथ बाँधूँगा जो सारा से अगले वर्ष के इसी नियुक्त समय में उत्पन्न होगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","तब परमेश्वर ने अब्राहम से बातें करनी बन्द की और उसके पास से ऊपर चढ़ गया। ");
INSERT INTO hin2017_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","तब अब्राहम ने अपने पुत्र इश्माएल को लिया और, उसके घर में जितने उत्पन्न हुए थे, और जितने उसके रुपये से मोल लिये गए थे, अर्थात् उसके घर में जितने पुरुष थे, उन सभी को लेकर उसी दिन परमेश्वर के वचन के अनुसार उनकी खलड़ी का खतना किया। ");
INSERT INTO hin2017_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","जब अब्राहम की खलड़ी का खतना हुआ तब वह निन्यानवे वर्ष का था। ");
INSERT INTO hin2017_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","और जब उसके पुत्र इश्माएल की खलड़ी का खतना हुआ तब वह तेरह वर्ष का था। ");
INSERT INTO hin2017_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","अब्राहम और उसके पुत्र इश्माएल दोनों का खतना एक ही दिन हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","और उसके घर में जितने पुरुष थे जो घर में उत्पन्न हुए, तथा जो परदेशियों के हाथ से मोल लिये गए थे, सब का खतना उसके साथ ही हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","अब्राहम मम्रे के बांजवृक्षों के बीच कड़ी धूप के समय तम्बू के द्वार पर बैठा हुआ था, तब यहोवा ने उसे दर्शन दिया: ");
INSERT INTO hin2017_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","उसने आँख उठाकर दृष्टि की तो क्या देखा, कि तीन पुरुष उसके सामने खड़े हैं। जब उसने उन्हें देखा तब वह उनसे भेंट करने के लिये तम्बू के द्वार से दौड़ा, और भूमि पर गिरकर दण्डवत् की और कहने लगा, ");
INSERT INTO hin2017_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“हे प्रभु, यदि मुझ पर तेरी अनुग्रह की दृष्टि है तो मैं विनती करता हूँ, कि अपने दास के पास से चले न जाना। ");
INSERT INTO hin2017_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","मैं थोड़ा सा जल लाता हूँ और आप अपने पाँव धोकर इस वृक्ष के तले विश्राम करें। ");
INSERT INTO hin2017_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","फिर मैं एक टुकड़ा रोटी ले आऊँ, और उससे आप अपने-अपने जीव को तृप्त करें; तब उसके पश्चात् आगे बढ़ें क्योंकि आप अपने दास के पास इसी लिए पधारे हैं।” उन्होंने कहा, “जैसा तू कहता है वैसा ही कर।” ");
INSERT INTO hin2017_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","तब अब्राहम तुरन्त तम्बू में सारा के पास गया और कहा, “तीन सआ मैदा जल्दी से गूँध, और फुलके बना।” ");
INSERT INTO hin2017_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","फिर अब्राहम गाय-बैल के झुण्ड में दौड़ा, और एक कोमल और अच्छा बछड़ा लेकर अपने सेवक को दिया, और उसने जल्दी से उसको पकाया। ");
INSERT INTO hin2017_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","तब उसने दही, और दूध, और बछड़े का माँस, जो उसने पकवाया था, लेकर उनके आगे परोस दिया; और आप वृक्ष के तले उनके पास खड़ा रहा, और वे खाने लगे। (इब्रा. 13:2) ");
INSERT INTO hin2017_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","उन्होंने उससे पूछा, “तेरी पत्नी सारा कहाँ है?” उसने कहा, “वह तो तम्बू में है।” ");
INSERT INTO hin2017_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","उसने कहा, “मैं वसन्त ऋतु में निश्चय तेरे पास फिर आऊँगा; और तेरी पत्नी सारा के एक पुत्र उत्पन्न होगा।” सारा तम्बू के द्वार पर जो अब्राहम के पीछे था सुन रही थी। (रोम. 9:9) ");
INSERT INTO hin2017_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","अब्राहम और सारा दोनों बहुत बूढ़े थे; और सारा का मासिक धर्म बन्द हो गया था। (रोम. 4:9) ");
INSERT INTO hin2017_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","इसलिए सारा मन में हँसकर कहने लगी, “मैं तो बूढ़ी हूँ, और मेरा स्वामी भी बूढ़ा है, तो क्या मुझे यह सुख होगा?” ");
INSERT INTO hin2017_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","तब यहोवा ने अब्राहम से कहा, “सारा यह कहकर क्यों हँसी, कि क्या मेरे, जो ऐसी बुढ़िया हो गई हूँ, सचमुच एक पुत्र उत्पन्न होगा? ");
INSERT INTO hin2017_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","क्या यहोवा के लिये कोई काम कठिन है? नियत समय में, अर्थात् वसन्त ऋतु में, मैं तेरे पास फिर आऊँगा, और सारा के पुत्र उत्पन्न होगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","तब सारा डर के मारे यह कहकर मुकर गई, “मैं नहीं हँसी।” उसने कहा, “नहीं; तू हँसी तो थी।” (1 पत. 3:6) ");
INSERT INTO hin2017_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","फिर वे पुरुष वहाँ से चलकर, सदोम की ओर दृष्टि की; और अब्राहम उन्हें विदा करने के लिये उनके संग-संग चला। ");
INSERT INTO hin2017_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","तब यहोवा ने कहा, “यह जो मैं करता हूँ उसे क्या अब्राहम से छिपा रखूँ? ");
INSERT INTO hin2017_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","अब्राहम से तो निश्चय एक बड़ी और सामर्थी जाति उपजेगी, और पृथ्वी की सारी जातियाँ उसके द्वारा आशीष पाएँगी। (प्रेरि. 3:25, रोम. 4:13, गला. 3:8) ");
INSERT INTO hin2017_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","क्योंकि मैं जानता हूँ, कि वह अपने पुत्रों और परिवार को जो उसके पीछे रह जाएँगे, आज्ञा देगा कि वे यहोवा के मार्ग में अटल बने रहें, और धार्मिकता और न्याय करते रहें, ताकि जो कुछ यहोवा ने अब्राहम के विषय में कहा है उसे पूरा करे।” ");
INSERT INTO hin2017_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","फिर यहोवा ने कहा, “सदोम और गमोरा के विरुद्ध चिल्लाहट बढ़ गई है, और उनका पाप बहुत भारी हो गया है; ");
INSERT INTO hin2017_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","इसलिए मैं उतरकर देखूँगा, कि उसकी जैसी चिल्लाहट मेरे कान तक पहुँची है, उन्होंने ठीक वैसा ही काम किया है कि नहीं; और न किया हो तो मैं उसे जान लूँगा।” (प्रका. 18:5) ");
INSERT INTO hin2017_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","तब वे पुरुष वहाँ से मुड़कर सदोम की ओर जाने लगे; पर अब्राहम यहोवा के आगे खड़ा रह गया। ");
INSERT INTO hin2017_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","तब अब्राहम उसके समीप जाकर कहने लगा, “क्या तू सचमुच दुष्ट के संग धर्मी भी नाश करेगा? ");
INSERT INTO hin2017_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","कदाचित् उस नगर में पचास धर्मी हों तो क्या तू सचमुच उस स्थान को नाश करेगा और उन पचास धर्मियों के कारण जो उसमें हों न छोड़ेगा? ");
INSERT INTO hin2017_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","इस प्रकार का काम करना तुझ से दूर रहे कि दुष्ट के संग धर्मी को भी मार डाले और धर्मी और दुष्ट दोनों की एक ही दशा हो। यह तुझ से दूर रहे। क्या सारी पृथ्वी का न्यायी न्याय न करे?” ");
INSERT INTO hin2017_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","यहोवा ने कहा, “यदि मुझे सदोम में पचास धर्मी मिलें, तो उनके कारण उस सारे स्थान को छोड़ूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","फिर अब्राहम ने कहा, “हे प्रभु, सुन मैं तो मिट्टी और राख हूँ; तो भी मैंने इतनी ढिठाई की कि तुझ से बातें करूँ। ");
INSERT INTO hin2017_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","कदाचित् उन पचास धर्मियों में पाँच घट जाएँ; तो क्या तू पाँच ही के घटने के कारण उस सारे नगर का नाश करेगा?” उसने कहा, “यदि मुझे उसमें पैंतालीस भी मिलें, तो भी उसका नाश न करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","फिर उसने उससे यह भी कहा, “कदाचित् वहाँ चालीस मिलें।” उसने कहा, “तो मैं चालीस के कारण भी ऐसा न करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","फिर उसने कहा, “हे प्रभु, क्रोध न कर, तो मैं कुछ और कहूँ: कदाचित् वहाँ तीस मिलें।” उसने कहा, “यदि मुझे वहाँ तीस भी मिलें, तो भी ऐसा न करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","फिर उसने कहा, “हे प्रभु, सुन, मैंने इतनी ढिठाई तो की है कि तुझ से बातें करूँ: कदाचित् उसमें बीस मिलें।” उसने कहा, “मैं बीस के कारण भी उसका नाश न करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","फिर उसने कहा, “हे प्रभु, क्रोध न कर, मैं एक ही बार और कहूँगा: कदाचित् उसमें दस मिलें।” उसने कहा, “तो मैं दस के कारण भी उसका नाश न करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","जब यहोवा अब्राहम से बातें कर चुका, तब चला गया: और अब्राहम अपने घर को लौट गया। ");
INSERT INTO hin2017_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","साँझ को वे दो दूत सदोम के पास आए; और लूत सदोम के फाटक के पास बैठा था। उनको देखकर वह उनसे भेंट करने के लिये उठा; और मुँह के बल झुककर दण्डवत् कर कहा; ");
INSERT INTO hin2017_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“हे मेरे प्रभुओं, अपने दास के घर में पधारिए, और रात भर विश्राम कीजिए, और अपने पाँव धोइये, फिर भोर को उठकर अपने मार्ग पर जाइए।” उन्होंने कहा, “नहीं; हम चौक ही में रात बिताएँगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","और उसने उनसे बहुत विनती करके उन्हें मनाया; इसलिए वे उसके साथ चलकर उसके घर में आए; और उसने उनके लिये भोजन तैयार किया, और बिना ख़मीर की रोटियाँ बनाकर उनको खिलाई। ");
INSERT INTO hin2017_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","उनके सो जाने के पहले, सदोम नगर के पुरुषों ने, जवानों से लेकर बूढ़ों तक, वरन् चारों ओर के सब लोगों ने आकर उस घर को घेर लिया; ");
INSERT INTO hin2017_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","और लूत को पुकारकर कहने लगे, “जो पुरुष आज रात को तेरे पास आए हैं वे कहाँ हैं? उनको हमारे पास बाहर ले आ, कि हम उनसे भोग करें।” ");
INSERT INTO hin2017_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","तब लूत उनके पास द्वार के बाहर गया, और किवाड़ को अपने पीछे बन्द करके कहा, ");
INSERT INTO hin2017_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“हे मेरे भाइयों, ऐसी बुराई न करो। ");
INSERT INTO hin2017_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","सुनो, मेरी दो बेटियाँ हैं जिन्होंने अब तक पुरुष का मुँह नहीं देखा, इच्छा हो तो मैं उन्हें तुम्हारे पास बाहर ले आऊँ, और तुम को जैसा अच्छा लगे वैसा व्यवहार उनसे करो: पर इन पुरुषों से कुछ न करो; क्योंकि ये मेरी छत के तले आए हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","उन्होंने कहा, “हट जा!” फिर वे कहने लगे, “तू एक परदेशी होकर यहाँ रहने के लिये आया पर अब न्यायी भी बन बैठा है; इसलिए अब हम उनसे भी अधिक तेरे साथ बुराई करेंगे।” और वे उस पुरुष लूत को बहुत दबाने लगे, और किवाड़ तोड़ने के लिये निकट आए। ");
INSERT INTO hin2017_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","तब उन अतिथियों ने हाथ बढ़ाकर लूत को अपने पास घर में खींच लिया, और किवाड़ को बन्द कर दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","और उन्होंने क्या छोटे, क्या बड़े, सब पुरुषों को जो घर के द्वार पर थे अंधा कर दिया, अतः वे द्वार को टटोलते-टटोलते थक गए। ");
INSERT INTO hin2017_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","फिर उन अतिथियों ने लूत से पूछा, “यहाँ तेरा और कौन-कौन हैं? दामाद, बेटे, बेटियाँ, और नगर में तेरा जो कोई हो, उन सभी को लेकर इस स्थान से निकल जा। ");
INSERT INTO hin2017_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","क्योंकि हम यह स्थान नाश करने पर हैं, इसलिए कि इसकी चिल्लाहट यहोवा के सम्मुख बढ़ गई है; और यहोवा ने हमें इसका सत्यानाश करने के लिये भेज दिया है।” ");
INSERT INTO hin2017_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","तब लूत ने निकलकर अपने दामादों को, जिनके साथ उसकी बेटियों की सगाई हो गई थी, समझाकर कहा, “उठो, इस स्थान से निकल चलो; क्योंकि यहोवा इस नगर को नाश करने पर है।” उसके दामाद उसका मजाक उड़ाने लगे। (लूका 17:28,29) ");
INSERT INTO hin2017_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","जब पौ फटने लगी, तब दूतों ने लूत से जल्दी करने को कहा और बोले, “उठ, अपनी पत्नी और दोनों बेटियों को जो यहाँ हैं ले जा: नहीं तो तू भी इस नगर के अधर्म में भस्म हो जाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","पर वह विलम्ब करता रहा, इस पर उन पुरुषों ने उसका और उसकी पत्नी, और दोनों बेटियों के हाथ पकड़े; क्योंकि यहोवा की दया उस पर थी: और उसको निकालकर नगर के बाहर कर दिया। (2 पत. 2:7) ");
INSERT INTO hin2017_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","और ऐसा हुआ कि जब उन्होंने उनको बाहर निकाला, तब उसने कहा, “अपना प्राण लेकर भाग जा; पीछे की ओर न ताकना, और तराई भर में न ठहरना; उस पहाड़ पर भाग जाना, नहीं तो तू भी भस्म हो जाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","लूत ने उनसे कहा, “हे प्रभु, ऐसा न कर! ");
INSERT INTO hin2017_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","देख, तेरे दास पर तेरी अनुग्रह की दृष्टि हुई है, और तूने इसमें बड़ी कृपा दिखाई, कि मेरे प्राण को बचाया है; पर मैं पहाड़ पर भाग नहीं सकता, कहीं ऐसा न हो, कि कोई विपत्ति मुझ पर आ पड़े, और मैं मर जाऊँ। ");
INSERT INTO hin2017_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","देख, वह नगर ऐसा निकट है कि मैं वहाँ भाग सकता हूँ, और वह छोटा भी है। मुझे वहीं भाग जाने दे, क्या वह नगर छोटा नहीं है? और मेरा प्राण बच जाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","उसने उससे कहा, “देख, मैंने इस विषय में भी तेरी विनती स्वीकार की है, कि जिस नगर की चर्चा तूने की है, उसको मैं नाश न करूँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","फुर्ती से वहाँ भाग जा; क्योंकि जब तक तू वहाँ न पहुँचे तब तक मैं कुछ न कर सकूँगा।” इसी कारण उस नगर का नाम सोअर पड़ा। ");
INSERT INTO hin2017_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","लूत के सोअर के निकट पहुँचते ही सूर्य पृथ्वी पर उदय हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","तब यहोवा ने अपनी ओर से सदोम और गमोरा पर आकाश से गन्धक और आग बरसाई; (लूका 17:29) ");
INSERT INTO hin2017_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","और उन नगरों को और सम्पूर्ण तराई को, और नगरों के सब निवासियों को, भूमि की सारी उपज समेत नाश कर दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","लूत की पत्नी ने जो उसके पीछे थी पीछे मुड़कर देखा, और वह नमक का खम्भा बन गई। ");
INSERT INTO hin2017_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","भोर को अब्राहम उठकर उस स्थान को गया, जहाँ वह यहोवा के सम्मुख खड़ा था; ");
INSERT INTO hin2017_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","और सदोम, और गमोरा, और उस तराई के सारे देश की ओर आँख उठाकर क्या देखा कि उस देश में से धधकती हुई भट्ठी का सा धुआँ उठ रहा है। ");
INSERT INTO hin2017_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","और ऐसा हुआ कि जब परमेश्वर ने उस तराई के नगरों को, जिनमें लूत रहता था, उलट-पुलट कर नाश किया, तब उसने अब्राहम को याद करके लूत को उस घटना से बचा लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","लूत ने सोअर को छोड़ दिया, और पहाड़ पर अपनी दोनों बेटियों समेत रहने लगा; क्योंकि वह सोअर में रहने से डरता था; इसलिए वह और उसकी दोनों बेटियाँ वहाँ एक गुफा में रहने लगे। ");
INSERT INTO hin2017_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","तब बड़ी बेटी ने छोटी से कहा, “हमारा पिता बूढ़ा है, और पृथ्वी भर में कोई ऐसा पुरुष नहीं जो संसार की रीति के अनुसार हमारे पास आए। ");
INSERT INTO hin2017_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","इसलिए आ, हम अपने पिता को दाखमधु पिलाकर, उसके साथ सोएँ, जिससे कि हम अपने पिता के वंश को बचाए रखें।” ");
INSERT INTO hin2017_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","अतः उन्होंने उसी दिन-रात के समय अपने पिता को दाखमधु पिलाया, तब बड़ी बेटी जाकर अपने पिता के पास लेट गई; पर उसने न जाना, कि वह कब लेटी, और कब उठ गई। ");
INSERT INTO hin2017_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","और ऐसा हुआ कि दूसरे दिन बड़ी ने छोटी से कहा, “देख, कल रात को मैं अपने पिता के साथ सोई; इसलिए आज भी रात को हम उसको दाखमधु पिलाएँ; तब तू जाकर उसके साथ सोना कि हम अपने पिता के द्वारा वंश उत्पन्न करें।” ");
INSERT INTO hin2017_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","अतः उन्होंने उस दिन भी रात के समय अपने पिता को दाखमधु पिलाया, और छोटी बेटी जाकर उसके पास लेट गई; पर उसको उसके भी सोने और उठने का ज्ञान न था। ");
INSERT INTO hin2017_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","इस प्रकार से लूत की दोनों बेटियाँ अपने पिता से गर्भवती हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","बड़ी एक पुत्र जनी और उसका नाम मोआब रखा; वह मोआब नामक जाति का जो आज तक है मूलपिता हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","और छोटी भी एक पुत्र जनी, और उसका नाम बेनअम्मी रखा; वह अम्मोनवंशियों का जो आज तक है मूलपिता हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","फिर अब्राहम वहाँ से निकलकर दक्षिण देश में आकर कादेश और शूर के बीच में ठहरा, और गरार में रहने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","और अब्राहम अपनी पत्नी सारा के विषय में कहने लगा, “वह मेरी बहन है,” इसलिए गरार के राजा अबीमेलेक ने दूत भेजकर सारा को बुलवा लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","रात को परमेश्वर ने स्वप्न में अबीमेलेक के पास आकर कहा, “सुन, जिस स्त्री को तूने रख लिया है, उसके कारण तू मर जाएगा, क्योंकि वह सुहागिन है।” ");
INSERT INTO hin2017_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","परन्तु अबीमेलेक उसके पास न गया था; इसलिए उसने कहा, “हे प्रभु, क्या तू निर्दोष जाति का भी घात करेगा? ");
INSERT INTO hin2017_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","क्या उसी ने स्वयं मुझसे नहीं कहा, ‘वह मेरी बहन है?’ और उस स्त्री ने भी आप कहा, ‘वह मेरा भाई है,’ मैंने तो अपने मन की खराई और अपने व्यवहार की सच्चाई से यह काम किया।” ");
INSERT INTO hin2017_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","परमेश्वर ने उससे स्वप्न में कहा, “हाँ, मैं भी जानता हूँ कि अपने मन की खराई से तूने यह काम किया है और मैंने तुझे रोक भी रखा कि तू मेरे विरुद्ध पाप न करे; इसी कारण मैंने तुझको उसे छूने नहीं दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","इसलिए अब उस पुरुष की पत्नी को उसे लौटा दे; क्योंकि वह नबी है, और तेरे लिये प्रार्थना करेगा, और तू जीता रहेगा पर यदि तू उसको न लौटाए तो जान रख, कि तू, और तेरे जितने लोग हैं, सब निश्चय मर जाएँगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","सवेरे अबीमेलेक ने तड़के उठकर अपने सब कर्मचारियों को बुलवाकर ये सब बातें सुनाईं; और वे लोग बहुत डर गए। ");
INSERT INTO hin2017_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","तब अबीमेलेक ने अब्राहम को बुलवाकर कहा, “तूने हम से यह क्या किया है? और मैंने तेरा क्या बिगाड़ा था कि तूने मेरे और मेरे राज्य के ऊपर ऐसा बड़ा पाप डाल दिया है? तूने मेरे साथ वह काम किया है जो उचित न था।” ");
INSERT INTO hin2017_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","फिर अबीमेलेक ने अब्राहम से पूछा, “तूने क्या समझकर ऐसा काम किया?” ");
INSERT INTO hin2017_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्राहम ने कहा, “मैंने यह सोचा था कि इस स्थान में परमेश्वर का कुछ भी भय न होगा; इसलिए ये लोग मेरी पत्नी के कारण मेरा घात करेंगे। ");
INSERT INTO hin2017_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","इसके अतिरिक्त सचमुच वह मेरी बहन है, वह मेरे पिता की बेटी तो है पर मेरी माता की बेटी नहीं; फिर वह मेरी पत्नी हो गई। ");
INSERT INTO hin2017_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","और ऐसा हुआ कि जब परमेश्वर ने मुझे अपने पिता का घर छोड़कर निकलने की आज्ञा दी, तब मैंने उससे कहा, ‘इतनी कृपा तुझे मुझ पर करनी होगी कि हम दोनों जहाँ-जहाँ जाएँ वहाँ-वहाँ तू मेरे विषय में कहना कि यह मेरा भाई है।’” ");
INSERT INTO hin2017_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","तब अबीमेलेक ने भेड़-बकरी, गाय-बैल, और दास-दासियाँ लेकर अब्राहम को दीं, और उसकी पत्नी सारा को भी उसे लौटा दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","और अबीमेलेक ने कहा, “देख, मेरा देश तेरे सामने है; जहाँ तुझे भाए वहाँ रह।” ");
INSERT INTO hin2017_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","और सारा से उसने कहा, “देख, मैंने तेरे भाई को रूपे के एक हजार टुकड़े दिए हैं। देख, तेरे सारे संगियों के सामने वही तेरी आँखों का परदा बनेगा, और सभी के सामने तू ठीक होगी।” ");
INSERT INTO hin2017_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","तब अब्राहम ने यहोवा से प्रार्थना की, और यहोवा ने अबीमेलेक, और उसकी पत्नी, और दासियों को चंगा किया और वे जनने लगीं। ");
INSERT INTO hin2017_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","क्योंकि यहोवा ने अब्राहम की पत्नी सारा के कारण अबीमेलेक के घर की सब स्त्रियों की कोखों को पूरी रीति से बन्द कर दिया था। ");
INSERT INTO hin2017_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","यहोवा ने जैसा कहा था वैसा ही सारा की सुधि लेकर उसके साथ अपने वचन के अनुसार किया। ");
INSERT INTO hin2017_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","सारा अब्राहम से गर्भवती होकर उसके बुढ़ापे में उसी नियुक्त समय पर जो परमेश्वर ने उससे ठहराया था, एक पुत्र उत्पन्न हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","अब्राहम ने अपने पुत्र का नाम जो सारा से उत्पन्न हुआ था इसहाक रखा। (मत्ती 1:2, लूका 3:34) ");
INSERT INTO hin2017_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","और जब उसका पुत्र इसहाक आठ दिन का हुआ, तब उसने परमेश्वर की आज्ञा के अनुसार उसका खतना किया। (प्रेरि. 7:8) ");
INSERT INTO hin2017_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","जब अब्राहम का पुत्र इसहाक उत्पन्न हुआ तब वह एक सौ वर्ष का था। ");
INSERT INTO hin2017_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","और सारा ने कहा, “परमेश्वर ने मुझे प्रफुल्लित किया है; इसलिए सब सुननेवाले भी मेरे साथ प्रफुल्लित होंगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","फिर उसने यह भी कहा, “क्या कोई कभी अब्राहम से कह सकता था, कि सारा लड़कों को दूध पिलाएगी? पर देखो, मुझसे उसके बुढ़ापे में एक पुत्र उत्पन्न हुआ।” ");
INSERT INTO hin2017_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","और वह लड़का बढ़ा और उसका दूध छुड़ाया गया; और इसहाक के दूध छुड़ाने के दिन अब्राहम ने बड़ा भोज किया। (गला. 4:22, इब्रा. 11:11) ");
INSERT INTO hin2017_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","तब सारा को मिस्री हागार का पुत्र, जो अब्राहम से उत्पन्न हुआ था, हँसी करता हुआ दिखाई पड़ा। ");
INSERT INTO hin2017_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","इस कारण उसने अब्राहम से कहा, “इस दासी को पुत्र सहित निकाल दे: क्योंकि इस दासी का पुत्र मेरे पुत्र इसहाक के साथ भागी न होगा।” (गला. 4:29) ");
INSERT INTO hin2017_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","यह बात अब्राहम को अपने पुत्र के कारण बुरी लगी। ");
INSERT INTO hin2017_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","तब परमेश्वर ने अब्राहम से कहा, “उस लड़के और अपनी दासी के कारण तुझे बुरा न लगे; जो बात सारा तुझ से कहे, उसे मान, क्योंकि जो तेरा वंश कहलाएगा सो इसहाक ही से चलेगा। (इब्रा. 11:18, रोम. 9:7) ");
INSERT INTO hin2017_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","दासी के पुत्र से भी मैं एक जाति उत्पन्न करूँगा इसलिए कि वह तेरा वंश है।” ");
INSERT INTO hin2017_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","इसलिए अब्राहम ने सवेरे तड़के उठकर रोटी और पानी से भरी चमड़े की थैली भी हागार को दी, और उसके कंधे पर रखी, और उसके लड़के को भी उसे देकर उसको विदा किया। वह चली गई, और बेर्शेबा के जंगल में भटकने लगी। ");
INSERT INTO hin2017_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","जब थैली का जल समाप्त हो गया, तब उसने लड़के को एक झाड़ी के नीचे छोड़ दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","और आप उससे तीर भर के टप्पे पर दूर जाकर उसके सामने यह सोचकर बैठ गई, “मुझ को लड़के की मृत्यु देखनी न पड़े।” तब वह उसके सामने बैठी हुई चिल्ला चिल्लाकर रोने लगी। ");
INSERT INTO hin2017_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","परमेश्वर ने उस लड़के की सुनी; और उसके दूत ने स्वर्ग से हागार को पुकारकर कहा, “हे हागार, तुझे क्या हुआ? मत डर; क्योंकि जहाँ तेरा लड़का है वहाँ से उसकी आवाज परमेश्वर को सुन पड़ी है। ");
INSERT INTO hin2017_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","उठ, अपने लड़के को उठा और अपने हाथ से सम्भाल; क्योंकि मैं उसके द्वारा एक बड़ी जाति बनाऊँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","तब परमेश्वर ने उसकी आँखें खोल दीं, और उसको एक कुआँ दिखाई पड़ा; तब उसने जाकर थैली को जल से भरकर लड़के को पिलाया। ");
INSERT INTO hin2017_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","और परमेश्वर उस लड़के के साथ रहा; और जब वह बड़ा हुआ, तब जंगल में रहते-रहते धनुर्धारी बन गया। ");
INSERT INTO hin2017_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","वह पारान नामक जंगल में रहा करता था; और उसकी माता ने उसके लिये मिस्र देश से एक स्त्री मँगवाई। ");
INSERT INTO hin2017_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","उन दिनों में ऐसा हुआ कि अबीमेलेक अपने सेनापति पीकोल को संग लेकर अब्राहम से कहने लगा, “जो कुछ तू करता है उसमें परमेश्वर तेरे संग रहता है; ");
INSERT INTO hin2017_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","इसलिए अब मुझसे यहाँ इस विषय में परमेश्वर की शपथ खा कि तू न तो मुझसे छल करेगा, और न कभी मेरे वंश से करेगा, परन्तु जैसी करुणा मैंने तुझ पर की है, वैसी ही तू मुझ पर और इस देश पर भी, जिसमें तू रहता है, करेगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","अब्राहम ने कहा, “मैं शपथ खाऊँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","और अब्राहम ने अबीमेलेक को एक कुएँ के विषय में जो अबीमेलेक के दासों ने बलपूर्वक ले लिया था, उलाहना दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","तब अबीमेलेक ने कहा, “मैं नहीं जानता कि किसने यह काम किया; और तूने भी मुझे नहीं बताया, और न मैंने आज से पहले इसके विषय में कुछ सुना।” ");
INSERT INTO hin2017_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","तब अब्राहम ने भेड़-बकरी, और गाय-बैल अबीमेलेक को दिए; और उन दोनों ने आपस में वाचा बाँधी। ");
INSERT INTO hin2017_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","अब्राहम ने सात मादा मेम्नों को अलग कर रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","तब अबीमेलेक ने अब्राहम से पूछा, “इन सात बच्चियों का, जो तूने अलग कर रखी हैं, क्या प्रयोजन है?” ");
INSERT INTO hin2017_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","उसने कहा, “तू इन सात बच्चियों को इस बात की साक्षी जानकर मेरे हाथ से ले कि मैंने यह कुआँ खोदा है।” ");
INSERT INTO hin2017_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","उन दोनों ने जो उस स्थान में आपस में शपथ खाई, इसी कारण उसका नाम बेर्शेबा पड़ा। ");
INSERT INTO hin2017_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","जब उन्होंने बेर्शेबा में परस्पर वाचा बाँधी, तब अबीमेलेक और उसका सेनापति पीकोल, उठकर पलिश्तियों के देश में लौट गए। ");
INSERT INTO hin2017_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","फिर अब्राहम ने बेर्शेबा में झाऊ का एक वृक्ष लगाया, और वहाँ यहोवा से जो सनातन परमेश्वर है, प्रार्थना की। ");
INSERT INTO hin2017_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","अब्राहम पलिश्तियों के देश में बहुत दिनों तक परदेशी होकर रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","इन बातों के पश्चात् ऐसा हुआ कि परमेश्वर ने, अब्राहम से यह कहकर उसकी परीक्षा की, “हे अब्राहम!” उसने कहा, “देख, मैं यहाँ हूँ।” (इब्रा. 11:17) ");
INSERT INTO hin2017_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","उसने कहा, “अपने पुत्र को अर्थात् अपने एकलौते पुत्र इसहाक को, जिससे तू प्रेम रखता है, संग लेकर मोरिय्याह देश में चला जा, और वहाँ उसको एक पहाड़ के ऊपर जो मैं तुझे बताऊँगा होमबलि करके चढ़ा।” ");
INSERT INTO hin2017_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","अतः अब्राहम सवेरे तड़के उठा और अपने गदहे पर काठी कसकर अपने दो सेवक, और अपने पुत्र इसहाक को संग लिया, और होमबलि के लिये लकड़ी चीर ली; तब निकलकर उस स्थान की ओर चला, जिसकी चर्चा परमेश्वर ने उससे की थी। ");
INSERT INTO hin2017_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","तीसरे दिन अब्राहम ने आँखें उठाकर उस स्थान को दूर से देखा। ");
INSERT INTO hin2017_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","और उसने अपने सेवकों से कहा, “गदहे के पास यहीं ठहरे रहो; यह लड़का और मैं वहाँ तक जाकर, और दण्डवत् करके, फिर तुम्हारे पास लौट आएँगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","तब अब्राहम ने होमबलि की लकड़ी ले अपने पुत्र इसहाक पर लादी, और आग और छुरी को अपने हाथ में लिया; और वे दोनों एक साथ चल पड़े। ");
INSERT INTO hin2017_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","इसहाक ने अपने पिता अब्राहम से कहा, “हे मेरे पिता,” उसने कहा, “हे मेरे पुत्र, क्या बात है?” उसने कहा, “देख, आग और लकड़ी तो हैं; पर होमबलि के लिये भेड़ कहाँ है?” ");
INSERT INTO hin2017_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहम ने कहा, “हे मेरे पुत्र, परमेश्वर होमबलि की भेड़ का उपाय आप ही करेगा।” और वे दोनों संग-संग आगे चलते गए। ");
INSERT INTO hin2017_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","जब वे उस स्थान को जिसे परमेश्वर ने उसको बताया था पहुँचे; तब अब्राहम ने वहाँ वेदी बनाकर लकड़ी को चुन-चुनकर रखा, और अपने पुत्र इसहाक को बाँधकर वेदी पर रखी लकड़ियों के ऊपर रख दिया। (याकू. 2:21) ");
INSERT INTO hin2017_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","फिर अब्राहम ने हाथ बढ़ाकर छुरी को ले लिया कि अपने पुत्र को बलि करे। ");
INSERT INTO hin2017_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","तब यहोवा के दूत ने स्वर्ग से उसको पुकारकर कहा, “हे अब्राहम, हे अब्राहम!” उसने कहा, “देख, मैं यहाँ हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","उसने कहा, “उस लड़के पर हाथ मत बढ़ा, और न उसे कुछ कर; क्योंकि तूने जो मुझसे अपने पुत्र, वरन् अपने एकलौते पुत्र को भी, नहीं रख छोड़ा; इससे मैं अब जान गया कि तू परमेश्वर का भय मानता है।” ");
INSERT INTO hin2017_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","तब अब्राहम ने आँखें उठाई, और क्या देखा, कि उसके पीछे एक मेढ़ा अपने सींगों से एक झाड़ी में फँसा हुआ है; अतः अब्राहम ने जाकर उस मेढ़े को लिया, और अपने पुत्र के स्थान पर होमबलि करके चढ़ाया। ");
INSERT INTO hin2017_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","अब्राहम ने उस स्थान का नाम यहोवा यिरे रखा, इसके अनुसार आज तक भी कहा जाता है, “यहोवा के पहाड़ पर प्रदान किया जाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","फिर यहोवा के दूत ने दूसरी बार स्वर्ग से अब्राहम को पुकारकर कहा, ");
INSERT INTO hin2017_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“यहोवा की यह वाणी है, कि मैं अपनी ही यह शपथ खाता हूँ कि तूने जो यह काम किया है कि अपने पुत्र, वरन् अपने एकलौते पुत्र को भी, नहीं रख छोड़ा; (लूका 1:73,74) ");
INSERT INTO hin2017_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","इस कारण मैं निश्चय तुझे आशीष दूँगा; और निश्चय तेरे वंश को आकाश के तारागण, और समुद्र तट के रेतकणों के समान अनगिनत करूँगा, और तेरा वंश अपने शत्रुओं के नगरों का अधिकारी होगा; (इब्रा. 6:13,14) ");
INSERT INTO hin2017_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","और पृथ्वी की सारी जातियाँ अपने को तेरे वंश के कारण धन्य मानेंगी: क्योंकि तूने मेरी बात मानी है।” ");
INSERT INTO hin2017_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","तब अब्राहम अपने सेवकों के पास लौट आया, और वे सब बेर्शेबा को संग-संग गए; और अब्राहम बेर्शेबा में रहने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","इन बातों के पश्चात् ऐसा हुआ कि अब्राहम को यह सन्देश मिला, “मिल्का के तेरे भाई नाहोर से सन्तान उत्पन्न हुई हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","मिल्का के पुत्र तो ये हुए, अर्थात् उसका जेठा ऊस, और ऊस का भाई बूज, और कमूएल, जो अराम का पिता हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","फिर केसेद, हज़ो, पिल्दाश, यिद्लाप, और बतूएल। ");
INSERT INTO hin2017_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","इन आठों को मिल्का ने अब्राहम के भाई नाहोर के द्वारा जन्म दिया। और बतूएल से रिबका उत्पन्न हुई। ");
INSERT INTO hin2017_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","फिर नाहोर के रूमा नामक एक रखैल भी थी; जिससे तेबह, गहम, तहश, और माका, उत्पन्न हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा तो एक सौ सताईस वर्ष की आयु को पहुँची; और जब सारा की इतनी आयु हुई; ");
INSERT INTO hin2017_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","तब वह किर्यतअर्बा में मर गई। यह तो कनान देश में है, और हेब्रोन भी कहलाता है। इसलिए अब्राहम सारा के लिये रोने-पीटने को वहाँ गया। ");
INSERT INTO hin2017_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","तब अब्राहम शव के पास से उठकर हित्तियों से कहने लगा, ");
INSERT INTO hin2017_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“मैं तुम्हारे बीच अतिथि और परदेशी हूँ; मुझे अपने मध्य में कब्रिस्तान के लिये ऐसी भूमि दो जो मेरी निज की हो जाए, कि मैं अपने मृतक को गाड़कर अपनी आँख से दूर करूँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","हित्तियों ने अब्राहम से कहा, ");
INSERT INTO hin2017_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“हे हमारे प्रभु, हमारी सुन; तू तो हमारे बीच में बड़ा प्रधान है। हमारी कब्रों में से जिसको तू चाहे उसमें अपने मृतक को गाड़; हम में से कोई तुझे अपनी कब्र के लेने से न रोकेगा, कि तू अपने मृतक को उसमें गाड़ने न पाए।” ");
INSERT INTO hin2017_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","तब अब्राहम उठकर खड़ा हुआ, और हित्तियों के सामने, जो उस देश के निवासी थे, दण्डवत् करके कहने लगा, ");
INSERT INTO hin2017_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“यदि तुम्हारी यह इच्छा हो कि मैं अपने मृतक को गाड़कर अपनी आँख से दूर करूँ, तो मेरी प्रार्थना है, कि सोहर के पुत्र एप्रोन से मेरे लिये विनती करो, ");
INSERT INTO hin2017_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","कि वह अपनी मकपेलावाली गुफा, जो उसकी भूमि की सीमा पर है; उसका पूरा दाम लेकर मुझे दे दे, कि वह तुम्हारे बीच कब्रिस्तान के लिये मेरी निज भूमि हो जाए।” ");
INSERT INTO hin2017_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","एप्रोन तो हित्तियों के बीच वहाँ बैठा हुआ था, इसलिए जितने हित्ती उसके नगर के फाटक से होकर भीतर जाते थे, उन सभी के सामने उसने अब्राहम को उत्तर दिया, ");
INSERT INTO hin2017_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“हे मेरे प्रभु, ऐसा नहीं, मेरी सुन; वह भूमि मैं तुझे देता हूँ, और उसमें जो गुफा है, वह भी मैं तुझे देता हूँ; अपने जातिभाइयों के सम्मुख मैं उसे तुझको दिए देता हूँ; अतः अपने मृतक को कब्र में रख।” ");
INSERT INTO hin2017_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","तब अब्राहम ने उस देश के निवासियों के सामने दण्डवत् किया। ");
INSERT INTO hin2017_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","और उनके सुनते हुए एप्रोन से कहा, “यदि तू ऐसा चाहे, तो मेरी सुन उस भूमि का जो दाम हो, वह मैं देना चाहता हूँ; उसे मुझसे ले ले, तब मैं अपने मुर्दे को वहाँ गाड़ूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","एप्रोन ने अब्राहम को यह उत्तर दिया, ");
INSERT INTO hin2017_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“हे मेरे प्रभु, मेरी बात सुन; उस भूमि का दाम तो चार सौ शेकेल रूपा है; पर मेरे और तेरे बीच में यह क्या है? अपने मुर्दे को कब्र में रख।” ");
INSERT INTO hin2017_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","अब्राहम ने एप्रोन की मानकर उसको उतना रूपा तौल दिया, जितना उसने हित्तियों के सुनते हुए कहा था, अर्थात् चार सौ ऐसे शेकेल जो व्यापारियों में चलते थे। ");
INSERT INTO hin2017_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","इस प्रकार एप्रोन की भूमि, जो मम्रे के सम्मुख मकपेला में थी, वह गुफा समेत, और उन सब वृक्षों समेत भी जो उसमें और उसके चारों ओर सीमा पर थे, ");
INSERT INTO hin2017_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","जितने हित्ती उसके नगर के फाटक से होकर भीतर जाते थे, उन सभी के सामने अब्राहम के अधिकार में पक्की रीति से आ गई। ");
INSERT INTO hin2017_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","इसके पश्चात् अब्राहम ने अपनी पत्नी सारा को उस मकपेलावाली भूमि की गुफा में जो मम्रे के अर्थात् हेब्रोन के सामने कनान देश में है, मिट्टी दी। ");
INSERT INTO hin2017_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","इस प्रकार वह भूमि गुफा समेत, जो उसमें थी, हित्तियों की ओर से कब्रिस्तान के लिये अब्राहम के अधिकार में पूरी रीति से आ गई। ");
INSERT INTO hin2017_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","अब्राहम अब वृद्ध हो गया था और उसकी आयु बहुत थी और यहोवा ने सब बातों में उसको आशीष दी थी। ");
INSERT INTO hin2017_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","अब्राहम ने अपने उस दास से, जो उसके घर में पुरनिया और उसकी सारी सम्पत्ति पर अधिकारी था, कहा, “अपना हाथ मेरी जाँघ के नीचे रख; ");
INSERT INTO hin2017_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","और मुझसे आकाश और पृथ्वी के परमेश्वर यहोवा की इस विषय में शपथ खा, कि तू मेरे पुत्र के लिये कनानियों की लड़कियों में से, जिनके बीच मैं रहता हूँ, किसी को न लाएगा। ");
INSERT INTO hin2017_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","परन्तु तू मेरे देश में मेरे ही कुटुम्बियों के पास जाकर मेरे पुत्र इसहाक के लिये एक पत्नी ले आएगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","दास ने उससे कहा, “कदाचित् वह स्त्री इस देश में मेरे साथ आना न चाहे; तो क्या मुझे तेरे पुत्र को उस देश में जहाँ से तू आया है ले जाना पड़ेगा?” ");
INSERT INTO hin2017_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","अब्राहम ने उससे कहा, “चौकस रह, मेरे पुत्र को वहाँ कभी न ले जाना।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","स्वर्ग का परमेश्वर यहोवा, जिसने मुझे मेरे पिता के घर से और मेरी जन्म-भूमि से ले आकर मुझसे शपथ खाकर कहा कि “मैं यह देश तेरे वंश को दूँगा; वही अपना दूत तेरे आगे-आगे भेजेगा, कि तू मेरे पुत्र के लिये वहाँ से एक स्त्री ले आए। ");
INSERT INTO hin2017_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","और यदि वह स्त्री तेरे साथ आना न चाहे तब तो तू मेरी इस शपथ से छूट जाएगा; पर मेरे पुत्र को वहाँ न ले जाना।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","तब उस दास ने अपने स्वामी अब्राहम की जाँघ के नीचे अपना हाथ रखकर उससे इस विषय की शपथ खाई। ");
INSERT INTO hin2017_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","तब वह दास अपने स्वामी के ऊँटों में से दस ऊँट छाँटकर उसके सब उत्तम-उत्तम पदार्थों में से कुछ कुछ लेकर चला; और अरम्नहरैम में नाहोर के नगर के पास पहुँचा। ");
INSERT INTO hin2017_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","और उसने ऊँटों को नगर के बाहर एक कुएँ के पास बैठाया। वह संध्या का समय था, जिस समय स्त्रियाँ जल भरने के लिये निकलती हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","वह कहने लगा, “हे मेरे स्वामी अब्राहम के परमेश्वर यहोवा, आज मेरे कार्य को सिद्ध कर, और मेरे स्वामी अब्राहम पर करुणा कर। ");
INSERT INTO hin2017_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","देख, मैं जल के इस सोते के पास खड़ा हूँ; और नगरवासियों की बेटियाँ जल भरने के लिये निकली आती हैं ");
INSERT INTO hin2017_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","इसलिए ऐसा होने दे कि जिस कन्या से मैं कहूँ, ‘अपना घड़ा मेरी ओर झुका, कि मैं पीऊँ,’ और वह कहे, ‘ले, पी ले, बाद में मैं तेरे ऊँटों को भी पिलाऊँगी,’ यह वही हो जिसे तूने अपने दास इसहाक के लिये ठहराया हो; इसी रीति मैं जान लूँगा कि तूने मेरे स्वामी पर करुणा की है।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","और ऐसा हुआ कि जब वह कह ही रहा था कि रिबका, जो अब्राहम के भाई नाहोर के जन्माये मिल्का के पुत्र, बतूएल की बेटी थी, वह कंधे पर घड़ा लिये हुए आई। ");
INSERT INTO hin2017_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","वह अति सुन्दर, और कुमारी थी, और किसी पुरुष का मुँह न देखा था। वह कुएँ में सोते के पास उतर गई, और अपना घड़ा भरकर फिर ऊपर आई। ");
INSERT INTO hin2017_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","तब वह दास उससे भेंट करने को दौड़ा, और कहा, “अपने घड़े में से थोड़ा पानी मुझे पिला दे।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","उसने कहा, “हे मेरे प्रभु, ले, पी ले,” और उसने फुर्ती से घड़ा उतारकर हाथ में लिये-लिये उसको पानी पिला दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","जब वह उसको पिला चुकी, तब कहा, “मैं तेरे ऊँटों के लिये भी तब तक पानी भर-भर लाऊँगी, जब तक वे पी न चुकें।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","तब वह फुर्ती से अपने घड़े का जल हौद में उण्डेलकर फिर कुएँ पर भरने को दौड़ गई; और उसके सब ऊँटों के लिये पानी भर दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","और वह पुरुष उसकी ओर चुपचाप अचम्भे के साथ ताकता हुआ यह सोचता था कि यहोवा ने मेरी यात्रा को सफल किया है कि नहीं। ");
INSERT INTO hin2017_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","जब ऊँट पी चुके, तब उस पुरुष ने आधा तोला सोने का एक नत्थ निकालकर उसको दिया, और दस तोले सोने के कंगन उसके हाथों में पहना दिए; ");
INSERT INTO hin2017_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","और पूछा, “तू किसकी बेटी है? यह मुझ को बता। क्या तेरे पिता के घर में हमारे टिकने के लिये स्थान है?” ");
INSERT INTO hin2017_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","उसने उत्तर दिया, “मैं तो नाहोर के जन्माए मिल्का के पुत्र बतूएल की बेटी हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","फिर उसने उससे कहा, “हमारे यहाँ पुआल और चारा बहुत है, और टिकने के लिये स्थान भी है।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","तब उस पुरुष ने सिर झुकाकर यहोवा को दण्डवत् करके कहा, ");
INSERT INTO hin2017_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“धन्य है मेरे स्वामी अब्राहम का परमेश्वर यहोवा, जिसने अपनी करुणा और सच्चाई को मेरे स्वामी पर से हटा नहीं लिया: यहोवा ने मुझ को ठीक मार्ग पर चलाकर मेरे स्वामी के भाई-बन्धुओं के घर पर पहुँचा दिया है।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","तब उस कन्या ने दौड़कर अपनी माता को इस घटना का सारा हाल बता दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","तब लाबान जो रिबका का भाई था, बाहर कुएँ के निकट उस पुरुष के पास दौड़ा गया। ");
INSERT INTO hin2017_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","और ऐसा हुआ कि जब उसने वह नत्थ और अपनी बहन रिबका के हाथों में वे कंगन भी देखे, और उसकी यह बात भी सुनी कि उस पुरुष ने मुझसे ऐसी बातें कहीं; तब वह उस पुरुष के पास गया; और क्या देखा, कि वह सोते के निकट ऊँटों के पास खड़ा है। ");
INSERT INTO hin2017_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","उसने कहा, “हे यहोवा की ओर से धन्य पुरुष भीतर आ तू क्यों बाहर खड़ा है? मैंने घर को, और ऊँटों के लिये भी स्थान तैयार किया है।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","इस पर वह पुरुष घर में गया; और लाबान ने ऊँटों की काठियाँ खोलकर पुआल और चारा दिया; और उसके और उसके साथियों के पाँव धोने को जल दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","तब अब्राहम के दास के आगे जलपान के लिये कुछ रखा गया; पर उसने कहा “मैं जब तक अपना प्रयोजन न कह दूँ, तब तक कुछ न खाऊँगा।” लाबान ने कहा, “कह दे।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","तब उसने कहा, “मैं तो अब्राहम का दास हूँ। ");
INSERT INTO hin2017_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","यहोवा ने मेरे स्वामी को बड़ी आशीष दी है; इसलिए वह महान पुरुष हो गया है; और उसने उसको भेड़-बकरी, गाय-बैल, सोना-रूपा, दास-दासियाँ, ऊँट और गदहे दिए हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","और मेरे स्वामी की पत्नी सारा के बुढ़ापे में उससे एक पुत्र उत्पन्न हुआ है; और उस पुत्र को अब्राहम ने अपना सब कुछ दे दिया है। ");
INSERT INTO hin2017_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","मेरे स्वामी ने मुझे यह शपथ खिलाई है, कि ‘मैं उसके पुत्र के लिये कनानियों की लड़कियों में से जिनके देश में वह रहता है, कोई स्त्री न ले आऊँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","मैं उसके पिता के घर, और कुल के लोगों के पास जाकर उसके पुत्र के लिये एक स्त्री ले आऊँगा।’ ");
INSERT INTO hin2017_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","तब मैंने अपने स्वामी से कहा, ‘कदाचित् वह स्त्री मेरे पीछे न आए।’ ");
INSERT INTO hin2017_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","तब उसने मुझसे कहा, ‘यहोवा, जिसके सामने मैं चलता आया हूँ, वह तेरे संग अपने दूत को भेजकर तेरी यात्रा को सफल करेगा; और तू मेरे कुल, और मेरे पिता के घराने में से मेरे पुत्र के लिये एक स्त्री ले आ सकेगा। ");
INSERT INTO hin2017_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","तू तब ही मेरी इस शपथ से छूटेगा, जब तू मेरे कुल के लोगों के पास पहुँचेगा; और यदि वे तुझे कोई स्त्री न दें, तो तू मेरी शपथ से छूटेगा।’ ");
INSERT INTO hin2017_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","इसलिए मैं आज उस कुएँ के निकट आकर कहने लगा, ‘हे मेरे स्वामी अब्राहम के परमेश्वर यहोवा, यदि तू मेरी इस यात्रा को सफल करता हो; ");
INSERT INTO hin2017_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","तो देख मैं जल के इस कुएँ के निकट खड़ा हूँ; और ऐसा हो, कि जो कुमारी जल भरने के लिये आए, और मैं उससे कहूँ, “अपने घड़े में से मुझे थोड़ा पानी पिला,” ");
INSERT INTO hin2017_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","और वह मुझसे कहे, “पी ले, और मैं तेरे ऊँटों के पीने के लिये भी पानी भर दूँगी,” वह वही स्त्री हो जिसको तूने मेरे स्वामी के पुत्र के लिये ठहराया है।’ ");
INSERT INTO hin2017_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","मैं मन ही मन यह कह ही रहा था, कि देख रिबका कंधे पर घड़ा लिये हुए निकल आई; फिर वह सोते के पास उतरकर भरने लगी। मैंने उससे कहा, ‘मुझे पानी पिला दे।’ ");
INSERT INTO hin2017_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","और उसने जल्दी से अपने घड़े को कंधे पर से उतार के कहा, ‘ले, पी ले, पीछे मैं तेरे ऊँटों को भी पिलाऊँगी,’ इस प्रकार मैंने पी लिया, और उसने ऊँटों को भी पिला दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","तब मैंने उससे पूछा, ‘तू किसकी बेटी है?’ और उसने कहा, ‘मैं तो नाहोर के जन्माए मिल्का के पुत्र बतूएल की बेटी हूँ,’ तब मैंने उसकी नाक में वह नत्थ, और उसके हाथों में वे कंगन पहना दिए। ");
INSERT INTO hin2017_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","फिर मैंने सिर झुकाकर यहोवा को दण्डवत् किया, और अपने स्वामी अब्राहम के परमेश्वर यहोवा को धन्य कहा, क्योंकि उसने मुझे ठीक मार्ग से पहुँचाया कि मैं अपने स्वामी के पुत्र के लिये उसके कुटुम्बी की पुत्री को ले जाऊँ। ");
INSERT INTO hin2017_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","इसलिए अब, यदि तुम मेरे स्वामी के साथ कृपा और सच्चाई का व्यवहार करना चाहते हो, तो मुझसे कहो; और यदि नहीं चाहते हो; तो भी मुझसे कह दो; ताकि मैं दाहिनी ओर, या बाईं ओर फिर जाऊँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","तब लाबान और बतूएल ने उत्तर दिया, “यह बात यहोवा की ओर से हुई है; इसलिए हम लोग तुझ से न तो भला कह सकते हैं न बुरा। ");
INSERT INTO hin2017_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","देख, रिबका तेरे सामने है, उसको ले जा, और वह यहोवा के वचन के अनुसार, तेरे स्वामी के पुत्र की पत्नी हो जाए।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","उनकी यह बात सुनकर, अब्राहम के दास ने भूमि पर गिरकर यहोवा को दण्डवत् किया। ");
INSERT INTO hin2017_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","फिर उस दास ने सोने और रूपे के गहने, और वस्त्र निकालकर रिबका को दिए; और उसके भाई और माता को भी उसने अनमोल-अनमोल वस्तुएँ दीं। ");
INSERT INTO hin2017_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","तब उसने अपने संगी जनों समेत भोजन किया, और रात वहीं बिताई। उसने तड़के उठकर कहा, “मुझ को अपने स्वामी के पास जाने के लिये विदा करो।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","रिबका के भाई और माता ने कहा, “कन्या को हमारे पास कुछ दिन, अर्थात् कम से कम दस दिन रहने दे; फिर उसके पश्चात् वह चली जाएगी।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","उसने उनसे कहा, “यहोवा ने जो मेरी यात्रा को सफल किया है; इसलिए तुम मुझे मत रोको अब मुझे विदा कर दो, कि मैं अपने स्वामी के पास जाऊँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","उन्होंने कहा, “हम कन्या को बुलाकर पूछते हैं, और देखेंगे, कि वह क्या कहती है।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","और उन्होंने रिबका को बुलाकर उससे पूछा, “क्या तू इस मनुष्य के संग जाएगी?” उसने कहा, “हाँ मैं जाऊँगी।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","तब उन्होंने अपनी बहन रिबका, और उसकी दाई और अब्राहम के दास, और उसके साथी सभी को विदा किया। ");
INSERT INTO hin2017_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","और उन्होंने रिबका को आशीर्वाद देकर कहा, “हे हमारी बहन, तू हजारों लाखों की आदिमाता हो, और तेरा वंश अपने बैरियों के नगरों का अधिकारी हो।” ");
INSERT INTO hin2017_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","तब रिबका अपनी सहेलियों समेत चली; और ऊँट पर चढ़कर उस पुरुष के पीछे हो ली। इस प्रकार वह दास रिबका को साथ लेकर चल दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","इसहाक जो दक्षिण देश में रहता था, लहैरोई नामक कुएँ से होकर चला आता था। ");
INSERT INTO hin2017_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","साँझ के समय वह मैदान में ध्यान करने के लिये निकला था; और उसने आँखें उठाकर क्या देखा, कि ऊँट चले आ रहे हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबका ने भी आँखें उठाकर इसहाक को देखा, और देखते ही ऊँट पर से उतर पड़ी। ");
INSERT INTO hin2017_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","तब उसने दास से पूछा, “जो पुरुष मैदान पर हम से मिलने को चला आता है, वह कौन है?” दास ने कहा, “वह तो मेरा स्वामी है।” तब रिबका ने घूँघट लेकर अपने मुँह को ढाँप लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","दास ने इसहाक से अपने साथ हुई घटना का वर्णन किया। ");
INSERT INTO hin2017_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","तब इसहाक रिबका को अपनी माता सारा के तम्बू में ले आया, और उसको ब्याह कर उससे प्रेम किया। इस प्रकार इसहाक को माता की मृत्यु के पश्चात् शान्ति प्राप्त हुई। ");
INSERT INTO hin2017_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","तब अब्राहम ने एक पत्नी ब्याह ली जिसका नाम कतूरा था। ");
INSERT INTO hin2017_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","उससे जिम्रान, योक्षान, मदना, मिद्यान, यिशबाक, और शूह उत्पन्न हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","योक्षान से शेबा और ददान उत्पन्न हुए; और ददान के वंश में अश्शूरी, लतूशी, और लुम्मी लोग हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिद्यान के पुत्र एपा, एपेर, हनोक, अबीदा, और एल्दा हुए, ये सब कतूरा की सन्तान हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","इसहाक को तो अब्राहम ने अपना सब कुछ दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","पर अपनी रखैलियों के पुत्रों को, कुछ कुछ देकर अपने जीते जी अपने पुत्र इसहाक के पास से पूर्व देश में भेज दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","अब्राहम की सारी आयु एक सौ पचहत्तर वर्ष की हुई। ");
INSERT INTO hin2017_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","अब्राहम का दीर्घायु होने के कारण अर्थात् पूरे बुढ़ापे की अवस्था में प्राण छूट गया; और वह अपने लोगों में जा मिला। ");
INSERT INTO hin2017_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","उसके पुत्र इसहाक और इश्माएल ने, हित्ती सोहर के पुत्र एप्रोन की मम्रे के सम्मुखवाली भूमि में, जो मकपेला की गुफा थी, उसमें उसको मिट्टी दी; ");
INSERT INTO hin2017_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","अर्थात् जो भूमि अब्राहम ने हित्तियों से मोल ली थी; उसी में अब्राहम, और उसकी पत्नी सारा, दोनों को मिट्टी दी गई। ");
INSERT INTO hin2017_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहम के मरने के पश्चात् परमेश्वर ने उसके पुत्र इसहाक को जो लहैरोई नामक कुएँ के पास रहता था, आशीष दी। ");
INSERT INTO hin2017_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","अब्राहम का पुत्र इश्माएल जो सारा की मिस्री दासी हागार से उत्पन्न हुआ था, उसकी यह वंशावली है। ");
INSERT INTO hin2017_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","इश्माएल के पुत्रों के नाम और वंशावली यह है: अर्थात् इश्माएल का जेठा पुत्र नबायोत, फिर केदार, अदबएल, मिबसाम, ");
INSERT INTO hin2017_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिश्मा, दूमा, मस्सा, ");
INSERT INTO hin2017_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, यतूर, नापीश, और केदमा। ");
INSERT INTO hin2017_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","इश्माएल के पुत्र ये ही हुए, और इन्हीं के नामों के अनुसार इनके गाँवों, और छावनियों के नाम भी पड़े; और ये ही बारह अपने-अपने कुल के प्रधान हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इश्माएल की सारी आयु एक सौ सैंतीस वर्ष की हुई; तब उसके प्राण छूट गए, और वह अपने लोगों में जा मिला। ");
INSERT INTO hin2017_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","और उसके वंश हवीला से शूर तक, जो मिस्र के सम्मुख अश्शूर के मार्ग में है, बस गए; और उनका भाग उनके सब भाई-बन्धुओं के सम्मुख पड़ा। ");
INSERT INTO hin2017_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","अब्राहम के पुत्र इसहाक की वंशावली यह है: अब्राहम से इसहाक उत्पन्न हुआ; ");
INSERT INTO hin2017_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","और इसहाक ने चालीस वर्ष का होकर रिबका को, जो पद्दनराम के वासी, अरामी बतूएल की बेटी, और अरामी लाबान की बहन थी, ब्याह लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","इसहाक की पत्नी तो बाँझ थी, इसलिए उसने उसके निमित्त यहोवा से विनती की; और यहोवा ने उसकी विनती सुनी, इस प्रकार उसकी पत्नी रिबका गर्भवती हुई। ");
INSERT INTO hin2017_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","लड़के उसके गर्भ में आपस में लिपटकर एक दूसरे को मारने लगे। तब उसने कहा, “मेरी जो ऐसी ही दशा रहेगी तो मैं कैसे जीवित रहूँगी?” और वह यहोवा की इच्छा पूछने को गई। ");
INSERT INTO hin2017_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","तब यहोवा ने उससे कहा, “तेरे गर्भ में दो जातियाँ हैं, और तेरी कोख से निकलते ही दो राज्य के लोग अलग-अलग होंगे, और एक राज्य के लोग दूसरे से अधिक सामर्थी होंगे और बड़ा बेटा छोटे के अधीन होगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","जब उसके पुत्र उत्पन्न होने का समय आया, तब क्या प्रगट हुआ, कि उसके गर्भ में जुड़वे बालक हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","पहला जो उत्पन्न हुआ वह लाल निकला, और उसका सारा शरीर कम्बल के समान रोममय था; इसलिए उसका नाम एसाव रखा गया। ");
INSERT INTO hin2017_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","पीछे उसका भाई अपने हाथ से एसाव की एड़ी पकड़े हुए उत्पन्न हुआ; और उसका नाम याकूब रखा गया। जब रिबका ने उनको जन्म दिया तब इसहाक साठ वर्ष का था। ");
INSERT INTO hin2017_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","फिर वे लड़के बढ़ने लगे और एसाव तो वनवासी होकर चतुर शिकार खेलनेवाला हो गया, पर याकूब सीधा मनुष्य था, और तम्बुओं में रहा करता था। ");
INSERT INTO hin2017_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","इसहाक एसाव के अहेर का माँस खाया करता था, इसलिए वह उससे प्रीति रखता था; पर रिबका याकूब से प्रीति रखती थी। ");
INSERT INTO hin2017_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","एक दिन याकूब भोजन के लिये कुछ दाल पका रहा था; और एसाव मैदान से थका हुआ आया। ");
INSERT INTO hin2017_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","तब एसाव ने याकूब से कहा, “वह जो लाल वस्तु है, उसी लाल वस्तु में से मुझे कुछ खिला, क्योंकि मैं थका हूँ।” इसी कारण उसका नाम एदोम भी पड़ा। ");
INSERT INTO hin2017_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","याकूब ने कहा, “अपना पहलौठे का अधिकार आज मेरे हाथ बेच दे।” ");
INSERT INTO hin2017_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसाव ने कहा, “देख, मैं तो अभी मरने पर हूँ इसलिए पहलौठे के अधिकार से मेरा क्या लाभ होगा?” ");
INSERT INTO hin2017_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","याकूब ने कहा, “मुझसे अभी शपथ खा,” अतः उसने उससे शपथ खाई, और अपना पहलौठे का अधिकार याकूब के हाथ बेच डाला। ");
INSERT INTO hin2017_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","इस पर याकूब ने एसाव को रोटी और पकाई हुई मसूर की दाल दी; और उसने खाया पिया, तब उठकर चला गया। इस प्रकार एसाव ने अपना पहलौठे का अधिकार तुच्छ जाना। ");
INSERT INTO hin2017_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","उस देश में अकाल पड़ा, वह उस पहले अकाल से अलग था जो अब्राहम के दिनों में पड़ा था। इसलिए इसहाक गरार को पलिश्तियों के राजा अबीमेलेक के पास गया। ");
INSERT INTO hin2017_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","वहाँ यहोवा ने उसको दर्शन देकर कहा, “मिस्र में मत जा; जो देश मैं तुझे बताऊँ उसी में रह। ");
INSERT INTO hin2017_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","तू इसी देश में रह, और मैं तेरे संग रहूँगा, और तुझे आशीष दूँगा; और ये सब देश मैं तुझको, और तेरे वंश को दूँगा; और जो शपथ मैंने तेरे पिता अब्राहम से खाई थी, उसे मैं पूरी करूँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","और मैं तेरे वंश को आकाश के तारागण के समान करूँगा; और मैं तेरे वंश को ये सब देश दूँगा, और पृथ्वी की सारी जातियाँ तेरे वंश के कारण अपने को धन्य मानेंगी। (उत्प. 15:5) ");
INSERT INTO hin2017_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","क्योंकि अब्राहम ने मेरी मानी, और जो मैंने उसे सौंपा था उसको और मेरी आज्ञाओं, विधियों और व्यवस्था का पालन किया।” ");
INSERT INTO hin2017_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","इसलिए इसहाक गरार में रह गया। ");
INSERT INTO hin2017_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","जब उस स्थान के लोगों ने उसकी पत्नी के विषय में पूछा, तब उसने यह सोचकर कि यदि मैं उसको अपनी पत्नी कहूँ, तो यहाँ के लोग रिबका के कारण जो परम सुन्दरी है मुझ को मार डालेंगे, उत्तर दिया, “वह तो मेरी बहन है।” ");
INSERT INTO hin2017_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","जब उसको वहाँ रहते बहुत दिन बीत गए, तब एक दिन पलिश्तियों के राजा अबीमेलेक ने खिड़की में से झाँककर क्या देखा कि इसहाक अपनी पत्नी रिबका के साथ क्रीड़ा कर रहा है। ");
INSERT INTO hin2017_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","तब अबीमेलेक ने इसहाक को बुलवाकर कहा, “वह तो निश्चय तेरी पत्नी है; फिर तूने क्यों उसको अपनी बहन कहा?” इसहाक ने उत्तर दिया, “मैंने सोचा था, कि ऐसा न हो कि उसके कारण मेरी मृत्यु हो।” ");
INSERT INTO hin2017_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमेलेक ने कहा, “तूने हम से यह क्या किया? ऐसे तो प्रजा में से कोई तेरी पत्नी के साथ सहज से कुकर्म कर सकता, और तू हमको पाप में फँसाता।” ");
INSERT INTO hin2017_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","इसलिए अबीमेलेक ने अपनी सारी प्रजा को आज्ञा दी, “जो कोई उस पुरुष को या उस स्त्री को छूएगा, वह निश्चय मार डाला जाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","फिर इसहाक ने उस देश में जोता बोया, और उसी वर्ष में सौ गुणा फल पाया; और यहोवा ने उसको आशीष दी, ");
INSERT INTO hin2017_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","और वह बढ़ा और उसकी उन्नति होती चली गई, यहाँ तक कि वह बहुत धनी पुरुष हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","जब उसके भेड़-बकरी, गाय-बैल, और बहुत से दास-दासियाँ हुईं, तब पलिश्ती उससे डाह करने लगे। ");
INSERT INTO hin2017_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","इसलिए जितने कुओं को उसके पिता अब्राहम के दासों ने अब्राहम के जीते जी खोदा था, उनको पलिश्तियों ने मिट्टी से भर दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","तब अबीमेलेक ने इसहाक से कहा, “हमारे पास से चला जा; क्योंकि तू हम से बहुत सामर्थी हो गया है।” ");
INSERT INTO hin2017_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","अतः इसहाक वहाँ से चला गया, और गरार की घाटी में अपना तम्बू खड़ा करके वहाँ रहने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","तब जो कुएँ उसके पिता अब्राहम के दिनों में खोदे गए थे, और अब्राहम के मरने के पीछे पलिश्तियों ने भर दिए थे, उनको इसहाक ने फिर से खुदवाया; और उनके वे ही नाम रखे, जो उसके पिता ने रखे थे। ");
INSERT INTO hin2017_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","फिर इसहाक के दासों को घाटी में खोदते-खोदते बहते जल का एक सोता मिला। ");
INSERT INTO hin2017_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","तब गरार के चरवाहों ने इसहाक के चरवाहों से झगड़ा किया, और कहा, “यह जल हमारा है।” इसलिए उसने उस कुएँ का नाम एसेक रखा; क्योंकि वे उससे झगड़े थे। ");
INSERT INTO hin2017_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","फिर उन्होंने दूसरा कुआँ खोदा; और उन्होंने उसके लिये भी झगड़ा किया, इसलिए उसने उसका नाम सित्ना रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","तब उसने वहाँ से निकलकर एक और कुआँ खुदवाया; और उसके लिये उन्होंने झगड़ा न किया; इसलिए उसने उसका नाम यह कहकर रहोबोत रखा, “अब तो यहोवा ने हमारे लिये बहुत स्थान दिया है, और हम इस देश में फूले-फलेंगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","वहाँ से वह बेर्शेबा को गया। ");
INSERT INTO hin2017_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","और उसी दिन यहोवा ने रात को उसे दर्शन देकर कहा, “मैं तेरे पिता अब्राहम का परमेश्वर हूँ; मत डर, क्योंकि मैं तेरे साथ हूँ, और अपने दास अब्राहम के कारण तुझे आशीष दूँगा, और तेरा वंश बढ़ाऊँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","तब उसने वहाँ एक वेदी बनाई, और यहोवा से प्रार्थना की, और अपना तम्बू वहीं खड़ा किया; और वहाँ इसहाक के दासों ने एक कुआँ खोदा। ");
INSERT INTO hin2017_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","तब अबीमेलेक अपने सलाहकार अहुज्जत, और अपने सेनापति पीकोल को संग लेकर, गरार से उसके पास गया। ");
INSERT INTO hin2017_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","इसहाक ने उनसे कहा, “तुम ने मुझसे बैर करके अपने बीच से निकाल दिया था, अब मेरे पास क्यों आए हो?” ");
INSERT INTO hin2017_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","उन्होंने कहा, “हमने तो प्रत्यक्ष देखा है, कि यहोवा तेरे साथ रहता है; इसलिए हमने सोचा, कि तू तो यहोवा की ओर से धन्य है, अतः हमारे तेरे बीच में शपथ खाई जाए, और हम तुझ से इस विषय की वाचा बन्धाएँ; ");
INSERT INTO hin2017_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","कि जैसे हमने तुझे नहीं छुआ, वरन् तेरे साथ केवल भलाई ही की है, और तुझको कुशल क्षेम से विदा किया, उसके अनुसार तू भी हम से कोई बुराई न करेगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","तब उसने उनको भोज दिया, और उन्होंने खाया-पिया। ");
INSERT INTO hin2017_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","सवेरे उन सभी ने तड़के उठकर आपस में शपथ खाई; तब इसहाक ने उनको विदा किया, और वे कुशल क्षेम से उसके पास से चले गए। ");
INSERT INTO hin2017_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","उसी दिन इसहाक के दासों ने आकर अपने उस खोदे हुए कुएँ का वृत्तान्त सुनाकर कहा, “हमको जल का एक सोता मिला है।” ");
INSERT INTO hin2017_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","तब उसने उसका नाम शिबा रखा; इसी कारण उस नगर का नाम आज तक बेर्शेबा पड़ा है। ");
INSERT INTO hin2017_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","जब एसाव चालीस वर्ष का हुआ, तब उसने हित्ती बेरी की बेटी यहूदीत, और हित्ती एलोन की बेटी बासमत को ब्याह लिया; ");
INSERT INTO hin2017_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","और इन स्त्रियों के कारण इसहाक और रिबका के मन को खेद हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","जब इसहाक बूढ़ा हो गया, और उसकी आँखें ऐसी धुंधली पड़ गईं कि उसको सूझता न था, तब उसने अपने जेठे पुत्र एसाव को बुलाकर कहा, “हे मेरे पुत्र,” उसने कहा, “क्या आज्ञा।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","उसने कहा, “सुन, मैं तो बूढ़ा हो गया हूँ, और नहीं जानता कि मेरी मृत्यु का दिन कब होगा ");
INSERT INTO hin2017_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","इसलिए अब तू अपना तरकश और धनुष आदि हथियार लेकर मैदान में जा, और मेरे लिये अहेर कर ले आ। ");
INSERT INTO hin2017_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","तब मेरी रूचि के अनुसार स्वादिष्ट भोजन बनाकर मेरे पास ले आना, कि मैं उसे खाकर मरने से पहले तुझे जी भरकर आशीर्वाद दूँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","तब एसाव अहेर करने को मैदान में गया। जब इसहाक एसाव से यह बात कह रहा था, तब रिबका सुन रही थी। ");
INSERT INTO hin2017_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","इसलिए उसने अपने पुत्र याकूब से कहा, “सुन, मैंने तेरे पिता को तेरे भाई एसाव से यह कहते सुना है, ");
INSERT INTO hin2017_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘तू मेरे लिये अहेर करके उसका स्वादिष्ट भोजन बना, कि मैं उसे खाकर तुझे यहोवा के आगे मरने से पहले आशीर्वाद दूँ।’ ");
INSERT INTO hin2017_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","इसलिए अब, हे मेरे पुत्र, मेरी सुन, और यह आज्ञा मान, ");
INSERT INTO hin2017_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","कि बकरियों के पास जाकर बकरियों के दो अच्छे-अच्छे बच्चे ले आ; और मैं तेरे पिता के लिये उसकी रूचि के अनुसार उनके माँस का स्वादिष्ट भोजन बनाऊँगी। ");
INSERT INTO hin2017_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","तब तू उसको अपने पिता के पास ले जाना, कि वह उसे खाकर मरने से पहले तुझको आशीर्वाद दे।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","याकूब ने अपनी माता रिबका से कहा, “सुन, मेरा भाई एसाव तो रोंआर पुरुष है, और मैं रोमहीन पुरुष हूँ। ");
INSERT INTO hin2017_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","कदाचित् मेरा पिता मुझे टटोलने लगे, तो मैं उसकी दृष्टि में ठग ठहरूँगा; और आशीष के बदले श्राप ही कमाऊँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","उसकी माता ने उससे कहा, “हे मेरे, पुत्र, श्राप तुझ पर नहीं मुझी पर पड़े, तू केवल मेरी सुन, और जाकर वे बच्चे मेरे पास ले आ।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","तब याकूब जाकर उनको अपनी माता के पास ले आया, और माता ने उसके पिता की रूचि के अनुसार स्वादिष्ट भोजन बना दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","तब रिबका ने अपने पहलौठे पुत्र एसाव के सुन्दर वस्त्र, जो उसके पास घर में थे, लेकर अपने छोटे पुत्र याकूब को पहना दिए। ");
INSERT INTO hin2017_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","और बकरियों के बच्चों की खालों को उसके हाथों में और उसके चिकने गले में लपेट दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","और वह स्वादिष्ट भोजन और अपनी बनाई हुई रोटी भी अपने पुत्र याकूब के हाथ में दे दी। ");
INSERT INTO hin2017_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","तब वह अपने पिता के पास गया, और कहा, “हे मेरे पिता,” उसने कहा, “क्या बात है? हे मेरे पुत्र, तू कौन है?” ");
INSERT INTO hin2017_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकूब ने अपने पिता से कहा, “मैं तेरा जेठा पुत्र एसाव हूँ। मैंने तेरी आज्ञा के अनुसार किया है; इसलिए उठ और बैठकर मेरे अहेर के माँस में से खा, कि तू जी से मुझे आशीर्वाद दे।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","इसहाक ने अपने पुत्र से कहा, “हे मेरे पुत्र, क्या कारण है कि वह तुझे इतनी जल्दी मिल गया?” उसने यह उत्तर दिया, “तेरे परमेश्वर यहोवा ने उसको मेरे सामने कर दिया।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","फिर इसहाक ने याकूब से कहा, “हे मेरे पुत्र, निकट आ, मैं तुझे टटोलकर जानूँ, कि तू सचमुच मेरा पुत्र एसाव है या नहीं।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","तब याकूब अपने पिता इसहाक के निकट गया, और उसने उसको टटोलकर कहा, “बोल तो याकूब का सा है, पर हाथ एसाव ही के से जान पड़ते हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","और उसने उसको नहीं पहचाना, क्योंकि उसके हाथ उसके भाई के से रोंआर थे। अतः उसने उसको आशीर्वाद दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","और उसने पूछा, “क्या तू सचमुच मेरा पुत्र एसाव है?” उसने कहा, “हाँ मैं हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","तब उसने कहा, “भोजन को मेरे निकट ले आ, कि मैं, अपने पुत्र के अहेर के माँस में से खाकर, तुझे जी से आशीर्वाद दूँ।” तब वह उसको उसके निकट ले आया, और उसने खाया; और वह उसके पास दाखमधु भी लाया, और उसने पिया। ");
INSERT INTO hin2017_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","तब उसके पिता इसहाक ने उससे कहा, “हे मेरे पुत्र निकट आकर मुझे चूम।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","उसने निकट जाकर उसको चूमा। और उसने उसके वस्त्रों का सुगन्ध पाकर उसको वह आशीर्वाद दिया, “देख, मेरे पुत्र की सुगन्ध जो ऐसे खेत की सी है जिस पर यहोवा ने आशीष दी हो; ");
INSERT INTO hin2017_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","परमेश्वर तुझे आकाश से ओस, और भूमि की उत्तम से उत्तम उपज, और बहुत सा अनाज और नया दाखमधु दे; ");
INSERT INTO hin2017_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","राज्य-राज्य के लोग तेरे अधीन हों, और देश-देश के लोग तुझे दण्डवत् करें; तू अपने भाइयों का स्वामी हो, और तेरी माता के पुत्र तुझे दण्डवत् करें। जो तुझे श्राप दें वे आप ही श्रापित हों, और जो तुझे आशीर्वाद दें वे आशीष पाएँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","जैसे ही यह आशीर्वाद इसहाक याकूब को दे चुका, और याकूब अपने पिता इसहाक के सामने से निकला ही था, कि एसाव अहेर लेकर आ पहुँचा। ");
INSERT INTO hin2017_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","तब वह भी स्वादिष्ट भोजन बनाकर अपने पिता के पास ले आया, और उसने कहा, “हे मेरे पिता, उठकर अपने पुत्र के अहेर का माँस खा, ताकि मुझे जी से आशीर्वाद दे।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","उसके पिता इसहाक ने पूछा, “तू कौन है?” उसने कहा, “मैं तेरा जेठा पुत्र एसाव हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","तब इसहाक ने अत्यन्त थरथर काँपते हुए कहा, “फिर वह कौन था जो अहेर करके मेरे पास ले आया था, और मैंने तेरे आने से पहले सब में से कुछ कुछ खा लिया और उसको आशीर्वाद दिया? वरन् उसको आशीष लगी भी रहेगी।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","अपने पिता की यह बात सुनते ही एसाव ने अत्यन्त ऊँचे और दुःख भरे स्वर से चिल्लाकर अपने पिता से कहा, “हे मेरे पिता, मुझ को भी आशीर्वाद दे!” ");
INSERT INTO hin2017_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","उसने कहा, “तेरा भाई धूर्तता से आया, और तेरे आशीर्वाद को लेकर चला गया।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","उसने कहा, “क्या उसका नाम याकूब यथार्थ नहीं रखा गया? उसने मुझे दो बार अड़ंगा मारा, मेरा पहलौठे का अधिकार तो उसने ले ही लिया था; और अब देख, उसने मेरा आशीर्वाद भी ले लिया है।” फिर उसने कहा, “क्या तूने मेरे लिये भी कोई आशीर्वाद नहीं सोच रखा है?” ");
INSERT INTO hin2017_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इसहाक ने एसाव को उत्तर देकर कहा, “सुन, मैंने उसको तेरा स्वामी ठहराया, और उसके सब भाइयों को उसके अधीन कर दिया, और अनाज और नया दाखमधु देकर उसको पुष्ट किया है। इसलिए अब, हे मेरे पुत्र, मैं तेरे लिये क्या करूँ?” ");
INSERT INTO hin2017_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","एसाव ने अपने पिता से कहा, “हे मेरे पिता, क्या तेरे मन में एक ही आशीर्वाद है? हे मेरे पिता, मुझ को भी आशीर्वाद दे।” यह कहकर एसाव फूट फूटकर रोया। ");
INSERT INTO hin2017_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","उसके पिता इसहाक ने उससे कहा, “सुन, तेरा निवास उपजाऊ भूमि से दूर हो, और ऊपर से आकाश की ओस उस पर न पड़े। ");
INSERT INTO hin2017_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तू अपनी तलवार के बल से जीवित रहे, और अपने भाई के अधीन तो होए; पर जब तू स्वाधीन हो जाएगा, तब उसके जूए को अपने कंधे पर से तोड़ फेंके।” (इब्रा. 11:20) ");
INSERT INTO hin2017_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","एसाव ने तो याकूब से अपने पिता के दिए हुए आशीर्वाद के कारण बैर रखा; और उसने सोचा, “मेरे पिता के अन्तकाल का दिन निकट है, फिर मैं अपने भाई याकूब को घात करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","जब रिबका को अपने पहलौठे पुत्र एसाव की ये बातें बताई गईं, तब उसने अपने छोटे पुत्र याकूब को बुलाकर कहा, “सुन, तेरा भाई एसाव तुझे घात करने के लिये अपने मन में धीरज रखे हुए है। ");
INSERT INTO hin2017_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","इसलिए अब, हे मेरे पुत्र, मेरी सुन, और हारान को मेरे भाई लाबान के पास भाग जा; ");
INSERT INTO hin2017_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","और थोड़े दिन तक, अर्थात् जब तक तेरे भाई का क्रोध न उतरे तब तक उसी के पास रहना। ");
INSERT INTO hin2017_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","फिर जब तेरे भाई का क्रोध तुझ पर से उतरे, और जो काम तूने उससे किया है उसको वह भूल जाए; तब मैं तुझे वहाँ से बुलवा भेजूँगी। ऐसा क्यों हो कि एक ही दिन में मुझे तुम दोनों से वंचित होना पड़े?” ");
INSERT INTO hin2017_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","फिर रिबका ने इसहाक से कहा, “हित्ती लड़कियों के कारण मैं अपने प्राण से घिन करती हूँ; इसलिए यदि ऐसी हित्ती लड़कियों में से, जैसी इस देश की लड़कियाँ हैं, याकूब भी एक को कहीं ब्याह ले, तो मेरे जीवन में क्या लाभ होगा?” ");
INSERT INTO hin2017_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","तब इसहाक ने याकूब को बुलाकर आशीर्वाद दिया, और आज्ञा दी, “तू किसी कनानी लड़की को न ब्याह लेना। ");
INSERT INTO hin2017_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","पद्दनराम में अपने नाना बतूएल के घर जाकर वहाँ अपने मामा लाबान की एक बेटी को ब्याह लेना। ");
INSERT INTO hin2017_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","सर्वशक्तिमान परमेश्वर तुझे आशीष दे, और फलवन्त करके बढ़ाए, और तू राज्य-राज्य की मण्डली का मूल हो। ");
INSERT INTO hin2017_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","वह तुझे और तेरे वंश को भी अब्राहम की सी आशीष दे, कि तू यह देश जिसमें तू परदेशी होकर रहता है, और जिसे परमेश्वर ने अब्राहम को दिया था, उसका अधिकारी हो जाए।” ");
INSERT INTO hin2017_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","तब इसहाक ने याकूब को विदा किया, और वह पद्दनराम को अरामी बतूएल के पुत्र लाबान के पास चला, जो याकूब और एसाव की माता रिबका का भाई था। ");
INSERT INTO hin2017_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","जब एसाव को पता चला कि इसहाक ने याकूब को आशीर्वाद देकर पद्दनराम भेज दिया, कि वह वहीं से पत्नी लाए, और उसको आशीर्वाद देने के समय यह आज्ञा भी दी, “तू किसी कनानी लड़की को ब्याह न लेना,” ");
INSERT INTO hin2017_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","और याकूब माता-पिता की मानकर पद्दनराम को चल दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","तब एसाव यह सब देखकर और यह भी सोचकर कि कनानी लड़कियाँ मेरे पिता इसहाक को बुरी लगती हैं, ");
INSERT INTO hin2017_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","अब्राहम के पुत्र इश्माएल के पास गया, और इश्माएल की बेटी महलत को, जो नबायोत की बहन थी, ब्याह कर अपनी पत्नियों में मिला लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याकूब बेर्शेबा से निकलकर हारान की ओर चला। ");
INSERT INTO hin2017_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","और उसने किसी स्थान में पहुँचकर रात वहीं बिताने का विचार किया, क्योंकि सूर्य अस्त हो गया था; इसलिए उसने उस स्थान के पत्थरों में से एक पत्थर ले अपना तकिया बनाकर रखा, और उसी स्थान में सो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","तब उसने स्वप्न में क्या देखा, कि एक सीढ़ी पृथ्वी पर खड़ी है, और उसका सिरा स्वर्ग तक पहुँचा है; और परमेश्वर के दूत उस पर से चढ़ते-उतरते हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","और यहोवा उसके ऊपर खड़ा होकर कहता है, “मैं यहोवा, तेरे दादा अब्राहम का परमेश्वर, और इसहाक का भी परमेश्वर हूँ; जिस भूमि पर तू लेटा है, उसे मैं तुझको और तेरे वंश को दूँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","और तेरा वंश भूमि की धूल के किनकों के समान बहुत होगा, और पश्चिम, पूरब, उत्तर, दक्षिण, चारों ओर फैलता जाएगा: और तेरे और तेरे वंश के द्वारा पृथ्वी के सारे कुल आशीष पाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","और सुन, मैं तेरे संग रहूँगा, और जहाँ कहीं तू जाए वहाँ तेरी रक्षा करूँगा, और तुझे इस देश में लौटा ले आऊँगा: मैं अपने कहे हुए को जब तक पूरा न कर लूँ तब तक तुझको न छोड़ूँगा।” (यशा. 41:10) ");
INSERT INTO hin2017_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","तब याकूब जाग उठा, और कहने लगा, “निश्चय इस स्थान में यहोवा है; और मैं इस बात को न जानता था।” ");
INSERT INTO hin2017_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","और भय खाकर उसने कहा, “यह स्थान क्या ही भयानक है! यह तो परमेश्वर के भवन को छोड़ और कुछ नहीं हो सकता; वरन् यह स्वर्ग का फाटक ही होगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","भोर को याकूब उठा, और अपने तकिये का पत्थर लेकर उसका खम्भा खड़ा किया, और उसके सिरे पर तेल डाल दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","और उसने उस स्थान का नाम बेतेल रखा; पर उस नगर का नाम पहले लूज था। ");
INSERT INTO hin2017_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","याकूब ने यह मन्नत मानी, “यदि परमेश्वर मेरे संग रहकर इस यात्रा में मेरी रक्षा करे, और मुझे खाने के लिये रोटी, और पहनने के लिये कपड़ा दे, ");
INSERT INTO hin2017_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","और मैं अपने पिता के घर में कुशल क्षेम से लौट आऊँ; तो यहोवा मेरा परमेश्वर ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","और यह पत्थर, जिसका मैंने खम्भा खड़ा किया है, परमेश्वर का भवन ठहरेगा: और जो कुछ तू मुझे दे उसका दशमांश मैं अवश्य ही तुझे दिया करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","फिर याकूब ने अपना मार्ग लिया, और पूर्वियों के देश में आया। ");
INSERT INTO hin2017_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","और उसने दृष्टि करके क्या देखा, कि मैदान में एक कुआँ है, और उसके पास भेड़-बकरियों के तीन झुण्ड बैठे हुए हैं; क्योंकि जो पत्थर उस कुएँ के मुँह पर धरा रहता था, जिसमें से झुण्डों को जल पिलाया जाता था, वह भारी था। ");
INSERT INTO hin2017_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","और जब सब झुण्ड वहाँ इकट्ठे हो जाते तब चरवाहे उस पत्थर को कुएँ के मुँह पर से लुढ़काकर भेड़-बकरियों को पानी पिलाते, और फिर पत्थर को कुएँ के मुँह पर ज्यों का त्यों रख देते थे। ");
INSERT INTO hin2017_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","अतः याकूब ने चरवाहों से पूछा, “हे मेरे भाइयों, तुम कहाँ के हो?” उन्होंने कहा, “हम हारान के हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","तब उसने उनसे पूछा, “क्या तुम नाहोर के पोते लाबान को जानते हो?” उन्होंने कहा, “हाँ, हम उसे जानते हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","फिर उसने उनसे पूछा, “क्या वह कुशल से है?” उन्होंने कहा, “हाँ, कुशल से है और वह देख, उसकी बेटी राहेल भेड़-बकरियों को लिये हुए चली आती है।” ");
INSERT INTO hin2017_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","उसने कहा, “देखो, अभी तो दिन बहुत है, पशुओं के इकट्ठे होने का समय नहीं; इसलिए भेड़-बकरियों को जल पिलाकर फिर ले जाकर चराओ।” ");
INSERT INTO hin2017_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","उन्होंने कहा, “हम अभी ऐसा नहीं कर सकते, जब सब झुण्ड इकट्ठे होते हैं तब पत्थर कुएँ के मुँह से लुढ़काया जाता है, और तब हम भेड़-बकरियों को पानी पिलाते हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","उनकी यह बातचीत हो रही थी, कि राहेल जो पशु चराया करती थी, अपने पिता की भेड़-बकरियों को लिये हुए आ गई। ");
INSERT INTO hin2017_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","अपने मामा लाबान की बेटी राहेल को, और उसकी भेड़-बकरियों को भी देखकर याकूब ने निकट जाकर कुएँ के मुँह पर से पत्थर को लुढ़काकर अपने मामा लाबान की भेड़-बकरियों को पानी पिलाया। ");
INSERT INTO hin2017_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","तब याकूब ने राहेल को चूमा, और ऊँचे स्वर से रोया। ");
INSERT INTO hin2017_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","और याकूब ने राहेल को बता दिया, कि मैं तेरा फुफेरा भाई हूँ, अर्थात् रिबका का पुत्र हूँ। तब उसने दौड़कर अपने पिता से कह दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","अपने भांजे याकूब का समाचार पाते ही लाबान उससे भेंट करने को दौड़ा, और उसको गले लगाकर चूमा, फिर अपने घर ले आया। और याकूब ने लाबान से अपना सब वृत्तान्त वर्णन किया। ");
INSERT INTO hin2017_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","तब लाबान ने याकूब से कहा, “तू तो सचमुच मेरी हड्डी और माँस है।” और याकूब एक महीना भर उसके साथ रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","तब लाबान ने याकूब से कहा, “भाई-बन्धु होने के कारण तुझ से मुफ्त सेवा कराना मेरे लिए उचित नहीं है; इसलिए कह मैं तुझे सेवा के बदले क्या दूँ?” ");
INSERT INTO hin2017_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबान की दो बेटियाँ थी, जिनमें से बड़ी का नाम लिआ और छोटी का राहेल था। ");
INSERT INTO hin2017_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लिआ के तो धुन्धली आँखें थीं, पर राहेल रूपवती और सुन्दर थी। ");
INSERT INTO hin2017_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","इसलिए याकूब ने, जो राहेल से प्रीति रखता था, कहा, “मैं तेरी छोटी बेटी राहेल के लिये सात वर्ष तेरी सेवा करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबान ने कहा, “उसे पराए पुरुष को देने से तुझको देना उत्तम होगा; इसलिए मेरे पास रह।” ");
INSERT INTO hin2017_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","अतः याकूब ने राहेल के लिये सात वर्ष सेवा की; और वे उसको राहेल की प्रीति के कारण थोड़े ही दिनों के बराबर जान पड़े। ");
INSERT INTO hin2017_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","तब याकूब ने लाबान से कहा, “मेरी पत्नी मुझे दे, और मैं उसके पास जाऊँगा, क्योंकि मेरा समय पूरा हो गया है।” ");
INSERT INTO hin2017_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","अतः लाबान ने उस स्थान के सब मनुष्यों को बुलाकर इकट्ठा किया, और एक भोज दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","साँझ के समय वह अपनी बेटी लिआ को याकूब के पास ले गया, और वह उसके पास गया। ");
INSERT INTO hin2017_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","लाबान ने अपनी बेटी लिआ को उसकी दासी होने के लिये अपनी दासी जिल्पा दी। ");
INSERT INTO hin2017_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","भोर को मालूम हुआ कि यह तो लिआ है, इसलिए उसने लाबान से कहा, “यह तूने मुझसे क्या किया है? मैंने तेरे साथ रहकर जो तेरी सेवा की, तो क्या राहेल के लिये नहीं की? फिर तूने मुझसे क्यों ऐसा छल किया है?” ");
INSERT INTO hin2017_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबान ने कहा, “हमारे यहाँ ऐसी रीति नहीं, कि बड़ी बेटी से पहले दूसरी का विवाह कर दें। ");
INSERT INTO hin2017_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","“इसका सप्ताह तो पूरा कर; फिर दूसरी भी तुझे उस सेवा के लिये मिलेगी जो तू मेरे साथ रहकर और सात वर्ष तक करेगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","याकूब ने ऐसा ही किया, और लिआ के सप्ताह को पूरा किया; तब लाबान ने उसे अपनी बेटी राहेल भी दी, कि वह उसकी पत्नी हो। ");
INSERT INTO hin2017_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","लाबान ने अपनी बेटी राहेल की दासी होने के लिये अपनी दासी बिल्हा को दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","तब याकूब राहेल के पास भी गया, और उसकी प्रीति लिआ से अधिक उसी पर हुई, और उसने लाबान के साथ रहकर सात वर्ष और उसकी सेवा की। ");
INSERT INTO hin2017_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","जब यहोवा ने देखा कि लिआ अप्रिय हुई, तब उसने उसकी कोख खोली, पर राहेल बाँझ रही। ");
INSERT INTO hin2017_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","अतः लिआ गर्भवती हुई, और उसके एक पुत्र उत्पन्न हुआ, और उसने यह कहकर उसका नाम रूबेन रखा, “यहोवा ने मेरे दुःख पर दृष्टि की है, अब मेरा पति मुझसे प्रीति रखेगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","फिर वह गर्भवती हुई और उसके एक पुत्र उत्पन्न हुआ; तब उसने यह कहा, “यह सुनकर कि मैं अप्रिय हूँ यहोवा ने मुझे यह भी पुत्र दिया।” इसलिए उसने उसका नाम शिमोन रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","फिर वह गर्भवती हुई और उसके एक पुत्र उत्पन्न हुआ; और उसने कहा, “अब की बार तो मेरा पति मुझसे मिल जाएगा, क्योंकि उससे मेरे तीन पुत्र उत्पन्न हुए।” इसलिए उसका नाम लेवी रखा गया। ");
INSERT INTO hin2017_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","और फिर वह गर्भवती हुई और उसके एक और पुत्र उत्पन्न हुआ; और उसने कहा, “अब की बार तो मैं यहोवा का धन्यवाद करूँगी।” इसलिए उसने उसका नाम यहूदा रखा; तब उसकी कोख बन्द हो गई। (मत्ती 1:2) ");
INSERT INTO hin2017_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","जब राहेल ने देखा कि याकूब के लिये मुझसे कोई सन्तान नहीं होती, तब वह अपनी बहन से डाह करने लगी और याकूब से कहा, “मुझे भी सन्तान दे, नहीं तो मर जाऊँगी।” ");
INSERT INTO hin2017_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","तब याकूब ने राहेल से क्रोधित होकर कहा, “क्या मैं परमेश्वर हूँ? तेरी कोख तो उसी ने बन्द कर रखी है।” ");
INSERT INTO hin2017_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","राहेल ने कहा, “अच्छा, मेरी दासी बिल्हा हाजिर है; उसी के पास जा, वह मेरे घुटनों पर जनेगी, और उसके द्वारा मेरा भी घर बसेगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","तब उसने उसे अपनी दासी बिल्हा को दिया, कि वह उसकी पत्नी हो; और याकूब उसके पास गया। ");
INSERT INTO hin2017_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","और बिल्हा गर्भवती हुई और याकूब से उसके एक पुत्र उत्पन्न हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","तब राहेल ने कहा, “परमेश्वर ने मेरा न्याय चुकाया और मेरी सुनकर मुझे एक पुत्र दिया।” इसलिए उसने उसका नाम दान रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","राहेल की दासी बिल्हा फिर गर्भवती हुई और याकूब से एक पुत्र और उत्पन्न हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","तब राहेल ने कहा, “मैंने अपनी बहन के साथ बड़े बल से लिपटकर मल्लयुद्ध किया और अब जीत गई।” अतः उसने उसका नाम नप्ताली रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","जब लिआ ने देखा कि मैं जनने से रहित हो गई हूँ, तब उसने अपनी दासी जिल्पा को लेकर याकूब की पत्नी होने के लिये दे दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","और लिआ की दासी जिल्पा के भी याकूब से एक पुत्र उत्पन्न हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","तब लिआ ने कहा, “अहो भाग्य!” इसलिए उसने उसका नाम गाद रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","फिर लिआ की दासी जिल्पा के याकूब से एक और पुत्र उत्पन्न हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","तब लिआ ने कहा, “मैं धन्य हूँ; निश्चय स्त्रियाँ मुझे धन्य कहेंगी।” इसलिए उसने उसका नाम आशेर रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","गेहूँ की कटनी के दिनों में रूबेन को मैदान में दूदाफल मिले, और वह उनको अपनी माता लिआ के पास ले गया, तब राहेल ने लिआ से कहा, “अपने पुत्र के दूदाफलों में से कुछ मुझे दे।” ");
INSERT INTO hin2017_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","उसने उससे कहा, “तूने जो मेरे पति को ले लिया है क्या छोटी बात है? अब क्या तू मेरे पुत्र के दूदाफल भी लेना चाहती है?” राहेल ने कहा, “अच्छा, तेरे पुत्र के दूदाफलों के बदले वह आज रात को तेरे संग सोएगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","साँझ को जब याकूब मैदान से आ रहा था, तब लिआ उससे भेंट करने को निकली, और कहा, “तुझे मेरे ही पास आना होगा, क्योंकि मैंने अपने पुत्र के दूदाफल देकर तुझे सचमुच मोल लिया।” तब वह उस रात को उसी के संग सोया। ");
INSERT INTO hin2017_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","तब परमेश्वर ने लिआ की सुनी, और वह गर्भवती हुई और याकूब से उसके पाँचवाँ पुत्र उत्पन्न हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","तब लिआ ने कहा, “मैंने जो अपने पति को अपनी दासी दी, इसलिए परमेश्वर ने मुझे मेरी मजदूरी दी है।” इसलिए उसने उसका नाम इस्साकार रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","लिआ फिर गर्भवती हुई और याकूब से उसके छठवाँ पुत्र उत्पन्न हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","तब लिआ ने कहा, “परमेश्वर ने मुझे अच्छा दान दिया है; अब की बार मेरा पति मेरे संग बना रहेगा, क्योंकि मेरे उससे छः पुत्र उत्पन्न हो चुके हैं।” इसलिए उसने उसका नाम जबूलून रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","तत्पश्चात् उसके एक बेटी भी हुई, और उसने उसका नाम दीना रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","परमेश्वर ने राहेल की भी सुधि ली, और उसकी सुनकर उसकी कोख खोली। ");
INSERT INTO hin2017_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","इसलिए वह गर्भवती हुई और उसके एक पुत्र उत्पन्न हुआ; तब उसने कहा, “परमेश्वर ने मेरी नामधराई को दूर कर दिया है।” ");
INSERT INTO hin2017_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","इसलिए उसने यह कहकर उसका नाम यूसुफ रखा, “परमेश्वर मुझे एक पुत्र और भी देगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","जब राहेल से यूसुफ उत्पन्न हुआ, तब याकूब ने लाबान से कहा, “मुझे विदा कर कि मैं अपने देश और स्थान को जाऊँ। ");
INSERT INTO hin2017_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","मेरी स्त्रियाँ और मेरे बच्चे, जिनके लिये मैंने तेरी सेवा की है, उन्हें मुझे दे कि मैं चला जाऊँ; तू तो जानता है कि मैंने तेरी कैसी सेवा की है।” ");
INSERT INTO hin2017_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","लाबान ने उससे कहा, “यदि तेरी दृष्टि में मैंने अनुग्रह पाया है, तो यहीं रह जा; क्योंकि मैंने अनुभव से जान लिया है कि यहोवा ने तेरे कारण से मुझे आशीष दी है।” ");
INSERT INTO hin2017_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","फिर उसने कहा, “तू ठीक बता कि मैं तुझको क्या दूँ, और मैं उसे दूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","उसने उससे कहा, “तू जानता है कि मैंने तेरी कैसी सेवा की, और तेरे पशु मेरे पास किस प्रकार से रहे। ");
INSERT INTO hin2017_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","मेरे आने से पहले वे कितने थे, और अब कितने हो गए हैं; और यहोवा ने मेरे आने पर तुझे आशीष दी है। पर मैं अपने घर का काम कब करने पाऊँगा?” ");
INSERT INTO hin2017_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","उसने फिर कहा, “मैं तुझे क्या दूँ?” याकूब ने कहा, “तू मुझे कुछ न दे; यदि तू मेरे लिये एक काम करे, तो मैं फिर तेरी भेड़-बकरियों को चराऊँगा, और उनकी रक्षा करूँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","मैं आज तेरी सब भेड़-बकरियों के बीच होकर निकलूँगा, और जो भेड़ या बकरी चित्तीवाली या चितकबरी हो, और जो भेड़ काली हो, और जो बकरी चितकबरी और चित्तीवाली हो, उन्हें मैं अलग कर रखूँगा; और मेरी मजदूरी में वे ही ठहरेंगी। ");
INSERT INTO hin2017_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","और जब आगे को मेरी मजदूरी की चर्चा तेरे सामने चले, तब धर्म की यही साक्षी होगी; अर्थात् बकरियों में से जो कोई न चित्तीवाली न चितकबरी हो, और भेड़ों में से जो कोई काली न हो, यदि मेरे पास निकलें, तो चोरी की ठहरेंगी।” ");
INSERT INTO hin2017_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","तब लाबान ने कहा, “तेरे कहने के अनुसार हो।” ");
INSERT INTO hin2017_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","अतः उसने उसी दिन सब धारीवाले और चितकबरे बकरों, और सब चित्तीवाली और चितकबरी बकरियों को, अर्थात् जिनमें कुछ उजलापन था, उनको और सब काली भेड़ों को भी अलग करके अपने पुत्रों के हाथ सौंप दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","और उसने अपने और याकूब के बीच में तीन दिन के मार्ग का अन्तर ठहराया; और याकूब लाबान की भेड़-बकरियों को चराने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","तब याकूब ने चिनार, और बादाम, और अर्मोन वृक्षों की हरी-हरी छड़ियाँ लेकर, उनके छिलके कहीं-कहीं छील के, उन्हें धारीदार बना दिया, ऐसी कि उन छड़ियों की सफेदी दिखाई देने लगी। ");
INSERT INTO hin2017_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","और तब छीली हुई छड़ियों को भेड़-बकरियों के सामने उनके पानी पीने के कठौतों में खड़ा किया; और जब वे पानी पीने के लिये आईं तब गाभिन हो गईं। ");
INSERT INTO hin2017_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","छड़ियों के सामने गाभिन होकर, भेड़-बकरियाँ धारीवाले, चित्तीवाले और चितकबरे बच्चे जनीं। ");
INSERT INTO hin2017_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","तब याकूब ने भेड़ों के बच्चों को अलग-अलग किया, और लाबान की भेड़-बकरियों के मुँह को चित्तीवाले और सब काले बच्चों की ओर कर दिया; और अपने झुण्डों को उनसे अलग रखा, और लाबान की भेड़-बकरियों से मिलने न दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","और जब जब बलवन्त भेड़-बकरियाँ गाभिन होती थीं, तब-तब याकूब उन छड़ियों को कठौतों में उनके सामने रख देता था; जिससे वे छड़ियों को देखती हुई गाभिन हो जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","पर जब निर्बल भेड़-बकरियाँ गाभिन होती थी, तब वह उन्हें उनके आगे नहीं रखता था। इससे निर्बल-निर्बल लाबान की रहीं, और बलवन्त-बलवन्त याकूब की हो गईं। ");
INSERT INTO hin2017_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","इस प्रकार वह पुरुष अत्यन्त धनाढ्य हो गया, और उसके बहुत सी भेड़-बकरियाँ, और दासियाँ और दास और ऊँट और गदहे हो गए। ");
INSERT INTO hin2017_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","फिर लाबान के पुत्रों की ये बातें याकूब के सुनने में आईं, “याकूब ने हमारे पिता का सब कुछ छीन लिया है, और हमारे पिता के धन के कारण उसकी यह प्रतिष्ठा है।” ");
INSERT INTO hin2017_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","और याकूब ने लाबान के चेहरे पर दृष्टि की और ताड़ लिया, कि वह उसके प्रति पहले के समान नहीं है। ");
INSERT INTO hin2017_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","तब यहोवा ने याकूब से कहा, “अपने पितरों के देश और अपनी जन्म-भूमि को लौट जा, और मैं तेरे संग रहूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","तब याकूब ने राहेल और लिआ को, मैदान में अपनी भेड़-बकरियों के पास बुलवाकर कहा, ");
INSERT INTO hin2017_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","“तुम्हारे पिता के चेहरे से मुझे समझ पड़ता है, कि वह तो मुझे पहले के समान अब नहीं देखता; पर मेरे पिता का परमेश्वर मेरे संग है। ");
INSERT INTO hin2017_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","और तुम भी जानती हो, कि मैंने तुम्हारे पिता की सेवा शक्ति भर की है। ");
INSERT INTO hin2017_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","फिर भी तुम्हारे पिता ने मुझसे छल करके मेरी मजदूरी को दस बार बदल दिया; परन्तु परमेश्वर ने उसको मेरी हानि करने नहीं दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","जब उसने कहा, ‘चित्तीवाले बच्चे तेरी मजदूरी ठहरेंगे,’ तब सब भेड़-बकरियाँ चित्तीवाले ही जनने लगीं, और जब उसने कहा, ‘धारीवाले बच्चे तेरी मजदूरी ठहरेंगे,’ तब सब भेड़-बकरियाँ धारीवाले जनने लगीं। ");
INSERT INTO hin2017_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","इस रीति से परमेश्वर ने तुम्हारे पिता के पशु लेकर मुझ को दे दिए। ");
INSERT INTO hin2017_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","भेड़-बकरियों के गाभिन होने के समय मैंने स्वप्न में क्या देखा, कि जो बकरे बकरियों पर चढ़ रहे हैं, वे धारीवाले, चित्तीवाले, और धब्बेवाले हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","तब परमेश्वर के दूत ने स्वप्न में मुझसे कहा, ‘हे याकूब,’ मैंने कहा, ‘क्या आज्ञा।’ ");
INSERT INTO hin2017_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","उसने कहा, ‘आँखें उठाकर उन सब बकरों को जो बकरियों पर चढ़ रहे हैं, देख, कि वे धारीवाले, चित्तीवाले, और धब्बेवाले हैं; क्योंकि जो कुछ लाबान तुझ से करता है, वह मैंने देखा है। ");
INSERT INTO hin2017_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","मैं उस बेतेल का परमेश्वर हूँ, जहाँ तूने एक खम्भे पर तेल डाल दिया था और मेरी मन्नत मानी थी। अब चल, इस देश से निकलकर अपनी जन्म-भूमि को लौट जा।’” ");
INSERT INTO hin2017_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","तब राहेल और लिआ ने उससे कहा, “क्या हमारे पिता के घर में अब भी हमारा कुछ भाग या अंश बचा है? ");
INSERT INTO hin2017_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","क्या हम उसकी दृष्टि में पराए न ठहरीं? देख, उसने हमको तो बेच डाला, और हमारे रूपे को खा बैठा है। ");
INSERT INTO hin2017_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","इसलिए परमेश्वर ने हमारे पिता का जितना धन ले लिया है, वह हमारा, और हमारे बच्चों का है; अब जो कुछ परमेश्वर ने तुझ से कहा है, वही कर।” ");
INSERT INTO hin2017_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","तब याकूब ने अपने बच्चों और स्त्रियों को ऊँटों पर चढ़ाया; ");
INSERT INTO hin2017_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","और जितने पशुओं को वह पद्दनराम में इकट्ठा करके धनाढ्य हो गया था, सब को कनान में अपने पिता इसहाक के पास जाने की मनसा से, साथ ले गया। ");
INSERT INTO hin2017_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","लाबान तो अपनी भेड़ों का ऊन कतरने के लिये चला गया था, और राहेल अपने पिता के गृहदेवताओं को चुरा ले गई। ");
INSERT INTO hin2017_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","अतः याकूब लाबान अरामी के पास से चोरी से चला गया, उसको न बताया कि मैं भागा जाता हूँ। ");
INSERT INTO hin2017_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","वह अपना सब कुछ लेकर भागा, और महानद के पार उतरकर अपना मुँह गिलाद के पहाड़ी देश की ओर किया। ");
INSERT INTO hin2017_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","तीसरे दिन लाबान को समाचार मिला कि याकूब भाग गया है। ");
INSERT INTO hin2017_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","इसलिए उसने अपने भाइयों को साथ लेकर उसका सात दिन तक पीछा किया, और गिलाद के पहाड़ी देश में उसको जा पकड़ा। ");
INSERT INTO hin2017_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","तब परमेश्वर ने रात के स्वप्न में अरामी लाबान के पास आकर कहा, “सावधान रह, तू याकूब से न तो भला कहना और न बुरा।” ");
INSERT INTO hin2017_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","और लाबान याकूब के पास पहुँच गया। याकूब अपना तम्बू गिलाद नामक पहाड़ी देश में खड़ा किए पड़ा था; और लाबान ने भी अपने भाइयों के साथ अपना तम्बू उसी पहाड़ी देश में खड़ा किया। ");
INSERT INTO hin2017_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","तब लाबान याकूब से कहने लगा, “तूने यह क्या किया, कि मेरे पास से चोरी से चला आया, और मेरी बेटियों को ऐसा ले आया, जैसा कोई तलवार के बल से बन्दी बनाई गई हों? ");
INSERT INTO hin2017_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","तू क्यों चुपके से भाग आया, और मुझसे बिना कुछ कहे मेरे पास से चोरी से चला आया; नहीं तो मैं तुझे आनन्द के साथ मृदंग और वीणा बजवाते, और गीत गवाते विदा करता? ");
INSERT INTO hin2017_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","तूने तो मुझे अपने बेटे-बेटियों को चूमने तक न दिया? तूने मूर्खता की है। ");
INSERT INTO hin2017_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","तुम लोगों की हानि करने की शक्ति मेरे हाथ में तो है; पर तुम्हारे पिता के परमेश्वर ने मुझसे बीती हुई रात में कहा, ‘सावधान रह, याकूब से न तो भला कहना और न बुरा।’ ");
INSERT INTO hin2017_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","भला, अब तू अपने पिता के घर का बड़ा अभिलाषी होकर चला आया तो चला आया, पर मेरे देवताओं को तू क्यों चुरा ले आया है?” ");
INSERT INTO hin2017_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","याकूब ने लाबान को उत्तर दिया, “मैं यह सोचकर डर गया था कि कहीं तू अपनी बेटियों को मुझसे छीन न ले। ");
INSERT INTO hin2017_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","जिस किसी के पास तू अपने देवताओं को पाए, वह जीवित न बचेगा। मेरे पास तेरा जो कुछ निकले, उसे भाई-बन्धुओं के सामने पहचानकर ले ले।” क्योंकि याकूब न जानता था कि राहेल गृहदेवताओं को चुरा ले आई है। ");
INSERT INTO hin2017_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","यह सुनकर लाबान, याकूब और लिआ और दोनों दासियों के तम्बुओं में गया; और कुछ न मिला। तब लिआ के तम्बू में से निकलकर राहेल के तम्बू में गया। ");
INSERT INTO hin2017_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राहेल तो गृहदेवताओं को ऊँट की काठी में रखकर उन पर बैठी थी। लाबान ने उसके सारे तम्बू में टटोलने पर भी उन्हें न पाया। ");
INSERT INTO hin2017_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","राहेल ने अपने पिता से कहा, “हे मेरे प्रभु; इससे अप्रसन्न न हो, कि मैं तेरे सामने नहीं उठी; क्योंकि मैं मासिक धर्म से हूँ।” अतः उसके ढूँढ़-ढाँढ़ करने पर भी गृहदेवता उसको न मिले। ");
INSERT INTO hin2017_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","तब याकूब क्रोधित होकर लाबान से झगड़ने लगा, और कहा, “मेरा क्या अपराध है? मेरा क्या पाप है, कि तूने इतना क्रोधित होकर मेरा पीछा किया है? ");
INSERT INTO hin2017_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","तूने जो मेरी सारी सामग्री को टटोलकर देखा, तो तुझको अपने घर की सारी सामग्री में से क्या मिला? कुछ मिला हो तो उसको यहाँ अपने और मेरे भाइयों के सामने रख दे, और वे हम दोनों के बीच न्याय करें। ");
INSERT INTO hin2017_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","इन बीस वर्षों से मैं तेरे पास रहा; इनमें न तो तेरी भेड़-बकरियों के गर्भ गिरे, और न तेरे मेढ़ों का माँस मैंने कभी खाया। ");
INSERT INTO hin2017_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","जिसे जंगली जन्तुओं ने फाड़ डाला उसको मैं तेरे पास न लाता था, उसकी हानि मैं ही उठाता था; चाहे दिन को चोरी जाता चाहे रात को, तू मुझ ही से उसको ले लेता था। ");
INSERT INTO hin2017_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","मेरी तो यह दशा थी कि दिन को तो घाम और रात को पाला मुझे खा गया; और नींद मेरी आँखों से भाग जाती थी। ");
INSERT INTO hin2017_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","बीस वर्ष तक मैं तेरे घर में रहा; चौदह वर्ष तो मैंने तेरी दोनों बेटियों के लिये, और छः वर्ष तेरी भेड़-बकरियों के लिये सेवा की; और तूने मेरी मजदूरी को दस बार बदल डाला। ");
INSERT INTO hin2017_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","मेरे पिता का परमेश्वर अर्थात् अब्राहम का परमेश्वर, जिसका भय इसहाक भी मानता है, यदि मेरी ओर न होता, तो निश्चय तू अब मुझे खाली हाथ जाने देता। मेरे दुःख और मेरे हाथों के परिश्रम को देखकर परमेश्वर ने बीती हुई रात में तुझे डाँटा।” ");
INSERT INTO hin2017_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","लाबान ने याकूब से कहा, “ये बेटियाँ तो मेरी ही हैं, और ये पुत्र भी मेरे ही हैं, और ये भेड़-बकरियाँ भी मेरे ही हैं, और जो कुछ तुझे देख पड़ता है वह सब मेरा ही है परन्तु अब मैं अपनी इन बेटियों और इनकी सन्तान से क्या कर सकता हूँ? ");
INSERT INTO hin2017_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","अब आ, मैं और तू दोनों आपस में वाचा बाँधें, और वह मेरे और तेरे बीच साक्षी ठहरी रहे।” ");
INSERT INTO hin2017_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","तब याकूब ने एक पत्थर लेकर उसका खम्भा खड़ा किया। ");
INSERT INTO hin2017_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","तब याकूब ने अपने भाई-बन्धुओं से कहा, “पत्थर इकट्ठा करो,” यह सुनकर उन्होंने पत्थर इकट्ठा करके एक ढेर लगाया और वहीं ढेर के पास उन्होंने भोजन किया। ");
INSERT INTO hin2017_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","उस ढेर का नाम लाबान ने तो जैगर सहादुथा, पर याकूब ने गिलियाद रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबान ने कहा, “यह ढेर आज से मेरे और तेरे बीच साक्षी रहेगा।” इस कारण उसका नाम गिलियाद रखा गया, ");
INSERT INTO hin2017_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","और मिस्पा भी; क्योंकि उसने कहा, “जब हम एक दूसरे से दूर रहें तब यहोवा मेरी और तेरी देख-भाल करता रहे। ");
INSERT INTO hin2017_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","यदि तू मेरी बेटियों को दुःख दे, या उनके सिवाय और स्त्रियाँ ब्याह ले, तो हमारे साथ कोई मनुष्य तो न रहेगा; पर देख मेरे तेरे बीच में परमेश्वर साक्षी रहेगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","फिर लाबान ने याकूब से कहा, “इस ढेर को देख और इस खम्भे को भी देख, जिनको मैंने अपने और तेरे बीच में खड़ा किया है। ");
INSERT INTO hin2017_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","यह ढेर और यह खम्भा दोनों इस बात के साक्षी रहें कि हानि करने की मनसा से न तो मैं इस ढेर को लाँघकर तेरे पास जाऊँगा, न तू इस ढेर और इस खम्भे को लाँघकर मेरे पास आएगा। ");
INSERT INTO hin2017_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","अब्राहम और नाहोर और उनके पिता; तीनों का जो परमेश्वर है, वही हम दोनों के बीच न्याय करे।” तब याकूब ने उसकी शपथ खाई जिसका भय उसका पिता इसहाक मानता था। ");
INSERT INTO hin2017_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","और याकूब ने उस पहाड़ पर बलि चढ़ाया, और अपने भाई-बन्धुओं को भोजन करने के लिये बुलाया, तब उन्होंने भोजन करके पहाड़ पर रात बिताई। ");
INSERT INTO hin2017_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","भोर को लाबान उठा, और अपने बेटे-बेटियों को चूमकर और आशीर्वाद देकर चल दिया, और अपने स्थान को लौट गया। ");
INSERT INTO hin2017_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याकूब ने भी अपना मार्ग लिया और परमेश्वर के दूत उसे आ मिले। ");
INSERT INTO hin2017_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","उनको देखते ही याकूब ने कहा, “यह तो परमेश्वर का दल है।” इसलिए उसने उस स्थान का नाम महनैम रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","तब याकूब ने सेईर देश में, अर्थात् एदोम देश में, अपने भाई एसाव के पास अपने आगे दूत भेज दिए। ");
INSERT INTO hin2017_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","और उसने उन्हें यह आज्ञा दी, “मेरे प्रभु एसाव से यह कहना; कि तेरा दास याकूब तुझ से यह कहता है, कि मैं लाबान के यहाँ परदेशी होकर अब तक रहा; ");
INSERT INTO hin2017_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","और मेरे पास गाय-बैल, गदहे, भेड़-बकरियाँ, और दास-दासियाँ हैं और मैंने अपने प्रभु के पास इसलिए सन्देश भेजा है कि तेरे अनुग्रह की दृष्टि मुझ पर हो।” ");
INSERT INTO hin2017_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","वे दूत याकूब के पास लौटकर कहने लगे, “हम तेरे भाई एसाव के पास गए थे, और वह भी तुझ से भेंट करने को चार सौ पुरुष संग लिये हुए चला आता है।” ");
INSERT INTO hin2017_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","तब याकूब बहुत डर गया, और संकट में पड़ा: और यह सोचकर, अपने साथियों के, और भेड़-बकरियों, और गाय-बैलों, और ऊँटों के भी अलग-अलग दो दल कर लिये, ");
INSERT INTO hin2017_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","कि यदि एसाव आकर पहले दल को मारने लगे, तो दूसरा दल भागकर बच जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","फिर याकूब ने कहा, “हे यहोवा, हे मेरे दादा अब्राहम के परमेश्वर, हे मेरे पिता इसहाक के परमेश्वर, तूने तो मुझसे कहा था कि अपने देश और जन्म-भूमि में लौट जा, और मैं तेरी भलाई करूँगा: ");
INSERT INTO hin2017_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","तूने जो-जो काम अपनी करुणा और सच्चाई से अपने दास के साथ किए हैं, कि मैं जो अपनी छड़ी ही लेकर इस यरदन नदी के पार उतर आया, और अब मेरे दो दल हो गए हैं, तेरे ऐसे-ऐसे कामों में से मैं एक के भी योग्य तो नहीं हूँ। ");
INSERT INTO hin2017_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","मेरी विनती सुनकर मुझे मेरे भाई एसाव के हाथ से बचा मैं तो उससे डरता हूँ, कहीं ऐसा न हो कि वह आकर मुझे और माँ समेत लड़कों को भी मार डाले। ");
INSERT INTO hin2017_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","तूने तो कहा है, कि मैं निश्चय तेरी भलाई करूँगा, और तेरे वंश को समुद्र के रेतकणों के समान बहुत करूँगा, जो बहुतायत के मारे गिने नहीं जा सकते।” ");
INSERT INTO hin2017_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","उसने उस दिन की रात वहीं बिताई; और जो कुछ उसके पास था उसमें से अपने भाई एसाव की भेंट के लिये छाँट छाँटकर निकाला; ");
INSERT INTO hin2017_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","अर्थात् दो सौ बकरियाँ, और बीस बकरे, और दो सौ भेड़ें, और बीस मेढ़े, ");
INSERT INTO hin2017_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","और बच्चों समेत दूध देनेवाली तीस ऊँटनियाँ, और चालीस गायें, और दस बैल, और बीस गदहियाँ और उनके दस बच्चे। ");
INSERT INTO hin2017_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","इनको उसने झुण्ड-झुण्ड करके, अपने दासों को सौंपकर उनसे कहा, “मेरे आगे बढ़ जाओ; और झुण्डों के बीच-बीच में अन्तर रखो।” ");
INSERT INTO hin2017_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","फिर उसने अगले झुण्ड के रखवाले को यह आज्ञा दी, “जब मेरा भाई एसाव तुझे मिले, और पूछने लगे, ‘तू किसका दास है, और कहाँ जाता है, और ये जो तेरे आगे-आगे हैं, वे किसके हैं?’ ");
INSERT INTO hin2017_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","तब कहना, ‘यह तेरे दास याकूब के हैं। हे मेरे प्रभु एसाव, ये भेंट के लिये तेरे पास भेजे गए हैं, और वह आप भी हमारे पीछे-पीछे आ रहा है।’” ");
INSERT INTO hin2017_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","और उसने दूसरे और तीसरे रखवालों को भी, वरन् उन सभी को जो झुण्डों के पीछे-पीछे थे ऐसी ही आज्ञा दी कि जब एसाव तुम को मिले तब इसी प्रकार उससे कहना। ");
INSERT INTO hin2017_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","और यह भी कहना, “तेरा दास याकूब हमारे पीछे-पीछे आ रहा है।” क्योंकि उसने यह सोचा कि यह भेंट जो मेरे आगे-आगे जाती है, इसके द्वारा मैं उसके क्रोध को शान्त करके तब उसका दर्शन करूँगा; हो सकता है वह मुझसे प्रसन्न हो जाए। ");
INSERT INTO hin2017_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","इसलिए वह भेंट याकूब से पहले पार उतर गई, और वह आप उस रात को छावनी में रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","उसी रात को वह उठा और अपनी दोनों स्त्रियों, और दोनों दासियों, और ग्यारहों लड़कों को संग लेकर घाट से यब्बोक नदी के पार उतर गया। ");
INSERT INTO hin2017_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","उसने उन्हें उस नदी के पार उतार दिया, वरन् अपना सब कुछ पार उतार दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","और याकूब आप अकेला रह गया; तब कोई पुरुष आकर पौ फटने तक उससे मल्लयुद्ध करता रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","जब उसने देखा कि मैं याकूब पर प्रबल नहीं होता, तब उसकी जाँघ की नस को छुआ; और याकूब की जाँघ की नस उससे मल्लयुद्ध करते ही करते चढ़ गई। ");
INSERT INTO hin2017_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","तब उसने कहा, “मुझे जाने दे, क्योंकि भोर होनेवाला है।” याकूब ने कहा, “जब तक तू मुझे आशीर्वाद न दे, तब तक मैं तुझे जाने न दूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","और उसने याकूब से पूछा, “तेरा नाम क्या है?” उसने कहा, “याकूब।” ");
INSERT INTO hin2017_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","उसने कहा, “तेरा नाम अब याकूब नहीं, परन्तु इस्राएल होगा, क्योंकि तू परमेश्वर से और मनुष्यों से भी युद्ध करके प्रबल हुआ है।” ");
INSERT INTO hin2017_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","याकूब ने कहा, “मैं विनती करता हूँ, मुझे अपना नाम बता।” उसने कहा, “तू मेरा नाम क्यों पूछता है?” तब उसने उसको वहीं आशीर्वाद दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","तब याकूब ने यह कहकर उस स्थान का नाम पनीएल रखा; “परमेश्वर को आमने-सामने देखने पर भी मेरा प्राण बच गया है।” ");
INSERT INTO hin2017_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","पनीएल के पास से चलते-चलते सूर्य उदय हो गया, और वह जाँघ से लँगड़ाता था। ");
INSERT INTO hin2017_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","इस्राएली जो पशुओं की जाँघ की जोड़वाले जंघानस को आज के दिन तक नहीं खाते, इसका कारण यही है कि उस पुरुष ने याकूब की जाँघ के जोड़ में जंघानस को छुआ था। ");
INSERT INTO hin2017_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","और याकूब ने आँखें उठाकर यह देखा, कि एसाव चार सौ पुरुष संग लिये हुए चला आता है। तब उसने बच्चों को अलग-अलग बाँटकर लिआ और राहेल और दोनों दासियों को सौंप दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","और उसने सब के आगे लड़कों समेत दासियों को उसके पीछे लड़कों समेत लिआ को, और सब के पीछे राहेल और यूसुफ को रखा, ");
INSERT INTO hin2017_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","और आप उन सब के आगे बढ़ा और सात बार भूमि पर गिरकर दण्डवत् की, और अपने भाई के पास पहुँचा। ");
INSERT INTO hin2017_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","तब एसाव उससे भेंट करने को दौड़ा, और उसको हृदय से लगाकर, गले से लिपटकर चूमा; फिर वे दोनों रो पड़े। ");
INSERT INTO hin2017_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","तब उसने आँखें उठाकर स्त्रियों और बच्चों को देखा; और पूछा, “ये जो तेरे साथ हैं वे कौन हैं?” उसने कहा, “ये तेरे दास के लड़के हैं, जिन्हें परमेश्वर ने अनुग्रह करके मुझ को दिया है।” ");
INSERT INTO hin2017_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","तब लड़कों समेत दासियों ने निकट आकर दण्डवत् किया। ");
INSERT INTO hin2017_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","फिर लड़कों समेत लिआ निकट आई, और उन्होंने भी दण्डवत् किया; अन्त में यूसुफ और राहेल ने भी निकट आकर दण्डवत् किया। ");
INSERT INTO hin2017_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","तब उसने पूछा, “तेरा यह बड़ा दल जो मुझ को मिला, उसका क्या प्रयोजन है?” उसने कहा, “यह कि मेरे प्रभु की अनुग्रह की दृष्टि मुझ पर हो।” ");
INSERT INTO hin2017_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","एसाव ने कहा, “हे मेरे भाई, मेरे पास तो बहुत है; जो कुछ तेरा है वह तेरा ही रहे।” ");
INSERT INTO hin2017_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकूब ने कहा, “नहीं नहीं, यदि तेरा अनुग्रह मुझ पर हो, तो मेरी भेंट ग्रहण कर: क्योंकि मैंने तेरा दर्शन पाकर, मानो परमेश्वर का दर्शन पाया है, और तू मुझसे प्रसन्न हुआ है। ");
INSERT INTO hin2017_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","इसलिए यह भेंट, जो तुझे भेजी गई है, ग्रहण कर; क्योंकि परमेश्वर ने मुझ पर अनुग्रह किया है, और मेरे पास बहुत है।” जब उसने उससे बहुत आग्रह किया, तब उसने भेंट को ग्रहण किया। ");
INSERT INTO hin2017_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","फिर एसाव ने कहा, “आ, हम बढ़ चलें: और मैं तेरे आगे-आगे चलूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","याकूब ने कहा, “हे मेरे प्रभु, तू जानता ही है कि मेरे साथ सुकुमार लड़के, और दूध देनेहारी भेड़-बकरियाँ और गायें है; यदि ऐसे पशु एक दिन भी अधिक हाँके जाएँ, तो सब के सब मर जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","इसलिए मेरा प्रभु अपने दास के आगे बढ़ जाए, और मैं इन पशुओं की गति के अनुसार, जो मेरे आगे हैं, और बच्चों की गति के अनुसार धीरे धीरे चलकर सेईर में अपने प्रभु के पास पहुँचूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","एसाव ने कहा, “तो अपने साथियों में से मैं कई एक तेरे साथ छोड़ जाऊँ।” उसने कहा, “यह क्यों? इतना ही बहुत है, कि मेरे प्रभु के अनुग्रह की दृष्टि मुझ पर बनी रहे।” ");
INSERT INTO hin2017_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","तब एसाव ने उसी दिन सेईर जाने को अपना मार्ग लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","परन्तु याकूब वहाँ से निकलकर सुक्कोत को गया, और वहाँ अपने लिये एक घर, और पशुओं के लिये झोंपड़े बनाए। इसी कारण उस स्थान का नाम सुक्कोत पड़ा। ");
INSERT INTO hin2017_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","और याकूब जो पद्दनराम से आया था, उसने कनान देश के शेकेम नगर के पास कुशल क्षेम से पहुँचकर नगर के सामने डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","और भूमि के जिस खण्ड पर उसने अपना तम्बू खड़ा किया, उसको उसने शेकेम के पिता हमोर के पुत्रों के हाथ से एक सौ कसीतों में मोल लिया। (यूह. 4:5, प्रेरि. 7:16) ");
INSERT INTO hin2017_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","और वहाँ उसने एक वेदी बनाकर उसका नाम एल-एलोहे-इस्राएल रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","एक दिन लिआ की बेटी दीना, जो याकूब से उत्पन्न हुई थी, उस देश की लड़कियों से भेंट करने को निकली। ");
INSERT INTO hin2017_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","तब उस देश के प्रधान हिब्बी हमोर के पुत्र शेकेम ने उसे देखा, और उसे ले जाकर उसके साथ कुकर्म करके उसको भ्रष्ट कर डाला। ");
INSERT INTO hin2017_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","तब उसका मन याकूब की बेटी दीना से लग गया, और उसने उस कन्या से प्रेम की बातें की, और उससे प्रेम करने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","अतः शेकेम ने अपने पिता हमोर से कहा, “मुझे इस लड़की को मेरी पत्नी होने के लिये दिला दे।” ");
INSERT INTO hin2017_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","और याकूब ने सुना कि शेकेम ने मेरी बेटी दीना को अशुद्ध कर डाला है, पर उसके पुत्र उस समय पशुओं के संग मैदान में थे, इसलिए वह उनके आने तक चुप रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","तब शेकेम का पिता हमोर निकलकर याकूब से बातचीत करने के लिये उसके पास गया। ");
INSERT INTO hin2017_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","याकूब के पुत्र यह सुनते ही मैदान से बहुत उदास और क्रोधित होकर आए; क्योंकि शेकेम ने याकूब की बेटी के साथ कुकर्म करके इस्राएल के घराने से मूर्खता का ऐसा काम किया था, जिसका करना अनुचित था। ");
INSERT INTO hin2017_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","हमोर ने उन सबसे कहा, “मेरे पुत्र शेकेम का मन तुम्हारी बेटी पर बहुत लगा है, इसलिए उसे उसकी पत्नी होने के लिये उसको दे दो। ");
INSERT INTO hin2017_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","और हमारे साथ ब्याह किया करो; अपनी बेटियाँ हमको दिया करो, और हमारी बेटियों को आप लिया करो। ");
INSERT INTO hin2017_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","और हमारे संग बसे रहो; और यह देश तुम्हारे सामने पड़ा है; इसमें रहकर लेन-देन करो, और इसकी भूमि को अपने लिये ले लो।” ");
INSERT INTO hin2017_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","और शेकेम ने भी दीना के पिता और भाइयों से कहा, “यदि मुझ पर तुम लोगों की अनुग्रह की दृष्टि हो, तो जो कुछ तुम मुझसे कहो, वह मैं दूँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","तुम मुझसे कितना ही मूल्य या बदला क्यों न माँगो, तो भी मैं तुम्हारे कहे के अनुसार दूँगा; परन्तु उस कन्या को पत्नी होने के लिये मुझे दो।” ");
INSERT INTO hin2017_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","तब यह सोचकर कि शेकेम ने हमारी बहन दीना को अशुद्ध किया है, याकूब के पुत्रों ने शेकेम और उसके पिता हमोर को छल के साथ यह उत्तर दिया, ");
INSERT INTO hin2017_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“हम ऐसा काम नहीं कर सकते कि किसी खतनारहित पुरुष को अपनी बहन दें; क्योंकि इससे हमारी नामधराई होगी। ");
INSERT INTO hin2017_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","इस बात पर तो हम तुम्हारी मान लेंगे कि हमारे समान तुम में से हर एक पुरुष का खतना किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","तब हम अपनी बेटियाँ तुम्हें ब्याह देंगे, और तुम्हारी बेटियाँ ब्याह लेंगे, और तुम्हारे संग बसे भी रहेंगे, और हम दोनों एक ही समुदाय के मनुष्य हो जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","पर यदि तुम हमारी बात न मानकर अपना खतना न कराओगे, तो हम अपनी लड़की को लेकर यहाँ से चले जाएँगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","उसकी इस बात पर हमोर और उसका पुत्र शेकेम प्रसन्न हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","और वह जवान जो याकूब की बेटी को बहुत चाहता था, इस काम को करने में उसने विलम्ब न किया। वह तो अपने पिता के सारे घराने में अधिक प्रतिष्ठित था। ");
INSERT INTO hin2017_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","इसलिए हमोर और उसका पुत्र शेकेम अपने नगर के फाटक के निकट जाकर नगरवासियों को यह समझाने लगे; ");
INSERT INTO hin2017_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“वे मनुष्य तो हमारे संग मेल से रहना चाहते हैं; अतः उन्हें इस देश में रहकर लेन-देन करने दो; देखो, यह देश उनके लिये भी बहुत है; फिर हम लोग उनकी बेटियों को ब्याह लें, और अपनी बेटियों को उन्हें दिया करें। ");
INSERT INTO hin2017_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","वे लोग केवल इस बात पर हमारे संग रहने और एक ही समुदाय के मनुष्य हो जाने को प्रसन्न हैं कि उनके समान हमारे सब पुरुषों का भी खतना किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","क्या उनकी भेड़-बकरियाँ, और गाय-बैल वरन् उनके सारे पशु और धन-सम्पत्ति हमारी न हो जाएगी? इतना ही करें कि हम लोग उनकी बात मान लें, तो वे हमारे संग रहेंगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","इसलिए जितने उस नगर के फाटक से निकलते थे, उन सभी ने हमोर की और उसके पुत्र शेकेम की बात मानी; और हर एक पुरुष का खतना किया गया, जितने उस नगर के फाटक से निकलते थे। ");
INSERT INTO hin2017_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","तीसरे दिन, जब वे लोग पीड़ित पड़े थे, तब ऐसा हुआ कि शिमोन और लेवी नामक याकूब के दो पुत्रों ने, जो दीना के भाई थे, अपनी-अपनी तलवार ले उस नगर में निधड़क घुसकर सब पुरुषों को घात किया। ");
INSERT INTO hin2017_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","हमोर और उसके पुत्र शेकेम को उन्होंने तलवार से मार डाला, और दीना को शेकेम के घर से निकाल ले गए। ");
INSERT INTO hin2017_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","याकूब के पुत्रों ने घात कर डालने पर भी चढ़कर नगर को इसलिए लूट लिया कि उसमें उनकी बहन अशुद्ध की गई थी। ");
INSERT INTO hin2017_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","उन्होंने भेड़-बकरी, और गाय-बैल, और गदहे, और नगर और मैदान में जितना धन था ले लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","उस सब को, और उनके बाल-बच्चों, और स्त्रियों को भी हर ले गए, वरन् घर-घर में जो कुछ था, उसको भी उन्होंने लूट लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","तब याकूब ने शिमोन और लेवी से कहा, “तुम ने जो इस देश के निवासी कनानियों और परिज्जियों के मन में मेरे प्रति घृणा उत्पन्न कराई है, इससे तुम ने मुझे संकट में डाला है, क्योंकि मेरे साथ तो थोड़े ही लोग हैं, इसलिए अब वे इकट्ठे होकर मुझ पर चढ़ेंगे, और मुझे मार डालेंगे, तो मैं अपने घराने समेत सत्यानाश हो जाऊँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","उन्होंने कहा, “क्या वह हमारी बहन के साथ वेश्या के समान बर्ताव करे?” ");
INSERT INTO hin2017_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","तब परमेश्वर ने याकूब से कहा, “यहाँ से निकलकर बेतेल को जा, और वहीं रह; और वहाँ परमेश्वर के लिये वेदी बना, जिसने तुझे उस समय दर्शन दिया, जब तू अपने भाई एसाव के डर से भागा जाता था।” ");
INSERT INTO hin2017_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","तब याकूब ने अपने घराने से, और उन सबसे भी जो उसके संग थे, कहा, “तुम्हारे बीच में जो पराए देवता हैं, उन्हें निकाल फेंको; और अपने-अपने को शुद्ध करो, और अपने वस्त्र बदल डालो; ");
INSERT INTO hin2017_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","और आओ, हम यहाँ से निकलकर बेतेल को जाएँ; वहाँ मैं परमेश्वर के लिये एक वेदी बनाऊँगा, जिसने संकट के दिन मेरी सुन ली, और जिस मार्ग से मैं चलता था, उसमें मेरे संग रहा।” ");
INSERT INTO hin2017_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","इसलिए जितने पराए देवता उनके पास थे, और जितने कुण्डल उनके कानों में थे, उन सभी को उन्होंने याकूब को दिया; और उसने उनको उस बांज वृक्ष के नीचे, जो शेकेम के पास है, गाड़ दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","तब उन्होंने कूच किया; और उनके चारों ओर के नगर निवासियों के मन में परमेश्वर की ओर से ऐसा भय समा गया, कि उन्होंने याकूब के पुत्रों का पीछा न किया। ");
INSERT INTO hin2017_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","याकूब उन सब समेत, जो उसके संग थे, कनान देश के लूज नगर को आया। वह नगर बेतेल भी कहलाता है। ");
INSERT INTO hin2017_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","वहाँ उसने एक वेदी बनाई, और उस स्थान का नाम एलबेतेल रखा; क्योंकि जब वह अपने भाई के डर से भागा जाता था तब परमेश्वर उस पर वहीं प्रगट हुआ था। ");
INSERT INTO hin2017_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","और रिबका की दूध पिलानेहारी दाई दबोरा मर गई, और बेतेल के बांज वृक्ष के तले उसको मिट्टी दी गई, और उस बांज वृक्ष का नाम अल्लोनबक्कूत रखा गया। ");
INSERT INTO hin2017_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","फिर याकूब के पद्दनराम से आने के पश्चात् परमेश्वर ने दूसरी बार उसको दर्शन देकर आशीष दी। ");
INSERT INTO hin2017_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","और परमेश्वर ने उससे कहा, “अब तक तो तेरा नाम याकूब रहा है; पर आगे को तेरा नाम याकूब न रहेगा, तू इस्राएल कहलाएगा।” इस प्रकार उसने उसका नाम इस्राएल रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","फिर परमेश्वर ने उससे कहा, “मैं सर्वशक्तिमान परमेश्वर हूँ। तू फूले-फले और बढ़े; और तुझ से एक जाति वरन् जातियों की एक मण्डली भी उत्पन्न होगी, और तेरे वंश में राजा उत्पन्न होंगे। ");
INSERT INTO hin2017_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","और जो देश मैंने अब्राहम और इसहाक को दिया है, वही देश तुझे देता हूँ, और तेरे पीछे तेरे वंश को भी दूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","तब परमेश्वर उस स्थान में, जहाँ उसने याकूब से बातें कीं, उसके पास से ऊपर चढ़ गया। ");
INSERT INTO hin2017_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","और जिस स्थान में परमेश्वर ने याकूब से बातें कीं, वहाँ याकूब ने पत्थर का एक खम्भा खड़ा किया, और उस पर अर्घ देकर तेल डाल दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","जहाँ परमेश्वर ने याकूब से बातें कीं, उस स्थान का नाम उसने बेतेल रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","फिर उन्होंने बेतेल से कूच किया; और एप्राता थोड़ी ही दूर रह गया था कि राहेल को बच्चा जनने की बड़ी पीड़ा उठने लगी। ");
INSERT INTO hin2017_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","जब उसको बड़ी-बड़ी पीड़ा उठती थी तब दाई ने उससे कहा, “मत डर; अब की भी तेरे बेटा ही होगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","तब ऐसा हुआ कि वह मर गई, और प्राण निकलते-निकलते उसने उस बेटे का नाम बेनोनी रखा; पर उसके पिता ने उसका नाम बिन्यामीन रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","और राहेल मर गई, और एप्राता, अर्थात् बैतलहम के मार्ग में, उसको मिट्टी दी गई। ");
INSERT INTO hin2017_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","और याकूब ने उसकी कब्र पर एक खम्भा खड़ा किया: राहेल की कब्र का वह खम्भा आज तक बना है। ");
INSERT INTO hin2017_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","फिर इस्राएल ने कूच किया, और एदेर नामक गुम्मट के आगे बढ़कर अपना तम्बू खड़ा किया। ");
INSERT INTO hin2017_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","जब इस्राएल उस देश में बसा था, तब एक दिन ऐसा हुआ कि रूबेन ने जाकर अपने पिता की रखैली बिल्हा के साथ कुकर्म किया; और यह बात इस्राएल को मालूम हो गई। याकूब के बारह पुत्र हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","उनमें से लिआ के पुत्र ये थे; अर्थात् याकूब का जेठा, रूबेन, फिर शिमोन, लेवी, यहूदा, इस्साकार, और जबूलून। ");
INSERT INTO hin2017_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","और राहेल के पुत्र ये थे; अर्थात् यूसुफ, और बिन्यामीन। ");
INSERT INTO hin2017_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","और राहेल की दासी बिल्हा के पुत्र ये थे; अर्थात् दान, और नप्ताली। ");
INSERT INTO hin2017_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","और लिआ की दासी जिल्पा के पुत्र ये थे: अर्थात् गाद, और आशेर। याकूब के ये ही पुत्र हुए, जो उससे पद्दनराम में उत्पन्न हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","और याकूब मम्रे में, जो किर्यतअर्बा, अर्थात् हेब्रोन है, जहाँ अब्राहम और इसहाक परदेशी होकर रहे थे, अपने पिता इसहाक के पास आया। (इब्रा. 11:9) ");
INSERT INTO hin2017_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाक की आयु एक सौ अस्सी वर्ष की हुई। ");
INSERT INTO hin2017_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","और इसहाक का प्राण छूट गया, और वह मर गया, और वह बूढ़ा और पूरी आयु का होकर अपने लोगों में जा मिला; और उसके पुत्र एसाव और याकूब ने उसको मिट्टी दी। ");
INSERT INTO hin2017_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसाव जो एदोम भी कहलाता है, उसकी यह वंशावली है। ");
INSERT INTO hin2017_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसाव ने तो कनानी लड़कियाँ ब्याह लीं; अर्थात् हित्ती एलोन की बेटी आदा को, और ओहोलीबामा को जो अना की बेटी, और हिब्बी सिबोन की नातिन थी। ");
INSERT INTO hin2017_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","फिर उसने इश्माएल की बेटी बासमत को भी, जो नबायोत की बहन थी, ब्याह लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","आदा ने तो एसाव के द्वारा एलीपज को, और बासमत ने रूएल को जन्म दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","और ओहोलीबामा ने यूश, और यालाम, और कोरह को उत्पन्न किया, एसाव के ये ही पुत्र कनान देश में उत्पन्न हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","एसाव अपनी पत्नियों, और बेटे-बेटियों, और घर के सब प्राणियों, और अपनी भेड़-बकरी, और गाय-बैल आदि सब पशुओं, निदान अपनी सारी सम्पत्ति को, जो उसने कनान देश में संचय किया था, लेकर अपने भाई याकूब के पास से दूसरे देश को चला गया। ");
INSERT INTO hin2017_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","क्योंकि उनकी सम्पत्ति इतनी हो गई थी, कि वे इकट्ठे न रह सके; और पशुओं की बहुतायत के कारण उस देश में, जहाँ वे परदेशी होकर रहते थे, वे समा न सके। ");
INSERT INTO hin2017_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","एसाव जो एदोम भी कहलाता है, सेईर नामक पहाड़ी देश में रहने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","सेईर नामक पहाड़ी देश में रहनेवाले एदोमियों के मूलपुरुष एसाव की वंशावली यह है ");
INSERT INTO hin2017_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसाव के पुत्रों के नाम ये हैं; अर्थात् एसाव की पत्नी आदा का पुत्र एलीपज, और उसी एसाव की पत्नी बासमत का पुत्र रूएल। ");
INSERT INTO hin2017_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","और एलीपज के ये पुत्र हुए; अर्थात् तेमान, ओमार, सपो, गाताम, और कनज। ");
INSERT INTO hin2017_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एसाव के पुत्र एलीपज के तिम्ना नामक एक रखैल थी, जिसने एलीपज के द्वारा अमालेक को जन्म दिया: एसाव की पत्नी आदा के वंश में ये ही हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रूएल के ये पुत्र हुए; अर्थात् नहत, जेरह, शम्मा, और मिज्जा एसाव की पत्नी बासमत के वंश में ये ही हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ओहोलीबामा जो एसाव की पत्नी, और सिबोन की नातिन और अना की बेटी थी, उसके ये पुत्र हुए: अर्थात् उसने एसाव के द्वारा यूश, यालाम और कोरह को जन्म दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसाववंशियों के अधिपति ये हुए: अर्थात् एसाव के जेठे एलीपज के वंश में से तेमान अधिपति, ओमार अधिपति, सपो अधिपति, कनज अधिपति, ");
INSERT INTO hin2017_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोरह अधिपति, गाताम अधिपति, अमालेक अधिपति एलीपज वंशियों में से, एदोम देश में ये ही अधिपति हुए: और ये ही आदा के वंश में हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसाव के पुत्र रूएल के वंश में ये हुए; अर्थात् नहत अधिपति, जेरह अधिपति, शम्मा अधिपति, मिज्जा अधिपति रूएलवंशियों में से, एदोम देश में ये ही अधिपति हुए; और ये ही एसाव की पत्नी बासमत के वंश में हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसाव की पत्नी ओहोलीबामा के वंश में ये हुए; अर्थात् यूश अधिपति, यालाम अधिपति, कोरह अधिपति, अना की बेटी ओहोलीबामा जो एसाव की पत्नी थी उसके वंश में ये ही हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","एसाव जो एदोम भी कहलाता है, उसके वंश ये ही हैं, और उनके अधिपति भी ये ही हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","सेईर जो होरी नामक जाति का था, उसके ये पुत्र उस देश में पहले से रहते थे; अर्थात् लोतान, शोबाल, सिबोन, अना, ");
INSERT INTO hin2017_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीशोन, एसेर, और दीशान: एदोम देश में सेईर के ये ही होरी जातिवाले अधिपति हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतान के पुत्र, होरी, और हेमाम हुए; और लोतान की बहन तिम्ना थी। ");
INSERT INTO hin2017_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबाल के ये पुत्र हुए: अर्थात् आल्वान, मानहत, एबाल, शपो, और ओनाम। ");
INSERT INTO hin2017_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","और सीदोन के ये पुत्र हुए: अय्या, और अना; यह वही अना है जिसको जंगल में अपने पिता सिबोन के गदहों को चराते-चराते गरम पानी के झरने मिले। ");
INSERT INTO hin2017_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","और अना के दीशोन नामक पुत्र हुआ, और उसी अना के ओहोलीबामा नामक बेटी हुई। ");
INSERT INTO hin2017_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दीशोन के ये पुत्र हुए: हेमदान, एशबान, यित्रान, और करान। ");
INSERT INTO hin2017_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसेर के ये पुत्र हुए: बिल्हान, जावान, और अकान। ");
INSERT INTO hin2017_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीशान के ये पुत्र हुए: ऊस, और अरान। ");
INSERT INTO hin2017_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","होरियों के अधिपति ये हुए: लोतान अधिपति, शोबाल अधिपति, सिबोन अधिपति, अना अधिपति, ");
INSERT INTO hin2017_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दीशोन अधिपति, एसेर अधिपति, दीशान अधिपति; सेईर देश में होरी जातिवाले ये ही अधिपति हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","फिर जब इस्राएलियों पर किसी राजा ने राज्य न किया था, तब भी एदोम के देश में ये राजा हुए; ");
INSERT INTO hin2017_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बोर के पुत्र बेला ने एदोम में राज्य किया, और उसकी राजधानी का नाम दिन्हाबा है। ");
INSERT INTO hin2017_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बेला के मरने पर, बोस्रानिवासी जेरह का पुत्र योबाब उसके स्थान पर राजा हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","योबाब के मरने पर, तेमानियों के देश का निवासी हूशाम उसके स्थान पर राजा हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","फिर हूशाम के मरने पर, बदद का पुत्र हदद उसके स्थान पर राजा हुआ यह वही है जिसने मिद्यानियों को मोआब के देश में मार लिया, और उसकी राजधानी का नाम अबीत है। ");
INSERT INTO hin2017_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","हदद के मरने पर, मस्रेकावासी सम्ला उसके स्थान पर राजा हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","फिर सम्ला के मरने पर, शाऊल जो महानद के तटवाले रहोबोत नगर का था, वह उसके स्थान पर राजा हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","शाऊल के मरने पर, अकबोर का पुत्र बाल्हानान उसके स्थान पर राजा हुआ। ");
INSERT INTO hin2017_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","अकबोर के पुत्र बाल्हानान के मरने पर, हदर उसके स्थान पर राजा हुआ और उसकी राजधानी का नाम पाऊ है; और उसकी पत्नी का नाम महेतबेल है, जो मेज़ाहाब की नातिन और मत्रेद की बेटी थी। ");
INSERT INTO hin2017_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","फिर एसाववंशियों के अधिपतियों के कुलों, और स्थानों के अनुसार उनके नाम ये हैं तिम्ना अधिपति, अल्वा अधिपति, यतेत अधिपति, ");
INSERT INTO hin2017_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ओहोलीबामा अधिपति, एला अधिपति, पीनोन अधिपति, ");
INSERT INTO hin2017_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","कनज अधिपति, तेमान अधिपति, मिबसार अधिपति, ");
INSERT INTO hin2017_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","मग्दीएल अधिपति, ईराम अधिपति एदोमवंशियों ने जो देश अपना कर लिया था, उसके निवास-स्थानों में उनके ये ही अधिपति हुए; और एदोमी जाति का मूलपुरुष एसाव है। ");
INSERT INTO hin2017_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकूब तो कनान देश में रहता था, जहाँ उसका पिता परदेशी होकर रहा था। ");
INSERT INTO hin2017_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","और याकूब के वंश का वृत्तान्त यह है: यूसुफ सत्रह वर्ष का होकर अपने भाइयों के संग भेड़-बकरियों को चराता था; और वह लड़का अपने पिता की पत्नी बिल्हा, और जिल्पा के पुत्रों के संग रहा करता था; और उनकी बुराइयों का समाचार अपने पिता के पास पहुँचाया करता था। ");
INSERT INTO hin2017_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","और इस्राएल अपने सब पुत्रों से बढ़कर यूसुफ से प्रीति रखता था, क्योंकि वह उसके बुढ़ापे का पुत्र था: और उसने उसके लिये रंग-बिरंगा अंगरखा बनवाया। ");
INSERT INTO hin2017_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","परन्तु जब उसके भाइयों ने देखा, कि हमारा पिता हम सब भाइयों से अधिक उसी से प्रीति रखता है, तब वे उससे बैर करने लगे और उसके साथ ठीक से बात भी नहीं करते थे। ");
INSERT INTO hin2017_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","यूसुफ ने एक स्वप्न देखा, और अपने भाइयों से उसका वर्णन किया; तब वे उससे और भी द्वेष करने लगे। ");
INSERT INTO hin2017_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","उसने उनसे कहा, “जो स्वप्न मैंने देखा है, उसे सुनो ");
INSERT INTO hin2017_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","हम लोग खेत में पूले बाँध रहे हैं, और क्या देखता हूँ कि मेरा पूला उठकर सीधा खड़ा हो गया; तब तुम्हारे पूलों ने मेरे पूले को चारों तरफ से घेर लिया और उसे दण्डवत् किया।” ");
INSERT INTO hin2017_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","तब उसके भाइयों ने उससे कहा, “क्या सचमुच तू हमारे ऊपर राज्य करेगा? या क्या सचमुच तू हम पर प्रभुता करेगा?” इसलिए वे उसके स्वप्नों और उसकी बातों के कारण उससे और भी अधिक बैर करने लगे। ");
INSERT INTO hin2017_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","फिर उसने एक और स्वप्न देखा, और अपने भाइयों से उसका भी यह वर्णन किया, “सुनो, मैंने एक और स्वप्न देखा है, कि सूर्य और चन्द्रमा, और ग्यारह तारे मुझे दण्डवत् कर रहे हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","इस स्वप्न का उसने अपने पिता, और भाइयों से वर्णन किया; तब उसके पिता ने उसको डाँटकर कहा, “यह कैसा स्वप्न है जो तूने देखा है? क्या सचमुच मैं और तेरी माता और तेरे भाई सब जाकर तेरे आगे भूमि पर गिरकर दण्डवत् करेंगे?” ");
INSERT INTO hin2017_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","उसके भाई तो उससे डाह करते थे; पर उसके पिता ने उसके उस वचन को स्मरण रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","उसके भाई अपने पिता की भेड़-बकरियों को चराने के लिये शेकेम को गए। ");
INSERT INTO hin2017_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","तब इस्राएल ने यूसुफ से कहा, “तेरे भाई तो शेकेम ही में भेड़-बकरी चरा रहे होंगे, इसलिए जा, मैं तुझे उनके पास भेजता हूँ।” उसने उससे कहा, “जो आज्ञा मैं हाजिर हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","उसने उससे कहा, “जा, अपने भाइयों और भेड़-बकरियों का हाल देख आ कि वे कुशल से तो हैं, फिर मेरे पास समाचार ले आ।” अतः उसने उसको हेब्रोन की तराई में विदा कर दिया, और वह शेकेम में आया। ");
INSERT INTO hin2017_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","और किसी मनुष्य ने उसको मैदान में इधर-उधर भटकते हुए पाकर उससे पूछा, “तू क्या ढूँढ़ता है?” ");
INSERT INTO hin2017_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","उसने कहा, “मैं तो अपने भाइयों को ढूँढ़ता हूँ कृपा करके मुझे बता कि वे भेड़-बकरियों को कहाँ चरा रहे हैं?” ");
INSERT INTO hin2017_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","उस मनुष्य ने कहा, “वे तो यहाँ से चले गए हैं; और मैंने उनको यह कहते सुना, ‘आओ, हम दोतान को चलें।’” इसलिए यूसुफ अपने भाइयों के पीछे चला, और उन्हें दोतान में पाया। ");
INSERT INTO hin2017_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","जैसे ही उन्होंने उसे दूर से आते देखा, तो उसके निकट आने के पहले ही उसे मार डालने की युक्ति की। ");
INSERT INTO hin2017_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","और वे आपस में कहने लगे, “देखो, वह स्वप्न देखनेवाला आ रहा है। ");
INSERT INTO hin2017_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","इसलिए आओ, हम उसको घात करके किसी गड्ढे में डाल दें, और यह कह देंगे, कि कोई जंगली पशु उसको खा गया। फिर हम देखेंगे कि उसके स्वप्नों का क्या फल होगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","यह सुनकर रूबेन ने उसको उनके हाथ से बचाने की मनसा से कहा, “हम उसको प्राण से तो न मारें।” ");
INSERT INTO hin2017_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","फिर रूबेन ने उनसे कहा, “लहू मत बहाओ, उसको जंगल के इस गड्ढे में डाल दो, और उस पर हाथ मत उठाओ।” वह उसको उनके हाथ से छुड़ाकर पिता के पास फिर पहुँचाना चाहता था। ");
INSERT INTO hin2017_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","इसलिए ऐसा हुआ कि जब यूसुफ अपने भाइयों के पास पहुँचा तब उन्होंने उसका रंग-बिरंगा अंगरखा, जिसे वह पहने हुए था, उतार लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","और यूसुफ को उठाकर गड्ढे में डाल दिया। वह गड्ढा सूखा था और उसमें कुछ जल न था। ");
INSERT INTO hin2017_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","तब वे रोटी खाने को बैठ गए; और आँखें उठाकर क्या देखा कि इश्माएलियों का एक दल ऊँटों पर सुगन्ध-द्रव्य, बलसान, और गन्धरस लादे हुए, गिलाद से मिस्र को चला जा रहा है। ");
INSERT INTO hin2017_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","तब यहूदा ने अपने भाइयों से कहा, “अपने भाई को घात करने और उसका खून छिपाने से क्या लाभ होगा? ");
INSERT INTO hin2017_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","आओ, हम उसे इश्माएलियों के हाथ बेच डालें, और अपना हाथ उस पर न उठाएँ, क्योंकि वह हमारा भाई और हमारी ही हड्डी और माँस है।” और उसके भाइयों ने उसकी बात मान ली। ");
INSERT INTO hin2017_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","तब मिद्यानी व्यापारी उधर से होकर उनके पास पहुँचे। अतः यूसुफ के भाइयों ने उसको उस गड्ढे में से खींचकर बाहर निकाला, और इश्माएलियों के हाथ चाँदी के बीस टुकड़ों में बेच दिया; और वे यूसुफ को मिस्र में ले गए। (प्रेरि. 7:9) ");
INSERT INTO hin2017_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","रूबेन ने गड्ढे पर लौटकर क्या देखा कि यूसुफ गड्ढे में नहीं है; इसलिए उसने अपने वस्त्र फाड़े, ");
INSERT INTO hin2017_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","और अपने भाइयों के पास लौटकर कहने लगा, “लड़का तो नहीं है; अब मैं किधर जाऊँ?” ");
INSERT INTO hin2017_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","तब उन्होंने यूसुफ का अंगरखा लिया, और एक बकरे को मारकर उसके लहू में उसे डुबा दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","और उन्होंने उस रंगबिरंगे अंगरखे को अपने पिता के पास भेजकर यह सन्देश दिया; “यह हमको मिला है, अतः देखकर पहचान ले कि यह तेरे पुत्र का अंगरखा है कि नहीं।” ");
INSERT INTO hin2017_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","उसने उसको पहचान लिया, और कहा, “हाँ यह मेरे ही पुत्र का अंगरखा है; किसी दुष्ट पशु ने उसको खा लिया है; निःसन्देह यूसुफ फाड़ डाला गया है।” ");
INSERT INTO hin2017_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","तब याकूब ने अपने वस्त्र फाड़े और कमर में टाट लपेटा, और अपने पुत्र के लिये बहुत दिनों तक विलाप करता रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","और उसके सब बेटे-बेटियों ने उसको शान्ति देने का यत्न किया; पर उसको शान्ति न मिली; और वह यही कहता रहा, “मैं तो विलाप करता हुआ अपने पुत्र के पास अधोलोक में उतर जाऊँगा।” इस प्रकार उसका पिता उसके लिये रोता ही रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","इस बीच मिद्यानियों ने यूसुफ को मिस्र में ले जाकर पोतीपर नामक, फ़िरौन के एक हाकिम, और अंगरक्षकों के प्रधान, के हाथ बेच डाला। ");
INSERT INTO hin2017_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","उन्हीं दिनों में ऐसा हुआ कि यहूदा अपने भाइयों के पास से चला गया, और हीरा नामक एक अदुल्लामवासी पुरुष के पास डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","वहाँ यहूदा ने शूआ नामक एक कनानी पुरुष की बेटी को देखा; और उससे विवाह करके उसके पास गया। ");
INSERT INTO hin2017_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","वह गर्भवती हुई, और उसके एक पुत्र उत्पन्न हुआ; और यहूदा ने उसका नाम एर रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","और वह फिर गर्भवती हुई, और उसके एक पुत्र और उत्पन्न हुआ; और उसका नाम ओनान रखा गया। ");
INSERT INTO hin2017_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","फिर उसके एक पुत्र और उत्पन्न हुआ, और उसका नाम शेला रखा गया; और जिस समय इसका जन्म हुआ उस समय यहूदा कजीब में रहता था। ");
INSERT INTO hin2017_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","और यहूदा ने तामार नामक एक स्त्री से अपने जेठे एर का विवाह कर दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","परन्तु यहूदा का वह जेठा एर यहोवा के लेखे में दुष्ट था, इसलिए यहोवा ने उसको मार डाला। ");
INSERT INTO hin2017_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","तब यहूदा ने ओनान से कहा, “अपनी भौजाई के पास जा, और उसके साथ देवर का धर्म पूरा करके अपने भाई के लिये सन्तान उत्पन्न कर।” ");
INSERT INTO hin2017_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ओनान तो जानता था कि सन्तान मेरी न ठहरेगी; इसलिए ऐसा हुआ कि जब वह अपनी भौजाई के पास गया, तब उसने भूमि पर वीर्य गिराकर नाश किया, जिससे ऐसा न हो कि उसके भाई के नाम से वंश चले। ");
INSERT INTO hin2017_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","यह काम जो उसने किया उससे यहोवा अप्रसन्न हुआ और उसने उसको भी मार डाला। ");
INSERT INTO hin2017_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","तब यहूदा ने इस डर के मारे कि कहीं ऐसा न हो कि अपने भाइयों के समान शेला भी मरे, अपनी बहू तामार से कहा, “जब तक मेरा पुत्र शेला सयाना न हो जाए तब तक अपने पिता के घर में विधवा ही बैठी रह।” इसलिए तामार अपने पिता के घर में जाकर रहने लगी। ");
INSERT INTO hin2017_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","बहुत समय के बीतने पर यहूदा की पत्नी जो शूआ की बेटी थी, वह मर गई; फिर यहूदा शोक के दिन बीतने पर अपने मित्र हीरा अदुल्लामवासी समेत अपनी भेड़-बकरियों का ऊन कतरनेवालों के पास तिम्नाह को गया। ");
INSERT INTO hin2017_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","और तामार को यह समाचार मिला, “तेरा ससुर अपनी भेड़-बकरियों का ऊन कतराने के लिये तिम्नाह को जा रहा है।” ");
INSERT INTO hin2017_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","तब उसने यह सोचकर कि शेला सयाना तो हो गया पर मैं उसकी स्त्री नहीं होने पाई; अपना विधवापन का पहरावा उतारा और घूँघट डालकर अपने को ढाँप लिया, और एनैम नगर के फाटक के पास, जो तिम्नाह के मार्ग में है, जा बैठी। ");
INSERT INTO hin2017_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","जब यहूदा ने उसको देखा, उसने उसको वेश्या समझा; क्योंकि वह अपना मुँह ढाँपे हुए थी। ");
INSERT INTO hin2017_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","वह मार्ग से उसकी ओर फिरा, और उससे कहने लगा, “मुझे अपने पास आने दे,” (क्योंकि उसे यह मालूम न था कि वह उसकी बहू है।) और वह कहने लगी, “यदि मैं तुझे अपने पास आने दूँ, तो तू मुझे क्या देगा?” ");
INSERT INTO hin2017_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","उसने कहा, “मैं अपनी बकरियों में से बकरी का एक बच्चा तेरे पास भेज दूँगा।” तब उसने कहा, “भला उसके भेजने तक क्या तू हमारे पास कुछ रेहन रख जाएगा?” ");
INSERT INTO hin2017_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","उसने पूछा, “मैं तेरे पास क्या रेहन रख जाऊँ?” उसने कहा, “अपनी मुहर, और बाजूबन्द, और अपने हाथ की छड़ी।” तब उसने उसको वे वस्तुएँ दे दीं, और उसके पास गया, और वह उससे गर्भवती हुई। ");
INSERT INTO hin2017_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","तब वह उठकर चली गई, और अपना घूँघट उतारकर अपना विधवापन का पहरावा फिर पहन लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","तब यहूदा ने बकरी का बच्चा अपने मित्र उस अदुल्लामवासी के हाथ भेज दिया कि वह रेहन रखी हुई वस्तुएँ उस स्त्री के हाथ से छुड़ा ले आए; पर वह स्त्री उसको न मिली। ");
INSERT INTO hin2017_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","तब उसने वहाँ के लोगों से पूछा, “वह देवदासी जो एनैम में मार्ग की एक ओर बैठी थी, कहाँ है?” उन्होंने कहा, “यहाँ तो कोई देवदासी न थी।” ");
INSERT INTO hin2017_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","इसलिए उसने यहूदा के पास लौटकर कहा, “मुझे वह नहीं मिली; और उस स्थान के लोगों ने कहा, ‘यहाँ तो कोई देवदासी न थी।’” ");
INSERT INTO hin2017_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","तब यहूदा ने कहा, “अच्छा, वह बन्धक उसी के पास रहने दे, नहीं तो हम लोग तुच्छ गिने जाएँगे; देख, मैंने बकरी का यह बच्चा भेज दिया था, पर वह तुझे नहीं मिली।” ");
INSERT INTO hin2017_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","लगभग तीन महीने के बाद यहूदा को यह समाचार मिला, “तेरी बहू तामार ने व्यभिचार किया है; वरन् वह व्यभिचार से गर्भवती भी हो गई है।” तब यहूदा ने कहा, “उसको बाहर ले आओ कि वह जलाई जाए।” ");
INSERT INTO hin2017_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","जब उसे बाहर निकाला जा रहा था, तब उसने, अपने ससुर के पास यह कहला भेजा, “जिस पुरुष की ये वस्तुएँ हैं, उसी से मैं गर्भवती हूँ,” फिर उसने यह भी कहलाया, “पहचान तो सही कि यह मुहर, और बाजूबन्द, और छड़ी किसकी हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदा ने उन्हें पहचानकर कहा, “वह तो मुझसे कम दोषी है; क्योंकि मैंने उसका अपने पुत्र शेला से विवाह न किया।” और उसने उससे फिर कभी प्रसंग न किया। ");
INSERT INTO hin2017_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","जब उसके जनने का समय आया, तब यह जान पड़ा कि उसके गर्भ में जुड़वे बच्चे हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","और जब वह जनने लगी तब एक बालक का हाथ बाहर आया, और दाई ने लाल सूत लेकर उसके हाथ में यह कहते हुए बाँध दिया, “पहले यही उत्पन्न हुआ।” ");
INSERT INTO hin2017_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","जब उसने हाथ समेट लिया, तब उसका भाई उत्पन्न हो गया। तब उस दाई ने कहा, “तू क्यों बरबस निकल आया है?” इसलिए उसका नाम पेरेस रखा गया। ");
INSERT INTO hin2017_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","पीछे उसका भाई जिसके हाथ में लाल सूत बन्धा था उत्पन्न हुआ, और उसका नाम जेरह रखा गया। ");
INSERT INTO hin2017_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","जब यूसुफ मिस्र में पहुँचाया गया, तब पोतीपर नामक एक मिस्री ने, जो फ़िरौन का हाकिम, और अंगरक्षकों का प्रधान था, उसको इश्माएलियों के हाथ से जो उसे वहाँ ले गए थे, मोल लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","यूसुफ अपने मिस्री स्वामी के घर में रहता था, और यहोवा उसके संग था; इसलिए वह सफल पुरुष हो गया। (प्रेरि. 7:9) ");
INSERT INTO hin2017_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","और यूसुफ के स्वामी ने देखा, कि यहोवा उसके संग रहता है, और जो काम वह करता है उसको यहोवा उसके हाथ से सफल कर देता है। (प्रेरि. 7:9) ");
INSERT INTO hin2017_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","तब उसकी अनुग्रह की दृष्टि उस पर हुई, और वह उसकी सेवा टहल करने के लिये नियुक्त किया गया; फिर उसने उसको अपने घर का अधिकारी बनाकर अपना सब कुछ उसके हाथ में सौंप दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","जब से उसने उसको अपने घर का और अपनी सारी सम्पत्ति का अधिकारी बनाया, तब से यहोवा यूसुफ के कारण उस मिस्री के घर पर आशीष देने लगा; और क्या घर में, क्या मैदान में, उसका जो कुछ था, सब पर यहोवा की आशीष होने लगी। ");
INSERT INTO hin2017_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","इसलिए उसने अपना सब कुछ यूसुफ के हाथ में यहाँ तक छोड़ दिया कि अपने खाने की रोटी को छोड़, वह अपनी सम्पत्ति का हाल कुछ न जानता था। यूसुफ सुन्दर और रूपवान था। ");
INSERT INTO hin2017_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","इन बातों के पश्चात् ऐसा हुआ, कि उसके स्वामी की पत्नी ने यूसुफ की ओर आँख लगाई और कहा, “मेरे साथ सो।” ");
INSERT INTO hin2017_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","पर उसने अस्वीकार करते हुए अपने स्वामी की पत्नी से कहा, “सुन, जो कुछ इस घर में है मेरे हाथ में है; उसे मेरा स्वामी कुछ नहीं जानता, और उसने अपना सब कुछ मेरे हाथ में सौंप दिया है। ");
INSERT INTO hin2017_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","इस घर में मुझसे बड़ा कोई नहीं; और उसने तुझे छोड़, जो उसकी पत्नी है; मुझसे कुछ नहीं रख छोड़ा; इसलिए भला, मैं ऐसी बड़ी दुष्टता करके परमेश्वर का अपराधी क्यों बनूँ?” ");
INSERT INTO hin2017_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","और ऐसा हुआ कि वह प्रतिदिन यूसुफ से बातें करती रही, पर उसने उसकी न मानी कि उसके पास लेटे या उसके संग रहे। ");
INSERT INTO hin2017_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","एक दिन क्या हुआ कि यूसुफ अपना काम-काज करने के लिये घर में गया, और घर के सेवकों में से कोई भी घर के अन्दर न था। ");
INSERT INTO hin2017_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","तब उस स्त्री ने उसका वस्त्र पकड़कर कहा, “मेरे साथ सो,” पर वह अपना वस्त्र उसके हाथ में छोड़कर भागा, और बाहर निकल गया। ");
INSERT INTO hin2017_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","यह देखकर कि वह अपना वस्त्र मेरे हाथ में छोड़कर बाहर भाग गया, ");
INSERT INTO hin2017_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","उस स्त्री ने अपने घर के सेवकों को बुलाकर कहा, “देखो, वह एक इब्री मनुष्य को हमारा तिरस्कार करने के लिये हमारे पास ले आया है। वह तो मेरे साथ सोने के मतलब से मेरे पास अन्दर आया था और मैं ऊँचे स्वर से चिल्ला उठी। ");
INSERT INTO hin2017_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","और मेरी बड़ी चिल्लाहट सुनकर वह अपना वस्त्र मेरे पास छोड़कर भागा, और बाहर निकल गया।” ");
INSERT INTO hin2017_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","और वह उसका वस्त्र उसके स्वामी के घर आने तक अपने पास रखे रही। ");
INSERT INTO hin2017_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","तब उसने उससे इस प्रकार की बातें कहीं, “वह इब्री दास जिसको तू हमारे पास ले आया है, वह मुझसे हँसी करने के लिये मेरे पास आया था; ");
INSERT INTO hin2017_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","और जब मैं ऊँचे स्वर से चिल्ला उठी, तब वह अपना वस्त्र मेरे पास छोड़कर बाहर भाग गया।” ");
INSERT INTO hin2017_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","अपनी पत्नी की ये बातें सुनकर कि तेरे दास ने मुझसे ऐसा-ऐसा काम किया, यूसुफ के स्वामी का कोप भड़का। ");
INSERT INTO hin2017_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","और यूसुफ के स्वामी ने उसको पकड़कर बन्दीगृह में, जहाँ राजा के कैदी बन्द थे, डलवा दिया; अतः वह उस बन्दीगृह में रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","पर यहोवा यूसुफ के संग-संग रहा, और उस पर करुणा की, और बन्दीगृह के दरोगा के अनुग्रह की दृष्टि उस पर हुई। ");
INSERT INTO hin2017_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","इसलिए बन्दीगृह के दरोगा ने उन सब बन्दियों को, जो कारागार में थे, यूसुफ के हाथ में सौंप दिया; और जो-जो काम वे वहाँ करते थे, वह उसी की आज्ञा से होता था। ");
INSERT INTO hin2017_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","यूसुफ के वश में जो कुछ था उसमें से बन्दीगृह के दरोगा को कोई भी वस्तु देखनी न पड़ती थी; क्योंकि यहोवा यूसुफ के साथ था; और जो कुछ वह करता था, यहोवा उसको उसमें सफलता देता था। ");
INSERT INTO hin2017_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","इन बातों के पश्चात् ऐसा हुआ, कि मिस्र के राजा के पिलानेहारे और पकानेहारे ने अपने स्वामी के विरुद्ध कुछ अपराध किया। ");
INSERT INTO hin2017_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","तब फ़िरौन ने अपने उन दोनों हाकिमों, अर्थात् पिलानेहारों के प्रधान, और पकानेहारों के प्रधान पर क्रोधित होकर ");
INSERT INTO hin2017_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","उन्हें कैद कराके, अंगरक्षकों के प्रधान के घर के उसी बन्दीगृह में, जहाँ यूसुफ बन्दी था, डलवा दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","तब अंगरक्षकों के प्रधान ने उनको यूसुफ के हाथ सौंपा, और वह उनकी सेवा-टहल करने लगा; अतः वे कुछ दिन तक बन्दीगृह में रहे। ");
INSERT INTO hin2017_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","मिस्र के राजा का पिलानेहारा और पकानेहारा, जो बन्दीगृह में बन्द थे, उन दोनों ने एक ही रात में, अपने-अपने होनहार के अनुसार, स्वप्न देखा। ");
INSERT INTO hin2017_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","सवेरे जब यूसुफ उनके पास अन्दर गया, तब उन पर उसने जो दृष्टि की, तो क्या देखता है, कि वे उदास हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","इसलिए उसने फ़िरौन के उन हाकिमों से, जो उसके साथ उसके स्वामी के घर के बन्दीगृह में थे, पूछा, “आज तुम्हारे मुँह क्यों उदास हैं?” ");
INSERT INTO hin2017_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","उन्होंने उससे कहा, “हम दोनों ने स्वप्न देखा है, और उनके फल का बतानेवाला कोई भी नहीं।” यूसुफ ने उनसे कहा, “क्या स्वप्नों का फल कहना परमेश्वर का काम नहीं है? मुझे अपना-अपना स्वप्न बताओ।” ");
INSERT INTO hin2017_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","तब पिलानेहारों का प्रधान अपना स्वप्न यूसुफ को यह बताने लगा: “मैंने स्वप्न में देखा, कि मेरे सामने एक दाखलता है; ");
INSERT INTO hin2017_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","और उस दाखलता में तीन डालियाँ हैं; और उसमें मानो कलियाँ लगीं हैं, और वे फूलीं और उसके गुच्छों में दाख लगकर पक गई। ");
INSERT INTO hin2017_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","और फ़िरौन का कटोरा मेरे हाथ में था; और मैंने उन दाखों को लेकर फ़िरौन के कटोरे में निचोड़ा और कटोरे को फ़िरौन के हाथ में दिया।” ");
INSERT INTO hin2017_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","यूसुफ ने उससे कहा, “इसका फल यह है: तीन डालियों का अर्थ तीन दिन हैं ");
INSERT INTO hin2017_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","इसलिए अब से तीन दिन के भीतर फ़िरौन तेरा सिर ऊँचा करेगा, और फिर से तेरे पद पर तुझे नियुक्त करेगा, और तू पहले के समान फ़िरौन का पिलानेहारा होकर उसका कटोरा उसके हाथ में फिर दिया करेगा। ");
INSERT INTO hin2017_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","अतः जब तेरा भला हो जाए तब मुझे स्मरण करना, और मुझ पर कृपा करके फ़िरौन से मेरी चर्चा चलाना, और इस घर से मुझे छुड़वा देना। ");
INSERT INTO hin2017_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","क्योंकि सचमुच इब्रानियों के देश से मुझे चुराकर लाया गया हैं, और यहाँ भी मैंने कोई ऐसा काम नहीं किया, जिसके कारण मैं इस कारागार में डाला जाऊँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","यह देखकर कि उसके स्वप्न का फल अच्छा निकला, पकानेहारों के प्रधान ने यूसुफ से कहा, “मैंने भी स्वप्न देखा है, वह यह है: मैंने देखा कि मेरे सिर पर सफेद रोटी की तीन टोकरियाँ हैं ");
INSERT INTO hin2017_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","और ऊपर की टोकरी में फ़िरौन के लिये सब प्रकार की पकी पकाई वस्तुएँ हैं; और पक्षी मेरे सिर पर की टोकरी में से उन वस्तुओं को खा रहे हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","यूसुफ ने कहा, “इसका फल यह है: तीन टोकरियों का अर्थ तीन दिन है। ");
INSERT INTO hin2017_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","अब से तीन दिन के भीतर फ़िरौन तेरा सिर कटवाकर तुझे एक वृक्ष पर टंगवा देगा, और पक्षी तेरे माँस को नोच-नोच कर खाएँगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","और तीसरे दिन फ़िरौन का जन्मदिन था, उसने अपने सब कर्मचारियों को भोज दिया, और उनमें से पिलानेहारों के प्रधान, और पकानेहारों के प्रधान दोनों को बन्दीगृह से निकलवाया। ");
INSERT INTO hin2017_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","पिलानेहारों के प्रधान को तो पिलानेहारे के पद पर फिर से नियुक्त किया, और वह फ़िरौन के हाथ में कटोरा देने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","पर पकानेहारों के प्रधान को उसने टंगवा दिया, जैसा कि यूसुफ ने उनके स्वप्नों का फल उनसे कहा था। ");
INSERT INTO hin2017_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","फिर भी पिलानेहारों के प्रधान ने यूसुफ को स्मरण न रखा; परन्तु उसे भूल गया। ");
INSERT INTO hin2017_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","पूरे दो वर्ष के बीतने पर फ़िरौन ने यह स्वप्न देखा कि वह नील नदी के किनारे खड़ा है। ");
INSERT INTO hin2017_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","और उस नदी में से सात सुन्दर और मोटी-मोटी गायें निकलकर कछार की घास चरने लगीं। ");
INSERT INTO hin2017_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","और, क्या देखा कि उनके पीछे और सात गायें, जो कुरूप और दुर्बल हैं, नदी से निकलीं; और दूसरी गायों के निकट नदी के तट पर जा खड़ी हुईं। ");
INSERT INTO hin2017_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","तब ये कुरूप और दुर्बल गायें उन सात सुन्दर और मोटी-मोटी गायों को खा गईं। तब फ़िरौन जाग उठा। ");
INSERT INTO hin2017_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","और वह फिर सो गया और दूसरा स्वप्न देखा कि एक डंठल में से सात मोटी और अच्छी-अच्छी बालें निकलीं। ");
INSERT INTO hin2017_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","और, क्या देखा कि उनके पीछे सात बालें पतली और पुरवाई से मुर्झाई हुई निकलीं। ");
INSERT INTO hin2017_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","और इन पतली बालों ने उन सातों मोटी और अन्न से भरी हुई बालों को निगल लिया। तब फ़िरौन जागा, और उसे मालूम हुआ कि यह स्वप्न ही था। ");
INSERT INTO hin2017_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","भोर को फ़िरौन का मन व्याकुल हुआ; और उसने मिस्र के सब ज्योतिषियों, और पंडितों को बुलवा भेजा; और उनको अपने स्वप्न बताए; पर उनमें से कोई भी उनका फल फ़िरौन को न बता सका। ");
INSERT INTO hin2017_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","तब पिलानेहारों का प्रधान फ़िरौन से बोल उठा, “मेरे अपराध आज मुझे स्मरण आए: ");
INSERT INTO hin2017_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","जब फ़िरौन अपने दासों से क्रोधित हुआ था, और मुझे और पकानेहारों के प्रधान को कैद कराके अंगरक्षकों के प्रधान के घर के बन्दीगृह में डाल दिया था; ");
INSERT INTO hin2017_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","तब हम दोनों ने एक ही रात में, अपने-अपने होनहार के अनुसार स्वप्न देखा; ");
INSERT INTO hin2017_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","और वहाँ हमारे साथ एक इब्री जवान था, जो अंगरक्षकों के प्रधान का दास था; अतः हमने उसको बताया, और उसने हमारे स्वप्नों का फल हम से कहा, हम में से एक-एक के स्वप्न का फल उसने बता दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","और जैसा-जैसा फल उसने हम से कहा था, वैसा ही हुआ भी, अर्थात् मुझ को तो मेरा पद फिर मिला, पर वह फांसी पर लटकाया गया।” ");
INSERT INTO hin2017_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","तब फ़िरौन ने यूसुफ को बुलवा भेजा। और वह झटपट बन्दीगृह से बाहर निकाला गया, और बाल बनवाकर, और वस्त्र बदलकर फ़िरौन के सामने आया। ");
INSERT INTO hin2017_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फ़िरौन ने यूसुफ से कहा, “मैंने एक स्वप्न देखा है, और उसके फल का बतानेवाला कोई भी नहीं; और मैंने तेरे विषय में सुना है, कि तू स्वप्न सुनते ही उसका फल बता सकता है।” ");
INSERT INTO hin2017_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","यूसुफ ने फ़िरौन से कहा, “मैं तो कुछ नहीं जानता: परमेश्वर ही फ़िरौन के लिये शुभ वचन देगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","फिर फ़िरौन यूसुफ से कहने लगा, “मैंने अपने स्वप्न में देखा, कि मैं नील नदी के किनारे पर खड़ा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","फिर, क्या देखा, कि नदी में से सात मोटी और सुन्दर-सुन्दर गायें निकलकर कछार की घास चरने लगीं। ");
INSERT INTO hin2017_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","फिर, क्या देखा, कि उनके पीछे सात और गायें निकली, जो दुबली, और बहुत कुरूप, और दुर्बल हैं; मैंने तो सारे मिस्र देश में ऐसी कुडौल गायें कभी नहीं देखीं। ");
INSERT INTO hin2017_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","इन दुर्बल और कुडौल गायों ने उन पहली सातों मोटी-मोटी गायों को खा लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","और जब वे उनको खा गईं तब यह मालूम नहीं होता था कि वे उनको खा गई हैं, क्योंकि वे पहले के समान जैसी की तैसी कुडौल रहीं। तब मैं जाग उठा। ");
INSERT INTO hin2017_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","फिर मैंने दूसरा स्वप्न देखा, कि एक ही डंठल में सात अच्छी-अच्छी और अन्न से भरी हुई बालें निकलीं। ");
INSERT INTO hin2017_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","फिर क्या देखता हूँ, कि उनके पीछे और सात बालें छूछी-छूछी और पतली और पुरवाई से मुर्झाई हुई निकलीं। ");
INSERT INTO hin2017_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","और इन पतली बालों ने उन सात अच्छी-अच्छी बालों को निगल लिया। इसे मैंने ज्योतिषियों को बताया, पर इसका समझानेवाला कोई नहीं मिला।” ");
INSERT INTO hin2017_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","तब यूसुफ ने फ़िरौन से कहा, “फ़िरौन का स्वप्न एक ही है, परमेश्वर जो काम करना चाहता है, उसको उसने फ़िरौन पर प्रगट किया है। ");
INSERT INTO hin2017_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","वे सात अच्छी-अच्छी गायें सात वर्ष हैं; और वे सात अच्छी-अच्छी बालें भी सात वर्ष हैं; स्वप्न एक ही है। ");
INSERT INTO hin2017_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","फिर उनके पीछे जो दुर्बल और कुडौल गायें निकलीं, और जो सात छूछी और पुरवाई से मुर्झाई हुई बालें निकालीं, वे अकाल के सात वर्ष होंगे। ");
INSERT INTO hin2017_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","यह वही बात है जो मैं फ़िरौन से कह चुका हूँ, कि परमेश्वर जो काम करना चाहता है, उसे उसने फ़िरौन को दिखाया है। ");
INSERT INTO hin2017_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","सुन, सारे मिस्र देश में सात वर्ष तो बहुतायत की उपज के होंगे। ");
INSERT INTO hin2017_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","उनके पश्चात् सात वर्ष अकाल के आएँगे, और सारे मिस्र देश में लोग इस सारी उपज को भूल जाएँगे; और अकाल से देश का नाश होगा। ");
INSERT INTO hin2017_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","और सुकाल (बहुतायत की उपज) देश में फिर स्मरण न रहेगा क्योंकि अकाल अत्यन्त भयंकर होगा। ");
INSERT INTO hin2017_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","और फ़िरौन ने जो यह स्वप्न दो बार देखा है इसका भेद यही है कि यह बात परमेश्वर की ओर से नियुक्त हो चुकी है, और परमेश्वर इसे शीघ्र ही पूरा करेगा। ");
INSERT INTO hin2017_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","इसलिए अब फ़िरौन किसी समझदार और बुद्धिमान् पुरुष को ढूँढ़ करके उसे मिस्र देश पर प्रधानमंत्री ठहराए। ");
INSERT INTO hin2017_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","फ़िरौन यह करे कि देश पर अधिकारियों को नियुक्त करे, और जब तक सुकाल के सात वर्ष रहें तब तक वह मिस्र देश की उपज का पंचमांश लिया करे। ");
INSERT INTO hin2017_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","और वे इन अच्छे वर्षों में सब प्रकार की भोजनवस्तु इकट्ठा करें, और नगर-नगर में भण्डार घर भोजन के लिये, फ़िरौन के वश में करके उसकी रक्षा करें। ");
INSERT INTO hin2017_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","और वह भोजनवस्तु अकाल के उन सात वर्षों के लिये, जो मिस्र देश में आएँगे, देश के भोजन के निमित्त रखी रहे, जिससे देश का उस अकाल से सत्यानाश न हो जाए।” ");
INSERT INTO hin2017_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","यह बात फ़िरौन और उसके सारे कर्मचारियों को अच्छी लगी। ");
INSERT INTO hin2017_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","इसलिए फ़िरौन ने अपने कर्मचारियों से कहा, “क्या हमको ऐसा पुरुष, जैसा यह है, जिसमें परमेश्वर का आत्मा रहता है, मिल सकता है?” ");
INSERT INTO hin2017_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","फिर फ़िरौन ने यूसुफ से कहा, “परमेश्वर ने जो तुझे इतना ज्ञान दिया है, कि तेरे तुल्य कोई समझदार और बुद्धिमान नहीं; ");
INSERT INTO hin2017_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","इस कारण तू मेरे घर का अधिकारी होगा, और तेरी आज्ञा के अनुसार मेरी सारी प्रजा चलेगी, केवल राजगद्दी के विषय मैं तुझ से बड़ा ठहरूँगा।” (प्रेरि. 7:10) ");
INSERT INTO hin2017_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","फिर फ़िरौन ने यूसुफ से कहा, “सुन, मैं तुझको मिस्र के सारे देश के ऊपर अधिकारी ठहरा देता हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","तब फ़िरौन ने अपने हाथ से मुहर वाली अंगूठी निकालकर यूसुफ के हाथ में पहना दी; और उसको बढ़िया मलमल के वस्त्र पहनवा दिए, और उसके गले में सोने की माला डाल दी; ");
INSERT INTO hin2017_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","और उसको अपने दूसरे रथ पर चढ़वाया; और लोग उसके आगे-आगे यह प्रचार करते चले, कि घुटने टेककर दण्डवत् करो और उसने उसको मिस्र के सारे देश के ऊपर प्रधानमंत्री ठहराया। ");
INSERT INTO hin2017_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","फिर फ़िरौन ने यूसुफ से कहा, “फ़िरौन तो मैं हूँ, और सारे मिस्र देश में कोई भी तेरी आज्ञा के बिना हाथ पाँव न हिलाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","फ़िरौन ने यूसुफ का नाम सापनत-पानेह रखा। और ओन नगर के याजक पोतीपेरा की बेटी आसनत से उसका ब्याह करा दिया। और यूसुफ सारे मिस्र देश में दौरा करने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","जब यूसुफ मिस्र के राजा फ़िरौन के सम्मुख खड़ा हुआ, तब वह तीस वर्ष का था। वह फ़िरौन के सम्मुख से निकलकर सारे मिस्र देश में दौरा करने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","सुकाल के सातों वर्षों में भूमि बहुतायत से अन्न उपजाती रही। ");
INSERT INTO hin2017_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","और यूसुफ उन सातों वर्षों में सब प्रकार की भोजनवस्तुएँ, जो मिस्र देश में होती थीं, जमा करके नगरों में रखता गया, और हर एक नगर के चारों ओर के खेतों की भोजनवस्तुओं को वह उसी नगर में इकट्ठा करता गया। ");
INSERT INTO hin2017_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","इस प्रकार यूसुफ ने अन्न को समुद्र की रेत के समान अत्यन्त बहुतायत से राशि-राशि गिनके रखा, यहाँ तक कि उसने उनका गिनना छोड़ दिया; क्योंकि वे असंख्य हो गईं। ");
INSERT INTO hin2017_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","अकाल के प्रथम वर्ष के आने से पहले यूसुफ के दो पुत्र, ओन के याजक पोतीपेरा की बेटी आसनत से जन्मे। ");
INSERT INTO hin2017_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","और यूसुफ ने अपने जेठे का नाम यह कहकर मनश्शे रखा, कि ‘परमेश्वर ने मुझसे मेरा सारा क्लेश, और मेरे पिता का सारा घराना भुला दिया है।’ ");
INSERT INTO hin2017_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","दूसरे का नाम उसने यह कहकर एप्रैम रखा, कि ‘मुझे दुःख भोगने के देश में परमेश्वर ने फलवन्त किया है।’ ");
INSERT INTO hin2017_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","और मिस्र देश के सुकाल के सात वर्ष समाप्त हो गए। ");
INSERT INTO hin2017_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","और यूसुफ के कहने के अनुसार सात वर्षों के लिये अकाल आरम्भ हो गया। सब देशों में अकाल पड़ने लगा; परन्तु सारे मिस्र देश में अन्न था। (प्रेरि. 7:11) ");
INSERT INTO hin2017_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","जब मिस्र का सारा देश भूखा मरने लगा; तब प्रजा फ़िरौन से चिल्ला चिल्लाकर रोटी माँगने लगी; और वह सब मिस्रियों से कहा करता था, “यूसुफ के पास जाओ; और जो कुछ वह तुम से कहे, वही करो।” (प्रेरि. 7:11, यूह. 2:5) ");
INSERT INTO hin2017_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","इसलिए जब अकाल सारी पृथ्वी पर फैल गया, और मिस्र देश में अकाल का भयंकर रूप हो गया, तब यूसुफ सब भण्डारों को खोल-खोलकर मिस्रियों के हाथ अन्न बेचने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","इसलिए सारी पृथ्वी के लोग मिस्र में अन्न मोल लेने के लिये यूसुफ के पास आने लगे, क्योंकि सारी पृथ्वी पर भयंकर अकाल था। ");
INSERT INTO hin2017_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","जब याकूब ने सुना कि मिस्र में अन्न है, तब उसने अपने पुत्रों से कहा, “तुम एक दूसरे का मुँह क्यों देख रहे हो।” ");
INSERT INTO hin2017_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","फिर उसने कहा, “मैंने सुना है कि मिस्र में अन्न है; इसलिए तुम लोग वहाँ जाकर हमारे लिये अन्न मोल ले आओ, जिससे हम न मरें, वरन् जीवित रहें।” (प्रेरि. 7:12) ");
INSERT INTO hin2017_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","अतः यूसुफ के दस भाई अन्न मोल लेने के लिये मिस्र को गए। ");
INSERT INTO hin2017_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","पर यूसुफ के भाई बिन्यामीन को याकूब ने यह सोचकर भाइयों के साथ न भेजा कि कहीं ऐसा न हो कि उस पर कोई विपत्ति आ पड़े। ");
INSERT INTO hin2017_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","इस प्रकार जो लोग अन्न मोल लेने आए उनके साथ इस्राएल के पुत्र भी आए; क्योंकि कनान देश में भी भारी अकाल था। (प्रेरि. 7:11) ");
INSERT INTO hin2017_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","यूसुफ तो मिस्र देश का अधिकारी था, और उस देश के सब लोगों के हाथ वही अन्न बेचता था; इसलिए जब यूसुफ के भाई आए तब भूमि पर मुँह के बल गिरकर उसको दण्डवत् किया। ");
INSERT INTO hin2017_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","उनको देखकर यूसुफ ने पहचान तो लिया, परन्तु उनके सामने भोला बनकर कठोरता के साथ उनसे पूछा, “तुम कहाँ से आते हो?” उन्होंने कहा, “हम तो कनान देश से अन्न मोल लेने के लिये आए हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","यूसुफ ने अपने भाइयों को पहचान लिया, परन्तु उन्होंने उसको न पहचाना। ");
INSERT INTO hin2017_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","तब यूसुफ अपने उन स्वप्नों को स्मरण करके जो उसने उनके विषय में देखे थे, उनसे कहने लगा, “तुम भेदिए हो; इस देश की दुर्दशा को देखने के लिये आए हो।” ");
INSERT INTO hin2017_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","उन्होंने उससे कहा, “नहीं, नहीं, हे प्रभु, तेरे दास भोजनवस्तु मोल लेने के लिये आए हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","हम सब एक ही पिता के पुत्र हैं, हम सीधे मनुष्य हैं, तेरे दास भेदिए नहीं।” ");
INSERT INTO hin2017_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","उसने उनसे कहा, “नहीं नहीं, तुम इस देश की दुर्दशा देखने ही को आए हो।” ");
INSERT INTO hin2017_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","उन्होंने कहा, “हम तेरे दास बारह भाई हैं, और कनान देशवासी एक ही पुरुष के पुत्र हैं, और छोटा इस समय हमारे पिता के पास है, और एक जाता रहा।” ");
INSERT INTO hin2017_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","तब यूसुफ ने उनसे कहा, “मैंने तो तुम से कह दिया, कि तुम भेदिए हो; ");
INSERT INTO hin2017_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","अतः इसी रीति से तुम परखे जाओगे, फ़िरौन के जीवन की शपथ, जब तक तुम्हारा छोटा भाई यहाँ न आए तब तक तुम यहाँ से न निकलने पाओगे। ");
INSERT INTO hin2017_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","इसलिए अपने में से एक को भेज दो कि वह तुम्हारे भाई को ले आए, और तुम लोग बन्दी रहोगे; इस प्रकार तुम्हारी बातें परखी जाएँगी कि तुम में सच्चाई है कि नहीं। यदि सच्चे न ठहरे तब तो फ़िरौन के जीवन की शपथ तुम निश्चय ही भेदिए समझे जाओगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","तब उसने उनको तीन दिन तक बन्दीगृह में रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तीसरे दिन यूसुफ ने उनसे कहा, “एक काम करो तब जीवित रहोगे; क्योंकि मैं परमेश्वर का भय मानता हूँ; ");
INSERT INTO hin2017_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","यदि तुम सीधे मनुष्य हो, तो तुम सब भाइयों में से एक जन इस बन्दीगृह में बँधुआ रहे; और तुम अपने घरवालों की भूख मिटाने के लिये अन्न ले जाओ। ");
INSERT INTO hin2017_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","और अपने छोटे भाई को मेरे पास ले आओ; इस प्रकार तुम्हारी बातें सच्ची ठहरेंगी, और तुम मार डाले न जाओगे।” तब उन्होंने वैसा ही किया। ");
INSERT INTO hin2017_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","उन्होंने आपस में कहा, “निःसन्देह हम अपने भाई के विषय में दोषी हैं, क्योंकि जब उसने हम से गिड़गिड़ाकर विनती की, तब भी हमने यह देखकर, कि उसका जीवन कैसे संकट में पड़ा है, उसकी न सुनी; इसी कारण हम भी अब इस संकट में पड़े हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","रूबेन ने उनसे कहा, “क्या मैंने तुम से न कहा था कि लड़के के अपराधी मत बनो? परन्तु तुम ने न सुना। देखो, अब उसके लहू का बदला लिया जाता है।” ");
INSERT INTO hin2017_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","यूसुफ की और उनकी बातचीत जो एक दुभाषिया के द्वारा होती थी; इससे उनको मालूम न हुआ कि वह उनकी बोली समझता है। ");
INSERT INTO hin2017_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","तब वह उनके पास से हटकर रोने लगा; फिर उनके पास लौटकर और उनसे बातचीत करके उनमें से शिमोन को छाँट निकाला और उनके सामने उसे बन्दी बना लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","तब यूसुफ ने आज्ञा दी, कि उनके बोरे अन्न से भरो और एक-एक जन के बोरे में उसके रुपये को भी रख दो, फिर उनको मार्ग के लिये भोजनवस्तु दो। अतः उनके साथ ऐसा ही किया गया। ");
INSERT INTO hin2017_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","तब वे अपना अन्न अपने गदहों पर लादकर वहाँ से चल दिए। ");
INSERT INTO hin2017_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","सराय में जब एक ने अपने गदहे को चारा देने के लिये अपना बोरा खोला, तब उसका रुपया बोरे के मुँह पर रखा हुआ दिखलाई पड़ा। ");
INSERT INTO hin2017_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","तब उसने अपने भाइयों से कहा, “मेरा रुपया तो लौटा दिया गया है, देखो, वह मेरे बोरे में है,” तब उनके जी में जी न रहा, और वे एक दूसरे की ओर भय से ताकने लगे, और बोले, “परमेश्वर ने यह हम से क्या किया है?” ");
INSERT INTO hin2017_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","तब वे कनान देश में अपने पिता याकूब के पास आए, और अपना सारा वृत्तान्त उसे इस प्रकार वर्णन किया: ");
INSERT INTO hin2017_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“जो पुरुष उस देश का स्वामी है, उसने हम से कठोरता के साथ बातें की, और हमको देश के भेदिए कहा। ");
INSERT INTO hin2017_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","तब हमने उससे कहा, ‘हम सीधे लोग हैं, भेदिए नहीं। ");
INSERT INTO hin2017_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","हम बारह भाई एक ही पिता के पुत्र हैं, एक तो जाता रहा, परन्तु छोटा इस समय कनान देश में हमारे पिता के पास है।’ ");
INSERT INTO hin2017_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","तब उस पुरुष ने, जो उस देश का स्वामी है, हम से कहा, ‘इससे मालूम हो जाएगा कि तुम सीधे मनुष्य हो; तुम अपने में से एक को मेरे पास छोड़कर अपने घरवालों की भूख मिटाने के लिये कुछ ले जाओ, ");
INSERT INTO hin2017_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","और अपने छोटे भाई को मेरे पास ले आओ। तब मुझे विश्वास हो जाएगा कि तुम भेदिए नहीं, सीधे लोग हो। फिर मैं तुम्हारे भाई को तुम्हें सौंप दूँगा, और तुम इस देश में लेन-देन कर सकोगे।’” ");
INSERT INTO hin2017_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","यह कहकर वे अपने-अपने बोरे से अन्न निकालने लगे, तब, क्या देखा, कि एक-एक जन के रुपये की थैली उसी के बोरे में रखी है। तब रुपये की थैलियों को देखकर वे और उनका पिता बहुत डर गए। ");
INSERT INTO hin2017_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","तब उनके पिता याकूब ने उनसे कहा, “मुझ को तुम ने निर्वंश कर दिया, देखो, यूसुफ नहीं रहा, और शिमोन भी नहीं आया, और अब तुम बिन्यामीन को भी ले जाना चाहते हो। ये सब विपत्तियाँ मेरे ऊपर आ पड़ी हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","रूबेन ने अपने पिता से कहा, “यदि मैं उसको तेरे पास न लाऊँ, तो मेरे दोनों पुत्रों को मार डालना; तू उसको मेरे हाथ में सौंप दे, मैं उसे तेरे पास फिर पहुँचा दूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","उसने कहा, “मेरा पुत्र तुम्हारे संग न जाएगा; क्योंकि उसका भाई मर गया है, और वह अब अकेला रह गया है: इसलिए जिस मार्ग से तुम जाओगे, उसमें यदि उस पर कोई विपत्ति आ पड़े, तब तो तुम्हारे कारण मैं इस बुढ़ापे की अवस्था में शोक के साथ अधोलोक में उतर जाऊँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","कनान देश में अकाल और भी भयंकर होता गया। ");
INSERT INTO hin2017_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","जब वह अन्न जो वे मिस्र से ले आए थे, समाप्त हो गया तब उनके पिता ने उनसे कहा, “फिर जाकर हमारे लिये थोड़ी सी भोजनवस्तु मोल ले आओ।” ");
INSERT INTO hin2017_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","तब यहूदा ने उससे कहा, “उस पुरुष ने हमको चेतावनी देकर कहा, ‘यदि तुम्हारा भाई तुम्हारे संग न आए, तो तुम मेरे सम्मुख न आने पाओगे।’ ");
INSERT INTO hin2017_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","इसलिए यदि तू हमारे भाई को हमारे संग भेजे, तब तो हम जाकर तेरे लिये भोजनवस्तु मोल ले आएँगे; ");
INSERT INTO hin2017_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","परन्तु यदि तू उसको न भेजे, तो हम न जाएँगे, क्योंकि उस पुरुष ने हम से कहा, ‘यदि तुम्हारा भाई तुम्हारे संग न हो, तो तुम मेरे सम्मुख न आने पाओगे।’” ");
INSERT INTO hin2017_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","तब इस्राएल ने कहा, “तुम ने उस पुरुष को यह बताकर कि हमारा एक और भाई है, क्यों मुझसे बुरा बर्ताव किया?” ");
INSERT INTO hin2017_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","उन्होंने कहा, “जब उस पुरुष ने हमारी और हमारे कुटुम्बियों की स्थिति के विषय में इस रीति पूछा, ‘क्या तुम्हारा पिता अब तक जीवित है? क्या तुम्हारे कोई और भाई भी है?’ तब हमने इन प्रश्नों के अनुसार उससे वर्णन किया; फिर हम क्या जानते थे कि वह कहेगा, ‘अपने भाई को यहाँ ले आओ।’” ");
INSERT INTO hin2017_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","फिर यहूदा ने अपने पिता इस्राएल से कहा, “उस लड़के को मेरे संग भेज दे, कि हम चले जाएँ; इससे हम, और तू, और हमारे बाल-बच्चे मरने न पाएँगे, वरन् जीवित रहेंगे। ");
INSERT INTO hin2017_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","मैं उसका जामिन होता हूँ; मेरे ही हाथ से तू उसको वापस लेना। यदि मैं उसको तेरे पास पहुँचाकर सामने न खड़ा कर दूँ, तब तो मैं सदा के लिये तेरा अपराधी ठहरूँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","यदि हम लोग विलम्ब न करते, तो अब तक दूसरी बार लौट आते।” ");
INSERT INTO hin2017_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","तब उनके पिता इस्राएल ने उनसे कहा, “यदि सचमुच ऐसी ही बात है, तो यह करो; इस देश की उत्तम-उत्तम वस्तुओं में से कुछ कुछ अपने बोरों में उस पुरुष के लिये भेंट ले जाओ: जैसे थोड़ा सा बलसान, और थोड़ा सा मधु, और कुछ सुगन्ध-द्रव्य, और गन्धरस, पिस्ते, और बादाम। ");
INSERT INTO hin2017_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","फिर अपने-अपने साथ दूना रुपया ले जाओ; और जो रुपया तुम्हारे बोरों के मुँह पर रखकर लौटा दिया गया था, उसको भी लेते जाओ; कदाचित् यह भूल से हुआ हो। ");
INSERT INTO hin2017_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","अपने भाई को भी संग लेकर उस पुरुष के पास फिर जाओ, ");
INSERT INTO hin2017_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","और सर्वशक्तिमान परमेश्वर उस पुरुष को तुम पर दयालु करेगा, जिससे कि वह तुम्हारे दूसरे भाई को और बिन्यामीन को भी आने दे: और यदि मैं निर्वंश हुआ तो होने दो।” ");
INSERT INTO hin2017_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","तब उन मनुष्यों ने वह भेंट, और दूना रुपया, और बिन्यामीन को भी संग लिया, और चल दिए और मिस्र में पहुँचकर यूसुफ के सामने खड़े हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","उनके साथ बिन्यामीन को देखकर यूसुफ ने अपने घर के अधिकारी से कहा, “उन मनुष्यों को घर में पहुँचा दो, और पशु मारकर भोजन तैयार करो; क्योंकि वे लोग दोपहर को मेरे संग भोजन करेंगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","तब वह अधिकारी पुरुष यूसुफ के कहने के अनुसार उन पुरुषों को यूसुफ के घर में ले गया। ");
INSERT INTO hin2017_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","जब वे यूसुफ के घर को पहुँचाए गए तब वे आपस में डरकर कहने लगे, “जो रुपया पहली बार हमारे बोरों में लौटा दिया गया था, उसी के कारण हम भीतर पहुँचाए गए हैं; जिससे कि वह पुरुष हम पर टूट पड़े, और हमें वश में करके अपने दास बनाए, और हमारे गदहों को भी छीन ले।” ");
INSERT INTO hin2017_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","तब वे यूसुफ के घर के अधिकारी के निकट जाकर घर के द्वार पर इस प्रकार कहने लगे, ");
INSERT INTO hin2017_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“हे हमारे प्रभु, जब हम पहली बार अन्न मोल लेने को आए थे, ");
INSERT INTO hin2017_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","तब हमने सराय में पहुँचकर अपने बोरों को खोला, तो क्या देखा, कि एक-एक जन का पूरा-पूरा रुपया उसके बोरे के मुँह पर रखा है; इसलिए हम उसको अपने साथ फिर लेते आए हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","और दूसरा रुपया भी भोजनवस्तु मोल लेने के लिये लाए हैं; हम नहीं जानते कि हमारा रुपया हमारे बोरों में किसने रख दिया था।” ");
INSERT INTO hin2017_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","उसने कहा, “तुम्हारा कुशल हो, मत डरो: तुम्हारा परमेश्वर, जो तुम्हारे पिता का भी परमेश्वर है, उसी ने तुम को तुम्हारे बोरों में धन दिया होगा, तुम्हारा रुपया तो मुझ को मिल गया था।” फिर उसने शिमोन को निकालकर उनके संग कर दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","तब उस जन ने उन मनुष्यों को यूसुफ के घर में ले जाकर जल दिया, तब उन्होंने अपने पाँवों को धोया; फिर उसने उनके गदहों के लिये चारा दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","तब यह सुनकर, कि आज हमको यहीं भोजन करना होगा, उन्होंने यूसुफ के आने के समय तक, अर्थात् दोपहर तक, उस भेंट को इकट्ठा कर रखा। ");
INSERT INTO hin2017_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","जब यूसुफ घर आया तब वे उस भेंट को, जो उनके हाथ में थी, उसके सम्मुख घर में ले गए, और भूमि पर गिरकर उसको दण्डवत् किया। ");
INSERT INTO hin2017_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","उसने उनका कुशल पूछा और कहा, “क्या तुम्हारा बूढ़ा पिता, जिसकी तुम ने चर्चा की थी, कुशल से है? क्या वह अब तक जीवित है?” ");
INSERT INTO hin2017_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","उन्होंने कहा, “हाँ तेरा दास हमारा पिता कुशल से है और अब तक जीवित है।” तब उन्होंने सिर झुकाकर फिर दण्डवत् किया। ");
INSERT INTO hin2017_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","तब उसने आँखें उठाकर और अपने सगे भाई बिन्यामीन को देखकर पूछा, “क्या तुम्हारा वह छोटा भाई, जिसकी चर्चा तुम ने मुझसे की थी, यही है?” फिर उसने कहा, “हे मेरे पुत्र, परमेश्वर तुझ पर अनुग्रह करे।” ");
INSERT INTO hin2017_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","तब अपने भाई के स्नेह से मन भर आने के कारण और यह सोचकर कि मैं कहाँ जाकर रोऊँ, यूसुफ तुरन्त अपनी कोठरी में गया, और वहाँ रो पड़ा। ");
INSERT INTO hin2017_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","फिर अपना मुँह धोकर निकल आया, और अपने को शान्त कर कहा, “भोजन परोसो।” ");
INSERT INTO hin2017_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","तब उन्होंने उसके लिये तो अलग, और भाइयों के लिये भी अलग, और जो मिस्री उसके संग खाते थे, उनके लिये भी अलग, भोजन परोसा; इसलिए कि मिस्री इब्रियों के साथ भोजन नहीं कर सकते, वरन् मिस्री ऐसा करना घृणित समझते थे। ");
INSERT INTO hin2017_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","सो यूसुफ के भाई उसके सामने, बड़े-बड़े पहले, और छोटे-छोटे पीछे, अपनी-अपनी अवस्था के अनुसार, क्रम से बैठाए गए; यह देख वे विस्मित होकर एक दूसरे की ओर देखने लगे। ");
INSERT INTO hin2017_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","तब यूसुफ अपने सामने से भोजन-वस्तुएँ उठा-उठाकर उनके पास भेजने लगा, और बिन्यामीन को अपने भाइयों से पाँचगुना भोजनवस्तु मिली। और उन्होंने उसके संग मनमाना खाया पिया। ");
INSERT INTO hin2017_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","तब उसने अपने घर के अधिकारी को आज्ञा दी, “इन मनुष्यों के बोरों में जितनी भोजनवस्तु समा सके उतनी भर दे, और एक-एक जन के रुपये को उसके बोरे के मुँह पर रख दे। ");
INSERT INTO hin2017_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","और मेरा चाँदी का कटोरा छोटे भाई के बोरे के मुँह पर उसके अन्न के रुपये के साथ रख दे।” यूसुफ की इस आज्ञा के अनुसार उसने किया। ");
INSERT INTO hin2017_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","सवेरे भोर होते ही वे मनुष्य अपने गदहों समेत विदा किए गए। ");
INSERT INTO hin2017_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","वे नगर से निकले ही थे, और दूर न जाने पाए थे कि यूसुफ ने अपने घर के अधिकारी से कहा, “उन मनुष्यों का पीछा कर, और उनको पाकर उनसे कह, ‘तुम ने भलाई के बदले बुराई क्यों की है? ");
INSERT INTO hin2017_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","क्या यह वह वस्तु नहीं जिसमें मेरा स्वामी पीता है, और जिससे वह शकुन भी विचारा करता है? तुम ने यह जो किया है सो बुरा किया।’” ");
INSERT INTO hin2017_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","तब उसने उन्हें जा पकड़ा, और ऐसी ही बातें उनसे कहीं। ");
INSERT INTO hin2017_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","उन्होंने उससे कहा, “हे हमारे प्रभु, तू ऐसी बातें क्यों कहता है? ऐसा काम करना तेरे दासों से दूर रहे। ");
INSERT INTO hin2017_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","देख जो रुपया हमारे बोरों के मुँह पर निकला था, जब हमने उसको कनान देश से ले आकर तुझे लौटा दिया, तब भला, तेरे स्वामी के घर में से हम कोई चाँदी या सोने की वस्तु कैसे चुरा सकते हैं? ");
INSERT INTO hin2017_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","तेरे दासों में से जिस किसी के पास वह निकले, वह मार डाला जाए, और हम भी अपने उस प्रभु के दास हो जाएँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","उसने कहा, “तुम्हारा ही कहना सही, जिसके पास वह निकले वह मेरा दास होगा; और तुम लोग निर्दोष ठहरोगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","इस पर वे जल्दी से अपने-अपने बोरे को उतार भूमि पर रखकर उन्हें खोलने लगे। ");
INSERT INTO hin2017_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","तब वह ढूँढ़ने लगा, और बडे़ के बोरे से लेकर छोटे के बोरे तक खोज की: और कटोरा बिन्यामीन के बोरे में मिला। ");
INSERT INTO hin2017_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","तब उन्होंने अपने-अपने वस्त्र फाड़े, और अपना-अपना गदहा लादकर नगर को लौट गए। ");
INSERT INTO hin2017_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","जब यहूदा और उसके भाई यूसुफ के घर पर पहुँचे, और यूसुफ वहीं था, तब वे उसके सामने भूमि पर गिरे। ");
INSERT INTO hin2017_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","यूसुफ ने उनसे कहा, “तुम लोगों ने यह कैसा काम किया है? क्या तुम न जानते थे कि मुझ सा मनुष्य शकुन विचार सकता है?” ");
INSERT INTO hin2017_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहूदा ने कहा, “हम लोग अपने प्रभु से क्या कहें? हम क्या कहकर अपने को निर्दोष ठहराएँ? परमेश्वर ने तेरे दासों के अधर्म को पकड़ लिया है। हम, और जिसके पास कटोरा निकला वह भी, हम सब के सब अपने प्रभु के दास ही हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","उसने कहा, “ऐसा करना मुझसे दूर रहे, जिस जन के पास कटोरा निकला है, वही मेरा दास होगा; और तुम लोग अपने पिता के पास कुशल क्षेम से चले जाओ।” ");
INSERT INTO hin2017_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","तब यहूदा उसके पास जाकर कहने लगा, “हे मेरे प्रभु, तेरे दास को अपने प्रभु से एक बात कहने की आज्ञा हो, और तेरा कोप तेरे दास पर न भड़के; क्योंकि तू तो फ़िरौन के तुल्य है। ");
INSERT INTO hin2017_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","मेरे प्रभु ने अपने दासों से पूछा था, ‘क्या तुम्हारे पिता या भाई हैं?’ ");
INSERT INTO hin2017_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","और हमने अपने प्रभु से कहा, ‘हाँ, हमारा बूढ़ा पिता है, और उसके बुढ़ापे का एक छोटा सा बालक भी है, परन्तु उसका भाई मर गया है, इसलिए वह अब अपनी माता का अकेला ही रह गया है, और उसका पिता उससे स्नेह रखता है।’ ");
INSERT INTO hin2017_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","तब तूने अपने दासों से कहा था, ‘उसको मेरे पास ले आओ, जिससे मैं उसको देखूँ।’ ");
INSERT INTO hin2017_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","तब हमने अपने प्रभु से कहा था, ‘वह लड़का अपने पिता को नहीं छोड़ सकता; नहीं तो उसका पिता मर जाएगा।’ ");
INSERT INTO hin2017_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","और तूने अपने दासों से कहा, ‘यदि तुम्हारा छोटा भाई तुम्हारे संग न आए, तो तुम मेरे सम्मुख फिर न आने पाओगे।’ ");
INSERT INTO hin2017_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","इसलिए जब हम अपने पिता तेरे दास के पास गए, तब हमने उससे अपने प्रभु की बातें कहीं। ");
INSERT INTO hin2017_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","तब हमारे पिता ने कहा, ‘फिर जाकर हमारे लिये थोड़ी सी भोजनवस्तु मोल ले आओ।’ ");
INSERT INTO hin2017_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","हमने कहा, ‘हम नहीं जा सकते, हाँ, यदि हमारा छोटा भाई हमारे संग रहे, तब हम जाएँगे; क्योंकि यदि हमारा छोटा भाई हमारे संग न रहे, तो हम उस पुरुष के सम्मुख न जाने पाएँगे।’ ");
INSERT INTO hin2017_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","तब तेरे दास मेरे पिता ने हम से कहा, ‘तुम तो जानते हो कि मेरी स्त्री से दो पुत्र उत्पन्न हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","और उनमें से एक तो मुझे छोड़ ही गया, और मैंने निश्चय कर लिया, कि वह फाड़ डाला गया होगा; और तब से मैं उसका मुँह न देख पाया। ");
INSERT INTO hin2017_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","अतः यदि तुम इसको भी मेरी आँख की आड़ में ले जाओ, और कोई विपत्ति इस पर पड़े, तो तुम्हारे कारण मैं इस बुढ़ापे की अवस्था में शोक के साथ अधोलोक में उतर जाऊँगा।’ ");
INSERT INTO hin2017_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","इसलिए जब मैं अपने पिता तेरे दास के पास पहुँचूँ, और यह लड़का संग न रहे, तब, उसका प्राण जो इसी पर अटका रहता है, ");
INSERT INTO hin2017_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","इस कारण, यह देखकर कि लड़का नहीं है, वह तुरन्त ही मर जाएगा। तब तेरे दासों के कारण तेरा दास हमारा पिता, जो बुढ़ापे की अवस्था में है, शोक के साथ अधोलोक में उतर जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","फिर तेरा दास अपने पिता के यहाँ यह कहकर इस लड़के का जामिन हुआ है, ‘यदि मैं इसको तेरे पास न पहुँचा दूँ, तब तो मैं सदा के लिये तेरा अपराधी ठहरूँगा।’ ");
INSERT INTO hin2017_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","इसलिए अब तेरा दास इस लड़के के बदले अपने प्रभु का दास होकर रहने की आज्ञा पाए, और यह लड़का अपने भाइयों के संग जाने दिया जाए। ");
INSERT INTO hin2017_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","क्योंकि लड़के के बिना संग रहे मैं कैसे अपने पिता के पास जा सकूँगा; ऐसा न हो कि मेरे पिता पर जो दुःख पड़ेगा वह मुझे देखना पड़े।” ");
INSERT INTO hin2017_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","तब यूसुफ उन सब के सामने, जो उसके आस-पास खड़े थे, अपने को और रोक न सका; और पुकारकर कहा, “मेरे आस-पास से सब लोगों को बाहर कर दो।” भाइयों के सामने अपने को प्रगट करने के समय यूसुफ के संग और कोई न रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","तब वह चिल्ला चिल्लाकर रोने लगा; और मिस्रियों ने सुना, और फ़िरौन के घर के लोगों को भी इसका समाचार मिला। ");
INSERT INTO hin2017_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","तब यूसुफ अपने भाइयों से कहने लगा, “मैं यूसुफ हूँ, क्या मेरा पिता अब तक जीवित है?” इसका उत्तर उसके भाई न दे सके; क्योंकि वे उसके सामने घबरा गए थे। ");
INSERT INTO hin2017_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","फिर यूसुफ ने अपने भाइयों से कहा, “मेरे निकट आओ।” यह सुनकर वे निकट गए। फिर उसने कहा, “मैं तुम्हारा भाई यूसुफ हूँ, जिसको तुम ने मिस्र आनेवालों के हाथ बेच डाला था। (प्रेरि. 7:9) ");
INSERT INTO hin2017_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","अब तुम लोग मत पछताओ, और तुम ने जो मुझे यहाँ बेच डाला, इससे उदास मत हो; क्योंकि परमेश्वर ने तुम्हारे प्राणों को बचाने के लिये मुझे तुम्हारे आगे भेज दिया है। (प्रेरि. 7:15) ");
INSERT INTO hin2017_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","क्योंकि अब दो वर्ष से इस देश में अकाल है; और अब पाँच वर्ष और ऐसे ही होंगे कि उनमें न तो हल चलेगा और न अन्न काटा जाएगा। (प्रेरि. 7:15) ");
INSERT INTO hin2017_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","इसलिए परमेश्वर ने मुझे तुम्हारे आगे इसलिए भेजा कि तुम पृथ्वी पर जीवित रहो, और तुम्हारे प्राणों के बचने से तुम्हारा वंश बढ़े। ");
INSERT INTO hin2017_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","इस रीति अब मुझ को यहाँ पर भेजनेवाले तुम नहीं, परमेश्वर ही ठहरा; और उसी ने मुझे फ़िरौन का पिता सा, और उसके सारे घर का स्वामी, और सारे मिस्र देश का प्रभु ठहरा दिया है। ");
INSERT INTO hin2017_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","अतः शीघ्र मेरे पिता के पास जाकर कहो, ‘तेरा पुत्र यूसुफ इस प्रकार कहता है, कि परमेश्वर ने मुझे सारे मिस्र का स्वामी ठहराया है; इसलिए तू मेरे पास बिना विलम्ब किए चला आ। (प्रेरि. 7:14) ");
INSERT INTO hin2017_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","और तेरा निवास गोशेन देश में होगा, और तू, बेटे, पोतों, भेड़-बकरियों, गाय-बैलों, और अपने सब कुछ समेत मेरे निकट रहेगा। ");
INSERT INTO hin2017_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","और अकाल के जो पाँच वर्ष और होंगे, उनमें मैं वहीं तेरा पालन-पोषण करूँगा; ऐसा न हो कि तू, और तेरा घराना, वरन् जितने तेरे हैं, वे भूखे मरें।’ (प्रेरि. 7:14) ");
INSERT INTO hin2017_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","और तुम अपनी आँखों से देखते हो, और मेरा भाई बिन्यामीन भी अपनी आँखों से देखता है कि जो हम से बातें कर रहा है वह यूसुफ है। ");
INSERT INTO hin2017_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","तुम मेरे सब वैभव का, जो मिस्र में है और जो कुछ तुम ने देखा है, उस सब का मेरे पिता से वर्णन करना; और तुरन्त मेरे पिता को यहाँ ले आना।” ");
INSERT INTO hin2017_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","और वह अपने भाई बिन्यामीन के गले से लिपटकर रोया; और बिन्यामीन भी उसके गले से लिपटकर रोया। ");
INSERT INTO hin2017_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","वह अपने सब भाइयों को चूमकर रोया और इसके पश्चात् उसके भाई उससे बातें करने लगे। ");
INSERT INTO hin2017_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","इस बात का समाचार कि यूसुफ के भाई आए हैं, फ़िरौन के भवन तक पहुँच गया, और इससे फ़िरौन और उसके कर्मचारी प्रसन्न हुए। (प्रेरि. 7:13) ");
INSERT INTO hin2017_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","इसलिए फ़िरौन ने यूसुफ से कहा, “अपने भाइयों से कह कि एक काम करो: अपने पशुओं को लादकर कनान देश में चले जाओ। ");
INSERT INTO hin2017_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","और अपने पिता और अपने-अपने घर के लोगों को लेकर मेरे पास आओ; और मिस्र देश में जो कुछ अच्छे से अच्छा है वह मैं तुम्हें दूँगा, और तुम्हें देश के उत्तम से उत्तम पदार्थ खाने को मिलेंगे। (प्रेरि. 7:14) ");
INSERT INTO hin2017_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","और तुझे आज्ञा मिली है, ‘तुम एक काम करो कि मिस्र देश से अपने बाल-बच्चों और स्त्रियों के लिये गाड़ियाँ ले जाओ, और अपने पिता को ले आओ। (प्रेरि. 7:14) ");
INSERT INTO hin2017_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","और अपनी सामग्री की चिन्ता न करना; क्योंकि सारे मिस्र देश में जो कुछ अच्छे से अच्छा है वह तुम्हारा है।’” ");
INSERT INTO hin2017_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","इस्राएल के पुत्रों ने वैसा ही किया; और यूसुफ ने फ़िरौन की आज्ञा के अनुसार उन्हें गाड़ियाँ दीं, और मार्ग के लिये भोजन-सामग्री भी दी। ");
INSERT INTO hin2017_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","उनमें से एक-एक जन को तो उसने एक-एक जोड़ा वस्त्र भी दिया; और बिन्यामीन को तीन सौ रूपे के टुकड़े और पाँच जोड़े वस्त्र दिए। ");
INSERT INTO hin2017_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","अपने पिता के पास उसने जो भेजा वह यह है, अर्थात् मिस्र की अच्छी वस्तुओं से लदे हुए दस गदहे, और अन्न और रोटी और उसके पिता के मार्ग के लिये भोजनवस्तु से लदी हुई दस गदहियाँ। ");
INSERT INTO hin2017_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","तब उसने अपने भाइयों को विदा किया, और वे चल दिए; और उसने उनसे कहा, “मार्ग में कहीं झगड़ा न करना।” ");
INSERT INTO hin2017_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","मिस्र से चलकर वे कनान देश में अपने पिता याकूब के पास पहुँचे। ");
INSERT INTO hin2017_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","और उससे यह वर्णन किया, “यूसुफ अब तक जीवित है, और सारे मिस्र देश पर प्रभुता वही करता है।” पर उसने उन पर विश्वास न किया, और वह अपने आपे में न रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","तब उन्होंने अपने पिता याकूब से यूसुफ की सारी बातें, जो उसने उनसे कहीं थीं, कह दीं; जब उसने उन गाड़ियों को देखा, जो यूसुफ ने उसके ले आने के लिये भेजी थीं, तब उसका चित्त स्थिर हो गया। ");
INSERT INTO hin2017_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","और इस्राएल ने कहा, “बस, मेरा पुत्र यूसुफ अब तक जीवित है; मैं अपनी मृत्यु से पहले जाकर उसको देखूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","तब इस्राएल अपना सब कुछ लेकर बेर्शेबा को गया, और वहाँ अपने पिता इसहाक के परमेश्वर को बलिदान चढ़ाया। ");
INSERT INTO hin2017_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","तब परमेश्वर ने इस्राएल से रात को दर्शन में कहा, “हे याकूब हे याकूब।” उसने कहा, “क्या आज्ञा।” ");
INSERT INTO hin2017_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","उसने कहा, “मैं परमेश्वर तेरे पिता का परमेश्वर हूँ, तू मिस्र में जाने से मत डर; क्योंकि मैं तुझ से वहाँ एक बड़ी जाति बनाऊँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","मैं तेरे संग-संग मिस्र को चलता हूँ; और मैं तुझे वहाँ से फिर निश्चय ले आऊँगा; और यूसुफ अपने हाथ से तेरी आँखों को बन्द करेगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","तब याकूब बेर्शेबा से चला; और इस्राएल के पुत्र अपने पिता याकूब, और अपने बाल-बच्चों, और स्त्रियों को उन गाड़ियों पर, जो फ़िरौन ने उनके ले आने को भेजी थीं, चढ़ाकर चल पड़े। ");
INSERT INTO hin2017_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","वे अपनी भेड़-बकरी, गाय-बैल, और कनान देश में अपने इकट्ठा किए हुए सारे धन को लेकर मिस्र में आए। ");
INSERT INTO hin2017_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","और याकूब अपने बेटे-बेटियों, पोते-पोतियों, अर्थात् अपने वंश भर को अपने संग मिस्र में ले आया। ");
INSERT INTO hin2017_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","याकूब के साथ जो इस्राएली, अर्थात् उसके बेटे, पोते, आदि मिस्र में आए, उनके नाम ये हैं याकूब का जेठा रूबेन था। ");
INSERT INTO hin2017_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","और रूबेन के पुत्र हनोक, पल्लू, हेस्रोन, और कर्मी थे। ");
INSERT INTO hin2017_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमोन के पुत्र, यमूएल, यामीन, ओहद, याकीन, सोहर, और एक कनानी स्त्री से जन्मा हुआ शाऊल भी था। ");
INSERT INTO hin2017_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवी के पुत्र गेर्शोन, कहात, और मरारी थे। ");
INSERT INTO hin2017_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदा के एर, ओनान, शेला, पेरेस, और जेरह नामक पुत्र हुए तो थे; पर एर और ओनान कनान देश में मर गए थे; और पेरेस के पुत्र, हेस्रोन और हामूल थे। ");
INSERT INTO hin2017_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्साकार के पुत्र, तोला, पुब्बा, योब और शिम्रोन थे। ");
INSERT INTO hin2017_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबूलून के पुत्र, सेरेद, एलोन, और यहलेल थे। ");
INSERT INTO hin2017_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","लिआ के पुत्र जो याकूब से पद्दनराम में उत्पन्न हुए थे, उनके बेटे पोते ये ही थे, और इनसे अधिक उसने उसके साथ एक बेटी दीना को भी जन्म दिया। यहाँ तक तो याकूब के सब वंशवाले तैंतीस प्राणी हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","फिर गाद के पुत्र, सपोन, हाग्गी, शूनी, एसबोन, एरी, अरोदी, और अरेली थे। ");
INSERT INTO hin2017_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशेर के पुत्र, यिम्ना, यिश्वा, यिश्वी, और बरीआ थे, और उनकी बहन सेरह थी; और बरीआ के पुत्र, हेबेर और मल्कीएल थे। ");
INSERT INTO hin2017_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","जिल्पा, जिसे लाबान ने अपनी बेटी लिआ को दिया था, उसके बेटे पोते आदि ये ही थे; और उसके द्वारा याकूब के सोलह प्राणी उत्पन्न हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","फिर याकूब की पत्नी राहेल के पुत्र यूसुफ और बिन्यामीन थे। ");
INSERT INTO hin2017_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","और मिस्र देश में ओन के याजक पोतीपेरा की बेटी आसनत से यूसुफ के ये पुत्र उत्पन्न हुए, अर्थात् मनश्शे और एप्रैम। ");
INSERT INTO hin2017_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बिन्यामीन के पुत्र, बेला, बेकेर, अश्बेल, गेरा, नामान, एही, रोश, मुप्पीम, हुप्पीम, और अर्द थे। ");
INSERT INTO hin2017_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","राहेल के पुत्र जो याकूब से उत्पन्न हुए उनके ये ही पुत्र थे; उसके ये सब बेटे-पोते चौदह प्राणी हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","फिर दान का पुत्र हूशीम था। ");
INSERT INTO hin2017_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नप्ताली के पुत्र, यहसेल, गूनी, येसेर, और शिल्लेम थे। ");
INSERT INTO hin2017_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","बिल्हा, जिसे लाबान ने अपनी बेटी राहेल को दिया, उसके बेटे पोते ये ही हैं; उसके द्वारा याकूब के वंश में सात प्राणी हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","याकूब के निज वंश के जो प्राणी मिस्र में आए, वे उसकी बहुओं को छोड़ सब मिलकर छियासठ प्राणी हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","और यूसुफ के पुत्र, जो मिस्र में उससे उत्पन्न हुए, वे दो प्राणी थे; इस प्रकार याकूब के घराने के जो प्राणी मिस्र में आए सो सब मिलकर सत्तर हुए। ");
INSERT INTO hin2017_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","फिर उसने यहूदा को अपने आगे यूसुफ के पास भेज दिया कि वह उसको गोशेन का मार्ग दिखाए; और वे गोशेन देश में आए। ");
INSERT INTO hin2017_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","तब यूसुफ अपना रथ जुतवाकर अपने पिता इस्राएल से भेंट करने के लिये गोशेन देश को गया, और उससे भेंट करके उसके गले से लिपटा, और कुछ देर तक उसके गले से लिपटा हुआ रोता रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","तब इस्राएल ने यूसुफ से कहा, “मैं अब मरने से भी प्रसन्न हूँ, क्योंकि तुझे जीवित पाया और तेरा मुँह देख लिया।” ");
INSERT INTO hin2017_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","तब यूसुफ ने अपने भाइयों से और अपने पिता के घराने से कहा, “मैं जाकर फ़िरौन को यह समाचार दूँगा, ‘मेरे भाई और मेरे पिता के सारे घराने के लोग, जो कनान देश में रहते थे, वे मेरे पास आ गए हैं; ");
INSERT INTO hin2017_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","और वे लोग चरवाहे हैं, क्योंकि वे पशुओं को पालते आए हैं; इसलिए वे अपनी भेड़-बकरी, गाय-बैल, और जो कुछ उनका है, सब ले आए हैं।’ ");
INSERT INTO hin2017_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","जब फ़िरौन तुम को बुलाकर पूछे, ‘तुम्हारा उद्यम क्या है?’ ");
INSERT INTO hin2017_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","तब यह कहना, ‘तेरे दास लड़कपन से लेकर आज तक पशुओं को पालते आए हैं, वरन् हमारे पुरखा भी ऐसा ही करते थे।’ इससे तुम गोशेन देश में रहने पाओगे; क्योंकि सब चरवाहों से मिस्री लोग घृणा करते हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","तब यूसुफ ने फ़िरौन के पास जाकर यह समाचार दिया, “मेरा पिता और मेरे भाई, और उनकी भेड़-बकरियाँ, गाय-बैल और जो कुछ उनका है, सब कनान देश से आ गया है; और अभी तो वे गोशेन देश में हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","फिर उसने अपने भाइयों में से पाँच जन लेकर फ़िरौन के सामने खड़े कर दिए। ");
INSERT INTO hin2017_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फ़िरौन ने उसके भाइयों से पूछा, “तुम्हारा उद्यम क्या है?” उन्होंने फ़िरौन से कहा, “तेरे दास चरवाहे हैं, और हमारे पुरखा भी ऐसे ही रहे।” ");
INSERT INTO hin2017_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","फिर उन्होंने फ़िरौन से कहा, “हम इस देश में परदेशी की भाँति रहने के लिये आए हैं; क्योंकि कनान देश में भारी अकाल होने के कारण तेरे दासों को भेड़-बकरियों के लिये चारा न रहा; इसलिए अपने दासों को गोशेन देश में रहने की आज्ञा दे।” ");
INSERT INTO hin2017_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","तब फ़िरौन ने यूसुफ से कहा, “तेरा पिता और तेरे भाई तेरे पास आ गए हैं, ");
INSERT INTO hin2017_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","और मिस्र देश तेरे सामने पड़ा है; इस देश का जो सबसे अच्छा भाग हो, उसमें अपने पिता और भाइयों को बसा दे; अर्थात् वे गोशेन देश में ही रहें; और यदि तू जानता हो, कि उनमें से परिश्रमी पुरुष हैं, तो उन्हें मेरे पशुओं के अधिकारी ठहरा दे।” ");
INSERT INTO hin2017_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","तब यूसुफ ने अपने पिता याकूब को ले आकर फ़िरौन के सम्मुख खड़ा किया; और याकूब ने फ़िरौन को आशीर्वाद दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","तब फ़िरौन ने याकूब से पूछा, “तेरी आयु कितने दिन की हुई है?” ");
INSERT INTO hin2017_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकूब ने फ़िरौन से कहा, “मैं तो एक सौ तीस वर्ष परदेशी होकर अपना जीवन बिता चुका हूँ; मेरे जीवन के दिन थोड़े और दुःख से भरे हुए भी थे, और मेरे बापदादे परदेशी होकर जितने दिन तक जीवित रहे उतने दिन का मैं अभी नहीं हुआ।” ");
INSERT INTO hin2017_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","और याकूब फ़िरौन को आशीर्वाद देकर उसके सम्मुख से चला गया। ");
INSERT INTO hin2017_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","तब यूसुफ ने अपने पिता और भाइयों को बसा दिया, और फ़िरौन की आज्ञा के अनुसार मिस्र देश के अच्छे से अच्छे भाग में, अर्थात् रामसेस नामक प्रदेश में, भूमि देकर उनको सौंप दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","और यूसुफ अपने पिता का, और अपने भाइयों का, और पिता के सारे घराने का, एक-एक के बाल-बच्चों की गिनती के अनुसार, भोजन दिला-दिलाकर उनका पालन-पोषण करने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","उस सारे देश में खाने को कुछ न रहा; क्योंकि अकाल बहुत भारी था, और अकाल के कारण मिस्र और कनान दोनों देश नाश हो गए। ");
INSERT INTO hin2017_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","और जितना रुपया मिस्र और कनान देश में था, सब को यूसुफ ने उस अन्न के बदले, जो उनके निवासी मोल लेते थे इकट्ठा करके फ़िरौन के भवन में पहुँचा दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","जब मिस्र और कनान देश का रुपया समाप्त हो गया, तब सब मिस्री यूसुफ के पास आ आकर कहने लगे, “हमको भोजनवस्तु दे, क्या हम रुपये के न रहने से तेरे रहते हुए मर जाएँ?” ");
INSERT INTO hin2017_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","यूसुफ ने कहा, “यदि रुपये न हों तो अपने पशु दे दो, और मैं उनके बदले तुम्हें खाने को दूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","तब वे अपने पशु यूसुफ के पास ले आए; और यूसुफ उनको घोड़ों, भेड़-बकरियों, गाय-बैलों और गदहों के बदले खाने को देने लगा: उस वर्ष में वह सब जाति के पशुओं के बदले भोजन देकर उनका पालन-पोषण करता रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","वह वर्ष तो बीत गया; तब अगले वर्ष में उन्होंने उसके पास आकर कहा, “हम अपने प्रभु से यह बात छिपा न रखेंगे कि हमारा रुपया समाप्त हो गया है, और हमारे सब प्रकार के पशु हमारे प्रभु के पास आ चुके हैं; इसलिए अब हमारे प्रभु के सामने हमारे शरीर और भूमि छोड़कर और कुछ नहीं रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","हम तेरे देखते क्यों मरें, और हमारी भूमि क्यों उजड़ जाए? हमको और हमारी भूमि को भोजनवस्तु के बदले मोल ले, कि हम अपनी भूमि समेत फ़िरौन के दास हों और हमको बीज दे, कि हम मरने न पाएँ, वरन् जीवित रहें, और भूमि न उजड़े।” ");
INSERT INTO hin2017_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","तब यूसुफ ने मिस्र की सारी भूमि को फ़िरौन के लिये मोल लिया; क्योंकि उस भयंकर अकाल के पड़ने से मिस्रियों को अपना-अपना खेत बेच डालना पड़ा। इस प्रकार सारी भूमि फ़िरौन की हो गई। ");
INSERT INTO hin2017_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","और एक छोर से लेकर दूसरे छोर तक सारे मिस्र देश में जो प्रजा रहती थी, उसको उसने नगरों में लाकर बसा दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","पर याजकों की भूमि तो उसने न मोल ली; क्योंकि याजकों के लिये फ़िरौन की ओर से नित्य भोजन का बन्दोबस्त था, और नित्य जो भोजन फ़िरौन उनको देता था वही वे खाते थे; इस कारण उनको अपनी भूमि बेचनी न पड़ी। ");
INSERT INTO hin2017_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","तब यूसुफ ने प्रजा के लोगों से कहा, “सुनो, मैंने आज के दिन तुम को और तुम्हारी भूमि को भी फ़िरौन के लिये मोल लिया है; देखो, तुम्हारे लिये यहाँ बीज है, इसे भूमि में बोओ। ");
INSERT INTO hin2017_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","और जो कुछ उपजे उसका पंचमांश फ़िरौन को देना, बाकी चार अंश तुम्हारे रहेंगे कि तुम उसे अपने खेतों में बोओ, और अपने-अपने बाल-बच्चों और घर के अन्य लोगों समेत खाया करो।” ");
INSERT INTO hin2017_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","उन्होंने कहा, “तूने हमको बचा लिया है; हमारे प्रभु के अनुग्रह की दृष्टि हम पर बनी रहे, और हम फ़िरौन के दास होकर रहेंगे।” ");
INSERT INTO hin2017_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","इस प्रकार यूसुफ ने मिस्र की भूमि के विषय में ऐसा नियम ठहराया, जो आज के दिन तक चला आता है कि पंचमांश फ़िरौन को मिला करे; केवल याजकों ही की भूमि फ़िरौन की नहीं हुई। ");
INSERT INTO hin2017_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","इस्राएली मिस्र के गोशेन प्रदेश में रहने लगे; और वहाँ की भूमि उनके वश में थी, और वे फूले-फले, और अत्यन्त बढ़ गए। ");
INSERT INTO hin2017_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","मिस्र देश में याकूब सत्रह वर्ष जीवित रहा इस प्रकार याकूब की सारी आयु एक सौ सैंतालीस वर्ष की हुई। ");
INSERT INTO hin2017_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","जब इस्राएल के मरने का दिन निकट आ गया, तब उसने अपने पुत्र यूसुफ को बुलवाकर कहा, “यदि तेरा अनुग्रह मुझ पर हो, तो अपना हाथ मेरी जाँघ के तले रखकर शपथ खा, कि तू मेरे साथ कृपा और सच्चाई का यह काम करेगा, कि मुझे मिस्र में मिट्टी न देगा। ");
INSERT INTO hin2017_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","जब मैं अपने बापदादों के संग सो जाऊँगा, तब तू मुझे मिस्र से उठा ले जाकर उन्हीं के कब्रिस्तान में रखेगा।” तब यूसुफ ने कहा, “मैं तेरे वचन के अनुसार करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","फिर उसने कहा, “मुझसे शपथ खा।” अतः उसने उससे शपथ खाई। तब इस्राएल ने खाट के सिरहाने की ओर सिर झुकाकर प्रार्थना की। (इब्रा. 11:21) ");
INSERT INTO hin2017_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","इन बातों के पश्चात् किसी ने यूसुफ से कहा, “सुन, तेरा पिता बीमार है।” तब वह मनश्शे और एप्रैम नामक अपने दोनों पुत्रों को संग लेकर उसके पास चला। ");
INSERT INTO hin2017_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","किसी ने याकूब को बता दिया, “तेरा पुत्र यूसुफ तेरे पास आ रहा है,” तब इस्राएल अपने को सम्भालकर खाट पर बैठ गया। ");
INSERT INTO hin2017_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","और याकूब ने यूसुफ से कहा, “सर्वशक्तिमान परमेश्वर ने कनान देश के लूज नगर के पास मुझे दर्शन देकर आशीष दी, ");
INSERT INTO hin2017_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","और कहा, ‘सुन, मैं तुझे फलवन्त करके बढ़ाऊँगा, और तुझे राज्य-राज्य की मण्डली का मूल बनाऊँगा, और तेरे पश्चात् तेरे वंश को यह देश दूँगा, जिससे कि वह सदा तक उनकी निज भूमि बनी रहे।’ ");
INSERT INTO hin2017_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","और अब तेरे दोनों पुत्र, जो मिस्र में मेरे आने से पहले उत्पन्न हुए हैं, वे मेरे ही ठहरेंगे; अर्थात् जिस रीति से रूबेन और शिमोन मेरे हैं, उसी रीति से एप्रैम और मनश्शे भी मेरे ठहरेंगे। ");
INSERT INTO hin2017_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","और उनके पश्चात् तेरे जो सन्तान उत्पन्न हो, वह तेरे तो ठहरेंगे; परन्तु बँटवारे के समय वे अपने भाइयों ही के वंश में गिने जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","जब मैं पद्दान से आता था, तब एप्राता पहुँचने से थोड़ी ही दूर पहले राहेल कनान देश में, मार्ग में, मेरे सामने मर गई; और मैंने उसे वहीं, अर्थात् एप्राता जो बैतलहम भी कहलाता है, उसी के मार्ग में मिट्टी दी।” ");
INSERT INTO hin2017_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","तब इस्राएल को यूसुफ के पुत्र देख पड़े, और उसने पूछा, “ये कौन हैं?” ");
INSERT INTO hin2017_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","यूसुफ ने अपने पिता से कहा, “ये मेरे पुत्र हैं, जो परमेश्वर ने मुझे यहाँ दिए हैं।” उसने कहा, “उनको मेरे पास ले आ कि मैं उन्हें आशीर्वाद दूँ।” ");
INSERT INTO hin2017_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","इस्राएल की आँखें बुढ़ापे के कारण धुन्धली हो गई थीं, यहाँ तक कि उसे कम सूझता था। तब यूसुफ उन्हें उसके पास ले गया; और उसने उन्हें चूमकर गले लगा लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","तब इस्राएल ने यूसुफ से कहा, “मुझे आशा न थी, कि मैं तेरा मुख फिर देखने पाऊँगा: परन्तु देख, परमेश्वर ने मुझे तेरा वंश भी दिखाया है।” ");
INSERT INTO hin2017_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","तब यूसुफ ने उन्हें अपने पिता के घुटनों के बीच से हटाकर और अपने मुँह के बल भूमि पर गिरकर दण्डवत् की। ");
INSERT INTO hin2017_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","तब यूसुफ ने उन दोनों को लेकर, अर्थात् एप्रैम को अपने दाहिने हाथ से, कि वह इस्राएल के बाएँ हाथ पड़े, और मनश्शे को अपने बाएँ हाथ से, कि इस्राएल के दाहिने हाथ पड़े, उन्हें उसके पास ले गया। ");
INSERT INTO hin2017_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","तब इस्राएल ने अपना दाहिना हाथ बढ़ाकर एप्रैम के सिर पर जो छोटा था, और अपना बायाँ हाथ बढ़ाकर मनश्शे के सिर पर रख दिया; उसने तो जान बूझकर ऐसा किया; नहीं तो जेठा मनश्शे ही था। ");
INSERT INTO hin2017_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","फिर उसने यूसुफ को आशीर्वाद देकर कहा, “परमेश्वर जिसके सम्मुख मेरे बापदादे अब्राहम और इसहाक चलते थे वही परमेश्वर मेरे जन्म से लेकर आज के दिन तक मेरा चरवाहा बना है; (इब्रा. 11:21) ");
INSERT INTO hin2017_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","और वही दूत मुझे सारी बुराई से छुड़ाता आया है, वही अब इन लड़कों को आशीष दे; और ये मेरे और मेरे बापदादे अब्राहम और इसहाक के कहलाएँ; और पृथ्वी में बहुतायत से बढ़ें।” (इब्रा. 11:21) ");
INSERT INTO hin2017_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","जब यूसुफ ने देखा कि मेरे पिता ने अपना दाहिना हाथ एप्रैम के सिर पर रखा है, तब यह बात उसको बुरी लगी; इसलिए उसने अपने पिता का हाथ इस मनसा से पकड़ लिया, कि एप्रैम के सिर पर से उठाकर मनश्शे के सिर पर रख दे। ");
INSERT INTO hin2017_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","और यूसुफ ने अपने पिता से कहा, “हे पिता, ऐसा नहीं; क्योंकि जेठा यही है; अपना दाहिना हाथ इसके सिर पर रख।” ");
INSERT INTO hin2017_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","उसके पिता ने कहा, “नहीं, सुन, हे मेरे पुत्र, मैं इस बात को भली भाँति जानता हूँ यद्यपि इससे भी मनुष्यों की एक मण्डली उत्पन्न होगी, और यह भी महान हो जाएगा, तो भी इसका छोटा भाई इससे अधिक महान हो जाएगा, और उसके वंश से बहुत सी जातियाँ निकलेंगी।” ");
INSERT INTO hin2017_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","फिर उसने उसी दिन यह कहकर उनको आशीर्वाद दिया, “इस्राएली लोग तेरा नाम ले लेकर ऐसा आशीर्वाद दिया करेंगे, ‘परमेश्वर तुझे एप्रैम और मनश्शे के समान बना दे,’” और उसने मनश्शे से पहले एप्रैम का नाम लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","तब इस्राएल ने यूसुफ से कहा, “देख, मैं तो मरने पर हूँ परन्तु परमेश्वर तुम लोगों के संग रहेगा, और तुम को तुम्हारे पितरों के देश में फिर पहुँचा देगा। ");
INSERT INTO hin2017_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","और मैं तुझको तेरे भाइयों से अधिक भूमि का एक भाग देता हूँ, जिसको मैंने एमोरियों के हाथ से अपनी तलवार और धनुष के बल से ले लिया है।” (यूह. 4:5) ");
INSERT INTO hin2017_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","फिर याकूब ने अपने पुत्रों को यह कहकर बुलाया, इकट्ठे हो जाओ, मैं तुम को बताऊँगा, कि अन्त के दिनों में तुम पर क्या-क्या बीतेगा। ");
INSERT INTO hin2017_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","हे याकूब के पुत्रों, इकट्ठे होकर सुनो, अपने पिता इस्राएल की ओर कान लगाओ। ");
INSERT INTO hin2017_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“हे रूबेन, तू मेरा जेठा, मेरा बल, और मेरे पौरूष का पहला फल है; प्रतिष्ठा का उत्तम भाग, और शक्ति का भी उत्तम भाग तू ही है। ");
INSERT INTO hin2017_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","तू जो जल के समान उबलनेवाला है, इसलिए दूसरों से श्रेष्ठ न ठहरेगा; क्योंकि तू अपने पिता की खाट पर चढ़ा, तब तूने उसको अशुद्ध किया; वह मेरे बिछौने पर चढ़ गया। ");
INSERT INTO hin2017_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","शिमोन और लेवी तो भाई-भाई हैं, उनकी तलवारें उपद्रव के हथियार हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","हे मेरे जीव, उनके मर्म में न पड़, हे मेरी महिमा, उनकी सभा में मत मिल; क्योंकि उन्होंने कोप से मनुष्यों को घात किया, और अपनी ही इच्छा पर चलकर बैलों को पंगु बनाया। ");
INSERT INTO hin2017_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","धिक्कार उनके कोप को, जो प्रचण्ड था; और उनके रोष को, जो निर्दय था; मैं उन्हें याकूब में अलग-अलग और इस्राएल में तितर-बितर कर दूँगा। ");
INSERT INTO hin2017_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","हे यहूदा, तेरे भाई तेरा धन्यवाद करेंगे, तेरा हाथ तेरे शत्रुओं की गर्दन पर पड़ेगा; तेरे पिता के पुत्र तुझे दण्डवत् करेंगे। ");
INSERT INTO hin2017_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदा सिंह का बच्चा है। हे मेरे पुत्र, तू अहेर करके गुफा में गया है वह सिंह अथवा सिंहनी के समान दबकर बैठ गया; फिर कौन उसको छेड़ेगा। (प्रका. 5:5) ");
INSERT INTO hin2017_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","जब तक शीलो न आए तब तक न तो यहूदा से राजदण्ड छूटेगा, न उसके वंश से व्यवस्था देनेवाला अलग होगा; और राज्य-राज्य के लोग उसके अधीन हो जाएँगे। (यूह. 11:52) ");
INSERT INTO hin2017_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","वह अपने जवान गदहे को दाखलता में, और अपनी गदही के बच्चे को उत्तम जाति की दाखलता में बाँधा करेगा; (प्रका. 7:14, प्रका. 22:14) उसने अपने वस्त्र दाखमधु में, और अपना पहरावा दाखों के रस में धोया है। ");
INSERT INTO hin2017_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","उसकी आँखें दाखमधु से चमकीली और उसके दाँत दूध से श्वेत होंगे। ");
INSERT INTO hin2017_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","जबूलून समुद्र तट पर निवास करेगा, वह जहाजों के लिये बन्दरगाह का काम देगा, और उसका परला भाग सीदोन के निकट पहुँचेगा ");
INSERT INTO hin2017_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","इस्साकार एक बड़ा और बलवन्त गदहा है, जो पशुओं के बाड़ों के बीच में दबका रहता है। ");
INSERT INTO hin2017_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","उसने एक विश्रामस्थान देखकर, कि अच्छा है, और एक देश, कि मनोहर है, अपने कंधे को बोझ उठाने के लिये झुकाया, और बेगारी में दास का सा काम करने लगा। ");
INSERT INTO hin2017_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","दान इस्राएल का एक गोत्र होकर अपने जातिभाइयों का न्याय करेगा। ");
INSERT INTO hin2017_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान मार्ग में का एक साँप, और रास्ते में का एक नाग होगा, जो घोड़े की नली को डसता है, जिससे उसका सवार पछाड़ खाकर गिर पड़ता है। ");
INSERT INTO hin2017_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","हे यहोवा, मैं तुझी से उद्धार पाने की बाट जोहता आया हूँ। ");
INSERT INTO hin2017_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","गाद पर एक दल चढ़ाई तो करेगा; पर वह उसी दल के पिछले भाग पर छापा मारेगा। ");
INSERT INTO hin2017_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","आशेर से जो अन्न उत्पन्न होगा वह उत्तम होगा, और वह राजा के योग्य स्वादिष्ट भोजन दिया करेगा। ");
INSERT INTO hin2017_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","नप्ताली एक छूटी हुई हिरनी है; वह सुन्दर बातें बोलता है। ");
INSERT INTO hin2017_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","यूसुफ बलवन्त लता की एक शाखा है, वह सोते के पास लगी हुई फलवन्त लता की एक शाखा है; उसकी डालियाँ दीवार पर से चढ़कर फैल जाती हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","धनुर्धारियों ने उसको खेदित किया, और उस पर तीर मारे, और उसके पीछे पड़े हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","पर उसका धनुष दृढ़ रहा, और उसकी बाँह और हाथ याकूब के उसी शक्तिमान परमेश्वर के हाथों के द्वारा फुर्तीले हुए, जिसके पास से वह चरवाहा आएगा, जो इस्राएल की चट्टान भी ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","यह तेरे पिता के उस परमेश्वर का काम है, जो तेरी सहायता करेगा, उस सर्वशक्तिमान का जो तुझे ऊपर से आकाश में की आशीषें, और नीचे से गहरे जल में की आशीषें, और स्तनों, और गर्भ की आशीषें देगा। ");
INSERT INTO hin2017_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","तेरे पिता के आशीर्वाद मेरे पितरों के आशीर्वादों से अधिक बढ़ गए हैं और सनातन पहाड़ियों की मनचाही वस्तुओं के समान बने रहेंगे वे यूसुफ के सिर पर, जो अपने भाइयों से अलग किया गया था, उसी के सिर के मुकुट पर फूले फलेंगे। ");
INSERT INTO hin2017_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","बिन्यामीन फाड़नेवाला भेड़िया है, सवेरे तो वह अहेर भक्षण करेगा, और साँझ को लूट बाँट लेगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","इस्राएल के बारहों गोत्र ये ही हैं और उनके पिता ने जिस-जिस वचन से उनको आशीर्वाद दिया, वे ये ही हैं; एक-एक को उसके आशीर्वाद के अनुसार उसने आशीर्वाद दिया। ");
INSERT INTO hin2017_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","तब उसने यह कहकर उनको आज्ञा दी, “मैं अपने लोगों के साथ मिलने पर हूँ: इसलिए मुझे हित्ती एप्रोन की भूमिवाली गुफा में मेरे बापदादों के साथ मिट्टी देना, (प्रेरि. 7:16) ");
INSERT INTO hin2017_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","अर्थात् उसी गुफा में जो कनान देश में मम्रे के सामने वाली मकपेला की भूमि में है; उस भूमि को अब्राहम ने हित्ती एप्रोन के हाथ से इसलिए मोल लिया था, कि वह कब्रिस्तान के लिये उसकी निज भूमि हो। ");
INSERT INTO hin2017_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","वहाँ अब्राहम और उसकी पत्नी सारा को मिट्टी दी गई थी; और वहीं इसहाक और उसकी पत्नी रिबका को भी मिट्टी दी गई; और वहीं मैंने लिआ को भी मिट्टी दी। ");
INSERT INTO hin2017_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","वह भूमि और उसमें की गुफा हित्तियों के हाथ से मोल ली गई।” ");
INSERT INTO hin2017_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","याकूब जब अपने पुत्रों को यह आज्ञा दे चुका, तब अपने पाँव खाट पर समेट प्राण छोड़े, और अपने लोगों में जा मिला। (प्रेरि. 7:15) ");
INSERT INTO hin2017_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","तब यूसुफ अपने पिता के मुँह पर गिरकर रोया और उसे चूमा। ");
INSERT INTO hin2017_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","और यूसुफ ने उन वैद्यों को, जो उसके सेवक थे, आज्ञा दी कि उसके पिता के शव में सुगन्ध-द्रव्य भरे; तब वैद्यों ने इस्राएल के शव में सुगन्ध-द्रव्य भर दिए। ");
INSERT INTO hin2017_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","और उसके चालीस दिन पूरे हुए, क्योंकि जिनके शव में सुगन्ध-द्रव्य भरे जाते हैं, उनको इतने ही दिन पूरे लगते है; और मिस्री लोग उसके लिये सत्तर दिन तक विलाप करते रहे। ");
INSERT INTO hin2017_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","जब उसके विलाप के दिन बीत गए, तब यूसुफ फ़िरौन के घराने के लोगों से कहने लगा, “यदि तुम्हारे अनुग्रह की दृष्टि मुझ पर हो तो मेरी यह विनती फ़िरौन को सुनाओ, ");
INSERT INTO hin2017_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","मेरे पिता ने यह कहकर, ‘देख मैं मरने पर हूँ,’ मुझे यह शपथ खिलाई, ‘जो कब्र मैंने अपने लिये कनान देश में खुदवाई है उसी में तू मुझे मिट्टी देगा।’ इसलिए अब मुझे वहाँ जाकर अपने पिता को मिट्टी देने की आज्ञा दे, तत्पश्चात् मैं लौट आऊँगा।” ");
INSERT INTO hin2017_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","तब फ़िरौन ने कहा, “जाकर अपने पिता की खिलाई हुई शपथ के अनुसार उसको मिट्टी दे।” ");
INSERT INTO hin2017_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","इसलिए यूसुफ अपने पिता को मिट्टी देने के लिये चला, और फ़िरौन के सब कर्मचारी, अर्थात् उसके भवन के पुरनिये, और मिस्र देश के सब पुरनिये उसके संग चले। ");
INSERT INTO hin2017_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","और यूसुफ के घर के सब लोग, और उसके भाई, और उसके पिता के घर के सब लोग भी संग गए; पर वे अपने बाल-बच्चों, और भेड़-बकरियों, और गाय-बैलों को गोशेन देश में छोड़ गए। ");
INSERT INTO hin2017_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","और उसके संग रथ और सवार गए, इस प्रकार भीड़ बहुत भारी हो गई। ");
INSERT INTO hin2017_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","जब वे आताद के खलिहान तक, जो यरदन नदी के पार है, पहुँचे, तब वहाँ अत्यन्त भारी विलाप किया, और यूसुफ ने अपने पिता के लिये सात दिन का विलाप कराया। ");
INSERT INTO hin2017_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","आताद के खलिहान में के विलाप को देखकर उस देश के निवासी कनानियों ने कहा, “यह तो मिस्रियों का कोई भारी विलाप होगा।” इसी कारण उस स्थान का नाम आबेलमिस्रैम पड़ा, और वह यरदन के पार है। ");
INSERT INTO hin2017_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","इस्राएल के पुत्रों ने ठीक वही काम किया जिसकी उसने उनको आज्ञा दी थी: ");
INSERT INTO hin2017_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","अर्थात् उन्होंने उसको कनान देश में ले जाकर मकपेला की उस भूमिवाली गुफा में, जो मम्रे के सामने हैं, मिट्टी दी; जिसको अब्राहम ने हित्ती एप्रोन के हाथ से इसलिए मोल लिया था, कि वह कब्रिस्तान के लिये उसकी निज भूमि हो। ");
INSERT INTO hin2017_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","अपने पिता को मिट्टी देकर यूसुफ अपने भाइयों और उन सब समेत, जो उसके पिता को मिट्टी देने के लिये उसके संग गए थे, मिस्र लौट आया। ");
INSERT INTO hin2017_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","जब यूसुफ के भाइयों ने देखा कि हमारा पिता मर गया है, तब कहने लगे, “कदाचित् यूसुफ अब हमारे पीछे पडे़, और जितनी बुराई हमने उससे की थी सब का पूरा बदला हम से ले।” ");
INSERT INTO hin2017_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","इसलिए उन्होंने यूसुफ के पास यह कहला भेजा, “तेरे पिता ने मरने से पहले हमें यह आज्ञा दी थी, ");
INSERT INTO hin2017_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘तुम लोग यूसुफ से इस प्रकार कहना, कि हम विनती करते हैं, कि तू अपने भाइयों के अपराध और पाप को क्षमा कर; हमने तुझ से बुराई की थी, पर अब अपने पिता के परमेश्वर के दासों का अपराध क्षमा कर।’” उनकी ये बातें सुनकर यूसुफ रो पड़ा। ");
INSERT INTO hin2017_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","और उसके भाई आप भी जाकर उसके सामने गिर पड़े, और कहा, “देख, हम तेरे दास हैं।” ");
INSERT INTO hin2017_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","यूसुफ ने उनसे कहा, “मत डरो, क्या मैं परमेश्वर की जगह पर हूँ? ");
INSERT INTO hin2017_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","यद्यपि तुम लोगों ने मेरे लिये बुराई का विचार किया था; परन्तु परमेश्वर ने उसी बात में भलाई का विचार किया, जिससे वह ऐसा करे, जैसा आज के दिन प्रगट है, कि बहुत से लोगों के प्राण बचे हैं। ");
INSERT INTO hin2017_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","इसलिए अब मत डरो: मैं तुम्हारा और तुम्हारे बाल-बच्चों का पालन-पोषण करता रहूँगा।” इस प्रकार उसने उनको समझा-बुझाकर शान्ति दी। ");
INSERT INTO hin2017_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","यूसुफ अपने पिता के घराने समेत मिस्र में रहता रहा, और यूसुफ एक सौ दस वर्ष जीवित रहा। ");
INSERT INTO hin2017_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","और यूसुफ एप्रैम के परपोतों तक को देखने पाया और मनश्शे के पोते, जो माकीर के पुत्र थे, वे उत्पन्न हुए और यूसुफ ने उन्हें गोद में लिया। ");
INSERT INTO hin2017_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","यूसुफ ने अपने भाइयों से कहा, “मैं तो मरने पर हूँ; परन्तु परमेश्वर निश्चय तुम्हारी सुधि लेगा, और तुम्हें इस देश से निकालकर उस देश में पहुँचा देगा, जिसके देने की उसने अब्राहम, इसहाक, और याकूब से शपथ खाई थी।” (इब्रा. 11:22) ");
INSERT INTO hin2017_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","फिर यूसुफ ने इस्राएलियों से यह कहकर कि परमेश्वर निश्चय तुम्हारी सुधि लेगा, उनको इस विषय की शपथ खिलाई, “हम तेरी हड्डियों को यहाँ से उस देश में ले जाएँगे।” (इब्रा. 11:22) ");
INSERT INTO hin2017_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","इस प्रकार यूसुफ एक सौ दस वर्ष का होकर मर गया: और उसके शव में सुगन्ध-द्रव्य भरे गए, और वह शव मिस्र में एक शवपेटी में रखा गया।");
INSERT INTO hin2017_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","इस्राएल के पुत्रों के नाम, जो अपने-अपने घराने को लेकर याकूब के साथ मिस्र देश में आए, ये हैं: ");
INSERT INTO hin2017_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रूबेन, शिमोन, लेवी, यहूदा, ");
INSERT INTO hin2017_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साकार, जबूलून, बिन्यामीन, ");
INSERT INTO hin2017_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नप्ताली, गाद और आशेर। ");
INSERT INTO hin2017_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","और यूसुफ तो मिस्र में पहले ही आ चुका था। याकूब के निज वंश में जो उत्पन्न हुए वे सब सत्तर प्राणी थे। (प्रेरि. 7:14) ");
INSERT INTO hin2017_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","यूसुफ, और उसके सब भाई, और उस पीढ़ी के सब लोग मर मिटे। (प्रेरि. 7:15) ");
INSERT INTO hin2017_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","परन्तु इस्राएल की सन्तान फूलने-फलने लगी; और वे अत्यन्त सामर्थी बनते चले गए; और इतना अधिक बढ़ गए कि सारा देश उनसे भर गया। ");
INSERT INTO hin2017_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","मिस्र में एक नया राजा गद्दी पर बैठा जो यूसुफ को नहीं जानता था। (प्रेरि. 7:17,18) ");
INSERT INTO hin2017_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","और उसने अपनी प्रजा से कहा, “देखो, इस्राएली हम से गिनती और सामर्थ्य में अधिक बढ़ गए हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","इसलिए आओ, हम उनके साथ बुद्धिमानी से बर्ताव करें, कहीं ऐसा न हो कि जब वे बहुत बढ़ जाएँ, और यदि युद्ध का समय आ पड़े, तो हमारे बैरियों से मिलकर हम से लड़ें और इस देश से निकल जाएँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","इसलिए मिस्रियों ने उन पर बेगारी करानेवालों को नियुक्त किया कि वे उन पर भार डाल-डालकर उनको दुःख दिया करें; तब उन्होंने फ़िरौन के लिये पितोम और रामसेस नामक भण्डारवाले नगरों को बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","पर ज्यों-ज्यों वे उनको दुःख देते गए त्यों-त्यों वे बढ़ते और फैलते चले गए; इसलिए वे इस्राएलियों से अत्यन्त डर गए। ");
INSERT INTO hin2017_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","तो भी मिस्रियों ने इस्राएलियों से कठोरता के साथ सेवा करवाई; ");
INSERT INTO hin2017_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","और उनके जीवन को गारे, ईंट और खेती के भाँति-भाँति के काम की कठिन सेवा से दुःखी कर डाला; जिस किसी काम में वे उनसे सेवा करवाते थे उसमें वे कठोरता का व्यवहार करते थे। ");
INSERT INTO hin2017_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","शिप्रा और पूआ नामक दो इब्री दाइयों को मिस्र के राजा ने आज्ञा दी, ");
INSERT INTO hin2017_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“जब तुम इब्री स्त्रियों को बच्चा उत्पन्न होने के समय प्रसव के पत्थरों पर बैठी देखो, तब यदि बेटा हो, तो उसे मार डालना; और बेटी हो, तो जीवित रहने देना।” ");
INSERT INTO hin2017_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","परन्तु वे दाइयाँ परमेश्वर का भय मानती थीं, इसलिए मिस्र के राजा की आज्ञा न मानकर लड़कों को भी जीवित छोड़ देती थीं। ");
INSERT INTO hin2017_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","तब मिस्र के राजा ने उनको बुलवाकर पूछा, “तुम जो लड़कों को जीवित छोड़ देती हो, तो ऐसा क्यों करती हो?” (प्रेरि. 7:19) ");
INSERT INTO hin2017_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","दाइयों ने फ़िरौन को उतर दिया, “इब्री स्त्रियाँ मिस्री स्त्रियों के समान नहीं हैं; वे ऐसी फुर्तीली हैं कि दाइयों के पहुँचने से पहले ही उनको बच्चा उत्पन्न हो जाता है।” ");
INSERT INTO hin2017_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","इसलिए परमेश्वर ने दाइयों के साथ भलाई की; और वे लोग बढ़कर बहुत सामर्थी हो गए। ");
INSERT INTO hin2017_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","इसलिए कि दाइयाँ परमेश्वर का भय मानती थीं उसने उनके घर बसाए। ");
INSERT INTO hin2017_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","तब फ़िरौन ने अपनी सारी प्रजा के लोगों को आज्ञा दी, “इब्रियों के जितने बेटे उत्पन्न हों उन सभी को तुम नील नदी में डाल देना, और सब बेटियों को जीवित रख छोड़ना।” (प्रेरि. 7:19) ");
INSERT INTO hin2017_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","लेवी के घराने के एक पुरुष ने एक लेवी वंश की स्त्री को ब्याह लिया। ");
INSERT INTO hin2017_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","वह स्त्री गर्भवती हुई और उसके एक पुत्र उत्पन्न हुआ; और यह देखकर कि यह बालक सुन्दर है, उसे तीन महीने तक छिपा रखा। (प्रेरि. 7:20, इब्रा. 11:23) ");
INSERT INTO hin2017_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","जब वह उसे और छिपा न सकी तब उसके लिये सरकण्डों की एक टोकरी लेकर, उस पर चिकनी मिट्टी और राल लगाकर, उसमें बालक को रखकर नील नदी के किनारे कांसों के बीच छोड़ आई। ");
INSERT INTO hin2017_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","उस बालक की बहन दूर खड़ी रही, कि देखे उसका क्या हाल होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","तब फ़िरौन की बेटी नहाने के लिये नदी के किनारे आई; उसकी सखियाँ नदी के किनारे-किनारे टहलने लगीं; तब उसने कांसों के बीच टोकरी को देखकर अपनी दासी को उसे ले आने के लिये भेजा। (प्रेरि. 7:21) ");
INSERT INTO hin2017_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","तब उसने उसे खोलकर देखा कि एक रोता हुआ बालक है; तब उसे तरस आया और उसने कहा, “यह तो किसी इब्री का बालक होगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","तब बालक की बहन ने फ़िरौन की बेटी से कहा, “क्या मैं जाकर इब्री स्त्रियों में से किसी धाई को तेरे पास बुला ले आऊँ जो तेरे लिये बालक को दूध पिलाया करे?” ");
INSERT INTO hin2017_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फ़िरौन की बेटी ने कहा, “जा।” तब लड़की जाकर बालक की माता को बुला ले आई। ");
INSERT INTO hin2017_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फ़िरौन की बेटी ने उससे कहा, “तू इस बालक को ले जाकर मेरे लिये दूध पिलाया कर, और मैं तुझे मजदूरी दूँगी।” तब वह स्त्री बालक को ले जाकर दूध पिलाने लगी। ");
INSERT INTO hin2017_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","जब बालक कुछ बड़ा हुआ तब वह उसे फ़िरौन की बेटी के पास ले गई, और वह उसका बेटा ठहरा; और उसने यह कहकर उसका नाम मूसा रखा, “मैंने इसको जल से निकाला था।” ");
INSERT INTO hin2017_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","उन दिनों में ऐसा हुआ कि जब मूसा जवान हुआ, और बाहर अपने भाई-बन्धुओं के पास जाकर उनके दुःखों पर दृष्टि करने लगा; तब उसने देखा कि कोई मिस्री जन मेरे एक इब्री भाई को मार रहा है। ");
INSERT INTO hin2017_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","जब उसने इधर-उधर देखा कि कोई नहीं है, तब उस मिस्री को मार डाला और रेत में छिपा दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","फिर दूसरे दिन बाहर जाकर उसने देखा कि दो इब्री पुरुष आपस में मारपीट कर रहे हैं; उसने अपराधी से कहा, “तू अपने भाई को क्यों मारता है?” ");
INSERT INTO hin2017_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","उसने कहा, “किसने तुझे हम लोगों पर हाकिम और न्यायी ठहराया? जिस भाँति तूने मिस्री को घात किया क्या उसी भाँति तू मुझे भी घात करना चाहता है?” तब मूसा यह सोचकर डर गया, “निश्चय वह बात खुल गई है।” ");
INSERT INTO hin2017_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","जब फ़िरौन ने यह बात सुनी तब मूसा को घात करने की योजना की। तब मूसा फ़िरौन के सामने से भागा, और मिद्यान देश में जाकर रहने लगा; और वह वहाँ एक कुएँ के पास बैठ गया। (इब्रा. 11:27) ");
INSERT INTO hin2017_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","मिद्यान के याजक की सात बेटियाँ थीं; और वे वहाँ आकर जल भरने लगीं कि कठौतों में भरकर अपने पिता की भेड़-बकरियों को पिलाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","तब चरवाहे आकर उनको हटाने लगे; इस पर मूसा ने खड़े होकर उनकी सहायता की, और भेड़-बकरियों को पानी पिलाया। ");
INSERT INTO hin2017_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","जब वे अपने पिता रूएल के पास फिर आई, तब उसने उनसे पूछा, “क्या कारण है कि आज तुम ऐसी फुर्ती से आई हो?” ");
INSERT INTO hin2017_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","उन्होंने कहा, “एक मिस्री पुरुष ने हमको चरवाहों के हाथ से छुड़ाया, और हमारे लिये बहुत जल भरकर भेड़-बकरियों को पिलाया।” ");
INSERT INTO hin2017_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","तब उसने अपनी बेटियों से पूछा, “वह पुरुष कहाँ है? तुम उसको क्यों छोड़ आई हो? उसको बुला ले आओ कि वह भोजन करे।” ");
INSERT INTO hin2017_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","और मूसा उस पुरुष के साथ रहने को प्रसन्न हुआ; उसने उसे अपनी बेटी सिप्पोरा को ब्याह दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","और उसके एक पुत्र उत्पन्न हुआ, तब मूसा ने यह कहकर, “मैं अन्य देश में परदेशी हूँ,” उसका नाम गेर्शोम रखा। (प्रेरि. 7:29, प्रेरि. 7:6) ");
INSERT INTO hin2017_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","बहुत दिनों के बीतने पर मिस्र का राजा मर गया। और इस्राएली कठिन सेवा के कारण लम्बी-लम्बी साँस लेकर आहें भरने लगे, और पुकार उठे, और उनकी दुहाई जो कठिन सेवा के कारण हुई वह परमेश्वर तक पहुँची। ");
INSERT INTO hin2017_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","और परमेश्वर ने उनका कराहना सुनकर अपनी वाचा को, जो उसने अब्राहम, और इसहाक, और याकूब के साथ बाँधी थी, स्मरण किया। (प्रेरि. 7:34) ");
INSERT INTO hin2017_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","और परमेश्वर ने इस्राएलियों पर दृष्टि करके उन पर चित्त लगाया। ");
INSERT INTO hin2017_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","मूसा अपने ससुर यित्रो नामक मिद्यान के याजक की भेड़-बकरियों को चराता था; और वह उन्हें जंगल की पश्चिमी ओर होरेब नामक परमेश्वर के पर्वत के पास ले गया। ");
INSERT INTO hin2017_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","और परमेश्वर के दूत ने एक कँटीली झाड़ी के बीच आग की लौ में उसको दर्शन दिया; और उसने दृष्टि उठाकर देखा कि झाड़ी जल रही है, पर भस्म नहीं होती। (मर. 12:26, लूका 20:37) ");
INSERT INTO hin2017_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","तब मूसा ने कहा, “मैं उधर जाकर इस बड़े अचम्भे को देखूँगा कि वह झाड़ी क्यों नहीं जल जाती।” (प्रेरि. 7:30,31) ");
INSERT INTO hin2017_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","जब यहोवा ने देखा कि मूसा देखने को मुड़ा चला आता है, तब परमेश्वर ने झाड़ी के बीच से उसको पुकारा, “हे मूसा, हे मूसा!” मूसा ने कहा, “क्या आज्ञा।” ");
INSERT INTO hin2017_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","उसने कहा, “इधर पास मत आ, और अपने पाँवों से जूतियों को उतार दे, क्योंकि जिस स्थान पर तू खड़ा है वह पवित्र भूमि है।” (प्रेरि. 7:33) ");
INSERT INTO hin2017_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","फिर उसने कहा, “मैं तेरे पिता का परमेश्वर, और अब्राहम का परमेश्वर, इसहाक का परमेश्वर, और याकूब का परमेश्वर हूँ।” तब मूसा ने जो परमेश्वर की ओर निहारने से डरता था अपना मुँह ढाँप लिया। (मत्ती 22:32, मर. 12:26, लूका 20:37) ");
INSERT INTO hin2017_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","फिर यहोवा ने कहा, “मैंने अपनी प्रजा के लोग जो मिस्र में हैं उनके दुःख को निश्चय देखा है, और उनकी जो चिल्लाहट परिश्रम करानेवालों के कारण होती है उसको भी मैंने सुना है, और उनकी पीड़ा पर मैंने चित्त लगाया है; ");
INSERT INTO hin2017_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","इसलिए अब मैं उतर आया हूँ कि उन्हें मिस्रियों के वश से छुड़ाऊँ, और उस देश से निकालकर एक अच्छे और बड़े देश में जिसमें दूध और मधु की धारा बहती है, अर्थात् कनानी, हित्ती, एमोरी, परिज्जी, हिब्बी, और यबूसी लोगों के स्थान में पहुँचाऊँ। ");
INSERT INTO hin2017_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","इसलिए अब सुन, इस्राएलियों की चिल्लाहट मुझे सुनाई पड़ी है, और मिस्रियों का उन पर अंधेर करना भी मुझे दिखाई पड़ा है, ");
INSERT INTO hin2017_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","इसलिए आ, मैं तुझे फ़िरौन के पास भेजता हूँ कि तू मेरी इस्राएली प्रजा को मिस्र से निकाल ले आए।” (प्रेरि. 7:34) ");
INSERT INTO hin2017_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","तब मूसा ने परमेश्वर से कहा, “मैं कौन हूँ जो फ़िरौन के पास जाऊँ, और इस्राएलियों को मिस्र से निकाल ले आऊँ?” ");
INSERT INTO hin2017_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","उसने कहा, “निश्चय मैं तेरे संग रहूँगा; और इस बात का कि तेरा भेजनेवाला मैं हूँ, तेरे लिए यह चिन्ह होगा; कि जब तू उन लोगों को मिस्र से निकाल चुके तब तुम इसी पहाड़ पर परमेश्वर की उपासना करोगे।” (प्रेरि. 7:7) ");
INSERT INTO hin2017_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","मूसा ने परमेश्वर से कहा, “जब मैं इस्राएलियों के पास जाकर उनसे यह कहूँ, ‘तुम्हारे पूर्वजों के परमेश्वर ने मुझे तुम्हारे पास भेजा है,’ तब यदि वे मुझसे पूछें, ‘उसका क्या नाम है?’ तब मैं उनको क्या बताऊँ?” ");
INSERT INTO hin2017_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","परमेश्वर ने मूसा से कहा, “मैं जो हूँ सो हूँ।” फिर उसने कहा, “तू इस्राएलियों से यह कहना, ‘जिसका नाम मैं हूँ है उसी ने मुझे तुम्हारे पास भेजा है।’” (प्रका. 1:4,8, प्रका. 4:8, प्रका. 11:17) ");
INSERT INTO hin2017_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","फिर परमेश्वर ने मूसा से यह भी कहा, “तू इस्राएलियों से यह कहना, ‘तुम्हारे पूर्वजों का परमेश्वर, अर्थात् अब्राहम का परमेश्वर, इसहाक का परमेश्वर, और याकूब का परमेश्वर, यहोवा, उसी ने मुझ को तुम्हारे पास भेजा है। देख सदा तक मेरा नाम यही रहेगा, और पीढ़ी-पीढ़ी में मेरा स्मरण इसी से हुआ करेगा।’ (मत्ती 22:32, मर. 12:26) ");
INSERT INTO hin2017_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","इसलिए अब जाकर इस्राएली पुरनियों को इकट्ठा कर, और उनसे कह, ‘तुम्हारे पूर्वज अब्राहम, इसहाक, और याकूब के परमेश्वर, यहोवा ने मुझे दर्शन देकर यह कहा है कि मैंने तुम पर और तुम से जो बर्ताव मिस्र में किया जाता है उस पर भी चित्त लगाया है; ");
INSERT INTO hin2017_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","और मैंने ठान लिया है कि तुम को मिस्र के दुःखों में से निकालकर कनानी, हित्ती, एमोरी, परिज्जी हिब्बी, और यबूसी लोगों के देश में ले चलूँगा, जो ऐसा देश है कि जिसमें दूध और मधु की धारा बहती है।’ ");
INSERT INTO hin2017_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","तब वे तेरी मानेंगे; और तू इस्राएली पुरनियों को संग लेकर मिस्र के राजा के पास जाकर उससे यह कहना, ‘इब्रियों के परमेश्वर, यहोवा से हम लोगों की भेंट हुई है; इसलिए अब हमको तीन दिन के मार्ग पर जंगल में जाने दे कि अपने परमेश्वर यहोवा को बलिदान चढ़ाएँ।’ ");
INSERT INTO hin2017_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","मैं जानता हूँ कि मिस्र का राजा तुम को जाने न देगा वरन् बड़े बल से दबाए जाने पर भी जाने न देगा। (निर्ग. 5:2) ");
INSERT INTO hin2017_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","इसलिए मैं हाथ बढ़ाकर उन सब आश्चर्यकर्मों से जो मिस्र के बीच करूँगा उस देश को मारूँगा; और उसके पश्चात् वह तुम को जाने देगा। ");
INSERT INTO hin2017_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","तब मैं मिस्रियों से अपनी इस प्रजा पर अनुग्रह करवाऊँगा; और जब तुम निकलोगे तब खाली हाथ न निकलोगे। ");
INSERT INTO hin2017_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","वरन् तुम्हारी एक-एक स्त्री अपनी-अपनी पड़ोसिन, और अपने-अपने घर में रहनेवाली से सोने चाँदी के गहने, और वस्त्र माँग लेगी, और तुम उन्हें अपने बेटों और बेटियों को पहनाना; इस प्रकार तुम मिस्रियों को लूटोगे।” ");
INSERT INTO hin2017_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","तब मूसा ने उत्तर दिया, “वे मुझ पर विश्वास न करेंगे और न मेरी सुनेंगे, वरन् कहेंगे, ‘यहोवा ने तुझको दर्शन नहीं दिया।’” ");
INSERT INTO hin2017_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","यहोवा ने उससे कहा, “तेरे हाथ में वह क्या है?” वह बोला, “लाठी।” ");
INSERT INTO hin2017_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","उसने कहा, “उसे भूमि पर डाल दे।” जब उसने उसे भूमि पर डाला तब वह सर्प बन गई, और मूसा उसके सामने से भागा। ");
INSERT INTO hin2017_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","तब यहोवा ने मूसा से कहा, “हाथ बढ़ाकर उसकी पूँछ पकड़ ले, ताकि वे लोग विश्वास करें कि तुम्हारे पूर्वजों के परमेश्वर अर्थात् अब्राहम के परमेश्वर, इसहाक के परमेश्वर, और याकूब के परमेश्वर, यहोवा ने तुझको दर्शन दिया है।” ");
INSERT INTO hin2017_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","जब उसने हाथ बढ़ाकर उसको पकड़ा तब वह उसके हाथ में फिर लाठी बन गई। ");
INSERT INTO hin2017_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","फिर यहोवा ने उससे यह भी कहा, “अपना हाथ छाती पर रखकर ढाँप।” अतः उसने अपना हाथ छाती पर रखकर ढाँप लिया; फिर जब उसे निकाला तब क्या देखा, कि उसका हाथ कोढ़ के कारण हिम के समान श्वेत हो गया है। ");
INSERT INTO hin2017_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","तब उसने कहा, “अपना हाथ छाती पर फिर रखकर ढाँप।” और उसने अपना हाथ छाती पर रखकर ढाँप लिया; और जब उसने उसको छाती पर से निकाला तब क्या देखता है कि वह फिर सारी देह के समान हो गया। ");
INSERT INTO hin2017_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","तब यहोवा ने कहा, “यदि वे तेरी बात पर विश्वास न करें, और पहले चिन्ह को न मानें, तो दूसरे चिन्ह पर विश्वास करेंगे। ");
INSERT INTO hin2017_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","और यदि वे इन दोनों चिन्हों पर विश्वास न करें और तेरी बात को न मानें, तब तू नील नदी से कुछ जल लेकर सूखी भूमि पर डालना; और जो जल तू नदी से निकालेगा वह सूखी भूमि पर लहू बन जाएगा।” (निर्ग. 7:19) ");
INSERT INTO hin2017_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","मूसा ने यहोवा से कहा, “हे मेरे प्रभु, मैं बोलने में निपुण नहीं, न तो पहले था, और न जब से तू अपने दास से बातें करने लगा; मैं तो मुँह और जीभ का भद्दा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","यहोवा ने उससे कहा, “मनुष्य का मुँह किसने बनाया है? और मनुष्य को गूँगा, या बहरा, या देखनेवाला, या अंधा, मुझ यहोवा को छोड़ कौन बनाता है? ");
INSERT INTO hin2017_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","अब जा, मैं तेरे मुख के संग होकर जो तुझे कहना होगा वह तुझे सिखाता जाऊँगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","उसने कहा, “हे मेरे प्रभु, कृपया तू किसी अन्य व्यक्ति को भेज।” ");
INSERT INTO hin2017_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","तब यहोवा का कोप मूसा पर भड़का और उसने कहा, “क्या तेरा भाई लेवीय हारून नहीं है? मुझे तो निश्चय है कि वह बोलने में निपुण है, और वह तुझ से भेंट करने के लिये निकल भी गया है, और तुझे देखकर मन में आनन्दित होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","इसलिए तू उसे ये बातें सिखाना; और मैं उसके मुख के संग और तेरे मुख के संग होकर जो कुछ तुम्हें करना होगा वह तुम को सिखाता जाऊँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","वह तेरी ओर से लोगों से बातें किया करेगा; वह तेरे लिये मुँह और तू उसके लिये परमेश्वर ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","और तू इस लाठी को हाथ में लिए जा, और इसी से इन चिन्हों को दिखाना।” ");
INSERT INTO hin2017_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","तब मूसा अपने ससुर यित्रो के पास लौटा और उससे कहा, “मुझे विदा कर, कि मैं मिस्र में रहनेवाले अपने भाइयों के पास जाकर देखूँ कि वे अब तक जीवित हैं या नहीं।” यित्रो ने कहा, “कुशल से जा।” ");
INSERT INTO hin2017_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","और यहोवा ने मिद्यान देश में मूसा से कहा, “मिस्र को लौट जा; क्योंकि जो मनुष्य तेरे प्राण के प्यासे थे वे सब मर गए हैं।” (मत्ती 2:20) ");
INSERT INTO hin2017_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","तब मूसा अपनी पत्नी और बेटों को गदहे पर चढ़ाकर मिस्र देश की ओर परमेश्वर की उस लाठी को हाथ में लिये हुए लौटा। ");
INSERT INTO hin2017_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","और यहोवा ने मूसा से कहा, “जब तू मिस्र में पहुँचे तब सावधान हो जाना, और जो चमत्कार मैंने तेरे वश में किए हैं उन सभी को फ़िरौन को दिखलाना; परन्तु मैं उसके मन को हठीला करूँगा, और वह मेरी प्रजा को जाने न देगा। (रोम. 9:18) ");
INSERT INTO hin2017_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","और तू फ़िरौन से कहना, ‘यहोवा यह कहता है, कि इस्राएल मेरा पुत्र वरन् मेरा पहलौठा है, ");
INSERT INTO hin2017_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","और मैं जो तुझ से कह चुका हूँ, कि मेरे पुत्र को जाने दे कि वह मेरी सेवा करे; और तूने अब तक उसे जाने नहीं दिया, इस कारण मैं अब तेरे पुत्र वरन् तेरे पहलौठे को घात करूँगा।’” ");
INSERT INTO hin2017_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","तब ऐसा हुआ कि मार्ग पर सराय में यहोवा ने मूसा से भेंट करके उसे मार डालना चाहा। ");
INSERT INTO hin2017_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","तब सिप्पोरा ने एक तेज चकमक पत्थर लेकर अपने बेटे की खलड़ी को काट डाला, और मूसा के पाँवों पर यह कहकर फेंक दिया, “निश्चय तू लहू बहानेवाला मेरा पति है।” ");
INSERT INTO hin2017_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","तब उसने उसको छोड़ दिया। और उसी समय खतने के कारण वह बोली, “तू लहू बहानेवाला पति है।” ");
INSERT INTO hin2017_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","तब यहोवा ने हारून से कहा, “मूसा से भेंट करने को जंगल में जा।” और वह गया, और परमेश्वर के पर्वत पर उससे मिला और उसको चूमा। ");
INSERT INTO hin2017_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","तब मूसा ने हारून को यह बताया कि यहोवा ने क्या-क्या बातें कहकर उसको भेजा है, और कौन-कौन से चिन्ह दिखलाने की आज्ञा उसे दी है। ");
INSERT INTO hin2017_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","तब मूसा और हारून ने जाकर इस्राएलियों के सब पुरनियों को इकट्ठा किया। ");
INSERT INTO hin2017_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","और जितनी बातें यहोवा ने मूसा से कही थीं वह सब हारून ने उन्हें सुनाई, और लोगों के सामने वे चिन्ह भी दिखलाए। ");
INSERT INTO hin2017_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","और लोगों ने उन पर विश्वास किया; और यह सुनकर कि यहोवा ने इस्राएलियों की सुधि ली और उनके दुःखों पर दृष्टि की है, उन्होंने सिर झुकाकर दण्डवत् किया। (निर्ग. 3:15,18) ");
INSERT INTO hin2017_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","इसके पश्चात् मूसा और हारून ने जाकर फ़िरौन से कहा, “इस्राएल का परमेश्वर यहोवा यह कहता है, ‘मेरी प्रजा के लोगों को जाने दे, कि वे जंगल में मेरे लिये पर्व करें।’” ");
INSERT INTO hin2017_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","फ़िरौन ने कहा, “यहोवा कौन है कि मैं उसका वचन मानकर इस्राएलियों को जाने दूँ? मैं यहोवा को नहीं जानता, और मैं इस्राएलियों को नहीं जाने दूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","उन्होंने कहा, “इब्रियों के परमेश्वर ने हम से भेंट की है; इसलिए हमें जंगल में तीन दिन के मार्ग पर जाने दे, कि अपने परमेश्वर यहोवा के लिये बलिदान करें, ऐसा न हो कि वह हम में मरी फैलाए या तलवार चलवाए।” ");
INSERT INTO hin2017_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","मिस्र के राजा ने उनसे कहा, “हे मूसा, हे हारून, तुम क्यों लोगों से काम छुड़वाना चाहते हो? तुम जाकर अपने-अपने बोझ को उठाओ।” ");
INSERT INTO hin2017_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","और फ़िरौन ने कहा, “सुनो, इस देश में वे लोग बहुत हो गए हैं, फिर तुम उनको उनके परिश्रम से विश्राम दिलाना चाहते हो!” ");
INSERT INTO hin2017_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","फ़िरौन ने उसी दिन उन परिश्रम करवानेवालों को जो उन लोगों के ऊपर थे, और उनके सरदारों को यह आज्ञा दी, ");
INSERT INTO hin2017_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“तुम जो अब तक ईंटें बनाने के लिये लोगों को पुआल दिया करते थे वह आगे को न देना; वे आप ही जाकर अपने लिये पुआल इकट्ठा करें। ");
INSERT INTO hin2017_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","तो भी जितनी ईंटें अब तक उन्हें बनानी पड़ती थीं उतनी ही आगे को भी उनसे बनवाना, ईंटों की गिनती कुछ भी न घटाना; क्योंकि वे आलसी हैं; इस कारण वे यह कहकर चिल्लाते हैं, ‘हम जाकर अपने परमेश्वर के लिये बलिदान करें।’ ");
INSERT INTO hin2017_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","उन मनुष्यों से और भी कठिन सेवा करवाई जाए कि वे उसमें परिश्रम करते रहें और झूठी बातों पर ध्यान न लगाएँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","तब लोगों के परिश्रम करानेवालों ने और सरदारों ने बाहर जाकर उनसे कहा, “फ़िरौन इस प्रकार कहता है, ‘मैं तुम्हें पुआल नहीं दूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","तुम ही जाकर जहाँ कहीं पुआल मिले वहाँ से उसको बटोरकर ले आओ; परन्तु तुम्हारा काम कुछ भी नहीं घटाया जाएगा।’” ");
INSERT INTO hin2017_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","इसलिए वे लोग सारे मिस्र देश में तितर-बितर हुए कि पुआल के बदले खूँटी बटोरें। ");
INSERT INTO hin2017_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","परिश्रम करनेवाले यह कह-कहकर उनसे जल्दी करते रहे कि जिस प्रकार तुम पुआल पाकर किया करते थे उसी प्रकार अपना प्रतिदिन का काम अब भी पूरा करो। ");
INSERT INTO hin2017_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","और इस्राएलियों में से जिन सरदारों को फ़िरौन के परिश्रम करानेवालों ने उनका अधिकारी ठहराया था, उन्होंने मार खाई, और उनसे पूछा गया, “क्या कारण है कि तुम ने अपनी ठहराई हुई ईंटों की गिनती के अनुसार पहले के समान कल और आज पूरी नहीं कराई?” ");
INSERT INTO hin2017_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","तब इस्राएलियों के सरदारों ने जाकर फ़िरौन की दुहाई यह कहकर दी, “तू अपने दासों से ऐसा बर्ताव क्यों करता है? ");
INSERT INTO hin2017_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","तेरे दासों को पुआल तो दिया ही नहीं जाता और वे हम से कहते रहते हैं, ‘ईंटें बनाओ, ईंटें बनाओ,’ और तेरे दासों ने भी मार खाई है; परन्तु दोष तेरे ही लोगों का है।” ");
INSERT INTO hin2017_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फ़िरौन ने कहा, “तुम आलसी हो, आलसी; इसी कारण कहते हो कि हमें यहोवा के लिये बलिदान करने को जाने दे। ");
INSERT INTO hin2017_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","अब जाकर अपना काम करो; और पुआल तुम को नहीं दिया जाएगा, परन्तु ईंटों की गिनती पूरी करनी पड़ेगी।” ");
INSERT INTO hin2017_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","जब इस्राएलियों के सरदारों ने यह बात सुनी कि उनकी ईंटों की गिनती न घटेगी, और प्रतिदिन उतना ही काम पूरा करना पड़ेगा, तब वे जान गए कि उनके संकट के दिन आ गए हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","जब वे फ़िरौन के सम्मुख से बाहर निकल आए तब मूसा और हारून, जो उनसे भेंट करने के लिये खड़े थे, उन्हें मिले। ");
INSERT INTO hin2017_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","और उन्होंने मूसा और हारून से कहा, “यहोवा तुम पर दृष्टि करके न्याय करे, क्योंकि तुम ने हमको फ़िरौन और उसके कर्मचारियों की दृष्टि में घृणित ठहराकर हमें घात करने के लिये उनके हाथ में तलवार दे दी है।” ");
INSERT INTO hin2017_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","तब मूसा ने यहोवा के पास लौटकर कहा, “हे प्रभु, तूने इस प्रजा के साथ ऐसी बुराई क्यों की? और तूने मुझे यहाँ क्यों भेजा? ");
INSERT INTO hin2017_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","जब से मैं तेरे नाम से फ़िरौन के पास बातें करने के लिये गया तब से उसने इस प्रजा के साथ बुरा ही व्यवहार किया है, और तूने अपनी प्रजा का कुछ भी छुटकारा नहीं किया।” ");
INSERT INTO hin2017_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","तब यहोवा ने मूसा से कहा, “अब तू देखेगा कि मैं फ़िरौन से क्या करूँगा; जिससे वह उनको बरबस निकालेगा, वह तो उन्हें अपने देश से बरबस निकाल देगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","परमेश्वर ने मूसा से कहा, “मैं यहोवा हूँ; ");
INSERT INTO hin2017_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","मैं सर्वशक्तिमान परमेश्वर के नाम से अब्राहम, इसहाक, और याकूब को दर्शन देता था, परन्तु यहोवा के नाम से मैं उन पर प्रगट न हुआ। ");
INSERT INTO hin2017_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","और मैंने उनके साथ अपनी वाचा दृढ़ की है, अर्थात् कनान देश जिसमें वे परदेशी होकर रहते थे, उसे उन्हें दे दूँ। ");
INSERT INTO hin2017_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","इस्राएली जिन्हें मिस्री लोग दासत्व में रखते हैं उनका कराहना भी सुनकर मैंने अपनी वाचा को स्मरण किया है। ");
INSERT INTO hin2017_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","इस कारण तू इस्राएलियों से कह, ‘मैं यहोवा हूँ, और तुम को मिस्रियों के बोझों के नीचे से निकालूँगा, और उनके दासत्व से तुम को छुड़ाऊँगा, और अपनी भुजा बढ़ाकर और भारी दण्ड देकर तुम्हें छुड़ा लूँगा, (प्रेरि. 13:17) ");
INSERT INTO hin2017_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","और मैं तुम को अपनी प्रजा बनाने के लिये अपना लूँगा, और मैं तुम्हारा परमेश्वर ठहरूँगा; और तुम जान लोगे कि मैं तुम्हारा परमेश्वर यहोवा हूँ जो तुम्हें मिस्रियों के बोझों के नीचे से निकाल ले आया। ");
INSERT INTO hin2017_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","और जिस देश के देने की शपथ मैंने अब्राहम, इसहाक, और याकूब से खाई थी उसी में मैं तुम्हें पहुँचाकर उसे तुम्हारा भाग कर दूँगा। मैं तो यहोवा हूँ।’” ");
INSERT INTO hin2017_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ये बातें मूसा ने इस्राएलियों को सुनाईं; परन्तु उन्होंने मन की बेचैनी और दासत्व की क्रूरता के कारण उसकी न सुनी। ");
INSERT INTO hin2017_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“तू जाकर मिस्र के राजा फ़िरौन से कह कि इस्राएलियों को अपने देश में से निकल जाने दे।” ");
INSERT INTO hin2017_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","और मूसा ने यहोवा से कहा, “देख, इस्राएलियों ने मेरी नहीं सुनी; फिर फ़िरौन मुझ भद्दे बोलनेवाले की कैसे सुनेगा?” ");
INSERT INTO hin2017_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","तब यहोवा ने मूसा और हारून को इस्राएलियों और मिस्र के राजा फ़िरौन के लिये आज्ञा इस अभिप्राय से दी कि वे इस्राएलियों को मिस्र देश से निकाल ले जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","उनके पितरों के घरानों के मुख्य पुरुष ये हैं: इस्राएल का पहलौठा रूबेन के पुत्र: हनोक, पल्लू, हेस्रोन और कर्मी थे; इन्हीं से रूबेन के कुल निकले। ");
INSERT INTO hin2017_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","और शिमोन के पुत्र: यमूएल, यामीन, ओहद, याकीन, और सोहर थे, और एक कनानी स्त्री का बेटा शाऊल भी था; इन्हीं से शिमोन के कुल निकले। ");
INSERT INTO hin2017_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लेवी के पुत्र जिनसे उनकी वंशावली चली है, उनके नाम ये हैं: अर्थात् गेर्शोन, कहात और मरारी, और लेवी की पूरी अवस्था एक सौ सैंतीस वर्ष की हुई। ");
INSERT INTO hin2017_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेर्शोन के पुत्र जिनसे उनका कुल चला: लिब्नी और शिमी थे। ");
INSERT INTO hin2017_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कहात के पुत्र: अम्राम, यिसहार, हेब्रोन और उज्जीएल थे, और कहात की पूरी अवस्था एक सौ सैंतीस वर्ष की हुई। ");
INSERT INTO hin2017_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मरारी के पुत्र: महली और मूशी थे। लेवियों के कुल जिनसे उनकी वंशावली चली ये ही हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अम्राम ने अपनी फूफी योकेबेद को ब्याह लिया और उससे हारून और मूसा उत्पन्न हुए, और अम्राम की पूरी अवस्था एक सौ सैंतीस वर्ष की हुई। ");
INSERT INTO hin2017_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","यिसहार के पुत्र: कोरह, नेपेग और जिक्री थे। ");
INSERT INTO hin2017_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्जीएल के पुत्र: मीशाएल, एलसाफान और सित्री थे। ");
INSERT INTO hin2017_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","हारून ने अम्मीनादाब की बेटी, और नहशोन की बहन एलीशेबा को ब्याह लिया; और उससे नादाब, अबीहू, और ईतामार उत्पन्न हुए। ");
INSERT INTO hin2017_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरह के पुत्र: अस्सीर, एलकाना और अबीआसाप थे; और इन्हीं से कोरहियों के कुल निकले। ");
INSERT INTO hin2017_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","हारून के पुत्र एलीआजर ने पूतीएल की एक बेटी को ब्याह लिया; और उससे पीनहास उत्पन्न हुआ। जिनसे उनका कुल चला। लेवियों के पितरों के घरानों के मुख्य पुरुष ये ही हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","हारून और मूसा वे ही हैं जिनको यहोवा ने यह आज्ञा दी: “इस्राएलियों को दल-दल करके उनके जत्थों के अनुसार मिस्र देश से निकाल ले आओ।” ");
INSERT INTO hin2017_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ये वही मूसा और हारून हैं जिन्होंने मिस्र के राजा फ़िरौन से कहा कि हम इस्राएलियों को मिस्र से निकाल ले जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","जब यहोवा ने मिस्र देश में मूसा से यह बात कहीं, ");
INSERT INTO hin2017_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“मैं तो यहोवा हूँ; इसलिए जो कुछ मैं तुम से कहूँगा वह सब मिस्र के राजा फ़िरौन से कहना।” ");
INSERT INTO hin2017_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","परन्तु मूसा ने यहोवा को उत्तर दिया, “मैं तो बोलने में भद्दा हूँ; और फ़िरौन कैसे मेरी सुनेगा?” ");
INSERT INTO hin2017_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","तब यहोवा ने मूसा से कहा, “सुन, मैं तुझे फ़िरौन के लिये परमेश्वर सा ठहराता हूँ; और तेरा भाई हारून तेरा नबी ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","जो-जो आज्ञा मैं तुझे दूँ वही तू कहना, और हारून उसे फ़िरौन से कहेगा जिससे वह इस्राएलियों को अपने देश से निकल जाने दे। ");
INSERT INTO hin2017_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","परन्तु मैं फ़िरौन के मन को कठोर कर दूँगा, और अपने चिन्ह और चमत्कार मिस्र देश में बहुत से दिखलाऊँगा। (प्रेरि. 7:36) ");
INSERT INTO hin2017_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","तो भी फ़िरौन तुम्हारी न सुनेगा; और मैं मिस्र देश पर अपना हाथ बढ़ाकर मिस्रियों को भारी दण्ड देकर अपनी सेना अर्थात् अपनी इस्राएली प्रजा को मिस्र देश से निकाल लूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","और जब मैं मिस्र पर हाथ बढ़ाकर इस्राएलियों को उनके बीच से निकालूँगा तब मिस्री जान लेंगे, कि मैं यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","तब मूसा और हारून ने यहोवा की आज्ञा के अनुसार ही किया। ");
INSERT INTO hin2017_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","तब जब मूसा और हारून फ़िरौन से बात करने लगे तब मूसा तो अस्सी वर्ष का था, और हारून तिरासी वर्ष का था। ");
INSERT INTO hin2017_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","फिर यहोवा ने मूसा और हारून से इस प्रकार कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“जब फ़िरौन तुम से कहे, ‘अपने प्रमाण का कोई चमत्कार दिखाओ,’ तब तू हारून से कहना, ‘अपनी लाठी को लेकर फ़िरौन के सामने डाल दे, कि वह अजगर बन जाए।’” ");
INSERT INTO hin2017_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","तब मूसा और हारून ने फ़िरौन के पास जाकर यहोवा की आज्ञा के अनुसार किया; और जब हारून ने अपनी लाठी को फ़िरौन और उसके कर्मचारियों के सामने डाल दिया, तब वह अजगर बन गई। ");
INSERT INTO hin2017_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","तब फ़िरौन ने पंडितों और टोनहा करनेवालों को बुलवाया; और मिस्र के जादूगरों ने आकर अपने-अपने तंत्र-मंत्र से वैसा ही किया। ");
INSERT INTO hin2017_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","उन्होंने भी अपनी-अपनी लाठी को डाल दिया, और वे भी अजगर बन गई। पर हारून की लाठी उनकी लाठियों को निगल गई। ");
INSERT INTO hin2017_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","परन्तु फ़िरौन का मन और हठीला हो गया, और यहोवा के वचन के अनुसार उसने मूसा और हारून की बातों को नहीं माना। ");
INSERT INTO hin2017_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","तब यहोवा ने मूसा से कहा, “फ़िरौन का मन कठोर हो गया है और वह इस प्रजा को जाने नहीं देता। ");
INSERT INTO hin2017_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","इसलिए सवेरे के समय फ़िरौन के पास जा, वह तो जल की ओर बाहर आएगा; और जो लाठी सर्प बन गई थी, उसको हाथ में लिए हुए नील नदी के तट पर उससे भेंट करने के लिये खड़े रहना। ");
INSERT INTO hin2017_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","और उससे इस प्रकार कहना, ‘इब्रियों के परमेश्वर यहोवा ने मुझे यह कहने के लिये तेरे पास भेजा है कि मेरी प्रजा के लोगों को जाने दे कि जिससे वे जंगल में मेरी उपासना करें; और अब तक तूने मेरा कहना नहीं माना। ");
INSERT INTO hin2017_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","यहोवा यह कहता है, इससे तू जान लेगा कि मैं ही परमेश्वर हूँ; देख, मैं अपने हाथ की लाठी को नील नदी के जल पर मारूँगा, और जल लहू बन जाएगा, ");
INSERT INTO hin2017_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","और जो मछलियाँ नील नदी में हैं वे मर जाएँगी, और नील नदी से दुर्गन्ध आने लगेगी, और मिस्रियों का जी नदी का पानी पीने के लिये न चाहेगा।’” ");
INSERT INTO hin2017_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","फिर यहोवा ने मूसा से कहा, “हारून से कह कि अपनी लाठी लेकर मिस्र देश में जितना जल है, अर्थात् उसकी नदियाँ, नहरें, झीलें, और जलकुण्ड, सब के ऊपर अपना हाथ बढ़ा कि उनका जल लहू बन जाए; और सारे मिस्र देश में काठ और पत्थर दोनों भाँति के जलपात्रों में लहू ही लहू हो जाएगा।” (प्रका. 8:8, प्रका. 11:6) ");
INSERT INTO hin2017_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","तब मूसा और हारून ने यहोवा की आज्ञा ही के अनुसार किया, अर्थात् उसने लाठी को उठाकर फ़िरौन और उसके कर्मचारियों के देखते नील नदी के जल पर मारा, और नदी का सब जल लहू बन गया। ");
INSERT INTO hin2017_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","और नील नदी में जो मछलियाँ थीं वे मर गई; और नदी से दुर्गन्ध आने लगी, और मिस्री लोग नदी का पानी न पी सके; और सारे मिस्र देश में लहू हो गया। (प्रका. 16:3) ");
INSERT INTO hin2017_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","तब मिस्र के जादूगरों ने भी अपने तंत्र-मंत्रों से वैसा ही किया; तो भी फ़िरौन का मन हठीला हो गया, और यहोवा के कहने के अनुसार उसने मूसा और हारून की न मानी। ");
INSERT INTO hin2017_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","फ़िरौन ने इस पर भी ध्यान नहीं दिया, और मुँह फेरकर अपने घर में चला गया। ");
INSERT INTO hin2017_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","और सब मिस्री लोग पीने के जल के लिये नील नदी के आस-पास खोदने लगे, क्योंकि वे नदी का जल नहीं पी सकते थे। ");
INSERT INTO hin2017_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","जब यहोवा ने नील नदी को मारा था तब से सात दिन हो चुके थे। ");
INSERT INTO hin2017_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","तब यहोवा ने फिर मूसा से कहा, “फ़िरौन के पास जाकर कह, ‘यहोवा तुझ से इस प्रकार कहता है, कि मेरी प्रजा के लोगों को जाने दे जिससे वे मेरी उपासना करें। ");
INSERT INTO hin2017_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","परन्तु यदि उन्हें जाने न देगा तो सुन, मैं मेंढक भेजकर तेरे सारे देश को हानि पहुँचानेवाला हूँ। ");
INSERT INTO hin2017_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","और नील नदी मेंढकों से भर जाएगी, और वे तेरे भवन में, और तेरे बिछौने पर, और तेरे कर्मचारियों के घरों में, और तेरी प्रजा पर, वरन् तेरे तन्दूरों और कठौतियों में भी चढ़ जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","और तुझ पर, और तेरी प्रजा, और तेरे कर्मचारियों, सभी पर मेंढक चढ़ जाएँगे।’” ");
INSERT INTO hin2017_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","फिर यहोवा ने मूसा को आज्ञा दी, “हारून से कह दे, कि नदियों, नहरों, और झीलों के ऊपर लाठी के साथ अपना हाथ बढ़ाकर मेंढकों को मिस्र देश पर चढ़ा ले आए।” ");
INSERT INTO hin2017_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","तब हारून ने मिस्र के जलाशयों के ऊपर अपना हाथ बढ़ाया; और मेंढकों ने मिस्र देश पर चढ़कर उसे छा लिया। ");
INSERT INTO hin2017_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","और जादूगर भी अपने तंत्र-मंत्रों से उसी प्रकार मिस्र देश पर मेंढक चढ़ा ले आए। ");
INSERT INTO hin2017_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","तब फ़िरौन ने मूसा और हारून को बुलवाकर कहा, “यहोवा से विनती करो कि वह मेंढकों को मुझसे और मेरी प्रजा से दूर करे; और मैं इस्राएली लोगों को जाने दूँगा। जिससे वे यहोवा के लिये बलिदान करें।” ");
INSERT INTO hin2017_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","तब मूसा ने फ़िरौन से कहा, “इतनी बात के लिये तू मुझे आदेश दे कि अब मैं तेरे, और तेरे कर्मचारियों, और प्रजा के निमित्त कब विनती करूँ, कि यहोवा तेरे पास से और तेरे घरों में से मेंढकों को दूर करे, और वे केवल नील नदी में पाए जाएँ?” ");
INSERT INTO hin2017_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","उसने कहा, “कल।” उसने कहा, “तेरे वचन के अनुसार होगा, जिससे तुझे यह ज्ञात हो जाए कि हमारे परमेश्वर यहोवा के तुल्य कोई दूसरा नहीं है। ");
INSERT INTO hin2017_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","और मेंढक तेरे पास से, और तेरे घरों में से, और तेरे कर्मचारियों और प्रजा के पास से दूर होकर केवल नील नदी में रहेंगे।” ");
INSERT INTO hin2017_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","तब मूसा और हारून फ़िरौन के पास से निकल गए; और मूसा ने उन मेंढकों के विषय यहोवा की दुहाई दी जो उसने फ़िरौन पर भेजे थे। ");
INSERT INTO hin2017_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","और यहोवा ने मूसा के कहने के अनुसार किया; और मेंढक घरों, आँगनों, और खेतों में मर गए। ");
INSERT INTO hin2017_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","और लोगों ने इकट्ठे करके उनके ढेर लगा दिए, और सारा देश दुर्गन्ध से भर गया। ");
INSERT INTO hin2017_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","परन्तु जब फ़िरौन ने देखा कि अब आराम मिला है तब यहोवा के कहने के अनुसार उसने फिर अपने मन को कठोर किया, और उनकी न सुनी। ");
INSERT INTO hin2017_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","फिर यहोवा ने मूसा से कहा, “हारून को आज्ञा दे, ‘तू अपनी लाठी बढ़ाकर भूमि की धूल पर मार, जिससे वह मिस्र देश भर में कुटकियाँ बन जाएँ।’” ");
INSERT INTO hin2017_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","और उन्होंने वैसा ही किया; अर्थात् हारून ने लाठी को ले हाथ बढ़ाकर भूमि की धूल पर मारा, तब मनुष्य और पशु दोनों पर कुटकियाँ हो गईं वरन् सारे मिस्र देश में भूमि की धूल कुटकियाँ बन गईं। ");
INSERT INTO hin2017_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","तब जादूगरों ने चाहा कि अपने तंत्र-मंत्रों के बल से हम भी कुटकियाँ ले आएँ, परन्तु यह उनसे न हो सका। और मनुष्यों और पशुओं दोनों पर कुटकियाँ बनी ही रहीं। ");
INSERT INTO hin2017_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","तब जादूगरों ने फ़िरौन से कहा, “यह तो परमेश्वर के हाथ का काम है।” तो भी यहोवा के कहने के अनुसार फ़िरौन का मन कठोर होता गया, और उसने मूसा और हारून की बात न मानी। ");
INSERT INTO hin2017_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","फिर यहोवा ने मूसा से कहा, “सवेरे उठकर फ़िरौन के सामने खड़ा होना, वह तो जल की ओर आएगा, और उससे कहना, ‘यहोवा तुझ से यह कहता है, कि मेरी प्रजा के लोगों को जाने दे, कि वे मेरी उपासना करें। ");
INSERT INTO hin2017_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","यदि तू मेरी प्रजा को न जाने देगा तो सुन, मैं तुझ पर, और तेरे कर्मचारियों और तेरी प्रजा पर, और तेरे घरों में झुण्ड के झुण्ड डांस भेजूँगा; और मिस्रियों के घर और उनके रहने की भूमि भी डांसों से भर जाएगी। ");
INSERT INTO hin2017_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","उस दिन मैं गोशेन देश को जिसमें मेरी प्रजा रहती है अलग करूँगा, और उसमें डांसों के झुण्ड न होंगे; जिससे तू जान ले कि पृथ्वी के बीच मैं ही यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","और मैं अपनी प्रजा और तेरी प्रजा में अन्तर ठहराऊँगा। यह चिन्ह कल होगा।’” ");
INSERT INTO hin2017_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","और यहोवा ने वैसा ही किया, और फ़िरौन के भवन, और उसके कर्मचारियों के घरों में, और सारे मिस्र देश में डांसों के झुण्ड के झुण्ड भर गए, और डांसों के मारे वह देश नाश हुआ। ");
INSERT INTO hin2017_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","तब फ़िरौन ने मूसा और हारून को बुलवाकर कहा, “तुम जाकर अपने परमेश्वर के लिये इसी देश में बलिदान करो।” ");
INSERT INTO hin2017_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","मूसा ने कहा, “ऐसा करना उचित नहीं; क्योंकि हम अपने परमेश्वर यहोवा के लिये मिस्रियों की घृणित वस्तु बलिदान करेंगे; और यदि हम मिस्रियों के देखते उनकी घृणित वस्तु बलिदान करें तो क्या वे हमको पथरवाह न करेंगे? ");
INSERT INTO hin2017_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","हम जंगल में तीन दिन के मार्ग पर जाकर अपने परमेश्वर यहोवा के लिये जैसा वह हम से कहेगा वैसा ही बलिदान करेंगे।” ");
INSERT INTO hin2017_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","फ़िरौन ने कहा, “मैं तुम को जंगल में जाने दूँगा कि तुम अपने परमेश्वर यहोवा के लिये जंगल में बलिदान करो; केवल बहुत दूर न जाना, और मेरे लिये विनती करो।” ");
INSERT INTO hin2017_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","तब मूसा ने कहा, “सुन, मैं तेरे पास से बाहर जाकर यहोवा से विनती करूँगा कि डांसों के झुण्ड तेरे, और तेरे कर्मचारियों, और प्रजा के पास से कल ही दूर हों; पर फ़िरौन आगे को कपट करके हमें यहोवा के लिये बलिदान करने को जाने देने के लिये मना न करे।” ");
INSERT INTO hin2017_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","अतः मूसा ने फ़िरौन के पास से बाहर जाकर यहोवा से विनती की। ");
INSERT INTO hin2017_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","और यहोवा ने मूसा के कहे के अनुसार डांसों के झुण्डों को फ़िरौन, और उसके कर्मचारियों, और उसकी प्रजा से दूर किया; यहाँ तक कि एक भी न रहा। ");
INSERT INTO hin2017_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","तब फ़िरौन ने इस बार भी अपने मन को कठोर किया, और उन लोगों को जाने न दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","फिर यहोवा ने मूसा से कहा, “फ़िरौन के पास जाकर कह, ‘इब्रियों का परमेश्वर यहोवा तुझ से इस प्रकार कहता है, कि मेरी प्रजा के लोगों को जाने दे, कि मेरी उपासना करें। ");
INSERT INTO hin2017_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","और यदि तू उन्हें जाने न दे और अब भी पकड़े रहे, ");
INSERT INTO hin2017_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","तो सुन, तेरे जो घोड़े, गदहे, ऊँट, गाय-बैल, भेड़-बकरी आदि पशु मैदान में हैं, उन पर यहोवा का हाथ ऐसा पड़ेगा कि बहुत भारी मरी होगी। ");
INSERT INTO hin2017_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","परन्तु यहोवा इस्राएलियों के पशुओं में और मिस्रियों के पशुओं में ऐसा अन्तर करेगा कि जो इस्राएलियों के हैं उनमें से कोई भी न मरेगा।’” ");
INSERT INTO hin2017_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","फिर यहोवा ने यह कहकर एक समय ठहराया, “मैं यह काम इस देश में कल करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","दूसरे दिन यहोवा ने ऐसा ही किया; और मिस्र के तो सब पशु मर गए, परन्तु इस्राएलियों का एक भी पशु न मरा। ");
INSERT INTO hin2017_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","और फ़िरौन ने लोगों को भेजा, पर इस्राएलियों के पशुओं में से एक भी नहीं मरा था। तो भी फ़िरौन का मन कठोर हो गया, और उसने उन लोगों को जाने न दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","फिर यहोवा ने मूसा और हारून से कहा, “तुम दोनों भट्ठी में से एक-एक मुट्ठी राख ले लो, और मूसा उसे फ़िरौन के सामने आकाश की ओर उड़ा दे। ");
INSERT INTO hin2017_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","तब वह सूक्ष्म धूल होकर सारे मिस्र देश में मनुष्यों और पशुओं दोनों पर फफोले और फोड़े बन जाएगी।” ");
INSERT INTO hin2017_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","इसलिए वे भट्ठी में की राख लेकर फ़िरौन के सामने खड़े हुए, और मूसा ने उसे आकाश की ओर उड़ा दिया, और वह मनुष्यों और पशुओं दोनों पर फफोले और फोड़े बन गई। ");
INSERT INTO hin2017_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","उन फोड़ों के कारण जादूगर मूसा के सामने खड़े न रह सके, क्योंकि वे फोड़े जैसे सब मिस्रियों के वैसे ही जादूगरों के भी निकले थे। ");
INSERT INTO hin2017_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","तब यहोवा ने फ़िरौन के मन को कठोर कर दिया, और जैसा यहोवा ने मूसा से कहा था, उसने उसकी न सुनी। (रोम. 9:18) ");
INSERT INTO hin2017_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","फिर यहोवा ने मूसा से कहा, “सवेरे उठकर फ़िरौन के सामने खड़ा हो, और उससे कह, ‘इब्रियों का परमेश्वर यहोवा इस प्रकार कहता है, कि मेरी प्रजा के लोगों को जाने दे, कि वे मेरी उपासना करें। ");
INSERT INTO hin2017_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","नहीं तो अब की बार मैं तुझ पर, और तेरे कर्मचारियों और तेरी प्रजा पर सब प्रकार की विपत्तियाँ डालूँगा, जिससे तू जान ले कि सारी पृथ्वी पर मेरे तुल्य कोई दूसरा नहीं है। ");
INSERT INTO hin2017_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","मैंने तो अभी हाथ बढ़ाकर तुझे और तेरी प्रजा को मरी से मारा होता, और तू पृथ्वी पर से सत्यानाश हो गया होता; ");
INSERT INTO hin2017_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","परन्तु सचमुच मैंने इसी कारण तुझे बनाए रखा है कि तुझे अपना सामर्थ्य दिखाऊँ, और अपना नाम सारी पृथ्वी पर प्रसिद्ध करूँ। (प्रका. 9:17) ");
INSERT INTO hin2017_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","क्या तू अब भी मेरी प्रजा के सामने अपने आपको बड़ा समझता है, और उन्हें जाने नहीं देता? ");
INSERT INTO hin2017_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","सुन, कल मैं इसी समय ऐसे भारी-भारी ओले बरसाऊँगा, कि जिनके तुल्य मिस्र की नींव पड़ने के दिन से लेकर अब तक कभी नहीं पड़े। ");
INSERT INTO hin2017_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","इसलिए अब लोगों को भेजकर अपने पशुओं को और मैदान में जो कुछ तेरा है सब को फुर्ती से आड़ में छिपा ले; नहीं तो जितने मनुष्य या पशु मैदान में रहें और घर में इकट्ठे न किए जाएँ उन पर ओले गिरेंगे, और वे मर जाएँगे।’” ");
INSERT INTO hin2017_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","इसलिए फ़िरौन के कर्मचारियों में से जो लोग यहोवा के वचन का भय मानते थे उन्होंने तो अपने-अपने सेवकों और पशुओं को घर में हाँक दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","पर जिन्होंने यहोवा के वचन पर मन न लगाया उन्होंने अपने सेवकों और पशुओं को मैदान में रहने दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","तब यहोवा ने मूसा से कहा, “अपना हाथ आकाश की ओर बढ़ा कि सारे मिस्र देश के मनुष्यों, पशुओं और खेतों की सारी उपज पर ओले गिरें।” ");
INSERT INTO hin2017_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","तब मूसा ने अपनी लाठी को आकाश की ओर उठाया; और यहोवा की सामर्थ्य से मेघ गरजने और ओले बरसने लगे, और आग पृथ्वी तक आती रही। इस प्रकार यहोवा ने मिस्र देश पर ओले बरसाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","जो ओले गिरते थे उनके साथ आग भी मिली हुई थी, और वे ओले इतने भारी थे कि जब से मिस्र देश बसा था तब से मिस्र भर में ऐसे ओले कभी न गिरे थे। (प्रका. 8:7, प्रका. 11:19) ");
INSERT INTO hin2017_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","इसलिए मिस्र भर के खेतों में क्या मनुष्य, क्या पशु, जितने थे सब ओलों से मारे गए, और ओलों से खेत की सारी उपज नष्ट हो गई, और मैदान के सब वृक्ष भी टूट गए। ");
INSERT INTO hin2017_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","केवल गोशेन प्रदेश में जहाँ इस्राएली बसते थे ओले नहीं गिरे। ");
INSERT INTO hin2017_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","तब फ़िरौन ने मूसा और हारून को बुलवा भेजा और उनसे कहा, “इस बार मैंने पाप किया है; यहोवा धर्मी है, और मैं और मेरी प्रजा अधर्मी हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","मेघों का गरजना और ओलों का बरसना तो बहुत हो गया; अब यहोवा से विनती करो; तब मैं तुम लोगों को जाने दूँगा, और तुम न रोके जाओगे।” ");
INSERT INTO hin2017_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मूसा ने उससे कहा, “नगर से निकलते ही मैं यहोवा की ओर हाथ फैलाऊँगा, तब बादल का गरजना बन्द हो जाएगा, और ओले फिर न गिरेंगे, इससे तू जान लेगा कि पृथ्वी यहोवा ही की है। ");
INSERT INTO hin2017_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","तो भी मैं जानता हूँ, कि न तो तू और न तेरे कर्मचारी यहोवा परमेश्वर का भय मानेंगे।” ");
INSERT INTO hin2017_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","सन और जौ तो ओलों से मारे गए, क्योंकि जौ की बालें निकल चुकी थीं और सन में फूल लगे हुए थे। ");
INSERT INTO hin2017_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","पर गेहूँ और कठिया गेहूँ जो बढ़े न थे, इस कारण वे मारे न गए। ");
INSERT INTO hin2017_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","जब मूसा ने फ़िरौन के पास से नगर के बाहर निकलकर यहोवा की ओर हाथ फैलाए, तब बादल का गरजना और ओलों का बरसना बन्द हुआ, और फिर बहुत मेंह भूमि पर न पड़ा। ");
INSERT INTO hin2017_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","यह देखकर कि मेंह और ओलों और बादल का गरजना बन्द हो गया फ़िरौन ने अपने कर्मचारियों समेत फिर अपने मन को कठोर करके पाप किया। ");
INSERT INTO hin2017_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","इस प्रकार फ़िरौन का मन हठीला होता गया, और उसने इस्राएलियों को जाने न दिया; जैसा कि यहोवा ने मूसा के द्वारा कहलवाया था। ");
INSERT INTO hin2017_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","फिर यहोवा ने मूसा से कहा, “फ़िरौन के पास जा; क्योंकि मैं ही ने उसके और उसके कर्मचारियों के मन को इसलिए कठोर कर दिया है कि अपने चिन्ह उनके बीच में दिखलाऊँ, ");
INSERT INTO hin2017_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","और तुम लोग अपने बेटों और पोतों से इसका वर्णन करो कि यहोवा ने मिस्रियों को कैसे उपहास में उड़ाया और अपने क्या-क्या चिन्ह उनके बीच प्रगट किए हैं; जिससे तुम यह जान लोगे कि मैं यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","तब मूसा और हारून ने फ़िरौन के पास जाकर कहा, “इब्रियों का परमेश्वर यहोवा तुझ से इस प्रकार कहता है, कि तू कब तक मेरे सामने दीन होने से संकोच करता रहेगा? मेरी प्रजा के लोगों को जाने दे कि वे मेरी उपासना करें। ");
INSERT INTO hin2017_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","यदि तू मेरी प्रजा को जाने न दे तो सुन, कल मैं तेरे देश में टिड्डियाँ ले आऊँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","और वे धरती को ऐसा छा लेंगी कि वह देख न पड़ेगी; और तुम्हारा जो कुछ ओलों से बच रहा है उसको वे चट कर जाएँगी, और तुम्हारे जितने वृक्ष मैदान में लगे हैं उनको भी वे चट कर जाएँगी, ");
INSERT INTO hin2017_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","और वे तेरे और तेरे सारे कर्मचारियों, यहाँ तक सारे मिस्रियों के घरों में भर जाएँगी; इतनी टिड्डियाँ तेरे बापदादों ने या उनके पुरखाओं ने जब से पृथ्वी पर जन्मे तब से आज तक कभी न देखीं।” और वह मुँह फेरकर फ़िरौन के पास से बाहर गया। ");
INSERT INTO hin2017_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","तब फ़िरौन के कर्मचारी उससे कहने लगे, “वह जन कब तक हमारे लिये फंदा बना रहेगा? उन मनुष्यों को जाने दे कि वे अपने परमेश्वर यहोवा की उपासना करें; क्या तू अब तक नहीं जानता कि सारा मिस्र नाश हो गया है?” ");
INSERT INTO hin2017_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","तब मूसा और हारून फ़िरौन के पास फिर बुलवाए गए, और उसने उनसे कहा, “चले जाओ, अपने परमेश्वर यहोवा की उपासना करो; परन्तु वे जो जानेवाले हैं, कौन-कौन हैं?” ");
INSERT INTO hin2017_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मूसा ने कहा, “हम तो बेटों-बेटियों, भेड़-बकरियों, गाय-बैलों समेत वरन् बच्चों से बूढ़ों तक सब के सब जाएँगे, क्योंकि हमें यहोवा के लिये पर्व करना है।” ");
INSERT INTO hin2017_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","उसने इस प्रकार उनसे कहा, “यहोवा तुम्हारे संग रहे जबकि मैं तुम्हें बच्चों समेत जाने देता हूँ; देखो, तुम्हारे मन में बुराई है। ");
INSERT INTO hin2017_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","नहीं, ऐसा नहीं होने पाएगा; तुम पुरुष ही जाकर यहोवा की उपासना करो, तुम यही तो चाहते थे।” और वे फ़िरौन के सम्मुख से निकाल दिए गए। ");
INSERT INTO hin2017_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","तब यहोवा ने मूसा से कहा, “मिस्र देश के ऊपर अपना हाथ बढ़ा कि टिड्डियाँ मिस्र देश पर चढ़कर भूमि का जितना अन्न आदि ओलों से बचा है सब को चट कर जाएँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","अतः मूसा ने अपनी लाठी को मिस्र देश के ऊपर बढ़ाया, तब यहोवा ने दिन भर और रात भर देश पर पुरवाई बहाई; और जब भोर हुआ तब उस पुरवाई में टिड्डियाँ आईं। ");
INSERT INTO hin2017_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","और टिडि्डयों ने चढ़कर मिस्र देश के सारे स्थानों में बसेरा किया, उनका दल बहुत भारी था, वरन् न तो उनसे पहले ऐसी टिड्डियाँ आई थीं, और न उनके पीछे ऐसी फिर आएँगी। ");
INSERT INTO hin2017_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","वे तो सारी धरती पर छा गईं, यहाँ तक कि देश में अंधकार छा गया, और उसका सारा अन्न आदि और वृक्षों के सब फल, अर्थात् जो कुछ ओलों से बचा था, सब को उन्होंने चट कर लिया; यहाँ तक कि मिस्र देश भर में न तो किसी वृक्ष पर कुछ हरियाली रह गई और न खेत में अनाज रह गया। ");
INSERT INTO hin2017_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","तब फ़िरौन ने फुर्ती से मूसा और हारून को बुलवाकर कहा, “मैंने तो तुम्हारे परमेश्वर यहोवा का और तुम्हारा भी अपराध किया है। ");
INSERT INTO hin2017_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","इसलिए अब की बार मेरा अपराध क्षमा करो, और अपने परमेश्वर यहोवा से विनती करो कि वह केवल मेरे ऊपर से इस मृत्यु को दूर करे।” ");
INSERT INTO hin2017_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","तब मूसा ने फ़िरौन के पास से निकलकर यहोवा से विनती की। ");
INSERT INTO hin2017_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","तब यहोवा ने बहुत प्रचण्ड पश्चिमी हवा बहाकर टिड्डियों को उड़ाकर लाल समुद्र में डाल दिया, और मिस्र के किसी स्थान में एक भी टिड्डी न रह गई। ");
INSERT INTO hin2017_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","तो भी यहोवा ने फ़िरौन के मन को कठोर कर दिया, जिससे उसने इस्राएलियों को जाने न दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","फिर यहोवा ने मूसा से कहा, “अपना हाथ आकाश की ओर बढ़ा कि मिस्र देश के ऊपर अंधकार छा जाए, ऐसा अंधकार कि टटोला जा सके।” ");
INSERT INTO hin2017_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","तब मूसा ने अपना हाथ आकाश की ओर बढ़ाया, और सारे मिस्र देश में तीन दिन तक घोर अंधकार छाया रहा। ");
INSERT INTO hin2017_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","तीन दिन तक न तो किसी ने किसी को देखा, और न कोई अपने स्थान से उठा; परन्तु सारे इस्राएलियों के घरों में उजियाला रहा। ");
INSERT INTO hin2017_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","तब फ़िरौन ने मूसा को बुलवाकर कहा, “तुम लोग जाओ, यहोवा की उपासना करो; अपने बालकों को भी संग ले जाओ; केवल अपनी भेड़-बकरी और गाय-बैल को छोड़ जाओ।” ");
INSERT INTO hin2017_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","मूसा ने कहा, “तुझको हमारे हाथ मेलबलि और होमबलि के पशु भी देने पड़ेंगे, जिन्हें हम अपने परमेश्वर यहोवा के लिये चढ़ाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","इसलिए हमारे पशु भी हमारे संग जाएँगे, उनका एक खुर तक न रह जाएगा, क्योंकि उन्हीं में से हमको अपने परमेश्वर यहोवा की उपासना का सामान लेना होगा, और हम जब तक वहाँ न पहुँचें तब तक नहीं जानते कि क्या-क्या लेकर यहोवा की उपासना करनी होगी।” ");
INSERT INTO hin2017_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","पर यहोवा ने फ़िरौन का मन हठीला कर दिया, जिससे उसने उन्हें जाने न दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","तब फ़िरौन ने उससे कहा, “मेरे सामने से चला जा; और सचेत रह; मुझे अपना मुख फिर न दिखाना; क्योंकि जिस दिन तू मुझे मुँह दिखलाए उसी दिन तू मारा जाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","मूसा ने कहा, “तूने ठीक कहा है; मैं तेरे मुँह को फिर कभी न देखूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","फिर यहोवा ने मूसा से कहा, “एक और विपत्ति मैं फ़िरौन और मिस्र देश पर डालता हूँ, उसके पश्चात् वह तुम लोगों को वहाँ से जाने देगा; और जब वह जाने देगा तब तुम सभी को निश्चय निकाल देगा। ");
INSERT INTO hin2017_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","मेरी प्रजा को मेरी यह आज्ञा सुना कि एक-एक पुरुष अपने-अपने पड़ोसी, और एक-एक स्त्री अपनी-अपनी पड़ोसिन से सोने-चाँदी के गहने माँग ले।” ");
INSERT INTO hin2017_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","तब यहोवा ने मिस्रियों को अपनी प्रजा पर दयालु किया। और इससे अधिक वह पुरुष मूसा मिस्र देश में फ़िरौन के कर्मचारियों और साधारण लोगों की दृष्टि में अति महान था। ");
INSERT INTO hin2017_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","फिर मूसा ने कहा, “यहोवा इस प्रकार कहता है, कि आधी रात के लगभग मैं मिस्र देश के बीच में होकर चलूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","तब मिस्र में सिंहासन पर विराजनेवाले फ़िरौन से लेकर चक्की पीसनेवाली दासी तक के पहलौठे; वरन् पशुओं तक के सब पहलौठे मर जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","और सारे मिस्र देश में बड़ा हाहाकार मचेगा, यहाँ तक कि उसके समान न तो कभी हुआ और न होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","पर इस्राएलियों के विरुद्ध, क्या मनुष्य क्या पशु, किसी पर कोई कुत्ता भी न भौंकेगा; जिससे तुम जान लो कि मिस्रियों और इस्राएलियों में मैं यहोवा अन्तर करता हूँ। ");
INSERT INTO hin2017_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","तब तेरे ये सब कर्मचारी मेरे पास आ मुझे दण्डवत् करके यह कहेंगे, ‘अपने सब अनुचरों समेत निकल जा।’ और उसके पश्चात् मैं निकल जाऊँगा।” यह कहकर मूसा बड़े क्रोध में फ़िरौन के पास से निकल गया। ");
INSERT INTO hin2017_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","यहोवा ने मूसा से कह दिया था, “फ़िरौन तुम्हारी न सुनेगा; क्योंकि मेरी इच्छा है कि मिस्र देश में बहुत से चमत्कार करूँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","मूसा और हारून ने फ़िरौन के सामने ये सब चमत्कार किए; पर यहोवा ने फ़िरौन का मन और कठोर कर दिया, इसलिए उसने इस्राएलियों को अपने देश से जाने न दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","फिर यहोवा ने मिस्र देश में मूसा और हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“यह महीना तुम लोगों के लिये आरम्भ का ठहरे; अर्थात् वर्ष का पहला महीना यही ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","इस्राएल की सारी मण्डली से इस प्रकार कहो, कि इसी महीने के दसवें दिन को तुम अपने-अपने पितरों के घरानों के अनुसार, घराने पीछे एक-एक मेम्ना ले रखो। ");
INSERT INTO hin2017_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","और यदि किसी के घराने में एक मेम्ने के खाने के लिये मनुष्य कम हों, तो वह अपने सबसे निकट रहनेवाले पड़ोसी के साथ प्राणियों की गिनती के अनुसार एक मेम्ना ले रखे; और तुम हर एक के खाने के अनुसार मेम्ने का हिसाब करना। ");
INSERT INTO hin2017_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","तुम्हारा मेम्ना निर्दोष और पहले वर्ष का नर हो, और उसे चाहे भेड़ों में से लेना चाहे बकरियों में से। ");
INSERT INTO hin2017_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","और इस महीने के चौदहवें दिन तक उसे रख छोड़ना, और उस दिन सूर्यास्त के समय इस्राएल की सारी मण्डली के लोग उसे बलि करें। ");
INSERT INTO hin2017_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","तब वे उसके लहू में से कुछ लेकर जिन घरों में मेम्ने को खाएँगे उनके द्वार के दोनों ओर और चौखट के सिरे पर लगाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","और वे उसके माँस को उसी रात आग में भूनकर अख़मीरी रोटी और कड़वे सागपात के साथ खाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","उसको सिर, पैर, और अंतड़ियाँ समेत आग में भूनकर खाना, कच्चा या जल में कुछ भी पकाकर न खाना। ");
INSERT INTO hin2017_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","और उसमें से कुछ सवेरे तक न रहने देना, और यदि कुछ सवेरे तक रह भी जाए, तो उसे आग में जला देना। ");
INSERT INTO hin2017_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","और उसके खाने की यह विधि है; कि कमर बाँधे, पाँव में जूती पहने, और हाथ में लाठी लिए हुए उसे फुर्ती से खाना; वह तो यहोवा का फसह होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","क्योंकि उस रात को मैं मिस्र देश के बीच में से होकर जाऊँगा, और मिस्र देश के क्या मनुष्य क्या पशु, सब के पहिलौठों को मारूँगा; और मिस्र के सारे देवताओं को भी मैं दण्ड दूँगा; मैं तो यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","और जिन घरों में तुम रहोगे उन पर वह लहू तुम्हारे निमित्त चिन्ह ठहरेगा; अर्थात् मैं उस लहू को देखकर तुम को छोड़ जाऊँगा, और जब मैं मिस्र देश के लोगों को मारूँगा, तब वह विपत्ति तुम पर न पड़ेगी और तुम नाश न होंगे। ");
INSERT INTO hin2017_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","और वह दिन तुम को स्मरण दिलानेवाला ठहरेगा, और तुम उसको यहोवा के लिये पर्व करके मानना; वह दिन तुम्हारी पीढ़ियों में सदा की विधि जानकर पर्व माना जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“सात दिन तक अख़मीरी रोटी खाया करना, उनमें से पहले ही दिन अपने-अपने घर में से ख़मीर उठा डालना, वरन् जो पहले दिन से लेकर सातवें दिन तक कोई ख़मीरी वस्तु खाए, वह प्राणी इस्राएलियों में से नाश किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","पहले दिन एक पवित्र सभा, और सातवें दिन भी एक पवित्र सभा करना; उन दोनों दिनों में कोई काम न किया जाए; केवल जिस प्राणी का जो खाना हो उसके काम करने की आज्ञा है। ");
INSERT INTO hin2017_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","इसलिए तुम बिना ख़मीर की रोटी का पर्व मानना, क्योंकि उसी दिन मानो मैंने तुम को दल-दल करके मिस्र देश से निकाला है; इस कारण वह दिन तुम्हारी पीढ़ियों में सदा की विधि जानकर माना जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","पहले महीने के चौदहवें दिन की साँझ से लेकर इक्कीसवें दिन की साँझ तक तुम अख़मीरी रोटी खाया करना। ");
INSERT INTO hin2017_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","सात दिन तक तुम्हारे घरों में कुछ भी ख़मीर न रहे, वरन् जो कोई किसी ख़मीरी वस्तु को खाए, चाहे वह देशी हो चाहे परदेशी, वह प्राणी इस्राएलियों की मण्डली से नाश किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","कोई ख़मीरी वस्तु न खाना; अपने सब घरों में बिना ख़मीर की रोटी खाया करना।” ");
INSERT INTO hin2017_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","तब मूसा ने इस्राएल के सब पुरनियों को बुलाकर कहा, “तुम अपने-अपने कुल के अनुसार एक-एक मेम्ना अलग कर रखो, और फसह का पशुबलि करना। ");
INSERT INTO hin2017_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","और उसका लहू जो तसले में होगा उसमें जूफा का एक गुच्छा डुबाकर उसी तसले में के लहू से द्वार के चौखट के सिरे और दोनों ओर पर कुछ लगाना; और भोर तक तुम में से कोई घर से बाहर न निकले। ");
INSERT INTO hin2017_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","क्योंकि यहोवा देश के बीच होकर मिस्रियों को मारता जाएगा; इसलिए जहाँ-जहाँ वह चौखट के सिरे, और दोनों ओर पर उस लहू को देखेगा, वहाँ-वहाँ वह उस द्वार को छोड़ जाएगा, और नाश करनेवाले को तुम्हारे घरों में मारने के लिये न जाने देगा। ");
INSERT INTO hin2017_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","फिर तुम इस विधि को अपने और अपने वंश के लिये सदा की विधि जानकर माना करो। ");
INSERT INTO hin2017_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","जब तुम उस देश में जिसे यहोवा अपने कहने के अनुसार तुम को देगा प्रवेश करो, तब वह काम किया करना। ");
INSERT INTO hin2017_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","और जब तुम्हारे लड़के वाले तुम से पूछें, ‘इस काम से तुम्हारा क्या मतलब है?’ ");
INSERT INTO hin2017_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तब तुम उनको यह उत्तर देना, ‘यहोवा ने जो मिस्रियों के मारने के समय मिस्र में रहनेवाले हम इस्राएलियों के घरों को छोड़कर हमारे घरों को बचाया, इसी कारण उसके फसह का यह बलिदान किया जाता है।’” तब लोगों ने सिर झुकाकर दण्डवत् किया। ");
INSERT INTO hin2017_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","और इस्राएलियों ने जाकर, जो आज्ञा यहोवा ने मूसा और हारून को दी थी, उसी के अनुसार किया। ");
INSERT INTO hin2017_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ऐसा हुआ कि आधी रात को यहोवा ने मिस्र देश में सिंहासन पर विराजनेवाले फ़िरौन से लेकर गड्ढे में पड़े हुए बँधुए तक सब के पहिलौठों को, वरन् पशुओं तक के सब पहिलौठों को मार डाला। ");
INSERT INTO hin2017_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","और फ़िरौन रात ही को उठ बैठा, और उसके सब कर्मचारी, वरन् सारे मिस्री उठे; और मिस्र में बड़ा हाहाकार मचा, क्योंकि एक भी ऐसा घर न था जिसमें कोई मरा न हो। ");
INSERT INTO hin2017_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","तब फ़िरौन ने रात ही रात में मूसा और हारून को बुलवाकर कहा, “तुम इस्राएलियों समेत मेरी प्रजा के बीच से निकल जाओ; और अपने कहने के अनुसार जाकर यहोवा की उपासना करो। ");
INSERT INTO hin2017_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","अपने कहने के अनुसार अपनी भेड़-बकरियों और गाय-बैलों को साथ ले जाओ; और मुझे आशीर्वाद दे जाओ।” ");
INSERT INTO hin2017_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","और मिस्री जो कहते थे, ‘हम तो सब मर मिटे हैं,’ उन्होंने इस्राएली लोगों पर दबाव डालकर कहा, “देश से झटपट निकल जाओ।” ");
INSERT INTO hin2017_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","तब उन्होंने अपने गुँधे-गुँधाए आटे को बिना ख़मीर दिए ही कठौतियों समेत कपड़ों में बाँधकर अपने-अपने कंधे पर डाल लिया। ");
INSERT INTO hin2017_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","इस्राएलियों ने मूसा के कहने के अनुसार मिस्रियों से सोने-चाँदी के गहने और वस्त्र माँग लिए। ");
INSERT INTO hin2017_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","और यहोवा ने मिस्रियों को अपनी प्रजा के लोगों पर ऐसा दयालु किया कि उन्होंने जो-जो माँगा वह सब उनको दिया। इस प्रकार इस्राएलियों ने मिस्रियों को लूट लिया। ");
INSERT INTO hin2017_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","तब इस्राएली रामसेस से कूच करके सुक्कोत को चले, और बाल-बच्चों को छोड़ वे कोई छः लाख पैदल चलनेवाले पुरुष थे। ");
INSERT INTO hin2017_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","उनके साथ मिली-जुली हुई एक भीड़ गई, और भेड़-बकरी, गाय-बैल, बहुत से पशु भी साथ गए। ");
INSERT INTO hin2017_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","और जो गूँधा आटा वे मिस्र से साथ ले गए उसकी उन्होंने बिना ख़मीर दिए रोटियाँ बनाईं; क्योंकि वे मिस्र से ऐसे बरबस निकाले गए, कि उन्हें अवसर भी न मिला की मार्ग में खाने के लिये कुछ पका सके, इसी कारण वह गूँधा हुआ आटा बिना ख़मीर का था। ");
INSERT INTO hin2017_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","मिस्र में बसे हुए इस्राएलियों को चार सौ तीस वर्ष बीत गए थे। ");
INSERT INTO hin2017_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","और उन चार सौ तीस वर्षों के बीतने पर, ठीक उसी दिन, यहोवा की सारी सेना मिस्र देश से निकल गई। ");
INSERT INTO hin2017_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","यहोवा इस्राएलियों को मिस्र देश से निकाल लाया, इस कारण वह रात उसके निमित्त मानने के योग्य है; यह यहोवा की वही रात है जिसका पीढ़ी-पीढ़ी में मानना इस्राएलियों के लिये अवश्य है। ");
INSERT INTO hin2017_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","फिर यहोवा ने मूसा और हारून से कहा, “पर्व की विधि यह है; कि कोई परदेशी उसमें से न खाए; ");
INSERT INTO hin2017_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","पर जो किसी का मोल लिया हुआ दास हो, और तुम लोगों ने उसका खतना किया हो, वह तो उसमें से खा सकेगा। ");
INSERT INTO hin2017_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","पर परदेशी और मजदूर उसमें से न खाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","उसका खाना एक ही घर में हो; अर्थात् तुम उसके माँस में से कुछ घर से बाहर न ले जाना; और बलिपशु की कोई हड्डी न तोड़ना। ");
INSERT INTO hin2017_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","पर्व को मानना इस्राएल की सारी मण्डली का कर्तव्य है। ");
INSERT INTO hin2017_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","और यदि कोई परदेशी तुम लोगों के संग रहकर यहोवा के लिये पर्व को मानना चाहे, तो वह अपने यहाँ के सब पुरुषों का खतना कराए, तब वह समीप आकर उसको माने; और वह देशी मनुष्य के तुल्य ठहरेगा। पर कोई खतनारहित पुरुष उसमें से न खाने पाए। ");
INSERT INTO hin2017_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","उसकी व्यवस्था देशी और तुम्हारे बीच में रहनेवाले परदेशी दोनों के लिये एक ही हो।” ");
INSERT INTO hin2017_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","यह आज्ञा जो यहोवा ने मूसा और हारून को दी उसके अनुसार सारे इस्राएलियों ने किया। ");
INSERT INTO hin2017_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","और ठीक उसी दिन यहोवा इस्राएलियों को मिस्र देश से दल-दल करके निकाल ले गया। ");
INSERT INTO hin2017_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“क्या मनुष्य के क्या पशु के, इस्राएलियों में जितने अपनी-अपनी माँ के पहलौठे हों, उन्हें मेरे लिये पवित्र मानना; वह तो मेरा ही है।” ");
INSERT INTO hin2017_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","फिर मूसा ने लोगों से कहा, “इस दिन को स्मरण रखो, जिसमें तुम लोग दासत्व के घर, अर्थात् मिस्र से निकल आए हो; यहोवा तो तुम को वहाँ से अपने हाथ के बल से निकाल लाया; इसमें ख़मीरी रोटी न खाई जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","अबीब के महीने में आज के दिन तुम निकले हो। ");
INSERT INTO hin2017_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","इसलिए जब यहोवा तुम को कनानी, हित्ती, एमोरी, हिब्बी, और यबूसी लोगों के देश में पहुँचाएगा, जिसे देने की उसने तुम्हारे पुरखाओं से शपथ खाई थी, और जिसमें दूध और मधु की धारा बहती हैं, तब तुम इसी महीने में पर्व करना। ");
INSERT INTO hin2017_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","सात दिन तक अख़मीरी रोटी खाया करना, और सातवें दिन यहोवा के लिये पर्व मानना। ");
INSERT INTO hin2017_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","इन सातों दिनों में अख़मीरी रोटी खाई जाए; वरन् तुम्हारे देश भर में न ख़मीरी रोटी, न ख़मीर तुम्हारे पास देखने में आए। ");
INSERT INTO hin2017_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","और उस दिन तुम अपने-अपने पुत्रों को यह कहकर समझा देना, कि यह तो हम उसी काम के कारण करते हैं, जो यहोवा ने हमारे मिस्र से निकल आने के समय हमारे लिये किया था। ");
INSERT INTO hin2017_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","फिर यह तुम्हारे लिये तुम्हारे हाथ में एक चिन्ह होगा, और तुम्हारी आँखों के सामने स्मरण करानेवाली वस्तु ठहरे; जिससे यहोवा की व्यवस्था तुम्हारे मुँह पर रहे क्योंकि यहोवा ने तुम्हें अपने बलवन्त हाथों से मिस्र से निकाला है। ");
INSERT INTO hin2017_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","इस कारण तुम इस विधि को प्रतिवर्ष नियत समय पर माना करना। ");
INSERT INTO hin2017_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“फिर जब यहोवा उस शपथ के अनुसार, जो उसने तुम्हारे पुरखाओं से और तुम से भी खाई है, तुम्हें कनानियों के देश में पहुँचाकर उसको तुम्हें दे देगा, ");
INSERT INTO hin2017_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","तब तुम में से जितने अपनी-अपनी माँ के जेठे हों उनको, और तुम्हारे पशुओं में जो ऐसे हों उनको भी यहोवा के लिये अर्पण करना; सब नर बच्चे तो यहोवा के हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","और गदही के हर एक पहलौठे के बदले मेम्ना देकर उसको छुड़ा लेना, और यदि तुम उसे छुड़ाना न चाहो तो उसका गला तोड़ देना। पर अपने सब पहलौठे पुत्रों को बदला देकर छुड़ा लेना। ");
INSERT INTO hin2017_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","और आगे के दिनों में जब तुम्हारे पुत्र तुम से पूछें, ‘यह क्या है?’ तो उनसे कहना, ‘यहोवा हम लोगों को दासत्व के घर से, अर्थात् मिस्र देश से अपने हाथों के बल से निकाल लाया है। ");
INSERT INTO hin2017_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","उस समय जब फ़िरौन ने कठोर होकर हमको जाने देना न चाहा, तब यहोवा ने मिस्र देश में मनुष्य से लेकर पशु तक सब के पहिलौठों को मार डाला। इसी कारण पशुओं में से तो जितने अपनी-अपनी माँ के पहलौठे नर हैं, उन्हें हम यहोवा के लिये बलि करते हैं; पर अपने सब जेठे पुत्रों को हम बदला देकर छुड़ा लेते हैं।’ ");
INSERT INTO hin2017_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","यह तुम्हारे हाथों पर एक चिन्ह-सा और तुम्हारी भौहों के बीच टीका-सा ठहरे; क्योंकि यहोवा हम लोगों को मिस्र से अपने हाथों के बल से निकाल लाया है।” ");
INSERT INTO hin2017_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","जब फ़िरौन ने लोगों को जाने की आज्ञा दे दी, तब यद्यपि पलिश्तियों के देश में होकर जो मार्ग जाता है वह छोटा था; तो भी परमेश्वर यह सोचकर उनको उस मार्ग से नहीं ले गया कि कहीं ऐसा न हो कि जब ये लोग लड़ाई देखें तब पछताकर मिस्र को लौट आएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","इसलिए परमेश्वर उनको चक्कर खिलाकर लाल समुद्र के जंगल के मार्ग से ले चला। और इस्राएली पाँति बाँधे हुए मिस्र से निकल गए। ");
INSERT INTO hin2017_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","और मूसा यूसुफ की हड्डियों को साथ लेता गया; क्योंकि यूसुफ ने इस्राएलियों से यह कहकर, ‘परमेश्वर निश्चय तुम्हारी सुधि लेगा,’ उनको इस विषय की दृढ़ शपथ खिलाई थी कि वे उसकी हड्डियों को अपने साथ यहाँ से ले जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","फिर उन्होंने सुक्कोत से कूच करके जंगल की छोर पर एताम में डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","और यहोवा उन्हें दिन को मार्ग दिखाने के लिये बादल के खम्भे में, और रात को उजियाला देने के लिये आग के खम्भे में होकर उनके आगे-आगे चला करता था, जिससे वे रात और दिन दोनों में चल सके। ");
INSERT INTO hin2017_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","उसने न तो बादल के खम्भे को दिन में और न आग के खम्भे को रात में लोगों के आगे से हटाया। ");
INSERT INTO hin2017_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इस्राएलियों को आज्ञा दे, कि वे लौटकर मिग्दोल और समुद्र के बीच पीहहीरोत के सम्मुख, बाल-सपोन के सामने अपने डेरे खड़े करें, उसी के सामने समुद्र के तट पर डेरे खड़े करें। ");
INSERT INTO hin2017_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","तब फ़िरौन इस्राएलियों के विषय में सोचेगा, ‘वे देश के उलझनों में फँसे हैं और जंगल में घिर गए हैं।’ ");
INSERT INTO hin2017_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","तब मैं फ़िरौन के मन को कठोर कर दूँगा, और वह उनका पीछा करेगा, तब फ़िरौन और उसकी सारी सेना के द्वारा मेरी महिमा होगी; और मिस्री जान लेंगे कि मैं यहोवा हूँ।” और उन्होंने वैसा ही किया। ");
INSERT INTO hin2017_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","जब मिस्र के राजा को यह समाचार मिला कि वे लोग भाग गए, तब फ़िरौन और उसके कर्मचारियों का मन उनके विरुद्ध पलट गया, और वे कहने लगे, “हमने यह क्या किया, कि इस्राएलियों को अपनी सेवकाई से छुटकारा देकर जाने दिया?” ");
INSERT INTO hin2017_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","तब उसने अपना रथ तैयार करवाया और अपनी सेना को संग लिया। ");
INSERT INTO hin2017_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","उसने छः सौ अच्छे से अच्छे रथ वरन् मिस्र के सब रथ लिए और उन सभी पर सरदार बैठाए। ");
INSERT INTO hin2017_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","और यहोवा ने मिस्र के राजा फ़िरौन के मन को कठोर कर दिया। इसलिए उसने इस्राएलियों का पीछा किया; परन्तु इस्राएली तो बेखटके निकले चले जाते थे। ");
INSERT INTO hin2017_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","पर फ़िरौन के सब घोड़ों, और रथों, और सवारों समेत मिस्री सेना ने उनका पीछा करके उनके पास, जो पीहहीरोत के पास, बाल-सपोन के सामने, समुद्र के किनारे पर डेरे डालें पड़े थे, जा पहुँची। ");
INSERT INTO hin2017_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","जब फ़िरौन निकट आया, तब इस्राएलियों ने आँखें उठाकर क्या देखा, कि मिस्री हमारा पीछा किए चले आ रहे हैं; और इस्राएली अत्यन्त डर गए, और चिल्लाकर यहोवा की दुहाई दी। ");
INSERT INTO hin2017_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","और वे मूसा से कहने लगे, “क्या मिस्र में कब्रें न थीं जो तू हमको वहाँ से मरने के लिये जंगल में ले आया है? तूने हम से यह क्या किया कि हमको मिस्र से निकाल लाया? ");
INSERT INTO hin2017_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","क्या हम तुझ से मिस्र में यही बात न कहते रहे, कि हमें रहने दे कि हम मिस्रियों की सेवा करें? हमारे लिये जंगल में मरने से मिस्रियों कि सेवा करनी अच्छी थी।” ");
INSERT INTO hin2017_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","मूसा ने लोगों से कहा, “डरो मत, खड़े-खड़े वह उद्धार का काम देखो, जो यहोवा आज तुम्हारे लिये करेगा; क्योंकि जिन मिस्रियों को तुम आज देखते हो, उनको फिर कभी न देखोगे। ");
INSERT INTO hin2017_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","यहोवा आप ही तुम्हारे लिये लड़ेगा, इसलिए तुम चुपचाप रहो।” ");
INSERT INTO hin2017_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","तब यहोवा ने मूसा से कहा, “तू क्यों मेरी दुहाई दे रहा है? इस्राएलियों को आज्ञा दे कि यहाँ से कूच करें। ");
INSERT INTO hin2017_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","और तू अपनी लाठी उठाकर अपना हाथ समुद्र के ऊपर बढ़ा, और वह दो भाग हो जाएगा; तब इस्राएली समुद्र के बीच होकर स्थल ही स्थल पर चले जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","और सुन, मैं आप मिस्रियों के मन को कठोर करता हूँ, और वे उनका पीछा करके समुद्र में घुस पड़ेंगे, तब फ़िरौन और उसकी सेना, और रथों, और सवारों के द्वारा मेरी महिमा होगी। ");
INSERT INTO hin2017_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","और जब फ़िरौन, और उसके रथों, और सवारों के द्वारा मेरी महिमा होगी, तब मिस्री जान लेंगे कि मैं यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","तब परमेश्वर का दूत जो इस्राएली सेना के आगे-आगे चला करता था जाकर उनके पीछे हो गया; और बादल का खम्भा उनके आगे से हटकर उनके पीछे जा ठहरा। ");
INSERT INTO hin2017_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","इस प्रकार वह मिस्रियों की सेना और इस्राएलियों की सेना के बीच में आ गया; और बादल और अंधकार तो हुआ, तो भी उससे रात को उन्हें प्रकाश मिलता रहा; और वे रात भर एक दूसरे के पास न आए। ");
INSERT INTO hin2017_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","तब मूसा ने अपना हाथ समुद्र के ऊपर बढ़ाया; और यहोवा ने रात भर प्रचण्ड पुरवाई चलाई, और समुद्र को दो भाग करके जल ऐसा हटा दिया, जिससे कि उसके बीच सूखी भूमि हो गई। ");
INSERT INTO hin2017_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","तब इस्राएली समुद्र के बीच स्थल ही स्थल पर होकर चले, और जल उनकी दाहिनी और बाईं ओर दीवार का काम देता था। ");
INSERT INTO hin2017_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","तब मिस्री, अर्थात् फ़िरौन के सब घोड़े, रथ, और सवार उनका पीछा किए हुए समुद्र के बीच में चले गए। ");
INSERT INTO hin2017_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","और रात के अन्तिम पहर में यहोवा ने बादल और आग के खम्भे में से मिस्रियों की सेना पर दृष्टि करके उन्हें घबरा दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","और उसने उनके रथों के पहियों को निकाल डाला, जिससे उनका चलना कठिन हो गया; तब मिस्री आपस में कहने लगे, “आओ, हम इस्राएलियों के सामने से भागें; क्योंकि यहोवा उनकी ओर से मिस्रियों के विरुद्ध युद्ध कर रहा है।” ");
INSERT INTO hin2017_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","फिर यहोवा ने मूसा से कहा, “अपना हाथ समुद्र के ऊपर बढ़ा, कि जल मिस्रियों, और उनके रथों, और सवारों पर फिर बहने लगे।” ");
INSERT INTO hin2017_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","तब मूसा ने अपना हाथ समुद्र के ऊपर बढ़ाया, और भोर होते-होते क्या हुआ कि समुद्र फिर ज्यों का त्यों अपने बल पर आ गया; और मिस्री उलटे भागने लगे, परन्तु यहोवा ने उनको समुद्र के बीच ही में झटक दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","और जल के पलटने से, जितने रथ और सवार इस्राएलियों के पीछे समुद्र में आए थे, वे सब वरन् फ़िरौन की सारी सेना उसमें डूब गई, और उसमें से एक भी न बचा। ");
INSERT INTO hin2017_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","परन्तु इस्राएली समुद्र के बीच स्थल ही स्थल पर होकर चले गए, और जल उनकी दाहिनी और बाईं दोनों ओर दीवार का काम देता था। ");
INSERT INTO hin2017_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","इस प्रकार यहोवा ने उस दिन इस्राएलियों को मिस्रियों के वश से इस प्रकार छुड़ाया; और इस्राएलियों ने मिस्रियों को समुद्र के तट पर मरे पड़े हुए देखा। ");
INSERT INTO hin2017_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","और यहोवा ने मिस्रियों पर जो अपना पराक्रम दिखलाता था, उसको देखकर इस्राएलियों ने यहोवा का भय माना और यहोवा की और उसके दास मूसा की भी प्रतीति की। ");
INSERT INTO hin2017_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","तब मूसा और इस्राएलियों ने यहोवा के लिये यह गीत गाया। उन्होंने कहा, “मैं यहोवा का गीत गाऊँगा, क्योंकि वह महाप्रतापी ठहरा है; घोड़ों समेत सवारों को उसने समुद्र में डाल दिया है। ");
INSERT INTO hin2017_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","यहोवा मेरा बल और भजन का विषय है, और वही मेरा उद्धार भी ठहरा है; मेरा परमेश्वर वही है, मैं उसी की स्तुति करूँगा, (मैं उसके लिये निवास-स्थान बनाऊँगा), मेरे पूर्वजों का परमेश्वर वही है, मैं उसको सराहूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","यहोवा योद्धा है; उसका नाम यहोवा है। ");
INSERT INTO hin2017_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","फ़िरौन के रथों और सेना को उसने समुद्र में डाल दिया; और उसके उत्तम से उत्तम रथी लाल समुद्र में डूब गए। ");
INSERT INTO hin2017_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","गहरे जल ने उन्हें ढाँप लिया; वे पत्थर के समान गहरे स्थानों में डूब गए। ");
INSERT INTO hin2017_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","हे यहोवा, तेरा दाहिना हाथ शक्ति में महाप्रतापी हुआ हे यहोवा, तेरा दाहिना हाथ शत्रु को चकनाचूर कर देता है। ");
INSERT INTO hin2017_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","तू अपने विरोधियों को अपने महाप्रताप से गिरा देता है; तू अपना कोप भड़काता, और वे भूसे के समान भस्म हो जाते हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","तेरे नथनों की साँस से जल एकत्र हो गया, धाराएँ ढेर के समान थम गईं; समुद्र के मध्य में गहरा जल जम गया। ");
INSERT INTO hin2017_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","शत्रु ने कहा था, मैं पीछा करूँगा, मैं जा पकड़ूँगा, मैं लूट के माल को बाँट लूँगा, उनसे मेरा जी भर जाएगा। मैं अपनी तलवार खींचते ही अपने हाथ से उनको नाश कर डालूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","तूने अपने श्वास का पवन चलाया, तब समुद्र ने उनको ढाँप लिया; वे समुद्र में सीसे के समान डूब गए। ");
INSERT INTO hin2017_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","हे यहोवा, देवताओं में तेरे तुल्य कौन है? तू तो पवित्रता के कारण महाप्रतापी, और अपनी स्तुति करनेवालों के भय के योग्य, और आश्चर्यकर्मों का कर्ता है। ");
INSERT INTO hin2017_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","तूने अपना दाहिना हाथ बढ़ाया, और पृथ्वी ने उनको निगल लिया है। ");
INSERT INTO hin2017_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","अपनी करुणा से तूने अपनी छुड़ाई हुई प्रजा की अगुआई की है, अपने बल से तू उसे अपने पवित्र निवास-स्थान को ले चला है। ");
INSERT INTO hin2017_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","देश-देश के लोग सुनकर काँप उठेंगे; पलिश्तियों के प्राणों के लाले पड़ जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","एदोम के अधिपति व्याकुल होंगे; मोआब के पहलवान थरथरा उठेंगे; सब कनान निवासियों के मन पिघल जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","उनमें डर और घबराहट समा जाएगा; तेरी बाँह के प्रताप से वे पत्थर के समान अबोल होंगे, जब तक, हे यहोवा, तेरी प्रजा के लोग निकल न जाएँ, जब तक तेरी प्रजा के लोग जिनको तूने मोल लिया है पार न निकल जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","तू उन्हें पहुँचाकर अपने निज भागवाले पहाड़ पर बसाएगा, यह वही स्थान है, हे यहोवा जिसे तूने अपने निवास के लिये बनाया, और वही पवित्रस्थान है जिसे, हे प्रभु, तूने आप ही स्थिर किया है। ");
INSERT INTO hin2017_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","यहोवा सदा सर्वदा राज्य करता रहेगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","यह गीत गाने का कारण यह है, कि फ़िरौन के घोड़े रथों और सवारों समेत समुद्र के बीच में चले गए, और यहोवा उनके ऊपर समुद्र का जल लौटा ले आया; परन्तु इस्राएली समुद्र के बीच स्थल ही स्थल पर होकर चले गए। ");
INSERT INTO hin2017_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","तब हारून की बहन मिर्याम नाम नबिया ने हाथ में डफ लिया; और सब स्त्रियाँ डफ लिए नाचती हुई उसके पीछे हो लीं। ");
INSERT INTO hin2017_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","और मिर्याम उनके साथ यह टेक गाती गई कि: “यहोवा का गीत गाओ, क्योंकि वह महाप्रतापी ठहरा है; घोड़ों समेत सवारों को उसने समुद्र में डाल दिया है।” ");
INSERT INTO hin2017_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","तब मूसा इस्राएलियों को लाल समुद्र से आगे ले गया, और वे शूर नामक जंगल में आए; और जंगल में जाते हुए तीन दिन तक पानी का सोता न मिला। ");
INSERT INTO hin2017_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","फिर मारा नामक एक स्थान पर पहुँचे, वहाँ का पानी खारा था, उसे वे न पी सके; इस कारण उस स्थान का नाम मारा पड़ा। ");
INSERT INTO hin2017_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","तब वे यह कहकर मूसा के विरुद्ध बड़बड़ाने लगे, “हम क्या पीएँ?” ");
INSERT INTO hin2017_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","तब मूसा ने यहोवा की दुहाई दी, और यहोवा ने उसे एक पौधा बता दिया, जिसे जब उसने पानी में डाला, तब वह पानी मीठा हो गया। वहीं यहोवा ने उनके लिये एक विधि और नियम बनाया, और वहीं उसने यह कहकर उनकी परीक्षा की, ");
INSERT INTO hin2017_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“यदि तू अपने परमेश्वर यहोवा का वचन तन मन से सुने, और जो उसकी दृष्टि में ठीक है वही करे, और उसकी आज्ञाओं पर कान लगाए और उसकी सब विधियों को माने, तो जितने रोग मैंने मिस्रियों पर भेजे हैं उनमें से एक भी तुझ पर न भेजूँगा; क्योंकि मैं तुम्हारा चंगा करनेवाला यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","तब वे एलीम को आए, जहाँ पानी के बारह सोते और सत्तर खजूर के पेड़ थे; और वहाँ उन्होंने जल के पास डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","फिर एलीम से कूच करके इस्राएलियों की सारी मण्डली, मिस्र देश से निकलने के बाद दूसरे महीने के पंद्रहवे दिन को, सीन नामक जंगल में, जो एलीम और सीनै पर्वत के बीच में है, आ पहुँची। ");
INSERT INTO hin2017_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","जंगल में इस्राएलियों की सारी मण्डली मूसा और हारून के विरुद्ध बुड़बुड़ाने लगे। ");
INSERT INTO hin2017_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","और इस्राएली उनसे कहने लगे, “जब हम मिस्र देश में माँस की हाँड़ियों के पास बैठकर मनमाना भोजन खाते थे, तब यदि हम यहोवा के हाथ से मार डाले भी जाते तो उत्तम वही था; पर तुम हमको इस जंगल में इसलिए निकाल ले आए हो कि इस सारे समाज को भूखा मार डालो।” ");
INSERT INTO hin2017_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","तब यहोवा ने मूसा से कहा, “देखो, मैं तुम लोगों के लिये आकाश से भोजनवस्तु बरसाऊँगा; और ये लोग प्रतिदिन बाहर जाकर प्रतिदिन का भोजन इकट्ठा करेंगे, इससे मैं उनकी परीक्षा करूँगा, कि ये मेरी व्यवस्था पर चलेंगे कि नहीं। ");
INSERT INTO hin2017_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","और ऐसा होगा कि छठवें दिन वह भोजन और दिनों से दूना होगा, इसलिए जो कुछ वे उस दिन बटोरें उसे तैयार कर रखें।” ");
INSERT INTO hin2017_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","तब मूसा और हारून ने सारे इस्राएलियों से कहा, “साँझ को तुम जान लोगे कि जो तुम को मिस्र देश से निकाल ले आया है वह यहोवा है। ");
INSERT INTO hin2017_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","और भोर को तुम्हें यहोवा का तेज देख पड़ेगा, क्योंकि तुम जो यहोवा पर बुड़बुड़ाते हो उसे वह सुनता है। और हम क्या हैं कि तुम हम पर बुड़बुड़ाते हो?” ");
INSERT INTO hin2017_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","फिर मूसा ने कहा, “यह तब होगा जब यहोवा साँझ को तुम्हें खाने के लिये माँस और भोर को रोटी मनमाने देगा; क्योंकि तुम जो उस पर बुड़बुड़ाते हो उसे वह सुनता है। और हम क्या हैं? तुम्हारा बुड़बुड़ाना हम पर नहीं यहोवा ही पर होता है।” ");
INSERT INTO hin2017_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","फिर मूसा ने हारून से कहा, “इस्राएलियों की सारी मण्डली को आज्ञा दे, कि यहोवा के सामने वरन् उसके समीप आए, क्योंकि उसने उनका बुड़बुड़ाना सुना है।” ");
INSERT INTO hin2017_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","और ऐसा हुआ कि जब हारून इस्राएलियों की सारी मण्डली से ऐसी ही बातें कर रहा था, कि उन्होंने जंगल की ओर दृष्टि करके देखा, और उनको यहोवा का तेज बादल में दिखलाई दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“इस्राएलियों का बुड़बुड़ाना मैंने सुना है; उनसे कह दे, कि सूर्यास्त के समय तुम माँस खाओगे और भोर को तुम रोटी से तृप्त हो जाओगे; और तुम यह जान लोगे कि मैं तुम्हारा परमेश्वर यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","तब ऐसा हुआ कि साँझ को बटेरें आकर सारी छावनी पर बैठ गईं; और भोर को छावनी के चारों ओर ओस पड़ी। ");
INSERT INTO hin2017_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","और जब ओस सूख गई तो वे क्या देखते हैं, कि जंगल की भूमि पर छोटे-छोटे छिलके पाले के किनकों के समान पड़े हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","यह देखकर इस्राएली, जो न जानते थे कि यह क्या वस्तु है, वे आपस में कहने लगे यह तो मन्ना है। तब मूसा ने उनसे कहा, “यह तो वही भोजनवस्तु है जिसे यहोवा तुम्हें खाने के लिये देता है। ");
INSERT INTO hin2017_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","जो आज्ञा यहोवा ने दी है वह यह है, कि तुम उसमें से अपने-अपने खाने के योग्य बटोरा करना, अर्थात् अपने-अपने प्राणियों की गिनती के अनुसार, प्रति मनुष्य के पीछे एक-एक ओमेर बटोरना; जिसके डेरे में जितने हों वह उन्हीं के लिये बटोरा करे।” ");
INSERT INTO hin2017_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","और इस्राएलियों ने वैसा ही किया; और किसी ने अधिक, और किसी ने थोड़ा बटोर लिया। ");
INSERT INTO hin2017_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","जब उन्होंने उसको ओमेर से नापा, तब जिसके पास अधिक था उसके कुछ अधिक न रह गया, और जिसके पास थोड़ा था उसको कुछ घटी न हुई; क्योंकि एक-एक मनुष्य ने अपने खाने के योग्य ही बटोर लिया था। ");
INSERT INTO hin2017_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","फिर मूसा ने उनसे कहा, “कोई इसमें से कुछ सवेरे तक न रख छोड़े।” ");
INSERT INTO hin2017_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","तो भी उन्होंने मूसा की बात न मानी; इसलिए जब किसी किसी मनुष्य ने उसमें से कुछ सवेरे तक रख छोड़ा, तो उसमें कीड़े पड़ गए और वह बसाने लगा; तब मूसा उन पर क्रोधित हुआ। ");
INSERT INTO hin2017_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","वे भोर को प्रतिदिन अपने-अपने खाने के योग्य बटोर लेते थे, और जब धूप कड़ी होती थी, तब वह गल जाता था। ");
INSERT INTO hin2017_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","फिर ऐसा हुआ कि छठवें दिन उन्होंने दूना, अर्थात् प्रति मनुष्य के पीछे दो-दो ओमेर बटोर लिया, और मण्डली के सब प्रधानों ने आकर मूसा को बता दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","उसने उनसे कहा, “यह तो वही बात है जो यहोवा ने कही, क्योंकि कल पवित्र विश्राम, अर्थात् यहोवा के लिये पवित्र विश्राम होगा; इसलिए तुम्हें जो तंदूर में पकाना हो उसे पकाओ, और जो सिझाना हो उसे सिझाओ, और इसमें से जितना बचे उसे सवेरे के लिये रख छोड़ो।” ");
INSERT INTO hin2017_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","जब उन्होंने उसको मूसा की इस आज्ञा के अनुसार सवेरे तक रख छोड़ा, तब न तो वह बसाया, और न उसमें कीड़े पड़े। ");
INSERT INTO hin2017_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","तब मूसा ने कहा, “आज उसी को खाओ, क्योंकि आज यहोवा का विश्रामदिन है; इसलिए आज तुम को वह मैदान में न मिलेगा। ");
INSERT INTO hin2017_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","छः दिन तो तुम उसे बटोरा करोगे; परन्तु सातवाँ दिन तो विश्राम का दिन है, उसमें वह न मिलेगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","तो भी लोगों में से कोई-कोई सातवें दिन भी बटोरने के लिये बाहर गए, परन्तु उनको कुछ न मिला। ");
INSERT INTO hin2017_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","तब यहोवा ने मूसा से कहा, “तुम लोग मेरी आज्ञाओं और व्यवस्था को कब तक नहीं मानोगे? ");
INSERT INTO hin2017_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","देखो, यहोवा ने जो तुम को विश्राम का दिन दिया है, इसी कारण वह छठवें दिन को दो दिन का भोजन तुम्हें देता है; इसलिए तुम अपने-अपने यहाँ बैठे रहना, सातवें दिन कोई अपने स्थान से बाहर न जाना।” ");
INSERT INTO hin2017_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","अतः लोगों ने सातवें दिन विश्राम किया। ");
INSERT INTO hin2017_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इस्राएल के घराने ने उस वस्तु का नाम मन्ना रखा; और वह धनिया के समान श्वेत था, और उसका स्वाद मधु के बने हुए पूए का सा था। ");
INSERT INTO hin2017_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","फिर मूसा ने कहा, “यहोवा ने जो आज्ञा दी वह यह है, कि इसमें से ओमेर भर अपने वंश की पीढ़ी-पीढ़ी के लिये रख छोड़ो, जिससे वे जानें कि यहोवा हमको मिस्र देश से निकालकर जंगल में कैसी रोटी खिलाता था।” ");
INSERT INTO hin2017_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","तब मूसा ने हारून से कहा, “एक पात्र लेकर उसमें ओमेर भर लेकर उसे यहोवा के आगे रख दे, कि वह तुम्हारी पीढ़ियों के लिये रखा रहे।” ");
INSERT INTO hin2017_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","जैसी आज्ञा यहोवा ने मूसा को दी थी, उसी के अनुसार हारून ने उसको साक्षी के सन्दूक के आगे रख दिया, कि वह वहीं रखा रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इस्राएली जब तक बसे हुए देश में न पहुँचे तब तक, अर्थात् चालीस वर्ष तक मन्ना खाते रहे; वे जब तक कनान देश की सीमा पर नहीं पहुँचे तब तक मन्ना खाते रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","एक ओमेर तो एपा का दसवाँ भाग है। ");
INSERT INTO hin2017_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","फिर इस्राएलियों की सारी मण्डली सीन नामक जंगल से निकल चली, और यहोवा के आज्ञानुसार कूच करके रपीदीम में अपने डेरे खड़े किए; और वहाँ उन लोगों को पीने का पानी न मिला। ");
INSERT INTO hin2017_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","इसलिए वे मूसा से वाद-विवाद करके कहने लगे, “हमें पीने का पानी दे।” मूसा ने उनसे कहा, “तुम मुझसे क्यों वाद-विवाद करते हो? और यहोवा की परीक्षा क्यों करते हो?” ");
INSERT INTO hin2017_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","फिर वहाँ लोगों को पानी की प्यास लगी तब वे यह कहकर मूसा पर बुड़बुड़ाने लगे, “तू हमें बाल-बच्चों और पशुओं समेत प्यासा मार डालने के लिये मिस्र से क्यों ले आया है?” ");
INSERT INTO hin2017_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","तब मूसा ने यहोवा की दुहाई दी, और कहा, “इन लोगों से मैं क्या करूँ? ये सब मुझे पथरवाह करने को तैयार हैं।” ");
INSERT INTO hin2017_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","यहोवा ने मूसा से कहा, “इस्राएल के वृद्ध लोगों में से कुछ को अपने साथ ले ले; और जिस लाठी से तूने नील नदी पर मारा था, उसे अपने हाथ में लेकर लोगों के आगे बढ़ चल। ");
INSERT INTO hin2017_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","देख मैं तेरे आगे चलकर होरेब पहाड़ की एक चट्टान पर खड़ा रहूँगा; और तू उस चट्टान पर मारना, तब उसमें से पानी निकलेगा जिससे ये लोग पीएँ।” तब मूसा ने इस्राएल के वृद्ध लोगों के देखते वैसा ही किया। ");
INSERT INTO hin2017_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","और मूसा ने उस स्थान का नाम मस्सा और मरीबा रखा, क्योंकि इस्राएलियों ने वहाँ वाद-विवाद किया था, और यहोवा की परीक्षा यह कहकर की, “क्या यहोवा हमारे बीच है या नहीं?” ");
INSERT INTO hin2017_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","तब अमालेकी आकर रपीदीम में इस्राएलियों से लड़ने लगे। ");
INSERT INTO hin2017_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","तब मूसा ने यहोशू से कहा, “हमारे लिये कई एक पुरुषों को चुनकर छाँट ले, और बाहर जाकर अमालेकियों से लड़; और मैं कल परमेश्वर की लाठी हाथ में लिये हुए पहाड़ी की चोटी पर खड़ा रहूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","मूसा की इस आज्ञा के अनुसार यहोशू अमालेकियों से लड़ने लगा; और मूसा, हारून, और हूर पहाड़ी की चोटी पर चढ़ गए। ");
INSERT INTO hin2017_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","और जब तक मूसा अपना हाथ उठाए रहता था तब तक तो इस्राएल प्रबल होता था; परन्तु जब जब वह उसे नीचे करता तब-तब अमालेक प्रबल होता था। ");
INSERT INTO hin2017_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","और जब मूसा के हाथ भर गए, तब उन्होंने एक पत्थर लेकर मूसा के नीचे रख दिया, और वह उस पर बैठ गया, और हारून और हूर एक-एक ओर में उसके हाथों को सम्भाले रहे; और उसके हाथ सूर्यास्त तक स्थिर रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","और यहोशू ने अनुचरों समेत अमालेकियों को तलवार के बल से हरा दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","तब यहोवा ने मूसा से कहा, “स्मरणार्थ इस बात को पुस्तक में लिख ले और यहोशू को सुना दे कि मैं आकाश के नीचे से अमालेक का स्मरण भी पूरी रीति से मिटा डालूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","तब मूसा ने एक वेदी बनाकर उसका नाम ‘यहोवा निस्सी’ रखा; ");
INSERT INTO hin2017_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","और कहा, “यहोवा ने शपथ खाई है कि यहोवा अमालेकियों से पीढ़ियों तक लड़ाई करता रहेगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","जब मूसा के ससुर मिद्यान के याजक यित्रो ने यह सुना, कि परमेश्वर ने मूसा और अपनी प्रजा इस्राएल के लिये क्या-क्या किया है, अर्थात् यह कि किस रीति से यहोवा इस्राएलियों को मिस्र से निकाल ले आया। ");
INSERT INTO hin2017_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","तब मूसा के ससुर यित्रो मूसा की पत्नी सिप्पोरा को, जो पहले अपने पिता के घर भेज दी गई थी, ");
INSERT INTO hin2017_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","और उसके दोनों बेटों को भी ले आया; इनमें से एक का नाम मूसा ने यह कहकर गेर्शोम रखा था, “मैं अन्य देश में परदेशी हुआ हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","और दूसरे का नाम उसने यह कहकर एलीएजेर रखा, “मेरे पिता के परमेश्वर ने मेरा सहायक होकर मुझे फ़िरौन की तलवार से बचाया।” ");
INSERT INTO hin2017_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","मूसा की पत्नी और पुत्रों को उसका ससुर यित्रो संग लिए मूसा के पास जंगल के उस स्थान में आया, जहाँ परमेश्वर के पर्वत के पास उसका डेरा पड़ा था। ");
INSERT INTO hin2017_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","और आकर उसने मूसा के पास यह कहला भेजा, “मैं तेरा ससुर यित्रो हूँ, और दोनों बेटों समेत तेरी पत्नी को तेरे पास ले आया हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","तब मूसा अपने ससुर से भेंट करने के लिये निकला, और उसको दण्डवत् करके चूमा; और वे परस्पर कुशलता पूछते हुए डेरे पर आ गए। ");
INSERT INTO hin2017_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","वहाँ मूसा ने अपने ससुर से वर्णन किया कि यहोवा ने इस्राएलियों के निमित्त फ़िरौन और मिस्रियों से क्या-क्या किया, और इस्राएलियों ने मार्ग में क्या-क्या कष्ट उठाया, फिर यहोवा उन्हें कैसे-कैसे छुड़ाता आया है। ");
INSERT INTO hin2017_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","तब यित्रो ने उस समस्त भलाई के कारण जो यहोवा ने इस्राएलियों के साथ की थी कि उन्हें मिस्रियों के वश से छुड़ाया था, मगन होकर कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","“धन्य है यहोवा, जिसने तुम को फ़िरौन और मिस्रियों के वश से छुड़ाया, जिसने तुम लोगों को मिस्रियों की मुट्ठी में से छुड़ाया है। ");
INSERT INTO hin2017_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","अब मैंने जान लिया है कि यहोवा सब देवताओं से बड़ा है; वरन् उस विषय में भी जिसमें उन्होंने इस्राएलियों के साथ अहंकारपूर्ण व्यवहार किया था।” ");
INSERT INTO hin2017_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","तब मूसा के ससुर यित्रो ने परमेश्वर के लिये होमबलि और मेलबलि चढ़ाए, और हारून इस्राएलियों के सब पुरनियों समेत मूसा के ससुर यित्रो के संग परमेश्वर के आगे भोजन करने को आया। ");
INSERT INTO hin2017_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","दूसरे दिन मूसा लोगों का न्याय करने को बैठा, और भोर से साँझ तक लोग मूसा के आस-पास खड़े रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","यह देखकर कि मूसा लोगों के लिये क्या-क्या करता है, उसके ससुर ने कहा, “यह क्या काम है जो तू लोगों के लिये करता है? क्या कारण है कि तू अकेला बैठा रहता है, और लोग भोर से साँझ तक तेरे आस-पास खड़े रहते हैं?” ");
INSERT INTO hin2017_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मूसा ने अपने ससुर से कहा, “इसका कारण यह है कि लोग मेरे पास परमेश्वर से पूछने आते हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","जब जब उनका कोई मुकद्दमा होता है तब-तब वे मेरे पास आते हैं और मैं उनके बीच न्याय करता, और परमेश्वर की विधि और व्यवस्था उन्हें समझाता हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","मूसा के ससुर ने उससे कहा, “जो काम तू करता है वह अच्छा नहीं। ");
INSERT INTO hin2017_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","और इससे तू क्या, वरन् ये लोग भी जो तेरे संग हैं निश्चय थक जाएँगे, क्योंकि यह काम तेरे लिये बहुत भारी है; तू इसे अकेला नहीं कर सकता। ");
INSERT INTO hin2017_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","इसलिए अब मेरी सुन ले, मैं तुझको सम्मति देता हूँ, और परमेश्वर तेरे संग रहे। तू तो इन लोगों के लिये परमेश्वर के सम्मुख जाया कर, और इनके मुकद्दमों को परमेश्वर के पास तू पहुँचा दिया कर। ");
INSERT INTO hin2017_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","इन्हें विधि और व्यवस्था प्रगट कर करके, जिस मार्ग पर इन्हें चलना, और जो-जो काम इन्हें करना हो, वह इनको समझा दिया कर। ");
INSERT INTO hin2017_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","फिर तू इन सब लोगों में से ऐसे पुरुषों को छाँट ले, जो गुणी, और परमेश्वर का भय माननेवाले, सच्चे, और अन्याय के लाभ से घृणा करनेवाले हों; और उनको हजार-हजार, सौ-सौ, पचास-पचास, और दस-दस मनुष्यों पर प्रधान नियुक्त कर दे। ");
INSERT INTO hin2017_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","और वे सब समय इन लोगों का न्याय किया करें; और सब बड़े-बड़े मुकद्दमों को तो तेरे पास ले आया करें, और छोटे-छोटे मुकद्दमों का न्याय आप ही किया करें; तब तेरा बोझ हलका होगा, क्योंकि इस बोझ को वे भी तेरे साथ उठाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","यदि तू यह उपाय करे, और परमेश्वर तुझको ऐसी आज्ञा दे, तो तू ठहर सकेगा, और ये सब लोग अपने स्थान को कुशल से पहुँच सकेंगे।” ");
INSERT INTO hin2017_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","अपने ससुर की यह बात मानकर मूसा ने उसके सब वचनों के अनुसार किया। ");
INSERT INTO hin2017_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","अतः उसने सब इस्राएलियों में से गुणी पुरुष चुनकर उन्हें हजार-हजार, सौ-सौ, पचास-पचास, दस-दस, लोगों के ऊपर प्रधान ठहराया। ");
INSERT INTO hin2017_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","और वे सब लोगों का न्याय करने लगे; जो मुकद्दमा कठिन होता उसे तो वे मूसा के पास ले आते थे, और सब छोटे मुकद्दमों का न्याय वे आप ही किया करते थे। ");
INSERT INTO hin2017_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","तब मूसा ने अपने ससुर को विदा किया, और उसने अपने देश का मार्ग लिया। ");
INSERT INTO hin2017_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","इस्राएलियों को मिस्र देश से निकले हुए जिस दिन तीन महीने बीत चुके, उसी दिन वे सीनै के जंगल में आए। ");
INSERT INTO hin2017_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","और जब वे रपीदीम से कूच करके सीनै के जंगल में आए, तब उन्होंने जंगल में डेरे खड़े किए; और वहीं पर्वत के आगे इस्राएलियों ने छावनी डाली। ");
INSERT INTO hin2017_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","तब मूसा पर्वत पर परमेश्वर के पास चढ़ गया, और यहोवा ने पर्वत पर से उसको पुकारकर कहा, “याकूब के घराने से ऐसा कह, और इस्राएलियों को मेरा यह वचन सुना, ");
INSERT INTO hin2017_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘तुम ने देखा है कि मैंने मिस्रियों से क्या-क्या किया; तुम को मानो उकाब पक्षी के पंखों पर चढ़ाकर अपने पास ले आया हूँ। ");
INSERT INTO hin2017_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","इसलिए अब यदि तुम निश्चय मेरी मानोगे, और मेरी वाचा का पालन करोगे, तो सब लोगों में से तुम ही मेरा निज धन ठहरोगे; समस्त पृथ्वी तो मेरी है। ");
INSERT INTO hin2017_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","और तुम मेरी दृष्टि में याजकों का राज्य और पवित्र जाति ठहरोगे।’ जो बातें तुझे इस्राएलियों से कहनी हैं वे ये ही हैं।” ");
INSERT INTO hin2017_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","तब मूसा ने आकर लोगों के पुरनियों को बुलवाया, और ये सब बातें, जिनके कहने की आज्ञा यहोवा ने उसे दी थी, उनको समझा दीं। ");
INSERT INTO hin2017_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","और सब लोग मिलकर बोल उठे, “जो कुछ यहोवा ने कहा है वह सब हम नित करेंगे।” लोगों की यह बातें मूसा ने यहोवा को सुनाईं। ");
INSERT INTO hin2017_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","तब यहोवा ने मूसा से कहा, “सुन, मैं बादल के अंधियारे में होकर तेरे पास आता हूँ, इसलिए कि जब मैं तुझ से बातें करूँ तब वे लोग सुनें, और सदा तेरा विश्वास करें।” और मूसा ने यहोवा से लोगों की बातों का वर्णन किया। ");
INSERT INTO hin2017_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","तब यहोवा ने मूसा से कहा, “लोगों के पास जा और उन्हें आज और कल पवित्र करना, और वे अपने वस्त्र धो लें, ");
INSERT INTO hin2017_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","और वे तीसरे दिन तक तैयार हो जाएँ; क्योंकि तीसरे दिन यहोवा सब लोगों के देखते सीनै पर्वत पर उतर आएगा। ");
INSERT INTO hin2017_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","और तू लोगों के लिये चारों ओर बाड़ा बाँध देना, और उनसे कहना, ‘तुम सचेत रहो कि पर्वत पर न चढ़ो और उसकी सीमा को भी न छूओ; और जो कोई पहाड़ को छूए वह निश्चय मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","उसको कोई हाथ से न छूए, जो छूए उस पर पथराव किया जाए, या उसे तीर से छेदा जाए; चाहे पशु हो चाहे मनुष्य, वह जीवित न बचे।’ जब महाशब्द वाले नरसिंगे का शब्द देर तक सुनाई दे, तब लोग पर्वत के पास आएँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","तब मूसा ने पर्वत पर से उतरकर लोगों के पास आकर उनको पवित्र कराया; और उन्होंने अपने वस्त्र धो लिए। ");
INSERT INTO hin2017_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","और उसने लोगों से कहा, “तीसरे दिन तक तैयार हो जाओ; स्त्री के पास न जाना।” ");
INSERT INTO hin2017_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","जब तीसरा दिन आया तब भोर होते बादल गरजने और बिजली चमकने लगी, और पर्वत पर काली घटा छा गई, फिर नरसिंगे का शब्द बड़ा भारी हुआ, और छावनी में जितने लोग थे सब काँप उठे। ");
INSERT INTO hin2017_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","तब मूसा लोगों को परमेश्वर से भेंट करने के लिये छावनी से निकाल ले गया; और वे पर्वत के नीचे खड़े हुए। ");
INSERT INTO hin2017_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","और यहोवा जो आग में होकर सीनै पर्वत पर उतरा था, इस कारण समस्त पर्वत धुएँ से भर गया; और उसका धुआँ भट्ठे का सा उठ रहा था, और समस्त पर्वत बहुत काँप रहा था। ");
INSERT INTO hin2017_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","फिर जब नरसिंगे का शब्द बढ़ता और बहुत भारी होता गया, तब मूसा बोला, और परमेश्वर ने वाणी सुनाकर उसको उत्तर दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","और यहोवा सीनै पर्वत की चोटी पर उतरा; और मूसा को पर्वत की चोटी पर बुलाया और मूसा ऊपर चढ़ गया। ");
INSERT INTO hin2017_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","तब यहोवा ने मूसा से कहा, “नीचे उतरकर लोगों को चेतावनी दे, कहीं ऐसा न हो कि वे बाड़ा तोड़कर यहोवा के पास देखने को घुसें, और उनमें से बहुत नाश हो जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","और याजक जो यहोवा के समीप आया करते हैं वे भी अपने को पवित्र करें, कहीं ऐसा न हो कि यहोवा उन पर टूट पड़े।” ");
INSERT INTO hin2017_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मूसा ने यहोवा से कहा, “वे लोग सीनै पर्वत पर नहीं चढ़ सकते; तूने तो आप हमको यह कहकर चिताया कि पर्वत के चारों और बाड़ा बाँधकर उसे पवित्र रखो।” ");
INSERT INTO hin2017_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","यहोवा ने उससे कहा, “उतर तो जा, और हारून समेत तू ऊपर आ; परन्तु याजक और साधारण लोग कहीं यहोवा के पास बाड़ा तोड़कर न चढ़ आएँ, कहीं ऐसा न हो कि वह उन पर टूट पड़े।” ");
INSERT INTO hin2017_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","अतः ये बातें मूसा ने लोगों के पास उतरकर उनको सुनाईं। ");
INSERT INTO hin2017_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","तब परमेश्वर ने ये सब वचन कहे, ");
INSERT INTO hin2017_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“मैं तेरा परमेश्वर यहोवा हूँ, जो तुझे दासत्व के घर अर्थात् मिस्र देश से निकाल लाया है। ");
INSERT INTO hin2017_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“तू मुझे छोड़ दूसरों को परमेश्वर करके न मानना। ");
INSERT INTO hin2017_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“तू अपने लिये कोई मूर्ति खोदकर न बनाना, न किसी की प्रतिमा बनाना, जो आकाश में, या पृथ्वी पर, या पृथ्वी के जल में है। ");
INSERT INTO hin2017_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","तू उनको दण्डवत् न करना, और न उनकी उपासना करना; क्योंकि मैं तेरा परमेश्वर यहोवा जलन रखनेवाला परमेश्वर हूँ, और जो मुझसे बैर रखते हैं, उनके बेटों, पोतों, और परपोतों को भी पितरों का दण्ड दिया करता हूँ, ");
INSERT INTO hin2017_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","और जो मुझसे प्रेम रखते और मेरी आज्ञाओं को मानते हैं, उन हजारों पर करुणा किया करता हूँ। ");
INSERT INTO hin2017_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“तू अपने परमेश्वर का नाम व्यर्थ न लेना; क्योंकि जो यहोवा का नाम व्यर्थ ले वह उसको निर्दोष न ठहराएगा। ");
INSERT INTO hin2017_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“तू विश्रामदिन को पवित्र मानने के लिये स्मरण रखना। ");
INSERT INTO hin2017_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","छः दिन तो तू परिश्रम करके अपना सब काम-काज करना; ");
INSERT INTO hin2017_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","परन्तु सातवाँ दिन तेरे परमेश्वर यहोवा के लिये विश्रामदिन है। उसमें न तो तू किसी भाँति का काम-काज करना, और न तेरा बेटा, न तेरी बेटी, न तेरा दास, न तेरी दासी, न तेरे पशु, न कोई परदेशी जो तेरे फाटकों के भीतर हो। ");
INSERT INTO hin2017_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","क्योंकि छः दिन में यहोवा ने आकाश और पृथ्वी, और समुद्र, और जो कुछ उनमें है, सब को बनाया, और सातवें दिन विश्राम किया; इस कारण यहोवा ने विश्रामदिन को आशीष दी और उसको पवित्र ठहराया। ");
INSERT INTO hin2017_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“तू अपने पिता और अपनी माता का आदर करना, जिससे जो देश तेरा परमेश्वर यहोवा तुझे देता है उसमें तू बहुत दिन तक रहने पाए। ");
INSERT INTO hin2017_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“तू खून न करना। ");
INSERT INTO hin2017_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“तू व्यभिचार न करना। ");
INSERT INTO hin2017_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“तू चोरी न करना। ");
INSERT INTO hin2017_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“तू किसी के विरुद्ध झूठी साक्षी न देना। ");
INSERT INTO hin2017_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“तू किसी के घर का लालच न करना; न तो किसी की पत्नी का लालच करना, और न किसी के दास-दासी, या बैल गदहे का, न किसी की किसी वस्तु का लालच करना।” ");
INSERT INTO hin2017_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","और सब लोग गरजने और बिजली और नरसिंगे के शब्द सुनते, और धुआँ उठते हुए पर्वत को देखते रहे, और देखके, काँपकर दूर खड़े हो गए; ");
INSERT INTO hin2017_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","और वे मूसा से कहने लगे, “तू ही हम से बातें कर, तब तो हम सुन सकेंगे; परन्तु परमेश्वर हम से बातें न करे, ऐसा न हो कि हम मर जाएँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मूसा ने लोगों से कहा, “डरो मत; क्योंकि परमेश्वर इस निमित्त आया है कि तुम्हारी परीक्षा करे, और उसका भय तुम्हारे मन में बना रहे, कि तुम पाप न करो।” ");
INSERT INTO hin2017_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","और वे लोग तो दूर ही खड़े रहे, परन्तु मूसा उस घोर अंधकार के समीप गया जहाँ परमेश्वर था। ");
INSERT INTO hin2017_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","तब यहोवा ने मूसा से कहा, “तू इस्राएलियों को मेरे ये वचन सुना, कि तुम लोगों ने तो आप ही देखा है कि मैंने तुम्हारे साथ आकाश से बातें की हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","तुम मेरे साथ किसी को सम्मिलित न करना, अर्थात् अपने लिये चाँदी या सोने से देवताओं को न गढ़ लेना। ");
INSERT INTO hin2017_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","मेरे लिये मिट्टी की एक वेदी बनाना, और अपनी भेड़-बकरियों और गाय-बैलों के होमबलि और मेलबलि को उस पर चढ़ाना; जहाँ-जहाँ मैं अपने नाम का स्मरण कराऊँ वहाँ-वहाँ मैं आकर तुम्हें आशीष दूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","और यदि तुम मेरे लिये पत्थरों की वेदी बनाओ, तो तराशे हुए पत्थरों से न बनाना; क्योंकि जहाँ तुम ने उस पर अपना हथियार लगाया वहाँ तू उसे अशुद्ध कर देगा। ");
INSERT INTO hin2017_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","और मेरी वेदी पर सीढ़ी से कभी न चढ़ना, कहीं ऐसा न हो कि तेरा तन उस पर नंगा देख पड़े।” ");
INSERT INTO hin2017_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","फिर जो नियम तुझे उनको समझाने हैं वे ये हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“जब तुम कोई इब्री दास मोल लो, तब वह छः वर्ष तक सेवा करता रहे, और सातवें वर्ष स्वतंत्र होकर सेंत-मेंत चला जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","यदि वह अकेला आया हो, तो अकेला ही चला जाए; और यदि पत्नी सहित आया हो, तो उसके साथ उसकी पत्नी भी चली जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","यदि उसके स्वामी ने उसको पत्नी दी हो और उससे उसके बेटे या बेटियाँ उत्पन्न हुई हों, तो उसकी पत्नी और बालक उस स्वामी के ही रहें, और वह अकेला चला जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","परन्तु यदि वह दास दृढ़ता से कहे, ‘मैं अपने स्वामी, और अपनी पत्नी, और बालकों से प्रेम रखता हूँ; इसलिए मैं स्वतंत्र होकर न चला जाऊँगा;’ ");
INSERT INTO hin2017_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","तो उसका स्वामी उसको परमेश्वर के पास ले चले; फिर उसको द्वार के किवाड़ या बाजू के पास ले जाकर उसके कान में सुतारी से छेद करें; तब वह सदा उसकी सेवा करता रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“यदि कोई अपनी बेटी को दासी होने के लिये बेच डालें, तो वह दासी के समान बाहर न जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","यदि उसका स्वामी उसको अपनी पत्नी बनाए, और फिर उससे प्रसन्न न रहे, तो वह उसे दाम से छुड़ाई जाने दे; उसका विश्वासघात करने के बाद उसे विदेशी लोगों के हाथ बेचने का उसको अधिकार न होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","यदि उसने उसे अपने बेटे को ब्याह दिया हो, तो उससे बेटी का सा व्यवहार करे। ");
INSERT INTO hin2017_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","चाहे वह दूसरी पत्नी कर ले, तो भी वह उसका भोजन, वस्त्र, और संगति न घटाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","और यदि वह इन तीन बातों में घटी करे, तो वह स्त्री सेंत-मेंत बिना दाम चुकाए ही चली जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“जो किसी मनुष्य को ऐसा मारे कि वह मर जाए, तो वह भी निश्चय मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","यदि वह उसकी घात में न बैठा हो, और परमेश्वर की इच्छा ही से वह उसके हाथ में पड़ गया हो, तो ऐसे मारनेवाले के भागने के निमित्त मैं एक स्थान ठहराऊँगा जहाँ वह भाग जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","परन्तु यदि कोई ढिठाई से किसी पर चढ़ाई करके उसे छल से घात करे, तो उसको मार डालने के लिये मेरी वेदी के पास से भी अलग ले जाना। ");
INSERT INTO hin2017_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“जो अपने पिता या माता को मारे-पीटे वह निश्चय मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“जो किसी मनुष्य को चुराए, चाहे उसे ले जाकर बेच डाले, चाहे वह उसके पास पाया जाए, तो वह भी निश्चय मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“जो अपने पिता या माता को श्राप दे वह भी निश्चय मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“यदि मनुष्य झगड़ते हों, और एक दूसरे को पत्थर या मुक्के से ऐसा मारे कि वह मरे नहीं परन्तु बिछौने पर पड़ा रहे, ");
INSERT INTO hin2017_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","तो जब वह उठकर लाठी के सहारे से बाहर चलने फिरने लगे, तब वह मारनेवाला निर्दोष ठहरे; उस दशा में वह उसके पड़े रहने के समय की हानि भर दे, और उसको भला चंगा भी करा दे। ");
INSERT INTO hin2017_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“यदि कोई अपने दास या दासी को सोंटे से ऐसा मारे कि वह उसके मारने से मर जाए, तब तो उसको निश्चय दण्ड दिया जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","परन्तु यदि वह दो एक दिन जीवित रहे, तो उसके स्वामी को दण्ड न दिया जाए; क्योंकि वह दास उसका धन है। ");
INSERT INTO hin2017_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“यदि मनुष्य आपस में मारपीट करके किसी गर्भवती स्त्री को ऐसी चोट पहुँचाए, कि उसका गर्भ गिर जाए, परन्तु और कुछ हानि न हो, तो मारनेवाले से उतना दण्ड लिया जाए जितना उस स्त्री का पति पंच की सम्मति से ठहराए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","परन्तु यदि उसको और कुछ हानि पहुँचे, तो प्राण के बदले प्राण का, ");
INSERT INTO hin2017_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","और आँख के बदले आँख का, और दाँत के बदले दाँत का, और हाथ के बदले हाथ का, और पाँव के बदले पाँव का, ");
INSERT INTO hin2017_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","और दाग के बदले दाग का, और घाव के बदले घाव का, और मार के बदले मार का दण्ड हो। ");
INSERT INTO hin2017_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“जब कोई अपने दास या दासी की आँख पर ऐसा मारे कि फूट जाए, तो वह उसकी आँख के बदले उसे स्वतंत्र करके जाने दे। ");
INSERT INTO hin2017_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","और यदि वह अपने दास या दासी को मारकर उसका दाँत तोड़ डाले, तो वह उसके दाँत के बदले उसे स्वतंत्र करके जाने दे। ");
INSERT INTO hin2017_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“यदि बैल किसी पुरुष या स्त्री को ऐसा सींग मारे कि वह मर जाए, तो वह बैल तो निश्चय पथरवाह करके मार डाला जाए, और उसका माँस खाया न जाए; परन्तु बैल का स्वामी निर्दोष ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","परन्तु यदि उस बैल की पहले से सींग मारने की आदत पड़ी हो, और उसके स्वामी ने जताए जाने पर भी उसको न बाँध रखा हो, और वह किसी पुरुष या स्त्री को मार डाले, तब तो वह बैल पथरवाह किया जाए, और उसका स्वामी भी मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","यदि उस पर छुड़ौती ठहराई जाए, तो प्राण छुड़ाने को जो कुछ उसके लिये ठहराया जाए उसे उतना ही देना पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","चाहे बैल ने किसी बेटे को, चाहे बेटी को मारा हो, तो भी इसी नियम के अनुसार उसके स्वामी के साथ व्यवहार किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","यदि बैल ने किसी दास या दासी को सींग मारा हो, तो बैल का स्वामी उस दास के स्वामी को तीस शेकेल रूपा दे, और वह बैल पथरवाह किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“यदि कोई मनुष्य गड्ढा खोलकर या खोदकर उसको न ढाँपे, और उसमें किसी का बैल या गदहा गिर पड़े, ");
INSERT INTO hin2017_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","तो जिसका वह गड्ढा हो वह उस हानि को भर दे; वह पशु के स्वामी को उसका मोल दे, और लोथ गड्ढेवाले की ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“यदि किसी का बैल किसी दूसरे के बैल को ऐसी चोट लगाए, कि वह मर जाए, तो वे दोनों मनुष्य जीवित बैल को बेचकर उसका मोल आपस में आधा-आधा बाँट लें; और लोथ को भी वैसा ही बाँटें। ");
INSERT INTO hin2017_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","यदि यह प्रगट हो कि उस बैल की पहले से सींग मारने की आदत पड़ी थी, पर उसके स्वामी ने उसे बाँध नहीं रखा, तो निश्चय वह बैल के बदले बैल भर दे, पर लोथ उसी की ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“यदि कोई मनुष्य बैल, या भेड़, या बकरी चुराकर उसका घात करे या बेच डाले, तो वह बैल के बदले पाँच बैल, और भेड़-बकरी के बदले चार भेड़-बकरी भर दे। ");
INSERT INTO hin2017_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","यदि चोर सेंध लगाते हुए पकड़ा जाए, और उस पर ऐसी मार पड़े कि वह मर जाए, तो उसके खून का दोष न लगे; ");
INSERT INTO hin2017_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","यदि सूर्य निकल चुके, तो उसके खून का दोष लगे; अवश्य है कि वह हानि को भर दे, और यदि उसके पास कुछ न हो, तो वह चोरी के कारण बेच दिया जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","यदि चुराया हुआ बैल, या गदहा, या भेड़ या बकरी उसके हाथ में जीवित पाई जाए, तो वह उसका दूना भर दे। ");
INSERT INTO hin2017_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“यदि कोई अपने पशु से किसी का खेत या दाख की बारी चराए, अर्थात् अपने पशु को ऐसा छोड़ दे कि वह पराए खेत को चर ले, तो वह अपने खेत की और अपनी दाख की बारी की उत्तम से उत्तम उपज में से उस हानि को भर दे। ");
INSERT INTO hin2017_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“यदि कोई आग जलाए, और वह काँटों में लग जाए और फूलों के ढेर या अनाज या खड़ा खेत जल जाए, तो जिसने आग जलाई हो वह हानि को निश्चय भर दे। ");
INSERT INTO hin2017_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“यदि कोई दूसरे को रुपये या सामग्री की धरोहर धरे, और वह उसके घर से चुराई जाए, तो यदि चोर पकड़ा जाए, तो दूना उसी को भर देना पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","और यदि चोर न पकड़ा जाए, तो घर का स्वामी परमेश्वर के पास लाया जाए कि निश्चय हो जाए कि उसने अपने भाई-बन्धु की सम्पत्ति पर हाथ लगाया है या नहीं। ");
INSERT INTO hin2017_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","चाहे बैल, चाहे गदहे, चाहे भेड़ या बकरी, चाहे वस्त्र, चाहे किसी प्रकार की ऐसी खोई हुई वस्तु के विषय अपराध क्यों न लगाया जाए, जिसे दो जन अपनी-अपनी कहते हों, तो दोनों का मुकद्दमा परमेश्वर के पास आए; और जिसको परमेश्वर दोषी ठहराए वह दूसरे को दूना भर दे। ");
INSERT INTO hin2017_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“यदि कोई दूसरे को गदहा या बैल या भेड़-बकरी या कोई और पशु रखने के लिये सौंपे, और किसी के बिना देखे वह मर जाए, या चोट खाए, या हाँक दिया जाए, ");
INSERT INTO hin2017_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","तो उन दोनों के बीच यहोवा की शपथ खिलाई जाए, ‘मैंने इसकी सम्पत्ति पर हाथ नहीं लगाया;’ तब सम्पत्ति का स्वामी इसको सच माने, और दूसरे को उसे कुछ भी भर देना न होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","यदि वह सचमुच उसके यहाँ से चुराया गया हो, तो वह उसके स्वामी को उसे भर दे। ");
INSERT INTO hin2017_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","और यदि वह फाड़ डाला गया हो, तो वह फाड़े हुए को प्रमाण के लिये ले आए, तब उसे उसको भी भर देना न पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“फिर यदि कोई दूसरे से पशु माँग लाए, और उसके स्वामी के संग न रहते उसको चोट लगे या वह मर जाए, तो वह निश्चय उसकी हानि भर दे। ");
INSERT INTO hin2017_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","यदि उसका स्वामी संग हो, तो दूसरे को उसकी हानि भरना न पड़े; और यदि वह भाड़े का हो तो उसकी हानि उसके भाड़े में आ गई। ");
INSERT INTO hin2017_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“यदि कोई पुरुष किसी कन्या को जिसके ब्याह की बात न लगी हो फुसलाकर उसके संग कुकर्म करे, तो वह निश्चय उसका मोल देकर उसे ब्याह ले। ");
INSERT INTO hin2017_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","परन्तु यदि उसका पिता उसे देने को बिल्कुल इन्कार करे, तो कुकर्म करनेवाला कन्याओं के मोल की रीति के अनुसार रुपये तौल दे। ");
INSERT INTO hin2017_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“तू जादू-टोना करनेवाली को जीवित रहने न देना। ");
INSERT INTO hin2017_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“जो कोई पशुगमन करे वह निश्चय मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“जो कोई यहोवा को छोड़ किसी और देवता के लिये बलि करे वह सत्यानाश किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“तुम परदेशी को न सताना और न उस पर अंधेर करना क्योंकि मिस्र देश में तुम भी परदेशी थे। ");
INSERT INTO hin2017_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","किसी विधवा या अनाथ बालक को दुःख न देना। ");
INSERT INTO hin2017_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","यदि तुम ऐसों को किसी प्रकार का दुःख दो, और वे कुछ भी मेरी दुहाई दें, तो मैं निश्चय उनकी दुहाई सुनूँगा; ");
INSERT INTO hin2017_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","तब मेरा क्रोध भड़केगा, और मैं तुम को तलवार से मरवाऊँगा, और तुम्हारी पत्नियाँ विधवा और तुम्हारे बालक अनाथ हो जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“यदि तू मेरी प्रजा में से किसी दीन को जो तेरे पास रहता हो रुपये का ऋण दे, तो उससे महाजन के समान ब्याज न लेना। ");
INSERT INTO hin2017_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","यदि तू कभी अपने भाई-बन्धु के वस्त्र को बन्धक करके रख भी ले, तो सूर्य के अस्त होने तक उसको लौटा देना; ");
INSERT INTO hin2017_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","क्योंकि वह उसका एक ही ओढ़ना है, उसकी देह का वही अकेला वस्त्र होगा; फिर वह किसे ओढ़कर सोएगा? और जब वह मेरी दुहाई देगा तब मैं उसकी सुनूँगा, क्योंकि मैं तो करुणामय हूँ। ");
INSERT INTO hin2017_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“परमेश्वर को श्राप न देना, और न अपने लोगों के प्रधान को श्राप देना। ");
INSERT INTO hin2017_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“अपने खेतों की उपज और फलों के रस में से कुछ मुझे देने में विलम्ब न करना। अपने बेटों में से पहलौठे को मुझे देना। ");
INSERT INTO hin2017_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","वैसे ही अपनी गायों और भेड़-बकरियों के पहलौठे भी देना; सात दिन तक तो बच्चा अपनी माता के संग रहे, और आठवें दिन तू उसे मुझे दे देना। ");
INSERT INTO hin2017_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“तुम मेरे लिये पवित्र मनुष्य बनना; इस कारण जो पशु मैदान में फाड़ा हुआ पड़ा मिले उसका माँस न खाना, उसको कुत्तों के आगे फेंक देना। ");
INSERT INTO hin2017_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“झूठी बात न फैलाना। अन्यायी साक्षी होकर दुष्ट का साथ न देना। ");
INSERT INTO hin2017_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","बुराई करने के लिये न तो बहुतों के पीछे हो लेना; और न उनके पीछे फिरकर मुकद्दमे में न्याय बिगाड़ने को साक्षी देना; ");
INSERT INTO hin2017_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","और कंगाल के मुकद्दमे में उसका भी पक्ष न करना। ");
INSERT INTO hin2017_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“यदि तेरे शत्रु का बैल या गदहा भटकता हुआ तुझे मिले, तो उसे उसके पास अवश्य फेर ले आना। ");
INSERT INTO hin2017_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","फिर यदि तू अपने बैरी के गदहे को बोझ के मारे दबा हुआ देखे, तो चाहे उसको उसके स्वामी के लिये छुड़ाने के लिये तेरा मन न चाहे, तो भी अवश्य स्वामी का साथ देकर उसे छुड़ा लेना। ");
INSERT INTO hin2017_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“तेरे लोगों में से जो दरिद्र हों उसके मुकद्दमे में न्याय न बिगाड़ना। ");
INSERT INTO hin2017_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","झूठे मुकद्दमे से दूर रहना, और निर्दोष और धर्मी को घात न करना, क्योंकि मैं दुष्ट को निर्दोष न ठहराऊँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","घूस न लेना, क्योंकि घूस देखनेवालों को भी अंधा कर देता, और धर्मियों की बातें पलट देता है। ");
INSERT INTO hin2017_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“परदेशी पर अंधेर न करना; तुम तो परदेशी के मन की बातें जानते हो, क्योंकि तुम भी मिस्र देश में परदेशी थे। ");
INSERT INTO hin2017_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“छः वर्ष तो अपनी भूमि में बोना और उसकी उपज इकट्ठी करना; ");
INSERT INTO hin2017_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","परन्तु सातवें वर्ष में उसको पड़ती रहने देना और वैसा ही छोड़ देना, तो तेरे भाई-बन्धुओं में के दरिद्र लोग उससे खाने पाएँ, और जो कुछ उनसे भी बचे वह जंगली पशुओं के खाने के काम में आए। और अपनी दाख और जैतून की बारियों को भी ऐसे ही करना। ");
INSERT INTO hin2017_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","छः दिन तक तो अपना काम-काज करना, और सातवें दिन विश्राम करना; कि तेरे बैल और गदहे सुस्ताएँ, और तेरी दासियों के बेटे और परदेशी भी अपना जी ठंडा कर सके। ");
INSERT INTO hin2017_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","और जो कुछ मैंने तुम से कहा है उसमें सावधान रहना; और दूसरे देवताओं के नाम की चर्चा न करना, वरन् वे तुम्हारे मुँह से सुनाई भी न दें। ");
INSERT INTO hin2017_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“प्रतिवर्ष तीन बार मेरे लिये पर्व मानना। ");
INSERT INTO hin2017_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","अख़मीरी रोटी का पर्व मानना; उसमें मेरी आज्ञा के अनुसार अबीब महीने के नियत समय पर सात दिन तक अख़मीरी रोटी खाया करना, क्योंकि उसी महीने में तुम मिस्र से निकल आए। और मुझ को कोई खाली हाथ अपना मुँह न दिखाए। ");
INSERT INTO hin2017_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","और जब तेरी बोई हुई खेती की पहली उपज तैयार हो, तब कटनी का पर्व मानना। और वर्ष के अन्त में जब तू परिश्रम के फल बटोरकर ढेर लगाए, तब बटोरन का पर्व मानना। ");
INSERT INTO hin2017_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","प्रतिवर्ष तीनों बार तेरे सब पुरुष प्रभु यहोवा को अपना मुँह दिखाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“मेरे बलिपशु का लहू ख़मीरी रोटी के संग न चढ़ाना, और न मेरे पर्व के उत्तम बलिदान में से कुछ सवेरे तक रहने देना। ");
INSERT INTO hin2017_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","अपनी भूमि की पहली उपज का पहला भाग अपने परमेश्वर यहोवा के भवन में ले आना। बकरी का बच्चा उसकी माता के दूध में न पकाना। ");
INSERT INTO hin2017_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“सुन, मैं एक दूत तेरे आगे-आगे भेजता हूँ जो मार्ग में तेरी रक्षा करेगा, और जिस स्थान को मैंने तैयार किया है उसमें तुझे पहुँचाएगा। ");
INSERT INTO hin2017_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","उसके सामने सावधान रहना, और उसकी मानना, उसका विरोध न करना, क्योंकि वह तुम्हारा अपराध क्षमा न करेगा; इसलिए कि उसमें मेरा नाम रहता है। ");
INSERT INTO hin2017_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","और यदि तू सचमुच उसकी माने और जो कुछ मैं कहूँ वह करे, तो मैं तेरे शत्रुओं का शत्रु और तेरे द्रोहियों का द्रोही बनूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","इस रीति मेरा दूत तेरे आगे-आगे चलकर तुझे एमोरी, हित्ती, परिज्जी, कनानी, हिब्बी, और यबूसी लोगों के यहाँ पहुँचाएगा, और मैं उनको सत्यानाश कर डालूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","उनके देवताओं को दण्डवत् न करना, और न उनकी उपासना करना, और न उनके से काम करना, वरन् उन मूरतों को पूरी रीति से सत्यानाश कर डालना, और उन लोगों की लाटों के टुकड़े-टुकड़े कर देना। ");
INSERT INTO hin2017_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","तुम अपने परमेश्वर यहोवा की उपासना करना, तब वह तेरे अन्न जल पर आशीष देगा, और तेरे बीच में से रोग दूर करेगा। ");
INSERT INTO hin2017_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","तेरे देश में न तो किसी का गर्भ गिरेगा और न कोई बाँझ होगी; और तेरी आयु मैं पूरी करूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","जितने लोगों के बीच तू जाएगा उन सभी के मन में मैं अपना भय पहले से ऐसा समवा दूँगा कि उनको व्याकुल कर दूँगा, और मैं तुझे सब शत्रुओं की पीठ दिखाऊँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","और मैं तुझ से पहले बर्रों को भेजूँगा जो हिब्बी, कनानी, और हित्ती लोगों को तेरे सामने से भगाकर दूर कर देंगी। ");
INSERT INTO hin2017_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","मैं उनको तेरे आगे से एक ही वर्ष में तो न निकाल दूँगा, ऐसा न हो कि देश उजाड़ हो जाए, और जंगली पशु बढ़कर तुझे दुःख देने लगें। ");
INSERT INTO hin2017_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","जब तक तू फूल-फलकर देश को अपने अधिकार में न कर ले तब तक मैं उन्हें तेरे आगे से थोड़ा-थोड़ा करके निकालता रहूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","मैं लाल समुद्र से लेकर पलिश्तियों के समुद्र तक और जंगल से लेकर फरात तक के देश को तेरे वश में कर दूँगा; मैं उस देश के निवासियों को भी तेरे वश में कर दूँगा, और तू उन्हें अपने सामने से बरबस निकालेगा। ");
INSERT INTO hin2017_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","तू न तो उनसे वाचा बाँधना और न उनके देवताओं से। ");
INSERT INTO hin2017_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","वे तेरे देश में रहने न पाएँ, ऐसा न हो कि वे तुझ से मेरे विरुद्ध पाप कराएँ; क्योंकि यदि तू उनके देवताओं की उपासना करे, तो यह तेरे लिये फंदा बनेगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","फिर यहोवा ने मूसा से कहा, “तू, हारून, नादाब, अबीहू, और इस्राएलियों के सत्तर पुरनियों समेत यहोवा के पास ऊपर आकर दूर से दण्डवत् करना। ");
INSERT INTO hin2017_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","और केवल मूसा यहोवा के समीप आए; परन्तु वे समीप न आएँ, और दूसरे लोग उसके संग ऊपर न आएँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","तब मूसा ने लोगों के पास जाकर यहोवा की सब बातें और सब नियम सुना दिए; तब सब लोग एक स्वर से बोल उठे, “जितनी बातें यहोवा ने कही हैं उन सब बातों को हम मानेंगे।” ");
INSERT INTO hin2017_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","तब मूसा ने यहोवा के सब वचन लिख दिए। और सवेरे उठकर पर्वत के नीचे एक वेदी और इस्राएल के बारहों गोत्रों के अनुसार बारह खम्भे भी बनवाए। ");
INSERT INTO hin2017_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","तब उसने कई इस्राएली जवानों को भेजा, जिन्होंने यहोवा के लिये होमबलि और बैलों के मेलबलि चढ़ाए। ");
INSERT INTO hin2017_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","और मूसा ने आधा लहू लेकर कटोरों में रखा, और आधा वेदी पर छिड़क दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","तब वाचा की पुस्तक को लेकर लोगों को पढ़ सुनाया; उसे सुनकर उन्होंने कहा, “जो कुछ यहोवा ने कहा है उस सब को हम करेंगे, और उसकी आज्ञा मानेंगे।” ");
INSERT INTO hin2017_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","तब मूसा ने लहू को लेकर लोगों पर छिड़क दिया, और उनसे कहा, “देखो, यह उस वाचा का लहू है जिसे यहोवा ने इन सब वचनों पर तुम्हारे साथ बाँधी है।” ");
INSERT INTO hin2017_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","तब मूसा, हारून, नादाब, अबीहू और इस्राएलियों के सत्तर पुरनिए ऊपर गए, ");
INSERT INTO hin2017_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","और इस्राएल के परमेश्वर का दर्शन किया; और उसके चरणों के तले नीलमणि का चबूतरा सा कुछ था, जो आकाश के तुल्य ही स्वच्छ था। ");
INSERT INTO hin2017_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","और उसने इस्राएलियों के प्रधानों पर हाथ न बढ़ाया; तब उन्होंने परमेश्वर का दर्शन किया, और खाया पिया। ");
INSERT INTO hin2017_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","तब यहोवा ने मूसा से कहा, “पहाड़ पर मेरे पास चढ़, और वहाँ रह; और मैं तुझे पत्थर की पटियाएँ, और अपनी लिखी हुई व्यवस्था और आज्ञा दूँगा कि तू उनको सिखाए।” ");
INSERT INTO hin2017_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","तब मूसा यहोशू नामक अपने टहलुए समेत परमेश्वर के पर्वत पर चढ़ गया। ");
INSERT INTO hin2017_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","और पुरनियों से वह यह कह गया, “जब तक हम तुम्हारे पास फिर न आएँ तब तक तुम यहीं हमारी बाट जोहते रहो; और सुनो, हारून और हूर तुम्हारे संग हैं; तो यदि किसी का मुकद्दमा हो तो उन्हीं के पास जाए।” ");
INSERT INTO hin2017_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","तब मूसा पर्वत पर चढ़ गया, और बादल ने पर्वत को छा लिया। ");
INSERT INTO hin2017_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","तब यहोवा के तेज ने सीनै पर्वत पर निवास किया, और वह बादल उस पर छः दिन तक छाया रहा; और सातवें दिन उसने मूसा को बादल के बीच में से पुकारा। ");
INSERT INTO hin2017_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","और इस्राएलियों की दृष्टि में यहोवा का तेज पर्वत की चोटी पर प्रचण्ड आग सा देख पड़ता था। ");
INSERT INTO hin2017_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","तब मूसा बादल के बीच में प्रवेश करके पर्वत पर चढ़ गया। और मूसा पर्वत पर चालीस दिन और चालीस रात रहा। ");
INSERT INTO hin2017_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“इस्राएलियों से यह कहना कि मेरे लिये भेंट लाएँ; जितने अपनी इच्छा से देना चाहें उन्हीं सभी से मेरी भेंट लेना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","और जिन वस्तुओं की भेंट उनसे लेनी हैं वे ये हैं; अर्थात् सोना, चाँदी, पीतल, ");
INSERT INTO hin2017_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","नीले, बैंगनी और लाल रंग का कपड़ा, सूक्ष्म सनी का कपड़ा, बकरी का बाल, ");
INSERT INTO hin2017_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","लाल रंग से रंगी हुई मेढ़ों की खालें, सुइसों की खालें, बबूल की लकड़ी, ");
INSERT INTO hin2017_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","उजियाले के लिये तेल, अभिषेक के तेल के लिये और सुगन्धित धूप के लिये सुगन्ध-द्रव्य, ");
INSERT INTO hin2017_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","एपोद और चपरास के लिये सुलैमानी पत्थर, और जड़ने के लिये मणि। ");
INSERT INTO hin2017_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","और वे मेरे लिये एक पवित्रस्थान बनाएँ, कि मैं उनके बीच निवास करूँ। ");
INSERT INTO hin2017_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","जो कुछ मैं तुझे दिखाता हूँ, अर्थात् निवास-स्थान और उसके सब सामान का नमूना, उसी के अनुसार तुम लोग उसे बनाना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“बबूल की लकड़ी का एक सन्दूक बनाया जाए; उसकी लम्बाई ढाई हाथ, और चौड़ाई और ऊँचाई डेढ़-डेढ़ हाथ की हो। ");
INSERT INTO hin2017_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","और उसको शुद्ध सोने से भीतर और बाहर मढ़वाना, और सन्दूक के ऊपर चारों ओर सोने की बाड़ बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","और सोने के चार कड़े ढलवा कर उसके चारों पायों पर, एक ओर दो कड़े और दूसरी ओर भी दो कड़े लगवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","फिर बबूल की लकड़ी के डंडे बनवाना, और उन्हें भी सोने से मढ़वाना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","और डंडों को सन्दूक की दोनों ओर के कड़ों में डालना जिससे उनके बल सन्दूक उठाया जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","वे डंडे सन्दूक के कड़ों में लगे रहें; और उससे अलग न किए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","और जो साक्षीपत्र मैं तुझे दूँगा उसे उसी सन्दूक में रखना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“फिर शुद्ध सोने का एक प्रायश्चित का ढकना बनवाना; उसकी लम्बाई ढाई हाथ, और चौड़ाई डेढ़ हाथ की हो। ");
INSERT INTO hin2017_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","और सोना ढालकर दो करूब बनवाकर प्रायश्चित के ढकने के दोनों सिरों पर लगवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","एक करूब तो एक सिरे पर और दूसरा करूब दूसरे सिरे पर लगवाना; और करूबों को और प्रायश्चित के ढकने को उसके ही टुकड़े से बनाकर उसके दोनों सिरों पर लगवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","और उन करूबों के पंख ऊपर से ऐसे फैले हुए बनें कि प्रायश्चित का ढकना उनसे ढँपा रहे, और उनके मुख आमने-सामने और प्रायश्चित के ढकने की ओर रहें। ");
INSERT INTO hin2017_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","और प्रायश्चित के ढकने को सन्दूक के ऊपर लगवाना; और जो साक्षीपत्र मैं तुझे दूँगा उसे सन्दूक के भीतर रखना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","और मैं उसके ऊपर रहकर तुझ से मिला करूँगा; और इस्राएलियों के लिये जितनी आज्ञाएँ मुझ को तुझे देनी होंगी, उन सभी के विषय मैं प्रायश्चित के ढकने के ऊपर से और उन करूबों के बीच में से, जो साक्षीपत्र के सन्दूक पर होंगे, तुझ से वार्तालाप किया करूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“फिर बबूल की लकड़ी की एक मेज बनवाना; उसकी लम्बाई दो हाथ, चौड़ाई एक हाथ, और ऊँचाई डेढ़ हाथ की हो। ");
INSERT INTO hin2017_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","उसे शुद्ध सोने से मढ़वाना, और उसके चारों ओर सोने की एक बाड़ बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","और उसके चारों ओर चार अंगुल चौड़ी एक पटरी बनवाना, और इस पटरी के चारों ओर सोने की एक बाड़ बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","और सोने के चार कड़े बनवाकर मेज के उन चारों कोनों में लगवाना जो उसके चारों पायों में होंगे। ");
INSERT INTO hin2017_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","वे कड़े पटरी के पास ही हों, और डंडों के घरों का काम दें कि मेज उन्हीं के बल उठाई जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","और डंडों को बबूल की लकड़ी के बनवाकर सोने से मढ़वाना, और मेज उन्हीं से उठाई जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","और उसके परात और धूपदान, और चमचे और उण्डेलने के कटोरे, सब शुद्ध सोने के बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","और मेज पर मेरे आगे भेंट की रोटियाँ नित्य रखा करना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“फिर शुद्ध सोने की एक दीवट बनवाना। सोना ढलवा कर वह दीवट, पाये और डण्डी सहित बनाया जाए; उसके पुष्पकोष, गाँठ और फूल, सब एक ही टुकड़े के बनें; ");
INSERT INTO hin2017_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","और उसके किनारों से छः डालियाँ निकलें, तीन डालियाँ तो दीवट की एक ओर से और तीन डालियाँ उसकी दूसरी ओर से निकली हुई हों; ");
INSERT INTO hin2017_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","एक-एक डाली में बादाम के फूल के समान तीन-तीन पुष्पकोष, एक-एक गाँठ, और एक-एक फूल हों; दीवट से निकली हुई छहों डालियों का यही आकार या रूप हो; ");
INSERT INTO hin2017_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","और दीवट की डण्डी में बादाम के फूल के समान चार पुष्पकोष अपनी-अपनी गाँठ और फूल समेत हों; ");
INSERT INTO hin2017_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","और दीवट से निकली हुई छहों डालियों में से दो-दो डालियों के नीचे एक-एक गाँठ हो, वे दीवट समेत एक ही टुकड़े के बने हुए हों। ");
INSERT INTO hin2017_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","उनकी गाँठें और डालियाँ, सब दीवट समेत एक ही टुकड़े की हों, शुद्ध सोना ढलवा कर पूरा दीवट एक ही टुकड़े का बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","और सात दीपक बनवाना; और दीपक जलाए जाएँ कि वे दीवट के सामने प्रकाश दें। ");
INSERT INTO hin2017_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","और उसके गुलतराश और गुलदान सब शुद्ध सोने के हों। ");
INSERT INTO hin2017_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","वह सब इन समस्त सामान समेत किक्कार भर शुद्ध सोने का बने। ");
INSERT INTO hin2017_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","और सावधान रहकर इन सब वस्तुओं को उस नमूने के समान बनवाना, जो तुझे इस पर्वत पर दिखाया गया है। ");
INSERT INTO hin2017_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“फिर निवास-स्थान के लिये दस पर्दे बनवाना; इनको बटी हुई सनीवाले और नीले, बैंगनी और लाल रंग के कपड़े का कढ़ाई के काम किए हुए करूबों के साथ बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","एक-एक पर्दे की लम्बाई अट्ठाईस हाथ और चौड़ाई चार हाथ की हो; सब पर्दे एक ही नाप के हों। ");
INSERT INTO hin2017_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","पाँच पर्दे एक दूसरे से जुड़े हुए हों; और फिर जो पाँच पर्दे रहेंगे वे भी एक दूसरे से जुड़े हुए हों। ");
INSERT INTO hin2017_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","और जहाँ ये दोनों पर्दे जोड़े जाएँ वहाँ की दोनों छोरों पर नीले-नीले फंदे लगवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","दोनों छोरों में पचास-पचास फंदे ऐसे लगवाना कि वे आमने-सामने हों। ");
INSERT INTO hin2017_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","और सोने के पचास अंकड़े बनवाना; और परदों के छल्लों को अंकड़ों के द्वारा एक दूसरे से ऐसा जुड़वाना कि निवास-स्थान मिलकर एक ही हो जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“फिर निवास के ऊपर तम्बू का काम देने के लिये बकरी के बाल के ग्यारह पर्दे बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","एक-एक पर्दे की लम्बाई तीस हाथ और चौड़ाई चार हाथ की हो; ग्यारहों पर्दे एक ही नाप के हों। ");
INSERT INTO hin2017_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","और पाँच पर्दे अलग और फिर छः पर्दे अलग जुड़वाना, और छठवें पर्दे को तम्बू के सामने मोड़कर दुहरा कर देना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","और तू पचास अंकड़े उस पर्दे की छोर में जो बाहर से मिलाया जाएगा और पचास ही अंकड़े दूसरी ओर के पर्दे की छोर में जो बाहर से मिलाया जाएगा बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","और पीतल के पचास अंकड़े बनाना, और अंकड़ों को फंदों में लगाकर तम्बू को ऐसा जुड़वाना कि वह मिलकर एक ही हो जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","और तम्बू के परदों का लटका हुआ भाग, अर्थात् जो आधा पट रहेगा, वह निवास की पिछली ओर लटका रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","और तम्बू के परदों की लम्बाई में से हाथ भर इधर, और हाथ भर उधर निवास को ढाँकने के लिये उसकी दोनों ओर पर लटका हुआ रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","फिर तम्बू के लिये लाल रंग से रंगी हुई मेढ़ों की खालों का एक ओढ़ना और उसके ऊपर सुइसों की खालों का भी एक ओढ़ना बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“फिर निवास को खड़ा करने के लिये बबूल की लकड़ी के तख्ते बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","एक-एक तख्ते की लम्बाई दस हाथ और चौड़ाई डेढ़ हाथ की हो। ");
INSERT INTO hin2017_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","एक-एक तख्ते में एक दूसरे से जोड़ी हुई दो-दो चूलें हों; निवास के सब तख्तों को इसी भाँति से बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","और निवास के लिये जो तख्ते तू बनवाएगा उनमें से बीस तख्ते तो दक्षिण की ओर के लिये हों; ");
INSERT INTO hin2017_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","और बीसों तख्तों के नीचे चाँदी की चालीस कुर्सियाँ बनवाना, अर्थात् एक-एक तख्ते के नीचे उसके चूलों के लिये दो-दो कुर्सियाँ। ");
INSERT INTO hin2017_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","और निवास की दूसरी ओर, अर्थात् उत्तर की ओर बीस तख्ते बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","और उनके लिये चाँदी की चालीस कुर्सियाँ बनवाना, अर्थात् एक-एक तख्ते के नीचे दो-दो कुर्सियाँ हों। ");
INSERT INTO hin2017_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","और निवास की पिछली ओर, अर्थात् पश्चिम की ओर के लिए छः तख्ते बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","और पिछले भाग में निवास के कोनों के लिये दो तख्ते बनवाना; ");
INSERT INTO hin2017_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","और ये नीचे से दो-दो भाग के हों और दोनों भाग ऊपर के सिरे तक एक-एक कड़े में मिलाए जाएँ; दोनों तख्तों का यही रूप हो; ये तो दोनों कोनों के लिये हों। ");
INSERT INTO hin2017_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","और आठ तख्ते हों, और उनकी चाँदी की सोलह कुर्सियाँ हों; अर्थात् एक-एक तख्ते के नीचे दो-दो कुर्सियाँ हों। ");
INSERT INTO hin2017_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“फिर बबूल की लकड़ी के बेंड़े बनवाना, अर्थात् निवास की एक ओर के तख्तों के लिये पाँच, ");
INSERT INTO hin2017_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","और निवास की दूसरी ओर के तख्तों के लिये पाँच बेंड़े, और निवास का जो भाग पश्चिम की ओर पिछले भाग में होगा, उसके लिये पाँच बेंड़े बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","बीचवाला बेंड़ा जो तख्तों के मध्य में होगा वह तम्बू के एक सिरे से दूसरे सिरे तक पहुँचे। ");
INSERT INTO hin2017_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","फिर तख्तों को सोने से मढ़वाना, और उनके कड़े जो बेंड़ों के घरों का काम देंगे उन्हें भी सोने के बनवाना; और बेंड़ों को भी सोने से मढ़वाना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","और निवास को इस रीति खड़ा करना जैसा इस पर्वत पर तुझे दिखाया गया है। ");
INSERT INTO hin2017_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“फिर नीले, बैंगनी और लाल रंग के और बटी हुई सूक्ष्म सनीवाले कपड़े का एक बीचवाला परदा बनवाना; वह कढ़ाई के काम किए हुए करूबों के साथ बने। ");
INSERT INTO hin2017_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","और उसको सोने से मढ़े हुए बबूल के चार खम्भों पर लटकाना, इनकी अंकड़ियाँ सोने की हों, और ये चाँदी की चार कुर्सियों पर खड़ी रहें। ");
INSERT INTO hin2017_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","और बीचवाले पर्दे को अंकड़ियों के नीचे लटकाकर, उसकी आड़ में साक्षीपत्र का सन्दूक भीतर ले जाना; सो वह बीचवाला परदा तुम्हारे लिये पवित्रस्थान को परमपवित्र स्थान से अलग किए रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","फिर परमपवित्र स्थान में साक्षीपत्र के सन्दूक के ऊपर प्रायश्चित के ढकने को रखना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","और उस पर्दे के बाहर निवास के उत्तर की ओर मेज रखना; और उसके दक्षिण की ओर मेज के सामने दीवट को रखना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“फिर तम्बू के द्वार के लिये नीले, बैंगनी और लाल रंग के और बटी हुई सूक्ष्म सनीवाले कपड़े का कढ़ाई का काम किया हुआ एक परदा बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","और इस पर्दे के लिये बबूल के पाँच खम्भे बनवाना, और उनको सोने से मढ़वाना; उनकी कड़ियाँ सोने की हों, और उनके लिये पीतल की पाँच कुर्सियाँ ढलवा कर बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“फिर वेदी को बबूल की लकड़ी की, पाँच हाथ लम्बी और पाँच हाथ चौड़ी बनवाना; वेदी चौकोर हो, और उसकी ऊँचाई तीन हाथ की हो। ");
INSERT INTO hin2017_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","और उसके चारों कोनों पर चार सींग बनवाना; वे उस समेत एक ही टुकड़े के हों, और उसे पीतल से मढ़वाना। ");
INSERT INTO hin2017_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","और उसकी राख उठाने के पात्र, और फावड़ियां, और कटोरे, और काँटे, और अँगीठियाँ बनवाना; उसका कुल सामान पीतल का बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","और उसके पीतल की जाली की एक झंझरी बनवाना; और उसके चारों सिरों में पीतल के चार कड़े लगवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","और उस झंझरी को वेदी के चारों ओर की कँगनी के नीचे ऐसे लगवाना कि वह वेदी की ऊँचाई के मध्य तक पहुँचे। ");
INSERT INTO hin2017_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","और वेदी के लिये बबूल की लकड़ी के डंडे बनवाना, और उन्हें पीतल से मढ़वाना। ");
INSERT INTO hin2017_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","और डंडे कड़ों में डाले जाएँ, कि जब जब वेदी उठाई जाए तब वे उसकी दोनों ओर पर रहें। ");
INSERT INTO hin2017_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","वेदी को तख्तों से खोखली बनवाना; जैसी वह इस पर्वत पर तुझे दिखाई गई है वैसी ही बनाई जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“फिर निवास के आँगन को बनवाना। उसकी दक्षिण ओर के लिये तो बटी हुई सूक्ष्म सनी के कपड़े के सब पर्दों को मिलाए कि उसकी लम्बाई सौ हाथ की हो; एक ओर पर तो इतना ही हो। ");
INSERT INTO hin2017_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","और उनके बीस खम्भे बनें, और इनके लिये पीतल की बीस कुर्सियाँ बनें, और खम्भों के कुण्डे और उनकी पट्टियाँ चाँदी की हों। ");
INSERT INTO hin2017_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","और उसी भाँति आँगन की उत्तर ओर की लम्बाई में भी सौ हाथ लम्बे पर्दे हों, और उनके भी बीस खम्भे और इनके लिये भी पीतल के बीस खाने हों; और उन खम्भों के कुण्डे और पट्टियाँ चाँदी की हों। ");
INSERT INTO hin2017_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","फिर आँगन की चौड़ाई में पश्चिम की ओर पचास हाथ के पर्दे हों, उनके खम्भे दस और खाने भी दस हों। ");
INSERT INTO hin2017_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","पूरब की ओर पर आँगन की चौड़ाई पचास हाथ की हो। ");
INSERT INTO hin2017_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","और आँगन के द्वार की एक ओर पन्द्रह हाथ के पर्दे हों, और उनके खम्भे तीन और खाने तीन हों। ");
INSERT INTO hin2017_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","और दूसरी ओर भी पन्द्रह हाथ के पर्दे हों, उनके भी खम्भे तीन और खाने तीन हों। ");
INSERT INTO hin2017_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","आँगन के द्वार के लिये एक परदा बनवाना, जो नीले, बैंगनी और लाल रंग के कपड़े और बटी हुई सूक्ष्म सनी के कपड़े का कामदार बना हुआ बीस हाथ का हो, उसके खम्भे चार और खाने भी चार हों। ");
INSERT INTO hin2017_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","आँगन के चारों ओर के सब खम्भे चाँदी की पट्टियों से जुड़े हुए हों, उनके कुण्डे चाँदी के और खाने पीतल के हों। ");
INSERT INTO hin2017_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","आँगन की लम्बाई सौ हाथ की, और उसकी चौड़ाई बराबर पचास हाथ की और उसकी कनात की ऊँचाई पाँच हाथ की हो, उसकी कनात बटी हुई सूक्ष्म सनी के कपड़े की बने, और खम्भों के खाने पीतल के हों। ");
INSERT INTO hin2017_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","निवास के भाँति-भाँति के बर्तन और सब सामान और उसके सब खूँटे और आँगन के भी सब खूँटे पीतल ही के हों। ");
INSERT INTO hin2017_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“फिर तू इस्राएलियों को आज्ञा देना, कि मेरे पास दीवट के लिये कूट के निकाला हुआ जैतून का निर्मल तेल ले आना, जिससे दीपक नित्य जलता रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","मिलापवाले तम्बू में, उस बीचवाले पर्दे से बाहर जो साक्षीपत्र के आगे होगा, हारून और उसके पुत्र दीवट साँझ से भोर तक यहोवा के सामने सजा कर रखें। यह विधि इस्राएलियों की पीढ़ियों के लिये सदैव बनी रहेगी। ");
INSERT INTO hin2017_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“फिर तू इस्राएलियों में से अपने भाई हारून, और नादाब, अबीहू, एलीआजर और ईतामार नामक उसके पुत्रों को अपने समीप ले आना कि वे मेरे लिये याजक का काम करें। ");
INSERT INTO hin2017_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","और तू अपने भाई हारून के लिये वैभव और शोभा के निमित्त पवित्र वस्त्र बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","और जितनों के हृदय में बुद्धि है, जिनको मैंने बुद्धि देनेवाली आत्मा से परिपूर्ण किया है, उनको तू हारून के वस्त्र बनाने की आज्ञा दे कि वह मेरे निमित्त याजक का काम करने के लिये पवित्र बनें। ");
INSERT INTO hin2017_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","और जो वस्त्र उन्हें बनाने होंगे वे ये हैं, अर्थात् सीनाबन्ध; और एपोद, और बागा, चार खाने का अंगरखा, पुरोहित का टोप, और कमरबन्द; ये ही पवित्र वस्त्र तेरे भाई हारून और उसके पुत्रों के लिये बनाएँ जाएँ कि वे मेरे लिये याजक का काम करें। ");
INSERT INTO hin2017_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","और वे सोने और नीले और बैंगनी और लाल रंग का और सूक्ष्म सनी का कपड़ा लें। ");
INSERT INTO hin2017_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“वे एपोद को सोने, और नीले, बैंगनी और लाल रंग के कपड़े का और बटी हुई सूक्ष्म सनी के कपड़े का बनाएँ, जो कि निपुण कढ़ाई के काम करनेवाले के हाथ का काम हो। ");
INSERT INTO hin2017_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","और वह इस तरह से जोड़ा जाए कि उसके दोनों कंधों के सिरे आपस में मिले रहें। ");
INSERT INTO hin2017_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","और एपोद पर जो काढ़ा हुआ पटुका होगा उसकी बनावट उसी के समान हो, और वे दोनों बिना जोड़ के हों, और सोने और नीले, बैंगनी और लाल रंगवाले और बटी हुई सूक्ष्म सनीवाले कपड़े के हों। ");
INSERT INTO hin2017_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","फिर दो सुलैमानी मणि लेकर उन पर इस्राएल के पुत्रों के नाम खुदवाना, ");
INSERT INTO hin2017_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","उनके नामों में से छः तो एक मणि पर, और शेष छः नाम दूसरे मणि पर, इस्राएल के पुत्रों की उत्पत्ति के अनुसार खुदवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","मणि गढ़नेवाले के काम के समान जैसे छापा खोदा जाता है, वैसे ही उन दो मणियों पर इस्राएल के पुत्रों के नाम खुदवाना; और उनको सोने के खानों में जड़वा देना। ");
INSERT INTO hin2017_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","और दोनों मणियों को एपोद के कंधों पर लगवाना, वे इस्राएलियों के निमित्त स्मरण दिलवाने वाले मणि ठहरेंगे; अर्थात् हारून उनके नाम यहोवा के आगे अपने दोनों कंधों पर स्मरण के लिये लगाए रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","“फिर सोने के खाने बनवाना, ");
INSERT INTO hin2017_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","और डोरियों के समान गूँथे हुए दो जंजीर शुद्ध सोने के बनवाना; और गूँथे हुए जंजीरों को उन खानों में जड़वाना। ");
INSERT INTO hin2017_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“फिर न्याय की चपरास को भी कढ़ाई के काम का बनवाना; एपोद के समान सोने, और नीले, बैंगनी और लाल रंग के और बटी हुई सूक्ष्म सनी के कपड़े की उसे बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","वह चौकोर और दोहरी हो, और उसकी लम्बाई और चौड़ाई एक-एक बिलांद की हो। ");
INSERT INTO hin2017_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","और उसमें चार पंक्ति मणि जड़ाना। पहली पंक्ति में तो माणिक्य, पद्मराग और लालड़ी हों; ");
INSERT INTO hin2017_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दूसरी पंक्ति में मरकत, नीलमणि और हीरा; ");
INSERT INTO hin2017_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तीसरी पंक्ति में लशम, सूर्यकांत और नीलम; ");
INSERT INTO hin2017_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","और चौथी पंक्ति में फीरोजा, सुलैमानी मणि और यशब हों; ये सब सोने के खानों में जड़े जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","और इस्राएल के पुत्रों के जितने नाम हैं उतने मणि हों, अर्थात् उनके नामों की गिनती के अनुसार बारह नाम खुदें, बारहों गोत्रों में से एक-एक का नाम एक-एक मणि पर ऐसे खुदे जैसे छापा खोदा जाता है। ");
INSERT INTO hin2017_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","फिर चपरास पर डोरियों के समान गूँथे हुए शुद्ध सोने की जंजीर लगवाना; ");
INSERT INTO hin2017_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","और चपरास में सोने की दो कड़ियाँ लगवाना, और दोनों कड़ियों को चपरास के दोनों सिरों पर लगवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","और सोने के दोनों गूँथे जंजीरों को उन दोनों कड़ियों में जो चपरास के सिरों पर होंगी लगवाना; ");
INSERT INTO hin2017_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","और गूँथे हुए दोनों जंजीरों के दोनों बाकी सिरों को दोनों खानों में जड़वा के एपोद के दोनों कंधों के बंधनों पर उसके सामने लगवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","फिर सोने की दो और कड़ियाँ बनवाकर चपरास के दोनों सिरों पर, उसकी उस कोर पर जो एपोद के भीतर की ओर होगी लगवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","फिर उनके सिवाय सोने की दो और कड़ियाँ बनवाकर एपोद के दोनों कंधों के बंधनों पर, नीचे से उनके सामने और उसके जोड़ के पास एपोद के काढ़े हुए पटुके के ऊपर लगवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","और चपरास अपनी कड़ियों के द्वारा एपोद की कड़ियों में नीले फीते से बाँधी जाए, इस रीति वह एपोद के काढ़े हुए पटुके पर बनी रहे, और चपरास एपोद पर से अलग न होने पाए। ");
INSERT INTO hin2017_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","और जब जब हारून पवित्रस्थान में प्रवेश करे, तब-तब वह न्याय की चपरास पर अपने हृदय के ऊपर इस्राएलियों के नामों को लगाए रहे, जिससे यहोवा के सामने उनका स्मरण नित्य रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","और तू न्याय की चपरास में ऊरीम और तुम्मीम को रखना, और जब जब हारून यहोवा के सामने प्रवेश करे, तब-तब वे उसके हृदय के ऊपर हों; इस प्रकार हारून इस्राएलियों के लिये यहोवा के न्याय को अपने हृदय के ऊपर यहोवा के सामने नित्य लगाए रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“फिर एपोद के बागे को सम्पूर्ण नीले रंग का बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","उसकी बनावट ऐसी हो कि उसके बीच में सिर डालने के लिये छेद हो, और उस छेद के चारों ओर बख्तर के छेद की सी एक बुनी हुई कोर हो कि वह फटने न पाए। ");
INSERT INTO hin2017_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","और उसके नीचेवाले घेरे में चारों ओर नीले, बैंगनी और लाल रंग के कपड़े के अनार बनवाना, और उनके बीच-बीच चारों ओर सोने की घंटियाँ लगवाना, ");
INSERT INTO hin2017_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","अर्थात् एक सोने की घंटी और एक अनार, फिर एक सोने की घंटी और एक अनार, इसी रीति बागे के नीचेवाले घेरे में चारों ओर ऐसा ही हो। ");
INSERT INTO hin2017_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","और हारून उस बागे को सेवा टहल करने के समय पहना करे, कि जब जब वह पवित्रस्थान के भीतर यहोवा के सामने जाए, या बाहर निकले, तब-तब उसका शब्द सुनाई दे, नहीं तो वह मर जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“फिर शुद्ध सोने का एक टीका बनवाना, और जैसे छापे में वैसे ही उसमें ये अक्षर खोदे जाएँ, अर्थात् ‘यहोवा के लिये पवित्र।’ ");
INSERT INTO hin2017_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","और उसे नीले फीते से बाँधना; और वह पगड़ी के सामने के हिस्से पर रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","और वह हारून के माथे पर रहे, इसलिए कि इस्राएली जो कुछ पवित्र ठहराएँ, अर्थात् जितनी पवित्र वस्तुएँ भेंट में चढ़ावे उन पवित्र वस्तुओं का दोष हारून उठाए रहे, और वह नित्य उसके माथे पर रहे, जिससे यहोवा उनसे प्रसन्न रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“अंगरखे को सूक्ष्म सनी के कपड़े का चारखाना बुनवाना, और एक पगड़ी भी सूक्ष्म सनी के कपड़े की बनवाना, और बेलबूटे की कढ़ाई का काम किया हुआ एक कमरबन्द भी बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“फिर हारून के पुत्रों के लिये भी अंगरखे और कमरबन्द और टोपियाँ बनवाना; ये वस्त्र भी वैभव और शोभा के लिये बनें। ");
INSERT INTO hin2017_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","अपने भाई हारून और उसके पुत्रों को ये ही सब वस्त्र पहनाकर उनका अभिषेक और संस्कार करना, और उन्हें पवित्र करना कि वे मेरे लिये याजक का काम करें। ");
INSERT INTO hin2017_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","और उनके लिये सनी के कपड़े की जाँघिया बनवाना जिनसे उनका तन ढँपा रहे; वे कमर से जाँघ तक की हों; ");
INSERT INTO hin2017_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","और जब जब हारून या उसके पुत्र मिलापवाले तम्बू में प्रवेश करें, या पवित्रस्थान में सेवा टहल करने को वेदी के पास जाएँ तब-तब वे उन जाँघियों को पहने रहें, न हो कि वे पापी ठहरें और मर जाएँ। यह हारून के लिये और उसके बाद उसके वंश के लिये भी सदा की विधि ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“उन्हें पवित्र करने को जो काम तुझे उनसे करना है कि वे मेरे लिये याजक का काम करें वह यह है: एक निर्दोष बछड़ा और दो निर्दोष मेढ़े लेना, ");
INSERT INTO hin2017_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","और अख़मीरी रोटी, और तेल से सने हुए मैदे के अख़मीरी फुलके, और तेल से चुपड़ी हुई अख़मीरी पपड़ियाँ भी लेना। ये सब गेहूँ के मैदे के बनवाना। ");
INSERT INTO hin2017_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","इनको एक टोकरी में रखकर उस टोकरी को उस बछड़े और उन दोनों मेढ़ों समेत समीप ले आना। ");
INSERT INTO hin2017_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","फिर हारून और उसके पुत्रों को मिलापवाले तम्बू के द्वार के समीप ले आकर जल से नहलाना। ");
INSERT INTO hin2017_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","तब उन वस्त्रों को लेकर हारून को अंगरखा और एपोद का बागा पहनाना, और एपोद और चपरास बाँधना, और एपोद का काढ़ा हुआ पटुका भी बाँधना; ");
INSERT INTO hin2017_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","और उसके सिर पर पगड़ी को रखना, और पगड़ी पर पवित्र मुकुट को रखना। ");
INSERT INTO hin2017_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","तब अभिषेक का तेल ले उसके सिर पर डालकर उसका अभिषेक करना। ");
INSERT INTO hin2017_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","फिर उसके पुत्रों को समीप ले आकर उनको अंगरखे पहनाना, ");
INSERT INTO hin2017_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","और उसके अर्थात् हारून और उसके पुत्रों के कमर बाँधना और उनके सिर पर टोपियाँ रखना; जिससे याजक के पद पर सदा उनका हक़ रहे। इसी प्रकार हारून और उसके पुत्रों का संस्कार करना। ");
INSERT INTO hin2017_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“तब बछड़े को मिलापवाले तम्बू के सामने समीप ले आना। और हारून और उसके पुत्र बछड़े के सिर पर अपने-अपने हाथ रखें, ");
INSERT INTO hin2017_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","तब उस बछड़े को यहोवा के सम्मुख मिलापवाले तम्बू के द्वार पर बलिदान करना, ");
INSERT INTO hin2017_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","और बछड़े के लहू में से कुछ लेकर अपनी उँगली से वेदी के सींगों पर लगाना, और शेष सब लहू को वेदी के पाए पर उण्डेल देना, ");
INSERT INTO hin2017_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","और जिस चर्बी से अंतड़ियाँ ढपी रहती हैं, और जो झिल्ली कलेजे के ऊपर होती है, उनको और दोनों गुर्दों को उनके ऊपर की चर्बी समेत लेकर सब को वेदी पर जलाना। ");
INSERT INTO hin2017_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","परन्तु बछड़े का माँस, और खाल, और गोबर, छावनी से बाहर आग में जला देना; क्योंकि यह पापबलि होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“फिर एक मेढ़ा लेना, और हारून और उसके पुत्र उसके सिर पर अपने-अपने हाथ रखें, ");
INSERT INTO hin2017_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","तब उस मेढ़े को बलि करना, और उसका लहू लेकर वेदी पर चारों ओर छिड़कना। ");
INSERT INTO hin2017_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","और उस मेढ़े को टुकड़े-टुकड़े काटना, और उसकी अंतड़ियों और पैरों को धोकर उसके टुकड़ों और सिर के ऊपर रखना, ");
INSERT INTO hin2017_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","तब उस पूरे मेढ़े को वेदी पर जलाना; वह तो यहोवा के लिये होमबलि होगा; वह सुखदायक सुगन्ध और यहोवा के लिये हवन होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“फिर दूसरे मेढ़े को लेना; और हारून और उसके पुत्र उसके सिर पर अपने-अपने हाथ रखें, ");
INSERT INTO hin2017_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","तब उस मेढ़े को बलि करना, और उसके लहू में से कुछ लेकर हारून और उसके पुत्रों के दाहिने कान के सिरे पर, और उनके दाहिने हाथ और दाहिने पाँव के अँगूठों पर लगाना, और लहू को वेदी पर चारों ओर छिड़क देना। ");
INSERT INTO hin2017_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","फिर वेदी पर के लहू, और अभिषेक के तेल, इन दोनों में से कुछ कुछ लेकर हारून और उसके वस्त्रों पर, और उसके पुत्रों और उनके वस्त्रों पर भी छिड़क देना; तब वह अपने वस्त्रों समेत और उसके पुत्र भी अपने-अपने वस्त्रों समेत पवित्र हो जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","तब मेढ़े को संस्कारवाला जानकर उसमें से चर्बी और मोटी पूँछ को, और जिस चर्बी से अंतड़ियाँ ढपी रहती हैं उसको, और कलेजे पर की झिल्ली को, और चर्बी समेत दोनों गुर्दों को, और दाहिने पुट्ठे को लेना, ");
INSERT INTO hin2017_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","और अख़मीरी रोटी की टोकरी जो यहोवा के आगे धरी होगी उसमें से भी एक रोटी, और तेल से सने हुए मैदे का एक फुलका, और एक पपड़ी लेकर, ");
INSERT INTO hin2017_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","इन सब को हारून और उसके पुत्रों के हाथों में रखकर हिलाए जाने की भेंट ठहराकर यहोवा के आगे हिलाया जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","तब उन वस्तुओं को उनके हाथों से लेकर होमबलि की वेदी पर जला देना, जिससे वह यहोवा के सामने सुखदायक सुगन्ध ठहरे; वह तो यहोवा के लिये हवन होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“फिर हारून के संस्कार को जो मेढ़ा होगा उसकी छाती को लेकर हिलाए जाने की भेंट के लिये यहोवा के आगे हिलाना; और वह तेरा भाग ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","और हारून और उसके पुत्रों के संस्कार का जो मेढ़ा होगा, उसमें से हिलाए जाने की भेंटवाली छाती जो हिलाई जाएगी, और उठाए जाने का भेंटवाला पुट्ठा जो उठाया जाएगा, इन दोनों को पवित्र ठहराना। ");
INSERT INTO hin2017_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","और ये सदा की विधि की रीति पर इस्राएलियों की ओर से उसका और उसके पुत्रों का भाग ठहरे, क्योंकि ये उठाए जाने की भेंटें ठहरी हैं; और यह इस्राएलियों की ओर से उनके मेलबलियों में से यहोवा के लिये उठाए जाने की भेंट होगी। ");
INSERT INTO hin2017_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“हारून के जो पवित्र वस्त्र होंगे वह उसके बाद उसके बेटे पोते आदि को मिलते रहें, जिससे उन्हीं को पहने हुए उनका अभिषेक और संस्कार किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","उसके पुत्रों के जो उसके स्थान पर याजक होगा, वह जब पवित्रस्थान में सेवा टहल करने को मिलापवाले तम्बू में पहले आए, तब उन वस्त्रों को सात दिन तक पहने रहें। ");
INSERT INTO hin2017_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“फिर याजक के संस्कार का जो मेढ़ा होगा उसे लेकर उसका माँस किसी पवित्रस्थान में पकाना; ");
INSERT INTO hin2017_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","तब हारून अपने पुत्रों समेत उस मेढ़े का माँस और टोकरी की रोटी, दोनों को मिलापवाले तम्बू के द्वार पर खाए। ");
INSERT INTO hin2017_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","जिन पदार्थों से उनका संस्कार और उन्हें पवित्र करने के लिये प्रायश्चित किया जाएगा उनको तो वे खाएँ, परन्तु पराए कुल का कोई उन्हें न खाने पाए, क्योंकि वे पवित्र होंगे। ");
INSERT INTO hin2017_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","यदि संस्कारवाले माँस या रोटी में से कुछ सवेरे तक बचा रहे, तो उस बचे हुए को आग में जलाना, वह खाया न जाए; क्योंकि वह पवित्र होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“मैंने तुझे जो-जो आज्ञा दी हैं, उन सभी के अनुसार तू हारून और उसके पुत्रों से करना; और सात दिन तक उनका संस्कार करते रहना, ");
INSERT INTO hin2017_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","अर्थात् पापबलि का एक बछड़ा प्रायश्चित के लिये प्रतिदिन चढ़ाना। और वेदी को भी प्रायश्चित करने के समय शुद्ध करना, और उसे पवित्र करने के लिये उसका अभिषेक करना। ");
INSERT INTO hin2017_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","सात दिन तक वेदी के लिये प्रायश्चित करके उसे पवित्र करना, और वेदी परमपवित्र ठहरेगी; और जो कुछ उससे छू जाएगा वह भी पवित्र हो जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“जो तुझे वेदी पर नित्य चढ़ाना होगा वह यह है; अर्थात् प्रतिदिन एक-एक वर्ष के दो भेड़ी के बच्चे। ");
INSERT INTO hin2017_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","एक भेड़ के बच्चे को तो भोर के समय, और दूसरे भेड़ के बच्चे को साँझ के समय चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","और एक भेड़ के बच्चे के संग हीन की चौथाई कूटकर निकाले हुए तेल से सना हुआ एपा का दसवाँ भाग मैदा, और अर्घ के लिये ही की चौथाई दाखमधु देना। ");
INSERT INTO hin2017_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","और दूसरे भेड़ के बच्चे को साँझ के समय चढ़ाना, और उसके साथ भोर की रीति अनुसार अन्नबलि और अर्घ दोनों देना, जिससे वह सुखदायक सुगन्ध और यहोवा के लिये हवन ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","तुम्हारी पीढ़ी से पीढ़ी में यहोवा के आगे मिलापवाले तम्बू के द्वार पर नित्य ऐसा ही होमबलि हुआ करे; यह वह स्थान है जिसमें मैं तुम लोगों से इसलिए मिला करूँगा कि तुझ से बातें करूँ। ");
INSERT INTO hin2017_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","मैं इस्राएलियों से वहीं मिला करूँगा, और वह तम्बू मेरे तेज से पवित्र किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","और मैं मिलापवाले तम्बू और वेदी को पवित्र करूँगा, और हारून और उसके पुत्रों को भी पवित्र करूँगा कि वे मेरे लिये याजक का काम करें। ");
INSERT INTO hin2017_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","और मैं इस्राएलियों के मध्य निवास करूँगा, और उनका परमेश्वर ठहरूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","तब वे जान लेंगे कि मैं यहोवा उनका परमेश्वर हूँ, जो उनको मिस्र देश से इसलिए निकाल ले आया, कि उनके मध्य निवास करूँ; मैं ही उनका परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“फिर धूप जलाने के लिये बबूल की लकड़ी की वेदी बनाना। ");
INSERT INTO hin2017_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","उसकी लम्बाई एक हाथ और चौड़ाई एक हाथ की हो, वह चौकोर हो, और उसकी ऊँचाई दो हाथ की हो, और उसके सींग उसी टुकड़े से बनाए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","और वेदी के ऊपरवाले पल्ले और चारों ओर के बाजुओं और सींगों को शुद्ध सोने से मढ़ना, और इसके चारों ओर सोने की एक बाड़ बनाना। ");
INSERT INTO hin2017_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","और इसकी बाड़ के नीचे इसके आमने-सामने के दोनों पल्लों पर सोने के दो-दो कड़े बनाकर इसके दोनों ओर लगाना, वे इसके उठाने के डंडों के खानों का काम देंगे। ");
INSERT INTO hin2017_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","डंडों को बबूल की लकड़ी के बनाकर उनको सोने से मढ़ना। ");
INSERT INTO hin2017_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","और तू उसको उस पर्दे के आगे रखना जो साक्षीपत्र के सन्दूक के सामने है, अर्थात् प्रायश्चितवाले ढकने के आगे जो साक्षीपत्र के ऊपर है, वहीं मैं तुझ से मिला करूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","और उसी वेदी पर हारून सुगन्धित धूप जलाया करे; प्रतिदिन भोर को जब वह दीपक को ठीक करे तब वह धूप को जलाए, ");
INSERT INTO hin2017_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","तब साँझ के समय जब हारून दीपकों को जलाए तब धूप जलाया करे, यह धूप यहोवा के सामने तुम्हारी पीढ़ी-पीढ़ी में नित्य जलाया जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","और उस वेदी पर तुम और प्रकार का धूप न जलाना, और न उस पर होमबलि और न अन्नबलि चढ़ाना; और न इस पर अर्घ देना। ");
INSERT INTO hin2017_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","हारून वर्ष में एक बार इसके सींगों पर प्रायश्चित करे; और तुम्हारी पीढ़ी-पीढ़ी में वर्ष में एक बार प्रायश्चित के पापबलि के लहू से इस पर प्रायश्चित किया जाए; यह यहोवा के लिये परमपवित्र है।” ");
INSERT INTO hin2017_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","और तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“जब तू इस्राएलियों की गिनती लेने लगे, तब वे गिनने के समय जिनकी गिनती हुई हो अपने-अपने प्राणों के लिये यहोवा को प्रायश्चित दें, जिससे जब तू उनकी गिनती कर रहा हो उस समय कोई विपत्ति उन पर न आ पड़े। ");
INSERT INTO hin2017_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","जितने लोग गिने जाएँ वे पवित्रस्थान के शेकेल के अनुसार आधा शेकेल दें, (यह शेकेल बीस गेरा का होता है), यहोवा की भेंट आधा शेकेल हो। ");
INSERT INTO hin2017_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","बीस वर्ष के या उससे अधिक अवस्था के जितने गिने जाएँ उनमें से एक-एक जन यहोवा को भेंट दे। ");
INSERT INTO hin2017_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","जब तुम्हारे प्राणों के प्रायश्चित के निमित्त यहोवा की भेंट अर्पित की जाए, तब न तो धनी लोग आधे शेकेल से अधिक दें, और न कंगाल लोग उससे कम दें। ");
INSERT INTO hin2017_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","और तू इस्राएलियों से प्रायश्चित का रुपया लेकर मिलापवाले तम्बू के काम में लगाना; जिससे वह यहोवा के सम्मुख इस्राएलियों के स्मरणार्थ चिन्ह ठहरे, और उनके प्राणों का प्रायश्चित भी हो।” ");
INSERT INTO hin2017_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","और यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“धोने के लिये पीतल की एक हौदी और उसका पाया भी पीतल का बनाना। और उसे मिलापवाले तम्बू और वेदी के बीच में रखकर उसमें जल भर देना; ");
INSERT INTO hin2017_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","और उसमें हारून और उसके पुत्र अपने-अपने हाथ पाँव धोया करें। ");
INSERT INTO hin2017_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","जब जब वे मिलापवाले तम्बू में प्रवेश करें तब-तब वे हाथ पाँव जल से धोएँ, नहीं तो मर जाएँगे; और जब जब वे वेदी के पास सेवा टहल करने, अर्थात् यहोवा के लिये हव्य जलाने को आएँ तब-तब वे हाथ पाँव धोएँ, न हो कि मर जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","यह हारून और उसके पीढ़ी-पीढ़ी के वंश के लिये सदा की विधि ठहरे।” ");
INSERT INTO hin2017_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“तू उत्तम से उत्तम सुगन्ध-द्रव्य ले, अर्थात् पवित्रस्थान के शेकेल के अनुसार पाँच सौ शेकेल अपने आप निकला हुआ गन्धरस, और उसका आधा, अर्थात् ढाई सौ शेकेल सुगन्धित दालचीनी और ढाई सौ शेकेल सुगन्धित अगर, ");
INSERT INTO hin2017_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","और पाँच सौ शेकेल तज, और एक हीन जैतून का तेल लेकर ");
INSERT INTO hin2017_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","उनसे अभिषेक का पवित्र तेल, अर्थात् गंधी की रीति से तैयार किया हुआ सुगन्धित तेल बनवाना; यह अभिषेक का पवित्र तेल ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","और उससे मिलापवाले तम्बू का, और साक्षीपत्र के सन्दूक का, ");
INSERT INTO hin2017_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","और सारे सामान समेत मेज का, और सामान समेत दीवट का, और धूपवेदी का, ");
INSERT INTO hin2017_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","और सारे सामान समेत होमवेदी का, और पाए समेत हौदी का अभिषेक करना। ");
INSERT INTO hin2017_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","और उनको पवित्र करना, जिससे वे परमपवित्र ठहरें; और जो कुछ उनसे छू जाएगा वह पवित्र हो जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","फिर हारून का उसके पुत्रों के साथ अभिषेक करना, और इस प्रकार उन्हें मेरे लिये याजक का काम करने के लिये पवित्र करना। ");
INSERT INTO hin2017_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","और इस्राएलियों को मेरी यह आज्ञा सुनाना, ‘यह तेल तुम्हारी पीढ़ी-पीढ़ी में मेरे लिये पवित्र अभिषेक का तेल होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","यह किसी मनुष्य की देह पर न डाला जाए, और मिलावट में उसके समान और कुछ न बनाना; यह पवित्र है, यह तुम्हारे लिये भी पवित्र होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","जो कोई इसके समान कुछ बनाए, या जो कोई इसमें से कुछ पराए कुलवाले पर लगाए, वह अपने लोगों में से नाश किया जाए।’” ");
INSERT INTO hin2017_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","फिर यहोवा ने मूसा से कहा, “बोल, नखी और कुन्दरू, ये सुगन्ध-द्रव्य निर्मल लोबान समेत ले लेना, ये सब एक तौल के हों, ");
INSERT INTO hin2017_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","और इनका धूप अर्थात् नमक मिलाकर गंधी की रीति के अनुसार शुद्ध और पवित्र सुगन्ध-द्रव्य बनवाना; ");
INSERT INTO hin2017_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","फिर उसमें से कुछ पीसकर बारीक कर डालना, तब उसमें से कुछ मिलापवाले तम्बू में साक्षीपत्र के आगे, जहाँ पर मैं तुझ से मिला करूँगा वहाँ रखना; वह तुम्हारे लिये परमपवित्र होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","और जो धूप तू बनवाएगा, मिलावट में उसके समान तुम लोग अपने लिये और कुछ न बनवाना; वह तुम्हारे आगे यहोवा के लिये पवित्र होगा। ");
INSERT INTO hin2017_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","जो कोई सूँघने के लिये उसके समान कुछ बनाए वह अपने लोगों में से नाश किया जाए।” ");
INSERT INTO hin2017_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“सुन, मैं ऊरी के पुत्र बसलेल को, जो हूर का पोता और यहूदा के गोत्र का है, नाम लेकर बुलाता हूँ। ");
INSERT INTO hin2017_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","और मैं उसको परमेश्वर की आत्मा से जो बुद्धि, प्रवीणता, ज्ञान, और सब प्रकार के कार्यों की समझ देनेवाली आत्मा है परिपूर्ण करता हूँ, ");
INSERT INTO hin2017_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","जिससे वह कारीगरी के कार्य बुद्धि से निकाल निकालकर सब भाँति की बनावट में, अर्थात् सोने, चाँदी, और पीतल में, ");
INSERT INTO hin2017_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","और जड़ने के लिये मणि काटने में, और लकड़ी पर नक्काशी का काम करे। ");
INSERT INTO hin2017_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","और सुन, मैं दान के गोत्रवाले अहीसामाक के पुत्र ओहोलीआब को उसके संग कर देता हूँ; वरन् जितने बुद्धिमान हैं उन सभी के हृदय में मैं बुद्धि देता हूँ, जिससे जितनी वस्तुओं की आज्ञा मैंने तुझे दी है उन सभी को वे बनाएँ; ");
INSERT INTO hin2017_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","अर्थात् मिलापवाले तम्बू, और साक्षीपत्र का सन्दूक, और उस पर का प्रायश्चितवाला ढकना, और तम्बू का सारा सामान, ");
INSERT INTO hin2017_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","और सामान सहित मेज, और सारे सामान समेत शुद्ध सोने की दीवट, और धूपवेदी, ");
INSERT INTO hin2017_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","और सारे सामान सहित होमवेदी, और पाए समेत हौदी, ");
INSERT INTO hin2017_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","और काढ़े हुए वस्त्र, और हारून याजक के याजकवाले काम के पवित्र वस्त्र, और उसके पुत्रों के वस्त्र, ");
INSERT INTO hin2017_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","और अभिषेक का तेल, और पवित्रस्थान के लिये सुगन्धित धूप, इन सभी को वे उन सब आज्ञाओं के अनुसार बनाएँ जो मैंने तुझे दी हैं।” ");
INSERT INTO hin2017_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“तू इस्राएलियों से यह भी कहना, ‘निश्चय तुम मेरे विश्रामदिनों को मानना, क्योंकि तुम्हारी पीढ़ी-पीढ़ी में मेरे और तुम लोगों के बीच यह एक चिन्ह ठहरा है, जिससे तुम यह बात जान रखो कि यहोवा हमारा पवित्र करनेवाला है। ");
INSERT INTO hin2017_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","इस कारण तुम विश्रामदिन को मानना, क्योंकि वह तुम्हारे लिये पवित्र ठहरा है; जो उसको अपवित्र करे वह निश्चय मार डाला जाए; जो कोई उस दिन में कुछ काम-काज करे वह प्राणी अपने लोगों के बीच से नाश किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","छः दिन तो काम-काज किया जाए, पर सातवाँ दिन पवित्र विश्राम का दिन और यहोवा के लिये पवित्र है; इसलिए जो कोई विश्राम के दिन में कुछ काम-काज करे वह निश्चय मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","इसलिए इस्राएली विश्रामदिन को माना करें, वरन् पीढ़ी-पीढ़ी में उसको सदा की वाचा का विषय जानकर माना करें। ");
INSERT INTO hin2017_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","वह मेरे और इस्राएलियों के बीच सदा एक चिन्ह रहेगा, क्योंकि छः दिन में यहोवा ने आकाश और पृथ्वी को बनाया, और सातवें दिन विश्राम करके अपना जी ठंडा किया।’” ");
INSERT INTO hin2017_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","जब परमेश्वर मूसा से सीनै पर्वत पर ऐसी बातें कर चुका, तब परमेश्वर ने उसको अपनी उँगली से लिखी हुई साक्षी देनेवाली पत्थर की दोनों तख्तियाँ दीं। ");
INSERT INTO hin2017_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","जब लोगों ने देखा कि मूसा को पर्वत से उतरने में विलम्ब हो रहा है, तब वे हारून के पास इकट्ठे होकर कहने लगे, “अब हमारे लिये देवता बना, जो हमारे आगे-आगे चले; क्योंकि उस पुरुष मूसा को जो हमें मिस्र देश से निकाल ले आया है, हम नहीं जानते कि उसे क्या हुआ?” ");
INSERT INTO hin2017_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","हारून ने उनसे कहा, “तुम्हारी स्त्रियों और बेटे बेटियों के कानों में सोने की जो बालियाँ हैं उन्हें उतारो, और मेरे पास ले आओ।” ");
INSERT INTO hin2017_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","तब सब लोगों ने उनके कानों से सोने की बालियों को उतारा, और हारून के पास ले आए। ");
INSERT INTO hin2017_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","और हारून ने उन्हें उनके हाथ से लिया, और एक बछड़ा ढालकर बनाया, और टाँकी से गढ़ा। तब वे कहने लगे, “हे इस्राएल तेरा ईश्वर जो तुझे मिस्र देश से छुड़ा लाया है वह यही है।” ");
INSERT INTO hin2017_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","यह देखकर हारून ने उसके आगे एक वेदी बनवाई; और यह प्रचार किया, “कल यहोवा के लिये पर्व होगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","और दूसरे दिन लोगों ने भोर को उठकर होमबलि चढ़ाए, और मेलबलि ले आए; फिर बैठकर खाया पिया, और उठकर खेलने लगे। ");
INSERT INTO hin2017_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","तब यहोवा ने मूसा से कहा, “नीचे उतर जा, क्योंकि तेरी प्रजा के लोग, जिन्हें तू मिस्र देश से निकाल ले आया है, वे बिगड़ गए हैं; ");
INSERT INTO hin2017_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","और जिस मार्ग पर चलने की आज्ञा मैंने उनको दी थी उसको झटपट छोड़कर उन्होंने एक बछड़ा ढालकर बना लिया, फिर उसको दण्डवत् किया, और उसके लिये बलिदान भी चढ़ाया, और यह कहा है, ‘हे इस्राएलियों तुम्हारा ईश्वर जो तुम्हें मिस्र देश से छुड़ा ले आया है वह यही है।’” ");
INSERT INTO hin2017_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","फिर यहोवा ने मूसा से कहा, “मैंने इन लोगों को देखा, और सुन, वे हठीले हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","अब मुझे मत रोक, मेरा कोप उन पर भड़क उठा है जिससे मैं उन्हें भस्म करूँ; परन्तु तुझ से एक बड़ी जाति उपजाऊँगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","तब मूसा अपने परमेश्वर यहोवा को यह कहकर मनाने लगा, “हे यहोवा, तेरा कोप अपनी प्रजा पर क्यों भड़का है, जिसे तू बड़े सामर्थ्य और बलवन्त हाथ के द्वारा मिस्र देश से निकाल लाया है? ");
INSERT INTO hin2017_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","मिस्री लोग यह क्यों कहने पाएँ, ‘वह उनको बुरे अभिप्राय से, अर्थात् पहाड़ों में घात करके धरती पर से मिटा डालने की मनसा से निकाल ले गया?’ तू अपने भड़के हुए कोप को शान्त कर, और अपनी प्रजा को ऐसी हानि पहुँचाने से फिर जा। ");
INSERT INTO hin2017_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","अपने दास अब्राहम, इसहाक, और याकूब को स्मरण कर, जिनसे तूने अपनी ही शपथ खाकर यह कहा था, ‘मैं तुम्हारे वंश को आकाश के तारों के तुल्य बहुत करूँगा, और यह सारा देश जिसकी मैंने चर्चा की है तुम्हारे वंश को दूँगा, कि वह उसके अधिकारी सदैव बने रहें।’” ");
INSERT INTO hin2017_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","तब यहोवा अपनी प्रजा की हानि करने से जो उसने कहा था पछताया। ");
INSERT INTO hin2017_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","तब मूसा फिरकर साक्षी की दोनों तख्तियों को हाथ में लिये हुए पहाड़ से उतर गया, उन तख्तियों के तो इधर और उधर दोनों ओर लिखा हुआ था। ");
INSERT INTO hin2017_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","और वे तख्तियाँ परमेश्वर की बनाई हुई थीं, और उन पर जो खोदकर लिखा हुआ था वह परमेश्वर का लिखा हुआ था। ");
INSERT INTO hin2017_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","जब यहोशू को लोगों के कोलाहल का शब्द सुनाई पड़ा, तब उसने मूसा से कहा, “छावनी से लड़ाई का सा शब्द सुनाई देता है।” ");
INSERT INTO hin2017_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","उसने कहा, “वह जो शब्द है वह न तो जीतनेवालों का है, और न हारनेवालों का, मुझे तो गाने का शब्द सुन पड़ता है।” ");
INSERT INTO hin2017_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","छावनी के पास आते ही मूसा को वह बछड़ा और नाचना देख पड़ा, तब मूसा का कोप भड़क उठा, और उसने तख्तियों को अपने हाथों से पर्वत के नीचे पटककर तोड़ डाला। ");
INSERT INTO hin2017_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","तब उसने उनके बनाए हुए बछड़े को लेकर आग में डालकर फूँक दिया। और पीसकर चूर चूरकर डाला, और जल के ऊपर फेंक दिया, और इस्राएलियों को उसे पिलवा दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","तब मूसा हारून से कहने लगा, “उन लोगों ने तुझ से क्या किया कि तूने उनको इतने बड़े पाप में फँसाया?” ");
INSERT INTO hin2017_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","हारून ने उत्तर दिया, “मेरे प्रभु का कोप न भड़के; तू तो उन लोगों को जानता ही है कि वे बुराई में मन लगाए रहते हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","और उन्होंने मुझसे कहा, ‘हमारे लिये देवता बनवा जो हमारे आगे-आगे चले; क्योंकि उस पुरुष मूसा को, जो हमें मिस्र देश से छुड़ा लाया है, हम नहीं जानते कि उसे क्या हुआ?’ ");
INSERT INTO hin2017_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","तब मैंने उनसे कहा, ‘जिस जिसके पास सोने के गहने हों, वे उनको उतार लाएँ;’ और जब उन्होंने मुझ को दिया, मैंने उन्हें आग में डाल दिया, तब यह बछड़ा निकल पड़ा।” ");
INSERT INTO hin2017_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","हारून ने उन लोगों को ऐसा निरंकुश कर दिया था कि वे अपने विरोधियों के बीच उपहास के योग्य हुए, ");
INSERT INTO hin2017_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","उनको निरंकुश देखकर मूसा ने छावनी के निकास पर खड़े होकर कहा, “जो कोई यहोवा की ओर का हो वह मेरे पास आए;” तब सारे लेवीय उसके पास इकट्ठे हुए। ");
INSERT INTO hin2017_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","उसने उनसे कहा, “इस्राएल का परमेश्वर यहोवा यह कहता है, कि अपनी-अपनी जाँघ पर तलवार लटकाकर छावनी से एक निकास से दूसरे निकास तक घूम-घूमकर अपने-अपने भाइयों, संगियों, और पड़ोसियों को घात करो।” ");
INSERT INTO hin2017_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","मूसा के इस वचन के अनुसार लेवियों ने किया और उस दिन तीन हजार के लगभग लोग मारे गए। ");
INSERT INTO hin2017_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","फिर मूसा ने कहा, “आज के दिन यहोवा के लिये अपना याजकपद का संस्कार करो, वरन् अपने-अपने बेटों और भाइयों के भी विरुद्ध होकर ऐसा करो जिससे वह आज तुम को आशीष दे।” ");
INSERT INTO hin2017_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","दूसरे दिन मूसा ने लोगों से कहा, “तुम ने बड़ा ही पाप किया है। अब मैं यहोवा के पास चढ़ जाऊँगा; सम्भव है कि मैं तुम्हारे पाप का प्रायश्चित कर सकूँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","तब मूसा यहोवा के पास जाकर कहने लगा, “हाय, हाय, उन लोगों ने सोने का देवता बनवाकर बड़ा ही पाप किया है। ");
INSERT INTO hin2017_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","तो भी अब तू उनका पाप क्षमा कर नहीं तो अपनी लिखी हुई पुस्तक में से मेरे नाम को काट दे।” ");
INSERT INTO hin2017_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","यहोवा ने मूसा से कहा, “जिसने मेरे विरुद्ध पाप किया है उसी का नाम मैं अपनी पुस्तक में से काट दूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","अब तो तू जाकर उन लोगों को उस स्थान में ले चल जिसकी चर्चा मैंने तुझ से की थी; देख मेरा दूत तेरे आगे-आगे चलेगा। परन्तु जिस दिन मैं दण्ड देने लगूँगा उस दिन उनको इस पाप का भी दण्ड दूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","अतः यहोवा ने उन लोगों पर विपत्ति भेजी, क्योंकि हारून के बनाए हुए बछड़े को उन्हीं ने बनवाया था। ");
INSERT INTO hin2017_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","फिर यहोवा ने मूसा से कहा, “तू उन लोगों को जिन्हें मिस्र देश से छुड़ा लाया है संग लेकर उस देश को जा, जिसके विषय मैंने अब्राहम, इसहाक और याकूब से शपथ खाकर कहा था, ‘मैं उसे तुम्हारे वंश को दूँगा।’ ");
INSERT INTO hin2017_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","और मैं तेरे आगे-आगे एक दूत को भेजूँगा और कनानी, एमोरी, हित्ती, परिज्जी, हिब्बी, और यबूसी लोगों को बरबस निकाल दूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","तुम लोग उस देश को जाओ जिसमें दूध और मधु की धारा बहती है; परन्तु तुम हठीले हो, इस कारण मैं तुम्हारे बीच में होकर न चलूँगा, ऐसा न हो कि मैं मार्ग में तुम्हारा अन्त कर डालूँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","यह बुरा समाचार सुनकर वे लोग विलाप करने लगे; और कोई अपने गहने पहने हुए न रहा। ");
INSERT INTO hin2017_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","क्योंकि यहोवा ने मूसा से कह दिया था, “इस्राएलियों को मेरा यह वचन सुना, ‘तुम लोग तो हठीले हो; जो मैं पल भर के लिये तुम्हारे बीच होकर चलूँ, तो तुम्हारा अन्त कर डालूँगा। इसलिए अब अपने-अपने गहने अपने अंगों से उतार दो, कि मैं जानूँ कि तुम्हारे साथ क्या करना चाहिए।’” ");
INSERT INTO hin2017_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","तब इस्राएली होरेब पर्वत से लेकर आगे को अपने गहने उतारे रहे। ");
INSERT INTO hin2017_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","मूसा तम्बू को छावनी से बाहर वरन् दूर खड़ा कराया करता था, और उसको मिलापवाला तम्बू कहता था। और जो कोई यहोवा को ढूँढ़ता वह उस मिलापवाले तम्बू के पास जो छावनी के बाहर था निकल जाता था। ");
INSERT INTO hin2017_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","जब जब मूसा तम्बू के पास जाता, तब-तब सब लोग उठकर अपने-अपने डेरे के द्वार पर खड़े हो जाते, और जब तक मूसा उस तम्बू में प्रवेश न करता था तब तक उसकी ओर ताकते रहते थे। ");
INSERT INTO hin2017_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","जब मूसा उस तम्बू में प्रवेश करता था, तब बादल का खम्भा उतरकर तम्बू के द्वार पर ठहर जाता था, और यहोवा मूसा से बातें करने लगता था। ");
INSERT INTO hin2017_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","और सब लोग जब बादल के खम्भे को तम्बू के द्वार पर ठहरा देखते थे, तब उठकर अपने-अपने डेरे के द्वार पर से दण्डवत् करते थे। ");
INSERT INTO hin2017_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","और यहोवा मूसा से इस प्रकार आमने-सामने बातें करता था, जिस प्रकार कोई अपने भाई से बातें करे। और मूसा तो छावनी में फिर लौट आता था, पर यहोशू नामक एक जवान, जो नून का पुत्र और मूसा का टहलुआ था, वह तम्बू में से न निकलता था। ");
INSERT INTO hin2017_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","और मूसा ने यहोवा से कहा, “सुन तू मुझसे कहता है, ‘इन लोगों को ले चल;’ परन्तु यह नहीं बताया कि तू मेरे संग किसको भेजेगा। तो भी तूने कहा है, ‘तेरा नाम मेरे चित्त में बसा है, और तुझ पर मेरे अनुग्रह की दृष्टि है।’ ");
INSERT INTO hin2017_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","और अब यदि मुझ पर तेरे अनुग्रह की दृष्टि हो, तो मुझे अपनी गति समझा दे, जिससे जब मैं तेरा ज्ञान पाऊँ तब तेरे अनुग्रह की दृष्टि मुझ पर बनी रहे। फिर इसकी भी सुधि कर कि यह जाति तेरी प्रजा है।” ");
INSERT INTO hin2017_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","यहोवा ने कहा, “मैं आप चलूँगा और तुझे विश्राम दूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","उसने उससे कहा, “यदि तू आप न चले, तो हमें यहाँ से आगे न ले जा। ");
INSERT INTO hin2017_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","यह कैसे जाना जाए कि तेरे अनुग्रह की दृष्टि मुझ पर और अपनी प्रजा पर है? क्या इससे नहीं कि तू हमारे संग-संग चले, जिससे मैं और तेरी प्रजा के लोग पृथ्वी भर के सब लोगों से अलग ठहरें?” ");
INSERT INTO hin2017_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","यहोवा ने मूसा से कहा, “मैं यह काम भी जिसकी चर्चा तूने की है करूँगा; क्योंकि मेरे अनुग्रह की दृष्टि तुझ पर है, और तेरा नाम मेरे चित्त में बसा है।” ");
INSERT INTO hin2017_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","उसने कहा, “मुझे अपना तेज दिखा दे।” ");
INSERT INTO hin2017_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","उसने कहा, “मैं तेरे सम्मुख होकर चलते हुए तुझे अपनी सारी भलाई दिखाऊँगा, और तेरे सम्मुख यहोवा नाम का प्रचार करूँगा, और जिस पर मैं अनुग्रह करना चाहूँ उसी पर अनुग्रह करूँगा, और जिस पर दया करना चाहूँ उसी पर दया करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","फिर उसने कहा, “तू मेरे मुख का दर्शन नहीं कर सकता; क्योंकि मनुष्य मेरे मुख का दर्शन करके जीवित नहीं रह सकता।” ");
INSERT INTO hin2017_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","फिर यहोवा ने कहा, “सुन, मेरे पास एक स्थान है, तू उस चट्टान पर खड़ा हो; ");
INSERT INTO hin2017_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","और जब तक मेरा तेज तेरे सामने होकर चलता रहे तब तक मैं तुझे चट्टान के दरार में रखूँगा, और जब तक मैं तेरे सामने होकर न निकल जाऊँ तब तक अपने हाथ से तुझे ढाँपे रहूँगा; ");
INSERT INTO hin2017_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","फिर मैं अपना हाथ उठा लूँगा, तब तू मेरी पीठ का तो दर्शन पाएगा, परन्तु मेरे मुख का दर्शन नहीं मिलेगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","फिर यहोवा ने मूसा से कहा, “पहली तख्तियों के समान पत्थर की दो और तख्तियाँ गढ़ ले; तब जो वचन उन पहली तख्तियों पर लिखे थे, जिन्हें तूने तोड़ डाला, वे ही वचन मैं उन तख्तियों पर भी लिखूँगा। ");
INSERT INTO hin2017_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","और सवेरे तैयार रहना, और भोर को सीनै पर्वत पर चढ़कर उसकी चोटी पर मेरे सामने खड़ा होना। ");
INSERT INTO hin2017_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","तेरे संग कोई न चढ़ पाए, वरन् पर्वत भर पर कोई मनुष्य कहीं दिखाई न दे; और न भेड़-बकरी और गाय-बैल भी पर्वत के आगे चरने पाएँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","तब मूसा ने पहली तख्तियों के समान दो और तख्तियाँ गढ़ीं; और भोर को सवेरे उठकर अपने हाथ में पत्थर की वे दोनों तख्तियाँ लेकर यहोवा की आज्ञा के अनुसार पर्वत पर चढ़ गया। ");
INSERT INTO hin2017_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","तब यहोवा ने बादल में उतरकर उसके संग वहाँ खड़ा होकर यहोवा नाम का प्रचार किया। ");
INSERT INTO hin2017_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","और यहोवा उसके सामने होकर यह प्रचार करता हुआ चला, “यहोवा, यहोवा, परमेश्वर दयालु और अनुग्रहकारी, कोप करने में धीरजवन्त, और अति करुणामय और सत्य, ");
INSERT INTO hin2017_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","हजारों पीढ़ियों तक निरन्तर करुणा करनेवाला, अधर्म और अपराध और पाप को क्षमा करनेवाला है, परन्तु दोषी को वह किसी प्रकार निर्दोष न ठहराएगा, वह पितरों के अधर्म का दण्ड उनके बेटों वरन् पोतों और परपोतों को भी देनेवाला है।” ");
INSERT INTO hin2017_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","तब मूसा ने फुर्ती कर पृथ्वी की ओर झुककर दण्डवत् किया। ");
INSERT INTO hin2017_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","और उसने कहा, “हे प्रभु, यदि तेरे अनुग्रह की दृष्टि मुझ पर हो तो प्रभु, हम लोगों के बीच में होकर चले, ये लोग हठीले तो हैं, तो भी हमारे अधर्म और पाप को क्षमा कर, और हमें अपना निज भाग मानकर ग्रहण कर।” ");
INSERT INTO hin2017_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","उसने कहा, “सुन, मैं एक वाचा बाँधता हूँ। तेरे सब लोगों के सामने मैं ऐसे आश्चर्यकर्म करूँगा जैसा पृथ्वी पर और सब जातियों में कभी नहीं हुए; और वे सारे लोग जिनके बीच तू रहता है यहोवा के कार्य को देखेंगे; क्योंकि जो मैं तुम लोगों से करने पर हूँ वह भययोग्य काम है। ");
INSERT INTO hin2017_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","जो आज्ञा मैं आज तुम्हें देता हूँ उसे तुम लोग मानना। देखो, मैं तुम्हारे आगे से एमोरी, कनानी, हित्ती, परिज्जी, हिब्बी, और यबूसी लोगों को निकालता हूँ। ");
INSERT INTO hin2017_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","इसलिए सावधान रहना कि जिस देश में तू जानेवाला है उसके निवासियों से वाचा न बाँधना; कहीं ऐसा न हो कि वह तेरे लिये फंदा ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","वरन् उनकी वेदियों को गिरा देना, उनकी लाठों को तोड़ डालना, और उनकी अशेरा नामक मूर्तियों को काट डालना; ");
INSERT INTO hin2017_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","क्योंकि तुम्हें किसी दूसरे को परमेश्वर करके दण्डवत् करने की आज्ञा नहीं, क्योंकि यहोवा जिसका नाम जलनशील है, वह जल उठनेवाला परमेश्वर है, ");
INSERT INTO hin2017_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","ऐसा न हो कि तू उस देश के निवासियों से वाचा बाँधे, और वे अपने देवताओं के पीछे होने का व्यभिचार करें, और उनके लिये बलिदान भी करें, और कोई तुझे नेवता दे और तू भी उसके बलिपशु का प्रसाद खाए, ");
INSERT INTO hin2017_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","और तू उनकी बेटियों को अपने बेटों के लिये लाए, और उनकी बेटियाँ जो आप अपने देवताओं के पीछे होने का व्यभिचार करती हैं तेरे बेटों से भी अपने देवताओं के पीछे होने को व्यभिचार करवाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“तुम देवताओं की मूर्तियाँ ढालकर न बना लेना। ");
INSERT INTO hin2017_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“अख़मीरी रोटी का पर्व मानना। उसमें मेरी आज्ञा के अनुसार अबीब महीने के नियत समय पर सात दिन तक अख़मीरी रोटी खाया करना; क्योंकि तू मिस्र से अबीब महीने में निकल आया। ");
INSERT INTO hin2017_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","हर एक पहलौठा मेरा है; और क्या बछड़ा, क्या मेम्ना, तेरे पशुओं में से जो नर पहलौठे हों वे सब मेरे ही हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","और गदही के पहलौठे के बदले मेम्ना देकर उसको छुड़ाना, यदि तू उसे छुड़ाना न चाहे तो उसकी गर्दन तोड़ देना। परन्तु अपने सब पहलौठे बेटों को बदला देकर छुड़ाना। मुझे कोई खाली हाथ अपना मुँह न दिखाए। ");
INSERT INTO hin2017_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“छः दिन तो परिश्रम करना, परन्तु सातवें दिन विश्राम करना; वरन् हल जोतने और लवने के समय में भी विश्राम करना। ");
INSERT INTO hin2017_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","और तू सप्ताहों का पर्व मानना जो पहले लवे हुए गेहूँ का पर्व कहलाता है, और वर्ष के अन्त में बटोरन का भी पर्व मानना। ");
INSERT INTO hin2017_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","वर्ष में तीन बार तेरे सब पुरुष इस्राएल के परमेश्वर प्रभु यहोवा को अपने मुँह दिखाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","मैं तो अन्यजातियों को तेरे आगे से निकालकर तेरी सीमाओं को बढ़ाऊँगा; और जब तू अपने परमेश्वर यहोवा को अपना मुँह दिखाने के लिये वर्ष में तीन बार आया करे, तब कोई तेरी भूमि का लालच न करेगा। ");
INSERT INTO hin2017_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“मेरे बलिदान के लहू को ख़मीर सहित न चढ़ाना, और न फसह के पर्व के बलिदान में से कुछ सवेरे तक रहने देना। ");
INSERT INTO hin2017_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","अपनी भूमि की पहली उपज का पहला भाग अपने परमेश्वर यहोवा के भवन में ले आना। बकरी के बच्चे को उसकी माँ के दूध में न पकाना।” ");
INSERT INTO hin2017_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","और यहोवा ने मूसा से कहा, “ये वचन लिख ले; क्योंकि इन्हीं वचनों के अनुसार मैं तेरे और इस्राएल के साथ वाचा बाँधता हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मूसा तो वहाँ यहोवा के संग चालीस दिन और रात रहा; और तब तक न तो उसने रोटी खाई और न पानी पिया। और उसने उन तख्तियों पर वाचा के वचन अर्थात् दस आज्ञाएँ लिख दीं। ");
INSERT INTO hin2017_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","जब मूसा साक्षी की दोनों तख्तियाँ हाथ में लिये हुए सीनै पर्वत से उतरा आता था तब यहोवा के साथ बातें करने के कारण उसके चेहरे से किरणें निकल रही थीं। परन्तु वह यह नहीं जानता था कि उसके चेहरे से किरणें निकल रही हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","जब हारून और सब इस्राएलियों ने मूसा को देखा कि उसके चेहरे से किरणें निकलती हैं, तब वे उसके पास जाने से डर गए। ");
INSERT INTO hin2017_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","तब मूसा ने उनको बुलाया; और हारून मण्डली के सारे प्रधानों समेत उसके पास आया, और मूसा उनसे बातें करने लगा। ");
INSERT INTO hin2017_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","इसके बाद सब इस्राएली पास आए, और जितनी आज्ञाएँ यहोवा ने सीनै पर्वत पर उसके साथ बात करने के समय दी थीं, वे सब उसने उन्हें बताईं। ");
INSERT INTO hin2017_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","जब तक मूसा उनसे बात न कर चुका तब तक अपने मुँह पर ओढ़ना डाले रहा। ");
INSERT INTO hin2017_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","और जब जब मूसा भीतर यहोवा से बात करने को उसके सामने जाता तब-तब वह उस ओढ़नी को निकलते समय तक उतारे हुए रहता था; फिर बाहर आकर जो-जो आज्ञा उसे मिलती उन्हें इस्राएलियों से कह देता था। ");
INSERT INTO hin2017_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","इस्राएली मूसा का चेहरा देखते थे कि उससे किरणें निकलती हैं; और जब तक वह यहोवा से बात करने को भीतर न जाता तब तक वह उस ओढ़नी को डाले रहता था। ");
INSERT INTO hin2017_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मूसा ने इस्राएलियों की सारी मण्डली इकट्ठा करके उनसे कहा, “जिन कामों के करने की आज्ञा यहोवा ने दी है वे ये हैं। ");
INSERT INTO hin2017_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","छः दिन तो काम-काज किया जाए, परन्तु सातवाँ दिन तुम्हारे लिये पवित्र और यहोवा के लिये पवित्र विश्राम का दिन ठहरे; उसमें जो कोई काम-काज करे वह मार डाला जाए; ");
INSERT INTO hin2017_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","वरन् विश्राम के दिन तुम अपने-अपने घरों में आग तक न जलाना।” ");
INSERT INTO hin2017_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","फिर मूसा ने इस्राएलियों की सारी मण्डली से कहा, “जिस बात की आज्ञा यहोवा ने दी है वह यह है। ");
INSERT INTO hin2017_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","तुम्हारे पास से यहोवा के लिये भेंट ली जाए, अर्थात् जितने अपनी इच्छा से देना चाहें वे यहोवा की भेंट करके ये वस्तुएँ ले आएँ; अर्थात् सोना, रुपा, पीतल; ");
INSERT INTO hin2017_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","नीले, बैंगनी और लाल रंग का कपड़ा, सूक्ष्म सनी का कपड़ा; बकरी का बाल, ");
INSERT INTO hin2017_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","लाल रंग से रंगी हुई मेढ़ों की खालें, सुइसों की खालें; बबूल की लकड़ी, ");
INSERT INTO hin2017_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","उजियाला देने के लिये तेल, अभिषेक का तेल, और धूप के लिये सुगन्ध-द्रव्य, ");
INSERT INTO hin2017_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","फिर एपोद और चपरास के लिये सुलैमानी मणि और जड़ने के लिये मणि। ");
INSERT INTO hin2017_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“तुम में से जितनों के हृदय में बुद्धि का प्रकाश है वे सब आकर जिस-जिस वस्तु की आज्ञा यहोवा ने दी है वे सब बनाएँ। ");
INSERT INTO hin2017_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","अर्थात् तम्बू, और आवरण समेत निवास, और उसकी घुंडी, तख्ते, बेंड़े, खम्भे और कुर्सियाँ; ");
INSERT INTO hin2017_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","फिर डंडों समेत सन्दूक, और प्रायश्चित का ढकना, और बीचवाला परदा; ");
INSERT INTO hin2017_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","डंडों और सब सामान समेत मेज, और भेंट की रोटियाँ; ");
INSERT INTO hin2017_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","सामान और दीपकों समेत उजियाला देनेवाला दीवट, और उजियाला देने के लिये तेल; ");
INSERT INTO hin2017_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","डंडों समेत धूपवेदी, अभिषेक का तेल, सुगन्धित धूप, और निवास के द्वार का परदा; ");
INSERT INTO hin2017_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","पीतल की झंझरी, डंडों आदि सारे सामान समेत होमवेदी, पाए समेत हौदी; ");
INSERT INTO hin2017_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","खम्भों और उनकी कुर्सियों समेत आँगन के पर्दे, और आँगन के द्वार के पर्दे; ");
INSERT INTO hin2017_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","निवास और आँगन दोनों के खूँटे, और डोरियाँ; ");
INSERT INTO hin2017_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","पवित्रस्थान में सेवा टहल करने के लिये काढ़े हुए वस्त्र, और याजक का काम करने के लिये हारून याजक के पवित्र वस्त्र, और उसके पुत्रों के वस्त्र भी।” ");
INSERT INTO hin2017_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","तब इस्राएलियों की सारी मण्डली मूसा के सामने से लौट गई। ");
INSERT INTO hin2017_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","और जितनों को उत्साह हुआ, और जितनों के मन में ऐसी इच्छा उत्पन्न हुई थी, वे मिलापवाले तम्बू के काम करने और उसकी सारी सेवकाई और पवित्र वस्त्रों के बनाने के लिये यहोवा की भेंट ले आने लगे। ");
INSERT INTO hin2017_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","क्या स्त्री, क्या पुरुष, जितनों के मन में ऐसी इच्छा उत्पन्न हुई थी वे सब जुगनू, नथनी, मुंदरी, और कंगन आदि सोने के गहने ले आने लगे, इस भाँति जितने मनुष्य यहोवा के लिये सोने की भेंट के देनेवाले थे वे सब उनको ले आए। ");
INSERT INTO hin2017_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","और जिस-जिस पुरुष के पास नीले, बैंगनी या लाल रंग का कपड़ा या सूक्ष्म सनी का कपड़ा, या बकरी का बाल, या लाल रंग से रंगी हुई मेढ़ों की खालें, या सुइसों की खालें थीं वे उन्हें ले आए। ");
INSERT INTO hin2017_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","फिर जितने चाँदी, या पीतल की भेंट के देनेवाले थे वे यहोवा के लिये वैसी भेंट ले आए; और जिस जिसके पास सेवकाई के किसी काम के लिये बबूल की लकड़ी थी वे उसे ले आए। ");
INSERT INTO hin2017_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","और जितनी स्त्रियों के हृदय में बुद्धि का प्रकाश था वे अपने हाथों से सूत कात-कातकर नीले, बैंगनी और लाल रंग के, और सूक्ष्म सनी के काते हुए सूत को ले आईं। ");
INSERT INTO hin2017_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","और जितनी स्त्रियों के मन में ऐसी बुद्धि का प्रकाश था उन्होंने बकरी के बाल भी काते। ");
INSERT INTO hin2017_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","और प्रधान लोग एपोद और चपरास के लिये सुलैमानी मणि, और जड़ने के लिये मणि, ");
INSERT INTO hin2017_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","और उजियाला देने और अभिषेक और धूप के सुगन्ध-द्रव्य और तेल ले आए। ");
INSERT INTO hin2017_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","जिस-जिस वस्तु के बनाने की आज्ञा यहोवा ने मूसा के द्वारा दी थी उसके लिये जो कुछ आवश्यक था, उसे वे सब पुरुष और स्त्रियाँ ले आईं, जिनके हृदय में ऐसी इच्छा उत्पन्न हुई थी। इस प्रकार इस्राएली यहोवा के लिये अपनी ही इच्छा से भेंट ले आए। ");
INSERT INTO hin2017_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","तब मूसा ने इस्राएलियों से कहा सुनो, “यहोवा ने यहूदा के गोत्रवाले बसलेल को, जो ऊरी का पुत्र और हूर का पोता है, नाम लेकर बुलाया है। ");
INSERT INTO hin2017_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","और उसने उसको परमेश्वर के आत्मा से ऐसा परिपूर्ण किया है कि सब प्रकार की बनावट के लिये उसको ऐसी बुद्धि, समझ, और ज्ञान मिला है, ");
INSERT INTO hin2017_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","कि वह कारीगरी की युक्तियाँ निकालकर सोने, चाँदी, और पीतल में, ");
INSERT INTO hin2017_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","और जड़ने के लिये मणि काटने में और लकड़ी पर नक्काशी करने में, वरन् बुद्धि से सब भाँति की निकाली हुई बनावट में काम कर सके। ");
INSERT INTO hin2017_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","फिर यहोवा ने उसके मन में और दान के गोत्रवाले अहीसामाक के पुत्र ओहोलीआब के मन में भी शिक्षा देने की शक्ति दी है। ");
INSERT INTO hin2017_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","इन दोनों के हृदय को यहोवा ने ऐसी बुद्धि से परिपूर्ण किया है, कि वे नक्काशी करने और गढ़ने और नीले, बैंगनी और लाल रंग के कपड़े, और सूक्ष्म सनी के कपड़े में काढ़ने और बुनने, वरन् सब प्रकार की बनावट में, और बुद्धि से काम निकालने में सब भाँति के काम करें। ");
INSERT INTO hin2017_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“बसलेल और ओहोलीआब और सब बुद्धिमान जिनको यहोवा ने ऐसी बुद्धि और समझ दी हो, कि वे यहोवा की सारी आज्ञाओं के अनुसार पवित्रस्थान की सेवकाई के लिये सब प्रकार का काम करना जानें, वे सब यह काम करें।” ");
INSERT INTO hin2017_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","तब मूसा ने बसलेल और ओहोलीआब और सब बुद्धिमानों को जिनके हृदय में यहोवा ने बुद्धि का प्रकाश दिया था, अर्थात् जिस-जिसको पास आकर काम करने का उत्साह हुआ था उन सभी को बुलवाया। ");
INSERT INTO hin2017_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","और इस्राएली जो-जो भेंट पवित्रस्थान की सेवकाई के काम और उसके बनाने के लिये ले आए थे, उन्हें उन पुरुषों ने मूसा के हाथ से ले लिया। तब भी लोग प्रति भोर को उसके पास भेंट अपनी इच्छा से लाते रहे; ");
INSERT INTO hin2017_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","और जितने बुद्धिमान पवित्रस्थान का काम करते थे वे सब अपना-अपना काम छोड़कर मूसा के पास आए, ");
INSERT INTO hin2017_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","और कहने लगे, “जिस काम के करने की आज्ञा यहोवा ने दी है उसके लिये जितना चाहिये उससे अधिक वे ले आए हैं।” ");
INSERT INTO hin2017_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","तब मूसा ने सारी छावनी में इस आज्ञा का प्रचार करवाया, “क्या पुरुष, क्या स्त्री, कोई पवित्रस्थान के लिये और भेंट न लाए।” इस प्रकार लोग और भेंट लाने से रोके गए। ");
INSERT INTO hin2017_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","क्योंकि सब काम बनाने के लिये जितना सामान आवश्यक था उतना वरन् उससे अधिक बनानेवालों के पास आ चुका था। ");
INSERT INTO hin2017_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","और काम करनेवाले जितने बुद्धिमान थे उन्होंने निवास के लिये बटी हुई सूक्ष्म सनी के कपड़े के, और नीले, बैंगनी और लाल रंग के कपड़े के दस परदों को काढ़े हुए करूबों सहित बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","एक-एक पर्दे की लम्बाई अट्ठाईस हाथ और चौड़ाई चार हाथ की हुई; सब पर्दे एक ही नाप के बने। ");
INSERT INTO hin2017_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","उसने पाँच पर्दे एक दूसरे से जोड़ दिए, और फिर दूसरे पाँच पर्दे भी एक दूसरे से जोड़ दिए। ");
INSERT INTO hin2017_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","और जहाँ ये पर्दे जोड़े गए वहाँ की दोनों छोरों पर उसने नीले-नीले फंदे लगाए। ");
INSERT INTO hin2017_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","उसने दोनों छोरों में पचास-पचास फंदे इस प्रकार लगाए कि वे एक दूसरे के सामने थे। ");
INSERT INTO hin2017_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","और उसने सोने की पचास अंकड़े बनाए, और उनके द्वारा परदों को एक दूसरे से ऐसा जोड़ा कि निवास मिलकर एक हो गया। ");
INSERT INTO hin2017_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","फिर निवास के ऊपर के तम्बू के लिये उसने बकरी के बाल के ग्यारह पर्दे बनाए। ");
INSERT INTO hin2017_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","एक-एक पर्दे की लम्बाई तीस हाथ और चौड़ाई चार हाथ की हुई; और ग्यारहों पर्दे एक ही नाप के थे। ");
INSERT INTO hin2017_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","इनमें से उसने पाँच पर्दे अलग और छः पर्दे अलग जोड़ दिए। ");
INSERT INTO hin2017_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","और जहाँ दोनों जोड़े गए वहाँ की छोरों में उसने पचास-पचास फंदे लगाए। ");
INSERT INTO hin2017_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","और उसने तम्बू के जोड़ने के लिये पीतल की पचास अंकड़े भी बनाए जिससे वह एक हो जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","और उसने तम्बू के लिये लाल रंग से रंगी हुई मेढ़ों की खालों का एक ओढ़ना और उसके ऊपर के लिये सुइसों की खालों का एक ओढ़ना बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","फिर उसने निवास के लिये बबूल की लकड़ी के तख्तों को खड़े रहने के लिये बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","एक-एक तख्ते की लम्बाई दस हाथ और चौड़ाई डेढ़ हाथ की हुई। ");
INSERT INTO hin2017_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","एक-एक तख्ते में एक दूसरी से जोड़ी हुई दो-दो चूलें बनीं, निवास के सब तख्तों के लिये उसने इसी भाँति बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","और उसने निवास के लिये तख्तों को इस रीति से बनाया कि दक्षिण की ओर बीस तख्ते लगे। ");
INSERT INTO hin2017_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","और इन बीसों तख्तो के नीचे चाँदी की चालीस कुर्सियाँ, अर्थात् एक-एक तख्ते के नीचे उसकी दो चूलों के लिये उसने दो कुर्सियाँ बनाईं। ");
INSERT INTO hin2017_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","और निवास की दूसरी ओर, अर्थात् उत्तर की ओर के लिये भी उसने बीस तख्ते बनाए। ");
INSERT INTO hin2017_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","और इनके लिये भी उसने चाँदी की चालीस कुर्सियाँ, अर्थात् एक-एक तख्ते के नीचे दो-दो कुर्सियाँ बनाईं। ");
INSERT INTO hin2017_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","और निवास की पिछली ओर, अर्थात् पश्चिम ओर के लिये उसने छः तख्ते बनाए। ");
INSERT INTO hin2017_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","और पिछले भाग में निवास के कोनों के लिये उसने दो तख्ते बनाए। ");
INSERT INTO hin2017_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","और वे नीचे से दो-दो भाग के बने, और दोनों भाग ऊपर के सिरे तक एक-एक कड़े में मिलाए गए; उसने उन दोनों तख्तों का आकार ऐसा ही बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","इस प्रकार आठ तख्ते हुए, और उनकी चाँदी की सोलह कुर्सियाँ हुईं, अर्थात् एक-एक तख्ते के नीचे दो-दो कुर्सियाँ हुईं। ");
INSERT INTO hin2017_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","फिर उसने बबूल की लकड़ी के बेंड़े बनाए, अर्थात् निवास की एक ओर के तख्तों के लिये पाँच बेंड़े, ");
INSERT INTO hin2017_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","और निवास की दूसरी ओर के तख्तों के लिये पाँच बेंड़े, और निवास का जो किनारा पश्चिम की ओर पिछले भाग में था उसके लिये भी पाँच बेंड़े, बनाए। ");
INSERT INTO hin2017_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","और उसने बीचवाले बेंड़े को तख्तों के मध्य में तम्बू के एक सिरे से दूसरे सिरे तक पहुँचने के लिये बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","और तख्तों को उसने सोने से मढ़ा, और बेंड़ों के घर को काम देनेवाले कड़ों को सोने के बनाया, और बेंड़ों को भी सोने से मढ़ा। ");
INSERT INTO hin2017_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","फिर उसने नीले, बैंगनी और लाल रंग के कपड़े का, और बटी हुई सूक्ष्म सनीवाले कपड़े का बीचवाला परदा बनाया; वह कढ़ाई के काम किए हुए करूबों के साथ बना। ");
INSERT INTO hin2017_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","और उसने उसके लिये बबूल के चार खम्भे बनाए, और उनको सोने से मढ़ा; उनकी घुंडियाँ सोने की बनीं, और उसने उनके लिये चाँदी की चार कुर्सियाँ ढालीं। ");
INSERT INTO hin2017_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","उसने तम्बू के द्वार के लिये भी नीले, बैंगनी और लाल रंग के कपड़े का, और बटी हुई सूक्ष्म सनी के कपड़े का कढ़ाई का काम किया हुआ परदा बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","और उसने घुंडियों समेत उसके पाँच खम्भे भी बनाए, और उनके सिरों और जोड़ने की छड़ों को सोने से मढ़ा, और उनकी पाँच कुर्सियाँ पीतल की बनाईं। ");
INSERT INTO hin2017_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","फिर बसलेल ने बबूल की लकड़ी का सन्दूक बनाया; उसकी लम्बाई ढाई हाथ, चौड़ाई डेढ़ हाथ, और ऊँचाई डेढ़ हाथ की थी। ");
INSERT INTO hin2017_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","उसने उसको भीतर बाहर शुद्ध सोने से मढ़ा, और उसके चारों ओर सोने की बाड़ बनाई। ");
INSERT INTO hin2017_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","और उसके चारों पायों पर लगाने को उसने सोने के चार कड़े ढाले, दो कड़े एक ओर और दो कड़े दूसरी ओर लगे। ");
INSERT INTO hin2017_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","फिर उसने बबूल के डंडे बनाए, और उन्हें सोने से मढ़ा, ");
INSERT INTO hin2017_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","और उनको सन्दूक के दोनों ओर के कड़ों में डाला कि उनके बल सन्दूक उठाया जाए। ");
INSERT INTO hin2017_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","फिर उसने शुद्ध सोने के प्रायश्चितवाले ढकने को बनाया; उसकी लम्बाई ढाई हाथ और चौड़ाई डेढ़ हाथ की थी। ");
INSERT INTO hin2017_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","और उसने सोना गढ़कर दो करूब प्रायश्चित के ढकने के दोनों सिरों पर बनाए; ");
INSERT INTO hin2017_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","एक करूब तो एक सिरे पर, और दूसरा करूब दूसरे सिरे पर बना; उसने उनको प्रायश्चित के ढकने के साथ एक ही टुकड़े के दोनों सिरों पर बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","और करूबों के पंख ऊपर से फैले हुए बने, और उन पंखों से प्रायश्चित का ढकना ढँपा हुआ बना, और उनके मुख आमने-सामने और प्रायश्चित के ढकने की ओर किए हुए बने। ");
INSERT INTO hin2017_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","फिर उसने बबूल की लकड़ी की मेज को बनाया; उसकी लम्बाई दो हाथ, चौड़ाई एक हाथ, और ऊँचाई डेढ़ हाथ की थी; ");
INSERT INTO hin2017_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","और उसने उसको शुद्ध सोने से मढ़ा, और उसमें चारों ओर शुद्ध सोने की एक बाड़ बनाई। ");
INSERT INTO hin2017_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","और उसने उसके लिये चार अंगुल चौड़ी एक पटरी, और इस पटरी के लिये चारों ओर सोने की एक बाड़ बनाई। ");
INSERT INTO hin2017_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","और उसने मेज के लिये सोने के चार कड़े ढालकर उन चारों कोनों में लगाया, जो उसके चारों पायों पर थे। ");
INSERT INTO hin2017_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","वे कड़े पटरी के पास मेज उठाने के डंडों के खानों का काम देने को बने। ");
INSERT INTO hin2017_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","और उसने मेज उठाने के लिये डंडों को बबूल की लकड़ी के बनाया, और सोने से मढ़ा। ");
INSERT INTO hin2017_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","और उसने मेज पर का सामान अर्थात् परात, धूपदान, कटोरे, और उण्डेलने के बर्तन सब शुद्ध सोने के बनाए। ");
INSERT INTO hin2017_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","फिर उसने शुद्ध सोना गढ़कर पाए और डण्डी समेत दीवट को बनाया; उसके पुष्पकोष, गाँठ, और फूल सब एक ही टुकड़े के बने। ");
INSERT INTO hin2017_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","और दीवट से निकली हुई छः डालियाँ बनीं; तीन डालियाँ तो उसकी एक ओर से और तीन डालियाँ उसकी दूसरी ओर से निकली हुई बनीं। ");
INSERT INTO hin2017_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","एक-एक डाली में बादाम के फूल के सरीखे तीन-तीन पुष्पकोष, एक-एक गाँठ, और एक-एक फूल बना; दीवट से निकली हुई, उन छहों डालियों का यही आकार हुआ। ");
INSERT INTO hin2017_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","और दीवट की डण्डी में बादाम के फूल के समान अपनी-अपनी गाँठ और फूल समेत चार पुष्पकोष बने। ");
INSERT INTO hin2017_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","और दीवट से निकली हुई छहों डालियों में से दो-दो डालियों के नीचे एक-एक गाँठ दीवट के साथ एक ही टुकड़े की बनी। ");
INSERT INTO hin2017_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","गाँठें और डालियाँ सब दीवट के साथ एक ही टुकड़े की बनीं; सारा दीवट गढ़े हुए शुद्ध सोने का और एक ही टुकड़े का बना। ");
INSERT INTO hin2017_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","और उसने दीवट के सातों दीपक, और गुलतराश, और गुलदान, शुद्ध सोने के बनाए। ");
INSERT INTO hin2017_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","उसने सारे सामान समेत दीवट को किक्कार भर सोने का बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","फिर उसने बबूल की लकड़ी की धूपवेदी भी बनाई; उसकी लम्बाई एक हाथ और चौड़ाई एक हाथ की थी; वह चौकोर बनी, और उसकी ऊँचाई दो हाथ की थी; और उसके सींग उसके साथ बिना जोड़ के बने थे ");
INSERT INTO hin2017_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ऊपरवाले पल्लों, और चारों ओर के बाजुओं और सींगों समेत उसने उस वेदी को शुद्ध सोने से मढ़ा; और उसके चारों ओर सोने की एक बाड़ बनाई, ");
INSERT INTO hin2017_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","और उस बाड़ के नीचे उसके दोनों पल्लों पर उसने सोने के दो कड़े बनाए, जो उसके उठाने के डंडों के खानों का काम दें। ");
INSERT INTO hin2017_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","और डंडों को उसने बबूल की लकड़ी का बनाया, और सोने से मढ़ा। ");
INSERT INTO hin2017_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","और उसने अभिषेक का पवित्र तेल, और सुगन्ध-द्रव्य का धूप गंधी की रीति के अनुसार बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","फिर उसने बबूल की लकड़ी की होमबलि के लिये वेदी भी बनाई; उसकी लम्बाई पाँच हाथ और चौड़ाई पाँच हाथ की थी; इस प्रकार से वह चौकोर बनी, और ऊँचाई तीन हाथ की थी। ");
INSERT INTO hin2017_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","और उसने उसके चारों कोनों पर उसके चार सींग बनाए, वे उसके साथ बिना जोड़ के बने; और उसने उसको पीतल से मढ़ा। ");
INSERT INTO hin2017_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","और उसने वेदी का सारा सामान, अर्थात् उसकी हाँड़ियों, फावड़ियों, कटोरों, काँटों, और करछों को बनाया। उसका सारा सामान उसने पीतल का बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","और वेदी के लिये उसके चारों ओर की कँगनी के तले उसने पीतल की जाली की एक झंझरी बनाई, वह नीचे से वेदी की ऊँचाई के मध्य तक पहुँची। ");
INSERT INTO hin2017_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","और उसने पीतल की झंझरी के चारों कोनों के लिये चार कड़े ढाले, जो डंडों के खानों का काम दें। ");
INSERT INTO hin2017_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","फिर उसने डंडों को बबूल की लकड़ी का बनाया, और पीतल से मढ़ा। ");
INSERT INTO hin2017_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","तब उसने डंडों को वेदी की ओर के कड़ों में वेदी के उठाने के लिये डाल दिया। वेदी को उसने तख्तों से खोखली बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","उसने हौदी और उसका पाया दोनों पीतल के बनाए, यह मिलापवाले तम्बू के द्वार पर सेवा करनेवाली महिलाओं के पीतल के दर्पणों के लिये बनाए गए। ");
INSERT INTO hin2017_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","फिर उसने आँगन बनाया; और दक्षिण की ओर के लिये आँगन के पर्दे बटी हुई सूक्ष्म सनी के कपड़े के थे, और सब मिलाकर सौ हाथ लम्बे थे; ");
INSERT INTO hin2017_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","उनके लिये बीस खम्भे, और इनकी पीतल की बीस कुर्सियाँ बनीं; और खम्भों की घुंडियाँ और जोड़ने की छड़ें चाँदी की बनीं। ");
INSERT INTO hin2017_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","और उत्तर की ओर के लिये भी सौ हाथ लम्बे पर्दे बने; और उनके लिये बीस खम्भे, और इनकी पीतल की बीस ही कुर्सियाँ बनीं, और खम्भों की घुंडियाँ और जोड़ने की छड़ें चाँदी की बनीं। ");
INSERT INTO hin2017_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","और पश्चिम की ओर के लिये सब पर्दे मिलाकर पचास हाथ के थे; उनके लिए दस खम्भे, और दस ही उनकी कुर्सियाँ थीं, और खम्भों की घुंडियाँ और जोड़ने की छड़ें चाँदी की थीं। ");
INSERT INTO hin2017_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","और पूरब की ओर भी वह पचास हाथ के थे। ");
INSERT INTO hin2017_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","आँगन के द्वार के एक ओर के लिये पन्द्रह हाथ के पर्दे बने; और उनके लिये तीन खम्भे और तीन कुर्सियाँ थीं। ");
INSERT INTO hin2017_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","और आँगन के द्वार के दूसरी ओर भी वैसा ही बना था; और आँगन के दरवाजे के इधर और उधर पन्द्रह-पन्द्रह हाथ के पर्दे बने थे; और उनके लिये तीन ही तीन खम्भे, और तीन ही तीन इनकी कुर्सियाँ भी थीं। ");
INSERT INTO hin2017_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","आँगन के चारों ओर सब पर्दे सूक्ष्म बटी हुई सनी के कपड़े के बने हुए थे। ");
INSERT INTO hin2017_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","और खम्भों की कुर्सियाँ पीतल की, और घुंडियाँ और छड़ें चाँदी की बनीं, और उनके सिरे चाँदी से मढ़े गए, और आँगन के सब खम्भे चाँदी के छड़ों से जोड़े गए थे। ");
INSERT INTO hin2017_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","आँगन के द्वार के पर्दे पर बेलबूटे का काम किया हुआ था, और वह नीले, बैंगनी और लाल रंग के कपड़े का; और सूक्ष्म बटी हुई सनी के कपड़े के बने थे; और उसकी लम्बाई बीस हाथ की थी, और उसकी ऊँचाई आँगन की कनात की चौड़ाई के समान पाँच हाथ की बनी। ");
INSERT INTO hin2017_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","और उनके लिये चार खम्भे, और खम्भों की चार ही कुर्सियाँ पीतल की बनीं, उनकी घुंडियाँ चाँदी की बनीं, और उनके सिरे चाँदी से मढ़े गए, और उनकी छड़ें चाँदी की बनीं। ");
INSERT INTO hin2017_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","और निवास और आँगन के चारों ओर के सब खूँटे पीतल के बने थे। ");
INSERT INTO hin2017_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","साक्षीपत्र के निवास का सामान जो लेवियों के सेवाकार्य के लिये बना; और जिसकी गिनती हारून याजक के पुत्र ईतामार के द्वारा मूसा के कहने से हुई थी, उसका वर्णन यह है। ");
INSERT INTO hin2017_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","जिस-जिस वस्तु के बनाने की आज्ञा यहोवा ने मूसा को दी थी उसको यहूदा के गोत्रवाले बसलेल ने, जो हूर का पोता और ऊरी का पुत्र था, बना दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","और उसके संग दान के गोत्रवाले, अहीसामाक का पुत्र, ओहोलीआब था, जो नक्काशी करने और काढ़नेवाला और नीले, बैंगनी और लाल रंग के और सूक्ष्म सनी के कपड़े में कढ़ाई करनेवाला निपुण कारीगर था। ");
INSERT INTO hin2017_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","पवित्रस्थान के सारे काम में जो भेंट का सोना लगा वह पवित्रस्थान के शेकेल के हिसाब से उनतीस किक्कार, और सात सौ तीस शेकेल था। ");
INSERT INTO hin2017_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","और मण्डली के गिने हुए लोगों की भेंट की चाँदी पवित्रस्थान के शेकेल के हिसाब से सौ किक्कार, और सत्रह सौ पचहत्तर शेकेल थी। ");
INSERT INTO hin2017_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","अर्थात् जितने बीस वर्ष के और उससे अधिक आयु के गिने गए थे, वे छः लाख तीन हजार साढ़े पाँच सौ पुरुष थे, और एक-एक जन की ओर से पवित्रस्थान के शेकेल के अनुसार आधा शेकेल, जो एक बेका होता है, मिला। ");
INSERT INTO hin2017_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","और वह सौ किक्कार चाँदी पवित्रस्थान और बीचवाले पर्दे दोनों की कुर्सियों के ढालने में लग गई; सौ किक्कार से सौ कुर्सियाँ बनीं, एक-एक कुर्सी एक किक्कार की बनी। ");
INSERT INTO hin2017_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","और सत्रह सौ पचहत्तर शेकेल जो बच गए उनसे खम्भों की घुंडियाँ बनाई गईं, और खम्भों की चोटियाँ मढ़ी गईं, और उनकी छड़ें भी बनाई गईं। ");
INSERT INTO hin2017_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","और भेंट का पीतल सत्तर किक्कार और दो हजार चार सौ शेकेल था; ");
INSERT INTO hin2017_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","इससे मिलापवाले तम्बू के द्वार की कुर्सियाँ, और पीतल की वेदी, पीतल की झंझरी, और वेदी का सारा सामान; ");
INSERT INTO hin2017_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","और आँगन के चारों ओर की कुर्सियाँ, और उसके द्वार की कुर्सियाँ, और निवास, और आँगन के चारों ओर के खूँटे भी बनाए गए। ");
INSERT INTO hin2017_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","फिर उन्होंने नीले, बैंगनी और लाल रंग के काढ़े हुए कपड़े पवित्रस्थान की सेवा के लिये, और हारून के लिये भी पवित्र वस्त्र बनाए; जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","और उसने एपोद को सोने, और नीले, बैंगनी और लाल रंग के कपड़े का, और सूक्ष्म बटी हुई सनी के कपड़े का बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","और उन्होंने सोना पीट-पीटकर उसके पत्तर बनाए, फिर पत्तरों को काट-काटकर तार बनाए, और तारों को नीले, बैंगनी और लाल रंग के कपड़े में, और सूक्ष्म सनी के कपड़े में कढ़ाई की बनावट से मिला दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","एपोद के जोड़ने को उन्होंने उसके कंधों पर के बन्धन बनाए, वह अपने दोनों सिरों से जोड़ा गया। ");
INSERT INTO hin2017_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","और उसे कसने के लिये जो काढ़ा हुआ पटुका उस पर बना, वह उसके साथ बिना जोड़ का, और उसी की बनावट के अनुसार, अर्थात् सोने और नीले, बैंगनी और लाल रंग के कपड़े का, और सूक्ष्म बटी हुई सनी के कपड़े का बना; जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","उन्होंने सुलैमानी मणि काटकर उनमें इस्राएल के पुत्रों के नाम, जैसा छापा खोदा जाता है वैसे ही खोदे, और सोने के खानों में जड़ दिए। ");
INSERT INTO hin2017_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","उसने उनको एपोद के कंधे के बन्धनों पर लगाया, जिससे इस्राएलियों के लिये स्मरण करानेवाले मणि ठहरें; जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","उसने चपरास को एपोद के समान सोने की, और नीले, बैंगनी और लाल रंग के कपड़े की, और सूक्ष्म बटी हुई सनी के कपड़े में बेलबूटे का काम किया हुआ बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","चपरास तो चौकोर बनी; और उन्होंने उसको दोहरा बनाया, और वह दोहरा होकर एक बित्ता लम्बा और एक बित्ता चौड़ा बना। ");
INSERT INTO hin2017_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","और उन्होंने उसमें चार पंक्तियों में मणि जड़े। पहली पंक्ति में माणिक्य, पद्मराग, और लालड़ी जड़े गए; ");
INSERT INTO hin2017_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","और दूसरी पंक्ति में मरकत, नीलमणि, और हीरा, ");
INSERT INTO hin2017_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","और तीसरी पंक्ति में लशम, सूर्यकांत, और नीलम; ");
INSERT INTO hin2017_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","और चौथी पंक्ति में फीरोजा, सुलैमानी मणि, और यशब जड़े; ये सब अलग-अलग सोने के खानों में जड़े गए। ");
INSERT INTO hin2017_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","और ये मणि इस्राएल के पुत्रों के नामों की गिनती के अनुसार बारह थे; बारहों गोत्रों में से एक-एक का नाम जैसा छापा खोदा जाता है वैसा ही खोदा गया। ");
INSERT INTO hin2017_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","और उन्होंने चपरास पर डोरियों के समान गूँथे हुए शुद्ध सोने की जंजीर बनाकर लगाई; ");
INSERT INTO hin2017_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","फिर उन्होंने सोने के दो खाने, और सोने की दो कड़ियाँ बनाकर दोनों कड़ियों को चपरास के दोनों सिरों पर लगाया; ");
INSERT INTO hin2017_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","तब उन्होंने सोने की दोनों गूँथी हुई जंजीरों को चपरास के सिरों पर की दोनों कड़ियों में लगाया। ");
INSERT INTO hin2017_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","और गूँथी हुई दोनों जंजीरों के दोनों बाकी सिरों को उन्होंने दोनों खानों में जड़ के, एपोद के सामने दोनों कंधों के बन्धनों पर लगाया। ");
INSERT INTO hin2017_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","और उन्होंने सोने की और दो कड़ियाँ बनाकर चपरास के दोनों सिरों पर उसकी उस कोर पर, जो एपोद के भीतरी भाग में थी, लगाई। ");
INSERT INTO hin2017_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","और उन्होंने सोने की दो और कड़ियाँ भी बनाकर एपोद के दोनों कंधों के बन्धनों पर नीचे से उसके सामने, और जोड़ के पास, एपोद के काढ़े हुए पटुके के ऊपर लगाई। ");
INSERT INTO hin2017_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","तब उन्होंने चपरास को उसकी कड़ियों के द्वारा एपोद की कड़ियों में नीले फीते से ऐसा बाँधा, कि वह एपोद के काढ़े हुए पटुके के ऊपर रहे, और चपरास एपोद से अलग न होने पाए; जैसे यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","फिर एपोद का बागा सम्पूर्ण नीले रंग का बनाया गया। ");
INSERT INTO hin2017_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","और उसकी बनावट ऐसी हुई कि उसके बीच बख्तर के छेद के समान एक छेद बना, और छेद के चारों ओर एक कोर बनी, कि वह फटने न पाए। ");
INSERT INTO hin2017_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","और उन्होंने उसके नीचेवाले घेरे में नीले, बैंगनी और लाल रंग के कपड़े के अनार बनाए। ");
INSERT INTO hin2017_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","और उन्होंने शुद्ध सोने की घंटियाँ भी बनाकर बागे के नीचेवाले घेरे के चारों ओर अनारों के बीचों बीच लगाई; ");
INSERT INTO hin2017_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","अर्थात् बागे के नीचेवाले घेरे के चारों ओर एक सोने की घंटी, और एक अनार फिर एक सोने की घंटी, और एक अनार लगाया गया कि उन्हें पहने हुए सेवा टहल करें; जैसे यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","फिर उन्होंने हारून, और उसके पुत्रों के लिये बुनी हुई सूक्ष्म सनी के कपड़े के अंगरखे, ");
INSERT INTO hin2017_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","और सूक्ष्म सनी के कपड़े की पगड़ी, और सूक्ष्म सनी के कपड़े की सुन्दर टोपियाँ, और सूक्ष्म बटी हुई सनी के कपड़े की जाँघिया, ");
INSERT INTO hin2017_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","और सूक्ष्म बटी हुई सनी के कपड़े की और नीले, बैंगनी और लाल रंग की कढ़ाई का काम की हुई पगड़ी; इन सभी को जिस तरह यहोवा ने मूसा को आज्ञा दी थी वैसा ही बनाया। ");
INSERT INTO hin2017_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","फिर उन्होंने पवित्र मुकुट की पटरी शुद्ध सोने की बनाई; और जैसे छापे में वैसे ही उसमें ये अक्षर खोदे गए, अर्थात् ‘यहोवा के लिये पवित्र।’ ");
INSERT INTO hin2017_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","और उन्होंने उसमें नीला फीता लगाया, जिससे वह ऊपर पगड़ी पर रहे, जिस तरह यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","इस प्रकार मिलापवाले तम्बू के निवास का सब काम समाप्त हुआ, और जिस-जिस काम की आज्ञा यहोवा ने मूसा को दी थी, इस्राएलियों ने उसी के अनुसार किया। ");
INSERT INTO hin2017_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","तब वे निवास को मूसा के पास ले आए, अर्थात् घुंडियाँ, तख्ते, बेंड़े, खम्भे, कुर्सियाँ आदि सारे सामान समेत तम्बू; ");
INSERT INTO hin2017_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","और लाल रंग से रंगी हुई मेढ़ों की खालों का ओढ़ना, और सुइसों की खालों का ओढ़ना, और बीच का परदा; ");
INSERT INTO hin2017_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","डंडों सहित साक्षीपत्र का सन्दूक, और प्रायश्चित का ढकना; ");
INSERT INTO hin2017_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","सारे सामान समेत मेज, और भेंट की रोटी; ");
INSERT INTO hin2017_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","सारे सामान सहित दीवट, और उसकी सजावट के दीपक और उजियाला देने के लिये तेल; ");
INSERT INTO hin2017_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","सोने की वेदी, और अभिषेक का तेल, और सुगन्धित धूप, और तम्बू के द्वार का परदा; ");
INSERT INTO hin2017_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","पीतल की झंझरी, डंडों और सारे सामान समेत पीतल की वेदी; और पाए समेत हौदी; ");
INSERT INTO hin2017_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","खम्भों और कुर्सियों समेत आँगन के पर्दे, और आँगन के द्वार का परदा, और डोरियाँ, और खूँटे, और मिलापवाले तम्बू के निवास की सेवा का सारा सामान; ");
INSERT INTO hin2017_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","पवित्रस्थान में सेवा टहल करने के लिये बेल बूटा काढ़े हुए वस्त्र, और हारून याजक के पवित्र वस्त्र, और उसके पुत्रों के वस्त्र जिन्हें पहनकर उन्हें याजक का काम करना था। ");
INSERT INTO hin2017_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","अर्थात् जो-जो आज्ञा यहोवा ने मूसा को दी थी उन्हीं के अनुसार इस्राएलियों ने सब काम किया। ");
INSERT INTO hin2017_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","तब मूसा ने सारे काम का निरीक्षण करके देखा कि उन्होंने यहोवा की आज्ञा के अनुसार सब कुछ किया है। और मूसा ने उनको आशीर्वाद दिया। ");
INSERT INTO hin2017_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“पहले महीने के पहले दिन को तू मिलापवाले तम्बू के निवास को खड़ा कर देना। ");
INSERT INTO hin2017_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","और उसमें साक्षीपत्र के सन्दूक को रखकर बीचवाले पर्दे की ओट में कर देना। ");
INSERT INTO hin2017_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","और मेज को भीतर ले जाकर जो कुछ उस पर सजाना है उसे सजा देना; तब दीवट को भीतर ले जाकर उसके दीपकों को जला देना। ");
INSERT INTO hin2017_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","और साक्षीपत्र के सन्दूक के सामने सोने की वेदी को जो धूप के लिये है उसे रखना, और निवास के द्वार के पर्दे को लगा देना। ");
INSERT INTO hin2017_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","और मिलापवाले तम्बू के निवास के द्वार के सामने होमवेदी को रखना। ");
INSERT INTO hin2017_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","और मिलापवाले तम्बू और वेदी के बीच हौदी को रखकर उसमें जल भरना। ");
INSERT INTO hin2017_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","और चारों ओर के आँगन की कनात को खड़ा करना, और उस आँगन के द्वार पर पर्दे को लटका देना। ");
INSERT INTO hin2017_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","और अभिषेक का तेल लेकर निवास का और जो कुछ उसमें होगा सब कुछ का अभिषेक करना, और सारे सामान समेत उसको पवित्र करना; तब वह पवित्र ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","सब सामान समेत होमवेदी का अभिषेक करके उसको पवित्र करना; तब वह परमपवित्र ठहरेगी। ");
INSERT INTO hin2017_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","पाए समेत हौदी का भी अभिषेक करके उसे पवित्र करना। ");
INSERT INTO hin2017_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","तब हारून और उसके पुत्रों को मिलापवाले तम्बू के द्वार पर ले जाकर जल से नहलाना, ");
INSERT INTO hin2017_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","और हारून को पवित्र वस्त्र पहनाना, और उसका अभिषेक करके उसको पवित्र करना कि वह मेरे लिये याजक का काम करे। ");
INSERT INTO hin2017_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","और उसके पुत्रों को ले जाकर अंगरखे पहनाना, ");
INSERT INTO hin2017_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","और जैसे तू उनके पिता का अभिषेक करे वैसे ही उनका भी अभिषेक करना कि वे मेरे लिये याजक का काम करें; और उनका अभिषेक उनकी पीढ़ी-पीढ़ी के लिये उनके सदा के याजकपद का चिन्ह ठहरेगा।” ");
INSERT INTO hin2017_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","और मूसा ने जो-जो आज्ञा यहोवा ने उसको दी थी उसी के अनुसार किया। ");
INSERT INTO hin2017_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","और दूसरे वर्ष के पहले महीने के पहले दिन को निवास खड़ा किया गया। ");
INSERT INTO hin2017_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","मूसा ने निवास को खड़ा करवाया और उसकी कुर्सियाँ धर उसके तख्ते लगाकर उनमें बेंड़े डाले, और उसके खम्भों को खड़ा किया; ");
INSERT INTO hin2017_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","और उसने निवास के ऊपर तम्बू को फैलाया, और तम्बू के ऊपर उसने ओढ़ने को लगाया; जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","और उसने साक्षीपत्र को लेकर सन्दूक में रखा, और सन्दूक में डंडों को लगाकर उसके ऊपर प्रायश्चित के ढकने को रख दिया; ");
INSERT INTO hin2017_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","और उसने सन्दूक को निवास में पहुँचाया, और बीचवाले पर्दे को लटकवा के साक्षीपत्र के सन्दूक को उसके अन्दर किया; जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","और उसने मिलापवाले तम्बू में निवास के उत्तर की ओर बीच के पर्दे से बाहर मेज को लगवाया, ");
INSERT INTO hin2017_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","और उस पर उसने यहोवा के सम्मुख रोटी सजा कर रखी; जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","और उसने मिलापवाले तम्बू में मेज के सामने निवास की दक्षिण ओर दीवट को रखा, ");
INSERT INTO hin2017_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","और उसने दीपकों को यहोवा के सम्मुख जला दिया; जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","और उसने मिलापवाले तम्बू में बीच के पर्दे के सामने सोने की वेदी को रखा, ");
INSERT INTO hin2017_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","और उसने उस पर सुगन्धित धूप जलाया; जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","और उसने निवास के द्वार पर पर्दे को लगाया। ");
INSERT INTO hin2017_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","और मिलापवाले तम्बू के निवास के द्वार पर होमवेदी को रखकर उस पर होमबलि और अन्नबलि को चढ़ाया; जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","और उसने मिलापवाले तम्बू और वेदी के बीच हौदी को रखकर उसमें धोने के लिये जल डाला, ");
INSERT INTO hin2017_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","और मूसा और हारून और उसके पुत्रों ने उसमें अपने-अपने हाथ पाँव धोए; ");
INSERT INTO hin2017_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","और जब जब वे मिलापवाले तम्बू में या वेदी के पास जाते थे तब-तब वे हाथ पाँव धोते थे; जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","और उसने निवास के चारों ओर और वेदी के आस-पास आँगन की कनात को खड़ा करवाया, और आँगन के द्वार के पर्दे को लटका दिया। इस प्रकार मूसा ने सब काम को पूरा किया। ");
INSERT INTO hin2017_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","तब बादल मिलापवाले तम्बू पर छा गया, और यहोवा का तेज निवास-स्थान में भर गया। ");
INSERT INTO hin2017_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","और बादल मिलापवाले तम्बू पर ठहर गया, और यहोवा का तेज निवास-स्थान में भर गया, इस कारण मूसा उसमें प्रवेश न कर सका। ");
INSERT INTO hin2017_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","इस्राएलियों की सारी यात्रा में ऐसा होता था, कि जब जब वह बादल निवास के ऊपर से उठ जाता तब-तब वे कूच करते थे। ");
INSERT INTO hin2017_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","और यदि वह न उठता, तो जिस दिन तक वह न उठता था उस दिन तक वे कूच नहीं करते थे। ");
INSERT INTO hin2017_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","इस्राएल के घराने की सारी यात्रा में दिन को तो यहोवा का बादल निवास पर, और रात को उसी बादल में आग उन सभी को दिखाई दिया करती थी।");
INSERT INTO hin2017_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","यहोवा ने मिलापवाले तम्बू में से मूसा को बुलाकर उससे कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“इस्राएलियों से कह कि तुम में से यदि कोई मनुष्य यहोवा के लिये पशु का चढ़ावा चढ़ाए, तो उसका बलिपशु गाय-बैलों या भेड़-बकरियों में से एक का हो। ");
INSERT INTO hin2017_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“यदि वह गाय-बैलों में से होमबलि करे, तो निर्दोष नर मिलापवाले तम्बू के द्वार पर चढ़ाए कि यहोवा उसे ग्रहण करे। ");
INSERT INTO hin2017_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","वह अपना हाथ होमबलि पशु के सिर पर रखे, और वह उनके लिये प्रायश्चित करने को ग्रहण किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","तब वह उस बछड़े को यहोवा के सामने बलि करे; और हारून के पुत्र जो याजक हैं वे लहू को समीप ले जाकर उस वेदी के चारों ओर छिड़के जो मिलापवाले तम्बू के द्वार पर है। ");
INSERT INTO hin2017_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","फिर वह होमबलि पशु की खाल निकालकर उस पशु को टुकड़े-टुकड़े करे; ");
INSERT INTO hin2017_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","तब हारून याजक के पुत्र वेदी पर आग रखें, और आग पर लकड़ी सजा कर रखे; ");
INSERT INTO hin2017_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","और हारून के पुत्र जो याजक हैं वे सिर और चर्बी समेत पशु के टुकड़ों को उस लकड़ी पर जो वेदी की आग पर होगी सजा कर रखें; ");
INSERT INTO hin2017_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","और वह उसकी अंतड़ियों और पैरों को जल से धोए। तब याजक सब को वेदी पर जलाए कि वह होमबलि यहोवा के लिये सुखदायक सुगन्धवाला हवन ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“यदि वह भेड़ों या बकरों का होमबलि चढ़ाए, तो निर्दोष नर को चढ़ाए। ");
INSERT INTO hin2017_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","और वह उसको यहोवा के आगे वेदी के उत्तरी ओर बलि करे; और हारून के पुत्र जो याजक हैं वे उसके लहू को वेदी के चारों ओर छिड़कें। ");
INSERT INTO hin2017_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","और वह उसको सिर और चर्बी समेत टुकड़े-टुकड़े करे, और याजक इन सब को उस लकड़ी पर सजा कर रखे जो वेदी की आग पर होगी; ");
INSERT INTO hin2017_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","वह उसकी अंतड़ियों और पैरों को जल से धोए। और याजक वेदी पर जलाए कि वह होमबलि हो और यहोवा के लिये सुखदायक सुगन्धवाला हवन ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“यदि वह यहोवा के लिये पक्षियों की होमबलि चढ़ाए, तो पंडुको या कबूतरों का चढ़ावा चढ़ाए। ");
INSERT INTO hin2017_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","याजक उसको वेदी के समीप ले जाकर उसका गला मरोड़कर सिर को धड़ से अलग करे, और वेदी पर जलाए; और उसका सारा लहू उस वेदी के बाजू पर गिराया जाए; ");
INSERT INTO hin2017_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","और वह उसकी गल-थैली को मल सहित निकालकर वेदी के पूरब की ओर से राख डालने के स्थान पर फेंक दे; ");
INSERT INTO hin2017_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","और वह उसको पंखों के बीच से फाड़े, पर अलग-अलग न करे। तब याजक उसको वेदी पर उस लकड़ी के ऊपर रखकर जो आग पर होगी जलाए कि वह होमबलि और यहोवा के लिये सुखदायक सुगन्धवाला हवन ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“जब कोई यहोवा के लिये अन्नबलि का चढ़ावा चढ़ाना चाहे, तो वह मैदा चढ़ाए; और उस पर तेल डालकर उसके ऊपर लोबान रखे; ");
INSERT INTO hin2017_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","और वह उसको हारून के पुत्रों के पास जो याजक हैं लाए। और अन्नबलि के तेल मिले हुए मैदे में से इस तरह अपनी मुट्ठी भरकर निकाले कि सब लोबान उसमें आ जाए; और याजक उन्हें स्मरण दिलानेवाले भाग के लिये वेदी पर जलाए कि यह यहोवा के लिये सुखदायक सुगन्धित हवन ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","और अन्नबलि में से जो बचा रहे वह हारून और उसके पुत्रों का ठहरे; यह यहोवा के हवनों में से परमपवित्र भाग होगा। ");
INSERT INTO hin2017_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“जब तू अन्नबलि के लिये तंदूर में पकाया हुआ चढ़ावा चढ़ाए, तो वह तेल से सने हुए अख़मीरी मैदे के फुलकों, या तेल से चुपड़ी हुई अख़मीरी रोटियों का हो। ");
INSERT INTO hin2017_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","और यदि तेरा चढ़ावा तवे पर पकाया हुआ अन्नबलि हो, तो वह तेल से सने हुए अख़मीरी मैदे का हो; ");
INSERT INTO hin2017_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","उसको टुकड़े-टुकड़े करके उस पर तेल डालना, तब वह अन्नबलि हो जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","और यदि तेरा चढ़ावा कढ़ाही में तला हुआ अन्नबलि हो, तो वह मैदे से तेल में बनाया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","और जो अन्नबलि इन वस्तुओं में से किसी का बना हो उसे यहोवा के समीप ले जाना; और जब वह याजक के पास लाया जाए, तब याजक उसे वेदी के समीप ले जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","और याजक अन्नबलि में से स्मरण दिलानेवाला भाग निकालकर वेदी पर जलाए कि वह यहोवा के लिये सुखदायक सुगन्धवाला हवन ठहरे; ");
INSERT INTO hin2017_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","और अन्नबलि में से जो बचा रहे वह हारून और उसके पुत्रों का ठहरे; वह यहोवा के हवनों में परमपवित्र भाग होगा। ");
INSERT INTO hin2017_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“कोई अन्नबलि जिसे तुम यहोवा के लिये चढ़ाओ ख़मीर मिलाकर बनाया न जाए; तुम कभी हवन में यहोवा के लिये ख़मीर और मधु न जलाना। ");
INSERT INTO hin2017_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","तुम इनको पहली उपज का चढ़ावा करके यहोवा के लिये चढ़ाना, पर वे सुखदायक सुगन्ध के लिये वेदी पर चढ़ाए न जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","फिर अपने सब अन्नबलियों को नमकीन बनाना; और अपना कोई अन्नबलि अपने परमेश्वर के साथ बंधी हुई वाचा के नमक से रहित होने न देना; अपने सब चढ़ावों के साथ नमक भी चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“यदि तू यहोवा के लिये पहली उपज का अन्नबलि चढ़ाए, तो अपनी पहली उपज के अन्नबलि के लिये आग में भुनी हुई हरी-हरी बालें, अर्थात् हरी-हरी बालों को मींजकर निकाल लेना, तब अन्न को चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","और उसमें तेल डालना, और उसके ऊपर लोबान रखना; तब वह अन्नबलि हो जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","और याजक मींजकर निकाले हुए अन्न को, और तेल को, और सारे लोबान को स्मरण दिलानेवाला भाग करके जला दे; वह यहोवा के लिये हवन ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“यदि उसका चढ़ावा मेलबलि का हो, और यदि वह गाय-बैलों में से किसी को चढ़ाए, तो चाहे वह पशु नर हो या मादा, पर जो निर्दोष हो उसी को वह यहोवा के आगे चढ़ाए। ");
INSERT INTO hin2017_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","और वह अपना हाथ अपने चढ़ावे के पशु के सिर पर रखे और उसको मिलापवाले तम्बू के द्वार पर बलि करे; और हारून के पुत्र जो याजक हैं वे उसके लहू को वेदी के चारों ओर छिड़कें। ");
INSERT INTO hin2017_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","वह मेलबलि में से यहोवा के लिये हवन करे, अर्थात् जिस चर्बी से अंतड़ियाँ ढपी रहती हैं, और जो चर्बी उनमें लिपटी रहती है वह भी, ");
INSERT INTO hin2017_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","और दोनों गुर्दे और उनके ऊपर की चर्बी जो कमर के पास रहती है, और गुर्दों समेत कलेजे के ऊपर की झिल्ली, इन सभी को वह अलग करे। ");
INSERT INTO hin2017_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","तब हारून के पुत्र इनको वेदी पर उस होमबलि के ऊपर जलाएँ, जो उन लकड़ियों पर होगी जो आग के ऊपर है, कि यह यहोवा के लिये सुखदायक सुगन्धवाला हवन ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“यदि यहोवा के मेलबलि के लिये उसका चढ़ावा भेड़-बकरियों में से हो, तो चाहे वह नर हो या मादा, पर जो निर्दोष हो उसी को वह चढ़ाए। ");
INSERT INTO hin2017_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","यदि वह भेड़ का बच्चा चढ़ाता हो, तो उसको यहोवा के सामने चढ़ाए, ");
INSERT INTO hin2017_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","और वह अपने चढ़ावे के पशु के सिर पर हाथ रखे और उसको मिलापवाले तम्बू के आगे बलि करे; और हारून के पुत्र उसके लहू को वेदी के चारों ओर छिड़कें। ");
INSERT INTO hin2017_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","तब मेलबलि को यहोवा के लिये हवन करे, और उसकी चर्बी भरी मोटी पूँछ को वह रीढ़ के पास से अलग करे, और जिस चर्बी से अंतड़ियाँ ढपी रहती हैं, और जो चर्बी उनमें लिपटी रहती है, ");
INSERT INTO hin2017_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","और दोनों गुर्दे, और जो चर्बी उनके ऊपर कमर के पास रहती है, और गुर्दों समेत कलेजे के ऊपर की झिल्ली, इन सभी को वह अलग करे। ");
INSERT INTO hin2017_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","और याजक इन्हें वेदी पर जलाए; यह यहोवा के लिये हवन रूपी भोजन ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“यदि वह बकरा या बकरी चढ़ाए, तो उसे यहोवा के सामने चढ़ाए। ");
INSERT INTO hin2017_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","और वह अपना हाथ उसके सिर पर रखे, और उसको मिलापवाले तम्बू के आगे बलि करे; और हारून के पुत्र उसके लहू को वेदी के चारों ओर छिड़के। ");
INSERT INTO hin2017_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","तब वह उसमें से अपना चढ़ावा यहोवा के लिये हवन करके चढ़ाए, और जिस चर्बी से अंतड़ियाँ ढपी रहती हैं, और जो चर्बी उनमें लिपटी रहती है वह भी, ");
INSERT INTO hin2017_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","और दोनों गुर्दे और जो चर्बी उनके ऊपर कमर के पास रहती है, और गुर्दों समेत कलेजे के ऊपर की झिल्ली, इन सभी को वह अलग करे। ");
INSERT INTO hin2017_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","और याजक इन्हें वेदी पर जलाए; यह हवन रूपी भोजन है जो सुखदायक सुगन्ध के लिये होता है; क्योंकि सारी चर्बी यहोवा की है। ");
INSERT INTO hin2017_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","यह तुम्हारे निवासों में तुम्हारी पीढ़ी-पीढ़ी के लिये सदा की विधि ठहरेगी कि तुम चर्बी और लहू कभी न खाओ।” (प्रेरि. 15:20,29) ");
INSERT INTO hin2017_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“इस्राएलियों से यह कह कि यदि कोई मनुष्य उन कामों में से जिनको यहोवा ने मना किया है, किसी काम को भूल से करके पापी हो जाए; ");
INSERT INTO hin2017_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","और यदि अभिषिक्त याजक ऐसा पाप करे, जिससे प्रजा दोषी ठहरे, तो अपने पाप के कारण वह एक निर्दोष बछड़ा यहोवा को पापबलि करके चढ़ाए। ");
INSERT INTO hin2017_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","वह उस बछड़े को मिलापवाले तम्बू के द्वार पर यहोवा के आगे ले जाकर उसके सिर पर हाथ रखे, और उस बछड़े को यहोवा के सामने बलि करे। ");
INSERT INTO hin2017_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","और अभिषिक्त याजक बछड़े के लहू में से कुछ लेकर मिलापवाले तम्बू में ले जाए; ");
INSERT INTO hin2017_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","और याजक अपनी उँगली लहू में डुबो-डुबोकर और उसमें से कुछ लेकर पवित्रस्थान के बीचवाले पर्दे के आगे यहोवा के सामने सात बार छिड़के। ");
INSERT INTO hin2017_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","और याजक उस लहू में से कुछ और लेकर सुगन्धित धूप की वेदी के सींगों पर जो मिलापवाले तम्बू में है यहोवा के सामने लगाए; फिर बछड़े के सब लहू को वेदी के पाए पर होमबलि की वेदी जो मिलापवाले तम्बू के द्वार पर है उण्डेल दे। ");
INSERT INTO hin2017_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","फिर वह पापबलि के बछड़े की सब चर्बी को उससे अलग करे, अर्थात् जिस चर्बी से अंतड़ियाँ ढपी रहती हैं, और जितनी चर्बी उनमें लिपटी रहती है, ");
INSERT INTO hin2017_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","और दोनों गुर्दे और उनके ऊपर की चर्बी जो कमर के पास रहती है, और गुर्दों समेत कलेजे के ऊपर की झिल्ली, इन सभी को वह ऐसे अलग करे, ");
INSERT INTO hin2017_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","जैसे मेलबलिवाले चढ़ावे के बछड़े से अलग किए जाते हैं, और याजक इनको होमबलि की वेदी पर जलाए। ");
INSERT INTO hin2017_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","परन्तु उस बछड़े की खाल, पाँव, सिर, अंतड़ियाँ, गोबर, ");
INSERT INTO hin2017_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","और सारा माँस, अर्थात् समूचा बछड़ा छावनी से बाहर शुद्ध स्थान में, जहाँ राख डाली जाएगी, ले जाकर लकड़ी पर रखकर आग से जलाए; जहाँ राख डाली जाती है वह वहीं जलाया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“यदि इस्राएल की सारी मण्डली अज्ञानता के कारण पाप करे और वह बात मण्डली की आँखों से छिपी हो, और वे यहोवा की किसी आज्ञा के विरुद्ध कुछ करके दोषी ठहरे हों; ");
INSERT INTO hin2017_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","तो जब उनका किया हुआ पाप प्रगट हो जाए तब मण्डली एक बछड़े को पापबलि करके चढ़ाए। वह उसे मिलापवाले तम्बू के आगे ले जाए, ");
INSERT INTO hin2017_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","और मण्डली के वृद्ध लोग अपने-अपने हाथों को यहोवा के आगे बछड़े के सिर पर रखें, और वह बछड़ा यहोवा के सामने बलि किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","तब अभिषिक्त याजक बछड़े के लहू में से कुछ मिलापवाले तम्बू में ले जाए; ");
INSERT INTO hin2017_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","और याजक अपनी उँगली लहू में डुबो-डुबोकर उसे बीचवाले पर्दे के आगे सात बार यहोवा के सामने छिड़के। ");
INSERT INTO hin2017_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","और उसी लहू में से वेदी के सींगों पर जो यहोवा के आगे मिलापवाले तम्बू में है लगाए; और बचा हुआ सब लहू होमबलि की वेदी के पाए पर जो मिलापवाले तम्बू के द्वार पर है उण्डेल दे। ");
INSERT INTO hin2017_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","और वह बछड़े की कुल चर्बी निकालकर वेदी पर जलाए। ");
INSERT INTO hin2017_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","जैसे पापबलि के बछड़े से किया था वैसे ही इससे भी करे; इस भाँति याजक इस्राएलियों के लिये प्रायश्चित करे, तब उनका पाप क्षमा किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","और वह बछड़े को छावनी से बाहर ले जाकर उसी भाँति जलाए जैसे पहले बछड़े को जलाया था; यह तो मण्डली के निमित्त पापबलि ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“जब कोई प्रधान पुरुष पाप करके, अर्थात् अपने परमेश्वर यहोवा कि किसी आज्ञा के विरुद्ध भूल से कुछ करके दोषी हो जाए, ");
INSERT INTO hin2017_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","और उसका पाप उस पर प्रगट हो जाए, तो वह एक निर्दोष बकरा बलिदान करने के लिये ले आए; ");
INSERT INTO hin2017_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","और बकरे के सिर पर अपना हाथ रखे, और बकरे को उस स्थान पर बलि करे जहाँ होमबलि पशु यहोवा के आगे बलि किए जाते हैं; यह पापबलि ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","तब याजक अपनी उँगली से पापबलि पशु के लहू में से कुछ लेकर होमबलि की वेदी के सींगों पर लगाए, और उसका लहू होमबलि की वेदी के पाए पर उण्डेल दे। ");
INSERT INTO hin2017_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","और वह उसकी कुल चर्बी को मेलबलि की चर्बी के समान वेदी पर जलाए; और याजक उसके पाप के विषय में प्रायश्चित करे, तब वह क्षमा किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“यदि साधारण लोगों में से कोई अज्ञानता से पाप करे, अर्थात् कोई ऐसा काम जिसे यहोवा ने मना किया हो करके दोषी हो, और उसका वह पाप उस पर प्रगट हो जाए, ");
INSERT INTO hin2017_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","तो वह उस पाप के कारण एक निर्दोष बकरी बलिदान के लिये ले आए; ");
INSERT INTO hin2017_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","और वह अपना हाथ पापबलि पशु के सिर पर रखे, और होमबलि के स्थान पर पापबलि पशु का बलिदान करे। ");
INSERT INTO hin2017_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","और याजक उसके लहू में से अपनी उँगली से कुछ लेकर होमबलि की वेदी के सींगों पर लगाए, और उसके सब लहू को उसी वेदी के पाए पर उण्डेल दे। ");
INSERT INTO hin2017_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","और वह उसकी सब चर्बी को मेलबलि पशु की चर्बी के समान अलग करे, तब याजक उसको वेदी पर यहोवा के निमित्त सुखदायक सुगन्ध के लिये जलाए; और इस प्रकार याजक उसके लिये प्रायश्चित करे, तब उसे क्षमा मिलेगी। ");
INSERT INTO hin2017_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“यदि वह पापबलि के लिये एक मेम्ना ले आए, तो वह निर्दोष मादा हो, ");
INSERT INTO hin2017_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","और वह अपना हाथ पापबलि पशु के सिर पर रखे, और उसको पापबलि के लिये वहीं बलिदान करे जहाँ होमबलि पशुबलि किया जाता है। ");
INSERT INTO hin2017_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","तब याजक अपनी उँगली से पापबलि के लहू में से कुछ लेकर होमबलि की वेदी के सींगों पर लगाए, और उसके सब लहू को वेदी के पाए पर उण्डेल दे। ");
INSERT INTO hin2017_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","और वह उसकी सब चर्बी को मेलबलिवाले मेम्ने की चर्बी के समान अलग करे, और याजक उसे वेदी पर यहोवा के हवनों के ऊपर जलाए; और इस प्रकार याजक उसके पाप के लिये प्रायश्चित करे, और वह क्षमा किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“यदि कोई साक्षी होकर ऐसा पाप करे कि शपथ खिलाकर पूछने पर भी कि क्या तूने यह सुना अथवा जानता है, और वह बात प्रगट न करे, तो उसको अपने अधर्म का भार उठाना पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","अथवा यदि कोई किसी अशुद्ध वस्तु को अज्ञानता से छू ले, तो चाहे वह अशुद्ध जंगली पशु की, चाहे अशुद्ध घरेलू पशु की, चाहे अशुद्ध रेंगनेवाले जीव-जन्तु की लोथ हो, तो वह अशुद्ध होकर दोषी ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","अथवा यदि कोई मनुष्य किसी अशुद्ध वस्तु को अज्ञानता से छू ले, चाहे वह अशुद्ध वस्तु किसी भी प्रकार की क्यों न हो जिससे लोग अशुद्ध हो जाते हैं तो जब वह उस बात को जान लेगा तब वह दोषी ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","अथवा यदि कोई बुरा या भला करने को बिना सोचे समझे शपथ खाए, चाहे किसी प्रकार की बात वह बिना सोचे-विचारे शपथ खाकर कहे, तो ऐसी बात में वह दोषी उस समय ठहरेगा जब उसे मालूम हो जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","और जब वह इन बातों में से किसी भी बात में दोषी हो, तब जिस विषय में उसने पाप किया हो वह उसको मान ले, ");
INSERT INTO hin2017_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","और वह यहोवा के सामने अपना दोषबलि ले आए, अर्थात् उस पाप के कारण वह एक मादा भेड़ या बकरी पापबलि करने के लिये ले आए; तब याजक उस पाप के विषय उसके लिये प्रायश्चित करे। ");
INSERT INTO hin2017_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“पर यदि उसे भेड़ या बकरी देने की सामर्थ्य न हो, तो अपने पाप के कारण दो पिण्डुक या कबूतरी के दो बच्चे दोषबलि चढ़ाने के लिये यहोवा के पास ले आए, उनमें से एक तो पापबलि के लिये और दूसरा होमबलि के लिये। ");
INSERT INTO hin2017_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","वह उनको याजक के पास ले आए, और याजक पापबलि वाले को पहले चढ़ाए, और उसका सिर गले से मरोड़ डालें, पर अलग न करे, ");
INSERT INTO hin2017_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","और वह पापबलि पशु के लहू में से कुछ वेदी के बाजू पर छिड़के, और जो लहू शेष रहे वह वेदी के पाए पर उण्डेला जाए; वह तो पापबलि ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","तब दूसरे पक्षी को वह नियम के अनुसार होमबलि करे, और याजक उसके पाप का प्रायश्चित करे, और तब वह क्षमा किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“यदि वह दो पिण्डुक या कबूतरी के दो बच्चे भी न दे सके, तो वह अपने पाप के कारण अपना चढ़ावा एपा का दसवाँ भाग मैदा पापबलि करके ले आए; उस पर न तो वह तेल डाले, और न लोबान रखे, क्योंकि वह पापबलि होगा (लूका 2:24) ");
INSERT INTO hin2017_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","वह उसको याजक के पास ले जाए, और याजक उसमें से अपनी मुट्ठी भर स्मरण दिलानेवाला भाग जानकर वेदी पर यहोवा के हवनों के ऊपर जलाए; वह तो पापबलि ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","और इन बातों में से किसी भी बात के विषय में जो कोई पाप करे, याजक उसका प्रायश्चित करे, और तब वह पाप क्षमा किया जाएगा। और इस पापबलि का शेष अन्नबलि के शेष के समान याजक का ठहरेगा।” ");
INSERT INTO hin2017_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“यदि कोई यहोवा की पवित्र की हुई वस्तुओं के विषय में भूल से विश्वासघात करे और पापी ठहरे, तो वह यहोवा के पास एक निर्दोष मेढ़ा दोषबलि के लिये ले आए; उसका दाम पवित्रस्थान के शेकेल के अनुसार उतने ही शेकेल चाँदी का हो जितना याजक ठहराए। ");
INSERT INTO hin2017_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","और जिस पवित्र वस्तु के विषय उसने पाप किया हो, उसमें वह पाँचवाँ भाग और बढ़ाकर याजक को दे; और याजक दोषबलि का मेढ़ा चढ़ाकर उसके लिये प्रायश्चित करे, तब उसका पाप क्षमा किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","यदि कोई ऐसा पाप करे, कि उन कामों में से जिन्हें यहोवा ने मना किया है किसी काम को करे, तो चाहे वह उसके अनजाने में हुआ हो, तो भी वह दोषी ठहरेगा, और उसको अपने अधर्म का भार उठाना पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","इसलिए वह एक निर्दोष मेढ़ा दोषबलि करके याजक के पास ले आए, वह उतने दाम का हो जितना याजक ठहराए, और याजक उसके लिये उसकी उस भूल का जो उसने अनजाने में की हो प्रायश्चित करे, और वह क्षमा किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","यह दोषबलि ठहरे; क्योंकि वह मनुष्य निःसन्देह यहोवा के सम्मुख दोषी ठहरेगा।” ");
INSERT INTO hin2017_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“यदि कोई यहोवा का विश्वासघात करके पापी ठहरे, जैसा कि धरोहर, या लेन-देन, या लूट के विषय में अपने भाई से छल करे, या उस पर अत्याचार करे, ");
INSERT INTO hin2017_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","या पड़ी हुई वस्तु को पाकर उसके विषय झूठ बोले और झूठी शपथ भी खाए; ऐसी कोई भी बात क्यों न हो जिसे करके मनुष्य पापी ठहरते हैं, ");
INSERT INTO hin2017_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","तो जब वह ऐसा काम करके दोषी हो जाए, तब जो भी वस्तु उसने लूट, या अत्याचार करके, या धरोहर, या पड़ी पाई हो; ");
INSERT INTO hin2017_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","चाहे कोई वस्तु क्यों न हो जिसके विषय में उसने झूठी शपथ खाई हो; तो वह उसको पूरा-पूरा लौटा दे, और पाँचवाँ भाग भी बढ़ाकर भर दे, जिस दिन यह मालूम हो कि वह दोषी है, उसी दिन वह उस वस्तु को उसके स्वामी को लौटा दे। ");
INSERT INTO hin2017_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","और वह यहोवा के सम्मुख अपना दोषबलि भी ले आए, अर्थात् एक निर्दोष मेढ़ा दोषबलि के लिये याजक के पास ले आए, वह उतने ही दाम का हो जितना याजक ठहराए। ");
INSERT INTO hin2017_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","इस प्रकार याजक उसके लिये यहोवा के सामने प्रायश्चित करे, और जिस काम को करके वह दोषी हो गया है उसकी क्षमा उसे मिलेगी।” ");
INSERT INTO hin2017_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“हारून और उसके पुत्रों को आज्ञा देकर यह कह कि होमबलि की व्यवस्था यह है: होमबलि ईंधन के ऊपर रात भर भोर तक वेदी पर पड़ा रहे, और वेदी की अग्नि वेदी पर जलती रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","और याजक अपने सनी के वस्त्र और अपने तन पर अपनी सनी की जाँघिया पहनकर होमबलि की राख, जो आग के भस्म करने से वेदी पर रह जाए, उसे उठाकर वेदी के पास रखे। ");
INSERT INTO hin2017_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","तब वह अपने ये वस्त्र उतारकर दूसरे वस्त्र पहनकर राख को छावनी से बाहर किसी शुद्ध स्थान पर ले जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","वेदी पर अग्नि जलती रहे, और कभी बुझने न पाए; और याजक प्रतिदिन भोर को उस पर लकड़ियाँ जलाकर होमबलि के टुकड़ों को उसके ऊपर सजा कर धर दे, और उसके ऊपर मेलबलियों की चर्बी को जलाया करे। ");
INSERT INTO hin2017_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","वेदी पर आग लगातार जलती रहे; वह कभी बुझने न पाए। ");
INSERT INTO hin2017_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“अन्नबलि की व्यवस्था इस प्रकार है: हारून के पुत्र उसको वेदी के आगे यहोवा के समीप ले आएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","और वह अन्नबलि के तेल मिले हुए मैदे में से मुट्ठी भर और उस पर का सब लोबान उठाकर अन्नबलि के स्मरणार्थ इस भाग को यहोवा के सम्मुख सुखदायक सुगन्ध के लिये वेदी पर जलाए। ");
INSERT INTO hin2017_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","और उसमें से जो शेष रह जाए उसे हारून और उसके पुत्र खाएँ; वह बिना ख़मीर पवित्रस्थान में खाया जाए, अर्थात् वे मिलापवाले तम्बू के आँगन में उसे खाएँ। (1 कुरि. 9:13) ");
INSERT INTO hin2017_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","वह ख़मीर के साथ पकाया न जाए; क्योंकि मैंने अपने हव्य में से उसको उनका निज भाग होने के लिये उन्हें दिया है; इसलिए जैसा पापबलि और दोषबलि परमपवित्र हैं वैसा ही वह भी है। ");
INSERT INTO hin2017_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","तुम्हारी पीढ़ी-पीढ़ी में हारून के वंश के सब पुरुष उसमें से खा सकते हैं, यहोवा के हवनों में से यह उनका भाग सदैव बना रहेगा; जो कोई उन हवनों को छूए वह पवित्र ठहरेगा।” ");
INSERT INTO hin2017_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“जिस दिन हारून का अभिषेक हो उस दिन वह अपने पुत्रों के साथ यहोवा को यह चढ़ावा चढ़ाए; अर्थात् एपा का दसवाँ भाग मैदा नित्य अन्नबलि में चढ़ाए, उसमें से आधा भोर को और आधा संध्या के समय चढ़ाए। ");
INSERT INTO hin2017_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","वह तवे पर तेल के साथ पकाया जाए; जब वह तेल से तर हो जाए तब उसे ले आना, इस अन्नबलि के पके हुए टुकडे़ यहोवा के सुखदायक सुगन्ध के लिये चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","हारून के पुत्रों में से जो भी उस याजकपद पर अभिषिक्त होगा, वह भी उसी प्रकार का चढ़ावा चढ़ाया करे; यह विधि सदा के लिये है, कि यहोवा के सम्मुख वह सम्पूर्ण चढ़ावा जलाया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","याजक के सम्पूर्ण अन्नबलि भी सब जलाए जाएँ; वह कभी न खाया जाए।” ");
INSERT INTO hin2017_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“हारून और उसके पुत्रों से यह कह कि पापबलि की व्यवस्था यह है: जिस स्थान में होमबलि पशु वध किया जाता है उसी में पापबलि पशु भी यहोवा के सम्मुख बलि किया जाए; वह परमपवित्र है। ");
INSERT INTO hin2017_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","जो याजक पापबलि चढ़ाए वह उसे खाए; वह पवित्रस्थान में, अर्थात् मिलापवाले तम्बू के आँगन में खाया जाए। (1 कुरि. 9:13) ");
INSERT INTO hin2017_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","जो कुछ उसके माँस से छू जाए, वह पवित्र ठहरेगा; और यदि उसके लहू के छींटे किसी वस्त्र पर पड़ जाएँ, तो उसे किसी पवित्रस्थान में धो देना। ");
INSERT INTO hin2017_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","और वह मिट्टी का पात्र जिसमें वह पकाया गया हो तोड़ दिया जाए; यदि वह पीतल के पात्र में उबाला गया हो, तो वह माँजा जाए, और जल से धो लिया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","याजकों में से सब पुरुष उसे खा सकते हैं; वह परमपवित्र वस्तु है। ");
INSERT INTO hin2017_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","पर जिस पापबलि पशु के लहू में से कुछ भी लहू मिलापवाले तम्बू के भीतर पवित्रस्थान में प्रायश्चित करने को पहुँचाया जाए उसका माँस कभी न खाया जाए; वह आग में जला दिया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“फिर दोषबलि की व्यवस्था यह है। वह परमपवित्र है; ");
INSERT INTO hin2017_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","जिस स्थान पर होमबलि पशु का वध करते हैं उसी स्थान पर दोषबलि पशु भी बलि करें, और उसके लहू को याजक वेदी पर चारों ओर छिड़के। ");
INSERT INTO hin2017_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","और वह उसमें की सब चर्बी को चढ़ाए, अर्थात् उसकी मोटी पूँछ को, और जिस चर्बी से अंतड़ियाँ ढपी रहती हैं वह भी, ");
INSERT INTO hin2017_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","और दोनों गुर्दे और जो चर्बी उनके ऊपर और कमर के पास रहती है, और गुर्दों समेत कलेजे के ऊपर की झिल्ली; इन सभी को वह अलग करे; ");
INSERT INTO hin2017_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","और याजक इन्हें वेदी पर यहोवा के लिये हवन करे; तब वह दोषबलि होगा। ");
INSERT INTO hin2017_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","याजकों में के सब पुरुष उसमें से खा सकते हैं; वह किसी पवित्रस्थान में खाया जाए; क्योंकि वह परमपवित्र है। (1 कुरि. 10:18) ");
INSERT INTO hin2017_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","जैसा पापबलि है वैसा ही दोषबलि भी है, उन दोनों की एक ही व्यवस्था है; जो याजक उन बलियों को चढ़ा के प्रायश्चित करे वही उन वस्तुओं को ले ले। ");
INSERT INTO hin2017_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","और जो याजक किसी के लिये होमबलि को चढ़ाए उस होमबलि पशु की खाल को वही याजक ले ले। ");
INSERT INTO hin2017_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","और तंदूर में, या कढ़ाही में, या तवे पर पके हुए सब अन्नबलि उसी याजक की होंगी जो उन्हें चढ़ाता है। (लैव्य. 2:3,10, गिन. 18:9, यहे. 44:29) ");
INSERT INTO hin2017_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","और सब अन्नबलि, जो चाहे तेल से सने हुए हों चाहे रूखे हों, वे हारून के सब पुत्रों को एक समान मिले। ");
INSERT INTO hin2017_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“मेलबलि की जिसे कोई यहोवा के लिये चढ़ाए व्यवस्था यह है: ");
INSERT INTO hin2017_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","यदि वह उसे धन्यवाद के लिये चढ़ाए, तो धन्यवाद-बलि के साथ तेल से सने हुए अख़मीरी फुलके, और तेल से चुपड़ी हुई अख़मीरी रोटियाँ, और तेल से सने हुए मैदे के फुलके तेल से तर चढ़ाए। (इब्रा. 13:15) ");
INSERT INTO hin2017_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","और वह अपने धन्यवादवाले मेलबलि के साथ अख़मीरी रोटियाँ, भी चढ़ाए। ");
INSERT INTO hin2017_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","और ऐसे एक-एक चढ़ावे में से वह एक-एक रोटी यहोवा को उठाने की भेंट करके चढ़ाए; वह मेलबलि के लहू के छिड़कनेवाले याजक की होगी। ");
INSERT INTO hin2017_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","और उस धन्यवादवाले मेलबलि का माँस बलिदान चढ़ाने के दिन ही खाया जाए; उसमें से कुछ भी भोर तक शेष न रह जाए। (1 कुरि. 10:18) ");
INSERT INTO hin2017_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","पर यदि उसके बलिदान का चढ़ावा मन्नत का या स्वेच्छा का हो, तो उस बलिदान को जिस दिन वह चढ़ाया जाए उसी दिन वह खाया जाए, और उसमें से जो शेष रह जाए वह दूसरे दिन भी खाया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","परन्तु जो कुछ बलिदान के माँस में से तीसरे दिन तक रह जाए वह आग में जला दिया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","और उसके मेलबलि के माँस में से यदि कुछ भी तीसरे दिन खाया जाए, तो वह ग्रहण न किया जाएगा, और न उसके हित में गिना जाएगा; वह घृणित कर्म समझा जाएगा, और जो कोई उसमें से खाए उसका अधर्म उसी के सिर पर पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“फिर जो माँस किसी अशुद्ध वस्तु से छू जाए वह न खाया जाए; वह आग में जला दिया जाए। फिर मेलबलि का माँस जितने शुद्ध हों वे ही खाएँ, ");
INSERT INTO hin2017_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","परन्तु जो अशुद्ध होकर यहोवा के मेलबलि के माँस में से कुछ खाए वह अपने लोगों में से नाश किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","और यदि कोई किसी अशुद्ध वस्तु को छूकर यहोवा के मेलबलि पशु के माँस में से खाए, तो वह भी अपने लोगों में से नाश किया जाए, चाहे वह मनुष्य की कोई अशुद्ध वस्तु या अशुद्ध पशु या कोई भी अशुद्ध और घृणित वस्तु हो।” ");
INSERT INTO hin2017_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“इस्राएलियों से इस प्रकार कह: तुम लोग न तो बैल की कुछ चर्बी खाना और न भेड़ या बकरी की। ");
INSERT INTO hin2017_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","और जो पशु स्वयं मर जाए, और जो दूसरे पशु से फाड़ा जाए, उसकी चर्बी और अन्य काम में लाना, परन्तु उसे किसी प्रकार से खाना नहीं। ");
INSERT INTO hin2017_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","जो कोई ऐसे पशु की चर्बी खाएगा जिसमें से लोग कुछ यहोवा के लिये हवन करके चढ़ाया करते हैं वह खानेवाला अपने लोगों में से नाश किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","और तुम अपने घर में किसी भाँति का लहू, चाहे पक्षी का चाहे पशु का हो, न खाना। ");
INSERT INTO hin2017_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","हर एक प्राणी जो किसी भाँति का लहू खाएगा वह अपने लोगों में से नाश किया जाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“इस्राएलियों से इस प्रकार कह: जो यहोवा के लिये मेलबलि चढ़ाए वह उसी मेलबलि में से यहोवा के पास भेंट ले आए; ");
INSERT INTO hin2017_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","वह अपने ही हाथों से यहोवा के हव्य को, अर्थात् छाती समेत चर्बी को ले आए कि छाती हिलाने की भेंट करके यहोवा के सामने हिलाई जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","और याजक चर्बी को तो वेदी पर जलाए, परन्तु छाती हारून और उसके पुत्रों की होगी। ");
INSERT INTO hin2017_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","फिर तुम अपने मेलबलियों में से दाहिनी जाँघ को भी उठाने की भेंट करके याजक को देना; ");
INSERT INTO hin2017_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","हारून के पुत्रों में से जो मेलबलि के लहू और चर्बी को चढ़ाए दाहिनी जाँघ उसी का भाग होगा। ");
INSERT INTO hin2017_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","क्योंकि इस्राएलियों के मेलबलियों में से हिलाने की भेंट की छाती और उठाने की भेंट की जाँघ को लेकर मैंने याजक हारून और उसके पुत्रों को दिया है, कि यह सर्वदा इस्राएलियों की ओर से उनका हक़ बना रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","“जिस दिन हारून और उसके पुत्र यहोवा के समीप याजकपद के लिये लाए गए, उसी दिन यहोवा के हव्यों में से उनका यही अभिषिक्त भाग ठहराया गया; ");
INSERT INTO hin2017_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","अर्थात् जिस दिन यहोवा ने उनका अभिषेक किया उसी दिन उसने आज्ञा दी कि उनको इस्राएलियों की ओर से ये भाग नित्य मिला करें; उनकी पीढ़ी-पीढ़ी के लिये उनका यही हक़ ठहराया गया।” (निर्ग. 40:13-15) ");
INSERT INTO hin2017_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","होमबलि, अन्नबलि, पापबलि, दोषबलि, याजकों के संस्कार बलि, और मेलबलि की व्यवस्था यही है; (लैव्य. 6:9,14) ");
INSERT INTO hin2017_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","जब यहोवा ने सीनै पर्वत के पास के जंगल में मूसा को आज्ञा दी कि इस्राएली मेरे लिये क्या-क्या चढ़ावा चढ़ाएँ, तब उसने उनको यही व्यवस्था दी थी। ");
INSERT INTO hin2017_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“तू हारून और उसके पुत्रों के वस्त्रों, और अभिषेक के तेल, और पापबलि के बछड़े, और दोनों मेढ़ों, और अख़मीरी रोटी की टोकरी को ");
INSERT INTO hin2017_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","मिलापवाले तम्बू के द्वार पर ले आ, और वहीं सारी मण्डली को इकट्ठा कर।” ");
INSERT INTO hin2017_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","यहोवा की इस आज्ञा के अनुसार मूसा ने किया; और मण्डली मिलापवाले तम्बू के द्वार पर इकट्ठा हुई। ");
INSERT INTO hin2017_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","तब मूसा ने मण्डली से कहा, “जो काम करने की आज्ञा यहोवा ने दी है वह यह है।” ");
INSERT INTO hin2017_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","फिर मूसा ने हारून और उसके पुत्रों को समीप ले जाकर जल से नहलाया। ");
INSERT INTO hin2017_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","तब उसने उनको अंगरखा पहनाया, और कमरबन्ध लपेटकर बागा पहना दिया, और एपोद लगाकर एपोद के काढ़े हुए पट्टे से एपोद को बाँधकर कस दिया। ");
INSERT INTO hin2017_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","और उसने चपरास लगाकर चपरास में ऊरीम और तुम्मीम रख दिए। ");
INSERT INTO hin2017_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","तब उसने उसके सिर पर पगड़ी बाँधकर पगड़ी के सामने सोने के टीके को, अर्थात् पवित्र मुकुट को लगाया, जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","तब मूसा ने अभिषेक का तेल लेकर निवास का और जो कुछ उसमें था उन सब का भी अभिषेक करके उन्हें पवित्र किया। ");
INSERT INTO hin2017_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","और उस तेल में से कुछ उसने वेदी पर सात बार छिड़का, और सम्पूर्ण सामान समेत वेदी का और पाए समेत हौदी का अभिषेक करके उन्हें पवित्र किया। ");
INSERT INTO hin2017_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","और उसने अभिषेक के तेल में से कुछ हारून के सिर पर डालकर उसका अभिषेक करके उसे पवित्र किया। ");
INSERT INTO hin2017_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","फिर मूसा ने हारून के पुत्रों को समीप ले आकर, अंगरखे पहनाकर, कमरबन्ध बाँध के उनके सिर पर टोपी रख दी, जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","तब वह पापबलि के बछड़े को समीप ले गया; और हारून और उसके पुत्रों ने अपने-अपने हाथ पापबलि के बछड़े के सिर पर रखे। ");
INSERT INTO hin2017_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","तब वह बलि किया गया, और मूसा ने लहू को लेकर उँगली से वेदी के चारों सींगों पर लगाकर पवित्र किया, और लहू को वेदी के पाए पर उण्डेल दिया, और उसके लिये प्रायश्चित करके उसको पवित्र किया। (इब्रा. 9:21) ");
INSERT INTO hin2017_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","और मूसा ने अंतड़ियों पर की सब चर्बी, और कलेजे पर की झिल्ली, और चर्बी समेत दोनों गुर्दों को लेकर वेदी पर जलाया। ");
INSERT INTO hin2017_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","परन्तु बछड़े में से जो कुछ शेष रह गया उसको, अर्थात् गोबर समेत उसकी खाल और माँस को उसने छावनी से बाहर आग में जलाया, जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","फिर वह होमबलि के मेढ़े को समीप ले गया, और हारून और उसके पुत्रों ने अपने-अपने हाथ मेढ़े के सिर पर रखे। ");
INSERT INTO hin2017_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","तब वह बलि किया गया, और मूसा ने उसका लहू वेदी पर चारों ओर छिड़का। (इब्रा. 9:21) ");
INSERT INTO hin2017_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","तब मेढ़ा टुकड़े-टुकड़े किया गया, और मूसा ने सिर और चर्बी समेत टुकड़ों को जलाया। ");
INSERT INTO hin2017_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","तब अंतड़ियाँ और पाँव जल से धोये गए, और मूसा ने पूरे मेढ़े को वेदी पर जलाया, और वह सुखदायक सुगन्ध देने के लिये होमबलि और यहोवा के लिये हव्य हो गया, जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","फिर वह दूसरे मेढ़े को जो संस्कार का मेढ़ा था समीप ले गया, और हारून और उसके पुत्रों ने अपने-अपने हाथ मेढ़े के सिर पर रखे। ");
INSERT INTO hin2017_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","तब वह बलि किया गया, और मूसा ने उसके लहू में से कुछ लेकर हारून के दाहिने कान के सिरे पर और उसके दाहिने हाथ और दाहिने पाँव के अँगूठों पर लगाया। ");
INSERT INTO hin2017_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","और वह हारून के पुत्रों को समीप ले गया, और लहू में से कुछ एक-एक के दाहिने कान के सिरे पर और दाहिने हाथ और दाहिने पाँव के अँगूठों पर लगाया; और मूसा ने लहू को वेदी पर चारों ओर छिड़का। ");
INSERT INTO hin2017_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","और उसने चर्बी, और मोटी पूँछ, और अंतड़ियों पर की सब चर्बी, और कलेजे पर की झिल्ली समेत दोनों गुर्दे, और दाहिनी जाँघ, ये सब लेकर अलग रखे; ");
INSERT INTO hin2017_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","और अख़मीरी रोटी की टोकरी जो यहोवा के आगे रखी गई थी उसमें से एक अख़मीरी रोटी, और तेल से सने हुए मैदे का एक फुलका, और एक पपड़ी लेकर चर्बी और दाहिनी जाँघ पर रख दी; ");
INSERT INTO hin2017_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","और ये सब वस्तुएँ हारून और उसके पुत्रों के हाथों पर रख दी गईं, और हिलाने की भेंट के लिये यहोवा के सामने हिलाई गईं। ");
INSERT INTO hin2017_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","तब मूसा ने उन्हें फिर उनके हाथों पर से लेकर उन्हें वेदी पर होमबलि के ऊपर जलाया, यह सुखदायक सुगन्ध देने के लिये संस्कार की भेंट और यहोवा के लिये हव्य था। ");
INSERT INTO hin2017_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","तब मूसा ने छाती को लेकर हिलाने की भेंट के लिये यहोवा के आगे हिलाया; और संस्कार के मेढ़े में से मूसा का भाग यही हुआ जैसा यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","तब मूसा ने अभिषेक के तेल और वेदी पर के लहू, दोनों में से कुछ लेकर हारून और उसके वस्त्रों पर, और उसके पुत्रों और उनके वस्त्रों पर भी छिड़का; और उसने वस्त्रों समेत हारून को भी पवित्र किया। ");
INSERT INTO hin2017_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","तब मूसा ने हारून और उसके पुत्रों से कहा, “माँस को मिलापवाले तम्बू के द्वार पर पकाओ, और उस रोटी को जो संस्कार की टोकरी में है वहीं खाओ, जैसा मैंने आज्ञा दी है कि हारून और उसके पुत्र उसे खाएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","और माँस और रोटी में से जो शेष रह जाए उसे आग में जला देना। ");
INSERT INTO hin2017_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","और जब तक तुम्हारे संस्कार के दिन पूरे न हों तब तक, अर्थात् सात दिन तक मिलापवाले तम्बू के द्वार के बाहर न जाना, क्योंकि वह सात दिन तक तुम्हारा संस्कार करता रहेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","जिस प्रकार आज किया गया है वैसा ही करने की आज्ञा यहोवा ने दी है, जिससे तुम्हारा प्रायश्चित किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","इसलिए तुम मिलापवाले तम्बू के द्वार पर सात दिन तक दिन-रात ठहरे रहना, और यहोवा की आज्ञा को मानना, ताकि तुम मर न जाओ; क्योंकि ऐसी ही आज्ञा मुझे दी गई है।” ");
INSERT INTO hin2017_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","तब यहोवा की इन्हीं सब आज्ञाओं के अनुसार जो उसने मूसा के द्वारा दी थीं हारून और उसके पुत्रों ने किया। ");
INSERT INTO hin2017_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","आठवें दिन मूसा ने हारून और उसके पुत्रों को और इस्राएली पुरनियों को बुलवाकर हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","“पापबलि के लिये एक निर्दोष बछड़ा, और होमबलि के लिये एक निर्दोष मेढ़ा लेकर यहोवा के सामने भेंट चढ़ा। ");
INSERT INTO hin2017_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","और इस्राएलियों से यह कह, ‘तुम पापबलि के लिये एक बकरा, और होमबलि के लिये एक बछड़ा और एक भेड़ का बच्चा लो, जो एक वर्ष के हों और निर्दोष हों, ");
INSERT INTO hin2017_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","और मेलबलि के लिये यहोवा के सम्मुख चढ़ाने के लिये एक बैल और एक मेढ़ा, और तेल से सने हुए मैदे का एक अन्नबलि भी ले लो; क्योंकि आज यहोवा तुम को दर्शन देगा।’” ");
INSERT INTO hin2017_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","और जिस-जिस वस्तु की आज्ञा मूसा ने दी उन सब को वे मिलापवाले तम्बू के आगे ले आए; और सारी मण्डली समीप जाकर यहोवा के सामने खड़ी हुई। ");
INSERT INTO hin2017_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","तब मूसा ने कहा, “यह वह काम है जिसके करने के लिये यहोवा ने आज्ञा दी है कि तुम उसे करो; और यहोवा की महिमा का तेज तुम को दिखाई पड़ेगा।” ");
INSERT INTO hin2017_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","तब मूसा ने हारून से कहा, “यहोवा की आज्ञा के अनुसार वेदी के समीप जाकर अपने पापबलि और होमबलि को चढ़ाकर अपने और सब जनता के लिये प्रायश्चित कर और जनता के चढ़ावे को भी चढ़ाकर उनके लिये प्रायश्चित कर।” (इब्रा. 5:3) ");
INSERT INTO hin2017_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","इसलिए हारून ने वेदी के समीप जाकर अपने पापबलि के बछड़े को बलिदान किया। ");
INSERT INTO hin2017_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","और हारून के पुत्र लहू को उसके पास ले गए, तब उसने अपनी उँगली को लहू में डुबाकर वेदी के सींगों पर लहू को लगाया, और शेष लहू को वेदी के पाए पर उण्डेल दिया; ");
INSERT INTO hin2017_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","और पापबलि में की चर्बी और गुर्दों और कलेजे पर की झिल्ली को उसने वेदी पर जलाया, जैसा यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","और माँस और खाल को उसने छावनी से बाहर आग में जलाया। ");
INSERT INTO hin2017_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","तब होमबलि पशु को बलिदान किया; और हारून के पुत्रों ने लहू को उसके हाथ में दिया, और उसने उसको वेदी पर चारों ओर छिड़क दिया। ");
INSERT INTO hin2017_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","तब उन्होंने होमबलि पशु को टुकड़े-टुकड़े करके सिर सहित उसके हाथ में दे दिया और उसने उनको वेदी पर जला दिया। ");
INSERT INTO hin2017_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","और उसने अंतड़ियों और पाँवों को धोकर वेदी पर होमबलि के ऊपर जलाया। ");
INSERT INTO hin2017_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","तब उसने लोगों के चढ़ावे को आगे लेकर और उस पापबलि के बकरे को जो उनके लिये था लेकर उसका बलिदान किया, और पहले के समान उसे भी पापबलि करके चढ़ाया। ");
INSERT INTO hin2017_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","और उसने होमबलि को भी समीप ले जाकर विधि के अनुसार चढ़ाया। ");
INSERT INTO hin2017_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","और अन्नबलि को भी समीप ले जाकर उसमें से मुट्ठी भर वेदी पर जलाया, यह भोर के होमबलि के अलावा चढ़ाया गया। ");
INSERT INTO hin2017_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","बैल और मेढ़ा, अर्थात् जो मेलबलि पशु जनता के लिये थे वे भी बलि किए गए; और हारून के पुत्रों ने लहू को उसके हाथ में दिया, और उसने उसको वेदी पर चारों ओर छिड़क दिया; ");
INSERT INTO hin2017_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","और उन्होंने बैल की चर्बी को, और मेढ़े में से मोटी पूँछ को, और जिस चर्बी से अंतड़ियाँ ढपी रहती हैं उसको, और गुर्दों सहित कलेजे पर की झिल्ली को भी उसके हाथ में दिया; ");
INSERT INTO hin2017_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","और उन्होंने चर्बी को छातियों पर रखा; और उसने वह चर्बी वेदी पर जलाई, ");
INSERT INTO hin2017_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","परन्तु छातियों और दाहिनी जाँघ को हारून ने मूसा की आज्ञा के अनुसार हिलाने की भेंट के लिये यहोवा के सामने हिलाया। ");
INSERT INTO hin2017_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","तब हारून ने लोगों की ओर हाथ बढ़ाकर उन्हें आशीर्वाद दिया; और पापबलि, होमबलि, और मेलबलियों को चढ़ाकर वह नीचे उतर आया। ");
INSERT INTO hin2017_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","तब मूसा और हारून मिलापवाले तम्बू में गए, और निकलकर लोगों को आशीर्वाद दिया; तब यहोवा का तेज सारी जनता को दिखाई दिया। ");
INSERT INTO hin2017_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","और यहोवा के सामने से आग निकली चर्बी सहित होमबलि को वेदी पर भस्म कर दिया; इसे देखकर जनता ने जय जयकार का नारा लगाया, और अपने-अपने मुँह के बल गिरकर दण्डवत् किया। ");
INSERT INTO hin2017_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","तब नादाब और अबीहू नामक हारून के दो पुत्रों ने अपना-अपना धूपदान लिया, और उनमें आग भरी, और उसमें धूप डालकर उस अनुचित आग को जिसकी आज्ञा यहोवा ने नहीं दी थी यहोवा के सम्मुख अर्पित किया। ");
INSERT INTO hin2017_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","तब यहोवा के सम्मुख से आग निकली और उन दोनों को भस्म कर दिया, और वे यहोवा के सामने मर गए। ");
INSERT INTO hin2017_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","तब मूसा ने हारून से कहा, “यह वही बात है जिसे यहोवा ने कहा था, कि जो मेरे समीप आए अवश्य है कि वह मुझे पवित्र जाने, और सारी जनता के सामने मेरी महिमा करे।” और हारून चुप रहा। ");
INSERT INTO hin2017_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","तब मूसा ने मीशाएल और एलसाफान को जो हारून के चाचा उज्जीएल के पुत्र थे बुलाकर कहा, “निकट आओ, और अपने भतीजों को पवित्रस्थान के आगे से उठाकर छावनी के बाहर ले जाओ।” ");
INSERT INTO hin2017_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","मूसा की इस आज्ञा के अनुसार वे निकट जाकर उनको अंगरखों सहित उठाकर छावनी के बाहर ले गए। ");
INSERT INTO hin2017_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","तब मूसा ने हारून से और उसके पुत्र एलीआजर और ईतामार से कहा, “तुम लोग अपने सिरों के बाल मत बिखराओ, और न अपने वस्त्रों को फाड़ो, ऐसा न हो कि तुम भी मर जाओ, और सारी मण्डली पर उसका क्रोध भड़क उठे; परन्तु इस्राएल के सारे घराने के लोग जो तुम्हारे भाई-बन्धु हैं वह यहोवा की लगाई हुई आग पर विलाप करें। ");
INSERT INTO hin2017_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","और तुम लोग मिलापवाले तम्बू के द्वार के बाहर न जाना, ऐसा न हो कि तुम मर जाओ; क्योंकि यहोवा के अभिषेक का तेल तुम पर लगा हुआ है।” मूसा के इस वचन के अनुसार उन्होंने किया। ");
INSERT INTO hin2017_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","फिर यहोवा ने हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“जब जब तू या तेरे पुत्र मिलापवाले तम्बू में आएँ तब-तब तुम में से कोई न तो दाखमधु पीए हो न और किसी प्रकार का मद्य, कहीं ऐसा न हो कि तुम मर जाओ; तुम्हारी पीढ़ी-पीढ़ी में यह विधि प्रचलित रहे, ");
INSERT INTO hin2017_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","जिससे तुम पवित्र और अपवित्र में, और शुद्ध और अशुद्ध में अन्तर कर सको; ");
INSERT INTO hin2017_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","और इस्राएलियों को उन सब विधियों को सिखा सको जिसे यहोवा ने मूसा के द्वारा उनको बता दी हैं।” ");
INSERT INTO hin2017_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","फिर मूसा ने हारून से और उसके बचे हुए दोनों पुत्र एलीआजर और ईतामार से भी कहा, “यहोवा के हव्य में से जो अन्नबलि बचा है उसे लेकर वेदी के पास बिना ख़मीर खाओ, क्योंकि वह परमपवित्र है; ");
INSERT INTO hin2017_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","और तुम उसे किसी पवित्रस्थान में खाओ, वह यहोवा के हव्य में से तेरा और तेरे पुत्रों का हक़ है; क्योंकि मैंने ऐसी ही आज्ञा पाई है। ");
INSERT INTO hin2017_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","तब हिलाई हुई भेंट की छाती और उठाई हुई भेंट की जाँघ को तुम लोग, अर्थात् तू और तेरे बेटे-बेटियाँ सब किसी शुद्ध स्थान में खाओ; क्योंकि वे इस्राएलियों के मेलबलियों में से तुझे और तेरे बच्चों का हक़ ठहरा दी गई हैं। ");
INSERT INTO hin2017_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","चर्बी के हव्यों समेत जो उठाई हुई जाँघ और हिलाई हुई छाती यहोवा के सामने हिलाने के लिये आया करेंगी, ये भाग यहोवा की आज्ञा के अनुसार सर्वदा की विधि की व्यवस्था से तेरे और तेरे बच्चों के लिये हैं।” ");
INSERT INTO hin2017_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","फिर मूसा ने पापबलि के बकरे की खोजबीन की, तो क्या पाया कि वह जलाया गया है, इसलिए एलीआजर और ईतामार जो हारून के पुत्र बचे थे उनसे वह क्रोध में आकर कहने लगा, ");
INSERT INTO hin2017_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“पापबलि जो परमपवित्र है और जिसे यहोवा ने तुम्हें इसलिए दिया है कि तुम मण्डली के अधर्म का भार अपने पर उठाकर उनके लिये यहोवा के सामने प्रायश्चित करो, तुम ने उसका माँस पवित्रस्थान में क्यों नहीं खाया? ");
INSERT INTO hin2017_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","देखो, उसका लहू पवित्रस्थान के भीतर तो लाया ही नहीं गया, निःसन्देह उचित था कि तुम मेरी आज्ञा के अनुसार उसके माँस को पवित्रस्थान में खाते।” ");
INSERT INTO hin2017_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","इसका उत्तर हारून ने मूसा को इस प्रकार दिया, “देख, आज ही उन्होंने अपने पापबलि और होमबलि को यहोवा के सामने चढ़ाया; फिर मुझ पर ऐसी विपत्तियाँ आ पड़ी हैं! इसलिए यदि मैं आज पापबलि का माँस खाता तो क्या यह बात यहोवा के सम्मुख भली होती?” ");
INSERT INTO hin2017_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","जब मूसा ने यह सुना तब उसे संतोष हुआ। ");
INSERT INTO hin2017_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","फिर यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“इस्राएलियों से कहो: जितने पशु पृथ्वी पर हैं उन सभी में से तुम इन जीवधारियों का माँस खा सकते हो। (इब्रा. 9:10) ");
INSERT INTO hin2017_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","पशुओं में से जितने चिरे या फटे खुर के होते हैं और पागुर करते हैं उन्हें खा सकते हो। ");
INSERT INTO hin2017_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","परन्तु पागुर करनेवाले या फटे खुरवालों में से इन पशुओं को न खाना, अर्थात् ऊँट, जो पागुर तो करता है परन्तु चिरे खुर का नहीं होता, इसलिए वह तुम्हारे लिये अशुद्ध ठहरा है। ");
INSERT INTO hin2017_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","और चट्टानी बिज्जू, जो पागुर तो करता है परन्तु चिरे खुर का नहीं होता, वह भी तुम्हारे लिये अशुद्ध है। ");
INSERT INTO hin2017_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","और खरगोश, जो पागुर तो करता है परन्तु चिरे खुर का नहीं होता, इसलिए वह भी तुम्हारे लिये अशुद्ध है। ");
INSERT INTO hin2017_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","और सूअर, जो चिरे अर्थात् फटे खुर का होता तो है परन्तु पागुर नहीं करता, इसलिए वह तुम्हारे लिये अशुद्ध है। ");
INSERT INTO hin2017_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","इनके माँस में से कुछ न खाना, और इनकी लोथ को छूना भी नहीं; ये तो तुम्हारे लिये अशुद्ध है। ");
INSERT INTO hin2017_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“फिर जितने जलजन्तु हैं उनमें से तुम इन्हें खा सकते हों, अर्थात् समुद्र या नदियों के जलजन्तुओं में से जितनों के पंख और चोंयेटे होते हैं उन्हें खा सकते हो। ");
INSERT INTO hin2017_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","और जलचरी प्राणियों में से जितने जीवधारी बिना पंख और चोंयेटे के समुद्र या नदियों में रहते हैं वे सब तुम्हारे लिये घृणित हैं। ");
INSERT INTO hin2017_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","वे तुम्हारे लिये घृणित ठहरें; तुम उनके माँस में से कुछ न खाना, और उनकी लोथों को अशुद्ध जानना। ");
INSERT INTO hin2017_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","जल में जिस किसी जन्तु के पंख और चोंयेटे नहीं होते वह तुम्हारे लिये अशुद्ध है। ");
INSERT INTO hin2017_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“फिर पक्षियों में से इनको अशुद्ध जानना, ये अशुद्ध होने के कारण खाए न जाएँ, अर्थात् उकाब, हड़फोड़, कुरर, ");
INSERT INTO hin2017_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","चील, और भाँति-भाँति के बाज, ");
INSERT INTO hin2017_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","और भाँति-भाँति के सब काग, ");
INSERT INTO hin2017_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","शुतुर्मुर्ग, तखमास, जलकुक्कट, और भाँति-भाँति के शिकरे, ");
INSERT INTO hin2017_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","हबासिल, हाड़गील, उल्लू, ");
INSERT INTO hin2017_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","राजहँस, धनेश, गिद्ध, ");
INSERT INTO hin2017_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","सारस, भाँति-भाँति के बगुले, टिटीहरी और चमगादड़। ");
INSERT INTO hin2017_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“जितने पंखवाले कीड़े चार पाँवों के बल चलते हैं वे सब तुम्हारे लिये अशुद्ध हैं। ");
INSERT INTO hin2017_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","पर रेंगनेवाले और पंखवाले जो चार पाँवों के बल चलते हैं, जिनके भूमि पर कूदने फाँदने को टाँगें होती हैं उनको तो खा सकते हो। ");
INSERT INTO hin2017_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","वे ये हैं, अर्थात् भाँति-भाँति की टिड्डी, भाँति-भाँति के फनगे, भाँति-भाँति के झींगुर, और भाँति-भाँति के टिड्डे। ");
INSERT INTO hin2017_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","परन्तु और सब रेंगनेवाले पंखवाले जो चार पाँव वाले होते हैं वे तुम्हारे लिये अशुद्ध हैं। ");
INSERT INTO hin2017_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“इनके कारण तुम अशुद्ध ठहरोगे; जिस किसी से इनकी लोथ छू जाए वह साँझ तक अशुद्ध ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","और जो कोई इनकी लोथ में का कुछ भी उठाए वह अपने वस्त्र धोए और साँझ तक अशुद्ध रहे। (इब्रा. 9:10) ");
INSERT INTO hin2017_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","फिर जितने पशु चिरे खुर के होते हैं परन्तु न तो बिलकुल फटे खुर और न पागुर करनेवाले हैं वे तुम्हारे लिये अशुद्ध हैं; जो कोई उन्हें छूए वह अशुद्ध ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","और चार पाँव के बल चलनेवालों में से जितने पंजों के बल चलते हैं वे सब तुम्हारे लिये अशुद्ध हैं; जो कोई उनकी लोथ छूए वह साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","और जो कोई उनकी लोथ उठाए वह अपने वस्त्र धोए और साँझ तक अशुद्ध रहे; क्योंकि वे तुम्हारे लिये अशुद्ध हैं। ");
INSERT INTO hin2017_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“और जो पृथ्वी पर रेंगते हैं उनमें से ये रेंगनेवाले तुम्हारे लिये अशुद्ध हैं, अर्थात् नेवला, चूहा, और भाँति-भाँति के गोह, ");
INSERT INTO hin2017_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","और छिपकली, मगर, टिकटिक, सांडा, और गिरगिट। ");
INSERT INTO hin2017_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","सब रेंगनेवालों में से ये ही तुम्हारे लिये अशुद्ध हैं; जो कोई इनकी लोथ छूए वह साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","और इनमें से किसी की लोथ जिस किसी वस्तु पर पड़ जाए वह भी अशुद्ध ठहरे, चाहे वह काठ का कोई पात्र हो, चाहे वस्त्र, चाहे खाल, चाहे बोरा, चाहे किसी काम का कैसा ही पात्र आदि क्यों न हो; वह जल में डाला जाए, और साँझ तक अशुद्ध रहे, तब शुद्ध समझा जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","और यदि मिट्टी का कोई पात्र हो जिसमें इन जन्तुओं में से कोई पड़े, तो उस पात्र में जो कुछ हो वह अशुद्ध ठहरे, और पात्र को तुम तोड़ डालना। ");
INSERT INTO hin2017_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","उसमें जो खाने के योग्य भोजन हो, जिसमें पानी का छुआव हो वह सब अशुद्ध ठहरे; फिर यदि ऐसे पात्र में पीने के लिये कुछ हो तो वह भी अशुद्ध ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","और यदि इनकी लोथ में का कुछ तंदूर या चूल्हे पर पड़े तो वह भी अशुद्ध ठहरे, और तोड़ डाला जाए; क्योंकि वह अशुद्ध हो जाएगा, वह तुम्हारे लिये भी अशुद्ध ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","परन्तु सोता या तालाब जिसमें जल इकट्ठा हो वह तो शुद्ध ही रहे; परन्तु जो कोई इनकी लोथ को छूए वह अशुद्ध ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","और यदि इनकी लोथ में का कुछ किसी प्रकार के बीज पर जो बोने के लिये हो पड़े, तो वह बीज शुद्ध रहे; ");
INSERT INTO hin2017_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","पर यदि बीज पर जल डाला गया हो और पीछे लोथ में का कुछ उस पर पड़ जाए, तो वह तुम्हारे लिये अशुद्ध ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","फिर जिन पशुओं के खाने की आज्ञा तुम को दी गई है यदि उनमें से कोई पशु मरे, तो जो कोई उसकी लोथ छूए वह साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","और उसकी लोथ में से जो कोई कुछ खाए वह अपने वस्त्र धोए और साँझ तक अशुद्ध रहे; और जो कोई उसकी लोथ उठाए वह भी अपने वस्त्र धोए और साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“सब प्रकार के पृथ्वी पर रेंगनेवाले जन्तु घिनौने हैं; वे खाए न जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","पृथ्वी पर सब रेंगनेवालों में से जितने पेट या चार पाँवों के बल चलते हैं, या अधिक पाँव वाले होते हैं, उन्हें तुम न खाना; क्योंकि वे घिनौने हैं। ");
INSERT INTO hin2017_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","तुम किसी प्रकार के रेंगनेवाले जन्तु के द्वारा अपने आपको घिनौना न करना; और न उनके द्वारा अपने को अशुद्ध करके अपवित्र ठहराना। ");
INSERT INTO hin2017_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","क्योंकि मैं तुम्हारा परमेश्वर यहोवा हूँ; इस कारण अपने को शुद्ध करके पवित्र बने रहो, क्योंकि मैं पवित्र हूँ। इसलिए तुम किसी प्रकार के रेंगनेवाले जन्तु के द्वारा जो पृथ्वी पर चलता है अपने आपको अशुद्ध न करना। (1 पत. 1:16) ");
INSERT INTO hin2017_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","क्योंकि मैं वह यहोवा हूँ जो तुम्हें मिस्र देश से इसलिए निकाल ले आया हूँ कि तुम्हारा परमेश्वर ठहरूँ; इसलिए तुम पवित्र बनो, क्योंकि मैं पवित्र हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“पशुओं, पक्षियों, और सब जलचरी प्राणियों, और पृथ्वी पर सब रेंगनेवाले प्राणियों के विषय में यही व्यवस्था है, ");
INSERT INTO hin2017_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","कि शुद्ध अशुद्ध और भक्ष्य और अभक्ष्य जीवधारियों में भेद किया जाए।” ");
INSERT INTO hin2017_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“इस्राएलियों से कह: जो स्त्री गर्भवती हो और उसके लड़का हो, तो वह सात दिन तक अशुद्ध रहेगी; जिस प्रकार वह ऋतुमती होकर अशुद्ध रहा करती। ");
INSERT INTO hin2017_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","और आठवें दिन लड़के का खतना किया जाए। (लूका 1:59, लूका 2:21, यूह. 7:22, प्रेरि. 15:1) ");
INSERT INTO hin2017_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","फिर वह स्त्री अपने शुद्ध करनेवाले रूधिर में तैंतीस दिन रहे; और जब तक उसके शुद्ध हो जाने के दिन पूरे न हों तब तक वह न तो किसी पवित्र वस्तु को छूए, और न पवित्रस्थान में प्रवेश करे। ");
INSERT INTO hin2017_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","और यदि उसके लड़की पैदा हो, तो उसको ऋतुमती की सी अशुद्धता चौदह दिन की लगे; और फिर छियासठ दिन तक अपने शुद्ध करनेवाले रूधिर में रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“जब उसके शुद्ध हो जाने के दिन पूरे हों, तब चाहे उसके बेटा हुआ हो चाहे बेटी, वह होमबलि के लिये एक वर्ष का भेड़ का बच्चा, और पापबलि के लिये कबूतरी का एक बच्चा या पिण्डुकी मिलापवाले तम्बू के द्वार पर याजक के पास लाए। (लूका 2:22) ");
INSERT INTO hin2017_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","तब याजक उसको यहोवा के सामने भेंट चढ़ाकर उसके लिये प्रायश्चित करे; और वह अपने रूधिर के बहने की अशुद्धता से छूटकर शुद्ध ठहरेगी। जिस स्त्री के लड़का या लड़की उत्पन्न हो उसके लिये यही व्यवस्था है। ");
INSERT INTO hin2017_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","और यदि उसके पास भेड़ या बकरी देने की पूँजी न हो, तो दो पिण्डुकी या कबूतरी के दो बच्चे, एक तो होमबलि और दूसरा पापबलि के लिये दे; और याजक उसके लिये प्रायश्चित करे, तब वह शुद्ध ठहरेगी।” (लूका 2:24) ");
INSERT INTO hin2017_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","फिर यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“जब किसी मनुष्य के शरीर के चर्म में सूजन या पपड़ी या दाग हो, और इससे उसके चर्म में कोढ़ की व्याधि के समान कुछ दिखाई पड़े, तो उसे हारून याजक के पास या उसके पुत्र जो याजक हैं, उनमें से किसी के पास ले जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","जब याजक उसके चर्म की व्याधि को देखे, और यदि उस व्याधि के स्थान के रोएँ उजले हो गए हों और व्याधि चर्म से गहरी दिखाई पड़े, तो वह जान ले कि कोढ़ की व्याधि है; और याजक उस मनुष्य को देखकर उसको अशुद्ध ठहराए। ");
INSERT INTO hin2017_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","पर यदि वह दाग उसके चर्म में उजला तो हो, परन्तु चर्म से गहरा न देख पड़े, और न वहाँ के रोएँ उजले हो गए हों, तो याजक उसको सात दिन तक बन्द करके रखे; ");
INSERT INTO hin2017_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","और सातवें दिन याजक उसको देखे, और यदि वह व्याधि जैसी की तैसी बनी रहे और उसके चर्म में न फैली हो, तो याजक उसको और भी सात दिन तक बन्द करके रखे; ");
INSERT INTO hin2017_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","और सातवें दिन याजक उसको फिर देखे, और यदि देख पड़े कि व्याधि की चमक कम है और व्याधि चर्म पर फैली न हो, तो याजक उसको शुद्ध ठहराए; क्योंकि उसके तो चर्म में पपड़ी है; और वह अपने वस्त्र धोकर शुद्ध हो जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","पर यदि याजक की उस जाँच के पश्चात् जिसमें वह शुद्ध ठहराया गया था, वह पपड़ी उसके चर्म पर बहुत फैल जाए, तो वह फिर याजक को दिखाया जाए; ");
INSERT INTO hin2017_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","और यदि याजक को देख पड़े कि पपड़ी चर्म में फैल गई है, तो वह उसको अशुद्ध ठहराए; क्योंकि वह कोढ़ ही है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“यदि कोढ़ की सी व्याधि किसी मनुष्य के हो, तो वह याजक के पास पहुँचाया जाए; ");
INSERT INTO hin2017_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","और याजक उसको देखे, और यदि वह सूजन उसके चर्म में उजली हो, और उसके कारण रोएँ भी उजले हो गए हों, और उस सूजन में बिना चर्म का माँस हो, ");
INSERT INTO hin2017_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","तो याजक जाने कि उसके चर्म में पुराना कोढ़ है, इसलिए वह उसको अशुद्ध ठहराए; और बन्द न रखे, क्योंकि वह तो अशुद्ध है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","और यदि कोढ़ किसी के चर्म में फूटकर यहाँ तक फैल जाए, कि जहाँ कहीं याजक देखे रोगी के सिर से पैर के तलवे तक कोढ़ ने सारे चर्म को छा लिया हो, ");
INSERT INTO hin2017_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","तो याजक ध्यान से देखे, और यदि कोढ़ ने उसके सारे शरीर को छा लिया हो, तो वह उस व्यक्ति को शुद्ध ठहराए; और उसका शरीर जो बिलकुल उजला हो गया है वह शुद्ध ही ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","पर जब उसमें चर्महीन माँस देख पड़े, तब तो वह अशुद्ध ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","और याजक चर्महीन माँस को देखकर उसको अशुद्ध ठहराए; क्योंकि वैसा चर्महीन माँस अशुद्ध ही होता है; वह कोढ़ है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","पर यदि वह चर्महीन माँस फिर उजला हो जाए, तो वह मनुष्य याजक के पास जाए, ");
INSERT INTO hin2017_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","और याजक उसको देखे, और यदि वह व्याधि फिर से उजली हो गई हो, तो याजक रोगी को शुद्ध जाने; वह शुद्ध है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“फिर यदि किसी के चर्म में फोड़ा होकर चंगा हो गया हो, ");
INSERT INTO hin2017_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","और फोड़े के स्थान में उजली सी सूजन या लाली लिये हुए उजला दाग हो, तो वह याजक को दिखाया जाए; ");
INSERT INTO hin2017_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","और याजक उस सूजन को देखे, और यदि वह चर्म से गहरा दिखाई पड़े, और उसके रोएँ भी उजले हो गए हों, तो याजक यह जानकर उस मनुष्य को अशुद्ध ठहराए; क्योंकि वह कोढ़ की व्याधि है जो फोड़े में से फूटकर निकली है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","परन्तु यदि याजक देखे कि उसमें उजले रोएँ नहीं हैं, और वह चर्म से गहरी नहीं, और उसकी चमक कम हुई है, तो याजक उस मनुष्य को सात दिन तक बन्द करके रखे। ");
INSERT INTO hin2017_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","और यदि वह व्याधि उस समय तक चर्म में सचमुच फैल जाए, तो याजक उस मनुष्य को अशुद्ध ठहराए; क्योंकि वह कोढ़ की व्याधि है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","परन्तु यदि वह दाग न फैले और अपने स्थान ही पर बना रहे, तो वह फोड़े का दाग है; याजक उस मनुष्य को शुद्ध ठहराए। ");
INSERT INTO hin2017_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“फिर यदि किसी के चर्म में जलने का घाव हो, और उस जलने के घाव में चर्महीन दाग लाली लिये हुए उजला या उजला ही हो जाए, ");
INSERT INTO hin2017_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","तो याजक उसको देखे, और यदि उस दाग में के रोएँ उजले हो गए हों और वह चर्म से गहरा दिखाई पड़े, तो वह कोढ़ है; जो उस जलने के दाग में से फूट निकला है; याजक उस मनुष्य को अशुद्ध ठहराए; क्योंकि उसमें कोढ़ की व्याधि है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","पर यदि याजक देखे, कि दाग में उजले रोएँ नहीं और न वह चर्म से कुछ गहरा है, और उसकी चमक कम हुई है, तो वह उसको सात दिन तक बन्द करके रखे, ");
INSERT INTO hin2017_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","और सातवें दिन याजक उसको देखे, और यदि वह चर्म में फैल गई हो, तो वह उस मनुष्य को अशुद्ध ठहराए; क्योंकि उसको कोढ़ की व्याधि है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","परन्तु यदि वह दाग चर्म में नहीं फैला और अपने स्थान ही पर जहाँ का तहाँ बना हो, और उसकी चमक कम हुई हो, तो वह जल जाने के कारण सूजा हुआ है, याजक उस मनुष्य को शुद्ध ठहराए; क्योंकि वह दाग जल जाने के कारण से है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“फिर यदि किसी पुरुष या स्त्री के सिर पर, या पुरुष की दाढ़ी में व्याधि हो, ");
INSERT INTO hin2017_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","तो याजक व्याधि को देखे, और यदि वह चर्म से गहरी देख पड़े, और उसमें भूरे-भूरे पतले बाल हों, तो याजक उस मनुष्य को अशुद्ध ठहराए; वह व्याधि सेंहुआ, अर्थात् सिर या दाढ़ी का कोढ़ है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","और यदि याजक सेंहुएँ की व्याधि को देखे, कि वह चर्म से गहरी नहीं है और उसमें काले-काले बाल नहीं हैं, तो वह सेंहुएँ के रोगी को सात दिन तक बन्द करके रखे, ");
INSERT INTO hin2017_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","और सातवें दिन याजक व्याधि को देखे, तब यदि वह सेंहुआ फैला न हो, और उसमें भूरे-भूरे बाल न हों, और सेंहुआ चर्म से गहरा न देख पड़े, ");
INSERT INTO hin2017_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","तो यह मनुष्य मुँड़ा जाए, परन्तु जहाँ सेंहुआ हो वहाँ न मुँड़ा जाए; और याजक उस सेंहुएँ वाले को और भी सात दिन तक बन्द करे; ");
INSERT INTO hin2017_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","और सातवें दिन याजक सेंहुएँ को देखे, और यदि वह सेंहुआ चर्म में फैला न हो और चर्म से गहरा न देख पड़े, तो याजक उस मनुष्य को शुद्ध ठहराए; और वह अपने वस्त्र धोकर शुद्ध ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","पर यदि उसके शुद्ध ठहरने के पश्चात् सेंहुआ चर्म में कुछ भी फैले, ");
INSERT INTO hin2017_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","तो याजक उसको देखे, और यदि वह चर्म में फैला हो, तो याजक भूरे बाल न ढूँढ़े, क्योंकि वह मनुष्य अशुद्ध है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","परन्तु यदि उसकी दृष्टि में वह सेंहुआ जैसे का तैसा बना हो, और उसमें काले-काले बाल जमे हों, तो वह जाने की सेंहुआ चंगा हो गया है, और वह मनुष्य शुद्ध है; याजक उसको शुद्ध ही ठहराए। ");
INSERT INTO hin2017_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“फिर यदि किसी पुरुष या स्त्री के चर्म में उजले दाग हों, ");
INSERT INTO hin2017_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","तो याजक देखे, और यदि उसके चर्म में वे दाग कम उजले हों, तो वह जाने कि उसको चर्म में निकली हुई दाद ही है; वह मनुष्य शुद्ध ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“फिर जिसके सिर के बाल झड़ गए हों, तो जानना कि वह चन्दुला तो है परन्तु शुद्ध है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","और जिसके सिर के आगे के बाल झड़ गए हों, तो वह माथे का चन्दुला तो है परन्तु शुद्ध है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","परन्तु यदि चन्दुले सिर पर या चन्दुले माथे पर लाली लिये हुए उजली व्याधि हो, तो जानना कि वह उसके चन्दुले सिर पर या चन्दुले माथे पर निकला हुआ कोढ़ है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","इसलिए याजक उसको देखे, और यदि व्याधि की सूजन उसके चन्दुले सिर या चन्दुले माथे पर ऐसी लाली लिये हुए उजली हो जैसा चर्म के कोढ़ में होता है, ");
INSERT INTO hin2017_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","तो वह मनुष्य कोढ़ी है और अशुद्ध है; और याजक उसको अवश्य अशुद्ध ठहराए; क्योंकि वह व्याधि उसके सिर पर है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“जिसमें वह व्याधि हो उस कोढ़ी के वस्त्र फटे और सिर के बाल बिखरे रहें, और वह अपने ऊपरवाले होंठ को ढाँपे हुए अशुद्ध, अशुद्ध पुकारा करे। ");
INSERT INTO hin2017_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","जितने दिन तक वह व्याधि उसमें रहे उतने दिन तक वह तो अशुद्ध रहेगा; और वह अशुद्ध ठहरा रहे; इसलिए वह अकेला रहा करे, उसका निवास-स्थान छावनी के बाहर हो। (लूका 17:12) ");
INSERT INTO hin2017_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“फिर जिस वस्त्र में कोढ़ की व्याधि हो, चाहे वह वस्त्र ऊन का हो चाहे सनी का, ");
INSERT INTO hin2017_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","वह व्याधि चाहे उस सनी या ऊन के वस्त्र के ताने में हो चाहे बाने में, या वह व्याधि चमड़े में या चमड़े की बनी हुई किसी वस्तु में हो, ");
INSERT INTO hin2017_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","यदि वह व्याधि किसी वस्त्र के चाहे ताने में चाहे बाने में, या चमड़े में या चमड़े की किसी वस्तु में हरी हो या लाल सी हो, तो जानना कि वह कोढ़ की व्याधि है और वह याजक को दिखाई जाए। (मत्ती 8:4, मर. 1:44, लूका 5:14, लूका 17:14) ");
INSERT INTO hin2017_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","और याजक व्याधि को देखे, और व्याधिवाली वस्तु को सात दिन के लिये बन्द करे; ");
INSERT INTO hin2017_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","और सातवें दिन वह उस व्याधि को देखे, और यदि वह वस्त्र के चाहे ताने में चाहे बाने में, या चमड़े में या चमड़े की बनी हुई किसी वस्तु में फैल गई हो, तो जानना कि व्याधि गलित कोढ़ है, इसलिए वह वस्तु, चाहे कैसे ही काम में क्यों न आती हो, तो भी अशुद्ध ठहरेगी। ");
INSERT INTO hin2017_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","वह उस वस्त्र को जिसके ताने या बाने में वह व्याधि हो, चाहे वह ऊन का हो चाहे सनी का, या चमड़े की वस्तु हो, उसको जला दे, वह व्याधि गलित कोढ़ की है; वह वस्तु आग में जलाई जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“यदि याजक देखे कि वह व्याधि उस वस्त्र के ताने या बाने में, या चमड़े की उस वस्तु में नहीं फैली, ");
INSERT INTO hin2017_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","तो जिस वस्तु में व्याधि हो उसके धोने की आज्ञा दे, तब उसे और भी सात दिन तक बन्द करके रखे; ");
INSERT INTO hin2017_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","और उसके धोने के बाद याजक उसको देखे, और यदि व्याधि का न तो रंग बदला हो, और न व्याधि फैली हो, तो जानना कि वह अशुद्ध है; उसे आग में जलाना, क्योंकि चाहे वह व्याधि भीतर चाहे ऊपरी हो तो भी वह खा जानेवाली व्याधि है। ");
INSERT INTO hin2017_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","पर यदि याजक देखे, कि उसके धोने के पश्चात् व्याधि की चमक कम हो गई, तो वह उसको वस्त्र के चाहे ताने चाहे बाने में से, या चमड़े में से फाड़कर निकाले; ");
INSERT INTO hin2017_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","और यदि वह व्याधि तब भी उस वस्त्र के ताने या बाने में, या चमड़े की उस वस्तु में दिखाई पड़े, तो जानना कि वह फूटकर निकली हुई व्याधि है; और जिसमें वह व्याधि हो उसे आग में जलाना। ");
INSERT INTO hin2017_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","यदि उस वस्त्र से जिसके ताने या बाने में व्याधि हो, या चमड़े की जो वस्तु हो उससे जब धोई जाए और व्याधि जाती रही, तो वह दूसरी बार धुलकर शुद्ध ठहरे।” ");
INSERT INTO hin2017_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ऊन या सनी के वस्त्र में के ताने या बाने में, या चमड़े की किसी वस्तु में जो कोढ़ की व्याधि हो उसके शुद्ध और अशुद्ध ठहराने की यही व्यवस्था है। ");
INSERT INTO hin2017_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“कोढ़ी के शुद्ध ठहराने की व्यवस्था यह है।, वह याजक के पास पहुँचाया जाए; (मत्ती 8:4) ");
INSERT INTO hin2017_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","और याजक छावनी के बाहर जाए, और याजक उस कोढ़ी को देखे, और यदि उसके कोढ़ की व्याधि चंगी हुई हो, (लूका 17:14) ");
INSERT INTO hin2017_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","तो याजक आज्ञा दे कि शुद्ध ठहरानेवाले के लिये दो शुद्ध और जीवित पक्षी, देवदार की लकड़ी, और लाल रंग का कपड़ा और जूफा ये सब लिये जाएँ; (इब्रा. 9:19) ");
INSERT INTO hin2017_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","और याजक आज्ञा दे कि एक पक्षी बहते हुए जल के ऊपर मिट्टी के पात्र में बलि किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","तब वह जीवित पक्षी को देवदार की लकड़ी और लाल रंग के कपड़े और जूफा इन सभी को लेकर एक संग उस पक्षी के लहू में जो बहते हुए जल के ऊपर बलि किया गया है डुबा दे; ");
INSERT INTO hin2017_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","और कोढ़ से शुद्ध ठहरनेवाले पर सात बार छिड़ककर उसको शुद्ध ठहराए, तब उस जीवित पक्षी को मैदान में छोड़ दे। ");
INSERT INTO hin2017_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","और शुद्ध ठहरनेवाला अपने वस्त्रों को धोए, और सब बाल मुँण्डवाकर जल से स्नान करे, तब वह शुद्ध ठहरेगा; और उसके बाद वह छावनी में आने पाए, परन्तु सात दिन तक अपने डेरे से बाहर ही रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","और सातवें दिन वह सिर, दाढ़ी और भौहों के सब बाल मुँड़ाएँ, और सब अंग मुँण्ड़न कराए, और अपने वस्त्रों को धोए, और जल से स्नान करे, तब वह शुद्ध ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“आठवें दिन वह दो निर्दोष भेड़ के बच्चे, और एक वर्ष की निर्दोष भेड़ की बच्ची, और अन्नबलि के लिये तेल से सना हुआ एपा का तीन दहाई अंश मैदा, और लोज भर तेल लाए। ");
INSERT INTO hin2017_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","और शुद्ध ठहरानेवाला याजक इन वस्तुओं समेत उस शुद्ध होनेवाले मनुष्य को यहोवा के सम्मुख मिलापवाले तम्बू के द्वार पर खड़ा करे। ");
INSERT INTO hin2017_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","तब याजक एक भेड़ का बच्चा लेकर दोषबलि के लिये उसे और उस लोज भर तेल को समीप लाए, और इन दोनों को हिलाने की भेंट के लिये यहोवा के सामने हिलाए; ");
INSERT INTO hin2017_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","और वह उस भेड़ के बच्चे को उसी स्थान में जहाँ वह पापबलि और होमबलि पशुओं का बलिदान किया करेगा, अर्थात् पवित्रस्थान में बलिदान करे; क्योंकि जैसे पापबलि याजक का निज भाग होगा वैसे ही दोषबलि भी उसी का निज भाग ठहरेगा; वह परमपवित्र है। ");
INSERT INTO hin2017_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","तब याजक दोषबलि के लहू में से कुछ लेकर शुद्ध ठहरनेवाले के दाहिने कान के सिरे पर, और उसके दाहिने हाथ और दाहिने पाँव के अँगूठों पर लगाए। ");
INSERT INTO hin2017_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","तब याजक उस लोज भर तेल में से कुछ लेकर अपने बाएँ हाथ की हथेली पर डाले, ");
INSERT INTO hin2017_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","और याजक अपने दाहिने हाथ की उँगली को अपनी बाईं हथेली पर के तेल में डुबाकर उस तेल में से कुछ अपनी उँगली से यहोवा के सम्मुख सात बार छिड़के। ");
INSERT INTO hin2017_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","और जो तेल उसकी हथेली पर रह जाएगा याजक उसमें से कुछ शुद्ध होनेवाले के दाहिने कान के सिरे पर, और उसके दाहिने हाथ और दाहिने पाँव के अँगूठों पर दोषबलि के लहू के ऊपर लगाए; ");
INSERT INTO hin2017_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","और जो तेल याजक की हथेली पर रह जाए उसको वह शुद्ध होनेवाले के सिर पर डाल दे। और याजक उसके लिये यहोवा के सामने प्रायश्चित करे। ");
INSERT INTO hin2017_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","याजक पापबलि को भी चढ़ाकर उसके लिये जो अपनी अशुद्धता से शुद्ध होनेवाला हो प्रायश्चित करे; और उसके बाद होमबलि पशु का बलिदान करके ");
INSERT INTO hin2017_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","अन्नबलि समेत वेदी पर चढ़ाए: और याजक उसके लिये प्रायश्चित करे, और वह शुद्ध ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“परन्तु यदि वह दरिद्र हो और इतना लाने के लिये उसके पास पूँजी न हो, तो वह अपना प्रायश्चित करवाने के निमित्त, हिलाने के लिये भेड़ का बच्चा दोषबलि के लिये, और तेल से सना हुआ एपा का दसवाँ अंश मैदा अन्नबलि करके, और लोज भर तेल लाए; ");
INSERT INTO hin2017_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","और दो पंडुक, या कबूतरी के दो बच्चे लाए, जो वह ला सके; और इनमें से एक तो पापबलि के लिये और दूसरा होमबलि के लिये हो। ");
INSERT INTO hin2017_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","और आठवें दिन वह इन सभी को अपने शुद्ध ठहरने के लिये मिलापवाले तम्बू के द्वार पर, यहोवा के सम्मुख, याजक के पास ले आए; ");
INSERT INTO hin2017_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","तब याजक उस लोज भर तेल और दोषबलिवाले भेड़ के बच्चे को लेकर हिलाने की भेंट के लिये यहोवा के सामने हिलाए। ");
INSERT INTO hin2017_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","फिर दोषबलि के भेड़ के बच्चे का बलिदान किया जाए; और याजक उसके लहू में से कुछ लेकर शुद्ध ठहरनेवाले के दाहिने कान के सिरे पर, और उसके दाहिने हाथ और दाहिने पाँव के अँगूठों पर लगाए। ");
INSERT INTO hin2017_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","फिर याजक उस तेल में से कुछ अपने बाएँ हाथ की हथेली पर डालकर, ");
INSERT INTO hin2017_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","अपने दाहिने हाथ की उँगली से अपनी बाईं हथेली पर के तेल में से कुछ यहोवा के सम्मुख सात बार छिड़के; ");
INSERT INTO hin2017_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","फिर याजक अपनी हथेली पर के तेल में से कुछ शुद्ध ठहरनेवाले के दाहिने कान के सिरे पर, और उसके दाहिने हाथ और दाहिने पाँव के अँगूठों, पर दोषबलि के लहू के स्थान पर लगाए। ");
INSERT INTO hin2017_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","और जो तेल याजक की हथेली पर रह जाए उसे वह शुद्ध ठहरनेवाले के लिये यहोवा के सामने प्रायश्चित करने को उसके सिर पर डाल दे। ");
INSERT INTO hin2017_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","तब वह पंडुक या कबूतरी के बच्चों में से जो वह ला सका हो एक को चढ़ाए, ");
INSERT INTO hin2017_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","अर्थात् जो पक्षी वह ला सका हो, उनमें से वह एक को पापबलि के लिये और अन्नबलि समेत दूसरे को होमबलि के लिये चढ़ाए; इस रीति से याजक शुद्ध ठहरनेवाले के लिये यहोवा के सामने प्रायश्चित करे। ");
INSERT INTO hin2017_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","जिसे कोढ़ की व्याधि हुई हो, और उसके इतनी पूँजी न हो कि वह शुद्ध ठहरने की सामग्री को ला सके, तो उसके लिये यही व्यवस्था है।” (मर. 1:44, लूका 5:14, मत्ती 8:4) ");
INSERT INTO hin2017_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","फिर यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“जब तुम लोग कनान देश में पहुँचो, जिसे मैं तुम्हारी निज भूमि होने के लिये तुम्हें देता हूँ, उस समय यदि मैं कोढ़ की व्याधि तुम्हारे अधिकार के किसी घर में दिखाऊँ, ");
INSERT INTO hin2017_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","तो जिसका वह घर हो वह आकर याजक को बता दे कि मुझे ऐसा देख पड़ता है कि घर में मानो कोई व्याधि है। ");
INSERT INTO hin2017_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","तब याजक आज्ञा दे कि उस घर में व्याधि देखने के लिये मेरे जाने से पहले उसे खाली करो, कहीं ऐसा न हो कि जो कुछ घर में हो वह सब अशुद्ध ठहरे; और इसके बाद याजक घर देखने को भीतर जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","तब वह उस व्याधि को देखे; और यदि वह व्याधि घर की दीवारों पर हरी-हरी या लाल-लाल मानो खुदी हुई लकीरों के रूप में हो, और ये लकीरें दीवार में गहरी देख पड़ती हों, ");
INSERT INTO hin2017_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","तो याजक घर से बाहर द्वार पर जाकर घर को सात दिन तक बन्द कर रखे। ");
INSERT INTO hin2017_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","और सातवें दिन याजक आकर देखे; और यदि वह व्याधि घर की दीवारों पर फैल गई हो, ");
INSERT INTO hin2017_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","तो याजक आज्ञा दे कि जिन पत्थरों को व्याधि है उन्हें निकालकर नगर से बाहर किसी अशुद्ध स्थान में फेंक दें; ");
INSERT INTO hin2017_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","और वह घर के भीतर ही भीतर चारों ओर खुरचवाए, और वह खुरचन की मिट्टी नगर से बाहर किसी अशुद्ध स्थान में डाली जाए; ");
INSERT INTO hin2017_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","और उन पत्थरों के स्थान में और दूसरे पत्थर लेकर लगाएँ और याजक ताजा गारा लेकर घर की जुड़ाई करे। ");
INSERT INTO hin2017_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“यदि पत्थरों के निकाले जाने और घर के खुरचे और पुताई जाने के बाद वह व्याधि फिर घर में फूट निकले, ");
INSERT INTO hin2017_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","तो याजक आकर देखे; और यदि वह व्याधि घर में फैल गई हो, तो वह जान ले कि घर में गलित कोढ़ है; वह अशुद्ध है। ");
INSERT INTO hin2017_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","और वह सब गारे समेत पत्थर, लकड़ी और घर को खुदवाकर गिरा दे; और उन सब वस्तुओं को उठवाकर नगर से बाहर किसी अशुद्ध स्थान पर फिंकवा दे। ");
INSERT INTO hin2017_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","और जब तक वह घर बन्द रहे तब तक यदि कोई उसमें जाए तो वह साँझ तक अशुद्ध रहे; ");
INSERT INTO hin2017_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","और जो कोई उस घर में सोए वह अपने वस्त्रों को धोए; और जो कोई उस घर में खाना खाए वह भी अपने वस्त्रों को धोए। ");
INSERT INTO hin2017_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“पर यदि याजक आकर देखे कि जब से घर लेसा गया है तब से उसमें व्याधि नहीं फैली है, तो यह जानकर कि वह व्याधि दूर हो गई है, घर को शुद्ध ठहराए। ");
INSERT INTO hin2017_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","और उस घर को पवित्र करने के लिये दो पक्षी, देवदार की लकड़ी, लाल रंग का कपड़ा और जूफा लाए, ");
INSERT INTO hin2017_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","और एक पक्षी बहते हुए जल के ऊपर मिट्टी के पात्र में बलिदान करे, ");
INSERT INTO hin2017_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","तब वह देवदार की लकड़ी, लाल रंग के कपड़े और जूफा और जीवित पक्षी इन सभी को लेकर बलिदान किए हुए पक्षी के लहू में और बहते हुए जल में डुबा दे, और उस घर पर सात बार छिड़के। ");
INSERT INTO hin2017_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","इस प्रकार वह पक्षी के लहू, और बहते हुए जल, और जीवित पक्षी, और देवदार की लकड़ी, और जूफा और लाल रंग के कपड़े के द्वारा घर को पवित्र करे; ");
INSERT INTO hin2017_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","तब वह जीवित पक्षी को नगर से बाहर मैदान में छोड़ दे; इसी रीति से वह घर के लिये प्रायश्चित करे, तब वह शुद्ध ठहरेगा।” ");
INSERT INTO hin2017_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","सब भाँति के कोढ़ की व्याधि, और सेंहुएँ, ");
INSERT INTO hin2017_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","और वस्त्र, और घर के कोढ़, ");
INSERT INTO hin2017_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","और सूजन, और पपड़ी, और दाग के विषय में, ");
INSERT INTO hin2017_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","शुद्ध और अशुद्ध ठहराने की शिक्षा देने की व्यवस्था यही है। सब प्रकार के कोढ़ की व्यवस्था यही है। ");
INSERT INTO hin2017_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","फिर यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“इस्राएलियों से कहो कि जिस-जिस पुरुष के प्रमेह हो, तो वह प्रमेह के कारण से अशुद्ध ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","वह चाहे बहता रहे, चाहे बहना बन्द भी हो, तो भी उसकी अशुद्धता बनी रहेगी। ");
INSERT INTO hin2017_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","जिसके प्रमेह हो वह जिस-जिस बिछौने पर लेटे वह अशुद्ध ठहरे, और जिस-जिस वस्तु पर वह बैठे वह भी अशुद्ध ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","और जो कोई उसके बिछौने को छूए वह अपने वस्त्रों को धोकर जल से स्नान करे, और साँझ तक अशुद्ध ठहरा रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","और जिसके प्रमेह हो और वह जिस वस्तु पर बैठा हो, उस पर जो कोई बैठे वह अपने वस्त्रों को धोकर जल से स्नान करे, और साँझ तक अशुद्ध ठहरा रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","और जिसके प्रमेह हो उससे जो कोई छू जाए वह अपने वस्त्रों को धोकर जल से स्नान करे और साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","और जिसके प्रमेह हो यदि वह किसी शुद्ध मनुष्य पर थूके, तो वह अपने वस्त्रों को धोकर जल से स्नान करे, और साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","और जिसके प्रमेह हो वह सवारी की जिस वस्तु पर बैठे वह अशुद्ध ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","और जो कोई किसी वस्तु को जो उसके नीचे रही हो छूए, वह साँझ तक अशुद्ध रहें; और जो कोई ऐसी किसी वस्तु को उठाए वह अपने वस्त्रों को धोकर जल से स्नान करे, और साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","और जिसके प्रमेह हो वह जिस किसी को बिना हाथ धोए छूए वह अपने वस्त्रों को धोकर जल से स्नान करे, और साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","और जिसके प्रमेह हो वह मिट्टी के जिस किसी पात्र को छूए वह तोड़ डाला जाए, और काठ के सब प्रकार के पात्र जल से धोए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“फिर जिसके प्रमेह हो वह जब अपने रोग से चंगा हो जाए, तब से शुद्ध ठहरने के सात दिन गिन ले, और उनके बीतने पर अपने वस्त्रों को धोकर बहते हुए जल से स्नान करे; तब वह शुद्ध ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","और आठवें दिन वह दो पंडुक या कबूतरी के दो बच्चे लेकर मिलापवाले तम्बू के द्वार पर यहोवा के सम्मुख जाकर उन्हें याजक को दे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","तब याजक उनमें से एक को पापबलि; और दूसरे को होमबलि के लिये भेंट चढ़ाए; और याजक उसके लिये उसके प्रमेह के कारण यहोवा के सामने प्रायश्चित करे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“फिर यदि किसी पुरुष का वीर्य स्खलित हो जाए, तो वह अपने सारे शरीर को जल से धोए, और साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","और जिस किसी वस्त्र या चमड़े पर वह वीर्य पड़े वह जल से धोया जाए, और साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","और जब कोई पुरुष स्त्री से प्रसंग करे तो वे दोनों जल से स्नान करें, और साँझ तक अशुद्ध रहें। (इब्रा. 9:10) ");
INSERT INTO hin2017_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“फिर जब कोई स्त्री ऋतुमती रहे, तो वह सात दिन तक अशुद्ध ठहरी रहे, और जो कोई उसको छूए वह साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","और जब तक वह अशुद्ध रहे तब तक जिस-जिस वस्तु पर वह लेटे, और जिस-जिस वस्तु पर वह बैठे वे सब अशुद्ध ठहरें। ");
INSERT INTO hin2017_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","और जो कोई उसके बिछौने को छूए वह अपने वस्त्र धोकर जल से स्नान करे, और साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","और जो कोई किसी वस्तु को छूए जिस पर वह बैठी हो वह अपने वस्त्र धोकर जल से स्नान करे, और साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","और यदि बिछौने या और किसी वस्तु पर जिस पर वह बैठी हो छूने के समय उसका रूधिर लगा हो, तो छूनेवाले साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","और यदि कोई पुरुष उससे प्रसंग करे, और उसका रूधिर उसके लग जाए, तो वह पुरुष सात दिन तक अशुद्ध रहे, और जिस-जिस बिछौने पर वह लेटे वे सब अशुद्ध ठहरें। ");
INSERT INTO hin2017_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“फिर यदि किसी स्त्री के अपने मासिक धर्म के नियुक्त समय से अधिक दिन तक रूधिर बहता रहे, या उस नियुक्त समय से अधिक समय तक ऋतुमती रहे, तो जब तक वह ऐसी दशा में रहे तब तक वह अशुद्ध ठहरी रहे। (मत्ती 9:20) ");
INSERT INTO hin2017_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","उसके ऋतुमती रहने के सब दिनों में जिस-जिस बिछौने पर वह लेटे वे सब उसके मासिक धर्म के बिछौने के समान ठहरें; और जिस-जिस वस्तु पर वह बैठे वे भी उसके ऋतुमती रहने के दिनों के समान अशुद्ध ठहरें। ");
INSERT INTO hin2017_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","और जो कोई उन वस्तुओं को छूए वह अशुद्ध ठहरे, इसलिए वह अपने वस्त्रों को धोकर जल से स्नान करे, और साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","और जब वह स्त्री अपने ऋतुमती से शुद्ध हो जाए, तब से वह सात दिन गिन ले, और उन दिनों के बीतने पर वह शुद्ध ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","फिर आठवें दिन वह दो पंडुक या कबूतरी के दो बच्चे लेकर मिलापवाले तम्बू के द्वार पर याजक के पास जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","तब याजक एक को पापबलि और दूसरे को होमबलि के लिये चढ़ाए; और याजक उसके लिये उसके मासिक धर्म की अशुद्धता के कारण यहोवा के सामने प्रायश्चित करे। ");
INSERT INTO hin2017_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“इस प्रकार से तुम इस्राएलियों को उनकी अशुद्धता से अलग रखा करो, कहीं ऐसा न हो कि वे यहोवा के निवास को जो उनके बीच में है अशुद्ध करके अपनी अशुद्धता में फँसकर मर जाएँ।” ");
INSERT INTO hin2017_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","जिसके प्रमेह हो और जो पुरुष वीर्य स्खलित होने से अशुद्ध हो; ");
INSERT INTO hin2017_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","और जो स्त्री ऋतुमती हो; और क्या पुरुष क्या स्त्री, जिस किसी के धातुरोग हो, और जो पुरुष अशुद्ध स्त्री के साथ प्रसंग करे, इन सभी के लिये यही व्यवस्था है। ");
INSERT INTO hin2017_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","जब हारून के दो पुत्र यहोवा के सामने समीप जाकर मर गए, उसके बाद यहोवा ने मूसा से बातें की; ");
INSERT INTO hin2017_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","और यहोवा ने मूसा से कहा, “अपने भाई हारून से कह कि सन्दूक के ऊपर के प्रायश्चितवाले ढकने के आगे, बीचवाले पर्दे के अन्दर, अति पवित्रस्थान में हर समय न प्रवेश करे, नहीं तो मर जाएगा; क्योंकि मैं प्रायश्चितवाले ढकने के ऊपर बादल में दिखाई दूँगा। (इब्रा. 6:19) ");
INSERT INTO hin2017_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","जब हारून अति पवित्रस्थान में प्रवेश करे तब इस रीति से प्रवेश करे, अर्थात् पापबलि के लिये एक बछड़े को और होमबलि के लिये एक मेढ़े को लेकर आए। ");
INSERT INTO hin2017_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","वह सनी के कपड़े का पवित्र अंगरखा, और अपने तन पर सनी के कपड़े की जाँघिया पहने हुए, और सनी के कपड़े का कमरबन्ध, और सनी के कपड़े की पगड़ी बाँधे हुए प्रवेश करे; ये पवित्र वस्त्र हैं, और वह जल से स्नान करके इन्हें पहने। ");
INSERT INTO hin2017_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","फिर वह इस्राएलियों की मण्डली के पास से पापबलि के लिये दो बकरे और होमबलि के लिये एक मेढ़ा ले। ");
INSERT INTO hin2017_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","और हारून उस पापबलि के बछड़े को जो उसी के लिये होगा चढ़ाकर अपने और अपने घराने के लिये प्रायश्चित करे। (इब्रा. 5:3, इब्रा. 7:27) ");
INSERT INTO hin2017_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","और उन दोनों बकरों को लेकर मिलापवाले तम्बू के द्वार पर यहोवा के सामने खड़ा करे; ");
INSERT INTO hin2017_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","और हारून दोनों बकरों पर चिट्ठियाँ डाले, एक चिट्ठी यहोवा के लिये और दूसरी अजाजेल के लिये हो। ");
INSERT INTO hin2017_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","और जिस बकरे पर यहोवा के नाम की चिट्ठी निकले उसको हारून पापबलि के लिये चढ़ाए; ");
INSERT INTO hin2017_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","परन्तु जिस बकरे पर अजाजेल के लिये चिट्ठी निकले वह यहोवा के सामने जीवित खड़ा किया जाए कि उससे प्रायश्चित किया जाए, और वह अजाजेल के लिये जंगल में छोड़ा जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“हारून उस पापबलि के बछड़े को, जो उसी के लिये होगा, समीप ले आए, और उसको बलिदान करके अपने और अपने घराने के लिये प्रायश्चित करे। ");
INSERT INTO hin2017_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","और जो वेदी यहोवा के सम्मुख है, उस पर के जलते हुए कोयलों से भरे हुए धूपदान को लेकर, और अपनी दोनों मुट्ठियों को कूटे हुए सुगन्धित धूप से भरकर, बीचवाले पर्दे के भीतर ले आकर (इब्रा. 6:19) ");
INSERT INTO hin2017_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","उस धूप को यहोवा के सम्मुख आग में डाले, जिससे धूप का धुआँ साक्षीपत्र के ऊपर के प्रायश्चित के ढकने के ऊपर छा जाए, नहीं तो वह मर जाएगा; ");
INSERT INTO hin2017_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","तब वह बछड़े के लहू में से कुछ लेकर पूरब की ओर प्रायश्चित के ढकने के ऊपर अपनी उँगली से छिड़के, और फिर उस लहू में से कुछ उँगली के द्वारा उस ढकने के सामने भी सात बार छिड़क दे। (इब्रा. 9:7-13) ");
INSERT INTO hin2017_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","फिर वह उस पापबलि के बकरे को जो साधारण जनता के लिये होगा बलिदान करके उसके लहू को बीचवाले पर्दे के भीतर ले आए, और जिस प्रकार बछड़े के लहू से उसने किया था ठीक वैसा ही वह बकरे के लहू से भी करे, अर्थात् उसको प्रायश्चित के ढकने के ऊपर और उसके सामने छिड़के। (इब्रा. 6:19, इब्रा. 7:27, इब्रा. 9:7-13, इब्रा. 10:4) ");
INSERT INTO hin2017_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","और वह इस्राएलियों की भाँति-भाँति की अशुद्धता, और अपराधों, और उनके सब पापों के कारण पवित्रस्थान के लिये प्रायश्चित करे; और मिलापवाले तम्बू जो उनके संग उनकी भाँति-भाँति की अशुद्धता के बीच रहता है उसके लिये भी वह वैसा ही करे। ");
INSERT INTO hin2017_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","जब हारून प्रायश्चित करने के लिये अति पवित्रस्थान में प्रवेश करे, तब से जब तक वह अपने और अपने घराने और इस्राएल की सारी मण्डली के लिये प्रायश्चित करके बाहर न निकले तब तक कोई मनुष्य मिलापवाले तम्बू में न रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","फिर वह निकलकर उस वेदी के पास जो यहोवा के सामने है जाए और उसके लिये प्रायश्चित करे, अर्थात् बछड़े के लहू और बकरे के लहू दोनों में से कुछ लेकर उस वेदी के चारों कोनों के सींगों पर लगाए। ");
INSERT INTO hin2017_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","और उस लहू में से कुछ अपनी उँगली के द्वारा सात बार उस पर छिड़ककर उसे इस्राएलियों की भाँति-भाँति की अशुद्धता छुड़ाकर शुद्ध और पवित्र करे। ");
INSERT INTO hin2017_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“जब वह पवित्रस्थान और मिलापवाले तम्बू और वेदी के लिये प्रायश्चित कर चुके, तब जीवित बकरे को आगे ले आए; ");
INSERT INTO hin2017_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","और हारून अपने दोनों हाथों को जीवित बकरे पर रखकर इस्राएलियों के सब अधर्म के कामों, और उनके सब अपराधों, अर्थात् उनके सारे पापों को अंगीकार करे, और उनको बकरे के सिर पर धरकर उसको किसी मनुष्य के हाथ जो इस काम के लिये तैयार हो जंगल में भेजकर छुड़वा दे। (इब्रा. 10:4) ");
INSERT INTO hin2017_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","वह बकरा उनके सब अधर्म के कामों को अपने ऊपर लादे हुए किसी निर्जन देश में उठा ले जाएगा; इसलिए वह मनुष्य उस बकरे को जंगल में छोड़ दे। ");
INSERT INTO hin2017_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“तब हारून मिलापवाले तम्बू में आए, और जिस सनी के वस्त्रों को पहने हुए उसने अति पवित्रस्थान में प्रवेश किया था उन्हें उतारकर वहीं पर रख दे। ");
INSERT INTO hin2017_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","फिर वह किसी पवित्रस्थान में जल से स्नान कर अपने निज वस्त्र पहन ले, और बाहर जाकर अपने होमबलि और साधारण जनता के होमबलि को चढ़ाकर अपने और जनता के लिये प्रायश्चित करे। ");
INSERT INTO hin2017_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","और पापबलि की चर्बी को वह वेदी पर जलाए। ");
INSERT INTO hin2017_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","और जो मनुष्य बकरे को अजाजेल के लिये छोड़कर आए वह भी अपने वस्त्रों को धोए, और जल से स्नान करे, और तब वह छावनी में प्रवेश करे। ");
INSERT INTO hin2017_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","और पापबलि का बछड़ा और पापबलि का बकरा भी जिनका लहू पवित्रस्थान में प्रायश्चित करने के लिये पहुँचाया जाए वे दोनों छावनी से बाहर पहुँचाए जाएँ; और उनका चमड़ा, माँस, और गोबर आग में जला दिया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","और जो उनको जलाए वह अपने वस्त्रों को धोए, और जल से स्नान करे, और इसके बाद वह छावनी में प्रवेश करने पाए। ");
INSERT INTO hin2017_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“तुम लोगों के लिये यह सदा की विधि होगी कि सातवें महीने के दसवें दिन को तुम उपवास करना, और उस दिन कोई, चाहे वह तुम्हारे निज देश का हो चाहे तुम्हारे बीच रहनेवाला कोई परदेशी हो, कोई भी किसी प्रकार का काम-काज न करे; ");
INSERT INTO hin2017_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","क्योंकि उस दिन तुम्हें शुद्ध करने के लिये तुम्हारे निमित्त प्रायश्चित किया जाएगा; और तुम अपने सब पापों से यहोवा के सम्मुख पवित्र ठहरोगे। ");
INSERT INTO hin2017_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","यह तुम्हारे लिये परमविश्राम का दिन ठहरे, और तुम उस दिन उपवास करना और किसी प्रकार का काम-काज न करना; यह सदा की विधि है। ");
INSERT INTO hin2017_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","और जिसका अपने पिता के स्थान पर याजकपद के लिये अभिषेक और संस्कार किया जाए वह याजक प्रायश्चित किया करे, अर्थात् वह सनी के पवित्र वस्त्रों को पहनकर, ");
INSERT INTO hin2017_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","पवित्रस्थान, और मिलापवाले तम्बू, और वेदी के लिये प्रायश्चित करे; और याजकों के और मण्डली के सब लोगों के लिये भी प्रायश्चित करे। ");
INSERT INTO hin2017_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","और यह तुम्हारे लिये सदा की विधि होगी, कि इस्राएलियों के लिये प्रतिवर्ष एक बार तुम्हारे सारे पापों के लिये प्रायश्चित किया जाए।” यहोवा की इस आज्ञा के अनुसार जो उसने मूसा को दी थी, हारून ने किया। ");
INSERT INTO hin2017_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“हारून और उसके पुत्रों से और सब इस्राएलियों से कह कि यहोवा ने यह आज्ञा दी है: ");
INSERT INTO hin2017_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","इस्राएल के घराने में से कोई मनुष्य हो जो बैल या भेड़ के बच्चे, या बकरी को, चाहे छावनी में चाहे छावनी से बाहर घात करके ");
INSERT INTO hin2017_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","मिलापवाले तम्बू के द्वार पर, यहोवा के निवास के सामने यहोवा को चढ़ाने के निमित्त न ले जाए, तो उस मनुष्य को लहू बहाने का दोष लगेगा; और वह मनुष्य जो लहू बहानेवाला ठहरेगा, वह अपने लोगों के बीच से नष्ट किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","इस विधि का यह कारण है कि इस्राएली अपने बलिदान जिनको वे खुले मैदान में वध करते हैं, वे उन्हें मिलापवाले तम्बू के द्वार पर याजक के पास, यहोवा के लिये ले जाकर उसी के लिये मेलबलि करके बलिदान किया करें; ");
INSERT INTO hin2017_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","और याजक लहू को मिलापवाले तम्बू के द्वार पर यहोवा की वेदी के ऊपर छिड़के, और चर्बी को उसके सुखदायक सुगन्ध के लिये जलाए। ");
INSERT INTO hin2017_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","वे जो बकरों के पूजक होकर व्यभिचार करते हैं, वे फिर अपने बलिपशुओं को उनके लिये बलिदान न करें। तुम्हारी पीढ़ियों के लिये यह सदा की विधि होगी। ");
INSERT INTO hin2017_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“तू उनसे कह कि इस्राएल के घराने के लोगों में से या उनके बीच रहनेवाले परदेशियों में से कोई मनुष्य क्यों न हो जो होमबलि या मेलबलि चढ़ाए, ");
INSERT INTO hin2017_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","और उसको मिलापवाले तम्बू के द्वार पर यहोवा के लिये चढ़ाने को न ले आए; वह मनुष्य अपने लोगों में से नष्ट किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“फिर इस्राएल के घराने के लोगों में से या उनके बीच रहनेवाले परदेशियों में से कोई मनुष्य क्यों न हो जो किसी प्रकार का लहू खाए, मैं उस लहू खानेवाले के विमुख होकर उसको उसके लोगों के बीच में से नष्ट कर डालूँगा। ");
INSERT INTO hin2017_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","क्योंकि शरीर का प्राण लहू में रहता है; और उसको मैंने तुम लोगों को वेदी पर चढ़ाने के लिये दिया है कि तुम्हारे प्राणों के लिये प्रायश्चित किया जाए; क्योंकि प्राण के लिए लहू ही से प्रायश्चित होता है। (इब्रा. 9:22) ");
INSERT INTO hin2017_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","इस कारण मैं इस्राएलियों से कहता हूँ कि तुम में से कोई प्राणी लहू न खाए, और जो परदेशी तुम्हारे बीच रहता हो वह भी लहू कभी न खाए।” ");
INSERT INTO hin2017_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“इस्राएलियों में से या उनके बीच रहनेवाले परदेशियों में से, कोई मनुष्य क्यों न हो, जो शिकार करके खाने के योग्य पशु या पक्षी को पकड़े, वह उसके लहू को उण्डेलकर धूलि से ढाँप दे। ");
INSERT INTO hin2017_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","क्योंकि शरीर का प्राण जो है वह उसका लहू ही है जो उसके प्राण के साथ एक है; इसलिए मैं इस्राएलियों से कहता हूँ कि किसी प्रकार के प्राणी के लहू को तुम न खाना, क्योंकि सब प्राणियों का प्राण उनका लहू ही है; जो कोई उसको खाए वह नष्ट किया जाएगा। (प्रेरि. 15:20-29) ");
INSERT INTO hin2017_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","और चाहे वह देशी हो या परदेशी हो, जो कोई किसी लोथ या फाड़े हुए पशु का माँस खाए वह अपने वस्त्रों को धोकर जल से स्नान करे, और साँझ तक अशुद्ध रहे; तब वह शुद्ध होगा। ");
INSERT INTO hin2017_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","परन्तु यदि वह उनको न धोए और न स्नान करे, तो उसको अपने अधर्म का भार स्वयं उठाना पड़ेगा।” ");
INSERT INTO hin2017_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“इस्राएलियों से कह कि मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","तुम मिस्र देश के कामों के अनुसार, जिसमें तुम रहते थे, न करना; और कनान देश के कामों के अनुसार भी, जहाँ मैं तुम्हें ले चलता हूँ, न करना; और न उन देशों की विधियों पर चलना। ");
INSERT INTO hin2017_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","मेरे ही नियमों को मानना, और मेरी ही विधियों को मानते हुए उन पर चलना। मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","इसलिए तुम मेरे नियमों और मेरी विधियों को निरन्तर मानना; जो मनुष्य उनको माने वह उनके कारण जीवित रहेगा। मैं यहोवा हूँ। (मत्ती 19:17, लूका 10:28, रोम. 7:10, रोम. 10:5, गला. 3:12) ");
INSERT INTO hin2017_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“तुम में से कोई अपनी किसी निकट कुटुम्बिनी का तन उघाड़ने को उसके पास न जाए। मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","अपनी माता का तन, जो तुम्हारे पिता का तन है, न उघाड़ना; वह तो तुम्हारी माता है, इसलिए तुम उसका तन न उघाड़ना। ");
INSERT INTO hin2017_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","अपनी सौतेली माता का भी तन न उघाड़ना; वह तो तुम्हारे पिता ही का तन है। (1 कुरि. 5:1) ");
INSERT INTO hin2017_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","अपनी बहन चाहे सगी हो चाहे सौतेली हो, चाहे वह घर में उत्पन्न हुई हो चाहे बाहर, उसका तन न उघाड़ना। ");
INSERT INTO hin2017_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","अपनी पोती या अपनी नातिन का तन न उघाड़ना, उनकी देह तो मानो तुम्हारी ही है। ");
INSERT INTO hin2017_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","तुम्हारी सोतेली बहन जो तुम्हारे पिता से उत्पन्न हुई, वह तुम्हारी बहन है, इस कारण उसका तन न उघाड़ना। ");
INSERT INTO hin2017_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","अपनी फूफी का तन न उघाड़ना; वह तो तुम्हारे पिता की निकट कुटुम्बिनी है। ");
INSERT INTO hin2017_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","अपनी मौसी का तन न उघाड़ना; क्योंकि वह तुम्हारी माता की निकट कुटुम्बिनी है। ");
INSERT INTO hin2017_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","अपने चाचा का तन न उघाड़ना, अर्थात् उसकी स्त्री के पास न जाना; वह तो तुम्हारी चाची है। ");
INSERT INTO hin2017_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","अपनी बहू का तन न उघाड़ना वह तो तुम्हारे बेटे की स्त्री है, इस कारण तुम उसका तन न उघाड़ना। ");
INSERT INTO hin2017_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","अपनी भाभी का तन न उघाड़ना; वह तो तुम्हारे भाई ही का तन है। (मत्ती 14:3, 4, मर. 6:18) ");
INSERT INTO hin2017_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","किसी स्त्री और उसकी बेटी दोनों का तन न उघाड़ना, और उसकी पोती को या उसकी नातिन को अपनी स्त्री करके उसका तन न उघाड़ना; वे तो निकट कुटुम्बिनी है; ऐसा करना महापाप है। ");
INSERT INTO hin2017_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","और अपनी स्त्री की बहन को भी अपनी स्त्री करके उसकी सौत न करना कि पहली के जीवित रहते हुए उसका तन भी उघाड़े। ");
INSERT INTO hin2017_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“फिर जब तक कोई स्त्री अपने ऋतु के कारण अशुद्ध रहे तब तक उसके पास उसका तन उघाड़ने को न जाना। ");
INSERT INTO hin2017_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","फिर अपने भाई-बन्धु की स्त्री से कुकर्म करके अशुद्ध न हो जाना। ");
INSERT INTO hin2017_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","अपनी सन्तान में से किसी को मोलेक के लिये होम करके न चढ़ाना, और न अपने परमेश्वर के नाम को अपवित्र ठहराना; मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","स्त्रीगमन की रीति पुरुषगमन न करना; वह तो घिनौना काम है। (रोम. 1:27) ");
INSERT INTO hin2017_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","किसी जाति के पशु के साथ पशुगमन करके अशुद्ध न हो जाना, और न कोई स्त्री पशु के सामने इसलिए खड़ी हो कि उसके संग कुकर्म करे; यह तो उलटी बात है। ");
INSERT INTO hin2017_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ऐसा-ऐसा कोई भी काम करके अशुद्ध न हो जाना, क्योंकि जिन जातियों को मैं तुम्हारे आगे से निकालने पर हूँ वे ऐसे-ऐसे काम करके अशुद्ध हो गई हैं; ");
INSERT INTO hin2017_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","और उनका देश भी अशुद्ध हो गया है, इस कारण मैं उस पर उसके अधर्म का दण्ड देता हूँ, और वह देश अपने निवासियों को उगल देता है। ");
INSERT INTO hin2017_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","इस कारण तुम लोग मेरी विधियों और नियमों को निरन्तर मानना, और चाहे देशी, चाहे तुम्हारे बीच रहनेवाला परदेशी हो, तुम में से कोई भी ऐसा घिनौना काम न करे; ");
INSERT INTO hin2017_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","क्योंकि ऐसे सब घिनौने कामों को उस देश के मनुष्य जो तुम से पहले उसमें रहते थे, वे करते आए हैं, इसी से वह देश अशुद्ध हो गया है। ");
INSERT INTO hin2017_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","अब ऐसा न हो कि जिस रीति से जो जाति तुम से पहले उस देश में रहती थी, उसको उसने उगल दिया, उसी रीति जब तुम उसको अशुद्ध करो, तो वह तुम को भी उगल दे। ");
INSERT INTO hin2017_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","जितने ऐसा कोई घिनौना काम करें वे सब प्राणी अपने लोगों में से नष्ट किए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","यह आज्ञा जो मैंने तुम्हारे मानने को दी है, उसे तुम मानना, और जो घिनौनी रीतियाँ तुम से पहले प्रचलित हैं, उनमें से किसी पर न चलना, और न उनके कारण अशुद्ध हो जाना। मैं तुम्हारा परमेश्वर यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“इस्राएलियों की सारी मण्डली से कह कि तुम पवित्र बने रहो; क्योंकि मैं तुम्हारा परमेश्वर यहोवा पवित्र हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","तुम अपनी-अपनी माता और अपने-अपने पिता का भय मानना, और मेरे विश्रामदिनों को मानना: मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","तुम मूरतों की ओर न फिरना, और देवताओं की प्रतिमाएँ ढालकर न बना लेना; मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“जब तुम यहोवा के लिये मेलबलि करो, तब ऐसा बलिदान करना जिससे मैं तुम से प्रसन्न हो जाऊँ। ");
INSERT INTO hin2017_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","उसका माँस बलिदान के दिन और दूसरे दिन खाया जाए, परन्तु तीसरे दिन तक जो रह जाए वह आग में जला दिया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","यदि उसमें से कुछ भी तीसरे दिन खाया जाए, तो यह घृणित ठहरेगा, और ग्रहण न किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","और उसका खानेवाला यहोवा के पवित्र पदार्थ को अपवित्र ठहराता है, इसलिए उसको अपने अधर्म का भार स्वयं उठाना पड़ेगा; और वह प्राणी अपने लोगों में से नष्ट किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“फिर जब तुम अपने देश के खेत काटो, तब अपने खेत के कोने-कोने तक पूरा न काटना, और काटे हुए खेत की गिरी पड़ी बालों को न चुनना। ");
INSERT INTO hin2017_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","और अपनी दाख की बारी का दाना-दाना न तोड़ लेना, और अपनी दाख की बारी के झड़े हुए अंगूरों को न बटोरना; उन्हें दीन और परदेशी लोगों के लिये छोड़ देना; मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“तुम चोरी न करना, और एक दूसरे से, न तो कपट करना, और न झूठ बोलना। ");
INSERT INTO hin2017_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","तुम मेरे नाम की झूठी शपथ खाके अपने परमेश्वर का नाम अपवित्र न ठहराना; मैं यहोवा हूँ। (मत्ती 5:33) ");
INSERT INTO hin2017_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“एक दूसरे पर अंधेर न करना, और न एक दूसरे को लूट लेना। मजदूर की मजदूरी तेरे पास सारी रात सवेरे तक न रहने पाए। (मत्ती 20:8, 1 तीमु. 5:18, याकू. 5:4) ");
INSERT INTO hin2017_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","बहरे को श्राप न देना, और न अंधे के आगे ठोकर रखना; और अपने परमेश्वर का भय मानना; मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“न्याय में कुटिलता न करना; और न तो कंगाल का पक्ष करना और न बड़े मनुष्यों का मुँह देखा विचार करना; एक दूसरे का न्याय धार्मिकता से करना। ");
INSERT INTO hin2017_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","बकवादी बनके अपने लोगों में न फिरा करना, और एक दूसरे का लहू बहाने की युक्तियाँ न बाँधना; मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“अपने मन में एक दूसरे के प्रति बैर न रखना; अपने पड़ोसी को अवश्य डाँटना, नहीं तो उसके पाप का भार तुझको उठाना पड़ेगा। (मत्ती 18:15) ");
INSERT INTO hin2017_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","बदला न लेना, और न अपने जातिभाइयों से बैर रखना, परन्तु एक दूसरे से अपने समान प्रेम रखना; मैं यहोवा हूँ। (मत्ती 5:43, मत्ती 19:19, मत्ती 22:39, मर. 12:31,33, लूका 10:27, रोम. 12:19, रोम. 13:9, गला. 5:14, याकू. 2:8) ");
INSERT INTO hin2017_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“तुम मेरी विधियों को निरन्तर मानना। अपने पशुओं को भिन्न जाति के पशुओं से मेल न खाने देना; अपने खेत में दो प्रकार के बीज इकट्ठे न बोना; और सनी और ऊन की मिलावट से बना हुआ वस्त्र न पहनना। ");
INSERT INTO hin2017_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“फिर कोई स्त्री दासी हो, और उसकी मंगनी किसी पुरुष से हुई हो, परन्तु वह न तो दास से और न सेंत-मेंत स्वाधीन की गई हो; उससे यदि कोई कुकर्म करे, तो उन दोनों को दण्ड तो मिले, पर उस स्त्री के स्वाधीन न होने के कारण वे दोनों मार न डाले जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","पर वह पुरुष मिलापवाले तम्बू के द्वार पर यहोवा के पास एक मेढ़ा दोषबलि के लिये ले आए। ");
INSERT INTO hin2017_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","और याजक उसके किए हुए पाप के कारण दोषबलि के मेढ़े के द्वारा उसके लिये यहोवा के सामने प्रायश्चित करे; तब उसका किया हुआ पाप क्षमा किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“फिर जब तुम कनान देश में पहुँचकर किसी प्रकार के फल के वृक्ष लगाओ, तो उनके फल तीन वर्ष तक तुम्हारे लिये मानो खतनारहित ठहरे रहें; इसलिए उनमें से कुछ न खाया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","और चौथे वर्ष में उनके सब फल यहोवा की स्तुति करने के लिये पवित्र ठहरें। ");
INSERT INTO hin2017_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","तब पाँचवें वर्ष में तुम उनके फल खाना, इसलिए कि उनसे तुम को बहुत फल मिलें; मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“तुम लहू लगा हुआ कुछ माँस न खाना। और न टोना करना, और न शुभ या अशुभ मुहूर्त्तों को मानना। ");
INSERT INTO hin2017_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","अपने सिर में घेरा रखकर न मुण्डाना, और न अपने गाल के बालों को मुण्डाना। ");
INSERT INTO hin2017_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","मुर्दों के कारण अपने शरीर को बिलकुल न चीरना, और न उसमें छाप लगाना; मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“अपनी बेटियों को वेश्या बनाकर अपवित्र न करना, ऐसा न हो कि देश वेश्‍यागमन के कारण महापाप से भर जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","मेरे विश्रामदिन को माना करना, और मेरे पवित्रस्थान का भय निरन्तर मानना; मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ओझाओं और भूत साधनेवालों की ओर न फिरना, और ऐसों की खोज करके उनके कारण अशुद्ध न हो जाना; मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“पक्के बाल वाले के सामने उठ खड़े होना, और बूढ़े का आदरमान करना, और अपने परमेश्वर का भय निरन्तर मानना; मैं यहोवा हूँ। (1 तीमु. 5:1) ");
INSERT INTO hin2017_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“यदि कोई परदेशी तुम्हारे देश में तुम्हारे संग रहे, तो उसको दुःख न देना। ");
INSERT INTO hin2017_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","जो परदेशी तुम्हारे संग रहे वह तुम्हारे लिये देशी के समान हो, और उससे अपने ही समान प्रेम रखना; क्योंकि तुम भी मिस्र देश में परदेशी थे; मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“तुम न्याय में, और परिमाण में, और तौल में, और नाप में, कुटिलता न करना। ");
INSERT INTO hin2017_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","सच्चा तराजू, धर्म के बटखरे, सच्चा एपा, और धर्म का हीन तुम्हारे पास रहें; मैं तुम्हारा परमेश्वर यहोवा हूँ जो तुम को मिस्र देश से निकाल ले आया। ");
INSERT INTO hin2017_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","इसलिए तुम मेरी सब विधियों और सब नियमों को मानते हुए निरन्तर पालन करो; मैं यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“इस्राएलियों से कह कि इस्राएलियों में से, या इस्राएलियों के बीच रहनेवाले परदेशियों में से, कोई क्यों न हो, जो अपनी कोई सन्तान मोलेक को बलिदान करे वह निश्चय मार डाला जाए; और जनता उसको पथरवाह करे। ");
INSERT INTO hin2017_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","मैं भी उस मनुष्य के विरुद्ध होकर, उसको उसके लोगों में से इस कारण नाश करूँगा, कि उसने अपनी सन्तान मोलेक को देकर मेरे पवित्रस्थान को अशुद्ध किया, और मेरे पवित्र नाम को अपवित्र ठहराया। ");
INSERT INTO hin2017_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","और यदि कोई अपनी सन्तान मोलेक को बलिदान करे, और जनता उसके विषय में आनाकानी करे, और उसको मार न डाले, ");
INSERT INTO hin2017_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","तब तो मैं स्वयं उस मनुष्य और उसके घराने के विरुद्ध होकर उसको और जितने उसके पीछे होकर मोलेक के साथ व्यभिचार करें उन सभी को भी उनके लोगों के बीच में से नाश करूँगा। ");
INSERT INTO hin2017_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“फिर जो मनुष्य ओझाओं या भूत साधनेवालों की ओर फिरके, और उनके पीछे होकर व्यभिचारी बने, तब मैं उस मनुष्य के विरुद्ध होकर उसको उसके लोगों के बीच में से नाश कर दूँगा। ");
INSERT INTO hin2017_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","इसलिए तुम अपने आपको पवित्र करो; और पवित्र बने रहो; क्योंकि मैं तुम्हारा परमेश्वर यहोवा हूँ। (1 पत. 1:16) ");
INSERT INTO hin2017_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","और तुम मेरी विधियों को मानना, और उनका पालन भी करना; क्योंकि मैं तुम्हारा पवित्र करनेवाला यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“कोई क्यों न हो, जो अपने पिता या माता को श्राप दे वह निश्चय मार डाला जाए; उसने अपने पिता या माता को श्राप दिया है, इस कारण उसका खून उसी के सिर पर पड़ेगा। (मत्ती 15:4, मर. 7:10) ");
INSERT INTO hin2017_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","फिर यदि कोई पराई स्त्री के साथ व्यभिचार करे, तो जिसने किसी दूसरे की स्त्री के साथ व्यभिचार किया हो तो वह व्यभिचारी और वह व्यभिचारिणी दोनों निश्चय मार डालें जाएँ। (यूह. 8:5) ");
INSERT INTO hin2017_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","यदि कोई अपनी सौतेली माता के साथ सोए, वह अपने पिता ही का तन उघाड़नेवाला ठहरेगा; इसलिए वे दोनों निश्चय मार डाले जाएँ, उनका खून उन्हीं के सिर पर पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","यदि कोई अपनी बहू के साथ सोए, तो वे दोनों निश्चय मार डाले जाएँ; क्योंकि वे उलटा काम करनेवाले ठहरेंगे, और उनका खून उन्हीं के सिर पर पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","यदि कोई जिस रीति स्त्री से उसी रीति पुरुष से प्रसंग करे, तो वे दोनों घिनौना काम करनेवाले ठहरेंगे; इस कारण वे निश्चय मार डाले जाएँ, उनका खून उन्हीं के सिर पर पड़ेगा। (रोम. 1:27) ");
INSERT INTO hin2017_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","यदि कोई अपनी पत्नी और अपनी सास दोनों को रखे, तो यह महापाप है; इसलिए वह पुरुष और वे स्त्रियाँ तीनों के तीनों आग में जलाए जाएँ, जिससे तुम्हारे बीच महापाप न हो। ");
INSERT INTO hin2017_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","फिर यदि कोई पुरुष पशुगामी हो, तो पुरुष और पशु दोनों निश्चय मार डाले जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","यदि कोई स्त्री पशु के पास जाकर उसके संग कुकर्म करे, तो तू उस स्त्री और पशु दोनों को घात करना; वे निश्चय मार डाले जाएँ, उनका खून उन्हीं के सिर पर पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“यदि कोई अपनी बहन का, चाहे उसकी सगी बहन हो चाहे सौतेली, उसका नग्‍न तन देखे, और उसकी बहन भी उसका नग्‍न तन देखे तो यह निन्दित बात है, वे दोनों अपने जातिभाइयों की आँखों के सामने नाश किए जाएँ; क्योंकि जो अपनी बहन का तन उघाड़नेवाला ठहरेगा उसे अपने अधर्म का भार स्वयं उठाना पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","फिर यदि कोई पुरुष किसी ऋतुमती स्त्री के संग सोकर उसका तन उघाड़े, तो वह पुरुष उसके रूधिर के सोते का उघाड़नेवाला ठहरेगा, और वह स्त्री अपने रूधिर के सोते की उघाड़नेवाली ठहरेगी; इस कारण वे दोनों अपने लोगों के बीच में से नाश किए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","अपनी मौसी या फूफी का तन न उघाड़ना, क्योंकि जो उसे उघाड़े वह अपनी निकट कुटुम्बिनी को नंगा करता है; इसलिए इन दोनों को अपने अधर्म का भार उठाना पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","यदि कोई अपनी चाची के संग सोए, तो वह अपने चाचा का तन उघाड़नेवाला ठहरेगा; इसलिए वे दोनों अपने पाप के भार को उठाए हुए निर्वंश मर जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","यदि कोई अपनी भाभी को अपनी पत्नी बनाए, तो इसे घिनौना काम जानना; और वह अपने भाई का तन उघाड़नेवाला ठहरेगा, इस कारण वे दोनों निःसन्तान रहेंगे। (मत्ती 14:3,4) ");
INSERT INTO hin2017_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“तुम मेरी सब विधियों और मेरे सब नियमों को समझ के साथ मानना; जिससे यह न हो कि जिस देश में मैं तुम्हें लिये जा रहा हूँ वह तुम को उगल दे। ");
INSERT INTO hin2017_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","और जिस जाति के लोगों को मैं तुम्हारे आगे से निकालता हूँ उनकी रीति-रस्म पर न चलना; क्योंकि उन लोगों ने जो ये सब कुकर्म किए हैं, इसी कारण मुझे उनसे घृणा हो गई है। ");
INSERT INTO hin2017_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","पर मैं तुम लोगों से कहता हूँ कि तुम तो उनकी भूमि के अधिकारी होंगे, और मैं इस देश को जिसमें दूध और मधु की धाराएँ बहती हैं तुम्हारे अधिकार में कर दूँगा; मैं तुम्हारा परमेश्वर यहोवा हूँ जिसने तुम को अन्य देशों के लोगों से अलग किया है। ");
INSERT INTO hin2017_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","इस कारण तुम शुद्ध और अशुद्ध पशुओं में, और शुद्ध और अशुद्ध पक्षियों में भेद करना; और कोई पशु या पक्षी या किसी प्रकार का भूमि पर रेंगनेवाला जीवजन्तु क्यों न हो, जिसको मैंने तुम्हारे लिये अशुद्ध ठहराकर वर्जित किया है, उससे अपने आपको अशुद्ध न करना। ");
INSERT INTO hin2017_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","तुम मेरे लिये पवित्र बने रहना; क्योंकि मैं यहोवा स्वयं पवित्र हूँ, और मैंने तुम को और देशों के लोगों से इसलिए अलग किया है कि तुम निरन्तर मेरे ही बने रहो। ");
INSERT INTO hin2017_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“यदि कोई पुरुष या स्त्री ओझाई या भूत की साधना करे, तो वह निश्चय मार डाला जाए; ऐसों पर पथराव किया जाए, उनका खून उन्हीं के सिर पर पड़ेगा।” ");
INSERT INTO hin2017_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","फिर यहोवा ने मूसा से कहा, “हारून के पुत्र जो याजक हैं उनसे कह कि तुम्हारे लोगों में से कोई भी मरे, तो उसके कारण तुम में से कोई अपने को अशुद्ध न करे; ");
INSERT INTO hin2017_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","अपने निकट कुटुम्बियों, अर्थात् अपनी माता, या पिता, या बेटे, या बेटी, या भाई के लिये, ");
INSERT INTO hin2017_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","या अपनी कुँवारी बहन जिसका विवाह न हुआ हो, जिनका निकट का सम्बंध है; उनके लिये वह अपने को अशुद्ध कर सकता है। ");
INSERT INTO hin2017_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","पर याजक होने के नाते से वह अपने लोगों में प्रधान है, इसलिए वह अपने को ऐसा अशुद्ध न करे कि अपवित्र हो जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","वे न तो अपने सिर मुँड़ाएँ, और न अपने गाल के बालों को मुँड़ाएँ, और न अपने शरीर चीरें। ");
INSERT INTO hin2017_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","वे अपने परमेश्वर के लिये पवित्र बने रहें, और अपने परमेश्वर का नाम अपवित्र न करें; क्योंकि वे यहोवा के हव्य को जो उनके परमेश्वर का भोजन है चढ़ाया करते हैं; इस कारण वे पवित्र बने रहें। ");
INSERT INTO hin2017_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","वे वेश्या या भ्रष्टा को ब्याह न लें; और न त्यागी हुई को ब्याह लें; क्योंकि याजक अपने परमेश्वर के लिये पवित्र होता है। (यहे. 44:22) ");
INSERT INTO hin2017_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","इसलिए तू याजक को पवित्र जानना, क्योंकि वह तुम्हारे परमेश्वर का भोजन चढ़ाया करता है; इसलिए वह तेरी दृष्टि में पवित्र ठहरे; क्योंकि मैं यहोवा, जो तुम को पवित्र करता हूँ, पवित्र हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","और यदि याजक की बेटी वेश्या बनकर अपने आपको अपवित्र करे, तो वह अपने पिता को अपवित्र ठहराती है; वह आग में जलाई जाए। (प्रका. 17:16, प्रका. 18:8) ");
INSERT INTO hin2017_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“जो अपने भाइयों में महायाजक हो, जिसके सिर पर अभिषेक का तेल डाला गया हो, और जिसका पवित्र वस्त्रों को पहनने के लिये संस्कार हुआ हो, वह अपने सिर के बाल बिखरने न दे, और न अपने वस्त्र फाड़े; ");
INSERT INTO hin2017_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","और न वह किसी लोथ के पास जाए, और न अपने पिता या माता के कारण अपने को अशुद्ध करे; ");
INSERT INTO hin2017_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","और वह पवित्रस्थान से बाहर भी न निकले, और न अपने परमेश्वर के पवित्रस्थान को अपवित्र ठहराए; क्योंकि वह अपने परमेश्वर के अभिषेक का तेलरूपी मुकुट धारण किए हुए है; मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","और वह कुँवारी स्त्री को ब्याहे। ");
INSERT INTO hin2017_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","जो विधवा, या त्यागी हुई, या भ्रष्ट, या वेश्या हो, ऐसी किसी से वह विवाह न करे, वह अपने ही लोगों के बीच में की किसी कुँवारी कन्या से विवाह करे। ");
INSERT INTO hin2017_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","और वह अपनी सन्तान को अपने लोगों में अपवित्र न करे; क्योंकि मैं उसका पवित्र करनेवाला यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“हारून से कह कि तेरे वंश की पीढ़ी-पीढ़ी में जिस किसी के कोई भी शारीरिक दोष हो वह अपने परमेश्वर का भोजन चढ़ाने के लिये समीप न आए। ");
INSERT INTO hin2017_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","कोई क्यों न हो, जिसमें दोष हो, वह समीप न आए, चाहे वह अंधा हो, चाहे लँगड़ा, चाहे नकचपटा हो, चाहे उसके कुछ अधिक अंग हों, (लैव्य. 22:19-25, लैव्य. 22:23) ");
INSERT INTO hin2017_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","या उसका पाँव, या हाथ टूटा हो, ");
INSERT INTO hin2017_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","या वह कुबड़ा, या बौना हो, या उसकी आँख में दोष हो, या उस मनुष्य के चाईं या खुजली हो, या उसके अण्ड पिचके हों; ");
INSERT INTO hin2017_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","हारून याजक के वंश में से जिस किसी में कोई भी शारीरिक दोष हो, वह यहोवा के हव्य चढ़ाने के लिये समीप न आए; वह जो दोषयुक्त है कभी भी अपने परमेश्वर का भोजन चढ़ाने के लिये समीप न आए। ");
INSERT INTO hin2017_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","वह अपने परमेश्वर के पवित्र और परमपवित्र दोनों प्रकार के भोजन को खाए, ");
INSERT INTO hin2017_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","परन्तु उसके दोष के कारण वह न तो बीचवाले पर्दे के भीतर आए और न वेदी के समीप, जिससे ऐसा न हो कि वह मेरे पवित्रस्थानों को अपवित्र करे; क्योंकि मैं उनका पवित्र करनेवाला यहोवा हूँ।” (लैव्य. 16:2, लैव्य. 21:12) ");
INSERT INTO hin2017_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","इसलिए मूसा ने हारून और उसके पुत्रों को तथा सब इस्राएलियों को यह बातें कह सुनाईं। ");
INSERT INTO hin2017_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“हारून और उसके पुत्रों से कह कि इस्राएलियों की पवित्र की हुई वस्तुओं से जिनको वे मेरे लिये पवित्र करते हैं अलग रहें, और मेरे पवित्र नाम को अपवित्र न करें; मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","और उनसे कह कि तुम्हारी पीढ़ी-पीढ़ी में तुम्हारे सारे वंश में से जो कोई अपनी अशुद्धता की दशा में उन पवित्र की हुई वस्तुओं के पास जाए, जिन्हें इस्राएली यहोवा के लिये पवित्र करते हैं, वह मनुष्य मेरे सामने से नाश किया जाएगा; मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","हारून के वंश में से कोई क्यों न हो, जो कोढ़ी हो, या उसके प्रमेह हो, वह मनुष्य जब तक शुद्ध न हो जाए, तब तक पवित्र की हुई वस्तुओं में से कुछ न खाए। और जो लोथ के कारण अशुद्ध हुआ हो, या जिसका वीर्य स्खलित हुआ हो, ऐसे मनुष्य को जो कोई छूए, ");
INSERT INTO hin2017_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","और जो कोई किसी ऐसे रेंगनेवाले जन्तु को छूए जिससे लोग अशुद्ध हो सकते हैं, या किसी ऐसे मनुष्य को छूए जिसमें किसी प्रकार की अशुद्धता हो जो उसको भी लग सकती है। ");
INSERT INTO hin2017_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","तो वह याजक जो इनमें से किसी को छूए साँझ तक अशुद्ध ठहरा रहे, और जब तक जल से स्नान न कर ले, तब तक पवित्र वस्तुओं में से कुछ न खाए। ");
INSERT INTO hin2017_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","तब सूर्य अस्त होने पर वह शुद्ध ठहरेगा; और तब वह पवित्र वस्तुओं में से खा सकेगा, क्योंकि उसका भोजन वही है। ");
INSERT INTO hin2017_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","जो जानवर आप से मरा हो या पशु से फाड़ा गया हो उसे खाकर वह अपने आपको अशुद्ध न करे; मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","इसलिए याजक लोग मेरी सौंपी हुई वस्तुओं की रक्षा करें, ऐसा न हो कि वे उनको अपवित्र करके पाप का भार उठाए, और इसके कारण मर भी जाएँ; मैं उनका पवित्र करनेवाला यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“पराए कुल का जन, किसी पवित्र वस्तु को न खाने पाए, चाहे वह याजक का अतिथि हो या मजदूर हो, तो भी वह कोई पवित्र वस्तु न खाए। ");
INSERT INTO hin2017_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","यदि याजक किसी दास को रुपया देकर मोल ले, तो वह दास उसमें से खा सकता है; और जो याजक के घर में उत्पन्न हुए हों चाहे कुटुम्बी या दास, वे भी उसके भोजन में से खाएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","और यदि याजक की बेटी पराए कुल के किसी पुरुष से विवाह हो, तो वह भेंट की हुई पवित्र वस्तुओं में से न खाए। ");
INSERT INTO hin2017_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","यदि याजक की बेटी विधवा या त्यागी हुई हो, और उसकी सन्तान न हो, और वह अपनी बाल्यावस्था की रीति के अनुसार अपने पिता के घर में रहती हो, तो वह अपने पिता के भोजन में से खाए; पर पराए कुल का कोई उसमें से न खाने पाए। ");
INSERT INTO hin2017_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","और यदि कोई मनुष्य किसी पवित्र वस्तु में से कुछ भूल से खा जाए, तो वह उसका पाँचवाँ भाग बढ़ाकर उसे याजक को भर दे। ");
INSERT INTO hin2017_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","वे इस्राएलियों की पवित्र की हुई वस्तुओं को, जिन्हें वे यहोवा के लिये चढ़ाएँ, अपवित्र न करें। ");
INSERT INTO hin2017_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","वे उनको अपनी पवित्र वस्तुओं में से खिलाकर उनसे अपराध का दोष न उठवाएँ; मैं उनका पवित्र करनेवाला यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“हारून और उसके पुत्रों से और इस्राएलियों से समझाकर कह कि इस्राएल के घराने या इस्राएलियों में रहनेवाले परदेशियों में से कोई क्यों न हो, जो मन्नत या स्वेच्छाबलि करने के लिये यहोवा को कोई होमबलि चढ़ाए, ");
INSERT INTO hin2017_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","तो अपने निमित्त ग्रहणयोग्य ठहरने के लिये बैलों या भेड़ों या बकरियों में से निर्दोष नर चढ़ाया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","जिसमें कोई भी दोष हो उसे न चढ़ाना; क्योंकि वह तुम्हारे निमित्त ग्रहणयोग्य न ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","और जो कोई बैलों या भेड़-बकरियों में से विशेष वस्तु संकल्प करने के लिये या स्वेच्छाबलि के लिये यहोवा को मेलबलि चढ़ाए, तो ग्रहण होने के लिये अवश्य है कि वह निर्दोष हो, उसमें कोई भी दोष न हो। ");
INSERT INTO hin2017_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","जो अंधा या अंग का टूटा या लूला हो, अथवा उसमें रसौली या खौरा या खुजली हो, ऐसों को यहोवा के लिये न चढ़ाना, उनको वेदी पर यहोवा के लिये हव्य न चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","जिस किसी बैल या भेड़ या बकरे का कोई अंग अधिक या कम हो उसको स्वेच्छाबलि के लिये चढ़ा सकते हो, परन्तु मन्नत पूरी करने के लिये वह ग्रहण न होगा। ");
INSERT INTO hin2017_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","जिसके अण्ड दबे या कुचले या टूटे या कट गए हों उसको यहोवा के लिये न चढ़ाना, और अपने देश में भी ऐसा काम न करना। ");
INSERT INTO hin2017_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","फिर इनमें से किसी को तुम अपने परमेश्वर का भोजन जानकर किसी परदेशी से लेकर न चढ़ाओ; क्योंकि उनमें दोष और कलंक है, इसलिए वे तुम्हारे निमित्त ग्रहण न होंगे।” ");
INSERT INTO hin2017_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“जब बछड़ा या भेड़ या बकरी का बच्चा उत्पन्न हो, तो वह सात दिन तक अपनी माँ के साथ रहे; फिर आठवें दिन से आगे को वह यहोवा के हव्य चढ़ावे के लिये ग्रहणयोग्य ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","चाहे गाय, चाहे भेड़ी या बकरी हो, उसको और उसके बच्चे को एक ही दिन में बलि न करना। ");
INSERT INTO hin2017_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","और जब तुम यहोवा के लिये धन्यवाद का मेलबलि चढ़ाओ, तो उसे इसी प्रकार से करना जिससे वह ग्रहणयोग्य ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","वह उसी दिन खाया जाए, उसमें से कुछ भी सवेरे तक रहने न पाए; मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“इसलिए तुम मेरी आज्ञाओं को मानना और उनका पालन करना; मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","और मेरे पवित्र नाम को अपवित्र न ठहराना, क्योंकि मैं इस्राएलियों के बीच अवश्य ही पवित्र माना जाऊँगा; मैं तुम्हारा पवित्र करनेवाला यहोवा हूँ, ");
INSERT INTO hin2017_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","जो तुम को मिस्र देश से निकाल लाया है जिससे तुम्हारा परमेश्वर बना रहूँ; मैं यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“इस्राएलियों से कह कि यहोवा के पर्व जिनका तुम को पवित्र सभा एकत्रित करने के लिये नियत समय पर प्रचार करना होगा, मेरे वे पर्व ये हैं। ");
INSERT INTO hin2017_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“छः दिन काम-काज किया जाए, पर सातवाँ दिन परमविश्राम का और पवित्र सभा का दिन है; उसमें किसी प्रकार का काम-काज न किया जाए; वह तुम्हारे सब घरों में यहोवा का विश्रामदिन ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“फिर यहोवा के पर्व जिनमें से एक-एक के ठहराये हुए समय में तुम्हें पवित्र सभा करने के लिये प्रचार करना होगा वे ये हैं। ");
INSERT INTO hin2017_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","पहले महीने के चौदहवें दिन को साँझ के समय यहोवा का फसह हुआ करे। ");
INSERT INTO hin2017_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","और उसी महीने के पन्द्रहवें दिन को यहोवा के लिये अख़मीरी रोटी का पर्व हुआ करे; उसमें तुम सात दिन तक अख़मीरी रोटी खाया करना। ");
INSERT INTO hin2017_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","उनमें से पहले दिन तुम्हारी पवित्र सभा हो; और उस दिन परिश्रम का कोई काम न करना। ");
INSERT INTO hin2017_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","और सातों दिन तुम यहोवा को हव्य चढ़ाया करना; और सातवें दिन पवित्र सभा हो; उस दिन परिश्रम का कोई काम न करना।” ");
INSERT INTO hin2017_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इस्राएलियों से कह कि जब तुम उस देश में प्रवेश करो जिसे यहोवा तुम्हें देता है और उसमें के खेत काटो, तब अपने-अपने पके खेत की पहली उपज का पूला याजक के पास ले आया करना; ");
INSERT INTO hin2017_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","और वह उस पूले को यहोवा के सामने हिलाए कि वह तुम्हारे निमित्त ग्रहण किया जाए; वह उसे विश्रामदिन के अगले दिन हिलाए। ");
INSERT INTO hin2017_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","और जिस दिन तुम पूले को हिलवाओ उसी दिन एक वर्ष का निर्दोष भेड़ का बच्चा यहोवा के लिये होमबलि चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","और उसके साथ का अन्नबलि एपा के दो दसवें अंश तेल से सने हुए मैदे का हो वह सुखदायक सुगन्ध के लिये यहोवा का हव्य हो; और उसके साथ का अर्घ हीन भर की चौथाई दाखमधु हो। ");
INSERT INTO hin2017_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","और जब तक तुम इस चढ़ावे को अपने परमेश्वर के पास न ले जाओ, उस दिन तक नये खेत में से न तो रोटी खाना और न भूना हुआ अन्न और न हरी बालें; यह तुम्हारी पीढ़ी-पीढ़ी में तुम्हारे सारे घरानों में सदा की विधि ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“फिर उस विश्रामदिन के दूसरे दिन से, अर्थात् जिस दिन तुम हिलाई जानेवाली भेंट के पूले को लाओगे, उस दिन से पूरे सात विश्रामदिन गिन लेना; ");
INSERT INTO hin2017_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","सातवें विश्रामदिन के अगले दिन तक पचास दिन गिनना, और पचासवें दिन यहोवा के लिये नया अन्नबलि चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","तुम अपने घरों में से एपा के दो दसवें अंश मैदे की दो रोटियाँ हिलाने की भेंट के लिये ले आना; वे ख़मीर के साथ पकाई जाएँ, और यहोवा के लिये पहली उपज ठहरें। ");
INSERT INTO hin2017_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","और उस रोटी के संग एक-एक वर्ष के सात निर्दोष भेड़ के बच्चे, और एक बछड़ा, और दो मेढ़े चढ़ाना; वे अपने-अपने साथ के अन्नबलि और अर्घ समेत यहोवा के लिये होमबलि के समान चढ़ाए जाएँ, अर्थात् वे यहोवा के लिये सुखदायक सुगन्ध देनेवाला हव्य ठहरें। ");
INSERT INTO hin2017_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","फिर पापबलि के लिये एक बकरा, और मेलबलि के लिये एक-एक वर्ष के दो भेड़ के बच्चे चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","तब याजक उनको पहली उपज की रोटी समेत यहोवा के सामने हिलाने की भेंट के लिये हिलाए, और इन रोटियों के संग वे दो भेड़ के बच्चे भी हिलाए जाएँ; वे यहोवा के लिये पवित्र, और याजक का भाग ठहरें। ");
INSERT INTO hin2017_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","और तुम उस दिन यह प्रचार करना, कि आज हमारी एक पवित्र सभा होगी; और परिश्रम का कोई काम न करना; यह तुम्हारे सारे घरानों में तुम्हारी पीढ़ी-पीढ़ी में सदा की विधि ठहरे। (प्रेरि. 2:1, 1 कुरि. 16:8) ");
INSERT INTO hin2017_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“जब तुम अपने देश में के खेत काटो, तब अपने खेत के कोनों को पूरी रीति से न काटना, और खेत में गिरी हुई बालों को न इकट्ठा करना; उसे गरीब और परदेशी के लिये छोड़ देना; मैं तुम्हारा परमेश्वर यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इस्राएलियों से कह कि सातवें महीने के पहले दिन को तुम्हारे लिये परमविश्राम हो; उस दिन को स्मरण दिलाने के लिये नरसिंगे फूँके जाएँ, और एक पवित्र सभा इकट्ठी हो। ");
INSERT INTO hin2017_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","उस दिन तुम परिश्रम का कोई काम न करना, और यहोवा के लिये एक हव्य चढ़ाना।” ");
INSERT INTO hin2017_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“उसी सातवें महीने का दसवाँ दिन प्रायश्चित का दिन माना जाए; वह तुम्हारी पवित्र सभा का दिन होगा, और उसमें तुम उपवास करना और यहोवा का हव्य चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","उस दिन तुम किसी प्रकार का काम-काज न करना; क्योंकि वह प्रायश्चित का दिन नियुक्त किया गया है जिसमें तुम्हारे परमेश्वर यहोवा के सामने तुम्हारे लिये प्रायश्चित किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","इसलिए जो मनुष्य उस दिन उपवास न करे वह अपने लोगों में से नाश किया जाएगा। (प्रेरि. 3:23) ");
INSERT INTO hin2017_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","और जो मनुष्य उस दिन किसी प्रकार का काम-काज करे उस मनुष्य को मैं उसके लोगों के बीच में से नाश कर डालूँगा। ");
INSERT INTO hin2017_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","तुम किसी प्रकार का काम-काज न करना; यह तुम्हारी पीढ़ी-पीढ़ी में तुम्हारे घराने में सदा की विधि ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","वह दिन तुम्हारे लिये परमविश्राम का हो, उसमें तुम उपवास करना; और उस महीने के नवें दिन की साँझ से अगली साँझ तक अपना विश्रामदिन माना करना।” ");
INSERT INTO hin2017_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“इस्राएलियों से कह कि उसी सातवें महीने के पन्द्रहवें दिन से सात दिन तक यहोवा के लिये झोपड़ियों का पर्व रहा करे। (यूह. 7:2) ");
INSERT INTO hin2017_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","पहले दिन पवित्र सभा हो; उसमें परिश्रम का कोई काम न करना। ");
INSERT INTO hin2017_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","सातों दिन यहोवा के लिये हव्य चढ़ाया करना, फिर आठवें दिन तुम्हारी पवित्र सभा हो, और यहोवा के लिये हव्य चढ़ाना; वह महासभा का दिन है, और उसमें परिश्रम का कोई काम न करना। (यूह. 7:37) ");
INSERT INTO hin2017_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“यहोवा के नियत पर्व ये ही हैं, इनमें तुम यहोवा को हव्य चढ़ाना, अर्थात् होमबलि, अन्नबलि, मेलबलि, और अर्घ, प्रत्येक अपने-अपने नियत समय पर चढ़ाया जाए और पवित्र सभा का प्रचार करना। ");
INSERT INTO hin2017_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","इन सभी से अधिक यहोवा के विश्रामदिनों को मानना, और अपनी भेंटों, और सब मन्नतों, और स्वेच्छाबलियों को जो यहोवा को अर्पण करोगे चढ़ाया करना। ");
INSERT INTO hin2017_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“फिर सातवें महीने के पन्द्रहवें दिन को, जब तुम देश की उपज को इकट्ठा कर चुको, तब सात दिन तक यहोवा का पर्व मानना; पहले दिन परमविश्राम हो, और आठवें दिन परमविश्राम हो। ");
INSERT INTO hin2017_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","और पहले दिन तुम अच्छे-अच्छे वृक्षों की उपज, और खजूर के पत्ते, और घने वृक्षों की डालियाँ, और नदी में के मजनू को लेकर अपने परमेश्वर यहोवा के सामने सात दिन तक आनन्द करना। ");
INSERT INTO hin2017_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","प्रतिवर्ष सात दिन तक यहोवा के लिये पर्व माना करना; यह तुम्हारी पीढ़ी-पीढ़ी में सदा की विधि ठहरे, कि सातवें महीने में यह पर्व माना जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","सात दिन तक तुम झोपड़ियों में रहा करना, अर्थात् जितने जन्म के इस्राएली हैं वे सब के सब झोपड़ियों में रहें, ");
INSERT INTO hin2017_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","“इसलिए कि तुम्हारी पीढ़ी-पीढ़ी के लोग जान रखें, कि जब यहोवा हम इस्राएलियों को मिस्र देश से निकालकर ला रहा था तब उसने उनको झोपड़ियों में टिकाया था; मैं तुम्हारा परमेश्वर यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","और मूसा ने इस्राएलियों को यहोवा के पर्व के नियत समय कह सुनाए। ");
INSERT INTO hin2017_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“इस्राएलियों को यह आज्ञा दे कि मेरे पास उजियाला देने के लिये कूट के निकाला हुआ जैतून का निर्मल तेल ले आना, कि दीपक नित्य जलता रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","हारून उसको, मिलापवाले तम्बू में, साक्षीपत्र के बीचवाले पर्दे से बाहर, यहोवा के सामने नित्य साँझ से भोर तक सजा कर रखे; यह तुम्हारी पीढ़ी-पीढ़ी के लिये सदा की विधि ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","वह दीपकों को सोने की दीवट पर यहोवा के सामने नित्य सजाया करे। ");
INSERT INTO hin2017_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“तू मैदा लेकर बारह रोटियाँ पकवाना, प्रत्येक रोटी में एपा का दो दसवाँ अंश मैदा हो। ");
INSERT INTO hin2017_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","तब उनकी दो पंक्तियाँ करके, एक-एक पंक्ति में छः छः रोटियाँ, स्वच्छ मेज पर यहोवा के सामने रखना। ");
INSERT INTO hin2017_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","और एक-एक पंक्ति पर शुद्ध लोबान रखना कि वह रोटी स्मरण दिलानेवाली वस्तु और यहोवा के लिये हव्य हो। ");
INSERT INTO hin2017_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","प्रति विश्रामदिन को वह उसे नित्य यहोवा के सम्मुख क्रम से रखा करे, यह सदा की वाचा की रीति इस्राएलियों की ओर से हुआ करे। ");
INSERT INTO hin2017_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","और वह हारून और उसके पुत्रों की होंगी, और वे उसको किसी पवित्रस्थान में खाएँ, क्योंकि वह यहोवा के हव्यों में से सदा की विधि के अनुसार हारून के लिये परमपवित्र वस्तु ठहरी है।” ");
INSERT INTO hin2017_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","उन दिनों में किसी इस्राएली स्त्री का बेटा, जिसका पिता मिस्री पुरुष था, इस्राएलियों के बीच चला गया; और वह इस्राएली स्त्री का बेटा और एक इस्राएली पुरुष छावनी के बीच आपस में मारपीट करने लगे, ");
INSERT INTO hin2017_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","और वह इस्राएली स्त्री का बेटा यहोवा के नाम की निन्दा करके श्राप देने लगा। यह सुनकर लोग उसको मूसा के पास ले गए। उसकी माता का नाम शलोमीत था, जो दान के गोत्र के दिब्री की बेटी थी। ");
INSERT INTO hin2017_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","उन्होंने उसको हवालात में बन्द किया, जिससे यहोवा की आज्ञा से इस बात पर विचार किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“तुम लोग उस श्राप देनेवाले को छावनी से बाहर ले जाओ; और जितनों ने वह निन्दा सुनी हो वे सब अपने-अपने हाथ उसके सिर पर रखें, तब सारी मण्डली के लोग उस पर पथराव करें। ");
INSERT INTO hin2017_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","और तू इस्राएलियों से कह कि कोई क्यों न हो, जो अपने परमेश्वर को श्राप दे उसे अपने पाप का भार उठाना पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","यहोवा के नाम की निन्दा करनेवाला निश्चय मार डाला जाए; सारी मण्डली के लोग निश्चय उस पर पथराव करें; चाहे देशी हो चाहे परदेशी, यदि कोई यहोवा के नाम की निन्दा करें तो वह मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“फिर जो कोई किसी मनुष्य को जान से मारे वह निश्चय मार डाला जाए। (मत्ती 5:21) ");
INSERT INTO hin2017_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","और जो कोई किसी घरेलू पशु को जान से मारे वह उसका बदला दे, अर्थात् प्राणी के बदले प्राणी दे। ");
INSERT INTO hin2017_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“फिर यदि कोई किसी दूसरे को चोट पहुँचाए, तो जैसा उसने किया हो वैसा ही उसके साथ भी किया जाए, ");
INSERT INTO hin2017_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","अर्थात् अंग-भंग करने के बदले अंग-भंग किया जाए, आँख के बदले आँख, दाँत के बदले दाँत, जैसी चोट जिसने किसी को पहुँचाई हो वैसी ही उसको भी पहुँचाई जाए। (मत्ती 5:38) ");
INSERT INTO hin2017_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","पशु का मार डालनेवाला उसका बदला दे, परन्तु मनुष्य का मार डालनेवाला मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","तुम्हारा नियम एक ही हो, जैसा देशी के लिये वैसा ही परदेशी के लिये भी हो; मैं तुम्हारा परमेश्वर यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","अतः मूसा ने इस्राएलियों को यह समझाया; तब उन्होंने उस श्राप देनेवाले को छावनी से बाहर ले जाकर उस पर पथराव किया। और इस्राएलियों ने वैसा ही किया जैसा यहोवा ने मूसा को आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","फिर यहोवा ने सीनै पर्वत के पास मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“इस्राएलियों से कह कि जब तुम उस देश में प्रवेश करो जो मैं तुम्हें देता हूँ, तब भूमि को यहोवा के लिये विश्राम मिला करे। ");
INSERT INTO hin2017_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","छः वर्ष तो अपना-अपना खेत बोया करना, और छहों वर्ष अपनी-अपनी दाख की बारी छाँट छाँटकर देश की उपज इकट्ठी किया करना; ");
INSERT INTO hin2017_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","परन्तु सातवें वर्ष भूमि को यहोवा के लिये परमविश्रामकाल मिला करे; उसमें न तो अपना खेत बोना और न अपनी दाख की बारी छाँटना। ");
INSERT INTO hin2017_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","जो कुछ काटे हुए खेत में अपने आप से उगें उसे न काटना, और अपनी बिन छाँटी हुई दाखलता की दाखों को न तोड़ना; क्योंकि वह भूमि के लिये परमविश्राम का वर्ष होगा। ");
INSERT INTO hin2017_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","भूमि के विश्रामकाल ही की उपज से तुम को, और तुम्हारे दास-दासी को, और तुम्हारे साथ रहनेवाले मजदूरों और परदेशियों को भी भोजन मिलेगा; ");
INSERT INTO hin2017_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","और तुम्हारे पशुओं का और देश में जितने जीवजन्तु हों उनका भी भोजन भूमि की सब उपज से होगा। ");
INSERT INTO hin2017_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“सात विश्रामवर्ष, अर्थात् सातगुना सात वर्ष गिन लेना, सातों विश्रामवर्षों का यह समय उनचास वर्ष होगा। ");
INSERT INTO hin2017_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","तब सातवें महीने के दसवें दिन को, अर्थात् प्रायश्चित के दिन, जय जयकार के महाशब्द का नरसिंगा अपने सारे देश में सब कहीं फुँकवाना। ");
INSERT INTO hin2017_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","और उस पचासवें वर्ष को पवित्र करके मानना, और देश के सारे निवासियों के लिये छुटकारे का प्रचार करना; वह वर्ष तुम्हारे यहाँ जुबली कहलाए; उसमें तुम अपनी-अपनी निज भूमि और अपने-अपने घराने में लौटने पाओगे। ");
INSERT INTO hin2017_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","तुम्हारे यहाँ वह पचासवाँ वर्ष जुबली का वर्ष कहलाए; उसमें तुम न बोना, और जो अपने आप उगें उसे भी न काटना, और न बिन छाँटी हुई दाखलता की दाखों को तोड़ना। ");
INSERT INTO hin2017_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","क्योंकि वह तो जुबली का वर्ष होगा; वह तुम्हारे लिये पवित्र होगा; तुम उसकी उपज खेत ही में से ले लेकर खाना। ");
INSERT INTO hin2017_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“इस जुबली के वर्ष में तुम अपनी-अपनी निज भूमि को लौटने पाओगे। ");
INSERT INTO hin2017_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","और यदि तुम अपने भाई-बन्धु के हाथ कुछ बेचो या अपने भाई-बन्धु से कुछ मोल लो, तो तुम एक दूसरे पर उपद्रव न करना। ");
INSERT INTO hin2017_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","जुबली के बाद जितने वर्ष बीते हों उनकी गिनती के अनुसार दाम ठहराके एक दूसरे से मोल लेना, और शेष वर्षों की उपज के अनुसार वह तेरे हाथ बेचे। ");
INSERT INTO hin2017_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","जितने वर्ष और रहें उतना ही दाम बढ़ाना, और जितने वर्ष कम रहें उतना ही दाम घटाना, क्योंकि वर्ष की उपज की संख्या जितनी हो उतनी ही वह तेरे हाथ बेचेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","तुम अपने-अपने भाई-बन्धु पर उपद्रव न करना; अपने परमेश्वर का भय मानना; मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“इसलिए तुम मेरी विधियों को मानना, और मेरे नियमों पर समझ बूझकर चलना; क्योंकि ऐसा करने से तुम उस देश में निडर बसे रहोगे। ");
INSERT INTO hin2017_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","भूमि अपनी उपज उपजाया करेगी, और तुम पेट भर खाया करोगे, और उस देश में निडर बसे रहोगे। ");
INSERT INTO hin2017_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","और यदि तुम कहो कि सातवें वर्ष में हम क्या खाएँगे, न तो हम बोएँगे न अपने खेत की उपज इकट्ठा करेंगे?” ");
INSERT INTO hin2017_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","तो जानो कि मैं तुम को छठवें वर्ष में ऐसी आशीष दूँगा, कि भूमि की उपज तीन वर्ष तक काम आएगी। ");
INSERT INTO hin2017_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","तुम आठवें वर्ष में बोओगे, और पुरानी उपज में से खाते रहोगे, और नवें वर्ष की उपज जब तक न मिले तब तक तुम पुरानी उपज में से खाते रहोगे। ");
INSERT INTO hin2017_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“भूमि सदा के लिये बेची न जाए, क्योंकि भूमि मेरी है; और उसमें तुम परदेशी और बाहरी होंगे। ");
INSERT INTO hin2017_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","लेकिन तुम अपने भाग के सारे देश में भूमि को छुड़ाने देना। ");
INSERT INTO hin2017_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“यदि तेरा कोई भाई-बन्धु कंगाल होकर अपनी निज भूमि में से कुछ बेच डाले, तो उसके कुटुम्बियों में से जो सबसे निकट हो वह आकर अपने भाई-बन्धु के बेचे हुए भाग को छुड़ा ले। ");
INSERT INTO hin2017_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","यदि किसी मनुष्य के लिये कोई छुड़ानेवाला न हो, और उसके पास इतना धन हो कि आप ही अपने भाग को छुड़ा सके, ");
INSERT INTO hin2017_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","तो वह उसके बिकने के समय से वर्षों की गिनती करके शेष वर्षों की उपज का दाम उसको, जिसने उसे मोल लिया हो, फेर दे; तब वह अपनी निज भूमि का अधिकारी हो जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","परन्तु यदि उसके पास इतनी पूँजी न हो कि उसे फिर अपनी कर सके, तो उसकी बेची हुई भूमि जुबली के वर्ष तक मोल लेनेवालों के हाथ में रहे; और जुबली के वर्ष में छूट जाए तब वह मनुष्य अपनी निज भूमि का फिर अधिकारी हो जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“फिर यदि कोई मनुष्य शहरपनाह वाले नगर में बसने का घर बेचे, तो वह बेचने के बाद वर्ष भर के अन्दर उसे छुड़ा सकेगा, अर्थात् पूरे वर्ष भर उस मनुष्य को छुड़ाने का अधिकार रहेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","परन्तु यदि वह वर्ष भर में न छुड़ाए, तो वह घर जो शहरपनाह वाले नगर में हो मोल लेनेवाले का बना रहे, और पीढ़ी-पीढ़ी में उसी में वंश का बना रहे; और जुबली के वर्ष में भी न छूटे। ");
INSERT INTO hin2017_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","परन्तु बिना शहरपनाह के गाँवों के घर तो देश के खेतों के समान गिने जाएँ; उनका छुड़ाना भी हो सकेगा, और वे जुबली के वर्ष में छूट जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","फिर भी लेवियों के निज भाग के नगरों के जो घर हों उनको लेवीय जब चाहें तब छुड़ाएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","और यदि कोई लेवीय अपना भाग न छुड़ाए, तो वह बेचा हुआ घर जो उसके भाग के नगर में हो जुबली के वर्ष में छूट जाए; क्योंकि इस्राएलियों के बीच लेवियों का भाग उनके नगरों में वे घर ही हैं। ");
INSERT INTO hin2017_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","पर उनके नगरों के चारों ओर की चराई की भूमि बेची न जाए; क्योंकि वह उनका सदा का भाग होगा। ");
INSERT INTO hin2017_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“फिर यदि तेरा कोई भाई-बन्धु कंगाल हो जाए, और उसकी दशा तेरे सामने तरस योग्य हो जाए, तो तू उसको सम्भालना; वह परदेशी या यात्री के समान तेरे संग रहे। ");
INSERT INTO hin2017_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","उससे ब्याज या बढ़ती न लेना; अपने परमेश्वर का भय मानना; जिससे तेरा भाई-बन्धु तेरे संग जीवन निर्वाह कर सके। (लूका 6:35) ");
INSERT INTO hin2017_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","उसको ब्याज पर रुपया न देना, और न उसको भोजनवस्तु लाभ के लालच से देना। ");
INSERT INTO hin2017_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","मैं तुम्हारा परमेश्वर यहोवा हूँ; मैं तुम्हें कनान देश देने के लिये और तुम्हारा परमेश्वर ठहरने की मनसा से तुम को मिस्र देश से निकाल लाया हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“फिर यदि तेरा कोई भाई-बन्धु तेरे सामने कंगाल होकर अपने आपको तेरे हाथ बेच डाले, तो उससे दास के समान सेवा न करवाना। ");
INSERT INTO hin2017_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","वह तेरे संग मजदूर या यात्री के समान रहे, और जुबली के वर्ष तक तेरे संग रहकर सेवा करता रहे; ");
INSERT INTO hin2017_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","तब वह बाल-बच्चों समेत तेरे पास से निकल जाए, और अपने कुटुम्ब में और अपने पितरों की निज भूमि में लौट जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","क्योंकि वे मेरे ही दास हैं, जिनको मैं मिस्र देश से निकाल लाया हूँ; इसलिए वे दास की रीति से न बेचे जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","उस पर कठोरता से अधिकार न करना; अपने परमेश्वर का भय मानते रहना। ");
INSERT INTO hin2017_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","तेरे जो दास-दासियाँ हों वे तुम्हारे चारों ओर की जातियों में से हों, और दास और दासियाँ उन्हीं में से मोल लेना। ");
INSERT INTO hin2017_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","जो यात्री लोग तुम्हारे बीच में परदेशी होकर रहेंगे, उनमें से और उनके घरानों में से भी जो तुम्हारे आस-पास हों, और जो तुम्हारे देश में उत्पन्न हुए हों, उनमें से तुम दास और दासी मोल लो; और वे तुम्हारा भाग ठहरें। ");
INSERT INTO hin2017_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","तुम अपने पुत्रों को भी जो तुम्हारे बाद होंगे उनके अधिकारी कर सकोगे, और वे उनका भाग ठहरें; उनमें से तुम सदा अपने लिये दास लिया करना, परन्तु तुम्हारे भाई-बन्धु जो इस्राएली हों उन पर अपना अधिकार कठोरता से न जताना। ");
INSERT INTO hin2017_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“फिर यदि तेरे सामने कोई परदेशी या यात्री धनी हो जाए, और उसके सामने तेरा भाई कंगाल होकर अपने आपको तेरे सामने उस परदेशी या यात्री या उसके वंश के हाथ बेच डाले, ");
INSERT INTO hin2017_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","तो उसके बिक जाने के बाद वह फिर छुड़ाया जा सकता है; उसके भाइयों में से कोई उसको छुड़ा सकता है, ");
INSERT INTO hin2017_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","या उसका चाचा, या चचेरा भाई, तथा उसके कुल का कोई भी निकट कुटुम्बी उसको छुड़ा सकता है; या यदि वह धनी हो जाए, तो वह आप ही अपने को छुड़ा सकता है। ");
INSERT INTO hin2017_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","वह अपने मोल लेनेवाले के साथ अपने बिकने के वर्ष से जुबली के वर्ष तक हिसाब करे, और उसके बिकने का दाम वर्षों की गिनती के अनुसार हो, अर्थात् वह दाम मजदूर के दिवसों के समान उसके साथ होगा। ");
INSERT INTO hin2017_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","यदि जुबली के वर्ष के बहुत वर्ष रह जाएँ, तो जितने रुपयों से वह मोल लिया गया हो उनमें से वह अपने छुड़ाने का दाम उतने वर्षों के अनुसार फेर दे। ");
INSERT INTO hin2017_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","यदि जुबली के वर्ष के थोड़े वर्ष रह गए हों, तो भी वह अपने स्वामी के साथ हिसाब करके अपने छुड़ाने का दाम उतने ही वर्षों के अनुसार फेर दे। ");
INSERT INTO hin2017_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","वह अपने स्वामी के संग उस मजदूर के समान रहे जिसकी वार्षिक मजदूरी ठहराई जाती हो; और उसका स्वामी उस पर तेरे सामने कठोरता से अधिकार न जताने पाए। (कुलु. 4:1) ");
INSERT INTO hin2017_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","और यदि वह इन रीतियों से छुड़ाया न जाए, तो वह जुबली के वर्ष में अपने बाल-बच्चों समेत छूट जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","क्योंकि इस्राएली मेरे ही दास हैं; वे मिस्र देश से मेरे ही निकाले हुए दास हैं; मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“तुम अपने लिये मूरतें न बनाना, और न कोई खुदी हुई मूर्ति या स्तम्भ अपने लिये खड़ा करना, और न अपने देश में दण्डवत् करने के लिये नक्काशीदार पत्थर स्थापित करना; क्योंकि मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","तुम मेरे विश्रामदिनों का पालन करना और मेरे पवित्रस्थान का भय मानना; मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“यदि तुम मेरी विधियों पर चलो और मेरी आज्ञाओं को मानकर उनका पालन करो, ");
INSERT INTO hin2017_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","तो मैं तुम्हारे लिये समय-समय पर मेंह बरसाऊँगा, तथा भूमि अपनी उपज उपजाएगी, और मैदान के वृक्ष अपने-अपने फल दिया करेंगे; ");
INSERT INTO hin2017_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","यहाँ तक कि तुम दाख तोड़ने के समय भी दाँवनी करते रहोगे, और बोने के समय भी भर पेट दाख तोड़ते रहोगे, और तुम मनमानी रोटी खाया करोगे, और अपने देश में निश्चिन्त बसे रहोगे। ");
INSERT INTO hin2017_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","और मैं तुम्हारे देश में सुख चैन दूँगा, और तुम सोओगे और तुम्हारा कोई डरानेवाला न होगा; और मैं उस देश में खतरनाक जन्तुओं को न रहने दूँगा, और तलवार तुम्हारे देश में न चलेगी। ");
INSERT INTO hin2017_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","और तुम अपने शत्रुओं को मार भगा दोगे, और वे तुम्हारी तलवार से मारे जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","तुम में से पाँच मनुष्य सौ को और सौ मनुष्य दस हजार को खदेड़ेंगे; और तुम्हारे शत्रु तलवार से तुम्हारे आगे-आगे मारे जाएँगे; ");
INSERT INTO hin2017_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","और मैं तुम्हारी ओर कृपादृष्टि रखूँगा और तुम को फलवन्त करूँगा और बढ़ाऊँगा, और तुम्हारे संग अपनी वाचा को पूर्ण करूँगा। ");
INSERT INTO hin2017_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","और तुम रखे हुए पुराने अनाज को खाओगे, और नये के रहते भी पुराने को निकालोगे। ");
INSERT INTO hin2017_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","और मैं तुम्हारे बीच अपना निवास-स्थान बनाए रखूँगा, और मेरा जी तुम से घृणा नहीं करेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","और मैं तुम्हारे मध्य चला फिरा करूँगा, और तुम्हारा परमेश्वर बना रहूँगा, और तुम मेरी प्रजा बने रहोगे। (2 कुरि. 6:16) ");
INSERT INTO hin2017_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","मैं तो तुम्हारा वह परमेश्वर यहोवा हूँ, जो तुम को मिस्र देश से इसलिए निकाल ले आया कि तुम मिस्रियों के दास न बने रहो; और मैंने तुम्हारे जूए को तोड़ डाला है, और तुम को सीधा खड़ा करके चलाया है। ");
INSERT INTO hin2017_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“यदि तुम मेरी न सुनोगे, और इन सब आज्ञाओं को न मानोगे, ");
INSERT INTO hin2017_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","और मेरी विधियों को निकम्मा जानोगे, और तुम्हारी आत्मा मेरे निर्णयों से घृणा करे, और तुम मेरी सब आज्ञाओं का पालन न करोगे, वरन् मेरी वाचा को तोड़ोगे, ");
INSERT INTO hin2017_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","तो मैं तुम से यह करूँगा; अर्थात् मैं तुम को बेचैन करूँगा, और क्षयरोग और ज्वर से पीड़ित करूँगा, और इनके कारण तुम्हारी आँखें धुंधली हो जाएँगी, और तुम्हारा मन अति उदास होगा। और तुम्हारा बीज बोना व्यर्थ होगा, क्योंकि तुम्हारे शत्रु उसकी उपज खा लेंगे; ");
INSERT INTO hin2017_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","और मैं भी तुम्हारे विरुद्ध हो जाऊँगा, और तुम अपने शत्रुओं से हार जाओगे; और तुम्हारे बैरी तुम्हारे ऊपर अधिकार करेंगे, और जब कोई तुम को खदेड़ता भी न होगा तब भी तुम भागोगे। ");
INSERT INTO hin2017_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","और यदि तुम इन बातों के उपरान्त भी मेरी न सुनो, तो मैं तुम्हारे पापों के कारण तुम्हें सातगुना ताड़ना और दूँगा, ");
INSERT INTO hin2017_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","और मैं तुम्हारे बल का घमण्ड तोड़ डालूँगा, और तुम्हारे लिये आकाश को मानो लोहे का और भूमि को मानो पीतल की बना दूँगा; ");
INSERT INTO hin2017_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","और तुम्हारा बल अकारथ गँवाया जाएगा, क्योंकि तुम्हारी भूमि अपनी उपज न उपजाएगी, और मैदान के वृक्ष अपने फल न देंगे। ");
INSERT INTO hin2017_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“यदि तुम मेरे विरुद्ध चलते ही रहो, और मेरा कहना न मानो, तो मैं तुम्हारे पापों के अनुसार तुम्हारे ऊपर और सात गुणा संकट डालूँगा। ");
INSERT INTO hin2017_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","और मैं तुम्हारे बीच वन पशु भेजूँगा, जो तुम को निर्वंश करेंगे, और तुम्हारे घरेलू पशुओं को नाश कर डालेंगे, और तुम्हारी गिनती घटाएँगे, जिससे तुम्हारी सड़कें सूनी पड़ जाएँगी। ");
INSERT INTO hin2017_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“फिर यदि तुम इन बातों पर भी मेरी ताड़ना से न सुधरो, और मेरे विरुद्ध चलते ही रहो, ");
INSERT INTO hin2017_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","तो मैं भी तुम्हारे विरुद्ध चलूँगा, और तुम्हारे पापों के कारण मैं आप ही तुम को सात गुणा मारूँगा। ");
INSERT INTO hin2017_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","और मैं तुम पर एक ऐसी तलवार चलवाऊँगा, जो वाचा तोड़ने का पूरा-पूरा पलटा लेगी; और जब तुम अपने नगरों में जा जाकर इकट्ठे होंगे तब मैं तुम्हारे बीच मरी फैलाऊँगा, और तुम अपने शत्रुओं के वश में सौंप दिए जाओगे। ");
INSERT INTO hin2017_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","जब मैं तुम्हारे लिये अन्न के आधार को दूर कर डालूँगा, तब दस स्त्रियाँ तुम्हारी रोटी एक ही तंदूर में पकाकर तौल-तौलकर बाँट देंगी; और तुम खाकर भी तृप्त न होंगे। ");
INSERT INTO hin2017_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“फिर यदि तुम इसके उपरान्त भी मेरी न सुनोगे, और मेरे विरुद्ध चलते ही रहोगे, ");
INSERT INTO hin2017_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","तो मैं अपने न्याय में तुम्हारे विरुद्ध चलूँगा, और तुम्हारे पापों के कारण तुम को सातगुना ताड़ना और भी दूँगा। ");
INSERT INTO hin2017_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","और तुम को अपने बेटों और बेटियों का माँस खाना पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","और मैं तुम्हारे पूजा के ऊँचे स्थानों को ढा दूँगा, और तुम्हारे सूर्य की प्रतिमाएँ तोड़ डालूँगा, और तुम्हारी लोथों को तुम्हारी तोड़ी हुई मूरतों पर फेंक दूँगा; और मेरी आत्मा को तुम से घृणा हो जाएगी। ");
INSERT INTO hin2017_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","और मैं तुम्हारे नगरों को उजाड़ दूँगा, और तुम्हारे पवित्रस्थानों को उजाड़ दूँगा, और तुम्हारा सुखदायक सुगन्ध ग्रहण न करूँगा। ");
INSERT INTO hin2017_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","और मैं तुम्हारे देश को सूना कर दूँगा, और तुम्हारे शत्रु जो उसमें रहते हैं वे इन बातों के कारण चकित होंगे। ");
INSERT INTO hin2017_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","और मैं तुम को जाति-जाति के बीच तितर-बितर करूँगा, और तुम्हारे पीछे-पीछे तलवार खींचे रहूँगा; और तुम्हारा देश सुना हो जाएगा, और तुम्हारे नगर उजाड़ हो जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“तब जितने दिन वह देश सूना पड़ा रहेगा और तुम अपने शत्रुओं के देश में रहोगे उतने दिन वह अपने विश्रामकालों को मानता रहेगा। तब ही वह देश विश्राम पाएगा, अर्थात् अपने विश्रामकालों को मानता रहेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","जितने दिन वह सूना पड़ा रहेगा उतने दिन उसको विश्राम रहेगा, अर्थात् जो विश्राम उसको तुम्हारे वहाँ बसे रहने के समय तुम्हारे विश्रामकालों में न मिला होगा वह उसको तब मिलेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","और तुम में से जो बचा रहेंगे और अपने शत्रुओं के देश में होंगे उनके हृदय में मैं कायरता उपजाऊँगा; और वे पत्ते के खड़कने से भी भाग जाएँगे, और वे ऐसे भागेंगे जैसे कोई तलवार से भागे, और किसी के बिना पीछा किए भी वे गिर पड़ेंगे। ");
INSERT INTO hin2017_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","जब कोई पीछा करनेवाला न हो तब भी मानो तलवार के भय से वे एक दूसरे से ठोकर खाकर गिरते जाएँगे, और तुम को अपने शत्रुओं के सामने ठहरने की कुछ शक्ति न होगी। ");
INSERT INTO hin2017_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","तब तुम जाति-जाति के बीच पहुँचकर नाश हो जाओगे, और तुम्हारे शत्रुओं की भूमि तुम को खा जाएगी। ");
INSERT INTO hin2017_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","और तुम में से जो बचे रहेंगे वे अपने शत्रुओं के देशों में अपने अधर्म के कारण गल जाएँगे; और अपने पुरखाओं के अधर्म के कामों के कारण भी वे उन्हीं के समान गल जाएँगे। ");
INSERT INTO hin2017_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“पर यदि वे अपने और अपने पितरों के अधर्म को मान लेंगे, अर्थात् उस विश्वासघात को जो उन्होंने मेरे विरुद्ध किया, और यह भी मान लेंगे, कि हम यहोवा के विरुद्ध चले थे, ");
INSERT INTO hin2017_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","इसी कारण वह हमारे विरुद्ध होकर हमें शत्रुओं के देश में ले आया है। यदि उस समय उनका खतनारहित हृदय दब जाएगा और वे उस समय अपने अधर्म के दण्ड को अंगीकार करेंगे; (प्रेरि. 7:51) ");
INSERT INTO hin2017_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","तब जो वाचा मैंने याकूब के संग बाँधी थी उसको मैं स्मरण करूँगा, और जो वाचा मैंने इसहाक से और जो वाचा मैंने अब्राहम से बाँधी थी उनको भी स्मरण करूँगा, और इस देश को भी मैं स्मरण करूँगा। ");
INSERT INTO hin2017_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","पर वह देश उनसे रहित होकर सूना पड़ा रहेगा, और उनके बिना सूना रहकर भी अपने विश्रामकालों को मानता रहेगा; और वे लोग अपने अधर्म के दण्ड को अंगीकार करेंगे, इसी कारण से कि उन्होंने मेरी आज्ञाओं का उल्लंघन किया था, और उनकी आत्माओं को मेरी विधियों से घृणा थी। ");
INSERT INTO hin2017_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","इतने पर भी जब वे अपने शत्रुओं के देश में होंगे, तब मैं उनको इस प्रकार नहीं छोड़ूँगा, और न उनसे ऐसी घृणा करूँगा कि उनका सर्वनाश कर डालूँ और अपनी उस वाचा को तोड़ दूँ जो मैंने उनसे बाँधी है; क्योंकि मैं उनका परमेश्वर यहोवा हूँ; ");
INSERT INTO hin2017_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","परन्तु मैं उनकी भलाई के लिये उनके पितरों से बाँधी हुई वाचा को स्मरण करूँगा, जिन्हें मैं अन्यजातियों की आँखों के सामने मिस्र देश से निकालकर लाया कि मैं उनका परमेश्वर ठहरूँ; मैं यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","जो-जो विधियाँ और नियम और व्यवस्था यहोवा ने अपनी ओर से इस्राएलियों के लिये सीनै पर्वत पर मूसा के द्वारा ठहराई थीं वे ये ही हैं। ");
INSERT INTO hin2017_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“इस्राएलियों से यह कह कि जब कोई विशेष संकल्प माने, तो संकल्प किया हुआ मनुष्य तेरे ठहराने के अनुसार यहोवा के होंगे; ");
INSERT INTO hin2017_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","इसलिए यदि वह बीस वर्ष या उससे अधिक और साठ वर्ष से कम अवस्था का पुरुष हो, तो उसके लिये पवित्रस्थान के शेकेल के अनुसार पचास शेकेल का चाँदी ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","यदि वह स्त्री हो, तो तीस शेकेल ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","फिर यदि उसकी अवस्था पाँच वर्ष या उससे अधिक और बीस वर्ष से कम की हो, तो लड़के के लिये तो बीस शेकेल, और लड़की के लिये दस शेकेल ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","यदि उसकी अवस्था एक महीने या उससे अधिक और पाँच वर्ष से कम की हो, तो लड़के के लिये तो पाँच, और लड़की के लिये तीन शेकेल ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","फिर यदि उसकी अवस्था साठ वर्ष की या उससे अधिक हो, और वह पुरुष हो तो उसके लिये पन्द्रह शेकेल, और स्त्री हो तो दस शेकेल ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","परन्तु यदि कोई इतना कंगाल हो कि याजक का ठहराया हुआ दाम न दे सके, तो वह याजक के सामने खड़ा किया जाए, और याजक उसकी पूँजी ठहराए, अर्थात् जितना संकल्प करनेवाले से हो सके, याजक उसी के अनुसार ठहराए। ");
INSERT INTO hin2017_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“फिर जिन पशुओं में से लोग यहोवा को चढ़ावा चढ़ाते है, यदि ऐसों में से कोई संकल्प किया जाए, तो जो पशु कोई यहोवा को दे वह पवित्र ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","वह उसे किसी प्रकार से न बदले, न तो वह बुरे के बदले अच्छा, और न अच्छे के बदले बुरा दे; और यदि वह उस पशु के बदले दूसरा पशु दे, तो वह और उसका बदला दोनों पवित्र ठहरेंगे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","और जिन पशुओं में से लोग यहोवा के लिये चढ़ावा नहीं चढ़ाते ऐसों में से यदि वह हो, तो वह उसको याजक के सामने खड़ा कर दे, ");
INSERT INTO hin2017_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","तब याजक पशु के गुण-अवगुण दोनों विचार कर उसका मोल ठहराए; और जितना याजक ठहराए उसका मोल उतना ही ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","पर यदि संकल्प करनेवाला उसे किसी प्रकार से छुड़ाना चाहे, तो जो मोल याजक ने ठहराया हो उसमें उसका पाँचवाँ भाग और बढ़ाकर दे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“फिर यदि कोई अपना घर यहोवा के लिये पवित्र ठहराकर संकल्प करे, तो याजक उसके गुण-अवगुण दोनों विचार कर उसका मोल ठहराए; और जितना याजक ठहराए उसका मोल उतना ही ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","और यदि घर का पवित्र करनेवाला उसे छुड़ाना चाहे, तो जितना रुपया याजक ने उसका मोल ठहराया हो उसमें वह पाँचवाँ भाग और बढ़ाकर दे, तब वह घर उसी का रहेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“फिर यदि कोई अपनी निज भूमि का कोई भाग यहोवा के लिये पवित्र ठहराना चाहे, तो उसका मोल इसके अनुसार ठहरे, कि उसमें कितना बीज पड़ेगा; जितना भूमि में होमेर भर जौ पड़े उतनी का मोल पचास शेकेल ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","यदि वह अपना खेत जुबली के वर्ष ही में पवित्र ठहराए, तो उसका दाम तेरे ठहराने के अनुसार ठहरे; ");
INSERT INTO hin2017_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","और यदि वह अपना खेत जुबली के वर्ष के बाद पवित्र ठहराए, तो जितने वर्ष दूसरे जुबली के वर्ष के बाकी रहें उन्हीं के अनुसार याजक उसके लिये रुपये का हिसाब करे, तब जितना हिसाब में आए उतना याजक के ठहराने से कम हो। ");
INSERT INTO hin2017_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","और यदि खेत को पवित्र ठहरानेवाला उसे छुड़ाना चाहे, तो जो दाम याजक ने ठहराया हो उसमें वह पाँचवाँ भाग और बढ़ाकर दे, तब खेत उसी का रहेगा। ");
INSERT INTO hin2017_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","और यदि वह खेत को छुड़ाना न चाहे, या उसने उसको दूसरे के हाथ बेचा हो, तो खेत आगे को कभी न छुड़ाया जाए; ");
INSERT INTO hin2017_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","परन्तु जब वह खेत जुबली के वर्ष में छूटे, तब पूरी रीति से अर्पण किए हुए खेत के समान यहोवा के लिये पवित्र ठहरे, अर्थात् वह याजक ही की निज भूमि हो जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","फिर यदि कोई अपना मोल लिया हुआ खेत, जो उसकी निज भूमि के खेतों में का न हो, यहोवा के लिये पवित्र ठहराए, ");
INSERT INTO hin2017_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","तो याजक जुबली के वर्ष तक का हिसाब करके उस मनुष्य के लिये जितना ठहराए उतना ही वह यहोवा के लिये पवित्र जानकर उसी दिन दे दे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","जुबली के वर्ष में वह खेत उसी के अधिकार में जिससे वह मोल लिया गया हो फिर आ जाए, अर्थात् जिसकी वह निज भूमि हो उसी की फिर हो जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","जिस-जिस वस्तु का मोल याजक ठहराए उसका मोल पवित्रस्थान ही के शेकेल के हिसाब से ठहरे: शेकेल बीस गेरा का ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“परन्तु घरेलू पशुओं का पहलौठा, जो पहलौठा होने के कारण यहोवा का ठहरा है, उसको कोई पवित्र न ठहराए; चाहे वह बछड़ा हो, चाहे भेड़ या बकरी का बच्चा, वह यहोवा ही का है। ");
INSERT INTO hin2017_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","परन्तु यदि वह अशुद्ध पशु का हो, तो उसका पवित्र ठहरानेवाला उसको याजक के ठहराए हुए मोल के अनुसार उसका पाँचवाँ भाग और बढ़ाकर छुड़ा सकता है; और यदि वह न छुड़ाया जाए, तो याजक के ठहराए हुए मोल पर बेच दिया जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“परन्तु अपनी सारी वस्तुओं में से जो कुछ कोई यहोवा के लिये अर्पण करे, चाहे मनुष्य हो चाहे पशु, चाहे उसकी निज भूमि का खेत हो, ऐसी कोई अर्पण की हुई वस्तु न तो बेची जाए और न छुड़ाई जाए; जो कुछ अर्पण किया जाए वह यहोवा के लिये परमपवित्र ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","मनुष्यों में से जो कोई मृत्युदण्ड के लिये अर्पण किया जाए, वह छुड़ाया न जाए; निश्चय वह मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“फिर भूमि की उपज का सारा दशमांश, चाहे वह भूमि का बीज हो चाहे वृक्ष का फल, वह यहोवा ही का है; वह यहोवा के लिये पवित्र ठहरे। (मत्ती 23:23, लूका 11:42) ");
INSERT INTO hin2017_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","यदि कोई अपने दशमांश में से कुछ छुड़ाना चाहे, तो पाँचवाँ भाग बढ़ाकर उसको छुड़ाए। ");
INSERT INTO hin2017_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","और गाय-बैल और भेड़-बकरियाँ, अर्थात् जो-जो पशु गिनने के लिये लाठी के तले निकल जानेवाले हैं उनका दशमांश, अर्थात् दस-दस पीछे एक-एक पशु यहोवा के लिये पवित्र ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","कोई उसके गुण-अवगुण न विचारे, और न उसको बदले; और यदि कोई उसको बदल भी ले, तो वह और उसका बदला दोनों पवित्र ठहरें; और वह कभी छुड़ाया न जाए।” ");
INSERT INTO hin2017_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","जो आज्ञाएँ यहोवा ने इस्राएलियों के लिये सीनै पर्वत पर मूसा को दी थीं, वे ये ही हैं।");
INSERT INTO hin2017_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","इस्राएलियों के मिस्र देश से निकल जाने के दूसरे वर्ष के दूसरे महीने के पहले दिन को, यहोवा ने सीनै के जंगल में मिलापवाले तम्बू में, मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“इस्राएलियों की सारी मण्डली के कुलों और पितरों के घरानों के अनुसार, एक-एक पुरुष की गिनती नाम ले लेकर करना। ");
INSERT INTO hin2017_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","जितने इस्राएली बीस वर्ष या उससे अधिक आयु के हों, और जो युद्ध करने के योग्य हों, उन सभी को उनके दलों के अनुसार तू और हारून गिन ले। ");
INSERT INTO hin2017_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","और तुम्हारे साथ प्रत्येक गोत्र का एक पुरुष भी हो जो अपने पितरों के घराने का मुख्य पुरुष हो। ");
INSERT INTO hin2017_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","तुम्हारे उन साथियों के नाम ये हैं: रूबेन के गोत्र में से शदेऊर का पुत्र एलीसूर; ");
INSERT INTO hin2017_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","शिमोन के गोत्र में से सूरीशद्दै का पुत्र शलूमीएल; ");
INSERT INTO hin2017_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","यहूदा के गोत्र में से अम्मीनादाब का पुत्र नहशोन; ");
INSERT INTO hin2017_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","इस्साकार के गोत्र में से सूआर का पुत्र नतनेल; ");
INSERT INTO hin2017_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","जबूलून के गोत्र में से हेलोन का पुत्र एलीआब; ");
INSERT INTO hin2017_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","यूसुफ वंशियों में से ये हैं, अर्थात् एप्रैम के गोत्र में से अम्मीहूद का पुत्र एलीशामा, और मनश्शे के गोत्र में से पदासूर का पुत्र गम्लीएल; ");
INSERT INTO hin2017_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","बिन्यामीन के गोत्र में से गिदोनी का पुत्र अबीदान; ");
INSERT INTO hin2017_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","दान के गोत्र में से अम्मीशद्दै का पुत्र अहीएजेर; ");
INSERT INTO hin2017_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","आशेर के गोत्र में से ओक्रान का पुत्र पगीएल; ");
INSERT INTO hin2017_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","गाद के गोत्र में से दूएल का पुत्र एल्यासाप; ");
INSERT INTO hin2017_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","नप्ताली के गोत्र में से एनान का पुत्र अहीरा।” ");
INSERT INTO hin2017_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","मण्डली में से जो पुरुष अपने-अपने पितरों के गोत्रों के प्रधान होकर बुलाए गए, वे ये ही हैं, और ये इस्राएलियों के हजारों में मुख्य पुरुष थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","जिन पुरुषों के नाम ऊपर लिखे हैं उनको साथ लेकर मूसा और हारून ने, ");
INSERT INTO hin2017_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","दूसरे महीने के पहले दिन सारी मण्डली इकट्ठी की, तब इस्राएलियों ने अपने-अपने कुल और अपने-अपने पितरों के घराने के अनुसार बीस वर्ष या उससे अधिक आयु वालों के नामों की गिनती करवाकर अपनी-अपनी वंशावली लिखवाई; ");
INSERT INTO hin2017_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","जिस प्रकार यहोवा ने मूसा को आज्ञा दी थी उसी के अनुसार उसने सीनै के जंगल में उनकी गणना की। ");
INSERT INTO hin2017_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","और इस्राएल के पहलौठे रूबेन के वंश के जितने पुरुष अपने कुल और अपने पितरों के घराने के अनुसार बीस वर्ष या उससे अधिक आयु के थे और युद्ध करने के योग्य थे, वे सब अपने-अपने नाम से गिने गए: ");
INSERT INTO hin2017_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","और रूबेन के गोत्र के गिने हुए पुरुष साढ़े छियालीस हजार थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","शिमोन के वंश के लोग जितने पुरुष अपने कुलों और अपने पितरों के घरानों के अनुसार बीस वर्ष या उससे अधिक आयु के थे, और जो युद्ध करने के योग्य थे वे सब अपने-अपने नाम से गिने गए। ");
INSERT INTO hin2017_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","और शिमोन के गोत्र के गिने हुए पुरुष उनसठ हजार तीन सौ थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","गाद के वंश के जितने पुरुष अपने कुलों और अपने पितरों के घरानों के अनुसार बीस वर्ष या उससे अधिक आयु के थे और जो युद्ध करने के योग्य थे, वे सब अपने-अपने नाम से गिने गए: ");
INSERT INTO hin2017_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","और गाद के गोत्र के गिने हुए पुरुष पैंतालीस हजार साढ़े छः सौ थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","यहूदा के वंश के जितने पुरुष अपने कुलों और अपने पितरों के घरानों के अनुसार बीस वर्ष या उससे अधिक आयु के थे और जो युद्ध करने के योग्य थे, वे सब अपने-अपने नाम से गिने गए: ");
INSERT INTO hin2017_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","और यहूदा के गोत्र के गिने हुए पुरुष चौहत्तर हजार छः सौ थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","इस्साकार के वंश के जितने पुरुष अपने कुलों और अपने पितरों के घरानों के अनुसार बीस वर्ष या उससे अधिक आयु के थे और जो युद्ध करने के योग्य थे, वे सब अपने-अपने नाम से गिने गए: ");
INSERT INTO hin2017_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","और इस्साकार के गोत्र के गिने हुए पुरुष चौवन हजार चार सौ थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","जबूलून के वंश के जितने पुरुष अपने कुलों और अपने पितरों के घरानों के अनुसार बीस वर्ष या उससे अधिक आयु के थे और जो युद्ध करने के योग्य थे, वे सब अपने-अपने नाम से गिने गए: ");
INSERT INTO hin2017_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","और जबूलून के गोत्र के गिने हुए पुरुष सत्तावन हजार चार सौ थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","यूसुफ के वंश में से एप्रैम के वंश के जितने पुरुष अपने कुलों और अपने पितरों के घरानों के अनुसार बीस वर्ष या उससे अधिक आयु के थे और जो युद्ध करने के योग्य थे, वे सब अपने-अपने नाम से गिने गए: ");
INSERT INTO hin2017_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","और एप्रैम गोत्र के गिने हुए पुरुष साढ़े चालीस हजार थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","मनश्शे के वंश के जितने पुरुष अपने कुलों और अपने पितरों के घरानों के अनुसार बीस वर्ष या उससे अधिक आयु के थे और जो युद्ध करने के योग्य थे, वे सब अपने-अपने नाम से गिने गए: ");
INSERT INTO hin2017_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","और मनश्शे के गोत्र के गिने हुए पुरुष बत्तीस हजार दो सौ थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","बिन्यामीन के वंश के जितने पुरुष अपने कुलों और अपने पितरों के घरानों के अनुसार बीस वर्ष या उससे अधिक आयु के थे और जो युद्ध करने के योग्य थे, वे सब अपने-अपने नाम से गिने गए: ");
INSERT INTO hin2017_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","और बिन्यामीन के गोत्र के गिने हुए पुरुष पैंतीस हजार चार सौ थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","दान के वंश के जितने पुरुष अपने कुलों और अपने पितरों के घरानों के अनुसार बीस वर्ष या उससे अधिक आयु के थे और जो युद्ध करने के योग्य थे, वे अपने-अपने नाम से गिने गए: ");
INSERT INTO hin2017_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","और दान के गोत्र के गिने हुए पुरुष बासठ हजार सात सौ थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","आशेर के वंश के जितने पुरुष अपने कुलों और अपने पितरों के घरानों के अनुसार बीस वर्ष या उससे अधिक आयु के थे और जो युद्ध करने के योग्य थे, वे सब अपने-अपने नाम से गिने गए: ");
INSERT INTO hin2017_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","और आशेर के गोत्र के गिने हुए पुरुष साढ़े इकतालीस हजार थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","नप्ताली के वंश के जितने पुरुष अपने कुलों और अपने पितरों के घरानों के अनुसार बीस वर्ष या उससे अधिक आयु के थे और जो युद्ध करने के योग्य थे, वे सब अपने-अपने नाम से गिने गए: ");
INSERT INTO hin2017_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","और नप्ताली के गोत्र के गिने हुए पुरुष तिरपन हजार चार सौ थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","इस प्रकार मूसा और हारून और इस्राएल के बारह प्रधानों ने, जो अपने-अपने पितरों के घराने के प्रधान थे, उन सभी को गिन लिया और उनकी गिनती यही थी। ");
INSERT INTO hin2017_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","अतः जितने इस्राएली बीस वर्ष या उससे अधिक आयु के होने के कारण युद्ध करने के योग्य थे वे अपने पितरों के घरानों के अनुसार गिने गए, ");
INSERT INTO hin2017_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","और वे सब गिने हुए पुरुष मिलाकर छः लाख तीन हजार साढ़े पाँच सौ थे। ");
INSERT INTO hin2017_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","इनमें लेवीय अपने पितरों के गोत्र के अनुसार नहीं गिने गए। ");
INSERT INTO hin2017_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","क्योंकि यहोवा ने मूसा से कहा था, ");
INSERT INTO hin2017_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“लेवीय गोत्र की गिनती इस्राएलियों के संग न करना; ");
INSERT INTO hin2017_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","परन्तु तू लेवियों को साक्षी के तम्बू पर, और उसके सम्पूर्ण सामान पर, अर्थात् जो कुछ उससे सम्बंध रखता है उस पर अधिकारी नियुक्त करना; और सम्पूर्ण सामान सहित निवास को वे ही उठाया करें, और वे ही उसमें सेवा टहल भी किया करें, और तम्बू के आस-पास वे ही अपने डेरे डाला करें। (प्रेरि. 7:44) ");
INSERT INTO hin2017_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","और जब जब निवास को आगे ले जाना हो तब-तब लेवीय उसको गिरा दें, और जब जब निवास को खड़ा करना हो तब-तब लेवीय उसको खड़ा किया करें; और यदि कोई दूसरा समीप आए तो वह मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","और इस्राएली अपना-अपना डेरा अपनी-अपनी छावनी में और अपने-अपने झण्डे के पास खड़ा किया करें; ");
INSERT INTO hin2017_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","पर लेवीय अपने डेरे साक्षी के तम्बू ही के चारों ओर खड़े किया करें, कहीं ऐसा न हो कि इस्राएलियों की मण्डली पर मेरा कोप भड़के; और लेवीय साक्षी के तम्बू की रक्षा किया करें।” ");
INSERT INTO hin2017_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","जो आज्ञाएँ यहोवा ने मूसा को दी थीं, इस्राएलियों ने उन्हीं के अनुसार किया। ");
INSERT INTO hin2017_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","फिर यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“इस्राएली मिलापवाले तम्बू के चारों ओर और उसके सामने अपने-अपने झण्डे और अपने-अपने पितरों के घराने के निशान के समीप अपने डेरे खड़े करें। ");
INSERT INTO hin2017_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","और जो पूर्व दिशा की ओर जहाँ सूर्योदय होता है, अपने-अपने दलों के अनुसार डेरे खड़े किया करें, वे ही यहूदा की छावनीवाले झण्डे के लोग होंगे, और उनका प्रधान अम्मीनादाब का पुत्र नहशोन होगा, ");
INSERT INTO hin2017_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","और उनके दल के गिने हुए पुरुष चौहत्तर हजार छः सौ हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","उनके समीप जो डेरे खड़े किया करें वे इस्साकार के गोत्र के हों, और उनका प्रधान सूआर का पुत्र नतनेल होगा, ");
INSERT INTO hin2017_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","और उनके दल के गिने हुए पुरुष चौवन हजार चार सौ हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","इनके पास जबूलून के गोत्रवाले रहेंगे, और उनका प्रधान हेलोन का पुत्र एलीआब होगा, ");
INSERT INTO hin2017_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","और उनके दल के गिने हुए पुरुष सत्तावन हजार चार सौ हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","इस रीति से यहूदा की छावनी में जितने अपने-अपने दलों के अनुसार गिने गए वे सब मिलकर एक लाख छियासी हजार चार सौ हैं। पहले ये ही कूच किया करें। ");
INSERT INTO hin2017_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“दक्षिण की ओर रूबेन की छावनी के झण्डे के लोग अपने-अपने दलों के अनुसार रहें, और उनका प्रधान शदेऊर का पुत्र एलीसूर होगा, ");
INSERT INTO hin2017_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","और उनके दल के गिने हुए पुरुष साढ़े छियालीस हजार हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","उनके पास जो डेरे खड़े किया करें वे शिमोन के गोत्र के होंगे, और उनका प्रधान सूरीशद्दै का पुत्र शलूमीएल होगा, ");
INSERT INTO hin2017_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","और उनके दल के गिने हुए पुरुष उनसठ हजार तीन सौ हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","फिर गाद के गोत्र के रहें, और उनका प्रधान रूएल का पुत्र एल्यासाप होगा, ");
INSERT INTO hin2017_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","और उनके दल के गिने हुए पुरुष पैंतालीस हजार साढ़े छः सौ हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","रूबेन की छावनी में जितने अपने-अपने दलों के अनुसार गिने गए वे सब मिलकर एक लाख इक्यावन हजार साढ़े चार सौ हैं। दूसरा कूच इनका हो। ");
INSERT INTO hin2017_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“उनके पीछे और सब छावनियों के बीचों बीच लेवियों की छावनी समेत मिलापवाले तम्बू का कूच हुआ करे; जिस क्रम से वे डेरे खड़े करें उसी क्रम से वे अपने-अपने स्थान पर अपने-अपने झण्डे के पास-पास चलें। ");
INSERT INTO hin2017_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“पश्चिम की ओर एप्रैम की छावनी के झण्डे के लोग अपने-अपने दलों के अनुसार रहें, और उनका प्रधान अम्मीहूद का पुत्र एलीशामा होगा, ");
INSERT INTO hin2017_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","और उनके दल के गिने हुए पुरुष साढ़े चालीस हजार हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","उनके समीप मनश्शे के गोत्र के रहें, और उनका प्रधान पदासूर का पुत्र गम्लीएल होगा, ");
INSERT INTO hin2017_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","और उनके दल के गिने हुए पुरुष बत्तीस हजार दो सौ हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","फिर बिन्यामीन के गोत्र के रहें, और उनका प्रधान गिदोनी का पुत्र अबीदान होगा, ");
INSERT INTO hin2017_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","और उनके दल के गिने हुए पुरुष पैंतीस हजार चार सौ हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","एप्रैम की छावनी में जितने अपने-अपने दलों के अनुसार गिने गए वे सब मिलकर एक लाख आठ हजार एक सौ पुरुष हैं। तीसरा कूच इनका हो। ");
INSERT INTO hin2017_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“उत्तर की ओर दान की छावनी के झण्डे के लोग अपने-अपने दलों के अनुसार रहें, और उनका प्रधान अम्मीशद्दै का पुत्र अहीएजेर होगा, ");
INSERT INTO hin2017_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","और उनके दल के गिने हुए पुरुष बासठ हजार सात सौ हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","और उनके पास जो डेरे खड़े करें वे आशेर के गोत्र के रहें, और उनका प्रधान ओक्रान का पुत्र पगीएल होगा, ");
INSERT INTO hin2017_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","और उनके दल के गिने हुए पुरुष साढ़े इकतालीस हजार हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","फिर नप्ताली के गोत्र के रहें, और उनका प्रधान एनान का पुत्र अहीरा होगा, ");
INSERT INTO hin2017_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","और उनके दल के गिने हुए पुरुष तिरपन हजार चार सौ हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","और दान की छावनी में जितने गिने गए वे सब मिलकर एक लाख सत्तावन हजार छः सौ हैं। ये अपने-अपने झण्डे के पास-पास होकर सबसे पीछे कूच करें।” ");
INSERT INTO hin2017_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","इस्राएलियों में से जो अपने-अपने पितरों के घराने के अनुसार गिने गए वे ये ही हैं; और सब छावनियों के जितने पुरुष अपने-अपने दलों के अनुसार गिने गए वे सब मिलकर छः लाख तीन हजार साढ़े पाँच सौ थे। ");
INSERT INTO hin2017_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","परन्तु यहोवा ने मूसा को जो आज्ञा दी थी उसके अनुसार लेवीय तो इस्राएलियों में गिने नहीं गए। ");
INSERT INTO hin2017_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","इस प्रकार जो-जो आज्ञा यहोवा ने मूसा को दी थी, इस्राएली उन आज्ञाओं के अनुसार अपने-अपने कुल और अपने-अपने पितरों के घरानों के अनुसार, अपने-अपने झण्डे के पास डेरे खड़े करते और कूच भी करते थे। ");
INSERT INTO hin2017_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","जिस समय यहोवा ने सीनै पर्वत के पास मूसा से बातें की उस समय हारून और मूसा की यह वंशावली थी। ");
INSERT INTO hin2017_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","हारून के पुत्रों के नाम ये हैं नादाब जो उसका जेठा था, और अबीहू, एलीआजर और ईतामार; ");
INSERT INTO hin2017_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","हारून के पुत्र, जो अभिषिक्त याजक थे, और उनका संस्कार याजक का काम करने के लिये हुआ था, उनके नाम ये हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","नादाब और अबीहू जिस समय सीनै के जंगल में यहोवा के सम्मुख अनुचित आग ले गए उसी समय यहोवा के सामने मर गए थे; और वे पुत्रहीन भी थे। एलीआजर और ईतामार अपने पिता हारून के साथ याजक का काम करते रहे। ");
INSERT INTO hin2017_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“लेवी गोत्रवालों को समीप ले आकर हारून याजक के सामने खड़ा कर कि वे उसकी सहायता करें। ");
INSERT INTO hin2017_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","जो कुछ उसकी ओर से और सारी मण्डली की ओर से उन्हें सौंपा जाए उसकी देख-रेख वे मिलापवाले तम्बू के सामने करें, इस प्रकार वे तम्बू की सेवा करें; ");
INSERT INTO hin2017_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","वे मिलापवाले तम्बू के सम्पूर्ण सामान की और इस्राएलियों की सौंपी हुई वस्तुओं की भी देख-रेख करें, इस प्रकार वे निवास-स्थान की सेवा करें। ");
INSERT INTO hin2017_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","और तू लेवियों को हारून और उसके पुत्रों को सौंप दे; और वे इस्राएलियों की ओर से हारून को सम्पूर्ण रीति से अर्पण किए हुए हों। ");
INSERT INTO hin2017_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","और हारून और उसके पुत्रों को याजक के पद पर नियुक्त कर, और वे अपने याजकपद को सम्भालें; और यदि परदेशी समीप आए, तो वह मार डाला जाए।” ");
INSERT INTO hin2017_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“सुन इस्राएली स्त्रियों के सब पहिलौठों के बदले, मैं इस्राएलियों में से लेवियों को ले लेता हूँ; इसलिए लेवीय मेरे ही हों। ");
INSERT INTO hin2017_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","सब पहलौठे मेरे हैं; क्योंकि जिस दिन मैंने मिस्र देश के सब पहिलौठों को मारा, उसी दिन मैंने क्या मनुष्य क्या पशु इस्राएलियों के सब पहिलौठों को अपने लिये पवित्र ठहराया; इसलिए वे मेरे ही ठहरेंगे; मैं यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","फिर यहोवा ने सीनै के जंगल में मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“लेवियों में से जितने पुरुष एक महीने या उससे अधिक आयु के हों उनको उनके पितरों के घरानों और उनके कुलों के अनुसार गिन ले।” ");
INSERT INTO hin2017_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","यह आज्ञा पाकर मूसा ने यहोवा के कहे अनुसार उनको गिन लिया। ");
INSERT INTO hin2017_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","लेवी के पुत्रों के नाम ये हैं, अर्थात् गेर्शोन, कहात, और मरारी। ");
INSERT INTO hin2017_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","और गेर्शोन के पुत्र जिनसे उसके कुल चले उनके नाम ये हैं, अर्थात् लिब्नी और शिमी। ");
INSERT INTO hin2017_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","कहात के पुत्र जिनसे उसके कुल चले उनके नाम ये हैं, अर्थात् अम्राम, यिसहार, हेब्रोन, और उज्जीएल। ");
INSERT INTO hin2017_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","और मरारी के पुत्र जिनसे उसके कुल चले ये हैं, अर्थात् महली और मूशी। ये लेवियों के कुल अपने पितरों के घरानों के अनुसार हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","गेर्शोन से लिब्नियों और शिमियों के कुल चले; गेर्शोनवंशियों के कुल ये ही हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","इनमें से जितने पुरुषों की आयु एक महीने की या उससे अधिक थी, उन सभी की गिनती साढ़े सात हजार थी। ");
INSERT INTO hin2017_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","गेर्शोनवाले कुल निवास के पीछे पश्चिम की ओर अपने डेरे डाला करें; ");
INSERT INTO hin2017_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","और गेर्शोनियों के मूलपुरुष के घराने का प्रधान लाएल का पुत्र एल्यासाप हो। ");
INSERT INTO hin2017_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","और मिलापवाले तम्बू की जो वस्तुएँ गेर्शोनवंशियों को सौंपी जाएँ वे ये हों, अर्थात् निवास और तम्बू, और उसका आवरण, और मिलापवाले तम्बू के द्वार का परदा, ");
INSERT INTO hin2017_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","और जो आँगन निवास और वेदी के चारों ओर है उसके पर्दे, और उसके द्वार का परदा, और सब डोरियाँ जो उसमें काम आती हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","फिर कहात से अम्रामियों, यिसहारियों, हेब्रोनियों, और उज्जीएलियों के कुल चले; कहातियों के कुल ये ही हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","उनमें से जितने पुरुषों की आयु एक महीने की या उससे अधिक थी उनकी गिनती आठ हजार छः सौ थी। उन पर पवित्रस्थान की देख-रेख का उत्तरदायित्व था। ");
INSERT INTO hin2017_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","कहातियों के कुल निवास-स्थान की उस ओर अपने डेरे डाला करें जो दक्षिण की ओर है; ");
INSERT INTO hin2017_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","और कहातियों के मूलपुरुष के घराने का प्रधान उज्जीएल का पुत्र एलीसापान हो। ");
INSERT INTO hin2017_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","और जो वस्तुएँ उनको सौंपी जाएँ वे सन्दूक, मेज, दीवट, वेदियाँ, और पवित्रस्थान का वह सामान जिससे सेवा टहल होती है, और परदा; अर्थात् पवित्रस्थान में काम में आनेवाला सारा सामान हो। ");
INSERT INTO hin2017_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","और लेवियों के प्रधानों का प्रधान हारून याजक का पुत्र एलीआजर हो, और जो लोग पवित्रस्थान की सौंपी हुई वस्तुओं की देख-रेख करेंगे उन पर वही मुखिया ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","फिर मरारी से महलियों और मूशियों के कुल चले; मरारी के कुल ये ही हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","इनमें से जितने पुरुषों की आयु एक महीने की या उससे अधिक थी उन सभी की गिनती छः हजार दो सौ थी। ");
INSERT INTO hin2017_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","और मरारी के कुलों के मूलपुरुष के घराने का प्रधान अबीहैल का पुत्र सूरीएल हो; ये लोग निवास के उत्तर की ओर अपने डेरे खड़े करें। ");
INSERT INTO hin2017_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","और जो वस्तुएँ मरारीवंशियों को सौंपी जाएँ कि वे उनकी देख-रेख करें, वे निवास के तख्ते, बेंड़े, खम्भे, कुर्सियाँ, और सारा सामान; निदान जो कुछ उसके लगाने में काम आए; ");
INSERT INTO hin2017_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","और चारों ओर के आँगन के खम्भे, और उनकी कुर्सियाँ, खूँटे और डोरियाँ हों। ");
INSERT INTO hin2017_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","और जो मिलापवाले तम्बू के सामने, अर्थात् निवास के सामने, पूर्व की ओर जहाँ से सूर्योदय होता है, अपने डेरे डाला करें, वे मूसा और हारून और उसके पुत्रों के डेरे हों, और पवित्रस्थान की देख-रेख इस्राएलियों के बदले वे ही किया करें, और दूसरा जो कोई उसके समीप आए वह मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","यहोवा की इस आज्ञा को पाकर एक महीने की या उससे अधिक आयु वाले जितने लेवीय पुरुषों को मूसा और हारून ने उनके कुलों के अनुसार गिना, वे सब के सब बाईस हजार थे। ");
INSERT INTO hin2017_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","फिर यहोवा ने मूसा से कहा, “इस्राएलियों के जितने पहलौठे पुरुषों की आयु एक महीने की या उससे अधिक है, उन सभी को नाम ले लेकर गिन ले। ");
INSERT INTO hin2017_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","और मेरे लिये इस्राएलियों के सब पहिलौठों के बदले लेवियों को, और इस्राएलियों के पशुओं के सब पहिलौठों के बदले लेवियों के पशुओं को ले; मैं यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","यहोवा की इस आज्ञा के अनुसार मूसा ने इस्राएलियों के सब पहिलौठों को गिन लिया। ");
INSERT INTO hin2017_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","और सब पहलौठे पुरुष जिनकी आयु एक महीने की या उससे अधिक थी, उनके नामों की गिनती बाईस हजार दो सौ तिहत्तर थी। ");
INSERT INTO hin2017_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“इस्राएलियों के सब पहिलौठों के बदले लेवियों को, और उनके पशुओं के बदले लेवियों के पशुओं को ले; और लेवीय मेरे ही हों; मैं यहोवा हूँ। ");
INSERT INTO hin2017_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","और इस्राएलियों के पहिलौठों में से जो दो सौ तिहत्तर गिनती में लेवियों से अधिक हैं, उनके छुड़ाने के लिये, ");
INSERT INTO hin2017_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","पुरुष पाँच शेकेल ले; वे पवित्रस्थान के शेकेल के हिसाब से हों, अर्थात् बीस गेरा का शेकेल हो। ");
INSERT INTO hin2017_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","और जो रुपया उन अधिक पहिलौठों की छुड़ौती का होगा उसे हारून और उसके पुत्रों को दे देना।” ");
INSERT INTO hin2017_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","अतः जो इस्राएली पहलौठे लेवियों के द्वारा छुड़ाए हुओं से अधिक थे उनके हाथ से मूसा ने छुड़ौती का रुपया लिया। ");
INSERT INTO hin2017_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","और एक हजार तीन सौ पैंसठ शेकेल रुपया पवित्रस्थान के शेकेल के हिसाब से वसूल हुआ। ");
INSERT INTO hin2017_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","और यहोवा की आज्ञा के अनुसार मूसा ने छुड़ाए हुओं का रुपया हारून और उसके पुत्रों को दे दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","फिर यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“लेवियों में से कहातियों की, उनके कुलों और पितरों के घरानों के अनुसार, गिनती करो, ");
INSERT INTO hin2017_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","अर्थात् तीस वर्ष से लेकर पचास वर्ष तक की आयु वालों में, जितने मिलापवाले तम्बू में काम-काज करने को भर्ती हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","और मिलापवाले तम्बू में परमपवित्र वस्तुओं के विषय कहातियों का यह काम होगा, ");
INSERT INTO hin2017_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","अर्थात् जब जब छावनी का कूच हो तब-तब हारून और उसके पुत्र भीतर आकर, बीचवाले पर्दे को उतार कर उससे साक्षीपत्र के सन्दूक को ढाँप दें; ");
INSERT INTO hin2017_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","तब वे उस पर सुइसों की खालों का आवरण डालें, और उसके ऊपर सम्पूर्ण नीले रंग का कपड़ा डालें, और सन्दूक में डंडों को लगाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","फिर भेंटवाली रोटी की मेज पर नीला कपड़ा बिछाकर उस पर परातों, धूपदानों, करछों, और उण्डेलने के कटोरों को रखें; और प्रतिदिन की रोटी भी उस पर हो; ");
INSERT INTO hin2017_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","तब वे उन पर लाल रंग का कपड़ा बिछाकर उसको सुइसों की खालों के आवरण से ढाँपें, और मेज के डंडों को लगा दें। ");
INSERT INTO hin2017_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","फिर वे नीले रंग का कपड़ा लेकर दीपकों, गुलतराशों, और गुलदानों समेत उजियाला देनेवाले दीवट को, और उसके सब तेल के पात्रों को, जिनसे उसकी सेवा टहल होती है, ढाँपें; ");
INSERT INTO hin2017_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","तब वे सारे सामान समेत दीवट को सुइसों की खालों के आवरण के भीतर रखकर डंडे पर धर दें। ");
INSERT INTO hin2017_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","फिर वे सोने की वेदी पर एक नीला कपड़ा बिछाकर उसको सुइसों की खालों के आवरण से ढाँपें, और उसके डंडों को लगा दें; ");
INSERT INTO hin2017_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","तब वे सेवा टहल के सारे सामान को लेकर, जिससे पवित्रस्थान में सेवा टहल होती है, नीले कपड़े के भीतर रखकर सुइसों की खालों के आवरण से ढाँपें, और डंडे पर धर दें। ");
INSERT INTO hin2017_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","फिर वे वेदी पर से सब राख उठाकर वेदी पर बैंगनी रंग का कपड़ा बिछाएँ; ");
INSERT INTO hin2017_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","तब जिस सामान से वेदी पर की सेवा टहल होती है वह सब, अर्थात् उसके करछे, काँटे, फावड़ियाँ, और कटोरे आदि, वेदी का सारा सामान उस पर रखें; और उसके ऊपर सुइसों की खालों का आवरण बिछाकर वेदी में डंडों को लगाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","और जब हारून और उसके पुत्र छावनी के कूच के समय पवित्रस्थान और उसके सारे सामान को ढाँप चुकें, तब उसके बाद कहाती उसके उठाने के लिये आएँ, पर किसी पवित्र वस्तु को न छूएँ, कहीं ऐसा न हो कि मर जाएँ। कहातियों के उठाने के लिये मिलापवाले तम्बू की ये ही वस्तुएँ हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“जो वस्तुएँ हारून याजक के पुत्र एलीआजर को देख-रेख के लिये सौंपी जाएँ वे ये हैं, अर्थात् उजियाला देने के लिये तेल, और सुगन्धित धूप, और नित्य अन्नबलि, और अभिषेक का तेल, और सारे निवास, और उसमें की सब वस्तुएँ, और पवित्रस्थान और उसके सम्पूर्ण सामान।” ");
INSERT INTO hin2017_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","फिर यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“कहातियों के कुलों के गोत्रों को लेवियों में से नाश न होने देना; ");
INSERT INTO hin2017_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","उसके साथ ऐसा करो, कि जब वे परमपवित्र वस्तुओं के समीप आएँ, तब न मरें परन्तु जीवित रहें; इस कारण हारून और उसके पुत्र भीतर आकर एक-एक के लिये उसकी सेवकाई और उसका भार ठहरा दें, ");
INSERT INTO hin2017_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","और वे पवित्र वस्तुओं के देखने को क्षण भर के लिये भी भीतर आने न पाएँ, कहीं ऐसा न हो कि मर जाएँ।” ");
INSERT INTO hin2017_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“गेर्शोनियों की भी गिनती उनके पितरों के घरानों और कुलों के अनुसार कर; ");
INSERT INTO hin2017_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","तीस वर्ष से लेकर पचास वर्ष तक की आयु वाले, जितने मिलापवाले तम्बू में सेवा करने को भर्ती हों उन सभी को गिन ले। ");
INSERT INTO hin2017_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","सेवा करने और भार उठाने में गेर्शोनियों के कुलवालों की यह सेवकाई हो; ");
INSERT INTO hin2017_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","अर्थात् वे निवास के पटों, और मिलापवाले तम्बू और उसके आवरण, और इसके ऊपरवाले सुइसों की खालों के आवरण, और मिलापवाले तम्बू के द्वार के पर्दे, ");
INSERT INTO hin2017_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","और निवास, और वेदी के चारों ओर के आँगन के पर्दों, और आँगन के द्वार के पर्दे, और उनकी डोरियों, और उनमें काम में आनेवाले सारे सामान, इन सभी को वे उठाया करें; और इन वस्तुओं से जितना काम होता है वह सब भी उनकी सेवकाई में आए। ");
INSERT INTO hin2017_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","और गेर्शोनियों के वंश की सारी सेवकाई हारून और उसके पुत्रों के कहने से हुआ करे, अर्थात् जो कुछ उनको उठाना, और जो-जो सेवकाई उनको करनी हो, उनका सारा भार तुम ही उन्हें सौंपा करो। ");
INSERT INTO hin2017_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","मिलापवाले तम्बू में गेर्शोनियों के कुलों की यही सेवकाई ठहरे; और उन पर हारून याजक का पुत्र ईतामार अधिकार रखे। ");
INSERT INTO hin2017_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“फिर मरारियों को भी तू उनके कुलों और पितरों के घरानों के अनुसार गिन लें; ");
INSERT INTO hin2017_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","तीस वर्ष से लेकर पचास वर्ष तक की आयु वाले, जितने मिलापवाले तम्बू की सेवा करने को भर्ती हों, उन सभी को गिन ले। ");
INSERT INTO hin2017_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","और मिलापवाले तम्बू में की जिन वस्तुओं के उठाने की सेवकाई उनको मिले वे ये हों, अर्थात् निवास के तख्ते, बेंड़े, खम्भे, और कुर्सियाँ, ");
INSERT INTO hin2017_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","और चारों ओर आँगन के खम्भे, और इनकी कुर्सियाँ, खूँटे, डोरियाँ, और भाँति-भाँति के काम का सारा सामान ढोने के लिये उनको सौंपा जाए उसमें से एक-एक वस्तु का नाम लेकर तुम गिन लो। ");
INSERT INTO hin2017_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","मरारियों के कुलों की सारी सेवकाई जो उन्हें मिलापवाले तम्बू के विषय करनी होगी वह यही है; वह हारून याजक के पुत्र ईतामार के अधिकार में रहे।” ");
INSERT INTO hin2017_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","तब मूसा और हारून और मण्डली के प्रधानों ने कहातियों के वंश को, उनके कुलों और पितरों के घरानों के अनुसार, ");
INSERT INTO hin2017_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","तीस वर्ष से लेकर पचास वर्ष की आयु के, जितने मिलापवाले तम्बू की सेवकाई करने को भर्ती हुए थे, उन सभी को गिन लिया; ");
INSERT INTO hin2017_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","और जो अपने-अपने कुल के अनुसार गिने गए, वे दो हजार साढ़े सात सौ थे। ");
INSERT INTO hin2017_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","कहातियों के कुलों में से जितने मिलापवाले तम्बू में सेवा करनेवाले गिने गए, वे इतने ही थे; जो आज्ञा यहोवा ने मूसा के द्वारा दी थी उसी के अनुसार मूसा और हारून ने इनको गिन लिया। ");
INSERT INTO hin2017_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","गेर्शोनियों में से जो अपने कुलों और पितरों के घरानों के अनुसार गिने गए, ");
INSERT INTO hin2017_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","अर्थात् तीस वर्ष से लेकर पचास वर्ष तक की आयु के, जो मिलापवाले तम्बू की सेवकाई करने को दल में भर्ती हुए थे, ");
INSERT INTO hin2017_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","उनकी गिनती उनके कुलों और पितरों के घरानों के अनुसार दो हजार छः सौ तीस थी। ");
INSERT INTO hin2017_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","गेर्शोनियों के कुलों में से जितने मिलापवाले तम्बू में सेवा करनेवाले गिने गए, वे इतने ही थे; यहोवा की आज्ञा के अनुसार मूसा और हारून ने इनको गिन लिया। ");
INSERT INTO hin2017_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","फिर मरारियों के कुलों में से जो अपने कुलों और पितरों के घरानों के अनुसार गिने गए, ");
INSERT INTO hin2017_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","अर्थात् तीस वर्ष से लेकर पचास वर्ष तक की आयु के, जो मिलापवाले तम्बू की सेवकाई करने को भर्ती हुए थे, ");
INSERT INTO hin2017_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","उनकी गिनती उनके कुलों के अनुसार तीन हजार दो सौ थी। ");
INSERT INTO hin2017_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","मरारियों के कुलों में से जिनको मूसा और हारून ने, यहोवा की उस आज्ञा के अनुसार जो मूसा के द्वारा मिली थी, गिन लिया वे इतने ही थे। ");
INSERT INTO hin2017_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","लेवियों में से जिनको मूसा और हारून और इस्राएली प्रधानों ने उनके कुलों और पितरों के घरानों के अनुसार गिन लिया, ");
INSERT INTO hin2017_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","अर्थात् तीस वर्ष से लेकर पचास वर्ष तक की आयु वाले, जितने मिलापवाले तम्बू की सेवकाई करने और बोझ उठाने का काम करने को हाजिर होनेवाले थे, ");
INSERT INTO hin2017_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","उन सभी की गिनती आठ हजार पाँच सौ अस्सी थी। ");
INSERT INTO hin2017_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ये अपनी-अपनी सेवा और बोझ ढोने के लिए यहोवा के कहने पर गए। जो आज्ञा यहोवा ने मूसा को दी थी उसी के अनुसार वे गिने गए। ");
INSERT INTO hin2017_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“इस्राएलियों को आज्ञा दे, कि वे सब कोढ़ियों को, और जितनों के प्रमेह हो, और जितने लोथ के कारण अशुद्ध हों, उन सभी को छावनी से निकाल दें; ");
INSERT INTO hin2017_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ऐसों को चाहे पुरुष हों, चाहे स्त्री, छावनी से निकालकर बाहर कर दें; कहीं ऐसा न हो कि तुम्हारी छावनी, जिसके बीच मैं निवास करता हूँ, उनके कारण अशुद्ध हो जाए।” ");
INSERT INTO hin2017_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","और इस्राएलियों ने वैसा ही किया, अर्थात् ऐसे लोगों को छावनी से निकालकर बाहर कर दिया; जैसा यहोवा ने मूसा से कहा था इस्राएलियों ने वैसा ही किया। ");
INSERT INTO hin2017_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“इस्राएलियों से कह कि जब कोई पुरुष या स्त्री ऐसा कोई पाप करके जो लोग किया करते हैं यहोवा से विश्वासघात करे, और वह मनुष्य दोषी हो, ");
INSERT INTO hin2017_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","तब वह अपना किया हुआ पाप मान ले; और पूरी क्षतिपूर्ति में पाँचवाँ अंश बढ़ाकर अपने दोष के बदले में उसी को दे, जिसके विषय दोषी हुआ हो। ");
INSERT INTO hin2017_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","परन्तु यदि उस मनुष्य का कोई कुटुम्बी न हो जिसे दोष का बदला भर दिया जाए, तो उस दोष का जो बदला यहोवा को भर दिया जाए वह याजक का हो, और वह उस प्रायश्चितवाले मेढ़े से अधिक हो जिससे उसके लिये प्रायश्चित किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","और जितनी पवित्र की हुई वस्तुएँ इस्राएली उठाई हुई भेंट करके याजक के पास लाएँ, वे उसी की हों; ");
INSERT INTO hin2017_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","सब मनुष्यों की पवित्र की हुई वस्तुएँ याजक की ठहरें; कोई जो कुछ याजक को दे वह उसका ठहरे।” ");
INSERT INTO hin2017_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“इस्राएलियों से कह, कि यदि किसी मनुष्य की स्त्री बुरी चाल चलकर उससे विश्वासघात करे, ");
INSERT INTO hin2017_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","और कोई पुरुष उसके साथ कुकर्म करे, परन्तु यह बात उसके पति से छिपी हो और खुली न हो, और वह अशुद्ध हो गई, परन्तु न तो उसके विरुद्ध कोई साक्षी हो, और न कुकर्म करते पकड़ी गई हो; ");
INSERT INTO hin2017_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","और उसके पति के मन में संदेह उत्पन्न हो, अर्थात् वह अपनी स्त्री पर जलने लगे और वह अशुद्ध हुई हो; या उसके मन में जलन उत्पन्न हो, अर्थात् वह अपनी स्त्री पर जलने लगे परन्तु वह अशुद्ध न हुई हो; ");
INSERT INTO hin2017_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","तो वह पुरुष अपनी स्त्री को याजक के पास ले जाए, और उसके लिये एपा का दसवाँ अंश जौ का मैदा चढ़ावा करके ले आए; परन्तु उस पर तेल न डाले, न लोबान रखे, क्योंकि वह जलनवाला और स्मरण दिलानेवाला, अर्थात् अधर्म का स्मरण करानेवाला अन्नबलि होगा। ");
INSERT INTO hin2017_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“तब याजक उस स्त्री को समीप ले जाकर यहोवा के सामने खड़ा करे; ");
INSERT INTO hin2017_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","और याजक मिट्टी के पात्र में पवित्र जल ले, और निवास-स्थान की भूमि पर की धूल में से कुछ लेकर उस जल में डाल दे। ");
INSERT INTO hin2017_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","तब याजक उस स्त्री को यहोवा के सामने खड़ा करके उसके सिर के बाल बिखराए, और स्मरण दिलानेवाले अन्नबलि को जो जलनवाला है उसके हाथों पर धर दे। और अपने हाथ में याजक कड़वा जल लिये रहे जो श्राप लगाने का कारण होगा। ");
INSERT INTO hin2017_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","तब याजक स्त्री को शपथ धरवाकर कहे, कि यदि किसी पुरुष ने तुझ से कुकर्म न किया हो, और तू पति को छोड़ दूसरे की ओर फिरके अशुद्ध न हो गई हो, तो तू इस कड़वे जल के गुण से जो श्राप का कारण होता है बची रहे। ");
INSERT INTO hin2017_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","पर यदि तू अपने पति को छोड़ दूसरे की ओर फिरके अशुद्ध हुई हो, और तेरे पति को छोड़ किसी दूसरे पुरुष ने तुझ से प्रसंग किया हो, ");
INSERT INTO hin2017_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(और याजक उसे श्राप देनेवाली शपथ धराकर कहे,) यहोवा तेरी जाँघ सड़ाए और तेरा पेट फुलाए, और लोग तेरा नाम लेकर श्राप और धिक्कार दिया करें; ");
INSERT INTO hin2017_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","अर्थात् वह जल जो श्राप का कारण होता है तेरी अंतड़ियों में जाकर तेरे पेट को फुलाए, और तेरी जाँघ को सड़ा दे। तब वह स्त्री कहे, आमीन, आमीन। ");
INSERT INTO hin2017_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“तब याजक श्राप के ये शब्द पुस्तक में लिखकर उस कड़वे जल से मिटाकर, ");
INSERT INTO hin2017_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","उस स्त्री को वह कड़वा जल पिलाए जो श्राप का कारण होता है, और वह जल जो श्राप का कारण होगा उस स्त्री के पेट में जाकर कड़वा हो जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","और याजक स्त्री के हाथ में से जलनवाले अन्नबलि को लेकर यहोवा के आगे हिलाकर वेदी के समीप पहुँचाए; ");
INSERT INTO hin2017_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","और याजक उस अन्नबलि में से उसका स्मरण दिलानेवाला भाग, अर्थात् मुट्ठी भर लेकर वेदी पर जलाए, और उसके बाद स्त्री को वह जल पिलाए। ");
INSERT INTO hin2017_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","और जब वह उसे वह जल पिला चुके, तब यदि वह अशुद्ध हुई हो और अपने पति का विश्वासघात किया हो, तो वह जल जो श्राप का कारण होता है उस स्त्री के पेट में जाकर कड़वा हो जाएगा, और उसका पेट फूलेगा, और उसकी जाँघ सड़ जाएगी, और उस स्त्री का नाम उसके लोगों के बीच श्रापित होगा। ");
INSERT INTO hin2017_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","पर यदि वह स्त्री अशुद्ध न हुई हो और शुद्ध ही हो, तो वह निर्दोष ठहरेगी और गर्भवती हो सकेगी। ");
INSERT INTO hin2017_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“जलन की व्यवस्था यही है, चाहे कोई स्त्री अपने पति को छोड़ दूसरे की ओर फिरके अशुद्ध हो, ");
INSERT INTO hin2017_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","चाहे पुरुष के मन में जलन उत्पन्न हो और वह अपनी स्त्री पर जलने लगे; तो वह उसको यहोवा के सम्मुख खड़ा कर दे, और याजक उस पर यह सारी व्यवस्था पूरी करे। ");
INSERT INTO hin2017_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","तब पुरुष अधर्म से बचा रहेगा, और स्त्री अपने अधर्म का बोझ आप उठाएगी।” ");
INSERT INTO hin2017_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“इस्राएलियों से कह कि जब कोई पुरुष या स्त्री नाज़ीर की मन्नत, अर्थात् अपने को यहोवा के लिये अलग करने की विशेष मन्नत माने, ");
INSERT INTO hin2017_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","तब वह दाखमधु और मदिरा से अलग रहे; वह न दाखमधु का, और न मदिरा का सिरका पीए, और न दाख का कुछ रस भी पीए, वरन् दाख न खाए, चाहे हरी हो चाहे सूखी। (लूका 1:15) ");
INSERT INTO hin2017_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","जितने दिन यह अलग रहे उतने दिन तक वह बीज से लेकर छिलके तक, जो कुछ दाखलता से उत्पन्न होता है, उसमें से कुछ न खाए। ");
INSERT INTO hin2017_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“फिर जितने दिन उसने अलग रहने की मन्नत मानी हो उतने दिन तक वह अपने सिर पर छुरा न फिराए; और जब तक वे दिन पूरे न हों जिनमें वह यहोवा के लिये अलग रहे तब तक वह पवित्र ठहरेगा, और अपने सिर के बालों को बढ़ाए रहे। (प्रेरि. 21:23, 24:2) ");
INSERT INTO hin2017_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","जितने दिन वह यहोवा के लिये अलग रहे उतने दिन तक किसी लोथ के पास न जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","चाहे उसका पिता, या माता, या भाई, या बहन भी मरे, तो भी वह उनके कारण अशुद्ध न हो; क्योंकि अपने परमेश्वर के लिये अलग रहने का चिन्ह उसके सिर पर होगा। ");
INSERT INTO hin2017_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","अपने अलग रहने के सारे दिनों में वह यहोवा के लिये पवित्र ठहरा रहे। ");
INSERT INTO hin2017_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“यदि कोई उसके पास अचानक मर जाए, और उसके अलग रहने का जो चिन्ह उसके सिर पर होगा वह अशुद्ध हो जाए, तो वह शुद्ध होने के दिन, अर्थात् सातवें दिन अपना सिर मुँड़ाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","और आठवें दिन वह दो पंडुक या कबूतरी के दो बच्चे मिलापवाले तम्बू के द्वार पर याजक के पास ले जाए, ");
INSERT INTO hin2017_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","और याजक एक को पापबलि, और दूसरे को होमबलि करके उसके लिये प्रायश्चित करे, क्योंकि वह लोथ के कारण पापी ठहरा है। और याजक उसी दिन उसका सिर फिर पवित्र करे, ");
INSERT INTO hin2017_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","और वह अपने अलग रहने के दिनों को फिर यहोवा के लिये अलग ठहराए, और एक वर्ष का एक भेड़ का बच्चा दोषबलि करके ले आए; और जो दिन इससे पहले बीत गए हों वे व्यर्थ गिने जाएँ, क्योंकि उसके अलग रहने का चिन्ह अशुद्ध हो गया। ");
INSERT INTO hin2017_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“फिर जब नाज़ीर के अलग रहने के दिन पूरे हों, उस समय के लिये उसकी यह व्यवस्था है; अर्थात् वह मिलापवाले तम्बू के द्वार पर पहुँचाया जाए, ");
INSERT INTO hin2017_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","और वह यहोवा के लिये होमबलि करके एक वर्ष का एक निर्दोष भेड़ का बच्चा पापबलि करके, और एक वर्ष की एक निर्दोष भेड़ की बच्ची, और मेलबलि के लिये एक निर्दोष मेढ़ा, ");
INSERT INTO hin2017_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","और अख़मीरी रोटियों की एक टोकरी, अर्थात् तेल से सने हुए मैदे के फुलके, और तेल से चुपड़ी हुई अख़मीरी पपड़ियाँ, और उन बलियों के अन्नबलि और अर्घ; ये सब चढ़ावे समीप ले जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","इन सब को याजक यहोवा के सामने पहुँचाकर उसके पापबलि और होमबलि को चढ़ाए, ");
INSERT INTO hin2017_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","और अख़मीरी रोटी की टोकरी समेत मेढ़े को यहोवा के लिये मेलबलि करके, और उस मेलबलि के अन्नबलि और अर्घ को भी चढ़ाए। ");
INSERT INTO hin2017_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","तब नाज़ीर अपने अलग रहने के चिन्हवाले सिर को मिलापवाले तम्बू के द्वार पर मुँड़ाकर अपने बालों को उस आग पर डाल दे जो मेलबलि के नीचे होगी। ");
INSERT INTO hin2017_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","फिर जब नाज़ीर अपने अलग रहने के चिन्हवाले सिर को मुँड़ा चुके तब याजक मेढ़े का पकाया हुआ कंधा, और टोकरी में से एक अख़मीरी रोटी, और एक अख़मीरी पपड़ी लेकर नाज़ीर के हाथों पर धर दे, ");
INSERT INTO hin2017_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","और याजक इनको हिलाने की भेंट करके यहोवा के सामने हिलाए; हिलाई हुई छाती और उठाई हुई जाँघ समेत ये भी याजक के लिये पवित्र ठहरें; इसके बाद वह नाज़ीर दाखमधु पी सकेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“नाज़ीर की मन्नत की, और जो चढ़ावा उसको अपने अलग होने के कारण यहोवा के लिये चढ़ाना होगा उसकी भी यही व्यवस्था है। जो चढ़ावा वह अपनी पूँजी के अनुसार चढ़ा सके, उससे अधिक जैसी मन्नत उसने मानी हो, वैसे ही अपने अलग रहने की व्यवस्था के अनुसार उसे करना होगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“हारून और उसके पुत्रों से कह कि तुम इस्राएलियों को इन वचनों से आशीर्वाद दिया करना: ");
INSERT INTO hin2017_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“यहोवा तुझे आशीष दे और तेरी रक्षा करे: ");
INSERT INTO hin2017_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","“यहोवा तुझ पर अपने मुख का प्रकाश चमकाए, और तुझ पर अनुग्रह करे: ");
INSERT INTO hin2017_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","“यहोवा अपना मुख तेरी ओर करे, और तुझे शान्ति दे। ");
INSERT INTO hin2017_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“इस रीति से मेरे नाम को इस्राएलियों पर रखें, और मैं उन्हें आशीष दिया करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","फिर जब मूसा ने निवास को खड़ा किया, और सारे सामान समेत उसका अभिषेक करके उसको पवित्र किया, और सारे सामान समेत वेदी का भी अभिषेक करके उसे पवित्र किया, ");
INSERT INTO hin2017_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","तब इस्राएल के प्रधान जो अपने-अपने पितरों के घरानों के मुख्य पुरुष, और गोत्रों के भी प्रधान होकर गिनती लेने के काम पर नियुक्त थे, ");
INSERT INTO hin2017_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","वे यहोवा के सामने भेंट ले आए, और उनकी भेंट छः भरी हुई गाड़ियाँ और बारह बैल थे, अर्थात् दो-दो प्रधान की ओर से एक-एक गाड़ी, और एक-एक प्रधान की ओर से एक-एक बैल; इन्हें वे निवास के सामने यहोवा के समीप ले गए। ");
INSERT INTO hin2017_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“उन वस्तुओं को तू उनसे ले ले, कि मिलापवाले तम्बू की सेवकाई में काम आएँ, तू उन्हें लेवियों के एक-एक कुल की विशेष सेवकाई के अनुसार उनको बाँट दे।” ");
INSERT INTO hin2017_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","अतः मूसा ने वे सब गाड़ियाँ और बैल लेकर लेवियों को दे दिये। ");
INSERT INTO hin2017_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","गेर्शोनियों को उनकी सेवकाई के अनुसार उसने दो गाड़ियाँ और चार बैल दिए; ");
INSERT INTO hin2017_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","और मरारियों को उनकी सेवकाई के अनुसार उसने चार गाड़ियाँ और आठ बैल दिए; ये सब हारून याजक के पुत्र ईतामार के अधिकार में किए गए। ");
INSERT INTO hin2017_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","परन्तु कहातियों को उसने कुछ न दिया, क्योंकि उनके लिये पवित्र वस्तुओं की यह सेवकाई थी कि वह उसे अपने कंधों पर उठा लिया करें। ");
INSERT INTO hin2017_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","फिर जब वेदी का अभिषेक हुआ तब प्रधान उसके संस्कार की भेंट वेदी के समीप ले जाने लगे। ");
INSERT INTO hin2017_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","तब यहोवा ने मूसा से कहा, “वेदी के संस्कार के लिये प्रधान लोग अपनी-अपनी भेंट अपने-अपने नियत दिन पर चढ़ाएँ।” ");
INSERT INTO hin2017_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","इसलिए जो पुरुष पहले दिन अपनी भेंट ले गया वह यहूदा गोत्रवाले अम्मीनादाब का पुत्र नहशोन था; ");
INSERT INTO hin2017_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","उसकी भेंट यह थी, अर्थात् पवित्रस्थान के शेकेल के हिसाब से एक सौ तीस शेकेल चाँदी का एक परात, और सत्तर शेकेल चाँदी का एक कटोरा, ये दोनों अन्नबलि के लिये तेल से सने हुए और मैदे से भरे हुए थे; ");
INSERT INTO hin2017_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","फिर धूप से भरा हुआ दस शेकेल सोने का एक धूपदान; ");
INSERT INTO hin2017_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","होमबलि के लिये एक बछड़ा, एक मेढ़ा, और एक वर्ष का एक भेड़ी का बच्चा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","पापबलि के लिये एक बकरा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","और मेलबलि के लिये दो बैल, और पाँच मेढ़े, और पाँच बकरे, और एक-एक वर्ष के पाँच भेड़ी के बच्चे। अम्मीनादाब के पुत्र नहशोन की यही भेंट थी। ");
INSERT INTO hin2017_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","दूसरे दिन इस्साकार का प्रधान सूआर का पुत्र नतनेल भेंट ले आया; ");
INSERT INTO hin2017_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","वह यह थी, अर्थात् पवित्रस्थान के शेकेल के हिसाब से एक सौ तीस शेकेल चाँदी का एक परात, और सत्तर शेकेल चाँदी का एक कटोरा, ये दोनों अन्नबलि के लिये तेल से सने हुए और मैदे से भरे हुए थे; ");
INSERT INTO hin2017_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","फिर धूप से भरा हुआ दस शेकेल सोने का एक धूपदान; ");
INSERT INTO hin2017_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","होमबलि के लिये एक बछड़ा, एक मेढ़ा, और एक वर्ष का एक भेड़ी का बच्चा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","पापबलि के लिये एक बकरा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","और मेलबलि के लिये दो बैल, और पाँच मेढ़े, और पाँच बकरे, और एक-एक वर्ष के पाँच भेड़ी के बच्चे। सूआर के पुत्र नतनेल की यही भेंट थी। ");
INSERT INTO hin2017_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","और तीसरे दिन जबूलूनियों का प्रधान हेलोन का पुत्र एलीआब यह भेंट ले आया, ");
INSERT INTO hin2017_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","अर्थात् पवित्रस्थान के शेकेल के हिसाब से एक सौ तीस शेकेल चाँदी का एक परात, और सत्तर शेकेल चाँदी का एक कटोरा, ये दोनों अन्नबलि के लिये तेल से सने हुए और मैदे से भरे हुए थे; ");
INSERT INTO hin2017_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","फिर धूप से भरा हुआ दस शेकेल सोने का एक धूपदान; ");
INSERT INTO hin2017_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","होमबलि के लिये एक बछड़ा, एक मेढ़ा, और एक वर्ष का एक भेड़ी का बच्चा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","पापबलि के लिये एक बकरा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","और मेलबलि के लिये दो बैल, और पाँच मेढ़े, और पाँच बकरे, और एक-एक वर्ष के पाँच भेड़ी के बच्चे। हेलोन के पुत्र एलीआब की यही भेंट थी। ");
INSERT INTO hin2017_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","और चौथे दिन रूबेनियों का प्रधान शदेऊर का पुत्र एलीसूर यह भेंट ले आया, ");
INSERT INTO hin2017_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","अर्थात् पवित्रस्थान के शेकेल के हिसाब से एक सौ तीस शेकेल चाँदी का एक परात, और सत्तर शेकेल चाँदी का एक कटोरा, ये दोनों अन्नबलि के लिये तेल से सने हुए और मैदे से भरे हुए थे; ");
INSERT INTO hin2017_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","फिर धूप से भरा हुआ दस शेकेल सोने का एक धूपदान; ");
INSERT INTO hin2017_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","होमबलि के लिये एक बछड़ा, और एक मेढ़ा, और एक वर्ष का एक भेड़ी का बच्चा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","पापबलि के लिये एक बकरा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","और मेलबलि के लिये दो बैल, और पाँच मेढ़े, और पाँच बकरे, और एक-एक वर्ष के पाँच भेड़ी के बच्चे। शदेऊर के पुत्र एलीसूर की यही भेंट थी। ");
INSERT INTO hin2017_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","पाँचवें दिन शिमोनियों का प्रधान सूरीशद्दै का पुत्र शलूमीएल यह भेंट ले आया, ");
INSERT INTO hin2017_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","अर्थात् पवित्रस्थान के शेकेल के हिसाब से एक सौ तीस शेकेल चाँदी का एक परात, और सत्तर शेकेल चाँदी का एक कटोरा, ये दोनों अन्नबलि के लिये तेल से सने हुए और मैदे से भरे हुए थे; ");
INSERT INTO hin2017_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","फिर धूप से भरा हुआ दस शेकेल सोने का एक धूपदान; ");
INSERT INTO hin2017_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","होमबलि के लिये एक बछड़ा, और एक मेढ़ा, और एक वर्ष का एक भेड़ी का बच्चा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","पापबलि के लिये एक बकरा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","और मेलबलि के लिये दो बैल, और पाँच मेढ़े, और पाँच बकरे, और एक-एक वर्ष के पाँच भेड़ी के बच्चे। सूरीशद्दै के पुत्र शलूमीएल की यही भेंट थी। ");
INSERT INTO hin2017_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","और छठवें दिन गादियों का प्रधान दूएल का पुत्र एल्यासाप यह भेंट ले आया, ");
INSERT INTO hin2017_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","अर्थात् पवित्रस्थान के शेकेल के हिसाब से एक सौ तीस शेकेल चाँदी का एक परात, और सत्तर शेकेल चाँदी का एक कटोरा ये दोनों अन्नबलि के लिये तेल से सने हुए और मैदे से भरे हुए थे; ");
INSERT INTO hin2017_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","फिर धूप से भरा हुआ दस शेकेल सोने का एक धूपदान; ");
INSERT INTO hin2017_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","होमबलि के लिये एक बछड़ा, और एक मेढ़ा, और एक वर्ष का एक भेड़ी का बच्चा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","पापबलि के लिये एक बकरा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","और मेलबलि के लिये दो बैल, और पाँच मेढ़े, और पाँच बकरे, और एक-एक वर्ष के पाँच भेड़ी के बच्चे। दूएल के पुत्र एल्यासाप की यही भेंट थी। ");
INSERT INTO hin2017_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","सातवें दिन एप्रैमियों का प्रधान अम्मीहूद का पुत्र एलीशामा यह भेंट ले आया, ");
INSERT INTO hin2017_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","अर्थात् पवित्रस्थान के शेकेल के हिसाब से एक सौ तीस शेकेल चाँदी का एक परात, और सत्तर शेकेल चाँदी का एक कटोरा, ये दोनों अन्नबलि के लिये तेल से सने हुए और मैदे से भरे हुए थे; ");
INSERT INTO hin2017_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","फिर धूप से भरा हुआ दस शेकेल सोने का एक धूपदान; ");
INSERT INTO hin2017_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","होमबलि के लिये एक बछड़ा, एक मेढ़ा, और एक वर्ष का एक भेड़ी का बच्चा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","पापबलि के लिये एक बकरा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","और मेलबलि के लिये दो बैल, और पाँच मेढ़े, और पाँच बकरे, और एक-एक वर्ष के पाँच भेड़ी के बच्चे। अम्मीहूद के पुत्र एलीशामा की यही भेंट थी। ");
INSERT INTO hin2017_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","आठवें दिन मनश्शेइयों का प्रधान पदासूर का पुत्र गम्लीएल यह भेंट ले आया, ");
INSERT INTO hin2017_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","अर्थात् पवित्रस्थान के शेकेल के हिसाब से एक सौ तीस शेकेल चाँदी का एक परात, और सत्तर शेकेल चाँदी का एक कटोरा, ये दोनों अन्नबलि के लिये तेल से सने हुए और मैदे से भरे हुए थे; ");
INSERT INTO hin2017_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","फिर धूप से भरा हुआ दस शेकेल सोने का एक धूपदान; ");
INSERT INTO hin2017_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","होमबलि के लिये एक बछड़ा, और एक मेढ़ा, और एक वर्ष का एक भेड़ी का बच्चा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","पापबलि के लिये एक बकरा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","और मेलबलि के लिये दो बैल, और पाँच मेढ़े, और पाँच बकरे, और एक-एक वर्ष के पाँच भेड़ी के बच्चे। पदासूर के पुत्र गम्लीएल की यही भेंट थी। ");
INSERT INTO hin2017_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","नवें दिन बिन्यामीनियों का प्रधान गिदोनी का पुत्र अबीदान यह भेंट ले आया, ");
INSERT INTO hin2017_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","अर्थात् पवित्रस्थान के शेकेल के हिसाब से एक सौ तीस शेकेल चाँदी का एक परात, और सत्तर शेकेल चाँदी का एक कटोरा, ये दोनों अन्नबलि के लिये तेल से सने हुए और मैदे से भरे हुए थे; ");
INSERT INTO hin2017_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","फिर धूप से भरा हुआ दस शेकेल सोने का एक धूपदान; ");
INSERT INTO hin2017_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","होमबलि के लिये एक बछड़ा, और एक मेढ़ा, और एक वर्ष का एक भेड़ी का बच्चा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","पापबलि के लिये एक बकरा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","और मेलबलि के लिये दो बैल, और पाँच मेढ़े, और पाँच बकरे, और एक-एक वर्ष के पाँच भेड़ी के बच्चे। गिदोनी के पुत्र अबीदान की यही भेंट थी। ");
INSERT INTO hin2017_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","दसवें दिन दानियों का प्रधान अम्मीशद्दै का पुत्र अहीएजेर यह भेंट ले आया, ");
INSERT INTO hin2017_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","अर्थात् पवित्रस्थान के शेकेल के हिसाब से एक सौ तीस शेकेल चाँदी का एक परात, और सत्तर शेकेल चाँदी का एक कटोरा, ये दोनों अन्नबलि के लिये तेल से सने हुए और मैदे से भरे हुए थे; ");
INSERT INTO hin2017_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","फिर धूप से भरा हुआ दस शेकेल सोने का एक धूपदान; ");
INSERT INTO hin2017_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","होमबलि के लिये बछड़ा, और एक मेढ़ा, और एक वर्ष का एक भेड़ी का बच्चा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","पापबलि के लिये एक बकरा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","और मेलबलि के लिये दो बैल, और पाँच मेढ़े, और पाँच बकरे, और एक-एक वर्ष के पाँच भेड़ी के बच्चे। अम्मीशद्दै के पुत्र अहीएजेर की यही भेंट थी। ");
INSERT INTO hin2017_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ग्यारहवें दिन आशेरियों का प्रधान ओक्रान का पुत्र पगीएल यह भेंट ले आया। ");
INSERT INTO hin2017_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","अर्थात् पवित्रस्थान के शेकेल के हिसाब से एक सौ तीस शेकेल चाँदी का एक परात, और सत्तर शेकेल चाँदी का एक कटोरा, ये दोनों अन्नबलि के लिये तेल से सने हुए और मैदे से भरे हुए थे; ");
INSERT INTO hin2017_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","फिर धूप से भरा हुआ दस शेकेल सोने का धूपदान; ");
INSERT INTO hin2017_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","होमबलि के लिये एक बछड़ा, और एक मेढ़ा, और एक वर्ष का एक भेड़ी का बच्चा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","पापबलि के लिये एक बकरा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","और मेलबलि के लिये दो बैल, और पाँच मेढ़े, और पाँच बकरे, और एक-एक वर्ष के पाँच भेड़ी के बच्चे। ओक्रान के पुत्र पगीएल की यही भेंट थी। ");
INSERT INTO hin2017_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","बारहवें दिन नप्तालियों का प्रधान एनान का पुत्र अहीरा यह भेंट ले आया, ");
INSERT INTO hin2017_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","अर्थात् पवित्रस्थान के शेकेल के हिसाब से एक सौ तीस शेकेल चाँदी का एक परात, और सत्तर शेकेल चाँदी का एक कटोरा, ये दोनों अन्नबलि के लिये तेल से सने हुए और मैदे से भरे हुए थे; ");
INSERT INTO hin2017_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","फिर धूप से भरा हुआ दस शेकेल सोने का एक धूपदान; ");
INSERT INTO hin2017_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","होमबलि के लिये एक बछड़ा, और एक मेढ़ा, और एक वर्ष का एक भेड़ी का बच्चा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","पापबलि के लिये एक बकरा; ");
INSERT INTO hin2017_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","और मेलबलि के लिये दो बैल, और पाँच मेढ़े, और पाँच बकरे, और एक-एक वर्ष के पाँच भेड़ी के बच्चे। एनान के पुत्र अहीरा की यही भेंट थी। ");
INSERT INTO hin2017_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","वेदी के अभिषेक के समय इस्राएल के प्रधानों की ओर से उसके संस्कार की भेंट यही हुई, अर्थात् चाँदी के बारह परात, चाँदी के बारह कटोरे, और सोने के बारह धूपदान। ");
INSERT INTO hin2017_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","एक-एक चाँदी का परात एक सौ तीस शेकेल का, और एक-एक चाँदी का कटोरा सत्तर शेकेल का था; और पवित्रस्थान के शेकेल के हिसाब से ये सब चाँदी के पात्र दो हजार चार सौ शेकेल के थे। ");
INSERT INTO hin2017_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","फिर धूप से भरे हुए सोने के बारह धूपदान जो पवित्रस्थान के शेकेल के हिसाब से दस-दस शेकेल के थे, वे सब धूपदान एक सौ बीस शेकेल सोने के थे। ");
INSERT INTO hin2017_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","फिर होमबलि के लिये सब मिलाकर बारह बछड़े, बारह मेढ़े, और एक-एक वर्ष के बारह भेड़ी के बच्चे, अपने-अपने अन्नबलि सहित थे; फिर पापबलि के सब बकरे बारह थे; ");
INSERT INTO hin2017_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","और मेलबलि के लिये सब मिलाकर चौबीस बैल, और साठ मेढ़े, और साठ बकरे, और एक-एक वर्ष के साठ भेड़ी के बच्चे थे। वेदी के अभिषेक होने के बाद उसके संस्कार की भेंट यही हुई। ");
INSERT INTO hin2017_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","और जब मूसा यहोवा से बातें करने को मिलापवाले तम्बू में गया, तब उसने प्रायश्चित के ढकने पर से, जो साक्षीपत्र के सन्दूक के ऊपर था, दोनों करूबों के मध्य में से उसकी आवाज सुनी जो उससे बातें कर रहा था; और उसने (यहोवा) उससे बातें की। ");
INSERT INTO hin2017_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“हारून को समझाकर यह कह कि जब जब तू दीपकों को जलाए तब-तब सातों दीपक का प्रकाश दीवट के सामने हो।” ");
INSERT INTO hin2017_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","इसलिए हारून ने वैसा ही किया, अर्थात् जो आज्ञा यहोवा ने मूसा को दी थी उसी के अनुसार उसने दीपकों को जलाया कि वे दीवट के सामने उजियाला दें। ");
INSERT INTO hin2017_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","और दीवट की बनावट ऐसी थी, अर्थात् यह पाए से लेकर फूलों तक गढ़े हुए सोने का बनाया गया था; जो नमूना यहोवा ने मूसा को दिखलाया था उसी के अनुसार उसने दीवट को बनाया। ");
INSERT INTO hin2017_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“इस्राएलियों के मध्य में से लेवियों को अलग लेकर शुद्ध कर। ");
INSERT INTO hin2017_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","उन्हें शुद्ध करने के लिये तू ऐसा कर, कि पावन करनेवाला जल उन पर छिड़क दे, फिर वे सर्वांग मुँण्ड़न कराएँ, और वस्त्र धोएँ, और वे अपने को शुद्ध करें। ");
INSERT INTO hin2017_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","तब वे तेल से सने हुए मैदे के अन्नबलि समेत एक बछड़ा ले लें, और तू पापबलि के लिये एक दूसरा बछड़ा लेना। ");
INSERT INTO hin2017_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","और तू लेवियों को मिलापवाले तम्बू के सामने पहुँचाना, और इस्राएलियों की सारी मण्डली को इकट्ठा करना। ");
INSERT INTO hin2017_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","तब तू लेवियों को यहोवा के आगे समीप ले आना, और इस्राएली अपने-अपने हाथ उन पर रखें, ");
INSERT INTO hin2017_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","तब हारून लेवियों को यहोवा के सामने इस्राएलियों की ओर से हिलाई हुई भेंट करके अर्पण करे कि वे यहोवा की सेवा करनेवाले ठहरें। ");
INSERT INTO hin2017_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","तब लेवीय अपने-अपने हाथ उन बछड़ों के सिरों पर रखें; तब तू लेवियों के लिये प्रायश्चित करने को एक बछड़ा पापबलि और दूसरा होमबलि करके यहोवा के लिये चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","और लेवियों को हारून और उसके पुत्रों के सम्मुख खड़ा करना, और उनको हिलाने की भेंट के लिये यहोवा को अर्पण करना। ");
INSERT INTO hin2017_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","“इस प्रकार तू उन्हें इस्राएलियों में से अलग करना, और वे मेरे ही ठहरेंगे। ");
INSERT INTO hin2017_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","और जब तू लेवियों को शुद्ध करके हिलाई हुई भेंट के लिये अर्पण कर चुके, उसके बाद वे मिलापवाले तम्बू सम्बंधी सेवा टहल करने के लिये अन्दर आया करें। ");
INSERT INTO hin2017_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","क्योंकि वे इस्राएलियों में से मुझे पूरी रीति से अर्पण किए हुए हैं; मैंने उनको सब इस्राएलियों में से एक-एक स्त्री के पहलौठे के बदले अपना कर लिया है। ");
INSERT INTO hin2017_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","इस्राएलियों के पहलौठे, चाहे मनुष्य के हों, चाहे पशु के, सब मेरे हैं; क्योंकि मैंने उन्हें उस समय अपने लिये पवित्र ठहराया जब मैंने मिस्र देश के सब पहिलौठों को मार डाला। ");
INSERT INTO hin2017_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","और मैंने इस्राएलियों के सब पहिलौठों के बदले लेवियों को लिया है। ");
INSERT INTO hin2017_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","उन्हें लेकर मैंने हारून और उसके पुत्रों को इस्राएलियों में से दान करके दे दिया है, कि वे मिलापवाले तम्बू में इस्राएलियों के निमित्त सेवकाई और प्रायश्चित किया करें, कहीं ऐसा न हो कि जब इस्राएली पवित्रस्थान के समीप आएँ तब उन पर कोई महाविपत्ति आ पड़े।” ");
INSERT INTO hin2017_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","लेवियों के विषय यहोवा की यह आज्ञा पाकर मूसा और हारून और इस्राएलियों की सारी मण्डली ने उनके साथ ठीक वैसा ही किया। ");
INSERT INTO hin2017_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","लेवियों ने तो अपने को पाप से शुद्ध किया, और अपने वस्त्रों को धो डाला; और हारून ने उन्हें यहोवा के सामने हिलाई हुई भेंट के निमित्त अर्पण किया, और उन्हें शुद्ध करने को उनके लिये प्रायश्चित भी किया। ");
INSERT INTO hin2017_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","और उसके बाद लेवीय हारून और उसके पुत्रों के सामने मिलापवाले तम्बू में अपनी-अपनी सेवकाई करने को गए; और जो आज्ञा यहोवा ने मूसा को लेवियों के विषय में दी थी, उसी के अनुसार वे उनसे व्यवहार करने लगे। ");
INSERT INTO hin2017_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“जो लेवियों को करना है वह यह है, कि पच्चीस वर्ष की आयु से लेकर उससे अधिक आयु में वे मिलापवाले तम्बू सम्बंधी काम करने के लिये भीतर उपस्थित हुआ करें; ");
INSERT INTO hin2017_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","और जब पचास वर्ष के हों तो फिर उस सेवा के लिये न आए और न काम करें; ");
INSERT INTO hin2017_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","परन्तु वे अपने भाई-बन्धुओं के साथ मिलापवाले तम्बू के पास रक्षा का काम किया करें, और किसी प्रकार की सेवकाई न करें। लेवियों को जो-जो काम सौंपे जाएँ उनके विषय तू उनसे ऐसा ही करना।” ");
INSERT INTO hin2017_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","इस्राएलियों के मिस्र देश से निकलने के दूसरे वर्ष के पहले महीने में यहोवा ने सीनै के जंगल में मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“इस्राएली फसह नामक पर्व को उसके नियत समय पर मनाया करें। ");
INSERT INTO hin2017_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","अर्थात् इसी महीने के चौदहवें दिन को साँझ के समय तुम लोग उसे सब विधियों और नियमों के अनुसार मानना।” ");
INSERT INTO hin2017_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","तब मूसा ने इस्राएलियों से फसह मानने के लिये कह दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","और उन्होंने पहले महीने के चौदहवें दिन को साँझ के समय सीनै के जंगल में फसह को मनाया; और जो-जो आज्ञाएँ यहोवा ने मूसा को दी थीं उन्हीं के अनुसार इस्राएलियों ने किया। ");
INSERT INTO hin2017_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","परन्तु कुछ लोग एक मनुष्य के शव के द्वारा अशुद्ध होने के कारण उस दिन फसह को न मना सके; वे उसी दिन मूसा और हारून के समीप जाकर मूसा से कहने लगे, ");
INSERT INTO hin2017_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","“हम लोग एक मनुष्य की लोथ के कारण अशुद्ध हैं; परन्तु हम क्यों रुके रहें, और इस्राएलियों के संग यहोवा का चढ़ावा नियत समय पर क्यों न चढ़ाएँ?” ");
INSERT INTO hin2017_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","मूसा ने उनसे कहा, “ठहरे रहो, मैं सुन लूँ कि यहोवा तुम्हारे विषय में क्या आज्ञा देता है।” ");
INSERT INTO hin2017_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“इस्राएलियों से कह कि चाहे तुम लोग चाहे तुम्हारे वंश में से कोई भी किसी लोथ के कारण अशुद्ध हो, या दूर की यात्रा पर हो, तो भी वह यहोवा के लिये फसह को माने। ");
INSERT INTO hin2017_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","वे उसे दूसरे महीने के चौदहवें दिन को साँझ के समय मनाएँ; और फसह के बलिपशु के माँस को अख़मीरी रोटी और कड़वे सागपात के साथ खाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","और उसमें से कुछ भी सवेरे तक न रख छोड़े, और न उसकी कोई हड्डी तोड़े; वे फसह के पर्व को सारी विधियों के अनुसार मनाएँ। (यूह. 19:36) ");
INSERT INTO hin2017_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","परन्तु जो मनुष्य शुद्ध हो और यात्रा पर न हो, परन्तु फसह के पर्व को न माने, वह मनुष्य अपने लोगों में से नाश किया जाए, उस मनुष्य को यहोवा का चढ़ावा नियत समय पर न ले आने के कारण अपने पाप का बोझ उठाना पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","यदि कोई परदेशी तुम्हारे साथ रहकर चाहे कि यहोवा के लिये फसह मनाएँ, तो वह उसी विधि और नियम के अनुसार उसको माने; देशी और परदेशी दोनों के लिये तुम्हारी एक ही विधि हो।” ");
INSERT INTO hin2017_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","जिस दिन निवास जो, साक्षी का तम्बू भी कहलाता है, खड़ा किया गया, उस दिन बादल उस पर छा गया; और संध्या को वह निवास पर आग के समान दिखाई दिया और भोर तक दिखाई देता रहा। ");
INSERT INTO hin2017_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","प्रतिदिन ऐसा ही हुआ करता था; अर्थात् दिन को बादल छाया रहता, और रात को आग दिखाई देती थी। ");
INSERT INTO hin2017_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","और जब जब वह बादल तम्बू पर से उठ जाता तब इस्राएली प्रस्थान करते थे; और जिस स्थान पर बादल ठहर जाता वहीं इस्राएली अपने डेरे खड़े करते थे। ");
INSERT INTO hin2017_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","यहोवा की आज्ञा से इस्राएली कूच करते थे, और यहोवा ही की आज्ञा से वे डेरे खड़े भी करते थे; और जितने दिन तक वह बादल निवास पर ठहरा रहता, उतने दिन तक वे डेरे डाले पड़े रहते थे। ");
INSERT INTO hin2017_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","जब बादल बहुत दिन निवास पर छाया रहता, तब भी इस्राएली यहोवा की आज्ञा मानते, और प्रस्थान नहीं करते थे। ");
INSERT INTO hin2017_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","और कभी-कभी वह बादल थोड़े ही दिन तक निवास पर रहता, और तब भी वे यहोवा की आज्ञा से डेरे डाले पड़े रहते थे; और फिर यहोवा की आज्ञा ही से वे प्रस्थान करते थे। ");
INSERT INTO hin2017_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","और कभी-कभी बादल केवल संध्या से भोर तक रहता; और जब वह भोर को उठ जाता था तब वे प्रस्थान करते थे, और यदि वह रात दिन बराबर रहता, तो जब बादल उठ जाता, तब ही वे प्रस्थान करते थे। ");
INSERT INTO hin2017_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","वह बादल चाहे दो दिन, चाहे एक महीना, चाहे वर्ष भर, जब तक निवास पर ठहरा रहता, तब तक इस्राएली अपने डेरों में रहते और प्रस्थान नहीं करते थे; परन्तु जब वह उठ जाता तब वे प्रस्थान करते थे। ");
INSERT INTO hin2017_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","यहोवा की आज्ञा से वे अपने डेरे खड़े करते, और यहोवा ही की आज्ञा से वे प्रस्थान करते थे; जो आज्ञा यहोवा मूसा के द्वारा देता था, उसको वे माना करते थे। ");
INSERT INTO hin2017_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“चाँदी की दो तुरहियां गढ़कर बनाई जाए; तू उनको मण्डली के बुलाने, और छावनियों के प्रस्थान करने में काम में लाना। ");
INSERT INTO hin2017_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","और जब वे दोनों फूँकी जाएँ, तब सारी मण्डली मिलापवाले तम्बू के द्वार पर तेरे पास इकट्ठी हो जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","यदि एक ही तुरही फूँकी जाए, तो प्रधान लोग जो इस्राएल के हजारों के मुख्य पुरुष हैं तेरे पास इकट्ठे हो जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","जब तुम लोग साँस बाँधकर फूँको, तो पूर्व दिशा की छावनियों का प्रस्थान हो। ");
INSERT INTO hin2017_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","और जब तुम दूसरी बार साँस बाँधकर फूँको, तब दक्षिण दिशा की छावनियों का प्रस्थान हो। उनके प्रस्थान करने के लिये वे साँस बाँधकर फूँकें। ");
INSERT INTO hin2017_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","जब लोगों को इकट्ठा करके सभा करनी हो तब भी फूँकना परन्तु साँस बाँधकर नहीं। ");
INSERT INTO hin2017_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","और हारून के पुत्र जो याजक हैं वे उन तुरहियों को फूँका करें। यह बात तुम्हारी पीढ़ी-पीढ़ी के लिये सर्वदा की विधि रहे। ");
INSERT INTO hin2017_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","और जब तुम अपने देश में किसी सतानेवाले बैरी से लड़ने को निकलो, तब तुरहियों को साँस बाँधकर फूँकना, तब तुम्हारे परमेश्वर यहोवा को तुम्हारा स्मरण आएगा, और तुम अपने शत्रुओं से बचाए जाओगे। ");
INSERT INTO hin2017_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","अपने आनन्द के दिन में, और अपने नियत पर्वों में, और महीनों के आदि में, अपने होमबलियों और मेलबलियों के साथ उन तुरहियों को फूँकना; इससे तुम्हारे परमेश्वर को तुम्हारा स्मरण आएगा; मैं तुम्हारा परमेश्वर यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","दूसरे वर्ष के दूसरे महीने के बीसवें दिन को बादल साक्षी के निवास के तम्बू पर से उठ गया, ");
INSERT INTO hin2017_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","तब इस्राएली सीनै के जंगल में से निकलकर प्रस्थान करके निकले; और बादल पारान नामक जंगल में ठहर गया। ");
INSERT INTO hin2017_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","उनका प्रस्थान यहोवा की उस आज्ञा के अनुसार जो उसने मूसा को दी थी आरम्भ हुआ। ");
INSERT INTO hin2017_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","और सबसे पहले तो यहूदियों की छावनी के झण्डे का प्रस्थान हुआ, और वे दल बाँधकर चले; और उनका सेनापति अम्मीनादाब का पुत्र नहशोन था। ");
INSERT INTO hin2017_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","और इस्साकारियों के गोत्र का सेनापति सूआर का पुत्र नतनेल था। ");
INSERT INTO hin2017_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","और जबूलूनियों के गोत्र का सेनापति हेलोन का पुत्र एलीआब था। ");
INSERT INTO hin2017_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","तब निवास का तम्बू उतारा गया, और गेर्शोनियों और मरारियों ने जो निवास के तम्बू को उठाते थे प्रस्थान किया। ");
INSERT INTO hin2017_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","फिर रूबेन की छावनी के झण्डे का कूच हुआ, और वे भी दल बनाकर चले; और उनका सेनापति शदेऊर का पुत्र एलीसूर था। ");
INSERT INTO hin2017_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","और शिमोनियों के गोत्र का सेनापति सूरीशद्दै का पुत्र शलूमीएल था। ");
INSERT INTO hin2017_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","और गादियों के गोत्र का सेनापति दूएल का पुत्र एल्यासाप था। ");
INSERT INTO hin2017_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","तब कहातियों ने पवित्र वस्तुओं को उठाए हुए प्रस्थान किया, और उनके पहुँचने तक गेर्शोनियों और मरारियों ने निवास के तम्बू को खड़ा कर दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","फिर एप्रैमियों की छावनी के झण्डे का कूच हुआ, और वे भी दल बनाकर चले; और उनका सेनापति अम्मीहूद का पुत्र एलीशामा था। ");
INSERT INTO hin2017_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","और मनश्शेइयों के गोत्र का सेनापति पदासूर का पुत्र गम्लीएल था। ");
INSERT INTO hin2017_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","और बिन्यामीनियों के गोत्र का सेनापति गिदोनी का पुत्र अबीदान था। ");
INSERT INTO hin2017_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","फिर दानियों की छावनी जो सब छावनियों के पीछे थी, उसके झण्डे का प्रस्थान हुआ, और वे भी दल बनाकर चले; और उनका सेनापति अम्मीशद्दै का पुत्र अहीएजेर था। ");
INSERT INTO hin2017_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","और आशेरियों के गोत्र का सेनापति ओक्रान का पुत्र पगीएल था। ");
INSERT INTO hin2017_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","और नप्तालियों के गोत्र का सेनापति एनान का पुत्र अहीरा था। ");
INSERT INTO hin2017_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","इस्राएली इसी प्रकार अपने-अपने दलों के अनुसार प्रस्थान करते, और आगे बढ़ा करते थे। ");
INSERT INTO hin2017_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","मूसा ने अपने ससुर रूएल मिद्यानी के पुत्र होबाब से कहा, “हम लोग उस स्थान की यात्रा करते हैं जिसके विषय में यहोवा ने कहा है, ‘मैं उसे तुम को दूँगा’; इसलिए तू भी हमारे संग चल, और हम तेरी भलाई करेंगे; क्योंकि यहोवा ने इस्राएल के विषय में भला ही कहा है।” ");
INSERT INTO hin2017_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","होबाब ने उसे उत्तर दिया, “मैं नहीं जाऊँगा; मैं अपने देश और कुटुम्बियों में लौट जाऊँगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","फिर मूसा ने कहा, “हमको न छोड़, क्योंकि जंगल में कहाँ-कहाँ डेरा खड़ा करना चाहिये, यह तुझे ही मालूम है, तू हमारे लिए आँखों का काम करना। ");
INSERT INTO hin2017_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","और यदि तू हमारे संग चले, तो निश्चय जो भलाई यहोवा हम से करेगा उसी के अनुसार हम भी तुझ से वैसा ही करेंगे।” ");
INSERT INTO hin2017_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","फिर इस्राएलियों ने यहोवा के पर्वत से प्रस्थान करके तीन दिन की यात्रा की; और उन तीनों दिनों के मार्ग में यहोवा की वाचा का सन्दूक उनके लिये विश्राम का स्थान ढूँढ़ता हुआ उनके आगे-आगे चलता रहा। ");
INSERT INTO hin2017_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","और जब वे छावनी के स्थान से प्रस्थान करते थे तब दिन भर यहोवा का बादल उनके ऊपर छाया रहता था। ");
INSERT INTO hin2017_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","और जब जब सन्दूक का प्रस्थान होता था तब-तब मूसा यह कहा करता था, “हे यहोवा, उठ, और तेरे शत्रु तितर-बितर हो जाएँ, और तेरे बैरी तेरे सामने से भाग जाएँ।” ");
INSERT INTO hin2017_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","और जब जब वह ठहर जाता था तब-तब मूसा कहा करता था, “हे यहोवा, हजारों-हजार इस्राएलियों में लौटकर आ जा।” ");
INSERT INTO hin2017_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","फिर वे लोग बुड़बुड़ाने और यहोवा के सुनते बुरा कहने लगे; अतः यहोवा ने सुना, और उसका कोप भड़क उठा, और यहोवा की आग उनके मध्य में जल उठी, और छावनी के एक किनारे से भस्म करने लगी। ");
INSERT INTO hin2017_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","तब लोग मूसा के पास आकर चिल्लाए; और मूसा ने यहोवा से प्रार्थना की, तब वह आग बुझ गई, ");
INSERT INTO hin2017_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","और उस स्थान का नाम तबेरा पड़ा, क्योंकि यहोवा की आग उनके मध्य में जल उठी थी। ");
INSERT INTO hin2017_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","फिर जो मिली-जुली भीड़ उनके साथ थी, वह बेहतर भोजन की लालसा करने लगी; और फिर इस्राएली भी रोने और कहने लगे, “हमें माँस खाने को कौन देगा? (1 कुरि. 10:6) ");
INSERT INTO hin2017_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","हमें वे मछलियाँ स्मरण हैं जो हम मिस्र में सेंत-मेंत खाया करते थे, और वे खीरे, और खरबूजे, और गन्दने, और प्याज, और लहसुन भी; ");
INSERT INTO hin2017_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","परन्तु अब हमारा जी घबरा गया है, यहाँ पर इस मन्ना को छोड़ और कुछ भी देख नहीं पड़ता।” ");
INSERT INTO hin2017_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","मन्ना तो धनिये के समान था, और उसका रंग रूप मोती के समान था। ");
INSERT INTO hin2017_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","लोग इधर-उधर जाकर उसे बटोरते, और चक्की में पीसते या ओखली में कूटते थे, फिर तसले में पकाते, और उसके फुलके बनाते थे; और उसका स्वाद तेल में बने हुए पूए के समान था। ");
INSERT INTO hin2017_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","और रात को छावनी में ओस पड़ती थी तब उसके साथ मन्ना भी गिरता था। (यूह. 6:31) ");
INSERT INTO hin2017_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","और मूसा ने सब घरानों के आदमियों को अपने-अपने डेरे के द्वार पर रोते सुना; और यहोवा का कोप अत्यन्त भड़का, और मूसा को भी उनका बुड़बुड़ाना बुरा लगा। ");
INSERT INTO hin2017_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","तब मूसा ने यहोवा से कहा, “तू अपने दास से यह बुरा व्यवहार क्यों करता है? और क्या कारण है कि मैंने तेरी दृष्टि में अनुग्रह नहीं पाया, कि तूने इन सब लोगों का भार मुझ पर डाला है? ");
INSERT INTO hin2017_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","क्या ये सब लोग मेरी ही कोख में पड़े थे? क्या मैं ही ने उनको उत्पन्न किया, जो तू मुझसे कहता है, कि जैसे पिता दूध पीते बालक को अपनी गोद में उठाए-उठाए फिरता है, वैसे ही मैं इन लोगों को अपनी गोद में उठाकर उस देश में ले जाऊँ, जिसके देने की शपथ तूने उनके पूर्वजों से खाई है? ");
INSERT INTO hin2017_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","मुझे इतना माँस कहाँ से मिले कि इन सब लोगों को दूँ? ये तो यह कह-कहकर मेरे पास रो रहे हैं, कि तू हमें माँस खाने को दे। ");
INSERT INTO hin2017_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","मैं अकेला इन सब लोगों का भार नहीं सम्भाल सकता, क्योंकि यह मेरी शक्ति के बाहर है। ");
INSERT INTO hin2017_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","और यदि तुझे मेरे साथ यही व्यवहार करना है, तो मुझ पर तेरा इतना अनुग्रह हो, कि तू मेरे प्राण एकदम ले ले, जिससे मैं अपनी दुर्दशा न देखने पाऊँ।” ");
INSERT INTO hin2017_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","यहोवा ने मूसा से कहा, “इस्राएली पुरनियों में से सत्तर ऐसे पुरुष मेरे पास इकट्ठे कर, जिनको तू जानता है कि वे प्रजा के पुरनिये और उनके सरदार हैं और मिलापवाले तम्बू के पास ले आ, कि वे तेरे साथ यहाँ खड़े हों। ");
INSERT INTO hin2017_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","तब मैं उतरकर तुझ से वहाँ बातें करूँगा; और जो आत्मा तुझ में है उसमें से कुछ लेकर उनमें समवाऊँगा; और वे इन लोगों का भार तेरे संग उठाए रहेंगे, और तुझे उसको अकेले उठाना न पड़ेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","और लोगों से कह, ‘कल के लिये अपने को पवित्र करो, तब तुम्हें माँस खाने को मिलेगा; क्योंकि तुम यहोवा के सुनते हुए यह कह-कहकर रोए हो, कि हमें माँस खाने को कौन देगा? हम मिस्र ही में भले थे। इसलिए यहोवा तुम को माँस खाने को देगा, और तुम खाओगे। ");
INSERT INTO hin2017_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","फिर तुम एक दिन, या दो, या पाँच, या दस, या बीस दिन ही नहीं, ");
INSERT INTO hin2017_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","परन्तु महीने भर उसे खाते रहोगे, जब तक वह तुम्हारे नथनों से निकलने न लगे और तुम को उससे घृणा न हो जाए, क्योंकि तुम लोगों ने यहोवा को जो तुम्हारे मध्य में है तुच्छ जाना है, और उसके सामने यह कहकर रोए हो कि हम मिस्र से क्यों निकल आए?’” ");
INSERT INTO hin2017_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","फिर मूसा ने कहा, “जिन लोगों के बीच मैं हूँ उनमें से छः लाख तो प्यादे ही हैं; और तूने कहा है कि मैं उन्हें इतना माँस दूँगा, कि वे महीने भर उसे खाते ही रहेंगे। ");
INSERT INTO hin2017_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","क्या वे सब भेड़-बकरी गाय-बैल उनके लिये मारे जाएँ कि उनको माँस मिले? या क्या समुद्र की सब मछलियाँ उनके लिये इकट्ठी की जाएँ, कि उनको माँस मिले?” ");
INSERT INTO hin2017_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","यहोवा ने मूसा से कहा, “क्या यहोवा का हाथ छोटा हो गया है? अब तू देखेगा कि मेरा वचन जो मैंने तुझ से कहा है वह पूरा होता है कि नहीं।” ");
INSERT INTO hin2017_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","तब मूसा ने बाहर जाकर प्रजा के लोगों को यहोवा की बातें कह सुनाईं; और उनके पुरनियों में से सत्तर पुरुष इकट्ठा करके तम्बू के चारों ओर खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","तब यहोवा बादल में होकर उतरा और उसने मूसा से बातें कीं, और जो आत्मा उसमें था उसमें से लेकर उन सत्तर पुरनियों में समवा दिया; और जब वह आत्मा उनमें आया तब वे भविष्यद्वाणी करने लगे। परन्तु फिर और कभी न की। ");
INSERT INTO hin2017_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","परन्तु दो मनुष्य छावनी में रह गए थे, जिसमें से एक का नाम एलदाद और दूसरे का मेदाद था, उनमें भी आत्मा आया; ये भी उन्हीं में से थे जिनके नाम लिख लिए गये थे, पर तम्बू के पास न गए थे, और वे छावनी ही में भविष्यद्वाणी करने लगे। ");
INSERT INTO hin2017_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","तब किसी जवान ने दौड़कर मूसा को बताया, कि एलदाद और मेदाद छावनी में भविष्यद्वाणी कर रहे हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","तब नून का पुत्र यहोशू, जो मूसा का टहलुआ और उसके चुने हुए वीरों में से था, उसने मूसा से कहा, “हे मेरे स्वामी मूसा, उनको रोक दे।” ");
INSERT INTO hin2017_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","मूसा ने उससे कहा, “क्या तू मेरे कारण जलता है? भला होता कि यहोवा की सारी प्रजा के लोग भविष्यद्वक्ता होते, और यहोवा अपना आत्मा उन सभी में समवा देता!” (1 कुरि. 14:5) ");
INSERT INTO hin2017_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","तब फिर मूसा इस्राएल के पुरनियों समेत छावनी में चला गया। ");
INSERT INTO hin2017_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","तब यहोवा की ओर से एक बड़ी आँधी आई, और वह समुद्र से बटेरें उड़ाकर छावनी पर और उसके चारों ओर इतनी ले आई, कि वे इधर-उधर एक दिन के मार्ग तक भूमि पर दो हाथ के लगभग ऊँचे तक छा गए। ");
INSERT INTO hin2017_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","और लोगों ने उठकर उस दिन भर और रात भर, और दूसरे दिन भी दिन भर बटेरों को बटोरते रहे; जिसने कम से कम बटोरा उसने दस होमेर बटोरा; और उन्होंने उन्हें छावनी के चारों ओर फैला दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","माँस उनके मुँह ही में था, और वे उसे खाने न पाए थे कि यहोवा का कोप उन पर भड़क उठा, और उसने उनको बहुत बड़ी मार से मारा। ");
INSERT INTO hin2017_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","और उस स्थान का नाम किब्रोतहत्तावा पड़ा, क्योंकि जिन लोगों ने माँस की लालसा की थी उनको वहाँ मिट्टी दी गई। (1 कुरि. 10:6) ");
INSERT INTO hin2017_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","फिर इस्राएली किब्रोतहत्तावा से प्रस्थान करके हसेरोत में पहुँचे, और वहीं रहे। ");
INSERT INTO hin2017_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","मूसा ने एक कूशी स्त्री के साथ विवाह कर लिया था। इसलिए मिर्याम और हारून उसकी उस विवाहिता कूशी स्त्री के कारण उसकी निन्दा करने लगे; ");
INSERT INTO hin2017_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","उन्होंने कहा, “क्या यहोवा ने केवल मूसा ही के साथ बातें की हैं? क्या उसने हम से भी बातें नहीं की?” उनकी यह बात यहोवा ने सुनी। ");
INSERT INTO hin2017_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","मूसा तो पृथ्वी भर के रहनेवाले सब मनुष्यों से बहुत अधिक नम्र स्वभाव का था। ");
INSERT INTO hin2017_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","इसलिए यहोवा ने एकाएक मूसा और हारून और मिर्याम से कहा, “तुम तीनों मिलापवाले तम्बू के पास निकल आओ।” तब वे तीनों निकल आए। ");
INSERT INTO hin2017_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","तब यहोवा ने बादल के खम्भे में उतरकर तम्बू के द्वार पर खड़ा होकर हारून और मिर्याम को बुलाया; अतः वे दोनों उसके पास निकल आए। ");
INSERT INTO hin2017_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","तब यहोवा ने कहा, “मेरी बातें सुनो यदि तुम में कोई भविष्यद्वक्ता हो, तो उस पर मैं यहोवा दर्शन के द्वारा अपने आपको प्रगट करूँगा, या स्वप्न में उससे बातें करूँगा। ");
INSERT INTO hin2017_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","परन्तु मेरा दास मूसा ऐसा नहीं है; वह तो मेरे सब घराने में विश्वासयोग्य है। ");
INSERT INTO hin2017_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","उससे मैं गुप्त रीति से नहीं, परन्तु आमने-सामने और प्रत्यक्ष होकर बातें करता हूँ; और वह यहोवा का स्वरूप निहारने पाता है। इसलिए तुम मेरे दास मूसा की निन्दा करते हुए क्यों नहीं डरे?” ");
INSERT INTO hin2017_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","तब यहोवा का कोप उन पर भड़का, और वह चला गया; ");
INSERT INTO hin2017_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","तब वह बादल तम्बू के ऊपर से उठ गया, और मिर्याम कोढ़ से हिम के समान श्वेत हो गई। और हारून ने मिर्याम की ओर दृष्टि की, और देखा कि वह कोढ़िन हो गई है। ");
INSERT INTO hin2017_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","तब हारून मूसा से कहने लगा, “हे मेरे प्रभु, हम दोनों ने जो मूर्खता की वरन् पाप भी किया, यह पाप हम पर न लगने दे। ");
INSERT INTO hin2017_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","और मिर्याम को उस मरे हुए के समान न रहने दे, जिसकी देह अपनी माँ के पेट से निकलते ही अधगली हो।” ");
INSERT INTO hin2017_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","अतः मूसा ने यह कहकर यहोवा की दुहाई दी, “हे परमेश्वर, कृपा कर, और उसको चंगा कर।” ");
INSERT INTO hin2017_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","यहोवा ने मूसा से कहा, “यदि उसके पिता ने उसके मुँह पर थूका ही होता, तो क्या सात दिन तक वह लज्जित न रहती? इसलिए वह सात दिन तक छावनी से बाहर बन्द रहे, उसके बाद वह फिर भीतर आने पाए।” ");
INSERT INTO hin2017_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","अतः मिर्याम सात दिन तक छावनी से बाहर बन्द रही, और जब तक मिर्याम फिर आने न पाई तब तक लोगों ने प्रस्थान न किया। ");
INSERT INTO hin2017_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","उसके बाद उन्होंने हसेरोत से प्रस्थान करके पारान नामक जंगल में अपने डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“कनान देश जिसे मैं इस्राएलियों को देता हूँ, उसका भेद लेने के लिये पुरुषों को भेज; वे उनके पितरों के प्रति गोत्र के एक-एक प्रधान पुरुष हों।” ");
INSERT INTO hin2017_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","यहोवा से यह आज्ञा पाकर मूसा ने ऐसे पुरुषों को पारान जंगल से भेज दिया, जो सब के सब इस्राएलियों के प्रधान थे। ");
INSERT INTO hin2017_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","उनके नाम ये हैं रूबेन के गोत्र में से जक्कूर का पुत्र शम्मू; ");
INSERT INTO hin2017_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","शिमोन के गोत्र में से होरी का पुत्र शापात; ");
INSERT INTO hin2017_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","यहूदा के गोत्र में से यपुन्ने का पुत्र कालेब; ");
INSERT INTO hin2017_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","इस्साकार के गोत्र में से यूसुफ का पुत्र यिगाल; ");
INSERT INTO hin2017_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","एप्रैम के गोत्र में से नून का पुत्र होशे; ");
INSERT INTO hin2017_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","बिन्यामीन के गोत्र में से रापू का पुत्र पलती; ");
INSERT INTO hin2017_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","जबूलून के गोत्र में से सोदी का पुत्र गद्दीएल; ");
INSERT INTO hin2017_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","यूसुफ वंशियों में, मनश्शे के गोत्र में से सूसी का पुत्र गद्दी; ");
INSERT INTO hin2017_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","दान के गोत्र में से गमल्ली का पुत्र अम्मीएल; ");
INSERT INTO hin2017_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","आशेर के गोत्र में से मीकाएल का पुत्र सतूर; ");
INSERT INTO hin2017_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","नप्ताली के गोत्र में से वोप्सी का पुत्र नहूबी; ");
INSERT INTO hin2017_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","गाद के गोत्र में से माकी का पुत्र गूएल। ");
INSERT INTO hin2017_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","जिन पुरुषों को मूसा ने देश का भेद लेने के लिये भेजा था उनके नाम ये ही हैं। और नून के पुत्र होशे का नाम मूसा ने यहोशू रखा। ");
INSERT INTO hin2017_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","उनको कनान देश के भेद लेने को भेजते समय मूसा ने कहा, “इधर से, अर्थात् दक्षिण देश होकर जाओ, ");
INSERT INTO hin2017_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","और पहाड़ी देश में जाकर उस देश को देख लो कि कैसा है, और उसमें बसे हुए लोगों को भी देखो कि वे बलवान हैं या निर्बल, थोड़े हैं या बहुत, ");
INSERT INTO hin2017_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","और जिस देश में वे बसे हुए हैं वह कैसा है, अच्छा या बुरा, और वे कैसी-कैसी बस्तियों में बसे हुए हैं, और तम्बुओं में रहते हैं या गढ़ अथवा किलों में रहते हैं, ");
INSERT INTO hin2017_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","और वह देश कैसा है, उपजाऊ है या बंजर है, और उसमें वृक्ष हैं या नहीं। और तुम हियाव बाँधे चलो, और उस देश की उपज में से कुछ लेते भी आना।” वह समय पहली पक्की दाखों का था। ");
INSERT INTO hin2017_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","इसलिए वे चल दिए, और सीन नामक जंगल से ले रहोब तक, जो हमात के मार्ग में है, सारे देश को देख-भाल कर उसका भेद लिया। ");
INSERT INTO hin2017_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","वे दक्षिण देश होकर चले, और हेब्रोन तक गए; वहाँ अहीमन, शेशै, और तल्मै नामक अनाकवंशी रहते थे। हेब्रोन मिस्र के सोअन से सात वर्ष पहले बसाया गया था। ");
INSERT INTO hin2017_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","तब वे एशकोल नामक नाले तक गए, और वहाँ से एक डाली दाखों के गुच्छे समेत तोड़ ली, और दो मनुष्य उसे एक लाठी पर लटकाए हुए उठा ले चले गए; और वे अनारों और अंजीरों में से भी कुछ कुछ ले आए। ");
INSERT INTO hin2017_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","इस्राएली वहाँ से जो दाखों का गुच्छा तोड़ ले आए थे, इस कारण उस स्थान का नाम एशकोल नाला रखा गया। ");
INSERT INTO hin2017_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","चालीस दिन के बाद वे उस देश का भेद लेकर लौट आए। ");
INSERT INTO hin2017_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","और पारान जंगल के कादेश नामक स्थान में मूसा और हारून और इस्राएलियों की सारी मण्डली के पास पहुँचे; और उनको और सारी मण्डली को सन्देशा दिया, और उस देश के फल उनको दिखाए। ");
INSERT INTO hin2017_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","उन्होंने मूसा से यह कहकर वर्णन किया, “जिस देश में तूने हमको भेजा था उसमें हम गए; उसमें सचमुच दूध और मधु की धाराएँ बहती हैं, और उसकी उपज में से यही है। ");
INSERT INTO hin2017_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","परन्तु उस देश के निवासी बलवान हैं, और उसके नगर गढ़वाले हैं और बहुत बड़े हैं; और फिर हमने वहाँ अनाकवंशियों को भी देखा। ");
INSERT INTO hin2017_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","दक्षिण देश में तो अमालेकी बसे हुए हैं; और पहाड़ी देश में हित्ती, यबूसी, और एमोरी रहते हैं; और समुद्र के किनारे-किनारे और यरदन नदी के तट पर कनानी बसे हुए हैं।” ");
INSERT INTO hin2017_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","पर कालेब ने मूसा के सामने प्रजा के लोगों को चुप कराने के विचार से कहा, “हम अभी चढ़कर उस देश को अपना कर लें; क्योंकि निःसन्देह हम में ऐसा करने की शक्ति है।” ");
INSERT INTO hin2017_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","पर जो पुरुष उसके संग गए थे उन्होंने कहा, “उन लोगों पर चढ़ने की शक्ति हम में नहीं है; क्योंकि वे हम से बलवान हैं।” ");
INSERT INTO hin2017_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","और उन्होंने इस्राएलियों के सामने उस देश की जिसका भेद उन्होंने लिया था यह कहकर निन्दा भी की, “वह देश जिसका भेद लेने को हम गये थे ऐसा है, जो अपने निवासियों को निगल जाता है; और जितने पुरुष हमने उसमें देखे वे सब के सब बड़े डील-डौल के हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","फिर हमने वहाँ नपीलों को, अर्थात् नपीली जातिवाले अनाकवंशियों को देखा; और हम अपनी दृष्टि में तो उनके सामने टिड्डे के समान दिखाई पड़ते थे, और ऐसे ही उनकी दृष्टि में मालूम पड़ते थे।” ");
INSERT INTO hin2017_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","तब सारी मण्डली चिल्ला उठी; और रात भर वे लोग रोते ही रहे। (इब्रा. 3:16-18) ");
INSERT INTO hin2017_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","और सब इस्राएली मूसा और हारून पर बुड़बुड़ाने लगे; और सारी मण्डली उससे कहने लगी, “भला होता कि हम मिस्र ही में मर जाते! या इस जंगल ही में मर जाते! (1 कुरि. 10:10) ");
INSERT INTO hin2017_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","यहोवा हमको उस देश में ले जाकर क्यों तलवार से मरवाना चाहता है? हमारी स्त्रियाँ और बाल-बच्चे तो लूट में चले जाएँगे; क्या हमारे लिये अच्छा नहीं कि हम मिस्र देश को लौट जाएँ?” ");
INSERT INTO hin2017_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","फिर वे आपस में कहने लगे, “आओ, हम किसी को अपना प्रधान बना लें, और मिस्र को लौट चलें।” (प्रेरि. 7:39) ");
INSERT INTO hin2017_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","तब मूसा और हारून इस्राएलियों की सारी मण्डली के सामने मुँह के बल गिरे। ");
INSERT INTO hin2017_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","और नून का पुत्र यहोशू और यपुन्ने का पुत्र कालेब, जो देश के भेद लेनेवालों में से थे, अपने-अपने वस्त्र फाड़कर, ");
INSERT INTO hin2017_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","इस्राएलियों की सारी मण्डली से कहने लगे, “जिस देश का भेद लेने को हम इधर-उधर घूमकर आए हैं, वह अत्यन्त उत्तम देश है। ");
INSERT INTO hin2017_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","यदि यहोवा हम से प्रसन्न हो, तो हमको उस देश में, जिसमें दूध और मधु की धाराएँ बहती हैं, पहुँचाकर उसे हमें दे देगा। ");
INSERT INTO hin2017_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","केवल इतना करो कि तुम यहोवा के विरुद्ध बलवा न करो; और न उस देश के लोगों से डरो, क्योंकि वे हमारी रोटी ठहरेंगे; छाया उनके ऊपर से हट गई है, और यहोवा हमारे संग है; उनसे न डरो।” ");
INSERT INTO hin2017_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","तब सारी मण्डली चिल्ला उठी, कि इनको पथरवाह करो। तब यहोवा का तेज मिलापवाले तम्बू में सब इस्राएलियों पर प्रकाशमान हुआ। ");
INSERT INTO hin2017_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","तब यहोवा ने मूसा से कहा, “ये लोग कब तक मेरा तिरस्कार करते रहेंगे? और मेरे सब आश्चर्यकर्मों को देखने पर भी कब तक मुझ पर विश्वास न करेंगे? ");
INSERT INTO hin2017_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","मैं उन्हें मरी से मारूँगा, और उनके निज भाग से उन्हें निकाल दूँगा, और तुझ से एक जाति उत्पन्न करूँगा जो उनसे बड़ी और बलवन्त होगी।” ");
INSERT INTO hin2017_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","मूसा ने यहोवा से कहा, “तब तो मिस्री जिनके मध्य में से तू अपनी सामर्थ्य दिखाकर उन लोगों को निकाल ले आया है यह सुनेंगे, ");
INSERT INTO hin2017_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","और इस देश के निवासियों से कहेंगे। उन्होंने तो यह सुना है कि तू जो यहोवा है इन लोगों के मध्य में रहता है; और प्रत्यक्ष दिखाई देता है, और तेरा बादल उनके ऊपर ठहरा रहता है, और तू दिन को बादल के खम्भे में, और रात को अग्नि के खम्भे में होकर इनके आगे-आगे चला करता है। ");
INSERT INTO hin2017_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","इसलिए यदि तू इन लोगों को एक ही बार में मार डाले, तो जिन जातियों ने तेरी कीर्ति सुनी है वे कहेंगी, ");
INSERT INTO hin2017_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","कि यहोवा उन लोगों को उस देश में जिसे उसने उन्हें देने की शपथ खाई थी, पहुँचा न सका, इस कारण उसने उन्हें जंगल में घात कर डाला है। (1 कुरि. 10:5) ");
INSERT INTO hin2017_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","इसलिए अब प्रभु की सामर्थ्य की महिमा तेरे कहने के अनुसार हो, ");
INSERT INTO hin2017_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","कि यहोवा कोप करने में धीरजवन्त और अति करुणामय है, और अधर्म और अपराध का क्षमा करनेवाला है, परन्तु वह दोषी को किसी प्रकार से निर्दोष न ठहराएगा, और पूर्वजों के अधर्म का दण्ड उनके बेटों, और पोतों, और परपोतों को देता है। ");
INSERT INTO hin2017_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","अब इन लोगों के अधर्म को अपनी बड़ी करुणा के अनुसार, और जैसे तू मिस्र से लेकर यहाँ तक क्षमा करता रहा है वैसे ही अब भी क्षमा कर दे।” ");
INSERT INTO hin2017_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","यहोवा ने कहा, “तेरी विनती के अनुसार मैं क्षमा करता हूँ; ");
INSERT INTO hin2017_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","परन्तु मेरे जीवन की शपथ सचमुच सारी पृथ्वी यहोवा की महिमा से परिपूर्ण हो जाएगी; (इब्रा. 3:11) ");
INSERT INTO hin2017_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","उन सब लोगों ने जिन्होंने मेरी महिमा मिस्र देश में और जंगल में देखी, और मेरे किए हुए आश्चर्यकर्मों को देखने पर भी दस बार मेरी परीक्षा की, और मेरी बातें नहीं मानी, (इब्रा. 3:18) ");
INSERT INTO hin2017_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","इसलिए जिस देश के विषय मैंने उनके पूर्वजों से शपथ खाई, उसको वे कभी देखने न पाएँगे; अर्थात् जितनों ने मेरा अपमान किया है उनमें से कोई भी उसे देखने न पाएगा। (1 कुरि. 10:5) ");
INSERT INTO hin2017_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","परन्तु इस कारण से कि मेरे दास कालेब के साथ और ही आत्मा है, और उसने पूरी रीति से मेरा अनुकरण किया है, मैं उसको उस देश में जिसमें वह हो आया है पहुँचाऊँगा, और उसका वंश उस देश का अधिकारी होगा। ");
INSERT INTO hin2017_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","अमालेकी और कनानी लोग तराई में रहते हैं, इसलिए कल तुम घूमकर प्रस्थान करो, और लाल समुद्र के मार्ग से जंगल में जाओ।” ");
INSERT INTO hin2017_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","फिर यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“यह बुरी मण्डली मुझ पर बुड़बुड़ाती रहती है, उसको मैं कब तक सहता रहूँ? इस्राएली जो मुझ पर बुड़बुड़ाते रहते हैं, उनका यह बुड़बुड़ाना मैंने तो सुना है। ");
INSERT INTO hin2017_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","इसलिए उनसे कह कि यहोवा की यह वाणी है, कि मेरे जीवन की शपथ जो बातें तुम ने मेरे सुनते कही हैं, निःसन्देह मैं उसी के अनुसार तुम्हारे साथ व्यवहार करूँगा। ");
INSERT INTO hin2017_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","तुम्हारे शव इसी जंगल में पड़े रहेंगे; और तुम सब में से बीस वर्ष की या उससे अधिक आयु के जितने गिने गए थे, और मुझ पर बुड़बुड़ाते थे, (इब्रा. 3:17) ");
INSERT INTO hin2017_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","उसमें से यपुन्ने के पुत्र कालेब और नून के पुत्र यहोशू को छोड़ कोई भी उस देश में न जाने पाएगा, जिसके विषय मैंने शपथ खाई है कि तुम को उसमें बसाऊँगा। (1 कुरि. 10:5, यहू. 1:5) ");
INSERT INTO hin2017_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","परन्तु तुम्हारे बाल-बच्चे जिनके विषय तुम ने कहा है, कि वे लूट में चले जाएँगे, उनको मैं उस देश में पहुँचा दूँगा; और वे उस देश को जान लेंगे जिसको तुम ने तुच्छ जाना है। ");
INSERT INTO hin2017_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","परन्तु तुम लोगों के शव इसी जंगल में पड़े रहेंगे। ");
INSERT INTO hin2017_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","और जब तक तुम्हारे शव जंगल में न गल जाएँ तब तक, अर्थात् चालीस वर्ष तक, तुम्हारे बाल-बच्चे जंगल में तुम्हारे व्यभिचार का फल भोगते हुए भटकते रहेंगे। (प्रेरि. 7:36) ");
INSERT INTO hin2017_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","जितने दिन तुम उस देश का भेद लेते रहे, अर्थात् चालीस दिन उनकी गिनती के अनुसार, एक दिन के बदले एक वर्ष, अर्थात् चालीस वर्ष तक तुम अपने अधर्म का दण्ड उठाए रहोगे, तब तुम जान लोगे कि मेरा विरोध क्या है। (प्रेरि. 13:18) ");
INSERT INTO hin2017_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","मैं यहोवा यह कह चुका हूँ, कि इस बुरी मण्डली के लोग जो मेरे विरुद्ध इकट्ठे हुए हैं इसी जंगल में मर मिटेंगे; और निःसन्देह ऐसा ही करूँगा भी।” (इब्रा. 3:16-18) ");
INSERT INTO hin2017_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","तब जिन पुरुषों को मूसा ने उस देश के भेद लेने के लिये भेजा था, और उन्होंने लौटकर उस देश की नामधराई करके सारी मण्डली को कुड़कुड़ाने के लिये उभारा था, (यहू. 1:5) ");
INSERT INTO hin2017_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","उस देश की वे नामधराई करनेवाले पुरुष यहोवा के मारने से उसके सामने मर गये। ");
INSERT INTO hin2017_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","परन्तु देश के भेद लेनेवाले पुरुषों में से नून का पुत्र यहोशू और यपुन्ने का पुत्र कालेब दोनों जीवित रहे। ");
INSERT INTO hin2017_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","तब मूसा ने ये बातें सब इस्राएलियों को कह सुनाई और वे बहुत विलाप करने लगे। ");
INSERT INTO hin2017_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","और वे सवेरे उठकर यह कहते हुए पहाड़ की चोटी पर चढ़ने लगे, “हमने पाप किया है; परन्तु अब तैयार हैं, और उस स्थान को जाएँगे जिसके विषय यहोवा ने वचन दिया था।” ");
INSERT INTO hin2017_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","तब मूसा ने कहा, “तुम यहोवा की आज्ञा का उल्लंघन क्यों करते हो? यह सफल न होगा। ");
INSERT INTO hin2017_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","यहोवा तुम्हारे मध्य में नहीं है, मत चढ़ो, नहीं तो शत्रुओं से हार जाओगे। ");
INSERT INTO hin2017_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","वहाँ तुम्हारे आगे अमालेकी और कनानी लोग हैं, इसलिए तुम तलवार से मारे जाओगे; तुम यहोवा को छोड़कर फिर गए हो, इसलिए वह तुम्हारे संग नहीं रहेगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","परन्तु वे ढिठाई करके पहाड़ की चोटी पर चढ़ गए, परन्तु यहोवा की वाचा का सन्दूक, और मूसा, छावनी से न हटे। ");
INSERT INTO hin2017_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","तब अमालेकी और कनानी जो उस पहाड़ पर रहते थे उन पर चढ़ आए, और होर्मा तक उनको मारते चले आए। ");
INSERT INTO hin2017_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“इस्राएलियों से कह कि जब तुम अपने निवास के देश में पहुँचो, जो मैं तुम्हें देता हूँ, ");
INSERT INTO hin2017_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","और यहोवा के लिये क्या होमबलि, क्या मेलबलि, कोई हव्य चढ़ाओं, चाहे वह विशेष मन्नत पूरी करने का हो चाहे स्वेच्छाबलि का हो, चाहे तुम्हारे नियत समयों में का हो, या वह चाहे गाय-बैल चाहे भेड़-बकरियों में का हो, जिससे यहोवा के लिये सुखदायक सुगन्ध हो; ");
INSERT INTO hin2017_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","तब उस होमबलि या मेलबलि के संग भेड़ के बच्चे यहोवा के लिये चौथाई हीन तेल से सना हुआ एपा का दसवाँ अंश मैदा अन्नबलि करके चढ़ाना, ");
INSERT INTO hin2017_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","और चौथाई हीन दाखमधु अर्घ करके देना। ");
INSERT INTO hin2017_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","और मेढ़े के बलि के साथ तिहाई हीन तेल से सना हुआ एपा का दो दसवाँ अंश मैदा अन्नबलि करके चढ़ाना; ");
INSERT INTO hin2017_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","और उसका अर्घ यहोवा को सुखदायक सुगन्ध देनेवाला तिहाई हीन दाखमधु देना। ");
INSERT INTO hin2017_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","और जब तू यहोवा को होमबलि या किसी विशेष मन्नत पूरी करने के लिये बलि या मेलबलि करके बछड़ा चढ़ाए, ");
INSERT INTO hin2017_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","तब बछड़े का चढ़ानेवाला उसके संग आधा हीन तेल से सना हुआ एपा का तीन दसवाँ अंश मैदा अन्नबलि करके चढ़ाए। ");
INSERT INTO hin2017_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","और उसका अर्घ आधा हीन दाखमधु चढ़ाए, वह यहोवा को सुखदायक सुगन्ध देनेवाला हव्य होगा। ");
INSERT INTO hin2017_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“एक-एक बछड़े, या मेढ़े, या भेड़ के बच्चे, या बकरी के बच्चे के साथ इसी रीति चढ़ावा चढ़ाया जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","तुम्हारे बलिपशुओं की जितनी गिनती हो, उसी गिनती के अनुसार एक-एक के साथ ऐसा ही किया करना। ");
INSERT INTO hin2017_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","जितने देशी हों वे यहोवा को सुखदायक सुगन्ध देनेवाला हव्य चढ़ाते समय ये काम इसी रीति से किया करें। ");
INSERT INTO hin2017_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","“और यदि कोई परदेशी तुम्हारे संग रहता हो, या तुम्हारी किसी पीढ़ी में तुम्हारे बीच कोई रहनेवाला हो, और वह यहोवा को सुखदायक सुगन्ध देनेवाला हव्य चढ़ाना चाहे, तो जिस प्रकार तुम करोगे उसी प्रकार वह भी करे। ");
INSERT INTO hin2017_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","मण्डली के लिये, अर्थात् तुम्हारे और तुम्हारे संग रहनेवाले परदेशी दोनों के लिये एक ही विधि हो; तुम्हारी पीढ़ी-पीढ़ी में यह सदा की विधि ठहरे, कि जैसे तुम हो वैसे ही परदेशी भी यहोवा के लिये ठहरता है। ");
INSERT INTO hin2017_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","तुम्हारे और तुम्हारे संग रहनेवाले परदेशियों के लिये एक ही व्यवस्था और एक ही नियम है।” ");
INSERT INTO hin2017_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“इस्राएलियों को मेरा यह वचन सुना, कि जब तुम उस देश में पहुँचो जहाँ मैं तुम को लिये जाता हूँ, ");
INSERT INTO hin2017_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","और उस देश की उपज का अन्न खाओ, तब यहोवा के लिये उठाई हुई भेंट चढ़ाया करो। ");
INSERT INTO hin2017_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","अपने पहले गुँधे हुए आटे की एक पपड़ी उठाई हुई भेंट करके यहोवा के लिये चढ़ाना; जैसे तुम खलिहान में से उठाई हुई भेंट चढ़ाओगे वैसे ही उसको भी उठाया करना। ");
INSERT INTO hin2017_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","अपनी पीढ़ी-पीढ़ी में अपने पहले गुँधे हुए आटे में से यहोवा को उठाई हुई भेंट दिया करना। ");
INSERT INTO hin2017_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“फिर जब तुम इन सब आज्ञाओं में से जिन्हें यहोवा ने मूसा को दिया है किसी का उल्लंघन भूल से करो, ");
INSERT INTO hin2017_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","अर्थात् जिस दिन से यहोवा आज्ञा देने लगा, और आगे की तुम्हारी पीढ़ी-पीढ़ी में उस दिन से उसने जितनी आज्ञाएँ मूसा के द्वारा दी हैं, ");
INSERT INTO hin2017_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","उसमें यदि भूल से किया हुआ पाप मण्डली के बिना जाने हुआ हो, तो सारी मण्डली यहोवा को सुखदायक सुगन्ध देनेवाला होमबलि करके एक बछड़ा, और उसके संग नियम के अनुसार उसका अन्नबलि और अर्घ चढ़ाए, और पापबलि करके एक बकरा चढ़ाए। ");
INSERT INTO hin2017_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","तब याजक इस्राएलियों की सारी मण्डली के लिये प्रायश्चित करे, और उनकी क्षमा की जाएगी; क्योंकि उनका पाप भूल से हुआ, और उन्होंने अपनी भूल के लिये अपना चढ़ावा, अर्थात् यहोवा के लिये हव्य और अपना पापबलि उसके सामने चढ़ाया। ");
INSERT INTO hin2017_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","इसलिए इस्राएलियों की सारी मण्डली का, और उसके बीच रहनेवाले परदेशी का भी, वह पाप क्षमा किया जाएगा, क्योंकि वह सब लोगों के अनजाने में हुआ। ");
INSERT INTO hin2017_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","फिर यदि कोई मनुष्य भूल से पाप करे, तो वह एक वर्ष की एक बकरी पापबलि करके चढ़ाए। ");
INSERT INTO hin2017_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","और याजक भूल से पाप करनेवाले मनुष्य के लिये यहोवा के सामने प्रायश्चित करे; अतः इस प्रायश्चित के कारण उसका वह पाप क्षमा किया जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","जो कोई भूल से कुछ करे, चाहे वह इस्राएलियों में देशी हो, चाहे तुम्हारे बीच परदेशी होकर रहता हो, सब के लिये तुम्हारी एक ही व्यवस्था हो। ");
INSERT INTO hin2017_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“परन्तु क्या देशी क्या परदेशी, जो मनुष्य ढिठाई से कुछ करे, वह यहोवा का अनादर करनेवाला ठहरेगा, और वह प्राणी अपने लोगों में से नाश किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","वह जो यहोवा का वचन तुच्छ जानता है, और उसकी आज्ञा का टालनेवाला है, इसलिए वह मनुष्य निश्चय नाश किया जाए; उसका अधर्म उसी के सिर पड़ेगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","जब इस्राएली जंगल में रहते थे, उन दिनों एक मनुष्य विश्राम के दिन लकड़ी बीनता हुआ मिला। ");
INSERT INTO hin2017_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","और जिनको वह लकड़ी बीनता हुआ मिला, वे उसको मूसा और हारून, और सारी मण्डली के पास ले गए। ");
INSERT INTO hin2017_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","उन्होंने उसको हवालात में रखा, क्योंकि ऐसे मनुष्य से क्या करना चाहिये वह प्रगट नहीं किया गया था। ");
INSERT INTO hin2017_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","तब यहोवा ने मूसा से कहा, “वह मनुष्य निश्चय मार डाला जाए; सारी मण्डली के लोग छावनी के बाहर उस पर पथरवाह करें।” ");
INSERT INTO hin2017_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","इस प्रकार जैसा यहोवा ने मूसा को आज्ञा दी थी उसी के अनुसार सारी मण्डली के लोगों ने उसको छावनी से बाहर ले जाकर पथरवाह किया, और वह मर गया। ");
INSERT INTO hin2017_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“इस्राएलियों से कह, कि अपनी पीढ़ी-पीढ़ी में अपने वस्त्रों के छोर पर झालर लगाया करना, और एक-एक छोर की झालर पर एक नीला फीता लगाया करना; ");
INSERT INTO hin2017_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","और वह तुम्हारे लिये ऐसी झालर ठहरे, जिससे जब जब तुम उसे देखो तब-तब यहोवा की सारी आज्ञाएँ तुम को स्मरण आ जाएँ; और तुम उनका पालन करो, और तुम अपने-अपने मन और अपनी-अपनी दृष्टि के वश में होकर व्यभिचार न करते फिरो जैसे करते आए हो। (रोम. 11:16, मत्ती 23:5) ");
INSERT INTO hin2017_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","परन्तु तुम यहोवा की सब आज्ञाओं को स्मरण करके उनका पालन करो, और अपने परमेश्वर के लिये पवित्र बनो। ");
INSERT INTO hin2017_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","मैं यहोवा तुम्हारा परमेश्वर हूँ, जो तुम्हें मिस्र देश से निकाल ले आया कि तुम्हारा परमेश्वर ठहरूँ; मैं तुम्हारा परमेश्वर यहोवा हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","कोरह जो लेवी का परपोता, कहात का पोता, और यिसहार का पुत्र था, वह एलीआब के पुत्र दातान और अबीराम, और पेलेत के पुत्र ओन, ");
INSERT INTO hin2017_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","इन तीनों रूबेनियों से मिलकर मण्डली के ढाई सौ प्रधान, जो सभासद और नामी थे, उनको संग लिया; ");
INSERT INTO hin2017_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","और वे मूसा और हारून के विरुद्ध उठ खड़े हुए, और उनसे कहने लगे, “तुम ने बहुत किया, अब बस करो; क्योंकि सारी मण्डली का एक-एक मनुष्य पवित्र है, और यहोवा उनके मध्य में रहता है; इसलिए तुम यहोवा की मण्डली में ऊँचे पदवाले क्यों बन बैठे हो?” ");
INSERT INTO hin2017_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","यह सुनकर मूसा अपने मुँह के बल गिरा; ");
INSERT INTO hin2017_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","फिर उसने कोरह और उसकी सारी मण्डली से कहा, “सवेरे को यहोवा दिखा देगा कि उसका कौन है, और पवित्र कौन है, और उसको अपने समीप बुला लेगा; जिसको वह आप चुन लेगा उसी को अपने समीप बुला भी लेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","इसलिए, हे कोरह, तुम अपनी सारी मण्डली समेत यह करो, अर्थात् अपना-अपना धूपदान ठीक करो; ");
INSERT INTO hin2017_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","और कल उनमें आग रखकर यहोवा के सामने धूप देना, तब जिसको यहोवा चुन ले वही पवित्र ठहरेगा। हे लेवियों, तुम भी बड़ी-बड़ी बातें करते हो, अब बस करो।” ");
INSERT INTO hin2017_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","फिर मूसा ने कोरह से कहा, “हे लेवियों, सुनो, ");
INSERT INTO hin2017_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","क्या यह तुम्हें छोटी बात जान पड़ती है कि इस्राएल के परमेश्वर ने तुम को इस्राएल की मण्डली से अलग करके अपने निवास की सेवकाई करने, और मण्डली के सामने खड़े होकर उसकी भी सेवा टहल करने के लिये अपने समीप बुला लिया है; ");
INSERT INTO hin2017_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","और तुझे और तेरे सब लेवी भाइयों को भी अपने समीप बुला लिया है? फिर भी तुम याजकपद के भी खोजी हो? ");
INSERT INTO hin2017_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","और इसी कारण तूने अपनी सारी मण्डली को यहोवा के विरुद्ध इकट्ठी किया है; हारून कौन है कि तुम उस पर बुड़बुड़ाते हो?” ");
INSERT INTO hin2017_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","फिर मूसा ने एलीआब के पुत्र दातान और अबीराम को बुलवा भेजा; परन्तु उन्होंने कहा, “हम तेरे पास नहीं आएँगे। ");
INSERT INTO hin2017_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","क्या यह एक छोटी बात है कि तू हमको ऐसे देश से जिसमें दूध और मधु की धाराएँ बहती है इसलिए निकाल लाया है, कि हमें जंगल में मार डालें, फिर क्या तू हमारे ऊपर प्रधान भी बनकर अधिकार जताता है? ");
INSERT INTO hin2017_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","फिर तू हमें ऐसे देश में जहाँ दूध और मधु की धाराएँ बहती हैं नहीं पहुँचाया, और न हमें खेतों और दाख की बारियों का अधिकारी बनाया। क्या तू इन लोगों की आँखों में धूल डालेगा? हम तो नहीं आएँगे।” ");
INSERT INTO hin2017_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","तब मूसा का कोप बहुत भड़क उठा, और उसने यहोवा से कहा, “उन लोगों की भेंट की ओर दृष्टि न कर। मैंने तो उनसे एक गदहा भी नहीं लिया, और न उनमें से किसी की हानि की है।” ");
INSERT INTO hin2017_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","तब मूसा ने कोरह से कहा, “कल तू अपनी सारी मण्डली को साथ लेकर हारून के साथ यहोवा के सामने हाजिर होना; ");
INSERT INTO hin2017_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","और तुम सब अपना-अपना धूपदान लेकर उनमें धूप देना, फिर अपना-अपना धूपदान जो सब समेत ढाई सौ होंगे यहोवा के सामने ले जाना; विशेष करके तू और हारून अपना-अपना धूपदान ले जाना।” ");
INSERT INTO hin2017_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","इसलिए उन्होंने अपना-अपना धूपदान लेकर और उनमें आग रखकर उन पर धूप डाला; और मूसा और हारून के साथ मिलापवाले तम्बू के द्वार पर खड़े हुए। ");
INSERT INTO hin2017_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","और कोरह ने सारी मण्डली को उनके विरुद्ध मिलापवाले तम्बू के द्वार पर इकट्ठा कर लिया। तब यहोवा का तेज सारी मण्डली को दिखाई दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","तब यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“उस मण्डली के बीच में से अलग हो जाओ कि मैं उन्हें पल भर में भस्म कर डालूँ।” ");
INSERT INTO hin2017_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","तब वे मुँह के बल गिरकर कहने लगे, “हे परमेश्वर, हे सब प्राणियों के आत्माओं के परमेश्वर, क्या एक पुरुष के पाप के कारण तेरा क्रोध सारी मण्डली पर होगा?” (इब्रा. 12:9) ");
INSERT INTO hin2017_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“मण्डली के लोगों से कह कि कोरह, दातान, और अबीराम के तम्बुओं के आस-पास से हट जाओ।” ");
INSERT INTO hin2017_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","तब मूसा उठकर दातान और अबीराम के पास गया; और इस्राएलियों के वृद्ध लोग उसके पीछे-पीछे गए। ");
INSERT INTO hin2017_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","और उसने मण्डली के लोगों से कहा, “तुम उन दुष्ट मनुष्यों के डेरों के पास से हट जाओ, और उनकी कोई वस्तु न छूओ, कहीं ऐसा न हो कि तुम भी उनके सब पापों में फँसकर मिट जाओ।” (2 तीमु. 2:19) ");
INSERT INTO hin2017_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","यह सुनकर लोग कोरह, दातान, और अबीराम के तम्बुओं के आस-पास से हट गए; परन्तु दातान और अबीराम निकलकर अपनी पत्नियों, बेटों, और बाल-बच्चों समेत अपने-अपने डेरे के द्वार पर खड़े हुए। ");
INSERT INTO hin2017_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","तब मूसा ने कहा, “इससे तुम जान लोगे कि यहोवा ने मुझे भेजा है कि यह सब काम करूँ, क्योंकि मैंने अपनी इच्छा से कुछ नहीं किया। ");
INSERT INTO hin2017_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","यदि उन मनुष्यों की मृत्यु और सब मनुष्यों के समान हो, और उनका दण्ड सब मनुष्यों के समान हो, तब जानो कि मैं यहोवा का भेजा हुआ नहीं हूँ। ");
INSERT INTO hin2017_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","परन्तु यदि यहोवा अपनी अनोखी शक्ति प्रगट करे, और पृथ्वी अपना मुँह पसारकर उनको, और उनका सब कुछ निगल जाए, और वे जीते जी अधोलोक में जा पड़ें, तो तुम समझ लो कि इन मनुष्यों ने यहोवा का अपमान किया है।” ");
INSERT INTO hin2017_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","वह ये सब बातें कह ही चुका था कि भूमि उन लोगों के पाँव के नीचे फट गई; ");
INSERT INTO hin2017_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","और पृथ्वी ने अपना मुँह खोल दिया और उनको और उनके समस्त घरबार का सामान, और कोरह के सब मनुष्यों और उनकी सारी सम्पत्ति को भी निगल लिया। ");
INSERT INTO hin2017_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","और वे और उनका सारा घरबार जीवित ही अधोलोक में जा पड़े; और पृथ्वी ने उनको ढाँप लिया, और वे मण्डली के बीच में से नष्ट हो गए। ");
INSERT INTO hin2017_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","और जितने इस्राएली उनके चारों ओर थे वे उनका चिल्लाना सुन यह कहते हुए भागे, “कहीं पृथ्वी हमको भी निगल न ले!” ");
INSERT INTO hin2017_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","तब यहोवा के पास से आग निकली, और उन ढाई सौ धूप चढ़ानेवालों को भस्म कर डाला। ");
INSERT INTO hin2017_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“हारून याजक के पुत्र एलीआजर से कह कि उन धूपदानों को आग में से उठा ले; और आग के अंगारों को उधर ही छितरा दे, क्योंकि वे पवित्र हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","जिन्होंने पाप करके अपने ही प्राणों की हानि की है, उनके धूपदानों के पत्तर पीट-पीट कर बनाए जाएँ जिससे कि वह वेदी के मढ़ने के काम आए; क्योंकि उन्होंने यहोवा के सामने रखा था; इससे वे पवित्र हैं। इस प्रकार वह इस्राएलियों के लिये एक निशान ठहरेगा।” (इब्रा. 12:3) ");
INSERT INTO hin2017_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","इसलिए एलीआजर याजक ने उन पीतल के धूपदानों को, जिनमें उन जले हुए मनुष्यों ने धूप चढ़ाया था, लेकर उनके पत्तर पीटकर वेदी के मढ़ने के लिये बनवा दिए, ");
INSERT INTO hin2017_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","कि इस्राएलियों को इस बात का स्मरण रहे कि कोई दूसरा, जो हारून के वंश का न हो, यहोवा के सामने धूप चढ़ाने को समीप न जाए, ऐसा न हो कि वह भी कोरह और उसकी मण्डली के समान नष्ट हो जाए, जैसे कि यहोवा ने मूसा के द्वारा उसको आज्ञा दी थी। ");
INSERT INTO hin2017_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","दूसरे दिन इस्राएलियों की सारी मण्डली यह कहकर मूसा और हारून पर बुड़बुड़ाने लगी, “यहोवा की प्रजा को तुम ने मार डाला है।” ");
INSERT INTO hin2017_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","और जब मण्डली के लोग मूसा और हारून के विरुद्ध इकट्ठे हो रहे थे, तब उन्होंने मिलापवाले तम्बू की ओर दृष्टि की; और देखा, कि बादल ने उसे छा लिया है, और यहोवा का तेज दिखाई दे रहा है। ");
INSERT INTO hin2017_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","तब मूसा और हारून मिलापवाले तम्बू के सामने आए, ");
INSERT INTO hin2017_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","तब यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“तुम उस मण्डली के लोगों के बीच से हट जाओ, कि मैं उन्हें पल भर में भस्म कर डालूँ।” तब वे मुँह के बल गिरे। ");
INSERT INTO hin2017_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","और मूसा ने हारून से कहा, “धूपदान को लेकर उसमें वेदी पर से आग रखकर उस पर धूप डाल, मण्डली के पास फुर्ती से जाकर उसके लिये प्रायश्चित कर; क्योंकि यहोवा का कोप अत्यन्त भड़का है, और मरी फैलने लगी है।” ");
INSERT INTO hin2017_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","मूसा की आज्ञा के अनुसार हारून धूपदान लेकर मण्डली के बीच में दौड़ा गया; और यह देखकर कि लोगों में मरी फैलने लगी है, उसने धूप जलाकर लोगों के लिये प्रायश्चित किया। ");
INSERT INTO hin2017_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","और वह मुर्दों और जीवित के मध्य में खड़ा हुआ; तब मरी थम गई। ");
INSERT INTO hin2017_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","और जो कोरह के संग भागी होकर मर गए थे, उन्हें छोड़ जो लोग इस मरी से मर गए वे चौदह हजार सात सौ थे। (1 कुरि. 10:10) ");
INSERT INTO hin2017_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","तब हारून मिलापवाले तम्बू के द्वार पर मूसा के पास लौट गया, और मरी थम गई। ");
INSERT INTO hin2017_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“इस्राएलियों से बातें करके उनके पूर्वजों के घरानों के अनुसार, उनके सब प्रधानों के पास से एक-एक छड़ी ले; और उन बारह छड़ियों में से एक-एक पर एक-एक के मूलपुरुष का नाम लिख, ");
INSERT INTO hin2017_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","और लेवियों की छड़ी पर हारून का नाम लिख। क्योंकि इस्राएलियों के पूर्वजों के घरानों के एक-एक मुख्य पुरुष की एक-एक छड़ी होगी। ");
INSERT INTO hin2017_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","और उन छड़ियों को मिलापवाले तम्बू में साक्षीपत्र के आगे, जहाँ मैं तुम लोगों से मिला करता हूँ, रख दे। ");
INSERT INTO hin2017_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","और जिस पुरुष को मैं चुनूँगा उसकी छड़ी में कलियाँ फूट निकलेंगी; और इस्राएली जो तुम पर बुड़बुड़ाते रहते हैं, वह बुड़बुड़ाना मैं अपने ऊपर से दूर करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","अतः मूसा ने इस्राएलियों से यह बात कही; और उनके सब प्रधानों ने अपने-अपने लिए, अपने-अपने पूर्वजों के घरानों के अनुसार, एक-एक छड़ी उसे दी, सो बारह छड़ियाँ हुई; और उन छड़ियों में हारून की भी छड़ी थी। ");
INSERT INTO hin2017_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","उन छड़ियों को मूसा ने साक्षीपत्र के तम्बू में यहोवा के सामने रख दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","दूसरे दिन मूसा साक्षीपत्र के तम्बू में गया; तो क्या देखा, कि हारून की छड़ी जो लेवी के घराने के लिये थी उसमें कलियाँ फूट निकली, उसमें कलियाँ लगीं, और फूल भी फूले, और पके बादाम भी लगे हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","तब मूसा उन सब छड़ियों को यहोवा के सामने से निकालकर सब इस्राएलियों के पास ले गया; और उन्होंने अपनी-अपनी छड़ी पहचानकर ले ली। ");
INSERT INTO hin2017_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","फिर यहोवा ने मूसा से कहा, “हारून की छड़ी को साक्षीपत्र के सामने फिर रख दे, कि यह उन बलवा करनेवालों के लिये एक निशान बनकर रखी रहे, कि तू उनका बुड़बुड़ाना जो मेरे विरुद्ध होता रहता है भविष्य में रोक सके, ऐसा न हो कि वे मर जाएँ।” (इब्रा. 9:4) ");
INSERT INTO hin2017_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","और मूसा ने यहोवा की इस आज्ञा के अनुसार ही किया। ");
INSERT INTO hin2017_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","तब इस्राएली मूसा से कहने लगे, देख, “हमारे प्राण निकलने वाले हैं, हम नष्ट हुए, हम सब के सब नष्ट हुए जाते हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","जो कोई यहोवा के निवास के तम्बू के समीप जाता है वह मारा जाता है। तो क्या हम सब के सब मर ही जाएँगे?” ");
INSERT INTO hin2017_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","फिर यहोवा ने हारून से कहा, “पवित्रस्थान के विरुद्ध अधर्म का भार तुझ पर, और तेरे पुत्रों और तेरे पिता के घराने पर होगा; और तुम्हारे याजक कर्म के विरुद्ध अधर्म का भार तुझ पर और तेरे पुत्रों पर होगा। ");
INSERT INTO hin2017_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","और लेवी का गोत्र, अर्थात् तेरे मूलपुरुष के गोत्रवाले जो तेरे भाई हैं, उनको भी अपने साथ ले आया कर, और वे तुझ से मिल जाएँ, और तेरी सेवा टहल किया करें, परन्तु साक्षीपत्र के तम्बू के सामने तू और तेरे पुत्र ही आया करें। ");
INSERT INTO hin2017_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","जो तुझे सौंपा गया है उसकी और सारे तम्बू की भी वे रक्षा किया करें; परन्तु पवित्रस्थान के पात्रों के और वेदी के समीप न आएँ, ऐसा न हो कि वे और तुम लोग भी मर जाओ। ");
INSERT INTO hin2017_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","अतः वे तुझ से मिल जाएँ, और मिलापवाले तम्बू की सारी सेवकाई की वस्तुओं की रक्षा किया करें; परन्तु जो तेरे कुल का न हो वह तुम लोगों के समीप न आने पाए। ");
INSERT INTO hin2017_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","और पवित्रस्थान और वेदी की रखवाली तुम ही किया करो, जिससे इस्राएलियों पर फिर मेरा कोप न भड़के। ");
INSERT INTO hin2017_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","परन्तु मैंने आप तुम्हारे लेवी भाइयों को इस्राएलियों के बीच से अलग कर लिया है, और वे मिलापवाले तम्बू की सेवा करने के लिये तुम को और यहोवा को सौंप दिये गए हैं। (इब्रा. 9:6) ");
INSERT INTO hin2017_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","पर वेदी की और बीचवाले पर्दे के भीतर की बातों की सेवकाई के लिये तू और तेरे पुत्र अपने याजकपद की रक्षा करना, और तुम ही सेवा किया करना; क्योंकि मैं तुम्हें याजकपद की सेवकाई दान करता हूँ; और जो तेरे कुल का न हो वह यदि समीप आए तो मार डाला जाए।” ");
INSERT INTO hin2017_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","फिर यहोवा ने हारून से कहा, “सुन, मैं आप तुझको उठाई हुई भेंट सौंप देता हूँ, अर्थात् इस्राएलियों की पवित्र की हुई वस्तुएँ; जितनी हों उन्हें मैं तेरा अभिषेक वाला भाग ठहराकर तुझे और तेरे पुत्रों को सदा का हक़ करके दे देता हूँ। (1 कुरि. 9:13) ");
INSERT INTO hin2017_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","जो परमपवित्र वस्तुएँ आग में भस्म न की जाएँगी वे तेरी ही ठहरें, अर्थात् इस्राएलियों के सब चढ़ावों में से उनके सब अन्नबलि, सब पापबलि, और सब दोषबलि, जो वे मुझ को दें, वह तेरे और तेरे पुत्रों के लिये परमपवित्र ठहरें। ");
INSERT INTO hin2017_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","उनको परमपवित्र वस्तु जानकर खाया करना; उनको हर एक पुरुष खा सकता है; वे तेरे लिये पवित्र हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","फिर ये वस्तुएँ भी तेरी ठहरें, अर्थात् जितनी भेंटें इस्राएली हिलाने के लिये दें, उनको मैं तुझे और तेरे बेटे-बेटियों को सदा का हक़ करके दे देता हूँ; तेरे घराने में जितने शुद्ध हों वह उन्हें खा सकेंगे। ");
INSERT INTO hin2017_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","फिर उत्तम से उत्तम नया दाखमधु, और गेहूँ, अर्थात् इनकी पहली उपज जो वे यहोवा को दें, वह मैं तुझको देता हूँ। ");
INSERT INTO hin2017_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","उनके देश के सब प्रकार की पहली उपज, जो वे यहोवा के लिये ले आएँ, वह तेरी ही ठहरे; तेरे घराने में जितने शुद्ध हों वे उन्हें खा सकेंगे। ");
INSERT INTO hin2017_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","इस्राएलियों में जो कुछ अर्पण किया जाए वह भी तेरा ही ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","सब प्राणियों में से जितने अपनी-अपनी माँ के पहलौठे हों, जिन्हें लोग यहोवा के लिये चढ़ाएँ, चाहे मनुष्य के चाहे पशु के पहलौठे हों, वे सब तेरे ही ठहरें; परन्तु मनुष्यों और अशुद्ध पशुओं के पहिलौठों को दाम लेकर छोड़ देना। ");
INSERT INTO hin2017_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","और जिन्हें छुड़ाना हो, जब वे महीने भर के हों तब उनके लिये अपने ठहराए हुए मोल के अनुसार, अर्थात् पवित्रस्थान के बीस गेरा के शेकेल के हिसाब से पाँच शेकेल लेकर उन्हें छोड़ना। ");
INSERT INTO hin2017_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","पर गाय, या भेड़ी, या बकरी के पहलौठे को न छोड़ना; वे तो पवित्र हैं। उनके लहू को वेदी पर छिड़क देना, और उनकी चर्बी को बलि करके जलाना, जिससे यहोवा के लिये सुखदायक सुगन्ध हो; ");
INSERT INTO hin2017_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","परन्तु उनका माँस तेरा ठहरे, और हिलाई हुई छाती, और दाहिनी जाँघ भी तेरी ही ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","पवित्र वस्तुओं की जितनी भेंटें इस्राएली यहोवा को दें, उन सभी को मैं तुझे और तेरे बेटे-बेटियों को सदा का हक़ करके दे देता हूँ यह तो तेरे और तेरे वंश के लिये यहोवा की सदा के लिये नमक की अटल वाचा है।” ");
INSERT INTO hin2017_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","फिर यहोवा ने हारून से कहा, “इस्राएलियों के देश में तेरा कोई भाग न होगा, और न उनके बीच तेरा कोई अंश होगा; उनके बीच तेरा भाग और तेरा अंश मैं ही हूँ। ");
INSERT INTO hin2017_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“फिर मिलापवाले तम्बू की जो सेवा लेवी करते हैं उसके बदले मैं उनको इस्राएलियों का सब दशमांश उनका निज भाग कर देता हूँ। (इब्रा. 7:5) ");
INSERT INTO hin2017_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","और भविष्य में इस्राएली मिलापवाले तम्बू के समीप न आएँ, ऐसा न हो कि उनके सिर पर पाप लगे, और वे मर जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","परन्तु लेवी मिलापवाले तम्बू की सेवा किया करें, और उनके अधर्म का भार वे ही उठाया करें; यह तुम्हारी पीढ़ियों में सदा की विधि ठहरे; और इस्राएलियों के बीच उनका कोई निज भाग न होगा। ");
INSERT INTO hin2017_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","क्योंकि इस्राएली जो दशमांश यहोवा को उठाई हुई भेंट करके देंगे, उसे मैं लेवियों को निज भाग करके देता हूँ, इसलिए मैंने उनके विषय में कहा है, कि इस्राएलियों के बीच कोई भाग उनको न मिले।” ");
INSERT INTO hin2017_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“तू लेवियों से कह, कि जब जब तुम इस्राएलियों के हाथ से वह दशमांश लो जिसे यहोवा तुम को तुम्हारा निज भाग करके उनसे दिलाता है, तब-तब उसमें से यहोवा के लिये एक उठाई हुई भेंट करके दशमांश का दशमांश देना। ");
INSERT INTO hin2017_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","और तुम्हारी उठाई हुई भेंट तुम्हारे हित के लिये ऐसी गिनी जाएगी जैसा खलिहान में का अन्न, या रसकुण्ड में का दाखरस गिना जाता है। ");
INSERT INTO hin2017_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","इस रीति तुम भी अपने सब दशमांशों में से, जो इस्राएलियों की ओर से पाओगे, यहोवा को एक उठाई हुई भेंट देना; और यहोवा की यह उठाई हुई भेंट हारून याजक को दिया करना। ");
INSERT INTO hin2017_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","जितने दान तुम पाओ उनमें से हर एक का उत्तम से उत्तम भाग, जो पवित्र ठहरा है, उसे यहोवा के लिये उठाई हुई भेंट करके पूरी-पूरी देना। ");
INSERT INTO hin2017_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","इसलिए तू लेवियों से कह, कि जब तुम उसमें का उत्तम से उत्तम भाग उठाकर दो, तब यह तुम्हारे लिये खलिहान में के अन्न, और रसकुण्ड के रस के तुल्य गिना जाएगा; ");
INSERT INTO hin2017_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","और उसको तुम अपने घरानों समेत सब स्थानों में खा सकते हो, क्योंकि मिलापवाले तम्बू की जो सेवा तुम करोगे उसका बदला यही ठहरा है। (मत्ती 10:10, 1 कुरि. 9:13) ");
INSERT INTO hin2017_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","और जब तुम उसका उत्तम से उत्तम भाग उठाकर दो तब उसके कारण तुम को पाप न लगेगा। परन्तु इस्राएलियों की पवित्र की हुई वस्तुओं को अपवित्र न करना, ऐसा न हो कि तुम मर जाओ।” ");
INSERT INTO hin2017_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","फिर यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“व्यवस्था की जिस विधि की आज्ञा यहोवा देता है वह यह है; कि तू इस्राएलियों से कह, कि मेरे पास एक लाल निर्दोष बछिया ले आओ, जिसमें कोई भी दोष न हो, और जिस पर जूआ कभी न रखा गया हो। ");
INSERT INTO hin2017_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","तब उसे एलीआजर याजक को दो, और वह उसे छावनी से बाहर ले जाए, और कोई उसको एलीआजर याजक के सामने बलिदान करे; ");
INSERT INTO hin2017_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","तब एलीआजर याजक अपनी उँगली से उसका कुछ लहू लेकर मिलापवाले तम्बू के सामने की ओर सात बार छिड़क दे। ");
INSERT INTO hin2017_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","तब कोई उस बछिया को खाल, माँस, लहू, और गोबर समेत उसके सामने जलाए; ");
INSERT INTO hin2017_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","और याजक देवदार की लकड़ी, जूफा, और लाल रंग का कपड़ा लेकर उस आग में जिसमें बछिया जलती हो डाल दे। (इब्रा. 9:19) ");
INSERT INTO hin2017_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","तब वह अपने वस्त्र धोए और स्नान करे, इसके बाद छावनी में तो आए, परन्तु साँझ तक अशुद्ध रहेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","और जो मनुष्य उसको जलाए वह भी जल से अपने वस्त्र धोए और स्नान करे, और साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","फिर कोई शुद्ध पुरुष उस बछिया की राख बटोरकर छावनी के बाहर किसी शुद्ध स्थान में रख छोड़े; और वह राख इस्राएलियों की मण्डली के लिये अशुद्धता से छुड़ानेवाले जल के लिये रखी रहे; वह तो पापबलि है। (इब्रा. 9:13) ");
INSERT INTO hin2017_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","और जो मनुष्य बछिया की राख बटोरे वह अपने वस्त्र धोए, और साँझ तक अशुद्ध रहेगा। और यह इस्राएलियों के लिये, और उनके बीच रहनेवाले परदेशियों के लिये भी सदा की विधि ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“जो किसी मनुष्य के शव को छूए वह सात दिन तक अशुद्ध रहे; ");
INSERT INTO hin2017_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ऐसा मनुष्य तीसरे दिन पाप छुड़ाकर अपने को पावन करे, और सातवें दिन शुद्ध ठहरे; परन्तु यदि वह तीसरे दिन अपने आपको पाप छुड़ाकर पावन न करे, तो सातवें दिन शुद्ध न ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","जो कोई किसी मनुष्य का शव छूकर पाप छुड़ाकर अपने को पावन न करे, वह यहोवा के निवास-स्थान का अशुद्ध करनेवाला ठहरेगा, और वह मनुष्य इस्राएल में से नाश किया जाए; क्योंकि अशुद्धता से छुड़ानेवाला जल उस पर न छिड़का गया, इस कारण वह अशुद्ध ठहरेगा, उसकी अशुद्धता उसमें बनी रहेगी। ");
INSERT INTO hin2017_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“यदि कोई मनुष्य डेरे में मर जाए तो व्यवस्था यह है, कि जितने उस डेरे में रहें, या उसमें जाएँ, वे सब सात दिन तक अशुद्ध रहें। ");
INSERT INTO hin2017_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","और हर एक खुला हुआ पात्र, जिस पर कोई ढकना लगा न हो, वह अशुद्ध ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","और जो कोई मैदान में तलवार से मारे हुए को, या मृत शरीर को, या मनुष्य की हड्डी को, या किसी कब्र को छूए, तो सात दिन तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","अशुद्ध मनुष्य के लिये जलाए हुए पापबलि की राख में से कुछ लेकर पात्र में डालकर उस पर सोते का जल डाला जाए; ");
INSERT INTO hin2017_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","तब कोई शुद्ध मनुष्य जूफा लेकर उस जल में डुबाकर जल को उस डेरे पर, और जितने पात्र और मनुष्य उसमें हों, उन पर छिड़के, और हड्डी के, या मारे हुए के, या मृत शरीर को, या कब्र के छूनेवाले पर छिड़क दे; ");
INSERT INTO hin2017_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","वह शुद्ध पुरुष तीसरे दिन और सातवें दिन उस अशुद्ध मनुष्य पर छिड़के; और सातवें दिन वह उसके पाप छुड़ाकर उसको पावन करे, तब वह अपने वस्त्रों को धोकर और जल से स्नान करके साँझ को शुद्ध ठहरे। (इब्रा. 9:13) ");
INSERT INTO hin2017_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“जो कोई अशुद्ध होकर अपने पाप छुड़ाकर अपने को पावन न कराए, वह मनुष्य यहोवा के पवित्रस्थान का अशुद्ध करनेवाला ठहरेगा, इस कारण वह मण्डली के बीच में से नाश किया जाए; अशुद्धता से छुड़ानेवाला जल उस पर न छिड़का गया, इस कारण से वह अशुद्ध ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","और यह उनके लिये सदा की विधि ठहरे। जो अशुद्धता से छुड़ानेवाला जल छिड़के वह अपने वस्त्रों को धोए; और जो जन अशुद्धता से छुड़ानेवाला जल छूए वह भी साँझ तक अशुद्ध रहे। ");
INSERT INTO hin2017_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","और जो कुछ वह अशुद्ध मनुष्य छूए वह भी अशुद्ध ठहरे; और जो मनुष्य उस वस्तु को छूए वह भी साँझ तक अशुद्ध रहे।” ");
INSERT INTO hin2017_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","पहले महीने में सारी इस्राएली मण्डली के लोग सीन नामक जंगल में आ गए, और कादेश में रहने लगे; और वहाँ मिर्याम मर गई, और वहीं उसको मिट्टी दी गई। ");
INSERT INTO hin2017_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","वहाँ मण्डली के लोगों के लिये पानी न मिला; इसलिए वे मूसा और हारून के विरुद्ध इकट्ठे हुए। ");
INSERT INTO hin2017_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","और लोग यह कहकर मूसा से झगड़ने लगे, “भला होता कि हम उस समय ही मर गए होते जब हमारे भाई यहोवा के सामने मर गए! ");
INSERT INTO hin2017_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","और तुम यहोवा की मण्डली को इस जंगल में क्यों ले आए हो, कि हम अपने पशुओं समेत यहाँ मर जाए? ");
INSERT INTO hin2017_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","और तुम ने हमको मिस्र से क्यों निकालकर इस बुरे स्थान में पहुँचाया है? यहाँ तो बीज, या अंजीर, या दाखलता, या अनार, कुछ नहीं है, यहाँ तक कि पीने को कुछ पानी भी नहीं है।” (इब्रा. 3:8) ");
INSERT INTO hin2017_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","तब मूसा और हारून मण्डली के सामने से मिलापवाले तम्बू के द्वार पर जाकर अपने मुँह के बल गिरे। और यहोवा का तेज उनको दिखाई दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“उस लाठी को ले, और तू अपने भाई हारून समेत मण्डली को इकट्ठा करके उनके देखते उस चट्टान से बातें कर, तब वह अपना जल देगी; इस प्रकार से तू चट्टान में से उनके लिये जल निकालकर मण्डली के लोगों और उनके पशुओं को पिला।” ");
INSERT INTO hin2017_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","यहोवा की इस आज्ञा के अनुसार मूसा ने उसके सामने से लाठी को ले लिया। ");
INSERT INTO hin2017_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","और मूसा और हारून ने मण्डली को उस चट्टान के सामने इकट्ठा किया, तब मूसा ने उससे कहा, “हे बलवा करनेवालों, सुनो; क्या हमको इस चट्टान में से तुम्हारे लिये जल निकालना होगा?” ");
INSERT INTO hin2017_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","तब मूसा ने हाथ उठाकर लाठी चट्टान पर दो बार मारी; और उसमें से बहुत पानी फूट निकला, और मण्डली के लोग अपने पशुओं समेत पीने लगे। (1 कुरि. 10:4) ");
INSERT INTO hin2017_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","परन्तु मूसा और हारून से यहोवा ने कहा, “तुम ने जो मुझ पर विश्वास नहीं किया, और मुझे इस्राएलियों की दृष्टि में पवित्र नहीं ठहराया, इसलिए तुम इस मण्डली को उस देश में पहुँचाने न पाओगे जिसे मैंने उन्हें दिया है।” ");
INSERT INTO hin2017_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","उस सोते का नाम मरीबा पड़ा, क्योंकि इस्राएलियों ने यहोवा से झगड़ा किया था, और वह उनके बीच पवित्र ठहराया गया। ");
INSERT INTO hin2017_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","फिर मूसा ने कादेश से एदोम के राजा के पास दूत भेजे, “तेरा भाई इस्राएल यह कहता है, कि हम पर जो-जो क्लेश पड़े हैं वह तू जानता होगा; ");
INSERT INTO hin2017_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","अर्थात् यह कि हमारे पुरखा मिस्र में गए थे, और हम मिस्र में बहुत दिन रहे; और मिस्रियों ने हमारे पुरखाओं के साथ और हमारे साथ भी बुरा बर्ताव किया; ");
INSERT INTO hin2017_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","परन्तु जब हमने यहोवा की दुहाई दी तब उसने हमारी सुनी, और एक दूत को भेजकर हमें मिस्र से निकाल ले आया है; इसलिए अब हम कादेश नगर में हैं जो तेरी सीमा ही पर है। ");
INSERT INTO hin2017_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","अतः हमें अपने देश में से होकर जाने दे। हम किसी खेत या दाख की बारी से होकर न चलेंगे, और कुओं का पानी न पीएँगे; सड़क ही सड़क से होकर चले जाएँगे, और जब तक तेरे देश से बाहर न हो जाएँ, तब तक न दाएँ न बाएँ मुड़ेंगे।” ");
INSERT INTO hin2017_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","परन्तु एदोमियों के राजा ने उसके पास कहला भेजा, “तू मेरे देश में से होकर मत जा, नहीं तो मैं तलवार लिये हुए तेरा सामना करने को निकलूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","इस्राएलियों ने उसके पास फिर कहला भेजा, “हम सड़क ही सड़क से चलेंगे, और यदि हम और हमारे पशु तेरा पानी पीएँ, तो उसका दाम देंगे, हमको और कुछ नहीं, केवल पाँव-पाँव चलकर निकल जाने दे।” ");
INSERT INTO hin2017_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","परन्तु उसने कहा, “तू आने न पाएगा।” और एदोम बड़ी सेना लेकर भुजबल से उसका सामना करने को निकल आया। ");
INSERT INTO hin2017_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","इस प्रकार एदोम ने इस्राएल को अपने देश के भीतर से होकर जाने देने से इन्कार किया; इसलिए इस्राएल उसकी ओर से मुड़ गए। ");
INSERT INTO hin2017_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","तब इस्राएलियों की सारी मण्डली कादेश से कूच करके होर नामक पहाड़ के पास आ गई। (गिन. 33:37, 21:4) ");
INSERT INTO hin2017_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","और एदोम देश की सीमा पर होर पहाड़ में यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“हारून अपने लोगों में जा मिलेगा; क्योंकि तुम दोनों ने जो मरीबा नामक सोते पर मेरा कहना न मानकर मुझसे बलवा किया है, इस कारण वह उस देश में जाने न पाएगा जिसे मैंने इस्राएलियों को दिया है। (व्यव. 32:50) ");
INSERT INTO hin2017_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","इसलिए तू हारून और उसके पुत्र एलीआजर को होर पहाड़ पर ले चल; ");
INSERT INTO hin2017_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","और हारून के वस्त्र उतारकर उसके पुत्र एलीआजर को पहना; तब हारून वहीं मरकर अपने लोगों में जा मिलेगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","यहोवा की इस आज्ञा के अनुसार मूसा ने किया; वे सारी मण्डली के देखते होर पहाड़ पर चढ़ गए। ");
INSERT INTO hin2017_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","तब मूसा ने हारून के वस्त्र उतारकर उसके पुत्र एलीआजर को पहनाए और हारून वहीं पहाड़ की चोटी पर मर गया। तब मूसा और एलीआजर पहाड़ पर से उतर आए। ");
INSERT INTO hin2017_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","और जब इस्राएल की सारी मण्डली ने देखा कि हारून का प्राण छूट गया है, तब इस्राएल के सब घराने के लोग उसके लिये तीस दिन तक रोते रहे। (उत्प. 50:3, व्यव. 34:8) ");
INSERT INTO hin2017_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","तब अराद का कनानी राजा, जो दक्षिण देश में रहता था, यह सुनकर कि जिस मार्ग से वे भेदिए आए थे उसी मार्ग से अब इस्राएली आ रहे हैं, इस्राएल से लड़ा, और उनमें से कुछ को बन्धुआ कर लिया। ");
INSERT INTO hin2017_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","तब इस्राएलियों ने यहोवा से यह कहकर मन्नत मानी, “यदि तू सचमुच उन लोगों को हमारे वश में कर दे, तो हम उनके नगरों को सत्यानाश कर देंगे।” ");
INSERT INTO hin2017_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","इस्राएल की यह बात सुनकर यहोवा ने कनानियों को उनके वश में कर दिया; अतः उन्होंने उनके नगरों समेत उनको भी सत्यानाश किया; इससे उस स्थान का नाम होर्मा रखा गया। ");
INSERT INTO hin2017_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","फिर उन्होंने होर पहाड़ से कूच करके लाल समुद्र का मार्ग लिया कि एदोम देश से बाहर-बाहर घूमकर जाएँ; और लोगों का मन मार्ग के कारण बहुत व्याकुल हो गया। ");
INSERT INTO hin2017_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","इसलिए वे परमेश्वर के विरुद्ध बात करने लगे, और मूसा से कहा, “तुम लोग हमको मिस्र से जंगल में मरने के लिये क्यों ले आए हो? यहाँ न तो रोटी है, और न पानी, और हमारे प्राण इस निकम्मी रोटी से दुःखित हैं।” ");
INSERT INTO hin2017_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","अतः यहोवा ने उन लोगों में तेज विषवाले साँप भेजे, जो उनको डसने लगे, और बहुत से इस्राएली मर गए। (1 कुरि. 10:9) ");
INSERT INTO hin2017_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","तब लोग मूसा के पास जाकर कहने लगे, “हमने पाप किया है, कि हमने यहोवा के और तेरे विरुद्ध बातें की हैं; यहोवा से प्रार्थना कर कि वह साँपों को हम से दूर करे।” तब मूसा ने उनके लिये प्रार्थना की। ");
INSERT INTO hin2017_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","यहोवा ने मूसा से कहा, “एक तेज विषवाले साँप की प्रतिमा बनवाकर खम्भे पर लटका; तब जो साँप से डसा हुआ उसको देख ले वह जीवित बचेगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","अतः मूसा ने पीतल का एक साँप बनवाकर खम्भे पर लटकाया; तब साँप के डसे हुओं में से जिस-जिसने उस पीतल के साँप की ओर देखा वह जीवित बच गया। (यूह. 3:14) ");
INSERT INTO hin2017_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","फिर इस्राएलियों ने कूच करके ओबोत में डेरे डालें। ");
INSERT INTO hin2017_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","और ओबोत से कूच करके अबारीम में डेरे डालें, जो पूर्व की ओर मोआब के सामने के जंगल में है। ");
INSERT INTO hin2017_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","वहाँ से कूच करके उन्होंने जेरेद नामक नाले में डेरे डालें। ");
INSERT INTO hin2017_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","वहाँ से कूच करके उन्होंने अर्नोन नदी, जो जंगल में बहती और एमोरियों के देश से निकलती है, उसकी दूसरी ओर डेरे खड़े किए; क्योंकि अर्नोन मोआबियों और एमोरियों के बीच होकर मोआब देश की सीमा ठहरी है। ");
INSERT INTO hin2017_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","इस कारण यहोवा के संग्राम नामक पुस्तक में इस प्रकार लिखा है, “सूपा में वाहेब, और अर्नोन की घाटी, ");
INSERT INTO hin2017_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","और उन घाटियों की ढलान जो आर नामक नगर की ओर है, और जो मोआब की सीमा पर है।” ");
INSERT INTO hin2017_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","फिर वहाँ से कूच करके वे बैर तक गए; वहाँ वही कुआँ है जिसके विषय में यहोवा ने मूसा से कहा था, “उन लोगों को इकट्ठा कर, और मैं उन्हें पानी दूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","उस समय इस्राएल ने यह गीत गाया, “हे कुएँ, उमड़ आ, उस कुएँ के विषय में गाओ! ");
INSERT INTO hin2017_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","जिसको हाकिमों ने खोदा, और इस्राएल के रईसों ने अपने सोंटों और लाठियों से खोद लिया।” फिर वे जंगल से मत्ताना को, ");
INSERT INTO hin2017_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","और मत्ताना से नहलीएल को, और नहलीएल से बामोत को, ");
INSERT INTO hin2017_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","और बामोत से कूच करके उस तराई तक जो मोआब के मैदान में है, और पिसगा के उस सिरे तक भी जो यशीमोन की ओर झुका है पहुँच गए। ");
INSERT INTO hin2017_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","तब इस्राएल ने एमोरियों के राजा सीहोन के पास दूतों से यह कहला भेजा, ");
INSERT INTO hin2017_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“हमें अपने देश में होकर जाने दे; हम मुड़कर किसी खेत या दाख की बारी में तो न जाएँगे; न किसी कुएँ का पानी पीएँगे; और जब तक तेरे देश से बाहर न हो जाएँ तब तक सड़क ही से चले जाएँगे।” ");
INSERT INTO hin2017_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","फिर भी सीहोन ने इस्राएल को अपने देश से होकर जाने न दिया; वरन् अपनी सारी सेना को इकट्ठा करके इस्राएल का सामना करने को जंगल में निकल आया, और यहस को आकर उनसे लड़ा। ");
INSERT INTO hin2017_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","तब इस्राएलियों ने उसको तलवार से मार दिया, और अर्नोन से यब्बोक नदी तक, जो अम्मोनियों की सीमा थी, उसके देश के अधिकारी हो गए; अम्मोनियों की सीमा तो दृढ़ थी। ");
INSERT INTO hin2017_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","इसलिए इस्राएल ने एमोरियों के सब नगरों को ले लिया, और उनमें, अर्थात् हेशबोन और उसके आस-पास के नगरों में रहने लगे। ");
INSERT INTO hin2017_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","हेशबोन एमोरियों के राजा सीहोन का नगर था; उसने मोआब के पिछले राजा से लड़कर उसका सारा देश अर्नोन तक उसके हाथ से छीन लिया था। ");
INSERT INTO hin2017_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","इस कारण गूढ़ बात के कहनेवाले कहते हैं, “हेशबोन में आओ, सीहोन का नगर बसे, और दृढ़ किया जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","क्योंकि हेशबोन से आग, सीहोन के नगर से लौ निकली; जिससे मोआब देश का आर नगर, और अर्नोन के ऊँचे स्थानों के स्वामी भस्म हुए। ");
INSERT INTO hin2017_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","हे मोआब, तुझ पर हाय! कमोश देवता की प्रजा नाश हुई, उसने अपने बेटों को भगोड़ा, और अपनी बेटियों को एमोरी राजा सीहोन की दासी कर दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","हमने उन्हें गिरा दिया है, हेशबोन दीबोन तक नष्ट हो गया है, और हमने नोपह और मेदबा तक भी उजाड़ दिया है।” ");
INSERT INTO hin2017_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","इस प्रकार इस्राएल एमोरियों के देश में रहने लगा। ");
INSERT INTO hin2017_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","तब मूसा ने याजेर नगर का भेद लेने को भेजा; और उन्होंने उसके गाँवों को ले लिया, और वहाँ के एमोरियों को उस देश से निकाल दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","तब वे मुड़कर बाशान के मार्ग से जाने लगे; और बाशान के राजा ओग ने उनका सामना किया, वह लड़ने को अपनी सारी सेना समेत एद्रेई में निकल आया। ");
INSERT INTO hin2017_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","तब यहोवा ने मूसा से कहा, “उससे मत डर; क्योंकि मैं उसको सारी सेना और देश समेत तेरे हाथ में कर देता हूँ; और जैसा तूने एमोरियों के राजा हेशबोनवासी सीहोन के साथ किया है, वैसा ही उसके साथ भी करना।” ");
INSERT INTO hin2017_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","तब उन्होंने उसको, और उसके पुत्रों और सारी प्रजा को यहाँ तक मारा कि उसका कोई भी न बचा; और वे उसके देश के अधिकारी हो गए। ");
INSERT INTO hin2017_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","तब इस्राएलियों ने कूच करके यरीहो के पास यरदन नदी के इस पार मोआब के अराबा में डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","और सिप्पोर के पुत्र बालाक ने देखा कि इस्राएल ने एमोरियों से क्या-क्या किया है। ");
INSERT INTO hin2017_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","इसलिए मोआब यह जानकर, कि इस्राएली बहुत हैं, उन लोगों से अत्यन्त डर गया; यहाँ तक कि मोआब इस्राएलियों के कारण अत्यन्त व्याकुल हुआ। ");
INSERT INTO hin2017_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","तब मोआबियों ने मिद्यानी पुरनियों से कहा, “अब वह दल हमारे चारों ओर के सब लोगों को चट कर जाएगा, जिस तरह बैल खेत की हरी घास को चट कर जाता है।” उस समय सिप्पोर का पुत्र बालाक मोआब का राजा था; ");
INSERT INTO hin2017_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","और इसने पतोर नगर को, जो फरात के तट पर बोर के पुत्र बिलाम के जातिभाइयों की भूमि थी, वहाँ बिलाम के पास दूत भेजे कि वे यह कहकर उसे बुला लाएँ, “सुन एक दल मिस्र से निकल आया है, और भूमि उनसे ढक गई है, और अब वे मेरे सामने ही आकर बस गए हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","इसलिए आ, और उन लोगों को मेरे निमित्त श्राप दे, क्योंकि वे मुझसे अधिक बलवन्त हैं, तब सम्भव है कि हम उन पर जयवन्त हों, और हम सब इनको अपने देश से मारकर निकाल दें; क्योंकि यह तो मैं जानता हूँ कि जिसको तू आशीर्वाद देता है वह धन्य होता है, और जिसको तू श्राप देता है वह श्रापित होता है।” ");
INSERT INTO hin2017_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","तब मोआबी और मिद्यानी पुरनिये भावी कहने की दक्षिणा लेकर चले, और बिलाम के पास पहुँचकर बालाक की बातें कह सुनाईं। (2 पत. 2:15, यहू. 1:1) ");
INSERT INTO hin2017_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","उसने उनसे कहा, “आज रात को यहाँ टिको, और जो बात यहोवा मुझसे कहेगा, उसी के अनुसार मैं तुम को उत्तर दूँगा।” तब मोआब के हाकिम बिलाम के यहाँ ठहर गए। ");
INSERT INTO hin2017_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","तब परमेश्वर ने बिलाम के पास आकर पूछा, “तेरे यहाँ ये पुरुष कौन हैं?” ");
INSERT INTO hin2017_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","बिलाम ने परमेश्वर से कहा, “सिप्पोर के पुत्र मोआब के राजा बालाक ने मेरे पास यह कहला भेजा है, ");
INSERT INTO hin2017_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘सुन, जो दल मिस्र से निकल आया है उससे भूमि ढँप गई है; इसलिए आकर मेरे लिये उन्हें श्राप दे; सम्भव है कि मैं उनसे लड़कर उनको बरबस निकाल सकूँगा।’” ");
INSERT INTO hin2017_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","परमेश्वर ने बिलाम से कहा, “तू इनके संग मत जा; उन लोगों को श्राप मत दे, क्योंकि वे आशीष के भागी हो चुके हैं।” ");
INSERT INTO hin2017_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","भोर को बिलाम ने उठकर बालाक के हाकिमों से कहा, “तुम अपने देश को चले जाओ; क्योंकि यहोवा मुझे तुम्हारे साथ जाने की आज्ञा नहीं देता।” ");
INSERT INTO hin2017_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","तब मोआबी हाकिम चले गए और बालाक के पास जाकर कहा, “बिलाम ने हमारे साथ आने से मना किया है।” ");
INSERT INTO hin2017_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","इस पर बालाक ने फिर और हाकिम भेजे, जो पहले से प्रतिष्ठित और गिनती में भी अधिक थे। ");
INSERT INTO hin2017_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","उन्होंने बिलाम के पास आकर कहा, “सिप्पोर का पुत्र बालाक यह कहता है, ‘मेरे पास आने से किसी कारण मना मत कर; ");
INSERT INTO hin2017_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","क्योंकि मैं निश्चय तेरी बड़ी प्रतिष्ठा करूँगा, और जो कुछ तू मुझसे कहे वही मैं करूँगा; इसलिए आ, और उन लोगों को मेरे निमित्त श्राप दे।’” ");
INSERT INTO hin2017_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","बिलाम ने बालाक के कर्मचारियों को उत्तर दिया, “चाहे बालाक अपने घर को सोने चाँदी से भरकर मुझे दे दे, तो भी मैं अपने परमेश्वर यहोवा की आज्ञा को पलट नहीं सकता, कि उसे घटाकर व बढ़ाकर मानूँ। ");
INSERT INTO hin2017_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","इसलिए अब तुम लोग आज रात को यहीं टिके रहो, ताकि मैं जान लूँ, कि यहोवा मुझसे और क्या कहता है।” ");
INSERT INTO hin2017_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","और परमेश्वर ने रात को बिलाम के पास आकर कहा, “यदि वे पुरुष तुझे बुलाने आए हैं, तो तू उठकर उनके संग जा; परन्तु जो बात मैं तुझ से कहूँ उसी के अनुसार करना।” ");
INSERT INTO hin2017_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","तब बिलाम भोर को उठा, और अपनी गदही पर काठी बाँधकर मोआबी हाकिमों के संग चल पड़ा। ");
INSERT INTO hin2017_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","और उसके जाने के कारण परमेश्वर का कोप भड़क उठा, और यहोवा का दूत उसका विरोध करने के लिये मार्ग रोककर खड़ा हो गया। वह तो अपनी गदही पर सवार होकर जा रहा था, और उसके संग उसके दो सेवक भी थे। ");
INSERT INTO hin2017_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","और उस गदही को यहोवा का दूत हाथ में नंगी तलवार लिये हुए मार्ग में खड़ा दिखाई पड़ा; तब गदही मार्ग छोड़कर खेत में चली गई; तब बिलाम ने गदही को मारा कि वह मार्ग पर फिर आ जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","तब यहोवा का दूत दाख की बारियों के बीच की गली में, जिसके दोनों ओर बारी की दीवार थी, खड़ा हुआ। ");
INSERT INTO hin2017_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","यहोवा के दूत को देखकर गदही दीवार से ऐसी सट गई कि बिलाम का पाँव दीवार से दब गया; तब उसने उसको फिर मारा। ");
INSERT INTO hin2017_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","तब यहोवा का दूत आगे बढ़कर एक सकरे स्थान पर खड़ा हुआ, जहाँ न तो दाहिनी ओर हटने की जगह थी और न बाईं ओर। ");
INSERT INTO hin2017_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","वहाँ यहोवा के दूत को देखकर गदही बिलाम को लिये हुए बैठ गई; फिर तो बिलाम का कोप भड़क उठा, और उसने गदही को लाठी से मारा। ");
INSERT INTO hin2017_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","तब यहोवा ने गदही का मुँह खोल दिया, और वह बिलाम से कहने लगी, “मैंने तेरा क्या किया है कि तूने मुझे तीन बार मारा?” (2 पत. 2:16) ");
INSERT INTO hin2017_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","बिलाम ने गदही से कहा, “यह कि तूने मुझसे नटखटी की। यदि मेरे हाथ में तलवार होती तो मैं तुझे अभी मार डालता।” ");
INSERT INTO hin2017_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","गदही ने बिलाम से कहा, “क्या मैं तेरी वही गदही नहीं, जिस पर तू जन्म से आज तक चढ़ता आया है? क्या मैं तुझ से कभी ऐसा करती थी?” वह बोला, “नहीं।” ");
INSERT INTO hin2017_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","तब यहोवा ने बिलाम की आँखें खोलीं, और उसको यहोवा का दूत हाथ में नंगी तलवार लिये हुए मार्ग में खड़ा दिखाई पड़ा; तब वह झुक गया, और मुँह के बल गिरकर दण्डवत् किया। ");
INSERT INTO hin2017_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","यहोवा के दूत ने उससे कहा, “तूने अपनी गदही को तीन बार क्यों मारा? सुन, तेरा विरोध करने को मैं ही आया हूँ, इसलिए कि तू मेरे सामने दुष्ट चाल चलता है; ");
INSERT INTO hin2017_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","और यह गदही मुझे देखकर मेरे सामने से तीन बार हट गई। यदि वह मेरे सामने से हट न जाती, तो निःसन्देह मैं अब तक तुझको मार ही डालता, परन्तु उसको जीवित छोड़ देता।” ");
INSERT INTO hin2017_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","तब बिलाम ने यहोवा के दूत से कहा, “मैंने पाप किया है; मैं नहीं जानता था कि तू मेरा सामना करने को मार्ग में खड़ा है। इसलिए अब यदि तुझे बुरा लगता है, तो मैं लौट जाता हूँ।” ");
INSERT INTO hin2017_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","यहोवा के दूत ने बिलाम से कहा, “इन पुरुषों के संग तू चला जा; परन्तु केवल वही बात कहना जो मैं तुझ से कहूँगा।” तब बिलाम बालाक के हाकिमों के संग चला गया। ");
INSERT INTO hin2017_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","यह सुनकर कि बिलाम आ रहा है, बालाक उससे भेंट करने के लिये मोआब के उस नगर तक जो उस देश के अर्नोनवाले सीमा पर है गया। ");
INSERT INTO hin2017_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","बालाक ने बिलाम से कहा, “क्या मैंने बड़ी आशा से तुझे नहीं बुलवा भेजा था? फिर तू मेरे पास क्यों नहीं चला आया? क्या मैं इस योग्य नहीं कि सचमुच तेरी उचित प्रतिष्ठा कर सकता?” ");
INSERT INTO hin2017_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","बिलाम ने बालाक से कहा, “देख, मैं तेरे पास आया तो हूँ! परन्तु अब क्या मैं कुछ कर सकता हूँ? जो बात परमेश्वर मेरे मुँह में डालेगा, वही बात मैं कहूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","तब बिलाम बालाक के संग-संग चला, और वे किर्यथूसोत तक आए। ");
INSERT INTO hin2017_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","और बालाक ने बैल और भेड़-बकरियों को बलि किया, और बिलाम और उसके साथ के हाकिमों के पास भेजा। ");
INSERT INTO hin2017_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","भोर को बालाक बिलाम को बाल के ऊँचे स्थानों पर चढ़ा ले गया, और वहाँ से उसको सब इस्राएली लोग दिखाई पड़े। ");
INSERT INTO hin2017_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","तब बिलाम ने बालाक से कहा, “यहाँ पर मेरे लिये सात वेदियाँ बनवा, और इसी स्थान पर सात बछड़े और सात मेढ़े तैयार कर।” ");
INSERT INTO hin2017_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","तब बालाक ने बिलाम के कहने के अनुसार किया; और बालाक और बिलाम ने मिलकर प्रत्येक वेदी पर एक बछड़ा और एक मेढ़ा चढ़ाया। ");
INSERT INTO hin2017_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","फिर बिलाम ने बालाक से कहा, “तू अपने होमबलि के पास खड़ा रह, और मैं जाता हूँ; सम्भव है कि यहोवा मुझसे भेंट करने को आए; और जो कुछ वह मुझ पर प्रगट करेगा वही मैं तुझको बताऊँगा।” तब वह एक मुण्डे पहाड़ पर गया। ");
INSERT INTO hin2017_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","और परमेश्वर बिलाम से मिला; और बिलाम ने उससे कहा, “मैंने सात वेदियाँ तैयार की हैं, और प्रत्येक वेदी पर एक बछड़ा और एक मेढ़ा चढ़ाया है।” ");
INSERT INTO hin2017_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","यहोवा ने बिलाम के मुँह में एक बात डाली, और कहा, “बालाक के पास लौट जा, और इस प्रकार कहना।” ");
INSERT INTO hin2017_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","और वह उसके पास लौटकर आ गया, और क्या देखता है कि वह सारे मोआबी हाकिमों समेत अपने होमबलि के पास खड़ा है। ");
INSERT INTO hin2017_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","तब बिलाम ने अपनी गूढ़ बात आरम्भ की, और कहने लगा, “बालाक ने मुझे अराम से, अर्थात् मोआब के राजा ने मुझे पूर्व के पहाड़ों से बुलवा भेजा: ‘आ, मेरे लिये याकूब को श्राप दे, आ, इस्राएल को धमकी दे!’ ");
INSERT INTO hin2017_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","परन्तु जिन्हें परमेश्वर ने श्राप नहीं दिया उन्हें मैं क्यों श्राप दूँ? और जिन्हें यहोवा ने धमकी नहीं दी उन्हें मैं कैसे धमकी दूँ? ");
INSERT INTO hin2017_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","चट्टानों की चोटी पर से वे मुझे दिखाई पड़ते हैं, पहाड़ियों पर से मैं उनको देखता हूँ; वह ऐसी जाति है जो अकेली बसी रहेगी, और अन्यजातियों से अलग गिनी जाएगी! ");
INSERT INTO hin2017_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","याकूब के धूलि के किनके को कौन गिन सकता है, या इस्राएल की चौथाई की गिनती कौन ले सकता है? सौभाग्य यदि मेरी मृत्यु धर्मियों की सी, और मेरा अन्त भी उन्हीं के समान हो!” ");
INSERT INTO hin2017_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","तब बालाक ने बिलाम से कहा, “तूने मुझसे क्या किया है? मैंने तुझे अपने शत्रुओं को श्राप देने को बुलवाया था, परन्तु तूने उन्हें आशीष ही आशीष दी है।” ");
INSERT INTO hin2017_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","उसने कहा, “जो बात यहोवा ने मुझे सिखलाई, क्या मुझे उसी को सावधानी से बोलना न चाहिये?” ");
INSERT INTO hin2017_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","बालाक ने उससे कहा, “मेरे संग दूसरे स्थान पर चल, जहाँ से वे तुझे दिखाई देंगे; तू उन सभी को तो नहीं, केवल बाहरवालों को देख सकेगा; वहाँ से उन्हें मेरे लिये श्राप दे।” ");
INSERT INTO hin2017_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","तब वह उसको सोपीम नामक मैदान में पिसगा के सिरे पर ले गया, और वहाँ सात वेदियाँ बनवाकर प्रत्येक पर एक बछड़ा और एक मेढ़ा चढ़ाया। ");
INSERT INTO hin2017_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","तब बिलाम ने बालाक से कहा, “अपने होमबलि के पास यहीं खड़ा रह, और मैं उधर जाकर यहोवा से भेंट करूँ।” ");
INSERT INTO hin2017_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","और यहोवा ने बिलाम से भेंट की, और उसने उसके मुँह में एक बात डाली, और कहा, “बालाक के पास लौट जा, और इस प्रकार कहना।” ");
INSERT INTO hin2017_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","और वह उसके पास गया, और क्या देखता है कि वह मोआबी हाकिमों समेत अपने होमबलि के पास खड़ा है। और बालाक ने पूछा, “यहोवा ने क्या कहा है?” ");
INSERT INTO hin2017_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","तब बिलाम ने अपनी गूढ़ बात आरम्भ की, और कहने लगा, “हे बालाक, मन लगाकर सुन, हे सिप्पोर के पुत्र, मेरी बात पर कान लगा: ");
INSERT INTO hin2017_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","परमेश्वर मनुष्य नहीं कि झूठ बोले, और न वह आदमी है कि अपनी इच्छा बदले। क्या जो कुछ उसने कहा उसे न करे? क्या वह वचन देकर उसे पूरा न करे? (रोम. 9:6, 2 तीमु. 2:13) ");
INSERT INTO hin2017_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","देख, आशीर्वाद ही देने की आज्ञा मैंने पाई है: वह आशीष दे चुका है, और मैं उसे नहीं पलट सकता। ");
INSERT INTO hin2017_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","उसने याकूब में अनर्थ नहीं पाया; और न इस्राएल में अन्याय देखा है। उसका परमेश्वर यहोवा उसके संग है, और उनमें राजा की सी ललकार होती है। ");
INSERT INTO hin2017_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","उनको मिस्र में से परमेश्वर ही निकाले लिए आ रहा है, वह तो जंगली साँड़ के समान बल रखता है। ");
INSERT INTO hin2017_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","निश्चय कोई मंत्र याकूब पर नहीं चल सकता, और इस्राएल पर भावी कहना कोई अर्थ नहीं रखता; परन्तु याकूब और इस्राएल के विषय में अब यह कहा जाएगा, कि परमेश्वर ने क्या ही विचित्र काम किया है! ");
INSERT INTO hin2017_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","सुन, वह दल सिंहनी के समान उठेगा, और सिंह के समान खड़ा होगा; वह जब तक शिकार को न खा ले, और मरे हुओं के लहू को न पी ले, तब तक न लेटेगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","तब बालाक ने बिलाम से कहा, “उनको न तो श्राप देना, और न आशीष देना।” ");
INSERT INTO hin2017_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","बिलाम ने बालाक से कहा, “क्या मैंने तुझ से नहीं कहा कि जो कुछ यहोवा मुझसे कहेगा, वही मुझे करना पड़ेगा?” ");
INSERT INTO hin2017_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","बालाक ने बिलाम से कहा, “चल मैं तुझको एक और स्थान पर ले चलता हूँ; सम्भव है कि परमेश्वर की इच्छा हो कि तू वहाँ से उन्हें मेरे लिये श्राप दे।” ");
INSERT INTO hin2017_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","तब बालाक बिलाम को पोर के सिरे पर, जहाँ से यशीमोन देश दिखाई देता है, ले गया। ");
INSERT INTO hin2017_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","और बिलाम ने बालाक से कहा, “यहाँ पर मेरे लिये सात वेदियाँ बनवा, और यहाँ सात बछड़े और सात मेढ़े तैयार कर।” ");
INSERT INTO hin2017_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","बिलाम के कहने के अनुसार बालाक ने प्रत्येक वेदी पर एक बछड़ा और एक मेढ़ा चढ़ाया। ");
INSERT INTO hin2017_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","यह देखकर कि यहोवा इस्राएल को आशीष ही दिलाना चाहता है, बिलाम पहले के समान शकुन देखने को न गया, परन्तु अपना मुँह जंगल की ओर कर लिया। ");
INSERT INTO hin2017_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","और बिलाम ने आँखें उठाई, और इस्राएलियों को अपने गोत्र-गोत्र के अनुसार बसे हुए देखा। और परमेश्वर का आत्मा उस पर उतरा। ");
INSERT INTO hin2017_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","तब उसने अपनी गूढ़ बात आरम्भ की, और कहने लगा, “बोर के पुत्र बिलाम की यह वाणी है, जिस पुरुष की आँखें खुली थीं उसी की यह वाणी है, ");
INSERT INTO hin2017_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","परमेश्वर के वचनों का सुननेवाला, जो दण्डवत् में पड़ा हुआ खुली हुई आँखों से सर्वशक्तिमान का दर्शन पाता है, उसी की यह वाणी है कि ");
INSERT INTO hin2017_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","हे याकूब, तेरे डेरे, और हे इस्राएल, तेरे निवास-स्थान क्या ही मनभावने हैं! ");
INSERT INTO hin2017_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","वे तो घाटियों के समान, और नदी के तट की वाटिकाओं के समान ऐसे फैले हुए हैं, जैसे कि यहोवा के लगाए हुए अगर के वृक्ष, और जल के निकट के देवदारू। (इब्रा. 8:2) ");
INSERT INTO hin2017_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","और उसके घड़ों से जल उमड़ा करेगा, और उसका बीज बहुत से जलभरे खेतों में पडे़गा, और उसका राजा अगाग से भी महान होगा, और उसका राज्य बढ़ता ही जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","उसको मिस्र में से परमेश्वर ही निकाले लिए आ रहा है; वह तो जंगली साँड़ के समान बल रखता है, जाति-जाति के लोग जो उसके द्रोही हैं उनको वह खा जाएगा, और उनकी हड्डियों को टुकड़े-टुकड़े करेगा, और अपने तीरों से उनको बेधेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","वह घात लगाए बैठा है, वह सिंह या सिंहनी के समान लेट गया है; अब उसको कौन छेड़े? जो कोई तुझे आशीर्वाद दे वह आशीष पाए, और जो कोई तुझे श्राप दे वह श्रापित हो।” ");
INSERT INTO hin2017_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","तब बालाक का कोप बिलाम पर भड़क उठा; और उसने हाथ पर हाथ पटककर बिलाम से कहा, “मैंने तुझे अपने शत्रुओं को श्राप देने के लिये बुलवाया, परन्तु तूने तीन बार उन्हें आशीर्वाद ही आशीर्वाद दिया है। ");
INSERT INTO hin2017_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","इसलिए अब तू अपने स्थान पर भाग जा; मैंने तो सोचा था कि तेरी बड़ी प्रतिष्ठा करूँगा, परन्तु अब यहोवा ने तुझे प्रतिष्ठा पाने से रोक रखा है।” ");
INSERT INTO hin2017_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","बिलाम ने बालाक से कहा, “जो दूत तूने मेरे पास भेजे थे, क्या मैंने उनसे भी न कहा था, ");
INSERT INTO hin2017_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","कि चाहे बालाक अपने घर को सोने चाँदी से भरकर मुझे दे, तो भी मैं यहोवा की आज्ञा तोड़कर अपने मन से न तो भला कर सकता हूँ और न बुरा; जो कुछ यहोवा कहेगा वही मैं कहूँगा? ");
INSERT INTO hin2017_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","“अब सुन, मैं अपने लोगों के पास लौटकर जाता हूँ; परन्तु पहले मैं तुझे चेतावनी देता हूँ कि आनेवाले दिनों में वे लोग तेरी प्रजा से क्या-क्या करेंगे।” ");
INSERT INTO hin2017_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","फिर वह अपनी गूढ़ बात आरम्भ करके कहने लगा, “बोर के पुत्र बिलाम की यह वाणी है, जिस पुरुष की आँखें बन्द थीं उसी की यह वाणी है, ");
INSERT INTO hin2017_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","परमेश्वर के वचनों का सुननेवाला, और परमप्रधान के ज्ञान का जाननेवाला, जो दण्डवत् में पड़ा हुआ खुली हुई आँखों से सर्वशक्तिमान का दर्शन पाता है, उसी की यह वाणी है: ");
INSERT INTO hin2017_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","मैं उसको देखूँगा तो सही, परन्तु अभी नहीं; मैं उसको निहारूँगा तो सही, परन्तु समीप होकर नहीं याकूब में से एक तारा उदय होगा, और इस्राएल में से एक राजदण्ड उठेगा; जो मोआब की सीमाओं को चूर कर देगा, और सब शेत के पुत्रों का नाश कर देगा। (मत्ती 2:2) ");
INSERT INTO hin2017_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","तब एदोम और सेईर भी, जो उसके शत्रु हैं, दोनों उसके वश में पड़ेंगे, और इस्राएल वीरता दिखाता जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","और याकूब ही में से एक अधिपति आएगा जो प्रभुता करेगा, और नगर में से बचे हुओं को भी सत्यानाश करेगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","फिर उसने अमालेक पर दृष्टि करके अपनी गूढ़ बात आरम्भ की, और कहने लगा, “अमालेक अन्यजातियों में श्रेष्ठ तो था, परन्तु उसका अन्त विनाश ही है।” ");
INSERT INTO hin2017_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","फिर उसने केनियों पर दृष्टि करके अपनी गूढ़ बात आरम्भ की, और कहने लगा, “तेरा निवास-स्थान अति दृढ़ तो है, और तेरा बसेरा चट्टान पर तो है; ");
INSERT INTO hin2017_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","तो भी केन उजड़ जाएगा। और अन्त में अश्शूर तुझे बन्दी बनाकर ले आएगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","फिर उसने अपनी गूढ़ बात आरम्भ की, और कहने लगा, “हाय, जब परमेश्वर यह करेगा तब कौन जीवित बचेगा? ");
INSERT INTO hin2017_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","तो भी कित्तियों के पास से जहाज वाले आकर अश्शूर को और एबेर को भी दुःख देंगे; और अन्त में उसका भी विनाश हो जाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","तब बिलाम चल दिया, और अपने स्थान पर लौट गया; और बालाक ने भी अपना मार्ग लिया। ");
INSERT INTO hin2017_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","इस्राएली शित्तीम में रहते थे, और वे लोग मोआबी लड़कियों के संग कुकर्म करने लगे। (1 कुरि. 10:8) ");
INSERT INTO hin2017_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","और जब उन स्त्रियों ने उन लोगों को अपने देवताओं के यज्ञों में नेवता दिया, तब वे लोग खाकर उनके देवताओं को दण्डवत् करने लगे। (प्रका. 2:14) ");
INSERT INTO hin2017_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","इस प्रकार इस्राएली बालपोर देवता को पूजने लगे। तब यहोवा का कोप इस्राएल पर भड़क उठा; (प्रका. 2:20) ");
INSERT INTO hin2017_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","और यहोवा ने मूसा से कहा, “प्रजा के सब प्रधानों को पकड़कर यहोवा के लिये धूप में लटका दे, जिससे मेरा भड़का हुआ कोप इस्राएल के ऊपर से दूर हो जाए।” ");
INSERT INTO hin2017_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","तब मूसा ने इस्राएली न्यायियों से कहा, “तुम्हारे जो-जो आदमी बालपोर के संग मिल गए हैं उन्हें घात करो।” ");
INSERT INTO hin2017_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","जब इस्राएलियों की सारी मण्डली मिलापवाले तम्बू के द्वार पर रो रही थी, तो एक इस्राएली पुरुष मूसा और सब लोगों की आँखों के सामने एक मिद्यानी स्त्री को अपने साथ अपने भाइयों के पास ले आया। ");
INSERT INTO hin2017_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","इसे देखकर एलीआजर का पुत्र पीनहास, जो हारून याजक का पोता था, उसने मण्डली में से उठकर हाथ में एक बरछी ली, ");
INSERT INTO hin2017_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","और उस इस्राएली पुरुष के डेरे में जाने के बाद वह भी भीतर गया, और उस पुरुष और उस स्त्री दोनों के पेट में बरछी बेध दी। इस पर इस्राएलियों में जो मरी फैल गई थी वह थम गई। ");
INSERT INTO hin2017_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","और मरी से चौबीस हजार मनुष्य मर गए। (1 कुरि. 10:8) ");
INSERT INTO hin2017_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“हारून याजक का पोता एलीआजर का पुत्र पीनहास, जिसे इस्राएलियों के बीच मेरी जैसी जलन उठी, उसने मेरी जलजलाहट को उन पर से यहाँ तक दूर किया है, कि मैंने जलकर उनका अन्त नहीं कर डाला। ");
INSERT INTO hin2017_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","इसलिए तू कह दे, कि मैं उससे शान्ति की वाचा बाँधता हूँ। ");
INSERT INTO hin2017_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","“और वह उसके लिये, और उसके बाद उसके वंश के लिये, सदा के याजकपद की वाचा होगी, क्योंकि उसे अपने परमेश्वर के लिये जलन उठी, और उसने इस्राएलियों के लिये प्रायश्चित किया।” ");
INSERT INTO hin2017_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","जो इस्राएली पुरुष मिद्यानी स्त्री के संग मारा गया, उसका नाम जिम्री था, वह सालू का पुत्र और शिमोनियों में से अपने पितरों के घराने का प्रधान था। ");
INSERT INTO hin2017_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","और जो मिद्यानी स्त्री मारी गई उसका नाम कोजबी था, वह सूर की बेटी थी, जो मिद्यानी पितरों के एक घराने के लोगों का प्रधान था। ");
INSERT INTO hin2017_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“मिद्यानियों को सता, और उन्हें मार; ");
INSERT INTO hin2017_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","क्योंकि पोर के विषय और कोजबी के विषय वे तुम को छल करके सताते हैं।” कोजबी तो एक मिद्यानी प्रधान की बेटी और मिद्यानियों की जाति बहन थी, और मरी के दिन में पोर के मामले में मारी गई। ");
INSERT INTO hin2017_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","फिर यहोवा ने मूसा और एलीआजर नामक हारून याजक के पुत्र से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“इस्राएलियों की सारी मण्डली में जितने बीस वर्ष के, या उससे अधिक आयु के होने से इस्राएलियों के बीच युद्ध करने के योग्य हैं, उनके पितरों के घरानों के अनुसार उन सभी की गिनती करो।” ");
INSERT INTO hin2017_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","अतः मूसा और एलीआजर याजक ने यरीहो के पास यरदन नदी के तट पर मोआब के अराबा में उनको समझाकर कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“बीस वर्ष के और उससे अधिक आयु के लोगों की गिनती लो, जैसे कि यहोवा ने मूसा और इस्राएलियों को मिस्र देश से निकल आने के समय आज्ञा दी थी।” ");
INSERT INTO hin2017_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","रूबेन जो इस्राएल का जेठा था; उसके ये पुत्र थे; अर्थात् हनोक, जिससे हनोकियों का कुल चला; और पल्लू, जिससे पल्लूइयों का कुल चला; ");
INSERT INTO hin2017_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","हेस्रोन, जिससे हेस्रोनियों का कुल चला; और कर्मी, जिससे कर्मियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","रूबेनवाले कुल ये ही थे; और इनमें से जो गिने गए वे तैंतालीस हजार सात सौ तीस पुरुष थे। ");
INSERT INTO hin2017_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","और पल्लू का पुत्र एलीआब था। ");
INSERT INTO hin2017_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","और एलीआब के पुत्र नमूएल, दातान, और अबीराम थे। ये वही दातान और अबीराम हैं जो सभासद थे; और जिस समय कोरह की मण्डली ने यहोवा से झगड़ा किया था, उस समय उस मण्डली में मिलकर उन्होंने भी मूसा और हारून से झगड़े थे; ");
INSERT INTO hin2017_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","और जब उन ढाई सौ मनुष्यों के आग में भस्म हो जाने से वह मण्डली मिट गई, उसी समय पृथ्वी ने मुँह खोलकर कोरह समेत इनको भी निगल लिया; और वे एक दृष्टान्त ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","परन्तु कोरह के पुत्र तो नहीं मरे थे। ");
INSERT INTO hin2017_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","शिमोन के पुत्र जिनसे उनके कुल निकले वे ये थे; अर्थात् नमूएल, जिससे नमूएलियों का कुल चला; और यामीन, जिससे यामीनियों का कुल चला; और याकीन, जिससे याकीनियों का कुल चला; ");
INSERT INTO hin2017_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","और जेरह, जिससे जेरहियों का कुल चला; और शाऊल, जिससे शाऊलियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","शिमोनवाले कुल ये ही थे; इनमें से बाईस हजार दो सौ पुरुष गिने गए। ");
INSERT INTO hin2017_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","गाद के पुत्र जिससे उनके कुल निकले वे ये थे; अर्थात् सपोन, जिससे सपोनियों का कुल चला; और हाग्गी, जिससे हाग्गियों का कुल चला; और शूनी, जिससे शूनियों का कुल चला; और ओजनी, जिससे ओजनियों का कुल चला; ");
INSERT INTO hin2017_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","और एरी, जिससे एरियों का कुल चला; और अरोद, जिससे अरोदियों का कुल चला; ");
INSERT INTO hin2017_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","और अरेली, जिससे अरेलियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","गाद के वंश के कुल ये ही थे; इनमें से साढ़े चालीस हजार पुरुष गिने गए। ");
INSERT INTO hin2017_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","और यहूदा के एर और ओनान नामक पुत्र तो हुए, परन्तु वे कनान देश में मर गए। ");
INSERT INTO hin2017_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","और यहूदा के जिन पुत्रों से उनके कुल निकले वे ये थे; अर्थात् शेला, जिससे शेलियों का कुल चला; और पेरेस जिससे पेरेसियों का कुल चला; और जेरह, जिससे जेरहियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","और पेरेस के पुत्र ये थे; अर्थात् हेस्रोन, जिससे हेस्रोनियों का कुल चला; और हामूल, जिससे हामूलियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","यहूदियों के कुल ये ही थे; इनमें से साढ़े छिहत्तर हजार पुरुष गिने गए। ");
INSERT INTO hin2017_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","इस्साकार के पुत्र जिनसे उनके कुल निकले वे ये थे; अर्थात् तोला, जिससे तोलियों का कुल चला; और पुव्वा, जिससे पुव्वियों का कुल चला; ");
INSERT INTO hin2017_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","और याशूब, जिससे याशूबियों का कुल चला; और शिम्रोन, जिससे शिम्रोनियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","इस्साकारियों के कुल ये ही थे; इनमें से चौसठ हजार तीन सौ पुरुष गिने गए। ");
INSERT INTO hin2017_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","जबूलून के पुत्र जिनसे उनके कुल निकले वे ये थे; अर्थात् सेरेद जिससे सेरेदियों का कुल चला; और एलोन, जिनसे एलोनियों का कुल चला; और यहलेल, जिससे यहलेलियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","जबूलूनियों के कुल ये ही थे; इनमें से साढ़े साठ हजार पुरुष गिने गए। ");
INSERT INTO hin2017_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","यूसुफ के पुत्र जिससे उनके कुल निकले वे मनश्शे और एप्रैम थे। ");
INSERT INTO hin2017_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","मनश्शे के पुत्र ये थे; अर्थात् माकीर, जिससे माकीरियों का कुल चला; और माकीर से गिलाद उत्पन्न हुआ; और गिलाद से गिलादियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","गिलाद के तो पुत्र ये थे; अर्थात् ईएजेर, जिससे ईएजेरियों का कुल चला; ");
INSERT INTO hin2017_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","और हेलेक, जिससे हेलेकियों का कुल चला और अस्रीएल, जिससे अस्रीएलियों का कुल चला; और शेकेम, जिससे शेकेमियों का कुल चला; और शमीदा, जिससे शमीदियों का कुल चला; ");
INSERT INTO hin2017_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","और हेपेर, जिससे हेपेरियों का कुल चला; ");
INSERT INTO hin2017_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","और हेपेर के पुत्र सलोफाद के बेटे नहीं, केवल बेटियाँ हुईं; इन बेटियों के नाम महला, नोवा, होग्ला, मिल्का, और तिर्सा हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","मनश्शेवाले कुल तो ये ही थे; और इनमें से जो गिने गए वे बावन हजार सात सौ पुरुष थे। ");
INSERT INTO hin2017_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","एप्रैम के पुत्र जिनसे उनके कुल निकले वे ये थे; अर्थात् शूतेलह, जिससे शूतेलहियों का कुल चला; और बेकेर, जिससे बेकेरियों का कुल चला; और तहन जिससे तहनियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","और शूतेलह के यह पुत्र हुआ; अर्थात् एरान, जिससे एरानियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","एप्रैमियों के कुल ये ही थे; इनमें से साढ़े बत्तीस हजार पुरुष गिने गए। अपने कुलों के अनुसार यूसुफ के वंश के लोग ये ही थे। ");
INSERT INTO hin2017_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","और बिन्यामीन के पुत्र जिनसे उनके कुल निकले वे ये थे; अर्थात् बेला जिससे बेलियों का कुल चला; और अशबेल, जिससे अशबेलियों का कुल चला; और अहीराम, जिससे अहीरामियों का कुल चला; ");
INSERT INTO hin2017_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","और शपूपाम, जिससे शपूपामियों का कुल चला; और हूपाम, जिससे हूपामियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","और बेला के पुत्र अर्द और नामान थे; और अर्द से अर्दियों का कुल, और नामान से नामानियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","अपने कुलों के अनुसार बिन्यामीनी ये ही थे; और इनमें से जो गिने गए वे पैंतालीस हजार छः सौ पुरुष थे। ");
INSERT INTO hin2017_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","दान का पुत्र जिससे उनका कुल निकला यह था; अर्थात् शूहाम, जिससे शूहामियों का कुल चला। और दान का कुल यही था। ");
INSERT INTO hin2017_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","और शूहामियों में से जो गिने गए उनके कुल में चौसठ हजार चार सौ पुरुष थे। ");
INSERT INTO hin2017_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","आशेर के पुत्र जिनसे उनके कुल निकले वे ये थे; अर्थात् यिम्ना, जिससे यिम्नियों का कुल चला; यिश्वी, जिससे यिश्वीयों का कुल चला; और बरीआ, जिससे बरीइयों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","फिर बरीआ के ये पुत्र हुए; अर्थात् हेबेर, जिससे हेबेरियों का कुल चला; और मल्कीएल, जिससे मल्कीएलियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","और आशेर की बेटी का नाम सेरह है। ");
INSERT INTO hin2017_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","आशेरियों के कुल ये ही थे; इनमें से तिरपन हजार चार सौ पुरुष गिने गए। ");
INSERT INTO hin2017_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","नप्ताली के पुत्र जिससे उनके कुल निकले वे ये थे; अर्थात् यहसेल, जिससे यहसेलियों का कुल चला; और गूनी, जिससे गूनियों का कुल चला; ");
INSERT INTO hin2017_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","येसेर, जिससे येसेरियों का कुल चला; और शिल्लेम, जिससे शिल्लेमियों का कुल चला। ");
INSERT INTO hin2017_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","अपने कुलों के अनुसार नप्ताली के कुल ये ही थे; और इनमें से जो गिने गए वे पैंतालीस हजार चार सौ पुरुष थे। ");
INSERT INTO hin2017_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","सब इस्राएलियों में से जो गिने गए थे वे ये ही थे; अर्थात् छः लाख एक हजार सात सौ तीस पुरुष थे। ");
INSERT INTO hin2017_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“इनको, इनकी गिनती के अनुसार, वह भूमि इनका भाग होने के लिये बाँट दी जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","अर्थात् जिस कुल में अधिक हों उनको अधिक भाग, और जिसमें कम हों उनको कम भाग देना; प्रत्येक गोत्र को उसका भाग उसके गिने हुए लोगों के अनुसार दिया जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","तो भी देश चिट्ठी डालकर बाँटा जाए; इस्राएलियों के पितरों के एक-एक गोत्र का नाम, जैसे-जैसे निकले वैसे-वैसे वे अपना-अपना भाग पाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","चाहे बहुतों का भाग हो चाहे थोड़ों का हो, जो-जो भाग बाँटे जाएँ वह चिट्ठी डालकर बाँटे जाएँ।” ");
INSERT INTO hin2017_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","फिर लेवियों में से जो अपने कुलों के अनुसार गिने गए वे ये हैं; अर्थात् गेर्शोनियों से निकला हुआ गेर्शोनियों का कुल; कहात से निकला हुआ कहातियों का कुल; और मरारी से निकला हुआ मरारियों का कुल। ");
INSERT INTO hin2017_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","लेवियों के कुल ये हैं; अर्थात् लिब्नियों का, हेब्रोनियों का, महलियों का, मूशियों का, और कोरहियों का कुल। और कहात से अम्राम उत्पन्न हुआ। ");
INSERT INTO hin2017_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","और अम्राम की पत्नी का नाम योकेबेद है, वह लेवी के वंश की थी जो लेवी के वंश में मिस्र देश में उत्पन्न हुई थी; और वह अम्राम से हारून और मूसा और उनकी बहन मिर्याम को भी जनी। ");
INSERT INTO hin2017_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","और हारून से नादाब, अबीहू, एलीआजर, और ईतामार उत्पन्न हुए। ");
INSERT INTO hin2017_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","नादाब और अबीहू तो उस समय मर गए थे, जब वे यहोवा के सामने ऊपरी आग ले गए थे। ");
INSERT INTO hin2017_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","सब लेवियों में से जो गिने गये, अर्थात् जितने पुरुष एक महीने के या उससे अधिक आयु के थे, वे तेईस हजार थे; वे इस्राएलियों के बीच इसलिए नहीं गिने गए, क्योंकि उनको देश का कोई भाग नहीं दिया गया था। ");
INSERT INTO hin2017_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","मूसा और एलीआजर याजक जिन्होंने मोआब के अराबा में यरीहो के पास की यरदन नदी के तट पर इस्राएलियों को गिन लिया, उनके गिने हुए लोग इतने ही थे। ");
INSERT INTO hin2017_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","परन्तु जिन इस्राएलियों को मूसा और हारून याजक ने सीनै के जंगल में गिना था, उनमें से एक भी पुरुष इस समय के गिने हुओं में न था। ");
INSERT INTO hin2017_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","क्योंकि यहोवा ने उनके विषय कहा था, “वे निश्चय जंगल में मर जाएँगे।” इसलिए यपुन्ने के पुत्र कालेब और नून के पुत्र यहोशू को छोड़, उनमें से एक भी पुरुष नहीं बचा। ");
INSERT INTO hin2017_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","तब यूसुफ के पुत्र मनश्शे के वंश के कुलों में से सलोफाद, जो हेपेर का पुत्र, और गिलाद का पोता, और मनश्शे के पुत्र माकीर का परपोता था, उसकी बेटियाँ जिनके नाम महला, नोवा, होग्ला, मिल्का, और तिर्सा हैं वे पास आईं। ");
INSERT INTO hin2017_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","और वे मूसा और एलीआजर याजक और प्रधानों और सारी मण्डली के सामने मिलापवाले तम्बू के द्वार पर खड़ी होकर कहने लगीं, ");
INSERT INTO hin2017_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“हमारा पिता जंगल में मर गया; परन्तु वह उस मण्डली में का न था जो कोरह की मण्डली के संग होकर यहोवा के विरुद्ध इकट्ठी हुई थी, वह अपने ही पाप के कारण मरा; और उसके कोई पुत्र न था। ");
INSERT INTO hin2017_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","तो हमारे पिता का नाम उसके कुल में से पुत्र न होने के कारण क्यों मिट जाए? हमारे चाचाओं के बीच हमें भी कुछ भूमि निज भाग करके दे।” ");
INSERT INTO hin2017_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","उनकी यह विनती मूसा ने यहोवा को सुनाई। ");
INSERT INTO hin2017_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“सलोफाद की बेटियाँ ठीक कहती हैं; इसलिए तू उनके चाचाओं के बीच उनको भी अवश्य ही कुछ भूमि निज भाग करके दे, अर्थात् उनके पिता का भाग उनके हाथ सौंप दे। ");
INSERT INTO hin2017_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","और इस्राएलियों से यह कह, ‘यदि कोई मनुष्य बिना पुत्र मर जाए, तो उसका भाग उसकी बेटी के हाथ सौंपना। ");
INSERT INTO hin2017_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","और यदि उसके कोई बेटी भी न हो, तो उसका भाग उसके भाइयों को देना। ");
INSERT INTO hin2017_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","और यदि उसके भाई भी न हों, तो उसका भाग चाचाओं को देना। ");
INSERT INTO hin2017_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","और यदि उसके चाचा भी न हों, तो उसके कुल में से उसका जो कुटुम्बी सबसे समीप हो उनको उसका भाग देना कि वह उसका अधिकारी हो। इस्राएलियों के लिये यह न्याय की विधि ठहरेगी, जैसे कि यहोवा ने मूसा को आज्ञा दी।’” ");
INSERT INTO hin2017_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","फिर यहोवा ने मूसा से कहा, “इस अबारीम नामक पर्वत के ऊपर चढ़कर उस देश को देख ले जिसे मैंने इस्राएलियों को दिया है। ");
INSERT INTO hin2017_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","और जब तू उसको देख लेगा, तब अपने भाई हारून के समान तू भी अपने लोगों में जा मिलेगा, ");
INSERT INTO hin2017_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","क्योंकि सीन नामक जंगल में तुम दोनों ने मण्डली के झगड़ने के समय मेरी आज्ञा को तोड़कर मुझसे बलवा किया, और मुझे सोते के पास उनकी दृष्टि में पवित्र नहीं ठहराया।” (यह मरीबा नामक सोता है जो सीन नामक जंगल के कादेश में है) ");
INSERT INTO hin2017_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","मूसा ने यहोवा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“यहोवा, जो सारे प्राणियों की आत्माओं का परमेश्वर है, वह इस मण्डली के लोगों के ऊपर किसी पुरुष को नियुक्त कर दे, (इब्रा. 12:9) ");
INSERT INTO hin2017_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","जो उसके सामने आया-जाया करे, और उनका निकालने और बैठानेवाला हो; जिससे यहोवा की मण्डली बिना चरवाहे की भेड़-बकरियों के समान न रहे।” (मत्ती 9:36, मर. 6:34) ");
INSERT INTO hin2017_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","यहोवा ने मूसा से कहा, “तू नून के पुत्र यहोशू को लेकर उस पर हाथ रख; वह तो ऐसा पुरुष है जिसमें मेरा आत्मा बसा है; ");
INSERT INTO hin2017_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","और उसको एलीआजर याजक के और सारी मण्डली के सामने खड़ा करके उनके सामने उसे आज्ञा दे। ");
INSERT INTO hin2017_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","और अपनी महिमा में से कुछ उसे दे, जिससे इस्राएलियों की सारी मण्डली उसकी माना करे। ");
INSERT INTO hin2017_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","और वह एलीआजर याजक के सामने खड़ा हुआ करे, और एलीआजर उसके लिये यहोवा से ऊरीम की आज्ञा पूछा करे; और वह इस्राएलियों की सारी मण्डली समेत उसके कहने से जाया करे, और उसी के कहने से लौट भी आया करे।” ");
INSERT INTO hin2017_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","यहोवा की इस आज्ञा के अनुसार मूसा ने यहोशू को लेकर, एलीआजर याजक और सारी मण्डली के सामने खड़ा करके, ");
INSERT INTO hin2017_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","उस पर हाथ रखे, और उसको आज्ञा दी जैसे कि यहोवा ने मूसा के द्वारा कहा था। ");
INSERT INTO hin2017_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“इस्राएलियों को यह आज्ञा सुना, ‘मेरा चढ़ावा, अर्थात् मुझे सुखदायक सुगन्ध देनेवाला मेरा हव्यरूपी भोजन, तुम लोग मेरे लिये उनके नियत समयों पर चढ़ाने के लिये स्मरण रखना।’ ");
INSERT INTO hin2017_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","और तू उनसे कह: जो-जो तुम्हें यहोवा के लिये चढ़ाना होगा वे ये हैं; अर्थात् नित्य होमबलि के लिये एक-एक वर्ष के दो निर्दोष भेड़ी के नर बच्चे प्रतिदिन चढ़ाया करना। ");
INSERT INTO hin2017_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","एक बच्चे को भोर को और दूसरे को साँझ के समय चढ़ाना; ");
INSERT INTO hin2017_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","और भेड़ के बच्चे के साथ एक चौथाई हीन कूटकर निकाले हुए तेल से सने हुए एपा के दसवें अंश मैदे का अन्नबलि चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","यह नित्य होमबलि है, जो सीनै पर्वत पर यहोवा का सुखदायक सुगन्धवाला हव्य होने के लिये ठहराया गया। ");
INSERT INTO hin2017_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","और उसका अर्घ प्रति एक भेड़ के बच्चे के संग एक चौथाई हीन हो; मदिरा का यह अर्घ यहोवा के लिये पवित्रस्थान में देना। ");
INSERT INTO hin2017_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","और दूसरे बच्चे को साँझ के समय चढ़ाना; अन्नबलि और अर्घ समेत भोर के होमबलि के समान उसे यहोवा को सुखदायक सुगन्ध देनेवाला हव्य करके चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“फिर विश्रामदिन को दो निर्दोष भेड़ के एक वर्ष के नर बच्चे, और अन्नबलि के लिये तेल से सना हुआ एपा का दो दसवाँ अंश मैदा अर्घ समेत चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","नित्य होमबलि और उसके अर्घ के अलावा प्रत्येक विश्रामदिन का यही होमबलि ठहरा है। (मत्ती 12:5) ");
INSERT INTO hin2017_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“फिर अपने महीनों के आरम्भ में प्रतिमाह यहोवा के लिये होमबलि चढ़ाना; अर्थात् दो बछड़े, एक मेढ़ा, और एक-एक वर्ष के निर्दोष भेड़ के सात नर बच्चे; ");
INSERT INTO hin2017_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","और बछड़े के साथ तेल से सना हुआ एपा का तीन दसवाँ अंश मैदा, और उस एक मेढ़े के साथ तेल से सना हुआ एपा का दो दसवाँ अंश मैदा; ");
INSERT INTO hin2017_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","और प्रत्येक भेड़ के बच्चे के पीछे तेल से सना हुआ एपा का दसवाँ अंश मैदा, उन सभी को अन्नबलि करके चढ़ाना; वह सुखदायक सुगन्ध देने के लिये होमबलि और यहोवा के लिये हव्य ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","और उनके साथ ये अर्घ हों; अर्थात् बछड़े के साथ आधा हीन, मेढ़े के साथ तिहाई हीन, और भेड़ के बच्चे के साथ चौथाई हीन दाखमधु दिया जाए; वर्ष के सब महीनों में से प्रत्येक महीने का यही होमबलि ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","और एक बकरा पापबलि करके यहोवा के लिये चढ़ाया जाए; यह नित्य होमबलि और उसके अर्घ के अलावा चढ़ाया जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“फिर पहले महीने के चौदहवें दिन को यहोवा का फसह हुआ करे। ");
INSERT INTO hin2017_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","और उसी महीने के पन्द्रहवें दिन को पर्व लगा करे; सात दिन तक अख़मीरी रोटी खाई जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","पहले दिन पवित्र सभा हो; और उस दिन परिश्रम का कोई काम न किया जाए; ");
INSERT INTO hin2017_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","उसमें तुम यहोवा के लिये हव्य, अर्थात् होमबलि चढ़ाना; अतः दो बछड़े, एक मेढ़ा, और एक-एक वर्ष के सात भेड़ के नर बच्चे हों; ये सब निर्दोष हों; ");
INSERT INTO hin2017_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","और उनका अन्नबलि तेल से सने हुए मैदे का हो; बछड़े के साथ एपा का तीन दसवाँ अंश और मेढ़े के साथ एपा का दो दसवाँ अंश मैदा हो। ");
INSERT INTO hin2017_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","और सातों भेड़ के बच्चों में से प्रति बच्चे के साथ एपा का दसवाँ अंश चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","और एक बकरा भी पापबलि करके चढ़ाना, जिससे तुम्हारे लिये प्रायश्चित हो। ");
INSERT INTO hin2017_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","भोर का होमबलि जो नित्य होमबलि ठहरा है, उसके अलावा इनको चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","इस रीति से तुम उन सातों दिनों में भी हव्य का भोजन चढ़ाना, जो यहोवा को सुखदायक सुगन्ध देने के लिये हो; यह नित्य होमबलि और उसके अर्घ के अलावा चढ़ाया जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","और सातवें दिन भी तुम्हारी पवित्र सभा हो; और उस दिन परिश्रम का कोई काम न करना। ");
INSERT INTO hin2017_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“फिर पहली उपज के दिन में, जब तुम अपने कटनी के पर्व में यहोवा के लिये नया अन्नबलि चढ़ाओगे, तब भी तुम्हारी पवित्र सभा हो; और परिश्रम का कोई काम न करना। ");
INSERT INTO hin2017_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","और एक होमबलि चढ़ाना, जिससे यहोवा के लिये सुखदायक सुगन्ध हो; अर्थात् दो बछड़े, एक मेढ़ा, और एक-एक वर्ष के सात भेड़ के नर बच्चे; ");
INSERT INTO hin2017_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","और उनका अन्नबलि तेल से सने हुए मैदे का हो; अर्थात् बछड़े के साथ एपा का तीन दसवाँ अंश, और मेढ़े के संग एपा का दो दसवाँ अंश, ");
INSERT INTO hin2017_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","और सातों भेड़ के बच्चों में से एक-एक बच्चे के पीछे एपा का दसवाँ अंश मैदा चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","और एक बकरा भी चढ़ाना, जिससे तुम्हारे लिये प्रायश्चित हो। ");
INSERT INTO hin2017_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ये सब निर्दोष हों; और नित्य होमबलि और उसके अन्नबलि और अर्घ के अलावा इसको भी चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“फिर सातवें महीने के पहले दिन को तुम्हारी पवित्र सभा हो; उसमें परिश्रम का कोई काम न करना। वह तुम्हारे लिये जयजयकार का नरसिंगा फूँकने का दिन ठहरा है; ");
INSERT INTO hin2017_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","तुम होमबलि चढ़ाना, जिससे यहोवा के लिये सुखदायक सुगन्ध हो; अर्थात् एक बछड़ा, एक मेढ़ा, और एक-एक वर्ष के सात निर्दोष भेड़ के नर बच्चे; ");
INSERT INTO hin2017_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","और उनका अन्नबलि तेल से सने हुए मैदे का हो; अर्थात् बछड़े के साथ एपा का तीन दसवाँ अंश, और मेढ़े के साथ एपा का दसवाँ अंश, ");
INSERT INTO hin2017_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","और सातों भेड़ के बच्चों में से एक-एक बच्चे के साथ एपा का दसवाँ अंश मैदा चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","और एक बकरा भी पापबलि करके चढ़ाना, जिससे तुम्हारे लिये प्रायश्चित हो। ");
INSERT INTO hin2017_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","इन सभी से अधिक नये चाँद का होमबलि और उसका अन्नबलि, और नित्य होमबलि और उसका अन्नबलि, और उन सभी के अर्घ भी उनके नियम के अनुसार सुखदायक सुगन्ध देने के लिये यहोवा के हव्य करके चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“फिर उसी सातवें महीने के दसवें दिन को तुम्हारी पवित्र सभा हो; तुम उपवास करके अपने-अपने प्राण को दुःख देना, और किसी प्रकार का काम-काज न करना; ");
INSERT INTO hin2017_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","और यहोवा के लिये सुखदायक सुगन्ध देने को होमबलि; अर्थात् एक बछड़ा, एक मेढ़ा, और एक-एक वर्ष के सात भेड़ के नर बच्चे चढ़ाना; फिर ये सब निर्दोष हों; ");
INSERT INTO hin2017_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","और उनका अन्नबलि तेल से सने हुए मैदे का हो; अर्थात् बछड़े के साथ एपा का तीन दसवाँ अंश, और मेढ़े के साथ एपा का दो दसवाँ अंश, ");
INSERT INTO hin2017_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","और सातों भेड़ के बच्चों में से एक-एक बच्चे के पीछे एपा का दसवाँ अंश मैदा चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","और पापबलि के लिये एक बकरा भी चढ़ाना; ये सब प्रायश्चित के पापबलि और नित्य होमबलि और उसके अन्नबलि के, और उन सभी के अर्घों के अलावा चढ़ाए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“फिर सातवें महीने के पन्द्रहवें दिन को तुम्हारी पवित्र सभा हो; और उसमें परिश्रम का कोई काम न करना, और सात दिन तक यहोवा के लिये पर्व मानना; ");
INSERT INTO hin2017_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","तुम होमबलि यहोवा को सुखदायक सुगन्ध देने के लिये हव्य करके चढ़ाना; अर्थात् तेरह बछड़े, और दो मेढ़े, और एक-एक वर्ष के चौदह भेड़ के नर बच्चे; ये सब निर्दोष हों; ");
INSERT INTO hin2017_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","और उनका अन्नबलि तेल से सने हुए मैदे का हो; अर्थात् तेरहों बछड़ों में से एक-एक बछड़े के साथ एपा का तीन दसवाँ अंश, और दोनों मेढ़ों में से एक-एक मेढ़े के साथ एपा का दो दसवाँ अंश, ");
INSERT INTO hin2017_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","और चौदहों भेड़ के बच्चों में से एक-एक बच्चे के साथ एपा का दसवाँ अंश मैदा चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","और पापबलि के लिये एक बकरा भी चढ़ाना; ये नित्य होमबलि और उसके अन्नबलि और अर्घ के अलावा चढ़ाए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“फिर दूसरे दिन बारह बछड़े, और दो मेढ़े, और एक-एक वर्ष के चौदह निर्दोष भेड़ के नर बच्चे चढ़ाना; ");
INSERT INTO hin2017_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","और बछड़ों, और मेढ़ों, और भेड़ के बच्चों के साथ उनके अन्नबलि और अर्घ, उनकी गिनती के अनुसार, और नियम के अनुसार चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","और पापबलि के लिये एक बकरा भी चढ़ाना; ये नित्य होमबलि और उसके अन्नबलि और अर्घ के अलावा चढ़ाए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“फिर तीसरे दिन ग्यारह बछड़े, और दो मेढ़े, और एक-एक वर्ष के चौदह निर्दोष भेड़ के नर बच्चे चढ़ाना; ");
INSERT INTO hin2017_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","और बछड़ों, और मेढ़ों, और भेड़ के बच्चों के साथ उनके अन्नबलि और अर्घ, उनकी गिनती के अनुसार, और नियम के अनुसार चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","और पापबलि के लिये एक बकरा भी चढ़ाना; ये नित्य होमबलि और उसके अन्नबलि और अर्घ के अलावा चढ़ाए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“फिर चौथे दिन दस बछड़े, और दो मेढ़े, और एक-एक वर्ष के चौदह निर्दोष भेड़ के नर बच्चे चढ़ाना; ");
INSERT INTO hin2017_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","बछड़ों, और मेढ़ों, और भेड़ के बच्चों के साथ उनके अन्नबलि और अर्घ, उनकी गिनती के अनुसार, और नियम के अनुसार चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","और पापबलि के लिये एक बकरा भी चढ़ाना; ये नित्य होमबलि और उसके अन्नबलि और अर्घ के अलावा चढ़ाए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“फिर पाँचवें दिन नौ बछड़े, दो मेढ़े, और एक-एक वर्ष के चौदह निर्दोष भेड़ के नर बच्चे चढ़ाना; ");
INSERT INTO hin2017_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","और बछड़ों, मेढ़ों, और भेड़ के बच्चों के साथ उनके अन्नबलि और अर्घ, उनकी गिनती के अनुसार, और नियम के अनुसार चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","और पापबलि के लिये एक बकरा भी चढ़ाना; ये नित्य होमबलि और उसके अन्नबलि और अर्घ के अलावा चढ़ाए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“फिर छठवें दिन आठ बछड़े, और दो मेढ़े, और एक-एक वर्ष के चौदह निर्दोष भेड़ के नर बच्चे चढ़ाना; ");
INSERT INTO hin2017_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","और बछड़ों, और मेढ़ों, और भेड़ के बच्चों के साथ उनके अन्नबलि और अर्घ, उनकी गिनती के अनुसार और नियम के अनुसार चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","और पापबलि के लिये एक बकरा भी चढ़ाना; ये नित्य होमबलि और उसके अन्नबलि और अर्घ के अलावा चढ़ाए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“फिर सातवें दिन सात बछड़े, और दो मेढ़े, और एक-एक वर्ष के चौदह निर्दोष भेड़ के नर बच्चे चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","और बछड़ों, और मेढ़ों, और भेड़ के बच्चों के साथ उनके अन्नबलि और अर्घ, उनकी गिनती के अनुसार, और नियम के अनुसार चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","और पापबलि के लिये एक बकरा भी चढ़ाना; ये नित्य होमबलि और उसके अन्नबलि और अर्घ के अलावा चढ़ाए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“फिर आठवें दिन तुम्हारी एक महासभा हो; उसमें परिश्रम का कोई काम न करना, ");
INSERT INTO hin2017_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","और उसमें होमबलि यहोवा को सुखदायक सुगन्ध देने के लिये हव्य करके चढ़ाना; वह एक बछड़े, और एक मेढ़े, और एक-एक वर्ष के सात निर्दोष भेड़ के नर बच्चों का हो; ");
INSERT INTO hin2017_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","बछड़े, और मेढ़े, और भेड़ के बच्चों के साथ उनके अन्नबलि और अर्घ, उनकी गिनती के अनुसार, और नियम के अनुसार चढ़ाना। ");
INSERT INTO hin2017_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","और पापबलि के लिये एक बकरा भी चढ़ाना; ये नित्य होमबलि और उसके अन्नबलि और अर्घ के अलावा चढ़ाए जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“अपनी मन्नतों और स्वेच्छाबलियों के अलावा, अपने-अपने नियत समयों में, ये ही होमबलि, अन्नबलि, अर्घ, और मेलबलि, यहोवा के लिये चढ़ाना।” ");
INSERT INTO hin2017_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","यह सारी आज्ञा यहोवा ने मूसा को दी जो उसने इस्राएलियों को सुनाई। ");
INSERT INTO hin2017_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","फिर मूसा ने इस्राएली गोत्रों के मुख्य-मुख्य पुरुषों से कहा, “यहोवा ने यह आज्ञा दी है: ");
INSERT INTO hin2017_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","जब कोई पुरुष यहोवा की मन्नत माने, या अपने आपको वाचा से बाँधने के लिये शपथ खाए, तो वह अपना वचन न टाले; जो कुछ उसके मुँह से निकला हो उसके अनुसार वह करे। (मत्ती 5:33) ");
INSERT INTO hin2017_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","और जब कोई स्त्री अपनी कुँवारी अवस्था में, अपने पिता के घर में रहते हुए, यहोवा की मन्नत माने, व अपने को वाचा से बाँधे, ");
INSERT INTO hin2017_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","तो यदि उसका पिता उसकी मन्नत या उसका वह वचन सुनकर, जिससे उसने अपने आपको बाँधा हो, उससे कुछ न कहे; तब तो उसकी सब मन्नतें स्थिर बनी रहें, और कोई बन्धन क्यों न हो, जिससे उसने अपने आपको बाँधा हो, वह भी स्थिर रहे। ");
INSERT INTO hin2017_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","परन्तु यदि उसका पिता उसकी सुनकर उसी दिन उसको मना करे, तो उसकी मन्नतें या और प्रकार के बन्धन, जिनसे उसने अपने आपको बाँधा हो, उनमें से एक भी स्थिर न रहे, और यहोवा यह जानकर, कि उस स्त्री के पिता ने उसे मना कर दिया है, उसका यह पाप क्षमा करेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","फिर यदि वह पति के अधीन हो और मन्नत माने, या बिना सोच विचार किए ऐसा कुछ कहे जिससे वह बन्धन में पड़े, ");
INSERT INTO hin2017_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","और यदि उसका पति सुनकर उस दिन उससे कुछ न कहे; तब तो उसकी मन्नतें स्थिर रहें, और जिन बन्धनों से उसने अपने आपको बाँधा हो वह भी स्थिर रहें। ");
INSERT INTO hin2017_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","परन्तु यदि उसका पति सुनकर उसी दिन उसे मना कर दे, तो जो मन्नत उसने मानी है, और जो बात बिना सोच-विचार किए कहने से उसने अपने आपको वाचा से बाँधा हो, वह टूट जाएगी; और यहोवा उस स्त्री का पाप क्षमा करेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","फिर विधवा या त्यागी हुई स्त्री की मन्नत, या किसी प्रकार की वाचा का बन्धन क्यों न हो, जिससे उसने अपने आपको बाँधा हो, तो वह स्थिर ही रहे। ");
INSERT INTO hin2017_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","फिर यदि कोई स्त्री अपने पति के घर में रहते मन्नत माने, या शपथ खाकर अपने आपको बाँधे, ");
INSERT INTO hin2017_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","और उसका पति सुनकर कुछ न कहे, और न उसे मना करे; तब तो उसकी सब मन्नतें स्थिर बनी रहें, और हर एक बन्धन क्यों न हो, जिससे उसने अपने आपको बाँधा हो, वह स्थिर रहे। ");
INSERT INTO hin2017_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","परन्तु यदि उसका पति उसकी मन्नत आदि सुनकर उसी दिन पूरी रीति से तोड़ दे, तो उसकी मन्नतें आदि, जो कुछ उसके मुँह से अपने बन्धन के विषय निकला हो, उसमें से एक बात भी स्थिर न रहे; उसके पति ने सब तोड़ दिया है; इसलिए यहोवा उस स्त्री का वह पाप क्षमा करेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","कोई भी मन्नत या शपथ क्यों न हो, जिससे उस स्त्री ने अपने जीव को दुःख देने की वाचा बाँधी हो, उसको उसका पति चाहे तो दृढ़ करे, और चाहे तो तोड़े; ");
INSERT INTO hin2017_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","अर्थात् यदि उसका पति दिन प्रतिदिन उससे कुछ भी न कहे, तो वह उसको सब मन्नतें आदि बन्धनों को जिनसे वह बंधी हो दृढ़ कर देता है; उसने उनको दृढ़ किया है, क्योंकि सुनने के दिन उसने कुछ नहीं कहा। ");
INSERT INTO hin2017_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","और यदि वह उन्हें सुनकर बहुत दिन पश्चात् तोड़ दे, तो अपनी स्त्री के अधर्म का भार वही उठाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","पति-पत्नी के बीच, और पिता और उसके घर में रहती हुई कुँवारी बेटी के बीच, जिन विधियों की आज्ञा यहोवा ने मूसा को दी वे ये ही हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“मिद्यानियों से इस्राएलियों का पलटा ले; उसके बाद तू अपने लोगों में जा मिलेगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","तब मूसा ने लोगों से कहा, “अपने में से पुरुषों को युद्ध के लिये हथियार धारण कराओ कि वे मिद्यानियों पर चढ़कर उनसे यहोवा का पलटा लें। ");
INSERT INTO hin2017_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","इस्राएल के सब गोत्रों में से प्रत्येक गोत्र के एक-एक हजार पुरुषों को युद्ध करने के लिये भेजो।” ");
INSERT INTO hin2017_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","तब इस्राएल के सब गोत्रों में से प्रत्येक गोत्र के एक-एक हजार पुरुष चुने गये, अर्थात् युद्ध के लिये हथियार-बन्द बारह हजार पुरुष। ");
INSERT INTO hin2017_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","प्रत्येक गोत्र में से उन हजार-हजार पुरुषों को, और एलीआजर याजक के पुत्र पीनहास को, मूसा ने युद्ध करने के लिये भेजा, और पीनहास के हाथ में पवित्रस्थान के पात्र और वे तुरहियां थीं जो साँस बाँध बाँधकर फूँकी जाती थीं। ");
INSERT INTO hin2017_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","और जो आज्ञा यहोवा ने मूसा को दी थी, उसके अनुसार उन्होंने मिद्यानियों से युद्ध करके सब पुरुषों को घात किया। ");
INSERT INTO hin2017_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","और शेष मारे हुओं को छोड़ उन्होंने एवी, रेकेम, सूर, हूर, और रेबा नामक मिद्यान के पाँचों राजाओं को घात किया; और बोर के पुत्र बिलाम को भी उन्होंने तलवार से घात किया। ");
INSERT INTO hin2017_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","और इस्राएलियों ने मिद्यानी स्त्रियों को बाल-बच्चों समेत बन्दी बना लिया; और उनके गाय-बैल, भेड़-बकरी, और उनकी सारी सम्पत्ति को लूट लिया। ");
INSERT INTO hin2017_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","और उनके निवास के सब नगरों, और सब छावनियों को फूँक दिया; ");
INSERT INTO hin2017_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","तब वे, क्या मनुष्य क्या पशु, सब बन्दियों और सारी लूट-पाट को लेकर ");
INSERT INTO hin2017_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","यरीहो के पास की यरदन नदी के तट पर, मोआब के अराबा में, छावनी के निकट, मूसा और एलीआजर याजक और इस्राएलियों की मण्डली के पास आए। ");
INSERT INTO hin2017_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","तब मूसा और एलीआजर याजक और मण्डली के सब प्रधान छावनी के बाहर उनका स्वागत करने को निकले। ");
INSERT INTO hin2017_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","और मूसा सहस्रपति-शतपति आदि, सेनापतियों से, जो युद्ध करके लौटे आते थे क्रोधित होकर कहने लगा, ");
INSERT INTO hin2017_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","“क्या तुम ने सब स्त्रियों को जीवित छोड़ दिया? ");
INSERT INTO hin2017_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","देखो, बिलाम की सम्मति से, पोर के विषय में इस्राएलियों से यहोवा का विश्वासघात इन्हीं स्त्रियों ने कराया, और यहोवा की मण्डली में मरी फैली। ");
INSERT INTO hin2017_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","इसलिए अब बाल-बच्चों में से हर एक लड़के को, और जितनी स्त्रियों ने पुरुष का मुँह देखा हो उन सभी को घात करो। ");
INSERT INTO hin2017_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","परन्तु जितनी लड़कियों ने पुरुष का मुँह न देखा हो उन सभी को तुम अपने लिये जीवित रखो। ");
INSERT INTO hin2017_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","और तुम लोग सात दिन तक छावनी के बाहर रहो, और तुम में से जितनों ने किसी प्राणी को घात किया, और जितनों ने किसी मरे हुए को छुआ हो, वे सब अपने-अपने बन्दियों समेत तीसरे और सातवें दिनों में अपने-अपने को पाप छुड़ाकर पावन करें। ");
INSERT INTO hin2017_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","और सब वस्त्रों, और चमड़े की बनी हुई सब वस्तुओं, और बकरी के बालों की और लकड़ी की बनी हुई सब वस्तुओं को पावन कर लो।” ");
INSERT INTO hin2017_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","तब एलीआजर याजक ने सेना के उन पुरुषों से जो युद्ध करने गए थे कहा, “व्यवस्था की जिस विधि की आज्ञा यहोवा ने मूसा को दी है वह यह है: ");
INSERT INTO hin2017_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","सोना, चाँदी, पीतल, लोहा, टीन, और सीसा, ");
INSERT INTO hin2017_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","जो कुछ आग में ठहर सके उसको आग में डालो, तब वह शुद्ध ठहरेगा; तो भी वह अशुद्धता से छुड़ानेवाले जल के द्वारा पावन किया जाए; परन्तु जो कुछ आग में न ठहर सके उसे जल में डुबाओ। ");
INSERT INTO hin2017_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","और सातवें दिन अपने वस्त्रों को धोना, तब तुम शुद्ध ठहरोगे; और तब छावनी में आना।” ");
INSERT INTO hin2017_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“एलीआजर याजक और मण्डली के पितरों के घरानों के मुख्य-मुख्य पुरुषों को साथ लेकर तू लूट के मनुष्यों और पशुओं की गिनती कर; ");
INSERT INTO hin2017_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","तब उनको आधा-आधा करके एक भाग उन सिपाहियों को जो युद्ध करने को गए थे, और दूसरा भाग मण्डली को दे। ");
INSERT INTO hin2017_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","फिर जो सिपाही युद्ध करने को गए थे, उनके आधे में से यहोवा के लिये, क्या मनुष्य, क्या गाय-बैल, क्या गदहे, क्या भेड़-बकरियाँ ");
INSERT INTO hin2017_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","पाँच सौ के पीछे एक को कर मानकर ले ले; और यहोवा की भेंट करके एलीआजर याजक को दे दे। ");
INSERT INTO hin2017_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","फिर इस्राएलियों के आधे में से, क्या मनुष्य, क्या गाय-बैल, क्या गदहे, क्या भेड़-बकरियाँ, क्या किसी प्रकार का पशु हो, पचास के पीछे एक लेकर यहोवा के निवास की रखवाली करनेवाले लेवियों को दे।” (गिन. 31:42-47, गिन. 3:7,8, 25, 31, 36) ");
INSERT INTO hin2017_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","यहोवा की इस आज्ञा के अनुसार जो उसने मूसा को दी मूसा और एलीआजर याजक ने किया। ");
INSERT INTO hin2017_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","और जो वस्तुएँ सेना के पुरुषों ने अपने-अपने लिये लूट ली थीं उनसे अधिक की लूट यह थी; अर्थात् छः लाख पचहत्तर हजार भेड़-बकरियाँ, ");
INSERT INTO hin2017_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","बहत्तर हजार गाय बैल, ");
INSERT INTO hin2017_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","इकसठ हजार गदहे, ");
INSERT INTO hin2017_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","और मनुष्यों में से जिन स्त्रियों ने पुरुष का मुँह नहीं देखा था वह सब बत्तीस हजार थीं। ");
INSERT INTO hin2017_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","और इसका आधा, अर्थात् उनका भाग जो युद्ध करने को गए थे, उसमें भेड़-बकरियाँ तीन लाख साढ़े सैंतीस हजार, ");
INSERT INTO hin2017_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","जिनमें से पौने सात सौ भेड़-बकरियाँ यहोवा का कर ठहरीं। ");
INSERT INTO hin2017_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","और गाय-बैल छत्तीस हजार, जिनमें से बहत्तर यहोवा का कर ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","और गदहे साढ़े तीस हजार, जिनमें से इकसठ यहोवा का कर ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","और मनुष्य सोलह हजार जिनमें से बत्तीस प्राणी यहोवा का कर ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","इस कर को जो यहोवा की भेंट थी मूसा ने यहोवा की आज्ञा के अनुसार एलीआजर याजक को दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","इस्राएलियों की मण्डली का आधा भाग, जिसे मूसा ने युद्ध करनेवाले पुरुषों के पास से अलग किया था ");
INSERT INTO hin2017_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","तीन लाख साढ़े सैंतीस हजार भेड़-बकरियाँ ");
INSERT INTO hin2017_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","छत्तीस हजार गाय-बैल, ");
INSERT INTO hin2017_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","साढ़े तीस हजार गदहे, ");
INSERT INTO hin2017_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","और सोलह हजार मनुष्य हुए। ");
INSERT INTO hin2017_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","इस आधे में से, यहोवा की आज्ञा के अनुसार मूसा ने, क्या मनुष्य क्या पशु, पचास में से एक लेकर यहोवा के निवास की रखवाली करनेवाले लेवियों को दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","तब सहस्रपति-शतपति आदि, जो सरदार सेना के हजारों के ऊपर नियुक्त थे, वे मूसा के पास आकर कहने लगे, ");
INSERT INTO hin2017_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","“जो सिपाही हमारे अधीन थे उनकी तेरे दासों ने गिनती ली, और उनमें से एक भी नहीं घटा। ");
INSERT INTO hin2017_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","इसलिए पायजेब, कड़े, मुंदरियाँ, बालियाँ, बाजूबन्द, सोने के जो गहने, जिसने पाया है, उनको हम यहोवा के सामने अपने प्राणों के निमित्त प्रायश्चित करने को यहोवा की भेंट करके ले आए हैं।” ");
INSERT INTO hin2017_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","तब मूसा और एलीआजर याजक ने उनसे वे सब सोने के नक्काशीदार गहने ले लिए। ");
INSERT INTO hin2017_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","और सहस्त्रपतियों और शतपतियों ने जो भेंट का सोना यहोवा की भेंट करके दिया वह सब सोलह हजार साढ़े सात सौ शेकेल का था। ");
INSERT INTO hin2017_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","(योद्धाओं ने तो अपने-अपने लिये लूट ले ली थी।) (गिन. 31:32; व्यव. 20:14) ");
INSERT INTO hin2017_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","यह सोना मूसा और एलीआजर याजक ने सहस्त्रपतियों और शतपतियों से लेकर मिलापवाले तम्बू में पहुँचा दिया, कि इस्राएलियों के लिये यहोवा के सामने स्मरण दिलानेवाली वस्तु ठहरे। (निर्ग. 30:16) ");
INSERT INTO hin2017_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","रूबेनियों और गादियों के पास बहुत से जानवर थे। जब उन्होंने याजेर और गिलाद देशों को देखकर विचार किया, कि वह पशुओं के योग्य देश है, ");
INSERT INTO hin2017_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","तब मूसा और एलीआजर याजक और मण्डली के प्रधानों के पास जाकर कहने लगे, ");
INSERT INTO hin2017_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“अतारोत, दीबोन, याजेर, निम्रा, हेशबोन, एलाले, सबाम, नबो, और बोन नगरों का देश ");
INSERT INTO hin2017_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","जिस पर यहोवा ने इस्राएल की मण्डली को विजय दिलवाई है, वह पशुओं के योग्य है; और तेरे दासों के पास पशु हैं।” ");
INSERT INTO hin2017_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","फिर उन्होंने कहा, “यदि तेरा अनुग्रह तेरे दासों पर हो, तो यह देश तेरे दासों को मिले कि उनकी निज भूमि हो; हमें यरदन पार न ले चल।” ");
INSERT INTO hin2017_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","मूसा ने गादियों और रूबेनियों से कहा, “जब तुम्हारे भाई युद्ध करने को जाएँगे तब क्या तुम यहाँ बैठे रहोगे? ");
INSERT INTO hin2017_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","और इस्राएलियों से भी उस पार के देश जाने के विषय, जो यहोवा ने उन्हें दिया है, तुम क्यों अस्वीकार करवाते हो? ");
INSERT INTO hin2017_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","जब मैंने तुम्हारे बापदादों को कादेशबर्ने से कनान देश देखने के लिये भेजा, तब उन्होंने भी ऐसा ही किया था। ");
INSERT INTO hin2017_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","अर्थात् जब उन्होंने एशकोल नामक घाटी तक पहुँचकर देश को देखा, तब इस्राएलियों से उस देश के विषय जो यहोवा ने उन्हें दिया था अस्वीकार करा दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","इसलिए उस समय यहोवा ने कोप करके यह शपथ खाई, ");
INSERT INTO hin2017_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘निःसन्देह जो मनुष्य मिस्र से निकल आए हैं उनमें से, जितने बीस वर्ष के या उससे अधिक आयु के हैं, वे उस देश को देखने न पाएँगे, जिसके देने की शपथ मैंने अब्राहम, इसहाक, और याकूब से खाई है, क्योंकि वे मेरे पीछे पूरी रीति से नहीं हो लिये; ");
INSERT INTO hin2017_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","परन्तु यपुन्ने कनजी का पुत्र कालेब, और नून का पुत्र यहोशू, ये दोनों जो मेरे पीछे पूरी रीति से हो लिये हैं ये उसे देखने पाएँगे।’ ");
INSERT INTO hin2017_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","अतः यहोवा का कोप इस्राएलियों पर भड़का, और जब तक उस पीढ़ी के सब लोगों का अन्त न हुआ, जिन्होंने यहोवा के प्रति बुरा किया था, तब तक अर्थात् चालीस वर्ष तक वह उन्हें जंगल में मारे-मारे फिराता रहा। ");
INSERT INTO hin2017_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","और सुनो, तुम लोग उन पापियों के बच्चे होकर इसलिए अपने बापदादों के स्थान पर प्रगट हुए हो, कि इस्राएल के विरुद्ध यहोवा के भड़के हुए कोप को और भी भड़काओ! ");
INSERT INTO hin2017_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","यदि तुम उसके पीछे चलने से फिर जाओ, तो वह फिर हम सभी को जंगल में छोड़ देगा; इस प्रकार तुम इन सारे लोगों का नाश कराओगे।” ");
INSERT INTO hin2017_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","तब उन्होंने मूसा के और निकट आकर कहा, “हम अपने पशुओं के लिये यहीं भेड़शालाएँ बनाएँगे, और अपने बाल-बच्चों के लिये यहीं नगर बसाएँगे, ");
INSERT INTO hin2017_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","परन्तु आप इस्राएलियों के आगे-आगे हथियार-बन्द तब तक चलेंगे, जब तक उनको उनके स्थान में न पहुँचा दें; परन्तु हमारे बाल-बच्चे इस देश के निवासियों के डर से गढ़वाले नगरों में रहेंगे। ");
INSERT INTO hin2017_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","परन्तु जब तक इस्राएली अपने-अपने भाग के अधिकारी न हों तब तक हम अपने घरों को न लौटेंगे। ");
INSERT INTO hin2017_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","हम उनके साथ यरदन पार या कहीं आगे अपना भाग न लेंगे, क्योंकि हमारा भाग यरदन के इसी पार पूर्व की ओर मिला है।” ");
INSERT INTO hin2017_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","तब मूसा ने उनसे कहा, “यदि तुम ऐसा करो, अर्थात् यदि तुम यहोवा के आगे-आगे युद्ध करने को हथियार बाँधो। ");
INSERT INTO hin2017_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","और हर एक हथियार-बन्द यरदन के पार तब तक चले, जब तक यहोवा अपने आगे से अपने शत्रुओं को न निकाले ");
INSERT INTO hin2017_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","और देश यहोवा के वश में न आए; तो उसके पीछे तुम यहाँ लौटोगे, और यहोवा के और इस्राएल के विषय निर्दोष ठहरोगे; और यह देश यहोवा के प्रति तुम्हारी निज भूमि ठहरेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","और यदि तुम ऐसा न करो, तो यहोवा के विरुद्ध पापी ठहरोगे; और जान रखो कि तुम को तुम्हारा पाप लगेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","तुम अपने बाल-बच्चों के लिये नगर बसाओ, और अपनी भेड़-बकरियों के लिये भेड़शालाएँ बनाओ; और जो तुम्हारे मुँह से निकला है वही करो।” ");
INSERT INTO hin2017_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","तब गादियों और रूबेनियों ने मूसा से कहा, “अपने प्रभु की आज्ञा के अनुसार तेरे दास करेंगे। ");
INSERT INTO hin2017_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","हमारे बाल-बच्चे, स्त्रियाँ, भेड़-बकरी आदि, सब पशु तो यहीं गिलाद के नगरों में रहेंगे; ");
INSERT INTO hin2017_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","परन्तु अपने प्रभु के कहे के अनुसार तेरे दास सब के सब युद्ध के लिये हथियार-बन्द यहोवा के आगे-आगे लड़ने को पार जाएँगे।” ");
INSERT INTO hin2017_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","“तब मूसा ने उनके विषय में एलीआजर याजक, और नून के पुत्र यहोशू, और इस्राएलियों के गोत्रों के पितरों के घरानों के मुख्य-मुख्य पुरुषों को यह आज्ञा दी, ");
INSERT INTO hin2017_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","कि यदि सब गादी और रूबेनी पुरुष युद्ध के लिये हथियार-बन्द तुम्हारे संग यरदन पार जाएँ, और देश तुम्हारे वश में आ जाए, तो गिलाद देश उनकी निज भूमि होने को उन्हें देना। ");
INSERT INTO hin2017_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","परन्तु यदि वे तुम्हारे संग हथियार-बन्द पार न जाएँ, तो उनकी निज भूमि तुम्हारे बीच कनान देश में ठहरे।” ");
INSERT INTO hin2017_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","तब गादी और रूबेनी बोल उठे, “यहोवा ने जैसा तेरे दासों से कहलाया है वैसा ही हम करेंगे। ");
INSERT INTO hin2017_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","हम हथियार-बन्द यहोवा के आगे-आगे उस पार कनान देश में जाएँगे, परन्तु हमारी निज भूमि यरदन के इसी पार रहे।” ");
INSERT INTO hin2017_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","तब मूसा ने गादियों और रूबेनियों को, और यूसुफ के पुत्र मनश्शे के आधे गोत्रियों को एमोरियों के राजा सीहोन और बाशान के राजा ओग, दोनों के राज्यों का देश, नगरों, और उनके आस-पास की भूमि समेत दे दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","तब गादियों ने दीबोन, अतारोत, अरोएर, ");
INSERT INTO hin2017_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","अत्रौत, शोपान, याजेर, योगबहा, ");
INSERT INTO hin2017_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","बेतनिम्रा, और बेत-हारन नामक नगरों को दृढ़ किया, और उनमें भेड़-बकरियों के लिये भेड़शाला बनाए। ");
INSERT INTO hin2017_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","और रूबेनियों ने हेशबोन, एलाले, और किर्यातैम को, ");
INSERT INTO hin2017_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","फिर नबो और बालमोन के नाम बदलकर उनको, और सिबमा को दृढ़ किया; और उन्होंने अपने दृढ़ किए हुए नगरों के और-और नाम रखे। ");
INSERT INTO hin2017_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","और मनश्शे के पुत्र माकीर के वंशवालों ने गिलाद देश में जाकर उसे ले लिया, और जो एमोरी उसमें रहते थे उनको निकाल दिया। ");
INSERT INTO hin2017_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","तब मूसा ने मनश्शे के पुत्र माकीर के वंश को गिलाद दे दिया, और वे उसमें रहने लगे। ");
INSERT INTO hin2017_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","और मनश्शेई याईर ने जाकर गिलाद की कितनी बस्तियाँ ले लीं, और उनके नाम हव्वोत्याईर रखे। ");
INSERT INTO hin2017_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","और नोबह ने जाकर गाँवों समेत कनात को ले लिया, और उसका नाम अपने नाम पर नोबह रखा। ");
INSERT INTO hin2017_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","जब से इस्राएली मूसा और हारून की अगुआई में दल बाँधकर मिस्र देश से निकले, तब से उनके ये पड़ाव हुए। ");
INSERT INTO hin2017_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","मूसा ने यहोवा से आज्ञा पाकर उनके कूच उनके पड़ावों के अनुसार लिख दिए; और वे ये हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","पहले महीने के पन्द्रहवें दिन को उन्होंने रामसेस से कूच किया; फसह के दूसरे दिन इस्राएली सब मिस्रियों के देखते बेखटके निकल गए, ");
INSERT INTO hin2017_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","जबकि मिस्री अपने सब पहिलौठों को मिट्टी दे रहे थे जिन्हें यहोवा ने मारा था; और उसने उनके देवताओं को भी दण्ड दिया था। ");
INSERT INTO hin2017_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","इस्राएलियों ने रामसेस से कूच करके सुक्कोत में डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","और सुक्कोत से कूच करके एताम में, जो जंगल के छोर पर है, डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","और एताम से कूच करके वे पीहहीरोत को मुड़ गए, जो बाल-सपोन के सामने है; और मिग्दोल के सामने डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","तब वे पीहहीरोत के सामने से कूच कर समुद्र के बीच होकर जंगल में गए, और एताम नामक जंगल में तीन दिन का मार्ग चलकर मारा में डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","फिर मारा से कूच करके वे एलीम को गए, और एलीम में जल के बारह सोते और सत्तर खजूर के वृक्ष मिले, और उन्होंने वहाँ डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","तब उन्होंने एलीम से कूच करके लाल समुद्र के तट पर डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","और लाल समुद्र से कूच करके सीन नामक जंगल में डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","फिर सीन नामक जंगल से कूच करके उन्होंने दोपका में डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","और दोपका से कूच करके आलूश में डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","और आलूश से कूच करके रपीदीम में डेरा किया, और वहाँ उन लोगों को पीने का पानी न मिला। ");
INSERT INTO hin2017_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","फिर उन्होंने रपीदीम से कूच करके सीनै के जंगल में डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","और सीनै के जंगल से कूच करके किब्रोतहत्तावा में डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","और किब्रोतहत्तावा से कूच करके हसेरोत में डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","और हसेरोत से कूच करके रित्मा में डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","फिर उन्होंने रित्मा से कूच करके रिम्मोनपेरेस में डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","और रिम्मोनपेरेस से कूच करके लिब्ना में डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","और लिब्ना से कूच करके रिस्सा में डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","और रिस्सा से कूच करके कहेलाता में डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","और कहेलाता से कूच करके शेपेर पर्वत के पास डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","फिर उन्होंने शेपेर पर्वत से कूच करके हरादा में डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","और हरादा से कूच करके मखेलोत में डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","और मखेलोत से कूच करके तहत में डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","और तहत से कूच करके तेरह में डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","और तेरह से कूच करके मित्का में डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","फिर मित्का से कूच करके उन्होंने हशमोना में डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","और हशमोना से कूच करके मोसेरोत में डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","और मोसेरोत से कूच करके याकानियों के बीच डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","और याकानियों के बीच से कूच करके होर्हग्गिदगाद में डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","और होर्हग्गिदगाद से कूच करके योतबाता में डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","और योतबाता से कूच करके अब्रोना में डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","और अब्रोना से कूच करके एस्योनगेबेर में डेरे खड़े किए। ");
INSERT INTO hin2017_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","और एस्योनगेबेर से कूच करके उन्होंने सीन नामक जंगल के कादेश में डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","फिर कादेश से कूच करके होर पर्वत के पास, जो एदोम देश की सीमा पर है, डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","वहाँ इस्राएलियों के मिस्र देश से निकलने के चालीसवें वर्ष के पाँचवें महीने के पहले दिन को हारून याजक यहोवा की आज्ञा पाकर होर पर्वत पर चढ़ा, और वहाँ मर गया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","और जब हारून होर पर्वत पर मर गया तब वह एक सौ तेईस वर्ष का था। ");
INSERT INTO hin2017_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","और अराद का कनानी राजा, जो कनान देश के दक्षिण भाग में रहता था, उसने इस्राएलियों के आने का समाचार पाया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","तब इस्राएलियों ने होर पर्वत से कूच करके सलमोना में डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","और सलमोना से कूच करके पूनोन में डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","और पूनोन से कूच करके ओबोत में डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","और ओबोत से कूच करके अबारीम नामक डीहों में जो मोआब की सीमा पर हैं, डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","तब उन डीहों से कूच करके उन्होंने दीबोन-गाद में डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","और दीबोन-गाद से कूच करके अल्मोनदिबलातैम में डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","और अल्मोनदिबलातैम से कूच करके उन्होंने अबारीम नामक पहाड़ों में नबो के सामने डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","फिर अबारीम पहाड़ों से कूच करके मोआब के अराबा में, यरीहो के पास यरदन नदी के तट पर डेरा किया। ");
INSERT INTO hin2017_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","और उन्होंने मोआब के अराबा में बेत्यशीमोत से लेकर आबेलशित्तीम तक यरदन के किनारे-किनारे डेरे डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","फिर मोआब के अराबा में, यरीहो के पास की यरदन नदी के तट पर, यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“इस्राएलियों को समझाकर कह: जब तुम यरदन पार होकर कनान देश में पहुँचो ");
INSERT INTO hin2017_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","तब उस देश के निवासियों को उनके देश से निकाल देना; और उनके सब नक्काशीदार पत्थरों को और ढली हुई मूर्तियों को नाश करना, और उनके सब पूजा के ऊँचे स्थानों को ढा देना। ");
INSERT INTO hin2017_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","और उस देश को अपने अधिकार में लेकर उसमें निवास करना, क्योंकि मैंने वह देश तुम्हीं को दिया है कि तुम उसके अधिकारी हो। ");
INSERT INTO hin2017_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","और तुम उस देश को चिट्ठी डालकर अपने कुलों के अनुसार बाँट लेना; अर्थात् जो कुल अधिकवाले हैं उन्हें अधिक, और जो थोड़ेवाले हैं उनको थोड़ा भाग देना; जिस कुल की चिट्ठी जिस स्थान के लिये निकले वही उसका भाग ठहरे; अपने पितरों के गोत्रों के अनुसार अपना-अपना भाग लेना। ");
INSERT INTO hin2017_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","परन्तु यदि तुम उस देश के निवासियों को अपने आगे से न निकालोगे, तो उनमें से जिनको तुम उसमें रहने दोगे, वे मानो तुम्हारी आँखों में काँटे और तुम्हारे पांजरों में कीलें ठहरेंगे, और वे उस देश में जहाँ तुम बसोगे, तुम्हें संकट में डालेंगे। ");
INSERT INTO hin2017_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","और उनसे जैसा बर्ताव करने की मनसा मैंने की है वैसा ही तुम से करूँगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“इस्राएलियों को यह आज्ञा दे: कि जो देश तुम्हारा भाग होगा वह तो चारों ओर की सीमा तक का कनान देश है, इसलिए जब तुम कनान देश में पहुँचो, ");
INSERT INTO hin2017_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","तब तुम्हारा दक्षिणी प्रान्त सीन नामक जंगल से ले एदोम देश के किनारे-किनारे होता हुआ चला जाए, और तुम्हारी दक्षिणी सीमा खारे ताल के सिरे पर आरम्भ होकर पश्चिम की ओर चले; ");
INSERT INTO hin2017_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","वहाँ से तुम्हारी सीमा अक्रब्बीम नामक चढ़ाई के दक्षिण की ओर पहुँचकर मुड़े, और सीन तक आए, और कादेशबर्ने के दक्षिण की ओर निकले, और हसरद्दार तक बढ़के अस्मोन तक पहुँचे; ");
INSERT INTO hin2017_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","फिर वह सीमा अस्मोन से घूमकर मिस्र के नाले तक पहुँचे, और उसका अन्त समुद्र का तट ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“फिर पश्चिमी सीमा महासमुद्र हो; तुम्हारी पश्चिमी सीमा यही ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“तुम्हारी उत्तरी सीमा यह हो, अर्थात् तुम महासमुद्र से ले होर पर्वत तक सीमा बाँधना; ");
INSERT INTO hin2017_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","और होर पर्वत से हमात की घाटी तक सीमा बाँधना, और वह सदाद पर निकले; ");
INSERT INTO hin2017_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","फिर वह सीमा जिप्रोन तक पहुँचे, और हसरेनान पर निकले; तुम्हारी उत्तरी सीमा यही ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“फिर अपनी पूर्वी सीमा हसरेनान से शपाम तक बाँधना; ");
INSERT INTO hin2017_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","और वह सीमा शपाम से रिबला तक, जो ऐन के पूर्व की ओर है, नीचे को उतरते-उतरते किन्नेरेत नामक ताल के पूर्व से लग जाए; ");
INSERT INTO hin2017_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","और वह सीमा यरदन तक उतरकर खारे ताल के तट पर निकले। तुम्हारे देश की चारों सीमाएँ ये ही ठहरें।” ");
INSERT INTO hin2017_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","तब मूसा ने इस्राएलियों से फिर कहा, “जिस देश के तुम चिट्ठी डालकर अधिकारी होंगे, और यहोवा ने उसे साढ़े नौ गोत्र के लोगों को देने की आज्ञा दी है, वह यही है; ");
INSERT INTO hin2017_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","परन्तु रूबेनियों और गादियों के गोत्र तो अपने-अपने पितरों के कुलों के अनुसार अपना-अपना भाग पा चुके हैं, और मनश्शे के आधे गोत्र के लोग भी अपना भाग पा चुके हैं; ");
INSERT INTO hin2017_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","अर्थात् उन ढाई गोत्रों के लोग यरीहो के पास यरदन के पार पूर्व दिशा में, जहाँ सूर्योदय होता है, अपना-अपना भाग पा चुके हैं।” ");
INSERT INTO hin2017_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“जो पुरुष तुम लोगों के लिये उस देश को बाँटेंगे उनके नाम ये हैं एलीआजर याजक और नून का पुत्र यहोशू। ");
INSERT INTO hin2017_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","और देश को बाँटने के लिये एक-एक गोत्र का एक-एक प्रधान ठहराना। ");
INSERT INTO hin2017_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","और इन पुरुषों के नाम ये हैं यहूदागोत्री यपुन्ने का पुत्र कालेब, ");
INSERT INTO hin2017_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","शिमोनगोत्री अम्मीहूद का पुत्र शमूएल, ");
INSERT INTO hin2017_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","बिन्यामीनगोत्री किसलोन का पुत्र एलीदाद, ");
INSERT INTO hin2017_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","दान के गोत्र का प्रधान योग्ली का पुत्र बुक्की, ");
INSERT INTO hin2017_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","यूसुफियों में से मनश्शेइयों के गोत्र का प्रधान एपोद का पुत्र हन्नीएल, ");
INSERT INTO hin2017_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","और एप्रैमियों के गोत्र का प्रधान शिप्तान का पुत्र कमूएल, ");
INSERT INTO hin2017_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","जबूलूनियों के गोत्र का प्रधान पर्नाक का पुत्र एलीसापान, ");
INSERT INTO hin2017_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","इस्साकारियों के गोत्र का प्रधान अज्जान का पुत्र पलतीएल, ");
INSERT INTO hin2017_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","आशेरियों के गोत्र का प्रधान शलोमी का पुत्र अहीहूद, ");
INSERT INTO hin2017_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","और नप्तालियों के गोत्र का प्रधान अम्मीहूद का पुत्र पदहेल।” ");
INSERT INTO hin2017_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","जिन पुरुषों को यहोवा ने कनान देश को इस्राएलियों के लिये बाँटने की आज्ञा दी वे ये ही हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","फिर यहोवा ने, मोआब के अराबा में, यरीहो के पास की यरदन नदी के तट पर मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“इस्राएलियों को आज्ञा दे, कि तुम अपने-अपने निज भाग की भूमि में से लेवियों को रहने के लिये नगर देना; और नगरों के चारों ओर की चराइयाँ भी उनको देना। ");
INSERT INTO hin2017_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","नगर तो उनके रहने के लिये, और चराइयाँ उनके गाय-बैल और भेड़-बकरी आदि, उनके सब पशुओं के लिये होंगी। ");
INSERT INTO hin2017_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","और नगरों की चराइयाँ, जिन्हें तुम लेवियों को दोगे, वह एक-एक नगर की शहरपनाह से बाहर चारों ओर एक-एक हजार हाथ तक की हों। ");
INSERT INTO hin2017_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","और नगर के बाहर पूर्व, दक्षिण, पश्चिम, और उत्तर की ओर, दो-दो हजार हाथ इस रीति से नापना कि नगर बीचों बीच हो; लेवियों के एक-एक नगर की चराई इतनी ही भूमि की हो। ");
INSERT INTO hin2017_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","और जो नगर तुम लेवियों को दोगे उनमें से छः शरणनगर हों, जिन्हें तुम को खूनी के भागने के लिये ठहराना होगा, और उनसे अधिक बयालीस नगर और भी देना। ");
INSERT INTO hin2017_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","जितने नगर तुम लेवियों को दोगे वे सब अड़तालीस हों, और उनके साथ चराइयाँ देना। ");
INSERT INTO hin2017_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","और जो नगर तुम इस्राएलियों की निज भूमि में से दो, वे जिनके बहुत नगर हों उनसे बहुत, और जिनके थोड़े नगर हों उनसे थोड़े लेकर देना; सब अपने-अपने नगरों में से लेवियों को अपने ही अपने भाग के अनुसार दें।” ");
INSERT INTO hin2017_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2017_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“इस्राएलियों से कह: जब तुम यरदन पार होकर कनान देश में पहुँचो, ");
INSERT INTO hin2017_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","तक ऐसे नगर ठहराना जो तुम्हारे लिये शरणनगर हों, कि जो कोई किसी को भूल से मारकर खूनी ठहरा हो वह वहाँ भाग जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","वे नगर तुम्हारे निमित्त पलटा लेनेवाले से शरण लेने के काम आएँगे, कि जब तक खूनी न्याय के लिये मण्डली के सामने खड़ा न हो तब तक वह न मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","और शरण के जो नगर तुम दोगे वे छः हों। ");
INSERT INTO hin2017_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","तीन नगर तो यरदन के इस पार, और तीन कनान देश में देना; शरणनगर इतने ही रहें। ");
INSERT INTO hin2017_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ये छहों नगर इस्राएलियों के और उनके बीच रहनेवाले परदेशियों के लिये भी शरणस्थान ठहरें, कि जो कोई किसी को भूल से मार डाले वह वहीं भाग जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“परन्तु यदि कोई किसी को लोहे के किसी हथियार से ऐसा मारे कि वह मर जाए, तो वह खूनी ठहरेगा; और वह खूनी अवश्य मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","और यदि कोई ऐसा पत्थर हाथ में लेकर, जिससे कोई मर सकता है, किसी को मारे, और वह मर जाए, तो वह भी खूनी ठहरेगा; और वह खूनी अवश्य मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","या कोई हाथ में ऐसी लकड़ी लेकर, जिससे कोई मर सकता है, किसी को मारे, और वह मर जाए, तो वह भी खूनी ठहरेगा; और वह खूनी अवश्य मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","लहू का पलटा लेनेवाला आप ही उस खूनी को मार डाले; जब भी वह मिले तब ही वह उसे मार डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","और यदि कोई किसी को बैर से ढकेल दे, या घात लगाकर कुछ उस पर ऐसे फेंक दे कि वह मर जाए, ");
INSERT INTO hin2017_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","या शत्रुता से उसको अपने हाथ से ऐसा मारे कि वह मर जाए, तो जिसने मारा हो वह अवश्य मार डाला जाए; वह खूनी ठहरेगा; लहू का पलटा लेनेवाला जब भी वह खूनी उसे मिल जाए तब ही उसको मार डाले। ");
INSERT INTO hin2017_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“परन्तु यदि कोई किसी को बिना सोचे, और बिना शत्रुता रखे ढकेल दे, या बिना घात लगाए उस पर कुछ फेंक दे, ");
INSERT INTO hin2017_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","या ऐसा कोई पत्थर लेकर, जिससे कोई मर सकता है, दूसरे को बिना देखे उस पर फेंक दे, और वह मर जाए, परन्तु वह न उसका शत्रु हो, और न उसकी हानि का खोजी रहा हो; ");
INSERT INTO hin2017_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","तो मण्डली मारनेवाले और लहू का पलटा लेनेवाले के बीच इन नियमों के अनुसार न्याय करे; (गिन. 35:12, यहो. 20:6) ");
INSERT INTO hin2017_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","और मण्डली उस खूनी को लहू के पलटा लेनेवाले के हाथ से बचाकर उस शरणनगर में जहाँ वह पहले भाग गया हो लौटा दे, और जब तक पवित्र तेल से अभिषेक किया हुआ महायाजक न मर जाए तब तक वह वहीं रहे। ");
INSERT INTO hin2017_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","परन्तु यदि वह खूनी उस शरणनगर की सीमा से जिसमें वह भाग गया हो बाहर निकलकर और कहीं जाए, ");
INSERT INTO hin2017_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","और लहू का पलटा लेनेवाला उसको शरणनगर की सीमा के बाहर कहीं पाकर मार डाले, तो वह लहू बहाने का दोषी न ठहरे। ");
INSERT INTO hin2017_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","क्योंकि खूनी को महायाजक की मृत्यु तक शरणनगर में रहना चाहिये; और महायाजक के मरने के पश्चात् वह अपनी निज भूमि को लौट सकेगा। ");
INSERT INTO hin2017_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“तुम्हारी पीढ़ी-पीढ़ी में तुम्हारे सब रहने के स्थानों में न्याय की यह विधि होगी। ");
INSERT INTO hin2017_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","और जो कोई किसी मनुष्य को मार डाले वह साक्षियों के कहने पर मार डाला जाए, परन्तु एक ही साक्षी की साक्षी से कोई न मार डाला जाए। (व्यव. 17:6, मत्ती 18:16) ");
INSERT INTO hin2017_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","और जो खूनी प्राणदण्ड के योग्य ठहरे उससे प्राणदण्ड के बदले में जुर्माना न लेना; वह अवश्य मार डाला जाए। ");
INSERT INTO hin2017_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","और जो किसी शरणनगर में भागा हो उसके लिये भी इस मतलब से जुर्माना न लेना, कि वह याजक के मरने से पहले फिर अपने देश में रहने को लौटने पाए। ");
INSERT INTO hin2017_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","इसलिए जिस देश में तुम रहोगे उसको अशुद्ध न करना; खून से तो देश अशुद्ध हो जाता है, और जिस देश में जब खून किया जाए तब केवल खूनी के लहू बहाने ही से उस देश का प्रायश्चित हो सकता है। (व्यव. 21:7) ");
INSERT INTO hin2017_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","जिस देश में तुम निवास करोगे उसके बीच मैं रहूँगा, उसको अशुद्ध न करना; मैं यहोवा तो इस्राएलियों के बीच रहता हूँ।” (लैव्य. 18:24) ");
INSERT INTO hin2017_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","फिर यूसुफियों के कुलों में से गिलाद, जो माकीर का पुत्र और मनश्शे का पोता था, उसके वंश के कुल के पितरों के घरानों के मुख्य-मुख्य पुरुष मूसा के समीप जाकर उन प्रधानों के सामने, जो इस्राएलियों के पितरों के घरानों के मुख्य पुरुष थे, कहने लगे, ");
INSERT INTO hin2017_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“यहोवा ने हमारे प्रभु को आज्ञा दी थी, कि इस्राएलियों को चिट्ठी डालकर देश बाँट देना; और फिर यहोवा की यह भी आज्ञा हमारे प्रभु को मिली, कि हमारे सगोत्री सलोफाद का भाग उसकी बेटियों को देना। ");
INSERT INTO hin2017_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","पर यदि वे इस्राएलियों के और किसी गोत्र के पुरुषों से ब्याही जाएँ, तो उनका भाग हमारे पितरों के भाग से छूट जाएगा, और जिस गोत्र में वे ब्याही जाएँ उसी गोत्र के भाग में मिल जाएगा; तब हमारा भाग घट जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","और जब इस्राएलियों की जुबली होगी, तब जिस गोत्र में वे ब्याही जाएँ उसके भाग में उनका भाग पक्की रीति से मिल जाएगा; और वह हमारे पितरों के गोत्र के भाग से सदा के लिये छूट जाएगा।” ");
INSERT INTO hin2017_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","तब यहोवा से आज्ञा पाकर मूसा ने इस्राएलियों से कहा, “यूसुफियों के गोत्री ठीक कहते हैं। ");
INSERT INTO hin2017_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","सलोफाद की बेटियों के विषय में यहोवा ने यह आज्ञा दी है, कि जो वर जिसकी दृष्टि में अच्छा लगे वह उसी से ब्याही जाए; परन्तु वे अपने मूलपुरुष ही के गोत्र के कुल में ब्याही जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","और इस्राएलियों के किसी गोत्र का भाग दूसरे के गोत्र के भाग में न मिलने पाए; इस्राएली अपने-अपने मूलपुरुष के गोत्र के भाग पर बने रहें। ");
INSERT INTO hin2017_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","और इस्राएलियों के किसी गोत्र में किसी की बेटी हो जो भाग पानेवाली हो, वह अपने ही मूलपुरुष के गोत्र के किसी पुरुष से ब्याही जाए, इसलिए कि इस्राएली अपने-अपने मूलपुरुष के भाग के अधिकारी रहें। ");
INSERT INTO hin2017_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","किसी गोत्र का भाग दूसरे गोत्र के भाग में मिलने न पाए; इस्राएलियों के एक-एक गोत्र के लोग अपने-अपने भाग पर बने रहें।” ");
INSERT INTO hin2017_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","यहोवा की आज्ञा के अनुसार जो उसने मूसा को दी सलोफाद की बेटियों ने किया। ");
INSERT INTO hin2017_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","अर्थात् महला, तिर्सा, होग्ला, मिल्का, और नोवा, जो सलोफाद की बेटियाँ थीं, उन्होंने अपने चचेरे भाइयों से ब्याह किया। ");
INSERT INTO hin2017_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","वे यूसुफ के पुत्र मनश्शे के वंश के कुलों में ब्याही गईं, और उनका भाग उनके मूलपुरुष के कुल के गोत्र के अधिकार में बना रहा। ");
INSERT INTO hin2017_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","जो आज्ञाएँ और नियम यहोवा ने मोआब के अराबा में यरीहो के पास की यरदन नदी के तट पर मूसा के द्वारा इस्राएलियों को दिए वे ये ही हैं।");
INSERT INTO hin2017_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","जो बातें मूसा ने यरदन के पार जंगल में, अर्थात् सूफ के सामने के अराबा में, और पारान और तोपेल के बीच, और लाबान हसेरोत और दीजाहाब में, सारे इस्राएलियों से कहीं वे ये हैं। ");
INSERT INTO hin2017_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","होरेब से कादेशबर्ने तक सेईर पहाड़ का मार्ग ग्यारह दिन का है। ");
INSERT INTO hin2017_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","चालीसवें वर्ष के ग्यारहवें महीने के पहले दिन को जो कुछ यहोवा ने मूसा को इस्राएलियों से कहने की आज्ञा दी थी, उसके अनुसार मूसा उनसे ये बातें कहने लगा। ");
INSERT INTO hin2017_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","अर्थात् जब मूसा ने एमोरियों के राजा हेशबोनवासी सीहोन और बाशान के राजा अश्तारोतवासी ओग को एद्रेई में मार डाला, ");
INSERT INTO hin2017_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","उसके बाद यरदन के पार मोआब देश में वह व्यवस्था का विवरण ऐसे करने लगा, ");
INSERT INTO hin2017_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“हमारे परमेश्वर यहोवा ने होरेब के पास हम से कहा था, ‘तुम लोगों को इस पहाड़ के पास रहते हुए बहुत दिन हो गए हैं; ");
INSERT INTO hin2017_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","इसलिए अब यहाँ से कूच करो, और एमोरियों के पहाड़ी देश को, और क्या अराबा में, क्या पहाड़ों में, क्या नीचे के देश में, क्या दक्षिण देश में, क्या समुद्र के किनारे, जितने लोग एमोरियों के पास रहते हैं उनके देश को, अर्थात् लबानोन पर्वत तक और फरात नाम महानद तक रहनेवाले कनानियों के देश को भी चले जाओ। ");
INSERT INTO hin2017_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","सुनो, मैं उस देश को तुम्हारे सामने किए देता हूँ; जिस देश के विषय यहोवा ने अब्राहम, इसहाक, और याकूब, तुम्हारे पितरों से शपथ खाकर कहा था कि मैं इसे तुम को और तुम्हारे बाद तुम्हारे वंश को दूँगा, उसको अब जाकर अपने अधिकार में कर लो।’” ");
INSERT INTO hin2017_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","“फिर उसी समय मैंने तुम से कहा, ‘मैं तुम्हारा भार अकेला नहीं उठा सकता; ");
INSERT INTO hin2017_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","क्योंकि तुम्हारे परमेश्वर यहोवा ने तुम को यहाँ तक बढ़ाया है कि तुम गिनती में आज आकाश के तारों के समान हो गए हो। (इब्रा. 11:12) ");
INSERT INTO hin2017_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","तुम्हारे पितरों का परमेश्वर तुम को हजारगुणा और भी बढ़ाए, और अपने वचन के अनुसार तुम को आशीष भी देता रहे! ");
INSERT INTO hin2017_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","परन्तु तुम्हारे झंझट, और भार, और झगड़ों को मैं अकेला कहाँ तक सह सकता हूँ। ");
INSERT INTO hin2017_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","इसलिए तुम अपने-अपने गोत्र में से एक-एक बुद्धिमान और समझदार और प्रसिद्ध पुरुष चुन लो, और मैं उन्हें तुम पर मुखिया ठहराऊँगा।’ ");
INSERT INTO hin2017_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","इसके उत्तर में तुम ने मुझसे कहा, ‘जो कुछ तू हम से कहता है उसका करना अच्छा है।’ ");
INSERT INTO hin2017_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","इसलिए मैंने तुम्हारे गोत्रों के मुख्य पुरुषों को जो बुद्धिमान और प्रसिद्ध पुरुष थे चुनकर तुम पर मुखिया नियुक्त किया, अर्थात् हजार-हजार, सौ-सौ, पचास-पचास, और दस-दस के ऊपर प्रधान और तुम्हारे गोत्रों के सरदार भी नियुक्त किए। ");
INSERT INTO hin2017_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","और उस समय मैंने तुम्हारे न्यायियों को आज्ञा दी, ‘तुम अपने भाइयों के मुकद्दमे सुना करो, और उनके बीच और उनके पड़ोसियों और परदेशियों के बीच भी धार्मिकता से न्याय किया करो। (यूह. 7:51) ");
INSERT INTO hin2017_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","न्याय करते समय किसी का पक्ष न करना; जैसे बड़े की वैसे ही छोटे मनुष्य की भी सुनना; किसी का मुँह देखकर न डरना, क्योंकि न्याय परमेश्वर का काम है; और जो मुकद्दमा तुम्हारे लिये कठिन हो, वह मेरे पास ले आना, और मैं उसे सुनूँगा।’ (याकू. 2:9) ");
INSERT INTO hin2017_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","और मैंने उसी समय तुम्हारे सारे कर्तव्य तुम को बता दिए। ");
INSERT INTO hin2017_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“हम होरेब से कूच करके अपने परमेश्वर यहोवा की आज्ञा के अनुसार उस सारे बड़े और भयानक जंगल में होकर चले, जिसे तुम ने एमोरियों के पहाड़ी देश के मार्ग में देखा, और हम कादेशबर्ने तक आए। ");
INSERT INTO hin2017_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","वहाँ मैंने तुम से कहा, ‘तुम एमोरियों के पहाड़ी देश तक आ गए हो जिसको हमारा परमेश्वर यहोवा हमें देता है। ");
INSERT INTO hin2017_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","देखो, उस देश को तुम्हारा परमेश्वर यहोवा तुम्हारे सामने किए देता है, इसलिए अपने पितरों के परमेश्वर यहोवा के वचन के अनुसार उस पर चढ़ो, और उसे अपने अधिकार में ले लो; न तो तुम डरो और न तुम्हारा मन कच्चा हो।’ ");
INSERT INTO hin2017_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","और तुम सब मेरे पास आकर कहने लगे, ‘हम अपने आगे पुरुषों को भेज देंगे, जो उस देश का पता लगाकर हमको यह सन्देश दें, कि कौन से मार्ग से होकर चलना होगा और किस-किस नगर में प्रवेश करना पड़ेगा?’ ");
INSERT INTO hin2017_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","इस बात से प्रसन्न होकर मैंने तुम में से बारह पुरुष, अर्थात् हर गोत्र में से एक पुरुष चुन लिया; ");
INSERT INTO hin2017_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","और वे पहाड़ पर चढ़ गए, और एशकोल नामक नाले को पहुँचकर उस देश का भेद लिया। ");
INSERT INTO hin2017_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","और उस देश के फलों में से कुछ हाथ में लेकर हमारे पास आए, और हमको यह सन्देश दिया, ‘जो देश हमारा परमेश्वर यहोवा हमें देता है वह अच्छा है।’ ");
INSERT INTO hin2017_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“तो भी तुम ने वहाँ जाने से मना किया, किन्तु अपने परमेश्वर यहोवा की आज्ञा के विरुद्ध होकर ");
INSERT INTO hin2017_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","अपने-अपने डेरे में यह कहकर कुड़कुड़ाने लगे, ‘यहोवा हम से बैर रखता है, इस कारण हमको मिस्र देश से निकाल ले आया है, कि हमको एमोरियों के वश में करके हमारा सत्यानाश कर डाले। ");
INSERT INTO hin2017_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","हम किधर जाएँ? हमारे भाइयों ने यह कहकर हमारे मन को कच्चा कर दिया है कि वहाँ के लोग हम से बड़े और लम्बे हैं; और वहाँ के नगर बड़े-बड़े हैं, और उनकी शहरपनाह आकाश से बातें करती हैं; और हमने वहाँ अनाकवंशियों को भी देखा है।’ ");
INSERT INTO hin2017_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","मैंने तुम से कहा, ‘उनके कारण भय मत खाओ और न डरो। ");
INSERT INTO hin2017_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","तुम्हारा परमेश्वर यहोवा जो तुम्हारे आगे-आगे चलता है वह आप तुम्हारी ओर से लड़ेगा, जैसे कि उसने मिस्र में तुम्हारे देखते तुम्हारे लिये किया; ");
INSERT INTO hin2017_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","फिर तुम ने जंगल में भी देखा कि जिस रीति कोई पुरुष अपने लड़के को उठाए चलता है, उसी रीति हमारा परमेश्वर यहोवा हमको इस स्थान पर पहुँचने तक, उस सारे मार्ग में जिससे हम आए हैं, उठाए रहा।’ (प्रेरि. 13:18) ");
INSERT INTO hin2017_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","इस बात पर भी तुम ने अपने उस परमेश्वर यहोवा पर विश्वास नहीं किया, ");
INSERT INTO hin2017_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","जो तुम्हारे आगे-आगे इसलिए चलता रहा कि डेरे डालने का स्थान तुम्हारे लिये ढूँढ़े, और रात को आग में और दिन को बादल में प्रगट होकर चला, ताकि तुम को वह मार्ग दिखाए जिससे तुम चलो। ");
INSERT INTO hin2017_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“परन्तु तुम्हारी वे बातें सुनकर यहोवा का कोप भड़क उठा, और उसने यह शपथ खाई, ");
INSERT INTO hin2017_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘निश्चय इस बुरी पीढ़ी के मनुष्यों में से एक भी उस अच्छे देश को देखने न पाएगा, जिसे मैंने उनके पितरों को देने की शपथ खाई थी। ");
INSERT INTO hin2017_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","केवल यपुन्ने का पुत्र कालेब ही उसे देखने पाएगा, और जिस भूमि पर उसके पाँव पड़े हैं उसे मैं उसको और उसके वंश को भी दूँगा; क्योंकि वह मेरे पीछे पूरी रीति से हो लिया है।’ ");
INSERT INTO hin2017_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","और मुझ पर भी यहोवा तुम्हारे कारण क्रोधित हुआ, और यह कहा, ‘तू भी वहाँ जाने न पाएगा; ");
INSERT INTO hin2017_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","नून का पुत्र यहोशू जो तेरे सामने खड़ा रहता है, वह तो वहाँ जाने पाएगा; इसलिए तू उसको हियाव दे, क्योंकि उस देश को इस्राएलियों के अधिकार में वही कर देगा। ");
INSERT INTO hin2017_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","फिर तुम्हारे बाल-बच्चे जिनके विषय में तुम कहते हो कि ये लूट में चले जाएँगे, और तुम्हारे जो बच्चे अभी भले बुरे का भेद नहीं जानते, वे वहाँ प्रवेश करेंगे, और उनको मैं वह देश दूँगा, और वे उसके अधिकारी होंगे। ");
INSERT INTO hin2017_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","परन्तु तुम लोग घूमकर कूच करो, और लाल समुद्र के मार्ग से जंगल की ओर जाओ।’ ");
INSERT INTO hin2017_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“तब तुम ने मुझसे कहा, ‘हमने यहोवा के विरुद्ध पाप किया है; अब हम अपने परमेश्वर यहोवा की आज्ञा के अनुसार चढ़ाई करेंगे और लड़ेंगे।’ तब तुम अपने-अपने हथियार बाँधकर पहाड़ पर बिना सोचे समझे चढ़ने को तैयार हो गए। ");
INSERT INTO hin2017_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","तब यहोवा ने मुझसे कहा, ‘उनसे कह दे कि तुम मत चढ़ो, और न लड़ो; क्योंकि मैं तुम्हारे मध्य में नहीं हूँ; कहीं ऐसा न हो कि तुम अपने शत्रुओं से हार जाओ।’ ");
INSERT INTO hin2017_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","यह बात मैंने तुम से कह दी, परन्तु तुम ने न मानी; किन्तु ढिठाई से यहोवा की आज्ञा का उल्लंघन करके पहाड़ पर चढ़ गए। ");
INSERT INTO hin2017_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","तब उस पहाड़ के निवासी एमोरियों ने तुम्हारा सामना करने को निकलकर मधुमक्खियों के समान तुम्हारा पीछा किया, और सेईर देश के होर्मा तक तुम्हें मारते-मारते चले आए। ");
INSERT INTO hin2017_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","तब तुम लौटकर यहोवा के सामने रोने लगे; परन्तु यहोवा ने तुम्हारी न सुनी, न तुम्हारी बातों पर कान लगाया। ");
INSERT INTO hin2017_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","और तुम कादेश में बहुत दिनों तक रहे, यहाँ तक कि एक युग हो गया। ");
INSERT INTO hin2017_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“तब उस आज्ञा के अनुसार, जो यहोवा ने मुझ को दी थी, हमने घूमकर कूच किया, और लाल समुद्र के मार्ग के जंगल की ओर गए; और बहुत दिन तक सेईर पहाड़ के बाहर-बाहर चलते रहे। ");
INSERT INTO hin2017_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","तब यहोवा ने मुझसे कहा, ");
INSERT INTO hin2017_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘तुम लोगों को इस पहाड़ के बाहर-बाहर चलते हुए बहुत दिन बीत गए, अब घूमकर उत्तर की ओर चलो। ");
INSERT INTO hin2017_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","और तू प्रजा के लोगों को मेरी यह आज्ञा सुना, कि तुम सेईर के निवासी अपने भाई एसावियों की सीमा के पास होकर जाने पर हो; और वे तुम से डर जाएँगे। इसलिए तुम बहुत चौकस रहो; ");
INSERT INTO hin2017_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","उनसे लड़ाई न छेड़ना; क्योंकि उनके देश में से मैं तुम्हें पाँव रखने की जगह तक न दूँगा, इस कारण कि मैंने सेईर पर्वत एसावियों के अधिकार में कर दिया है। (प्रेरि. 7:5) ");
INSERT INTO hin2017_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","तुम उनसे भोजन रुपये से मोल लेकर खा सकोगे, और रुपया देकर कुओं से पानी भरकर पी सकोगे। ");
INSERT INTO hin2017_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","क्योंकि तुम्हारा परमेश्वर यहोवा तुम्हारे हाथों के सब कामों के विषय तुम्हें आशीष देता आया है; इस भारी जंगल में तुम्हारा चलना फिरना वह जानता है; इन चालीस वर्षों में तुम्हारा परमेश्वर यहोवा तुम्हारे संग-संग रहा है; और तुम को कुछ घटी नहीं हुई।’ ");
INSERT INTO hin2017_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","अतः हम सेईर निवासी अपने भाई एसावियों के पास से होकर, अराबा के मार्ग, और एलत और एस्योनगेबेर को पीछे छोड़कर चले। “फिर हम मुड़कर मोआब के जंगल के मार्ग से होकर चले। ");
INSERT INTO hin2017_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","और यहोवा ने मुझसे कहा, ‘मोआबियों को न सताना और न लड़ाई छेड़ना, क्योंकि मैं उनके देश में से कुछ भी तेरे अधिकार में न कर दूँगा क्योंकि मैंने आर को लूत के वंशजों के अधिकार में किया है। ");
INSERT INTO hin2017_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(पुराने दिनों में वहाँ एमी लोग बसे हुए थे, जो अनाकियों के समान बलवन्त और लम्बे-लम्बे और गिनती में बहुत थे; ");
INSERT INTO hin2017_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","और अनाकियों के समान वे भी रपाई गिने जाते थे, परन्तु मोआबी उन्हें एमी कहते हैं। ");
INSERT INTO hin2017_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","और पुराने दिनों में सेईर में होरी लोग बसे हुए थे, परन्तु एसावियों ने उनको उस देश से निकाल दिया, और अपने सामने से नाश करके उनके स्थान पर आप बस गए; जैसे कि इस्राएलियों ने यहोवा के दिए हुए अपने अधिकार के देश में किया।) ");
INSERT INTO hin2017_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","अब तुम लोग कूच करके जेरेद नदी के पार जाओ।’ तब हम जेरेद नदी के पार आए। ");
INSERT INTO hin2017_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","और हमारे कादेशबर्ने को छोड़ने से लेकर जेरेद नदी पार होने तक अड़तीस वर्ष बीत गए, उस बीच में यहोवा की शपथ के अनुसार उस पीढ़ी के सब योद्धा छावनी में से नाश हो गए। ");
INSERT INTO hin2017_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","और जब तक वे नाश न हुए तब तक यहोवा का हाथ उन्हें छावनी में से मिटा डालने के लिये उनके विरुद्ध बढ़ा ही रहा। ");
INSERT INTO hin2017_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“जब सब योद्धा मरते-मरते लोगों के बीच में से नाश हो गए, ");
INSERT INTO hin2017_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","तब यहोवा ने मुझसे कहा, ");
INSERT INTO hin2017_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘अब मोआब की सीमा, अर्थात् आर को पार कर; ");
INSERT INTO hin2017_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","और जब तू अम्मोनियों के सामने जाकर उनके निकट पहुँचे, तब उनको न सताना और न छेड़ना, क्योंकि मैं अम्मोनियों के देश में से कुछ भी तेरे अधिकार में न करूँगा, क्योंकि मैंने उसे लूत के वंशजों के अधिकार में कर दिया है। ");
INSERT INTO hin2017_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(वह देश भी रपाइयों का गिना जाता था, क्योंकि पुराने दिनों में रपाई, जिन्हें अम्मोनी जमजुम्मी कहते थे, वे वहाँ रहते थे; ");
INSERT INTO hin2017_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","वे भी अनाकियों के समान बलवान और लम्बे-लम्बे और गिनती में बहुत थे; परन्तु यहोवा ने उनको अम्मोनियों के सामने से नाश कर डाला, और उन्होंने उनको उस देश से निकाल दिया, और उनके स्थान पर आप रहने लगे; ");
INSERT INTO hin2017_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","जैसे कि उसने सेईर के निवासी एसावियों के सामने से होरियों को नाश किया, और उन्होंने उनको उस देश से निकाल दिया, और आज तक उनके स्थान पर वे आप निवास करते हैं। ");
INSERT INTO hin2017_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","वैसा ही अव्वियों को, जो गाज़ा नगर तक गाँवों में बसे हुए थे, उनको कप्तोरियों ने जो कप्तोर से निकले थे नाश किया, और उनके स्थान पर आप रहने लगे।) ");
INSERT INTO hin2017_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","अब तुम लोग उठकर कूच करो, और अर्नोन के नाले के पार चलो: सुन, मैं देश समेत हेशबोन के राजा एमोरी सीहोन को तेरे हाथ में कर देता हूँ; इसलिए उस देश को अपने अधिकार में लेना आरम्भ करो, और उस राजा से युद्ध छेड़ दो। ");
INSERT INTO hin2017_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","और जितने लोग धरती पर रहते हैं उन सभी के मन में मैं आज ही के दिन से तेरे कारण डर और थरथराहट समवाने लगूँगा; वे तेरा समाचार पाकर तेरे डर के मारे काँपेंगे और पीड़ित होंगे।’ ");
INSERT INTO hin2017_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“अतः मैंने कदेमोत नामक जंगल से हेशबोन के राजा सीहोन के पास मेल की ये बातें कहने को दूत भेजे: ");
INSERT INTO hin2017_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘मुझे अपने देश में से होकर जाने दे; मैं राजपथ पर से चला जाऊँगा, और दाएँ और बाएँ हाथ न मुड़ूँगा। ");
INSERT INTO hin2017_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","तू रुपया लेकर मेरे हाथ भोजनवस्तु देना कि मैं खाऊँ, और पानी भी रुपया लेकर मुझ को देना कि मैं पीऊँ; केवल मुझे पाँव-पाँव चले जाने दे, ");
INSERT INTO hin2017_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","जैसा सेईर के निवासी एसावियों ने और आर के निवासी मोआबियों ने मुझसे किया, वैसा ही तू भी मुझसे कर, इस रीति मैं यरदन पार होकर उस देश में पहुँचूँगा जो हमारा परमेश्वर यहोवा हमें देता है।’ ");
INSERT INTO hin2017_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","परन्तु हेशबोन के राजा सीहोन ने हमको अपने देश में से होकर चलने न दिया; क्योंकि तुम्हारे परमेश्वर यहोवा ने उसका चित्त कठोर और उसका मन हठीला कर दिया था, इसलिए कि उसको तुम्हारे हाथ में कर दे, जैसा कि आज प्रगट है। ");
INSERT INTO hin2017_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","और यहोवा ने मुझसे कहा, ‘सुन, मैं देश समेत सीहोन को तेरे वश में कर देने पर हूँ; उस देश को अपने अधिकार में लेना आरम्भ कर।’ ");
INSERT INTO hin2017_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","तब सीहोन अपनी सारी सेना समेत निकल आया, और हमारा सामना करके युद्ध करने को यहस तक चढ़ आया। ");
INSERT INTO hin2017_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","और हमारे परमेश्वर यहोवा ने उसको हमारे द्वारा हरा दिया, और हमने उसको पुत्रों और सारी सेना समेत मार डाला। ");
INSERT INTO hin2017_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","और उसी समय हमने उसके सारे नगर ले लिए, और एक-एक बसे हुए नगर की स्त्रियों और बाल-बच्चों समेत यहाँ तक सत्यानाश किया कि कोई न छूटा; ");
INSERT INTO hin2017_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","परन्तु पशुओं को हमने अपना कर लिया, और उन नगरों की लूट भी हमने ले ली जिनको हमने जीत लिया था। ");
INSERT INTO hin2017_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","अर्नोन के नाले के छोरवाले अरोएर नगर से लेकर, और उस नाले में के नगर से लेकर, गिलाद तक कोई नगर ऐसा ऊँचा न रहा जो हमारे सामने ठहर सकता था; क्योंकि हमारे परमेश्वर यहोवा ने सभी को हमारे वश में कर दिया। ");
INSERT INTO hin2017_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","परन्तु हम अम्मोनियों के देश के निकट, वरन् यब्बोक नदी के उस पार जितना देश है, और पहाड़ी देश के नगर जहाँ जाने से हमारे परमेश्वर यहोवा ने हमको मना किया था, वहाँ हम नहीं गए। ");
INSERT INTO hin2017_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“तब हम मुड़कर बाशान के मार्ग से चढ़ चले; और बाशान का ओग नामक राजा अपनी सारी सेना समेत हमारा सामना करने को निकल आया, कि एद्रेई में युद्ध करे। ");
INSERT INTO hin2017_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","तब यहोवा ने मुझसे कहा, ‘उससे मत डर; क्योंकि मैं उसको सारी सेना और देश समेत तेरे हाथ में किए देता हूँ; और जैसा तूने हेशबोन के निवासी एमोरियों के राजा सीहोन से किया है वैसा ही उससे भी करना।’ ");
INSERT INTO hin2017_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","इस प्रकार हमारे परमेश्वर यहोवा ने सारी सेना समेत बाशान के राजा ओग को भी हमारे हाथ में कर दिया; और हम उसको यहाँ तक मारते रहे कि उनमें से कोई भी न बच पाया। ");
INSERT INTO hin2017_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","उसी समय हमने उनके सारे नगरों को ले लिया, कोई ऐसा नगर न रह गया जिसे हमने उनसे न ले लिया हो, इस रीति अर्गोब का सारा देश, जो बाशान में ओग के राज्य में था और उसमें साठ नगर थे, वह हमारे वश में आ गया। ");
INSERT INTO hin2017_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ये सब नगर गढ़वाले थे, और उनके ऊँची-ऊँची शहरपनाह, और फाटक, और बेंड़े थे, और इनको छोड़ बिना शहरपनाह के भी बहुत से नगर थे। ");
INSERT INTO hin2017_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","और जैसा हमने हेशबोन के राजा सीहोन के नगरों से किया था वैसा ही हमने इन नगरों से भी किया, अर्थात् सब बसे हुए नगरों को स्त्रियों और बाल-बच्चों समेत सत्यानाश कर डाला। ");
INSERT INTO hin2017_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","परन्तु सब घरेलू पशु और नगरों की लूट हमने अपनी कर ली। ");
INSERT INTO hin2017_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","इस प्रकार हमने उस समय यरदन के इस पार रहनेवाले एमोरियों के दोनों राजाओं के हाथ से अर्नोन के नाले से लेकर हेर्मोन पर्वत तक का देश ले लिया। ");
INSERT INTO hin2017_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(हेर्मोन को सीदोनी लोग सिर्योन, और एमोरी लोग सनीर कहते हैं।) ");
INSERT INTO hin2017_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","समथर देश के सब नगर, और सारा गिलाद, और सल्का, और एद्रेई तक जो ओग के राज्य के नगर थे, सारा बाशान हमारे वश में आ गया। ");
INSERT INTO hin2017_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","जो रपाई रह गए थे, उनमें से केवल बाशान का राजा ओग रह गया था, उसकी चारपाई जो लोहे की है वह तो अम्मोनियों के रब्बाह नगर में पड़ी है, साधारण पुरुष के हाथ के हिसाब से उसकी लम्बाई नौ हाथ की और चौड़ाई चार हाथ की है। ");
INSERT INTO hin2017_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“जो देश हमने उस समय अपने अधिकार में ले लिया वह यह है, अर्थात् अर्नोन के नाले के किनारेवाले अरोएर नगर से लेकर सब नगरों समेत गिलाद के पहाड़ी देश का आधा भाग, जिसे मैंने रूबेनियों और गादियों को दे दिया, ");
INSERT INTO hin2017_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","और गिलाद का बचा हुआ भाग, और सारा बाशान, अर्थात् अर्गोब का सारा देश जो ओग के राज्य में था, इन्हें मैंने मनश्शे के आधे गोत्र को दे दिया। (सारा बाशान तो रपाइयों का देश कहलाता है। ");
INSERT INTO hin2017_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","और मनश्शेई याईर ने गशूरियों और माकावासियों की सीमा तक अर्गोब का सारा देश ले लिया, और बाशान के नगरों का नाम अपने नाम पर हब्बोत्याईर रखा, और वही नाम आज तक बना है।) ");
INSERT INTO hin2017_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","और मैंने गिलाद देश माकीर को दे दिया, ");
INSERT INTO hin2017_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","और रूबेनियों और गादियों को मैंने गिलाद से लेकर अर्नोन के नाले तक का देश दे दिया, अर्थात् उस नाले का बीच उनकी सीमा ठहराया, और यब्बोक नदी तक जो अम्मोनियों की सीमा है; ");
INSERT INTO hin2017_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","और किन्नेरेत से लेकर पिसगा की ढलान के नीचे के अराबा के ताल तक, जो खारा ताल भी कहलाता है, अराबा और यरदन की पूर्व की ओर का सारा देश भी मैंने उन्हीं को दे दिया। ");
INSERT INTO hin2017_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“उस समय मैंने तुम्हें यह आज्ञा दी, ‘तुम्हारे परमेश्वर यहोवा ने तुम्हें यह देश दिया है कि उसे अपने अधिकार में रखो; तुम सब योद्धा हथियार-बन्द होकर अपने भाई इस्राएलियों के आगे-आगे पार चलो। ");
INSERT INTO hin2017_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","परन्तु तुम्हारी स्त्रियाँ, और बाल-बच्चे, और पशु, जिन्हें मैं जानता हूँ कि बहुत से हैं, वह सब तुम्हारे नगरों में जो मैंने तुम्हें दिए हैं रह जाएँ। ");
INSERT INTO hin2017_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","और जब यहोवा तुम्हारे भाइयों को वैसा विश्राम दे जैसा कि उसने तुम को दिया है, और वे उस देश के अधिकारी हो जाएँ जो तुम्हारा परमेश्वर यहोवा उन्हें यरदन पार देता है; तब तुम भी अपने-अपने अधिकार की भूमि पर जो मैंने तुम्हें दी है लौटोगे।’ ");
INSERT INTO hin2017_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","फिर मैंने उसी समय यहोशू से चिताकर कहा, ‘तूने अपनी आँखों से देखा है कि तेरे परमेश्वर यहोवा ने इन दोनों राजाओं से क्या-क्या किया है; वैसा ही यहोवा उन सब राज्यों से करेगा जिनमें तू पार होकर जाएगा। ");
INSERT INTO hin2017_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","उनसे न डरना; क्योंकि जो तुम्हारी ओर से लड़नेवाला है वह तुम्हारा परमेश्वर यहोवा है।’ ");
INSERT INTO hin2017_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“उसी समय मैंने यहोवा से गिड़गिड़ाकर विनती की, ");
INSERT INTO hin2017_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘हे प्रभु यहोवा, तू अपने दास को अपनी महिमा और बलवन्त हाथ दिखाने लगा है; स्वर्ग में और पृथ्वी पर ऐसा कौन देवता है जो तेरे से काम और पराक्रम के कर्म कर सके? ");
INSERT INTO hin2017_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","इसलिए मुझे पार जाने दे कि यरदन पार के उस उत्तम देश को, अर्थात् उस उत्तम पहाड़ और लबानोन को भी देखने पाऊँ।’ ");
INSERT INTO hin2017_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","परन्तु यहोवा तुम्हारे कारण मुझसे रुष्ट हो गया, और मेरी न सुनी; किन्तु यहोवा ने मुझसे कहा, ‘बस कर; इस विषय में फिर कभी मुझसे बातें न करना। ");
INSERT INTO hin2017_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","पिसगा पहाड़ की चोटी पर चढ़ जा, और पूर्व, पश्चिम, उत्तर, दक्षिण, चारों ओर दृष्टि करके उस देश को देख ले; क्योंकि तू इस यरदन के पार जाने न पाएगा। ");
INSERT INTO hin2017_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","और यहोशू को आज्ञा दे, और उसे ढाढ़स देकर दृढ़ कर; क्योंकि इन लोगों के आगे-आगे वही पार जाएगा, और जो देश तू देखेगा उसको वही उनका निज भाग करा देगा।’ ");
INSERT INTO hin2017_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","तब हम बेतपोर के सामने की तराई में ठहरे रहे। ");
INSERT INTO hin2017_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","“अब, हे इस्राएल, जो-जो विधि और नियम मैं तुम्हें सिखाना चाहता हूँ उन्हें सुन लो, और उन पर चलो; जिससे तुम जीवित रहो, और जो देश तुम्हारे पितरों का परमेश्वर यहोवा तुम्हें देता है उसमें जाकर उसके अधिकारी हो जाओ। ");
INSERT INTO hin2017_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","जो आज्ञा मैं तुम को सुनाता हूँ उसमें न तो कुछ बढ़ाना, और न कुछ घटाना; तुम्हारे परमेश्वर यहोवा की जो-जो आज्ञा मैं तुम्हें सुनाता हूँ उन्हें तुम मानना (प्रका. 22:18) ");
INSERT INTO hin2017_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","तुम ने तो अपनी आँखों से देखा है कि बालपोर के कारण यहोवा ने क्या-क्या किया; अर्थात् जितने मनुष्य बालपोर के पीछे हो लिये थे उन सभी को तुम्हारे परमेश्वर यहोवा ने तुम्हारे बीच में से सत्यानाश कर डाला; ");
INSERT INTO hin2017_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","परन्तु तुम जो अपने परमेश्वर यहोवा के साथ लिपटे रहे हो सब के सब आज तक जीवित हो। ");
INSERT INTO hin2017_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","सुनो, मैंने तो अपने परमेश्वर यहोवा की आज्ञा के अनुसार तुम्हें विधि और नियम सिखाए हैं, कि जिस देश के अधिकारी होने जाते हो उसमें तुम उनके अनुसार चलो। ");
INSERT INTO hin2017_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","इसलिए तुम उनको धारण करना और मानना; क्योंकि और देशों के लोगों के सामने तुम्हारी बुद्धि और समझ इसी से प्रगट होगी, अर्थात् वे इन सब विधियों को सुनकर कहेंगे, कि निश्चय यह बड़ी जाति बुद्धिमान और समझदार है। ");
INSERT INTO hin2017_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","देखो, कौन ऐसी बड़ी जाति है जिसका देवता उसके ऐसे समीप रहता हो जैसा हमारा परमेश्वर यहोवा, जब भी हम उसको पुकारते हैं? (रोम. 3:2) ");
INSERT INTO hin2017_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","फिर कौन ऐसी बड़ी जाति है जिसके पास ऐसी धर्ममय विधि और नियम हों, जैसी कि यह सारी व्यवस्था जिसे मैं आज तुम्हारे सामने रखता हूँ? ");
INSERT INTO hin2017_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","“यह अत्यन्त आवश्यक है कि तुम अपने विषय में सचेत रहो, और अपने मन की बड़ी चौकसी करो, कहीं ऐसा न हो कि जो-जो बातें तुम ने अपनी आँखों से देखीं उनको भूल जाओ, और वह जीवन भर के लिये तुम्हारे मन से जाती रहें; किन्तु तुम उन्हें अपने बेटों पोतों को सिखाना। ");
INSERT INTO hin2017_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","विशेष करके उस दिन की बातें जिसमें तुम होरेब के पास अपने परमेश्वर यहोवा के सामने खड़े थे, जब यहोवा ने मुझसे कहा था, ‘उन लोगों को मेरे पास इकट्ठा कर कि मैं उन्हें अपने वचन सुनाऊँ, जिससे वे सीखें, ताकि जितने दिन वे पृथ्वी पर जीवित रहें उतने दिन मेरा भय मानते रहें, और अपने बाल-बच्चों को भी यही सिखाएँ।’ ");
INSERT INTO hin2017_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","तब तुम समीप जाकर उस पर्वत के नीचे खड़े हुए, और वह पहाड़ आग से धधक रहा था, और उसकी लौ आकाश तक पहुँचती थी, और उसके चारों ओर अंधियारा और बादल, और घोर अंधकार छाया हुआ था। (इब्रा. 12:18,19) ");
INSERT INTO hin2017_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","तब यहोवा ने उस आग के बीच में से तुम से बातें की; बातों का शब्द तो तुम को सुनाई पड़ा, परन्तु कोई रूप न देखा; केवल शब्द ही शब्द सुन पड़ा। ");
INSERT INTO hin2017_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","और उसने तुम को अपनी वाचा के दसों वचन बताकर उनके मानने की आज्ञा दी; और उन्हें पत्थर की दो पटियाओं पर लिख दिया। ");
INSERT INTO hin2017_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","और मुझ को यहोवा ने उसी समय तुम्हें विधि और नियम सिखाने की आज्ञा दी, इसलिए कि जिस देश के अधिकारी होने को तुम पार जाने पर हो उसमें तुम उनको माना करो। ");
INSERT INTO hin2017_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“इसलिए तुम अपने विषय में बहुत सावधान रहना। क्योंकि जब यहोवा ने तुम से होरेब पर्वत पर आग के बीच में से बातें की, तब तुम को कोई रूप न दिखाई पड़ा, (रोम. 1:23) ");
INSERT INTO hin2017_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","कहीं ऐसा न हो कि तुम बिगड़कर चाहे पुरुष चाहे स्त्री के, ");
INSERT INTO hin2017_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","चाहे पृथ्वी पर चलनेवाले किसी पशु, चाहे आकाश में उड़नेवाले किसी पक्षी के। ");
INSERT INTO hin2017_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","“चाहे भूमि पर रेंगनेवाले किसी जन्तु, चाहे पृथ्वी के जल में रहनेवाली किसी मछली के रूप की कोई मूर्ति खोदकर बना लो, ");
INSERT INTO hin2017_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","या जब तुम आकाश की ओर आँखें उठाकर, सूर्य, चन्द्रमा, और तारों को, अर्थात् आकाश का सारा तारागण देखो, तब बहक कर उन्हें दण्डवत् करके उनकी सेवा करने लगो, जिनको तुम्हारे परमेश्वर यहोवा ने धरती पर के सब देशवालों के लिये रखा है। ");
INSERT INTO hin2017_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","और तुम को यहोवा लोहे के भट्ठे के सरीखे मिस्र देश से निकाल ले आया है, इसलिए कि तुम उसका प्रजारूपी निज भाग ठहरो, जैसा आज प्रगट है। ");
INSERT INTO hin2017_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","फिर तुम्हारे कारण यहोवा ने मुझसे क्रोध करके यह शपथ खाई, ‘तू यरदन पार जाने न पाएगा, और जो उत्तम देश इस्राएलियों का परमेश्वर यहोवा उन्हें उनका निज भाग करके देता है, उसमें तू प्रवेश करने न पाएगा।’ ");
INSERT INTO hin2017_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","किन्तु मुझे इसी देश में मरना है, मैं तो यरदन पार नहीं जा सकता; परन्तु तुम पार जाकर उस उत्तम देश के अधिकारी हो जाओगे। ");
INSERT INTO hin2017_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","इसलिए अपने विषय में तुम सावधान रहो, कहीं ऐसा न हो कि तुम उस वाचा को भूलकर, जो तुम्हारे परमेश्वर यहोवा ने तुम से बाँधी है, किसी और वस्तु की मूर्ति खोदकर बनाओ, जिसे तुम्हारे परमेश्वर यहोवा ने तुम को मना किया है। ");
INSERT INTO hin2017_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","क्योंकि तुम्हारा परमेश्वर यहोवा भस्म करनेवाली आग है; वह जलन रखनेवाला परमेश्वर है। (इब्रा. 12:29) ");
INSERT INTO hin2017_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“यदि उस देश में रहते-रहते बहुत दिन बीत जाने पर, और अपने बेटे-पोते उत्पन्न होने पर, तुम बिगड़कर किसी वस्तु के रूप की मूर्ति खोदकर बनाओ, और इस रीति से अपने परमेश्वर यहोवा के प्रति बुराई करके उसे अप्रसन्न कर दो, ");
INSERT INTO hin2017_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","तो मैं आज आकाश और पृथ्वी को तुम्हारे विरुद्ध साक्षी करके कहता हूँ, कि जिस देश के अधिकारी होने के लिये तुम यरदन पार जाने पर हो उसमें तुम जल्दी बिल्कुल नाश हो जाओगे; और बहुत दिन रहने न पाओगे, किन्तु पूरी रीति से नष्ट हो जाओगे। ");
INSERT INTO hin2017_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","और यहोवा तुम को देश-देश के लोगों में तितर-बितर करेगा, और जिन जातियों के बीच यहोवा तुम को पहुँचाएगा उनमें तुम थोड़े ही से रह जाओगे। ");
INSERT INTO hin2017_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","और वहाँ तुम मनुष्य के बनाए हुए लकड़ी और पत्थर के देवताओं की सेवा करोगे, जो न देखते, और न सुनते, और न खाते, और न सूँघते हैं। ");
INSERT INTO hin2017_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","परन्तु वहाँ भी यदि तुम अपने परमेश्वर यहोवा को ढूँढ़ोगे, तो वह तुम को मिल जाएगा, शर्त यह है कि तुम अपने पूरे मन से और अपने सारे प्राण से उसे ढूँढ़ो। ");
INSERT INTO hin2017_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","अन्त के दिनों में जब तुम संकट में पड़ो, और ये सब विपत्तियाँ तुम पर आ पड़ें, तब तुम अपने परमेश्वर यहोवा की ओर फिरो और उसकी मानना; ");
INSERT INTO hin2017_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","क्योंकि तेरा परमेश्वर यहोवा दयालु परमेश्वर है, वह तुम को न तो छोड़ेगा और न नष्ट करेगा, और जो वाचा उसने तेरे पितरों से शपथ खाकर बाँधी है उसको नहीं भूलेगा। ");
INSERT INTO hin2017_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“जब से परमेश्वर ने मनुष्य को उत्पन्न करके पृथ्वी पर रखा तब से लेकर तू अपने उत्पन्न होने के दिन तक की बातें पूछ, और आकाश के एक छोर से दूसरे छोर तक की बातें पूछ, क्या ऐसी बड़ी बात कभी हुई या सुनने में आई है? ");
INSERT INTO hin2017_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","क्या कोई जाति कभी परमेश्वर की वाणी आग के बीच में से आती हुई सुनकर जीवित रही, जैसे कि तूने सुनी है? ");
INSERT INTO hin2017_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","फिर क्या परमेश्वर ने और किसी जाति को दूसरी जाति के बीच से निकालने को कमर बाँधकर परीक्षा, और चिन्ह, और चमत्कार, और युद्ध, और बलवन्त हाथ, और बढ़ाई हुई भुजा से ऐसे बड़े भयानक काम किए, जैसे तुम्हारे परमेश्वर यहोवा ने मिस्र में तुम्हारे देखते किए? ");
INSERT INTO hin2017_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","यह सब तुझको दिखाया गया, इसलिए कि तू जान ले कि यहोवा ही परमेश्वर है; उसको छोड़ और कोई है ही नहीं। ");
INSERT INTO hin2017_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","आकाश में से उसने तुझे अपनी वाणी सुनाई कि तुझे शिक्षा दे; और पृथ्वी पर उसने तुझे अपनी बड़ी आग दिखाई, और उसके वचन आग के बीच में से आते हुए तुझे सुनाई पड़े। ");
INSERT INTO hin2017_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","और उसने जो तेरे पितरों से प्रेम रखा, इस कारण उनके पीछे उनके वंश को चुन लिया, और प्रत्यक्ष होकर तुझे अपने बड़े सामर्थ्य के द्वारा मिस्र से इसलिए निकाल लाया, ");
INSERT INTO hin2017_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","कि तुझ से बड़ी और सामर्थी जातियों को तेरे आगे से निकालकर तुझे उनके देश में पहुँचाए, और उसे तेरा निज भागकर दे, जैसा आज के दिन दिखाई पड़ता है; ");
INSERT INTO hin2017_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","इसलिए आज जान ले, और अपने मन में सोच भी रख, कि ऊपर आकाश में और नीचे पृथ्वी पर यहोवा ही परमेश्वर है; और कोई दूसरा नहीं। (1 कुरि. 8:4) ");
INSERT INTO hin2017_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","और तू उसकी विधियों और आज्ञाओं को जो मैं आज तुझे सुनाता हूँ मानना, इसलिए कि तेरा और तेरे पीछे तेरे वंश का भी भला हो, और जो देश तेरा परमेश्वर यहोवा तुझे देता है उसमें तेरे दिन बहुत वरन् सदा के लिये हों।” ");
INSERT INTO hin2017_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","तब मूसा ने यरदन के पार पूर्व की ओर तीन नगर अलग किए, ");
INSERT INTO hin2017_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","इसलिए कि जो कोई बिना जाने और बिना पहले से बैर रखे अपने किसी भाई को मार डाले, वह उनमें से किसी नगर में भाग जाए, और भागकर जीवित रहे ");
INSERT INTO hin2017_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","अर्थात् रूबेनियों का बेसेर नगर जो जंगल के समथर देश में है, और गादियों के गिलाद का रामोत, और मनश्शेइयों के बाशान का गोलन। ");
INSERT INTO hin2017_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","फिर जो व्यवस्था मूसा ने इस्राएलियों को दी वह यह है ");
INSERT INTO hin2017_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","ये ही वे चेतावनियाँ और नियम हैं जिन्हें मूसा ने इस्राएलियों को उस समय कह सुनाया जब वे मिस्र से निकले थे, ");
INSERT INTO hin2017_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","अर्थात् यरदन के पार बेतपोर के सामने की तराई में, एमोरियों के राजा हेशबोनवासी सीहोन के देश में, जिस राजा को उन्होंने मिस्र से निकलने के बाद मारा। ");
INSERT INTO hin2017_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","और उन्होंने उसके देश को, और बाशान के राजा ओग के देश को, अपने वश में कर लिया; यरदन के पार सूर्योदय की ओर रहनेवाले एमोरियों के राजाओं के ये देश थे। ");
INSERT INTO hin2017_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","यह देश अर्नोन के नाले के छोरवाले अरोएर से लेकर सिय्योन पर्वत, जो हेर्मोन भी कहलाता है, ");
INSERT INTO hin2017_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","उस पर्वत तक का सारा देश, और पिसगा की ढलान के नीचे के अराबा के ताल तक, यरदन पार पूर्व की ओर का सारा अराबा है। ");
INSERT INTO hin2017_vpl VALUES ("DT5_1",