﻿USE sofia;
DROP TABLE IF EXISTS sofia.hin2010_vpl;
CREATE TABLE hin2010_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hin2010_vpl WRITE;
INSERT INTO hin2010_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","आदि में परमेश्वर ने आकाश और पृथ्वी को बनाया। ");
INSERT INTO hin2010_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","पृथ्वी बेडौल और सुनसान थी। धरती पर कुछ भी नहीं था। समुध पर अंधेरा छाया था और परमेश्वर की आत्मा जल के ऊपर मण्डराती थी। ");
INSERT INTO hin2010_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","तब परमेश्वर ने कहा, “उजियाला हो” और उजियाला हो गया। ");
INSERT INTO hin2010_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","परमेश्वर ने उजियाले को देखा और वह जान गए कि यह अच्छा है। तब परमेश्वर ने उजियाले को अंधियारे से अलग किया। ");
INSERT INTO hin2010_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","परमेश्वर ने उजियाले का नाम “दिन” और अंधियारे का नाम “रात” रखा। शाम हुई और तब सवेरा हुआ। यह पहला दिन था। ");
INSERT INTO hin2010_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","तब परमेश्वर ने कहा, “जल को दो भागों में अलग करने के लिए वायुमण्डल हो जाए।” ");
INSERT INTO hin2010_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","इसलिए परमेश्वर ने वायुमण्डल बनाया और जल को अलग किया। कुछ जल वायुमण्डल के ऊपर था और कुछ वायुमण्डल के नीचे। ");
INSERT INTO hin2010_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","परमेश्वर ने वायुमण्डल को “आकाश” कहा! तब शाम हुई और सवेरा हुआ। यह दूसरा दिन था। ");
INSERT INTO hin2010_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","और तब परमेश्वर ने कहा, “पृथ्वी का जल एक जगह इकट्ठा हो जिससे सूखी भूमि दिखाई दे” और ऐसा ही हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","परमेश्वर ने सूखी भूमि का नाम “पृथ्वी” रखा और जो पानी इकट्ठा हुआ था, उसे “समुद्र” का नाम दिया। परमेश्वर ने देखा कि यह अच्छा है। ");
INSERT INTO hin2010_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","तब परमेश्वर ने कहा, “पृथ्वी, घास, पौधे जो अन्न उत्पन्न करते हैं, और फलों के पेड़ उगाए। फलों के पेड़ ऐसे फल उत्पन्न करें जिनके फलों के अन्दर बीज हो और हर एक पौधा अपनी जाति का बीज बनाए। इन पौधों को पृथ्वी पर उगने दो” और ऐसा ही हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","पृथ्वी ने घास और पौधे उपजाए जो अन्न उत्पन्न करते हैं और ऐसे पेड़, पौधे उगाए जिनके फलों के अन्दर बीज होते हैं। हर एक पौधे ने अपने जाति अनुसार बीज उत्पन्न किए और परमेश्वर ने देखा कि यह अच्छा है। ");
INSERT INTO hin2010_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","तब शाम हुई और सवेरा हुआ। यह तीसरा दिन था। ");
INSERT INTO hin2010_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","तब परमेश्वर ने कहा, “आकाश में ज्योतियाँ होने दो। यह ज्योतियाँ दिन को रात से अलग करेंगी। यह ज्योतियाँ एक विशेष चिन्ह के रूप में प्रयोग की जाएगी जो यह बताएगी कि विशेष सभाएं कब शुरू की जाएं और यह दिनों तथा वर्षों के समयों को निश्चित करेंगी। ");
INSERT INTO hin2010_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","पृथ्वी पर प्रकाश देने के लिए आकाश में ज्योतियाँ ठहरें” और ऐसा ही हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","तब परमेश्वर ने दो बड़ी ज्योतियाँ बनाई। परमेश्वर ने उन में से बड़ी ज्योति को दिन पर राज करने के लिए बनाया और छोटी को रात पर राज करने के लिए बनाया। परमेश्वर ने तारे भी बनाए। ");
INSERT INTO hin2010_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","परमेश्वर ने इन ज्योत्तियों को आकाश में इसलिए रखा कि वेह पृथ्वी पर पर चमकें। ");
INSERT INTO hin2010_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","परमेश्वर ने इन ज्योतियों को आकाश में इसलिए रखा कि वह दिन तथा रात पर राज करें। इन ज्योतियों ने उजियाले को अंधकार से अलग किया और परमेश्वर ने देखा कि यह अच्छा है। ");
INSERT INTO hin2010_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","तब शाम हुई और सवेरा हुआ। यह चौथा दिन था। ");
INSERT INTO hin2010_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","तब परमेश्वर ने कहा, “जल, अनेक जलचरों से भर जाए और पक्षी पृथ्वी के ऊपर वायुमण्डल में उड़ें।” ");
INSERT INTO hin2010_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","इसलिए परमेश्वर ने समुद्र में बहुत बड़े—बड़े जलजन्तु बनाए। परमेश्वर ने समुद्र में विचरण करने वाले प्राणियों को बनाया। समुद्र में भिन्न—भिन्न जाति के जलजन्तु हैं। परमेश्वर ने इन सब की सृष्टि की। परमेश्वर ने हर तरह के पक्षी भी बनाए जो आकाश में उड़ते हैं। परमेश्वर ने देखा कि यह अच्छा है। ");
INSERT INTO hin2010_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","परमेश्वर ने इन जानवरों को आशीष दी, और कहा, “जाओ और बहुत से बच्चे उत्पन्न करो और समुद्र के जल को भर दो। पक्षी भी बहुत बढ़ जाए।” ");
INSERT INTO hin2010_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","तब शाम हुई और सवेरा हुआ। यह पाँचवाँ दिन था। ");
INSERT INTO hin2010_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","तब परमेश्वर ने कहा, “पृथ्वी हर एक जाति के जीवजन्तु उत्पन्न करे। बहुत से भिन्न जाति के जानवर हों। हर जाति के बड़े जानवर और छोटे रेंगनेवाले जानवर हो और यह जानवर अपने जाति के अनुसार और जानवर बनाए” और यही सब हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","तो, परमेश्वर ने हर जाति के जानवरों को बनाया। परमेश्वर ने जंगली जानवर, पालतू जानवर, और सभी छोटे रेंगनेवाले जीव बनाए और परमेश्वर ने देखा कि यह अच्छा है। ");
INSERT INTO hin2010_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","तब परमेश्वर ने कहा, “अब हम मनुष्य बनाएं। हम मनुष्य को अपने स्वरूप जैसा बनाएगे। मनुष्य हमारी तरह होगा। अह समुद्र की सारी मछलियों पर और आकाश के पक्षियों पर राज करेगा। वह पृथ्वी के सभी बड़े जानवरों और छोटे रेंगनेवाले जीवों पर राज करेगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","इसलिए परमेश्वर ने मनुष्य को अपने स्वरूप में बनाया। परमेश्वर ने मनुष्य को अपने ही स्वरुप में सृजा। परमेश्वर ने उन्हें नर और नारी बनाया। ");
INSERT INTO hin2010_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","परमेश्वर ने उन्हें आशीष दी। परमेश्वर ने उनसे कहा, “तुम्हारे बहुत सी संताने हों। पृथ्वी को भर दो और उस पर राज करो। समुद्र की मछलियों और आकाश के पक्षियों पर राज करो। हर एक पृथ्वी के जीवजन्तु पर राज करो।” ");
INSERT INTO hin2010_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","परमेश्वर ने कहा, “देखो, मैंने तुम लोगों को सभी बीज वाले पेड़ पौधे और सारे फलदार पेड़ दिए हैं। ये अन्न तथा फल तुम्हारा भोजन होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","मैं प्रत्येक हरे पेड़ पौधा जानवरों के लिए दे रहा हूँ। ये हरे पेड़—पौधे उनका भोजन होगा। पृथ्वी का हर एक जानवर, आकाश का हर एक पक्षी और पृथ्वी पर रेंगने वाले सभी जीवजन्तु इस भोजन को खांएगे।” ये सभी बातें हुईं। ");
INSERT INTO hin2010_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","परमेश्वर ने अपने द्वारा बनाई हर चीज़ को देखा और परमेश्वर ने देखा कि हर चीज़ बहुत अच्छी है। शाम हुई और तब सवेरा हुआ। यह छठवाँ दिन था। ");
INSERT INTO hin2010_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","इस तरह पृथ्वी, आकाश और उसकी प्रत्येक वस्तु की रचना पूरी हुई। ");
INSERT INTO hin2010_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","परमेश्वर ने अपने किए जा रहे काम को पूरा कर लिया। अतः सातवें दिन परमेश्वर ने अपने काम से विश्राम किया। ");
INSERT INTO hin2010_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","परमेश्वर ने सातवें दिन को आशीषित किया और उसे पवित्र दिन बना दिया। परमेश्वर ने उस दिन को पवित्र दिन इसलिए बनाया कि संसार को बनाते समय जो काम वह कर रहा था उन सभी कार्यों से उसने उस दिन विश्राम किया। ");
INSERT INTO hin2010_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","यह पृथ्वी और आकाश का इतिहास है। यह कथा उन चीज़ों की है, जो परमेश्वर द्वारा पृथ्वी और आकाश बनाते समय, घटित हुई। ");
INSERT INTO hin2010_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","तब पृथ्वी पर कोई पेड़ पौधा नहीं था और खेतों में कुछ भी नहीं उग रहा था, क्योंकि यहोवा ने तब तक पृथ्वी पर वर्षा नहीं भेजी थी तथा पेड़ पौधों की देख—भाल करने वाला कोई व्यक्ति भी नहीं था। ");
INSERT INTO hin2010_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","परन्तु कोहरा पृथ्वी से उठता था और जल सारी पृथ्वी को सींचता था। ");
INSERT INTO hin2010_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","तब यहोवा परमेश्वर ने पृथ्वी से धूल उठाई और मनुष्य को बनाया। यहोवा ने मनुष्य की नाक में जीवन की साँस फूँकी और मनुष्य एक जीवित प्राणी बन गया। ");
INSERT INTO hin2010_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","तब यहोवा परमेश्वर ने पूर्व में अदन नामक जगह में एक बाग लगाया। यहोवा परमेश्वर ने अपने बनाए मनुष्य को इसी बाग में रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","यहोवा परमेश्वर ने हर एक सुन्दर पेड़ और भोजन के लिए सभी अच्छे पेड़ों को उस बाग में उगाया। बाग के बीच में परमेश्वर ने जीवन के पेड़ को रखा और उस पेड़ को भी रखा जो अच्छे और बुरे की जानकारी देता है। ");
INSERT INTO hin2010_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","अदन से होकर एक नदी बहती थी और वह बाग़ को पानी देती थी। वह नदी आगे जाकर चार छोटी नदियाँ बन गई। ");
INSERT INTO hin2010_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","पहली नदी का नाम पीशोन है। यह नदी हवीला प्रदेश के चारों ओर बहती है। ");
INSERT INTO hin2010_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(उस प्रदेश में सोना है और वह सोना अच्छा है। मोती और गोमेदक रत्न उस प्रदेश में हैं।) ");
INSERT INTO hin2010_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","दूसरी नदी का नाम गीहोन है जो सारे कूश प्रदेश के चारों ओर बहती है। ");
INSERT INTO hin2010_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","तीसरी नदी का नाम दजला है। यह नदी अश्शूर के पूर्व में बहती है। चौथी नदी फरात है। ");
INSERT INTO hin2010_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","यहोवा ने मनुष्य को अदन के बाग में रखा। मनुष्य का काम पेड़—पौधे लगाना और बाग की देख—भाल करना था। ");
INSERT INTO hin2010_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","यहोवा परमेश्वर ने मनुष्य को आज्ञा दी, “तुम बग़ीचे के किसी भी पेड़ से फल खा सकते हो। ");
INSERT INTO hin2010_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","लेकिन तुम अच्छे और बुरे की जानकारी देने वाले पेड़ का फल नहीं खा सकते। यदि तुमने उस पेड़ का फल खा लिया तो तुम मर जाओगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","तब यहोवा परमेश्वर ने कहा, “मैं समझता हूँ कि मनुष्य का अकेला रहना ठीक नहीं है। मैं उसके लिए एक सहायक बनाऊँगा जो उसके लिए उपयुक्त होगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","यहोवा ने पृथ्वी के हर एक जानवर और आकाश के हर एक पक्षी को भूमि की मिट्टी से बनाया। यहोवा इन सभी जीवों को मनुष्य के सामने लाया और मनुष्य ने हर एक का नाम रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","मनुष्य ने पालतू जानवरों, आकाश के सभी पक्षियों और जंगल के सभी जानवरों का नाम रखा। मनुष्य ने अनेक जानवर और पक्षी देखे लेकिन मनुष्य कोई ऐसा सहायक नहीं पा सका जो उसके योग्य हो। ");
INSERT INTO hin2010_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","अतः यहोवा परमेश्वर ने मनुष्य को गहरी नींद में सुला दिया और जब वह सो रहा था, यहोवा परमेश्वर ने मनुष्य के शरीर से एक प्सली निकाल ली। तब यहोवा ने मनुष्य की उस त्वचा को बन्द कर दिया जहाँ से उसने पसली निकाली थी। ");
INSERT INTO hin2010_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","यहोवा परमेश्वर ने मनुष्य की पसली से स्त्री की रचना की। तब यहोवा परमेश्वर स्त्री को मनुष्य के पास लाए। ");
INSERT INTO hin2010_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","और मनुष्य से कहा, “अन्तत! हमारे समाने एक व्यक्ति। इसकी हड्डियाँ मेरी हड्डियों से आई इसका शरीर मेरे शरीर से आया। क्योंकि यह मनुष्य से निकाली गई, इसलिए मैं इसे स्त्री कहूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","इसलिए पुरुष अपने माता—पिता को छोड़कर अपनी पत्नी के साथ रहेगा और वे दोनों एक तन हो जाएगे। ");
INSERT INTO hin2010_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","मनुष्य और उसकी पत्नी बाग में नंगे थे, परन्तु वे लजाते नहीं थे। ");
INSERT INTO hin2010_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","यहोवा द्वारा बनाए गए सभी जानवरों में सबसे अधिक चतुर साँप था। (वह स्त्री को धोखा देना चाहता था।) साँप ने कहा, “हे स्त्री क्या परमेश्वर ने सच—मुच तुमसे कहा हऐ कि तुम बाग के किसी पेड़ से फल ना खाना?” ");
INSERT INTO hin2010_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","स्त्री न कहा, “नहीं परमेश्वर ने यह नहीं कहा। हम बाग़ के पेड़ों से फल खा सकते हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","लेकिन एक पेड़ है जिसके फल हम लोग नहीं खा सकते हैं। परमेश्वर ने हम लोगों से कहा, ‘बाग के बीच के पेड़ के फल तुम नहीं खा सकते, तुम उसे छूना भी नहीं, नहीं तो मर जाओगे।’” ");
INSERT INTO hin2010_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","लेकिन साँप ने स्त्री से कहा, “तुम मरोगी नहीं। ");
INSERT INTO hin2010_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","परमेश्वर जानता है कि यदि तुम लोग उस पेड़ से फल खाओगे तो अच्छे और बुरे के बारे में जान जाओगे और तब तुम परमेश्वर के समान हो जाओगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","स्त्री ने देखा कि पेड़ सुन्दर है। उसने देखा कि फल खाने के लिए अच्छा है और पेड़ उसे बुद्धिमान बनाएगा। तब स्त्री ने पेड़ से फल लिया और उसे खाया। उसका पती भी उसके साथ था इसलिए उसने कुछ फल उसे दिया और उसने उसे खाया। ");
INSERT INTO hin2010_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","तब पुरुष और स्त्री दोनों बदल गए। उनकी आँखे खुल गई और उन्होंने वस्तुओं को भिन्न दृष्टि से देखा। उन्होंने देखा कि उनके कपड़े नहीं है, वे नंगे है। इसलिए उन्होंने कुछ अंजीर के पत्ते लेकर उन्हें जोड़ा और कपड़ो के स्थान पर अपने लिए पहना। ");
INSERT INTO hin2010_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","तब पुरुष और स्त्री ने दिन के ठण्डे समय में यहोवा परमेश्वर के आने की आवाज बाग में सुनी। वे बाग मे पेड़ों के बीच में छिप गए। ");
INSERT INTO hin2010_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","यहोवा परमेश्वर ने पुकार कर पुरुष से पूछा, “तुम कहाँ हो?” ");
INSERT INTO hin2010_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","पुरुष ने कहा, “मैंने बाग में तेरे आने की आवाज सुनी और मैं डर गया। मैं नंगा था, इसलिए छिप गया।” ");
INSERT INTO hin2010_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","यहोवा परमेश्वर ने पुरुष से पूछा, “तुम्हें किसने बताया कि तुम नंगे हो? तुम किस कारण से शरमाए? क्या तुमने उस विशेष पेड़ का फल खाया जिसे मैंने तुम्हें न खाने की आज्ञा दी थी?” ");
INSERT INTO hin2010_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","पुरुष ने कहा, “तूने जो स्त्री मेरे लिए बनाई उसने उस पेड़ से मुझे फल दिए, और मैंने उसे खाया।” ");
INSERT INTO hin2010_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","तब यहोवा परमेश्वर ने स्त्री से कहा, “यह तुमने क्या किया?” स्त्री ने कहा, “साँप ने मुझे धोखा दिया। उसने मुझे बेवकूफ बनाया और मैंने फल खा लिया।” ");
INSERT INTO hin2010_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","तब यहोवा परमेश्वर ने साँप से कहा, “तुमने यह बहुत बुरी बात की। इसलिए तुम्हारा बुरा हो होगा। अन्य जानवरों की अपेक्षा तुम्हारा बहुत बुरा होगा। तुम अपने पेट के बल रेंगने को मजबूर होगे। और धूल चाटने को विवश होगे जीवन के सभी दिनों में। ");
INSERT INTO hin2010_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","मैं तुम्हें और स्त्री को एक दूसरे का दुश्मन बनाऊँगा। तुम्हारे बच्चे और इसके बच्चे आपस में दुश्मन होंगे। तुम इसके बच्चे के पैर में डसोगे और वह तुम्हारा सिर कुचल देगी।” ");
INSERT INTO hin2010_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","तब यहोवा परमेश्वर ने स्त्री से कहा, “मैं तेरे गर्भावस्था में तुझे बहुत दुःखी करूँगा और जब तू बच्चा जनेगी तब तुझे बहुत पीड़ा होगी। तेरी चाहत तेरे पति के लिए होगी किन्तु वह तुझ पर प्रभुता करेगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","तब यहोवा परमेश्वर ने मनुष्य से कहा, “मैंने आज्ञा दी थी कि तुम विशेष पेड़ का फल न खाना। किन्तु तुमने अपनी पत्नी की बाते सुनीं और तुमने उस पेड़ का फल खाया। इसलिए मैं तुम्हारे कारण इस भूमि को शाप देता हूँ अपने जीवन के पूरे काल तक उस भोजन के लिए जो धरती देती है। तुम्हें कठिन मेहनत करनी पड़ेगी। ");
INSERT INTO hin2010_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","तुम उन पेड़ पौधों को खाओगे जो खेतों में उगते है। किन्तु भूमि तुम्हारे लिए काँटे और खर—पतवार पैदा करेगी। ");
INSERT INTO hin2010_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","तुम अपने भोजन के लिए कठिन परिश्रम करोगे। तुम तब तक परिश्रम करोगे जब तक माथे पर पसीना ना आ जाए। तुम तब तक कठिन मेहनत करोगे जब तक तुम्हारी मृत्यु न आ जाए। उस समय तुम दुबारा मिट्टी बन जाओगे। जब मैंने तुमको बनाया था, तब तुम्हें मिट्टी से बनाया था और जब तुम मरोगे तब तुम उसी मिट्टी में पुनः मिल जाओगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","आदम ने अपनी पत्नी का नाम हब्बा रखा, क्योंकि सारे मनुष्यों की वह आदिमाता थी। ");
INSERT INTO hin2010_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","यहोवा परमेश्वर ने मनुष्य और उसकी पत्नी के लिए जानवरों के चमड़ों से पोशाक बनाया। तब यहोवा ने ये पोशाक उन्हें दी। ");
INSERT INTO hin2010_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","यहोवा परमेश्वर ने कहा, “देखो, पुरुष हमारे जैसा हो गया है। पुरुष अच्छाई और बुरा जानता है और अब पुरुष जीवन के पेड़ से भी फल ले सकता है। अगर पुरुष उस फल को खायेगा तो सदा ही जीवित रहेगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","तब यहोवा परमेश्वर ने पुरुष को अदन के बाग छोड़ने के लिए मजबूर किया। जिस मिट्टी से आदम बना था उस पृथ्वी पर आदम को कड़ी मेहनत करनी पड़ी। ");
INSERT INTO hin2010_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","परमेश्वर ने आदम को बाग से बाहर निकाल दिया। तब परमेश्वर ने करूब (स्वर्गदूतों) को बाग के फाटक की रखवाली के लिए रखा। परमेश्वर ने वहाँ एक आग की तलवार भी रख दी। यह तलवार जीवन के पेड़ के रास्ते की रखवाली करती हुई चारों ओर चमकती थी। ");
INSERT INTO hin2010_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","आदम और उसकी पत्नी हब्बा के बीच शारीरिक सम्बन्ध हुए और हब्बा ने एक बच्चे को जन्म दिया। बच्चे का नाम कैन रखा गया। हब्बा ने कहा, “यहोवा की मदद से मैंने एक मनुष्य पाया है।” ");
INSERT INTO hin2010_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","इसके बाद हब्बा ने दूसरे बच्चे को जन्म दिया। यह बच्चा कैन का भाई हाबिल था। हाबिल गड़ेंरिया बना। कैन किसान बना। ");
INSERT INTO hin2010_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","4","फसल के समय कैन एक भेंट यहोवा के पास लाया। जो अन्न कैन ने अपनी ज़मीन में उपजाया था उसमें से थोड़ा अन्न वह लाया। परन्तु हाबिल अपने जानवरों के झुण्ड में से कुछ जानवर लाया। हाबिल अपनी सबसे अच्छी भेड़ का सबसे अच्छा हिस्सा लाया। यहोवा ने हाबिल तथा उसकी भेंट को स्वीकार किया। ");
INSERT INTO hin2010_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","परन्तु यहोवा ने कैन तथा उसके द्वारा लाई भेंट को स्वीकार नहीं किया इस कारण कैन क्रोधित हो गया। वह बहुत व्याकुल और निराश हो गया। ");
INSERT INTO hin2010_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","यहोवा ने कैन से पूछा, “तुम क्रोधित क्यों हो? तुम्हारा चेहरा उतरा हुआ क्यों दिखाई पड़ता है? ");
INSERT INTO hin2010_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","अगर तुम अच्छे काम करोगे तो तुम मेरी दृष्टि में ठीक रहोगे। तब मैं तुम्हें अपनाऊँगा। लेकिन अगर तुम बुरे काम करोगे तो वह पाप तुम्हारे जीवन में रहेगा। तुम्हारे पाप तुम्हें अपने वश में रखना चाहेंगे लेकिन तुम को अपने पाप को अपने बस में रखना होगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","कैन ने अपने भाई हाबिल से कहा, “आओ हम मैदान में चलें।” इसलिए कैन और हाबिल मैदान में गए। तब कैन ने अपने भाई पर हमल किया और उसे मार डाला। ");
INSERT INTO hin2010_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","बाद में यहोवा ने कैन से पूछा, “तुम्हारा भाई हाबिल कहाँ है?” कैन ने जवाब दिया, “मैं नहीं जानता। क्या यह मेरा काम है कि मैं अपने भाई की निगरानी और देख भाल करूँ?” ");
INSERT INTO hin2010_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","तब यहोवा ने कहा, “तुमने यह क्या किया? तुम्हारे भाई का खून जमीन से बोल रहा है कि क्या हो गया है? ");
INSERT INTO hin2010_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","तुमने अपने भाई की हत्या की है, पृथ्वी तुम्हारे हाथों से उसका खून लेने के लिए खुल गयी है। इसलिए अब मैं उस जमीन को बुरा करने वाली चीजों को पैदा करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","बीते समय में तुमने फ़सलें लगाई और वे अच्छी उगीं। लेकिन अब तुम फसल बोओगे और जमीन तुम्हारी फसल अच्छी होने में मदद नहीं करेगी। तुम्हें पृथ्वी पर घर नहीं मिलेगा। तुम जगह जगह भटकोगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","तब कैन ने कहा, “यह दण्ड इतना अधिक है कि मैं सह नहीं सकता। ");
INSERT INTO hin2010_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","मेरी ओर देख। तूने मुझे जमीन में फसल के काम को छोड़ने के लिए मजबूर कर दिया है और मैं अब तेरे करीब भी नहीं रहूँगा। मेरा कोई घर नहीं होगा और पृथ्वी पर से मैं नष्ट हो जाऊँगा और यदि कोई मनुष्य मुझे पाएगा तो मार डालेगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","तब यहोवा ने कैन से कहा, “मैं यह नहीं होने दूँगा। यदि कोई तुमको मारेगा तो मैं उस आदमी को बहुत कठोर दण्ड दूँगा।” तब यहोवा ने कैन पर एक चिन्ह बनाया। यह चिन्ह वह बताता था कि कैन को कोई न मारे। ");
INSERT INTO hin2010_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","तब कैन यहोवा को छोड़कर चला गया। कैन नोद देश में रहने लगा। ");
INSERT INTO hin2010_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","कैन ने अपनी पत्नी के साथ शारीरिक सम्बन्ध किया। वह गर्भवती हुई। उसने हनोक नाम बच्चे को जन्म दिया। कैन ने एक शहर बसाया और उसका नाम अपने अपने पुत्र के नाम पर हनोक ही रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोक से ईराद उत्पन्न हुआ, ईराद से महुयाएल उत्पन्न हुआ, महूयाएल से मतूशाएल उत्पन्न हुआ और मतूशाएल से लेमेक उत्पन्न हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लेमेक ने दो स्त्रियों से विवाह किया। एक पत्नी का नाम आदा और दूसरी का नाम सिल्ला था। ");
INSERT INTO hin2010_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदा ने याबाल को जन्म दिया। याबाल उन लोगों का पिता था जो तम्बूओं में रहते थे तथा पशुओं क पालन करके जीवन निर्वाह करते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","आदा का दूसरा पुत्र यूबाल भी था। यूबाल, याबाल का भाई था। यूबाल उन लोगों का पिता था जो वीणा और बाँसुरी बजाते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","सिल्ला ने तूबलकैन को जन्म दिया। तूबलकैन उन लोगों का पिता था जो काँसे और लोहे का काम करते थे। तूबलकैन की बहन का नाम नामा था। ");
INSERT INTO hin2010_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","लेमेक ने अपनी पत्नियों से कहा: “ऐ आदा और सिल्ला मेरी बात सुनो। लेमेक की पत्नियों जो बाते मैं कहता हूँ, सुनो। एक पुरुष ने मुझे चोट पहुँचाई, मैंने उसे मार डाला। एक जवान ने मुझे चोट दी, इसलिए मैंने उसे मार डाला। ");
INSERT INTO hin2010_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","कैन की हत्या का दण्ड बहुत भारी था। इसलिए मेरी हत्या का दण्ड भी उससे बहुत, बहुत भारी होगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","आदम ने हव्वा के साथ फिर शारीरिक सम्बन्ध किया और हव्वा ने एक और बच्चे को जन्म दिया। उन्होंने इस बच्चे का नाम शेत रखा। हव्वा ने कहा, “यहोवा ने मुझे दूसरा पुत्र दिया है। कैन ने हाबिल को मार डाला किन्तु अब शेत मेरे पास है।” ");
INSERT INTO hin2010_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","शेत का भी एक पुत्र था। इसका नाम एनोश था। उस समय लोग यहोवा पर विश्वास करने लगे। ");
INSERT INTO hin2010_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","यह अध्याय आदम के परिवार के बारे में है। परमेश्वर ने मनुष्य को अपने स्वरूप में बनाया। ");
INSERT INTO hin2010_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","परमेश्वर ने एक पुरुष और एक स्त्री को बनाया। जिस दिन परमेश्वर ने उन्हें बनाया, आशीष दी एवं उसका नाम “आदम” रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","जब आदम एक सौ तीस वर्ष का हो गया तब वह एक और बच्चे का पिता हुआ। यह पुत्र ठीक आदम सा दिखाई देता था। आदम ने पुत्र का नाम शेत रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","शेत के जन्म के बाद आदम आठ सौ वर्ष जीवित रहा। इन दिनों में आदम के अन्य पुत्र और पुत्रियाँ पैदा हुई। ");
INSERT INTO hin2010_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","इस तरह आदम पूरे नौ सौ तीस वर्ष तक जीवित रहा, तब वह मरा। ");
INSERT INTO hin2010_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","जब शेत एक सौ पाँच वर्ष का हो गया तब उसे एनोश नाम का पुत्र पैदा हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","एनोश के जन्म के बाद शेत आठ सौ सात वर्ष जीवित रहा। इसी शेत के अन्य पुत्र—पुत्रियाँ पैदा हुई। ");
INSERT INTO hin2010_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","इस तरह शेत पूरे नौ सौ बारह वर्ष जीवित रहा, तब वह मरा। ");
INSERT INTO hin2010_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","एनोश जब नब्बे वर्ष का हुआ, उसे केनान नाम का पुत्र पैदा हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","केनान के जन्म के बाद एनोश आठ सौ फन्द्रह वर्ष जीवित रहा। इन दिनों इसके अन्य पुत्र और पुत्रियाँ पैदा हुई। ");
INSERT INTO hin2010_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","इस तरह एनोश पूरे नौ सौ पाँच वर्ष जीवित रहा, तब वह मरा। ");
INSERT INTO hin2010_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","जब केनान सत्तर वर्ष का हुआ, उसे महललेल नाम का पुत्र पैदा हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","महललेल के जन्म के बाद केनान आठ सौ चालीस वर्ष जीवित रहा। इन दिनों केनान के दूसरे पुत्र और पुत्रियाँ पैदा हुई। ");
INSERT INTO hin2010_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","इस तरह केनान पूरे नौ सौ दस वर्ष जीवित रहा, तब वह मरा। ");
INSERT INTO hin2010_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","जब महललेल पैंसठ वर्ष का हुआ, उसे येरेद नाम का पुत्र पैदा हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","येरेद के जन्म के बाद महललेल आठ सौ तीस वर्ष जीवित रहा। इन दिनों में उसे दूसरे पुत्र और पुत्रियाँ पैदा हुई। ");
INSERT INTO hin2010_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","इस तरह महललेल पूरे आठ सौ पंचानवे वर्ष जीवित रहा। तब वह मरा। ");
INSERT INTO hin2010_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","जब येरेद एक सौ बासठ वर्ष का हुआ तो उसे हनोक नाम का पुत्र पैदा हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","हनोक के जन्म के बाद येरेद आठ सौ वर्ष जीवित रहा। इन दिनों में उसे दूसरे पुत्र और पुत्रियाँ पैदा हुई। ");
INSERT INTO hin2010_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","इस तरह येरेद पूरे नौ सौ बासठ वर्ष जीवित रहा, तब वह मरा। ");
INSERT INTO hin2010_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","जब हनोक पैंसठ वर्ष का हुआ, उसे मतूशेलह नाम का पुत्र पैदा हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","मतूशेलह के जन्म के बाद हनोक परमेश्वर के साथ तीन सौ वर्ष रहा। इन दिनों उसके दूसरे पुत्र पुत्रियाँ पैदा हुई। ");
INSERT INTO hin2010_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","इस तरह हनोक पूरे ती सौ पैंसठ वर्ष जीवित रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","एक दिन हनोक परमेश्वर के साथ चल रहा था और गायब हो गया क्योंकि परमेश्वर ने उसे उठा लिया। ");
INSERT INTO hin2010_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","जब मतूशेलह एक सौ सत्तासी वर्ष का हुआ, उसे लेमेक नाम का पुत्र पैदा हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","लेमेक के जन्म के बाद मतूशेलह सात सौ बयासी वर्ष जीवित रहा। इन दिनों उसे दूसरे पुत्र और पुत्रियाँ पैदा हुई। ");
INSERT INTO hin2010_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","इस तरह मतूशेलह पूरे नौ सौ उनहत्तर वर्ष जीवित रहा, तब यह मरा। ");
INSERT INTO hin2010_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","जब लेमेक एक सौ बयासी वर्ष का हुआ, वह एक पुत्र का पिता बना। ");
INSERT INTO hin2010_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","लेमेक के पुत्र का नाम नूह रखा। लेमेक ने कहा, “हम किसान लोग बहुत कड़ो मेहनत करते हैं क्यैंकि परमेश्वर ने भूमि को शाप दे दिया है। किन्तु नूह हम लोगों को विश्राम देगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","नूह के जन्म के बाद, लेमेक पाँच सौ पंचानवे वर्ष जीवित रहा। इन दिनों उसे दूसरे पुत्र और पुत्रियाँ पैदा हुई। ");
INSERT INTO hin2010_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","इस तरह लेमेक पूरे सात सौ सतहत्तर वर्ष जीवित रहा, तब वह मरा। ");
INSERT INTO hin2010_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","जब नूह पाँच सौ वर्ष का हुआ, उसके शेम, हाम, और येपेत नाम के पुत्र हुए। ");
INSERT INTO hin2010_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","4","पृथ्वी पर मनुष्यों की संख्या बढ़ती रही। इन लोगों के लड़कियाँ पैदा हुई। परमेश्वर के पुत्रों ने देखा कि ये लड़कियाँ सुन्दर हैं। इसलिए परमेश्वर के पुत्रों ने अपनी इच्छा के अनुसार जिससे चाहा उसी से विवाह किया। इन स्त्रियों ने बच्चों को जन्म दिया। तब यहोवा ने कहा, “मनुष्य शरीर ही है। मैं सदा के लिए इनसे अपनी आत्मा को परेशान नहीं होने दूँगा। मैं उन्हें एक सौ बीस वर्ष का जीवन दूँगा।” इन दिनों और बाद में भी नेफिलिम लोग उस देश में रहते थे। ये प्रसिद्ध लोग थे। ये लोग प्राचीन काल से बहुत वीर थे। ");
INSERT INTO hin2010_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","यहोवा ने देखा कि पृथ्वी पर मनुष्य बहुत अधिक पापी हैं। यहोवा ने देखा कि मनुष्य लगातार बुरी बातें ही सोचता है। ");
INSERT INTO hin2010_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","यहोवा को इस बात का दुःख हुआ, कि मैंने पृथ्वी पर मनुष्यों को क्यों बनाया? यहोवा इस बात से बहुत दुःखी हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","इसलिए यहोवा ने कहा, “मैं अपनी बनाई पृथ्वी के सारे लोगों को खतम कर दूँगा। मैं हर एक व्यक्ति, जानवर और पृथ्वी पर रेंगने वाले हर एक जीवजन्तु को खतम करूँगा। मैं आकाश के पक्षियों को भी खतम करुँगा। क्यों? क्योंकि मैं इस बात से दुःखी हूँ कि मैंने इन सभी चीजों को बनाया।” ");
INSERT INTO hin2010_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","लेकिन पृथ्वी पर यहोवा को खुश करने वाला एक व्यक्ति था—नूह। ");
INSERT INTO hin2010_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","यह कहानी नूह के परिवार की है। अपने पूरे जीवन में नूह ने सदैव परमेश्वर का अनुसरण किया। ");
INSERT INTO hin2010_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","नूह के तीन पुत्र थे, शेम, हाम और येपेत। ");
INSERT INTO hin2010_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","परमेश्वर ने पृथ्वी पर दृष्टि की और उसने देखा कि पृथ्वी को लोगों ने बर्बाद कर दिया है। हर जगह हिंसा पैली हुई है। लोग पापी और भ्रष्ट हो गए है, और उन्होंने पृथ्वी पर अपना जीवन बर्बाद कर दिया है। ");
INSERT INTO hin2010_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","इसलिए परमेश्वर ने नूह से कहा, “सारे लोगों ने पृथ्वी को क्रोध और हिंसा से भर दिया है। इसलिए मैं सभी जीवित प्राणियों को नष्ट करूँगा। मैं उनकी पृथ्वी से हटाऊँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","गोपेर की लकड़ी का उपयोग करो और अपने लिए एक जहाज बनाओ। जहाज में कमरे बनाओ और उसे राल से भीतर और बाहर पोत दो। ");
INSERT INTO hin2010_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","“जो जहाज मैं बनवाना चाहता हूँ उसका नाप तीन सौ हाथ लम्बाई, पचास हाथ चौड़ाई, तीस हाथ ऊँचाई है। ");
INSERT INTO hin2010_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","जहाज के लिए छत से करीब एक हाथ नीचे एक खिड़की बनाओ जहाज की बगल में एक दरवाजा बनाओ। जहाज में तीन मंजिलें बनाओ। ऊपरी मंजिल, बीच की मंजिल और नीचे की मंजिल।” ");
INSERT INTO hin2010_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“तुम्हें जो बता रहा हूँ उसे समझो। मैं पृथ्वी पर बड़ा भारी जल का बाढ़ लाऊँगा। आकाश के नीचे सभी जीवों को मैं नष्ट कर दूँगा। पृथ्वी के सभी जीव मर जायेंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","किन्तु मैं तुमको बचाऊँगा। तब मैं तुम से एक विशेष वाचा करूँगा। तुम तुम्हारे पुत्र तुम्हारे पुत्र तुम्हारी पत्नी तुम्हारे पुत्रों की पत्नियाँ सभी जहाज़ में सवार होगे। ");
INSERT INTO hin2010_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","साथ ही साथ पृथ्वी पर जीवित प्राणियों के जोड़े भी तुम्हें लाने होंगे। हर एक के नर और मादा को जहाज़ में लाओ। अपने साथ उनको जीवित रखो। ");
INSERT INTO hin2010_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","पृथ्वी की रह तरह की चिड़ियों के जोड़ों को भी खोजो। पृथ्वी पर रेंगने वाले हर एक जीव के जोड़ों को भी खोजो। पृथ्वी के हर प्रकार के जानवरों के नर और मादा तुम्हारे साथ होंगे। जहाज़ पर उन्हें जीवित रखो। ");
INSERT INTO hin2010_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","पृथ्वी के सभी प्रकार के भोजन भी जहाज़ पर लाओ। यह भोजन तुम्हारे लिए तथा जानवरों के लिए होगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","नूह ने यह सब कुछ किया। नूह ने परमेश्वर की सारी आज्ञाओं का पालन किया। ");
INSERT INTO hin2010_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","तब यहोवा ने नूह से कहा, “मैंने देखा है कि इस समय के पापी लोगों में तुम्हीं एक अच्छे व्यक्ति हो। इसलिए तुम अपने परिवार को इकट्ठा करो और तुम सभी जहाज में चले जाओ। ");
INSERT INTO hin2010_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","हर एक शुद्ध जानवर के सात जोड़े, (सात नर तथा सात मादा) साथ में ले लो और पृथ्वी के दूसरे अशुद्ध जानवरों के एक—एक जोड़े (एक नर और एक मादा) लाओ। इन सभी जानवरों को अपने साथ जहाज़ में ले जाओ। ");
INSERT INTO hin2010_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","हवा में उड़ने वाले सभी पक्षियों के सात जोड़े (सात नर और सात मादा) लाओ। इससे ये सभी जानवर पृथ्वी पर जीवित रहेंगे, जब दूसरे जानवर नष्ट हो जायेंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","अब से सातवें दिन मैं पृथ्वी पर बहुत भारी वर्षा भेजूँगा। यह वर्षा चालीस दिन और चालीस रात होती रहेगी। पृथ्वी के सभी जीवित प्राणी नष्ट हो जायेंगे। मेरी बनाई सभी चीज़े खतम हो जायेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","नूह ने उन सभी बातों को माना जो यहोवा ने आज्ञा दी। ");
INSERT INTO hin2010_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","वर्षा आने के समय नूह छः सौ वर्ष का था। ");
INSERT INTO hin2010_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","नूह और उसका परिवार बाढ़ के जल से बचने के लिए जहाज़ में चला गया। नूह की पत्नी, उसके पुत्र और उनकी पत्नियाँ उसके साथ थीं। ");
INSERT INTO hin2010_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","पृथ्वी के सभी शुद्ध जानवर एवं अन्य जानवर, पक्षी और पृथ्वी पर रेंगने वाले सभी जीव ");
INSERT INTO hin2010_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","नूह के साथ जहाज में चढ़े। इन जानवरों के नर और मादा जोड़े परमेश्वर की आज्ञा के अनुसार जहाज में चढ़े। ");
INSERT INTO hin2010_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","सात दिन बद बाढ़ प्रारम्भ हुई। धरती पर वर्षा होने लगी। ");
INSERT INTO hin2010_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","13","दूसरे महीने के सातवें दिन, जब नूह छः सौ वर्ष का था, जमीन के नीचे के सभी सोते खुल पड़े और ज़मीन से पानी बहना शुरु हो गया। उसी दिन पृथ्वी पर भारी वर्षा होने लगी। ऐसा लगा मानो आकाश की खिड़कियाँ खुल पड़ी हों। चालीस दिन और चालीस रात तक वर्षा पृथ्वी पर होती रही। ठीक उसी दिन नूह, उसकी पत्नी, उसके पुत्र शेम, हाम और येपेत और उनकी पत्नियाँ जहाज़ पर चढ़ें। ");
INSERT INTO hin2010_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","वे लोग और पृथ्वी के हर एक प्रकार के जानवर जहाज़ में थे। हर प्रकार के मवेशी, पृथ्वी पर रेंगने वाले हर प्रकार के जीव और हर प्रकार के पक्षी जहाज़ में थे। ");
INSERT INTO hin2010_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ये सभी जानवर नूह के साथ जहाज़ में चढ़े। हर जाति के जीवित जानवरों के ये जोड़े थे। ");
INSERT INTO hin2010_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","परमेश्वर की आज्ञा के अनुसार सभी जानवर जहाज़ में चढ़े। उनके अन्दर जाने के बाद यहोवा ने दरवाज़ा बन्द कर दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","चालीस दिन तक पृथ्वी पर जल प्रलय होता रहा। जल बढ़ना शुरु हुआ और उसने जराज की जमीन से ऊपर उठा दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","जल बढ़ता रहा और जहाज़ पृथ्वी से बहुत ऊपर तैरता रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","जल इतना ऊँचा उठा कि ऊँचे—से—ऊँचे पहाड़ भी पानी में डूब गए। ");
INSERT INTO hin2010_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","जल पहाड़ों के ऊपर बढ़ता रहा। सबसे ऊँचे पहाड़ से तेरह हाथ ऊँचा था। ");
INSERT INTO hin2010_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","पृथ्वी के सभी जीव मारे गए। हर एक स्त्री और पुरुष मर गए। सभी पक्षियों और सभी तरह के जानवर मर गए। ");
INSERT INTO hin2010_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","इस तरह परमेश्वर ने पृथ्वी के सभी जीवित हर एक मनुष्य, हर एक जानवर, हर एक रेंगने वाले जीव और हर एक पक्षी को नष्ट कर दिया। वे सभी पृथ्वी से खतम हो गए। केवल नूह, उसके साथ जहाज में चढ़े लोगों और जानवरों का जीवन बचा रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","और जल एक सौ पचास दिन तक पृथ्वी को डुबाए रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","लेकिन परमेश्वर नूह को नहीं भूला। परमेश्वर ने नूह और जहाज़ में उसके साथ रहने वाले सभी पशुओं और जानवरों के याद रखा। परमेश्वर ने पृथ्वी पर आँधी चलाई और सारा जल गायब होने लगा। ");
INSERT INTO hin2010_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","आकाश से वर्षा रूक गई और पृथ्वी के नीचे से पानी का बहना भी रूक गया। ");
INSERT INTO hin2010_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","पृथ्वी को डुबाने वाला पानी बरबर घटता चला गया। एक सौ पचास दिन बाद पानी इतना उतर गया कि जहाज फिर से भूमि पर आ गमा। ");
INSERT INTO hin2010_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","जहाज अरारात के पहाड़ों में से एक पर आ टिका। यह सातवें महीने का सत्तरहवाँ दिन था। ");
INSERT INTO hin2010_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","जल उतरता गया और दसवें महीने के पहले दिन पहाड़ों की चोटियाँ जल के ऊपर दिखाई देने लगी। ");
INSERT INTO hin2010_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","जहाज में बनी खिड़की को नूह ने चालीस दिन बाद खोला। ");
INSERT INTO hin2010_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","नूह ने एक कौवे को बाहर उड़ाया। कौवा उड़ कर तब तक फिरता रहा जब तक कि पृथ्वी पूरी तरह से न सूख गयी। ");
INSERT INTO hin2010_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","नूह ने एक फाख्ता भी बाहर भेजा। वह जानना चाहता था कि पृथ्वी का पानी कम हुआ है या नहीं। ");
INSERT INTO hin2010_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","फ़ाख्ते को कहीं बैठने की जगह नहीं मिली क्योंकि अभी तक पानी पृथ्वी पर फैला हुआ था। इसलिए वह नूह के पास जहाज़ पर वापस लौट आया। नूह ने अपना हाथ बढ़ा कर फ़ाख्ते को वापस जहाज़ के अन्दर ले लिया। ");
INSERT INTO hin2010_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","सात दिन बाद नूह ने फिर फ़ाख्ते को भेजा। ");
INSERT INTO hin2010_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","उस दिन दोपहर बाद फ़ाख्ता नूह के पास आया। फ़ाख्ते के मुँह में एक ताजी जैतून की पत्ती थी। यह चिन्ह नूह को यह बताने के लिए था कि अब पानी पृथ्वी पर धीरे—धीरे कम हो रहा है। ");
INSERT INTO hin2010_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","नूह ने सात दिन बाद फिर फ़ाख्ते को भेजा। किन्तु इस समय फ़ाख्ता लौटा ही नहीं। ");
INSERT INTO hin2010_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","उसके बाद नूह ने जहाज़ का दरवाजा खोला नूह ने देखा और पाया कि भूमि सूखी है। यह वर्ष के पहले महीने का पहला दिन था। नूह छः सौ एक वर्ष का था। ");
INSERT INTO hin2010_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","दूसरे महीने के सत्ताइसवें दिन तक भूमि पूरी तरह सूख गयी। ");
INSERT INTO hin2010_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","तब परमेश्वर ने नूह से कहा, ");
INSERT INTO hin2010_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“जहाज़ को छोड़ो। तुम, तुम्हारी पत्नी, तुम्हारे पुत्र और उनकी पत्नियाँ सभी अब बाहर निकलों। ");
INSERT INTO hin2010_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","हर एक जीवित प्राणी, सभी पक्षियों, जानवरों तथा पृथ्वी पर रेंगने वाले सभी को जहाज़ के बाहर लाओ। ये जानवर अनेक जानवर उत्पन्न करेंगे और पृथ्वी को फिर भर देंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","अतः नूह अपने पुत्रों, अपनी पत्नी, अपने पुत्रों की पत्नियों के साथ जहाज़ से बाहर आया। ");
INSERT INTO hin2010_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","सभी जानवरों, सभी रेंगने वाले जीवों और सभी पक्षियों ने जहाज़ को छोड़ दिया। सभी जानवर जहाज़ से नर और मादा के जोड़े में बाहर आए। ");
INSERT INTO hin2010_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","तब नूह ने यहोवा के लिए एक वेदी बनाई। उसने कुछ शुद्ध पक्षियों और कुछ शुद्ध जानवर को लिया और उनको वेदी पर परमेश्वर को भेंट के रूप में जलाया। ");
INSERT INTO hin2010_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","यहोवा इन बलियों की सुगन्ध पाकर खुश हुआ। यहोवा ने मन—ही—मन कहा, “मैं फिर कभी मनुष्य के कारण पृथ्वी को शाप नहीं दूँगा। मानव छोटी आयु से ही बुरी बातें सोचने लगता है। इसलिए जैसा मैंने अभी किया है इस तरह मैं अब कभी भी सारे प्राणियों को सजा नहीं दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","जब तक यह पृथ्वी रहेगी तब तक इस पर फसल उगाने और फ़सल काटने का समय सदैव रहेगा। पृथ्वी पर गरमी और जाड़ा तथा दिन औ रात सदा होते रहेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","परमेश्वर ने नूह और उसके पुत्रों को आशीष दी और उनसे कहा, “बहुत से बच्चे पैदा करो और अपने लोगों से पृथ्वी को भर दो। ");
INSERT INTO hin2010_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","पृथ्वी के सभी जानवर तुम्हारे डर से काँपेंगे और आकाश के हर एक पक्षी भी तुम्हारा आदर करेंगे और तुमसे डरेंगे। पृथ्वी पर रेंगने वाला हर एक जीव और समुद्र की हर एक मछली तुम लोगों का आदर करेगी और तुम लोगों से डरेगी। तुम इन सभी के ऊपर शासन करोगे। ");
INSERT INTO hin2010_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","बीते समय में तुमको मैंने हर पेड़—पौधे खाने को दिए थे। अब हर एक जानवर भी तुम्हारा भोजन होगा। मैं पृथ्वी की सभी चीजें तुमको देता हूँ—अब ये तुम्हारी हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","मैं तुम्हें एक आज्ञा देता हूँ कि तुम किसी जानवर को तब तक न खाना जब तक कि उसमें जीवन (खून) है। ");
INSERT INTO hin2010_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","मैं तुम्हारे जीवन बदले में तुम्हारा खून मागूँगा। अर्थात् मैं उस जानवर का जीवन मागूँगा जो किसी व्यक्ति को मारेगा और मैं हर एक ऐसे व्यक्ति का जीवन मागूँगा जो दूसरे व्यक्ति की ज़िन्दगी नष्ट करेगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“परमेश्वर ने मनुष्य को अपने स्वरूप में बनाया है। इसलिए जो कोई किसी व्यक्ति का खून बहाएगा, उसका खून वयक्ति द्वारा ही बहाया जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“नूह तुम्हें और तुम्हारे पुत्रों के अनेक बच्चे हों और धरती को लोगों से भर दो।” ");
INSERT INTO hin2010_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","तब परमेश्वर ने नूह और उसके पुत्रों से कहा, ");
INSERT INTO hin2010_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“अब मैं तुम्हें और तुम्हारे वंशजों को वचन देता हूँ। ");
INSERT INTO hin2010_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","मैं यह वचन तुम्हारे साथ जहाज़ से बाहर आने वाले सभी पक्षियों, सभी पशुओं तथा सभी जानवरों को देता हूँ। मैं यह वचन पृथ्वी के सभी जीवित प्राणियों को देता हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","मैं तुमको वचन देता हूँ, “जल की बाढ़ से पृथ्वी का सारा जीवन नष्ट हो गया था। किन्तु अब यह कभी नहीं होगा। अब बाढ़ फिर कभी पृथ्वी के जीवन को नष्ट नहीं करेगी।” ");
INSERT INTO hin2010_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","और परमेश्वर ने कहा, “यह प्रमाणित करने के लिए कि मैंने तुमको वचन दिया है कि मैं तुमको कुछ दूँगा। यह प्रमाण बतायेगा कि मैंने तुम से और पृथ्वी के सभी जीवित प्राणियों से एक वाचा बाँधी है। यह वाचा भविष्य में सदा बनी रहेगी जिसका प्रमाण यह है ");
INSERT INTO hin2010_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","कि मैंने बादलों में मेघधनुष बनाया है। यह मेघधनुष मेरे और पृथ्वी के बीच हुए वाचा का प्रमाण है। ");
INSERT INTO hin2010_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","जब मैं पृथ्वी के ऊपर बादलों को लाऊँगा तो तुम बादलों में मेघधनुष को देखोगे। ");
INSERT INTO hin2010_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","जब मैं इस मेघधनुष को देखूँगा तब मैं तुम्हारे, पृथ्वी के सभी जीवित प्राणियों और अपने बीच हुई वाचा को याद करूँगा। यह वाचा इस बात की है कि बाढ़ फिर कभी पृथ्वी के प्राणियों को नष्ट नहीं करेगी। ");
INSERT INTO hin2010_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","जब मैं ध्यान से बादलों में मेघधनुष को देखूँगा तब मैं उस स्थायी वाचा को याद करूँगा। मैं अपने और पृथ्वी के सभी जीवित प्राणियों के बीच हुई वाचा को याद करूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","इस तरह यहोवा ने नूह से कहा, “वह मेघधनुष मेरे और पृथ्वी के सभी जीवित प्राणियों के बीच हुई वाचा का प्रमाण है।” ");
INSERT INTO hin2010_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","नूह के पुत्र उसके साथ जहाज से बाहर आए। उनके नाम शेम, हाम और येपेत था। (हाम तो कनान का पिता था।) ");
INSERT INTO hin2010_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","तीनों नूह के पुत्र थे और संसार के सभी लोग इन तीनों से ही पैदा हुए। ");
INSERT INTO hin2010_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नूह किसान बना। उसने अंगूरों का बाग लगाया। ");
INSERT INTO hin2010_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","नूह ने दाखमधु बनाया और उसे पिया। वह मतवाला हो गया और अपने तम्बू में लेट गया। नूह कोई कपड़ा नहीं पहना था। ");
INSERT INTO hin2010_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","कनान के पिता हाम ने अपने पिता को नंगा देखा। तम्बू के बाहर अपने भाईयों से हाम ने यह बताया। ");
INSERT INTO hin2010_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","तब शेम और येपेत ने एक कपड़ा लिया। वे कपड़े को पीठ पर डाल कर तम्बू में ले गए। वे उल्टे मुँह तम्बू में गए। इस तरह उन्होंने अपने पिता को नंगा नहीं देखा। ");
INSERT INTO hin2010_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","बाद में नूह सोकर उठा। (वह दाखमधु के कारण सो रहा था।) तब उसे पता चला कि उसके सब से छोटे पुत्र हाम ने उसके बारे में क्या किया है। ");
INSERT INTO hin2010_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","इसलिए नूह ने शाप दिया, “यह शाप कनान के लिए हो कि वह अपने भाईयों को दास हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","नूह ने यह भी कहा, “शेम का परमेश्वर यहोवा धन्य हो! कनान शेम का दास हो। ");
INSERT INTO hin2010_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","परमेश्वर येपेत को अधिक भूमि दे। परमेश्वर शेम के तम्बूओं में रहे और कनान उनका दास बनें।” ");
INSERT INTO hin2010_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","बाढ़ के बाद नूह साढ़े तीन सौ वर्ष जीवित रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","नूह पूरे साढ़े नौ सौ वर्ष जीवित रहा, तब वह मरा। ");
INSERT INTO hin2010_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","नूह के पुत्र शेम, हाम, और येपेत थे। बाढ़ के बाद ये तीनों बहुत से पुत्रों के पिता हुए। यहाँ शेम, हाम और येपेत से पैदा होने वाले पुत्रों की सूची दी जा रही है: ");
INSERT INTO hin2010_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","येपेत के पुत्र थे: गोमेर, मागोग, मादै, यावान, तूबल, मेशेक और तीरास। ");
INSERT INTO hin2010_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","गोमेर के पुत्र थे: अशकनज, रीपत और तोगर्मा ");
INSERT INTO hin2010_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","यावान के पुत्र थे: एलीशा, तर्शीश, कित्ती और दोदानी ");
INSERT INTO hin2010_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","भूमध्य सागर के चारों ओर तटों पर जो लोग रहने लगे वे येपेत के वंशज के ही थे। हर एक पुत्र का अपना अलग प्रदेश था। सभी परिवार बढ़े और अलग राष्ट्र बन गए। हर एक राष्ट्र की अपनी भाषा थी। ");
INSERT INTO hin2010_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हाम के पुत्र थे: कूश, मिस्र, फूत और कनान। ");
INSERT INTO hin2010_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","कूश के पुत्र थे: सबा, हबीला, सबता, रामा, सबूतका। रामा के पुत्र थे: शबा और ददान। ");
INSERT INTO hin2010_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कूश का एक पुत्र निम्रोद नाम का भी था। निम्रोद पृथ्वी पर बहुत शक्तिशाली व्यक्ति हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","यहोवा के सामने निम्रोद एक बड़ा शिकारी था। इसलिए लोग दूसरे व्यक्तियों की तुलना निम्रोद से करते हैं और कहते है, “यह व्यक्ति यहोवा के सामने बड़ा शिकारी निम्रोद के समान है।” ");
INSERT INTO hin2010_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","निम्रोद का राज्य शिनार देश में बाबुल, एरेख और अव्कद प्रदेश में प्रारम्भ हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","निम्रोद अश्शूर में भी गया। वहाँ उसने नीनवे, रहोबोतीर, कालह और ");
INSERT INTO hin2010_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","रेसेन नाम के नगरों को बसाया। (रेसेन, नीनवे और बड़े शहर कालह के बीच का शहर है।) ");
INSERT INTO hin2010_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिस्रम (मिस्र) लूद, अनाम, लहाब, नप्तूह, ");
INSERT INTO hin2010_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","पत्रूस, कसलूह और कप्तोर देशों के निवासियों का पिता था। (पलिश्ती लोग कसलूह लोगों से आए थे।) ");
INSERT INTO hin2010_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनान सीदोन का पिता था। सिदोन कनान का पहला पुत्र था। कनान, हित का भी पिता था। ");
INSERT INTO hin2010_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","और कनान, यबूसी, एमोरी, गिर्गाशी, ");
INSERT INTO hin2010_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिव्वी, अकर्ी, सीनी, ");
INSERT INTO hin2010_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अर्बदी, समारी, हमाती लोगों का पिता था। कनान के परिवार संसार के विभिन्न भागों मे फैले। ");
INSERT INTO hin2010_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","कनान लोगों का देश सीदोन से उत्तर में और दक्षिण में गरार तक, पश्चिम में अजा से पूर्व में सदोम और अमोरा तक, अदमा और सबोयीम से लाशा तक था। ");
INSERT INTO hin2010_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ये सभी लोग हाम के वंशज थे। उन सभी परिवारों को अपनी भाषाएँ और अपने प्रदेश थे। वे अलग—अलग राष्ट्र बन गए। ");
INSERT INTO hin2010_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","शेम येपेत का बड़ा भाई था। शेम का एक वंशज एबेर हिब्रू लोगों का पिता था। ");
INSERT INTO hin2010_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेम के पुत्र एलाम, अश्शूर, अर्पक्षद, लूद और अराम थे। ");
INSERT INTO hin2010_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अराम के पुत्र ऊस, हूल, गेतेर और मश थे। ");
INSERT INTO hin2010_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अर्पक्षद शेलह का पिता था। शेलह एबेर का पिता था। ");
INSERT INTO hin2010_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","एवेर के दो पुत्र थे। एक पुत्र का नाम पेलेग था। उसे यह नाम इसलिए दिया गया क्योंकि जीवन काल में धरती का विभाजन हुआ। दूसरे भाई का नाम योक्तान था। ");
INSERT INTO hin2010_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","योक्तान अल्मोदाद, शेलेप, हसर्मावेत, येरह, ");
INSERT INTO hin2010_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","यदोरवाम, ऊजाल, दिक्ला, ");
INSERT INTO hin2010_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबीमाएल, शवा, ");
INSERT INTO hin2010_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओपोर हवीला और योबाब का पिता था। ये सभी लोग योक्तान की संतान हुए। ");
INSERT INTO hin2010_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ये लोग मेशा और पूर्वी पहाड़ी प्रदेश के बीच की भूमि में रहते थे। मेशा सपारा प्रदेश की ओर था। ");
INSERT INTO hin2010_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","वे लोग शेम के परिवार से थे। वे परिवार, भाषा, प्रदेश और राष्ट्र की इकाईयों में व्यवस्थित थे। ");
INSERT INTO hin2010_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","नूह के पुत्रों से चलने वाले परिवारों की यह सूची है। वे अपने—अपने राष्ट्रो में बँटकर रहते थे। बाढ़ के बाद सारी पृथ्वी पर फैलने वाले लोग इन्हीं परिवारों से निकले। ");
INSERT INTO hin2010_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","बाढ़ के बाद सारा संसार एक ही भाषा बोलता था। सभी लोग एक ही शब्द समूह का प्रयोग करते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","लोग पूर्व से बढ़े। उन्हें शिनार देश में एक मैदान मिला। लोग वहीं रहने के लिए ठहर गए। ");
INSERT INTO hin2010_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","लोगों ने कहा, “हम लोगों को ईंटें बनाना और उन्हें आग में तपाना चाहिए, ताकि वे कठोर हो जाए।” इसलिए लोगों ने अपने घर बनाने के लिए पत्थरों के स्थान पर ईंटों का प्रयोग किया और लोगों ने गारे के स्थान पर राल का प्रयोग किया। ");
INSERT INTO hin2010_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","लोगों ने कहा, “हम अपने लिए एक नगर बनाएँ और हम एक बहुत ऊँची इमारत बनाएँगे जो आकाश को छुएगी। हम लोग प्रसिद्ध हो जाएँगे। आगर हम लोग ऐसा करेंगे तो पूरी धरती पर बिखरेंगे नहीं, हम लोग एक जगह पर एक साथ रहेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","यहोवा नगर और बहुत ऊँची इमारत को देखने के लिए नीचे आया। यहोवा ने लोगों को यह सब बनाते देखा। ");
INSERT INTO hin2010_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","यहोवा ने कहा, “ये सभी लोग एक ही भाषा बोलते हैं और मैं देखता हूँ कि वे इस काम को करने के लिए एकजुट हैं। यह तो, ये जो कुछ कर सकते हैं उसका केवल आरम्भ है। शीघ्र ही वे वह सब कुछ करने के योग्य हो जाएँगे जो ये करना चाहेंगे। सब कुछ करने के योग्य हो जाएँगे जो ये करना चाहेंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","इसलिए आओ हम नीचे चले और इनकी भाषा को गड़बड़ कर दें। तब ये एक दूसरे की बात नहीं समझेगी।” ");
INSERT INTO hin2010_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","यहोवा ने लोगों को परी पृथ्वी पर फैला दिया। इससे लोगों ने नगर को बनाना पूरा नहीं किया। ");
INSERT INTO hin2010_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","यही वह जगह थी जहाँ यहोवा ने पूरे संसार की भाषा को गड़बड़ कर दिया था। इसलिए इस जगह का नाम बाबुल पड़ा। इस प्रकार यहोवा ने उस जगह से लोगों को पृथ्वी के सभी देशों में फैलाया। ");
INSERT INTO hin2010_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","यह शेम के परिवार की कथा है। बाढ़ के दो वर्ष बाद जब शेम सौ वर्ष का था उसके पुत्र अर्पक्षद का जन्म हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","उसके बाद शेम पाँच सौ वर्ष जीवित रहा। उसके अन्य पुत्र और पुत्रियाँ थीं। ");
INSERT INTO hin2010_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","जब अर्पक्षद पैंतीस वर्ष का था उसके पुत्र शेलह का जन्म हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","शेलह के जन्म होने के बाद अर्पक्षद चार सौ तीन वर्ष जीवित रहा। इन दिनों उसके दूसरे पुत्र और पुत्रियाँ पैदा हुईं। ");
INSERT INTO hin2010_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","शेलह के तीस वर्ष के होने पर उसके पुत्र एबेर का जन्म हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","एबेर के जन्म के बाद शेलह चार सौ तीन वर्ष जीवित रहा। इन दिनों में उसके दूसरे पुत्र और पुत्रियाँ उत्पन्न हुईं। ");
INSERT INTO hin2010_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","एबेर के चौंतीस वर्ष के होने के बाद उसके पुत्र पेलेग का जन्म हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","पेलेग के जन्म के बाद एबेर चार सौ तीन वर्ष और जीवित रहा। इन दिनों में इसको दूसरे पुत्र और पुत्रियाँ हुईं। ");
INSERT INTO hin2010_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","जब पेलेग तीस वर्ष का हुआ, उसके पुत्र रु का जन्म हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","रु के जन्म के बाद पेलेग दो सौ नौ वर्ष और जीवित रहा। उन दिनों में उसके अन्य पुत्रियों और पुत्रों का जन्म हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","जब रु बत्तीस वर्ष का हुआ, उसके पुत्र सरूग का जन्म हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","सरूग के जन्म के बाद रु दो सौ सात वर्ष और जीवित रहा। इन दिनों उसके दूसरे पुत्र और पुत्रियाँ हुईं। ");
INSERT INTO hin2010_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","जब सरुग तीस वर्ष का हुआ, उसके पुत्र नाहोर का जन्म हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","नाहोर के जन्म के बाद सरुग दो सौ वर्ष और जीवित रहा। इन दिनों में उसके दूसरे पुत्रों और पुत्रियों का जन्म हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","जब नाहोर उनतीस वर्ष का हुआ, उसके पुत्र तेरह का जन्म हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","तेरह के जन्म के बाद नाहोर एक सौ उन्नीस वर्ष और जीवित रहा। इन दिनों में उसके दूसरी पुत्रियों और पुत्रों का जन्म हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","तेरह जब सत्तर वर्ष का हुआ, उसके पुत्र अब्राम, नाहोर और हारान का जन्म हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","यह तेरह के परिवार की कथा है। तेरह अब्राम, नाहोर और हारान का पिता था। हारान लूत का पिता था। ");
INSERT INTO hin2010_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","हारान अपनी जन्मभूमि कसदियों के उर नगर में मरा। जब हारान मरा तब उसका पिता तेरह जीवित था। ");
INSERT INTO hin2010_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राम और नाहोर दोनों ने विवाह किया। अब्राम की पत्नी सारै थी। नाहोर दोनों ने विवाह किया। अब्राहम की पत्नी सारै थी। नाहोर की पत्नी मिल्का थी। मिल्का हारान की पुत्री थी। हारान मिल्का और यिस्का का बाप था। ");
INSERT INTO hin2010_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","सारै के कोई बच्चा नहीं था क्योंकि वह किसी बच्चे को जन्म देने योग्य नहीं थी। ");
INSERT INTO hin2010_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","तेरह ने अपने परिवार को साथ लिया और कसदियों के उर नगर को छोड़ दिया। उन्होंने कनान की यात्रा करने का इरादा किया। तेरह ने अपने पुत्र अब्राम, अपने पोते लूत (हारान का पुत्र), अपनी पुत्रवधू (अब्राम की पत्नी) सारै को साथ लिया। उन्होंने हारान तक यात्रा की और वहाँ ठहरना तय किया। ");
INSERT INTO hin2010_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","तेरह दो सौ पाँच वर्ष जीवित रहा। तब वह हारान में मर गया। ");
INSERT INTO hin2010_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","यहोवा ने अब्राम से कहा, “अपने देश और अपने लोगों को छोड़ दो। अपने पिता के परिवार को छोड़ दो और उस देश जाओ जिसे मै तुम्हें दिखाऊँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","मैं तुम्हें आशीर्वाद दूँगा। मैं तुझसे एक महान राष्ट्र बनाऊँगा। मैं तुम्हारे नाम को प्रसिद्ध करूँगा। लोग तुम्हारे नाम का प्रयोग दूसरों के कल्यान के लिए करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","मैं उन लोगों को आशीर्वाद दूँगा, जो तुम्हारा भला करेंगे। किन्तु उनको दण्ड दूँगा जो तुम्हारा बुरा करेंगे। पृथ्वी के सारे मनुष्यों को आशीर्वाद देने के लिए मैं तुम्हारा उपयोग करूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","अब्राम ने यहोवा को आज्ञा मानी। उसने हारान को छोड़ दिया और लूत उसके साथ गया। इस समय अब्राम पच्हत्तर वर्ष का था। ");
INSERT INTO hin2010_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","अब्राम ने जब हारान छोड़ा तो वह अकेला नहीं था। अब्राम अपनी पत्नी सारै, भतीजे लूत और हारान में उनके पास जो कुछ था, सहको साथ लाया। हारान में जो दास अब्राम को मिले थे वे भी उनके साथ गए। अब्राम और उसके दल ने हारान को छोड़ा और कनान देश तक यात्रा की। ");
INSERT INTO hin2010_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","अब्राम ने कनान देश में शकेम के नगर और मोरे के बड़े पेड़ तक यात्रा की। उस समय कनानी लोग उस देश में रहते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","यहोव अब्राम के सामने आया यहोवा ने कहा, “मैं यह देश तुम्हारे वंशजों को दूँगा।” यहोवा अब्राम के सामने जिस जगह पर प्रकट हुआ उस जगह पर अब्राम ने एक वेदी यहोवा की उपासना के लिए बनाया। ");
INSERT INTO hin2010_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","तब अब्राम ने उस जगह को छोड़ा और बेतेल के पूर्व पहाड़ों तक यात्रा की। अब्राम ने वहाँ अपना तम्बू लगाया। बेतेल नगर पश्चिम में था। ये नगर पूर्व में था। उस जगह अब्राम ने यहोवा के लिए दूसरी वेदी बनाई और अब्राम ने वहाँ यहोवा की उपासना की। ");
INSERT INTO hin2010_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","इसके बाद अब्राम ने फिर यात्रा आरम्भ की। उसने नेगव की ओर यात्रा की। ");
INSERT INTO hin2010_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","इन दिनों भूमि बहुत सूखी थी। वर्षा नहीं हो रही थी और कोई खाने की चीज़ नहीं उग सकती थी। इसलिए अब्राम जीवित रहने के लिए मिस्र चला गया। ");
INSERT INTO hin2010_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","अब्राम ने देखा कि उसकी पत्नी सारै बहुत सुन्दर थी। इसलिए मिस्रि में आने के पहले अब्राम ने सारै से कहा, “मैं जानता हूँ कि तुम बहुत सुन्दर स्त्री हो। ");
INSERT INTO hin2010_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","मिस्र के लोग तुम्हें देखेंगे। वे कहेंगे ‘यह स्त्री इसकी पत्नी है।’ तब वे मुझे मार डालेंगे क्योंकि वे तुमको लेना चाहेंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","इसलिए तुम लोगों से कहना कि तुम मेरी बहन हो। तब वे मुझको नहीं मारेंगे। वे मुझ पर दया करेंगे क्योंकि वे समझेंगे कि मैं तुम्हारा भाई हूँ। इस तरह तुम मेरा जीवन बचाओगी।” ");
INSERT INTO hin2010_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","इस प्रकार अब्राम मिस्र में पहुँचा। मिस्र के लोगों ने देखा, सारै बहुत सुन्दर स्त्री है। ");
INSERT INTO hin2010_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","कुछ मिस्र के अधिकारियों ने भी उसे देखा। उन्होंने फ़िरौन से कहा कि वह बहुत सुन्दर स्त्री है। वे अधिकारी सारै को फ़िरौन के घर ले गए। ");
INSERT INTO hin2010_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","फिरौन ने अब्राम के ऊपर दया की क्योंकि उसने समझा कि वह सारै का भाई है। फ़िरौन ने अब्राम को भेड़ें, मवेशी और गधे दिए। अब्राम को ऊँटों के साथ—साथ आदमी और स्त्रियाँ दास—दासी के रूप में मिले। ");
INSERT INTO hin2010_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","फ़िरौन अब्राम की पत्नी को रख लिया। इससे यहोवा ने फ़िरौन और उसके घर के मनुष्यों में बुरी बीमारी फैला दी। ");
INSERT INTO hin2010_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","इसलिए फिरौन ने अब्राम को बुलाया। फ़िरौन ने कहा, “तुमने मेरे साथ बड़ी बुराई की है। तुमने यह नहीं बताया कि सारै तुम्हारी पत्नी है। क्यों? ");
INSERT INTO hin2010_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","तुमने कहा, ‘यह मेरी बहन है।’ तुमने ऐसा क्यों कहा? मैंने इसे इसलिए रखा कि यह मेरी पत्नी होगी। किन्तु अब मैं तुम्हारी पत्नी को तुम्हें लौटाता हूँ। इसे लो और जाओ।” ");
INSERT INTO hin2010_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","तब फ़िरौन ने अपने पुरुषों को आज्ञा दी कि वे अब्राम को मिस्र के बाहर पहुँचा दे। इस तरह अब्राम और उसकी पत्नी ने वह जगह छोड़ी और वे सभी चीज़े अपने साथ ले गए जो उनकी थीं। ");
INSERT INTO hin2010_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","अब्राम ने मिस्र छोड़ दिया। अब्राम ने अपनी पत्नी तथा अपने सभी सामान के साथ नेगव से होकर यात्रा की। लूत भी उसके साथ था। ");
INSERT INTO hin2010_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","इस समय अब्राम बहुत धनी था। उसके पास बहुत से जानवर, बहुत सी चाँदी और बहुत सा सोना था। ");
INSERT INTO hin2010_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","अब्राम चारों तरफ यात्रा करता रहा। उसने नेगेव को छोड़ा और बेतेल को लौट गया। वह बेतेल नगर और ऐ नगर के बीच के प्रदेश में पहुँचा। यह वही जगह थी जहाँ अब्राम और उसका परिवार पहले तम्बू लगाकर ठहरा था। ");
INSERT INTO hin2010_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","यह वही जगह थी जहाँ अब्राम ने एक वेदी बनाई थी। इसलिए अब्राम ने यहाँ यहोवा की उपासना की। ");
INSERT INTO hin2010_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","इस समय लूत भी अब्राम के साथ यात्रा कर रहा था। लूत के पास बहुत से जानवर और तम्बू थे। ");
INSERT INTO hin2010_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","अब्राम और लूत के पास इतने अधिक जानवर थे कि भूमि एक साथ उनको चारा नहीं दे सकती थी। ");
INSERT INTO hin2010_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","(उन दिनों कनानी लोग और परिजी लोग भी इसी प्रदेश में रहते थे।) अब्राम और लूत के मज़दूर आपस में बहस करने लगे। ");
INSERT INTO hin2010_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","अब्राम ने लूत से कहा, “हमारे और तुम्हारे बीच कोई बहस नहीं होनी चाहिए। हमारे और तुम्हारे लोग भी बहस न करें। हम सभी भाई हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","हम लोगों को अलग हो जाना चाहिए। तुम जो चाहो जगह चुन लो। अगर तुम बायीं और जाओगे तो मैं बायीं ओर जाऊँगा।” अगर तुम बायीं ओर जाओगे तो मैं दाहिनी ओर जाऊँगा। अगर तुम दाहिनी ओर जाओगे तो मैं बायीं ओर जऊँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","लूत ने निगाह दौड़ाई और यरदन की घाटी को देखा। लूत ने देखा कि वहाँ बहुत पानी है। (यह बात उस समय की है जब यहोवा ने सदोम और अमोरा को नष्ट नहीं किया था। उस समय यरदन की घाटी सोअर तक यहोवा के बाग की तरह पूरे रास्ते के साथ—साथ फैली थी। यह प्रदेश मिस्र देश की तरह अच्छा था।) ");
INSERT INTO hin2010_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","इसलिए लूत ने यरदन घाटी में रहना स्वीकार किया। इस तरह दोनों व्यक्ति अलग हुए और लूत ने पूर्व की ओर यात्रा शुरू की। ");
INSERT INTO hin2010_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम कनान प्रदेश में रहा और लूत घाटी के नगरों में रहा। लूत सदोम के दक्षिण में बढ़ा और ठहर गया। ");
INSERT INTO hin2010_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोम के लोग बहुत पापी थे। वे हमेशा यहोवा के विरुद्ध पाप करते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","जब लूत चला गया तब यहोवा ने अब्राम से कहा, “अपने चारों ओर देखो, उत्तर, दक्षिण, पूर्व और पश्चिम की ओर देखो। ");
INSERT INTO hin2010_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","यह सारी भूमि, जिसे तुम देखते हो, मैं तुमको और तुम्हारे बाद जो तुम्हारे लोग रहेंगे उनको देता हूँ। यह प्रदेश सदा के लिए तुम्हारा है। ");
INSERT INTO hin2010_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","मै तुम्हारे लोगों को पृथ्वी के कणों के समान अनगिनत बनाऊँगा। अगर कोई व्यक्ति पृथ्वी के कणों को गिन सके तो वह तुम्हारे लोगों को भी गिन सकेगा। ");
INSERT INTO hin2010_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","इसलिए जाओ। अपनी भूमि पर चलो। मैं इसे अब तुमको देता हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","इस तरह अब्राम ने अपने तम्बू हटाया। वह मस्रे के बड़े पेड़ों के पास रहने लगा। यह हेब्रोन नगर के करीब था। उस जगह पर अब्राम ने एक वेदी यहोवा की उपासना के लिए बनायी। ");
INSERT INTO hin2010_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","अम्रपेल शिनार का राजा था। अर्योक एल्लासार का राजा था। कदोर्लाओमेर एलाम का राजा था। तिदाल गोयीम का राजा था। ");
INSERT INTO hin2010_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","इन सभी राजाओं ने सदोम के राजा बेरा, अमोरा के राजा बिर्शा, अद्मा के राजा शिनाब, सबोयीम के राजा शेमेबेर तथा बेला (बेला सोअर भी कहा जाता है) के राजा के साथ एक लड़ाई लड़ी। ");
INSERT INTO hin2010_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","सिद्दीम की घाटी में ये सभी राजा अपनी सेनाओं से मिले। (सिद्दीम की घाटी आज—कल लवण सागर है।) ");
INSERT INTO hin2010_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","इन राजाओं ने कदोर्लाओमेर की सेवा बारह वर्ष तक की थी। किन्तु तेरहवें वर्ष वे सभी उसके विरुद्ध हो गए। ");
INSERT INTO hin2010_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","इसलिए चौदहवें वर्ष कदोर्लाओमेर अन्य राजाओं के साथ उनसे लड़ने आया। कदोर्लाओमेर और उसके साथ के राजाओं ने रपाई लोगों को अशतरोत्कनम में हराया। उन्होंने हाम में जीजि लोगों को भी हराया। उन्होंने एमि लोगों को शाबेकिर्यातैम में हराया ");
INSERT INTO hin2010_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","और उन्होंने होरीत लोगों को सेईर के पहाड़ी प्रदेश से हराकर एल्पारान की ओर भगाया। (एल्पारान मरूभूमि के करीब है।) ");
INSERT INTO hin2010_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","तब राजा कदोर्लाओमेर पीछे को मुड़ा और एन्मिशपात को गया। (यह कादेश भी कहलाता है।) और सभी अमालेकी लोगों को हराया। उसने एमोरी लोगों को भी हराया। ये लोग हससोन्तामार में रहते हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","उस समय सदोम का राजा, अमोरा का राजा, अदमा का राजा, सबोयीम का राजा, और बेला का राजा, (बेला सोओर की है।) सभी एक साथ मिलकर अपने शत्रुओं से लड़ने के लिए गए। ");
INSERT INTO hin2010_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","वे एलाम के राजा कदोर्लाओमेर, गोयीम के राजा तिदाल, शिनार के राजा अम्रापेल, और एल्लासार के राजा अर्योक से लड़े। इस तरह चार राजा पाँच राजाओं से लड़ रहे थे। ");
INSERT INTO hin2010_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","सिद्दीम की घाटी में राल से भरे हुए अनेक गके थे। सदोम और अमोरा के राजा और उनकी सेनाँए भाग गई। अनेक सैनिक उन गद्ढों में गिर गए। किन्तु दूसरे लोग पहाड़ी में भाग गए। ");
INSERT INTO hin2010_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","सदोम और अमोरा के पास जो कुछ था उसे उनके शत्रुओं ने ले लिया। उन्होंने उनके सारे भोजन—वस्त्रों को ले लिया और वे चले गए। ");
INSERT INTO hin2010_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","अब्राम के भाई का पुत्र लूत सदोम में रहता था, उसे शत्रुओं ने पकड़ लिया। उसके पास जो कुछ था उसे भी शत्रु लेकर चले गए। ");
INSERT INTO hin2010_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","एक व्यक्ति ने, जो पकड़ा नहीं जा सका था उसने अब्राम (जो हिब्रू था) को ये सारी बातें बतायीं। एमोरी मम्रे के पेड़ों के पास अब्राम ने अपना डेरा डाला था। मम्रे एशकोल और आनेर के एक सन्धि एक दूसरे की मदद के लिए की थी और उन्होंने अब्राम की मदद के लिए भी एक वाचा की थी। ");
INSERT INTO hin2010_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","जब अब्राम को पता चला कि लूत पकड़ा गया है। तो उसने अपने पूरे परिवार को इकट्ठा किया और उनमें से तीन सौ अट्ठारह प्रशिक्षित सैनिकों को लेकर अब्राम ने दान नगर तक शत्रुओं का पीछा किया। ");
INSERT INTO hin2010_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","उसी रात उसने और उसके पुरुषों ने शत्रुओं पर अचानक धावा बोल दिया। उन्होंने शत्रुओं को हराया था दमिश्क के उत्तर में होबा तक उनका पीछा किया। ");
INSERT INTO hin2010_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","तब अब्राम शत्रु द्वारा चुराई गई सभी चीज़ें लाया। अब्राम स्त्रियों, नौकर, लूत और लूत की अपनी सभी चीज़ें ले आया। ");
INSERT INTO hin2010_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","कदोर्लाओमेर और उसके साथ के सभी राजाओं को हराने के बाद अब्राम अपने घर लौट आय। जब वह घर आया तो सदोम का राजा उससे मिलने शावे की घाटी पहुँचा। (इसे अब राजा की घाटी कहते हैं।) ");
INSERT INTO hin2010_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","शालेम का राजा मेल्कीसेदेक भी अब्राम से मिलने गया। मेल्कीसेदेक, सबसे महान परमेश्वर का याजक था। मेल्कीसेदेक रोटी और दाखरस लाय। ");
INSERT INTO hin2010_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","मेल्कीसेदेक ने अब्राम को आशीर्वाद दिया और कहा: “अब्राम, सबसे महान परमेश्वर तुम्हें आशीष दे। परमेश्वर ने पृथ्वी और आकाश बनाया। ");
INSERT INTO hin2010_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","और हम सबसे महान परमेश्वर की स्तुति करते हैं। परमेश्वर ने शत्रुओं को हराने में तुम्हारी मदद की।” तब अब्राम ने लड़ाई में मिली हर एक चीज़ का दसवाँ हिस्सा मल्कीसेदेक को दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","तब सदोम के राजा ने कहा, “तुम ये सभी चीज़ें अपने पास रख सकते हो, मुझे केवल मेरे उन मनुष्यों को दे दो जिन्हें शत्रु पकड़ कर ले गए थे।” ");
INSERT INTO hin2010_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","किन्तु अब्राम ने सदोम के राजा से कहा, “मैंने सबसे महान परमेश्वर यहोवा जिसने पृथ्वी और आकाश को बनाया हाय। उसके सम्मुख यह शपथ ली है ");
INSERT INTO hin2010_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","कि जो आपकी चीज़ है उसमें से कुछ भी न लूँगा। यहाँ तक कि एक धागा व जूते का तस्मा भी नहीं लूँगा। मैं यह नहीं चाहता कि आप कहें, ‘मैंने अब्राम को धनी बनाया।’ ");
INSERT INTO hin2010_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","मैं केवल वह भोजन स्वीकार करूँगा जो हमारे जवानों ने खाया है किन्तु आप दूसरे लोगों को उनका हिस्सा दें। हमारी लड़ाई में जीती हुई चीज़ें आप लें और इसमें से कुछ आनेर, एश्कोल और मस्रे को दें। इन लोगों ने लड़ाई में मेरी मदद की थी।” ");
INSERT INTO hin2010_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","इन बातों के हो जाने के बाद यहोवा का आदेश अब्राम को एक दर्शन में आया। परमेश्वर ने कहा, “अब्राम, डरो नहीं। मैं तुम्हारी रक्षा करूँगा और मैं तुम्हें एक बड़ा पुरस्कार दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","किन्तु अब्राम ने कहा, “हे यहोवा ऐसा कुछ भी नहीं है जिसे तू मुझे देगा और वह मुझे प्रसन्न करेगा। क्यों? क्योंकि मेरे पुत्र नहीं है। इसलिए मेरा दास दमिश्क का निओवासी एलीएजेर मेरे मरने के बाद मेरा सब कुछ पाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","अब्राम ने कहा, “तू ही देख, तूने मुझे कोई पुत्र नहीं दिया है। इसलिए मेरे घर में पैदा एक दास मेरी सभी चीज़ें पाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","तब यहोवा ने अब्राम से बातें की। परमेश्वर ने कहा, “तुम्हारी चीज़ों को तुम्हारा यह दास नहीं पाएग। तुमको एक पुत्र होगा और तुम्हारा पुत्र ही तुम्हारी चीज़ें पाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","तब परमेश्वर अब्राम को बाहर ले गया। परमेश्वर ने कहा, “आकाश को देखो। अनेक तारों को देखो। ये इतने हैं कि तुम गिन नहीं सकते। भविष्य में तुम्हारा कुटुम्ब ऐसा ही होगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","अब्राम ने परमेश्वर पर विश्वास किया और परमेश्वर ने उसके विश्वास को एक अच्छा काम माना, ");
INSERT INTO hin2010_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","परमेश्वर ने अब्राम से कहा, “मैं ही वह यहोवा हूँ जो तुम्हें कसदियों के ऊर से बाहर लाया। यह मैंने इसलिए किया कि यह प्रदेश मैं तुम्हें दे सकूँ, तुम इस प्रदेश को अपने कब्ज़े में कर सको।” ");
INSERT INTO hin2010_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","किन्तु अब्राम ने कहा, “हे यहोवा, मेरे स्वामी, मुझे कैसे विश्वास हो कि यह प्रदेश मुझे मिलेगा?” ");
INSERT INTO hin2010_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","परमेश्वर ने अब्राम से कहा, “हम लोग एक वाचा बांधेंगे। तुम मुझको तीन वर्ष की एक गाय, तीन वर्ष की एक बकरी, और तीन वर्ष का एक भेड़ लाओ। एक फ़ाख्ता और एक कबूतर का बच्चा भी लाओ।” ");
INSERT INTO hin2010_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","अब्राम ये सभी चीज़ें परमेश्वर के पास लाया। अब्राम ने इन प्राणियों को मार डला और हर एक के दो टुकड़े कर डाले। अब्राम ने एक आधा टुकड़ा एक तरफ तथा उसका दूसरा आधा टुकड़ा उसके विपरीत दूसरी तरफ रखा। अब्राम ने पक्षियों के दो टुकड़े नहीं किए। ");
INSERT INTO hin2010_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","थोड़ी देर बाद माँसहारी पक्षी वेदी पर चढ़ाए हुए मृत जीवों को खाने के लिए नीचे आए किन्तु अब्राम ने उनको भगा दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","बाद में सूरज डूबने लगा। अब्राम को गहरी नींद आ गयी। घन—घोर अंधकार ने उसे चारों तरफ से घेर लिया। ");
INSERT INTO hin2010_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","तब यहोवा ने अब्राम से कहा, “तुम्हें ये बातें जाननी चहिए। तुम्हारे वंशज विदेशी बनेंगे और वे उस देश में जांएगे जो उनका नहीं होगा। वे वहाँ दास होंगे। चार सौ वर्ष तक उनके साथ बुरा व्यवहार होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","मैं उस राष्ट्र का न्याय करूँगा तथा उसे सजा दूँगा, जिसने उन्हें गुलाम बनाया और जब तुम्हारे बाद स्न्र ब्स्ल्र लोग उस देश को छेड़ेंगे तो अपने साथ अनेक अच्छी वस्तुएं ले जायेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","“तुम बहुत लम्बी आयु तक जीवित रहोगे। तुम शान्ति के साथ मरोगे और तुम अपने पुरखाओं के पास दफनाए जाओगे। ");
INSERT INTO hin2010_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","चार पीढ़ियों के बाद तुम्हारे लोग इसी प्रदेश में फिर आएंगे। उस समय तुम्हारे लोग एमोरियों को हरांएगे। यहाँ रहने वाले एमोरियों को, दण्ड देने के लिए मैं तुम्हारे लोगों का प्रयोग करूँगा। यह बात भविष्य में होगी क्योंकि एमोरी दण्ड पाने येग्य बुरे अही नहीं हुए हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","जब सूरज ढ़ल गया, तो बहुत अंधेरा छा गया। मृत जानवर अभी तक जमीन पर पड़े हुए थे। हर जानवर दो भागों में कटे पड़े थे। उसी समय धुएँ तथा आग का एक खम्भा मरे जानवरों के तुकड़ों के बीच से गुजरा। ");
INSERT INTO hin2010_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","इस तरह उस दिन यहोवा ने अब्राम को वचन दिया और उसके साथ वाचा की। यहोवा ने कहा, “मैं यह प्रदेश तुम्हारे वंशजों को दूँगा। मैं मिस्र की नदी और बाड़ी नदी परात के बीच का प्रदेश उनको दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","यह देश केनी, कनिज्जी, कदमोनी, ");
INSERT INTO hin2010_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्ती, परीज्जी, रपाई, ");
INSERT INTO hin2010_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","एमोरी, कनानी, गिर्गाशी तथा यबूसी लोगों का है।” ");
INSERT INTO hin2010_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","सारै अब्राम की पत्नी थी। अब्राम और उसके कोई बच्चा नहीं था। सारै के पास एक मिसर की दासी थी। उसका नाम हाजिरा था। ");
INSERT INTO hin2010_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","सारै ने अब्राम से कहा, “देखो, यहोवा ने मुझे कोई बच्चा नहीं दिया है। इसलिए मेरी दासी को रख लो। मैं इसके बच्चे को अपना बच्चा ही मान लूँगी।” अब्राम ने अपनी पत्नी का कहना मान लिया। ");
INSERT INTO hin2010_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","कनान में अब्राम के दस वर्ष रहने के बाद यह बात हुई और सारै (हाजिरा मिस्री दासी थी।) ");
INSERT INTO hin2010_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","हाजिरा, अब्राम से गर्भवती हुई। जब हाजिरा ने यह देखा तो उसे बहुत गर्व हुआ और यह अनुभव करने लगी कि मैं अपनी मालकिन सारै से अच्छी हूँ। ");
INSERT INTO hin2010_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","लेकिन सारै ने अब्राम से कहा, “मेरी दासी अब मुझसे घृणा करती हऐ और इसके लिए मैं तुमको दोषी मानती हूँ। मैंने उसको तुमको दिया। वह गर्भवती हुई और तब वह अनुभव करने लगी कि वह मुझसे अच्छी है। मैं चाहती हूँ कि यहोवा सही न्याय करे।” ");
INSERT INTO hin2010_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","लेकिन अब्राम ने सारै से कहा, “तुम हाजिरा की मालकिन हो। तुम उसके साथ जो चाहो कर सकती हो।” इसलिए सारै ने अपनी दासी को दाण्ड दिया और उसकी दासी भाग गई। ");
INSERT INTO hin2010_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","यहोवा के दूत ने मरुभूमि में पानी के सोते के पास दासी को पाया। यह सोता शूर जाने वाले रास्ते पर था। ");
INSERT INTO hin2010_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","दूत ने कहा, “हाजिरा, तुम सारै की दासी हो। तुम यहाँ क्यों हो? तुम कहाँ जा रही हो?” हाजिरा ने कहा, “मैं अपनी मालकिन सारै के यहाँ से भाग रही हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","यहोवा के दूत ने उससे कहा, “तुम अपनी मालकिन के घर जाओ और उसकी बातें मानो।” ");
INSERT INTO hin2010_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","यहोवा के दूत ने उससे यह भी कहा, “तुमसे बहुत से लोग उत्पन्न होंगे। ये लो गितने हो जाएंगे कि गिने नहीं जा सकेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","दूत ने और भी कहा, “अभी तुम गर्भवती हो और तुम्हे एक पुत्र होगा। तुम उसका नाम इश्माएल रखना। क्योंकि यहोवा ने तुम्हारे कष्ट को सुना है और वह तुम्हारी मदद करेगा। ");
INSERT INTO hin2010_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","इश्माएल जंगली और आजाद होगा एक जंगली गधे की तरह। वह सबके विरुद्ध होगा। वह एक स्थान से दूसरे स्थान को जाएगा। वह अपने भाइयों के पास अपना डेरा डालेगा किन्तु वह उनके विरुद्ध होगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","तब यहोवा ने हाजिरा से बातें की उसने परमेश्वर को जो उससे बातें कर रहा था, एक नए नाम से पुकारा। उसने कहा, “तुम वह ‘यहोवा हो जो मुझे देखता है।’” उसने उसे वह नाम इसलिए दिया क्योंकि उसने अपने—आप से कहा, “मैंने देखा है कि वह मेरे ऊपर नज़र रखता है।” ");
INSERT INTO hin2010_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","इसलिए उस कुएँ का नाम लहैरोई पड़ा। यह कुआँ कादेश तथा बेरेद के बीच में है। ");
INSERT INTO hin2010_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","हाजिरा ने अब्राम के पुत्र को जन्म दिया। अब्राम ने पुत्र का नाम इश्माएल रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","अब्राम उस समय छियासी वर्ष का था जब हाजिरा ने इश्माएल को जन्म दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","जब अब्राम निन्यानवे वर्ष का हुआ, यहोवा ने उससे बात की। यहोवा ने कहा, “मैं सर्वशक्तिमान परमेश्वर हूँ। मेरे लिए ये काम करो। मेरी आज्ञा मानो और सही रास्ते पर चलो। ");
INSERT INTO hin2010_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","अगर तुम यह करो तो मैं अपने और तुम्हारे बीच एक वाचा तैयार करूँगा। मैं तुम्हारे लोगों को एक महान राष्ट्र बनाने का वचन दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","अब्राम ने अपना मुँह जमीन की ओर झुकाया। तब परमेश्वर ने उससे बात—चीत की और कहा, ");
INSERT INTO hin2010_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“हमारी वाचा का यह भाग मेरा है। मैं तुम्हें कई राष्ट्रों का पिता बनाऊँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","मैं तुम्हारे नाम को बदल दूँगा। तुम्हारा नाम अब्राम नहीं रहेगा। तुम्हारा नां इब्राहीम होगा। मैं तुम्हें यह नाम इसलिए दे रहा हूँ कि तुम बहुत से राष्ट्रों के पिता बनोगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","“मैं तुमको बहुत वंशज दूँगा। तुमसे नए राष्ट्र उत्पन्न होंगे। तुमसे नए राजा उत्पन्न होंगे ");
INSERT INTO hin2010_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","और मैं अपने और तुम्हारे बीच एक वाचा करूँगा। यह वाचा तुम्हारे सभी वंशजों के लिए होगी। मैं तुम्हारा और तुम्हारे सभी वंशजों का परमेश्वर रहूँगा। यह वाचा सदा के लिए बनी रहेगी ");
INSERT INTO hin2010_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","और मैं यह प्रदेश तुमको और तुम्हारे सभी वंशजों को दूँगा। मैं वह प्रदेश तुम्हें दूँगा जिससे होकर तुम यात्रा कर रहे हो। मैं तुम्हें कनान प्रदेश दूँगा। मैं तुम्हें यह प्रदेश सदा के लिए दूँगा और मैं तुम्हारा परमेश्वर रहूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","परमेश्वर ने इब्राहीम से कहा, “अब वाचा का यह तुम्हारा भाग है। मेरी इस वाचा का पालन तुम और तुम्हारे वंशज करोगे। ");
INSERT INTO hin2010_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","यह वाचा है जिसका तुम पालन करोगे। यह वाचा मेरे और तुम्हारे बीच है। यह तुम्हारे सभी वंशजों के लिए है। हर एक बच्चा जो पैदा होगा उसका खतना अवश्य होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","तुम चमड़े को यह बताने के लिए काटोगे कि तुम अपने और मेरे बीच के वाचा का पालन करते हो। ");
INSERT INTO hin2010_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","जब बच्चा आठ दिन का हो जाए, तब तुम उसका खतना करना। हर एक लड़का जो तुम्हारे लोगों में पैडा हो या कोई लड़का जो तुम्हारे लोगों का दास हो, उसका खतना अवश्य होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","इस प्रकार तुम्हारे राष्ट्र के प्रत्येक बच्चे का खतना होगा। जो लड़का तुम्हारे परिवार में उत्पन्न होगा या दास के रूप में खरीदा जाएगा उसका खतना होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","यही मेरा नियम है और मेरे और तुम्हारे बीच वाचा है। जिस किसी व्यक्ति का खतना नहीं होगा वह तुम्हारे लोगों से अलग कर दिया जाएगा। क्यों? क्योंकि उस व्यक्ति ने मेरी वाचा तोड़ी है।” ");
INSERT INTO hin2010_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","परमेश्वर ने इब्राहीम से कहा, “मैं सारै को जो तुम्हारी पत्नी है, नया नाम दूँगा। उसका नाम सारा होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","मैं उसे आशीर्वाद दूँगा। मैं उसे पुत्र दूँगा और तुम पिता होगे। वह बहुत से नए राष्ट्रों की माँ होगी। उससे राष्ट्रों के राजा पैदा होंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","इब्राहीम ने अपना सिर परमेश्वर को भक्ति दिखाने के लिए जमीन तक झुकाया। लेकिन वह हँसा और अपने से बोला, “मैं सौ वर्ष का बूढ़ा हूँ। मैं पुत्र पैदा नहीं कर सकता और सारा नब्बे वर्ष की बुढ़िया है। वह बच्चों को जन्म नहीं दे सकती।” ");
INSERT INTO hin2010_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","तब इब्राहीम के कहने का मतलब परमेश्वर से पूछा, “क्या इश्माएल जीवित रहे और तेरी सेवा करे?” ");
INSERT INTO hin2010_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","परमेश्वर ने कहा, “नहीं, मैंने कहा कि तुम्हारी पत्नी सारा पुत्र को जन्म देगी। तुम उसका नाम इसहाक रखोगे। मैं उसके साथ वाचा करूँगा। यह वाचा ऐसी होगी जो उसके सभी वंशजों के साथ सदा बनी रहेगी। ");
INSERT INTO hin2010_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“तुमने मुझसे इश्माएल के बारे में पूछा और मैंने तुम्हारी बात सुनी। मैं उसे आशीर्वाद दूँगा। उसके बहुत से बच्चे होंगे। वह बारह बड़े राजाओं का पिता होगा। उसका परिवार एक बड़ा राष्ट्र बनेगा। ");
INSERT INTO hin2010_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","मैं अपनी वाचा इसहाक के साथ बनाऊँगा। इसहाक ही वह पुत्र होगा जिसे सारा जनेगी। यह पुत्र अगले वर्ष इसी समय में पैदा होगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","परमेश्वर ने जब इब्राहीम से बात करनी बन्द की, इब्राहीम अकेला रह गया। परमेश्वर इब्राहीम के पास से आकाश की ओर उठ गया। ");
INSERT INTO hin2010_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","परमेश्वर ने कहा था कि तुम अपने कुटुम्ब के सभी लड़कों और पुरुषों का खतना कराना। इसलिए इब्राहीम ने इश्माएल और अपने घर में पैदा सभी दासों को एक साथ बुलाया। इब्राहीम ने उन दासों को भी एक साथ बुलाया जो धन से खरीदे गए थे। इब्राहीम के घर के सभी पुरुष और लड़के इकट्ठे हुए और उन सभी का खतना उसी दिन उनका माँस काट कर दिया गया। ");
INSERT INTO hin2010_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","जब खतना हुआ इब्राहीम निन्यानबे वर्ष का था ");
INSERT INTO hin2010_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","और उसका पुत्र इश्माएल खतना होने के समय तेरह वर्ष का था। ");
INSERT INTO hin2010_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","इब्राहीम और उसके पुत्र का खतना उसी दिन हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","उसी दिन इब्राहीम के सभी पुरुषों का खतना हुआ। इब्राहीम के घर में पैदा सभी दासों और खरीदे गए सभी दासों का खतना हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","बाद में यहोवा फिर इब्राहीम के सामने प्रकट हुआ। इब्राहीम मस्रे के बांज के पेड़ों के पास रहता था। एक दिन, दिन के सबसे गर्म पहर में इब्राहीम अपने तम्बू के दरवाज़े पर बैठा था। ");
INSERT INTO hin2010_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","इब्राहीम ने आँख उठा कर देखा और अपने सामने तीन पुरुषों को खड़े पाया। जब इब्राहीम ने उनको देखा, वह उनके पास गया और उन्हें प्रणाम किया। ");
INSERT INTO hin2010_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","इब्राहीम ने कहा, “महोदयों, आप अपने इस सेवक के साथ ही थोड़ी देर ठहरें। ");
INSERT INTO hin2010_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","मैं आप लोगों के पैर धोने के लिए पानी लाता हूँ। आप पेड़ों के नीचे आराम करें। ");
INSERT INTO hin2010_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","मैं आप लोगों के लिए कुछ भोजन लाटा हूँ और आप लोग जितना चाहें खाए। इसके बाद आप लोग अपनी यात्रा आरम्भ कर सकते हैं।” तीनों ने कहा, “यह बहुत अच्छा है। तुम जैसा कहते हो, करो।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","इब्राहीम जल्दी से तम्बू में घुसा। इब्राहीम ने सारा से कहा, “जल्दी से तीन रोटियों के लिए आटा तैयार करो।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","तब इब्राहीम अपने मवेशियों की ओर दौड़ा। इब्राहीम ने सबसे अच्छा एक जवान बछड़ा लिया। इब्राहीम ने बछड़ा नौकर को दिया। इब्राहीम ने नौकर से कहा कि तुम जल्दी करो, इस बछड़े को मारो और भोजन के लिए तैयार करो। ");
INSERT INTO hin2010_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","इब्राहीम ने तीनों को भोजन के लिए माँस दिया। उसने दूध और मक्खन दिया। जब तक तीनों पुरुष खाते रहे तब तक इब्राहीम पेड़ के नीचे उनके पास खड़ा रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","उन व्यक्तियों ने इब्राहीम से कहा, “तुम्हारी पत्नी सारा कहाँ है?” इब्राहीम ने कहा, “वह तम्बू में है।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","तब यहोवा ने कहा, “मैं बसन्त में फिर आऊँगा उस समय तुम्हारी पत्नी सारा एक पुत्र को जन्म देगी।” सारा तम्बू में सुन रही थी और उसने इन बातों को सुना। ");
INSERT INTO hin2010_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","इब्राहीम और सारा दोनों बहुत बूढ़े थे। सारा प्रसव की उम्र को पार कर चुकी थी। ");
INSERT INTO hin2010_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","सारा मन ही मन मुस्करायी। उसे अपने कानों पर विश्वास नहीं हुआ। उसने अपने आप से कहा, “मैं और मेरे पति दोनों ही बूढे हैं। मैं बच्चा जनने के लिए काफी बूढ़ी हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","तब यहोवा ने इब्राहीम से कहा, “सारा हंसी और बोली, ‘मैं इतनी बूढ़ी हूँ कि बच्चा जन नहीं सकती।’ ");
INSERT INTO hin2010_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","क्या यहोवा के लिए कुछ भी असम्भव है? नही, मैं फिर बसन्त में अपने बताए समय पर आऊँगा और तुम्हारी पत्नी सारा पुत्र जनेगी।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","लेकिन सारा ने कहा, “मैं हंसी नहीं।” (उसने ऐसा कहा, क्योंकि वह डरी हुई थी।) लेकिन यहोवा ने कहा, “नहीं, मैं मानता हूँ कि तुम्हारा कहना सही नहीं है। तुम ज़रूर हँसी।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","तब वे पुरुष जाने के लिए उठे। उन्होंने सदोम की ओर देखा और उसी ओर चल पड़े। इब्राहीम उनको विदा करने के लिए कुछ दूर तक उनके साथ गया। ");
INSERT INTO hin2010_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","यहोवा ने मन में कहा, “क्या मैं इब्राहीम से वह कह दूँ जो मैं अभी करूँगा? ");
INSERT INTO hin2010_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","इब्राहीम एक बड़ा और शक्तिशाली राष्ट्र बन जाएगा। इसी के कारण पृथ्वी के सारे मनुष्य आशीर्वाद पायेंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","मैंने इब्राहीम के साथ खास वाचा की है। मैंने यह इसलिए किया है कि वह अपने बच्चे और अपने वंशज को उस तरह जीवन बिताने के लिए आज्ञा देगा जिस तरह का जीवन बिताना यहोवा चाहता है। मैंने यह इसलिए किया कि वे सच्चाई से रहेंगे और भले बनेंगे। तब मैं यहोवा प्रतिज्ञा की गई चीज़ों को दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","तब यहोवा ने कहा, “मैंने बार—बार सुना है कि सदोम और अमोरा के लोग बहुत बुरे हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","इसलिए मैं वहाँ जाऊँगा और देखूँगा कि क्या हालत उतनी ही खराब है जितनी मैंने सुनी है। तब मैं ठीक—ठीक जान लूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","तब वे लोग मुड़े और सदोम की ओर चल पड़े। किन्तु इब्राहीम यहोवा के सामने खड़ा रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","तब इब्राहीम यहोवा से बोला, “हे यहोवा, क्या तू बुरे लोगों को नष्ट करने के साथ अच्छे लोगों को भी नष्ट करने की बात सोच रहा है? ");
INSERT INTO hin2010_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","यदि उस नगर में पचास अच्छे लोग हों तो क्या होगा? क्या तब भी तू नगर को नष्ट कर देगा? निश्चय ही तू वहाँ रहने वाले पचास अच्छे लोगों के लिए उस नगर को बचा लेगा। ");
INSERT INTO hin2010_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","निश्चय ही तू नगर को नष्ट नहीं करेगा। बुरे लोगों को मारने के लिए तू पचास अच्छे लोगों को नष्ट नहीं करेगा। अगर ऐसा हुआ तो अच्छे और बुरे लोग एक ही हो जाएँगे, दोनों को ही दण्ड मिलेगा। तू पूरी पृथ्वी को न्याय देने वाला हऐ। मैं जानता हूँ कि तू न्याय करेगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","तब यहोवा ने कहा, “यदि मुझे सदोम नगर में पचास अच्छे लोग मिले तो मैं पूरे नगर को बचा लूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","तब इब्राहीम ने कहा, “हे यहोवा, तेरी तुलना में, मैं केवल धूलि और राख हूँ। लेकिन तू मुझको फिर थोड़ा कष्ट देने का अवसर दे और मुझे यह पूछने दे कि ");
INSERT INTO hin2010_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","यदि पाँच अच्छे लोग कम हों तो क्या होगा? यददि नगर में पैंतालीस ही अच्छे लोग हो तो क्या होगा। क्या तू केवल पाँच लोगों के लिए पूरा नगर नष्ट करेगा?” तब यहोवा ने कहा, “यदि मुझे वहाँ पैंतालीस अच्छे लोग मिले तो मैं नगर को नष्ट नहीं करूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","इब्राहीम ने फिर यहोवा से कहा, “यदि तुझे वहाँ केवल चालीस अच्छे ओग मिले तो क्या तू नगर को नष्ट कर देगा?” यहोवा ने कहा, “यदि मुझे चालीस अच्छे लोग वहाँ मिले तो मैं नगर को नष्ट नहीं करूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","तब इब्राहीम ने कहा, “हे यहोवा कृपा करके मुझ पर नाराज़ न हो। मुझे यह पूछने दे कि यदि नगर में केवल तीस अच्छे लोग हो तो क्या तू नगर को नष्ट करेगा?” यहोवा ने कहा, “यदि मुझे तीस अच्छे लोग वहाँ मिले तो मैं नगर को नष्ट नहीं करूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","तब इब्राहीम ने कहा, “हे यहोवा, क्या मैं तुझे फिर कष्ट दूँ और पूछ लूँ कि यदि बीस ही अच्छे लोग वहाँ हुए तो?” यहोवा ने उत्तर दिया, “अगर मुझे बीस अच्छे लोग मिले तो मैं नगर को नष्ट नहीं करूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","तब इब्राहीम ने कहा, “हे यहोवा तू मुझसे नाराज़ न हो मुझे अन्तिम बार कष्ट देने का मौका दे। यदि तुझे वहाँ दस अच्छे लोग मिले तो तू क्या करेगा?” यहोवा ने कहा, “यदि मुझे नगर में दस अच्छे लोग मिले तो भी मैं नगर को नष्ट नहीं करूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","यहोवा न इब्राहीम से बोलना बन्द कर दिया, इसलिए यहोवा चला गया और इब्राहीम अपने घर लौट आया। ");
INSERT INTO hin2010_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","उनमें से दो स्वर्गदूत साँझ को सदोम नगर में आए। लूत नगर के द्वार पर बैठा था और उसने स्वर्गदूतों को देखा। लूत ने सोचा कि वे लोग अन्गर के बीच से यात्रा कर रहे हैं। लूत उठा और स्वर्गदूतों के पास गया तथा जमीन तक सामने झुका। ");
INSERT INTO hin2010_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","लूत ने कहा, “आप सब महोदय, कृप्या कर मेरे घर चलें और मैं आप लोगों की सेवा करूँगा। वहाँ आप लोग अपने पैर धो सकते हैं और रात को ठहर सकते हैं। तब कल आप लोग अपनी यात्रा आरम्भ कर सकते हैं।” स्वर्गदूतों ने उत्तर दिया, “नहीं, हम लोग रात को मैदान में ठहरेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","किन्तु लूत अपने घर चलने के लिए बार—बार कहता रहा। इस तरह स्वर्गदूत लूत के घर जाने के लिए तैयार हो गए। जब वे घर पहुँचे तो लूत उनके पीने के लिए कुछ लाया। लूत ने उनके लिए रोटियाँ बनाई। लूत का पकाया भोजन स्वर्गदूतों ने खाया। ");
INSERT INTO hin2010_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","उस शाम सोने के समय के पहले ही नगर के सभी भागों से लोग लूत के घर आए। सदोम के पुरुषों ने लूत का घर घेर लिया और बोले। ");
INSERT INTO hin2010_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","उन्होंने कहा, “आज रात को जो लोग तुम्हारे पास आए, वे दोनों पुरुष कहाँ हैं? उन पुरुषों को बाहर हमें दे दो। हम उनके साथ कुकर्म करना चाहते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","लूत बाहर निकला और अपने पीछे से उसने दरवाज़ा बन्द कर लिया। ");
INSERT INTO hin2010_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","लूत ने पुरुषों से कहा, “नहीं मेरे भाइयों मैं प्रार्थना करता हूँ कि आप यह बुरा काम न करें। ");
INSERT INTO hin2010_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","देखों मेरी दो पुत्रियाँ हैं, वे इसके पहले किसी पुरुष के साथ नहीं सोयी हैं। मैं अपनी पुत्रियों को तुम लोगों को दे देता हूँ। तुम लोग उनके साथ जो चाहो कर सकते हो। लेकिन इन व्यक्तियों के साथ कुछ न करो। ये लोग हमारे घर आए हैं और मैं इनकी रक्षा जरूर करूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","घर के चारों ओर के लोगों ने उत्तर दिया, “रास्ते से हट जाओ।” तब पुरुषों ने अपने मन में सोचा, “यह व्यक्ति लूत हमारे नगर में अतिथि के रूप में आया। अब यह सिखाना चाहता है कि हम लोग क्या करें।” तब लोगों ने लूत से कहा, “हम लोग उनसे भी अधिक तुम्हारा बुरा करेंगे।” इसलिए उन व्यक्तियों ने लूत को घेर कर उसके निकट आना शुरू किया। वे दरवाज़े को तोड़कर खोलना चाहते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","किन्तु लूत के साथ ठहरे व्यक्तियों ने दरवाज़ा खोला और लूत को घर के भीतर खींच लिया। तब उन्होंने दरवाज़ा बन्द कर लिया। ");
INSERT INTO hin2010_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","दोनों व्यक्तियों ने दरवाज़े के बाहर के पुरुषों को अन्धा कर दिया। इस तरह घर में घुसने की कोशिश करने वाले जवान व बूढ़े सब अन्धे हो गए और दरवाज़ा न पा सके। ");
INSERT INTO hin2010_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","दोनों व्यक्तियों ने लूत से कहा, “क्या इस नगर में ऐसा व्यक्ति है जो तुम्हारे परिवार का है? क्या तुम्हारे दामाद, तुम्हारा पुत्रियाँ या अन्य कोई तुम्हारे परिवार का व्यक्ति है? यदि कोई दूसरा इस नगर में तुम्हारे परिवार का है तो तुम अभी नगर छोड़ने के लिए कह दो। ");
INSERT INTO hin2010_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","हम लोग इस नगर को नष्ट करेंगे। यहोवा ने उन सभी बुराइयों को सुन लिया है जो इस नगर में है। इसलिए यहोवा ने हम लोगों को इसे नष्ट करने के लिए भेजा है।” ");
INSERT INTO hin2010_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","इसलिए लूत बाहर गया और अपनी अन्य पुत्रियों से विवाह करने वाले दामादों से बातें की। लूत ने कहा, “शीघ्रता करो और इस नगर को छोड़ दो।” यहोवा इसे तुरन्त नष्ट करेगा। लेकिन उन लोगों ने समझा कि लूत मज़ाक कर रहा है। ");
INSERT INTO hin2010_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","दूसरी सुबह को भोर के समय ही स्वर्गदूत लूत से जल्दी करने की कोशिश की। उन्होंने कहा, “देखो इस नगर को दण्ड मिलेगा। इसलिए तुम अपनी पत्नी और तुम्हारे साथ जो दो पुत्रियाँ जो अभी तक हैं, उन्हें लेकर इस जगह को छोड़ दो। तब तुम नगर के साथ नष्ट नहीं होगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","लेकिन लूत दुविधा में रहा और नगर छोड़ने की जल्दी उसने नहीं की। इसलिए दोनों स्वर्गदूतों ने लूत, उसकी पत्नी और उसकी दोनों पुत्रियों के हाथ पकड़ लिए। उन दोनों ने लूत और उसके परिवार को नगर के बाहर सुरक्षित स्थान में पहुँचाया। लूत और उसके परिवार पर यहोवा की कृपा थी। ");
INSERT INTO hin2010_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","इसलिए दोनों ने लूत और उसके परिवार को नगर के बाहर पहुँचा दिया। जब वे बाहर हो गए तो उनमें से एक ने कहा, “अपना जीवन बचाने के लिए अब भागो। नगर को मुड़कर भी मत देखो। इस घाटी में किसी जगह न रूको। तब तक भागते रहो जब तक पहाड़ों में न जा पहुँचो। अगर तुम ऐसा नहीं करते, तो तुम नगर के साथ नष्ट हो जाओगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","तब लूत ने दोनों से कहा, “महोदयों, कृपा करके इतनी दूर दौड़ने के लिए विवश न करें। ");
INSERT INTO hin2010_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","आप लोगों ने मुझ सेवक पर इतनी अधिक कृपा की है। आप लोगों ने मुझे बचाने की कृपा की है। लेकिन मैं पहाड़ी तक दौड़ नहीं सकता। अगर मैं आवश्यकता से अधिक धीरे दौड़ा तो कुछ बुरा होगा और मैं मारा जाऊँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","लेकिन देखें यहाँ पास में एक बहुत छोटा नगर है। हमें उस नगर तक दौड़ने दें। तब हमारा जीवन बच जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","स्वर्गदूत ने लूत से कहा, “ठीक है, मैं तुम्हें ऐसा भी करने दूँगा। मैं उस नगर को नष्ट नहीं करूँगा जिसमें तुम जा रहे हो। ");
INSERT INTO hin2010_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","लेकिन वहाँ तक तेज दौड़ो। मैं तब तक सदोम को नष्ट नहीं करूँगा जब तक तुम उस नगर में सुरक्षित नहीं पहुँच जाते।” (इस नगर का नाम सोअर है, क्योंकि यह छोटा है।) ");
INSERT INTO hin2010_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","जब लूत सोअर में घुस रहा था, सबेरे का सूरज चमकने लगा ");
INSERT INTO hin2010_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","और यहोवा ने सदोम और अमोरा को नष्ट करना आरम्भ किया। यहोवा ने आग तथा जलते हुए गन्धक को आकाश से नीचें बरसाया। ");
INSERT INTO hin2010_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","इस तरह यहोवा ने उन नगरों को जला दिया और पूरी घाटी के सभी जीवित मनुष्यों तथा सभी पेड़ पौधों को भी नष्ट कर दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","जब वे भाग रहे थे, तो लूत की पत्नी ने मुड़कर नगर को देखा। जब उसने मुड़कर देखा तब वह एक नमक की ढेर हो गई। ");
INSERT INTO hin2010_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","उसी दिन बहुत सबेरे इब्राहीम उठा और उस जगह पर गया जहाँ वह यहोवा के सामने खड़ा होता था। ");
INSERT INTO hin2010_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","इब्राहीम ने सदोम और अमोरा नगरों की ओर नज़र डाली। इब्राहीम ने उस घाटी की पूरी भूमि की ओर देखा। इब्राहीम ने उस प्रदेश से उठते हुए घने धुँए को देखा। बड़ी भयंकर आग से उठते धुँए के समान वह दिखाई पड़ा। ");
INSERT INTO hin2010_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","घाटी के नगरों को परमेश्वर ने नष्ट कर दिया। जब परमेश्वर ने यह किया तब इब्राहीम ने जो कुछ माँगा था उसे उसने याद रखा। परमेश्वर ने लूत का जीवन बचाया लेकिन परमेश्वर ने उस नगर को नष्ट कर दिया जिसमें लूत रहता था। ");
INSERT INTO hin2010_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","लूत सोअर में लगातार रहने से डरा। इसलिए वह और उसकी दोनों पुत्रियाँ पहाड़ों में गई और वहीं रहने लगी। वे वहाँ एक गुफा में रहते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","एक दिन बड़ी पुत्री ने छोटी से कहा, “पृथ्वी पर चारों ओर पुरुष और स्त्रियाँ विवाह करते हैं। लेकिन यहाँ आस पास कोई पुरुष नहीं है जिससे हम विवाह करें। हम लोगों के पिता बूढ़े हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","इसलिए हम लोग अपने पिता का उपयोग बच्चों को जन्म देने के लिए करें जिससे हम लोगों का वंश चल सके। हम लोग अपने पिता के पास चलेंगे और दाखरस पिलायेंगे तथा उसे मदहोश कर देंगे। तब हम उसके साथ सो सकते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","उस रात दोनों पुत्रियाँ अपने पिता के पास गई और उसे उन्होंने दाखरस पिलाकर मदहोश कर दिया। तब बड़ी पुत्री पिता के बिस्तर में गई और उसके साथ सोई। लूत अधिक मदहोश था इसलिए यह न जान सका कि वह उसके साथ सोया। ");
INSERT INTO hin2010_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","दूसरे दिन बड़ी पुत्री ने छोटी से कहा, “पिछली रात मैं अपने पिता के साथ सोई। आओ इस रात फिर हम उसे दाखरस पिलाकर मदहोश कर दें। तब तुम उसके बिस्तर में जा सकती हो और उसके साथ सो सकती हो। इस तरह हम लोगों को अपने पिता का उपयोग बच्चों को जन्म देकर अपने वंश को चलाने के लिए करना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","इसलिए उन दोनों पुत्रियों ने अपने पिता को दाखरस पिलाकर मदहोश कर दिया। तब छोटी पुत्री उसके बिस्तर में गई और उसके पास सोई। लूत इस बार भी न जान सका कि उसकी पुत्री उसके साथ सोई। ");
INSERT INTO hin2010_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","इस तरह लूत की दोनों पुत्रियाँ गर्भवती हुईं। उनका पिता ही उनके बच्चों का पिता था। ");
INSERT INTO hin2010_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","बड़ी पुत्री ने एक पुत्र को जन्म दिया। उसने लड़के का नाम मोआब रखा। मोआब उन सभी मोआबी लोगों का पिता है, जो अब तक रह रहे हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","छोटी पुत्री ने भी एक पुत्र जना। इसने अपने पुत्र का नाम बेनम्मी रखा। बेनम्मी अभी उन सबी अम्मोनी लोगों का पिता है जो अब तक रह रहे हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","इब्राहीम ने उस जगह को छोड़ दिया और नेगेव की यात्रा की। इब्राहीम कादेश और शूर के बीच गरार में बस गया। ");
INSERT INTO hin2010_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","गरार में इब्राहीम ने लोगों से कहा कि सारा मेरी बहन है। गरार के राजा अबीमेलेक ने यह बात सुनी। अबीमेलेक सारा को चाहता था इसलिए उसने कुछ नौकर उसे लाने के लिए भेजे। ");
INSERT INTO hin2010_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","लेकिन एक रात परमेश्वर ने अबीमेलेक से स्वप्न में बात की। परमेश्वर ने कहा, “देखो, तुम मर जाओगे। जिस स्त्री को तुमने लिया है उसका विवाह हो चुका है।” ");
INSERT INTO hin2010_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","लेकिन अबीमेलेक अभी सारा के साथ नहीं सोया था। इसलिए अबीमेलेक ने कहा, “हे यहोवा, मैं दोषी नहीं हूँ। क्या तू निर्दोष व्यक्ति को मारेगा। ");
INSERT INTO hin2010_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","इब्राहीम ने मुझसे खुद कहा, ‘यह स्त्री मेरी बहन है’ और स्त्री ने भी कहा, ‘यह पुरुष मेरा भाई है।’ मैं निर्दोष हूँ। मैं नहीं जानता था कि मैं क्या कर रहा हूँ?” ");
INSERT INTO hin2010_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","तब परमेश्वर ने अबीमेलेक से स्वप्न में कहा, “हाँ, मैं जानता हूँ कि तुम निर्दोष हो और मैं यह भी जानता हूँ कि तुम यह नहीं जानते थे कि तुम क्या कर रहे थे? मैंने तुमको बचाया। मैंने तुम्हें अपने विरुद्ध पाप नहीं करने दिया। यह मैं ही था जिसने तुम्हें उसके साथ सोने नहीं दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","इसलिए इब्राहीम को उसकी पत्नी लौटा दो। इब्राहीम एक नबी है। वह तुम्हारे लिए प्रार्थना करेगा और तुम जीवित रहोगे किन्तु यदि तुम सारा को नहीं लौटाओगे तो मैं शाप देता हूँ कि तुम मर जाओगे। तुम्हारा सारा परिवार तुम्हारे साथ मर जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","इसलिए दूसरे दिन बहुत सबेरे अबीमेलेक ने अपने सभी नौकरों को बुलाया। अबीमेलेक ने सप्ने में हुई सारी बातें उनको बताई। नौकर बहुत डर गए। ");
INSERT INTO hin2010_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","तब अबीमेलेक ने इब्राहीम को बुलाया और उससे कहा, “तुमने हम लोगों के साथ ऐसा क्यों किया? मैंने तुम्हारा क्या बिगाड़ा था? तुम ने यह झूठ क्यों बोला कि वह तुम्हारी बहन है। तुमने हमारे राज्य पर बहुत बड़ी विपत्ति ला दी है। यह बात तुम्हें मेरे साथ नहीं करनी चाहिए थी। ");
INSERT INTO hin2010_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","तुम किस बात से डर रहे थे? तुमने ये बातें मेरे साथ क्यों की?” ");
INSERT INTO hin2010_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","तब इब्राहीम ने कहा, “मैं डरता था। क्योंकि मैंने सोचा कि यहाँ कोई भी परमेश्वर का आदर नहीं करता। मैंने सोचा कि सारा को पाने के लिए कोई मुझे मार डालेगा। ");
INSERT INTO hin2010_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","वह मेरी पत्नी है, किन्तु वह मेरी बहन भी है। वह मेरे पिता की पुत्री तो है परन्तु मेरी माँ की पुत्री नहीं है। ");
INSERT INTO hin2010_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","परमेश्वर ने मुझे पिता के घर से दूर पहुँचाया है। परमेश्वर ने कोई अलग—अलग प्रदेशों में मुझे भटकाया। जब ऐसा हुआ तो मैंने सारा से कहा, ‘मेरे लिए कुछ करो, लोगों से कहो कि तुम मेरी बहन हो।’” ");
INSERT INTO hin2010_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","तब अबीमेलेक ने जाना कि क्या हो चुका है। इसलिए अबीमेलेक ने इब्राहीम को सारा लौटा दी। अबीमेलेक ने इब्राहीम को कुछ भेड़ें, मवेशी तथा दास भी दिए। ");
INSERT INTO hin2010_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","अबीमेलेक ने कहा, “तुम चारों और देख लो। यह मेरा देश है। तुम जिस जगह चाहो, रह सकते हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","अबीमेलेक ने सारा से कहा, “देखो, मैंने तुम्हारे भाई को एक हजार चाँदी के टुकड़े दिए हैं। मैंने यह इसलिए किया कि जो कुछ हुआ उससे मैं दुःखी हूँ। मैं चाहता हूँ कि हर एक व्यक्ति यह देखें कि मैंने अच्छे काम किए हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","परमेश्वर ने अबीमेलेक के परिवार की सभी स्त्रियों को बच्चा जनने के अयोग्य बनाया। परमेश्वर ने वह इसलिए किया कि उसने इब्राहीम की पत्नी सारा को रख लिया था। लेकिन इब्राहीम ने परमेश्वर से प्रार्थना की और परमेश्वर ने अबीमेलेक, उसकी पत्नियों और दास—कन्याओं को स्वस्थ कर दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","यहोवा ने सारा को यह वचन दिया था कि वह उस पर कृपा करेगा। यहोवा अपने वचन के अनुसार उस पर दयालु हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","सारा गर्भवती हुई और बुढ़ापे में इब्राहीम के लिए एक बच्चा जनी। सही समय पर जैसा परमेश्वर ने वचन दिया था वैसा ही हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","सारा ने पुत्र जना और इब्राहीम ने उसका नाम इसहाक रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","परमेश्वर की आज्ञा के अनुसार इब्राहीम ने आठ दिन का होने पर इसहाक का खतना किया। ");
INSERT INTO hin2010_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","इब्राहीम सौ वर्ष का था जब उसका पुत्र इसहाक उत्पन्न हुआ ");
INSERT INTO hin2010_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","और सारा ने कहा, “परमेश्वर ने मुझे सुखी बना दिया है। हर एक व्यक्ति जो इस बारे में सुनेगा वह मुझसे खुश होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","कोई भी यह नहीं सोचता था कि सारा इब्राहीम को उसके बुढ़ापे के लिए उसे एक पुत्र देगी। लेकिन मैंने बूढ़े इब्राहीम को एक पुत्र दिया है।” ");
INSERT INTO hin2010_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","अब बच्चा इतना बड़ा हो गया कि माँ का दूध छोड़ वह ठोस भोजन खाना शुरू करे। जिस दिन उसका दूध छुड़वाया गया उस दिन इब्राहीम ने एक बहुत बड़ा भोज रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","सारा ने हाजिरा के पुत्र को खेलते हुए देखा। (बीते समय में मिस्री दासी हाजिरा ने एक पुत्र को जन्म दिया था। इब्राहीम उस पुत्र का भी पिता था।) ");
INSERT INTO hin2010_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","इसलिए सारा ने इब्राहीम से कहा, “उस दासी स्त्री तथा उसके पुत्र को यहाँ से भेज दो। जब हम लोग मरेंगे हम लोगों की सभी चीज़ें इसहाक को मिलेंगी। मैं नहीं चाहती कि उसका पुत्र इसहाक के साथ उन चीज़ों में हिस्सा ले।” ");
INSERT INTO hin2010_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","इन सभी बातों ने इब्राहीम को बहुत दुःखी कर दिया। वह अपने पुत्र इश्माएल के लिए दुःखी था। ");
INSERT INTO hin2010_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","किन्तु परमेश्वर ने इब्राहीम से कहा, “उस लड़के के बारे में दुःखी मत होओ। उस दासी स्त्री के बारे में भी दुःखी मत होओ। जो सारा चाहती है तुम वही करो। तुम्हारा वंश इसहाक के वंश से चलेगा। ");
INSERT INTO hin2010_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","लेकिन मैं तुम्हारी दासी के पुत्र को भी अशीर्वाद दूँगा। वह तुम्हारा पुत्र है इसलिए मैं उसके परिवार को भी एक बड़ा राष्ट्र बनाऊँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","दूसरे दिन बहुत सवेरे इब्राहीम ने कुछ भोजन और पानी लिया। इब्राहीम ने यह चीज़ें हाजिरा को दे दी। हाजिरा ने वे चीज़ें ली और बच्चे के साथ वहाँ से चली गई। हाजिरा ने वह स्थान छोड़ा और वह बेर्शेबा की मरुभूमि में भटकने लगी। ");
INSERT INTO hin2010_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","कुछ समय बाद हाजिरा का सारा पानी स्माप्त हो गया। पीने के लिए कुछ भी पानी न बचा। इसलिए हाजिरा ने अपने बच्चे को एक झाड़ी के नीचे रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","हाजिरा वहाँ से कुछ दूर गई। तब वह रुकी और बैठ गई। हाजिरा ने सोचा कि उसका पुत्र मर जाएगा क्योंकि वहाँ पानी नहीं था। वह उसे मरता हुआ देखना नहीं चाहती थी। वह वहाँ बैठ गई और रोने लगी। ");
INSERT INTO hin2010_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","परमेश्वर ने बच्चे का रोना सुना। स्वर्ग से एक दूत हाजिरा के पास आया। उसने पूछा, “हाजिरा, तुम्हें क्या कठिनाई हाय। परमेश्वर ने वहाँ बच्चे का रोना सुन लिया। ");
INSERT INTO hin2010_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","जाओ, और बच्चे को संभालो। उसका हाथ पकड़ लो और उसे साथ ले चलो। मैं उसे बहुत से लोगों का पिता बनाऊँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","परमेश्वर ने हाजिरा की आँखे इस प्रकार खोली कि वह एक पानी का कुआँ देख सकी। इसलिए कुएँ पर हाजिरा गई और उसके थैले को पानी से भर लिया। तब उसने बच्चे को पीने के लिए पानी दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","बच्चा जब तक बड़ा न हुआ तब तक परमेश्वर उसके साथ रहा। इश्माएल मरुभूमि में रहा और एक शिकारी बन गया। उसने बहुत अच्छा तीर चलाना सीख लिया। ");
INSERT INTO hin2010_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","उसकी माँ मिस्र से उसके लिए दुल्हन लाई। वे पारान मरुभूमि में रहने लगे। ");
INSERT INTO hin2010_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","तब अबीमेलेक और पीकोल ने इब्राहीम से बातें की। पीकोल अबीमेलेक की सेना का सेनापति था। उन्होंने इब्राहीम से कहा, “तुम जो कुछ करते हो, परमेश्वर तुम्हारा साथ देता है। ");
INSERT INTO hin2010_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","इसलिए तुम परमेश्वर के सामने वचन दो। यह वचन दो कि तुम मेरे और मेरे बच्चों के लिए भले रहोगे। तुम यह वचन दो कि तुम मेरे प्रति और जहाँ रहे हो उस देश के प्रति दयालु रहोगे। तुम यह भी वचन दो कि मैं तुम्हारे प्रति जितना दयालु रहा उतना तुम मुझ पर भी दयालु रहोगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","इब्राहीम ने कहा, “मैं वचन देता हूँ कि तुमसे मैं वैसा ही व्यवहार करूँगा जैसा तुमने मेरे साथ व्यवहार किया है।” ");
INSERT INTO hin2010_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","तब इब्राहीम ने अबीमेलेक से शिकायत की। इब्राहीम ने इसलिए शिकायत की कि अबीमेलेक के नौकरों ने पानी के एक कुएँ पर कब्ज़ा कर लिया था। ");
INSERT INTO hin2010_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","अबीमेलेक ने कहा, “इसके बारे में मैंने यह पहली बार सुना है! मुझे नहीं पता है, कि यह किसने किया है, और तुमने भी इसकी चर्चा मुझसे इससे पहले कभी नहीं की।” ");
INSERT INTO hin2010_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","इसलिए इब्राहीम और अबीमेलेक ने एक सन्धि की। ");
INSERT INTO hin2010_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","इब्राहीम ने सन्धि के प्रमाण के रूप में अबीमेलेक को कुछ भेड़े और मवेशी दिए। इब्राहीम सात मादा मेमने भी अबीमेलेक के सामने लाया। ");
INSERT INTO hin2010_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","अबीमेलेक ने इब्राहीम से पूछा, “तुम ये सात मादा मेमने अलग क्यों दे रहे हो?” ");
INSERT INTO hin2010_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","इब्राहीम ने कहा, “जब तुम इन सात मेमनों को मुझसे लोगे तो यह सबूत रहेगा कि यह कुआँ मैंने खोदा है।” ");
INSERT INTO hin2010_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","इसलिए इसके बाद वह कुआँ बेर्र्शेबा कहलाया। उन्होंने कुएँ को यह नाम दिया क्योंकि यह वह जगह थी जहाँ उन्होंने एक दूसरे को वचन दिया था। ");
INSERT INTO hin2010_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","इस प्रकार इब्राहीम और अबीमेलेक ने बेर्शेबा में सन्धि की। तब अबीमेलेक और सेनापति दोनों पलिश्तियों के प्रदेश में लौट गए। ");
INSERT INTO hin2010_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","इब्राहीम ने बेर्शेबा में एक विशेष पेड़ लगाया। उस जगह इब्राहीम ने यहोवा परमेश्वर से प्रार्थना की ");
INSERT INTO hin2010_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","और इब्राहीम पलिश्तियों के देश में बहुत समय तक रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","इन बातों के बाद परमेश्वर ने इब्राहीम के विश्वास की परीक्षा लेना तय किया। परमेश्वर ने उससे कहा, “इब्राहीम!” और इब्राहीम ने कहा, “हाँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","परमेश्वर ने कहा, “अपना पुत्र लो, अपना एकलौता पुत्र, इसहाक जिससे तुम प्रेम करते हो मोरिय्याह पर जाओ, तुम उस पहाड़ पर जाना जिसे मैं तुम्हें दिखाऊँगा। वहाँ तुम अपन पुत्र को मारोगे और उसको होमबलि स्वरूप मुझे अर्पण करोगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","सवेरे इब्राहीम उठा और उसने गधे को तैयार किया। इब्राहीम ने इसहाक और दो नौकरों को साथ लिया। इब्राहीम ने बलि के लिए लकड़ियाँ काटकर तैयार कीं। तब वे उस जगह गए जहाँ जाने के लिए परमेश्वर ने कहा। ");
INSERT INTO hin2010_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","उनकी तीन दिन की यात्रा के बाद इब्राहीम ने ऊपर देखा और दूर उस जगह को देखा जहाँ वे जा रहे थे। ");
INSERT INTO hin2010_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","तब इब्राहीम ने अपने नौकरों से कहा, “यहाँ गधे के साथ ठहरो। मैं अपने पुत्र को उस जगह ले जाऊँगा और उपासना करूँगा। तब हम बाद में लौट आएगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","इब्राहीम ने बलि के लिए लकड़ियाँ ली और इन्हें पुत्र के कन्धों पर रखा। इब्राहीम ने एक विशेष छुरी और आग ली। तब इब्राहीम और उसका पुत्र दोनों उपासना के लिए उस जगह एक साथ गए। ");
INSERT INTO hin2010_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","इसहाक ने अपने पिता इब्राहीम से कहा, “पिताजी!” इब्राहीम ने उत्तर दिया, “हाँ, पुत्र।” इसहाक ने कहा, “मैं लकड़ी और आग तो देखता हूँ, किन्तु वह मेमना कहाँ है जिसे हम बलि के रूप में जलाएगे?” ");
INSERT INTO hin2010_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","इब्राहीम ने उत्तर दिया, “पुत्र परमेश्वर बलि के लिए मेमना स्वयं जुटा रहा हऐ।” इस तरह इब्राहीम और उसका पुत्र उस जगह साथ—साथ गए। ");
INSERT INTO hin2010_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","वे उस जगह पर पहुँचे जहाँ परमेश्वर ने पहुँचने को कहा था। वहाँ इब्राहीम ने एक बलि की वेदी बनाई। इब्राहीम ने वेदी पर लकड़ियाँ रखी। तब इब्राहीम ने अपने पुत्र को बाँधा। इब्राहीम ने इसहाक को वेदी की लकड़ियों पर रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","तब इब्राहीम ने अपनी छुरी निकाली और अपने पुत्र को मारने की तैयारी की। ");
INSERT INTO hin2010_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","तब यहोवा के दूत ने इब्राहीम को रोक दिया। दूत ने स्वर्ग से पुकारा और कहा, “इब्राहीम, इब्राहीम।” इब्राहीम ने उत्तर दिया, “हाँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","दूत ने कहा, “तुम अपने पुत्र को मत मारो अथवा उस किसी प्रकार की चोट न पहुँचाओ। मैंने अब देख लिया कि तुम परमेश्वर का आदर करते हो और उसकी आज्ञा मानते हो। मैं देखता हूँ कि तुम अपने एक लौते पुत्र को मेरे लिए मारने के लिए तैयार हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","इब्राहीम ने ऊपर दृष्टि की और एक मेढ़े को देखा। मेढ़े के सींगे एक झाड़ी में फँस गए थे। इसलिए इब्राहीम वहाँ गया, उसे पकड़ा और उसे मार डाला। इब्राहीम ने मेढ़े को अपने पुत्र के स्थान पर बलि चढ़ाया। इब्राहीम का पुत्र बच गया। ");
INSERT INTO hin2010_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","इसलिए इब्राहीम ने उस जगह का नाम “यहोवा यिरे” रखा। आज भी लोग कहते हैं, “इस पहाड़ पर यहोवा को देखा जा सकता है।” ");
INSERT INTO hin2010_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","यहोवा के दूत ने स्वर्ग से इब्राहीम को दूसरी बार पुकारा। ");
INSERT INTO hin2010_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","दूत ने कहा, “तुम मेरे लिए अपने पुत्र को मारने के लिए तैयार थे। यह तुम्हारा एकलौता पुत्र था। तुमने मेरे लिए ऐसा किया है इसलिए मैं, यहोवा तुमको वचन देता हूँ कि, ");
INSERT INTO hin2010_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","मैं तुम्हें निश्चय ही आशीर्वाद दूँगा। मैं तुम्हें उतने वंशज दूँगा जितने आकाश में तारे हैं। ये इतने अधिक लोग होंगे जितने समुद्र के तट पर बालू के कण और तुम्हारे लोग अपने सभी शत्रुओं को हराएगे। ");
INSERT INTO hin2010_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","संसार के सभी राष्ट्र तुम्हारे परिवार के द्वारा आशीर्वाद पाएँगे। मैं यह इसलिए करूँगा क्योंकि तुमने मेरी आज्ञा का पालन किया।” ");
INSERT INTO hin2010_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","तब इब्राहीम अपने नौकरों के पास लौटा। उन्होंने बेर्शेबा तक वापसी यात्रा की और इब्राहीम वहीं रहने लगा। ");
INSERT INTO hin2010_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","इसके बाद, इब्राहीम को यह खबर मिली। खबर यह थी, “तुम्हारे भाई नाहोर और उसकी पत्नी मिल्का के अब बच्चे हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","पहला पुत्र ऊस है। दूसरा पुत्र बूज है। तीसरा पुत्र अराम का पिता कमूएल है। ");
INSERT INTO hin2010_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","इसके अतिरिक्त केसेद, हजो, पिल्दाश, यिदलाप और बतूएल है।” ");
INSERT INTO hin2010_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","बतूएल, रिबका का पिता था। मिल्का इन आठ पुत्रों की माँ थी और नाहोर पिता था। नाहोर इब्राहीम का भाई था। ");
INSERT INTO hin2010_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","नाहोर के दूसरे चार लड़के उसकी एक रखैल रुमा से थे। ये पुत्र तेबह, गहम, तहश, माका थे। ");
INSERT INTO hin2010_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा एक सौ सत्ताईस वर्ष तक जीवित रही। ");
INSERT INTO hin2010_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","वह कनान प्रदेश के किर्यतर्बा (हेब्रोन) नगर में मरी। इब्राहीं बहुत दुःखी हुआ और उसके लिए वहाँ रोया। ");
INSERT INTO hin2010_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","तब इब्राहीम ने अपनी मरी पत्नी को छोड़ा और हित्ती लोगों से बात करने गया। उसने कहा, ");
INSERT INTO hin2010_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“मैं इस प्रदेश में नहीं रहता। मैं यहाँ केवल एक यात्री हूँ। इसलिए मेरे पास अपनी पत्नी को दफनाने के लिए कोई जगह नहीं है। मैं कुछ भूमि चाहता हूँ जिसमें अपनी पत्नी को दफना सकूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","हित्ती लोगों ने इब्राहीम को उत्तर दिया, ");
INSERT INTO hin2010_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“महोदय, आप हम लोगों के बीच परमेश्वर के प्रमुख व्यक्तियों में से एक हैं। आप अपने मरे को दफनाने के लिए सबसे अच्छी जगह, जो हम लोगों के पास है, ले सकते हैं। आप हम लोगों की कोई भी दफनाने की जगह, जो आप चाहते हैं, ले सकते हैं। हम लोगों मे से कोई भी आपको पत्नी को दफनाने से नहीं रोकेगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","इब्राहीम उठा और लोगों की तरफ सिर झुकाया। ");
INSERT INTO hin2010_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","इब्राहीम ने उनसे कहा, “यदि आप लोग सचमुच मेरी मरी हुई पत्नी को दफनाने में मेरी मद्द करना चाहते हैं तो सोहर के पुत्र एप्रोन से मेरे लिए बात करें। ");
INSERT INTO hin2010_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","मैं मकपेला की गुफा को खरीदना पसन्द करूँगा। एप्रोन इसका मालिक है। यह उसके खेत के सिरे पर है। मैं इसके मूल्य के अनुसार उसे पूरी कीमत दूँगा। मैं चाहता हूँ कि आप लोग इस बात के गवाह रहे कि मैं इस भूमि को कब्रिस्तान के रूप में खरीद रहा हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","एप्रोन वहीं लोगों के बीच बैठा था। एप्रोन ने इब्राहीम को उत्तर दिया, ");
INSERT INTO hin2010_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“नहीं, महोदय। मैं आपको भूमि दूँगा। मैं आपको वह गुफा दूँगा। मैं यह आपको इसलिए दूँगा कि आप इसमें अपनी पत्नी को दफना सकें।” ");
INSERT INTO hin2010_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","तब इब्राहीम ने हित्ती लोगों के सामने अपना सिर झुकाया। ");
INSERT INTO hin2010_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","इब्राहीम ने सभी लोगों के सामने एप्रोन से कहा, “किन्तु मैं तो खेत की पूरी कीमत देना आहता हूँ। मेरा धन स्वीकार करें। मैं अपने मरे हुए को इसमें दफनाऊँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","एप्रोन ने इब्राहीम को उत्तर दिया, ");
INSERT INTO hin2010_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“महोदय, मेरी बात सुनें। चार सौ चाँदी के शेकेल हमारे और आपके लिए क्या अर्थ रखते हैं? भूमि लें और अपनी मरी पत्नी को दफनाएँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","इब्राहीम ने समझा कि एप्रोन उसे भूमि की कीमत बता रहा है, इसलिए हित्ती लोगों को गवाह मानकर, इब्राहीम ने चाँदी के चार सौ शेकेल एप्रोन के लिए तौले। इब्राहीम ने पैसा उस व्यापारी को दे दिया जो इस भूमि के बेचने का धन्धा कर रहा था। ");
INSERT INTO hin2010_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","इस प्रकार एप्रोन के खेत के मालिक बदल गए। वह खेत मस्रे के पूर्व मकपेला में था। नगर के सभी लोगों ने एप्रोन और इब्राहीम के बीच हुई वाचा को देखा। ");
INSERT INTO hin2010_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","इसके बाद इब्राहीम ने अपनी पत्नी सारा को मम्रे कनान प्रदेश में (हेब्रोन) के निकट उस खेत की गुफा में दफनाया। ");
INSERT INTO hin2010_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","इब्राहीम ने खेत और उसकी गुफा को हित्ती लोगों से खरीद। यह उसकी सम्पत्ति हो गई, और उसने इसका प्रयोग कब्रिस्तान के रूप में किया। ");
INSERT INTO hin2010_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","इब्राहीम बहुत बुढ़ापे तक जीवित रहा। यहोवा ने इब्राहीम को आशीर्वाद दिया और उसके हर काम में उसे सफलता प्रदान की। ");
INSERT INTO hin2010_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","इब्राहीम का एक बहुत पुराना नौकर था जो इब्राहीम का जो कुछ था उसका प्रबन्धक था। इब्राहीम ने उस नौकर को बुलाया और कहा, “अपने हाथ मेरी जांघों के नीचे रखो। ");
INSERT INTO hin2010_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","अब मैं चाहता हूँ कि तुम मुझे एक वचन दो। धरती और आकाश के परमेश्वर यहोवा के सामने तुम वचन दो कि तुम अकनान की किसी लड़की से मेरे पुत्र का विवाह नहीं होने दोगे। हम लोग उनके बीच रहते हैं, किन्तु एक कनानी लड़की से उसे विवाह न करने दो। ");
INSERT INTO hin2010_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","तुम मेरे देश और मेरे अपने लोगों में लौटकर जाओ। वहाँ मेरे पुत्र इसहाक के लिए एक दुल्हन खोजो। तब उसे यहाँ उसके पास लाओ।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","नौकर ने उससे कहा, “यह हो सकता है कि वह दुल्हन मेरे साथ इस देश में लौटना न चाहे। तब, क्या मैं तुम्हारे पुत्र को तुम्हारी जन्मभूमि को ले जाऊँ?” ");
INSERT INTO hin2010_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","इराहीम ने उससे कहा, “नहीं, तुम हमारे पुत्र को उस देश में न ले जाओ। ");
INSERT INTO hin2010_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","यहोवा, स्वर्ग का परमेश्वर मुझे मेरी जन्मभूमि से यहाँ लाया। वह देश मेरे पुइता और मेरे परिवार का घर था। किन्तु यहोवा ने यह वचन दिया कि वह नया प्रदेश मेरे परिवार वालों का होगा। यहोवा अपना एक दूत तुम्हारे सामने भेजे जिससे तुम मेरे पुत्र के लिए दुल्हन चुन सको। ");
INSERT INTO hin2010_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","किन्तु यदि लड़की तुम्हारे साथ आना मना करे तो तुम अपने वचन से छुटकारा पा जाओगे। किन्तु तुम मेरे पुत्र को उस देश में वापस मत ले जाना।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","इस प्रकार नौकर ने अपने मालिक की जांघों के नीचे अपना हाथ रखकर वचन दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","नौकर ने इब्राहीम के दस ऊँट लिए और उस जगह से वह चला गया। नौकर कई प्रकार की सुन्दर भेंटें अपने साथ ले गया। वह नाहोर के नगर मेसोपोटामिया को गया। ");
INSERT INTO hin2010_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","वह नगर के बाहर के कुएँ पर ग्या। यह बात शाम को हुई जब स्त्रियाँ पानी भरने के लिए बाहर आती हैं। नौकर ने वहीं ऊँटों को घुटनों के बल बिठाया। ");
INSERT INTO hin2010_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","नौकर ने कहा, “हे यहोवा, तू मेरे स्वामी इब्राहीम का परमेश्वर है। आज तू उसके पुत्र के लिए मुझे एक दुल्हन प्राप्त करा। कृप्या मेरे स्वामी इब्राहीम पर यह दया कर। ");
INSERT INTO hin2010_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","मैं यहाँ इस जल के कुएँ के पास खड़ा हूँ और पानी भरने के लिए नगर से लड़कियाँ आ रहीं हैम। ");
INSERT INTO hin2010_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","मैं एक विशेष चिन्ह की प्रतीक्षा कर रहा हूँ जिससे मैं जान सकूँ कि इसहाक के लिए कौन सी लड़की ठीक है। यह विशेष चिन्ह है: मैं लड़की से कहूँगा ‘कृप्या कर आप घड़े को नीचे रखे जिससे मैं पानी पी सकूँ।’ मैं तब समझूँगा कि यह ठीक लड़की हऐ जब वह कहेगी, ‘पीओ, और मैं तुम्हारे ऊँटों के लिए भी पानी दूँगी।’ यदि ऐसा होगा तो तू प्रमाणित कर देगा कि इसहाक के लिए यह लड़की ठीक है। मैं समझूँगा कि तूने मेरे स्वामी पर कृपा की है।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","तब नौकर की प्रार्थना पूरी होने के पहले ही रिबका नाम की एक लड़की कुएँ पर आई। रिबका बतूएल की पुत्री थी। (बतूएल इब्राहीम के भाई नाहोर और मिल्का का पुत्र था।) रिबका अपने कंधे पर पानी का घड़ा लेकर कुएँ पर आई थी। ");
INSERT INTO hin2010_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","लड़की बहुत सुन्दर थी। वह कुँवारी थी। वह किसी पुरुष के साथ कभी नहीं सोई थी। वह अपना घड़ा भरने के लिए कुएँ पर आई। ");
INSERT INTO hin2010_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","तब नौकर उसके पास तक दौड़ कर गया और बोला, “कृप्या करके अपने घड़े से पीने के लिए थोड़ा जल दें।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","रिबका ने जल्दी कंधे से घड़े को नीचे उतारा और उसे पानी पिलाया। रिबका ने कहा, “महोदय, यह पिएँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ज्यों ही उसने पीने के लिए कुछ पानी देना खतम किया, रिबका ने कहा, “मैं आपके ऊँटों को भी पानी दे सकती हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","इसलिए रिबका ने झट से घड़े का सारा पानी ऊँटों के लिए बनी नाद में उड़ेल दिया। तब वह और पानी लाने के लिए कुएँ को दौड़ गई और उसने सभी ऊँटों को पानी पिलाया। ");
INSERT INTO hin2010_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","नौकर ने उसे चुप—चाप ध्यान से देखा। वह तय करना चाहता था कि यहोवा ने शायद बात मान ली है और उसकी यात्रा को सफल बना दिया है। ");
INSERT INTO hin2010_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","जब ऊँटों ने पानी पी लिया तब उसने रिबका को चौथाई औंस तौल कर एक सोने की अँगूठी दी। उसने उसे दो बाजूबन्द भी दिए जो तौल में हर एक पाँच औंस थे। ");
INSERT INTO hin2010_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","नौकर ने पूछा, “तुम्हारा पिता कौन है? क्या तुम्हारे पिता के घर में इतनी जगह है कि हम सब के रहने तथा सोने का प्रबन्ध हो सके?” ");
INSERT INTO hin2010_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","रिबका ने उत्तर दिया, “मेरे पिता बतूएल हैं जो मिल्का और नाहोर के पुत्र हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","तब उसने कहा, “और हाँ हम लोगों के पास तुम्हारे ऊँटों के लिए चारा हऐ और तुम्हारे लिए सोने की जगह है।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","नौकर ने सिर झुकाया और यहोवा की उपासना की। ");
INSERT INTO hin2010_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","नौकर ने कहा, “मेरे मालिक इब्राहीम के परमेश्वर यहोवा की कृपा है। यहोवा हमारे मालिक पर दयालु है। यहोवा ने मुझे अपने मालिक के पुत्र के लिए सही दुल्हन दीया है।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","तब रिबका दौड़ी और जो कुछ हुआ था अपने परिवार को बताया। ");
INSERT INTO hin2010_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","रिबका का एक भाई था। उसका नाम लाबान था। रिबका ने उसे वे बातें बताई जो उससे उस व्यक्ति ने की थी। लाबान उसकी बातें सुन रहा था। जब लाबान ने अँगूठी और बहन की बाहों पर बाजूबन्द देकहआ तो वह दौड़कर कुएँ पर पहुँचा और वहाँ वह व्यक्ति कुएँ के पास, ऊँटों के बगल में खड़ा था। ");
INSERT INTO hin2010_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","लाबान ने कहा, “महोदय, आप पधारें आपका स्वागत है। आपको यहाँ बाहर खड़ा नहीं रहना है। मैंने आपके ऊँटों के लिए एक जगह बना दी है और आपके सोने के लिए एक कमरा ठीक कर दिया है।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","इसलिए इब्राहीम का नौकर घर में गया। लाबान ने ऊँटों और उस की मदद की और ऊँटों को खाने के लिए चारा दिया। तब लाबान ने पानी दिया जिससे वह व्यक्ति तथा उसके साथ आए हुए दूसरे नौकर अपने पैर धो सकें। ");
INSERT INTO hin2010_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","तब लाबान ने उसे खाने के लिए भोजन दिया। लेकिन नौकर ने भोजन करना मना किया। उसने कहा, “मैं तब तक भोजन नहीं करूँगा जब तक मैं यह न बता दूँ कि मैं यहाँ किसलिए आया हूँ।” इसलिए लाबान ने कहा, “तब हम लोगों को बताओ।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","नौकर ने कहा, “मैं इब्राहीम का नौकर हूँ। ");
INSERT INTO hin2010_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","यहोवा ने हमारे मालिक पर हर एक विषय में कृपा की है। मेरे मालिक महान व्यक्ति हो गए हैं। यहोवा ने इब्राहीम को कई भेड़ों की रेवड़े तथा बवेशियों के झुण्ड दिए हैं। इब्राहीम के पास बहुत सोना, चाँदी और नौकर हैं। इब्राहीम के पास बहुत से ऊँट और गधे हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","सारा, मेरे मालिक की पत्नी थी। जब वह बहुत बूढ़ी हो गई थी उसने एक पुत्र को जन्म दिया और हमारे मालिक ने अपना सब कुछ उस पुत्र को दे दिया है। ");
INSERT INTO hin2010_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","मेरे स्वामी ने मुझे एक वचन देने के लिए विवश किया। मेरे मालिक ने मुझसे कहा, ‘तुम मेरे पुत्र को कनान की लड़की से किसी भी तरह विवाह नहीं करने दोगे। हम लोग उनके बीच रहते हैं, किन्तु मैं नहीं चाहता कि वह किसी कनानी लड़की से विवाह करे। ");
INSERT INTO hin2010_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","इसलिए तुम्हें वचन देना होगा कि तुम मेरे पिता के देश को जाओगे। मेरे परिवार में जाओ और मेरे पुत्र के लिए एक दुल्हन चुनो।’ ");
INSERT INTO hin2010_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","मैंने अपने मालिक से कहा, ‘यह हो सकता है कि वह दुल्हन मेरे साथ इस देश को न आए।’ ");
INSERT INTO hin2010_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","लेकिन मेरे मालिक ने कहा, ‘मैं यहोवा की सेवा करता हूँ और यहोवा तुम्हारे साथ अपना दूत भेजेगा और तुम्हारी मद्द करेगा। तुम्हें वहाँ मेरे अपने लोगों में मेरे पुत्र के लिए एक दुल्हन मिलेगी। ");
INSERT INTO hin2010_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","किन्तु यदि तुम मेरे पिता के देश को जाते हो और वे लोग मेरे पुत्र के लिए एक दुल्हन देने से मना करते हैं तो तुम्हें इस वचन से छुटकारा मिल जाएगा।’ ");
INSERT INTO hin2010_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“आज मैं इस कुएँ पर आया और मैंने कहा, ‘हे यहोवा मेरे मालिक के परमेश्वर कृपा करके मेरी यात्रा सफल बना। ");
INSERT INTO hin2010_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","मैं यहाँ कुएँ के पास ठहरूँगा और पानी भरने के लिए आने वाली किसी युवती की प्रतीक्षा करूँगा। तब मैं कहूँगा, “कृपा करके आप अपने घड़े से पीने के लिए पानी दें।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","उपयुक्त लड़की ही विशेष रूप से उत्तर देगी। वह कहेगी, “यह पानी पीओ और मैं तुम्हारे ऊँटों के लिए भी पानी लाती हूँ।” इस तरह मैं जानूँगा कि यह वही स्त्री हऐ जिसे यहोवा ने मेरे मालिक के पुत्र के लिए चुना है।’” ");
INSERT INTO hin2010_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“मेरी प्रार्थना पूरी होने के पहले ही रिबका कुएँ पर पानी भरने आई। पानी का घड़ा उसने अपने कंधे पर ले रखा था। वह कुएँ तक गई और उसने पानी भरा। मैंने इससे कहा, “कृपा करके मुझे पानी दें। ");
INSERT INTO hin2010_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","उसने तुरन्त कंधे से घड़े को झुकाया और मेरे लिए पानी डाला और कहा, ‘यह पीएँ और मैं आपके ऊँटों के लिए भी पानी लाऊँगी।’ इसलिए मैंने पानी पीया और अपने ऊँटों को भी पानी पिलाया। ");
INSERT INTO hin2010_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","तब मैंने इससे पूछा, ‘तुम्हारे पिता कौन है?’ इसने उत्तर दिया, ‘मेरा पिता बतूएल है। मेरे पिता के माता—पिता मिल्का और नाहोर हैं।’ तब मैंने इसे अँगूठी और बाहों के लिए बाजीबन्द दिए। ");
INSERT INTO hin2010_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","उस समय मैंने अपना सिर झुकाया और यहोवा को धन्य कहा। मैंने अपने मालिक इब्राहीम के परमेश्वर यहोवा को कृपालु कहा। मैंने उसे धन्य कहा क्योंकि उसने सीधे मेरे मालिक के भाई की पोती तक मुझे पहुँचाया। ");
INSERT INTO hin2010_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","अब बताओ कि तुम क्या करोगे? क्या तुम मेरे मालिक पर दयालु और श्रद्धालु बनोगे और अपनी पुत्री उसे दोगे? या तुम अपनी पुत्री देना मना करोगे? मुझे बताओ, जिससे मैं यह समझ सकूँ कि मुझे क्या करना है।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","तब लाबान और बतूएल ने उत्तर दिया, “हम लोग यह देखते हैं कि यह यहोवा की ओर से है। इसे हम टाल नहीं सकते। ");
INSERT INTO hin2010_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","रिबका तुम्हारी है। उसे लो और जाओ। अपने मालिक के पुत्र से इसे विवाह करने दो। यही है जिसे यहोवा चाहता है।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","इब्राहीम के नौकर ने यह सुना और वह यहोवा के सामने भूमि पर झुका। ");
INSERT INTO hin2010_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","तब उसने रिबका को वे भेंटे दी जो वह साथ लाया था। उसने रिबका को सोने और चाँदी के गहने और बहुत से सुन्दर कपड़े दिए। उसने, उसके भाई और उसकी माँ को कीमती भेंटे दी। ");
INSERT INTO hin2010_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","नौकर और उसके साथ के व्यक्ति वहाँ ठहरे तथा खाया और पीया। वे वहाँ रातभर ठहरे। वे दूसरे दिन सवेरे उठे और बोले “अब हम अपने मालिक के पास जाएँगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","रिबका की माँ और भाई ने कहा, “रिबका को हम लोगों के पास कुछ दिन और ठहरने दो। उसे दस दिन तक हमारे साथ ठहरने दो। इसके बाद वह जा सकई है।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","लेकिन नौकर ने उनसे कहा, “मुझसे प्रतीक्षा न करवाएँ। यहोवा ने मेरी यात्रा सफल की है। अब मुझे अपने मालिक के पास लौट जाने दें।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","रिबका के भाई और माँ ने कहा, “हम लोग रिबका को बुलाएँगे और उस से पूछेंगे कि वह क्या चाहती है?” ");
INSERT INTO hin2010_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","उन्होंने रिबका को बुलाया और उससे कहा, “क्या तुम इस व्यक्ति के साथ अभी जाना चाहती हो?” रिबका ने कहा, “हाँ, मैं जाऊँगी।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","इसलिए उन्होंने रिबका को इब्राहीम के नौकर और उसके साथियों के साथ जाने दिया। रिबका की धाय भी उनके साथ गई। ");
INSERT INTO hin2010_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","जब वह जाने लगी तब वे रिबका से बोले, “हमारी बहन, तुम लाखों लोगों की जननी बनो और तुम्हारे वंशज अपने शत्रुओं को हराएँ और उनके नगरों को ले लें।” ");
INSERT INTO hin2010_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","तब रिबका और धाय ऊँट पर चढ़ी और नौकर तथा उसके साथियों के पीछे चलने लगी। इस तरह नौकर ने रिबका को साथ लिया और घर को लौटने की यात्रा शुरू की। ");
INSERT INTO hin2010_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","इस समय इसहाक ने लहैरोई को छोड़ दिया था और नेगेव में रहने लगा था। ");
INSERT INTO hin2010_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","एक शाम इसहाक मैदान में विचरण करने गया। इसहाक ने नज़र उठाई और बहुत दूर से ऊँटों को आते देखा। ");
INSERT INTO hin2010_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबका ने नज़र डाली और इसहाक को देखा। तब वह ऊँट से कूद पड़ी। ");
INSERT INTO hin2010_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","उसने नौकर से पूछा, “हम लोगों से मिलने के लिए खेतों में टहलने वाला वह युवक कौन है?” नौकर ने कहा, “यह मेरे मालिक का पुत्र है।” इसलिए रिबका ने अपने मुँह को पर्दे में छिपा लिया। ");
INSERT INTO hin2010_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","नौकर ने इसहाक को वे सभी बातें बताई जो हो चुकी थी। ");
INSERT INTO hin2010_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","तब इसहाक लड़की को अपनी माँ के तम्बू में ले आया। उसी दिन इसहाक ने रिबका से विवाह कर लिया। वह उससे बहुत प्रेम करता था। अतः उसे उसकी माँ की मृत्यु के पश्चात् भी सांत्वना मिली। ");
INSERT INTO hin2010_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","इब्राहीम ने फिर विवाह किया। उसकी नई पत्नी का नाम कतूरा था। ");
INSERT INTO hin2010_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","कतूरा ने जिम्रान, योक्षान, मदना, मिद्यान, यिशबाक और शूह को जन्म दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","योक्षान, शबा और ददान का पिता हुआ। ददान के वंशज अश्शूर और लुम्मी लोग थे। ");
INSERT INTO hin2010_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिद्यान के पुत्र एपा, एपेर, हनोक, अबीद और एल्दा थे। ये सभी पुत्र इब्राहीम और कतूरा से पैदा हुए। ");
INSERT INTO hin2010_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","इब्राहीम ने मरने से पहले अपनी दासियों के पुत्रों को कुछ भेंट दिया। इब्राहीम ने पुत्रों को पूर्व को भेजा। उसने इन्हें इसहाक से दूर भेजा। इसके बाद इब्राहीम ने अपनी सभी चीज़ें इसहाक को दे दीं। ");
INSERT INTO hin2010_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","इब्राहीम एक सौ पचहत्तर वर्ष की उम्र तक जीवित रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","इब्राहीम धीरे—धीरे कमज़ोर पड़ता गया और भरे—पूरे जीवन के बाद चल बसा। उसने लम्बा भरपूर जीवन बिताया और फिर वह अपने पुरखों के साथ दफनाया गया। ");
INSERT INTO hin2010_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","उसके पुत्र इसहाक और इश्माएल ने उसे मकपेला की गुफा में दफनाया। यह गुफा सोहर के पुत्र एप्रोन के खेत में है। यह मम्रे के पूर्व में थी। ");
INSERT INTO hin2010_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","यह वही गुफा है जिसे इब्राहीम ने हित्ती लोगों से खरीदा था। इब्राहीम को उसकी पत्नी सारा के साथ दफनाया गया। ");
INSERT INTO hin2010_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","इब्राहीम के मरने के बाद परमेश्वर ने इसहाक पर कृपा की और इसहाक लहैरोई में रहता रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","इश्माएल के परिवार की यह सूची है। इश्माएल इब्राहीम और हाजिरा का पुत्र था। (हाजिरा सारा की मिस्री दासी थी।) ");
INSERT INTO hin2010_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","इश्माएल के पुत्रों के ये नाम हैं पहला पुत्र नबायोत था, तब केदार पैदा हुआ, तब अदबेल, मिबसाम, ");
INSERT INTO hin2010_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिश्मा, दूमा, मस्सा, ");
INSERT INTO hin2010_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदर, तेमा, यतूर, नापीश और केदमा हुए। ");
INSERT INTO hin2010_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ये इश्माएल के पुरों के नाम थे। हर एक पुत्र के अपने पड़ाव थे जो छोटे नगर में बदल गए। ये बारह पुत्र अपने लोगों के साथ बारह राजकुमारों के समान थे। ");
INSERT INTO hin2010_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इश्माएल एक सौ सैंतीस वर्ष जीवित रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","इश्माएल के लोग हवीला से लेकर शूर के पास मिस्र की सीमा और उससे भी आगे अश्शूर के किनारे तक, घूमते रहे और अपने भाईयों और उनसे सम्बन्धित देशों में आक्रमण करते रहे। ");
INSERT INTO hin2010_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","यह इसहाक की कथा है। इब्राहीम का एक पुत्र इसहाक था। ");
INSERT INTO hin2010_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","जब इसहाक चालीस वर्ष का था तब उसने रिबका से विवाह किया। रिबका पद्दनराम की रहने वाली थी। वह अरामी बतूएल की पुत्री थी और लाबान की बहन थी। ");
INSERT INTO hin2010_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","इसहाक की पत्नी बच्चे नहीं जन सकी। इसलिए इसहाक ने यहोवा से अपनॊई पत्नी के लिए प्रार्थना की। यहोवा ने इसहाक की प्रार्थना सुनी और यहोवा ने रिबका को गर्भवती होने दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","जब रिबका गर्भवती थी तब वह अपने गर्भ के बच्चों से परेशान तहई, लड़के उसके गर्भ में आपस में लिपट के एक दूसरे को मारने लगे। रिबका ने यहोवा से प्रार्थना की और बोली, “मेरे साथ ऐसा क्यों हो रहा है।” ");
INSERT INTO hin2010_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","यहोवा ने कहा, “तुम्हारे गर्भ में दो राष्ट्र हैं। दो परिवारों के राजा तुम से पैदा होंगे और वे बँट जाएंगे। एक पुत्र दूसरे से बलवान होगा। बड़ा पुत्र छोटे पुत्र की सेवा करेगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","और जब समय पूरा हुआ तो रिबका ने जुड़वे बच्चों को जन्म दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","पहला बच्चा लाल हुआ। उसकी त्वचा रोंएदार पोशाक की तरह थी। इसलिए उसका नाम एसाव पड़ा। ");
INSERT INTO hin2010_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","जब दूसरा बच्चा पैदा हुआ, वह एसाव की एड़ी को मज़बूती से पकड़े था। इसलिए उस बच्चे का नाम याकूब पड़ा। इसहाक की उम्र उस समय साठ वर्ष की थी। जब याकूब और एसाव पैदा हुए। ");
INSERT INTO hin2010_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","लड़के बड़े हुए। एसाव एक कुशल शिकारी हुआ। वह मैदानों में रहना पसन्द करने लगा। किन्तु याकूब शान्त व्यक्ति था। वह अपने तम्बू में रहता था। ");
INSERT INTO hin2010_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","इसहाक एसाव को प्यार करता था। वह उन जानवरों को खाना पसन्द करता था जो एसाव मारकर लाता था। किन्तु रिबका याकूब को प्यार करती थी। ");
INSERT INTO hin2010_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","एक बार एसाव शिकार से लौटा। वह थका हुआ और भूख से परेशान था। याकूब कुछ दाल पका रहा था। ");
INSERT INTO hin2010_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","इसलिए एसाव ने याकूब से कहा, “मैं भूख से कमज़ोर हो रहा हूँ। तुम उस लाल दाल में से कुछ मुझे दो।” (यही कारण है कि लोग उसे एदोम कहते हैं।) ");
INSERT INTO hin2010_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","किन्तु याकूब ने कहा, “तुम्हें पहलौठा होने का अधिकार मुझको आज बेचना होगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसाव ने कहा, “मैं भूख से मरा जा रहा हूँ। यदि मैं मर जाता हूँ तो मेरे पिता का सारा धन भी मेरी सहायता नहीं कर पाएगा। इसलिए तुमको मैं अपना हिस्सा दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","किन्तु याकूब ने कहा, “पहले वचन दो कि तुम यह मुझे दोगे।” इसलिए एसाव ने याकूब को वचन दिया। एसाव ने अपने पिता के धन का अपना हिस्सा यकूब को बेच दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","तब याकूब ने एसाव को रोटी और भोजन दिया। एसाव ने खाया, पिया और तब चला गया। इस तरह एसाव ने यह दिखाया कि वह पहलौठे होने के अपने हक की परवाह नहीं करता। ");
INSERT INTO hin2010_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","एक बार अकाल पड़ा। यह अकाल वैसा ही था जैसा इब्राहीम के समय में पड़ा था। इसलिए इसहाक गरार नगर में पलिश्तियों के रजा अबीमेलेक के पास गया। ");
INSERT INTO hin2010_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","यहोवा ने इसहाक से बात की। यहोवा ने इसहाक से यह कहा, “मिस्र को न जाओ। उसी देश में रहो जिामें न का आदेश मैंने तुम्हें दिया है। ");
INSERT INTO hin2010_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","उसी देश में रहो और मैं तुम्हारे साथ रहूँगा। मैं तुम्हें आशीर्वाद दूँगा। मैं तुम्हें और तुम्हारे परिवार को यह सारा प्रदेश दूँगा। मैं वही करूँगा जो मैंने तुम्हारे पिता इब्राहीम को वचन दिया है। ");
INSERT INTO hin2010_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","मैं तुम्हारे परिवार को आकाश के तारागणों की तरह बहुत से बनाऊँगा और मैं सारा प्रदेश तुम्हारे परिवार को दूँगा। पृथ्वी के सभी राष्ट्र तुम्हारे परिवार के कारण मेरा आशीर्वाद प्राप्त करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","मैं यह इसलिए करूँगा कि तुम्हारे पिता इब्राहीम ने मेरी आज्ञा का पालन किया और मैंने जो कुछ कहा, उसने किया। इब्राहीम ने मेरे आदेशों, मेरी विधियों और मेरे नियमों का पालन किया।” ");
INSERT INTO hin2010_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","इसहान ठहरा और गरार में रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","इसहाक की पत्नी रिबका बहुत ही सुन्दर थी। उस जगह के लोगों ने इसहाक से रिबका के बारे में पूछा। इसहाक ने कहा, “यह मेरी बहन है।” इसहाक यह कहने से डर रहा था कि रिबका मेरी पत्नी है। इसहाक डरता था कि लोग उसकी पत्नी को पाने के लिए उसको मार डालेंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","जब इसहाक वहाँ बहुत समय तक रह चुका, अबीमेलेक ने अपनी खिड़की से बाहर झाँका और देखा कि इसहाक, रिबका के साथ छेड़खानी कर रहा है। ");
INSERT INTO hin2010_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","अबीमेलेक ने इसहाक को बुलाया और कहा, “यह स्त्री तुम्हारी पत्नी है। तुमने हम लोगों से यह क्यों कहा कि यह मेरी बहन है।” इसहाक ने उससे कहा, “मैं डरता था कि तुम उसे पाने के लिए मुझे मार डालोगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमेलेक ने कहा, “तुमने हम लोगों के लिए बुरा किया है। हम लोगों का कोई भी पुरुष तुम्हारी पत्नी के साथ सो सकता था। तब वह बड़े पाप का दोषी होता।” ");
INSERT INTO hin2010_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","इसलिए अबीमेलेक ने सभी लोगों को चेतावनी दी। उसने कहा, “इस पुरुष और इस स्त्री को कोई चोट नहीं पहुँचाएगा। यदि कोई इन्हें चोट पहुँचाएगा तो वह व्यक्ति जान से मार दिया जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","इसहाक ने उस भूमि पर खेती की और उस साल उसे बहुत फसल हुई। यहोवा ने उस पर बहुत अधिक कृपा की। ");
INSERT INTO hin2010_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","इसहाक धनी हो गया। वह अधिक से अधिक धन तब तक बटोरता रहा जब तक वह धनी नहीं हो गया। ");
INSERT INTO hin2010_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","उसके पास बहुत सी रेवड़े और मवेशियों के झुण्ड थे। उसके पास अनेक दास भी थे। सभी पलिश्ती उससे डाह रखते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","इसल; इए पलिश्तियों ने उन सभी कुओं को नष्ट कर दिया जिन्हें इसहाक के पिता इब्राहीम और उसके साथियों ने वर्षों पहले खोदा था। पलिश्तीयों ने उन्हें मिट्टी से भर दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","और अबीमेलेक ने इसहाक से कहा, “हमारा देश छोड़ दो। तुम हम लोगों से बहुत अधिक शक्तिशाली हो गए हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","इसलिए इसहाक ने वह जगह छोड़ दी और गरार की छोटी नदी के पास पड़ाव डाला। इसहाक वहीं ठहरा और वहीं रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","इसके बहुत पहले इब्राहीम ने कई कुएँ खोदे थे। जब इब्राहीम मरा तो पलिश्तीयों ने मिट्टी से कुओं को भर दिया। इसलिए वहीं इसहाक लौटा और उन कुओं को फिर खोद डाला। ");
INSERT INTO hin2010_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","इसहाक के नौकरों ने छोटी दी के पास एक कुआँ खोदा। उस कुएँ से एक पानी का सोता फूट पड़ा। ");
INSERT INTO hin2010_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","तब गरार के गड़ेंरिए उस कुएँ की वजह से इसहाक के नौकरों से झगड़ा करने लगे। उन्होंने कहा, “यह पाणी हमारा है।” इसलिए इसहाक ने उसका नाम एसेक रखा। उसने यह नाम इसलिए दिया कि उसी जगह पर उन लोगों ने उससे झगड़ा किया था। ");
INSERT INTO hin2010_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","तब इसहाक के नौकरों ने दूसरा कुआँ खोदा। वहाँ के लोगों ने उस कुएँ के लिए भी झगड़ा किया। इसलिए इसहाक ने उस कुएँ का नाम सित्रा रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","इसहाक वहाँ से हटा और दूसरा कुआँ खोदा। उस कुएँ के लिए झगड़ा करने कोई नहीं आया। इसलिए इसहाक ने उस कुएँ का नाम रहोबोत रखा। इसहाक ने कहा, “यहोवा ने यहाँ हमारे लिए जगह उपलब्ध कराई है। हम लोग बढ़ेगे और इसी भूमि पर सफल होंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","उस जगह से इसहाक बेर्शेबा को गया। ");
INSERT INTO hin2010_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","यहोवा उस रात इसहाक से बोला, “मैं तुम्हारे पिता इब्राहीम का परमेश्वर हूँ। डरो मत। मैं तुम्हारे साथ हूँ और मैं तुम्हें आशीर्वाद दूँगा। मैं तुम्हारे परिवार को महान बनाऊँगा। मैं अपने सेवक इब्राहीम के कारण यह करूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","इसलिए इसहाक ने उस जगह यहोवा की उपासना के लिए एक वेदी बनाई। इसहाक ने वहाँ पड़ाव डाला और उसके नौकरों ने एक कुआँ खोदा। ");
INSERT INTO hin2010_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","अबीमेलेक गरार से इसहाक को देखने आया। अबीमेलेक अपने साथ सलाहकार अहुज्जत और सेनापति पीकोल को लाया। ");
INSERT INTO hin2010_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","इसहाक ने पूछा, “तुम मुझे देखने क्यों आए हो? तुम इसके पहले मेरे साथ मित्रता नहीं रखते थे। तुमने मुझे अपना देश छोड़ने को विवश किया।” ");
INSERT INTO hin2010_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","उन्होंने जवाब दिय, “अब हम लोग जानते हैं कि यहोवा तुम्हारे साथ है। हम चाहते हैं कि हम तुम्हारे साथ एक वाचा करें। हम चाहते हैं कि तुम हमें एक वचन दो। ");
INSERT INTO hin2010_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","हम लोगों ने तुम्हें चोट नहीं पहुँचाई, अब तुम्हें यह वचन देना चाहिए कि तुम हम लोगों को चोट नहीं पहुँचाओगे। हम लोगों ने तुमको भेजा। लेकिन हम लोगों ने तुम्हें शान्ति से भेजा। अब साफ है कि यहोवा ने तुम्हें आशीर्वाद दिया है।” ");
INSERT INTO hin2010_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","इसलिए इसहाक ने उन्हें दावत दी। सभी ने खाया और पीया। ");
INSERT INTO hin2010_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","दूसरे दिन सवेरे हर एक व्यक्ति ने वचन दिया और शपथ खाई। तब इसहाक ने उनको शान्ति से विदा किया और वे सकुशल उसके पास से चले आए। ");
INSERT INTO hin2010_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","उस दिन इसहाक के नौकर आए और उन्होंने अपने खोदे हुए कुएँ के बारे में बताया। नौकरों ने कहा, “हम लोगों ने उस कुएँ से पानी पिया।” ");
INSERT INTO hin2010_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","इसलिए इसहाक ने उसका नाम शिबा रखा और वह नगर अभी भी बेर्शेबा कहलाता है। ");
INSERT INTO hin2010_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","जब एसाव चालीस वर्ष का हुआ, उसने हित्ती स्त्रियों से विवाह किया। एक बेरी की पुत्री यहूदीत थी। दूसरी एलोन की पुत्री बाशमत थी। ");
INSERT INTO hin2010_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","इन विवाहों ने इसहाक और रिबका का मन दुःखी कर दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","जब इसहाक बूढ़ा हो गया तो उसकी आँखें अच्छी न रहीं। इसहाक साफ—साफ नहीं देख सकता था। एक दिन उसने अपने बड़े पुत्र एसाव को बुलाया। इसहाक ने कहा, “पुत्र।” एसाव ने उत्तर दिया, “हाँ, पिताजी।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","इसहाक ने कहा, “देखो, मैं बूढ़ा तो गया। हो सकता है मैं जल्दी ही मर जाऊँ। ");
INSERT INTO hin2010_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","अब तू अपना तरकश और धनुष लेकर, मेरे लिए शिकार पर जाओ। मेरे खाने के लिए एक जानवर मार लाओ। ");
INSERT INTO hin2010_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","मेरा प्रिय भोजन बनाओ। उसे मेरेपास लाओ, और मैं इसे खाऊँगा। तब मैं मरने से पहले तुम्हें आशीर्वाद दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","इसलिए एसाव शिकार करने गया। रिबका ने वे बातें सुन ली थी, जो इसहाक ने अपने पुत्र एसाव से कही। ");
INSERT INTO hin2010_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","रिबका ने अपने पुत्र याकूब से कहा, “सुनो, मैंने तुम्हारे पिता को, तुम्हारे भाई से बातें करते सुना है। ");
INSERT INTO hin2010_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","तुम्हारे पिता ने कहा, ‘मेरे खाने के लिए एक जानवर मारो। मेरे लिए भोजन बनाओ और मैं उसे खाऊँगा। तब मैं मरने से पहले तुमको आशीर्वाद दूँगा।’ ");
INSERT INTO hin2010_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","इसलिए पुत्र सुनो। मैं जो कहती हूँ, करो। ");
INSERT INTO hin2010_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","पनी बकरियों के बीच जाओ और दो नई बकरियाँ लाओ। मैं उन्हें वैसा बनाऊँगी जैसा तुम्हारे पिता को प्रिय है। ");
INSERT INTO hin2010_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","तब तुम वह भोजन अपने पिता के पास ले जाओगे और वह मरने से पहले तुमको ही आशीर्वाद देंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","लेकिन याकूब ने अपनी माँ रिबका से कहा, “किन्तु मेरा भाई रोएदार हऐ और मैं उसकी तरह रोएदार नहीं हूँ। ");
INSERT INTO hin2010_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","यदि मेरे पिता मुझको छूते हैं, यो जान जाएंगे कि मैं एसाव नहीं हूँ। तब वे मुझे आशीर्वाद नहईं देंगे। वे मुझे शाप देंगे क्योंकि मैंने उनके साथ चाल चलने का प्रयत्न किया।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","इस पर रिबका ने उससे कहा, “यदि कोई परेशानी होगी तो मैं अपना दोष मान लूँगी। जो मैं कहती हूँ करो। जाओ, और मेरे लिए बकरियाँ लाओ।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","इसलिए याकूब बाहर गया और उसने दो बकरियों को पकड़ा और अपनी माँ के पास लाया। उसकी माँ ने इसहाक की पसंद के अनुसार विशेष ढंग से उन्हें पकाया। ");
INSERT INTO hin2010_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","तब रिबका ने उस पोशाक को उठाया जो उसका बड़ा पुत्र एसाव पहनना पसंद करता था। रिबका ने अपने छोटे पुत्र याकूब को वे कपड़े पहना दिए। ");
INSERT INTO hin2010_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","रिबका ने बकरियों के चमड़े को लिया और याकूब के हाथों और गले पर बांध दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","तब ररिबका ने अपना पकाया भोजन उठाया और उसे याकूब को दियआ। ");
INSERT INTO hin2010_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","याकूब पिता के पास गया और बोला, “पिताजी।” और उसके पिता ने पूछा, “हाँ पुत्र, तुम कौन हो?” ");
INSERT INTO hin2010_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकूब ने अपने पिता से कहा, “मैं आपका बड़ा पुत्र एसाव हूँ। आपने जो कहा हऐ, मैंने कर दिया है। अब आप बैठें और उन जानवरों को खाएं जिनका शिकार मैंने आपके लिए किया है। तब आप मुझे आशीर्वाद दे सकते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","लेकिन इसहाक ने अपने पुत्र से कहा, “तुमने इतनी जल्दी शिकार करके जानवरों को कैसे मारा हैं?” याकूब ने उत्तर दिया, “क्योंकि आपके परमेश्वर यहोवा ने मुझे जल्दी ही जानवरों को प्राप्त करा दिया।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","तब इसहाक ने याकूब से कहा, “मेरे पुत्र मेरे पास आओ जिससे मैं तुम्हें छू सकूँ। यदि मैं तुम्हें छू सकूँगा तो मैं यह जान जाऊँगा कि तुम वास्तव में मेरे पुत्र एसाव ही हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","याकूब अपने पिता इसहाक के पास गया। इसहाक ने उसे छुआ और कहा, “तुम्हारी आवाज़ याकूब की आवाज़ जैसी है। लेकिन तुम्हारी बाहें एसाव की रोंएदार बाहों की तरह हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","इसहाक यह नहीं जान पाया कि यह याकूब है क्योंकि उसकी बाहें एसाव की बाहों की तरह रोएंदार थी। इसलिए इसहाक ने याकूब को आशीर्वाद दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","इसहाक ने कहा, “क्या सचमुच तुम मेरे पुत्र एसाव हो?” याकूब ने उत्तर दिया, “हाँ, मैं हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","तब इसहाक ने कहा, “भोजन लाओ। मैं इसे खाऊँगा और तुम्हें आशीर्वाद दूँगा।” इसलिए याकूब ने उसे भोजन दिया और उसने खाया। याकूब ने उसे दाखमधु दी, और उसने उसे पिया। ");
INSERT INTO hin2010_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","तब इसहाक ने उससे कहा, “पुत्र, मेरे करीब आओ और मुझे चूमो।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","इसलिए याकूब अपने पिता के पास गया और उसे चूमा। इसहाक ने एसाव के कपड़ों की गन्ध पाई और उसको आशीर्वाद दिया। इसहाक ने कहा, “अहा, मेरे पुत्र की सुगन्ध यहोवा से वरदान पाए खेतों की सुगन्ध की तरह है। ");
INSERT INTO hin2010_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","यहोवा तुम्हें बहुत वर्षा दे। जिससे तुम्हें बहुत फसल और दाखमधु मिले। ");
INSERT INTO hin2010_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","सभी लोग तुम्हारी सेवा करें। राष्ट्र तुम्हारे सामने झुकें। तुम अपने भाईयों के ऊपर शासक होगे। तुम्हारी माँ के पुत्र तुम्हारे सामने झुकेंगे और तुम्हारी आज्ञा मानेंगे। हर एक व्यक्ति जो तुम्हें शाप देगा, शाप पाएगा और हर एक व्यक्ति जो तुम्हें आशीर्वाद देगा, आशीर्वाद पाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","इसहाक ने याकूब को आशीर्वाद देना पूरा किया। तब ज्योंही याकूब अपने पिता इसहाक के पास से गया त्योंही एसाव शिकार करके अन्दर आया। ");
INSERT INTO hin2010_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","एसाव ने अपनेपिता की पसंद का विशेष भोजन बनाया। एसाव इसे अपने पिता के पास लाया। उसने अपने पिटा से कहा, “पिताजी, उठें और उस भोजन को खाएं जो आपके पुत्र ने आपके लिए मारा है। तब आप मुझे आशीर्वाद दे सकते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","किन्तु इसहाक ने उससे कहा, “तुम कौन हो?” उसने उत्तर दिया, “मैं आपका पहलौठा पुत्र एसाव हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","तब इसहाक बहुत झल्ला गया और बोला, “तब तुम्हारे आने से पहले वह कौन था? जिसने भोजन पकाया और जो मेरे पास लाया। मैंने वह सब खाया और उसको आशीर्वाद दिया। अब अपने आशीर्वादों को लौटाने का समय निकल चुका है।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","एसाव ने अपने पिता की बात सुनी। उसका मन बहुत गुस्से और कड़वाहट से भर गया। वह चीखा। वह अपने पिता से बोला, “पिताजी, तब मुझे भी आशीर्वाद दें।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","इसहाक ने कहा, “तुम्हारे भाई ने मुझे धोखा दिया। वह आया और तुम्हारा आशीर्वाद लेकर गया।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","एसाव ने कहा, “उसका नाम ही याकूब (चालबाज़) है। यह नाम उसके लिए ठीक ही है। उसका यह नाम बिल्कुल सही रखा गया है वह सचमुच में चालबाज़ हैम। उसने मुझे दो बार धोखा दिया। वह पहलौठा होने के मेरे अधिकार को ले ही चुका था और अब उसने मेरे हिस्से के आशीर्वाद को भी ले लिया। क्या आपने मेरे लिए कोई आशीर्वाद बचा रखा है?” ");
INSERT INTO hin2010_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इसहाक ने जवाब दिया, “नहीं, अब बहुत देर हो गई। मैंने याकूब को तुम्हारे ऊपर शासन करने का अधिकार दे दिया है। मैंने यह भी कह दिया कि सभी भाई उसके सेवक होंगे। मैंने उसे बहुत अधिक अन्न और दाखमधु का आशीर्वाद दिया है। पुत्र तुम्हें देने के लिए कुछ नहीं बचा है।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","किन्तु एसाव अपने पिता से माँगता रहा। “पिताजी, क्या आपके पास एक भी आशीर्वाद नहीं है? पिताजी, मुझे भी आशीर्वाद दें।” यूँ एसाव रोने लगा। ");
INSERT INTO hin2010_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","तब इसहाक ने उससे कहा, “तुम अच्छी भूमि पर नहीं रहोगे। तुम्हारे पास बहुत अन्न नहीं होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तुम्हें जीने के लिए संघर्ष करना होगा। और तुम अपने भाई के दास होगे। किन्तु तुम आज़ादी के लिए लड़ोगे, और उसके शासन से आज़ाद हो जाओगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","इसके बाद इस आशीर्वाद के कारण एसाव याकूब से घृणा करता रहा। एसाव ने मन ही मन सोचा, “मेरा पिता जल्दी ही मरेगा और मैं उसका शोक मनाऊँगा। लेकिन उसके बाद मैं याकूब को मार डालूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","रिबका ने एसाव द्वारा याकूब को मारने का षड़यन्त्र सुना। उसने याकूब को बुलाया और उससे कहा, “सुनो, तुम्हारा भाई एसाव तुम्हें मारने का षडयन्त्र कर रहा है। ");
INSERT INTO hin2010_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","इसलिए पुत्र जो मैं कहती हूँ, करो। मेरा भाई लाबान हारान में रहता है। उसके पास जाओ और छिपे रहो। ");
INSERT INTO hin2010_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","उसके पास थोड़े समय तक ही रहो जब तक तुम्हारे भाई का गुस्सा नहीं उतरता। ");
INSERT INTO hin2010_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","थोड़े समय बाद तुम्हारा भाई भूल जाएगा कि तुमने उसके साथ क्या किया? तब मैं तुम्हें लौटाने के लिए एक नौकर को भेजूँगी। मैं एक ही दिन दोनों पुत्रों को खोना नहीं चाहती।” ");
INSERT INTO hin2010_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","तब रिबका ने इसहाक से कहा, “तुम्हारे पुत्र एसाव ने हित्ती स्त्रियों से विवाह कर लिया है। मैं इन स्त्रियों से परेशान हूँ क्योंकि ये हमारे लोगों में से नहीं हैं। यदि याकूब भी इन्हीं स्त्रियों में से किसी के साथ विवाह करता है तो मैं मर जाना चाहूँगी।” ");
INSERT INTO hin2010_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","इसहाक ने याकूब को बुलाया और उसको आशीर्वाद दिया। तब इसहाक ने उसे आदेश दिया। इसहाक ने कहा, “तुम कनानी स्त्री से विवाह नहीं कर सकते। ");
INSERT INTO hin2010_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","इसलिए इस जगह को छोड़ो और पद्दनराम को जाओ। अपने नाना बतूएल के घराने में जाओ। वहाँ तुम्हारा मामा लाबान रहता है। उसकी किसी एक पुत्री से विवाह करो। ");
INSERT INTO hin2010_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","मैं प्रार्थना करता हूँ कि सर्वशक्तिमान परमेश्वर तुम्हें आशीर्वाद दे और तुम्हें बहुत से पुत्र दे। मैं प्रार्थना करता हूँ कि तुम एक महान राष्ट्र के पिता बनो। ");
INSERT INTO hin2010_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","मैं प्रार्थना करता हूँ कि जिस तरह परमेश्वर ने इब्राहीम को वरदान दिया था उसी तरह वह तुमको भी आशीर्वाद दे। मैं प्रार्थना करता हूँ कि परमेश्वर तुम्हें इब्राहीम का आशीर्वाद दे, यानी वह तुम्हें और तुम्हारी आने वाली पीढ़ी को, यह जगह जहाँ तुम आज परदेशी की तरह रहते हो, हमेशा के लिए तुम्हारी सम्पत्ति बना दे।” ");
INSERT INTO hin2010_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","इस तरह इसहाक ने याकूब को पद्दनराम के प्रदेश को भेजा। याकूब अपने मामा लाबान और रिबका का पिता था और रिबका याकूब और एसाव की माँ थी। ");
INSERT INTO hin2010_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","एसाव को पता चला कि उसके पिता इसहाक ने याकूब को आशीर्वाद दिया है और उसने याकूब को पद्दरनाम में एक पत्नी की खोज के लिए भेजा है। एसाव को यह भी पता लगा कि इसहाक ने याकूब को आदेश दिया है कि वह कनानी स्त्री से विवाह न करे। ");
INSERT INTO hin2010_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","एसाव ने यह समझा कि याकूब ने अपने पिता और माँ की आज्ञा मानी और वह पद्दरनाम को चला गया। ");
INSERT INTO hin2010_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","एसाव ने इससे यह समझा कि उसका पिता नहीं चाहता कि उसके पुत्र कनानी स्त्रियों से विवाह करें। ");
INSERT INTO hin2010_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","एसाव की दो पत्नियाँ पहले से ही थी। किन्तु उसने इश्माएल की पुत्री महलत से विवाह किया। इश्माएल इब्राहीम का पुत्र था। महलत नबायोत की बहन थी। ");
INSERT INTO hin2010_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याकूब ने बेर्शेबा को छोड़ा और वह हारान को गया। ");
INSERT INTO hin2010_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","याकूब के यात्रा करते समय ही सूरज डूब गया था। इसलिए याकूब रात बिताने के लिए एक जगह ठहरने गया। याकूब ने उस जगह एक चट्टान देखी और सोने के लिए इस पर अपना सिर रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","याकूब ने सपना देखा। उसने देखा कि एक सीढ़ी पृथ्वी से स्वर्ग तक पहुँची है। ");
INSERT INTO hin2010_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","याकूब ने स्वर्गदूतों को उस सीढ़ी पर चढ़ते उतरते देखा और यहोवा को सीढ़ी के पास खड़ा देखा। यहोवा ने कहा, “मैं तुम्हारे पितामह इब्राहीम का परमेश्वर यहोवा हूँ। मैं इसहाक का परमेश्वर हूँ। मैं तुम्हें वह भूमि दूँगा जिस पर तुम अब सो रहे हो। मैं यह भूमि तुम्हें और तुम्हारे वंशजों को दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","तुम्हारे वंशज उतने होगे जितने पृथ्वी पर मिट्टी के कण हैं। वे पूर्व, पश्चिम, उत्तर तथा दक्षिण में फैलेंगे। पृथ्वी के सभी परिवार तुम्हारे वंशजों के कारण वरदान पाएँगे। ");
INSERT INTO hin2010_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","“मैं तुम्हारे साथ हूँ और मैं तुम्हारी रक्षा करूँगा जहाँ भी जाओगे और मैं इस भूमि पर तुम्हें लौटा ले आऊँगा। मैं तुमको तब तक नहीं छोड़ूँगा जब तक मैं वह नहीं कर लूँगा जो मैंने करो का वचन दिया है।” ");
INSERT INTO hin2010_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","तब याकूब अपनी नींद से उठा और बोला, “मैं जानता हूँ कि यहोवा इस जगह पर है। किन्तु यहाँ जब तक मैं सोया नहीं था, मैं नहीं जानता था कि वह यहाँ है।” ");
INSERT INTO hin2010_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","याकूब डर गया। उसने कहा, “यह बहुत महान जगह है। यह तो परमेश्वर का घर है। यह तो स्वर्ग का द्वार है।” ");
INSERT INTO hin2010_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","याकूब दूसरे दिन बहुत सबेरे उठा। याकूब ने उस शिला को उठाया और उसे किनारे से खड़ा कर दिया। तब उसने इस पर तेल चढ़ाया। इस तरह उसने इसे परमेश्वर का स्मरण स्तम्भ बनाया। ");
INSERT INTO hin2010_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","उस जगह का नाम लूज था किन्तु याकूब ने उसे बेतेल नाम दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","तब याकूब ने एक वचन दिया। उसने कहा, “यदि परमेश्वर मेरे साथ रहेगा और अगर परमेश्वर, जहाँ भी मैं जाता हूँ, वहाँ मेरी रक्षा करेगा, अगर परमेश्वर मुझे खाने को भोजन और पहनने को वस्त्र देगा। ");
INSERT INTO hin2010_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","अगर मैं अपने पिता के पास शान्ति से लौटूँगा, यदि परमेश्वर ये सभी चीजें करेगा, तो यहोवा मेरा परमेश्वर होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","इस जगह, जहाँ मैंने यह पत्थर खड़ा किया है, परमेश्वर का पवित्र स्थान होगा और परमेश्वर जो कुछ तू मुझे देगा उसका दशमांश मैं तुझे दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","तब याकूब ने अपनी यात्रा जारी रखी। वह पूर्व के प्रदेश में गया। ");
INSERT INTO hin2010_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","याकूब ने दृष्टि डाली, उसने मैदान में एक कुआँ देखा। वहाँ कुएँ के पास भेड़ों की तीन रेवड़े पड़ी हुई थी। यही वह कुआँ था जहाँ ये भेड़े पानी पीती थी। वहाँ एक बड़े शिला से कुएँ का मुँह ढका था। ");
INSERT INTO hin2010_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","जब सभी भेड़े वहाँ इकट्ठी हो जातीं तो गड़ेंरिये चट्टान को कुएँ के मुँह पर से हटाते थे। तब सभी भेड़े उसका जल पी सकती थी। जब भेड़े पी चुकती थी तब गड़ेंरिये शिला को फिर अपनी जगह पर रख देते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","याकूब ने वहाँ गड़ेंरियों से कहा, “भाईयों, आप लोग कहीं के हैं?” उन्होंने उत्तर दिया, “हम हारान के है।” ");
INSERT INTO hin2010_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","तब याकूब ने कहा, “क्या आप लोग नाहोर के पुत्र लाबान को जानते हैं?” गड़ेंरियों ने जवाव दिया, “हम लोग उसे जानते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","तब याकूब ने पूछा, “वह कुशल से तो हैं?” उन्होंने कहा, “वे ठीक हैं। सब कुछ बहुत अच्छा है। देखो, वह उसकी पुत्री राहेल अपनी भेड़ों के साथ आ रही है।” ");
INSERT INTO hin2010_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","याकूब ने कहा, “देखो, अभी दिन है और सूरज डूबने में अभी काफी देर है। रात के लिए जानवरों को इकट्ठा करने का अभी समय नहीं है। इसलिए उन्हें पानी दो और उन्हें मैदान में लौट जाने दो।” ");
INSERT INTO hin2010_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","लेकिन उस गड़ेंरियें ने कहा, “हम लोग यह तब तक नहीं कर सकते जब तक सभी रेबड़े इकट्ठी नहीं हो जाती। तब हम लोग शिला को कुएँ हटाएँगें और सभी भेड़े पानी पीएँगी।” ");
INSERT INTO hin2010_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","याकूब जब तक गड़ेंरियों से बातें कर रहा था तब राहेल अपने पिता को भेड़ों के साथ आई। (राहेल का काम भेड़ों की देखभाल करना था।) ");
INSERT INTO hin2010_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","राहेल लाबान की पुत्री थी। लाबान, रिबका का भाई था, जो याकूब की माँ थी। जब याकूब ने राहेल को देखा तो जाकर शिला को हटाया और भेड़ों को पानी पिलाया। ");
INSERT INTO hin2010_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","तब याकूब ने राहेल को चूमा और जोर से रोया। ");
INSERT INTO hin2010_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","याकूब ने बताया कि मैं तुम्हारे पिता के खानदान से हूँ। उसने राहेल को बताया कि मैं रिबका का पुत्र हूँ। इसलिए राहेल घर को दौड़ गई और अपने पिता से यह सब कहा। ");
INSERT INTO hin2010_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","लाबान ने अपनी बहन के पुत्र, याकूब के बारे में खबर सुनी। इसलिए लाबन उससे मिलने के लिए दौड़ा। लाबान उससे गले मिला, उसे चूमा और उसे अपने घर लाया। याकूब ने जो कुछ हुआ था, उसे लाबान को बताया। ");
INSERT INTO hin2010_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","तब लाबान ने कहा, “आश्चर्य है, तुम हमारे खानदान से हो।” अतः याकूब लाबान के साथ एक महीने तक रूका। ");
INSERT INTO hin2010_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","एक दिन लाबान ने याकूब से कहा, “यह ठीक नहीं है कि तुम हमारे यहाँ बिना बेतन में काम करते रहो। तुम रिश्तेदार हो, दास नहीं। मैं तुम्हें क्या वेतन दूँ?” ");
INSERT INTO hin2010_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबान की दो पुत्रियाँ थी। बड़ी लिआ थी और छोटी राहेल। ");
INSERT INTO hin2010_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","राहेल सुन्दर थी और लिआ की धुंधली आँखें थीं। ");
INSERT INTO hin2010_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याकूब राहेल से प्रेम करता था। याकूब ने लाबान से कहा, “यदि तुम मुझे अपनी पुत्री राहेल के साथ विवाह करने दो तो मैं तुम्हारे यहाँ सात साल तक काम कर सकता हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबान ने कहा, “यह उसके लिए अच्छा होगा कि किसी दूसरे के बजाय वह तुझसे विवाह करे। इसलिए मेरे साथ ठहरो।” ");
INSERT INTO hin2010_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","इसलिए याकूब ठहरा और सात साल तक लाबान के लिए काम करता रहा। लेकिन यह समय उसे बहुत कम लगा क्योंकि वह राहेल से बहुत प्रेम करता था। ");
INSERT INTO hin2010_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","सात साल के बाद उसने लाबान से कहा, “मुझे राहेल को दो जिससे मैं उससे विवाह करूँ। तुम्हारे यहाँ मेरे काम करने का समय पूरा हो गया।” ");
INSERT INTO hin2010_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","इसलिए लाबान ने उस जगह के सभी लोगों को एक दावत दी। ");
INSERT INTO hin2010_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","उस रात लाबान अपनी पुत्री लिआ को याकूब के पास लाया। याकूब और लिआ ने परस्पर शारीरिक सम्बन्ध स्थापित किया। ");
INSERT INTO hin2010_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(लाबान ने अपनी पुत्री को, सेविका के रूप में अपनी नौकरानी जिल्पा को दिया।) ");
INSERT INTO hin2010_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","सबेरे याकूब ने जाना कि वह लिआ के साथ सोया था। याकूब ने लाबान से कहा, “तुमने मुझे धोखा दिया है। मैंने तुम्हारे लिए कठिन परिश्रम इसलिए किया कि मैं राहेल से विवाह कर सकूँ। तुमने मुझे धोखा क्यों दिया?” ");
INSERT INTO hin2010_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबान ने कहा, “हम लोग अपने देश में छोटी पुत्री का बड़ी पुत्री से पहले विवाह नहीं करने देंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","किन्तु विवाह के उत्सव को पूरे सप्ताह मनाले रहो और मैं राहेल को भी तुम्हें विवाह के लिए दूँगा। परन्तु तुम्हें और सात वर्ष तक मेरी सेवा करनी पड़ेगी।” ");
INSERT INTO hin2010_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","इसलिए याकूब ने यही किया और सप्ताह को बिताया। तब लाबान ने अपनी पुत्री राहेल को भी उसे उसकी पत्नी के रूप में दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(लाबान ने अपनी पुत्री राहेल की सेविका के रूप में अपनी नौकरानी बिल्हा को दिया।) ");
INSERT INTO hin2010_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","इसलिए याकूब ने राहेल के साथ भी शारीरिक सम्बन्ध स्थापित किया और याकूब ने राहेल को लिआ से अधिक प्यार किया। याकूब ने लाबान के लिए और सात वर्ष तक काम किया। ");
INSERT INTO hin2010_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","यहोवा ने देखा कि याकूब लिआ से अधिक राहेल को प्यार करता है। इसलिए यहोवा ने लिआ को इस योग्य बनाया कि वह बच्चों को जन्म दे सके। लेकिन राहेल को कोई बच्चा नहीं हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","लिआ ने एक पुत्र को जन्म दिया। उसने उसका नाम रूबेन रखा। लिआ ने उसका यह नाम इसलिए रखा क्योंकि उसने कहा, “यहोवा ने मेरे कष्टों को देखा है। मेरा पति मुझको प्यार नहीं करता, इसलिए हो सकता है कि मेरा पति अब मुझसे प्यार करे।” ");
INSERT INTO hin2010_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","लिआ फिर गर्भवती हुई और उसने दूसरे पुत्र को जन्म दिया। उसने इस पुत्र का नाम शिमोन रखा। लिआ ने कहा, “यहोवा ने सुना कि मुझे प्यार नहीं मिलता, इसलिए उसने मुझे यह पुत्र दिया।” ");
INSERT INTO hin2010_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","लिआ फिर गर्भवती हुई और एक ओर पुत्र को जन्म दिया। उसने पुत्र का नाम लेवी रखा। लिआ ने कहा, “अब निश्चय ही मेरा पति मुझको प्यार करेगा। मैंने उसे तीन पुत्र दिए हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","तब लिआ ने एक और पुत्र को जन्म दिया। उसने इस लड़के का नाम यहूदा रखा। लिआ ने उसे यह नाम दिया क्योंकि उसने कहा, “अब मैं यहोवा की स्तुति करूँगी।” तब लिआ को बच्चा होना बन्द हो गया। ");
INSERT INTO hin2010_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","राहेल ने देखा कि वह याकूब के लिए किसी बच्चे को जन्म नहीं दे रही है। राहेल अपनी बहन लिआ से ईर्ष्या करने लगी। इसलिए राहेल ने याकूब से कहा, “मुझे बच्चो दो, वरना मैं मर जाऊँगी।” ");
INSERT INTO hin2010_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","याकूब राहेल पर क्रुद्ध हुआ। उसने कहा, “मैं परमेश्वर नहीं हूँ। वह परमेश्वर ही है जिसने तुम्हें बच्चों को जन्म देने से रोका है।” ");
INSERT INTO hin2010_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","तब राहेल ने कहा, “तुम मेरी दासी बिल्हा को ले सकते हो। उसके साथ सोओ और वह मेरे लिए बच्चे को जन्म देगी। तब मैं उसके द्वारा माँ बनूँगी।” ");
INSERT INTO hin2010_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","इस प्रकार राहेल ने अपने पति याकूब के लिए बिल्हा को दिया। याकूब ने बिल्हा के साथ शारीरिक सम्बन्ध किया। ");
INSERT INTO hin2010_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","बिल्हा गर्भवती हुई और याकूब के लिए एक पुत्र को जन्म दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","राहेल ने कहा, “परमेश्वर ने मेरी प्रार्थना सुन ली है। उसने मुझे एक पुत्र देने का निश्चय किया।” इसलिए राहेल ने इस पुत्र का नाम दान रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","बिल्हा दूसरी बार गर्भवती हुई और उसने याकूब को दूसरा पुत्र दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","राहेल ने कहा, “अपनी बहन से मुकाबले के लिए मैंने कठिन लड़ाई लड़ी है और मैंने विजय पा ली है।” इसलिए उसने इस पुत्र क नाम नप्ताली रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","लिआ ने सोचा कि वह और अधिक बच्चों को जन्म नहीं दे सकती। इसलिए उसने अपनी दासी जिल्पा को याकूब के लिए दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","तब जिल्पा ने एक पुत्र को जन्म दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","लिआ ने कहा, “मैं भाग्यवती हूँ। अब स्त्रियाँ मुझे भाग्यवती कहेंगी।” इसलिए उसने पुत्र का नाम गाद रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","जिल्पा ने दूसरे पुत्र को जन्म दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","लिआ ने कहा, “मैं बहुत प्रसन्न हूँ।” इसलिए उसने लड़के का नाम आशेर रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","गेहूँ कटने के समय रूबेन खेतों में गया और कुछ विशेष फूलों को देखा। रूबेन इन फूलों को अपनी माँ लिआ के पास लाया। लेकिन राहेल ने लिआ से कहा, “कृपाकर अपने पुत्र के फूलों में से कुछ मुझे दे दो।” ");
INSERT INTO hin2010_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","लिआ ने उत्तर दिया, “तुमने तो मेरे पति को पहले ही ले लिया है। अब तुम मेरे पुत्र के फूलों को भी ले लेना चाहती हो।” लेकिन राहेल ने उत्तर दिया, “यदि तुम अपने पुत्र के फूल मुझे दोगी तो तुम आज रात याकूब के साथ सो सकती हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","उस रात याकूब खेतों से लौटा। लिआ ने उसे देखा और उससे मिलने गई। उसने कहा, “आज रात तुम मेरे साथ सोओगे। मैंने अपने पुत्र के फूलों को तुम्हारी कीमत के रूप में दिया है।” इसलिए याकूब उस रात लिआ के साथ सोया। ");
INSERT INTO hin2010_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","तब परमेश्वर ने लिआ को फिर गर्भवती होने दिया। उसने पाँचवें पुत्र को जन्म दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","लिआ ने कहा, “परमेश्वर ने मुझे इस बात का पुरस्कार दिया है कि मैंने अपनी दासी को अपने पति को दिया।” इसलिए लिआ ने अपने पुत्र का नाम इस्साकर रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","लिआ फिर गर्भवती हुई और उसने छठे पुत्र को जन्म दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","लिआ ने कहा, “परमेश्वर ने मुझे एक सुन्दर भेंट दी है। अब निश्चय ही याकूब मुझे अपनाएगा, क्योंकि मैंने उसे छः बच्चे दिए है।” इसलिए लिआ ने पुत्र का नाम जबूलून रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","इसके बाद लिआ ने एक पुत्री को जन्म दिया। उसने पुत्रों का नाम दीना रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","तब परमेश्वर ने राहेल की प्रार्थना सुनी। परमेश्वर ने राहेल के लिए बच्चे उत्पन्न करना सभंव बनाया। ");
INSERT INTO hin2010_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","24","राहेल गर्भवती हुई और उसने एक पुत्र को जन्म दिया। राहेल ने कहा, “परमेश्वर ने मेरी लज्जा समाप्त कर दी है और मुझे एक पुत्र दिया है।” इसलिए राहेल ने अपने पुत्र का नाम यूसुफ रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","यूसुफ के जन्म के बाद याकूब ने लाबान से कहा, “अब मुझे अपने घर लौटने दो। ");
INSERT INTO hin2010_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","मुझे मेरी पत्नियाँ और बच्चे दो। मैंने चौदह वर्ष तक तुम्हारे लिए काम करके उन्हें कमाया है। तुम जानते हो कि मैंने तुम्हारी अच्छी सेवा की है।” ");
INSERT INTO hin2010_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","लाबान ने उससे कहा, “मुझे कुछ कहने दो। मैं अनुभव करता हूँ कि यहोवा ने तुम्हारी वजह से मुझ पर कृपा की है। ");
INSERT INTO hin2010_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","बताओ कि तुम्हें मैं क्या हूँ और मैं वही तुमको दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","याकूब ने उत्तर दिया, “तुम जानते हो, कि मैंने तुम्हारे लिए कठिन परिश्रम किया है। तुम्हारी रेवड़े बड़ी हैं और जब तक मैंने उनकी देखभाल की है, ठीक रही है। ");
INSERT INTO hin2010_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","जब मैं आया था, तुम्हारे पास थोड़ी सी थीं। अब तुम्हारे पास बहुत अधिक हैं। हर बार जब मैंने तुम्हारे लिए कुछ किया है यहोवा ने तुम पर कृपा की है। अब मेरे लिए समय आ गया है कि मैं अपने लिए काम करूँ, यह मेरे लिए अपना घर बनाने का समय है।” ");
INSERT INTO hin2010_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","लाबान ने पूछा, “तब मैं तुम्हें क्या दूँ?” याकूब ने उत्तर दिया, “मैं नहीं चाहता कि तुम मुझे कुछ दो। मैं केवल चाहता हूँ कि तुम जो मैंने काम किया है उसकी कीमत चुका दो। केवल यही ेक काम करो। मैं लौटूँगा और तुम्हारी भेड़ों की देखभाल करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","मुझे अपनी सभी रेवड़ों के बीच से जाने दो और दागदार औ धारीदार हर एक मेमने को मुझे ले लेने दो और काली नई बकरी को ले लेने दी हर एक दागदार और धारीदार बकरी को ले लेने दो। यही मेरा वेतन होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","भविष्य में तुम सरलता से देख लोग कि मैं ईम्मानदार हूँ। तुम मेरी रेवड़ों को देखने आ सकते हो। यदि कोई बकरी दागदार नहीं होगी या कोई भेड़ काली नहीं होगी तो तुम जान लोगे कि मैंने उसे चुराया है।” ");
INSERT INTO hin2010_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","लाबान ने उत्तर दिया, “मैं इसे स्वीकार करता हूँ। हम तुमको जो कुछ मागोगे देंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","लेकिन उस दिन लाबान ने दागदार बकरों को छिपा दिया और लाबान ने सभी दागदार या धारीदार बकरियों को छिपा दिया। लाबान ने सभी काली भेड़ों की देखभाल करने को कहा। ");
INSERT INTO hin2010_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","इसलिए पुत्रों ने सभी दागदार जानवरों को लिया और वे दूसरी जगह चले गए। उन्होंने तीन दिन तक यात्रा की। याकूब रूक गया और बच्चे हुए जानवरों की देखभाल करने लगा। किन्तु उनमें कोई जानवर दागदार या काला नहीं था। ");
INSERT INTO hin2010_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","इसलिए याकूब ने चिनार, बादाम और अर्मोन पेड़ों की हरी शाखाएँ काटी। उसने उनकी छाल इस तरह उतारी कि शाखाएँ सफेद धारीदार बन गई। ");
INSERT INTO hin2010_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","याकूब ने पानी पिलाने की जगह पर शाखाओं को रेवड़े के सामने रख दिया। जब जानवर पानी पीने आए तो उस जगह पर वे गाभिन होने के लिए मिले। ");
INSERT INTO hin2010_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","तब बकरियाँ जब शाखाओं के सामने गाभिन होने के लिए मिली तो जो बच्चे पैदा हुए वे दागदार, धारीदार या काले हुए। ");
INSERT INTO hin2010_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","याकूब ने दागदार और काले जानवरों को रेवड़ के अन्य जानवरों से अलग किया। सो इस प्रकार, याकूब ने अपने जानवरों को लाबान के जानवरों से अलग किया। उसने अपनी भेड़ों को लाबान की भेड़ों के पास नहीं भटकने दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","जब कभी रेवड़ में स्वस्थ जानवर गाभिन होने के लिए मिलते थे तब याकूब उनकी आँखों के सामने शाखाएँ रख देता था, उन शाखाओं के करीब ही ये जानवर गाभिन होने के लिए मिलते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","लेकिन जब कमजोर जानवर गाभिन होने के लिए मिलते थे। तो याकूब वहाँ शाखाएँ नहीं रखता था। इस प्रकार कमजोर जानवरों से पैदा बच्चे लाबान के थे। स्वस्थ जानवरों से पैदा बच्चे याकूब के थे। ");
INSERT INTO hin2010_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","इस प्रकार याकूब बहुत धनी हो गया। उसके पास बड़ी रेवड़ें, बहुत से नौकर, ऊँट और गधे थे। ");
INSERT INTO hin2010_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","एक दिन याकूब ने लाबान के पुत्रों को बात करते सुना। उन्होंने कहा, “हम लोगों के पिता का सब कुछ याकूब ने ले लिया है। याकूब धनी हो गया है, और यह सारा धन उसने हमारे पिता से लिया है।” ");
INSERT INTO hin2010_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","याकूब ने यह देखा कि लाबान पहले की तरह प्रेम भाव नहीं रखता है। ");
INSERT INTO hin2010_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","परमेश्वर ने याकूब से कहा, “तुम अपने पूर्वजों के देश को वापस लौट जाओ जहाँ तुम पैदा हुए। मैं तुम्हारे साथ रहूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","इसलिए याकूब ने राहेल और लिआ से उस मैदान में मिलने के लिए कहा जहाँ वह बकरियों और भेड़ों की रेवड़े रखता था। ");
INSERT INTO hin2010_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","याकूब ने राहेल और लिआ से कहा, “मैंने देखा है कि तुम्हारे पिता मुझ से क्रोधित हैं। उन का मेरे प्रति वह पहले जैसा प्रेम—भाव अब नहीं रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","तुम दोनों जानती हो कि मैंने तुम लोगों के पिता के लिए उतनी कड़ी मेहनत की, जितनी कर सकता था। ");
INSERT INTO hin2010_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","लेकिन तुम लोगों के पिता ने मुझे धोखा दिया। तुम्हारे पिता ने मेरा वेतन दस बार बदला है। लेकिन इस पूरे समय में परमेश्वर ने लाबान के सारे धोखों से मुझे बचाया है।” ");
INSERT INTO hin2010_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","“एक बार लाबान ने कहा, ‘तुम दागदार सभी बकरियों को रख सकते हो। यह तुम्हारा होगा।’ जब से उसने यह कहा तब से सभी जानवरों ने धारीदार बच्चे दिए। इस प्रकार वे सभी मेरे थे। लेकिन लाबान ने तब कहा, ‘मैं दागदार बकरियों को रखूँगा। तुम सारी धारीदार बकरियाँ ले सकते हो। यही तुम्हारा वेतन होगा।’ उसके इस तरह कहने के बाद सभी जानवरों न धारीदार बच्चे दिये। ");
INSERT INTO hin2010_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","इस प्रकार परमेश्वर ने जानवरों को तुम लोगों के पिता से ले लिया है और मुझे दे दिया है। ");
INSERT INTO hin2010_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“जिस समय जानवर गाभिन होने के लिए मिल रहे थे मैंने एक स्वप्न देखा। मैंने देखा कि केवल नर जानवर जो गाभिन करने के लिए मिल रहे थे धारीदार और दागदार थे। ");
INSERT INTO hin2010_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","स्वप्न में परमेश्वर के दूत ने मुझ से बातें की। स्वर्गदूत ने कहा, ‘याकूब!’ “मैंने उत्तर दिया, ‘हाँ!’ ");
INSERT INTO hin2010_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“स्वर्गदूत कहा, ‘देखो, केवल दागदार और धारीदार बकरियाँ ही गाभिन होने के लिए मिल रही हैं। मैं ऐसा कर रहा हूँ। मैंने वह सब बुरा देखा है जो लाबान तुम्हारे लिए करता है। मैं यह इसलिए कर रहा हूँ कि सभी नये बकरियों के बच्चे तुम्हारे हो जायें। ");
INSERT INTO hin2010_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","मैं वही परमेश्वर हूँ जिससे तुमने बेतेल में वाचा बाँधी थी। उस जगह तुमने एक स्मरण स्तम्भ बनाया था और जैतून के तेल से उसका अभिषेक किया था और उस जगह तुमने मुझसे एक प्रतिज्ञा की थी। अब, उठो और यह जगह छोड़ दो और वापस अपने जन्म को लौट जाओ।’” ");
INSERT INTO hin2010_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","राहेल और लिआ ने याकूब को उत्तर दिया, “हम लोगों के पिता के पास मरने पर हम लोगों को देने के लिए कुछ नहीं है। ");
INSERT INTO hin2010_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","उसने हम लोगों के साथ अजनबी जैसा व्यवहार किया है। उसने हम लोगों को और तुमको बेच दिया और इस प्रकार हम लोगों का सारा धन उसने खर्च कर दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","परमेश्वर ने यह सारा धन हमारे पिता से ले लिया है और अब यह हमारा है। इसलिए तुम वही करो जो परमेश्वर ने करने के लिए कहा है।” ");
INSERT INTO hin2010_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","इसलिए याकूब ने यात्रा की तैयारी की। उसने अपनी पत्नियों और पुत्रों को ऊँटो पर बैठाया। ");
INSERT INTO hin2010_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","तब वे कनान की ओर लौटने लगे जहाँ उसका पिता रहता था। जानवरों की भी सभी रेवड़ें, जो याकूब की थीं, उनके आगे चल रही थीं। वह वो सभी चीजें साथ ले जा रहा था जो उसने पद्दनराम में रहते हुए प्राप्त की थी। ");
INSERT INTO hin2010_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","इस समय लाबान अपनी भेड़ों का ऊन काटने गया था। जब वह बाहर गया तब राहेल उसके घर में घुसी और अपने पिता के गृह देवताओं को चुरा लाई। ");
INSERT INTO hin2010_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","याकूब ने अरामी लाबान को धोखा दिया। उसने लाबान को वह नहीं बताया कि वह वहाँ से जा रहा है। ");
INSERT INTO hin2010_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","याकूब ने अपने परिवार और अपनी सभी चीजों को लिया तथा शीघ्रता से चल पड़ा। उन्होंने फरात नदी को पार किया और गिलाद पहाड़ की ओर यात्रा की। ");
INSERT INTO hin2010_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","तीन दिन बाद लाबान को पता चला कि याकूब भाग गया। ");
INSERT INTO hin2010_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","इसलिए लाबान ने अपने आदमियों को इकट्ठा किया और याकूब का पीछा करना आरम्भ किया। साद दिन बाद लाबान ने याकूब को गिलाद पहाड़ के पास पाया। ");
INSERT INTO hin2010_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","उस रात परमेश्वर लाबान के पास स्वप्न में प्रकट हुआ। परमेश्वर ने कहा, “याकूब से तुम जो कुछ कहो उसके एक—एक शब्द के लिए सावधान रहो।” ");
INSERT INTO hin2010_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","दूसरे दिन सबेरे लाबान ने याकूब को जा पकड़ा। याकूब ने अपना तम्बू पहाड़ पर लगाया था। इसलिए लाबान और उसके आदमियों ने अपने तम्बू गिलाद पहाड़ पर लगाए। ");
INSERT INTO hin2010_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","लाबान ने याकूब से कहा, “तुमने मुझे धोखा क्यों दिया? तुम मेरी पुत्रियों को ऐसे क्यों ले जा रहे हो मानो वे युद्ध में पकड़ी गई स्त्रियाँ हो? ");
INSERT INTO hin2010_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","मुझसे बिना कहे तुम क्यों भागे? यदि तुमने कहा होता तो मैं तुम्हें दावत देता। उसमें बाजे के साथ नाचना और गाना होता। ");
INSERT INTO hin2010_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","तुमने मुझे अपने नातियों को चूमने तक नहीं दिया और न ही पुत्रियों को विद कहने दिया। तुमने यह करके बड़ी भारी मूर्खता की। ");
INSERT INTO hin2010_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","तुम्हें सचमुच चोट पहुँचाने की शक्ति मुझमें है, किन्तु पिछली रात तुम्हारे पिता का परमेश्वर मेरे स्वप्न में आया। उसने मुझे चेतावनी दी कि मैं किसी प्रकार तुमको चोट न पहुँचाऊँ। ");
INSERT INTO hin2010_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","मैं जानता हूँ कि तुम अपने घर लौटना चाहते हो। यही कारण है कि तुम वहाँ से चल पड़े हो। किन्तु तुमने मेरे घर में देवताओं को क्यों चुराया?” ");
INSERT INTO hin2010_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","याकूब ने उत्तर दिया, “मैं तुमसे बिना कहे चल पड़ा, क्योंकि मैं डरा हुआ था। मैंने सोचा कि तुम अपनी पुत्रियों को मुझसे ले लोगी। ");
INSERT INTO hin2010_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","किन्तु मैंने तुम्हारे देवताओं को नहीं चुराया। यदि तुम यहाँ मेरे पास किसी व्यक्ति को, जो तुम्हारे देवताओं को चुरा लाया है, पाओ तो वह मार दिया जाएगा। तुम्हारे लोग ही मेरे गवाह होंगे। तुम अपनी किसी भी चीज को यहाँ ढूँढ सकते हो। जो कुछ भी तुम्हारा हो, ले लो।” (याकूब को यह पता नहीं था कि राहेल ने लाबान के गृह देवता चुराए हैं।) ");
INSERT INTO hin2010_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","इसलिए लाबान याकूब के तम्बू में गया और उसमें ढूँढा। उसने याकूब के तम्बू में ढूँढा और तब लिआ के तम्बू में भी। तब उसने उस तम्बू में ढूँढा जिसमें दोनों दासियाँ ठहरी थी। किन्तु उसने उसके घर से देवताओं को नहीं पाया। तब लाबान राहेल के तम्बू में गया। ");
INSERT INTO hin2010_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राहेल ने ऊँट की जीन में देवताओं को छिपा रका था और वह उन्हीं पर बैठी थी। लाबान ने पूरे तम्बू में ढूँढा किन्तु वह देवताओं को न खोज सका। ");
INSERT INTO hin2010_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","और राहेल ने अपने पिता से कहा, “पिताजी, मुझ पर क्रुद्ध न हो। मैं आपके सामने खड़ी होने में असमर्थ हूँ। इस समय मेरा मासिकधर्म चल रहा है।” इसलिए लाबान ने पूरे तम्बू में ढूँढा, लेकिन वह उसके घर से देवताओं को नहीं पा सका। ");
INSERT INTO hin2010_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","तब याकूब बहुत क्रुद्ध हुआ। याकूब ने कहा, “मैंने क्या बुरा किया है? मैंने कौन सा नियम तोड़ा है? मेरा पीछा करने और मुझे रोकने का अधिकार तुम्हें कैसे है? ");
INSERT INTO hin2010_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","मेरा जो कुछ है उसमें तुमने ढूँढ लिया। तुमने ऐसी कोई चीज़ नहीं पाई जो तुम्हारी है। यदि तुमने कोई चीज़ पाई हो तो मुझे दिखाओ। उसे यहाँ रखी जिससे हमारे साथी देख सकें। हमारे साथियों को तय करने दो कि हम दोनों में कौन ठीक है। ");
INSERT INTO hin2010_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","मैंने तुम्हारे लिए बीस वर्ष तक काम किया है। इस पूरे समय में बच्चा देते समय कोई मेमना तुम्हारी रेवड़ में से नहीं खाया है। ");
INSERT INTO hin2010_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","यदि कभी जंगली जानवरों ने कोई भेड़ मारी तो मैंने तुरन्त उसकी कीमत स्वयं दे दी। मैंने कभी मरे जानवर को तुम्हारे पास ले जाकर यह नहीं कहा कि इसमें मेरा दोष नहीं। किन्तु रात—दिन मुझे लूटा गया। ");
INSERT INTO hin2010_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","दिन में सूरज मेरी ताकत छीनता था और रात को सर्दी मेरी आँखों से नींद चुरा लेती थी। ");
INSERT INTO hin2010_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","मैंने बीस वर्ष तक तुम्हारे लिए एक दास की तरह काम किया। पहले के चौदह वर्ष मैंने तुम्हारी दो पुत्रियों को पाने के लिए काम किया। बाद में छः वर्ष मैंने तुम्हारे जानवरों को पाने के लिए काम किया और इस बीच तुमने मेरे वेतन दस बार बदला। ");
INSERT INTO hin2010_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","लेकिन मेरे पूर्वजों के परमेश्वर इब्राहीम का परमेश्वर और इसहाक क भय मेरे साथ था। यदि परमेश्वर मेरे साथ नहीं होता तो तुम मुझे खाली हाथ भेज देते। किन्तु परमेश्वर ने मेरी परेशानियों को देखा। परमेश्वर ने मेरे किए काम को देखा और पिछली रात परमेश्वर ने प्रमाणित कर दिया कि मैं ठीक हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","लाबान ने याकूब से कहा, “ये लड़कियाँ मेरी पुत्रियाँ है। उनके बच्चे मेरे हैं। ये जानवर मेरे हैं। जो कुछ भी तुम यहाँ देखते हो, मेरा है। लेकिन मैं अपनी पुत्रियों और उनके बच्चों को रखने के लिए कुछ नहीं कर सकता। ");
INSERT INTO hin2010_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","इसलिए मैं तुमसे एक सन्धि करना चाहता हूँ। हम लोग पत्थरों का एक ढेर लगाएँगे जो यह बताएगा कि हम लोग सन्धि कर चुके हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","इसलिए याकूब ने एक बड़ी चट्टान ढूँढी और उसे यह पता देने के लिए वहाँ रखा कि उसने सन्धि की है। ");
INSERT INTO hin2010_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","इसने अपने पुरुषों की और अधिक चट्टानें ढूँढने और चट्टानों का एक ढेर लगाने को कहा। तब उन्होंने चट्टानों के समीप भोजन किया। ");
INSERT INTO hin2010_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","लाबान ने उस जगह का नाम रखा यज्रा सहादूधा रखा। लेकिन याकूब ने उस जगह का नाम गिलियाद रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबान ने याकूब से कहा, “यह चट्टानों का ढेर हम दोनों को हमारी सन्धि की याद दिलाने में सहायता करेगा।” यह कारण है कि याकूब ने उस जगह को गिलियाद कहा। ");
INSERT INTO hin2010_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","तब लाबान ने कहा, “यहोवा, हम लोगों के एक दूसरे से अलग होने का साक्षी रहे।” इसलिए उस जगह का नाम मिजपा भी होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","तब लाबान ने कहा, “यदि तुम मेरी पुत्रियों की चोट पहुँचाओगे तो याद रखो, परमेश्वर तुमको दण्ड देगा। यदि तुम दूसरी स्त्री से विवाह करोगे तो याद रखो, परमेश्वर तुमको देख रहा है। ");
INSERT INTO hin2010_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","यहाँ ये चट्टानें हैं, जो हमारे बीच में रखी हैं और यह विशेष चट्टान है जो बताएगी कि हमने सन्धि की है। ");
INSERT INTO hin2010_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","चट्टानों का ढेर तथा यह विशेष चट्टान हमें अपनी सन्धि को याद कराने में सहायता करेगी। तुमसे लड़ने के लिए मैं इन चट्टानों के पार कभी नहीं जाऊँगा और तुम मुझसे लड़ने के लिए इन चट्टानों से आगे मेरी ओर कभी नहीं आओगे। ");
INSERT INTO hin2010_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","यदि हम लोग इस सन्धि को तोड़ें तो इब्राहीम का परमेश्वर, नाहोर का परमेश्वर और उनके पूर्वजों का परमेश्वर हम लोगों का न्याय करेगा।” याकूब के पित इसहाक ने परमेश्वर को “भय” नाम से पुकारा। इसलिए याकूब ने सन्धि के लिए उस नाम का प्रयोग किया। ");
INSERT INTO hin2010_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","तब याकूब ने एक पशु को मारा और पहाड़ पर बलि के रूप में भेंट किया और उसने अपने पुरुषों को भोजन में सम्मिलित होने के लिए बुलाया। भोजन करने के बाद उन्होंने पहाड़ पर रात बिताई। ");
INSERT INTO hin2010_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","दूसरे दिन सबेरे लाबान ने अपने नातियों को चूमा और पुत्रियों को बिदा दी। उसने उन्हें आशीर्वाद दिया और घर लौट गया। ");
INSERT INTO hin2010_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याकूब ने भी वह जगह छोड़ी। जब वह यात्रा कर रहा था उसने परमेश्वर के स्वर्गदूत को देखा। ");
INSERT INTO hin2010_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","जब याकूब ने उन्हें देखा तो कहा, “यह परमेश्वर का पड़ाव है।” इसलिए याकूब ने उस जगह का नाम महनैम रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","याकूब का भाई एसाव सेईर नामक प्रदेश में रहता था। यह एदोम का पहाड़ी प्रदेश था। याकूब ने एसाव के पास दूत भेजा। ");
INSERT INTO hin2010_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","याकूब ने दूत से कहा, “मेरे स्वामी एसाव को यह खबर दी: ‘तुम्हारा सेवक याकूब कहता है, मैं इन सारे वर्षों लाबान के साथ रहा हूँ। ");
INSERT INTO hin2010_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","मेरे पास मवेशी, गधे, रेवड़े और बहुत से नौकर हैं। मैं इन्हें तुम्हारे पास भेजता हूँ और चाहता हूँ कि तुम हमें स्वीकार करो।’” ");
INSERT INTO hin2010_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","दूत याकूब के पास लौटा और बोला, “हम तुम्हारे भाई एसाव के पास गए। वह तुमसे मिलने आ रहा है। उसके साथ चार सौ सशस्त्र वीर हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","उस सन्देश ने याकूब को डरा दिया। उसने अपने सभी साथीयों को दो दलों में बाँट दिया। उसने अपनी सभी रेवड़ों, मवेशियों के झुण्ड और ऊँटों को दो भागों में बाँटा। ");
INSERT INTO hin2010_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","याकूब ने सोचा, “यदि एसाव आकर एक भाग को नष्ट करता है तो दूसरा भाग सकता है और बच सकता है।” ");
INSERT INTO hin2010_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","याकूब ने कहा, “हे मेरे पूर्वज इब्राहीम के परमेश्वर। हे मेरे पिता इसहाक के परमेश्वर। तूने मुझे अपने देश में लौटने और अपने परिवार में आने के लिए कहा। तूने कहा कि तू मेरी भलाई करेगा। ");
INSERT INTO hin2010_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","तू मुझ पर बहुत दयालु रहा है। तूने मेरे लिए बहुत अच्छी चीजें की हैं। पहली बार मैंने यरदन नदी के पास यात्रा की, मेरे पास टहलने की छड़ी के अतिरिक्त कुछ भी न था। किन्तु मेरे पास अब इतनी चीजें हैं कि मैं उनको पूरे दो दलों में बाँट सकूँ। ");
INSERT INTO hin2010_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","तुझसे प्रार्थना करता हूँ कि कृपा करके मुझे मेरे भाई एसाव से बचा। मैं उससे डरा हुआ हूँ। इसलिए कि वह आएगा और हम सभी को, यहाँ तक कि बच्चों सहित माताओं को भी जान से मार डालेगा। ");
INSERT INTO hin2010_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","हे यहोवा, तूने मुझसे कहा, ‘मैं तुम्हारी भलाई करूँगा। मैं तुम्हारे परिवार को बढ़ाऊँगा और तुम्हारे वंशजों को समुद्र के बालू के कणों के समान बढ़ा दूँगा। वे इतने अधिक होंगे कि गिने नहीं जा सकेंगे।’” ");
INSERT INTO hin2010_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","याकूब रात को उस जगह ठहरा। याकूब ने कुछ चीजें एसाव को भेंट देने के लिए तैयार की। ");
INSERT INTO hin2010_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","याकूब ने दो सौ बकरियाँ, बीस बकरे, दो सौ भेड़ें तथा बीस नर भेड़े लिए। ");
INSERT INTO hin2010_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","याकूब ने तीस ऊँट और उनके बच्चें, चालीस गायें और दस बैल, बीस गदहियाँ और दस गदहे लिए। ");
INSERT INTO hin2010_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","याकूब ने जानवरों का हर एक झुण्ड नौकरों को दिया। तब याकूब ने नौकरों से कहा, “सब जानवरों के हर झुण्ड को अलग कर लो। मेरे आगे—आगे चलो और हर झुण्ड के बीच कुछ दूरी रखो।” ");
INSERT INTO hin2010_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","याकूब ने उन्हें आदेश दिया। जानवरों के पहले झुण्ड वाले नौकर से याकूब ने कहा, “मेरा भाई एसाव जब तुम्हारे पास आए और तुमसे पूछे, ‘यह किसके जानवर हैं? तुम कहाँ जा रहे हो? तुम किसके नौकर हो?’ ");
INSERT INTO hin2010_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","तब तुम उत्तर देना, ‘ये जानवर आपके सेवक याकूब के हैं। याकूब ने इन्हें अपने स्वामी एसाव को भेंट के रूप में भेजे हैं, और याकूब भी हम लोगों के पीछे आ रहा है।’” ");
INSERT INTO hin2010_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","याकूब ने दूसरे नौकर, तीसरे नौकर, और सभी अन्य नौकरों को यही बात करने का आदेश दिया। उसने कहा, “जब तुम लोग एसाव से मिलो तो यही एक बात कहोगे। ");
INSERT INTO hin2010_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","तुम लोग कहोगे, ‘यह आपकी भेंट है, और आपका सेवक याकूब भी लोगों के पीछे आ रहा है।’” याकूब ने सोचा, “यदि मैं भेंट के साथ इन पुरुषों को आगे भेजता हूँ तो यह हो सकता है कि एसाव मुझे क्षमा कर दे और मुझको स्वीकार कर ले।” ");
INSERT INTO hin2010_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","इसलिए याकूब ने एसाव को भेंट भेजी। किन्तु याकूब उस रात अपने पड़ाव में ही ठहरा। ");
INSERT INTO hin2010_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","बाद में उसी रात याकूब उठा और उस जगह को छोड़ दिया। याकूब ने अपनी दोनों पत्नियों, अपनी दोनों दासियों और अपने ग्यारह पुत्रों को साथ लिया। घाट पर जाकर याकूब ने यब्बोक नदी को पार किया। ");
INSERT INTO hin2010_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","याकूब ने अपने परिवार को नदी के उस पार भेजा। तब याकूब ने अपनी सभी चीजें नदी के उस पार भेज दीं। ");
INSERT INTO hin2010_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","याकूब नदी को पार करने वाला अन्तिम व्यक्ति था। किन्तु पार करने से पहले जब तक वह अकेला ही था, एक व्यक्ति आया और उससे मल्ल युद्ध करने लगा। उस व्यक्ति ने उससे तब तक मल्ल युद्ध किया जब तक सूरज न निकला। ");
INSERT INTO hin2010_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","व्यक्ति ने देखा कि वह याकूब को हरा नहीं सकता। इसलिए उसने याकूब के पैर को उसके कूल्हे के जोड़ पर छुआ। उस समय याकूब के कूल्हे का जोड़ अपने स्थान से हट गया। ");
INSERT INTO hin2010_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","तब उस व्यक्ति ने याकूब से कहा, “मुझे छोड़ दो। सूरज ऊपर चढ़ रहा है।” किन्तु याकूब ने कहा, “मैं तुमको नहीं छोड़ूँगा। मुझको तुम्हें आशीर्वाद देना होगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","और उस व्यक्ति ने उससे कहा, “तुम्हारा क्या नाम है?” और याकूब ने कहा, “मेरा नाम याकूब है।” ");
INSERT INTO hin2010_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","तब व्यक्ति ने कहा, “तुम्हारा नाम याकूब नहीं रहेगा। अब तुम्हारा नाम इस्राएल होगा। मैं तुम्हें यह नाम इसलिए देता हूँ कि तुमने परमेश्वर के साथ और मनुष्यों के साथ युद्ध किया है और तुम हराए नहीं जा सके हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","तब याकूब ने उससे पूछा, “कृपया मुझे अपना नाम बताएं।” किन्तु उस व्यक्ति ने कहा, “तुम मेरा नाम क्यों पूछते हो?” उस समय उस व्यक्ति ने याकूब को आशीर्वाद दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","इसलिए याकूब ने उस जगह का नाम पनीएल रखा। याकूब ने कहा, “इस जगह मैंने परमेश्वर का प्रत्यक्ष दर्शन किया है। किन्तु मेरे जीवन की रक्षा हो गई।” ");
INSERT INTO hin2010_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","जैसे ही वह पनीएल से गुजरा, सूरज निकल आया। याकूब अपने पैरों के कारण लंगड़ाकर चल रहा था। ");
INSERT INTO hin2010_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","इसलिए आज भी इस्राएल के लोग पुट्ठे की माँसपेशी को नहीं खाते क्योंकि इसी माँसपेशी पर याकूब को चोट लगी थी। ");
INSERT INTO hin2010_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","याकूब ने दृष्टि उठाई और एसाव को आते हुए देखा। एसाव आ रहा था और उसके साथ चार सौ पुरुष थे। याकूब ने अपने परिवार को चार समूहों में बाँटा। लिआ और उसके बच्चे एक समूह में थे, राहेल और यूसुफ एक समूह में थे, दासी और उनके बच्चे दो समूहों में थे। ");
INSERT INTO hin2010_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","याकूब ने दासियों और उनके बच्चों को आगे रखा। उसके बाद उनके पीछे लिआ और उसके बच्चों को रखा और याकूब ने राहेल और यूसुफ को सबके अन्त में रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","याकूब स्वयं एसाव की ओर गया। इसलिए वह पहला व्यक्ति था जिसके पास एसाव आया। अपने भाई की ओर बढ़ते समय याकूब ने सात बार ज़मीन पर झुककर प्रणाम किया। ");
INSERT INTO hin2010_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","तब एसाव ने याकूब को देखा, वह उससे मिलने को दौड़ पड़ा। एसाव ने याकूब को अपनी बाहों में भर लिया और छाती से लगाया। तब एसाव ने उसकी गर्दन को घूमा और दोनों आनन्द में रो पड़े। ");
INSERT INTO hin2010_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","एसाव ने नज़र उठाई और स्त्रियों तथा बच्चों को देखा। उसने कहा, “तुम्हारे साथ ये कौन लोग हैं?” याकूब ने उत्तर दिया, “ये वे बच्चे हैं जो परमेश्वर ने मुझे दिए है। परमेश्वर मुझ पर दयालु रहा है।” ");
INSERT INTO hin2010_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","तब दोनों दासियाँ अपने बच्चों के साथ एसाव के पास गए। उन्होंने उसको झुककर प्रणाम किया। ");
INSERT INTO hin2010_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","तब लिआ अपने बच्चों के साथ एसाव के सामने गई और उसने प्रणाम किया और तब राहेल और यूसुफ एसाव के सामने गए और उन्होंने भी प्रणाम किया। ");
INSERT INTO hin2010_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","एसाव ने कहा, “मैंने जिन सब लोगों को यहाँ आते समय देखा वे कौन थे? और वे सभी जानवर किसलिए थे?” याकूब ने उत्तर दिया, “वे तुमको मेरी भेट है जिससे तुम मुझे स्वीकार कर सको!” ");
INSERT INTO hin2010_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","किन्तु एसाव ने कहा, “भाई, तुम्हें मुझको कोई भेंट नहीं देनी चाहिए क्योंकि मेरे पास सब कुछ बहुतायत से हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकूब ने कहा, “नहीं! मैं तुमसे विनती करता हूँ। यदि तुम सचमुच मुझे स्वीकार करते हो तो कृपया जो भेटें देता हूँ तुम स्वीकार करो। मैं तुमको दुबारा देख कर बहुत प्रसन्न हूँ। यह तो परमेश्वर को देखने जैसा है। मैं यह देखकर बहुत प्रसन्न हूँ कि तुमने मुझे स्वीकार किया है। ");
INSERT INTO hin2010_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","इसलिए मैं विनती करता हूँ कि जो भेंट मैं देता हूँ उसे भी स्वीकार करो। परमेश्वर मेरे ऊपर बहुत कृपालु रहा है। मेरे पास अपनी आवश्यकता से अधिक हैं।” इस प्रकार याकूब ने एसाव से भेंट स्वीकार करने को विनती की। इसलिए एसाव ने भेंट स्वीकार की। ");
INSERT INTO hin2010_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","तब एसाव ने कहा, “अब तुम अपनी यात्रा जारी रख सकते हो। मैं तुम्हारे साथ चलूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","किन्तु याकूब ने उससे कहा, “तुम यह जानते हो कि मेरे बच्चे अभी कमज़ोर हैं और मुझे अपनी रेवड़ों और उनके बच्चों की विशेष देख—रेख करनी चाहिए। यदि मैं उन्हें बहुत दूर एक दिन में चलने के लिए विवश करता हूँ तो सभी पशु मर जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","इसलिए तुम आगे चलो और मैं धीरे—धीरे तुम्हारे पीछे आऊँगा। मैं पशुओं और अन्य जानवरों की रक्षा के लिए काफी धीरे—धीरे बढ़ूँगा और मैं काफी धीरे—धीरे इसलिए चलूँगा कि मेरे बच्चे बहुत अधिक थक न जाए। मैं सेईर में तुमसे मिलूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","इसलिए एसाव ने कहा, “तब मैं अपने कुछ साथियों को तुम्हारी सहायता के लिए छोड़ दूँगा।” किन्तु याकूब ने कहा, “यह तुम्हारी विशेष दया है। किन्तु ऐसा करने की कोई आवश्यकता नहीं है।” ");
INSERT INTO hin2010_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","इसलिए उस दिन एसाव सेईर की वापसी यात्रा पर चल पढ़ा। ");
INSERT INTO hin2010_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","किन्तु याकूब सुक्कोत को गया। वहाँ उसने अपने लिए एक घर बनाया और अपने मवेशियों के लिए छोटी पशुशालाएँ बनाई। इसी कारण इस जगह का नाम सुक्कोत रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","बाद में याकूब ने अपना जो कुछ था उसे कनान प्रदेश से शकेम नगर को भेज दिया। याकूब ने नगर के समीप मैदान में अपना डेरा डाला। ");
INSERT INTO hin2010_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","याकूब ने उस भूमि को शकेम के पिता हमोर के परिवार से खरीदा। याकूब ने चाँदी के सौ सिक्के दिए। ");
INSERT INTO hin2010_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","याकूब ने परमेश्वर की उपासना के लिए वहाँ एक विशेष स्मरण स्तम्भ बनाया। याकूब ने जगह का नाम “एले, इस्राएल का परमेश्वर” रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","दीना लिआ और याकूब की पुत्री थी। एक दिन तीना उस प्रदेश की स्त्रियों को देखने के लिए बाहर गई। ");
INSERT INTO hin2010_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","उस प्रदेस के राजा हमोर के पुत्र शकेम ने दीना को देखा। उसने उसे पकड़ लिया और अपने साथ शारीरीक सम्बन्ध करने के लिए उसे विवश किया। ");
INSERT INTO hin2010_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","शकेम दने से प्रेम करने लगा और उससे विवाह करना चाहा। ");
INSERT INTO hin2010_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","शकेम ने अपने पिता से कहा, “कृपया इस लड़की को प्राप्त करें जिससे मैं इसके साथ विवाह कर सकूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","याकूब ने यह जान लिया कि शकेम ने उसको पुत्री के साथ ऐसी बुरी बात की है। किन्तु याकूब के सभी पुत्र अपने पशुओं के साथ मैदान में गए थे। इसलिए वे जब तक नहीं आए, याकूब ने कुछ नहीं किया। ");
INSERT INTO hin2010_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","उस समय शकेम का पिता हमोर याकूब के साथ बात करने गया। ");
INSERT INTO hin2010_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","खेतों में याकूब के पुत्रों ने जो कुछ हुआ था, उसकी खबर सुनी। जब उन्होंने यह सुना तो वे बहुत क्रुद्ध हुए। वे पागल से हो गए क्योंकि शकेम ने याकूब की पुत्री के साथ सोकर इस्राएल को कलंकित किया था। शकेम ने बहुत घिनौनी बात की थी। इसलिए सभी भाई खेतों से घर लौटे। ");
INSERT INTO hin2010_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","किन्तु हमोर ने भाईयों से बात की। उसने कहा, “मेरा पुत्र शकेम दीना से बहुत प्रेम करता है। कृपया उसे इसके साथ विवाह करने दो। ");
INSERT INTO hin2010_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","यह विवाह इस बात का प्रमाण होगा कि हम लोगों ने विशेष सन्धि की है। तब हमारे लोग तुम लोगों की स्त्रियों और तुम्हारे लोग हम लोगों की स्त्रियों के साथ विवाह कर सकते हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","तुम लोग हमारे साथ एक प्रदेश में रह सकते हो। तुम भूमि के स्वामी बनने और यहाँ व्यापार करने के लिए स्वतन्त्र होगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","शकेम ने भी याकूब और भाईयों से बात की। शकेम ने कहा, “कृपया मुझे स्वीकार करें और मैंने जो किया उसके लिए क्षमा करें। मुझे जो कुछ आप लोग करने को कहेंगे, करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","मैं कोई भी भेंट जो तुम चाहोगे, दूँगा, अगर तुम मुझे दीना के साथ विवाह करने दोगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","याकूब के पुत्रों ने शकेम और उसके पिता से झूठ बोलने का निश्चय किया। भाई अभी भी पागल हो रहे थे क्योंकि शकेम ने उनकी बहन दीना के साथ ऐसा घिनौना व्यवहार किया था। ");
INSERT INTO hin2010_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","इसलिए भाईयों ने उससे कहा, “हम लोग तुम्हें अपनी बहन के साथ विवाह नहीं करने देंगे क्योंकि तुम्हारा खतना अभी नहीं हुआ है। हमारी बहन का तुमसे विवाह करना अनुचित होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","किन्तु हम लोग तुम्हें उसके साथ विवाह करने देंगे यदि तुम यही एक काम करो कि तुम्हारे नगर के हर पुरुष का खतना हम लोगों की तरह हो जाए। ");
INSERT INTO hin2010_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","तब तुम्हारे पुरुष हमारी स्त्रियों से विवाह कर सकते हैं और हमारे पुरुष तुम्हारी स्त्रियों से विवाह कर सकते हैं। तब हम एक ही लोग बन जाएँगे। ");
INSERT INTO hin2010_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","यदि तुम खतना कराना अस्वीकार करते हो तो हम लोग दीना को ले जाएँगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","इस सन्धि ने हमोर और शकेम को बहुत प्रसन्न किया। ");
INSERT INTO hin2010_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","दीना के भाईयों ने जो कुछ कहा उसे कहने में शकेम बहुत प्रसन्न हुआ। शकेम परिवार का सबसे अधिक प्रतिष्ठित व्यक्ति था। ");
INSERT INTO hin2010_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","हमोर और शकेम अपने नगर के सभास्थल को गए। उन्होंने नगर के लोगों से बातें कीं और कहा, ");
INSERT INTO hin2010_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“इस्राएल के ये लोग हमारे मित्र होना चाहते हैं। हम लोग उन्हें अपने प्रदेश में रहने देना चाहते हैं और अपने साथ शान्ति बनाए रखना चाहते हैं। हम लोग के पास अपने सभी लोगों के लिए काफी भूमि है। हम लोग इनकी स्त्रियों के साथ विवाह करने को स्वतन्त्र हैं और हम लोग अपनी स्त्रियाँ उनको विवाह के लिए देने में प्रसन्न हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","किन्तु एक बात है जिसे करने के लिए हम सभी को सन्धि करनी होगी। ");
INSERT INTO hin2010_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","यदि हम ऐसा करेंगे तो उनके पशुओं तथा जानवरों से हम धनी हो जाएँगे। इसलिए हम लोग उनके साथ यह सन्धि करें और वे यहीं हम लोगों के साथ रहेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","सभास्थल पर जिन लोगों ने यह बात सुनी वे हमोर और शकेम के साथ सहमत हो गए और उस समय हर एक पुरुष का खतना कर दिया गया। ");
INSERT INTO hin2010_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","तीन दिन बाद खतना कर दिए गए पुरुष अभी ज़ख्मी थे। याकूब के दो पुत्र शिमोन और लेवी जानते थे कि इस समय लोग कमज़ोर होगें, इसलिए वे नगर को गए और उन्होंने सभी पुरुषों को मार डाला। ");
INSERT INTO hin2010_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","दीना के भाई शिमोन और लेवी ने हमोर और उसके पुत्र शकेम को मार डाला। उन्होंने दीना को शकेम के घर से निकाल लिया और वे चले आए। ");
INSERT INTO hin2010_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","याकूब के अन्य पुत्र नगर में गए और उन्होंने वहाँ जो कुछ था, लूट लिया। शकेम ने उनकी बहन के साथ जो कुछ किया था, उससे वे तब तक क्रुद्ध थे। ");
INSERT INTO hin2010_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","इसलिए भाईयों ने उनके सभी जानवर ले लिए। उन्होंने उनके गधे तथा नगर और खेतों मे अन्य जो कुछ था सब ले लिया। ");
INSERT INTO hin2010_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","भाईयों ने उन लोगों का सब कुछ ले लिया। भाईयों ने उनकी पत्नियों और बच्चों तक को ले लिया। ");
INSERT INTO hin2010_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","किन्तु याकूब ने शिमोन और लेवी से कहा, “तुम लोगों ने मुझे बहुत कष्ट दिया है और इस प्रदेश के निवासियों के मन में घृणा उत्पन्न करायी। सभी कनानी और परिजी लोग हमारे विरुद्ध हो जाएँगे। यहाँ हम बहुत थोड़े हैं। यदि इस प्रदेश के लोग हम लोगों के विरुद्ध लड़ने के लिए इकट्ठे होंगे तो मैं नष्ट हो जाऊँगा और हमारे साथ हमारे सभी लोग नष्ट हो जाएँगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","किन्तु भाईयों ने उत्तर दिया, “क्या हम लोग उन लोगों को अपनी बहन के साथ वेश्या जैसा व्यवहार करने दें? नहीं हमारी बहन के साथ वैसा व्यवहार करने वाले लोग बुरे थे।” ");
INSERT INTO hin2010_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","परमेश्वर ने याकूब से कहा, “बेतेल नगर को जाओ, वहाँ बस जाओ और वहाँ उपासना की वेदी बनाओ। परमेश्वर को याद करो, वह जो तुम्हारे सामने प्रकट हुआ था जब तुम अपने भाई एसाव से बच कर भाग रहे थे। उस परमेश्वर की उपासना के लिए वहाँ वेदी बनाओ।” ");
INSERT INTO hin2010_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","इसलिए याकूब ने अपने परिवार और अपने सभी सेवकों से कहा, “लकड़ी और धातु के बने जो झूठे देवता तुम लोगों के पास हैं उन्हें नष्ट कर दी। अपने को पवित्र करो। साफ कपड़े पहनो। ");
INSERT INTO hin2010_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","हम लोग इस जगह छोड़ेंगे और बेतेल को जाएँगे। उस जगह में अपने परमेश्वर के लिए एक वेदी बनायेंगे। यह वही परमेश्वर हैं जो मेरे कष्टों के समय में मेरी सहायता की और जहाँ कहीं मैं गया वह मेरे साथ रहा।” ");
INSERT INTO hin2010_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","इसलिए लोगों के पास जो झूठे देवता थे, उन सभी को उन्होंने याकूब को दे दिया। उन्होंने अपो कानों में पहनी दुई सभी बालियों को भी याकूब को दे दिया। याकूब ने शकेम नाम के शहर के समीप एक सिन्दूर के पेड़ के नीचे इन सभी चीज़ों को गाड़ दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","याकूब और उसके पुत्रों ने वह जगह छोड़ दी। उस क्षेत्र के लोग उनका पीछा करना चाहते थे और उन्हें मार डालना चाहते थे। किन्तु वे बहुत डर गए और उन्होंने याकूब का पीछा नहीं किया। ");
INSERT INTO hin2010_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","इसलिए याकूब और उसके लोग लूज पहुँचे। अब लूज को बेतेल कहते हैं। यह कनान प्रदेश में है। ");
INSERT INTO hin2010_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","याकूब ने वहाँ एक वेदी बनायी। याकूब ने उस जगह का नाम “एलबेतेल” रखा। याकूब ने इस नाम को इसलिए चुना कि जब वह अपने भाई के यहाँ से भाग रहा था, तब पहली बार परमेश्वर यहीं प्रकट हुआ था। ");
INSERT INTO hin2010_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","रिबका की धाय दबोरा यहाँ मरी थी, उन्होंने बेतेल में सिन्दूर के पेड़ के नीचे उसे दफनाया। उन्होंने उस स्थान का नाम अल्लोन बक्कूत रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","जब याकूब पद्दनराम से लौट तब परमेश्वर फिर उसके सामने प्रकट हुआ। परमेश्वर ने याकूब को आशीर्वाद दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","परमेश्वर ने याकूब से कहा, “तुम्हारा नाम याकूब है। किन्तु मैं उस नाम को बदलूँगा। अब तुम याकूब नहीं कहलाओगे। तुम्हारा नया नाम इस्राएल होगा।” इसलिए इसके बाद याकूब का नाम इस्राएल हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","परमेश्वर ने उससे कहा, “मैं सर्वशक्तिमान परमेश्वर हूँ और तुमको मैं यह आशीर्वाद देता हूँ तुम्हारे बहुत बच्चे हों और तुम एक महान राष्ट्र बन जाओ। तुम ऐसा राष्ट्र बनोगे जिसका सम्मान अन्य सभी राष्ट्र करेंगे। अन्य राष्ट्र और राजा तुमसे पैदा होंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","मैंने इब्राहीम और इसहाक को कुछ विशेष प्रदेश दिए थे। अब वह प्रदेश मैं तुमको देता हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","तब परमेश्वर ने वह जगह छोड़ दी। ");
INSERT INTO hin2010_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","15","याकूब ने इस स्थान पर एक विशेष चट्टान खड़ी की। याकूब ने उस पर दाखरस और तेल चढ़ाकर उस चट्टान को पवित्र बनाया। वह एक विशेष स्थान था क्योंकि परमेश्वर ने वहाँ याकूब से बात की थी और याकूब ने उस स्थान का नाम बेतेल रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","याकूब और उसके दल ने बेतेल को छोड़ा। एप्राता (बेतलेहेम) आने से ठीक पहले राहेल अपने बच्चे को जन्म देने लगी। ");
INSERT INTO hin2010_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","लेकिन राहेल को इस जन्म से बहुत कष्ट होने लगा। उसे बहुत दर्द हो रहा था। राहेल की धाय ने उसे देखा और कहा, “राहेल, डरो नहीं। तुम एक और पुत्र को जन्म दे रही हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","पुत्र को जन्म देते समय राहेल मर गई। मरने के पहले राहेल ने बच्चे का नाम बेनोनी रखा। किन्तु याकूब ने उसका नाम बिन्यामीन रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","एप्राता को आनेवाली सड़क पर राहेल को दफनाया गया। (एप्राता बेतलेहेम है) ");
INSERT INTO hin2010_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","और याकूब ने राहेल के सम्मान में उसकी कब्र पर एक विशेष चट्टान रखी। वह विशेष चट्टान वहाँ आज तक है। ");
INSERT INTO hin2010_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","तब इस्राएल (याकूब) ने अपनी यात्रा जारी रखी। उसने एदेर स्तम्भ के ठीक दक्षिण में अपना डेरा डाला। ");
INSERT INTO hin2010_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","इस्राएल वहाँ थोड़े समय ठहरा। जब वह वहाँ था तब रूबेन इस्राएल की दासी बिल्हा के साथ सोया। इस्राएल ने इस बारे में सुना और बहुत क्रुद्ध हुआ। याकूब (इस्राएल) के बारह पुत्र थे। ");
INSERT INTO hin2010_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","उसकी पत्नी लिआ से उसके छः पुत्र थे: रूबेन, शिमोन, लेवी, यहूदा, इस्साकार, जबूलून। ");
INSERT INTO hin2010_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","उसकी पत्नी राहेल से उसके दो पुत्र थे: यूसुफ, बिन्यामीन। ");
INSERT INTO hin2010_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","राहेल की दासी बिल्हा से उसके दो पुत्र थे: दान, नप्ताली। ");
INSERT INTO hin2010_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","और लिआ की दासी जिल्पा से उसके दो पुत्र थे: गाद, आशेर। ये याकूब (इस्राएल) के पुत्र हैं जो पद्दनराम में पैदा हुए थे। ");
INSERT INTO hin2010_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","मम्रे के किर्यतर्बा (हेब्रोन) में याकूब अपने पिता इसहाक के पास गया। यह वही जगह है जहाँ इब्राहीम और इसहाक रह चुके थे। ");
INSERT INTO hin2010_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाक एक सौ अस्सी वर्ष का था। ");
INSERT INTO hin2010_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","इसहाक बहुत वर्षों तक जीवित रहा। जब वह मरा, वह बहुत बुढ़ा था। उसके पुत्र एसाव और याकूब ने उसे वहीं दफनाया जहाँ उसका पिता को दफनाया गया था। ");
INSERT INTO hin2010_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसाव ने कनान देश की पुत्रियों से विवाह किया। यह एसाव के परिवार की एक सूची है। (जो एदोम भी कहा जाता है।) ");
INSERT INTO hin2010_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसाव की पत्नियाँ थी: आदा, हित्ती एलीन की पुत्री। ओहोलीबामा हिव्वी सिबोन की नतिनी और अना की पुत्री। ");
INSERT INTO hin2010_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","बासमत इश्माएल की पुत्री और नबायोत की बहन। ");
INSERT INTO hin2010_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","आदा ने एसाव को एक पुत्र एलीपज दिया। बासमत को रुएल नाम का पुत्र हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ओहोलीबामा ने एसाव को तीन पुत्र दिए यूश, यालाम और कोरह ये एसाव के पुत्र थे। ये कनान प्रदेश में पैदा हुए थे। ");
INSERT INTO hin2010_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","याकूब और एसाव के परिवार अब बहुत बढ़ गये और कनान में इस बड़े परिवार का खान—पान जुटा पाना कठिन हो गया। इसलिए एसाव ने कनान छोड़ दिया और अपने भाई याकूब से दूर दूसरे प्रदेश में चला गया। एसाव अपनी सभी चीज़ों को अपने साथ लाया। कनान में रहते हुए उसने ये चीज़ें प्राप्त की थीं। इसलिए एसाव अपने साथ अपनी पत्नियों, पुत्रों, पुत्रियों सभी सेवकों, पशु और अन्य जानवरों को लाया। एसाव और याकूब के परिवार इतने बड़े हो रहे थे कि उनका एक स्थान पर रहना कठिन था। वह भूमि दोनों परिवारों के पोषण के लिए काफी बड़ी नहीं थी। उनके पास अत्याधिक पशु थे। एसाव पहाड़ी प्रदेश सेईर की ओर बढ़ा। (एसाव का नाम एदोम भी है।) ");
INSERT INTO hin2010_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","एसाव एदोम के लोगों का आदि पिता है। सेईर एदोम के पहाड़ी प्रदेश में रहने वाले एसाव के परिवार के ये नाम हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसाव के पुत्र थे, एलीपज, आदा और एसाव का पुत्र। रुएल बासमत और एसाव का पुत्र। ");
INSERT INTO hin2010_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","एलीपज के पाँच पुत्र थे: तेमान, ओमार, सपो, गाताम, कनज। ");
INSERT INTO hin2010_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एलीपज की एक तिम्ना नामक दासी भी थी। लिम्ना और एलीपज ने अमालेक को जन्म दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रुएल के चार पुत्र थे: नहत, जेरह, शम्मा मिज्जा। वे एसाव की पत्नी बासमत से उसके पौत्र हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","एसाव की तीसरी पत्नी अना की पुत्री ओहोलीबामा थी। (अना सिबोन का पुत्र था।) एसाव और ओहोलीबमा के पुत्र थे: यूश, यालाम, कोरह। ");
INSERT INTO hin2010_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसाव से चलने वाले वंश ये ही हैं। एसाव का पहला पुत्र एलीपज था। एलीपज से आए: तेमान, ओमार, सपो, कनज, ");
INSERT INTO hin2010_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोरह, गाताम, अमालेक। ये सभी परिवार एसाव की पत्नी आदा से आए। ");
INSERT INTO hin2010_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसाव का पुत्र रुएल इन परिवारों का आदि पिता था: नहत, जेरह, शम्मा, मिज्जा। ये सभी परिवार एसाव की पत्नी बासमत से आए। ");
INSERT INTO hin2010_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","अना की पुत्री एसाव की पत्नी ओहोलीबामा ने यूश, यालाम और कोरह को जन्म दिया। ये तीनों अपने—अपने परिवारों के पिता थे। ");
INSERT INTO hin2010_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ये सभी परिवार एसाव से चले। ");
INSERT INTO hin2010_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","एसाव के पहले एदोम में सेईर नामक एक होरी व्यक्ति रहता था। सेईर के पुत्र ये है: लोतान, शोबाल, शिबोन, अना ");
INSERT INTO hin2010_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीशोन, एसेर, दिशान। ये पुत्र अपने परिवारों के मुखिया थे। ");
INSERT INTO hin2010_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतान, होरी, हेमाम का पिता था। (तिम्ना लोतान की बहन थी।) ");
INSERT INTO hin2010_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबल, आल्वान, मानहत एबल शपो, ओनाम का पिता था। ");
INSERT INTO hin2010_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","शिबोन के दो पुत्र थे: अथ्या, अना, (अना वह व्यक्ति है जिसने अपने पिता के गधों की देखभाल करते समय पहाड़ों में गर्म पानी का सोता ढूँढा।) ");
INSERT INTO hin2010_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अना, दीशोन और ओहोलीबामा का पिता था। ");
INSERT INTO hin2010_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दीशोन के चार पुत्र थे: हेमदान, एश्वान, यित्रान, करान। ");
INSERT INTO hin2010_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसेर के तीन पुत्र थे: बिल्हान, जावान, अकान। ");
INSERT INTO hin2010_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीशान के दो पुत्र थे: ऊस और अरान। ");
INSERT INTO hin2010_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ये होरी परिवारों के मुखियाओं के नाम है। लोतान, शोबाल, शिबोन, अना। ");
INSERT INTO hin2010_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दिशोन, एसेर, दीशोन। ये व्यक्ति उन परिवारों के मुखिया थे जो सेईर (एदोम) प्रदेश में रहते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","उस समय एदोम में कोई राजा थे। इस्राएल में राजाओं के होने के बहुत पहले ह एदोम में राजा थे। ");
INSERT INTO hin2010_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बोर का पुत्र बेला एदोम में शासन करने वाला राजा था। वह दिन्हावा नगर पर शासन करता था। ");
INSERT INTO hin2010_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","जब बेला मरा तो योबाब राजा हुआ। योबाब बोस्रा से जेरह का पुत्र था। ");
INSERT INTO hin2010_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","जब योबाब मरा, हूशाम ने शासन किया। हूशाम तेमानी लोगों के देश का था। ");
INSERT INTO hin2010_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","जब हूशाम मरा, हदद ने उस क्षेत्र पर शासन किया। हदद बदद का पुत्र था। (हदद वह व्यक्ति था जिसने मिद्यानी लोगों को मोआब देश में हराया था।) हदद अबीत नगर का था। ");
INSERT INTO hin2010_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","जब हदद मरा, सम्ला ने उस प्रदेश पर शासन किया। सम्ला मस्रेका था। ");
INSERT INTO hin2010_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","जब सम्ला मरा, शाऊल ने उस क्षेत्र पर शासन किया। शाऊल फरात नदी के किनारे रहोबोत का था। ");
INSERT INTO hin2010_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","जब शाऊल मरा, बाल्हानान ने उस देश पर शासन किया। बाल्हानान अकबोर का पुत्र था। ");
INSERT INTO hin2010_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","जब बाल्हानान मरा, हदर ने उस देश पर शासन किया। हदर पाऊ नगर का था। मत्रेद की पुत्री हदर की पत्नी का नाम महेतबेल था। (मत्रेद का पिता मेजाहब था।) ");
INSERT INTO hin2010_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","एदोमी परिवारों: तिम्ना, अल्बा, यतेत, ओहोलीबामा, एला, पीपोन, कनज, तेमान, मिबसार, मग्दीएल और ईराम आदि का पिता एसाब था। हर एक परिवार एक ऐसे प्रदेश में रहता था जिसका नाम वही था जो उनका पारिवारिक नाम था। ");
INSERT INTO hin2010_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकूब ठहर गया और कनान प्रदेश में रहने लगा। यह वही प्रदेश है जहाँ उसका पिता आकर बस गया था। ");
INSERT INTO hin2010_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","याकूब के परिवार की यही कथा है। यूसुफ एक सत्रह वर्ष का युवक था। उसका काम भेड़ बकरियों कि देखभाल करना था। यूसुफ यह काम अपने भाईयों यानि कि बिल्हा और जिल्पा के पुत्रों के साथ करता था। (बिल्हा और जिल्पा उस के पिता की पत्नियाँ थी) ");
INSERT INTO hin2010_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","यूसुफ अपने पिता को अपने भाईयों की बुरी बातें बताया करता था। यूसुफ उस समय उत्पन्न हुआ जब उसका पिता इस्राएल बहुत बढ़ा था। इसलिए इस्राएल यूसुफ को अपने अन्य पुत्रों से अधिक प्यार करता था। याकूब ने अपने पुत्र को एक विशेष अंगरखा दिया। यह अंगरखा लम्बा और बहुत सुन्दर था। ");
INSERT INTO hin2010_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","यूसुफ के भाइयों ने देखा कि उनका पिता उनकी अपेक्षा यूसुफ को अधिक प्यार करता है। वे इसी कारण अपने भाई से घृणा करते थे। वे यूसुफ से अच्छी तरह बात नहीं करते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","एक बार यूसुफ ने एक विशेष सपना देखा। बाद में यूसुफ ने अपने इस सपने के बारे में अपने भाईयों को बताया। इसके बाद उसके भाई पहले से भी अधिक उससे घृणा करने लगे। ");
INSERT INTO hin2010_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","यूसुफ ने कहा, “मैंने एक सपना देखा। ");
INSERT INTO hin2010_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","हम सभी खेत में काम कर रहे थे। हम लोग गेहूँ को एक साथ गट्ठे बाँध रहे थे। मेरा गट्ठा खड़ा हुआ और तुम लोगों के गट्ठों ने मेरे गट्ठें के चारों ओर घेरा बनाया। तब तुम्हारे सभी गट्ठों ने मेरे गट्ठे को झुककर प्रणाम किया।” ");
INSERT INTO hin2010_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","उसके भाईयों ने कहा, “क्या, तुम सोचते हो कि इसका अर्थ है कि तुम राजा बनोगे और हम लोगों पर शासन करोगे?” उसके भाईयों ने यूसुफ से अब और अधिक घृणा करनी आरम्भ की क्योंकि उसने उनके बारे में सपना देखा था। ");
INSERT INTO hin2010_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","तब यूसुफ ने दूसरा सपना देखा। यूसुफ ने अपने भाईयों से इस सपने के बारे में बताया। यूसुफ ने कहा, “मैंने दूसरा सपना देखा है। मैंने सूरज, चाँद और ग्यारह नक्षत्रों को अपने को प्रणाम करते देखा।” ");
INSERT INTO hin2010_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","यूसुफ ने अपने पिता को भी इस सपने के बारे में बताया। किन्तु उसके पिता ने इसकी आलोचना की। उसके पिता ने कहा, “यह किस प्रकार का सपना है? क्या तुम्हें विश्वास है कि तुम्हारी माँ, तुम्हारे भाई और हम तुमको प्रणाम करेंगे?” ");
INSERT INTO hin2010_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","यूसुफ के भाई उससे लगातार इर्षा करते रहे। किन्तु यूसुफ के पिता ने इन सभी बातों के बारे में बहुत गहराई से विचार किया और सोचा कि उनका अर्थ क्या होगा? ");
INSERT INTO hin2010_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","एक दिन यूसुफ के भाई अपने पिता की भेड़ों की देखभाल के लिए शकेम गए। ");
INSERT INTO hin2010_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","याकूब ने यूसुफ से कहा, “शकेम जाओ। तुम्हारे भाई मेरी भेड़ों के साथ वहाँ हैं।” यूसुफ ने उत्तर दिया, “मैं जाऊँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","यूसुफ के पिता ने कहा, “जाओ और देखो कि तुम्हारे भाई सुरक्षित है। लौटकर आओ और बताओ कि क्या मेरी भेड़ें ठीक है?” इस प्रकार यूसुफ के पिता ने उसे हेब्रोन की घाटी से शकेम को भेजा। ");
INSERT INTO hin2010_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","शकेम में यूसुफ खो गया। एक व्यक्ति ने उसे खेतों में भटकते हुए पया। उस व्यक्ति ने कहा, “तुम क्या खोज रहे हो?” ");
INSERT INTO hin2010_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","यूसुफ ने उत्तर दिया, “मैं अपने भाईयों को खोज रहा हूँ। क्या तुम बता सकते हो कि वे अपनी भेड़ों के साथ कहाँ हैं?” ");
INSERT INTO hin2010_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","व्यक्ति ने उत्तर दिया, “वे पहले ही चले गए है। मैंने उन्हें कहते हुए सुना कि वे दोतान को जा रहे हैं।” इसलिए यूसुफ अपने भाईयों के पीछे गया और उसने उन्हें दोतान में पाया। ");
INSERT INTO hin2010_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","यूसुफ के भाईयों ने बहुत दूर से उसे आते देखा। उन्होंने उसे मार डालने की योजना बनाने का निश्चय किया। ");
INSERT INTO hin2010_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","भाईयों ने एक दूसरे से कहा, “यह सपना देखने वाला यूसुफ आ रहा है। ");
INSERT INTO hin2010_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","मौका मिले हम लोग उसे मार डाले हम उसका शरीर सूखे कुओं में से किसी एक में फेंक सकते हैं। हम अपने पिता से कह सकते हैं कि एक जंगली जानवर ने उसे मार डाला। तब हम लोग उसे दिखाएँगे कि उसके सपने व्यर्थ हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","किन्तु रूबेन यूसुफ को बचाना चाहता था। रूबेन ने कहा, “हम लोग उसे मारे नहीं। ");
INSERT INTO hin2010_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","हम लोग उसे चोट पहुँचाए बिना एक कुएँ में डाल सकते हैं।” रूबेन ने यूसुफ को बचाने और उसके पिता के साथ भेजने की योजना बनाई। ");
INSERT INTO hin2010_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","यूसुफ अपने भाईयों के पास आया। उन्होंने उस पर आक्रमण किया और उसके लम्बे सुन्दर अंगरखा को फाड़ डाला। ");
INSERT INTO hin2010_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","तब उन्होंने उसे खाली सूखे कुएँ में फेंक दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","यूसुफ कुएँ में था, उसके भाई भोजन करने बैठे। तब उन्होंने नज़र उठाई और व्यापारियों का एक दल को देखा जो गिलाद से मिस्र की यात्रा पर थे। उनके ऊँट कई प्रकार के मसाले और धन ले जा रहे थे। ");
INSERT INTO hin2010_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","इसलिए यहूदा ने अपने भाईयों से कहा, अगर हम लोग अपने भाई को मार देंगे और उसकी मृत्यु को छिपाएँगे तो उससे हमें क्या लाभ होगा? ");
INSERT INTO hin2010_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","हम लोगों को अधिक लाभ तब होगा जब हम उसे इन व्यापारियों के हाथ बेच देंगे। अन्य भाई मान गए। ");
INSERT INTO hin2010_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","जब मिद्यानी व्यापारी पास आए, भाईयों ने यूसुफ को कुएँ से बाहर निकाला। उन्होंने बीस चाँदी के टुकड़ों में उसे व्यापारियों को बेच दिया। व्यापारी उसे मिस्र ले गए। ");
INSERT INTO hin2010_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","इस पूरे समय रूबेन भाईयों के साथ वहाँ नहीं था। वह नहीं जानता था कि उन्होंने यूसुफ को बेच दिया था। जब रूबेन कुएँ पर लौटकर आया तो उसने देखा कि यूसुफ वहाँ नहीं है। रूबेन बहुत अधिक दुःखी हुआ। उसने अपने कपड़ों को फाड़ा। ");
INSERT INTO hin2010_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","रूबेन भाईयों के पास गया और उसने उनसे कहा, “लड़का कुएँ पर नहीं है। मैं क्या करूँ?” ");
INSERT INTO hin2010_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","भाईयों ने एक बकरी को मारा और उसके खून को यूसुफ के सुन्दर अंगरखे पर डाला। ");
INSERT INTO hin2010_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","तब भाईयों ने उस अंगरखे को अपने पिता को दिखाया और भाईयों ने कहा, “हमे यह अंगरखा मिला है, क्या यह यूसुफ का अंगरखा है?” ");
INSERT INTO hin2010_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","पिता ने अंगरखे को देखा और पहचाना कि यह यूसुफ का है। पिता ने कहा, “हाँ, यह उसी का है। संभव है उसे किसी जंगली जानवर ने मार डाला हो। मेरे पुत्र यूसुफ को कोई जंगली जानवर खा गया।” ");
INSERT INTO hin2010_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","याकूब अपने पुत्र के लिए इतना दुःखी हुआ कि उसने अपने कपड़े फाड़ डाले। तब याकूब ने विशेष वस्त्र पहने जो उसके शोक के प्रतीक थे। याकूब लम्बे समय तक अपने पुत्र के शोक में पड़ा रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","याकूब के सभी पुत्रों, पुत्रियों ने उसे धीरज बँधाने का प्रयत्न किया। किन्तु याकूब कभी धीरज न धर सका। याकूब ने कहा, “मैं मरने के दिन तक अपने पुत्र यूसुफ के शोक में डूबा रहूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","उन मिद्यानी व्यापारियों ने जिन्होंने यूसुफ को खरीदा था, बाद में उसे मिस्र में बेच दिया। उन्होंने फिरौन के अंगरक्षकों के सेनापति पोतीपर के हाथ उसे बेचा। ");
INSERT INTO hin2010_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","उन्हीं दिनों यहूदा ने अपने भाईयों को छोड़ दिया और हीरा नामक व्यक्ति के साथ रहने चला गया। हीरा अदुल्लाम नगर का था। ");
INSERT INTO hin2010_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","यहूदा एक कनानी स्त्री से वहाँ मिला और उसने उससे विवाह कर लिया। स्त्री के पिता का नाम शूआ था। ");
INSERT INTO hin2010_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","कनानी स्त्री ने एक पुत्र को जन्म दिया। उन्होंने उसका नाम एर रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","बाद में उसने दूसरे पुत्र को जन्म दिया। उन्होंने लड़के का नाम ओनान रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","बाद में उसे अन्य पुत्र शेला नाम का हुआ। यहूदा तीसरे बच्चे के जन्म के समय कजीब में रहता था। ");
INSERT INTO hin2010_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","यहूदा ने अपने पुत्र एर के लिए पत्नी के रूप में एक स्त्री को चुना। स्त्री का नाम तामार था। ");
INSERT INTO hin2010_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","किन्तु एर ने बहुत सी बुरी बातें की। यहोवा उससे प्रसन्न नहीं था। इसलिए यहोवा ने उसे मार डाला। ");
INSERT INTO hin2010_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","तब यहूद ने एर के भाई ओनान से कहा, “जाओ और मृत भाई की पत्नी के साथ सोओ तुम उसके पति के समान बनो। अगर बच्चे होंगे तो वे तुम्हारे भाई एर के होंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ओनान जानता था कि इस जोड़े से पैदा बच्चे उसके नहीं होंगे। ओनान ने तामार के साथ शारीरिक सम्बन्ध किया। किन्तु उसने उसे अपना गर्भधारण करने नहीं दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","इससे यहोवा क्रुद्ध हुआ। इसलिए यहोवा ने ओनान को भी मार डाला। ");
INSERT INTO hin2010_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","तब यहूदा ने अपनी पुत्रबधू तामार से कहा, “अपने पिता के घर लौट जाओ। वहीं रहो और तब तक विवाह न करो जब तक मेरा छोटा पुत्र शेला बड़ा न हो जाए।” यहूदा को डर था कि शेला भी अपने भाईयों की तरह मार डाला जाएगा। तामार अपने पिता के घर लौट गई। ");
INSERT INTO hin2010_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","बाद में शुआ की पुत्री यहूदा की पत्नी मर गई। यहूदा अपने शोक के समय के बाद अदुल्लाम के अपने मित्र हीरा के साथ तिम्नाथ गया। यहूदा अपनी भेड़ों का ऊन काटने तिम्नाथ गया। ");
INSERT INTO hin2010_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","तामार को यह मालुम हुआ कि उसके ससुर यहूदा अपनी भेड़ों का ऊन काटने तिम्नाथ जा रहा है। ");
INSERT INTO hin2010_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","तामार सदा ऐसे वस्त्र पहनती थी जिससे मालूम हो कि वह विधवा है। इसलिए उसने कुछ अन्य वस्त्र पहने और मुँह को पर्दे में ढक लिया। तब वह तिम्नाथ नगर के पास एनैम को जाने वाली सड़क के किनारे बैठ गई। तामार जानती थी कि यहूदा का छोटा पुत्र शेला अब बड़ा हो गया है। लेकिन यहूदा उससे उसके विवाह की कोई योजना नहीं बना रहा था। ");
INSERT INTO hin2010_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","यहूदा ने उसी सड़क से यात्रा की। उसने उसे देखा, किन्तु सोचा कि वह वेश्या है। (उसका मुख वेश्या की तरह ढका हुआ था।) ");
INSERT INTO hin2010_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","इसलिए यहूदा उसके पास गया और बोला, “मुझे अपने साथ शारीरिक सम्बन्ध करने दो।” (यहूदा नहीं जानता था कि वह उसकी पुत्र वधू तामार है।) तामार बोली, “तुम मुझे कितना दोगे?” ");
INSERT INTO hin2010_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","यहूदा ने उत्तर दिया, “मैं अपनी रेवड़ से तुम्हें एक नयी बकरी भेजूँगा।” उसने उत्तर दिया, “मैं इसे स्वीकार करती हूँ किन्तु पहले तुम मुझे कुछ रखने को दो जब तक तुम बकरी नहीं भेजते।” ");
INSERT INTO hin2010_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","यहूदा ने पूछा, “मैं बकरी भेजूँगा इसके प्रमाण के लिए तुम मुझ से क्या लेना चाहोगी?” तामार ने उत्तर दिया, “मुझे विशेष मुहर और इसकी रस्सी, जो तुम अपने पत्रों के लिए प्रयोग करते हो, दो और मुझे अपने टहलने की छड़ी दो।” यहूदा ने ये चीजें उसे दे दी। तब यहूदा और तामार ने शारीरिक सम्बन्ध किया और तामार गर्भवती हो गई। ");
INSERT INTO hin2010_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","तामार घर गई और मुख को ढकने वाले पर्दे को हटा दिया। तब उसने फिर अपने को विधवा बताने वाले विशेष वस्त्र पहन लिए। ");
INSERT INTO hin2010_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","यहूदा ने अपने मित्र हीरा को तामार के घर उसको वचन दी हुई बकरी देने के लिए भेजा। यहूदा ने हीरा से विशेष मुहर तथा टहलने की छड़ी भी उससे लेने के लिए कहा। किन्तु हीरा उसका पता न लगा सका। ");
INSERT INTO hin2010_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","हीरा ने एनैम नगर के कुछ लोगों से पूछा, “सड़क के किनारे जो वेश्या थी वह कहाँ है?” लोगों ने कहा, “यहाँ कभी कोई वेश्या नहीं थी।” ");
INSERT INTO hin2010_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","इसलिए यहूदा का मित्र यहूदा के पास लौट गया और उससे कहा, “मैं उस स्त्री का पता नहीं लगा सका। जो लोग उस स्थान पर रहते हैं उन्होंने बताया कि वहाँ कभी कोई वेश्या नहीं थी।” ");
INSERT INTO hin2010_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","इसलिए यहूदा ने कहा, “उसे वे चीजें रखने दो। मैं नहीं चाहता कि लोग हम पर हँसे। मैंने उसे बकरी देनी चाही, किन्तु हम उसका पता नहीं लगा सके वही पर्याप्त है।” ");
INSERT INTO hin2010_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","लगभग तीन महीने बाद किसी ने यहूदा से कहा, “तुम्हारी पुत्रवधु तामार ने वेश्या की तरह पाप किया है और अब वह गर्भवती है।” तब यहूदा ने कहा, “उसे बाहर निकालो और मार डालो। उसके शरीर को जला दो।” ");
INSERT INTO hin2010_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","उसके आदमी तामार को मारने गए। किन्तु तामार ने अपने ससुर के पास सन्देश भेजा। तामार ने कहा, “जिस पुरुष ने मुझे गर्भवती किया है उसी की ये चीजें हैं। तब उसने उसे विशेष मुहर बाजूबन्द और टहलने की छड़ी दिखाई। इन चीजों को देखो। ये किसकी है? यह किस की विशेष मुहर, बाजूबन्द और रस्सी है? किसकी यह टहलने की छड़ी है?” ");
INSERT INTO hin2010_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदा ने उन चीजों को पहचाना और कहा, “यह ठीक कहती है। मैं गलती पर था। मैंने अपने वचन के अनुसार अपने पुत्र शेला को इसे नहीं दिया।” और यहूदा उसके साथ फिर नहीं सोया। ");
INSERT INTO hin2010_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","तामार के बच्चा देने का समय आया और उन्होंने देखा कि वह जुड़वे बच्चों को जन्म देगी। ");
INSERT INTO hin2010_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","जिस समय वह जन्म दे रही थी एक बच्चे ने बाहर हाथ निकाला। धाय ने हाथ पर लाल धागा बाँधा और कहा, “यह बच्चा पहले पैदा हुआ।” ");
INSERT INTO hin2010_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","लेकिन उस बच्चे ने अपना हाथ वापस भीतर खींच लिया। तब दूसरा बच्चा पहले पैदा हुआ। तब धाय ने कहा, “तुम ही पहले बाहर निकलने में समर्थ हुए।” इसलिए उन्होंने उसका नाम पेरेस रखा। (इस नाम का अर्थ “खुव पड़ना” या “फट पड़ना” है।) ");
INSERT INTO hin2010_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","इसके बाद दूसरा बच्चा उत्पन्न हुआ। यह बच्चा हाथ पर लाल धागा था। उन्होंने उसका नाम जेरह रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","व्यापारी जिसने यूसुफ को खरीदा वह उसे मिस्र ले गए। उन्होंने फ़िरौन के अंगरक्षक के नायक के हाथ उसे बेचा। ");
INSERT INTO hin2010_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","किन्तु यहोवा ने यूसुफ को सहायता की। यूसुफ एक सफल व्यक्ति बन गया। यूसुफ अपने मिस्री स्वामी पोतीपर के घर में रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","पोतीपर ने देखा कि यहोवा यूसुफ के साथ है। पोतीपर ने यह भी देखा कि यहोवा जो कुछ यूसुफ करता है, उसमें उसे सफल बनाने में सहायक है। ");
INSERT INTO hin2010_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","इसलिए पोतीपर यूसुफ को पाकर बहुत प्रसन्न था। पोतीपर ने उसे अपने लिए काम करने तथा घर के प्रबन्ध में सहायता करने में लगाया। पोतीपर की अपनी हर एक चीज़ का यूसुफ अधिकारी था। ");
INSERT INTO hin2010_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","तब यूसुफ घर का अधिकारी बना दिया गया तब यहोवा ने उस घर और पोतीपर की हर एक चीज़ को आशीर्वाद दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","यहोवा ने यह यूसुफ के कारण किया और यहोवा ने पोतीपर के खेतों में उगने वाली हर चीज़ की ज़िम्मेदारी यूसुफ को दी। पोतीपर किसी चीज़ की चिन्ता नहीं करता था वह जो भोजन करता था एक मात्र उसकी उसे चिन्ता थी। यूसुफ बहुत सुन्दर और सुरूप था। ");
INSERT INTO hin2010_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","कुछ समय बाद यूसुफ के मालिक की पत्नी यूसुफ से प्रेम करने लगी। एक दिन उसने कहा, “मेरे साथ सोओ।” ");
INSERT INTO hin2010_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","किन्तु यूसुफ ने मना कर दिया। उसने कहा, “मेरा मालिक घर की अपनी हर चीज़ के लिए मुझ पर विश्वास करता है। उसने यहाँ की हर एक चीज़ की ज़िम्मेदारी मुझे दी है। ");
INSERT INTO hin2010_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","मेरे मालिक ने अपने घर में मुझे लगभग अपने बराबर मान दिया है। किन्तु मुझे उसकी पत्नी के साथ नहीं सोना चाहिए। यह अनुचित है। यह परमेश्वर के विरुद्ध पाप है।” ");
INSERT INTO hin2010_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","वह स्त्री हर दिन यूसुफ से बात करती थी किन्तु यूसुफ ने उसके साथ सोने से मना कर दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","एक दिन यूसुफ अपना काम करने घर में गया। उस समय वह घर में अकेला व्यक्ति था। ");
INSERT INTO hin2010_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","उसके मालिक की पत्नी ने उसका अंगरखा पकड़ा लिया और उससे कहा, “आओ और मेरे साथ सोओ।” किन्तु यूसुफ घर से बाहर भाग गया और उसने अपना अंगरखा उसके हाथ में छोड़ दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","स्त्री ने देखा कि यूसुफ ने अपना अंगरखा उसके हाथों में छोड़ दिया है और उसने जो कुछ हुआ उसके बारे में झूठ बोलने में निश्चय किया। वह बाहर दौड़ी। ");
INSERT INTO hin2010_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","और उसने बाहर के लोगों को पुकारा। उसने कहा, “देखो, यह हिब्रू दास हम लोगों का उपहास करने यहाँ आया था। वह अन्दर आया और मेरे साथ सोने की कोशिश की। किन्तु मैं ज़ोर से चिल्ला पड़ी। ");
INSERT INTO hin2010_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","मेरी चिल्लाहट ने उसे डरा दिया और वह भाग गया। किन्तु वह अपना अंगरखा मेरे पास छोड़ गया।” ");
INSERT INTO hin2010_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","इसलिए उसने यूसफ के मालिक अपने पति के घर लौटने के समय तक उसके अंगरखे को अपने पास रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","और उसने अपने पति को वही कहानी सुनाई। उसने कहा, “जिस हिब्रू दास को तुम यहाँ लाए उसने मुझ पर हमला करने का प्रयास किया। ");
INSERT INTO hin2010_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","किन्तु जब वह मेरे पास आया तो मैं चिल्लाई। वह भाग गया, किन्तु अपना अंगरखा छोड़ गया।” ");
INSERT INTO hin2010_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","यूसुफ के मालिक ने जो उसकी पत्नी ने कहा, उसे सुना और वह बहुत क्रुद्ध हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","वहाँ एक कारागार था जिसमें राजा के शत्रु रखे जाते थे। इसलिए पोतीपर ने यूसुफ को उसी बंदी खाने में डाल दिया और यूसुफ वहाँ पड़ा रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","किन्तु यहोवा यूसुफ के साथ था। यहोवा उस पर कृपा करता रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","कुछ समय बाद कारागार के रक्षकों का मुखिया यूसुफ से स्नेह करने लगा। रक्षकों के मुखिया ने सभी कैदियों का अधिकारी यूसुफ को बनाया। यूसुफ उनका मुखिया था, किन्तु काम वही करता था जो वे करते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","रक्षकों का अधिकारी कारागार को सभी चीजों के लिए यूसुफ पर विश्वास करता था। यह इसलिए हुआ कि यहोवा यूसुफ के साथ था। यहोवा यूसुफ को, वह जो कुछ करता था, सफल करने में सहायता करता था। ");
INSERT INTO hin2010_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","बाद में फ़िरौन के दो नौकरों ने फ़िरौन का कुछ नुकसान किया। इन नौकरों में से एक रोटी पकाने वाला तथा दूसरा फिरौन को दाखमधु देने वाले नौकर पर क्रुद्ध हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","3","इसलिए फ़िरौन ने उसी कारागार में उन्हें भेजा जिसमें यूसुफ था। फ़िरौन के अंगरक्षकों का नायक पोतीपर उस कारागार का अधिकारी था। ");
INSERT INTO hin2010_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","नायक ने दोनों कैदियों को यूसुफ की देखरेख में रखा। दोनों कुछ समय तक कारागार में रहे। ");
INSERT INTO hin2010_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","एक रात दोनों कैदियों ने एक सपना देखा। (दोनों कैदी मिस्र के राजा के राजा के रोटी पकानेवाले तथा दाखमधु देने वाले नौकर थे।) हर एक कैदी के अपने—अपने सपने थे और हर एक सपने का अपना अलग अलग अर्थ था। ");
INSERT INTO hin2010_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","यूसुफ अगली सुबह उनके पास गया। यूसुफ ने देखा कि दोनों व्यक्ति परेशान थे। ");
INSERT INTO hin2010_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","यूसुफ ने पूछा, “आज तुम लोग इतने परेशान क्यों दिखाई पड़ते हो?” ");
INSERT INTO hin2010_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","दोनों व्यक्तियों ने उत्तर दिया, “पिछली रात हम लोगों ने सपना देखा, किन्तु हम लोग नहीं समझते कि सपने का क्या अर्थ है? कोई व्यक्ति ऐसा नहीं है जो सपनों की व्याख्या करे या हम लोगों को स्पष्ट बताए।” यूसुफ ने उनसे कहा, “केवल परमेश्वर ही ऐसा है जो सपने को समझता और उसकी व्याख्या करता है। इसलिए मैं निवेदन करता हूँ कि अपने सपने मुझे बताओ।” ");
INSERT INTO hin2010_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","इसलिए दाखमधु देने वाले नौकर ने यूसुफ को अपना सपना बताया। नौकर ने कहा, “मैंने सपने में अँगूर की बेल देखी। ");
INSERT INTO hin2010_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","उस अंगूर की बेल की तीन शाखाएँ थी। मैंने शाखाओं में फूल आते और उन्हें अँगूर बनते देखा। ");
INSERT INTO hin2010_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","मैं फ़िरौन का प्याला लिए था। इसलिए मैंने अंगूरों को लिया और प्याले में रस निचोड़ा। तब मैंने प्याला फ़िरौन को दिया।” ");
INSERT INTO hin2010_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","तब यूसुफ ने कहा, “मैं तुमको सपने की व्याख्या समझाऊँगा। तीन शाखाओं का अर्थ तीन दिन है। ");
INSERT INTO hin2010_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","तीन दिन बीतने के पहले फ़िरौन तुमको क्षमा करेगा और तुम्हें तुम्हारे काम पर लौटने देगा। तुम फ़िरौन के लिए वही काम करोगे जो पहले करते थे। ");
INSERT INTO hin2010_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","किन्तु जब तुम स्वतन्त्र हो जाओगे तो मुझे याद रखना। मेरी सहायता करना। फ़िरौन से मेरे बारे में कहना जिससे मैं इस कारागार से बाहर हो सकूँ। ");
INSERT INTO hin2010_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","मुझे अपने घर से लाया गया था जो मेरे अपने लोगों हिब्रूओं का देश है। मैंने कोई अपराध नहीं किया है। इसलिए मुझे कारागार में नहीं होना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","रोटी बनाने वाले ने देखा कि दूसरे नौकर का सपना अच्छा था। इसलिए रोटी बनाने वाले ने यूसुफ से कहा, “मैंने भी सपना देखा। मैंने देखा कि मेरे सिर पर तीन रोटियों की टोकरियाँ है। ");
INSERT INTO hin2010_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","सबसे ऊपर की टोकरी में हर प्रकार के पके भोजन थे। यह भोजन राजा के लिए था। किन्तु इस भोजन को चिड़ियाँ खा रही थीं।” ");
INSERT INTO hin2010_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","यूसुफ ने उत्त्तर दिया, “मैं तुम्हें बताऊँगा कि सपने का क्या अर्थ है? तीन टोकरियों का अर्थ तीन दिन है। ");
INSERT INTO hin2010_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","तीन दिन बीतने के पहले राजा तुमको इस जेल से बाहर निकालेगा। तब राजा तुम्हारा सिर काट डालेगा। वह तुम्हारे शरीर को एक खम्भे पर लटकाएगा और चिड़ियाँ तुम्हारे शरीर को खाएँगी।” ");
INSERT INTO hin2010_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","तीन दिन बाद फ़िरौन का जन्म दिन था। फ़िरौन ने अपने सभी नौकरों को दावत दी। दावत के समय फ़िरौन ने दाखमधु देने वाले तथा रोटी पकाने वाले नौकरों को कारागार से बाहर आने दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","फ़िरौन ने दाखमधु देने वाले नौकर को स्वतन्त्र कर दिया। फ़िरौन ने उसे नौकरी पर लौटा लिया और दाखमधु देने वाले नौकर ने फ़िरौन के हाथ में एक दाखमधु का प्याला दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","लेकिन फ़िरौन ने रोटी बनाने वाले को मार डाला। सभी बातें जैसे यूसुफ ने होनी बताई थी वैसे ही हुई। ");
INSERT INTO hin2010_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","किन्तु दाखमधु देने वाले नौकर को यूसुफ की सहायता करना याद नहीं रहा। उसने यूसुफ के बारे में फ़िरौन से कुछ नहीं कहा। दाखमधु देने वाला नौकर यूसुफ के बारे में भूल गया। ");
INSERT INTO hin2010_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","दो वर्ष बाद फ़िरौन ने सपना देखा। फिरौन ने सपने में देखा कि वह नील नदी के किनारे खड़ा है। ");
INSERT INTO hin2010_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","तब फ़िरौन ने सपने में नदी से सात गायों को बाहर आते देखा। गायें मोटी और सुन्दर थीं। गायें वहाँ खड़ी थी और घास चर रही थीं। ");
INSERT INTO hin2010_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","तब सात अन्य गायें नदी से बाहर आईं, और नदी के किनारे मोटी गायों के पास खड़ी हो गई। किन्तु ये गायें दुबली और भद्दी थी। ");
INSERT INTO hin2010_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ये सातों दुबली गायें, सुन्दर मोटी सात गायों को खा गईं। तब फ़िरौन जाग उठा। ");
INSERT INTO hin2010_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","फ़िरौन फिर सोया और दूसरी बार सपना देखा। उसने सपने में अनाज की सात बालें एक अनाज के पीछे उगी हुई देखी। अनाज की बालें मोटी और अच्छी थीं। ");
INSERT INTO hin2010_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","तब उसने उसी अनाज के पीछे सात अन्न बालें उगी देखीं। अनाज की ये बालें पतली और गर्म हवा से नष्ट हो गई थीं। ");
INSERT INTO hin2010_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","तब सात पतली बालों ने सात मोटी ओर अच्छी वालों ने सात मोटी और अच्छी वालों को खा लिया। फ़िरौन फिर जाग उठा और उसने समझा कि यह केवल सपना ही है। ");
INSERT INTO hin2010_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","अगली सुबह फ़िरौन इन सपनों के बारे में परेशान था। इसलिए उसने मिस्र के सभी जादूगरों को और सभी गुणी लोगों को बुलाया। फ़िरौन ने उनको सपना बताया। किन्तु उन लोगों में से कोई भी सपने को स्पष्ट या उसकी व्याख्या न कर सका। ");
INSERT INTO hin2010_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","तब दाखमधु देने वाले नौकर को यूसुफ याद आ गया। नौकर ने फ़िरौन से कहा, “मेरे साथ जो कुछ घटा वह मुझे याद आ रहा है। ");
INSERT INTO hin2010_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","आप मुझ पर और एक दूसरे नौकर पर क्रुद्ध थे और आपने हम दोनों को कारागार में डाल दिया था। ");
INSERT INTO hin2010_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","कारागार में एक ही रात हम दोनों ने सपने देखे। हर सपना अलग अर्थ रखता था। ");
INSERT INTO hin2010_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","एक हिब्रू युवक हम लोगों के साथ कारागार में था। वह अंगरक्षको के नायक का नौकर था। हम लोगों ने अपने सपने उसको बताए और उसने सपने को व्याख्या हम लोगों को समझाई। उसने हर सपने का अर्थ हम लोगों को बताया। ");
INSERT INTO hin2010_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","जो अर्थ उसने बताए वे ठीक निकले। उसने बताया कि मैं स्वतन्त्र होऊँगा और अपनी पुरानी नौकरी फिर पाऊँगा और यही हुआ। उसने कहा कि रोटी पकाने वाला मरेगा और वही हुआ।” ");
INSERT INTO hin2010_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","इसलिए फ़िरौन ने यूसुफ को कारागार से बुलाया। रक्षक जल्दी से यूसुफ को कारागार से बाहर लाए। यूसुफ ने बाल कटाए और साफ कपड़े पहने। तब वह गया और फ़िरौन के सामने खड़ा हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","तब फ़िरौन ने यूसुफ से कहा, “मैंने एक सपना देखा है। किन्तु कोई ऐसा नहीं है जो सपने की व्याख्या मुझको समझा सके। मैंने सुना है कि जब कोई सपने के बारे में तुमसे कहता है तब तुम सपनों की व्याख्या और उन्हें स्पष्ट कर सकते हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","यूसुफ ने उत्तर दिया, “मेरी अपनी बुद्धि नहीं है कि मैं सपनों को समझ सकूँ केवल परमेश्वर ही है जो ऐसी शक्ति रखता है और फ़िरौन के लिए परमेश्वर ही यह करेगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","तब फ़िरौन ने कहा, “अपने सपने में, मैं नील नदी के किनारे खड़ा था। ");
INSERT INTO hin2010_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","मैंने सात गायों को नदी से बाहर आते देखा और घास चरते देखा। ये गायें मोटी और सुन्दर थीं। ");
INSERT INTO hin2010_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","तब मैंने अन्य सात गायों को नदी से बाहर आते देखा। वे गायें पतली और भद्दी थीं। मैंने मिस्र देश में जितनी गायें देखी हैं उनमें वे सब से अधिक बुरी थीं। ");
INSERT INTO hin2010_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","और इन भद्दी और पतली गायों ने पहली सुन्दर सात गायों को खा डाला। ");
INSERT INTO hin2010_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","लेकिन सात गायों को खाने के बाद तक भी वे पतली और भद्दी ही रहीं। तुम उनको देखो तो नहीं जान सकते कि उन्होंने अन्य सात गायों को खाया है। वे उतनी ही भद्दी और पतली दिखाई पड़ती थीं जितनी आरम्भ में थीं। तब मैं जाग गया। ");
INSERT INTO hin2010_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“तब मैंने अपने दूसरे सपने में अनाज को सात बालें एक ही अनाज के पीछे उगी देखीं। वे अनाज की बालें भरी हुई, अच्छी और सुन्दर थीं। ");
INSERT INTO hin2010_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","तब उनके बाद सात अन्य बालें उगीं। किन्तु ये बालें पतली, भद्दी और गर्म हवा से नष्ट थीं। ");
INSERT INTO hin2010_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","तब पतली बालों ने सात अच्छी बालों को खा डाला। “मैंने इस सपने को अपने लोगों को बताया जो जादूगर और गुणी हैं। किन्तु किसी ने सपने की व्याख्या मुझको नहीं समझाई। इसका अर्थ क्या है?” ");
INSERT INTO hin2010_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","तब यूसुफ ने फ़िरौन से कहा, “ये दोनों सपने एक ही अर्थ रखते हैं। परमेश्वर तुम्हें बता रहा है जो जल्दी ही होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","सात अच्छी गायें और सात अच्छी अनाज की बालें सात वर्ष हैं, दोनों सपने एक ही है। ");
INSERT INTO hin2010_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","सात दुबली और भद्दी गायें तथा सात बुरी अनाज की बालें देश में भूखमरी के सात वर्ष हैं। ये सात वर्ष, अच्छे सात वर्षो के बाद आयेंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","परमेश्वर ने आपको यह दिखा दिया है कि जल्दी ही क्या होने वाला है। यह वैसा ही होगा जैसा मैंने कहा है। ");
INSERT INTO hin2010_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","आपके सात वर्ष पूरे मिस्र में अच्छी पैदावार और भोजन बहुतायत के होंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","लेकिन इन सात वर्षों के बाद पूरे देश में भूखमरी के सात वर्ष आएँगे। यह अकाल देश को नष्ट कर देगा। ");
INSERT INTO hin2010_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","भरपूर भोजनस्मरण रखना लोग भूल जाएँगें कि क्या होता है? ");
INSERT INTO hin2010_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","“हे फ़िरौन, आपने एक ही बात के बारे में दो सपने देखे थे। यह इस बात को दिखाने के लिए हुआ कि परमेश्वर निश्चय ही ऐसा होने देगा और यह बताया है कि परमेश्वर इसे जल्दी ही होने देगा। ");
INSERT INTO hin2010_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","इसलिए हे फ़िरौन आप एक ऐसा व्यक्ति चुनें जो बहुत और बुद्धिमान हो। आप उसे मिस्र देश का प्रशासक बनाएँ। ");
INSERT INTO hin2010_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","तब आप दूसरे व्यक्तियों को जनता से भोजन इकट्ठा करने के लिए चुने। हर व्यक्ति सात अच्छे वर्षों में जितना भोजन उत्पन्न करे, उसका पाँचवाँ हिस्सा दे। ");
INSERT INTO hin2010_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","इन लोगों को आदेश दें कि जो अच्छे वर्ष आ रहे हैं उनमें सारा भोजन इकट्ठा करें। व्यक्तियों से कह दें कि उन्हें नगरों में भोजन जमा करने का अधिकार है। तब वे भोजन की रक्षा उस समय तक करेंगे जब उनकी आवश्यकता होगी। ");
INSERT INTO hin2010_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","वह भोजन मिस्र देश में आने वाले भूखमरी के सात वर्षों में सहायता करेगा। तब मिस्र में सात वर्षों में लोग भोजन के अभाव में मरेंगे नहीं।” ");
INSERT INTO hin2010_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","फ़िरौन को यह अच्छा विचार मालूम हुआ। इससे सभी अधिकारी सहमत थे। ");
INSERT INTO hin2010_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","फ़िरौन ने अपने अधिकारियों से पूछा, “क्या तुम लोगों में से कोई इस काम को करने के लिए यूसुफ से अच्छा व्यक्ति ढूँढ सकता है? परमेश्वर की आत्मा ने इस व्यक्ति को सचमुच बुद्धिमान बना दिया है।” ");
INSERT INTO hin2010_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","फ़िरौन ने यूसुफ से कहा, “परमेश्वर ने ये सभी चीज़ें तुम को दिखाई हैं। इसलिए तुम ही सर्वाधिक बुद्धिमान हो। ");
INSERT INTO hin2010_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","इसलिए मैं तुमको देश का प्रशासक बनाऊँगा। जनता तुम्हारे आदेशों का पालन करेगी। मैं अकेला इस देश में तुम से बड़ा प्रशासक रहूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","एक विशेष समारोह और प्रदर्शन था जिसमें फ़िरौन ने यूसुफ को प्रशासक बनाया तब फ़िरौन ने यूसुफ से कहा, “मैं अब तुम्हें मिस्र के पूरे देश का प्रशासक बनाता हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","तब फिरौन ने अपनी राजकीय मुहर वाल अगूँठी यूसुफ को दी और यूसुफ को एक सुन्दर रेशमी वस्त्र पहनने को दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","फ़िरौन ने दूसरे श्रेणी के राजकीय रथ पर यूसुफ को सवार होने को कहा। उसके रथ के आगे विशेष रक्षक चलते थे। वे लोगों से कहते थे, “हे लोगों, यूसुफ को झुककर प्रणाम करो। इस तरह यूसुफ पूरे मिस्र का प्रशासक बना।” ");
INSERT INTO hin2010_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","फ़िरौन ने उससे कहा, “मैं सम्राट फ़िरौन हूँ। इसलिए मैं जो करना चाहूँगा, करूँगा। किन्तु मिस्र में कोई अन्य व्यक्ति हाथ पैर नहीं हिला सकता है जब तक तुम उसे न कहो।” ");
INSERT INTO hin2010_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","फ़िरौन ने उसे दूसरा नाम सापन तपानेह दिया। फ़िरौन ने आसनत नाम की एक स्त्री, जो ओन के याजक पोतीपेरा की पुत्री थी, यूसुफ को पत्नी के रूप में दी। इस प्रकार यूसुफ पूरे मिस्र देश का प्रशासक हो गया। ");
INSERT INTO hin2010_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","यूसुफ उस समय तीन वर्ष का था जब वह मिस्र के सम्राट की सेवा करने लगा। यूसुफ ने पूरे मिस्र देश में यात्राएँ की। ");
INSERT INTO hin2010_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","अच्छे सात वर्षों में देश में पैदावार बहुत अच्छी हुई ");
INSERT INTO hin2010_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","और यूसुफ ने मिस्र में सात वर्ष खाने की चीजें बचायीं। यूसुफ ने भोजन नगरों में जमा किया। यूसुफ ने नगर के चारों ओर के खेतों के उपजे अन्न को हर नगर में जमा किया। ");
INSERT INTO hin2010_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","यूसुफ ने बहुत अन्न इकट्ठा किया। यह समुद्र के बालू के सदृश था। उसने इतना अन्न इकट्ठा किया कि उसके वजन को भी न आँका जा सके। ");
INSERT INTO hin2010_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","यूसुफ की पत्नी आसनत ओन के याजक पोतीपरा कि पुत्री थी। भूखमरी के पहले वर्ष के आने के पूर्व यूसुफ और आसनेत के दो पुत्र हुए। ");
INSERT INTO hin2010_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","पहले पुत्र का नाम मनश्शे रखा गया। यूसुफ ने उसका यह नाम रखा क्योंकि उसने बताया, “मुझे जितने सारे कष्ट हुए तथा घर की हर बात परमेश्वर ने मुझसे भुला दी।” ");
INSERT INTO hin2010_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","यूसुफ ने दूसरे पुत्र का नाम एप्रैम रखा। यूसुफ ने उसका नाम यह रका क्योंकि उसने बताया, “मुझे बहुत दुःख मिला, लेकिन परमेश्वर ने मुझे फुलाया—फलाया।” ");
INSERT INTO hin2010_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","सात वर्ष तक लोगों के पास खाने के लिए यह सब भोजन था जिसकी उन्हें आवश्यकता थी और जो चीजें उन्हें आवश्यक थीं वे सभी उगती थीं। ");
INSERT INTO hin2010_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","किन्तु सात वर्ष वाद भूखमरी के दिन शुरु हुए। यह ठीक वैसा ही हुआ जैसा यूसुफ ने कहा था। सारी भूमि में चारों ओर अन्न पैदा न हुआ। लोगों के पास खाने को कुछ न था। किन्तु मिस्र में लोगों के खाने के लिए काफी था, क्योंकि यूसुफ ने अन्न जमा कर रखा था। ");
INSERT INTO hin2010_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","भूखमरी का समय शुरु हुआ और लोग भोजन के लिए फ़िरौन के सामने रोने लगे। फ़िरौन ने मिस्री लोगों से कहा, “यूसुफ से पूछो। वही करो जो वह करने को कहता है।” ");
INSERT INTO hin2010_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","इसलिए जब देश में सर्वत्र भूखमरी थी, यूसुफ ने अनाज के गोदामों से लोगों को अन्न दिया। यूसुफ ने जमा अन्न को मिस्र के लोगों को बेचा। मिस्र में बहुत भयंकर अकाल था। ");
INSERT INTO hin2010_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","मिस्र के चारों ओर के देशों के लोग अनाज खरीदने मिस्र आए। वे यूसुफ के पास आए क्योंकि वहाँ संसार के उस भाग में सर्वत्र भूखमरी थी। ");
INSERT INTO hin2010_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","इस समय याकूब के प्रदेश में भूखमरी थी। किन्तु याकूब को यह पता लगा कि मिस्र में अन्न है। इसलिए याकूब ने अपने पुत्रों से कहा, “हम लोग यहाँ हाथ पर हाथ धरे क्यों बैठे है? ");
INSERT INTO hin2010_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","मैंने सुना है कि मिस्र में खरीदने के लिए अन्न है। इसलिए हम लोग वहाँ चलें और वहाँ से अपने खाने के लिए अन्न खरीदें, तब हम लोग जीवित रहेंगे, मरेंगे नहीं।” ");
INSERT INTO hin2010_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","इसलिए यूसुफ के भाईयों में से दस अन्य खरीदने मिस्र गए। ");
INSERT INTO hin2010_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","याकूब ने बिन्यामीन को नहीं भेजा। (बिन्यामीन यूसुफ का एकमात्र सगा भाई था) ");
INSERT INTO hin2010_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","कनान में भूखमरी का समय बहुत भयंकर था। इसलिए कनान के बहुत से लोग अन्न खरीदने मिस्र गए। उन्हीं लोगों में इस्राएल के पुत्र भी थे। ");
INSERT INTO hin2010_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","इस समय यूसुफ मिस्र का प्रशासक था। केवल यूसुफ ही था जो मिस्र आने वाले लोगों को अन्न बेचने का आदेश देता था। यूसुफ के भाई उसके पास आए और उन्होंने उसे झुककर प्रणाम किया। ");
INSERT INTO hin2010_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","यूसुफ ने अपने भाईयों को देखा और उसने उन्हें पहचान लिया कि वे कौन है। किन्तु यूसुफ उनसे इस तरह बात करता रहा जैसे वह उन्हें पहचानता ही नहीं। उसने उनके साथ क्रूरता से बात की। उसने कहा, “तुम लोग कहाँ से आए हो?” भाईयों ने उत्तर दिया, “हम कनान देश से आए हैं। हम लोग अन्न खरीदने आए हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","यूसुफ जानता था कि वे लोग उसके भाई हैं। किन्तु वे नहीं जानते थे कि वह कौन हैं? ");
INSERT INTO hin2010_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","यूसुफ ने उन सपनों को याद किया जिन्हें उसने अपने भाईयों के बारे में देखा था। यूसुफ ने अपने भाईयों से कहा, “तुम लोग अन्न खरीदने नहीं आए हो। तुम लोग जासूस हो। तुम लोग यह पता लगाने आए हो कि हम कहाँ कमजोर हैं?” ");
INSERT INTO hin2010_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","किन्तु भाईयों ने उससे कहा, “नहीं महोदया! हम तो आपके सेवक के रूप में आए हैं। हम लोग केवल अन्न खरीदने आए है। ");
INSERT INTO hin2010_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","हम सभी लोग भाई है, हम लोगों का एक ही पिता है। हम लोग ईमानदार हैं। हम लोग केवल अन्न खरीदने आए है।” ");
INSERT INTO hin2010_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","तब यूसुफ ने उनसे कहा, “नहीं, तुम लोग यह पता लगाने आए हो कि हम कहाँ कमजोर हैं?” ");
INSERT INTO hin2010_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","भाईयों ने कहा, “नहीं हम सभी भाई है। हमारे परिवार में बारह भाई है। हम सबका एक ही पिता है। हम लोगों का सबसे छोटा भाई अभी भी हमारे पिता के साथ गर पर है और दूसरा भाई बहुत समय पहले मर गया। हम लोग आपके सामने सेवक की तरह है। हम लोग कनान देश के हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","किन्तु यूसुफ ने कहा, “नहीं मुझे पता है कि मैं ठीक हूँ। तुम भेदिये हो। ");
INSERT INTO hin2010_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","किन्तु मैं तुम लोगों को यह प्रमाणित करने का अक्सर दूँगा कि तुम लोग सच कह रहे हो। तुम लोग यह जगह तब तक नहीं छोड़ सकते जब तक तुम लोगों का छोटा भाई यहाँ नहीं आता। ");
INSERT INTO hin2010_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","इसलिए तुम लोगों में से एक लौटे और अपने छोटे भाई को यहाँ लाए। उस समय तक अन्य यहाँ कारागार में रहेंगे। हम देखेंगे कि क्या तुम लोग सच बोल रहे हो। किन्तु मुझे विश्वास है कि तुम लोग जासूस हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","तब यूसुफ ने उन सभी को तीन दिन के लिए कारागार में डाल दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तीन दिन बाद यूसुफ ने उनसे कहा, “मैं परमेश्वर का भय मानता हूँ। इसलिए मैं तुम लोगों को यह प्रमाणित करने का एक अवसर दूँगा कि तुम लोग सच बोल रहे हो। तुम लोग यह काम करो और मैं तुम लोगों को जीवित रहने दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","अगर तुम लोग ईमानदार व्यक्ति हो तो अपने भाईयों में से एक को कारागार में रहने दो। अन्य जा सकते हैं और अपने लोगों के लिए अन्न ले जा सकते हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","तब अपने सबसे छोटे भाई को लेकर यहाँ मेरे पास आओ। इस प्रकार में विश्वास करूँगा कि तुम लोग सच बोल रहे हो।” भाईयों ने इस बात को मान लिया। ");
INSERT INTO hin2010_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","उन्होंने आपस में बात की, “हम लोग दण्डित किए गए हैं। क्योंकि हम लोगों ने अपने छोटे भाई के साथ बुरा किया है। हम लोगों ने उसके कष्टों को देखा जिसमें वह था। उसने अपनी रक्षा के लिए हम लोगों से प्रार्थना की। किन्तु हम लोगों ने उसकी एक न सुनी। इसलिए हम लोग दुःखों में हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","तब रूबेन ने उनसे कहा, “मैंने तुमसे कहा था कि उस लड़के का कुछ भी बुरा न करो। लेकिन तुम लोगों ने मेरी एक न सुनी। इसलिए अब हम उसकी मृत्यु के लिए दण्डित हो रहे हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","यूसुफ अपने भाईयों से बात करने के लिए एक दुभाषिये से काम ले रहा था। इसलिए भाई नहीं जानते थे कि यूसुफ उनकी भाषा जानता है। किन्तु वे जो कुछ कहते थे उसे यूसुफ सुनता और समझता था। ");
INSERT INTO hin2010_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","उनकी बातों से यूसुफ बहुत दुःखी हुआ। इसलिए यूसुफ उनसे अलग हट गया और रो पड़ा। थोड़ी देर में यूसुफ उनके पास लौटा। उसने भाईयों में से शिमोन को पकड़ा और उसे बाँधा जब कि अन्य भाई देखते रहे। ");
INSERT INTO hin2010_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","यूसुफ ने कुछ सेवकों को उनकी बोरियों को अन्न से भरने को कहा। भाईयों ने इस अन्न का मूल्य यूसुफ को दिया। किन्तु यूसुफ ने उस धन को अपने पास नहीं रखा। उसने उस धन को उनकी अनाज की बोरियों में रख दिया। तब यूसुफ ने उन्हें वे चीज़ें दी, जिनकी आवश्यकता उन्हें घर तक लौटने की यात्रा में ही सकती थी। ");
INSERT INTO hin2010_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","इसलिए भाईयों ने अन्न को अपने गधों पर लादा और वहाँ से चल पड़े। ");
INSERT INTO hin2010_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","वे सभी भाई रात को ठहरे और भाईयों में से एक ने कुछ अन्न के लिए अपनी बोरी खोली और उसने अपना धन अपनी बोरी में पाया। ");
INSERT INTO hin2010_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","उसने अन्य भाईयों से कहा, “देखो, जो मूल्य मैंने अन्न के लिए चुकाया, वह यहाँ है। किसी ने मेरी बोरी में ये धन लौटा दिया है। वे सभी भाई बहुत अधिक भयभीत हो गए। उन्होंने आपस में बातें की, परमेश्वर हम लोगों के साथ क्या कर रहा है?” ");
INSERT INTO hin2010_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","वे भाई कनान देश में अपने पिता याकूब के पास गए। उन्होंने जो कुछ हुआ था अपने पिता को बताया। ");
INSERT INTO hin2010_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","उन्होंने कहा, “उस देश का प्रशासक हम लोगों से बहुत रूखाई से बोला। उसने सोचा कि हम लोग उस सेना की ओर से भेजे गए हैं जो वहाँ के लोगों को नष्ट करना चाहती है। ");
INSERT INTO hin2010_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","लेकिन हम लोगों ने कहा कि, हम लोग ईमानदार हैं। हम लोग किसी सेना में से नहीं हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","हम लोगों ने उसे बताया कि, ‘हम लोग बारह भाई हैं। हम लोगों ने अपने पिता के बारे में बताया और यह कहा कि हम लोगों का सबसे छोटा भाई अब भी कनान देश में है।’” ");
INSERT INTO hin2010_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“तब देश के प्रशासक ने हम लोगों से यह कहा, ‘यह प्रमाणित करने के लिए कि तुम ईमानदार हो यह रास्ता है: अपने भाईयों में से एक को हमारे पास यहाँ छोड़ दो। अपना अन्न लेकर अपने परिवारों के पास लौट जाओ। ");
INSERT INTO hin2010_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","अपने सबसे छोटे भाई को हमारे पास लाओ। तब मैं समझूँगा कि तुम लोग ईमानदार हो अथवा तुम लोग हम लोगों को नष्ट करने वाली सेना की ओर से नहीं भेजे गए हो। यदि तुम लोग सब बोल रहे हो तो मैं तुम्हारे भाई को तुम्हें दे दूँगा।’” ");
INSERT INTO hin2010_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","तब सब भाई अपनी बोरियों से अन्न लेने गए और हर एक भाई ने अपने धन की थैली अपने अन्न की बोरी में पाई। भाईयों और उनके पिता ने धन को देखा और वे बहुत डर गए। ");
INSERT INTO hin2010_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","याकूब ने उनसे कहा, “क्या तुम लोग चाहते हो कि मैं अपने सभी पुत्रों से हाथ धो बैठूँ। यूसुफ तो चला ही गया। शिमोन भी गया और तुम लोग बिन्यामीन को भी मुझसे दूर ले जाना चाहते हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","तब रूबेन ने अपने पिता से कहा, “पिताजी आप मेरे दो पुत्रों को मार देना यदि मैं बिन्यामीन को आपके पास बिन्यामीन को लौटा लाऊँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","किन्तु याकूब ने कहा, “मैं बिन्यामीन को तुम लोगों के साथ नहीं जाने दूँगा। उसका भाई मर चुका है। और मेरी पत्नी राहेल का वही अकेला पुत्र बचा है। मिस्र तक की यात्रा में यदि उसके साथ कुछ हुआ तो वह घटना मुझे मार डालेगी। तुम लोग मुझ वृद्ध को कब्र में बहुत दुःखी करके भेजोगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","देश में भूखमरी का समय बहुत ही बुरा था। वहाँ कोई भी खाने की चीज नहीं उग रही थी। ");
INSERT INTO hin2010_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","लोग वह सारा अन्न खा गए जो वे मिस्र से लाये थे। जब अन्न समाप्त हो गया, याकूब ने अपने पुत्रों से कहा, “फिर मिस्र जाओ। हम लोगों के खाने के लिए कुछ और अन्न खरीदो।” ");
INSERT INTO hin2010_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","किन्तु यहूदा ने याकूब से कहा, “उस देश के प्रसाशक ने हम लोगों को चेतावनी दी है। उसने कहा है, ‘यदि तुम लोग अपने भाई को मेरे पास वापस नहीं लाओगे तो मैं तुम लोगों से बात करने से मना भी कर दूँगा।’ ");
INSERT INTO hin2010_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","यदि तुम हम लोगों के साथ बिन्यामीन को भेजोगे तो हम लोग जाएँगे और अन्न खरीदेंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","किन्तु यदि तुम बिन्यामीन को भेजने से मना करोगे तब हम लोग नहीं जाएँगे। उस व्यक्ति ने चेतावनी दी कि हम लोग उसके बिना वापस न आए।” ");
INSERT INTO hin2010_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","इस्राएल (याकूब) ने कहा, “तुम लोगों ने उस व्यक्ति से क्यों कहा, कि तुम्हारा अन्य भाई भी है। तुम लोगों ने मेरे साथ ऐसी बुरी बात क्यों की?” ");
INSERT INTO hin2010_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","भाईयों ने उत्तर दिया, “उस व्यक्ति ने सावधानी से हम लोगों से प्रश्न पूछे। वह हम लोगों तथा हम लोगों के परिवार के बारे में जानना चाहता था। उसने हम लोगों से पूछा, ‘क्या तुम लोगों का पिता अभी जीवित है? क्या तुम लोगों का अन्य भाई घर पर है?’ हम लोगों ने केाल उसके प्रश्नों के उत्तर दिए। हम लोग नहीं जानते थे के वह हमारे दूसरे भाई को अपने पास लाने को कहेगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","तब यहूदा ने अपने पिता इस्राएल से कहा, “बिन्यामीन को मेरे साथ भेजो। मैं उसकी देखभाल करूँगा हम लोग मिस्र अवश्य जाएँगे और भोजन लाएँगे। यदि हम लोग नहीं जाते हैं तो हम लोगों के बच्चे भी मर जाएँगे। ");
INSERT INTO hin2010_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","मैं विश्वास दिलाता हूँ कि वह सुरक्षित रहेगा। मैं इसका उत्तरदायी रहूँगा। यदि मैं उसे तुम्हारे लौटाकर न लाऊँ तो तुम सदा के लिए मुझे दोषी ठहरा सकते हो। ");
INSERT INTO hin2010_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","यदि तुमने हमें पहले जाने दिया होता तो भोजन के लिए हम लोग दो यात्राएँ अभी तक कर चुके होते।” ");
INSERT INTO hin2010_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","तब उनके पिता इस्राएल ने कहा, “यदि यह सचमुच सही है तो बिन्यामीन को अपने साथ ले जाओ। किन्तु प्रशासक के लिए कुछ भेंट ले जाओ। उन चीजों में से कुछ ले जाओ जो हम लोग अपने देश में इकट्ठा कर सके हैं। उसके लिए कुछ शहद, पिस्ते, बादाम, गोंद और लोबान ले जाओ। ");
INSERT INTO hin2010_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","इस समय, पहले से दुगुना धन भी ले लो जो पिछली बार देने के बाद लौटा दिया गया था। संभव है कि प्रशासक से गलती हुई हो। ");
INSERT INTO hin2010_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","बिन्यामीन को साथ लो और उस व्यक्ति के पास ले जाओ। ");
INSERT INTO hin2010_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","मैं प्रार्थना करता हूँ कि सर्वशक्तिमान परमेश्वर तुम लोगों की उस समय सहायता करेगा जब तुम प्रशासक के सामने खड़े होओगे। मैं प्रार्थना करता हूँ कि वह बिन्यामीन और शिमोन को भी सुरक्षित आने देगा। यदि नहीं तो मैं अपने पुत्र से हाथ धोकर फिर दुःखी होऊँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","इसलिए भाईयों ने प्रशासक को देने के लिए भेंटे ली और उन्होंने जितना धन पहले लिया था उसका दुगना धन अपने साथ लिया। बिन्यामीन भाईयों के साथ मिस्र गया। ");
INSERT INTO hin2010_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","मिस्र में यूसुफ ने उनके साथ बिन्यामीन को देखा। यूसुफ ने अपने सेवक से कहा, “उन व्यक्तियों को मेरे घर लाओ। एक जानवर मारो और पकाओ। वे व्यक्ति आज दोपहर को मेरे साथ भोजन करेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","सेवक को जैसा कहा गया था वैसा किया। वह उन व्यक्तियों को यूसुफ के घर लाया। ");
INSERT INTO hin2010_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","भाई डरे हुए थे जब वे यूसुफ के घर लाए गए। उन्होंने कहा, “हम लोग यहाँ उस धन के लिए लाए गए हैं जो पिछली बार हम लोगों की बोरियों में रख दिया गया था। वे हम लोगों को अपराधी सिद्ध करने लिए उनका उपयोग करेंगे। तब वे हम लोगों के गधों को चुरा लेंगे और हम लोगों को दास बनाएँगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","अतः यूसुफ के घर की देख—रेख करने वाले सेवक के पास सभी भाई गए। ");
INSERT INTO hin2010_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","उन्होंने कहा, “महोदय, मैं प्रतिज्ञापूर्वक सब कहता हूँ कि पिछली बार हम आए थे। हम लोग भोजन खरीदने आए थे। ");
INSERT INTO hin2010_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","घर लौटते समय हम लोगों ने अपनी बोरियाँ खोलीं और हर एक बोरी में अपना धन पाया। हम लोग नहीं जानते कि उनमें धन कैसे पहुँचा। किन्तु हम वह धन आपको लौटाने के लिए साथ लाए हैं और इस समय हम लोग जो अन्न खरीदना चाहते हैं उसके लिए अधिक धन लाए हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","किन्तु सेवक ने उत्तर दिया, “डरो नहीं, मुझ पर विश्वास करो। तुम्हारे पिता के परमेश्वर ने तुम लोगों के धन को तुम्हारी बोरियों में भेंट के रूप में रखा होगा। मुझे याद है कि तुम लोगों ने पिछली बार अन्न का मूल्य मुझे दे दिया था।” सेवक शिमोन को कारागार से बाहर लाया। ");
INSERT INTO hin2010_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","सेवक उन लोगों को यूसुफ के घर ले गया। उसने उन्हें पानी दिया और उन्होंने अपने पैर धोए। तब तक उसने उनके गधों को खाने के लिए चारा दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","भाईयों ने सुना कि वे यूसुफ के साथ भोजन करेंगे। इसलिए उसके लिए अपनी भेंट तैयार करने में वे दोपहर तक लगे रहे। ");
INSERT INTO hin2010_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","यूसुफ घर आया और भाईयों ने उसे भेंट दीं जो वे अपने साथ लाए थे। तब उन्होंने धरती पर झुककर प्रणाम किया। ");
INSERT INTO hin2010_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","यूसुफ ने उनकी कुशल पूछी। यूसुफ ने कहा, “तुम लोगों का वृद्ध पिता जिसके बारे में तुम लोगों ने बताया, ठीक तो है? क्या वह अब तक जीवित है?” ");
INSERT INTO hin2010_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","भाईयों ने उत्तर दिया, “महोदय, हम लोगों के पिता ठीक हैं। वे अब तक जीवित है” और वे फिर यूसुफ के सामने झुके। ");
INSERT INTO hin2010_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","तब यूसुफ ने अपने भाई बिन्यामीन को देखा। (बिन्यामीन और यूसुफ की एक ही माँ थी) यूसुफ ने कहा, “क्या यह तुम लोगों का सबसे छोटा भाई है जिसके बारे में तुम ने बताया था?” तब यूसुफ ने बिन्यामीन से कहा, “परमेश्वर तुम पर कृपालु हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","तब यूसुफ कमरे से बाहर दौड़ गया। यूसुफ बहुत चाहता थी कि वह अपने भाईयों को दिखाए कि वह उनसे बहुत प्रेम करता है। वह रोने—रोने सा हो रहा था, किन्तु वह नहीं चाहता था कि उसके भाई उसे रोता देखें। इसलिए वह अपने कमरे में दौड़ता हुआ पहुँचा और वहीं रोया। ");
INSERT INTO hin2010_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","तब यूसुफ ने अपना मुँह धोया और बाहर आया। उसने अपने को संभाला और कहा, “अब भोजन करने का समय है।” ");
INSERT INTO hin2010_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","यूसुफ ने अकेले एक मेज पर भोजन किया। उसके भाईयों ने दूसरी मेज पर एक साथ भोजन किया। मिस्री लोगों ने अन्य मेज पर एक साथ खाया। उनका विश्वास था कि उनके लिए यह अनुचित है कि वे हिब्रू लोगों के साथ खाएँ। ");
INSERT INTO hin2010_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","यूसुफ के भाई उसके सामने की मेज पर बैठे थे। सभी भाई सबसे बड़े भाई से आरम्भ कर सबसे छोटे भाई तक क्रम में बैठे थे। सभी भाई एक दूसरे को, जी हो रहा था उस पर आश्चर्य करते हुए देखते जा रहे थे। ");
INSERT INTO hin2010_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","सेवक यूसुफ की मेज से उनको भोजन ले जाते थे। किन्तु औरों की तुलना में सेवकों ने बिन्यामीन को पाँच गुना अधिक दिया। यूसुफ के साथ वे सभी भाई तब तक खाते और दाखमधु पीते रहे जब तक वे नशे में चूर नहीं हो गया। ");
INSERT INTO hin2010_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","तब यूसुफ ने अपने नौकर को आदेश दिया। यूसुफ ने कहा, “उन व्यक्तियों की बोरियों में इतना अन्न भरी जितना ये ले जा सके और हर एक का धन उस की अन्न की बोरी में रख दो। ");
INSERT INTO hin2010_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","सबसे छोटे भाई की बोरी में धन रखो। किन्तु उसकी बोरी में मेरी विशेष चाँदी का प्याला भी रख दो।” सेवक ने यूसुफ का आदेश पूरा किया। ");
INSERT INTO hin2010_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","अगले दिन बहुत सुबह सब भाई अपने गधों के साथ अपने देश को वापस भेज दिए गए। ");
INSERT INTO hin2010_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","जब वे नगर को छोड़ चुके, यूसुफ ने अपने सेवक से कहा, “जाओ और उन लोगों का पीछा करो। उन्हें रोको और उनसे कहो, ‘हम लोग आप लोगों के प्रति अच्छे रहे। किन्तु आप लोगों ने हमारे यहाँ चोरी क्यों की? आप लोगों ने यूसुफ का चाँदी का प्याला क्यों चुराया? ");
INSERT INTO hin2010_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","हमारे मालिक यूसुफ इसी प्याले से पीते हैं। वे सपने की व्याख्या के लिए इसी प्याले का उपयोग करते हैं। इस प्याले को चुराकर आप लोगों ने अपराध किया है।’” ");
INSERT INTO hin2010_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","अतः सेवक ने आदेश का पालन किया। वह सवार हो कर भाईयों तक गया और उन्हें रोका। सेवक ने उनसे वे ही बातें कहीं जो यूसुफ ने उनसे कहने के लिए कही थी। ");
INSERT INTO hin2010_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","किन्तु भाईयों ने सेवक से कहा, “प्रशासक ऐसी बातें क्यों कहते है? हम लोग ऐसा कुछ नहीं कर सकते। ");
INSERT INTO hin2010_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","हम लोग वह धन लौटाकर लाए जो पहले हम लोगों की बोरियों में मिले थे। ");
INSERT INTO hin2010_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","इसलिए निश्चय ही हम तुम्हारे मालिक के घर से चाँदी का वह प्याला पा जाये तो उस व्यक्ति को मर जाने दिया जाये। तुम उसे मार सकते हो और हम लोग तुम्हारे दास होंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","सेवक ने कहा, “जैसा तुम कहते हो हम वैसा ही करेंगे, किन्तु मैं उस व्यक्ति को मारूँगा नहीं। यदि मुझे चाँदी का प्याला मिलेगा तो वह व्यक्ति मेरा दास होगा। अन्य भाई स्वतन्त्र होंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","तब सभी भाईयों ने अपनी बोरियों जल्दी जल्दी ज़मीन पर खोली। ");
INSERT INTO hin2010_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","सेवक ने बोरियों जल्दी जल्दी जमीन पर खोली। सेवक ने बोरियों में देखा। उसने सबसे बड़े भाई से आरम्भ किया और सबसे छोटे भाई पर अन्त किया। उसने बिन्यामीन की बोरी में प्याला पाया। ");
INSERT INTO hin2010_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","भाई बहुत दुःखी हुए। उन्होंने दुःख के कारण अपने वस्त्र फाड़ डाले। उन्होंने अपनी बोरियाँ गधों पर लादी और नगर को लौट पड़े। ");
INSERT INTO hin2010_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","यहूदा और उसके भाई यूसुफ के घर लौटकर गए। यूसुफ तब तक वहाँ था। भाईयों ने पृथ्वी तक झुककर प्रणाम किया। ");
INSERT INTO hin2010_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","यूसुफ ने उनसे कहा, “तुम लोगों ने यह क्यों किया? क्या तुम लोगों को पता नहीं है कि गुप्त बातों को जानने का मेरा विशेष ढंग है। मुझसे बढ़कर अच्छी तरह कोई दूसरा यह नहीं कर सकता।” ");
INSERT INTO hin2010_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहूदा ने कहा, “महोदय, हम लोगों को कहने के लिए कुछ नहीं है। स्पष्ट करने का कोई रास्ता नहीं है। यह दिखाने का कोई तरीका नहीं है कि हम लोग अपराधी नहीं है। हम लोगों ने और कुछ किया होगा जिसके लिए परमेश्वर ने हमें अपराधी ठहराया। इसलिए हम सभी बिन्यामीन भी, आपके दास होंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","किन्तु यूसुफ ने कहा, “मैं तुम सभी को दास नहीं बनाउँगा। केवल वह व्यक्ति जिसने प्याला चुराया है, मेरा दास होगा। अन्य तुम लोग शान्ति से अपने पिता के पास जा सकते हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","तब यहूदा यूसुफ के पास गया और उसने कहा, “महोदय, कृपाकर मुझे स्वयं स्पष्ट कह लेने दें। कृपा कर मुझ से अप्रसन्न न हों। मैं जानता हूँ कि आप स्वयं फ़िरौन जैसे हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","जब हम लोग पहले यहाँ आए थे, आपने पूछा था कि ‘क्या तुम्हारे पिता या भाई है?’ ");
INSERT INTO hin2010_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","और हमने आपको उत्तर दिया, ‘हमारे एक पिता हैं, वे बूढ़े हैं और हम लोगों का एक छोटा भाई है। हमारे पिता उससे बहुत प्यार करते है। क्योंकि उसका जन्म उनके बूढ़ापे में हुआ था, यह अकेला पुत्र है। हम लोगों के पिता उसे बहुत प्यार करते हैं।’ ");
INSERT INTO hin2010_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","तब आपने हमसे कहा था, ‘उस भाई को मेरे पास लाओ। मैं उसे देखना चाहता हूँ।’ ");
INSERT INTO hin2010_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","और हम लोगों ने कहा था, ‘वह छोटा लड़का नहीं आ सकता। वह अपने पिता को नहीं छोड़ सकता। यदि उसके पिता को उससे हाथ धोना पड़ा तो उसका पिता इतना दुःखी होगा कि वह मर जाएगा।’ ");
INSERT INTO hin2010_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","किन्तु आपने हमसे कहा, ‘तुम लोग अपने छोटे भाई को अवश्य लाओ, नहीं तो मैं फिर तुम लोगों के हाथ अन्न नहीं बेचूँगा।’ ");
INSERT INTO hin2010_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","इसलिए हम लोग अपने पिता के पास लौटे और आपने जो कुछ कहा, उन्हें बताया। ");
INSERT INTO hin2010_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“बाद में हम लोगों के पिता ने कहा, ‘फिर जाओ और हम लोगों के लिए कुछ और अन्न खरीदो।’ ");
INSERT INTO hin2010_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","और हम लोगों ने अपने पिता से कहा, ‘हम लोग अपने सबसे छोटे भाई के बिना नहीं जा सकते। शासक ने कहा है कि वह तब तक हम लोगों को फिर अन्न नहीं बेचेगा जब तक वह हमारे सबसे छोटे भाई को नहीं देख लेता।’ ");
INSERT INTO hin2010_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","तब मेरे पिता ने हम लोगों से कहा, ‘तुम लोग जानते हो कि मेरी पत्नी राहेल ने मुझे दो पत्र दिये। ");
INSERT INTO hin2010_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","मैंने एक पुत्र को दूर जाने दिया और वह जंगली जानवर द्वारा मारा गया और तब से मैंने उसे नहीं देखा है। ");
INSERT INTO hin2010_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","यदि तुम लोग मेरे दूसरे पुत्र को मुझसे दूर ले जाते हो और उसे कुछ हो जाता है तो मुझे इतना दुःख होगा कि मैं मर जाऊँगा।’ ");
INSERT INTO hin2010_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","इसलिए यदि अब हम लोग अपने सबसे छोटे भाई के बिना घर जायेंगे तब हम लोगों के पिता को यह देखना पड़ेगा। यह छोटा लड़का हमारे पिता के जीवन में सबसे अधिक महत्व रखता है। ");
INSERT INTO hin2010_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","जब वे देखेंगे कि छोटा लड़का हम लोगों के साथ नहीं है वे मर जायेंगे और यह हम लोगों का दोष होगा। हम लोग अपने पिता के घोर दुःख एवं मृत्यु का कारण होंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“मैंने छोटे लड़के का उत्तरदायित्व लिया है। मैंने अपने पिता से कहा, ‘यदि मैं उसे आपके पास लौटाकर न लाऊँ तो आप मेरे सारे जीवनभर मुझे दोषी ठहरा सकते है।’ ");
INSERT INTO hin2010_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","इसलिए अब मैं आपसे माँगता हूँ, और आप से प्रार्थना करता हूँ कि कृपया छोटे लड़के को अपने भाईयों के साथ लौट जाने दें और मैं यहाँ रूकूँगा और आपका दास होऊँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","मैं अपने पिता के पास लौट नहीं सकता यदि हमारे साथ छोटा भाई नहीं रहेगा। मैं इस बात से बहुत भयभीत हूँ कि मेरे पिता के साथ क्या घटेगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","यूसुफ अपने को और अधिक न संभाल सका। वह वहाँ उपस्थित सभी लोगों के सामने हो पड़ा। यूसुफ ने कहा, “हर एक से कहो कि यहाँ से हट जाए।” इसलिए सभी लोग चले गये। केवल उसके भाई ही यूसुफ के साथ रह गए। तब यूसुफ ने उन्हें बताया कि वह कौन है। ");
INSERT INTO hin2010_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","यूसुफ रोता रहा, और फ़िरौन के महल के सभी मिस्री व्यक्तियों ने सुना। ");
INSERT INTO hin2010_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","यूसुफ ने अपने भाईयों से कहा, “मैं आप लोगों का भाई यूसुफ हूँ। क्या मेरे पिता सकुशल हैं?” किन्तु भाईयों ने उसको उत्तर नहीं दिया। वे डरे हुए तथा उलझान में थे। ");
INSERT INTO hin2010_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","इसलिए यूसुफ ने अपने भाईयों से फिर कहा, “मेरे पास आओ।” इसलिए यूसुफ के भाई निकट गए और यूसुफ ने उनसे कहा, “मैं आप लोगों का भाई यूसुफ हूँ। मैं वहीं हूँ जिसे मिस्रियों के हाथ आप लोगों ने दास के रूप में बेचा था। ");
INSERT INTO hin2010_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","अब परेशान न हों। आप लोग अपने किए हुए के लिए स्वयं भी पश्चाताप न करें। वह तो मेरे लिए परमेश्वर की योजना थी कि मैं यहाँ आऊँ। मैं यहाँ तुम लोगों का जीवन बचाने के लिए आया हूँ। ");
INSERT INTO hin2010_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","यह भयंकर भूखमरी का समय दो वर्ष ही अभी बीता है और अभी पाँच वर्ष बिना पौधे रोपने या उपज के आएँगे। ");
INSERT INTO hin2010_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","इसलिए परमेश्वर ने तुम लोगों से पहले मुझे यहाँ भेजा जिससे मैं इस देश में तुम लोगों को बचा सकूँ। ");
INSERT INTO hin2010_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","यह आप लोगों का दोष नहीं था कि मैं यहाँ भेजा गया। वह परमेश्वर की योजना थी। परमेश्वर ने मुझे फ़िरौन के पिता सदृश बनाया। ताकि मैं उसके सारे घर और सारे मिस्र का शासक रहूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","यूसुफ ने कहा, “इसलिए जल्दी मेरे पिता के पास जाओ। मेरे पिता से कहो कि उसके पुत्र यूसुफ ने यह सन्देश भेजा है: ‘परमेश्वर ने मुझे पूरे मिस्र का शासक बनाया है। मेरे पास आइये। प्रतीक्षा न करें। अभी आएँ। ");
INSERT INTO hin2010_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","आप मेरे निकट गीरोत प्रदेश में रहेंगे। आपका, आपके पुत्रों का, आपके सभी जानवरों एवं झुण्डों का यहाँ स्वागत है। ");
INSERT INTO hin2010_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","भुखमरी के अगले पाँच वर्षों में मैं आपका देखभाल करुँगा। इस प्रकार आपके और आपके परिवार की जो चीज़ें हैं उनसे आपको हाथ धोना नहीं पड़ेगा।’ ");
INSERT INTO hin2010_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“यूसुफ अपने भाईयों से बात करता रहा। उसने कहा, “अब आप लोग देखते हैं कि यह सचमुच मैं ही हूँ, और आप लोगों का भाई बिन्यामीन जानता है कि यह मैं हूँ। मैं आप लोगों का भाई आप लोगों से बात कर रहा हूँ। ");
INSERT INTO hin2010_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","इसलिए मेरे पिता से मेरी मिस्र की अत्याधिक सम्पत्ति के बारे में कहें। आप लोगों ने जो यहाँ देखा है उस हर एक चीज़ के बारे में मेरे पिता को बताएं। अब जल्दी करो और मेरे पिता को लेकर मेरे पास लौटो।” ");
INSERT INTO hin2010_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","तब यूसुफ ने अपने भाई बिन्यामीन को गले लगाया और हो पड़ा और बिन्यामीन भी हो पड़ा। ");
INSERT INTO hin2010_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","तब यूसुफ ने सभी भाईयों को चूमा और उनके लिए रो पड़ा। इसके बाद भाई उसके साथ बातें करने लगे। ");
INSERT INTO hin2010_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","फ़िरौन को पता लगा कि यूसुफ के भाई उसके पास आए हैं। यह खबर फ़िरौन के पूरे महल में फैल गई। फ़िरौन और उसके सेवक इस बारे में बहुत प्रसन्न हुए। ");
INSERT INTO hin2010_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","इसलिए फ़िरौन ने यूसुफ से कहा, “अपने भाईयों से कहो कि उन्हें जितना भोजन चाहिए, लें और कनान देश को लौट जाए। ");
INSERT INTO hin2010_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","अपने भाईयों से कहो कि वे अपने पिता और अपने परिवारों को लेकर यहाँ मेरे पास आए। मैं तुम्हें जीविका के लिए मिस्र में सबसे अच्छी भूमि दूँगा और तुम्हारा परिवार सबसे अच्छा भोजन करेगा जो हमारे पास यहाँ है। ");
INSERT INTO hin2010_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","तब फ़िरौन ने कहा, “हमारी सबसे अच्छी गाड़ियों में से कुछ अपने भाईयों को दो। उन्हें कनान जाने और गाड़ियों में अपने पिता, स्त्रियों और बच्चों को यहाँ लाने को कहो। ");
INSERT INTO hin2010_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","उनकी कोई भी चीज़ यहाँ लाने की चिन्ता न करो। हम उन्हें मिस्र में जो कुछ सबसे अच्छा है, देंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","इसलिए इस्राएल के पुत्रों ने यही किया। यूसुफ ने फ़िरौन के वचन के अनुसार अच्छी गाड़ियाँ दी और यूसुफ ने यात्रा के लिए उन्हें भरपूर भोजन दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","यूसुफ ने हर एक भाई को एक एक जोड़ा सुन्दर वस्त्र दिया। किन्तु यूसुफ ने बिन्यामीन को पाँच जोड़े सुन्दर वस्त्र दिए और यूसुफ ने बिन्यामीन को तीन सौ चाँदी के सिक्के भी दिए। ");
INSERT INTO hin2010_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","यूसुफ ने अपने पिता को भी भेंटें भेजी। उसने मिस्र से बहुत सी अच्छी चीज़ों से भरी बोरियों से लदे दस गधों को भेजा और उसने अपने पिता के लिए अन्न, रोटी और अन्य भोजन से लदी हुई दस गदहियों को उनकी वापसी यात्रा के लिए भेजा। ");
INSERT INTO hin2010_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","तब यूसुफ ने अपने भाईयों को जाने के लिए कहा। जब वे जाने को हुए थे यूसुफ ने उनसे कहा, “सीधे घर जाओ और रास्ते में लड़ना नहीं।” ");
INSERT INTO hin2010_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","इस प्रकार भाईयों ने मिस्र को छोड़ा और कनान देश में अपने पिता के पास गए। ");
INSERT INTO hin2010_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","भाईयों ने उससे कहा, “पिताजी यूसुफ अभी जीवित है और वह पूरे मिस्र देश का प्रशासक है।” उनका पिता चकित हुआ। उसने उन पर विश्वास नहीं किया। ");
INSERT INTO hin2010_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","किन्तु यूसुफ ने जो बातें कहीं थी, भाईयों ने हर एक बात अपने पिता से कही। तब याकूब ने उन गाड़ियों को देखा जिन्हें यूसुफ ने उसे मिस्र की वापसी यात्रा के लिए भेजा था। तब याकूब भाबुक हो गया और अत्यन्त प्रसन्न हुआ। ");
INSERT INTO hin2010_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","इस्राएल ने कहा, “अब मुझे विश्वास है कि मेरा पुत्र यूसुफ अभी जीवित है। मैं मरने से पहले उसे देखने जा रहा हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","इसलिए इस्राएल ने मिस्र की अपनी यात्रा प्रारम्भ की। पहले इस्राएल बेर्शेबा पहुँचा। वहाँ इस्राएल ने अपने पिता इसहाक के परमेश्वर की उपासना की। उसने बलि दी। ");
INSERT INTO hin2010_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","रात में परमेश्वर इस्राएल से सपने में बोला। परमेश्वर ने कहा, “याकूब, याकूब।” और इस्राएल ने उत्तर दिया, “मैं यहाँ हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","तब यहोवा ने कहा, “मैं यहोवा हूँ तुम्हारे पिता का परमेश्वर। मिस्र जाने से न डरो। मिस्र में मैं तुम्हें महान राष्ट्र बनाऊँगा। ");
INSERT INTO hin2010_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","मैं तुम्हारे साथ मिस्र चलूँगा और मैं तुम्हें फिर मिस्र से बाहर निकाल लाऊँगा। तुम मिस्र में मरोगे। किन्तु यूसुफ तुम्हारे साथ रहेगा। जब तुम मरोगे तो वह स्वयं अपने हाथों से तुम्हारी आँखें बन्द करेगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","तब याकूब ने बेर्शेबा छोड़ा और मिस्र तक यात्रा की। उसके पुत्र, अर्थात् इस्राएल के पुत्र अपने पिता, अपनी पत्नियों और अपने सभी बच्चों को मिस्र ले आए। उन्होंने फ़िरौन द्वारा भेजी गयी गाड़ियों में यात्रा की। ");
INSERT INTO hin2010_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","उनके पास उनके पशु और कनान देश में उनका अपना जो कुछ था, वह भी साथ था। इस प्रकार इस्राएल अपने सभी बच्चे और अपने परिवार के साथ मिस्र गया। ");
INSERT INTO hin2010_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","उसके साथ उसके पुत्र और पुत्रियाँ एवं पौत्र और पौत्रियाँ थी। उसका सारा परिवार उसके साथ मिस्र को गया। ");
INSERT INTO hin2010_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","यह इस्राएल के उन पुत्रों और परिवारों के नाम है जो उसके साथ मिस्र गए: रूबेन याकूब का पहला पुत्र था। ");
INSERT INTO hin2010_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","रूबेन के पुत्र थे: हनोक, पललू, हेस्रोन और कर्म्मी। ");
INSERT INTO hin2010_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमोन के पुत्र: यमूएल, यामीन, ओहद, याकीन और सोहर। वहाँ शाऊल भी था। (शाऊल कनानी पत्नी से पैदा हुआ था।) ");
INSERT INTO hin2010_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवी के पुत्र: गेर्शोन, कहात और मरारी। ");
INSERT INTO hin2010_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदा के पुत्र: एर, ओनान, शेला, पेरेस और जेरह। (एर और ओनान कनान में रहने समय मर गये थे।) पेरेम के पुत्र: हेब्रोन और हामूल। ");
INSERT INTO hin2010_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्साकार के पुत्र: तोला, पुब्बा, योब और शिम्रोन। ");
INSERT INTO hin2010_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबूलून के पुत्र: सेरेद, एलोन और यहलेल। ");
INSERT INTO hin2010_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","रूबेन, शिमोन लेवी, इस्साकार और जबूलून और याकूब की पत्नी लिआ से उसकी पुत्री दीना भी थी। इस परिवार में तैंतीस व्यक्ति थे। ");
INSERT INTO hin2010_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","गाद के पुत्र: सिय्योन, हाग्गी, शूनी, एसबोन, एरी, अरोदी और अरेली। ");
INSERT INTO hin2010_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशेर के पुत्र: यिम्ना, यिश्वा, यिस्वी, बरीआ और उनकी बहन सेरह और बरीआ के पुत्र: हेबेर और मल्कीएल थे। ");
INSERT INTO hin2010_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ये सभी याकूब की पत्नी की दासी जिल्पा से उसके पुत्र थे। इस परिवार में सोलह व्यक्ति थे। ");
INSERT INTO hin2010_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","याकूब के साथ उसकी पत्नी राहेल से पैदा हुआ पुत्र बिन्यामीन भी था। (यूसुफ भी राहेल से पैदा था, किन्तु वह पहले से ही मिस्र में था।) ");
INSERT INTO hin2010_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","मिस्र में यूसुफ के दो पुत्र थे, मनश्शे, एप्रैम। (यूसुफ की पत्नी ओन के याजक पोतीपेरा की पुत्री आसनत थी।) ");
INSERT INTO hin2010_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बिन्यामीन के पुत्र: बेला, बेकेर, अश्बेल, गेरा, नामान, एही, रोश, हुप्पीम, मुप्पीम और आर्द। ");
INSERT INTO hin2010_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","वे याकूब की पत्नी राहेल से पैदा हुए उसके पुत्र थे। इस परिवार में चौदह व्यक्ति थे। ");
INSERT INTO hin2010_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","दान का पुत्र: हूशीम। ");
INSERT INTO hin2010_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नप्ताली के पुत्र: यहसेल, गूनी, सेसेर शिल्लेम। ");
INSERT INTO hin2010_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","वे याकूब और बिल्हा के पुत्र थे। (बिल्हा राहेल की सेविका थी।) इस परिवार में सात व्यक्ति थे। ");
INSERT INTO hin2010_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","इस प्रकार याकूब का परिवार मिस्र में पहुँचा। उनमें छियासठ उसके सीधे वंशज थे। (इस संख्या में याकूब के पुत्रों की पत्नियाँ सम्मिलित नहीं थी।) ");
INSERT INTO hin2010_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","यूसुफ के भी दो पुत्र थे। वे मिस्र में पैदा हुए थे। इस प्रकार मिस्र में याकूब के परिवार में सत्तर व्यक्ति थे। ");
INSERT INTO hin2010_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","याकूब ने पहले यहूदा को यूसुफ के पास भेजा। यहूदा गोशेन प्रदेश में यूसुफ के पास गया। जब याकूब और उसके लोग उस प्रदेश में गए। ");
INSERT INTO hin2010_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","यूसुफ को पता लगा कि उसका पिता निकट आ रहा है। इसलिए यूसुफ ने अपना रथ तैयार कराया और अपने पिता इस्राएल से गीशोन में मिलने चला। जब यूसुफ ने अपने पिता को देखा तब वह उसके गले से लिपट गया और देर तक रोता रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","तब इस्राएल ने यूसुफ से कहा, “अब मैं शान्ति से मर सकता हूँ। मैंने तुम्हारा मुँह देख लिया और मैं जानता हूँ कि तुम अभी जीवित हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","यूसुफ ने अपने भाईयों और अपने पिता के परिवार से कहा, “मैं जाऊँगा और फ़िरौन से कहूँगा कि मेरे पिता यहाँ आ गए हैं। मैं फिंरौन से कहूँगा, ‘मेरे भाईयों और मेरे पिता के परिवार ने कनान देश छोड़ दिया है और यहाँ मेरे पास आ गए हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","यह चरवाहों का परिवार है। उन्होंने सदैव पशु और रेवड़े रखी हैं। वे अपने सभी जानवर और उनका जो कुछ अपना है उसे अपने साथ लाएं हैं।’ ");
INSERT INTO hin2010_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","जब फ़िरौन आप लोगों को बुलाएँगे और आप लोगों से पूछेंगे कि, ‘आप लोग क्या काम करते हैं?’ ");
INSERT INTO hin2010_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","आप लोग उनसे कहना, ‘हम लोग चरवाहे हैं। हम लोगों ने पूरा जीवन अपने जानवरों की देखभाल में बिताया है। हम लोगों से पहले हमारे पूर्वज भी ऐसे ही रहे।’ तब फ़िरौन तुम लोगों को गीशोन प्रदेश में रहने की आज्ञा दे देगा। मिस्री लोग चरवाहों को पसन्द नहीं करते, इसलिए अच्छा यही होगा कि आप लोग गीशोन में ही ठहरों।” ");
INSERT INTO hin2010_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","यूसुफ फ़िरौन के पास गया और उसने कहा, “मेरे पिता, मेरे भाई और उनके सब परिवार यहाँ आ गए हैं। वे अपने सभी जानवर तथा कनान में उनका अपना जो कुछ था, उसके साथ हैं। इस समय वे गीशोन प्रदेश में हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","यूसुफ ने अपने भाईयों में से पाँच को फ़िरौन के सामने अपने साथ रहने के लिए चुना। ");
INSERT INTO hin2010_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फ़िरौन ने भाईयों से पूछा, “तुम लोग क्या काम करते हो?” भाईयों ने फ़िरौन से कहा, “मान्यवर, हम लोग चरवाहे हैं। हम लोगों से पहले हमारे पूर्वज भी चरवाहे थे।” ");
INSERT INTO hin2010_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","उन्होंने फ़िरौन से कहा, “कनान में भूखमरी का यह समय बहुत बुरा है। हम लोगों के जानवरों के लिए घास वाला कोई भी खेत बचा नहीं रह गया है। इसलिए हम लोग इस देश में रहने आएं हैं। आपसे हम लोग प्रार्थना करते हैं कि आप कृपा करके हम लोगों को गीशोन प्रदेश में रहने दें।” ");
INSERT INTO hin2010_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","तब फ़िरौन ने यूसुफ से कहा, “तुम्हारे पिता और तुम्हारे भाई तुम्हारे पास आए हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","तुम मिस्र में कोई भी स्थान उनके रहने के लिए चुन सकते हो। अपने पिता और अपने भाईयों को सबसे अच्छी भूमि दी। उन्हें गीशोन प्रदेश में रहने दी और यदि ये कुशल चरवाहे है, तो वे मेरे जानवरों की भी देखभाल कर सकते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","तब यूसुफ ने अपने पिता याकूब को अन्दर फ़िरौन के सामने बुलाया। याकूब ने फिरौन को आशीर्वाद दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","तब फ़िरौन ने याकूब से पूछा, “आपको उम्र क्या है?” ");
INSERT INTO hin2010_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकूब ने फ़िरौन से कहा, “बहुत से कष्टों के साथ मेरा छोटा जीवन रहा। मैं केवल एक सौ तीस वर्ष जीवन बिताया हूँ। मेरे पिता और उनके पिता मुझसे अधिक उम्र तक जीवित रहे।” ");
INSERT INTO hin2010_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","याकूब ने फ़िरौन को आशीर्वाद दिया। तब फिरौन से बिदा लेकर चल दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","यूसुफ ने फ़िरौन का आदेश माना। उसने अपने पिता और भाईयों को मिस्र में भूमि दी। यह रामसेस नगर के निकट मिस्र में सबसे अच्छी भूमि थी। ");
INSERT INTO hin2010_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","यूसुफ ने अपने पिता, भाईयों और उनके अपने लोगों को जो भोजन उन्हें आवश्यक था, दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","भूखमरी का समय और भी अधिक बुरा हो गया। देश में कहीं भी भोजन न रहा। इस बुरे समय के कारण मिस्र और कनान बहुत गरीब हो गए। ");
INSERT INTO hin2010_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","देश में लोग अधिक से अधिक अन्न खरीदने लगे। यूसुफ ने धन बचाया और उसे फ़िरौन के महल में लाया। ");
INSERT INTO hin2010_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","कुछ समय बाद मिस्र और कनान में लोगों के पास पैसा नहीं रहा। उन्होंने अपना सारा धन अन्न खरीदने में खर्च कर दिया। इसलिए लोग यूसुफ के पास गए और बोले, “कृपा कर हमें भोजन दें। हम लोगों का धन समाप्त हो गया। यदि हम लोग नहीं खाएँगे तो आपके देखते—देखते हम मर जायेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","लेकिन यूसुफ ने उत्तर दिया, “अपने पशु मुझे दो और मैं तुम लोगों को भोजन दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","इसलिए लोग अपने पशु, घोड़े और अन्य सभी जानवरों को भोजन खरीदने के लिए उपयोग में लाने लगे और उस वर्ष यूसुफ ने उनके जानवरों को लिया तथा भोजन दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","किन्तु दूसरे वर्ष लोगों के पास जानवर नहीं रह गए और भोजन खरीदने के लिए कुछ भी न रहा। इसलिए लोग यूसुफ के पास गए और बोले, “आप जानते हैं कि हम लोगों के पास धन नहीं बचा है और हमारे सभी जानवर आपके हो गये हैं। इसलिए हम लोगों के पास कुछ नहीं बचा है। वह बचा है केवल, जो आप देखते हैं, हमारा शरीर और हमारी भूमि। ");
INSERT INTO hin2010_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","आपके देखते हुए ही हम निश्चय ही मर जाएँगे। किन्तु यदि आप हमें भोजन देते हैं तो हम फ़िरौन को अपनी भूमि देंगे और उसके दास हो जाएँगे। हमें बीज दो जिन्हें हम बो सकें। तब हम लोग जीवित रहेंगे और मरेंगे नहीं और भूमि हम लोगों के लिए फिर अन्न उगाएगी।” ");
INSERT INTO hin2010_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","इसलिए यूसुफ ने मिस्र की सारी भूमि फ़िरौन के लिए खरीद ली। मिस्र के सभी लोगों ने अपने खेतों को यूसुफ के हाथ बेच दिया। उन्होंने यह इसलिए किया क्योंकि वे बहुत भूखे थे। ");
INSERT INTO hin2010_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","और सभी लोग फ़िरौन के दास हो गए। मिस्र में सर्वत्र लोग फ़िरौन के दास थे। ");
INSERT INTO hin2010_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","एक मात्र वही भूमि यूसुफ ने नहीं खरीदी जो याजकों के अधिकार में थी, क्योंकि फ़िरौन उनके काम के लिए उन्हें वेतन देता था। इसलिए उन्होंने इस धन को खाने के लिए भोजन खरीदने में व्यर्थ किया। ");
INSERT INTO hin2010_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","यूसुफ ने लोगों से कहा, “अब मैंने तुम लोगों की और तुम्हारी भूमि को फ़िरौन के लिए खरीद लिया है। इसलिए मैं तुमको बीज दूँगा और तुम लोग अपने खेतों में पौधे लगा सकते हो। ");
INSERT INTO hin2010_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","फसल काटने के समय तुम लोग फसल का पाँचवाँ हिस्सा फ़िरौन को अवश्य देगा। तुम लोग अपने लिए पाँच में से चार हिस्से रख सकते हो। तुम लोग उस बीज को जिसे भोजन और बोने के लिए रखोगे उसे दूसरे वर्ष उपयोग में ला सकोगे। अब तुम अपने परिवारों और बच्चों को खिला सकते हो।” ");
INSERT INTO hin2010_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","लोगों ने कहा, “आपने हम लोगों का जीवन बचा लिया है। हम लोग आपके और फ़िरौन के दास होने में प्रसन्न हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","इसलिए यूसुफ ने उस समय देश में एक नियम बनाया और वह नियम अब तक चला आ रहा है। नियम के अनुसार भूमि से हर एक उपज का पाँचवाँ हिस्सा फ़िरौन का है। फ़िरौन सारी भूमि का स्वामी हैं। केवल वही भूमि उसकी नहीं है जो याजकों की है। ");
INSERT INTO hin2010_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","इस्राएल (याकूब) मिस्र में रहा। वह गीशेन प्रदेश में रहा। उसका परिवार बढ़ा और बहुत हो गया। उन्होंने मिस्र में उस भूमि को पाया और अच्छा जीवन बिताया। ");
INSERT INTO hin2010_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","याकूब मिस्र में सत्रह वर्ष रहा। इस प्रकार याकूब एक सौ सैंतालीस वर्ष का हो गया। ");
INSERT INTO hin2010_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","वह समय आ गया जब इस्राएल (याकूब) समझ गया कि वह जल्दी ही मरेगा, इसलिए उसने अपने पुत्र यूसुफ को अपने पास बुलाया। उसने कहा, “यदि तुम मुझसे प्रेम करते हो तो तुम अपने हाथ मेरी जांघ के नीचे रख कर मुझे वचन दो। वचन दो कि तुम, जो मैं कहूँगा करोगे और तुम मेरे प्रति सच्चे रहोगे। जब मैं मरूँ तो मुझे मिस्र में मत दफनाना। ");
INSERT INTO hin2010_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","उसी जगह मुझे दफना ना जिस जगह मेरे पूर्वज दफनाए गए हैं। मुझे मिस्र से बाहर ले जाना और मेरे परिवार के कब्रिस्तान में दफनाना।” यूसुफ ने उत्तर दिया, “मैं वचन देता हूँ कि वही करूँगा जो आप कहते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","तब याकूब ने कहा, “मुझसे एक प्रतिज्ञा करो” और यूसुफ ने उससे प्रतिज्ञा की कि वह इसे पूरा करेगा। तब इस्राएल (याकूब) ने अपना सिर पलंग पर पीछे को रखा। ");
INSERT INTO hin2010_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","कुछ समय बाद यूसुफ को पता लगा कि उसका पिता बहुत बीमार हैं। इसलिए यूसुफ ने अपने दोनों पुत्रों मनश्शे और एप्रैम को साथ लिया और अपने पिता के पास गया। ");
INSERT INTO hin2010_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","जब यूसुफ पहुँचा तो किसी ने इस्राएल से कहा, “तुम्हारा पुत्र यूसुफ तुम्हें देखने आया है।” इस्राएल बहुत कमज़ोर था, किन्तु उसने बहुत प्रयत्न किया और पलंग पर बैठ गया। ");
INSERT INTO hin2010_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","तब इस्राएल ने यूसुफ से कहा, “कनान देश में लूज के स्थान पर सर्वशक्तिमान परमेश्वर ने मुझे स्वयं दर्शन दिया। परमेश्वर ने वहाँ मुझे आशीर्वाद दिया। ");
INSERT INTO hin2010_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","परमेश्वर ने मुझसे कहा, ‘मैं तुम्हारा एक बड़ा परिवार बनाऊँगा। मैं तुमको बहुत से बच्चे दूँगा और तुम एक महान राष्ट्र बनोगे। तुम्हारे लोगों का अधिकार इस देश पर सदा बना रहेगा।’ ");
INSERT INTO hin2010_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","और अब तुम्हारे दो पुत्र हैं। मेरे आने से पहले मिस्र देश में यहाँ ये पैदा हुए थे। तुम्हारे दोनों पुत्र एप्रैम और मनश्शे मेरे अपने पुत्रों की तरह होंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","किन्तु यदि तुम्हारे अन्य पुत्र होंगे तो वे तुम्हारे बच्चे होंगे। किन्तु वे भी एप्रैम और मनश्शे का जो कुछ होगा, उसमें हिस्सेदार होंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","पद्दनराम से यात्रा करते समय राहेल मर गई। इस बात ने मुझे बहुत दुःखी किया। वह कनान देश में मरी। हम लोग अभी एप्राता की ओर यात्रा कर रहे थे। मैंने उसे एप्राता की ओर जाने वाली सड़क पर दफनाया।” (एप्राता बैतलेहेम है।) ");
INSERT INTO hin2010_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","तब इस्राएल ने यूसुफ के पुत्रों को देखा। इस्राएल ने पूछा, “ये लड़के कौन हैं?” ");
INSERT INTO hin2010_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","यूसुफ ने अपने पिता से कहा, “ये मेरे पुत्र हैं। ये वे लड़के हैं जिन्हें परमेश्वर ने मुझे दिया है।” इस्राएल ने कहा, “अपने पुत्रों को मेरे पास लाओ। मैं उन्हें आशीर्वाद दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","इस्राएल बूढ़ा था और उसकी आँखें ठीक नहीं थीं। इसलिए यूसुफ अपने पुत्रों को अपने पिता के निकट ले गया। इस्राएल ने बच्चों को चूमा और गले लगाया। ");
INSERT INTO hin2010_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","तब इस्राएल ने यूसुफ से कहा, “मैंने कभी नहीं सोचा कि मैं तुम्हारा मुँह फिर देखूँगा, किन्तु देखो। परमेश्वर ने तुम्हें और तुम्हारे बच्चों को भी मुझे देखने दिया।” ");
INSERT INTO hin2010_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","तब यूसुफ ने बच्चों की इस्राएल की गोद से लिया और वे उसके पिता के सामने प्रणाम करने को झुके। ");
INSERT INTO hin2010_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","यूसुफ ने एप्रैम को अपनी दायीं ओर किया और मनश्शे को अपनी बायीं ओर (इस प्रकार एप्रैम इस्राएल की बायीं ओर था और मनश्शे इस्राएल की दायीं ओर था)। ");
INSERT INTO hin2010_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","किन्तु इस्राएल ने अपने हाथों की दिशा बदलकर अपने दायें हाथ को छोटे लड़के एप्रैम के सिर पर रखा और तब बायें हाथ को इस्राएल ने बड़े लड़के मनश्शे के सिर पर रखा। उसने अपने बायें हाथ को मनश्शे पर रखा, यद्यपि मनश्शे का जन्म पहले हुआ था ");
INSERT INTO hin2010_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","और इस्राएल ने यूसुफ को आशीर्वाद दिया और कहा, “मेरे पूर्वज इब्राहीम और इसहाक ने हमारे परमेश्वर की उपासना की और वही परमेश्वर मेरे पूरे जीवन का पथ—प्रदर्शक रहा है। ");
INSERT INTO hin2010_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","वही दूर रहा जिसने मुझे सभी कष्टों से बचाया और मेरी प्रार्थना है कि इन लड़कों को वह आशीर्वाद दे। अब ये बच्चे मेरा नाम पाएँगे। वे हमारे पूर्वज इब्राहीम और इसहाक का नाम पाएँगे। मैं प्रार्थना करता हूँ कि वे इस धरती पर बड़े परिवार और राष्ट्र बनेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","यूसुफ ने देखा कि उसके पिता ने एप्रैम के सिर पर दायीं हाथ रखा है। वह यूसुफ को प्रसन्न न कर सका। यूसुफ ने अपने पिता के हाथ को पकड़ा। वह उसे एप्रैम के सिर से हटा कर मनश्शे के सिर पर रखना चाहता था। ");
INSERT INTO hin2010_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","यूसुफ ने अपने पिता से कहा, “आपने अपना दायीं हाथ गलत लड़के पर रखा है। मनश्शे का जन्म पहले हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","किन्तु उसके पिता ने तर्क दिया और कहा, “पुत्र, मैं जानता हूँ। मनश्शे का जन्म पहले है और वह महान होगा। वह बहुत से लोगों का पिता भी होगा। किन्तु छोटा भाई बड़े भाई से बड़ा होगा और छोटे भाई का परिवार उससे बहुत बड़ा होगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","इस प्रकार इस्राएल ने उस दिन उन्हें आशीर्वाद दिया। उसने कहा, “इस्राएल के लोग तुम्हारे नाम का प्रयोग आशीर्वाद देने के लिए करेंगे, तुम्हारे कारण कृपा प्राप्त करेंगे। लोग प्रार्थना करेंगे, ‘परमेश्वर तुम्हें एप्रैम और मनश्शे के समान बनायें।’” इस प्रकार इस्राएल ने एप्रैम को मनश्शे से बड़ा बनाया। ");
INSERT INTO hin2010_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","तब इस्राएल ने यूसुफ से कहा, “देखो मेरी मृत्यु का समय निकट आ गया है। किन्तु परमेश्वर तुम्हारे साथ अब भी रहेगा। वह तुम्हें तुम्हारे पूर्वजों के देश तक लौटा ले जायेगा। ");
INSERT INTO hin2010_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","मैंने तुमको ऐसा कुछ दिया है जो तुम्हारे भाईयों को नहीं दिया है। मैं तुमको वह पहाड़ देता हूँ जिसे मैंने एमोरी लोगों से जीता था। उस पहाड़ के लिए मैंने अपनी तलवार और अपने धनुष से युद्ध किया था और मेरी जीत हुई थी।” ");
INSERT INTO hin2010_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","तब याकूब ने अपने सभी पुत्रों को अपने पास बुलाया। उसने कहाँ, “मेरे सभी पुत्रों, यहाँ मेरे पास आओ। मैं तुम्हें बताऊँगा कि भविष्य में क्या होगा। ");
INSERT INTO hin2010_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“याकूब के पुत्रों, एक साथ आओ और सुनो, अपने पिता इस्राएल की सुनो। ");
INSERT INTO hin2010_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“रूबेन, तुम मेरे प्रथम पुत्र हो। तुम मेरे पहले पुत्र और मेरे शक्ति का पहला सबूत हो। तुम मेरे सभी पुत्रों से अधिक गर्वीले और बलवान हो। ");
INSERT INTO hin2010_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","किन्तु तुम बाढ़ की तंरगों की तरह प्रचण्ड हो। तुम मेरे सभी पुत्रों से अधिक महत्व के नहीं हो सकोगे। तुम उस स्त्री के साथ सोए जो तुम्हारे पिता की थी। तुमने अपने पिता के बिछौने की सम्मान नहीं दिया।” ");
INSERT INTO hin2010_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“शिमोन और लेवी भाई हैं। उन्हें अपनी तलवारों से लड़ना प्रिय है। ");
INSERT INTO hin2010_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","उन्होंने गुप्त रूप से बुरी योजनाएँ बनाई। मेरी आत्मा उनकी योजना का कोई अंश नहीं चाहती। मैं उनकी गुप्त बैठकों को स्वीकार नहीं करूँगा। उन्होंने आदमियों की हत्या की जब वे क्रोध में थे और उन्होंने केवल विनोद के लिए जानवरों को चोट पहुँचाई। ");
INSERT INTO hin2010_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","उनका क्रोध एक अभिशाप है। ये अत्याधिक कठोर और अपने पागलपन में क्रुद्ध हैं। याकूब के देश में इनके परिवारों की अपनी भूमि नहीं होगी। वे पूरे इस्राएल में फैलेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“यहूदा, तुम्हारे भाई तुम्हारी प्रशंसा करेंगे। तुम अपने शत्रुओं को हराओगे। तुम्हारे भाई तुम्हारे सामने झुकेंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदा उस शेर की तरह है जिसने किसी जानवर को मारा हो। हे मेरे पुत्र, तुम अपने शिकार पर खड़े शेर के समान हो जो आराम करने के लिए लेटता है, और कोई इतना बहादुर नहीं कि उसे छोड़ दे। ");
INSERT INTO hin2010_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","यहूदा के परिवार के व्यक्ति राजा होंगे। उसके परिवार का राज—चिन्ह उसके परिवार से वास्तविक शासक के आने से पहले समाप्त नहीं होगा। तब अनेकों लोग उसका आदेश मानेंगे और सेवा करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","वह अपने गधे को अँगूर की बेल से बाँधता है। वह अपने गधे के बच्चों को सबसे अच्छी अँगूर की बेलों में बाँधता है। वह अपने वस्त्रों को धोने के लिए सबसे अच्छी दाखमधु का उपयोग करता है। ");
INSERT INTO hin2010_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","उसकी आँखे दाखमधु पीने से लाल रहती है। उसके दाँत दूध पीने से उजले हैं।” ");
INSERT INTO hin2010_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“जबूलून समुद्र के निकट रहेगा। इसका समुद्री तट जहाजों के लिए सुरक्षित होगा। इसका प्रदेश सीदोन तक फैला होगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“इस्साकर उस गधे के समान है जिसने अत्याधिक कठोर काम किया है। वह भारी बोझ ढोने के कारण पस्त पड़ा है। ");
INSERT INTO hin2010_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","वह देखेगा कि उसके आराम की जगह अच्छी है। तथा यह कि उसकी भूमि सुहाबनी है। तब वह भारी बोझे ढोने को तैयार होगा। वह दास के रूप में काम करना स्वीकार करेगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“दान अपने लोगों का न्याय वैसे ही करेगा जैसे इस्राएल के अन्य परिवार करते हैं। ");
INSERT INTO hin2010_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान सड़क के किनारे के साँप के समान है। वह रास्ते के पास लेटे हुए उस भयंकर साँप की तरह है, जो घोड़े के पैर को डसता है, और सवार घोड़े से गिर जाता है। ");
INSERT INTO hin2010_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“यहोवा, मैं उद्धार की प्रतीक्षा कर रहा हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“डाकुओं का एक गिरोह गाद पर आक्रमण करेगा। किन्तु गाद उन्हें मार भगाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“आशेर की भूमि बहुत अच्छी उपज देगी। उसे वही भोजन मिलेगा जो राजाओं के लिए उपयुक्त होगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“नप्ताली स्वतन्त्र दौड़ने वाले हिरण की तरह है और उसकी बोली उनके सुन्दर बच्चों की तरह है।” ");
INSERT INTO hin2010_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“यूसुफ बहुत सफल है। यूसुफ फलों से लदी अंगूर की बेल के समान है। वह सोते के समीप उगी अँगूर की बेल की तरह है, बाड़े के सहारे उगी अँगूर की बेल की तरह है। ");
INSERT INTO hin2010_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","बहुत से लोग उसके विरुद्ध हुए और उससे लड़े। धर्नुधारी लोग उसे पसन्द नहीं करते। ");
INSERT INTO hin2010_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","किन्तु उसने अपने शक्तिशाली धनुष और कुशल भुजाओं से युद्ध जीता। वह याकूब के शक्तिशाली परमेश्वर चरवाहे, इस्राएल की चट्टान से शक्ति पाता है। ");
INSERT INTO hin2010_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","और अपने पिता के परमेश्वर से शक्ति पाता है। “परमेश्वर तुम को आशीर्वाद दे। सर्वशक्तिमान परमेश्वर तुम को आशीर्वाद दे। वह तुम्हें ऊपर आकाश से आशीर्वाद दे और नीचे गहरे समुद्र से आशीर्वाद दे। वह तुम्हें स्तनों और गर्भ का आशीर्वाद दे।” ");
INSERT INTO hin2010_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","मेरे माता—पिता को बहुत सी अच्छी चीजें होती रही और तुम्हारे पिता से मुझको और अधिक आशीर्वाद मिला। तुम्हारे भाईयों ने तुमको बेचना चाहा। किन्तु अब तुम्हें एक ऊँचे पर्वत के समान, मेरे सारे आशीर्वाद का ढेर मिलेगा। ");
INSERT INTO hin2010_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“बिन्यामीन एक ऐसे भूखे भेड़िये के समान है जो सबेरे मारता है और उसे खाता है। शाम को यह बचे खुचे से काम चलाता है।” ");
INSERT INTO hin2010_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ये इस्राएल के बारह परिवार है और वही जीज़ें हैं जिन्हें उनके पिता ने उनसे कहा था। उसने हर एक पुत्र को वह आशीर्वाद दिया जो उसके लिए ठीक था। ");
INSERT INTO hin2010_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","तब इस्राएल ने उनकी एक आदेश दिया। उसने कहा, “जब मैं मरूँ तो मैं अपने लोगों के बीच रहना चाहता हूँ। मैं अपने पूर्वजों के साथ हित्ती एप्रोन के खेतों की गुफा में दफनाया जाना चाहता हूँ। ");
INSERT INTO hin2010_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","वह गुफा मम्रे के निकट मकपेला के खेत में है। वह कनान देश में है। इब्राहीम ने उस खेत को एप्रोम से इसलिए खरीदा था जिससे उसके पास एक कब्रिस्तान हो सके। ");
INSERT INTO hin2010_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","इब्राहीम और उसकी पत्नी सारा उसी गुफा में दफनाए गए हैं। इसहाक और उसकी पत्नी हिबका उसी गुफा में दफनाए गए। मैंने अपनी पत्नी लिआ को उसी गुफा में दफनाया।” ");
INSERT INTO hin2010_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","वह गुफा उस खेत में है जिसे हित्ती लोगों से खरीदा गया था। ");
INSERT INTO hin2010_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","अपने पुत्रों से बातें समाप्त करने के बाद याकूब लेट गया, पैरों को अपने बिछौने पर रखा और मर गया। ");
INSERT INTO hin2010_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","जब इस्राएल मरा, यूसुफ बहुत दुःखी हुआ। वह पिता के गले लिपट गया, उस पर होया और उसे चूमा। ");
INSERT INTO hin2010_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","यूसुफ ने अपने सेवकों को आदेश दिया कि वे उसके पिता के शरीर को तैयार करें (ये सेवक वैद्य थे।) वैद्यों ने याकूब के शरीर को दफनाने के लिए तैयार किया। उन्होंने मिस्री लोगों के विशेष तरीके से खरीर को तैयार किया। ");
INSERT INTO hin2010_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","जब मिस्री लोगों ने विशेष तरह से शव तैयार किया तब उसने दफनाने के पहले चालीस दिन तक प्रतिज्ञा की। उसके बाद मिस्रियों ने याकूब के लिए शोक का विशेष समय रखा। यह समय सत्तर दिन का था। ");
INSERT INTO hin2010_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","सत्तर दिन बाद शोक का समय समाप्त हुआ। इसलिए यूसुफ ने फ़िरौन के अधिकारियों से कहा, “कृपया फ़िरौन से वह कहो, ");
INSERT INTO hin2010_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘जब मेरे पिता मर रहे थे तब मैंने उनसे एक प्रतिज्ञा की थी। मैंने प्रतिज्ञा की थी कि मैं उन्हें कनान देश की गुफा में दफनाऊँगा। यह वह गुफा है जिसे उन्होंने अपने लिए बनाई है। इसलिए कृपा करके मुझे जाने दें और वहाँ पिता की दफनाने दें। तब मैं आपके पास वापस यहाँ लौट आऊँगा।’” ");
INSERT INTO hin2010_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","फ़िरौन ने कहा, “अपनी प्रतिज्ञा पूरी करो। जाओ और अपने पिता को दफनाओ।” ");
INSERT INTO hin2010_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","इसलिए यूसुफ अपने पिता की दफनाने गया। फ़िरौन के सभी अधिकारी यूसुफ के साथ गए। फ़िरौन के बड़े लोग (नेता) और मिस्र के बड़े लोग यूसुफ के साथ गए। ");
INSERT INTO hin2010_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","यूसुफ और उसके भाईयों के परिवार के सभी व्यक्ति उसके साथ गए और उसके पिता के परिवार के सभी लोग भी यूसुफ के साथ गए। केव बच्चे और जानवर गीशोन प्रदेश में रह गए। ");
INSERT INTO hin2010_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","यूसुफ के साथ जाने के लिए लोग रथों और घोड़ो पर सवार हुए। यह बहुत बढ़ा जनसमूह था। ");
INSERT INTO hin2010_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","वे गोरन आताद को गए। जो यरदन नदी के पूर्व में था। इस स्थान पर इन्होंने इस्राएल का अन्तिम संस्कार किया। वे अन्तिम संस्कार सात दिन तक होता रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","कनान के निवासियों ने गोरन आताद में अन्तिम संस्कार को देखा। उन्होंने कहा, “वे मिस्री सचमुच बहुत शोक भरा संस्कार कर रहे है।” इसलिए उस जगह का नाम अब आबेल मिस्रैम है। ");
INSERT INTO hin2010_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","इस प्रकार याकूब के पुत्रों ने वही किया जो उनके पिता ने आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","वे उसके शव को कनान ले गए और मकपेला की गुफा में उसे दफनाया। यह गुफा मम्रे के निकट उस खेत में थी जिसे इब्राहीम ने हित्ती एप्रोन से खरीदा था। ");
INSERT INTO hin2010_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","यूसुफ ने जब अपने पिता को दफना दिया तो वह और उसके साथ समूह का हर एक व्यक्ति मिस्र को लौट गया। ");
INSERT INTO hin2010_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","याकूब के मरने के बाद यूसुफ के भाई चितिंत हुए। वे डर रहे थे कि उन्होंने जो कुछ पहले किया था उसके लिए यूसुफ अब भी उनसे क्रोध में पागल होगा। उन्होंने कहा, “क्या जो कुछ हम ने किया उसके लिए यूसुफ अब भी हम से घृणा करता है?” ");
INSERT INTO hin2010_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","इसलिए भाईयों ने वह सन्देश यूसुफ को भेजा: “तुम्हारे पिता ने मरने के पहले हम लोगों को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","उसने कहा, ‘युसुफ से कहना कि मैं निवेदन करता हूँ कि कृपा कर वह उस अपराध को क्षमा कर दे जो उन्होंने उसके साथ किया।’ इसलिए अब हम तुमसे प्रार्थना करते हैं कि उस अपराध को क्षमा कर दो जो हम ने किया। हम लोग केवल तुम्हारे पिता के परमेश्वर के सेवक हैं।” यूसुफ के भाईयों ने कुछ कहा उससे उसे बड़ा दुःख हुआ और वह रो पड़ा। ");
INSERT INTO hin2010_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","यूसुफ के भाई उसके सामने गए और उसके सामने झुककर प्रणाम किया। उन्होंने कहा, “हम लोग तुम्हारे सेवक होंगे।” ");
INSERT INTO hin2010_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","तब यूसुफ ने उनसे कहा, “डरो नहीं मैं परमेश्वर नहीं हूँ। ");
INSERT INTO hin2010_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","तुम लोगों ने मेरे साथ जो कुछ बुरा करने की योजना बनाई थी। किन्तु परमेश्वर सचमुच अच्छी योजना बना रहा था। परमेश्वर की योजना बहुत से लोगों का जीवन बचाने के लिए मेरा उपयोग करने की थी और आज भी उसकी यही योजना है। ");
INSERT INTO hin2010_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","इसलिए डरो नहीं। मैं तुम लोगों और तुम्हारे बच्चों की देखभाल करूँगा।” इस प्रकार यूसुफ ने उन्हें सान्त्वना दी और उनसे कोमलता से बातें की। ");
INSERT INTO hin2010_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","यूसुफ अपने पिता के परिवार के साथ मिस्र में रहता रहा। यूसुफ एक सौ दस वर्ष का होकर मरा। ");
INSERT INTO hin2010_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","यूसुफ के जीवन काल में एप्रैम के पुत्र और पौत्र हुए और उसके पुत्र मनश्शे का एक पुत्र माकीर नाम का हुआ। यूसुफ माकीर के बच्चों को देखने के लिए जीवित रहा। ");
INSERT INTO hin2010_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","जब यूसुफ मरने को हुआ, उसने अपने भाईयों से कहा, “मेरे मरने का समय आ गया। किन्तु मैं जानता हूँ कि परमेश्वर तुम लोगों की रक्षा करेगा। वह इस देश से तुम लोगों को बाहर ले जाएगा। परमेश्वर तुम लोगों को उस देश में ले जाएगा जिसे उसने इब्राहीम, इसहाक और याकूब को देने का वचन दिया था।” ");
INSERT INTO hin2010_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","तब यूसुफ ने अपने लोगों से एक प्रतिज्ञा करने को कहा। यूसुफ ने कहा, “मुझ से प्रतिज्ञा करो कि तब मेरी अस्थियों अपने साथ ले जाओगे जब परमेश्वर तुम लोगों को नए देश में ले जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","यूसुफ मिस्र में मरा, जब यह एक सौ दस वर्ष का था। वैद्यों ने उसके शव को दफनाने के लिए तैयार किया और मिस्र में उसके शव को एक डिव्वे में रखा। ");
INSERT INTO hin2010_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","याकूब (इस्राएल) ने अपने पुत्रों के साथ मिस्र की यात्रा की थी, और हर एक पुत्र के साथ उसका अपना परिवार था। इस्राएल के पुत्रों के नाम है: ");
INSERT INTO hin2010_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रूबेन, शिमोन, लेवी, यहूदा, ");
INSERT INTO hin2010_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साकर, जबूलून, बिन्यामीन, ");
INSERT INTO hin2010_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नप्ताली, गाद, आशेर। ");
INSERT INTO hin2010_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","याकूब के अपने वंश में सत्तर लोग थे। उसके बारह पुत्रों में एक यूसुफ पहले से ही मिस्र में था। ");
INSERT INTO hin2010_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","बाद में यूसुफ उसके भाई और उसकी पीढ़ी के सभी लोग मर गए। ");
INSERT INTO hin2010_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","किन्तु इस्राएल के लोगों की बहुत सन्तानें थी, और उनकी संख्या बढ़ती ही गई। ये लोग शक्तिशाली हो गए और इन्हीं लोगों से मिस्र भर गया था। ");
INSERT INTO hin2010_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","तब एक नया राजा मिस्र पर शासन करने लगा। यह व्यक्ति यूसुफ को नहीं जानता था। ");
INSERT INTO hin2010_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","इस राजा ने अपने लोगों से कहा, “इस्राएल के लोगों को देखो, इनकी संख्या अत्याधिक है, और हम लोगों से अधिक शक्तिशाली है। ");
INSERT INTO hin2010_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","हम लोगों को निश्चय ही इनके बिरुद्ध योजना बनानी चाहिए। यदि हम लोग ऐसा नहीं करते तो हो सकता है, कि कोई युद्ध छिड़े और इस्राएल के लोग हमारे शत्रुओं का साथ देने लगे। तब वे हम लोगों को हरा सकते हैं और हम लोगों के हाथों से निकल सकते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","मिस्र के लोग इस्राएल के लोगों का जीवन कठिन बनाना चाहते थे। इसलिए उन्होंने इस्राएल के लोगों पर दास—स्वामी नियुक्त किए। उन स्वामियों ने फ़िरौन के लिए पितोम और रामसेस नगरों को बनाने के लिए इस्राएली लोगों को विवश किया। उन्होंने इन नगरों में अन्न तथा अन्य चीज़ें इकट्ठी कीं। ");
INSERT INTO hin2010_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","मिस्री लोगों ने इस्राएल के लोगों को कठिन से कठिन काम करने को विवश किया। किन्तु जितना अधिक काम करने के लिए इस्राएली लोगों को विवश किया गया उनकी संख्या उतनी ही बढ़ती चली गई और मिस्री लोग इस्राएली लोगों से अधिकाधिक भयभीत होते गए। ");
INSERT INTO hin2010_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","इसलिए मिस्र के लोगों ने इस्राएली लोगों को और भी अधिक कठिन काम करने को विवश किया। ");
INSERT INTO hin2010_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","मिस्री लोगों ने इस्राएली लोगों का जीवन दूभर कर दिया। उन्होंने इस्राएली लोगों को ईंट—गारा बनाने का बहुत कड़ा काम करने के लिए विवश किया। उन्होंने उन्हें खेतों में भी बहुत कड़ा काम करने को विवश किया। वे जो कुछ करते थे उन्हें कठिन परिश्रम के साथ करने को विवश किया। ");
INSERT INTO hin2010_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","वहाँ शिप्रा और पूआ नाम की दो धाइयाँ थीं। ये धाइयाँ इस्राएली स्त्रियों के बच्चों का जन्म देने में सहायता करती थी। मिस्र के राजा ने धाइयों से बातचीत की। ");
INSERT INTO hin2010_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","राजा ने कहा, “तुम हिब्रू स्त्रियों को बच्चा जनने में सहायता करती रहोगी। यदि लड़की पैदा हो तो उसे जीवित रहने दो किन्तु यदि लड़का पैदा हो तो तुम लोग उसे मार डालो।” ");
INSERT INTO hin2010_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","किन्तु धाइयों ने परमेश्वर पर विश्वास? किया। इसलिए उन्होंने मिस्र के राजा के आदेश का पालन नहीं किया। उन्होंने सभी लड़कों को जीवित रहने दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","मिस्र के राजा ने धाइयों को बुलाया और कहा, “तुम लोगों ने ऐसा क्यों किया? तुम लोगों ने पुत्रों (लड़कों) को क्यों जीवित रहने दिया?” ");
INSERT INTO hin2010_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","धाइयों ने फ़िरौन से कहा, “हिब्रू स्त्रियाँ मिस्री स्त्रियों से अधिक बलवान हैं। उनकी सहायता के लिए हम लोगों के पहुँचने से पहले ही वे बच्चों को जन्म दे देती हैं।” ");
INSERT INTO hin2010_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","परमेश्वर धाइयों पर कृपालु था क्योंकि वे परमेश्वर से डरती थीं। इसलिए परमेश्वर उनके लिए अच्छा रहा और उन्हें अपने परिवार बनाने दिया और हिब्रू लोग अधिक बच्चे उत्पन्न करते रहे और वे बहुत शक्तिशाली हो गए। ");
INSERT INTO hin2010_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","इसलिए फ़िरौन ने अपने सभी लोगों को यह आदेश दिया, “जब कभी पुत्र पैदा हो तब तुम अवश्य ही उसे नील नदी में फेंक दो। किन्तु सभी पुत्रियों को जीवित रहने दो।” ");
INSERT INTO hin2010_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","लेवी के परिवार का एक व्यक्ति वहाँ था। उसने लेवी के परिवार की ही एक स्त्री से विवाह किया। ");
INSERT INTO hin2010_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","वह स्त्री गर्भवती हुई और उसने एक पुत्र को जन्म दिया। माँ ने देखा कि बच्चा अत्याधिक सुन्दर है और उसने उसे तीन महीने तक छिपाए रखा। ");
INSERT INTO hin2010_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","किन्तु तीन महीने बाद माँ डरी कि बच्चा ढूँढ लिया जाएगा। तब वह मार डाला जाएगा, क्योंकि वह लड़का है। इसलिए उसने एक टोकरी बनाई और उस पर तारकोल का लेप इस प्रकार किया कि वह तैर सके। उसने बच्चे को टोकरी में रख दिया। तब उसने टोकरी को नदी के किनारे लम्बी घास में रख दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","बच्चे की बहन वहाँ रूकी और उसकी रखवाली करती रही। वह देखना चाहती थी कि बच्चे के साथ क्या घटित होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","उसी समय फ़िरौन की पुत्री नहाने के लिए नदी को गई। उसकी सखियाँ नदी के किनारे टहल रही थी। उसने ऊँची घास में टोकरी देखी। उसने अपनी दासियों में से एक को जाकर उसे लाने को कहा। ");
INSERT INTO hin2010_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","राजा की पुत्री ने टोकरी को खोला और लड़के को देखा। बच्चा रो रहा था और उसे उस पर दया आ गई। उसने कहा, यह हिब्रू बच्चों में से एक है। ");
INSERT INTO hin2010_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","बच्चे की बहन अभी तक छिपी थी। तब वह खड़ी हुई और फ़िरौन की पुत्री से बोली, “क्या आप चाहती है कि मैं बच्चे की देखभाल करने में आपकी सहायता के लिए एक हिब्रू स्त्री जाकर ढूँढ लाऊँ?।” ");
INSERT INTO hin2010_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फ़िरौन की पुत्री ने कहा, “धन्यवाद हो।” इसलिए लड़की गई और बच्चे की अपनी माँ की ढूँढ लाई। ");
INSERT INTO hin2010_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फ़िरौन की पुत्री ने कहा, “इस बच्चे को ले जाओ और मेरे लिए इसे पालो। इस बच्चे को अपना दूध पिलाओ मैं तुम्हें वेतन दूँगी।” सो उस स्त्री ने अपने बच्चे को ले लिया और उसका पालन पोषन किया। ");
INSERT INTO hin2010_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","बच्चा बड़ा हुआ और कुछ समय बाद वह स्त्री उस बच्चे को फ़िरौन की पुत्री के पास लाई। फ़िरौन की पुत्री ने अपने पुत्र के रूप में उस बच्चे को अपना लिया। फ़िरौन की पुत्री ने उसका नाम मूसा रखा। क्योंकि उसने उसे पानी से निकाला था। ");
INSERT INTO hin2010_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","मूसा बड़ा हुआ और युवक हो गया। उसने देखा कि उसके हिब्रू लोग अत्यन्त कठिन काम करने के लिए विवश किए जा रहे हैं। एक दिन मूसा ने एक मिस्री व्यक्ति द्वारा एक हिब्रू व्यक्ति को पिटते देखा। ");
INSERT INTO hin2010_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","इसलिए मूसा ने चारों ओर नजर घुमाई और देखा कि कोई देख नहीं रहा है। सो मूसा ने मिस्री को मार डाला और उसे रेत में छिपा दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","अगले दिन मूसा ने दो हिब्रू व्यक्तियों को परस्पर लड़ते देखा। मूसा ने देखा कि एक व्यक्ति गलती पर था। मूसा ने उस आदमी से कहा, “तुम अपने पड़ोसी को क्यों मार रहे हो?” ");
INSERT INTO hin2010_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","उस व्यक्ति ने उत्तर दिया, “क्या किसी ने कहा है कि तुम हमारे शासक और न्यायाधीश बनो? नहीं। मुझे बताओ कि क्या तुम मुझे भी उसी प्रकार मार डालोगे जिस प्रकार तुमने कल मिस्री को मार डाला?” तब मूसा डरा। मूसा ने मन ही मन सोचा, “अब हर एक व्यक्ति जानता है कि मैंने क्या किया है?” ");
INSERT INTO hin2010_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","फ़िरौन ने सुना कि मूसा ने मिस्री की हत्या की है। मूसा ने जो कुछ किया फ़िरौन ने उसके बारे में सुना, इसलिए उसने मूसा को मार डालने का निश्चय किया। किन्तु मूसा फिरौन की पकड़ से निकल भागा। मूसा मिद्यान देश में गया। उस प्रदेश में मूसा एक कुएँ के समीप रूका। ");
INSERT INTO hin2010_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","द्यान में एक याजक था जिसकी सात पुत्रियाँ थीं। एक दिन उसकी पुत्रियाँ अपने पिता की भेड़ों के लिए पानी लेने उसी कुएँ पर गई। वे कठौती को पानी से भरने का प्रयत्न कर रही थीं। ");
INSERT INTO hin2010_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","किन्तु कुछ चरवाहों ने उन लड़कियों को भगा दिया और पानी नहीं लेने दिया। इसलिए मूसा ने लड़कियों की सहायता की और उनके जानवरों को पानी दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","तब वे अपने पिता रुएल के पास लौट गई। उनके पिता ने उनसे पूछा, “आज तुम लोग क्यों जल्दी घर चली आई?” ");
INSERT INTO hin2010_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","लड़कियों ने उत्तर दिया, “चरवाहों ने हम लोगों को भगाना चाहा। किन्तु एक मिस्री व्यक्ति ने हम लोगों की सहायता की। उसने हम लोगों के लिए पानी निकाला और हम लोगों के जानवरों को दिया।” ");
INSERT INTO hin2010_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","इसलिए रुएल ने अपनी पुत्रियों से कहा, “यह व्यक्ति कहाँ है? तुम लोगों ने उसे छोड़ा क्यों? उसे यहाँ बुलाओ और हम लोगों के साथ उसे भोजन करने दो।” ");
INSERT INTO hin2010_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","मूसा उस आदमी के साथ ठहरने से प्रसन्न हुआ। और उस आदमी ने अपनी पुत्री सिप्पोरा को मूसा की पत्नी के रूप में उसे दे दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","सिप्पोरा ने एक पुत्र को जन्म दिया। मूसा ने अपने पुत्र का नाम गेर्शोम रखा। मूसा ने अपने पुत्र को यह नाम इसलिए दिया कि वह उस देश में अजनबी था जो उसका अपना नहीं था। ");
INSERT INTO hin2010_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","लम्बा समय बीता और मिस्र का राजा मर गया। इस्राएली लोगों को जब भी कठिन परिश्रम करने के लिए विवश किया जाता था। वे सहायता के लिए पुकारते थे। और परमेशवर ने उनकी पुकार सुनी। ");
INSERT INTO hin2010_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","परमेश्वर ने उनकी प्रार्थनाएँ सुनीं और उस वाचा को याद किया जो उसने इब्राहीम, इसहाक और याकूब के साथ की थी। ");
INSERT INTO hin2010_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","परमेश्वर ने इस्राएली लोगों के कष्टों को देखा और उसने सोचा कि वे शीघ्र ही उनकी सहायता करेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","मूसा के ससुर का नाम यित्रो था। यित्रो मिद्यान का याजक था। मूसा यित्रो की भेड़ों का चरवाहा था। एक दिन मूसा भेड़ों को मरुभूमि के पश्चिम की ओर ले गया। मूसा होरेब नाम के उस एक पहाड़ को गया, जो परमेश्वर का पहाड़ था। ");
INSERT INTO hin2010_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","मूसा ने उस पहाड़ पर यहोवा के दूत को एक जलती हुई झाड़ी में देखा। यह इस प्रकार घटित हुआ। मूसा ने एक झाड़ी को जलते हुए देखा जो भस्म नहीं हो रही थी। ");
INSERT INTO hin2010_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","इसलिए मूसा ने कहा कि मैं झाड़ी के निकट जाऊँगा और देखूँगा कि बिना राख हुए कोई झाड़ी कैसे जलती रह सकती है। ");
INSERT INTO hin2010_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","यहोवा ने देखा कि मूसा झाड़ी को देखने आ रहा है। इसलिए परमेश्वर ने झाड़ी से मूसा को पुकारा। उसने कहा, “मूसा, मूसा।” और मूसा ने कहा, “हाँ, यहोवा।” ");
INSERT INTO hin2010_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","तब यहोवा ने कहा, “निकट मत आओ। अपनी जूतियाँ उतार लो। तुम पवित्र भूमि पर खड़े हो। ");
INSERT INTO hin2010_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","मैं तुम्हारे पूर्वजों का परमेश्वर हूँ। मैं इब्राहीम का परमेश्वर हसहाक का परमेश्वर तथा याकूब का परमेश्वर हूँ।” मूसा ने अपना मूँह ढक लिया क्योंकि वह परमेश्वर को देखने से डरता था। ");
INSERT INTO hin2010_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","तब यहोवा ने कहा, “मैंने उन कष्टों को देखा है जिन्हें मिस्र में हमारे लोगों ने सहा है और मैंने उनका रोना भी सुना है जब मिस्री लोग उन्हें चोट पहुँचाते हैं। मैं उनकी पीड़ा के बारे में जानता हूँ। ");
INSERT INTO hin2010_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","मैं अब जाऊँगा और मिस्रियों से अपने लोगों को बचाऊँगा। मैं उन्हें उस देश से निकालूँगा और उन्हें मैं एक अच्छे देश में ले जाऊँगा जहाँ वे कष्टों से मुक्त हो सकेंगे। जो अनेक अच्छी चीजों से भरा पड़ा है। उस प्रदेश में विभिन्न लोग रहते हैं। कनानी, हित्ती, एमोरी, परिज्जी हिब्बी और यबूसी। ");
INSERT INTO hin2010_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","मैंने इस्राएल के लोगों की पुकार सुनी है। मैंने देखा है कि मिस्रियों ने किस तरह उनके लिए जीवन को कठिन कर दिया है। ");
INSERT INTO hin2010_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","इसलिए अब मैं तुमको फ़िरौन के पास भेज रहा हूँ। जाओ! मेरे लोगों अर्थात् इस्राएल के लोगों को मिस्र से बाहर लाओ।” ");
INSERT INTO hin2010_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","किन्तु मूसा ने परमेश्वर से कहा, “मैं कोई महत्वपूर्ण आदमी नहीं हूँ। मैं ही वह व्यक्ति क्यों हूँ जो फ़िरौन के पास जाए और इस्राएल के लोगों को मिस्र के बाहर निकाल कर ले चले?” ");
INSERT INTO hin2010_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","परमेश्वर ने कहा, “क्योंकि मैं तुम्हारे साथ रहूँगा। मैं तुमको भेज रहा हूँ, यह प्रमाण होगा: लोगों को मिस्र के बाहर निकाल लाने के बाद तुम आओगे और इस पर्वत पर मेरी उपासना करोगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","तब मूसा ने परमेश्वर से कहा, “किन्तु यदि मैं इस्राएल के लोगों के पास जाऊँगा और उनसे कहूँगा, ‘तुम लोगों के पूर्वजों के परमेश्वर ने मुझे तुम लोगों के पास भेजा है,’ ‘तब लोग पूछेंगे, उसका क्या नाम है?’ मैं उनसे क्या कहूँगा?” ");
INSERT INTO hin2010_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","तब परमेश्वर ने मूसा से कहा, “उनसे कहो, ‘मैं जो हूँ सो हूँ।’ जब तुम इस्राएल के लोगों के पास जाओ, तो उनसे कहो, ‘मैं हूँ’ जिसने मुझे तुम लोगों के पास भेजा है।” ");
INSERT INTO hin2010_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","परमेश्वर ने मूसा से यह भी कहा, “लोगों से तुम जो कहोगे वह यह है कि: ‘यहोवा तुम्हारे पूर्वजों का परमेश्वर, इब्राहीम का परमेश्वर, इसहाक का परमेश्वर और याकूब का परमेश्वर है। मेरा नाम सदा यहोवा रहेगा। इसी रूप में लोग आगे पीढ़ी दर पीढ़ी मुझे जानेंगे।’ लोगों से कहो, ‘यहोवा ने मुझे तुम्हारे पास भेजा है।’” ");
INSERT INTO hin2010_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“यहोवा ने यह भी कहा, ‘जाओ और इस्राएल के बुजुर्गों (नेताओं) को इकट्ठा करो और उनसे कहो, तुम्हारे, पूर्वजों का परमेश्वर यहोवा, मेरे सामने प्रकट हुआ। इब्राहीम, इसहाक और याकूब के परमेश्वर ने मुझसे बातें कीं।’ यहोवा ने कहा है: ‘मैंने तुम लोगों के बारे में सोचा है और उस सबके बारे में भी जो तुम लोगों के साथ मिस्र में घटित हुआ है। ");
INSERT INTO hin2010_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","मैंने निश्चय किया है कि मिस्र में तुम लोग जो कष्ट सह रहे हो उससे तुम्हें बारह निकालूँ। मैं तुम लोगों को उस देश में ले चलूँगा जो अनेक लोगों अर्थात् कनानी, हित्ती, एमोरी, परिज्जी, हिब्बी और यबूसी का है। मैं तुम लोगों को ऐसे अच्छे देश को ले जाऊँगा जो बहुत अच्छी चीज़ों से भरा पूरा है।’ ");
INSERT INTO hin2010_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“बुज़ुर्ग (नेता) तुम्हारी बातें सुनेंगे और तब तुम और बुजुर्ग (नेता) मिस्र के राजा के पास जाओगे। तुम उससे कहोगे ‘हिब्रू लोगों का परमेश्वर यहोवा है। हमारा परमेश्वर हम लोगों के पास आया था। उसने हम लोगों से तीन दिन तक मरूभूमि में यात्रा करने के लिए कहा है। वहाँ हम लोग अपने परमेश्वर यहोवा को निश्चय ही बलियाँ चढ़ायेंगे।’ ");
INSERT INTO hin2010_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“किन्तु मैं जानता हूँ कि मिस्र का राजा तुम लोगों को जाने नहीं देगा। केवल एक महान शक्ति ही तुम लोगों को जाने देने के लिए उसे विवश करेगी। ");
INSERT INTO hin2010_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","इसलिए मैं अपनी महान शक्ति का उपयोग मिस्र के विरुद्ध करूँगा। मैं उस देश में चमत्कार होने दूँगा। जब मैं ऐसा करूँगा तो वह तुम लोगों को जाने देगा। ");
INSERT INTO hin2010_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","और मैं मिस्री लोगों को इस्राएली लोगों के प्रति कृपालु बनाऊँगा। इसलिए जब तुम लोग विदा होंगे तो वे तुम्हें भेंट देंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","“हर एक हिब्रू स्त्री अपने मिस्री पड़ोसी से तथा अपने घर में रहने वालों से मांगेगी और वे लोग उसे भेंट देंगे। तुम्हारे लोग भेंट में चाँदी, सोना और सुन्दर वस्त्र पाएंगे। जब तुम लोग मिस्र को छोड़ोगे तुम लोग उन भेंटों को अपने बच्चों को पहनाओगे। इस प्रकार तुम लोग मिस्रियों का धन ले आओगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","तब मूसा ने परमेश्वर से कहा, “किन्तु इस्राएल के लोग मुझ पर विश्वास नहीं करेंगे जब मैं उनसे कहूँगा कि तूने मुझे भेजा है। वे कहेंगे, ‘यहोवा ने तुमसे बातें नहीं कीं।’” ");
INSERT INTO hin2010_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","किन्तु परमेश्वर ने मूसा से कहा, “तुमने अपने हाथ में क्या ले रखा है?” मूसा ने उत्तर दिया, “यह मेरी टहलने की लाठी है।” ");
INSERT INTO hin2010_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","तब परमेश्वर ने कहा, “अपनी लाठी को जमीन पर फेंको।” इसलिए मूसा ने अपनी लाठी को जमीन पर फेंका और लाठी एक साँप बन गया। मूसा डरा और इससे दूर भागा। ");
INSERT INTO hin2010_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","किन्तु यहोवा ने मूसा से कहा, “आगे बढ़ो और साँप की पूँछ पकड़ लो।” इसलिए मूसा आगे बढ़ा और उसने साँप की पूँछ पकड़ लिया। जब मूसा ने ऐसा किया तो साँप फिर लाठी बन गया। ");
INSERT INTO hin2010_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","तब परमेश्वर ने कहा, “अपनी लाठी का इसी प्रकार उपयोग करो और लोग विश्वास करेंगे कि तुमने यहोवा अर्थात् अपने पूर्वजों के परमेश्वर, इब्राहीम के परमेश्वर, इसहाक के परमेश्वर तथा याकूब के परमेश्वर को देखा है।” ");
INSERT INTO hin2010_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","तब यहोवा ने मूसा से कहा, “मैं तुमको दूसरा प्रमाण दूँगा। तुम अपने हाथ को अपने लबादे के अन्दर करो।” इसलिए मूसा ने अपने लबादे को खोला और हाथ को अन्दर किया। तब मूसा ने अपने हाथ को लबादे से बाहर निकाला और वह बदला हुआ था। उसका हाथ बर्फ की तरह सफेद दागों से ढका था। ");
INSERT INTO hin2010_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","तब परमेश्वर ने कहा, “अब तुम अपना हाथ फिर लबादे के भीतर रखो।” इसलिए मूसा ने अपना हाथ अपने लबादे के भीतर फिर किया। तब मूसा ने अपना हाथ बाहर निकाला और उसका हाथ बदल गया था। अब उसका हाथ पहले की तरह ठीक हो गया था। ");
INSERT INTO hin2010_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","तब परमेश्वर ने कहा, “यदि लोग तुम्हारा विश्वास लाठी का उपयोग करने पर न करें, तो वे तुम पर तब विश्वास करेंगे जब तुम इस चिन्ह को दिखाओगे। ");
INSERT INTO hin2010_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","यदि वे दोनों चीजों को दिखाने के बाद भी विश्वास न करें तो तुम नील नदी से कुछ पानी लेना। पानी को ज़मीन पर गिराना शुरु करना और ज्योही यह ज़मीन को छूएगा, खून बन जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","किन्तु मूसा ने यहोवा से कहा, “किन्तु हे यहोवा, मैं सच कहता हूँ मैं कुशल वक्ता नहीं हूँ। मैं लोगों से कुशलतापूर्वक बात करने के योग्य नहीं हुआ और अब तुझ से बातचीत करने के बाद भी मैं कुशल वक्ता नहीं हूँ। तू जानता हैं कि मैं धीरे—धीरे बोलता हूँ और उत्तम शब्दों का उपयोग नहीं करता।” ");
INSERT INTO hin2010_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","तब यहोवा ने उससे कहा, “मनुष्य का मुँह किसने बनाया? और एक व्यक्ति को कौन बोलने और सुनने में असमर्थ बना सकता है? मनुष्य को कौन देखनेवाला और अन्धा बना सकता है? यह मैं हूँ जो इन सभी चीजों को कर सकता हूँ। मैं यहोवा हूँ। ");
INSERT INTO hin2010_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","इसलिए जाओ। जब तुम बोलोगे, मैं तुम्हारे साथ रहूँगा। मैं तुम्हें बोलने के लिए शब्द दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","किन्तु मूसा ने कहा, “मेरे यहोवा, मैं दूसरे व्यक्ति को भेजने के लिए प्रार्थना करता हूँ मुझे न भेज।” ");
INSERT INTO hin2010_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","यहोवा मूसा पर क्रुद्ध हुआ। यहोवा ने कहा, “मैं तुमको सहायता के लिए एक व्यक्ति दूँगा। मैं तुम्हारे भाई हारून का उपयोग करूँगा। वह कुशल वक्ता है। हारून पहले ही तुम्हारे पास आ रहा था। वह तुमको देखकर बहुत प्रसन्न होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","वह तुम्हारे साथ फ़िरौन के पास जाएगा। मैं तुम्हें बताऊँगा कि तुम्हें क्या कहना है। तब तुम हारून को बताओगे। हारून फ़िरौन से कहने के लिए उचित शब्द चुनेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","हारून ही तुम्हारे लिए लोगों से बात करेगा। तुम उसके लिए महान राजा के रूप में रहोगे और वह तुम्हारा अधिकृत वक्ता होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","इसलिए जाओं और अपनी लाठी साथ ले जाओ। अपनी लाठी और दूसरे चमत्कारों का उपयोग लोगों को यह दिखाने के लिए करो कि मैं तुम्हारे साथ हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","तब मूसा अपने ससुर यित्रो के पास लौटा। मूसा ने यित्रो से कहा, “मैं आपसे प्रार्थना करता हूँ कि मुझे मिस्र में अपने लोगों के पास जाने दे। मैं यह देखना चाहता हूँ कि क्या वे अभी तक जीवित हैं।” यित्रो ने मूसा से कहा, “तुम शान्तिपूर्वक जा सकते हो।” ");
INSERT INTO hin2010_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","उस समय जब मूसा मिद्यान में ही था, परमेश्वर ने उससे कहा, “इस समय तुम्हारे लिए मिस्र को जाना सुरक्षित है। जो व्यक्ति तुमको मारना चाहते थे वे मर चुके हैं।” ");
INSERT INTO hin2010_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","इसलिए मूसा ने अपनी पत्नी और अपने पुत्रों को लिया और उन्हें गधे पर बिठाया। तब मूसा ने मिस्र देश की वापसी यात्रा की। मूसा उस लाठी को अपने साथ ले गया जिसमें परमेश्वर की शक्ति थी। ");
INSERT INTO hin2010_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","जिस समय मूसा मिस्र की वापसी यात्रा पर था, परमेश्वर उससे बोला। परमेश्वर ने कहा, “जब तुम फ़िरौन से बात करो तो उन सभी चमत्कारों को दिखाना। याद रखना जिन्हें दिखाने की शक्ति मैंने तुम्हें दी है। किन्तु फ़िरौन को मैं बहुत हठी बना दूँगा। वह लोगों को जाने नहीं देगा। ");
INSERT INTO hin2010_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","तब तुम फ़िरौन से कहना: ");
INSERT INTO hin2010_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","यहोवा कहता है, ‘इस्राएल मेरा पहलौठा पुत्र है और मैं तुम से कहता हूँ कि मेरे पुत्र को जाने दो तथा मेरी उपासना करने दो। यदि तुम इस्राएल को जाने से मना करते हो तो मैं तुम्हारे पहलौठे पुत्र को मार डालूँगा।’” ");
INSERT INTO hin2010_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","मूसा मिस्र की अपनी यात्रा करता रहा। यात्रियों के लिए बने एक स्थान पर वह सोने के लिए रूका। यहोवा इस स्थान पर मूसा से मिला और उसे मार डालने को कोशिश की। ");
INSERT INTO hin2010_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","किन्तु सिप्पोरा ने पत्थर का एक तेज़ चाकू लिया और अपने पुत्र का खतना किया। उसने चमड़े को लिया और उसके पैर छुए। तब उसने मूसा से कहा, “तुम मेरे खून बहाने वाले पति हो।” ");
INSERT INTO hin2010_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","सिप्पोरा ने यह इसलिए कहा कि उसे अपने पुत्र का खतना करना पड़ा था। इसलिए परमेश्वर ने मूसा को क्षमा किया और उसे मारा नहीं। ");
INSERT INTO hin2010_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","यहोवा ने हारून से बात की थी। यहोवा ने उससे कहा था, “मरूभूमि में जाओ और मूसा से मिलो।” इसलिए हारून गया और परमेश्वर के पहाड़ पर मूसा से मिला। जब हारून ने मूसा को देखा, उसने उसे चूमा। ");
INSERT INTO hin2010_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","मूसा ने हारून को यहोवा द्वारा भेजे जाने का कारण बताया और मूसा ने हारून को उन चमत्कारों और उन संकेतों को भी समझाया जिन्हें उसे प्रमाण रूप में प्रदर्शित करना था। मूसा ने हारून को वह सब कुछ बताया जो यहोवा ने कहा था। ");
INSERT INTO hin2010_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","इस प्रकार मूसा और हारून गए और उन्होंने इस्राएल के लोगों के सभी बुजुर्गों (नेताओ) को इकट्ठा किया। ");
INSERT INTO hin2010_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","तब हारून ने लोगों से कहा। उसने लोगों को वे सारी बातें बताई जो यहोवा ने मूसा से कहीं थीं। तब मूसा ने सब लोगों को दिखाने के लिए सारे प्रमाणों को करके दिखाया। ");
INSERT INTO hin2010_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","लोगों ने विश्वास किया कि परमेश्वर ने मूसा को भेजा है। उन्होंने झुक कर प्रणाम किया और परमेश्वर की उपासना की, क्योंकि वे जान गए कि परमेश्वर इस्राएल के लोगों की सहायता करने आ गया है और उन्होंने परमेश्वर की इसलिए उपासना की क्योंकि वे जान गए कि यहोवा ने उनके कष्टों को देखा है। ");
INSERT INTO hin2010_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","लोगों से बात करने के बाद मूसा और हारून फ़िरौन के पास गए। उन्होंने कहा, “इस्राएल का परमेश्वर यहोवा कहता है, ‘मेरे लोगों को मरुभूमि में जाने दें जिससे वे मेरे लिए उत्सव कर सके।’” ");
INSERT INTO hin2010_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","किन्तु फ़िरौन ने कहा, “यहोवा कौन है? मैं उसका आदेश क्यों मानूँ? मैं इस्राएलियों को क्यों जाने दूँ? मैं उसे नहीं जानता जिसे तुम यहोवा कहते हो। इसलिए मैं इस्राएलियों को जाने देने से मना करता हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","तब हारून और मूसा ने कहा, “हिब्रूओं के परमेश्वर ने हम लोगों को दर्शन दिया है। इसलिए हम लोग आपसे प्रार्थना करते है कि आप हम लोगों को तीन दिन तक मरुभूमि में यात्रा करने दें। वहाँ हम लोग अपने परमेश्वर यहोवा को एक बलि चढ़ाएंगे। यदि हम लोग ऐसा नहीं करेंगे तो वह क्रुद्ध हो जाएगा और हमें नष्ट कर देगा। वह हम लोगों को रोग या तलवार से मार सकता है।” ");
INSERT INTO hin2010_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","किन्तु फ़िरौन ने उनसे कहा, “मूसा और हारून, तुम लोगों को परेशान कर रहे हैं। तुम उन्हें काम करने से हटा रहे हो। उन दासों को काम पर लौटने को कहो। ");
INSERT INTO hin2010_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","यहाँ बहुत से श्रमिक हैं तुम लोग उन्हें अपना काम करने से रोक रहे हो।” ");
INSERT INTO hin2010_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ठीक उसी दिन फ़िरौन ने इस्राएल के लोगों के काम को और अधिक कड़ा बनाने का आदेश दिया। फ़िरौन ने दास स्वामियों से कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“तुम ने लोगों को सदा भूसा दिया है जिसका उपयोग वे ईंट बनाने में करते हैं। किन्तु अब उनसे कहो कि वे ईटें बनाने के लिए भूसा स्वयं जाकर इकट्ठा करें। ");
INSERT INTO hin2010_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","किन्तु वे संख्या में अब भी उतनी ही ई टें बनाएं जितनी वे पहले बनाते थे। वे आलसी हो गए है। यही कारण है कि वे जाने की माँग कर रहे हैं। उनके पास करने के लिए काफी काम नहीं है इसलिए वे मुझसे माँग कर रहे हैं कि मैं उन्हें उनके परमेश्वर को बलि चढ़ाने दूँ। ");
INSERT INTO hin2010_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","इसलिए इन लोगों से अधिक कड़ा काम कराओ। इन्हें काम में लगाए रखो। तब उनके पास इतना समय ही नहीं होगा कि वे मूसा की झूठी बातें सुनें।” ");
INSERT INTO hin2010_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","इसलिए मिस्री दास स्वामी और हिब्रू कार्य प्रबन्धक इस्राएल के लोगों के पास गए और उन्होंने कहा, “फ़िरौन ने निर्णय किया है कि वह तुम लोगों को तुम्हारी ईंटों के लिए तुम्हें भूसा नहीं देगा। ");
INSERT INTO hin2010_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","तुम लोगों को स्वयं जाना होगा और अपने लिए भूसा स्वयं इकट्ठा करना होगा। इसलिए जाओ और भूसा जुटाओ। किन्तु तुम लोग उतनी ही ईंटे बनाओ जितनी पहले बनाते थे।” ");
INSERT INTO hin2010_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","इस प्रकार हर एक आदमी मिस्र में भूसा खोजने के लिए चारों ओर गया। ");
INSERT INTO hin2010_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","दास स्वामी लोगों को अधिक कड़ा काम करने के लिए विवश करते रहे। वे लोगों को उतनी ही ईंटे बनाने के लिए विवश करते रहे जितनी वे पहले बनाया करते थे। ");
INSERT INTO hin2010_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","मिस्री दास स्वामियों ने हिब्रू कार्य—प्रबन्धक चुन रखे थे और उन्हें लोगों के काम का उत्तरदायी बना रखा था। मिस्री दास स्वामी इन कार्य—प्रबन्धकों को पीटते थे और उनसे कहते थे, “तुम उतनी ही ईंटे क्यों नहीं बनाते जितनी पहले बना रहे थे। जब तुम यह काम पहले कर सकते थे तो तुम इसे अब भी कर सकते हो।” ");
INSERT INTO hin2010_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","तब हिब्रू कार्य—प्रबन्धक फ़िरौन के पास गए। उन्होंने शिकायत की और कहा, “आप अपने सेवकों के साथ ऐसा बरताव क्यों कर रहे है? ");
INSERT INTO hin2010_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","आपने हम लोगों को भूसा नहीं दिया। किन्तु हम लोगों को आदेश दिया गया कि उतनी ही ईंटे बनाएँ जितनी पहले बनती थीं और अब हम लोगों के स्वामी हमे पीटते हैं। ऐसा करने में आपके लोगों की ग़लती है।” ");
INSERT INTO hin2010_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फ़िरौन ने उत्तर दिया, “तुम लोग आलसी हो। तुम लोग काम करना नहीं चाहते। यही कारण है कि तुम लोग माँग करते हो कि मैं तुम लोगों को जाने दूँ और यही कारण है कि तुम लोग यह स्थान छोड़ना चाहते हो और यहोवा को बलि चढ़ाना चाहते हो। ");
INSERT INTO hin2010_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","अब काम पर लौट जाओ। हम तुम लोगों को कोई भूसा नहीं देंगे। किन्तु तुम लोग उतनी ही ईंटें बनाओ जितनी पहले बनाया करते थे।” ");
INSERT INTO hin2010_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","हिब्रू कार्य—प्रबन्धक समझ गए कि वे परेशानी में पड़ गए हैं। कार्य—प्रबन्धक जानते थे कि वे उतनी ईंटें नहीं बना सकते जितनी बीते समय में बनाते थे। ");
INSERT INTO hin2010_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","फिरौन से मिलने के बाद जा रहे थे, वे मूसा और हारून के पास से निकले। मूसा और हारून उनकी प्रतीक्षा कर रहे थे। ");
INSERT INTO hin2010_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","इसलिए उन्होंने मूसा और हारून से कहा, “तुम लोगों ने बुरा किया कि तुम ने फ़िरौन से हम लोगों को जाने देने के लिए कहा। यहोवा तुम को दण्ड दे क्योंकि तुम लोगों ने फ़िरौन और उसके प्रशासकों में हम लोगों के प्रति घृणा उत्पन्न की। तुम ने हम लोगों को मारने का एक बहाना उन्हें दिया है।” ");
INSERT INTO hin2010_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","तब मूसा ने यहोवा से प्रार्थना की और कहा, “हे स्वामी, तूने अपने लोगों के लिए यह बुरा काम क्यों किया है? तूने हमको यहाँ क्यों भेजा है? ");
INSERT INTO hin2010_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","मैं फ़िरौन के पास गया और जो तूने कहने को कहा उसे मैंने उससे कहा। किन्तु उस समय से वह लोगों के प्रति अधिक क्रूर हो गया। और तूने उनकी सहायता के लिए कुछ नहीं किया है।” ");
INSERT INTO hin2010_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","तब यहोवा ने मूसा से कहा, “अब तुम देखोगे कि फ़िरौन का मैं क्या करता हूँ। मैं अपनी महान शक्ति का उपयोग उसके विरोध में करूँगा और वह मेरे लोगों को जाने देगा। वह उन्हें छोड़ने के लिए इतना अधिक आतुर होगा कि वह स्वयं उन्हें जाने के लिए विवश करेगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","तब परमेश्वर ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","“मैं यहोवा हूँ। मैं इब्राहीम, इसहाक और याकूब के सामने प्रकट हुआ था। उन्होंने मुझे एल सद्दायी (सर्वशक्तिमान परमेश्वर) कहा। मैंने उनको यह नहीं बताया था कि मेरा नाम यहोवा (परमेश्वर) है। ");
INSERT INTO hin2010_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","मैंने उनके साथ एक साक्षीपत्र बनाया मैंने उनको कनान प्रदेश देने का वचन दिया। वे उस प्रदेश में रहते थे, किन्तु वह उनका अपना प्रदेश नहीं था। ");
INSERT INTO hin2010_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","अब मैं इस्राएल के लोगों के कष्ट के बारे में जानता हूँ। मैं जानता हूँ कि वे मिस्र के दास है और मुझे अपना साक्षीपत्र याद है। ");
INSERT INTO hin2010_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","इसलिए इस्राएल के लोगों से कहो कि मैं उनसे कहता हूँ, ‘मैं यहोवा हूँ। मैं तुम लोगों की रक्षा करूँगा। मैं तुम लोगों को स्वतन्त्र करूँगा। तुम लोग मिस्रियों के दास नहीं रहोगे। मैं अपनी महान शक्ति का उपयोग करूँगा और मिस्रियों को भयंकर दण्ड दूँगा। तब मैं तुम लोगों को बचाऊँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","तुम लोग मेरे लोग होगे और मैं तुम लोगों का परमेश्वर। मैं यहोवा तुम लोगों का परमेश्वर हूँ और जानोगे कि मैंने तुम लोगों को मिस्र की दासता से मुक्त किया। ");
INSERT INTO hin2010_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","मैंने इब्राहीम, इसहाक और याकूब से बड़ी प्रतिज्ञा की थी। मैंने उन्हें विशेष प्रदेश देने का वचन दिया था। इसलिए मैं तुम लोगों को उस प्रदेश तक ले जाऊँगा। मैं वह प्रदेश तुम लोगों को दूँगा। वह तुम लोगों का होगा। मैं यहोवा हूँ।’” ");
INSERT INTO hin2010_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","इसलिए मूसा ने यह बात इस्राएल के लोगों को बताई। किन्तु लोग इतना कठिन श्रम कर रहे थे कि वे मूसा के प्रति धीरज न रख सके। उन्होंने उसकी बात नहीं सुनी। ");
INSERT INTO hin2010_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“जाओ और फ़िरौन से कहो कि वह इस्राएल के लोगों को इस देश से निश्चय ही जाने दे।” ");
INSERT INTO hin2010_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","किन्तु मूसा ने उत्तर दिया, “इस्राएल के लोग मेरी बात सुनना भी नहीं चाहते हैं इसलिए निश्चय ही फ़िरौन भी सुनना नहीं चाहेगा। मैं बहुत खराब वक्ता हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","किन्तु यहोवा ने मूसा और हारून से बातचीत की। परमेश्वर ने उन्हें जाने और इस्राएल के लोगों से बातें करने का आदेश दिया और यह भी आदेश दिया कि वे जाएँ और फ़िरौन से बातें करें। परमेश्वर ने आदेश दिया कि वे इस्राएल के लोगों को मिस्र के बाहर ले जाए। ");
INSERT INTO hin2010_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","इस्राएल के परिवारों के प्रमुख लोगों के नाम है: इस्राएल के पहले पुत्र रूबेन के चार पुत्र थे। वे थे हनोक, पल्लु, हेस्रोन और कर्म्मी। ");
INSERT INTO hin2010_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","शिमोन के पुत्र थे: यमूएल, यामीन, ओहद, याकीन सोहर और शाउल। (शाउल एक कनानी स्त्री का पुत्र था।) ");
INSERT INTO hin2010_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लेवी एक सौ सैंतीस वर्ष जीवित रहा। लेवी के पुत्र थे गेर्शोन, कहात और मरारी। ");
INSERT INTO hin2010_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेर्शोन के दो पुत्र थे—लिबनी और शिमी। ");
INSERT INTO hin2010_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कहात एक सौ तैंतीस वर्ष जीवित रहा। कहात के पुत्र थे अम्राम, यिसहार, हेब्रोन और उज्जीएल। ");
INSERT INTO hin2010_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मरारी के पुत्र थे महली और मूशी। ये सभी परिवार इस्राएल के पुत्र लेवी के थे। ");
INSERT INTO hin2010_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अम्राम एक सौ सैंतीस वर्ष जीवित रहा। अम्राम ने अपने पिता की बहन योकेबेद से विवाह किया। अम्राम और योकेबेद ने हारून और मूसा को जन्म दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","यिसहार के पुत्र थे कोरह नेपग और जिक्री। ");
INSERT INTO hin2010_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्जीएल के पुत्र थे मीशाएल एलसापान और सित्री। ");
INSERT INTO hin2010_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","हारून ने एलीशेबा से विवाह किया। (एलीशेबा अम्मीनादाब की पुत्री थी और नहशोन की बहन।) हारून और एलीशेबा ने नादाब, अबीहू, एलाजार, और ईतामार को जन्म दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरह के पुत्र (अर्थात् कोरही थे) अस्सीर एलकाना और अबीआसाप। ");
INSERT INTO hin2010_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","हारून के पुत्र एलाजार ने पूतीएल की पुत्री से विवाह किया और उन्होंने पीनहास को जन्म दिया। ये सभी लोग इस्राएल के पुत्र लेवी से थे। ");
INSERT INTO hin2010_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","इस प्रकार हारून और मूसा इसी परिवारासमूह से थे और ये ही वे व्यक्ति है जिनसे परमेश्वर ने बातचीत की और कहा, “मेरे लोगों को समूहों में बाँटकर मिस्र से निकालो।” ");
INSERT INTO hin2010_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","हारून और मूसा ने ही मिस्र के राजा फ़िरौन से बातचीत की। उन्होंने फ़िरौन से कहा कि वह इस्राएल के लोगों को मिस्र से जाने दे। ");
INSERT INTO hin2010_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","मिस्र देश में परमेश्वर ने मूसा से बातचीत की। ");
INSERT INTO hin2010_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","उसने कहा, “मैं यहोवा हूँ। मिस्र के राजा से वे सारी बातें कहो जो मैं तुमसे कहता हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","किन्तु मूसा ने उत्तर दिया, “मैं अच्छा वक्ता नहीं हूँ। राजा मेरी बात नहीं सुनेगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","यहोवा ने मूसा से कहा, “मैं तुम्हारे साथ रहूँगा। फ़िरौन के लिए तुम एक महान राजा की तरह होगे और हारून तुम्हारा अधिकृत वक्ता होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","जो आदेश मैं दे रहा हूँ वह सब कुछ हारून से कहो। तब वह वे बातें जो मैं कह रहा हूँ, फ़िरौन से कहेगा और फ़िरौन इस्राएल के लोगों को इस देश से जाने देगा। ");
INSERT INTO hin2010_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","किन्तु मैं फ़िरौन को हठी बनाऊँगा। वह उन बातों को नहीं मानेगा जो तुम कहोगे। तब मैं मिस्र में बहुत से चमत्कार करूँगा। किन्तु वह फिर भी नहीं सुनेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","इसलिए तब मैं मिस्र को बुरी तरह दण्ड दूँगा और मैं अपने लोगों को उस देश के बाहर ले चलूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","तब मिस्र के लोग जानेंगे कि मैं यहोवा हूँ। मैं उनके विरूद्ध हो जाऊँगा, और वे जानेंगे कि मैं यहोवा हूँ। तब मैं अपने लोगों को उनके देश से बाहर ले जाऊँगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","मूसा और हारून ने उन बातों का पालन किया जिन्हें यहोवा ने कहा था। ");
INSERT INTO hin2010_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","इस समय मूसा अस्सी वर्ष का था और हारून तिरासी का। ");
INSERT INTO hin2010_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“फ़िरौन तुमसे तुम्हारी शक्ति को प्रमाणित करने के लिए कहेगा। वह तुम्हें चमत्कार दिखाने के लिए कहेगा। तुम हारून से उसकी लाठी जमीन पर फेंकने को कहना। जिस समय फ़िरौन देख रहा होगा तभी लाठी साँप बन जाएगी।” ");
INSERT INTO hin2010_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","इसलिए मूसा और हारून फ़िरौन के पास गए और यहोवा की आज्ञा का पालन किया। हारून ने अपनी लाठी नीचे फेंकी। फिरौन और उसके अधिकारियों के देखते—देखते लाठी साँप बन गयी। ");
INSERT INTO hin2010_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","इसलिए फ़िरौन ने अपने गुणी पुरुषों और जादूगरों को बुलाया। इन लोगों ने अपने रहस्य चातुर्य का उपयोग किया और वे भी हारून के समान कर सके। ");
INSERT INTO hin2010_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","उन्होंने अपनी लाठियाँ ज़मीन पर फेंकी और वे साँप बन गई। किन्तु हारून की लाठी ने उनकी लाठियों को खा डाला। ");
INSERT INTO hin2010_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","फ़िरौन ने फिर भी, लोगों का जाना मना कर दिया। यह वैसा ही हुआ जैसा यहोवा ने कहा था। फिरौन ने मूसा और हारून की बात सुनने से मना कर दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","तब यहोवा ने मूसा और हारून से कहा, “फ़िरौन हठ पकड़े हुए है। फिरौन लोगों को जाने से मना करता है। ");
INSERT INTO hin2010_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","सवेरे फ़िरौन नदी पर जाएगा। उसके साथ नील नदी के किनारे—किनारे जाओ। उस लाठी को अपने साथ ले लो जो साँप बनी थी। ");
INSERT INTO hin2010_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","उससे यह कहो, ‘हिब्रू लोगों के परमेश्वर यहोवा ने हमको तुम्हारे पास भेजा है। यहोवा ने मुझे तुमसे यह कहने को कहा है, मेरे लोगों को मेरी उपासना करने के लिए मरुभूमि में जाने दो। तुमने भी अब तक यहोवा की बात पर कान नहीं दिया है। ");
INSERT INTO hin2010_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","इसलिए यहोवा कहता है कि, मैं ऐसा करूँगा जिससे तुम जानोगे कि मैं यहोवा हूँ। जो मैं अपने हाथ की इस लाठी को लेकर नील नदीं के पानी पर मारुँगा और नील नदी खून में बदल जाएगी। ");
INSERT INTO hin2010_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","तब नील नदी की मछलियाँ मर जाएंगी और नदी से दुर्गन्ध आने लगेगी। और मिस्री लोग नदी से पानी नहीं पी पाएँगे।’” ");
INSERT INTO hin2010_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","यहोवा ने मूसा को यह आदेश दिया, “हारून से कहो कि वह नदियों, नहरों, झीलों तथा तालाबों सभी स्थानों पर जहाँ मिस्र के लोग पानी एकत्र करते हैं, अपने हाथ की लाठी को बढ़ाए। जब वह ऐसा करेगा तो सारा जल खून में बदल जाएगा। सारा पानी, यहाँ तक कि लकड़ी और पत्थर के घड़ों का पानी भी, खून में बदल जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","इसलिए मूसा और हारून ने यहोवा का जैसा आदेश था, वैसा किया। उसने लाठी को उठाया और नील नदी के पानी पर मारा। उसने यह फ़िरौन और उसके अधिकारियों के सामने किया। फिर नदी का सारा जल खून में बदल गया। ");
INSERT INTO hin2010_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","नदी में मछलियाँ मर गई और नदी से दुर्गन्ध आने लगी। इसलिए मिस्री नदी से पानी नहीं पी सकते थे। मिस्र में सर्वत्र खून था। ");
INSERT INTO hin2010_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","जादूगरों ने अपनी जादूगरी दिखाई और उन्होंने भी वैसा ही किया। इसलिए फ़िरौन ने मूसा और हारून को सुनने से इन्कार कर दिया। यह ठीक वैसा ही हुआ जैसा यहोवा ने कहा था। ");
INSERT INTO hin2010_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","फिरौन मुड़ा और अपने घर चला गया। फ़िरौन ने, मूसा और हारून ने जो कुछ किया, उसकी उपेक्षा की। ");
INSERT INTO hin2010_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","मिस्री नदी से पानी नहीं पी सकते थे। इसलिए पीने के पानी के लिए उन्होंने नदी के चारों और कुएँ खोदे। ");
INSERT INTO hin2010_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","यहोवा द्वारा नील नदी के बदले जाने के बाद सात दिन बीत गये। ");
INSERT INTO hin2010_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","तब यहोवा ने मूसा से कहा, “फ़िरौन के पास जाओ और उससे कहो को यहोवा यह कहता है, ‘मेरे आदमियों को मेरी उपासना के लिए जाने दो। ");
INSERT INTO hin2010_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","यदि फ़िरौन उनको जाने से रोकता है तो मैं मिस्र को मेंढ़कों से भर दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","नील नदी मेढ़कों से भर जाएगी। वे नदी से निकलेंगे और तुम्हारे घरों में घुसेंगे। वे तुम्हारे सोने के कमरों और तुम्हारे बिछौनों में होंगे। मेढ़क तुम्हारे अधिकारियों के घरों में, रसोई में और तुम्हारे पानी के घड़ों में होंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","मेंढ़क पूरी तरह तुम्हारे ऊपर, तुम्हारे लोगों के ऊपर और तुम्हारे अधिकारियों के ऊपर होंगे।’” ");
INSERT INTO hin2010_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","तब यहोवा ने मूसा से कहा, “हारून से कहो कि वह अपने हाथ की लाठी को नहरों, नदियों और झीलों के उपर उठाए और मेढ़क बाहर निकलकर मिस्र देश में भर जाएँगें।” ");
INSERT INTO hin2010_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","तब हारून ने मिस्र देश में जहाँ भी जल था उसके ऊपर हाथ उठाया और मेंढ़क पानी से बाहर आने आरम्भ हो गए और पूरे मिस्र को ढक दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","जादूगरों ने भी वैसा ही किया। वे भी मिस्र देश में मेंढ़क ले आए। ");
INSERT INTO hin2010_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","फ़िरौन ने मूसा और हारून को बुलाया। फिरौन ने कहा, “यहोवा से कहो कि वे मुझ पर तथा मेरे लोगों पर से मेढ़कों को हटाएं। तब मैं लोगों को यहोवा के लिए बलि चढ़ाने को जाने दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मूसा ने फिरौन से कहा, “मुझे यह बताएँ कि आप कब चाहते हैं कि मेंढ़क चले जाएँ। मैं आपके लिए, आपके लोगों के लिए तथा आपके अधिकारियों के लिए प्रार्थना करूँगा। तब मेंढ़क आपको और आपके घरों को छोड़ देंगे। मेंढ़क केवल नदी में रह जाएँगे। आप कब चाहते है कि मेंढ़क चले जाएं?।” ");
INSERT INTO hin2010_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","फिरौन ने कहा, “कल।” मूसा ने कहा, “जैसा आप कहते हैं वैसा ही होगी। इस प्रकार आप जान जाएंगे कि हमारे परमेश्वर यहोवा के समान कोई अन्य देवता नहीं है। ");
INSERT INTO hin2010_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","मेंढ़क आपको, आपके घर को, आपके अधिकारियों को और आपके लोगों को छोड़ देंगे। मेंढ़क केवल नदी में रह जाएंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","मूसा और हारून फ़िरौन से विदा हुए। मूसा ने उन मेंढ़को के लिए जिन्हें फ़िरौन के विरुद्ध यहोवा ने भेजा था, यहोवा को पुकारा। ");
INSERT INTO hin2010_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","और यहोवा ने वह किया जो मूसा ने कहा था। मेंढ़क घरों में, घर के आँगनों में और खेतों में मर गए। ");
INSERT INTO hin2010_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","वे सड़ने लगे और पूरा देश दुर्गन्ध से भर गया। ");
INSERT INTO hin2010_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","जब फ़िरौन ने देखा कि वे मेंढ़कों से मुक्त हो गए है तो वह फिर हठी हो गया। फ़िरौन ने वैसा नहीं किया जैसा मूसा और हारून ने उससे करने को कहा था। वह ठीक वैसा ही हुआ जैसा यहोवा ने कहा था। ");
INSERT INTO hin2010_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","तब यहोवा ने मूसा से कहा, “हारून से कहो कि वह अपनी लाठी उठाए और जमीन पर की धूल पर मारे। मिस्र में सर्वत्र धूल जूँएं बन जाएंगी।” ");
INSERT INTO hin2010_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","उन्होंने यह किया। हारून ने अपने हाथ की लाठी को उठाया और जमीन पर धूल में मारा मिस्र में सर्वत्र धूल जूँएं बन गई। जूँएं जानवरों और आदमियों पर छाई रहीं। ");
INSERT INTO hin2010_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","जादूगरों ने अपने जादूओं का उपयोग किया और वैसा ही करना चाहा। किन्तु जादूगर धूल से जूँए न बना सके। जूएँ जानवरों और आदमियों पर छाई रहीं। ");
INSERT INTO hin2010_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","इसलिए जादूगरों ने फिरौन से कहा कि परमेश्वर की शक्ति ने ही यह किया है। किन्तु फ़िरौन ने उनकी सुनने से इन्कार कर दिया। यह ठीक वैसा ही हुआ जैसा यहोवा ने कहा था। ");
INSERT INTO hin2010_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","यहोवा ने मूसा से कहा, “सवेरे उठो और फ़िरौन के पास जाओ। फ़िरौन नदी पर जाएगा। उससे कहो कि यहोवा कह रहा है, ‘मेरे लोगों को मेरी उपासना के लिए जाने दो। ");
INSERT INTO hin2010_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","यदि तुम मेरे लोगों को नहीं जाने दोगे तो तुम्हारे घरों में मक्खियाँ आएँगी। मक्खियाँ तुम्हारे और तुम्हारे अधिकारियों के ऊपर छा जाएंगी। मिस्र के घर मक्खियों से भर जाएंगे। मक्खियाँ पूरी ज़मीन पर छा जाएंगी। ");
INSERT INTO hin2010_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","किन्तु मैं इस्राएल के लोगों के साथ वैसा ही बरताव नहीं करूँगा जैसा मिस्री लोगों के साथ करुँगा। जहाँ गेशेन में मेरे लोग रहते हैं वहँ कोई मक्खी नहीं होगी। इस प्रकार तुम जानोगे कि मैं यहोवा, इस देश में हूँ। ");
INSERT INTO hin2010_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","अतः मैं कल अपने लोगों के साथ तुम्हारे लोगों से भिन्न बरताव करूँगा। यही मेरा प्रमाण होगा।’” ");
INSERT INTO hin2010_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","अतः यहोवा ने वही किया, उसने जो कहा झुण्ड की झुण्ड मक्खियाँ मिस्र में आई। मक्खियाँ फ़िरौन के घर और उसके सभी अधिकारियों के घर में भरी थीं। मक्खियाँ पूरे मिस्र देश में भरी थी। मक्खियाँ देश को नष्ट कर रही थीं। ");
INSERT INTO hin2010_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","इसलिए फ़िरौन ने मूसा और हारून को बुलाया। फ़िरौन ने कहा, “तुम लोग अपने परमेश्वर यहोवा को इसी देश में बलियाँ भेंट करो।” ");
INSERT INTO hin2010_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","किन्तु मूसा ने कहा, “वैसा करना ठीक नहीं होगा। मिस्री सोचते हैं कि हमारे परमेश्वर यहोवा को जानवरों को मार कर बलि चढ़ाना एक भयंकर बात है। इसलिए यदि हम लोग यहाँ ऐसा करते तो मिस्री हमें देखेंगे, वे हम लोगों पर पत्थर फेकेंगे और हमें मार डालेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","हम लोगों को तीन दिन तक मरुभूमि में जाने दो और हमें अपने यहोवा परमेश्वर को बलि चढ़ाने दो। यही बात है जो यहोवा ने हम लोगों से करने को कहा है।” ");
INSERT INTO hin2010_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","इसलिए फ़िरौन ने कहा, “मैं तुम लोगों को जाने दूँगा और मरूभूमि में तुम लोगों के यहोवा परमेश्वर को बलियाँ भेंट करने दूँगा। किन्तु तुम लोगों को ज्यादा दूर नहीं जाना होगा। अब तुम जाओ और मेरे लिए प्रार्थना करो।” ");
INSERT INTO hin2010_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मूसा ने कहा, “देखो, मैं जाऊँगा और यहोवा से प्रार्थना करूँगा कि कल वे तुम से, तुम्हारे लोगों से और तुम्हारे अधिकारियों से मक्खियों को हटा ले। किन्तु तुम लोग यहोवा को बलियाँ भेंट करने से मत रोको।” ");
INSERT INTO hin2010_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","इसलिए मूसा फ़िरौन के पास से गया और यहोवा से प्रार्थना की ");
INSERT INTO hin2010_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","और यहोवा ने यह किया जो मूसा ने कहा। यहोवा ने मक्खियों को फ़िरौन, उसके अधिकारियों और उसके लोगों से हटा लिया। कोई मक्खी नहीं रह गई। ");
INSERT INTO hin2010_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","किन्तु फ़िरौन फिर हठी हो गया और उसने लोगों को नहीं जाने दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","तब यहोवा ने मूसा से कहा फ़िरौन के पास जाओ और उससे कहो, “हिब्रू लोगों का परमेश्वर यहोवा कहता है, ‘मेरी उपासना के लिए मेरे लोगों को जाने दो।’ ");
INSERT INTO hin2010_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","यदि तुम उन्हें रोकते रहे और उनका जाना मना करते रहे ");
INSERT INTO hin2010_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","तब यहोवा अपनी शक्ति का उपयोग तुम्हारे खेत के जानवरों के विरुद्ध करेगा। यहोवा तुम्हारे सभी घोड़ों, गधों, ऊँटो, गाय, बैल, बकरियों और भेड़ों को भयंकर बीमारियों का शिकार बना देगा। ");
INSERT INTO hin2010_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","यहोवा इस्राएल के जानवरों के साथ मिस्र के जानवरों से भिन्न बरताव करेगा। इस्राएल के लोगों का कोई जानवर नहीं मरेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","यहोवा ने इसके घटित होने का समय निश्चित कर दिया है। कल यहोवा इस देश में इसे घटित होने देगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","अगली सुबह मिस्र के सभी खेत के जानवर मर गए। किन्तु इस्राएल के लोगों के जानवरों में से कोई नहीं मरा। ");
INSERT INTO hin2010_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","फ़िरौन ने लोगों को यह देखने भेजा कि क्या इस्राएल के लोगों का कोई जानवर मरा या इस्राएल के लोगों का कोई जानवर नहीं मरा था। फ़िरौन हठ पकड़े रहा। उसने लोगों को नहीं जाने दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","यहोवा ने मूसा और हारून से कहा, “अपनी अंजलियों में भट्टी की राख भरो। और मूसा तुम फ़िरौन के सामने राख को हवा में फेंका। ");
INSERT INTO hin2010_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","यह धूल बन जाएगी और पूरे मिस्र देश में फैल जाएगी। जैसे ही धूल आदमी या जानवर पर मिस्र में पड़ेगी, चमड़े पर फोड़े फुंसी (घाव) फूट निकलेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","इसलिए मूसा और हारून ने भट्टी से राख ली। तब वे गए और फ़िरौन के सामने खड़े हो गए। उन्होंने राख को हवा में फेंका और लोगों और जानवरों को फोड़े होने लगे। ");
INSERT INTO hin2010_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","जादूगर मूसा को ऐसा करने से न रोक सके, क्योंकि जादूगरों को भी फोड़े हो गए थे। सारे मिस्र में ऐसा ही हुआ। ");
INSERT INTO hin2010_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","किन्तु यहोवा ने फ़िरौन को हठी बनाए रखा। इसलिए फ़िरौन ने मूसा और हारून को सुनने से मना कर दिया। यह वैसा ही हुआ जैसा यहोवा ने कहा था। ");
INSERT INTO hin2010_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","तब यहोवा ने मूसा से कहा, “सवेरे उठो और फ़िरौन के पास जाओ। उससे कहो कि हिब्रू लोगों का परमेश्वर यहोवा कहता है, ‘मेरे लोगों को मेरी उपासना के लिए जाने दो! ");
INSERT INTO hin2010_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","यदि तुम यह नहीं करोगे तो मैं तुम्हें, तुम्हारे अधिकारियों और तुम्हारे लोगों के विरुद्ध पूरी शक्ति का प्रयोग करुँगा। तब तुम जानोगे कि मेरे समान दुनिया में अन्य कोई परमेश्वर नहीं है। ");
INSERT INTO hin2010_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","मैं अपनी शक्ति का प्रयोग कर सकता हूँ तथा मैं ऐसी बीमारी फैला सकता हूँ जो तुम्हें और तुम्हारे लोगों को धरती से समाप्त कर देगी। ");
INSERT INTO hin2010_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","किन्तु मैंने तुम्हें यहाँ किसी कारणवश रखा है। मैंने तुम्हें यहाँ इसलिए रखा है कि तुम मेरी शक्ति को देख सको। तब सारे संसार के लोग मेरे बारे में जान जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","तुम अब भी मेरे लोगों के विरुद्ध हो। तुम उन्हें स्वतन्त्रतापूर्वक नहीं जाने दे रहे हो। ");
INSERT INTO hin2010_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","इसलिए कल मैं इसी समय भयंकर ओला बारिश उत्पन्न करुँगा। जब से मिस्र राष्ट्र बना तब से मिस्र में ऐसी ओला बारिश पहले कभी नहीं आई होगी। ");
INSERT INTO hin2010_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","अतः अपने जानवरों को सुरक्षित जगह में रखना। जो कुछ तुम्हारा खेतों में हो उसे सुरक्षित स्थानों में अवश्य रख लेना। क्यों? क्योंकि कोई भी व्यक्ति या जानवर जो मैदानों में होगा, मारा जाएगा। जो कुछ तुम्हारे घरों के भीतर नहीं रखा होगा उस सब पर ओले गिरेंगे।’” ");
INSERT INTO hin2010_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","फ़िरौन के कुछ अधिकारियों ने यहोवा के सन्देश पर ध्यान दिया। उन लोगों ने जल्दी—जल्दी अपने जानवरों और दासों को घरों में कर लिया। ");
INSERT INTO hin2010_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","किन्तु अन्य लोगों ने यहोवा के सन्देश की उपेक्षा की। उन लोगों के वे दास और जानवर नष्ट हो गए तो बाहर मैदानों में थे। ");
INSERT INTO hin2010_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","यहोवा ने मूसा से कहा, “अपनी भुजाएं हवा में उठाओ और मिस्र पर ओले गिरने आरम्भ हो जाएंगे। ओले पूरे मिस्र के सभी खेतों में लोगों, जानवरों और पेड़—पौधों पर गिरेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","अतः मूसा ने अपनी लाठी को हवा में उठाया और यहोवा ने गर्जन और बिजलियां भेजी, तथा ज़मीन पर ओले बरसायें। ओले पूरे मिस्र पर पड़े। ");
INSERT INTO hin2010_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ओले पड़ रहे थे और ओलों के साथ बिजली चमक रह थी। जब से मिस्र राष्ट्र बना था तब से मिस्र को हानि पहुँचाने वाले ओले वृष्टि में यह सबसे भयंकर थे। ");
INSERT INTO hin2010_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","आँधी ने मिस्र के खेतों में जो कुछ था उसे नष्ट कर दिया। ओलों ने आदमियों, जानवरों और पेड़—पौधों को नष्ट कर दिया। ओले ने खेतों में सारे पेड़ों को भी तोड़ दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","गेशेन प्रदेश ही, जहाँ इस्राएल के लोग रहते थे, ऐसी जगह थी जहाँ ओले नहीं पड़े। ");
INSERT INTO hin2010_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","फ़िरौन ने मूसा और हारून को बुलाया। फ़िरौन ने उनसे कहा, “इस बार मैंने पाप किया है। यहोवा सच्चा है और मैं तथा मेरे लोग दुष्ट हैं। ");
INSERT INTO hin2010_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ओले और परमेश्वर की गरजती आवाज़े अत्याधिक हैं। परमेश्वर से तूफान को रोकने को कहो। मैं तुम लोगों को जाने दूँगा। तुम लोगों को यहाँ रहना नहीं पड़ेगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मूसा ने फ़िरौन से कहा, “जब मैं नगर को छोड़ूँगा तब मैं प्रार्थना में अपनी भुजाओं को यहोवा के सामने उठाऊँगा और गर्जन तथा ओले रूक जाएंगे। तब तुम जानोगे कि पृथ्वी यहोवा ही की है। ");
INSERT INTO hin2010_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","किन्तु मैं जानता हूँ कि तुम और तुम्हारे अधिकारी अब भी यहोवा से नहीं डरते हैं और न ही उसका सम्मान करते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","जूट में दाने पड़ चुके थे। और जौ पहले ही फट चुका था। इसलिए ये फसले नष्ट हो गई। ");
INSERT INTO hin2010_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","गेहूँ और कठिया नामक गेहूँ अन्य अन्नों से बाद में पकते हैं अतः ये फसलें नष्ट नहीं हुई थीं। ");
INSERT INTO hin2010_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","मूसा ने फिरौन को छोड़ा और नगर के बाहर गया। उसने यहोवा के सामने अपनी भुजाएं फैलायी और गरज तथा ओले बन्द हो गए। वर्षा भी धरती पर होनी बन्द हो गई। ");
INSERT INTO hin2010_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","जब फिरौन ने देखा कि वर्षा, ओले और गर्जन बन्द हो गए तो उसने फिर गलत काम किया। वह और उसके अधिकारी फिर हठ पकड़े रहे। ");
INSERT INTO hin2010_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","फ़िरौन ने इस्राएल के लोगों को स्वतन्त्रतापूर्वक जाने से इन्कार कर दिया। यह ठीक वैसा ही हुआ जैसा यहोवा ने मूसा से कहा था। ");
INSERT INTO hin2010_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","यहोवा ने मूसा से कहा, “फिरौन के यहाँ जाओ। मैंने उसे और उसके अधिकारियों को हठी बना दिया है। मैंने यह इसलिए किया है कि मैं उन्हें अपने शक्तिशाली चमत्कार दिखा सकूँ। ");
INSERT INTO hin2010_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","मैंने इसे इसलिए भी किया कि तुम अपने पुत्र—पुत्रियों तथा पौत्र—पौत्रियों से उन चमत्कारों और अद्भुत बातों को बता सको जो मैंने मिस्र में किया है। तब तुम सभी जानोगे कि मैं यहोवा हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","इसलिए मूसा और हारून फ़िरौन के पास गए। उन्होंने उससे कहा, “हिब्रू लोगों का परमेश्वर यहोवा कहता है, ‘तुम मेरे आदेशों का पालन करने से कब तक इन्कार करोगे? मेरे लोगों को मेरी उपासना करने के लिए जाने दो! ");
INSERT INTO hin2010_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","यदि तुम मेरे लोगों को जाने से मना करते हो तो मैं कल तुम्हारे देश में टिड्डियों को लाऊँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","टिड्डियाँ पूरी जमीन को ढक लेगी। टिड्डियों की संख्या इतनी अधिक होगी कि तुम जमीन नहीं देख सकोगे। जो कोई चीज ओले भरी आँधी से बच गई है उसे टिड्डियाँ खा जाएंगी। टिड्डियाँ मैदानों में पेड़ों की सारी पत्तियाँ खा डालेंगी। ");
INSERT INTO hin2010_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","टिड्डियाँ तुम्हारे सभी घरों, तुम्हारे अधिकारियों के सभी घरों और मिस्र के सभी घरों में भर जाएंगी। जितनी टिड्डियाँ तुम्हारे बाप—दादों ने कभी देखीं होंगी उससे भी अधिक टिड्डियाँ यहाँ होंगी। जब से लोग मिस्र में, रहने लगे तब से जब कभी जितनी टिड्डियाँ हुईं होंगी उससे अधिक टिड्डियाँ होंगी।’” तब मूसा मुड़ा और उसने फ़िरौन को छोड़ दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","फ़िरौन के अधिकारियों ने उससे पूछा, “हम लोग कब तक इन लोगों के जाल में फँसे रहेंगे। लोगों को उनके परमेश्वर यहोवा की उपासना करने जाने दें। यदि आप उन्हें नहीं जाने देंगे तो आपके जानने से पहले मिस्र नष्ट हो जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","अत: फ़िरौन के अधिकारियों ने मूसा और हारून को उसके पास वापस बुलाने को कहा। फ़िरौन ने उनसे कहा, “जाओ और अपने परमेश्वर यहोवा की उपासना करो। किन्तु मुझे बताओ कि सचमुच कौन—कौन जा रहा है?” ");
INSERT INTO hin2010_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मूसा ने उत्तर दिया, “हमारे युवक और बूढ़े लोग जाएंगे और हम लोग अपने साथ अपने पुत्रों और पुत्रियों, तथा भेड़ों और पशुओं को भी ले जाएंगे। हम सभी जाएंगे क्योंकि यह हमारे लिए हम लोगों के यहोवा का त्यौहार है।” ");
INSERT INTO hin2010_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","फ़िरौन ने उनसे कहा, “इससे पहले कि मैं तुम्हे और तुम्हारे सभी बच्चों को मिस्र छोड़कर जाने दूँ यहोवा को वास्तव में तुम्हारे साथ होना होगा। देखो तुम लोग एक बहुत बुरी योजना बना रहे हो। ");
INSERT INTO hin2010_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","केवल पुरुष जा सकते हैं और यहोवा की उपासना कर सकते हैं। तुमने प्रारम्भ में यही माँग की थी। किन्तु तुम्हारे सारे लोग नहीं जा सकते।” तब फ़िरौन ने मूसा और हारून को भेज दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","यहोवा ने मूसा से कहा, “मिस्र को भूमि के ऊपर अपना हाथ उठाओ और टिड्डियाँ आ जाएंगी। टिड्डियाँ मिस्र की सारी भूमि पर फैल जाएंगी। टिड्डियाँ ओलों से बचे सभी पेड़—पौधों को खा जाएंगी।” ");
INSERT INTO hin2010_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","मूसा ने अपनी लाठी को मिस्र देश के ऊपर उठाया और यहोवा ने पूर्व से प्रवल आँधी उठाई। आँधी उस पूरे दिन और रात चलती रही। जब सवेरा हुआ, आँधी ने मिस्र देश में टिड्डियों को ला दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","टिड्डियाँ मिस्र देश में उड़कर आई और भूमि पर बैठ गई। मिस्र में कभी जितनी टिड्डियाँ हुई थी उनसे अधिक टिड्डियाँ हुई और उतनी संख्या में वहाँ टिड्डियाँ फिर कभी नहीं होंगी। ");
INSERT INTO hin2010_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","टिड्डियों ने जमीन को ढक लिया और पूरे देश में अँधेरे छा गया। टिड्डियों ने उन सभी पौधों और पेड़ों के हर फल को, जो ओले से नष्ट नहीं हुआ था खा डाला। मिस्र में कहीं भी किसी पेड़ या पौधे पर कोई पत्ती नहीं रह गई। ");
INSERT INTO hin2010_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","फ़िरौन ने मूसा और हारून को जल्दी बुलवाया। फ़िरौन ने कहा, “मैंने तुम्हारे और तुम्हारे परमेश्वर यहोवा के विरुद्ध पाप किया है। ");
INSERT INTO hin2010_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","इस समय मेरे पाप को अब क्षमा करो। अपने परमेश्वर यहोवा से प्रार्थना करो कि इस ‘मृत्यु’ (टिड्डियों) को मुझ से दूर करे।” ");
INSERT INTO hin2010_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","मूसा फ़िरौन को छोड़ कर चला गया और उसने यहोवा से प्रार्थना की। ");
INSERT INTO hin2010_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","इसलिए यहोवा ने हवा का रूख बदल दिया। यहोवा ने पश्चिम से तेज़ आँधी उठाई और उसने टिड्डियों को दूर लाल सागर में उड़ा दिया। एक भी टिड्डी मिस्र में नहीं बची। ");
INSERT INTO hin2010_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","किन्तु यहोवा ने फ़िरौन को फिर हठी बनाया और फ़िरौन ने इस्राएल के लोगों को जाने नहीं दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","तब यहोवा ने मूसा से कहा, “अपनी बाहों को आकाश में ऊपर उठाओ और अंधकार मिस्र को ढक लेगा। यह अधंकार इतना सघन होगा कि तुम मानो उसे महसूस कर सकोगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","अतः मूसा ने हवा में बाहें उठाई और घोर अन्धकार ने मिस्र को ढक लिया। मिस्र में तीन दिन तक अधंकार रहा। ");
INSERT INTO hin2010_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","कोई भी किसी अन्य को नहीं देख सकता था और तीन दिन तक कोई अपनी जगह से नहीं उठ सका। किन्तु उन सभी जगहों पर जहाँ इस्राएल के लोग रहते थे, प्रकाश था। ");
INSERT INTO hin2010_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","फ़िरौन ने मूसा को फिर बुलाया। फ़िरौन ने कहा, “जाओ और यहोवा की उपासना करो! तुम अपने साथ अपने बच्चों को ले जा सकते हो। केवल अपनी भेड़ें और पशु यहाँ छोड़ देना।” ");
INSERT INTO hin2010_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","मूसा ने कहा, “हम लोग केवल अपनी भेड़ें और पशु ही अपने साथ नहीं ले जाएंगे बल्कि जब हम लोग जाएंगे तुम हम लोगों को भेंट और बलि भी दोगे और हम लोग इन बलियों का अपने परमेश्वर यहोवा की उपासना के रूप में प्रयोग करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","हम लोग अपने जानवर अपने साथ अपने परमेश्वर यहोवा की उपासना के लिए ले जाएंगे। एक खुर भी पीछे नहीं छोड़ा जाएगा। अभी तक हम नहीं जानते कि यहोवा की उपासना के लिए किन चीज़ों की सचमुच आवश्यकता पड़ेगी। यह हम लोग तब जान सकेंगे जब हम लोग वहाँ पहुँचेंगे जहाँ हम जा रहे हैं। अतः ये सभी चीज़ें अवश्य ही हम अपने साथ ले जाएंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","यहोवा ने फ़िरौन को फिर हठी बनाया। इसलिए फ़िरौन ने उनको जाने से मना कर दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","तब फ़िरौन ने मूसा से कहा, “मुझ से दूर हो जाओ। मैं नहीं चाहता कि तुम यहाँ फिर आओ! इसके बाद यदि तुम मुझसे मिलने आओगे तो मारे जाओगे!” ");
INSERT INTO hin2010_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","तब मूसा ने फिरौन से कहा, “तुम जो कहते हो, सही है। मैं तुमसे मिलने फिर कभी नहीं आऊँगा!” ");
INSERT INTO hin2010_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","तब यहोवा ने मूसा से कहा, “फिरौन और मिस्र के विरुद्ध मैं एक और विपत्ति लाऊँगा। इसके बाद वह तुम लोगों को मिस्र से भेज देगा। वस्तुतः वह तुम लोगों को यह देश छोड़ने को विवश करेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","तुम इस्राएल के लोगों को यह सन्देश अवश्य देना: ‘तुम सभी स्त्री और पुरुष अपने पड़ोसियों से चाँदी और सोने की बनी चीजें माँगना। ");
INSERT INTO hin2010_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","यहोवा मिस्रियों को तुम लोगों पर कृपालु बनाएगा। मिस्री लोग, यहाँ तक कि फ़िरौन के अधिकारी भी पहले से मूसा को महान पुरुष समझते हैं।’” ");
INSERT INTO hin2010_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","मूसा ने लोगों से कहा, “यहोवा कहता है, ‘आज आधी रात के समय, मैं मिस्र से होकर गुजरुँगा, ");
INSERT INTO hin2010_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","और मिस्र का हर एक पहलौठे पुत्र मिस्र के शासक फ़िरौन के पहलौठे पुत्र से लेकर चक्की चलाने वाली दासी तक का पहलौठा पुत्र मर जाएगा। पहलौठे नर जानवर भी मरेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","मिस्र की समूची धरती पर रोना—पीटना मचेगा। यह रोना—पीटना किसी भी गुजरे समय के रोने—पीटने से अधिक बुरा होगा और यह भविष्य के किसी भी रोने—पीटने के समय से अधिक बुरा होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","किन्तु इस्राएल के किसी व्यक्ति को कोई चोट नहीं पहुँचेगी। यहाँ तक कि उन पर कोई कुत्ता तक नहीं भौंकेगा। इस्राएल के लोगों के किसी व्यक्ति या किसी जानवर को कोई चोट नहीं पहुँचेगी। इस प्रकार तुम लोग जानोगे कि मैंने मिस्रियों के साथ इस्राएल वालों से भिन्न व्यवहार किया है। ");
INSERT INTO hin2010_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","तब ये सभी तुम लोगों के दास मिस्री झुक कर मुझे प्रणाम करेंगे और मेरी उपासना करेंगे। वे कहेंगे, “जाओ, और अपने सभी लोगों को अपने साथ ले जाओ।” तब मैं फ़िरौन को क्रोध में छोड़ दूँगा।’” ");
INSERT INTO hin2010_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","तब यहोवा ने मूसा से कहा, “फ़िरौन ने तुम्हारी बात नहीं सुनी। क्यों? इसलिए कि मैं अपनी महान शक्ति मिस्र में दिखा सकूँ।” ");
INSERT INTO hin2010_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","यही कारण था कि मूसा और हारून ने फ़िरौन के सामने ये बड़े—बड़े चमत्कार दिखाए। और यही कारण है कि यहोवा ने फ़िरौन को इतना हठी बनाया कि उसने इस्राएल के लोगों को अपना देश छोड़ने नहीं दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","मूसा और हारून जब मिस्र में ही थे, यहोवा ने उनसे कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“यह महीना तुम लोगों के लिए वर्ष का पहला महीना होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","इस्राएल की पूरी जाति के लिए यह आदेश है: इस महीने के दसवें दिन हर एक व्यक्ति अपने परिवार के लोगों के लिए एक मेमना अवश्य प्राप्त करेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","यदि पूरा मेमना खा सकने वाले पर्याप्त आदमी अपने परिवारों में न हों तो उस भोजन में सम्मिलित होने के लिए अपने कुछ पड़ोसियों को निमन्त्रित करना चाहिए। खाने के लिए हर एक को पर्याप्त मेमना होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","एक वर्ष का यह नर मेमना दोषरहित होना चाहिए। यह जानवर या तो एक भेड़ का बच्चा हो सकता है या बकरे का बच्चा। ");
INSERT INTO hin2010_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","तुम्हें इस जानवर को महीने के चौदहवें दिन तक सावधानी के साथ रखना चाहिए। उस दिन इस्राएल जाति के सभी लोग सन्ध्या काल में इन जानवरों को मारेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","इन जानवरों का खून तुम्हें इकट्ठा करना चाहिए। कुछ खून उन घरों के दरवाजों की चौखटों के ऊपरी सिरे तथा दोनों पटों पर लगाना चाहिए जिन घरों में लोग यह भोजन करें। ");
INSERT INTO hin2010_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","“इस रात को तुम मेमने को अवश्य भून लेना और उसका माँस खा जाना। तुम्हें कड़वी जड़ी—बूटियों और अखमीरी रोटियाँ भी खानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","तुम्हें मेमने को पानी में उवालना नहीं चाहिए। तुम्हें पूरे मेमने को आग पर भूनना चाहिए। इस दशा में भी मेमने का सिर, उसके पैर तथा उसका भीतरी भाग ठीक बना रहना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","उसी रात को तुम्हें सारा माँस अवश्य खा लेना चाहिए। यदि थोड़ा माँस सबेरे तक बच जाये तो उसे आग में अवश्य ही जला देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“जब तुम भोजन करो तो ऐसे वस्त्रों को पहनो जैसे तुम लोग यात्रा पर जा रहे हो तुम लोगों के लबादे तुम्हारी पेटियों में कसे होने चाहिए। तुम लोग अपने जूते पहने रहना और अपनी यात्रा की छड़ी को अपने हाथों में रखना। तुम लोगों को शीघ्रता से भोजन कर लेना चाहिए। क्यों? क्योंकि यह यहोवा का फसह है वह समय जब यहोवा ने अपने लोगों की रक्षा की और उन्हें शीघ्रता से मिस्र के बाहर ले गया। ");
INSERT INTO hin2010_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“आज रात मैं मिस्र से होकर गुजरूँगा और मिस्र में प्रत्येक पहलौठे पुत्र को मार डालूँगा। मैं सभी पहलौठे जानवरों और मनुष्यों को मार डालूँगा। मैं मिस्र के सभी देवताओं को दण्ड दूँगा और दिखा दूँगा कि मैं यहोवा हूँ। ");
INSERT INTO hin2010_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","किन्तु तुम लोगों के घरों पर लगा हुआ खून एक विशेष चिन्ह होगा। जब मैं खून देखूँगा, तो तुम लोगों के घरों को छोड़ता हुआ गुजर जाऊँगा। मैं मिस्र के लोगों के लिए हानिकारक चीज़ें उत्पन्न करूँगा। किन्तु उन बुरी बीमारियों में से कोई भी तुम लोगों को हानि नहीं पहुँचाएगी। ");
INSERT INTO hin2010_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“सो तुम लोग आज की इस रात को सदा याद रखोगे, तुम लोगों के लिए यह एक विशेष पवित्र पर्व होगा। तुम्हारे वंशज सदा इस पवित्र पर्व को यहोवा की भक्ति किया करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","इस पवित्र पर्व पर तुम लोग अख़मीरी आटे की रोटियाँ सात दिनों तक खाओगे। इस पवित्र पर्व के आने पर तुम लोग पहले दिन अपने घरों से सारे ख़मीर को निकाल बाहर करोगे। इस पवित्र पर्व के पूरे सात दिन तक किसी को भी ख़मीर नहीं खाना चाहिए। यदि कोई व्यक्ति ख़मीर खाए तो उसे तुम इस्राएल के अन्य व्यक्तियों से निश्चय ही अलग कर देना। ");
INSERT INTO hin2010_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","इस पवित्र पर्व के प्रथम और अन्तिम दिनों में धर्म सभा होगी। इन दिनों तुम्हें कोई भी काम नहीं करना होगा। इन दिनों केवल एक काम जो किया जा सकता, वह है अपना भोजन तैयार करना। ");
INSERT INTO hin2010_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","तुम लोगों को अवश्य अख़मीरी रोटी का पवित्र पर्व याद रखना होगा। क्यों? क्योंकि इस दिन ही मैंने तुम्हारे लोगों के सभी वर्गो को मिस्र से निकाला। अतः तुम लोगों के सभी वंशजों को यह दिन याद रखना ही होगा। यह नियम ऐसा है जो सदा रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","इसलिए प्रथम महीने निसन के चौदहवें दिन की सन्ध्या से तुम लोग अख़मीरी रोटी खाना आरम्भ करोगे। उसी महीने के इक्कीसवें दिन की सन्ध्या तक तुम ऐसी रोटी खाओगे। ");
INSERT INTO hin2010_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","सात दिन तक तुम लोगों के घरों में कोई ख़मीर नहीं होना चाहिए। कोई भी व्यक्ति चाहे वह इस्राएल का नागरिक हो या विदेशी, जो इस समय ख़मीर खाएगा अन्य इस्राएलियों से अवश्य अलग कर दिया जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","इस पवित्र पर्व में तुम लोगों को ख़मीर नहीं खाना चाहिए। तुम जहाँ भी रहो अख़मीरी रोटी ही खाना।” ");
INSERT INTO hin2010_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","इसलिए मूसा ने सभी बुजुर्गों (नेताओं) को एक स्थान पर बुलाया। मूसा ने उनसे कहा, “अपने परिवारों के लिए मेमने प्राप्त करो। फसह पर्व के लिए मेमने को मारो। ");
INSERT INTO hin2010_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","जूफा के गुच्छों को लो और खून से भरे प्यालों में उन्हें डुबाओ। खून से चौखटों के दोनों पटों और सिरों को रंग दो। कोई भी व्यक्ति सवेरा होने से पहले अपना घर न छोड़े। ");
INSERT INTO hin2010_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","उस समय जब यहोवा पहलौठे सन्तानों को मारने के लिए मिस्र से होकर जाएगा तो वह चौखट के दोनों पटों और सिरों पर खून देखेगा, तब यहोवा उस घर की रक्षा करेगा। यहोवा नाश करने वाले को तुम्हारे घरों के भीतर आने और तुम लोगों को चोट नहीं पहुँचाने देगा। ");
INSERT INTO hin2010_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","तुम लोग इस आदेश को अवश्य याद रखना। यह नियम तुम लोगों तथा तुम लोगों के वंशजों के निमित्त सदा के लिए है। ");
INSERT INTO hin2010_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","तुम लोगों को यह कार्य तब भी याद रखना होगा जब तुम लोग उस देश में पहुँचोगे जो यहोवा तुम लोगों को देगा। ");
INSERT INTO hin2010_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","जब तुम लोगों के बच्चे तुम से पूछेंगे, ‘हम लोग यह त्योहार क्यों मनाते हैं?’ ");
INSERT INTO hin2010_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तो तुम लोग कहोगे, ‘यह फसह पर्व यहोवा की भक्ति के लिए है। क्यों? क्योंकि जब हम लोग मिस्र में थे तब यहोवा इस्राएल के घरों से होकर गुजरा था। यहोवा ने मिस्रियों को मार डाला, किन्तु उसने हम लोगों के घरों में लोगों को बचाया।’” इसलिए लोग अब यहोवा को झुककर प्रणाम करते है तथा उपासना करते हैं। ");
INSERT INTO hin2010_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","यहोवा ने यह आदेश मूसा और हारून को दिया था। इसलिए इस्राएल के लोगों ने वही किया जो यहोवा का आदेश था। ");
INSERT INTO hin2010_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","आधी रात को यहोवा ने मिस्र के सभी पहलौठे पुत्रों, फ़िरौन के पहलौठे पुत्र (जो मिस्र का शासक था) से लेकर बन्दीगृह में बैठे कैदी के पुत्र तक सभी को मार डाला। पहलौठे जानवर भी मर गए। ");
INSERT INTO hin2010_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","मिस्र में उस रात को हर घर में कोई न कोई मरा। फ़िरौन, उसके अधिकारी और मिस्र के सभी लोग ज़ोर से रोने चिल्लाने लगे। ");
INSERT INTO hin2010_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","इसलिए उस रात फ़िरौन ने मूसा और हारून को बुलाया। फ़िरौन ने उनसे कहा, “तैयार हो जाओ और हमारे लोगों को छोड़ कर चले जाओ। तुम और तुम्हारे लोग वैसा ही कर सकते हैं जैसा तुमने कहा है। जाओ और अपने यहोवा की उपासना करो। ");
INSERT INTO hin2010_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","और तुम लोग जैसा तुमने कहा है कि तुम चाहते हो, अपनी भेड़ें और मवेशी अपने साथ ले जा सकते हो, जाओ! और मुझे भी आशीष दो!” ");
INSERT INTO hin2010_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","मिस्र के लोगों ने भी उनसे शीघ्रता से जाने के लिए कहा। क्यों? क्योंकि उन्होंने कहा, “यदि तुम लोग नहीं जाते हो हम सभी मर जाएंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","इस्राएल के लोगों के पास इतना समय न रहा कि वे अपनी रोटी में खमीर डालें। उन्होंने गुँधे आटे की परातों को अपने कपड़ों में लपेटा और अपने कंधों पर रख कर ले गए। ");
INSERT INTO hin2010_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","तब इस्राएल के लोगों ने वही किया जो मूसा ने करने को कहा। वे अपने मिस्री पड़ोसियों के पास गए और उनसे वस्त्र तथा चाँदी और सोने की बनी चीज़ें माँगी। ");
INSERT INTO hin2010_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","यहोवा ने मिस्रियों को इस्राएल के लोगों के प्रति दयालु बना दिया। इसलिए उन्होंने अपना धन इस्राएल के लोगों को दे दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","इस्राएल के लोग रमसिज से सुक्काम गए। वे लगभग छ: लाख पुरुष थे। इसमें बच्चे सम्मिलित नहीं है। ");
INSERT INTO hin2010_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","उनके साथ अनेक भेड़ें, गाय—बकरियाँ और अन्य पशुधन था। उनके साथ ऐसे अन्य लोग भी यात्रा कर रहे थे। जो इस्राएली नहीं थे, किन्तु वे इस्राएल के लोगों के साथ गए। ");
INSERT INTO hin2010_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","किन्तु लोगों को रोटी में खमीर डालने का समय न मिला। और उन्होंने अपनी यात्रा के लिए कोई विशेष भोजन नहीं बनाया। इसलिए उन्हें बिना खमीर के ही रोटियाँ बनानी पड़ीं। ");
INSERT INTO hin2010_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","इस्राएल के लोग मिस्र में चार सौ तीस वर्ष तक रहे। ");
INSERT INTO hin2010_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","चार सौ तीस वर्ष बाद, ठीक उसी दिन, यहोवा की सारी सेना ने मिस्र से प्रस्थान किया। ");
INSERT INTO hin2010_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","वह विशेष रात है जब लोग याद करते हैं कि यहोवा ने क्या किया। इस्राएल के सभी लोग उस रात को सदा याद रखेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","यहोवा ने मूसा और हारून से कहा, “फसह पर्व के नियम ये है: कोई विदेशी फसह पर्व में से नहीं खाएगा। ");
INSERT INTO hin2010_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","किन्तु यदि कोई व्यक्ति दास को खरीदेगा और यदि उसका खतना करेगा तो वह दास उस में से खा सकेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","किन्तु यदि कोई व्यक्ति केवल तुम लोगों के देश में रहता है या किसी व्यक्ति को तुमम्हारे लिए मजदूरी पर रखा गया है तो उस व्यक्ति को उस में से नहीं खाना चाहिए। वह केवल इस्राएल के लोगों के लिए है। ");
INSERT INTO hin2010_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“प्रत्येक परिवार को घर के भीतर ही भोजन करना चाहिए। कोई भी भोजन घर के बाहर नहीं ले जाना चाहिए। मेमने की किसी हड्डी को न तोड़े। ");
INSERT INTO hin2010_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","पूरी इस्राएली जाति इस उत्सव को अवश्य मनाए। ");
INSERT INTO hin2010_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","यदि कोई ऐसा व्यक्ति तुम लोगों के साथ रहता है जो इस्राएल की जाति का सदस्य नहीं है किन्तु वह फसह पर्व में सम्मिलित होना चाहता है तो उसका खतना अवश्य होना चाहिए। तब वह इस्राएल के नागरिक के समान होगा, और वह भोजन में भाग ले सकेगा। किन्तु यदि उस व्यक्ति का खतना नहीं हुआ हो तो वह इस फसह पर्व के भोजन को नहीं खा सकता। ");
INSERT INTO hin2010_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ये ही नियम हर एक पर लागू होंगे। नियमों के लागू होने में इस बात को कोई महत्व नहीं होगा कि वह व्यक्ति तुम्हारे देश का नागरिक है या विदेशी है।” ");
INSERT INTO hin2010_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","इसलिए इस्राएल के सभी लोगों ने उन आदेशों का पालन किया जिन्हें यहोवा ने मूसा और हारून को दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","इस प्रकार यहोवा उसी दिन इस्राएल के सभी लोगों को मिस्र से बाहर ले गया। लोगों ने समूहों में प्रस्थान किया। ");
INSERT INTO hin2010_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“प्रत्येक पहलौठा इस्राएली लड़का मुझे समर्पित होगा। हर एक स्त्री का पहलौठा नर बच्चा मेरा ही होगा। तुम लोग हर एक नर पहलौठा जानवर को भी मुझे समर्पित करना।” ");
INSERT INTO hin2010_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","मूसा ने लोगों से कहा, “इस दिन को याद रखो। तुम लोग मिस्र में दास थे। किन्तु इस दिन यहोवा ने अपनी महान शक्ति का उपयोग किया और तुम लोगों को स्वतन्त्र किया। तुम लोग खमीर के साथ रोटी मत खाना। ");
INSERT INTO hin2010_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","आज के दिन आबीब के महीने में तुम लोग मिस्र से प्रस्थान कर रहे हो। ");
INSERT INTO hin2010_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","यहोवा ने तुम लोगों के पूर्वजों से विशेष प्रतिज्ञा की थी। यहोवा ने तुम लोगों को कनानी, हित्ती, एमोरी, हिब्बी और यबूसी लोगों को धरती देने की प्रतिज्ञा की थी। यहोवा जब तुम लोगों को उस सम्पन्न और सुन्दर देश में पहुँचा दे तब तुम लोग इस दिन को अवश्य याद रखना। तुम लोग हर वर्ष के पहले महीने में इस दिन को उपासना का विशेष दिन रखना। ");
INSERT INTO hin2010_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“सात दिन तक तुम लोग वही रोटी खाना जिसमें ख़मीर न हो। सातवें दिन एक बड़ी दावत होगी। यह दावत यहोवा के सम्मान का सूचक होगी। ");
INSERT INTO hin2010_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","अत: सात दिन तक लोगों को ख़मीर के साथ बनी रोटी खानी नहीं चाहिए। तुम्हारे प्रदेश में किसी भी जगह ख़मीर की कोई रोटी नहीं होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","इस दिन तुम को अपने बच्चों से कहना चाहिए, ‘हम लोग यह दावत इसलिए कर रहे हैं कि यहोवा ने मुझ को मिस्र से बाहर निकाला।’ ");
INSERT INTO hin2010_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“यह पवित्र दिन तुम लोगों को याद रखने में सहायता करेगा अर्थात् तुम लोगों के हाथ पर बंधे धागे का काम करेगा। यह पवित्र दिन यहोवा के उपदेशों को याद करने में तुमको सहायता करेगा। तुम्हें यह याद दिलाने में सहायता करेगा कि यहोवा ने तुम लोगों को मिस्र से बाहर निकालने के लिए अपनी महान शक्ति का उपयोग किया। ");
INSERT INTO hin2010_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","इसलिए हर वर्ष इस दिन को ठीक समय पर याद रखो। ");
INSERT INTO hin2010_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“यहोवा तुम लोगों को उस देश में ले चलेगा जिसे तुम लोगों को देने के लिए उसने प्रतिज्ञा की है। इस समय वहाँ कनानी लोग रहते हैं। किन्तु यहोवा ने तुम से पहले तुम्हारे पूर्वजों से यह प्रतिज्ञा की थी कि वह यह प्रदेश तुम लोगों को देगा। परमेश्वर जब यह प्रदेश तुम को देगा उसके बाद ");
INSERT INTO hin2010_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","तुम लोग अपने हर एक पहलौठे पुत्र को उसे समर्पित करना याद रखना और हर एक पहलौठा नर जानवर यहोवा को अवश्य समर्पित होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","हर एक पहलौठा गधा यहोवा से वापस खरीदा जा सकता है। तुम लोग उसके बदले मेमने को अर्पित कर सकते हो और गधे को वापस ले सकते हो। यदि तुम यहोवा से गधे को खरीदना नहीं चाहते तो इसे मार डालो। यह एक बलि होगी तुम उसकी गर्दन अवश्य तोड़ दो। हर एक पहलौठा लड़का यहोवा से पुनः अवश्य खरीद लिया जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“भविष्य में तुम्हारे बच्चे पूछेंगे कि तुम यह क्यों करते हो? वे कहेंगे, ‘इस सबका क्या मतलब है?’ और तुम उत्तर दोगे, ‘यहोवा ने हम लोगों को मिस्र से बचाने के लिए महान शक्ति का उपयोग किया। हम लोग वहाँ दास थे। किन्तु यहोवा ने हम लोगों को बाहर निकाला और वह यहाँ लाया। ");
INSERT INTO hin2010_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","मिस्र में फ़िरौन हठी था। उसने हम लोगों को प्रस्थान नहीं करने दिया। किन्तु यहोवा ने उस देश के सभी पहलौठे नर सन्तानों को मार डाला। (यहोवा ने पहलौठे नर जानवरों और पहलौठे पुत्रों को मार डाला।) इसलिए हम लोग हर एक पहलौठे नर जानवर को यहोवा को समर्पित करते हैं। और यही कारण है कि हम प्रत्येक पहलौठे पुत्रों को फिर यहोवा से खरीदते हैं।’ ");
INSERT INTO hin2010_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","यह तुम्हारी हाथ पर बँधे धागे की तरह है और यह तुम्हारी आँखों के सामने बँधे चिन्ह की तरह है। यह इसे याद करने में सहायक है कि यहोवा अपनी महान शक्ति से हम लोगों को मिस्र से बाहर लाया।” ");
INSERT INTO hin2010_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","फ़िरौन ने लोगों को मिस्र छोड़ने के लिए विवश किया। यहोवा ने लोगों को समुद्र के तट की सड़क को नहीं पकड़ने दिया। वह सड़क पलिश्ती तक का सबसे छोटा रास्ता है, किन्तु यहोवा ने कहा, “यदि लोग उस रास्ते से जाएंगे तो उन्हें लड़ना पड़ेगा। तब वे अपना मन बदल सकते हैं और मिस्र को लौट सकते है।” ");
INSERT INTO hin2010_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","इसलिए यहोवा उन्हें अन्य रास्ते से ले गया। वह लाल सागर की तटीय मरुभूमि से उन्हें ले गया। किन्तु इस्राएल के लोग तब युद्ध के लिए वस्त्र पहने थे जब उन्होंने मिस्र छोड़ा। ");
INSERT INTO hin2010_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","मूसा यूसुफ़ की अस्थियों को अपने साथ ले गया। (मरने के पहले यूसुफ़ ने इस्राएल की सन्तानों से प्रतिज्ञा कराई कि वे वह करेंगे। मरने के पहले यूसुफ़ ने कहा, “जब परमेश्वर तुम लोगों को बचाए, मेरी अस्थियों को मिस्र के बाहर अपने साथ ले जाना याद रखना।”) ");
INSERT INTO hin2010_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","इस्राएल के लोगों ने सुक्कोत नगर छोड़ा और एताम में डेरा डाला। एताम मरुभूमि के छोर पर था। ");
INSERT INTO hin2010_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","यहोवा ने रास्ता दिखाया। दिन में यहोवा ने एक बड़े बादल का उपयोग लोगों को ले चलने के किया। और रात में यहोवा ने रास्ता दिखाने के लिए एक ऊँचे अग्नि स्तम्भ का उपयोग किया। यह आग उन्हें प्रकाश देती थी अतः वे रात को भी यात्रा कर सकते थे। ");
INSERT INTO hin2010_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","एक ऊँचे स्तम्भ के रूप में बादल सदा उनके साथ दिन में रहा और रात को अग्नि स्तम्भ सदा उनके साथ रहा। ");
INSERT INTO hin2010_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“लोगों से पीहाहीरोत तक पीछे मुड़कर यात्रा करने को कहो। रात में मिगदोल और समुद्र के बीच उनसे ठहरने को कहो। यह बाल सपोन के करीब है। ");
INSERT INTO hin2010_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","फ़िरौन सोचेगा कि इस्राएल के लोग मरुभूमि में भटक गए है और वह सोचेगा कि लोगों को कोई स्थान नहीं मिलेगा जहाँ वे जाए। ");
INSERT INTO hin2010_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","मैं फ़िरौन की हिम्मत बढ़ाऊँगा ताकि वह तुम लोगों का पीछा करे। किन्तु फ़िरौन और उसकी सेना को हराऊँगा। इससे मुझे गौरव प्राप्त होगा। तब मिस्र के लोग जानेंगे कि मैं ही यहोवा हूँ।” इस्राएल के लोगों ने परमेश्वर का आदेश माना अर्थात् उन्होंने वही किया जो उसने कहा। ");
INSERT INTO hin2010_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","तब फ़िरौन को यह सूचना मिली कि इस्राएल के लोग भाग गए हैं तो उसने और उसके अधिकारियों ने उन्हें वहाँ से चले जाने देने का जो वचन दिया था, उसके प्रति अपना मन बदल दिया। फ़िरौन ने कहा, “हमने इस्राएल के लोगों को क्यों जाने दिया? हमने उन्हें भागने क्यों दिया? अब हमारे दास हमारे हाथों से निकल चुके हैं।” ");
INSERT INTO hin2010_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","इसलिए फ़िरौन ने अपने युद्ध रथ को तैयार किया और अपनी सेना को साथ लिया। ");
INSERT INTO hin2010_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","फ़िरौन ने अपने लोगों में से छः सौ सबसे अच्छे आदमियों तथा अपने सभी रथों को लिया। हर एक रथ में एक अधिकारी बैठा था। ");
INSERT INTO hin2010_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","इस्राएल के लोग विजय के उत्साह में अपने शस्त्रों को ऊपर उठाए जा रहे थे किन्तु यहोवा ने मिस्र के राजा फिरौन को साहसी बनाया। और फ़िरौन ने इस्राएल के लोगों का पीछा करना शुरु कर दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","मिस्री सेना के पास बहुत से घोड़े, सैनिक और रथ थे। उन्होंने इस्राएल के लोगों का पीछा किया और उस समय जब वे लाल सागर के तट पर पीहाहीरोत में, बालसपोन के पूर्व में डेरा डाले थे, वे उनके समीप आ गए। ");
INSERT INTO hin2010_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","इस्राएल के लोगों ने फिरौन और उसकी सेना को अपनी ओर आते देखा तो लोग बुरी तरह डर गए। उन्होंने सहायता के लिए यहोवा को पुकारा। ");
INSERT INTO hin2010_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","उन्होंने मूसा से कहा, “तुम हम लोगों को मिस्र से बाहर क्यों लाए? तुम हम लोगों को इस मरुभूमि में मरने के लिए क्यों ले आए? हम लोग शान्तिपूर्वक मिस्र में मरते, मिस्र में बहुत सी कब्रें थी। ");
INSERT INTO hin2010_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","हम लोगों ने कहा था कि ऐसा होगा। मिस्र में हम लोगों ने कहा था, ‘कृपया हम लोगों को कष्ट न दो। हम लोगों को यहीं ठहरने और मिस्रियों की सेवा करने दो।’ यहाँ आकर मरुभूमि में मरने से अच्छा यह होता कि हम लोग वहीं मिस्रियों के दास बनकर रहते।” ");
INSERT INTO hin2010_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","किन्तु मूसा ने उत्तर दिया, “डरो नही! भागो नहीं! रूक जाओ! ज़रा ठहरो और देखो कि आज तुम लोगों को यहोवा कैसे बचाता है। आज के बाद तुम लोग इन मिस्रियों को कभी नहीं देखोगे! ");
INSERT INTO hin2010_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","तुम लोगों को शान्त रहने के अतिरिक्त और कुछ नहीं करना है। यहोवा तुम लोगों के लिए लड़ता रहेगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","तब यहोवा ने मूसा से कहा, “तुम्हें मुझको पुकारना नहीं पड़ेगा; इस्राएल के लोगों को आगे चलने का आदेश दो। ");
INSERT INTO hin2010_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","अपने हाथ की लाठी को लाल सागर के ऊपर उठाओ और लाल सागर फट जाएगा। तब लोग सूखी भूमि से समुद्र को पार कर सकेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","मैंने मिस्रियों को साहसी बनाया है। इस प्रकार वे तुम्हारा पीछा करेंगे। किन्तु मैं दिखाऊँगा कि मैं फ़िरौन, उसके सभी घुड़सवारों और रथों से अधिक शक्तिशाली हूँ। ");
INSERT INTO hin2010_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","तब मिस्री समझेंगे कि मैं यहोवा हूँ। जब मैं फ़िरौन, उसके घुड़सवारों और रथों को हराऊँगा वे तब मुझे सम्मान देंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","उस समय यहोवा का दूत लोगों के पीछे गया। (यहोवा का दूत प्रायः लोगों के आगे था और उन्हें ले जा रहा था)। इसलिए बादल का स्तम्भ लोगों के आगे से हट गया और उनके पीछे आ गया। ");
INSERT INTO hin2010_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","इस प्रकार बादल मिस्रियों और इस्राएलियों के बीच खड़ा हुआ। इस्राएल के लोगों के लिए प्रकाश था किन्तु मिस्रियों के लिए अँधेरा। इसलिए मिस्री उस रात इस्राएलियों के अधिक निकट न आ सके। ");
INSERT INTO hin2010_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","मूसा ने अपनी बाहें लाल सागर के ऊपर उठाई। और यहोवा ने पूर्व से तेज आँधी चला दी। आँधी रात भर चलती रही। समुद्र फटा और पुरवायी हवा ने जमीन को सुखा दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","इस्राएल के लोग सूखी जमीन पर चलकर समुद्र के पार गए। उनकी दायीं और बाईं ओर पानी दीवार की तरह खड़ा था। ");
INSERT INTO hin2010_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","तब फ़िरौन के सभी रथों और घुड़सवारों ने समुद्र में उनका पीछा किया। ");
INSERT INTO hin2010_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","बहुत सवेरे ही यहोवा ने लम्बे बादल और आग के स्तम्भ पर से मिस्र की सेना को देखा और यहोवा ने उन पर हमला किया और उन्हें हरा दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","रथों के पहिए धंस गए। रथों का नियन्त्रण कठिन हो गया। मिस्री चिल्लाए, “हम लोग यहाँ से निकल चलें। यहोवा हम लोगों के विरुद्ध लड़ रहा है। यहोवा इस्राएल के लोगों के लिए लड़ रहा है।” ");
INSERT INTO hin2010_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","तब यहोवा ने मूसा से कहा, “अपने हाथ को समुद्र के ऊपर उठाओ। फिर पानी गिरेगा तथा मिस्री रथों और घुड़सवारों को डूबो देगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","इसलिए ठीक दिन निकलने से पहले मूसा ने अपना हाथ समुद्र के ऊपर उठाया और पानी अपने उचित तल पर वापस पहुँच गया। मिस्री भागने का प्रयत्न कर रहे थे। किन्तु यहोवा ने मिस्रियों को समुद्र में बहा कर डूबो दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","पानी अपने उचित तल तक लौटा और उसने रथों तथा घुड़सवारों को ढक लिया। फ़िरौन की पूरी सेना जो इस्राएली लोगों का पीछा कर रही थी, डूबकर नष्ट हो गई। उनमें से कोई भी न बचा! ");
INSERT INTO hin2010_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","किन्तु इस्राएल के लोगों ने सूखी जमीन पर चलकर समुद्र पार किया। उनकी दायीं और बायीं ओर पानी दीवार की तरह खड़ा था। ");
INSERT INTO hin2010_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","इसलिए उस दिन यहोवा ने इस्राएल के लोगों को मिस्रियों से बचाया और इस्राएल के लोगों ने मिस्रियों के शवों को लाल सागर के किनारे देखा। ");
INSERT INTO hin2010_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","इस्राएल के लोगों ने यहोवा की महान शक्ति को देखा जब उसने मिस्रियों को हराया। अत: लोगों ने यहोवा का भय माना और सम्मान किया और उन्होंने यहोवा और उसके सेवक मूसा पर विश्वास किया। ");
INSERT INTO hin2010_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","तब मूसा और इस्राएल के लोग यहोवा के लिए यह गीत गाने लगे: “मैं यहोवा के लिए गाऊँगा क्योंकि उसने महान काम किये है। उसने घोड़ों और सवारों को समुद्र में फेंका है। ");
INSERT INTO hin2010_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","यहोवा ही मेरी शक्ति है। वह हमें बचाता है और मैं गाता हूँ गीत उसकी प्रशंसा के। मेरा परमेश्वर यहोवा है और मैं उसकी स्तुति करता हूँ। मेरे पूर्वजों का परमेश्वर यहोवा है और मैं उसका आदर करता हूँ। ");
INSERT INTO hin2010_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","यहोवा महान योद्धा है। उसका नाम यहोवा है। ");
INSERT INTO hin2010_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","उसने फ़िरौन के रथ और सैनिकों को समुद्र में फेंक दिया। फ़िरौन के उत्तम अधिकारी लाल सागर में डूब गए। ");
INSERT INTO hin2010_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","गहरे पानी ने उन्हें ढका। वे चट्टानों की तरह गहरे पानी में डूबे। ");
INSERT INTO hin2010_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“तेरी दायीं भुजा अद्भुत शक्तिशाली है। यहोवा, तेरी दायीं भुजा ने शत्रु को चकनाचूर कर दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","तूने अपनी महामहिम में नष्ट किया उन्हें जो व्यक्ति तेरे विरुद्ध खड़े हुए। तेरे क्रोध ने उन्हें उस प्रकार नष्ट किया जैसे आग तिनके को जलाती है। ");
INSERT INTO hin2010_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","तूने जिस तेज आँधी को चलाया, उसने जल को ऊँचा उठाया। वह तेज़ बहता जल ठोस दीवार बना। समुद्र ठोस बन गया अपने गहरे से गहरे भाग तक। ");
INSERT INTO hin2010_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“शत्रु ने कहा, ‘मैं उनका पीछा करूँगा और उनको पकड़ूँगा। मैं उनका सारा धन लूँगा। मैं अपनी तलवार चलाऊँगा और उनसे हर चीज़ लूँगा। मैं अपने हाथों का उपयोग करूँगा और अपने लिए सब कुछ लूँगा।’ ");
INSERT INTO hin2010_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","किन्तु तू उन पर टूट पड़ा और उन्हें समुद्र से ढक दिया तूने वे सीसे की तरह डूबे गहरे समुद्र में। ");
INSERT INTO hin2010_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“क्या कोई देवता यहोवा के समान है? नहीं! तेरे समान कोई देवता नहीं, तू है अद्भुत अपनी पवित्रता में! तुझमें है विस्मयजनक शक्ति तू अद्भुत चमत्कार करता है! ");
INSERT INTO hin2010_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","तू अपना दाँया हाथ उठा कर संसार को नष्ट कर सकता था! ");
INSERT INTO hin2010_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","परन्तु तू कृपा कर उन लोगों को ले चला जिन्हें तूने बचाया है। तू अपनी शक्ति से इन लोगों को अपने पवित्र और सुहावने देश को ले जाता है। ");
INSERT INTO hin2010_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","“अन्य राष्ट्र इस कथा को सुनेंगे और वे भयभीत होंगे। पलिश्ती लोग भय से काँपेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","तब एदोम के मुखिया भय से काँपेंगे मोआब के शक्तिशाली नेता भय से काँपेंगे, कनान के व्यक्ति अपना साहस खो देंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","वे लोग आतंक और भय से आक्रान्त होंगे जब वे तेरी शक्ति देखेंगे। वे चट्टान के समान शान्त रहेंगे जब तक तुम्हारे लोग गुज़रेंगे जब तक तेरे द्वारा लाए गए लोग गुज़रेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","यहोवा अपने लोगों को स्वयं ले जाएगा अपने पर्वत पर उस स्थान तक जिसे तूने अपने सिंहासन के लिए बनाया है। हे स्वामी, तू अपना मन्दिर अपने हाथों बनायेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“यहोवा सदा सर्वदा शासन करता रहेगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","हाँ, ये सचमुच हुआ! फ़िरौन के घोड़े, सवार और रथ समुद्र में चले गए और यहोवा ने उन्हें समुद्र के पानी से ढक दिया। किन्तु इस्राएल के लोग सूखी ज़मीन पर चलकर समुद्र के पार चले गए। ");
INSERT INTO hin2010_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","तब हारून की बहन नबिया मरियम ने एक डफली ली। मरियम और स्त्रियों ने नाचना, गाना आरम्भ किया। मरियम की टेक थी, ");
INSERT INTO hin2010_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","“यहोवा के लिए गाओ क्योंकि उसने महान काम किए हैं। फेंका उसने घोड़े को और उसके सवार को सागर के बीच में।” ");
INSERT INTO hin2010_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","मूसा इस्राएल के लोगों को लाल सागर से दूर ले जाता रहा, लोग शूर मरुभूमि में पहुँचे। वे तीन दिन तक मरुभूमि में यात्रा करते रहे। लोग तनिक भी पानी न पा सके। ");
INSERT INTO hin2010_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","तीन दिन के बाद लोगों ने मारा की यात्रा की। मारा में पानी था, किन्तु पानी इतना कड़वा था कि लोग पी नहीं सकते थे। (यही कारण था कि इस स्थान का नाम मारा पड़ा।) ");
INSERT INTO hin2010_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","लोगों ने मूसा से शिकायत शुरु की। लोगों ने कहा, “अब हम लोग क्या पीएं?” ");
INSERT INTO hin2010_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","मूसा ने यहोवा को पुकारा। इसलिए यहोवा ने उसे एक पेड़ दिखाया। मूसा ने पेड़ को पानी में डाला। जब उसने ऐसा किया, पानी अच्छा पीने योग्य हो गया। उस स्थान पर यहोवा ने लोगों की परीक्षा ली और उन्हें एक नियम दिया। यहोवा ने लोगों के विश्वास की जाँच की। ");
INSERT INTO hin2010_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","यहोवा ने कहा, “तुम लोगों को अपने परमेश्वर यहोवा का आदेश अवश्य मानना चाहिए। तुम लोगों को वह करना चाहिए जिसे वह ठीक कहता है। यदि तुम लोग यहोवा के आदेशों और नियमों का पालन करोगे तो तुम लोग मिस्रियों की तरह बीमार नहीं होगे। मैं तुम्हारा यहोवा तुम लोगों को कोई ऐसी बीमारी नहीं दूँगा जैसी मैंने मिस्रियों को दी। मैं यहोवा हूँ। मैं ही वह हूँ जो तुम्हें स्वस्थ बनाता है।” ");
INSERT INTO hin2010_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","तब लोगों ने एलीम तक की यात्रा की। एलीम में पानी के बारह सोते थे। और वहाँ सत्तर खजूर के पेड़ थे। इसलिए लोगों ने वहाँ पानी के निकट डेरा डाला। ");
INSERT INTO hin2010_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","तब लोगों ने एलीम से यात्रा की और सीनै मरुभूमि में पहुँचे। यह स्थान एलीम और सीनै के बीच था। वे इस स्थान पर दूसरे महीने के पन्द्रहवें दिन मिस्र छोड़ने के बाद पहुँचे। ");
INSERT INTO hin2010_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","तब इस्राएल के लोगों ने फिर शिकायत करनी शुरु की। उन्होंने मूसा और हारुन से मरुभूमि में शिकायत की। ");
INSERT INTO hin2010_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","लोगों ने मूसा और हारुन से कहा, “यह हमारे लिए अच्छा होता कि यहोवा ने हम लोगों को मिस्र में मार डाला होता। मिस्र में हम लोगों के पास खाने को बहुत था। हम लोगों के पास वह सारा भोजन था जिसकी हमें आवश्यकता थी। किन्तु अब तुम हमें मरुभूमि में ले आये हो। हम सभी यहाँ भूख से मर जाएंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","तब यहोवा ने मूसा से कहा, “मैं आकाश से भोजन गिराऊँगा। वह भोजन तुम लोगों के खाने के लिए होगा। हर एक दिन लोग बाहर जायें और उस दिन खाने के जरूरत के लिए भोजन इकट्ठा करें। मैं यह इसलिए करूँगा कि मैं देखूँ कि क्या लोग वही करेंगे जो मैं करने को कहूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","हर एक दिन लोग प्रत्येक दिन के लिए पर्याप्त भोजन इकट्ठा करें। किन्तु शुक्रवार को जब भोजन तैयार करने लगे तो देखें कि वे दो दिन के लिए पर्याप्त भोजन रखते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","इसलिए मूसा और हारून ने इस्राएल के लोगों से कहा, “आज की रात तुम लोग यहोवा की शक्ति देखोगे। तुम लोग जानोगे कि एक मात्र वह ही ऐसा है जिसने तुम लोगों को मिस्र देश से बचा कर बाहर निकाला। ");
INSERT INTO hin2010_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","कल सवेरे तुम लोग यहोवा की महिमा देखोगे। तुम लोगों ने यहोवा से शिकायत की। उसने तुम लोगों की सुनी। तुम लोग हम लोगों से शिकायत पर शिकायत कर रहे हो। संभव है कि हम लोग अब कुछ आराम कर सकें।” ");
INSERT INTO hin2010_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","और मूसा ने कहा, “तुम लोगों ने शिकायत की और यहोवा ने तुम लोगों कि शिकायतें सुन ली है। इसलिए रात को यहोवा तुम लोगों को माँस देगा और हर सवेरे तुम लोग वह सारा भोजन पाओगे, जिसकी तुम को ज़रुरत है। तुम लोग मुझसे और हारून से शिकायत करते रहे हो। याद रखो तुम लोग मेरे और हारून के विरुद्ध शिकायत नहीं कर रहे हो। तुम लोग यहोवा के विरुद्ध शिकायत कर रहे हो।” ");
INSERT INTO hin2010_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","तब मूसा ने हारून से कहा, “इस्राएल के लोगों को सम्बोधित करो। उनसे कहो, ‘यहोवा के सामने इकट्ठे हों क्योंकि उसने तुम्हारी शिकायतें सुनी हैं।’” ");
INSERT INTO hin2010_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","हारून ने इस्राएल के सभी लोगों को सम्बोधित किया। वे सभी एक स्थान पर इकट्ठे थे। जब हारून बातें कर रहा था तभी लोग मुड़े और उन्होंने मरूभूमि की ओर देखा और उन्होंने यहोवा की महिमा को बादल में प्रकट होते देखा। ");
INSERT INTO hin2010_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“मैंने इस्राएल के लोगों की शिकायत सुनी है। इसलिए उनसे मेरी बातें कहो। मैं कहता हूँ, ‘आज साँझ को तुम माँस खाओगे और कल सवेरे तुम लोग भरपेट रोटियाँ खाओगे, तब तुम लोग जानोगे कि तुम लोग अपने परमेश्वर यहोवा पर विश्वास कर सकते हो।’” ");
INSERT INTO hin2010_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","उस रात बटेरें (पक्षियाँ) डेरे के चारों ओर आईं। लोगों ने इन बटेरों को माँस के लिए पकड़ा। सवेरे डेरे के पास ओस पड़ी होती थी। ");
INSERT INTO hin2010_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","सूरज के निकलने पर ओस पिघल जाती थी किन्तु ओस के पिघलने पर पाले की तह की तरह ज़मीन पर कुछ रह जाता था। ");
INSERT INTO hin2010_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","इस्राएल के लोगों ने इसे देखा और परस्पर कहा, “वह क्या है?” उन्होंने यह प्रश्न इसलिए पूछा कि वे नहीं जानते थे कि वह क्या चीज है। इसलिए मूसा ने उनसे कहा, “यह भोजन है जिसे यहोवा तुम्हें खाने को दे रहा है। ");
INSERT INTO hin2010_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","यहोवा कहता है, ‘हर व्यक्ति उतना इकट्ठा करे जितना उसे आवश्यक है। तुम लोगों में से हर एक लगभग दो क्वार्ट अपने परिवार के हर व्यक्ति के लिए इकट्ठा करें।’” ");
INSERT INTO hin2010_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","इसलिए इस्राएल के लोगों ने ऐसा ही किया। हर व्यक्ति ने इस भोजन को इकट्ठा किया। कुछ व्यक्तियों ने अन्य लोगों से अधिक इकट्ठा किया। ");
INSERT INTO hin2010_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","उन लोगों ने अपने परिवार के हर एक व्यक्ति को भोजन दिया। जब भोजन नापा गया तो हर एक व्यक्ति के लिए सदा पर्याप्त रहा, किन्तु कभी भी आवश्यकता से अधिक नहीं हुआ। हर व्यक्ति ने ठीक अपने लिए तथा अपने परिवार के खाने के लिए पर्याप्त इकट्ठा किया। ");
INSERT INTO hin2010_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","मूसा ने उनसे कहा, “अगले दिन खाने के लिए वह भोजन मत बचाओ।” ");
INSERT INTO hin2010_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","किन्तु लोगों ने मूसा की बात न मानी। कुछ लोगों ने अपना भोजन बचाया जिससे वे उसे अगले दिन खा सकें। किन्तु जो भोजन बचाया गया था उसमें कीड़े पड़ गए और वह दुर्गन्ध देने लगा। मूसा उन लोगों पर क्रुद्ध हुआ जिन्होंने यह किया था। ");
INSERT INTO hin2010_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","हर सवेरे लोग भोजन इकट्ठा करते थे। हर एक व्यक्ति उतना इकट्ठा करता था जितना वह खा सके। किन्तु जब धूप तेज होती थी भोजन गल जाता था और वह समाप्त हो जाता था। ");
INSERT INTO hin2010_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","शुक्रवार को लोगों ने दुगना भोजन इकट्ठा किया। उन्होंने चार र्क्वाट हर व्यक्ति के लिए इकट्ठ किया। इसलिए लोगों के सभी मुखिया आए और उन्होंने यह बात मूसा से कही। ");
INSERT INTO hin2010_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","मूसा ने उनसे कहा, “यह वैसा ही है जैसा यहोवा ने बताया था। क्यों? क्योंकि कल यहोवा के आराम का पवित्र दिन सब्त है। तुम लोग आज के लिए जितना भोजन तुम्हें चाहिए पका सकते हो। किन्तु शेष भोजन कल सवेरे के लिए बचाना।” ");
INSERT INTO hin2010_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","इसलिए लोगों ने अगले दिन के लिए बाकी भोजन बचाया और कोई भोजन खराब नहीं हुआ और इनमें कहीं कोई कीड़े नहीं पड़े। ");
INSERT INTO hin2010_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","शनिवार को मूसा ने लोगों से कहा, “आज यहोवा को समर्पित आराम का पवित्र दिन सब्त है। इसलिए तुम लोगों में से कल कोई भी खेत में बाहर नहीं होगा। कल का इकट्ठा भोजन खाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","तुम लोगों को छः दिन भोजन इकट्ठा करना चाहिए। किन्तु सातवाँ दिन आराम का दिन है इसलिए जमीन पर कोई विशेष भोजन नहीं होगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","शनिवार को कुछ लोग थोड़ा भोजन एकत्र करने गए, किन्तु वे वहाँ ज़रा सा भी भोजन नहीं पा सके। ");
INSERT INTO hin2010_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","तब यहोवा ने मूसा से कहा, “तुम्हारे लोग मेरे आदेश का पालन करने और उपदेशों पर चलने से कब तक मना करेंगे? ");
INSERT INTO hin2010_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","देखो यहोवा ने शनिवार को तुम्हारे आराम का दिन बनाया है। इसलिए शुक्रवार को यहोवा दो दिन के लिए पर्याप्त भोजन तुम्हें देगा। इसलिए सब्त को हर एक को बैठना और आराम करना चाहिए। वहीं ठहरे रहो जहाँ हो।” ");
INSERT INTO hin2010_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","इसलिए लोगों ने सब्त को आराम किया। ");
INSERT INTO hin2010_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इस्राएली लोगों ने इस विशेष भोजन को “मन्ना” कहना आरम्भ किया। मन्ना छोटे सफ़ेद धनिया के बीजों के समान था और इसका स्वाद शहद के साथ बने पापड़ की तरह था। ");
INSERT INTO hin2010_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","तब मूसा ने कहा, “यहोवा ने आदेश दिया कि, ‘इस भोजन का आठ प्याले भर अपने वंशजों के लिए बचाना। तब वे उस भोजन को देख सकेंगे जिसे मैंने तुम लोगों को मरुभूमि में तब दिया था जब मैंने तुम लोगों को मिस्र से निकाला था।’” ");
INSERT INTO hin2010_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","इसलिए मूसा ने हारून से कहा, “एक घड़ा लो और इसे आठ प्याले मन्ना से भरो और इस मन्ना को यहोवा के सामने रखने के लिए और अपने वंशजों के लिए बचाओ।” ");
INSERT INTO hin2010_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","(इसलिए हारून ने वैसा ही किया जैसा यहोवा ने मूसा को आदेश दिया था। हारून ने आगे चलकर मन्ना के घड़े को साक्षीपत्र के सन्दूक के सामने रखा।) ");
INSERT INTO hin2010_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","लोगों ने चालीस वर्ष तक मन्ना खाया। वे मन्ना तब तक खाते रहे जब तक उस प्रदेश में नहीं आ गए जहाँ उन्हें बसना था। वे उसे तब तक खाते रहे जब तक वे कनान के निकट नहीं आ गए। ");
INSERT INTO hin2010_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(वे मन्ना के लिए जिस तोल का उपयोग करते थे, वह ओमेर था। एक ओमेर लगभग आठ प्यालों के बराबर था।) ");
INSERT INTO hin2010_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","इस्राएल के सभी लोगों ने सीन की मरुभूमि से एक साथ यात्रा की। वे यहोवा जैसा आदेश देता रहा, एक स्थान से दूसरे स्थान की यात्रा करते रहे। लोगों ने रपीदीम की यात्रा की और वहाँ उन्होंने डेरा डाला। वहाँ लोगों के पीने के लिए पानी न था। ");
INSERT INTO hin2010_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","इसलिए वे मूसा के विरुद्ध हो गए और उससे बहस करने लगे। लोगों ने कहा, “हमें पीने के लिए पानी दो।” किन्तु मूसा ने उनसे कहा, “तुम लोग मेरे विरुद्ध क्यों हो रहे हो? तुम लोग यहोवा की परीक्षा क्यों ले रहे हो? क्या तुम लोग समझते हो कि यहोवा हमारे साथ नहीं है?” ");
INSERT INTO hin2010_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","किन्तु लोग बहुत प्यासे थे। इसलिए उन्होंने मूसा से शिकायत जारी रखी। लोगों ने कहा, “हम लोगों को तुम मिस्र से बाहर क्यों लाए? क्या तुम इसलिए लाए कि पानी के बिना हमको, हमारे बच्चों को और हमारी गाय, बकरियों को प्यासा मार डालो?” ");
INSERT INTO hin2010_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","इसलिए मूसा ने यहोवा को पुकारा, “मैं इन लोगों के साथ क्या करूँ? ये मुझे मार डालने को तैयार है।” ");
INSERT INTO hin2010_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","यहोवा ने मूसा से कहा, “इस्राएल के लोगों के पास जाओ और उनके कुछ बुजुर्गों (नेताओं) को अपने साथ लो। अपनी लाठी अपने साथ ले जाओ। यह वही लाठी है जिसे तुमने तब उपयोग में लिया था जब नील नदी पर इससे चोट की थी। ");
INSERT INTO hin2010_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","होरेब (सीनै) पहाड़ पर मैं तुम्हारे सामने एक चट्टान पर खड़ा होऊँगा। लाठी को चट्टान पर मारो और इससे पानी बाहर आ जाएगा। तब लोग पी सकते हैं।” मूसा ने वही बातें कीं और इस्राएल के बुजुर्गों (नेताओं) ने इसे देखा। ");
INSERT INTO hin2010_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","मूसा ने इस स्थान का नाम मरीबा और मस्सा रखा। क्योंकि यह वह स्थान था जहाँ इस्राएल के लोग उसके विरुद्ध हुए और उन्होंने यहोवा की परीक्षा ली थी। लोग यह जानना चाहते थे कि यहोवा उनके साथ है या नहीं। ");
INSERT INTO hin2010_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","अमालेकी लोग रपीदीम आए और इस्राएल के लोगों के विरुद्ध लड़े। ");
INSERT INTO hin2010_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","इसलिए मूसा ने यहोशू से कहा, “कुछ लोगों को चुनों और अगले दिन अमालेकियों से जाकर लड़ो। मैं पर्वत की चोटी पर खड़ा होकर तुम्हें देखूँगा। मैं परमेश्वर द्वारा दी गई छड़ी को पकड़े रहूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","यहोशू ने मूसा की आज्ञा मानी और अगले दिन अमालेकियों से लड़ने गया। उसी समय मूसा, हारून और हूर पहाड़ी की चोटी पर गए। ");
INSERT INTO hin2010_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","जब कभी मूसा अपने हाथ को हवा में उठाता तो इस्राएल के लोग युद्ध जीत लेते। किन्तु जब मूसा अपने हाथ को नीचे करता तो इस्राएल के लोग युद्ध में हारने लगते। ");
INSERT INTO hin2010_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","कुछ समय बाद मूसा की बाहें थक गई। मूसा के साथ के लोग ऐसा उपाय करना चाहते थे, जिससे मूसा की बाहें हव में रह सकें। इसलिए उन्होंने एक बड़ी चट्टान मूसा के नीचे बैठने के लिए रखी तथा हारून और हूर ने मूसा की बाहों को हवा में पकड़े रखा। हारून मूसा की एक ओर था तथा हूर दूसरी ओर। वे उसके हाथों को वैसे ही ऊपर तब तक पकड़े रहे जब तक सूरज नहीं डूबा। ");
INSERT INTO hin2010_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","इसलिए यहोशू और उसके सैनिकों ने अमालेकियों को इस युद्ध में हरा दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","तब यहोवा ने मूसा से कहा, “इस युद्ध के बारे में लिखो। इस युद्ध की घटनाओं को एक पुस्तक में लिखो जिससे लोग याद करेंगे कि यहाँ क्या हुआ था और यहोशू से कहो कि मैं अमालेकी लोगों को धरती से पूर्णरूप से नष्ट कर दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","तब मूसा ने एक वेदी बनायी। मूसा ने वेदी का नाम “यहोवा निस्सी” रखा। ");
INSERT INTO hin2010_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","मूसा ने कहा, “मैंने यहोवा के सिंहासन की ओर अपने हाथ फैलाए। इसलिए यहोवा अमालेकी लोगों से लड़ा जैसा उसने सदा किया है।” ");
INSERT INTO hin2010_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","मूसा का ससुर यित्रो मिद्यान में याजक था। परमेश्वर ने मूसा और इस्राएल के लोगों की अनेक प्रकार से जो सहायता की उसके बारे में यित्रो ने सुना। यित्रो ने इस्राएल के लोगों को यहोवा द्वारा मिस्र से बाहर ले जाए जाने के बारे में सुना। ");
INSERT INTO hin2010_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","इसलिए यित्रो मूसा के पास गया जब वह परमेश्वर के पर्वत के पास डेरा डाले था। वह मूसा की पत्नी सिप्पोरा को अपने साथ लाया। (सिप्पोरा मूसा के साथ नहीं थी क्योंकि मूसा ने उसे उसके घर भेज दिया था।) ");
INSERT INTO hin2010_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","यित्रो मूसा के दोनो पुत्रों को भी साथ लाया। पहले पुत्र का नाम गेर्शोम रखा क्योंकि जब वह पैदा हुआ, मूसा ने कहा, “मैं विदेश में अजनबी हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","दूसरे पुत्र का नाम एलीएजेर रखा क्योंकि जब वह उत्पन्न हुआ तो मूसा ने कहा, “मेरे पिता के परमेश्वर ने मेरी सहायता की और मिस्र के राजा की तलवार से मुझे बचाया है।” ");
INSERT INTO hin2010_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","इसलिए यित्रो मूसा के पास तब गया जब वह परमेश्वर के पर्वत (सीनै पर्वत) के निकट मरुभूमि में डेरा डाले था। मूसा की पत्नी और उसके दो पुत्र यित्रो के साथ थे। ");
INSERT INTO hin2010_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","यित्रो ने मूसा को एक सन्देश भेजा। यित्रो ने कहा, “मैं तुम्हारा ससुर यित्रो हूँ और मैं तुम्हारी पत्नी और उसके दोनों पुत्रों को तुम्हारे पास ला रहा हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","इसलिए मूसा अपने ससुर से मिलने गया। मूसा उसके सामने झुका और उसे चूमा। दोनों लोगों ने एक दूसरे का कुशल क्षेम पूछा। तब वे मूसा के डेरे में और अधिक बातें करने गए। ");
INSERT INTO hin2010_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","मूसा ने अपने ससुर यित्रो को हर एक बात बताई जो यहोवा ने इस्राएल के लोगों के लिए की थी। मूसा ने वे चीज़ें भी बताई जो यहोवा ने फ़िरौन और मिस्र के लोगों के लिए की थीं। मूसा ने रास्ते की सभी समस्याओं के बारे में बताया और मूसा ने अपने ससुर को बताया कि किस तरह यहोवा ने इस्राएली लोगों को बचाया, जब—जब वे कष्ट में थे। ");
INSERT INTO hin2010_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","यित्रो उस समय बहुत प्रसन्न हुआ जब उसने यहोवा द्वारा इस्राएल के लिए की गई सभी अच्छी बातों को सुना। यित्रो इसलिए प्रसन्न था कि यहोवा ने इस्राएल के लोगों को मिस्रियों से स्वतन्त्र कर दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","यित्रो ने कहा, “यहोवा की स्तुति करो! उसने तुम्हें मिस्र के लोगों से स्वतन्त्र कराया। यहोवा ने तुम्हें फ़िरौन से बचाया है। ");
INSERT INTO hin2010_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","अब मैं जानता हूँ कि यहोवा सभी देवताओं से महान है, उन्होंने सोचा कि सबकुछ उनके काबू में है लेकिन देखो, परमेश्वर ने क्या किया!” ");
INSERT INTO hin2010_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","तब यित्रो ने परमेश्वर के सम्मान में बलि तथा भेंटे दीं। तब हारून तथा इस्राएल के सभी बुजुर्ग (नेता) मूसा के ससुर यित्रो के साथ भोजन करने आए। यह उन्होंने परमेश्वर की उपासना की विशेष विधि के रूप में किया। ");
INSERT INTO hin2010_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","अगले दिन मूसा लोगों का न्याय करने वाला था। वहाँ लोगों की संख्या बहुत अधिक थी। इस कारण लोगों को मूसा के सामने सारे दिन खड़ा रहना पड़ा। ");
INSERT INTO hin2010_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","यित्रो ने मूसा को न्याय करते देखा। उसने पूछा, “तुम ही यह क्यों कर रहे हो? एक मात्र न्यायाधीश तुम्हीं क्यों हो? और लोग केवल तुम्हारे पास ही सारे दिन क्यों आते हैं?” ");
INSERT INTO hin2010_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","तब मूसा ने अपने ससुर से कहा, “लोग मेरे पास आते हैं और अपनी समस्याओं के बारे में मुझ से परमेश्वर का निर्णय पूछते हैं। ");
INSERT INTO hin2010_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","यदि उन लोगों का कोई विवाद होता है तो वे मेरे पास आते हैं। मैं निर्णय करता हूँ कि कौन ठीक है। इस प्रकार मैं परमेश्वर के नियमों और उपदेशों की शिक्षा लोगों को देता हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","किन्तु मूसा के ससुर ने उससे कहा, “जिस प्रकार तुम यह कर रहे हो, ठीक नहीं है। ");
INSERT INTO hin2010_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","तुम्हारे अकेले के लिए यह काम अत्याधिक है। इससे तुम थक जाते हो और इससे लोग भी थक जाते हैं। तुम यह काम स्वयं अकेले नहीं कर सकते। ");
INSERT INTO hin2010_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","मैं तुम्हें कुछ सुझाव दूँगा। मैं तुम्हें बताऊँगा कि तुम्हें क्या करना चाहिए। मेरी प्रार्थना है कि परमेश्वर तुम्हारा साथ देगा। जो तुम्हें करना चाहिए वह यह है। तुम्हें परमेश्वर के सामने लोगों का प्रतिनिधित्व करते रहना चाहिए, और तुम्हें उनके इन विवादों और समस्याओं को परमेश्वर के सामने रखना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","तुम्हें परमेश्वर के नियमों और उपदेशों की शिक्षा लोगों को देनी चाहिए। लोगों को चेतावनी दो कि वे नियम न तोड़े। लोगों को जीने की ठीक राह बताओ। उन्हें बताओ कि वे क्या करेें। ");
INSERT INTO hin2010_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","किन्तु तुम्हें लोगों में से अच्छे लोगों को चुनना चाहिए। “तुम्हें अपने विश्वासपात्र आदमियों का चुनाव करना चाहिए अर्थात् उन आदमियों का जो परमेश्वर का सम्मान करते हो। उन आदमियों को चुनो जो धन के लिए अपना निर्णय न बदलें। इन आदमियों को लोगों का प्रशासक बनाओ। हज़ार, सौ, पचास और दस लोगों पर भी प्रशासक होने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","इन्हीं प्रशासकों को लोगों का न्याय करने दो। यदि कोई बहुत ही गंभीर मामला हो तो वे प्रशासक निर्णय के लिए तुम्हारे पास आ सकते हैं। किन्तु अन्य मामलों का निर्णय वे स्वयं ही कर सकते हैं। इस प्रकार यह तुम्हारे लिए अधिक सरल होगा। इसके अतिरिक्त, ये तुम्हारे काम में हाथ बटा सकेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","यदि तुम यहोवा की इच्छानुसार ऐसा करते हो तब तुम अपना कार्य करते रहने योग्य हो सकोगे। और इसके साथ ही साथ सभी लोग अपनी समस्याओं के हल हो जाने से शान्तिपूर्वक घर जा सकेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","इसलिए मूसा ने वैसा ही किया जैसा यित्रो ने कहा था। ");
INSERT INTO hin2010_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","मूसा ने इस्राएल के लोगों में से योग्य पुरुषों को चुना। मूसा ने उन्हें लोगों का अगुआ बनाया। वहाँ हज़ार, सौ, पचास और दस लोगों के ऊपर प्रशासक थे। ");
INSERT INTO hin2010_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ये प्रशासक लोगों के न्यायाधीश थे। लोग अपनी समस्याएँ इन प्रशासको के पास सदा ला सकते थे। और मूसा को केवल गंभीर मामले ही निपटाने पड़ते थे। ");
INSERT INTO hin2010_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","कुछ समय बाद मूसा ने अपने ससुर यित्रो से विदा ली और यित्रो अपने घर लौट गया। ");
INSERT INTO hin2010_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","मिस्र से अपनी यात्रा करने के तीसरे महीने में इस्राएल के लोग सीनै मरुभूमि में पहुँचे। ");
INSERT INTO hin2010_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","लोगों ने रपीदीम को छोड़ दिया था और वे सीनै मरुभूमि में आ पहुँचे थे। इस्राएल के लोगों ने मरुभूमि में पर्वत के निकट डेरा डाला। ");
INSERT INTO hin2010_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","तब मूसा पर्वत के ऊपर परमेश्वर के पास गया। जब मूसा पर्वत पर था तभी पर्वत से परमेश्वर ने उससे कहा, “ये बातें इस्राएल के लोगों अर्थात् याकूब के बड़े परिवार से कहो, ");
INSERT INTO hin2010_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘तुम लोगों ने देखा कि मैं अपने शत्रुओं के साथ क्या कर सकता हूँ। तुम लोगों ने देखा कि मैंने मिस्र के लोगों के साथ क्या किया। तुम ने देखा कि मैंने तुम को मिस्र से बाहर एक उकाब की तरह पंखों पर बैठाकर निकाला। और यहाँ अपने समीप लाया। ");
INSERT INTO hin2010_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","इसलिए अब मैं कहता हूँ तुम लोग मेरा आदेश मानो। मेरे साक्षीपत्र का पालन करो। यदि तुम मेरे आदेश मानोगे तो तुम मेरे विशेष लोग बनोगे। समस्त संसार मेरा है। ");
INSERT INTO hin2010_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","तुम एक विशेष लोग और याजकों का राज्य बनोगे।’ मूसा, जो बातें मैंने बताई है उन्हें इस्राएल के लोगों से अवश्य कह देना।” ");
INSERT INTO hin2010_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","इसलिए मूसा पर्वत से नीचे आया और लोगों के बुज़ुर्गों (नेताओं) को एक साथ बुलाया। मूसा ने बुज़ुर्गों से वह बातें कहीं जिन्हें कहने का आदेश यहोवा ने उसे दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","फिर सभी लोग एक साथ बोले, “हम लोग यहोवा की कही हर बात मानेंगे।” तब मूसा परमेश्वर के पास पर्वत पर लौट आया। मूसा ने कहा कि लोग उसके आदेश का पालन करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","और यहोवा ने मूसा से कहा, “मैं घने बादल में तुम्हारे पास आऊँगा। मैं तुमसे बात करूँगा। सभी लोग मुझे तुमसे बातें करते हुए सुनेंगे। मैं यह इसलिए करूँगा जिससे लोग उन बातों में सदा विश्वास करेंगे जो तुमने उनसे कहीं।” तब मूसा ने परमेश्वर को वे सभी बातें बताई जो लोगों ने कही थीं। ");
INSERT INTO hin2010_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","यहोवा ने मूसा से कहा, “आज और कल तुम लोगों को विशेष सभा के लिए अवश्य तैयार करो। लोगों को अपने वस्त्र धो लेने चहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","और तीसरे दिन मेरे लिए तैयार रहना चाहिए। तीसरे दिन मैं (यहोवा) सीनै पर्वत पर नीचे आऊँगा और सभी लोग मुझ (यहोवा) को देखेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","13","किन्तु उन लोगों से अवश्य कह देना कि वे पर्वत से दूर ही रूकें। एक रेखा खींचना और उसे लोगों को पार न करने देना। यदि कोई व्यक्ति या जानवर पर्वत को छूएगा तो उसे अवश्य मार दिया जाएगा। वह पत्थरों से मारा जाएगा या बाणों से बेधा जाएगा। किन्तु किसी व्यक्ति को उसे छूने नहीं दिया जाएगा। लोगों को तुरही बजने तक प्रतीक्षा करनी चाहिए। उसी समय उन्हें पर्वत पर जाने दिया जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","सो मूसा पर्वत से नीचे उतरा। वह लोगों के समीप गया और विशेष बैठक के लिए उन्हें तैयार किया। लोगों ने अपने वस्त्र से धोए। ");
INSERT INTO hin2010_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","तब मूसा ने लोगों से कहा, “परमेश्वर से मिलने के लिए तीन दिन में तैयार हो जाओ। उस समय तक कोई भी पुरुष स्त्री से सम्पर्क न करे।” ");
INSERT INTO hin2010_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","तीसरे दिन पर्वत पर बिजली की चमक और मेघ की गरज हुई। एक घना बादल पर्वत पर उतरा और तुरही की तेज ध्वनि हुई। डेरे के सभी लोग डर गए। ");
INSERT INTO hin2010_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","तब मूसा लोगों को पर्वत की तलहटी पर परमेश्वर से मिलने के लिए डेरे के बाहर ले गया। ");
INSERT INTO hin2010_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","सीनै पर्वत धुएँ से ढका था। पर्वत से धुआँ इस प्रकार उठा जैसे किसी भट्टी से उठता है। यह इसलिए हुआ कि यहोवा आग में पर्वत पर उतरे और साथ ही सारा पर्वत भी काँपने लगा। ");
INSERT INTO hin2010_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","तुरही की ध्वनि तीव्र से तीव्रतर होती चली गई। जब भी मूसा ने परमेश्वर से बात की, मेघ की गरज में परमेश्वर ने उसे उत्तर दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","इस प्रकार यहोवा सीनै पर्वत पर उतरा। यहोवा स्वर्ग से पर्वत की चोटी पर उतरा। तब यहोवा ने मूसा को अपने साथ पर्वत की चोटी पर आने को कहा। इसलिए मूसा पर्वत पर चढ़ा। ");
INSERT INTO hin2010_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","यहोवा ने मूसा से कहा, “जाओ और लोगों को चेतावनी दो कि वे मेरे पास न आएं न ही मुझे देखें। यदि वे ऐसा करेंगे तो वे मर जाएंगे और इस तरह बहुत सी मौतें हो जाएंगी। ");
INSERT INTO hin2010_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","उन याजकों से भी कहो जो मेरे पास आएंगे कि वे इस विशेष, मिलन के लिए स्वयं को तैयार करें। यदि वे ऐसा नहीं करते तो मैं उन्हें दण्ड दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मूसा ने यहोवा से कहा, “किन्तु लोग पर्वत पर नहीं आ सकते। तूने स्वयं ही हम से एक रेखा खींचकर पर्वत को पवित्र समझने और उसे पार न करने के लिए कहा था।” ");
INSERT INTO hin2010_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","यहोवा ने उससे कहा, “लोगों के पास जाओ और हारून को लाओ। उसे अपने साथ वापस लाओ। किन्तु याजकों और लोगों को मत आने दो। यदि वे मेरे पास आएंगे तो मैं उन्हें दण्ड दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","इसलिए मूसा लोगों के पास गया और उनसे ये बातें कहीं। ");
INSERT INTO hin2010_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","तब परमेश्वर ने ये बातें कहीं, ");
INSERT INTO hin2010_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“मैं तुम्हारा परमेश्वर यहोवा हूँ। मैं तुम्हें मिस्र देश से बाहर लाया। मैंने तुम्हें दासता से मुक्त किया। इसलिए तुम्हें निश्चय ही इन आदेशों का पालन करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“तुम्हे मेरे अतिरिक्त किसी अन्य देवता को, नहीं मानना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“तुम्हें कोई भी मूर्ति नहीं बनानी चाहिए। किसी भी उस चीज़ की आकृति मत बनाओ जो ऊपर आकाश में या नीचे धरती पर अथवा धरती के नीचे पानी में हो। ");
INSERT INTO hin2010_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","किसी भी प्रकार की मूर्ति की पूजा मत करो, उसके आगे मत झुको। क्यों? क्योंकि मैं तुम्हारा परमेश्वर यहोवा हूँ। मेरे लोग जो दूसरे देवताओं की पूजा करते है मैं उनसे घृणा करता हूँ। यदि कोई व्यक्ति मेरे विरुद्ध पाप करता है तो मैं उसका शत्रु हो जाता हूँ। मैं उस व्यक्ति की सन्तानों की तीसरी और चौथी पीढ़ी तक को दण्ड दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","किन्तु मैं उन व्यक्तियों पर बहुत कृपालू रहूँगा जो मुझसे प्रेम करेंगे और मेरे आदेशों को मानेंगे। मैं उनके परिवारों के प्रति सहस्रों पीढ़ी तक कृपालु रहूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“तुम्हारे परमेश्वर यहोवा के नाम का उपयोग तुम्हें गलत ढंग से नहीं करना चाहिए। यदि कोई व्यक्ति यहोवा के नाम का उपयोग गलत ढंग से करता है तो वह अपराधी है और यहोवा उसे निरपराध नहीं मानेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“सब्त को एक विशेष दिन के रूप में मानने का ध्यान रखना। ");
INSERT INTO hin2010_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","सप्ताह में तुम छः दिन अपना कार्य कर सकते हो। ");
INSERT INTO hin2010_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","किन्तु सातवाँ दिन तुम्हारे परमेश्वर यहोवा की प्रतिष्ठा में आराम का दिन है। इसलिए उस दिन कोई व्यक्ति चाहे तुम, या तुम्हारे पुत्र और पुत्रियाँ, तुम्हारे दास और दासियाँ, पशु तथा तुम्हारे नगर में रहने वाले सभी विदेशी काम नहीं करेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","क्यों? क्योंकि यहोवा ने छ: दिन काम किया और आकाश, धरती, सागर और उनकी हर चीज़ें बनाई। और सातवें दिन परमेश्वर ने आराम किया। इस प्रकार यहोवा ने शनिवार को वरदान दिया कि उसे आराम के पवित्र दिन के रूप में मनाया जाएगा। यहोवा ने उसे बहुत ही विशेष दिन के रूप में स्थापित किया। ");
INSERT INTO hin2010_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“अपने माता और अपने पिता का आदर करो। यह इसलिए करो कि तुम्हारे परमेश्वर यहोवा जिस धरती को तुम्हें दे रहा है, उसमें तुम दीर्घ जीवन बिता सको” ");
INSERT INTO hin2010_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“तुम्हें किसी व्यक्ति की हत्या नहीं करनी चाहिए” ");
INSERT INTO hin2010_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“तुम्हें व्यभिचार नहीं करना चाहिए” ");
INSERT INTO hin2010_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“तुम्हें चोरी नहीं करनी चाहिए” ");
INSERT INTO hin2010_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“तुम्हें अपने पड़ोसियों के विरुद्ध झूठी गवाही नहीं देनी चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“दूसरे लोगों की चीज़ों को लेने की इच्छा तुम्हें नहीं करनी चाहिए। तुम्हें अपने पड़ोसी का घर, उसकी पत्नी, उसके सेवक और सेविकाओं, उसकी गायों, उसके गधों को लेने की इच्छा नहीं करनी चाहिए। तुम्हें किसी की भी चीज़ को लेने की इच्छा नहीं करनी चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","घाटी में लोगों ने इस पूरे समय गर्जन सुनी और पर्वत पर बिजली की चमक देखी। उन्होंने तुरही की ध्वनि सुनी और पर्वत से उठते धूएँ को देखा। लोग डरे और भय से काँप उठे। वे पर्वत से दूर खड़े रहे और देखते रहे। ");
INSERT INTO hin2010_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","तब लोगों ने मूसा से कहा, “यदि तुम हम लोगों से कुछ कहना चाहोगे तो हम लोग सुनेंगे। किन्तु परमेश्वर को हम लोगों से बात न करने दो। यदि यह होगा तो हम लोग मर जाएंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","तब मूसा ने लोगों से कहा, “डरो मत! यहोवा यह प्रमाणित करने आया है कि वह तुमसे प्रेम करता है।” ");
INSERT INTO hin2010_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","लोग उस समय उठकर पर्वत से दूर चले आए जबकि मूसा उस गहरे बादल में गया जहाँ यहोवा था। ");
INSERT INTO hin2010_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","तब यहोवा ने मूसा से इस्राएलियों को बताने के लिए ये बातें कहीं: “तुम लोगों ने देखा कि मैंने तुमसे आकाश से बातें की। ");
INSERT INTO hin2010_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","इसलिए तुम लोग मेरे विरोध में सोने या चाँदी की मूर्तियाँ न बनाना। तुम्हें इन झूठे देवताओं की मूर्तियाँ कदापि नहीं बनानी है” ");
INSERT INTO hin2010_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“मेरे लिए एक विशेष वेदी बनाओ। इस वेदी को बनाने के लिए धूलि का उपयोग करो। इस वेदी पर बलि के रूप में होमबलि तथा मेलबलि चढ़ाओ। इस काम के लिए अपनी भेड़ों और गाय, बकरियों का उपयोग करो। उन सभी स्थानों पर यही करो जहाँ मैं अपने को याद करने के लिए कह रहा हूँ। तब मैं आऊँगा और तुम्हें आशीर्वाद दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","यदि तुम लोग वेदी को बनाने के लिए चट्टानों का उपयोग करो तो तुम लोग उन चट्टानों का उपयोग न करो जिन्हें तुम लोगों ने अपने किसी लोहे के औज़ारों से चिकना किया है। यदि तुम लोग चट्टानों पर किसी औज़ारो का उपयोग करोगे तो मैं वेदी को स्वीकार नहीं करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","तुम लोग वेदी तक पहुँचाने वाली सीढ़ियाँ भी न बनाना। यदि सीढ़ियाँ होंगी तो जब लोग ऊपर वेदी को देखेंगे तो वे तुम्हारे वस्त्रों के भीतर नीचे से तुम्हारी नग्नता को भी देख सकेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","तब परमेश्वर ने मूसा से कहा, “ये वे अन्य नियम है, जिन्हें तुम लोगों को बताओगे, ");
INSERT INTO hin2010_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“यदि तुम एक हिब्रू दास खरीदते हो तो उसे तुम्हारी सेवा केवल छः वर्ष करनी होगी। छः वर्ष बाद वह स्वतन्त्र हो जाएगा। उसे कुछ भी नहीं देना पड़ेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","तुम्हारा दास होने के पहले यदि उसका विवाह नहीं हुआ है तो वह पत्नी के बिना ही स्वतन्त्र होकर चला जाएगा। किन्तु यदि दास होने के समय वह व्यक्ति विवाहित होगा तो स्वतन्त्र होने के समय वह अपनी पत्नी को अपने साथ ले जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","यदि दास विवाहित नहीं होगा तो उसका स्वामी उसे पत्नी दे सकेगा। यदि वह पत्नी, पुत्र या पुत्रियों को जन्म देगी तो वह स्त्री तथा बच्चे उस दास के स्वामी के होंगे। अपने सेवाकाल के पूरा होने पर केवल वह दास ही स्वतन्त्र किया जाएगा” ");
INSERT INTO hin2010_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“किन्तु यह हो सकता है कि दास यह निश्चय करे कि वह अपने स्वामी के साथ रहना चाहता है। तब उसे कहना पड़ेगा, ‘मैं अपने स्वामी से प्रेम करता हूँ। मैं अपनी पत्नी और अपने बच्चों से प्रेम करता हूँ। मैं स्वतन्त्र नहीं होऊँगा मैं यहीं रहूँगा।’ ");
INSERT INTO hin2010_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","यदि ऐसा हो तो दास का स्वामी उसे परमेश्वर के सामने लाएगा। दास का स्वामी उसे किसी दरवाज़े तक या उसकी चौखट तक ले जाएगा और दास का स्वामी एक तेज़ औज़ार से दास के कान में एक छेद करेगा। तब दास उस स्वामी की सेवा जीवन भर करेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“कोई भी व्यक्ति अपनी पुत्री को दासी के रूप में बेचने का निश्चय कर सकता है। यदि ऐसा हो तो उसे स्वतन्त्र करने के लिए वे ही नियम नहीं है जो पुरुष दासों को स्वतन्त्र करने के लिए है। ");
INSERT INTO hin2010_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","यदि स्वामी उस स्त्री से सन्तुष्ट नहीं है तो वह उसके पिता को उसे वापस बेच सकता है। किन्तु यदि दासी का स्वामी उस स्त्री से विवाह करने का वचन दे तो वह दूसरे व्यक्ति को उसे बेचने का अधिकार खो देता है। ");
INSERT INTO hin2010_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","यदि दासी का स्वामी उस दासी से अपने पुत्र का विवाह करने का वचन दे तो उससे दासी जैसा व्यवहार नहीं किया जाएगा। उसके साथ पुत्री जैसा व्यवहार करना होगा” ");
INSERT INTO hin2010_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“यदि दासी का स्वामी किसी दूसरी स्त्री से भी विवाह करे तो उसे चाहिए कि वह पहली पत्नी को कम भोजन या वस्त्र न दे और उसे चाहिए कि उन चीजों को लगातार वह उसे देता रहे जिन्हें पाने का उसे अधिकार विवाह से मिला है। ");
INSERT INTO hin2010_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","उस व्यक्ति को ये तीन चीजें उसके लिए करनी चाहिए। यदि वह इन्हें नहीं करता तो स्त्री स्वतन्त्र की जाएगी और इसके लिए उसे कुछ देना भी नहीं पड़ेगा। उसे उस व्यक्ति को कोई धन नहीं देना होगा” ");
INSERT INTO hin2010_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“यदि कोई व्यक्ति किसी को चोट पहुँचाए और उसे मार डाले तो उस व्यक्ति को भी मार दिया जाय। ");
INSERT INTO hin2010_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","किन्तु यदि ऐसा संयोग होता है कि कोई बिना पूर्व योजना के किसी व्यक्ति को मार दे, तो ऐसा परमेश्वर की इच्छा से ही हुआ होगा। मैं कुछ विशेष स्थानों को चुनूँगा जहाँ लोग सुरक्षा के लिए दौड़कर जा सकते हैं। इस प्रकार वह व्यक्ति दौड़कर इनमें से किसी भी स्थान पर जा सकता है। ");
INSERT INTO hin2010_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","किन्तु कोई व्यक्ति यदि किसी व्यक्ति के प्रति क्रोध या घृणा रखने के कारण उसे मारने की योजना बनाए तो हत्यारे को दण्ड अवश्य मिलना चाहिए। उसे मेरी वेदी से दूर ले जाओ और उसे मार डालो” ");
INSERT INTO hin2010_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“कोई व्यक्ति जो अपने माता—पिता को चोट पहुँचायें वह अवश्य ही मार दिया जाये। ");
INSERT INTO hin2010_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“यदि कोई व्यक्ति किसी को दास के रूप में बेचने या अपना दास बनाने के लिए चुराए तो उसे अवश्य मार दिया जाए। ");
INSERT INTO hin2010_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“कोई व्यक्ति, जो अपने माता—पिता को शाप दे तो उसे अवश्य मार दिया जाए। ");
INSERT INTO hin2010_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“दो व्यक्ति बहस कर सकते है और एक दूसरे को पत्थर या मुक्के से मार सकते हैं। उस व्यक्ति को तुम्हें कैसे दण्ड देना चाहिए? यदि चोट खाया हुआ व्यक्ति मर न जाए तो चोट पहुँचाने वाला व्यक्ति मारा न जाए। ");
INSERT INTO hin2010_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","किन्तु यदि चोट खाए व्यक्ति को कुछ समय तक चारपाई पकड़नी पड़े तो चोट पहुँचाने वाले व्यक्ति को उसे हर्जाना देना चाहिए। चोट पहुँचाने वाला व्यक्ति उसके समय की हानि को धन से पूरा करे। वह व्यक्ति तब तक उसे हर्जाना दे जब तक वह पूरी तरह ठीक न हो जाए” ");
INSERT INTO hin2010_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“कभी कभी लोग अपने दास और दासियों को पीटते हैं। यदि पिटाई के बाद दास मर जाए तो हत्यारे को अवश्य दण्ड दिया जाए। ");
INSERT INTO hin2010_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","किन्तु दास यदि मरता नहीं और कुछ दिनों बाद वह स्वस्थ हो जाता है तो उस व्यक्ति को दण्ड नहीं दिया जाएगा। क्यों? क्योंकि दास के स्वामी ने दास के लिए धन दिया और दास उसका है। ");
INSERT INTO hin2010_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“दो व्यक्ति आपस में लड़ सकते हैं और किसी गर्भवती स्त्री को चोट पहुँचा सकते हैं। यदि वह स्त्री अपने बच्चे को समय से पहले जन्म देती है, और माँ बुरी तरह घायल नहीं है तो चोट पहुँचानेवाला व्यक्ति उसे अवश्य धन दे। उस स्त्री का पति यह निश्चित करेगा कि वह व्यक्ति कितना धन दे। न्यायाधीश उस व्यक्ति को यह निश्चय करने में सहायता करेंगे कि वह धन कितना होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","किन्तु यदि स्त्री बुरी तरह घायल हो तो वह व्यक्ति जिसने उसे चोट पहुँचाई है अवश्य दण्डित किया जाए। यदि एक व्यक्ति मार दिया जाता है तो हत्यारा अवश्य मार दिया जाए। तुम एक जीवन के बदले दूसरा जीवन लो। ");
INSERT INTO hin2010_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","तुम आँख के बदले आँख, दाँत के बदले दाँत, हाथ के बदले हाथ, पैर के बदले पैर लो। ");
INSERT INTO hin2010_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","जले के बदले जलाओ, खरोंच के बदले खरोंच करो और घाव के बदले घाव। ");
INSERT INTO hin2010_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“यदि कोई व्यक्ति किसी दास की आँख को चोट पहुँचाए और दास उस आँख से अन्धा हो जाए तो वह दास स्वतन्त्र हो जाने दिया जाएगा। उसकी आँख उसकी स्वतन्त्रता का मूल्य है। यह नियम दास या दासी दोनों के लिए समान है। ");
INSERT INTO hin2010_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","यदि दास का स्वामी दास के मुँह पर मारे और दास का कोई दाँत टूट जाए तो दास को स्वतन्त्र कर दिया जाएगा। दास का दाँत उसकी स्वतन्त्रता का मूल्य है। यह दास और दासी दोनों के लिए समान है। ");
INSERT INTO hin2010_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“यदि किसी व्यक्ति का कोई बैल किसी स्त्री को या पुरुष को मार देता है तो तुम पत्थरों का उपयोग करो और बैल को मार डालो। तुम्हें उस बैल को खाना नहीं चाहिए। किन्तु बैल का स्वामी अपराधी नहीं है। ");
INSERT INTO hin2010_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","किन्तु यदि बैल ने पहले लोगों को चोट पहुँचाई हो और स्वामी को चेतावनी दी गई हो तो वह स्वामी अपराधी है। क्यों? क्योंकि इसने बैल को बाँधा या बन्द नहीं रखा। यदि बैल स्वतन्त्र छोड़ा गया हो और किसी को वह मारे तो स्वामी अपराधी है। तुम पत्थरों से बैल और उसके स्वामी को भी मार दो। ");
INSERT INTO hin2010_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","किन्तु मृतक का परिवार यदि चाहे तो बदले में धन लेकर बैल के मालिक को छोड़ सकता है। किन्तु वह उतना धन दे जितना न्यायाधीश निश्चित करे। ");
INSERT INTO hin2010_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","“यही नियम उस समय भी लागू होगा जब बैल किसी व्यक्ति के पुत्र या पुत्री को मारता है। ");
INSERT INTO hin2010_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","किन्तु बैल यदि दास को मार दे तो बैल का स्वामी दास के स्वामी को एक नये दास का मूल्य चाँदी के तीस सिक्के दे और बैल भी पत्थरों से मार डाला जाए। यह नियम दास और दासी के लिए समान होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“कोई व्यक्ति कोई गका या कुँआ खोदे और उसे ढके नहीं और यदि किसी व्यक्ति का जानवर आए और उसमें गिर जाए तो गके का स्वामी दोषी है। ");
INSERT INTO hin2010_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","गके का स्वामी जानवर के लिए धन देगा। किन्तु जानवर के लिए धन देने के बाद उसे उस मरे जानवर को लेने दिया जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“यदि किसी का बैल किसी दूसरे व्यक्ति के बैल को मार डाले तो वे दोनों उस जीवित बैल को बेच दें। दोनों व्यक्ति बेचने से प्राप्त आधा—आधा धन और मरे बैल का आधा—आधा भाग ले लें। ");
INSERT INTO hin2010_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","किन्तु यदि उस व्यक्ति के बैल ने पहले भी किसी दूसरे जानवर को चोट पहुँचाई हो तो उस बैल का स्वामी अपने बैल के लिए उत्तरदायी है। यदि उसका बैल दूसरे बैल को मार डालता है तो यह अपराधी है क्योंकि उसने बैल को स्वतन्त्र छोड़ा। वह व्यक्ति बैल के बदले बैल अवश्य दे। वह मारे गए बैल के बदले अपना बैल दे। ");
INSERT INTO hin2010_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“जो व्यक्ति किसी बैल या भेड़ को चुराता है उसे तुम कैसा दण्ड दोगे? यदि वह व्यक्ति जानवर को मार डाले या बेच दे तो वह उसे लौटा तो नहीं सकता। इसलिए वह एक चुराए बैल के बदले पाँच बैल दे। या वह एक चुराई गई भेड़ के बदले चार भेड़ दे। वह चोरी के लिए कुछ धन भी दे। ");
INSERT INTO hin2010_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","किन्तु यदि उसके पास अपना कुछ भी नहीं है तो चोरी के लिए उसे दास के रूप में बेचा जाएगा। किन्तु यदि उसके पास चोरी का जानवर पाया जाए तो वह व्यक्ति जानवर के स्वामी को हर एक चुराए गए जानवर के बदले दो जानवर देगा। इस बात का कोई अन्तर नहीं पड़ेगा कि जानवर बैल, गधा या भेड़ हो। “यदि कोई चोर रात को घर में सेंध लगाने का प्रयत्न करते समय मारा जाए तो उसे मारने का अपराधी कोई नहीं होगा। किन्तु यदि यह दिन में हो तो उसका हत्यारा व्यक्ति अपराध का दोषी होगा। चोर को निश्चय ही क्षतिपूर्ति करनी होगी। ");
INSERT INTO hin2010_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“यदि कोई व्यक्ति अपने खेत या अँगूर के बाग में आग लगाए और वह उस आग को फैलने दे और वह उसके पड़ोसी के खेत या अँगूर के बाग को जला दे तो वह अपने पड़ोसी की हानि की पूर्ति में देने के लिए अपनी सबसे अच्छी फसल का उपयोग करेगा।y ");
INSERT INTO hin2010_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“कोई व्यक्ति अपने खेत की झाड़ियों को जलाने के लिए आग लगाए। किन्तु यदि आग बढ़े और उसके पड़ोसी की फसल या पड़ोसी के खेत में उगे अन्न को जला दे तो आग लगाने वाला व्यक्ति जली हुई चीज़ों के बदले भुगतान करेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“कोई व्यक्ति अपने पड़ोसी से उसके घर में कुछ धन या कुछ अन्य चीज़ें रखने को कहे और यदि वह धन या वे चीज़ें पड़ोसी के घर से चोरी चली जाए तो तुम क्या करोगे? तुम्हें चोर का पता लगाने का प्रयत्न करना चाहिए। यदि तुमने चोर को पकड़ लिया तो वह चीज़ों के मूल्य का दुगुना देगा। ");
INSERT INTO hin2010_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","किन्तु यदि तुम चोर का पता न लगा सके तब परमेश्वर निर्णय करेगा कि पड़ोसी अपराधी है या नहीं। घर का स्वामी परमेश्वर के सामने जाए और परमेश्वर ही निर्णय करेगा कि उसने चुराया है या नहीं। ");
INSERT INTO hin2010_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“यदि दो व्यक्ति किसी खोए बैल, गधा, भेड़, वस्त्र, यदि किसी अन्य खोई हुई चीज़ के बारे में सहमत न हों तो तुम क्या करोगे? एक व्यक्ति कहता है, ‘यह मेरी है।’ और दूसरा कहता है, ‘नहीं, यह मेरी है।’ दोनों व्यक्ति परमेश्वर के सामने जाएँ। परमेश्वर निर्णय करेगा कि अपराधी कौन है। जिस व्यक्ति को परमेश्वर अपराधी पाएगा वह उस चीज़ के मूल्य से दुगुना भुगतान करे। ");
INSERT INTO hin2010_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“कोई अपने पड़ोसी से कुछ समय के लिए अपने जानवर की देखभाल के लिए कहे। वह जानवर बैल, भेड़, गधा या कोई अन्य पशु हो और यदि वह जानवर मर जाए, उसे चोट आ जाए या कोई उसे तब हाँक ले जाए जब कोई न देख रहा हो तो तुम क्या करोगे? ");
INSERT INTO hin2010_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","वह पड़ोसी स्पष्ट करे कि उसने जानवर को नहीं चुराया है। यदि यह सत्य हो तब पड़ोसी यहोवा की शपथ उठाए कि उसने वह नहीं चुराया है। जानवर का मालिक इस शपथ को अवश्य स्वीकार करे। पड़ोसी को जानवर के लिए मालिक को भुगतान नहीं करना होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","किन्तु यदि पड़ोसी ने जानवर को चुराया हो तो वह मालिक को जानवर के लिए भुगतान अवश्य करे। ");
INSERT INTO hin2010_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","यदि जंगली जानवरों ने जानवर को मारा हो तो प्रमाण के लिए उसके शरीर को पड़ोसी लाए। पड़ोसी मारे गए जानवर के लिए मालिक को भुगतान नहीं करेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“यदि कोई व्यक्ति अपने पड़ोसी से किसी जानवर को उधार ले तो उसके लिए वह व्यक्ति ही उत्तरदायी है। यदि उस जानवर को चोट पहुँचे या वह मर जाए तो पड़ोसी मालिक को उस जानवर के लिए भुगतान करे। पड़ोसी इसलिए उत्तरदायी है क्योंकि उसका मालिक स्वयं वहाँ नहीं था। ");
INSERT INTO hin2010_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","किन्तु यदि मालिक जानवर के साथ वहाँ हो तब पड़ोसी को भुगतान नहीं करना होगा। या यदि पड़ोसी काम लेने के लिए धन का भुगतान कर रहा हो तो जानवर के मरने या चोट खाने पर उसे कुछ भी नहीं देना होगा। जानवर के उपयोग के लिए दिया गया भुगतान ही पर्याप्त होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“यदि कोई पुरुष किसी अविवाहित कुँवारी कन्या से यौन सम्बन्ध करे तो वह उससे निश्चय ही विवाह करे। और वह उस लड़की के पिता को पूरा दहेज दे। ");
INSERT INTO hin2010_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","यदि पिता अपनी पुत्री को उसे विवाह के लिए देने से इन्कार करता है तो भी उस व्यक्ति को धन देना पड़ेगा। वह उसे दहेज का पूरा धन दे। ");
INSERT INTO hin2010_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“तुम किसी स्त्री को जादू टोना मत करने देना। यदि वह ऐसा करे तो तुम उसे जीवित मत रहने देना। ");
INSERT INTO hin2010_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“तुम किसी व्यक्ति को किसी जानवर के साथ यौन सम्बन्ध न रखने देना। यदि ऐसा हो तो वह व्यक्ति अवश्य मार डाला जाए। ");
INSERT INTO hin2010_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“यदि कोई किसी मिथ्या देवता को बलि चढ़ाए तो उस व्यक्ति को अवश्य नष्ट कर दिया जाए। केवल परमेश्वर यहोवा ही ऐसा है जिसे तुमको बलि चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“याद रखो इससे पहले तुम लोग मिस्र देश में विदेशी थे। अतः तुम लोग उस व्यक्ति को न ठगो, न ही चोट पहुँचाओ जो तुम्हारे देश में विदेशी हो। ");
INSERT INTO hin2010_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“निश्चय ही तुम लोग ऐसी स्त्रियों का कभी बुरा नहीं करोगे जिनके पति मर चुके हों या उन बच्चों का जिनके माता—पिता न हों। ");
INSERT INTO hin2010_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","यदि तुम लोग उन विधवाओं या अनाथ बच्चों का कुछ बुरा करोगे तो वे मेरे आगे रोएंगे और मैं उनके कष्टों को सुनूँगा ");
INSERT INTO hin2010_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","और मुझे बहुत क्रोध आएगा। मैं तुम्हें तलवार से मार डालूँगा। तब तुम्हारी पत्नियाँ विधवा हो जाएंगी और तुम्हारे बच्चे अनाथ हो जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“यदि मेरे लोगों में से कोई गरीब हो और तुम उसे कर्ज़ दो तो उस धन के लिए तुम्हें ब्याज़ नहीं लेना चाहिए। और जल्दी चुकाने के लिए भी तुम उसे मजबूर नहीं करोगे। ");
INSERT INTO hin2010_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","कोई व्यक्ति उधार लिए हुए धन के भुगतान के लिए अपना लबादा गिरवी रख सकता है। किन्तु तुम सूरज डूबने के पहले उसका वह वस्त्र अवश्य लौटा देना। ");
INSERT INTO hin2010_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","यदि वह व्यक्ति अपना लबादा नहीं पाता तो उसके पास शरीर ढकने को कुछ भी नहीं रहेगा। जब वह सोएगा तो उसे सर्दी लगेगी। यदि वह मुझे रोकर पुकारेगा तो मैं उसकी सुनूँगा। मैं उसकी बात सुनूँगा क्योंकि मैं कृपालु हूँ। ");
INSERT INTO hin2010_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“तुम्हें परमेश्वर या अपने लोगों के मुखियाओ को शाप नहीं देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“फ़सल कटने के समय तुम्हें अपना प्रथम अन्न और प्रथम फल का रस मुझे देना चाहिए। इसे टालो मत। “मुझे अपने पहलौठे पुत्रों को दो। ");
INSERT INTO hin2010_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","अपनी पहलौठी गायों तथा भेड़ों को भी मुझे देना। पहलौठे को उसकी माँ के साथ सात दिन रहने देना। उसके बाद आठवें दिन उसे मुझको देना। ");
INSERT INTO hin2010_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“तुम लोग मेरे विशेष लोग हो। इसलिए ऐसे किसी जानवर का माँस मत खाना जिसे किसी जंगली जानवर ने मारा हो। उस मरे जानवर को कुत्तों को खाने दो।” ");
INSERT INTO hin2010_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“लोगों के विरुद्ध झूठ मत बोलो। यदि तुम न्यायालय में गवाह हो तो बुरे व्यक्ति की सहायता के लिए झूठ मत बोलो। ");
INSERT INTO hin2010_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“उस भीड़ का अनुसरण मत करो, जो गलत कर रही हो। जो जनसमूह बुरा कर रहा हो उसका अनुसरण करते हुए न्यायालय में उसका समर्थन मत करो। ");
INSERT INTO hin2010_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","“न्यायालय में किसी गरीब का इसलिए पक्ष मत लो कि वह गरीब है। तुम्हें ऐसा नहीं करना चाहिए। यदि वह सही है तब ही उसका समर्थन करो। ");
INSERT INTO hin2010_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“यदि तुम्हें कोई खोया हुआ बैल या गधा मिले तो तुम्हें उसे उसके मालिक को लौटा देना चाहिए। चाहे वह तुम्हारा शत्रु ही क्यों न हो। ");
INSERT INTO hin2010_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","“यदि तुम देखो कि कोई जानवर इसलिए नहीं चल पा रहा है कि उसे अत्याधिक बोझ ढोना पड़ रहा है तो तुम्हें उसे रोकना चाहिए और उस जानवर की सहायता करनी चाहिए। तुम्हें उस जानवर की सहायता तब भी करनी चाहिए जब वह जानवर तुम्हारे शत्रुओं में से भी किसी का हो। ");
INSERT INTO hin2010_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“तुम्हें, लोगों को गरीबों के प्रति अन्यायी नहीं होने देना चाहिए। उनके साथ भी अन्य लोगों के समान ही न्याय होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“तुम किसी को किसी बात के लिए अपराधी कहते समय बहुत सावधान रहो। किसी व्यक्ति पर झूठे दोष न लगाओ। किसी निर्दोष व्यक्ति को उस अपराध के दण्ड के द्वारा मत मरने दो जो उसने नहीं किया। कोई व्यक्ति जो निर्दोष की हत्या करें, दुष्ट है। और मैं उस दुष्ट व्यक्ति को क्षमा माफ़ नहीं करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“यदि कोई व्यक्ति गलत होने पर अपने से सहमत होने के लिए रिश्वत देने का प्रयत्न करे तो उसे मत लो। ऐसी रिश्वत न्यायाधीशों को अन्धा कर देगी जिससे वे सत्य को नहीं देख सकेंगे। रिश्वत अच्छे लोगों को झूठ बोलना सिखाएगी। ");
INSERT INTO hin2010_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“तुम किसी विदेशी के साथ कभी बुरा बरताव न करो। याद रखो जब तुम मिस्र देश में रहते थे तब तुम विदेशी थे।” ");
INSERT INTO hin2010_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“छः वर्ष तक बीज बोओ, अपनी फ़सलों को काटो और खेत को तैयार करो। ");
INSERT INTO hin2010_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","किन्तु सातवें वर्ष अपनी भूमि का उपयोग न करो। सातवाँ वर्ष भूमि के विश्राम का विशेष समय होगा। अपने खेतों मे कुछ भी न बोओ। यदि कोई फ़सल वहाँ उगती है तो उसे गरीब लोगों को ले लेने दो। जो भी खाने की चीज़ें बच जाएं उन्हें जंगली जानवरों को खा लेने दो। यही बात तुम्हें अपने अंगूर और जैतून के बागों के सम्बन्ध में भी करनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“छः दिन तक काम करो। तब सातवें दिन विश्राम करो। इससे तुम्हारे दासों और तुम्हारे दूसरे मजदूरों को भी विश्राम का समय मिलेगा। और तुम्हारे बैल और गधे भी आराम कर सकेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“संकल्प करो कि तुम इन नियमों का पालन करोगे। मिथ्या देवताओं की पूजा मत करो। तुम्हें उनका नाम भी नहीं लेना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“प्रति वर्ष तुम्हारे तीन विशेष पवित्र पर्व होंगे। इन दिनों तुम लोग मेरी उपासना के लिए मेरी विशेष जगह पर आओगे। ");
INSERT INTO hin2010_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","पहला पवित्र पर्व अख़मीरी रोटी का पर्व होगा। यह वैसा ही होगा, जैसा मैंने आदेश दिया है। इस दिन तुम लोग ऐसी रोटी खाओगे जिसमें खमीर न हो। यह सात दिन तक चलेगा। तुम लोग यह आबीब के महीने में करोगे। क्योंकि यही वह समय है जब तुम लोग मिस्र से आए थे। इन दिनों कोई भी व्यक्ति मेरे सामने खाली हाथ नहीं आएगा। ");
INSERT INTO hin2010_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“दूसरा पवित्र पर्व कटनी का पर्व होगा। यह पवित्र पर्व ग्रीष्म के आरम्भ में, तब होगा जब तुम अपने खेतों में उगायी गई फसल को काटोगे। “तीसरा पवित्र पर्व बटोरने का पर्व होगा। यह पतझड़ में होगा। यह उस समय होगा जब तुम अपनी सारी फसलें खेतों से इकट्ठा करते हो। ");
INSERT INTO hin2010_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“इस प्रकार प्रति वर्ष तीन बार सभी पुरुष यहोवा परमेश्वर के सामने उपस्थित होंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“जब तुम किसी जानवर को मारो और इसका ख़ून बलि के रूप में भेंट चढ़ाओ तब ऐसी रोटी भेंट नहीं करो जिसमें खमीर हो। और जब तुम इस बलि के माँस को खाओ तब तुम्हें एक ही दिन में वह सारा माँस खा लेना चाहिए। अगले दिन के लिए कुछ भी माँस न बचाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“फसल काटने के समय जब तुम अपनी फ़सलें इकट्ठी करो तब अपनी काटी हुई फ़सल की पहली उपज अपने यहोवा परमेश्वर के भवन में लाओ। “तुम्हें छोटी बकरी के उस माँस को नहीं खाना चाहिए जो उस बकरी की माँ के दूध में पका हो।” ");
INSERT INTO hin2010_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","परमेश्वर ने कहा, “मैं तुम्हारे सामने एक दूत भेज रहा हूँ। यह दूत तुम्हें उस स्थान तक ले जाएगा जिसे मैंने तुम्हारे लिए तैयार किया है। यह दूत तुम्हारी रक्षा करेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","दूत की आज्ञा मानो और उसका अनुसरण करो। उसके विरुद्ध विद्रोह न करो। वह दूत उन अपराधों को क्षमा नहीं करेगा जो तुम उसके प्रति करोगे। उसमें मेरी शक्ति निहित है। ");
INSERT INTO hin2010_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","वह जो कुछ कहे उसे मानो। तुम्हें हर एक वह कार्य करना चाहिए जो मैं तुम्हें कहता हूँ। यदि तुम यह करोगे तो मैं तुम्हारे साथ रहूँगा। मैं तुम्हारे सभी शत्रुओं के विरुद्ध होऊँगा और मैं उस हर व्यक्ति का शत्रु होऊँगा जो तुम्हारे विरुद्ध होगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","परमेश्वर ने कहा, “मेरा दूत तुम्हें इस देश से होकर ले जाएगा। वह तुम्हें कई भिन्न लोगों—एमोरी, हित्ती, परिज्जी, कनानी, हिब्बी और यबूसी के विरुद्ध कर देगा। किन्तु मैं उन सभी लोगों को नष्ट कर दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“उनके देवताओं को मत पूजो। उन देवताओं को झूककर कभी प्रणाम मत करो। तुम उस ढंग से कभी न रहो जिस ढंग से वे रहते हैं। तुम्हें उनकी मूर्तियों को निश्चय ही नष्ट कर देना चाहिए और तुम्हें उनके प्रस्तर पिण्ड़ों को तोड़ देना चाहिए जो उन्हें उनके देवताओं को याद दिलाने में सहायता करती है। ");
INSERT INTO hin2010_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","तुम्हें अपने परमेश्वर यहोवा की सेवा करनी चाहिए। यदि तुम यह करोगे तो मैं तुम्हें भरपूर रोटी और पानी का वरदान दूँगा। मैं तुम्हारी सारी बीमारियो को दूर कर दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","तुम्हारी सभी स्त्रियाँ बच्चों को जन्म देने लायक होंगी। जन्म के समय उनका कोई बच्चा नहीं मरेगा और मैं तुम लोगों को भरपूर लम्बा जीवन प्रदान करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“जब तुम अपने शत्रुओं से लड़ोगे, मैं अपनी प्रबल शक्ति तुमसे भी पहले वहाँ भेज दूँगा। मैं तुम्हारे सभी शत्रुओं के हराने में तुम्हारी सहायता करूँगा। वे लोग जो तुम्हारे विरुद्ध होंगे वे युद्ध में घबरा कर भाग जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","मैं तुम्हारे आगे—आगे बर्रे भेजूँगा वह तुम्हारे शत्रुओं को भागने के लिए विवश करेंगे। हिब्बी, कनानी और हित्ती लोग तुम्हारा प्रदेश छोड़ कर भाग जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","किन्तु मैं उन लोगों को तुम्हारे प्रदेश से बाहर जाने को शीघ्रतापूर्वक विवश नहीं करूँगा। मैं यह केवल एक वर्ष में नहीं करुँगा। यदि मैं लोगों को अति शीघ्रता से बाहर जाने को विवश करूँ तो प्रदेश ही निर्जन हो जाए। तब सभी प्रकार के जंगली जानवर बढ़ेंगे और वे तुम्हारे लिए बहुत कष्टकर होंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","मैं उन्हें धीरे और उस समय तक बाहर खदेड़ता रहूँगा जब तक तुम उस धरती पर फैल न जाओ और उस पर अधिकार न कर लो। ");
INSERT INTO hin2010_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“मैं तुम लोगों को लाल सागर से लेकर फरात तक का सारा प्रदेश दूँगा। पश्चिमी सीमा पलिश्ती सागर (भूमध्य सागर) होगा और पूर्वी सीमा अरब मरुभूमि होगी। मैं ऐसा करूँगा कि वहाँ के रहने वालों को तुम हराओ। और तुम इन सभी लोगों को वहाँ से भाग जाने के लिए विवश करोगे। ");
INSERT INTO hin2010_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“तुम उनके देवताओं या उन लोगों में से किसी के साथ कोई समझौता नहीं करोगे। ");
INSERT INTO hin2010_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","उन्हें अपने देश में मत रहने दो। यदि तुम उन्हें रहने दोगे तो तुम उनके जाल में फँस जाओगे। वे तुमसे मेरे विरुद्ध पाप करवाएंगे और तुम उनके देवताओं की सेवा आरम्भ कर दोगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","परमेश्वर ने मूसा से कहा, “तुम हारून, नादाब, अबीहू और इस्राएल के सत्तर बुजुर्ग (नेता) पर्वत पर आओ और कुछ दूर से मेरी उपासना करो। ");
INSERT INTO hin2010_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","तब मूसा अकेले यहोवा के समीप आएगा। अन्य लोग यहोवा के समीप न आएँ, और शेष व्यक्ति पर्वत तक भी न आएँ।” ");
INSERT INTO hin2010_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","इस प्रकार मूसा ने यहोवा के सभी नियमों और आदेशों को लोगों को बताया। तब सभी लोगों ने कहा, “यहोवा ने जिन सभी आदेशों को दिया उनका हम पालन करेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","इसलिए मूसा ने यहोवा के सभी आदेशों को चर्म पत्र पर लिखा। अगली सुबह मूसा उठा और पर्वत की तलहटी के समीप उसने एक वेदी बनाई और उसने बारह शिलाएँ इस्राएल के बारह कबीलों के लिए स्थापित कीं। ");
INSERT INTO hin2010_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","तब मूसा ने इस्राएल के युवकों को बलि चढ़ाने के लिए बुलाया। इन व्यक्तियों ने यहोवा को होमबलि और मेलबलि के रूप में बैल की बलि चढ़ाई। ");
INSERT INTO hin2010_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","मूसा ने इन जानवरों के खून को इकट्ठा किया। मूसा ने आधा खून प्याले में रखा और उसने दूसरा आधा खून वेदी पर छिड़का। ");
INSERT INTO hin2010_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","मूसा ने चर्म पत्र पर लिखे विशेष साक्षीपत्र को पढ़ा। मूसा ने साक्षीपत्र को इसलिए पढ़ा कि सभी लोग उसे सुन सकें और लोगों ने कहा, “हम लोगों ने उन नियमों को जिन्हें यहोवा ने हमें दिया, सुन लिया है और हम सब लोग उनके पालन करने का वचन देते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","तब मूसा ने खून को लिया और उसे लोगों पर छिड़का। उसने कहा, “यह खून बताता है कि यहोवा ने तुम्हारे साथ विशेष साक्षीपत्र स्थापित किया। ये नियम जो यहोवा ने दिए है वे साक्षीपत्र को स्पष्ट करते है।” ");
INSERT INTO hin2010_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","तब मूसा, हारून, नादाब, अबीहू और इस्राएल के सत्तर बुजुर्ग (नेता) ऊपर पर्वत पर चढ़े। ");
INSERT INTO hin2010_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","पर्वत पर इन लोगों ने इस्राएल के परमेश्वर को देखा। परमेश्वर किसी ऐसे आधार पर खड़ा था। जो नीलमणि सा दिखता था ऐसा निर्मल जैसा आकाश। ");
INSERT INTO hin2010_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","इस्राएल के सभी नेताओं ने परमेश्वर को देखा, किन्तु परमेश्वर ने उन्हें नष्ट नहीं किया। तब उन्होंने एक साथ खाया और पिया। ");
INSERT INTO hin2010_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","यहोवा ने मूसा से कहा, “मेरे पास पर्वत पर आओ। मैंने अपने उपदेशों और आदेशों को दो समतल पत्थरों पर लिखा है। ये उपदेश लोगों के लिए हैं। मैं इन समतल पत्थरों को तुम्हें दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","इसलिए मूसा और उसका सहायक यहोशू परमेश्वर के पर्वत तक गए। ");
INSERT INTO hin2010_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","मूसा ने चुने हुए बुजुर्गो से कहा, “हम लोगों की यहीं प्रतीक्षा करो, हम तुम्हारे पास लौटेंगे। जब तक मैं अनुपस्थित रहूँ, हारून और हूर आप लोगों के अधिकारी होंगे। यदि किसी को कोई समस्या हो तो वह उनके पास जाए।” ");
INSERT INTO hin2010_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","तब मूसा पर्वत पर चढ़ा और बादल ने पर्वत को ढक लिया। ");
INSERT INTO hin2010_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","यहोवा की दिव्यज्योति सीनै पर्वत पर उतरी। बादल ने छः दिन तक पर्वत को ढके रखा। सातवें दिन यहोवा, बादल में से मूसा से बोला। ");
INSERT INTO hin2010_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","इस्राएल के लोग यहोवा की दिव्यज्योति को देख सकते थे। वह पर्वत की चोटी पर दीप्त प्रकाश की तरह थी। ");
INSERT INTO hin2010_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","तब मूसा बादलों में और ऊपर पर्वत पर चढ़ा। मूसा पर्वत पर चालीस दिन और चालीस रात रहा। ");
INSERT INTO hin2010_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“इस्राएल के लोगों से मेरे लिए भेंट लाने को कहो। हर एक व्यक्ति अपने मन में निश्चय करे कि वह मुझे इन वस्तुओं में से क्या अर्पित करना चाहता है। इन उपहारों को मेरे लिए अर्पित करो। ");
INSERT INTO hin2010_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","इन वस्तुओं की सूची यह है जिन्हें तुम लोगों से स्वीकार करोगे, सोना, चाँदी, काँसा; ");
INSERT INTO hin2010_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","नीला, बैंगनी और लाल सूत, सुन्दर रेशमी कपड़ा; बकरियों के बाल, ");
INSERT INTO hin2010_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","लाल रंग से रंगा भेड़ का चमड़ा, सुइसों के चमड़ें, बबूल की लकड़ी, ");
INSERT INTO hin2010_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","दीपक में जलाने का तेल, धूप के लिए सुगन्धित द्रव्य, अभिषेक के तेल के लिए भीनी सुगन्ध देने वाले मसाले। ");
INSERT INTO hin2010_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","गोमेदक रत्न तथा अन्य मूल्यवान रत्न भी जो याजकों के पहनने की एफोद और न्याय की थैली पर जड़े जाएं, अर्पित करो।” ");
INSERT INTO hin2010_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","परमेश्वर ने यह भी कहा, “लोग मेरे लिए एक पवित्र तम्बू बनाएंगे। तब मैं उनके साथ रह सकूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","मैं तुम्हें दिखाऊँगा कि पवित्र तम्बू कैसा दिखाई पड़ना चाहिए। मैं तुम्हें दिखाऊँगा कि इसमें सभी चीज़ें कैसी दिखाई देनी चाहिए। जैसा मैंने दिखाया है हर एक चीज़ ठीक वैसे ही बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“बबूल की लकड़ी का उपयोग करके एक विशेष सन्दूक बनाओ। वह सन्दूक निश्चय ही पैतालिस इंच लम्बा, सत्ताईस इंच चौड़ा और सत्ताईस इंच ऊँचा होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","सन्दूक को भीतर और बाहर से ढकने के लिए शुद्ध सोने का उपयोग करो। सन्दूक के कोनों को सोने से मढ़ो। ");
INSERT INTO hin2010_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","सन्दूक को उठाने के लिए सोने के चार कड़े बनाओ। सोने के कड़ो को चारों कोनों पर लगाओ। दोनों तरफ दो—दो कड़े हों। ");
INSERT INTO hin2010_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","तब सन्दूक ले चलने के लिए बल्लियाँ बनाओ। ये बल्लियाँ बबूल की लकड़ी की बनी हो और सोने से मढ़ी होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","सन्दूक के बगलों के कोनों पर लगे कड़ों में इन बल्लियों को डाल देना। इन बल्लियों का उपयोग सन्दूक को ले जाने के लिए करो। ");
INSERT INTO hin2010_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ये बल्लियाँ सन्दूक के कड़ों में सदा पड़ी रहनी चाहिए। बल्लियों को बाहर न निकालो।” ");
INSERT INTO hin2010_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","परमेश्वर ने कहा, “मैं तुम्हें साक्षीपत्र दूँगा। इस साक्षीपत्र को इस सन्दूक में रखो। ");
INSERT INTO hin2010_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","तब एक ढक्कन बनाओ। इसे शुद्ध सोने का बनाओ। इसे पैंतालिस इंच लम्बा और सत्ताईस इंच चौड़ा बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","तब दो करूब बनाओ और उन्हें ढक्कन के दोनों सिरों पर लगाओ। इन करूबों को बनाने के लिए स्वर्ण पत्रों का उपयोग करो। ");
INSERT INTO hin2010_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","एक करूब को ढक्कन के एक सिरे पर लगाओ तथा दूसरे को दूसरे सिरे पर। करूब और ढक्कन को परस्पर जोड़ कर के एक इकाई के रूप में बनाया जाए। ");
INSERT INTO hin2010_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","करूब एक दूसरे के आमने—सामने होने चाहिए। करूबों के मुख ढक्कन की ओर देखते हुए होने चाहिए। करूबों के पंख ढक्कन पर फैले हों। ");
INSERT INTO hin2010_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","“मैंने तुमको साक्षीपत्र का जो प्रमाण दिया है उसे साक्षीपत्र के सन्दूक में रखो और विशेष ढक्कन से सन्दूक को बन्द करो। ");
INSERT INTO hin2010_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","जब मैं तुमसे मिलूँगा तब मैं करूबो के बीच से, जो साक्षीपत्र के सन्दूक के विशेष ढक्कन पर है, बात करूँगा। मैं अपने सभी आदेश इस्राएल के लोगों को उसी स्थान से दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“बबूल की लकड़ी का एक मेज़ बनाओ। मेज़ छत्तीस इंच लम्बा अट्ठारह इंच चौड़ा और सत्ताईस इंच ऊँचा होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","मेज़ को शुद्ध सोने से मढ़ो और उसके चारों ओर सोने की झालर लगाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","तब तीन इंच चौड़ा सोने का चौखरा मेज के ऊपर चारों ओर जड़ दो और उसके चारों ओर सोने की झालर लगाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","तब सोने के चार कड़े बनाओ और मेज़ के चारों कोनों पर पायों के पास लगाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","हर एक पाए पर एक कड़ा लगा दो। जो मेज़ के ऊपर की चारों ओर की सजावट के समीप हो। इन कड़ों में मेज़ को ले जाने के लिए बनी बल्लियाँ फँसी होंगी। ");
INSERT INTO hin2010_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","बल्लियाँ को बनाने के लिए बबूल की लकड़ी का उपयोग करो और उन्हें सोने से मढ़ो। बल्लियाँ मेज़ को ले जाने के लिए हैं। ");
INSERT INTO hin2010_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","पात्र, तवे, मर्तबान और अर्ध के लिए कटोरे इन सबको शुद्ध सोने का बनाना। ");
INSERT INTO hin2010_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","विशेष रोटी मेज़ पर मेरे सम्मुख रखो। यह सदैव मेरे सम्मुख वहाँ रहनी चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“तब तुम्हें एक दीपाधार बनाना चाहिए। दीपाधार के हर एक भाग को बनाने के लिए शुद्ध सोने के पत्तर तैयार करो। सुन्दर दिखने के लिए दीप पर फूल बनाओ। ये फूल, इनकी कलियाँ और पंखुडियाँ शुद्ध सोने की बनी होनी चाहिए और वे सभी चीज़ें एक ही में जुड़ी हुई होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","“दीपाधार की छः शाखाएँ होनी चाहिए। तीन शाखाएँ एक ओर और तीन शाखाएँ दूसरी ओर होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","हर शाखा पर बादाम के आकार के तीन प्याले होने चाहिए। हर प्याले के साथ एक कली और एक फूल होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","और स्वयं दीपाधार पर बादाम के फूल के आकार के चार और प्याले होने चाहिए। इन प्यालों के साथ भी कली और फूल होने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","दीपाधार से निकलने वाली छः शाखाएँ दो दो के तीन भागों में बटीं होनी चाहिए। हर एक दो शाखाओं के जोड़े के नीचे एक एक कली बनाओ जो दीपाधार से निकलती हो। ");
INSERT INTO hin2010_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ये सभी शाखाएँ और कलियाँ दीपाधार के साथ एक इकाई बननी चाहिए। और हर एक चीज शुद्ध सोने से तैयार की जानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","तब सात छोटे दीपक दीपाधार पर रखे जाने के लिए बनाओ। ये दीपक दीपाधार के सामने के स्थान को प्रकाश देंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","दीपक की बतियाँ बुझाने के पात्र और तश्तरियाँ शुद्ध सोने की बनानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","पचहत्तर पौंड शुद्ध सोने का उपयोग दीपाधार और इसके साथ की सभी चीज़ों को बनाने में करें। ");
INSERT INTO hin2010_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","सावधानी के साथ हर एक चीज़ ठीक—ठीक उसी ढँग से बनायी जाए जैसी मैंने पर्वत पर तुम्हें दिखाई है।” ");
INSERT INTO hin2010_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","यहोवा ने मूसा से कहा, “पवित्त्र तम्बू दस कनातों से बनाओ। इन कनातों को अच्छे रेशम तथा नीले, लाल और बैंगनी कपड़ों से बनाओ। किसी कुशल कारीगर को चाहिए कि वह करूबों को पंख सहित कनातों पर काढ़े। ");
INSERT INTO hin2010_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","हर एक कनात को एक बराबर बनाओ। हर एक कनात चौदह गज़ लम्बी और दो गज चौड़ी होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","सभी कनातों को दो भागों में सीओ। एक भाग में पाँच कनातों को एक साथ सीओ और दूसरे भाग में पाँच को एक साथ। ");
INSERT INTO hin2010_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","आखिरी कनात के सिरे के नीचे छल्ले बनाओ। इन छल्लों को बनाने के लिए नीला कपड़ा उपयोग में लाओ। कनातों के दोनों भागों में एक और नीचे छल्ले होंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","पहले भाग की आखिरी कनात में पचास छल्ले होंगे और दूसरे भाग की आखिरी कनात में पचास। ");
INSERT INTO hin2010_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","तब पचास सोने के कड़े छल्लों को एक साथ मिलाने के लिए बनाओ। यह कनातों को इस प्रकार जोड़ेंगे कि पवित्र तम्बू एक ही हो जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“तब तुम दूसरा तम्बू बनाओगे जो पवित्र तम्बू को ढकेगा। इस तम्बू को बनाने के लिए बकरियों के बाल से बनी ग्यारह कनातों का उपयोग करो। ");
INSERT INTO hin2010_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ये सभी कनातें एक बराबर होनी चाहिए। वे पन्द्रह गज लम्बी और दो गज चौड़ी होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","एक भाग में पाँच कनातों को एक साथ सीओ तब बाकी छः कनातों को दूसरे भाग में एक साथ सीओ। छठी कनात का उपयोग तम्बू के सामने के पर्दे के लिए करो। इसे इस प्रकार लपेटो कि यह द्वार की तरह खुले। ");
INSERT INTO hin2010_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","एक भाग की आखिरी कनात के सिरे पर पचास छल्ले बनाओ, ऐसा ही दूसरे भाग की आखिरी कनात के लिए करो। ");
INSERT INTO hin2010_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","तब पचास काँसे के कड़े बनाओ। इन काँसे के कड़ों का उपयोग छल्लों को एक साथ जोड़ने के लिए करो। ये कनातों को एक साथ तम्बू के रूप में जोड़ेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ये कनातें पवित्र तम्बू से अधिक लम्बी होंगी। इस प्रकार अन्त के कनात का आधा हिस्सा तम्बू के पीछे किनारों के नीचे लटका रहेगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","“वहाँ अट्ठारह इंच कनात तम्बू के बगलों में निचले किनारों से लटकती रहेगी। यह तम्बू को पूरी तरह ढक लेगी। ");
INSERT INTO hin2010_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","बाहरी आवरण को ढकने के लिए दो अन्य पर्दे बनाओ। एक लाल रंगे मेढ़े के चमड़े से बनाना चाहिए तथा दूसरा पर्दा सुइसों के चमड़े का बना होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“तम्बू के सहारे के लिए बबूल की लकड़ी के तख़्ते बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","तख्ते पन्द्रह फुट लम्बे और सत्ताईस इंच चौड़े होने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","हर तख़्ता एक जैसा होना चाहिए। हर एक तख़्ते के तले में उन्हें जोड़ने के लिए साथ—साथ दो खूंटियाँ होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","तम्बू के दक्षिणी भाग के लिए बीस तख़्ते बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ढाँचे के ठीक नीचे चाँदी के दो आधार हर एक तख़्ते के लिए होने चाहिए। इसलिए तुम्हें तख़्तें के लिए चाँदी के चालीस आधार बनाने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","तम्बू के (उत्तरी भाग) के लिए बीस तख़्ते और बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","इन तख़्तों के लिए भी चाँदी के चालीस आधार बनाओ, अर्थात् एक तख़्ते के लिए दो आधार। ");
INSERT INTO hin2010_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","तुम्हें तम्बू के (पश्चिमी छोर) के लिए छः और तख्ते बनाने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","दो तख़्ते पिछले कोनों के लिए बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","कोने के दोनों तख़्ते एक साथ जोड़ देने चाहिए। तले में दोनों तख़्तों की खूँटियाँ चाँदी के एक ही आधार में लगेंगी और ऊपर धातु का एक छल्ला दोनों तख़्तों को एक साथ रखेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","इस प्रकार सब मिलाकर आठ तख्तें तम्बू के सिरे के लिए होंगे और हर तख़्ते के नीचे दो आधारों के होने से सोलह चाँदी के आधार पश्चिमी छोर के लिए होंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“बबूल की लकड़ी का उपयोग करो और तम्बू के तख़्तों के लिए कुण्डियाँ बनाओ। तम्बू के पहले भाग के लिए पाँच कुण्डियाँ होंगी। ");
INSERT INTO hin2010_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","और तम्बू के दूसरे भाग के ढाँचे के लिए पाँच कुण्डियाँ होंगी। और तम्बू के (पश्चिमी भाग) के ढाँचे के लिए पाँच कुण्डियाँ होंगी अर्थात् तम्बू के पीछे। ");
INSERT INTO hin2010_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","पाँचों कुण्डियों के बीच की कुण्डी तख़्तों के मध्य में होनी चाहिए। यह कुण्डी तख़्तों के एक सिरे से दूसरे सिरे तक पहुँचनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","“तख़्तों को सोने से मढ़ो और तख़्तों की कुण्डियों को फँसाने के लिए कड़े बनवाओ। ये कड़े भी सोने के ही बनने चाहिए। कुण्डियों को भी सोने से मढ़ो। ");
INSERT INTO hin2010_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","पवित्र तम्बू को तुम उसी ढंग की बनाओ जैसा मैंने तुम्हें पर्वत पर दिखाया था। ");
INSERT INTO hin2010_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“सन के अच्छे रेशों का उपयोग करो और तम्बू के भीतरी भाग के लिए एक विशेष पर्दा बनाओ। इस पर्दे को नीले, बैंगनी और लाल रंग के कपड़े से बनाओ। करूब के प्रतिरूप कपड़े में काढ़ो। ");
INSERT INTO hin2010_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","बबूल की लकड़ी के चार खम्भे बनाओ। चारों खम्भों पर सोने की बनी खूँटियाँ लगाओ। खम्भों को सोने से मढ़ दो। खम्भों के नीचे चाँदी के चार आधार रखो। तब सोने की खूँटियों में पर्दा लटकाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","खूँटियों पर पर्दे को लटकाने के बाद, साक्षीपत्र के सन्दूक को पर्दे के पीछे रखो। यह पर्दा पवित्र स्थान को सर्वाधिक पवित्र स्थान से अलग करेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","सर्वाधिक पवित्र स्थान में साक्षीपत्र के सन्दूक पर ढक्कन रखो। ");
INSERT INTO hin2010_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","“पवित्र स्थान में पर्दे के दूसरी ओर विशेष मेज़ को रखो। मेज़ तम्बू के उत्तर में होनी चाहिए। तब दीपाधार को तम्बू के दक्षिण में रखो। दीपाधार मेज़ के ठीक सामने होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“तब तम्बू के मुख्य द्वार के लिए एक पर्दा बनाओ। इस पर्दे को बनाने के लिए नीले बैंगनी, लाल कपड़े तथा सन के उत्तम रेशों का उपयोग करो और कपड़े में चित्रों की कढ़ाई करो। ");
INSERT INTO hin2010_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","द्वार के इस पर्दे के लिए सोने के छल्ले बनावाओ। सोने से मढ़े बबूल की लकड़ी के पाँच खम्भे बनाओ और पाँचों खम्भों के लिए काँसे के पाँच आधार बनाओ।” ");
INSERT INTO hin2010_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","यहोवा ने मूसा से कहा, “बबूल की लकड़ी का उपयोग करो और एक वेदी बनाओ। वेदी वर्गाकार होनी चाहिए। यह साढ़े सात फूट लम्बी साढ़े सात फूट चौड़ी और साढ़े चार फुट ऊँची होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","वेदी के चारों कोनों पर सींग बनाओ। हर एक सींग को इसके कोनों से ऐसे जोड़ो कि सभी एक हो जाए तब वेदी को काँसे से मढ़ो। ");
INSERT INTO hin2010_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","“वेदी पर काम आने वाले सभी उपकरणों और तश्तरियों को काँसे का बनाओ। काँसे के बर्तन, पल्टे, कटोरे, काँटे और तसले बनाओ। ये वेदी से राख को निकालने में काम आएंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","जाल के जैसी काँसे की एक बड़ी जाली बनाओ। जाली के चारों कोनों पर काँसे के कड़े बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","जाली को वेदी की परत के नीचे रखो। जाली वेदी के भीतर बीच तक रहेगी। ");
INSERT INTO hin2010_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","“वेदी के लिए बबूल की लकड़ी के बल्ले बनाओ और उन्हें काँसे से मढ़ो। ");
INSERT INTO hin2010_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","वेदी के दोनों ओर लगे कड़ो में इन बल्लों को डालो। इन बल्लों को वेदी को ले जाने के लिए काम में लो। ");
INSERT INTO hin2010_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","वेदी भीतर से खोखली रहेगी और इसकी अगल—बगल तख्तों की बनी होगी। वेदी वैसी ही बनाओ जैसी मैंने तुमको पर्वत पर दिखाई थी। ");
INSERT INTO hin2010_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“तम्बू के चारों ओर कनातों की एक दीवार बनाओ। यह तम्बू के लिए एक आँगन बनाएगी। दक्षिण की ओर कनातों की यह दीवार पचास गज लम्बी होनी चाहिए। ये कनातें सन के उत्तम रेशों से बनी होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","बीस खम्भों और उनके नीचे बीस काँसे के आधारों का उपयोग करो। खम्भों के छल्लें और पर्दे की छड़े चाँदी की बननी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","उत्तर की ओर लम्बाई उतनी ही होनी चाहिए जितनी दक्षिण की ओर थी। इसमें पचास गज़ लम्बी पर्दो की दीवार, बीस खम्भे और बीस काँसे के आधार होने चाहिए। खम्भे और उनके पर्दो की छड़ों के छल्ले चाँदी के बनने चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“आँगन के पश्चिमी सिरे पर कनातों की एक दीवार पच्चीस गज लम्बी होनी चाहिए। वहाँ उस दीवार के साथ दस खम्भे और दास आधार होने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","आँगन का पूर्वी सिरा भी पच्चीस गज लम्बा होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","यह पूर्वी सिरा आँगन का प्रवेश द्वार है। ");
INSERT INTO hin2010_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","प्रवेश द्वार की हर एक ओर की कनातें साढ़े सात गज लम्बी होनी चाहिए। उस ओर तीन खम्भे और तीन आधार होने चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“एक कनात दस गज लम्बी आँगन के प्रवेश द्वार को ढ़कने के लिए बनाओ। इस कनात को सन के उत्तम रेशों और नीले, लाल और बैंगनी कपड़े से बनाओ। इन कनातों पर चित्रों को काढ़ो। उस पर्दे के लिए चार खम्भे और चार आधार होने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","आँगन के चारों ओर के सभी खम्भे चाँदी की छड़ों से ही जोड़े जाने चाहिए। खम्भों के छल्ले चाँदी के बनाने चाहिए और खम्भों के आधार काँसे के होने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","आँगन पचास गज लम्बा और पच्चीस गज चौड़ा होना चाहिए। आँगन के चारों ओर की दीवार साढ़े सात फुट ऊँची होनी चाहिए। पर्दा सन के उत्तम रेशों का बना होना चाहिए। सभी खम्भों के नीचे के आधार काँसे के होने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","सभी उपकरण, तम्बू की खूँटियाँ और तम्बू में लगी हर एक चीज़ काँसे की ही बननी चाहिए। और आँगन के चारों ओर के पर्दो के लिए खूँटियाँ काँसे की ही होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“इस्राएल के लोगों को सर्वोत्तम जैतून का तेल लाने का आदेश दो। इस तेल का उपयोग हर एक सन्ध्या को जलने वाले दीपक के लिए करो। ");
INSERT INTO hin2010_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","हारून और उसके पुत्र प्रकाश का प्रबन्ध करने का कार्य संभालेंगे। वे मिलापवाले तम्बू के पहले कमरे में जाएंगे। यह कमरा साक्षीपत्र के सन्दूक वाले कमरे के बाहर उस पर्दे के सामने है जो दोनों कमरों को अलग करता है। वे इसका ध्यान रखेंगे कि इस स्थान पर यहोवा के सामने दीपक सन्ध्या से प्रातः तक लगातार जलते रहेंगे। इस्राएल के लोग और उनके वंशज इस नियम का पालन सदैव करेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“अपने भाई हारून और उसके पुत्रों नादाब, अबीहू, एलिआजार और ईतामर को इस्राएल के लोगों में से अपने पास आने को कहो। ये व्यक्ति मेरी सेव याजक के रूप में करेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","“अपने भाई हारून के लिए विशेष वस्त्र बनाओ। ये वस्त्र उसे आदर और गौरव देंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","लोगों में ऐसे कुशल कारीगर है जो ये वस्त्र बना सकते हैं। मैंने इन व्यक्तियों को विशेष बुद्धि दी है। उन लोगों से हारून के लिए वस्त्र बनाने को कहो। ये वस्त्र बताएंगे कि वह मेरी सेवा विशेष रूप से करता है। तब वह मेरी सेवा याजक के रूप में कर सकता है। ");
INSERT INTO hin2010_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","कारीगरों को इन वस्त्त्रों को बनाना चाहिए न्याय का थैला एपोद बिना बाँह की विशेष एपोद एक नीले रंग का लबादा, एक सफेद बुना चोगा, सिर को ढकने के लिए एक साफा और एक पटुका लोगों को ये विशेष वस्त्र तुम्हारे भाई हारून और उसके पुत्र मेरी सेवा याजक के रूप में कर सकते हैं। ");
INSERT INTO hin2010_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","लोगों से कहो कि वे सुनहरे धागों, सन के उत्तम रेशों तथा नीले, लाल और बैंगनी कपड़े उपयोग में लाएं। ");
INSERT INTO hin2010_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“एपोद बनाने के लिए सुनहरे धागे, सन के उत्तम रेशों तथा नीले, लाल और बैंगनी कपड़े का उपयोग करो। इस विशेष एपोद को कुशल कारीगर बनाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","एपोद के हर एक कंधे पर पट्टी लगी होगी। कंधे की ये पट्टियाँ एपोद के दोनों कोनों पर बंधी होंगी। ");
INSERT INTO hin2010_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","“कारीगर बढ़ी सावधानी से एपोद पर बाँधने के लिए एक पटुका बुनेंगे। (यह पटुका उन्हीं चीज़ों का होगा जिनका एपोद, सुनहरे धागे, सन के उत्तम रेशों और बैंगनी कपड़े।) ");
INSERT INTO hin2010_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“तुम्हें दो गोमेदक रत्न लेने चाहिए। इन नगों पर इस्राएल के बारह पुत्रों के नाम खोदो। ");
INSERT INTO hin2010_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","छः नाम एक नग पर और छः नाम दूसरे नार पर। नामों को सबसे बड़े से सबसे छोटे के क्रम में लिखो। ");
INSERT INTO hin2010_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","इस्राएल के पुत्रों के नामों को इन नगों पर खुदवाओ। यह उसी प्रकार करो जिस प्रकार वह व्यक्ति जो मुहरें बनाता है, शब्द और चित्रों को खोदता है। नग के चारों ओर सोना लगाओ जिससे उन्हें एपोद के कंधो पर टाँका जा सके। ");
INSERT INTO hin2010_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","तब एपोद के हर एक कंधे के पट्टी पर इन दोनों नगों को जड़ो। हारून यहोवा के सम्मुख जब खड़ा होगा, इस विशेष एपोद को पहनेगा और इस्राएल के पुत्रों के नाम वाले दोनों नग एपोद पर होंगे। यह इस्राएल के लोगों को याद रखने में यहोवा की सहायता करेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","अच्छा सोना ही नगों को एपोद पर ढाँकने के लिए उपयोग में लाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","रस्सी की तरह एक में शुद्ध सोने की जंजीरे बटो। सोने की ऐसी दो जंजीरे बनाओ और सोने के जड़ाव के साथ इन्हें बांधो।” ");
INSERT INTO hin2010_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“महायाजक के लिए सीनाबन्द बनाओ। कुशल कारीगर इस सीनाबन्द को वैसे ही बनाए जैसे एपोद को बनाया। वे सुनहरे धागे, सन के उत्तम रेशों तथा नीले, लाल और बैंगनी कपड़े का उपयोग करें। ");
INSERT INTO hin2010_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","सीनाबन्द नौ इंच लम्बा और नौ इंच चौड़ा होना चाहिए। चौकोर जेब बनाने के लिए इसकी दो तह करनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","सीनाबन्द पर सुन्दर रत्नों की चार पक्तियाँ जड़ो। रत्नों की पहली पंक्ति में एक लाल, एक पुखराज और एक मर्कत मणि होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दूसरी पंक्ति मे फिरोजा, नीलम तथा पन्ना होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तीसरी पंक्ति मे धुम्रकान्त, अकीक और याकूत लगना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","चौथी पंक्ति में लहसुनिया, गोमेदक रत्न और कपिश मणि लगानी चाहिए। सीनाबन्द पर इन्हें लगाने के लिए उन्हें सोने मे जड़ो। ");
INSERT INTO hin2010_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","सीनाबन्द पर बारह रत्न होंगे जो इस्राएल के बारह पुत्रों का एक प्रतिनिधित्व करेंगे। हर एक नग पर इस्राएल के पुत्रों में से एक—एक का नाम लिखो। मुहर को तरह हर एक नग पर इन नामों को खोदो। ");
INSERT INTO hin2010_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“सीनाबन्द के चारो और जाती हुई सोने की जंजीरें बनाओ। ये जंजीर बटी हुई रस्सी की तरह होंगी। ");
INSERT INTO hin2010_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","दो सोने के छल्ले बनाओ और इन्हें सीनाबन्द के दोनों कोनों पर लगाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","(दोनों सुनहरी जंजीरों को सीनाबन्द में दोनों में लगे छल्लों में डालो।) ");
INSERT INTO hin2010_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","सोने की जंजीरों को दूसरे सिरों को कंधे की पट्टियों पर के जड़ाव में लगाओ। जिससे वे एपोद के साथ सोने पर कसे रहें। ");
INSERT INTO hin2010_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","दो अन्य सोने के छल्ले बनाओ और उन्हें सीनाबन्द के दूसरे दोनों कोनों पर लगाओ। यह सीनाबन्द का भीतरी भाग एपोद के समीप होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","दो और सोने के छल्ले बनाओ और उन्हें कंधे की पट्टी के तले एपोद के सामने लगाओ। सोने के छल्लों को एपोद की पेटी के समीप ऊपर के स्थान पर लगाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","सीनाबन्द के छल्लों को एपोद के छल्लों से जोड़ो। उन्हें पेटी से एक साथ जोड़ने के लिए नीली पट्टियों का उपयोग करो। इस प्रकार सीनाबन्द एपोद से अलग नहीं होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“हारून जब पवित्र स्थान में प्रवेश करे तो उसे इस सीनाबन्द को पहने रहना चाहिए। इस प्रकार इस्राएल के बारहों पुत्रों के नाम उसके मन में रहेंगे और यहोवा को सदा ही उन लोगों की याद दिलाई जाती रहेगी। ");
INSERT INTO hin2010_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ऊरीम और तुम्मीम को सीनाबन्द में रखो। हारून जब यहोवा के सामने जाएगा तब ये सभी चीज़ें उसे याद होंगी। इसलिए हारून जब यहोवा के सामने होगा तब वह इस्राएल के लोगों का न्याय करने का साधन सदा अपने साथ रखेगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“एपोद के नीचे पहनने के लिए एक चोगा बनाओ। चोगा केवल नीले कपड़े का बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","सिर के लिए इस कपड़े के बीचोबीच एक छेद बनाओ। इस छेद के चारों ओर गोट लगाओ जिससे यह फटे नहीं। ");
INSERT INTO hin2010_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","नीले, लाल और बैंगनी कपड़े के फुदने बनाओ जो अनार के आकार के हों। इन अनारों को चोगे के निचले सिरे में लटकाओ और उनके बीच सोने की घंटियाँ लटकाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","इस प्रकार चोगे के निचले सिरे के चारों ओर क्रमशः एक अनार और एक सोने की घंटी होगी। ");
INSERT INTO hin2010_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","हारून तब इस चोगे को पहनेगा जब वह याजक के रूप में सेवा करेगा और यहोवा के सामने पवित्र स्थान में जाएगा। जब वह पवित्र स्थान में प्रवेश करेगा और वहाँ से निकलेगा तब ये घंटियाँ बजेंगी। इस प्रकार हारून मरेगा नहीं। ");
INSERT INTO hin2010_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“शुद्ध सोने का एक पतरा बनाओ। सोने में मुहर की तरह शब्द लिखो। ये शब्द लिखो: यहोवा के लिए पवित्र ");
INSERT INTO hin2010_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","सोने के इस पतरे को उस पगड़ी पर लगाओ जो सिर को ढकने के लिए पहनी गयी है। उस पगड़ी से सोने के पतरे को बाँधने के लिए नीले कपड़े की पट्टी का उपयोग करो। ");
INSERT INTO hin2010_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","हारून यह दर्शाने के लिए इसे अपने ललाट पर पहनेगा कि इस्राएल के लोगों ने अपने अपराधों के लिए जो पवित्र भेंटे यहोवा को अर्पित की है उनके अपराधों को प्रतीक रूप में हारून वहन कर रहा है। हारून जब भी यहोवा के सामने जाएगा ये सदा पहने रहेगा, ताकि यहोवा उन्हें स्वीकार कर ले। ");
INSERT INTO hin2010_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“लबादा बनाने के लिए सन के उत्तम रेशों को उपयोग में लाओ और उस कपड़े को बनाने के लिए भी सन के उत्तर रेशों को उपयोग में लाओ जो सिर को ढ़कता है, इसमें कढ़ाई कढ़ी होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","लबादा, पटुका और पगड़ियाँ हारून के पुत्रों के लिए भी बनाओ ये उन्हें गौरव तथा आदर देंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ये पोशाक अपने भाई हारून और उसके पुत्रों को पहनाओ। उसके बाद जैतून का तेल उनके सिर पर यह दिखाने के लिए डालो कि वे याजक हैं, यह उन्हें पवित्र बनायेगा। तब वे मेरी सेवा याजक के रूप में करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“उन के वस्त्रों को बनाने के लिए सन के उत्तम रेशों का उपयोग करो जो विशेष याजक के वस्त्रों के नीचे पहनने के लिए होंगे। ये अधोवस्त्र कमर से जाँघ तक पहने जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","हारून और उसके पुत्रों को इन वस्त्रों को ही पहनना चाहिए जब कभी वे मिलापवाले तम्बू में जाएं। उन्हें इन्हीं वस्त्रों को पहनना चाहिए जब कभी वे पवित्र स्थान में याजक के रूप में सेवा के लिए वेदी के समीप आएं। यदि वे इन पोशाकों को नहीं पहनेंगे, तो वे अपराध करेंगे और उन्हें मरना होगा। यह ऐसा नियम होना चाहिए जो हारून और उसके बाद उसके वंश के लोगों के लिए सदा के लिए बना रहेगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“अब मैं तुम्हें बताऊँगा कि हारून और उसके पुत्र मेरी सेवा विशेष रूप में करते है, यह दिखाने के लिए तुम्हें क्या करना चाहिए। एक दोष रहित बछड़ा और दो दोष रहित मेढ़े लाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","जिसमें खमीर न मिलाया गया हो ऐसा महीन आटा लो और उससे तीन तरह की रोटीयाँ बनाओ—पहली बिना खमीर की सादी रोटी। दूसरी तेल का मोमन डली रोटी और तीसरी वैसे ही आटे की छोटी पतली रोटी बनाकर उस पर तेल चुपड़ो। ");
INSERT INTO hin2010_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","इन रोटियों को एक टोकरी में रखो ओर फिर इस टोकरी को हारून और उसके पुत्रों को दो, साथ ही वह बछड़ा और दोनों मेढ़े भी दो। ");
INSERT INTO hin2010_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“तब हारून और उसके पुत्रों को मिलापवाले तम्बू के द्वार के सामने लाओ, तब उन्हें पानी से नहलाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","हारून की विशेष पोशाक उसे पहनाओ, लबादा, चोगा और एपोद। फिर उस पर सीनाबन्द, फिर विशेष पटुका बाँधो ");
INSERT INTO hin2010_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","और फिर पगड़ी उसके सिर पर बाँधो। सोने की पट्टी को जो एक विशेष मुकुट के जैसी है पगड़ी के चारों ओर बाँधो ");
INSERT INTO hin2010_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","और जैतून का तेल डालो जो बताएगा कि हारून इस काम के लिए चुना गया है।” ");
INSERT INTO hin2010_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“तब उसके पुत्रों को उस स्थान पर लाओ और उन्हें चोगे पहनाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","तब उनकी कमर के चारों ओर पटुके बाँधो। उन्हें पहनने को पगड़ी दो। उस समय से वे याजक के रूप में काम करना आरम्भ करेंगे। वे उस नियम के अनुसार जो सदा रहेगा, याजक होंगे। यही ढंग है जिससे तुम हारून और उसके पुत्रों को याजक बनाओगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“तब मिलापवाले तम्बू के सामने के स्थान पर बछड़े को लाओ। हारून और उसके पुत्रों को चाहिए कि वे बछड़े के सिर पर हाथ रखें। ");
INSERT INTO hin2010_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","तब उस बछड़े को मिलापवाले तम्बू के द्वार पर यहोवा के सामने मार डालो। ");
INSERT INTO hin2010_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","तब बछड़े का कुछ खून लो और वेदी तक जाओ। अपनी उँगली से वेदी पर लगे सींगों पर कुछ खून लगाओ। बचा हुआ सारा खून नीचे वेदी पर डालो। ");
INSERT INTO hin2010_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","तब बछड़े में से सारी चर्बी निकालो। तब कलेजे के चारों ओर की चर्बी और दोनों गुर्दे और उसकी चारों ओर की चर्बी लो। इस चर्बी को वेदी पर जलाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","तब बछड़े के माँस, उसके चमड़े और उसके दूसरे अंगों को लो और अपने डेरे से बाहर जाओ। इन चीज़ों को डेरे के बाहर जलाओ। यह भेंट है जो याजकों के पापों को दूर करने के लिए चढ़ाई जाती है। ");
INSERT INTO hin2010_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“तब हारून और उसके पुत्रों से मेढ़े के सिर पर हाथ रखने को कहो। ");
INSERT INTO hin2010_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","तब उस मेढ़े को मार डालो और उसके खून को लो। खून को वेदी के चारों ओर छिड़को। ");
INSERT INTO hin2010_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","तब मेढ़े को कई टुकड़ों में काटो। मेढ़े के भीतर के सभी अंगो और पैरों को धोओ। इन चीज़ों को सिर तथा मेढ़े के अन्य टुकड़ों के साथ रखो। ");
INSERT INTO hin2010_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","तब वेदी पर इन को जलाओ। यह वह विशेष भेंट है जो जलाई जाती है। यह होमबलि यहोवा के लिए है। इसकी सुगन्ध यहोवा को प्रसन्न करेगी। यह ऐसी होमबलि है जो यहोवा को आग के द्वारा दी जाती है। ");
INSERT INTO hin2010_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“हारून और उसके पुत्रों को दूसरे मेढ़े पर हाथ रखने को कहो। ");
INSERT INTO hin2010_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","उस मेढ़े को मारो और उसका कुछ खून लो। उस खून को हारून और उसके पत्रों के दाएं कान के निचले भाग में लगाओ। उनके दाएँ हाथ के अंगूठों पर भी कुछ खून लगाओ और कुछ खून उनके दाएँ पैर के अगूँठों पर लगाओ। बाकी के खून को वेदी के चारों ओर छिड़को। ");
INSERT INTO hin2010_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","तब वेदी पर छिड़के खून में से कुछ खून लो। इसे अभिषेक के तेल में मिलाओ और हारून तथा उसके वस्त्रों पर छिड़को और उसके पुत्रों और उनके वस्त्रों पर भी छिड़को। यह बताएगा कि हारून और उसके पुत्र मेरी सेवा विशेष रूप से करते हैं। और यह सूचित करेगा कि उनके वस्त्र विशेष अवसर पर ही काम में आते हैं। ");
INSERT INTO hin2010_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“तब उस मेढ़े से चर्बी लो। (यही मेढ़ा है जिसका उपयोग हारून को महायाजक बनाने में होगा।) पूँछ के चारों ओर की चर्बी तथा उस चर्बी को लो जो शरीर के भीतर के अंगों को ढकती है, कलेजे को ढकने वाली चर्बी को लो, दोनो गुर्दो और दाएँ पैर को लो। ");
INSERT INTO hin2010_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","तब उस रोटी की टोकरी को लो जिसमें तुमने अख़मीरी रोटियाँ रखी थीं। यही टोकरी है जिसे तुम्हें यहोवा के सम्मुख रखना है। इन रोटियों को टोकरी से बाहर निकालो। एक रोटी, सादी, एक तेल से बनी और एक छोटी पतली चुपड़ी हुई। ");
INSERT INTO hin2010_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","तब इन को हारून और उसके पुत्रों को दो: फिर उनसे कहो कि वे यहोवा के सामने इन्हें अपने हाथों में उठाएँ। यह यहोवा को विशेष भेंट होगी। ");
INSERT INTO hin2010_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","तब इन रोटियों को हारून और उसके पुत्रों से लो और उन्हें वेदी पर मेढ़ें के साथ रखो। यह एक होमबलि है, यह यहोवा को ऐसी भेंट होगी जो आग के द्वारा दी जाती है। इस की सुगन्ध यहोवा को प्रसन्न करेगी।” ");
INSERT INTO hin2010_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“तब इस मेढ़े से उसकी छाती को निकालो। (यही मेढ़ा है जिसका उपयोग हारून को महायाजक बनाने के लिए बलि दिया जाएगा।) मेढ़े की छाती को विशेष भेंट के रूप में यहोवा के सामने पकड़ो। जानवर का यह भाग तुम्हारा होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","तब मेढ़े की उस छाती और टाँग को लो जो हारून को महायाजक बनाने के लिए उपयोग में आयी थी। इन्हें पवित्र बनाओ और इन्हें हारून और उसके पुत्रों को दो। वह भेंट का विशेष अंश होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","इस्राएल के लोग इन अंगो को हारून और उसके पुत्रों को सदा देंगे। जब कभी इस्राएल के लोग यहोवा को मेलबलि चढ़ायेंगे तो ये भाग सदा याजकों के होंगे। जब वे इन भागों को याजकों को देंगे तो यह यहोवा को देने जैसा ही होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“उन विशेष वस्त्रों को सुरक्षित रखो जो हारून के लिए बने थे। ये वस्त्र उसके उत्तराधिकारी वंशजों के लिए होंगे। वे उन वस्त्रों को तब पहनेंगे जब याजक नियुक्त किए जाएँगे। ");
INSERT INTO hin2010_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","हारून का जो पुत्र उसके बाद अगला महायाजक होगा, वह सात दिन तक उन वस्त्रों को पहनेगा, जब वह मिलापवाले तम्बू के पवित्र स्थान में सेवा करने आएगा। ");
INSERT INTO hin2010_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“उस मेढ़े के माँस को पकाओ जो हारून को महायाजक बनाने के लिए उपयोग में आया था। उस माँस को एक पवित्र स्थान पर पकाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","तब हारून और उसके पुत्र मिलापवाले तम्बू के द्वार पर माँस खाएंगे, और वे उस टोकरी की रोटी भी खाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","इन भेटों का उपयोग उनके पाप को समाप्त करने के लिए तब हुआ था जब वे याजक बने थे। ये मेढ़े बस उन्हीं को खाना चाहिए किसी अन्य को नहीं। क्योंकि ये पवित्र है। ");
INSERT INTO hin2010_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","यदि उस मेढ़े का कुछ माँस या कोई रोटी अगले सवेरे के लिए बच जाए तो उसे जला देना चाहिए। तुम्हें वह रोटी या माँस नहीं खाना चाहिए क्योंकि यह केवल विशेष ढंग से विशेष समय पर ही खाया जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“वैसा ही करो जैसा मैंने तुम्हें हारून और उसके पुत्रों के लिए करने को आदेश दिया है। यह समारोह सात दिन तक चलेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","सात दिन तक हर रोज़ एक—एक बछड़े को मारो। यह हारून और उसके पुत्रों के पाप के लिए भेंट होगी। तुम इन दिनों दिए गए बलिदानों का उपयोग वेदी को शुद्ध करने के लिए करना और वेदी को पवित्र बनाने के लिए जैतून का तेल इस पर डालना। ");
INSERT INTO hin2010_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","तुम सात दिन तक वेदी को शुद्ध और पवित्र करना। उस समय वेदी अत्याधिक पवित्र होगी। वेदी को छूने वाली कोई भी चीज़ पवित्र हो जाएगी। ");
INSERT INTO hin2010_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“हर एक दिन वेदी पर तुम्हें एक भेंट चढ़ानी चाहिए। तुम्हें एक—एक वर्ष के दो मेमनों की भेंट चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","एक मेमने की भेंट प्रातःकाल चढ़ाओ और दूसरे की संन्ध्या के समय। ");
INSERT INTO hin2010_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","41","जब तुम पहले मेमने को मारो, दो पौण्ड गेहूँ का महीन आटा भी भेंट चढ़ाओ। गेहूँ के आटे को एक क्वार्ट भेंट स्वरूप दाखमधु में मिलाओ। जब तुम दूसरे मेमने को सन्ध्या के समय मारो तब दो पौण्ड महीन आटा भी भेंट में चढ़ाओ और एक क्वार्ट दाखमधु भी भेंट करो। यह वैसा ही है जैसा तुमने प्रातः काल किया था। यह यहोवा को भोजन की भेंट होगी। जब तुम उस भेंट को जलाओगे तो यहोवा इसकी सुगन्ध लेगा और यह उसे प्रसन्न करेगी। ");
INSERT INTO hin2010_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“तुम्हें इन चीज़ों को यहोवा को भेंट में रोज़ जलाना चाहिए। यह यहोवा के सामने, मिलापवाले तम्बू के द्वार पर करो। यह सदा करते रहो। जब तुम भेंट चढ़ाओगे तब मैं अर्थात् यहोवा वहाँ तुम से मिलूँगा और तुमसे बातें करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","मैं इस्राएल के लोगों से उस स्थान पर मिलूँगा और वह स्थान मेरे तेज़ के कारण पवित्र बन जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“इस प्रकार मैं मिलापवाले तम्बू को पवित्र बनाऊँगा और मैं वेदी को भी पवित्र बनाऊँगा और मैं हारून और उसके पुत्रों को पवित्र बनाऊँगा जिससे वे मेरी सेवा याजक के रूप में कर सकें। ");
INSERT INTO hin2010_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","मैं इस्राएल के लोगों के साथ रहूँगा। मैं उनका परमेश्वर होऊँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","लोग यह जानेंगे कि मैं उनका परमेश्वर यहोवा हूँ। वे जानेंगे कि मैं ही वह हूँ जो उन्हें मिस्र से बाहर लाया ताकि मैं उनके साथ रह सकूँ। मैं उनका परमेश्वर यहोवा हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","परमेश्वर ने मूसा से कहा, “बबूल की लकड़ी की एक वेदी बनाओ। तुम इस वेदी का उपयोग धूप जलाने के लिए करोगे। ");
INSERT INTO hin2010_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","तुम्हें वेदी को वर्गाकार अट्ठारह इंच लम्बी और अट्ठारह इंच चौड़ी बनानी चाहिए। यह छत्तीस इंच ऊँची होनी चाहिए। चारों कोनों पर सींग लगे होने चाहिए। ये सींग वेदी के साथ एक ही इकाई के रूप में वेदी के साथ जड़े जाने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","वेदी के ऊपरी सिरे तथा उसकी सभी भुजाओं को शुद्ध सोने से मढ़ो। वेदी के चारों ओर सोने की पट्टी लगाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","इस पट्टी के नीचे सोने के दो छल्ले होने चाहिए। वेदी के दूसरी ओर भी सोने के दो छल्ले होने चाहिए। ये छल्ले वेदी को ले जाने के लिए बल्लियों को फँसाने के लिए होंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","बल्लियों को भी बबूल की लकड़ी से ही बनाओ। बल्लियों को सोने से मढ़ो। ");
INSERT INTO hin2010_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","वेदी को विशेष पर्दे के सामने रखो। साक्षीपत्र का सन्दूक उस पर्दे के दूसरी ओर है। उस सन्दूक को ढकने वाले ढक्कन के सामने वेदी रहेगी। यही वह स्थान है जहाँ मैं तुमसे मिलूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“हारून हर प्रातः सुगन्धित धूप वेदी पर जलाएगा। वह यह तब करेगा जब वह दीपकों की देखभाल करने आएगा। ");
INSERT INTO hin2010_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","उसे शाम को जब वह दीपकों की देखभाल करने आए फिर धूप जलानी चाहिए। जिससे यहोवा के सामने नित्य प्रति सुबह शाम धूप जलती रहे। ");
INSERT INTO hin2010_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","इस वेदी का उपयोग किसी अन्य प्रकार की धूप या होमबलि के लिए मत करना। इस वेदी का उपयोग अन्नबलि या पेय भेंट के लिए मत करना। ");
INSERT INTO hin2010_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","“वर्ष में एक बार हारून यहोवा को विशेष बलिदान अवश्य चढ़ाए। हारून पापबलि के खून का उपयोग लोगों के पापों को धोने के लिए करेगा, हारून इस वेदी के सींगों पर यह करेगा। यह दिन प्रायश्चित का दिन कहलाएगा। यह यहोवा के लिए अति पवित्र दिन होगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“इस्राएल के लोगों को गिनो जिससे तुम जानोगे कि वहाँ कितने लोग है। जब कभी यह किया जाएगा हर एक व्यक्ति अपने जीवन के लिए यहोवा को धन देगा। यदि हर एक व्यक्ति यह करेगा तो लोगों के साथ कोई भी भयानक घटना घटित नहीं होगी। ");
INSERT INTO hin2010_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","हर व्यक्ति जिसे गिना जाए वह (आधा शेकेल चाँदी अवश्य दे। ");
INSERT INTO hin2010_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","हर एक पुरुष जिसे गिना जाए और जो बीस वर्ष या उससे अधिक आयु का हो,) यहोवा को यह भेंट देगा। ");
INSERT INTO hin2010_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","धनी लोग आधे शेकेल से अधिक नहीं देंगे और गरीब लोग आधे शेकेल से कम नहीं देंगे। सभी लोग यहोवा को बराबर ही भेंट देंगे यह तुम्हारे जीवन का मूल्य होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","इस्राएल के लोगों से यह धन इकट्ठा करो। मिलापवाले तम्बू में सेवा के लिए इसका उपयोग करो। यह भुगतान यहोवा के लिए अपने लोगों को याद करने का एक तरीका होगा। वे अपने जीवन के लिए भुगतान करते रहेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“एक काँसे की चिलमची बनाओ और इसे काँसे के आधार पर रखो। तुम इसका उपयोग हाथ पैर धोने के लिए करोगे। चिलमची को मिलापवाले तम्बू और वेदी के बीच रखो। चिलमची को पानी से भरो। ");
INSERT INTO hin2010_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","हारून और उसके पुत्र इस चिलमची के पानी से अपने हाथ पैर धोएंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","हर बार जब वे मिलापवले तम्बू में आएँ तो पानी से हाथ पैर अवश्य धोएँ, इससे वे मरेंगे नहीं। जब वे वेदी के समीप यहोवा की सेवा करने या धूप जलाने आएं, ");
INSERT INTO hin2010_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","तो वे अपने हाथ पैर अवश्य धोएँ, इससे वे मरेंगे नहीं। यह ऐसा नियम होगा जो हारून और उसके लोगों के लिए सदा बना रहेगा। यह नियम हारून के उन सभी लोगों के लिए बना रहेगा जो भविष्य में होंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“बहुत अच्छे मसाले लाओ। बारह पौंड द्रव लोबान लाओ और इस तोल का आधा अर्थात् छः पौंड, सुगन्धित दालचीनी और बारह पौंड सुगन्धित छाल, ");
INSERT INTO hin2010_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","और बारह पौंड तेजपात लाओ। इन्हें नापने के लिए प्रामाणिक बाटों का उपयोग करो। एक गैलन जैतून का तेल भी लाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","“सुगन्धित अभिषेक का तेल बनाने के लिए इन सभी चीज़ों को मिलाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","मिलापवाले तम्बू और साक्षीपत्र के सन्दूक पर इस तेल को डालो। यह इस बात का संकेत करेगा कि इन चीज़ों का विशेष उद्देश्य है। ");
INSERT INTO hin2010_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","मेज़ और मेज़ पर की सभी तश्तरियों पर तेल डालो। इस तेल को दीपक और सभी उपकरणों पर डालो। ");
INSERT INTO hin2010_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","धूप वाली वेदी पर तेल डालो। यहोवा के लिए होमबलि वाली वेदी पर भी तेल डालो। उस वेदी की सभी चीज़ों पर यह तेल डालो। कटोरे और उसके नीचे के आधार पर यह तेल डालो। ");
INSERT INTO hin2010_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","तुम इन सभी चीज़ों को समर्पित करोगे। वे अत्यन्त पवित्र होंगी। कोई भी चीज जो इन्हें छूएगी वह भी पवित्र हो जाएगी। ");
INSERT INTO hin2010_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“हारून और उसके पुत्रों पर तेल डालो। यह स्पष्ट करेगा कि वे मेरी विशेष डंग से सेवा करते हैं। तब ये मेरी सेवा याजक कि तरह कर सकते हैं। ");
INSERT INTO hin2010_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","इस्राएल के लोगों से कहो कि अभिषेक का तेल मेरे लिए सदैव अति विशेष होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","साधारण सुगन्ध की तरह कोई भी इस तेल का उपयोग नहीं करेगा। उस प्रकार कोई सुगन्ध न बनाओ जिस प्रकार तुमने यह विशेष तेल बनाया। यह तेल पवित्र है और यह तुम्हारे लिए अति विशेष होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","यदि कोई इस पवित्र तेल की तरह सुगन्ध बनाए और उसे किसी विदेशी को दे तो उस व्यक्ति को अपने लोगों से अवश्य अलग कर दिया जाये।” ");
INSERT INTO hin2010_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","तब यहोवा ने मूसा से कहा, “इन सुगन्धित मसालों को लो: रसगंधा, कस्तूरी गंधिका, बिरोजा और शुद्ध लोबान। सावधानी रखो कि तुम्हारे पास मसालों की बराबर मात्रा हो। ");
INSERT INTO hin2010_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","मसालों को सुगन्धित धूप बनाने के लिए आपस में मिलाओ। इसे उसी प्रकार करो जैसा सुगन्ध बनाने वाला व्यक्ति करता है। इस धूप में नमक भी मिलाओ। यह इसे शुद्ध और पवित्र बनाएगा। ");
INSERT INTO hin2010_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","कुछ धूप को तब तक पीसते रहो जब तक उसका बारीक चूर्ण न हो जाये। मिलापवाले तम्बू में साक्षीपत्र के सन्दूक के सामने इस चूर्ण को रखो। यही वह स्थान है जहाँ मैं तुमसे मिलूँगा। तुम्हें इस धूप के चूर्ण का उपयोग इसके अति विशेष अवसर पर ही करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","तुम्हें इस चूर्ण का उपयोग केवल विशेष ढँग से यहोवा के लिए ही करना चाहिए। तुम इस धूप को विशेष ढँग से बनाओगे। इस विशेष ढँग का उपयोग अन्य कोई धूप बनाने के लिए मत करो। ");
INSERT INTO hin2010_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","कोई व्यक्ति अपने लिए कुछ ऐसे धूप बनाना चाह सकता है जिससे वह सुगन्ध का आनन्द ले सके। किन्तु यदि वह ऐसा करे तो उसे अपने लोगों से अवश्य अलग कर दिया जाये।” ");
INSERT INTO hin2010_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","तब यहोवा ने मूसा के कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“मैंने यहूदा के कबीले से ऊरो के पुत्र बसलेल को चुना है। ऊरो हूर का पुत्र था। ");
INSERT INTO hin2010_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","मैंने बसलेल को परमेश्वर की आत्मा से भर दिया है, अर्थात् मैंने उसे सभी प्रकार की चीज़ों को करने का ज्ञान और निपुणता दे दी है। ");
INSERT INTO hin2010_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","बसलेल बहुत अच्छा शिल्पकार है और वह सोना, चाँदी तथा काँसे की चीज़ें बना सकता है। ");
INSERT INTO hin2010_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","बसलेल सुन्दर रत्नों को काट और जड सकता है। वह लकड़ी का भी काम कर सकता है। बसलेल सब प्रकार के काम कर सकता है। ");
INSERT INTO hin2010_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","मैंने ओहोलीआब को भी उसके साथ काम करने को चुना है। आहोलीआब दान कबीले के अहीसामाक का पुत्र है और मैंने दूसरे सब श्रमिकों को भी ऐसी निपुणता दी है कि वे उन सभी चीज़ों को बना सकते हैं जिसे मैंने तुमको बनाने का आदेश दिया है: ");
INSERT INTO hin2010_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","मिलापवाला तम्बू, साक्षीपत्र का सन्दूक, सन्दूक को ढकने वाला ढक्कन, मिलापवाले तम्बू का साजोसामान, ");
INSERT INTO hin2010_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","मेज और उस पर की सभी चीजें, शुद्ध सोना का दीपाधार, धूप जलाने की वेदी, ");
INSERT INTO hin2010_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","भेंट जलाने के लिए वेदी, और वेदी पर उपयोग की चीज़ें, चिलमची और उसके नीचे का आधार, ");
INSERT INTO hin2010_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","याजक हारून के लिए सभी विशेष वस्त्र और उसके पुत्रों के लिए सभी विशेष वस्त्र, जिन्हें वे याजक के रूप मे सेवा करते समय पहनेंगे, ");
INSERT INTO hin2010_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","अभिषेक का सुगन्धित तेल, और पवित्र स्थान के लिए सुगन्धित धूप। इन सभी चीज़ों को उसी ढंग से बनांएगे जैसा मैंने तुमको आदेश दिया है।” ");
INSERT INTO hin2010_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“इस्राएल के लोगों से यह कहो: ‘तुम लोग मेरे विशेष विश्राम के दिन वाले नियमों का पालन करोगे। तुम्हें यह अवश्य करना चाहिए, क्योंकि ये मेरे और तुम्हारे बीच सभी पीढ़ियों के लिए प्रतीक स्वरूप रहेंगें। इससे तुम्हें पता चलेगा कि मैंनें अर्थात् यहोवा ने तुम्हें अपना विशेष जनसमूह बनाया है। ");
INSERT INTO hin2010_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“‘सब्त के दिन को विशेष दिवस मनाओ। यदि कोई व्यक्ति सब्त के दिन को अन्य दिनों की तरह मानता है तो वह व्यक्ति अवश्य मार दिया जाना चाहिए। कोई व्यक्ति जो सब्त के दिन काम करता है अपने लोगों से अवश्य अलग कर दिया जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","सप्ताह में दूसरे अन्य छः दिन काम करने के लिए हैं, किन्तु सातवाँ दिन विश्राम करने का विशेष दिन है, अर्थात् यहोवा को सम्मान देने का विशेष दिन है, कोई व्यक्ति जो सब्त के दिन काम करेगा अवश्य ही मार दिया जाये। ");
INSERT INTO hin2010_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","इस्राएल के लोग सब्त के दिन को अवश्य याद रखें और इसे विशेष दिन बनाएं। वे इसे लगातार मनाते रहें। यह मेरे और उनके बीच साक्षीपत्र है जो सदा बना रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","सब्त का दिन मेरे और इस्राएल के लोगों के बीच सदा के लिए प्रतीक रहेगा।’” (यहोवा ने छः दिन काम किया तथा आकाश एवं धरती को बनाया। सातवें दिन उसने अपने को विश्राम दिया।) ");
INSERT INTO hin2010_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","इस प्रकार परमेश्वर ने मूसा से सीनै पर्वत पर बात करना समाप्त किया। तब परमेश्वर ने उसे आदेश लिखे हुए दो समतल पत्थर दिए। परमेश्वर ने अपनी अंगुलियों का उपयोग किया और पत्थर पर उन नियमों को लिखा। ");
INSERT INTO hin2010_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","लोगों ने देखा कि लम्बा समय निकल गया और मूसा पर्वत से नीचे नहीं उतरा। इसलिए लोग हारून के चारों ओर इकट्ठा हुए। उन्होंने उससे कहा, “देखो, मूसा ने हमें मिस्र देश से बाहर निकाला। किन्तु हम यह नहीं जानते कि उसके साथ क्या घटित हुआ है। इसलिए कोई देवता हमारे आगे चलने और हमें आगे ले चलने वाला बनाओ।” ");
INSERT INTO hin2010_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","हारून ने लोगों से कहा, “अपनी पत्नियों, पुत्रों और पुत्रियों के कानों की बालियाँ मेरे पास लाओ।” ");
INSERT INTO hin2010_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","इसलिए सभी लोगों ने कान की बालियाँ इकट्ठी कीं और वे उन्हें हारून के पास लाए। ");
INSERT INTO hin2010_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","हारून ने लोगों से सोना लिया, और एक बछड़े की मूर्ति बनाने के लिए उसका उपयोग किया। हारून ने मूर्ति बनाने के लिए मूर्ति को आकार देने वाले एक औज़ार का उपयोग किया। तब इसे उसने सोने से मढ़ दिया। तब लोगों ने कहा, “इस्राएल के लोगों, ये तुम्हारे वे देवता हैं जो तुम्हें मिस्र से बाहार ले आया।” ");
INSERT INTO hin2010_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","हारून ने इन चीज़ों को देखा। इसलिए उसने बछड़े के सम्मुख एक वेदी बनाई। तब हारून ने घोषणा की। उसने कहा, “कल यहोवा के लिए विशेष दावत होगी।” ");
INSERT INTO hin2010_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","अगले दिन सुबह लोग शीघ्र उठ गए। उन्होंने जानवरों को मारा और होमबलि तथा मेलबलि चढ़ाई। लोग खाने और पीने के लिये बैठे। तब वे खड़े हुए और उनकी एक उन्मत्त दावत हुई। ");
INSERT INTO hin2010_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","उसी समय यहोवा ने मूसा से कहा, “इस पर्वत से नीचे उतरो। तुम्हारे लोग अर्थात् उन लोगों ने, जिन्हें तुम मिस्र से लाए हो, भयंकर पाप किया है। ");
INSERT INTO hin2010_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","उन्होंने उन चीज़ों को करने से शीघ्रता से इन्कार कर दिया है जिन्हें करने का आदेश मैंने उन्हें दिया था। उन्होंने पिघले सोने से अपने लिए एक बछड़ा बनाया है। वे उस बछड़े की पूजा कर रहे हैं और उसे बलि भेंट कर रहे हैं। लोगों ने कहा है, ‘इस्राएल, ये देवता है जो तुम्हें मिस्र से बाहर लाए हैं।’” ");
INSERT INTO hin2010_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","यहोवा ने मूसा से कहा, “मैंने इन लोगों को देखा है। मैं जानता हूँ कि ये बड़े हठी लोग हैं जो सदा मेरे विरुद्ध जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","इसलिए अब मुझे इन्हें क्रोध करके नष्ट करने दो। तब मैं तुझसे एक महान राष्ट्र बनाऊँगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","किन्तु मूसा ने अपने परमेश्वर यहोवा से प्रार्थना की। मूसा ने कहा, “हे यहोवा, तू अपने क्रोध को अपने लोगों को नष्ट न करने दे। तू अपार शक्ति और अपने बल से इन्हें मिस्र से बाहर ले आया। ");
INSERT INTO hin2010_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","किन्तु यदि तू अपने लोगों को नष्ट करेगा तब मिस्र के लोग कह सकते हैं, ‘यहोवा ने अपने लोगों के साथ बुरा करने की योजना बनाई। यही कारण है कि उसने इनको मिस्र से बाहर निकाला। वह उन्हें पर्वतों में मार डालना चाहता था। वह अपने लोगों को धरती से मिटाना चाहता था।’ इसलिए तू लोगों पर क्रुद्ध न हो। अपना क्रोध त्याग दे। अपने लोगों को नष्ट न कर। ");
INSERT INTO hin2010_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","तू अपने सेवक इब्राहीम, इसहाक और इस्राएत (याकूब) को याद कर। तूने अपने नाम का उपयोग किया और तूने उन लोगों को वचन दिया। तूने कहा, ‘मैं तुम्हारे लोगों कों उतना अनगिनत बनाऊँगा जितने आकाश में तारे हैं। मैं तुम्हारे लोगों को वह सारी धरती दूँगा जिसे मैंने उनको देने का वचन दिया है। यह धरती सदा के लिए उनकी होगी।’” ");
INSERT INTO hin2010_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","इसलिए यहोवा ने लोगों के लिए अफ़सोस किया। यहोवा ने वह नहीं किया जो उसने कहा कि वह करेगा अर्थात् लोगों को नष्ट नहीं किया। ");
INSERT INTO hin2010_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","तब मूसा पर्वत से नीचे उतरा। मूसा के पास आदेश वाले दो समतल पत्थर थे। ये आदेश पत्थर के सामने तथा पीछे दोनों तरफ लिखे हुए थे। ");
INSERT INTO hin2010_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","परमेश्वर ने स्वयं उन पत्थरों को बनाया था और परमेश्वर ने स्वयं उन आदेशों को उन पत्थरों पर लिखा था। ");
INSERT INTO hin2010_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","जब वे पर्वत से उतर रहे थे यहोशू ने लोगों का उन्मत्त शोर सुना। यहोशू ने मूसा से कहा, “नीचे पड़ाव में युद्ध की तरह का शोर हैं!” ");
INSERT INTO hin2010_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","मूसा ने उत्तर दिया, “यह सेना का विजय के लिये शोर नहीं है। यह हार से चिल्लाने वाली सेना का शोर भी नहीं है। मैं जो आवाज़ सुन रहा हूँ वह संगीत की है।” ");
INSERT INTO hin2010_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","जब मूसा डेरे के समीप आया तो उसने सोने के बछड़े और गाते हुए लोगों को देखा। मूसा बहुत क्रोधित हो गया और उसने उन विशेष पत्थरों को ज़मीन पर फेंक दिया। पर्वत की तलहटी में पत्थरों के कई टुकडें हो गए। ");
INSERT INTO hin2010_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","तब मूसा ने लोगों के बनाए बछड़े को नष्ट कर दिया। उसने इसे आग में गला दिया। उसने सोने को तब तक पीसा जब तक यह चूर्ण न हो गया और उसने उस चूर्ण को पानी में फेंक दिया। उसने इस्राएल के लोगों को वह पानी पीने को विवश किया। ");
INSERT INTO hin2010_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","मूसा ने हारून से कहा, “इन लोगों ने तुम्हारे साथ क्या किया? तुम उन्हें ऐसा बुरा पाप करने की ओर क्यों ले गए?” ");
INSERT INTO hin2010_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","हारून ने उत्तर दिया, “महाशय, क्रोधित मत हो। आप जानते हैं कि ये लोग सदा गलत काम करने को तैयार रहते हैं। ");
INSERT INTO hin2010_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","लोगों ने मुझ से कहा, ‘मूसा हम लोगों को मिस्र से बाहर लाया। किन्तु हम लोग नहीं जानते कि उसके साथ क्या घटित हुआ।’ इसलिए हम लोगों का मार्ग दिखाने वाला कोई देवता बनाओ, ");
INSERT INTO hin2010_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","इसलिए मैंने लोगों से कहा, ‘यदि तुम्हारे पास सोने की अंगूठियाँ हों तो उन्हें मुझे दे दो।’ लोगों ने मुझे अपना सोना दिया। मैंने इस सोने को आग में फेंका और उस आग से यह बछड़ा आया।” ");
INSERT INTO hin2010_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","मूसा ने देखा कि हारून ने विद्रोह उत्पन्न किया है। लोग मूर्खो की तरह उग्र व्यवहार इस तरह कर रहे थे कि उनके सभी शत्रु देख सकें। ");
INSERT INTO hin2010_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","इसलिए मूसा डेरे के द्वार पर खड़ा हुआ। मूसा ने कहा, “कोई व्यक्ति जो यहोवा का अनुसरण करना चाहता है मेरे पास आए” तब लेवी के परिवार के सभी लोग दौड़कर मूसा के पास आए। ");
INSERT INTO hin2010_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","तब मूसा ने उनसे कहा, “मैं तुम्हें बताऊँगा कि इस्राएल का परमेश्वर यहोवा क्या कहता है ‘हर व्यक्ति अपनी तलवार अवश्य उठा ले और डेरे के एक सिरे से दूसरे सिरे तक जाये। तुम लोग इन लोगों को अवश्य दण्ड दोगे चाहे किसी व्यक्ति को अपने भाई, मित्र और पड़ोसी को ही क्यों न मारना पड़े।’” ");
INSERT INTO hin2010_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","लेवी के परिवार के लोगों ने मूसा का आदेश माना। उस दिन इस्राएल के लगभग तीन हज़ार लोग मरे। ");
INSERT INTO hin2010_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","तब मूसा ने कहा, “यहोवा ने आज तुम को ऐसे लोगों के रूप में चुना है जो अपने पुत्रों और भाईयों को आशीर्वाद देंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","अगली सुबह मूसा ने लोगों से कहा, “तुम लोगों ने भयंकर पाप किया है। किन्तु अब मैं यहोवा के पास ऊपर जाऊँगा और ऐसा कुछ कर सकूँगा जिससे वह तुम्हारे पापों को क्षमा कर दें।” ");
INSERT INTO hin2010_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","इसलिए मूसा वापस यहोवा के पास गया और उसने कहा, “कृपया सुन! इन लोगों ने बहुत बुरा पाप किया है और सोने का एक देवता बनाया है। ");
INSERT INTO hin2010_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","अब उन्हें इस पाप के लिये क्षमा कर। यदि तू क्षमा नहीं करेगा तो मेरा नाम उस किताब से मिटा दें जिसे तूने लिखा है।” ");
INSERT INTO hin2010_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","किन्तु यहोवा ने मूसा से कहा, “जो मेरे विरुद्ध पाप करते हैं केवल वे ही ऐसे लोग हैं जिनका नाम मैं अपनी पुस्तक से मिटाता हूँ। ");
INSERT INTO hin2010_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","इसलिए जाओ और लोगों को वहाँ ले जाओ जहाँ मैं कहता हूँ। मेरा दूत तुम्हारे आगे आगे चलेगा और तुम्हें रास्ता दिखाएगा। जब उन लोगों को दण्ड देने का समय आएगा जिन्होंने पाप किया है तब उन्हें दण्ड दिया जायेगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","इसलिए यहोवा ने लोगों में एक भयंकर बीमारी उत्पन्न की। उन्होंने यह इसलिए किया कि उन लोगों ने हारून से सोने का बछड़ा बनाने को कहा था। ");
INSERT INTO hin2010_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","तब यहोवा ने मूसा से कहा, “तुम और तुम्हारे वे लोग जिन्हें तुम मिस्र से लाए हो उस जगह को अवश्य छोड़ दो। और उस प्रदेश में जाओ जिसे मैंने इब्राहीम, इसहाक और याकूब को देने का वचन दिया था। मैंने उन्हें वचन दिया मैंने कहा, ‘मैं वह प्रदेश तुम्हारे भावी वंशजों को दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","मैं एक दूत तुम्हारे आगे आगे चलने के लिये भेजूँगा, और मैं कनानी, एमोरी, हित्ती, परिज्जी, हिब्बी और यबूसी लोगों को हराऊँगा, मैं उन लोगों को तुम्हारा प्रदेश छोड़ने को विवश करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","इसलिए उस प्रदेश को जाओ जो बहुत ही अच्छी चीज़ों से भरा है। किन्तु मैं तुम्हारे साथ नहीं जाऊँगा, तुम लोग बड़े हठी हो, यदि मैं तुम्हारे साथ गया तो मैं तुम्हें शायद रास्ते में ही नष्ट कर दूँ।’” ");
INSERT INTO hin2010_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","लोगों ने यह बुरी खबर सुनी और वे वहुत दुःखी हुए। इसके बाद लोगों ने आभूषण नही पहने। ");
INSERT INTO hin2010_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","उन्होंने आभूषण नहीं पहने क्योंकि यहोवा ने मूसा से कहा, “इस्राएल के लोगों से कहो, ‘तुम हठी लोग हो। यदि मैं तुम लोगों के साथ थोड़े समय के लिए भी यात्रा करुँ तो मैं तुम लोगों को नष्ट कर दूँगा, इसलिए अपने सभी गहने उतार लो। तब मैं निश्चय करूँगा कि तुम्हारे साथ क्या करूँ।’” ");
INSERT INTO hin2010_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","इसलिए इस्राएल के लोगों ने होरेब (सीनै) पर्वत पर अपने सभी गहने उतार लिए। ");
INSERT INTO hin2010_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","मूसा मिलापवाला तम्बू को डेरे से कुछ दूर ले गया। वहाँ उसने उसे लगाया और उसका नाम “मिलापवाला तम्बू” रखा। कोई व्यक्ति जो यहोवा से कुछ जानना चाहता था उसे डेरे के बाहर मिलापवाले तम्बू तक जाना होता था। ");
INSERT INTO hin2010_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","जब कभी मूसा बाहर तम्बू में जाता तो लोग उसको देखते रहते। लोग अपने तम्बूओं के द्वार पर खड़े रहते और मूसा को तब तक देखते रहते जब तक वह मिलापवाले तम्बू में चला जाता। ");
INSERT INTO hin2010_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","जब मूसा तम्बू में जाता तो एक लम्बा बादल का स्तम्भ सदा नीचे उतरता था। वह बादल तम्बू के द्वार पर ठहरता। इस प्रकार यहोवा मूसा से बात करता था। ");
INSERT INTO hin2010_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","जब लोग तम्बू के द्वार पर बादल को देखते तो सामने झुकते और उपासना करते थे। हर एक व्यक्ति अपने तम्बू के द्वार पर उपासना करता था। ");
INSERT INTO hin2010_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","यहोवा मूसा से आमने—सामने बात करता था। यहोवा मूसा से इस प्रकार बात करता था जिस प्रकार कोई व्यक्ति अपने मित्र से बात करता है। यहोवा से बात करने के बाद मूसा हमेशा अपने डेरे मे वापस लौटता था। नून का पुत्र नवयुवक यहोशू मूसा का सहायक था। यहोशू सदा तम्बू में रहता था जब मूसा उसे छोड़ता था। ");
INSERT INTO hin2010_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मूसा ने यहोवा से कहा, “तूने मुझे इन लोगों को ले चलने को कहा। किन्तु तूने यह नहीं बताया कि मेरे साथ किसे भेजेगा। तूने मुझसे कहा, ‘मैं तुम्हें अच्छी तरह जानता हूँ और मैं तुमसे प्रसन्न हूँ।’ ");
INSERT INTO hin2010_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","यदि तुझे मैंने सचमुच प्रसन्न किया है तो अपने निर्णय मुझे बता। तुझे मैं सचमुच जानना चाहता हूँ। तब मैं तुझे लगातार प्रसन्न रख सकता हूँ। याद रख कि ये सभी तेरे लोग हैं।” ");
INSERT INTO hin2010_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","यहोवा ने कहा, “मैं स्वयं तुम्हारे साथ चलूँगा। मैं तुम्हें रास्ता दिखाऊँगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","तब मूसा ने उससे कहा, “यदि तू हम लोगों के साथ न चले तो तू इस स्थान से हम लोगों को दूर मत भेज। ");
INSERT INTO hin2010_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","हम यह भी कैसे जानेंगे कि तू मुझसे और इन लोगों से प्रसन्न है? यदि तू साथ चलेगा तो हम लोग निश्चयपूर्वक यह जानेंगे। यदि तू हम लोगों के साथ नहीं जाता तो मैं और ये लोग धरती के अन्य दूसरे लोगों से भिन्न नहीं होंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","तब यहोवा ने मूसा से कहा, “मैं वह करूँगा जो तू कहता है। मैं यह करूँगा क्योंकि मैं तुझसे प्रसन्न हूँ। मैं तुझे अच्छी तरह जानता हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","तब मूसा ने कहा, “अब कृपया मुझे अपनी महिमा दिखा।” ");
INSERT INTO hin2010_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","तब यहोवा ने उत्तर दिया, “मैं अपनी सम्पूर्ण भलाई को तुम तक जाने दूँगा। मैं यहोवा हूँ और मैं अपने नाम की घोषणा करूँगा जिससे तुम उसे सुन सको। मैं उन लोगों पर कृपा और प्रेम दिखाऊँगा जिन्हें मैं चूनूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","किन्तु तुम मेरा मुख नहीं देख सकते। कोई भी व्यक्ति मुझे देख नहीं सकता और यदि देख ले तो जीवित नहीं रह सकता है। ");
INSERT INTO hin2010_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","“मेरे समीप के स्थान पर एक चट्टान है। तुम उस चट्टान पर खड़े हो सकते हो। ");
INSERT INTO hin2010_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","मेरी महिमा उस स्थान से होकर गुज़रेगी। उस चट्टान की बड़ी दरार में मैं तुम को रखूँगा और गुजरते समय मैं तुम्हें अपने हाथ से ढकूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","तब मैं अपना हाथ हटा लूँगा और तुम मेरी पीठ मात्र देखोगे। किन्तु तुम मेरा मुख नहीं देख पाओगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","तब यहोवा ने मूसा से कहा, “दो और समतल चट्टानें ठीक वैसी ही बनाओ जैसी पहली दो थीं जो टूट गई। मैं इन पर उन्हीं शब्दों को लिखूँगा जो पहले दोनों पर लिखे थे। ");
INSERT INTO hin2010_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","कल प्रातःकाल तैयार रहना और सीनै पर्वत पर आना। वहाँ मेरे सामने पर्वत की चोटी पर खड़े रहना। ");
INSERT INTO hin2010_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","किसी व्यक्ति को तुम्हारे साथ नहीं आने दिया जाएगा। पर्वत के किसी भी स्थान पर कोई भी व्यक्ति दिखाई तक नहीं पड़ना चाहिए। यहाँ तक कि तुम्हारे जानवरों के झुण्ड और भेड़ों की रेवडें भी पर्वत की तलहटी में घास नहीं चर सकेंगी।” ");
INSERT INTO hin2010_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","इसलिए मूसा ने पहले पत्थरों की तरह पत्थर की दो समतल पटिट्याँ बनाई। तब अगले सवेरे ही वह सीनै पर्वत पर गया। उसने हर एक चीज़ यहोवा के आदेश के अनुसार की। मूसा अपने साथ पत्थर की दोनों समतल पट्टियाँ ले गया। ");
INSERT INTO hin2010_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","मूसा के पर्वत पर पहुँच जाने के बाद यहोवा उसके पास बादल में नीचे पर्वत पर आया। यहोवा वहाँ मूसा के साथ खड़ा रहा, और उसने यहोवा का नाम लिया। ");
INSERT INTO hin2010_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","यहोवा मूसा के सामने से गुज़रा था और उसने कहा, “यहोवा दयालु और कृपालु परमेश्वर है। यहोवा जल्दी क्रोधित नहीं होता। यहोवा महान, प्रेम से भरा है। यहोवा विश्वसनीय है। ");
INSERT INTO hin2010_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","यहोवा हज़ारों पीढ़ियों पर कृपा करता है। यहोवा लोगों को उन गलतियों के लिए जो वे करते हैं क्षमा करता है। किन्तु यहोवा अपराधियों को दण्ड देना नहीं भूलता। यहोवा केवल अपराधी को ही दण्ड नहीं देगा अपितु उनके बच्चों, उनके पौत्रों और प्रपौत्रों को भी उस बुरी बात के लिये कष्ट सहना होगा जो वे लोग करते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","तब तत्काल मूसा भूमि पर झुका और उसने यहोवा की उपासना की। मूसा ने कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“यहोवा, यदि तू मुझसे प्रसन्न हैं तो मेरे साथ चल। मैं जानता हूँ कि ये लोग हठी हैं। किन्तु तू हमें उन पापों और अपराधों के लिए क्षमा कर जो हमने किए हैं। अपने लोगों के रूप में हमें स्वीकार कर।” ");
INSERT INTO hin2010_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","तब यहोवा ने कहा, “मैं तुम्हारे सभी लोगों के साथ यह साक्षीपत्र बना रहा हूँ। मैं ऐसे अद्भुत काम करूँगा जैसे इस धरती पर किसी भी दूसरे राष्ट्र के लिए पहले कभी नहीं किए। तुम्हारे साथ सभी लोग देखेंगे कि मैं यहोवा अत्यन्त महान हूँ। लोग उन अद्भुत कामों को देखेंगे जो मैं तुम्हारे लिए करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","आज मैं जो आदेश देता हूँ उसका पालन करो और मैं तुम्हारे शत्रुओं को तुम्हारा देश छोड़ने को विवश करूँगा। मैं एमोरी, कनानी, हित्ती, परिज्जी, हिब्बी और यबूसी को बाहर निकल जाने को विवश करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","सावधान रहो। उन लोगों के साथ कोई सन्धि न करो जो उस प्रदेश में रहते हैं जहाँ तुम जा रहे हो। यदि तुम उनके साथ सन्धि करोगे जो उस प्रदेश में रहते हैं जहाँ तुम जा रहे हो। यदि तुम उनके साथ साक्षीपत्र बनाओगे तो तुम उस में फँस जाओगे। ");
INSERT INTO hin2010_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","उनकी वेदियों को नष्ट कर दो। उन पत्थरों को तोड़ दो जिनकी वे पूजा करते हैं। उनकी मूर्तियों को काट गिराओ। ");
INSERT INTO hin2010_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","किसी दूसरे देवता की पूजा न करो। मैं यहोवा (कना) जलन रखने वाला परमेश्वर हूँ। यह मेरा नाम है। मैं (एलकाना) जल उठने वाला परमेश्वर हूँ। ");
INSERT INTO hin2010_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“सावधान रहो उस प्रदेश में जो लोग रहते हैं उनसे कोई सन्धि न हो। यदि तुम यह करोगे तो जब वे अपने देवताओं की पूजा करेगं तब तुम उनके साथ हो सकोगे। वे लोग तुम्हें अपने में मिलने के लिये आमंत्रित करेंगे और तुम उनकी बलियों को खाओगे। ");
INSERT INTO hin2010_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","तुम उनकी कुछ लड़कियों को अपने पुत्रों की पत्नियों के रूप में चुन सकते हो। वे पुत्रियाँ असत्य देवताओं की सेवा करती हैं। वे तुम्हारे पुत्रों से भी वही करवा सकतीं हैं। ");
INSERT INTO hin2010_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“मूर्तियाँ मत बनाना। ");
INSERT INTO hin2010_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“अखमीरी रोटियों की दावत का उत्सव मनाओ। मेरे दिए आदेश के अनुसार सात दिन तक अखमीरी रोटी खाओ। इसे उस महीने में करो जिसे मैंने चुना हैं—आबीब का महीना। क्यों? क्योंकि यह वही महीना है जब तुम मिस्र से बाहर आए। ");
INSERT INTO hin2010_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“किसी भी स्त्री का पहलौठा बच्चा सदा मेरा है। पहलौठा जानवर भी जो तुम्हारी गाय, बकरियों या भेड़ों से उत्पन्न होता है, मेरा है। ");
INSERT INTO hin2010_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","यदि तुम पहलौठे गधे को रखना चाहते हो तो तुम इसे एक मेमने के बदले खरीद सकते हो। किन्तु यदि तुम उस गधे को मेमने के बदले नहीं ख़रीदते तो तुम उस गधे की गर्दन तोड़ दो। तुम्हें अपने पहलौठे सभी पुत्र मुझसे वापस खरीदने होंगे। कोई व्यक्ति बिना भेंट के मेरे सामने नहीं आएगा। ");
INSERT INTO hin2010_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“तुम छः दिन काम करोगे। किन्तु सातवें दिन अवश्य विश्राम करोगे। पौधे रोपने और फसल काटने के समय भी तुम्हें विश्राम करना होगा। ");
INSERT INTO hin2010_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“सप्ताह की दावत को मनाओ। गेहूँ की फ़सल के पहले अनाज का उपयोग इस दावत में करो और वर्ष के अन्त में फ़सल कटने की दावत मनाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“हर वर्ष तुम्हारे सभी पुरुष तीन बार अपने स्वामी, परमेश्वर इस्राएल के यहोवा के पास जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","“जब तुम अपने प्रदेश में पहुँचोगे तो मैं तुम्हारे शत्रुओं को उस प्रदेश से बाहर जाने को विवश करूँगा। मैं तुम्हारी सीमाओं को बढ़ाऊँगा और तुम अधिकाधिक प्रदेश पाओगे। तुम अपने परमेश्वर यहोवा के सामने वर्ष में तीन बार जाओगे। और उन दिनों तुम्हारा देश तुम से लेने का कोई भी प्रयत्न नहीं करेगा। ");
INSERT INTO hin2010_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“यदि तुम मुझे बलि से खून भेंट करो तो उसी समय मुझे खमीर भेंट मत करो “और फ़सह पर्व का कुछ भी माँस अगली सुबह तक के लिये नहीं छोड़ा जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“यहोवा को अपनी पहली काटी हुई फ़सलें दो। उन चीज़ों को अपने परमेश्वर यहोवा के घर लाओ। “कभी बकरी के बच्चे को उसकी माँ के दूध में न पकाओ।” ");
INSERT INTO hin2010_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","तब यहोवा ने मूसा से कहा, “जो बातें मैंने बताई हैं उन्हें लिख लो। ये बातें हमारे तुम्हारे और इस्राएल के लोगों के मध्य साक्षीपत्र हैं।” ");
INSERT INTO hin2010_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मूसा वहाँ यहोवा के साथ चालीस दिन और चालीस रात रहा। उस पूरे समय उसने न भोजन किया न ही पानी पिया। और मूसा ने साक्षीपत्र के शब्दों के (दस आदेशों) को, पत्थर की दो समतल पट्टियों पर लिखा। ");
INSERT INTO hin2010_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","तब मूसा सीनै पर्वत से नीचे उतरा। वह यहोवा की दोनों पत्थरों की समतल पट्टियों को साथ लाया जिन पर यहोवा के नियम लिखे थे। मूसा का मुख चमक रहा था। क्योंकि उसने परमेश्वर से बातें की थीं। किन्तु मूसा यह नहीं जानता था कि उसके मुख पर तेज हैं। ");
INSERT INTO hin2010_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","हारून और इस्राएल के सभी लोगों ने देखा कि मूसा का मुख चमक रहा था। इसलिए वे उसके पास जाने से डरे। ");
INSERT INTO hin2010_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","किन्तु मूसा ने उन्हें बुलाया। इसलिए हारून और लोगों के सभी अगुवा मूसा के पास गए। मूसा ने उन से बातें कीं। ");
INSERT INTO hin2010_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","उसके बाद इस्राएल के सभी लोग मूसा के पास आए। और मूसा ने उन्हें वे आदेश दिए जो यहोवा ने सीनै पर्वत पर उसे दिए थे। ");
INSERT INTO hin2010_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","जब मूसा ने बातें करना खत्म किया तब उसने अपने मुख को एक कपड़े से ढक लिया। ");
INSERT INTO hin2010_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","जब कभी मूसा यहोवा के सामने बातें करने जाता तो कपड़े को हटा लेता था। तब मूसा बाहर आता और इस्राएल के लोगों को वह बताता जो यहोवा का आदेश होता था। ");
INSERT INTO hin2010_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","इस्राएल के लोग देखते थे कि मूसा का मुख तेज से चमक रहा है। इसलिए मूसा अपना मुख फिर ढक लेता था। मूसा अपने मुख को तब तक ढके रखता था जब तक वह यहोवा के साथ बात करने अगली बार नहीं जाता था। ");
INSERT INTO hin2010_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मूसा ने इस्राएल के सभी लोगों को एक साथ इकट्ठा किया। मूसा ने उनसे कहा, “मैं वे बातें बताऊँगा जो यहोवा ने तुम लोगों को करने के लिए कही हैं: ");
INSERT INTO hin2010_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","“काम करने के छ: दिन हैं। किन्तु सापवाँ दिन तुम लोगों का विश्राम का विशेष दिन होगा। उस विशेष दिन को विश्राम करके तुम लोग यहोवा को श्रद्धा अर्पित करोगे। यदि कोई सातवें दिन काम करेगा तो उसे अवश्य मार दिया जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","सब्त के दिन तुम्हें किसी स्थान पर आग तक नहीं जलानी चाहिए, जहाँ कहीं तुम रहते हो।” ");
INSERT INTO hin2010_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","मूसा ने इस्राएल के सभी लोगों से कहा, “यही है जो यहोवा ने आदेश दिया है। ");
INSERT INTO hin2010_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","यहोवा के लिए विशेष भेंट इकट्ठी करो। तुम्हें अपने मन में निश्चय करना चाहिए कि तुम क्या भेंट करोगे। और तब तुम वह भेंट यहोवा के पास लाओ। सोना, चाँदी ओर काँसा; ");
INSERT INTO hin2010_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","नीला बैंगनी और लाल कपड़ा, सन का उत्तम रेशा; बकरी के बाल; ");
INSERT INTO hin2010_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","भेंड़ की लाल रंगी खाल, सुइसों का चमड़ा; बबूल की लकड़ी; ");
INSERT INTO hin2010_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","दीपकों के लिए जैतून का तेल; अभिषेक के तेल के लिए मसाले, सुगन्धित धूप के लिए मसाले, ");
INSERT INTO hin2010_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","गोमेदक नग तथा अन्य रत्न भेंट में लाओ। ये नग और रत्न एपोद और सीनाबन्द पर लगाए जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“तुम सभी कुशल कारीगरों को चाहिए कि यहोवा ने जिन चीज़ों का आदेश दिया है उन्हें बनाए। ये वे चीज़ें हैं जिनके लिए यहोवा ने आदेश दिया हैं: ");
INSERT INTO hin2010_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","पवित्र तम्बू, इसका बाहरी तम्बू, और इसका आच्छादन, छल्ले, तख्ते, पट्टियाँ, स्तम्भ और आधार; ");
INSERT INTO hin2010_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","पवित्र सन्दूक, और इसकी बल्लियाँ तथा सन्दूक का ढक्कन, और सन्दूक रखे जाने की जगह को ढकने के लिए पर्दे; ");
INSERT INTO hin2010_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","मेज और इसकी बल्लियाँ, मेज पर रहने वाली सभी चीज़ें, और मेज पर रखी जाने वाली विशेष रोटी; ");
INSERT INTO hin2010_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","प्रकाश के लिये उपयोग में आने वाला दीपाधार, और वे सभी चीज़ें जो दीपाधार के साथ होती हैं अर्थात् दीपक, और प्रकाश के लिए तेल; ");
INSERT INTO hin2010_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","धूप जलाने के लिए वेदी और इसकी बल्लियाँ अभिषेक का तेल और सुगन्धित धूप, मिलापवाले तम्बू के प्रवेश द्वार को ढकने वाली कनात; ");
INSERT INTO hin2010_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","होमबलियों के लिए वेदी और इसकी काँसे की जाली, बल्लियाँ और वेदी पर उपयोग में आने वाली सभी चीज़ें, काँसे की चिलमची और इसका आधार; ");
INSERT INTO hin2010_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","आँगन की चारों ओर की कनातें, और उनके खंभे और आधार, और आँगन के प्रवेशद्वार को ढकने वाला कनात; ");
INSERT INTO hin2010_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","आँगन और तम्बू के सहारे के लिए उपयोग में आने वाली खूँटियाँ, और खूँटियों से बँधने वाली रस्सियाँ; ");
INSERT INTO hin2010_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","और विशेष बुने वस्त्र जिन्हें याजक पवित्र स्थानों में पहनेंगे। ये विशेष वस्त्र याजक हारून और उसके पुत्रों के पहनने के लिए हैं वे इन वस्त्रों को तब पहनेंगे जब वे याजक के रूप में सेवा—कार्य करेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","तब इस्राएल के सभी लोग मूसा के पास से चले गए। ");
INSERT INTO hin2010_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","सभी लोग जो भेंट चढ़ाना चाहते थे आए और यहोवा के लिए भेंट लाए। ये भेंटे मिलापवाले तम्बू को बनाने, तम्बू की सभी चीज़ों, और विशेष वस्त्र बनाने के काम में लाई गई। ");
INSERT INTO hin2010_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","सभी स्त्री और पुरुष, जो चढ़ाना चाहते थे, हर प्रकार के अपने सोने के गहने लाए। वे चिमटी कान की बालियाँ, अगूंठियाँ, अन्य गहने लेकर आए। उन्होंने अपने सभी सोने के गहने यहोवा को अर्पित किए। यह यहोवा को विशेष भेंट थी। ");
INSERT INTO hin2010_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","हर व्यक्ति जिसके पास सन के उत्तम रेशे, नीला, बैंगनी और लाल कपड़ा था वह इन्हें यहोवा के पास लाया। वह व्यक्ति जिसके पास बकरी के बाल, लाल रंग से रंगी भेड़ की खाल, सुइसों का खाल था उसे वह यहोवा के पास लाया। ");
INSERT INTO hin2010_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","हर एक व्यक्ति जो चाँदी, काँसा, चढ़ाना चाहता था यहोवा को भेंट के रूप में उसे लाया। हर एक व्यक्ति जिसके पास बबूल की लकड़ी थी, आया और उसे यहोवा को अर्पित किया। ");
INSERT INTO hin2010_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","हर एक कुशल स्त्री ने सन के उत्तम रेशों और नीला, बैंगनी तथा लाल कपड़ा बनाया। ");
INSERT INTO hin2010_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","उन सभी स्त्रियों ने जो कुशल थीं और हाथ बँटाना चाहती थीं उन्होंने बकरी के बालों से कपड़ा बनाया। ");
INSERT INTO hin2010_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","अगुवा लोग गोमेदक नग तथा अन्य रत्न ले आए। ये नग और रत्न याजक के एपोद तथा सीनाबन्द में लगाए गए। ");
INSERT INTO hin2010_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","लोग मसाले और जैतून का तेल भी लाए। ये चीज़ें सुगन्धित धूप, अभिषेक का तेल और दीपकों के तेल के लिए उपयोग में आई। ");
INSERT INTO hin2010_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","इस्राएल के वे सभी लोग जिनके मन में प्रेरणा हुई यहोवा के लिए भेंट लाए। ये भेटें मुक्त भाव से दी गई थीं, लोगों ने इन्हें दिया क्योंकि वे देना चाहते थे। ये भेंट उन सभी चीज़ों के बनाने के लिए उपयोग में आई जिन्हें यहोवा ने मूसा और लोगों को बनाने का आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","तब मूसा ने इस्राएल के लोगों से कहा, “देखों! यहोवा ने बसलेल को चुना है जो ऊरी का पुत्र और यहूदा के परिवार समूह का है। (ऊरी हूर का पुत्र था।) ");
INSERT INTO hin2010_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","यहोवा ने बसलेल को परमेश्वर की शक्ति से भर दिया अर्थात् बसलेल को हर प्रकार का काम करने की विशेष निपुणता और जानकारी दी। ");
INSERT INTO hin2010_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","वह सोने, चाँदी और काँसे की चीज़ों का आलेखन करके उन्हें बना सकता है। ");
INSERT INTO hin2010_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","वह नग और रत्न को काट और जड़ सकता है। बसलेल लकड़ी का काम कर सकता है और सभी प्रकार की चीज़े बना सकता है। ");
INSERT INTO hin2010_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","यहोवा ने बसलेल और ओहोलीआब को अन्य लोगों के सिखाने की विशेष निपुणता दे रखी है। (ओहोलीआब दान के परिवार समूह से अहीसामाक का पुत्र था।) ");
INSERT INTO hin2010_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","यहोवा ने इन दोनों व्यक्तियों को सभी प्रकार का काम करने की विशेष निपुणता दे रखी है। वे बढ़ई और ठठेरे का काम करने की निपुणता रखते हैं, वे नीले, बैंगनी, और लाल कपड़े और सन के उत्तम रेशों मे चित्रों को काढ़ कर उन्हें सी सकते हैं और वे ऊन से भी चीजों को बुन सकते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“इसलिए, बसलेल, ओहोलीआब और सभी निपुण व्यक्ति उन कामों को करेंगे जिनका आदेश यहोवा ने दिया है। यहोवा ने इन व्यक्तियों को उन सभी निपुण काम करने की बुद्धि और समझ दे रखी है जिनकी आवश्यकता इस पवित्र स्थान को बनाने के लिए है।” ");
INSERT INTO hin2010_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","तब मूसा ने बसलेल, ओहोलीआब और सभी अन्य निपुण लोगों को बुलाया जिन्हें यहोवा ने विशेष निपुणता दी थी और ये लोग आए क्योंकि ये काम में सहायता करना चाहते थे। ");
INSERT INTO hin2010_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","मूसा ने इस्राएल के इन लोगों को उन सभी चीज़ों को दे दिया जिन्हें इस्राएल के लोग भेंट के रूप में लाए थे। और उन्होंने उन चीज़ों का उपयोग पवित्र स्थान बनाने में किया। लोग प्रत्येक सुबह भेंट लाते रहे। ");
INSERT INTO hin2010_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","अन्त में प्रत्येक निपुण कारीगरों ने उस काम को छोड़ दिया जिसे वे पवित्र स्थान पर कर रहे थे और वे मूसा से बातें करने गए। ");
INSERT INTO hin2010_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","उन्होंने कहा, “लोग बहुत कुछ लाए हैं। हम लोगों के पास उससे अधिक है जितना तम्बू को पूरा करने के लिए यहोवा ने कहा है।” ");
INSERT INTO hin2010_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","तब मूसा ने पूरे डेरे में यह खबर भेजी: “कोई पुरुष या स्त्री अब कोई अन्य भेंट तम्बू के लिए नहीं चढ़ाएगा।” इस प्रकार लोग और अधिक न देने के लिए विवश किए गए। ");
INSERT INTO hin2010_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","लोगों ने पर्याप्त से अधिक चीज़ें पवित्र स्थान को बनाने के लिए दीं। ");
INSERT INTO hin2010_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","तब निपुण कारीगरों ने पवित्र तम्बू बनाना आरम्भ किया। उन्होंने नीले, बैंगनी और लाल कपड़े और सन के उत्तम रेशों की दस कनातें बनाई। और उन्होंने करूब के पंख सहित चित्रों को कपड़े पर काढ़ दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","हर एक कनात बराबर नात की थी। यह चौदह गज़ लम्बी तथा, दो गज़ चौड़ी थी। ");
INSERT INTO hin2010_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","पाँच कनातें एक साथ आपस में जोड़ी गई जिससे वे एक ही बन गई। दूसरी को बनाने के लिए अन्य पाँच कनातें आपस में जोड़ी गई। ");
INSERT INTO hin2010_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","पाँच से बनी पहली कनात को अन्तिम कनात के सिरे के साथ लुप्पी बनाने के लिए उन्होंने नीले कपड़े का उपयोग किया। उन्होंने वही काम दूसरी पाँच से कबनी अन्य कनातों के साथ भी किया। ");
INSERT INTO hin2010_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","एक में पचास छेद थे और दूसरी में भी पचास छेद थे। छेद एक दूसरे के आमने—सामने थे। ");
INSERT INTO hin2010_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","तब उन्होंने पचास सोने के छल्ले बनाए। उन्होंने इन छल्लों का उपयोग दोनों कनातों को जोड़ने के लिए किया। इस प्रकार पूरा तम्बू एक ही कपड़े में जुड़कर एक हो गया। ");
INSERT INTO hin2010_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","तब कारीगरों ने बकरी के बालों का उपयोग तम्बू को ढकने वाली ग्यारह कनातों को बनाने के लिए किया। ");
INSERT INTO hin2010_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","सभी ग्यारह कनातें एक ही माप की थी। वे पन्द्रह गज लम्बी और दो गज चौड़ी थीं। ");
INSERT INTO hin2010_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","कारीगरों ने पाँच कनातों को एक में सीआ, और तब छ: को एक दूसरे में एक साथ सीआ। ");
INSERT INTO hin2010_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","उन्होंने पहले समूह की अन्तिम कनात के सिरे में पचास लुप्पियाँ बनाई। और दूसरे समूह की अन्तिम कनात के सिरे में पचास। ");
INSERT INTO hin2010_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","कारीगरों ने दोनों को एक में मीलाने के लिए पचास काँसे के छल्ले बनाए। ");
INSERT INTO hin2010_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","तब उन्होंने तम्बू के दो और आच्छादन बनाए। एक आच्छादन लाल रंगे हुए मेढ़े की खाल से बनाया गया। दूसरा आच्छादन सुइसों के चमड़ें का बनाया गया। ");
INSERT INTO hin2010_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","तब बसलेल ने बबूल की लकड़ी के तख़्ते बनाए। ");
INSERT INTO hin2010_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","हर एक तख्ता पन्द्रह फीट लम्बा और सत्ताइस इंच चौड़ा बनाया। ");
INSERT INTO hin2010_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","हर एक तख्ते के तल में अगल—बगल दो चूले थी। इनका उपयोग तख्तों को जोड़ने के लिए किया जाता था। पवित्र तम्बू के लिए हर एक तख़्ता इसी प्रकार का था। ");
INSERT INTO hin2010_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","बसलेल ने तम्बू के दक्षिण भाग के लिए बीस तख्ते बनाए। ");
INSERT INTO hin2010_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","तब उसने चालीस चाँदी के आधार बनाए जो बीस तख़्तों के नीचे लगे। हर एक तख़्ते के दो आधार थे अर्थात् हर तख़्ते की हर “चूल” के लिए एक। ");
INSERT INTO hin2010_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","उसने बीस तख़्ते तम्बू की दूसरी ओर (उत्तर) की तरफ़ के भी बनाए। ");
INSERT INTO hin2010_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","उसने हर एक तख़्ते के नीचे दो लगने वाले चाँदी के चालीस आधार बनाए। ");
INSERT INTO hin2010_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","उसने तम्बू के पिछले भाग (पश्चिमी ओर) के लिए छः तख़्ते बनाए। ");
INSERT INTO hin2010_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","उसने तम्बू के पिछले भाग के कोनों के लिये दो तख़्ते बनाए। ");
INSERT INTO hin2010_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ये तख़्ते तले में एक दूसरे से जोड़े गए थे, और ऐसे छल्लों में लगे थे जो उन्हें जोड़ते थे। उसने प्रत्येक सिरे के लिये ऐसा किया। ");
INSERT INTO hin2010_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","इस प्रकार वहाँ आठ तख़्ते थे, और हर एक तख़्ते के लिए दो आधार के हिसाब से सोलह चाँदी के आधार थे। ");
INSERT INTO hin2010_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","तब उसने तम्बू के पहली बाजू के लिये पाँच, ");
INSERT INTO hin2010_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","और तम्बू की दूसरी बाजू के लिये पाँच तथा तम्बू के पिछली (पश्चिमी) ओर के लिये पाँच कीकर की कड़ियाँ बनाई। ");
INSERT INTO hin2010_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","उसमें बीच की कड़ियाँ ऐसी बनाई जो तख्तों में से एक दूसरे से होकर एक दूसरे तक जाती थीं। ");
INSERT INTO hin2010_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","उसने इन तख़्तों को सोने से मढ़ा। उसने कड़ीयों को भी सोने से मढ़ा और उसने कड़ीयों को पकड़े रखने के लिये सोने के छल्ले बनाए। ");
INSERT INTO hin2010_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","तब उसने सर्वाधिक पवित्र स्थान के द्वार के लिये पर्दे बनाए। उसने सन के उत्तम रेशों और नीले लाल तथा बैगनी कपड़े का उपयोग किया। उसने सन के उत्तम रेशों में करूबों का चित्र काढ़ा। ");
INSERT INTO hin2010_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","उसने बबूल की लकड़ी के चार खम्भे बनाए और उन्हें सोने से मढ़ा। तब उसने खम्भों के लिये सोने के छल्ले बनाए और उसने खम्भों के लिये चार चाँदी के आधार बनाए। ");
INSERT INTO hin2010_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","तब उसने तम्बू के द्वार के लिये पर्दा बनाया। उसने नीले, बैंगनी और लाल कपड़े तथा सन के उत्तम रेशों का उपयोग किया। उसने कपड़े में चित्र काढ़े। ");
INSERT INTO hin2010_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","तब उसने इस पर्दे के लिये पाँच खम्भे और उनके लिये छल्ले बनाए। उसने खम्भों के सिरों और पर्दे की छड़ों को सोने से मढ़ा, और उसने काँसे के पाँच आधार खम्भों के लिए बनाए। ");
INSERT INTO hin2010_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","बसलेल ने बबूल की लकड़ी का पवित्र सन्दूक बनाया। सन्दूक पैतालिस इंच लम्बा, सत्ताईस इंच चौड़ा और सत्ताईस इंच ऊँचा था। ");
INSERT INTO hin2010_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","उसने सन्दूक के भीतरी और बाहर भाग को शुद्ध सोने से मढ़ दिया। तब उसने सोने की पट्टी सन्दूक के चारों ओर लगाई। ");
INSERT INTO hin2010_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","फिर उसने सोने के चार कड़े बनाए और उन्हें नीचे के चारों कोनों पर लगाया। ये कड़े सन्दूक को ले जाने के लिए उपयोग में आते थे। दोनों तरफ दो—दो कड़े थे। ");
INSERT INTO hin2010_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","तब उसने सन्दूक ले चलने के लिये बल्लियों को बनाया। बल्लियों के लिये उसने बबूल की लकड़ी का उपयोग किया और बल्लियों को शुद्ध सोने से मढ़ा। ");
INSERT INTO hin2010_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","उसने सन्दूक के हर एक सिरे पर बने कड़ों में बल्लियों को डाला। ");
INSERT INTO hin2010_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","तब उसने शुद्ध सोने से ढक्कन को बनाया। ये ढाई हाथ लम्बा तथा डेढ़ हाथ चौड़ा था। ");
INSERT INTO hin2010_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","तब बसलेल ने सोने को पीट कर दो करूब बनाए। उसने ढक्कन के दोनों छोरो पर करूब लगाये। ");
INSERT INTO hin2010_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","उसने एक करूब को एक ओर तथा दूसरे को दूसरी ओर लगाया। करूब को ढक्कन से एक बनाने के लिये जोड़ दिया गया। ");
INSERT INTO hin2010_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","करूबों के पंख आकाश की ओर उठा दिए गए। करूबों ने सन्दूक को अपने पंखों से ढक लिया। करूबों एक दूसरे के सामने ढक्कन को देख रहे थे। ");
INSERT INTO hin2010_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","तब बसलेल ने बबूल की लकड़ी की मेज बनाई। मेज़ छत्तीस इंच लम्बी, अट्ठारह इंच चौड़ी और सत्ताईस इंच ऊँची थी। ");
INSERT INTO hin2010_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","उसने मेज को शुद्ध सोने से मढ़ा। उसने सोने की सजावट मेज के चारों ओर की। ");
INSERT INTO hin2010_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","तब उसने मेज के चारों ओर एक किनारे बनायी। यह किनारे लगभग तीन इंच चौड़ी थी। उसने किनारे पर सोने की झालर लगाई। ");
INSERT INTO hin2010_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","तब उसने मेज के लिये चार सोने के कड़े बनाए। उसने नीचे के चारों कोनों पर सोने के चार कड़े लगाए। ये वहीं—वहीं थे जहाँ चार पैर थे। ");
INSERT INTO hin2010_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","कड़े किनारी के समीप थे। कड़ों में वे बल्लियाँ थीं जो मेज को ले जाने में काम आती थीं। ");
INSERT INTO hin2010_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","तब उसने मेज को ले जाने के लिये बल्लियाँ बनाईं। बल्लियों के लिये उसने बबूल की लकड़ी का उपयोग किया और उन को शुद्ध सोने से मढ़ा। ");
INSERT INTO hin2010_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","तब उसने उन चीज़ों को बनाया जो मेज पर काम आती थीं। उसने तश्तरी, चम्मच, परात और पेय भेंटों के लिये उपयोग में आने वाले घड़े बनाए। ये सभी चीज़ें शुद्ध सोने से बनाई गईं थीं। ");
INSERT INTO hin2010_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","तब उसने दीपाधार बनाया। इसके लिये उसने शुद्ध सोने का उपयोग किया और उसे पीट कर आधार तथा उसके डंडे को बनाया। तब उसने फूलों के समान दिखने वाले प्याले बनाए। प्यालों के साथ कलियाँ और खिले हुए पुष्प थे। हर एक चीज़ शुद्ध सोने की बनी थी। ये सभी चीजें एक ही इकाई बनाने के रूप में परस्पर जुड़ी थी। ");
INSERT INTO hin2010_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","दीपाधार के दोनों ओर छः शाखाएं थी। एक ओर तीन शाखाएं थी तथा तीन शाखाएं दूसरी ओर। ");
INSERT INTO hin2010_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","हर एक शाखा पर सोने के तीन फूल थे। ये फूल बादाम के फूल के आकार के बने थे। उनमें कलियाँ और पंखुडियाँ थीं। ");
INSERT INTO hin2010_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","दीपाधार की डंडी पर सोने के चार फूल थे। वे भी कली और पंखुडियों सहित बादाम के फूल के आकार के बने थे। ");
INSERT INTO hin2010_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","छः शाखाएं दो—दो करके तीन भागों में थीं। हर एक भाग की शाखाओं के नीचे एक कली थी। ");
INSERT INTO hin2010_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ये सभी कलियां, शाखाएं और दीपाधार शुद्ध सोने के बने थे। इस सारे सोने को पीट कर एक ही में मिला दिया गया था। ");
INSERT INTO hin2010_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","उसने इस दीपाधार के लिये सात दीपक बनाए तब उसने तश्तरियाँ और चिमटे बनाए। हर एक वस्तु को शुद्ध सोने से बनाया। ");
INSERT INTO hin2010_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","उसने लगभग पचहत्तर पौंड शुद्ध सोना दीपाधार और उसके उपकरणों को बनाने में लगाया। ");
INSERT INTO hin2010_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","तब उसने धूप जलाने की एक वेदी बनाई। उसने इसे बबूल की लकड़ी का बनाया। वेदी वर्गाकार थी। यह अट्ठारह इंच लम्बी, अट्ठारह इंच चौड़ी और छत्तीस इंच ऊँची थी। वेदी पर चार सींग बनाए गए थे। हर एक कोने पर एक सींग बना था। ये सींगे वेदी के साथ एक इकाई बनाने के लिये जोड़ दिए गए थे। ");
INSERT INTO hin2010_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","उसने सिरे, सभी बाजुओं और सींगो को शुद्ध सोने के पतरे से मढ़ा। तब उसने वेदी के चारों ओर सोने की झालर लगाई। ");
INSERT INTO hin2010_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","उसने सोने के दो कड़े वेदी के लिये बनाए। उसने सोने के कड़ों को वेदी के हर ओर की झालर से नीचे रखा। इन कड़ों में वेदी के हर ओर की झालर से नीचे रखा। इन कड़ों में वेदी को ले जाने के लिये बल्लियाँ डाली जाती थीं। ");
INSERT INTO hin2010_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","तब उसने बबूल की लकड़ी की बल्लियाँ बनाईं और उन्हें सोने से मढ़ा। ");
INSERT INTO hin2010_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","तब उसने अभिषेक का पवित्र तेल बनाया। उसने शुद्ध सुगन्धित धूप भी बनाई। ये चीज़ें उसी प्रकार बनाई गई जिस प्रकार कोई निपुण बनाता हैं। ");
INSERT INTO hin2010_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","तब उसने होमबलि की वेदी बनाई। यह वेदी होमबलि के लिये उपयोग में आने वाली थी। उसने बबूल की लकड़ी से इसे बनाया। वेदी वर्गाकार थी। यह साढ़े सात फुट लम्बी, साढ़े सात फुट चौड़ी और साढ़े सात फुट ऊँची थी। ");
INSERT INTO hin2010_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","उसने हर एक कोने पर एक सींग बनाये। उसने सींगों को वेदी के साथे जोड़ दिया। तब उसने हर चीज़ को काँसे से ढक लिया। ");
INSERT INTO hin2010_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","तब उसने वेदी पर उपयोग में आने वाले सभी उपकरणों को बनाया। उसने इन चीज़ों को काँसे से ही बनाया। उसने पात्र, बेलचे, कटोरे, माँस के लिए काँटे, और कढ़ाहियाँ बनाईं। ");
INSERT INTO hin2010_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","तब उसने वेदी के लिये एक जाली बनायी। यह जाली काँसे की जाली की तरह थी। जाली को वेदी के पायदान से लगाया। यह वेदी के भीतर लगभग मध्य में था। ");
INSERT INTO hin2010_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","तब उसने काँसे के कड़े बनाए। ये कड़े वेदी को ले जाने के लिये बल्लियों को फँसाने के काम आते थे। उसने पर्दे के चारों कोनों पर कड़ों को लगाया। ");
INSERT INTO hin2010_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","तब उसने बबूल की लकड़ी की बल्लियाँ बनाईं और उन्हें काँसे से मढ़ा। ");
INSERT INTO hin2010_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","उसने बल्लियाँ को कड़ों में डाला। बल्लियाँ वेदी की बगल में थीं। वे वेदी को ले जाने के काम आती थीं। उसने वेदी को बनाने के लिये बबूल के तख़्तों का उपयोग किया। वेदी भीतर खाली थी, एक खाली सन्दूक की तरह। ");
INSERT INTO hin2010_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","उसने हाथ धोने के बड़े पात्र तथा उसके आधार को उस काँसे से बनाया जिसे पवित्र तम्बू के प्रवेश द्वार पर सेवा करने वाली स्त्रियों द्वारा दर्पण के रूप में काम में लाया जाता था। ");
INSERT INTO hin2010_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","तब उसने आँगन के चारों ओर पर्दें की दीवार बनाईं। दक्षिण की ओर के पर्दे की दीवार पचास गज लम्बी थी। ये पर्दे सन के उत्तम रेशों के बने थे। ");
INSERT INTO hin2010_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","दक्षिणी ओर के पर्दो को बीस खम्भों पर सहारा दिया गया था। ये खम्भे काँसे के बीस आधारों पर थे। खम्भों और बल्लियों के लिये छल्ले चाँदी के बने थे। ");
INSERT INTO hin2010_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","उत्तरी तरफ़ का आँगन भी पचास गज लम्बा था और उसमें बीस खम्भे बीस काँसे के आधारों के साथ थे। खम्भों और बल्लियों के लिये छल्ले चाँदी के बने थे। ");
INSERT INTO hin2010_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","आँगन के पश्चिमी तरफ़ के पर्दे पच्चीस गज लम्बे थे। वहाँ दस खम्भे और दस आधार थे। खम्भों के लिये छल्ले तथा कुँड़े चाँदी के बनाए गए थे। ");
INSERT INTO hin2010_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","आँगन की पूर्वी दीवार पच्चीस गज चौड़ी थी। आँगन का प्रवेश द्वार इसी ओर था। ");
INSERT INTO hin2010_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","प्रवेश द्वार के एक तरफ़ पर्दे की दीवार साढ़े सात गज लम्बी थी। इस तरफ़ तीन खम्भे और तीन आधार थे। ");
INSERT INTO hin2010_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","प्रवेश द्वार के दूसरी तरफ़ पर्दे की दीवार की लम्बाई भी साढ़े सात गज़ थीं। वहाँ भी तीन खम्भे और तीन आधार थे। ");
INSERT INTO hin2010_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","आँगन के चारों ओर की कनाते सन के उत्तम रेशों की बनी थीं। ");
INSERT INTO hin2010_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","खम्भों के आधार काँसे के बने थे। छल्लों और कनातों की छड़े चाँदी की बनी थीं। खम्भों के सिरे भी चाँदी से मढ़े थे। आँगन के सभी खम्भे कनात की चाँदी की छड़ों से जुड़े थे। ");
INSERT INTO hin2010_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","आँगन के प्रवेश द्वार की कनात सन के उत्तम रेशों और नीले, लाल तथा बैंगनी कपड़े की बनी थी। इस पर कढ़ाई कढ़ी हुई थी। कनात दस गज लम्बी और ढाई गज ऊँची थी। ये उसी ऊँचाई की थी जिस ऊँचाई की आँगन की चारों ओर की कनातें थीं। ");
INSERT INTO hin2010_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","कनात चार खम्भों और चार काँसें के आधारों पर खड़ी थी। खम्भों के छल्ले चाँदी के बने थे। खम्भों के सिरे चाँदी से मढ़े थे और पर्दे की छड़े भी चाँदी की बनी थी। ");
INSERT INTO hin2010_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","पवित्र तम्बू और आँगन के चारों ओर की कनातों की खूँटियाँ काँसे की बनी थी। ");
INSERT INTO hin2010_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","मूसा ने सभी लेवी लोगों को आदेश दिया कि वे तम्बू अर्थात् साक्षीपत्र का तम्बू बनाने में काम आई हुई चीज़ों को लिख ले। हारून का पुत्र ईतामार इस सूची को रखने का अधिकारी था। ");
INSERT INTO hin2010_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","यहूदा के परिवार समूह से हूर के पुत्र ऊरी के पुत्र बसलेल ने भी सभी चीज़ें बनाईं जिनके लिये यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","दान के परिवार समूह से अहीसामाक के पुत्र ओहोलीआब ने भी उसे सहायता दी। ओहोलीआब एक निपुण कारीगर और शिल्पकार था। वह सन के उत्तम रेशों और नीला, बैंगनी और लाल कपड़े बुनने में निपुण था। ");
INSERT INTO hin2010_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","दो टन से अधिक सोना पवित्र तम्बू के लिये यहोवा को भेंट किया गया था। (यह मन्दिर के प्रामाणिक बाटों से तोला गया था।) ");
INSERT INTO hin2010_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","लोगों ने पौने चार टन से अधिक चाँदी दी। (यह अधिकारिक मन्दिर के बाट से तोली गयी थी।) ");
INSERT INTO hin2010_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","यह चाँदी उनके द्वारा कर वसूल करने से आई। लेवी पुरुषों ने बीस वर्ष या उससे अधिक उम्र के लोगों की गणना की। छः लाख तीन हज़ार पाँच सौ पचास लोग थे और हर एक पुरुष को एक बेका चाँदी कर के रूप में देनी थी। (मन्दिर के अधिकारिक बाट के अनुसार एक बेका आधा शेकेल होता था।) ");
INSERT INTO hin2010_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","पौने चार टन चाँदी का उपयोग पवित्र तम्बू के सौ आधारों और कनातों को बनाने में हुआ था। उन्होंने पचहत्तर पौंड चाँदी हर एक आधार में लगायी। ");
INSERT INTO hin2010_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","अन्य पचास पौंड़ चाँदी का उपयोग खूँटियों कनातों की छड़ों और खम्भों के सिरों को बनाने में हुआ था। ");
INSERT INTO hin2010_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","साढ़े छब्बीस टन से अधिक काँसा यहोवा को भेंट चढ़ाया गया। ");
INSERT INTO hin2010_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","उस काँसे का उपयोग मिलापवाले तम्बू के प्रवेश द्वार के आधारों को बनाने में हुआ। उन्होंने काँसे का उपयोग वेदी और काँसे की जाली बनाने में भी किया और वह काँसा, सभी उपकरण और वेदी की तश्तरियों को बनाने के काम में आया। ");
INSERT INTO hin2010_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","इसका उपयोग आँगन के चारों ओर की कनातों के आधारों और प्रवेश द्वार की कनातों के आधारों के लिए भी हुआ। और काँसे का उपयोग तम्बू के लिये खूँटियों को बनाने और आँगन के चारों ओर की कनातों के लिए हुआ। ");
INSERT INTO hin2010_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","कारीगरों ने नीले, लाल और बैंगनी कपड़ों के विशेष वस्त्र याजकों के लिए बनाए जिन्हें वे पवित्र स्थान में सेवा के समय पहनेगे। उन्होंने हारून के लिए भी वैसे ही विशेष वस्त्र बनाये जैसा यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","उन्होंने एपोद सन के उत्तम रेशों और नीले, लाल और बैंगनी कपड़े से बनाया। ");
INSERT INTO hin2010_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","(उन्होंने सोने को बारीक पट्टियों के रूप में पीटा और तब उन्होंने उसे लम्बे धागो के रूप में काटा। उन्होंने सोने को नीले, बैंगनी, लाल कपड़ों और सन के उत्तम रेशों में बुना। इसे निपुणता के साथ किया गया।) ");
INSERT INTO hin2010_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","उन्होंने एपोद के कंधों की पट्टियाँ बनाई। और कंधे की इन पट्टियों को एपोद के कंधे पर टाँका। ");
INSERT INTO hin2010_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","पटुका उसी प्रकार बनाया गया था। यह एपोद से एक ही इकाई के रूप मे जोड़ दिया गया। यह सोने के तार, सन के उत्तम रेशों, नीला, लाल और बैंगनी कपड़े से वैसा ही बना जैसा यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","कारीगरों ने रत्नों को सोने को पट्टी में जड़ा। उन्होंने इस्राएल के पुत्रों के नाम रत्नों पर लिखे। ");
INSERT INTO hin2010_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","तब उन्होंने रत्नों को एपोद के कंधें के पेबन्द पर लगाया। हर एक रत्न इस्राएल के बारह पुत्रों में से एक—एक का प्रतिनिधित्व करता था। यह वैसा ही किया गया जैसा यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","तब उन्होंने सीनाबन्द बनाया। यह वही निपुणता के साथ बनाया गया था। सीनाबन्द एपोद की तरह बनाया गया था। यह सोने के तार, सन के उत्तम रेशों, नीला, लाल और बैंगनी कपड़े का बनाया गया था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","सीनाबन्द वर्गाकार दोहरा तह किया हुआ था। यह नौ इंच लम्बा और नौ इंच चौड़ा था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","तब कारीगर ने इस पर सुन्दर रत्नों की पक्तियाँ जड़ीं। पहली पंक्ति में एक लाल, एक पुखराज और एक मर्कतमणि थी। ");
INSERT INTO hin2010_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","दूसरी पंक्ति में एक फिरोज़ा, एक नीलम तथा एक पन्ना था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","तीसरी पंक्ति में एक धूम्रकान्त, अकीक और एक याकूत था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","चौथी पंक्ति में एक लहसुनिया, एक गोमेदक मणि, और एक कपिश मणि थी। ये सभी रत्न सोने में जड़े थे। ");
INSERT INTO hin2010_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","इन बारह रत्नों पर इस्राएल के पुत्रों के नाम उसी प्रकार लिखे गये थे जिस प्रराक एक कारीगर मुहर पर खोदता है। हर एक रत्न पर इस्राएल के बारह पुत्रों में से एक—एक का नाम था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","सीनाबन्द के लिए शुद्ध सोने की एक जंजीर बनाई गई। ये रस्सी की तरह बटी थी। ");
INSERT INTO hin2010_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","कारीगरों ने सोने की दो पट्टियों और दो सोने के छल्ले बनाए। उन्होंने दोनों छल्लों को सीनाबन्द के ऊपरी कोनों पर लगाया। ");
INSERT INTO hin2010_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","तब उन्होंने दोनों सोने की जंजीरों को दोनों छल्लों में बाँधा। ");
INSERT INTO hin2010_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","उन्होंने सोने की जंजीरों के दूसरी सिरों को दोनों पट्टियों से बाँधा। तब उन्होंने एपोद के दोनों कंधों से सामने की ओर उन्हें फँसाया। ");
INSERT INTO hin2010_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","तब उन्होंने दो और सोने के छल्ले बनाए और सीनाबन्द के निचले कोनों पर उन्हें लगाया। उन्होंने छल्लों को चोगे के समीप अन्दर लगाया। ");
INSERT INTO hin2010_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","उन्होंने सामने की ओर कंधे की पट्टी के तले में सोने के दो छल्ले लगाए। ये छल्ले बटनों के समीप ठीक पटुके के ऊपर थे। ");
INSERT INTO hin2010_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","तब उन्होंने एक नीली पट्टी का उपयोग किया और सीनाबन्द के छल्लों को एपोद छल्लों से बाँधा। इस प्रकार सीनाबन्द पेटी के समीप लगा रहा। यह गिर नहीं सकता था। उन्होंने यह सब चीज़ें यहोवा के आदेश के अनुसार कीं। ");
INSERT INTO hin2010_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","तब उन्होंने एपोद के नीचे का चोगा बनाया। उन्होंने इसे नीले कपड़े से बनाया। यह एक निपुण व्यक्ति का काम था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","चोग़े के बीचोंबीच एक छेद था। इस छेद के चारों ओर कपड़े की गोट लगी थी। यह गोट छेद को फटने से बचाती थी। ");
INSERT INTO hin2010_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","तब उन्होंने सन के उत्तम रेशों, नीले, लाल और बैंगनी कपड़े से फूँदने बनाए जे अनार के आकार के नीचे लटके थे। उन्होंने इन अनारों को चोग़े के नीचे के सिरे पर चारों ओर बाँधा। ");
INSERT INTO hin2010_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","तब उन्होंने शुद्ध सोने की घंटियाँ बनाई। उन्होंने अनारों के बीच में चोगे के नीचे के सिरे के चारों ओर इन्हें बाँधा। ");
INSERT INTO hin2010_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","लबादे के नीचे के सिरे के चारो ओर अनार और घंटियाँ थी। हर एक अनारों के मध्य घंटी थी। याजक उस चोगे को तब पहनता था जब वह यहोवा की सेवा करता था, जैसा यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","कारीगरों ने हारून ओर उसके पुत्रों के लिये लबादे बनाए। ये लबादे सन के उत्तम रेशों के थे। ");
INSERT INTO hin2010_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","और कारीगरों के सन के उत्तम रेशों के साफ़े बनाए। उन्होंने सिर की पगड़ियाँ और अधोवस्त्र भी बनाए। उन्होंने इन चीज़ों को सन के उत्तम रेशों का बनाया। ");
INSERT INTO hin2010_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","तब उन्होंने पटुके को सन के उत्तम रेशों, नीले, बैंगनी और लाल कपड़े से बनाया। कपड़े में काढ़ने काढ़े गये। ये चीज़ें वैसी ही बनाई गई जैसा यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","तब उन्होंने सिर पर बाँधने के लिये सोने का पतरा बनाया। उन्होंने सोने पर ये शब्द लिखे: यहोवा के लिए पवित्र। ");
INSERT INTO hin2010_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","तब उन्होंने पतरे से एक नीली पट्टी बाँधी और उसे पगड़ी पर इस प्रकार बाँधा जैसा यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","इस प्रकार मिलापवाले तम्बू का सारा काम पूरा हो गया। इस्राएल के लोगों ने हर चीज़ ठीक वैसी ही बनाई जैसा यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","तब उन्होंने मिलापवाला तम्बू मूसा को दिखाया। उन्होंने उसे तम्बू और उसमें की सभी चीज़ें दिखाईं। उन्होंने उसे छल्ले, तख्ते, छड़ें खम्भे तथा आधार दिखाए। ");
INSERT INTO hin2010_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","उन्होंने उसे तम्बू का आच्छादन दिखाया जो लाल रंगी हुई भेड़ की खाल का बना था और उन्होंने वह आच्छादन दिखाया जो सुइसों के चमड़े का बना था और उन्होंने वह कनात दिखाई जो प्रवेश द्वार से सब से अधिक पवित्र स्थान को ढकती थी। ");
INSERT INTO hin2010_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","उन्होंने मूसा को साक्षीपत्र का सन्दूक दिखाया। उन्होंने सन्दूक को ले जाने वाली बल्लियाँ तथा सन्दूक को ढकने वाले ढक्कन को दिखाया। ");
INSERT INTO hin2010_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","उन्होंने विशेष रोटी की मेज़ तथा उस पर रहने वाली सभी चीज़े और साथ में विशेष रोटी मूसा को दिखायी। ");
INSERT INTO hin2010_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","उन्होंने मूसा को शुद्ध सोने का दीपाधार और उस पर रखे हुए दीपकों को दिखाया। उन्होंने तेल और अन्य सभी चीज़ें मूसा को दिखाई, जिनका उपयोग दीपकों के साथ होता था। ");
INSERT INTO hin2010_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","उन्होंने उसे सोने की वेदी, अभिषेक का तेल, सुगन्धित धूप और तम्बू के प्रवेश द्वार को ढकने वाली कनात को दिखाया। ");
INSERT INTO hin2010_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","उन्होंने काँसे की वेदी और काँसे की जाली को दिखाया। उन्होंने वेदी को ले जाने के लिये बनी बल्लियों को भी मूसा को दिखाया। और उन्होंने उन सभी चीज़ों को दिखाया जो वेदी पर काम मे आती थी। उन्होंने चिलमची और उसके नीचे का आधार दिखाया। ");
INSERT INTO hin2010_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","उन्होंने आँगन के चारों ओर की कनातों को, खम्भों ओर आधारों के साथ मूसा को दिखाया। उन्होंने उसको उस कनात को दिखाया जो आँगन के प्रवेशद्वार को ढके थी। उन्होंने उसे रस्सियाँ और काँसे की तम्बू वाली खूँटियाँ दिखाईं। उन्होंने मिलापवाले तम्बू में उसे सभी चीज़ें दिखाईं। ");
INSERT INTO hin2010_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","तब उन्होंने मूसा को पवित्र स्थान में सेवा करने वाले याजकों के लिये बने वस्त्रों को दिखाया। वे उन वस्त्रों को तब पहनते थे जब वे याजक के रूप में सेवा करते थे। ");
INSERT INTO hin2010_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","यहोवा ने मूसा को जैसा आदेश दिया था इस्राएल के लोगों ने ठीक सभी काम उसी तरह किया। ");
INSERT INTO hin2010_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","मूसा ने सभी कामों को ध्यान से देखा। मूसा ने देखा कि सब काम ठीक उसी प्रकार हुआ जैसा यहोवा ने आदेश दिया था। इसलिए मूसा ने उनको आशीर्वाद दिया। ");
INSERT INTO hin2010_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“पहले महीने के पहले दिन पवित्र तम्बू जो मिलाप वाला तम्बू है खड़ा करो। ");
INSERT INTO hin2010_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","साक्षीपत्र के सन्दूक को मिलापवाले तम्बू में रखो। सन्दूक को पर्दे से ढक दो। ");
INSERT INTO hin2010_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","तब विशेष रोटी की मेज को अन्दर लाओ। जो सामान मेज पर होने चाहिए उन्हें उस पर रखो। तब दीपाधार को तम्बू में रखो। दीपाधार पर दीपकों को ठीक स्थानों पर रखो। ");
INSERT INTO hin2010_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","सोने की वेदी को, धूप की भेंट के लिये तम्बू में रखो। वेदी को साक्षीपत्र के सन्दूक के सामने रखो। तब कनात को पवित्र तम्बू के प्रवेश द्वार पर लगाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“होमबलि की वेदी को मिलापवाले तम्बू की पवित्र तम्बू के प्रवेशद्वार पर रखो। ");
INSERT INTO hin2010_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","चिलमची को वेदी और मिलापवाले तम्बू के बीच मे रखो। चिलमची में पानी भरो। ");
INSERT INTO hin2010_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","आँगन के चारों ओर कनाते लगाओ। तब आँगन के प्रवेशद्वार पर कनात लगाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“अभिषेक के तेल को डालकर पवित्र तम्बू और इसमें की हर एक चीज़ का अभिषेक करो। जब तुम इन चीज़ों पर तेल डालोगे तो तुम इन्हें पवित्र बनाओगे। ");
INSERT INTO hin2010_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","होमबलि की वेदी का अभिषेक करो। वेदी की हर एक चीज़ का अभिषेक करो। तुम वेदी को पवित्र करोगे। यह अत्यधिक पवित्र होगी। ");
INSERT INTO hin2010_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","तब चिलमची और उसके नीचे के आधार का अभिषेक करो। ऐसा उन चीज़ों के पवित्र करने के लिये करो। ");
INSERT INTO hin2010_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“हारून और उसके पुत्रों को मिलापवाले तम्बू के प्रवेशद्वार पर लाओ। उन्हें पानी से नहलाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","तब हारून को विशेष वस्त्र पहनाओ। तेल से उसका अभिषेक करो और उसे पवित्र करो। तब वह याजक के रूप में मेरी सेवा कर सकता है। ");
INSERT INTO hin2010_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","तब उसके पुत्रों को वस्त्र पहनाओ। ");
INSERT INTO hin2010_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","पुत्रों का अभिषेक वैसे ही करो जैसे उनके पिता का अभिषेक किया। तब वे भी मेरी सेवा याजक के रूप में कर सकते हैं। जब तुम अभिषेक करोगे, वे याजक हो जाएंगे। वह परिवार भविष्य में भी सदा के लिये याजक बना रहेगा।” ");
INSERT INTO hin2010_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","मूसा ने यहोवा की आज्ञा मानी। उसने वह सब किया जिसका यहोवा ने आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","इस प्रकार ठीक समय पर पवित्र तम्बू खड़ा किया गया। यह मिस्र छोड़ने के बाद के दूसरे वर्ष में पहले महीने का पहला दिन था। ");
INSERT INTO hin2010_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","मूसा ने पवित्र तम्बू को यहोवा के कथानानुसार खड़ा किया। पहले उसने आधारों को रखा। तब उसने आधारों पर तख़्तों को रखा। फिर उसने बल्लियाँ लगाईं और खम्भों को खड़ा किया। ");
INSERT INTO hin2010_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","उसके बाद मूसा ने पवित्र तम्बू के ऊपर आच्छादन रखा। इसके बाद उसने तम्बू के आच्छादन पर दूसरा आच्छादन रखा। उसने यह यहोवा के आदेश के अनुसार किया। ");
INSERT INTO hin2010_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","मूसा ने साक्षीपत्र के उन पत्थरों को जिन पर यहोवा के आदेश लिखे थे, सन्दूक में रखा। मूसा ने बल्लियों को सन्दूक के छल्लों में लगाया। तब उसने ढक्कन को सन्दूक के ऊपर रखा। ");
INSERT INTO hin2010_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","तब मूसा सन्दूक को पवित्र तम्बू के भीतर लाया। और उसने पर्दे को ठीक स्थान पर लटकाया। उसने पवित्र तम्बू में साक्षीपत्र के सन्दूक को ढक दिया। मूसा ने ये चीज़ें यहोवा के आदेश के अनुसार कीं। ");
INSERT INTO hin2010_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","तब मूसा ने विशेष रोटी की मेज को मिलापवाले तम्बू में रखा। उसने इसे पवित्र तम्बू के उत्तर की ओर रखा। उसने इसे पर्दे के सामने रखा। ");
INSERT INTO hin2010_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","तब उसने यहोवा के सामने मेज पर रोटी रखी। उसने यह यहोवा ने जैसा आदेश दिया था, वैसा ही किया। ");
INSERT INTO hin2010_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","तब मूसा ने दीपाधार को मिलापवाले तम्बू में रखा। उसने दीपाधार को पवित्र तम्बू के दक्षिण ओर मेज के पार रखा। ");
INSERT INTO hin2010_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","तब यहोवा के सामने मूसा ने दीपाधार पर दीपक रखे। उसने यह यहोवा के आदेश के अनुसार किया। ");
INSERT INTO hin2010_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","तब मूसा ने सोने की वेदी को मिलापवाले तम्बू में रखा। उसने सोने की वेदी को पर्दे के सामने रखा। ");
INSERT INTO hin2010_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","तब उसने सोने की वेदी पर सुगन्धित धूप जलाई। उसने यह यहोवा के आदेशानुसार किया। ");
INSERT INTO hin2010_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","तब मूसा ने पवित्र तम्बू के प्रवेश द्वार पर कनात लगाई। ");
INSERT INTO hin2010_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","मूसा ने होमबलि वाली वेदी को, मिलापवाले तम्बू के प्रवेशद्वार पर रखा। तब मूसा ने एक होमबलि उस वेदी पर चढ़ाई। उसने अन्नबलि भी यहोवा को चढ़ाई। उसने ये चीज़ें यहोवा के आदेशानुसार कीं। ");
INSERT INTO hin2010_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","तब मूसा ने मिलापवाले तम्बू और वेदी के बीच चिलमची को रखा। और उसमे धोने के लिये पानी भरा। ");
INSERT INTO hin2010_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","मूसा, हारून और हारून के पुत्रों ने अपने हाथ और पैर धोने के लिए इस चिलमची का उपयोग किया। ");
INSERT INTO hin2010_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","वे हर बार जब मिलापवाले तम्बू में जाते तो अपने हाथ और पैर धोते थे। जब वे वेदी के निकट जाते थे तब भी वे हाथ और पैर धोते थे। वे इसे वैसे ही करते थे जैसा यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","तब मूसा ने पवित्र तम्बू के आँगन के चारों ओर कनातें खड़ी कीं। मूसा ने वेदी को आँगन में रखा। तब उसने आँगन के प्रवेश द्वार पर कनात लगाई। इस प्रकार मूसा ने वे सभी काम पूरे कर लिए जिन्हें करने का आदेश यहोवा ने दिया था। ");
INSERT INTO hin2010_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","जब सभी चीज़ें पूरी हो गई, बादल ने मिलापवाले तम्बू को ढक लिया। और यहोवा के तेज़ से पवित्र तम्बू भर गया। ");
INSERT INTO hin2010_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","बादल मिलापवाले तम्बू पर उतर आया। और यहोवा के तेज ने पवित्र तम्बू को भर दिया। इसलिए मूसा मिलापवाले तम्बू में नहीं घुस सका। ");
INSERT INTO hin2010_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","इस बादल ने लोगों को संकेत दिया कि उन्हें कब चलना है। जब बादल तम्बू से उठता तो इस्राएल के लोग चलना आरम्भ कर देते थे। ");
INSERT INTO hin2010_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","किन्तु जब बादल तम्बू पर ठहर जाता तो लोग चलने की कोशिश नहीं करते थे। वे उसी स्थान पर ठहरे रहते थे, जब तक बादल तम्बू से नहीं उठता था। ");
INSERT INTO hin2010_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","इसलिए दिन में यहोवा का बादल तम्बू पर रहता था, और रात को बादल में आग होती थी। इसलिए इस्राएल के सबी लोग यात्रा करते समय बादल को देख सकते थे। ");
INSERT INTO hin2010_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","यहोवा परमेश्वर ने मूसा को बलाया और मिलापवाले तम्बू में से उससे बोला। यहोवा ने कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“इस्राएल के लोगों से कहो: तुम लोगों में से कोई जब यहोवा को भेट लाए तो वह भेंट तुम्हें उन जानवरों में से लानी चाहिये जो तुमाहेरे झुण्ड या रेवड़ में से हो। ");
INSERT INTO hin2010_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“यदि कोई व्यक्ति अपने पशुओं में से किसी की होमबलि दे तो वह नर होना चाहिए और उस जानवर में कोई दोष नहीं होना चाहिए। उस व्यक्ति को चाहिए कि वह जानवर को मिलापवाले तम्बू के द्वार पर ले जाये। तब यहोव भेंट स्वीकार करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","इस व्यक्ति को अपना हाथ जानवर के सिर पर रखना चाहिए। परमेश्वर होमबिल को व्यक्ति के पाप के लिए भुगतान के रुप में स्वीकार करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","“व्यक्ति को चाहिए कि वह बछड़े का खून पर चारों ओर खून छिड़कना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","वह उस जानवर का चमड़ा हटा देगा और उसे टुकड़ों में काटेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","हारून के याजक पुत्रों को वेदी पर लकड़ी और आग रखनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","हारून के याजक पुत्रों को वे टुकड़े, (सिर और चर्बी) लकड़ी पर रखनी चाहिए। वह लकड़ी वेदी पर आग के ऊपर होती है। ");
INSERT INTO hin2010_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","याजक को जानवर के भीतरी भागों और पैरों को पानी से धोना चाहिए। तब याजक को जानवर के सभी भागों को वेदी पर जलाना चाहिए। यही होमबलि है अर्थात आग के द्वारा यहोवा को सुगन्ध से प्रसन्न करना। ");
INSERT INTO hin2010_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“यदि कोई व्यक्ति भेड़ या बकरी की होमबलि चढ़ाए तो वह एक ऐसे नर पशु की भेंट दे जिसमें कोई दोष न हो। ");
INSERT INTO hin2010_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","उस व्यक्ति को वेदी के उत्तर की ओर यहोवा के सामने पशु को मारना चाहिए। हारून के याजक पुत्रों को वेदी के चारों ओर खून छिड़कना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","तब याजक को चाहिए कि वह पशु को टुकड़ों में काटे। पशु का सिर और चर्बी याजक को लकड़ी के ऊपर क्रम से रखना चाहिए। लकड़ी वेदी पर आग के ऊपर रहती है। ");
INSERT INTO hin2010_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","याजक को पशु के भीतरी भागों और उसके पैरों को पानी से धोना चाहिए। तब याजक को चाहिए कि वह पशु के सभी भागों को वेदी पर जलाएँ। यह होमबलि है अर्थात् आग के द्वारा यहोवा को सुगन्ध से प्रसन्न करना। ");
INSERT INTO hin2010_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“यदि कोई व्यक्ति यहोवा को पक्षी की होमबलि चढ़ाए तो यह पक्षी की होमबलि चढ़ाए तो यह पक्षी फाख्ता या नया कबूतर होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","याजक बेंट को वेदी कपर लाएगा। याजक पक्षी को वेदी पर जलाएगा। पक्षी का खून वेदी की ओर बहना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","याजक को पक्षी के गले की थैली और उसके पंखों को वेदी के पूर्व की ओर फेंक देना चाहिए। यह वही जगह है जहाँ वे वेदी से निकालकर राख डालते हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","तब याजक को पंख के पास से पक्षी को चीरना चाहिए किन्तु पक्षी को दो भागों ने नहीं बाँटना चाहिए। याजक को वेदी के ऊपर आग पर रखी लकड़ी के ऊपर पक्षी को जलाना चाहिए। यह होमबलि है अर्थात् आग के द्वारा यहोवा को सुगन्ध से प्रसन्न करना। ");
INSERT INTO hin2010_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“जब कोई व्यक्ति यहोवा को अन्नबलि चढ़ाये तो उसकी भेंट महीन आटे की होनी चाहिए। वह व्यक्ति उस आटे पर तेल डाले और उस पर लोबान रखे। ");
INSERT INTO hin2010_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","तब वह इसे हारून के याजक पुत्रों के पास लाए। वह व्यक्ति तेल और लोबान से मिला हुआ एक मुट्ठी महीन आटा ले तब योजक वेदी पर स्मृतिभेंट के रूप में आटे को आग में जलाए। यह यहोवा के लिये सुगन्ध होगी ");
INSERT INTO hin2010_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","और बची हुई अन्नबलि हारून और उसके पुत्रों के लिए होगी। यह भेंट यहोवा को आग से दी जाने वाली भेंटों में सबसे अधिक पवित्र होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“जब तुम चूल्हे मं पकी अन्नबलि लाओ तो यह अखमीरी मैदे के फुलके या ऊपर से तेल डाली हुई अख़मीरी चपातियाँ होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","यदि तुम भूनने की कड़ाही से अन्नबलि लाते हो तो यह तेल मिली अख़मीरी महीन आटे की होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","तुम्हे इसे कई टुकड़े करके कई भागों में बाँटना चाहिए और इन पर तेल डालना चाहिए। यह अन्नबलि है। ");
INSERT INTO hin2010_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","यदि तुम अन्नबलि तलने की कड़ाही से लाते हो तो यह तेल मिले महीन आटे की होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","“तुम इन चीजो से बनी अन्नबलि यहोवा के लिओ लाओगे। तुन उन चीजों को याजक के पास ले जाओगे औ वह उन्हें वैदी पर रखेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","फिर उस अन्नबलि में से याजक इसका कुछ भाग लेकर उसे स्मृति भेंट के रूप में वेदी पर जलायेगा। यह आग द्वारा दी गई एक भेंट है। इस की सुगन्ध से यहोवा प्रसन्न होता है। ");
INSERT INTO hin2010_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","बची हुई अन्नबलि हारून और उसके पुत्रों की होगी। यह भेंट यहोवा को आग से चढ़ाई जाने वाली भेंटों में अति पवित्र होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“तुम्हें यहोवा को खमीर वाली कोई अन्नबलि नहीं चढ़ानी चाहिए। तुम्हें यहोवा को, आग द्वारा भेंट के रूप में ख़मीर या शहद नहीं जलाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","तुम पहली फ़सल से तैयाह की गई खमीर और शहद मधुर गन्ध के रूप में ऊपर जाने के लिए वैदी पर जलाने नहीं चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","तुम्हें अपनी लायी हुई हर एक अन्नबलि पर नमक भी रखना चाहिए। यहोवा से तुम्हारे वाचा के प्रतीक रूप, नमक का अभाव तुम्हारी किसी अन्नबलि में नहीं होना चाहिए। तुम्हें अनपी सभी भेटों के साथ नमक लाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“यदि तुम पहली फ़सल से यहोवा को अन्नबलि लाते हो तो तुम्हें भुनी हुई अन्न की बालें लानी चाहिए। इस अन्न को दलकर छोटे टुकड़ों में तोड़ा जाना चाहिए। इस पहली फसल से तुम्हारी अन्नबलि होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","तुम्हें इस पर तेल डालना और लोबान रखना चाहिए। यह अन्नबलि है। ");
INSERT INTO hin2010_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","याजक को चाहिए कि वह स्मृति भेंटके रूप में दले गए अन्न के कुछ भाग, तेल और इस पर रखे पूरे लोबान को जलाए। यह यहोवा को आग से चढ़ाई भेंट है। ");
INSERT INTO hin2010_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“यदि यह भेंट मेलबलि है और यह यहोवा को अपने पशुओं के झुण्ड से एक नर या मादा पशु देता है, तो इस पशु में कोई दोष नहीं होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","इस व्यक्ति को अनपा हाथ पशु के सिर पर रखना चाहिए। मिलापवाले तुम्बू के द्वार पर उस व्यक्ति द्वारा उस पशु को मार डालना चाहिए। तब हारून के याजक पुत्रों को वेदी पर चारों ओर खून छिड़कना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","इस व्यक्ति को मेलबलि में से यहोवा को आग द्वारा भेंट चढ़ानी चाहिए। भीतरी भागों को ढकने वाली और भीतरी भागों में रहने वाली चर्बी की भेंट चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","उस के दोनों गुर्दों पर की चर्बी और पुट्ठे की चर्बी भी भेंट में चढ़ानी चाहिए। गुर्दों के सात कलेजे को ढकने वाली चर्बी भी निकाल लेनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","तब हारून के पुत्र चर्बी को वेदी पर जलाएंगे। वे आग पर रखी हुई लकड़ी, जिस पर होमबलि रखी गी, उसके ऊपर उसे रखेंगे। इस की सुगन्ध यहोवा को प्रसन्न करती है। ");
INSERT INTO hin2010_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“यदि व्यक्ति यहोवा के लिए अपनी रेवड़ में से मेलबलि के रूप में पशु को लाता है, तब उसे एक नर या मादा पशु भेंट में देना चाहिए जिसमें कोई दोष न हो। ");
INSERT INTO hin2010_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","यदि वह भेंट में एक मेमना लाता है तो उसे यहोवा के सामने लाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","उसे अपना हाथ पशु के सिर पर रखाना चाहिए हारून के पुत्र वेदी पर चारों ओर पशु का खून जालेंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","तब वह व्यक्ति मेलबलि का एक भाग यहोवा को आग द्वारा भेंट के रूप में चढ़ाएगा। इस व्यक्ति को चर्बी और चर्बी से भरी सम्पूर्ण पूँछ और पशु के भीतरी भागों के ऊपर और चारों ओर की चर्बी लानी चाहिए। (उसे उस पूँछ को रीढ़ की हड्डी के एकदम पास से काटना चाहिए।) ");
INSERT INTO hin2010_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","इस व्यक्ति को दोनों गुर्दे और उन्हें ढकने वाली चर्बी और पुट्ठे की चर्बी भी भेंट में चढ़ानी चाहिए। उसे कलेजे को ढकने वाली चर्बी भी भेंट में चढ़ानी चाहीए। उसे गुर्दों के साथ कलेजे को भी निकाल लेना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","तब याजक वेदी पर इस को जलाएगा। यह यहोवा को आग द्वारा दी गई भेंट होगी तथा यह लोगों के लिए भी भोजन होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“यदि किसी व्यक्ति की भेंट एक बकरा है तो वह उसे यहोवा के सामने भेंट करे। ");
INSERT INTO hin2010_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","इस व्यक्ति को बकरे के सिर पर हाथ रखना चाहिए। तब हारून के पुत्र बकरे का खून वैदी पर चारों ओर जालेंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","तब व्यक्ति को बकरे का एक भाग यहोवा को अग्नि द्वारा भेंट के रूप में चढ़ाने के लिए लाना चाहिए। इस व्यक्ति को भीतरी भाग के ऊपर और उसके चारों ओर की चर्बी की भेंट चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","उशे दोनों गुर्दे उसे ढकने वाली चर्बी तथा पशु के पुट्ठे की चर्बी भेंट में चढ़ानी चाहिए। उसे कलेजे को ढकलने वाली चर्बी चढ़ानी चाहिए। उसे कलेजे के साथ गुर्दे को निकाल लेना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","याजक को वेदी पर बकरे के भागों को जलाना चाहिए। यह यहोवा को आग द्वारा दी गई भेंट तथा याजक का भोजन होगा। इसकी सुगन्ध यहोवा को प्रसन्न करती है। (लेकिन सारा उत्तम भाग यहोवा का है।) ");
INSERT INTO hin2010_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","यह नियम तुम्हारी सभी पीढ़ीयों में सदा चलता रहेगा। तुम जहाँ कहीं भी रहो, तुम्हें खून या चर्बी नहीं खानी चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“इस्राएल के लोगों से कहोः यदि किसी व्यक्ति से संयोगवश कोई ऐसा पाप हो जाए जिसे यहोवा ने न करने का आदेश दिया हो तो उस व्यक्ति को निम्न बातें करनी चाहिए: ");
INSERT INTO hin2010_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“यदि अभीषिक्त याजक से कोई ऐसा पाप हुआ हो जसका बुरा असर लोगों पर पड़ा हो तो उसे अपने किए गए पाप के लिए यहोवा को बलि चढ़ानी चाहिए: उसे एक बछड़ा यहोवा को भेंट में देना चाहिए जिसमें कोई दोष न हो। उसे यहोवा को बछड़ा पापबलि के रूप में चढ़ाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","अभिषिक्त याजक को उस बछड़े को परमेश्वर के सामने मिलापवाले तम्बू के द्वार पर लाना चाहिए। उसे अपना हाथ उस बछड़े के सिर पर रखाना चाहिए और यहोहा के सामने उसे मार देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","तब अभिषिक्त याजक को बछड़े का कुच खून लेना चाहिए और मिलापवले तम्बू में ले जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","याजक को अपनी उँगलियाँ खून में डालनी चाहिए और महापवित्र स्थान के पर्दे के सामने खून को सात बार परमेश्वर के सामने छिड़कना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","याजक को कुछ खून सुगन्धित धूप की वेदी के सिरे पर लगाना चाहिए। (यह वेदी यहोवा के सामने मिलापवाले तम्बू में है।) याजक को बछड़े का सारा ख़ून होमबलि की वेदी की नींव पर डालना चाहिए। (वह वेदी मिलापवले तम्बू के द्वार पर है।) ");
INSERT INTO hin2010_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","औ उसे पापबलि किए गए बछड़े की सारी चर्बी को निकाल लेना चाहिए। उसे भीतरी भागों के ऊपर और उसके चारों ओर की चर्बी को निकाल लेनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","उसे दोनों गुर्दे, उसके ऊपर की चर्बी और पुट्ठे पर की चर्बी ले लेनी चाहिए। उसे कलेजे को ढकने वाली चर्बी भी लेनी चाहिये और उसे कलेजे को गुर्दे के साथ निकाल लेना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","याजक को ये चीजें ठीक उसी तरह लेनी चाहिए जिस प्रकार उसने ये चीजें मेलबलि के बछड़े से ली थी। याजक को होमबलि की वेदी पर पशु के भागों को जलाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","किन्तु याजक को बछड़े का चमड़ा, सिर सहित इसका सारा माँस, पैर, भीतरी भाग और शरीर का बेकार भाग निकल लेना चाहिए। याजक को डेरे के बाहर विशेष स्थान पर बछड़े के पूरे शरीर को लेजाना चाहिए जहाँ राख डाली जाती है। याजक को वहाँ लकड़ी की आग पर बछड़े को जलान चाहिए। बछड़े को वहाँ जलाय जाना चाहिए जहाँ राख डाली जाती हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ऐसा हो सकता है कि पूरे इस्राएल राष्ट्र से अनजाने में कोई ऐसा पाप हो जाए जिसे न करने का आदेश परमेश्वर ने दिया है। यदि ऐसा होता है तो वे दोषी होंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","यदि उन्हें इस पाप का पता चलता है तो पूरे राष्ट्र के लिए एक बछड़ा पापबलि के रूप में चढ़ाया जाना चाहिए। उन्हें बछड़े को मिलापवाले तम्बू के सामने लाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","बुजुर्गों को यहोवा के सामने बछड़े के सिर पर अपने हाथ रखने चाहिए। यहोवा के सामने बछड़े को मारना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","तब अभिषिक्त याजक को बछड़े का कुछ खून मिलापवले तम्बू में लाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","याजक को अपनी उँगलियाँ खून में डूबानी चाहिए और पर्दे के सामने सात बार खून को यहोवा के सामने छिड़कना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","तब याजक को कुछ खून वेदी के सिरे के सींगों पर डालना चाहिए। (वह वेदी मिलापवाले तम्बू में यहोवा के सामने है।) याजक को सारा खून होमबली की वेदी की नींव पर डालना चाहिए। वह वेदी मिलापवाले तम्बू के द्वार पर है। ");
INSERT INTO hin2010_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","तब याजक को पशु की सारी चर्बी निकाल लेनी चाहिए और उसे वेदी पर जलाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","वह बछड़े के साथ वैसा ही करेगा जैसा उसने पापबलि के रूप में चढ़ाये गए बछड़े के साथ किया था। इस प्रकार याजक लोगों के पाप का भुगतान करता है, इससे यहोवा इस्राएल के लोगों को क्षमा कर देगा। ");
INSERT INTO hin2010_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","याजक डेरे के बाहर बछड़े को ले जाएगा और उसे वहाँ जलाएगा। यह पहले के समान होगा। यह पूरे समाज के लिए पापबलि होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“हो सकता है किसी शासक से संयोगवश, कोई ऐसी बात हो जो जिसे उसके परमेश्वर यहोवा ने न करने का आदेश दिया है, तो यह शासक दोषी होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","यदि उसे इस पाप का पता चलता है तब उसे एक ऐसा बकरा लाना चाहिए जिसमें कोई कोई दोष न हो। यही उसकी भेंट होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","शासक को बकरे के सिर पर हाथ रखना चाहिए और उसे उस स्थान पर मारना चाहिए जहाँ वे होमबलि को यहोवा केसामने मारते हैं। बकरा पापबलि है। ");
INSERT INTO hin2010_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","याजक को पापबलि का कुछ खून अपनी ऊँगली पर लेना चाहिए। याजक होमबलि की वेदी के सिरे पर खून छिड़केगा। याजक को बाकी खून होमबलि की वेदी की नींव पर डालना चाहिए ");
INSERT INTO hin2010_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","और याजक को बकरे की सारी चर्बी वैदी पर जलानी चाहिए। इसे उसी प्रकार जलाना चाहिए जिस प्रकार वह मेलबलि की चर्बी को जलाता है। इस प्रकार वह मेलबलि की चर्बी को जलाता है। इस प्रकार याजक शासक के पाप का भुगतान करता है और यहोवा शासक को क्षमा करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“हो सकता है कि साधारण जनता में से किसी व्यक्ति से संयोगवश कोई एसी बात हो जाए जिसे यहोवा ने न करने का आदेश दिया है। ");
INSERT INTO hin2010_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","यदि उस व्यक्ति को अपने पाप का पता चले तो वह एक बकरी लाए जिसमें कोई दोष न हो। यह उस व्यक्ति की भेंट होगी। वह इस बकरी को उस पाप के लिए लाए जो उसने किया है। ");
INSERT INTO hin2010_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","उसे अपना हाथ पशु के सिर पर रखना चाहिए और होमबलि के स्थान पर उसे मारना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","तब याजक को उस बकरी का कुछ खून अपनी उँगली पर लेना चाहिए और होमबतलि की वेदी के सिरे पर डालना चाहिए। याजक को वेदी की नींव पर बकरी का सारा खून उँडेलना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","तब याजक को बकरी की सारी चर्बी उसी प्रकार निकालनी चाहिए जिस प्रकार मलेबलि से चर्बी निकाली जाती है। याजक को इसे यहोवा के लिये सुगन्धि धूप की वेदी पर जलाना चाहिए। इस प्रकार याजक उस व्यक्ति के पापों का भुगतान कर देगा और यहोवा उस व्यक्ति को क्षमा कर देगा। ");
INSERT INTO hin2010_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“यदि यह व्यक्ति पापबलि के रूप में एक मेमने को लाता है तो उसे एक मादा मेमना लानी चाहिए जिसमें कोई दोष न हो। ");
INSERT INTO hin2010_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","व्यक्ति को उसके सिर पर हाथ रखना चाहिए और उसे उस स्थान पर पापबलि के रूप में मारना चाहिए जहाँ वे होमबलि के पशु को मारते हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","याजक को अपनी ऊँगली पर पापबलि का खून लेना चाहिए और इसे होमबलि की वेदी के सिरे पर डालना चाहिए। तब उसे मेमने के सारे खून को वेदी की नींव पर उँडेलना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","याजक को मेमने की सारी चर्बी उसी प्रकार लेनी चाहिए जिस प्रकार मेलबलि के मेमने की चर्बी ली जाती है। याजक को यहोवा के लिए आग द्वारा दी जाने वाली भेंटों के समान ही वेदी पर इन टुकड़ों को जलाना चाहिए। इस प्रकार याजक उस व्यक्ति के पापों का भुगतान करेगा और यहोवा उस व्यक्ति को क्षमा कर देगा। ");
INSERT INTO hin2010_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“यदि कोई व्यक्ति न्यायालय में गवाही देने के लिए बुलाया जाता है या सुना है, उसे नहीं बताता तो वह पाप करता है। उसे उसके अपराध के लिए अवश्य ही दण्ड भोगना होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“अथवा कोई व्यक्ति किसी ऐसी चीज को छूता है जो अशुद्ध है जैसे अशुद्ध जंगली जानवर का शव या अशुद्ध मवेशी का शव अथवा रेंगने वाले किसी अशुद्ध जन्तु का शव और उस व्यक्ति को इसका पता भी नहीं चलता कि उसने उन चीजों को छुआ है, तो भी वह बुरा करने का दोषी होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“किसी भी व्यक्ति से बहुत सी ऐसी चीज़ें निकलती है जो शुद्ध नहीं होती। कोई व्यक्ति इनमें से दूसरे व्यक्ति की किसी भी अशुद्ध वस्तु को अनजाने में ही छू लेता है तब वह दोषी होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“अथवा ऐसा हो सकता है कि कोई व्यक्ति अच्छा या बुरा करने का जल्दी मं वचन दे देता हैं। लोग बहुत प्रकार के वचन जल्दी में वचन दे देते हैं। यदि कोई व्यक्ति ऐसा वजन दे देता है और उसे भूल जाता है तो वह अपराधी है और जब उसे अपना वचन याद आता है तब भी वह अपराधी है। ");
INSERT INTO hin2010_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","अत: यदि वह इनमें से किसी का दोषी है तो उसे अपनी बुराई स्वीकार करनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","उसे परमेश्वर को अनपे किए हुए पाप के लिए दोषबलि लानी चाहिए। उसे दोषबलि के रूप में अपनी रेवड़ से एक मादा जानवर लाना चाहिए। यह मेमना या बकरी हो सकता है। तब याजक वह कार्य करेगा जिससे उस व्यक्ति के पाप का भुगतान होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“यदि कोई व्यक्ति मेमना भेंट करने में असमर्थ है तो उसे दो फ़ाख्ता या कबूतर के दो बच्चे यहोवा को भेंट में देना चाहिए। यह उसके पाप के लिए दोषबलि होगी। एक पक्षी दोषबलि के लिए होना चाहिए तथा दूसरा होमबलि के लिए होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","उस व्यक्ति को चाहिए कि वह उन पक्षियों को याजक के पास लाए। पहले याजक को दोषबलि के रूप में एक पक्षी को चढ़ाना चाहिए। याजक पक्षी की गर्दन को मोड़ देगा। किन्तु याजक पक्षी को दो भागों में नहीं बाँटेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","तब याजक को दोषबलि के खून को वेदी के सिरों पर डालना चाहिए। तब याजक को बचा हुआ खून वेदी की नींव पर डालना चाहिए। यह दोषबलि है। ");
INSERT INTO hin2010_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","तब याजक को नियम के अनुसार होमबलि के रूप में दूसरे पक्षी की भेंट चढ़ानी चाहिए। इस प्रकार याजक उस व्यक्ति के अपराधों का भुगतान देगा। और परमेश्वर उस व्यक्ति को क्षमा करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“यदि कोई व्यक्ति दो फाख्ता या दो कबूतर भेंट चढ़ाने में असमर्थ हो तो उसे एपा का दसवाँ भाग महीन आटा लाना चाहिए। यह उसकी दोषबलि होगी। उस व्यक्ति को आटे पर तेल नहीं डालना चाहिए। उसे इस पर लोबान नहीं रखना चाहिए क्यों यह दोषबलि है। ");
INSERT INTO hin2010_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","व्यक्ति को आटा याजक के पास लाना चाहिए। याजक इसमें से मुट्ठी भर आटा निकालेगा। यह स्मृति भेंट होगी। याजक यहोवा को आग द्वारा दी गई भेंट पर वेदी के ऊपर आटे को जलाएगा। यह दोषबलि है। ");
INSERT INTO hin2010_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","इस प्रकार याजक व्यक्ति के अपराधों के लिए भुगतान करेगा और यहोवा उस व्यक्ति को क्षमा करेगा। बची हुई दोषबलि याजक की वैसे ही होगी जैसे अन्नबलि होती है।” ");
INSERT INTO hin2010_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“कोई व्यक्ति यहोवा की पवित्र वस्तुओं के प्रति अकस्मात् कोई गलती कर सकता है। तो उस व्यक्ति को एक दोष रहित मेढ़ा लाना चाहिए। यह मेढ़ा यहोवा के लिए उसकी दोषबलि होगी। तुम्हें उस मेढ़े का मुल्य निर्धारित करने के लिए अधिकृत मानक का प्रयोग करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","उस व्यक्ति को पवित्र चीजों के विपरीत किये गये पाप के लिए भुगतान अवश्य करना चाहिए। जिन चीज़ों का उसने वायदा किया है, वे अवश्य देनी चाहिए। उसे मूल्य में पाँचवाँ भाग जोड़ना चाहिए। उसे यह धन याजक को देना चाहिए। इस प्रकार याजक दोषबलि के मेढ़े द्वारा उस व्यक्ति के पाप को धोएगा और यहोवा उसके पाप को क्षमा करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“यदि कोई व्यक्ति पाप करता है और जिन चीजों को न करने का आदेश यहोवा ने दिया है। उन्हें करता हो इस बात का कोई महत्व नहीं कि वह इसे नहीं जानता । वह व्यक्ति अपराधी है और उसे अपने पाप का फल भोगना होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","उस व्यक्ति को एक निर्दोष मेढ़ा अपनी रेवड़ से याजक के पास लाना चाहिए। मेढ़ा दोषबलि होगा। इस प्रकार याजक उस व्यक्ति के उस पाप का भुगतान करेगा जिसे उसने अनजाने में किया। यहोवा उस व्यक्ति को क्षमा करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","व्यक्ति अपराधी हो चाहे वह यह न जानता हो कि वह पाप कर रहा है। इसलिए उसे यहोवा को दोषबलि देना होगी।” ");
INSERT INTO hin2010_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“कोई व्यक्ति यहोवा के प्रति इनमें से किसी एक को करके अपराध कर सकता है: वह किसी अन्य के लिए जिसकी वह देखभाल कर रहा हो, उसे कुछ होने के बारे में झूठ बोल सकता है, अथवा कोई व्यक्ति अपने दिए वचन के बारे में झूठ बोल सकता है, अथवा कोई व्यक्ति कुछ चुरा सकता है, या कोई व्यक्ति किसी को ठग सकता है, ");
INSERT INTO hin2010_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","अथवा किसी को कोई खोई चीज मिले और तब वह उसके विषय में झूठ बोल सकता है या कोई व्यक्ति कुछ करने का वचन दे सकता हे और तब अपने दिये गे वचन को पूरा नहीं करता है, अथवा कोई कुछ अन्य बुरा कर सकता हे। ");
INSERT INTO hin2010_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","यदि कोई व्यक्ति इनमें से किसी को करता है तो वह पाप करने का दोषी है। उस व्यक्ति को जो कुछ उसने चुराया हो या ठगकर जो कुछ लिया हो या किसी व्यक्ति के कहने से उसकी धरोहर के रूप में जो रखा हो, या किसी का खोया हुआ पाकर उसके बारे में झुठ बोला हो ");
INSERT INTO hin2010_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","या जिस किसी के बारे में झुठा वचन दिया हो, वह उसे लौटान चाहिए। उसे पूरा मूल्य चुकाना चाहिए और तब उसे वस्तु के मूल्य का पाँचवाँ हिस्सा अतिरिक्त देना चाहिए। उसे असली मालिक को धन देना चाहिए। उसे यह उसी दिन करना चाहिए जि दिन वह दोषबलि लाए। ");
INSERT INTO hin2010_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","उस व्यक्ति को दोषबलि याजक के पास लाना चाहे। यह रेवड़ से एक मेढ़ा होना चाहिए। मेढ़े में कोई दोष नहीं होना चाहिए। यह उसी मूल्य का होना चाहिए जो याजक कहे। यह यहोवा को दी गी दोषबलि होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","तब याजक यहोवा के पास जाएगा और उस व्यक्ति के उन पापों के लिए भुगतान करेगा जिनका वह अपराधी है, और यहोवा उस व्यक्ति को उन पापों के लिए क्षमा करेगा जिन्होंने उसे अपराधी बनाया।” ");
INSERT INTO hin2010_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“हारून और उसके पुत्रों को यह आदेश दोः यह होमबलि का नियम है। होमबलि को वेदी के अग्नि कुण्ड में पूरी रात सवेरा होने तक रखना चाहिए। वेदी की आग को वेदी पर जलती रहनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","याजक को सन के उत्तम रेशों के बने वस्त्र पहनने चाहिए। उसे अपने शरीर से चिपका सन का अर्न्तवस्त्र पहनना चाहिए। तब याजक को वेदी पर होमबलि पर जलने के बाद बची हुई राख को उठाना चाहिए। याजक को वेदी की एक ओर राख को रखना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","तब याजक को अपने वस्त्रों को उतारना चाहिए और अन्य वस्त्र पहनने चाहिए। तब उसे डेरे से बाहर स्वच्छ स्थान पर राख ले जानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","किन्तु वेदी की आग वेदी में जलती रहनी चाहिए। इसे बुझने नहीं देना चाहिए। याजक को हर सुबह वेदी पर लकड़ी जलानी चाहिए। उसे वेदी पर लकड़ी रखनी चाहिए। उसे मेलबलि की चर्बी जलानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","वेदी पर आग लगातार जलती रहनी चाहिए। यह बुझनी नहीं चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“अन्नबलि का यह नियम है कि: हारून के पुत्रों को वेदी के समने यहोवा के लिए इसे लाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","याजक को अन्नबलि में से मुट्ठी भर उत्तम आटा लेना चाहिए। तेल और लोबान अन्नबलि पर अवश्य होना चाहिए। याजक को अन्नबलि को वेदी पर जलाना चाहिए। यह यहोवा को एक सुगन्धित और स्मृति भेंट होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","“हारून और उसके पुत्रों को बची हुई अन्नबलि को खाना चाहिए। अन्नबलि एक प्रकार की अख़मीरी रोटी की भेंट है। याजक को इस रोटी को पवित्र स्थान में खाना चाहिए। उन्हें मिलापवाले तम्बू के आँगन में अन्नबलि खानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","अन्नबलि खमीर के साथ नहीं पकाई जानी चाहिए। मुझको (यहोवा को) आग द्वारा दी जाने वली बलि में से उनके (याजकों के) भाग के रूप में मैंने इसे दिया है। यह पापबलि तथा दोषबलि के समान अत्यन्त पवित्र है। ");
INSERT INTO hin2010_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","हारून की सन्तानों में से हर एक लड़का आग द्वारा यहोवा को चड़ाई गई भेंट में से खा सकता है। यह तुम्हारी पीढ़ीयों का सदा के लिए नियम है। इन बलियों का स्पर्श उन व्यक्तियों को पवित्र करता है।” ");
INSERT INTO hin2010_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“हारून तथा उसेक पुत्रों को जो बलि यहोवा को लानी चाहिए, वह यह है। उन्हें यह उस दिन करना चाहिए जिस दिन हारून का अभिषेक हुआ है। उन्हें सदा दो क्वार्ट उत्तम महीन आटा अन्नबलि के लिए लेना चाहिए। उन्हें इसका आधा प्रातः काल तथा आधा सन्ध्या काल में लाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","उत्तम महीन आटे में तेल मिलाना चाहिए और उसे कड़ाही में भूनना चाहिए। जब यह भून जाए तब इसे अन्दर लाना चाहिए। तुम्हें अन्नबलि का चूरमा बना लेना चाहिए। इस की सुगन्ध यहोवा को प्रसन्न करेगी। ");
INSERT INTO hin2010_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","“हारून के वंश में से वह याजक जिसका हारून के स्थान पर अभिषेक हो, यहोवा को यह अन्नबलि चढ़ाए। यह नियम सदा के लिए है। यहोवा के लिए अन्नबलि पूरी तरह जलाई जानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","जाजक की हर एक अन्नबलि पूरी तरह जलाई जानी चाहिए। इस खाना नहीं चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“हारून और उसके पुत्रों से कहो: पापबलि के लिए यह नियम है कि पापबलि को भी वहीं मारा जाना चाहिए जहाँ यहोवा के सामने होमबलि को मार जाता है। यह अत्यन्त पवित्र है। ");
INSERT INTO hin2010_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","उस याजक को इसे खाना चाहिए, जो पापबलि चढ़ाता है। उसे पवित्र स्थान पर मिलापवाले तमबू के आँगन में इसे खाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","पापबलि के माँस का स्पर्श किसी भी व्यक्ति को पवित्र करता है। “यदि छिड़का हुआ खून किसी के वस्त्रों पर पड़ता है तो उन वस्त्रों को धो दिया जाना चाहिए। तुम्हें उन वस्त्रों को एक निश्चित पवित्र स्थान में धोना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","यदि पापबलि किसी मिट्टी के बर्तन में उबाली जाए तो उस बर्तन को फोड़ देना चाहिए। यदि पापबलि को काँसे के बर्तन में उबाला जाय तो बर्तन को माँजा जाए और पानी में उबाला जाय तो बर्तन को माँजा जाए और पानी में धोया जाए। ");
INSERT INTO hin2010_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","“परिवार का प्रत्येक पुरुष सदस्य याजक, पापबलि को खा सकात है। यह अत्यन्त पवित्र है। ");
INSERT INTO hin2010_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","किन्तु यदि पापबलि का खून पवित्र स्थान को शुद्ध करे के लिए मिलापवाले तम्बू में ले जाया गया हो तो पापबलि को आग में जला देना चाहिए। याजक उस पापबलि को नहीं खा सकते।” ");
INSERT INTO hin2010_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“दोषबलि के लिए यह नियम है। यह अत्यन पवित्र है। ");
INSERT INTO hin2010_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","याजक को दोष बलि को उसी स्थान पर मारना चाहिए जिस पर वह होमबलियों को मारता है। याजक को दोषबलि में से वेदी के चारों ओर खून छिड़कना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","“याजक को दोषबलि की सारी चर्बी चढ़ानी चाहिए। उसे चर्बी भरी पुँछ, भीतरी भागों को ढकने वाली चर्बी, ");
INSERT INTO hin2010_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","दोनों गुर्दे और उनके ऊपर की चर्बी, पुट्ठो की चर्बी, और कलेजे की चर्बी चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","याजक को वेदी पर उन सभी चीजों को जलाना चाहिए। ये यहोवा को आग द्वारा दी गई बलि होगी। यह दोषबलि है। ");
INSERT INTO hin2010_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","“हर एक पुरुष जो याजक है, दोषबलि खा सकता है। यह बहुत पवित्र है। अत: इसे एक निश्चित पवित्र स्थान में खआना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","दोषबलि पापबलि के समान है। दोनों के लिए एक जैसे नियम हैं। वह याजक, जो बलि चढ़ाता है, उसको वह प्राप्त करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","वह याजक जो बलि चढ़ाता है चमड़ा भी होमबलि से ले सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","हर एक अन्नबलि चढ़ाने वाले याजक की होती है। याजक उन अन्नबलियों को लेगा जो चूल्हे में पकी हों, या कड़ाही में पकी हों या तवे पर पकी हों। ");
INSERT INTO hin2010_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","अन्नबलि हारुन के पुत्रों की होगी। उससे कोई अन्तर नहीं पड़ेगा कि वे सूखी अथवा तेल मिली हैं। हारून के पुत्र याजक समान भागीदार होंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ये मेलबलि के नियम हैं, जिसे कोई व्यक्ति यहोवा को चढ़ाता हैः ");
INSERT INTO hin2010_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","कोई व्यक्ति मेलबलि अपनी कृतज्ञता प्रकट करने लिए ला सकता है। यदि वह कृतज्ञता प्रकट करने के लिए बलि लाता है तो उसे तेल मिले अखमीरी फुलके, अखमीरी चपातियाँ और तेल मिले उत्तम आटे के फुलके भी लाने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","उस व्यक्ति को अनपी मेलबलि के लिए खमीरी रोटियों के साथ अपनी बलि लानी चाहिए। यह वह बलि है जिसे कोई व्यक्ति यहोवा के प्रति कृतज्ञता दर्शाने के लिए लाता है। ");
INSERT INTO hin2010_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","उन रोटियों में से एक उस याजक की होगी जो मेलबलि के खून को छिड़कता है। ");
INSERT INTO hin2010_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","इस मेलबलि का माँस उसी दिन खाया जाना चाहिए जिस दिन यह चढ़ाया जाए। कोई व्यक्ति परमेश्वर के प्रति कृतज्ञता प्रकट करने के लिए यह भेंट चढ़ाता है। किन्तु कुछ भी माँस अगले दिन के लिए नहीं बचना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“कोई व्यक्ति मेलबलि यहोवा को केवल भेंट चढ़ाने की इच्छा से ला सकता हे अथवा सम्भवत: उस व्यक्ति ने यहोवा को विशेष वचन दिया हो। यदि यह सत्य है तो बलि उसी दिन खायी जानी चाहिए जिस दिन वब उसे चढ़ाये। यदि कुछ बच जाए तो उसे अगले दिन खा लेना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","किन्तु यदि इस बलि का कुछ माँस फिर भी तीसरे दिन के लिए बच जाए तो उसे आग में जला दिया जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","यदि कोई व्यक्ति मेलबलि का माँस तीसरे दिन खाता है तो यहोवा उस व्यक्ति से प्रसन्न नहीं होगा। यहोवा उस बलि को उसके लिए महत्व नहीं देगा। यह बलि घृणित वस्तु बन जाएगी औ यदि कोई व्यक्ति उस माँस का कुछ भी खाता है तो वह अपने पाप के लिए उत्तरदायी होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“लोगों को ऐसा माँस भी नहीं खाना चाहिए जिसे कोई अशुद्ध वस्तु छू ले। उन्हें इस माँस को आग में जला देना चाहिए। वे सभी व्यक्ति जो शुद्ध हों, मेलबलि का माँस खा सकते हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","किन्तु यदि कोई व्यक्ति अपवित्र हो और यहोवा के लिए मेलबलि में से कुछ माँस खा ले तो उस व्यक्ति को उस के लोगों से अलग कर देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“सम्भव है कि कोई व्यक्ति कोई ऐसी चीज छू ले जो अशुद्ध है। यह चीज लोगों द्वार या गन्दे जानवर द्वारा या किसी घृणित गन्दी चीज़ द्वारा अशुद्ध बनाई जा सकती है। वह व्यक्ति अशुद्ध हो जाएगा और यदि वह यहोवा के लिए मेलबलि से कुछ माँस खा ले तो उस व्यक्ति को उसके लोगों से अलग कर देना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“इस्राएल के लोगों से कहोः तुम लोगों को गाय, भेड़ और बकरी की चर्बी नहीं खानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","तुम उस जानवर की चर्बी का प्रयोग कर सकते हो जो स्वतः मरा हो या अन्य जानवरों द्वारा फाड़ दिया गया हो। किन्तु तुम उस जानवर को कभी नहीं खाना। ");
INSERT INTO hin2010_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","यदि कोई व्यक्ति उस जानवर की चर्बी खाता है जो यहोवा को आग द्वारा भेंट चढ़ाया गया हो तो उस व्यक्ति को उस के लोगों से अलग कर दिया जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","“तुम चाहे जहाँ भी रहो, तुम्हें किसी पक्षी या जानवर का खून कभी नहीं खाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","यदि कोई व्यक्ति कुछ खून खाता है तो उस व्यक्ति को उस के लोगों से अलग कर दिया जाना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“इस्राएल के लोगों से कहोः यदि कोई व्यक्ति यहोवा को मेलबलि लाए तो उस व्यक्ति को उस भेंट का एक भाग यहोवा को देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","भेंट का वह भाग आग में जलाया जाएगा। उसे उस भेंट का वह भाग अपने हाथ में लेकर चलना चाहिए। उसे जानवर की छाती की चर्बी लेकर चलना चाहिए और छाती को याजक के पास ले जाना चाहिए। छाती को यहोवा के सामने ऊपर उठाया जायेगा। यह उत्तोलन बलि होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","तब याजक को वेदी पर चर्बी जलानी चाहिए। किन्तु जानवर की छाती हारून और उसके पुत्रों की होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","मेलबलि से दायीं जांघ हारून के पुत्रों में से याजक को देनी चाहिये। ");
INSERT INTO hin2010_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","मेलबलि में से दायीं जांघ उस याजक की होगी जो मेलबलि की चर्बी और खून चढ़ाता है। ");
INSERT INTO hin2010_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","में(यहोवा) उत्तोलन बलि की छाती तथा मेलबलि की दायीं जांघ इस्राएल के लोगों से ले रहा हूँ और में उन चीजों को हारून और उसके पुत्रों को दे रहा हूँ। इस्राएल के लोगों के लिए यह नियम सदा के लिए होगा।” ");
INSERT INTO hin2010_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","यहोवा को आग द्वारा दी गी भेंट हारून और उसके पुत्रों की है, जब कभी हारून और उसके पुत्र यहोवा के याजक के रूप में सेवा करते हैं तब वे बलि का वह भाग पाते हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","जिस समय यहोवा ने याजकों का अभीषेक किया उसी समय उन्होंने इस्राएल के लोगों को वे भाग याजकों को देने का आदेश दिया। वे भाग सदा उनकी पीढ़ी याकों को दिए जाने हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ये होमबलि, अन्नबलि, पापबलि, दोषबलि, याजकों की नियुक्ति, और मेलबलि के नियम हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","यहोवा ने सीनै पर्वत पर ये नियम मूसा क दिए। यहोवा ने ये नियम उस दिन दिए जिस दिन उसने इस्राएल के लोगों को सीनै मरुभूमि में यहोवा के लिए अपनी भेंट लाने का आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“हारून और उसके साथ उके पुत्रों, उनके वस्त्र, अभिषेक का तेल, पापबलि का बैल, दो भेड़ें और अखमीरी मैदे के फुलके की टोकरी लो, ");
INSERT INTO hin2010_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","तब मिलापवाले तम्बू के द्वार पर लोगों को एक साथ लाओ।” ");
INSERT INTO hin2010_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","मूसा ने वही किया जो यहोवा ने उसे आदेश दिया। लोगो मिलापवाले तम्बू के द्वार पर एक साथ मिले। ");
INSERT INTO hin2010_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","तब मूसा ने लोगों से कहा, “यह वही है जोसे करने का आदेश यहोवा ने दिया है।” ");
INSERT INTO hin2010_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","तब मूसा, हारून और उसके पुत्रों को लाया। उसने उन्हें पानी से नहलया। ");
INSERT INTO hin2010_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","तब मूसा ने हारून को अन्तःवस्त्र पहनाया। मूसा ने हारून के चारों ओर एक पेटी बाँधी। तब मूसा ने हारून को बाहरी लबादा पहनाया। इसके ऊपर मूसा ने हारुन को चोगा पहनाया और उस पर एपोद पहनाई, फिर उस पर सुन्दर पटुका बाँधा। ");
INSERT INTO hin2010_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","तब मूसा ने न्याया की थैली की जेब में ऊरीम औ तुम्मीम रखा। ");
INSERT INTO hin2010_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","मूसा ने हारून के सिर पर पगड़ी भी बाँधी। मूसा ने इस पगड़ी के अगले भाग पर सोने की पट्टी पवित्र मुकुट के समान है। मूसा ने यह यहोवा के आदेश के अनुसार किया। ");
INSERT INTO hin2010_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","तब मूसा ने अभिषक का तेल लिया और पवित्र तम्बू तथा इसमें की सभी चीजों पर छिड़का। इसप्रकार मूसा ने उन्हें पवित्र किया। ");
INSERT INTO hin2010_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","मूसा ने अभिषेक का कुछ तेल वेदी पर सात बार छिड़का। मूसा ने वेदी, उसके उपकरणों और तश्तरियों का अभिषेक किया। मूसा ने बड़ी चिलमची और उसके आधार पर भी अभिषेक का तेल छिड़का। इस प्रकार मूसा ने उन्हें पवित्र किया। ");
INSERT INTO hin2010_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","तब मूसा ने अभिषेक के कुछ तेल को हारून के सिर पर डाला। इस प्रकार उसने हारून को पवित्र किया। ");
INSERT INTO hin2010_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","तब मूसा हारून के पुत्रों को लाया और उन्हें विशेष वस्त्र पहनाए। उसने उन्हें पटुके पेटियाँ बाँधे। तब उसने उन के सिर पर पगड़ियाँ बाँधी। मूसा ने ये सब वैसे ही किया जैसे यहोवा ने आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","तब मूसा पापबलि के बैल को लाया। हारून औ उसके पुत्रों ने अपने हातों को पापबलि के बैल के सिर पर रखा। ");
INSERT INTO hin2010_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","तब मूसा ने बैल को मारा। मूसा ने उसेक खून को लिया। मूसा ने अपनी ऊँगली का उपयोग किया और कुछ खून वेदी पर के सभी कोनों पर छिड़का। इस प्रकार मूसा ने वेदी को बलि के लिए शुद्ध किया। तब मूसा ने वेदी की नींव पर खून को उँडेला। इस प्रकार मूसा ने वेदी को लोगों के पापों के भुगतान के लिए पाप बलियों के लिए तैयार किया। ");
INSERT INTO hin2010_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","मूसा ने बैल के भीतरी भागों से सारी चर्बी ली। मूसा ने दोनों गुर्दे और उनेक ऊपर की चर्बी के साथ कलेजे को ढकने वाली चर्बी ली। तब उसने उन्हें बेदी पर जलाया। ");
INSERT INTO hin2010_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","किन्तु मूसा बैल के चमड़े, उसके माँस और शरीर के वयर्थ भीतरी भाग रको डेरे के बाहर ले गया। मूसा ने डेरे के बाहर आग में उन चीजों को जलाया। मूसा ने ये सब बैसा ही किया जैसा यहोवा ने आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","मूसा होमबलि के मेढ़े को लाया। हारून और उसके पुत्रों ने अपने हाथ मेढ़े के सिर पर रखे। ");
INSERT INTO hin2010_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","तब मूसा ने मेढ़े को मार। उसने वेदी के चारों और खून छिड़का । ");
INSERT INTO hin2010_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","मूसा ने मेढ़े को टुकड़ों में काटा। मूसा ने भीतरी भागों और पैरों को पानी से धोया। तब मूसा ने पूरे मेढ़े को वेदी पर जलाया।मूसा ने उसका सिर, टुकड़े औ चर्बी को जलाया। यह आग द्वारा होमबलि थी। यह यहोवा के लिए सुगन्ध थी। मूसा ने यहोवा के आदेश के अनुसार वे सबकाम किए। ");
INSERT INTO hin2010_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","तब मूसा दूसरे मेढ़े को लाया। इस मेढ़े का उपयोग हारून और उसके पुत्रों को याजक बनाने के लिए किया गाय। हारून और उसके पुत्रों ने अनपे हाथ मेढ़े के सिर पर रखे। ");
INSERT INTO hin2010_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","तब मूसा ने मेढ़े को मारा। उसने इसका कुछ खून हारून के कान के निचले सिरे पर, दाएं हाथ के अंगूठे पर और हारून के दाएं पैर के अंगूठे पर लगाया। ");
INSERT INTO hin2010_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","तब मूसा हारून के पुत्रों को वेदी के पास लाया। मूसा ने कुछ खून उनके दाएं कान के निचले सिरे पर, दाएं हाथ के अंगूठे पर और उनके दाएं पैर के अंगूठों पर लगाया। तब मूसा ने वेदी के चारों ओर खून डाला। ");
INSERT INTO hin2010_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","मूसा ने चर्बी और भरी पूँछ, भीतरी भाग की सारी चर्बी कलेजे को ढकेने वाली चर्बी, दोनों गुर्दे और उनकी चर्बी और दायीं जाँघ को लिया। ");
INSERT INTO hin2010_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","एक टोकरी अखमीरी मैदे के फुलके हर एक दिन यहोवा के सामने रखी जाती हैं। मूसा ने उन फुलकियों में से एक रोटी, और एक तेल से सनी फुलकी, और एक अखमीरी चपाती ली। मूसा ने उन फुलकियों के टुकड़ो को चर्बी तथा मेढ़े की दायीं जाँघ पर रखा। ");
INSERT INTO hin2010_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","तब मूसा ने उन सभी को हारून और उके पुत्रों के हाथों में रखा। मूसा ने उन टुकड़ों को यहोवा के सामने उत्तोन बलि के रूप मे हाथों में ऊपर उठवाया। ");
INSERT INTO hin2010_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","तब मूसा ने इन चीजों को हारून और उसके पुत्रों के हाथों से लिया। मूसा ने उन्हें वेदी पर होमबली के ऊपर जलाया। इस प्रकार वह बलि हारून और उसके पुत्रों को याजक नियुक्त करने के लिए थी। यह आग द्वारा दी गी बलि थी। यह यहोवा को प्रसन्न करने के लिए सुगन्ध थी। ");
INSERT INTO hin2010_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","तब मूसा ने उस मेढ़े की छाती को लिया और यहोवा के सामने उत्तोलन बलि के लिए ऊपर उठवाया। याजकों को नियुक्त करने के लिए यह मूसा के हिस्से का मेढ़ा था। यह ठीक वैसा ही था जैसा यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","मूसा ने अभिषेक का कुछ तेल और वेदी पर का कुछ खून लिया। मूसा ने उस में से थोड़ा हारून और उसके वस्त्रों पर छिड़का और कुछ हारुन के उन पुत्रों पर जो उसके साथ थे और कुछ उनके वस्त्रों पर छिड़का। इस प्रकार मूसा ने हारून, उसके वस्त्रों, उसके पुत्रों और उनके वस्त्रों को पवित्र बनाया। ");
INSERT INTO hin2010_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","तब मूसा ने हारून और उसके पुत्रों से कहा, “क्या तुम्हें मेरा आदेश याद है? मैंने कहा, ‘हारून और उसके पुत्र इन चीजों को खाएंगे।’ अत: याजक नियुक्ति संस्कार से रोटी की टोकरी और माँस लो। मिलापवाले तम्बू के द्वार पर उस माँस को उबालो। तुम उस माँस और उस रोटी को उसी स्थान पर खाओगे। ");
INSERT INTO hin2010_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","यदि कुछ मांस या रोटी बच जाए तो उसे जला देना। ");
INSERT INTO hin2010_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","याजक नियुक्ति संस्कार सात दिन तक चलेगा। तुम मिलापवाल तम्बू से तब तक नहीं जाओगे जब तक तुमहार याजक नियुक्ति संस्कार का समय पूरा नहीं हो जाता। ");
INSERT INTO hin2010_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","यहोवा ने उन कामों को करने का आदेश दिया था जो आज किए गए उन्होंने तुम्हारे पापों के भुगतान के लिए यह आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","तुम्हें मिलापवाले तम्बू के द्वार पर सात दिन तक, पूरे दिन रात रहना चाहिए। यदि तुम यहोवा का आदेश नहीं मानते हो तो तुम मर जाओगे। यहोवा ने मुझे ये आदेश दिया था।” ");
INSERT INTO hin2010_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","इसलिए हारून और उसके पुत्रों ने वह सब कुछ किया जिसे करने का आदेश यहोवा ने मूसा को दिया था। ");
INSERT INTO hin2010_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","आठवें दिन, मूसा ने हारून और उसके पुत्रों को बुलाया। उस ने इस्राएलके बुजुर्गों (नेताओं) को भी बुलाया। ");
INSERT INTO hin2010_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","मूसा ने हारून से कहा, “अपने पशूओं में से एक बछड़ा और एक मेढ़ा लो। इन जानवरों में कोई दोष नहीं होना चाहिए। बछड़ा पापबलि होगा और मेढ़ा होमबलि होगा। इन जानवरों को यहोवा को भेंट करो। ");
INSERT INTO hin2010_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","इस्राएल के लोगों से कहो, ‘पापबलि हेतु एक बकरा लो। एक बछड़ा और एक मेमना होमबलि के लिए लो। बछड़ा और मेमना दोनों एक वर्ष के होने चाहिए। इन जानवरों में कोई दोष नहीं होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","एक साँड और एक मेढ़ा मेलबलि के लिए लो। उन जानवरों को और तेल मिली अन्नबलि लो और उन्हें यहोवा को भेंट चढ़ाओ। क्यों? कियोंकि आज यहोवा की महिमा तुम्हारे सामने प्रकट होगी।’” ");
INSERT INTO hin2010_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","इसलिए सभई लोग मिलापवाले तम्बू में आए और वे सभई उन चीज़ों को लाए जिनके लिए मूसा ने आदेश दिया था। सभी लोग यहोवा के सामने खड़े हुए। ");
INSERT INTO hin2010_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","मूसा ने कहा, “तुमने वही किया है जो यहोवा ने आदेश दिया। तुन लोग यहोवा की महिमा देखोगे।” ");
INSERT INTO hin2010_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","तब मूसा ने हारून से ये बातें कहीं, “जाओ और वह करो जिसके लिए यहोवा ने आदेश दिया था। वेदी के पास जाओ और पापबलि तथा होमबलि चढ़ाओ। यह सब अपने और लोगों के पापों के भुगतान के लिए करो। तुम लोगों की लायी हुई बलि को लो औ उसे यहोवा को अर्पित करो। यह उनके पापों का भुगतान होगा।” ");
INSERT INTO hin2010_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","इसलिए हारून वेदी के पास गया। उसन बछड़े को पापबलि हेतु मारा। यह पापबलि स्वयं उसके अपने लिए थी। ");
INSERT INTO hin2010_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","तब हारून के पुत्र हारून के पास खून लाए। हारून ने अपनी उँगली खून में डाली और वेदी के सिरों पर इसे लगाया। तब हारून ने वेदी की नींव पर खून उँडेला। ");
INSERT INTO hin2010_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","हारून ने पापबलि से चर्बी, गुर्दे और कलेजे की चर्बी को लिया। उस ने उनहें वेदी पर जलाया। उसने उसी प्रकार किया जिस प्रकार यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","तब हारून ने डेरे के बाहर माँस और चमड़े को जलाया। ");
INSERT INTO hin2010_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","इसके बादस, हारून ने होमबलि के लिए उस जानवर को मार। जानवरको टुकड़ों में काटा गाय। हारून के पुत्र खून को हारून के पास लाए और हारून ने वेदी के चारों ओर खून डाला। ");
INSERT INTO hin2010_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","हारून के पुत्रों ने उन टुकड़ों और होमबलि का सिर हारून को दिया। तब हारून ने उन्हें वेदी पर जलाया। ");
INSERT INTO hin2010_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","हारून ने होमबलि के भीतरी भागों और पैरों को धोया और उसने उन्हें वेदी पर जलाया। ");
INSERT INTO hin2010_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","तब हारून लोगों की बलि लाया। उसने लोगों के लिए पापबलि वाले बकरे को मारा। उसने बकरे को पहले की तरह पापबलि के लिए चढ़ाया। ");
INSERT INTO hin2010_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","हारून होमबलि को लाया और उसने वह बलि चढ़ाई। वैसे ही जैसे यहोवा ने आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","हारून अन्नबलि को वेदी के पास लाया। उसने मुट्ठी भर अन्न लिया और प्रातः काल की नित्य बलि के साथ उसे वेदी पर रखा। ");
INSERT INTO hin2010_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","हारून ने लोगों के लिए मलेबलि के साँड और मेढ़े को मारा। हारून के पुत्र खून को हारून के पास लाए। हारून ने इस खून को वेदी के चारों ओर उँडेला। ");
INSERT INTO hin2010_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","हारून के पुत्र साँड और मेढ़े की चर्बी भी लाए। वे चर्बी भरी पूँछ, भीतरी भागों को ढकने वाली चर्बी, गुर्दे और कलेजे को ढकने वाली चर्बी भी लाए। ");
INSERT INTO hin2010_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","हारून के पुत्रों ने चर्बी के इन भागों को साँड और मेढ़े की छातियों पर रखा। हारून ने चर्बी के भागों को लेकर उसे वेदी पर जलाया। ");
INSERT INTO hin2010_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","मूसा के आदेश के अनुसार हारून ने छातियों और दायीं जाँघ को उत्तोलन भेंट के लिए यहोवा के सामने हाथों में ऊपर उठाया। ");
INSERT INTO hin2010_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","तब हारून ने अपने हाथ लोगों की ओर उठाए और उन्हें आशीर्वाद दिया। हारून पापबलि, होमबलि और मेलबलि को चढ़ाने के बाद वेदी से नीचे उतर आया। ");
INSERT INTO hin2010_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","मूसा और हारून मिलापवाले तम्बू में गए और फिर बाहर आकर उन्होंने लोगों के सामने तेज प्रकट हुआ। ");
INSERT INTO hin2010_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","यहोवा से अग्नि प्रकट हुई और उसने वेदी पर होमबलि और चर्बी को जलाया। सभी लोगों जब यह देखा तो वे चिल्लाया और उन्होंने धरती पर गिरकर प्रणाम किया। ");
INSERT INTO hin2010_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","फिर तभी हारून के पुत्रों नादाब और अबीहू ने पाप किया। दोनों पुत्रों ने लोबान जलाने के लिए तश्तरी ली। उन्होंने एक अलग ही आग का प्रयोग किया और लोबान को जलाया। उन्होंने उस आग का प्रयोग नहीं किया जिसके उपयोग का आदेश मूसा ने उन्हें दिया था। ");
INSERT INTO hin2010_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","इसलिए योहव से ज्वाला प्रकट हुई और उसने नादाब और अबीहू को नष्ट कर दीया। वे यहोवा के सामने मरे। ");
INSERT INTO hin2010_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","तब मूसा ने हारून से कहा, “यहोवा कहता है, ‘जो याजक मेरे पास आए, उन्हें मेरा सम्मान करना चाहिए! मैं उन के लिए और सब ही के लिये पवित्र माना जाऊँ।’” इसलिए हारून अनपे मरे हुए पुत्रों के लिए खामोश रहा। ");
INSERT INTO hin2010_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","हारून के चाचा उज्जीएल के दो पुत्र थे। वे मीशाएल और एलसाफान थे। मूसा ने उन पुत्रों से कहा, “पवित्र स्थान के सामने के भगा में जाओ। अपने चचेरे भाईयों के शवों को उठाओ और उन्हें डेरे के बाहर ले जाओ।” ");
INSERT INTO hin2010_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","इसलिए मीशाएल और इलसाफान ने मूसा का आदेश माना। वे नादाब और अबीहू के शवों को बाहर लाए। नादाब और अबीहू तब तक अपने विशेष अन्तःवस्त्र पहने थे। ");
INSERT INTO hin2010_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","तब मूसा ने हारून और उसके अन्य पुत्रों एलीआजार और ईतामार से बात की। मूसा ने उनसे कहा, “कोई शोक प्रकट न करो! अनपे वस्त्र न फाड़ो या अपने बालों को न बिखरो! शोक प्रकट न कोरो, तुम मरोगे नहीं और योहवा तुम सभी लोगों से अप्रसन्न नहीं होगा। इस्राएल का पूरा राष्ट्र तुम लोगों का सम्बन्धी है। वे यहोवा द्वारा नादाब और अबीहू के जलाने के विषय में रो पीट सकते हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","किन्तु तुम लोगों को मिलापवाले तम्बू भी नहीं छोड़ना चाहिए । यदि तुम लोग उस द्वार से बाहर जाओगे तो मर जाओगे। क्यों क्योंकि यहोवा के अभिष्क का तेल तुम ने लगा रखा है।” सो हारून एलीआजार और ईतामार ने मूसा की आज्ञा मानी। ");
INSERT INTO hin2010_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","तब योहा ने हारून से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“तुम्हें और तम्हारे पुत्रों को दाखमधु या मद्य उस समय नहीं पीनी चाहिए जब तुम लोग मिलापवाले तम्बू में आओ। यदि तुम ऐसा करोगे तो मर जाओगे! यह नयम तुम्हारी पीढ़ियों में सदा चलता रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","तुम्हें, जो चीज़ें पवित्र हैं तथा जो पवित्र नहीं हैं, जो शुद्ध हैं और जो शुद्ध नहीं हैं उनमें अन्तर करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","यहोवा ने मूसा को अपने नियम दिए और मूसा ने उन नियमों को लोगों को दिया। “हारून तुम्हें उन सभी नयमों की शिक्षा लोगों को देना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","अभी तक हारून के दो पुत्र एलीआज़ार और ईतामार जीवित थे। मूसा ने हारून और उके दोनों पुत्रों से बात की। मूसा ने कहा, “कुछ अन्नबलि उन बलियों में से बची है जो आग में जलाई गई थी। तुम लोग अन्नबलि का वह भाग खाओगे। किन्तु तुम लोगों को इसे बिना ख़मीर मिलाए खाना चाहिए। इसे वेदी के पास खाओ। क्यों क्योंकि वह बेट बहुत पवित्र है। ");
INSERT INTO hin2010_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","वह उस भेंट का भाग है, जो यहोवा के लिए आग में जलाई गई थी और जो नियम मैंने तुमको बताया, वह सिखाता है कि वह भाग तुम्हारा और तम्हारे पुत्रों का है। किन्तु तुम्हें इसे पवित्र स्थान पर ही खाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“तुम, तुम्हारे पुत्र और तुम्हारी पुत्रियों भी उत्तोलन बलि से छाती को औ मेलबलि से जाँघ को खा सकेंग। इन्हें तुम्हें किसी पवित्र स्थान पर नहीं खाना है। बल्कि तुम्हें इन्हें किसी शुद्ध स्थान पर खाना चाहिए। क्यों क्योंकि ये मेलबलियों में से मिली है। इस्रएल के लोग ये बलि यहोवा को देते हैं। उन जानवरों के कुछ भाग को लोग खाते हैं किन्तु छाती और जाँघ तुम्हारा भाग है। ");
INSERT INTO hin2010_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","लोगों को अपने जानवरों की चर्बी आग में जलाई जाने वाली बलि के रूप में लानी चाहिए। उसे यहोवा के सामने उत्तोलित करना होगा और यह बलि तुम्हारा भाग होगा। यह तुम्हारा और तुम्हारे बच्चों का होगा। योहवा के आदेश के अनुसार बलि का वह भाग सदा तुम्हारा होगा।” ");
INSERT INTO hin2010_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","मूसा ने पापबलि के बकरे के बारे में पूछा। किन्तु उसे पहले ही जला दिया गया था। मूसा हारून के शेष पुत्रों एलीआज़ार और ईतामार पर बहुत क्रोधित हुआ। मूसा ने कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“तुम लोगों कोस यह बकरा पवित्र स्थान पर खाना था। यह बहुत पवित्र है! तुम लोगों ने इसे यहोवा के सामने क्यों नहीं खाया? यहोवा ने उसे तुम लोगों के अपराधों को दूर करने के लिए दिया। वह बकरा लोगों के पापों के भुगतान के लिए था। ");
INSERT INTO hin2010_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","देखो! तुम उस बकरे का खून पवित्र स्थान के भीतर नहीं लाए। तुम्हें इस बकरे को पवित्र स्थान पर खाना था जैसा कि मैंने आदेश दिया है।” ");
INSERT INTO hin2010_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","किन्तु हारून ने मूसा से कहा, “सुनों, आज वे अपनी पापबलि और होमबलि यहोवा के सामने लाए। किन्तु तुम जानते हो कि आज मरे साथ क्या हुआ! क्या तुम यह समझते हो कि यदि मैं पापबलि को आज खाऊँगा तो यहोव प्रसन्न होगा? नहीं!” ");
INSERT INTO hin2010_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","जब मूसा ने यह सुना तो वह सहमत हो गया। ");
INSERT INTO hin2010_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“इस्राएल के लोगों से कहो: ये जानवर हैं जिन्हें तुम खा सकते हो: ");
INSERT INTO hin2010_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","यदि जानवर के खुर दो भागों में बँटे हों और वह जानवर जुगाली भी करता हो तो तुम उस जानवर का माँस खा सकते हो। ");
INSERT INTO hin2010_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","“कुछ जानवर जुगाली करते हैं, किन्तु उनके खुर फटे नहीं होते। तो ऐसे जानवरों को मत खाओ—ऊँट, शापान और खरगोश वैसे हैं, इसलिए वे तुम्हारे लिए अपवित्र हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","अन्य जानवर दो भागों में बँटी खुरों वाले हैं, किन्तु वे जुगाली नहीं करते। उन जानवरों को मत खाओ। सुअर बैसे ही हैं, अतः वे तुम्हारे लिए अशुद्ध हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","उन जानवरों का माँस मत खाओ! उनके शव को छूना भी मत वे तुम्हारे लिए अशुद्ध हैं! ");
INSERT INTO hin2010_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“यदि कोई जानवर समुद्र या नदी में रहता है और उसके पंख और परतें हैं तो तुम उस जानवर को खा सकते हो। ");
INSERT INTO hin2010_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","11","किन्तु यदि जानवर समुद्र या नदी में रहता है और उसके पंख और परतें नहीं होतीं तो उस जानवर को तुम्हें नहीं खाना चाहिए। वह गन्दे जानवरों में से एक हैं। उस जानवर का माँस मत खाओ। उसके शव को छूना भी मत! ");
INSERT INTO hin2010_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","तुम्हें पानी के हर एक जानवर को, जिसके पंख और परतें नहीं होतीं, उसे घिनौने जानवरों में समझना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“तुम्हें निम्न पक्षियों को भी घिनौने पक्षी समझना चाहिए। इन पक्षियों में से किसी को मत खाओ: उकाब, गिद्ध, शिकारी पक्षी, ");
INSERT INTO hin2010_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","चील, सभी प्रकार के बाज नामक पक्षी, ");
INSERT INTO hin2010_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","सभी प्रकार के काले पक्षी, ");
INSERT INTO hin2010_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","शुतुर्मुर्गु, सींग वाला उल्लू, समुद्री जलमुर्ग, सभी प्रकार के बाज, ");
INSERT INTO hin2010_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","उल्लू, समुद्री काग, बड़ उल्लू, ");
INSERT INTO hin2010_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","जलमुर्ग, मछली खानेवाले पेलिकन नामक खेत जलपक्षी, समुद्री गिद्ध, ");
INSERT INTO hin2010_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","हंस, सभी प्रकार के सारस, कठफोड़वा और चमगादड़। ");
INSERT INTO hin2010_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“और सभी ऐसे कीट पतंगे जिनके पंख होते हैं तथा जो रेंग कर चलते भी हैं। ये घिनौने कीट पतंगे हैं! ");
INSERT INTO hin2010_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","किन्तु यदि पतंगों के पंख हैं और वह रेंग कर चलता भी हो तथा उसके पैरों के ऊपर टांगों में ऐसे जोड़ हैं कि वब उछल सके तो तुम उन पतंगों को खा सते हो। ");
INSERT INTO hin2010_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ये पतंगे हैं जिनहें तुम खा सकते होः हर प्रकार की टिड्डियाँ, हर प्रकार की सपंख टिड्डियाँ, हर प्रकार के झींगुर हर प्रकार के टिड्डे। ");
INSERT INTO hin2010_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","“किन्तु अन्य सभी वे कीट पतंगे जनके पंख हैं और जो रेंग भी सकते हैं, तुम्हारे लिए घिनौने प्राणी हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","वे कीट पतंगे तुमको असुद्ध करेंगे। कोई व्यक्ति जो मरे कीट पतंगे को छूएगा, सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","यदि कोई मरे कीट पतंगें मे से किसी को उठाता है तो उस व्यक्ति को अपने कपड़े धो लेने चाहिए। वह व्यक्ति सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","27","“कुछ जानवरों के घुर फटे होते हैं किन्तु खुर के ठीक ठीक दो भाग नीहं होते। कुछ जानवर जुगाली नीं करते। कुछ जानवरों के घुर नहीं होते, वे अपने पंजों पर चलते हैं ऐसे सभी जानवर तुम्हारे लिए घनौने हैं। कोई व्यक्ति, जो उन्हें छूयेगा अशुद्ध हौ जाएगा। वह व्यक्ति सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","यदि कोई व्यक्ति उनके मरे शरीर को उठाता है तो उस व्यक्तति को अपने वस्त्र धोने चाहिए। वह व्यक्ति सन्ध्या तक अशुद्ध रहेगा। वे जानवर तुम्हारे लिए अशुद्ध है। ");
INSERT INTO hin2010_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ये रेंगने वाले जानवर तुम्हारे लिए घिनौने हैं: छछून्दर, चूहा, सभी प्रकार के बड़े गिरगिट, ");
INSERT INTO hin2010_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","छिपकली, मगरमच्छ, गिरगिट, रेगिस्तानी गोहेर, और रंग बदलता गिरगिट। ");
INSERT INTO hin2010_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ये रेंगने वाले जानवर तुम्हारे लिये घिनौने हैं। कोई व्यक्ति जो उन मरे हुओं को छूएगा सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","“यदि किसी घिनौने जानवरों में से कोई मरा हुआ जानवर किसी चीज़ पर गिरे तो वह चीज़ अशुद्ध हो जाएगी। यह लकड़ी, चमड़ा, कपड़ा, शोक वस्त्र या कोई भी औजार हो सकात है। जो कुछ भी वह हो उसे पानी से धोना चाहिए। यह सन्ध्या तक अशुद्ध रहेगा। तब यह फिर शुद्ध हो जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","यदि उन गन्दे जानवरों में से कोई मरा हुआ मिट्टी के कटोरे में गिरे तो कटोरे की कोई भी चीज़ अशुद्ध हो जाएगी। तुम्हें कटोरा अवश्य तोड़ देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","यदि अशुद्ध मिट्टी के कटोरे का पानी किसी भोजन पर पड़े तो भोजन अशुद्ध हो जाएगा। अपवित्र कटोरे में कोई भी दाखमधु अशुद्ध हो जाएगी। ");
INSERT INTO hin2010_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","यदि किसी मरे हुए घिनौने जानवर का कोई भाग किसी चीज़ पर आ पड़े तो वह चीज शुद्ध नहीं रहेगी। इसे टुकडे—टुकड़े कर दैने चाहिए। चाहे वह चूल्हा हो चाहे कड़ाही। वे तुम्हारे लिए सदा अशुद्ध रहेगी। ");
INSERT INTO hin2010_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","“कोई सोता या कुआँ जिसमें पानी रहता है, शुद्ध बना रहेगा किन्तु कोई व्यक्ति जो किसी मरे घिनौने जानवर को छूयेगा, अशुद्ध हो जाएगा ");
INSERT INTO hin2010_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","यदि उन घिनौने मरे जानवरों का कोई भाग बोए जाने वाले बीज पर आ पड़े तो भी वह शुद्ध ही रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","किन्तु भिगोने के लिए यदि तुम कुछ बीजों पर पानी डालेते हो और तब यदि मरे घिनौने जानवर का कोई भाग उन बीजों पर आ पड़े तो वे बीज तुम्हारे लिए अशुद्ध हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“और भी, यदि भोजन केलिए उपयुक्त कोई जानवर अपने आप मर जाए तो जो व्यक्ति उके मरे शरीर को छूयेगा, सन्ध्या तक अशुद्ध रहेगा ");
INSERT INTO hin2010_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","और उस व्यक्ति को अपने वस्त्र धोने चाहिए। जो उस मृत जानवर के शरीर का माँ खाए। वह व्यक्ति सन्ध्या तक अशुद्ध रहेगा। जो व्यक्ति मरे जानवर के शरीर को उठाएगा उसे भी अपने वस्त्रों को धोना चाहिए। यह व्यक्ति सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“हर एक ऐसा जानवर जो धरती पर रेंगता है, वो उन जानवरों में से एक है, जिसे यहोवा ने खाने को मना किया है। ");
INSERT INTO hin2010_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","तुम्हें ऐसे किसी भी रेंगने वाले जानवर को नहीं खाना चाहिए जो पेट के बल रेंगता है जै चारों पैरों पर चलता है, या जिसके बहुत से पैर हैं। ये तुम्हारे लिए घिनौने जानवर हैं! ");
INSERT INTO hin2010_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","उन घिनौने जानवरों से अपने को अशुद्ध मत बनाओ। तुम्हें उनके साथ अपने को अशुद्ध नहीं बनाना चाहिए! ");
INSERT INTO hin2010_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","क्यों क्योंकि में तुम्हारा परमेश्वर यहोवा हूँ! मैं पवित्र हूँ इसलिए तुम्हें अपने को पवित्र रखना चाहिए! उन घिनौने रेंगने वाले जानवरों से अपने को घोनौना न बनाओ! ");
INSERT INTO hin2010_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","मैं तुम लोगों को मिस्र से लाया। मैंने यह इसलिए किया कि तुम लोग मेरे विशेष जन बने रह सको। मैंने यह इसलिए किया कि मैं तुमहार परमेश्वर बन सकूँ। मैं पवित्र हूँ अतः तम्हें भी पवित्र रहना है!” ");
INSERT INTO hin2010_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","वे नियम सभी मवेशियों, पक्षियों और धरती के अन्य जानवरों के लिए हैं। वे नियम समुद्र में रहने वाले सभी जानवरों और धरती पर रेंगने वाले सभी जानवरों के लिए हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","वे उपदेश इसलिए हैं कि लोग शुद्ध जानवरों और घिनौने जानवरों में अन्तर कर सकें। इस, प्रकार लोग जानेंगे कि कौन सा जानवर खाने योग्य है और कौन सा खाने योग्य नहीं है। ");
INSERT INTO hin2010_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“इस्राएल के लोगों से कहोः “यदि कोई स्त्री एक लड़के को जन्म देती है तो वह स्त्री सात दिन तक अशुद्ध रहेगी। यह उसके रक्त स्राव के मासिकधर्म के समय अशुद्ध होने की तरह होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","आठवें दि लड़के का खतना होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","खून की हानि से उत्पन्न अशुद्धि से शुद्ध होने के तैंतीस दिन बाद तक यह होगा। उस स्त्री को वह कुछ नहीं छूना चाहिए जो पवित्र है। उसे पवित्र स्थान में तब तक नहीं जाना चाहिए जब तक उसके पवित्र होने कासमय पूरा न हो जाए। ");
INSERT INTO hin2010_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","किन्तु यदि स्त्री लड़की को जन्म देती है तो माँ रक्त स्राव के मासिक धर्म के समय की तरह दो स्पताह तक शुद्ध नहीं होगी। वह अपने खून की हानि के छियासठ दिन बाद शुद्ध हो जाती है। ");
INSERT INTO hin2010_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“नहीं मैं जिसने अभी लड़की या लड़के को जन्म दिया है, ऐसी माँ के शुद्ध होने का विशेष समय पूरा होने पर उसे मिलापवाले तम्बू में विशेष भेंटें लानी चाहिए। उसे उन भेंटों को मिलापवाले तम्बू के द्वार पर याजक को देना चाहिए। उसे एक वर्ष का मेमना होमबलि के लिए और पापबलि के हेतु एक फ़ाख्ता या कबूतर का बच्चा लाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","8","यदि स्त्री मेमना लाने में असमर्थ हो तो वह दो फ़ाख्ते या दो कबूतर के बच्चे ला सकती है। एक पक्षी होमबलि के लिए होगा तथा एक पापबलि के लिए। याजक यहोवा के सामने उनहें अर्पित करेगा। इस प्रकार वह उसके लिए उसके पापों का भुगतान करेगा। तब वह अपने खून की हानि की अशुद्धि से शुद्ध होगी। ये नियम उन स्त्रियों के लिए है जो एक लड़का या लड़की को जन्म देती हैं।” ");
INSERT INTO hin2010_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“किसी व्यक्ति के चर्म पर कोई भयंकर सूजन हो सकी है, या खुजली अथवा सफेद दाग हो सकते हैं। यदि घाव चर्मरोग की तरह दिखाई पड़े तो व्यक्ति को याजक हारून या उसके किसी एक याजक पुत्र के पास लाया जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","याजकों को व्यक्ति के चर्म के घाव को देखना चाहिए। यदि घाव के बाल सफेद हो गए हों और घाव व्यक्ति के चर्म से अधिक गहरा मालूम हो तो यह भयंकर चर्म रोग है. जब याजक व्यक्ति की जाँच खत्म करे तो उसे घोषणा करनी चाहिए कि व्यक्ति अशुद्ध है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“कभी कभी किसी व्यक्ति के चर्म पर कोई सफेद दाग हो जाता है किन्तु दाग चर्म से गहरा नहीं मालूम होता। यदि वह सत्य हो तो याजक उस व्यक्ति को सात दिन के लिए अन्य लोगों से अलग करे। ");
INSERT INTO hin2010_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","सातवे दिन याजक को उस व्यक्ति की जाँच करनी चाहिए। यदि याजक देखे कि घाव मं परिवर्तन नहीं हुआ है और वह चर्म पर औ अधिक फैला नहीं है तो याजक को और सात दिन के लिए उसे अलग करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","सात दिन बाद याजक को उस व्यक्ति की फिर जांच करनी चाहिए। यदि घाव सूख गया हो और चरम पर फैला न हो, तो याजक को घोषणा करनी चाहिए कि व्यक्ति शुद्ध है। वह केवल एक खुरंड है। तब रोगी को अनपे वस्त्र धोने चाहिए और फिर से शुद्ध होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","“किन्तु यदि व्यक्ति ने याजक को फिर अपने आपको सुद्ध बनाने के लिए दिखा लिया हो और उसके बाद चर्मरोग त्वचा पर अधिक फैलने लगे तो उस व्यक्ति को फिर याजक के पास आना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","याजक को जाँच करके देखना चाहिए। यदि घाव चर्म पर फैला हो तो याजक को घोषमा करनी चाहिए कि वह व्यक्ति अशुद्ध है अर्थात् उसे कोई कोई भयानक चर्मरोग है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“यदि व्यक्ति को भायनक चर्मरोग हुआ हो तो उसे याजक के पास लाया जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","याजक को उस व्यक्ति की जाँच करके देखना चाहिए। यदि चर्म पर सफेद दाग हो और उसमे सूजन हो, उस स्थान के बाल सफेद हों गए हो और यदि वहाँ घाव कच्चा हो ");
INSERT INTO hin2010_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","तो यह कोई भयानक चर्मरोग है जो उस व्यक्ति को बहुत समय से है। अत: याजक को उस व्यक्ति को अशुद्ध घोषित कर देना चाहिए। याजक उस व्यक्ति को केवल थोड़े से समय के लिए ही अन्य लोगों से अलग नहीं करेगा। क्यों? क्योंकि वह जानता है कि वह व्यक्ति अशुद्ध है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“यदि कभी चरमरोग व्यक्ति के सारे शरीर पर फैल जाए, वह चर्मरोग उस व्यक्ति के चरम को सिर से पाँव तक ढकले, ");
INSERT INTO hin2010_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","और याजक देखे कि चर्मरोग पूरे शरीर को इस प्रकार ढके है कि उस व्यक्ति का पूरा शरीर ही सफेद हो गया है तो याजक को उसे शुद्ध घोषित कर देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","किन्तु यदि व्यक्ति का चरम घाव जैसा कच्चा हो ते वह शुद्ध नहीं है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","जब याजक कच्चा चर्म देखे, तब उसे घोषित करना चाहिए कि व्यक्ति अशुद्ध है। कच्चा चर्म शुद्ध नहीं है। यह भयानक चर्मरोग है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","“यदि चर्म फिर कच्चा पड़ जाये और सफेद हो जाये तो व्यक्ति को याजक के पास आना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","याजक को उस व्यक्ति की जाँच करेक देखना चाहिए। यदि रोग ग्रस्त अंग सफेद हो गया हो तो याजक को घोषित करन चाहिए कि वह व्यक्ति जिसे छूत रोग है, वह अंग शुद्ध है। सो वह व्यक्ति शुद्ध है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“हो सकता है कि शरीर के चर्म पर कोई फोड़ा हो। और फोड़ा ठीक हो जाय। ");
INSERT INTO hin2010_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","किन्तु फोड़े की जगह पर सफेद सूजन या गहरी लाली लिए सफेद औ चमकीला दाग रह जाय तब चर्म का यह स्थान याजक को दिखाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","याजक को उसे देखना चाहिए। यदि सूजन चर्म से गहरा है और इस पर के बाल सफेद हो गये हैं तो याजक को घोषणा करनी चाहिए कि वह व्यक्ति अशुदध है। वह दाग भयानक चर्म रोग है। यह फोड़े के भीतर से फूट पड़ा हे। ");
INSERT INTO hin2010_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","किन्तु यदि याजक उस स्थान को देखता है और उस पर सफेद बाल नहीं हैं और दाग चर्म से गहरा नहीं है, बल्कि धुंधला है तो याजक को उस व्यक्ति को सात दिन के लिए अलग करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","यदि दाग का अधिक भाग चर्म पर फैलता है तब याजक को घोषणा करनी चाहिए कि व्यक्ति अशुद्ध है। यह छूत रोग है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","किन्तु यदि सफेद दाग अपनी जगह बना रहता है, फैलता नहीं तो वह पुराने फोड़े का केवल घाव है। याजक को घोषणा करनी चाहिए कि व्यक्ति शुद्ध है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","25","“किसी व्यक्ति का चर्म जल सकता है। यदि कच्चा चर्म सफेद या लालीयुक्त दाग होता है तो याजक को इसे देखना चाहिए। यदि वह दाग चर्म से गहरा मालूम हो औ उस स्थान के बाल सफेद हो तो यह भयंकर चर्म रोग है। जो जले में से फूट पड़ा है. तब याजक को उस व्यक्ति को अशुद्ध घोषित करना चाहिए। यह भयंकर चरकम रोग है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","किन्तु याजक यदि उस स्थान को देखता है ौर सफेद ताग में सफेद बाल नहीं है और दाग चर्म से गहरा नहीं है, बल्कि हल्का है तो याजक को उसे सात दिन के लिए ही अलग करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","सातवें दिन याजक को उस व्यक्ति को फिर देखना चाहिए। यदि दाग चर्म पर फैले तो याजक को घोषणा करनी चाहिए कि व्यक्ति अशुद्ध है। यह भयंकर चर्म रोग है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","किन्तु यदि सफेद दाग चर्म पर न फेल, अपितु धुंधला हो तो यह जलने से पैदा हुई सूजन है। याजक को उस व्यक्ति को शुद्ध घोषित करना चाहिए। यह केवल जले का निशान है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“किसी व्यक्ति के सिर की खाल पर या दाढ़ी में कोई छूत रोग हौ सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","याजक को छूत के रोग को देखना चाहिए। यदि छूत का रोग चर्म से गहरा मालूम हो और इसके चारों ओ के बल बारीक औ पीले हों तो याजक को घोषणा करनी चाहिए कि व्यक्ति अशुद्ध है। यह बुरा चर्मरोग है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","यदिरोग चर्म से गहरा न मालूम हो, और इसमें कोई काला बाल न हो तो याजक को उसे सात दिन के लिए अलग कर देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","सातवें दिन याजक को छूत के रोगी को देखना चाहिए। यदि रोग फैला नहीं है या इसमं पीले बाल नहीं उग रहे है और रोग चर्म से गहरा नहीं है, ");
INSERT INTO hin2010_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","तो व्यक्ति को बाल काट लेने चाहिये। किन्तु उसे रोग वाले स्थान के बाल नहीं काटने चाहिए। याजक को उस व्यक्ति को और सात दिन के लिए अलग करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","सातवें दिन याजक को रोगी को देखना चाहिए। यदि रोग चर्म नहीं फैला है और यह चर्म से गहरा नीं मालूम होता है तो याजक को घोषणा करनी चाहिए कि व्यक्ति शुद्ध है। व्यक्ति को अनपे वस्त्र धोने चाहिए तथा शुद्ध हो जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","किन्तु यदि व्यक्ति के शुद्ध हो जाने के बाद चर्म में रोग फैलता है ");
INSERT INTO hin2010_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","तो याजक को फिर व्यक्ति को देखना चाहिए। यदि रोग चर्म में फैला है तो याजक को पीले बालों को देखने की आवश्यकता नहीं है, व्यक्ति अशुद्ध है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","किन्तु यदि याजक यह समझता है कि रोग का बढ़ना रुक गया है और इसमें काले बाल उग रहे हैं तो रोग अच्छा हो गया है। व्यक्ति शुद्ध है। याजक को घोषणा करनी चाहिए कि व्यक्ति शुद्ध है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“जब व्यक्ति के चर्म पर सफेद दाग हों, ");
INSERT INTO hin2010_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","तो याजक को उन दागों को देखना चाहिए। यदि व्यक्ति के चर्म के दाग धुंधले सफेद हैं, तो रोग केवल अहानिकारक फुंसियाँ है। वह व्यक्ति शुद्ध है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“किसी व्यक्ति के चर्म पर सफेद दाग हों, ");
INSERT INTO hin2010_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","किसी आदमी के सिर के माथे के बाल झड़ सकते हैं। वह शुद्ध है। यह दूसरे प्रकार का गंजापन है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","किन्तु यदि उसके सिर की चमड़ी पर लाल सफेद फुंसियाँ हैं तो यह भयानक चर्म रोग है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","याजक को ऐसे व्यक्ति को देखना चाहिए। यदि छूत ग्रस्त त्वचा की सूजन लाली युक्त सफेद है और कुष्ठ की तरह शरीर के अन्य भागों पर दिखाई पड़ रही है ");
INSERT INTO hin2010_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","तो उस व्यक्ति के सिर की चमड़ी पर भयानक चर्मरोग है। व्यक्ति अशुद्ध है, याजक को घोषणा करनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","यदि किसी व्यक्ति को भयानक चर्मरोग हो तो उस ब्यक्ति को अन्य लोगों को सावधान करना चाहिए। उस व्यक्ति को जोर से ‘अशुद्ध! अशुद्ध! कहना चाहिए, उस व्यक्ति के वस्त्रों को, सिलाई से फाड़ देना चाहिए उस व्यक्ति को, अपने बालों को सँवारना नहीं चाहिए और उस व्यक्ति को अपना मुख ढकना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","जो व्यक्ति अशुद्ध होगा उसमें छूत का रोग सदा रहेगा। वह व्यक्ति अशुद्ध है। उसे अकेल रहना चाहिए। उनका निवास डेरे से बाहर होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","“कुछ वस्त्रों पर फफूँदी लग सकती हैं। वस्त्र सन का या ऊनी हो सकता है। वस्त्र बुना हुआ या कढ़ा हुआ हो सकता है। फफूँदी किसी चमड़े या चमड़े से बनी किसी चीज पर हो सकती है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","यदि फफूँदी हरी या लाल हो तो उसे याजक को दिखाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","याजक को फफूँदी देखनी चाहिए। उसे उस चीज को सात दिन तक अलग स्थान पर रखना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","52","सातवें दिन, याजक को फफूँदी देखनी चाहिए। यह महत्वपूर्ण नहीं है कि फफूँदी चमड़े या कपड़े पर है। यह महत्वपूरण नहीं कि वस्त्र बुना हुआ या कढ़ा हुआ है। यह महत्वपूर्ण नहीं कि चमड़े का उपयोग किस लिए किया गया था। यदि फफूँदी फैलती है तो वह कपड़ा या चमड़ा अशुद्ध है। वह फफूँदी अशुद्ध है। याजक को उस कपड़े या चमड़े को जला देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“यदि याजक देखे कि फफूँदी फैली नहीं तो वह कपड़ा या चमड़ा धोया जाना चाहिए। यह महत्वपूर्ण नहीं कि यह चमड़ा है या कपड़ा, अथवा कपड़ा बुना हुआ है या कढ़ा हुआ, इस धोना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","याजक को लोगों को यह आदेश देना चाहिए कि वे चमड़े या कपड़े के टुकड़ों को धोएं, तब याजक वस्त्रों को और सात दिनों के लिए अलग करे। ");
INSERT INTO hin2010_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","उस समय के बाद याजक को फिर देखना चाहिए। यदि फफूँदी ठीक वैसी ही दिखाई देती है तो वह वस्तु अशुद्ध है। यह महत्वपूर्ण नहीं है कि छूत फैली नहीं है। तुम्हें उस कपड़े या चमड़े को जला देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“किन्तु यदि याजक उस चमड़े को देखता है कि फफूँदी युक्त दाग को चमड़े या कपड़े से फाड़ देना चाहिए। यह महत्वपूर्ण नहीं कि कपड़ा कढ़ा हुआ है या बारीक बुना हुआ है। ");
INSERT INTO hin2010_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","किन्तु फफूँदी उस चमड़े या कपड़े पर लौट सकती है। यदि ऐसा होता है तो फफूँदी बढ़ रही है। उस चमड़े या कपड़े को जला देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","किन्तु यदि धोने के बाद फफूँदी न लौटे, तो वह चमड़ा या कपड़ा शुद्ध है। इसका कोई महत्व नहीं कि कपड़ा कढ़ा हुआ या बुना हुआ था। वह कपड़ा शुद्ध है।” ");
INSERT INTO hin2010_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","चमड़े या कपड़े पर की फफूँदी के विषय में ये नियम हैं। इसका कोई महत्व नहीं कि कपड़ा कढ़ा हुआ है या बुना हूआ है। ");
INSERT INTO hin2010_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“ये उन लोगों के लिए नियम हैं जिन्हें भयानक चर्म रोग था और जो स्वस् हो गए। ये नियम उस व्यक्ति को शुद्ध बनाने के लिए है। “याजक को उस व्यक्ति को देखान चाहिए जिसे भयानक चर्म रोग है। ");
INSERT INTO hin2010_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","याजक को उस व्यक्ति के पास डेरे के बाहर जाना चाहिए। याजक को यह देखने का प्रयत्न करना चाहिए कि वह चर्म रोग अच्छा हो गाय है। ");
INSERT INTO hin2010_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","यदि व्यक्ति स्वस्थ है तो याजक उसे यह करने को कहेगा: उसे दो जीवित शुद्ध पक्षी, एक देवदारू की लकड़ी, लाल कपड़े का एक टुकड़ा और एक जूफा का पौधा लाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","याजक को बहते हुए पानी के ऊपर मिट्टी के एक कटोरे में एक पक्षी को मारने का आदेश देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","तब याजक दूसरे पक्षी को ले, जो अभी जीवित है औ देवदारू की लकड़ी, लाल कपड़े के टुकड़े और जूफा का पौधा ले। याजक को जीवित पक्षी और अन्य चीज़ों को बहते हुए पानी के ऊपर मारे गए पक्षी के खून में डूबाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","याजक उस व्यक्ति पर सात बार खून छिड़केगा जिसे भायनक चर्म रोग है। तब याजक को घोषित करना चाहिए कि वह व्यक्ति सुद्ध है। तब याजक को खुले मैदान में जाना चाहिए और जीवित पक्षी को उड़ा देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“इसके बाद उस व्यक्ति को अपने वस्त्र धोने चाहिए। उसे अपने सारे बाल काट डालने चाहिए और पानी से नहाना चाहिए। वह शुद्ध हो जाएगा। तब वह व्यक्ति डेरे में जा सकेगा। किन्तु उस अपने खेमे के बाहर सात दिन तक रहना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","सातवें दिन उसे अपने सारे बाल काट डालने चाहिए। उसे अपने सिर, दाढ़ी, भौंहों के सभी बाल कटवा लेने चाहिए। तब उसे अपने कपड़े धोने चाहिए और पानी से नहाना चाहिए। तब वह व्यक्ति शुद्ध होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“आठवें दिन उस व्यक्ति को दो नर मेमने लेने चाहिए जिनमें कोई दोष न हो। उसे एक वर्ष की एक मादा मेमना भी लेनी चाहिए जिसमें कोई दोष न हो। उसे छ: र्क्वाट तेल मिला उत्तम महीन आटा लेना चाहिए। यह आटा अन्नबलि के लिए है। व्यक्ति को दो तिहाई पिन्ट जैतून का तेल लेना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","(याजक को घोषणा करनी चाहिए कि वह व्यक्ति शुद्ध है।) याजक को उस व्यक्ति और उसकी बलि को मिलापवाले तम्बू के द्वार पर यहोवा के सामने लाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","याजक नर मेमनों में से एक को दोषबलि के रूप में चढ़ाएगा। वह उस मेमनों और उस तेल को यहोवा के सामने उत्तोलन बलि के रूप में चढ़ाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","तब याजक नर मेमने को उसी पवित्र स्थान पर मारेगा जहाँ वे पापबलि और होमबलि को मारते हैं। दोषबलि, पापबलि के समान है। यह याजक की है। यह अत्यन्त पवित्र है। ");
INSERT INTO hin2010_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","“याजक दोषबलि का कुछ खून लेगा और फिर याजक इसमें से कुछ खून शुद्ध किये जाने वाले व्यक्ति के दाएँ कान के निचले सिरे पर लागएगा। याजक कुछ खून उस व्यक्ति के हाथ के दाएँ अंगूठे और दाएँ पैर के अंगूठे पर लगाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","याजक कुछ तेल भी लेगा और अपनी बाँयी हथेली पर डालेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","तब याजक अपने दाएँ हाथ की ऊँगलियाँ अपने बाएँ हाथ की हथेली में रखे हुये तेल में डुबाएगा। वह अपनी उँगली का उपयोग कुछ तेल यहोवा के सामने सात बार छिड़कने के लिए करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","याजक अपनी हथेली का कुछ तेल शुद्ध किये जाने वेला व्यक्ति के दाएँ कान के निचले सिरे पर लगाएगा। याजक कुछ तेल उस व्यक्ति के दाएँ हाथ के अंगूठे और दाएं पैर के अंगूठे पर लागाएगा। याजक कुछ तेल दोषबलि के खून पर लगाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","याजक अपनी हथेली में बचा हुआ तेल शुद्ध किए जाने वाले व्यक्ति के सिर पर लगाएगा। इस प्रकार याजक उस व्यक्ति के पाप का यहोवा के सामने भुगता न करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“उसके बाद याजक पापबलि चढ़ाएगा और व्यक्ति के पापों का भुगतान करेगा जिससे वह शुद्ध हो जाएगा। इसके पश्चात याजक होमबलि के लिए जानवर को मारेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","तब याजक होमबलि और अन्नबलि को वेदी पर चढ़ाएगा। इस प्रकार याजक उस व्यक्ति के पापों का भुगतान करेगा और वह व्यक्ति शुद्ध हो जायेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“किन्तु यदि व्यक्ति गरीब है और उन बलियों को देने में असमर्थ है तो उसे एक मेमना दोषबलि के रूप में लेना चाहिए। यह उत्तोलनबलि होगी जिससे याजक उसके पापों के भुगतान के लिए देघा। उसे दो क्वार्ट तेल मिला उत्तम महीन आटा लेना चाहिए। यह आटा अन्नबलि के रूप में उपयोग में आएगा। व्यक्ति को दो तिहाई पिन्ट जैतून का तेल ");
INSERT INTO hin2010_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","और दो फ़ाख्ते या दो कबूतर के बच्चे लेने चाहिए। इन चीज़ों को देने में गरीब लोग भी समर्थ होंगे। एक पक्षी पापबलि के लिए होगा और दूसरा होमबलि का होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“आठवें दिन, वह व्यक्ति उन चीज़ों को याजक के पास मिलापवाले तम्बू के द्वार पर लाएगा। वे चीज़ें यहोवा के सामने बलि चढ़ाई जाएंगी जिससे व्यक्ति शुद्ध हो जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","याजक, दोषबलि के रूप में तेल और मेमने को लेगा। तथा यहोवा के सामने उत्तोलनबलि के रूप में चढ़ाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","तब याजक दोषबलि के मेमने को मारेगा। कुछ खून शुद्ध बनाए जाने वाले व्यक्ति के दाएँ कान के निचले सिरे पर लगाएगा। याजक इसमें से कुछ खून इस व्यक्ति के दाएँ हाथ के अंगूठे और दाएँ पैर के अंगूठे पर लगाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","याजक इस तेल में से कुछ अपनी बायीं हथेली में भी डालेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","याजक अपने दाएँ हाथ की उँगली का उयोग अपनी हथेली के तेल को यहोवा के सामने सात बार छिड़कने के लिए करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","तब याजक अपनी हथेली के कुछ तेल को शुद्ध बनाए जाने वाले व्यक्ति के दाएँ कान के सिरे पर लगाएगा। याजक इस तेल में से कुछ तेल व्यक्ति के दाएँ हाथ के अंगूठे और उसके दाएँ पैर के अंगूठ पर लगाएगा। याजक दोषबलि के खून लगे स्थान पर इसमें से कुछ तेल लगाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","याजक को अपनी हथेली के बचे हुये तेल को शुद्ध किए जाने वाले व्यक्ति के सिर पर डालना चाहिए। इस प्रकार यहोवा के सामने याजक उस व्यक्ति के पापों का भुगतान करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","“तब व्यक्ति फाख्तों में से एक या कबूतर के बच्चों में से एक की बलि चढ़ाएगा। गरीब लोग भी इन पक्षियों को भेंट करने में समर्थ होंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","व्यक्ति को अपनी सामर्थ्य के अनुसार बलि चढ़ानी चाहिए। उसे पक्षियों में से एक को पापबलि के रूप में चढ़ाना चाहिए औ दूसरे पक्षी को होमबलि के रूप में उसे उनकी अन्नबलि के साथ भेंट चढ़ाना चाहिए। इस प्रकार याजक यहोवा के सामने उस व्यक्ति के पाप का भुगतान करेगा और वह व्यक्ति शुद्ध हो जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ये भयानक चर्मरोग के ठीक होने के बाद किसी एक व्यक्ति के लिए हैं जो शुद्ध करने के नियम हैं। ये नियम उन व्यक्तियों के लिए हैं जो शुद्ध होने के लिए सामान्य बलियों का व्यय नहीं उठा सकते। ");
INSERT INTO hin2010_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","यहोवा ने मूसा और हारून से यह भी कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“मैं तुम्हारे लोगों को कनान देश दे रहा हूँ। तुम्हारे लोग इस भूमि पर जाएंगे। उस समय मैं हो सकता है, कुछ लोगों के घरों में फफूँदी लगा दूँ। ");
INSERT INTO hin2010_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","तो उस घर के मालिक को याजक के पास आकर कहन चाहिए, ‘मैंने अपने घर में फफूँदी जैसी कोई चीज देखी है।’ ");
INSERT INTO hin2010_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","“तब याजक को आदेश देना चाहिए कि घर को खाली कर दिया जाय। लोगों को याजक के फफूँदी देखने जाने से पहले ही यह करना चाहिए। इस तरह घर घर की सभी चीज़ों को याजक को असुद्ध नहीं कहना पड़ेगा। लोगों द्वारा घर खाली कर दिए जाने पर याजक घर में देखने जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","याजक फफूँदी को देखेगा। यदि फफूँदी ने घर की दीवारों पर हरे या लाल रंग के चकत्ते बना दिए हैं और फफूँदी दीवार की सतह पर बढ़ रही है, ");
INSERT INTO hin2010_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","तो याजक को घर से बाहर निकल आना चाहिए और सात दिन तक घर बन्द कर देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","“सातवें दिन, याजक को वहाँ लौटना चाहिए और घर की जाँच करनी चाहिए। यदि घर की दीवारों पर फफूँदी फैल गई हो ");
INSERT INTO hin2010_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","तो याजक को लोगोंको आदेश देना चाहिए कि वे फफूँदी सहित पत्थरों को उखाड़ें और उन्हें दूर फेंग दें। उन्हें उन पत्थरों को नगर से बाहर विशेष अशुद्ध स्थान पर फेंकना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","तब याजक को पूरे घर को अन्दर से खुरचवा डालना चाहिए। लोगों को उस लेप को जिसे उन्होंने खुरचा है, फेंक देना चाहिए। उन्हें उस लेप को नगर के बाहर विशेष अशुद्ध स्थान पर डालना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","तब उरस व्यक्ति को नए पत्थर दीवारों में लगाने चाहिए और उसे उन दीवारों को नए लेप से ढक देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“सम्भव है कोई व्यक्ति पुराने पत्थरों और लेप को निकाल कर नेय पत्थरों और लेप को लगाए और सम्भव है वह फफूँदी उस घर में फिर प्रकट हो। ");
INSERT INTO hin2010_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","तब याजक को आकर उस घर की जाँच करनी चाहिए। यदि फफूँदी घर में फैल गी हो तो यह रोग है जो दूसरी जगहों में जल्दी से फैलता है। अत: घर अशुद्ध है। ");
INSERT INTO hin2010_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","उस व्यक्ति को वह घर गिरा देना चाहिए। उन्हें सारे पत्थर, लेप तथा अन्य लकड़ी के टुकड़ों को नगर से बाहर अशुद्ध स्थान पर ले जान चाहिए ");
INSERT INTO hin2010_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","और कोई व्यक्ति जो उसमें जाता है, सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","यदि कोई व्यक्ति उसमें भोजन करता है या उसमें सोता है तो उस व्यक्ति को अनपे वस्त्र धोने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“घर में नये पत्थर और लेप लगाने के बाद याजक को घर की जाँच करनी चाहिए। यदि फफूँदी घर में नहीं फैली है तो याजक घोषणा करेगा की घर शुद्ध है। क्यों? क्योंकि फफूँदी समाप्त हो गई है! ");
INSERT INTO hin2010_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","“तब, घर को शुद्ध करने के लिए याजक को दो पक्षी, एक देवदारू की लकड़ी, एक लाल कपड़े का टुकड़ और जूफा का फौधा लेना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","याजक बहते पानी के ऊपर मिट्टी के कटोरे में एक पक्षी को मारेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","तब याजक देवदारू की लकड़ी, जूफा का पौधा, लाल कपड़े का टुकड़ा और जीवित पक्षी को लेगा। याजक बहते जल के ऊपर मारे गए पक्षी के खून में उन चीज़ों को डुबाएगा। तब याजक उस खून को उस घर पर सात बार छिड़केगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","इस प्रकार याजक उन चीज़ों का उपयोग घर को शुद्ध करने के लिए करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","याजक खुले मैदान में नगर के बाहर जाएगा और पक्षी को उड़ा देगा। इस प्रकार याजक घर को शुद्ध करेगा। घर शुद्ध हो जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","वे नियम भयानक चर्मरोग के, ");
INSERT INTO hin2010_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","घर या कपड़े के टुकड़ों पर की फफूँदी के बारे में है। ");
INSERT INTO hin2010_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","वे नियम सूजन, फुंसियों या चर्मरोग पर सफेद दाग से सम्बन्धित हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","वे नियम सिखाते हैं कि चीजे कब अशुद्ध हैं तथा कब शुद्ध हैं। वे नियम उस प्रकार की बिमारियों से सम्बन्धित हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“इस्राएल के लोगों से कहोः जब किसी व्यक्ति के शरीर से धात का स्राव है तब वह व्यक्ति अशुद्ध होता है। ");
INSERT INTO hin2010_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","वह धात शरीर से खुला बहता है या शरीर उसे बहने से रोक देता है इसका कोई महत्व नहीं। ");
INSERT INTO hin2010_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“यदि धात त्याग करने वाला बिस्तर पर लोया रहात है तो वह बिस्तर अशुद्ध हो जाता है। जिस चीज़ पर भी वह बैठता है वह अशुद्ध हो जाता है। ");
INSERT INTO hin2010_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","यदि कोई व्यक्ति उसके बिस्तर को छूता भी है तो उसे अपने वस्त्रों को धोना और पानी से नहाना चाहिए। वह सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","यदि कोई व्यक्ति उस चीज़ पर बैठाता है जिस पर धात त्याग करने वाला व्यक्ति बैठा हो तो उसे सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","यदि कोई व्यक्ति उस व्यक्ति को छूता है जिसने धात त्या किया है तो उसे अपने वस्त्रों को धोना चाहिए तथा बहते पानी में नहाना चाहिए। वह सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","यदि धत त्याग करने वाल व्यक्ति किसी शुद्ध व्यक्ति पर थूकता है तो शुद्ध व्यक्ति को अपने वस्त्र धोने चाहिए तथा नहाना चाहिए। यह व्यक्ति सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","पशु पर बैठने की कोई काठी जिस पर धात त्याग करने वाला व्यक्ति बैठा हो तो वह अशुद्ध हो जाएगी। ");
INSERT INTO hin2010_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","इसलिए कोई व्यक्ति जो धात त्याग करने वाले व्यक्ति के नीचे रहने वाली किसी चीज़ को छूता है, सन्ध्या तक अशुद्ध रहेगा। जो व्यक्ति धात त्याग करने वाले व्यक्ति के नीचे की चीज़ें ले जाता है उसे अपने पस्त्रों को धोना चाहिए तथा बहते पानी में नहाना चाहिए। वह सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","यह सम्भव है कि धात त्याग करने वाल व्यक्ति पानी में हाथ धोए बिना किसी अनय् व्यक्ति को छूए। तब दूसरा व्यक्ति अपने वस्त्रों को धोए और बहते पानी में नहाए। वह सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“धात त्याग करने वाला व्यक्ति यदि मिट्टी का कटोरा छूए तो वह कटोरा पोड़ देना चाहिए। यदि धात त्याग करने वाला व्यक्ति कोई लकड़ी का कटोरा छूए तो उस कटोरे को बहते पानी में अच्छी तरह धोना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“जब धात त्याग करने वाला कोई व्यक्ति अपने धात त्याग से शुद्ध किया जाता है तो उसे अपनी शुद्धि के लिए उस दिन से सात दिन गिनने चाहिए। तब उसे अपने वस्त्र दोने चाहिए और बहते पानी में नहाने चाहिए। तब उसे अपने वस्त्र धोने चाहिए और बहते पानी में नहाना चाहिए। वह शुद्ध हो जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","आठवें दिन उस व्यक्ति को दो फ़ाख्ते या दो कबूतर के बच्चे लेने चाहिए। उसे मिलापवाले तम्बू के द्वार पर यहोवा के सामने आना चाहिए। वह व्यक्ति दो पक्षी याजक को देगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","याजक पक्षियों की बलि चढ़ाएगा। एक को पापबलि के लिए तथा दूसरे को होमबलि के लिये। इस प्रकार याजक इसे व्यक्ति को यहोवा के सामने उस के धात त्याग से हुई अशुद्धता से शुद्ध करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“यदि व्यक्ति का वीर्य निकल जाता है तो उसे सम्पूर्ण शरीर से बहते पानी में नहाना चाहिए। वह सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","यदि वीर्य किसी वस्त्र या चमड़े पर गिरे तो वह वस्त्र या चमड़ा पानी में धोना चाहिए। यह सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","यदि कोई व्यक्ति किसी स्त्री के साथ सोता है और वीर्य निकलता है तो स्त्री पुरुष दोनों को सबहते पानी में नहाना चाहिए। वे सन्ध्या तक अशुद्ध रहेंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“यदि कोई स्त्री मासिक रक्त स्राव के समय मासिक धर्म से है तो वह सात दिन तक अशुद्ध रहेगी। यदि कोई व्यक्ति उसे छूता है तो वह व्यक्ति सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","अपने मासिकधर्म के समय स्त्री जिस किसी चीज़ पर लेटेगी, वह भी अशुद्ध होगी और उस समय में जिस चीज़ पर वह बैठेगी, वह बी अशुद्ध होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","यदि कोई व्यक्ति उस स्त्री के बिस्तर को छूता है तो उसे अनपे वस्त्रों को बहते पानी में धोना और नहाना चाहिए। वह सन्धया तक अशुद्ध रहागा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","यदि कोई व्यक्ति उस चीज़ को छूता है जिस पर वह स्त्री बैठी हो तो उस व्यक्ति को अपने वस्त्र बहते पानी में धोने चाहिए और नहाना चाहिए। वह सन्ध्या तक अशुद्ध रहाग। ");
INSERT INTO hin2010_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","वह व्यक्ति स्त्रि के बिस्तर को छूता है या उस चीज़ को छूता है जिस पर वह बैठी हो, तो वह व्यक्ति सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“यदि कोई व्यक्ति किसी स्त्री के साथ मासिक धर्म के समय यौन सम्बन्ध करता है तो वह व्यक्ति सात दिन तक अशुद्ध रहेगा। हर एक बिस्तर जिस पर वह सोता है, अशुद्ध होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“यदि किसी स्त्री को कई दिन तक रक्त स्राव रहता है जो उसके मासिकधर्म के समय नहीं होता, या निश्चित समय के बाद मासिकधर्म हो ता है तो वह उसी प्रकार अशुद्ध होगी जिस प्रकार मासिकधर्म के समय और तब तक अशुद्ध रहेगी जब तक रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","पूरे रक्त स्राव के समय वह स्त्री जिस बिस्तर पर लेटेगी, वह वैसा ही होगा जैसा मासिकधर्म के समय। जिस किसी चीज़ पर वह स्त्री बैठेगी, वह वैसे ही अशुद्ध होगी जैसे वह मासिकधर्म क अशुद्ध होती है। ");
INSERT INTO hin2010_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","यदि कोई व्यक्ति उन चीज़ों को छूता है तो वह अशुद्ध होगा। इस व्यक्ति को बहते पानी से अपने कपड़े धोने चाहिए तथा नाहा चाहिए। वह सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","उसके बाद जब स्त्री अपने मासिकधर्म से अशुद्ध हो जाती है तब से उसे सात दिन गिनने चाहिए। इसके बाद वह शुद्ध होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","फिर आठवें दिन उसे दो फ़ाख्ते और दो कबूतर के बच्चे लेने चाहिए। उसे उन्हें मिलापवाले तम्बू के द्वार पर याजक के पास लाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","तब याजक को एक पक्षी पापबलि के रूप में तथा दूसरे को होमबलि के रूप में चढ़ाना चाहिए। इस प्रकार वह याजक उसे यहोवा के सामने उसके स्राव से उत्पन्न अशुद्धि से शुद्ध करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“इसलिए तुम इस्राएल के लोगों को अशुद्ध होने और उनको अशुद्धि से दूर रहने के बारे में सावधान करना । यदि तुम लोगों को सावधान नहीं करते तो वे मेरे पवित्र तम्बू को अशुद्ध कर सकते हैं और तब उन्हें मरना होगा!” ");
INSERT INTO hin2010_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ये नियम धात त्याग करने वाले लोगों के लिए हैं। ये नियम उन व्यक्तियों के लिए हैं जो वीर्य के शरीर से बाहर निकलने से अशुद्ध होते हैं ");
INSERT INTO hin2010_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","और ये नियम उन स्त्रियों के लिए हैं जो अपने मासिकधर्म क रक्त स्राव के समय अशुद्ध होती है और वे नियम उन पुरुषों के लिए है जो अशुद्ध स्त्रियों के साथ सोने से अशुद्ध होते हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","हारून के दो पुत्र यहोवा को सुगन्ध भेंट चढ़ाते समय मर गए थे। फिर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“अपने भाई हारून से बात करो कि वह जब चाहे तब पर्दे के पीछे महापवित्र स्थान में नहीं जा सकता है। उस पर्दे के पीछे जो कमरा है उसमें पवित्र सन्दूक रखा है। उस पवित्र सन्दूक के ऊपर उसका विशेष ढक्कन लगा है। उस विशेष ढक्कन के ऊपर एक बादल में मैं प्रकट होता हूँ। यदि हारून उस कमरे में जाता है तो वह मर जायेगा! ");
INSERT INTO hin2010_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“पापसे निस्तार के दिन पवित्र स्थान में जाने के पहले हारून को पापबलि के रूप में एक बछड़ा और होमबलि के लिए एक मेढ़ा भेंट करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","हारून अपने पूरे शरीर को पानी डालकर धोएगा। तब हारून इन वस्त्रों को पहनेगा: हारून पवित्र सन के वस्त्र पहनेगा। सन के निचले वस्त्र शरीर से सटे होगें। उसकी पेटी सन का पटुका होगी। हारून सन की पगड़ी बाँधेगा। ये पवित्र वस्त्र है। ");
INSERT INTO hin2010_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“हारून को इस्राएल के लोगों से दो बकरे पापबलि के रूप में और एक मेढ़ा होमबलि के लिए लेना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","तब हारून बैल की पापबलि चढ़ाएगा। यह पापबलि उसके अनपे लिए और उसेक परिवार के लिए है। तब हारून वह उपासना करेगा जिसमें वह औ उसका परिवार शुद्ध होंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","“इसके बाद हारून दो बकरे लेगा और मिलापवाले तुमबू के द्वार पर यबोवा के सामने लाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","हारून दोनों बकरों के लिए चिट्ठी डालेगा। एक चिट्ठी यहोवा के लिए होगी। दूसरी चिट्ठी अजाजेल के लिए होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","“तब हारून चिट्ठी डालकर यहोवा के लिए चुने गए बकरे की भेंट चढ़ाएगा। हारून को इस पगरे को पापबलि के लिये चढ़ाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","किन्तु चिट्ठी डालकर अजाजेल के लिए चुना गया बकरा यहोवा के सामने जीवित लाया जाना चाहिए। याजक उसे शुद्ध बनाने के लिये उपासना करेगा। तब यह बकरा मरुभूमि में अजाजेल के पास भेजा जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“तब हारून अपने लिये बैल को पापबलि के रूप में चढ़ाएगा। हारून अपने आप को और अपने परिवार को शुद्ध करेगा। हारुन बैल को अपने लिए पापबलि के रूप में मारेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","तब उसे आग के लिए एक तसला वेदी के अंगारों से भरा हुआ यहोवा के सामने लाना चाहिए। हारून दो मुट्ठी वह मधुर सुगन्धि धूप लेगा जो बारीक पीसी गिई है। हारून को पर्दे के पीछे कमरे में उस सुगन्धित को आग में डालना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","तब सुगन्धित धूप के धुएँका बादन साक्षीपत्र के ऊपर के विशेष ढक्कन को ढक लेगा। इस प्रकार हारून नहीं मरेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","साथ ही साथ हारून को बैल का कुछ खून लेना चाहिए और उसे अपनी उँगली से उस विशेष ढक्कन के पूर्व की ओर छिड़कना चाहिए। इस के सामने वह अपनी ऊँगली से सात बार खून छिड़केगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“तब हारून को लोगों के लिए पापबलि स्वरूप बकरे को मारना चाहिए। रहारून को बकरे का खून पर्दे के पीछे कमरे में लाना चाहिए। हारून को बकरे के खून से वैसा ही करना चाहिए जैसा बैल के खून से उसने किया। हारून को उस ढक्कन पर और ढक्कन के साने बकरे का खून छिड़कना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ऐसा अनक बार हुआ जब इस्राएल के लोग अशुद्ध हुए। इसलिए हारून इस्राएल के लोगों के अपराध और पाप से महापवित्र स्थान को शुद्ध करने के लिए उपासना करेगा। हारून को ये काम क्यों करना चाहिए क्योंकि मिलापवाला तम्बू अशुद्ध लोगों के बीच में स्थित है। ");
INSERT INTO hin2010_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","“जिस समय हारून महापवित्र स्थान को शुद्ध करे, उस समय कोई व्यक्ति मिलापवाले तम्बू में नहीं होना चाहिए। किसी व्यक्ति को उसके भीतर तब तक नहीं जाना चाहिए जब तक हारून बाहर न आ जाय। इस प्रकार हारून अपने को और अपने परिवार को शुद्ध करेगा और तब इस्राएल के सभी लोगों को शुद्ध करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","तब हारून वेदी को शुद्ध करेगा। हारून बैल का कुछ खून और कुछ बकरे काखून लेकर वेदी के कोनों पर चारों ओर लगाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","तब हारून कुछ खून अपनी ऊँगली से वेदी पर सात बार छिड़गा। इस प्रकार हारून इस्राएल के लोगों के सभी पापों से वेदी को शुद्ध और पवित्र करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“हारून महापवित्र स्थान, मिलापवाले तम्बू तथा वेदी को पवित्र बनाएगा। इन कामों के बाद राहून यहोवा के पास बकरे को जीवित लाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","हारून अपने दोनों हाथों को जीवित बकरे के सिर पर रखेगा। तब हारून बकरे के ऊपर इस्राएल के लोगों के अपराध और पाप को कबूल करेगा। इस प्रकार हारून लोगों के पापों को बकरे के सिर पर डालेगा। तब वह बकरे को दूर मरुभूमि में भेजेगा. एक व्यक्ति बगल में बकरे को ले जाने के लिए खड़ा रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","इस प्रकार बकरा सभी लोगों के पाप अपने ऊपर सूनी मरुभूमि में ले जाएगा। जो व्यक्ति बकरे को ले जाएगा वह मरुभूमि में उसे खुला छोड़ देगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“तब हारून मिलापवाले तम्बू में जाएगा। वह सन के उन वस्त्रों को उतारेगा जिन्हें उसने महपवित्र स्थान में जाते समय पहना था। उसे उन वस्त्रों को वहीं छोड़ना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","वहअपने पूरे शरीर को पवित्र स्थान में पानी डालकर धोएगा। तब वह अपने अन्य विशेष वस्त्रों को पहनेगा। वह बाहर आएगा और अपने लिये होमबलि और लोगों के लिये होमबलि चढ़ाएगा। वह अनपे को तथा लोगों को पापों से मुक्त करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","तब वह वेदी पर पापबलि की चर्बी को जलाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“जो व्यक्ति बकरे को अजाजेल के पास ले जाए, उस अपने वस्त्र तथा अपने पूरे शरीर को पानी डालकर धोना चाहिए। सके बाद वह व्यक्ति डेरे में आ सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“पापबलि के बैल और बकरे को डेरे के बाहर ले जाना चाहिए। (उन जानवरों का खून पवित्र स्थान में पवित्र चीज़ों को शुद्ध करने के लिए लाया गया था।) याजक उन जानवरों का चमड़ा, शरीर और शरीर मल आग में जलाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","तब उन चीज़ों को जलाने वाले व्यक्ति को अपने वस्त्र और पूरे शरीर को पानी डालकर धोना चाहिए। उसके बाद वह व्यक्ति डेरे में आ सकात है। ");
INSERT INTO hin2010_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“यह नियम तुम्हारे लिए सदैव रहैगा: सातवें महीने के दसवें दिन तुम्हें उपवास करना चाहिए। तुम्हें कोई काम नहीं करना चाहिए। तुम्हारे साथ रहने वाले यात्री या विदेशी भी कोई काम नहीं कर सगेंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","क्यों क्योंकि इस दिन याजक तुमहें शुद्ध करता है और तुम्हारे पापों को धोता है। तब तुम यहोवा के लिए शुद्ध होंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","यह दिन तुम्हारे लिए आराम करने का विशेष दिन है। तुम्हें इस दिन उपवास करना चाहिए। यह नियम सदैव के लिए होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","“सो वह पुरुष जो महायाजक बनने के लिए अभिषिक्त है, वस्तुओं को शुद्ध करने की उपासना को सम्पन्न करेगा। यह वही पुरुष है जिसे उसके पिता की मृत्यु के बाद महायाजक के रूप में सेवा के लिए नियुक्त किया गया है। उस याजक को सन के पवित्र वस्त्र धारण करने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","उसे पवित्र स्थान, मिलापवाले तम्बू और वेदी को शुद्ध करना चाहिए और उसे याजक और इस्राएल के सभी लोगों को शुद्ध करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","इस्राएल के लोगों को शुद्ध करे का यह नियम सदैव रहेगा। इस्राएल के लोगों के पाप के निस्तार के लिए तुम उन क्रियाओं को वर्ष में एक बार करोगे।” इसलिए उन्होंने वही किया जो यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“हारून, उसके पुत्रों और इस्राएल के सभी लोगों से कहो। उनको कहो कि यहोवा ने यह आदेश दिया है: ");
INSERT INTO hin2010_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","कोई इस्राएली व्यक्ति किसी बैल या मेमने या बकरे को डेरे में या डेरे के बाहर मार सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","वह व्यक्ति उस जानवर को मिलापवाले तम्बू में भेंट के रूप में देना चाहिए। उस व्यक्ति ने खून बहाया है, मारा है इसलिए उसे यहोवा के पवित्र तम्बू में भेंट ले जानी चाहिए। यदि वह जानवर के भाग को भेंट के रूप में यहोवा को नहीं ले जाता तो उस अपने लोगों से अलग कर देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","यह नियम इसलिए है कि लोग मेलबलि यहोवा को अर्पित करें। इस्राएल के लोगों को उन जानवरों को लाना चाहिए जिन्हें वे मैदानों में मारते हैं। उन्हें उन जानवरों को मिलापवाले तम्बू के द्वार पर लाना चाहिए। उन्हें उन जानवरों को याजक के पास लाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","तब याजक उन जानवरों का खून मिलापवाले तम्बू के द्वार के समीप यहोवा की वेदी तक फेंकेगा और याजक उन जानवरों की चर्बी को वेदी पर जलाएगा। यह यहोवा के लिए मधुर सुगन्ध होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","उन्हें आगे अब कोई भी भेंट ‘बकरे की मूर्तियों’ को नीहं चढ़ानी चाहिए। ये लोग उन अन्य देवताओं के पीछे लग चुके हैं। इस प्रकार उन्होंने वेश्याओं जैसा काम किया है। ये नियम सदैव ही रहेंगे! ");
INSERT INTO hin2010_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“लोगों से कहो: इस्राएल का कोई नागरिक, या कोई यात्री, या कोई विदेशी जो तुम लोगों के बीच रहता है, होमबलि या बलि चढ़ा सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","उस व्यक्ति को वह बलि मिलावाले तम्बू के द्वार पर ले जानी चाहिए और उसे यहोवा को चढ़ानी चाहिए। यदि वह व्यक्ति ऐसा नहीं करता तो उसे अपने लोगों से अलग कर देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“मैं (परमेश्वर) हर ऐसे व्यक्ति के विरुद्ध होऊँगा जो खून खाता है। चाहे वह इस्राएल का नागरिक हो या वह तुम्हारे बीच रहने वाला कोई विदेशी हो । मैं उसे उसके लोगों से अलग करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","क्यों? क्योंकि प्राणी का जीवन खून में है। मैंने तुम्हें उस खून को वेदी पर डालने का नियम दिया है। तुम्हें अपने को शुद्ध करने के लिए यह करना चाहिए। तुम्हें वह खून उस जीवन के बदले में मुझे देना होगा जो तुम लेते हो। ");
INSERT INTO hin2010_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","इसलिए मैं इस्राएल के लोगों से कहता हूँ: तुममें से कोई खून नहीं खा सकता और नही तुम्हारे बीच रहने वाला कोई विदेशी खून खा सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“यदि कोई व्यक्ति किसी विदेशी खून खा सकता है। यदि कोई व्यक्ति किसी जंगली जानवर या पक्षी को पकड़ता है जिसे खाया जा सेक तो उस व्यक्ति को खून जमीन पर बह देना चाहिए और मिट्टी से उसे ढक देना चाहिए। चाहे वह व्यक्ति इस्राएल का नागरिक हो या तुम्हारे बीच रहने वाले विदेशी। ");
INSERT INTO hin2010_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","तुम्हें यह क्यों करना चाहिए? क्योकि यदि खून तब भी माँस में है तो उस जानवर का प्राण भी माँस में है। इसलिए मैं इस्राएल के लोगों को आदेश देता हूँ उस माँ को मत खाओ जिसमं खून हो! कोई भी व्यक्ति जो खून खाता है अपने लोगों से अलग कर दिया जाए। ");
INSERT INTO hin2010_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“यदि कोई व्यक्ति अपने आप मरे जानवर या किसी दूसरे जानवर द्वारा मारे गए जानवर को खाता है तो वह व्यक्ति सन्ध्या तक अशुद्ध रहेगा। उस व्यक्ति को अपने वस्त्र और अपना पूरा शरीर पानी से धोना चाहिए। चाहे वह व्यक्ति इस्राएल का नागरिक हो या तुम्हारे बीच रहने वाला कोई विदेशी। ");
INSERT INTO hin2010_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","यदि वह व्यक्ति अपने वस्त्रों को नहीं धोता और न ही नहाता है तो वह पाप करने का अपराधी होगा।” ");
INSERT INTO hin2010_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“इस्राएल के लोगों से कहोः मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2010_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","यहाँ आने के पहले तुम लोग मिस्र में थे। तुम्हें वह नहीं करना चाहिए जो वहाँ हुआ करता था! मैं तुम लोगों को कनान ले जा रहा हूँ। तुम लोगों को वह नहीं करना है जो उस देश में किया जाता है! ");
INSERT INTO hin2010_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","तम्हें मेरे नियमों का पालन करना चाहिए। और मेरे नियमों के अनुसार चलना चाहिए। उन नियमों के अनुसार चलना चाहिए। उन नियमों के पालन में सावधान रहो! क्यों? क्योंकि मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2010_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","इसलिए तुम्हें मेरे नियमों और निर्णयों का पालन करना चाहिए। यदि कोई व्यक्ति मेरे विधियों और नियमों का पालन करता है तो वह जीवित रहेगा! मैं यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“तुम्हें अपने निकट सम्बन्धियों से कभी यौन सम्बन्ध नहीं करना चाहिए। मैं यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“तुम्हें अपने पिता का अपमान नहीं करना चाहिए अर्थात् तुम्हें अपनी माता के साथ यौन सम्बन्ध नहीं करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","तुम्हें अपनी विमाता से भी यौन सम्बन्ध नहीं करना चाहिए। पिता की पत्नी से यौन सम्बन्ध केवल तुम्हारे पिता के लिए है। ");
INSERT INTO hin2010_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“तम्हें अपने पिता या माँ की पुत्री अर्थात् अपनी बहन से यौन सम्बन्ध नहीं करना चाहिए। इससे अन्तर नहीं पड़ता कि तुम्हारी उस बहन का पालन पोषण तुम्हारे घर हुआ या या किसी अन्य जगह। ");
INSERT INTO hin2010_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“तुम्हें अपने नाती पोतियों से यौन सम्बन्ध नहीं करना चाहिए। वे बच्चे तुम्हारे अंग हैं! ");
INSERT INTO hin2010_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“यदि तुम्हारे पिता और उनकी पत्नी की कोई पुत्री है तो वह तुम्हारी बहन है। तुम्हें उसके साथ यौन सम्बन्ध नहीं करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“अपने पिता की बहन के साथ तुम्हारा यौन सम्बन्ध नहीं होना चाहिए। वह तुम्हारे पिता के गोत्र की है। ");
INSERT INTO hin2010_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","तुम्हें अपनी माँ की बहन के साथ यौन सम्बन्ध नहीं करना चाहिए। वह तुम्हारी माँ के गोत्र की है। ");
INSERT INTO hin2010_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","तुम्हें अपने पिता के भाई का अपमान नहीं करना चाहिए अर्थात् उसकी पत्नी के साथ यौन सम्बन्ध के लिए नहीं जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“तुम्हें अपनी पुत्रवधू के साथ यौन सम्बन्ध नहीं करना चाहिए। वह तुम्हारे पुत्र की पत्नी है। तुम्हें उके साथ यौन सम्बन्ध नहीं करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“तुम्हें अपने भाई की वधू के साथ यौन सम्बन्ध नहीं करना चाहिए। यह अपने भाई के साथ यौन सम्बन्ध रखने जैसा होगा। केवल तुम्हारा भाई अपनी पत्नी के साथ यौन सम्बन्ध रक सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“तुम्हें किसी स्त्री और उसकी पुत्री के साथ यौन सम्बन्ध नहीं करना चाहिए और तुम्हें इस स्त्री की पोती से यौन सम्बनध नहीं रखना चाहिए। इससे अन्तर नीहं पड़ता कि वह पोती उस स्त्री के पुत्र की या पुत्री की बेटी है। उसकी पोतियाँ उसके गोत्र की हैं। उनके साथ यौन सम्बन्ध करना अनुचित है। ");
INSERT INTO hin2010_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“जब तक तुम्हारी पत्नी जीवित है, तुम्हें उसकी बहन को दूसरी पत्नी नहीं बनाना चाहीए। यह बहनों को परस्पर शत्रु बना देगा। तुम्हें अपनी पत्नी की बहन से यौन सम्बन्ध नहीं करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“तुम्हें किसी स्त्री के पास उसके मासिकधर्म के समय यौन सम्बन्ध के लिए नहीं जाना चाहिए। वह इस समय अशुद्ध है। ");
INSERT INTO hin2010_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“तुम्हें अपने पड़ोसी की पत्नी से यौन सम्बन्ध नहीं करना चाहिए। यह तुम्हें केवल अशुद्ध बनाएगा! ");
INSERT INTO hin2010_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“तुम्हें अपने किसी बच्चे को आग द्वारा मोलेक को भेंट नहीं चढाना चाहिए। यदि तुम ऐसा करते हो तो तुम यही दिखाते हो कि तुम अपने यहोवा के नाम का सम्मान नहीं करते! मैं यहोवा हूँ। ");
INSERT INTO hin2010_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“तुम्हें किसी पुरुष के साथ वैसा ही यौन सम्बन्ध नहीं करना चाहिए जैसा किसी स्त्री के साथ किया जाता है। यह भयंकर पाप है! ");
INSERT INTO hin2010_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“किसी जानवर के साथ तम्हारा यौन सम्बन्द नहीं होना चाहिए। यह क्वल तुम्हें घिनौना बना देगा! स्त्री को भी किसी जानवर के साथ यौन सम्बन्ध नहीं करना चाहिए। यह प्राकृति के विरुद्ध है! ");
INSERT INTO hin2010_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“इन अनुचित कामों में से किसी से अपनीको अशुद्ध न करो! मैं उन जातियों को उनके देश से बाहर कर रहा हूँ और मैं उनकी धरती तुम को दे रहा हूँ। क्यों? क्योंकि वे लोग वैसे भयंकर पाप करे हैं! ");
INSERT INTO hin2010_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","इसलिए वह देश अशुद्ध हो गया है! वह देश अब उन कामों से ऊब गाय है और वह देश उसमें रहेन वालों को बाहर निकाल फेंक रहा है! ");
INSERT INTO hin2010_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","“इसलिए तुम मेरे नियमों और निर्णयों का पालन करोगे। तुम्हें उन में से कोई भयंकर पाप नहीं करना चाहिए। ये नियम इस्राएल के नागरिकों और जो तम्हारे बीच रहते हैं, उनके लिए है। ");
INSERT INTO hin2010_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","जो लोग तुम से पहले वहाँ रहे उन्होंने वे सभी भयंकर काम किए। जिससे वह धरती गन्दी हो गयी। ");
INSERT INTO hin2010_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","यदि तुम भी वही काम करोगे तो तुम धरती को गंदा बनाओगे। यह तुम लोगों को वैसे ही निकाल बाहर करेगी, जैसे तुमसे पहले रहीन वाली चातियों को किया गया। ");
INSERT INTO hin2010_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","यदि कोई व्यक्ति वैसे भयंकर पाप करता है तो उस व्यक्ति को अपने लोगों से अलग कर दैना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","अन्य लोगों ने उन भयंकर पापों को किया है। किन्तु मेरे नियमों का पालन करना चाहिए। तुम्हें उन भयंकर पापों में से कोई भी नहीं करना चाहिए। उन भयंकर पापों से अपने को असुद्ध मत बनाओ। मैं तम्हारा परमेश्वर यहोवा हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“इस्राएल के सभी लोगों से कहोः कि मैं तुम्हारा परमेश्वर यहोवा हूँ मैं पवित्र हूँ! इसलिए तुम्हें पवित्र होना चाहिए! ");
INSERT INTO hin2010_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“तुम में से हर एक व्यक्ति को अपने माता पिता का सम्मान करना चाहिए और मेरे विश्राम के विशेष दिनों को मानना चाहिए। मैं तुम्हारा परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2010_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“मूर्तियों की उपासना मत करो। अनपे लिए देवताओं की मूर्तियों धातु गला कर मत बाओ। मैं तुम लोगों का परमेश्वर यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“जब तुम यहोवा को मेलबलि चढ़ाओ तो तो तुम उसे ऐसे चढ़ाओ कि तुम यहोवा द्वारा स्वीकार किए जा सको। ");
INSERT INTO hin2010_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","तुम इसे चढ़ाने के दिन खा सकोगे और अगले दिन भी । किन्तु यदि बलि का कुछ भाग तीसरे दिन भी बच जाए तो उसे उसे तुम्हें आग में जला देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","किसी भी बलि को तीसरे दिन नहीं खाना चाहिए। यह अशुद्ध है । यह स्वीकार नहीं होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","यदि कोई व्यक्ति ऐसा करात है तो वह अपारधी होगा। क्यों? क्योंकि उसने यहोवा की पविक्ष चीजों का सम्मान नीहं किया। उस व्यक्ति को अपने लोगों से अलग कर दिया जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“जब तुम कटनी के समय अपनी फ़सल काटो तो तुम सब ओस से खेत के कोनों तक मत काटो और यदि अन्न जमीन पर गिर जाता है तो तुम्हें उसे इकट्ठा नहीं करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","अपने अँगूर के बाग के सारे अंगूर न तोड़ो और जो जमीन पर गिर जाएँ उन्हें न उठाओ। क्यों? क्योंकि तुम्हें वे चीज़ें गरीब लोगों और जो तुम्हारे देश से यात्रा करेंगे, उनके लिए छोड़नी चाहिए। मैं तुम्हारा परमेश्वर यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“तुम्हें चोरी नहीं करनी चाहिए। तुम्हें लोगों को ठगना नहीं चाहिए। तुम्हें आपस में झूठ नहीं बोलना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","तुम्हें मेरे नाम पर झूठा वचन नहीं देना चाहिए। यदि तुन ऐसा करेत हो तो तुम यह दिखाते हो कि तुम अनपे परमेश्वर के नाम का सम्मान नहीं करते हो। मैं यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“तुम्हें अपने पड़ोसी को धोखा नहीं देना चाहिए। तुम्हें उसकी चोरी नहीं करनी चाहिए। तुम्हें मजदूर की मजदूरी पूरी रात, सवेरे तक नही रोकनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“तुम्हें किसी बहरे आदमी को अपशब्द नहीं कहना चाहिए। तुम्हें किसी अन्धे को गिराने के लिए उसके सामन कोई चीज नहीं रखनी चाहिए। किन्तु तुम्हें अपने परमेश्वर यहोवा का सम्मान करना चाहिए। मैं यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“तुम्हें न्याय करने मैं ईमानदार होना चाहिए। न तो तुम्हें ग़रीब के साथ विशेष पक्षपात करना चाहिए और न ही बड़े एवं धनी लोगों के प्रति कोई आदर दिखाना चाहिए। तुम्हें अपे पड़ोसी के साथ न्याय करते समय ईमानदार होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","तुम्हें अन्य लोगों के विरुद्ध चारों ओर अफवाहें फैलाते हुए नहीं चलना चाहिए। ऐसा कुछ न करो जो तुम्हारे पड़ोसी के जीवन को खतरे में डाले। मैं यहोव हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“तुम्हें अपने हृदय में अपने भाईयों से घृणा नहीं करनी चाहिए। यदि तुम्हारा पड़ोसी कुछ बुरा करता है तो इसके बारे में उसे समझाओ। किन्तु उसे क्षमा करो! ");
INSERT INTO hin2010_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","लोग, जो तुम्हारा बुरा करें, उसे भुल जाओ। उससे बदला लेना का प्रयतन न करो। अपने पड़ोसी से वैसे ही प्रेम करो जैसे अनपे आप से करते हो। मैं यहोव हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“तुम्हें मेरे नियमों का पालन करना चाहिए। दो जातियों के पशुओं को प्रजनन के लिए आपस में मत मिलाओ। तुम्हें दो प्रकार के बीज नहीं बोने वस्त्रों को नहीं पहनना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“यह हो सकता है कि किसी दूसरे व्यक्ति की दासी से किसी व्यक्ति का यौन सम्बन्ध हो। यदि यह दासी न तो खरीदी गई है न ही स्वतन्त्र कराई गई है तो उन्हें दण्ड दिया जाना चाहिए। किन्तु वे मारे नहीं जाएंगे। क्यों? क्योंकि स्त्री स्वतन्त्र नहीं थी। ");
INSERT INTO hin2010_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","उस व्यक्ति को अपने अपराध के लिए मिलापवाले तम्बू के द्वार पर यहोवा को बलि चढ़ानी चाहिए। व्यक्ति को एक मेढ़ा दोषबलि के रूप में लाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","याजक उस व्यक्ति के पापों के भुगतान करने के लिए उपासना करेगा। याजक यहोवा को दोषबलि के रूप में मेढ़े को चढ़ाएगा। यह व्यक्ति के किए हुए पापों के लिए होगा। तब व्यक्ति अपने किए पाप के लिए क्षमा किया जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“भविष्य में तुम अपने प्रदेश में प्रवेश करोगे। उस समय भोजन के लिए तुम अनेकों प्रकार के पेड़ लगाओगे। पेड़ लगाने के बाद पेड़ के किसी फल का उपयोगकरने का लिए तुम्हें तीन वर्ष तक प्रतीक्षा करनी चाहिए। तुम्हें उससे पहले के फल का उपयोग नहीं करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","चौथे वर्ष उस पेड़ के फल यहोवा के होंगे। यह यहोवा की स्तुति के लिए पवित्र भेंट होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","तब, पाँचवें वर्ष तुम उस पेड़ का फल खासकते हो और पेड़ का फल खा सकते हो और पेड़ तुम्हारे लिए अधिक से अधिक फल पैदा करेगा। मैं तुम्हारा परमेश्वर यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“तुम्हें कोई चीज़, उसमें खून रहते तक नहीं खानी चाहिए। “तुम्हें भविष्यवाणी करने के लिये जादू या शगुन आदि का उपयोग नहीं करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“तुम्हें अपने सिर के बगल के बढ़े बालों कटवाना नहीं चाहिए. तुम्हें अपनी दाढ़ी के किनारे नहीं कटवाने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","किसी मरे व्यक्ति की याद को बनाए रखने के लिए तुम्हें अपने अपने शरीर को काटना नहीं चाहिए। तुम्हें अपने ऊपर कोई चिन्ह गुदवाना नहीं चाहिए में यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“तुम अपनी पुत्री को वेश्या मत बनने दै। इससे केवल यह पता चलता है कि तुम उसका आदर नहीं करते। तुम अनपे देश में स्त्रियों को वेश्याएँ मत बनने दो। तुम अपने देश को इस के पापों से मत भर जानेदो। ");
INSERT INTO hin2010_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“तुम्हें मेरे विश्राम के विशेष दिनों में काम नहीं करना चाहिए। तुम्हें मेरे पवित्र स्थान का सम्मान करना चाहिए। मैं यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ओझाओं तथा भूतसिद्धियों के पास सलाह के लिए मत जाओ। उनके पास तुम मत जाओ, वे केवल तुम्हें अशुद्ध बनाएँगें। में तुम्हारा परमेश्वर यहोवा हूँ!” ");
INSERT INTO hin2010_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“बूढ़े लोगों का सम्मान करो। जब वे कमरे में आएँ तो खड़े हो जाओ। अपने परमेश्वर का सम्मान करो। मैं यहोवा हूँ!” ");
INSERT INTO hin2010_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“अपने देश में रहने वला विदेशियों के साथ बुरा व्यवहार मत करो! ");
INSERT INTO hin2010_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","तुम्हें विदेशियों के साथ वैसा ही व्यवहार करना चाहिए जैा तुम अपने नागरिकों के सात करते हो। तुम विदेशियों से वैसा प्यार करो जैसा अपने से करते हो। क्यों? क्योंकि तुम भी एक समय मिस्र में विदेशी थे। मैं तुम्हारा परमेशवर यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“तम्हें न्याय करते समय लोगों के प्रति ईमानदार होना चाहिए। तुम्हें चीज़ों के नापने और तौलने में ईमानदार होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","तुम्हारि टोकरियाँ ठीक माप की होनी चाहिए। तुम्हारे नापने के पात्रों में द्रव क ीउचित मात्रा आनी चाहिए। तुम्हारे तराजू और तुम्हारेबाट चीज़ों को ठीक तौलने वाले होने चाहिए। मैं तुम्हारा परमेश्वर यहोवा हूँ! मैं तुम्हें मिस्र देश से बहरा लाया! ");
INSERT INTO hin2010_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“तुम्हें मेरे सभी नियमों और निर्णयों को याद रखना चाहिए और तुम्हें उनका पालन करना चाहिए। मैं यहोवा हूँ!” ");
INSERT INTO hin2010_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“तुम्हें इस्राएल के लोगों से यह भी कहना चाहिए: तुम्हारे देश में कोई व्यक्ति अनपे बच्चों में से किसी को झूठे देवता मोलेक को दे सकता है। उस व्यक्ति को मार डालना चाहिए। इससे अन्तर नहीं पड़ता कि वह इस्राएल का नागरि है या इस्राएल में रहने वाला कोई विदेशी है, तुम्हें उस पत्थर फेंक फेंक कर मार जालना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","मैं उस व्यक्ति के विरुद्ध होऊँगा। मैं उसे उसके लोगों से अलग करूँगा। क्यों? क्योंकि उसने अपने बच्चों को मोलेक को दिया। उसने यह प्रकट किया कि वह मरे पवित्र नाम का सम्मान नहीं करता। उसने मरे पवित्र स्थान को अशुद्ध किया। ");
INSERT INTO hin2010_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","सम्भव है साधारण लोग उस व्यक्ति की उपेक्षा करे। सम्भव है वे उस व्यक्ति को न मारे जिसने बच्चों को मोलेक को दिया है। ");
INSERT INTO hin2010_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","किन्तु मैं उस व्यक्ति और उसके परिवार के विरुद्ध होऊँगा। मैं उसे उसके लोगों से अलग करुँगा मैं किसी भी ऐसे व्यक्ति को उसके लोगों से अलग करुँगा जो मेरे प्रति विश्वास नहीं रखता और मोलेक का अनुसरण करता है। ");
INSERT INTO hin2010_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“मैं उस व्यक्ति के विरुद्ध होऊँगा जो किसी ओझा और भूतसिद्धि के पास सलाह के लिए जाता है। वह व्यक्ति मुझसे विश्वासघात करता है। इसलिए मैं उस व्यक्ति को उसके लोगों से अलग करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“विशेष बनो। अपने को पवित्र बनाओ। क्यों? क्योंकि मैं पवित्र हूँ! मैं तुम्हारा परमेश्वर यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","मेरे आज्ञाओं का पान करो और उन्हें याद रखो। मैं योहवा हूँ और मैंने तुम्हें अपना विशेष लोग बनाया है। ");
INSERT INTO hin2010_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“यदि कोई व्यक्ति अपने माता पिता के अनिष्ट की कामना करता है तो उस व्यक्ति को मार डालना चाहिए। उसने अपने पिता या माँ का अनिष्ट चाहा है, इसलिए उसे दण्ड देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“यदि कोई व्यक्ति अपने पड़ोसी की पत्नी के साथ यौन सम्बन्ध करता है तो स्त्री और पुरुष दोनों अनैतिक सम्बन्ध के अपराधी हैं। इसलिए स्त्री और पुरुष दोनों को मार डालना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","यदि कोई वयक्ति अपनी विमाता से यौन सम्बन्ध करता है तो उस व्यक्ति को मार डालना चाहिओए। उस व्यक्ति को और उसकी विमाता दोनों को मार डालना चाहिए। उस व्यक्ति ने अपने पिता के विरुद्ध पाप किया है। ");
INSERT INTO hin2010_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“यदि कोई व्यक्ति अपनी पुओत्रवधू के साथ यौनसम्बन्ध करता है तो दोनों को मार डालना चचाहिए। उन्होंने बहुत बुरा यौन पाप किया है। उन्हें दण्ड अवश्य मिलना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“यदि कोई व्यक्ति किसी पुरुष के साथ स्त्री जैसा यौन सम्बन्ध करता है तो दोनों को मार डालना चाहिए। उन्होंने बहुत बुरा यौन पाप किया है। उन्हें दण्ड अवश्य मिलना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“यदि कोई व्यक्ति किसी स्त्री और उसकी माँ के साथ यौन सम्बन्ध करता है तो यह यौन पाप है। लोगों को उस व्यक्ति तथा दोनों स्त्रियों को आग में जला देना चाहिए। इस यौन पाप को अपने लोगों में मत होने दो। ");
INSERT INTO hin2010_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“यदि कोई व्यक्ति किसी जानवर से यौन सम्बन्ध करे तो उस व्यक्ति को मार डालना चाहिए और तुम्हें उस जानवर को भी मार देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","यदि कोई स्त्री किसी जानवर से यौन सम्बन्ध करती है तो तुम्हें अवश्य मार देना चाहिए। उन्हें दण्ड अवश्य मिलना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“यह एक भाई और उसकी बहन के लिए लज्जाजनक है कि आपस में वे यौन सम्बन्ध करे। उन्हें सामाजिक रूप में दण्ड मिलना चाहिए। वे अपने लोगों से अलग कर दिए जाने चाहिए। वह व्यक्ति जिसने अपनी बहन के साथ यौन सम्बन्ध किया है, अपने पाप के लिए दण्ड पाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“यदि कोई व्यक्ति किसी स्त्री के साथ मासिकधर्म के रक्त स्राव के समय यौन सम्बन्ध करेगा तो स्त्री पुरुष दोनों को अपने लोगों से अलग कर देना चाहिए। उन्होंने पाप किया है क्योंकि उसने खून के स्रोत को उघाड़ा। ");
INSERT INTO hin2010_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“तुम्हें योन स्म्बन्ध अपनी माँ की बहन या पिता की बहन के साथ नहीं करना चाहिए। यह गोत्रीय अनैतिकता का पाप है। उन्हें उनके पाप के लिए दण्ड मिलागा। ");
INSERT INTO hin2010_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“किसी पुरुष को अपने चाचा मामा की पत्नी के सात नहीं सोना चाहिए। ह व्यक्ति तथा उसकी चाची वे मामी को उनके पापों के लिए दण्ड मिलेगा. वे बिना किसी सन्तान के मरेंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“किसी व्यक्ति के लिए यह बुरा है कि वह अपने भाई की पत्नी के साथ यौन सम्बन्ध करे। उस व्यक्ति ने अपने भाई के विरुद्ध पाप किया है। उनकी कोई सन्तान नहीं होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“तुम्हें मेरे सारे नियमों और निर्णयों को याद रखना चाहिए और तुम्हें उनका पालन अवश्य करना चाहिए। मैं तुम्हें तुम्हारे प्रदेश को ले जा रहा हूँ। तुम लोग उस प्रदेश में रहोगे। यदि तुम लोग मेरे नियमों और निर्णयों को मानते रहे तो वह प्रदेश तुम लोगों को निकाल बाहर नहीं करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","मैं अन्य लोगों को उस प्रदेश को छोड़ने के लिए विवश कर रहा हूँ। क्यों? क्योंकि उन लोगों ने वे सभी पाप किए। मैं उन पापों से घृणा करता हूँ। इसलिए जिस प्रकाकर वे लोगग रहे, उस तरह तुम नहीं रहोगे। ");
INSERT INTO hin2010_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","मैंने कहा है कि तुम उनका प्रदेश प्राप्त करोगे। मैं उनका प्रदेश तुमको दूँगा। यह तुम्हार प्रदेश होगा। वह प्रदेश बहुत सुन्दर है। उसमें दूध वे मधु की नदियाँ बहती हैं। मैं तुम्हारा परमेश्वर यहोवा हूँ! “मैंने तुम्हें विशेष बनाया है। मैंने तुम्हारे साथ अन्य लोगों से भिन्न व्यवहार किया है। ");
INSERT INTO hin2010_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","इसलिए तुम्हें शुद्ध जानवरों के साथ अशुद्ध जानवरों से भिन्न व्यवहार करना चाहिए। तुम्हें शुद्ध पक्षियों के साथ अशुद्ध पक्षियों से भिन्न व्यवहार करना चाहिए। उन में से किसी भी अशुद्ध पक्षी, जानवर और कीट पतंग को मत खाओ जो भूमि पर रेंगते हैं। मैंने उन चीज़ों को अशुद्ध बनाया है। ");
INSERT INTO hin2010_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","मैंने तुम्हें अपना विशेष जन बनाया है। इसलिए तुम्हें मेरे लिए पवित्र होना चाहिए। क्यों? क्योंकि मैं यहोवा हूँ और मैं पवित्र हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“कोई पुरुष या कोई स्त्री जो ओझा हो या कोई भूतसिद्धि हो, तो उन्हें निश्चय ही मार दिया जाना चाहिए। लोगों को चाहिए कि वे उन्हें पत्थर मार मार कर मार दें। उन्हें मार ही दिया जाना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","यहोवा ने मूसा से कहा, “ये बातें हारून के याजक पुत्रों से कहो: किसी मरे व्यक्ति को छूकर याजक अपने को अशुद्ध न करें। ");
INSERT INTO hin2010_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","किन्तु यदि मरा हुआ व्यक्ति उसके नजदीकी सम्बन्धियों मेसे कोई है तो वह मृतक के शरीर को छू सकता है। याजक अपने को अशुद्ध कर सकता है यदि मृत व्यक्ति उसकी माँ, पिता, उसका पुत्र, या पुत्री, उसका भाई, ");
INSERT INTO hin2010_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","उसकी अविवाहित बहन है। (यह बहन उसकी नजदीकी है क्योंकि उसका पति नहीं है। इसलिए याजक अपने को अशुद्ध कर सकता है, यदि वह मरती है।) ");
INSERT INTO hin2010_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","किन्तु याजक अपने को अशुद्ध नहीं कर सकता, यदि मरा व्यक्ति उसके दासों में से एक हो। ");
INSERT INTO hin2010_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“याजक को शोक प्रकट करने के लिए अपने सिर का मुण्डन नहीं कराना चाहिए। याजक को अपनी दाढ़ी के सिरे नहीं कटवाने चाहिए। याजक को अपने शरीर को कहीं भी काटननना नहीं चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","याजक को अपने परमेश्वर के लिए पवित्र होना चाहिए। उन्हें परमेश्वर के नाम के लिए सम्मान दिखाना चाहिए। क्यों क्योंकि वे रोटी और आग द्वारा भेंट यहोवा को पहुँचाते हैं। इसलिए उन्हें पवित्र होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“याजक परमेश्वर की सेवा विशेष ढंग से करता है। इलिए याजक को ऐसी स्त्री से विवाह नहीं करना चाहिए जिसने किसी के साथ यौन सम्बन्ध किया हो। याजक जिसने किसी के साथ यौन सम्बन्ध किया हो। याजक को किसी वेश्या, या किसी तलाक दी गी स्त्री से विवाह नहीं करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","याजक परमेश्वर की सेवा विशेष ढंग से करता है। इसलिए तुम्हें उसके साथ विशेष व्यवहार करना चाहिए। क्यों क्योंकि वह पवित्र चीज़ें ले चलता है। वह पवित्र रोटी यहोवा को पहुँचता है ले चलता है। वह पवित्र रोटी यहोवा को पहुँचता है और मैं पवित्र हूँ। मैं यहोवा हूँ, और में तुम्हें पवित्र बनाता हूँ। ");
INSERT INTO hin2010_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“यदि याजक की पुत्री वेश्या बन जाती है तो वह अपनी प्रतिष्ठा नष्ट करती है तथा अपने पिता को कलंक लगाती है। इसलिए उसे जला देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“महायाज अपने भाईयों में से चुना जाता था। अभिषेक का तेल उसके सिर उसके सिर पर डाला जाता था। इस प्रकार वह माहायाजक के विशेष कर्त्तव्य के लिए नियुक्त किया जाता था। वह महायाजक के विशेष वस्त्र को पहनने के लिए चुना जाता था। इसलिए उसे अपने दुःख को प्रकट करने वाला कोई काम समाज में नहीं करना चाहिए। उसे अपने बाल जंगली ढंग से नहीं बिखेरने चाहिए। उसे अपने वस्त्र नहीं फाड़ने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","उसे मुर्दे को छूकर अपने को अशुद्ध नहीं बनाना चाहिए। उसे किसी मुर्दे के पास नहीं जाना चाहिए। चाहे वह उसके अपने माता—पिता का ही क्यों न हो। ");
INSERT INTO hin2010_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","महायाजक को परमेश्वर के पवित्र स्थान के बाहर नहीं जाना चाहिए। यदि उसने ऐसा किया तो वह अशुद्ध हो जायेगा और तब वह परमेश्वर के पवित्र स्थान को असुद्ध कर देगा। अभिषेक का तेल महायाजक के सिर पर डाला जाता था। यह उसे शेष लोगों से भिन्न करता था। मैं यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“महायाजक को विवाह करके उसे पत्नी बनाना चाहिए जो कुवाँरी हो । ");
INSERT INTO hin2010_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","महायाजक को ऐसी सत्री से विवाह नहीं करना चाहिए जो किसी अन्य पुरुष के साथ यौन सम्बन्ध रख चुकी हो। महायजक को किसी वेश्या, या तलाक दी गई स्त्री, या विधवा स्त्री से विवाह नहीं करना चाहिए। महायाजक को अपने लोगों में से एक कुवाँरी से विवाह करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","इस प्रकार लोग उसके बच्चों को सम्मान देंगे। मैं, यहोवा ने, याजक को विशेष काम के लिए भिन्न बनाया है।” ");
INSERT INTO hin2010_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“हारून से कहो: यदि तुम्हारे वंशजों की सन्तानों में से कोई अपने में कोई दोष पाए तो उन्हें विशेष रोटी परमेश्वर तक नहीं ले जानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","कोई व्यक्ति जिसमें कोई दोष हो, याजक का काम न करे और न ही मरे पास भेंटट लाए, ये लोग याजक के रूप में सेवा नहीं कर सकते: अन्धे व्यक्ति, लगंड़े व्यक्ति, विकृत चेहरे वाले व्यक्ति, अत्यधिक लम्बी भुजा और टाँग वाले व्यक्ति। ");
INSERT INTO hin2010_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","टूटे पैर या हाथ वाले व्यक्ति, ");
INSERT INTO hin2010_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","कुबड़े व्यक्ति, बौने, आँख में दोष वाले व्यक्ति,। खुजली और चर्म रोग वाले व्यक्ति बधिया किए गे नपुंसक व्यक्ति। ");
INSERT INTO hin2010_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","“यदि हारून के वंशजों मे से कोई कुछ दोष वाला है तो वह यहोवा को आग से बलि नहीं चढ़ा सकता और वह व्यक्ति विशेष रोटी अपने परमेश्वर को नहीं पहुँचा सकता। ");
INSERT INTO hin2010_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","वह व्यक्ति याजकों के पिरवार से है अतः वह पवित्र रोचटी खा सकता है। वह अती पवित्र रोटी बी खा सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","किन्तु वह सबसे अधिक पवित्र स्थान में पर्दे से होकर नहीं जा सकता और न ही वह वेदी के पास जा सकता है। क्यों? क्योंकि उस में कुछ दोष है। उसे मेरे पवित्र स्थान को अपवित्र नहीं बनाना चाहिए। मैं यहोवा उन स्थानों को पवित्र बनाता हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","इसलिए मूसा ने ये बातें हारून से, हारून के पुत्रों और इस्राएल के सभी लोगों से कही। ");
INSERT INTO hin2010_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","परमेश्वर यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“हारून और उसके पुत्रों से कहोः इस्राएल के लोग जो चीज़ें मुझे देंगे, वे पवित्र हो जाएंगी। वे मेरी हैं। इसलिए तुम याजकों को वे चीज़ें नहीं लेनी चाहिए। यदि तुम उन उन पवित्र चीज़ों का उपयोग करते हो तो तुम यह प्रकट करोगे कि तुम मेरे पवित्र नाम का सम्मान नहीं करते। मैं यहोवा हूँ। ");
INSERT INTO hin2010_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","यदि तुम्हारे सभी वंशजो में से कोई व्यक्ति उन चीज़ों को छूएगा तो वह अशुद्ध हो जाएगा। वह व्यक्ति मुझसे अलग हो जाएगा। इस्राएल के लोगों ने वे चीजें मुझे दीं। मैं यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“यदि हारून के किसी वंशज को बुरे चर्म रोगों में से कोई रोग हो या उससे कुछ रिस रहा हो तो वह तब तक पवित्र भोजन नहीं कर सकता जब तक वह शुद्ध न हो जाए। यह नियम किसी भी याजक के लिए है जो अशुद्ध हो। वह याजक किसी शव को छू कर या अपने वीर्य पात से अशुद्ध हो सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","वह तब अशुद्ध हो सकता है जब वह किसी रेंगने वाले जानवर को छूए। वह तब अशुद्ध हो सकात है जब वह किसी अशुद्ध व्यक्ति को छूए। इसका कोई महत्व नहीं कि उस व्यक्ति को किस चीज़ ने अशुद्ध किया है। ");
INSERT INTO hin2010_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","यदि कोई व्यक्ति उन चीज़ों को छूएगा तो वह सन्ध्या तक अशुद्ध रहेगा। उस व्यक्ति को पवित्र भोजन में स् कुछ भी नहीं खाना चाहिए। पानी डालकर नहाये बिना वह पवित्र बोजन नहीं कर सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","पवह सूरज के डूबने पर ही शुद्ध होगा। तभी वह पवित्र भोजन कर सकता है। क्यों? क्योंकि वह भोजन उसका है। ");
INSERT INTO hin2010_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","“यदि याजक को कोई ऐसा जानवर मिलता है जो स्वयं मर गया हो या किसी अन्य जानवर द्वारा मार दिया गया हो तो उसे मरे जानवर को नहीं खाना चाहिए। यदि वह व्यक्ति उस जानवर को खाता है तो वह अशुद्ध होगा। मैं यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“याजक को मेरी सेवा के विशेष समय रखने होंगे। उन्हें उन दिनों सावधान रहना होगा। उन्हें इस बात के लिए सावधान रहना होगा कि वे पवित्र चीज़ों को अपवित्र न बनाएँ। यदि वे सावधान रहेंगे तो मरेंगे नहीं। मैं यहोवा ने उन्हें इस विशेष काम के लिए दूसरों से भिन्न किया है। ");
INSERT INTO hin2010_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","केवल याजकों के परिवार के व्यक्ति ही पवित्र भोजन खा सकते हैं। याजक के साथ ठहरने वाला अतिथि या मजदूर पवित्र भोजन में से कुछ भी नहीं खाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","किन्तु यदि याजक अपने धन से किसी दास को खरीदता है तो वह पवित्र चीज़ों में से कुछ को खा सकता है और याजक केक घर में उत्पन्न दास भी उस पवित्र भोजन में से कुछ खा सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","किसी याजक की पुत्री ऐसे व्यक्ति से विवाह कर सकती है जो याजक न हो। यदि वह ऐसा करती है तो पवत्र भेंट में से कुछ नहीं का सकती। ");
INSERT INTO hin2010_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","किसी याजक की पुत्री विधवा हो सकती है, या उसे तलाक जासकता है। यदि उके भरन पोषण के लिए उसके बच्चे नहीं हैं और वह अपने पिता के यहाँ लौटती है, जहाँ वह बचपन में रही है तो वह पिता के भोजन मेंस कुछ खा सकती है। किन्तु केवल याजक के परिवार के व्यक्ति ही इस भोजन को खा सकते हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“कोई व्यक्ति भूल से कुछ पवित्र भोजन खा सकता है। उस व्यक्ति को वह पवित्र भोजन याजक को देना चाहिए और उसके अतिरिक्त उस भोजन के मूल्य का पाँचवाँ भाग उसे और देना होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","“इस्राएल के लोग यहोवा को भेंट चढ़ाएँगे। वे भेटें पवित्र हो जाती हैं। इसलिए याजक को उन पवित्र चीज़ों को अपवित्र नहीं बनाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","यदि याजक उन चीज़ों को अपवित्र समझते हैं तो वे तब अपने पाप को बढ़ाएँगे जब पवित्र भोजन को खाएँगे। मैं, यहोवा उन्हें पवित्र बनाता हूँ!” ");
INSERT INTO hin2010_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“हारून और उसके पुत्रों, और इस्राएल के सभी लोगों से कहो: सम्भव है कि इस्राएल का कोई नागरिक या कोई विदेशी को ई भेंट लाना चाहे। सम्भव है उसने कई विशेष वचन दिया हौ, और ह उसके लिए हो। या सम्भव है यह वह विशेष भेंट हो जिसे वह व्यक्ति अर्पित करना चाहेता हो। ");
INSERT INTO hin2010_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","20","ये ऐसी भेटें हैं जिन्हें लोग इसलिए लाते हैं कि वे यहोवा भेंट चढ़ाना चहते हैं। तुम्हें कोई ऐसी भेंट नहीं स्वीकार करनी चाहिए जिसमें कोई दोष हो। मैं उस भेंट से प्रसन्न नहीं होऊँगा! यदि भेंट एक साँड़ है, या एक भेड़ है, या एक बकरा है तो वह नर होना चाहिए और इसमें कोई दोष नहीं होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“कोई वयक्ति यहोवा को मलेबलि चढ़ा सकता है। वह मेलबलि उस व्यक्ति द्वारा दिए गए किसी वचन के लिए भेंट के रूप में हो सकती है या यह कोई स्वत: प्रेरित भेंट हो सकती है जसे वह व्यक्ति यहोवा को चढ़ाना चाहता है। यह बैल या मेढ़ा हो सकता है। किन्तु वह स्वस्थ तथा दोष रहित होना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","तुम्हें यहोवा कोऐसा कोई जानवर नहीं भेंट करना चाहिए जो अन्धा हो या जिसकी हड्डियाँ टूटी हों, या जो लंगड़ा हो, या जिसका कोई घाव रिस रहा हो या बुरे चर्म रोग वाला हो। तुम्हें यहोवा की वेदी की आग पर उस बिमार जानवर की भेंट नहीं चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","“कभी कभी किसी मवेशी या मेमने के पैर अत्याधिक लम्बे हो सकते हैं या ऐसे पैर हो सकते हैं जिनका विकास ठीक से न हुआ हो। यदि कोई व्यक्ति ऐसे जानवर को यहोवा को विशेष भेंट के रुप में चढ़ाना चाहता है तो वह स्वीकार किया जाएगा। किन्तु इसे किसी व्यक्ति द्वारा दिए गए वचन के लिए किये जाने वाले भुगतान के रुप में स्वीकार नहीं किया जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","“यदि जानवर के अण्ड कोष जख्मी, कुचले हुए या फाड़े हूए हों तो तुम्हें उस जानवर की भेंट यहोवा को नहीं चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“तुम्हें विदेशियों से बलि के लिए ऐसे जडानवरों को नहीं लेना चाहिए। क्यों? क्योंकि ये जानवर किसी प्रकार चोट खाए हुए हैं। उनमें कुच दोष है। ये स्वीकार नहीं किए जाएंगे।” ");
INSERT INTO hin2010_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“जब को ई बछड़ा या भेड़ या बकरी पैदा हो तो अपनी माँ के साथ उसे सात दिन रहने देना चाहिए। तब आठवें दिन और उसके बाद यह जानवर यहोवा को आग द्वारा दी जाने वाली बलि के रूप में स्वीकार किया जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","किन्तु तुम्हें उसी दिन उस जानवर और उसकी माँ को नहीं मारना चाहिए। यही नियम गाय और भेड़ों के लिए है। ");
INSERT INTO hin2010_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“यदि तुम्हें यहोवा को कोई विशेष कृतज्ञता बलि चढ़ानी हो तो तुम उस भेंट को चढ़ाने में स्वतन्त्र हो । किन्तु यह इस प्रकार करो कि वह परमेश्वर को प्रसन्न करे। ");
INSERT INTO hin2010_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","तुम्हें पूरा जानवर उसी दिन खा लेना चाहिए। तुम्हें अगली सुबह के लिए कुच भी माँस नहीं छोड़ना चाहिए। मैं यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“मेरे आदेशों को याद रखो और उनका पालन करो। मैं यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","मेरे पवित्र नाम का सम्मान करो! मुझे इस्राएल के लोगों के लिए बहुत विशिष्ट होवा चाहिए। मैं, यहोवा ने तुम्हें अपना विशेष लोग बनाया है। ");
INSERT INTO hin2010_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","मैं तुम्हें मिस्र से लाया। मैं तुम्हारा परमेश्वर बना। मैं यहोवा हूँ!” ");
INSERT INTO hin2010_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","यहोवा ने मूसा के कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“इस्राएल के लोगों से कहोः तुम यहोवा के निश्चित पर्वों को पवित्र घोषित करो। ये मेरे विशेष पवित्र दिन है: ");
INSERT INTO hin2010_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“छ: दिन काम करो। किन्तु सातवाँ दिन, आराम का एक विशेष दिन या पवित्र मिलन का दिन होगा। उस दिन तुम्हें कोई काम नहीं करना चाहिए। यह तुम्हारे सभी घरों में यहोवा का सब्त है। ");
INSERT INTO hin2010_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ये यहोवा के चुने हुए पवित्र दिन हैं। उनके लिए निश्चित समय पर तुम पवित्र सभाओं की घोषणा करोगे। ");
INSERT INTO hin2010_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","यहोवा का फसह पर्व पहले महीने की चौदह तारीख को सन्धया काल में प्रैंत: है। ");
INSERT INTO hin2010_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“उसी महीने की पन्द्रह तारीख को अख़मीरी मैदे के फुलकों का पर्व होगा। तुम सात दिन तक अखमीरी मैदे के फुलके खाओगे। ");
INSERT INTO hin2010_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","इस पर्व के पहले दिन तुम एक पवित्र सभा करोगे। उस दिन तुम्हें कोई काम नहीं करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","सात दिन तक तुम यहोवा को आग द्वारा बलि चढ़ाओगे। सातवें दिन एक पवित्र सभा होगी। उस दिन तुम्हें कोई काम नहीं करना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इस्राएल के लोगों से कहो: तुम उस धरती पर जाओगे जिसे मैं तुम्हें दूँगा। तुम उसकी फ़सल काटोगे। उस समय तुम्हें अपनी फ़सल की पहली पूली याजक के पास लानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","याजक पूली को यहोवा के सामने उत्तोलित करेगा। तब वह तुम्हारे लिए स्वीकार कर ली जाएगी। याजक पूली को रविवार के प्रात: काल उत्तोनित करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","“जिस दिन तुम पूली को उत्तोलित करो, उस दिन तुम एक वर्ष का एक नर मेमना बलि चढ़ाओगे। उस मेमने में कोई दोष नहीं होना चाहिए। वह मेमना यहोवा की होमबलि होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","तुम्हें चार क्वार्ट अच्छे जैतून के तेल मिले आटे की अन्नबलि देनी चाहिए। तुम्हें एक क्वार्ट दाखमधु भी देनी चाहिए। यह भेंट यहोवा को प्रसन्न करने वाली सुगन्ध होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","जब तक तुम अपने परमेश्वर को भेंट नहीं चढ़ाते, तब तक तुम्हें कोई नया अन्न, या फल या नये अन्न से बनी रोटी नहीं खानी चाहिए। यह नियम तुम चाहे जहाँ भी रहो, तुम्हारी पीढ़ी दर पीढ़ी चलता रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“उस रविवार के प्रातःकाल से (वह दिन जब तुम पूली उत्तोलन भेंट के लिए लाते हो), सात सप्ताह गिनो। ");
INSERT INTO hin2010_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","सातवें सप्ताह के अगले रविवार को (अर्थात् पचास दिन) बाद तुम यहोवा के लिए नये अन्नबलि लाओगे। ");
INSERT INTO hin2010_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","उस दिन तुम अपने घरों से दो—दो रोटियाँ लाओ। ये रोटियाँ उत्तोलन भेंट होगी। खमीर का उपयोग करो और चार क्वार्ट आटे की रोटियाँ बनाओ। वह तुम्हारी पहली फसल से यहोवा की भेंट होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","“लोगों से अन्नबलि के साथ में एक बछड़ा, दो मेढ़े और एक एक वर्ष के सात नर मेमने भेंट किए जाएंगे। इन जानवरों में कोई दोष नहीं होना चाहिए। ये यहोवा की होमबलि होंगे। वे आग द्वारा यहोवा को दी गई भेंट होगी। इस की सुगन्ध से यहोवा प्रसन्न होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","तुम भी पापबलि के रूप में एक बकरा तथा एक वर्ष के दो मेमने मेलबलि के रूप में चढ़ाओगे। ");
INSERT INTO hin2010_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","“याजक यहोवा के सामने उत्तोलन बलि के लिए दो मेमने और पहल फ़सल की रोटी उन्हें उत्तोलित करेगा। वे यहोवा के लिए पवित्र हैं। वे याजक के होंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","उसी दिन, तुम एक पवित्र सभा बुलाओगे। तुम कोई काम नहीं करोगे। यह नियम तुम्हारे सभी घरों में सदैव चलेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“जब तुम अपने खेतों की फ़सल काटो तो खेतों के कोनों की सारी फ़सल मत काटो। जो अन्न जमीन पर गिरे, उसे मत उठाओ। उसे तुम गरीब लोगों तथा तुम्हारे देश में यात्रा करने वाले विदेशियों के लिए छोड़ दो। मैं तुम्हारा परमेश्वर यहोवा हूँ!” ");
INSERT INTO hin2010_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","यहोवा ने मूसा से फिर कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इस्राएल के लोगों से कहो: सातवें महीने के प्रथम दिन तुम्हें आराम का विशेष दिन मानना चाहिए। उस दिन एक धर्म सभा होगी। तुम्हें इसे मनाने के लिए तुरही बजानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","तुम्हें कोई काम नहीं करना चाहिए। तुम यहोवा को आग द्वारा बलि चढ़ाने के लिए बलि लाओगे।” ");
INSERT INTO hin2010_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“सातवें महीने के दसवें दिन प्रायश्चित्त का दिन होगा। उस दिन एक धर्म सभा होगी। तुम भोजन नहीं करोगे और तुम यहोवा को आग द्वाराबलि चढ़ाओगे। ");
INSERT INTO hin2010_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","तुम उस दिन कोई काम नहीं करोगे। क्यों? क्योंकी यह प्रायश्चित का दिन है। उस दिन याजक यहोवा के सामने जाएगा और वह उपासना करेगा जो तुम्हें सुद्ध बनाती है। ");
INSERT INTO hin2010_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","“यदि कोई व्यक्ति उस दिन उपवास करेन से मना करता है तो उसे अपने लोगों से अलग कर देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","यदि कोई व्यक्ति उस दिन काम करेगा तो उसे मैं (परमेश्वर) उसके लोगों में से काट दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","तुम्हें कोई भी काम नहीं करना चाहिए। यह नियम तुम जहाँ कहीं बी काम नहीं करना चाहिए। यह नियम तुम जहाँ कहीं भी रहो, सदैव रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","यह तुम्हारे लिए आराम का विशे, दिन होगा। तुम्हें भोजन नहीं करना चाहिए। तुम आराम के इस विशेष दिन को महीने के नवें दिन की सन्ध्या से आरम्भ करोगे। यह आराम का विशेष दिन उस सन्ध्या से आरम्भ करके अगली सन्धया तक रहाता है।” ");
INSERT INTO hin2010_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","यहोवा ने मूसा से फिर कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“इस्राएल के लोगों से कहो: सातवें महीने के पन्द्रहनवें दिन आश्रय का पर्व होगा। यहोवा के लिए यह पवित्र सा दिन तक चलेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","पहले दिन एक धर्म सभा होगी। तुम्हें तब कोई काम नहीं करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","तुम सात दिनों तक यहोवा के लिए आग द्वारा बलि चढ़ाओगे। आठवें दिन तुम दूसरी धर्म सभा करोगे। तुम यहोवा को आग द्वारा बलि चढ़ाआगे। यह एक धर्म सभा होगी। तुम्हें तब कोई काम नहीं करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ये यहोवाच का विशेष पवित्र दिन है। उन दिनों धर्म सभाएँ होंगी। तुम यहोवा को होमबलि, अन्नबलि, बलियाँ, पेयबलि अग्नि द्वारा चढ़ाओगे। तुम वे बलियाण ठीक समय पर लाओगे। ");
INSERT INTO hin2010_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","तुम यहोवा के स्बत दिवसों को याद करने के अतिरिक्त उन पवित्र दिनोंका पर्व मनाओगे। तुम उन बलियों को यहोवा को अपनी अन्नबलि के अतिरिक्त दोगे। तुम विशेष दिए गे अपने वचन को पूरा करने के रूप में दी गई किसी भेंट के अतिरिक्त उन चीज़ों को दोगे। वे उन विशेष भेंटों के अतिरिक्ति होंगी जिन्हें तुम यहोवा को देना चाहते हो। ");
INSERT INTO hin2010_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“सातवें महीने के पन्द्रहवें दिन, जब तुम अपने खेतों से फसल ला चकोगे, सात दिन तक यहोवा का पर्व मनाओगे। तुम पहले और आठवें दिन आराम करोगे। ");
INSERT INTO hin2010_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","पहले दिन तुम फलदार पेड़ों से अच्छे फल लोगे और तुम नाले के किनारे के खजूर के पेड़, चीड़ और बेंत के पेड़ों से शाखाएँ लोगे। तुम अपने परमेश्वर यहोवा के सामने सात दिन तक पर्व मनाओगे। ");
INSERT INTO hin2010_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","तुम इस पवित्रदिन को हर वर्ष यहोवा के लिए सात दिनों तक मनाओगे। यह नियम सदैव रहेगा। तुम इस पवित्र दिन को सातवें महीने में मनाओगे। ");
INSERT INTO hin2010_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","तुम सात दिन तक अस्थायी आश्रयों में रहोगे। इस्राएल में उत्पन्न हुए सबी लोग उन आश्रयों में रहोगे। इस्राएल में उत्पन्न हुए सभी लोग उन आश्रयों में रहेंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","क्यों? इससे तुम्हारे सभी वंशज यह जानेंगे कि मैंने इस्राएल के लोगों को अस्थायी आश्रयों में रहने वाला उस समय बनाया जिस समय मैं उन्हें मिस्र से लाया। मैं तुम्हारा परमेश्वर यहोवा हूँ!” ");
INSERT INTO hin2010_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","इस प्रकार मूसा ने इस्राएल के लोगों को यहोवा के विशेष पवित्र दिनों के बारे में बताया। ");
INSERT INTO hin2010_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“इस्राएल के लोगों को कोल्हू से निकाला हुआ जैतून का शुद्ध तेल अपने पास लाने का आदेश दो। वह तेल दीपकों के लिए है। ये दीपक बिना बुझे जलते रहने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","हारून यहोवा के मिलापवाले तम्बू में साक्षीपत्र के पर्दे के आगे सन्ध्या समय से प्रातःकाल तक दीपकों को जलाये रखेगा। यह नियम सदा सदा के लिए है। ");
INSERT INTO hin2010_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","हारून को सोने की दीपाधार पर यहोवा के सामने दीपकों को सैव जलता हुआ रखना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“अच्छा महीन आटा लो और उसकी बारह रोटियाँ बनाओ। हर एक रोटी के लिए चारि क्वार्ट आटे का उपयोग करो। ");
INSERT INTO hin2010_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","उन्हें दो पँक्तियों में सुनहरी मेज़ पर यहोवा के सामने रखो। हर एक पँक्ति में छ: रोटियाँ होंगी। ");
INSERT INTO hin2010_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","हर एक पँक्ति पर शुद्ध लोबान रखो। यह यहोवा को आग द्वारा दी गई भेंट के सम्बन्ध में यहोवा को याद दिलाने में सहायता करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","हर एक सब्त दिवस को हारून रोटियों को यहोवा के सामने क्रम में रखेगा। इसे सदैव करना चाहिए। इस्राऐल के लोगों के साथ यह वाचा सदैव बनी रहेगी। ");
INSERT INTO hin2010_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","वह रोटी हारून और उसके पुत्रों की होगी। वे रोटियों को पवित्र स्थान में खायेंगे। क्यों?क्योंकि वह रोटी यहोवा को आग द्वारा चढ़ाई गी भेंटों में से है। वह रोटी सदैव हारून का हिस्सा है।” ");
INSERT INTO hin2010_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","एक इस्राएली स्त्री का पुत्र था। उसका पिता मिस्री था। इस्राएली स्त्री का यह पुत्र इस्राएली था। वह इस्राएली लोगों के बीच में घूम रहा था और उसने डेरे में लड़ना आरम्भ किया। ");
INSERT INTO hin2010_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","इस्राएली स्त्री के लड़के ने यहोवा के नाम के बारे मं बुरी बातें कहनी शुरू कीं। इसलिए लोग उस पुत्र को मूसा के सामने लाए। (लड़के की माँ का नाम शलोमीत था जो दान के परिवार समूह से दिब्री की पुत्री थी।) ");
INSERT INTO hin2010_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","लोगों ने लड़के को कैदी की तरह पकड़े रखा और तब तक प्रतीक्षा की, जब तक यहोवा का आदेश उन्हें स्पष्ट रूप से ज्ञात नहीं हो गया। ");
INSERT INTO hin2010_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“उस व्यक्ति को डेरे के बाहर एक स्थान पर लाओ, जिसने शाप दिया है। तब उन सभी लोगों को एक साथ बुलाओ जिन्होंने उसे शा देते सुना है। वे लोग एक साथ बुलाओ जिन्होंने उसे शाप देते सुना है। वे लोग अपने हाथ उसके सिर पर रखेंगे। और तब सभी लोग उस पर पत्थर मारेंगे और उसे मार डालेंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","तुम्हें इस्राएल के लोगों से कहना चाहिए: यदि कोई व्यक्ति अपने परमेश्वर को शाप देता है तो उस व्यक्ति को दण्ड मिलना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","कोई व्यक्ति, जो यहोवा के नाम के विरुद्ध बोलता है, अवश्य मार दिया जाना चाहिए। सभी लोगों को उसे पत्थर मारने चाहए। विदेशी को वैसे ही दण्ड मिलना चाहिए जैसे इस्राएल में जन्म लेने वाले व्यक्ति को मिलता है। यदि कोई व्यक्ति योहवा के नाम को अपश्ब्द कहता है तो उसे अवश्य मार देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“और यदि कोई व्यक्ति किसी दूसरे व्यक्ति को मार डालता है तो उसे अवश्य मार डालना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","यदि कोई व्यक्ति किसी व्यक्ति के जानवर को मार डालता है तो उसके बदले में उसे दसूरा जानवर देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“यदि कोई व्यक्ति अपने पड़ोस में किसी को चोट पहुँचाता है तो वसन व्यक्ति को उसी प्रकार की चोट उस व्यक्ति को पहुँचानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","एक टूटी हड्डी के लिए एक टूटी हड्डी, एक आँख के लिए एक आँख, और एक दाँत के लिए दाँत। उसी प्रकार की चोट उस व्यक्ति को पहुँचानी चाहिए, जैसा उसने दूसरे को पहुँचाई है। ");
INSERT INTO hin2010_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","इसलिए जो व्यक्ति किसी दूसरे व्यक्ति के जानवर को मारे तो इसके बदनले में उसे दूसरा जानवर देना चाहिए। किन्तु जो व्यक्ति किसी दूसरे व्यक्ति को मार डालता है वह अवश्य मार डाला जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","“तुम्हारे लिए एक ही प्रकार का न्याया होगा। यह विदेशी और तुम्हारे अपने देशवासी के लिए समान होगा। क्योंकि मैं तुम्हारा परमेश्वर यहोवा हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","तब मूसा ने इस्राएल के लोगों से बात की और वे उस व्यक्ति को डेरे के बाहर एक स्तान पर लाए, जिसने शाप दिया था। तब उन्होंने उस पत्थरों से मार डाला। इस प्रकार इस्राएल के लोगों ने वह किया जो यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","यहोवा ने मूसा से सीनै पर्वत पर कहा। यहोवा ने कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“इस्राएल के लोगों से कहो, तुन लोग उस भूमि पर जाओगे जिसे मैं तुमको दे रहा हूँ। उस समय तुम्हें भूमि को आराम का विशेश समय देना चाहिए। यह यहोवा को सम्मान देने के लिए धरती के आराम का विशेष समय होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","तुम छ: वर्ष तक अपने खेतों में बीज बोओगे। तुम अपने अंगूर के बागों में छः वर्ष तक कटाई करोगे और उसके फल लाओगे। ");
INSERT INTO hin2010_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","किन्तु सातवें वर्ष तुम उस भूमि को आराम करने दोगे। यह यहोवा को सम्मान देने के लिए आराम का विशेष समय होगा। तुम्हें अपने खेतों में बीज नहीं बोना चाहिए और अँगूर के बागों में बेलों की कटाई नहीं करनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","तुम्हें उन फ़सलों की कटाई नहीं करनी चाहिए जो फ़सल काटने के बाद अपने आप उगती है। तुम्हें अपनी उन अँगूर की बेलों से अँगूर नहीं उतारने चाहिए जिनकी तुमने कटाई नहीं की है। यह भूमि के विश्राम का वर्ष होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","“यह भूमि के विश्राम का वर्ष होगा, किन्तु तुम्हारे पास फिर भी पर्याप्त भोजन रहेगा। तुम्हारे पुरुष व स्त्री दासों के लिए पर्याप्त भोजन रहेगा। मज़दूरी पर रखे गए तुम्हारे मजदूर और तुम्हारे देश में रहने वाले विदेशियों के लिए भोजन रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","तुम्हारे मवेशियों और अन्य जानवरों के खाने के लिए पर्याप्त चारा होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“तुम सात वर्षों के सात समूहों को गिनोगे। ये उन्नचास वर्ष होंगें। इस समय के भीतर भूमि के लिए सात वर्ष आराम के होंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","प्रायश्चित के दिन तुम्हें मेढ़े का सींग बजाना चाहिए। वह सातवें महीने के दसवें दिन होगा। तुम्हें पूरे देश मं मेढ़े का सींगा बजाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","तुम पचासवें वर्ष को विशेष वर्ष मनाओगे। तुम अपने देश रहने वाले सभी लोगों की स्वतन्त्रता घोषित करोगे। इस समय को “जुबली मुक्तिवर्ष” कहा जाएगा। तुममें से हर एक को उसकी धरती लौटा दी जाएगी। और तुममें से हर एक अपने परिवार में लौट जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","पचासवाँ वर्ष तुम्हारे लिए विशेष उत्सव का वर्ष होगा। उस वर्ष तुम बीज मत बोओ। अपने आप उगी फसल न काटो। अँगूर की उन बलों से अँगूर मत लो। ");
INSERT INTO hin2010_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","वह जुबली वर्ष है। यह तुम्हारे लिए पवित्र समय होगा। तुम उस पैदावार को खाओगे जो तुम्हारे खेतों से आती है। ");
INSERT INTO hin2010_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","जुबली वर्ष में हर एक व्यक्ति को उसकी धरती वापस हो जाएगी। ");
INSERT INTO hin2010_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“किसी व्यक्ति को अपनी भूमि बेचन में मत ठगो और जब तुम उससे भूमि खरीदो तब उसे अपने को मत ठगने दौ। ");
INSERT INTO hin2010_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","यदि तुम किसी की भूमि खरीदना चाहते हो तो पिछले जुबली से काल गणना करो और उस गणना का उपयोग धरती का ठीक मूल्य तय करने के लिए करो। यदि तुम भूमि को बेचो, तो फसलों के काटने के वर्षों को गिनो और वर्षों की उस गणना का का उयोग ठीक मूल्य तय करने के लिए करो। ");
INSERT INTO hin2010_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","यदि अधिक वर्ष हैं तो मूल्य ऊँचा होगा। यदि वर्ष थोड़े हैं तो मूल्य कम करो। क्यों? क्योंकि वह व्यक्ति तुमको सचमुच कुछ वर्षों की कुछ फसलें ही बेच रहा है। अगली जुबली पर भूमि उसके परिवारों की हो जाएगी। ");
INSERT INTO hin2010_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","तुम्हें एक दूसरे को ठगना नहीं चाहिए। तुम्हें अपने परमेश्वर का सम्मान करना चाहिए। मैं तुम्हारे परमेश्वर यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“मेरे नियमों और निर्णयों को याद रखो। उनका पालन करो। तब तुम अपने देश में सुरक्षित रहोगा। ");
INSERT INTO hin2010_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","भूबमि तुम्हारे लिए उत्तम फ़सल पैदा करेगी। तब तुम्हारे पास बहुत अधिक भोजन होगा और तुम अपने प्रदेश में सुरक्षित रहोगे। ");
INSERT INTO hin2010_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“किन्तु कदाचित तुम यह कहो, ‘यदि हम बीज न बोए या अपनी फ़सलें न इकट्ठी करें तो सातवें वर्ष हम लोगों के लिए खाने को कुछ भी नहीं रहेगा।’ ");
INSERT INTO hin2010_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","चिन्ता मत करो। मैं छठे वर्ष में अपनी आशीष को तुम्हारे पास आने का आदेश दूँगा। भूमि तीन वर्ष तक फ़सल पैदा करती रहेगी। ");
INSERT INTO hin2010_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","जब आठवें वर्ष तुम बोओगे तब तक फसल पैदा करती रहेगी। तुम पुरानी पैदावार को नवें वर्ष तक खाते रहोगे जब आठवें वर्ष बोयी हुई फ़सल घरों में आ जाएगी। ");
INSERT INTO hin2010_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“भूमि वस्तुत: मेरी है। इसलइए तुम इसे स्थायी रूप में नहीं बेच सकते। तुम मेरे साथ मेरी भूमि पर केवल विदेशी और यात्री के रूप में रह रहे हो। ");
INSERT INTO hin2010_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","कोई व्यक्ति अपनी भूमि बेच सकता है, किन्तु उसका परिवार सदैव अपनी भूमि वापस पाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","कोई व्यक्ति तुम्हारे देश में बहुत गरीब हो सकात है। वह इतना गरीब हो सकता कि उसे अपनी सम्पत्ति बेचनी पड़े। ऐसी हालत में उसके नजदीकी रिश्तेदारों को आगे आना चाहिए और अपने रिश्तेदार के लिए वह सम्पत्ति वापस खरीदनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","किसी व्यक्ति का कोई ऐसा नजदीकी रिश्तेदार नहीं भी हो सकता है जो उसके लिए सम्पत्ति वापस खरीदे। कुन्तु हो सकता है वह स्वयं भूमि को वापस खरीदने के लिए पर्याप्त धन पा ले। ");
INSERT INTO hin2010_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","तो उसे जब से भूमि बिकी थी तब से वर्षों को गिनना चाहिए। उसे उस गणना का उपयोग, भूमि का मूल्य निश्चित करने के लिए करना चाहिए। तब उसे भूमि को वापस खरीदना चाहिए। तब भूमि फिर उसकी हो जाएगी। ");
INSERT INTO hin2010_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","किन्तु यदि वह व्यक्ति अपने लिए भूमि को वापस खरीदने के लिए पर्याप्त धन नहीं जुटा पाता तो जो कुछ उसने बेचा है वह स व्यक्ति के हाथ में जिसने उसे खरीदा है, जुबली पर्व के आने के हाथ में जिसने उसे खरीदा है, जुबली पर्व के आने तक रहेगा। तब उस विशेष उत्सव के समय भूमि प्रथम भूस्वामी के परिवार की हो जाएगी। इस प्रकार सम्पत्ति पुन: मूल अधिकारी परिवार की हो जाएगी। ");
INSERT INTO hin2010_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“यदि कोई व्यक्ति नगर परकोटे के भीतर अपना घर बेचता है तो घर के बेचे जाने के बाद एक वर्ष तक उसे वापस लेने का अधिकार होगा। घर को वापस लेने का उसका अधिकार एक वर्ष तक रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","किन्तु यदि घर का स्वामी एक पूरा वर्ष बीतने के पहले अपना घर वापस नहीं खरीदता है उसका और इसके वंशजों का हो जाता है। जुबली के समय प्रधम गृह स्वामी को वापस नहीं होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","बिना परकोटे वाले नगर खुले मैदान माने जाएंगे। अत: उन छोटे नगरों में बने हुए घर जुबली पर्व के समय प्रथम गृहस्वामि को वापस होंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“किन्तु लेवियों के नगर के बारे में: जो नगर लेवियों के अपने हैं, उनमें वे अपने घरों को किसी बी समय वापस खरीद सकते हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","यदि कोई व्यक्ति लेवी से कोई घर खरीदे तो लेवीयोंके नगर का वह घर फिर जुबली पर्व के समय लेवियों का हो जाएगा। क्यों? क्योंकि लेवी नगर के घर लेवी के परिवार समूह के लोगों के हैं। इस्राएल के लोगों ने उन नगरों को लेवी लोगों को दिया। ");
INSERT INTO hin2010_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","लेवी नगरों के चारों ओर के खेत और चरागाह बेचे नहीं जा सकते। वे खेत सदा के लिए लेवियों के हैं। ");
INSERT INTO hin2010_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“सम्भवत: तुम्हारे देश का कोई व्यक्ति इतना अधिक गरीब होत जाए कि अपना भरण पोषण न कर सके। तुम उसे एक अतिथि की तरह जीवित रखोगे। ");
INSERT INTO hin2010_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","उसे दिए गए अपने कर्ज पर कोई सूद मत लो। अपने परमेश्वर का सम्मान करो और अपने भाई को अपने साथ रहने दो। ");
INSERT INTO hin2010_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","उसे सूद कपर पैसा उधार मत दो। जो भोजन वह करे, उस पर कोई लाभ लेने का प्रयत्न मत करो। ");
INSERT INTO hin2010_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","मैं तुम्हारा परमेश्वर यहोवा हूँ। मैं तुम्हें मिस्र देश से कनान प्रदेश देने और तुम्हारा परमेश्वर बनने के लिए बाहर लाया। ");
INSERT INTO hin2010_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“सम्भवत: तुम्हारा कोई बन्धु इतना गरीब हो जाय कि वह दास के रूप में तुम्हें अपने को बेच। तुम्हें उससे दास की तरह काम नहीं लेना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","वह जुबली वर्ष तक मजदूर और एक अतिथि की तरह तुम्हारे सात रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","तब वह तुम्हें छोड़ सकता है। वह अपने बच्चों को अपने साथ ले जा सकता है और अपने पिरवार में लौट सकता है। वह अपने पूर्वजों की सम्पत्ति को लौटा सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","क्यों? क्योंकि वे मेरे सेवक हैं। मैंने उन्हें मिस्र की दासता से मुक्त किया। वे फिर दास नहीं होने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","तुम्हें ऐसे व्यक्ति पर क्रूरता से शासन नहीं करना चाहिए। तुम्हें अपने परमेश्वर का सम्मान करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“तुम्हारे दास दासियों के बारे में: तुम अपे चारों ओर के अन्य राष्ट्रों से दास दासियाँ ले सकते हो। ");
INSERT INTO hin2010_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","यदि तुम्हारे देश में रहिने वले विदेशियों के परिवारों के बच्चे तुम्हारे पास आते हैं तो तुम उन्हें भी दास रख सकते हो। वे बच्चे तुम्हारे दास होंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","तुम इन विदेशी दासों को अपने बच्चों को भी दे सकते हो जो तुम्हारे मरने के बाद तुम्हारे बच्चों के होंगे। वे सदा के लिए तुम्हारे दास रहेंगे। तुम इन विदेशियों को दास बना सकते हो। किन्तु तुम्हें अपने भाईयों, इस्राएल के लोगों पर क्रूरता से शासन नहीं करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“सम्भव है कि कोई विदेशी यात्री या अतिथि तुम्हारे बीच धनी हो जाय। सम्भव है कि तुम्हारे देश का कोई व्यक्ति इतना गरीब हो जाय कि वह अपने को तुम्हारे बीच रहने वाले किसी विदेशी या विदेशी या विदेशी परिवार के सदस्य को दास के रूप में बेचे। ");
INSERT INTO hin2010_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","वह व्यक्ति वापस खरीदे जाने और स्वतन्त्र होने का अधिकारी होगा। उसके भाईयों में से कोई भी उसे वास खरीद सकता है ");
INSERT INTO hin2010_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","अथवा उसके चाचा, मामा वे चचेरे, ममेरे भाई उसे वापस खरीद सकते हैं या उसके नजदीकी रिश्तेदारों में से उसे कोई खरीद सकता है अथवा यदि व्यक्ति पर्याप्त धन पाता है तो स्वयं धन देकर वह फिर मुक्त हो सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","“तुम उसका मूल्य कैसे निश्चित करोगे? विदेशी के पास जब से उसने अपने को बचा है तब से अगली जुबली तक के वर्षों को तुम गिनोगे। उस गणना का उपयोग मूल्य निश्चित करने में करो। क्यों? क्योंकि वस्तुत: उस व्यक्ति ने कुछ वर्षों के लिए उसे ‘मजदूरी’ पर रखा। ");
INSERT INTO hin2010_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","यदि जुबली के वर्ष के पूर्व कई वर्ष हो तो व्यक्ति को मूल्य का बड़ा हिस्सा लौटाना चाहिए। यह उन वर्षों की संख्या पर आधारित है। ");
INSERT INTO hin2010_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","यदि जुबली के वर्ष तक कुछ ही वर्ष शेष हो तो व्यक्ति को मूल कीमत का थोड़ा सा भाग ही लौटाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","किन्तु वह व्यक्ति प्रति वर्ष विदेशी के यहाँ मजदूर की तरह रहेगा, विदेशी को उस व्यक्ति पर क्रूरता से शासन न करने दो। ");
INSERT INTO hin2010_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“वह व्यक्ति किसी के द्वारा वापस न खरीदे जाने पर भी मुक्त होगा। जुबली के वर्ष वह तथा उसके बच्चे मुक्त हो जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","क्यों? क्योंकि इस्राएल के लोग मेरे दास हैं। वे मेरे सेवक हैं। मैंने मिस्र की दासता से उन्हें मुक्त किया। मैं तुम्हारा परमेश्वर यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“अपने मूर्तियाँ मत बनाओ। मूर्तियाँ या यादगार के पत्थर स्थापित मत करो। अपने देश में उपासना करने के लिए पत्थर की मूर्तियाँ स्थापित न करो। क्यों कियोंकि मैं तुम्हारा परमेश्वर यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“मेरे आराम के विशेष दिनों को याद रखो और मेरे पवित्र स्थान का सम्मान करो। मैं यहोवा हूँ! ");
INSERT INTO hin2010_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“मेरे नियमों और आदेशों को याद रखो और उनका पालन कोर। ");
INSERT INTO hin2010_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","यदि तुम ऐसा करोगे तो मैं जिस समय वर्षा आनी चाहिए, उसी समय वर्षा कराऊँगा। भूमि फ़सलें पैदा करेंगी और पेड़ अपने फवल देंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","तुम्हारा अनाज निकालने का काम तब तक जलेगा जब तक अँगूर इकट्ठा करने का समय आएगा और अँगूर का इकट्ठा करना तब तक चलेगा जब तक बोने का समय आएगा। तब तुम्हारे पास खाने के लिए बहुत होगा, और तुम अपने प्रदेश में सुरक्षित रहोगे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","में तुम्हारे देश को शान्ति दूँगा। तुम शान्ति से सो सकोगे। कोई वयक्ति भयभीत करने नहीं आएगा। मैं विनाशकारी जानवरों को तुम्हारे देश से बाहर रखूँगा। और सेनाएँ तुम्हारे देश से नहीं गुजरेंगी। ");
INSERT INTO hin2010_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","“तुम अपने शत्रुओं को पीछा करके भाओगे और उन्हें रहाओगे। तुम उन्हें अपनी तलवार से मार डालोगे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","तुम्हारे पाँच व्यक्ति सौ व्यक्तियों को पीछा कर के भगाएंगे और तुम्हारे सौ व्यक्ति हजार व्यक्तियों का पीछा करेंगे। तुम अपने शुत्रओं को हराओगै और उन्हें तलवार से मार डालोगे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“तब मेंम तुम्हारी ओर मुड़ूँगा मैं तुम्हें बहुत से बच्चों वाला बनाऊँगा। मैं तुम्हारे साथ अपनी वाचा का पालन करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","तुम्हारे पास एक वर्ष से अधिक चलने वाली पर्याप्त पैदावार रहेगी। तुम नयी फसल काटोगे। किन्तु तब तुम्हें पुरानी पैदावार नयी पैदावार के लिए जगह बनाने हेतुत फेंकनी पड़ेगी। ");
INSERT INTO hin2010_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","तुम लोगों के बीच मैं अपना पवित्र तम्बू रखूँगा। मैं तुम लोगों से अलग नहीं होऊँगा। ");
INSERT INTO hin2010_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","में तुम्हारे साथ चलूँगा ");
INSERT INTO hin2010_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","और तुम्हारा परमेश्वर यहोवा हूँ तुम मिस्र में दास थे। किन्तु में तुम्हें मिस्र से बाहर लाया। तुम लोग दास के रूप में भारी बोझ ढोने से झुके हुए थे किन्तु मैंने तुम्हारे कंधों के जुंए को तोड़ फेंका। मैंने तुम्हें पुन: गर्व से चलने वाला बनया। ");
INSERT INTO hin2010_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“किन्तु यदि तुम मेरी आज्ञा का पालन नहीं करोगे और मरे ये सब आदेश नहीं मानोगे तो ये बुरी बातें होंगी। ");
INSERT INTO hin2010_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","यदि तुम मेरे नियमों और आदेशों को मानना अस्वीकार करते हो तो तुमने मेरी वाचा को तोड़ दिया है। ");
INSERT INTO hin2010_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","यदि तुम ऐसा करते हो तो मैं ऐसा करूँगा कि तुम्हारा भयंकर अनिष्ट होगा। मैं तुमको असाध्य रोग और तुम्हारा जीवन ले लेंगे। जब तुम अपने बीज बोओगे तो तुम्हें सफलता नहीं मिलेगी। तुम्हारी पैदावार तुम्हारे शुत्र खाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","मैं तुम्हारे विरुद्ध होऊँगा, अत: तुम्हारे शत्रु तुमको हराएँगे। वे शत्रु तुमसे घृणा करेंगे और तुम्हारे ऊपर शासन करेंगे। तुम तब भी भागोगेष जब तुम्हारा पीछा कोई न कर रहा होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“यदि इस के बाद भी तुम मेरी आज्ञा पालन नहीं करते हो तो मैं तुम्हारे पापों के लिए सात गुना अधिक दण्ड दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","मैं उन बड़े नगरों को भी नष्ट करूँगा जो तुम्हें गर्वीला बनाते हैं। आकाश वर्षा नहीं देगा और धरती पैदावार नहीं उत्पन्न करेगी। ");
INSERT INTO hin2010_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","तुम कठोर परिश्रम करोगा, किन्तु इससे कुछ भी नहीं होगा। तुम्हारी भूमि में कोई पैदावार नहीं होगी और तुम्हारे पेड़ों पर फल नहीं आएंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“यदि तब बी तुम मेरे विरुद्ध जाते हो और मेरी आज्ञा का पालन करना अस्वीकार करते हो तो मैं सात गुना कठोरता से मारूँगा। जितना अधिक पाप करोगे उतना अधिक दण्ड पाओगे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","मैं तुम्हारे विरुद्ध जंगली जानवरों को भेजूँगा। वे तुम्हारे बच्चों को तुमसे छीन ले जाएगें। वे तुम्हारे मवेशियों को नष्ट करेंगे। वे तुम्हारी संख्या बहुत कम कर देंगे। लोग यात्रा करने से भय खाएंगे, सड़कें खाली हो जाएंगी! ");
INSERT INTO hin2010_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“यदि उन चीज़ों के होने पर भी तुम्हें सबक नहीं मिलता और तुम मेरे विरुद्ध जाते हो, ");
INSERT INTO hin2010_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","तो मैं तुम्हारे विरुद्ध होऊँगा। मैं, हाँ, मैं (यहोवा), तुम्हारे पापों के लिए तुम्हें सात गुना दण्ड दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","तुमने मेरी वाचा तोड़ी है, अतः मैं तुम्हें दण्ड दूँगा। मैं तुम्हारे विरुद्ध सेनाएँ भेजूँगा। तुम सुरक्षा के लिए अपने नगरों में जाओगे। किन्तु मैं ऐसा करूँगा कि तुम लोगों में बीमारियाँ फैलें। तब तुम्हारे शत्रु तुमहे हराएंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","मैं उस नगर में छोड़े गे अन्न का एक भाग तुम्हें दूँगा। किन्तु खाने के लिए बहुत कम अन्न रहेगा। दस स्त्रियाँ अपनी सभी रोटी एक चूल्हे में पका सकेंगी। वे रोटी के हर एक टुकड़े को नापेंगी। तुम खओगे, किन्तु फिर भी भूखे रहोगे! ");
INSERT INTO hin2010_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“यदि तुम इतने पर भी मरी बातें सुनना अस्वीकार करते हो, और मेरे विरुद्ध रहते हो ");
INSERT INTO hin2010_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","तो मैं वस्तुत: अपना क्रोध प्रकट करूंगा! मैं, हाँ, मैं (यहोवा) तुम्हें तुम्हारे पापों के लिए सात गुना दण्ड दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","तुम अपने पुत्र पुत्रियों के शरीरों को खाओगे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","मैं तुम्हारे ऊँचे स्थानों को नष्ट करूँगा। मैं तुम्हारी सुगन्धित वेदियों को काट डालूँगा। मैं तुम्हारे शवों को तुमहारी निर्जीव मूर्तियों के शवों पर डालूँगा। तुम मुझको अत्यन्त घोनौने लगोगे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","मैं तुम्हारे नगरों को नष्ट करूँगा। मैं ऊँचे पवित्र स्थानों को खाली कर दूँगा। मैं तुम्हारी भेंटों की मधुर सुगन्ध को नहीं लूँगा। ");
INSERT INTO hin2010_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","मैं तुम्हारे देश को इतना खाली कर दूँगा की तुम्हारे शत्रु तक जो इसमें रहने आएंगे, वे इस पर चकित होंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","और मैं तुम्हें विभिन्न प्रदेशों में बिखेर दूँगा। मैं अपनी तलवार खीचूँगा और तुम्हें नष्ट करूँगा। तुमहारी भूमि ख़ाली हो जाएगी और तुम्हारे नगर उजाड़ हो जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“तुम अपने शत्रु के देशों में ले जाये जाओगे। तुमहारी धरती खाली हो जायेगी और वह अंत में उस विश्राम को पायेगी। ");
INSERT INTO hin2010_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","जिसे तुमने उसे तब नहीं दिया था जब तुम उस पर रहते थे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","बचे हुए व्यक्ति अपने शत्रुओं के देश में अपना साहस खो देंगे। वह हर चीज से भयभीत होंगे। वह हवा में उड़ती पत्ती की तरह चारोंम ओर भागेंगें। वे ऐसे भागेंगे मानों कोई तलवरा लिए उनका पीछा कर रहा हो। ");
INSERT INTO hin2010_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","वे एक दूसरे पर तब भी गिरेंगे जब कोई भी उनका पीछा नहीं कर रहा होगा। “तुम इतने शक्तिशाली नहीं रहोगे कि अपने शत्रुओं के मुकाबले खड़े रह सको। ");
INSERT INTO hin2010_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","तुम अन्य लोगों मेम विलीन हो जाओगे। तुम अपने शत्रुओं के देश में लुप्त हो जाओगे। ");
INSERT INTO hin2010_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","इस प्रकार तुमहारी सन्तानें तुम्हारे शत्रुओं के देश में अपने पापों में सड़ेंगी। वे अपने पापों में ठीक वैसे ही सड़ेंगी जैसे उनके पूर्वज सड़े। ");
INSERT INTO hin2010_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“सम्भव है कि लोग अपने पाप स्वीकार करें और वे अपने पूर्वजों के पापों को सवीकार करेंगे। सम्भव हे वे यह स्वीकार करें कि वे मेरे विरुद्ध हुए सम्भव है वे यह स्वीकार करें कि उन्होंने मेरे विरुद्ध पाप किया है। ");
INSERT INTO hin2010_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","सम्भव है कि वे स्वीकार करें कि मैं उनके विरुद्ध हुआ और उन्हें उनके शत्रुओं के देश में लाया। उन लोगों ने मेरे साथ अजनबी का सा व्यवहार किया। यदि वे विनम्र हो जाएं और अपने पापों के लिए दण्ड स्वीकर करें ");
INSERT INTO hin2010_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","तो मैं याकूब के साथ के अपनी वचा को याद करूँगा। इसहाक के साथ के अपनी वाचा को याद करुँगा। इब्राहिम के साथ की गी वाचा को मैं याद करूँगा और मैं उस भूमि को याद करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","“भूमि खाली रहेगी। भूमि आराम के साय का आनन्द लेगी। तब तुम्हारे बचे हुए लोग अपने पाप के लिए दण्ड स्वीकार करेगें। वे सीखेंगे कि उन्हें इसलिए दण्ड मिला कि उन्होंने मेर व्यवस्था से घृणा की और नियमों का पालन करना अस्वीकार किया। ");
INSERT INTO hin2010_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","उन्होंने सचमुच पाप किया। किन्तु यदि वे मेरे पास सहायता के लिए आते हैं तो मैं उनसे दूर नहीं रहूँगा। मैं उनकी बातें तब भी सुनूँगा जब वे अपने शत्रुओं के देश में भी होगें। मैं उन्हें पूरी तरह नष्ट नहीं करूँगा। मैं उके साथ अपनी वाचा को नहीं तोड़ूँगा। क्यों? क्योंकि में उनका परमेश्वर यहोवा हूँ। ");
INSERT INTO hin2010_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","मैं उनके पूर्वजों के साथ की गी वाचा को याद रखूँगा। मैं उनके पूर्वजों को इसलिए मिस्र स् बाहर लाया कि मैं उका परमेश्वर हो सकूँ। दूसरे राष्ट्रों ने उन बातों को देखा। मैं यहोवा हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","येवे विधियाँ, नियम और व्यवस्थाएं हैं जिन्हें यहोवा ने इस्राएल के लोगों को दिया। वे नियम इस्राएल केके लोगों और यहोवा के बीज वाचा है। यहोवा ने उन नियमों को सीनै पर्वत पर दिया था। उसने मूसा को नियम दिए और मूसा ने उन्हें लोगों को दिया। ");
INSERT INTO hin2010_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“इस्राएल के लोगों से कहो: कोई व्यक्ति यहोवा को विशेष वचन दे सकता है। वह व्यक्ति यहोवा को किसी व्यक्ति को अर्पित करने का वचन दे सकता है। वह व्यक्ति यहोवाक की सेवा विशेष ढंग से करेगा। याजक उस व्यक्ति के लिए विशेष मूल्य निश्चित करेगा। यदि लोग उसे यहोवा से वापस खरीदना चाहते हैं तो वे मूल्य देंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","बीस से साठ वर्ष तक की आयु के पुरुष का मूल्य पचास शेकेल चाणदी होगी। (तुम्हें चाँदी को तोलने के लिए पवित्र स्थान से प्रामाणिक शेकेल का उपयोग करना चाहिए।) ");
INSERT INTO hin2010_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","बीस से साठ वर्ष की आयु की स्त्री का मूल्य तीस शेकेल है। ");
INSERT INTO hin2010_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","पाँच से बीस वर्ष आयु के पुरुष का मूल्य बीस शेकेल है। पाँच से बीस वर्ष आयु की स्त्री का मूल्य दस शेकेल है। ");
INSERT INTO hin2010_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","एक महीने से पाँच महीने तक के बालक का मूल्य पाँच शेकेल है। एक बालिका का मूल्य तीन शेकेल है। ");
INSERT INTO hin2010_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","साठ या साठ से अधिक आयु के पुरूष का मूल्य पन्द्रह शेकेल है। एक स्त्री का मूल्य दस शेकेल है। ");
INSERT INTO hin2010_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“यदि व्यक्ति इतना गरीबत है कि मूल्य देने में असमर्थ है तो उस व्यक्ति को याजक के सामने लाओ। याजक यह निश्चित करेगा कि वह व्यक्ति कितना मूल्य भुगता में दे सकता है। ");
INSERT INTO hin2010_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“कुछ जानवरों का उपयोग यहोवा की बलि के रूप में किया जा सकता है। यदि कोई व्यक्ति उन जानवरों में से किसी को लाता है तो वह जानवर पवित्र हो जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","वह व्यक्ति यहोवा को उस जानवर को देने का वचन देता है। इसलिए उस व्यक्ति को उस जानवर के स्थान पर दूसरा जानवर रखने का प्रयत्न नहीं करना चाहिए। उसे अच्छे जानवर को बुरे जानवर से नहीं बदलना चाहिए। उसे बुरे जानवर को अच्छे जानवर से नहीं बदलना चाहिए। यदि वह व्यक्ति दोनों जानवरों को बदलना ही चाहता है तो दोनों जानवर पवित्र हो जाएगें। दोनों जानवर यहोवा के हो जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“कुछ जानवर यहोवा को बलि के रूप में नहीं भेंट किए जा सकेत। यदि कोई व्यक्ति उन अशुद्ध जानवरों में से किसी को यहोवा के लिए लाता है तो वह जानवर याजक के सामने लाया जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","याजक उस जानवर का मूल्य निश्चित करेगा। इससे कोई जानवर नहीं कहा जाएगा कि वह जानवर अच्छा है या बूरा, यदि याजक मूल्य निश्चित कर देता है तो जानवर का वही मूल्य है। ");
INSERT INTO hin2010_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","यदि व्यक्ति जानवर को वापस खरीदना चाहता है। तो उसे मूल्य में पाँचवाँ हिस्सा और जोड़ना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“यदि कोई व्यक्ति अपने मकान को पवित्र मकान के रूप में यहोवा को अर्पित करता है तो याजक को इसका मूल्य निश्चित करना चाहिए। इससे कोई अन्तर नहीं पड़ता कि मकान अच्छा है या बुरा, यदि याजक मूल्य निश्चित करता है तो वही मकान का मूल्य है। ");
INSERT INTO hin2010_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","किन्तु वह व्यक्ति जो मकान अर्पित करता है यदि उसे वापस खरीदना चाहता है तो उसे मूल्य में पाँचवाँ हिस्सा जोड़ना चाहिए। तब घर उस व्यक्ति का हो जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“यदि कोई व्यक्ति अपने खेत का कोई भाग यहोवा को अर्पित करता है तो उन खेतों का मूल्य उनको बोने के लिए आवश्यक बीज पर आधारित होगा। एक होमेर जौ के बीज की कीमत चाँदी के पचास शेकेल होगी। ");
INSERT INTO hin2010_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","यदि व्यक्ति जुबली के वर्ष खेत का दान करता है तब मूल्य वह होगा जो याजक निश्चित करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","किन्तु व्यक्ति यदि जुबलि का बाद खेत का दान करता है तो याजक को वास्तविक मूल्य निश्चित करना चाहिए। उसे अगले जुबली वर्ष तक के वर्षों को गिनना चाहिए। तब वह उस गणना का उपयोग मूल्य निश्चित करे के लिए करेगा। ");
INSERT INTO hin2010_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","यदि खेत दान देने वाला व्यक्ति खेत को वापस खरीदना चाहे तो उसके मूल्य में पाँचवाँ भाग और जोड़ा जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","यदि वह व्यक्ति खेत को वापस नहीं खरीदता है तो खेत सदैव याजकों का होगा। यदि खेत किसी अन्य को बचा जाता है तो पहलपा व्यक्ति उसे पापस नहीं खरीद सकता। ");
INSERT INTO hin2010_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","यदि व्यक्ति खेत को वापस नहीं खरीदता है तो जुबली के वर्ष खेत केवल यहोवा के लिए पवित्र रहेगा। यह सदैव याजकों का रहेगा। यह उस भूमि की तरह होगा जो पूरी तरह यहोवा को दे दी गई हो। ");
INSERT INTO hin2010_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“यदि कोई अपने खरीदे खेत को यहोवा को अर्पित करता है जो उसकी निजी सम्पत्ति का भाग नहीं है। ");
INSERT INTO hin2010_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","तब याजक को चुबली के वर्ष तक वर्षों को गिनना चाहिए और खेत का मूल्य निश्चित करना चाहिए। तब वह खेत योहवा का होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","जुबली के वर्ष वह खेत मूल भूस्वामी के पास चला जाएगा। वह उस पर्वार को जाएगा जो उसका स्वामी है। ");
INSERT INTO hin2010_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“तुम्हें पवित्र स्थान से प्रामाणिक शेकेल का उपयोग उन मूल्यों को अदा करने के लिए करना चाहिए। पवित्र स्थान के प्रामाणिक शेकेल का तोल बीस गेरा है। ");
INSERT INTO hin2010_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“लोग मवेशियों और भेड़ों को यहोवा को दान दे सकते हैं, किन्तु यदि जानवर पहलौठा है तो वह जानवर जनम से ही यहोवा का है। इसलिए लोग पहलौठा जानवर का दान नहीं कर सकते। ");
INSERT INTO hin2010_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","लोगों को पहलौठा जानवर यहोवा को देना चाहिए। किन्तु यदि पलौठा जानवर अशुद्ध है तो व्यक्ति को उस जानवर को वापस खरीदना चाहिए। याजक उस जानवर का मूल्य निश्चित करेगा और व्यक्ति को उस मूल्य का पाँचवाँ भाग उसमें जोड़ना चाहिए। यदि व्यक्ति जानवर को वापस नहीं खरीदता तो याजक को अपने निश्चित किए गाए मूल्य पर उसे बेच देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“एक विशेष प्रकार की भेट है जिसे लोग योहवा को चढ़ाते हैं। वह भेंट पूरी तरह यहोवा की है। वह भेंट न तो वापस खरीदी जा सकती है न ही बेची जा सकती है। वह भेंट यहोवा की है। उस प्रकार की भेटें ऐसे लोग, जानवर और खेत हैं, जो परिवार की सम्पत्ति है। ");
INSERT INTO hin2010_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","यदि वह विशेष प्रकार की योहवा को भेंट कोई व्यक्ति है तो उसे वापस खरीदा नहीं जा सकता। उसे अवश्य मार दिया जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“सभी पैदावारों का दसवाँ भाग यहोवा का है। इसमें खेतों, फसले और पेड़ों के फल सम्मिलित हैं। वह दसवाँ भाग यहोवा का है। ");
INSERT INTO hin2010_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","इसलिए यदि कोई व्यक्ति अपना दसवाँ भाग वापस लेना चाहता है तो उसेक मूल्य का पाँचवाँ भाग उसमें जोड़ना चाहिए और वापस खरीदना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","“याजक व्यक्तियों के मवेशियों और भेड़ों में से हर दसवाँ जानवर लेगा। हर दसवाँ जानवर यहोवा का होगा। ");
INSERT INTO hin2010_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","मालिक को यह चिन्ता नहीं करनी चाहिए कि वह जानवर अच्छा है या बुरा। उसे जानवर को अन्य जानवर से नहीं बदलना चाहिए। यदि वह बदलने का निश्चय करता है तो दोनों जानवर यहोवा के होंगे। वह जानवर वापस नहीं खरीदा जा सकता।” ");
INSERT INTO hin2010_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ये वे आदेश हैं जिन्हें यहोवा ने सीनैं पर्वत पर मूसा को दिये। ये आदेश इस्राएल के लोगों के लिए हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","यहोवा ने मूसा से मिलापवाले तम्बू में बात की। यह सीनै मरुभूमि में हुई। यह बात इस्राएल के लोगों द्वारा मिस्र छोड़ने के बाद दूसरे वर्ष के दूसरे महीने के पहले दिन की थी। यहोवा ने मूसा से कहा: ");
INSERT INTO hin2010_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“इस्राएल के सभी लोगों को गिनो। हर एक व्यक्ति की सूची उसके परिवार और उसके परिवार समूह के साथ बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","तुम तथा हारून इस्राएल के सभी पुरुषों को गिनोगे। उन पुरुषों को गिनो जो बीस वर्ष या उससे अधिक उम्र के हैं। (ये वे हैं जो इस्राएल की सेना में सेवा करते हैं।) इनकी सूची इनके समुदाय के आधार पर बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","हर एक परिवार समूह से एक व्यक्ति तुम्हारी सहायता करेगा। यह व्यक्ति अपने परिवार समूह का नेता होगा। ");
INSERT INTO hin2010_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","तुम्हारे साथ रहने और तुम्हारी सहायता करने वाले व्यक्तियों के नाम ये हैं: रूबेन परिवार समूह से शदेऊर का पुत्र एलीसूर; ");
INSERT INTO hin2010_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","शिमोन परिवार समूह से—सूरीशद्दै का पुत्र शलूमीएल; ");
INSERT INTO hin2010_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","यहूदा के परिवार समूह से—अम्मीनादाब का पुत्र नहशोन; ");
INSERT INTO hin2010_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","इस्साकार के परिवार समूह से सूआर का पुत्र नतनेल; ");
INSERT INTO hin2010_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","जवूलून के परिवार समूह से—हेलोन का पुत्र एलीआब; ");
INSERT INTO hin2010_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","यूसुफ के वंश से, एप्रैम के परिवार समूह से—अम्मीहूद का पुत्र एप्रैम; मनश्शे के परिवार समूह से—पदासूर का पुत्र गम्लीऐल; ");
INSERT INTO hin2010_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","बिन्यामीन के परिवार समूह से—गिदोनी का पुत्र अबीदान; ");
INSERT INTO hin2010_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","दान के परिवार समूह से—अम्मीशद्दै का पुत्र अहीएजेर; ");
INSERT INTO hin2010_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","आशेर के परिवार समूह से—ओक्रान का पुत्र पगीएल; ");
INSERT INTO hin2010_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","गाद के परिवार समूह से दूएल का पुत्र एल्यासाप; ");
INSERT INTO hin2010_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","नप्ताली के परिवार समूह से—एनाम का पुत्र अहीरा; ");
INSERT INTO hin2010_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ये सभी व्यक्ति अपने लोगों द्वारा अपने परिवार समूह के नेता चुने गए। ये लोग अपने परिवार समूह के नेता हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","मूसा और हारून ने इन व्यक्तियों (और इस्राएल के लोगों) को एक साथ लिया जो नेता होने के लिये आये थे। ");
INSERT INTO hin2010_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","मूसा और हारून ने इस्राएल के सभी लोगों को बुलाया। तब लोगों की सूची उनके परिवार और परिवार समूह के अनुसार बनी। बीस वर्ष या उससे अधिक उम्र के सभी व्यक्तियों की सूची बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","मूसा ने ठीक वैसा ही किया जैसा यहोवा का आदेश था।मूसा ने लोगों को तब गिना जब वे सीनै की मरुभूमि में थे। ");
INSERT INTO hin2010_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","रूबेन के परिवार समूह को गिना गया। (रूबेन इस्राएल का पहलौठा पुत्र था।) उन सभी पुरुषों की सूची बर्नी जो बीस वर्ष या उससे अधिक उम्र के थे और सेना में सेवा करने योग्य थे। उनकी सूची उनके परिवार और उनके परिवार समूह के साथ बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","रूबेन के परिवार समूह से गिने गए पुरुषों की संख्या छियालीस हजार पाँच सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","शिमोन के परिवार समूह को गिना गया। बीस वर्ष या उससे अधिक उम्र और सेना में सेवा करने योग्य सभी पुरुषों के नामों की सूची बनी। उनकी सूची उनके परिवार और उनके परिवार समूह के साथ बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","शिमोन के परिवार समूह को गिनने पर सारे पुरुषों की संख्या उनसठ हजार तीन सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","गाद के परिवार समूह को गिना गया। बीस वर्ष या उससे अधिक उम्र और सेना में सेवा करने योग्य सभी पुरुषों के नामों की सूची बनी। उनकी सूची उनके परिवार और उनके परिवार समूह के साथ बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","गाद के परिवार समूह को गिनने पर पुरुषों की सारी संख्या पैंतालीस हजार छः सौ पचास थी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","यहूदा के परिवार समूह को गिना गया। बीस वर्ष या उससे अधिक उम्र और सेना में सेवा करने योग्य सभी पुरुषों के नामों की सूची बनी। उनकी सूची उनके परिवार और उनके परिवार समूह के साथ बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","यहूदा के परिवार समूह को गिनने पर सारी संख्या चौहत्तर हजार छः सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","इस्साकार के परिवार समूह को गिना गया। बीस वर्ष या उससे अधिक उम्र और सेना में सेवा करने योग्य सभी पुरुषों के नामों की सूची बनी। उनकी सूची उनके परिवार समूह के साथ बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","इस्साकार के परिवार समूह को गिनने पर पुरुषों की सारी संख्या चौवन हजार चार सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","जबूलून के परिवार समूह को गिना गया। बीस वर्ष या उससे अधिक उम्र और सेना में सेवा करने योग्य सभी पुरुषों के नामों की सूची बनी। उनकी सूची उनके परिवार और उनके परिवार समूह के साथ बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","जबूलून के परिवार समूह को गिनने पर पुरुषों की सारी संख्या सत्तावन हजार चार सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","एप्रैम के परिवार समूह को गिना गया। बीस वर्ष या उससे अधिक उम्र और सेना में सेवा करने योग्य सभी पुरुषों के नामों की सूची बनी। उनकी सूची उनके परिवार समूह के साथ बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","एप्रैम के परिवार समूह को गिनने पर सारी संख्या चालीस हजार पाँच सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","मनश्शे के परिवार समूह को गिना गया। बीस वर्ष या उससे अधिक उम्र और सेना में सेवा करने योग्य सभी पुरुषों के नामों की सूची बनी। उनकी सूची उनके परिवार समूह के साथ बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","मनश्शे के परिवार समूह को गिनने पर पुरुषों की सारी संख्या बत्तीस हजार दो सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","बिन्यामीन के परिवार समूह को गिना गया। बीस वर्ष या उससे अधिक उम्र और सेना में सेवा करने योग्य सभी पुरुषों के नामों की सूची बनी। उनकी सूची उनके परिवार और उनके परिवार समूह के साथ बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","बिन्यामीन के परिवार समूह को गिनने पर पुरुषों की सारी संख्या पैंतीस हजार चार सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","दान के परिवार समूह को गिना गया। बीस वर्ष या उससे अधिक उम्र और सेना में सेवा करने योग्य सभी पुरुषों के नामों की सूची बनी। उनकी सूची उनके परिवार और उनके परिवार समूह के साथ बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","दान के परिवार समूह को गिनने पर सारी संख्या बासठ हजार सात सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","आशेर के परिवार समूह को गिना गया। बीस वर्ष या उससे अधिक उम्र और सेना में सेवा करने योग्य सभी पुरुषों के नामों की सूची बनी। उनकी सूची उनके परिवार और उनके परिवार समूह के साथ बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","आशेर के परिवार समूह को गिनने पर पुरुषों की सारी संख्या एकतालीस हजार पाँच सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","नप्ताली के परिवार समूह को गिना गया। बीस वर्ष या उससे अधिक उम्र और सेना में सेवा करने योग्य सभी पुरुष के नामों की सूची बनी। उनकी सूची उनके परिवार और उनके परिवार समूह के साथ बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","नप्ताली के परिवार समूह को गिनने पर पुरुषों की सारी संख्या तिरपन हजार चार सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","मूसा, हारून और इस्राएल के नेताओं ने इन सभी पुरुषों को गिना। वहाँ बारह नेता थे। (हर परिवार समूह से एक नेता था।) ");
INSERT INTO hin2010_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","इस्राएल का हर एक पुरुष जो बीस वर्ष या उससे अधिक उम्र और सेना में सेवा करने योग्य था, गिना गया। इन पुरुषों की सूची उनके परिवार समूह के साथ बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","पुरुषों की सारी संख्या छः लाख तीन हजार पाँच सौ पचास थी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","लेवी के परिवार समूह से परिवारों की सूची इस्राएल के अन्य पुरुषों के साथ नहीं बनी। ");
INSERT INTO hin2010_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","यहोवा ने मूसा से कहा था: ");
INSERT INTO hin2010_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“लेवी के परिवार समूह के पुरुषों को तुम्हें नहीं गिनना चाहिए। इस्राएल के अन्य पुरुषों के एक भाग के रुप में उनकी संख्या को मत जोड़ो। ");
INSERT INTO hin2010_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","लेवीवंश के पुरुषों से कहो कि वे साक्षीपत्र के पवित्र तम्बू के लिए उत्तरदायी हैं। वे उसकी और उसमें जो चीजें हैं, उनकी देखभाल करेंगे। वे मिलापवाले तम्बू और उसकी सभी चीजें लेकर चलेंगे।वे अपना डेरा उसके चारों ओर डालेंगे तथा उसकी देखभाल करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","जब कभी वह पवित्र तम्बू कहीं ले जाया जाएगा, तो लेवीवंश के पुरुषों को ही उसे उतारना होगा।जब कभी मिलापवाला तम्बू किसी स्थान पर लगाया जाएगा तो लेवीवंश के पुरुषों को ही यह करना होगा। वे ही ऐसे पुरुष हैं जो मिलापवाले तम्बू की देखभाल करते हैं। यदि कोई ऐसा अन्य पुरुष तम्बू के निकट आना चाहता है जो लेवी के परिवार समूह का नहीं है तो वह मार डाला जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","इस्राएल के लोग अपने डेरे अलग—अलग समूहों में लगाऐंगे। हर एक व्यक्ति को अपना डेरा अपने परिवार के झण्डे के पास लगाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","किन्तु लेवी के लोगों को अपना डेरा पवित्र तम्बू के चारों ओर डालना चाहिए। लेवीवंश के लोग साक्षीपत्र के पवित्र तम्बू की रक्षा करेंगे। वे पवित्र तम्बू की रक्षा करेंगे जिससे इस्राएल के लोगों का कुछ भी बुरा नहीं होगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","इसलिए इस्राएल के लोगों ने उन सभी बातों को माना जिसका आदेश यहोवा ने मूसा को दिया था। ");
INSERT INTO hin2010_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","यहोवा ने मूसा और हारून से कहाः ");
INSERT INTO hin2010_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“इस्राएल के लोगों को मिलापवाले तम्बू के चारों ओर अपने डेरे लगाने चाहिए। हर एक समुदाय का अपना विशेष झण्डा होगा और हर एक व्यक्ति को अपने समूह के झण्डे के पास अपना डेरा लगाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“यहूदा के डेरे का झण्डा पूर्व में होगा, जहाँ सूरज निकलता है।यहुदा के लोग वहीं डेरा लगांएगे। यहूदा के लोगों का नेता अम्मीनादाब का पुत्र नहशोन है। ");
INSERT INTO hin2010_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","इस समूह में चौहत्तर हजार छः सौ पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“इस्साकार का परिवार समूह यहूदा के लोगों के ठीक बाद में होगा। इस्साकार के लोगों का नेता सूआर का पुत्र नतनेल है। ");
INSERT INTO hin2010_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","इस समूह में चौवन हजार चार सौ पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“जबूलून का परिवार समूह भी यहूदा के परिवार समूह से ठीक बाद में अपना डेरा लगाएगा। जबूलून के लोगों नेता हेलोन का पुत्र एलीआब है। ");
INSERT INTO hin2010_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","इस समूह में सत्तावन हजार चार सौ पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“यहूदा के डेरे में एक लाख छियासी हजार चार सौ पुरुष थे। ये सभी अपने अलग अलग परिवार समूह में बंटे हुए हैं। यहूदा पहला समूह होगा जो उस समय आगे चलेगा जब लोग एक स्थान से दूसरे स्थान की यात्रा करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“रूबेन का झण्डा पवित्र तम्बू के दझिण में होगा। हर एक समूह अपने झण्डे के पास आपना डेरा लगाएगा। रूबेन के लोगों का नेता शदेऊर का पुत्र एलीसूर है। ");
INSERT INTO hin2010_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","इस समूह में छियालीस हजार पाँच सौ पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“शिमोन का परिवार समूह रुबेन के परिवार समूह के ठीक बाद अपना डेरा लगाएगा। शिमोन के लोगों का नेता सूरीशद्दै का पुत्र शलूमीएल है। ");
INSERT INTO hin2010_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","इस समूह में उनसठ हजार तीन सौ पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“गाद का परिवार समूह भी रूबेन के लोगों के ठीक बाद अपना डेरा लगाएगा। गाद के लोगों का नेता रूएल का पुत्र एल्यासाप है। ");
INSERT INTO hin2010_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","इस समूह में पैंतालीस हजार चार सौ पचास पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“रूबेन के डेरे में सभी समूहों के एक लाख इकयावन हजार चार सौ पचास पुरुष थे। रूबेन का डेरा दूसरा समूह हगा जो उस समय चलेगा जब लोग एक स्थान से दूसरे स्थान की यात्रा करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“जब लोग यात्रा करेंगे तो लेवी का डेरा ठीक उसके बाद चलेगा। मिलापवाला तम्बू दूसरे अन्य डेरों के बीच उनके साथ रहेगा। लोग अपने डेरे उसी क्रम में लगाएंगे जिस क्रम में वे चलेंगे। हर एक व्यक्ति अपने परिवार के झण्डे के साथ रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“एप्रैम का झण्डा पश्चिम की ओर रहेगा। एप्रैम के परिवार के समूह वहीं डेरा लगाएंगे। एप्रैम के लोगों का नेता अम्मीहूद का पुत्र एलीशामा है। ");
INSERT INTO hin2010_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","इस समूह में चालीस हजार पाँच सौ पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“मनश्शे का परिवार समूह एप्रैम के परिवार के ठीक बाद अपना डेरा लगाएगा। मनश्शे के लोगों का नेता पदासूर का पुत्र गम्लीएल है। ");
INSERT INTO hin2010_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","इस समूह में बत्तीस हजार दो सौ पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“बिन्यामीन का परिवार समूह भी एप्रैम के परिवार के ठीक बाद अपन डेरा लगाएगा। बिन्यामीन के लोगों का नेता गिदोनी के पुत्र अबीदान है। ");
INSERT INTO hin2010_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","इस समूह में पैंतीस हजार चार सौ पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“एप्रैम के डेरे में एक लाख आठ हजार एक सौ पुरुष थे। यह तीसरा परिवार होगा जो तब चलेगा जब लोग एक स्थान दूसरे स्थान से की यात्रा करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“दान के डेरे का झण्डा उत्तर की ओर होगा। दान के परिवार का समूह वहीं डेरा लगाएगा। दान के लोगों का नेता अम्मीशद्दै का पुत्र अहीऐजेर है। ");
INSERT INTO hin2010_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","इस समूह में बासठ हजार सात सौ पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“आशेर का परिवार समूह दान के परिवार समुह के ठीक बाद अपना डेरा लगाएगा। आशेर के लोगों का नेता ओक्रान का पुत्र पगीएल है। ");
INSERT INTO hin2010_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","इस समूह के एकतालीस हजार पाँच सौ पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“नप्ताली का परिवार समूह भी दान के परिवार समूह के ठीक बाद अपने डेरे लगाएगा। नप्ताली के लोगों का नेता एनान का पुत्र अहीरा है। ");
INSERT INTO hin2010_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","इस समूह में तिरपन हजार चार सौ पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“दान के डेरे में एक लाख सत्तावन हजार छः सौ पुरुष थे। जब लोग एक स्थान से दूसरे स्थान की यात्रा करेंगे तो यह चलने वाला आखिरी परिवार होगा। ये अपने झण्डे के नीचे अपना डेरा लगाएंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","इस प्रकार ये इस्राएल के लोग थे। वे परिवार के अनुसार गिने गये थे। सभी डेरों में अलग—अलग समूहों के सभी परिवारों के पुरुषों की समूची संख्या थी छः लाख तीन हजार पाँच सौ पचास। ");
INSERT INTO hin2010_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","मूसा ने इस्राएल के अन्य लोगों में लेवीवंश के लोगों को नहीं गिना। यह यहोवा का आदेश था। ");
INSERT INTO hin2010_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","यहोवा ने मूसा को जो कुछ करने को कहा उस सबका पालन इस्राएल के लोगों ने किया। हर एक समूहों ने अपने झण्डों के नीचे अपने डेरे लगाए और हर एक व्यक्ति अपने परिवार और अपने परिवार समूह के साथ रहा। ");
INSERT INTO hin2010_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","जिस समय यहोवा ने सीनै पर्वत पर मूसा से बात की, उस समय हारून और मूसा के परिवार का इतिहास यह है। ");
INSERT INTO hin2010_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","हारून के चार पुत्र थे। नादाब पहलौठा पुत्र था। उसके बाद अबीहू, एलीआजार और ईतामार थेए। ");
INSERT INTO hin2010_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ये पुत्र चुने हुए याजक थे। इन्हें याजक के रूप में यहोवा की सेवा का विशेष कार्य सौंपा गया था। ");
INSERT INTO hin2010_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","किन्तु नादाब और अबीहू यहोवा की सेवा करते समय पाप करने के कारण मर गए। उन्होंने यहोवा को भेंट चढ़ाई, किन्तु उन्होंने उस आग का उपयोग किया जिसके लिए यहोवा ने आज्ञा नहीं दी थी। इस प्रकार नादाब और अबीहू वहीं सीनै की मरुभूमि में मर गए। उनके पुत्र नहीं थे, अतः एलीआज़ार और ईतामार याजक बने और यहोवा की सेवा करने लगे। वे यह उस समय तक करते रहे जब तक उनका पिता हारून जीवित था। ");
INSERT INTO hin2010_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“लेवी के परिवार समूह के सभी लोगों को याजक हारून के सामने लाओ। वे लोग हारून के सहायक होंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","लेवीवंशी हारून की उस समय सहायता करेंगे जिस समय वे पवित्र तम्बू में उपासना करने आएंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","इस्राएल के लोग मिलापवाले तम्बू की हर एक चीज की रक्षा करेंगें, यह उनका कर्तव्य है। किन्तु इन चीजों की देखभाल करके ही लेवीवंश के लोग इस्राएल के लोगों की सेवा करेंगे। पवित्र तम्बू में उपासना करने की उनकी यही पद्धति होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","“इस्राएल के सभी लोगों में से लेवीवंशी चुने गए थे। ये लेवी, हारून और उसके पुत्रों की सहायता के लिए चुने गए थे। ");
INSERT INTO hin2010_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","“तुम हारून और उसके पुत्रों को याजक नियुक्त करोगे। वे अपना कर्तव्य पूरा करेंगे और याजक के रूप में सेवा करेंगे। कोई अन्य व्यक्ति जो पवित्र चीज़ों के समीप आने का प्रयत्न करता है, मार दिया जाना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","यहोवा ने मूसा से यह भी कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“मैंने तुमसे कहा कि इस्राएल का हर एक परिवार अपना पहलौठा पुत्र मुझ को देगा, किन्तु अब मैं लेवीवंश को अपनी सेवा के लिए चुन रहा हूँ। वे मेरे होंगे। अतः इस्राएल के सभी अन्य लोगों को अपना पहलौठा पुत्र मुझको नहीं देना पड़ेगा। जब तम मिस्र में थे, मैने मिस्र के लोगों के पहलोठों को मार डाला था। उस समय मैंने इस्राएल के सभी पहलौठों को अपने लिए लिया। सकभी पहलौठे बच्चे और सभी पहलौठे जानवर मेरे हैं। किन्तु अब मैं तुम्हारे पहलौठे बच्चों को तुम्हें वापस करता हूँ और लेवीवंश को अपना बनाता हूँ। मैं यहोवा हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","यहोवा ने फिर सीनै की मरुभूमि में मूसा से बात की। यहोवा ने कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“लेवीवंश के सभी परिवार समुहों और परिवारों को गिनो। प्रत्येक पुरुष या लड़कों को जो एक महीने या उससे अधिक के हैं, उनको गीनो।” ");
INSERT INTO hin2010_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","अतः मूसा ने यहोवा की आज्ञा मानी। उसने उन सभी को गिना। ");
INSERT INTO hin2010_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","लेवी के तीन पुत्र थेः उनके नाम थेः गेर्शोन, कहात और मरारी। ");
INSERT INTO hin2010_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","हर एक पुत्र परिवार समूहों का नेता था। गेर्शोन के परिवार समूह थेः लिब्नी और शिमी। ");
INSERT INTO hin2010_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","कहात के परिवार समूह थेः अम्राम, यिसहार, हेब्रोन, उज्जीएल। ");
INSERT INTO hin2010_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","मरारी के परिवार समूह थेः महली और मूशी। ये ही वे परिवार थे जो लेवी के परिवार समूह से सम्बन्धित थे। ");
INSERT INTO hin2010_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","लिब्नी और शिमियों के परिवार गेर्शोन के परिवार समूह से सम्बन्धित थे। वे गेर्शोनवंशी परिवार समूह थे। ");
INSERT INTO hin2010_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","इन दोनों परिवार समूहों में एक महीने से अधिक उम्र के लड़के या पुरुष सात हजार पाँच सौ थे। ");
INSERT INTO hin2010_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","गेर्शोन वंश के परिवार समूहों को पश्मि में डेरा लगाने के लिये कहा गया। उन्होंने पवित्र तम्बू के पीछे अपना डेरा लगाया। ");
INSERT INTO hin2010_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","गेर्शोन वंश के परिवार समूहों का नेता लाएल का पुत्र एल्यासाप था। ");
INSERT INTO hin2010_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","मिलापवाले तम्बू में गेर्शोन वंशी लोग पवित्र तम्बु, आच्छादन और बाहरी तम्बू की देखभाल का कार्य करने वाले थे। वे मिलापवाले तम्बू के प्रवेश द्वार के पर्दे कि भी देखभाल करते थे। ");
INSERT INTO hin2010_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","वे आँगन के पर्दे की देखभाल करते थे।वे आँगन के द्वार के पर्दो की भी देखभाल करते थे। वे रस्सियों और पर्दे के लिए काम में आने वाली हक एक चीज़ की देखभाल करते थे। ");
INSERT INTO hin2010_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","अम्रामियों, यिसहारियों, हेब्रोनियों और उज्जीएल के परिवार कहात के परिवार से सम्बन्धित थे। वे कहात परिवार समूह के थे। ");
INSERT INTO hin2010_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","इस परिवार समूह में एक महीने या उससे अधिक उम्र के लड़के और पुरूष आठ हजार छः सौ थे। कहात वंश के लोगों को पवित्र स्थान की देखभाल का कार्य सौंपा गया. ");
INSERT INTO hin2010_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","कहात के परिवार समूहों को पवित्र तम्बू के दक्षिण का क्षेत्र दिया गया। यह वह क्षेत्र था जहाँ उन्होंने डेरे लगाए। ");
INSERT INTO hin2010_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","कहात के परिवार समूह का नेता उज्जीएल का पुत्र एलीसापान था। ");
INSERT INTO hin2010_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","उनका कार्य पवित्र सन्दूक, मेज, दीपाधार, वेदियों और पवित्र स्थान के उपकरणों की देखभाल करना था। वे पर्दे और उनके साथ उपयोग में आने वाली सभी चीजों की भी देखभाल करते थे। ");
INSERT INTO hin2010_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","लेवीवंश के प्रमुखों का नेता हारून का पुत्र एलीआजार था। वह याजक था एलीआजार पवित्र चीज़ों की देखभाल करने वाले सभी लोगों का अधीक्षक था। ");
INSERT INTO hin2010_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","34","महली और मूशियों के परिवार समूह मरारी परिवार से सम्बन्धित थे। एक महीने या उससे अधिक उम्र के लड़के और पुरुष महली परिवार समूह में छः हजार दो सौ थे। ");
INSERT INTO hin2010_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","मरारी समूह का नेता अबीहैल का पुत्र सूरीएल था। इस परिवार समूह को पवित्र तम्बू के उत्तर का क्षेत्र दिया गया था। यही वह क्षेत्र है जहाँ उन्होंने डेरा लगाया। ");
INSERT INTO hin2010_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","मरारी लोगों को पवित्र तम्बू के ढाँचे की देखभाल का कार्य सौंपा गया। वे सभी छड़ों, खम्बों, आधारों और पविभ तम्बू के ढाँचे में जो कुछ लगा था, उन सब की दखभाल करते थे। ");
INSERT INTO hin2010_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","पवित्र तम्बू के चारों ओर के आँगन के सभी खम्भों की भी देखभाल किया करते थे। इनमें सभी आधार, तम्बू की खूटियाँ और रस्सियाँ शामिल थीं। ");
INSERT INTO hin2010_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","मूसा, हारून और उसके पुत्रों ने मिलापवाले तम्बू के सामने पवित्र तम्बू के पूर्व में अपने डेरे लगाए। उन्हे पवित्र स्थान की देखभाल का काम सौंपा गया। उन्होंने यह इस्राएल के सभी लोगों के लिए किया। कोई दूसरा व्यक्ति जो पवित्र स्थान के समीप आता, मार दिया जाता था। ");
INSERT INTO hin2010_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","यहोवा ने लेवी परिवार समूह के एक महीने या उससे अधिक उम्र के लड़कों और पुरुषों को गिनने का आदेश दिया। सारी संख्या बाइस हजार था। ");
INSERT INTO hin2010_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","यहोवा ने मूसा से कहा, “इस्राएल में सभी एक महीने या उससे अधिक उम्र के पहलौठे लड़के और पुरुषों को गिनो। उनके नामों की एक सूची बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","अब मैं इस्राएल के सभी पहलौठे लड़कों और पुरुषों को नहीं लूँगा। अब मैं अर्थात् यहोवा लेवीवंशी को ही लूँगा। इस्राएल के अन्य सभी लोगों के पहलौठे जानवरों को लेने के स्थान पर अब मैं लेवीवंशी के लोगों के पहलौठे जानवरों को ही लूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","इस प्रकार मूसा ने वह किया जो यहोवा ने आदेश दिया। मूसा ने इस्राएल के पहलौठी सारी सन्तानों को गिना। ");
INSERT INTO hin2010_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","मूसा ने सभी पहलौठे एक महीने या उससे अधिक उम्र के लड़कों और पुरुषों की सूची बनाई। उस सूची में बाइस हजार दो सौ तिहत्तर नाम थे। ");
INSERT INTO hin2010_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","यहोवा ने मूसा से यह भी कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“मैं अर्थात् यहोवा यह आदेश देता हुँ: इस्राएल के अन्य परिवारों के पहलौठे पुरुषों के स्थान पर लेवीवंशी के लोगों को लो और मैं अन्य लोगों के जानवरों के स्थान पर लेवीवंश के जानवरों को लूँगा। लेवीवंशी मेरे हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","लेवीवंश के लोग बाइस हजार हैं और अन्य परिवारों के बाइस हजार दो सौ तिहत्तर पहलौठे पुत्र हैं। इस प्रकार केवल दो सौ तिहत्तर पहलौठे पुत्र लेवीवंश के लोगों से अधिक हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","इसलिए पहलौठे दो सौ तिहत्तर पुत्रों में से हर एक के लिए पाँच शेकेल चाँदी दो। यह चाँदी इस्राएल के लोगों से इकट्ठा करो। ");
INSERT INTO hin2010_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","वह चाँदी हारून और उसके पुत्रों को दो। यह एस्राएल के दो सौ तिहत्तर लोगों के लिए भुगतान है।” ");
INSERT INTO hin2010_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","मूसा ने दो सौ तिहत्तर लोगों के लिए धन इकट्ठा किया। क्योंकि यहाँ इतने लेवी नहीं थे जो दूसरे परिवार समूह के दो सौ तिहत्तर पहलौठों की जगह ले सकें। ");
INSERT INTO hin2010_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","मूसा ने इस्राएल के पहलौठे लोगों से चाँदी इकट्ठा की। उसने एक हजार तीन सौ पैंसठ शेकेल चाँदी “अधिकृत भार” का उपयोग करके इकट्ठा की। ");
INSERT INTO hin2010_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","मूसा ने यहोवा की आज्ञा मानी। मूसा ने यहोवा के आदेश के अनुसार वह चाँदी हारून और उसके पुत्रों को दी। ");
INSERT INTO hin2010_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","यहोवा ने मूसा और हारून से कहाः ");
INSERT INTO hin2010_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“कहात परिवार समूह के पुरुषों को गिनो। (कहात परिवार समूह लेवी परिवार समूह का एक भाग है।) ");
INSERT INTO hin2010_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","अपने सेवा कर्तव्य का निर्वाह करने वाले तीस से पाचस वर्ष की उम्र वाले पुरुषों को गिनो। ये व्यक्ति मिलापवाले तम्बू में कार्य करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","उनका कार्य मिलापवाले तम्बू के सर्वाधिक पवित्र स्थान की देखभाल करना है। ");
INSERT INTO hin2010_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“जब इस्राएल के लोग नए स्थान की यात्रा करें तो हारून और उसके पुत्रों को चाहिए कि वे पवित्र तम्बू में जाएँ और पर्दे को उतारें और साक्षीपत्र के पवित्र सन्दूक को उससे ढकें। ");
INSERT INTO hin2010_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","तब वे इन सबको सुइसों के चमड़े से बने आवरण में ढकें। तब वे पवित्र सन्दूक पर बिछे चमड़े पर पूरी तरह से एक नीला वस्त्र फैलाएंगे और पवित्र सन्दूक में कड़ों में डंडे डालेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“तब वे एक नीला कपड़ा पवित्र मेज के ऊपर फैलाएंगे। तब वे उस पर थाली, चम्मच, कटोरे और पेय भेंट के कलश रखेंगे। वे विशेष रोटी भी मेज पर रखेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","तब तुम इन सभी चिज़ों के ऊपर एक लाल कपड़ा डालोगे।तब हर एक चीज़ को सुइसों के चमड़े से ढक दो। तब मेज के कड़ों में डंडे डालो। ");
INSERT INTO hin2010_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“तब दीपाधार और दीपकों को नीले कपड़े से ढको। दीपक जलने के लिए उपयोग में आनेवाली सभी चीजों और दीपक के लिए उपयोग में आने वाले तेल के सभी घड़ों को ढको। ");
INSERT INTO hin2010_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","तब सभी चीजों को सुइसों के चमड़े में लेपेटो और इन्हें ले जाने के के लिये उपयोग में आने वाले डंडो पर इन्हें रखो। ");
INSERT INTO hin2010_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“सुनहरी वेदी पर एक नीला कपड़ा फैलाओ। उसे सुइसों के चमड़े से ढको। तब वेदी को ले जाने के लिए उसमें लगे हुए कड़ो में डंडे डालो। ");
INSERT INTO hin2010_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“पवित्र स्थान में उपासना के उपयोग में आने वाली सभी विशेष चीज़ों को एक साथ इकट्ठा करो। इन्हें एक साथ इकट्ठा करो और इनको नीले कपड़े में लपेटो। तब इसे सुइसों के चमड़े से ढको। इन चीजों को ले जाने के लिए इन्हें एक ढाँचे पर रखो। ");
INSERT INTO hin2010_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“काँसेवाली वेदी से राख को साफ कर दो और इसके ऊपर एक बैंगनी रंग का कपड़ा फैलाओ। ");
INSERT INTO hin2010_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","तब वेदी पर उपासना के लिए उपयोग में आने वाली चीजों को इकट्ठा करो। आग के तसले, माँस के लिए काँटे, बेलचे और चिलमची हैं। इन चीजों को काँसे की वेदी पर रखो। तब वेदी के ऊपर सुइसों के चमड़े का आवरण फैलाओ। वेदी में लगे कड़ों में, इसे ले जाने वाले डंडे डालो। ");
INSERT INTO hin2010_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“जब हारून और उसके पुत्र पवित्र स्थान की सभी पवित्र चीज़ों को ढकना पुरा कर लें तब कहात परिवार के व्यक्ति अन्दर आ सकते हैं और उन चीज़ों को ले जाना आरम्भ कर सकते हैं। इस प्रकार वे इस पवित्र वस्तुओं को छुएंगे नहीं। सो वे मरेंगे नहीं। ");
INSERT INTO hin2010_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“याजक हारून का पुत्र एलीअज़ार पवित्र तम्बू के लिए उत्तरदायी होगा। वह पवित्र स्थान और इसकी हर एक चीज़ के लिए उत्तरदायी होगा। वह दीपक के तेल, मधुर सुगन्धवाली सुगन्धि तथा दैनिक बलि और अभिषेक के तेल के लिये उत्तरदायी होगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“सावधान रहो! इन कहातवंशी व्यक्तियों को नष्ट मत होने दो। ");
INSERT INTO hin2010_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","तम्हें यह इसलिए करना चाहिए ताकि कहातवंशी सर्वाधिक पवित्र स्थान तक जाएँ और मरें नहीं: हारून और उसके पुत्रों को अन्दर जाना चाहिए और हर एक कहातवंशी को बताना चाहिए कि वह क्या करे। उन्हें हर एक व्यक्ति को वह चीज़ देनी चाहिए जो उसे ले जानी है। ");
INSERT INTO hin2010_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","यदी तुम ऐसा नहीं करते हो तो कहातवंशी अन्दर जा सकते हैं और पवित्र चीज़ों को देख सकते हैं। यदि वे एक क्षण के लिए भी उन पवित्र वस्तुओं की ओर देखते हैं तो उन्हें मरना होगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“गेर्शोन परिवार के सभी लोगों को गिनो। उनकी सूची परिवार और परिवार समूह के अनुसार बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","अपना सेवा कतर्व्य कर चुकने वाले तीस वर्ष से पचास वर्ष तक के पुरुषों को गिनो। ये लोग मिलापवाले तम्बू की देखभाल का सेवा—कार्य करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“गेर्शोन परिवार को यही करना चाहिए और इन्हीं चीज़ों को ले चलना चाहिएः ");
INSERT INTO hin2010_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","इन्हें पवित्र तम्बू के पर्दे, मिलापवाले तम्बू, इसके आवरण और सुइसों के चमड़ें से बना आवरण ले चलना चाहिए। उन्हें मिलापवाले तम्बू के द्वार के पर्दे भी ले चलना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","उन्हें आँगन के उन पर्दों को, जो पवित्र तम्बू और वेदी को चारों ओर लगे हें, ले चलना चाहिए। उन्हें आँगन के प्रवेश द्वार का पर्दा भी ले चलना चाहिए। उन्हें सारी रस्सियाँ और पर्दे के साथ उपयोग में आनेवाली सभी चीजें ले चलनी चाहिए। गेर्शोन वंश के लोग उस किसी भी चीज़ के लिए उत्तरदायी होंगे जो इन चीज़ो से की जानी है। ");
INSERT INTO hin2010_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","हारून और उसके पुत्र इन सभी किए गए कार्यों की निगरानी करेंगे। होर्शोन वंश के लोग जो कुछ ले जाएंगे और जो दूसरे कार्य करेंगे उनकी निगरानी हारून और उसके पुत्र करेंगे। तुम्हें उनको वे सभी चीज़े बतानी चाहिए जिनके ले जाने के लिये वे उत्तरदायी हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","यही काम है जिसे गेर्शोन वंश के परिवार समूह के लोगों को मिलापवाले तम्बू के लिए करना है हारून का पुत्र ईतामार याजक उनके काम के लिए उत्तरदायी होगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“मरारी परिवार समूह के परिवार ओर परिवार समूह के पुरुषों को गिनो। ");
INSERT INTO hin2010_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","सेवा—कर्तव्य कर चुके तीस से पचास वर्ष के सभी पुरुषों को गिनो। ये लोग मिलापवाले तम्बू के लिए विशेष कार्य करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","जब तुम यात्रा करोगे तब उनका यह कार्य है कि वे मिलापवाले तम्बू के तख्ते ले चलें। उन्हें तख्ते, खम्भों और आधारों को ले चलना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","उन्हें आँगन के चारों ओर के खम्भों को भी ले चलना चाहिए। उन्हें उन तम्बू की खूंटियों, रस्सियों और वे सभी चीजें जिनका उपयोग आँगन के चारों ओर के खम्भों के लिए होता है, ले चलना चाहिए। नामों की सूची बनाओ और हर एक व्यक्ति को बताओ कि उसे क्या—क्या चीज़े ले जाना है। ");
INSERT INTO hin2010_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","यही बातें हैं जिसे मरारी वंश के लोग मिलापवाले तम्बू के कार्यों में सेवा करने के लिए करेंगे। हारून का पुत्र ईतामार याजक इनके कार्य के लिए उत्तरदायी होगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","मूसा, हारून और इस्राएल के लोगों के नेताओं ने कहातवंश के लोगों को गिना। उन्होंने उनको परिवार और परिवार समूह के अनुसार गिना। ");
INSERT INTO hin2010_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","उन्होंने आपना सेवा—कर्तव्य कर चुके तीस से पचास पर्ष के उम्र के लोगों को गिना। इन लोगों को मिलापवाले तम्बू के लिए विशेष कार्य करने को दिए गए। ");
INSERT INTO hin2010_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","कहात परिवार समूह में जो इस कार्य को करने की योग्यता रखते थे, दो हजार सात सौ पचास पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","इस प्रकार कहात परिवार के इन लोगों को मिलापवाले तम्बु के बिशेष कार्य करने के लिए दिए गए। मूसा और हारून ने इसे वैसे ही किया जैसा यहोवाने मूसा से करने को कहा था। ");
INSERT INTO hin2010_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","गेर्शोन परिवार समूह को भी गिना गया। ");
INSERT INTO hin2010_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","सभी पुरुष जो अपना कर्तव्य सेवा कर चुके थे और तीस से पचास वर्ष की उम्र के थे, गिने गए। इन लोगों को मिलापवाले तम्बू में विशेष कार्य करने का सेवा—कार्य दिया गया। ");
INSERT INTO hin2010_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","गेर्शोन परिवार समूह के परिवारों में जो योग्य थे, वे दो हजार छः सौ तीस पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","इस प्रकार इन पुरुषों को जो गेर्शोन परिवार समूह के थे, मिलापवाले तम्बू में विशेष कार्य करने का सेवा—कार्य सौंपा गया। मूसा और हारून ने इसे वैसे ही किया जैसा यहोवा ने मूसा को करने को कहा था। ");
INSERT INTO hin2010_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","मरारी के परिवार और परिवार समूह भी गिने गए। ");
INSERT INTO hin2010_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","सभी पुरुष जो अपना सेवा—कर्तव्य कर चुके थे और तीस से पचास वर्ष की उम्र के थे, गिने गए। इन व्यक्तियों को मिलापवाले तम्बू के लिए विशेष कार्य करने का सेवा—कार्य दिया गया। ");
INSERT INTO hin2010_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","मरारी परिवार समूह के परिवारों में जो लोग योग्य थे, वे तीन हजार दो सौ व्यक्ति थे। ");
INSERT INTO hin2010_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","इस प्रकार मरारी परिवार समूह के इन लोगों को विशेष कार्य दिया गया। मूसा और हारून ने इसे वैसे ही किया जैसा यहोवा ने मूसा से करने को कहा था। ");
INSERT INTO hin2010_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","मूसा, हारून और इस्राएल के लोगों के नेताओं ने लेवीवंश परिवार समूह के सभी सदस्यों को गिना। उन्होंने प्रत्येक परिवार और प्रत्येक परिवार समूह को गिना। ");
INSERT INTO hin2010_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","सभी व्यक्ति जो अपने सेवा—कर्तव्य का निर्वाह कर चुके थे और जो तीस वर्ष से पचास वर्ष उम्र के थे, गिने गए। इन व्यक्तियों को मिलापवाले तम्बू के लिए विशेष कार्य करने का सेवा—कार्य दिया गया। उन्होंने मिलापवाले तम्बू को ले चलने का कार्य तब किया जब उन्होंने यात्रा की। ");
INSERT INTO hin2010_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","पुरुषों की सारी संख्या आठ हजार पाँच सौ अस्सी थी। ");
INSERT INTO hin2010_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","यहोवा ने यह आदेश मूसा को दिया था। हर एक पुरुष को अपना कार्य दिया गया था और हर एक पुरुष से कहा गया था कि उसे क्या—क्या ले चलना चाहिए। इसलिए यहोवा ने जो आदेश दिया था उन चीज़ों को पूरा किया गया। सभी पुरुषों को गिना गया। ");
INSERT INTO hin2010_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“मैं इस्राएल के लोगों को, उनके डेरे बीमारियों व रोगों से मुक्त रखने का आदेश देता हूँ। इस्राएल के लोगों से कहो कि हर उस व्यक्ति को जो बुरे चर्म रोगो, शरीर से निकलने वाले स्रावों या किसी शव को छूने के कारण अशुद्ध हो गये हैं, उन्हें डेरे से बाहर निकाल दें, ");
INSERT INTO hin2010_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","चाहे वे पुरुष हो चाहे स्त्री। उन्हें डेरे से बाहर निकाल दें ताकि वे जिस डेरे में मेरा निवास है उसे वे अशुद्ध न कर दें। मैं तुम्हारे डेरे में तुम लोगों के बीच रह रहा हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","अतः इस्राएल के लोगों ने परमेश्वर का आदेश माना। उन्होंने उन लोगों को डेरे के बाहर भेज दिया। उन्होंने ऐसा इसलिए किया क्योंकि यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“इस्राएल के लोगों को यह बताओः जब कोई व्यक्ति किसी दूसरे व्यक्ति का कुछ बुरा करता है तो वस्तुतः वह यहोवा के विरूद्ध पाप करता है। वह व्यक्ति अपराधी है। ");
INSERT INTO hin2010_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","इसलिए वह व्यक्ति लोगों को अपने किए गए पाप को बताए। तब यह व्यक्ति अपने बुरे किए गए काम का पूरा भुगतान करे। वह भुगतान में पाँचवाँ हिस्सा जोड़े और उसका भुगतान उसे करे जिसका बुरा उसने किया है। ");
INSERT INTO hin2010_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","किन्तु जिस व्यक्ति का उसने बुरा किया है, वह मर भी सकता है और सम्भव है उस मृतक का कोई नजदीकी सम्बन्धी न हो जिसे भुगतान किया जाए। उस स्थिति में, बुरा करने वाला व्यक्ति यहोवा को भुगतान करेगा। वह व्यक्ति पूरा भूतगन याजक को करेगा।याजक को क्षमादान रुपी मेढ़े की बली देनी चाहिए। बुरा करने वाले व्यक्ति के पापों को ढकने के लिए इस मेढ़े की बलि दी जानी चाहिए किन्तु याजक बाकी बचे भुगतान को अपने पास रख सकता है। ");
INSERT INTO hin2010_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","“यदि इस्राएल का कोई व्यक्ति यहोवा को विशेष भेंट देता है तो वह याजक जो उसे स्वीकार करता है उसे अपने पास रख सकता है। यह उसकी है। ");
INSERT INTO hin2010_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","किसी व्यक्ति को ये विशेष भेंट देनी नहीं पड़ेगी। किन्तु यदि वह उनकी दता है तो वह याजक की होगी।” ");
INSERT INTO hin2010_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","तब यहोवा ने मूसा से कहाः ");
INSERT INTO hin2010_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“इस्राएल के लोगों से यह कहो, किसी व्यक्ति की पत्नी पतिव्रता नहीं भी हो सकती है। ");
INSERT INTO hin2010_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","उस का किसी दूसरे व्यक्ति के साथ शारीरिक सम्बन्ध हो सकता है और वह इसे अपने पति से छिपा सकती है। कोई ऐसा व्यक्ति भी नहीं होता जो कहे कि उसने यह पाप किया। उसका पति उसे कभी जान भी नहीं सकता जो बुराई उसने की है और वह स्त्री भी अपने पति से अपने पाप के बारे में नहीं कहेगी। ");
INSERT INTO hin2010_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","किन्तु पति शंका करना आरम्भ कर सकता है कि उसकी पत्नी ने उसके विरुद्ध पाप किया है। वह उसके प्रति ईर्ष्या रख सकता है। चाहे वह सच्ची हो चाहे नहीं। ");
INSERT INTO hin2010_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","यदि ऐसा होता है तो वह अपनी पत्नी को याजक के पास ले जाए। पति एक भेंट भी ले जाएगा। यह भेंट 1/10 एपा जौ का आटा होगा। यह उसे जो के आटे पर तेल या सुगन्धित नहीं डालनी चाहिये। का आटा यहोवा को अन्नबलि है. यह इसलिए दिया जाता कि पति ईर्यालु है। यह भेंट यही संकेत करेगी कि उसे विस्वास है कि उसकी पत्नी पतिव्रता नहीं है। ");
INSERT INTO hin2010_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“याजक स्त्री को यहोवा के सामने ले जाएगा और स्त्री यहोवा के सामने खड़ी होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","तब याजक कुछ विशेष पानी लेगा और उसे मिट्टी के घड़े में डालेगा। याजक पवित्र तम्बू के फर्श से कुछ मिट्टी पानी में डालेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","याजक स्त्री को यहोवा के सामने खड़ा रहने के लिए विवश करेगा। तब वह उसके बाल खोलेगा और उसके हाथ में अन्नबलि देगा। यह जौ का आटा होगा जिसे उसके पति ने ईर्ष्या के कारण उसे दिया था। उसी समय वह विशेष कड़वे जल वाले मिट्टी के घड़े को पकड़े रहेगा। यह विशेष कड़वा जल ही है जो स्त्री को परेशानी पैदा करता है। ");
INSERT INTO hin2010_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","“तब याजक स्त्री से कहेगा कि उसे झूठ नहीं बोलना चाहिए। उसे सत्य बोलने का वचन देना चाहिए। याजक उससे कहेगाः यदि तुम दूसरे व्यक्ति के साथ नहीं सोई हो, और तुमने अपने पति के विरुद्ध पाप नहीं किया है, जबकि तुम्हारा विवाह उसके साथ हुआ है, तो यह कड़वा जल तुमको हानि नहीं पहुँचाएगा। ");
INSERT INTO hin2010_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","किन्तु यदि तुमने अपने पति के विरुद्ध पाप किया है, यदि तुम किसी अन्य पुरुष के साथ सोई हो तो तुम शुद्ध नहीं हो। क्यों क्योंकि जो तुम्हारे साथ सोया है तुम्हारा पति नहीं है और उसने तुम्हें अशुद्ध बनाया है। ");
INSERT INTO hin2010_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","इसलिए जब तुम इस विशेष जल को पीओगी तो तुम्हें बहुत परेशानी होगी। तुम्हारा पेट फूल जाएगा और तुम कोई बच्चा उत्पन्न नहीं कर सकोगी। यदि तुम गर्भवती हो, तो तुम्हारा बच्चा मर जाएगा। तब तुम्हारे लोग तुम्हे छोड़ देंगे और वे तुम्हारे बारे में बुरी बातें कहेंगे। “तब याजक को स्त्री से यहोवा को विशेष वचन देने के लिए कहना चाहिए। स्त्री को स्वीकार करना चाहिए कि ये बुरी बातें उसे होगी, यदि वह झूठ बोलेगी। ");
INSERT INTO hin2010_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","याजक को कहना चाहिए, तुम इस जल को लोगी जो तुम्हारे शरीर में परेशानी उत्पन्न करेगा। यदि तुमने पाप किया है तो तुम बच्चों को जन्म नहीं दे सकोगी औ यदि तुम्हारा कोई बच्चा गर्भ में है तो वह जन्म लेने के पहले मर जाएगा। तब स्त्री को कहना चाहिएः मैं वह स्वीकार करती हूँ जो आप कहते हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“याजक को इन चेतावनियों को चर्म—पत्र पर लिखनी चाहिए।फिर उसे इस लिखावट को पानी में धो देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","तब स्त्री उस पानी को पीएगी जो कड़वा है। वह पानी उसमें जाएगा और यदि वह अपराधी है, तो उसे बहुत परेशानी उत्पन्न करेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","“तब याजक उस अन्नबलि को उससे लेगा। (ईर्ष्या के लिए भेंट) और उसे यहोवा के सामने उठाएगा और उसे वेदी तक ले जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","तब याजक अपनी अंजली में अन्न भरेगा और उसे वेदी पर रखेगा। तब वह उसे जलाएगा। उसके बाद, वह स्त्री से पानी पीने को कहेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","यदि स्त्री ने पति के विरुद्ध पाप किया होगा, तो पानी उसे परेशान करेगा। पानी उसके शरीर में जाएगा और उसे बहुत कष्ट देगा और कोई बच्चा जो उसके गर्भ में होगा, पैदा होने से पहले मर जाएगा और वह कभी बच्चे को जन्म नहीं दे सकेगी। सभी लोग उसके विरुद्ध हो जायेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","किन्तु यदि स्त्री ने पति के विरुद्ध पाप नहीं किया है तो वह पवित्र है, फिर याजक घोषणा करेगा कि वह अपराधी नहीं है और बच्चों को जन्म देने के योग्य हो जाएगी। ");
INSERT INTO hin2010_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“इस प्रकार यह ईर्ष्या के विषय में नियम है। तुम्हें यही करना चाहिए यदि कोई विवाहित स्त्री अपने पति के विरूद्ध पाप करती है। ");
INSERT INTO hin2010_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","या यदि कोई व्यक्ति ईर्ष्या करता है और अपनी पत्नी के सम्बन्ध में शंका करता है कि उसने उसके विरुद्ध पाप किया है तो व्यक्तिको यही करना चारिए। याजक को कहना चाहिए कि वह स्त्री यहोवा के सामने खड़ी हो। तब याजक इन सभी कार्यों को करेगा। यही नियम है। ");
INSERT INTO hin2010_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","पति कोई बुरा करने का अपराधी नहीं होगा। किन्तु स्त्री कष्ट उठाएगी, यदी उसने पाप किया है।” ");
INSERT INTO hin2010_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ये बातें इस्राएल के लोगों से कहोः कोई पुरुष या स्त्री कुछ समय के लिए किन्हीं अन्य लोगों से अलग रहना चाह सकता है। इस अलगाव का उद्देश्य यह हो कि वह व्यक्ति पूरी तरह अपने को उस समय के लिए यहोवा को समर्पित कर सके। वह व्यक्ति नाज़ीर कहलाएगा। ");
INSERT INTO hin2010_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","उस काल में व्यक्ति को कोई दाखमधु या कोई अधिक नशीली चीज़ नहीं पीनी चाहिए। व्यक्ति को सिरका जो दाखमधु से बना हो या किसी अधिक नशीले पेय को नहीं पीना चाहिए। उस व्यक्ति को अंगूर का रस नहीं पीना चाहिए और न ही अंगुर या किशमिश खाने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","उस अलगाव के विशेष काल में उस व्यक्ति को अंगूर से बनी कोई चीज नहीं खानी चाहिए। उस व्यक्ति को अंगूर का बीज या छिलका भी नहीं खाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“उस अलगाव के काल में उस व्यक्ति को अपने बाल नहीं काटने चाहिए। उस व्यक्ति को उस समय तक पवित्र रहना चाहिए जब तक अलगाव का समय समाप्त न हो। उसे अपने बालों को लम्बे होने देना चाहिए। उस व्यक्ति के बाल, परमेस्वर को दिए गये उसके वचन का एक विशेष भाग है। वह उन बालों को परमेस्वर के लिए भेंट के रुप में देगा। इसलिए वह व्यक्ति अपने बालों को तब तक लम्बा होने देगा जब तक अलगाव का समय समाप्त न होगा। ");
INSERT INTO hin2010_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“इस अलगाव के काल में नाज़ीर को किसी शव के पास नही जाना चाहिए। क्यों क्योंकि उस व्यक्ति ने अपने को पूरी तरह यहोवा को समर्पित कर दिया है। ");
INSERT INTO hin2010_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","यदि उसके अपने पिता, अपनी माता, अपने भाई या अपनी बहन भी मरें तो भी उसे उनको छूना नहीं चाहिए। यह उसे अपवित्र करेगा। उसे यह दिखाना चाहिए कि उसे अलग किया गया है और अपने को पूरी तरह परमेस्वर को समर्पित कर चुका है। ");
INSERT INTO hin2010_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","जिस पूरे काल में वह अलग किया गया, वह पूरी तरह अपने को यहोवा को समर्पित किए हुए है। ");
INSERT INTO hin2010_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","यह संभव है कि नाजीर किसी दूसरे व्यक्ति के साथ हो और वह दूसरा व्यक्ति अचानक मर जाए। यदि नाज़ीर मरे व्यक्ति को छुएगा तो वह अपवित्र हो जाएगा। यदि ऐसा होता है तो नाजीर को सिर से अपने बाल कटवा लेना चाहिए। वे बाल उसके विशेष दिए गए वचन के भाग थे। उसे अपने बालों को सातवें दिन काटना चाहिए क्योंकि उस दिन वह पवित्र किया जाता है। ");
INSERT INTO hin2010_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","तब आठवें दिन उसे दो फाख्ते या कबूतर के दो बच्चे याजक के पास लाने चाहिए। उसे याजक को उन्हें मिलापवाले तम्बू के द्वार पर देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","तब याजक एक को पापबलि के रूप में भेंट करेगा। वह दूसरे को होमबलि के रूप में भेंट करेगा। यह होमबलि उस व्यक्ति द्वारा किये गये पाप के लिए भुगतान होगी। उसने पाप किया क्योंकि वह शव के पास था। उस समय वह व्यक्ति फिर वचन देगा कि सिर के बालों को परमेस्वर को भेंट करेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","इसका यह तात्पर्य हुआ कि उस व्यक्ति को फिर अलगाव के दूसरे समय के लिए अपने आपको यहोवा को समर्पित कर देना चाहिए। उस व्यक्ति को एक वर्ष का एक मेढ़ा लाना चाहिए। वह इसे पाप के लिए भेंट के रूप में देगा। उसके अलगाव के सभी दिन भुला दिये जाते हैं। उस व्यक्ति को नये अलगाव के समय का आरम्भ करना होगा। यह अवश्य किया जाना चाहिए क्योंकि उसने अलगाव के प्रथम काल में एक शव का स्पर्श किया। ");
INSERT INTO hin2010_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“जब व्यक्ति के अलगाव का समय पूरा हो तो उसे मिलापवाले तम्बू के द्वार पर जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","वहाँ वह अपनी भेंट यहोवा को देगा। उसकी भेंट होनी चाहिएः होमबलि के लिए बिना दोष का एक वर्ष का एक मेढ़ा पापबलि के लिए बिना दोष की एक वर्ष की एक मादा भेड़, मेलबलि के लिए बिना दोष का एक नर भेड़, ");
INSERT INTO hin2010_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","अखमीरी रोटियों की एक टोकरी, (तेल से मिश्रित अच्छे आटे के फुलके इन “फुलकों” पर तेल लगाना चाहिए।) अन्य भेंट तथा पेय भेंट जो इन भेंटों का एक भाग है। ");
INSERT INTO hin2010_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“तब याजक इन चीज़ों को यहोवा को देगा। याजक पापबलि और होमबलि चढ़ाएगा। ");
INSERT INTO hin2010_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","याजक रोटयों की टोकरी यहोवा को देगा। तब वह यहोवा की मेलबलि के रूप में नर भेड़ को मारेगा। वह यहोवा को अन्नबलि और पेय भेंट के साथ इसे देगा। ");
INSERT INTO hin2010_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","नाजीर को मिलापवाले तम्बू के द्वार पर जाना चाहिए। वहाँ उसे अपने बाल कटवाने चाहिए जिन्हें उसने यहोवा के लिए बढ़ाया था। उन बालों को मेलबलि के रूप में दी गई बलि के नीचे जल रही आग में डाला जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“जब नाज़ीर अपने बालों को काट चकेगा तो याजक उसे नर मेढ़ का एक पका हुआ कंधा और टोकरी से एक बड़ा और एक छोटा ‘फुलका’ देगा। ये दोनों अखमीरी फुलके होंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","तब याजक इन चीजों को यहोवा के सामने उत्तोलित करेगा। यह एक उत्तोलन भेंट हैं। ये चीजें पवित्र हैं और याजक की हैं। नर भेड़ की छाती और जांघ भी यहोवा के सामने उत्तोलित किये जाएंगे। ये चीज़ें भी याजक की हैं। इसके बाद नाज़ीर दाखमधु पी सकता है। ");
INSERT INTO hin2010_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“यह नियम उन व्यक्तियों के लिए है जो नाजीर होने का वचन लेते हैं। उस व्यक्ति को यहोवा को ये सभी भेंट देनी चाहिए यदि कोई व्यक्ति अधिक देने का वचन देता है तो उसे अपने वचन का पालन करना चाहिए। लेकिन उसे कम से कम वह सभी चीज़े देनी चाहिए जो नाज़ीर के नियम में लिखी हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“हारून और उसके पुत्रों से कहो। इस्राएल के लोगों को आशीर्वाद देने का ढंग यह है। उन्हें कहना चाहिएः ");
INSERT INTO hin2010_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘यहोवा तुम पर कृपा करे और तुम्हारी रक्षा करे। ");
INSERT INTO hin2010_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","यहोवा की कृपादृष्टि तुम पर प्रकाशित हो। वह तुमसे प्रेम करे। ");
INSERT INTO hin2010_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","यहोवा की दृष्टि तुम पर हो। वह तुम्हें शान्ति दे।’ ");
INSERT INTO hin2010_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","इस प्रकार हारून और उसके पुत्र इस्राएल के लोगों के सामने मेरा नाम लेंगे और मैं उन्हें आशीर्वाद दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","जिस दिन मूसा ने पवित्र तम्बू का लगाना पूरा किया, उसने इसे यहोवा को समर्पित किया। मूसा ने तम्बू और इसमें उपयोग आने वाली चीजों को अभिषिक्त किया। मूसा ने वेदी और इसके साथ उपयोग में आने वाली चीजों को भी अभिषिक्त किया। ये दिखाती थी कि ये सभी वस्तुएं केवल यहोवा की उपालना के लिये प्रयोग की जानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","तब इस्राएल के नेताओं ने भेटे चढ़ाई। ये अपने—अपने परिवारों के मुखिया थे जो अपने परिवार समूह के नेता थे। इन्हीं नेताओं ने लोगों को गिना था। ");
INSERT INTO hin2010_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ये नेता यहोवा के लिये भेंटे लाए। वे चारों ओर से ढकी छः गाड़ियाँ और बारह गायें लाए। (हर एक नेता द्वारा एक गाय दी गई थी। हर नेता ने दूसरे नेता से चारों ओर से ढकी गाड़ी को देने में साझा किया।) नेताओं ने पवित्र तम्बू पर यहोवा को ये चीज़े दीं। ");
INSERT INTO hin2010_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“नेताओं की इन भेंटों को स्वीकार करो। ये भेंटें मिलावाले तम्बू के काम में उपयोग की जा सकती हैं। इन चीज़ों को लेवीवंश के लोगों को दो। यह उन्हें अपने काम करने में सहायक होंगी।” ");
INSERT INTO hin2010_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","इसलिए मूसा ने चारों ओर से ढकी गाड़ियों और गायों को लिया। उसने इन चीज़ों को लेवीवंश के लोगों को दिया। ");
INSERT INTO hin2010_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","उसने दो गाड़ियाँ और चार गायें गेर्शोन वंशियों को दीं। उन्हें अपने काम के लिए उन गाड़ियों और गायों की आवश्यकता थी। ");
INSERT INTO hin2010_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","तब मूसा ने चार गाड़ियों और आठ गायें मरारी वंश को दीं। उन्हें अपने काम के लिए गाड़ियों और गायों की आवश्यकता थी। याजक हारून का पुत्र ईतामार इन सभी व्यक्तियों के कार्य के लिए उत्तरदायी था। ");
INSERT INTO hin2010_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","मूसा ने कहात वंशियों को कोई गाय या कोई गाड़ी नहीं दी। इन व्यक्तियों को पवित्र चीज़े अपने कंधों पर ले जानी थीं। यही कार्य उनको करने के लिए सौंपा गया था। ");
INSERT INTO hin2010_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","उस दिन के अभिषेक के पश्चात नेता अपनी भेंटे वेदी पर समर्पण के लिए लाए। उन्होंने अपनी भेंटे वेदी के सामने यहोवा को अर्पित कीं। ");
INSERT INTO hin2010_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","यहोवा ने पहले से ही मूसा से कह रखा था, “वेदी को समर्पण के रूप में दी जाने वाली अपनी भेंट का भाग हर एक नेता एक एक दिन लाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","बारह नेताओं में से प्रत्येक नेता अपनी—अपनी भेंटे लाया। वे भेंटे ये हैं: प्रत्येक नेता चाँदी की एक थाली लाया जिसका वजन था एक सौ तीस शेकेल। प्रत्येक नेता चाँदी का एक कटोरा लाया जिसका वजन सत्तर शेकेल था इन दोनों ही उपहारों को पवित्र अधिकृत भार हुआ था। यह अन्नबलि के रुप में प्रयोग में लाया जिसका भार दस शेकेल था। इस करछी में धूप भरी हुई थी। प्रत्यके नेता एक बछड़ा, एक मेढ़ा और एक वर्ष का एक मेमना भी लाया। ये पशु होमबलि के लिए थे। प्रत्येक नेता पापबलि के रूप में इस्तेमाल किये जाने के लिए एक बकरा भी लाया। प्रत्येक नेता दी गाय, पाँच मेढ़े, पाँच बकरे और एक एक वर्ष के पाँच मेमने लाया। इन सभी की मेलबलि दी गयी। अम्मीनादाब का पुत्र नहशोम, जो यहूदा के परिवार समूह से था, पहले दिन अपनी भेंटे लाया। दूसरे दिन सूआर का पुत्र नतनेल जो इस्साकार का नेता था, अपनी भेंटे लाया। तीसरे दिन हेलोन का पुत्र एलीआब जो जबूलूनियों का नेता था, अपनी भेंटे लाया। चौथे दिन शदेऊर का पुत्र एलीसूर जो रूबेनियों का नेता था, अपनी भेटे लाया। पाँचवे दिन सूरीशद्दै का पुत्र शलूमीएल जो शमौनियों का नेता था, अपनी भेंटे लाया। छठे दिन दूएल का पुत्र एल्यासाप जो गादियों का नेता था, अपनी भेंटे लाया। सातवें दिन अम्मीहूद का पुत्र एलीशामा जो एप्रैम के लोगों का नेता था, अपनी भेंटे लाया। आठवें दिन पदासूर का पुत्र गम्लीएल जो मनश्शे के लोगों का नेता था, अपनी भेंटे लाया। नवें दिन गिदोनी का पुत्र अबीदान जो बिन्यामिन के लोगों का नेता था, अपनी भेंटे लाया। दसवें दिन अम्मीशद्दै का पुत्र आखीआजर जो दान के लोगों का नेता था, अपनी भेंटे लाया। ग्यारहवें दिन ओक्रान का पुत्र पजीएल जो आशेर के लोगों का नेता था, अपनी भेंटे लाया। और फिर बारहवें दिन एनान का पुत्र अहीरा जो नप्ताली के लोगों का नेता था, अपनी भेंटे लेकर आया। ");
INSERT INTO hin2010_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","इस प्रकार ये सभी चीज़ें इस्राएल के लोगों के नेताओं की भेटों थी। ये चीज़े तब लई गई जब मूसा ने वेदी को विशेष तेल डालकर समर्पित किया। वे बारह चाँदी की तश्तरियाँ, बारह चाँदी के कटोरे और बारह सोने के चम्मच लाए। ");
INSERT INTO hin2010_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","चाँदी की हर एक तश्तरी का वजन लगभग सवा तीन पौड़ था और हर एक कटोरे का वजन लगभल पौने दो पौंड़ था। चाँदी की तश्तरियों और चाँदी के कटोरों का कुल अधिकृत भार साठ पौंड था। ");
INSERT INTO hin2010_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","सुगन्धि से भरे सोने के चम्मचों में से प्रत्येक का अधिकृत भार दस शेकेल था। बारह सोने के चम्मचों का कुल वजन लगभग तीन पौंड था। ");
INSERT INTO hin2010_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","होमबलि के लिए जानवरों की कुल संख्या बारह बैल, बारह मेढ़े और बारह एक बर्ष के मेमने थे। वहाँ अन्नबलि भी थी। यहोवा को पापबलि के रुप में उपयोग में आने वाले बारह बकरे भी थे। ");
INSERT INTO hin2010_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","नेताओं ने मेलबलि के रुप में उपयोग और मारे जाने के लिए भी जानवर दिए। इन जानवरों की संख्या थी चौबीस बैल, साठ मेढ़े, साठ बकरे और साठ एक वर्ष के मेमने थे। वेदी के समर्पण काल में ये चीज़े भेंट के रुप में दी गई। यह मुसा द्वारा अभीषेक का तेल उन पर डालने के बाद हुआ। ");
INSERT INTO hin2010_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","मूसा मीलापवाले तम्बू में यहोवा से बात करने गया। उस समय उसने अपने से बात करती हुई यहोवा की वाणी सुनी। वह वाणी साक्षीपत्र के सन्दूक के ऊपर के विशेष ढक्कन पर के दोनों करूबों के मध्य से आ रही थी। इस प्रकार परमेश्वर ने मूसा से बातें की। ");
INSERT INTO hin2010_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“हारून से बात करो और उससे कहो, उन स्थानों पर सात दीपकों को रखो जिन्हें मैंने तुम्हें दिखाया था। वे दीपक दीपाधार के सामने के क्षेत्र को प्रकाशित करेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","हारून ने यह किया। हारून ने दीपकों को उचित स्थान पर रखा और उनका रुख ऐसा कर दिया कि उससे दीपाधार के सामने का क्षेत्र प्रकाशित हो सके। उसने मूसा को दिये गए यहोवा के आदेश का पालन किया। ");
INSERT INTO hin2010_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","दीपाधार सोने की पट्टियों से बना था। सोने का उपयोग आधार से आरम्भ हुआ था और ऊपर सुनहरे फूलों तक पहुँचा हुआ था। यह सब उसी प्रकार बना था जैसा कि यहोवा ने मूसा को दिखाया था। ");
INSERT INTO hin2010_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“लेवीवंश के लोगों को इस्राएल के अन्य लोगों से अलग ले जाओ। उन लेवीवंशी लोगों को शुद्ध करो। ");
INSERT INTO hin2010_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","यह तुम्हें पवित्र बनाने के लिए करना होगा। पापबलि से विशेष पानी उन पर छिड़को। यह पानी उन्हें पवित्र करेगा। तब वे अपने शरीर के बाल कटवायेंगे तथा अपने कपड़ों को धोएंगे। यह उनके शरीर को शुद्ध करेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","“तब वे एक नया बैल और उसके साथ उपयोग में आने वाली अन्नबलि लेंगे। यह अन्नबलि, तेल मिला हुआ आटा होगा। तब अन्य बैल को पापबलि के रूप में लो। ");
INSERT INTO hin2010_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","लेवीवंश के लोगों को मिलापवाले तम्बू के सामने के क्षेत्र में लाओ। तब इस्राएल के सभी लोगों को चारों ओर से इकट्ठा करो। ");
INSERT INTO hin2010_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","तब तुम्हें लेवीवंश के लोगों को यहोवा के सामने लाना चाहिए और इस्राएल के लोग अपना हाथ उन पर रखेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","तब हारून लेवीवंश के लोगों को यहोवा के सामने लाएगा वे परमेस्वर के लिए भेंट के रूप में होंगे। इस ढंग से लेवीवंश के लोग यहोवा का विशेष कार्य करने के लिए तैयार होंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“लेवीवंश के लोगों से कहो कि वे अपना हाथ बैलों के सिर पर रखें। एक बैल यहोवा को पापबलि के रूप में होगा। दूसरा बैल यहोवा को होमबलि के रूप में काम आएगा। ये भेंटे लेवीवंश के लोगों को शुद्ध करेंगी। ");
INSERT INTO hin2010_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","लेवीवंश के लोगों से कहो कि वे हारून और उसके पुत्रों के सामने खड़े हों। तब यहोवा के सामने लेवीवंश के लोगों को उत्तोलन भेंट के रूप में प्रस्तुत करो। ");
INSERT INTO hin2010_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","यह लेवीवंश के लोगों को पवित्र बनायेगा। यह दिखायेगा कि वे परमेस्वर के लिये विशेष रीति से इस्तेमाल होंगे। वे इस्राएल के अन्य लोगों से भिन्न होंगे और लेवीवंश के लोग मेरे होंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“इसलिए लेवीवंश के लोगों को शुद्ध करो और उन्हें यहोवा के सामने उत्तोलन के रूप में प्रस्तुत करो। जब यह पूरा हो जाए तब वे आ सकते हैं और मिलापवाले तम्बू में अपना काम कर सकते हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ये लेवीवंशी इस्राएल के वे लोग हैं जो मुझको दिये गए हैं। मैंने उन्हें अपने लोगों के रूप में स्वीकार किया है। बीते समय में हर एक इस्राएल के परिवार में पहलौठा पुत्र मुझे दिया जाता था किन्तु मैंने लेवीवंशी के लोगों को इस्रएल के अन्य परिवारों के पहलौठे पुत्रों के स्थान पर स्वीकार किया है। ");
INSERT INTO hin2010_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","इस्राएल का हर पुरुष जो हर एक परिवार में पहलौठा है, मेरा है। यदि यह पुरुष या जानवर है तो भी मेरा है। मैंने मिस्र में सभी पहलौठे बच्चों और जानवरों को मार डाला था। इसलिए मैंने पहलौठे पुत्रों को अलग किया जिससे वे मेरे हो सकें। ");
INSERT INTO hin2010_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","अब मैंने लेवीवंशी लोगों को ले लिया है। मैंने इस्राएल के अन्य लोगों के परिवारों में पहलौठे बच्चों के स्थान पर इनको स्वीकार किया है। ");
INSERT INTO hin2010_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","मैंने इस्राएल के सभी लोगों में से लेवीवंश के लोगों को चुना है। मैंने उन्हें हारुन और उसके पुत्रों को इन्हें भेंट के रूप में दिया है। मैं चाहता हूँ कि वे मिलापवाले तम्बू में काम करें। वे इस्राएल के सभी लोगों के लिए सेवा करेंगे और वे उन बलिदानों को करने में सहायता करेंगे जो इस्राएल के लोगों के पापों को ढकने में सहायता करेंगी। तब कोई बड़ा रोग या कष्ट इस्राएल के लोगों को नहीं होगा जब वे पवित्र स्थान के पास आएंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","इसलिए मूसा, हारून और इस्राएल के सभी लोगों ने यहोवा का आदेश माना। उन्होंने लेवीवंशियों के प्रति वैसा ही किया जैसा उन के प्रति करने का यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","लेवीयों ने अपने को शुद्ध किया और अपने वस्त्रों को धोया। तब हारून ने उन्हें यहोवा के सामने उत्तोलन भेंट के रूप में प्रस्तुत किया। हारून ने वे भेंटे भी चढ़ाई जिन्होंने उनके पापों को नष्ट करके उन्हें शुद्ध किया था। ");
INSERT INTO hin2010_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","उसके बाद लेवीवंश के लोग अपना काम करने के लिए मिलापवाले तम्बू में आए। हारून और उसके पुत्रों ने उनकी देखभाल की। वे लेवीवंश के लोगों के कार्य के लिए उत्तरदायी थे। हारून और उसके पुत्रों ने उन आदेशों का पालन किया जिन्हें यहोवा ने मूसा को दिया था। ");
INSERT INTO hin2010_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“लेवीवंश के लोगों के लिए यह विशेष आदेश हैः हर एक लेवीवंशी पुरुष को, जो पच्चीस वर्ष या उससे अधिक उम्र का है, अवश्य आना चाहिए और मिलापवाले तम्बू के कामों में हाथ बटाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","जब कोई व्यक्ति पचास वर्ष का हो जाए तो उसे नित्य के कामों से छुट्टी लेनी चाहिए। उसे पून: काम करने की आवश्यकता नहीं है। ");
INSERT INTO hin2010_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","पचास वर्ष या उससे अधिक उम्र के लोग मिलापावाले तम्बू में अपने भाईयों को उनके काम में सहायता दे सकते हैं। किन्तु वे लोग स्वयं काम नहीं करेंगे।उन्हें सेवा—निवृत्त होने की स्वीकृति दी जाएगी। इसलिए उस समय लेवीवंश के लोगों से यह कहना याद रखो जब तुम उन्हें उनका सेवा—कार्य सौंपो।” ");
INSERT INTO hin2010_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","यहोवा ने मूसा को सीनै की मरूभूमि में कहा। उस समय से एक वर्ष और एक महीना हो गया जब इस्राएल के लोग मिस्र से निकले थे। यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“इस्राएल के लोगों से कहो कि वे निश्चित समय पर फसह पर्व की दावत को खाना याद रखें। ");
INSERT INTO hin2010_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","वह निश्चित समय इस महीने का चौदहवाँ दिन है। उन्हें संध्या के समय दावत खानी चाहिए और दावत के बारे में मैंने जो नियम दिए हैं उनको उन्हें याद रखना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","इसलिए मूसा ने इस्राएल के लोगों से फसह पर्व की दावत खाने को याद रखने के लिए कहा ");
INSERT INTO hin2010_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","और लोगों ने चौदहवें दिन संध्या के समय सीनै की मरुभूमि में वैसा ही किया। यह पहले महीने में था। इस्राएल के लोगों ने हर एक काम वैसे ही किया जैसे यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","किन्तु कुछ लोग फसह पर्व की दावत उसी दिन नहीं खा सके। वे एक शव के कारण शुद्ध नहीं थे। इसलिए वे उस दिन मूसा और हारून के पास गए। ");
INSERT INTO hin2010_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","उन लोगों ने मूसा से कहा, “हम लोग एक शव छूने के कारण अशुद्ध हुए हैं। याजकों ने हमें निश्चित समय पर यहोवा को चढ़ाई जाने वाली भेंट देने से रोक दिया है। अतः हम फसह पर्व को अन्य इस्राएली लोगों के साथ नहीं मना सकते। हमें क्या करना चाहिए” ");
INSERT INTO hin2010_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","मूसा ने उनसे कहा, “मैं यहोवा से पूछूंगा कि वह इस सम्बन्ध में क्या कहता है।” ");
INSERT INTO hin2010_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“इस्राएल के लोगों से ये बातें कहोः यह हो सगता है कि तुम ठीक समय पर फसह पर्व न मना सको क्योंकि तुम या तुम्हारे परिवार का कोई व्यक्ति शव को स्पर्श करने के कारण अशुद्ध हो या संभव है कि तुम किसी यात्रा पर गए हुए हो। ");
INSERT INTO hin2010_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","तो भी तुम फसह पर्व मना सकते हो। तुम फसह पर्व को दूसरे महीने के चौदहवें दिन संध्या के समय मनाओगे। उस समय तुम मेमना, अखमीरी रोटी और कड़वा सागपात खाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","अगली सुबह तक के लिए तुम्हें उसमें से कोई भी भोजन नहीं छोड़ना चाहिए। तुम्हें मेमने की किसी हड्डी को भी नहीं तोड़ना चाहिए। उस व्यक्ति को फसह पर्व के सभी नियमों का पालन करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","किन्तु कोई भी व्यक्ति जो समर्थ है, फसह पर्व की दावत को ठीक समय पर ही खाये। यदि वह शुद्ध है और किसी यात्रा पर नहीं गया है तो उसके लिए कोई बहाना नहीं है। यदि वह व्यक्ति फसह पर्व को ठीक समय पर नहीं खाता है तो उसे अपने लोगों से अलग भेज दिया जायेगा। वह अपराधी है! क्योंकि उसने यहोवा को ठीक समय पर अपनी भेंट नहीं चढ़ाई सो उसे दण्ड अवश्य दिया जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“तुम लोगों के साथ रहने वाला कोई भी व्यक्ति जो इस्राएलि लोगों का सदस्य नहीं है, यहोवा के फसह पर्व में तुम्हारे साथ भाग लेना चाह सकता है। यह स्वीकृत है, किन्तु उस व्यक्ति को उन नियमों का पालन करना होगा। जो तुम्हें दिए गए हैं. तुम्हें अन्य लोगों के लिए भी वे ही नियम रखने होंगे जो तुम्हारे लिए हैं।” ");
INSERT INTO hin2010_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","जिस दिन पवित्र साक्षीपत्र का तम्बू लगाया गया, एक बादल इसके ऊपर रूक गया। रात को बादल अग्नि की तरह दिखाई पड़ता था। ");
INSERT INTO hin2010_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","बादल तम्बू के ऊपर निरन्तर ठहरा रहा और रात को बादल अग्नि की तरह दिखाई दिया। ");
INSERT INTO hin2010_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","जब बादल तम्बू के ऊपर अपने स्थान से चलता था, इस्राएली इसका अनुसरण करते थे। जब बादल रुक जाता था तब इस्राएल के लोग वहीं अपना डेरा डालते थे। ");
INSERT INTO hin2010_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","यही ढंग था जिससे यहोवा इस्राएल के लोगों को यात्रा करने का आदेश देता था, और यही उसका उस स्थान के लिए आदेश था जहाँ उन्हें डेरा लगाना चाहिए था और जब तक बादल तम्बू के ऊपर ठहरता था।लोग उसी स्थान पर डेरा डाले रहते थे। ");
INSERT INTO hin2010_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","कभी—कभी बादल तम्बू के ऊपर लम्बे समय तक ठहरता था। इस्राएली यहोवा का आदेश मानते थे और यात्रा नहीं करते थे। ");
INSERT INTO hin2010_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","कभी—कभी बादल तम्बू के ऊपर कुछ हीं दिनों के लिए रहता था और लोग यहोवा के आदेश का पालन करते थे। वे बादल का अनु शरण तब करते जब वह तलता था। ");
INSERT INTO hin2010_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","कभी—कभी बादल केवल रात में ही ठहरता था और जब बादल अगली सुबह चलता था तब लोग अपनी चीज़े इकट्ठी करते थे और उसका अनुसरण करते थे, रात में या दिन में, यदि बादल चलता था तो लोग उसका अनुसरण करते थे। ");
INSERT INTO hin2010_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","यदि बादल तम्बू के ऊपर दो दिन या एक महीना या एक वर्ष ठहरता था तो लोग यहोवा के आदेश का पालन करते रहते थे। वे उसी डेरे में ठहरते थे और तब तक बादल अपने स्थान से उठता और चलता तब लोग भी चलते थे। ");
INSERT INTO hin2010_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","इस प्रकार लोग यहोवा के आदेश का पालन करते थे। वे वहाँ डेरा डालते थे जिस स्थान को यहोवा दिखाता था और जब यहोवा उन्हें स्थान छोड़ने के लिए आदेश देता था तब लोग बादल का अनुसरण करते हुए स्थान छोड़ते थे। लोग यहोवा के आदेश का पालन करते थे। यह आदेश था जिसे यहोवा ने मूसा के द्वारा उन्हें दिया। ");
INSERT INTO hin2010_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","यहोवा ने मूसा से कहाः ");
INSERT INTO hin2010_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“बिगुल बनाने के लिये चाँदी का उपयोग करो। चाँदी का पतरा बना कर उससे दो बिगुल बनाओ। ये बिगुल लोगों को एक साथ बुलाने और यह बताने के लिए होंगें कि डेरे को कब चलाना है। ");
INSERT INTO hin2010_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","जब तुम इन दोनों बिगुलों को बजाओगे, तो सभी लोगों को मिलापवाले तम्बू के सामने तुम्हारे आगे इकट्ठा हो जाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","यदि तुम केवल एक विगुल बजाते हो, तो नेता (इस्राएल के बारह परिवारों के मुखिया) तुम्हारे सामने इकट्ठे होंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“जब तुम बिगुल को पहली बार कम बजाओ, तब पूर्व में डेरा लगाए हुए परिवारों के समूहों को चलना आरम्भ कर देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","जब तुम बिगुल को दूसरी बार कम बजाओगे तो दक्षिण के डेरे को चलना आरम्भ कर देना चाहिए। बिगुल की ध्वनि यह घोषणा करेगी कि लोग चलें। ");
INSERT INTO hin2010_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","जब तुम सभी लोगों को इकट्ठा करना चाहते हो तो बिगुल को दूसरे ढंग से लम्बी स्थिर ध्वनि निकालते हुए बजाओ। ");
INSERT INTO hin2010_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","केवल हारून के याजक पुत्रों को बिगुल बजाना चाहिए। यह तुम लोगों के लिए नियम है जो भविष्य में माना जाता रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“यदि तुम अपने देश में किसी शत्रु से लड़ रहे हो तो, तुम उनके विरुद्ध जाने के पहले बिगुल को जोर से बजाओ। तब तुम्हारा परमेश्वर तुम्हारी बात सुनेगा, और वह तुम्हें तुम्हारे शत्रुओं से बचाएगा। ");
INSERT INTO hin2010_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","अपनी विशेष प्रसन्नता के समय में भी तुम्हें अपना बिगुल बजाना चाहिए। अपने विशेष पवित्र दिनों और नये चाँद की दावतों में बिगुल बजाओ और तुम्हारे परमेस्वर यहोवा को तुम्हें याद करने का यह विशेष तरीका होगा। मैं तुम्हें यह करने का आदेश देता हूँ, मैं तुम्हारा परमेस्वर यहोवा हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","दूसरे वर्ष के दूसरे महीने में इस्राएल के लोगों द्वारा मिस्र छोड़ने के बीसवें दिन के बाद साक्षीपत्र के तम्बू के ऊपर से बादल उठा। ");
INSERT INTO hin2010_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","इसलिए इस्राएल के सभी लोगों ने सीनै की मरुभूमि से यात्रा करनी आरम्भ की वे एक स्थान से दुसरे स्थान को यात्रा तब तक करते रहे जब तक बादल पारान की मरुभूमि में नहीं रूका। ");
INSERT INTO hin2010_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","यह पहला समय था कि लोगों ने अपने डेरों को वैसे चलाया जैसा यहोवा ने मूसा को आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","यहूदा के डेरे से तीन दल पहले गए। उन्होंने अपने झण्डे के साथ यात्रा की। पहला दल यहूदा के परिवार समूह का था। अम्मीनादाब का पुत्र नहशोन उस दल का नेता था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","उसके ठीक बाद इस्साकार का परिवार समूह आया। सूआर का पुत्र नतनेल उस दल का नेता था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","और तब जबूलून का परिवार समूह आया। हेलोन का पुत्र एलीआब उस दल का नेता था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","तब मिलापवाले तम्बू उतारे गए और गेर्शोन तथा मरारी के लोग पवित्र तम्बू को लेकर चले। इसलिए इन परिवारों के लोग पंक्ति में ठीक बाद में थे। ");
INSERT INTO hin2010_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","तब रूबेन के डेरे के तीन दल आए। उनहोंने अपने झण्डे के साथ यात्रा की। पहला दल रूबेन परिवार समूह का था। शदेऊर का पुत्र एलीआज़र इस दल का नेता था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","इसके ठीक बाद शिमोन का परिवार समूह आया। सूरीशद्दै का पुत्र शलूमीएल उस दल का नेता था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","और तब गाद का परिवार समूह आया। दूएल का पुत्र एल्यासाप उस दल का नेता था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","तब कहात परिवार के लोग आए। वे उन पवित्र चीज़ों को ले जा रहे थे जो पवित्र तम्बू में थीं। ये लोग इस समय इसलिए आए ताकि इन लोगों के पहुँचने के पहले पवित्र तम्बू लगा दिया जाए और तैयार कर दिया जाए। ");
INSERT INTO hin2010_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","इसके ठीक बाद एप्रैम के डेरे के तीन दल आए। उन्होंने अपने झण्डे के साथ यात्रा की। पहला दल एप्रैम के परिवार समूह का था। अम्मीहूद का पुत्र एलीशामा उस दल का नेता था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ठीक उसके बाद मनश्शे का परिवार समूह आया। पदासूर का पुत्र गम्लीएल उस दल का नेता था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","तब बिन्यामीन का परिवार समूह आया। गिदोनी का पुत्र अबीदान उस दल का नेता था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","पंक्ति में आखिरी तीन परिवार समूह अन्य सभी परिवार समूहों के लिए पृष्ठ रक्षक थे। ये दल दान के डेरे मे से थे। उन्होंने अपने झण्डे के साथ यात्रा की। पहला दल दान के परिवार समूह का था। अम्मीशद्दै का पुत्र अहीएजेर उस दल का नेता था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","उसके ठीक बाद आशेर का परिवार समूह आया। ओक्रान का पुत्र पजीएल उस दल का नेता था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","तब नप्ताली का परिवार समूह आया। एनान का पुत्र अहीरा उस दल का नेता था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","जब इस्राएल के लोग एक स्थान से दूसरे स्थान की यात्रा करते थे तब उनका यही ढंग था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","रूएल का पुत्र होबाब मिद्यानी था। (रूएल मूसा का ससुर था।) मूसा ने होबाब से कहा, “हम लोग उस देश की यात्रा कर रहे हैं जिसे परमेस्वर ने हम लोगों को देने का वचन दिया है। इसलिए हम लोगों के साथा आओ, हम लोग तुम्हारे साथ अच्छा व्यवहार करेंगे। परमेस्वर ने इस्राएल के लोगों को अच्छी चीजें देने का वचन दिया है।” ");
INSERT INTO hin2010_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","किन्तु होबाब ले उत्तर दिया, “नहीं, मैं तुम्हारे साथ नहीं जाऊँगा। मैं अपने देश और अपने लोगों के पास लौटूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","तब मूसा ने कहा, “हमें छोड़ो मत। तुम रेगिस्तान के बारे मे हम लोगों से अधिक जानते हो। तुम हमारे पथ पदर्शक हो सकते हो। ");
INSERT INTO hin2010_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","यदि तुम हम लोगों के साथ आते हो तो यहोवा जो कुछ अच्छी चीज़े देगा उसमें तुम्हारे साथ हम हिस्सा बटाऐंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","इसलिए होबाब मान गया और उन्होंने यहोवा के पर्वत से यात्रा आरम्भ की। याजकों ने यहोवा के साक्षीपत्र के पवित्र सन्दूक को लिया और लोगों के आगे चले। वे डेरा डालने के स्थान की खोज में तीन दिन तक पवित्र सन्दूक ढोते रहे। ");
INSERT INTO hin2010_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","यहोवा का बादल हर एक दिन उनके ऊपर था और हर एक सुबह जब वे अपने डेरे को छोड़ते थे तो उनको रास्ता दिखाने के लिए बादल वहाँ रहता था। ");
INSERT INTO hin2010_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","जब लोग पवित्र सन्दूक के साथ यात्रा आरम्भ करते थे और पवित्र सन्दक डेरे से बाहर ले जाया जाता था, मूसा सदा कहता था, “यहोवा, उठ! तेरे शत्रु सभी दिशाओं में भागें। जो लोग तेरे विरुद्ध हो तेरे सामने से भागें।” ");
INSERT INTO hin2010_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","और जब पवित्र सन्दूक अपनी जगह पर रखा जाता था तब मूसा सदा यह कहता था, “यहोवा, वापस आ, इस्राएल के लाखों लोगों के पास।” ");
INSERT INTO hin2010_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","इस समय लोगों ने अपने कष्टों के लिए शिकायत की। यहोवा ने उनकी शिकायतें सुनी। जब यहोवा ने ये बातें सुनी तो वह क्रोधित हुआ। यहोवा की तरफ से डेरे में आग लग गई। आग ने डेरे के छोर पर के कुछ हिस्से को जला दिया। ");
INSERT INTO hin2010_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","इसलिए लोगों ने मूसा को सहायता के लिये पुकारा। मूसा ने यहोवा से प्रार्थना की और आग का जलना बन्द हो गया। ");
INSERT INTO hin2010_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","इसलिए उस स्थान को तबेरा कहा गया। लोगों ने उस स्थान को यही नाम दिया क्योंकि यहोवा ने उनके बीच आग जला दी थी। ");
INSERT INTO hin2010_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","इस्राएल के लोगों के साथ जो विदेशी मिल गए थे अन्य चीज़े खाने की इच्छा करने लगे। शीघ्र ही इस्राएल के लोगों ने फिर शिकायत करनी आरम्भ की। लोगों ने कहा, “हम माँस खाना चाहते हैं! ");
INSERT INTO hin2010_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","हम लोग मिस्र में खायी गई मछलियों को याद करते हैं। उन मछलियों का कोई मुल्य नहीं देना पड़ता था। गम लोगों के पास बहुत सी सब्जियाँ थीं जैसे ककड़ियाँ, खरबूजे, गन्दे, पयाज और लहसुन। ");
INSERT INTO hin2010_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","किन्तु अब हम अपनी शक्ति खो चुके हैं हम और कुछ भी नहीं खाते, इस मन्ने के अतिरिक्त!” ");
INSERT INTO hin2010_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(मन्ना धनियाँ के बीज के समान था, वह गूगुल के पारदर्शी पीले गौंद के समान दिखता था। ");
INSERT INTO hin2010_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","लोग इसे इकट्ठा करते थे और तब इसे पीसकर आटा बनाते थे या वे इसे कुचलने के लिए चट्टान का उपयोग करते थे। तब वे इसे बर्तन में पाकते थे अथवा इसके “फुलके” बनाते थे। फुलके का स्वाद जैतून के तेल से पकी रोटी के समान होता था। ");
INSERT INTO hin2010_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","हर रात को जब भूमि ओस से गीली होती थी तो मन्ना भूमि पर गिरता था।) ");
INSERT INTO hin2010_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","मूसा ने हर एक परिवार के लोगों को अपने खेमों के द्वारे पर खड़े शिकायत करते सुना। यहोवा बहुत क्रोधित हुआ। इससे मूसा बहुत परेशान हो गया। ");
INSERT INTO hin2010_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","मूसा ने यहोवा से पूछा, “यहोवा, तूने अपने सेवक मुझ पर यह आपत्ति क्यों डाली है मैंने क्या किया है जो बुरा है। मैंने तुझे अप्रसन्न करने के लिए क्या किया है तूने मेरे ऊपर इन सभी लोगों का उत्तरदायित्व क्यों सौंपा है? ");
INSERT INTO hin2010_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","तू जानता है कि मैं इन सभी लोगों का पिता नहीं हुँ। तू जानता है कि मैंने इनको पैदा नहीं किया है। किन्तु यह तो ऐसे हैं कि मैं इन्हें अपनी गोद में वैसे ही ले चलूँ जैले कोई धाय बच्चे को ले चलती है। तू हमें ऐसा करने को विवश क्यों करता हैतू मुझे क्यों विवश करता है कि मैं इन्हें उस देश को ले जाऊँ जिसे देने का वचन तूने उनके पूर्वजों को दिया है ");
INSERT INTO hin2010_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","मेरे पास इन लोगों के लिए पर्याप्त माँस नहीं है, किन्तु वे लगातार मुझसे शिकायत कर रहे हैं। वे कहते हैं, ‘हमें खाने के लिए माँस दो!’ ");
INSERT INTO hin2010_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","मैं अकेले इन सभी लोगों की देखभाल नहीं कर सकता। यह बोझ मेरी बरदाश्त के बाहर है। ");
INSERT INTO hin2010_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","यदि तू उनके कष्ट को मुझे देकर चलाते रहना चाहता है तो तू मुझे अभी मार डाल। यदि तू मुझे अपना सेवक मानता है तो अभी मुझे मर जाने दे। तब मेरे सभी कष्ट समाप्त हो जाएंगे!” ");
INSERT INTO hin2010_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","यहोवा ने मूसा से कहा, “मेरे पास इस्राएल के ऐसे सत्तर अग्रजों को लाओ, जो लोगों के अग्रज और अधिकारी हों। इन्हें मिलापवाले तम्बू में लाओ। वहाँ उन्हें अपने साथ खड़ा करो। ");
INSERT INTO hin2010_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","तब मैं आऊँगा और तुमसे बातें करूँगा। अब तुम पर आत्मा आई है। किन्तु मैं उन्हें भी आत्मा का कुछ अंश दूँगा। तब वे लोगों की देखभाल करने में तुम्हारी सहायता करेंगे। इस प्रकार, तुमको अकेले इन लोगों के लिए उत्तरदायी नहीं होना पड़ेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“लोगों से कहोः कल के लिए अपने को तैयार करो। कल तुम लोग माँस खाओगे। यहोवा ने सुना है जब तुम लोग रोए—चिल्लाए। यहोवा ले तुम लोगों की बातें सुनीं जब तुम लोगों ने कहा, ‘हमें खाने के लिए माँस चाहिए! हम लोगों के लिए मिस्र में अच्छा था।’ अब यहोवा तुम लोगों को माँस देगा और तुम लोग उसे खाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","तुम लोग उसे केवल एक दिन नहीं, दो, पाँच, दस या बीस दिन भी खा सकोगे। ");
INSERT INTO hin2010_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","तुम लोग वह माँस, महीने भर खाओगे। तुम लोग वह माँस तब तक खाओगे जब तक उससे ऊब नहीं जाओगे। यह होगा, क्योंकि तुम लोगों ने यहोवा के विरुद्ध शिकायत की है। यहोवा तुम लोगों में घूमता है और तुम्हारी आवश्यकताओं को समझता है। किन्तु तुम लोग उसके सामने रोए—चिल्लाए और शिकायत की है! तुम लोगों ने कहा, हम लोगों ने आखिर मिस्र छोड़ा ही क्यों” ");
INSERT INTO hin2010_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","मूसा ने कहा, “यहोवा, यहाँ छः लाख पुरुष साथ चल रहे हैं और तू कहता है, ‘मैं उन्हें पूरे महीने खाने के लिए पर्याप्त माँस दूँगा!’ ");
INSERT INTO hin2010_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","यदि हमें सभी भेड़ें और मवेशी मारने पड़े तो भी इतनी बड़ी संख्या में लोगों के महीने भर खाने के लिए वह पर्याप्त नहीं होगा और यदि हम समुद्र की सारी मछलियाँ पकड़ लें तो भी उनके लिए वे पर्याप्त नहीं होंगी।” ");
INSERT INTO hin2010_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","किन्तु यहोवा ने मूसा से कहा, “यहोवा की शक्ति को सीमित न करो। तुम देखोगे कि यदि मैं कहता हूँ कि मैं कुछ करूँगा तो उसे मैं कर सकता हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","इसलिए मूसा लोगों से बात करने बाहर गया। मूसा ने उन्हें वह बताया जो यहोवा ने कहा था। तब मूसा ने सत्तर अग्रज नेताओं को इकट्ठा किया। मूसा ने उनसे तम्बू के चारों ओर खड़ा रहने को कहा। ");
INSERT INTO hin2010_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","तब यहोवा एक बादल में उतरा और उसने मूसा से बातें की। आत्मा मूसा पर थी। यहोवा ने उसी आत्मा को सत्तर अग्रज नेताओं पर भेजा। जब उनमें आत्मा आई तो वे भविष्यवाणी करने लगे। किन्तु यह केवल उसी समय हुआ जब उन्होंने ऐसा किया। ");
INSERT INTO hin2010_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","अग्रजों में से दो एलदाद और मेदाद तम्बू में नहीं गए। उनके नाम अग्रज नेताओं की सूची में थे। किन्तु वे डेरे में रहे किन्तु आत्मा उन पर भी आई और वे भी डेरे में भविष्यावाणी करने लगे। ");
INSERT INTO hin2010_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","एक युवक दौड़ा और मूसा से बोला। उस पुरुष ने कहा, “एलदाद और मेदाद डेरे में भविष्यावाणी कर रहे हैं।” ");
INSERT INTO hin2010_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","किन्तु नून के पुत्र यहोशू ने मूसा से कहा, “मूसा, तुम्हें उन्हें रोकना चाहिए!” (यहोशू मूसा का तब से सहायक था जब वह किशोर था।) ");
INSERT INTO hin2010_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","किन्तु मूसा ने उत्तर दिया, “क्या तुम्हें डर है कि लोग सोचेंगे कि अब मैं नेता नहीं हूँ मैं चाहता हूँ कि यहोवा के सभी लोग भविष्यवाणी करने योग्य हो। मैं चाहता हूँ कि यहोवा अपनी आत्मा उन सभी पर भेजे।” ");
INSERT INTO hin2010_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","तब मूसा और इस्राएल के नेता डेरे में लौट गए। ");
INSERT INTO hin2010_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","तब यहोवा ने समुद्र की ओर से भारी आंधी चलाई। आंधी ने उस क्षेत्र में बटेरों को पहुँचाया। बटेरें डेरों के चारों ओर उड़ने लगीं। वहाँ इतनी बटेरें थीं कि भूमि ढक गई। भूमि पर बटेरों की तीन फीट ऊँची परत जम गई थी। कोई व्यक्ति एक दिन में जितनी दूर जा सकता था उतनी दूर तक चारों ओर बटेरें थीं। ");
INSERT INTO hin2010_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","लोग बाहर निकले और पूरे दिन और पूरी रात बटेरों को इकट्ठा किया और फिर पूरे अगले दिन भी उन्होंने बटेरें इकट्ठी कीं। हर एक आदमी ने साठ बुशेल या उससे अधिक बटेरें इकट्ठी की। तब लोगों ने बटेरों को अपने डेरे के चारों ओर फैलाया। ");
INSERT INTO hin2010_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","लोगों ने माँस खाना आरम्भ किया किन्तु यहोवा बहुत क्रोधित हुआ। जब माँस उनके मुँह में था और लोग जब तक इसको खाना खत्म करें इसके पहले ही, यहोवा ने एक बीमारी लोगों में फेला दी। ");
INSERT INTO hin2010_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","इसलिए लोगों ने उस स्थान का नाम किब्रोथत्तावा रखा। उन्होंने उस स्थान को वह नाम इसलिए दिया कि यह वही स्थान है जहाँ उन्होंने उन लोगों को दफनाया था जो स्वादिष्ट भोजन की प्रबल इच्छा रखते थे। ");
INSERT INTO hin2010_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","किब्रोथत्तावा से लोगों ने हसेरोत की यात्रा की और वे वहीं ठहरे। ");
INSERT INTO hin2010_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","मरियम और हारून मूसा के विरुद्ध बात करने लगे। उन्होंने उसकी आलोचना की, क्योंकि उसकी पत्नी कूशी थी। उन्होंने सोचा कि यह अच्छा नहीं कि मूसा ने कूशी लोगों में से एक के साथ विवाह किया। ");
INSERT INTO hin2010_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","उन्होंने आपस में कहा, “यहोवा ने लोगों से बात करने के लिए मूसा का उपयोग किया है। किन्तु मूसा ही एकमात्र नहीं है। यहोवा ने हम लोगों के द्वारा भी कहा है।” यहोवा ने यह सुना। ");
INSERT INTO hin2010_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(मूसा बहुत विनम्र व्यक्ति था। वह न डींग हाँकता था,न शेखी बघारता था। वह धरती पर के किसी व्यक्ति से अधिक विनम्र था।) ");
INSERT INTO hin2010_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","इसलिए यहोवा अचानक आया और मूसा,हारून और मरियम से बोला। यहोवा ने कहा, “तुम तीनों को अब मिलापवाले तम्बू में आना चाहिए।” इसलिए मूसा, हारून और मरियम तम्बू में गए। ");
INSERT INTO hin2010_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","तब यहोवा बादल में उतरा। यहोवा तम्बू के द्वार पर खड़ा हुआ। यहोवा ने “हारून और मरियम” को अपने पास आने के लिए कहा! जब दोनों उसके समीप आए तो, ");
INSERT INTO hin2010_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","यहोवा ने कहा, “मेरी बात सुनो जब मैं तुम लोगों में नबी भेजूँगा, तब मैं अर्थात् यहोवा अपने आपको उसके दर्शन में दिखाऊँगा और मैं उससे उसके सपने में बात करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","किन्तु मैंने अपने सेवक मूसा के साथ ऐसा नहीं किया। मैंने उसे अपने सभी लोगों को ऊपर शक्ति दी है। ");
INSERT INTO hin2010_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","जब मैं उससे बात करता हूँ तो मैं उसके आमने सामने बात करता हूँ। मैं जो बात कहना चाहता हुँ उसे साफ—साफ कहता हुँ मैं छिपे अर्थ वाले विचित्र विचारों को उसके सामने नहीं रखता और मूसा यहोवा के स्वरूप को देख सकता है। इसलिए तुमने मेरे सेवक मूसा के विरुद्ध बोलने का साहस कैसे किया” ");
INSERT INTO hin2010_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","तब यहोवा उनके पास से गया। किन्तु वह उनसे बहुत क्रोधित था। ");
INSERT INTO hin2010_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","बादल तम्बू से उठा। तब हारून मुड़ा और उसने मरियम को देखा और उसे दिखाई पड़ा कि उसे भयंकर चर्मरोग हो गया है। उसकी त्वचा बर्फ की तरह सफेद थी! ");
INSERT INTO hin2010_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","तब हारून ने मूसा से कहा, “महोदय, कृपा करके जो मूर्खता भरा पाप हम लोगों ने किया है, उसके लिए क्षमा करें। ");
INSERT INTO hin2010_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","उसकी त्वचा का रंग उस प्रकार न उड़ने दे जैसा मरे हुए उत्पन्न बच्चे का होता है।” (कभी कभी इस प्रकार का बच्चा आधी गली हुई त्वचा के साथ उत्पन्न होता है।) ");
INSERT INTO hin2010_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","इसलिए मूसा ने यहोवा से प्रार्थना की, “परमेश्वर, कृपा करके इस बीमारी से उसे स्वस्थ कर!” ");
INSERT INTO hin2010_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","यहोवा ने मूसा को उत्तर दिया, “यदि उसका पिता उसके मुँह पर थूके, तो वह सात दिन तक लज्जित रहेगी। इसलिए उसे सात दिन तक डेरे से बाहर रखो। उस समय के बाद वह ठीक हो जायेगी। तब वह डेरे में वापस आ सकती है।” ");
INSERT INTO hin2010_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","इसलिए मरियम सात दिन के लिए डेरे से बाहर ले जाई गई और तब तक वे वहाँ से नहीं चले जब तक वह फिर वापस नहीं लाई गई। ");
INSERT INTO hin2010_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","उसके बाद लोगों ने हसेरोत को छोड़ा और पारान मरुभूमि की उन्होंने यात्रा की। लोगों ने उस मरुभूमि में डेरे लगाए। ");
INSERT INTO hin2010_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“कुछ व्यक्तियों को कनान देश का अध्ययन करने के लिए भेजो। यही वह देश है जिसे मैं इस्राएल के लोगों को दूँगा। हर एक बारह परिवार समूह से एक नेता को भेजो।” ");
INSERT INTO hin2010_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","इसलिए मूसा ने यहोवा की आज्ञा मानी। उसने परान के रेगिस्तान से नेताओं को भेजा। ");
INSERT INTO hin2010_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ये उनके नाम जककुर का पुत्र शम्मु—रुबेन के परिवार के समूह से, ");
INSERT INTO hin2010_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","होरी का पूत्र शापात—शिमोन के परिवार समूह से; ");
INSERT INTO hin2010_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","यपुन्ने का पुत्र कालेब—यहूदा के परिवार समूह से; ");
INSERT INTO hin2010_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","योसेप का पुत्र यिगास—इस्साकार के परिवार समूह से; ");
INSERT INTO hin2010_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","नून का पुत्र होशे—एप्रैम के परिवार समूह से; ");
INSERT INTO hin2010_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","रापू का पुत्र पलती—बिन्यामीन के परिवार समूह से; ");
INSERT INTO hin2010_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","सोदी का पुत्र गद्दीएल—जबूलून के परिवार समूह से; ");
INSERT INTO hin2010_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","सूसी का पुत्र गद्दी—मनश्शे के परिवार समूह से; ");
INSERT INTO hin2010_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","गमल्ली का पुत्र अम्मीएल—दान के परिवार समूह से; ");
INSERT INTO hin2010_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","मीकाएल का पुत्र सतूर—आशेर के परिवार समूह से; ");
INSERT INTO hin2010_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","वोप्सी का पुत्र नहूबी—नप्ताली परिवार समूह; ");
INSERT INTO hin2010_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","माकी का पुत्र गूएल—गाद के परिवार समूह से; ");
INSERT INTO hin2010_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ये उन व्यक्तियों के नाम हैं जिन्हें मूसा ने प्रदेश को देखने और जाँच करने के लिए भेजा। (मूसा से नून के पुत्र होशे को दूसरे नाम से पुकारा। मूसा ने उसे यहोशू कहा।) ");
INSERT INTO hin2010_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","मूसा जब उन्हें कनान की छानबीन के लिए भेज रहा था, तब उसने कहा, “गेवेक घाटी से होकर पहाड़ी प्रदेश में जाओ। ");
INSERT INTO hin2010_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","यह देखो कि देश कैसा दिखाई देता है? और उन लोगों की जानकारी प्राप्त करो जो वहाँ रहते हैं। वे शक्तिशाली हैं? या कमजोर हैं? वे थोड़े हैं? या अधिक संख्या में हैं? ");
INSERT INTO hin2010_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","उस प्रदेश के बारे में जानकारी करो जिसमें वे रहते हैं। क्या यह अच्छा प्रदेश है? या बुरा? किस प्रकार के नगरों में वे रहते हैं क्या उन नगरों के परकोटे हैं क्या नगर शक्तिशाली ढगं से सुरक्षित है? ");
INSERT INTO hin2010_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","और प्रदेश के बारे में अन्य बातों की जानकारी प्राप्त करो। क्या भूमि उपज के लिए उपजाऊ है? या ऊसर है? क्या जमीन पर पेड़ उगे हैं? और उस भूमि से कुछ फल लाने का प्रयत्न करो।” (यह उस समय की बात है जब अंगूर की पहली फसल पकी हो।) ");
INSERT INTO hin2010_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","तब उन्होंने प्रदेश की छानबीन की। वे जिन मरुभूमि से रहोब और लेबो हमात तक गए। ");
INSERT INTO hin2010_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","वे नेगेव से होकर तब तक यात्रा करते रहे जब तक वे हेब्रोन नगर को पहुँचे। (हेब्रोन मिस्र में सोअन नगर के बसने के सात वर्ष पहले बना था।) अहीमन, शेशै और तल्मै वहाँ रहते थे। ये लोग अनाक के वंशज थे। ");
INSERT INTO hin2010_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","तब वे लोग एश्कोन की घाटी में आये उन व्यक्तियो ने अंगूर की बेल की एक शाखा काटी। उस शाखा में अंगूर का एक गुच्छा था। लोगों मेंसे दो व्यक्ति अपने बीच एक डंडे पर उसे रख कर लाए। वे कुछ अनार ओर अंजीर भी लाए। ");
INSERT INTO hin2010_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","उस स्थान का नाम एश्कोल की घाटी था। क्योंकि यह वही स्थान हैं जहाँ इस्राएल के आदिनियों में अंगुर के गुच्छे काटे थे। ");
INSERT INTO hin2010_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","उन व्यक्तियों ने उस प्रदेश की छानबीन चालीस दिन तक की। तब वे डेरे को लौटे। ");
INSERT INTO hin2010_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","वे व्यक्ति मूसा, हारून और अन्य इस्राएल के लोगों के पास कादेश में लौटे। यह पारान मरुभूमि में था। तब उन्होंने मूसा, हारून और सभी लोगों को, जो कुछ देखा सब कुछ सुनाया और उन्होंने उन्हें उस प्रदेश के फलों को दिखाया। ");
INSERT INTO hin2010_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","उन लोगों ने मूसा से यह कहा, “हम लोग उस प्रदेश में गए जहाँ आपने हमें भजा। वह प्रदेश अत्यधिक अच्छा है यहाँ दूध और मधु की नदियाँ बह रही हैं! ये वे कुछ फल हैं जिन्हे हम लोगं ने वहाँ पाया ");
INSERT INTO hin2010_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","किन्तु वहाँ जो लोग रहते हैं, वे बहुत शक्तिशाली और मजबूत हैं। उनके नगर बहूत विशाल हैं। हम लोगों ने वहाँ उनके परिवार के कुछ लोगों को देखा भी। ");
INSERT INTO hin2010_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","अमालेकी लोग नेगेव की घाटी में रहते हैं। हित्ती, यबूसी और एमोरी पहाड़ी प्रदेशों में रहते हैं। कनानी लोग समुद्र के किनारे और यरदन नदी के किनारे रहते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","तब कालेब ने मूसा के समीप के लोगों को शान्त होने को कहा। कालेब ने कहा, “हम लोगों को वहाँ जाना चाहिए और उस प्रदेश को अपने लिए लेना चाहिए। हम लोग उस प्रदेश को सरलता से ले सकते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","किन्तु जो उसके साथ गया था, वह बोला, “हम लोग उन लोगों के विरुद्ध लड़ नहीं सकते। वे हम लोगों की तुलना में अधिक शक्तिशाली हैं।” ");
INSERT INTO hin2010_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","और उन लोगों ने सभी इस्राएली लोगों से कहा कि उस प्रदेश के लोगों को पराजित करने के लिए वे पर्याप्त शक्तिशानी नहीं हैं उन्होंने कहा, “जिस प्रदेश को हम लोगों ने देखा, वह शक्तिशाली लोगों से भरा है। वे लोग इतने अधिक शक्तिशाली हैं कि जो कोई व्यक्ति वहाँ जाएगा उसे वे सरलता से हरा सकते हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","हम लोगों ने वहाँ नपीलियों को देखा! (अनाक के परिवार के लोग जो नपीलों के वंश के थे।) उनके सामने खड़े होने पर हम लोगों ने अपने आपको टिड्डा अनुभव किया। उन लोगों ने हम लोगों को ऐसे देखा मानो टिड्डे के समान छोटे हों।” ");
INSERT INTO hin2010_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","उस हात डेरे के सब लोगों ने जोर से रोना आरम्भ किया। ");
INSERT INTO hin2010_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","इस्राएल के सभी लोगों ने हारून और मूसा के विरुद्ध फिर शिकायत की। सभी लोग एक साथ आए और मूसा तथा हारून से उन्होंने कहा, “हम लोगों को मिस्र या मरुभूमि में मर जाना चाहिए था, अपने नए प्रदेश में तलवार से मरने की अपेक्षा यह बहुत अच्छा रहा होता। ");
INSERT INTO hin2010_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","क्या यहोवा हम लोगों को इस नये प्रदेश में मरने के लिए लाया है हमारी पत्नियाँ और हमारे बच्चे हमसे छीन लिए जाएंगे और हम तलवार से मार डाले जाएंगे। यह हम लोगों के लिए अच्छा होगा कि हम लोग मिस्र को लौट जाएं।” ");
INSERT INTO hin2010_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","तब लोगों ने एक दूसरे से कहा, “हम लोगों को दूसरा नेता चुनना चाहिए और मिस्र चलना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","तब मूसा और हारून वहाँ इकट्ठे सारे इस्राएल के लोगों के सामने भूमि पर झुक गए। ");
INSERT INTO hin2010_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","उस प्रदेश की छानबीन करने वाले लोगों में से दो व्यक्ति बहुत परेशान हो गए। (वे दोनो नून का पुत्र यहोशू और यपुन्ने का पुत्र कालेब थे।) ");
INSERT INTO hin2010_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","इन दोनों ने वहाँ इकट्ठे इस्राएल के सभी लोगों से कहा, “जिस प्रदेश को हम लोगों ने देखा है वह बहुत अच्छा है। ");
INSERT INTO hin2010_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","और यदि यहोवा हम लोगों से प्रसन्न है तो वह हम लोगों को उस प्रदेश में ले चलेगा। वह प्रदेश सम्पन्न है, ऐसा है जैसे वहाँ दूध और मधु की नदियाँ बहती हो और यहोवा उस प्रदेश को हम लोगों को देने के लिए अपनी शक्ति का उपयोग करेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","किन्तु हम लोगों को यहोवा के विरुद्ध नहीं जाना चाहिए। हम लोगों को उस प्रदेश के लोगों से डरना नहीं चाहिए। हम लोग उन्हें सरलता से हरा देंगे। उनके पास कोई सुरक्षा नहीं है, उन्हें सुरक्षित रखने के लिए उनके पास कुछ नहीं है। किन्तु हम लोगों के साथ यहोवा है। इसलिए इन लोगों से डरो मत!” ");
INSERT INTO hin2010_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","तब इस्राएल के सभी लोग उन दोनों व्यक्तियों को पत्थरों से मार देने की बातें करने लगे। किन्तु यहोवा का तेज मिलापवाले तम्बू पर आया। इस्राएल के सभी लोग इसे देख सकते थे। ");
INSERT INTO hin2010_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","यहोवा ने मूसा से कहा, “ये लोग इस प्रकार मुझसे कब तक घृणा करते रहेंगे वे प्रकट कर रहे हैं कि वे मुज पर विस्वास नहीं करते। वे दिखाते हैं कि उन्हें मेरी शक्ति पर विस्वाश नहीं। वे मुझ पर विस्वास करने से तब भी इन्कार करते हैं जबकि मैंने उन्हें बहुत से शक्तिशाली चिन्ह दिखाये हैं। मैंने उनके बीच अकं बड़ी चीजें की हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","मैं उन्हें नष्ट कर दूँगा और तुम्हारा उपयोग दूसरा राष्ट बनाने के लिए करूँगा और तुम्हारा राष्ट्र इन लोगों से अधिक बड़ा और और अधिक शक्तिशाली होगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","तब मूसा ने यहोवा से कहा, “यदी तू ऐसा करता है तो मिस्र में लोग यह सुनेंगे कि तूने अपने सभी लोगों को मार डाला। तूने अपनी बड़ी शक्ति का उपयोग उन लोगों को मिस्र से बाहर लाने के लिए किया ");
INSERT INTO hin2010_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","और मिस्र के लोगों ने इसके बारे में कनान के लोगों को बताया है। वे पहले से ही जानते हैं कि तू यहोवा है। वे जानते हैं कि तू अपने लोगों के साथ है और वे जानते हैं कि तू प्रत्यक्ष है। इस देश में रहने वाले लोग उस बादल के बारे में जानेंगे जो लोगों के ऊपर ठहरता है तूने उस बादल का उपयोग दिन में अपने लोगों को रास्ता दिखाने के लिए किया और रात को वह बादल लोगों को रास्ता दिखाने के लिए आग बन जाता है। ");
INSERT INTO hin2010_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","इसलिए तुझे अब लोगों को मारना नहीं चाहिए। यदि तू उन्हें मारता है तो सभी राष्ट, जो तेरी शक्ति के बारे में सुन चुके हैं, कहेंगे, ");
INSERT INTO hin2010_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘यहोवा इन लोगों को उस प्रदेश में ले जाने में समर्थ नहीं था जिस प्रदेस को उसने उन्हें देने का वचन दिया था। इसलिए यहोवा ने उन्हें मरुभूमि में मार दिया।’ ");
INSERT INTO hin2010_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“इसलिए तुझे अपनी शक्ति दिखानी चाहिए। तुझे इसे वैसे ही दिखाना चाहिए जैसा दिखाने की घोषणा तूने की है। ");
INSERT INTO hin2010_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","तूने कहा था, ‘यहोवा क्रोधित होने में सहनशील है। यहोवा प्रेम से परिपूर्ण है। यहोवा पाप को क्षमा करता है और उन लोगों को क्षमा करता है जो उसके विरुद्ध भी हो जाते हैं। किन्तु यहोवा उन लोगों को अवश्य दण्ड देगा जो अपराधी हैं। यहोवा तो बच्चों को, उनके पितामह और प्रपितामह के पापों के लिए भी दण्ड द्ता है!’ ");
INSERT INTO hin2010_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","इसलिए इन लोगों को अपना महान प्रेम दिखा। उनके पाप को क्षमा कर। उनको उसी प्रकार क्षमा कर जि, प्रकार प्रकार तू उनको मिस्र छोड़ने के समय से अब तक क्षमा करता रहा है।” ");
INSERT INTO hin2010_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","यहोवा ने उत्तर दिया, “मैंने लोगों को तुम्हारे कहे अनुसार क्षमा कर दिया है। ");
INSERT INTO hin2010_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","किन्तु मैं तुमसे यह सत्य कहता हूँ, क्योंकि मैं शाशवत हूँ और मेरी शक्ति इस सारी पृथ्वी पर फैली है। अतः मैं तुमको यह वचन दूँगा। ");
INSERT INTO hin2010_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","उन लोगों में से कोई भी व्यक्ति जिसे मैं मीस्र से बाहर लाया, उस देश को कभी नहीं देखेगा। उन लोगों ने मिस्र में मेरे तेज और मेरे महान संकेतो को देखा है और उन लोगों ने उन महान कार्यों को देखा जो मैने मरुभूमि में किए। किन्तु उन्होंने मेरी आज्ञा का उल्लंघन किया और दस बार मेरी परीक्षा ली। ");
INSERT INTO hin2010_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","मैंने उनके पूर्वर्जों को वचन दिया था। मैंने प्रतिज्ञा की थी कि मैं उनको एक महान देश दूँगा। किन्तु उनमें से कोई भी व्यक्ति जो मेरे विरुद्ध में हो चुका है उस देश में प्रवेश नहीं करेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","किन्तु मेरा सेवक कालेब इनसे भिन्न है। वह पूरी तरह मेरा अनुसरण करता है। इसलिए मैं उसे उस देश में ले जाऊँगा जिसे उसने पहले देखा है और उसके लोग प्रदेश प्राप्त करेगें। ");
INSERT INTO hin2010_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","अमालेकियों और कनानी लोग घाटी में रह रहें हैं इसलिये तुम्हारे जाने के लिए कोई जगह नही है। कल इस स्थान को छोड़ो और रेगिस्तान की ओर लालसागर से होकर लौट जाओ।” ");
INSERT INTO hin2010_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ये लोग कब तक मेरे विरुद्ध शिकायत करते रहेंगे मैं इन लोगों की शिकायत और पीड़ा को सुन चुका हूँ। ");
INSERT INTO hin2010_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","इसलिए इनसे कहो, ‘यहोवा कहता है कि वह निश्चय ही सभी काम करेगा जिनके बारे में तुम लोगों की शिकायत है। ");
INSERT INTO hin2010_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","तुम लोगों को यह सब होगाः तुम लोगों के शरीर इस मरुभूमि में मरे हुए गिरेंगे। हर एक व्यक्ति जो बीस वर्ष में या अधिक उम्र का था हमारे लोंगों के सदस्य के रुप गिना गया और तुम लोगों के में से हर एक ने मेरे अर्थात् यहोवा के विरुद्ध शिकायत की। इसलिए तुम लोगों में से हर एक मरुभूमि में मरेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","तुम लोगों में से कोई भी कभी उस देश में प्रवेश नहीं करेगा जिसे मैंने तुमको देने का वचन दिया था। केवल यपुले का पुत्र कालेब और नून का पुत्र यहोशू उस देश में प्रवेश करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","तुम लोग डर गए थे और तुम लोगों ने शिकायत की कि उस नये देश में तुम्हारे शत्रु तुम्हारे बच्चों को तुमसे छीन लेंगे। किन्तु मैं तुमसे कहता हूँ कि मैं उन बच्चों को उस देश में ले जाऊँगा। वे उन चीज़ों का भोग करेंगे जिनका भोग करना तुमने स्वीकार नहीं किया। ");
INSERT INTO hin2010_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","जहाँ तक तुम लोगों की बात है, तुम्हारे शरीर इस मरुभूमि में गिर जाएंगे।’” ");
INSERT INTO hin2010_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","“‘तुम्हारे बच्चे यहाँ मरुभूमि में चालीस वर्ष तक गड़ेंरिए रहेंगे। उनको यह कष्ट होगा क्योंकि तुम लोगों ने विश्वास नहीं किया। वे इस मरुभूमि में तब तक रहेंगे जब तक तुम सभी यहाँ मर नहीं जाओगे। तब तुम सबके शरीर इस मरुभूमि में दफन हो जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","तुम लोग अपने पाप के लिए चालीस वर्ष तक कष्ट भोगोगे। (तुम लोगों ने इस देश की छानबीन में जो चालीस दिन लागए उसके प्रत्येक दिन के लिए एक वर्ष होगा।) तुम लोग जानोगे कि मेरा तुम लोगों के विरुद्ध होना कितना भयानक है। ");
INSERT INTO hin2010_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","“मैं यहोवा हूँ और मैंने यह कहा है। मैं वचन देता हूँ कि मैं इन सभी बुरे लोगों के लिए यह करुँगा। ये लोग मेरे विरुद्ध एक साथ आए इसलिए वे सभी यहाँ मरुभूमि में मरेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","जिन लोगों को मूसा ने नये प्रदेश की छानबीन के लिए भेजा, वे ऐसे थे जो लौट आए और जो सभी इस्राएलियों में शिकायत करते हुए फैल गए। उन लोगों ने कहा कि लोग उस प्रदेश में प्रवेश करने के लिए पर्याप्त शक्तिशाली नहीं हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","वे लोग इस्राएली लोगों में परेशानी फैलाने के लिए उत्तरदायी थे। इसलिए यहोवा ने एक बीमारी उत्पन्न करके उन सभी को मर जाने दिया। ");
INSERT INTO hin2010_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","किन्तु नून का पुत्र यहोशू और यपुन्ने का पुत्र कालेब उन लोगों में थे जिन्हें देश की छानबीन करने के लिए भेजा गया था और यहोवा ने उन दोनों आदमियों को बचाया। उनको वह बीमारी नहीं हुई जिसने अन्य लोगों को मार डाला। ");
INSERT INTO hin2010_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","मूसा ने ये सभी बातें इस्राएल के लोगों से कहीं। लोग बहुत अधिक दुःखी हुए। ");
INSERT INTO hin2010_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","अगले दिन बहुत सवेरे लोगों ने ऊँचे पहाड़ी प्रदेश की ओर बढ़ना आरम्भ किया। लोगों ने कहा, “हम लोगों ने पाप किया है। हम लोगों को दुःख है कि गम लोगों ने यहोवा पर विश्वास नहीं किया। हम लोग उस स्थान पर जाएंगे जिसे यहोवा ने देने का वचन दिया है।” ");
INSERT INTO hin2010_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","किन्तु मूसा ने कहा, “तुम लोग यहोवा के आदेश का पालन क्यों नहीं कर रहे होतूम लोग सफल नहीं हो सकोगे। ");
INSERT INTO hin2010_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","उस देश में प्रवेश न करो।यहोवा तूम लोगों के साथ नहीं है। तुम लोग सरलता से अपने शत्रुओं से हार जाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","अमालेकी और कनानी लोग वहाँ तुम्हारे विरुद्ध लड़ेंगे। तुम लोग यहोवा से विमुख हुए हो। इसलिए वह तुम लोगों के साथ नहीं होगा जब तुम लोग उनसे लड़ोगे और तुम सभी उनकी तलवार से मारे जाओगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","किन्तु लोगों ने मूसा पर विश्वास नहीं किया। वे ऊँचे पहाड़ी प्रदेश की ओर गए। किन्तु मूसा और यहोवा का साक्षीपत्र का सन्दूक लोगों के साथ नहीं गया। ");
INSERT INTO hin2010_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","तब अमालेकी और कनानी लोग जो पहाड़ी प्रदेशों में रहते थे, आए और उन्होंने इस्राएली लोगों पर आक्रमण कर दिया। अमालेकी और कनानी लोगों ने उनको सरलता से हरा दिया और होर्मा तक उनका पीछा किया। ");
INSERT INTO hin2010_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“इस्राएल के लोगों से बातें करो और उनसे कहोः तुम लोग ऐसे प्रदेश में प्रवेश करोगे जिसे मैं तुम लोगों को तुम्हारे घर के रूप में दे रहा हूँ। ");
INSERT INTO hin2010_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","जब तुम उस प्रदेश में पहुँचोगे तब तुम्हें यहोवा को आग द्वारा विशेष भेंट दनी चाहिए। इसकी सुगन्ध यहोवा को प्रसन्न करेगी। तुम अपनी गायें, भेड़ें और बकरियों का इस्तेमाल होमबलि, बलिदानों, विशेष मनौतियों, मेलबलि, शान्ति भेंट या विशेष पर्वों में करोगे। ");
INSERT INTO hin2010_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","“और उस समय जो अपनी भेंट लाएगा उसे यहोवा को अन्नबलि भी देनी होगी। यह अन्नबलि एक क्वार्ट जैतून के तेल में मिली हुई दो क्वार्ट अच्छे आटे की होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","हर एक बार जब तुम एक मेमना होमबलि के रूप में दो तो तुम्हें एक क्वार्ट दाखमधु पेय भेंट के रूप में तैयार करनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“यदि तुम एक मेढ़ा दे रहे हो तो तुम्हें अन्नबलि भी तैयार करनी चाहिए। यह अन्नबलि एक चौथाई क्वार्ट जैतून के तेल में मिली हुई चार क्वार्ट अच्छे आटे की होनी चाहीए ");
INSERT INTO hin2010_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","और तुम्हें एक चौथाई क्वार्ट दाखमधु पेय भेंट के रूप में तैयार करनी चाहीए। इसे यहोवा को भेंट करो। इसकी सुगन्ध यहोवा को प्रसन्न करेगी। ");
INSERT INTO hin2010_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“होमबलि, शान्ति भेंट अथवा किसी मन्नौती के लिए यहोवा को भेंट के रूप में तुम एक बछड़े को तैयार कर सकते हो। ");
INSERT INTO hin2010_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","इसलिए तुम्हें बैल के साथ अन्नबलि भी लानी चाहिए। अन्नबलि दो क्वार्ट जैतून के तेल में मिली हुई छः क्वार्ट अच्छे आटे की होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","दो क्वार्ट दाखमधु भी पेय भेंट के रूप में लाओ। आग में जलाई गई यह भेंट यहोवा के लिए मधुर गन्ध होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","प्रत्येक बैल या मेढ़ा या मेमना या बकरी का बच्चा, जिसे तुम यहोवा को भेंट करो, उसी प्रकार तैयार होना चारिए। ");
INSERT INTO hin2010_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","जो जानवर तुम भेंट करो उनमें से हर एक के लिए यह करो। ");
INSERT INTO hin2010_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“इसलिए जब लोग यह होमबलि देंगे तो यहोवा को यह सुगन्ध प्रसन्न करेगी। किन्तु इस्राएल के हर एक नागरिक को इसे वैसे ही करना चाहिए जिस प्रकार मैंने बताया है। ");
INSERT INTO hin2010_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","और भविष्य के सभी दिनों में, यदि कोई व्यक्ति जो इस्राएल के परिवार में उत्पन्न नहीं है और तुम्हारे बीच रह रहा है तो उसे भी इन सब चीजों का पालन करना चाहिए। उसे ये वैसे ही करना होगा जैसा मैंने तुमको बताया है। ");
INSERT INTO hin2010_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","इस्राएल के परिवार में उत्पन्न लोगों के लिये जो नियम होगें वही नियम उन अन्य लोगों के लिये भी होंगे जो तुम्हारे बीच रहते हैं। यह नियम अब से भविष्य में लागू रहेगा। तुम और तुम्हारे बीच रहने वाले लोग यहोवा के सामने समान होंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","इसका यह तात्पर्य है कि तुम्हें एक ही विधि और नियम का पालन करना चाहिए। वे नियम इस्राएल के परिवार में उत्पन्न तुम्हारे लिए औ अन्य लोगों के लिए भी है जो तुम्हारे बीज रहते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“इस्राएल के लोगों से यह कहोः मैं तुम्हें दूसरे देश में ले जा रहा हुँ। ");
INSERT INTO hin2010_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","जब तूम भोजन करो जो उस प्रदेश में उत्पन्न हो तो भोजन का कुछ अंश यहोवा को भेंट के रूप में दो। ");
INSERT INTO hin2010_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","तुम अन्न इकट्ठा करोगे और इसे आटे के रूप में पीसोगे और उसे रोटी बनाने के लिए गुँदोगे। फिर उस आटे की पहली रोटी को यहोवा को अर्पित करोगे। वह ऐसी अन्नबलि होगी जो खलिहान से आती है। ");
INSERT INTO hin2010_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","यह नियम सदा सर्वदा के लिए है। इसका तात्पर्य है कि जिस अन्न को तुम आटे के रूप में माढ़ते हो, उसकी पहली रोटी यहोवा को अर्पित की जानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“यदि तुम यहोवा द्वारा मूसा को दिये गए आदेशों मे से किसी का पालन करना भूल जाओ तो तुम क्या करोगे ");
INSERT INTO hin2010_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ये आदेश उसी दिन से आरम्भ हो गए थे जिस दिन यहोवा ने इन्हें तुमको दिया था और ये आदेश भविष्य में भी लागू रहेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","इसलिये यदि तुम कोई गलती करते हो और इन सभी आज्ञाओं का पालन करना भूल जाते हो तो तुम क्या करोगे यदि इस्राएल के सभी लोग गलती करते हैं, तो सभी लोगों को मिलकर एक बछड़ा यहोवा को भेंट चढ़ाना चाहिए। यह होमबलि होगी और इसकी यह सुगन्ध यहोवा को प्रसन्न करेगी। बैल के साथ अन्नबलि और पेय भेंट भी याद रखो और तुम्हें एक बकरा भी पापबलि के रूप में देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","“याजक लोगों को पापों से शुद्ध करने के लिये ऐसा करेगा। वह इस्राएल के सभी लोगों के लिए ऐसा करेगा। लोगों ने नहीं जाना था कि वे पाप करत रहे हैं। किन्तु जब उन्होंने यह जाना तब वे यहोवा के पास भेंट लाए। वे एक भेंट अपने पाप के लिए देने आए और एक होमबलि के लिये जिसे आग में जलाया जाना था।इस प्रकार लोग क्षमा किये जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","इस्राएल के सभी लोग और उनके बीच रहने वाले सभी अन्य लोग क्षमा कर दिये जाएंगे। वे इसलिए क्षमा किये जाएंगे क्योंकि वे नहीं जानते थे कि वे बुरा कर रहे हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“किन्तु यदि एक व्यक्ति आदेश का पालन करना भूल जाता है तो उसे एक वर्ष की बकरी पापबलि के रूप में लानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","याजक इसे उस व्यक्ति के पापों के लिए यहोवा को अर्पित करेगा और उस व्यक्ति को क्षमा कर दिया जाएगा क्योंकि याजक ने उसके लिए भुगतान कर दिया है। ");
INSERT INTO hin2010_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","यही हर उस व्यक्ति के लिए नियम है जो पाप करता है, किन्तु जानता नहीं कि बुरा किया है। यही नियम इस्राएल के परिवार में उत्पन्न लोगों के लिए है या अन्य लोगों के लिए भी जो तुम्हारे बीच में रहते हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“किन्तु कोई व्यक्ति जो पाप करता है और जानता है कि वह बुरा कर रहा है, वह यहोवा का अपमान करता है। उस व्यक्ति को अपने लोगों से अलग भेज देना चाहिए। यह इस्राएल के परिवार में उत्पन्न व्यक्ति तथा किसी भी अन्य व्यक्ति के लिए, जो तुम्हारे बीच रहता है, समान है। ");
INSERT INTO hin2010_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","वह व्यक्ति यहोवा के आदेश के विरुद्ध गया है। उसने यहोवा के आदेश का पालन नहीं किया है। उस व्यक्ति को तुम्हारे समूह से अलग कर दिया जाना चाहिए। वह व्यक्ति अपराधी ही रहेगा और दण्ड का भागी होगा!” ");
INSERT INTO hin2010_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","इस समय, इस्राएल के लोग अभी तक मरुभूमि में ही थे। ऐसा हुआ कि एक व्यक्ति को जलाने के लिए कुच लकड़ी मिली। इसलिए वह व्यक्ति लकड़ियाँ इकट्ठी करता रहा। किन्तु वह सब्त (विश्राम) का दिन था। कुछ अन्य लोगों ने उसे यह करते देखा। ");
INSERT INTO hin2010_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","जिन लोगों ने उसे लकड़ी इकट्ठी करते देखा, वे उसे मूसा और हारून के पास लाए और सभी लोग चारों ओर इकट्ठे हो गए। ");
INSERT INTO hin2010_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","उन्होंने उस व्यक्ति को वहाँ रखा क्योंकि वे नहीं जानते थे कि उसे कैसे दण्ड दें। ");
INSERT INTO hin2010_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","तब यहोवा ने मूसा से कहा, “इस व्यक्ति को मरना चाहिए। सभी लोग डेरे से बाहर इसे पत्थर से मारेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","इसलिए लोग उसे डेरे से बाहर ले गए और उसे पत्थरों से मार डाला। उन्होंने यह वैसे ही किया जैसा मूसा को यहोवा ने आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“इस्राएल के लोगों से बातें करो और उनसे यह कहोः मैं तुम लोगों को कुछ अपने आदेशों को याद रखने के लिए दूँगा। धागे के कई टुकड़ों को एक साथ बांधकर उन्हें अपने वस्त्रों के कोने पर बांधो। एक नीले रंग का धागा हर एक ऐसी गुच्छियों में डालो। तुम इन्हें अब से हमेशा के लिये पहनोगे। ");
INSERT INTO hin2010_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","तुम लोग इन गुच्छियों को देखते रहोगे और यहोवा ने जो आदेश तुम्हें दिये हैं, उन्हें याद रखोगे। तब तुम आदेशों का पालन करोगे। तुम लोग आदेशों को नहीं भूलोगे और आँखों तथा शरीर की आवश्यकताओं से प्रेरित होकर कोई पाप नहीं करोगे। ");
INSERT INTO hin2010_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","तुम हमारे सभी आदेशों के पालन की बात याद रखोगे। तब तुम यहोवा के विशेष लोग बनोगे। ");
INSERT INTO hin2010_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","मैं तुम्हारा परमेश्वर यहोवा हूँ। वह मैं हूँ जो तुम्हें मिस्र से बाहर लाया। मैंने यह किया अतः मैं तुम्हारा परमेश्वर रहूँगा। मैं तुम्हारा परमेश्वर यहोवा हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","कोरह दातान, अबीराम ओर ओन मूसा के विरुद्ध हो गए। (कोरह यिसहार का पुत्र था। यिसहार कहात का पुत्र था, और कहात लेवी का पुत्र था। एलीआब के पुत्र दातान और अबीराम भाई थे और ओन पेलेत का पुत्र था। दातान, अबीराम और ओन रूबेन के वंशज थे।) ");
INSERT INTO hin2010_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","इन चार व्यक्तियों ने इस्राएल के दो सौ पचास व्यक्तियो को एक साथ इकट्ठा किया ओर ये मूसा के विरुद्ध आए। ये दो सौ पचास इस्राएली व्यक्ति लोगों में आदरणीय नेता थे। वे समिति के सदस्य चुने गए थे। ");
INSERT INTO hin2010_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","वे एक समूह के रूप में मूसा और हारून के विरुद्ध बात करने आए। इन व्यक्तियों ने मूसा और हारून से कहा, “हम उससे सहमत नहीं जो तुमने किया है। इस्राएली समूह के सभी लोग पवित्र हैं। यहोवा उनके साथ है। तुम अपने को सभी लोगों से ऊँचे स्थान पर क्यों रख रहेहो” ");
INSERT INTO hin2010_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","जब मूसा ने यह बात सुना तो वह भूमि पर गिर गया। ");
INSERT INTO hin2010_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","तब मूसा ने कोरह और उसके अनुयायियों से कहा, “कल सवेरे यहोवा दिखाएगा कि कौन व्यक्ति सचमुच उसका है। यहोवा दिखाएगा कि कौन व्यक्ति सचमुच पवित्र है और यहोवा उसे अपने समीप ले जाएगा। यहोवा उस व्यक्ति को चुनेगा और यहोवा उस व्यक्ति को अपने निकट लेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","इसलिए कोरह, तुम्हें और तुम्हारे सभी अनुयायियों को यह करना चाहिएः ");
INSERT INTO hin2010_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","किसी विशेष अग्निपात्र में आग और सुगन्धित धूप रखो। तब उन पात्रों को यहोवा के सामने लाओ। यहोवा एक पुरुष को चुनेगा जो सचमुच पवित्र होगा। किन्तु मुझे डर है कि तुमने और तुम्हारे लेवीवंशी भाईयों ने सीमा का अतिक्रमण किया है।” ");
INSERT INTO hin2010_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","मूसा ने कोरह से यह भी कहा, “लेविवंशियों! मेरी बात सुनो। ");
INSERT INTO hin2010_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","तुम लोगों को प्रसन्न होना चाहिए कि इस्राएल के परमेश्वर ने तुम लोगों को अलग और विशेष बनाया है। तुम लोग बाकी इस्राएली लोगों से भिन्न हो। यहोवा ने तुम्हें अपने समीप लिया जिससे तुम यहोवा की उपासना में इस्राएल के लोगों की सहायता के लिए यहोवा के पवित्र तम्बू में विशेष कार्य कर सको। क्या यह पर्याप्त नहीं है ");
INSERT INTO hin2010_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","यहोवा ने तुम्हें और अन्य सभी लेवीवंश के लोगों को अपने समीप लिया है। किन्तु अब तुम याजक भी बनना चाहते हो। ");
INSERT INTO hin2010_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","तुम और तुम्हारे अनुयायी परस्पर एकत्र होकर यहोवा के विरोध में आए हो। क्या हारून ने कुछ बुरा किया है नहीं।तो फिर उसके विरुद्ध शिकायत करने क्यों आए हो” ");
INSERT INTO hin2010_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","तब मूसा ने एलीआब के पुत्रों दातान और अबीराम को बुलाया। किन्तु दोनोम आदमियों ने कहा, “हम लोग नहीं आएंगे! ");
INSERT INTO hin2010_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","तुम हमें उस देश से बाहर निकाल लाए हो जो सम्पनन था और जहाँ दूध और मधु की नदियाँ बहती थीं। तुम हम लोगों को यहाँ मरुभूमि में मारने के लिए लाए हो और अब तुम दिखाना चाहते हो कि तुम हम लोगों पर अधिक अधिकार भी रखते हो। ");
INSERT INTO hin2010_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","हम लोग तुम्हारा अनुसरण क्यों करें तुम हम लोगों को उस नये देश में नहीं लाए हो जो सम्पन्न है और जिसमें दूध और मधु की नदियाँ बहती हैं। तुमने हम लोगों को वह देश नहीं दिया है जिसे देने का वचन यहोवा ने दिया था। तुमने हम लोगों को खेत या अंगूर के बाग नहीं दिये हैं। क्या तुम इन लोगों को अपना गुलाम बनाओगे नहीं!हम लोग नहीं आएंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","इसलिए मूसा बहुत क्रोधित हो गया। उसने यहोवा से कहा, “इनकी भेंटे स्वीकार न कर! मैंने इनसे कुछ नहीं लिया है एक गधा तक नहीं और मैंने इनमें से किसी का बुरा नहीं किया है।” ");
INSERT INTO hin2010_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","तब मूसा ने कोरह से कहा, “तुम्हें और तुम्हारे अनुयायियों को कल यहोवा के सामने खड़ा होना चाहिए। हारून तुम्हारे साथ यहोवा के सामने खड़ा होगा। ");
INSERT INTO hin2010_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","तुम में से हर एक को एक अग्निपात्र लेना चाहिए और उसमें धूप रखनी चाहिए। ये दो सौ पचास अग्निपात्र प्रमुखों के लिये होंगे। हर एक अग्निपात्र को यहोवा के सामने ले जाओ। तुम्हें और हारून को अपने अग्निपात्रों को यहोवा के सामने ले जाना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","इसलिए हर एक व्यक्ति ने एक अग्निपात्र लिया और उसमें जलती हुई धूप रखी। तब वे मिलापवाले तम्बू के द्वार पर खड़े हुए।मूसा और हारुन भी वहाँ खड़े हुए। ");
INSERT INTO hin2010_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","कोरह ने अपने सभी अनुयायियों को एक साथ इकट्ठा किया। ये वे व्यक्ति हैं जो मूसा और हारून के विरुद्ध हो गए थे। कोरह ने उन सभी को मिलावाले तम्बू के द्वार पर इकट्ठा किया। तब यहोवा का तेज वहाँ हर एक व्यक्ति पर प्रकट हुआ। ");
INSERT INTO hin2010_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“इन पुरुषों से दूर हटो! मैं अब उन्हें नष्ट करना चाहता हूँ!” ");
INSERT INTO hin2010_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","किन्तु मूसा और हारून भूमि पर गिर पड़े और चिल्लाए, “हे परमेश्वर, तू जानता है कि लोग क्या सोच रहे हैं। कृपा करके इस पूरे समूह पर क्रोधित न हो। एक ही व्यक्ति ने सचमुच पाप किया है।” ");
INSERT INTO hin2010_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“लोगों से कहो कि वे कोरह दातान और अबीराम के डेरों से दूर हट जाए।” ");
INSERT INTO hin2010_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","मूसा खड़ा हुआ और दातान और अबिराम के पास गया। इस्राएल के सभी अग्रज (नेता) उसके पीछे चले। ");
INSERT INTO hin2010_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","मूसा ने लोगों को चेतावनी दी, “इन बुरे आदमियों के डेरों से दूर हट जाओ। इनकी किसी चीज को नो छुओ! यदि तुम लोग छूओगे तो इनके पापों के कारण नष्ट हो जाओगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","इसलिए लोग कोरह, दातान और अबीराम के तम्बुओं से दूर हट गए। दातान और अबीराम अपने डेरे के बाहर अपनी पत्नी, बच्चे और छोटे शिशुओं के साथ खड़े थे। ");
INSERT INTO hin2010_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","तब मूसा ने कहा, “मैं प्रमाण प्रस्तुत करूँगा कि यहोवा ने मुझे उन चीज़ों को करने के लिए भेजा है जो मैंने तुमको कहा है। मैं दिखाऊँगा कि वे सभी मेरे विचार नहीं थे। ");
INSERT INTO hin2010_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ये पुरुष यहाँ मरेंगे। किन्तु यदि ये सामान्य ढंग से मरते हैं अर्थात् जिस प्रकार आदमी सदा मरते हैं तो यह प्रकट करेगा कि यहोवा ने वस्तुतः मुझे नहीं भेजा है। ");
INSERT INTO hin2010_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","किन्तु यदि यहोवा इन्हें दूसरे ढंग अर्थात् कुछ नये ढंग से मरने देता है तो तुम लोग जानोगे कि इन व्यक्तियों ने सचमुच यहोवा के विरुद्ध पाप किया है। पृथ्वी फटेगी और इन व्यक्तियों को निगल लेगी। वे अपनी कब्रों में जीवित ही जाएंगे और इनकी हर एक चीज इनके साथ नीचे चली जाएगी।” ");
INSERT INTO hin2010_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","जव मूसा ने इन बातों का कहना समाप्त किया, व्यक्तियों के पैरों के नीचे पृथ्वी फटी। ");
INSERT INTO hin2010_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","यह ऐसा था मानों पृथ्वी ने अपना मुँह खोला ओ इन्हें खा गई और उनके सारे परिवार औ कोरह के सभी व्यक्ति तथा उनकी सभी चीजें पृथ्वी में चली गई। ");
INSERT INTO hin2010_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","वे जीवित ही कब्र में चले गए। उनकी हर एक चीज उनके साथ गई। तब पृथ्वी उनके ऊपर से बन्द हो गई। वे नष्ट हो गए और वे उस डेरे से लुप्त गो गए। ");
INSERT INTO hin2010_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","इस्राएल के लोगों ने नष्ट किये जाते हुए लोगों का रोना चिल्लाना सुना। इसलिए वे चारों ओर दौड़ पड़े और कहने लगे, “पृथ्वी हम लोगों को भी निगल जाएगी।” ");
INSERT INTO hin2010_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","तब यहोवा से आग आई और उसने दो सौ पचास पुरुषों को, जो सुगन्धि भेंट कर रहे थे, नष्ट कर दिया। ");
INSERT INTO hin2010_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","38","“हारून के पुत्र याजक एलीआजार से कहो कि वह आग में से सुगन्धि के पात्रों को एकत्र करे। डेरे से दूर के क्षेत्र में उन कोयलों को फैलाओ। सुगन्धि के बर्तन अब भी पवित्र हैं। ये वे पात्र है जो उन व्यक्तियों के है जिन्होंने मेरे विरुद्ध पाप किया था। उनके पाप का मूल्य उनका जीवन हुआ। बर्तनों को पीट कर पत्तरों में बदलो। इन धातुओं के पत्तरों का उपयोग वेदी को ढकने के लिए करो। वे पवित्र थे क्योंकि उन्हें यहोवा के सामने प्रस्तुत किया गया था। उन चपटे बर्तनों को इस्राएल के सभी लोगों के लिए चेतावनी बनने दो।” ");
INSERT INTO hin2010_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","तब याजक एलीआजार ने काँसे के उन सभी बर्तनों को इकट्ठा किया जिन्हें वे लोग लाए थे। वे सभी व्यक्ति जल गए थे, किन्तु बर्तन तब भी वहाँ थे। तब एलीआज़ार ने कुछ व्यक्तियों को बर्तनों को, चपटी धातु के रूप में पीटने को कहा। तब उसने धातु की चपटी चादरों को वेदी पर रखा। ");
INSERT INTO hin2010_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","उसने इसे वैसे ही किया जैसा यहोवा ने मूसा के द्वारा आदेश दिया था। यह संकेत था कि जिससे इस्राएल के लोग याद रख सकें कि केवल हारून के परिवार के व्यक्ति को यहोवा के सामने सुगन्धि भेंट करने का अधिकार है। यदि कोई अन्य व्यक्ति यहोवा के सामने सुगन्धि जलाता है तो वह व्यक्ति कोरह और उसके अनुयायियों की तरह हो जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","अगले दिन इस्राएल के लोगों ने मूसा और हारून के विरुद्ध शिकायत की। उन्होंने कहा, “तुमने यहोवा के लोगों को मारा है।” ");
INSERT INTO hin2010_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","मूसा और हारून मिलापवाले तम्बू के द्वार पर खड़े थे। लोग उस स्थान पर मूसा और हारून की शिकायत करने के लिए इकट्ठा हुए । किन्तु जब उन्होंने मिलापवाले तम्बू को देखा तो बादल ने उसे ढक लिया और वहाँ यहोवा का तेज प्रकट हुआ। ");
INSERT INTO hin2010_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","तब मूसा और हारून मिलापवाले तम्बू के सामने गए। ");
INSERT INTO hin2010_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","तब यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“उन लोगों से दूर हट जाओ जिससे मैं उन्हें अब नष्ट कर दूँ।” मूसा और हारुन धरती पर गिर पड़े। ");
INSERT INTO hin2010_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","तब मूसा ने हारून से कहा, “वेदी की आग और अपने काँसे के बर्तन को लो। तब इसमें सुगन्धि डालो। लोगों के समूह के पास शीघ्र जाओ औ उनके पाप के लिए भुगतान करो। यहोवा उन पर क्रोधित है। परेशानी आरम्भ हो चुकी है।” ");
INSERT INTO hin2010_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","इसलिए, हारून ने मूसा के कथनानुसार काम किया। सुगन्धि और आग को लेने के बाद वह लोगों के बीच दौड़कर पहुँचा। किन्तु लोगों में बीमारी पहले ही आरम्भ हो चुकी थी। हारून ने लोगों के भुगतान के लिए सुगन्धि की भेंट दी। ");
INSERT INTO hin2010_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","हारून मरे हुए और जीवित लोगों में खड़ा हुआ और तब बीमारी रूक गई। ");
INSERT INTO hin2010_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","किन्तु इसके पहले कि हारून उनके पापों के लिए भुगतान करे, चौदह हजार सात सौ लोग उस बीमारी से मर गए। तब यहोवा ने इसे रोका। वहाँ ऐसे लोग भी थे जो कोरह के कारण मरे। ");
INSERT INTO hin2010_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","तब हारून मिलापवाले तम्बू के द्वार पर मूसा के पास लौटा। लोगों की भयंकर बीमारी रोक दी गई। ");
INSERT INTO hin2010_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“इस्राएल के लोगों से कहो। अपने लोगों से बारह लकड़ी की छड़ियाँ लें। बारह परिवार समूहों में हर एक के नेता से एक छड़ी लो। हर एक व्यक्ति की छड़ी पर उसका नाम लिख दो। ");
INSERT INTO hin2010_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","लेवी की छड़ी पर हारून का नाम लिखो। बारह परिवार समूहों के हर एक मुखिया की छड़ी होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","इन छड़ियों को साक्षीपत्र के सन्दूक के सामने मिलापवाले तम्बू में रखो। यही वह स्थान है जहाँ मैं तुमसे मिलता हूँ। ");
INSERT INTO hin2010_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","मैं एक व्यक्ति को चुनूँगा। तुम जान जाओगे कि किस व्यक्ति को मैंने चुना है। क्योंकि उस छड़ी में नयी पत्तियाँ उगनी आरम्भ होंगी। इस प्रकार, मैं लोगों को अपने और तुम्हारे विरुद्ध सदा शिकायत करने से रोक दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","इसलिए मूसा ने इस्राएली लोगों से बातें की। प्रत्येक नेता ने उसे एक छड़ी दी। सारी छड़ियों की संख्या बारह थी। हर एक परिवार समूह के नेता की एक छड़ी उसमें थी। हारून की छड़ी उनमें थी। ");
INSERT INTO hin2010_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","मूसा ने साक्षी के मिलापवाले तम्बू में यहोवा के सामने छड़ियों को रखा। ");
INSERT INTO hin2010_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","अगले दिन मूसा ने तम्बू में प्रवेश किया। उसने देखा कि हारून की वह छड़ी, जो लेवीवंश की थी, एक मात्र ऐसी थी जिससे नयी पत्तियाँ उगनी आरम्भ हुई थीं। उस छड़ी में कलियाँ, फूल और बादाम भी लग गए थे। ");
INSERT INTO hin2010_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","इसलिए मूसा यहोवा के स्थान से सभी छड़ियों को लाया। मूसा ने इस्राएल के लोगों को छड़ियाँ दिखाई। उन सभी ने छड़ियों को देखा और हर एक पुरुष ने अपनी छड़ी वापस ली। ");
INSERT INTO hin2010_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","तब यहोवा ने मूसा से कहा, “हारून की छड़ी को तम्बू में रख दो। यह उन लोगों के लिए चेतावनी होगी जो सदा मेरे विरुद्ध जाते हैं। यह उनकी मेरे विरुद्ध शिकायतों को रोकेगा। इस प्रकार वे नहीं मरेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","मूसा ने उन आदेशों का पालन किया जो यहोवा ने दिए थे। ");
INSERT INTO hin2010_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","इस्राएल के लोगों ने मूसा से कहा, “हम जानते हैं कि हम मरेंगे! हमें नष्ट होना ही है! हम सभी को नष्ट होना ही हैं! ");
INSERT INTO hin2010_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","कोई व्यक्ति यहोवा के पवित्र तम्बू के निकट आने पर भी मरेगा। क्या हम सभी मर जाएंगे” ");
INSERT INTO hin2010_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","यहोवा ने हारून से कहा, “तुम, तुम्हारे पुत्र और तुम्हारे पिता का परिवार अब किसी भी बुराई के लिए उत्तरदायी है जो पवित्र स्थान के विरुद्ध की जाएंगी। तुम और तुम्हारे पुत्र उन बुराइयों के लिए उत्तरदायी होंगे जो याजकों के विरुद्ध होंगी। ");
INSERT INTO hin2010_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","अन्य लेविवंशी लोगों को अपना साथ देने के लिए अपने परिवार समूह से लाओ। वे तुम्हारी और तुम्हारे पुत्रों की सहायता साक्षी के पवित्र तम्बू के कार्यों को करने में करेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","लेवी परिवार के वे लोग तुम्हारे अधीन हैं। वे उन सभी कार्यों को करेंगे जिन्हें तम्बू में किया जाना है। किन्तु उन्हें वेदी या पवित्र स्थान की चीज़ों के पास नहीं जाना चाहिए। यदि वे ऐसा करेंगे ते वे मर जायेंगे और तुम भी मर जाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","वे तुम्हारे साथ होंगे और तुम्हारे साथ काम करेंगे। वे मिलापवाले तम्बू की देखभाल करने के उत्तरदायी होंगें। सभी कार्य, जिन्हें तम्बू में किया जाना चाहिए, वे करेंगे। अन्य कोई भी उस स्थान के निकट नहीं आएगा जहाँ तुम हो। ");
INSERT INTO hin2010_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“पवित्र स्थान और वेदी की देखाभाल करने के उत्तरदायी तुम हो। मैं इस्राएल के लोगों पर फिर क्रोधित होना नहीं चाहता। ");
INSERT INTO hin2010_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","मैंने तुम्हारे लोगों अर्थात् लेवीवंश के लोगों को स्वयं इस्राएल के सभी लोगों में से चुना है। वे तुमको भेंट की तरह हैं। उनका एकमात्र उपयोग परमेश्वर की सेवा और मिलापवाले तम्बू के काम को करने में है। ");
INSERT INTO hin2010_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","किन्तु केवल तुम और तुम्हारे पुत्र याजक के रूप में सेवा कर सकते हो। एक मात्र तुम्हीं वेदी के पास जा सकते हो। केवल तुम्हीं पर्दे के भीतर अति पवित्र स्थान में जा सकते हो। मैं याजक के रूप में तुम्हारी सेवा को तुम्हें एक भेंट के रूप में दे रहा हूँ। कोई भी अन्य, जो पवित्र स्थान के पास आएगा, मार डाला जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","तब यहोवा ने हारून से कहा, “मैंने अपने लिए चढ़ाई गई भेटों का उत्तरदायित्व तुमको दिया है। इस्राएल के लोग जो सारी भेंट मुझको देंगे, वह मैं तुमको देता हूँ। तुम और तुम्हारे पुत्र इन पवित्र भेटों को आपस में बाँट सकते हैं। यह सदा तुम्हारी होंगी। ");
INSERT INTO hin2010_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","उन सभी पवित्र भेंटों में तुम्हारा अपना भाग होगा जो जलाई नहीं जाएंगी। लोग मेरे पास भेंटे सर्वाधिक पवित्र भेंट के रूप में लाते हैं। ये अन्नबलि, या पापबलि या दोषबलि है। किन्तु ये सभी चीज़ें तुम्हारी और तुम्हारे पुत्रों की होंगी। ");
INSERT INTO hin2010_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","इन सबको सर्वाधिक पवित्र चीज़ों के रूप में खाओ। तुम्हारे परिवार का हर एक पुरुष इसे खाएगा। तुम्हें इसको पवित्र मानना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“और वे सभी जो इस्राएल के लोगों द्वारा उत्तोलन भेंट के रूप में दी जाएंगी, तुम्हारी ही होंगी। मैं इसे तुमको, तुम्हारे पुत्रों और तुम्हारी पुत्रियों को देता हूँ। यह तुम्हारा भाग है। तुम्हारे परिवार का हर एक व्यक्ति जो पवित्र होगा, इसे खा सकेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“और मैं सारा अच्छा जैतून का तेल, सारी सर्वोतम नयी दाखमधु और अन्न तुम्हें देता हूँ। ये वे चीज़ें हैं जिन्हें इस्राएल के लोग मुझे अर्थात् अपने यहोवा को देते हैं। ये वे पहली चीज़ें हैं जिन्हें वे अपनी फसल पकने पर इकट्ठी करते हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","जब लोग अपनी फसलें इकट्ठी करते हैं तब लोग पहली चीज यहोवा के पास लाते हैं। अतः ये चीज़ें मैं तुमको दूँगा और हर एक व्यक्ति जो तुम्हारे परिवार में पवित्र है, इसे खा सकेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“और इस्राएल में हर एरक चीज जो यहोवा को दी जाती है, तुम्हारी है। ");
INSERT INTO hin2010_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“किसी भी परिवार में पहलौठा बालक या जानवर यहोवा गी भेंट होगा और वह तुम्हारा होगा। किन्तु तुम्हें प्रत्येक पहलौठे बच्चे और हर सक पहलौठे अशुध्द पशु को फिर को खरीदने के लिए स्वीकार करना चाहिए। तब पहलौठा बच्चा फिर उस परिवार का हो जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","जब वे एक महीने के हो जाए तब तुम्हें उनके लिए भुगतान ले लेना चाहिए। उसका मूल्य दो औंस चाँदी होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“किन्तु तुम्हें पहलौठे गाय, भेड़ या बकरे के लिए भुगतान नहीं लेना चाहिए। वे पशु पवित्र हैं वे शुद्ध हैं। उनका खून वेदी पर छिड़को और उनकी चर्बी जलाओ। यह भेंट अग्नि द्वारा समर्पित है। इस भेंट की सुगन्ध मेरे लिए अर्थात् यहोवा के लिए मधुर सुगन्ध होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","किन्तु इन पशुओं का माँस तुम्हारा होगा। और उत्तोलन भेंट की छाती भी तुम्हारी होगी। अन्य भेंटों की दायी जांघ तुम्हारी होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","कोई भी चीज, जिसे लोग पवित्र भेंट के रूप में मुझे चढ़ाते हैं, मैं यहोवा उसे तुमको देता हूँ। यह तुम्हारा हिस्सा हैं। मै इसे तुमको और तुम्हारे पुत्रों और तुम्हारी पुत्रियों को देता हूँ। यह यहोवा के साथ की गयी वाचा है जो सदा बनी रहेगी। मैं यह वचन तुमको और तुम्हारे वंशजों को देता हूँ।” ");
INSERT INTO hin2010_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","यहोवा ने हारून से यह भी कहा, “तुम कोई भूमि नहीं प्राप्त करोगे और ऐसी कोई चीज़ नहीं रखोगे जैसी अन्य लोग रखते हैं। मैं, यहोवा, तुम्हारा रहूँगा। इस्राएल के लोग वह देश प्राप्त करेंगे जिसके लिए मैंने वचन दिया है। किन्तु तुम्हारे लिए अपना उपहार मैं स्वयं होऊँगा। ");
INSERT INTO hin2010_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“इस्राएल के लोग उनके पास जो कुछ होगा उसका दसवाँ भाग देंगे। इस प्रकार मैं लेवीवंश के लोगों को दसवाँ भाग देता हूँ। यह उनके उस कार्य के लिए भुगतान है जो वे मिलापवालेे तम्बू में सेवा करते हुए करते हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","किन्तु इस्राएल के अन्य लोगों को मिलापवाले तम्बू के निकट कभी नहीं जाना चाहिए। यदि वे ऐसा करते हैं तो उन्हें अपने पाप के लिए भुगतान करना पड़ेगा और वे मर जाएंगे! ");
INSERT INTO hin2010_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","जो लेवीवंश मिलापवाले तम्बू में काम कर रहे हैं वे इसके विरुद्ध किये गए पापों के लिए उत्तरदायी हैं। यह नियम भविष्य के दिनों के लिए भी रहेगा। लेवीवंशी लोग उस भूमि को नहीं लेंगे जिसे मैंने इस्राएल के अन्य लोगों को दिया है। ");
INSERT INTO hin2010_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","किन्तु इस्राएल के लोगों के पास जो कुछ होगा उसका दसवाँ हिस्सा मुझको देंगे। इस तरह मैं लेवीवंशी लोगों को दसवाँ हिस्सा दूँगा। यही कारण है कि मैंने लेविवंशीयों के लिए कहा हैः वे लोग उस भूमि को नहीं पाएंगे जिसे मैंने इस्राएल के लोगों को देने का वचन दिया है।” ");
INSERT INTO hin2010_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“लेवीवंशी लोगों से बातें करो और उनसे कहोः इस्राएल के लोग अपनी हर एक चीज़ का दसवाँ भाग यहोवा को देंगे। वह दसवाँ भाग लेवीवंशियों का होगा। किन्तु तुम्हें उसका दसवाँ भाग यहोवा को उनकी भेंट के रूप में देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","फसल कटने के बाद तुम लोग खलिहानों से अन्न और दाखमधुशाला से रस प्राप्त करोगे। तब वह भी यहोवा को तुम्हारी भेंट होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","इस प्रकार, तुम यहोवा को वैसे ही भेंट दोगे जिस प्रकार इस्राएल के अन्य लोग देते हैं। तुम इस्राएल के लोगों का दिया हुआ दसवाँ भाग प्राप्त करोगे और तब तुम उसका दसवाँ भाग याजक हारून को दोगे। ");
INSERT INTO hin2010_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","जब इस्राएल के लोग अपनी हर एक चीज़ का दसवाँ भाग दें तो तुम्हें उनमें से सर्वोत्तम और पवित्रतम भाग चुनना चाहिए। वही दसवाँ भाग है जिसे तुम्हें यहोवा को देना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“मूसा, लेवियों से यह कहोः इस्राएल के लोग तुम लोगों को अपनी फसल या अपनी दाखमधु का दसवाँ भाग देंगे। तब तुम लोग उसका सर्वोत्तम भाग यहोवा को दोगे। ");
INSERT INTO hin2010_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","जो बचेगा उसे तुम और तुम्हारे परिवार के व्यक्ति खा सकते हैं। यह तुम लोगों के उस काम के लिए भुगतान है जो तुम लोग मिलापवाले तम्बू में करते हो। ");
INSERT INTO hin2010_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","और यदि तुम सदा इसका सर्वोत्तम भाग यहोवा को देते रहोगे तो तुम कभी दोषी नहीं होगे। तुम इस्राएल के लोगों की पवित्र भेंट के प्रति पाप नहीं करोगे और तुम मरोगे नहीं।” ");
INSERT INTO hin2010_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","यहोवा ने मूसा और हारून से बात की। उसने कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ये नियम और उपदेश हैं जिन्हें यहोवा इस्राएल के लोगों को देता है। उन्हें दोष से रहित एक लाल गाय लेनी चाहिए और उसे तुम्हारे पास लाना चाहिए। उस गाय को कोई खरोंच भी न लगी हो और उस गाय के कंधे पर कभी जुआ अपनी उगंलियों पर लागाना चाहिए ओर उसे कुछ खून नहीं रखा गया हो। ");
INSERT INTO hin2010_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","इस गाय को याजक एलीआजार को दो। एलीआजार गाय को डेरे से बाहर ले जाएगा और वह वहाँ गाय को मारेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","तब याजक एलीआजार को इसका कुछ खून अपनी उंगलियों पर लागना चाहिए औ उसे कुछ खून पवित्र तम्बू की दिशा में छिड़कना चाहिए। उसे यह सात बार करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","तब पूरी गाय को उसके सामने जलाना चाहिए। चमड़ा, माँस, खून और और आतें सभी जला डालनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","तब याजक को एक देवदारु की लकड़ी, एक जूफा की शाखा और लाल रंग का कपड़ा लेना चाहिए। याजक को इन चीज़ों को उस आग में डालना चाहिए जिसमें गाय जल रही हो। ");
INSERT INTO hin2010_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","तब याजक को, अपने को तथा अपने कपड़ों को पानी से धोना चाहिए। तब उसे डेरे मे लौटाना चाहिए। याजक सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","जो व्यक्ति गाय को जलाए उसे अपने को तथा अपने वस्त्रों को पानी से धोना चाहिए। वह सन्ध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“तब एक पुरुष जो शुद्ध होगा, गाय की राख को इकट्ठा करेगा। वह इस राख को डेरे के बाहर एक शुद्ध स्थान पर रखेगा। यह राख उस समय उपयोग में आएगी जब लोग शुद्ध होने के लिए विशेष संस्कार करेंगे। यह राख व्यक्ति के पाप को दूर करने के लिए उपयोग में आएगी। ");
INSERT INTO hin2010_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","“वह व्यक्ति, जिसने गाय की राख को इकट्ठा किया, अपने कपड़े धोएगा। वह सन्ध्या तक अशुद्ध रहेगा। “यह नियम सदा चलता रहेगा। यह नियम इस्राएल के नागरिकों के लिए है और यह उन विदेशियों के लिए भी है जो तुम्हारे बीच रहते हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","यदि कोई व्यक्ति एक मरे व्यक्ति को छूता है, तो वह सात दिन के लिए अशुद्ध हो जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","उसे अपने को तीसरे दिन तथा फिर सातवें दिन विशेष पानी से धोना चाहिए। यदि वह ऐसा नहीं करता, तो वह अशुद्ध रह जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","यदि कोई व्यक्ति किसी शव को छूता है, तो वह व्यक्ति अशुद्ध है। यदि वह व्यक्ति अशुद्ध रहता है और तब पवित्र तम्बू में जाता है तो पवित्र तम्बू अशुद्ध हो जाती है। इसलिए उस व्यक्ति को इस्राएल के लोगों से अलग कर दिया जाना चाहिए। यदि अशुद्ध व्यक्ति पर विशेष जल नहीं डाला जाता तो वह व्यक्ति अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“यह नियम उन लोगों से सम्बन्धित है जो अपने खेमों में मरते हैं। यदि कोई व्यक्ति खेमें में मरता है तो उस खेमे का हर एक व्यक्ति अशुद्ध हो जाएगा। वे सात दिन तक अशुद्ध रहेंगे ");
INSERT INTO hin2010_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","और हर एक ढक्कन रहित बर्तन और घड़ा अशुद्ध हो जाता है। ");
INSERT INTO hin2010_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","यदि कोई शव को छूता है, तो वह व्यक्ति सात दिन तक अशुद्ध रहेगा। यह तब भी सत्य होगा जब व्यक्ति बाहर देश में मरा हो या युद्ध में मारा गया हो। यदि कोई व्यक्ति मरे व्यक्ति की हड्डी या किसी कब्र को छूता है तो वह व्यक्ति अशुद्ध हो जाता है। ");
INSERT INTO hin2010_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“इसलिए तुम्हें दुग्ध गाय की राख का उपयोग उस व्यक्ति को पुनः शुद्ध करने के लिए करना चाहिए। स्वच्छ पानी घड़े मेंे रखी हुई राख पर डालो। ");
INSERT INTO hin2010_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","शुद्ध व्यक्ति को एक जूफा की शाखा लेनी चाहिए और इसे पानी में डुबाना चाहिए। तब उसे तम्बू, बर्तनों तथा डेरे में जो व्यक्ति हैं उन पर यह जल छिड़कना चाहिए। तुम्हें यह उन सभी व्यक्तियों के साथ करना चाहिए जो शव को छुऐंगे। तुम्हें यह उस के साथ भी करना चाहिए जो युद्ध में मरे व्यक्ति के शव को छूता है या उस किसी के साथ भी जो किसी मरे व्यक्ति की हड्डियों या क्रब को छूता है। ");
INSERT INTO hin2010_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","“तब कोई शुद्ध व्यक्ति इस जल को अशुद्ध व्यक्ति पर तीसरे दिन और फिर सातवें दिन छिड़के। सातवें दिन वह व्यक्ति शुद्ध हो जाता है। उसे अपने कपड़ों को पानी में धोना चाहिए। वह संध्या के समय पवित्र हो जाता है। ");
INSERT INTO hin2010_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“यदि कोई व्यक्ति अशुद्ध हो जाता है और शुद्ध नहीं होता तो उसे इस्राएल के लोगों से अलग कर देना चाहिए। उस व्यक्ति पर विशेष पानी नहीं छिड़का गया। वह शुद्ध नहीं हुआ। तो वह पवित्र तम्बू को अशुद्ध कर सकता है। ");
INSERT INTO hin2010_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","यह नियम तुम्हारे लिए सदा के लिए होगा। जो व्यक्ति इस विशेष जल को छिड़कता है, उसे भी अपने कपड़े अवश्य धो लेने चाहिए। कोई व्यक्ति जो इस विशेष जल को छुएगा, वह संध्या तक अशुद्ध रहेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","यदि कोई अशुद्ध व्यक्ति किसी अन्य को छूए, तो वह व्यक्ति भी अशुद्ध हो जाएगा। वह व्यक्ति संध्या तक अशुद्ध रहेगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","इस्राएल के लोग सीन मरुभूमि में पहले महीने में पहुँचे। लोग कादेश में ठहरे। मरियम की मृत्यु हो गई और वह वहाँ दफनाई गई। ");
INSERT INTO hin2010_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","उस स्थान पर लोगों के लिए पर्याप्त पानी नहीं था। इसलिए लोग मूसा और हारून के विरुद्ध शिकायत करने के लिए इकट्ठे हुए। ");
INSERT INTO hin2010_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","लोगों ने मूसा से बहस की। उन्होंने कहा, “क्या ही अच्छा होता हम अपने भाइयों की तरह यहोवा के सामने मर गए होते। ");
INSERT INTO hin2010_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","तुम यहोवा के लोगों को इस मरुभूमि में क्यों लाए क्या तुम चाहते हो कि हम और हमारे जानवर यहाँ मर जाए तुम हम लोगों को मिस्र से कयों लाए ");
INSERT INTO hin2010_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","तुम हम लोगों को इस बुरे स्थान पर क्यों लाए यहाँ कोई अन्न नहीं है, कोई अंजीर, अंगूर या अनार नहीं है और यहाँ पीने के लिए पानी नहीं है।” ");
INSERT INTO hin2010_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","इसलिए मूसा और हारून ने लोगों को छोड़ा और वे मिलापवाले तम्बू के द्वार पर पहुँचे। उन्होंने दण्डवत्(प्रणाम) किया और उन पर यहोवा का तेज प्रकाशित हुआ। ");
INSERT INTO hin2010_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","यहोवा ने मूसा से बात की। उसने कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“अपने भाई हारून और लोगों की भीड़ को साथ लो और उस चट्टान तक जाओ। अपनी छड़ी को भी मी लो। लोगो के सामने चट्टान से बातें करो। तब चट्टान से पानी बहेगा और तुम वह पानी अपने लोगों औ जानवरों को दे सकते हो।” ");
INSERT INTO hin2010_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","छड़ी यहोवा के सामने पवित्र तुम्बू में थी। मूसा ने यहोवा के कहने के अनुसार छड़ी ली। ");
INSERT INTO hin2010_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","तब उसने तथा हारून ने लोगों को चट्टान के सामने इकट्ठा होने को कहा। तब मूसा ने कहा, “तुम लोग सदा शिकायत करते हो। अब मेरी बात सुनो। हम इस चट्टान से पानी बहायेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","मूसा ने अपनी भुजा उठाई और दो बार चट्टान पर चोट की। चट्टान से पानी बहने लगा और लोगों तथा जानवरों ने पानी पिया। ");
INSERT INTO hin2010_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","किन्तु यहोवा ने मूसा और हारून से कहा, “इस्राएल के सभी लोग चारों ओर इकट्ठे थे। किन्तु तुमने मुझको सम्मान नहीं दिया। तुमने लोगों को नहीं दिखाया कि पानी निकालने की शक्ति मुझसे तुममें आई। तुमने लोगों को यह नहीं बताया कि तुमने मुझ पर विश्वास किया। मैं उन लोगों को वह देश दूँगा मैने जिसे देने का वचन दिया है। लेकिन तुम उस देश में उनको पहुँचाने वाले नहीं रहोगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","इस स्थान को मरीबा का पानी कहा जाता था। यही वह स्थान था जहाँ इस्राएल के लोगों ने यहोवा के साथ बहस की और यह वह स्थान था जहाँ यहोवा ने यह दिखाया कि वह पवित्र था। ");
INSERT INTO hin2010_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","जब मूसा कादेश में था, उसने कुछ व्यक्तियों को एदोम के राजा के पास एक संदेश के साथ भेजा। संदेश यह थाः “तुम्हारे भाई इस्राएल के लोग तुमसे यह कहते हैं: तुम जानते हो कि हम लोगों ने कितनी कठिनाइयाँ सही हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","अनेक वर्ष पहले हमारे पूर्वज मिस्र चले गये थे और हम लोग वहाँ अनेक वर्ष रहे। मिस्र के लोग हम लोगों के प्रति क्रूर थे। ");
INSERT INTO hin2010_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","किन्तु हम लोगों ने यहोवा से सहायता के लिए प्राथाना की।” यहोवा ने हम लोगों की प्रार्थना सुनी और उन्होंने हम लोगों की सहायता के लिए एक दूत भेजा। यहोवा हम लोगों को मिस्र से बाहर लाया है। “अब हम लोग यहाँ कादेश में हैं जहाँ से तुम्हारा प्रदेश आरम्भ होता है। ");
INSERT INTO hin2010_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","कृपया अपने देश से हम लोगों को यात्रा करने दें। हम लोग किसी खेत या अंगूर के बाग से यात्रा नहीं करेंगे। हम लोग तुम्हारे किसी कुएँ से पानी नहीं पीएंगे। हम लोग केवल राजपथ से यात्रा करेंगे। हम राजपथ को छोड़कर दायें या बायें नहीं बढ़ेंगे। हम लोग तब तक राजपथ पर ही ठहरेंगे जब तक तुम्हारे देश को पार नहीं कर जाते।” ");
INSERT INTO hin2010_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","किन्तु एदोम के राजा ने उत्तर दिया, “तुम हमारे देश से होकर यात्रा नहीं कर सकते। यदि तुम हमारे देश से होकर यात्रा करने का प्रयत्न करते हो तो हम लोग आएंगे और तुमसे तलवारों से लड़ेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","इस्राएल के लोगों ने उत्तर दिया, “हम लोग मुख्य सड़क से यात्रा करेंगे। यदि हमारे जानवर तुम्हारा कुछ पानी पीएंगे, तो हम लोग उसके मूल्य का भुगतान करेंगे। हम लोग तुम्हारे देश से केवल चलकर पार जाना चाहते हैं। हम लोग इसे अपने लिए लेना नहीं चाहते।” ");
INSERT INTO hin2010_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","किन्तु एदोम ने फिर उत्तर दिया, “हम अपने देश से होकर तुम्हें जाने नहीं देगे।” तब एदोम के राजा ने एक विशाल और शक्तिशाली सेना इकट्ठी की और इस्राएल के लोगों से लड़ने के लिए निकल पड़ा। ");
INSERT INTO hin2010_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","एदोम के राजा ने इस्राएल के लोगों को अपने देश से यात्रा करने से मना कर दिया और इस्राएल के लोग मुड़े और दूसरे रास्ते से चल पड़े। ");
INSERT INTO hin2010_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","इस्राएल के सभी लोगों ने कादेश से होर पर्वत तक यात्रा की। ");
INSERT INTO hin2010_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","होर पर्वत एदोम की सीमा पर था। यहोवा ने मूसा और हारून से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“हारून को अपने पूर्वजों के साथ जाना होगा। यह उस प्रदेश में नहीं जाएगा जिसे देने के लिए मैंने इस्राएल के लोगों को वचन दिया है। मूसा, मैं तुमसे यह कहता हूँ क्योंकि तुमने और हारून ने मरीबा के पानी के विषय में मेरे दिये आदेश का पुरी तरह पालन नहीं कया। ");
INSERT INTO hin2010_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","“हारून और उसके पुत्र एलीआज़ार को होर पर्वत पर लाओ। ");
INSERT INTO hin2010_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","हारून के विशेष वस्त्रों को उससे लो ओर उन वस्त्रो को उसके पुत्र ऐलीआज़ार को पहनाओ। हारून वहाँ पर्वत पर मरेगा और वह अपने पूर्वजों के साथ हो जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","मूसा ने यहोवा के आदेश का पालन किया। मूसा, हारून और एलीआज़ार होर पर्वत पर गए। इस्राएल के सभी लोगों ने उन्हें जाते देखा। ");
INSERT INTO hin2010_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","मूसा ने हारून के वस्त्र उतार लिए और उन वस्रों को हारून के पुत्र एलीआजार को पहनाया। तब हारून पर्वत की चोटी पर मर गया। मूसा और एलीआज़ार पर्वत से उतर आए। ");
INSERT INTO hin2010_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","तब इस्राएल के सभी लोगों ने जाना कि हारून मर गया। इसलिए इस्राएल के हर व्यक्ति ने तीस दिन तक शोक मनाया। ");
INSERT INTO hin2010_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","अराद का कनानी राजा नेगेव मरुभूमि में रहता था। उस ने सुना कि इस्राएल के लोग अथारीम को जाने वाली सड़क से आ रहे हैं। इसलिए राजा बाहर निकला और उसने इस्राएल के लोगों पर आक्रमण कर दिया। उसने उनमें से कुछ को पकड़ लिया और उन्हें बन्दी बनाया। ");
INSERT INTO hin2010_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","तब इस्राएल के लोगों ने यहोवा को यह वचन दियाः “हे यहोवा, इन लोगों को पराजित करने में हमारी मदद करो। उन्हें हमारे अधीन कर दो। यदि तु ऐसा करेगा, तो हम लोग उनके नगरों को पूरी तरह नष्ट कर देंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","यहोवा ने इस्राएल के लोगों की प्रार्थना सुनी ओर यहोवा ने इस्राएल के लोगों से कनानी लोगों को हरवा दिया। इस्राएल के लोगों ने कनानी लोगों तथा उनके नगरों को पूरी तरह नष्ट कर दिया। इसलिए उस स्थान का नाम होर्मा पड़ा। ");
INSERT INTO hin2010_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","इस्राएल के लोगों ने होर पर्वत को छोड़ा और लाल सागर के किनारे—किनारे चले। उन्होंने ऐसा इसलिए किया जिससे वे एदोम कहे जाने वाले स्थान के चारों ओर जा सकें। किन्तु लोगों को धीरज नहीं था। जिस समय वे चल रहे थे उसी समय उन्होनें लम्बी यात्रा के विरुद्ध शिकायत करनी आरम्भ की। ");
INSERT INTO hin2010_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","लोगों ने परमेश्वर और मूसा के विरुद्ध बातें की। लोगों ने कहा, “तुम हमें मिस्र से बाहर क्यों लाए हो हम लोग यहाँ मरुभूमि में मर जाएंगे! यहाँ रोटी नहीं मिलती! यहाँ पानी नहीं है और हम लोग इस खराब भोजन से घृणा करते हैं।” ");
INSERT INTO hin2010_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","इसलिए यहोवा ने लोगों के बीच जहरीले साँप भेजे। साँपों ने उन लोगों को डसा और बहुत से लोग मर गए। ");
INSERT INTO hin2010_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","लोग मूसा के पास आए और उससे कहा, “हम जानते हैं कि जब हमने यहोवा और तुम्हारे विरुद्ध शिकायत की तो हमने पाप किया। यहोवा से प्रार्थना करो। उनसे कहो कि इन साँपों को दूर करे।” इसलिए मूसा ने लोगों के लिए प्रार्थना की। ");
INSERT INTO hin2010_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","यहोवा ने मूसा से कहा, “एक काँसे का साँप बनाओ और उसे एक ऊँचे डंडे पर रखो। यदि किसी व्यक्ति को साँप काटे, तो उस व्यक्ति को डंडे के ऊपर काँसे के साँप को देखना चाहिए। तब वह व्यक्ति मरेगा नहीं।” ");
INSERT INTO hin2010_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","इसलिए मूसा ने यहोवा की आज्ञा मानी और एक काँसे का साँप बनाया तथा उसे एक डंडे के ऊपर रखा। तब जब किसी व्यक्ति को साँप काटता था तो वह डंडे के ऊपर के साँप को देखता था और जीवित रहता था। ");
INSERT INTO hin2010_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","इस्राएल के लोग यात्रा करते रहे। उन्होंने ओबोत नामक स्थान पर डेरा डाला। ");
INSERT INTO hin2010_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","तब लोगों ने ओबोत से ईय्ये अबीराम तक की यात्रा की और वहाँ डेरा डाला। यह मोआब के पूर्व में मरुभूमि में था। ");
INSERT INTO hin2010_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","तब लोगों ने उस स्थान को छोड़ा और जेरेद की यात्रा की। उन्होंने वहाँ डेरा डाला। ");
INSERT INTO hin2010_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","तब लोगों ने अर्नोन घाटी की यात्रा की। उन्होंने उस क्षेत्र के समीप डेरा डाला। यह एमोरियों के प्रदेश के पास मरुभूमि में था। अर्नोन घाटी मोआब और एमोरी लोगों के बीच की सीमा है। ");
INSERT INTO hin2010_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","यही कारण है कि यहोवा के युद्धों की पुस्तक में निम्न विवरण प्राप्त हैः “…और सूपा में वाहेब, अर्नोन की घाटी ");
INSERT INTO hin2010_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","और आर की बस्ती तक पहुँचाने वाली घाटी के किनारे की पहाड़ियाँ।ये स्थान मोआब की सीमा पर हैं।” ");
INSERT INTO hin2010_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","इस्राएल के लोगों ने उस स्थान को छोड़ा और उन्होंने बैर की यात्रा की। इस स्थान पर एक कुँआ था। यहोवा ने मूसा से कहा, “यहाँ सभी लोगों को इकट्ठा करो और मैं उन्हें पानी दूँगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","तब इस्राएल के लोगों ने यह गीत गायाः “कुएँ! पानी से उमड़ बहो! इसका गीत गाओ! ");
INSERT INTO hin2010_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","महापुरुषों ने इस कुएँ को खोदा। महान नेताओं ने इस कुएँ को खोदा। अपनी छड़ों और डण्डों से इसे खोदा। यह मरुभूमि में एक भेंट है।” ");
INSERT INTO hin2010_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","लोग “मत्ताना” नाम के कुएँ पर थे। तब लोगों ने मत्ताना से नहलीएल की यात्रा की। तब उन्होंने नहलीएल से बामोत की यात्रा की। ");
INSERT INTO hin2010_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","लोगों ने बामोत घाटी की यात्रा की। इस स्थान पर पिसगा पर्वत की चोटी मरुभूमि के ऊपर दिखाई पड़ती है ");
INSERT INTO hin2010_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","इस्राएल के लोगों ने कुछ व्यक्तियों को एमोरी लोगों के राजा सीहोन के पास भेजा। इन लोगों ने राजा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“अपने देश से होकर हमें यात्रा करने दो। हम लोग किसी खेत या अंगूर के बाग से होकर नहीं जाएंगे। हम तुम्हारे किसी कुएँ से पानी नहीं पीएंगे। हम लोग केवल राजपथ से यात्रा करेंगे। हम लोग तब तक उस सड़क पर ही ठहरेंगे जब तक हम लोग तुम्हारे देश से होकर यात्रा पूरी नहीं कर लेते।” ");
INSERT INTO hin2010_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","किन्तु राजा सीहोन इस्राएल के लोगों को अपने देश से होकर यात्रा करने की अनुमति नहीं दी। राजा ने अपनी सेना इकट्ठी की और मरुभूमि की ओर चल पड़ा। वह इस्राएल के लोगों के विरुद्ध आक्रमण कर रहा था। यहस नाम के एक स्थान पर राजा की सेना ने इस्राएल के लोगों के साथ युद्ध किया। ");
INSERT INTO hin2010_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","किन्तु इस्राएल के लोगों ने राजा को मार डाला। तब उन्होंने अर्नोन घाटी से लेकर यब्बोक क्षेत्र तक के उसके प्रदेश पर अधिकार कर लिया। इस्राएल के लोगों ने अम्मोनी लोगों की सीमा तक के प्रदेश पर अधिकार किया। उन्होंने और अधिक क्षेत्र पर अधिकार नहीं जमाया क्योंकि वह सीमा अम्मोनी लोगों दूारा दृढ़ता से सुरक्षित थी। ");
INSERT INTO hin2010_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","किन्तु इस्रएल ने अम्मोनी लोगों के सभी नगरों पर कब्जा कर लिया। उन्होंने हेशबोन नगर तक को और उसके चारों ओर के छोटे नगरों को भी हराया। ");
INSERT INTO hin2010_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","हेशबोन वह नगर था जिसमें राजा सीहोन रहता था। इसके पहले सीहोन ने मोआब के राजा को हराया था और सीहोन से अर्नोन घाटी तक के सारे प्रदेश पर अधिकार कर लिया था। ");
INSERT INTO hin2010_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","यही कारण है कि गायक यह गीत गाते हैं: “आओ हेशबोन को, इसे फिर से बसाना है। सीहोन के नगर को फिर से बनने दो। ");
INSERT INTO hin2010_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","हेशबोन में आग लग गई थी। वह आग सीहोन के नगर में लगी थी। आग ने आर (मोआब) को नष्ट किया इसने ऊपरी अर्नोन की पहाड़ियों को जलाया। ");
INSERT INTO hin2010_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ऐ मोआब! यह तुम्हारे लिए बुरा है, कमोश के लोग नष्ट कर दिए गए हैं। उसके पुत्र भाग खड़े हुए। उसकी पुत्रियाँ बन्दी बनीं एमोरी लोगों के राजा सीहोन द्वारा। ");
INSERT INTO hin2010_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","किन्तु हमने उन एमोरियों को हराया, हमने उनके हेशबोन से दीबोन तक नगरों को मिटाया मेदबा के निकट नशिम से नोपह तक।” ");
INSERT INTO hin2010_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","इसलिए इस्राएल के लोगों ने एमोरियों के देश में अपना डेरा लगाया। ");
INSERT INTO hin2010_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","मूसा ने गुप्तचरों को याजेर नगर पर निगरानी के लिए भेजा। मूसा के ऐसा करने के बाद, इस्राएल के लोगों ने उस नगर पर अधिकार कर लिया। उन्होंने उसके चारों ओर के छोटे नगर पर भी अधिकार जमाया। इस्राएल के लोगों ने उस स्थान पर रहने वाले एमोरियों को वह स्थान छोड़ने को विवश किया। ");
INSERT INTO hin2010_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","तब इस्राएल के लोगों ने बाशान की ओर जाने वाली सड़क पर यात्रा की। बाशान के राजा ओग ने अपनी सेना ली और इस्राएल के लोगों का सामना करने निकला। वह एद्रेई नाम के क्षेत्र में उनके विरुद्ध लड़ा। ");
INSERT INTO hin2010_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","किन्तु यहोवा ने मूसा से कहा, “उस राजा से मत डरो। मैं तुम्हें उसकी हराने दूँगा। तुम उसके पूरी सेना और प्रदेश को प्राप्त करोगे। तुम उसके साथ वही करो जो तुमने एमोरी लोगों के राजा सीहोन के साथ किया।” ");
INSERT INTO hin2010_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","अतः इस्राएल के लोगों ने ओग और उसकी सारी सेना को हराया। उन्होने उसे, उसके पुत्रों और उसकी सारी सेना को हराया। तब इस्राएल के लोगों ने उसके पूरे देश पर अधिकार कर लिया। ");
INSERT INTO hin2010_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","तब इस्राएल के लोगों ने मोआब के मैदान की यात्रा की। उन्होंने यरीहो के उस पार यरदन नदी के निकट डेरा डाला। ");
INSERT INTO hin2010_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","3","सिप्पोर के पुत्र बालाक ने एमोरी लोगों के साथ इस्राएल के लोगों ने जो कुछ किया था, उसे देखा था औ मोआब बहुत अधिक भयभीत था क्योंकि वहाँ इस्राएल के बहुत लोग थे। मोआब इस्राएल के लोगों से बहुत आतंकित था। ");
INSERT INTO hin2010_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","मोआब के नेताओं ने मिद्यान के अग्रजों से कहा, “लोगों का यह विशाल समूह हमारे चारों ओर की सभी चीज़ों को वैसे ही नष्ट कर देगा जैसे कोई गाय मैदान की घास चर जाती है।” इस समय सिप्पोर का पुत्र बालाक मोआब का राजा था। ");
INSERT INTO hin2010_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","उसने कुछ व्यक्तियों को बोर के पुत्र बिलाम को बुलाने के लिए भेजा। बिलाम नदी के निकट पतोर नाम के क्षेत्र में था। बालाक ने कहा, “लोगों का एक नया राष्ट्र मिस्र से आया है। वे इतने अधिक हैं कि पूरे प्रदेश में फैल सकते हैं। उन्होंने ठीक हमारे पास डेरा डाला है। ");
INSERT INTO hin2010_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","आओ और इन लोगों के साथ निपटने में मेरी सहायता करो। वे मेरी शक्ति से बहुत अधिक शक्तिशाली हैं। संभव है कि तब इनको मैं हरा सकूँ। तब मैं उन्हें अपना देश छोड़ने को विवश कर सकता हूँ। मैं जानता हूँ कि तुम बड़ी शक्ति रखते हो। यदि तुम किसी व्यक्ति को आशीर्वाद देते हो तो उसका भला हो जाता है। यदि तुम किसी व्यक्ति के विरुद्ध कहते हो तो उसका बुरा हो जाता है। इसलिए आओ और इन लोगों के विरुद्ध कुछ कहो।” ");
INSERT INTO hin2010_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","मोआब और मिद्यान के अग्रज चले। वे बिलाम से बातचीत करने गए। वे उसकी सेवाओं के लिए धन देने को ले गए। तब उन्होंने, बालाक ने जो कुछ कहा था, उससे कहा। ");
INSERT INTO hin2010_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","बिलाम ने उनसे कहा, “यहाँ रात में रुको। मैं यहोवा से बातें करुँगा और जो उत्तर, वह मुझे देगा, वह तुमसे कहूँगा।” इसलिए उस रात मोआबी लोगों के नेता उसके साथ ठहरे। ");
INSERT INTO hin2010_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","परमेश्वर बिलाम के पास आया और उसने पूछा, “तुम्हारे साथ ये कौन लोग हैं?” ");
INSERT INTO hin2010_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","बिलाम ने परमेश्वर से कहा, “मोआब के राजा सिप्पोर के पुत्र बालाक ने उन्हें मुझको एक संदेश देने को भेजा है। ");
INSERT INTO hin2010_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","सन्देश यह हैः लोगों का एक नया राद्र मिस्र से आया है। वे इतने अधिक हैं कि सारे देश में फैल सकते हैं। इसलिए आओ और इन लोगों के विरुद्ध कुछ कहो। तब सम्भ्व है कि उनसे लड़ने में मैं समर्थ हो सकूँ ओर अपने देश को छोड़ने के लिए उन्हे विवश कर सकूँ।” ");
INSERT INTO hin2010_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","किन्तु परमेश्वर ने बिलाम से कहा, “उनके साथ मत जाओ। तुम्हें उन लोगों के विरुद्ध कुछ नहीं कहना चाहिए। उन्हें यहोवा से वरदान प्राप्त है।” ");
INSERT INTO hin2010_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","दूसरे दिन सवेरे बिलाम उठा और बालाक के नेताओं से कहा, “अपने देश को लौट जाओ। यहोवा मुझे तुम्हारे साथ जाने नहीं देगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","इसलिए मोआबी नेता बालाक के पास लौटे और उससे उन्होंने ये बातें कहीं। उन्होंने कह, “बिलाम ने हम लोगों के साथ आने से इन्कार कर दिया।” ");
INSERT INTO hin2010_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","इसलिए बालाक ने दूसरे नेताओं को बिलाम के पास भेजा। इस बार उसने पहली बार की अपेक्षा बहुत अधिक आदमी भेजे और ये नेता पहली बार के नेताओं की अपेक्षा अधिक महत्वपूर्ण थे। ");
INSERT INTO hin2010_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","वे बिलाम के पास गए और उन्होंने उससे कहा, “सिप्पोर का पुत्र बालाक तुमसे कहता हैः कृपया अपने को यहाँ आने से किसी को रोकने न दें। ");
INSERT INTO hin2010_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","जो मैं तुमसे माँगता हूँ यदि तुम वह करोगे तो मैं तुम्हें बहुत अधिक भुगतान करूँगा। आओ और इन लोगों के विरुद्ध मेरे लिए कुछ कहो।” ");
INSERT INTO hin2010_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","किन्तु बिलाम ने उन लोगों को उत्तर दिया। उसने कहा, “मुझे यहोवा मेरे परमेश्वर की आज्ञा माननी चाहिए। मैं उसके आदेश के विरुद्ध कुछ नहीं कर सकता। मैं बड़ा छोटा कुछ भी तब तक नहीं कर सकता जब तक यहोवा नहीं कहता कि मैं उसे कर सकता हूँ। यदि राजा बालाक अपने सोने चाँदी भरे सुन्दर घर को दे तो भी मैं अपने परमेश्वर यहोवा के आदेश के विरुद्ध कुछ नहीं करूँगा। ");
INSERT INTO hin2010_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","किन्तु तुम भी उन दूसरे लोगों की तरह आज की रात यहाँ ठहर सकते हो और रात में मैं जान जाऊँगा कि यहोवा मुझसे क्या कहलवाना चाहता है।” ");
INSERT INTO hin2010_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","उस रात परमेश्वर बिलाम के पास आया। परमेश्वर ने कहा, “ये लोग अपने साथ ले जाने के लिए को फिर आ गए हैं। इस्राएल तुम उनके साथ जा सकते हो। किन्तु केवल वही करो जो मैं तुमसे करने को कहूँ।” ");
INSERT INTO hin2010_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","अगली सुबह, बिलाम उठा और अपने गधे पर काठी रखी। तब वह मोआबी नेताओं के साथ गया। ");
INSERT INTO hin2010_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","बिलाम अपने गधे पर सवार था। उसके सेवकों में से दो उसके साथ थे। जब बिलाम यात्रा कर रहा था, परमेश्वर उस पर क्रोधित हो गया। इसलिए यहोवा का दूत बिलाम के सामने सड़क पर खड़ा हो गया। दूत बिलाम को रोकने जा रहा था। ");
INSERT INTO hin2010_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","बिलाम के गधे ने यहोवा के दूत को सड़क पर खड़ा देखा। दूत के हाथ में एक तलवार थी। इसलिए गधा सड़क से मुड़ा और खेत में चला गया। बिलाम दूत को नहीं देख सकता था। इसलिए वह गधे पर बहुत क्रोधित हुआ। उसने गधे को मारा और उसे सड़क पर लौटने को विवश किया। ");
INSERT INTO hin2010_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","बाद में, यहोवा का दूत ऐसी जगह पर खड़ा हुआ जहाँ सड़क सँकरी हो गई थी। यह दो अंगूर के बागों के बीच का स्थान था। वहाँ सड़क के दोनों ओर दीवारें थीं। ");
INSERT INTO hin2010_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","गधे ने यहोवा के दूत को फिर देखा। इसलिए गधा एक दीवार से सटकर निकला। इससे बिलाम का पैर दीवार से छिल गया। इसलिए बिलाम ने अपने गधे को फिर मारा। ");
INSERT INTO hin2010_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","इसके बाद, यहोवा का दूत दूसरे स्थान पर खड़ा हुआ। यह दूसरी जगह थी जहाँ सड़क सँकरी हो गई थी। वहाँ कोई ऐसी जगह नहीं थी जहाँ गधा मुड़ सके। गधा दायें या बायें नहीं मुड़ सकता था। ");
INSERT INTO hin2010_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","गधे ने यहोवा के दूत को देखा इसलिए गधा बिलाम को अपनी पीठ पर लिए हुए जमीन पर बैठ गया। बिलाम गधे पर बहुत क्रोधित था। इसलिए उसने उसे अपने डंडे से पीटा। ");
INSERT INTO hin2010_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","तब यहोवा ने गधे को बोलने वाला बनाया। गधे ने बिलाम से कहा, “तुम मुझ पर क्यों क्रोधित हो मैंने तुम्हारे साथ क्या किया है तुमने मुझे तीन बार मारा है!” ");
INSERT INTO hin2010_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","बिलाम ने गधे को उत्तर दिया, “तुमने दूसरों की नजर में मुझे मूर्ख बनाया है यदि मेरे हाथ में तलवार होती तो मैं अभी तुम्हें मार डालता।” ");
INSERT INTO hin2010_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","किन्तु गधे ने बिलाम से कहा, “मैं तुम्हारा अपना गधा हूँ जिस पर तुम अनेक वर्ष से सवार हुए हो और तुम जानते हो कि मैंने ऐसा इसके पहले कभी नहीं किया है।” “यह सही है।” बिलाम ने कहा। ");
INSERT INTO hin2010_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","तब यहोवा ने बिलाम को सड़क पर खड़े दूत को देखने दिया। बिलाम ने दूत और उसकी तलवार को देखा। तब बिलाम ने झुक कर प्रणाम किया। ");
INSERT INTO hin2010_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","यहोवा के दूत ने बिलाम से पूछा, “तुमने अपने गधे को तीन बार क्यों मारा तुम्हें मुझ पर क्रोध से पागल होना चाहिए। मैं तुमको रोकने के लिए यहाँ आया हूँ। तुम्हें कुछ अधिक सावधान रहना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","गधे ने मुझे देखा और वह तीन बार मुझसे मुड़ा। यदि गधा मुड़ा न होता तो मैंने तुमको मार डाला होता। किन्तु मुझे तुम्हारे गधे को नहीं मारना था।” ");
INSERT INTO hin2010_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","तब बिलाम ने यहोवा के दूत से कहा, “मैंने पाप किया है। मैं यह नहीं जानता था कि तुम सड़क पर खड़े हो। यदि मैं बुरा कर रहा हूँ तो मैं घर लौट जाऊँगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","यहोवा के दूत ने बिलाम से कहा, “नहीं, तुम इन लोगों के साथ जा सकते हो। किन्तु सावधान रहो। वही बातें कहोव जो मैं तुमसे कहने के लिए कहूँगा।” इसलिए बिलाम बालाक द्वारा भेजे गए नेताओं के साथ गया। ");
INSERT INTO hin2010_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","बालाक ने सुना कि बिलाम आ रहा है। इसलिए बालाक उससे मिलने के लिए अर्नोन सीमा पर मोआबी नगर को गया। यह उसके देश की छोर थी। ");
INSERT INTO hin2010_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","जब बालाक ने बिलाम को देखा तो उसने बिलाम से कहा, “मैंने इसके पहले तुमसे आने के लिए कहा था और यह भी बताया था कि यह अत्यन्त महत्वपूर्ण है। तुम हमारे पास क्यों नहीं आए क्या यह सच है कि तुम मुझसे कोई भी पुरस्कार या भुगतान नहीं पाना चाहते” ");
INSERT INTO hin2010_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","किन्तु बिलाम ने उत्तर दिया, “मैं अब तुम्हारे पास आया हूँ। लेकिन मैं, जो तुमने करने को कहा था उनमें से, शायद कुछ भी न कर सकूँ। मैं केवल वही बातें तुमसे कह सकता हूँ जो परमश्वर मुझसे कहने को कहता है।” ");
INSERT INTO hin2010_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","तब बिलाम बालाक के साथ किर्यथूसोत गया। ");
INSERT INTO hin2010_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","बालाक ने कुछ मवेशी तथा कुछ भेड़ें उसकी भेंट के रूप मे मारीं।उसके कुछ माँस बिलाम तथा कुछ उसके साथ के नेताओं को दिया। ");
INSERT INTO hin2010_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","अगली सुबह बालाक को बमोथ बाल नगर को ले गया। उस नगर से वे इस्राएली लोगों के कुछ डेरों को देख सकते थे। ");
INSERT INTO hin2010_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","बिलाम ने कहा, “यहाँ सात वेदियाँ बनाओ और मेरे लिए सात बैल और सात मेढ़े तैयार करो।” ");
INSERT INTO hin2010_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","बालाक ने वह सब किया जो बिलाम ने कहा। तब बिलाम ने हर एक वेदी पर एक बैल और एक मेढ़े को मारा। ");
INSERT INTO hin2010_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","तब बिलाम ने बालाक से कहा, “इस वेदी के समीप ठहरो। मैं दूसरी जगह जाऊँगा। तब कदाचित यहोवा मेरे पास आएगा और बताएगा कि मैं क्या कहूँ।” तब बिलाम एक अधिक ऊँचे स्थान पर गया। ");
INSERT INTO hin2010_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","परमेश्वर उस स्थान पर बिलाम के पास आया और बिलाम ने कहा, “मैंने सात वेदियाँ तैयार की हैं और मैंने हर एक वेदी पर एक बैल और एक मेढ़े को मारा है।” ");
INSERT INTO hin2010_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","तब यहोवा ने बिलाम को वह बताया जो उसे कहना चाहिए। तब यहोवा ने कहा, “बालाक के पास जाओ और इन बातों को कहो जो मैंने कहने के लिए बताई हैं।” ");
INSERT INTO hin2010_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","इसलिए बिलाम बालाक के पास लौटा। बालाक तब तक वेदी के पास खड़ा था और मोआब के सभी नेता उसके साथ खड़े थे। ");
INSERT INTO hin2010_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","तब बिलाम ने ये बातें कहीः “मोआब के राजा बालाक ने मुझे आराम से बुलाया पूर्व के पहाड़ों से। बालाक ने मुझसे कहा ‘आओ और मेरे लिए याकूब के विरुद्ध कहो, आओ और इस्राएल के लोगों के विरुद्ध कहो।’ ");
INSERT INTO hin2010_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","परमेश्वर उन लोगों के विरुद्ध नहीं है, अतः मैं भी उनके विरुद्ध नहीं कह सकता। यहोवा ने उनका बुरा होने के लिए नहीं कहा है। अतः मैं भी वैसा नहीं कर सकता। ");
INSERT INTO hin2010_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","मैं उन लोगों को पर्वत से देखता हूँ। मैं ऐसे लोगों को देखता हूँ जो अकेले रहते हैं। वो लोग किसी अन्य राष्ट्र के अंग नहीं हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","याकूब के लोग बालू के कण से भी अधिक हैं। इस्राएल के लोगों की चौथाई को भी कोई गिन नहीं सकता। मुझे एक अच्छे मनुष्य की तरह मरने दो, मुझे उन लोगों की तरह ही मरने दो।” ");
INSERT INTO hin2010_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","बालाक ने बिलाम से कहा, “तुमने हमारे लिए क्या किया है मैंने तुमको अपने शत्रुओं के विरुद्ध कुछ कहने को बुलाया था। किन्तु तुमने उन्हीं को आशीर्वाद दिया है।” ");
INSERT INTO hin2010_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","किन्तु बिलाम ने उत्तर दिया, “मुझे वही करना चाहिए जो यहोवा मुझे करने को कहता है।” ");
INSERT INTO hin2010_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","तब बालाक ने उससे कहा, “इसलिए मेरे साथ दूसरे स्थान पर आओ। उस स्थान पर तुम लोगों को भी देख सकते हो। किन्तु तुम उनके एक भाग को ही देख सकते हो, सभी को नहीं देख सकते और उस स्थान से तुम मेरे लिए उनके विरुद्ध कुछ कह सकते हो।” ");
INSERT INTO hin2010_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","इसलिए बालाक बिलाम को सोपीम के मैदान में ले गया। यह पिसगा पर्वत की चोटी पर था। बालाक ने उस स्थान पर सात वेदियाँ बनाई। तब बालाक ने हर एक वेदी पर बलि के रूप में एक बैल और एक मेढ़ा मारा। ");
INSERT INTO hin2010_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","इसलिए बिलाम ने बालाक से कहा, “इस वेदी के पास खड़े रहो। मैं उस स्थान पर परमेश्वर से मिलने जाऊँगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","इसलिए यहोवा बिलाम के पास आया और उसने बिलाम को बताया कि वह क्या कहे। तब यहोवा ने बिलाम को बालाक के पास लौटने और उन बातों को कहने को कहा। ");
INSERT INTO hin2010_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","इसलिए बिलाम बालाक के पास गया। बालाक तब तक वेदी के पास खड़ा था। मोआब के नेता उसके साथ थे। बालाक ने उसे आते हुए देखा और उससे पूछा, “यहोवा ने क्या कहा” ");
INSERT INTO hin2010_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","तब बिलाम ने ये बातें कहीः “बालाक! खड़े हो और मेरी बात सुनों। सिप्पोर के पुत्र बालाक! मेरी बात सुनो। ");
INSERT INTO hin2010_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","परमेश्वर मनुष्य नहीं है, वह झूठ नहीं बोलेगा; परमेश्वर मनुष्य पुत्र नहीं, उसके निर्णय बदलेंगे नहीं। यदि यहोवा कहता है कि वह कुछ करेगा तो वह अवश्य उसे करेगा। यदि यहोवा वचन देता है तो अपने वचन को अवश्य पूरा करेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","यहोवा ने मुझे उन्हें आशीर्वाद देने का आदेश दिया। यहोवा ने उन्हें आशीर्वा दिया है, इसलिए मैं उसे बदल नहीं सकता। ");
INSERT INTO hin2010_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","याकूब के लोगों में कोई दोष नहीं था। इस्राएल के लोगों में कोई पाप नहीं था। यहोवा उनका परमेश्वर है और वह उनके साथ है। महाराजा (परमेश्वर) की वाणी उनके साथ है! ");
INSERT INTO hin2010_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","परमेश्वर उन्हें मिस्र से बाहर लाया। इस्राएल के वे लोग जंगली साँड की तरह शक्तिशाली हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","कोई जादुई शक्ति नहीं जो याकूब के लोगों को हरा सके। याकूब के बारे में और इस्राएल के लोगों के विषय में भी लोग यह कहेंगे: ‘परमेश्वर ने जो महान कार्य किये हैं उन पर ध्यान दो!’ ");
INSERT INTO hin2010_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","वे लोग सिंह की तरह शक्तिशाली होंगे। वे सिंह जैसे लड़ेंगे और यह सिंह कभी विश्राम नहीं करेगा, जब तक वह शत्रु को खा नहीं डालता, और वह सिंह कभी विश्राम नहीं करेगा जब तक वह उनका रक्त नहीं पीता जो उसके विरुद्ध हैं।” ");
INSERT INTO hin2010_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","तब बालाक ने बिलाम से कहा, “तुमने उन लोगों के लिए अच्छी चीज़ें होने की मांग नहीं की। किन्तु तुमने उनके लिए बुरी चीज़ें होने की भी माँग नहीं की।” ");
INSERT INTO hin2010_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","बिलाम ने उत्तर दिया, “मैंने पहले ही तुमसे कह दिया कि मैं केवल वही कहूँगा जो यहोवा मुझसे कहने के लिए कहता है।” ");
INSERT INTO hin2010_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","तब बालाक ने बिलाम से कहा, “इसलिए तुम मेरे साथ दूसरे स्थान पर चलो। सम्भव है कि परमेश्वर प्रसन्न हो जाये और तुम्हें उस स्थान से शाप देने दे।” ");
INSERT INTO hin2010_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","इसलिए बालाक बिलाम को पोर पर्वत की चोटी परले गया। यह पर्वत मरुभूमि के छोर पर स्थित है। ");
INSERT INTO hin2010_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","बिलाम ने कहा, “यहाँ सात वेदियाँ बनाओ। तब सात साँड़ तथा सात मेढ़े वेदियों पर बलि के लिए तैयार करो।” ");
INSERT INTO hin2010_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","बालाक ने वही किया जो बिलाम ने कहा। बालाक ने बलि के रूप में हर एक वेदी पर एक साँड़ तथा एक मेढ़ा मारा। ");
INSERT INTO hin2010_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","बिलाम को मालूम हुआ कि यहोवा इस्राएल को आशीर्वाद देना चाहता है। इस्रालिए बिलाम ने किसी प्रकार के जादू मन्तर का उपयोग करके उसे बदलना नहीं चाहा। किन्तु बिलाम मुड़ा और उसने मरुभूमि की ओर देखा। ");
INSERT INTO hin2010_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","बिलाम ने मरुभूमि के पार तक देखा और इस्राएल के सभी लोगों को देख लिया। वे अपने अलग—अलग परिवार समूहों के क्षेत्र में डेरा डाले हुए थे। तब परमेश्वर ने बिलाम को प्रेरित किया। ");
INSERT INTO hin2010_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","और बिलाम ने ये शब्द कहेः “बोर का पुत्र बिलाम जो सब कुछ स्पष्ट देख सकता है ये बातें कहता है। ");
INSERT INTO hin2010_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ये शब्द कहे गए, क्योंकि मैं परमेश्वर की बात सुनता हूँ। मैं उन चीज़ों को देख सकता हूँ जिसे सर्वशक्तिमान परमेश्वर चाहता है की मैं देखूँ। मैं जो कुछ स्पष्ट देख सकता हूं वही नम्रता के साथ कहता हूँ। ");
INSERT INTO hin2010_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“याकूब के लोगों तुम्हारे खेमे बहुत सुन्दर हैं! इस्राएल के लोगों जिनके घर सुन्दर हैं! ");
INSERT INTO hin2010_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","तुम्हारे डेरे घाटियों की तरह प्रदेश के आर—पार फैले हैं. ये नदी के किनारे उगे बाग की तरह हैं। ये यहोवा द्वारा बोयी गई फसल की तरह हैं। ये नदियों के किनारे उगे देवदार के सुन्दर पेड़ों की तरह हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","तुम्हें पीने के लिए सदा पर्याप्त पानी मिलेगा। तुम्हें फसलें उगाने के लिए पर्याप्त पानी मिलेगा। तुम लोगों का राजा अगाग से महान होगा। तुम्हारा राज्य बहुत महान हो जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“परमेश्वर उन लोगों को मिस्र से बाहर लाया। वे इतने शक्तिशाली हैं जितना कोई जंगली साँड। वे अपने सभी शत्रुओं को हरायेंगे। वे अपने शत्रुओं की हड्डियाँ चूर करेंगे। और उनके बाण उनके शत्रु को मार डालेंगे वे उस सिंह की तरह हैं जो अपने शिकार पर टूट पड़ना चाहता हो। ");
INSERT INTO hin2010_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","वे उस सिंह की तरह है जो सो रहा हो। कोई व्यक्ति इतना साहसी नहीं जो उसे जगा दे! कोई व्यक्ति जो तुम्हें आशीर्वाद देगा, आशीष पाएगा, और कोई व्यक्ति जो तुम्हारे विरुद्ध बोलेगा विपत्ति में पड़ेगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","तब बिलाम पर बालाक बहुत क्रोधित हुआ। बालाक ने बिलाम से कहा, “मैंने तुम्हे आने और अपने शत्रुओं के विरुद्ध कुछ कहने के लिए बुलाया। किन्तु तुमने उनको आशीर्वाद दिया है। तुमने उन्हें तीन बार आशीर्वाद दिया है। ");
INSERT INTO hin2010_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","अब विदा हो और घर जाओ। मैंने कहा था कि मैं तुम्हें बहुत अधिक सम्पन्न बनाऊँगा। किन्तु यहोवा ने तुम्हें पुरस्कार से वंचित कराया है।” ");
INSERT INTO hin2010_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","बिलाम ने बालाक से कहा, “तुमने आदमियों को मेरे पास भेजा। उन व्यक्तियों ने मुझसे आने के लिए कहा। किन्तु मैंने उनसे कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘बालाक अपना सोने—चाँदी से भरा घर मुझको दे सकता है। परन्तु मैं तब भी केवल वही बातें कह सकता हूँ जिसे कहने के लिए यहोवा आदेश देता है। मैं अच्छा या बुरा स्वयं कुछ नहीं कर सकता। मुझे वही करना चाहिए जो यहोवा का आदेश हो।’ क्या तुम्हें याद नहीं कि मैंने ये बातें तुम्हारे लोगों से कहीं।’ ");
INSERT INTO hin2010_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","अब मैं अपने लोगों के बीच जा रहा हूँ किन्तु तुमको एक चेतावनी दूँगा। मैं तुमसे कहूँगा कि भविष्य में इस्राएल के ये लोग तुम्हारे और तुम्हारे लोगों के साथ क्या करेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","तब बिलाम ने ये बातें कहीः “बोर के पुत्र बिलाम के ये शब्द हैं: ये उस व्यक्ति के शब्द हैं जो चीज़ों को साफ—साफ देख सकता है। ");
INSERT INTO hin2010_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ये उस व्यक्ति के शब्द हैं जो परमेश्वर की बातें सुनता है। सर्वोच्च परमेंश्वर ने मुझे ज्ञान दिया है। मैंने वह देखा है जिसे सर्वशक्तिमान परमेश्वर ने मुझे दिखाना चाहा है। मैं जो कुछ स्पष्ट देखता हूँ वही नम्रता के साथ कहता हूँ। ");
INSERT INTO hin2010_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“मैं देखता हूँ कि यहोवा आ रहा है, किन्तु अभी नहीं। मैं उसका आगमन देखता हूँ, किन्तु यह शीघ्र नहीं है। याकूब के परिवार से एक तारा आएगा। इस्राएल के लोगों में से एक नया शासक आएगा। वह शासक मोआबी लोगों के सिर कुचल देगा। वह शासक सेईर के सभी पुत्रों के सिर कुचल देगा। ");
INSERT INTO hin2010_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","एदोम देश पराजित होगा नये राजा का शत्रु सेईर पराजित होगा। इस्राएल के लोग शक्तिशाली हो जाएंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","“याकूब के परिवार से एक नया शासक आएगा। नगर में जीवित बचे लोगों को वह शासक नष्ट करेगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","तब बिलाम ने अपने अमालेकी लोगों को देखा और ये बातें कहीः “सभी राष्ट्रों में अमालेक सबसे अधिक बलवान था। किन्तु अमालेक भी नष्ट किया जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","तब बिलाम ने केनियों को देखा और उनसे ये बातें कहीः “तुम्हें विश्वास है कि तुम्हारा देश उसी प्रकार सुरक्षित है। जैसे किसी ऊँचे खड़े पर्वत पर बना घोंसला। ");
INSERT INTO hin2010_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","किन्तु केनियों, तुम नष्ट किये जाओगे। अश्शूर तुम्हें बन्दी बनाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","तब बिलाम ने ये शब्द कहे, “कोई व्यक्ति नहीं रह सकता जब परमेश्वर यह करता है। ");
INSERT INTO hin2010_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","कित्तियों के तट स जहाज आएंगे। वे जहाज अश्शूर और एबेर को हराएंगे। किन्तु तब वे जहाज भी नष्ट कर दिए जाएंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","तब बिलाम उठा और अपने घर को लौट गया और बालाक भी अपनी राह चला गया। ");
INSERT INTO hin2010_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","इस्राएल के लोग अभी तक शित्तीम के क्षेत्र मे डेरा डाले हुए थे। उस समय लोग मोआबी स्त्रियों के साथ यौन सम्बन्धी पाप करने लगे। ");
INSERT INTO hin2010_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","मोआबी स्त्रियों ने पुरुषों को आने और अपने मिथ्या देवताओं को भेंट चढ़ाने में सहायता करने के लिए आमंन्त्रित किया। इस्राएली लोगों ने वहाँ भोजन किया और मिथ्या देवताओं की पूजा की। ");
INSERT INTO hin2010_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","अतः इस्राएल के लोगों ने इसी प्रकार मिथ्या देवता पोर के बाल की पूजा आरम्भ की। यहोवा इन लोगों पर बहुत क्रोधित हुआ। ");
INSERT INTO hin2010_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","यहोवा ने मूसा से कहा, “इन लोगों के नेताओं को लाओ। तब उन्हें सभी लोगों की आँखों के सामने मार डालो। उनके शरीर को यहोवा के सामने डालो । तब यहोवा इस्राएल के लोगों लोगों पर क्रोधित नहीं होगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","इसलिए मूसा ने इस्राएल के न्यायाधीशों से कहा “तुम लोगों में से हर एक को अपने परिवार समूह में उन लोगों को ढूँढ निकालना है जिन्होंने लोगों को पोर के मिथ्या देवता बाल की पूजा के लिए प्रेरित किया है। तब तुम्हें उन लोगों को अवश्य मार डालना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","उस समय मूसा और सभी इस्राएल के अग्रज (नेता) मिलापवाले तम्बू के द्वार पर एक साथ इकट्ठे थे। एक इस्राएली व्यक्ति एक मिद्यानी स्त्री को अपने भाईयों के पास अपने घर लाया। उसने यह वहाँ किया जहाँ उसे मूसा ओर सारे नेता देख सकते थे। मूसा ओर नेता बहुत दुःखी हुए। ");
INSERT INTO hin2010_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","याजक हारून के पोते तथा एलीआज़ार के पुत्र पीनहास ने इसे देखा। इसलिए उसने बैठक छोड़ी और अपना भाला उठाया। ");
INSERT INTO hin2010_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","वह इस्राएली व्यक्ति के पीछे—पीछे उसके खेमे में गया। तब उसने इस्राएली पुरुष और मिद्यानी स्त्री को अपने भाले से मार डाला। उसने अपने भाले को दोनों के शरीरों के पार कर दिया। उस समय इस्राएल के लोगों में एक बड़ी बीमारी फैली थी। किन्तु जब पीनहास ने इन दोनों लोगों को मार डाला तो बीमारी रूक गई। ");
INSERT INTO hin2010_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","इस बीमारी से चौबीस हजार लोग मर चुके थे। ");
INSERT INTO hin2010_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“याजक हारून के पोते तथा एलीआजार के पुत्र पीनहास ने इस्राएल लोगों को मेरे क्रोध से बचा लिया है। उसने मुझे प्रसन्न करने के लिए कठिन प्रयत्न किया। वह वैसा ही है जैसा मैं हूँ। उसने मेरी प्रतिष्ठा को लोगों में सुरक्षित रखने का प्रयत्न किया। इसलिए मैं लोगों को वैसे ही नहीं मारूँगा जैसे मैं मारना चाहता था। ");
INSERT INTO hin2010_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","इसलिए पीनहास से कहो कि मैं उसके साथ एक शान्ति की वाचा करना चाहता हूँ। ");
INSERT INTO hin2010_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","वह और उसके बाद के वंशज मेरे साथ एक वाचा करेंगे। वे सदा याजक रहेंगे क्योंकि उसने अपने परमेश्वर की प्रतिष्ठा की रक्षा के लिए कठिन प्रयत्न किया। इस प्रकार उसने इस्राएली लोगों के दोषों के लिए हर्जाना दिया।” ");
INSERT INTO hin2010_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","जो इस्राएली मिद्यानी स्त्री के साथ मारा गया था उसका नाम जिम्रि था वह साल का पुत्र था। वह शिमोन के परिवार समूह के परिवार का नेता था ");
INSERT INTO hin2010_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","और मारी गई मिद्यानी स्त्री का नाम कोजबी था। 15 वह सूर की पुत्री थी। वह अपने परिवार का मुखिया था और वह मिद्यानी परिवार समूह का नेता था। ");
INSERT INTO hin2010_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“मिद्यानी लोग तुम्हारे शत्रु हैं। तुम्हें उनके मार डालना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","उन्होंने पहले ही तुमको अपना शत्रु बना लिया है। उन्होंने तुमको धोखा दिया और तुमसे अपने मिथ्या देवताओं की पोर में पूजा करवाई और उन्होंने तुममें से एक व्यक्ति का विवाह कोजबी के साथ लगभग करा दिया जो मिद्यानी नेता की पुत्री थी। यही स्त्री उस समय मारी गयी जब इस्राएली लोगों में बीमारी आई। बीमारी इसलिए उत्पन्न की गई कि लोग पोर में मिथ्या देवता बाल की पूजा कर रहे थे।” ");
INSERT INTO hin2010_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","बड़ी बीमारी के बाद यहोवा ने मूसा और हारून के पुत्र याजक एलीआज़ार से बातें की। ");
INSERT INTO hin2010_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","उसने कहा, “सभी इस्राएली लोगों की संख्या गिनो। हर एक परिवार को देखो और बीस वर्ष या उससे अधिक उम्र के हर एक पुरुष को गिनो। ये वे पुरुष हैं जो इस्राएल की सेना में सेवा करने योग्य हैं।” ");
INSERT INTO hin2010_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","इस समय लोग मोआब के मैदान में डेरा डाले थे। यह यरीहो के पार यरदन नदी के समीप था। इसलिए मूसा और याजक एलीआज़ार ने लोगों से बातें कीं। ");
INSERT INTO hin2010_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","उन्होंने कहा, “तुम्हें बीस वर्ष या उससे अधिक उम्र के हर एक पुरुष को गिनना चाहिए। यही वह आदेश था जो यहोवा ने मूसा को पालन करने के लिए दिया था।” यहाँ उन इस्राएल के लोगों की सूची है जो मिस्र से आए थेः ");
INSERT INTO hin2010_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ये रूबेन के परिवार के लोग हैं। (रूबेन इस्राएल (याकूब) का पहलौठा पुत्र था।) ये परिवार थेः हनोक—हनोकी परिवार। पल्लू—पल्लिय परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","हेस्रोन—हेस्रोनी परिवार। कर्मी—कर्मी परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","रूबेन के परिवार समूह में वे परिवार थे। योग में सभी तैंतालीस हजार सात सौ तीस पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","पल्लू का पुत्र एलीआब था। ");
INSERT INTO hin2010_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","एलीआब के तीन पुत्र थे—नमूएल, दातान और अबीराम। याद रखो कि दातान और अबीराम वे दो नेता थे जो मूसा और हारून के विरोधी हो गए थे। वे कोरह के अनुयायी थे और कोरह यहोवा विरोधी हो गया था। ");
INSERT INTO hin2010_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","वही समय था जब पृथ्वी फटी थी और कोरह एवं उसके सभी अनुयायियों को निगल गई थी। कुल दो सौ पचास पुरुष मर गये थे। यह इस्राएल के सभी लोगों के लिए एक संकेत और चेतावनी थी। ");
INSERT INTO hin2010_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","किन्तु कोरह के परिवार के अन्य लोग नहीं मरे। ");
INSERT INTO hin2010_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","शिमोन के परिवार समूह के ये परिवार थेः नमूएल—नमूएल परिवार। यामीन—यामीन परिवार। याकीन—याकीन परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","जेरह—जेराही परिवार। शाऊल—शाऊल परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","शिमोन के परिवार समूह में वे परिवार थे। इसमें कुल बाइस हजार पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","गाद के परिवार समूह के ये परिवार हैः सपोन—सपोन परिवार। हाग्गी—हाग्गी परिवार। शूनी—शूनी परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ओजनी—ओजनी परिवार। ऐरी—ऐरी परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","अरोद—अरोद परिवार। अरेली—अरेली परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","गाद के परिवार समहू के वे परिवार थे। इनमें कुस चालीस हजार पाँच सौ पुरुष थे। ");
INSERT INTO hin2010_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","20","यहूदा के परिवार समूह के ये परिवार हैं: शेला—शेला परिवार। पेरेस—पेरेस परिवार। जेरह—जेरह परिवार। (यहूदा के दो पुत्र एर, ओनान—कनान में मर गए थे।) ");
INSERT INTO hin2010_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","पेरेस के ये परिवार हैं: हेस्रोन—हेस्रोनी परिवार। हामूल—हामूल परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","यहूदा के परिवार समूह के वे परिवार थे। इनके कुल पुरुषों की संख्या छिहत्तर हजार पाँच सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","इस्साकार के परिवार समूह के परिवार ये थेः तोला—तोला परिवार। पुव्वा—पुव्वा परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","याशूब—याशूब परिवार। शिम्रोन—शिम्रोन परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","इस्साकार के परिवार समूह के वे परिवार थे। इनमें कुल पुरुषों की संख्या चौसठ हजार तीन सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","जबूलून के परिवार समूह के परिवार ये थेः सेरेद—सेरेद परिवार। एलोन—एलोन परिवार। यहलेल—यहलेल परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","जबूलून के परिवार समूह के वे परिवार थे। इनमें कुल पुरुषों की संख्या साठ हजार पाँच सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","यूसुफ के दो पुत्र मनश्शे और एप्रैम थे। हर एक पुत्र अपने परिवारों के साथ परिवार समूह बन गया था। ");
INSERT INTO hin2010_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","मनश्शे के परिवार में ये थेः माकीर—माकीर परिवार, (माकीर गिलाद का पिता था।) गिलाद—गिलाद परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","गिलाद के परिवार ये थेः ईएजेर—ईएजेर परिवार। हेलेक—हेलेकी परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","अस्रीएल—अस्रीएल परिवार। शेकेम—शेकेमी परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","शमीदा—शमीदा परिवार। हेपेर—हेपेरी परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","हेपेर का पुत्र सलोफाद था। किन्तु उसका कोई पुत्र न था। केवल पुत्री थी। उसकी पुत्रियों के नाम महला, नोआ, होग्ला, मिल्का, और तिर्सा थे। ");
INSERT INTO hin2010_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","मनश्शे परिवार समूह के ये परिवार हैं। इनमें कुल पुरुष बावन हजार सात सौ थे। ");
INSERT INTO hin2010_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","एप्रैम के परिवार समूह के ये परिवार थेः शूतेलह—शूतेलही परिवार। बेकेर—बेकेरी परिवार। तहन—तहनी परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","एरान शूतेलह परिवार का था। उसका परिवार एरनी था। ");
INSERT INTO hin2010_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","एप्रैम के परिवार समूह में ये परिवार थे। कुल पुरुषों की संख्या इसमें बत्तीस हजार पाँच सौ थी। वे ऐसे सभी लोग हैं जो यूसुफ के परिवार समूहों के हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","बिन्यामीन के परिवार समूह के परिवार ये थेः बेला—बेला परिवार। अशबेल—अश्बेली परिवार। अहीरम—अहीरमी परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","शपूपाम—शपूपाम परिवार। हूपाम—हूपामी परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","बेला के परिवार में ये थेः अर्द—अर्दी परिवार। नामान—नामानी परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","बिन्यामीन के परिवार समूह के ये सभी परिवार थे। इसमें पुरुषों की कुल संख्या पैंतालीस हजार छः सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","दान के परिवार समूह में ये परिवार थेः शूहाम—शूहाम परिवार समूह। दान के परिवार समूह से वह परिवार समूह था। ");
INSERT INTO hin2010_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","शूहामी परिवार समूह में बहुत से परिवार थे। इनमें पुरुषों की कुल संख्या चौंसठ हजार चार सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","आशेर के परिवार समूह के ये परिवार हैं: यिम्ना—यिम्नी परिवार। यिश्री—यिश्री परिवार। बरीआ—बरीआ परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","बरीआ के ये परिवार हैं हेबेर—हेबेरी परिवार। मल्कीएल—मल्कीएली परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(आशेर की एक पुथत्री सेरह नाम की थी।) ");
INSERT INTO hin2010_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","आशेर के परिवार समूह में वे परिवार थे। इसमें पुरूषों की संख्या तिरपन हजार चार सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","नप्ताली के परिवार समूह के ये परिवार थेः यहसेल— यहसेली परिवार। गूनी—गूनी परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","येसेर—येसेरी परिवार। शिल्लेम—शिल्लेमी परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","नप्ताली के परिवार समूह के ये परिवार थे। इसमें पुरुषों की कुल संख्या पैंतालीस हजार चार सौ थी। ");
INSERT INTO hin2010_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","इस प्रकार इस्राएल के पुरुषों की कुल संख्या छः लाख एक हजार सात सौ तीस थी। ");
INSERT INTO hin2010_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","यहोवा ने मूसा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“हर एक परिवार समूह को भूमि दी जाएगी। यह वही प्रदेश है जिसके लिए मैंने वचन दिया था। हर एक परिवार समूह उन लोगों के लिये पर्याप्त भूमि प्राप्त करेंगे जिन्हें गिना गया। ");
INSERT INTO hin2010_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","बड़ा परिवार समूह अधिक भूमि पाएगा और छोटा परिवार समूह कम भूमि पाएगा। किन्तु हर एक परिवार समूह को भूमि मिलेगी जिसके लिए मैंने वचन दिया है और जो भूमि वे पाएंगे वह उनकी गिनी गई संख्या के बराबर होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","हर एक परिवार समूह को पासों के आधार पर निश्चय करके धरती दी जाएगी और उस प्रदेश का वही नाम होगा जो उस परिवार समूह का होगा। ");
INSERT INTO hin2010_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","वह प्रदेश जिसे मैंने लोगों को देने का वचन दिया, उनके उत्तराधिकार में होगा। यह बड़े और छोटे परिवार समूहों को दिया जाएगा। निर्णय करने के लिए तुम्हें पासे फेंकने होंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","लेवी का परिवार समूह भी गिना गया। लेवी के परिवार समूह के ये परिवार हैं गेर्शोन—गेर्शोन परिवार। कहात—कहात परिवार। मरारी—मरारी परिवार। ");
INSERT INTO hin2010_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","लेवी के परिवार समूह से ये परिवार भी थेः लिब्नि परिवार। हेब्रोनी परिवार। महली परिवार। मूशी परिवार। कहात परिवार। अम्राम कहात के परिवार समूह का था। ");
INSERT INTO hin2010_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","अम्राम की पत्नी का नाम योकेबेद था। वह भी लेवी के परिवार समूह की थी। उसका जन्म मिस्र में हुआ था। अम्राम और योकेबेद के दो पुत्र हारून और मूसा थे। उनकी एक पुत्री मरियम भी थी। ");
INSERT INTO hin2010_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","हारून, नादाब, अबीहू, एलीआज़ार तथा ईतामार का पिता था। ");
INSERT INTO hin2010_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","किन्तु नादाब और अबीहू मर गए। वे मर गए क्योंकि उन्होंने यहोवा को उस आग से भेंट चढ़ाई जो उनके लिए स्वीकृत नहीं थी। ");
INSERT INTO hin2010_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","लेवी परिवार समूह के सभी पुरुषों की संख्या तेईस हजार थी। किन्तु ये लोग इस्राएल के अन्य लोगों के साथ नहीं गिने गए थे। वे भूमि नहीं पा सके जिसे अन्य लोगों को देने का वचन यहोवा ने दिया था। ");
INSERT INTO hin2010_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","मूसा और याजक एलीआजार ने इन सभी लोगों को गिना। उन्होंने इस्राएल के लोगों को मोआब के मैदान में गिना। यह यरीहो से यरदन नदी के पार था। ");
INSERT INTO hin2010_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","बहुत समय पहले मूसा और याजक हारून ने इस्राएल के लोगों को सीनै मरुभूमि में गिना था। किन्तु वे सभी लोग मर चुके थे। मोआब के मैदान में मूसा ने जिन लोगों को गिना, वे पहले गिने गए लोगों से भिन्न थे। ");
INSERT INTO hin2010_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","यह इसलिए हुआ कि यहोवा ने इस्राएल के लोगों से यह कहा था कि वे सभी मरुभूमि मे मरेंगे। जो केवल दो जीवित बचे थे यपुन्ने का पुत्र कालेब और नून का पुत्र यहोशू थे। ");
INSERT INTO hin2010_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","सलोफाद हेपर का पुत्र था। हेपेर गिलाद का पुत्र था। गिलाद माकीर का पुत्र था। माकीर मनश्शे का पुत्र था और मनश्शे यूसुफ का पुत्र था। सलोफाद की पाँच पुत्रियाँ थीं। उनके नाम महला, नोवा, होग्ला, मिल्का और तिर्सा था। ");
INSERT INTO hin2010_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ये पाँचों स्त्रियाँ मिलापवाले तम्बू में गई और मूसा, याजक एलीआजार, नेतागण और सब इस्राएलियों के सामने खड़ी हो गई। पाँचों पुत्रियों ने कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“हमारे पिता उस समय मर गये जब हम लोग मरुभूमि से यात्रा कर रहे थे। वह उन लोगों में से नहीं था जो कोरह के दल में सम्मिलित हुए थे। (करोह वही था जो यहोवा के विरुद्ध हो गया था।) हम लोगों के पिता की मृत्यु स्वाभाविक थी। किन्तु हमारे पिता का कोई पुत्र नहीं था। ");
INSERT INTO hin2010_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","इसका तात्पर्य यह हुआ कि हमारे पिता का नाम नहीं चलेगा। यह ठीक नहीं है कि हमारे पिता का नाम मिट जाए। इसलिए हम लोग यह माँग करते हैं कि हमें भी कुछ भूमि दी जाए जिसे हमारे पिता के भाई पाएंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","इसलिए मूसा ने यहोवा से पूछा कि वह क्या करे। ");
INSERT INTO hin2010_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","यहोवा ने उससे कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“सलोफाद की पुत्रियाँ ठीक कहती हैं। तुम्हें उनके चाचाओं के साथ—साथ उन्हें भी भूमि का भाग अवश्य देना चाहिए जो तुम उनके पिता को देते। ");
INSERT INTO hin2010_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“इसलिए इस्राएल के लोगों के लिए इसे नियम बना दो। यदि किसी व्यक्ति के पुत्र न हो और वह मर जाए तो हर एक चीज़ जो उसकी है, उसकी पुत्री की होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","यदि उसे कोई पुत्र न हो तो, जो कुछ भी उसका है उसके भाईयों को दिया जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","यदि उसका कोई भाई न हो तो, जो कुछ उसका है उसके पिता के भाईयों को दिया जाएगा। ");
INSERT INTO hin2010_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","यदि उसके पिता का कोई भाई नहीं है तो, जो कुछ उसका हो उसे उसके परिवार के निकटतम सम्बन्धी को दिया जाएगा। इस्राएल के लोगों में यह नियम होना चाहिए। यहोवा मूसा को यह आदेश देता है।” ");
INSERT INTO hin2010_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","तब यहोवा ने मूसा से कहा, “उस पर्वत के ऊपर चढ़ो। जो अबारीम पर्वत श्रृंखला में से एक है। वहाँ तुम उस प्रदेश को देखोगे जिसे मैं इस्राएल के लोगों को दे रहा हूँ। ");
INSERT INTO hin2010_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","जब तुम इस प्रदेश को देख लोगे तब तुम अपने भाई हारून की तरह मर जाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","उस बात को याद करो जब लोग सीन की मरुभूमि में पानी के लिए क्रोधित हुए थे। तुम और हारून दोनों ने मेरा आदेश मानना अस्वीकार किया था। तुम लोगों ने मेरा सम्मान नहीं किया था और लोगों के सामने मुझे पवित्र नहीं बनाया था।” (यह पानी सीन की मरुभूमि में कादेश के अन्तर्गत मरीबा में था।) ");
INSERT INTO hin2010_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","मूसा ने यहोवा से कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“यहोवा परमेश्वर है वही जानता है कि लोग क्या सोच रहे हैं। यहोवा मेरी प्रार्थना है कि तू इन लोगों के लिए एक नेता चुन। ");
INSERT INTO hin2010_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","मैं प्रार्थना करता हूँ कि यहोवा एक ऐसा नेता चुन जो उन्हें इस प्रदेश से बाहर ले जाएगा तथा उन्हें नये प्रदेश में पहुँचायेगा। तब यहोवा के लोग गड़ेरिया रहित भेड़ के समान नहीं होंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","इसलिए यहोवा ने मूसा से कहा, नून का पुत्र यहोशू नेता होगा। यहोशू बहुत बुद्धिमान है उसे नया नेता बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","उससे याजक एलीआज़ार और सभी लोगों के सामने खड़े होने को कहो। तब उसे नया नेता बनाओ। ");
INSERT INTO hin2010_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","“लोगों को यह दिखाओ कि तुम उसे नेता बना रहे हो, तब सभी उसका आदेश मानेंगे। ");
INSERT INTO hin2010_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","यदि यहोशू कोई विशेष निर्णय लेना चाहेगा तो उसे याजक एलीआज़ार के पास जाना होगा। एलीआज़ार ऊरीम का उपयोग यहोवा के उत्तर को जानने के लिए करेगा। तब यहोशू और इस्राएल के सभी लोग वह करेंगे जो परमेश्वर कहेगा। यदि परमेश्वर कहेगा, ‘युद्ध करने जाओ।’ तो वे युद्ध करने जाएंगे और यदि परमेश्वर कहे, ‘घर जाओं,’ तो घर जायेंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","मूसा ने यहोवा की आज्ञा मानी। मूसा ने यहोशू से याजक एलीआज़ार और इस्राएल के सब लोगों के सामने खड़ा होने के लिए कहा। ");
INSERT INTO hin2010_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","तब मूसा ने अपने हाथों को उसके सिर पर यह दिखाने के लिए रखा कि वह नया नेता है। उसने यह वैसे ही किया जैसा यहोवा ने कहा था। ");
INSERT INTO hin2010_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","तब यहोवा ने मूसा से बात की। उसने कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“इस्राएल के लोगों को यह आदेश दो। उनसे कहो कि वे ठीक समय पर निश्चयपूर्वक मुझे विशेष भेंट चढ़ाएं। उनसे कहो कि वे अन्नबलि और होमबलि चढ़ाएं। यहोवा उन होमबलियों की सुगन्ध पसन्द करता ह। ");
INSERT INTO hin2010_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","इन होमबलियों को उन्हें यहोवा को चढ़ाना ही चाहिए। उन्हें दोषरहित एक वर्ष के दो मेढ़े नित्य भेंट के रूप में चढ़ाना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","मेढ़ों में से एक को सवेरे चढ़ाओ और दूसरे मेढ़े को संध्या के समय। ");
INSERT INTO hin2010_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","इसके अतिरिक्त दो क्वार्ट अन्नबलि एक क्वार्ट जैतून के तेल के साथ मिला आटा दो।” ");
INSERT INTO hin2010_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","(उन्होंने सीनै पर्वत पर नित्य भेंट देनी आरम्भ की थी। यहोवा ने उन होमबलियों की सुगन्ध पसन्द की थी।) ");
INSERT INTO hin2010_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","लोगों को होमबलि के साथ पेय भेंट भी चढ़ानी चाहिए। उन्हें हर एक मेमने के साथ एक क्वार्ट दाखमधु देनी चाहिए। उस पेय भेंट को पवित्र स्थान में वेदी पर डालो। यह यहोवा को भेंट है। ");
INSERT INTO hin2010_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","दूसरे मेढ़े की भेंट गोधूलि के समय चढ़ाओ। इसे सवेरे की भेंट की तरह चढ़ाओ। वैसे ही पेय भेंट भी चढ़ाओ. ये आग द्वारा दी गई भेंट होगी। इस की सुगन्ध यहोवा को प्रसन्न करेगी। ");
INSERT INTO hin2010_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“शनिवार को, जो छुट्टी का दिन है, एक वर्ष के दोष रहित दो मेमने जैतून के तेल के साथ मिले चार क्वार्ट अच्छे आटे की अन्नबलि और पेय भेंट चढ़ाओ। ");
INSERT INTO hin2010_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","यह छुट्टी के दिन की विशेष भेंट है। यह भेंट नियमित नित्य भेंट और पेय भेंट के अतिरिक्त है।” ");
INSERT INTO hin2010_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“हर एक महीने के प्रथम दिन तुम यहोवा को होमबलि चढ़ाओगे। यह भेंट दोष रहित दो बैलों, एक मेढ़ा और सात एक वर्ष के मेमनों की होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","हर एक बैल के साथ जैतून के तेल के साथ मिले छः क्वार्ट अच्छे आटे की अन्नबलि भी चढ़ाओ। हर एक मेढ़े के साथ जैतून के तेल के साथ मिले चार क्वार्ट अच्छे आटे की अन्नबलि भी चढ़ाओ। ");
INSERT INTO hin2010_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","हर एक मेमने के साथ जैतून के तेल के साथ मिले दो क्वार्ट अच्छे आटे की अन्नबलि भी चढ़ाओ। यह ऐसी होमबलि होगी जो यहोवा के लिए मधुर गन्ध होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","पेय भेंट में दो क्वार्ट दाखमधु हर एक बैल के साथ, एक चौथाई क्वार्ट दाखमधु हर एक मेढ़े के साथ और एक क्वार्ट दाखमधु हर एक मेमने के साथ होगी। यह होमबलि है जो वर्ष के हर एक महीने चढ़ाई जानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","नित्य दैनिक होमबलि और पेय भेंट के अतिरिक्त तुम्हें यहोवा को एक बकरा देना चाहिए। वह बकरा पापबलि होगा। ");
INSERT INTO hin2010_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“पहले महीने के चौदहवें दिन यहोवा के सम्मान में फसह पर्व होगा। ");
INSERT INTO hin2010_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","उस महीने के पन्द्रहवें दिन अखमीरी रोटी की दावत आरम्भ होती है। यह पर्व सात दिन तक रहता है। तुम वही रोटी खा सकते हो जो अखमीरी हो। ");
INSERT INTO hin2010_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","इस पर्व के पहले दिन तुम्हें विशेष बैठक बुलानी चाहिए। उस दिन तुम कोई काम नहीं करोगे। ");
INSERT INTO hin2010_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","तुम यहोवा को होमबलि दोगे। यह होमबलि दोष रहित दो बैल, एक मेढ़ा और एक वर्ष के सात मेमनों की होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","21","हर एक बैल के साथ जैतून के तेल के साथ मिले हुए छ: क्वार्ट अच्छे आटे। मेढ़े के साथ जैतून के तेल के साथ मिले हुए चार क्वार्ट अच्छ आटे और हर एक मेमने के साथ दो क्वार्ट जैतून के तेल के साथ मिले हुए आटे की अन्नबलि भी होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","तुम्हें एक बकरा भी देना चाहिए। वह बकरा तुम्हारे लिए पापबलि होगा। यह तुम्हारे पापो को ढकेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","तुम लोगों को वे भेंटे उन भेंटों के अतिरिक्त देनी चाहिए जो तुम हर एक सवेरे होमबलि के रूप में देते हो। ");
INSERT INTO hin2010_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","“उसी प्रकार तुम्हें सात दिन तक आग द्वारा भेंट देनी चाहिए और इसके साथ पेय भेंट भी देनी चाहिए। यह भेंट यहोवा के लिए मधुर गन्ध होगी। तुम्हें ये भेंटे होमबलि के अतिरिक्त देनी चाहिए जो तुम प्रतिदिन देते हो। ");
INSERT INTO hin2010_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","“तब फसह पर्व के सातवें दिन तुम एक विशेष बैठक बुलाओगे और उस दिन तुम कोई काम नहीं करोगे। ");
INSERT INTO hin2010_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“प्रथम फल का पर्व या सप्ताहों के पर्व के समय तुम यहोवा के नये फसल की अन्नबलि दो। उस समय तुम्हें एक विशेष बैठक भी बुलानी चाहिए। तुम उस दिन कोई काम नहीं करोगे। ");
INSERT INTO hin2010_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","तुम होमबलि चढ़ाओगे। वह बलि यहोवा के लिए सुगन्ध होगी। तुम दोष रहित दो साँड, एक मेढ़ा और एक वर्ष के सात मेमनों की भेंट चढ़ाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","तुम हर एक साँड के साथ जैतून के तेल के साथ मिले हुए छः क्वार्ट अच्छे आटे, हर एक मेढ़े के साथ चार क्वार्ट ");
INSERT INTO hin2010_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","और हर एक मेमने के साथ दो क्वार्ट आटे की भेंट चढ़ाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","तुम्हें अपने पापों को ढकने के लिए एक बकरे की बलि चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","तुम्हें यह भेंट प्रतिदिन होमबलि और इसकी अन्नबलि के अतिरिक्त चढ़ानी चाहिए। निश्चय कर लो कि जानवरों में कोई दोष न हो और यह निश्चय कर लो कि पेय भेंट ठीक है। ");
INSERT INTO hin2010_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“सातवें महीने के प्रथम दिन एक विशेष बैठक होगी। तुम उस दिन कोई काम नहीं करोगे। वह बिगुल बजाने का दिन है। ");
INSERT INTO hin2010_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","तुम होमबलि चढ़ाओगे। ये भेंटे यहोवा के लिए मधुर गन्ध होगी। तुम दोष रहित एक साँड, एक मेढ़ा और एक वर्ष के सात मेमनों की भेंट चढ़ाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","तुम छः क्वार्ट तेल मिला अच्छा आटा भी बैल के साथ, चार क्वार्ट मेढ़े के साथ और ");
INSERT INTO hin2010_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","सात मेमनों में से हर एक के साथ दो क्वार्ट आटे की भेंट चढ़ाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","इसके अतिरिक्त, पापबलि के लिए एक बकरा भी चढ़ाओगे। यह तुम्हारे पापों को ढकेगी। ");
INSERT INTO hin2010_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ये भेंटे नवचन्द्र बलि और उसकी अन्नबलि के अतिरिक्त होगी और ये नित्य की भेंटों, इसकी अन्नबलियों तथा पेय भेंटों के अतिरिक्त होगी। ये नियम के अनुसार की जानी चाहिए। इन्हें आग में जलाना चाहिए। इसकी सुगन्धि यहोवा को प्रसन्न करेगी। ");
INSERT INTO hin2010_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“सातवें महीने के दसवें दिन एक विशेष बैठक होगी। उस दिन तुम उपवास करोगे और तुम कोई काम नहीं करोगे। ");
INSERT INTO hin2010_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","तुम होमबलि दोगे। यह यहोवा के लिए मधुर गन्ध होगी। तुम दोष रहित दो साँड, एक मेढ़ा और एक वर्ष के सात मेमनों की भेंट चढ़ाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","तुम हर एक बैल के साथ जैतून के मिले हुए छ: क्वार्ट आटे, मेढ़े के साथ चार क्वार्ट आटे ");
INSERT INTO hin2010_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","और हर एक सातों मेमनों के साथ दो क्वार्ट आटे की भेंट चढ़ाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","तुम एक बकरा भी पापबलि के रूप में चढ़ाओगे। यह प्रायश्चित के दिन की पापबलि के अतिरिक्त होगी। यह दैनिक बलि, अन्न और पेय भेंटों के भी अतिरिक्त होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“सातवें महीने के पन्द्रहवें दिन एक विशेष बैठक होगी। तुम उस दिन कोई काम नहीं करोगे। तुम यहोवा के लिए सात दिन तक छुट्टी मनाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","तुम होमबलि चढ़ाओगे। यह यहोवा के लिए मधुर गन्ध होगी। तुम दोष रहित तेरह साँड, दो मेढ़े और एक—एक वर्ष के चौदह मेमने भेंट चढ़ाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","तुम तेरह बैलों में से हर एक के साथ जैतून के साथ मिले हुए छः क्वार्ट आटे, दोनों मेढ़ों में से हर एक के लिए चार क्वार्ट ");
INSERT INTO hin2010_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","और चौदह मेढ़ों में से हर एक के लिए दो क्वार्ट आटे की भेंट चढ़ाओगे। ");
INSERT INTO hin2010_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","तुम्हें एक बकरा भी पापबलियों के रूप में अर्पित करना चाहिए। यह दैनिकबलि, अन्न और पेय भेंट के अतिरिक्त होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“इस पर्व के दूसरे दिन तुम्हें दोष, रहित बारह साँड, दो मेढ़ें और एक—एक वर्ष के चौदह मेमनों की भेंटे चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","तुम्हें साँड, मेढ़ों और मेमनों के साथ अपेक्षित मात्रा में अन्न और पेय भेंट भी चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","तुम्हें पापबलि के रूप में एक बकरे की भी भेंट देनी चाहिए। यह दैनिक बलि और अन्नबलि तथा पेय भेंट के अतिरिक्त भेंट होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“इस छुट्टी के तीसरे दिन तुम्हें दोष रहित ग्यारह साँड, दो मेढ़े और एक—एक वर्ष के चौदह मेमनों की भेंट चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","तुम्हें बैलों, मेढ़ों और मेमनों के साथ अपेक्षित मात्रा में अन्न और पेय की भेंट भी चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","तुम्हें पापबलि के रूप में एक बकरे की भी भेंट देनी चाहिए। यह दैनिक बलि और अन्नबलि तथा पेय भेंट के अतिरिक्त भेंट होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“इस छुट्टी के चौथे दिन तुम्हें दोष रहित दस साँड, दो मेढ़े और एक—एक वर्ष के चौदह मेमनों की भेंट चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","तुम्हें बैलों, मेढ़ों और मेमनों के साथ अपेक्षित मात्रा में अन्न और पेय की भेंट चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","तुम्हें पापबलि के रूप में एक बकरे की भी भेंट देनी चाहिए। यह दैनिक बलि और अन्नबलि तथा पेय भेंट के अतिरिक्त भेंट होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“इस छुट्टी के पाँचवें दिन तुम्हें दोष रहित नौ साँड, दो मेढ़े और एक—एक वर्ष के चौदह मेमनों की भेंट चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","तुम्हें बैलों, मेढ़ों और मेमनों के साथ अपेक्षित मात्रा में अन्न तथा पेय की भी भेंट चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","तुम्हें पापबलि के रूप में एक बकरे की भी भेंट देनी चाहिए। यह दैनिक बलि और अन्नबलि तथा पेय भेंट के अतिरिक्त भेंट होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“इस छुट्टी के छठे दिन तुम्हें दोष रहित आठ साँड, दो मेढ़ें और एक—एक वर्ष के चौदह मेमनों की भेंट चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","तुम्हें बैलों, मेढ़ों और मेमनों के साथ अपेक्षित मात्रा में अन्न और पेय की भेंट भी चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","तुम्हें पापबलि के रूप में एक बकरे की भी भेंट देनी चाहिए। यह दैनिक बलि और अन्नबलि तथा पेय भेंट के अतिरिक्त भेंट होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“इस छुट्टी के सातवें दिन तुम्हें दोष रहित सात साँड, दो मेढ़े, और एक—एक वर्ष के चौदह मेमनों की भेंट चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","तुम्हें बैलो, मेढ़ों और मेमनो के साथ अपेक्षित मात्रा में अन्न और पेय की भी घोट चढ़ानी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","तुम्हें पापबलि के रूप में एक बकरे की भी भेंट देनी चाहिए। यह दैनिक बलि और अन्नबलि तथा पेय भेंट के अतिरिक्त भेंट होगी। ");
INSERT INTO hin2010_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“इस छुट्टी का आठवाँ दिन तुम्हारी विशेष बैठक का दिन है। तुम्हें उस दिन कोई काम नहीं करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","तुम्हें होमबलि चढ़ानी चाहिए। ये आग द्वारा दी गई भेंट होगी। यह यहोवा के लिए मधुर सुगन्ध होगी। तुम्हें दोषरहित एक साँड, एक मेढ़ा और एक—एक वर्ष के सात मेमने भेंट में चढ़ाने चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","तुम्हें साँड, मेढ़ा और मेमनों के लिए अपेक्षित मात्रा में अन्न और पेय की भी भेंट देनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","तुम्हें पापबलि के रूप में एक बकरे की भी भेंट देनी चाहिए। यह दैनिक बलि और अन्नबलि तथा पेय भेंट के अतिरिक्त भेंट होनी चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“वे (तुम्हारे) विशेष छुट्टियाँ यहोवा के सम्मान के लिए है। तुम्हें उन विशेष मनौतियों, स्वेच्छा भेंटों, होमबलियों मेलबलियों या अन्न और पेय भेंटे, जो तुम यहोवा को देना चाहते हो, उसके अतिरिक्त इन विशेष दिनों को मनाना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","मूसा ने इस्राएल के लोगों से उन सभी बातों को कहा जो यहोवा ने उसे आदेश दिया था। ");
INSERT INTO hin2010_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","मूसा ने सभी इस्राएली परिवार समूहों के नेताओं से बातें कीं। मूसा ने यहोवा के इन आदेशों के बारे में उनसे कहाः ");
INSERT INTO hin2010_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","“यदि कोई व्यक्ति परमेश्वर को विशेष वचन देता है या यदि वह व्यक्ति यहोवा को कुछ विशेष अर्पित करने का वचन देता है तो उसे वैसा ही करने दो। किन्तु उस व्यक्ति को ठीक वैसा ही करना चाहिए जैसा उसने वचन दिया है। ");
INSERT INTO hin2010_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“सम्भव है कि कोई युवती अपने पिता के घर पर ही रहती हो और वह युवती यहोवा को कुछ चढ़ाने का विशेष वचन देती है ");
INSERT INTO hin2010_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","और उसका पिता इस वचन के विषय में सुनता है और उसे स्वीकार करत लेता है तो उस युवती को उस वचन को अवश्य ही पूरा कर देना चाहिए जिसे करने का उसने वचन दिया हैं। ");
INSERT INTO hin2010_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","किन्तु यदि उसका पिता उसके दिये गये वचनों के बारे में सुन कर उसे स्वीकार नहीं करता तो उस युवती को वह वचन पूरा नहीं करना है। उसके पिता ने उसे रोका अतः यहोवा उसे क्षमा करेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“सम्भव है कोई स्त्री अपने विवाह से पहले यहोवा को कोई वचन देती है अथवा बात ही बात में बिना सोचे विचारे कोई वचन ले लेती है और बाद में उसका विवाह हो जाता है ");
INSERT INTO hin2010_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","और पति दिये गये वचन के बारे में सुनता है और उसे स्वीकार करता है तो उस स्त्री को अपने दिये गए वचन के अनुसार काम को पूरा करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","किन्तु यदि पति दिये गए वचन के बारे में सुनता है और उसे स्वीकार नहीं करता तो स्त्री को अपने दिये गए वचन को पूरा नहीं करना पड़ेगा। उसके पति ने उसका वचन तोड़ दिया और उसने उसे उसकी कही बात को पूरा नहीं करने दिया, अतः यहोवा उसे क्षमा करेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“कोई विधवा या तलाक दी गई स्त्री विशेष वचन दे सकती है। यदि वह ऐसा करती है तो उसे ठीक अपने वचन के अनुसार करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“एक विवाहित स्त्री यहोवा को कुछ चढ़ाने का वचन दे सकती है। ");
INSERT INTO hin2010_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","यदि उसका पति दिये गए वचन के बारे में सुनता है और उसे अपने वचन को पूरा करने देता है, तो उसे ठीक अपने दिए गए वचनों के अनुसार ही वह कार्य करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","किन्तु यदि उसका पति उसके दिये गए वचन को सुनता है और उसे वचन पूरा करने से इन्कार करता है, तो उसे अपने दिये वचन के अनुसार वह कार्य पूरा नहीं करना पड़ेगा। इसका कोई महत्व नहीं होगा कि उसने क्या वचन दिया था, उसका पति उस वचन को भंग कर सकता है। यदि उसका पति वचन को भंग करता है, तो यहोवा उसे क्षमा करेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","एक विवाहित स्त्री यहोवा को कुछ चढ़ाने का वचन दे सकती है या स्वयं को किसी चीज़ से वंचित रखने का वचन दे सकती है या वह परमेश्वर को कोई विशेष वचन दे सकती हैं। उसका पति उन वचनों में से किसी को रोक सकता है या पति उन वचनों में से किसी को पूरा करने दे सकता है। ");
INSERT INTO hin2010_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","पति अपनी पत्नी को कैसे अपने वचन पूरा करने देगा यदि वह दिये वचन के बारे में सुनता है और उन्हें रोकता नहीं है तो स्त्री को अपने दिए वचन के अनुसार कार्य को पूरा करना चाहिए। ");
INSERT INTO hin2010_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","किन्तु यदि पति दिये गए वचन के बारे में सुनता है और उन्हें रोकता है तो उसके वचन तोड़ने का उत्तरदायित्व पति पर होगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ये आदेश है जिन्हें यहोवा ने मूसा को दिया। ये आदेश एक व्यक्ति और उसकी पत्नी के बारे में है तथा पिता और उसकी उस पुत्री के बारे में है जो युवती हो और अपने पिता के घर में रह रही हो। ");
INSERT INTO hin2010_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","यहोवा ने मूसा से बात की। उसने कहा, ");
INSERT INTO hin2010_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“मैं इस्राएल के लोगों के साथ मिद्यानियों ने जो किया है उसके लिए उन्हें दण्ड दूँगा। उसके बाद, मूसा, तू मर जाएगा।” ");
INSERT INTO hin2010_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","इसलिए मूसा ने लोगों से बात की। उसने कहा, “अपने कुछ पुरुषों को युद्ध के लिए तैयार करो। यहोवा उन व्यक्तियों का उपयोग मिद्यानियों को दण्ड देने में करेगा। ");
INSERT INTO hin2010_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ऐसे एक हजार पुरुषों को इस्राएल के हर एक कबीले से चुनो। ");
INSERT INTO hin2010_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","इस्राएल के सभी परिवार समूहों से बारह हजार सैनिक होंगे।” ");
INSERT INTO hin2010_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","मूसा ने उन बारह हजार पुरुषों को युद्ध के लिए भेजा। उसने याजक एलीआज़ार को उनके साथ भेजा। एलीआज़ार ने अपने साथ पवित्र वस्तुएं, सींग और बिगुल ले लिए। ");
INSERT INTO hin2010_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","इस्राएली लोगों के साथ वैसे ही लड़े जैसा यहोवा ने मूसा को आदेश दिया था। उन्होंने सभी मिद्यानीं पुरुषों को मार डाला। ");
INSERT INTO hin2010_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","जिन लोगों को उन्होंने मार डाला उनमें एवी, रेकेम, सूर, हूर, और रेबा ये पाँच मिद्यानी राजा थे। उन्होंने बोर के पुत्र बिलाम को भी तलवार से मार डाला। ");
INSERT INTO hin2010_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","इस्राएल के लोगों ने मिद्यानी स्त्रियों और बच्चों को बन्दी बनाया। उन्होंने उनकी सारी रेवड़ों, मवेशियों के झुण्डों और अन्य चीज़ों को ले लिया। ");
INSERT INTO hin2010_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","तब उन्होंने उनके उन सारे खेमों और नगरों में आग लगा दी जहाँ वे रहते थे। ");
INSERT INTO hin2010_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","उन्होंने सभी लोगों और जानवरों को ले लिया, ");
INSERT INTO hin2010_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","और उन्हें मूसा, याजक एलीआज़ार और इस्राएल के सभी लोगों के पास लाए। वे उन सभी चीज़ों को इस्राएल के डेरे में लाए जिन्हें उन्होंने वहाँ प्राप्त किया। इस्राएल के लोग मोआब में स्थित यरदन घाटी में डेरा डाले थे। यह यरीहो के समीप यरदन नदी के पूर्व की ओर था। ");
INSERT INTO hin2010_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","तब मूसा, याजक एलीआज़ार और लोगों के नेता सैनिकों से मिलने के लिए डेरों से बाहर गए। ");
INSERT INTO hin2010_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","मूसा सेनापतियों पर बहुत क्रोधित था। वह उन एक हजार की सेना के संचालकों और सौ की सेना के संचालकों पर क्रोधित था जो युद्ध से लौट कर आए थे। ");
INSERT INTO hin2010_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","मूसा ने उनसे कहा, “तुम लोगों ने स्त्रियों को क्यों जीवित रहने दिया ");
INSERT INTO hin2010_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","देखो यह स्त्री ही थी जिसके कारण बिलाम की घटना में इस्रालियों के लिए समस्याएं पैदा हुई और पोर में वे यहोवा के विरुद्ध हो गये जिससे इस्राएल के लोगों को महामारी झेलनी पड़ी। ");
INSERT INTO hin2010_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","अब सभी मिद्यानी लड़कों को मार डालो और उन सभी मिद्यानी स्त्रियों को मार डालो जो किसी व्यक्ति के साथ रही हैं। उन सभी स्त्रियों को मार डालो जिनका किसी पुरुष के साथ यौन सम्बन्ध था। ");
INSERT INTO hin2010_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","तुम केवल उन सभी लड़कियों को जीवित रहने दे सकते हो जिनका किसी पुरुष के साथ यौन सम्बन्ध नहीं हुआ है। ");
INSERT INTO hin2010_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","तब अन्य व्यक्तियों को मारने वाले तुम लोगों को सात दिन तक डेरे के बाहर रहना पड़ेगा। तुम्हें डेरे से बाहर रहना होगा यदि तुमने किसी शव को छूआ हो। तीसरे दिन तुम्हें और तुम्हारे बन्दियों को अपने आप को शुद्ध करना होगा। तुम्हें वही कार्य सातवें दिन फिर करना होगा। ");
INSERT INTO hin2010_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","तुम्हें अपने सभी कपड़े धोने चाहिए। तुम्हें चमड़े की बनी हर वस्तु ऊनी और लकड़ी की बनी वस्तुओं को भी धोना चाहिए। तुम्हें शुद्ध हो जाना चाहिए।” ");
INSERT INTO hin2010_vpl VALUES ("NU31_21","005_31_21","N