﻿USE sofia;
DROP TABLE IF EXISTS sofia.hil_vpl;
CREATE TABLE hil_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hil_vpl WRITE;
INSERT INTO hil_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Sang ginsuguran, gintuga sang Dios ang kalangitan kag ang kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ang kalibutan sadto wala pa sing porma kag mahawan pa. Ang tubig nga nagatabon sa kalibutan nalikupan sang kadulom. Kag ang Espiritu sang Dios nagahulag sa ibabaw sang tubig. ");
INSERT INTO hil_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Dayon nagsiling ang Dios, “Magsanag!” Kag dayon may kasanag. ");
INSERT INTO hil_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nanamian ang Dios sa kasanag nga iya nakita. Dayon ginseparar niya ang kasanag kag ang kadulom. ");
INSERT INTO hil_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Gintawag niya nga “adlaw” ang kasanag kag gintawag niya nga “gab-i” ang kadulom. Nag-abot ang kagab-ihon, pagkatapos ang kaagahon. Amo ato ang una nga adlaw. ");
INSERT INTO hil_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Dayon nagsiling ang Dios, “Matuga ang kahawaan nga magaseparar sa tubig sa duha ka lugar.” ");
INSERT INTO hil_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kag nahimo ini. Ginhimo sang Dios ang kahawaan nga nagaseparar sa tubig sa ibabaw kag sa tubig sa idalom. ");
INSERT INTO hil_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ini nga kahawaan gintawag sang Dios nga “kalangitan.” Nag-abot ang kagab-ihon, pagkatapos ang kaagahon. Amo ato ang ikaduha nga adlaw. ");
INSERT INTO hil_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Dayon nagsiling ang Dios, “Magtingob sa isa ka lugar ang tubig sa kalibutan para magguwa ang mamala nga lugar.” Kag nahimo ini. ");
INSERT INTO hil_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Gintawag niya nga “duta” ang mamala nga lugar kag gintawag niya nga “dagat” ang natingob nga tubig. Nanamian ang Dios sa iya nakita. ");
INSERT INTO hil_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Dayon nagsiling ang Dios, “Magtubo sa duta ang mga tanom: ang mga tanom nga may mga liso kag ang mga kahoy nga nagapamunga suno sa ila nga klase.” Kag nahimo ini. ");
INSERT INTO hil_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nagtubo sa duta ang tanan nga klase sang tanom, kag nanamian ang Dios sa mga tanom nga iya nakita. ");
INSERT INTO hil_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nag-abot ang kagab-ihon, pagkatapos ang kaagahon. Amo ato ang ikatatlo nga adlaw. ");
INSERT INTO hil_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Dayon nagsiling ang Dios, “Matuga sa kalangitan ang mga butang nga may kasanag sa pagseparar sang adlaw kag sang gab-i, kag bilang palatandaan sang pag-umpisa sang mga panahon, mga adlaw kag mga tuig. ");
INSERT INTO hil_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Magsiga sila sa kalangitan sa paghatag kasanag sa kalibutan.” Kag nahimo ini. ");
INSERT INTO hil_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Gani nahimo ang duha ka dalagko nga mga butang nga may kasanag: ang mas dako nga magasanag kon adlaw, kag ang gamay nga magasanag kon gab-i. Nahimo man ang mga bituon. ");
INSERT INTO hil_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Ginbutang sang Dios ang ini nga mga butang sa kalangitan sa paghatag kasanag sa kalibutan kon adlaw kag gab-i, kag sa pagseparar sang adlaw kag sang gab-i. Kag nanamian ang Dios sa iya nakita. ");
INSERT INTO hil_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nag-abot ang kagab-ihon, pagkatapos ang kaagahon. Amo ato ang ikaapat nga adlaw. ");
INSERT INTO hil_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Dayon nagsiling ang Dios, “Magdamo ang nagkalain-lain nga sapat sa tubig, kag maglupad ang nagkalain-lain nga sapat sa kahanginan.” ");
INSERT INTO hil_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Gani ginhimo sang Dios ang dalagko nga mga sapat sa tubig, kag ang tanan nga klase sang sapat nga nagaestar sa tubig, kag ang tanan nga klase sang sapat nga nagalupad. Nanamian ang Dios sa iya nakita. ");
INSERT INTO hil_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kag ginbendisyunan niya ini nga mga sapat. Siling niya, “Magmuad kamo kag magdamo, kamo nga mga sapat sa tubig kag mga sapat nga nagalupad.” ");
INSERT INTO hil_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nag-abot ang kagab-ihon, pagkatapos ang kaagahon. Amo ato ang ikalima nga adlaw. ");
INSERT INTO hil_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Dayon nagsiling ang Dios, “Magkabuhi ang nagkalain-lain nga klase sang sapat sa duta: mga sapat nga mahagop kag maila, mga dalagko kag magagmay.” Kag nahimo ini. ");
INSERT INTO hil_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ginhimo sang Dios ang ini nga mga sapat, kag nanamian ang Dios sa iya nakita. ");
INSERT INTO hil_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Dayon nagsiling ang Dios, “Mahimo kita sang tawo nga kaanggid sa aton. Magagahom sila sa tanan nga klase sang mga sapat: ang nagalangoy, ang nagalupad, ang nagalakat, kag ang nagakamang.” ");
INSERT INTO hil_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Gani gintuga sang Dios ang tawo, lalaki kag babayi, nga kaanggid sa iya. ");
INSERT INTO hil_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kag ginbendisyunan niya sila nga nagasiling, “Magmuad kamo kag magdamo para ang inyo mga kaliwat magalapta kag magagahom sa kalibutan. Kag gamhan ninyo ang tanan nga sapat.” ");
INSERT INTO hil_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Dayon nagsiling ang Dios, “Ginahatag ko sa inyo ang mga tanom nga may mga liso kag ang mga kahoy nga nagapamunga para inyo kaunon. ");
INSERT INTO hil_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Kag ginahatag ko sa tanan nga sapat ang tanan nga hilamon kag dahon-dahon bilang pagkaon nila.” Kag natuman ini. ");
INSERT INTO hil_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Gintan-aw sang Dios ang tanan niya nga ginpanghimo kag nanamian gid siya. Nag-abot ang kagab-ihon, pagkatapos ang kaagahon. Amo ato ang ikaanom nga adlaw. ");
INSERT INTO hil_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Gani natapos tuga sang Dios ang kalangitan, ang kalibutan, kag ang tanan nga ara sa ila. ");
INSERT INTO hil_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Natapos niya ini sa sulod sang anom ka adlaw, kag sa ikapito nga adlaw nagpahuway siya sa tanan niya nga obra. ");
INSERT INTO hil_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ginbendisyunan niya ang ikapito nga adlaw kag ginkabig niya nga isa ka pinasahi nga adlaw, tungod kay sa sina nga adlaw nagpahuway siya matapos niya tuga ang tanan. ");
INSERT INTO hil_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Amo ini ang estorya parte sa pagtuga sang kalangitan kag sang kalibutan. Sang paghimo sang Ginoong Dios sang kalibutan kag sang kalangitan, ");
INSERT INTO hil_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","wala pa sa kalibutan ang mga ginakultibar nga mga tanom sa latagon, kay wala pa niya pagpaulana kag wala sing tawo nga magaatipan sang duta. ");
INSERT INTO hil_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Pero bisan wala sing ulan, ang mga tuburan sa kalibutan amo ang nagapabasa sa duta. ");
INSERT INTO hil_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Dayon ginhimo sang Ginoong Dios ang tawo halin sa duta. Ginhuypan niya sa ilong ang tawo sang ginhawa nga nagahatag sang kabuhi. Gani ang tawo nangin buhi nga tinuga. ");
INSERT INTO hil_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Dayon naghimo ang Ginoong Dios sang katamnan sa Eden, sa east, kag didto niya ginpaestar ang tawo nga iya ginhimo. ");
INSERT INTO hil_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Kag ginpatubo sang Ginoong Dios ang tanan nga klase sang mga kahoy nga manami tulukon kag ang ila mga bunga manamit kaunon. Sa tunga sang katamnan may kahoy didto nga nagahatag sang kabuhi, kag may kahoy man didto nga nagahatag sang ihibalo kon ano ang maayo kag ang malain. ");
INSERT INTO hil_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Sa Eden may suba nga nagailig, nga amo ang nagahatag sang tubig sa katamnan. Nagsanga ini sa apat ka suba. ");
INSERT INTO hil_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ang ngalan sang premiro nga suba amo ang Pishon. Nagailig ini sa bilog nga duta sang Havila, nga sa diin may mga bulawan. ");
INSERT INTO hil_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Puro gid ang mga bulawan didto. Kag makita man didto ang malahalon nga pahamot nga bediliyum, kag ang malahalon nga bato nga onix. ");
INSERT INTO hil_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ang ngalan sang ikaduha nga suba amo ang Gihon. Nagailig ini sa bilog nga duta sang Cush. ");
INSERT INTO hil_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ang ngalan sang ikatatlo nga suba amo ang Tigris. Nagailig ini sa east sang Assyria. Kag ang ikaapat nga suba amo ang Euphrates. ");
INSERT INTO hil_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ginpaestar sang Ginoong Dios sa katamnan sang Eden ang tawo nga iya ginhimo para mag-atipan sini. ");
INSERT INTO hil_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kag ginsilingan niya siya, “Makakaon ka sang bunga sang bisan ano nga kahoy sa katamnan, ");
INSERT INTO hil_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","luwas lang sang bunga sang kahoy nga nagahatag sang ihibalo kon ano ang maayo kag ang malain. Kay sa tion nga kaunon mo ini, sigurado gid nga mapatay ka.” ");
INSERT INTO hil_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Dayon nagsiling ang Ginoong Dios, “Indi maayo nga nagaisahanon lang ang tawo, himuan ko siya sang kaupod nga magabulig sa iya kag bagay sa iya.” ");
INSERT INTO hil_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ginhimo sang Ginoong Dios halin sa duta ang tanan nga klase sang mga sapat nga nagaestar sa duta pati ang tanan nga klase sang mga sapat nga nagalupad. Dayon gindala niya sila didto sa tawo para tan-awon kon ano ang ipangalan niya sa ila. Kag kon ano ang tawag sang tawo sa ila amo na ina ang ila mga ngalan. ");
INSERT INTO hil_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Gani gin-ngalanan sang tawo ang mga sapat nga nagaestar sa duta pati ang mga sapat nga nagalupad. Pero wala gid sing bisan isa sa ila nga bagay nga mangin kaupod niya nga magabulig sa iya. ");
INSERT INTO hil_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Gani ginpatulog sang Ginoong Dios ang tawo sing mahamuok gid. Kag samtang nagakatulog siya, ginkuha sang Ginoong Dios ang isa niya ka gusok kag ginkipot dayon ang ginkuhaan sini. ");
INSERT INTO hil_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ang gusok nga ginkuha sang Ginoong Dios sa lalaki ginhimo niya nga babayi, kag gindala niya siya sa lalaki. ");
INSERT INTO hil_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Dayon nagsiling ang lalaki, “Ari na ang pareho sa akon! Tul-an nga ginkuha sa akon tul-an, kag unod nga ginkuha sa akon unod. Pagatawgon siya nga babayi, kay ginkuha siya halin sa lalaki.” ");
INSERT INTO hil_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Amo ina ang rason nga bayaan sang lalaki ang iya amay kag iloy kag mag-upod sa iya asawa, kag sila nga duha mangin isa. ");
INSERT INTO hil_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Sadto nga tion, bisan hublas sila nga duha, wala sila mahuya. ");
INSERT INTO hil_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Karon, sa tanan nga maila nga sapat nga ginhimo sang Ginoong Dios, ang man-og amo ang labing maayo magpadihot. Isa sadto ka tion, ginpamangkot sang man-og ang babayi, “Matuod gid bala nga ginabawalan kamo sang Dios nga magkaon sang bisan ano nga bunga sang kahoy sa katamnan?” ");
INSERT INTO hil_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Nagsabat ang babayi, “Makakaon kami sang bisan ano nga bunga sang kahoy diri sa katamnan, ");
INSERT INTO hil_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","luwas lang sang bunga sang kahoy nga ara sa tunga sang sini nga katamnan. Kay nagsiling ang Dios nga indi gid kami magkaon sang bunga sang sina nga kahoy ukon bisan magtandog lang sini. Kay kon himuon namon ina, mapatay kami.” ");
INSERT INTO hil_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Pero nagsiling ang man-og, “Indi matuod nga mapatay kamo! ");
INSERT INTO hil_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nagsiling ang Dios sina tungod kay nahibaluan niya nga kon kaunon ninyo ina, masanagan kamo, kag mangin pareho kamo sa iya nga nakahibalo kon ano ang maayo kag ang malain.” ");
INSERT INTO hil_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Sang makita sang babayi nga ang kahoy manami tulukon kag ang iya mga bunga manamit kaunon, kag tungod nga naghandom siya nga mangin maalam, nagkuha siya sang bunga kag nagkaon. Ginhatagan man niya ang iya bana kag nagkaon man siya. ");
INSERT INTO hil_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Pagkatapos nila kaon, nakaintiendi sila kon ano ang maayo kag ang malain, kag natalupangdan nila nga hublas gali sila. Gani nagtambi-tambi sila sang mga dahon sang kahoy nga higera para itabon sa ila lawas. ");
INSERT INTO hil_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Sang mabulubugnaw na sang hapon, nabatian nila nga nagalakat ang Ginoong Dios sa katamnan. Gani nagpanago sila sa kakahuyan. ");
INSERT INTO hil_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Pero gintawag sang Ginoong Dios ang lalaki kag ginpamangkot, “Diin ka?” ");
INSERT INTO hil_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nagsabat ang lalaki, “Nabatian ko ikaw sa katamnan, gani nagpanago ako kay nahadlok ako tungod kay hublas ako.” ");
INSERT INTO hil_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Nagpamangkot ang Ginoong Dios, “Sin-o bala ang nagsiling sa imo nga hublas ka? Nagkaon ka bala sang bunga sang kahoy nga ginsiling ko sa imo nga indi mo pagkaunon?” ");
INSERT INTO hil_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Nagsabat ang lalaki, “Ang babayi abi nga ginpaupod mo sa akon ginhatagan niya ako sang bunga sang sadto nga kahoy kag ginkaon ko.” ");
INSERT INTO hil_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ginpamangkot dayon sang Ginoong Dios ang babayi, “Ngaa bala ginhimo mo ato?” Nagsabat ang babayi, “Gindayaan abi ako sang man-og. Amo ato nga nagkaon ako.” ");
INSERT INTO hil_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Gani nagsiling ang Ginoong Dios sa man-og, “Tungod nga ginhimo mo ini, ikaw lang gid sa tanan nga sapat ang magaagom sang sini nga sumpa: sa bilog mo nga kabuhi magakamang ka paagi sa imo tiyan, kag ang imo baba permi lang masudlan sang yab-ok. ");
INSERT INTO hil_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ikaw kag ang babayi magakontrahanay. Ang imo kaliwat kag ang iya kaliwat magakontrahanay man. Dunuton niya ang imo ulo kag kadton mo ang iya tikod.” ");
INSERT INTO hil_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Nagsiling man siya sa babayi, “Tungod sang imo ginhimo, dugangan ko ang imo pag-antos sa pagbusong kag ang imo kasakit sa pagbata. Pero sa pihak sina, handumon mo gihapon ang imo bana, kag magagahom siya sa imo.” ");
INSERT INTO hil_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Nagsiling man siya sa lalaki, “Tungod kay nagpati ka sa imo asawa kag nagkaon sang bunga sang kahoy nga gindumili ko sa imo, pakamalauton ko ang duta. Gani sa bilog mo nga kabuhi magapangabudlay ka sing tudo-tudo para makakaon ka. ");
INSERT INTO hil_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Magatubo sa duta ang tunukon nga mga tanom, kag magakaon ka sang mga gintanom sa uma. ");
INSERT INTO hil_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kinahanglan nga magpangabudlay ka sing tudo-tudo para makakaon ka, hasta nga magbalik ka sa duta nga amo ang imo ginhalinan. Tungod nga sa duta ka naghalin, gani sa duta ka man magabalik.” ");
INSERT INTO hil_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Gin-ngalanan ni Adan ang iya asawa nga “Eva” tungod kay siya ang mangin iloy sang tanan nga tawo. ");
INSERT INTO hil_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Dayon naghimo ang Ginoong Dios sang bayo nga halin sa panit sang sapat para kay Adan kag sa iya asawa. ");
INSERT INTO hil_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Dayon nagsiling ang Ginoong Dios, “Karon ang tawo nangin pareho na sa aton nga nakahibalo kon ano ang maayo kag ang malain. Kinahanglan nga indi gid siya pagtugutan nga magkaon sang bunga sang kahoy nga nagahatag sang kabuhi, kay kon magkaon siya, magapabilin siya nga buhi hasta san-o.” ");
INSERT INTO hil_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Gani ginpahalin siya sang Ginoong Dios sa katamnan sang Eden sa pagpanguma sang duta nga amo ang iya ginhalinan. ");
INSERT INTO hil_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Sang nakahalin na ang tawo, nagbutang ang Ginoong Dios sang mga kerubin sa east sang katamnan sang Eden. Kag nagbutang man siya sang espada nga nagadabadaba kag nagatiyog para wala sing may makapalapit sa kahoy nga nagahatag sang kabuhi. ");
INSERT INTO hil_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Pagkatapos sadto, naghulid si Adan sa iya asawa nga si Eva kag nagbusong siya. Sang nakabata na si Eva, nagsiling siya, “Nakaangkon ako sang bata nga lalaki paagi sa bulig sang Ginoo, gani ngalanan ko siya nga Cain.” ");
INSERT INTO hil_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kag sang ulihi nagbata liwat si Eva sing lalaki kag gin-ngalanan niya nga Abel. Si Abel nangin manugbantay sang mga karnero kag kanding, kag si Cain ya nangin mangunguma. ");
INSERT INTO hil_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Isa sadto ka adlaw, naghalad si Cain sa Ginoo halin sa iya patubas. ");
INSERT INTO hil_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Si Abel iya nagkuha sang kamagulangan sa iya mga kasapatan kag gin-ihaw niya, kag ginhalad ang pinakamaayo nga parte sa Dios. Nalipay ang Ginoo kay Abel kag sa iya halad, ");
INSERT INTO hil_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","pero wala siya nalipay kay Cain kag sa iya halad. Kag tungod sini, nagkusmod si Cain kag puwerte gid ang iya kaakig. ");
INSERT INTO hil_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Gani ginpamangkot siya sang Ginoo, “Ano bala ang naakigan mo? Ngaa nagakusmod ka? ");
INSERT INTO hil_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kon maayo lang ang imo ginahimo, kuntani malipayon ka. Pero kon indi maayo ang imo ginahimo, mag-andam ka kay nagabantay sa imo ang sala para tukbon ka. Gani kinahanglan daugon mo ini.” ");
INSERT INTO hil_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Isa sadto ka adlaw, nagsiling si Cain kay Abel, “Dali, makadto kita sa uma.” Kag sang didto na sila, ginpatay ni Cain si Abel nga iya utod. ");
INSERT INTO hil_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Dayon nagpamangkot ang Ginoo kay Cain, “Diin na bala ang imo utod?” Nagsabat si Cain, “Ambot, wala ako kahibalo. Ngaa, ako bala ang manugbantay niya?” ");
INSERT INTO hil_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Nagsiling dayon ang Ginoo kay Cain, “Ano bala ang imo ginhimo? Ang dugo sang imo utod daw sa tingog nga nagapakitluoy nga silutan ko ang tawo nga nagpatay sa iya. ");
INSERT INTO hil_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tungod sang imo ginhimo, ginapakamalaot ko ikaw. Sugod subong indi ka na makapanguma sa duta nga nagsuyop sang dugo sang imo utod nga imo ginpatay. ");
INSERT INTO hil_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Bisan magtanom ka pa, ang duta indi na magpatubas para sa imo. Kag wala ka na sing permanente nga elistaran, gani bisan diin ka na lang makadto.” ");
INSERT INTO hil_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Nagsiling si Cain sa Ginoo, “Tama gid ini kabug-at nga silot para sa akon. ");
INSERT INTO hil_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ginatabog mo ako subong sa sini nga duta kag sa imo presensya. Wala na ako sing permanente nga elistaran, gani bisan diin na lang ako makadto. Kag kon may makakita sa akon sigurado gid nga patyon niya ako.” ");
INSERT INTO hil_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Pero nagsiling ang Ginoo kay Cain, “Indi ina matabo sa imo! Kay nagasiling ako nga ang bisan sin-o nga magpatay sa imo, balusan ko sing pito ka pilo.” Gani ginbutangan sang Ginoo sing tanda si Cain para indi siya pagpatyon sang bisan sin-o nga makakita sa iya. ");
INSERT INTO hil_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Dayon nagpalayo si Cain sa Ginoo kag didto nag-estar sa duta sang Nod, sa east sang Eden. ");
INSERT INTO hil_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Karon, naghulid si Cain sa iya asawa. Nagbusong ang iya asawa kag nagbata sing lalaki kag gin-ngalanan nila nga Enoc. Nagtukod si Cain sang isa ka banwa kag gin-ngalanan niya nga Enoc pareho sa ngalan sang iya anak. ");
INSERT INTO hil_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Si Enoc may anak man nga lalaki kag ang iya ngalan si Irad. Si Irad nga ini amay ni Mehuel; si Mehuel amay ni Metushael; kag si Metushael amay ni Lamec. ");
INSERT INTO hil_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Si Lamec may duha ka asawa nga si Ada kag si Zila. ");
INSERT INTO hil_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Si Ada nagbata kay Jabal nga amo ang ginhalinan sadtong mga tawo nga nagaestar sa mga tolda, nga nagaatipan sang mga sapat. ");
INSERT INTO hil_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","May utod si Jabal nga lalaki nga ang ngalan si Jubal, nga amo ang ginhalinan sang tanan nga manugtukar sang arpa kag plawta. ");
INSERT INTO hil_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Si Zila nagbata man sing lalaki nga ang ngalan si Tubal Cain. Si Tubal Cain nga ini nagapanghimo sang tanan nga klase sang galamiton halin sa salsalon kag saway. May utod siya nga babayi nga si Naama. ");
INSERT INTO hil_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Isa sadto ka adlaw, nagsiling si Lamec sa iya duha ka asawa, “Ada kag Zila, nga akon mga asawa, pamati kamo sa akon. Ginpatay ko ang bataon nga lalaki kay ginsakit kag ginpilasan niya ako. ");
INSERT INTO hil_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kon pito ka pilo ang balos sa tawo nga magpatay kay Cain, 77 ka pilo ang balos sa tawo nga magpatay sa akon.” ");
INSERT INTO hil_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Naghulid liwat si Adan kay Eva, kag nagbata si Eva sing lalaki. Nagsiling siya, “Ginhatagan liwat ako sang Dios sing anak nga lalaki bilang ilis kay Abel nga ginpatay ni Cain, gani ngalanan ko siya nga Set.” ");
INSERT INTO hil_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sang ulihi si Set may anak man nga lalaki nga iya gin-ngalanan nga Enosh. Sang panahon ni Enosh, nagsugod ang mga tawo tawag sa ngalan sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Amo ini ang ginsulat nga estorya parte sa pamilya ni Adan. Sang pagtuga sang Dios sa tawo, ginhimo niya siya nga kaanggid sa iya. ");
INSERT INTO hil_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Gintuga niya ang lalaki kag babayi, kag ginpakamaayo niya sila kag gintawag nga “tawo.” ");
INSERT INTO hil_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Sang nagaedad si Adan sing 130 ka tuig, natawo ang iya anak nga kaanggid sa iya. Gin-ngalanan niya siya nga Set. ");
INSERT INTO hil_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Matapos natawo si Set, nagkabuhi pa gid si Adan sing 800 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Napatay siya sa edad nga 930. ");
INSERT INTO hil_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sang nagaedad na si Set sing 105 ka tuig, natawo ang iya anak nga lalaki nga si Enosh. ");
INSERT INTO hil_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Matapos natawo si Enosh, nagkabuhi pa gid si Set sing 807 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Napatay siya sa edad nga 912. ");
INSERT INTO hil_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Sang nagaedad na si Enosh sing 90 ka tuig, natawo ang iya anak nga lalaki nga si Kenan. ");
INSERT INTO hil_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Matapos natawo si Kenan, nagkabuhi pa gid si Enosh sing 815 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Napatay siya sa edad nga 905. ");
INSERT INTO hil_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Sang nagaedad na si Kenan sing 70 ka tuig, natawo ang iya anak nga lalaki nga si Mahalalel. ");
INSERT INTO hil_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Matapos natawo si Mahalalel, nagkabuhi pa gid si Kenan sing 840 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Napatay siya sa edad nga 910. ");
INSERT INTO hil_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Sang nagaedad na si Mahalalel sing 65 ka tuig, natawo ang iya anak nga lalaki nga si Jared. ");
INSERT INTO hil_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Matapos natawo si Jared, nagkabuhi pa gid si Mahalalel sing 830 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Napatay siya sa edad nga 895. ");
INSERT INTO hil_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Sang nagaedad na si Jared sing 162 ka tuig, natawo ang iya anak nga lalaki nga si Enoc. ");
INSERT INTO hil_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Matapos natawo si Enoc, nagkabuhi pa gid si Jared sing 800 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Napatay siya sa edad nga 962. ");
INSERT INTO hil_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Sang nagaedad na si Enoc sing 65 ka tuig, natawo ang iya anak nga lalaki nga si Metusela. ");
INSERT INTO hil_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","24","Matapos natawo si Metusela, nagkabuhi pa gid si Enoc sing 300 ka tuig kag nadugangan pa gid ang iya kabataan. Sang sina nga mga tinuig, malapit gid ang relasyon ni Enoc sa Dios, gani sang nagaedad na siya sing 365 ka tuig nadula siya, kay ginkuha siya sang Dios. ");
INSERT INTO hil_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Sang nagaedad na si Metusela sing 187 ka tuig, natawo ang iya anak nga lalaki nga si Lamec. ");
INSERT INTO hil_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Matapos natawo si Lamec, nagkabuhi pa gid si Metusela sing 782 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Napatay siya sa edad nga 969. ");
INSERT INTO hil_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Sang nagaedad na si Lamec sing 182 ka tuig, natawo ang isa niya ka anak nga lalaki. ");
INSERT INTO hil_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Nagsiling siya, “Ining akon anak makabulig sa aton nga pagpangabudlay sa duta nga ginpakamalaot sang Ginoo, gani ngalanan ko siya nga Noe.” ");
INSERT INTO hil_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Matapos natawo si Noe, nagkabuhi pa gid si Lamec sing 595 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Napatay siya sa edad nga 777. ");
INSERT INTO hil_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Halin sa edad ni Noe nga 500, natawo ang iya mga anak nga lalaki nga sila ni Shem, Ham, kag Jafet. ");
INSERT INTO hil_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Sang ulihi nagdamo ang mga tawo sa kalibutan, kag nagkalatawo man ang ila mga kabataan nga babayi. ");
INSERT INTO hil_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Nakita sang mga anak sang Dios nga ang mga babayi guwapa. Gani ginpangasawa nila ang bisan sin-o nga ila naluyagan. ");
INSERT INTO hil_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Karon nagsiling ang Ginoo, “Indi ko pagtugutan nga mabuhi ang tawo sing malawig tungod kay tawo lang sila. Gani sugod subong ang tawo magakabuhi nga indi magsobra sa 120 ka tuig.” ");
INSERT INTO hil_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Sang sadto nga tiyempo, kag bisan sang ulihi, may mga Nefilim sa kalibutan nga mga kaliwat sang mga anak sang Dios nga nagpakigrelasyon sa mga babayi nga anak sang mga tawo. Ini sila mga gamhanan kag bantog nga mga tawo sang una nga tiyempo. ");
INSERT INTO hil_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Sang nakita sang Ginoo nga ang ginahimo sang mga tawo sa kalibutan puro na lang kalautan, kag ang ila ginahunahuna permi malain, ");
INSERT INTO hil_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","naghinulsol siya nga ginhimo pa niya ang tawo sa kalibutan. Dako gid ang iya kasubo, ");
INSERT INTO hil_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","gani nagsiling siya, “Laglagon ko ang tanan nga tawo nga akon gintuga. Kag laglagon ko man ang tanan nga sapat sa duta pati ang mga sapat nga nagalupad, kay nagahinulsol ako nga ginhimo ko sila.” ");
INSERT INTO hil_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pero may isa ka tawo nga nakapalipay sa Ginoo. Siya amo si Noe. ");
INSERT INTO hil_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Amo ini ang estorya parte sa pamilya ni Noe. Si Noe matarong nga tawo. Siya lang ang nagkabuhi nga matarong sa iya nga tiyempo, kag malapit ang iya relasyon sa Dios. ");
INSERT INTO hil_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","May tatlo siya ka anak nga lalaki nga sila ni Shem, Ham, kag Jafet. ");
INSERT INTO hil_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Sa atubangan sang Dios, malain gid ang mga tawo kag ang ila kalainan naglapta sa kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nakita sang Dios nga malain gid ang mga tawo sa kalibutan tungod kay ang ila ginahimo puro lang kalainan. ");
INSERT INTO hil_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Gani nagsiling siya kay Noe, “Laglagon ko ang tanan nga tawo. Kay tungod sa ila, naglapta ang kalautan sa kalibutan. Laglagon ko sila kaupod sang kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Gani ikaw Noe, maghimo ka sang barko halin sa maayo nga kahoy, kag himuan mo ini sang mga kuwarto. Dayon lamhitan mo sang alkitran sa sulod kag sa guwa sang barko. ");
INSERT INTO hil_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Himua nga ang iya kalabaon 450 feet, ang iya kasangkaron 75 feet, kag ang iya kataason 45 feet. ");
INSERT INTO hil_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Atupan mo ang barko, kag butangan mo sang antad nga 18 inches ang dingding kag ang atop. Himua nga ang barko may tatlo ka panalgan. Butangi man sang puwertahan sa iya kilid. ");
INSERT INTO hil_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kay pabahaon ko ang kalibutan para malaglag ang tanan nga nagakabuhi. Mapatay ang tanan nga ara sa kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Pero magahimo ako sang kasugtanan sa imo. Karon, magsulod ka sa barko upod ang imo asawa, mga anak, kag mga umagad. ");
INSERT INTO hil_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Magpasulod ka man sang isa ka pares, lalaki kag babayi, sa kada klase sang mga sapat para mabuhi sila upod sa imo. ");
INSERT INTO hil_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Duha sa kada klase sang tanan nga sapat ang magapalapit sa imo para mabuhi—ang mga sapat nga nagalupad, ang nagalakat, kag ang nagakamang. ");
INSERT INTO hil_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Magdala ka man sang tanan nga klase sang pagkaon para sa inyo kag para man sa mga sapat.” ");
INSERT INTO hil_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Gintuman ni Noe ang tanan nga ginsugo sang Dios sa iya. ");
INSERT INTO hil_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Nagsiling ang Ginoo kay Noe, “Magsulod ka sa barko upod sang imo bilog nga pamilya. Tungod kay sa tanan nga tawo sa sini nga henerasyon ikaw lang ang nakita ko nga matarong. ");
INSERT INTO hil_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Magdala ka sang pito ka pares sa kada klase sang matinlo nga sapat, pero isa lang ka pares sa kada klase sang indi matinlo nga sapat. ");
INSERT INTO hil_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Kag magdala ka man sang pito ka pares sa kada klase sang sapat nga nagalupad. Himuon mo ini para mabuhi sila sa kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kay pagkatapos sang pito ka adlaw halin subong, paulanan ko ang bilog nga kalibutan sa sulod sang 40 ka adlaw kag 40 ka gab-i, para magkalamatay ang tanan ko nga ginhimo.” ");
INSERT INTO hil_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Gintuman ni Noe ang tanan nga ginsugo sang Ginoo sa iya. ");
INSERT INTO hil_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nagaedad si Noe sing 600 ka tuig sang nag-abot ang grabe gid nga baha sa kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nagsulod siya sa barko upod sang iya asawa, mga anak, kag mga umagad para indi sila magkalamatay sa baha. ");
INSERT INTO hil_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Suno sa ginsugo sang Dios kay Noe, ginpasulod niya sa barko ang kada pares sang tanan nga klase sang sapat nga matinlo kag indi matinlo nga nagpalapit sa iya. ");
INSERT INTO hil_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Kag pagkaligad sang pito ka adlaw, nagbaha sa kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nagaedad sadto si Noe sing 600 ka tuig. Kag sang ika-17 nga adlaw sang ikaduha nga bulan, nag-ulan sing puwerte gid kabaskog kag nag-awas ang tanan nga tuburan. ");
INSERT INTO hil_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Kag nag-inulan sa kalibutan sa sulod sang 40 ka adlaw kag 40 ka gab-i. ");
INSERT INTO hil_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Sang adlaw mismo nga nag-umpisa ang pag-ulan, nagsulod sa barko si Noe kag ang iya asawa kag ang tatlo nila ka anak nga sila ni Shem, Ham, kag Jafet kaupod sang ila mga asawa. ");
INSERT INTO hil_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Kaupod man nila ang tanan nga klase sang sapat: ang nagalakat, ang nagakamang, kag ang nagalupad. ");
INSERT INTO hil_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Suno sa ginsugo sang Dios kay Noe, ginpasulod niya sa barko ang kada pares sang tanan nga klase sang sapat nga nagpalapit sa iya. Pagkatapos ginsira sang Ginoo ang barko. ");
INSERT INTO hil_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Sige ang inulan sa kalibutan sa sulod sang 40 ka adlaw. Nagtaas ang tubig hasta nga naglutaw ang barko. ");
INSERT INTO hil_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Nagtaas pa gid ang tubig hasta nga nalapawan ang tanan nga mataas nga mga bukid, ");
INSERT INTO hil_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","kag hasta nga nagtaas pa gid ang tubig sing mga sobra 20 feet halin sa putokputokan sang pinakamataas nga bukid. ");
INSERT INTO hil_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Gani nagkalamatay ang tanan nga may kabuhi—ang mga sapat nga nagalupad, nagalakat, nagakamang, kag ang tanan nga tawo. ");
INSERT INTO hil_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nagkalamatay ang tanan nga nagakabuhi sa duta. ");
INSERT INTO hil_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ginlaglag ang tanan nga tawo kag ang tanan nga sapat sa kalibutan. Si Noe lang kag ang iya mga kaupod sa sulod sang barko ang wala mapatay. ");
INSERT INTO hil_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Nagbaha ang kalibutan sa sulod sang 150 ka adlaw. ");
INSERT INTO hil_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Wala pagkalimti sang Dios si Noe kag ang iya mga kaupod nga mga sapat sa sulod sang barko. Gani ginpahuyop niya ang hangin sa kalibutan kag nag-amat-amat hubas ang tubig. ");
INSERT INTO hil_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Gintakpan niya ang mga tuburan kag ginpauntat ang ulan. ");
INSERT INTO hil_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Sige hubas ang tubig sa sulod sang 150 ka adlaw. ");
INSERT INTO hil_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Kag sang ika-17 nga adlaw sang ikapito nga bulan, nabara ang barko sa kabukiran sang Ararat. ");
INSERT INTO hil_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Padayon nga naghubas ang tubig. Kag sang nahauna nga adlaw sang ika-10 nga bulan, makita na ang putokputokan sang mga bukid. ");
INSERT INTO hil_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Pagligad sang 40 pa gid ka adlaw, ginbuksan ni Noe ang bintana sang barko ");
INSERT INTO hil_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","kag ginbuy-an paguwa ang isa ka uwak. Kag ang ini nga uwak sige lang ang iya lupad-lupad pakadto-pabalik hasta sa paghubas sang tubig. ");
INSERT INTO hil_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ginbuy-an man ni Noe ang isa ka pating para mahibaluan niya kon naghubas na ang tubig, ");
INSERT INTO hil_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","pero wala sing may mahapunan ang pating tungod kay natabunan pa sang tubig ang bilog nga kalibutan. Gani nagbalik na lang ang pating kay Noe sa barko. Ginpahapon ni Noe ang pating sa iya kamot kag ginpasulod sa barko. ");
INSERT INTO hil_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ginpaligad anay ni Noe ang pito ka adlaw kag ginbuy-an niya liwat ang pating. ");
INSERT INTO hil_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Nagbalik ang pating sang sirom na nga may lab-as nga dahon sang olibo sa iya tuktok. Gani nahibaluan ni Noe nga naghubas na ang tubig. ");
INSERT INTO hil_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ginpaligad liwat ni Noe ang pito pa gid ka adlaw kag ginbuy-an niya liwat ang pating, pero wala na ini nagbalik. ");
INSERT INTO hil_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nagaedad na si Noe sing 601 ka tuig. Kag sang nahauna nga adlaw sang nahauna nga bulan, naghubas ang tubig. Ginkuha ni Noe ang tabon sa may barko kag nakita niya nga mala na ang duta. ");
INSERT INTO hil_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Sang ika-27 nga adlaw sang ikaduha nga bulan, mala na gid ang duta sa bilog nga kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Nagsiling dayon ang Dios kay Noe, ");
INSERT INTO hil_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Guwa na kamo tanan sa barko. ");
INSERT INTO hil_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kag paguwaa man ang tanan nga sapat para magmuad sila kag magdamo, kag maglapta sa kalibutan.” ");
INSERT INTO hil_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Gani nagguwa si Noe upod ang iya asawa, mga anak nga lalaki kag mga umagad. ");
INSERT INTO hil_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nagguwa man ang tanan nga sapat: ang nagalakat, ang nagalupad, kag ang nagakamang. Nagainupod sila suno sa ila nga klase. ");
INSERT INTO hil_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Naghimo si Noe sang halaran para sa Ginoo. Dayon nagkuha siya sang isa sa kada klase sang mga sapat nga matinlo pati man sa kada klase sang mga pispis nga matinlo kag ginsunog niya ini sa halaran bilang halad sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Sang napanimahuan sang Ginoo ang kahamot sini, nagsiling siya sa iya kaugalingon, “Indi ko na gid pagpakamalauton liwat ang duta tungod sang ginahimo sang tawo. Bisan pa nga nahibaluan ko nga makasasala ang tawo halin sang bata pa siya, indi ko na gid paglaglagon liwat ang tanan nga nagakabuhi pareho sang akon ginhimo sadto. ");
INSERT INTO hil_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Samtang nagapadayon ang kalibutan, may panahon sang tigtalanom kag may tig-alani, may tigtulugnaw kag may tig-ilinit, may tingulan kag may tingadlaw, kag may adlaw kag may gab-i.” ");
INSERT INTO hil_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Karon, ginbendisyunan sang Dios si Noe kag ang iya mga anak kag ginsilingan, “Magpamata kamo para magdamo kamo kag maglapta sa kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mahadlok sa inyo ang tanan nga sapat: ang nagalakat, ang nagalupad, ang nagakamang, kag ang nagalangoy. Kamo ang magagahom sa ila tanan. ");
INSERT INTO hil_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ginahatag ko ini nga mga sapat sa inyo bilang pagkaon, subong nga ginhatag ko sa inyo ang mga tanom bilang pagkaon. ");
INSERT INTO hil_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Pero indi gid ninyo pagkaunon ang sapat nga sang pagpatay ang dugo wala makaguwa, tungod kay ang dugo simbolo sang kabuhi. ");
INSERT INTO hil_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Pagasukton ko gid ang bisan sin-o nga magpatay sa inyo, bisan pa ang mga sapat. Pagasukton ko ang bisan sin-o nga magpatay sa iya isigkatawo. ");
INSERT INTO hil_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ang bisan sin-o nga magpatay sa iya isigkatawo dapat pagapatyon man sang iya isigkatawo. Kay ang tawo ginhimo sang Dios nga kaanggid sa iya. ");
INSERT INTO hil_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Karon, magpamata kamo para magdamo kamo kag maglapta sa kalibutan.” ");
INSERT INTO hil_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Nagsiling pa gid ang Dios kay Noe kag sa iya mga anak, ");
INSERT INTO hil_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","11","“Amo ini ang akon kasugtanan sa inyo kag sa inyo mga kaliwat, kag sa tanan nga nagakabuhi sa kalibutan—ang tanan nga sapat nga nangin kaupod ninyo sa barko: Indi ko na gid paglaglagon liwat ang tanan nga nagakabuhi paagi sa grabe gid nga baha. Kag wala na gid sing baha nga pareho sini nga matabo pa sa paglaglag sang kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Kag bilang tanda sang akon kasugtanan sa inyo kag sa tanan nga sapat, kag sa inyo mga kaliwat sa palaabuton, ibutang ko ang akon balangaw sa mga panganod. ");
INSERT INTO hil_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kon paguwaon ko ang mga panganod kag magpakita ang balangaw, ");
INSERT INTO hil_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","dumdumon ko dayon ang akon kasugtanan sa inyo kag sa tanan nga klase sang sapat, nga indi na gid magbaha liwat sa paglaglag sang tanan nga nagakabuhi. ");
INSERT INTO hil_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kon magguwa ang balangaw sa mga panganod, dumdumon ko dayon ang akon wala sing katapusan nga kasugtanan sa tanan nga klase sang sapat sa kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ang balangaw amo ang tanda sang akon kasugtanan sa tanan nga nagakabuhi sa kalibutan.” ");
INSERT INTO hil_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Amo ini ang mga anak ni Noe nga kaupod niya sa barko: si Shem, si Ham, kag si Jafet. (Si Ham amo ang amay ni Canaan.) ");
INSERT INTO hil_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ini sila nga tatlo amo ang ginhalinan sang tanan nga tawo sa kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Si Noe isa ka mangunguma kag siya amo ang una nga nagtanom sang ubas. ");
INSERT INTO hil_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Sang isa ka tion, nag-inom siya sang bino kag nahubog siya. Natulugan siya nga hublas sa sulod sang iya tolda. ");
INSERT INTO hil_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Karon, si Ham nga amay ni Canaan nagsulod sa tolda, kag nakita niya nga hublas ang iya amay. Gani nagguwa siya kag ginsugiran niya ang duha niya ka utod. ");
INSERT INTO hil_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Nagkuha si Shem kag si Jafet sang panapton kag ginsablay nila sa ila abaga, dayon naglakat sila nga nagaisol pasulod sa tolda kag gintabunan nila ang ila amay. Wala gid sila nagbalikid tungod kay indi nila gusto nga makita ang pagkahublas sang ila amay. ");
INSERT INTO hil_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Sang naumpawan na si Noe sa iya kahulugbon, kag pagkahibalo niya kon ano ang ginhimo sang iya kamanghuran nga anak, ");
INSERT INTO hil_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","nagsiling siya: “Pakamalauton ka Canaan! Mangin kubos ka nga ulipon sang imo mga utod.” ");
INSERT INTO hil_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Kag nagsiling man siya, “Dalayawon ang Ginoo, ang Dios ni Shem. Kabay pa nga mangin ulipon ni Shem si Canaan. ");
INSERT INTO hil_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Kabay pa nga palaparon sang Dios ang kadutaan ni Jafet, kag mangin maayo ang pag-inupdanay sang iya mga kaliwat kag sang mga kaliwat ni Shem. Kag kabay pa nga mangin ulipon man ni Jafet si Canaan.” ");
INSERT INTO hil_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nagkabuhi pa gid si Noe sing 350 ka tuig pagkatapos sang grabe gid nga baha. ");
INSERT INTO hil_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Napatay siya sa edad nga 950. ");
INSERT INTO hil_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Amo ini ang estorya parte sa mga pamilya sang mga anak ni Noe nga sila ni Shem, Ham, kag Jafet. Nagkalatawo ang ila mga anak pagkatapos sang grabe gid nga baha. ");
INSERT INTO hil_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ang mga anak nga lalaki ni Jafet amo sila ni Gomer, Magog, Madai, Javan, Tubal, Meshec, kag Tiras. ");
INSERT INTO hil_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ang mga anak ni Gomer amo sila ni Ashkenaz, Rifat, kag Togarma. ");
INSERT INTO hil_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ang mga anak ni Javan amo sila ni Elisha, Tarshish, Kitim, kag Dodanim. ");
INSERT INTO hil_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Sila amo ang ginhalinan sang mga tawo nga nagaestar sa mga lugar nga malapit sa dagat kag sa mga isla. Ang kada pamilya nila nagaestar sa ila kaugalingon nga lugar nga sakop sang ila nasyon, kag may kaugalingon sila nga lingguahe. ");
INSERT INTO hil_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ang mga anak nga lalaki ni Ham amo sila ni Cush, Mizraim, Put, kag Canaan. ");
INSERT INTO hil_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ang mga anak nga lalaki ni Cush amo sila ni Seba, Havila, Sabta, Raama, kag Sabteca. Ang mga anak ni Raama amo si Sheba kag si Dedan. ");
INSERT INTO hil_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","May isa pa ka anak si Cush nga ang iya ngalan si Nimrod. Si Nimrod nga ini nangin gamhanan nga tawo sa kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Maayo gid siya nga mangangayam sa atubangan sang Ginoo, gani may hulubaton nga nagasiling, “Pareho ka kay Nimrod nga maayo gid nga mangangayam sa atubangan sang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ang una nga ginharian nga gin-gamhan ni Nimrod amo ang Babilonia, Erec, Acad, kag Calne. Ini sila tanan sakop sang Shinar. ");
INSERT INTO hil_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Halin sa sadto nga mga lugar nagkadto siya sa Assyria kag gintukod niya ang Nineve, Rehobot Ir, Cala, ");
INSERT INTO hil_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","kag Resen nga ara sa tunga-tunga sang Nineve kag sang Cala nga isa ka bantog nga banwa. ");
INSERT INTO hil_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Si Mizraim amo ang ginhalinan sang mga Ludhanon, Anamnon, Lehabnon, Naftunon, ");
INSERT INTO hil_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusnon, Caslunon, kag sang mga Caftornon nga amo ang ginhalinan sang mga Filistinhon. ");
INSERT INTO hil_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Si Canaan amo ang amay ni Sidon kag ni Het. Si Sidon amo ang magulang. ");
INSERT INTO hil_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Si Canaan amo man ang ginhalinan sang mga Jebusnon, Amornon, Girgashnon, ");
INSERT INTO hil_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivhanon, Arkhanon, Sinhanon, ");
INSERT INTO hil_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvadnon, Zemarnon, kag sang mga Hamatnon. Sang ulihi naglapta ang mga kaliwat ni Canaan. ");
INSERT INTO hil_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ang border sang ila kadutaan nagahalin sa Sidon pakadto sa Gerar hasta sa Gaza, kag nagalambot sa Sodom, Gomora, Adma, Zeboyim, hasta sa Lasha. ");
INSERT INTO hil_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Amo ini sila ang mga kaliwat ni Ham. Ang kada pamilya nila nagaestar sa ila kaugalingon nga lugar nga sakop sang ila nasyon, kag may kaugalingon sila nga lingguahe. ");
INSERT INTO hil_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Si Shem nga magulang ni Jafet amo ang ginhalinan sang tanan nga Hebreo. ");
INSERT INTO hil_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ang iya mga anak nga lalaki amo sila ni Elam, Ashur, Arfaxad, Lud, kag Aram. ");
INSERT INTO hil_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ang mga anak ni Aram amo sila ni Uz, Hul, Geter, kag Meshec. ");
INSERT INTO hil_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Si Arfaxad amay ni Shela. Si Shela amay ni Eber. ");
INSERT INTO hil_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","May duha ka anak nga lalaki si Eber: ang isa gin-ngalanan nga Peleg, tungod kay sang iya panahon ang mga tawo sa kalibutan nagabinahin-bahin; ang ngalan sang iya utod amo si Joktan. ");
INSERT INTO hil_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Si Joktan amo ang amay nila ni Almodad, Shelef, Hazarmavet, Jera, ");
INSERT INTO hil_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO hil_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO hil_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, kag Jobab. Sila tanan amo ang mga anak ni Joktan. ");
INSERT INTO hil_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ang kadutaan nga ginaestaran nila nagahalin sa Mesha kag nagapakadto sa Sefar, sa kabukiran sa east. ");
INSERT INTO hil_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Amo ini sila ang mga kaliwat ni Shem. Ang kada pamilya nila nagaestar sa ila kaugalingon nga lugar nga sakop sang ila nasyon, kag may kaugalingon sila nga lingguahe. ");
INSERT INTO hil_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Amo ato tanan ang mga kaliwat sang mga anak ni Noe. Ini sila ara sa nagkalain-lain nga nasyon. Tungod sa ila, natukod ang mga nasyon sa bilog nga kalibutan pagkatapos sang grabe gid nga baha. ");
INSERT INTO hil_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Sang una isa lang ka lingguahe ang ginagamit sang tanan nga tawo sa bilog nga kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Samtang nagasaylo ang mga tawo sang elistaran pa-east, nakaabot sila sa isa ka patag sa duta sang Shinar, kag didto sila nag-estar. ");
INSERT INTO hil_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Karon, nagsiling ang mga tawo, “Matukod kita sang isa ka siyudad nga may tore nga lambot sa kalangitan, para mangin bantog kita kag para indi kita maglapta sa bilog nga kalibutan.” Gani naghimo sila sang mga tisa, kag ginpainitan nila ini sing maayo para magtig-a gid. Tisa ang ila gin-gamit imbes bato. Kag aspalto ang ila gin-gamit bilang semento. ");
INSERT INTO hil_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Karon, nagpasilabot ang Ginoo sa pagtukod sang mga tawo sang siyudad kag tore. ");
INSERT INTO hil_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Siling niya, “Ini nga mga tawo nagaugyon kag may isa lang sila ka lingguahe. Kag ining ila ginahimo umpisa pa lang sang ila pa gid nga pagahimuon. Sa indi madugay himuon nila ang bisan ano nga gusto nila himuon. ");
INSERT INTO hil_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Gani dali, magpasilabot kita. Lain-lainon ta ang ila lingguahe para indi sila mag-intiendihanay.” ");
INSERT INTO hil_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Gani ginpalapta sila sang Ginoo sa bilog nga kalibutan kag nauntat ang ila pagtukod sang siyudad. ");
INSERT INTO hil_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ini nga siyudad gintawag nga Babilonia kay didto ginpalain-lain sang Ginoo ang lingguahe sang mga tawo, kag halin didto ginpalapta niya sila sa bilog nga kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Amo ini ang estorya parte sa pamilya ni Shem. Duha ka tuig pagkatapos sang grabe gid nga baha, sang nagaedad si Shem sing 100 ka tuig, natawo ang iya anak nga lalaki nga si Arfaxad. ");
INSERT INTO hil_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Matapos natawo si Arfaxad, nagkabuhi pa gid si Shem sing 500 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Sang nagaedad na si Arfaxad sing 35 ka tuig, natawo ang iya anak nga lalaki nga si Shela. ");
INSERT INTO hil_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Matapos natawo si Shela, nagkabuhi pa gid si Arfaxad sing 403 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sang nagaedad na si Shela sing 30 ka tuig, natawo ang iya anak nga lalaki nga si Eber. ");
INSERT INTO hil_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Matapos natawo si Eber, nagkabuhi pa gid si Shela sing 403 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Sang nagaedad na si Eber sing 34 ka tuig, natawo ang iya anak nga lalaki nga si Peleg. ");
INSERT INTO hil_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Matapos natawo si Peleg, nagkabuhi pa gid si Eber sing 430 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Sang nagaedad na si Peleg sing 30 ka tuig, natawo ang iya anak nga lalaki nga si Reu. ");
INSERT INTO hil_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Matapos natawo si Reu, nagkabuhi pa gid si Peleg sing 209 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Sang nagaedad na si Reu sing 32 ka tuig, natawo ang iya anak nga lalaki nga si Serug. ");
INSERT INTO hil_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Matapos natawo si Serug, nagkabuhi pa gid si Reu sing 207 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sang nagaedad na si Serug sing 30 ka tuig, natawo ang iya anak nga lalaki nga si Nahor. ");
INSERT INTO hil_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Matapos natawo si Nahor, nagkabuhi pa gid si Serug sing 200 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Sang nagaedad na si Nahor sing 29 ka tuig, natawo ang iya anak nga lalaki nga si Tera. ");
INSERT INTO hil_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Matapos natawo si Tera, nagkabuhi pa gid si Nahor sing 119 ka tuig kag nadugangan pa gid ang iya kabataan. ");
INSERT INTO hil_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Halin sa edad ni Tera nga 70, natawo ang iya mga anak nga lalaki nga sila ni Abram, Nahor, kag Haran. ");
INSERT INTO hil_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Amo ini ang estorya parte sa pamilya ni Tera. Si Tera amay nila ni Abram, Nahor, kag Haran. Si Haran amay ni Lot. ");
INSERT INTO hil_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Napatay si Haran didto sa Ur nga sakop sang mga Kaldeanhon, sa lugar mismo nga sa diin natawo siya. Napatay siya samtang buhi pa ang iya amay nga si Tera. ");
INSERT INTO hil_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Nagpangasawa si Abram kay Sarai, kag si Nahor nagpangasawa kay Milca. Ang amay ni Milca kag sang iya utod nga si Isca amo si Haran. ");
INSERT INTO hil_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Si Sarai indi makabata kay baw-as siya. ");
INSERT INTO hil_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Naghalin si Tera sa Ur nga sakop sang mga Kaldeanhon. Kaupod niya ang iya anak nga si Abram, ang iya umagad nga si Sarai, kag ang iya apo nga si Lot nga anak ni Haran. Pakadto sila kuntani sa Canaan, pero pag-abot nila sa Haran didto na lang sila nag-estar. ");
INSERT INTO hil_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Didto napatay si Tera sa edad nga 205. ");
INSERT INTO hil_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Karon, nagsiling ang Ginoo kay Abram, “Bayai ang imo nasyon, mga paryente, kag ang pamilya sang imo amay, kag magkadto ka sa lugar nga akon itudlo sa imo. ");
INSERT INTO hil_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Himuon ko ang imo mga kaliwat nga isa ka bantog nga nasyon. Pakamaayuhon ko ikaw kag mangin bantog ang imo ngalan. Paagi sa imo, madamo ang makabaton sang pagpakamaayo. ");
INSERT INTO hil_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Pakamaayuhon ko ang nagapakamaayo sa imo. Pero pakamalauton ko ang nagapakamalaot sa imo. Pakamaayuhon ko ang tanan nga katawhan sa kalibutan paagi sa imo.” ");
INSERT INTO hil_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Gani naghalin si Abram sa Haran kag nagkadto sa Canaan, suno sa ginsiling sang Ginoo sa iya. Nagaedad sadto si Abram sing 75 ka tuig. Nag-upod sa iya ang iya hinablos nga si Lot. Gindala man niya ang iya asawa nga si Sarai kag ang tanan nila nga mga pagkabutang kag mga tinawo nga natipon nila sa Haran. Pag-abot nila sa Canaan, ");
INSERT INTO hil_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","nagpadayon sila hasta nga nakalambot sila sa dako nga kahoy sang More didto sa Shekem. (Sadto nga panahon didto pa ang mga Canaanhon.) ");
INSERT INTO hil_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Dayon nagpakita ang Ginoo kay Abram kag nagsiling sa iya, “Amo ini nga duta ang ihatag ko sa imo mga kaliwat.” Gani naghimo si Abram sang halaran para sa Ginoo nga nagpakita sa iya. ");
INSERT INTO hil_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Halin didto, nagsaylo sila sa bukid sa east sang Betel, kag didto sila nagpatindog sang tolda, sa tunga-tunga sang Betel kag Ai. Ang Betel sa west kag ang Ai sa east. Naghimo man didto si Abram sang halaran kag nagsimba sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Sang ulihi nagsaylo naman sila. Sige ang ila panglakaton pakadto sa Negev. ");
INSERT INTO hil_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Pero may puwerte nga gutom sa Canaan, gani nagderetso si Abram sa Egypt para didto lang anay mag-estar. ");
INSERT INTO hil_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Sang manug-abot na sila sa Egypt, nagsiling si Abram sa iya asawa, “Sarai, guwapa ka nga babayi. ");
INSERT INTO hil_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Kon makita ka sang mga Egyptohanon masiling sila nga asawa ko ikaw, gani patyon nila ako kag ikaw ya indi. ");
INSERT INTO hil_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Mas maayo pa siguro nga silingon mo sila nga mag-utod kita para indi nila ako pagpatyon kag para maayo ang ila pagtratar sa akon tungod sa imo.” ");
INSERT INTO hil_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Gani pag-abot nila sa Egypt, nakita sang mga Egyptohanon nga guwapa gid si Sarai. ");
INSERT INTO hil_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kag sang makita siya sang mga opisyal sang hari, ginsugiran nila ang hari kon daw ano siya kaguwapa. Gani gindala si Sarai didto sa palasyo. ");
INSERT INTO hil_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Tungod kay Sarai, maayo gid ang pagtratar sang hari kay Abram kag ginhatagan pa siya sang mga karnero, kanding, baka, lalaki kag babayi nga mga donkey, camel, kag mga ulipon nga lalaki kag babayi. ");
INSERT INTO hil_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Pero ginhatagan sang Ginoo sang makahalalit nga balatian ang hari kag ang mga sinakpan niya sa palasyo tungod kay Sarai. ");
INSERT INTO hil_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Gani, ginpatawag niya si Abram kag ginpamangkot, “Ano bala ining ginhimo mo sa akon? Ngaa wala ka magsugid nga asawa mo gali siya? ");
INSERT INTO hil_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ngaa nagsiling ka nga mag-utod kamo? Ti kundi ginkuha ko siya nga mangin akon asawa. Karon, ari ang imo asawa, kuhaa siya kag maglakat kamo!” ");
INSERT INTO hil_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Dayon nagsugo ang hari sa iya mga tinawo nga pahalinon na sila. Gani gindala nila si Abram paguwa sa sadto nga lugar kag ginpahalin upod ang iya asawa kag dala ang tanan niya nga pagkabutang. ");
INSERT INTO hil_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Halin sa Egypt, nagkadto si Abram sa Negev upod ang iya asawa kag dala ang tanan niya nga pagkabutang, kag nag-upod man sa ila si Lot. ");
INSERT INTO hil_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Manggaranon na kaayo si Abram; madamo na ang iya kasapatan, pilak, kag bulawan. ");
INSERT INTO hil_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Halin sa Negev, nagsaylo-saylo sila hasta nga nakabalik sila sa lugar nga ila anay ginpatindugan sang tolda. Ini nga lugar ara sa tunga-tunga sang Betel kag Ai. ");
INSERT INTO hil_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Diri man sila una nga nagpatindog sang halaran. Sa liwat nagsimba didto si Abraham sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Si Lot nga nagaupod man kay Abram kon diin siya magkadto may iya man nga mga kasapatan kag mga tolda. ");
INSERT INTO hil_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Kag tungod kay madamo na ang ila kasapatan kag iban pa nga mga pagkabutang, indi sila puwede nga magtingob estar sa isa ka lugar. Ang palahalban indi makaigo sa ila. ");
INSERT INTO hil_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Tungod sini, nag-ilinaway ang mga manugbantay sang ila mga kasapatan. (Sadto nga panahon ang mga Canaanhon kag mga Periznon nagaestar pa sa sadto nga duta.) ");
INSERT INTO hil_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Gani nagsiling si Abram kay Lot, “Kita kag ang aton mga tinawo indi dapat mag-ilinaway, kay magparyentihanay kita. ");
INSERT INTO hil_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ang maayo pa, mabulagay na lang kita tungod madamo pa man sang lugar nga puwede sayluhan. Ikaw ang magpili kon diin nga parte sang duta ang imo gusto. Kon mapawala ka, mapatuo ako; kon mapatuo ka, mapawala ako.” ");
INSERT INTO hil_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Nagtan-aw si Lot sa palibot kag nakita niya nga bugana sang tubig ang Kapatagan sang Jordan hasta sa Zoar, pareho sang katamnan sang Ginoo kag sang duta sang Egypt. (Ini sang wala pa ginlaglag sang Ginoo ang Sodom kag Gomora.) ");
INSERT INTO hil_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Gani ginpili ni Lot ang bilog nga Kapatagan sang Jordan sa east. Sa amo nga paagi nagbulagay si Lot kag si Abram. ");
INSERT INTO hil_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Si Abram nagpabilin sa Canaan samtang si Lot iya didto sa mga banwa sang kapatagan. Nagpatindog si Lot sang iya mga tolda malapit sa Sodom. ");
INSERT INTO hil_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ang mga tawo sa Sodom tama gid ka makasasala. Puwerte gid ang ila pagpakasala kontra sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Sang nakahalin na si Lot, nagsiling ang Ginoo kay Abram, “Halin sa imo ginatindugan tan-awa sing maayo ang imo palibot. ");
INSERT INTO hil_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ang tanan nga duta nga malambot sang imo panulok ihatag ko sa imo kag sa imo mga kaliwat, kag mangin inyo ina hasta san-o. ");
INSERT INTO hil_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Hatagan ko ikaw sing madamo nga kaliwat nga ang ila kadamuon pareho sa yab-ok. Ang yab-ok indi maisip, gani ang imo mga kaliwat indi man maisip. ");
INSERT INTO hil_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Lakat ka kag libuta ang bilog nga duta kay ihatag ko ina tanan sa imo.” ");
INSERT INTO hil_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Gani ginhalin ni Abram ang iya mga tolda, kag didto siya nag-estar malapit sa dalagko nga mga kahoy ni Mamre didto sa Hebron, kag naghimo siya didto sang halaran para sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Sang sadto nga tiyempo, si Haring Amrafel sang Shinar, si Haring Arioc sang Elasar, si Haring Kedorlaomer sang Elam, kag si Haring Tidal sang Goyim ");
INSERT INTO hil_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","nagpakig-away kontra kay Haring Bera sang Sodom, Haring Birsha sang Gomora, Haring Shinab sang Adma, Haring Shemeber sang Zeboyim, kag sa hari sang Bela nga ginatawag man nga Zoar. ");
INSERT INTO hil_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Nagtipon ining lima ka hari upod ang ila mga soldado didto sa Kapatagan sang Sidim nga ginatawag subong nga Patay nga Dagat. ");
INSERT INTO hil_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ini nga mga hari ginsakop anay ni Kedorlaomer sa sulod sang 12 ka tuig, pero sang ika-13 nga tuig nagrebelde sila kontra sa iya. ");
INSERT INTO hil_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kag sang ika-14 nga tuig, gindaog ni Kedorlaomer kag sang iya mga kadampig nga mga hari ang mga Refaimnon sa Ashterot Karnaim, ang mga Zuzhanon sa Ham, ang mga Emhanon sa kapatagan sang Kiriataim, ");
INSERT INTO hil_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","kag ang mga Horhanon sa kabukiran sang Seir hasta sa El Paran nga malapit sa kamingawan. ");
INSERT INTO hil_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Halin didto, nagbalik sila kag nakaabot sa En Mishpat nga ginatawag subong nga Kadesh. Kag gin-agaw nila ang tanan nga kadutaan sang mga Amaleknon kag sang mga Amornon nga nagaestar sa Hazazon Tamar. ");
INSERT INTO hil_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Karon, gintipon sang mga hari sang Sodom, Gomora, Adma, Zeboyim, kag Bela ang ila mga soldado didto sa Kapatagan sang Sidim ");
INSERT INTO hil_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","kag nagpakig-away sila kontra kay Haring Kedorlaomer sang Elam, Haring Tidal sang Goyim, Haring Amrafel sang Shinar, kag kay Haring Arioc sang Elasar—lima ka hari kontra sa apat ka hari. ");
INSERT INTO hil_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Karon, ang Kapatagan sang Sidim may madamo nga buho nga ginakuhaan sang aspalto. Kag sang magpalagyo ang hari sang Sodom kag sang Gomora upod ang ila mga tinawo, nahulog ang iban sa ila sa mga buho, kag ang iban nakapalagyo sa mga bukid. ");
INSERT INTO hil_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","12","Ang tanan nga pagkabutang sang Sodom kag Gomora pati ang ila mga pagkaon ginkuha sang ila mga kaaway. Ginbihag man nila si Lot nga hinablos ni Abram kag ginkuha ang iya mga pagkabutang, kay natabuan nga didto siya nagaestar sa Sodom. Pagkatapos panguha sang mga kaaway, naglakat sila. ");
INSERT INTO hil_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Karon, may isa nga nakapalagyo kag nagpanugid kay Abram nga Hebreo parte sa natabo. Si Abram sadto didto nagaestar malapit sa dalagko nga mga kahoy ni Mamre nga Amornon. Si Mamre nga ini kag ang iya mga utod nga si Eshcol kag si Aner may kasugtanan kay Abram nga magdampiganay sila. ");
INSERT INTO hil_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Pagkabati ni Abram nga ginbihag ang iya hinablos, gintipon niya dayon ang iya 318 ka tinawo nga masaligan, nga natawo sa iya kampo. Ginlagas nila ang apat ka hari hasta sa Dan. ");
INSERT INTO hil_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Pagkagab-i, gintunga ni Abram ang iya mga tinawo kag ginsalakay nila ang ila mga kaaway, kag napierdi nila ini. Ang iban nga nakapalagyo ginlagas nila hasta sa Hoba, sa north sang Damascus. ");
INSERT INTO hil_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Nabawi nila ang tanan nga pagkabutang nga gin-agaw sang mga kaaway. Nabawi man nila si Lot kag ang iya mga pagkabutang pati ang mga babayi kag ang iban pa nga mga katawhan. ");
INSERT INTO hil_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Sang pagpuli na ni Abram, matapos nila nga napierdi si Kedorlaomer kag ang iya kaupod nga mga hari, ginsugata siya sang hari sang Sodom sa Kapatagan sang Shave (nga ginatawag man nga Kapatagan sang Hari). ");
INSERT INTO hil_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ginsugata man siya ni Melkizedek nga hari sang Salem kag pari sang Labing Mataas nga Dios. May dala si Melkizedek nga tinapay kag ilimnon. ");
INSERT INTO hil_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ginbendisyunan niya si Abram nga nagasiling: “Kabay pa nga bendisyunan ka Abram sang Labing Mataas nga Dios nga naghimo sang langit kag sang duta. ");
INSERT INTO hil_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Dalayawon ang Labing Mataas nga Dios nga nagpadaog sa imo kontra sa imo mga kaaway!” Dayon ginhatag ni Abram kay Melkizedek ang ikanapulo sang tanan nga butang nga iya nakuha sa inaway. ");
INSERT INTO hil_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Karon, nagsiling ang hari sang Sodom kay Abram, “Imo na lang ang tanan ko nga mga pagkabutang nga nabawi mo, pero iuli lang sa akon ang tanan ko nga mga tinawo.” ");
INSERT INTO hil_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Pero nagsabat si Abram, “Ginasumpa ko sa atubangan sang Ginoo, ang Labing Mataas nga Dios nga amo ang naghimo sang langit kag sang duta, ");
INSERT INTO hil_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nga indi gid ako magkuha sang bisan ano sa imo pagkabutang, bisan hilo ukon higot sang sandalyas, para indi ka makasiling nga ikaw ang nagpamanggaranon sa akon. ");
INSERT INTO hil_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Indi ako magbaton sang bisan ano para sa akon kaugalingon. Ang kabigon ko lang nga nabaton ko amo ang ginkaon sang akon mga tinawo, pero tuguti ang akon mga kaupod nga sila ni Aner, Eshcol, kag Mamre sa pagkuha sang ila parte sa mga butang nga nakuha sa inaway.” ");
INSERT INTO hil_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Pagkatapos sadto, naghambal ang Ginoo kay Abram paagi sa isa ka palanan-awon. Siling niya, “Abram, indi ka magkahadlok tungod kay apinan ko ikaw kag hatagan sang dako nga balos.” ");
INSERT INTO hil_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Pero nagsiling si Abram, “O Ginoong Dios, ano bala ang pulos sang imo balos sa akon kay hasta subong wala man ako sing bata. Ang manunubli ko amo gid lang si Eliezer nga taga-Damascus. ");
INSERT INTO hil_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Tungod kay wala mo ako paghatagi sang bata, si Eliezer nga isa sang akon mga suluguon amo na lang ang magapanubli sang akon mga pagkabutang.” ");
INSERT INTO hil_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Nagsiling ang Ginoo sa iya, “Indi si Eliezer ang magapanubli sang imo mga pagkabutang kundi ang imo gid mismo nga bata.” ");
INSERT INTO hil_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Dayon gindala siya sang Ginoo sa guwa kag ginsilingan, “Tan-awa bala ang mga bituon sa langit; isipa kon maisip mo. Pareho man sina kadamo ang imo mangin kaliwat.” ");
INSERT INTO hil_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Nagtuo si Abram sa Ginoo, kag tungod sang iya pagtuo ginpakamatarong siya. ");
INSERT INTO hil_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Nagsiling pa gid siya kay Abram, “Ako ang Ginoo nga nagsugo sa imo sa paghalin sa Ur nga sakop sang mga Kaldeanhon para ihatag sa imo ini nga duta nga mangin imo.” ");
INSERT INTO hil_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Pero nagsiling si Abram, “O Ginoong Dios, paano ko mahibaluan nga maangkon ko ini?” ");
INSERT INTO hil_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Nagsabat ang Ginoo, “Dal-i ako diri sang isa ka bataon nga babayi nga baka, isa ka babayi nga kanding, kag isa ka lalaki nga karnero, nga ang kada isa tatlo ka tuig ang edad. Kag magdala ka man sang isa ka pating kag isa ka tukmo.” ");
INSERT INTO hil_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Gani gindala ini tanan ni Abram sa Ginoo. Dayon ginpamihak ini ni Abram kag ginplastar nga nagaatubangay ang kada pihak. Ang tukmo lang kag ang pating ang wala niya pagpihaka. ");
INSERT INTO hil_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Naghapon sa pinihak nga mga sapat ang mga pispis nga nagapangaon sang patay, pero gintabog sila ni Abram. ");
INSERT INTO hil_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Sang manugsalop na ang adlaw, natulugan sing mahamuok si Abram kag may dako nga kahadlok nga nag-abot sa iya. ");
INSERT INTO hil_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Dayon nagsiling ang Ginoo sa iya, “Sigurado gid nga ang imo mga kaliwat mangin pangayaw sa iban nga lugar. Mangin ulipon sila didto kag pintasan sa sulod sang 400 ka tuig. ");
INSERT INTO hil_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Pero silutan ko ang nasyon nga magaulipon sa ila. Pagkatapos magahalin ang imo mga kaliwat sa sadto nga nasyon nga may dala nga madamo nga manggad. ");
INSERT INTO hil_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Pero kon parte sa imo Abram, palawigon ko ang imo kabuhi kag mapatay ka sa katigulangon nga may kalinong. ");
INSERT INTO hil_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Magaligad anay ang apat ka henerasyon antes makabalik ang imo mga kaliwat diri, tungod kay indi pa tuman ang pagpakasala sang mga Amornon para silutan sila kag pahalinon sa sini nga duta.” ");
INSERT INTO hil_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Sang nakasalop na ang adlaw kag nagdulom na, hinali lang nga may nakita si Abram nga kolon nga nagaaso kag sulo nga nagadabdab, nga nagaagi sa tunga sang mga pinihak nga mga sapat. ");
INSERT INTO hil_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Sa sina gid nga adlaw, naghimo ang Ginoo sang kasugtanan kay Abram. Siling niya, “Ihatag ko sa imo mga kaliwat ini nga duta nga halin sa suba sang Egypt pakadto sa dako nga suba nga amo ang Euphrates. ");
INSERT INTO hil_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ini nga duta amo subong ang ginaestaran sang mga Kenhanon, Keniznon, Kadmonhon, ");
INSERT INTO hil_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hithanon, Periznon, Refaimnon, ");
INSERT INTO hil_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amornon, Canaanhon, Girgashnon, kag mga Jebusnon.” ");
INSERT INTO hil_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Si Sarai nga asawa ni Abram indi makabata. May ulipon siya nga babayi nga Egyptohanon nga ang ngalan si Hagar. ");
INSERT INTO hil_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Nagsiling si Sarai kay Abram, “Tungod nga wala nagtugot ang Ginoo nga makabata ako, maayo pa siguro nga maghulid ka sa akon ulipon nga babayi kay basi pa lang makabaton kita sang bata paagi sa iya.” Nagsugot si Abram sa ginsiling sang iya asawa. ");
INSERT INTO hil_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Gani ginhatag ni Sarai si Hagar kay Abram para mangin iya asawa. (Natabo ini matapos nakaestar si Abram sa Canaan sing napulo ka tuig.) ");
INSERT INTO hil_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Sang ulihi nagbusong si Hagar. Pagkahibalo ni Hagar nga nagabusong siya, ginpakanubo niya si Sarai. ");
INSERT INTO hil_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tungod sini, nagsiling si Sarai kay Abram, “Karon nga nagabusong na si Hagar ginapakanubo na niya ako. Ikaw ang dapat basulon sini. Gintugyan ko siya sa imo. Ang Ginoo na ang maghukom kon sin-o sa aton ang husto.” ");
INSERT INTO hil_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Nagsabat si Abram, “Kon amo sina, ibalik ko siya sa imo bilang ulipon kag pagusto ka kon ano ang himuon mo sa iya.” Umpisa sadto tama na kalain ang pagtratar ni Sarai kay Hagar, gani sang ulihi naglayas na lang siya. ");
INSERT INTO hil_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Nakita sang anghel sang Ginoo si Hagar didto sa tuburan sa kamingawan. Ang tuburan nga ini malapit sa dalan pakadto sa Shur. ");
INSERT INTO hil_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Nagpamangkot ang anghel sa iya, “Hagar, ulipon ni Sarai, diin ka bala naghalin kag diin ka makadto?” Nagsabat siya, “Naglayas ako sa akon ama nga si Sarai.” ");
INSERT INTO hil_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Nagsiling ang anghel sa iya, “Balik ka sa imo ama kag magpasakop ka sa iya.” ");
INSERT INTO hil_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Dayon nagsiling pa gid ang anghel, “Padamuon ko gid ang imo kaliwat nga ang ila kadamuon indi maisip. ");
INSERT INTO hil_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Nagabusong ka, kag sa indi madugay magabata ka sing lalaki. Ngalanan mo siya nga Ishmael, kay ginpamatian sang Ginoo ang imo pagpanawag sa iya tungod sa imo pag-antos. ");
INSERT INTO hil_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Pero ang imo anak magakabuhi nga pareho sa isa ka maila nga donkey. Kontrahon niya ang tanan, kag ang tanan magakontra sa iya. Bisan ang iya mga paryente kontrahon niya.” ");
INSERT INTO hil_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Gintawag ni Hagar ang Ginoo nga nagpakighambal sa iya nga “Dios nga Nakakita,” kay siling niya, “Nakita ko gid bala ang Dios nga nakakita sa akon kag sa gihapon buhi ako?” ");
INSERT INTO hil_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Amo ina nga ang tuburan nga didto sa tunga sang Kadesh kag Bered gintawag nga Beer Lahai Roi. ");
INSERT INTO hil_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Nagbalik si Hagar kay Sarai, kag sang ulihi nagbata siya sing lalaki. Gin-ngalanan ni Abram ang bata nga Ishmael. ");
INSERT INTO hil_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ang edad ni Abram sang natawo si Ishmael 86 ka tuig. ");
INSERT INTO hil_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Sang nagaedad si Abram sing 99 ka tuig, nagpakita ang Ginoo sa iya kag nagsiling, “Ako ang Dios nga Makagagahom. Magtuman ka permi sa akon kag magkabuhi nga matarong. ");
INSERT INTO hil_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Tumanon ko ang akon kasugtanan sa imo; padamuon ko gid ang imo mga kaliwat.” ");
INSERT INTO hil_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Pagkabati sadto ni Abram, nagluhod siya bilang pagtahod sa Dios. Nagsiling ang Dios sa iya, ");
INSERT INTO hil_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Sa akon bahin, amo ini ang akon kasugtanan sa imo: Mangin amay ka sang madamo nga nasyon. ");
INSERT INTO hil_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Sugod subong indi na Abram ang itawag sa imo kundi Abraham na, tungod kay himuon ko ikaw nga amay sang madamo nga nasyon. ");
INSERT INTO hil_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Padamuon ko gid ang imo mga kaliwat kag magatukod sila sang mga nasyon, kag ang iban sa ila mangin hari. ");
INSERT INTO hil_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Tumanon ko ang akon kasugtanan sa imo kag sa imo mga kaliwat sa palaabuton nga mga henerasyon, nga ako padayon nga mangin Dios ninyo. Ini nga kasugtanan magapadayon hasta san-o. ");
INSERT INTO hil_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Mga pangayaw lang kamo subong sa duta sang Canaan. Pero igahatag ko ining bilog nga duta sa imo kag sa imo mga kaliwat. Mangin inyo na ina hasta san-o, kag ako padayon nga mangin Dios ninyo.” ");
INSERT INTO hil_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Nagsiling pa gid siya kay Abraham, “Sa imo bahin, tipigan mo ang akon kasugtanan sa imo. Kag amo man ini ang dapat nga himuon sang imo mga kaliwat sa palaabuton nga mga henerasyon. ");
INSERT INTO hil_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Kag parte sang sina nga kasugtanan, dapat tulion ninyo ang tanan ninyo nga lalaki. ");
INSERT INTO hil_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ini ang mangin tanda sang akon kasugtanan sa inyo. ");
INSERT INTO hil_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Sugod subong hasta sa palaabuton nga mga henerasyon, dapat tulion ninyo ang kada bata nga lalaki sa edad nga walo ka adlaw. Tulion man ninyo ang mga ulipon nga lalaki nga natawo sa inyo panimalay kag pati ang mga ulipon nga inyo ginbakal sa mga taga-iban nga lugar. Ina nga tanda sa inyo lawas magapamatuod nga ang akon kasugtanan sa inyo magapadayon hasta san-o. ");
INSERT INTO hil_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ang bisan sin-o nga lalaki sa inyo nga wala matuli indi ninyo pagkabigon nga sakop ninyo, kay ginbaliwala niya ang akon kasugtanan.” ");
INSERT INTO hil_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nagsiling pa gid ang Dios kay Abraham, “Kon parte sa imo asawa nga si Sarai, indi mo na siya pagtawgon nga Sarai, kundi sugod subong Sara na ang itawag mo sa iya. ");
INSERT INTO hil_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Pakamaayuhon ko siya kag hatagan ko gid ikaw sang anak paagi sa iya. Mangin iloy siya sang madamo nga nasyon, kag ang iban niya nga mga kaliwat mangin hari.” ");
INSERT INTO hil_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Pagkabati sadto ni Abraham nagluhod siya bilang pagtahod sa Dios, pero nagkadlaw siya. Nagsiling siya sa iya kaugalingon, “Makapabata pa bala ako nga 100 na ang akon edad? Kag si Sara, makabata pa bala nga 90 na ang iya edad?” ");
INSERT INTO hil_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Dayon nagsiling siya sa Dios, “Kabay pa nga si Ishmael ang magabaton sang mga ginpromisa mo sa akon.” ");
INSERT INTO hil_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nagsabat ang Dios, “Indi. Ang imo asawa nga si Sara magabata sing lalaki kag ngalanan mo siya nga Isaac. Sa iya ko padayunon ang akon kasugtanan sa imo, kag magapadayon ini nga kasugtanan sa iya mga kaliwat hasta san-o. ");
INSERT INTO hil_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Kon parte kay Ishmael, nabatian ko ang imo pangabay para sa iya. Pakamaayuhon ko siya kag hatagan sang madamo nga kaliwat. Mangin amay siya sang dose ka pangulo, kag ang iya mga kaliwat mangin bantog nga katawhan. ");
INSERT INTO hil_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ugaling, kay Isaac kag sa iya mga kaliwat ko lang tumanon ang akon kasugtanan sa imo. Magabata si Sara kay Isaac sa amo man sini nga tion sa sunod nga tuig.” ");
INSERT INTO hil_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Pagkatapos hambal sang Dios kay Abraham, naghalin siya dayon. ");
INSERT INTO hil_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Sa sadto gid mismo nga adlaw, gintuman ni Abraham ang ginsugo sa iya sang Dios. Gintuli niya ang iya anak nga si Ishmael kag ang tanan nga lalaki sa iya panimalay: ang mga ulipon nga natawo sa iya panimalay kag ang mga ulipon nga iya ginbakal. ");
INSERT INTO hil_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Nagaedad si Abraham sing 99 ka tuig sang gintuli siya, ");
INSERT INTO hil_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","kag si Ishmael ya nagaedad sing 13 ka tuig. ");
INSERT INTO hil_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Sa sadto gid mismo nga adlaw nga nagsugo ang Dios nga ang tanan nga lalaki dapat matuli, nagpatuli si Abraham kag si Ishmael pati ang tanan nga ulipon ni Abraham nga natawo sa iya panimalay kag ang mga ulipon nga iya ginbakal sa mga taga-iban nga lugar. ");
INSERT INTO hil_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Nagpakita ang Ginoo kay Abraham sang didto pa siya nagaestar malapit sa dalagko nga mga kahoy ni Mamre. Mainit sadto nga adlaw, kag si Abraham didto nagapungko sa puwertahan sang iya tolda. ");
INSERT INTO hil_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Samtang nagapanan-aw tan-aw siya, may nakita siya nga tatlo ka lalaki nga nagatindog sa unhan. Nagtindog siya dayon kag nagdali-dali sugata sa ila. Nagluhod siya sa ila bilang pagtahod ");
INSERT INTO hil_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","kag nagsiling, “Ginoo, kon mahimo, hapit ka anay diri sa amon. ");
INSERT INTO hil_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Magpakuha ako sang tubig para makapanghinaw kamo sang inyo mga tiil kag dayon magpahuway kamo sa idalom sang sini nga kahoy. ");
INSERT INTO hil_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Makuha man ako sang pagkaon para sa inyo agod may kusog kamo sa inyo paglakat. Ginakalipay ko ang pagserbisyo sa inyo samtang ari kamo diri sa amon.” Kag nagsabat sila, “Sige, himua ang ginsiling mo.” ");
INSERT INTO hil_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Gani nagdali-dali si Abraham sulod sa tolda kag nagsiling kay Sara, “Abi, kuha ka sing mga tunga sa sako nga harina nga pinakamaayo nga klase kag magluto ka sang tinapay. Kag dalion mo ang pagluto.” ");
INSERT INTO hil_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Nagdalagan dayon si Abraham pakadto sa iya mga baka kag nagpili sang matambok nga bata, kag dali-dali niya ini nga ginpaihaw kag ginpaluto sa iya bataon nga suluguon. ");
INSERT INTO hil_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Dayon gindala niya ini sa iya mga bisita, kag nagdala man siya sang keso kag gatas. Kag samtang nagakaon sila sa idalom sang kahoy, didto man si Abraham nga nagaserbi sa ila. ");
INSERT INTO hil_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Karon, nagpamangkot ang mga bisita kay Abraham, “Diin bala si Sara nga imo asawa?” Nagsabat siya, “Didto sa sulod sang tolda.” ");
INSERT INTO hil_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ang isa sa mga bisita nagsiling, “Sigurado gid nga mabalik ako diri sa sunod nga tuig sa amo man sini nga tion, kag ang imo asawa nga si Sara may anak na nga lalaki.” Nagapamati gali si Sara didto sa puwertahan sang tolda sa likod lang ni Abraham. ");
INSERT INTO hil_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","(Tigulang na gid sila nga duha ni Abraham kag nag-untat na gani ang pamulanon ni Sara.) ");
INSERT INTO hil_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Nagkadlaw si Sara sa iya lang kaugalingon kag naghunahuna, “Sa katigulangon ko nga ini ganahan pa ayhan ako sa paghulid sa akon bana nga tigulang man?” ");
INSERT INTO hil_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Nagpamangkot dayon ang Ginoo kay Abraham, “Ngaa bala nagkadlaw si Sara kag nagsiling, ‘Makabata pa bala ako nga tigulang na ako?’ ");
INSERT INTO hil_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","May butang bala nga indi mahimo sang Ginoo? Suno sa ginsiling ko, mabalik ako diri sa sunod nga tuig sa amo man sini nga tion, kag si Sara may anak na nga lalaki.” ");
INSERT INTO hil_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Hinadlukan si Sara, gani nagbutig siya. Siling niya, “Wala ako nagkadlaw!” Pero nagsiling ang Ginoo, “Nagkadlaw ka gid.” ");
INSERT INTO hil_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Pagkatapos naglakat ang tatlo ka lalaki. Gindul-ong sila ni Abraham hasta sa lugar nga makita nila sa ubos ang banwa sang Sodom. ");
INSERT INTO hil_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Nagsiling ang Ginoo, “Indi ko pagtaguon kay Abraham ang akon pagahimuon. ");
INSERT INTO hil_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Sigurado nga mangin dako kag gamhanan nga nasyon ang iya mga kaliwat sa palaabuton. Kag paagi sa iya pakamaayuhon ko ang tanan nga nasyon sa kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ginpili ko siya para ipatuman niya sa iya mga kabataan kag mga kaliwat ang akon mga pamaagi, para maghimo sila sang husto kag matarong. Sa sina nga paagi, matuman ang akon ginpromisa sa iya.” ");
INSERT INTO hil_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Dayon nagsiling ang Ginoo kay Abraham, “Madamo na ang nagareklamo kontra sa Sodom kag Gomora, kay puwerte na gid ang kalautan sa sini nga mga lugar. ");
INSERT INTO hil_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Gani makadto ako didto para mahibaluan ko kon matuod ukon indi ini nga mga reklamo.” ");
INSERT INTO hil_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Naglakat dayon ang duha ka lalaki pa-Sodom, pero nagpabilin ang Ginoo kag si Abraham. ");
INSERT INTO hil_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Nagpalapit si Abraham sa Ginoo kag nagpamangkot, “Laglagon mo bala ang mga matarong upod sa mga makasasala? ");
INSERT INTO hil_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kon may ara abi nga 50 ka matarong sa sina nga banwa, laglagon mo bala gihapon ang bilog nga banwa? Indi mo bala pagkaluoyan ang banwa tungod na lang sa 50 ka tawo nga matarong? ");
INSERT INTO hil_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Imposible nga laglagon mo ang mga matarong upod sa mga makasasala. Indi mahimo nga palareho lang ang pagtratar mo sa ila. Ikaw nga nagahukom sa bilog nga kalibutan, indi bala nga dapat himuon mo kon ano ang husto?” ");
INSERT INTO hil_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Nagsabat ang Ginoo, “Kon may makita ako nga 50 ka matarong sa Sodom, indi ko paglaglagon ang bilog nga banwa tungod lang sa ila.” ");
INSERT INTO hil_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Nagsiling liwat si Abraham, “O Ginoo, patawara ako nga nangisog ako sa pagpakighambal sa imo. Tawo lang ako, kag wala ako sing kinamatarong sa paghambal sini sa imo. ");
INSERT INTO hil_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Pero kon may ara lang abi nga 45 ka matarong, ano, laglagon mo bala gihapon ang bilog nga banwa tungod kay kulang ini sang lima?” Nagsabat ang Ginoo, “Kon may makita ako nga 45 ka matarong, indi ko paglaglagon ang banwa.” ");
INSERT INTO hil_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Nagsiling liwat si Abraham, “Ti, kon 40 lang abi ang matarong?” Nagsabat ang Ginoo, “Indi ko paglaglagon ang banwa kon may 40 nga matarong.” ");
INSERT INTO hil_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Nagsiling liwat si Abraham, “Indi ka lang kuntani mangakig sa akon, Ginoo, kay mamangkot pa ako. Ti, abi kon may 30 lang ka tawo nga matarong?” Nagsabat ang Ginoo, “Indi ko gihapon paglaglagon ang banwa kon may makita ako nga 30 ka tawo nga matarong.” ");
INSERT INTO hil_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Nagsiling pa gid liwat si Abraham, “Ginoo, patawara ako sa akon kaisog sa padayon nga pagpakighambal sa imo. Abi kon may 20 lang ka tawo nga matarong?” Nagsabat ang Ginoo, “Indi ko gihapon paglaglagon ang banwa kon may 20 nga matarong.” ");
INSERT INTO hil_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Nagsiling pa gid liwat si Abraham, “Ginoo, indi ka kuntani mangakig; katapusan ko na lang gid ini nga pamangkot. Halimbawa 10 lang abi ang imo makita nga matarong?” Nagsabat ang Ginoo, “Indi ko gihapon paglaglagon ang banwa kon may 10 nga matarong.” ");
INSERT INTO hil_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Pagkatapos nila estorya, naghalin ang Ginoo, kag si Abraham ya nagpuli sa ila. ");
INSERT INTO hil_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nag-abot atong duha ka anghel sa Sodom sang sirom na. Nagapungko sadto si Lot sa puwertahan sang banwa. Pagkakita ni Lot sa ila, nagtindog siya sa pagsugata sa ila. Dayon nagluhod siya sa ila atubangan bilang pagtahod kag nagsiling, ");
INSERT INTO hil_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Kon mahimo hapit anay kamo sa akon balay. Makapanghinaw kamo didto sang inyo mga tiil kag makatulog karon nga gab-i. Kag buwas sa kaagahon makapadayon kamo sa inyo pagpanglakaton.” Pero nagsabat sila, “Indi lang, didto lang kami matulog sa plasa karon nga gab-i.” ");
INSERT INTO hil_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Pero ginpilit gid sila ni Lot, gani nag-upod na lang sila sa iya balay. Nagpreparar si Lot sang mga pagkaon kag ilimnon. Nagpaluto man siya sang tinapay nga wala sing inugpahabok. Kag sang handa na, nagpanyapon sila. ");
INSERT INTO hil_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Sang manugtulog na sila, nag-abot ang tanan nga bataon kag tigulang nga mga lalaki halin sa tanan nga parte sang siyudad sang Sodom, kag ginpalibutan nila ang balay ni Lot. ");
INSERT INTO hil_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Gintawag nila si Lot kag ginpamangkot, “Diin na bala ang imo bisita nga mga lalaki nga nag-abot sini lang nga gab-i? Paguwaa sila diri kay luyag namon nga magpakighilawas sa ila.” ");
INSERT INTO hil_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Nagguwa si Lot sa balay para atubangon sila. Sang pagguwa niya, ginsira niya dayon ang puwertahan. ");
INSERT INTO hil_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Nagsiling siya sa ila, “Mga abyan, nagapangabay ako nga indi ninyo paghimua inang ginahunahuna ninyo nga malain. ");
INSERT INTO hil_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kon gusto ninyo, may duha ako ka anak nga dalaga pa. Ihatag ko sila sa inyo kag pagusto kamo kon ano ang inyo himuon sa ila. Pero indi lang ninyo pag-anha ining duha ka tawo, kay mga bisita ko sila kag dapat ko sila nga protektaran.” ");
INSERT INTO hil_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Pero nagsiling ang mga tawo, “Estranghero ka lang diri pero daw si sin-o ka gid nga magpasilabot sa amon. Halin dira! Basi kon sobra pa ang amon himuon sa imo sang sa ila.” Dayon gintikwang nila si Lot. Mapalapit na kuntani sila sa puwertahan para gub-on ini, ");
INSERT INTO hil_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","pero gin-abrihan ini sang duha ka anghel nga didto sa sulod kag ginbutong nila si Lot pasulod kag ginsiradhan ang puwertahan. ");
INSERT INTO hil_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Dayon ginbulag nila ang mga tawo sa guwa para indi na sila makatultol sang puwertahan. ");
INSERT INTO hil_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Nagsiling ang duha ka anghel kay Lot, “Kon may mga anak ka pa, ukon mga umagad nga lalaki, ukon mga paryente sa sini nga banwa, dal-a sila tanan kag magpalagyo kamo, ");
INSERT INTO hil_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","tungod kay laglagon namon ini nga banwa. Nabatian sang Ginoo ang mga reklamo kontra sa sining mga tawo. Gani ginpadala niya kami sa paglaglag sang sini nga banwa.” ");
INSERT INTO hil_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Dayon ginkadtuan ni Lot ang mga mangin umagad niya nga mga lalaki kag ginsilingan, “Magdali-dali kamo halin diri kay pagalaglagon sang Ginoo ang ini nga banwa.” Pero wala sila nagpati kay abi nila nagalango-lango lang si Lot. ");
INSERT INTO hil_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Sang kaagahon, ginpadali-dali si Lot sang mga anghel nga maghalin sa banwa. Siling nila, “Dasiga! Dal-a ang imo asawa kag duha ka anak nga babayi nga ari diri kag maghalin kamo dayon, kay basi madalahig kamo kon laglagon na ini nga banwa.” ");
INSERT INTO hil_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Indi pa kuntani maghalin si Lot. Pero tungod kay naluoy ang Ginoo sa ila, gin-uyatan sila sang mga anghel sa kamot kag gindala paguwa sa banwa. ");
INSERT INTO hil_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Sang didto na sila sa guwa, nagsiling ang Ginoo, “Dalagan kamo! Indi gid kamo magbulobalikid ukon magpundo sa bisan diin sa sini nga kapatagan. Dalagan kamo sa bukid para indi kamo mapatay.” ");
INSERT INTO hil_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Pero nagsabat si Lot, “Ginoo ko, indi na ako pagpadalagana sa bukid. ");
INSERT INTO hil_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ginkaluoyan mo ako kag ginpakita mo ang imo kaayo sa akon sa pagluwas sang akon kabuhi. Pero layo katama ang bukid; basi maabtan ako sang kahalitan kag mapatay ako antes makaabot didto. ");
INSERT INTO hil_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tan-awa bala inang gamay nga banwa sa unhan. Siguro maabot ko ina kay malapit man lang. Puwede bala ako makapalagyo sa sina nga gamay nga banwa para maluwas ako?” ");
INSERT INTO hil_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nagsabat ang Ginoo, “Huo, sugot ako sa imo pangabay; indi ko paglaglagon ina nga banwa. ");
INSERT INTO hil_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Sige, dalagan na kamo didto, kay indi ko mahimo ang akon himuon hasta indi pa kamo makaabot didto.” Ato nga banwa gintawag nga Zoar. ");
INSERT INTO hil_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Nagabutlak gid ang adlaw sang pag-abot nila ni Lot sa Zoar. ");
INSERT INTO hil_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Dayon ginpaulanan sang Ginoo sang nagadabdab nga asupre ang Sodom kag Gomora. ");
INSERT INTO hil_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ginlaglag sang Ginoo ang duha ka banwa kag ang bilog nga kapatagan. Nagkalamatay ang tanan nga nagaestar didto pati ang tanan nga tanom. ");
INSERT INTO hil_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Nagbalikid ang asawa ni Lot, gani nahimo siya nga haligi nga asin. ");
INSERT INTO hil_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Aga pa gid sang sunod nga adlaw, nagdali-dali kadto si Abraham sa lugar nga sa diin nagpakighambal siya sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Gintan-aw niya ang Sodom kag Gomora kag ang bilog nga kapatagan. Nakita niya ang aso nga nagatub-ok halin sa duta nga daw pareho sa aso nga nagahalin sa isa ka dako nga hurnohan. ");
INSERT INTO hil_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Gani gindumdom sang Dios si Abraham, kay sang paglaglag sang Dios sang mga banwa sa kapatagan nga sa diin nag-estar si Lot, ginpapalagyo niya anay si Lot para indi siya mahalitan. ");
INSERT INTO hil_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Tungod kay nahadlok si Lot mag-estar sa Zoar, nagsaylo siya kag ang iya duha ka anak nga dalaga sa bukid kag didto nag-estar sa kuweba. ");
INSERT INTO hil_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Sang isa ka adlaw, nagsiling ang magulang nga anak sa iya manghod, “Tigulang na ang aton amay kag wala gid diri sing lalaki nga aton mapamana para makapamata kita pareho sa ginahimo sa bisan diin. ");
INSERT INTO hil_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Maayo pa nga paimnon ta si tatay sang bino hasta nga mahubog siya, dayon maghulid kita sa iya para makabata kita paagi sa iya.” ");
INSERT INTO hil_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Gani sadto nga gab-i, ginhubog nila ang ila amay. Dayon nagpakighilawas ang magulang nga anak sa iya amay. Pero tungod sa sobra nga kahubog ni Lot wala gid siya kahibalo kon ano ang nagkalatabo. ");
INSERT INTO hil_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Pagkasunod nga adlaw, nagsiling ang magulang sa iya manghod, “Naghulid na ako kagab-i sa aton amay. Kag karon sa gab-i paimnon ta naman siya sang bino hasta nga mahubog siya, kag ikaw naman ang maghulid sa iya para kita nga duha makabata paagi sa iya.” ");
INSERT INTO hil_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Gani sadto gid nga gab-i, ginhubog naman nila ang ila amay kag ang manghod naman ang nagpakighilawas sa iya. Sa sobra niya nga kahubog wala siya gihapon kahibalo kon ano ang nagkalatabo. ");
INSERT INTO hil_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Sa sadto nga paagi, nagbusong ang duha ka anak ni Lot paagi mismo sa iya. ");
INSERT INTO hil_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Sang ulihi nagbata ang magulang sing lalaki kag gin-ngalanan niya nga Moab. Siya ang ginhalinan sang katawhan subong nga mga Moabnon. ");
INSERT INTO hil_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nagbata man ang manghod sing lalaki kag gin-ngalanan niya nga Ben Ami. Siya ang ginhalinan sang katawhan subong nga mga Ammonhon. ");
INSERT INTO hil_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Naghalin sila ni Abraham sa Mamre kag nagkadto sa Negev. Didto sila nag-estar sa tunga-tunga sang Kadesh kag Shur. Sang ulihi nagsaylo sila sa Gerar. ");
INSERT INTO hil_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Samtang didto sila, ang pakilala ni Abraham kay Sara sa mga tawo utod niya siya. Gani ginpakuha ni Haring Abimelec sang Gerar si Sara. ");
INSERT INTO hil_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Isa ka gab-i, nagpakita ang Dios kay Abimelec paagi sa isa ka damgo. Siling niya, “Mapatay ka tungod kay ginkuha mo ina nga babayi nga may bana na.” ");
INSERT INTO hil_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Pero tungod kay wala pa matandog ni Abimelec si Sara, nagsiling siya, “Ginoo, ngaa patyon mo ako kag ang akon katawhan? Wala ako sing sala. ");
INSERT INTO hil_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Nagsiling man abi si Abraham nga utod niya si Sara kag si Sara nagsiling man nga utod niya si Abraham. Inosente gid ako kag wala gid ako sing malain nga tuyo sa pagkuha kay Sara.” ");
INSERT INTO hil_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Nagsabat ang Dios, “Huo, nakahibalo ako nga wala ka sing malain nga tuyo, gani wala ako magtugot nga matandog mo siya para indi ka makasala sa akon. ");
INSERT INTO hil_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Pero dapat ibalik mo siya sa iya bana tungod ang iya bana isa ka propeta, kag pangamuyuan ka niya para indi ka mapatay. Pero kon indi mo gani siya pag-ibalik, ginapaandaman ko ikaw nga daan nga mapatay ka gid pati ang tanan mo nga katawhan.” ");
INSERT INTO hil_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Aga pa gid sang sunod nga adlaw, ginpatawag ni Abimelec ang tanan niya nga mga opisyal kag ginsugiran parte sa iya nga damgo. Kag hinadlukan gid sila. ");
INSERT INTO hil_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Dayon ginpatawag ni Abimelec si Abraham kag ginpamangkot, “Ano bala ining ginhimo mo sa amon? Ano bala ang akon sala sa imo nga ginbutang mo sa dako nga paglapas ang akon bilog nga ginharian? Indi husto ang imo ginhimo. ");
INSERT INTO hil_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Pero ngaa bala ginhimo mo ini?” ");
INSERT INTO hil_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Nagsabat si Abraham, “Abi ko wala gid sing bisan isa diri nga nagatahod sa Dios, gani naghunahuna ako nga basi patyon ninyo ako para makuha ninyo ang akon asawa. ");
INSERT INTO hil_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Matuod gid man nga mag-utod kami, pero sa amay lang kag indi sa iloy, kag ginpangasawa ko siya. ");
INSERT INTO hil_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Sang ginsilingan ako sang Dios nga maghalin sa panimalay sang akon amay, ginhambalan ko si Sara nga ipakilala niya nga mag-utod kami bisan diin kami magkadto. Sa sini nga paagi mapakita niya ang iya paghigugma sa akon.” ");
INSERT INTO hil_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ginbalik ni Abimelec si Sara kay Abraham, kag ginhatagan pa niya si Abraham sang mga karnero, baka, kag mga ulipon nga babayi kag lalaki. ");
INSERT INTO hil_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Dayon nagsiling siya kay Abraham, “Handa ako nga paestaron kamo sa akon duta. Mag-estar kamo bisan diin nga gusto ninyo.” ");
INSERT INTO hil_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Nagsiling man siya kay Sara, “Hatagan ko ang imo utod sang 1,000 ka bilog nga pilak bilang pamatuod sa tanan ninyo nga kaupdanan nga wala ko ikaw matandog kag para indi sila maghunahuna nga nakahimo ka sang malain.” ");
INSERT INTO hil_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Tungod sa pagkuha ni Abimelec kay Sara, ginbuot sang Ginoo nga indi makabata ang tanan nga babayi sa iya panimalay. Gani nagpangamuyo si Abraham sa Dios, kag gin-ayo sang Dios ang asawa ni Abimelec kag ang iya mga ulipon nga mga babayi para makabata sila liwat. Gin-ayo man sang Dios si Abimelec sa iya balatian. ");
INSERT INTO hil_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Karon, gindumdom sang Ginoo si Sara suno sa iya ginpromisa. ");
INSERT INTO hil_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Nagbusong si Sara kag nagbata sing lalaki bisan tigulang na si Abraham. Natawo ang bata sa tion gid nga ginsiling sadto sang Dios. ");
INSERT INTO hil_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Gin-ngalanan ni Abraham ang bata nga Isaac. ");
INSERT INTO hil_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Sang walo na ka adlaw ang bata, gintuli siya ni Abraham suno sa ginsugo sa iya sang Dios. ");
INSERT INTO hil_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Nagaedad si Abraham sang 100 ka tuig sang natawo si Isaac. ");
INSERT INTO hil_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Nagsiling si Sara, “Ginpakadlaw ako sang Dios sa kalipay, kag ang bisan sin-o nga makabati parte sining natabo sa akon magakadlaw man. ");
INSERT INTO hil_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Sin-o ang makahunahuna nga magsiling kay Abraham nga makapatiti pa ako sang bata? Pero nakabata pa ako bisan tigulang na siya.” ");
INSERT INTO hil_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nagdako si Isaac, kag sang adlaw nga ginlutas siya naghiwat si Abraham sang isa ka dako nga punsyon. ");
INSERT INTO hil_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Isa ka adlaw, nakita ni Sara nga ginasunlog ni Ishmael si Isaac. (Si Ishmael anak ni Abraham kay Hagar nga Egyptohanon.) ");
INSERT INTO hil_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Gani nagsiling si Sara kay Abraham, “Palayasa inang babayi nga ulipon kag ang iya anak, kay ang anak sinang ulipon indi dapat partihan sa palanublion sang akon anak nga si Isaac.” ");
INSERT INTO hil_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Naglain gid ang buot ni Abraham tungod kay anak man niya si Ishmael. ");
INSERT INTO hil_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Pero nagsiling ang Dios sa iya, “Indi maglain ang buot mo parte kay Ishmael kag kay Hagar. Tumana ang gusto ni Sara, tungod sa kay Isaac magahalin ang imo mga kaliwat nga akon ginpromisa. ");
INSERT INTO hil_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Kag kon parte kay Ishmael, hatagan ko man siya sang madamo nga kaliwat kag mangin isa man sila ka nasyon, tungod kay anak mo man siya.” ");
INSERT INTO hil_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Aga pa gid sang sunod nga adlaw, nagkuha si Abraham sang pagkaon kag tubig nga nasulod sa panit nga suludlan, kag ginpapas-an niya ini kay Hagar. Dayon ginpalakat niya si Hagar kaupod ang bata. Nagpanglakaton sila sa kamingawan sang Beersheba nga wala kahibalo kon sa diin sila pakadto. ");
INSERT INTO hil_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Sang naubos na ang ila tubig, ginbilin niya ang iya bata sa idalom sang isa ka kahoy-kahoy ");
INSERT INTO hil_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","kag naglakat siya sa unhan nga ang kalayuon mga 100 ka metros halin sa bata. Didto siya nagpungko kag naghilibion nga nagasiling sa iya kaugalingon, “Indi ako makaantos nga magtan-aw sa akon anak nga mapatay.” ");
INSERT INTO hil_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Karon, nabatian sang Dios ang hibi sang bata. Gani nagsiling ang anghel sang Dios kay Hagar halin didto sa langit, “Ano ang imo ginapaligban Hagar? Indi ka magkahadlok; nabatian sang Dios ang hibi sang imo anak. ");
INSERT INTO hil_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tindog ka kag pabanguna ang bata, kay himuon ko nga dako nga nasyon ang iya mga kaliwat.” ");
INSERT INTO hil_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Dayon may ginpakita ang Dios sa iya nga isa ka bubon. Nagkadto siya didto kag ginsudlan sang tubig ang iya suludlan, dayon ginpainom niya ang iya anak. ");
INSERT INTO hil_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Wala pagpabay-i sang Dios si Ishmael hasta nga nagdako siya. Didto siya nag-estar sa kamingawan sang Paran kag nangin isa siya ka manugpana. Sang ulihi ginpaasawa siya sang iya iloy sa isa ka Egyptohanon. ");
INSERT INTO hil_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Sang sadto nga tion, nagkadto si Abimelec kay Abraham upod ang pangulo sang iya mga soldado nga si Ficol. Nagsiling si Abimelec kay Abraham, “Ginabuligan ka gid sang Dios sa tanan mo nga ginahimo. ");
INSERT INTO hil_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Gani, magsumpa ka diri sa ngalan sang Dios nga indi mo gid ako pagtraiduran pati ang akon mga kaliwat. Ipakita mo ang imo kaayo sa akon kag sa sining lugar nga sa diin nagaestar ka karon bilang pangayaw, subong nga nangin maayo man ako sa imo.” ");
INSERT INTO hil_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Nagsabat si Abraham, “Ginasumpa ko.” ");
INSERT INTO hil_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Pero nagreklamo si Abraham kay Abimelec parte sa bubon nga gin-agaw sang iya mga suluguon. ");
INSERT INTO hil_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Nagsiling si Abimelec, “Wala ako kahibalo kon sin-o ang naghimo sina. Wala mo man ako ginsugiran, kag subong ko lang nabatian ina.” ");
INSERT INTO hil_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Gani nagkuha si Abraham sang mga karnero kag mga baka kag ginhatag niya kay Abimelec, dayon naghimo sila nga duha sang kasugtanan. ");
INSERT INTO hil_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Nagkuha pa gid si Abraham sang pito ka babayi nga karnero kag iya ini ginpain. ");
INSERT INTO hil_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Nagpamangkot si Abimelec, “Para sa ano inang pito ka karnero nga imo ginpain?” ");
INSERT INTO hil_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Nagsabat si Abraham, “Batuna ining pito ka karnero bilang pamatuod nga ako ang nagkutkot sang sina nga bubon.” ");
INSERT INTO hil_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tungod sining pagsumpaanay nila, ang ato nga lugar gintawag Beersheba. ");
INSERT INTO hil_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Pagkatapos sang ila kasugtanan didto sa Beersheba, nagbalik si Abimelec kag ang pangulo sang iya mga soldado nga si Ficol sa duta sang mga Filistinhon. ");
INSERT INTO hil_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Nagtanom si Abraham sang isa ka kahoy nga tamarisko didto sa Beersheba kag nagsimba siya didto sa Ginoo, ang Dios nga wala sing katapusan. ");
INSERT INTO hil_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Nag-estar si Abraham sa duta sang mga Filistinhon sa malawig nga panahon. ");
INSERT INTO hil_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Sang ulihi gintilawan sang Dios si Abraham. Gintawag niya si Abraham, kag nagsabat si Abraham sa iya. ");
INSERT INTO hil_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Dayon nagsiling siya, “Dal-a ang imo bugtong kag pinalangga nga anak nga si Isaac kag magkadto kamo sa duta sang Moria. Saka kamo sa bukid nga akon itudlo sa imo kag ihalad mo siya didto sa akon bilang halad nga ginasunog.” ");
INSERT INTO hil_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Gani aga pa gid sang sunod nga adlaw, nagbial si Abraham sang mga kahoy nga inuggatong sa halad, kag ginkarga niya ini sa iya donkey. Naglakat siya kaupod si Isaac kag ang duha niya ka suluguon nga lalaki pakadto sa lugar nga ginsiling sa iya sang Dios. ");
INSERT INTO hil_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Sang ikatlo nga adlaw sang ila pagpanglakaton, nakita ni Abraham sa unhan ang lugar nga ginsiling sa iya sang Dios. ");
INSERT INTO hil_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Gani nagsiling si Abraham sa duha niya ka suluguon, “Diri lang kamo anay kag bantayi ninyo ang donkey, kay mataklad kami didto sa unhan kag magsimba sa Dios. Mabalik man kami dayon.” ");
INSERT INTO hil_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ginpapas-an ni Abraham kay Isaac ang mga kahoy nga inuggatong sa halad, kag siya ang nagdala sang sundang kag pangsindi. ");
INSERT INTO hil_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Samtang nagalakat sila, nagsiling si Isaac, “Tay!” Nagsabat si Abraham, “Ano, anak?” Nagpamangkot si Isaac, “May dala kita nga pangsindi kag inuggatong, pero diin ang karnero nga inughalad?” ");
INSERT INTO hil_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Nagsabat si Abraham, “Anak, ang Dios ang magahatag sa aton sang karnero nga inughalad.” Kag nagpadayon sila sa paglakat. ");
INSERT INTO hil_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Sang pag-abot nila sa lugar nga ginsiling sang Dios, naghimo si Abraham sang halaran, kag ginplastar niya ang mga kahoy sa ibabaw sini. Dayon gin-gapos niya si Isaac kag gintungtong sa ibabaw sang halaran. ");
INSERT INTO hil_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Pagkatapos nagkuha siya sang sundang. Kag sang patyon na niya kuntani si Isaac, ");
INSERT INTO hil_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","gintawag siya sang anghel sang Ginoo halin sa langit, “Abraham! Abraham!” Pagkatapos nga nagsabat si Abraham, ");
INSERT INTO hil_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","nagsiling ang anghel, “Indi pagpatya ang bata! Karon napamatud-an ko na gid nga may kahadlok ka sa Dios tungod kay wala mo pag-ilikaw sa akon ang imo bugtong nga anak.” ");
INSERT INTO hil_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Pagbalikid ni Abraham, may nakita siya nga isa ka lalaki nga karnero nga ang iya sungay nasangit sa mga kahoy-kahoy, kag indi na ini makahalin. Gani ginkuha ini ni Abraham kag ginhalad bilang halad nga ginasunog sa baylo sang iya anak. ");
INSERT INTO hil_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Gintawag ni Abraham ato nga lugar “Nagatigana ang Ginoo.” Gani hasta subong may hulubaton nga nagasiling, “Sa Bukid sang Ginoo may ginatigana siya.” ");
INSERT INTO hil_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Nagtawag liwat kay Abraham ang anghel sang Ginoo halin sa langit. ");
INSERT INTO hil_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","17","Siling niya, “Amo ini ang ginasiling sang Ginoo: Nagapanumpa ako sa akon mismo kaugalingon nga pakamaayuhon ko gid ikaw tungod kay wala mo pag-ilikaw ang imo bugtong nga anak sa akon. Padamuon ko gid ang imo mga kaliwat nga daw pareho kadamo sa mga bituon sa langit kag sa mga balas sa baybayon. Pagasakupon nila ang mga banwa sang ila mga kaaway. ");
INSERT INTO hil_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Kag paagi sa imo mga kaliwat, pakamaayuhon ko ang tanan nga nasyon sa kalibutan, tungod kay nagtuman ka sa akon.” ");
INSERT INTO hil_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Pagkatapos sadto, nagbalik si Abraham kag si Isaac sa mga suluguon. Dayon nagkadto sila sa Beersheba kag didto na nag-estar. ");
INSERT INTO hil_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Sang ulihi nabalitaan ni Abraham nga si Nahor nga iya utod may mga anak na kay Milca: ");
INSERT INTO hil_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Si Uz ang magulang, sunod si Buz, kag dayon si Kemuel (nga amay ni Aram), ");
INSERT INTO hil_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","si Kesed, si Hazo, si Pildash, si Jidlaf, kag si Betuel. ");
INSERT INTO hil_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Sila nga walo amo ang mga anak ni Nahor kay Milca. Si Betuel amo ang amay ni Rebeka. ");
INSERT INTO hil_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","May mga anak man si Nahor sa isa pa niya ka asawa nga si Reuma. Sila amo sanday Teba, Gaham, Tahash kag Maaca. ");
INSERT INTO hil_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Nagkabuhi si Sara sing 127 ka tuig. ");
INSERT INTO hil_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Didto siya napatay sa Kiriat Arba (nga amo ang Hebron) sa duta sang Canaan. Puwerte gid ang pagpangasubo ni Abraham sa pagkapatay ni Sara. ");
INSERT INTO hil_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Karon, ginbayaan anay ni Abraham ang bangkay sang iya asawa kag nagpakigkita siya sa mga Hithanon kag nagsiling sa ila, ");
INSERT INTO hil_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Nagaestar ako diri sa inyo nga lugar nga isa ka pangayaw, gani kon mahimo pabakla man ninyo ako sang duta nga puwede ko malubngan sang akon asawa.” ");
INSERT INTO hil_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Nagsabat ang mga Hithanon, ");
INSERT INTO hil_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Sir, pamati anay sa amon. Ginakilala ka namon nga gamhanan nga tawo, gani puwede mo ilubong ang imo asawa bisan diin sa amon pinakamaayo nga mga lulubngan. Wala gid sing bisan isa sa amon nga mangindi sa paghatag sa imo sang lulubngan para malubong mo ang imo asawa.” ");
INSERT INTO hil_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Sa gilayon nagluhod si Abraham sa pagpasalamat sa atubangan sang mga pumuluyo nga mga Hithanon. ");
INSERT INTO hil_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Dayon nagsiling siya, “Kon sugot gid man kamo nga diri ko ilubong ang akon asawa, buligan ninyo ako nga hambalon si Efron nga anak ni Zohar ");
INSERT INTO hil_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","nga ibaligya niya sa akon ang iya kuweba nga ara sa higad sang iya uma sa Macpela. Hambala ninyo siya nga bayaran ko siya sa husto nga presyo diri mismo sa inyo atubangan para mangin akon na ina nga kuweba para himuon nga lulubngan.” ");
INSERT INTO hil_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ara gali si Efron nga nagapungko upod sang iya mga kasimanwa nga mga Hithanon. Gani nagsabat siya kay Abraham nga nabatian sang tanan nga Hithanon nga nagtipon didto sa may puwertahan sang banwa. ");
INSERT INTO hil_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Siling niya, “Sa atubangan sining akon mga kasimanwa ginahatag ko sa imo sir ang bilog nga uma pati ang kuweba. Gani puwede mo na ilubong ang imo asawa.” ");
INSERT INTO hil_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Nagluhod liwat si Abraham sa pagpasalamat sa atubangan sang mga pumuluyo. ");
INSERT INTO hil_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Dayon nagsiling siya kay Efron nga nabatian sang mga pumuluyo, “Pamatii bala ako. Bayaran ko ang bili sang uma. Batuna ang akon bayad para malubong ko na ang akon asawa didto.” ");
INSERT INTO hil_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Nagsabat si Efron, ");
INSERT INTO hil_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Sir, ang duta nagabili sing 400 ka bilog nga pilak. Kon sa bagay, kon bayaran mo, pila man lang ina para sa imo kag sa akon. Sige, ilubong na ang imo asawa.” ");
INSERT INTO hil_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Nagsugot si Abraham sa bili nga ginsiling ni Efron. Gani nagkilo siya sing 400 ka bilog nga pilak suno sa bug-at nga ginabasihan sadto sang mga negosyante. Kag ginbayad niya ini kay Efron didto sa atubangan sang mga Hithanon. ");
INSERT INTO hil_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Gani nangin iya na ni Abraham ang uma ni Efron sa Macpela, sa east sang Mamre, pati ang kuweba kag ang mga kahoy sa palibot sang uma. Saksi ang tanan nga Hithanon nga nagtipon didto sa puwertahan sang banwa. ");
INSERT INTO hil_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ginlubong dayon ni Abraham si Sara didto sa kuweba nga ara sa uma sa Macpela, nga sakop sang duta sang Canaan. Ang Macpela malapit sa Mamre nga amo ang Hebron. ");
INSERT INTO hil_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Gani ang uma pati ang kuweba, nga iya anay sang mga Hithanon, nangin iya na ni Abraham kag ginhimo niya ini nga lulubngan. ");
INSERT INTO hil_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Tigulang na gid katama si Abraham kag ginpakamaayo siya sang Ginoo sa tanan nga butang. ");
INSERT INTO hil_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Isa sadto ka adlaw, ginsilingan niya ang iya manugdumala nga suluguon nga nagaasikaso sang tanan niya nga pagkabutang, “Ibutang ang imo kamot sa tunga-tunga sang duha ko ka paa, ");
INSERT INTO hil_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","kag magsumpa ka sa akon sa ngalan sang Ginoo, ang Dios sang langit kag sang duta, nga indi ka magpili sang palangasaw-on sang akon anak nga si Isaac diri sa taga-Canaan nga kaupod ta nga nagaestar subong. ");
INSERT INTO hil_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Magkadto ka sa lugar nga akon ginhalinan, kag didto ka magpili sang babayi halin sa akon mga paryente nga ipaasawa sa akon anak nga si Isaac.” ");
INSERT INTO hil_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Pero nagpamangkot ang suluguon, “Ti, paano abi kon indi mag-upod ang babayi sa sini nga lugar? Dal-on ko na lang bala si Isaac didto?” ");
INSERT INTO hil_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Nagsabat si Abraham, “Indi gid pagdal-a si Isaac didto! ");
INSERT INTO hil_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Gindala ako diri sang Ginoo, ang Dios sang langit, halin sa panimalay sang akon amay, sa lugar nga sa diin ako natawo. Kag nagpanumpa siya nga ihatag niya ini nga duta sang Canaan sa akon mga kaliwat. Gani maglakat ka kay magapadala ang Ginoo sang iya anghel sa pag-upod sa imo para makakita ka didto sang palangasaw-on sang akon anak. ");
INSERT INTO hil_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kon indi mag-upod ang babayi sa imo, wala ka sing salabton sa sining sumpa mo sa akon. Pero indi lang pagdal-a didto ang akon anak.” ");
INSERT INTO hil_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Gani ginbutang sang suluguon ang iya kamot sa tunga-tunga sang duha ka paa ni Abraham nga iya amo, kag nagsumpa siya nga tumanon niya ang ginsugo sa iya. ");
INSERT INTO hil_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Pagkatapos nagkuha ang suluguon sang napulo ka camel kag mga malahalon nga pangregalo halin sa iya amo nga si Abraham. Naglakat dayon siya pakadto sa Aram Naharaim, ang banwa nga ginaestaran ni Nahor. ");
INSERT INTO hil_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Pag-abot sang suluguon sa banwa, ginpaluko niya ang mga camel malapit sa bubon sa guwa sang banwa. Sirom na sadto kag tion sang pagpanag-ob sang mga babayi. ");
INSERT INTO hil_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Nagpangamuyo ang suluguon, “Ginoo, Dios sang akon amo nga si Abraham, kabay pa nga patigayunon mo ang akon katuyuan diri, kag ipakita mo ang imo kaayo sa akon amo. ");
INSERT INTO hil_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nagatindog ako diri sa higad sang bubon samtang nagasag-ob ang mga babayi sang sini nga banwa. ");
INSERT INTO hil_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kon mangayo gani ako sang tubig sa tibod sang isa ka dalaga, kag magsugot siya nga paimnon ako pati ang akon mga camel, kabay pa nga siya ang babayi nga imo ginpili nga mangin asawa sang imo alagad nga si Isaac. Sa sini mahibaluan ko nga ginpakita mo ang imo kaayo sa akon amo nga si Abraham.” ");
INSERT INTO hil_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Wala pa siya makatapos pangamuyo, nag-abot si Rebeka nga may ginapas-an nga tibod. Si Rebeka anak ni Betuel, kag si Betuel anak ni Nahor kag ni Milca. Si Nahor utod ni Abraham. ");
INSERT INTO hil_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Matahom gid nga dalaga si Rebeka kag birhen pa. Nagdulhog siya pakadto sa bubon kag ginsudlan niya sang tubig ang iya tibod. Dayon nagsaka siya para magpuli. ");
INSERT INTO hil_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Nagdali-dali ang suluguon sa pagsugata sa iya kag nagsiling, “Palihog paimna ako sa imo tibod bisan diutay lang.” ");
INSERT INTO hil_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Nagsabat si Rebeka “Sige sir, inom ka.” Ginpaidalom niya dayon ang tibod kag gin-uyatan samtang nagainom ang suluguon. ");
INSERT INTO hil_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Pagkatapos niya painom sa suluguon, nagsiling siya, “Masag-ob man ako para sa imo mga camel hasta nga makainom sila tanan.” ");
INSERT INTO hil_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Dali-dali niya nga ginbubo ang tubig sa ilimnan sang mga sapat kag nagbalik siya sa bubon sa pagsag-ob liwat. Sige ang iya sag-ob hasta nga nakainom ang tanan nga camel. ");
INSERT INTO hil_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Nagapanilag lang ang suluguon kag ginahunahuna niya kon bala ginapatigayon na sang Ginoo ang iya katuyuan sa pagkadto sa sina nga lugar. ");
INSERT INTO hil_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Pagkatapos inom sang mga camel, ginpaguwa sang suluguon ang dala niya nga singsing nga bulawan nga ang kabug-aton mga anom ka gramo. Ginpaguwa man niya ang duha ka pulseras nga bulawan nga ang kabug-aton mga 120 ka gramo. Kag ginhatag niya ini kay Rebeka. ");
INSERT INTO hil_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Dayon nagpamangkot siya kay Rebeka, “Kay sin-o ka bata? May lugar pa bala sa inyo nga puwede namon matulugan karon nga gab-i?” ");
INSERT INTO hil_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nagsabat si Rebeka, “Bata ako ni Betuel nga anak nga lalaki ni Nahor kag ni Milca. ");
INSERT INTO hil_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","May matulugan kamo didto sa amon, kag may madamo man nga mga dagami kag kumpay para sa inyo mga camel.” ");
INSERT INTO hil_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Nagluhod dayon ang suluguon kag nagsimba sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Siling niya, “Dalayawon ang Ginoo, ang Dios sang akon amo nga si Abraham. Iya gid ginpakita ang iya padayon nga kaayo sa akon amo. Ako mismo gintuytuyan niya sa pagkadto sa mga paryente sang akon amo.” ");
INSERT INTO hil_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nagdalagan puli si Rebeka sa balay sang iya iloy kag ginsugid niya sa ila ang tanan nga natabo. ");
INSERT INTO hil_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ang iya utod nga si Laban didto man nagapamati sa ginasugid niya parte sa ginpanghambal sang tawo sa iya. Nakita mismo ni Laban ang singsing kag pulseras nga ginasuksok ni Rebeka. Gani nagdalagan siya pakadto sa bubon kag nagkadto sa tawo nga ginsiling ni Rebeka. Didto gihapon nagatindog ang tawo malapit sa bubon, sa tupad sang mga camel. ");
INSERT INTO hil_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Nagsiling si Laban sa iya, “Ikaw gali ang tawo nga ginapakamaayo sang Ginoo. Ngaa diri ka lang nagatindog? Dali sa balay, kay ginpreparar ko na ang kuwarto para sa inyo kag ang lugar para sa imo mga camel.” ");
INSERT INTO hil_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Nag-upod ang suluguon kay Laban. Pag-abot nila sa balay, ginkuha ni Laban ang mga karga sang mga camel kag ginhatagan niya dayon ang mga camel sang dagami kag kumpay. Gindal-an man niya sang tubig ang suluguon kag ang iya mga kaupod, para makapanghinaw sila sang ila mga tiil. ");
INSERT INTO hil_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Sang mabutangan na sila sang pagkaon, nagsiling ang suluguon, “Indi ako magkaon kon indi ko anay masugid ang akon katuyuan sa pagkadto diri.” Nagsabat si Laban, “Sige, sugiri kami.” ");
INSERT INTO hil_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Nagsiling siya, “Suluguon ako ni Abraham. ");
INSERT INTO hil_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ginpakamaayo sang Ginoo ang akon amo kag manggaranon na gid siya subong. Ginhatagan siya sang Ginoo sang madamo nga karnero, kanding, baka, camel, donkey, pilak, bulawan, kag ulipon nga lalaki kag babayi. ");
INSERT INTO hil_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Bisan tigulang na gid si Sara nga iya asawa, nakabata pa siya. Kag ining bata nila nga lalaki amo ang magapanubli sang tanan niya nga pagkabutang. ");
INSERT INTO hil_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ginpasumpa ako sang akon amo nga tumanon ko ang iya sugo nga nagasiling, ‘Indi ka magpili sang pangasaw-on sang akon anak diri sa mga taga-Canaan nga ang ila duta amo ang ginaestaran ta subong. ");
INSERT INTO hil_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Magkadto ka sa panimalay sang akon amay, kag didto ka magpili sang babayi halin sa akon mga paryente nga ipaasawa sa akon anak.’ ");
INSERT INTO hil_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Pero nagpamangkot ako, ‘Ti, paano abi kon indi mag-upod ang babayi sa akon?’ ");
INSERT INTO hil_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Nagsabat siya, ‘Ang Ginoo nga akon ginatuman permi magapadala sang iya anghel sa pag-upod sa imo para mapatigayon ang imo katuyuan didto. Makakita ka sang palangasaw-on sang akon anak halin sa akon mga paryente, sa panimalay sang akon amay. ");
INSERT INTO hil_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kon didto ka magkadto sa akon mga paryente, wala ka sing salabton sa sumpa mo sa akon kon indi nila pag-ipadala ang babayi sa imo.’ ");
INSERT INTO hil_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Gani pag-abot ko kaina sa bubon, nagpangamuyo ako. Siling ko, ‘Ginoo, Dios sang akon amo nga si Abraham, kabay pa nga patigayunon mo ang akon katuyuan sa pagkadto diri. ");
INSERT INTO hil_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Karon, nagatindog ako diri sa higad sang bubon. Kon may mag-abot gani nga dalaga nga magsag-ob, mangayo ako sang diutay lang nga tubig sa iya tibod. ");
INSERT INTO hil_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Kon magsugot gani siya nga paimnon ako pati ang akon mga camel, kabay pa nga siya ang babayi nga ginpili mo nga mangin asawa sang anak sang akon amo.’ ");
INSERT INTO hil_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Wala pa gani ako makatapos pangamuyo, nag-abot si Rebeka nga may ginapas-an nga tibod. Nagdulhog siya pakadto sa bubon kag nagsag-ob. Nagsiling ako sa iya, ‘Palihog paimna ako.’ ");
INSERT INTO hil_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ginpaidalom niya dayon ang tibod sa iya abaga, kag nagsiling, ‘Sige, inom ka, kag paimnon ko man ang imo mga camel.’ Gani nag-inom ako, kag dayon ginpainom man niya ang mga camel. ");
INSERT INTO hil_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Pagkatapos sadto, ginpamangkot ko siya kon kay sin-o siya bata. Nagsabat siya, ‘Kay Betuel nga anak nga lalaki ni Nahor kag ni Milca.’ Dayon ginbutangan ko sang singsing ang iya ilong kag ginsuksukan sang mga pulseras ang iya butkon. ");
INSERT INTO hil_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Nagluhod dayon ako kag nagsimba sa Ginoo. Gindayaw ko ang Ginoo, ang Dios sang akon amo nga si Abraham. Siya ang nagtuytoy sa akon sa husto nga lugar, nga sa diin nakita ko ang anak sang paryente sang akon amo nga mangin asawa sang iya anak. ");
INSERT INTO hil_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","“Karon, gusto ko mahibaluan kon ipakita ninyo ang inyo padayon nga kaayo sa akon amo paagi sa pagpaasawa kay Rebeka. Siling nga daan kamo para mahibaluan ko man kon ano ang akon himuon.” ");
INSERT INTO hil_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Nagsabat si Laban kag si Betuel, “Tungod kay ini kabubut-on sang Ginoo, wala na kami sing may masiling pa. ");
INSERT INTO hil_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ari si Rebeka, dal-a siya kon magpuli ka para mangin asawa siya sang anak sang imo amo, suno sa ginsiling sang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Pagkabati sadto sang suluguon, nagluhod siya kag nagsimba sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ginpaguwa niya dayon ang iya dala nga mga alahas nga pilak kag bulawan kag pati mga bayo, kag ginhatag kay Rebeka. Ginhatagan man niya sang malahalon nga mga regalo ang utod nga lalaki kag ang iloy ni Rebeka. ");
INSERT INTO hil_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Dayon nagkaon ang suluguon kag ang iya mga kaupod. Kag didto sila nagtulog sadto nga gab-i. Pagbugtaw nila pagkaaga, nagsiling ang suluguon, “Mapuli na ako sa akon amo.” ");
INSERT INTO hil_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Pero nagsabat ang utod kag ang iloy ni Rebeka, “Patinera anay diri si Rebeka sa amon bisan napulo lang ka adlaw, pagkatapos sina makalakat na kamo.” ");
INSERT INTO hil_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Pero nagsiling ang suluguon, “Indi man ninyo ako pagpadugaya diri. Ginpatigayon na sang Ginoo ang akon katuyuan sa pagkadto diri, gani pabalika na ninyo ako sa akon amo.” ");
INSERT INTO hil_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Nagsabat sila, “Tawgon ta anay si Rebeka kag pamangkuton kon ano sa iya.” ");
INSERT INTO hil_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Gani gintawag nila si Rebeka kag ginpamangkot, “Gusto mo bala nga mag-upod sa iya subong?” Nagsabat si Rebeka, “Huo, maupod ako.” ");
INSERT INTO hil_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Gani, ginpaupod nila si Rebeka pati ang iya manug-atipan sa suluguon ni Abraham kag sa iya mga kaupod. ");
INSERT INTO hil_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ginbendisyunan nila si Rebeka sa iya paglakat. Siling nila, “Utod namon, kabay pa nga magahalin sa imo ang madamo gid nga mga kaliwat. Kabay pa nga pierdihon sang imo mga kaliwat ang ila mga kaaway.” ");
INSERT INTO hil_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Sang handa na ang tanan, nagsakay si Rebeka kag ang iya mga suluguon nga babayi sa mga camel, kag nagsunod sila sa suluguon ni Abraham. ");
INSERT INTO hil_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Karon, si Isaac nga didto na nagaestar sa Negev bag-o lang nag-abot halin sa Beer Lahai Roi. ");
INSERT INTO hil_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Sang mga sirom na, nagguwa si Isaac kag naglakat-lakat sa latagon. May nakita siya nga mga camel nga nagapadulong. ");
INSERT INTO hil_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Sang makita ni Rebeka si Isaac, nagpanaog siya sa iya camel ");
INSERT INTO hil_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","kag nagpamangkot sa suluguon ni Abraham, “Sin-o inang tawo sa latagon nga nagapadulong sa aton?” Nagsabat ang suluguon, “Siya ang akon amo nga si Isaac.” Gani gintabunan ni Rebeka ang iya guya sang belo. ");
INSERT INTO hil_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ginsugid sang suluguon kay Isaac ang tanan niya nga ginhimo. ");
INSERT INTO hil_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Dayon gindala ni Isaac si Rebeka didto sa tolda nga gin-estaran sadto sang iya iloy nga si Sara. Nangin asawa niya si Rebeka kag palangga gid niya siya. Gani naumpawan si Isaac sa iya kasubo tungod sa pagkapatay sang iya iloy. ");
INSERT INTO hil_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nagpangasawa liwat si Abraham, kag ang ngalan sang iya asawa si Ketura. ");
INSERT INTO hil_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ang ila mga anak amo sila ni Zimran, Jokshan, Medan, Midian, Ishbak, kag Shua. ");
INSERT INTO hil_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Si Jokshan amo ang amay ni Sheba kag ni Dedan. Ang mga kaliwat ni Dedan amo ang mga Ashurnon, Letushnon, kag Leumnon. ");
INSERT INTO hil_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ang mga anak nga lalaki ni Midian amo sila ni Efa, Efer, Hanoc, Abida, kag Eldaa. Amo ini sila tanan ang mga kaliwat ni Ketura. ");
INSERT INTO hil_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Antes napatay si Abraham, ginbilin niya ang tanan niya nga pagkabutang kay Isaac. Pero ginhatagan niya sang mga regalo ang iban niya nga mga anak sa iban niya nga mga asawa, kag ginpaestar niya sila sa mga kadutaan sa east, palayo sa iya anak nga si Isaac. ");
INSERT INTO hil_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Nagkabuhi si Abraham sing 175 ka tuig. ");
INSERT INTO hil_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Napatay siya nga tigulang na gid, kag ginsimpon siya sa iya mga paryente nga nagkalamatay na. ");
INSERT INTO hil_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ginlubong siya sang iya mga anak nga si Isaac kag si Ishmael didto sa kuweba sa Macpela, sa east sang Mamre, sa uma nga iya anay ni Efron nga anak ni Zohar nga Hithanon. ");
INSERT INTO hil_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ato nga uma ginbakal ni Abraham sa presensya sang mga Hithanon. Didto ginlubong si Abraham kag ang iya asawa nga si Sara. ");
INSERT INTO hil_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Pagkatapos nga napatay si Abraham, ginbendisyunan sang Dios si Isaac kag didto siya nag-estar sa Beer Lahai Roi. ");
INSERT INTO hil_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Amo ini ang estorya parte sa pamilya ni Ishmael nga anak ni Abraham kay Hagar nga Egyptohanon, nga ulipon ni Sara. ");
INSERT INTO hil_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Amo ini ang mga ngalan sang mga anak nga lalaki ni Ishmael halin sa kamagulangan: Nebayot, Kedar, Adbeel, Mibsam, ");
INSERT INTO hil_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma, Masa, ");
INSERT INTO hil_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafish, kag Kedema. ");
INSERT INTO hil_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Sila ang mga anak ni Ishmael, kag nangin pangulo sila sang dose ka tribo nga mga kaliwat ni Ishmael. Ang ila mga ngalan amo ang ginpangalan sa mga lugar nga ila gin-estaran. ");
INSERT INTO hil_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Nagkabuhi si Ishmael sing 137 ka tuig. Napatay siya kag ginsimpon siya sa iya mga paryente nga nagkalamatay na. ");
INSERT INTO hil_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Nag-estar ang iya mga kaliwat sa mga lugar nga halin sa Havila hasta sa Shur, sa east sang Egypt nga pakadto sa Assyria. Ginkontra nila ang tanan nila nga mga paryente nga mga kaliwat ni Isaac. ");
INSERT INTO hil_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Amo ini ang estorya parte sa pamilya ni Isaac nga anak ni Abraham. ");
INSERT INTO hil_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Nagaedad si Isaac sing 40 ka tuig sang magpangasawa siya kay Rebeka nga anak ni Betuel nga Arameanhon nga taga-Padan Aram. Si Rebeka utod ni Laban nga Arameanhon man. ");
INSERT INTO hil_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Tungod kay baw-as si Rebeka, nagpangamuyo si Isaac sa Ginoo nga makabata siya. Ginsabat sang Ginoo ang iya pangamuyo, gani nagbusong si Rebeka. ");
INSERT INTO hil_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Nabatyagan niya nga nagadis-uganay ang kapid nga bata sa sulod sang iya tiyan. Nagsiling si Rebeka, “Ngaa amo ini ang nagakatabo sa akon?” Gani nagpamangkot siya sa Ginoo parte sini. ");
INSERT INTO hil_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Nagsiling ang Ginoo sa iya, “Magahalin sa duha ka bata nga ara sa imo tiyan ang duha ka nasyon; duha ka grupo sang mga katawhan nga magakontrahanay. Ang isa mangin gamhanan sang sa isa. Ang magulang magaalagad sa manghod.” ");
INSERT INTO hil_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Sang nagbata na si Rebeka, ang iya bata kapid. ");
INSERT INTO hil_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ang una nga nagguwa mapula-pula kag balahibuhon, gani gin-ngalanan nila siya nga Esau. ");
INSERT INTO hil_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Sang pagguwa sang ikaduha, ang iya kamot nagauyat sa tikod sang iya kapid, gani gin-ngalanan nila siya nga Jacob. Nagaedad si Isaac sang 60 ka tuig sang magbata si Rebeka sang kapid. ");
INSERT INTO hil_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Sang nagdako na ang duha ka bata, nangin maabtik nga mangangayam si Esau kag permi lang siya sa latagon samtang si Jacob ya hipuson nga tawo kag permi lang nagatiner sa mga tolda. ");
INSERT INTO hil_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Mas nagustuhan ni Isaac si Esau tungod kay gusto niya permi magkaon sang mga pinangayaman ni Esau, pero si Jacob amo ang mas nagustuhan ni Rebeka. ");
INSERT INTO hil_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Isa ka adlaw, samtang nagaluto si Jacob sang sopas, nag-abot si Esau halin sa pagpangayam nga gutom gid katama. ");
INSERT INTO hil_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Nagsiling siya kay Jacob, “Abi, pakan-a ako sinang ginaluto mo nga mapula kay gutom gid ako katama.” (Amo ina nga gintawag si Esau nga Edom.) ");
INSERT INTO hil_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Pero nagsabat si Jacob, “Hatagan ko ikaw sini kon ihatag mo sa akon ang imo kinamatarong bilang magulang.” ");
INSERT INTO hil_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Nagsiling si Esau, “Sige, kay anhon ko man ina nga kinamatarong kon mapatay man lang ako sa kagutom.” ");
INSERT INTO hil_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Nagsabat si Jacob, “Kon amo sina, magsumpa ka anay sa akon.” Gani nagsumpa si Esau nga mangin iya na ni Jacob ang iya kinamatarong bilang magulang. ");
INSERT INTO hil_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ginhatagan dayon siya ni Jacob sang tinapay kag sopas. Pagkatapos niya kaon kag inom, naglakat siya dayon. Sa sadtong ginhimo ni Esau, ginbaliwala niya ang iya kinamatarong bilang magulang. ");
INSERT INTO hil_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","May gutom nga nag-abot sa lugar nga ginaestaran ni Isaac, wala labot sadtong gutom nga nag-abot sang panahon pa ni Abraham. Gani nagkadto si Isaac kay Abimelec nga hari sang mga Filistinhon sa Gerar. ");
INSERT INTO hil_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nagpakita ang Ginoo sa iya kag nagsiling, “Indi ka magkadto sa Egypt; magpabilin ka sa lugar nga itudlo ko sa imo. ");
INSERT INTO hil_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Diri ka lang anay mag-estar kay pagaupdan ko ikaw kag pakamaayuhon. Ihatag ko sa imo kag sa imo mga kaliwat ini tanan nga duta. Tumanon ko ang akon ginpromisa sa imo amay nga si Abraham. ");
INSERT INTO hil_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Padamuon ko ang imo mga kaliwat pareho sa kadamuon sang mga bituon sa langit, kag ihatag ko sa ila ini tanan nga duta. Kag paagi sa ila, pakamaayuhon ko ang tanan nga katawhan sa kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Himuon ko ini tungod kay nagtuman si Abraham sa akon. Nagtuman siya sa tanan ko nga kasuguan kag pagpanudlo.” ");
INSERT INTO hil_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Gani didto nag-estar si Isaac sa Gerar. ");
INSERT INTO hil_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Matahom si Rebeka, gani kon magpamangkot ang mga taga-Gerar sa kay Isaac parte sa iya asawa ginasabat niya nga utod niya si Rebeka. Nahadlok siya magsiling nga asawa niya kay basi kon patyon nila siya para makuha si Rebeka. ");
INSERT INTO hil_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Madugay-dugay na ang pagtiner nila ni Isaac didto sa Gerar. Kag isa sina ka adlaw, natabuan nga nagpamintana si Abimelec nga hari sang mga Filistinhon kag nakita niya nga nagaanggaanay si Isaac kag Rebeka. ");
INSERT INTO hil_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Gani ginpatawag niya si Isaac kag ginsilingan, “Asawa mo gali siya? Ngaa nagsiling ka nga utod mo siya?” Nagsabat si Isaac, “Nahadlok abi ako nga basi patyon ninyo ako tungod sa iya.” ");
INSERT INTO hil_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Nagsiling si Abimelec, “Indi maayo ang ginhimo mo sa amon. Kon natabo abi nga ang isa sa akon mga tinawo naghulid sa iya, ikaw kuntani ang kabangdanan sang amon pagpakasala.” ");
INSERT INTO hil_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ginpaandaman dayon ni Abimelec ang tanan nga tawo. Siling niya, “Ang bisan sin-o nga maghimo sang malain sa sini nga lalaki ukon sa iya asawa pagapatyon gid.” ");
INSERT INTO hil_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nagpananom si Isaac sa sadto nga lugar kag nakapatubas siya sing 100 ka pilo sa sina mismo nga tuig, tungod kay ginpakamaayo siya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Nagpadayon ang iya pag-uswag hasta nga nagmanggaranon na gid siya katama. ");
INSERT INTO hil_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Nahisa sa iya ang mga Filistinhon tungod kay madamo na ang iya mga karnero, kanding, baka, kag mga suluguon. ");
INSERT INTO hil_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ginpangtampukan nila sang duta ang mga bubon nga ginpangkutkot sadto sang mga suluguon sang iya amay nga si Abraham. ");
INSERT INTO hil_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Karon, nagsiling si Abimelec kay Isaac, “Halin ka na diri, kay madamo na kamo katama para sa amon.” ");
INSERT INTO hil_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Gani naghalin si Isaac, kag nagpatindog siya sang iya tolda sa Gerar nga ililigan sang tubig, kag didto na nag-estar. ");
INSERT INTO hil_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ginpakutkutan niya liwat ang mga bubon sang iya amay nga si Abraham nga gintabunan sang mga Filistinhon pagkatapos nga napatay si Abraham. Gin-ngalanan ni Isaac ang mga bubon sang amo man gihapon nga ngalan nga ginhatag sadto anay ni Abraham. ");
INSERT INTO hil_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Didto sa hubas nga ililigan sang tubig, nagkutkot sang bag-o nga bubon ang mga suluguon ni Isaac kag nakasapo sila sang tuburan. ");
INSERT INTO hil_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Pero ginbais sang mga bakiro nga taga-Gerar ang mga bakiro ni Isaac nga ila kuno atong bubon. Gani gin-ngalanan ni Isaac ang bubon nga Esek, tungod kay nagpakigbais ang mga taga-Gerar sa iya. ");
INSERT INTO hil_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Nagkutkot liwat ang mga suluguon ni Isaac sang lain nga bubon, pero ginlalisan man nila ini gihapon sang mga taga-Gerar. Gani gin-ngalanan ni Isaac ang bubon nga Sitna. ");
INSERT INTO hil_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Naghalin sila ni Isaac didto kag nagkutkot liwat sang lain pa gid nga bubon. Wala na nila ini paglalisi, gani gin-ngalanan ini ni Isaac nga Rehobot. Kay siling niya, “Karon ginhatagan kita sang Ginoo sang malapad nga lugar para magdamo pa gid kita diri.” ");
INSERT INTO hil_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Sang ulihi naghalin si Isaac sa sadto nga lugar kag nagkadto sa Beersheba. ");
INSERT INTO hil_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Sadto gid nga gab-i sang pag-abot niya, nagpakita ang Ginoo sa iya kag nagsiling, “Ako ang Dios sang imo amay nga si Abraham. Indi ka magkahadlok kay kaupod mo ako. Pakamaayuhon ko ikaw kag hatagan sang madamo nga kaliwat tungod kay Abraham nga akon alagad.” ");
INSERT INTO hil_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Gani naghimo si Isaac sang halaran kag nagsimba sa Ginoo. Nagpatindog siya sang tolda sa sadto nga lugar kag nagpakutkot sang bubon sa iya mga suluguon. ");
INSERT INTO hil_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Nagkadto si Abimelec kay Isaac halin sa Gerar kaupod si Ahuzat nga iya manuglaygay kag si Ficol nga pangulo sang iya mga soldado. ");
INSERT INTO hil_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Nagpamangkot si Isaac sa ila, “Ngaa nagkadto kamo sa akon? Indi bala nga akig kamo sa akon, kag amo gani nga ginpahalin ninyo ako sa inyo lugar?” ");
INSERT INTO hil_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Nagsabat sila, “Nareyalisar namon nga ang Ginoo kaupod mo, gani naghunahuna kami nga dapat maghimo kita sang kasugtanan nga may panumpa. Ipromisa mo sa amon ");
INSERT INTO hil_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","nga indi mo kami pag-anhon, tungod kay wala ka man namon pag-anha sang didto ka pa sa amon. Gintratar ka namon sing maayo kag ginpahalin nga maayo ang aton relasyon. Karon, kabay pa nga pakamaayuhon ka pa gid sang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Gani nagpapunsyon si Isaac para sa ila kag nagkinaon sila kag nag-ininom. ");
INSERT INTO hil_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Aga pa gid sang sunod nga adlaw, nagpanumpa sila sa isa kag isa. Dayon ginpalakat sila ni Isaac nga maayo ang ila relasyon. ");
INSERT INTO hil_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Sadto man nga adlaw, nag-abot ang mga suluguon ni Isaac kag nagsugid sa iya nga may tubig ang bubon nga ila ginkutkot. ");
INSERT INTO hil_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Gin-ngalanan ni Isaac ato nga bubon nga Shiba. Gani hasta subong ang ato nga lugar ginatawag nga Beersheba. ");
INSERT INTO hil_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Sang nagaedad na si Esau sang 40 ka tuig, nagpangasawa siya kay Judit nga anak ni Beeri nga Hithanon. Ginpangasawa pa gid niya si Basemat nga anak ni Elon nga Hithanon man. ");
INSERT INTO hil_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ining duha ka babayi nakapasubo gid sa kay Isaac kag kay Rebeka. ");
INSERT INTO hil_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Tigulang na gid si Isaac kag halos indi na makakita. Isa sadto ka tion, gintawag niya ang kamagulangan niya nga anak nga si Esau. Siling niya, “Anak.” Nagsabat si Esau, “Ano, tay?” ");
INSERT INTO hil_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Nagsiling si Isaac, “Tigulang na gid ako kag sa indi siguro madugay mapatay na ako. ");
INSERT INTO hil_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Maayo pa nga kuhaon mo ang imo pana kag magkadto ka sa latagon kag magpangayam para sa akon. ");
INSERT INTO hil_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Dayon, lutui ako sang akon paborito nga pagkaon kag dal-on mo dayon sa akon kay kaunon ko. Pagkatapos bendisyunan ko ikaw sa wala pa ako mapatay.” ");
INSERT INTO hil_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Nagapamati gali si Rebeka samtang nagahambal si Isaac kay Esau. Gani sang nakalakat na si Esau sa latagon sa pagpangayam, ");
INSERT INTO hil_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ginsilingan ni Rebeka ang iya anak nga si Jacob, “Nabatian ko nga ginsilingan ni tatay mo si Esau nga ");
INSERT INTO hil_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","magpangayam kag lutuan siya dayon sang iya paborito nga pagkaon. Kay sa wala pa kuno siya mapatay bendisyunan niya si Esau sa presensya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Gani anak, tumana ang akon isugo sa imo: ");
INSERT INTO hil_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kadto didto sa aton mga kasapatan kag magkuha ka sang duha ka bataon kag matambok nga kanding, kay lutuan ko ang imo amay sang paborito niya nga pagkaon. ");
INSERT INTO hil_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Dayon dal-on mo ini sa iya para bendisyunan ka niya sa wala pa siya mapatay.” ");
INSERT INTO hil_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Pero nagsiling si Jacob sa iya iloy, “Nakahibalo ka nga balahibuhon si Esau kag ako ya indi. ");
INSERT INTO hil_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Basi hikapon ako ni tatay kag mahibaluan niya nga ginatunto ko lang siya kag pakamalauton niya ako imbes nga bendisyunan.” ");
INSERT INTO hil_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nagsabat si Rebeka, “Anak, ako ang manabat kon pakamalauton ka, basta himua lang ang akon ginasugo sa imo. Lakat na kag kuhai ako sang kanding.” ");
INSERT INTO hil_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Gani nagkuha si Jacob sang duha ka kanding kag gindala niya sa iya iloy, kag ginluto ni Rebeka ang paborito nga pagkaon ni Isaac. ");
INSERT INTO hil_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Dayon ginkuha niya ang pinakamaayo nga bayo ni Esau nga didto sa balay kag ginpasuksok kay Jacob. ");
INSERT INTO hil_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ginbutangan niya sang panit sang kanding ang butkon ni Jacob pati ang iya liog nga indi balahibuhon. ");
INSERT INTO hil_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Dayon ginhatag niya kay Jacob ang pagkaon kag ang tinapay nga ginluto niya. ");
INSERT INTO hil_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Gindala ato ni Jacob sa iya amay kag nagsiling, “Tay!” Nagsiling si Isaac, “Sin-o ka nga anak ko?” ");
INSERT INTO hil_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Nagsabat si Jacob, “Ako si Esau, ang kamagulangan mo nga anak. Nahimo ko na ang imo ginsugo sa akon. Bangon anay kag magkaon sining akon pinangayaman para mabendisyunan mo ako.” ");
INSERT INTO hil_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Nagsiling si Isaac, “Anak, paano mo ini nakuha dayon?” Nagsabat si Jacob, “Ginbuligan ako sang Ginoo nga imo Dios.” ");
INSERT INTO hil_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Nagsiling si Isaac, “Palapit pa gid sa akon anak para mahikap ko kon ikaw gid bala matuod si Esau.” ");
INSERT INTO hil_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Gani nagpalapit si Jacob, kag ginhikap siya sang iya amay kag nagsiling, “Ang imo tingog daw iya ni Jacob pero ang imo butkon daw iya ni Esau.” ");
INSERT INTO hil_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Wala ni Isaac makilal-i si Jacob, kay ang iya butkon balahibuhon pareho sang iya ni Esau. Antes niya ginbendisyunan si Jacob, ");
INSERT INTO hil_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","nagpamangkot pa gid siya, “Ikaw gid bala matuod si Esau?” Nagsabat si Jacob, “Huo, ako gid.” ");
INSERT INTO hil_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Nagsiling si Isaac, “Abi, dal-a diri ang imo ginluto halin sa imo pinangayaman, kay pagkatapos ko kaon bendisyunan ko ikaw.” Gani ginhatagan siya ni Jacob sang pagkaon kag ilimnon, kag nagkaon siya kag nag-inom. ");
INSERT INTO hil_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Dayon nagsiling si Isaac sa iya, “Palapit sa akon, anak, kag haluki ako.” ");
INSERT INTO hil_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Nagpalapit si Jacob sa iya kag naghalok. Sang nasimhutan ni Isaac ang iya bayo, ginbendisyunan niya dayon si Jacob nga nagasiling, “Ining baho sang akon anak pareho sa baho sang latagon nga ginbendisyunan sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kabay pa nga hatagan ka sang Dios sang mapatubason nga duta nga permi may tun-og nga grasya niya, para bugana ang imo mga uyas kag duga sang ubas. ");
INSERT INTO hil_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kabay pa nga magapasakop sa imo ang madamo nga katawhan kag magaalagad sila sa imo. Kabay pa nga magagahom ka sa imo mga paryente kag magapasakop sila sa imo. Kabay pa nga ang nagapakamalaot sa imo pakamalauton man, kag ang nagapakamaayo sa imo pakamaayuhon man.” ");
INSERT INTO hil_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Pagkatapos bendisyon ni Isaac kay Jacob, naglakat dayon si Jacob. Bag-o lang gid siya nakalakat kag umabot man dayon si Esau halin sa pagpangayam. ");
INSERT INTO hil_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nagluto man siya sang manamit nga pagkaon kag iya ini gindala sa iya amay. Nagsiling siya, “Tay, bangon ka kag magkaon sining akon pinangayaman para mabendisyunan mo ako.” ");
INSERT INTO hil_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Nagpamangkot si Isaac sa iya, “Sin-o ka?” Nagsabat siya, “Ako si Esau, ang kamagulangan mo nga anak.” ");
INSERT INTO hil_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Pagkabati sadto ni Isaac, nagpalangurog siya kag nagsiling, “Sin-o gali atong nagpangayam kag nagdala diri sa akon sang pagkaon? Bag-o ko pa lang ato ginkaon kag umabot ka dayon. Ginhatag ko na sa iya ang akon bendisyon kag indi ko na gid ato mabawi.” ");
INSERT INTO hil_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Pagkabati sadto ni Esau, puwerte gid ang iya hilibion. Siling niya, “Tay, bendisyuni man ako!” ");
INSERT INTO hil_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Pero nagsabat si Isaac, “Gintunto ako sang imo manghod kag nakuha na niya ang akon bendisyon nga para kuntani sa imo.” ");
INSERT INTO hil_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Nagsiling si Esau, “Ikaduha na ini ka beses nga iya ako gintunto. Gai ko man nga Jacob ang iya ngalan. Ginkuha na niya ang akon kinamatarong bilang magulang, kag karon ginkuha pa gid niya ang bendisyon nga para sa akon.” Dayon nagpamangkot siya, “Tay, wala ka na gid bala sing nabilin nga bendisyon para sa akon?” ");
INSERT INTO hil_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Nagsabat si Isaac, “Ginhimo ko na siya nga imo agalon kag ginhimo ko man ang tanan niya nga mga paryente nga iya mga suluguon. Nahatag ko na sa iya ang bugana nga mga uyas kag duga sang ubas. Gani ano pa ang akon mahimo para sa imo anak?” ");
INSERT INTO hil_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Nagpakitluoy pa gid si Esau sa iya amay, “Tay, wala ka na gid bala sing bisan isa lang ka bendisyon? Bendisyuni man ko bi.” Kag naghibi pa gid siya. ");
INSERT INTO hil_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Nagsiling si Isaac sa iya, “Indi mapatubason ang duta nga imo pagaestaran, kag wala ini permi sang tun-og nga grasya sang Dios. ");
INSERT INTO hil_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Permi ka lang magapakig-away, kag magaalagad ka sa imo manghod. Pero kon magpamatok ka sa iya, mahilway ka sa iya gahom.” ");
INSERT INTO hil_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Gindumtan ni Esau si Jacob tungod sa bendisyon nga ginhatag sang iya amay kay Jacob. Nagsiling si Esau sa iya kaugalingon, “Dali na lang mapatay si tatay; kon mapatay na gani siya, patyon ko si Jacob.” ");
INSERT INTO hil_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Pero nabalitaan ni Rebeka ang plano ni Esau, gani ginpatawag niya si Jacob kag ginhambalan, “Ang imo magulang nga si Esau nagaplano sa pagpatay sa imo para maumpawan siya sa iya kaakig sa imo. ");
INSERT INTO hil_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Gani pamati ka sa akon isiling: Magpalagyo ka sa Haran, didto sa akon utod nga si Laban. ");
INSERT INTO hil_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Didto ka lang anay hasta nga maghaganhagan ang kaakig sang imo magulang, ");
INSERT INTO hil_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","kag malipatan na niya ang imo ginhimo sa iya. Ipasugat ko lang ugaling ikaw didto kon indi na siya akig sa imo. Indi ko gusto nga madula kamo nga duha sa akon sa isa lang ka adlaw.” ");
INSERT INTO hil_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Karon, nagsiling si Rebeka kay Isaac, “Ginatak-an na gid ako sang akon kabuhi tungod sining mga asawa ni Esau nga mga Hithanon. Kon ang mangin asawa ni Jacob taga-diri man nga babayi nga Hithanon maayo pa nga mapatay na lang ako.” ");
INSERT INTO hil_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Gani ginpatawag ni Isaac si Jacob. Pag-abot niya, ginbendisyunan niya siya kag ginmanduan, “Indi ka gid magpangasawa sang taga-Canaan. ");
INSERT INTO hil_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Maghimos ka kag magkadto sa Padan Aram, didto kay lolo mo Betuel nga amay sang imo iloy. Pangasaw-a didto ang isa sa mga dalaga nga anak ni Laban nga utod sang imo iloy. ");
INSERT INTO hil_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kabay pa nga pakamaayuhon ka sang Makagagahom nga Dios kag hatagan sang madamo nga kaliwat para mangin amay ka sang madamo nga grupo sang mga katawhan. ");
INSERT INTO hil_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kabay pa nga ihatag man niya sa imo kag sa imo mga kaliwat ang pagpakamaayo nga ginhatag niya kay Abraham, para mangin imo ini nga duta nga imo ginaestaran subong bilang pangayaw. Ini nga duta ginhatag sang Dios kay Abraham.” ");
INSERT INTO hil_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ginpalakat dayon ni Isaac si Jacob sa Padan Aram, sa lugar ni Laban nga anak ni Betuel nga Arameanhon. Si Laban utod ni Rebeka nga iloy ni Jacob kag ni Esau. ");
INSERT INTO hil_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Nahibaluan ni Esau nga ginbendisyunan ni Isaac si Jacob kag ginpakadto sa Padan Aram para didto mangita sang palangasaw-on. Nahibaluan man niya nga sang pagbendisyon ni Isaac kay Jacob, ginmanduan niya siya nga indi magpangasawa sang taga-Canaan. ");
INSERT INTO hil_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Kag nahibaluan man niya nga nagtuman si Jacob sa ila ginikanan kag nagkadto sa Padan Aram. ");
INSERT INTO hil_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Gani natalupangdan ni Esau nga indi gali gusto sang iya amay ang mga babayi nga taga-Canaan. ");
INSERT INTO hil_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Gani nagkadto siya sa iya tiyo nga si Ishmael nga anak ni Abraham kay Hagar. Luwas sang iya duha ka asawa, ginpangasawa pa gid niya si Mahalat nga anak ni Ishmael kag utod ni Nebayot. ");
INSERT INTO hil_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Naghalin si Jacob sa Beersheba kag naglakat pakadto sa Haran. ");
INSERT INTO hil_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Sang nagsalop na ang adlaw, nakaabot siya sa isa ka lugar kag didto siya nagpabilin sadto nga gab-i. Nagkuha siya sang isa ka bato kag iya gin-unlan sa iya pagtulog. ");
INSERT INTO hil_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Karon, nagdamgo siya nga may isa ka hagdan nga nagatindog sa duta nga lambot hasta sa langit. Nakita niya ang mga anghel sang Dios nga nagasaka-panaog sa hagdan. ");
INSERT INTO hil_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nakita man niya ang Ginoo nga nagatindog sa ibabaw sang hagdan kag nagsiling sa iya, “Ako amo ang Ginoo, ang Dios ni Abraham kag ni Isaac. Ihatag ko sa imo kag sa imo mga kaliwat ini nga duta nga imo ginahigdaan. ");
INSERT INTO hil_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ang imo mga kaliwat mangin pareho kadamo sang yab-ok sa duta. Magalapta sila sa nagkalain-lain nga parte sang sini nga duta. Paagi sa imo kag sa imo mga kaliwat, pakamaayuhon ko ang tanan nga katawhan sa kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Tandai gid permi nga kaupod mo ako kag bantayan ko ikaw bisan diin ka makadto. Pabalikon ko ikaw sa sini nga duta kag indi ko ikaw pagbayaan hasta nga matuman ko ang akon promisa sa imo.” ");
INSERT INTO hil_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Nakabugtaw dayon si Jacob kag nagsiling sa iya kaugalingon, “Wala ako kahibalo nga ari gali diri ang Ginoo sa sini nga lugar.” ");
INSERT INTO hil_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Kinulbaan siya kag nagsiling, “Daw ano ka makatilingala ang ini nga lugar! Puluy-an ini sang Dios kag diri mismo ang puwertahan pakadto sa langit.” ");
INSERT INTO hil_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Aga pa gid nagbangon si Jacob. Ginkuha niya ang bato nga iya gin-unlan kag ginpatindog bilang isa ka handumanan. Dayon ginbubuan niya ini sang lana para mangin sagrado. ");
INSERT INTO hil_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Gin-ngalanan ni Jacob ato nga lugar nga Betel. Pero sang una, Luz ang ngalan sang ato nga lugar. ");
INSERT INTO hil_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nagsumpa dayon si Jacob nga nagasiling, “O Dios, kon updan mo ako kag bantayan sa sining akon pagpanglakaton kag hatagan sang pagkaon kag bayo, ");
INSERT INTO hil_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","kag kon makabalik ako sa balay sang akon amay nga wala sing malain nga natabo sa akon, kilalahon ko ikaw, Ginoo, nga akon Dios. ");
INSERT INTO hil_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ining bato nga akon ginpatindog bilang isa ka handumanan magapamatuod sang imo presensya sa sini nga lugar. Kag ihatag ko sa imo ang ikanapulo sang tanan nga ihatag mo sa akon.” ");
INSERT INTO hil_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Nagpadayon si Jacob sa iya pagpanglakaton hasta nga nakaabot siya sa duta sang mga taga-east. ");
INSERT INTO hil_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Didto may nakita siya sa latagon nga isa ka bubon nga sa tupad sini may nagaluko nga tatlo ka panong sang mga karnero, kay didto nagakuha ang mga tawo sang tubig nga ipainom sa mga karnero. Ini nga bubon ginatakpan sang dako nga bato. ");
INSERT INTO hil_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ginahulat anay sang mga manugbantay sang karnero nga makatipon ang tanan nga karnero antes nila paligiron ang takop nga bato. Pagkatapos nila painom sang mga karnero, ginauli nila ang bato. ");
INSERT INTO hil_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Karon, nagpamangkot si Jacob sa mga manugbantay sang karnero, “Mga abyan, taga-diin kamo?” Nagsabat sila, “Taga-Haran.” ");
INSERT INTO hil_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Nagpamangkot liwat si Jacob, “Kilala bala ninyo si Laban nga apo ni Nahor?” Nagsabat sila, “Huo, kilala namon.” ");
INSERT INTO hil_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Nagpadayon sa pagpamangkot si Jacob, “Ti, kamusta siya?” Nagsabat sila, “Maayo man. Tan-awa, ara ang iya anak nga si Raquel nga nagapakadto diri upod sang mga karnero.” ");
INSERT INTO hil_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Nagsiling si Jacob sa ila, “Tungod kay temprano pa man kag indi pa tion sa pagtipon sang mga karnero, maayo siguro nga paimnon ninyo sila kag pahalbon liwat.” ");
INSERT INTO hil_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nagsabat sila, “Indi namon ina mahimo kon indi anay matipon ang tanan nga karnero. Kon diri na gani ang tanan, amo na ina ang pagpaligid namon sa takop nga bato para paimnon sila.” ");
INSERT INTO hil_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Nagahambal pa si Jacob sa ila sang mag-abot si Raquel dala ang mga karnero sang iya amay, tungod kay siya ang nagabantay sini. ");
INSERT INTO hil_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Pagkakita ni Jacob kay Raquel nga anak sang iya tiyo nga si Laban, kaupod sang mga karnero ni Laban, nagkadto siya sa bubon kag ginpaligid niya ang bato kag ginpainom ang mga karnero sang iya tiyo nga si Laban. ");
INSERT INTO hil_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Pagkatapos ginhalukan niya si Raquel kag naghibi siya sa kalipay. ");
INSERT INTO hil_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Nagsiling siya kay Raquel, “Bata ako ni Rebeka, gani hinablos ako ni tatay mo.” Nagdalagan puli si Raquel kag ginsugiran ang iya amay. ");
INSERT INTO hil_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Pagkabati ni Laban nga ara si Jacob nga iya hinablos kay Rebeka, nagdali-dali siya sa pagsugata sa iya. Ginhakos niya si Jacob kag ginhalukan kag gindala sa ila balay. Kag didto ginsugid ni Jacob kay Laban ang tanan nga nagkalatabo. ");
INSERT INTO hil_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Nagsiling si Laban sa iya, “Matuod gid nga magkadugo kita.” Pagkaligad sang isa ka bulan nga pagtiner ni Jacob sa ila ni Laban, ");
INSERT INTO hil_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","nagsiling si Laban sa iya, “Indi maayo nga mag-obra ka para sa akon nga wala sing suhol tungod lang kay hinablos ko ikaw. Sugiri ako kon ano ang gusto mo nga isuhol ko sa imo.” ");
INSERT INTO hil_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","May duha ka anak si Laban nga dalaga. Si Lea ang magulang kag si Raquel ang manghod. ");
INSERT INTO hil_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Manami ang mata ni Lea, pero mas guwapa kag manami sang lawas si Raquel. ");
INSERT INTO hil_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Tungod kay naluyag si Jacob kay Raquel, nagsiling siya kay Laban, “Magaserbisyo ako sa imo sing pito ka tuig kon ipaasawa mo sa akon si Raquel.” ");
INSERT INTO hil_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Nagsabat si Laban, “Mas maayo pa nga sa imo ko siya ipaasawa sang sa iban nga lalaki. Pabilin ka lang diri.” ");
INSERT INTO hil_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Gani nagserbisyo si Jacob kay Laban sing pito ka tuig para lang mapangasawa niya si Raquel. Tungod sa iya paghigugma kay Raquel daw pila lang ka adlaw sa iya ang pito ka tuig. ");
INSERT INTO hil_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Pagkaligad sang pito ka tuig, nagsiling si Jacob kay Laban, “Natapos na ang akon pagserbisyo sa imo, gani ihatag na sa akon si Raquel para mag-upod na kami.” ");
INSERT INTO hil_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Nagsugot si Laban, gani naghiwat siya sang punsyon kag gin-imbitar niya ang tanan nga tawo sa sina nga lugar. ");
INSERT INTO hil_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Pero pagkagab-i, imbes nga si Raquel ang dal-on ni Laban kay Jacob, si Lea ang iya gindala. Kag naghulid si Jacob kay Lea. ");
INSERT INTO hil_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Ginhatag ni Laban kay Lea ang iya ulipon nga babayi nga si Zilpa para mangin ulipon ni Lea.) ");
INSERT INTO hil_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Pagkaaga, nahibaluan ni Jacob nga si Lea gali ang iya kahulid. Gani ginkadtuan niya si Laban kag ginsilingan, “Ngaa ginhimo mo ini sa akon? Nagserbisyo ako sa imo para mapangasawa ko si Raquel. Karon ngaa nga gintunto mo ako?” ");
INSERT INTO hil_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Nagsabat si Laban, “Indi ina kinabatasan diri sa amon lugar nga ipaasawa ang manghod una sa magulang. ");
INSERT INTO hil_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Hulata lang nga matapos ang isa ka semana nga pagsaulog sining kasal kay ipaasawa ko dayon sa imo si Raquel, ina kon magserbisyo ka liwat sa akon sing pito pa gid ka tuig.” ");
INSERT INTO hil_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Nagsugot si Jacob sa ginsiling ni Laban. Pagkatapos sang isa ka semana nga pagsaulog sang kasal nila ni Lea, ginpaasawa ni Laban sa iya si Raquel. ");
INSERT INTO hil_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Ginhatag ni Laban kay Raquel ang iya ulipon nga babayi nga si Bilha para mangin ulipon ni Raquel.) ");
INSERT INTO hil_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Gani naghulid man si Jacob kay Raquel. Mas palangga niya si Raquel sang sa kay Lea. Nagserbisyo si Jacob kay Laban sing pito pa gid ka tuig. ");
INSERT INTO hil_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Nakita sang Ginoo nga indi palangga ni Jacob si Lea, gani ginbuot niya nga makapamata si Lea, pero si Raquel ya indi. ");
INSERT INTO hil_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Nagbusong si Lea kag nagbata sing lalaki kag gin-ngalanan niya nga Reuben, kay siling niya, “Nakita sang Ginoo ang akon kalisod, kag karon sigurado nga higugmaon na ako sang akon bana.” ");
INSERT INTO hil_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Nagbusong siya liwat kag nagbata sing isa naman ka lalaki. Nagsiling siya, “Ginhatagan liwat ako sang Ginoo sing isa ka anak nga lalaki kay nakabati siya nga wala ako ginahigugma sang akon bana.” Gani gin-ngalanan niya ang bata nga Simeon. ");
INSERT INTO hil_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nagbusong liwat si Lea kag nagbata sing isa pa gid ka lalaki. Nagsiling siya, “Karon mangin malapit na sa akon ang akon bana kay tatlo na ang amon anak nga lalaki.” Gani gin-ngalanan niya ang bata nga Levi. ");
INSERT INTO hil_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nagbusong pa gid liwat si Lea kag nagbata sing isa naman ka lalaki. Nagsiling siya, “Karon dayawon ko ang Ginoo.” Gani gin-ngalanan niya ang bata nga Juda. Halin sadto, wala na siya nakapamata. ");
INSERT INTO hil_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Si Raquel wala gihapon nagbusong, gani nahisa siya kay Lea. Nagsiling siya kay Jacob, “Hatagi ako sang anak kay kon indi, mapatay gid ako!” ");
INSERT INTO hil_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Naakig si Jacob sa iya kag ginsilingan siya, “Ngaa, Dios ako haw? Siya ang nagbuot nga indi ka makabata.” ");
INSERT INTO hil_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Nagsiling si Raquel, “Kon amo sina, maghulid ka kay Bilha nga akon suluguon agod bisan paagi na lang sa iya makabaton man ako sang anak.” ");
INSERT INTO hil_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Gani ginhatag niya si Bilha kay Jacob bilang asawa, kag naghulid si Jacob kay Bilha. ");
INSERT INTO hil_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Sang ulihi nagbusong si Bilha kag nagbata sing lalaki. ");
INSERT INTO hil_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Nagsiling si Raquel, “Ginkuha na sang Dios ang akon kahuy-anan. Ginsabat niya ang akon pangamuyo kay ginhatagan niya ako sang isa ka anak nga lalaki.” Gani gin-ngalanan niya ang bata nga Dan. ");
INSERT INTO hil_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Nagbusong liwat si Bilha nga suluguon ni Raquel kag nagbata sang lalaki nga ikaduha nila nga anak ni Jacob. ");
INSERT INTO hil_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Nagsiling si Raquel, “Puwerte gid ang akon pakigsumpong sa akon utod, kag nagdaog ako.” Gani gin-ngalanan niya ang bata nga Naftali. ");
INSERT INTO hil_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Sang indi na si Lea makapamata, ginpaasawa niya kay Jacob ang iya ulipon nga si Zilpa. ");
INSERT INTO hil_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Nagbusong si Zilpa kag nagbata sing lalaki. ");
INSERT INTO hil_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Nagsiling si Lea, “Daw ano nga suwerte.” Gani gin-ngalanan niya ang bata nga Gad. ");
INSERT INTO hil_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nagbata liwat si Zilpa sang lalaki nga ikaduha nila nga anak ni Jacob. ");
INSERT INTO hil_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Nagsiling si Lea, “Malipayon gid ako! Karon magatawag ang mga babayi sa akon nga malipayon.” Gani gin-ngalanan niya ang bata nga Asher. ");
INSERT INTO hil_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Isa sadto ka tion sang tig-alani sang trigo, nagkadto si Reuben sa uma kag may nakita siya nga mga tanom nga mandragora. Nagpanguha siya sang bunga kag gindala sa iya iloy nga si Lea. Pagkakita sadto ni Raquel nagsiling siya kay Lea, “Hatagi man ako sang mga mandragora nga gindala sang imo anak.” ");
INSERT INTO hil_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Pero nagsabat si Lea, “Indi ka pa bala kontento nga ginkuha mo ang akon bana? Kag karon kuhaon mo pa gid ang mga mandragora sang akon anak?” Nagsiling si Raquel, “Kon hatagan mo ako sang mga mandragora pahuliron ko si Jacob sa imo karon sa gab-i.” ");
INSERT INTO hil_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Pag-abot ni Jacob halin sa uma sang sirom na, ginsugata siya ni Lea kag ginsilingan, “Kinahanglan diri ka sa akon maghulid karon nga gab-i, tungod kay ginbayaran ko na ikaw kay Raquel sang mga mandragora nga gindala sang akon anak.” Gani kay Lea naghulid si Jacob sadto nga gab-i. ");
INSERT INTO hil_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ginsabat sang Dios ang pangamuyo ni Lea kag nagbusong siya. Nagbata siya sang lalaki nga ikalima nila nga anak ni Jacob. ");
INSERT INTO hil_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Nagsiling si Lea, “Ginpadyaan ako sang Dios kay ginhatag ko ang akon ulipon sa akon bana.” Gani gin-ngalanan niya ang bata nga Isacar. ");
INSERT INTO hil_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Nagbusong liwat si Lea kag nagbata sing lalaki nga ikaanom nila nga anak ni Jacob. ");
INSERT INTO hil_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Nagsiling siya, “Ginhatagan ako sang Dios sing maayo gid nga regalo. Padunggan na ako sini karon sang akon bana kay nahatagan ko na siya sing anom ka anak nga puro lalaki.” Gani gin-ngalanan niya ang bata nga Zebulun. ");
INSERT INTO hil_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Sang ulihi nagbata si Lea sing babayi kag gin-ngalanan niya nga Dina. ");
INSERT INTO hil_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Wala man pagkalimti sang Dios si Raquel. Ginsabat niya ang iya pangamuyo nga makabata man siya. ");
INSERT INTO hil_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nagbusong siya kag nagbata sing lalaki. Nagsiling siya, “Ginkuha sang Dios ang akon kahuy-anan.” Gani gin-ngalanan niya ang bata nga Jose, kay siling niya, ");
INSERT INTO hil_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","“Kabay pa nga hatagan ako sang Ginoo sang isa pa ka bata.” ");
INSERT INTO hil_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Pagkatapos nga nabata ni Raquel si Jose, nagsiling si Jacob kay Laban, “Tuguti na ako nga makapuli sa amon lugar. ");
INSERT INTO hil_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ihatag sa akon ang akon mga asawa nga ginserbisyuhan ko sa imo kag ang akon mga anak, kay mapuli na ako. Nakahibalo ka kon daw ano ang akon pagserbisyo sa imo.” ");
INSERT INTO hil_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Nagsabat si Laban, “Kon mahimo indi anay. Suno sa akon pagpapakot, nahibaluan ko nga ginpakamaayo ako sang Ginoo tungod sa imo. ");
INSERT INTO hil_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Isiling lang kon pila ang isuhol ko sa imo kay bayaran ko ikaw.” ");
INSERT INTO hil_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Nagsiling si Jacob, “Nakahibalo ka kon daw ano ang akon pagserbisyo sa imo kag kon daw ano ang pagdamo sang imo kasapatan tungod sa akon pagtatap. ");
INSERT INTO hil_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Sang pag-abot ko diri, diutay pa lang ang imo kasapatan, pero subong madamo na gid, kay ginpakamaayo ka sang Ginoo tungod sa akon. Karon dapat na siguro nga magpaninguha ako para sa akon kaugalingon nga panimalay.” ");
INSERT INTO hil_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Nagpamangkot si Laban, “Ano bala ang gusto mo nga ibayad ko sa imo?” Nagsabat si Jacob, “Indi na lang ako pagsuhuli. Padayunon ko ang pagtatap sang imo kasapatan kon magsugot ka sa sini nga kondisyon: ");
INSERT INTO hil_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Tan-awon ko karon ang imo mga kasapatan kag kuhaon ko ang itom nga mga karnero kag kambang nga mga kanding. Amo lang ina ang suhol ko. ");
INSERT INTO hil_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Sa ulihi nga mga inadlaw, mahibaluan mo kon masaligan ako ukon indi kon usisaon mo ang mga sapat nga ginsuhol mo sa akon. Kon may makita ka nga kanding nga indi kambang ukon karnero nga indi itom, isipa ina nga kinawatan ko.” ");
INSERT INTO hil_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Nagsabat si Laban, “Kon amo ina ang gusto mo, sugot ako.” ");
INSERT INTO hil_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Pero sadto mismo nga adlaw, ginpain ni Laban ang kambang nga mga kanding nga lalaki kag babayi, pati ang itom nga mga karnero. Ginpaatipan niya ini sa iya mga anak nga lalaki. ");
INSERT INTO hil_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ginseparar niya ini kay Jacob sa kalayuon nga tatlo ka adlaw kon lakton. Ang nabilin nga mga sapat amo ang ginbantayan ni Jacob. ");
INSERT INTO hil_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Karon, nagkuha si Jacob sang mga sanga sang alamo, abilyano, kag platano kag ginpanitan niya ang iban nga mga parte sini, gani may guray-guray nga puti kon tan-awon ang mga sanga. ");
INSERT INTO hil_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Ginbutang niya dayon ato nga mga sanga sa atubangan sang ilimnan sang mga sapat para makita sang mga sapat kon mag-inom sila. Didto sa atubangan sang sadto nga mga sanga nagakastahanay ang mga kanding kon mag-inom sila. Kon magbata sila, ang ila bata kambang. ");
INSERT INTO hil_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Pero lain ang ginhimo ni Jacob sa mga karnero: Samtang nagakastahanay ini nga mga sapat, ginapaatubang niya sila sa iya kambang nga mga kanding kag sa itom nga mga kanding ni Laban. Sa sini nga paagi nakatipon man si Jacob sang iya kaugalingon nga mga sapat kag wala niya ini gin-impon sa mga sapat ni Laban. ");
INSERT INTO hil_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kon nagakastahanay na gani ang mga sapat nga maayo sing lawas didto sa ilimnan, ginabutang dayon ni Jacob ato nga mga sanga sa ila atubangan. ");
INSERT INTO hil_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Pero kon ang mga sapat nga maluya ang nagakastahanay, wala niya ginabutang ang mga sanga. Gani ang mga maluya iya ni Laban kag ang mga maayo sing lawas iya ni Jacob. ");
INSERT INTO hil_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Sa sini nga paagi, nagmanggaranon gid si Jacob. Madamo ang iya mga kasapatan pati na ang mga camel kag mga donkey. Madamo man ang iya mga ulipon nga lalaki kag babayi. ");
INSERT INTO hil_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Nakabati si Jacob nga ang mga anak nga lalaki ni Laban nagasiling, “Ginkuha ni Jacob ang halos tanan nga pagkabutang sang aton amay. Ang tanan niya nga manggad naghalin sa pagkabutang sang aton amay.” ");
INSERT INTO hil_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Natalupangdan man ni Jacob nga naglain na ang pagtratar ni Laban sa iya kaysa sang una. ");
INSERT INTO hil_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Nagsiling ang Ginoo kay Jacob, “Pauli ka na sa lugar sang imo katigulangan, didto sa imo mga paryente, kag ako mangin kaupod mo.” ");
INSERT INTO hil_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Gani ginpatawag ni Jacob ang iya mga asawa nga si Raquel kag si Lea nga magkadto didto sa palahalban sang iya mga sapat. ");
INSERT INTO hil_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Nagsiling siya sa ila, “Natalupangdan ko nga naglain na ang pagtratar sang inyo amay sa akon kaysa sang una. Pero wala ako pagpabay-i sang Dios sang akon amay. ");
INSERT INTO hil_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nakahibalo man kamo nga nagserbisyo ako sa inyo amay hasta sa akon masarangan, ");
INSERT INTO hil_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","pero gintunto pa niya ako. Napulo gid ka beses nga ginliwat-liwat niya ang akon suhol. Pero wala ako pagpabay-i sang Dios nga daog-daugon lang niya. ");
INSERT INTO hil_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kon magsiling gani si Laban nga ang kambang nga mga kanding amo ang suhol ko, puro man kambang ang bata sang mga kanding. ");
INSERT INTO hil_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ginkuha sang Dios ang kasapatan sang inyo amay kag ginhatag sa akon.” ");
INSERT INTO hil_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Nagsiling pa gid si Jacob, “Sang tion sang pagpahigal sang mga sapat, nagdamgo ako. Nakita ko nga ang mga lalaki nga kanding nga nagakasta sa mga babayi nga kanding mga kambang. ");
INSERT INTO hil_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Sa akon nga damgo gintawag ako sang anghel sang Dios. Siling niya, ‘Jacob!’ Nagsabat ako sa iya ");
INSERT INTO hil_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","kag nagsiling siya dayon, ‘Tan-awa, tanan nga lalaki nga kanding nga nagakasta sa mga babayi nga kanding mga kambang. Ginhimo ko ini tungod kay nakita ko ang tanan nga ginahimo sa imo ni Laban. ");
INSERT INTO hil_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ako ang Dios nga nagpakita sa imo didto sa Betel, sa lugar nga sa diin ginbubuan mo sang lana ang bato nga ginpatindog mo bilang handumanan. Kag didto ka man nagsumpa sa akon. Karon, panghimos ka kag maghalin sa sini nga lugar kag magpuli sa lugar nga sa diin ka natawo.’ ” ");
INSERT INTO hil_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Nagsabat si Raquel kag si Lea kay Jacob, “Wala na kami sing may mapanubli sa amon amay. ");
INSERT INTO hil_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Iban na kami nga tawo sa iya pagtan-aw. Ginbaligya niya kami kag ubos na niya gasto ang amon bili. ");
INSERT INTO hil_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ang tanan nga manggad nga ginbawi sang Dios sa iya kag ginhatag sa imo makabig namon nga amo ang palanublion namon kag sang amon mga anak. Gani tumana ang ginsiling sa imo sang Dios.” ");
INSERT INTO hil_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Nanghimos dayon si Jacob para makapuli sa Canaan, sa lugar sang iya amay nga si Isaac. Ginpasakay niya ang iya mga anak kag mga asawa sa mga camel. Gindala niya ang iya mga kasapatan kag ang tanan niya nga pagkabutang nga iya natipon sa Padan Aram. ");
INSERT INTO hil_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Natabuan sadto nga naglakat si Laban sa pagpanggunting sang iya mga karnero, kag samtang wala siya ginkuha ni Raquel ang mga dios-dios sang iya tatay. ");
INSERT INTO hil_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Natunto ni Jacob si Laban nga Arameanhon tungod wala siya nagsugid nga mahalin na siya. ");
INSERT INTO hil_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Sang paglakat ni Jacob, dala niya ang tanan niya nga pagkabutang. Nagtabok siya sa Suba sang Euphrates kag nagpakadto sa kabukiran sang Gilead. ");
INSERT INTO hil_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Tatlo na ka adlaw ang nagligad sang nahibaluan ni Laban nga naglayas sanday Jacob. ");
INSERT INTO hil_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Gani ginlagas niya si Jacob upod ang iya mga paryente sa sulod sang pito ka adlaw. Nalambot nila sanday Jacob didto sa kabukiran sang Gilead. ");
INSERT INTO hil_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Sadto nga gab-i, nagpakita ang Dios kay Laban nga Arameanhon sa damgo. Nagsiling ang Dios sa iya, “Indi pag-anha si Jacob.” ");
INSERT INTO hil_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Nagapatindog sadto si Jacob sang iya tolda sa kabukiran sang Gilead sang naabtan siya ni Laban. Kag didto man nagpatindog sanday Laban sang ila mga tolda. ");
INSERT INTO hil_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Nagsiling si Laban kay Jacob, “Ngaa ginhimo mo ini sa akon? Ngaa gintunto mo ako? Imo pa nga gindala ang akon mga anak nga daw sa mga bihag sa inaway. ");
INSERT INTO hil_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ngaa gintunto mo ako kag naglakat kamo nga wala maglisensya sa akon? Kon nagsiling lang kamo, akon pa kuntani kamo ginpalakat nga may sinadya sa sunata sang tamborin kag arpa. ");
INSERT INTO hil_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Wala mo gani ako pagpahaluka sa akon mga apo kag mga anak paglakat nila. Indi gid maayo ining ginhimo mo. ");
INSERT INTO hil_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","May rason gid ako kuntani nga halitan ka, ugaling ginpaandaman ako kagab-i sang Dios sang imo amay nga indi ko ikaw pag-anhon. ");
INSERT INTO hil_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nahibaluan ko nga nahidlaw ka na gid sa inyo, gani gusto mo na nga magpuli. Pero ngaa ginkawat mo ang akon mga dios-dios?” ");
INSERT INTO hil_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Nagsabat si Jacob sa iya, “Wala ako maglisensya sa imo kay nahadlok ako nga basi puwersahon mo ako nga bawion sa akon ang imo mga anak. ");
INSERT INTO hil_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Pero kon parte sa imo mga dios-dios nga nadula, kon makita mo gani ini sa kay bisan sin-o sa amon, pagasilutan siya sang kamatayon. Sa atubangan sang aton mga paryente bilang mga saksi, tan-awa kon may pagkabutang ka diri sa amon kag kon may ara kuhaa.” Wala kahibalo si Jacob nga si Raquel gali ang nagkuha sang mga dios-dios ni Laban. ");
INSERT INTO hil_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Gani ginpangita ni Laban ang iya mga dios-dios sa tolda ni Jacob, sa tolda ni Lea, kag pati sa tolda sang duha ka suluguon nga babayi nga mga asawa ni Jacob. Pero wala gid niya nakita ang iya mga dios-dios. Pagguwa niya sa tolda ni Lea, nagsulod siya dayon sa tolda ni Raquel. ");
INSERT INTO hil_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Pero natago na ni Raquel ang mga dios-dios sa bulsa-bulsa sang hapin sa camel, kag iya ini nga ginpungkuan. Ginpangita ni Laban ang mga dios-dios didto sa tolda ni Raquel pero wala gid niya makita. ");
INSERT INTO hil_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Nagsiling si Raquel sa iya, “Tay, indi ka lang mangakig kon indi ako makatindog kay ara abi ang akon pamulanon.” Kag padayon nga nagpangita si Laban pero wala gid niya makita ang iya mga dios-dios. ");
INSERT INTO hil_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Wala na mapunggi ni Jacob ang iya kaakig, gani nagsiling siya kay Laban, “Ano bala nga krimen ang nahimo ko? Ano gid bala ang sala ko nga ginlagas mo gid ako? ");
INSERT INTO hil_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Karon nga nausisa mo na ang tanan ko nga pagkabutang, ti, may nakita ka nga imo? Kon may ara, ibutang diri sa atubangan para makita sang akon mga paryente kag sang imo mga paryente, kag bahala na sila nga maghukom sa aton. ");
INSERT INTO hil_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Sa sulod sang 20 ka tuig nga didto ako sa inyo, bisan kaisa lang wala gid mahar-asi ang imo mga kanding kag karnero. Kag wala gid ako makaihaw sang imo lalaki nga karnero. ");
INSERT INTO hil_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Wala ko na ginadala sa imo ang mga sapat nga ginpatay sang mabangis nga mga sapat; ginabayluhan ko na lang ini dayon. Ginpabayaran mo man sa akon ang mga sapat nga ginkawat kon adlaw bisan pa ang ginkawat kon gab-i. ");
INSERT INTO hil_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Amo ini ang nangin situasyon ko: Kon adlaw nagaantos ako sa kainit, kag kon gab-i nagaantos ako sa katugnaw. Kag kulang ako permi sang tulog. ");
INSERT INTO hil_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Sa sulod sang 20 ka tuig nga pag-estar ko sa inyo, 14 gid ka tuig nga nagserbisyo ako sa imo para sa imo duha ka anak nga babayi. Nagserbisyo pa gid ako sang anom ka tuig sa pagbantay sang imo mga kasapatan. Pero ano ang ginhimo mo? Kapulo mo nga ginliwat-liwat ang akon suhol. ");
INSERT INTO hil_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kon wala siguro ako pag-updi sang Dios nga ginatahod sang akon amay nga si Isaac, nga amo man ang Dios ni Abraham, basi ginpalayas mo na ako nga wala gid sing dala bisan ano. Pero nakita sang Dios ang akon kabudlayan kag pagtrabaho, gani ginsaway ka niya kagab-i.” ");
INSERT INTO hil_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Nagsabat si Laban, “Ina nga mga babayi mga anak ko, kag ang ila mga anak mga apo ko. Kag ina nga mga sapat akon man. Tanan nga makita mo akon. Pero karon, ano pa ang mahimo ko sa akon mga anak kag mga apo? ");
INSERT INTO hil_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ang maayo siguro, mahimo kita sang kasugtanan. Mapatindog kita sang handumanan nga bato nga magapamatuod sang aton kasugtanan.” ");
INSERT INTO hil_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Gani nagkuha si Jacob sang dako nga bato kag iya ini nga ginpatindog bilang handumanan. ");
INSERT INTO hil_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Dayon ginsugo niya ang iya mga paryente nga magtumpok sang mga bato sa higad sini. Pagkatapos nagkaon sila didto sa tinumpok nga mga bato. ");
INSERT INTO hil_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Gin-ngalanan ni Laban ang tinumpok nga mga bato nga Jegar Sahaduta. Pero gin-ngalanan ini ni Jacob nga Galeed. ");
INSERT INTO hil_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Nagsiling si Laban, “Ining tinumpok nga mga bato magapamatuod sa kasugtanan naton nga duha.” Amo ina ang kabangdanan kon ngaa gin-ngalanan ato nga tinumpok nga Galeed. ");
INSERT INTO hil_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Gintawag man ato nga Mizpa, tungod kay nagsiling pa gid si Laban, “Kabay pa nga bantayan kita sang Ginoo sa aton pagbululag. ");
INSERT INTO hil_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kag kon indi maayo ang pagtratar mo sa akon mga anak, ukon magpangasawa ka pa sang iban, dumduma nga bisan indi ako makahibalo, ara ang Dios nga nagapamatuod sang aton kasugtanan.” ");
INSERT INTO hil_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Nagsiling pa gid liwat si Laban kay Jacob, “Ari ang tinumpok nga mga bato kag ang handumanan nga bato nga magapamatuod sang aton kasugtanan. ");
INSERT INTO hil_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ining tinumpok nga mga bato kag ang handumanan nga bato amo ang magapamatuod sang aton kasugtanan nga indi ako maglapaw sa sining tinumpok nga mga bato para salakayon ka, kag indi ka man maglapaw sa sining tinumpok nga mga bato kag sa handumanan nga bato para salakayon ako. ");
INSERT INTO hil_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kabay pa nga ang dios sang imo lolo nga si Abraham kag ang dios sang akon amay nga si Nahor, nga amo man ang mga dios sang ila amay nga si Tera, amo ang maghukom sa aton nga duha.” Nagsumpa man dayon si Jacob kay Laban sa ngalan sang Dios nga ginatahod sang iya amay nga si Isaac. ");
INSERT INTO hil_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Naghalad si Jacob sang sapat didto sa bukid, kag dayon gintawag niya ang iya mga paryente nga magkaon. Didto sila sa bukid nagtulog pagkagab-i. ");
INSERT INTO hil_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Aga pa gid sang sunod nga adlaw, ginpanghalukan ni Laban kag ginbendisyunan ang iya mga anak kag mga apo, kag naglakat siya puli. ");
INSERT INTO hil_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Sang nagapadayon sila ni Jacob sa paglakat, ginsugata siya sang mga anghel sang Dios. ");
INSERT INTO hil_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Pagkakita ni Jacob sa ila, nagsiling siya, “Mga soldado ini sang Dios.” Gani gin-ngalanan niya ato nga lugar nga Mahanaim. ");
INSERT INTO hil_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","May mga ginsugo si Jacob nga mag-una sa iya para magpakigkita sa iya utod nga si Esau didto sa duta sang Seir, ang lugar nga gintawag man nga Edom. ");
INSERT INTO hil_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Gintudluan niya sila kon ano ang ila isiling sa kay Esau. Siling ni Jacob, “Silingon ninyo si Esau nga didto ako nagtiner kay Laban kag wala pa gani ako makapuli hasta subong. ");
INSERT INTO hil_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Kag sugiri ninyo siya nga may mga baka ako, mga donkey, mga karnero, mga kanding, kag mga ulipon nga lalaki kag babayi. Silingon ninyo siya nga ginsugo ko kamo sa pagpangabay sa iya nga kuntani mangin maayo ang iya pagtratar sa akon.” ");
INSERT INTO hil_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Pagbalik sang mga ginsugo ni Jacob, nagsiling sila, “Nakakadto kami kay Esau, kag nagapakadto na siya diri sa pagsugata sa imo. May upod siya nga 400 ka lalaki.” ");
INSERT INTO hil_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Kinulbaan gid si Jacob kag indi siya mapahamtang, gani gintunga niya sa duha ka grupo ang iya mga kaupdanan pati ang iya mga karnero, baka, kanding kag camel. ");
INSERT INTO hil_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Tungod kay naghunahuna siya nga kon pananglit gid man nga mag-abot si Esau kag salakayon ang isa ka grupo, makapalagyo pa ang isa ka grupo. ");
INSERT INTO hil_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Nagpangamuyo dayon si Jacob, “Dios sang akon lolo nga si Abraham kag Dios sang akon amay nga si Isaac, ikaw ang Ginoo nga nagsiling sa akon nga mabalik ako sa akon mga paryente, didto sa duta nga sa diin ako natawo, kag pakamaayuhon mo ako. ");
INSERT INTO hil_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Indi ako takos nga magbaton sang tanan nga kaayo kag katutom nga imo na ginpakita sa akon nga imo suluguon. Kay sang pagtabok ko sang una sa Jordan wala ako sing iban nga dala kundi baston gid lang, pero subong may duha na ako ka grupo. ");
INSERT INTO hil_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nagapangabay ako sa imo nga luwason mo ako sa akon utod nga si Esau. Nahadlok ako basi magkadto siya diri kag pamatyon kami tanan pati ang mga iloy kag ang mga bata. ");
INSERT INTO hil_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Pero nagpromisa ka sa akon nga pakamaayuhon mo ako kag padamuon mo ang akon mga kaliwat pareho sang balas sa baybayon nga indi maisip.” ");
INSERT INTO hil_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Didto nagtulog sanday Jacob pagkagab-i. Pagkaaga, nagpili si Jacob sang mga sapat nga iregalo kay Esau: ");
INSERT INTO hil_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 ka babayi nga kanding kag 20 ka lalaki nga kanding, 200 ka babayi nga karnero kag 20 ka lalaki nga karnero, ");
INSERT INTO hil_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 ka gatasan nga camel upod pa ang ila mga bata, 40 ka babayi nga baka kag 10 ka turo nga baka, 20 ka babayi nga donkey kag 10 ka lalaki nga donkey. ");
INSERT INTO hil_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ginpanggrupo-grupo dayon ni Jacob ang mga sapat, kag ang kada grupo may mga suluguon nga nagabantay. Ginsilingan niya ang iya mga suluguon, “Una kamo sa akon, kag maglakat kamo nga may antad ang kada grupo.” ");
INSERT INTO hil_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ginsilingan niya ang mga suluguon nga nagabantay sa nauna nga grupo, “Kon magsugat-anay gani kamo ni Esau kag magpamangkot siya kon kay sin-o kamo suluguon kag kon diin kamo makadto, kag kon kay sin-o inang mga sapat nga dala ninyo, ");
INSERT INTO hil_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","sabton ninyo siya nga akon ini mga sapat kag regalo ko ini sa iya. Silingon man ninyo siya nga ara ako nagasunod.” ");
INSERT INTO hil_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Amo man ang iya ginsiling sa ikaduha, sa ikatatlo kag sa tanan nga suluguon nga nagasunod sa mga sapat. ");
INSERT INTO hil_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kag ginpadumdom gid niya sila nga indi nila pagkalimtan nga silingon si Esau nga ara siya nagasunod. Kay siling ni Jacob sa iya hunahuna, “Ulo-ulohan ko si Esau sa sining mga regalo nga ipauna ko. Kag kon magkitaay kami basi pa lang patawaron niya ako.” ");
INSERT INTO hil_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Gani ginpauna niya ang iya mga regalo, pero siya ya nagpabilin sadto nga gab-i didto sa ila gintineran. ");
INSERT INTO hil_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Sadto nga gab-i, nagbangon si Jacob kag gindala niya ang iya duha ka asawa, ang iya duha ka ulipon nga babayi kag ang iya onse ka anak, kag nagtabok sila sa talabukan sang Jabok. ");
INSERT INTO hil_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ginpatabok man ni Jacob ang tanan niya nga pagkabutang. ");
INSERT INTO hil_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Karon, sang nagaisahanon siya, may nag-abot nga isa ka lalaki kag gindumog siya. Nagdumugay sila hasta mag-aga. ");
INSERT INTO hil_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Sang mabulubanta sang tawo nga indi niya madaog si Jacob, ginpisga niya ang balikawang ni Jacob kag nagliw-as ang nagatabo nga tul-an sini. ");
INSERT INTO hil_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Nagsiling dayon ang tawo, “Buy-i na ako kay kaagahon na.” Pero nagsabat si Jacob, “Indi ko ikaw pagbuy-an kon indi mo ako pagbendisyunan.” ");
INSERT INTO hil_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nagpamangkot ang tawo sa iya, “Sin-o ang imo ngalan?” Nagsabat siya, “Si Jacob.” ");
INSERT INTO hil_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Nagsiling dayon ang tawo, “Sugod subong indi na Jacob ang imo ngalan kundi Israel na tungod kay nagpakigsumpong ka sa Dios kag sa mga tawo, kag nagdaog ka.” ");
INSERT INTO hil_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Nagpamangkot man si Jacob sa iya, “Sugiri man ako sang imo ngalan.” Pero nagsabat ang tawo, “Indi na pagpamangkuta ang akon ngalan.” Dayon ginbendisyunan niya si Jacob didto. ");
INSERT INTO hil_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Gin-ngalanan ni Jacob ato nga lugar nga Peniel, kay siling niya, “Nakita ko ang hitsura sang Dios pero buhi pa gihapon ako.” ");
INSERT INTO hil_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Nagabutlak na ang adlaw sang paghalin ni Jacob sa Peniel. Nagapiang-piang siya tungod sa nagliw-as niya nga tul-an sa balikawang. ");
INSERT INTO hil_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Amo ini ang rason kon ngaa hasta subong ang mga Israelinhon wala nagakaon sang lanit-lanit sa tinabuan sang tul-an sa balikawang. Kay dira nga parte ginpisga sang Dios si Jacob. ");
INSERT INTO hil_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Karon, pagtan-aw ni Jacob, nakita niya si Esau nga nagapadulong upod ang 400 ka lalaki. Gani ginpatipon niya ang iya mga anak sa ila tagsa-tagsa ka iloy. ");
INSERT INTO hil_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Kag paglakat nila, ginpauna niya ang duha ka ulipon nga babayi kag ang ila mga anak, sunod si Lea kag ang iya mga anak, kag dayon si Raquel kag ang iya anak nga si Jose. ");
INSERT INTO hil_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nagauna si Jacob sa ila tanan kag makapila gid siya ka beses nga nagluhod samtang nagapalapit siya sa iya utod. ");
INSERT INTO hil_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Pero nagdalagan si Esau sa pagsugata sa iya. Ginhakos siya ni Esau kag ginhalukan, kag naghibi sila nga duha. ");
INSERT INTO hil_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Sang makita ni Esau ang mga babayi kag ang mga kabataan, ginpamangkot niya si Jacob, “Sin-o inang kaupdanan mo?” Nagsabat si Jacob, “Sila ang akon mga anak nga ginhatag sang Dios sa akon sa iya kaluoy.” ");
INSERT INTO hil_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Nagpalapit dayon kay Esau ang duha ka ulipon nga babayi kag ang ila mga anak, kag nagluhod sila bilang pagtahod sa iya. ");
INSERT INTO hil_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Nagsunod man dayon si Lea kag ang iya mga anak nga nagluhod. Kag ang ulihi nga nagpalapit kag nagluhod amo si Jose kag ang iya iloy nga si Raquel. ");
INSERT INTO hil_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Nagpamangkot si Esau kay Jacob, “Ano bala ang imo buot silingon sadtong mga grupo sang sapat nga nasugata ko?” Nagsiling si Jacob, “Regalo ko ato sa imo para batunon mo ako.” ");
INSERT INTO hil_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Pero nagsabat si Esau, “Madamo na ang akon pagkabutang, utod ko, gani sa imo na lang ato.” ");
INSERT INTO hil_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Pero nagpamilit gid si Jacob, “Sige na, batuna na ato. Kon matuod-tuod nga ginabaton mo ako, batuna na ang regalo ko sa imo. Kay sang pagkakita ko sang imo hitsura daw nakita ko ang hitsura sang Dios. Karon nga ginbaton mo ako, ");
INSERT INTO hil_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","batuna na ang ginahatag ko sa imo tungod kay maayo ang Dios sa akon kag wala ako makulangi sa akon mga kinahanglanon.” Sagi gid pilit ni Jacob si Esau hasta nga ginbaton na lang ni Esau ang iya regalo. ");
INSERT INTO hil_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Dayon nagsiling si Esau, “Dali na, malakat na kita. Ululupod na lang kita.” ");
INSERT INTO hil_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Pero nagsabat si Jacob, “Nakahibalo ka nga mahinay maglakat ang mga bata, kag kinahanglan ko gid nga tatapon maayo ang mga sapat nga nagapatiti. Kon piliton ta ang mga sapat nga maglakat sa bilog nga adlaw, basi magkalamatay sila. ");
INSERT INTO hil_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ang maayo pa, mag-una ka na lang sa amon. Maamat-amat lang kami sunod sa imo suno sa kadasigon sang mga bata kag sang mga sapat sa una namon. Didto na lang kita magkitaay sa Seir.” ");
INSERT INTO hil_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Nagsiling si Esau, “Kon amo sina, ibilin ko na lang ang iban ko nga mga tinawo sa imo.” Nagsabat si Jacob, “Indi na kinahanglan. Ang importante ginbaton mo ako.” ");
INSERT INTO hil_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Gani nagbalik na lang si Esau sa Seir sadto mismo nga adlaw. ");
INSERT INTO hil_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Pero didto nagpakadto sanday Jacob sa Sucot. Pag-abot nila didto, naghimo si Jacob sang elistaran kag ginhimuan man niya sang palasilungan ang iya mga kasapatan. Gani ato nga lugar gintawag nga Sucot. ");
INSERT INTO hil_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Sang ulihi nakaabot gid man sila sa Canaan halin sa Padan Aram nga wala sing may malain nga natabo sa ila. Nakaabot sila sa banwa nga ginaestaran ni Shekem. Nagpatindog sila sang ila mga tolda malapit sa banwa. ");
INSERT INTO hil_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Kag ang duta nga ginpatindugan nila sang mga tolda ginbakal ni Jacob sa mga anak ni Hamor sa bili nga 100 ka bilog nga pilak. Si Hamor amo man ang amay ni Shekem. ");
INSERT INTO hil_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Naghimo si Jacob didto sang halaran nga gin-ngalanan niya nga El Elohe Israel. ");
INSERT INTO hil_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Isa sadto ka adlaw, naglakat si Dina nga anak nga dalaga ni Jacob kag ni Lea. Nagbisita siya sa mga kababayihan nga taga-Canaan. ");
INSERT INTO hil_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Nakita siya ni Shekem nga anak ni Hamor nga Hivhanon, nga pangulo sang sadto nga lugar. Gindakop niya si Dina kag ginlugos. ");
INSERT INTO hil_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Pero nahulog ang iya buot kay Dina kag naluyag siya sa iya, gani gin-uloulohan niya ang dalaga. ");
INSERT INTO hil_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Karon, nagsiling si Shekem sa iya amay nga si Hamor, “Tay, pangitai abi sang paagi nga mapangasawa ko ang ina nga dalaga.” ");
INSERT INTO hil_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Sang nahibaluan ni Jacob nga ginhigkuan ni Shekem ang pagkatawo ni Dina, wala lang siya anay sing may ginhimo kay didto pa sa uma ang iya mga anak nga lalaki nga nagabantay sang iya mga sapat. ");
INSERT INTO hil_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Nagkadto ang amay ni Shekem nga si Hamor kay Jacob para magpakighambal sa iya. ");
INSERT INTO hil_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Pagkabati sang mga anak nga lalaki ni Jacob sa natabo, nagpuli dayon sila. Naglain gid ang ila buot kag puwerte gid ang ila kaakig kay Shekem tungod kay naghimo siya sang butang nga indi dapat himuon, nga nagdala sang kahuy-anan sa pamilya ni Jacob. ");
INSERT INTO hil_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Pero nagsiling si Hamor sa ila, “Naluyag gid ang akon anak nga si Shekem sa inyo nga dalaga, gani nagapangabay ako nga ipaasawa na lang ninyo siya sa iya. ");
INSERT INTO hil_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kag maayo man siguro nga ipaasawa ninyo ang inyo mga dalaga sa amon mga soltero kag ipaasawa man namon ang amon mga dalaga sa inyo mga soltero. ");
INSERT INTO hil_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Puwede kamo mag-estar upod sa amon sa bisan diin nga lugar nga gusto ninyo. Kag puwede man kamo diri makanegosyo bisan diin kag makaangkon sang duta.” ");
INSERT INTO hil_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Nagpangabay man si Shekem sa amay kag sa mga utod ni Dina, “Kon mahimo ipaasawa na lang ninyo si Dina sa akon. Bisan ano ang inyo pangayuon ihatag ko. ");
INSERT INTO hil_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Pagusto kamo kon pila ang pangayuon ninyo kag kon ano ang iregalo ko sa pagpangasawa ko sa inyo utod. Bayaran ko kamo bisan pila ang inyo pangayuon basta ipaasawa lang ninyo sa akon si Dina.” ");
INSERT INTO hil_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Pero tungod kay ginhigkuan ni Shekem ang pagkatawo ni Dina, gintunto sang mga anak ni Jacob si Shekem kag ang iya amay nga si Hamor. ");
INSERT INTO hil_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Siling nila, “Indi puwede nga ipaasawa namon si Dina sa tawo nga wala matuli, kay makahuluya ina para sa amon. ");
INSERT INTO hil_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Masugot lang kami kon ang tanan nga lalaki nga taga-diri magpatuli man pareho sa amon. ");
INSERT INTO hil_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kon magpatuli kamo, puwede namon ipaasawa ang amon mga dalaga sa inyo kag kami puwede man makapangasawa sang inyo mga dalaga. Kag maestar kami upod sa inyo para mangin isa na lang kita ka katawhan. ");
INSERT INTO hil_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Pero kon indi kamo magsugot, kuhaon namon si Dina kag maglakat.” ");
INSERT INTO hil_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Nakita ni Hamor kag ni Shekem nga daw maayo man ang kondisyon nga ginhatag sang mga anak ni Jacob. ");
INSERT INTO hil_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Gani tungod sa dako nga gugma ni Shekem kay Dina, wala na siya mag-usik pa sang tion sa pagtuman sang ginsiling sang mga anak ni Jacob. Si Shekem ginatahod gid sa panimalay sang iya amay. ");
INSERT INTO hil_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Gani nagkadto siya dayon kag ang iya amay didto sa puwertahan sang banwa kag nagpakighambal sa mga lalaki sang ila banwa. ");
INSERT INTO hil_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Siling nila, “Mainabyanon ini nga mga tawo. Gani diri na lang naton sila paestaron kag tugutan nga makanegosyo diri. Total, dako man ining aton lugar. Makapangasawa kita sa ila mga dalaga kag sila makapangasawa man sa aton mga dalaga. ");
INSERT INTO hil_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Pero masugot lang sila nga mag-estar upod sa aton bilang isa ka katawhan kon magsugot man ang tanan ta nga lalaki nga magpatuli pareho sa ila. ");
INSERT INTO hil_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kon diri na sila mag-estar, kundi mangin aton man ang tanan nila nga kasapatan kag mga pagkabutang. Gani masugot na lang kita sa ila kondisyon para mag-estar sila upod sa aton.” ");
INSERT INTO hil_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Nagsugot ang tanan nga lalaki sang banwa sa ginhambal ni Hamor kag sang iya anak nga si Shekem. Gani nagpatuli ang tanan nga lalaki. ");
INSERT INTO hil_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Pagkaligad sang tatlo ka adlaw, samtang ginahapdian pa ang mga lalaki, nagsulod sa banwa ang duha ka anak ni Jacob nga si Simeon kag si Levi, nga mga utod ni Dina. Wala kahibalo ang mga tawo didto nga malain gali ang ila tuyo. May dala sila nga espada kag ginpamatay nila ang tanan nga lalaki. ");
INSERT INTO hil_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ginpatay man nila si Hamor kag ang iya anak nga si Shekem. Ginkuha dayon nila si Dina sa balay ni Shekem kag naglakat. ");
INSERT INTO hil_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Pagkatapos ginsulod man sang iban pa nga mga anak ni Jacob ang banwa kag ginpanguha ang mga pagkabutang sini. Ginhimo nila ini tungod kay ginhigkuan ang pagkatawo sang ila utod nga si Dina. ");
INSERT INTO hil_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ginpanguha nila ang mga karnero, mga baka, mga donkey, kag ang tanan nga pagkabutang didto sa banwa kag sa uma. ");
INSERT INTO hil_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ginpanguha nila ang tanan nga manggad sang banwa, pati ang mga pagkabutang sa sulod sang mga balay. Kag ginbihag nila ang tanan nga babayi kag kabataan. ");
INSERT INTO hil_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Karon, nagsiling si Jacob kay Simeon kag kay Levi, “Ginhatagan ninyo ako sang dako nga problema. Dumtan na kita karon sang mga Canaanhon kag mga Periznon sa sini nga lugar. Mapatay gid kita tanan kon mag-isa sila sa pagsalakay sa aton tungod kay diutay lang kita.” ");
INSERT INTO hil_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Pero nagsabat ang duha, “Pabay-an lang bala namon nga trataron ang amon utod nga daw isa ka babayi nga nagabaligya sang iya lawas?” ");
INSERT INTO hil_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Karon, nagsiling ang Dios kay Jacob, “Magpanghimos ka kag magkadto sa Betel kag didto mag-estar. Maghimo ka dayon didto sang halaran para sa akon, ang Dios nga nagpakita sa imo sang nagapalagyo ka pa sadto sa imo utod nga si Esau.” ");
INSERT INTO hil_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Gani nagsiling si Jacob sa iya panimalay kag sa tanan niya nga kaupdanan, “Ipamilak ninyo ang inyo mga dios-dios. Magpakatinlo kamo kag mag-ilis sang bayo. ");
INSERT INTO hil_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Dayon magkadto kita sa Betel; kag mahimo ako didto sang halaran para sa Dios nga nagbulig sa akon sang ara ako sa kalisod, kag nag-upod sa akon bisan diin ako nagkadto.” ");
INSERT INTO hil_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Gani ginhatag nila kay Jacob ang ila mga dios-dios pati ang ila mga aritos. Ginlubong ini tanan ni Jacob sa idalom sang kahoy nga terebinto nga malapit sa Shekem. ");
INSERT INTO hil_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Sang nagahalin na sanday Jacob, ginpahadlok sang Dios ang mga tawo sa palibot nga mga banwa, gani wala nila paglagsa sanday Jacob. ");
INSERT INTO hil_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Nakaabot si Jacob kag ang iya mga kaupdanan sa Luz (nga ginatawag man nga Betel) didto sa Canaan. ");
INSERT INTO hil_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Naghimo siya didto sang halaran. Gin-ngalanan niya ato nga lugar nga El Betel kay nagpakita sa iya didto ang Dios sang nagapalagyo siya sa iya utod nga si Esau. ");
INSERT INTO hil_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Karon, napatay si Debora nga manug-atipan ni Rebeka. Gani ginlubong siya sa idalom sang dako nga kahoy didto sa ubos sang Betel. Gintawag ato nga kahoy nga Allon Bacut. ");
INSERT INTO hil_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Sang nagapapuli sadto si Jacob halin sa Padan Aram, nagpakita liwat ang Dios sa iya kag ginbendisyunan siya. ");
INSERT INTO hil_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Nagsiling ang Dios sa iya, “Jacob ang imo ngalan, pero sugod subong indi ka na pagtawgon nga Jacob kundi Israel na.” Gani nangin Israel ang ngalan ni Jacob. ");
INSERT INTO hil_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nagsiling pa gid ang Dios sa iya, “Ako ang Makagagahom nga Dios. Magpamata ka sing madamo. Mangin amay ka sang isa ka nasyon kag sang madamo pa nga mga nasyon, kag mangin hari ang iban mo nga mga kaliwat. ");
INSERT INTO hil_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ang duta nga ginhatag ko kay Abraham kag kay Isaac ihatag ko man sa imo kag sa imo mga kaliwat.” ");
INSERT INTO hil_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Dayon naghalin ang Dios sa sadto nga lugar nga sa diin nagpakig-estorya siya kay Jacob, kag nagpatindog didto si Jacob sang handumanan nga bato. Ginbubuan niya dayon sang bino kag lana ang bato para mangin sagrado. ");
INSERT INTO hil_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Gin-ngalanan niya ato nga lugar nga Betel. ");
INSERT INTO hil_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Karon, naghalin si Jacob kag ang iya panimalay sa Betel. Manugbata na sadto si Raquel. Sang malayo-layo pa sila sa banwa sang Efrata, ginsakitan si Raquel. ");
INSERT INTO hil_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Sang puwerte na gid ang iya pagpasakit, nagsiling ang paltera sa iya, “Indi ka magkahadlok Raquel, lalaki naman ang imo bata.” ");
INSERT INTO hil_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Natawo ang bata pero tagumatayon na si Raquel. Sang wala pa siya nabugtuan sang ginhawa, gin-ngalanan niya ang bata nga Ben Oni. Pero gin-ngalanan ni Jacob ang bata nga Benjamin. ");
INSERT INTO hil_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Napatay si Raquel kag ginlubong siya sa higad sang dalan nga pakadto sa Efrata (nga ginatawag subong nga Betlehem). ");
INSERT INTO hil_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ginbutangan ni Jacob sang bato nga palatandaan ang lulubngan ni Raquel, kag hasta subong ara pa ini nga tanda sa lulubngan ni Raquel. ");
INSERT INTO hil_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Nagpadayon sila ni Jacob sa ila paglakat. Pag-abot nila sa pihak sang Migdal Eder, nagpatindog sila didto sang ila mga tolda. ");
INSERT INTO hil_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Samtang didto pa nagaestar si Jacob, nagpakighilawas si Reuben kay Bilha nga isa sang mga asawa sang iya amay. Sang mahibaluan ato ni Jacob naakig gid siya. May dose ka anak nga lalaki si Jacob. ");
INSERT INTO hil_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ang iya mga anak kay Lea amo sila ni Reuben, ang kamagulangan, dayon si Simeon, si Levi, si Juda, si Isacar, kag si Zebulun. ");
INSERT INTO hil_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ang iya mga anak kay Raquel amo si Jose kag si Benjamin. ");
INSERT INTO hil_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ang iya mga anak kay Bilha nga ulipon ni Raquel amo si Dan kag si Naftali. ");
INSERT INTO hil_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ang iya mga anak kay Zilpa nga ulipon ni Lea amo si Gad kag si Asher. Sila tanan ang mga anak nga lalaki ni Jacob nga natawo sa Padan Aram. ");
INSERT INTO hil_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Nagkadto si Jacob sa iya amay nga si Isaac sa Mamre, malapit sa Kiriat Arba (nga ginatawag man nga Hebron). Ang ini nga lugar nga ginaestaran ni Isaac amo man anay ang gin-estaran ni Abraham. ");
INSERT INTO hil_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Nagkabuhi si Isaac sing 180 ka tuig. ");
INSERT INTO hil_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Napatay siya nga tigulang na gid, kag ginsimpon siya sa iya mga paryente nga nagkalamatay na. Ginlubong siya sang iya mga anak nga si Esau kag si Jacob. ");
INSERT INTO hil_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Amo ini ang estorya parte sa pamilya ni Esau (nga ginatawag man nga Edom). ");
INSERT INTO hil_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nagpangasawa si Esau sang mga babayi nga taga-Canaan. Sila amo si Ada nga anak ni Elon nga Hithanon kag si Oholibama nga anak ni Ana kag apo ni Zibeon nga Hivhanon. ");
INSERT INTO hil_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ginpangasawa man niya si Basemat nga utod ni Nebayot nga anak ni Ishmael. ");
INSERT INTO hil_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ang anak ni Esau kay Ada amo si Elifaz. Ang iya anak kay Basemat amo si Reuel. ");
INSERT INTO hil_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Kag ang iya mga anak kay Oholibama amo sila ni Jeush, Jalam, kag Kora. Sila ang mga anak ni Esau nga natawo sa Canaan. ");
INSERT INTO hil_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Gindala ni Esau ang iya mga asawa, mga anak, kag ang tanan nga sakop sang iya pamilya, pati ang iya mga pagkabutang kag kasapatan nga natipon niya sa Canaan, kag nagsaylo siya sa isa ka lugar palayo kay Jacob nga iya utod. ");
INSERT INTO hil_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Kay indi na sila puwede mag-upod sa isa ka lugar tungod sa kadamuon sang ila pagkabutang; kag ang lugar nga ila ginaestaran indi na makasustiner sa ila tungod sa kadamuon sang ila kasapatan. ");
INSERT INTO hil_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Gani didto nag-estar si Esau (nga ginatawag man nga Edom) sa kabukiran sang Seir. ");
INSERT INTO hil_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Amo ini ang estorya parte sa pamilya ni Esau nga amay sang mga Edomnon nga nagaestar sa kabukiran sang Seir. ");
INSERT INTO hil_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ang anak ni Esau kay Basemat amo si Reuel, kag ang anak niya kay Ada amo si Elifaz. ");
INSERT INTO hil_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ang mga anak ni Elifaz amo sila ni Teman, Omar, Zefo, Gatam kag Kenaz. ");
INSERT INTO hil_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","May anak man si Elifaz nga si Amalek sa isa pa niya ka asawa nga si Timna. Sila ang mga apo ni Esau kay Ada. ");
INSERT INTO hil_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ang mga anak ni Reuel amo sila ni Nahat, Zera, Shama, kag Miza. Sila ang mga apo ni Esau kay Basemat. ");
INSERT INTO hil_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ang mga anak ni Esau kay Oholibama amo sila ni Jeush, Jalam, kag Kora. (Si Oholibama anak ni Ana kag apo ni Zibeon.) ");
INSERT INTO hil_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Amo ini sila ang nangin pangulo sa mga kaliwat ni Esau: Si Teman, Omar, Zefo, Kenaz, ");
INSERT INTO hil_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam, kag Amalek. Ini sila nga mga pangulo sang lugar sang Edom mga anak ni Elifaz kag mga apo ni Ada. ");
INSERT INTO hil_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Nangin pangulo man sa Edom ang mga anak ni Reuel nga sila ni Nahat, Zera, Shama, kag Miza. Sila ang mga apo ni Esau kay Basemat. ");
INSERT INTO hil_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Nangin pangulo man ang mga anak ni Esau kay Oholibama nga anak ni Ana. Sila amo si Jeush, Jalam, kag Kora. ");
INSERT INTO hil_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Sila tanan ang mga kaliwat ni Esau nga mga pangulo sang Edom. ");
INSERT INTO hil_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Amo ini ang mga anak nga lalaki ni Seir nga Horhanon nga nagaestar sa Edom: Si Lotan, Shobal, Zibeon, Ana, ");
INSERT INTO hil_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, kag Dishan. Nangin pangulo man sila sang mga Horhanon nga nagaestar sa Edom. ");
INSERT INTO hil_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ang mga anak ni Lotan amo si Hori kag si Hemam. Si Lotan may utod nga babayi nga si Timna nga isa pa ka asawa ni Elifaz. ");
INSERT INTO hil_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ang mga anak ni Shobal amo sila ni Alvan, Manahat, Ebal, Shefo, kag Onam. ");
INSERT INTO hil_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ang mga anak ni Zibeon amo si Aya kag si Ana. Si Ana amo ang nakasapo sang tuburan didto sa kamingawan sang nagabantay siya sang mga donkey sang iya amay. ");
INSERT INTO hil_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ang mga anak ni Ana amo si Dishon kag si Oholibama. ");
INSERT INTO hil_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ang mga anak ni Dishon amo sila ni Hemdan, Eshban, Itran, kag Keran. ");
INSERT INTO hil_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ang mga anak ni Ezer amo sila ni Bilhan, Zaavan, kag Akan. ");
INSERT INTO hil_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ang mga anak ni Dishan amo si Uz kag si Aran. ");
INSERT INTO hil_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Amo ini sila ang mga pangulo sang mga Horhanon nga may mga ginadumalahan nga mga lugar sa Seir: Si Lotan, Shobal, Zibeon, Ana, Dishon, Ezer, kag Dishan. ");
INSERT INTO hil_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Amo ini sila ang mga hari sang Edom sang panahon nga wala pa sang mga hari ang mga Israelinhon: ");
INSERT INTO hil_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Si Bela nga taga-Dinhaba nga anak ni Beor nangin hari sa Edom. ");
INSERT INTO hil_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Pagkapatay niya, ginbuslan siya ni Jobab nga anak ni Zera nga taga-Bozra. ");
INSERT INTO hil_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Pagkapatay ni Jobab, ginbuslan siya ni Husham nga taga-Teman. ");
INSERT INTO hil_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Pagkapatay ni Husham, ginbuslan siya ni Hadad nga taga-Avit nga anak ni Bedad. Si Hadad ang nakapierdi sa mga Midianhon didto sa Moab. ");
INSERT INTO hil_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Pagkapatay ni Hadad, ginbuslan siya ni Samla nga taga-Masreka. ");
INSERT INTO hil_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Pagkapatay ni Samla, ginbuslan siya ni Shaul nga taga-Rehobot nga malapit sa Suba sang Euphrates. ");
INSERT INTO hil_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Pagkapatay ni Shaul, ginbuslan siya ni Baal Hanan nga anak ni Acbor. ");
INSERT INTO hil_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Pagkapatay ni Baal Hanan, ginbuslan siya ni Hadar nga taga-Pau. Ang iya asawa si Mehetabel nga anak ni Matred kag apo ni Mezahab. ");
INSERT INTO hil_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Si Esau (nga gintawag man nga Edom) amo ang ginhalinan sang mga Edomnon. Kag amo ini sila ang nangin pangulo sa mga kaliwat ni Esau nga ang ila mga tribo kag lugar ginpangalanan sa ila: Timna, Alva, Jetet, Oholibama, Elah, Pinon, Kenaz, Teman, Mibzar, Magdiel, kag Iram. ");
INSERT INTO hil_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Nagpabilin si Jacob sa pag-estar sa Canaan, ang lugar nga gin-estaran man anay sang iya amay. ");
INSERT INTO hil_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Kag amo ini ang estorya parte sa pamilya ni Jacob: Sang nagaedad na si Jose sing 17 ka tuig, nagabantay siya sang mga kasapatan kaupod sang iya mga utod nga mga anak ni Bilha kag ni Zilpa, nga mga asawa sang iya amay. Ginsugid ni Jose sa iya amay ang mga malain nga ginpanghimo sang iya mga utod. ");
INSERT INTO hil_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Mas palangga ni Jacob si Jose sang sa iban niya nga mga anak, tungod kay tigulang na siya sang natawo si Jose. Gani ginpatahian niya si Jose sang matahom kag malaba nga bayo. ");
INSERT INTO hil_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Pero pagkakita sang mga utod ni Jose nga mas palangga siya sang ila amay sang sa ila, nangakig sila kay Jose kag ginhambalan nila siya sang masakit nga mga estorya. ");
INSERT INTO hil_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Karon nagdamgo si Jose. Sang pagsugid niya sang iya damgo sa iya mga utod, nangakig pa gid sila tapat sa iya. ");
INSERT INTO hil_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Kay amo ini ang ginsugid niya, “Nagdamgo ako ");
INSERT INTO hil_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","nga samtang didto kita sa uma nga nagapamugkos sang mga uhay, hinali lang nga nagtindog ang akon binugkos kag ginpalibutan sang inyo mga binugkos nga nagasaludo.” ");
INSERT INTO hil_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Nagsiling ang iya mga utod, “Ano? Mangin hari ka kag magapangulo sa amon?” Gani nangakig pa gid sila kay Jose. ");
INSERT INTO hil_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Nagdamgo liwat si Jose kag ginsugid naman niya sa iya mga utod. Siling niya, “Nagdamgo naman ako nga nakita ko ang adlaw, ang bulan, kag ang onse ka bituon nga nagasaludo sa akon.” ");
INSERT INTO hil_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ginsugid man ni Jose ang iya damgo sa iya amay pero nangakig man ang iya amay sa iya. Siling niya, “Ano ang buot mo silingon? Nga kami sang imo iloy kag sang imo mga utod magasaludo sa imo?” ");
INSERT INTO hil_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Nahisa ang mga utod ni Jose sa iya, pero si Jacob iya gintago lang niya ini nga butang sa iya tagipusuon. ");
INSERT INTO hil_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Isa sadto ka adlaw, nagkadto ang mga utod ni Jose sa Shekem para magbantay sang mga sapat sang ila amay. ");
INSERT INTO hil_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","14","Karon, nagsiling si Jacob kay Jose, “Ang imo mga utod didto sa Shekem nga nagabantay sang mga sapat. Magkadto ka didto kag tan-awon mo kon bala maayo man ang kahimtangan sang imo mga utod kag sang mga sapat. Balik ka dayon kag sugiri ako.” Nagsabat si Jose, “Huo, tay.” Gani halin sa Kapatagan sang Hebron, nagkadto si Jose sa Shekem. ");
INSERT INTO hil_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Sang didto na siya nga nagalibot-libot sa latagon, may tawo nga nagpamangkot sa iya kon ano ang iya ginapangita. ");
INSERT INTO hil_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Nagsabat siya, “Ginapangita ko ang akon mga utod. Nakahibalo ka bala kon diin sila nagapahalab?” ");
INSERT INTO hil_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Nagsiling ang tawo, “Wala na sila diri. Nabatian ko nga makadto kuno sila sa Dotan.” Gani nag-apas si Jose kag nakita niya sila didto sa Dotan. ");
INSERT INTO hil_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Malayo pa si Jose nakita na siya sang iya mga utod. Kag sa wala pa siya makaabot, ginplanohan na nila nga patyon siya. ");
INSERT INTO hil_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Siling nila, “Ara na ang paladamgo. ");
INSERT INTO hil_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Dali, patyon ta siya kag ihulog dayon sa isa sining mga buho nga pulunduhan sang tubig. Silingon ta lang nga ginpatay siya sang mabangis nga sapat. Kag tan-awon ta abi kon matuman ang iya mga damgo.” ");
INSERT INTO hil_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Pero pagkabati ni Reuben sang ila plano, gintinguhaan niya nga luwason si Jose. Siling niya, “Indi ta lang siya pagpatyon. ");
INSERT INTO hil_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ihulog lang ninyo siya sa buho diri sa kamingawan, pero indi gid ninyo siya pagpatyon.” Ginsiling ato ni Reuben tungod kay plano na niya nga luwason si Jose kag ibalik sa ila amay. ");
INSERT INTO hil_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Gani pag-abot ni Jose, gin-ubahan nila siya sadtong iya bayo nga matahom kag malaba, ");
INSERT INTO hil_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","kag ginhulog sa buho nga pulunduhan sang tubig. Pero wala sadto sang tubig ang buho. ");
INSERT INTO hil_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Samtang nagakaon sila, may nalantawan sila nga mga negosyante nga Ishmaelinhon nga naghalin sa Gilead. Ang ila mga camel may karga nga mga panakot, bulong, kag pahamot nga dal-on sa Egypt. ");
INSERT INTO hil_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Nagsiling si Juda sa iya mga utod, “Ano bala ang aton makuha kon patyon ta ang aton utod kag tago-taguon ang iya kamatayon? ");
INSERT INTO hil_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ang maayo pa siguro ibaligya ta siya sa sinang mga Ishmaelinhon. Indi ta siya pagpatyon kay utod naton siya.” Nagsugot ang mga utod ni Juda sa iya. ");
INSERT INTO hil_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Gani pag-agi sang mga negosyante nga Ishmaelinhon, nga ang ila tribo Midianhon, ginbatak nila si Jose halin sa buho kag ginbaligya nila siya sa kantidad nga 20 ka bilog nga pilak. Kag gindala si Jose sang mga Ishmaelinhon sa Egypt. ");
INSERT INTO hil_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Sang pagbalik ni Reuben sa buho, wala na didto si Jose, gani gin-gisi niya ang iya bayo sa kasubo. ");
INSERT INTO hil_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Dayon nagbalik siya sa iya mga utod kag nagsiling, “Wala na didto ang aton manghod. Paano na ako makapuli karon didto kay tatay?” ");
INSERT INTO hil_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nagpatay sila sang kanding kag gintusmog nila sa dugo ang bayo ni Jose. ");
INSERT INTO hil_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Dayon gindala nila ang bayo ni Jose sa ila amay kag nagsiling, “Nakita namon ini. Tan-awa abi kon kay Jose ini ukon indi.” ");
INSERT INTO hil_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nakilala dayon ni Jacob ang bayo. Siling niya, “Iya ina! Ginpatay siya sang mabangis nga sapat! Sigurado gid nga ginus-ab siya sang sapat.” ");
INSERT INTO hil_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Gin-gisi dayon ni Jacob ang iya bayo kag nagsuksok sang sako sa pagpakita sang iya pagpangasubo. Pila gid ka adlaw ang iya pagpangasubo para iya anak. ");
INSERT INTO hil_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Gin-uloulohan siya sang tanan niya nga mga anak pero sige gid gihapon ang iya pangasubo. Siling niya, “Pabay-i lang bala ninyo ako! Mapatay ako nga nagapangasubo tungod sa pagkapatay sang akon anak.” Kag padayon ang iya paghibi tungod kay Jose. ");
INSERT INTO hil_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Karon didto sa Egypt, ginbaligya sang mga Midianhon si Jose kay Potifar nga isa sa mga opisyal sang hari sang Egypt. Kapitan siya sang mga guwardya sa palasyo. ");
INSERT INTO hil_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Sa amo man nga tion, nagbulag si Juda sa iya mga utod kag didto siya nag-estar upod kay Hira nga taga-Adulam. ");
INSERT INTO hil_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Didto nakilala ni Juda ang anak ni Shua nga taga-Canaan kag ginpangasawa niya ini. ");
INSERT INTO hil_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Sang ulihi nagbusong siya kag nagbata sing lalaki kag gin-ngalanan ini ni Juda nga Er. ");
INSERT INTO hil_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nagbusong siya liwat kag nagbata sing lalaki kag gin-ngalanan niya nga Onan. ");
INSERT INTO hil_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nagbusong pa gid siya kag nagbata sing lalaki kag gin-ngalanan niya nga Shela. Natawo si Shela sa Kezib. ");
INSERT INTO hil_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ginpaasawa ni Juda ang iya kamagulangan nga anak nga si Er sa babayi nga ang ngalan si Tamar. ");
INSERT INTO hil_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Pero si Er malain sa panulok sang Ginoo, gani ginpatay niya siya. ");
INSERT INTO hil_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Gani nagsiling si Juda kay Onan, “Pangasaw-a ang imo bayaw kay katungdanan mo ina bilang utod sang iya bana nga napatay, agod paagi sa imo may kaliwat man ang imo utod.” ");
INSERT INTO hil_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Nakahibalo si Onan nga ang mangin anak nila ni Tamar indi pagkabigon nga iya kaugalingon nga kaliwat. Gani kada maghulid sila ni Tamar, wala niya ginapasulod ang iya semilya para indi siya makabata para sa iya utod. ");
INSERT INTO hil_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Malain ang ginhimo ni Onan sa panulok sang Ginoo, gani ginpatay man niya siya. ");
INSERT INTO hil_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Nagsiling dayon si Juda kay Tamar nga iya umagad, “Pauli ka anay sa imo amay, kag indi ka magpamana hasta nga magsoltero na si Shela.” Ginsiling ato ni Juda kay nahadlok siya nga basi mapatay man si Shela pareho sa iya mga utod. Gani nagpuli anay si Tamar sa iya amay. ");
INSERT INTO hil_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Sang ulihi napatay ang asawa ni Juda. Pagkatapos sang iya pagpangasubo, nagkadto siya sa mga manuggunting sang iya mga karnero didto sa Timnah. Kaupod niya nga nagkadto didto ang iya amigo nga si Hira nga taga-Adulam. ");
INSERT INTO hil_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","May nagsugid kay Tamar nga ang iya ugangan makadto sa Timnah para guntingan didto ang iya mga karnero. ");
INSERT INTO hil_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Pagkabati sadto ni Tamar, gin-ilisan niya ang iya bayo nga pangbalo, kag gintabunan niya sang belo ang iya guya. Nagpungko dayon siya sa may puwertahan sang banwa sang Enaim, sa higad sang dalan nga pakadto sa Timnah. Plano niya nga dayaan si Juda tungod kay natalupangdan niya nga wala gihapon siya ginpaasawa kay Shela bisan soltero na si Shela. ");
INSERT INTO hil_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","16","Pagkakita ni Juda kay Tamar, wala niya siya nakilal-i nga iya umagad kay may tabon ang iya guya. Abi niya isa siya ka babayi nga nagabaligya sang iya lawas. Gani nagpalapit siya sa iya sa higad sang dalan kag nagsiling, “Dali, mahulid kita.” Nagsabat si Tamar, “Ano ang ibayad mo sa akon sa paghulid sa imo?” ");
INSERT INTO hil_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Nagsiling si Juda, “Hatagan ko ikaw sang bataon nga kanding halin sa akon kasapatan.” Nagsabat si Tamar, “Masugot ako kon may ihatag ka sa akon nga kasiguruhan hasta mapadala mo na ang kanding.” ");
INSERT INTO hil_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Nagpamangkot si Juda, “Ano nga kasiguruhan ang gusto mo?” Nagsabat si Tamar, “Ihatag sa akon ang imo pangmarka kag ang iya higot, pati ang imo baston.” Gani ginhatag ato ni Juda kag nagpakighilawas siya kay Tamar. Pagkatapos sadto nagpuli si Tamar, kag ginkuha niya ang tabon sa iya guya kag ginsuksok liwat ang bayo nga pangbalo. Sang ulihi nagbusong siya. ");
INSERT INTO hil_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Wala madugay, ginpadul-ong ni Juda ang bataon nga kanding sa iya amigo nga si Hira nga taga-Adulam para kuhaon ang mga butang nga iya ginhatag sa babayi bilang kasiguruhan, pero wala niya siya makita. ");
INSERT INTO hil_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Nagpamangkot si Hira sa mga taga-Enaim kon diin na ang babayi nga nagabaligya sang iya lawas, nga didto nagapungko sa higad sang dalan. Pero nagsabat ang mga tawo, “Wala man diri sing babayi nga nagabaligya sang iya lawas.” ");
INSERT INTO hil_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Gani nagbalik si Hira kay Juda kag nagsiling, “Wala ko siya makita. Kag siling sang mga tawo wala man kuno didto sing babayi nga nagabaligya sang iya lawas.” ");
INSERT INTO hil_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Nagsiling si Juda, “Pabay-i na lang atong akon mga butang sa iya, kay basi kadlawan pa kita sang mga tawo. Kon sa bagay, ginpadul-ungan ko man siya sining bataon nga kanding pero wala mo siya makita didto.” ");
INSERT INTO hil_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Pagkaligad sang tatlo ka bulan, ginsugiran si Juda nga ang iya umagad nga si Tamar nagbaligya sang iya lawas kag nagabusong na gani. Gani nagsiling si Juda, “Dal-a ninyo siya sa guwa sang banwa kag sunugon.” ");
INSERT INTO hil_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Pero sang ginadala na si Tamar, may ginsugo siya kay Juda sa pagsiling, “Ari ang pangmarka kag ang iya higot, pati ang baston. Ang tag-iya sini amo ang amay sang akon ginabusong. Pangilalaha abi kon kay sin-o ini.” ");
INSERT INTO hil_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Kilala ni Juda nga iya ato nga mga butang, gani nagsiling siya, “Wala siya sing sala. Ako ang nakasala kay wala ko siya ginpaasawa sa akon anak nga si Shela.” Wala na liwat naghulid si Juda kay Tamar. ");
INSERT INTO hil_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Sang manugbata na si Tamar, nasapwan nga ang iya ginabusong kapid. ");
INSERT INTO hil_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Sang ginasakitan na siya, nagguwa ang kamot sang isa ka bata. Ginhigtan ini sang paltera sang higot nga pula para mahibaluan nga siya ang una nga natawo. ");
INSERT INTO hil_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Pero ginpasulod sang bata ang iya kamot kag ang iya kapid amo ang una nga nagguwa. Nagsiling ang paltera, “Naghingagaw ka gid guwa.” Gani gin-ngalanan ang bata nga Perez. ");
INSERT INTO hil_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Dayon nagguwa man ang iya kapid nga may higot nga pula sa iya kamot. Gin-ngalanan siya nga Zera. ");
INSERT INTO hil_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Karon, sang nadala na si Jose sang mga Ishmaelinhon sa Egypt, ginbaligya siya kay Potifar nga isa sa mga opisyal sang hari sang Egypt. (Si Potifar kapitan sang mga guwardya sa palasyo.) ");
INSERT INTO hil_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Gin-ubayan gid sang Ginoo si Jose gani nagmainuswagon siya. Didto siya nag-estar sa balay sang iya agalon nga Egyptohanon nga si Potifar. ");
INSERT INTO hil_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nakita ni Potifar nga ginaubayan gid sang Ginoo si Jose kag ginapakamaayo sa tanan niya nga ginahimo, ");
INSERT INTO hil_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","gani nahulog ang iya buot kay Jose. Ginhimo niya siya nga iya kaugalingon nga kabulig kag manugdumala sang iya panimalay kag sang tanan niya nga pagkabutang. ");
INSERT INTO hil_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Halin sang tion nga si Jose ang nagadumala, ginpakamaayo sang Ginoo ang panimalay ni Potifar nga Egyptohanon kag ang tanan niya nga pagkabutang sa iya balay kag kaumahan. Ginhimo ini sang Ginoo tungod kay Jose. ");
INSERT INTO hil_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Gintugyan ni Potifar ang tanan kay Jose kag wala na siya sing iban nga ginaintiendi kundi ang iya lang nga pagkaon. Guwapo si Jose kag mabukod ang lawas. ");
INSERT INTO hil_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Sang ulihi naluyag sa iya ang asawa sang iya agalon. Ginhagad niya si Jose nga maghulid sa iya. ");
INSERT INTO hil_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Pero nagbalibad si Jose. Siling niya sa babayi, “Pamati bala! Gintugyan sa akon sang akon agalon ang tanan niya nga pagkabutang, gani wala na siya nagapalibog sa mga butang diri sa iya panimalay. ");
INSERT INTO hil_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Wala na sing may maglabaw pa sa akon sa sining panimalay. Gintugyan niya sa akon ang tanan magluwas lang sa imo tungod kay asawa niya ikaw. Gani indi ko mahimo nga traiduran ang akon agalon kag magpakasala sa Dios.” ");
INSERT INTO hil_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Bisan adlaw-adlaw ang paghagad sang babayi kay Jose nga maghulid sa iya, wala gid siya magsugot. ");
INSERT INTO hil_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Isa sadto ka adlaw, nagsulod si Jose sa balay para mag-obra. Natabuan nga wala gid sing bisan isa nga suluguon didto sa sulod sang balay. ");
INSERT INTO hil_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Karon, ginhawiran siya sa bayo sang asawa sang iya agalon kag ginsilingan, “Hulid ka sa akon.” Pero nagdalagan si Jose paguwa sa balay, kag nabilin ang iya bayo sa babayi. ");
INSERT INTO hil_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Sang makita sang babayi nga nagguwa si Jose kag nahawiran niya ang iya bayo, ");
INSERT INTO hil_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","gintawag niya ang iya mga suluguon kag nagsiling, “Tan-awa bala ninyo ini! Gindal-an kita diri sang akon bana sing Hebreo para pakahuy-an kita. Abi ninyo, nagsulod siya sa akon kuwarto para luguson ako, pero nagsinggit ako. ");
INSERT INTO hil_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Gani nagdalagan siya paguwa, kag nabilin niya ang iya bayo.” ");
INSERT INTO hil_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Gintago sang babayi ang bayo ni Jose hasta nga nag-abot ang iya bana. ");
INSERT INTO hil_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Nanugid siya dayon sa iya bana. Siling niya, “Ang Hebreo nga ulipon nga gindala mo diri luyag niya ako pakahuy-an. ");
INSERT INTO hil_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Pero sang nagsinggit ako nagdalagan siya paguwa, kag nabilin pa gani ang iya bayo.” ");
INSERT INTO hil_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Pagkabati ni Potifar sa ginsugid sang iya asawa parte sa ginhimo ni Jose, nangakig gid siya. ");
INSERT INTO hil_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Gani ginpadakop niya si Jose kag ginsulod sa prisohan sang mga priso sang hari. Pero bisan didto si Jose sa prisohan, ");
INSERT INTO hil_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","gin-ubayan gihapon siya sang Ginoo. Kag tungod sa kaayo sang Ginoo, nahulog ang buot sang manugdumala sang prisohan kay Jose. ");
INSERT INTO hil_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Gani gintugyan niya kay Jose ang pagdumala sa tanan nga priso kag sa tanan nga buluhaton sa prisohan. ");
INSERT INTO hil_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Wala na nagapalibog ang manugdumala sang prisohan sa mga butang nga gintugyan niya kay Jose, kay ginaubayan sang Ginoo si Jose kag ginapakamaayo sa tanan niya nga ginahimo. ");
INSERT INTO hil_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Natabo sang ulihi nga ang pangulo sang mga manugserbi sang ilimnon sang hari sang Egypt kag ang pangulo sang iya mga manugluto sang tinapay nakasala sa iya. Naakig gid ang hari sa sining duha niya ka opisyal. ");
INSERT INTO hil_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Gani ginpapriso niya sila sa prisohan nga sa diin napriso man si Jose, sa ginaestaran sang kapitan sang mga guwardya sa palasyo. ");
INSERT INTO hil_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Si Jose ang ginsaligan sang kapitan sang mga guwardya nga mag-atipan sa ila. Nagdugay sila didto sa prisohan. ");
INSERT INTO hil_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Isa sadto ka gab-i, nagdamgo ang manugserbi sang ilimnon kag ang manugluto sang tinapay sang hari sang Egypt samtang didto sila sa prisohan. Ang kada isa sa ila lain ang damgo kag lain man ang kahulugan sang ila damgo. ");
INSERT INTO hil_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Pagkaaga, pagkadto ni Jose sa ila, nakita niya nga maluya sila. ");
INSERT INTO hil_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Gani ginpamangkot niya sila, “Ngaa nga masinulub-on kamo?” ");
INSERT INTO hil_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nagsabat sila, “Nagdamgo abi kami pero wala sing may magpaathag sang kahulugan.” Nagsiling si Jose, “Ang Dios ang nagahatag sang kaalam sa pagpaathag sang kahulugan sang mga damgo. Abi sugiri ninyo ako kon ano ang inyo mga damgo.” ");
INSERT INTO hil_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Gani ginsugid sang pangulo sang mga manugserbi sang ilimnon ang iya damgo. Siling niya, “Nagdamgo ako nga may isa ka puno sang ubas sa akon atubangan ");
INSERT INTO hil_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","kag may tatlo ini ka sanga. Nagpanalingsing ini, nagpamulak, kag naluto ang iya pinungpong nga mga bunga. ");
INSERT INTO hil_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nagauyat ako sang kupa sang hari sang Egypt kag nagpuksi sang ubas kag ginpuga ko dayon sa kupa. Pagkatapos ginhatag ko ang kupa sa hari.” ");
INSERT INTO hil_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Nagsiling si Jose, “Amo ini ang kahulugan sang imo nga damgo: Ang tatlo ka sanga nagakahulugan sang tatlo ka adlaw. ");
INSERT INTO hil_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Sa wala pa matapos ang tatlo ka adlaw, paguwaon ka sang hari sa prisohan kag pabalikon sa imo obra bilang manugserbi sang iya ilimnon. ");
INSERT INTO hil_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kabay pa nga dumdumon mo ako kon ara ka na sa maayo nga kahimtangan. Kag bilang pagpakita sang imo kaayo sa akon, sambita man ako sa hari para mabuligan mo ako nga makaguwa sa prisohan. ");
INSERT INTO hil_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kay sa pagkamatuod, ginpuwersa lang ako nga dal-on diri halin sa lugar sang mga Hebreo, kag bisan diri wala man ako sing may nahimo nga sala para prisohon.” ");
INSERT INTO hil_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Pagkabati sang pangulo sang mga manugluto sang tinapay nga maayo ang kahulugan sang damgo sang iya kaupod, ginsugid man niya ang iya damgo kay Jose. Siling niya, “Nagdamgo man ako nga may ginalukdo ako nga tatlo ka alat nga may mga tinapay. ");
INSERT INTO hil_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ang sa ibabaw gid nga alat may sulod nga nagkalain-lain nga klase sang tinapay para sa hari sang Egypt, pero ginatuka ini sang mga pispis.” ");
INSERT INTO hil_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Nagsiling si Jose, “Amo ini ang kahulugan sang imo nga damgo: Ang tatlo ka alat nagakahulugan sang tatlo ka adlaw. ");
INSERT INTO hil_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Sa wala pa matapos ang tatlo ka adlaw, paguwaon ka sang hari sa prisohan, pero papugutan ka sang ulo kag ipatuhog ang imo bangkay sa nagatindog nga kahoy, kag pagatuk-on ka sang mga pispis.” ");
INSERT INTO hil_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Karon, ang ikatlo nga adlaw kaadlawan sang hari sang Egypt. Gani nagpapunsyon siya para sa tanan niya nga mga opisyal. Ginpaguwa niya sa prisohan ang pangulo sang iya mga manugserbi sang ilimnon kag ang pangulo sang iya mga manugluto sang tinapay kag ginpaatubang sa iya mga opisyal. ");
INSERT INTO hil_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ginpabalik niya ang pangulo sang mga manugserbi sang ilimnon sa iya obra, ");
INSERT INTO hil_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","pero ang pangulo sang mga manugluto sang tinapay, ginpatuhog niya ang bangkay sini. Natabo tanan ang ginsiling ni Jose sa ila. ");
INSERT INTO hil_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Pero wala gid makadumdom ang pangulo sang mga manugserbi sang ilimnon kay Jose. ");
INSERT INTO hil_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Pagkaligad sang duha ka tuig, nagdamgo ang hari sang Egypt nga nagatindog siya sa higad sang Suba sang Nilo. ");
INSERT INTO hil_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Gulpi lang nga may nagtakas nga pito ka baka nga matahom kag matambok, kag naghalab dayon sila sang hilamon. ");
INSERT INTO hil_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Dugay-dugay may nagtakas man nga pito ka baka nga malaw-ay kag maniwang, ");
INSERT INTO hil_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","kag ginpalapitan nila dayon ang pito ka matahom kag matambok nga mga baka kag ginkaon. Nakamata dayon ang hari. ");
INSERT INTO hil_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Natulugan liwat ang hari kag nagdamgo naman siya. Sa iya damgo nakakita siya sang pito ka uhay nga matinggas nga nag-ulhot sa isa lang ka puno. ");
INSERT INTO hil_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Kag sa sadto man nga puno, nag-ulhot man ang pito ka uhay nga huyos nga ginpakigas sang hangin nga halin sa east. ");
INSERT INTO hil_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ginlamon dayon sang huyos nga mga uhay ang pito ka matinggas nga mga uhay. Nakamata dayon ang hari. Abi niya matuod ato pero damgo man lang gali. ");
INSERT INTO hil_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Pagkaaga, naglibog ang hunahuna sang hari gani ginpatawag niya ang tanan nga madyikero kag maalamon nga mga tawo sang Egypt. Ginsugid niya sa ila ang iya mga damgo, pero wala gid sa ila sing may makapaathag sang kahulugan sadto. ");
INSERT INTO hil_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Nagpalapit dayon sa hari ang pangulo sang iya mga manugserbi sang ilimnon kag nagsiling, “Nadumduman ko subong ang akon mga sala. ");
INSERT INTO hil_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Indi bala nga nangakig ka sadto sa akon kag sa pangulo sang mga manugluto sang tinapay, kag ginpapriso mo gani kami sa ginaestaran sang kapitan sang mga guwardya sa palasyo? ");
INSERT INTO hil_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Abi mo sang isa sadto ka gab-i, nagdamgo kami nga duha, kag lain-lain ang kahulugan sang amon damgo. ");
INSERT INTO hil_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","May upod kami didto nga bataon pa nga Hebreo, nga ulipon sang kapitan sang mga guwardya sa palasyo. Ginsugid namon sa iya ang amon damgo kag ginpaathag niya sa amon ang kahulugan. ");
INSERT INTO hil_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Natabo matuod ang iya ginsiling sa amon: Ginpabalik mo ako sa akon obra kag ginpatuhog mo sa kahoy ang pangulo sang mga manugluto sang tinapay.” ");
INSERT INTO hil_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Gani ginpatawag sang hari si Jose, kag ginpaguwa siya gilayon sa prisohan. Pagkatapos niya pagunting kag pamarbas, nag-ilis siya kag nagkadto sa hari. ");
INSERT INTO hil_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Nagsiling ang hari sa iya, “Nagdamgo ako pero wala gid sing may makapaathag sang iya kahulugan. May nagsugid sa akon nga kahibalo ka magpaathag sang kahulugan sang mga damgo.” ");
INSERT INTO hil_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Nagsabat si Jose, “Indi ako, Mahal nga Hari, kundi ang Dios amo ang magahatag sang kahulugan sang imo mga damgo para sa imo ikaayo.” ");
INSERT INTO hil_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ginsugid dayon sang hari ang iya mga damgo kay Jose. Siling niya, “Nagdamgo ako nga nagatindog ako sa may pangpang sang Suba sang Nilo. ");
INSERT INTO hil_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Gulpi lang nga may nagtakas nga pito ka baka nga matahom kag matambok, kag naghalab dayon sila sang hilamon. ");
INSERT INTO hil_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Dugay-dugay may nagtakas man nga pito ka baka nga malaw-ay kag maniwang. Wala gid ako sing may nakita nga baka sa bilog nga Egypt nga pareho sadto kalaw-ay. ");
INSERT INTO hil_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Dayon ginkaon sang malaw-ay kag maniwang nga mga baka ang pito ka matambok nga mga baka nga una nga nagtakas. ");
INSERT INTO hil_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Pero pagkakaon nila, daw indi man lang mahibaluan nga nakakaon sila kay amo man gihapon sila kaniwang. Nakamata dayon ako. ");
INSERT INTO hil_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Pero natulugan ako liwat kag nagdamgo naman nga nakakita ako sang pito ka uhay nga matinggas nga nag-ulhot sa isa lang ka puno. ");
INSERT INTO hil_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kag sa sadto man nga puno, nag-ulhot man ang pito ka huyos nga mga uhay nga ginpakigas sang hangin nga halin sa east. ");
INSERT INTO hil_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ginkaon dayon sang huyos nga mga uhay ang pito ka matinggas nga mga uhay. Ginsugid ko na ini sa mga madyikero, pero wala gid sing bisan isa sa ila nga makapaathag sang iya kahulugan.” ");
INSERT INTO hil_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Nagsiling si Jose sa hari, “Mahal nga Hari, ang imo duha ka damgo isa lang ang kahulugan. Ginpahayag sa imo sang Dios kon ano ang iya pagahimuon. ");
INSERT INTO hil_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ang pito ka matambok nga mga baka kag ang pito ka matinggas nga mga uhay pareho nga pito ka tuig ang kahulugan. ");
INSERT INTO hil_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ang pito ka maniwang kag malaw-ay nga mga baka kag ang pito ka huyos nga mga uhay nga ginpakigas sang hangin nga halin sa east nagakahulugan sang pito ka tuig nga gutom. ");
INSERT INTO hil_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Suno sa ginsiling ko na sa imo, Mahal nga Hari, ginpahayag sa imo sang Dios kon ano ang iya pagahimuon. ");
INSERT INTO hil_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Sa sulod sang pito ka tuig nga magaabot, puwerte gid kabugana ang bilog nga Egypt. ");
INSERT INTO hil_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Pero sundan dayon ini sang pito ka tuig nga gutom, kag malimtan na sang mga tawo ang naagyan nila nga kabuganaan tungod kay ang gutom magahalit sa duta sang Egypt. ");
INSERT INTO hil_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Puwerte gid nga gutom ang magaabot nga daw wala lang mahibaluan nga nakaagi sang kabuganaan ang duta sang Egypt. ");
INSERT INTO hil_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Duha gid ka beses nga nagdamgo ka, Mahal nga Hari, para mahibaluan mo nga ginbuot na ini sang Dios nga matabo kag madali na lang matuman. ");
INSERT INTO hil_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Gani karon, Mahal nga Hari, dapat magpili ka sang isa ka tawo nga maalam para magdumala sa duta sang Egypt. ");
INSERT INTO hil_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Magbutang ka man sang mga opisyal sa bilog nga duta sang Egypt sa pagpreparar sa sini nga lugar sa sulod sang pito ka tuig nga kabuganaan. ");
INSERT INTO hil_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Sa sina nga mga tinuig, ipatipon mo sa ila ang tanan nga patubas. Kag sa idalom sang imo pagdumala, ipatago mo sa ila ang mga patubas sa mga bodega sang mga banwa. ");
INSERT INTO hil_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ina nga mga pagkaon itigana sa mga tawo kon mag-abot na ang pito ka tuig nga gutom sa Egypt, para indi sila magutuman.” ");
INSERT INTO hil_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Nagustuhan sang hari kag sang iya mga opisyal ang plano ni Jose. ");
INSERT INTO hil_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Nagsiling siya sa iya mga opisyal, “Wala na kita sing may makita pa nga tawo pareho kay Jose nga ginagiyahan sang espiritu sang Dios.” ");
INSERT INTO hil_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Gani nagsiling ang hari kay Jose, “Tungod kay ginsugid sa imo sang Dios ato nga mga butang, wala na siguro sing iban pa nga tawo nga may kaalam kag pag-intiendi nga pareho sa imo. ");
INSERT INTO hil_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","41","Ginahimo ko ikaw subong nga manugdumala sang akon palasyo kag gobernador sang bilog nga Egypt, kag magatuman sa imo ang tanan ko nga katawhan. Pero mas labaw ang akon awtoridad sang sa imo.” ");
INSERT INTO hil_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ginhukas dayon sang hari ang iya singsing nga pangmarka kag ginsuksok sa tudlo ni Jose. Ginpasuksukan niya si Jose sang bayo nga linen kag ginpakulintasan sang bulawan nga kulintas. ");
INSERT INTO hil_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ginpagamit man niya kay Jose ang iya ikaduha nga karwahe, kag may mga manugpahibalo nga magauna sa iya para magsinggit, “Magsaludo kamo!” Gani halin sadto ginpadumala si Jose sa bilog nga duta sang Egypt. ");
INSERT INTO hil_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Nagsiling pa gid ang hari kay Jose, “Ako ang hari diri sa Egypt, pero kon indi mo pag-itugot wala sing bisan sin-o nga makahimo sang bisan ano diri sa Egypt.” ");
INSERT INTO hil_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Gin-ngalanan niya dayon si Jose nga Zafenat Panea. Ginpaasawa man niya kay Jose si Asenat nga anak ni Potifera nga pari sa banwa sang On. Si Jose na ang nagdumala sa Egypt. ");
INSERT INTO hil_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Nagaedad sadto si Jose sing 30 ka tuig sang nag-umpisa siya sa pag-alagad sa hari sang Egypt. Isa sadto ka tion, ginbayaan anay ni Jose ang palasyo kag naglibot sa bilog nga Egypt. ");
INSERT INTO hil_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Sa sulod sang pito ka tuig nga kabuganaan, bugana gid ang mga patubas. ");
INSERT INTO hil_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Kag sa sina nga mga tinuig, ginpatipon ni Jose ang tanan nga patubas sa duta sang Egypt. Ginpatago niya sa kada banwa ang mga patubas nga halin sa kaumahan sa palibot sini. ");
INSERT INTO hil_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Puwerte gid kadamo sang uyas nga natipon ni Jose; daw pareho ini kadamo sa balas sa baybayon. Gin-untatan na lang niya ang pagtakos sini tungod indi na ini matakos. ");
INSERT INTO hil_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Sa wala pa mag-abot ang gutom, natawo ang duha ka anak ni Jose kay Asenat nga anak ni Potifera nga pari sang On. ");
INSERT INTO hil_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Gin-ngalanan ni Jose ang kamagulangan nga Manase kay suno sa iya, “Tungod sa bulig sang Dios, nalipatan ko ang akon mga pag-antos kag ang akon kahidlaw sa panimalay sang akon amay.” ");
INSERT INTO hil_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Gin-ngalanan niya ang ikaduha niya nga anak nga Efraim, kay suno sa iya, “Tungod sa bulig sang Dios, nagmauswagon ako sa lugar nga sa diin nakaagom ako sang mga kasakit.” ");
INSERT INTO hil_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Natapos na ang pito ka tuig nga kabuganaan sa Egypt, ");
INSERT INTO hil_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","kag nag-umpisa na ang pito ka tuig nga gutom pareho sang ginsiling ni Jose. May gutom man sa iban nga mga lugar pero may pagkaon ya sa bilog nga Egypt. ");
INSERT INTO hil_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Sang ulihi nabatyagan man sang mga taga-Egypt ang gutom, gani nagpangayo sila sang pagkaon sa hari. Nagsiling ang hari sa ila, “Magkadto kamo kay Jose kay siya ang magasiling sa inyo kon ano ang inyo himuon.” ");
INSERT INTO hil_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Naglambot ang gutom sa bisan diin nga lugar. Kag tungod nga puwerte gid ang gutom sa bilog nga duta sang Egypt, ginpabuksan ni Jose ang tanan nga bodega kag ginbaligyaan sang pagkaon ang mga taga-Egypt. ");
INSERT INTO hil_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Nagkadto man ang halos tanan nga nasyon sa Egypt sa pagbakal sang pagkaon kay Jose tungod kay puwerte na gid ang gutom sa bisan diin nga lugar. ");
INSERT INTO hil_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Pagkahibalo ni Jacob nga may ginabaligya nga pagkaon sa Egypt, ginsilingan niya ang iya mga anak nga lalaki, “Ano pa ang ginahulat ninyo? ");
INSERT INTO hil_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nakabati ako nga may ginabaligya kuno nga pagkaon sa Egypt, gani magkadto kamo didto kag magbakal para indi kita mapatay sa gutom.” ");
INSERT INTO hil_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Gani naglakat ang napulo ka utod ni Jose sa Egypt para magbakal sang pagkaon. ");
INSERT INTO hil_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Pero wala pagpaupda ni Jacob si Benjamin nga manghod ni Jose kay nahadlok siya nga basi may malain nga matabo sa iya. ");
INSERT INTO hil_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Gani nagkadto ang mga anak ni Jacob sa Egypt kaupod sang mga taga-iban nga lugar para magbakal sang pagkaon, kay naglapnag na ang gutom sa duta sang Canaan. ");
INSERT INTO hil_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Bilang gobernador sang Egypt, responsibilidad ni Jose ang pagbaligya sang pagkaon sa bilog nga duta. Gani pag-abot sang iya mga utod, nagluhod sila kay Jose bilang pagtahod sa iya. ");
INSERT INTO hil_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","9","Pagkakita ni Jose sa ila, nakilala niya dayon sila, pero sila ya wala makakilala sa iya. Wala lang siya nagpahalata nga siya si Jose. Nagpakig-estorya siya sa ila sing masakit. Nagpamangkot siya, “Taga-diin kamo?” Nagsabat sila, “Taga-Canaan kami, kag nagkadto kami diri para magbakal sang pagkaon.” Nadumduman dayon ni Jose ang iya damgo parte sa ila. Nagsiling siya, “Mga espiya kamo! Nagkadto kamo diri para tan-awon kon sa diin nga parte sang amon nasyon ang maluya sang depensa.” ");
INSERT INTO hil_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Nagsabat sila, “Indi, sir! Indi kami mga espiya. Nagkadto kami diri para magbakal sang pagkaon. ");
INSERT INTO hil_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Mag-ulutod kami tanan sa isa lang ka amay, kag nagasugid kami sing matuod. Indi kami mga espiya.” ");
INSERT INTO hil_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Pero nagsiling si Jose, “Indi ako magpati! Nagkadto kamo diri para tan-awon kon sa diin nga parte sang amon nasyon ang maluya sang depensa.” ");
INSERT INTO hil_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Nagsabat sila, “Sir, dose kami tanan ka mag-ulutod, kag isa lang ang amon amay nga ara subong sa Canaan. Ang amon kamanghuran didto nabilin sa iya. Ang isa namon ka utod wala na.” ");
INSERT INTO hil_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Nagsiling si Jose, “Pareho sa akon ginsiling, mga espiya gid kamo. ");
INSERT INTO hil_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Pero testingan ko kamo kon matuod gid inang inyo ginasiling. Ginasumpa ko sa ngalan sang hari sang Egypt nga indi kamo makahalin diri hasta indi ninyo madala diri ang inyo kamanghuran. ");
INSERT INTO hil_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Magpuli ang isa sa inyo para kuhaon ang inyo utod. Ang mabilin sa inyo prisohon hasta mapamatud-an ninyo ang inyo ginasiling, kay kon indi gani, matuod gid nga mga espiya kamo.” ");
INSERT INTO hil_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ginpapriso niya sila sa sulod sang tatlo ka adlaw. ");
INSERT INTO hil_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Sa ikatlo nga adlaw, nagsiling si Jose sa ila, “Nagatahod ako sa Dios, gani hatagan ko pa kamo sang kahigayunan nga mabuhi kon tumanon lang ninyo ang akon isugo sa inyo. ");
INSERT INTO hil_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kon nagasugid kamo sing matuod, magpabilin diri ang isa sa inyo kag magpuli kamo kag magdala sang pagkaon para sa ginagutom ninyo nga mga pamilya. ");
INSERT INTO hil_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Pagkatapos dal-on ninyo diri sa akon ang inyo kamanghuran para mapamatud-an ko nga wala kamo nagabutig kag para indi ko kamo pag-ipapatay.” Kag ginhimo nila ini. ");
INSERT INTO hil_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Nagsiling sila sa isa kag isa, “Ginasilutan na kita sa ginhimo ta sa aton utod. Nakita ta ang iya kasakit sang nagpakitluoy siya sa aton, pero wala gid naton siya ginkaluoyan. Amo ina ang kabangdanan kon ngaa nag-abot ini nga kalisod sa aton.” ");
INSERT INTO hil_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Nagsiling si Reuben, “Indi bala nga ginsilingan ko kamo sadto nga indi ninyo pag-anha ang bata? Pero wala gid kamo nagpamati sa akon. Gani ginasukot na kita subong sang iya kamatayon.” ");
INSERT INTO hil_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Wala sila nakahibalo nga maintiendihan ni Jose ang ila ginahambal tungod kay kon magpakighambal siya sa ila may interpreter siya. ");
INSERT INTO hil_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Naghalin anay si Jose sa ila kag naghibi. Pero sang ulihi nagbalik siya kag nagpakig-estorya sa ila. Ginpain niya si Simeon sa ila kag ginpagapos sa ila atubangan. ");
INSERT INTO hil_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Dayon nagsugo si Jose nga pun-on sang pagkaon ang mga sako sang iya mga utod kag ibalik sa ila mga sako ang ila bayad, kag pabalunan sila sang ila mga kinahanglanon sa ila pagpanglakaton. Natuman ang tanan nga ginsugo ni Jose. ");
INSERT INTO hil_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ginkarga dayon sang mga utod ni Jose ang ila mga sako sa ila mga donkey kag naglakat. ");
INSERT INTO hil_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Sang nagpalipas sila sang kagab-ihon sa isa ka lugar, may isa sa ila nga nagbukas sang iya sako para pakan-on ang iya donkey. Pagbukas niya, nakita niya didto ang kuwarta nga iya ginbayad. ");
INSERT INTO hil_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Nagsinggit siya sa iya mga utod, “Gin-uli ang akon ginbayad! Ari diri sa akon sako.” Nagpalangluya sila tanan kag kinulbaan. Nagpinamangkutanay sila, “Ano bala ining ginhimo sang Dios sa aton?” ");
INSERT INTO hil_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Pag-abot nila sa Canaan, ginsugid nila sa ila amay nga si Jacob ang tanan nga natabo sa ila. ");
INSERT INTO hil_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Siling nila kay Jacob, “Ginhambalan kami sing masakit sang gobernador sang Egypt kag ginpasibangdan nga mga espiya kuno kami. ");
INSERT INTO hil_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Pero ginsabat namon siya nga indi kami mga espiya kag nagasugid kami sing matuod. ");
INSERT INTO hil_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nagsiling man kami nga dose kami ka mag-ulutod kag isa lang ang amon amay. Ang isa namon ka utod patay na kag ang amon nga kamanghuran ari diri sa imo sa Canaan. ");
INSERT INTO hil_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Pero amo ini ang iya ginsiling sa amon, ‘Testingan ko kamo kon matuod ang inyo ginasiling. Magpabilin diri ang isa sa inyo kag magpuli kamo nga may dala nga pagkaon para sa inyo mga pamilya nga ginagutom. ");
INSERT INTO hil_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Pero dal-on ninyo diri sa akon ang inyo kamanghuran para mahibaluan ko nga nagasugid kamo sing matuod kag indi kamo mga espiya. Pagkatapos ibalik ko sa inyo ang inyo utod, kag tugutan ko kamo nga magpakadto-pakari diri sa Egypt.’ ” ");
INSERT INTO hil_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Sang ginbubo na nila ang unod sang ila mga sako, nakita nila didto sa ila mga sako ang kuwarta nga ila ginbayad. Pagkakita nila sini kag sang ila amay, kinulbaan sila tanan. ");
INSERT INTO hil_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Nagsiling si Jacob sa ila, “Gusto bala ninyo nga madulaan ako sang mga kabataan? Wala na si Jose, wala na si Simeon kag karon gusto naman ninyo nga kuhaon si Benjamin. Ako ya ang nagaantos.” ");
INSERT INTO hil_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Nagsiling si Reuben, “Tay, ako ang bahala kay Benjamin. Patya ang duha ko ka anak nga lalaki kon indi ko siya mabalik sa imo.” ");
INSERT INTO hil_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Pero nagsabat si Jacob, “Indi ko pagpaupdon sa inyo ang akon anak. Patay na ang iya utod kag siya na lang isa ang nabilin. Basi malain pa ang matabo sa iya sa dalan, kag sa katigulangon ko nga ini mapatay na lang ako nga nagapangasubo.” ");
INSERT INTO hil_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Naggrabe pa gid ang gutom sa Canaan. ");
INSERT INTO hil_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Naubos na sang pamilya ni Jacob ang pagkaon nga gindala nila halin sa Egypt. Gani naghambal si Jacob sa iya mga anak, “Balik kamo didto sa Egypt kag magbakal sing bisan diutay lang nga pagkaon.” ");
INSERT INTO hil_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Pero nagsabat si Juda sa iya, “Ginpaandaman kami sang gobernador nga indi kami magpakita sa iya kon indi namon kaupod ang amon utod nga si Benjamin. ");
INSERT INTO hil_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kon paupdon mo siya sa amon mabalik kami didto kag magbakal sang pagkaon. ");
INSERT INTO hil_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Pero kon indi gani, indi man kami magbalik didto, kay nagsiling ang gobernador nga indi kami magpakita sa iya kon indi namon kaupod ang amon utod.” ");
INSERT INTO hil_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Nagsiling si Jacob, “Ngaa ginhatagan ninyo ako sang dako nga problema? Ngaa abi ginsugiran pa ninyo ang gobernador nga may isa pa kamo ka utod?” ");
INSERT INTO hil_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Nagsabat sila, “Ano abi kay sagi gid niya kami pamangkot parte sa aton pamilya. Nagpamangkot siya kon buhi pa bala ang amon amay kag kon may utod pa bala kami nga iban. Siyempre ginsabat namon siya. Sin-o abi ang maghunahuna nga silingon niya kami nga dal-on namon didto sa iya ang amon utod?” ");
INSERT INTO hil_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Gani nagsiling si Juda sa ila amay, “Tay, paupda na lang sa amon si Benjamin para makalakat na kami dayon agod indi kita tanan mapatay sa gutom. ");
INSERT INTO hil_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Igarantiya ko ang akon kabuhi para kay Benjamin. Sukton mo ako kon ano ang matabo sa iya. Kon indi gani siya makabalik sa imo nga buhi, basulon mo ako hasta san-o. ");
INSERT INTO hil_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kon wala tani kita nag-usik sang tiyempo, siguro duha ka beses na kami nga nakabalik.” ");
INSERT INTO hil_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Nagsiling ang ila amay, “Ti, kon amo sina, maglakat kamo. Magdala kamo sa inyo mga suludlan sang pinakamaayo nga mga produkto diri sa aton lugar para iregalo sa gobernador: mga bulong, honey, panakot, pahamot, kag mga bunga sang pistasyo kag almendro. ");
INSERT INTO hil_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Dobleha ninyo ang dala ninyo nga kuwarta kay dapat ninyo ibalik ang kuwarta nga gin-uli sa inyo mga sako. Basi kon nagsala lang sila sadto. ");
INSERT INTO hil_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Dal-a ninyo ang inyo utod kag magbalik kamo gilayon sa gobernador. ");
INSERT INTO hil_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kabay pa nga tandugon sang Makagagahom nga Dios ang tagipusuon sang gobernador para maluoy siya sa inyo kag ibalik niya sa inyo si Simeon kag si Benjamin. Pero kon indi gani sila makabalik, batunon ko na lang sing hugot sa akon tagipusuon.” ");
INSERT INTO hil_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Gani nagdala ang mag-ulutod sang mga regalo kag gindoble man nila ang ila kuwarta. Dayon naglakat sila pa-Egypt kaupod si Benjamin, kag nagpakigkita sila kay Jose. ");
INSERT INTO hil_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Pagkakita ni Jose nga kaupod nila si Benjamin, ginsugo niya ang iya mayordomo, “Dal-a ining mga tawo sa balay. Mag-ihaw ka sang sapat kag magluto, kay manyaga sila upod sa akon.” ");
INSERT INTO hil_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Gintuman sang mayordomo ang sugo sa iya. Gani gindala niya ang mag-ulutod sa balay ni Jose. ");
INSERT INTO hil_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Hinadlukan ang mag-ulutod sang gindala sila sa balay ni Jose kay naghunahuna sila, “Basi gindala kita diri tungod sang kuwarta nga ginbalik sa aton mga sako sang nahauna ta nga pagkadto diri. Basi kon dakpon nila kita, kag kuhaon ang aton mga donkey kag himuon kita nga mga ulipon.” ");
INSERT INTO hil_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Gani nagpakighambal sila sa mayordomo sang sa may puwertahan pa lang sila sang balay. ");
INSERT INTO hil_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Siling nila, “Sir, dali lang anay, may isiling kami sa imo. Nagkadto kami diri anay sa pagbakal sang pagkaon. ");
INSERT INTO hil_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Sang nagapapuli na kami, nagpalipas kami sang kagab-ihon sa isa ka lugar. Kag didto ginbuksan namon ang amon mga sako kag nakita namon sa sulod ang amo gid nga kantidad sang kuwarta nga ginbayad namon. Ari gani, gindala namon para iuli. ");
INSERT INTO hil_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nagdala pa gid kami sang dugang nga kuwarta para ibakal sang pagkaon. Wala kami kahibalo kon sin-o ang nagbutang sang amon kuwarta sa amon mga sako.” ");
INSERT INTO hil_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Nagsabat ang mayordomo, “Wala ato sing kaso, kag indi kamo magkahadlok. Ang inyo Dios, nga Dios man sang inyo amay, amo siguro ang nagbutang sang sadto nga kuwarta sa inyo mga sako. Nabaton ko ang inyo bayad sadto.” Dayon gindala niya si Simeon sa ila. ");
INSERT INTO hil_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ginpasulod sang mayordomo ang mag-ulutod sa balay ni Jose kag ginhatagan sang tubig para makapanghinaw sila sang ila mga tiil. Ginhatagan man niya sang pagkaon ang ila mga donkey. ");
INSERT INTO hil_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ginpreparar sang mag-ulutod ang ila mga regalo kay Jose samtang ginahulat nila siya nga magpuli sa udto. Kay ginsilingan sila nga didto sila manyaga sa balay ni Jose. ");
INSERT INTO hil_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Pag-abot ni Jose, ginhatag nila ang ila mga regalo kag nagluhod sila sa iya atubangan bilang pagtahod. ");
INSERT INTO hil_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Nagpamangkot si Jose sa ila kon kamusta sila. Dayon nagpamangkot man siya, “Kamusta man ang inyo amay nga tigulang na, nga inyo ginsugid anay sa akon? Buhi pa bala siya?” ");
INSERT INTO hil_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Nagsabat sila, “Buhi pa si tatay kag maayo pa man siya.” Dayon nagluhod sila liwat sa iya bilang pagtahod. ");
INSERT INTO hil_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Pagkakita ni Jose kay Benjamin nga iya utod sa iya iloy, nagsiling siya, “Amo bala ini ang inyo kamanghuran nga inyo ginsugid anay sa akon?” Ginsilingan niya dayon si Benjamin, “Kabay pa nga pakamaayuhon ka sang Dios, toto.” ");
INSERT INTO hil_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Dayon nagdali-dali guwa si Jose kay daw mahibi na gid siya sa iya kahidlaw sa iya manghod. Nagsulod siya sa iya kuwarto kag didto naghibi. ");
INSERT INTO hil_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Pagkatapos nagpanghilam-os siya kag nagbalik didto sa ila nga may pagpugong sang iya balatyagon. Dayon nagsugo siya nga ihanda na ang pagkaon. ");
INSERT INTO hil_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Lain ang ginkan-an ni Jose, lain man ang ginkan-an sang iya mga utod, kag lain man ang iya sang mga Egyptohanon nga didto man nagpanyaga. Kay wala nagakaon ang mga Egyptohanon nga kaupod ang mga Hebreo, kay makangilil-ad ina para sa ila. ");
INSERT INTO hil_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Dira sa atubangan ni Jose ginpapungko ang iya mga utod. Nagtinulukay ang iya mga utod kay natingala sila nga pasunod halin sa magulang hasta sa kamanghuran ang pagpapungko sa ila. ");
INSERT INTO hil_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ginserbihan sila sang pagkaon nga halin sa atubangan ni Jose pero ang ginhatag kay Benjamin nga pagkaon lima gid ka pilo ang kadamuon sang sa iban. Nagkinaon sila kag nag-ininom kaupod si Jose. ");
INSERT INTO hil_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Karon, ginsugo ni Jose ang mayordomo sang iya balay. Siling niya, “Pun-a sang pagkaon ang mga sako sang mag-ulutod suno sa ila madala, kag ibutang ang kuwarta nga ila ginbayad sa ila mga sako. ");
INSERT INTO hil_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Dayon ibutang ang akon pilak nga kupa sa sako sang kamanghuran upod sang kuwarta nga ginbayad niya sa pagkaon.” Ginhimo sang mayordomo ang ginsiling ni Jose. ");
INSERT INTO hil_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Aga pa gid sang sunod nga adlaw, ginpalakat ang mag-ulutod upod sang ila mga donkey. ");
INSERT INTO hil_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Indi pa gid malayo sa banwa ang ila nalaktan sang nagsiling si Jose sa iya mayordomo, “Dali, lagsa ang mga tawo! Kag kon maabtan mo sila, silinga sila, ‘Ngaa malain ang ginbalos ninyo sa kaayo nga ginpakita namon sa inyo? ");
INSERT INTO hil_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ngaa ginkuha ninyo ang kupa nga ginaimnan sang akon agalon kag ginagamit niya sa pagpakot? Malain ining inyo ginhimo.’ ” ");
INSERT INTO hil_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Naabtan sang mayordomo ang mag-ulutod kag ginhambal niya ato sa ila. ");
INSERT INTO hil_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Nagsiling sila sa mayordomo, “Sir, paano nga nasiling mo ina? Imposible nga himuon namon ina nga butang. ");
INSERT INTO hil_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Kahibalo ka man nga halin sa Canaan gindala namon balik sa imo ang kuwarta nga nakita namon sa amon mga sako. Ti ngaa mangawat pa kami sang pilak ukon bulawan sa balay sang imo agalon? ");
INSERT INTO hil_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kon makita mo ina nga kupa sa isa sa amon, pagapatyon siya kag mangin ulipon ninyo kami sir.” ");
INSERT INTO hil_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Nagsiling ang mayordomo, “Sige, kon makit-an ang kupa sa isa sa inyo mangin ulipon ko siya, kag ang nabilin sa inyo wala na sing salabton.” ");
INSERT INTO hil_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Gani nagdali-dali ang kada isa sa pagpanaog sang ila mga sako kag gin-abrihan nila. ");
INSERT INTO hil_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Dayon gin-usisa sang mayordomo ang mga sako halin sa iya sang kamagulangan hasta sa iya sang kamanghuran, kag ang kupa nakita sa sako ni Benjamin. ");
INSERT INTO hil_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Pagkakita sini sang mag-ulutod, gin-gisi nila ang ila mga bayo sa kalain sang ila buot. Dayon ginkarga nila liwat sa mga donkey ang ila mga sako kag nagbalik sa banwa. ");
INSERT INTO hil_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Sang pag-abot ni Juda kag sang iya mga utod, didto pa gihapon si Jose sa iya balay. Nagsulod sila sa balay kag nagluhod sa atubangan ni Jose. ");
INSERT INTO hil_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Nagsiling si Jose sa ila, “Ano bala ining ginhimo ninyo? Wala bala kamo makahibalo nga kahibalo ako magpakot?” ");
INSERT INTO hil_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Nagsiling si Juda, “Sir, wala na kami sang may irason pa sa imo, kag indi kami makasiling nga wala kami sang sala. Ang Dios amo ang nagpahayag sang amon sala. Karon, tanan kami imo na nga ulipon—kami kag ang isa nga nakit-an sa iya ang kupa.” ");
INSERT INTO hil_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Pero nagsiling si Jose, “Indi ko mahimo ina. Siya lang nga sa iya nakita ang kupa amo ang akon mangin ulipon. Kag kamo makapuli na sa inyo amay nga wala sing sablag.” ");
INSERT INTO hil_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Nagpalapit si Juda kay Jose kag nagsiling, “Nagapangabay ako sa imo, sir, nga kon mahimo pamatii ako. Indi ka lang kuntani mangakig sa akon, ikaw nga daw pareho na sa hari sang Egypt. ");
INSERT INTO hil_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nagpamangkot ka sadto sa amon kon may amay pa kami kag utod, ");
INSERT INTO hil_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","kag ginsabat ka namon nga may amay kami nga tigulang na kag may kamanghuran nga utod nga natawo sa iya katigulangon. Patay na ang iya utod kag siya na lang ang nabilin nga anak sang iya iloy, kag palangga gid siya sang amon amay. ");
INSERT INTO hil_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Dayon nagsiling ka sa amon nga dal-on namon siya sa imo para makita mo man siya. ");
INSERT INTO hil_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nagsiling kami sa imo nga indi puwede nga bayaan sang amon kamanghuran ang amon amay, kay basi amo pa ini ang ikamatay niya. ");
INSERT INTO hil_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Pero ginsiling mo nga indi kami magpakita sa imo kon indi namon kaupod ang amon kamanghuran. ");
INSERT INTO hil_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ini tanan ginsugid namon sa amon amay sang nagpuli kami. ");
INSERT INTO hil_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Sang ulihi nagsiling ang amon amay nga magbalik kami diri liwat kag magbakal sang pagkaon. ");
INSERT INTO hil_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Pero nagsiling kami sa iya nga malakat lang kami kon upod namon ang amon kamanghuran, tungod kay indi kami puwede magpakita sa imo kon indi namon kaupod ang amon kamanghuran. ");
INSERT INTO hil_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Amo ini ang iya ginsabat sa amon, ‘Nahibaluan naman ninyo nga duha lang ang akon anak sa akon asawa nga si Raquel. ");
INSERT INTO hil_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ang isa wala na; siguro ginus-ab siya sang mabangis nga sapat. Kag hasta subong wala ko na siya makita. ");
INSERT INTO hil_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kon kuhaon pa gid ninyo ining isa nga nabilin sa akon, kag kon may matabo sa iya, ako nga tigulang na mapatay na lang sa kalisod.’ ");
INSERT INTO hil_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Gani, sir, ang kabuhi sang amon amay naangot sa kabuhi sang amon kamanghuran. Kon magpuli kami nga indi namon siya kaupod, ");
INSERT INTO hil_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","sigurado gid nga mapatay sa kasubo ang amon tigulang nga amay. ");
INSERT INTO hil_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Gin-garantiya ko ang akon kabuhi para sa amon kamanghuran. Ginsilingan ko ang akon amay nga kon indi ko siya mabalik sa iya, ako ang basulon hasta san-o. ");
INSERT INTO hil_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Gani, sir, ako na lang ang magpabilin diri bilang imo ulipon sa baylo niya, kag tuguti na lang siya nga magpuli upod sa iya mga utod. ");
INSERT INTO hil_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Indi ako magpuli nga indi siya kaupod. Indi ko mabatas nga makita ang malain nga matabo sa amon amay.” ");
INSERT INTO hil_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Indi na mapunggan ni Jose ang iya kaugalingon, gani ginpaguwa niya ang iya mga suluguon. Kag sang wala na sing iban nga tawo nga kaupod si Jose, nagpakilala siya sa iya mga utod. ");
INSERT INTO hil_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Naghibi sing tudo si Jose, gani nabatian ini sang mga Egyptohanon, kag nabalitaan ini sa palasyo sang hari. ");
INSERT INTO hil_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Nagsiling si Jose sa iya mga utod, “Ako si Jose! Matuod gid bala nga buhi pa si tatay?” Pero wala makasabat ang iya mga utod sa iya kay naurungan sila. ");
INSERT INTO hil_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Gani nagsiling si Jose, “Palapit kamo sa akon.” Sang nagpalapit na sila, nagsiling siya, “Ako si Jose nga inyo utod, ang inyo ginbaligya nga gindala diri sa Egypt. ");
INSERT INTO hil_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Karon indi kamo magkalisod kag indi ninyo pagkaugti ang inyo kaugalingon nga ginbaligya ninyo ako diri, tungod ang Dios amo ang nagpauna sa akon diri sa pagluwas sang inyo kabuhi. ");
INSERT INTO hil_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ikaduha pa lang ini nga tuig sang tiggulutom, kag may masunod pa nga lima ka tuig nga wala sing patubas. ");
INSERT INTO hil_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Pero ginpauna ako diri sang Dios para maluwas ko kamo kag mapreserbar ang madamo sa inyo diri sa kalibutan. ");
INSERT INTO hil_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Gani, indi kamo ang nagpadala diri sa akon kundi ang Dios. Ginhimo niya ako nga manuglaygay sa mahal nga hari sang Egypt kag manugdumala sang iya palasyo, kag manugdumala sang bilog nga Egypt. ");
INSERT INTO hil_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Karon, dali-dali kamo balik sa akon amay kag sugiran ninyo siya nga ang iya anak nga si Jose ginhimo sang Dios nga manugdumala sang bilog nga Egypt. Kag silingon ninyo siya nga ginapakadto ko siya diri sa akon sa labing madali. ");
INSERT INTO hil_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Silingon man ninyo siya nga puwede siya makaestar sa duta sang Goshen upod ang iya mga kabataan kag mga kaapuhan, mga kasapatan, kag ang tanan niya nga pagkabutang, para malapit siya sa akon. ");
INSERT INTO hil_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Atipanon ko siya didto sa Goshen tungod kay may lima pa ka tuig nga gutom nga magaabot. Indi ko gusto nga magutuman siya kag ang iya panimalay kag pati ang iya kasapatan.” ");
INSERT INTO hil_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Nagpadayon si Jose sa pagsiling, “Karon indi na lipod sa inyo, kag amo man sa akon utod nga si Benjamin, nga ako amo gid si Jose ang nagapakighambal sa inyo. ");
INSERT INTO hil_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Sugiri ninyo ang akon amay parte sa kadungganan nga naangkon ko diri sa Egypt kag sa tanan nga inyo nakita. Kag dal-a ninyo siya diri gilayon sa akon.” ");
INSERT INTO hil_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Dayon ginhakos ni Jose ang iya utod nga si Benjamin kag naghibi; amo man si Benjamin, nagahibi man siya samtang nagahakos kay Jose. ");
INSERT INTO hil_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Dayon ginpanghalukan ni Jose ang tanan niya nga mga utod kag nagahibi siya sa ila. Amo ato nga nakapakighambal ang iya mga utod sa iya. ");
INSERT INTO hil_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Sang nakaabot ang balita sa palasyo sang hari sang Egypt nga ang mga utod ni Jose nag-abot, nalipay ang hari kag ang iya mga opisyal. ");
INSERT INTO hil_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Nagsiling ang hari kay Jose, “Silingon mo ang imo mga utod nga kargahan nila sang pagkaon ang ila mga sapat kag magbalik sa Canaan. ");
INSERT INTO hil_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Dayon dal-on nila diri ang ila amay kag ang ila mga pamilya, kay ihatag ko sa ila ang maayo nga duta sa Egypt kag matilawan nila ang pinakamaayo nga mga produkto sini. ");
INSERT INTO hil_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Silingon mo man sila nga magdala sang mga karo halin diri sa Egypt para masakyan sang ila mga asawa kag mga kabataan sa pagsaylo diri. Kag dal-on gid nila diri ang ila amay. ");
INSERT INTO hil_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Indi sila magkanugon sa ila mga pagkabutang tungod kay ang maayo nga mga butang sa bilog nga Egypt mangin ila.” ");
INSERT INTO hil_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Gintuman ini sang mga anak ni Jacob. Kag suno sa sugo sang hari sang Egypt, ginhatagan ni Jose ang iya mga utod sang mga karo kag ginpabalunan sang pagkaon sa ila nga pagbiyahe. ");
INSERT INTO hil_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ginhatagan man niya ang kada isa sa ila sang bayo, pero ang ginhatag niya kay Benjamin lima ka bayo kag 300 ka bilog nga pilak. ");
INSERT INTO hil_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ginpadal-an man niya ang iya amay sang 10 ka donkey nga may karga nga pinakamaayo nga mga produkto sang Egypt, kag 10 ka babayi nga donkey nga may karga nga mga uyas, tinapay kag mga balalunon sang iya amay sa pagbiyahe. ");
INSERT INTO hil_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Sang ginpalakat na niya ang iya mga utod, ginsilingan niya sila nga indi sila mag-away sa dalan. ");
INSERT INTO hil_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Gani naghalin sila sa Egypt kag nagkadto sa ila amay sa Canaan. ");
INSERT INTO hil_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ginsugiran nila ang ila amay nga buhi si Jose, kag siya pa gani ang manugdumala sang bilog nga Egypt. Naurungan si Jacob; indi siya makapati. ");
INSERT INTO hil_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Pero sang ginsugiran nila siya sang tanan nga ginsiling ni Jose sa ila, kag sang makita niya ang mga karo nga ginpadala ni Jose sa pagdala sa iya sa Egypt, nagbaskog siya. ");
INSERT INTO hil_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Nagsiling si Jacob, “Kombinsido na ako! Ang akon anak nga si Jose buhi pa gali. Kadtuan ko siya antes ako mapatay.” ");
INSERT INTO hil_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Naglakat si Jacob kaupod ang iya panimalay kag dala ang tanan niya nga pagkabutang. Pag-abot niya sa Beersheba, naghalad siya sa Dios sang iya amay nga si Isaac. ");
INSERT INTO hil_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Pagkagab-i, nagpakighambal ang Dios sa iya paagi sa isa ka palanan-awon. Gintawag sang Dios si Jacob, kag nagsabat si Jacob sa iya. ");
INSERT INTO hil_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Dayon nagsiling siya, “Ako ang Dios, nga amo ang Dios sang imo amay. Indi ka magkahadlok sa pagkadto sa Egypt, kay himuon ko kamo didto nga isa ka bantog nga nasyon. ");
INSERT INTO hil_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ako mismo ang kaupod mo sa pagkadto sa Egypt kag sa pagbalik sa Canaan. Kag kon mapatay ka na, ara si Jose sa imo tupad.” ");
INSERT INTO hil_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ginpasakay si Jacob sang iya mga anak sa mga karo nga ginhatag sang hari sang Egypt para sakyan niya. Ginpasakay man nila ang ila mga asawa kag mga kabataan, kag naghalin sila didto sa Beersheba. ");
INSERT INTO hil_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Gindala nila ang ila mga kasapatan kag mga pagkabutang nga natipon nila sa Canaan. Nagkadto si Jacob sa Egypt kaupod ang tanan niya nga mga kaliwat: ang iya mga anak kag mga apo. ");
INSERT INTO hil_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Amo ini ang mga ngalan sang mga Israelinhon, ang mga kaliwat ni Jacob, nga nagkadto sa Egypt: si Reuben, nga kamagulangan nga anak ni Jacob, ");
INSERT INTO hil_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","kag ang iya mga anak nga sila ni Hanoc, Palu, Hezron kag Carmi; ");
INSERT INTO hil_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","si Simeon kag ang iya mga anak nga sila ni Jemuel, Jamin, Ohad, Jakin, Zohar kag si Shaul nga anak ni Simeon sa babayi nga Canaanhon; ");
INSERT INTO hil_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","si Levi kag ang iya mga anak nga sila ni Gershon, Kohat kag Merari; ");
INSERT INTO hil_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","si Juda kag ang iya mga anak nga sila ni Er, Onan, Shela, Perez kag Zera (pero si Er kag si Onan napatay sa Canaan), kag ang mga anak ni Perez nga si Hezron kag si Hamul; ");
INSERT INTO hil_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","si Isacar kag ang iya mga anak nga sila ni Tola, Pua, Jashub kag Shimron; ");
INSERT INTO hil_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","si Zebulun kag ang iya mga anak nga sila ni Sered, Elon kag Jaleel. ");
INSERT INTO hil_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Sila ang 33 ka anak kag apo ni Jacob kay Lea nga natawo sa Padan Aram, wala labot sa iya anak nga babayi nga si Dina. ");
INSERT INTO hil_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Nag-upod man sa Egypt: si Gad kag ang iya mga anak nga sila ni Zefon, Hagi, Shuni, Ezbon, Eri, Arodi kag Areli; ");
INSERT INTO hil_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","si Asher kag ang iya mga anak nga sila ni Imna, Ishva, Ishvi, Beria kag ang utod nila nga babayi nga si Sera, kag ang mga anak ni Beria nga si Heber kag si Malkiel. ");
INSERT INTO hil_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Sila ang 16 ka anak kag apo ni Jacob kay Zilpa, ang suluguon nga ginhatag ni Laban kay Lea. ");
INSERT INTO hil_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ang mga anak ni Jacob kay Raquel amo si Jose kag si Benjamin. ");
INSERT INTO hil_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ang mga anak ni Jose kay Asenat nga natawo sa Egypt amo si Manase kag si Efraim. (Si Asenat anak nga babayi ni Potifera nga pari sa banwa sang On.) ");
INSERT INTO hil_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Nag-upod man sa Egypt: si Benjamin kag ang iya mga anak nga sila ni Bela, Beker, Ashbel, Gera, Naaman, Ehi, Rosh, Mupim, Hupim kag Ard. ");
INSERT INTO hil_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Sila ang 14 ka anak kag apo ni Jacob kay Raquel. ");
INSERT INTO hil_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Nag-upod man sa Egypt: si Dan kag ang iya anak nga si Hushim; ");
INSERT INTO hil_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","si Naftali kag ang iya mga anak nga sila ni Jazeel, Guni, Jezer kag Shilem. ");
INSERT INTO hil_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Sila ang 7 ka anak kag apo ni Jacob kay Bilha, ang suluguon nga ginhatag ni Laban kay Raquel. ");
INSERT INTO hil_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ang kadamuon sang mga anak kag mga apo ni Jacob nga nagkadto sa Egypt 66 tanan, kag wala pa labot diri ang mga asawa sang iya mga anak. ");
INSERT INTO hil_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Pati sa duha ka anak ni Jose nga natawo sa Egypt, 70 tanan ang kabilugan sang panimalay ni Jacob sang nagkadto siya sa Egypt. ");
INSERT INTO hil_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Sang wala pa sila makaabot sa Egypt, ginsugo ni Jacob si Juda nga mag-una kadto kay Jose para itudlo sa ila ang lugar sang Goshen. Sang pag-abot na nila ni Jacob sa Goshen, ");
INSERT INTO hil_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","nagsakay si Jose sa iya karwahe kag nagkadto didto sa pagsugata sa iya amay. Sang magkitaay sila, ginhakos ni Jose ang iya amay kag sige ang iya hibi. ");
INSERT INTO hil_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Nagsiling si Jacob kay Jose, “Karon handa na ako nga mapatay tungod nakita ko na ikaw nga buhi.” ");
INSERT INTO hil_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Dayon nagsiling si Jose sa iya mga utod kag sa bilog nga panimalay sang iya amay, “Malakat ako kag sugiran ko ang hari sang Egypt nga nag-abot na ang akon mga utod kag ang bilog nga panimalay sang akon amay nga nagaestar sa Canaan. ");
INSERT INTO hil_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Silingon ko siya nga manugbantay kamo sang sapat, kag gindala gani ninyo ang inyo mga sapat kag ang tanan ninyo nga pagkabutang. ");
INSERT INTO hil_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Gani kon ipatawag niya kamo kag pamangkuton kon ano ang inyo trabaho, ");
INSERT INTO hil_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","silingon ninyo nga manugbantay kamo sang sapat halin sang gagmay pa kamo pareho sang inyo mga ginikanan, para paestaron niya kamo sa Goshen. Kay nalainan ang mga taga-Egypt sa mga manugbantay sang sapat.” ");
INSERT INTO hil_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Dayon naglakat si Jose kag nagkadto sa hari sang Egypt. Nagsiling si Jose sa hari, “Nag-abot na ang akon amay kag mga utod halin sa Canaan, kag dala nila ang ila mga kasapatan kag ang tanan nila nga pagkabutang. Didto sila subong sa Goshen.” ");
INSERT INTO hil_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ginpakilala niya dayon sa hari ang lima niya ka utod. ");
INSERT INTO hil_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ginpamangkot sila sang hari, “Ano ang inyo trabaho?” Nagsabat sila, “Mga manugbantay kami sang sapat, pareho sa amon mga ginikanan. ");
INSERT INTO hil_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Nagkadto kami diri para diri lang anay mag-estar tungod kay puwerte gid ang gutom sa Canaan, kag wala na sing mahalab ang amon mga kasapatan. Nagapangabay kami sa imo nga kon mahimo tugutan mo kami nga mag-estar sa Goshen.” ");
INSERT INTO hil_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Nagsiling ang hari kay Jose, “Karon nga nag-abot na ang imo amay kag mga utod, ");
INSERT INTO hil_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","bukas ang Egypt para sa imo pamilya. Paestara sila sa Goshen, nga isa ka maayo nga duta sa Egypt. Kon may nahibaluan ka sa ila nga masaligan, himua sila nga manugbantay sang akon mga kasapatan.” ");
INSERT INTO hil_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Gindala ni Jose ang iya amay sa hari kag ginpakilala. Pagkatapos bendisyon ni Jacob sa hari, ");
INSERT INTO hil_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ginpamangkot siya sang hari, “Pila na ang imo edad?” ");
INSERT INTO hil_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Nagsabat siya, “130 na ka tuig. Malip-ot kag mabudlay ang akon nga pagkabuhi diri sa duta. Indi ini makatupong sa kalawigon sang pagkabuhi sang akon mga katigulangan.” ");
INSERT INTO hil_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Pagkatapos ginbendisyunan liwat ni Jacob ang hari, kag dayon naghalin siya sa presensya sang hari. ");
INSERT INTO hil_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Suno sa sugo sang hari, ginpaestar ni Jose ang iya amay kag mga utod sa Egypt; ginhatag niya sa ila ang lugar sang Rameses, nga isa ka maayo nga duta sa Egypt. ");
INSERT INTO hil_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ginsustentuhan ni Jose sang pagkaon ang iya amay, mga utod, kag ang bilog nga panimalay sang iya amay, suno sa kadamuon sang ila kabataan. ");
INSERT INTO hil_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Karon, puwerte na gid ang gutom, gani wala na sang pagkaon bisan diin nga lugar. Nagluya na ang mga tawo sa Egypt kag sa Canaan tungod sa gutom. ");
INSERT INTO hil_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Gintipon ni Jose ang tanan nga kuwarta nga ginbayad sang mga taga-Egypt kag taga-Canaan sa pagkaon nga ila ginbakal, kag gindala niya ini sa palasyo sang hari. ");
INSERT INTO hil_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Nag-abot ang tiyempo nga naubos na ang kuwarta sang taga-Egypt kag taga-Canaan. Nagkadto ang mga taga-Egypt kay Jose kag nagsiling, “Wala na kami sang kuwarta. Tagai na lang kami sang pagkaon kay daw mapatay na kami sa gutom.” ");
INSERT INTO hil_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Nagsiling si Jose, “Kon wala na gid man kamo sang kuwarta, dal-a ninyo diri ang inyo mga sapat kag amo ang ibayad ninyo sa pagkaon.” ");
INSERT INTO hil_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Gani gindala nila kay Jose ang ila mga kabayo, karnero, baka, kag donkey, kag ginbaylo sa pagkaon. Sa bilog nga tuig, ginsustentuhan sila ni Jose sang pagkaon sa baylo sang ila mga sapat. ");
INSERT INTO hil_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Pagkaligad sang isa ka tuig, nagkadto naman ang mga tawo kay Jose kag nagsiling, “Indi lipod sa imo sir nga wala na kami sing kuwarta kag ang amon mga kasapatan ara na sa imo. Wala na gid sing may nabilin sa amon, luwas sa amon kaugalingon kag mga duta. ");
INSERT INTO hil_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Gani buligi man kami nga indi kami mapatay kag indi mapabay-an ang amon mga duta. Sugot kami nga mangin ulipon sang hari kag mangin iya ang amon mga duta para lang may pagkaon kami. Tagai kami dayon sang mga binhi nga matanom para indi kami mapatay kag para indi mapabay-an ang amon mga duta.” ");
INSERT INTO hil_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Gani ginbaligya sang tanan nga taga-Egypt ang ila mga duta sa kay Jose tungod puwerte na gid ang gutom. Ginbakal ini tanan ni Jose para sa hari, gani ang ato nga mga duta nangin iya sang hari. ");
INSERT INTO hil_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ginhimo ni Jose nga ulipon sang hari ang mga tawo sa bilog nga duta sang Egypt. ");
INSERT INTO hil_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ang mga duta gid lang sang mga pari ang wala mabakal ni Jose. Indi nila kinahanglan nga ibaligya ang ila mga duta tungod kay ginasustentuhan sila sang hari sang ila pagkaon. ");
INSERT INTO hil_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Nagsiling si Jose sa mga tawo, “Karon nga ginbakal ko na kamo kag ang inyo mga duta para sa hari, ari ang binhi para makatanom kamo. ");
INSERT INTO hil_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Kon mag-ani na gani kamo, ihatag ninyo sa hari ang ikalima nga parte sang inyo patubas. Kag ang nabilin inyo na, para may matanom kamo kag may pagkaon ang inyo bilog nga panimalay.” ");
INSERT INTO hil_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Nagsiling ang mga tawo, “Sir, maayo ka gid sa amon; ginluwas mo ang amon kabuhi. Sugot kami nga mangin ulipon sang hari.” ");
INSERT INTO hil_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Gani ginhimo ni Jose nga kasuguan sa duta sang Egypt nga ang ikalima nga parte sang patubas para sa hari. Ini nga kasuguan nagapadayon pa hasta subong. Ang mga duta gid lang sang mga pari ang wala ginapanag-iyahan sang hari. ");
INSERT INTO hil_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Didto nag-estar ang mga Israelinhon sa Goshen nga sakop sang Egypt. Nakaangkon sila didto sang duta kag nagdamo pa gid ang ila kabataan. ");
INSERT INTO hil_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Nag-estar si Jacob sa Egypt sang 17 ka tuig; nagkabuhi siya hasta sa edad nga 147 ka tuig. ");
INSERT INTO hil_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Sang nabatyagan niya nga dali na lang siya mapatay, gintawag niya si Jose kag nagsiling sa iya, “Kon mahimo ibutang ang imo kamot sa tunga-tunga sang duha ko ka paa kag magpromisa ka nga ipakita mo ang imo padayon nga kaayo sa akon. Indi mo ako pag-ilubong diri sa Egypt. ");
INSERT INTO hil_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Kon mapatay na ako, kuhaon mo ako diri sa Egypt kag ilubong mo ako sa lulubngan sang akon mga katigulangan.” Nagsabat si Jose, “Tumanon ko ang imo ginsiling.” ");
INSERT INTO hil_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Nagsiling dayon si Jacob, “Magsumpa ka sa akon nga tumanon mo gid ini.” Gani nagsumpa si Jose sa iya. Dayon nagluhod si Jacob sa iya hiligdaan sa pagsimba sa Dios. ");
INSERT INTO hil_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Sang ulihi may nagsugid kay Jose nga nagamasakit ang iya amay. Gani gindala niya ang iya duha ka anak nga si Manase kag si Efraim kag nagkadto sa iya. ");
INSERT INTO hil_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Sang ginsugiran si Jacob nga nag-abot ang iya anak nga si Jose, gintinguhaan niya nga makapungko sa iya hiligdaan. ");
INSERT INTO hil_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Nagsiling si Jacob kay Jose, “Sang didto pa ako sa Luz, sa duta sang Canaan, nagpakita sa akon ang Makagagahom nga Dios kag ginbendisyunan niya ako. ");
INSERT INTO hil_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Siling niya, ‘Hatagan ko ikaw sang madamo nga kaliwat para mangin amay ka sang madamo nga katawhan. Kag ihatag ko ang ini nga duta sa imo mga kaliwat kag mangin ila ini hasta san-o.’ ” ");
INSERT INTO hil_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Nagpadayon si Jacob sa pagsiling, “Ang duha mo ka anak nga si Efraim kag si Manase, nga natawo diri sa Egypt antes ako mag-abot, kabigon ko nga akon mga anak pareho kay Reuben kag kay Simeon. ");
INSERT INTO hil_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Pero ang masunod mo nga mga anak magapabilin nga imo, kag makabaton sila sang palanublion halin kay Efraim kag kay Manase. ");
INSERT INTO hil_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","“Nadumduman ko nga sang paghalin namon sa Padan kag nagapanglakaton kami sa duta sang Canaan, napatay ang imo iloy. Natabo ini sang malapit na kami sa Efrata, gani ginlubong ko na lang siya sa higad sang dalan nga pakadto sa Efrata” (nga amo man ang Betlehem.) ");
INSERT INTO hil_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Sang makita ni Israel ang mga anak ni Jose, nagpamangkot siya, “Sin-o sila?” ");
INSERT INTO hil_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Nagsabat si Jose, “Sila ang akon mga anak nga ginhatag sa akon sang Dios diri sa Egypt.” Dayon nagsiling si Israel, “Dal-a sila diri sa akon para mabendisyunan ko sila.” ");
INSERT INTO hil_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Daw indi na makakita si Israel tungod sa iya katigulangon, gani gindala ni Jose ang iya mga anak palapit kay Israel. Ginhakos sila ni Israel kag ginhalukan. ");
INSERT INTO hil_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Nagsiling si Israel kay Jose, “Wala na gid ako maglaom nga makita ko pa ikaw, pero karon gintugot sang Dios nga indi lang ikaw ang akon makita kundi pati man ang imo mga anak.” ");
INSERT INTO hil_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ginkuha dayon ni Jose ang iya mga anak sa sabak ni Israel kag nagluhod siya bilang pagtahod sa iya amay. ");
INSERT INTO hil_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Dayon ginpapalapit niya liwat ang iya mga anak sa ila lolo para bendisyunan sila. Si Efraim sa may tuo ni Jose, bali sa wala ni Israel; kag si Manase sa may wala ni Jose, bali sa tuo ni Israel. ");
INSERT INTO hil_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Pero gintungtong ni Israel ang iya tuo nga kamot sa ulo ni Efraim nga amo ang manghod, kag gintungtong niya ang iya wala nga kamot sa ulo ni Manase nga amo ang magulang. ");
INSERT INTO hil_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Dayon ginbendisyunan niya sila nga nagasiling, “Kabay pa nga bendisyunan ini nga mga bata sang Dios nga gin-alagad sang akon katigulangan nga si Abraham kag si Isaac, nga amo man ang Dios nga nagabantay sa akon halin sang akon pagkatawo hasta subong. ");
INSERT INTO hil_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Kag kabay pa nga bendisyunan man sila sang anghel nga nagluwas sa akon sa tanan nga katalagman. Kabay pa nga madumduman ako kag ang akon katigulangan nga si Abraham kag si Isaac paagi sa ila. Kag kabay pa nga magdamo gid sila sa kalibutan.” ");
INSERT INTO hil_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Pagkakita ni Jose nga ginatungtong sang iya amay ang iya tuo nga kamot sa ulo ni Efraim, naglain iya buot. Gani gin-uyatan niya ang kamot sang iya amay para sayluhon kay Manase, ");
INSERT INTO hil_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","kag nagsiling, “Tay, indi ina amo. Ari ang magulang; itungtong ang imo tuo nga kamot sa iya ulo.” ");
INSERT INTO hil_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Pero nagsabat ang iya amay, “Huo, nahibaluan ko man anak. Ang mga kaliwat ni Manase mangin bantog man nga katawhan. Pero mas mangin bantog ang mga kaliwat ni Efraim kag mangin madamo sila nga mga grupo sang mga katawhan.” ");
INSERT INTO hil_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Gani ginhimo niya si Efraim nga labaw sang sa kay Manase. Kag sang sadto nga adlaw, ginbendisyunan niya sila nga nagasiling, “Pagagamiton sang mga Israelinhon ang inyo mga ngalan sa pagbendisyon. Magasiling sila, ‘Kabay pa nga pakamaayuhon ka sang Dios pareho kay Efraim kag kay Manase.’ ” ");
INSERT INTO hil_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Dayon nagsiling si Israel kay Jose, “Madali na lang ako mapatay, pero pagaupdan kamo sang Dios kag pabalikon sa duta sang inyo katigulangan. ");
INSERT INTO hil_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Kag ikaw Jose ang magapanubli sang Shekem kag indi ang imo mga utod. Ina nga lugar naangkon ko sa pagpakig-away sa mga Amornon.” ");
INSERT INTO hil_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Dayon gintawag ni Jacob ang iya mga anak kag ginsilingan, “Magtipon kamo kay sugiran ko kamo kon ano ang matabo sa inyo sa palaabuton. ");
INSERT INTO hil_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Mga anak, magpalapit kamo kag magpamati sa akon nga inyo amay. ");
INSERT INTO hil_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ikaw Reuben, nga akon kamagulangan nga anak, ikaw ang nahauna nga bunga sang akon pagkalalaki. Mas dungganon ka kag mas gamhanan sang sa imo mga utod. ");
INSERT INTO hil_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Pero pareho ka sa nagabukal nga tubig. Kag tungod kay nagpakighilawas ka sa akon asawa nga suluguon, indi ka na labaw sang sa ila. ");
INSERT INTO hil_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Kamo Simeon kag Levi nga magkadampig, ginagamit ninyo ang inyo armas sa pagpamintas. ");
INSERT INTO hil_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Indi ako mag-intra ukon magtambong sa inyo pagtilipon kay sa inyo kaakig nagpamatay kamo sang tawo kag nagpagusto kamo pamiang sang mga turo nga baka. ");
INSERT INTO hil_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Pakamalauton kamo tungod sa inyo kaakig nga may kapintas. Laptahon ko ang inyo mga kaliwat sa Israel. ");
INSERT INTO hil_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Ikaw Juda, pagadayawon ka kag pagatahuron sang imo mga utod. Pierdihon mo ang imo mga kaaway. ");
INSERT INTO hil_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Pareho ka sang bataon pa nga leon nga pagkatapos niya pangita sang tulukbon, nagabalik siya sa iya palanaguan kag didto nagaluko. Kag wala gid sing may nagapangahas nga mag-disturbo sa iya. ");
INSERT INTO hil_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Padayon ka nga magadumala, Juda. Magahalin sa imo mga kaliwat ang mga manugdumala. Gani magahatag ang mga nasyon sang buhis sa imo kag magatuman sila sa imo. ");
INSERT INTO hil_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Mangin bugana ang imo duta; gani bisan ihigot mo ang donkey malapit sa pinakamaayo nga tanom sang ubas, indi niya ini pagkaunon. Kag bisan ipanglaba mo pa ang ilimnon indi ini maubos. ");
INSERT INTO hil_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Gani sa sobra nga inom sang ilimnon magapula ang imo mata kag sa sobra nga inom sang gatas magaputi ang imo ngipon. ");
INSERT INTO hil_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Ikaw Zebulun, magaestar ka malapit sa dagat. Ang imo lugar mangin dulungkaan sang mga sakayan. Ang imo duta magalambot hasta sa Sidon. ");
INSERT INTO hil_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Ikaw Isacar, pareho ka sa makusog nga donkey pero nagaluko lang sa elistaran sang mga karnero. ");
INSERT INTO hil_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Agwantahon mo nga magpaulipon bisan papas-anon ka sang mabug-at kag puwersahon nga magtrabaho, basta maayo kag bugana lang ang lugar nga imo estaran. ");
INSERT INTO hil_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Ikaw Dan, pagadumalahan mo sing maayo ang imo katawhan bilang isa sa mga tribo sang Israel. ");
INSERT INTO hil_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Mangin pareho ka sa dalitan nga man-og sa higad sang dalan nga nagapanukob sang tiil sang nagaagi nga kabayo, gani nagakahulog ang nagasakay sini.” ");
INSERT INTO hil_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Dayon nagsiling si Jacob, “O Ginoo, nagahulat ako sa imo pagluwas.” ");
INSERT INTO hil_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Nagpadayon pa gid siya sa pagsiling: “Ikaw Gad, pagasalakayon ka sang grupo sang mga tulisan, pero balusan mo sila samtang nagapalagyo sila. ");
INSERT INTO hil_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Ikaw Asher, mangin bugana ka sa pagkaon. Magapatubas ka sang mga pagkaon nga para sa mga hari. ");
INSERT INTO hil_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Ikaw Naftali, pareho ka sa ginbuy-an nga usa nga nagabata sang matahom nga mga bata. ");
INSERT INTO hil_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Ikaw Jose, pareho ka sa maila nga donkey sa higad sang tuburan ukon sa higad sang banglid. ");
INSERT INTO hil_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Dumtan ka sang mga manugpana. Sa ila kaugot pan-on ka nila, ");
INSERT INTO hil_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","pero sige man ang pana mo sa ila. Kag ang imo butkon padayon nga mabaskog, tungod sa bulig sang akon Gamhanan nga Dios, ang manugbantay kag ang palalipdan nga bato sang Israel. ");
INSERT INTO hil_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Siya ang Makagagahom nga Dios sang imo mga katigulangan nga nagabulig kag nagapakamaayo sa imo. Bugayan niya ikaw sang ulan kag sang tubig sa tuburan. Bugayan niya ikaw sang madamo nga kabataan kag kasapatan. ");
INSERT INTO hil_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Karon, madamo gid ang akon mga pagpakamaayo; sobra pa sa kabuganaan sang madugay na nga mga bukid. Kabay pa nga mabaton mo ini nga mga pagpakamaayo, Jose—ikaw nga labaw sang sa imo mga utod. ");
INSERT INTO hil_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Ikaw Benjamin, pareho ka sa wolf nga kon adlaw nagapangaon sang iya mabiktima, kag kon gab-i ginabahin-bahin niya ang nabilin.” ");
INSERT INTO hil_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ini sila amo ang dose ka anak ni Jacob nga ginhalinan sang mga tribo sang Israel. Kag amo ato ang pamilin-bilin ni Jacob sa kada isa sa ila. ");
INSERT INTO hil_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Dayon ginbilinan ni Jacob ang iya mga anak. Siling niya, “Madali na lang ako isimpon sa akon mga paryente nga nagkalamatay na. Kon matabo na ina, ilubong ninyo ako sa lulubngan sang akon mga katigulangan, didto sa kuweba nga ara sa uma ni Efron nga Hithanon. ");
INSERT INTO hil_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ina nga uma didto sa Macpela, sa east sang Mamre, nga sakop sang Canaan. Ginbakal sang akon lolo nga si Abraham ato nga uma kay Efron para himuon nga lulubngan. ");
INSERT INTO hil_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Didto siya ginlubong pati ang akon lola nga si Sara kag ang akon amay kag iloy nga si Isaac kag si Rebeka, kag didto ko man ginlubong si Lea. ");
INSERT INTO hil_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ini nga uma kag kuweba ginbakal sa mga Hithanon.” ");
INSERT INTO hil_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Pagkatapos hambal ni Jacob sa iya mga kabataan, naghigda siya kag nabugtuan sang ginhawa. Kag ginsimpon siya sa iya mga paryente nga nagkalamatay na. ");
INSERT INTO hil_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ginhakos dayon ni Jose ang iya amay kag ginhalukan nga nagahibi. ");
INSERT INTO hil_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Dayon ginsugo niya ang iya mga manugbalsamar nga balsamaron ang iya amay. Gani ginbalsamar nila siya. ");
INSERT INTO hil_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ang kalawigon sang pagbalsamar sa iya 40 ka adlaw, suno sa kinaandan sang mga taga-Egypt. Nagpangasubo ang mga Egyptohanon para kay Jacob sa sulod sang 70 ka adlaw. ");
INSERT INTO hil_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Sang matapos ang ila pagpangasubo, nagsiling si Jose sa mga opisyal sang hari sang Egypt, “Kon mahimo hambala ninyo ang hari ");
INSERT INTO hil_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","nga tugutan niya ako nga ilubong ko ang akon amay sa Canaan. Kay antes siya mapatay, ginpasumpa niya ako nga ilubong ko siya sa lulubngan nga iya ginpahimo sa Canaan. Pagkatapos lubong mabalik man dayon ako.” ");
INSERT INTO hil_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pagkahibalo sang hari, nagsiling siya kay Jose, “Tumana ang imo ginsumpa sa imo amay. Lakat ka kag ilubong siya.” ");
INSERT INTO hil_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Gani naglakat si Jose kaupod ang madamo nga opisyal sang hari: ang mga manugdumala sang palasyo kag ang mga manugdumala sang Egypt. ");
INSERT INTO hil_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Kaupod man ang panimalay ni Jose kag ang panimalay sang iya mga utod, ang bilog nga panimalay ni Jacob. Ang nabilin sa Goshen amo lang ang ila magagmay nga mga kabataan kag ang ila mga kasapatan. ");
INSERT INTO hil_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kaupod man nila ang mga karwahe kag mga manugkabayo. Madamo gid sila. ");
INSERT INTO hil_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Pag-abot nila sa linasan sa Atad, malapit sa Suba sang Jordan, nagpangasubo sila didto para kay Jacob kag puwerte gid ang ila paghibi. Nagpangasubo si Jose sing pito ka adlaw para sa iya amay. ");
INSERT INTO hil_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Pagkakita sang mga Canaanhon sang ila pagpangasubo sa may linasan sa Atad, nagsiling sila, “Puwerte gid ang pagpangasubo sang mga Egyptohanon.” Gani ato nga lugar nga malapit sa Suba sang Jordan gintawag nga Abel Mizraim. ");
INSERT INTO hil_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Gintuman sang mga anak ni Jacob ang iya ginbilin sa ila. ");
INSERT INTO hil_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Kay gindala nila ang iya bangkay sa Canaan kag ginlubong sa kuweba nga ara sa uma sa Macpela, sa east sang Mamre. Ginbakal ni Abraham ang ini nga uma kay Efron nga Hithanon para himuon nga lulubngan. ");
INSERT INTO hil_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Pagkatapos sang lubong, nagbalik si Jose sa Egypt upod ang iya mga utod kag ang tanan nga nag-upod sa paglubong. ");
INSERT INTO hil_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Karon nga patay na ang ila amay, nagsiling ang mga utod ni Jose, “Basi nagadumot pa si Jose sa aton kag balusan niya kita sa ginhimo ta sa iya.” ");
INSERT INTO hil_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Gani nagpadala sila sang mensahi kay Jose nga nagasiling, “Nagbilin ang aton amay antes siya mapatay ");
INSERT INTO hil_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","nga hambalon ka nga patawaron mo kami sa malain nga ginhimo namon sa imo. Gani karon, kabay pa nga patawaron mo kami nga suluguon man sang Dios sang aton amay.” Sang makaabot ang ila mensahi kay Jose, naghibi siya. ");
INSERT INTO hil_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Sang ulihi nagkadto mismo ang iya mga utod sa iya. Pag-abot nila, nagluhod sila sa iya atubangan bilang pagtahod. Dayon nagsiling sila, “Handa kami nga mangin ulipon mo.” ");
INSERT INTO hil_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Pero nagsabat si Jose sa ila, “Indi kamo magkahadlok. Dios bala ako? ");
INSERT INTO hil_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Matuod nga nagplano kamo sang malain sa akon, pero ginplano na sang Dios nga magaresulta ato sang kaayuhan nga amo ang pagluwas subong sang madamo nga tawo sa gutom. ");
INSERT INTO hil_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Gani indi kamo magkahadlok. Sustentuhan ko kamo sang pagkaon pati ang inyo mga kabataan.” Ginpasalig sila ni Jose kag napahamtang ang ila balatyagon. ");
INSERT INTO hil_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Nagtiner si Jose sa Egypt upod ang bilog nga panimalay sang iya amay. Nagkabuhi siya sing 110 ka tuig, ");
INSERT INTO hil_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","kag iya pa nakita ang iya mga apo sa tuhod sa iya anak nga si Efraim kag sa iya apo nga si Makir nga anak ni Manase. Ginkabig niya bilang kaugalingon nga anak ang mga anak ni Makir. ");
INSERT INTO hil_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Karon, nagsiling si Jose sa iya mga paryente, “Madali na lang ako mapatay, pero indi gid kamo pagpabay-an sang Dios. Kuhaon niya kamo sa sini nga lugar kag dal-on sa lugar nga iya ginpromisa kay Abraham, Isaac kag Jacob.” ");
INSERT INTO hil_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Dayon ginpasumpa ni Jose ang mga Israelinhon. Siling niya, “Ipromisa ninyo nga kon pahalinon na kamo diri sang Dios, dal-on man ninyo ang akon tul-an sa inyo paghalin sa sini nga lugar.” ");
INSERT INTO hil_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Napatay si Jose sa edad nga 110 ka tuig. Ginbalsamar siya kag ginbutang sa lungon didto sa Egypt.");
INSERT INTO hil_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Amo ini ang mga anak nga lalaki ni Jacob nga nag-upod sa iya sa Egypt, kaupod ang ila mga pamilya: ");
INSERT INTO hil_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Si Reuben, Simeon, Levi, Juda, ");
INSERT INTO hil_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zebulun, Benjamin, ");
INSERT INTO hil_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali, Gad, kag Asher. ");
INSERT INTO hil_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Si Jose didto na nga daan sa Egypt. 70 tanan ang kaliwat ni Jacob sang nagkadto siya sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Sang ulihi napatay si Jose kag ang tanan niya nga utod. Naglipas ang ina nga henerasyon, ");
INSERT INTO hil_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","pero madasig nga nagdamo ang ila mga kaliwat, ang kaliwat sang Israelinhon. Sa ila puwerte nga kadamo naglapta sila sa bisan diin nga parte sang Egypt. ");
INSERT INTO hil_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Karon, may bag-o na nga hari sa Egypt nga wala makakilala kay Jose. ");
INSERT INTO hil_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Nagsiling siya sa iya katawhan, “Tan-awa bala ninyo! Madamo na gid ang mga Israelinhon, gani delikado na ang aton kahimtangan. ");
INSERT INTO hil_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Kay basi bala sa tion sang inaway magadampig sila sa aton mga kaaway kag magakontra sa aton, kag dayon makapalagyo sila sa aton nasyon. Gani mangita kita sang maayo nga paagi nga indi na sila magdamo pa.” ");
INSERT INTO hil_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Gani ginpadumalahan nila ang mga Israelinhon sa mga tawo nga nagpaantos kag nagpaobra sa ila sing tudo-tudo gid. Ginpaobra sa ila ang mga banwa sang Pitom kag Rameses nga bulutangan sang mga bodega sang hari sang Egypt. ");
INSERT INTO hil_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Pero samtang ginapabudlayan sila nga ginapabudlayan, nagadamo pa gid gani sila nga nagadamo, kag naglalapta pa gid sila sa Egypt. Gani hinadlukan na gid ang mga Egyptohanon sa ila. ");
INSERT INTO hil_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Tungod sini, gindugangan pa gid nila ang ila kapintas sa pag-ulipon sa mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Wala gid sila sing kaluoy sa mga Israelinhon. Ginpabudlayan gid nila sila paagi sa pagpatrabaho sa ila sa mga tisa kag pangsemento. Kag ginpaobra nila sila sing tudo-tudo sa uma. ");
INSERT INTO hil_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Dayon nagsiling ang hari sang Egypt sa mga Hebreo nga paltera nga sila ni Shifra kag Pua, ");
INSERT INTO hil_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Sa inyo pagpabata sa mga Hebreo nga babayi, patya ninyo ang bata kon lalaki, pero kon babayi, indi lang pagpatya.” ");
INSERT INTO hil_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Pero tungod nga nahadlok ang mga paltera sa Dios, wala nila pagtumana ang ginsiling sang hari, sa baylo ginpabay-an nila nga mabuhi ang mga lapsag nga lalaki. ");
INSERT INTO hil_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Gani ginpatawag sang hari sang Egypt ang mga paltera kag ginpamangkot, “Ngaa ginhimo ninyo ini? Ngaa ginpabay-an ninyo nga mabuhi ang mga lapsag nga lalaki?” ");
INSERT INTO hil_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Nagsabat ang mga paltera, “Ang mga Hebreo nga babayi indi pareho sa mga Egyptohanon nga babayi; mahapos lang sila magbata kag sa wala pa kami makaabot nakabata na sila.” ");
INSERT INTO hil_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Gani ginpakamaayo sang Dios ang mga paltera, kag nagdamo pa gid nga nagdamo ang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Kag tungod nga nagatahod ang mga paltera sa Dios, ginhatagan sila sang Dios sang ila kaugalingon nga pamilya. ");
INSERT INTO hil_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Sang ulihi nagmando ang hari sang Egypt sa tanan niya nga katawhan, “Ipanghaboy ninyo sa Suba sang Nilo ang tanan nga bata nga lalaki sang mga Israelinhon nga bag-o natawo, pero pabay-i lang nga mabuhi ang mga bata nga babayi.” ");
INSERT INTO hil_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","May isa ka tawo nga kaliwat ni Levi nga nakapangasawa sang isa ka babayi nga kaliwat man ni Levi. ");
INSERT INTO hil_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nagbusong ini nga babayi kag nagbata sing lalaki. Sang makita niya nga maayo ang lawas sang bata, gintago niya ini sa sulod sang tatlo ka bulan. ");
INSERT INTO hil_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Pero sang indi na niya matago ang bata, nagkuha siya sang basket nga hinimo halin sa tanom nga papyrus kag ginpintahan niya ini sang alkitran. Dayon ginsulod niya ang bata sa sini nga basket kag ginbutang ang basket sa mga tigbaw sa higad sang Suba sang Nilo. ");
INSERT INTO hil_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ang utod nga babayi sang sini nga bata nagatindog sa unhan nga nagatan-aw kon ano ang matabo sa bata. ");
INSERT INTO hil_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Karon, ang anak nga babayi sang hari sang Egypt nagkadto sa Suba sang Nilo para magpaligo. Ang iya mga suluguon nga babayi nagalakat-lakat sa higad. Karon, nakita niya ang basket sa mga tigbaw, gani ginpakuha niya ini sa isa sang iya mga suluguon. ");
INSERT INTO hil_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Dayon ginbuksan niya ang basket kag nakita niya ang bata nga nagahibi, gani naluoy gid siya sa bata. Nagsiling siya, “Isa ini sa mga Hebreo nga bata.” ");
INSERT INTO hil_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Dayon nagpalapit ang utod nga babayi sang bata sa prinsesa kag nagpamangkot, “Gusto mo bala nga kuhaan ko ikaw sang isa ka Hebreo nga babayi nga magpatiti kag mag-atipan sang bata para sa imo?” ");
INSERT INTO hil_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Nagsabat ang prinsesa, “Sige.” Gani naglakat ang utod sang bata kag ginkadtuan niya ang ila iloy kag gindala sa prinsesa. ");
INSERT INTO hil_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Nagsiling ang prinsesa sa iloy sang bata, “Dal-a ini nga bata, patitia kag atipana para sa akon kay suhulan ko ikaw.” Gani ginkuha niya ang bata kag gin-atipan. ");
INSERT INTO hil_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Sang nalutas na ang bata, gindala siya sang iya iloy sa prinsesa, kag ginkabig siya sang prinsesa nga iya anak. Gin-ngalanan sang prinsesa ang bata nga Moises, kay siling niya, “Ginkuha ko siya sa tubig.” ");
INSERT INTO hil_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Isa ka adlaw, sang dako na si Moises, nagkadto siya sa iya mga kadugo, kag nakita niya nga ginapabudlayan sila kag ginapaobra sing tudo-tudo gid. Nakita niya ang isa ka Egyptohanon nga nagakastigo sang isa ka Hebreo nga iya kadugo. ");
INSERT INTO hil_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Nagpanan-aw tan-aw si Moises sa palibot kon may nagatulok; kag sang wala siya sing may nakita, ginpatay niya ang Egyptohanon kag ginlubong ang bangkay sa balas. ");
INSERT INTO hil_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Pagkasunod nga adlaw, naglakat liwat siya kag nakita niya ang duha ka Hebreo nga nagaaway. Ginpamangkot niya ang isa nga may sala, “Ngaa ginakastigo mo ang imo kapareho nga Hebreo?” ");
INSERT INTO hil_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Nagsabat ang tawo, “Sin-o ang naghimo sa imo nga pangulo kag manughukom namon? Ano, patyon mo man bala ako pareho sa ginhimo mo sa Egyptohanon?” Hinadlukan si Moises kag nagsiling sa iya kaugalingon, “Nahibaluan gali sang mga tawo ang akon ginhimo.” ");
INSERT INTO hil_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Pagkahibalo sang hari sang Egypt sa ginhimo ni Moises, nagtinguha siya sa pagpatay sa iya, pero nagpalagyo si Moises sa Midian kag didto nag-estar. Pag-abot niya sa Midian, nagpungko siya sa kilid sang bubon. ");
INSERT INTO hil_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Karon, ang pito ka anak nga babayi sang pari sa Midian nagkadto sa pagsag-ob para sa mga ilimnan sang mga sapat sang ila amay. ");
INSERT INTO hil_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","May nag-abot man didto nga mga manugbantay sang sapat kag ginpahalin nila ang mga babayi kag ang ila mga sapat, pero ginbuligan sila ni Moises kag ginpainom pa niya ang ila mga sapat. ");
INSERT INTO hil_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Pagpuli sang mga babayi sa ila amay nga si Reuel, ginpamangkot niya sila, “Ngaa temprano pa kamo nagpuli subong?” ");
INSERT INTO hil_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Nagsabat sila, “May isa ka Egyptohanon nga nagbulig sa amon kontra sa mga manugbantay sang sapat, kag ginsag-uban pa gani niya kami kag ginpainom ang amon mga sapat.” ");
INSERT INTO hil_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Nagpamangkot ang ila amay, “Ti, diin na siya? Ngaa ginbayaan ninyo siya? Tawga ninyo siya kag agdaha nga magkaon.” ");
INSERT INTO hil_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Nagsugot si Moises nga magdayon sa balay ni Reuel, kag sang ulihi ginpaasawa ni Reuel sa iya ang iya anak nga si Zipora. ");
INSERT INTO hil_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Nagbusong si Zipora kag nagbata sing lalaki, kag gin-ngalanan siya ni Moises nga Gershom, kay siling niya, “Pangayaw ako sa sini nga lugar.” ");
INSERT INTO hil_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Pagkaligad sang malawig nga tinuig, napatay ang hari sang Egypt. Pero sige gihapon ang pag-antos sang mga Israelinhon sa ila pagkaulipon. Nagpangayo sila sang bulig, kag nakaabot ini sa Dios. ");
INSERT INTO hil_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nabatian sang Dios ang ila mga pag-ugayong, kag gindumdom niya ang iya kasugtanan kay Abraham, Isaac, kag kay Jacob. ");
INSERT INTO hil_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nakita sang Dios ang ila kahimtangan kag naluoy gid siya sa ila. ");
INSERT INTO hil_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Isa ka adlaw, nagabantay si Moises sa mga kasapatan sang iya ugangan nga si Jetro nga pari sang Midian. Gindala ni Moises ang mga sapat sa unhan sang kamingawan kag nakaabot siya sa Horeb, ang bukid sang Dios. ");
INSERT INTO hil_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Didto nagpakita sa iya ang anghel sang Ginoo sa dagway sang nagadabadaba nga kalayo sa tunga sang kahoy-kahoy. Nakita ni Moises nga nagadabadaba ang kahoy-kahoy pero wala ini nagakasunog. ");
INSERT INTO hil_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Nagsiling siya, “Makatilingala! Ngaa bala wala nagakasunog ina nga kahoy-kahoy? Palapitan ko abi kag tan-awon.” ");
INSERT INTO hil_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Pagkakita sang Ginoo nga nagpalapit si Moises sa pagtan-aw, nagtawag siya sa iya halin sa tunga sang kahoy-kahoy, “Moises, Moises!” Nagsabat si Moises, “Ano tani?” ");
INSERT INTO hil_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Nagsiling ang Dios, “Indi ka na magpalapit pa. Ubaha ang imo sandalyas, kay balaan ang lugar nga imo ginatindugan. ");
INSERT INTO hil_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ako ang Dios sang imo mga katigulangan, ang Dios ni Abraham, Isaac, kag Jacob.” Gintabunan ni Moises ang iya guya, kay nahadlok siya magtan-aw sa Dios. ");
INSERT INTO hil_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Dayon nagsiling ang Ginoo, “Nakita ko gid ang pag-antos sang akon katawhan sa Egypt. Nabatian ko ang ila pagpangayo sang bulig tungod sa pagpaantos sa ila sang mga nagadumala sa ila sa trabaho, kag naluoy gid ako sa ila tungod sa ila mga pag-antos. ");
INSERT INTO hil_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Gani nagpanaog ako sa pagluwas sa ila sa kamot sang mga Egyptohanon, kag sa pagdala sa ila sa maayo, malapad, kag mapatubason nga duta, nga ginaestaran subong sang mga Canaanhon, Hithanon, Amornon, Periznon, Hivhanon, kag mga Jebusnon. ");
INSERT INTO hil_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Karon pamatii ini! Nabatian ko ang pagpangayo sang bulig sang mga Israelinhon, kag nakita ko kon paano sila ginapabudlayan sang mga Egyptohanon. ");
INSERT INTO hil_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Gani ipadala ko ikaw sa hari sang Egypt sa pagpaguwa sang akon katawhan nga mga Israelinhon sa Egypt.” ");
INSERT INTO hil_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Pero nagsiling si Moises sa Dios, “Sin-o gid ako nga magkadto sa hari kag magpaguwa sang mga Israelinhon sa Egypt?” ");
INSERT INTO hil_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Nagsiling ang Dios, “Magaupod ako sa imo, kag amo ini ang mangin tanda nga ako ang nagpadala sa imo: Kon mapaguwa mo na gani ang mga Israelinhon sa Egypt, magasimba kamo sa akon sa sini nga bukid.” ");
INSERT INTO hil_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Nagsiling si Moises sa Dios, “Halimbawa, makadto ako sa mga Israelinhon kag magsiling sa ila nga ang Dios sang ila mga katigulangan amo ang nagpadala sa akon sa ila, kag mamangkot sila sa akon, ‘Sin-o ang iya ngalan?’ Ti, ano ang akon isabat sa ila?” ");
INSERT INTO hil_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Nagsabat ang Dios kay Moises, “Ako ang Dios nga amo sa gihapon. Amo ini ang imo isabat sa ila: ‘Ang Dios nga amo sa gihapon amo ang nagpadala sa akon sa inyo.’ ” ");
INSERT INTO hil_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Nagsiling pa gid ang Dios kay Moises, “Ihambal ini sa mga Israelinhon: ‘Ang Ginoo, ang Dios sang inyo mga katigulangan nga si Abraham, Isaac, kag Jacob, amo ang nagpadala sa akon sa inyo.’ Kilalahon ako sa akon ngalan nga Ginoo hasta san-o.” ");
INSERT INTO hil_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Dayon nagsiling ang Ginoo kay Moises, “Lakat kag tipuna ang mga manugdumala sang Israel kag silinga sila, ‘Ang Ginoo, ang Dios sang inyo mga katigulangan nga si Abraham, Isaac, kag Jacob, nagpakita sa akon, kag nagsiling: Ginabantayan ko gid kamo, kag nakita ko ang ginahimo sang mga Egyptohanon sa inyo. ");
INSERT INTO hil_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Nagapromisa ako nga paguwaon ko kamo sa Egypt nga sa diin nagaantos kamo, kag dal-on sa duta sang mga Canaanhon, Hithanon, Amornon, Periznon, Hivhanon, kag mga Jebusnon—ang duta nga maayo kag mapatubason.’ ");
INSERT INTO hil_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Magapamati sa imo ang mga manugdumala sang Israel. Kag dayon, ikaw kag ang mga manugdumala magkadto sa hari sang Egypt kag magsiling sa iya, ‘Nagpakigkita sa amon ang Ginoo, ang Dios sang mga Hebreo. Gani kon mahimo tuguti kami sa paglakat sing tatlo ka adlaw sa kamingawan sa paghalad sa Ginoo nga amon Dios.’ ");
INSERT INTO hil_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Pero nahibaluan ko nga indi kamo pagtugutan sang hari sang Egypt luwas lang kon may magpilit sa iya. ");
INSERT INTO hil_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Gani silutan ko ang mga Egyptohanon paagi sa mga milagro nga himuon ko sa ila. Pagkatapos tugutan na niya kamo sa paglakat. ");
INSERT INTO hil_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Kag himuon ko nga magmaayo sa inyo ang mga Egyptohanon, para kon maglakat na kamo pabalunan pa nila kamo. ");
INSERT INTO hil_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ang mga babayi nga Israelinhon magapangayo sang mga alahas nga pilak kag bulawan kag sang mga bayo sa ila kasilingan nga mga Egyptohanon kag sa mga pangayaw didto sa Egypt. Kag ipasuksok ninyo ini nga mga butang sa inyo mga kabataan. Sa sini nga paagi, makuhaan ninyo sang mga pagkabutang ang mga Egyptohanon.” ");
INSERT INTO hil_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Nagsabat si Moises, “Paano kon indi magpati sa akon ang mga Israelinhon ukon magpamati sa akon isiling? Paano kon magsiling sila, ‘Wala nagpakita sa imo ang Ginoo’?” ");
INSERT INTO hil_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Nagsiling ang Ginoo sa iya, “Ano inang ginauyatan mo?” Nagsabat si Moises, “Baston.” ");
INSERT INTO hil_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Nagsiling ang Ginoo, “Ihaboy ina sa duta.” Gani ginhaboy ni Moises ang baston kag nahimo ini nga man-og, kag nagdalagan siya palayo sini. ");
INSERT INTO hil_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Nagsiling ang Ginoo sa iya, “Dakpa ang man-og sa ikog.” Gani gindakop ni Moises ang man-og kag nahimo ini liwat nga baston. ");
INSERT INTO hil_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Nagsiling ang Ginoo, “Himua ini nga milagro para magpati sila nga ako, ang Ginoo, ang Dios sang ila mga katigulangan nga si Abraham, Isaac, kag Jacob, nagpakita sa imo.” ");
INSERT INTO hil_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Nagsiling pa gid ang Ginoo, “Ibutang ang imo kamot sa sulod sang imo bayo.” Gintuman ini ni Moises, kag sang ginkuha na niya ang iya kamot, puwerte ini kaputi tungod nga gintubuan ini sang delikado nga balatian sa panit. ");
INSERT INTO hil_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Nagsiling ang Ginoo, “Ibutang liwat ang imo kamot sa sulod sang imo bayo.” Gintuman ini ni Moises, kag sang ginkuha na niya ang iya kamot, maayo na ini pareho sa iban nga mga parte sang iya lawas. ");
INSERT INTO hil_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Dayon nagsiling ang Ginoo, “Kon indi sila magpati sa una nga milagro, mapati na sila sa ikaduha. ");
INSERT INTO hil_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Pero kon indi pa gid gani sila magpati sa imo pagkatapos sining duha ka milagro, magkuha ka sang tubig sa Suba sang Nilo kag ibubo ini sa mamala nga duta, kag mahimo ini nga dugo.” ");
INSERT INTO hil_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Nagsiling si Moises sa Ginoo, “Ginoo, indi ako maayo maghambal. Halin pa sang una pigaw ako pahambalon, kag bisan subong nga nagapakighambal ka sa akon nga imo alagad. Nagautol-utol ako kon maghambal.” ");
INSERT INTO hil_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Nagsiling ang Ginoo sa iya, “Sin-o bala ang nagahimo sang baba sang tawo? Sin-o bala ang nagahimo sa iya nga bungol ukon apa? Sin-o bala ang nagabuot nga makakita siya ukon mabulag? Indi bala ako, ang Ginoo? ");
INSERT INTO hil_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Gani lakat, kay buligan ko ikaw sa paghambal kag tudluan ko ikaw kon ano ang imo ihambal.” ");
INSERT INTO hil_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Pero nagsiling si Moises, “O Ginoo, kon mahimo magpadala ka na lang sang iban.” ");
INSERT INTO hil_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Naakig ang Ginoo kay Moises, kag nagsiling siya, “Ti, si Aaron na lang nga imo utod, nga kaliwat man ni Levi. Nahibaluan ko nga maayo siya maghambal. Nagapakadto na siya gani diri sa pagpakigkita sa imo. Malipay gid siya kon makita niya ikaw. ");
INSERT INTO hil_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Estoryahon mo siya, kag tudluan mo siya kon ano ang iya ihambal. Buligan ko kamo nga duha sa paghambal, kag tudluan ko man kamo kon ano ang inyo himuon. ");
INSERT INTO hil_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Si Aaron ang magahambal sa mga tawo para sa imo. Tudluan mo siya kon ano ang iya ihambal, subong nga daw ikaw ang Dios. ");
INSERT INTO hil_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Kag dal-a ang imo baston agod paagi sina makahimo ka sang mga milagro.” ");
INSERT INTO hil_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Nagbalik si Moises kay Jetro nga iya ugangan kag nagsiling sa iya, “Tuguti ako sa pagbalik sa akon mga kadugo sa Egypt sa pagtan-aw kon bala buhi pa sila.” Nagsiling si Jetro, “Sige, kag maayo lang nga paglakat.” ");
INSERT INTO hil_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Antes maghalin si Moises sa Midian nagsiling ang Ginoo sa iya, “Sige, balik na sa Egypt kay nagkalamatay na ang tanan nga gusto magpatay sa imo.” ");
INSERT INTO hil_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Gani ginkuha ni Moises ang iya asawa kag mga anak nga lalaki kag ginpasakay sa donkey kag nagbalik sa Egypt. Gindala man niya ang baston nga ginsugo sang Dios nga iya dal-on. ");
INSERT INTO hil_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Nagsiling ang Ginoo kay Moises, “Pag-abot mo sa Egypt, himuon mo gid sa atubangan sang hari ang tanan nga milagro nga ginapahimo ko sa imo. Ginhatagan ko ikaw sang gahom sa paghimo sina. Pero patig-ahon ko ang tagipusuon sang hari para indi niya pagtugutan nga maghalin ang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Dayon silingon mo siya, ‘Amo ini ang ginasiling sang Ginoo: Ginakabig ko ang Israel nga akon kamagulangan nga anak nga lalaki, ");
INSERT INTO hil_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","gani ginsugo ko ikaw nga palakton mo siya para makasimba siya sa akon, pero wala ka magsugot. Gani patyon ko ang kamagulangan mo nga anak nga lalaki!’ ” ");
INSERT INTO hil_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Sang nagapanglakaton na si Moises kag ang iya pamilya, nagpahuway sila sa isa ka palahuwayan. Ginkadtuan sang Ginoo si Moises kag patyon kuntani. ");
INSERT INTO hil_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Pero nagkuha si Zipora sang matalom nga bato kag gintuli ang iya anak, kag ang panit nga iya nakuha gintandog niya sa kinatawo ni Moises. Dayon nagsiling si Zipora, “Ikaw isa ka duguon nga bana sa akon.” (Ginhambal ini ni Zipora nga may kaangtanan sa pagkatuli.) Gani wala pagpatya sang Ginoo si Moises. ");
INSERT INTO hil_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Karon, nagsiling ang Ginoo kay Aaron, “Lakat kag sugataa si Moises sa kamingawan.” Gani ginsugata niya si Moises sa Bukid sang Dios kag ginhalukan bilang pag-abiabi. ");
INSERT INTO hil_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ginsugiran dayon ni Moises si Aaron sang tanan nga ginsugo sang Ginoo nga ihambal niya, kag sang tanan nga milagro nga ipahimo sa iya. ");
INSERT INTO hil_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Gani naglakat sila nga duha, kag gintipon nila ang tanan nga manugdumala sang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ginsugiran sila ni Aaron sang tanan nga ginsiling sang Ginoo kay Moises. Kag ginhimo ni Moises ang mga milagro sa atubangan sang mga tawo, ");
INSERT INTO hil_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","kag nagpati sila. Sang nahibaluan nila nga nagakabalaka ang Ginoo sa ila kag nakita niya ang ila mga pag-antos, nagluhod sila kag nagsimba sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Sang ulihi nagkadto si Moises kag si Aaron sa hari sang Egypt kag nagsiling, “Amo ini ang ginasiling sang Ginoo, ang Dios sang Israel: ‘Palakta ang akon katawhan, para makasaulog sila sang piesta para sa akon sa kamingawan.’ ” ");
INSERT INTO hil_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Nagsiling ang hari, “Sin-o gid ang Ginoo nga magpati ako sa iya kag magtugot nga palakton ko ang mga Israelinhon? Wala ako nakakilala sa Ginoo kag indi ko pagpalakton ang mga Israelinhon.” ");
INSERT INTO hil_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Nagsabat si Moises kag si Aaron, “Nagpakita sa amon ang Dios sang mga Israelinhon. Gani kon mahimo tuguti kami sa paglakat sing tatlo ka adlaw sa kamingawan para makahalad kami sang mga halad sa Ginoo nga amon Dios, kay kon indi gani, pamatyon niya kami paagi sa balatian ukon inaway.” ");
INSERT INTO hil_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Pero nagsiling ang hari sang Egypt, “Ngaa pauntaton ninyo ang mga tawo sa ila trabaho? Balik na kamo sa inyo mga obra! ");
INSERT INTO hil_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Tan-awa kon daw ano kadamo sang tawo nga pauntaton ninyo sa pag-obra.” ");
INSERT INTO hil_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Sadto gid nga adlaw, nagmando ang hari sa mga Egyptohanon nga nagadumala sa mga Israelinhon sa trabaho kag sa mga porman nga Israelinhon. Siling niya, ");
INSERT INTO hil_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Indi na kamo maghatag sa mga trabahador sang mga dagami nga gamiton nila sa paghimo sang mga tisa, kundi sila na mismo ang magpanguha sini. ");
INSERT INTO hil_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Pero dapat amo man gihapon kadamo nga tisa ang ila himuon. Mga matamad sila, amo ina nga nagapangabay sila nga palakton ko sila para makahalad sila sa ila Dios. ");
INSERT INTO hil_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Paobraha pa gid sila sing tudo para magsako pa gid sila kag indi na magsagi pamati sa mga binutig.” ");
INSERT INTO hil_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Gani naglakat sila sa mga Israelinhon kag nagsiling, “Nagsugo ang hari nga indi na namon kamo paghatagan sang dagami. ");
INSERT INTO hil_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Kamo na ang magpangita sini bisan diin, pero amo man gihapon kadamo nga tisa ang inyo himuon.” ");
INSERT INTO hil_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Gani naglalapta ang mga Israelinhon sa bilog nga Egypt sa pagpanguha sang dagami. ");
INSERT INTO hil_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ginapadali sila sang mga manugdumala sa trabaho nga nagasiling, “Himua ninyo ang amo gihapon nga kadamuon sang tisa kada adlaw pareho sang inyo ginahimo sadto sang ginahatagan pa kamo sang dagami.” ");
INSERT INTO hil_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Dayon ginkastigo nila ang mga porman nga Israelinhon kag ginpamangkot, “Ngaa wala ninyo mahimo kahapon kag subong ang kadamuon sang tisa nga ginapahimo sa inyo, nga pareho kadamo sadto?” ");
INSERT INTO hil_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Gani nagkadto dayon ang mga porman nga Israelinhon sa hari kag nagreklamo, “Ngaa amo ini ang pagtratar mo sa amon nga imo mga suluguon? ");
INSERT INTO hil_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Wala kami ginahatagan sang dagami, pero ginapilit kami nga maghimo sang amo man gihapon kadamo nga tisa, kag ginakastigo pa kami. Sala gid ini sang imo mga tinawo!” ");
INSERT INTO hil_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Nagsiling ang hari, “Mga matamad gid kamo, amo ina nga nagapangabay kamo nga palakton ko kamo para makahalad kamo sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Balik na kamo sa inyo mga obra! Indi kamo paghatagan sang dagami, pero amo man gihapon kadamo nga tisa ang inyo himuon.” ");
INSERT INTO hil_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Tungod nga nag-insister ang hari nga himuon gid nila ang kadamuon sang tisa nga ginapahimo sa ila kada adlaw, nareyalisar sang mga porman nga Israelinhon nga mabudlayan gid sila. ");
INSERT INTO hil_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Paghalin nila sa hari, nakita nila si Moises kag si Aaron nga nagahulat sa ila. ");
INSERT INTO hil_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Nagsiling sila kay Moises kag kay Aaron, “Kabay pa nga silutan kamo sang Ginoo, kay tungod sa inyo nangakig sa amon ang hari kag ang iya mga opisyal. Ang inyo ginhimo mangin kabangdanan sa pagpatay nila sa amon.” ");
INSERT INTO hil_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Nagdangop liwat si Moises sa Ginoo kag nagpangamuyo, “O Ginoo, ngaa ginapaantos mo ang imo katawhan? Ngaa bala nga ginpadala mo pa ako sa ila? ");
INSERT INTO hil_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Halin sang ginsugid ko sa hari ang imo mensahi, ginpintasan pa gid niya ang imo katawhan, kag wala mo gid sila pagluwasa.” ");
INSERT INTO hil_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Nagsiling ang Ginoo kay Moises, “Karon makita mo kon ano ang pagahimuon ko sa hari sang Egypt. Tungod sa gahom nga akon ipakita, tugutan niya nga maghalin kamo sa iya nasyon. Mapilitan siya nga magpahalin sa inyo.” ");
INSERT INTO hil_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nagsiling pa gid ang Dios kay Moises, “Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nagpakita ako kay Abraham, kay Isaac, kag kay Jacob bilang Makagagahom nga Dios, pero wala ko ginpahayag sa ila ang akon ngalan nga Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Naghimo ako sang kasugtanan sa ila, nga ihatag ko sa ila ang duta sang Canaan nga sa diin nag-estar sila bilang mga pangayaw. ");
INSERT INTO hil_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Nabatian ko ang mga pag-ugayong sang mga Israelinhon nga ginaulipon sang mga Egyptohanon, kag ginadumdom ko ang akon kasugtanan sa ila. ");
INSERT INTO hil_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Gani silinga ang mga Israelinhon: ‘Ako amo ang Ginoo. Hilwayon ko kamo sa pagkaulipon sa Egypt. Paagi sa akon gahom, silutan ko sing puwerte gid ang mga Egyptohanon, kag luwason ko kamo. ");
INSERT INTO hil_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Kabigon ko kamo nga akon katawhan kag ako mangin inyo Dios. Dayon mahibaluan ninyo nga ako amo ang Ginoo nga inyo Dios nga naghilway sa inyo sa pagkaulipon sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Dal-on ko kamo sa duta nga akon ginsumpa nga ihatag kay Abraham, Isaac kag Jacob. Ihatag ko ini sa inyo, kag inyo ini panag-iyahan. Ako amo ang Ginoo.’ ” ");
INSERT INTO hil_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ginhambal ini ni Moises sa mga Israelinhon, pero wala sila nagpati sa iya tungod kay nadulaan na sila sing paglaom sa sobra nga pagpaantos sa ila bilang mga ulipon. ");
INSERT INTO hil_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Dayon nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Lakat, kag silinga ang Faraon nga hari sang Egypt nga pahalinon na niya ang mga Israelinhon sa iya nasyon.” ");
INSERT INTO hil_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Pero nagsiling si Moises sa Ginoo, “Kon ang mga Israelinhon indi gani magpamati sa akon, ang hari pa ayhan? Labi na nga indi ako maayo maghambal!” ");
INSERT INTO hil_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Pero nagsiling ang Ginoo kay Moises kag kay Aaron, “Silinga ninyo ang mga Israelinhon kag ang Faraon nga hari sang Egypt nga ginsugo ko kamo sa pagpaguwa sa mga Israelinhon sa Egypt.” ");
INSERT INTO hil_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Amo ini ang mga katigulangan sang mga panimalay nga naghalin sa mga tribo sang Israel: Ang mga anak nga lalaki ni Reuben, nga kamagulangan nga anak ni Israel, amo sila ni Hanoc, Palu, Hezron, kag Carmi. Sila kag ang ila mga kaliwat amo ang mga pamilya nga naghalin kay Reuben. ");
INSERT INTO hil_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ang mga anak nga lalaki ni Simeon amo sila ni Jemuel, Jamin, Ohad, Jakin, Zohar, kag Shaul. (Ining si Shaul anak ni Simeon sa Canaanhon nga babayi.) Sila kag ang ila mga kaliwat amo ang mga pamilya nga naghalin kay Simeon. ");
INSERT INTO hil_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ang mga anak nga lalaki ni Levi suno sa kasaysayan sang iya mga kaliwat amo sila ni Gershon, Kohat, kag Merari. Nagkabuhi si Levi sing 137 ka tuig. ");
INSERT INTO hil_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ang mga anak nga lalaki ni Gershon amo si Libni kag si Shimei. ");
INSERT INTO hil_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ang mga anak nga lalaki ni Kohat amo sila ni Amram, Izhar, Hebron, kag Uziel. Nagkabuhi si Kohat sing 133 ka tuig. ");
INSERT INTO hil_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ang mga anak nga lalaki ni Merari amo si Mali kag si Mushi. Amo ini ang mga pamilya nga naghalin kay Levi suno sa kasaysayan sang iya mga kaliwat. ");
INSERT INTO hil_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ginpangasawa ni Amram si Jokebed nga utod sang iya amay. Kag ang ila mga anak nga lalaki amo si Aaron kag si Moises. Nagkabuhi si Amram sing 137 ka tuig. ");
INSERT INTO hil_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ang mga anak nga lalaki ni Izhar amo sila ni Kora, Nefeg, kag Zicri. ");
INSERT INTO hil_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ang mga anak nga lalaki ni Uziel amo sila ni Mishael, Elzafan, kag Sitri. ");
INSERT INTO hil_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ginpangasawa ni Aaron si Elisheba, nga anak ni Aminadab kag utod ni Nashon. Ang ila mga anak nga lalaki amo sila ni Nadab, Abihu, Eleazar, kag Itamar. ");
INSERT INTO hil_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ang mga anak nga lalaki ni Kora amo sila ni Asir, Elkana, kag Abiasaf. Sila kag ang ila mga kaliwat amo ang mga pamilya nga naghalin kay Kora. ");
INSERT INTO hil_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Si Eleazar nga anak ni Aaron nagpangasawa sa isa sa mga anak ni Putiel. Ang ila anak nga lalaki amo si Finehas. Sila amo ang mga katigulangan sang mga pamilya nga naghalin kay Levi. ");
INSERT INTO hil_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ang Aaron kag Moises nga ginmitlang sa sini nga lista amo man ang Aaron kag Moises nga ginsugo sang Ginoo nga paguwaon ang bilog nga puwersa sang Israel sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Amo ini sila ang nagpakighambal sa Faraon nga hari sang Egypt nga paguwaon ang mga Israelinhon sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Sang nagpakig-estorya sadto ang Ginoo kay Moises sa Egypt, ");
INSERT INTO hil_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","nagsiling siya sa iya, “Ako amo ang Ginoo. Sugiri ang Faraon nga hari sang Egypt sang tanan nga ginsiling ko sa imo.” ");
INSERT INTO hil_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Pero nagsiling si Moises sa Ginoo, “Indi ako maayo maghambal, gani indi magpamati ang hari sa akon.” ");
INSERT INTO hil_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Nagsiling ang Ginoo kay Moises, “Pamati! Himuon ko ikaw nga daw isa ka dios para sa hari sang Egypt. Magapakighambal ka sa iya paagi kay Aaron nga imo utod. ");
INSERT INTO hil_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Sugiri si Aaron sang tanan nga ginasiling ko sa imo, kag ipasiling ini sa iya sa hari. Silingon niya ang hari nga paguwaon niya ang mga Israelinhon sa iya nasyon. ");
INSERT INTO hil_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Pero patig-ahon ko ang tagipusuon sang hari, kag bisan pa maghimo ako sang madamo nga milagro kag makatilingala nga mga butang sa Egypt, ");
INSERT INTO hil_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","indi siya magpamati sa inyo. Dayon silutan ko ang Egypt sing puwerte gid, kag paguwaon ko ang bilog nga puwersa sang Israel nga akon katawhan. ");
INSERT INTO hil_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Kon masilutan ko na ang mga Egyptohanon, kag mapaguwa ko na ang mga Israelinhon sa ila nasyon, mahibaluan nila nga ako amo ang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Gintuman ni Moises kag ni Aaron ang ginsugo sang Ginoo sa ila. ");
INSERT INTO hil_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Nagaedad si Moises sing 80 ka tuig kag si Aaron 83 sang nagpakighambal sila sa hari sang Egypt. ");
INSERT INTO hil_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Nagsiling ang Ginoo kay Moises kag kay Aaron, ");
INSERT INTO hil_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Kon magsiling ang hari sang Egypt nga maghimo kamo sang milagro, ikaw Moises magsiling kay Aaron, ‘Ihaboy ang imo baston sa atubangan sang hari, kag mahimo ini nga man-og.’ ” ");
INSERT INTO hil_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Gani nagkadto si Moises kag si Aaron sa hari kag ginhimo nila ang ginsiling sang Ginoo. Ginhaboy ni Aaron ang iya baston sa atubangan sang hari kag sang iya mga opisyal, kag nahimo ini nga man-og. ");
INSERT INTO hil_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ginpatawag dayon sang hari ang iya mga maalamon nga tawo kag mga madyikero, kag paagi sa ila nga mga madyik, nahimo man nila ang pareho sadto nga milagro. ");
INSERT INTO hil_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ang kada isa sa ila naghaboy sang ila baston kag nahimo man ini nga mga man-og. Pero ginlamon sang man-og ni Aaron ang ila mga man-og. ");
INSERT INTO hil_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Pero matig-a gihapon ang tagipusuon sang hari, kag wala siya nagpamati kay Moises kag kay Aaron, pareho sang ginsiling sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Nagsiling ang Ginoo kay Moises, “Matig-a gid ang tagipusuon sang hari; indi niya pagpalakton ang katawhan sang Israel. ");
INSERT INTO hil_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Gani kadtuan mo ang hari buwas sa aga sa iya pagkadto sa Suba sang Nilo. Didto ka magpakigkita sa iya sa higad sang suba kag dal-on mo gid ang imo baston nga nahimo nga man-og. ");
INSERT INTO hil_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Silingon mo siya, ‘Ang Ginoo, ang Dios sang mga Hebreo, nagsugo sa akon sa pagsiling sini sa imo: Palakta ang akon katawhan para makasimba sila sa akon sa kamingawan. Pero hasta subong wala ka gid nagtuman. ");
INSERT INTO hil_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ako, ang Ginoo, nagasiling nga paagi sa akon pagahimuon mahibaluan mo nga ako amo ang Ginoo. Paagi sa sini nga baston, hampakon ko ang tubig sang Nilo kag mahimo ang tubig nga dugo. ");
INSERT INTO hil_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Magakalamatay ang mga isda, kag magabaho ang suba, kag indi na makainom ang mga Egyptohanon sang tubig sini.’ ” ");
INSERT INTO hil_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Nagsiling pa gid ang Ginoo kay Moises, “Silinga si Aaron nga itudlo niya ang iya baston sa mga katubigan sang Egypt: sa mga suba, sapa, kanal, punong kag sa tanan nga ginatipunan sang tubig, kag mahimo ini tanan nga dugo. Amo ini ang matabo sa bisan diin sa Egypt. Pati ang tubig sa mga suludlannga kahoy ukon bato mangin dugo.” ");
INSERT INTO hil_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Gintuman ni Moises kag ni Aaron ang ginsugo sang Ginoo. Samtang nagatulok ang hari kag ang iya mga opisyal, ginbayaw ni Aaron ang iya baston kag ginhampak sa Suba sang Nilo, kag ang tanan nga tubig nahimo nga dugo. ");
INSERT INTO hil_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nagkalamatay ang mga isda kag nagbaho gid ang suba, gani indi na makainom ang mga Egyptohanon. Bisan diin sa Egypt may mga dugo. ");
INSERT INTO hil_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Pero ginhimo man ini nga milagro sang mga madyikero nga Egyptohanon paagi sa ila madyik. Gani matig-a gihapon ang tagipusuon sang hari, kag wala siya nagpamati kay Moises kag kay Aaron, pareho sang ginsiling sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Nagbalik ang hari sa iya palasyo, kag wala lang niya ato ginsapak. ");
INSERT INTO hil_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Nagkutkot ang mga Egyptohanon sa palibot sang Suba sang Nilo para makakuha sang ilimnon nga tubig, kay indi na nila mainom ang tubig sa suba. ");
INSERT INTO hil_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Pagkaligad sang pito ka adlaw halin sang paghampak sang Ginoo sang Suba sang Nilo paagi kay Aaron, ");
INSERT INTO hil_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Nagsiling ang Ginoo kay Moises, “Kadtui ang hari sang Egypt kag silinga siya, ‘Amo ini ang ginasiling sang Ginoo: Palakta ang akon katawhan para makasimba sila sa akon. ");
INSERT INTO hil_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kon indi mo gani sila pagpalakton, padagsaon ko ang mga paka sa bilog mo nga nasyon. ");
INSERT INTO hil_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mapuno sang mga paka ang Suba sang Nilo kag magasulod sila sa imo palasyo, sa imo kuwarto kag bisan sa imo hiligdaan. Magasulod man sila sa mga balay sang imo mga opisyal kag sang imo katawhan, kag pati sa mga dapog kag sa ginamasahan sang harina. ");
INSERT INTO hil_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Luksuhan ka sang mga paka pati ang imo katawhan kag ang tanan mo nga opisyal.’ ” ");
INSERT INTO hil_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Nagsiling pa gid ang Ginoo kay Moises, “Silinga si Aaron nga iuntay niya ang iya kamot nga may baston sa mga suba, sapa, kanal, kag sa mga punong, kag magaguluwa ang mga paka sa bilog nga Egypt.” ");
INSERT INTO hil_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Gani gin-untay ni Aaron ang iya kamot sa mga tubig sang Egypt, kag nagguluwa ang mga paka kag naglapta sa bilog nga Egypt. ");
INSERT INTO hil_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Pero ginhimo man ini nga milagro sang mga madyikero paagi sa ila mga madyik. Napaguwa man nila ang mga paka sa mga katubigan sang Egypt. ");
INSERT INTO hil_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ginpatawag sang hari si Moises kag si Aaron kag ginsilingan, “Magpangamuyo kamo sa Ginoo nga kuhaon niya ang mga paka sa akon kag sa akon katawhan, kag palakton ko ang inyo mga kasimanwa sa paghalad sa Ginoo.” ");
INSERT INTO hil_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Nagsiling si Moises sa hari, “Hambala lang ako kon san-o ako magpangamuyo para sa imo, sa imo mga opisyal, kag sa imo katawhan, para madula inang mga paka sa inyo kag sa inyo mga balay. Kag ang mabilin lang nga mga paka amo ang sa Suba sang Nilo.” ");
INSERT INTO hil_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Nagsabat ang hari, “Pangamuyui ako buwas.” Nagsiling si Moises, “Matuman ina suno sa ginsiling mo para mahibaluan mo nga wala na sing iban nga pareho sa Ginoo nga amon Dios. ");
INSERT INTO hil_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Madula ang tanan nga paka sa inyo; ang mabilin lang amo ang sa Suba sang Nilo.” ");
INSERT INTO hil_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Paghalin ni Moises kag ni Aaron sa hari, nagpangamuyo si Moises sa Ginoo nga kuhaon niya ang mga paka nga iya ginpadala sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Kag gintuman sang Ginoo ang ginpangabay ni Moises. Nagkalamatay ang mga paka sa mga balay, sa mga ugsaran, kag sa mga kaumahan. ");
INSERT INTO hil_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Gintipon ini sang mga Egyptohanon kag mataas gid ang ila mga tinumpok, kag nagbaho ang bilog nga duta sang Egypt. ");
INSERT INTO hil_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Pero pagkakita sang hari nga wala na ang mga paka, ginpatig-a niya liwat ang iya tagipusuon, kag wala siya nagpamati kay Moises kag kay Aaron, pareho sang ginsiling sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Nagsiling ang Ginoo kay Moises, “Silinga si Aaron nga ihampak niya ang baston sa duta, kag mahimo nga mga lamok ang mga yab-ok sa bilog nga duta sang Egypt.” ");
INSERT INTO hil_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Gintuman nila ini, kag sang ginhampak ni Aaron sang iya baston ang duta, nahimo nga mga lamok ang mga yab-ok sa bilog nga duta sang Egypt. Kag nagsalakay ang mga lamok sa mga tawo kag sa mga sapat. ");
INSERT INTO hil_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Gintinguhaan man ini sang mga madyikero nga sundon paagi sa ila mga madyik, pero wala nila masunod. Padayon nga nagasalakay ang mga lamok sa mga tawo kag sa mga sapat. ");
INSERT INTO hil_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Nagsiling ang mga madyikero sa hari, “Dios ang naghimo sini!” Pero matig-a gihapon ang tagipusuon sang hari, kag wala gid siya nagpamati, pareho sang ginsiling sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Nagsiling ang Ginoo kay Moises, “Aga ka pa magbangon buwas kag kadtui ang hari samtang nagapakadto siya sa suba. Silinga siya nga amo ini ang akon ginasiling: ‘Palakta ang akon katawhan para makasimba sila sa akon. ");
INSERT INTO hil_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kon indi mo gani sila pagpalakton, padal-an ko ikaw sang madamo gid nga mga sapat-sapat nga magahalit sa imo kag sa imo mga opisyal kag katawhan. Mapuno sang mga sapat-sapat ang inyo mga balay, kag ang duta matabunan sini. ");
INSERT INTO hil_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Pero indi mangin pareho sina sa duta sang Goshen nga sa diin nagaestar ang akon katawhan; indi makita didto ang madamo gid nga mga sapat-sapat, para mahibaluan ninyo nga ako, ang Ginoo, ara sa sina nga lugar. ");
INSERT INTO hil_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Lainon ko ang akon pagtratar sa akon katawhan sa imo katawhan. Ini nga milagro himuon ko buwas.’ ” ");
INSERT INTO hil_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ginhimo matuod ini sang Ginoo. Nagsulod ang madamo gid nga mga sapat-sapat sa palasyo sang hari kag sa mga balay sang iya mga opisyal, kag ang bilog nga duta sang Egypt nahalitan sini. ");
INSERT INTO hil_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Gani ginpatawag dayon sang hari si Moises kag si Aaron, kag ginsilingan, “Sige, maghalad kamo sa inyo Dios, pero diri lang sa Egypt.” ");
INSERT INTO hil_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Nagsabat si Moises, “Indi puwede nga diri kami maghalad sa Egypt, kay ang amon mga halad sa Ginoo nga amon Dios makangilil-ad para sa mga Egyptohanon. Kag kon maghalad kami sang mga halad nga makangilil-ad para sa ila, sigurado nga batuhon nila kami. ");
INSERT INTO hil_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kinahanglan malakat kami sing tatlo ka adlaw pakadto sa kamingawan sa paghalad didto sang mga halad sa Ginoo nga amon Dios, suno sa ginsugo niya sa amon.” ");
INSERT INTO hil_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Nagsiling ang hari, “Tugutan ko kamo nga maghalad sang mga halad sa Ginoo nga inyo Dios sa kamingawan, pero indi lang kamo magpalayo. Karon, pangamuyui na ninyo ako.” ");
INSERT INTO hil_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Nagsabat si Moises, “Sige, paghalin ko diri, mangamuyo ako sa Ginoo, kag sa buwas madula na sa inyo tanan ang mga sapat-sapat. Pero siguraduhon mo nga indi mo kami pagtuntuhon liwat nga indi kami pagpalakton sa paghalad sang mga halad sa Ginoo.” ");
INSERT INTO hil_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Naghalin dayon si Moises, kag nagpangamuyo sa Ginoo, ");
INSERT INTO hil_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","kag gintuman sang Ginoo ang ginpangabay ni Moises. Naghalin ang mga sapat-sapat sa tanan nga Egyptohanon. Wala gid sing may nabilin nga mga sapat-sapat. ");
INSERT INTO hil_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Pero ginpatig-a gihapon sang hari ang iya tagipusuon kag wala niya pagpalakta ang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Nagsiling ang Ginoo kay Moises, “Kadtui ang hari sang Egypt kag silinga siya, ‘Amo ini ang ginasiling sang Ginoo, ang Dios sang mga Hebreo: Palakta ang akon katawhan para makasimba sila sa akon. ");
INSERT INTO hil_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Kon indi mo pa gid gani sila pagpalakton, ");
INSERT INTO hil_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","padal-an ko sang makamamatay nga balatian ang imo mga kasapatan nga ara sa uma—mga kabayo, mga donkey, mga camel, mga baka, mga karnero, kag mga kanding. ");
INSERT INTO hil_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Pero lainon ko ang akon pagtratar sa kasapatan sang mga Israelinhon sa kasapatan sang mga Egyptohanon, para wala sing may mapatay sa mga kasapatan sang mga Israelinhon.’ ” ");
INSERT INTO hil_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ginpahibalo sang Ginoo nga himuon niya ini pagkasunod nga adlaw, ");
INSERT INTO hil_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","kag ginhimo niya matuod ini. Nagkalamatay ang tanan nga kasapatan sang mga Egyptohanon nga ara sa uma, pero wala gid sing may napatay sa mga kasapatan sang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Nagpadala ang hari sang mga tawo sa pag-usisa kon matuod nga wala sing may napatay sa mga kasapatan sang mga Israelinhon. Pero bisan nahibaluan niya nga matuod ini, matig-a gihapon ang iya tagipusuon kag wala niya pagpalakta ang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Dayon nagsiling ang Ginoo kay Moises kag kay Aaron, “Magkuha kamo sang tag-isa ka hakop nga abo sa hurnohan kag isabwag ini ni Moises sa hangin sa atubangan sang hari. ");
INSERT INTO hil_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Magalapta ini nga yab-ok sa bilog nga Egypt, kag tungod sini magatubo ang mga hubag sa lawas sang mga tawo kag sang mga sapat.” ");
INSERT INTO hil_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Gani nagkuha si Moises kag si Aaron sang abo sa hurnohan kag nagtindog sa atubangan sang hari. Ginsabwag ini ni Moises sa hangin, kag gintubuan sang mga hubag ang mga tawo kag mga sapat. ");
INSERT INTO hil_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Bisan ang mga madyikero indi makaatubang kay Moises, kay pati sila gintubuan man sang mga hubag pareho sa tanan nga Egyptohanon. ");
INSERT INTO hil_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Pero ginpatig-a pa gid sang Ginoo ang tagipusuon sang hari, kag wala gid siya nagpamati kay Moises kag kay Aaron, pareho sang ginsiling sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Dayon nagsiling ang Ginoo kay Moises, “Aga ka pa magbangon buwas kag kadtui ang hari, kag silinga, ‘Amo ini ang ginasiling sang Ginoo, ang Dios sang mga Hebreo: Palakta ang akon katawhan para makasimba sila sa akon. ");
INSERT INTO hil_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Kay kon indi gani, magapadala ako sang grabe gid nga kahalitan sa imo, sa imo mga opisyal, kag sa imo katawhan para mahibaluan mo nga wala na sang pareho sa akon sa bilog nga kalibutan. ");
INSERT INTO hil_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Bisan sadto pa, puwede ko ikaw laglagon kag ang imo katawhan paagi sa balatian, kag wala ka na kuntani subong. ");
INSERT INTO hil_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Pero gintugutan ko ikaw nga mabuhi para sa sini nga katuyuan: agod mapakita ko sa imo ang akon gahom kag agod mangin bantog ang akon ngalan sa bilog nga kalibutan. ");
INSERT INTO hil_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Pero nagapabugal ka gihapon sa akon katawhan, kag wala mo sila gintugutan nga maglakat. ");
INSERT INTO hil_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Gani buwas, sa amo man sini nga oras, paulanon ko sang yelo nga puwerte kabaskog, nga wala pa gid matabo sa Egypt halin sang pagtukod sini. ");
INSERT INTO hil_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Gani magsugo ka gilayon nga pasilungan ang tanan mo nga kasapatan kag ang tanan mo nga ulipon nga ara sa uma, kay ang tanan nga ara sa guwa, tawo man ukon sapat, magakalamatay kon matup-an sang ulan nga yelo.’ ” ");
INSERT INTO hil_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ang iban nga mga opisyal sang hari hinadlukan sa ginsiling sang Ginoo, gani dali-dali nila nga ginpapasilong ang ila mga ulipon kag mga kasapatan. ");
INSERT INTO hil_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Pero may iban nga wala nagsapak sa ginsiling sang Ginoo; ginpabay-an nila sa guwa ang ila mga ulipon kag mga kasapatan. ");
INSERT INTO hil_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Dayon nagsiling ang Ginoo kay Moises, “Ibayaw ang imo baston sa langit para magaulan sang yelo sa bilog nga Egypt—sa mga tawo, sa mga sapat kag sa tanan nga tanom.” ");
INSERT INTO hil_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Gani sang ginbayaw ni Moises ang iya baston sa langit, ginpadaguob sang Ginoo, ginpaulan sang yelo kag ginpakilat. Ang mga yelo nga ginpaulan sang Ginoo sa duta sang Egypt ");
INSERT INTO hil_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","amo ang pinakagrabe halin sang nangin isa ka nasyon ang Egypt. Samtang nagaulan sang mga yelo, sige ang pangilat. ");
INSERT INTO hil_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ang tanan nga tawo kag sapat nga ara sa guwa nahalitan, pati ang tanan nga tanom kag kahoy. ");
INSERT INTO hil_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ang wala lang maulanan sang yelo amo ang Goshen nga sa diin nagaestar ang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ginpatawag dayon sang hari si Moises kag si Aaron. Nagsiling siya sa ila, “Sini nga tion ginaako ko nga nakasala ako. Husto ang Ginoo; kag ako kag ang akon katawhan amo ang sala. ");
INSERT INTO hil_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pangabaya ang Ginoo nga untatan na niya ining puwerte nga daguob kag ulan nga yelo. Palakton ko na kamo; indi na kamo dapat magpabilin pa diri.” ");
INSERT INTO hil_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Nagsabat si Moises, “Kon makaguwa na ako sa siyudad, bayawon ko ang akon mga kamot sa pagpangamuyo sa Ginoo. Dayon magauntat ang daguob kag indi na mag-ulan sang yelo, para mahibaluan mo nga ang kalibutan iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Pero nahibaluan ko nga ikaw kag ang imo mga opisyal wala gihapon nagakahadlok sa Ginoong Dios.” ");
INSERT INTO hil_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Nagkalapierdi ang mga tanom nga flax kag barley, kay alanihon na sadto ang mga barley kag nagapamulak na ang mga flax. ");
INSERT INTO hil_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Pero wala nagkalapierdi ang mga trigo kag espelta kay indi pa ini alanihon.) ");
INSERT INTO hil_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Naghalin si Moises sa hari kag nagguwa sa siyudad. Ginbayaw niya ang iya mga kamot sa pagpangamuyo sa Ginoo; kag nag-untat ang daguob, ang pagtupa sang mga yelo, kag ang ulan. ");
INSERT INTO hil_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Pagkakita sang hari nga nag-untat na ang ulan, ang mga yelo, kag ang daguob, nagpakasala siya liwat. Ginpatig-a niya kag sang iya mga opisyal ang ila tagipusuon. ");
INSERT INTO hil_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Sa katig-a sang iya tagipusuon wala niya pagpalakta ang mga Israelinhon, pareho sang ginsiling sang Ginoo paagi kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Dayon nagsiling ang Ginoo kay Moises, “Kadtui ang hari sang Egypt, kay ginpatig-a ko ang iya tagipusuon kag ang tagipusuon sang iya mga opisyal, para padayon ko nga mapakita sa ila ining akon mga milagro, ");
INSERT INTO hil_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","kag para masugid ninyo sa inyo mga anak kag mga apo kon paano ko ginsilutan ang mga Egyptohanon kag kon paano ako naghimo sang mga milagro sa ila. Sa sini nga paagi mahibaluan ninyo nga ako amo ang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Gani nagkadto si Moises kag si Aaron sa hari kag nagsiling sa iya, “Amo ini ang ginasiling sang Ginoo, ang Dios sang mga Hebreo, ‘Hasta san-o ka pa bala nga indi magpaubos sa akon? Palakta ang akon katawhan para makasimba sila sa akon. ");
INSERT INTO hil_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Kon indi mo gani sila pagpalakton, padal-an ko buwas sang mga apan ang imo nasyon. ");
INSERT INTO hil_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Tungod sa ila kadamo, indi na makita ang duta. Pagakaunon nila ang nabilin nga mga tanom nga wala mapierdi sang ulan nga yelo, pati ang tanan ninyo nga kahoy. ");
INSERT INTO hil_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mapuno sang mga apan ang imo palasyo kag ang mga balay sang imo mga opisyal kag mga katawhan. Wala gid sing may nakita nga pareho sini sa duta sang Egypt halin sang pag-abot diri sang inyo mga katigulangan hasta subong.’ ” Dayon nagtalikod sila ni Moises kag naglakat. ");
INSERT INTO hil_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Nagsiling ang mga opisyal sang hari sa iya, “Hasta san-o mo pa bala pabay-an ini nga kalamidad nga maghalit sa aton? Palakta na ang mga Israelinhon, para makasimba sila sa Ginoo nga ila Dios. Wala mo bala nareyalisar nga guba na ang Egypt?” ");
INSERT INTO hil_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Gani ginpabalik liwat si Moises kag si Aaron sa hari. Nagsiling ang hari sa ila, “Sige, makalakat na kamo sa pagsimba sa Ginoo nga inyo Dios. Pero sugiri ninyo ako kon sin-o ang inyo updon sa paglakat.” ");
INSERT INTO hil_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Nagsabat si Moises, “Malakat kami tanan, bata kag tigulang. Dal-on namon ang amon mga kabataan kag mga kasapatan, kay tanan kami magasaulog sang piesta para sa Ginoo.” ");
INSERT INTO hil_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Nagsiling ang hari nga may pag-insulto, “Kabay pa nga updan kamo sang Ginoo kon palakton ko kamo kag ang inyo pamilya! Maathag nga malain ang inyo tuyo kay malagyo kamo. ");
INSERT INTO hil_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Indi ako magsugot! Ang mga lalaki lang ang maglakat para magsimba sa Ginoo, kon amo gid man ina ang inyo gusto.” Ginpahalin dayon si Moises kag si Aaron sa atubangan sang hari. ");
INSERT INTO hil_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Nagsiling dayon ang Ginoo kay Moises, “Itudlo ang imo baston sa duta sang Egypt para mag-abot ang mga apan, kag kaunon nila ang nabilin nga mga tanom nga wala mapierdi sang ulan nga yelo.” ");
INSERT INTO hil_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Gani gintudlo ni Moises ang iya baston sa duta sang Egypt, kag nagpadala ang Ginoo sang hangin nga halin sa east sa bilog nga adlaw kag gab-i. Pagkaaga nagdala ang hangin sang mga apan ");
INSERT INTO hil_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","nga puwerte kadamo, kag naghugpa ini sa bilog nga Egypt. Wala pa gid sing pareho sadto nga pagsalakay sang apan halin sang una kag bisan sang ulihi. ");
INSERT INTO hil_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Nagtabon sila sa bilog nga duta sang Egypt hasta nga daw nag-itom ang duta. Ginpangaon nila ang nabilin nga mga tanom nga wala mapierdi sang ulan nga yelo, pati ang tanan nga bunga sang kahoy. Wala gid sing may nabilin nga tanom sa bilog nga Egypt. ");
INSERT INTO hil_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Dali-dali nga ginpatawag sang hari si Moises kag si Aaron, kag ginsilingan, “Nakasala ako sa Ginoo nga inyo Dios kag sa inyo. ");
INSERT INTO hil_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Gani patawara ninyo ako liwat, kag magpangamuyo kamo sa Ginoo nga inyo Dios nga kuhaon niya sa akon ining mga apan nga makapatay sa mga tanom.” ");
INSERT INTO hil_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ginbayaan dayon ni Moises ang hari kag nagpangamuyo sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Nagsabat ang Ginoo paagi sa pagpadala sang mabaskog nga hangin nga halin sa west, kag ginpalid sini ang mga apan sa Mapula nga Dagat. Wala na gid sing apan nga nabilin sa bilog nga Egypt. ");
INSERT INTO hil_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Pero ginpatig-a gihapon sang Ginoo ang tagipusuon sang hari, kag wala niya pagpalakta ang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Dayon nagsiling ang Ginoo kay Moises, “Ibayaw ang imo kamot sa langit para tabunan sang puwerte nga kadulom ang duta sang Egypt.” ");
INSERT INTO hil_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Gani ginbayaw ni Moises ang iya kamot sa langit, kag nagdulom gid sa bilog nga duta sang Egypt sa sulod sang tatlo ka adlaw. ");
INSERT INTO hil_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Wala sing may nagguwa nga mga Egyptohanon sa ila balay sa sulod sang tatlo ka adlaw kay indi sila makakita. Pero ang mga Israelinhon ya may kasanag sa ila lugar nga ginaestaran. ");
INSERT INTO hil_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ginpatawag dayon sang hari si Moises kag ginsilingan, “Sige, magsimba na kamo sa Ginoo. Dal-a pati ang inyo mga pamilya, pero ibilin lang ang inyo mga kasapatan.” ");
INSERT INTO hil_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Pero nagsabat si Moises, “Kinahanglan nga dal-on namon ang amon mga kasapatan para makahalad kami sang mga halad, pati na sang mga halad nga ginasunog para sa Ginoo nga amon Dios. ");
INSERT INTO hil_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Dal-on gid namon ang amon mga kasapatan; wala gid sing may mabilin bisan isa sa ila, kay wala kami kahibalo kon ano nga sapat ang ipahalad sa amon sang Ginoo nga amon Dios. Mahibaluan lang namon ini kon didto na kami.” ");
INSERT INTO hil_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Pero ginpatig-a gihapon sang Ginoo ang tagipusuon sang hari, kag wala niya sila pagpalakta. ");
INSERT INTO hil_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Nagsiling ang hari kay Moises, “Halin ka sa akon atubangan! Indi ka na magpakita sa akon liwat, kay kon makit-an ko pa gani ikaw, ipapatay ko ikaw.” ");
INSERT INTO hil_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Nagsabat si Moises, “Kon amo ina ang gusto mo, indi na ako magpakita sa imo liwat.” ");
INSERT INTO hil_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Nakasiling sadto ang Ginoo kay Moises, “Padal-an ko sang isa pa ka kahalitan ang hari kag ang Egypt. Pagkatapos sina, palakton na niya kamo. Tabugon pa gani niya kamo tungod nga gusto na gid niya nga maghalin kamo. ");
INSERT INTO hil_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Silinga ang mga Israelinhon, lalaki kag babayi, nga magpangayo sila sa ila mga kasilingan nga mga Egyptohanon sang mga alahas nga pilak kag bulawan.” ");
INSERT INTO hil_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Ginbuot sang Ginoo nga magmaayo ang mga Egyptohanon sa mga Israelinhon. Kag gintahod gid si Moises sang mga opisyal sang hari kag sang mga pumuluyo sang Egypt.) ");
INSERT INTO hil_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Gani nagsiling si Moises sa hari, “Amo ini ang ginasiling sang Ginoo: ‘Magalabay ako sa Egypt sa mga tungang gab-i, ");
INSERT INTO hil_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","kag magakalamatay ang mga kamagulangan nga lalaki sa Egypt, halin sa kamagulangan sang hari, nga amo ang magabulos sa trono, pakadto sa kamagulangan sang pinakakubos nga ulipon nga babayi. Pati ang tanan nga kamagulangan sang mga kasapatan magakalamatay man. ");
INSERT INTO hil_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Mabatian ang puwerte nga paghinibi sa bilog nga Egypt nga wala pa gid matabo halin sang una, kag wala na sing may matabo pa nga pareho sini. ");
INSERT INTO hil_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Pero sa mga Israelinhon bisan taghol sang ido indi mabatian.’ Sa sini nga paagi mahibaluan ninyo nga lain ang pagtratar sang Ginoo sa mga Israelinhon sang sa mga Egyptohanon. ");
INSERT INTO hil_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Kag ang tanan mo nga opisyal magapalapit sa akon nga nagasaludo kag magasiling, ‘Lakat ka na upod sa mga tawo nga nagasunod sa imo!’ Pagkatapos sina, malakat ako.” Dayon naghalin si Moises sa atubangan sang hari nga puwerte ang iya kaakig. ");
INSERT INTO hil_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Nagsiling sadto ang Ginoo kay Moises, “Indi magpamati ang hari sa imo para madamo pa nga milagro ang himuon ko sa Egypt.” ");
INSERT INTO hil_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ini nga mga milagro ginhimo ni Moises kag ni Aaron sa atubangan sang hari, pero ginpatig-a sang Ginoo ang tagipusuon sang hari, kag wala pagtuguti sang hari nga maghalin ang mga Israelinhon sa iya nasyon. ");
INSERT INTO hil_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Dayon nagsiling ang Ginoo kay Moises kag kay Aaron didto sa Egypt, ");
INSERT INTO hil_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Sugod subong, ini nga bulan amo ang una nga bulan sang tuig para sa inyo. ");
INSERT INTO hil_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ipahibalo ninyo sa bilog nga komunidad sang Israel nga sa ikanapulo nga adlaw sang sini nga bulan, ang kada pamilya magpreparar sang isa ka karnero ukon kanding. ");
INSERT INTO hil_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kon ang isa ka pamilya gamay lang nga indi makaubos sang isa ka karnero, mag-ambitanay sila sang ila kasilingan. Partidahon nila ini suno sa ila kadamuon kag suno sa makaon sang kada tawo. ");
INSERT INTO hil_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kinahanglan ang karnero ukon kanding nga pilion ninyo lalaki nga isa pa lang ka tuig kag wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Atipanon ninyo ini hasta sa sirom sang ika-14 nga adlaw sang sini nga bulan nga amo ang tion nga ang bilog nga komunidad sang Israel mag-ihaw sang sini nga mga sapat. ");
INSERT INTO hil_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Dayon magkuha kamo sang dugo sini kag lamhitan ninyo ang ibabaw kag kilid sang hamba sang mga puwertahan sang mga balay nga kaunan ninyo sang mga karnero. ");
INSERT INTO hil_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Sa sina nga gab-i, ang kaunon ninyo amo ang litson nga karnero, mapait nga mga tanom, kag tinapay nga wala sing inugpahabok. ");
INSERT INTO hil_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Indi ninyo pagkaunon ang karne nga hilaw ukon linaga, kundi litsunon ninyo ini nga bilog upod ang ulo, tiil kag kasudlan. ");
INSERT INTO hil_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ubuson ninyo ini kaon, kag kon may mabilin gid man pagkaaga, sunuga ninyo. ");
INSERT INTO hil_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Sa tion nga kaunon ninyo ini, preparado na kamo sa paglakat. Isuksok ninyo ang inyo mga sandalyas kag uyati ang inyo baston, kag magdali-dali kaon. Amo ina ang Piesta sang Paglabay sang Anghel nga saulugon ninyo sa pagpadungog sa akon. ");
INSERT INTO hil_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Sa sina gid nga gab-i magalabay ako sa Egypt kag pamatyon ko ang tanan nga kamagulangan nga mga lalaki sang mga Egyptohanon, tawo man ukon sapat. Silutan ko ang tanan nga dios sang Egypt. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ang dugo nga ginlamhit ninyo sa hamba sang inyo mga puwertahan amo ang mangin tanda nga mahibaluan ko kon diin ang mga balay nga inyo ginaestaran. Kon makita ko ang dugo, labayan ko lang ang inyo balay, kag indi kamo mahalitan kon silutan ko na ang Egypt. ");
INSERT INTO hil_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Dapat dumdumon ninyo ina nga adlaw hasta san-o. Sauluga ninyo ina bilang piesta sa pagpadungog sa akon. Ini nga pagsulundan dapat tumanon ninyo hasta sa palaabuton nga mga henerasyon. ");
INSERT INTO hil_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Sa sulod sang pito ka adlaw magkaon kamo sang tinapay nga wala sing inugpahabok. Sa nahauna mismo nga adlaw, kuhaa ninyo ang tanan nga inugpahabok sa inyo mga balay, kay ang bisan sin-o nga magkaon sang tinapay nga may inugpahabok halin sa una nga adlaw hasta sa ikapito nga adlaw, indi pagkabigon nga sakop sang Israel. ");
INSERT INTO hil_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Sa nahauna nga adlaw kag sa ikapito nga adlaw, magtipon kamo sa pagsimba sa akon. Indi kamo mag-obra sa sina nga mga adlaw, luwas lang sa pagpreparar sang pagkaon para inyo kaunon. Amo lang ina ang inyo himuon. ");
INSERT INTO hil_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Sauluga ninyo ang Piesta sang Tinapay nga Wala sing Inugpahabok, kay magapadumdom ini sa inyo sang adlaw nga ginpaguwa ko ang inyo bilog nga puwersa sa Egypt. Sauluga ninyo ini hasta san-o bilang pagsulundan nga dapat ninyo tumanon hasta sa palaabuton nga mga henerasyon. ");
INSERT INTO hil_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Magsugod kamo sa pagsaulog sini halin sa sirom sang ika-14 nga adlaw sang nahauna nga bulan hasta sa sirom sang ika-21 nga adlaw, kag kinahanglan nga magkaon kamo sang tinapay nga wala sing inugpahabok. ");
INSERT INTO hil_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Sa sulod sang pito ka adlaw, dapat wala sing inugpahabok nga makita sa inyo mga balay. Ang bisan sin-o nga magkaon sang tinapay nga may inugpahabok indi pagkabigon nga sakop sang komunidad sang Israel, tumandok man siya ukon pangayaw. ");
INSERT INTO hil_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Huo, indi gid kamo magkaon sang bisan ano nga may inugpahabok sa tion sinang piesta, bisan diin man kamo nagaestar.” ");
INSERT INTO hil_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Dayon ginpatawag ni Moises ang tanan nga manugdumala sang Israel kag ginsilingan, “Silinga ang tanan ninyo nga pamilya, nga magkuha sila sang karnero ukon kanding kag ihawon nila sa pagsaulog sang Piesta sang Paglabay sang Anghel. ");
INSERT INTO hil_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Patuluon ninyo ang dugo sini sa yahong. Dayon magkuha kamo sang sanga sang isopo kag itum-oy ini sa dugo kag ipalhit sa ibabaw kag sa kilid sang hamba sang inyomga puwertahan. Kag wala sing may magguwa sa inyo balay hasta mag-aga. ");
INSERT INTO hil_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Kay magalabay ang Ginoo sa Egypt sa pagpamatay sa mga kamagulangan nga mga lalaki sang mga Egyptohanon. Pero kon makita sang Ginoo ang dugo sa ibabaw kag kilid sang hamba sang inyomga puwertahan, malabay lang siya sa inyo mga balay kag indi niya pagtugutan ang Manuglaglag sa pagsulod sa inyo mga balay sa pagpamatay sa inyo mga kamagulangan nga lalaki. ");
INSERT INTO hil_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ini nga pagsulundan dapat tumanon ninyo kag sang inyo mga kaliwat hasta san-o. ");
INSERT INTO hil_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Padayuna ninyo ang paghimo sini nga seremonya kon magsulod na kamo sa duta nga ginpromisa sang Ginoo nga ihatag sa inyo. ");
INSERT INTO hil_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kag kon magpamangkot gani ang inyo mga kabataan kon ano ang buot silingon sini nga seremonya, ");
INSERT INTO hil_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","amo ini ang inyo isabat: ‘Piesta ini sang Paglabay sang Anghel nga ginasaulog sa pagpadungog sa Ginoo, kay naglabay lang siya sa mga balay sang mga Israelinhon sa Egypt sang pagpamatay niya sang mga Egyptohanon.’ ” Pagkatapos hambal ni Moises, nagluhod ang mga Israelinhon kag nagsimba sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Kag ginhimo nila ang ginsugo sang Ginoo kay Moises kag kay Aaron. ");
INSERT INTO hil_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Sang mga tungang gab-i, ginpamatay sang Ginoo ang tanan nga kamagulangan nga lalaki sa Egypt, halin sa kamagulangan sang hari, nga amo ang magabulos sa trono, hasta sa kamagulangan sang mga priso nga ara sa prisohan. Kag ginpamatay man niya ang tanan nga kamagulangan sang mga kasapatan. ");
INSERT INTO hil_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Sadto nga gab-i nakabugtaw ang hari kag ang tanan niya nga opisyal kag ang tanan nga Egyptohanon. Kag nabatian ang puwerte nga paghinibi sa Egypt, kay wala gid sing balay nga wala sing patay. ");
INSERT INTO hil_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Sadto gid mismo nga gab-i, ginpatawag sang hari si Moises kag si Aaron kag ginsilingan, “Sige, lakat na kamo! Bayai na ninyo ang akon nasyon. Lakat na kamo kag magsimba sa Ginoo, suno sa inyo ginpangabay. ");
INSERT INTO hil_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Dal-a ninyo ang inyo mga kasapatan, suno man sa inyo ginpangabay, kag maglakat na kamo. Pero pangabaya man ninyo ang inyo Dios nga kaluoyan ako!” ");
INSERT INTO hil_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ginpadali sang mga Egyptohanon ang mga Israelinhon sa paghalin sa ila nasyon, kay siling nila, “Kon indi kamo maghalin, magakalamatay kami tanan!” ");
INSERT INTO hil_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Gani gindala sang mga Israelinhon ang ila mga linamas nga harina nga wala sing inugpahabok nga nasulod sa suludlan. Ginputos nila ini sa ila mga bayo kag ginpas-an. ");
INSERT INTO hil_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ginhimo sang mga Israelinhon ang ginsiling sa ila ni Moises nga mangayo sa mga Egyptohanon sang mga alahas nga pilak kag bulawan, kag mga bayo. ");
INSERT INTO hil_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ginbuot sang Ginoo nga magmaayo ang mga Egyptohanon sa mga Israelinhon, gani ginhatag sang mga Egyptohanon ang ila ginpangayo. Sa sini nga paagi, ginkuhaan nila sang mga pagkabutang ang mga Egyptohanon. ");
INSERT INTO hil_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Nagpanglakaton ang mga Israelinhon halin sa Rameses pakadto sa Sucot. Mga 600,000 tanan ka lalaki, wala labot sang mga babayi kag mga kabataan. ");
INSERT INTO hil_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Madamo man nga mga indi Israelinhon ang nag-upod sa ila, kag madamo man nga mga kasapatan ang ila gindala. ");
INSERT INTO hil_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Kon magpundo sila para magkaon, nagaluto sila sang tinapay nga wala sing inugpahabok halin sa linamas nga harina nga ila gindala halin sa Egypt. Wala ini ginbutangan sang inugpahabok tungod kay ginpadali sila sang mga Egyptohanon sa paghalin kag wala na sila sing tion sa pagpreparar sang ila pagkaon. ");
INSERT INTO hil_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ang kalawigon sang pag-estar sang mga Israelinhon sa Egypt mga 430 ka tuig. ");
INSERT INTO hil_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Sa katapusan mismo nga adlaw sang 430 ka tuig, naghalin ang bilog nga puwersa sang Ginoo sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Sang sina nga gab-i nga naghalin ang mga Israelinhon sa Egypt, daw sa nagpulaw ang Ginoo sa pagbantay sa ila. Gani sa amo man nga gab-i kada tuig, magapulaw ang mga Israelinhon sa pagpadungog sa Ginoo. Dapat himuon nila ini hasta sa palaabuton nga mga henerasyon. ");
INSERT INTO hil_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Nagsiling ang Ginoo kay Moises kag kay Aaron, “Amo ini ang mga pagsulundan parte sa Piesta sang Paglabay sang Anghel: “Ang mga pangayaw indi dapat magkaon sang kalan-on nga ginpreparar sa sini nga piesta. ");
INSERT INTO hil_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Makakaon ang tanan nga ulipon nga ginbakal kon natuli sila, ");
INSERT INTO hil_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","pero indi makakaon ang mga sinuhulan nga trabahador kag ang mga pangayaw. ");
INSERT INTO hil_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Dapat kaunon ini sa sulod sang balay sa diin ginpreparar ini; indi gid pagdal-on ang karne sa guwa sang balay, kag indi gid pagbalion ang tul-an sini. ");
INSERT INTO hil_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Dapat saulugon ini sang bilog nga komunidad sang Israel. ");
INSERT INTO hil_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Kon ang pangayaw nga nagaestar upod sa inyo gusto magsaulog sang Piesta sang Paglabay sang Anghel sa pagpadungog sa Ginoo, dapat tulion anay ang tanan nga lalaki sa iya panimalay. Dayon makaupod siya sa pagsaulog bilang isa ka tumandok nga Israelinhon. Pero indi gid puwede makaupod ang tawo nga wala matuli. ");
INSERT INTO hil_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ini nga pagsulundan para sa mga tumandok nga Israelinhon kag sa mga pangayaw nga nagaestar upod sa inyo.” ");
INSERT INTO hil_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ginhimo sang tanan nga Israelinhon ang ginsugo sang Ginoo kay Moises kag kay Aaron. ");
INSERT INTO hil_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Kag sadto gid nga adlaw ginpaguwa sang Ginoo ang bilog nga puwersa sang Israel sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Idedikar sa akon ang tanan nga kamagulangan nga lalaki sang mga Israelinhon kag ang tanan nga kamagulangan nga sapat. Akon sila.” ");
INSERT INTO hil_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Dayon nagsiling si Moises sa mga tawo, “Dumduma ninyo ini nga adlaw, nga amo ang adlaw nga ginpaguwa kamo sa Egypt halin sa pagkaulipon. Kay ginpaguwa kamo sang Ginoo paagi sa iya gahom. Indi kamo magkaon sang tinapay nga may inugpahabok. ");
INSERT INTO hil_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Dumduma ninyo ini nga adlaw sang bulan sang Aviv—ang adlaw nga ginpaguwa kamo sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Dapat saulugon ninyo ini kon dal-on na kamo sang Ginoo sa duta sang mga Canaanhon, Hithanon, Amornon, Hivhanon, kag mga Jebusnon. Amo ini ang duta nga ginsumpa sang Ginoo sa inyo mga katigulangan nga ihatag sa inyo. Ini nga duta maayo kag mapatubason. ");
INSERT INTO hil_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sa tion sang inyo pagsaulog, magkaon kamo sang tinapay nga wala sing inugpahabok sa sulod sang pito ka adlaw, kag sa ikapito nga adlaw maghiwat kamo sang piesta para sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Indi gid kamo magkaon sang tinapay nga may inugpahabok sa sulod sinang pito ka adlaw, kag kinahanglan nga wala gid sing inugpahabok nga makita sa inyo ukon sa bisan diin sa inyo lugar. ");
INSERT INTO hil_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Sa tion sang inyo pagsaulog, ipaintiendi ninyo sa inyo mga anak nga ginahimo ninyo ini sa pagdumdom sang ginhimo sang Ginoo sang pagguwa ninyo sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ini nga piesta daw pareho sa isa ka marka sa inyo mga kamot ukon sa inyo mga agtang nga magapadumdom sa inyo nga dapat ninyo isugid ang mga sugo sang Ginoo, kay ginpaguwa niya kamo sa Egypt paagi sa iya gahom. ");
INSERT INTO hil_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Gani sauluga ninyo ini nga piesta sa natalana nga tion kada tuig. ");
INSERT INTO hil_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Kon dal-on na gani kamo sang Ginoo sa duta sang mga Canaanhon nga iya ginsumpa nga ihatag sa inyo mga katigulangan kag sa inyo, ");
INSERT INTO hil_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","idedikar ninyo sa Ginoo ang kamagulangan nga mga lalaki, tawo man ukon sapat, kay sila iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Puwede magawad sa Ginoo ang kamagulangan sang inyo mga donkey paagi sa pagbaylo sini sang karnero. Pero kon indi ninyo ini paggawaron, kinahanglan nga patyon ang donkey paagi sa pagbali sang iya liog. Dapat man ninyo magawad ang inyo kamagulangan nga mga anak nga lalaki. ");
INSERT INTO hil_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Kon sa ulihi magpamangkot ang inyo mga anak kon ngaa ginahimo ninyo ini, silinga sila nga, ‘Paagi sa gahom sang Ginoo ginpaguwa niya kami sa Egypt nga sa diin kami gin-ulipon. ");
INSERT INTO hil_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Sang wala pa kami pagtuguti sang hari nga maglakat, ginpamatay sang Ginoo ang tanan nga kamagulangan nga lalaki sa Egypt, tawo man ukon sapat. Amo ina kon ngaa ginahalad namon sa Ginoo ang tanan nga kamagulangan nga lalaki sang amon mga kasapatan kag ginatubos namon ang amon kamagulangan nga mga anak nga lalaki.’ ");
INSERT INTO hil_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ini nga seremonya daw pareho sa isa ka marka sa inyo mga kamot ukon sa inyo mga agtang nga magapadumdom sa inyo nga ginpaguwa kamo sang Ginoo sa Egypt paagi sa iya gahom.” ");
INSERT INTO hil_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Sang ginpalakat sang hari ang mga Israelinhon, wala sila pagtuytuyi sang Dios sa dalan nga pakadto sa duta sang mga Filistinhon bisan amo ato ang laktod nga dalan. Kay nagsiling ang Dios, “Kon may inaway nga atubangon ang mga Israelinhon, basi magbaylo ang ila hunahuna kag magbalik sila sa Egypt.” ");
INSERT INTO hil_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Gani ginpalibot sila sang Dios sa kamingawan pakadto sa Mapula nga Dagat. Armado ang mga Israelinhon para sa inaway paghalin nila sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Gindala ni Moises ang mga tul-an ni Jose, suno sa ginpasumpa anay ni Jose nga himuon sang mga Israelinhon. Nagsiling sadto si Jose, “Sigurado nga hilwayon kamo sang Dios. Kon matabo na nga maghalin na kamo sa sini nga lugar, dal-on ninyo ang akon mga tul-an.” ");
INSERT INTO hil_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Paghalin nila sa Sucot, nagkampo sila sa Etam, sa border sang kamingawan. ");
INSERT INTO hil_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Kon adlaw, ginatuytuyan sila sang Ginoo paagi sa panganod nga daw haligi, kag kon gab-i ginatuytuyan sila paagi sa kalayo nga daw haligi nga nagahatag sa ila sang kasanag, para makapanglakaton sila, adlaw man ukon gab-i. ");
INSERT INTO hil_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Wala gid nagahalin sa unahan sang mga tawo kon adlaw ang panganod nga daw haligi, kag kon gab-i, ang kalayo nga daw haligi. ");
INSERT INTO hil_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Dayon nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Silinga ang mga Israelinhon nga magbalik sila malapit sa Pi Hahirot, sa tunga-tunga sang Migdol kag sang Mapula nga Dagat, kag magkampo sila didto sa higad sang baybay, sa atubangan sang Baal Zefon. ");
INSERT INTO hil_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Magahunahuna ang hari nga nagatalang-talang kamo kag indi na makaguwa sa kamingawan. ");
INSERT INTO hil_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Kag patig-ahon ko ang iya tagipusuon kag lagson niya kamo. Pero laglagon ko siya kag ang iya mga soldado. Sa sini nga paagi mapadunggan ako, kag mahibaluan sang mga Egyptohanon nga ako amo ang Ginoo.” Gani ginhimo ini sang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Sang mabalitaan sang hari sang Egypt nga nagpalagyo ang mga Israelinhon, nagbaylo ang iya hunahuna kag sang iya mga opisyal parte sa paghalin sang mga Israelinhon. Nagsiling sila, “Ano bala ang aton ginhimo? Ngaa ginpalakat ta ang mga Israelinhon? Karon wala na kita sang mga ulipon.” ");
INSERT INTO hil_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Gani ginpapreparar sang hari ang iya karwahe kag ang iya mga soldado. ");
INSERT INTO hil_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Gindala niya ang 600 sa pinakamaayo nga karwahe sang Egypt kag ang iban pa nga mga karwahe. May opisyal nga nagadumala sa kada karwahe. ");
INSERT INTO hil_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ginpatig-a sang Ginoo ang tagipusuon sang Faraon nga hari sang Egypt, gani ginlagas niya ang mga Israelinhon nga nagalakat nga may kaisog. ");
INSERT INTO hil_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ang mga Egyptohanon nga nag-upod sa paglagas amo ang mga soldado sang hari kaupod sang iya mga manugkabayo nga nagasakay sa mga kabayo kag mga karwahe. Naabtan nila ang mga Israelinhon sa ila ginakampuhan sa higad sang Mapula nga Dagat malapit sa Pi Hahirot, sa atubangan sang Baal Zefon. ");
INSERT INTO hil_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Sang nagapadulong ang hari kag ang iya mga soldado, nakita sila sang mga Israelinhon. Gani hinadlukan gid ang mga Israelinhon kag nagpangayo sila sang bulig sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Nagsiling sila kay Moises, “Ngaa diri mo pa kami gindala sa kamingawan para mapatay? Wala bala sing lulubngan didto sa Egypt? Ngaa ginpaguwa mo pa kami sa Egypt? ");
INSERT INTO hil_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Indi bala nagsiling kami sa imo didto sa Egypt nga pabay-an mo na lang kami nga magpaulipon sa mga Egyptohanon? Mas maayo pa para sa amon nga magpaulipon sa mga Egyptohanon sang sa mapatay diri sa kamingawan!” ");
INSERT INTO hil_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Nagsabat si Moises sa mga tawo, “Indi kamo magkahadlok. Magpakabakod kamo kag makita ninyo ang pagluwas sang Ginoo sa inyo subong nga adlaw. Inang mga Egyptohanon nga nakita ninyo subong indi na gid ninyo makita liwat. ");
INSERT INTO hil_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Ang Ginoo magapakig-away para sa inyo. Indi na kinahanglan nga magpakig-away pa kamo.” ");
INSERT INTO hil_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Dayon nagsiling ang Ginoo kay Moises, “Ngaa sagi ka pa panawag sa akon? Silinga ang mga Israelinhon nga magpadayon sila sa paglakat. ");
INSERT INTO hil_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Dayon itudlo ang imo baston sa dagat para matunga ang tubig kag makatabok ang mga Israelinhon sa mamala nga duta. ");
INSERT INTO hil_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Patig-ahon ko ang tagipusuon sang mga Egyptohanon para lagson nila kamo. Pero laglagon ko ang hari kag ang iya mga soldado, mga manugkabayo, kag mga karwahe. Sa sini nga paagi mapadunggan ako. ");
INSERT INTO hil_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Kag kon malaglag ko na sila, mahibaluan sang mga Egyptohanon nga ako amo ang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Dayon ang anghel sang Dios nga nagauna sa katawhan sang Israel nagsaylo sa ulihi nila, kag amo man ang panganod nga daw haligi. ");
INSERT INTO hil_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Nagpundo ini sa tunga sang mga Israelinhon kag sang mga Egyptohanon. Sa bilog nga gab-i, ang panganod naghatag sang kasanag sa mga Israelinhon kag naghatag sang kadulom sa mga Egyptohanon. Gani nagligad ang gab-i nga wala nakapalapit ang mga Egyptohanon sa mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Dayon gin-untay ni Moises ang iya kamot sa dagat, kag napihak ang dagat paagi sa mabaskog nga hangin nga ginpadala sang Ginoo halin sa east. Bilog nga gab-i ang huyop sang hangin hasta nga nagmala ang duta sa tunga sang dagat. ");
INSERT INTO hil_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Dayon nagtabok ang mga Israelinhon nga nagalakat sa mamala nga duta, nga ang tubig daw sa pader sa pihak kag pihak. ");
INSERT INTO hil_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ginlagas sila sang mga Egyptohanon. Ang tanan nga kabayo sang hari, mga karwahe, kag mga manugkabayo naglagas sa ila hasta sa tunga sang dagat. ");
INSERT INTO hil_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Pero sang kaagahon pa, gintulok sang Ginoo ang mga soldado sang Egypt halin sa panganod nga daw haligi kag sa kalayo nga daw haligi, kag ginpasala-sala niya sila. ");
INSERT INTO hil_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ginpaguot niya ang mga rueda sang ila mga karwahe para mabudlayan sila sa pagpadalagan. Nagsiling ang mga Egyptohanon, “Malagyo na lang kita sa mga Israelinhon, kay ang Ginoo amo ang nagapakig-away sa aton para sa ila.” ");
INSERT INTO hil_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Sang nakatabok na ang mga Israelinhon, nagsiling ang Ginoo kay Moises, “Iuntay ang imo kamot sa dagat para magbalik ang tubig kag matabunan ang mga Egyptohanon kag ang ila mga karwahe kag mga manugkabayo.” ");
INSERT INTO hil_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Gani gin-untay ni Moises ang iya kamot sa dagat, kag sang nagabutlak na ang adlaw, nagbalik ang tubig sa iya lugar. Nagtinguha ang mga Egyptohanon sa pagpalagyo pero ginpaanod sila sang Ginoo sa dagat. ");
INSERT INTO hil_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Gintabunan sang tubig ang tanan nga soldado sang hari sang Egypt nga nagalagas sa mga Israelinhon pati na ang ila mga manugkabayo kag mga karwahe. Wala gid sing isa sa ila nga nakaluwas. ");
INSERT INTO hil_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Pero ang mga Israelinhon ya nag-agi sa mamala nga duta sa tunga sang dagat, nga ang tubig daw sa pader sa pihak kag pihak. ");
INSERT INTO hil_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Sa sina nga adlaw, ginluwas sang Ginoo ang mga Israelinhon sa kamot sang mga Egyptohanon. Kag nakita sang mga Israelinhon ang mga bangkay sang mga Egyptohanon nga nagahamyang sa baybayon. ");
INSERT INTO hil_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Nakita sang mga Israelinhon ang puwerte nga gahom sang Ginoo nga iya gin-gamit kontra sa mga Egyptohanon, kag tungod sini nagtahod kag nagsalig sila sa Ginoo kag sa iya alagad nga si Moises. ");
INSERT INTO hil_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Dayon nagkanta si Moises kag ang mga Israelinhon sang sini nga kanta sa Ginoo: “Kantahan ko ang Ginoo tungod kay nagmadinalag-on gid siya. Gintagbong niya sa dagat ang mga kabayo kag ang mga nagasakay sini. ");
INSERT INTO hil_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ang Ginoo amo ang nagahatag sa akon sang kusog, kag siya ang akon ginakanta. Siya ang nagluwas sa akon. Siya ang akon Dios, kag pagadayawon ko siya. Siya ang Dios sang akon amay, kag padunggan ko siya. ");
INSERT INTO hil_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ginoo ang iya ngalan, kag isa siya ka mangangaway. ");
INSERT INTO hil_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Gintagbong niya sa dagat ang mga karwahe kag mga soldado sang hari sang Egypt. Nagkalalumos sa Mapula nga Dagat ang mga pinakamaayo nga mga opisyal sang hari. ");
INSERT INTO hil_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Nagkalalumos sila sa madalom nga tubig; nagkalalugdang sila sa kadadalman pareho sa bato. ");
INSERT INTO hil_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Puwerte gid ang imo gahom, O Ginoo; paagi sini gindugmok mo ang mga kaaway. ");
INSERT INTO hil_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Sa imo pagkagamhanan, ginlaglag mo ang mga nagakontra sa imo. Ginpaagom mo sa ila ang imo kaakig nga amo ang naglaglag sa ila nga daw sa ginsunog sila nga dagami. ");
INSERT INTO hil_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Sa isa mo lang ka paghuyop naghawa ang tubig. Ang nagadaganas nga tubig naghawa kag nagtindog nga daw sa pader; daw sa nagtig-a ang madalom nga dagat. ");
INSERT INTO hil_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Nagsiling ang kaaway nga nagapabugal, ‘Lagson ko sila kag dakpon; partidahon ko ang ila mga manggad kag paayawan ko ang akon kaugalingon sini. Gabuton ko ang akon espada kag laglagon ko sila.’ ");
INSERT INTO hil_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Pero sa isa mo lang ka paghuyop nalumos sila sa dagat. Naglugdang sila sa kadadalman pareho sa tingga. ");
INSERT INTO hil_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","O Ginoo, sin-o bala nga dios ang makapareho sa imo? Wala na sing pareho sa imo sa pagkabalaan kag pagkagamhanan. Ikaw lang ang Dios nga nagahimo sang makatilingala nga mga butang! ");
INSERT INTO hil_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Paagi sa imo gahom ginlamon sang duta ang amon mga kaaway. ");
INSERT INTO hil_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Sa imo mapinadayunon nga gugma tuytuyan mo ang mga tawo nga imo ginluwas. Sa imo nga kusog, tuytuyan mo sila sa imo balaan nga puluy-an. ");
INSERT INTO hil_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Mabatian ini sang mga nasyon kag magakurog sila sa kahadlok. Makulbaan gid ang mga Filistinhon. ");
INSERT INTO hil_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ang mga pangulo sang Edom kag Moab magakulurog sa kahadlok, kag ang mga pangulo sang Canaan magakalalipong sa kahadlok. ");
INSERT INTO hil_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","“Huo, makulbaan gid sila. Paagi sa imo puwerte nga gahom magapahimuyong sila pareho sa bato, hasta makaagi ang imo katawhan nga imo ginluwas, O Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Pagadal-on mo ang imo katawhan sa imo duta, kag ipahamtang mo sila sa bukid nga imo ginapanag-iyahan— ang lugar nga ginhimo mo nga imo puluy-an, O Ginoo, ang templo nga ikaw mismo ang naghimo. ");
INSERT INTO hil_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Magahari ka, O Ginoo, hasta san-o.” ");
INSERT INTO hil_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Gintabunan sang Ginoo sang tubig ang mga kabayo sang hari sang Egypt kag ang iya mga karwahe kag mga manugkabayo pagkatapos tabok sang mga Israelinhon sa mamala nga duta sa tunga sang dagat. ");
INSERT INTO hil_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Dayon si Miriam nga propeta kag utod ni Aaron nagkuha sang tamborin kag ginpangunahan niya ang mga babayi sa pagtukar sang tamborin kag pagsinaot. ");
INSERT INTO hil_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Nagkanta si Miriam sang sini nga kanta sa ila: “Kanta kamo sa Ginoo tungod kay nagmadinalag-on gid siya. Gintagbong niya sa dagat ang mga kabayo kag ang mga nagasakay sini.” ");
INSERT INTO hil_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Halin sa Mapula nga Dagat, gindala ni Moises ang mga Israelinhon sa kamingawan sang Shur. Sa sulod sang tatlo ka adlaw nagpanglakaton sila sa kamingawan kag wala sila sing may nakita nga tubig. ");
INSERT INTO hil_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Sang nakaabot sila sa Mara, nakakita sila sang tubig, pero indi sila makainom tungod kay mapait ang tubig. (Amo ina nga gin-ngalanan ini nga lugar nga Mara.) ");
INSERT INTO hil_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Tungod sini, nagreklamo ang mga Israelinhon kay Moises, “Ano na lang ang imnon ta?” ");
INSERT INTO hil_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Gani nagpangayo sang bulig si Moises sa Ginoo, kag ginpakita sang Ginoo sa iya ang isa ka utod nga kahoy. Ginhaboy ini ni Moises sa tubig kag nagnamit ang tubig. Didto naghatag ang Ginoo sang sini nga pagsulundan kag sugo sa pagtilaw sang ila katutom sa iya: ");
INSERT INTO hil_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“Kon magsunod kamo sing maayo sa akon, ang Ginoo nga inyo Dios, kag maghimo sing maayo sa akon panulok kag magtuman sang akon mga sugo kag mga pagsulundan, indi ko kamo pagpadal-an sang mga balatian pareho sa ginpadala ko sa mga Egyptohanon. Ako ang Ginoo nga inyo manug-ayo.” ");
INSERT INTO hil_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Nakaabot sila sa Elim, nga sa diin may 12 ka tuburan kag may 70 ka kahoy nga palma, kag nagkampo sila didto malapit sa tubig. ");
INSERT INTO hil_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Halin sa Elim, nagpadayon sa pagpanglakaton ang bilog nga komunidad sang Israel hasta nga nakaabot sila sa kamingawan sang Sin, nga ara sa tunga-tunga sang Elim kag Sinai. Nakaabot sila didto sang ika-15 nga adlaw sang ikaduha nga bulan halin sang pagguwa nila sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Didto sa kamingawan nagreklamo ang bilog nga komunidad kay Moises kag kay Aaron. ");
INSERT INTO hil_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Nagsiling sila, “Maayo pa nga ginpamatay na lang kami sang Ginoo sa Egypt. Didto bisan paano makakaon kami sang karne kag makapagusto sang bisan ano nga pagkaon. Pero karon gindala ninyo kami diri sa kamingawan para pagutuman hasta magkalamatay kami.” ");
INSERT INTO hil_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Dayon nagsiling ang Ginoo kay Moises, “Pamati! Paulanon ko sang tinapay halin sa langit para sa inyo. Kada adlaw magpanguha ang mga Israelinhon sang tinapay para sa sina lang nga adlaw. Sa sini nga paagi testingan ko sila kon bala tumanon nila ukon indi ang akon mga sugo. ");
INSERT INTO hil_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Silinga sila nga doblehon nila ang pagtipon sang tinapay sa ikaanom nga adlaw sang kada semana.” ");
INSERT INTO hil_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Gani nagsiling si Moises kag si Aaron sa tanan nga Israelinhon, “Karon sa gab-i, mareyalisar ninyo nga ang Ginoo amo ang nagpaguwa sa inyo sa Egypt, ");
INSERT INTO hil_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","kag sa aga makita ninyo ang gamhanan nga presensya sang Ginoo. Kay nabatian niya ang inyo mga reklamo. Sin-o gid bala kami nga magreklamo kamo sa amon? Ang matuod, ang Ginoo ang inyo ginareklamuhan.” ");
INSERT INTO hil_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Nagsiling pa gid si Moises, “Hatagan kamo sang Ginoo sang karne nga inyo kaunon kon gab-i kag tinapay nga makapagusto kamo kaon kon aga, kay nabatian niya ang inyo mga reklamo sa iya. Mareyalisar ninyo dayon nga wala kamo nagareklamo sa amon kundi sa Ginoo. Sin-o gid bala kami nga magreklamo kamo sa amon?” ");
INSERT INTO hil_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Nagsiling dayon si Moises kay Aaron, “Silinga ang bilog nga komunidad sang Israel nga magpalapit sila sa presensya sang Ginoo kay nabatian niya ang ila mga reklamo.” ");
INSERT INTO hil_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Samtang nagahambal si Aaron sa bilog nga komunidad, nagtulok sila sa kamingawan kag sa hinali lang nakita nila ang gamhanan nga presensya sang Ginoo sa panganod. ");
INSERT INTO hil_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nabatian ko ang mga reklamo sang mga Israelinhon. Silinga sila nga kada gab-i makakaon sila sang karne kag kada aga makapagusto sila sang tinapay. Dayon mahibaluan ninyo nga ako amo ang Ginoo nga inyo Dios.” ");
INSERT INTO hil_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Sang magsirom na, nag-abot ang madamo gid nga mga pitaw nga halos nagtabon sa ila kampo. Pagkaaga, ang duta sa ila kampo basa sang tun-og. ");
INSERT INTO hil_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Sang nagmala na ang tun-og, may nakita sila didto sa kamingawan nga manipis nga mga butang nga puwerte kaputi. ");
INSERT INTO hil_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Wala sila kahibalo kon ano ato, gani nagpinamangkutanay sila, “Ano ayhan ina?” Nagsiling si Moises sa ila, “Amo ina ang tinapay nga ginhatag sang Ginoo sa inyo para inyo kaunon. ");
INSERT INTO hil_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Nagsiling ang Ginoo nga ang kada isa sa inyo magtipon sini suno sa iya kinahanglanon: isa ka gantang kada tawo.” ");
INSERT INTO hil_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Gani nagpanguha ang mga Israelinhon sang sini nga pagkaon; ang iban madamo ang natipon kag ang iban diutay lang. ");
INSERT INTO hil_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Pero sang ginsukob nila ini, ang kada isa may isa ka gantang. Ang nagtipon sang madamo wala nagsobra, kag ang nagtipon sang diutay wala man makulangi. Tama-tama lang ang nakuha sang kada isa. ");
INSERT INTO hil_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Nagsiling si Moises sa ila, “Wala sing may magtigana sini para sa sunod nga adlaw.” ");
INSERT INTO hil_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Pero ang iban sa ila wala nagpati kay Moises, nagtigana sila para sa sunod nga adlaw. Pero nauluran ini kag nanimaho. Gani nangakig si Moises sa ila. ");
INSERT INTO hil_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kada aga nagapanguha ang kada isa suno sa iya kinahanglanon. Kag kon mag-init na gani, nagakatunaw ang pagkaon nga wala nila makuha. ");
INSERT INTO hil_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Sa ikaanom nga adlaw, ginadoble nila pagpanguha—mga duha ka gantang kada tawo. Gani nagkadto ang mga pangulo sang komunidad sang Israel kay Moises kag nagpamangkot kon ngaa ginadoble. ");
INSERT INTO hil_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Nagsiling si Moises sa ila, “Nagsugo ang Ginoo nga magpahuway kamo buwas kay Adlaw nga Inugpahuway, isa ka balaan nga adlaw para sa Ginoo. Gani lutua ninyo ang gusto ninyo nga lutuon, kag lagaa ang gusto ninyo nga lagaon. Ang mabilin itigana ninyo para sa buwas.” ");
INSERT INTO hil_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Gani gintigana nila ang nabilin para sa masunod nga adlaw suno sa ginsugo sa ila ni Moises. Kag pagkasunod nga adlaw wala ini nauluran ukon nanimaho. ");
INSERT INTO hil_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Nagsiling si Moises sa ila, “Kauna ninyo ina subong, kay Adlaw nga Inugpahuway subong para sa Ginoo. Wala kamo sing may makita sina sa duta subong nga adlaw. ");
INSERT INTO hil_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Makapanguha kamo sang sini nga pagkaon sa sulod sang anom ka adlaw, pero sa ikapito nga adlaw magpahuway kamo. Sa sina nga adlaw wala kamo sing may makuha nga pagkaon.” ");
INSERT INTO hil_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Pero may ara gihapon nga nagginuwa sa ikapito nga adlaw para manguha sang sadto nga pagkaon, pero wala sila sing may nakita. ");
INSERT INTO hil_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Dayon nagsiling ang Ginoo kay Moises, “Hasta san-o pa bala ini nga katawhan magsupak sa akon mga sugo kag mga pagpanudlo? ");
INSERT INTO hil_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Dumdumon ninyo nga ginhatagan ko kamo sang Adlaw nga Inugpahuway, amo ina nga kada ikaanom nga adlaw ginadoble ko ang inyo pagkaon para sa duha ka adlaw. Dapat ang kada isa magpabilin sa iya balay sa ikapito nga adlaw. Wala sing may magguwa sa pagpanguha sang pagkaon.” ");
INSERT INTO hil_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Gani nagpahuway ang mga tawo sa ikapito nga adlaw. ");
INSERT INTO hil_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Gintawag sang mga Israelinhon ang pagkaon nga manna. Daw sa mga liso ini nga magagmay kag maputi, kag matam-is pareho sa manipis nga tinapay nga may honey. ");
INSERT INTO hil_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Nagsiling si Moises sa ila, “Amo ini ang sugo sang Ginoo: ‘Magtago kamo sang isa ka gantang nga manna para sa palaabuton nga mga henerasyon, para makita nila ang pagkaon nga ginhatag ko sa inyo sa kamingawan sang ginpaguwa ko kamo sa Egypt.’ ” ");
INSERT INTO hil_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Nagsiling si Moises kay Aaron, “Magkuha ka sang tibod kag sudli ini sang isa ka gantang nga manna. Dayon ibutang ini sa presensya sang Ginoo para sa palaabuton nga mga henerasyon.” ");
INSERT INTO hil_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Gintuman ini ni Aaron suno sa ginsugo sang Ginoo kay Moises. Ginbutang ni Aaron ang manna sa Kahon sang Kasuguan para matago ini. ");
INSERT INTO hil_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Nagkaon ang mga Israelinhon sang manna sa sulod sang 40 ka tuig, hasta nakaabot sila sa duta nga ila estaran nga amo ang Canaan. ");
INSERT INTO hil_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Kada adlaw nagtipon ang kada isa sa ila sang isa ka omer nga manna, nga bali isa ka gantang.) ");
INSERT INTO hil_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Sa sugo sang Ginoo, naghalin ang bilog nga komunidad sang Israel sa kamingawan sang Sin kag nagpadayon sa pagpanglakaton. Nagsaylo-saylo sila halin sa isa ka lugar pakadto sa isa ka lugar. Sang ulihi nagkampo sila sa Refidim, pero wala sila sing tubig nga mainom didto. ");
INSERT INTO hil_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Gani ginbais nila si Moises kag nagsiling, “Hatagi kami sang tubig nga mainom.” Nagsabat si Moises, “Ngaa ginabais ninyo ako? Ngaa ginatestingan ninyo ang Ginoo?” ");
INSERT INTO hil_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Pero nauhaw gid ang mga tawo didto, gani padayon ang ila reklamo kay Moises. Nagsiling sila, “Ngaa bala ginpaguwa mo pa kami sa Egypt? Mapatay man lang gali kami diri sa kauhaw pati ang amon mga kabataan kag kasapatan.” ");
INSERT INTO hil_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Gani nagpangayo si Moises sang bulig sa Ginoo, “O Ginoo, ano bala ang himuon ko sa sini nga mga tawo? Halos batuhon na nila ako!” ");
INSERT INTO hil_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Nagsabat ang Ginoo kay Moises, “Kuhaa ang imo baston nga ginhampak mo sa Suba sang Nilo, kag mag-una ka sa mga tawo. Upda ang iban nga mga manugdumala sang Israel. ");
INSERT INTO hil_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Hulaton ko ikaw didto sa may bato sa Horeb.Kon didto ka na, hampakon mo ang bato, kag magaguwa ang tubig nga mainom sang mga tawo.” Gani ginhimo ini ni Moises sa atubangan sang mga manugdumala sang Israel. ");
INSERT INTO hil_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Gintawag ni Moises ato nga lugar nga Masa kag Meriba, tungod kay ginbais siya sang mga Israelinhon kag gintestingan nila ang Ginoo paagi sa pagsiling, “Ginaupdan bala kita sang Ginoo ukon wala?” ");
INSERT INTO hil_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Sang didto pa ang mga Israelinhon sa Refidim, ginsalakay sila sang mga Amaleknon. ");
INSERT INTO hil_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Nagsiling si Moises kay Josue, “Magpili ka sa aton mga tawo kag magpakig-away kamo sa mga Amaleknon. Magatindog ako buwas sa ibabaw sang bukid nga nagauyat sang baston nga ginsugo sang Dios nga akon dal-on.” ");
INSERT INTO hil_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Gani nagpakig-away sila ni Josue sa mga Amaleknon suno sa ginsugo ni Moises samtang sila ni Moises, Aaron, kag Hur nagsaka sa bukid. ");
INSERT INTO hil_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Kag samtang ginabayaw ni Moises ang iya kamot, nagadaog ang mga Israelinhon, pero kon paubuson niya gani ang iya kamot, nagadaog ang mga Amaleknon. ");
INSERT INTO hil_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Sang ulihi ginkapoy na ang kamot ni Moises. Gani nagkuha si Aaron kag Hur sang bato kag ginpapungkuan ini kay Moises. Dayon ginbayaw ni Aaron ang isa ka kamot ni Moises kag amo man ang ginhimo ni Hur sa isa ka kamot hasta magsalop ang adlaw. ");
INSERT INTO hil_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Gani napierdi nila ni Josue ang mga Amaleknon. ");
INSERT INTO hil_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Dayon nagsiling ang Ginoo kay Moises, “Isulat mo ini sa linukot nga sululatan para indi malipatan kag ipahibalo mo ini kay Josue: Dulaon ko gid sing bug-os ang mga Amaleknon.” ");
INSERT INTO hil_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Naghimo si Moises sang halaran kag gintawag ini nga, “Ang Ginoo amo ang akon Bandera sa Pagdaog.” ");
INSERT INTO hil_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Nagsiling siya, “Tungod nga gintaya sang mga Amaleknon ang ila mga inumol sa trono sang Ginoo, padayon nga magapakig-away ang Ginoo kontra sa ila hasta san-o.” ");
INSERT INTO hil_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Si Jetro nga pari sang Midian kag ugangan ni Moises nakabalita sang tanan nga ginhimo sang Dios kay Moises kag sa iya katawhan nga mga Israelinhon. Nabatian man niya kon paano ginpaguwa sang Ginoo ang mga Israelinhon sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Sadto anay ginpapuli ni Moises si Zipora nga iya asawa kag ang duha nila ka anak nga lalaki didto kay Jetro nga iya ugangan. Ang ngalan sang isa niya ka anak amo si Gershom, kay sang natawo siya nagsiling si Moises, “Pangayaw ako sa iban nga duta.” ");
INSERT INTO hil_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ang ngalan sang ikaduha amo si Eliezer, kay sang natawo siya nagsiling si Moises, “Ang Dios sang akon amay amo ang akon manugbulig. Ginluwas niya ako sa espada sang hari sang Egypt.” ");
INSERT INTO hil_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Karon, nagkadto si Jetro kaupod ang asawa kag duha ka anak ni Moises didto sa ginakampuhan nila ni Moises sa kamingawan, malapit sa bukid sang Dios. ");
INSERT INTO hil_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Nagpahibalo na nga daan si Jetro kay Moises nga maabot siya upod si Zipora kag ang duha niya ka anak. ");
INSERT INTO hil_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Gani ginsugata ni Moises ang iya ugangan, kag bilang pagtahod nagluhod siya kag pagkatapos naghalok sa iya. Nagpangamustahanay sila kag dayon nagsulod sila sa tolda. ");
INSERT INTO hil_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ginsugid ni Moises kay Jetro ang tanan nga ginhimo sang Ginoo sa hari sang Egypt kag sa mga Egyptohanon para sa mga Israelinhon. Ginsugid man niya ang tanan nga kabudlayan nga ila naagyan sa ila nga pagpanglakaton kag kon paano sila ginluwas sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Nalipay gid si Jetro sa tanan nga kaayo nga ginhimo sang Ginoo sa mga Israelinhon sa iya pagluwas sa ila sa kamot sang mga Egyptohanon. ");
INSERT INTO hil_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Nagsiling si Jetro, “Dalayawon ang Ginoo nga nagluwas sa inyo sa kamot sang mga Egyptohanon kag sa ila hari. ");
INSERT INTO hil_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Karon nahibaluan ko na nga ang Ginoo mas gamhanan sang sa tanan nga dios, kay ginluwas niya ang mga Israelinhon sa mga Egyptohanon nga nagdaogdaog sa ila.” ");
INSERT INTO hil_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Dayon naghalad si Jetro sang mga halad nga ginasunog kag iban pa nga mga halad sa Dios. Kag samtang ginahimo niya ini, nag-abot si Aaron kag ang tanan nga manugdumala sang Israel. Nag-upod sila kay Jetro sa pagkaon sa presensya sang Dios. ");
INSERT INTO hil_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Sang sunod nga adlaw, nagpungko si Moises bilang hukom sa paghusay sa mga kaso sang mga tawo. Nagalinya ang mga tawo sa iya atubangan halin sa aga hasta sa sirom. ");
INSERT INTO hil_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Sang makita ini ni Jetro, nagsiling siya kay Moises, “Ngaa ginahimo mo ini para sa mga tawo? Ngaa ikaw lang ang nagahimo sini? Nagalinya ang mga tawo sa imo atubangan halin sa aga hasta sa sirom.” ");
INSERT INTO hil_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Nagsabat si Moises, “Ginahimo ko ini tungod kay nagapalapit ang mga tawo sa akon sa paghibalo sang kabubut-on sang Dios. ");
INSERT INTO hil_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kon may ginabaisan ang mga tawo, ginadala ini sa akon, kag ako ang nagahukom kon sin-o sa ila ang husto. Kag ginatudluan ko sila sang mga sugo kag mga pagsulundan sang Dios.” ");
INSERT INTO hil_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Nagsiling si Jetro, “Indi husto ang imo pamaagi sa paghimo sini. ");
INSERT INTO hil_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ginapabudlayan mo lang gid ang imo kaugalingon kag ang ini nga mga tawo. Tama ini kabudlay para sa imo; indi mo ini mahimo nga ikaw lang. ");
INSERT INTO hil_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Pamati sa akon kay laygayan ko ikaw, kag kabay pa nga mag-upod ang Dios sa imo. Padayuna ang imo ginahimo nga pagpalapit sa Dios para sa mga tawo. Dal-a ang ila mga ginabaisan sa iya. ");
INSERT INTO hil_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Padayuna man ang imo nga pagtudlo sa ila sang mga sugo kag mga pagsulundan sang Dios. Tudlui sila kon paano magkabuhi kag kon ano ang ila himuon. ");
INSERT INTO hil_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Pero magpili ka sang mga tawo nga magbulig sa imo sa paghukom. Dapat may ikasarang sila sa paghukom, nagatahod sa Dios, masaligan, kag wala nagabaton sang lagay. Himua sila nga mga hukom sa grupo sang mga tawo nga tag-isa ka libo, tag-isa ka gatos, tag-singkuwenta kag tag-napulo. ");
INSERT INTO hil_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Mag-alagad sila bilang mga hukom sa tanan nga tion. Sila ang magahusay sa simple nga mga kaso, pero ang mabudlay nga mga kaso dal-on nila sa imo. Sa sini nga paagi, magmulumag-an ang imo obra kay makabulig sila sa imo. ");
INSERT INTO hil_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Nahibaluan ko nga amo ini ang gusto sang Dios nga himuon mo, kag kon tumanon mo ini indi ka mabudlayan. Kag ini nga mga tawo makapuli nga matawhay.” ");
INSERT INTO hil_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Gintuman ni Moises ang ginlaygay sang iya ugangan. ");
INSERT INTO hil_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Nagpili siya sa mga Israelinhon sang mga tawo nga may ikasarang sa paghukom, kag ginhimo niya sila nga mga hukom sa grupo sang mga tawo nga tag-isa ka libo, tag-isa ka gatos, tag-singkuwenta, kag tag-napulo. ");
INSERT INTO hil_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Nag-alagad sila sa mga tawo bilang mga hukom sa tanan nga tion. Sila ang nagahusay sa simple nga mga kaso, pero ang mabudlay nga mga kaso ginadala nila kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Sang ulihi ginpabalik ni Moises ang iya ugangan sa iya nasyon. ");
INSERT INTO hil_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Naghalin ang mga Israelinhon sa Refidim kag nagkadto sa kamingawan sang Sinai. Didto sila nagkampo sa atubangan sang bukid. Ikatatlo ato nga bulan halin sang paghalin nila sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Nagsaka si Moises sa bukid para magpakigkita sa Dios. Gintawag siya sang Ginoo didto sa bukid kag ginsilingan, “Amo ini ang imo isiling sa mga Israelinhon nga mga kaliwat ni Jacob: ");
INSERT INTO hil_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Nakita ninyo mismo kon ano ang ginhimo ko sa mga Egyptohanon, kag kon paano ko kamo gindala diri sa akon, pareho sang pagdala sang agila sa iya mga piso nga ginaprotektaran sang iya mga pakpak. ");
INSERT INTO hil_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Kon magtuman kamo sing bug-os sa akon kag magsunod sa akon kasugtanan, pilion ko kamo sa tanan nga nasyon nga mangin akon espesyal nga katawhan. Akon ang bilog nga kalibutan, ");
INSERT INTO hil_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","pero mangin akon kamo nga pinili nga katawhan, kag mangin isa kamo ka ginharian nga magaalagad sa akon bilang mga pari.’ Amo ini ang ihambal mo sa mga Israelinhon.” ");
INSERT INTO hil_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Gani nagpanaog si Moises sa bukid kag ginpatawag niya ang mga manugdumala sang mga Israelinhon kag ginsugiran niya sila sang ginsiling sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Nagkomporme ang tanan nga Israelinhon sa ginhambal ni Moises kag nagsiling sila, “Tumanon namon ang tanan nga ginsugo sang Ginoo.” Kag ginsugid ni Moises sa Ginoo ang sabat sang mga tawo. ");
INSERT INTO hil_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Nagsiling ang Ginoo kay Moises, “Makadto ako sa imo paagi sa madamol nga panganod para makabati ang mga tawo samtang nagapakighambal ako sa imo. Dayon magasalig sila permi sa imo.” Pagkatapos nga masugid ni Moises sa Ginoo ang sabat sang mga tawo, ");
INSERT INTO hil_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","nagsiling pa ang Ginoo sa iya, “Kadtui ang mga tawo kag silinga sila nga magpakatinlo sila subong kag sa buwas. Kinahanglan labhan nila ang ila mga bayo. ");
INSERT INTO hil_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Siguraduha nga preparado sila sa ikatlo nga adlaw, kay sa sina nga adlaw, ako, ang Ginoo, magapanaog sa ibabaw sang Bukid sang Sinai nga makita sang tanan nga tawo. ");
INSERT INTO hil_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Butangi sang tanda sa palibot sang bukid kon diin lang hasta magtindog ang mga tawo. Silinga sila nga indi gid sila magsaka ukon magpalapit sa tiilan sang bukid. Ang bisan sin-o nga magpalapit sa bukid pagapatyon gid, ");
INSERT INTO hil_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","tawo man ukon sapat. Pagapatyon gid siya paagi sa pagbato ukon pagpana; indi siya pagtandugon. Makasaka lang ang mga tawo sa bukid kon patunugon na sing malawig ang budyong.” ");
INSERT INTO hil_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Nagpanaog si Moises sa bukid kag ginsugo niya ang mga tawo nga magpakatinlo. Kag ginlabhan sang mga tawo ang ila mga bayo. ");
INSERT INTO hil_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Nagsiling si Moises sa ila, “Ipreparar ninyo ang inyo kaugalingon para sa ikatlo nga adlaw; indi anay kamo maghulid sa inyo asawa.” ");
INSERT INTO hil_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Sang pagkaaga sang ikatlo nga adlaw, nagdinaguob kag nagpinangilat, kag may madamol nga gal-om nga nagtabon sa bukid, kag mabatian ang matunog gid nga huni sang budyong. Nagkurog sa kahadlok ang tanan nga tawo sa kampo. ");
INSERT INTO hil_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Dayon gindala ni Moises ang mga tawo sa guwa sang kampo sa pagpakigkita sa Dios, kag nagtindog sila sa tiilan sang bukid. ");
INSERT INTO hil_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Nalikupan sang aso ang bilog nga Bukid sang Sinai kay nagpanaog didto ang Ginoo sa dagway sang kalayo. Nagtub-ok ang aso pareho sa aso nga naghalin sa hurnohan kag nagtay-og sing mabaskog ang bukid, ");
INSERT INTO hil_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","kag nagbaskog pa gid ang huni sang budyong. Dayon naghambal si Moises kag nagsabat ang Dios sa iya paagi sa daguob. ");
INSERT INTO hil_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Nagpanaog ang Ginoo sa ibabaw sang Bukid sang Sinai, kag ginhambalan niya si Moises nga magsaka sa ibabaw sang Bukid. Gani nagsaka si Moises ");
INSERT INTO hil_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","kag nagsiling ang Ginoo sa iya, “Magbalik ka sa idalom kag paandami ang mga tawo nga indi gid sila maglapaw sa tanda sa palibot sang bukid para tan-awon ako. Kay kon himuon nila ini, madamo sa ila ang mapatay. ");
INSERT INTO hil_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Bisan ang mga pari nga nagapalapit permi sa akon presensya kinahanglan nga magpakatinlo sang ila kaugalingon, kay kon indi gani, silutan ko man sila.” ");
INSERT INTO hil_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Nagsiling si Moises sa Ginoo, “Indi makasaka ang mga tawo sa bukid kay ikaw mismo ang nagpaandam sa amon nga kabigon namon ang bukid nga balaan, kag ginhambalan mo kami nga butangan namon sang tanda sa palibot sang bukid kon diin lang kami hasta magtindog.” ");
INSERT INTO hil_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Nagsiling ang Ginoo sa iya, “Panaog kag dal-a si Aaron diri. Pero ang mga pari kag ang mga tawo indi dapat magkadto diri sa akon. Kay kon magkadto sila diri silutan ko gid sila.” ");
INSERT INTO hil_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Gani nagpanaog si Moises kag ginsilingan ang mga tawo. ");
INSERT INTO hil_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Nagsiling ang Dios: ");
INSERT INTO hil_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ako ang Ginoo nga inyo Dios nga nagpaguwa sa inyo sa Egypt nga sa diin kamo gin-ulipon. ");
INSERT INTO hil_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Indi kamo magsimba sa iban nga dios magluwas sa akon. ");
INSERT INTO hil_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Indi kamo maghimo sang mga dios-dios sa dagway sang bisan ano nga ara sa langit, ukon sa duta, ukon sa tubig. ");
INSERT INTO hil_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Indi gid ninyo ini pag-alagaron kag simbahon, kay ako, ang Ginoo nga inyo Dios, indi gid gusto nga may ginasimba kamo nga iban. Ginasilutan ko ang mga nakasala sa akon pati ang ila mga kaliwat hasta sa ikatatlo kag ikaapat nga henerasyon nga nagasikway sa akon. ");
INSERT INTO hil_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Pero ginapakita ko ang akon kaayo sa madamo gid nga mga henerasyon nga nagahigugma sa akon kag nagatuman sang akon mga sugo. ");
INSERT INTO hil_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Indi ninyo paggamita ang ngalan sang Ginoo nga inyo Dios sa wala sing pulos kay ako, ang Ginoo, magasilot sa kay bisan sin-o nga maggamit sang akon ngalan sa wala sing pulos. ");
INSERT INTO hil_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Tumana ninyo ang akon mga ginapahimo sa Adlaw nga Inugpahuway, kag himua ninyo ini nga pinasahi nga adlaw para sa akon. ");
INSERT INTO hil_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Mag-obra kamo sa sulod sang anom ka adlaw, ");
INSERT INTO hil_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","pero ang ikapito nga adlaw amo ang Adlaw nga Inugpahuway nga inyo painon para sa akon, ang Ginoo nga inyo Dios. Indi kamo mag-obra sa sina nga adlaw pati ang inyo mga anak, mga ulipon, mga kasapatan, kag ang mga pangayaw nga nagaestar sa inyo mga banwa. ");
INSERT INTO hil_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kay sa sulod sang anom ka adlaw ginhimo ko ang kalangitan, ang duta, ang dagat kag ang tanan nga ara sa ila, pero nagpahuway ako sa ikapito nga adlaw. Gani ginbendisyunan ko ang Adlaw nga Inugpahuway kag ginhimo nga pinasahi nga adlaw para sa akon. ");
INSERT INTO hil_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Tahura ang inyo amay kag iloy para magkabuhi kamo sing malawig sa duta nga ginahatag ko sa inyo. ");
INSERT INTO hil_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Indi kamo magpatay. ");
INSERT INTO hil_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Indi kamo magpanginbabayi ukon magpanginlalaki. ");
INSERT INTO hil_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Indi kamo magpangawat. ");
INSERT INTO hil_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Indi kamo magsaksi sing butig kontra sa inyo isigkatawo. ");
INSERT INTO hil_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Indi kamo magkahisa sa balay sang inyo isigkatawo, ukon sa iya asawa, mga ulipon, mga baka ukon donkey, ukon sa bisan ano nga ara sa iya.” ");
INSERT INTO hil_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Sang mabatian sang mga tawo ang daguob, kag ang tunog sang budyong, kag sang makita nila ang kilat kag ang bukid nga nagaaso, nagkulurog sila sa kahadlok. Nagtindog sila sa malayo ");
INSERT INTO hil_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","kag nagsiling kay Moises, “Ikaw lang ang maghambal sa amon kay mamati kami, indi lang ang Dios kay basi mapatay kami.” ");
INSERT INTO hil_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Gani nagsiling si Moises sa mga tawo, “Indi kamo magkahadlok, kay nagkadto diri ang Dios sa pagpatilaw sa inyo sang iya gahom para magkahadlok kamo sa iya sa paghimo sang sala.” ");
INSERT INTO hil_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Nagtindog gihapon ang mga tawo sa malayo samtang si Moises nagpalapit sa madamol nga gal-om nga sa diin ara ang Dios. ");
INSERT INTO hil_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Dayon nagsiling ang Ginoo kay Moises, “Ihambal ini sa mga Israelinhon: Nakita ninyo nga nagpakighambal ako sa inyo halin sa langit. ");
INSERT INTO hil_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Gani indi kamo maghimo sang mga dios-dios nga pilak ukon bulawan para simbahon kaupod sa akon. ");
INSERT INTO hil_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“Maghimo kamo sang halaran nga duta para sa akon kag dira ninyo ihalad ang inyo mga karnero, mga kanding, kag mga baka bilang halad nga ginasunog kag halad nga para sa maayo nga relasyon. Himuon ninyo ini sa lugar nga akon ginpili nga pagasimbahon ako, kag didto kadtuan ko kamo kag bendisyunan. ");
INSERT INTO hil_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kon maghimo kamo sang halaran nga bato para sa akon indi ninyo ini pagbasbasan, kay kon gamitan ninyo ini sang pangbasbas, indi na ini takos nga gamiton sa paghalad sa akon. ");
INSERT INTO hil_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Kag indi man kamo maghimo sang halaran nga may hagdanan kay basi makita ang inyo kinatawo kon magsaka kamo.” ");
INSERT INTO hil_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Nagsiling ang Ginoo kay Moises, “Amo ini ang mga pagsulundan nga ipatuman mo sa mga Israelinhon: ");
INSERT INTO hil_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Kon magbakal kamo sang ulipon nga Hebreo, magaalagad siya sa inyo sa sulod sang anom ka tuig. Pero sa ikapito nga tuig, mahilway na siya sa pagkaulipon nga wala siya sing bayaran. ");
INSERT INTO hil_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kon sang pagbakal sa iya wala pa siya sing asawa kag sang ulihi nagpangasawa siya, siya lang ang mahilway sa ikapito nga tuig. Pero kon may asawa na siya sang pagbakal sa iya, ang iya asawa mahilway man upod sa iya. ");
INSERT INTO hil_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kon ginpaasawahan siya sang iya amo kag nakabata sila sang iya asawa, mahilway siya, pero ang iya asawa kag mga bata magapabilin sa iya amo. ");
INSERT INTO hil_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Pero kon magsiling ang ulipon nga ginahigugma niya ang iya amo, ang iya asawa kag mga bata, kag indi niya gusto nga mahilway, ");
INSERT INTO hil_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","dal-on siya sang iya amo sa presensya sang Dios. Kag didto sa puwertahan ukon hamba tuhugan sang iya amo ang iya dulunggan sang inugtuhog, kag mangin ulipon siya sang iya amo sa bilog niya nga kabuhi. ");
INSERT INTO hil_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Kon ibaligya sang isa ka tawo ang iya anak nga babayi nga mangin ulipon, indi siya mahilway sa ikapito nga tuig pareho sa mga lalaki nga ulipon. ");
INSERT INTO hil_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kon wala malipay sa iya ang iya amo nga nagbakal sa iya, puwede siya nga gawaron sang iya pamilya. Pero indi siya puwede nga ibaligya sang iya amo sa mga indi Israelinhon tungod kay ang iya amo, amo ang nagtalikod sa iya. ");
INSERT INTO hil_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Kon ipaasawa sang amo ini nga ulipon sa iya anak, kinahanglan nga kabigon niya siya bilang iya anak nga babayi. ");
INSERT INTO hil_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kon pangasaw-on niya mismo ini nga ulipon, kag magpangasawa pa gid siya sang iban nga babayi, kinahanglan padayunon niya ang paghatag sa sini nga ulipon sang pagkaon kag bayo, kag ang paghulid sa iya. ");
INSERT INTO hil_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Kon indi niya matuman ining tatlo ka butang, puwede maghalin ina nga babayi nga wala sing balayran. ");
INSERT INTO hil_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Ang bisan sin-o nga magsakit sang tawo kag mapatay niya ini, dapat patyon man siya. ");
INSERT INTO hil_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Pero kon wala niya ini ginhungod kag gintugutan ko ini nga matabo, makapalagyo siya sa lugar nga himuon ko nga dalangpan. ");
INSERT INTO hil_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Pero kon ginplano niya kag ginhungod ang pagpatay, patya ninyo siya bisan magpalapit pa siya sa akon halaran. ");
INSERT INTO hil_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Ang bisan sin-o nga magsakit sa iya amay kag iloy dapat patyon. ");
INSERT INTO hil_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ang bisan sin-o nga magkidnap sang tawo dapat patyon, bisan ginbaligya na niya ang iya ginkidnap ukon wala pa. ");
INSERT INTO hil_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Ang bisan sin-o nga magpakamalaot sa iya amay ukon iloy dapat patyon. ");
INSERT INTO hil_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Halimbawa, nag-away ang duha ka tawo, kag ginsumbag sang isa ukon ginlampusan sang bato ang iya kontra kag indi na ini makabangon pero wala mapatay. ");
INSERT INTO hil_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Kon sa ulihi makabangon siya kag makalakat-lakat, bisan nagabaston lang, ang tawo nga nagsakit sa iya indi pagsilutan. Pero kinahanglan magbayad ang tawo sa iya, sa iya panahon nga nausik tungod sa iya pagkabalda, kag kinahanglan atipanon siya sang tawo hasta mag-ayo siya. ");
INSERT INTO hil_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Kon ginbakol sang isa ka tawo ang iya ulipon, lalaki man ukon babayi, kag napatay ini, dapat silutan siya. ");
INSERT INTO hil_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Pero kon wala mapatay ang ulipon kag nakabangon ini pagkaligad sang isa ukon duha ka adlaw, ang tawo indi pagsilutan kay siya man ang tag-iya sang ulipon. ");
INSERT INTO hil_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Kon may nagaaway kag naigo ang isa ka babayi nga nagabusong, kag nagbata ini sa indi pa oras, pero wala man sing may malain nga natabo sa iya, ang nakaigo pabayaron suno sa kantidad nga pangayuon sang bana kag ginatugutan sang mga hukom. ");
INSERT INTO hil_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Pero kon grabe ang natabo sa babayi silutan ang responsable suno man sa natabo sa babayi. Kon napatay ang babayi, patyon man siya. ");
INSERT INTO hil_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Kon nabulag ang babayi, bulagon man siya. Kon nabingaw ang ngipon, bingawon man siya. Kon nabali ang kamot ukon tiil, balion man ang iya kamot ukon tiil. ");
INSERT INTO hil_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Kon napaso, pasuon man siya. Kon napilas, pilason man siya. Kag kon nabagrasan, bagrasan man siya. ");
INSERT INTO hil_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Kon nasumbag sang amo ang iya ulipon nga lalaki ukon babayi sa mata kag nabulag ini, hilwayon niya siya sa pagkaulipon bilang bayad sa mata nga iya ginbulag. ");
INSERT INTO hil_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kon nabingaw niya ang ngipon sang iya ulipon nga lalaki ukon babayi, hilwayon man niya siya sa pagkaulipon bilang bayad sa ngipon nga iya ginbingaw. ");
INSERT INTO hil_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Kon ang turo nga baka nakasungay sang tawo, lalaki ukon babayi, kag napatay ini, dapat batuhon ang baka, kag indi pagkan-on ang iya unod, pero ang tag-iya sang baka wala sing salabton. ");
INSERT INTO hil_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Pero kon ang baka naanad na nga magpanungay sang tawo kag ginpaandaman na ang tag-iya parte sini, pero ginpabay-an lang niya ang baka, kag nakapatay ini sang tawo, kinahanglan batuhon ini hasta mapatay kag ang tag-iya patyon man. ");
INSERT INTO hil_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Pero kon pabayaron ang tag-iya para mabuhi siya, kinahanglan nga bayaran niya kon pila ang ipabayad sa iya. ");
INSERT INTO hil_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Amo man ini ang pagsulundan kon nakasungay ang baka sang bata, lalaki man ukon babayi. ");
INSERT INTO hil_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kon nakasungay ang baka sang ulipon, lalaki man ukon babayi, kinahanglan nga magbayad ang tag-iya sini sang 30 ka bilog nga pilak sa amo sang ulipon, kag kinahanglan nga batuhon ang baka hasta mapatay. ");
INSERT INTO hil_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Halimbawa, may tawo nga nagkuha sang tabon sang bubon ukon nagkutkot sang bubon kag wala niya ini pagtabuni, kag may nahulog nga baka ukon donkey sa amo nga bubon, ");
INSERT INTO hil_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ang tag-iya sang bubon dapat magbayad sa tag-iya sang sapat, kag mangin iya na ang patay nga sapat. ");
INSERT INTO hil_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Kon ang baka sang isa ka tawo nakapatay sang baka sang iya kapareho, ibaligya nila nga duha ang buhi nga baka kag tungaon ang kuwarta. Tungaon man nila ang karne sang napatay nga baka. ");
INSERT INTO hil_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Pero kon ang baka nga nakapatay naanad na nga magpanungay kag ginpabay-an lang ini sang tag-iya, dapat magbayad ang tag-iya sini sang isa man ka baka sa baylo sang napatay, kag ining napatay nga baka mangin iya na. ");
INSERT INTO hil_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Kon ang isa ka tawo nangawat sang baka ukon karnero, kag gin-ihaw niya ini ukon ginbaligya, dapat magbayad siya. Sa isa ka baka nga iya ginkawat, magbayad siya sang lima ka baka. Kag sa isa ka karnero nga iya ginkawat, magbayad siya sang apat ka karnero. ");
INSERT INTO hil_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kon nangawat siya sa gab-i kag nadakpan sa akto, kag ginpatay siya, ang nakapatay sa iya wala sing salabton. ");
INSERT INTO hil_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Pero kon natabo ini sa adlaw, ang nakapatay sa kawatan may salabton. “Ang kawatan nga nadakpan dapat magbayad sa iya nga ginkawat. Pero kon wala siya sing ibayad, ibaligya siya nga ulipon kag ang iya bili ibayad sa iya nga ginkawat. ");
INSERT INTO hil_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Kon ang iya ginkawat nga baka ukon donkey ukon karnero nasapwan nga ara pa sa iya kag buhi pa ini, bayaran niya ini sing doble. ");
INSERT INTO hil_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Kon ang sapat sang isa ka tawo iya ginpabay-an nga maghalab sa talamnan sang iban, kinahanglan nga bayaran niya ang nahalab nga tanom sang pinakamaayo nga patubas sang iya uma ukon sang iya talamnan sang ubas. ");
INSERT INTO hil_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Kon may tawo nga nagpanutod, kag ang kalayo naglapta sa mga hilamon hasta sa talamnan sang iban nga tawo, ang nagpanutod dapat nga magbayad sang mga tanom nga napierdi. ");
INSERT INTO hil_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Halimbawa, nagpatago ang isa ka tawo sang iya kuwarta ukon sang bisan ano nga butang sa iya tupad-balay, kag ginkawat ini. Kon madakpan ang kawatan, dapat magbayad siya sing doble. ");
INSERT INTO hil_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Pero kon indi madakpan ang kawatan, ang ginbilinan sang pagkabutang pagadal-on sa presensya sang Dios, para mahibaluan kon ginkuha niya ukon wala ang ginpatago sa iya. ");
INSERT INTO hil_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Halimbawa, may duha ka tawo nga nagabaisay kon sin-o sa ila ang tag-iya sang isa ka pagkabutang pareho sang baka, donkey, karnero, bayo, ukon bisan ano nga butang, dapat dal-on nila ang ila kaso sa presensya sang Dios. Ang nakasala sa ila suno sa desisyon sang Dios magabayad sing doble sa tag-iya. ");
INSERT INTO hil_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Halimbawa, ginpasagod sang isa ka tawo ang iya donkey, baka, karnero, ukon bisan ano nga sapat sa iya tupad-balay, kag napatay ini, ukon napilasan, ukon nadula, nga wala sing may nakakita. ");
INSERT INTO hil_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Ang nagsagod dapat magkadto sa presensya sang Ginoo kag magsumpa nga wala siya sing may nahibaluan sa natabo. Dapat ini patihan sang tag-iya, kag indi niya siya pagpabayaron. ");
INSERT INTO hil_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Pero kon ginkawat ang sapat, dapat magbayad ang nagsagod sa tag-iya. ");
INSERT INTO hil_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kon ang sapat ginpatay sang mapintas nga sapat, kinahanglan dal-on niya ang nabilin nga parte sang sapat bilang pamatuod, kag indi niya kinahanglan nga bayaran ini. ");
INSERT INTO hil_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Halimbawa, naghulam ang isa ka tawo sang sapat sa iya tupad-balay kag napilas ini ukon napatay, kag wala ang tag-iya pagkatabo sini. Ang naghulam dapat magbayad sini. ");
INSERT INTO hil_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Pero kon ara ang tag-iya sang pagkatabo, ang naghulam indi na magbayad. Kon gin-arkilahan ang sapat, ang kuwarta nga ginbayad sa arkila amo na ang ibayad sa napilasan ukon napatay nga sapat. ");
INSERT INTO hil_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Kon gintintar sang isa ka lalaki ang isa ka dalaga nga indi pa kalaslon, kag nagpakighilawas siya sa iya, dapat magbayad ang lalaki sa pamilya sang babayi sang balayran sa pagpangasawa, kag dayon pangasaw-on niya ang babayi. ");
INSERT INTO hil_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Kon indi gid magsugot ang amay sang babayi nga ipakasal ang iya anak sa ato nga lalaki, magbayad gihapon ang lalaki sang amo nga balayran. ");
INSERT INTO hil_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Patya ninyo ang mga babaylan. ");
INSERT INTO hil_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Ang bisan sin-o nga magpakighilawas sa sapat dapat patyon. ");
INSERT INTO hil_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Ang bisan sin-o nga maghalad sa iban nga dios luwas sa akon dapat laglagon sing bug-os. ");
INSERT INTO hil_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Indi ninyo pagdaog-daugon ang mga pangayaw kay mga pangayaw man kamo sadto sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Indi ninyo pagpamintahaan ang mga balo nga babayi kag ang mga ilo. ");
INSERT INTO hil_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kon himuon ninyo ini, kag magpangayo sila sang bulig sa akon, sigurado gid nga buligan ko sila. ");
INSERT INTO hil_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Mangakig gid ako sa inyo kag pamatyon ko kamo sa inaway. Mabalo ang inyo mga asawa kag mailo ang inyo mga kabataan. ");
INSERT INTO hil_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Kon magpahulam kamo sang kuwarta sa bisan kay sin-o sa akon katawhan nga imol, indi ninyo pagpasakai pareho sa ginahimo sang mga manugpahulam sang kuwarta. ");
INSERT INTO hil_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kon kuhaon ninyo ang pangtabon nga panapton sang inyo isigkatawo bilang garantiya nga magbayad siya sa iya utang sa imo, iuli ini sa iya antes magsalop ang adlaw. ");
INSERT INTO hil_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Kay amo lang ini ang iya pangtabon sa iya lawas kon magtulog siya kon gab-i. Kon magpangayo siya sang bulig sa akon, buligan ko siya kay maluluy-on ako. ");
INSERT INTO hil_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Indi ninyo pag-insultuhon ang Dios kag indi ninyo pagpakamalauta ang nagadumala sa inyo. ");
INSERT INTO hil_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Indi ninyo pagkalimti ang paghatag sang mga halad sa akon halin sa inyo mga patubas kag mga duga sang prutas. “Idedikar ninyo sa akon ang inyo kamagulangan nga mga lalaki, ");
INSERT INTO hil_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","pati ang kamagulangan sang inyo mga baka kag mga karnero. Ang bag-o natawo nga baka ukon karnero dapat magpabilin sa iya iloy sa sulod sang pito ka adlaw. Pero halin sa ikawalo nga adlaw, puwede na ini ihalad sa akon. ");
INSERT INTO hil_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Kamo ang akon pinili nga katawhan, gani indi kamo magkaon sang karne sang bisan ano nga sapat nga ginpatay sang mapintas nga sapat. Ipakaon ninyo ini sa mga ido. ");
INSERT INTO hil_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Indi kamo magbalita sang kabutigan. Indi kamo magbulig sa malain nga tawo paagi sa pagsaksi sing butig. ");
INSERT INTO hil_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Indi kamo magsunod sa kadam-an sa paghimo sing malain. Kon magsaksi kamo sa korte, indi ninyo pagtikua ang hustisya tungod gusto mo lang magsunod sa kadam-an. ");
INSERT INTO hil_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Indi ninyo pagpaburi ang mga imol sa ila kaso. ");
INSERT INTO hil_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Kon makita ninyo nga nakabuhi ang baka ukon donkey sang inyo kaaway, dapat iuli ninyo ini sa iya. ");
INSERT INTO hil_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kon makita ninyo nga natumba ang donkey sang inyo kaaway tungod sa kabug-at sang iya sini karga, indi lang ninyo ini pagpabay-an kundi buligan ninyo nga makatindog. ");
INSERT INTO hil_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Siguraduha ninyo nga mahatagan sang hustisya ang mga imol sa ila kaso. ");
INSERT INTO hil_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Indi kamo mag-akusar sing binutig. Indi ninyo pagpatya ang matarong o inosente nga mga tawo, kay silutan ko gid ang bisan sin-o nga maghimo sini. ");
INSERT INTO hil_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Indi kamo magbaton sang lagay, kay ang lagay makabulag sa mga tawo sa kamatuoran, kag makahalit ini sa kinamatarong sang mga inosente. ");
INSERT INTO hil_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Indi ninyo pagpigusa ang mga pangayaw, kay kamo mismo nakahibalo kon ano ang balatyagon sang isa ka pangayaw, kay mga pangayaw man kamo sadto anay sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Sa sulod sang anom ka tuig makatanom kamo kag makaani sa inyo duta. ");
INSERT INTO hil_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Pero sa ikapito nga tuig indi ninyo ini pagtamnan. Kon may magtubo nga tanom sa inyo duta, pabay-i lang ninyo ang mga imol nga makakuha sang pagkaon sa mga tanom, kag ang mabilin ipakaon sa talunon nga mga sapat. Amo man sini ang inyo himuon sa inyo mga talamnan sang ubas kag sa inyo mga talamnan sang olibo. ");
INSERT INTO hil_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Mag-obra kamo sa sulod sang anom ka adlaw, pero sa ikapito nga adlaw magpahuway kamo para makapahuway man ang inyo mga baka kag mga donkey, kag pati ang inyo mga ulipon kag ang mga pangayaw. ");
INSERT INTO hil_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Tumana ninyo sing maayo ining tanan nga ginsiling ko sa inyo. Indi kamo magpangamuyo sa iban nga mga dios ukon bisan magsambit sang ila ngalan. ");
INSERT INTO hil_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Magsaulog kamo sang tatlo ka piesta kada tuig para sa akon kadungganan. ");
INSERT INTO hil_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Sauluga ninyo ang Piesta sang Tinapay nga Wala sing Inugpahabok. Suno sa ginsugo ko na sa inyo, magkaon kamo sang tinapay nga wala sing inugpahabok sa sulod sang pito ka adlaw. Himua ninyo ini sa gintalana nga tion sa bulan sang Aviv, kay amo ina nga bulan nga nagguwa kamo sa Egypt. Ang kada isa dapat magdala sa akon sang halad sa sina nga tion. ");
INSERT INTO hil_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Sauluga man ninyo ang Piesta sang Pag-ani paagi sa pagdala sa akon sang nahauna nga patubas sang inyo mga uma. Sauluga man ninyo ang Piesta sang Katapusan nga Ani sa katapusan sang tuig, kon magtipon na kamo sang mga patubas sang inyo mga uma. ");
INSERT INTO hil_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Ang inyo mga lalaki dapat magtambong sa sini nga mga piesta kada tuig sa pagsimba sa akon, ang Ginoo nga inyo Agalon. ");
INSERT INTO hil_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Indi kamo maghalad sang dugo sa akon kaupod sang tinapay nga may inugpahabok. Ang tambok sang sapat nga inyo ginhalad sa akon sa piesta indi ninyo pag-ibilin pagkaaga. ");
INSERT INTO hil_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Dal-a ninyo sa templo sang Ginoo nga inyo Dios ang pinakamaayo nga parte sang nahauna ninyo nga patubas. “Indi ninyo paglutua ang bataon nga kanding sa gatas sang iya iloy. ");
INSERT INTO hil_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Karon, ginapadala ko ang anghel sa pagbantay kag sa pagtuytoy sa inyo sa lugar nga ginpreparar ko. ");
INSERT INTO hil_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Pamati kamo sa iya kag tumana ang iya ginasiling. Indi kamo magrebelde sa iya. Kay ang tanan nga iya ginahimo, ginahimo niya sa akon ngalan kag indi niya pag-ibaliwala ang inyo mga sala. ");
INSERT INTO hil_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Kon magpamati lang kamo sing maayo sa iya ginasiling kag himuon ang tanan ko nga ginasiling, kontrahon ko ang inyo mga kaaway. ");
INSERT INTO hil_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Pangunahan kamo sang akon anghel kag dal-on niya kamo sa duta sang mga Amornon, Hithanon, Periznon, Canaanhon, Hivhanon, kag Jebusnon, kag pagalaglagon ko sila. ");
INSERT INTO hil_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Indi kamo magsimba ukon mag-alagad sa ila mga dios-dios, ukon magsunod sa ila mga ginahimo. Laglaga ninyo sing bug-os ang ila mga dios-dios, kag rumpaga ang ila handumanan nga mga bato. ");
INSERT INTO hil_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Simbaha ninyo ako, ang Ginoo nga inyo Dios, kag hatagan ko kamo sang bugana nga pagkaon kag tubig. Ayuhon ko ang inyo mga balatian, ");
INSERT INTO hil_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","kag wala sing babayi nga mahulugan ukon mabaw-as sa inyo duta, kag hatagan ko kamo sang malawig nga kabuhi. ");
INSERT INTO hil_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Pahadlukon ko kag pasalasalahon ang inyo mga kaaway nga inyo maatubang kag magapalalagyo sila. ");
INSERT INTO hil_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Magapadala ako sang mga alingayo nga magauna sa inyo, kag tabugon nila ang mga Hivhanon, Canaanhon, kag mga Hithanon. ");
INSERT INTO hil_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Pero indi ko sila pagtabugon sa sulod lang sang isa ka tuig para indi mangin mamingaw ang amo nga duta kag para indi magdamo ang talunon nga mga sapat didto. ");
INSERT INTO hil_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Tabugon ko sila sing amat-amat hasta nga magdamo kamo kag sarang na makapanag-iya sang duta. ");
INSERT INTO hil_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Siguraduhon ko nga ang border sang inyo mga duta maghalin sa Mapula nga Dagat hasta sa Dagat sang Mediteraneo, kag halin sa desierto sa south hasta sa Suba sang Euphrates. Itugyan ko sa inyo ang mga pumuluyo sang amo nga duta, kag tabugon ninyo sila. ");
INSERT INTO hil_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Indi kamo maghimo sang kasugtanan sa ila ukon sa ila mga dios-dios. ");
INSERT INTO hil_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Indi ninyo sila pagtuguti nga mag-estar sa inyo duta kay basi sila pa ang magtulod sa inyo sa pagpakasala sa akon. Kon magsimba kamo sa ila mga dios-dios, sigurado nga mangin siod ini sa inyo.” ");
INSERT INTO hil_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Dayon nagsiling ang Ginoo kay Moises, “Saka diri sa akon, kag upda si Aaron, Nadab, Abihu, kag ang 70 ka manugdumala sang Israel. Magsimba sila diri sa akon sa malayo-layo lang. ");
INSERT INTO hil_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ikaw lang Moises ang makapalapit sa akon, ang iban indi makapalapit. Kag ang mga tawo indi gid dapat magsaka diri upod sa imo.” ");
INSERT INTO hil_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Sang ginsugiran ni Moises ang mga tawo sang tanan nga gintudlo kag ginsugo sang Ginoo, nagsabat sila sing dungan, “Tumanon namon ang tanan nga ginsiling sang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Dayon ginsulat ni Moises ang tanan nga ginsiling sang Ginoo. Aga pa sang sunod nga adlaw, nagbangon si Moises kag nagpatindog sang halaran sa tiilan dampi sang bukid kag nagbutang siya sang dose ka handumanan nga bato nga nagarepresentar sang dose ka tribo sang Israel. ");
INSERT INTO hil_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Dayon nagsugo siya sang bataon nga mga lalaki nga maghalad sa Ginoo sang mga halad nga ginasunog kag maghalad man sang mga turo nga baka bilang halad nga para sa maayo nga relasyon. ");
INSERT INTO hil_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ginkuha ni Moises ang katunga sang dugo kag ginbutang ini sa mga yahong, kag ang katunga ginwisik niya sa halaran. ");
INSERT INTO hil_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Dayon ginkuha niya ang Libro sang Kasugtanan kag ginbasa ini sa mga tawo. Kag nagsabat ang mga tawo, “Tumanon namon ang tanan nga ginsiling sang Ginoo. Sundon namon siya.” ");
INSERT INTO hil_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Dayon ginkuha ni Moises ang dugo kag ginwisik ini sa mga tawo kag nagsiling, “Amo ini ang dugo nga nagapabakod sa kasugtanan nga ginhimo sang Ginoo sa inyo sang paghatag niya sining tanan nga sugo.” ");
INSERT INTO hil_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Nagsaka sa bukid si Moises, Aaron, Nadab, Abihu, kag ang 70 ka manugdumala sang Israel, ");
INSERT INTO hil_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","kag nakita nila ang Dios sang Israel. Sa iya tiilan daw may dalan nga hinimo halin sa bato nga sapiro nga pareho katin-aw sang langit. ");
INSERT INTO hil_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Bisan nakita sining mga pangulo ang Dios, wala sila pagpatya sang Dios. Nagkaon pa gani sila kag nag-inom didto sa presensya sang Dios. ");
INSERT INTO hil_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Dayon nagsiling ang Ginoo kay Moises, “Saka pa gid diri sa akon sa ibabaw sang bukid kag maghulat ka, kay ihatag ko sa imo ang malapad nga mga bato nga akon ginsulatan sang akon mga sugo kag mga pagpanudlo para sa mga tawo.” ");
INSERT INTO hil_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Gani nagsaka pa gid si Moises sa bukid sang Dios kaupod si Josue nga iya kabulig. ");
INSERT INTO hil_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Antes sila magsaka, nagsiling si Moises sa mga manugdumala sang Israel, “Hulata ninyo kami diri hasta makabalik kami. Mabilin diri sa inyo si Aaron kag si Hur, kag kon may problema kamo, kadto lang kamo sa ila.” ");
INSERT INTO hil_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Pag-abot ni Moises sa ibabaw pa gid sang bukid, gintabunan sang panganod ang bukid. ");
INSERT INTO hil_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Dayon ang gamhanan nga presensya sang Ginoo nagpanaog sa Bukid sang Sinai, kag sa sulod sang anom ka adlaw natabunan sang panganod ang bukid. Sang ikapito nga adlaw, gintawag sang Ginoo si Moises halin sa panganod. ");
INSERT INTO hil_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","18","Gani nagsulod si Moises sa panganod samtang nagapasaka pa gid siya sa bukid. Nagpabilin siya didto sa sulod sang 40 ka adlaw kag 40 ka gab-i. Para sa mga Israelinhon didto sa idalom, ang gamhanan nga presensya sang Ginoo sa ibabaw sang bukid pareho sa nagadabadaba nga kalayo. ");
INSERT INTO hil_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Silinga ang mga Israelinhon nga maghalad sila sa akon. Ikaw amo ang magbaton sang ila mga halad nga ila gusto ihalad sa akon. ");
INSERT INTO hil_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Amo ini ang mga halad nga imo batunon halin sa ila: bulawan, pilak, saway, ");
INSERT INTO hil_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","delana nga asol, granate kag pula, linen, panapton nga hinimo halin sa bulbol sang kanding, ");
INSERT INTO hil_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","panit sang karnero nga lalaki nga ginlugom sa pula, maayo nga klase sang panit, kahoy nga akasya, ");
INSERT INTO hil_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","lana sang olibo para sa suga, mga panakot para sa lana nga inughaplas kag para pahamot sa insenso, ");
INSERT INTO hil_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","kag bato nga onix kag iban pa nga malahalon nga mga bato nga inugtakod sa espesyal nga panaptonsang pangulo nga pari kag sa bulobulsa sa dughan sini. ");
INSERT INTO hil_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Kag pahimua ang katawhan sang Israel sang simbahan para sa akon nga sa diin makaestar ako upod sa ila. ");
INSERT INTO hil_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ipahimo ining Tolda nga Simbahan kag ang tanan nga kagamitan sini suno gid sa plano nga ipakita ko sa imo. ");
INSERT INTO hil_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Magpahimo ka sang Kahon nga akasya—45 inches ang kalabaon, 27 inches ang kasangkaron, kag 27 inches ang kataason. ");
INSERT INTO hil_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Pahaklapi ini sang puro nga bulawan sa sulod kag sa guwa, kag parebitihi sang bulawan ang mga kilid sini. ");
INSERT INTO hil_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Pahimui ini sang apat ka sulosingsing nga bulawan kag itakod sa iya apat ka tiil. ");
INSERT INTO hil_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Dayon magpahimo ka sang mga tukon nga akasya kag pahaklapi sang bulawan. ");
INSERT INTO hil_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Igulo ang mga tukon sa mga sulosingsing sa kada kilid sang Kahon para matuwangan ang Kahon. ");
INSERT INTO hil_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Indi gid pagkuhaon ang mga tukon sa sulosingsing sang Kahon. ");
INSERT INTO hil_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Dayon isulod sa Kahon ang malapad nga bato nga sa diin nasulat ang Kasuguan nga ihatag ko sa imo. ");
INSERT INTO hil_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Pahimui ini nga Kahon sang takop nga puro bulawan, nga 45 inches ang kalabaon kag 27 inches ang kasangkaron. ");
INSERT INTO hil_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Dayon magpahimo ka sang duha ka kerubin nga bulawan sa kada punta sang takop sang Kahon. Isaha lang sila ka pagporma sang takop sang Kahon. ");
INSERT INTO hil_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kinahanglan nga ang mga pakpak sang kerubin nagahumlad sa ibabaw sang takop para mahandungan nila ini, kag kinahanglan nga nagaatubangay sila nga duha kag nagatulok sa takop. ");
INSERT INTO hil_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Isulod sa Kahon ang malapad nga bato nga sa diin nasulat ang Kasuguan nga ihatag ko sa imo, kag takpan mo ang Kahon. ");
INSERT INTO hil_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Magapakigkita ako didto sa imo sa tunga sang duha ka kerubin nga ara sa ibabaw sang Kahon, kag ihatag ko sa imo ang tanan ko nga mga sugo para sa katawhan sang Israel. ");
INSERT INTO hil_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Magpahimo ka man sang lamisa nga akasya, nga 36 inches ang kalabaon, 18 inches ang kasangkaron, kag 27 inches ang kataason. ");
INSERT INTO hil_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Pahaklapi ini sang puro nga bulawan kag parebitihi sang bulawan ang mga kilid sini. ");
INSERT INTO hil_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Pabutangi man ini sang border sa kada kilid, nga 4 inches ang kasangkaron, kag parebitihi sang bulawan ang border. ");
INSERT INTO hil_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Dayon magpahimo ka sang apat ka sulosingsing nga bulawan kag itakod ini sa apat ka tiil sang lamisa, ");
INSERT INTO hil_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","malapit sa border. Diri ninyo igulo ang mga tukon nga pangtuwang sa lamisa. ");
INSERT INTO hil_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Dapat ini nga mga tukon akasya kag nahaklapan sang bulawan. ");
INSERT INTO hil_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","“Magpahimo ka man sang mga pinggan, mga tasa, mga tibod, kag mga yahong nga gamiton para sa mga halad nga ilimnon. Kinahanglan nga puro ini tanan bulawan. ");
INSERT INTO hil_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Kag kinahanglan butangan permi sang tinapay nga ginahalad sa akon presensya ato nga lamisa. ");
INSERT INTO hil_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Magpahimo ka man sang bulutangan sang suga nga puro bulawan ang iya tiil, lawas, kag dekorasyon nga mga bulak, nga ang iban bukol pa lang kag ang iban nagabuskad na. Ang dekorasyon naporma na nga daan upod sa lawas sang bulutangan sang suga sang pagkahimo sini. ");
INSERT INTO hil_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ang bulutangan sang suga dapat may anom ka sanga, tag-tatlo sa kada kilid. ");
INSERT INTO hil_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ang kada sanga may tatlo ka dekorasyon nga mga bulak nga ang korte daw almendro, nga ang iban bukol pa lang kag ang iban nagabuskad na. ");
INSERT INTO hil_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ang lawas sang bulutangan sang suga may apat ka dekorasyon nga mga bulak nga ang korte daw almendro man, nga ang iban bukol pa lang kag ang iban nagabuskad na. ");
INSERT INTO hil_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","May isa ka bulak sa idalom sang kada paris sang sanga. ");
INSERT INTO hil_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ang mga dekorasyon kag ang mga sanga naporma na nga daan upod sa lawas sang bulutangan sang suga sang pagkahimo sini. ");
INSERT INTO hil_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Dayon magpahimo ka sang pito ka suga kag ibutang sa sini nga bulutangan, kag iplastar mo ini nga masanagan ang lugar sa atubangan sini. ");
INSERT INTO hil_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ang mga kimpit kag mga inugsalod sa upos nga pabilo sang suga dapat puro man bulawan. ");
INSERT INTO hil_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Mga 35 ka kilo nga puro nga bulawan ang kinahanglan mo sa pagpahimo sang bulutangan sang suga kag sang tanan nga kagamitan sini. ");
INSERT INTO hil_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Siguraduha nga ipahimo mo ini tanan suno gid sa plano nga ginpakita ko sa imo diri sa bukid. ");
INSERT INTO hil_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Magpahimo ka sang Tolda nga Simbahan. Ang gamiton sa paghimo sini napulo ka panid nga linen nga ginbordahan sang delana nga asol, granate, kag pula. Kag paburdahi ini sing maayo sang dagway sang mga kerubin. ");
INSERT INTO hil_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Kinahanglan ang kada panid may kalabaon nga 42 feet kag may kasangkaron nga 6 feet. ");
INSERT INTO hil_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Tambihon ini sa tag-lima; bali duha ka tag-lima. ");
INSERT INTO hil_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Dayon pahimuan mo sang sulosingsing nga tela nga asol ang kilid sang katapusan nga panid sang tagsa ka tinambi nga mga tela; ");
INSERT INTO hil_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","tag-50 ka sulosingsing ang ibutang sa kada kilid kag kinahanglan nga nagaatubangay ini. ");
INSERT INTO hil_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Dayon magpahimo ka sang 50 ka kaw-it nga bulawan para matabid ang mga sulosingsing sang duha ka tinambi nga mga tela. Sa sini nga paagi mahimo ang Tolda nga Simbahan. ");
INSERT INTO hil_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Dayon pahimuan mo sang tabon ang Tolda. Ang gamiton sa paghimo sini onse ka panid nga tela nga hinimo halin sa bulbol sang kanding. ");
INSERT INTO hil_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Kinahanglan ang kada tela may kalabaon nga 45 feet kag may kasangkaron nga 6 feet. ");
INSERT INTO hil_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Tambihon ang lima ka tela, kag amo man ang nabilin nga anom. Ang ikaanom nga tela piluon sa atubangan sang Tolda. ");
INSERT INTO hil_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Pabutangi man sang 50 ka sulosingsing ang kilid sang katapusan nga panid sang tagsa ka tinambi nga mga tela, ");
INSERT INTO hil_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","kag tabidon ini sang 50 ka kaw-it nga saway. ");
INSERT INTO hil_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Paluyluyon sa likod sang Tolda ang katunga sang tela nga sobra, ");
INSERT INTO hil_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","kag paluyluyon man sa kada kilid ang 18 inches nga tela nga sobra sa pagtabon sang Tolda. ");
INSERT INTO hil_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ang ibabaw sang tabon sang Tolda pasampawi sang panit sang lalaki nga karnero nga ginlugom sa pula, kag pasampawi pa gid dayon sang maayo nga klase sang panit. ");
INSERT INTO hil_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Ang dingding sang Tolda dapat mga tapi nga akasya. ");
INSERT INTO hil_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ang kalabaon sang kada tapi 15 feet kag ang kasangkaron 2 feet. ");
INSERT INTO hil_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ang kada tapi butangan sang duha ka diladila para matabid ini sa isa pa ka tapi. Kinahanglan pareho sini ang himuon sa kada tapi. ");
INSERT INTO hil_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ang 20 sa sini nga mga tapi idingding sa parte sang Tolda nga nagaatubang sa south. ");
INSERT INTO hil_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ini nga mga tapi isuok sa 40 ka pundasyon nga pilak—duha ka pundasyon sa kada tapi. ");
INSERT INTO hil_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ang sa north sang Tolda dingdingan man sang 20 ka tapi ");
INSERT INTO hil_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","kag isuok man sa 40 ka pundasyon nga pilak—duha ka pundasyon sa kada tapi. ");
INSERT INTO hil_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ang sa west sang Tolda dingdingan sang anom ka tapi, ");
INSERT INTO hil_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","kag duha ka tapi sa mga corner sini. ");
INSERT INTO hil_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ini nga mga tapi sa mga corner natabid sing maayo sa idalom kag nahugot sa ibabaw paagi sa isa ka sulosingsing. Kinahanglan pareho gid sini ang himuon sa duha ka tapi sa mga corner. ");
INSERT INTO hil_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Gani may walo ka tapi sa sini nga parte sang Tolda, kag nasuok ini sa 16 ka pundasyon nga pilak—duha ka pundasyon sa kada tapi. ");
INSERT INTO hil_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Magpahimo ka man sang mga pangbalabag nga akasya para sa dingding—lima para sa parte sang Tolda nga nagaatubang sa north, ");
INSERT INTO hil_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","lima man sa south, kag lima pa gid sa west, sa likod sang Tolda. ");
INSERT INTO hil_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ang pangbalabag sa tunga-tunga sang dingding magahalin sa punta sang Tolda pakadto sa pihak nga punta. ");
INSERT INTO hil_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Pahaklapi sang bulawan ang mga tapi kag pabutangi ini sang mga sulosingsing nga bulawan nga amo ang gululuan sang mga pangbalabag. Pahaklapi man sang bulawan ang mga pangbalabag. ");
INSERT INTO hil_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Kinahanglan nga ipatukod mo ang Tolda nga Simbahan suno gid sa plano nga ginpakita ko sa imo diri sa bukid. ");
INSERT INTO hil_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Magpahimo ka man sang kurtina nga linen nga ginbordahan sang delana nga asol, granate kag pula. Kag paburdahi ini sing maayo sang dagway sang mga kerubin. ");
INSERT INTO hil_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ipakabit ini sa mga kaw-it nga bulawan sa apat ka haligi nga akasya nga nahaklapan sang bulawan. Ining apat ka haligi nasuok sa apat ka pundasyon nga pilak. ");
INSERT INTO hil_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Kon makabit na ang kurtina sa mga kaw-it, ibutang sa likod sini ang Kahon sang Kasuguan. Ang kurtina amo ang magaseparar sa Balaan nga Lugar sa Labing Balaan nga Lugar. ");
INSERT INTO hil_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ang Kahon sang Kasuguan dapat didto ibutang sa Labing Balaan nga Lugar kag dapat may takop ini. ");
INSERT INTO hil_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ibutang ang lamisa sa guwa sang kurtina sang Labing Balaan nga Lugar, sa north sang Tolda nga Simbahan, kag sa south, ibutang sa atubangan sang lamisa ang bulutangan sang suga. ");
INSERT INTO hil_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Magpahimo ka man sang isa pa ka kurtina para sa puwertahan sang Tolda nga Simbahan. Ang kurtina kinahanglan linen nga ginbordahan sang delana nga asol, granate kag pula. Kinahanglan maayo gid ang pagkaborda sini. ");
INSERT INTO hil_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Dayon ipakabit ini sa mga kaw-it nga bulawan sa lima ka haligi nga akasya nga nahaklapan sang bulawan. Ining lima ka haligi nasuok sa lima ka pundasyon nga saway.” ");
INSERT INTO hil_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Magpahimo ka sang kuwadrado nga halaran nga akasya. Ang iya kalabaon kag kasangkaron 7 feet kag 6 inches, kag ang kataason 4 feet kag 6 inches. ");
INSERT INTO hil_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Pabutangi ini sang mga sulosungay sa apat ka corner, nga naporma na nga daan upod sa halaran sang pagkahimo sini. Pahaklapi sang saway ang halaran. ");
INSERT INTO hil_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ang tanan nga kagamitan sang halaran kinahanglan hinimo man sa saway—ang bulutangan sang abo, mga pala, mga yahong, mga dako nga tinidor para sa karne, kag mga bulutangan sang baga. ");
INSERT INTO hil_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Magpahimo ka man sang parilyahan nga saway para sa halaran, kag pabutangi ini sang sulosingsing nga saway sa kada corner. ");
INSERT INTO hil_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Dayon ibutang ini sa sulod sang halaran sa idalom sang sagang, sa may tunga-tunga dampi halin sa ibabaw. ");
INSERT INTO hil_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Dayon magpahimo ka sang tukon nga pangtuwang sa halaran. Kinahanglan halin ini sa kahoy nga akasya, kag nahaklapan sang saway. ");
INSERT INTO hil_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Igulo ini nga tukon sa mga sulosingsing sa kada kilid sang halaran para matuwangan ang halaran. ");
INSERT INTO hil_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ang halaran nga ipahimo mo dapat tapi kag guhab ang sulod. Ipahimo ini suno sa plano nga ginpakita ko sa imo diri sa bukid. ");
INSERT INTO hil_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Pabutangi sang ugsaran ang Tolda nga Simbahan, kag palibuti ini sang mga dulodingding nga kurtina nga linen. Ang kalabaon sang kurtina sa south 150 feet. ");
INSERT INTO hil_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Itakod ini nga kurtina sa 20 ka haligi nga saway nga nasuok sa 20 man ka pundasyon nga saway. Ang kabitan sang kurtina amo ang mga kaw-it nga pilak nga nagakabit sa mga kabilya nga pilak sa mga haligi. ");
INSERT INTO hil_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ang kurtina sa north 150 feet man ang kalabaon. Itakod man ini sa 20 ka haligi nga saway nga nasuok sa 20 ka pundasyon nga saway. Ang kabitan sang kurtina amo ang mga kaw-it nga pilak nga nagakabit sa mga kabilya nga pilak sa mga haligi. ");
INSERT INTO hil_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Ang kurtina sa west 75 feet ang kalabaon, kag natakod ini sa napulo ka haligi nga nasuok sa napulo man ka pundasyon. ");
INSERT INTO hil_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ang sa east sang ugsaran 75 feet man ang kalabaon. ");
INSERT INTO hil_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ang dulodingding nga kurtina sa tuo sang puwertahan 22 feet kag 6 inches ang kalabaon, kag natakod ini sa tatlo ka haligi nga nasuok sa tatlo man ka pundasyon. ");
INSERT INTO hil_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ang kurtina sa wala 22 feet kag 6 inches man ang kalabaon, kag natakod man ini sa tatlo ka haligi nga nasuok sa tatlo man ka pundasyon. ");
INSERT INTO hil_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ang puwertahan mismo sang ugsaran pabutangi sang kurtina nga 30 feet ang kalabaon. Ang kurtina kinahanglan linen nga ginbordahan sang delana nga asol, granate kag pula. Kinahanglan nga maayo gid ang pagkaborda sini. Dayon itakod ang kurtina sa apat ka haligi nga nasuok sa apat ka pundasyon. ");
INSERT INTO hil_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Kinahanglan ang tanan nga haligi sa palibot sang ugsaran may mga kaw-it kag mga kabilya nga pilak, kag may mga pundasyon nga saway. ");
INSERT INTO hil_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","“Gani ang bilog nga ugsaran may kalabaon nga 150 feet kag may kasangkaron nga 75 feet. Napalibutan ini sang kurtina nga linen, nga ang kataason 7 feet kag 6 inches. Ang mga haligi sini nasuok sa mga pundasyon nga saway. ");
INSERT INTO hil_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Kinahanglan puro saway ang tanan nga kagamitan sa Tolda nga Simbahan pati ang tanan nga palpal para sa pagbanting sang Tolda kag sang mga kurtina sang ugsaran sini. ");
INSERT INTO hil_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Sugua ang mga Israelinhon nga dal-an ka nila sang puro nga lana sang olibo nga ginbayo para sa mga suga sang Tolda, para magasiga ini permi. ");
INSERT INTO hil_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ang bulutangan sang suga ibutang sa guwa sang kurtina nga nagatabon sa Kahon sang Kasuguan. Si Aaron kag ang iya mga kaliwat amo ang mag-atipan sang mga suga sang Tolda nga Ginapakigkitaan. Pasigahon nila ini sa akon presensya aga kag gab-i. Ini nga pagsulundan dapat tumanon sang mga Israelinhon hasta sa palaabuton nga mga henerasyon. ");
INSERT INTO hil_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Iseparar mo sa mga tawo si Aaron nga imo utod kag ang iya mga anak nga lalaki nga sila ni Nadab, Abihu, Eleazar, kag Itamar, para mag-alagad sa akon bilang mga pari. ");
INSERT INTO hil_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Magpatahi ka sang balaan nga mga panapton para kay Aaron para mapadunggan siya. ");
INSERT INTO hil_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Silinga ang tanan nga maayo nga mga sastre, nga ginhatagan ko sang abilidad sa pagpanahi, nga tahian nila sang mga panapton si Aaron nga magaseparar sa iya sa mga tawo para mag-alagad sa akon bilang pari. ");
INSERT INTO hil_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Amo ini ang mga panapton nga ila tahion: ang bulobulsa sa dughan, ang espesyal nga panapton, ang pangguwa nga bayo, ang pangsulod nga bayo nga binordahan, ang turban, kag ang wagkos. Tahion nila ini para kay Aaron, pati man sa iya mga anak nga lalaki, para makaalagad sila sa akon bilang mga pari. ");
INSERT INTO hil_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Kinahanglan ang tela nga ila gamiton linen nga ginbordahan sang bulawan nga hilo kag delana nga asol, granate kag pula. ");
INSERT INTO hil_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Ang espesyal nga panapton sang mga pari kinahanglan linen nga ginbordahan sang bulawan nga hilo kag delana nga asol, granate kag pula. Kinahanglan nga maayo gid ang pagkaborda sini. ");
INSERT INTO hil_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","May duha ini ka parte, likod kag atubang, kag nasugpon ini sa duha ka strap sa may abaga. ");
INSERT INTO hil_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ang wagkos sini linen man nga ginbordahan sang bulawan nga hilo kag delana nga asol, granate kag pula. ");
INSERT INTO hil_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Dayon magkuha ka sang duha ka bato nga onix kag painggrebi ini sang mga ngalan sang mga anak nga lalaki ni Jacob. ");
INSERT INTO hil_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Dapat pasunod ang pagbutang sang mga ngalan suno sa ila pagkatawo, kag anom ka ngalan sa kada bato. ");
INSERT INTO hil_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Dapat ang pag-inggreb sini pareho sa pag-inggreb sang platero sa pangmarka. Dayon ibutang ang mga bato sa mga bulutangan nga bulawan ");
INSERT INTO hil_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","kag itakod ini sa strap sang espesyal nga panapton bilang handumanan nga mga bato para sa mga tribo sang Israel. Sa sini nga paagi madala permi ni Aaron ang ila mga ngalan sa akon presensya, kag dumdumon ko sila. ");
INSERT INTO hil_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ang mga bulutangan nga bulawan ");
INSERT INTO hil_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","pabutangi sang duha ka kulokadena nga puro bulawan para matakod sa may abaga sang panapton. ");
INSERT INTO hil_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Magpahimo ka sang bulobulsa sa dughan nga ginagamit sa paghibalo sang akon kabubut-on. Kinahanglan maayo gid ang pagkahimo sini, kag ang tela sini dapat pareho man sa tela sang espesyal nga panapton sang mga pari: linen nga ginbordahan sang bulawan nga hilo kag delana nga asol, granate kag pula. ");
INSERT INTO hil_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ining bulobulsa sa dughan dapat napilo sing doble kag kuwadrado—9 inches ang kalabaon kag ang kasangkaron. ");
INSERT INTO hil_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Patakdi ini sang apat ka raya sang malahalon nga mga bato. Sa nahauna nga raya, ibutang ang rubi, topas, kag beril; ");
INSERT INTO hil_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","sa ikaduha nga raya, turquiso, sapiro, kag emeralda; ");
INSERT INTO hil_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","sa ikatatlo nga raya, hasinto, agate, kag ametist; ");
INSERT INTO hil_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","kag sa ikaapat nga raya, krisolito, onix, kag jasper. Dapat natakod ang mga bato sa mga bulutangan nga bulawan. ");
INSERT INTO hil_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ang kada bato dapat may ngalan sang mga anak ni Jacob sa pagrepresentar sang dose ka tribo sang Israel. Ang pag-inggreb sang mga ngalan dapat pareho sa pag-inggreb sang pangmarka. ");
INSERT INTO hil_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Pabutangi man sang kulokadena nga puro bulawan ang bulobulsa sa dughan. ");
INSERT INTO hil_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Dayon magpahimo ka sang duha ka sulosingsing nga bulawan kag iangot ini sa ibabaw nga mga corner sang bulobulsa sa dughan. ");
INSERT INTO hil_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Iangot ang duha ka kulokadena nga bulawan sa sulosingsing sang bulobulsa sa dughan, ");
INSERT INTO hil_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","kag ang duha ka punta sang kulokadena iangot sa duha ka bulutangan nga bulawan nga nagatapik sa strap sang espesyal nga panapton. ");
INSERT INTO hil_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Magpahimo ka pa sang duha ka sulosingsing nga bulawan, kag iangot ini sa idalom nga mga corner sang bulobulsa sa dughan nga nagasampaw sa espesyal nga panapton. ");
INSERT INTO hil_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Magpahimo ka pa gid sang duha ka sulosingsing nga bulawan kag iangot ini sa espesyal nga panapton sa may wagkos dampi. ");
INSERT INTO hil_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Dayon tabiron ninyo sang asol nga higot ang idalom nga mga sulosingsing sang bulobulsa sa dughan kag ang mga sulosingsing sang espesyal nga panapton. Sa sini nga paagi matabid sing maayo ang bulobulsa sa dughan sa espesyal nga panapton. ");
INSERT INTO hil_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Kon magsulod si Aaron sa Balaan nga Lugar kinahanglan isuksok niya ang ini nga bulobulsa sa dughan nga may mga ngalan sang mga tribo sang Israel para dumdumon ko sila permi. ");
INSERT INTO hil_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ibutang sa bulobulsa sa dughan ang Urim kag Thumim para ara ini sa dughan ni Aaron kon magkadto siya sa akon presensya. Gani dal-on permi ni Aaron ining duha ka butang kon magkadto siya sa akon presensya para mahibaluan niya ang akon kabubut-on para sa mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Ang pangguwa nga bayo nga nasampawan sang espesyal nga panapton kinahanglan puro asol ");
INSERT INTO hil_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","kag may buho sa tunga para sa ulo. Kag kinahanglan ang liab may kulokwelyo para indi ini magisi. ");
INSERT INTO hil_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Pakabiti ang palibot sang sidsid sang bayo sang mga puloprutas nga pomegranata, nga hinimo halin sa delana nga asol, granate, kag pula. Bal-utan mo ini nga mga dekorasyon sang mga lingga-lingganay nga bulawan. ");
INSERT INTO hil_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Kinahanglan nga isuksok ni Aaron ining pangguwa nga bayo kon magsulod siya sa Balaan nga Lugar sa pag-alagad sa akon presensya, para mabatian ang kilingkiling sang mga lingga-lingganay kon magsulod kag magguwa si Aaron sa Balaan nga Lugar. Kon himuon niya ini, indi siya mapatay. ");
INSERT INTO hil_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Magpahimo ka sang medalya nga puro bulawan kag painggrebi ini sang sini nga mga pulong: ginseparar para sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","38","Itapik ini sa atubangan sang turban ni Aaron paagi sa asol nga higot, para makita ini sa iya agtang. Ini magapakita nga pagadal-on ni Aaron ang bisan ano nga sala nga nahimo sang mga Israelinhon sa ila paghalad sa Ginoo. Itakod ini permi ni Aaron sa iya agtang para malipay ang Ginoo sa ila. ");
INSERT INTO hil_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Ang pangsulod nga bayo ni Aaron kinahanglan linen, kag amo man ang iya turban. Ang wagkos dapat ginbordahan sing maayo. ");
INSERT INTO hil_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Magpatahi ka man sang mga pangsulod nga bayo, mga wagkos, kag mga turban sa mga anak ni Aaron sa pagpadungog sa ila. ");
INSERT INTO hil_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","“Ipasuksok mo ini nga mga panapton sa imo utod nga si Aaron kag sa iya mga anak nga lalaki, kag dayon haplasan mo sila sang lana kag ordinahan. Idedikar sila sa akon para makaalagad sila sa akon bilang mga pari. ");
INSERT INTO hil_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Patahian mo man sila sang mga pang-idalom nga panapton nga linen, nga magatabon sang ila kinatawo. Ang kalabaon sini halin sa hawak hasta sa paa. ");
INSERT INTO hil_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Kinahanglan nga isuksok nila ini kon magsulod sila sa Tolda nga Ginapakigkitaan, ukon kon magpalapit sila sa halaran sa Balaan nga Lugar sa pag-alagad bilang mga pari, para indi sila makasala kag mapatay. Ini nga pagsulundan dapat tumanon ni Aaron kag sang iya mga kaliwat hasta san-o. ");
INSERT INTO hil_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Amo ini ang himuon mo sa pagdedikar kay Aaron kag sa iya mga anak nga lalaki para makaalagad sila sa akon bilang mga pari. Magkuha ka sang bataon nga baka kag duha ka lalaki nga karnero nga wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Magkuha ka man sang maayo nga klase nga harina kag magluto sang tinapay nga wala sing inugpahabok. Ang tinapay nga lutuon mo, tinapay nga wala sing mantika, tinapay nga madamol nga ginmikslahan sang mantika, kag tinapay nga manipis nga ginlamhitan sang mantika. ");
INSERT INTO hil_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Isulod mo dayon ini nga mga tinapay sa basket kag dal-on sa akon upod sang bataon nga baka kag sang duha ka karnero nga lalaki. ");
INSERT INTO hil_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Dal-a dayon si Aaron kag ang iya mga anak nga lalaki didto sa puwertahan sang Tolda nga Ginapakigkitaan, kag papaligua sila. ");
INSERT INTO hil_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Dayon ipasuksok kay Aaron ang iya pangsulod nga bayo, ang pangguwa nga bayo, ang espesyal nga panapton, kag ang bulobulsa sa dughan. Hugta sa iya hawak ang espesyal nga panapton paagi sa wagkos nga maayo ang pagkahimo. ");
INSERT INTO hil_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ipasuksok sa iya ulo ang turban, kag ipatakod sa atubangan sang turban ang medalya nga simbolo nga ginseparar siya para sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Kuhaa dayon ang lana nga inughaplas kag ibubo sa ulo ni Aaron sa pagdedikar sa iya. ");
INSERT INTO hil_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Idedikar man ang iya mga anak nga lalaki kag pasuksuka man sila sang pangsulod nga bayo, ");
INSERT INTO hil_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","turban, kag wagkos. Mangin pari sila hasta san-o. Sa sini nga paagi ordinahan mo si Aaron kag ang iya mga anak. ");
INSERT INTO hil_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Dal-a ang bataon nga baka sa atubangan sang Tolda nga Ginapakigkitaan, kag ipatungtong ang mga kamot ni Aaron kag sang iya mga anak sa ulo sang baka. ");
INSERT INTO hil_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Dayon ihawa ang baka sa akon presensya, didto dampi sa puwertahan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Magkuha ka sang dugo sang baka kag ilamhit ini sa mga sulosungay sa mga corner sang halaran, kag ang mabilin nga dugo iula sa idalom sang halaran. ");
INSERT INTO hil_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Dayon kuhaa ang tanan nga sapay sa kasudlan sang baka, ang gamay nga parte sang atay, kag ang mga batobato pati ang mga tambok sini, kag sunuga ini sa halaran. ");
INSERT INTO hil_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Pero ang iya unod, panit, kag tinai sunugon mo sa guwa sang kampo. Halad ini sa pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Dayon kuhaa ang isa ka lalaki nga karnero kag ipatungtong ang mga kamot ni Aaron kag sang iya mga anak sa ulo sang karnero. ");
INSERT INTO hil_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Dayon ihawa ini, kag iwisik-wisik ang dugo sini sa palibot sang halaran. ");
INSERT INTO hil_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Hiwa-hiwaa ang karnero kag hugasi ang mga parte sang sulod sang tiyan kag ang mga tiil, kag tipuna ini pati ang ulo kag ang iban pa nga mga parte sang sapat. ");
INSERT INTO hil_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Dayon sunuga ini tanan sa halaran bilang halad nga ginasunog para sa akon. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa akon. ");
INSERT INTO hil_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Dayon kuhaa ang isa pa ka lalaki nga karnero, kag ipatungtong ang mga kamot ni Aaron kag sang iya mga anak sa ulo sang karnero. ");
INSERT INTO hil_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Dayon ihawa ini, kag kuhaa ang iban nga dugo sini kag ilamhit sa idalom nga parte sang tuo nga dulunggan ni Aaron kag sang iya mga anak, kag sa mga kumalagko sang ila tuo nga kamot kag tuo nga tiil. Dayon iwisik-wisik ang dugo sa palibot sang halaran. ");
INSERT INTO hil_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Kuhaa ang iban nga dugo sa halaran kag imiksla ini sa lana nga inughaplas, kag dayon iwisik-wisik kay Aaron kag sa iya mga anak kag sa ila mga bayo. Sa sini nga paagi madedikar si Aaron kag ang iya mga anak, pati ang ila mga bayo. ");
INSERT INTO hil_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Dayon kuhaa ang mga tambok sang karnero, ang matambok nga ikog, ang mga sapay sa kasudlan, ang gamay nga parte sang atay, ang mga batobato pati ang mga tambok sini, kag ang tuo nga paa. Amo ini ang karnero nga halad para sa ordinasyon sang mga pari. ");
INSERT INTO hil_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Magkuha ka sa basket sang tig-isa ka klase sang mga tinapay nga wala sing inugpahabok nga ginhalad sa akon: tinapay nga wala sing mantika, tinapay nga madamol nga ginmikslahan sang mantika, kag tinapay nga manipis. ");
INSERT INTO hil_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Pauyati ini tanan kay Aaron kag sa iya mga anak kag ibayaw nila ini sa akon bilang halad nga ginabayaw. ");
INSERT INTO hil_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Dayon kuhaa ini sa ila kag sunuga sa halaran upod sa halad nga ginasunog. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa akon. ");
INSERT INTO hil_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Dayon kuhaa ang dughan sang karnero kag ibayaw ini sa akon bilang halad nga ginabayaw. Amo ini ang imo parte sa karnero nga halad para sa ordinasyon ni Aaron kag sang iya mga anak. ");
INSERT INTO hil_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Idedikar sa akon ang mga parte sang karnero nga halad para sa ordinasyon ni Aaron kag sang iya mga anak, lakip na diri ang dughan kag paa nga ginbayaw sa akon. ");
INSERT INTO hil_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Sa kada halad sa akon sang mga Israelinhon sang mga halad nga para sa maayo nga relasyon, amo gid ini permi ang mga parte sang sapat nga ibahin sa ila ni Aaron kag sang iya mga anak. ");
INSERT INTO hil_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Kon mapatay na si Aaron, ang iya balaan nga mga bayo ihatag sa tagsa niya ka kaliwat nga magabulos sa iya bilang pangulo nga pari, para ila ini suksukon kon ordinahan sila paagi sa paghaplas sang lana sa ila. ");
INSERT INTO hil_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ang kaliwat ni Aaron nga magabulos sa iya bilang pangulo nga pari magasuksok sini nga mga bayo sa sulod sang pito ka adlaw kon magsulod siya sa Tolda nga Ginapakigkitaan sa pag-alagad sa Balaan nga Lugar. ");
INSERT INTO hil_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Kuhaa ang karnero nga ginhalad sa pag-ordinar kag lutua ang karne sini sa isa ka balaan nga lugar. ");
INSERT INTO hil_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Kaunon ini ni Aaron kag sang iya mga anak, lakip ang mga tinapay sa basket, dira sa puwertahan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Sila lang ang makakaon sini nga karne kag tinapay nga ginhalad para matubos sila sa ila nga sala sang gin-ordinahan sila. Wala sing iban nga magkaon sini upod sa ila kay ini nga mga pagkaon para lang gid sa ila. ");
INSERT INTO hil_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kon may mabilin sini nga pagkaon pagkaaga, dapat sunugon ini. Indi gid ini pagkaunon, kay para lang ini sa mga pari. ");
INSERT INTO hil_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Sundon mo ining mga ginsugo ko sa imo parte sa pag-ordinar kay Aaron kag sa iya mga anak. Himua ang pag-ordinar sa ila sa sulod sang pito ka adlaw. ");
INSERT INTO hil_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kada adlaw maghalad ka sing isa ka baka bilang halad sa pagpakatinlo para mangin matinlo ang halaran, kag dayon haplasan mo ang halaran sang lana sa pagdedikar sini. ");
INSERT INTO hil_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Himuon mo ini sa sulod sang pito ka adlaw; kag dayon mangin balaan gid ang halaran, kag dapat balaan man ang nagauyat sini. ");
INSERT INTO hil_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Ang imo ihalad sa halaran adlaw-adlaw duha ka karnero nga isa ka tuig ang edad. ");
INSERT INTO hil_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Isa sa aga kag isa sa hapon. ");
INSERT INTO hil_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Sa imo paghalad sang karnero sa aga, maghalad ka man sing duha ka kilo nga harina nga maayo nga klase. Mikslahan mo ini sang isa ka litro nga mantika nga halin sa olibo nga ginbayo. Maghalad ka man sang mga isa ka litro nga duga sang ubas bilang halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Sa imo paghalad sang karnero sa hapon, maghalad ka man sang pareho gihapon nga mga halad nga harina kag ilimnon. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa akon. ");
INSERT INTO hil_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","43","Ini nga halad nga ginasunog kinahanglan ihalad adlaw-adlaw hasta sa palaabuton nga mga henerasyon. Ihalad ninyo ini sa akon presensya, didto dampi sa puwertahan sang Tolda nga Ginapakigkitaan nga sa diin magapakighambal ako sa imo kag magapakigkita ako sa mga Israelinhon. Kag ang ini nga Tolda mangin balaan tungod sang akon gamhanan nga presensya. ");
INSERT INTO hil_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Himuon ko nga balaan ang Tolda nga Ginapakigkitaan kag ang halaran, kag iseparar ko si Aaron kag ang iya mga anak sa pag-alagad sa akon bilang mga pari. ");
INSERT INTO hil_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Magapuyo ako upod sa mga Israelinhon kag ako mangin ila Dios. ");
INSERT INTO hil_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Mahibaluan nila nga ako amo ang Ginoo nga ila Dios nga nagpaguwa sa ila sa Egypt para magpuyo ako upod sa ila. Huo, ako amo ang Ginoo nga ila Dios. ");
INSERT INTO hil_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Magpahimo ka sang halaran nga akasya nga sulunugan sang insenso. ");
INSERT INTO hil_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kinahanglan nga kuwadrado ini—18 inches ang kalabaon kag ang kasangkaron, kag 36 inches ang kataason. Kinahanglan may ara ini sang mga sulosungay nga naporma na nga daan upod sa halaran sang pagkahimo sini. ");
INSERT INTO hil_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Pahaklapan mo sang puro nga bulawan ang ibabaw sini, ang apat ka kilid, kag ang mga sulosungay sini. Kag rebitihi ini sang bulawan sa palibot. ");
INSERT INTO hil_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Pabutangi sang duha ka sulosingsing nga bulawan sa idalom sang rebiti sa pihak kag pihak sang halaran, para gululuan sang mga tukon nga pangtuwang sini. ");
INSERT INTO hil_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Kinahanglan ang tukon kahoy nga akasya kag nahaklapan sang bulawan. ");
INSERT INTO hil_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ibutang ini nga halaran sa atubangan sang kurtina nga nagatabon sa Kahon sang Kasuguan. Dira ako magapakigkita sa inyo. ");
INSERT INTO hil_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Kada aga, kon mag-asikaso si Aaron sang mga suga, magsunog siya sang mahamot nga insenso sa sina nga halaran. ");
INSERT INTO hil_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Kag kon hapon, kon magsindi siya sang mga suga, magsunog siya liwat. Dapat himuon ini adlaw-adlaw hasta sa palaabuton nga mga henerasyon. ");
INSERT INTO hil_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Indi kamo maghalad sa sini nga halaran sang iban nga insenso ukon bisan ano nga halad nga ginasunog, ukon halad nga regalo, ukon halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Isa ka bes kada tuig, kinahanglan tinluan ni Aaron ang halaran paagi sa paglamhit sang dugo sa mga sulosungay sini. Ang dugo nga ilamhit magahalin sa halad sa pagpakatinlo. Dapat himuon ini kada tuig hasta sa palaabuton nga mga henerasyon, kay ang ini nga halaran balaan gid para sa akon.” ");
INSERT INTO hil_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Dayon nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Kon mag-census ka sa katawhan sang Israel, ang tagsa nga ma-census magbayad sa akon para sa iya kabuhi, para wala sing kahalitan nga mag-abot sa ila samtang gina-census mo sila. ");
INSERT INTO hil_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ang ibayad sang kada isa nga ma-census anom ka gramo nga pilak suno sa kilohan sang mga pari. Ihatag nila ini bilang halad sa akon. ");
INSERT INTO hil_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ang tanan nga nagaedad 20 ka tuig paibabaw amo ang maghatag sini sa akon. ");
INSERT INTO hil_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ang manggaranon indi magbayad sing sobra, kag ang imol indi magbayad sing kulang. ");
INSERT INTO hil_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Gamita ini nga kuwarta para sa buluhaton sa Tolda nga Ginapakigkitaan. Bayad ini sang mga Israelinhon para sa ila kabuhi, kag paagi sini dumdumon ko sila.” ");
INSERT INTO hil_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Dayon nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Maghimo ka sang saway nga labador nga may saway man nga tulungtungan, para gamiton nga hulugasan. Ibutang mo ini sa tunga-tunga sang Tolda nga Ginapakigkitaan kag sang halaran, kag sudli ini sang tubig. ");
INSERT INTO hil_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Amo ini ang gamiton ni Aaron kag sang iya mga anak nga lalaki sa paghugas sang ila mga kamot kag tiil, ");
INSERT INTO hil_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","21","antes sila magsulod sa Tolda nga Ginapakigkitaan, kag antes sila magpalapit sa halaran sa paghalad sa akon sang halad nga paagi sa kalayo. Kinahanglan nga hugasan gid nila ang ila mga kamot kag tiil para indi sila mapatay. Ini nga pagsulundan dapat tumanon ni Aaron kag sang iya mga kaliwat sa palaabuton nga mga henerasyon.” ");
INSERT INTO hil_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Dayon nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Magkuha ka sang pinakamaayo nga mga panakot: anom ka kilo nga mira, tatlo ka kilo nga mahamot nga sinamon, tatlo ka kilo nga mahamot nga calamus, ");
INSERT INTO hil_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","anom ka kilo nga cassia (dapat ang mga kabug-aton sini suno sa kilohan sang mga pari), kag isa ka galon nga lana sang olibo. ");
INSERT INTO hil_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Paagi sini maghimo ka sang balaan nga lana nga inughaplas nga mahamot gid. ");
INSERT INTO hil_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","28","Haplasan mo sang sini nga lana ang Tolda nga Ginapakigkitaan, ang Kahon sang Kasuguan, ang lamisa kag ang tanan nga kagamitan sini, ang bulutangan sang suga kag ang tanan nga kagamitan sini, ang halaran nga sulunugan sang insenso, ang halaran sang halad nga ginasunog kag ang tanan man nga kagamitan sini, kag ang labador kag ang iya tulungtungan. ");
INSERT INTO hil_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Idedikar mo ini nga mga butang para mangin balaan gid ini; kag dapat balaan man ang nagauyat sini. ");
INSERT INTO hil_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Haplasi man sang lana si Aaron kag ang iya mga anak bilang pagdedikar sa ila, para makaalagad sila sa akon bilang mga pari. ");
INSERT INTO hil_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Silinga ang mga Israelinhon nga amo ini ang akon balaan nga lana nga inughaplas hasta sa palaabuton nga mga henerasyon. ");
INSERT INTO hil_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Indi ninyo ini pag-ibubo sa ordinaryo nga mga tawo, kag indi man kamo maghimo sang pareho sini nga lana para sa inyo kaugalingon. Balaan ini, gani kabiga ninyo ini nga balaan. ");
INSERT INTO hil_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ang bisan sin-o nga maghimo sang pareho sini ukon maggamit sini sa kay bisan sin-o nga indi pari, indi na ninyo pagkabigon nga sakop ninyo.” ");
INSERT INTO hil_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Dayon nagsiling ang Ginoo kay Moises, “Magkuha ka sang sining mahamot nga mga panakot nga pareho tanan ang ila kadamuon: estakte, onika, galbano kag puro nga kamangyan. ");
INSERT INTO hil_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Paagi sini maghimo ka sang insenso nga mahamot gid. Dayon asini ini para mangin puraw ini kag balaan. ");
INSERT INTO hil_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Bukbuka sing mapino ang iban sini kag iwisik-wisik sa atubangan sang Kahon sang Kasuguan nga ara sa Tolda nga Ginapakigkitaan, nga sa diin magapakigkita ako sa imo. Dapat kabigon mo ini nga balaan gid. ");
INSERT INTO hil_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Indi kamo maghimo sang sini nga insenso para sa inyo kaugalingon. Kabiga ini nga balaan para sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ang bisan sin-o nga maghimo sini nga iya gamiton nga pahamot indi na ninyo pagkabigon nga sakop ninyo.” ");
INSERT INTO hil_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Dayon nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ginpili ko si Bezalel, nga anak ni Uri kag apo ni Hur, nga halin sa tribo ni Juda. ");
INSERT INTO hil_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Gin-gamhan ko siya sang akon Espiritu kag ginhatagan sang kaalam kag abilidad sa bisan ano nga buluhaton— ");
INSERT INTO hil_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","sa paghimo sang matahom nga mga butang nga bulawan, pilak, kag saway, ");
INSERT INTO hil_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","sa pagporma sang malahalon nga mga bato nga inugtampok, sa pagkorte sang kahoy, kag sang tanan nga klase sang buluhaton. ");
INSERT INTO hil_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ginpili ko man si Oholiab nga anak ni Ahisamac, nga halin sa tribo ni Dan, sa pagbulig kay Bezalel. Ginhatagan ko man sang abilidad ang tanan nga maayo nga mga panday para mahimo nila ang tanan nga ginsugo ko sa imo nga himuon: ");
INSERT INTO hil_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“ang Tolda nga Ginapakigkitaan, ang Kahon sang Kasuguan kag ang tabon sini, kag ang tanan nga kagamitan sa Tolda— ");
INSERT INTO hil_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ang lamisa kag ang mga kagamitan sini, ang bulutangan sang suga nga puro bulawan kag ang tanan man nga kagamitan sini, ang halaran nga sulunugan sang insenso, ");
INSERT INTO hil_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ang halaran sang halad nga ginasunog kag ang tanan nga kagamitan sini, ang labador kag ang iya tulungtungan— ");
INSERT INTO hil_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ang matahom kag balaan nga mga panapton ni Aaron kag sang iya mga anak nga suksukon nila kon mag-alagad sila bilang mga pari, ");
INSERT INTO hil_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ang lana nga inughaplas, kag ang mahamot nga insenso para sa Balaan nga Lugar. “Himuon nila ini tanan suno sa ginsugo ko sa imo.” ");
INSERT INTO hil_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Dayon nagsugo ang Ginoo kay Moises ");
INSERT INTO hil_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","nga ihambal niya ini sa mga Israelinhon: “Tumana gid ninyo ang akon mga ginapahimo parte sa Adlaw nga Inugpahuway, kay tanda ini sang aton kasugtanan hasta sa palaabuton nga mga henerasyon. Sa sini nga paagi mahibaluan ninyo nga ako amo ang Ginoo nga nagpili sa inyo nga mangin akon katawhan. ");
INSERT INTO hil_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Tumana ninyo ang akon mga ginapahimo sa Adlaw nga Inugpahuway, kay balaan ini nga adlaw para sa inyo. Ang bisan sin-o nga wala nagasunod dapat gid nga patyon. Ang bisan sin-o nga mag-obra sa sina nga adlaw indi na ninyo pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Obraha ninyo ang inyo buluhaton sa sulod sang anom ka adlaw, pero sa ikapito nga adlaw, magpahuway gid kamo. Tungod nga ini nga adlaw balaan para sa akon, ang bisan sin-o nga mag-obra sa sini nga adlaw dapat gid nga patyon. ");
INSERT INTO hil_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","17","Gani kamo nga mga Israelinhon, dapat tumanon ninyo ang akon mga ginapatuman sa Adlaw nga Inugpahuway hasta sa palaabuton nga mga henerasyon. Ini amo ang permanente nga tanda sang aton wala sing katapusan nga kasugtanan. Kay sa sulod sang anom ka adlaw ginhimo ko ang kalangitan kag ang kalibutan, kag sa ikapito nga adlaw nagpahuway ako.” ");
INSERT INTO hil_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Pagkatapos estorya sang Ginoo kay Moises sa Bukid sang Sinai, ginhatag niya kay Moises ang duha ka malapad nga bato nga ginsulatan niya mismo sang Kasuguan. ");
INSERT INTO hil_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Sang matalupangdan sang mga tawo nga kadugay kay Moises magpanaog sa bukid, nagtipon sila kay Aaron kag nagsiling, “Sige na! Himui kami sang dios nga magapanguna sa amon, tungod nga wala kita kahibalo kon ano na ang natabo sining tawo nga si Moises nga nagpaguwa sa aton sa Egypt.” ");
INSERT INTO hil_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Nagsabat si Aaron sa ila, “Panguhaa ninyo ang bulawan nga mga aritos nga ginasuksok sang inyo mga asawa kag mga anak, kag dal-a ninyo diri sa akon.” ");
INSERT INTO hil_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Gani ginpanguha nila tanan ang ila bulawan nga mga aritos kag gindala kay Aaron. ");
INSERT INTO hil_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Gintipon ini ni Aaron kag gintunaw kag ginporma nga baka. Nagsiling dayon ang mga Israelinhon, “Amo ini ang aton dios nga nagpaguwa sa aton sa Egypt.” ");
INSERT INTO hil_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Pagkakita ni Aaron nga nalipay gid ang mga tawo, nagpahimo siya sang halaran sa atubangan sang baka kag nagpahibalo, “Buwas magasaulog kita sang piesta para sa kadungganan sangGinoo.” ");
INSERT INTO hil_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Gani pagkaaga, aga pa gid nagbangon ang mga tawo kag naghalad sang mga halad nga ginasunog kag halad nga para sa maayo nga relasyon. Kag nagkinaon sila kag nag-ininom, kag nagpagusto pangalipay sa ila pagsimba sa dios-dios. ");
INSERT INTO hil_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Nagsiling ang Ginoo kay Moises, “Magpanaog ka gilayon kay ang imo katawhan nga ginpaguwa mo sa Egypt nagahimo sang kalautan. ");
INSERT INTO hil_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Kadali lang sa ila maglapas sa akon mga ginmando sa ila. Naghimo sila sang ila dios-dios nga baka kag ginsimba ini. Naghalad ang mga Israelinhon sa sini nga dios-dios kag nagsiling, ‘Amo ini ang aton dios nga nagpaguwa sa aton sa Egypt.’ ” ");
INSERT INTO hil_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Nagsiling pa gid ang Ginoo kay Moises, “Nakita ko kon daw ano katig-a ang mga ulo sang sini nga mga tawo. ");
INSERT INTO hil_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Gani pabay-i ako nga laglagon ko sila sa akon puwerte nga kaakig. Kag ikaw na lang kag ang imo mga kaliwat ang himuon ko nga bantog nga nasyon.” ");
INSERT INTO hil_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Pero nagpakitluoy si Moises sa Ginoo nga iya Dios, “O Ginoo, ngaa ipaagom mo ang imo kaakig sa imo katawhan nga ginpaguwa mo sa Egypt paagi sa imo puwerte nga gahom? ");
INSERT INTO hil_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ano na lang ang hambalon sang mga Egyptohanon? Nga ginkuha mo ang imo katawhan sa Egypt sa tuyo nga patyon sila sa kabukiran para madula sila sa kalibutan? Indi pagpadayuna ang imo puwerte nga kaakig sa ila, kag indi sila paglaglaga. ");
INSERT INTO hil_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Dumduma ang imo ginsumpa sa imo mga alagad nga si Abraham, Isaac, kag Jacob nga padamuon mo ang ila mga kaliwat pareho kadamo sa mga bituon sa langit, kag ihatag mo sa ila mga kaliwat ang tanan nga duta nga imo ginpromisa sa ila, kag mangin ila ini nga palanublion hasta san-o.” ");
INSERT INTO hil_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Gani wala na pagpadayuna sang Ginoo ang iya plano nga paglaglag sa iya katawhan. ");
INSERT INTO hil_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Dayon nagpanaog si Moises sa bukid nga dala ang duha ka malapad nga bato nga ginsulatan sang Kasuguan. Nakasulat ini sa atubangan kag sa likod sang amo nga mga bato. ");
INSERT INTO hil_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ang Dios mismo ang naghimo sini kag nagsulat. ");
INSERT INTO hil_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Sang mabatian ni Josue ang ginahod sang mga tawo, nagsiling siya kay Moises, “Daw may gahod sang inaway sa kampo.” ");
INSERT INTO hil_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Nagsabat si Moises, “Indi ina gahod sang kadalag-an ukon kapierdihan, kundi gahod ina sang pagkinanta.” ");
INSERT INTO hil_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Sang malapit na si Moises sa kampo, nakita niya ang dios-dios nga baka kag ang pagsinaot sang mga tawo, gani puwerte gid ang iya kaakig. Ginhaboy niya didto sa tiilan sang bukid ang malapad nga mga bato nga dala niya, kag nabuka ini. ");
INSERT INTO hil_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Dayon ginkuha niya ang dios-dios nga baka nga ila ginhimo kag ginsunog niya. Pagkatapos gindugmok niya sing mapino kag ginsabwag sa tubig, kag ginpainom sa katawhan sang Israel. ");
INSERT INTO hil_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Nagsiling si Moises kay Aaron, “Ano bala ang ginhimo sining mga tawo sa imo nga gintugutan mo sila sa puwerte nga pagpakasala?” ");
INSERT INTO hil_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Nagsabat si Aaron, “Indi ka mangakig sa akon. Nahibaluan mo man kon daw ano sila kadali madala sa kalautan. ");
INSERT INTO hil_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Nagsiling sila sa akon, ‘Himui kami sang dios nga magapanguna sa amon, tungod nga wala kita kahibalo kon ano na ang natabo sining tawo nga si Moises nga nagpaguwa sa aton sa Egypt.’ ");
INSERT INTO hil_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Gani nagsiling ako sa ila nga dal-on nila sa akon ang ila bulawan nga mga alahas. Sang madala na nila sa akon, ginhaboy ko ini sa kalayo kag nagguwa ining baka.” ");
INSERT INTO hil_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Nakita ni Moises nga nagapakawala ang mga tawo kag ginpabay-an lang sila ni Aaron. Tungod sini nangin kaladlawan sila sa ila mga kaaway sa palibot. ");
INSERT INTO hil_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Gani nagtindog si Moises sa puwertahan sang kampo kag nagsinggit, “Ang bisan sin-o sa inyo nga nagaunong sa Ginoo magpalapit sa akon!” Kag ang tanan nga kaliwat ni Levi nagtipon sa iya. ");
INSERT INTO hil_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Nagsiling si Moises sa ila, “Nagasiling ang Ginoo, ang Dios sang Israel, nga ang kada isa sa inyo magtaklos sang espada kag libuti ninyo ang kampo, kag pamatya ninyo inang malain nga mga tawo bisan utod pa ninyo, amigo, ukon kasilingan.” ");
INSERT INTO hil_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Gintuman sang mga kaliwat ni Levi ang ginsugo sa ila ni Moises, kag sadto nga adlaw mga 3,000 ka tawo ang napatay. ");
INSERT INTO hil_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Nagsiling si Moises sa mga kaliwat ni Levi, “Ginseparar kamo subong nga adlaw sa Ginoo, kay ginpamatay ninyo bisan ang inyo mga anak kag mga utod. Gani bendisyunan niya kamo subong nga adlaw.” ");
INSERT INTO hil_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Pagkasunod nga adlaw, nagsiling si Moises sa mga tawo, “Nakahimo kamo sang dako nga sala. Pero masaka ako subong sa bukid, didto saGinoo; basi pa lang mabuligan ko kamo nga matubos kamo sa inyo nga sala.” ");
INSERT INTO hil_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Gani nagbalik si Moises sa Ginoo kag nagsiling, “Daw ano kadako nga sala ang nahimo sini nga mga tawo. Naghimo sila sang dios nga bulawan. ");
INSERT INTO hil_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Pero karon, patawara sila sa ila nga sala. Kon indi mo sila mapatawad, panasa na lang ang akon ngalan sa libro nga ginsulatan mo sang mga ngalan sang imo katawhan.” ");
INSERT INTO hil_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Nagsabat ang Ginoo kay Moises, “Kon sin-o ang nakasala sa akon, ang iya ngalan amo ang akon panason sa akon libro. ");
INSERT INTO hil_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Lakat, kag pangunahi ang mga tawo pakadto sa lugar nga ginsiling ko sa imo, kag magauna ang akon anghel sa inyo. Pero magaabot ang tion nga silutan ko sila tungod sang ila sala.” ");
INSERT INTO hil_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Kag ginpadal-an sang Ginoo sang kahalitan ang mga Israelinhon tungod nga ginsimba nila ang dios-dios nga baka nga ginhimo ni Aaron. ");
INSERT INTO hil_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Dayon nagsiling ang Ginoo kay Moises, “Halin ka sa sini nga lugar, upod sa mga tawo nga ginpaguwa mo sa Egypt, kag kadto kamo sa duta nga ginsumpa ko nga ihatag kay Abraham, Isaac, kag Jacob. Nagsiling ako sa ila sadto nga ihatag ko ini nga duta sa ila mga kaliwat. ");
INSERT INTO hil_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Paunahon ko ang anghel sa inyo, kag tabugon ko ang mga Canaanhon, mga Amornon, mga Hithanon, mga Periznon, mga Hivhanon, kag mga Jebusnon ");
INSERT INTO hil_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","sa sina nga duta nga maayo kag mapatubason. Kamo lang ang magkadto didto; indi ako mag-upod sa inyo kay mga matig-a kamo sang ulo, kag basi kon pamatyon ko pa kamo sa dalan.” ");
INSERT INTO hil_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Sang mabatian sang mga tawo ining masakit nga mga pulong, nagpangasubo gid sila kag wala sila magsul-ob sang ila mga alahas. ");
INSERT INTO hil_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Kay nagsugo ang Ginoo kay Moises nga ihambal niya ini sa mga Israelinhon: “Mga matig-a kamo sing ulo nga mga tawo. Kon updan ko kamo bisan sa malip-ot lang nga tion, basi kon mapatay ko pa kamo. Karon, panghuksa ninyo ang inyo mga alahas hasta nga makadesisyon ako kon ano ang akon himuon sa inyo.” ");
INSERT INTO hil_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Gani ginpanghukas sang mga Israelinhon ang ila mga alahas didto sa Bukid sang Horeb. ");
INSERT INTO hil_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Kinabatasan na ni Moises nga magpatindog sang Tolda nga medyo malayo sa kampo. Ini nga Tolda ginatawag nga “Tolda nga Ginapakigkitaan.” Ang bisan sin-o nga gusto makahibalo sang kabubut-on sang Ginoo nagakadto sa sini nga Tolda. ");
INSERT INTO hil_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Kon magsulod si Moises sa Tolda, nagatindog ang mga tawo sa puwertahan sang ila mga tolda. Ginatan-aw nila si Moises hasta nga makasulod siya sa Tolda. ");
INSERT INTO hil_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Kag samtang didto si Moises sa sulod, nagapaidalom ang panganod nga daw haligi sa puwertahan sang Tolda samtang nagapakighambal ang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kag kon makita sang mga tawo ang panganod nga daw haligi sa puwertahan sang Tolda, nagatindog sila kag nagasimba sa Ginoo sa may puwertahan sang ila mga tolda. ");
INSERT INTO hil_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Kon magpakig-estorya ang Ginoo kay Moises, daw sa nagaatubangay gid sila, pareho sa mag-abyan nga nagaestoryahanay. Pagkatapos nagabalik si Moises sa kampo, pero ang bataon niya nga kabulig nga si Josue, nga anak ni Nun, nagapabilin sa Tolda. ");
INSERT INTO hil_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Nagsiling si Moises sa Ginoo, “Permi mo ako ginahambalan nga pangunahan ko ini nga katawhan sa pagkadto sa duta nga imo ginpromisa, pero wala mo pa ako ginpahibalo kon sin-o ang paupdon mo sa akon. Nagsiling ka pa nga kilala mo gid ako kag nalipay ka sa akon. ");
INSERT INTO hil_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kon matuod nga nalipay ka sa akon, tudlui ako sang imo mga pamaagi para makilala ko ikaw kag para malipay pa gid ikaw sa akon. Dumduma nga ini nga nasyon imo katawhan.” ");
INSERT INTO hil_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Nagsabat ang Ginoo, “Ako mismo ang magaupod sa imo, kag hatagan ko ikaw sang kapahuwayan.” ");
INSERT INTO hil_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Nagsiling si Moises sa iya, “Kon indi ka mag-upod sa amon, indi kami pagpahalina sa sini nga lugar. ");
INSERT INTO hil_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Kay paano mahibaluan sang iban nga nalipay ka sa akon kag sa imo katawhan kon indi mo kami pag-updan? Kag paano nila mahibaluan nga espesyal kami nga katawhan sang sa iban nga mga katawhan sa kalibutan?” ");
INSERT INTO hil_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Nagsabat ang Ginoo kay Moises, “Himuon ko ang ginapangayo mo, kay nalipay ako sa imo, kag kilala ko gid ikaw.” ");
INSERT INTO hil_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Dayon nagsiling si Moises, “Karon, ipakita sa akon ang imo gamhanan nga presensya.” ");
INSERT INTO hil_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Nagsabat ang Ginoo, “Ipakita ko sa imo ang tanan ko nga kaayo, kag imitlang ko sa imo ang akon ngalan, ang Ginoo. Kaluoyan ko ang gusto ko nga kaluoyan. ");
INSERT INTO hil_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Pero indi mo makita ang akon nawong kay wala sing tawo nga makakita sa akon nga mabuhi.” ");
INSERT INTO hil_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Dayon nagsiling ang Ginoo, “Tindog ka diri sa dako nga bato malapit sa akon. ");
INSERT INTO hil_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Kag samtang nagalabay ang akon gamhanan nga presensya, isulod ko ikaw sa guhab sang bato kag tabunan ko ikaw sang akon kamot hasta nga makaagi ako. ");
INSERT INTO hil_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Dayon kuhaon ko ang akon kamot kag makita mo ang akon likod, pero indi ang akon nawong.” ");
INSERT INTO hil_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Nagsiling ang Ginoo kay Moises, “Magbasbas ka sang duha ka malapad nga bato pareho sadtong nahauna, kay sulatan ko ini sang mga pulong nga nasulat sa nahauna nga bato nga ginbuka mo. ");
INSERT INTO hil_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Magpreparar ka para sa buwas sa aga, kag magsaka ka sa Bukid sang Sinai. Magpakigkita ka sa akon sa ibabaw sang bukid. ");
INSERT INTO hil_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Kinahanglan nga wala sing may mag-upod sa imo; wala gid dapat sing bisan sin-o nga makita sa bisan diin nga parte sang bukid. Bisan mga karnero ukon mga baka indi gid pagpahalbon sa bukid.” ");
INSERT INTO hil_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Gani nagbasbas si Moises sang duha ka malapad nga bato nga pareho sadtong nahauna. Kag aga pa sang sunod nga adlaw, nagsaka siya sa Bukid sang Sinai suno sa ginmando sa iya sang Ginoo dala ang duha ka malapad nga bato. ");
INSERT INTO hil_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Dayon nagpanaog ang Ginoo paagi sa panganod kag ginmitlang niya ang iya ngalan nga Ginoo samtang nagatindog si Moises sa iya presensya. ");
INSERT INTO hil_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Naglabay ang Ginoo sa atubangan ni Moises kag nagsiling, “Ako ang Ginoo, ang mabinalak-on kag maluluy-on nga Dios. Mahigugmaon kag matutom gid ako, kag indi dali mangakig. ");
INSERT INTO hil_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ginapakita ko ang akon paghigugma sa madamo nga tawo, kag ginapatawad ko ang ila kalautan, paglapas, kag sala. Pero ginasilutan ko ang mga nakasala, pati ang ila mga kaliwat hasta sa ikatatlo kag ikaapat nga henerasyon.” ");
INSERT INTO hil_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Nagluhod dayon si Moises sa duta kag nagsimba. ");
INSERT INTO hil_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Nagsiling siya, “O Ginoo, kon nalipay ka sa akon, nagapangabay ako nga mag-upod ka sa amon. Bisan matig-a ang ulo sang sini nga mga tawo, patawara kami sa amon kalautan kag sala. Batuna kami nga imo katawhan.” ");
INSERT INTO hil_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Nagsiling ang Ginoo, “Pamati! Himuon ko ini nga kasugtanan sa inyo. Sa atubangan sang tanan mo nga kasimanwa, mahimo ako sang makatilingala nga mga butang nga wala ko pa gid nahimo sa bisan diin nga nasyon sa bilog nga kalibutan. Ang mga katawhan sa palibot ninyo makakita sang sini nga mga butang nga himuon ko para sa imo. ");
INSERT INTO hil_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tumana ang mga sugo nga ginahatag ko sa imo subong. Tabugon ko ang mga Amornon, mga Canaanhon, mga Hithanon, mga Periznon, mga Hivhanon, kag mga Jebusnon sa duta nga ginpromisa ko sa inyo. ");
INSERT INTO hil_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Siguraduhon mo gid nga indi ka maghimo sang kasugtanan sa mga tawo sa sina nga duta nga inyo pagakadtuan, kay mangin siod ini sa inyo. ");
INSERT INTO hil_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Sa baylo, panggub-a ninyo ang ila mga halaran, pangdugmuka ang ila handumanan nga mga bato, kag pang-utda ang ila mga hulohaligi nga simbolo sang ila diosa nga si Ashera. ");
INSERT INTO hil_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Indi gid kamo magsimba sa iban nga dios kay ako, ang Ginoo, indi gid gusto nga may ginasimba kamo nga iban. ");
INSERT INTO hil_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Indi ka gid maghimo sang kasugtanan sa mga tawo nga nagaestar sa sina nga duta. Kay basi matintar kamo nga magkaon sang ila mga halad kon imbitaron nila kamo sa ila nga paghalad kag pagsimba sa ila mga dios. ");
INSERT INTO hil_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Kag basi ang inyo mga anak magpangasawa sa ila mga anak, nga amo ang magatulod sa ila sa pagsimba sa iban nga mga dios. ");
INSERT INTO hil_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Indi kamo maghimo sang mga dios-dios. ");
INSERT INTO hil_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Sauluga ninyo ang Piesta sang Tinapay nga Wala sing Inugpahabok. Suno sa ginsugo ko sa inyo, magkaon kamo sang tinapay nga wala sing inugpahabok sa sulod sang pito ka adlaw. Himua ninyo ini sa gintalana nga tion sa bulan sang Aviv, kay amo ina nga bulan nga nagguwa kamo sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Akon ang tanan nga kamagulangan nga lalaki, pati ang mga kamagulangan nga lalaki sang inyo mga kasapatan. ");
INSERT INTO hil_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Puwede magawad ang kamagulangan sang inyo mga donkey paagi sa pagbaylo sini sang karnero. Pero kon indi ninyo ini paggawaron, kinahanglan nga patyon ang donkey paagi sa pagbali sang iya liog. Puwede man ninyo magawad ang inyo kamagulangan nga mga anak nga lalaki. “Wala sing may magpalapit sa akon nga wala sing dala nga halad. ");
INSERT INTO hil_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Mag-obra kamo sa sulod sang anom ka adlaw, pero sa ikapito nga adlaw magpahuway kamo, bisan sa panahon sang tig-arado kag tig-alani. ");
INSERT INTO hil_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Sauluga ninyo ang Piesta sang Pag-ani paagi sa pagdala sa akon sang nahauna nga patubas sang inyo trigo, kag sauluga man ninyo ang Piesta sang Katapusan nga Ani sa katapusan sang tuig. ");
INSERT INTO hil_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Kada tuig, ang tanan ninyo nga lalaki dapat magtambong sa sinang tatlo ka piesta sa pagsimba sa akon, angGinoo nga inyo Agalon, ang Dios sang Israel. ");
INSERT INTO hil_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Tabugon ko ang mga katawhan sa duta nga ihatag ko sa inyo, kag palaparon ko ang inyo teritoryo. Kag wala sing may magsalakay kag mag-agaw sa inyo nasyon sa panahon nga magpalapit kamo sa akon, ang Ginoo nga inyo Dios, sa sinang tatlo ka piesta kada tuig. ");
INSERT INTO hil_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Indi kamo maghalad sang dugo sa akon kaupod sang tinapay nga may inugpahabok. Kag indi kamo magbilin sa masunod nga adlaw sang karne nga halad ninyo sa tion sang Piesta sang Paglabay sang Anghel. ");
INSERT INTO hil_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Dal-a ninyo sa templo sang Ginoo nga inyo Dios ang pinakamaayo nga parte sang nahauna ninyo nga patubas. “Indi ninyo paglutua ang bataon nga kanding sa gatas sang iya iloy.” ");
INSERT INTO hil_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Dayon nagsiling ang Ginoo kay Moises, “Isulat ining ginsiling ko, kay amo ini ang pagsulundan sang akon kasugtanan sa imo kag sa Israel.” ");
INSERT INTO hil_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Didto si Moises upod sa Ginoo sa sulod sang 40 ka adlaw kag 40 ka gab-i nga wala siya sing may ginkaon kag gin-inom. Ginsulat niya sa malapad nga bato ang mga pagsulundan sang kasugtanan—ang Napulo ka Sugo. ");
INSERT INTO hil_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Sang magpanaog si Moises sa Bukid sang Sinai, dala niya ang duha ka malapad nga bato nga ginsulatan sang Kasuguan. Wala siya kahibalo nga masilaw gali ang iya nawong tungod sa iya pagpakighambal sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Sang makita ni Aaron kag sang tanan nga Israelinhon ang masilaw nga nawong ni Moises, nahadlok sila magpalapit sa iya. ");
INSERT INTO hil_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Pero gintawag sila ni Moises, gani nagpalapit si Aaron kag ang mga pangulo sang komunidad sang Israel, kag nagpakighambal si Moises sa ila. ");
INSERT INTO hil_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Sang ulihi nagpalapit ang tanan nga Israelinhon sa iya. Kag ginsugid niya sa ila ang tanan nga sugo nga ginhatag sa iya sang Ginoo sa Bukid sang Sinai. ");
INSERT INTO hil_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Pagkatapos pakighambal ni Moises sa ila, gintabunan niya ang iya nawong. ");
INSERT INTO hil_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Pero kon magsulod siya sa Tolda nga Ginapakigkitaan para magpakighambal sa Ginoo, ginakuha niya ang tabon hasta nga makaguwa siya sa Tolda. Kon makaguwa na siya, ginasugid niya sa mga Israelinhon ang tanan nga ginsugo sang Ginoo sa iya, ");
INSERT INTO hil_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","kag makita sang mga Israelinhon nga masilaw ang iya nawong. Dayon tabunan naman niya ang iya nawong hasta nga magbalik siya sa Tolda sa pagpakighambal sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Ginpatipon ni Moises ang bilog nga komunidad sang Israel kag ginhambalan, “Amo ini ang ginsugo sang Ginoo nga inyo himuon: ");
INSERT INTO hil_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sa sulod sang anom ka adlaw, himua ninyo ang inyo mga buluhaton, pero sa ikapito nga adlaw magpahuway kamo, kay ini nga adlaw balaan kag para ini sa Ginoo. Ang bisan sin-o nga mag-obra sa sina nga adlaw dapat patyon. ");
INSERT INTO hil_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Gani indi gid kamo mag-obra, bisan magdabok sang kalayo sa inyo mga puluy-an sa pagluto sa sina nga adlaw.” ");
INSERT INTO hil_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Nagsiling si Moises sa bilog nga komunidad sang Israel, “Amo ini ang ginsugo sang Ginoo nga inyo himuon: ");
INSERT INTO hil_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Maghalad kamo sa Ginoo halin sa inyo mga pagkabutang. Puwede kamo maghalad sang bulawan, pilak, saway, ");
INSERT INTO hil_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","delana nga asol, granate kag pula, linen, panapton nga hinimo halin sa bulbol sang kanding, ");
INSERT INTO hil_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","panit sang karnero nga lalaki nga ginlugom sa pula, maayo nga klase sang panit, kahoy nga akasya, ");
INSERT INTO hil_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lana sang olibo para sa mga suga, mga panakot para sa lana nga inughaplas kag para pahamot sa insenso, ");
INSERT INTO hil_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","kag bato nga onix kag iban pa nga malahalon nga mga bato nga inugtakod sa espesyal nga panaptonsang pangulo nga pari kag sa bulobulsa sa dughan sini. ");
INSERT INTO hil_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Ang tanan sa inyo nga may abilidad sa pag-obra magpalapit kag magbulig sa paghimo sang tanan nga butang nga ginsugo sang Ginoo nga himuon: ");
INSERT INTO hil_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ang Tolda nga Simbahan kag ang iya sini mga tabon, mga kaw-it, mga dingding nga tapi, mga pangbalabag sa dingding, mga haligi, kag mga pundasyon; ");
INSERT INTO hil_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ang Kahon sang Kasugtanan kag ang iya mga tukon nga pangtuwang, tabon, kag kurtina; ");
INSERT INTO hil_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ang lamisa kag ang iya mga tukon nga pangtuwang kag ang tanan nga kagamitan sini; ang tinapay nga ginahalad sa presensya sang Dios; ");
INSERT INTO hil_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ang bulutangan sang suga kag ang mga kagamitan sini; ang mga suga kag ang lana para sa mga suga; ");
INSERT INTO hil_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ang halaran nga sulunugan sang insenso kag ang iya mga tukon nga pangtuwang; ang lana nga inughaplas; ang mahamot nga insenso; ang kurtina sang puwertahan sang Tolda nga Simbahan; ");
INSERT INTO hil_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ang halaran sang halad nga ginasunog kag ang iya sini parilyahan nga saway, ang iya mga tukon nga pangtuwang, kag ang tanan nga kagamitan sini; ang saway nga labador kag ang iya tulungtungan; ");
INSERT INTO hil_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ang mga kurtina sa palibot sang ugsaran kag ang iya sini mga haligi kag mga pundasyon; ang kurtina sa puwertahan sang ugsaran; ");
INSERT INTO hil_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ang mga palpal kag mga banting sang Tolda nga Simbahan kag sang ugsaran sini; ");
INSERT INTO hil_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","kag ang matahom kag balaan nga mga panapton sang pari nga si Aaron kag sang iya mga anak nga lalaki, nga ila suksukon kon mag-alagad sila bilang mga pari sa Balaan nga Lugar.” ");
INSERT INTO hil_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Dayon naghalin ang bilog nga komunidad sang Israel sa atubangan ni Moises. ");
INSERT INTO hil_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ang tanan nga gusto gid maghalad sa Ginoo nagdala sang mga materyales nga gamiton sa paghimo sang Tolda nga Ginapakigkitaan kag sang tanan nga kagamitan sini, kag sa paghimo sang mga panapton sang mga pari. ");
INSERT INTO hil_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ang tanan nga gusto maghalad, lalaki kag babayi, nagdala sang malahalon nga mga sibit, mga aritos, mga pulseras, kag nagkalain-lain nga klase sang mga alahas nga bulawan. Gindala nila ang ila mga bulawan bilang halad nga ginabayaw sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","May naghalad man sang delana nga asol, granate kag pula, linen, panapton nga hinimo halin sa bulbol sang kanding, panit sang karnero nga lalaki nga ginlugom sa pula, kag maayo nga klase sang panit. ");
INSERT INTO hil_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ang iban nagdala sang pilak ukon saway, kag mga tapi nga akasya bilang halad sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ang mga babayi nga may abilidad sa paghimo sang mga tela nagdala sang mga delana nga asol, granate kag pula, kag linen. ");
INSERT INTO hil_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Kag ang mga babayi nga may abilidad sa paghimo sang panapton halin sa bulbol sang kanding, naghimo sini sing kinabubut-on. ");
INSERT INTO hil_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ang mga pangulo nagdala sang mga bato nga onix kag iban pa nga malahalon nga mga bato para inugtakod sa espesyal nga panapton sang pangulo nga pari kag sa bulobulsa sa dughan sini. ");
INSERT INTO hil_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Nagdala man sila sang mga panakot kag lana sang olibo para sa mga suga, para sa lana nga inughaplas, kag para pahamot sa insenso. ");
INSERT INTO hil_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Gani ang tanan nga Israelinhon, lalaki kag babayi, nga gusto magbulig nagdala sang ila mga halad nga kinabubut-on sa Ginoo para sa tanan nga buluhaton nga ginsugo sang Ginoo paagi kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Nagsiling si Moises sa mga Israelinhon, “Pamati! Ginpili sang Ginoo si Bezalel, nga anak ni Uri kag apo ni Hur, nga halin sa tribo ni Juda. ");
INSERT INTO hil_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Gin-gamhan niya siya sang iya Espiritu kag ginhatagan sang kaalam kag abilidad sa bisan ano nga buluhaton— ");
INSERT INTO hil_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","sa paghimo sang matahom nga mga butang nga bulawan, pilak, kag saway; ");
INSERT INTO hil_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","sa pagporma sang malahalon nga mga bato nga inugtampok; sa pagkorte sang kahoy; kag sang tanan nga klase sang buluhaton. ");
INSERT INTO hil_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ginhatagan pa gid niya si Bezalel, kag amo man si Oholiab nga anak ni Ahisamac nga halin sa tribo ni Dan, sang abilidad sa pagtudlo sa iban sang ila nahibaluan. ");
INSERT INTO hil_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ginhatagan niya sila sang abilidad sa paghimo sang tanan nga klase sang buluhaton: sa pagdesinyo, sa paghimo sang tela, kag sa pagborda sa linen sang delana nga asol, granate kag pula. Masarangan nila nga himuon ang bisan ano nga klase sang buluhaton, kag maayo gid sila maghimo.” ");
INSERT INTO hil_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Si Bezalel, si Oholiab, kag ang iban pa nga ginhatagan sang Ginoo sang kaalam kag abilidad sa nagkalain-lain nga buluhaton amo ang mag-obra sang balaan nga Tolda suno sa sugo sang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Gani ginpatawag ni Moises si Bezalel, si Oholiab kag ang iban pa nga ginhatagan sang Ginoo sang kaalam kag abilidad sa nagkalain-lain nga buluhaton, kag gusto gid nga magbulig sa pag-obra. ");
INSERT INTO hil_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ginhatag ni Moises sa ila ang tanan nga ginhalad sang mga Israelinhon para sa pagpatindog sang balaan nga Tolda. Kag padayon pa gid ang pagdala sang mga tawo sang ila mga halad nga kinabubut-on kada aga. ");
INSERT INTO hil_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Gani sang ulihi ginbayaan anay sang mga nagaobra sang balaan nga Tolda ang ila trabaho kag nagkadto kay Moises kag nagsiling, ");
INSERT INTO hil_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“Sobra na ang ginadala sang mga tawo sang sa kinahanglanon para sa buluhaton nga ginsugo sang Ginoo nga himuon.” ");
INSERT INTO hil_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Gani nagpadala si Moises sang sini nga sugo sa bilog nga kampo: “Wala na sing may maghalad para sa pagpatindog sang balaan nga Tolda.” Gani nag-untat na ang mga tawo sa pagdala sang ila mga halad, ");
INSERT INTO hil_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","tungod kay sobra na ang ila nahatag para sa tanan nga buluhaton sa Tolda. ");
INSERT INTO hil_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Ang tanan nga maayo gid mag-obra amo ang naghimo sang Tolda nga Simbahan. Ang gin-gamit nila sa paghimo sini napulo ka panid nga linen nga ginbordahan sang delana nga asol, granate kag pula. Kag nabordahan ini sing maayo sang dagway sang mga kerubin. ");
INSERT INTO hil_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ang kada panid may kalabaon nga 42 feet kag may kasangkaron nga mga 6 feet. ");
INSERT INTO hil_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Gintambi nila ini sa tag-lima; bali duha ka tag-lima. ");
INSERT INTO hil_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Dayon ginhimuan nila sang sulosingsing nga tela nga asol ang kilid sang katapusan nga panid sang tagsa ka tinambi nga mga tela; ");
INSERT INTO hil_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","tag-50 ka sulosingsing ang ginbutang sa kada kilid kag nagaatubangay ini. ");
INSERT INTO hil_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Naghimo man sila sang 50 ka kaw-it nga bulawan para matabid ang mga sulosingsing sang duha ka tinambi nga mga tela. Sa sini nga paagi nahimo ang Tolda nga Simbahan. ");
INSERT INTO hil_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Dayon naghimo sila sang tabon sa Tolda. Ang ila gin-gamit onse ka panid nga tela nga hinimo halin sa bulbol sang kanding. ");
INSERT INTO hil_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ang kada tela may kalabaon nga 45 feet kag may kasangkaron nga mga 6 feet. ");
INSERT INTO hil_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Gintambi nila ang lima ka tela, kag amo man ang nabilin nga anom. ");
INSERT INTO hil_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ginbutangan nila sang 50 ka sulosingsing ang kilid sang katapusan nga panid sang tagsa ka tinambi nga mga tela, ");
INSERT INTO hil_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","kag gintabid nila sang 50 ka kaw-it nga saway. ");
INSERT INTO hil_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ang ibabaw sang tabon sang Tolda ginsampawan nila sang panit sang lalaki nga karnero nga ginlugom sa pula, kag ginsampawan pa gid nila sang maayo nga klase sang panit. ");
INSERT INTO hil_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Dayon naghimo sila sang dingding sang Tolda. Ang ila gin-gamit tapi nga akasya. ");
INSERT INTO hil_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ang kalabaon sang kada tapi 15 feet kag ang kasangkaron 2 feet. ");
INSERT INTO hil_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ang kada tapi ginbutangan nila sang duha ka diladila para matabid ini sa isa pa ka tapi. Pareho sini ang ginhimo nila sa kada tapi. ");
INSERT INTO hil_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ang 20 sa sini nga mga tapi gindingding nila sa parte sang Tolda nga nagaatubang sa south. ");
INSERT INTO hil_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ini nga mga tapi ginsuok nila sa 40 ka pundasyon nga pilak—duha ka pundasyon sa kada tapi. ");
INSERT INTO hil_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ang sa north sang Tolda gindingdingan man nila sang 20 ka tapi, ");
INSERT INTO hil_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","kag ginsuok man sa 40 ka pundasyon nga pilak—duha ka pundasyon sa kada tapi. ");
INSERT INTO hil_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ang sa west sang Tolda, nga amo ang likod sini, gindingdingan nila sang anom ka tapi, ");
INSERT INTO hil_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","kag duha ka tapi sa mga corner sini. ");
INSERT INTO hil_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ini nga mga tapi sa mga corner natabid sing maayo sa idalom kag nahugot sa ibabaw paagi sa isa ka sulosingsing. Pareho gid sini ang ginhimo nila sa duha ka tapi sa mga corner. ");
INSERT INTO hil_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Gani may walo ka tapi sa sini nga parte sang Tolda, kag nasuok ini sa 16 ka pundasyon nga pilak—duha ka pundasyon sa kada tapi. ");
INSERT INTO hil_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Naghimo man sila sang mga pangbalabag nga akasya para sa dingding—lima para sa parte sang Tolda nga nagaatubang sa north, ");
INSERT INTO hil_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","lima man sa south, kag lima pa gid sa west, sa likod sang Tolda. ");
INSERT INTO hil_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ang pangbalabag sa tunga-tunga sang dingding ginbutang nila halin sa punta sang Tolda pakadto sa pihak nga punta. ");
INSERT INTO hil_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ginhaklapan nila sang bulawan ang mga tapi kag ginbutangan sang mga sulosingsing nga bulawan nga amo ang gululuan sang mga pangbalabag. Ginhaklapan man nila sang bulawan ang mga pangbalabag. ");
INSERT INTO hil_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Naghimo man sila sang kurtina nga linen nga ginbordahan sang delana nga asol, granate kag pula. Kag nabordahan ini sing maayo sang dagway sang kerubin. ");
INSERT INTO hil_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Naghimo man sila sang apat ka haligi nga akasya nga may mga kaw-it nga bulawan, kag ginpakabit nila didto ang kurtina. Ining apat ka haligi nasuok sa apat ka pundasyon nga pilak. ");
INSERT INTO hil_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Naghimo sila sang isa pa ka kurtina para sa puwertahan sang Tolda nga Simbahan. Ang gin-gamit nila linen nga ginbordahan sang delana nga asol, granate kag pula. Kag maayo gid ang pagkaborda sini. ");
INSERT INTO hil_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Naghimo man sila sang lima ka haligi nga may mga kaw-it, kag ginpakabit nila didto ang kurtina. Ini nga mga haligi nahaklapan sang bulawan pati ang ila sini ulo-ulo kag mga kabilya, kag nasuok ini sa lima ka pundasyon nga saway. ");
INSERT INTO hil_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Dayon ginhimo nila ni Bezalel ang Kahon sang Kasuguan. Ang gin-gamit nila kahoy nga akasya. Ang kalabaon sang Kahon 45 inches, ang kasangkaron 27 inches, kag ang kataason 27 inches. ");
INSERT INTO hil_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ginhaklapan nila ini sang puro nga bulawan sa sulod kag sa guwa, kag ginrebitihan sang bulawan ang mga kilid sini. ");
INSERT INTO hil_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ginhimuan man nila ini sang apat ka sulosingsing nga bulawan kag gintakod sa apat ka tiil sini. Tag-duha sa pihak kag pihak. ");
INSERT INTO hil_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Dayon naghimo sila sang mga tukon nga akasya kag ginhaklapan nila ini sang bulawan. ");
INSERT INTO hil_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Gin-gulo nila ang mga tukon sa mga sulosingsing sa kada kilid sang Kahon para matuwangan ang Kahon. ");
INSERT INTO hil_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ginhimuan man nila ang Kahon sang takop nga puro bulawan, nga 45 inches ang kalabaon kag 27 inches ang kasangkaron. ");
INSERT INTO hil_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","8","Naghimo man sila sang duha ka kerubin nga bulawan sa kada punta sang takop sang Kahon. Isa lang ini sila ka pagporma sang takop sang Kahon. ");
INSERT INTO hil_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Nagahumlad ang mga pakpak sang mga kerubin sa ibabaw sang takop para mahandungan nila ini. Nagaatubangay sila nga duha kag nagatulok sa takop. ");
INSERT INTO hil_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Naghimo man sila sang lamisa nga akasya, nga 36 inches ang kalabaon, 18 inches ang kasangkaron, kag 27 inches ang kataason. ");
INSERT INTO hil_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ginhaklapan nila ini sang puro nga bulawan kag ginrebitihan sang bulawan ang mga kilid sini. ");
INSERT INTO hil_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ginbutangan man nila ini sang border sa kada kilid, nga 4 inches ang kasangkaron, kag ginrebitihan nila sang bulawan ang border. ");
INSERT INTO hil_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Dayon naghimo sila sang apat ka sulosingsing nga bulawan kag gintakod ini sa apat ka tiil sang lamisa, ");
INSERT INTO hil_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","malapit sa border. Diri nila gin-gulo ang mga tukon nga pangtuwang sa lamisa. ");
INSERT INTO hil_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ini nga mga tukon akasya kag nahaklapan sang bulawan. ");
INSERT INTO hil_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Naghimo man sila sang mga kagamitan nga puro bulawan para sa lamisa: mga pinggan, mga tasa, mga yahong, kag mga tibod nga gamiton para sa mga halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Naghimo man sila sang bulutangan sang suga nga puro bulawan ang iya tiil, lawas, kag dekorasyon nga mga bulak nga ang iban bukol pa lang kag ang iban nagabuskad na. Ang dekorasyon naporma na nga daan upod sa lawas sang bulutangan sang suga sang pagkahimo sini. ");
INSERT INTO hil_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ang bulutangan sang suga may anom ka sanga, tag-tatlo sa kada kilid. ");
INSERT INTO hil_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ang kada sanga may tatlo ka dekorasyon nga mga bulak nga ang korte daw almendro, nga ang iban bukol pa lang kag ang iban nagabuskad na. ");
INSERT INTO hil_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ang lawas sang bulutangan sang suga may apat ka dekorasyon nga mga bulak nga ang korte daw almendro, nga ang iban bukol pa lang kag ang iban nagabuskad na. ");
INSERT INTO hil_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","May isa ka bulak sa idalom sang kada paris sang sanga. ");
INSERT INTO hil_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ang mga dekorasyon kag ang mga sanga naporma na nga daan upod sa lawas sang bulutangan sang suga sang pagkahimo sini. ");
INSERT INTO hil_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Naghimo man sila sang pito ka suga, sang mga kimpit sini, kag sang mga inugsalod sa upos nga pabilo sang suga. Ini tanan puro bulawan. ");
INSERT INTO hil_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Mga 35 ka kilo nga puro bulawan ang nagamit sa paghimo sang bulutangan sang suga kag sang tanan nga kagamitan sini. ");
INSERT INTO hil_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Naghimo man sila sang halaran nga akasya nga sulunugan sang insenso. Kuwadrado ini; 18 inches ang kalabaon kag ang kasangkaron, 36 inches ang kataason. May ara ini sang mga sulosungay nga naporma na nga daan upod sa halaran sang pagkahimo sini. ");
INSERT INTO hil_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ginhaklapan nila sang puro nga bulawan ang ibabaw sini, ang apat ka kilid, kag ang mga sulosungay sini, kag ginrebitihan sang bulawan sa palibot. ");
INSERT INTO hil_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ginbutangan nila sang duha ka sulosingsing nga bulawan sa idalom sang rebiti sa pihak kag pihak sang halaran, para gululuan sang mga tukon nga pangtuwang sini. ");
INSERT INTO hil_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ang tukon hinimo halin sa kahoy nga akasya kag ginhaklapan sang bulawan. ");
INSERT INTO hil_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Naghimo man sila sang balaan nga lana nga inughaplas kag sang puro nga insenso nga mahamot gid. ");
INSERT INTO hil_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Naghimo man sila sang kuwadrado nga halaran sang halad nga ginasunog. Ang gin-gamit nila kahoy nga akasya. Ang iya kalabaon kag kasangkaron 7 feet kag 6 inches, kag ang iya kataason 4 feet kag 6 inches. ");
INSERT INTO hil_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ginbutangan nila ini sang mga sulosungay sa apat ka corner, nga naporma na nga daan upod sa halaran sang pagkahimo sini. Ginhaklapan nila sang saway ang halaran. ");
INSERT INTO hil_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ang tanan nga kagamitan sang halaran hinimo man sa saway—ang mga bulutangan sang abo, mga pala, mga yahong, mga dako nga tinidor para sa karne, kag mga bulutangan sang baga. ");
INSERT INTO hil_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Naghimo man sila sang parilyahan nga saway para sa halaran, kag ginbutang nila ini sa sulod sang halaran sa idalom sang sagang, sa tunga-tunga dampi halin sa ibabaw. ");
INSERT INTO hil_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Naghimo man sila sang apat ka sulosingsing nga saway kag gintakod ini sa apat ka corner sang parilyahan nga saway. Ini nga mga sulosingsing amo ang gululuan sang mga tukon nga pangtuwang sa halaran. ");
INSERT INTO hil_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ang mga tukon hinimo halin sa kahoy nga akasya kag ginhaklapan sang saway. ");
INSERT INTO hil_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Gin-gulo nila ang mga tukon sa mga sulosingsing sa kada kilid sang halaran para matuwangan ang halaran. Tapi ang ginhimo nila nga halaran kag guhab ang sulod. ");
INSERT INTO hil_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Dayon naghimo sila sang saway nga labador kag sang iya sini nga tulungtungan nga saway man. Ining mga saway nga gin-gamit halin sa saway nga espiho sang mga babayi nga nag-alagad sa puwertahan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ginbutangan nila sang ugsaran ang Tolda, kag ginpalibutan nila ini sang mga dulodingding nga kurtina nga linen. Ang kalabaon sang kurtina sa south, 150 feet. ");
INSERT INTO hil_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Gintakod nila ini nga kurtina sa 20 ka haligi nga saway nga nasuok sa 20 man ka pundasyon nga saway. Ang ginkabitan nila sang kurtina amo ang mga kaw-it nga pilak nga nagakabit sa mga kabilya nga pilak sa mga haligi. ");
INSERT INTO hil_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ang kurtina sa north 150 feet man ang kalabaon, kag natakod ini sa 20 ka haligi nga saway nga nasuok sa 20 man ka pundasyon nga saway. Ang ginkabitan sang kurtina amo ang mga kaw-it nga pilak nga nagakabit sa mga kabilya nga pilak sa mga haligi. ");
INSERT INTO hil_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ang kurtina sa west 75 feet ang kalabaon, kag natakod ini sa napulo ka haligi nga nasuok sa napulo man ka pundasyon. Ang ginkabitan sang kurtina amo ang mga kaw-it nga pilak nga nagakabit sa mga kabilya nga pilak sa mga haligi. ");
INSERT INTO hil_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ang sa east sang ugsaran 75 feet man ang kalabaon. ");
INSERT INTO hil_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Kag may puwertahan ini nga may mga dulodingding man nga kurtina sa kilid. Ang kurtina sa tuo 22 feet kag 6 inches ang kalabaon, kag natakod ini sa tatlo ka haligi nga nasuok sa tatlo man ka pundasyon. ");
INSERT INTO hil_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Ang kurtina sa wala 22 feet kag 6 inches man ang kalabaon, kag natakod man ini sa tatlo ka haligi nga nasuok sa tatlo man ka pundasyon. ");
INSERT INTO hil_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Ang tanan nga kurtina sa palibot sang ugsaran linen. ");
INSERT INTO hil_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ang mga pundasyon sang mga haligi saway, kag ang mga kaw-it kag mga kabilya sini pilak. Ang mga ulo-ulo sang mga haligi nahaklapan sang pilak. Ang tanan nga haligi sa palibot sang ugsaran may ara sang mga kabilya nga pilak. ");
INSERT INTO hil_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ang kurtina sang puwertahan sang ugsaran linen nga ginbordahan sang delana nga asol, granate, kag pula. Kag maayo gid ang pagkaborda sini. Ang kalabaon sini 30 feet kag ang kataason 7 feet kag 6 inches, pareho sa kataason sang mga kurtina nga nagapalibot sa ugsaran. ");
INSERT INTO hil_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ini nga kurtina natakod sa apat ka haligi nga nasuok sa apat man ka pundasyon. Ang mga kaw-it kag mga kabilya sang mga haligi pilak, kag ang ila mga ulo-ulo nahaklapan sang pilak. ");
INSERT INTO hil_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Puro saway ang tanan nga palpal sa mga banting sang Tolda nga Simbahan kag sang kurtina sa palibot sini. ");
INSERT INTO hil_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Amo ini ang mga materyales nga gin-gamit sa pagpatindog sang Tolda nga Simbahan nga sa diin nabutang ang Kasuguan. Ini nga mga materyales ginlista sang mga kaliwat ni Levi suno sa sugo ni Moises. Ini nga buluhaton gindumalahan ni Itamar nga anak ni Aaron nga pari. ");
INSERT INTO hil_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Ang nagdumala sa pagpatindog sang Tolda nga Simbahan amo si Bezalel nga anak ni Uri kag apo ni Hur, nga halin sa tribo ni Juda. Ginhimo niya ang tanan nga ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ang iya kabulig amo si Oholiab nga anak ni Ahisamac, nga halin sa tribo ni Dan. Maayo gid siya mag-obra kag magdesinyo, kag magborda sa linen sang delana nga asol, granate kag pula. ");
INSERT INTO hil_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ang kabug-aton sang tanan nga bulawan nga ginhalad para gamiton sa pag-obra sang balaan nga Tolda mga 1,000 ka kilo suno sa kilohan sang mga pari. ");
INSERT INTO hil_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","Ang kabug-aton sang tanan nga pilak nga natipon mga 3,520 ka kilo suno sa kilohan sang mga pari. Naghalin ini sa mga tawo nga nalista sa census. Ang kada isa sa ila naghatag sang anom ka gramo nga pilak suno sa kilohan sang mga pari. May 603,550 ka tawo nga nagaedad sing 20 ka tuig paibabaw ang nalista sa census. ");
INSERT INTO hil_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ang 3,500 ka kilo nga pilak gin-gamit sa paghimo sang 100 ka pundasyon sang balaan nga Tolda kag sang mga kurtina. Bali 35 ka kilo kada pundasyon. ");
INSERT INTO hil_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ang nabilin nga 20 ka kilo nga pilak ginhimo nga mga kaw-it kag mga kabilya sang mga haligi, kag ginhaklap sa mga ulo-ulo sang mga haligi. ");
INSERT INTO hil_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ang kabug-aton sang saway nga ginhalad sa Ginoo mga 2,500 ka kilo. ");
INSERT INTO hil_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Gin-gamit ini sa paghimo sang mga pundasyon sang mga haligi sa puwertahan sang Tolda nga Ginapakigkitaan. Ang iban sini gin-gamit sa paghimo sang halaran nga saway kag sang parilyahan sini, kag sang tanan nga kagamitan sang halaran. ");
INSERT INTO hil_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Gin-gamit man ang mga saway sa paghimo sang mga pundasyon sang mga haligi sa palibot sang ugsaran kag sang puwertahan sini, kag sa paghimo sang tanan nga palpal sa mga banting sang Tolda nga Simbahan kag sang mga kurtina sa palibot sini. ");
INSERT INTO hil_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Nagtahi man sila ni Bezalel sang balaan nga mga panapton para sa mga pari suno sa ginsugo sang Ginoo kay Moises. Ang tela nga gin-gamit nila delana nga asol, granate kag pula. Amo man ini nga tela ang gin-gamit nila sa pagtahi sang panapton ni Aaron. ");
INSERT INTO hil_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Nagtahi man sila sang espesyal nga panaptonsang mga pari. Ang tela nga gin-gamit nila linen nga ginbordahan sang delana nga asol, granate kag pula. ");
INSERT INTO hil_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Naghimo sila sang hilo nga bulawan paagi sa pagtapan sang bulawan kag pagkihad-kihad sini sing manipis. Dayon ginborda nila ini sa linen kaupod sang delana nga asol, granate kag pula. Maayo gid ang pagkaborda sini. ");
INSERT INTO hil_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","May duha ka parte ini nga panapton, likod kag atubangan, kag nasugpon ini sa duha ka strap sa may abaga. ");
INSERT INTO hil_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ang wagkos sini linen man nga ginbordahan sang bulawan nga hilo kag delana nga asol, granate kag pula. Ginhimo nila ini tanan suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Gintakod nila ang mga bato nga onix sa mga bulutangan nga bulawan. Gin-inggreban nila ini sang mga ngalan sang mga anak nga lalaki ni Jacob pareho sa pag-inggreb sang pangmarka. ");
INSERT INTO hil_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Gintakod dayon nila ini sa mga strap sang espesyal nga panapton bilang handumanan nga mga bato para sa mga tribo sang Israel. Ginhimo nila ini tanan suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Naghimo man sila sang bulobulsa sa dughan, kag maayo gid ang pagkahimo sini. Ang tela sini pareho man sa tela sang espesyal nga panapton: linen nga ginbordahan sang bulawan nga hilo kag delana nga asol, granate kag pula. ");
INSERT INTO hil_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ining bulobulsa sa dughan napilo sing doble kag kuwadrado—9 inches ang kalabaon kag ang kasangkaron. ");
INSERT INTO hil_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Gintakdan nila ini sang apat ka raya sang malahalon nga mga bato. Sa nahauna nga raya, rubi, topas, kag beril; ");
INSERT INTO hil_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","sa ikaduha nga raya, turquiso, sapiro, kag emeralda; ");
INSERT INTO hil_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","sa ikatatlo nga raya, hasinto, agate, kag ametist; ");
INSERT INTO hil_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","kag sa ikaapat nga raya, krisolito, onix, kag jasper. Gintakod nila ini sa mga bulutangan nga bulawan. ");
INSERT INTO hil_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ang kada bato may ngalan sang isa sa mga anak ni Jacob sa pagrepresentar sang dose ka tribo sang Israel. Ang pag-inggreb sang mga ngalan pareho sa pag-inggreb sang pangmarka. ");
INSERT INTO hil_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ginbutangan man nila sang kulokadena nga puro bulawan ang bulobulsa sa dughan. ");
INSERT INTO hil_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Naghimo man sila sang duha ka bulutangan nga bulawan kag duha ka sulosingsing nga bulawan, kag gin-angot nila ang duha ka sulosingsing sa ibabaw nga mga corner sang bulobulsa. ");
INSERT INTO hil_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Gin-angot nila ang duha ka kulokadena nga bulawan sa duha ka sulosingsing sang bulobulsa, ");
INSERT INTO hil_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","kag ang duha ka punta sang kulokadena gin-angot nila sa duha ka bulutangan nga bulawan nga nagakabit sa strap sang espesyal nga panapton. ");
INSERT INTO hil_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Naghimo man sila sang duha pa ka sulosingsing nga bulawan. Gin-angot nila ini sa likod sang idalom nga mga corner sang bulobulsa sa dughan, nga nagasampaw sa espesyal nga panapton. ");
INSERT INTO hil_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Naghimo pa gid sila sang duha pa ka sulosingsing nga bulawan kag gin-angot nila ini sa espesyal nga panapton sa may wagkos dampi. ");
INSERT INTO hil_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Dayon gintabid nila sang asol nga higot ang idalom nga mga sulosingsing sang bulobulsa kag ang mga sulosingsing sang espesyal nga panapton. Sa sini nga paagi matabid sing maayo ang bulobulsa sa espesyal nga panapton. Ginhimo nila ini tanan suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Nagtahi man sila sang pangguwa nga bayo sang mga pari. Ini nga bayo nasampawan sang espesyal nga panapton. Ang tela nga ila gin-gamit sa pagtahi sini delana nga puro asol. ");
INSERT INTO hil_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ini nga bayo may liab nga ginbutangan sang kulokwelyo para indi ini magisi. ");
INSERT INTO hil_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ginpakabitan nila ang palibot sang sidsid sang bayo sang mga puloprutas nga pomegranata, nga hinimo halin sa linen nga ginbordahan sang delana nga asol, granate kag pula. ");
INSERT INTO hil_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","26","Ginbal-utan nila ang mga dekorasyon sang mga lingga-lingganay nga puro bulawan. Ini nga bayo suksukon ni Aaron kon mag-alagad siya sa Ginoo. Ginhimo nila ini tanan suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Naghimo man sila sang pangsulod nga mga bayo para kay Aaron kag sa iya mga anak nga lalaki. Ang tela nga ila gin-gamit linen. ");
INSERT INTO hil_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Amo man nga tela ang gin-gamit nila sa paghimo sang mga turban, mga kalo kag mga pang-idalom nga panapton. ");
INSERT INTO hil_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ang mga wagkos linen man nga ginbordahan sang delana nga asol, granate kag pula. Kag maayo gid ang pagkaborda sini. Ginhimo nila ini tanan suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Naghimo sila sang medalya nga puro bulawan kag ginpainggreban nila ini pareho sa pag-inggreb sang pangmarka. Kag amo ini ang pulong nga gin-inggreb: ginseparar para sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Gintapik nila ini sa atubangan sang turban ni Aaron paagi sa asol nga higot. Ginhimo nila ini tanan suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Natapos ang tanan nga buluhaton sa Tolda nga Simbahan, nga ginatawag man nga Tolda nga Ginapakigkitaan. Ginhimo sang mga Israelinhon ang tanan nga ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ginpakita nila kay Moises ang Tolda nga Simbahan kag ang tanan nga kagamitan sini: ang mga kaw-it, mga dingding, mga pangbalabag sa dingding, mga haligi, mga pundasyon; ");
INSERT INTO hil_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ang tabon nga hinimo halin sa mga panit sang lalaki nga mga karnero nga ginlugom sa pula, ang tabon nga hinimo halin sa maayo nga klase sang panit, ang mga kurtina; ");
INSERT INTO hil_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ang Kahon sang Kasuguan kag ang iya tabon kag mga tukon nga pangtuwang; ");
INSERT INTO hil_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ang lamisa kag ang tanan nga kagamitan sini; ang tinapay nga ginahalad sa presensya sang Dios; ");
INSERT INTO hil_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ang bulutangan sang suga nga puro bulawan kag ang nagaraya nga mga suga kag kagamitan sini; ang lana para sa mga suga; ");
INSERT INTO hil_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ang halaran nga bulawan; ang lana nga inughaplas; ang mahamot nga insenso; ang kurtina sang puwertahan sang Tolda; ");
INSERT INTO hil_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ang halaran nga saway kag ang iya sini parilyahan nga saway, ang iya mga tukon nga pangtuwang, kag ang tanan nga kagamitan sini; ang labador kag ang iya tulungtungan; ");
INSERT INTO hil_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ang mga kurtina sa palibot sang ugsaran kag ang iya sini mga haligi kag mga pundasyon; ang kurtina sa puwertahan sang ugsaran; ang mga higot kag mga palpal para sa kurtina sang ugsaran; ang tanan nga kagamitan sang Tolda nga Simbahan, nga ginatawag man nga Tolda nga Ginapakigkitaan; ");
INSERT INTO hil_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","kag ang matahom kag balaan nga mga panapton sang pari nga si Aaron kag sang iya mga anak nga lalaki, nga ila suksukon kon mag-alagad sila bilang mga pari sa Balaan nga Lugar. ");
INSERT INTO hil_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ginhimo sang mga Israelinhon ang tanan nga buluhaton suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Gintan-aw ni Moises ang ila obra, kag nakita niya nga ginhimo nila ini tanan suno sa ginsugo sang Ginoo. Gani ginbendisyunan sila ni Moises. ");
INSERT INTO hil_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Dayon nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Iplastar ang Tolda nga Simbahan, nga ginatawag man nga Tolda nga Ginapakigkitaan, sa nahauna nga adlaw sang nahauna nga bulan. ");
INSERT INTO hil_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ipasulod didto ang Kahon sang Kasuguan, kag lipdi ini sang kurtina. ");
INSERT INTO hil_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ipasulod mo man didto ang lamisa kag iplastar ang mga kagamitan sini. Ipasulod mo man ang bulutangan sang suga kag ibutang ang mga suga sini. ");
INSERT INTO hil_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ibutang ang bulawan nga halaran nga sulunugan sang insenso sa atubangan sang Kahon sang Kasuguan, kag itakod ang kurtina sa puwertahan sang Tolda nga Simbahan. ");
INSERT INTO hil_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Ibutang ang halaran sang halad nga ginasunog sa atubangan sang puwertahan sang Tolda nga Simbahan. ");
INSERT INTO hil_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ibutang ang labador sa tunga-tunga sang Tolda kag sang halaran, kag sudli ini sang tubig. ");
INSERT INTO hil_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ibutang ang mga kurtina sang ugsaran, nga nagapalibot sa Tolda, pati ang kurtina sang puwertahan sang ugsaran. ");
INSERT INTO hil_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Dayon kuhaa ang lana kag haplasi ang Tolda kag ang tanan nga kagamitan sini sa pagdedikar sini sa akon, kag mangin sagrado ini. ");
INSERT INTO hil_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Haplasi man ang halaran sang halad nga ginasunog kag ang tanan nga kagamitan sini sa pagdedikar sini sa akon, kag mangin sagrado gid ini. ");
INSERT INTO hil_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Haplasi man ang labador kag ang iya tulungtungan sa pagdedikar sini sa akon. ");
INSERT INTO hil_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Dal-a si Aaron kag ang iya mga anak nga lalaki sa puwertahan sang Tolda nga Ginapakigkitaan kag papaligua sila didto. ");
INSERT INTO hil_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Dayon ipasuksok kay Aaron ang iya balaan nga mga bayo kag idedikar siya sa akon paagi sa paghaplas sa iya sang lana para makaalagad siya sa akon bilang pari. ");
INSERT INTO hil_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Dal-a man ang iya mga anak kag ipasuksok sa ila ang ila pangsulod nga bayo. ");
INSERT INTO hil_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Haplasi man sila sang lana pareho sa ginhimo mo sa ila amay, para makaalagad man sila sa akon bilang mga pari hasta sa palaabuton nga henerasyon.” ");
INSERT INTO hil_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Ginhimo ni Moises ang tanan nga ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Gani ginpatindog ang Tolda nga Simbahan sang nahauna nga adlaw sang nahauna nga bulan. Ikaduha ato nga tuig halin sang pagguwa nila sa Egypt. ");
INSERT INTO hil_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Amo ini ang pagpatindog ni Moises sang Tolda: Gintakod niya ang mga pundasyon sini, ang mga dingding, ang mga pangbalabag sa dingding, kag ang mga haligi. ");
INSERT INTO hil_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Dayon ginhumlad niya ang Tolda, kag ginsampawan pa gid niya sang tabon. Ginhimo niya ini tanan suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Dayon ginsulod niya sa Kahon ang malapad nga bato nga ginsulatan sang Kasuguan, kag gin-gulo niya sa mga sulosingsing sang Kahon ang mga tukon nga pangtuwang, kag gintabunan ini. ");
INSERT INTO hil_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Dayon ginsulod niya ang Kahon sa Tolda nga Simbahan, kag gintakod niya ang kurtina para malipdan ang Kahon sang Kasuguan, suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ginbutang niya ang lamisa sa sulod sang Tolda, sa north dampi, sa guwa lang sang kurtina. ");
INSERT INTO hil_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Dayon ginbutang niya sa lamisa ang tinapay nga ginahalad sa presensya sang Ginoo. Ginhimo niya ini tanan suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ginbutang man niya ang bulutangan sang suga didto sa sulod sang Tolda, sa atubangan sang lamisa, sa south dampi. ");
INSERT INTO hil_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Kag ginbutang niya ang mga suga sini didto sa presensya sang Ginoo. Ginhimo niya ini tanan suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ginbutang man niya ang bulawan nga halaran sa sulod sang Tolda, sa atubangan sang kurtina, ");
INSERT INTO hil_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","kag nagsunog siya sang mahamot nga insenso sa halaran. Ginhimo niya ini tanan suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Gintakod man niya ang kurtina sa puwertahan sang Tolda. ");
INSERT INTO hil_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Kag ginbutang niya didto malapit sa puwertahan ang halaran sang halad nga ginasunog. Dayon naghalad siya sa sini nga halaran sang mga halad nga ginasunog kag mga halad nga regalo. Ginhimo niya ini tanan suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ginbutang man niya ang labador sa tunga-tunga sang Tolda kag sang halaran, kag ginsudlan niya sang tubig para hilinawan. ");
INSERT INTO hil_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Didto nagapanghinaw si Moises, si Aaron kag ang iya mga anak nga lalaki sang ila mga kamot kag tiil. ");
INSERT INTO hil_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Nagapanghinaw sila kon magsulod sila sa Tolda ukon magpalapit sa halaran. Ginhimo nila ini tanan suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Dayon ginbutang ni Moises ang mga kurtina sang ugsaran, nga nagapalibot sa Tolda kag sa halaran, pati ang kurtina sang puwertahan sang ugsaran. Kag natapos gid ni Moises ang tanan nga buluhaton. ");
INSERT INTO hil_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Pagkatapos sini tanan, ang gamhanan nga presensya sang Ginoo naglikop sa Tolda nga Ginapakigkitaan sa dagway sang panganod. ");
INSERT INTO hil_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Indi makasulod si Moises sa Tolda tungod kay nalikupan ini sang gamhanan nga presensya sang Ginoo sa dagway sang panganod. ");
INSERT INTO hil_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Kon mag-alsa na gani ang panganod sa ibabaw sang Tolda kag maghalin, nagahalin man ang mga Israelinhon sa ila ginakampuhan. ");
INSERT INTO hil_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Kon indi gani maghalin ang panganod, indi man sila maghalin. ");
INSERT INTO hil_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ang panganod nga nagasimbolo sang presensya sang Ginoo ara sa ibabaw sang Tolda kon adlaw, kag kon gab-i may kalayo sa panganod para makita ini sang tanan nga Israelinhon sa ila nga pagpanglakaton.");
INSERT INTO hil_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","2","Gintawag sang Ginoo si Moises kag ginhambalan didto sa Tolda nga Ginapakigkitaan. Ginsugo niya si Moises nga ihambal ini sa mga Israelinhon: Kon may ara sa inyo nga maghalad sang sapat sa Ginoo, maghalad siya sang baka, karnero, ukon kanding. ");
INSERT INTO hil_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Kon baka ang iya ihalad bilang halad nga ginasunog, kinahanglan nga lalaki ini nga wala sing deperensya, kag ihalad niya ini didto dampi sa puwertahan sang Tolda nga Ginapakigkitaan, agod paagi sa sini nga halad batunon siya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Itungtong niya ang iya kamot sa ulo sang baka nga iya ginahalad, kag batunon ini sang Ginoo para matubos siya sa iya mga sala. ");
INSERT INTO hil_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Dayon ihawon niya ang ini nga sapat sa presensya sang Ginoo. Kag ang dugo sini iwisik-wisik sang mga pari nga kaliwat ni Aaron didto sa palibot sang halaran, nga ara dampi sa puwertahan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Dayon panitan sang manughalad ang sapat kag hiwa-hiwaon. ");
INSERT INTO hil_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Pagkatapos, ang mga pari nga kaliwat ni Aaron magpadukot sang kalayo sa halaran kag gatungan nila ini sang mga kahoy nga naplastar sing maayo. ");
INSERT INTO hil_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Kag dayon iplastar nila sa kalayo ang hiniwa nga mga parte sang sapat, pati ang ulo kag ang mga tambok. ");
INSERT INTO hil_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Dapat hugasan anay sang manughalad ang kasudlan kag ang mga tiil sini. Kag ang pari amo na ang magsunog sini tanan sa halaran bilang halad nga ginasunog. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Kon karnero ukon kanding ang ihalad sang tawo bilang halad nga ginasunog, kinahanglan nga lalaki ini nga wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ihawon niya ini sa presensya sang Ginoo didto sa north sang halaran. Kag ang dugo sini iwisik-wisik sang mga pari nga kaliwat ni Aaron didto sa palibot sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Pagkatapos nga mahiwa-hiwa ini sang manughalad, iplastar sang pari ini nga mga hiniwa sa kalayo, pati ang ulo kag ang mga tambok. ");
INSERT INTO hil_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Dapat hugasan anay sang manughalad ang kasudlan kag ang mga tiil sini. Kag ang pari amo na ang magasunog sini tanan sa halaran bilang halad nga ginasunog. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Kon pispis ang ihalad sang tawo bilang halad nga ginasunog, kinahanglan nga pating ini ukon tukmo. ");
INSERT INTO hil_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Dal-on ini sang pari sa halaran, lubagon niya ang liog hasta nga mautod, kag patuluon niya ang dugo sini sa kilid sang halaran. Dayon sunugon niya ang ulo sa halaran. ");
INSERT INTO hil_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Kuhaon niya ang balonbalunan pati ang mga kinaon sini kag ihaboy niya dayon sa east sang halaran nga sa diin ginabutang ang abo. ");
INSERT INTO hil_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Pihakon niya ang pispis paagi sa paghitad sang pakpak sini pero indi lang niya pagbitason ang pakpak. Dayon sunugon niya ang pispis sa halaran bilang halad nga ginasunog. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Kon may maghalad sang halad nga regalo sa Ginoo, gamiton niya ang maayo nga klase nga harina. Butangan niya ini sang mantika kag sang insenso. ");
INSERT INTO hil_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Dal-on niya ini sa mga pari nga kaliwat ni Aaron. Dayon buhinan sang pari sing isa ka hakop ang ginmiksla nga harina kag mantika, kag ang iya ginbuhin sunugon niya sa halaran lakip ang tanan nga insenso nga ginbutang didto sa harina. Sunugon niya ini bilang pagdumdom sa Ginoo. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ang nabilin nga harina iya na ni Aaron kag sang iya mga kaliwat, kag balaan gid ini tungod nga parte ini sang halad nga paagi sa kalayo nga ginhalad sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Kon may maghalad sang tinapay nga ginluto sa pugon bilang halad nga regalo, kinahanglan nga ginhimo ini halin sa maayo nga klase nga harina kag wala ginbutangan sing inugpahabok. Puwede nga ihalad ang madamol nga tinapay nga ginmikslahan sang mantika ukon ang manipis nga tinapay nga ginlamhitan sang mantika. ");
INSERT INTO hil_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kon ang tinapay nga ihalad ginluto sa sartin, kinahanglan nga ginhimo ini halin sa maayo nga klase nga harina kag ginmikslahan sang mantika, pero wala ginbutangan sing inugpahabok. ");
INSERT INTO hil_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Pihak-pihakon ini kag butangan sang mantika. Halad ini nga regalo. ");
INSERT INTO hil_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kon ang tinapay nga ihalad ginluto sa kalaha, kinahanglan nga ginhimo man ini halin sa maayo nga klase nga harina kag ginmikslahan man sang mantika. ");
INSERT INTO hil_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Dal-a ang ini nga klase sang mga halad sa pari para ihalad sa Ginoo didto sa halaran. ");
INSERT INTO hil_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Buhinan ini sang pari, kag ang iya ginbuhin sunugon niya sa halaran bilang pagdumdom sa Ginoo. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ang nabilin sa sini nga halad iya na ni Aaron kag sang iya mga kaliwat, kag balaan gid ini tungod nga parte ini sang halad nga paagi sa kalayo nga ginhalad sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Ang tanan nga halad nga regalo nga ginahalad sa Ginoo kinahanglan nga wala sing inugpahabok, kay indi kamo dapat magsunog sang inugpahabok ukon honey sa inyo paghalad sa Ginoo sang halad nga paagi sa kalayo. ");
INSERT INTO hil_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Puwede ninyo ihalad ang inugpahabok ukon honey bilang halad halin sa nahauna nga parte sang inyo patubas, pero indi ini dapat pagsunugon sa halaran. ");
INSERT INTO hil_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Asini ang tanan ninyo nga halad nga regalo, kay ang asin simbolo sang inyo wala sing katapusan nga kasugtanan sa inyo Dios. Asini ang tanan ninyo nga halad. ");
INSERT INTO hil_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Kon maghalad kamo halin sa inyo una nga patubas bilang regalo sa Ginoo, maghalad kamo sang ginaling nga mga uyas nga ginsanlag. ");
INSERT INTO hil_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Butangan ninyo ini sang mantika kag insenso. Halad ini nga regalo. ");
INSERT INTO hil_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Sunugon sang pari ang iban nga ginaling nga may mantika, lakip ang tanan nga insenso nga ginbutang didto sa ginaling, bilang pagdumdom sa Ginoo. Halad ini nga paagi sa kalayo para sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Kon may maghalad sang baka nga lalaki ukon babayi bilang halad nga para sa maayo nga relasyon, kinahanglan ang iya ihalad sa presensya sang Ginoo wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Itungtong niya ang iya kamot sa ulo sang baka, kag ihawon niya ini didto dampi sa puwertahan sang Tolda nga Ginapakigkitaan. Ang dugo sini iwisik-wisik sang mga pari nga kaliwat ni Aaron didto sa palibot sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Halin sa sina nga halad, magkuha ang pari sang ihalad niya sa Ginoo bilang halad nga paagi sa kalayo. Ang iya kuhaon amo ang tanan nga sapay sa kasudlan, ");
INSERT INTO hil_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ang mga batobato pati ang mga tambok sini, kag ang gamay nga parte sang atay. ");
INSERT INTO hil_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Dayon sunugon ini sang mga pari nga kaliwat ni Aaron sa halaran upod sa halad nga ginasunog. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Kon karnero ukon kanding ang iya ihalad para sa maayo nga relasyon sa Ginoo, kinahanglan nga lalaki ini ukon babayi nga wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kon karnero ang iya ihalad sa presensya sang Ginoo, ");
INSERT INTO hil_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","itungtong niya ang iya kamot sa ulo sang karnero kag ihawon niya ini didto sa atubangan sang Tolda nga Ginapakigkitaan. Ang dugo sini iwisik-wisik sang mga pari nga kaliwat ni Aaron didto sa palibot sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Halin sa sina nga halad, magkuha ang pari sang ihalad niya sa Ginoo bilang halad nga paagi sa kalayo. Ang iya kuhaon amo ang mga tambok, ang matambok nga ikog nga suop ang pagkautod, ang tanan nga sapay sa kasudlan, ");
INSERT INTO hil_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ang mga batobato pati ang mga tambok sini, kag ang gamay nga parte sang atay. ");
INSERT INTO hil_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Sunugon ini tanan sang pari sa halaran bilang halad nga pagkaon. Halad ini nga paagi sa kalayo para sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Kon kanding ang iya ihalad sa presensya sang Ginoo, ");
INSERT INTO hil_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","itungtong niya ang iya kamot sa ulo sang kanding kag ihawon niya ini didto sa atubangan sang Tolda nga Ginapakigkitaan. Ang dugo sini iwisik-wisik sang mga pari nga kaliwat ni Aaron didto sa palibot sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Halin sa sina nga halad, magkuha ang pari sang ihalad niya sa Ginoo bilang halad nga paagi sa kalayo. Ang iya kuhaon amo ang tanan nga sapay sa kasudlan, ");
INSERT INTO hil_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ang mga batobato pati ang mga tambok sini, kag ang gamay nga parte sang atay. ");
INSERT INTO hil_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Sunugon ini tanan sang pari sa halaran bilang halad nga pagkaon. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa Ginoo. Ang tanan nga tambok iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Indi kamo magkaon sang tambok ukon dugo. Ini nga pagsulundan dapat tumanon ninyo hasta sa palaabuton nga mga henerasyon, bisan diin kamo mag-estar. ");
INSERT INTO hil_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","2","Nagsugo pa gid ang Ginoo kay Moises nga hambalon ang mga Israelinhon nga ang bisan sin-o nga nakalapas sang iya nga sugo nga indi hungod, kinahanglan amo ini ang iya himuon: ");
INSERT INTO hil_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Kon ang pangulo nga pari nakasala nga indi niya hungod, kag tungod sini nadalahig ang mga tawo, maghalad siya sa Ginoo sang bataon nga baka nga wala sing deperensya bilang halad sa pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Dal-on niya ang baka sa presensya sang Ginoo didto dampi sa puwertahan sang Tolda nga Ginapakigkitaan. Itungtong niya ang iya kamot sa ulo sang baka kag ihawon niya ini. ");
INSERT INTO hil_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Dayon magkuha ang pangulo nga pari sang dugo sang sadto nga baka kag dal-on niya sa sulod sang Tolda. ");
INSERT INTO hil_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Itum-oy niya ang iya tudlo sa dugo kag iwisik-wisik ini sing makapito ka beses sa atubangan sang kurtina nga nagatabon sa Labing Balaan nga Lugar, didto sa presensya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Dayon lamhitan niya sang dugo ang mga sulosungay sa mga corner sang halaran nga sulunugan sang insenso didto sa presensya sang Ginoo sa sulod sang Tolda. Ang nabilin nga dugo sang baka iula niya sa idalom sang halaran sang halad nga ginasunog. Ini nga halaran ara dampi sa puwertahan sang Tolda. ");
INSERT INTO hil_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Dayon kuhaon niya ang tanan nga sapay sa kasudlan sang baka, ");
INSERT INTO hil_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ang mga batobato pati ang mga tambok sini, kag ang gamay nga parte sang atay. ");
INSERT INTO hil_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","(Amo man ini ang ginahimo sa sapat nga halad para sa maayo nga relasyon.) Dayon sunugon ini tanan sang pari sa halaran sang halad nga ginasunog. ");
INSERT INTO hil_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","Pero ang nabilin nga parte sang sapat, pareho sang panit, unod, ulo, mga tiil, kag ang kasudlan pati na ang sa sulod sang tinai, dal-on niya sa guwa sang kampo kag sunugon sa nagakalayo nga kahoy, didto sa lugar nga ginakabig nga matinlo nga ginaulaan sang abo. ");
INSERT INTO hil_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Kon ang bilog nga komunidad sang Israel nakalapas sa sugo sang Ginoo, pero indi nila hungod, nakasala gihapon sila bisan pa wala sila kahibalo sini. ");
INSERT INTO hil_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Kon mahibaluan na nila nga nakasala gali sila, ang komunidad maghalad sang bataon nga baka bilang halad sa pagpakatinlo. Dal-on nila ini nga baka didto sa Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Dayon itungtong sang mga manugdumala sang mga Israelinhon ang ila mga kamot sa ulo sang baka kag ihawon dayon nila ini sa presensya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Dayon magkuha ang pangulo nga pari sang dugo sang sadto nga baka kag dal-on niya sa sulod sang Tolda. ");
INSERT INTO hil_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Itum-oy niya ang iya tudlo sa dugo kag iwisik-wisik ini sing makapito ka beses sa kurtina nga nagatabon sa Labing Balaan nga Lugar, didto sa presensya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Dayon lamhitan niya sang dugo ang mga sulosungay sang halaran didto sa presensya sang Ginoo sa sulod sang Tolda. Ang nabilin nga dugo iula niya sa idalom sang halaran sang halad nga ginasunog. Ini nga halaran ara dampi sa puwertahan sang Tolda. ");
INSERT INTO hil_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","21","Kag himuon man niya sa sini nga baka ang pareho sa iya ginhimo sa sadto nga baka nga halad sa pagpakatinlo. Kuhaon niya ang tanan nga tambok sang baka kag sunugon sa halaran, kag dayon sunugon niya ang baka sa guwa sang kampo. Paagi sa sining himuon sang pangulo nga pari, matubos ang mga Israelinhon sa ila nga sala kag patawaron sila sang Ginoo. Amo ini ang halad sa pagpakatinlo para sa komunidad sang Israel. ");
INSERT INTO hil_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Kon ang isa ka pangulo nakalapas sa sugo sang Ginoo nga iya Dios, pero indi niya hungod, nakasala gihapon siya. ");
INSERT INTO hil_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Kon mahibaluan na niya nga nakasala gali siya, maghalad siya sang lalaki nga kanding nga wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Halad ini para sa iya nga pagpakatinlo. Itungtong niya ang iya kamot sa ulo sang kanding kag ihawon niya ini didto sa presensya sang Ginoo, sa may lugar nga ginaihawan man sang mga sapat nga bilang halad nga ginasunog. ");
INSERT INTO hil_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Dayon itum-oy sang pari ang iya tudlo sa dugo sang kanding kag ilamhit niya ini sa mga sulosungay sang halaran sang halad nga ginasunog. Ang nabilin nga dugo iula niya sa idalom sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Sunugon niya ang tanan nga tambok sa halaran pareho sa ginahimo sa tambok sang sapat nga halad para sa maayo nga relasyon. Paagi sa sining himuon sang pari, matubos ang amo nga pangulo sa iya nga sala kag patawaron siya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Kon ang isa sa inyo nakalapas sa sugo sang Ginoo, pero indi niya hungod, nakasala gihapon siya. ");
INSERT INTO hil_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Kon mahibaluan na niya nga nakasala gali siya, maghalad siya sang babayi nga kanding nga wala sing deperensya para sa sala nga iya nahimo. ");
INSERT INTO hil_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Itungtong niya ang iya kamot sa ulo sang sining halad sa pagpakatinlo, kag ihawon niya ini didto sa Tolda, sa may lugar nga ginaihawan man sang mga sapat nga bilang halad nga ginasunog. ");
INSERT INTO hil_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Dayon itum-oy sang pari ang iya tudlo sa dugo sang kanding kag ilamhit niya ini sa mga sulosungay sang halaran sang halad nga ginasunog. Ang nabilin nga dugo iula niya sa idalom sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Dayon kuhaon niya ang tanan nga tambok sang kanding pareho sa ginahimo sa sapat nga halad para sa maayo nga relasyon. Pagkatapos sunugon niya ang tambok sa halaran bilang mahamot nga halad nga makapalipay sa Ginoo. Paagi sa sining himuon sang pari, matubos ang tawo sa iya nga sala kag patawaron siya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Kon karnero ang ihalad sang tawo para sa iya pagpakatinlo, kinahanglan nga babayi ini nga wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Itungtong niya ang iya kamot sa ulo sang karnero kag ihawon ini didto sa Tolda, sa may lugar nga ginaihawan man sang mga sapat nga bilang halad nga ginasunog. ");
INSERT INTO hil_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Dayon itum-oy sang pari ang iya kamot sa dugo sang karnero kag ilamhit niya ini sa mga sulosungay sang halaran sang halad nga ginasunog. Ang nabilin nga dugo iula niya sa idalom sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Dayon kuhaon niya ang tanan nga tambok sang karnero pareho sa ginahimo sa karnero nga halad para sa maayo nga relasyon. Pagkatapos sunugon niya ang tambok sa halaran upod sa iban pa nga mga halad nga paagi sa kalayo para sa Ginoo. Paagi sa sining himuon sang pari, matubos ang tawo sa iya nga sala kag patawaron siya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Kon ang isa ka tawo indi magsugid sa korte parte sa mga butang nga iya nakita ukon nahibaluan, may salabton siya. ");
INSERT INTO hil_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Kon may ara nga nakatandog sang bisan ano nga butang nga ginakabig nga mahigko, pareho sang patay nga lawas sang mahigko nga mga sapat, nakasala siya kag nangin mahigko siya, bisan wala niya nahibaluan nga nakatandog gali siya. ");
INSERT INTO hil_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Kon nakatandog siya sang mahigko nga mga butang sang tawo nga wala niya mahibalui, nga tungod sini nangin mahigko siya, nakasala siya kon mahibaluan na niya ini. ");
INSERT INTO hil_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Kon ang isa ka tawo nagpanumpa nga pasapayan nga wala niya ginahunahuna, kag bisan maayo man ukon malain ang iya ginsumpa nga himuon, nakasala siya kon mahibaluan na niya ang iya ginhimo. ");
INSERT INTO hil_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Kon nahibaluan sang tawo nga nakasala siya sa bisan diin sa sina nga mga butang, kinahanglan nga ituad niya ini. ");
INSERT INTO hil_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Kag bilang bayad sa sala nga iya nahimo, maghalad siya sa Ginoo sang isa ka babayi nga karnero ukon kanding bilang halad sa pagpakatinlo. Ihalad ini sang pari para matubos siya sa iya nga sala. ");
INSERT INTO hil_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Pero kon indi siya makasarang maghalad sang karnero ukon kanding, maghalad na lang siya sang duha ka pating ukon duha ka tukmo sa Ginoo bilang bayad niya sa iya nga sala: ang isa halad sa pagpakatinlo kag ang isa halad nga ginasunog. ");
INSERT INTO hil_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Dal-on niya ini sa pari kag unahon halad sang pari ang halad sa pagpakatinlo. Lubagon sang pari ang liog sini, pero indi lang niya pag-utdon. ");
INSERT INTO hil_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Kag iwisik-wisik niya ang iban nga dugo sini sa kilid sang halaran, kag ang nabilin nga dugo iula niya sa idalom sang halaran. Halad ini sa pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ihalad man dayon sang pari ang isa pa ka halad nga ginasunog, suno sa paagi sang paghalad sini. Paagi sa sining himuon sang pari, matubos ang tawo sa iya nga sala kag patawaron siya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Pero kon indi siya makasarang maghalad sang duha ka pating ukon duha ka tukmo, maghalad na lang siya sang duha ka kilo nga harina nga maayo nga klase. Kinahanglan nga indi niya ini pagbutangan sang mantika kag insenso kay halad ini sa pagpakatinlo, kag indi halad nga regalo. ");
INSERT INTO hil_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Dal-on niya ini sa pari kag buhinan ini sang pari sing isa ka hakop bilang pagdumdom sa Ginoo. Ang iya ginbuhin sunugon niya sa halaran upod sa iban pa nga mga halad sa Ginoo nga paagi sa kalayo. Halad ini sa pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Paagi sa sining himuon sang pari, matubos ang tawo sa bisan diin sadto nga mga sala nga iya nahimo kag patawaron siya sang Ginoo. Ang nabilin nga halad nga harina iya na sang pari, pareho man sa ginahimo sa halad nga regalo. ");
INSERT INTO hil_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Naghatag pa gid ang Ginoo sang sini nga mga sugo kay Moises: ");
INSERT INTO hil_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Kon naglapas ang isa ka tawo tungod kay wala niya mahatag ang butang nga para kuntani sa Ginoo, bisan indi niya hungod, kinahanglan nga maghalad siya sang lalaki nga karnero nga wala sing deperensya bilang halad nga bayad sa iya nga sala. Ukon bayaran niya sang pilak ang bili sang karnero suno sa kabug-aton sang pilak sa kilohan sang mga pari. Halad ini nga bayad sa sala. ");
INSERT INTO hil_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Kinahanglan nga bayaran niya ang wala niya mahatag para sa Ginoo, kag dugangan pa gid niya sing 20 porsiyento sang bili sini. Dayon ihatag niya ini tanan sa pari nga amo ang maghalad sang karnero bilang halad nga bayad sa sala, para matubos siya kag patawaron sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Kon ang isa ka tawo naglapas sa sugo sang Ginoo nga wala niya mahibalui, nakasala siya kag may salabton siya sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","19","Kon mahibaluan na niya nga nakasala siya, kinahanglan nga magdala siya sa pari sang lalaki nga karnero nga wala sing deperensya bilang halad nga bayad sa sala. Ukon bayaran niya sang pilak ang bili sang karnero suno sa kabug-aton sang pilak sa kilohan sang mga pari. Paagi sa sining himuon sang pari, matubos ang tawo sa iya sala nga nahimo nga indi hungod kag patawaron siya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Amo ini ang ginsiling sang Ginoo kay Moises ");
INSERT INTO hil_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","parte sa tawo nga naglapas sa luyag sang Ginoo paagi sa pagpangdaya sa iya kapareho parte sa butang nga ginpatago ukon ginbilin sa iya, ukon pagkawat sa sini nga mga butang, ukon pagpanguwarta, ");
INSERT INTO hil_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ukon pagbutig parte sa butang nga nadula nga wala niya kuno nakita, ukon pagpanumpa sang indi matuod nga wala niya nahimo ang bisan diin sa sini nga mga sala. ");
INSERT INTO hil_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Kon mapamatud-an nga nakasala siya, kinahanglan nga iuli niya ang iya kinawat, ukon ang iya nakuha paagi sa pagpangdaya, ukon ang mga butang nga ginbilin ukon ginpatago sa iya, ukon ang mga butang nga nadula nga iya nakita, ");
INSERT INTO hil_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ukon ang bisan ano nga mga butang nga suno sa iya pagpanumpa wala sa iya, pero ang matuod ara. Kinahanglan nga iuli niya ini sa tag-iya nga wala gid sing kulang, kag dugangan pa gid niya sang 20 porsiyento sang bili sini. Ihatag niya ini sa tag-iya sa adlaw nga maghalad siya sang halad nga bayad sa iya nga sala. ");
INSERT INTO hil_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Magdala siya sa pari sang isa ka lalaki nga karnero nga wala sing deperensya, kag ihalad niya ini sa Ginoo bilang halad nga bayad sa iya nga sala. Ukon bayaran niya sang pilak ang bili sang karnero suno sa kabug-aton sang pilak sa kilohan sang mga pari. ");
INSERT INTO hil_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Paagi sa sining himuon sang pari sa presensya sang Ginoo, matubos ang tawo sa iya nga sala, kag patawaron siya sang Ginoo bisan diin man sa sadto nga mga sala nga iya nahimo. ");
INSERT INTO hil_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","9","Ginsugo sang Ginoo si Moises nga sugiran si Aaron kag ang iya mga anak nga lalaki sang sini nga mga pagsulundan parte sa halad nga ginasunog: Ang ini nga halad kinahanglan nga ibilin sa halaran hasta mag-aga, kag kinahanglan nga padayon ang pagdabdab sang kalayo sa halaran. ");
INSERT INTO hil_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Isuksok sang pari ang iya pangguwa nga bayo nga linen, pati ang iya pang-idalom nga panapton nga linen nga nagatabon sang iya kinatawo, kag kuhaon niya ang abo sang sini nga halad kag ibutang sa kilid sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Pagkatapos ilisan niya ang iya bayo kag dal-on niya ang abo sa guwa sang kampo, sa lugar nga ginakabig nga matinlo. ");
INSERT INTO hil_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Kinahanglan nga padayon ang pagdabdab sang kalayo sa halaran; indi gid ini pagpatyon. Kada aga gatungan ini sang pari, kag iplastar niya sing maayo sa kalayo ang halad nga ginasunog. Ilakip man niya sa pagsunog ang mga tambok sang sapat nga ginahalad para sa maayo nga relasyon. ");
INSERT INTO hil_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Kinahanglan nga padayon gid ang pagdabdab sang kalayo sa halaran; indi gid ini pagpatyon. ");
INSERT INTO hil_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Amo ini ang mga pagsulundan parte sa halad nga regalo: Ang mga pari nga kaliwat ni Aaron amo ang magadala sini sa presensya sang Ginoo didto sa atubangan sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Buhinan sang pari sing isa ka hakop ining halad nga harina nga may mantika, kag ang iya ginbuhin sunugon niya sa halaran lakip ang tanan nga insenso nga ginbutang didto sa harina. Sunugon niya ini bilang pagdumdom sa Ginoo. Ang kahamot sang sini nga halad makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","17","Ang nabilin nga harina lutuon kag kaunon ni Aaron kag sang iya mga kaliwat. Pero lutuon nila ini nga wala sing inugpahabok, kag kaunon nila didto sa ugsaran sang Tolda nga Ginapakigkitaan, nga isa ka balaan nga lugar. Ginhatag ini sang Ginoo sa ila bilang ila parte sa mga halad nga paagi sa kalayo. Ang halad nga regalo balaan gid pareho sang halad sa pagpakatinlo kag sang halad nga bayad sa sala. ");
INSERT INTO hil_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Ang tanan nga lalaki nga kaliwat ni Aaron makakaon sang ila parte sa mga halad nga paagi sa kalayo. Para gid ina sa ila hasta sa palaabuton nga mga henerasyon, kag magapabilin ini nga pagsulundan hasta san-o. Ang nagauyat sini nga mga halad dapat balaan. ");
INSERT INTO hil_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Amo ini ang ginsiling sang Ginoo kay Moises ");
INSERT INTO hil_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","parte sa halad nga para sa Ginoo nga ihalad ni Aaron sa adlaw nga ordinahan siya bilang pangulo nga pari, kag amo man ang himuon sang iya kaliwat nga magabulos sa iya: Maghalad siya sang duha ka kilo nga harina nga maayo nga klase. Halad ini nga regalo nga dapat himuon hasta san-o. Ang katunga sini ihalad niya sa aga kag ang katunga sa sirom. ");
INSERT INTO hil_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Ang ini nga harina mikslahon sa mantika kag lutuon sa sartin. Kag kon luto na, pihak-pihakon ini kag ihalad sa Ginoo bilang halad nga regalo. Ang kahamot sini nga halad makapalipay sa iya. ");
INSERT INTO hil_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Kag kinahanglan nga sunugon ini tanan, kay ini nga halad para sa Ginoo, kag dapat nga tumanon hasta san-o. Dapat himuon ini sang kaliwat ni Aaron nga magabulos sa iya bilang pangulo nga pari. ");
INSERT INTO hil_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ang tanan nga halad nga regalo sang pari kinahanglan nga sunugon tanan; indi gid ini pagkaunon. ");
INSERT INTO hil_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Ginsugo naman sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","nga sugiran si Aaron kag ang iya mga anak nga lalaki sang sini nga mga pagsulundan: Ang halad sa pagpakatinlo kinahanglan nga ihawon sa presensya sang Ginoo didto sa lugar nga ginaihawan sang halad nga ginasunog. Ang halad sa pagpakatinlo balaan gid nga halad. ");
INSERT INTO hil_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ang pari nga maghalad sini kinahanglan nga magkaon sini sa ugsaran sang Tolda nga Ginapakigkitaan, nga isa ka balaan nga lugar. ");
INSERT INTO hil_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ang nagauyat sini nga halad dapat balaan. Ang bayo nga maagsikan sang dugo sang sini nga halad kinahanglan nga labhan sa balaan nga lugar didto sa Tolda. ");
INSERT INTO hil_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Kinahanglan nga buk-on ang kolon nga ginpabukalan sang amo nga halad, pero kon ginpabukalan ini sa kaldero kiskisan ini nga kaldero kag hugasan sang tubig. ");
INSERT INTO hil_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Makakaon sini nga halad ang tanan nga lalaki sa pamilya sang mga pari. Balaan gid ang ini nga halad. ");
INSERT INTO hil_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Pero kon ang dugo sang sini nga halad gindala sa Balaan nga Lugar, didto sa sulod sang Tolda, para matubos ang sala sang isa ka tawo, indi gid pagkaunon ang ina nga halad kundi sunugon. ");
INSERT INTO hil_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Amo ini ang mga pagsulundan parte sa halad nga bayad sa sala, nga balaan gid nga halad: ");
INSERT INTO hil_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ang halad nga bayad sa sala pagaihawon didto sa ginaihawan sang halad nga ginasunog. Kag ang dugo sini iwisik-wisik sa palibot sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ang tanan nga tambok sini ihalad: ang matambok nga ikog, ang mga sapay sa kasudlan, ");
INSERT INTO hil_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ang mga batobato pati ang mga tambok sini, kag ang gamay nga parte sang atay. ");
INSERT INTO hil_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Ini tanan sunugon sang pari sa halaran bilang halad nga paagi sa kalayo para sa Ginoo. Halad ini nga bayad sa sala. ");
INSERT INTO hil_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Makakaon sang nabilin nga mga parte sang sini nga halad ang tanan nga lalaki sa pamilya sang mga pari, pero kinahanglan nga kaunon nila ini didto sa balaan nga lugar, kay balaan gid ini. ");
INSERT INTO hil_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Pareho lang ang pagsulundan parte sa halad sa pagpakatinlo kag sa halad nga bayad sa sala: ang karne sang sini nga mga halad iya na sang pari nga naghalad sini. ");
INSERT INTO hil_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ang panit sang sapat nga bilang halad nga ginasunog iya man sang pari nga naghalad sini. ");
INSERT INTO hil_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Pareho man sa tanan nga halad nga regalo, nga ginluto sa pugon ukon ginluto sa kalaha ukon sa sartin, iya na man ini sang pari nga naghalad sini. ");
INSERT INTO hil_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ang tanan nga halad nga regalo, nga ginmikslahan sang mantika ukon wala, iya na sang mga pari nga kaliwat ni Aaron kag partidahon nila ini sang palareho. ");
INSERT INTO hil_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Amo ini ang mga pagsulundan parte sa halad nga para sa maayo nga relasyon nga ginahalad sa Ginoo: ");
INSERT INTO hil_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Kon ang sapat nga halad para sa maayo nga relasyon ihalad sang tawo bilang pagpasalamat sa Ginoo, parisan niya ini sang tinapay. Magdala siya sang tinapay nga wala sing inugpahabok: tinapay nga madamol nga ginmikslahan sang mantika, tinapay nga manipis nga ginlamhitan sang mantika, kag tinapay nga hinimo halin sa maayo nga klase nga harina nga ginmikslahan sang mantika. ");
INSERT INTO hil_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Kag dugang pa sa sini, magdala man siya sang tinapay nga may inugpahabok. ");
INSERT INTO hil_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Maghalad siya sang kada klase sang sini nga mga tinapay bilang espesyal nga regalo sa Ginoo. Mangin iya na ini sang pari nga nagawisik-wisik sang dugo sang halad nga para sa maayo nga relasyon. ");
INSERT INTO hil_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Kon ang halad nga para sa maayo nga relasyon ihalad niya bilang pagpasalamat sa Ginoo, ang karne sini kinahanglan nga kaunon niya kag sang iya pamilya kag sang mga pari sa sina mismo nga adlaw sang paghalad; dapat wala gid sing may mabilin pagkasunod nga aga. ");
INSERT INTO hil_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Pero kon ang halad nga para sa maayo nga relasyon ihalad niya bilang halad sa pagtuman sang isa ka panaad ukon halad nga kinabubut-on, ang karne sini kaunon sa sina mismo nga adlaw sang paghalad kag ang mabilin puwede pa nga kaunon sa sunod nga adlaw. ");
INSERT INTO hil_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Kon may mabilin pa gid nga karne hasta sa ikatatlo nga adlaw, kinahanglan nga sunugon na ini. ");
INSERT INTO hil_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Kon may magkaon sang karne sa ikatatlo nga adlaw, indi pagbatunon sang Ginoo ang ini nga halad kag mangin wala sing pulos ang iya ginhalad. Kabigon ini nga makangilil-ad kag may salabton ang bisan sin-o nga magkaon sini. ");
INSERT INTO hil_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Kon makasag-id ang karne sa bisan ano nga butang nga ginakabig nga mahigko, kinahanglan nga indi na ini pagkaunon kundi dapat sunugon. Kon parte sa halad nga karne nga puwede kaunon, ang bisan sin-o nga ginakabig nga matinlo puwede magkaon sang sini nga karne. ");
INSERT INTO hil_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Pero ang bisan sin-o nga ginakabig nga mahigko nga magkaon sang sini nga karne nga para sa Ginoo, ina nga tawo indi na ninyo pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Kon may makatandog sang butang nga ginakabig nga mahigko, pareho sang mahigko nga mga butang sang tawo, mahigko nga sapat, ukon bisan ano nga mahigko nga butang nga makangilil-ad, kag dayon magkaon siya sang karne sang sini nga halad nga para sa Ginoo, ina nga tawo indi na ninyo pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Nagsugo ang Ginoo kay Moises ");
INSERT INTO hil_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","nga ihambal ini sa mga Israelinhon: Indi kamo magkaon sang tambok sang baka, karnero, ukon kanding. ");
INSERT INTO hil_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ang tambok sang sapat nga napatay lang ukon ginpatay sang iban nga sapat puwede ninyo gamiton sa bisan ano nga gusto ninyo, pero indi gid ninyo ini pagkaunon. ");
INSERT INTO hil_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ang bisan sin-o nga magkaon sang tambok nga puwede ihalad sa Ginoo bilang halad nga paagi sa kalayo, indi na ninyo pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Kag bisan diin man kamo mag-estar, indi gid kamo magkaon sang dugo sang sapat pati sang dugo sang pispis. ");
INSERT INTO hil_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ang bisan sin-o nga magkaon sang dugo, indi na ninyo pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Nagsugo pa gid ang Ginoo kay Moises ");
INSERT INTO hil_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","nga ihambal ini sa mga Israelinhon: Ang bisan sin-o nga maghalad sang halad nga para sa maayo nga relasyon, kinahanglan nga maghatag siya sang parte sini para sa Ginoonga makadto sa mga pari. ");
INSERT INTO hil_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ini nga halad dal-on mismo sang manughalad para ihalad sa Ginoo bilang halad nga paagi sa kalayo. Dal-on niya ang tambok kag ang dughan sang sapat, kag bayawon niya ang dughan sa presensya sang Ginoo bilang halad nga ginabayaw. ");
INSERT INTO hil_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Sunugon sang pari ang tambok sa halaran, pero ang dughan iya na ni Aaron kag sang iya mga kaliwat. ");
INSERT INTO hil_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","33","Ang tuo nga paa sang sapat ihatag sa sadto nga pari nga nagahalad sang dugo kag sang tambok sini. ");
INSERT INTO hil_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ginahatag sang Ginoo ang dughan kag ang paa sang inyo halad sa mga pari nga si Aaron kag ang iya mga kaliwat. Amo ini ang parte nga ila batunon halin sa inyo hasta san-o. ");
INSERT INTO hil_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Amo ato ang parte sang mga halad nga paagi sa kalayo para sa Ginoo nga ginhatag kay Aaron kag sa iya mga kaliwat sang adlaw nga ginhalad sila nga mag-alagad sa Ginoo bilang mga pari. ");
INSERT INTO hil_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Sa sina nga adlaw nga gin-ordinahan sila, nagsugo ang Ginoo sa mga Israelinhon nga ihatag gid nila atong parte sang mga pari nga para sa ila hasta san-o, kag tumanon nila ini hasta sa palaabuton nga mga henerasyon. ");
INSERT INTO hil_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Amo ato ang mga pagsulundan parte sa halad nga ginasunog, halad nga regalo, halad sa pagpakatinlo, halad nga bayad sa sala, halad nga para sa ordinasyon, kag halad nga para sa maayo nga relasyon. ");
INSERT INTO hil_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ina nga mga pagsulundan ginhatag sang Ginoo kay Moises didto sa kamingawan sa Bukid sang Sinai, sang tion nga nagsugo siya sa mga Israelinhon nga maghalad sa iya. ");
INSERT INTO hil_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","3","“Pakadtua si Aaron kag ang iya mga anak nga lalaki didto sa puwertahan sang Tolda nga Ginapakigkitaan, kag tipuna ang bilog nga komunidad didto. Ipadala ang mga bayo nga para sa mga pari, ang lana nga inughaplas, ang turo nga baka nga halad sa pagpakatinlo, ang duha ka karnero nga lalaki, kag ang alat nga may mga tinapay nga wala sing inugpahabok.” ");
INSERT INTO hil_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Gintuman ni Moises ang ginsugo sa iya sang Ginoo, kag nagtipon ang komunidad didto sa puwertahan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Karon, ginhambalan sila ni Moises nga ining iya himuon amo ang ginsugo sang Ginoo sa iya. ");
INSERT INTO hil_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Gindala niya sa tunga si Aaron kag ang iya mga anak kag ginpapaligo niya sila. ");
INSERT INTO hil_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ginpasuksok niya kay Aaron ang iya sulul-ubon bilang pangulo nga pari: ang pangsulod nga bayo, ang wagkos, ang pangguwa nga bayo, kag ang espesyal nga panapton nga nahigtan maayo sang hinabol nga paha nga maayo ang pagkahimo. ");
INSERT INTO hil_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Gintakod man ni Moises kay Aaron ang bulobulsa sa dughan kag ginsulod niya didto ang Urim kag Thumim. ");
INSERT INTO hil_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Dayon ginpasuksok niya ang turban sa ulo ni Aaron, kag ginpatakod sa atubangan sang turban ang medalya nga bulawan nga simbolo nga ginpain si Aaron para sa Ginoo. Ginhimo ini tanan ni Moises suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ginkuha dayon ni Moises ang lana kag ginwisikan ang Tolda nga Simbahan kag ang tanan nga ara sa sulod sini. Sa sini nga paagi gindedikar ini nga mga butang sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ginwisikan niya sang lana ang halaran sing makapito ka beses kag ang tanan nga kagamitan sini, kag amo man ang labador kag ang tulungtungan sini. Ginhimo niya ini para idedikar ini nga mga butang sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Dayon ginbubuan niya sang lana ang ulo ni Aaron sa pagdedikar sa iya sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Dayon gindala niya sa tunga ang mga anak ni Aaron nga lalaki kag ginpasuksok sa ila ang ila bayo bilang mga pari kag ginwagkusan ini. Ginsuksok man nila ang ila mga kalo. Ginhimo ini ni Moises suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Pagkatapos sini, ginpakuha ni Moises ang turo nga baka nga ihalad sa pagpakatinlo. Kag gintungtong ni Aaron kag sang iya mga anak ang ila mga kamot sa ulo sang baka. ");
INSERT INTO hil_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Gin-ihaw ni Moises ang baka kag nagkuha siya sang dugo sini. Gintum-oy niya ang iya tudlo sa dugo kag ginlamhitan ang mga sulosungay sang halaran sa pagtinlo sini. Dayon gin-ula niya ang nabilin nga dugo sa idalom sang halaran. Sa sini nga paagi gindedikar niya ang halaran sa Ginoo para mangin takos ini nga gamiton sa pagtubos sang sala. ");
INSERT INTO hil_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ginkuha man ni Moises ang tanan nga sapay sa kasudlan sang sapat, ang gamay nga parte sang atay, ang mga batobato pati ang mga tambok sini, kag ginsunog niya ini tanan sa halaran. ");
INSERT INTO hil_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ang mga nabilin nga parte sang baka pareho sang unod, panit, kag mga tinai, ginsunog niya sa guwa sang kampo. Ginhimo ini ni Moises suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Pagkatapos ginpakuha ni Moises ang lalaki nga karnero bilang halad nga ginasunog, kag gintungtong ni Aaron kag sang iya mga anak ang ila mga kamot sa ulo sang karnero. ");
INSERT INTO hil_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Dayon gin-ihaw ni Moises ang karnero kag ginwisik-wisik ang dugo sini sa palibot sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","Ginpanghiwa-hiwa niya ang sapat kag ginsunog ang ulo, ang mga tambok kag ang iban pa nga parte sang sapat. Ginhugasan niya ang mga parte sang sulod sang tiyan kag ang mga tiil. Ginsunog niya sa halaran ang tanan nga parte sang sapat bilang halad nga ginasunog. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa Ginoo. Ginhimo ini ni Moises suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ginpakuha man dayon ni Moises ang ikaduha nga lalaki nga karnero. Ini nga karnero halad nga para sa ordinasyon. Gintungtong ni Aaron kag sang iya mga anak ang ila mga kamot sa ulo sang karnero. ");
INSERT INTO hil_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Dayon gin-ihaw ni Moises ang karnero kag nagkuha siya sang dugo sini kag ginlamhit sa idalom nga parte sang tuo nga dulunggan ni Aaron, sa kumalagko sang iya tuo nga kamot, kag sa kumalagko sang iya tuo nga tiil. ");
INSERT INTO hil_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Gindala man ni Moises sa tunga ang mga anak ni Aaron nga lalaki kag ginlamhitan man niya sang dugo ang idalom nga parte sang ila tuo nga dulunggan, ang kumalagko sang ila tuo nga kamot, kag ang kumalagko sang ila tuo nga tiil. Dayon ginwisik-wisik niya ang dugo sa palibot sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ginkuha niya ang mga tambok, ang matambok nga ikog, ang tanan nga sapay sa kasudlan, ang gamay nga parte sang atay, ang mga batobato pati ang mga tambok sini, kag ang tuo nga paa. ");
INSERT INTO hil_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","27","Dayon nagkuha si Moises sang isa sa kada klase sang mga tinapay nga wala sing inugpahabok nga nasulod sa alat didto sa presensya sang Ginoo. Ang iya ginkuha tinapay nga madamol, tinapay nga ginmikslahan sang mantika, kag tinapay nga manipis. Ginpauyatan niya ini tanan kay Aaron kag sa iya mga anak pati ang tanan nga tambok kag ang tuo nga paa sang karnero, kag ginbayaw nila ini sa presensya sang Ginoo bilang halad nga ginabayaw. ");
INSERT INTO hil_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Dayon ginkuha ini ni Moises sa ila kag ginsunog sa halaran upod sang halad nga ginasunog. Halad ini nga para sa ila ordinasyon. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Ginkuha man ni Moises ang dughan sang karnero kag ginbayaw ini sa presensya sang Ginoo bilang halad nga ginabayaw. Amo ini ang iya parte sa karnero nga halad para sa ordinasyon. Ini tanan ginhimo ni Moises suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Dayon nagkuha si Moises sang lana nga inughaplas kag sang dugo sa halaran kag ginwisikan niya si Aaron kag ang iya mga anak pati ang ila mga bayo. Sa sini nga paagi gindedikar niya sila kag ang ila mga bayo sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Nagsiling dayon si Moises kay Aaron kag sa iya mga anak, “Lutua ninyo ang karne sa puwertahan sang Tolda nga Ginapakigkitaan, kag suno sa ginsugo ko sa inyo kauna ninyo ini diri upod sang mga tinapay sa alat nga halad para sa ordinasyon. ");
INSERT INTO hil_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Kag sunuga ninyo ang mabilin nga karne kag tinapay. ");
INSERT INTO hil_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Indi kamo maghalin diri sa sulod sang pito ka adlaw, hasta matapos ang inyo ordinasyon. ");
INSERT INTO hil_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ang Ginoo ang nagsugo sa aton sa paghimo sining ginahimo ta subong, para matubos kamo sa inyo mga sala. ");
INSERT INTO hil_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Kinahanglan nga magpabilin kamo diri adlaw-gab-i sa sulod sang pito ka adlaw, kag himuon gid ninyo ang ginapahimo sang Ginoo para indi kamo mapatay, kay amo ina ang ginsugo sa akon sang Ginoo nga himuon ninyo.” ");
INSERT INTO hil_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Gani gintuman ni Aaron kag sang iya mga anak ang tanan nga ginsugo sang Ginoo paagi kay Moises. ");
INSERT INTO hil_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Sang ikawalo nga adlaw, matapos ang ordinasyon, ginpatawag ni Moises si Aaron kag ang iya mga anak nga lalaki, kag ang mga manugdumala sang Israel. ");
INSERT INTO hil_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Nagsiling si Moises kay Aaron, “Magkuha ka sang isa ka bataon nga baka kag sang isa ka lalaki nga karnero nga pareho nga wala sing deperensya, kag ihalad sa presensya sang Ginoo. Ang baka halad sa pagpakatinlo, kag ang karnero halad nga ginasunog. ");
INSERT INTO hil_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Hambalon mo dayon ang mga Israelinhon nga magkuha sila sang lalaki nga kanding bilang halad sa pagpakatinlo. Kag magkuha man sila sang bataon nga baka kag karnero nga pareho nga isa ka tuig kag wala sing deperensya bilang halad nga ginasunog. ");
INSERT INTO hil_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Magkuha man sila sang baka kag lalaki nga karnero bilang halad nga para sa maayo nga relasyon. Ihalad nila ini sa presensya sang Ginoo upod sa halad nga regalo nga ginmikslahan sang mantika, kay subong nga adlaw magapahayag ang Ginoo sang iya presensya sa inyo.” ");
INSERT INTO hil_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Gani gindala sang bilog nga komunidad sa atubangan sang Tolda nga Ginapakigkitaan ang tanan nga butang nga ginsugo sa ila ni Moises nga dal-on. Nagtipon sila tanan didto sa presensya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Nagsiling si Moises sa ila, “Ginsugo kamo sang Ginoo nga himuon ninyo ining paghalad para ipakita niya ang iya gamhanan nga presensya sa inyo.” ");
INSERT INTO hil_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Nagsiling dayon siya kay Aaron, “Magpalapit ka sa halaran kag ihalad ang imo halad sa pagpakatinlo kag halad nga ginasunog para matubos ka kag ang imo panimalay sa inyo mga sala. Kag suno sa ginsugo sang Ginoo, ihalad man ang halad sang mga tawo para matubos sila sa ila mga sala.” ");
INSERT INTO hil_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Gani nagpalapit si Aaron sa halaran kag gin-ihaw niya ang bataon nga baka bilang halad sa pagpakatinlo para sa iya kaugalingon. ");
INSERT INTO hil_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ang dugo sini gindala sang iya mga anak sa iya, kag gintum-oy niya ang iya tudlo sa dugo kag ginwisik-wisik ini sa mga sulosungay sang halaran. Ang nabilin nga dugo gin-ula niya sa idalom sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ginsunog niya sa halaran ang mga tambok, ang mga batobato, kag ang gamay nga parte sang atay, suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ang karne kag ang panit sini ginsunog niya sa guwa sang kampo. ");
INSERT INTO hil_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Dayon gin-ihaw man ni Aaron ang sapat nga bilang halad nga ginasunog. Ang dugo sini gindala sang iya mga anak sa iya, kag ginwisik-wisik niya ini sa palibot sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Gindala man sang iya mga anak ang mga ginpanghiwa-hiwa nga mga parte sang sapat pati ang ulo sini, kag ginsunog niya ini sa halaran. ");
INSERT INTO hil_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ginhugasan niya ang mga parte sang sulod sang tiyan kag ang mga tiil, kag ginsunog niya ini sa halaran upod sang iban pa nga mga parte sang sapat. ");
INSERT INTO hil_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Pagkatapos gindala niya sa tunga ang mga halad nga para sa mga tawo. Gin-ihaw niya ang kanding bilang halad sa pagpakatinlo sang mga tawo pareho sang iya ginhimo sa nahauna nga halad. ");
INSERT INTO hil_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Dayon gindala man niya sa tunga ang sapat para sa halad nga ginasunog, kag ginhalad niya ini suno sa paagi sang paghalad sini. ");
INSERT INTO hil_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Gindala man niya sa tunga ang halad nga regalo. Nagkuha siya sang isa ka hakop sini kag ginsunog sa halaran dugang sa halad nga ginasunog, nga ginasunog kada aga. ");
INSERT INTO hil_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Gin-ihaw man ni Aaron ang baka kag ang lalaki nga karnero para sa mga tawo bilang ila halad para sa maayo nga relasyon. Ang dugo sini gindala sang iya mga anak sa iya, kag ginwisik-wisik niya ini sa palibot sang halaran. ");
INSERT INTO hil_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ang mga tambok sang sini nga mga sapat—ang ila matambok nga mga ikog kag mga sapay sa kasudlan—pati ang mga batobato kag ang gamay nga parte sang mga atay ");
INSERT INTO hil_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","gintungtong sang mga anak ni Aaron sa mga dughan sang mga sapat. Kag ginsunog ni Aaron ang mga tambok sa halaran. ");
INSERT INTO hil_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Suno sa ginsugo ni Moises, ginbayaw ni Aaron ang mga dughan kag ang tuo nga paa sang sapat bilang halad nga ginabayaw sa presensya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Pagkatapos halad ni Aaron sini tanan, ginbayaw niya ang iya mga kamot sa mga tawo kag ginbendisyunan sila, kag dayon nagpanaog siya halin sa halaran. ");
INSERT INTO hil_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","24","Nagsulod dayon si Moises kag si Aaron sa Tolda nga Ginapakigkitaan. Sang pagguwa nila, ginbendisyunan nila ang mga tawo. Kag dayon ginpakita sang Ginoo ang iya gamhanan nga presensya sa mga tawo paagi sa pagpadala sang kalayo nga nag-ubos sunog sang mga halad sa halaran. Sang makita ini sang mga tawo, naghinugyaw sila sa kalipay kag nagluhod. ");
INSERT INTO hil_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Karon, si Nadab kag si Abihu nga mga anak ni Aaron nagkuha sang ila tagsa ka bulutangan sang insenso. Ginbutangan nila ini sang baga kag sang insenso kag ginhalad sa presensya sang Ginoo. Pero ining ila ginhimo indi suno sa ginsugo sang Ginoo, kay ang kalayo nga ila gin-gamit indi amo ang dapat nila gamiton. ");
INSERT INTO hil_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Gani nagpadala ang Ginoo sang kalayo kag ginsunog sila hasta nga napatay sila sa presensya sang Ginoodidto sa Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Nagsiling dayon si Moises kay Aaron, “Amo ini ang buot silingon sang Ginoo sang magsiling siya, “ ‘Dapat kilalahon sang mga pari ang akon pagkabalaan, kag dapat padunggan ako sang bilog nga katawhan.’ ” Wala nakasabat si Aaron. ");
INSERT INTO hil_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Dayon ginpatawag ni Moises si Mishael kag si Elzafan, nga mga anak nga lalaki ni Uziel nga tiyo ni Aaron, kag ginsilingan sila, “Dali, kuhaa ninyo ang mga bangkay sang aton mga paryente sa balaan nga Tolda kag dal-a ninyo sa guwa sang kampo.” ");
INSERT INTO hil_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Gani ginkuha nila ang mga bangkay, pero sa bayo lang sila nagauyat, kag gindala nila sa guwa sang kampo suno sa ginsugo ni Moises. ");
INSERT INTO hil_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Dayon nagsiling si Moises kay Aaron kag sa iya mga anak nga si Eleazar kag si Itamar, “Indi ninyo paggumuna ang inyo buhok ukon paggisia ang inyo mga bayo sa pagpakita nga nagapangasubo kamo sa napatay. Kon himuon ninyo ini, mapatay kamo kag mangakig ang Ginoo sa bilog nga komunidad sang Israel. Ang inyo kapareho nga mga Israelinhon, nga inyo mga paryente, amo ang magpangasubo para sa ila nga duha nga ginsunog sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Indi kamo anay maghalin sa puwertahan sang Tolda. Kon himuon ninyo ini, mapatay kamo, kay ginpili kamo sang Ginoo nga mangin mga pari paagi sa paghaplas sa inyo sang lana.” Kag gintuman nila ang ginsiling ni Moises. ");
INSERT INTO hil_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Nagsiling ang Ginoo kay Aaron, ");
INSERT INTO hil_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Ikaw kag ang imo mga anak indi dapat magsulod sa Tolda nga nakainom sang bino ukon sang bisan ano nga ilimnon nga makahulubog. Kon himuon ninyo ini, mapatay kamo. Ini nga pagsulundan dapat tumanon ninyo hasta sa palaabuton nga mga henerasyon. ");
INSERT INTO hil_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Dapat mahibaluan ninyo kon ano ang para sa Ginoo kag ang para sa tanan, ang matinlo kag ang mahigko. ");
INSERT INTO hil_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Kag kinahanglan nga tudluan ninyo ang inyo kapareho nga mga Israelinhon sang tanan nga pagsulundan nga ginhatag ko sa inyo paagi kay Moises.” ");
INSERT INTO hil_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Nagsiling si Moises kay Aaron kag sa iya duha ka anak nga nabilin nga si Eleazar kag si Itamar, “Kuhaa ninyo ang nabilin nga halad nga regalo halin sa mga halad nga paagi sa kalayo nga ginhalad sa Ginoo. Lutua ninyo ini nga wala sing inugpahabok kag kauna ninyo sa tupad sang halaran kay balaan gid ini nga halad. ");
INSERT INTO hil_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Kauna ninyo ini sa balaan lang nga lugar, kay amo ini ang inyo parte halin sa mga halad nga paagi sa kalayo. Amo ina ang ginsugo sang Ginoo sa akon. ");
INSERT INTO hil_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“Ang dughan kag ang paa sang sapat nga ginbayaw kag ginhalad sa Ginoo kaunon ninyo sang imo pamilya. Kaunon ninyo ini sa bisan diin nga lugar nga ginakabig ta nga matinlo. Ginhatag ini sa inyo bilang inyo parte halin sa mga halad sang mga Israelinhon nga para sa maayo nga relasyon. ");
INSERT INTO hil_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Kon maghalad ang mga Israelinhon, ihalad nila ang dughan kag ang paa sang sapat upod ang mga tambok nga ihalad nila bilang halad nga paagi sa kalayo. Ang dughan kag ang paa bayawon nila sa presensya sang Ginoo bilang halad nga ginabayaw. Amo ini ang parte ninyo sang imo mga kaliwat hasta san-o, suno sa ginsugo sang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Sang nagpangusisa gid si Moises parte sa kanding nga halad sa pagpakatinlo, nasapwan niya nga ginsunog na ini tanan. Gani nangakig gid siya kay Eleazar kag kay Itamar, kag ginsuknaan niya sila. ");
INSERT INTO hil_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Siling niya, “Ngaa bala wala ninyo pagkauna ang halad sa pagpakatinlo sa balaan nga lugar? Ang ini nga halad balaan gid kag ginhatag ini sang Ginoo sa inyo para matubos ang komunidad sang Israel sa ila mga sala sa presensya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Tungod nga ang dugo sini wala madala sa sulod sang Balaan nga Lugar, ginkaon kuntani ninyo ini didto sa Tolda, suno sa akon ginsugo sa inyo.” ");
INSERT INTO hil_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Nagsabat si Aaron kay Moises, “Naghalad kaina ang akon mga anak sang ila halad sa pagpakatinlo kag sang ila halad nga ginasunog sa presensya sang Ginoo,pero napatay ang duha sa ila. Sa natabo nga ini sa akon panimalay malipay ayhan ang Ginoo kon ginkaon ko ang halad sa pagpakatinlo subong nga adlaw?” ");
INSERT INTO hil_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Komporme si Moises sa sabat ni Aaron. ");
INSERT INTO hil_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","3","Ginsugo sang Ginoo si Moises kag si Aaron nga ihambal ini sa mga Israelinhon: Puwede ninyo kaunon ang bisan ano nga sapat nga nagakabuhi sa duta nga nagapihak ang ila kuko kag nagausang liwat sang ila kinaon. ");
INSERT INTO hil_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","8","Pero indi ninyo pagkaunon ang mga sapat nga nagausang liwat sang ila kinaon pero wala nagapihak ang ila kuko, pareho sang camel, badier kag koneho. Indi man ninyo pagkaunon ang baboy, kay bisan tuod nga nagapihak ang iya kuko, wala ini nagausang liwat sang iya kinaon. Kabigon ninyo nga mahigko ang ini nga mga sapat. Indi gid kamo magkaon sang ila mga karne ukon bisan magtandog sang ila patay nga mga lawas. ");
INSERT INTO hil_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","12","Puwede ninyo kaunon ang bisan ano nga sapat nga nagakabuhi sa tubig nga may mga sirik kag mga himbis. Pero indi gid ninyo pagkaunon ang wala sing sirik kag himbis, kag indi man ninyo pagtandugon ang ila patay nga mga lawas. Kabigon ninyo nga makangilil-ad ini nga mga sapat. ");
INSERT INTO hil_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","Indi gid ninyo pagkaunon ang mga sapat nga nagalupad nga pareho sang mga agila, mga uwak, mga pispis nga nagakaon sang bangkay sang tawo ukon sapat, mga dapay, mga bukaw, mga murugmon, mga pispis nga nagapangdagit sang mga isda, mga tulabong, mga dugwak, kag mga kabog. Kabigon ninyo nga makangilil-ad ini nga mga sapat. ");
INSERT INTO hil_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","23","Puwede ninyo kaunon ang mga sapat-sapat nga nagalupad kag nagakamang nga may dalagko nga mga tiil nga panglumpat, pareho sang mga apan, mga sirom-sirom, kag mga tibakla. Pero indi gid ninyo pagkaunon ang iban pa nga mga sapat-sapat nga nagalupad kag nagakamang. Kabigon ninyo nga makangilil-ad ini nga mga sapat-sapat. ");
INSERT INTO hil_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","Indi ninyo pagtandugon ang patay nga mga lawas sang mga sapat nga wala nagapihak ang ila kuko kag wala nagausang liwat sang ila kinaon. Indi man ninyo pagtandugon ang patay nga mga lawas sang mga sapat nga apat ang tiil nga may mga kuko nga inugkaros. Kabigon ninyo nga mahigko ini nga mga sapat. Ang bisan sin-o nga makatandog sang ila patay nga lawas, dapat labhan niya ang iya bayo, pero kabigon pa siya nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","31","Kabigon ninyo nga mahigko ang mga sapat nga nagakamang pareho sang mga ilaga, mga giting, mga tuko, mga tiki, mga halo, mga buaya, mga taguto, kag mga tambalian. Ang bisan sin-o nga makatandog sang ila patay nga lawas kabigon nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ang bisan ano nga butang nga mahulugan sang ila patay nga lawas mangin mahigko, bisan butang man ini nga hinimo halin sa kahoy, tela, panit, ukon sako, kag bisan diin man ini ginagamit. Kinahanglan nga hugasan ini sa tubig, pero kabigon pa ini nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kon mahulugan ang banga sang ila patay nga lawas, ang tanan nga sa sulod sini mangin mahigko, kag kinahanglan nga buk-on ini. ");
INSERT INTO hil_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ang bisan ano nga kalan-on nga ginbutangan sang tubig nga halin sa sadto nga banga mangin mahigko. Kag mangin mahigko man ang tanan nga klase sang ilimnon nga dira sa sulod sang banga. ");
INSERT INTO hil_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ang bisan ano nga mahulugan sang ila patay nga lawas mangin mahigko. Kon ang mahulugan pugon ukon kolon, kabigon ninyo ini nga mahigko kag kinahanglan nga buk-on ini. ");
INSERT INTO hil_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ang tuburan ukon ang buho nga pulunduhan sang tubig nga mahulugan sang ila patay nga lawas magapabilin nga matinlo, pero ang magtandog sang sadtong patay nga sapat mangin mahigko. ");
INSERT INTO hil_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Magapabilin man nga matinlo ang bisan ano nga binhi nga inugtanom nga mahulugan sadto, ");
INSERT INTO hil_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","pero kon mahulugan ang binhi nga nahulom sa tubig, ini nga binhi mangin mahigko. ");
INSERT INTO hil_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Kon napatay ang isa ka sapat nga puwede makaon, ang bisan sin-o nga magtandog sini kabigon nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ang bisan sin-o nga magkuha ukon magkaon sang lawas sini dapat labhan niya ang iya bayo, pero kabigon pa siya nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","42","Indi ninyo pagkaunon ang bisan ano nga sapat nga nagakamang kay makangilil-ad ini: ang bisan ano nga nagakamang paagi sa iya tiyan ukon apat ka tiil ukon madamo nga tiil. ");
INSERT INTO hil_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","44","Indi ninyo paghigkui ang inyo kaugalingon paagi sa pagkaon sang bisan isa sa sini nga mga sapat, kay ako, ang Ginoo, amo ang inyo Dios. Gani iseparar ninyo ang inyo kaugalingon para sa akon; magkabuhi kamo nga balaan tungod kay ako balaan. ");
INSERT INTO hil_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ako ang Ginoo nga nagpaguwa sa inyo sa Egypt para mangin inyo Dios. Gani magkabuhi kamo nga balaan kay ako balaan. ");
INSERT INTO hil_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Paagi sa sining pagsulundan parte sa tanan nga klase sang mga sapat, ");
INSERT INTO hil_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","mahibaluan ninyo kon diin sa ila ang matinlo kag ang mahigko, ang puwede kaunon kag ang indi puwede kaunon. ");
INSERT INTO hil_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ginsugo sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","nga ihambal ini sa mga Israelinhon: Kon ang isa ka babayi nagbata sing lalaki, kabigon siya nga mahigko sa sulod sang pito ka adlaw, subong nga ginakabig siya nga mahigko kon ara ang iya pamulanon. ");
INSERT INTO hil_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Sa ikawalo nga adlaw pagatulion ang iya bata. ");
INSERT INTO hil_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Tungod sa padayon nga pagpangguwa sang iya dugo, maghulat pa siya sang 33 ka adlaw antes siya kabigon nga matinlo. Indi siya puwede magtandog sang bisan ano nga butang nga para sa Ginoo kag indi siya puwede magkadto sa balaan nga Tolda hasta nga makompleto ang mga inadlaw sang iya pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Kon babayi ang iya bata, kabigon siya nga mahigko sa sulod sang 14 ka adlaw, subong nga ginakabig siya nga mahigko kon ara ang iya pamulanon. Tungod sa padayon nga pagpangguwa sang iya dugo, maghulat pa siya sang 66 ka adlaw antes siya kabigon nga matinlo. ");
INSERT INTO hil_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Kon tapos na ang mga inadlaw sang iya pagpakatinlo sa pagbata sang lalaki ukon babayi, magdala dayon siya sa pari didto dampi sa puwertahan sang Tolda nga Ginapakigkitaan sang isa ka tuig nga karnero bilang halad nga ginasunog kag isa ka tukmo ukon pating bilang halad sa pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","8","Ihalad ini sang pari sa presensya sang Ginoo para makuha ang pagkahigko sang babayi tungod sa pagpangguwa sang iya dugo, kag mangin matinlo na siya. Kon indi siya makasarang sang karnero magdala na lang siya sang duha ka pating ukon duha ka tukmo; ang isa ihalad niya bilang halad nga ginasunog kag ang isa bilang halad sa pagpakatinlo. Paagi sa sining himuon sang pari, makuha ang iya nga pagkahigko kag mangin matinlo na siya. Amo ini ang mga pagsulundan parte sa babayi nga nagbata. ");
INSERT INTO hil_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Naghatag ang Ginoo sang sini nga mga pagsulundan kay Moises kag kay Aaron: ");
INSERT INTO hil_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Kon ang panit sang isa ka tawo nagabanog ukon nagaguros-guros ukon nagalamuti, nga tanda sang delikado nga balatian sa panit, dal-on ini nga tawo kay Aaron nga pari ukon sa isa sa mga pari nga kaliwat ni Aaron. ");
INSERT INTO hil_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Tan-awon sang pari ang iya panit, kag kon nagputi ang balahibo kag nagdalom ang inpeksyon, may delikado siya nga balatian sa panit. Kag ipahibalo dayon sang pari nga mahigko siya. ");
INSERT INTO hil_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Kon nagalamuti ang panit pero wala magdalom ang inpeksyon kag wala magputi ang balahibo, pagapainon siya sang pari sa mga tawo sa sulod sang pito ka adlaw. ");
INSERT INTO hil_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sa ikapito nga adlaw, tan-awon liwat siya sang pari. Kag kon ang makita sa panit amo lang gihapon kag wala man ini maglapta, painon siya liwat sang pari sa mga tawo sa sulod sang pito pa gid ka adlaw. ");
INSERT INTO hil_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Sa ikapito naman nga adlaw, tan-awon liwat siya sang pari. Kag kon nagpali na ang ara sa iya panit kag wala maglapta, ipahibalo sang pari nga matinlo siya kay guros-guros man lang ini. Pagkatapos sini, labhan sang tawo ang iya bayo, kag kabigon siya nga matinlo. ");
INSERT INTO hil_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Pero kon maglapta ang guros-guros sa iya panit sa tapos nga nakapatan-aw na siya sa pari kag ginpahibalo na sang pari nga matinlo siya, kinahanglan nga magpatan-aw liwat siya sa pari. ");
INSERT INTO hil_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kag kon matuod nga naglapta ang guros-guros, ipahibalo sang pari nga mahigko siya kay may delikado siya nga balatian sa panit. ");
INSERT INTO hil_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Ang bisan sin-o nga may tanda sang delikado nga balatian sa panit kinahanglan nga dal-on sa pari. ");
INSERT INTO hil_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kon sa pagtan-aw sang pari nagalamuti ang banog nga amo ang kabangdanan nga nagputi ang mga balahibo, kag ang unod kitaon na, ");
INSERT INTO hil_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","isa ini ka delikado nga balatian sa panit nga nagabalik-balik. Kag ipahibalo sang pari nga mahigko siya. Indi na kinahanglan nga painon pa siya kay klaro na nga mahigko siya. ");
INSERT INTO hil_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Kon sa pagtan-aw sang pari naglapta ang balatian sa bilog nga lawas sang tawo, ");
INSERT INTO hil_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","kinahanglan nga tan-awon pa gid niya sing maayo ini nga tawo. Kag kon matuod nga naglapta ang balatian sa bilog niya nga lawas kag tungod sini nagputi ang tanan niya nga panit, ipahibalo sang pari nga matinlo siya. ");
INSERT INTO hil_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","15","Pero kon sa pagtan-aw sang pari nagaguwa ang unod, ipahibalo niya nga mahigko ang tawo kay may delikado siya nga balatian sa panit. Ining nagaguwa nga unod ginakabig nga mahigko. ");
INSERT INTO hil_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Pero kon nagkugan ining unod kag nagputi ang pinalian, magpatan-aw liwat siya sa pari. ");
INSERT INTO hil_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Kag kon matuod nga nagpali ini, ipahibalo sang pari nga matinlo na siya. ");
INSERT INTO hil_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Kon ang isa ka tawo may hubag nga nag-ayo, ");
INSERT INTO hil_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","pero sang ulihi nagpalamuti ini ukon nagpalamula, kinahanglan nga ipatan-aw niya ini sa pari. ");
INSERT INTO hil_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Kag kon nagdalom ang inpeksyon kag nagputi ang balahibo, ipahibalo sang pari nga mahigko ang ini nga tawo, kay may delikado siya nga balatian sa panit nga nag-umpisa sa hubag. ");
INSERT INTO hil_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Pero kon sa pagtan-aw sang pari wala magputi ang balahibo kag wala magdalom ang inpeksyon, kag medyo pali na, painon siya sang pari sa mga tawo sa sulod sang pito ka adlaw. ");
INSERT INTO hil_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kon naglapta ini sa iban nga parte sang panit, ipahibalo sang pari nga mahigko siya, kay tanda ina sang delikado nga balatian sa panit. ");
INSERT INTO hil_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Pero kon wala man ini maglapta, pinalian lang ini sang hubag, kag ipahibalo sang pari nga matinlo siya. ");
INSERT INTO hil_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Kon ang isa ka tawo may paso nga nainpeksyon kag nagpalamuti ini ukon nagpalamula, ");
INSERT INTO hil_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","kinahanglan nga ipatan-aw ini sa pari. Kag kon nagputi ang balahibo kag nagdalom ang inpeksyon, may delikado siya nga balatian sa panit nga nag-umpisa sa paso. Kag ipahibalo sang pari nga mahigko siya. ");
INSERT INTO hil_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Pero kon sa pagtan-aw sang pari wala magputi ang balahibo kag wala magdalom ang inpeksyon, kag medyo pali na, painon siya sang pari sa mga tawo sa sulod sang pito ka adlaw. ");
INSERT INTO hil_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Sa ikapito nga adlaw, tan-awon liwat siya sang pari. Kag kon naglapta ini sa iban nga parte sang panit, ipahibalo sang pari nga mahigko siya, kay tanda ina sang delikado nga balatian sa panit. ");
INSERT INTO hil_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Pero kon wala man ini maglapta kag medyo pali na, isa lang ini ka banog nga nag-umpisa sa paso. Kag ipahibalo sang pari nga matinlo siya. ");
INSERT INTO hil_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Kon ang isa ka tawo may tanda sang delikado nga balatian sa panit sa iya ulo ukon sag-ang, ");
INSERT INTO hil_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kinahanglan nga ipatan-aw niya ini sa pari. Kon nagdalom ang inpeksyon kag ang mga buhok ukon burangos naga-yellow kag nagalaka, ipahibalo sang pari nga mahigko ang ini nga tawo, kay may delikado siya nga katol nga nagatubo sa ulo ukon sa sag-ang. ");
INSERT INTO hil_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Kon sa pagtan-aw sang pari wala magdalom ang inpeksyon pero wala na ini sang itom nga buhok ukon burangos, painon siya sang pari sa mga tawo sa sulod sang pito ka adlaw. ");
INSERT INTO hil_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Sa ikapito nga adlaw, tan-awon liwat sang pari ang katol. Kag kon wala ini maglapta kag wala magdalom ang inpeksyon, kag wala man mag-yellow ang buhok ukon burangos, ");
INSERT INTO hil_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","kinahanglan nga kiskisan niya ang iya buhok ukon barbasan ang iya burangos pero indi niya pag-ilakip ang parte nga may katol. Dayon painon liwat siya sang pari sa sulod sang pito pa gid ka adlaw. ");
INSERT INTO hil_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Sa ikapito nga adlaw, tan-awon liwat sang pari ang katol. Kag kon wala ini maglapta kag wala magdalom ang inpeksyon, ipahibalo sang pari nga matinlo siya. Dayon labhan sang tawo ang iya bayo, kag kabigon siya nga matinlo. ");
INSERT INTO hil_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Pero kon naglapta ang katol sa iya panit matapos nga ginpahibalo sang pari nga matinlo siya, ");
INSERT INTO hil_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","tan-awon liwat siya sang pari. Kag kon naglapta matuod ang katol sa iya panit, indi na kinahanglan nga tan-awon pa sang pari kon may buhok ukon burangos nga nag-yellow kay klaro na nga mahigko siya. ");
INSERT INTO hil_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Pero kon sa pagtan-aw sang pari wala ini maglapta kag may itom na nga buhok ukon burangos nga nagatubo, ayo na ini. Kag ipahibalo sang pari nga matinlo siya. ");
INSERT INTO hil_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Kon may nagaputi-puti sa panit sang isa ka tawo, ");
INSERT INTO hil_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","kinahanglan nga ipatan-aw niya ini sa pari. Kag kon ang mga nagaputi-puti malapsi, guros-guros lang ini nga nagguluwa sa panit. Ini nga tawo kabigon nga matinlo. ");
INSERT INTO hil_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Kon ang isa ka tawo nakalbo sa may agtang dampi ukon sa iya alimpudwan, matinlo siya. ");
INSERT INTO hil_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","44","Pero kon may mapula-pula nga banog sa iya kalbo, kinahanglan nga ipatan-aw niya ini sa pari. Kag kon ang mapula-pula nga banog isa ka delikado nga balatian sa panit, ipahibalo sang pari nga mahigko siya. ");
INSERT INTO hil_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Ang tawo nga may delikado nga balatian sa panit kinahanglan nga magsuksok sang gision nga bayo, gumunon niya ang iya buhok, kag tabunan niya ang idalom nga parte sang iya guya. Dayon magsinggit siya, “Mahigko ako! Mahigko ako!” ");
INSERT INTO hil_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Kabigon siya nga mahigko samtang ara pa sa iya ang balatian. Kag kinahanglan nga mag-estar siya sa guwa sang kampo nga isahanon lang. ");
INSERT INTO hil_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","50","Kon may tagiptip ang panapton nga delana ukon linen ukon ang bisan ano nga butang nga hinimo halin sa panit, kinahanglan nga ipatan-aw ini sa pari. Pagkatapos nga matan-aw sang pari ang panapton ukon ang panit, painon niya ini sa sulod sang pito ka adlaw. ");
INSERT INTO hil_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","52","Sa ikapito nga adlaw, tan-awon ini liwat sang pari. Kag kon naglapta ang tagiptip, kabigon ini nga panapton nga delana ukon linen, ukon panit nga mahigko, kag kinahanglan nga sunugon ini tungod kay nagadamo ini nga tagiptip. ");
INSERT INTO hil_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Pero kon sa pagtan-aw sang pari wala man maglapta ang tagiptip, ");
INSERT INTO hil_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","magsugo siya nga labhan ang panapton ukon hugasan ang panit, kag painon niya ini sa sulod sang pito pa gid ka adlaw. ");
INSERT INTO hil_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Pagkatapos tan-awon ini liwat sang pari. Kag kon ang tagiptip wala maglus-aw, kabigon ini nga panapton ukon panit nga mahigko bisan pa nga wala maglapta ang tagiptip. Gani kinahanglan nga sunugon ini bisan ara sa guwa ukon sa sulod sang panapton ang tagiptip. ");
INSERT INTO hil_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Pero kon sa pagtan-aw sang pari naglus-aw ang tagiptip, gision niya ang parte sang panapton ukon panit nga gintagiptipan. ");
INSERT INTO hil_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Pero kon magbalik liwat ang tagiptip kag maglapta, kinahanglan nga sunugon ang panapton ukon ang panit. ");
INSERT INTO hil_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Kon nadula ang tagiptip pagkatapos nga ginlabhan ang panapton ukon panit, labhan ini liwat kag mangin matinlo na ini. ");
INSERT INTO hil_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Amo ini ang mga pagsulundan kon paano mahibaluan nga matinlo ukon mahigko ang panapton nga delana ukon linen ukon ang bisan ano nga butang nga hinimo halin sa panit nga may tagiptip. ");
INSERT INTO hil_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","2","Amo ini ang mga pagsulundan nga ginsiling sang Ginoo kay Moises parte sa pagpakatinlo sang tawo nga nag-ayo sa delikado nga balatian sa panit: Pagkatapos nga napahibalo ang pari parte sa balatian sang isa ka tawo, ");
INSERT INTO hil_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","magguwa ang pari sa kampo kag tan-awon niya ang lawas sang ato nga tawo. Kon nag-ayo na siya sa iya balatian, ");
INSERT INTO hil_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","magpakuha ang pari sang duha ka matinlo nga pispis nga buhi, isa ka utod sang kahoy nga sedro, pula nga higot, kag isa ka pungpong sang tanom nga isopo. ");
INSERT INTO hil_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Dayon ipaihaw sang pari ang isa ka pispis sa ibabaw sang kolon nga may tubig nga halin sa tuburan. ");
INSERT INTO hil_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Kuhaon niya dayon ang isa pa ka buhi nga pispis, ang kahoy nga sedro, ang pula nga higot, kag ang isopo, kag itum-oy niya ini tanan sa sadto nga tubig nga may dugo sang pispis nga gin-ihaw. ");
INSERT INTO hil_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Kag ang tubig nga may dugo iwisik-wisik niya sing makapito ka beses sa tawo nga nag-ayo sa delikado nga balatian sa panit, kag ipahibalo niya nga matinlo na ang amo nga tawo. Dayon buy-an sang pari atong buhi nga pispis. ");
INSERT INTO hil_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Pero antes siya kabigon nga matinlo na gid, labhan niya anay ang iya bayo, kiskisan niya ang tanan niya nga buhok kag balahibo, kag magpaligo siya. Puwede na siya makasulod sa kampo pero indi siya mag-estar sa iya nga tolda sa sulod sang pito ka adlaw. ");
INSERT INTO hil_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Sa ikapito nga adlaw, kiskisan niya liwat ang tanan niya nga buhok kag balahibo, labhan niya ang iya bayo kag magpaligo. ");
INSERT INTO hil_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Sa ikawalo nga adlaw, kinahanglan nga magdala siya sang duha ka bataon nga karnero nga lalaki kag isa ka babayi nga karnero nga isa ka tuig, nga wala sing deperensya. Magdala man siya sang anom ka kilo nga harina nga maayo nga klase nga ginmikslahan sang mantika bilang halad nga regalo. Kag magdala pa gid siya sang isa ka baso nga mantika. ");
INSERT INTO hil_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ang pari nga magadeklarar sa iya nga matinlo magadala sa iya kag sang iya mga halad sa presensya sang Ginoo didto dampi sa puwertahan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Kuhaon sang pari ang isa ka lalaki nga karnero kag ang isa ka baso nga lana, kag ihalad niya ini bilang halad nga bayad sa sala. Dayon bayawon niya ini sa presensya sang Ginoo bilang halad nga ginabayaw. ");
INSERT INTO hil_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Ihawon niya ang karnero sa balaan nga lugar, didto sa ginaihawan sang halad sa pagpakatinlo kag halad nga ginasunog. Ining halad nga bayad sa sala iya na sang mga pari, pareho man sa halad sa pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Dayon magkuha ang pari sang dugo sang halad nga bayad sa sala kag ilamhit niya ini sa idalom nga parte sang tuo nga dulunggan sang tawo nga ginatinluan kag sa kumalagko sang iya tuo nga kamot kag tiil. ");
INSERT INTO hil_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Magkuha man ang pari sang lana kag ibutang niya ini sa iya mismo wala nga palad, ");
INSERT INTO hil_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","kag ang isa niya ka tudlo sa tuo nga kamot itum-oy niya sa sini nga lana kag iwisik-wisik sing makapito ka beses didto sa presensya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ang iban nga lana sa iya palad ilamhit niya sa mga parte sang lawas sang tawo nga ginlamhitan niya sang dugo sang halad nga bayad sa sala: ang sa idalom nga parte sang tuo nga dulunggan kag sa kumalagko sang iya tuo nga kamot kag tiil. ");
INSERT INTO hil_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","20","Ang nabilin nga lana sa palad sang pari ilamhit niya sa ulo sang tawo. Dayon ihalad sang pari ang halad sa pagpakatinlo. Pagkatapos sini, ihawon sang pari ang halad nga ginasunog kag ihalad niya ini sa halaran upod sang halad nga regalo. Paagi sa sining himuon sang pari sa presensya sang Ginoo, makuha ang pagkahigko sang tawo kag kabigon na siya nga matinlo. ");
INSERT INTO hil_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Pero kon imol ang amo nga tawo kag indi siya makasarang sa paghalad sang sini nga mga halad, magdala na lang siya sang isa ka lalaki nga karnero bilang halad nga bayad sa sala. Bayawon niya ini nga halad sa Ginoo para matubos siya sa iya nga sala. Magdala man siya sang duha ka kilo nga harina nga maayo nga klase nga ginmikslahan sang mantika bilang halad nga regalo. Kag magdala pa gid siya sang isa ka baso nga lana. ");
INSERT INTO hil_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Kag suno sa iya masarangan, magdala siya sang duha ka pating ukon duha ka tukmo; ang isa ihalad niya bilang halad sa pagpakatinlo kag ang isa bilang halad nga ginasunog. ");
INSERT INTO hil_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Sa ikawalo nga adlaw, dal-on niya ini tanan nga halad sa presensya sang Ginoo didto dampi sa puwertahan sang Tolda nga Ginapakigkitaan, kag ihatag niya ini sa pari. ");
INSERT INTO hil_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kuhaon sang pari ang karnero nga halad nga bayad sa sala kag ang isa ka baso nga lana kag bayawon niya ini sa presensya sang Ginoo bilang halad nga ginabayaw. ");
INSERT INTO hil_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Dayon ihawon niya ang karnero kag magkuha siya sang dugo sini kag ilamhit niya sa idalom nga parte sang tuo nga dulunggan sang tawo nga ginatinluan kag sa kumalagko sang iya tuo nga kamot kag tiil. ");
INSERT INTO hil_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Dayon magbutang ang pari sang lana sa iya wala nga palad, ");
INSERT INTO hil_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","kag paagi sa iya tudlo sa tuo nga kamot, iwisik-wisik niya ang lana sing makapito ka beses didto sa presensya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ang iban nga lana sa iya palad ilamhit niya sa mga parte sang lawas sang tawo nga ginlamhitan niya sang dugo sang halad nga bayad sa sala: ang sa idalom nga parte sang tuo nga dulunggan kag sa kumalagko sang iya tuo nga kamot kag tiil. ");
INSERT INTO hil_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","31","Ang nabilin nga lana sa palad sang pari ilamhit niya sa ulo sang tawo. Dayon ihalad sang pari ang duha ka pating ukon ang duha ka tukmo; ang isa halad sa pagpakatinlo kag ang isa halad nga ginasunog. Ihalad man niya ang halad nga regalo. Paagi sa sining himuon sang pari sa presensya sang Ginoo, makuha ang pagkahigko sang tawo. ");
INSERT INTO hil_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Amo ini ang mga pagsulundan parte sa pagpakatinlo sang tawo nga may delikado nga balatian sa panit kag kon ano ang iya himuon kon indi niya masarangan ang ginakinahanglan nga ihalad para sa pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Amo ini ang ginsiling sang Ginoo kay Moises kag kay Aaron ");
INSERT INTO hil_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","parte sa ila himuon kon patubuon sang Ginoo ang agup-op sa ila mga balay kon didto na sila sa Canaan, ang lugar nga ihatag sang Ginoo sa ila nga ila panag-iyahan: ");
INSERT INTO hil_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Kon ang tag-iya sang isa ka balay nakatalupangod nga may agup-op ang iya balay, kinahanglan nga sugiran niya ang pari. ");
INSERT INTO hil_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Kag antes magsulod ang pari sa sadto nga balay para tan-awon ang agup-op, magsugo siya nga ipaguwa ang tanan nga pagkabutang didto, kay basi pati ini makabig nga mahigko. Pagkatapos sini masulod ang pari sa balay ");
INSERT INTO hil_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","kag tan-awon niya ang agup-op sa dingding. Kag kon ang makita niya buloberde ukon mapula-pula nga nagaut-ot hasta sa sulod sang dingding, ");
INSERT INTO hil_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","maguwa dayon siya sa balay kag ipasara niya ini sa sulod sang pito ka adlaw. ");
INSERT INTO hil_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Sa ikapito nga adlaw, tan-awon niya ini liwat. Kag kon ang agup-op naglapta sa iban nga parte sang dingding, ");
INSERT INTO hil_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ipakuha niya ang mga parte sang dingding nga may agup-op kag ipahaboy sa guwa sang banwa, didto sa lugar nga ginahabuyan sang mga butang nga ginakabig nga mahigko. ");
INSERT INTO hil_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Kag pakiskisan niya ang tanan nga parte sang dingding sa sulod sang balay kag ang tanan nga kiniskis ipahaboy niya sa guwa sang banwa, didto sa lugar nga ginahabuyan sang mga butang nga ginakabig nga mahigko. ");
INSERT INTO hil_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Dayon pailisan niya ang mga parte sang dingding nga ginpanguha. ");
INSERT INTO hil_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Pero kon pagkatapos sadto gin-agup-opan liwat ang balay, ");
INSERT INTO hil_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","kadtuan ini liwat sang pari kag tan-awon. Kon naglapta ang agup-op, kabigon ang ato nga balay nga mahigko, kay ang ini nga klase sang agup-op nagabalik-balik. ");
INSERT INTO hil_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Gani gub-on ang ini nga balay kag ang mga materyales sini ihaboy sa guwa sang banwa, didto sa lugar nga ginahabuyan sang mga butang nga ginakabig nga mahigko. ");
INSERT INTO hil_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Ang bisan sin-o nga magsulod sa sini nga balay sang ginsirado ini kabigon nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Kag ang bisan sin-o nga magtulog ukon magkaon sa sini nga balay kinahanglan nga labhan niya ang iya bayo. ");
INSERT INTO hil_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Pero kon sa pagtan-aw sang pari wala man gin-agup-opan liwat ang balay pagkatapos nga gin-ilisan ang parte sang dingding nga gin-agup-opan, ipahibalo sang pari nga matinlo na ang balay kay nadula na ang agup-op. ");
INSERT INTO hil_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Kag para makabig nga matinlo ang balay, magkuha ang pari sang duha ka pispis, kahoy nga sedro, pula nga higot, kag isopo. ");
INSERT INTO hil_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ihawon niya ang isa ka pispis sa ibabaw sang kolon nga may tubig nga halin sa tuburan. ");
INSERT INTO hil_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Dayon kuhaon niya ang kahoy nga sedro, ang pula nga higot, ang isopo, kag ang buhi nga pispis, kag itum-oy niya ini tanan sa tubig nga may dugo sang pispis nga gin-ihaw. Kag ang tubig nga may dugo iwisik-wisik niya sing makapito ka beses sa balay. ");
INSERT INTO hil_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Gani paagi sa dugo sang pispis, sa tubig nga halin sa tuburan, sa buhi nga pispis, sa kahoy nga sedro, sa isopo, kag sa pula nga higot, matinluan sang pari ang balay. ");
INSERT INTO hil_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Dayon buy-an niya atong buhi nga pispis didto sa guwa sang banwa. Paagi sa sining himuon sang pari, makuha ang pagkahigko sang balay kag mangin matinlo na ini. ");
INSERT INTO hil_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","57","Amo ato ang mga pagsulundan parte sa mga delikado nga balatian sa panit nga nagakatol, ukon nagapalamanog, ukon nagaguros-guros, ukon nagalamuti, kag parte sa tagiptip sa bayo kag agup-op sa balay. Kag paagi sa sina nga mga pagsulundan, mahibaluan ninyo kon ano ang matinlo kag ang mahigko. ");
INSERT INTO hil_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Ginsugo sang Ginoo si Moises kag si Aaron ");
INSERT INTO hil_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","nga ihambal ini sa mga Israelinhon: Kon may nagaguwa sa kinatawo sang isa ka lalaki tungod sa iya balatian, inang nagaguwa sa iya ginakabig nga mahigko. ");
INSERT INTO hil_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Kag bisan nagapadayon ini sa pagtulo ukon wala, kabigon gihapon siya nga mahigko. ");
INSERT INTO hil_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ang bisan ano nga iya mahigdaan ukon mapungkuan mangin mahigko. ");
INSERT INTO hil_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","7","Kag ang bisan sin-o nga makatandog sa iya ukon sa iya ginhigdaan ukon ginpungkuan, kinahanglan nga labhan niya ang iya bayo kag magpaligo, pero kabigon pa siya nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Ang bisan sin-o nga maduplaan sang sini nga tawo, kinahanglan nga labhan niya ang iya bayo kag magpaligo, pero kabigon pa siya nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","10","Ang bisan ano nga mapungkuan sang sini nga tawo, pareho sang ginapungkuan kon magsakay sa kabayo, mangin mahigko. Ang makatandog sang sini nga butang kinahanglan nga labhan niya ang iya bayo kag magpaligo, pero kabigon pa siya nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ang bisan sin-o nga matandog sang sini nga tawo nga wala pa makapanghugas sang iya kamot, kinahanglan nga labhan niya ang iya bayo kag magpaligo, pero kabigon pa siya nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ang kolon nga matandog sang sini nga tawo kinahanglan nga buk-on, kag ang bisan ano nga butang nga hinimo halin sa kahoy nga iya matandog kinahanglan nga hugasan. ");
INSERT INTO hil_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","15","Kon mag-ayo na ini nga tawo sa iya nga balatian, maghulat pa siya sang pito ka adlaw. Dayon labhan niya ang iya bayo kag magpaligo sang tubig nga halin sa tuburan. Sa ikawalo nga adlaw, kinahanglan nga magdala siya sang duha ka pating ukon duha ka tukmo sa presensya sang Ginoo didto dampi sa puwertahan sang Tolda nga Ginapakigkitaan. Dayon ihatag niya ini sa pari nga amo ang maghalad sini. Ang isa halad sa pagpakatinlo kag ang isa halad nga ginasunog. Paagi sa sining himuon sang pari sa presensya sang Ginoo, makuha ang pagkahigko sang sadto nga tawo tungod sa nagaguwa sa iya kinatawo, kag mangin matinlo na siya. ");
INSERT INTO hil_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Kon ang isa ka lalaki naguwaan sang semilya, kinahanglan nga magpaligo siya, pero kabigon pa siya nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ang bisan ano nga panapton ukon butang nga hinimo halin sa panit nga natuluan sang semilya kinahanglan nga labhan, pero kabigon pa ini nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kon maghulid ang lalaki kag babayi, kag maguwaan sang semilya ang lalaki, kinahanglan nga magpaligo sila nga duha, pero kabigon pa sila nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Kon ara ang pamulanon sang isa ka babayi, kabigon siya nga mahigko sa sulod sang pito ka adlaw, kag ang bisan sin-o nga magtandog sa iya kabigon man nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ang bisan ano nga iya mahigdaan ukon mapungkuan nga ara ang iya pamulanon, mangin mahigko. ");
INSERT INTO hil_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Ang bisan sin-o nga makatandog sa iya ginhigdaan ukon ginpungkuan kinahanglan nga labhan niya ang iya bayo kag magpaligo, pero kabigon pa siya nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Kon maghulid ang lalaki sa babayi nga ara ang iya pamulanon, kabigon ang lalaki nga mahigko sa sulod sang pito ka adlaw, kag ang bisan ano nga iya mahigdaan mangin mahigko man. ");
INSERT INTO hil_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Kon ang isa ka babayi ginapangguwaan sang dugo sa sulod sang pila ka adlaw nga wala pa ang iya pamulanon ukon tapos na, kabigon siya nga mahigko, pareho man kon ara ang iya pamulanon. Kabigon siya nga mahigko samtang ginapangguwaan siya sang dugo. ");
INSERT INTO hil_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ang bisan ano nga iya mahigdaan ukon mapungkuan samtang ginapangguwaan pa siya sang dugo mangin mahigko, pareho man kon ara ang iya pamulanon. ");
INSERT INTO hil_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Kag ang bisan sin-o nga makatandog sadto mangin mahigko. Kinahanglan nga labhan niya ang iya bayo kag magpaligo, pero kabigon pa siya nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","30","Kon nag-ayo na ang babayi sa sadtong pagpangguwa sang dugo sa iya, maghulat siya sang pito ka adlaw. Sa ikawalo nga adlaw, kinahanglan nga magdala siya sang duha ka pating ukon duha ka tukmo sa pari didto dampi sa puwertahan sang Tolda nga Ginapakigkitaan. Ihalad sang pari ang isa bilang halad sa pagpakatinlo kag ang isa bilang halad nga ginasunog. Paagi sa sining himuon sang pari sa presensya sang Ginoo, makuha ang pagkahigko sang babayi tungod sa pagpangguwa sang dugo sa iya, kag mangin matinlo na siya. ");
INSERT INTO hil_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Ginhambalan sang Ginoo si Moises kag si Aaron nga paandaman gid ang mga Israelinhon parte sa mga butang nga makapahigko sa ila, para indi sila mapatay kon magkadto sila sa Tolda sang Ginoo, nga ara sa tunga sang kampo. ");
INSERT INTO hil_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","33","Amo ato ang mga pagsulundan parte sa lalaki nga naguwaan sang semilya ukon may nagaguwa sa iya kinatawo tungod sa iya balatian, kag parte sa babayi nga ara ang iya pamulanon ukon ginapangguwaan sang dugo nga wala pa ang iya pamulanon, kag parte sa lalaki nga nagahulid sa babayi nga ginakabig nga mahigko. ");
INSERT INTO hil_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","2","Sa tapos mapatay ang duha ka anak nga lalaki ni Aaron sang maghalad sila sa Ginoo, nagsiling ang Ginoo kay Moises, “Hambali ang imo utod nga si Aaron nga indi siya magsulod sa Labing Balaan nga Lugar, nga ara sa likod sang kurtina, sa bisan ano nga oras nga gusto niya. Kon himuon niya ini mapatay siya. Kay sa sini nga lugar ginapakita ko ang akon presensya paagi sa isa ka panganod nga sa ibabaw sang takop sang Kahon sang Kasugtanan.” ");
INSERT INTO hil_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Amo ini ang himuon ni Aaron sa adlaw nga magsulod siya sa Labing Balaan nga Lugar: Magdala siya sang bataon nga baka bilang halad sa pagpakatinlo kag lalaki nga karnero bilang halad nga ginasunog. ");
INSERT INTO hil_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Kinahanglan nga magpaligo siya kag dayon isuksok niya ang iya sulul-ubon bilang pangulo nga pari nga puro linen: ang pang-idalom nga panapton nga nagatabon sang iya kinatawo, ang pangguwa nga bayo, ang wagkos, kag ang turban. ");
INSERT INTO hil_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Maghatag sa iya ang komunidad sang Israel sing duha ka lalaki nga kanding bilang halad sa pagpakatinlo kag isa ka lalaki nga karnero bilang halad nga ginasunog. ");
INSERT INTO hil_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ihalad ni Aaron ang bataon nga baka bilang halad sa pagpakatinlo para matinluan siya kag ang iya panimalay. ");
INSERT INTO hil_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Dayon kuhaon niya ang duha ka kanding kag dal-on man niya sa presensya sang Ginoo, didto dampi sa puwertahan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Kag gabot-gabutan niya kon diin sa duha ka kanding ang para sa Ginoo kag ang para kay Azazel. ");
INSERT INTO hil_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ang kanding nga nagabutan para sa Ginoo ihalad niya bilang halad sa pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Pero ang kanding nga nagabutan para kay Azazel, ihalad niya ini nga buhi sa presensya sang Ginoo kag dayon buy-an niya sa kamingawan, para matubos ang mga tawo sa ila mga sala. ");
INSERT INTO hil_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Ihawon ni Aaron ang bataon nga baka bilang halad sa pagpakatinlo para sa iya kaugalingon kag sa iya panimalay. ");
INSERT INTO hil_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Dayon magkuha siya sang bulutangan sang insenso kag pun-on niya ini sang baga nga halin sa halaran didto sa presensya sang Ginoo. Kag magkuha man siya sang duha ka hakop sang mahamot nga insenso nga mapino, kag dal-on niya ini sa Labing Balaan nga Lugar. ");
INSERT INTO hil_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Didto sa presensya sang Ginoo, ibutang niya ang insenso sa kalayo, kag ang aso sini magalikop sa takop sang Kahon sang Kasuguan, para indi siya mapatay. ");
INSERT INTO hil_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Magkuha siya sang dugo sang baka kag magtindog siya sa atubangan sang Kahon nga nagaatubang sa east. Kag paagi sa iya tudlo wisikan niya ang takop sini sing makapito ka beses. ");
INSERT INTO hil_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Ihawon man niya ang kanding bilang halad sa pagpakatinlo para sa mga tawo. Dal-on niya ang dugo sini sa Labing Balaan nga Lugar kag iwisik ini sa takop sang Kahon sang Kasugtanan, pareho sa ginhimo niya sa dugo sang baka. ");
INSERT INTO hil_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Paagi sa sining himuon ni Aaron, matinluan ang Labing Balaan nga Lugar tungod sa pagkahigko sang mga Israelinhon kag tungod sa tanan nila nga mga sala kag mga paglapas. Himuon man niya ini sa iban nga mga parte sang Tolda nga ara sa tunga sang mahigko nga katawhan. ");
INSERT INTO hil_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kinahanglan nga wala sing tawo nga magtiner sa Tolda halin sa oras nga magsulod si Aaron sa Labing Balaan nga Lugar hasta nga magguwa siya. Pagkatapos nga nahimo na niya didto ang seremonya para matubos siya kag ang iya panimalay kag ang bilog nga komunidad sang Israel, ");
INSERT INTO hil_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","magguwa siya kag magkadto sa halaran sa presensya sang Ginoo. Dayon magkuha siya sang dugo sang baka kag sang kanding nga ginhalad kag ilamhit niya ini sa mga sulosungay sang halaran sa pagtinlo sini. ");
INSERT INTO hil_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Dayon isawsaw niya ang iya tudlo sa dugo kag wisikan sing makapito ka beses ang halaran sa pagdedikar sini sa Ginoo kag sa pagtinlo sini tungod sa pagkahigko sang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Pagkatapos nga nahimo ni Aaron ang pagtinlo sang Labing Balaan nga Lugar kag sang iban pa nga mga parte sang Tolda lakip na ang halaran, dal-on niya sa tunga ang buhi nga kanding. ");
INSERT INTO hil_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Itungtong niya ang iya duha ka kamot sa ulo sang kanding kag ituad niya ang tanan nga sala kag paglapas sang mga Israelinhon. Sa sini nga paagi masaylo ang ila mga sala sa ulo sang kanding. Pabuy-an dayon ni Aaron ang kanding sa kamingawan sa tawo nga gintugyanan sini. ");
INSERT INTO hil_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Gani dal-on sang kanding ang tanan nga sala sang mga Israelinhon kon buy-an na ini sang tawo sa kamingawan. ");
INSERT INTO hil_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Dayon masulod si Aaron sa Tolda kag ubahon niya ang iya bayo bilang pangulo nga pari nga ginsuksok niya sang wala pa siya magsulod sa Labing Balaan nga Lugar, kag ibilin niya ini didto. ");
INSERT INTO hil_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Magpaligo siya sa isa ka balaan nga lugar didto sa Tolda kag pagkatapos isuksok niya ang iya ordinaryo nga bayo. Dayon magguwa siya kag ihalad niya ang duha ka halad nga ginasunog para matubos siya kag ang mga Israelinhon sa ila mga sala. ");
INSERT INTO hil_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Sunugon man niya sa halaran ang mga tambok sang halad sa pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Ang tawo nga gintugyanan sa pagbuhi sang kanding nga para kay Azazel kinahanglan nga labhan niya ang iya bayo kag magpaligo antes siya magbalik sa kampo. ");
INSERT INTO hil_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Kinahanglan man nga dal-on sa guwa sang kampo kag sunugon ang nabilin nga parte sang baka kag kanding nga ang ila dugo gindala sa Labing Balaan nga Lugar sa pagtinlo sini. ");
INSERT INTO hil_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ang tawo nga magsunog sini kinahanglan man nga labhan niya ang iya bayo kag magpaligo antes siya magbalik sa kampo. ");
INSERT INTO hil_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","31","Amo ini ang mga pagsulundan nga himuon sang mga tumandok nga mga Israelinhon kag sang mga pangayaw nga nagaestar upod sa ila, nga pagatumanon nila hasta san-o. Sa ikanapulo nga adlaw sang ikapito nga bulan kinahanglan nga magpuasa sila kag indi mag-obra, pareho kon Adlaw nga Inugpahuway. Kay amo ina ang adlaw nga himuon ang seremonya sa pagtubos sa ila sa ila mga sala para mangin matinlo sila sa presensya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ang pari nga ginpili kag gin-ordinahan sa pagbulos sa iya amay bilang pangulo nga pari amo ang maghimo sang seremonya. Isuksok niya ang iya sulul-ubon bilang pangulo nga pari, ");
INSERT INTO hil_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","kag himuon niya ang seremonya sa pagtinlo sa Labing Balaan nga Lugar, sa iban pa nga mga parte sang Tolda lakip na ang halaran, sa mga pari, kag sa bilog nga komunidad. ");
INSERT INTO hil_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Kinahanglan nga tumanon nila ini nga pagsulundan hasta san-o. Kag himuon nila ini sing makaisa kada tuig. Kag natuman ini suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Ginsugo sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","nga ihambal ini kay Aaron kag sa iya mga anak nga lalaki kag sa tanan nga Israelinhon: ");
INSERT INTO hil_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ang bisan sin-o sa inyo nga maghalad sang baka, karnero, ukon kanding sa iban nga lugar ");
INSERT INTO hil_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","5","kag indi sa Tolda nga Simbahan (nga ginatawag man nga Tolda nga Ginapakigkitaan), pareho lang nga nakapatay siya sang tawo, gani indi na ninyo siya pagkabigon nga sakop ninyo. Ginhatag ina nga sugo para himuon ninyo ang paghalad didto dampi sa puwertahan sang Tolda kag indi sa iban nga lugar. Gani ang inyo halad nga para sa maayo nga relasyon ihatag ninyo sa pari nga amo ang magahalad sini sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Iwisik-wisik sang pari ang dugo sang sapat sa halaran nga para sa Ginoo, nga ara dampi sa puwertahan sang Tolda. Dayon sunugon niya ang mga tambok sang sapat; ang kahamot sini makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Gani indi na kamo dapat maghalad sa mga demonyo nga sa dagway sang kanding, kay ina makapahilayo sa inyo sa Ginoo. Dapat tumanon ninyo ini hasta sa palaabuton nga mga henerasyon. ");
INSERT INTO hil_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Tandaan gid ninyo ini, kamo nga mga Israelinhon kag ang mga pangayaw nga nagaestar upod sa inyo: Ang bisan sin-o sa inyo nga maghalad sang bisan ano nga halad sa iban nga lugar ");
INSERT INTO hil_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","kag indi sa puwertahan dampi sang Tolda, indi na ninyo siya pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Ang bisan sin-o sa inyo nga magkaon sang dugo kontrahon sang Ginoo kag indi na ninyo siya pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Kay ang kabuhi sang tagsa ka tinuga ara sa iya dugo kag ginsugo kamo sang Ginoo nga gamiton ninyo ini para matubos kamo sa inyo mga sala, kay ang dugo nga amo ang nagahatag sang kabuhi, amo ang makatubos sa tawo sa iya mga sala. ");
INSERT INTO hil_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Amo ini ang kabangdanan kon ngaa indi kamo dapat magkaon sang dugo. ");
INSERT INTO hil_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Ang bisan sin-o sa inyo nga magdakop sang sapat ukon pispis nga puwede kaunon, kinahanglan nga paguwaon niya ang dugo sini kag tabunan sang duta, ");
INSERT INTO hil_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","tungod kay ang kabuhi sang tagsa ka tinuga ara sa iya dugo. Amo gani nga ginhambalan kamo sang Ginoo nga indi kamo magkaon sang dugo sang bisan ano nga tinuga; kag ang bisan sin-o nga magkaon indi na ninyo pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Ang bisan sin-o sa inyo nga magkaon sang sapat nga napatay lang ukon ginpatay sang iban nga sapat, kinahanglan nga labhan niya ang iya bayo kag magpaligo, pero kabigon pa siya nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Kon indi siya maglaba sang iya bayo kag indi siya magpaligo, may salabton siya. ");
INSERT INTO hil_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Ginsugo sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","nga ihambal ini sa mga Israelinhon: Ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Kinahanglan nga indi ninyo paghimuon ang mga ginahimo sang mga tawo sa Egypt nga sa diin nag-estar kamo sang una, kag ang mga ginahimo sang mga tawo sa Canaan nga sa diin pagadal-on ko kamo. ");
INSERT INTO hil_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","5","Kinahanglan nga tumanon ninyo ang akon mga sugo kag mga pagsulundan kay ang tawo nga nagatuman sini makaangkon sang kabuhi. Ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Wala sing bisan sin-o sa inyo nga magpakigrelasyon sa iya malapit nga paryente. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","8","Indi pagpakahuy-i ang imo amay paagi sa pagpakighilawas sa imo iloy ukon sa iban pa niya nga asawa. ");
INSERT INTO hil_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Indi ka magpakighilawas sa imo utod nga babayi, bisan utod mo lang siya sa imo amay ukon sa imo iloy, kag bisan nagdako siya sa inyo ukon wala. ");
INSERT INTO hil_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Indi ka magpakighilawas sa imo apo nga babayi, kay makahatag ini sang kahuy-anan sa imo. ");
INSERT INTO hil_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Indi ka magpakighilawas sa anak nga babayi sang imo amay sa iban niya nga asawa, kay utod mo man siya. ");
INSERT INTO hil_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","13","Indi ka magpakighilawas sa imo tiya, bisan utod man siya sang imo amay ukon iloy. ");
INSERT INTO hil_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Indi pagpakahuy-i ang utod nga lalaki sang imo amay paagi sa pagpakighilawas sa iya asawa, kay tiya mo man siya. ");
INSERT INTO hil_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Indi ka magpakighilawas sa imo umagad nga babayi kay asawa siya sang imo anak. ");
INSERT INTO hil_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Indi ka magpakighilawas sa imo bayaw nga babayi kay makahatag ini sang kahuy-anan sa imo utod. ");
INSERT INTO hil_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Indi ka magpakighilawas sa anak ukon apo nga babayi sang babayi nga ginahuliran mo, kay mag-iloy ukon maglola sila, kag malaw-ay ina nga himuon. ");
INSERT INTO hil_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Indi mo pagpangasaw-on ang utod nga babayi sang imo asawa samtang buhi pa ang imo asawa. ");
INSERT INTO hil_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Indi ka magpakighilawas sa babayi nga ara ang iya pamulanon kay ginakabig siya nga mahigko. ");
INSERT INTO hil_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Indi ka magpakighilawas sa asawa sang iban, kay kon himuon mo ini kabigon ka nga mahigko. ");
INSERT INTO hil_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Indi mo pag-ihatag ang imo anak para ihalad sa dios nga si Molek, kay makahatag ina sang kahuy-anan sa akon nga imo Dios. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Indi ka magpakighilawas sa imo kapareho nga lalaki, kay makangilil-ad ina. ");
INSERT INTO hil_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Indi magpakighilawas ang lalaki ukon babayi sa sapat, kay mahigko kag malain gid ina. ");
INSERT INTO hil_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Indi ninyo paghigkui ang inyo kaugalingon paagi sa paghimo sang bisan diin sa sina nga mga butang, kay amo ina ang nakapahigko sa mga tawo nga ginapahalin ko sa duta nga para sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","28","Kag bisan gani ina nga duta nahigkuan tungod sinang ila ginahimo, gani ginpadal-an ko sang mga kalamidad ina nga duta para sa sini nga paagi maghalalin sila dira. Pero kamo nga mga tumandok nga mga Israelinhon kag ang mga pangayaw nga nagaestar upod sa inyo, indi gid ninyo paghimuon inang makangilil-ad nga mga butang kundi tumanon gid ninyo ang akon mga pagsulundan kag mga sugo. Kay kon higkuan man ninyo ang duta paagi sa paghimo sang sina nga mga butang, pahalinon man kamo sa sina nga duta pareho sang mga katawhan nga una sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Ang bisan sin-o nga maghimo sang sina nga makangilil-ad nga mga butang indi na ninyo pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Gani tumana ninyo ang ginapatuman ko sa inyo kag indi gid ninyo pagsundon ang makangilil-ad nga ginahimo sang mga tawo nga una sa inyo, para indi ninyo mahigkuan ang inyo kaugalingon tungod sini. Ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ginsugo sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","nga ihambal ini sa bilog nga komunidad sang Israel: Magkabuhi kamo nga balaan kay ako, ang Ginoo nga inyo Dios, balaan. ");
INSERT INTO hil_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Kinahanglan nga tahuron ninyo ang inyo iloy kag amay, kag kinahanglan nga tumanon ninyo ang akon mga ginapahimo sa inyo sa mga Adlaw nga Inugpahuway. Ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Indi kamo magsimba sa mga dios-dios ukon maghimo sang mga imahen nila. Ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Kon maghalad kamo sa akon sang halad nga para sa maayo nga relasyon, ihalad ninyo ini sa paagi nga mabaton ko para sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Kaunon ninyo ang karne sini sa adlaw sang inyo paghalad ukon sa sunod nga adlaw. Pero kon may mabilin nga karne hasta sa ikatatlo nga adlaw kinahanglan nga sunugon na ini. ");
INSERT INTO hil_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kon kaunon ninyo ini sa ikatatlo nga adlaw, indi ko ini pagbatunon kay makangilil-ad na ini. ");
INSERT INTO hil_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ang bisan sin-o nga magkaon sini may salabton tungod kay ginabaliwala niya ang butang nga para sa akon; gani ina nga tawo indi na ninyo pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Kon mag-ani kamo indi ninyo pag-ubuson ani ang ara sa higad sang inyo talamnan, kag indi na ninyo pagbalikon kag siputon ang mga nabilin. ");
INSERT INTO hil_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Amo man sa talamnan sang ubas, indi na ninyo pagbalikon kag kuhaon ang mga bunga nga nabilin ukon ang mga nagkalahulog. Ibilin na lang ninyo ina sa mga imol kag sa mga pangayaw. Ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Indi kamo magpangawat, ukon magbutig, ukon magpangdaya sa inyo isigkatawo. ");
INSERT INTO hil_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Indi kamo magpanumpa sang butig sa akon ngalan, kay kon himuon ninyo ina ginapakahuy-an ninyo ang ngalan sang inyo Dios. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Indi ninyo pagpamintahaan ukon pagkawatan ang inyo isigkatawo. Indi na ninyo pagpabuwasan ang paghatag sang suweldo sang tawo nga ginpaobra ninyo. ");
INSERT INTO hil_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Indi ninyo paghambali sang malain ang bungol, kag indi kamo magbutang sang makapasandad sa alagyan sang bulag. Himua ninyo ini sa pagpakita nga nagatahod kamo sa akon nga inyo Dios. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Dapat husto kag matarong ang inyo nga paghukom sa korte; indi ninyo pagpaburan ang manggaranon ukon ang imol. ");
INSERT INTO hil_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Indi kamo magkutsokutso sa inyo isigkatawo. Indi kamo maghimo sang bisan ano nga makaguba sang iya kabuhi. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Indi ninyo pagdumti ang inyo isigkatawo. Sabdunga ninyo siya kon nakasala siya para wala kamo sing salabton. ");
INSERT INTO hil_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Indi kamo magbalos ukon magdumot sa iban, kundi higugmaa ninyo ang inyo kapareho pareho sang inyo paghigugma sa inyo kaugalingon. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Tumana ninyo ang akon mga pagsulundan. Indi ninyo pagpakastahi ang isa ka sapat sa lain nga klase sang sapat. Indi kamo magtanom sang duha ka klase nga binhi sa isa ka talamnan. Indi kamo magsuksok sang bayo nga hinimo halin sa duha ka klase sang tela. ");
INSERT INTO hil_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Kon ang isa ka lalaki magpakighilawas sa isa ka ulipon nga babayi nga kalaslon na sa iban nga lalaki, pero ining babayi wala pa matubos ukon mahatagan sing kahilwayan, dapat silutan sila. Pero indi lang sila pagpatyon kay indi pa man hilway ang amo nga babayi. ");
INSERT INTO hil_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","22","Kinahanglan nga magdala ang lalaki sang lalaki nga karnero didto dampi sa puwertahan sang Tolda nga Ginapakigkitaan bilang halad nga bayad sa sala. Paagi sa paghalad sang pari sang karnero sa akon presensya, matubos ang lalaki sa iya nga sala kag patawaron ko siya. ");
INSERT INTO hil_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Kon mag-abot na kamo sa duta nga ihatag ko sa inyo, indi ninyo pagkaunon ang mga bunga sang mga kahoy nga inyo gintanom sa nahauna nga tatlo ka tuig. Kabigon ninyo ini nga mahigko. ");
INSERT INTO hil_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Sa ikaapat nga tuig, ang tanan nga bunga ihalad ninyo bilang pagdayaw sa akon, gani indi man ninyo ini pagkaunon. ");
INSERT INTO hil_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Pero sa ikalima nga tuig makakaon na kamo sang mga bunga. Kag kon tumanon ninyo ini nga mga pagsulundan, mangin bugana ang mga bunga sang inyo mga kahoy. Ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Indi kamo magkaon sang karne nga may dugo pa. Indi ninyo paghimuon ang ginahimo sang manugpakot ukon babaylan. ");
INSERT INTO hil_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Kon magpangasubo kamo sa patay indi ninyo pag-utdan ang inyo buhok sa palibot sang inyo ulo ukon ang inyo burangos, ");
INSERT INTO hil_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","kag indi man ninyo pagpilasan ang inyo lawas. Kag indi man kamo magpapika. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Indi ninyo pagpakahuy-i ang inyo mga anak nga babayi paagi sa pagpilit sa ila nga ibaligya ang ila lawas, kay makaimpluwensya ini sa inyo lugar kag magalapnag ang kalautan. ");
INSERT INTO hil_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Tumana ninyo ang akon mga ginapahimo sa inyo sa mga Adlaw nga Inugpahuway, kag tahura ninyo ang lugar nga ginasimbahan ninyo sa akon. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Indi kamo magdangop sa mga espiritista nga nagapakig-estorya sa kalag sang patay, kay kon himuon ninyo ini kabigon kamo nga mahigko. Ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Tahura ninyo ang mga tigulang, kag tahura man ninyo ako nga inyo Dios. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Indi ninyo pagtrataron sing malain ang mga pangayaw nga nagaestar upod sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Tratara ninyo sila nga daw kapareho ninyo, kag higugmaa ninyo sila pareho sang inyo paghigugma sa inyo kaugalingon, kay mga pangayaw man kamo sadto anay sa Egypt. Ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Indi kamo magdaya sa inyo pagkilo, pagtakos, ukon pagsukob. ");
INSERT INTO hil_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","37","Gamita ninyo ang husto nga kilohan, talaksan, ukon sulukban. Ako ang Ginoo nga inyo Dios nga nagpaguwa sa inyo sa Egypt. Tumana ninyo ang tanan ko nga mga pagsulundan kag mga sugo. ");
INSERT INTO hil_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Ginsugo sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","nga ihambal ini sa mga Israelinhon: Ang bisan sin-o sa inyo kag sa mga pangayaw nga nagaestar sa Israel nga maghalad sang iya anak sa dios nga si Molek, kinahanglan nga batuhon siya sang pumuluyo hasta nga mapatay gid. ");
INSERT INTO hil_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","4","Kontrahon ko ina nga tawo kag indi na ninyo siya pagkabigon nga sakop ninyo. Kay sa iya paghalad sang iya anak kay Molek, ginhigkuan niya ang lugar nga ginasimbahan sa akon kag ginpakahuy-an niya ang akon balaan nga ngalan. Kon pabay-an lang ninyo ina nga tawo, ");
INSERT INTO hil_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ako mismo ang magakontra sa iya kag sa iya pamilya kag sa tanan nga nagsunod sa iya sa paghalad kay Molek. Indi ko sila pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Kontrahon ko man ang tawo nga magdangop kag magsunod sa mga espiritista nga nagapakig-estorya sa kalag sang patay. Indi ko sila pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Iseparar ninyo ang inyo kaugalingon para sa akon kag magkabuhi kamo nga balaan, tungod kay ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Tumana ninyo ang akon mga pagsulundan kay ako amo ang Ginoo nga nagaseparar sa inyo para sa akon. ");
INSERT INTO hil_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ang bisan sin-o nga magpakamalaot sa iya amay ukon iloy kinahanglan nga patyon. Siya ang responsable sang iya kamatayon. ");
INSERT INTO hil_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Kon ang isa ka lalaki magpakighilawas sa asawa sang iban, siya kag ang babayi kinahanglan nga patyon. ");
INSERT INTO hil_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Kon ang isa ka lalaki magpakighilawas sa isa sang mga asawa sang iya amay, ginpakahuy-an niya ang iya amay. Gani sila nga duha sang babayi kinahanglan nga patyon. Sila ang responsable sang ila kamatayon. ");
INSERT INTO hil_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Kon ang amay magpakighilawas sa iya umagad nga babayi, sila nga duha kinahanglan nga patyon. Kay kalain ang ila ginhimo. Sila ang responsable sang ila kamatayon. ");
INSERT INTO hil_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Kon ang isa ka lalaki magpakighilawas sa iya kapareho nga lalaki, sila nga duha kinahanglan nga patyon kay makangilil-ad ang ila ginhimo. Sila ang responsable sang ila kamatayon. ");
INSERT INTO hil_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Kon ang isa ka lalaki magpakigrelasyon sa mag-iloy, kinahanglan nga sunugon sila nga tatlo, kay malain gid ang ila ginhimo. Indi dapat nga magpabilin ini nga kalainan sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","16","Kon ang isa ka lalaki ukon babayi magpakighilawas sa isa ka sapat, kinahanglan nga patyon siya kag ang sapat. Sila ang responsable sang ila kamatayon. ");
INSERT INTO hil_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Kon ang isa ka lalaki magpakigrelasyon kag maghulid sa iya utod nga babayi, bisan utod man niya ini sa iya amay ukon sa iya iloy, ginpakahuy-an niya ang iya utod gani may salabton siya. Kag tungod nga makahuluya ang ginhimo nila nga duha, indi na ninyo sila pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Kon ang isa ka lalaki maghulid sa babayi nga ara ang iya pamulanon, kag magsugot ang babayi, indi na ninyo sila nga duha pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Kon ang isa ka lalaki magpakighilawas sa iya tiya, ginpakahuy-an niya ang iya tiya. Sila nga duha may salabton sa ila nga ginhimo. ");
INSERT INTO hil_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Kon ang isa ka lalaki magpakighilawas sa asawa sang iya tiyo, ginpakahuy-an niya ang iya nga tiyo. Sila nga duha may salabton, kag mapatay lang sila nga wala sing bata. ");
INSERT INTO hil_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Kon ang isa ka lalaki magpakigrelasyon sa asawa sang iya utod, ginpakahuy-an niya ang iya utod. Kag tungod kay mahigko ang ila ginhimo, mapatay lang sila nga wala sing bata. ");
INSERT INTO hil_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Tumana ninyo ang tanan ko nga mga pagsulundan kag mga sugo para indi kamo pagpahalinon sa duta nga pagadal-an ko sa inyo nga inyo estaran. ");
INSERT INTO hil_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ang mga katawhan nga pahalinon ko sa sadto nga duta nagahimo sang sini nga mga kalautan, kag tungod sini ginakangil-aran ko sila. Gani indi ninyo pagsundon ang ila ginahimo. ");
INSERT INTO hil_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Kag suno sa ginsiling ko sa inyo, mangin inyo ang ila nga duta. Ihatag ko sa inyo ining maayo kag mapatubason nga duta para inyo panag-iyahan. Ako ang Ginoo nga inyo Dios nga nagseparar sa inyo sa iban nga mga katawhan. ");
INSERT INTO hil_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Dapat nahibaluan ninyo kon ano ang matinlo kag ang mahigko nga mga sapat pati mga pispis. Indi ninyo paghigkui ang inyo kaugalingon paagi sa pagkaon sang mahigko nga mga sapat nga gindumili ko sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Magkabuhi kamo nga balaan kay ako, ang Ginoo, balaan. Ginseparar ko kamo sa iban nga mga katawhan nga mangin akon. ");
INSERT INTO hil_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Kon may ara sa inyo sang espiritista nga nagapakig-estorya sa kalag sang patay, kinahanglan nga batuhon siya hasta nga mapatay gid. Siya ang responsable sang iya nga kamatayon. ");
INSERT INTO hil_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Ginsugo sang Ginoo si Moises nga ihambal ini sa mga pari nga kaliwat ni Aaron: Indi ninyo paghigkuan ang inyo kaugalingon paagi sa pagpartisipar sa lubong sang inyo kapareho nga Israelinhon, ");
INSERT INTO hil_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","luwas lang kon ang napatay malapit ninyo nga paryente pareho sang inyo iloy, amay, anak, utod nga lalaki, ");
INSERT INTO hil_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ukon utod nga babayi nga wala pa sing bana kag nagadepende pa sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Indi man ninyo paghigkuan ang inyo kaugalingon paagi sa pagpartisipar sa lubong sang paryente sang inyo asawa. ");
INSERT INTO hil_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Kon magpangasubo kamo sa patay, indi ninyo pagkiskisan ang bisan diin nga parte sang inyo ulo ukon utdan ang inyo burangos, ukon pilasan ang inyo lawas. ");
INSERT INTO hil_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Kinahanglan nga iseparar ninyo ang inyo kaugalingon para sa akon nga inyo Dios, kag indi ninyo pagpakahuy-an ang akon ngalan. Himuon ninyo ini tungod nga kamo ang nagahalad sang mga halad nga paagi sa kalayo, nga amo ang akon pagkaon. ");
INSERT INTO hil_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Kinahanglan nga indi kamo magpangasawa sang babayi nga mahigko tungod kay nagabaligya siya sang iya lawas, ukon sang babayi nga ginbulagan sang iya bana, tungod nga ginseparar kamo para sa akon. ");
INSERT INTO hil_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Kinahanglan nga kabigon kamo sang inyo kapareho nga mga Israelinhon nga balaan kay kamo ang nagahalad sang mga halad, nga amo ang akon pagkaon. Huo, dapat gid nga kabigon nila kamo nga balaan kay ako, ang Ginoo, balaan, kag ginahimo ko ang akon katawhan nga balaan. ");
INSERT INTO hil_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Kon may anak kamo nga babayi nga nagapakahuya sa inyo tungod kay nagabaligya siya sang iya lawas, kag tungod sini ginakabig siya nga mahigko, kinahanglan nga sunugon siya. ");
INSERT INTO hil_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Kon ang pangulo nga parimagpangasubo sa patay, dapat indi niya paggumunon ang iya buhok kag indi niya paggision ang iya bayo. ");
INSERT INTO hil_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Dapat indi niya paghigkuan ang iya kaugalingon paagi sa pagpalapit sa patay, bisan pa iya ini amay ukon iloy. ");
INSERT INTO hil_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Kag tungod kay ginhalad siya sa akon bilang pangulo nga pari paagi sa paghaplas sa iya sang lana, indi siya dapat maghalin sa akon Balaan nga Tolda para magpartisipar sa lubong, kay kon himuon niya ini mahigkuan ang Tolda. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","14","Ang pangasaw-on sang pangulo nga pari kinahanglan birhen kag kapareho niya nga Israelinhon. Indi siya magpangasawa sang balo, ukon sang babayi nga ginbulagan sang iya bana, ukon sang babayi nga mahigko tungod kay nagabaligya siya sang iya lawas. ");
INSERT INTO hil_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Sa sini nga paagi indi makabig nga mahigko ang iya mga anak. Ako ang Ginoo nga nagaseparar sa iya para sa akon. ");
INSERT INTO hil_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ginsugo sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","nga ihambal ini kay Aaron: Wala sing bisan sin-o sa imo mga kaliwat hasta sa palaabuton nga mga henerasyon nga makahalad sang mga halad, nga amo ang akon pagkaon, kon may deperensya ang iya lawas. ");
INSERT INTO hil_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Indi puwede ang bulag, lupog, may deperensya ang iya nawong, indi normal ang isa ka parte sang iya lawas, ");
INSERT INTO hil_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","may bali ang iya tiil ukon kamot, ");
INSERT INTO hil_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","buktot, inano, may balatian sa mata ukon sa panit, ukon indi makapabata. ");
INSERT INTO hil_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","23","Gani kon ang isa mo ka kaliwat may deperensya, indi siya puwede nga maghalad sa akon sang mga halad nga paagi sa kalayo, nga amo ang akon pagkaon. Indi man siya puwede nga magsulod sa Balaan nga Lugar kag magpalapit sa halaran kay mahigkuan ang akon Tolda. Pero puwede siya makakaon sang pagkaon nga parte nila nga mga pari sa balaan nga halad kag sa labing balaan nga halad. Ako ang Ginoo nga nagaseparar sa inyo para sa akon. ");
INSERT INTO hil_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ginhambal ini tanan ni Moises kay Aaron kag sa iya mga anak nga lalaki, kag sa tanan nga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Ginsugo sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","nga ihambal ini kay Aaron kag sa iya mga anak nga lalaki: Indi ninyo pagpakahuy-an ang akon balaan nga ngalan, gani tahura ninyo ang mga halad nga ginahalad sang mga Israelinhon sa akon. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Kon may ara sa inyo ukon sa inyo mga kaliwat sa palaabuton nga mga henerasyon nga magtandog sang halad nga para sa akon bisan mahigko siya, indi na gid siya makaalagad bilang pari. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","7","Wala sing bisan sin-o sa inyo nga makakaon sang halad kon may delikado siya nga balatian sa panit, ukon may nagaguwa sa iya kinatawo tungod sang iya balatian, ukon nahikapan niya ang butang nga mahigko tungod nga nakatandog ini sa patay, ukon naguwaan siya sang semilya, ukon nakatandog siya sang sapat ukon tawo nga ginakabig nga mahigko. Makakaon lang siya sang mga halad kon makapaligo na siya, pero mahulat siya anay hasta sa hapon kon magsalop na ang adlaw kag dayon makakaon na siya sang mga halad nga amo ang iya kalan-on bilang pari. ");
INSERT INTO hil_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Indi kamo dapat magkaon sang bisan ano nga karne sang sapat nga napatay lang ukon ginpatay sang iban nga sapat, kay kon himuon ninyo ini kabigon kamo nga mahigko. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Indi ninyo pag-ibaliwala ang akon ginapatuman sa inyo. Kinahanglan nga tumanon gid ninyo ini para indi kamo magkasala kag magkalamatay. Ako ang Ginoo nga nagaseparar sa inyo para sa akon. ");
INSERT INTO hil_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Kamo lang nga mga pari kag ang inyo panimalay ang makakaon sang parte sang mga halad nga para sa inyo. Indi puwede magkaon sini ang inyo bisita ukon ang inyo sinuhulan nga trabahador. ");
INSERT INTO hil_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Pero puwede nga magkaon ang ulipon nga ginbakal ninyo ukon natawo sa inyo panimalay. ");
INSERT INTO hil_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Indi man makakaon sini ang anak nga babayi sang pari nga nakapamana sang indi pari. ");
INSERT INTO hil_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Pero kon nabalo siya ukon nagbulagay sila sang iya bana nga wala sila sang bata, kag mag-estar siya liwat sa iya amay, makakaon siya sang pagkaon nga ginabaton sang iya amay bilang pari. Tandaan gid ninyo nga kamo lang nga mga pari kag ang inyo panimalay ang makakaon sang parte sang mga halad nga para sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Pero kon ang isa ka tawo nga indi miyembro sang inyo panimalay nakakaon sini nga indi niya hungod, kinahanglan nga ulian niya ini sa inyo kag dugangan pa gid niya sang 20 porsiyento sang bili sini. ");
INSERT INTO hil_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Kamo nga mga pari, indi ninyo pag-ibaliwala ang mga halad sang mga Israelinhon para sa akon, ");
INSERT INTO hil_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","agod nga sa pagkaon ninyo sini indi kamo makasala kag wala kamo sing salabton. Ako ang Ginoo nga nagaseparar sa inyo para sa akon. ");
INSERT INTO hil_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Ginsugo sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","nga ihambal ini kay Aaron kag sa iya mga anak nga lalaki, sa tanan nga kapareho nila nga mga Israelinhon, pati sa mga pangayaw sa Israel: Kon ang halad nga ginasunog ihalad ninyo bilang halad sa pagtuman sang isa ka panaad ukon halad nga kinabubut-on, ");
INSERT INTO hil_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","kinahanglan nga lalaki ini nga baka, karnero, ukon kanding nga wala sing deperensya para batunon ko. ");
INSERT INTO hil_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Indi kamo maghalad sing may deperensya kay indi ko gid ini pagbatunon. ");
INSERT INTO hil_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Kon ang halad nga para sa maayo nga relasyon ihalad ninyo sa akon bilang halad sa pagtuman sang isa ka panaad ukon halad nga kinabubut-on, kinahanglan nga baka ini ukon karnero ukon kanding nga wala sing deperensya para batunon ko. ");
INSERT INTO hil_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Indi kamo maghalad sa akon sang sapat nga bulag, nabalian, napilasan, ukon may balatian sa panit. Indi gid ninyo ini pag-ihalad sa akon sa halaran bilang halad nga paagi sa kalayo. ");
INSERT INTO hil_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Pero puwede ninyo ihalad bilang halad nga kinabubut-on ang baka ukon karnero ukon kanding nga indi normal ang isa ka parte sang iya lawas, pero indi ini puwede nga ihalad bilang halad sa pagtuman sang isa ka panaad. ");
INSERT INTO hil_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Indi kamo maghalad sa akon sang sapat nga may deperensya ang iya itlog, ukon ginkapon. Indi gid ninyo ini paghimuon sa inyo lugar. ");
INSERT INTO hil_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Kag indi man kamo magbakal sang sina nga klase sang mga sapat halin sa mga taga-iban nga lugar kag ihalad sa akon bilang akon pagkaon, kay indi ko ina pagbatunon. ");
INSERT INTO hil_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","27","Ang bag-o natawo nga baka, karnero, ukon kanding dapat magpabilin sa iya iloy sa sulod sang pito ka adlaw. Pero halin sa ikawalo nga adlaw puwede na ini ihalad sa akon bilang halad nga paagi sa kalayo. ");
INSERT INTO hil_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Indi ninyo pag-ihalad sing dungan ang baka ukon karnero ukon kanding kag ang iya bata sa isa lang ka adlaw. ");
INSERT INTO hil_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Kon maghalad kamo sang halad sa pagpasalamat sa akon, sundon ninyo ang husto nga pamaagi sa paghalad sini para batunon ko. ");
INSERT INTO hil_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Kag kinahanglan nga kaunon ninyo ini sa sina mismo nga adlaw sang paghalad kag indi gid ninyo pagbilinan hasta sa masunod nga aga. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Tumana ninyo ang akon mga sugo. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Indi ninyo pagpakahuy-an ang akon balaan nga ngalan, kag kilalahon ninyo ako nga balaan. Ako ang Ginoo nga nagaseparar sa inyo para sa akon, ");
INSERT INTO hil_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","kag ako amo ang nagpaguwa sa inyo sa Egypt para mangin inyo Dios. Huo, ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Ginsugo sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","nga ihambal sa mga Israelinhon ang ini nga mga pagsulundan parte sa natalana nga mga piesta, nga magatilipon sila sa pagsimba sa Ginoo: ");
INSERT INTO hil_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","May anom kamo ka adlaw sa pag-obra, pero sa ikapito nga adlaw magpahuway kamo kay amo ina ang Adlaw nga Inugpahuway. Indi kamo mag-obra sa sina nga adlaw kundi magtipon kamo sa pagsimba, kay adlaw ina nga padunggan ninyo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Amo ini ang natalana nga mga piesta nga magatilipon ang mga Israelinhon sa pagsimba sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Ang Piesta sang Paglabay sang Anghel ginahiwat sa gab-i sang ika-14 nga adlaw sang nahauna nga bulan. ");
INSERT INTO hil_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Kag sa ika-15 nga adlaw sang amo gihapon nga bulan, magaumpisa naman ang Piesta sang Tinapay nga Wala sing Inugpahabok. Pito ka adlaw ini nga piesta, kag sa sina nga mga inadlaw ang tinapay nga kaunon ninyo kinahanglan wala sing inugpahabok. ");
INSERT INTO hil_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Sa nahauna nga adlaw sang sini nga piesta, indi kamo mag-obra kundi magtipon kamo sa pagsimba sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Sa sulod sang pito ka adlaw maghalad kamo sa Ginoo sang halad nga paagi sa kalayo. Kag sa ikapito nga adlaw indi kamo liwat mag-obra kundi magtipon kamo sa pagsimba sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","11","Kon didto na kamo sa duta nga ihatag sang Ginoo sa inyo, ihalad ninyo sa iya ang una nga binugkos nga mga uhay nga naani ninyo. Dal-on ninyo ini sa pari sa sunod nga adlaw sa tapos sang Adlaw nga Inugpahuway, kag bayawon ini sang pari sa presensya sang Ginoo para batunon kamo sang Ginoo paagi sini. ");
INSERT INTO hil_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Sa sina man nga adlaw, maghalad man kamo sa Ginoo sang karnero nga isa ka tuig nga wala sing deperensya bilang halad nga ginasunog. ");
INSERT INTO hil_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Lakipan ninyo ini sang halad nga regalo nga apat ka kilo nga harina nga maayo nga klase kag ginmikslahan sang mantika, kag halad nga ilimnon nga isa ka litro nga bino. Halad ini nga paagi sa kalayo, kag ang kahamot sini makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Kon wala pa ninyo mahalad ina, indi gid kamo dapat magkaon sang bisan ano nga klase sang pagkaon halin sa inyo bag-o nga inani, hilaw man ini ukon sinanlag ukon ginluto nga tinapay. Ini nga pagsulundan dapat tumanon ninyo hasta sa palaabuton nga mga henerasyon, bisan diin kamo mag-estar. ");
INSERT INTO hil_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","17","Pagkaligad sang pito ka semana umpisa sa adlaw nga naghalad kamo sadtong binugkos nga mga uhay, magtipon kamo kag maghalad liwat sang halad nga regalo halin sa sadtong mga uhay nga bag-o lang ninyo inani. Ini bali sa ika-50 nga adlaw, nga amo ang adlaw pagkatapos sang ikapito nga Adlaw nga Inugpahuway. Ang ihalad ninyo duha ka tinapay nga ang kada isa hinimo halin sa apat ka kilo nga harina nga maayo nga klase, nga may inugpahabok. Ihalad ninyo ini bilang halad nga ginabayaw halin sa nahauna ninyo nga patubas. ");
INSERT INTO hil_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Parisan ninyo ini sang pito ka bataon nga karnero nga lalaki nga tag-isa ka tuig, isa ka bataon nga baka, kag duha ka gulang nga karnero nga lalaki, nga ang kada isa sa ila wala sing deperensya. Ihalad ninyo ini bilang halad nga ginasunog upod sa halad nga regalo kag pati sa halad nga ilimnon. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Dayon maghalad man kamo sang isa ka lalaki nga kanding bilang halad sa pagpakatinlo, kag duha ka karnero nga tag-isa ka tuig bilang halad nga para sa maayo nga relasyon. ");
INSERT INTO hil_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Bayawon sang pari sa presensya sang Ginoo ang duha ka karnero kag ang halad nga halin sa nahauna nga patubas. Balaan ini nga mga halad para sa Ginoo kay parte ini sang mga pari. ");
INSERT INTO hil_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Sa amo man nga adlaw indi kamo mag-obra kundi magtipon kamo sa pagsimba sa Ginoo. Ini nga pagsulundan dapat tumanon ninyo hasta sa palaabuton nga mga henerasyon, bisan diin kamo mag-estar. ");
INSERT INTO hil_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Kon mag-ani kamo, indi ninyo pag-ubusa ani ang ara sa higad sang inyo talamnan, kag indi ninyo pagbalikon kag siputon ang mga nabilin. Ibilin na lang ninyo ina sa mga imol kag sa mga pangayaw. Ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","Sa nahauna nga adlaw sang ikapito nga bulan, magpahuway kamo bilang pagdumdom sa Ginoo. Kon mabatian ninyo ang pagtunog sang mga trumpeta, magtipon kamo sa pagsimba sa iya. ");
INSERT INTO hil_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Indi kamo mag-obra sa sina nga adlaw kundi maghalad kamo sa Ginoo sang halad nga paagi sa kalayo. ");
INSERT INTO hil_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","28","Ang ikanapulo nga adlaw sang sina nga ikapito nga bulan amo ang Adlaw sang Pagtubos. Indi kamo mag-obra sa sina nga adlaw kundi magtipon kamo sa pagsimba sa Ginoo nga may pagpuasa, kag maghalad kamo sa iya sang halad nga paagi sa kalayo. Kay sa sina nga adlaw himuon ang seremonya sa pagtubos sa inyo sa inyo mga sala sa presensya sang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ang indi magpuasa sa sina nga adlaw indi na ninyo pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Patyon sang Ginoo ang bisan sin-o nga mag-obra sa sina nga adlaw. ");
INSERT INTO hil_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","32","Gani magpahuway kamo kag magpuasa umpisa sa pagsalop sang adlaw sa ikasiyam nga adlaw sang sina nga bulan hasta sa masunod nga pagsalop sang adlaw. Ini nga pagsulundan dapat tumanon ninyo hasta sa palaabuton nga mga henerasyon, bisan diin kamo mag-estar. ");
INSERT INTO hil_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","34","Ginsugo sang Ginoo si Moises nga ihambal ini sa mga Israelinhon: Sa ika-15 nga adlaw sang ikapito nga bulan magaumpisa ang Piesta sang Pagpatindog sang mga Payag, kag saulugon ninyo ini sa sulod sang pito ka adlaw. ");
INSERT INTO hil_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Sa nahauna nga adlaw indi kamo mag-obra kundi magtipon kamo sa pagsimba sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Sa sulod sang pito ka adlaw maghalad kamo sa Ginoo sang mga halad nga paagi sa kalayo. Kag sa ikawalo nga adlaw indi naman kamo mag-obra kundi magtipon kamo liwat sa pagsimba sa Ginoo, kag maghalad kamo sa iya. Katapusan ini nga adlaw sang inyo nga pagtilipon. ");
INSERT INTO hil_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Amo ina ang natalana nga mga piesta nga magatilipon kamo sa pagsimba sa Ginoo kag sa paghalad sang mga halad nga paagi sa kalayo. Dapat magdala kamo sang mga halad nga ginasunog, halad nga regalo, halad nga para sa maayo nga relasyon, kag mga halad nga ilimnon, nga ginakinahanglan nga ihalad ninyo sa mga tion sang paghalad sini. ");
INSERT INTO hil_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Saulugon ninyo ina nga mga piesta dugang sa Adlaw nga Inugpahuway nga ginsugo sang Ginoo nga himuon ninyo kada semana. Kag ihalad ninyo ini nga mga halad dugang sa inyo mga regalo, sa inyo mga halad sa pagtuman sang mga panaad, kag sa inyo mga halad nga kinabubut-on nga inyo ginahalad sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Kon parte liwat sa Piesta sang Pagpatindog sang mga Payag, saulugon ninyo ini sa pagpadungog sa Ginoo umpisa sa ika-15 nga adlaw sang ikapito nga bulan, pagkatapos sang tig-alani. Saulugon ninyo ini sa sulod sang pito ka adlaw; indi kamo mag-obra sa nahauna nga adlaw kag sa ikawalo nga adlaw. ");
INSERT INTO hil_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Sa nahauna nga adlaw, magkuha kamo sang pinakamaayo nga mga bunga sang mga kahoy, mga paklang sang palma, mga sanga sang madabong nga mga kahoy, kag mga kahoy-kahoy sa ililigan sang tubig, kag magkinalipay kamo sa presensya sang Ginoo nga inyo Dios sa sulod sang pito ka adlaw. ");
INSERT INTO hil_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","43","Saulugon ninyo ini nga piesta sa ikapito nga bulan sang kada tuig sa pagpadungog sa Ginoo. Sa sulod sang pito ka adlaw, tanan kamo nga mga tumandok nga mga Israelinhon mag-estar sa mga payag para mahibaluan sang inyo mga kaliwat nga ginpaestar sang Ginoo nga inyo Dios ang inyo mga katigulangan sa mga payag sang ginpaguwa niya sila sa Egypt. Ini nga pagsulundan dapat tumanon ninyo hasta sa palaabuton nga mga henerasyon. ");
INSERT INTO hil_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Amo ato ang parte sa natalana nga mga piesta para sa Ginoo nga ginpahibalo ni Moises sa mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","4","Ginsugo sang Ginoo si Moises nga ipatuman niya ini sa mga Israelinhon: Dal-an ninyo sang puro nga lana sang ginbayo nga olibo ang mga suga sa guwa sang kuwarto nga ginabutangan sang Kahon sang Kasuguan didto sa Tolda nga Ginapakigkitaan, para wala sing untat ang pagsiga sini sa presensya sang Ginoo. Kada magsirom na, sindihan ini ni Aaron kag padayon nga pasigahon hasta mag-aga. Siguruhon gid niya nga nagasiga permi ang mga suga sa bulutangan sini nga puro bulawan. Ini nga pagsulundan dapat tumanon ninyo hasta sa palaabuton nga mga henerasyon. ");
INSERT INTO hil_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Maghimo kamo sang dose ka bilog nga tinapay, nga ang kada isa hinimo halin sa apat ka kilo nga harina nga maayo nga klase. ");
INSERT INTO hil_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ibutang ninyo ini sa lamisa nga puro bulawan nga didto sa presensya sang Ginoo. Sampawon ninyo ini sa duha ka sampaw nga ang kada isa may anom ka tinapay. ");
INSERT INTO hil_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Butangan ninyo dayon sang puro nga insenso sa tupad sang kada sinampaw. Ang insenso amo ang magaserbi nga halad sa pagdumdom sa Ginoo. Sunugon ini bilang halad nga paagi sa kalayo sa baylo sang mga tinapay. ");
INSERT INTO hil_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Dapat magbutang gid permi sang sini nga mga tinapay sa presensya sang Ginoo kada Adlaw nga Inugpahuway bilang kasugtanan nga tumanon sang mga Israelinhon hasta san-o. ");
INSERT INTO hil_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ini nga mga tinapay para kay Aaron kag sa iya mga kaliwat. Kaunon nila ini sa balaan nga lugar didto sa Tolda, tungod kay balaan gid ini nga parte sang mga halad nga paagi sa kalayo. Kag para gid ina sa ila hasta san-o. ");
INSERT INTO hil_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Karon, may isa ka tawo nga ang iya amay Egyptohanon kag ang iya iloy Israelinhon. (Ang ngalan sang iya iloy amo si Shelomit, nga anak ni Dibri nga halin sa tribo ni Dan.) Nagpakig-away ini nga tawo sa isa ka Israelinhon didto sa kampo, kag gin-insulto niya ang ngalan sang Ginoo. Gani gindala nila siya kay Moises, ");
INSERT INTO hil_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","kag ginpriso nila siya hasta nga mahibaluan nila kon ano ang kabubut-on sang Ginoo sa amo nga tawo. ");
INSERT INTO hil_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Karon, nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Dal-a sa guwa sang kampo ang ato nga tawo nga nag-insulto sa akon. Ang tanan nga nakabati sang iya pag-insulto magtungtong sang ila kamot sa iya ulo sa pagpamatuod nga may salabton siya, kag dayon batuhon siya sang bilog nga komunidad sang Israel. ");
INSERT INTO hil_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","16","Kag hambalan mo ang mga Israelinhon nga ang bisan sin-o sa ila kag sa mga pangayaw nga magyaguta sa akon ukon mag-insulto sa akon ngalan may salabton. Kinahanglan nga batuhon siya sang bilog nga komunidad hasta nga mapatay gid. ");
INSERT INTO hil_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Ang bisan sin-o nga makapatay sang tawo, kinahanglan nga patyon man. ");
INSERT INTO hil_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Kag ang tawo nga makapatay sang sapat sang iban kinahanglan nga ilisan niya ini sang buhi tungod kay buhi man ato nga sapat, kag dapat buhi man ang ibayad. ");
INSERT INTO hil_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","20","Kon ginhalitan sang isa ka tawo ang iya isigkatawo, kinahanglan nga halitan man siya suno man sa iya nga ginhimo: Kon ginbali niya ang tul-an sang iban balion man ang iya tul-an, kon ginlukat niya ang mata sang iban lukaton man ang iya mata, kag kon ginbingaw niya ang ngipon sang iban bingawon man ang iya ngipon. ");
INSERT INTO hil_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ang bisan sin-o nga makapatay sang sapat kinahanglan nga ilisan niya ini, pero ang makapatay sang tawo kinahanglan nga patyon man. ");
INSERT INTO hil_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ang ini nga kasuguan para sa inyo tanan, tumandok man kamo nga mga Israelinhon ukon mga pangayaw. Ako amo ang Ginoo nga inyo Dios.” ");
INSERT INTO hil_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Pagkatapos nga nahambal ini ni Moises sa mga Israelinhon, gindala nila ang tawo nga nag-insulto sa Dios sa guwa sang kampo kag ginbato, suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Sang didto si Moises sa Bukid sang Sinai, ginsugo siya sang Ginoo ");
INSERT INTO hil_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","nga ihambal ini sa mga Israelinhon: Kon mag-abot na kamo sa duta nga ihatag ko sa inyo, indi ninyo pagtamnan ang duta kada ikapito nga tuig para mapadunggan ninyo ako. ");
INSERT INTO hil_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","4","Sa sulod sang anom ka tuig makatanom kamo kag makaani, pero sa ikapito nga tuig kinahanglan nga papahuwayon ninyo ang duta. Indi ninyo pagtamnan ang inyo mga uma kag indi man ninyo pagtapsan sang mga sanga ang inyo tanom nga mga ubas. ");
INSERT INTO hil_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Kag indi man ninyo pag-anihon ang mga uhay ukon pagduguson ang mga bunga sang mga ubas nga nagatubo lang. ");
INSERT INTO hil_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Pero puwede kamo magpanguha sini para lang kaunon ninyo sang inyo mga suluguon, sang inyo mga trabahador, sang mga pangayaw nga nagaestar upod sa inyo, ");
INSERT INTO hil_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","sang inyo mga kasapatan, kag sang talunon nga mga sapat sa inyo duta. ");
INSERT INTO hil_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","9","Sa kada 49 ka tuig, sa ikanapulo nga adlaw sang ikapito nga bulan nga amo ang Adlaw sang Pagtubos, patunugon ninyo ang mga budyong sa bilog nga lugar. ");
INSERT INTO hil_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Kabigon ninyo ang ika-50 nga tuig nga pinasahi nga tuig, kay tion ini sang paghilway sa mga ulipon para makabalik na sila sa ila pamilya kag sa pag-uli sa tag-iya sang iya mga duta nga iya ginbaligya. ");
INSERT INTO hil_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","12","Sa sini nga Tuig sang Paghilway kag Pag-uli, indi kamo magtanom, kag indi man kamo mag-ani ukon magdugos sang mga bunga sang mga tanom nga nagatubo lang, pero puwede kamo makapanguha para lang kaunon. Balaan ini nga tuig para sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Sa sini nga tuig, ang tanan nga pagkabutang nga ginbaligya sa inyo ibalik ninyo sa tag-iya. ");
INSERT INTO hil_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Gani kon magbaligya kamo ukon magbakal sang duta sa inyo kasimanwa, indi kamo magdinayaay. ");
INSERT INTO hil_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Kinahanglan nga ang bili sang duta suno sa kadamuon sang mga tinuig nga makapatubas ini sa wala pa ang sunod nga Tuig sang Paghilway kag Pag-uli. ");
INSERT INTO hil_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Kon madamo pa ang mga tinuig antes mag-abot ang Tuig sang Paghilway kag Pag-uli, pataasan ninyo ang presyo sang duta, pero kon gamay na lang, panubuan ninyo. Kay ang matuod, ang ginabakal indi ang duta mismo kundi ang kadamuon sang mapatubas sang duta. ");
INSERT INTO hil_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Indi kamo magdinayaay kundi tahura ninyo ako, kay ako ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","19","Tumana gid ninyo ang akon mga pagsulundan kag mga sugo para magkabuhi kamo nga malinong sa duta nga inyo estaran kag indi kamo mawad-an sang pagkaon tungod sa bugana nga mga patubas sang duta. ");
INSERT INTO hil_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Indi kamo magkabalaka kon ano ang inyo kaunon sa ikapito nga tuig nga indi kamo makatanom ukon makaani. ");
INSERT INTO hil_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Kay bendisyunan ko ang inyo duta sa ikaanom nga tuig para magpatubas ini sang madamo nga kalan-on nga para sa tatlo ka tuig. ");
INSERT INTO hil_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Gani samtang nagatanom kamo sa ikawalo nga tuig, ang inyo kaunon amo pa ang inyo inani sang ikaanom nga tuig, kag madamo pa ang inyo kalan-on hasta sa tig-alani sa ikasiyam nga tuig. ");
INSERT INTO hil_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Indi dapat ibaligya ang duta nga indi na mabawi pa, kay ang ini nga duta akon; ginapaestaran kag ginapaagsahan ko lang ini sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Gani tugutan ninyo nga mabawi pa sang tag-iya ang iya duta sa inyo. Himuon ninyo ini sa tanan nga duta nga inyo ginbakal. ");
INSERT INTO hil_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Kon nag-imol ang kapareho ninyo nga Israelinhon, kag tungod sini ginbaligya niya ang iya duta, ang iya pinakamalapit nga paryente amo ang maggawad sang iya ginbaligya. ");
INSERT INTO hil_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Pero kon wala siya sing paryente nga maggawad sini para sa iya, puwede niya gihapon ini mabawi kon may ikasarang na siya sa paggawad sini. ");
INSERT INTO hil_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Kon matabo ini bayaran niya ang nagbakal sang iya duta sang kantidad nga suno sa mapatubas sang duta hasta sa pag-abot sang Tuig sang Paghilway kag Pag-uli, dayon puwede na niya mabawi ang iya duta. ");
INSERT INTO hil_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Pero kon kulang pa ang iya inuggawad, magapabilin ini sa nagbakal hasta sa pag-abot sang Tuig sang Paghilway kag Pag-uli. Sa sina nga tuig, mabawi na niya ang iya duta nga wala sing bayad. ");
INSERT INTO hil_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Kon ang isa ka tawo magbaligya sang iya balay nga ara sa banwa nga napalibutan sang pader, magawad pa niya ini sa sulod sang isa ka tuig halin sang tion sang iya pagbaligya. ");
INSERT INTO hil_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Pero kon indi niya ini magawad sa sulod sang isa ka tuig, ang amo nga balay mangin iya na sang nagbakal kag sang iya mga kaliwat hasta san-o. Indi na ini mabawi sang tag-iya sa Tuig sang Paghilway kag Pag-uli. ");
INSERT INTO hil_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Pero ang mga balay sa mga baryo nga wala sing pader pagakabigon nga pareho sang mga uma, nga puwede magawad kag mabawi sa Tuig sang Paghilway kag Pag-uli. ");
INSERT INTO hil_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Ang mga kaliwat ni Levi puwede nga makagawad bisan san-o sang ila mga balay nga ara sa mga banwa nga ginapanag-iyahan nila. ");
INSERT INTO hil_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Kon indi nila ini magawad, iuli ini sa ila sa Tuig sang Paghilway kag Pag-uli. Kay ang mga balay dira sa ila mga banwa ila ina nga parte halin sa ila kapareho nga mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ang mga palahalban nga ara dampi sa ila mga banwa kinahanglan nga indi pag-ibaligya, kay ila ina nga pagkabutang hasta san-o. ");
INSERT INTO hil_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Kon nag-imol ang kapareho ninyo nga Israelinhon kag indi na siya makasarang nga magsuporta sa iya kaugalingon, buligan ninyo siya pareho sang pagbulig ninyo sa mga pangayaw nga temporaryo ukon permanente nga nagaestar upod sa inyo, para makapadayon siya sa pag-estar upod sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","37","Pahulama ninyo siya sang kuwarta nga wala sing saka, kag baligyai ninyo siya sang pagkaon nga wala sing ganansya, para makapadayon siya sa pag-estar upod sa inyo. Himua ninyo ina sa pagpakita nga nagatahod kamo sa akon nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ako ang Ginoo nga inyo Dios nga nagpaguwa sa inyo sa Egypt para ihatag ko sa inyo ang duta sang Canaan kag para mangin Dios ninyo ako. ");
INSERT INTO hil_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Kon nag-imol ang kapareho ninyo nga Israelinhon, kag tungod sini ginbaligya niya ang iya kaugalingon sa inyo bilang ulipon, indi ninyo siya pagpaobrahon pareho sang isa ka ordinaryo lang nga ulipon. ");
INSERT INTO hil_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Kabigon ninyo siya nga isa ka sinuhulan nga trabahador ukon isa ka bisita nga nagaestar lang sa inyo. Magaobra siya sa inyo hasta sa Tuig sang Paghilway kag Pag-uli. ");
INSERT INTO hil_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Sa sina nga tuig, hilway na siya kag ang iya mga anak, kag makabalik na sila sa ila mga kaparyentihan kag mangin ila liwat ang mga pagkabutang sang ila mga katigulangan. ");
INSERT INTO hil_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Mga ulipon ko kamo, kamo nga mga Israelinhon nga ginpaguwa ko sa Egypt. Gani indi dapat nga ibaligya ninyo ang inyo kaugalingon nga ulipon hasta san-o. ");
INSERT INTO hil_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Indi ninyo pagpintasan ang kapareho ninyo nga Israelinhon nga ulipon ninyo. Himua ninyo ina sa pagpakita nga nagatahod kamo sa akon nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Kon gusto ninyo nga may mga ulipon kamo, magbakal kamo sa mga nasyon sa palibot ninyo. ");
INSERT INTO hil_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Puwede man ninyo baklon ang mga pangayaw nga nagaestar upod sa inyo ukon ang mga miyembro sang ila panimalay nga natawo sa inyo lugar. Ang mga ulipon nga nabakal ninyo sa ila mangin pagkabutang na ninyo, ");
INSERT INTO hil_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","kag puwede ninyo sila ipanubli sa inyo mga anak para magserbisyo sa ila samtang buhi sila. Pero indi gid ninyo pagpintasan ang kapareho ninyo nga Israelinhon nga ulipon ninyo. ");
INSERT INTO hil_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Kon ang isa ka imol nga Israelinhon nagbaligya sang iya kaugalingon bilang ulipon sa isa ka pangayaw nga manggaranon nga nagaestar upod sa inyo ukon sa iya sini paryente, ");
INSERT INTO hil_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ang ina nga Israelinhon puwede pa nga magawad. Puwede siya nga gawaron sang iya utod, ");
INSERT INTO hil_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","tiyo, pakaisa, ukon sang bisan sin-o sa malapit niya nga mga paryente. Puwede man nga siya mismo ang maggawad sang iya kaugalingon kon may ikasarang na siya. ");
INSERT INTO hil_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","52","Ang iya himuon sumahon niya kag sang nagbakal sa iya kon pila ka tuig ang iya pagserbisyo kag kon pila ang maiguan sini kon bayaran siya pareho sa ginahimo sa isa ka sinuhulan nga trabahador. Ang maiguan nga kantidad ibuhin niya sa kantidad nga ginbayad sa iya sadto anay sang pagbakal sa iya bilang isa ka ulipon. (Ang amo nga kantidad ginabasi sa kadamuon sang tinuig halin sa pagbakal sa iya hasta sa Tuig sang Paghilway kag Pag-uli.) Kag kon pila ang mabilin amo ina ang ibayad niya para magawad siya. ");
INSERT INTO hil_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Kinahanglan nga kabigon siya sang nagbakal sa iya nga daw isa ka sinuhulan nga trabahador kag indi niya siya pagpintasan. ");
INSERT INTO hil_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Kon indi siya magawad sa sini nga mga paagi, mahilway gihapon siya kag ang iya mga anak sa Tuig sang Paghilway kag Pag-uli. ");
INSERT INTO hil_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Gani indi kamo magpaulipon sa inyo isigkatawo hasta san-o, kay mga ulipon ko kamo, kamo nga ginpaguwa ko sa Egypt. Ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Indi kamo maghimo sang mga dios-dios pareho sang mga imahen, handumanan nga bato, ukon bato nga may larawan, para simbahon, kay ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Tumana ninyo ang akon mga ginapahimo sa inyo sa mga Adlaw nga Inugpahuway kag tahura ninyo ang lugar nga ginasimbahan ninyo sa akon. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Kon tumanon ninyo ang akon mga pagsulundan kag mga sugo, ");
INSERT INTO hil_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","padal-an ko kamo sang ulan sa husto nga panahon para ang duta makapatubas kag ang mga kahoy makapamunga. ");
INSERT INTO hil_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Mangin bugana gid kaayo ang inyo mga patubas nga bisan pa gani ang inyo paglinas sang mga uhay magapadayon hasta sa tighalarvest sang mga ubas, kag ang inyo pagpangharvest sang ubas magapadayon hasta sa inyo tigpalanggas. Gani makapagusto kamo sang inyo nga pagkaon kag magakabuhi pa kamo nga malinong sa inyo lugar. ");
INSERT INTO hil_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Paluntaron ko ang kalinong sa inyo lugar, gani makatulog kamo nga wala sing may ginakahadlukan. Pangtabugon ko ang mapintas nga mga sapat sa inyo lugar, kag wala sing mga kaaway nga makasalakay sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Kamo ang magasalakay sa inyo mga kaaway kag pamatyon ninyo sila. ");
INSERT INTO hil_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Ang 5 sa inyo makapierdi sang 100 kag ang 100 sa inyo makapierdi sang 10,000. ");
INSERT INTO hil_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ipakita ko ang akon kaayo sa inyo kag hatagan ko kamo sang madamo nga kaliwat para matuman ko ang akon kasugtanan sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Tungod nga mangin bugana gid ang inyo mga patubas, ang inyo pagakaunon amo pa ang nagligad ninyo nga mga patubas hasta nga maabtan pa ini kag mailisan sang bag-o naman nga patubas. ");
INSERT INTO hil_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Magapuyo ako upod sa inyo kag indi ko kamo pag-isikway. ");
INSERT INTO hil_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Magaupod ako sa inyo kag ako padayon nga mangin Dios ninyo kag kamo padayon nga mangin katawhan ko. ");
INSERT INTO hil_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ako ang Ginoo nga inyo Dios nga nagpaguwa sa inyo sa Egypt para indi na kamo mangin mga ulipon sang mga Egyptohanon. Ginhilway ko na kamo, gani wala na kamo sing dapat nga ikahuya. ");
INSERT INTO hil_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","15","Pero kon indi gani kamo magpamati sa akon kag indi magtuman sang tanan ko nga mga sugo, mga pagsulundan kag mga ginapatuman, kag tungod sini ginalapas ninyo ang kasugtanan ko sa inyo, ");
INSERT INTO hil_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","amo ini ang akon himuon sa inyo: Mataranta kamo sa kahadlok tungod kay padal-an ko kamo sang makamamatay nga mga balatian kag hilanat nga makaguba sang inyo mga mata kag mga lawas. Magatanom kamo, pero indi ninyo ini mapuslan kay salakayon kamo sang inyo mga kaaway kag kaunon nila ang inyo mga patubas. ");
INSERT INTO hil_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Kontrahon ko kamo para mapierdi kamo sang inyo mga kaaway kag dumalahan nila kamo. Tungod sa kakulba magapalalagyo kamo bisan wala sing may nagalagas sa inyo. ");
INSERT INTO hil_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Kag kon indi gihapon kamo magpamati sa akon, silutan ko kamo sing pito ka pilo. ");
INSERT INTO hil_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Dulaon ko ang ginapabugal ninyo nga gahom. Indi ko gid pagpaulanon, gani magatig-a gid ang inyo mga duta. ");
INSERT INTO hil_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Mangin wala gid sing pulos ang inyo pagpangabudlay, kay ang inyo mga duta indi magpatubas kag ang inyo mga kahoy indi magpamunga. ");
INSERT INTO hil_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Kon padayon pa gid kamo nga magsupak sa akon kag indi kamo magpamati sa akon, dugangan ko pa gid liwat sing pito ka pilo ang inyo silot. ");
INSERT INTO hil_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Padal-an ko kamo sang mapintas nga mga sapat kag pamatyon nila ang inyo mga bata kag mga kasapatan, kag tungod sini diutay na lang ang mabilin sa inyo sa bagay nga daw wala na sing may nagalakat sa inyo mga dalan. ");
INSERT INTO hil_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Kon indi gihapon kamo magpamati sa akon kundi padayon pa gid kamo nga magsupak sa akon, ");
INSERT INTO hil_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ako gid mismo ang magakontra sa inyo kag silutan ko kamo sing pito pa gid ka pilo. ");
INSERT INTO hil_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ipasalakay ko kamo sa inyo mga kaaway sa pagsilot sa inyo tungod sang inyo paglapas sa aton kasugtanan. Bisan magpanago pa kamo sa inyo mga banwa padal-an ko gihapon kamo sang mga kahalitan, kag tungod sini mapilitan kamo nga magsurender sa inyo kaaway. ");
INSERT INTO hil_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Kulangon ang inyo pagkaon, gani isa lang ka pugon ang gamiton sang napulo ka babayi sa pagluto sang tinapay, kag tunga-tungaon pa nila ini sa inyo. Makakaon kamo matuod pero indi kamo mabusog. ");
INSERT INTO hil_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Kon indi gihapon kamo magpamati sa akon kundi padayon pa gid kamo nga magsupak sa akon, ");
INSERT INTO hil_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","sa akon kaakig kontrahon ko kamo kag silutan sing pito pa gid ka pilo. ");
INSERT INTO hil_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Pagutuman ko kamo kag mapilitan kamo sa pagkaon sang inyo kaugalingon nga mga anak. ");
INSERT INTO hil_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Panggub-on ko ang inyo mga simbahan sa mataas nga mga lugar pati ang mga halaran sini nga sulunugan sang insenso. Kag ihaboy ko ang inyo mga bangkay sa ibabaw sang inyo patay nga mga dios-dios, kag isikway ko kamo. ");
INSERT INTO hil_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Gub-on ko ang inyo mga banwa kag mga simbahan, kag indi ako malipay sa kahamot sang inyo mga halad. ");
INSERT INTO hil_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Gub-on ko ang inyo lugar, kag ang inyo mga kaaway nga magasakop sini matingala gid sa pagkaguba sini. ");
INSERT INTO hil_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Padal-an ko kamo sang gira nga magaguba sang inyo mga banwa. Laptahon ko kamo sa iban nga mga nasyon, kag mangin mamingaw ang inyo duta. ");
INSERT INTO hil_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Samtang ginabihag kamo sa lugar sang inyo mga kaaway kag wala na sing may nagaestar sa inyo duta, makapahuway na ini. Kay sang nagaestar pa kamo sa inyo duta wala gid ninyo ini pagpahuwayi bisan tuig sang inugpahuway sang duta. Pero subong makapahuway na gid ini samtang wala na sing may nagaestar. ");
INSERT INTO hil_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","37","Kamo nga mga nagkalabilin nga buhi sa inaway, nga gindala sang inyo mga kaaway sa ila nga lugar, pahadlukon ko gid. Sa bagay nga bisan sa kalas lang sang dahon nga ginahuyop sang hangin magapalagyo kamo nga daw sa ginalagas kamo nga patyon bisan wala sing may nagalagas sa inyo. Kag samtang nagapalagyo kamo magakalabungguanay kamo kag magakalatumba. Gani indi gid kamo makabato sa inyo mga kaaway. ");
INSERT INTO hil_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Magakalamatay kamo sa lugar sang inyo mga kaaway. ");
INSERT INTO hil_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Kag ang mabilin sa inyo amat-amat nga mapatay tungod sang inyo mga sala kag sang mga sala sang inyo mga katigulangan. ");
INSERT INTO hil_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","Tungod sang inyo pagluib kag pagsupak sa akon ginkontra ko kamo kag ginpabihag sa lugar sang inyo mga kaaway. Pero kon ituad ninyo ining sala ninyo kag sang inyo mga katigulangan kag untatan na ninyo ang pagpakatig-a, kag batunon ninyo ang silot tungod sang inyo mga sala, ");
INSERT INTO hil_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","tumanon ko ang akon kasugtanan sa inyo mga katigulangan nga si Abraham, Isaac, kag Jacob kag ibalik ko kamo sa inyo duta. ");
INSERT INTO hil_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Pero kinahanglan nga pahalinon ko anay kamo sa inyo duta bilang bayad ninyo sa inyo mga sala, tungod sang inyo pagsikway sang akon mga sugo kag mga pagsulundan. Kag makapahuway ang duta samtang wala kamo. ");
INSERT INTO hil_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Pero bisan ginasilutan ko kamo, indi ko kamo pag-isikway sa lugar sang inyo mga kaaway; indi ko kamo paglaglagon nga wala na sing may mabilin sa inyo. Kay indi mahimo nga dulaon ko ang akon kasugtanan sa inyo, tungod kay ako amo ang Ginoo nga inyo Dios. ");
INSERT INTO hil_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Tumanon ko sa inyo ang akon kasugtanan sa inyo mga katigulangan nga ginpaguwa ko sa Egypt sa pagpakita sang akon gahom sa mga nasyon. Ginhimo ko ini sa inyo mga katigulangan para mangin Dios nila ako. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Amo ato ang nagkalain-lain nga sugo kag pagsulundan nga ginhatag sang Ginoo sa mga Israelinhon didto sa Bukid sang Sinai paagi kay Moises. ");
INSERT INTO hil_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Ginsugo sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","nga ihambal ini sa mga Israelinhon: Kon ang isa ka tawo ginhalad sa Ginoo bilang pagtuman sa isa ka panaad, ina nga tawo puwede pa mahilway sa sina nga panaad ");
INSERT INTO hil_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","7","kon bayaran ang iya bili sang pilak nga suno sa kabug-aton sini sa kilohan sang mga pari: sa nagaedad 1 ka bulan hasta 4 ka tuig lalaki: 5 ka bilog nga pilak babayi: 3 ka bilog nga pilak sa nagaedad 5 ka tuig hasta 19 lalaki: 20 ka bilog nga pilak babayi: 10 ka bilog nga pilak sa nagaedad 20 ka tuig hasta 59 lalaki: 50 ka bilog nga pilak babayi: 30 ka bilog nga pilak sa nagaedad 60 ka tuig paibabaw lalaki: 15 ka bilog nga pilak babayi: 10 ka bilog nga pilak. ");
INSERT INTO hil_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Kon imol ang nakapanaad kag indi siya makasarang magbayad sang amo nga kantidad, dal-on niya sa pari ang tawo nga ginpanaad niya nga ihalad sa Ginoo, kag ang pari amo ang maghatag sang bili suno sa masarangan nga ibayad sang tawo. ");
INSERT INTO hil_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Kon ang iya ginpanaad sapat nga puwede ihalad sa Ginoo, ina nga sapat mangin iya na sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Kinahanglan nga indi na niya ini pagbayluhan sang isa pa ka sapat, bisan pa nga mas maayo ang iya ibaylo. Kon himuon niya ini, ang sapat nga iya ginpanaad kag ang sapat nga iya ginbaylo pareho nga mangin iya na sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Kon ang iya ginpanaad mahigko nga sapat, nga indi puwede ihalad sa Ginoo, dal-on niya ang sapat sa pari. ");
INSERT INTO hil_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Tan-awon ini sang pari kon maayo ukon indi, kag dayon hatagan niya ini sang bili nga indi na puwede ilisan. ");
INSERT INTO hil_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Kon bawion sang tag-iya ang sapat, kinahanglan nga bayaran niya ang bili sang sapat kag dugangan pa gid niya sing 20 porsiyento sang bili sini. ");
INSERT INTO hil_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Kon ginhalad sang tawo ang iya balay sa Ginoo, tan-awon sang pari ang amo nga balay kon bala maayo pa ini ukon indi, kag dayon hatagan niya ini sang bili nga indi na puwede ilisan. ");
INSERT INTO hil_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Kon bawion sang tag-iya ang iya balay, kinahanglan nga bayaran niya ang bili sang balay kag dugangan pa gid niya sing 20 porsiyento sang bili sini. Kag ang balay ibalik sa iya. ");
INSERT INTO hil_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Kon ginhalad sang tawo sa Ginoo ang parte sang iya duta nga ginpanubli niya sa iya katigulangan, hatagan ini sang pari sang bili nga suno sa kadamuon sang binhi nga sarang mapanggas sa sini nga duta: sa kada sako nga binhi sang barley, ang bili sang duta 20 ka bilog nga pilak. ");
INSERT INTO hil_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Kon ihalad niya ang iya uma pagkatapos lang gid sang Tuig sang Paghilway kag Pag-uli, ang bili sini amo lang gihapon. ");
INSERT INTO hil_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Pero kon sa ulihi pa niya ini ihalad, hatagan ini sang pari sang bili nga mas manubo, suno sa kadamuon sang tinuig nga nabilin hasta sa sunod naman nga Tuig sang Paghilway kag Pag-uli. ");
INSERT INTO hil_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Kon bawion sang tag-iya ang iya uma, kinahanglan nga bayaran niya ang bili sang uma kag dugangan pa gid niya sang 20 porsiyento sang bili sini. Kag ibalik sa iya ang iya uma. ");
INSERT INTO hil_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Pero kon ginbaligya niya ang uma nga wala pa niya magawad, indi na gid niya ini mabawi pa. ");
INSERT INTO hil_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Kag sa pag-abot sang Tuig sang Paghilway kag Pag-uli, iya na ini sang Ginoo kag indi na gid ini mabawi; mangin pagkabutang na ini sang mga pari. ");
INSERT INTO hil_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Kon ginhalad sang tawo ang uma nga iya ginbakal, ");
INSERT INTO hil_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","hatagan ini sang pari sang bili nga suno sa kadamuon sang mga tinuig nga nabilin hasta sa Tuig sang Paghilway kag Pag-uli. Kinahanglan nga gawaron ini dayon sang tawo. Ang iya ibayad sa paggawad iya na sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Sa Tuig sang Paghilway kag Pag-uli ang amo nga uma iuli sa tag-iya nga nagbaligya sini. ");
INSERT INTO hil_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Ang tanan nga bili sang sining mga ginhalad sa Ginoo kinahanglan nga suno sa kabug-aton sang pilak sa kilohan sang mga pari. ");
INSERT INTO hil_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Ang kamagulangan nga sapat iya na sang Ginoo, gani indi na kinahanglan nga ihalad ini sa iya. ");
INSERT INTO hil_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kon ini nga sapat mahigko, puwede ini gawaron sang tag-iya. Bayaran niya ang bili sang sapat kag dugangan pa gid niya sang 20 porsiyento sang bili sini. Pero kon indi niya paggawaron, ibaligya ini sang mga pari suno sa bili sini. ");
INSERT INTO hil_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Wala sing bisan ano nga butang nga ginhalad sing bug-os sa Ginoo nga puwede ibaligya ukon gawaron, bisan tawo man ini ukon sapat ukon duta nga ginpanubli. Iya na gid ini sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ang tawo nga ginhalad sing bug-os sa Ginoo indi puwede nga gawaron. Kinahanglan nga patyon gid siya. ");
INSERT INTO hil_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Ang ikanapulo nga parte sang tanan nga patubas iya na sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Kon gawaron sang tawo ang ikanapulo sang iya patubas, kinahanglan nga bayaran niya ang bili sini kag dugangan pa gid niya sing 20 porsiyento sang bili sini. ");
INSERT INTO hil_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Kon mag-isip kamo sang inyo mga baka, karnero, ukon kanding, ang isa sa pulo sini ihatag ninyo sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Kag kinahanglan nga indi ninyo ini pagpilion ukon pagbayluhan. Kon bayluhan ninyo ini, ang ini nga sapat kag ang sapat nga ginbaylo pareho nga mangin iya na sang Ginoo kag indi na puwede gawaron. ");
INSERT INTO hil_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Amo ato ang mga sugo nga ginhatag sang Ginoo kay Moises didto sa Bukid sang Sinai para sa mga Israelinhon.");
INSERT INTO hil_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Sang nahauna nga adlaw, sang ikaduha nga bulan, sang ikaduha nga tuig halin sang pagguwa sang mga Israelinhon sa Egypt, nagpakig-estorya ang Ginoo kay Moises sa Tolda nga Ginapakigkitaan didto sa kamingawan sang Sinai. Siling niya: ");
INSERT INTO hil_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","I-census ninyo ang bilog nga komunidad sang Israel suno sa ila mga pamilya. Ilista ninyo ang mga ngalan sang tanan nga lalaki ");
INSERT INTO hil_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","nga nagaedad sing 20 ka tuig paibabaw nga puwede magsoldado. Kamo ni Aaron ang magdumala sa pag-census. ");
INSERT INTO hil_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Magabulig sa inyo ang pangulo sang kada tribo. ");
INSERT INTO hil_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","15","Amo ini sila ang magabulig sa inyo: Tribo Pangulo Reuben Elizur nga anak ni Shedeur Simeon Shelumiel nga anak ni Zurishadai Juda Nashon nga anak ni Aminadab Isacar Netanel nga anak ni Zuar Zebulun Eliab nga anak ni Helon Efraim nga anak ni Jose Elishama nga anak ni Amihud Manase nga anak ni Jose Gamaliel nga anak ni Pedazur Benjamin Abidan nga anak ni Gideoni Dan Ahiezer nga anak ni Amishadai Asher Pagiel nga anak ni Ocran Gad Eliasaf nga anak ni Deuel Naftali Ahira nga anak ni Enan ");
INSERT INTO hil_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Amo ato sila ang mga pangulo sang mga tribo nga ginpili halin sa komunidad sang Israel. ");
INSERT INTO hil_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","18","Ginpatipon ni Moises kag ni Aaron kaupod sang sini nga mga pangulo ang bilog nga komunidad sadto mismo nga adlaw. Ginlista nila ang tanan nga lalaki nga nagaedad sing 20 ka tuig paibabaw, suno sa ila mga pamilya. ");
INSERT INTO hil_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Ginlista sila ni Moises didto sa kamingawan sang Sinai, suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","43","Amo ini ang kadamuon sang mga lalaki nga nagaedad 20 ka tuig paibabaw nga puwede magsoldado, nga nalista suno sa ila tribo kag pamilya: Tribo Kadamuon Reuben (ang kamagulangan ni Jacob) 46,500 Simeon 59,300 Gad 45,650 Juda 74,600 Isacar 54,400 Zebulun 57,400 Efraim nga anak ni Jose 40,500 Manase nga anak ni Jose 32,200 Benjamin 35,400 Dan 62,700 Asher 41,500 Naftali 53,400 ");
INSERT INTO hil_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","45","Amo ato ang mga lalaki nga gin-isip ni Moises kag ni Aaron kag sang dose ka pangulo sang Israel. Ang kada isa sa ila nagarepresentar sang iya pamilya, kag nagaedad sila sing 20 ka tuig paibabaw kag puwede magsoldado. ");
INSERT INTO hil_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Ang kabug-usan nga kadamuon nila, 603,550 tanan. ");
INSERT INTO hil_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Pero wala malakip diri ang mga kaliwat ni Levi. ");
INSERT INTO hil_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Kay nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Indi pag-ilakip ang tribo ni Levi sa pag-census upod sa iban nga mga Israelinhon nga magaserbisyo sa tion sang inaway. ");
INSERT INTO hil_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Sa baylo, ihatag sa ila ang responsibilidad sa pagdumala sang Tolda nga Simbahan nga sa diin nabutang ang Kasuguan, kag sang tanan nga kagamitan sini. Sila ang magdala sang Tolda kag sang tanan nga kagamitan sini, kag kinahanglan nga atipanon nila ini kag magkampo sila sa palibot sini. ");
INSERT INTO hil_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kon sayluhon na gani ang Tolda, sila ang maghimos sini, kag kon patindugon naman ini, sila man gihapon ang magpatindog sini. Ang bisan sin-o nga maghimo sang sini nga mga buluhaton sa Tolda, nga indi kaliwat ni Levi, pagapatyon. ");
INSERT INTO hil_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Magakampo ang mga Israelinhon suno sa ila tribo, kag ang kada tribo may bandera. ");
INSERT INTO hil_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Pero ang mga kaliwat ni Levi magakampo sa palibot sang Tolda nga sa diin nabutang ang Kasuguan, para indi ako mangakig sa komunidad sang Israel. Ang mga kaliwat ni Levi amo ang responsable sa pag-atipan sa Tolda.” ");
INSERT INTO hil_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ginhimo ini tanan sang mga Israelinhon suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Nagsiling ang Ginoo kay Moises kag kay Aaron, ");
INSERT INTO hil_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Magkampo ang kada tribo sang Israel sa idalom sang bandera sang ila tagsa ka tribo. Ang Tolda nga Ginapakigkitaan iplastar sa tunga sang kampo. ");
INSERT INTO hil_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","8","Ang mga tribo ni Juda, Isacar, kag Zebulun magkampo sa east, sa idalom sang bandera sang ila tagsa ka tribo. Amo ini ang mga ngalan sang ila mga pangulo kag ang kadamuon sang ila mga tinawo: Tribo Pangulo Kadamuon Juda Nashon nga anak ni Aminadab 74,600 Isacar Netanel nga anak ni Zuar 54,400 Zebulun Eliab nga anak ni Helon 57,400 ");
INSERT INTO hil_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","186,400 tanan ang kadamuon sang sini nga grupo nga ginapangunahan sang tribo ni Juda. Ini sila amo ang sa unahan kon maglakat ang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","15","“Ang mga tribo ni Reuben, Simeon, kag Gad magkampo sa south, sa idalom sang bandera sang ila tagsa ka tribo. Amo ini ang mga ngalan sang ila mga pangulo kag ang kadamuon sang ila mga tinawo: Tribo Pangulo Kadamuon Reuben Elizur nga anak ni Shedeur 46,500 Simeon Shelumiel nga anak ni Zurishadai 59,300 Gad Eliasaf nga anak ni Deuel 45,650 ");
INSERT INTO hil_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","151,450 tanan ang kadamuon sang sini nga grupo nga ginapangunahan sang tribo ni Reuben. Ini sila amo ang ikaduha nga grupo kon maglakat ang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Sunod sa ila amo ang tribo ni Levi nga nagadala sang Tolda nga Ginapakigkitaan. Ang tanan nga tribo magalakat sang pasunod pareho sang ila posisyon kon magkampo sila, nga ara sa idalom sang ila tagsa ka bandera. ");
INSERT INTO hil_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","23","“Ang mga tribo ni Efraim, Manase, kag Benjamin magkampo sa west, sa idalom sang bandera sang ila tagsa ka tribo. Amo ini ang mga ngalan sang ila mga pangulo kag ang kadamuon sang ila mga tinawo: Tribo Pangulo Kadamuon Efraim Elishama nga anak ni Amihud 40,500 Manase Gamaliel nga anak ni Pedazur 32,200 Benjamin Abidan nga anak ni Gideoni 35,400 ");
INSERT INTO hil_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","108,100 tanan ang kadamuon sang sini nga grupo nga ginapangunahan sang tribo ni Efraim. Ini sila nagasunod sa tribo ni Levi kon maglakat ang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","30","“Ang mga tribo ni Dan, Asher, kag Naftali magkampo sa north, sa idalom sang bandera sang ila tagsa ka tribo. Amo ini ang mga ngalan sang ila mga pangulo kag ang kadamuon sang ila mga tinawo: Tribo Pangulo Kadamuon Dan Ahiezer nga anak ni Amishadai 62,700 Asher Pagiel nga anak ni Ocran 41,500 Naftali Ahira nga anak ni Enan 53,400 ");
INSERT INTO hil_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","157,600 tanan ang kadamuon sang sini nga grupo nga ginapangunahan sang tribo ni Dan. Ini sila ang katapusan nga grupo kon maglakat ang mga Israelinhon. Magalakat sila tanan sa idalom sang ila bandera.” ");
INSERT INTO hil_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ang kabug-usan nga kadamuon sang mga Israelinhon nga nalista suno sa ila tribo, 603,550 tanan. ");
INSERT INTO hil_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Pero wala malakip diri ang mga kaliwat ni Levi, suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Gani ginhimo sang mga Israelinhon ang tanan nga ginsugo sang Ginoo kay Moises: ang tagsa ka tribo nagkampo kag nagpanglakaton sa idalom sang ila tagsa ka bandera suno sa ila tribo kag pamilya. ");
INSERT INTO hil_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Amo ini ang estorya parte sa mga kaliwat ni Aaron kag ni Moises sang tion nga nagpakighambal ang Ginoo kay Moises didto sa Bukid sang Sinai. ");
INSERT INTO hil_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ang mga anak ni Aaron amo sila ni Nadab, Abihu, Eleazar, kag Itamar. Si Nadab ang kamagulangan. ");
INSERT INTO hil_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ginpili sila kag gin-ordinahan sa pag-alagad bilang mga pari. ");
INSERT INTO hil_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Pero si Nadab kag si Abihu napatay sa presensya sang Ginoo sang naggamit sila sang kalayo nga indi amo ang dapat nila gamiton sa ila paghalad sa Ginoo didto sa kamingawan sang Sinai. Napatay sila nga wala sing mga anak, gani si Eleazar kag si Itamar lang ang nag-alagad bilang mga pari sang buhi pa si Aaron. ");
INSERT INTO hil_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Ipatawag ang tribo ni Levi kag dal-a sila kay Aaron nga pari sa pagbulig sa iya. ");
INSERT INTO hil_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Mag-alagad sila kay Aaron kag sa bilog nga komunidad paagi sa pag-asikaso sang mga buluhaton sa Tolda nga Simbahan, nga ginatawag man nga Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Sila man ang mag-atipan sa tanan nga kagamitan sa Tolda, kag mag-alagad sa Tolda para sa mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Itugyan ang mga kaliwat ni Levi kay Aaron kag sa iya mga anak nga lalaki para magbulig sa ila. ");
INSERT INTO hil_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Si Aaron kag ang iya mga anak amo ang pilion mo nga mag-alagad bilang mga pari. Ang bisan sin-o nga maghimo sang buluhaton sang pari sa Tolda nga Simbahan nga indi kaliwat ni Levi dapat patyon.” ");
INSERT INTO hil_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Nagsiling pa gid ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ginpili ko ang mga kaliwat ni Levi bilang bulos sa mga kamagulangan nga lalaki sang Israel. Ang tagsa ka kaliwat ni Levi akon, ");
INSERT INTO hil_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","kay ang tagsa ka kamagulangan nga lalaki akon. Sang ginpamatay ko ang tanan nga kamagulangan nga lalaki sang mga Egyptohanon, ginseparar ko para sa akon ang tanan nga kamagulangan nga lalaki sang Israel, tawo man ukon sapat. Gani akon sila. Ako amo ang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Nagsiling ang Ginoo kay Moises didto sa kamingawan sang Sinai, ");
INSERT INTO hil_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Isipa ang mga kaliwat nga lalaki ni Levi halin sa isa ka bulan paibabaw, suno sa ila pamilya.” ");
INSERT INTO hil_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Gani gin-isip sila ni Moises, suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Amo ini ang mga anak ni Levi: si Gershon, si Kohat, kag si Merari. ");
INSERT INTO hil_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ang mga anak ni Gershon amo si Libni kag si Shimei. ");
INSERT INTO hil_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ang mga anak ni Kohat amo sila ni Amram, Izhar, Hebron, kag Uziel. ");
INSERT INTO hil_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ang mga anak ni Merari amo si Mali kag si Mushi. Sila ang mga kaliwat ni Levi, suno sa ila mga pamilya. ");
INSERT INTO hil_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ang mga kaliwat ni Gershon amo ang mga pamilya nila ni Libni kag Shimei. ");
INSERT INTO hil_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ang kadamuon sang tanan nila nga lalaki nga nagaedad halin sa isa ka bulan paibabaw 7,500. ");
INSERT INTO hil_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Ang lugar nga ila ginakampuhan ara sa likod sang Tolda nga Simbahan sa west. ");
INSERT INTO hil_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Ang ila pangulo amo si Eliasaf nga anak ni Lael. ");
INSERT INTO hil_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Sila ang gintugyanan sa pag-atipan sang sini nga mga kagamitan sang Tolda nga Ginapakigkitaan: ang mga tabon, ang kurtina sang puwertahan sang Tolda, ");
INSERT INTO hil_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ang mga kurtina sang ugsaran nga nagapalibot sa Tolda kag sa halaran, pati ang kurtina sang puwertahan sang ugsaran, kag ang mga higot. Sila ang responsable sa tanan nga buluhaton nga may kaangtanan sa sini nga mga kagamitan. ");
INSERT INTO hil_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ang mga kaliwat ni Kohat amo ang mga pamilya nila ni Amram, Izhar, Hebron, kag Uziel. ");
INSERT INTO hil_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ang kadamuon sang tanan nila nga lalaki nga nagaedad halin sa isa ka bulan paibabaw 8,600. Gintugyanan man sila sa pag-atipan sang balaan nga Tolda. ");
INSERT INTO hil_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ang lugar nga ila ginakampuhan ara sa south sang Tolda. ");
INSERT INTO hil_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Kag ang ila pangulo amo si Elizafan nga anak ni Uziel. ");
INSERT INTO hil_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Sila ang responsable sa pag-atipan sang Kahon sang Kasugtanan, sang lamisa, sang bulutangan sang suga, sang mga halaran, sang mga kagamitan nga ginagamit sang mga pari sa ila pag-alagad, kag sang kurtina sa sulod sang Tolda. Sila ang responsable sa tanan nga buluhaton nga may kaangtanan sa sini nga mga kagamitan. ");
INSERT INTO hil_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Ang pangulo sang mga kaliwat ni Levi amo si Eleazar nga anak ni Aaron nga pari. Siya ang ginpili nga magdumala sa mga gintugyanan sa pag-atipan sang balaan nga Tolda. ");
INSERT INTO hil_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ang mga kaliwat ni Merari amo ang mga pamilya nila ni Mali kag kay Mushi. ");
INSERT INTO hil_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ang kadamuon sang tanan nila nga lalaki nga nagaedad halin sa isa ka bulan paibabaw 6,200. ");
INSERT INTO hil_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Ang ila pangulo amo si Zuriel nga anak ni Abihail. Ang lugar nga ila ginakampuhan ara sa north sang Tolda nga Simbahan. ");
INSERT INTO hil_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Sila ang gintugyanan sa pag-atipan sang mga tapi nga dingding sang Tolda, sang mga pangbalabag sini, sang mga haligi, kag sang mga pundasyon. Sila ang responsable sa tanan nga buluhaton nga may kaangtanan sa sini nga mga kagamitan. ");
INSERT INTO hil_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Sila man ang gintugyanan sa pag-atipan sang mga haligi sa palibot sang ugsaran kag sang mga pundasyon sini, sang mga palpal kag mga higot. ");
INSERT INTO hil_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ang lugar nga ginakampuhan ni Moises kag ni Aaron kag sang iya mga anak ara sa atubangan sang Tolda nga Ginapakigkitaan, sa east. Sila ang gintugyanan sa pagdumala sang mga buluhaton sa balaan nga Tolda para sa mga Israelinhon. Ang bisan sin-o nga maghimo sang buluhaton sang pari sa Tolda nga indi kaliwat ni Levi dapat patyon. ");
INSERT INTO hil_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ang kabug-usan nga kadamuon sang mga lalaki nga mga kaliwat ni Levi nga nagaedad halin sa isa ka bulan paibabaw 22,000 tanan. Si Moises kag si Aaron ang nag-isip sa ila, suno sa ginsugo sang Ginoo sa ila. ");
INSERT INTO hil_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Nagsiling ang Ginoo kay Moises, “Isipa kag listaha ang mga ngalan sang tanan nga kamagulangan nga lalaki sang mga Israelinhon nga nagaedad halin sa isa ka bulan paibabaw. ");
INSERT INTO hil_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Idedikar ang mga kaliwat ni Levi sa akon sa baylo sang tanan nga kamagulangan nga lalaki sang mga Israelinhon. Idedikar man sa akon ang mga kasapatan sang mga kaliwat ni Levi sa baylo sang tanan nga kamagulangan nga kasapatan sang mga Israelinhon. Ako amo ang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","43","Gani gin-isip ni Moises ang tanan nga kamagulangan nga lalaki sang mga Israelinhon nga nagaedad halin sa isa ka bulan paibabaw, suno sa ginsugo sang Ginoo sa iya. Ang ila kadamuon 22,273. ");
INSERT INTO hil_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Idedikar ang mga kaliwat ni Levi sa akon sa baylo sang tanan nga kamagulangan nga lalaki sang mga Israelinhon. Idedikar man sa akon ang mga kasapatan sang mga kaliwat ni Levi sa baylo sang kamagulangan nga mga kasapatan sang mga Israelinhon. Akon ang mga kaliwat ni Levi. Ako amo ang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Tungod kay sobra sing 273 ang kamagulangan nga lalaki sang mga Israelinhon sa mga kaliwat ni Levi, kinahanglan nga tubuson sila. ");
INSERT INTO hil_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Ang ibayad sa pagtubos sa kada isa sa ila lima ka bilog nga pilak suno sa kabug-aton sang pilak sa kilohan sang mga pari. ");
INSERT INTO hil_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ihatag mo kay Aaron kag sa iya mga anak nga lalaki ang kuwarta nga inugtubos sa sobra nga mga kamagulangan.” ");
INSERT INTO hil_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Gani ginkolekta ni Moises ang kuwarta nga inugtubos sa kamagulangan nga mga anak sang mga Israelinhon nga sobra sa kadamuon sang mga kaliwat ni Levi. ");
INSERT INTO hil_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Ang iya nakolekta 1,365 ka bilog nga pilak, suno sa kabug-aton sang pilak sa kilohan sang mga pari. ");
INSERT INTO hil_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Kag ginhatag niya ini kay Aaron kag sa iya mga anak suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Nagsiling ang Ginoo kay Moises kag kay Aaron, ");
INSERT INTO hil_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“I-census ninyo ang mga kaliwat ni Kohat nga sakop sang tribo ni Levi, suno sa ila mga pamilya. ");
INSERT INTO hil_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Isipa ang tanan nga lalaki nga nagaedad halin sa 30 hasta sa 50 ka tuig nga sarang makaalagad sa Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Ang buluhaton sang mga kaliwat ni Kohat sa Tolda nga Ginapakigkitaan amo ang pag-atipan sang labing balaan nga mga butang. ");
INSERT INTO hil_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Kon maghalin kamo sa inyo ginakampuhan, si Aaron kag ang iya mga anak nga lalaki magsulod sa Tolda kag kuhaon nila ang kurtina sa sulod kag itabon sa Kahon sang Kasuguan. ");
INSERT INTO hil_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Dayon tabunan pa gid nila ini sang maayo nga klase sang panit kag pagkatapos sang tela nga asol, kag dayon igulo nila ang mga tukon nga pangtuwang sini. ");
INSERT INTO hil_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Hapinan nila sang tela nga asol ang lamisa nga ginabutangan sang tinapay nga ginahalad sa presensya sang Dios; kag ibutang dayon nila sa lamisa ang mga pinggan, mga tasa, mga yahong, mga tibod nga ginasudlan sang mga halad nga ilimnon, kag ang mga tinapay nga ara permi sa lamisa. ");
INSERT INTO hil_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Pagkatapos tabunan nila ini sang tela nga pula, kag tabunan pa gid dayon sang maayo nga klase sang panit, kag igulo dayon ang mga tukon nga pangtuwang sini. ");
INSERT INTO hil_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Ang bulutangan sang suga putson nila sang tela nga asol, pati ang mga suga sini, ang mga kimpit, ang mga inugsalod sa mga upos nga pabilo sang suga, kag mga tibod nga suludlan sang lana sang suga. ");
INSERT INTO hil_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Putson pa gid nila ini tanan sang maayo nga klase sang panit kag ihigot sa tukon nga pangtuwang. ");
INSERT INTO hil_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Tabunan man nila sang tela nga asol ang bulawan nga halaran kag tabunan pa gid sang maayo nga klase sang panit, kag igulo dayon nila ang mga tukon nga pangtuwang sini. ");
INSERT INTO hil_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Kag ang iban pa nga mga kagamitan nga ginagamit sa pag-alagad sa balaan nga Tolda putson man sang tela nga asol kag sang maayo nga klase sang panit kag ihigot sa tukon nga pangtuwang. ");
INSERT INTO hil_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Kinahanglan kuhaon ang abo sa halaran, kag ang halaran tabunan sang tela nga granate. ");
INSERT INTO hil_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Kag ibutang nila sa halaran ang tanan nga kagamitan sini: ang mga bulutangan sang baga, ang mga dako nga tinidor para sa karne, ang mga pala, kag ang mga yahong. Tabunan nila ini sang maayo nga klase sang panit kag igulo dayon nila ang mga tukon nga pangtuwang sini. ");
INSERT INTO hil_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Pagkatapos tabon ni Aaron kag sang iya mga anak sang Tolda nga Ginapakigkitaan kag ang tanan nga kagamitan sini, tuwangan ini sang mga kaliwat ni Kohat kon maghalin na kamo sa inyo ginakampuhan. Pero indi gid nila pagtandugon ining balaan nga mga butang para indi sila mapatay. “Amo ato ang mga kagamitan sang Tolda nga Ginapakigkitaan nga dal-on sang mga kaliwat ni Kohat. ");
INSERT INTO hil_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Si Eleazar nga anak ni Aaron nga pari amo ang responsable sa lana para sa suga, sa insenso, sa adlaw-adlaw nga halad nga regalo, kag sa lana nga inughaplas. Siya ang magdumala sa bilog nga Tolda kag sa tanan nga kagamitan sini.” ");
INSERT INTO hil_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Nagsiling ang Ginoo kay Moises kag kay Aaron, ");
INSERT INTO hil_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Indi ninyo pagpabay-i nga madula ang mga kaliwat ni Kohat sa lahi ni Levi. ");
INSERT INTO hil_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Amo ini ang inyo himuon para indi sila mapatay kon magpalapit sila sa labing balaan nga mga butang: Updan sila ni Aaron kag sang iya mga anak kon magsulod sila sa Tolda kag hambalan nila sila kon ano ang ila dapat himuon kag kon ano ang ila dal-on. ");
INSERT INTO hil_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Kay kon indi sila pag-updan, indi gid sila magsulod sa pagtan-aw sang balaan nga mga butang bisan dali lang, para indi sila mapatay.” ");
INSERT INTO hil_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“I-census man ang mga kaliwat ni Gershon suno sa ila pamilya. ");
INSERT INTO hil_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Isipa ang tanan nga lalaki nga nagaedad halin sa 30 hasta sa 50 ka tuig nga sarang makaalagad sa Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Ang buluhaton sang mga kaliwat ni Gershon amo ang pagdala sang mga masunod: ");
INSERT INTO hil_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ang mga kurtina sang Tolda nga Simbahan (nga ginatawag man nga Tolda nga Ginapakigkitaan), ang tanan nga tabon sini kag mga kurtina sa puwertahan, ");
INSERT INTO hil_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ang mga kurtina sa ugsaran nga nagapalibot sa Tolda kag halaran, ang kurtina sa puwertahan sang ugsaran, ang mga higot, kag ang tanan nga kagamitan nga ginagamit sa pag-alagad sa Tolda. Sila ang maghimo sang tanan nga buluhaton nga may kaangtanan sa sini nga mga kagamitan. ");
INSERT INTO hil_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Si Aaron kag ang iya mga anak amo ang magadumala sa mga kaliwat ni Gershon parte sa ila mga buluhaton, magdala man sang mga kagamitan ukon maghimo sang iban nga mga buluhaton. Kamo ni Aaron ang magsiling kon ano ang ila dal-on. ");
INSERT INTO hil_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Amo ini ang buluhaton sang mga kaliwat ni Gershon sa Tolda nga Ginapakigkitaan. Panguluhan sila ni Itamar nga anak ni Aaron nga pari. ");
INSERT INTO hil_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“I-census mo man ang mga kaliwat ni Merari suno sa ila mga pamilya. ");
INSERT INTO hil_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Isipa ang tanan nga lalaki nga nagaedad halin sa 30 hasta sa 50 ka tuig nga sarang makaalagad sa Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Amo ini ang ila buluhaton sa Tolda nga Ginapakigkitaan: sila ang magdala sang mga tapi nga dingding sang Tolda, sang mga pangbalabag sini, sang mga haligi, kag sang mga pundasyon. ");
INSERT INTO hil_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Sila man ang magdala sang mga haligi nga ginatakdan sang mga kurtina sang ugsaran nga nagapalibot sa Tolda. Kag sila man ang magdala sang mga pundasyon sini, sang mga palpal, kag sang mga higot. Sila ang maghimo sang tanan nga buluhaton nga may kaangtanan sa sini nga mga kagamitan. Kamo ni Aaron ang magsiling sa kada isa sa ila kon ano ang ila dal-on. ");
INSERT INTO hil_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Amo ini ang buluhaton sang mga kaliwat ni Merari sa Tolda nga Ginapakigkitaan. Panguluhan sila ni Itamar nga anak ni Aaron nga pari.” ");
INSERT INTO hil_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Bilang pagtuman sa sugo sang Ginoo, gin-census nila ni Moises, Aaron kag sang mga pangulo sang komunidad sang Israel ang mga kaliwat ni Kohat, Gershon, kag Merari suno sa ila mga pamilya. Ginlista nila ang tanan nga lalaki nga nagaedad halin sa 30 hasta sa 50 ka tuig nga sarang makaalagad sa Tolda nga Ginapakigkitaan, kag amo ini ang ila kadamuon: Pamilya Kadamuon Kohat 2,750 Gershon 2,630 Merari 3,200 Ang kabug-usan nga kadamuon nila, 8,580 tanan. ");
INSERT INTO hil_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Gani suno sa ginsugo sang Ginoo kay Moises, gin-isip ang kada isa sa ila kag ginhatagan sang iya buluhaton kag ginhambalan kon ano ang iya dal-on. ");
INSERT INTO hil_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Sugua ang mga Israelinhon nga paguwaon nila sa kampo ang bisan sin-o nga may delikado nga balatian sa panit, ukon may nagaguwa sa iya kinatawo tungod sa balatian, ukon nangin mahigko siya tungod nakatandog siya sang patay. ");
INSERT INTO hil_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Huo, paguwaa ninyo sila, lalaki man ukon babayi para indi nila mahigkuan ang ila kampo, nga sa diin nagapuyo ako upod sa inyo.” ");
INSERT INTO hil_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Gani ginpaguwa sang mga Israelinhon ato nga mga tawo sa kampo suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Dayon nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Silinga ang mga Israelinhon nga kon ang isa ka lalaki ukon babayi naglapas sa luyag sang Ginoo paagi sa paghimo sang malain sa iya isigkatawo, ina nga tawo nakasala. ");
INSERT INTO hil_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Kinahanglan nga ituad niya ang iya sala nga nahimo, kag bayaran niya sing bug-os ang pagkabutang nga iya ginkuha ukon ginpierdi, kag dugangan pa niya sing 20 porsiyento sang bili sini. Ihatag niya ini tanan sa tawo nga nahimuan niya sang malain. ");
INSERT INTO hil_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Pero kon ang nahimuan sang malain patay na kag wala siya sing malapit nga paryente nga magbaton sini nga bayad, ang bayad iya na sang Ginoo kag kinahanglan nga ihatag ini sa pari, upod sang karnero nga ihalad sang pari sa pagtubos sang sala sang amo nga tawo. ");
INSERT INTO hil_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Ang tanan nga balaan nga regalo nga ginadala sang mga Israelinhon sa mga pari mangin iya sang mga pari. ");
INSERT INTO hil_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Huo, mangin iya na sang mga pari ining balaan nga mga halad.” ");
INSERT INTO hil_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Nagsiling pa gid ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Ihambal ini sa mga Israelinhon: Halimbawa ang isa ka lalaki nagasuspetso nga ang iya asawa nagluib kag nangin indi matutom sa iya, ");
INSERT INTO hil_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","kay sa banta niya naghulid ini sa isa ka lalaki. Pero wala niya ini makita kag wala siya sang prueba. Kag wala sing may magtestigo kontra sa mahigko nga buhat sang iya asawa, kay wala sing may nakakita sa iya sa akto. ");
INSERT INTO hil_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","15","Kon magpangimon kag magsuspetso gani siya sa iya asawa, kinahanglan nga dal-on niya siya sa pari, bisan indi matuod nga naghimo siya sining mahigko nga buhat. Kag kinahanglan nga magdala ang bana sang halad para sa iya asawa nga duha ka kilo nga harina nga barley. Kinahanglan nga indi niya ini pagbutangan sang lana ukon insenso, kay halad ini nga bilang regalo nga ihalad niya tungod sang iya pagsuspetso sa iya asawa. Isa ini ka halad sa paghibalo kon bala nakasala ang iya asawa ukon wala. ");
INSERT INTO hil_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Dal-on sang pari ang babayi sa akon presensya, ");
INSERT INTO hil_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","kag dayon magbutang ang pari sang balaan nga tubig sa kolon, kag butangan niya ini nga tubig sang yab-ok nga halin sa salog sang Tolda nga Simbahan. ");
INSERT INTO hil_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Kon napatindog na sang pari ang babayi sa akon presensya, bunghayon sang pari ang buhok sang babayi kag ibutang sa iya kamot ang halad nga regalo para sa paghibalo kon bala nakasala siya ukon wala. Ginhalad ini sang iya bana tungod sang iya pagsuspetso sa iya. Pagkatapos uyatan sang pari ang kolon nga may mapait nga tubig nga nagadala sang mga pagpakamalaot, ");
INSERT INTO hil_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","kag dayon pasumpaon niya ang babayi kon nagpanginlalaki siya ukon wala, kag silingan, ‘Kon wala mo ginhigkuan ang imo kaugalingon paagi sa pagpakighilawas sa iban nga lalaki, indi ka mahalitan sang pagpakamalaot nga ginadala sang sining mapait nga tubig. ");
INSERT INTO hil_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Pero kon ginhigkuan mo ang imo kaugalingon paagi sa pagpakighilawas sa lalaki nga indi mo bana, ");
INSERT INTO hil_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","nagasumpa ako nga mangin halimbawa ikaw sa mga tawo sang pagpakamalaot sang Ginoo sa tion nga indi ka na makabata. ");
INSERT INTO hil_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Kabay pa nga ini nga tubig nga nagadala sang pagpakamalaot magsulod sa imo lawas para indi ka na makabata.’ Dayon masiling ang babayi, ‘Komporme ako.’ ");
INSERT INTO hil_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Dayon isulat sang pari ini nga mga sumpa sa linukot nga sululatan kag hugasan niya ini didto sa mapait nga tubig. ");
INSERT INTO hil_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","(Kon ipainom na sa babayi ang mapait nga tubig nga nagadala sang mga pagpakamalaot, mangin kabangdanan ini sang iya puwerte nga pag-antos kon may sala siya.) ");
INSERT INTO hil_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Kuhaon sang pari sa kamot sang babayi ang halad nga regalo nga ginhalad sang iya bana tungod sang iya pagsuspetso, kag bayawon ini sang pari sa akon presensya kag dal-on dayon sa halaran. ");
INSERT INTO hil_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Magkuha ang pari sang isa ka hakop sang sini nga halad nga para sa paghibalo kon bala nakasala ang babayi ukon wala, kag dayon sunugon ini sa halaran. Pagkatapos ipainom niya sa babayi ang tubig. ");
INSERT INTO hil_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kon matuod nga ginhigkuan niya ang iya kaugalingon paagi sa pagluib sa iya bana, ang tubig nga iya gin-inom nga nagadala sang mga pagpakamalaot magapaantos sa iya sing puwerte gid. Indi na siya makabata kag mangin halimbawa siya sa mga tawo sang pagpakamalaot sang Dios. ");
INSERT INTO hil_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Pero kon wala niya ginhigkuan ang iya kaugalingon, indi siya mahalitan, kag makabata siya. ");
INSERT INTO hil_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Amo ini ang kasuguan parte sa bana nga nagasuspetso sa iya asawa. Kon ginhigkuan sang asawa ang iya kaugalingon paagi sa pagluib sa iya bana, ");
INSERT INTO hil_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ukon nagsuspetso ang bana sa iya asawa nga nagapanginlalaki siya, kinahanglan patindugon sang pari ang amo nga asawa sa akon presensya kag ipatuman ini nga mga kasuguan sa iya. ");
INSERT INTO hil_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Ang bana wala sing salabton, pero ang asawa may salabton kon nakasala siya, kag magaantos siya sa iya sala.” ");
INSERT INTO hil_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Silinga ang mga Israelinhon nga kon ang isa ka lalaki ukon babayi maghimo sang isa ka espesyal nga panaad nga idedikar niya ang iya kaugalingon sa pag-alagad sa akon bilang Nazareo, ");
INSERT INTO hil_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","kinahanglan indi siya mag-inom sang bino nga halin sa ubas kag sang iban pa nga makahulubog nga mga ilimnon. Indi man siya mag-usar sang langgaw nga halin sa ubas kag sang langgaw nga halin sa iban pa nga makahulubog nga mga ilimnon. Indi man siya mag-inom sang duga sang ubas, ukon magkaon sang ubas ukon pasas. ");
INSERT INTO hil_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Samtang isa siya ka Nazareo, kinahanglan nga indi gid siya magkaon sang bisan ano nga naghalin sa ubas, bisan gani sang liso ukon panit sini. ");
INSERT INTO hil_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Indi man niya pagpaguntingan ang iya buhok samtang wala pa matapos ang iya panaad sa pag-alagad sa Ginoo. Kinahanglan nga iseparar siya para sa Ginoo hasta matapos ang tion sang iya panaad. Gani pabay-an lang niya nga maglaba ang iya buhok. ");
INSERT INTO hil_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Kag samtang wala pa matapos ang iya panaad sa pag-alagad sa Ginoo, kinahanglan nga indi siya magpalapit sa patay, ");
INSERT INTO hil_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","bisan iya pa ini nga amay, iloy, ukon utod. Indi gid niya paghigkuan ang iya kaugalingon tungod sa ila. Kay ang iya buhok simbolo sang pagdedikar niya sang iya kabuhi sa Dios. ");
INSERT INTO hil_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Gani sa bilog nga tiyempo sang iya pagdedikar sang iya kabuhi, ginseparar siya para sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Kon may napatay gulpi sa iya tupad, kag tungod sini nadagtaan ang iya buhok nga simbolo sang iya pagdedikar sa Ginoo, kinahanglan nga maghulat siya sang pito ka adlaw, kag dayon pakiskisan niya ang iya buhok. Ang ikapito nga adlaw amo ang adlaw sang iya pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Dayon sa ikawalo nga adlaw, kinahanglan nga magdala siya sang duha ka pating ukon duha ka tukmo sa pari didto dampi sa puwertahan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ang isa ihalad sang pari bilang halad sa pagpakatinlo kag ang isa bilang halad nga ginasunog. Sa sini nga paagi matubos ang tawo sa iya sala nga nakatandog siya sang patay. Sa sina mismo nga adlaw, idedikar niya liwat ang iya kaugalingonkag patubuon niya liwat ang iya buhok. ");
INSERT INTO hil_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ang nagligad nga mga inadlaw sang iya pag-alagad sa Ginoo indi pag-isipon nga parte sang iya pagtuman sang iya panaad, tungod kay nadagtaan siya paagi sa pagtandog sang patay. Kinahanglan nga idedikar niya liwat ang iya kaugalingon hasta matapos ang iya panaad, kag magdala siya sang lalaki nga karnero bilang halad nga bayad sa sala. ");
INSERT INTO hil_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Amo ini ang pagsulundan kon matapos na niya ang iya panaad bilang Nazareo: Kinahanglan nga magkadto siya sa puwertahan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Maghalad siya didto sa Ginoo sining masunod nga mga sapat nga wala sing deperensya: isa ka bataon nga karnero nga lalaki nga isa ka tuig bilang halad nga ginasunog, isa ka babayi nga karnero nga isa man ka tuig bilang halad sa pagpakatinlo, kag isa ka gulang nga karnero nga lalaki bilang halad nga para sa maayo nga relasyon. ");
INSERT INTO hil_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Luwas sini, maghalad man siya sang mga halad nga regalo, mga halad nga ilimnon, kag isa ka basket nga tinapay nga wala sing inugpahabok, nga hinimo halin sa maayo nga klase nga harina. Ang iban nga mga tinapay madamol nga ginmikslahan sang mantika, kag ang iban manipis nga ginlamhitan sang mantika. ");
INSERT INTO hil_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Ang pari amo ang magahalad sini sa Ginoo: Ihalad niya ang halad sa pagpakatinlo kag ang halad nga ginasunog; ");
INSERT INTO hil_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","dayon ihalad man niya ang lalaki nga karnero bilang halad nga para sa maayo nga relasyon kaupod ang isa ka basket nga tinapay nga wala sing inugpahabok. Kag ihalad man niya ang mga halad nga regalo kag ang mga halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Dayon, pakiskisan sang Nazareo ang iya buhok nga simbolo sang pagdedikar niya sang iya kabuhi sa Ginoo, didto sa puwertahan sang Tolda nga Ginapakigkitaan. Sunugon niya dayon ini sa kalayo nga ginasunugan sang halad nga para sa maayo nga relasyon. ");
INSERT INTO hil_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Pagkatapos sini, ibutang sang pari sa kamot sang Nazareo ang abaga sang karnero nga ginlaga kag ang manipis kag madamol nga mga tinapay nga wala sing inugpahabok nga halin sa basket. ");
INSERT INTO hil_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Dayon kuhaon ini sang pari kag bayawon sa presensya sang Ginoo bilang halad nga ginabayaw. Balaan ini nga parte sang halad, kag iya na ini sang pari, pati ang dughan kag paa sang karnero nga ginbayaw man sa Ginoo. Pagkatapos sini, puwede na makainom sang bino ang Nazareo. ");
INSERT INTO hil_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Amo ina ang pagsulundan para sa isa ka Nazareo. Pero kon magpromisa ang isa ka Nazareo nga maghalad siya sa Ginoo nga sobra sa ginapatuman sa iya panaad bilang isa ka Nazareo, dapat tumanon gid niya ini.” ");
INSERT INTO hil_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Silinga si Aaron kag ang iya mga anak nga lalaki nga amo ini ang ila isiling kon magbendisyon sila sa mga Israelinhon: ");
INSERT INTO hil_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘Kabay pa nga pakamaayuhon kamo sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Kabay pa nga ipakita sang Ginoo ang iya kaayo kag kaluoy sa inyo. ");
INSERT INTO hil_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Kag kabay pa nga magmaalwan ang Ginoo sa inyo kag hatagan niya kamo sang maayo nga kahimtangan.’ ");
INSERT INTO hil_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Sa sini nga paagi mapahayag nila sa mga Israelinhon kon sin-o ako, kag pakamaayuhon ko sila.” ");
INSERT INTO hil_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Pagkatapos nga naplastar ni Moises ang Tolda nga Simbahan, ginwisikan niya ini sang lana kag gindedikar pati ang tanan nga kagamitan sini. Amo man ang iya ginhimo sa halaran kag sa tanan nga kagamitan sini. ");
INSERT INTO hil_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Dayon nagdala sang mga halad sa Ginoo ang mga pangulo sang Israel, nga mga pangulo sang kada tribo. Sila ang gintugyanan sa pagpang-census. ");
INSERT INTO hil_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Nagdala sila sa presensya sang Ginoo sang anom ka karo kag dose ka baka—isa ka karo sa kada duha ka pangulo kag isa ka baka sa kada isa sa ila. Gindala nila ini sa atubangan sang Tolda nga Simbahan. ");
INSERT INTO hil_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Batuna ang ila halad agod gamiton para sa mga buluhaton sa Tolda nga Ginapakigkitaan. Ihatag ini sa mga kaliwat ni Levi suno sa ila tagsa ka buluhaton.” ");
INSERT INTO hil_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Gani ginbaton ni Moises ang mga karo kag ang mga baka kag ginhatag ini sa mga kaliwat ni Levi. ");
INSERT INTO hil_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ginhatag niya ang duha ka karo kag apat ka baka sa mga kaliwat ni Gershon para sa ila buluhaton. ");
INSERT INTO hil_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Kag ginhatag niya ang apat ka karo kag walo ka baka sa mga kaliwat ni Merari para man sa ila buluhaton. Sila tanan ginapanguluhan ni Itamar nga anak ni Aaron nga pari. ");
INSERT INTO hil_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Pero wala paghatagi ni Moises sang karo ukon baka ang mga kaliwat ni Kohat kay sila ang gintugyanan sa pagtuwang sang balaan nga mga butang sang Tolda. ");
INSERT INTO hil_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ang mga pangulo nagdala man sang ila mga halad para sa pagdedikar sang halaran sang tion nga gindedikar ini. ");
INSERT INTO hil_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Nagsiling ang Ginoo kay Moises, “Kinahanglan nga sa kada adlaw may isa ka pangulo nga magdala sang iya halad para sa pagdedikar sang halaran.” ");
INSERT INTO hil_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Amo ini sila ang nagdala sang ila mga halad: Sang nahauna nga adlaw, si Nashon nga anak ni Aminadab, nga pangulo sang tribo ni Juda. Sang ikaduha nga adlaw, si Netanel nga anak ni Zuar, nga pangulo sang tribo ni Isacar. Sang ikatatlo nga adlaw, si Eliab nga anak ni Helon, nga pangulo sang tribo ni Zebulun. Sang ikaapat nga adlaw, si Elizur nga anak ni Shedeur, nga pangulo sang tribo ni Reuben. Sang ikalima nga adlaw, si Shelumiel nga anak ni Zurishadai, nga pangulo sang tribo ni Simeon. Sang ikaanom nga adlaw, si Eliasaf nga anak ni Deuel, nga pangulo sang tribo ni Gad. Sang ikapito nga adlaw, si Elishama nga anak ni Amihud, nga pangulo sang tribo ni Efraim. Sang ikawalo nga adlaw, si Gamaliel nga anak ni Pedazur, nga pangulo sang tribo ni Manase. Sang ikasiyam nga adlaw, si Abidan nga anak ni Gideoni, nga pangulo sang tribo ni Benjamin. Sang ikanapulo nga adlaw, si Ahiezer nga anak ni Amishadai, nga pangulo sang tribo ni Dan. Sang ikaonse nga adlaw, si Pagiel nga anak ni Ocran, nga pangulo sang tribo ni Asher. Kag sang ikadose nga adlaw, si Ahira nga anak ni Enan, nga pangulo sang tribo ni Naftali. Ang kada isa sa ila nagdala sang sini nga mga halad: isa ka pilak nga bandehado nga may kabug-aton nga mga isa ka kilo kag tunga, kag isa ka pilak nga yahong nga may kabug-aton nga mga 800 ka gramo suno sa kilohan sang mga pari. Ang kada isa sini ginpuno nila sang maayo nga klase sang harina nga ginmikslahan sang mantika para sa halad nga regalo. Nagdala man ang kada isa sa ila sang isa ka bulawan nga tasa nga may kabug-aton nga mga 120 ka gramo nga puno sang insenso; isa ka bataon nga baka, isa ka gulang nga karnero nga lalaki, kag isa ka bataon nga karnero nga lalaki nga isa ka tuig bilang halad nga ginasunog; isa ka lalaki nga kanding bilang halad sa pagpakatinlo; kag duha ka turo nga baka, lima ka gulang nga karnero nga lalaki, lima ka kanding nga lalaki, kag lima ka bataon nga karnero nga lalaki nga isa ka tuig bilang halad nga para sa maayo nga relasyon. ");
INSERT INTO hil_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Amo ini tanan ang mga halad sang dose ka pangulo sang mga Israelinhon para sa pagdedikar sang halaran: dose ka pilak nga bandehado, dose ka pilak nga yahong, kag dose ka bulawan nga tasa. ");
INSERT INTO hil_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ang kada pilak nga bandehado may kabug-aton nga mga isa ka kilo kag tunga, kag ang kada pilak nga yahong may kabug-aton nga mga 800 ka gramo. Ang kabug-aton nila tanan mga 28 ka kilo suno sa kilohan sang mga pari. ");
INSERT INTO hil_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ang dose ka bulawan nga tasa nga puno sang insenso may kabug-aton nga mga 120 ka gramo kada isa suno sa kilohan sang mga pari. Ang kabug-aton nila tanan mga 1,440 ka gramo. ");
INSERT INTO hil_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ang mga sapat nga ginhatag para sa halad nga ginasunog: dose ka bataon nga baka, dose ka gulang nga karnero nga lalaki kag dose ka bataon nga karnero nga lalaki nga isa ka tuig ang edad, upod sa sini ang mga halad nga regalo. Ang halad sa pagpakatinlo: dose ka kanding nga lalaki. ");
INSERT INTO hil_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Ang mga sapat nga halad para sa maayo nga relasyon: 24 ka turo nga baka, 60 ka gulang nga karnero nga lalaki, 60 ka kanding nga lalaki, kag 60 ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Amo ini tanan ang mga halad sang pagdedikar sang halaran. ");
INSERT INTO hil_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Kon magsulod si Moises sa Tolda nga Ginapakigkitaan sa pagpakighambal sa Ginoo, mabatian niya ang tingog nga nagapakighambal sa iya halin sa tunga sang duha ka kerubin, sa ibabaw sang takop sang Kahon sang Kasuguan. Didto nagapakighambal ang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Silinga si Aaron nga kon ibutang na niya ang pito ka suga, kinahanglan nga iplastar niya ini nga ang sanag sini magabanaag sa atubangan sang bulutangan sini.” ");
INSERT INTO hil_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Gani ginhimo ini ni Aaron; ginplastar niya ang mga suga nga ang sanag sini nagabanaag sa atubangan, suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Bulawan ang bug-os nga bulutangan sang suga, halin sa idalom hasta sa ibabaw, suno sa desinyo nga ginpakita sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Paina ang mga kaliwat ni Levi sa iban nga mga Israelinhon, kag tinlui sila. ");
INSERT INTO hil_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Amo ini ang imo himuon sa pagtinlo sa ila: Wisikan mo sila sang tubig nga ginagamit sa pagpakatinlo, kag pakiskisi ang bilog nila nga lawas kag palabhi ang ila mga bayo. Dayon kabigon na sila nga matinlo. ");
INSERT INTO hil_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Pagkatapos pakuhaon mo sila sang bataon nga baka kag sang halad nga regalo. Ini nga halad dapat maayo nga klase sang harina nga ginmikslahan sang mantika. Pakuhaon mo man sila sang isa pa ka bataon nga baka bilang halad sa pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","“Dayon patipunon mo ang bilog nga komunidad sang Israel kag idedikar ang mga kaliwat ni Levi sa atubangan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Dal-on mo ang mga kaliwat ni Levi sa akon presensya kag itungtong sang mga Israelinhon ang ila mga kamot sa mga ulo sang mga kaliwat ni Levi. ");
INSERT INTO hil_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Si Aaron amo ang magdedikar sa ila sa akon presensya bilang espesyal nga halad halin sa mga Israelinhon, para makaalagad sila sa akon. ");
INSERT INTO hil_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Dayon itungtong sang mga kaliwat ni Levi ang ila mga kamot sa ulo sang duha ka bataon nga baka para sa akon. Ang isa halad sa pagpakatinlo, kag ang isa halad nga ginasunog, para matubos sila sa ila mga sala. ");
INSERT INTO hil_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Dayon patinduga sila sa atubangan ni Aaron kag sang iya mga anak nga lalaki kag idedikar sila bilang espesyal nga halad sa akon. ");
INSERT INTO hil_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Sa sini nga paagi painon mo ang mga kaliwat ni Levi sa iban nga mga Israelinhon, kag mangin akon sila. ");
INSERT INTO hil_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Pagkatapos nga matinluan mo na ang mga kaliwat ni Levi kag madedikar sila sa akon bilang espesyal nga halad, makaalagad na sila sa Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Sila ang mga Israelinhon nga ginseparar para lang gid sa akon sa baylo sang tanan nga kamagulangan nga lalaki sang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Kay ang tagsa ka kamagulangan sa Israel akon, tawo man ukon sapat. Sang ginpamatay ko ang tanan nga kamagulangan sang mga Egyptohanon, ginseparar ko para sa akon ang tanan nga kamagulangan nga lalaki sang Israel. ");
INSERT INTO hil_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Kag ginkuha ko ang mga kaliwat ni Levi sa baylo sang tanan nga kamagulangan nga lalaki sang Israel. ");
INSERT INTO hil_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Sa tanan nga Israelinhon, ang mga kaliwat ni Levi ang ginpili ko nga magbulig kay Aaron kag sa iya mga anak. Magaalagad sila sa Tolda nga Ginapakigkitaan para sa mga Israelinhon, kag magahimo sila sang mga seremonya para matubos ang mga Israelinhon sa ila mga sala, agod wala sing kahalitan nga mag-abot sa ila kon magpalapit sila sa Tolda nga Ginapakigkitaan.” ");
INSERT INTO hil_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Gani ginhimo nila ni Moises, ni Aaron kag sang bilog nga komunidad sang Israel ang ginsugo sang Ginoo kay Moises nga himuon para sa mga kaliwat ni Levi. ");
INSERT INTO hil_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Nagpakatinlo ang mga kaliwat ni Levi kag ginlabhan nila ang ila mga bayo. Dayon gindedikar sila ni Aaron sa presensya sang Ginoo bilang espesyal nga halad, kag naghimo si Aaron sang seremonya para matubos sila sa ila mga sala, kag para makabig sila nga matinlo. ");
INSERT INTO hil_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Pagkatapos sina, nag-alagad na ang mga kaliwat ni Levi sa Tolda nga Ginapakigkitaan sa idalom sang pagdumala ni Aaron kag sang iya mga anak. Gani ginhimo nila sa mga kaliwat ni Levi ang suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Ini nga mga pagsulundan para sa mga kaliwat ni Levi: Magsugod ang mga kaliwat ni Levi sa pag-alagad sa Tolda nga Ginapakigkitaan sa edad nga 25, ");
INSERT INTO hil_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","kag mag-untat sila sa pag-alagad sa edad nga 50. Kag kon magretiro na sila, ");
INSERT INTO hil_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","puwede sila makabulig-bulig sa ila kapareho nga mga Levita paagi sa pag-alagad bilang manugbantay sa Tolda, pero indi gid sila maghimo sang mga buluhaton sa Tolda. Amo ina ang mga katungdanan sang mga kaliwat ni Levi nga ipatuman mo sa ila.” ");
INSERT INTO hil_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Sang nahauna nga bulan sang ikaduha nga tuig halin sang pagguwa sang mga Israelinhon sa Egypt, nagsiling ang Ginoo kay Moises didto sa kamingawan sang Sinai, ");
INSERT INTO hil_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Ipasaulog sa mga Israelinhon ang Piesta sang Paglabay sang Anghel sa natalana nga tion, ");
INSERT INTO hil_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","umpisa sa pagsalop sang adlaw sa ika-14 nga adlaw sang sini nga bulan. Kinahanglan nga sundon gid ninyo ang tanan nga pagsulundan parte sa sini nga piesta.” ");
INSERT INTO hil_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Gani ginsilingan ni Moises ang mga Israelinhon sa pagsaulog sang Piesta sang Paglabay sang Anghel, ");
INSERT INTO hil_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","kag gintuman nila ini didto sa kamingawan sang Sinai sang pagsalop sang adlaw sa ika-14 nga adlaw sang nahauna nga bulan. Ginhimo ini sang tanan nga Israelinhon suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Pero may iban sa ila nga wala nakasaulog sang sini nga piesta, tungod kay sa sina nga adlaw ginkabig sila nga mahigko tungod nga nakatandog sila sang patay. Gani sadto mismo nga adlaw nagkadto sila kay Moises kag kay Aaron ");
INSERT INTO hil_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","kag nagsiling, “Nangin mahigko kami tungod nakatandog kami sang patay, pero ngaa bala nga indi kami pagtugutan sa pagselebrar sang sini nga piesta kag sa paghalad sang mga halad sa Ginoo upod sa iban nga mga Israelinhon sa natalana nga tion?” ");
INSERT INTO hil_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Nagsabat si Moises sa ila, “Maghulat lang anay kamo hasta mahibaluan ko kon ano ang isugo sang Ginoo sa akon parte sa inyo.” ");
INSERT INTO hil_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Silinga ang mga Israelinhon nga ang bisan sin-o sa ila ukon sa ila mga kaliwat nga nangin mahigko tungod sa pagtandog sang patay ukon tungod nagbiyahe siya sa malayo, makasaulog gihapon sang Piesta sang Paglabay sang Anghel. ");
INSERT INTO hil_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Saulugon nila ini pagkaligad sang isa ka bulan, umpisa sa pagsalop sang adlaw sa ika-14 nga adlaw sang ikaduha nga bulan. Magakaon sila sang karnero nga may upod nga tinapay nga wala sing inugpahabok kag sang mapait nga tanom. ");
INSERT INTO hil_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Kinahanglan nga wala gid sila sing may ibilin sini pagkaaga, kag indi man nila pagbalion ang mga tul-an sang karnero. Kon magsaulog sila sang Piesta sang Paglabay sang Anghel, kinahanglan nga sundon gid nila ang tanan nga pagsulundan parte sini. ");
INSERT INTO hil_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","“Pero ang tawo nga indi magsaulog sang Piesta sang Paglabay sang Anghel, bisan matinlo siya kag wala nagbiyahe sa malayo, ina nga tawo dapat indi na pagkabigon nga sakop ninyo, tungod kay wala siya naghalad sang halad para sa Ginoo sa natalana nga tion. Ina nga tawo magaantos sa iya nga sala. ");
INSERT INTO hil_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Kon ang pangayaw nga nagaestar upod sa inyo gusto magsaulog sang Piesta sang Paglabay sang Anghel, kinahanglan nga saulugon niya ini suno sa tanan nga pagsulundan parte sini. Pareho lang ang mga pagsulundan para sa mga tumandok nga mga Israelinhon kag sa mga pangayaw.” ");
INSERT INTO hil_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Sang adlaw nga ginpatindog ang Tolda nga Simbahan nga sa diin nabutang ang Kasuguan, ginlikupan ini sang panganod. Halin sa gab-i hasta sa aga nagasiga ang panganod nga daw sa kalayo. ");
INSERT INTO hil_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Amo ini ang nagakatabo permi—nagalikop ang panganod sa Tolda kon adlaw kag nagasiga ini nga daw sa kalayo kon gab-i. ");
INSERT INTO hil_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Kon mag-alsa na gani ang panganod sa ibabaw sang Tolda kag maghalin, nagahalin man ang mga Israelinhon, kag kon diin gani magpundo ang panganod didto man sila nagakampo. ");
INSERT INTO hil_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Gani nagalakat kag nagakampo ang mga Israelinhon suno sa mando sang Ginoo. Wala sila nagalakat kon nagalikop pa ang panganod sa Tolda. ");
INSERT INTO hil_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Bisan magdugay ang panganod sa ibabaw sang Tolda, nagahulat lang sila sa sugo sang Ginoo kag wala sila nagahalin. ");
INSERT INTO hil_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Kon kaisa mga pila lang ka adlaw ang panganod sa ibabaw sang Tolda, gani ang mga tawo nagapabilin man sing pila lang ka adlaw. Dayon suno sa mando sang Ginoo nagahalin sila. ");
INSERT INTO hil_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Kon kaisa man nagapabilin ini sa isa lang ka gab-i kag pagkaaga nagapaibabaw ini, kag nagalakat man dayon ang mga Israelinhon. Bisan gab-i ukon adlaw, basta magpaibabaw ang panganod nagalakat man ang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Kon magpabilin man ang panganod sa ibabaw sang Tolda sing duha ka adlaw ukon mga isa ka bulan ukon mga isa ka tuig, nagapabilin man ang mga Israelinhon sa ila kampo. Pero kon magpaibabaw na gani ang panganod, nagalakat man dayon sila. ");
INSERT INTO hil_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Gani nagakampo kag nagalakat ang mga Israelinhon suno sa mando sang Ginoo. Kag gintuman nila ang mga sugo sang Ginoo paagi kay Moises. ");
INSERT INTO hil_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Magpahimo ka sang duha ka trumpeta nga pilak kag gamiton mo ini sa pagtipon sa komunidad kag sa pagpreparar sa ila sa paglakat. ");
INSERT INTO hil_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Kon patunugon na gani sing dungan ining duha ka trumpeta, magtipon ang bilog nga komunidad sa puwertahan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Kon isa lang ang patunugon, ang mga pangulo lang sang kada tribo ang magtipon sa imo atubangan. ");
INSERT INTO hil_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Kon patunugon gani ang trumpeta sa pagpreparar sa mga tawo sa paglakat, ang mga tribo sa east sang Tolda amo ang una nga maglakat. ");
INSERT INTO hil_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Kon patunugon gani ang trumpeta sa ikaduha nga beses, ang tribo naman sa south sang Tolda ang maglakat. Ini nga pagpatunog amo ang tanda sang ila paglakat. ");
INSERT INTO hil_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Pero lain ang pagpatunog sang trumpeta kon magpatipon sa ila. ");
INSERT INTO hil_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Ang mga kaliwat lang ni Aaron nga mga pari ang magpatunog sang mga trumpeta. Ini nga pagsulundan dapat ninyo tumanon kag sang inyo mga kaliwat hasta san-o. ");
INSERT INTO hil_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Kon ara na kamo sa inyo duta, kag magpakig-away kamo kontra sa inyo mga kaaway nga nagadaogdaog sa inyo, patunuga ninyo ang mga trumpeta para ako, ang Ginoo nga inyo Dios, magadumdom sa inyo kag magaluwas sa inyo sa inyo mga kaaway. ");
INSERT INTO hil_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Kag sa tion sang inyo pagkinalipay—sa inyo pagsaulog sang natalana nga mga piesta pati na sang Piesta sang Pag-umpisa sang Bulan—patunugon man ninyo ang mga trumpeta kon maghalad kamo sang mga halad nga ginasunog kag halad nga para sa maayo nga relasyon. Ini nga mga trumpeta magapadumdom sa akon nga inyo Dios sang akon kasugtanan sa inyo. Ako amo ang Ginoo nga inyo Dios.” ");
INSERT INTO hil_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Sang ika-20 nga adlaw sang ikaduha nga bulan, sang ikaduha nga tuig halin sang pagguwa sang mga Israelinhon sa Egypt, nagpaibabaw ang panganod halin sa Tolda nga Simbahan nga sa diin nabutang ang Kasuguan. ");
INSERT INTO hil_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Dayon naghalin ang mga Israelinhon sa kamingawan sang Sinai kag nagpanglakaton sila nga nagabalhin-balhin sang lugar, hasta nga nagpundo ang panganod sa kamingawan sang Paran. ");
INSERT INTO hil_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Amo ini ang nahauna nga tion nga naglakat sila suno sa sugo sang Ginoo paagi kay Moises. ");
INSERT INTO hil_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ang nahauna nga grupo sang mga tribo nga naglakat dala ang ila bandera amo ang grupo nga ginapangunahan sang tribo ni Juda. Ang pangulo sang tribo ni Juda amo si Nashon nga anak ni Aminadab. ");
INSERT INTO hil_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Ang pangulo sang tribo ni Isacar amo si Netanel nga anak ni Zuar, ");
INSERT INTO hil_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","kag ang pangulo sang tribo ni Zebulun amo si Eliab nga anak ni Helon. ");
INSERT INTO hil_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Pagkatapos nga nabungkag ang Tolda nga Simbahan, gindala ini sang mga kaliwat ni Gershon kag sang mga kaliwat ni Merari, kag nagsunod sila sa paglakat. ");
INSERT INTO hil_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ang sunod nga grupo nga naglakat dala ang ila bandera amo ang grupo nga ginapangunahan sang tribo ni Reuben. Ang pangulo sang tribo ni Reuben amo si Elizur nga anak ni Shedeur. ");
INSERT INTO hil_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Ang pangulo sang tribo ni Simeon amo si Shelumiel nga anak ni Zurishadai, ");
INSERT INTO hil_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","kag ang pangulo sang tribo ni Gad amo si Eliasaf nga anak ni Deuel. ");
INSERT INTO hil_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Dayon ang sunod nga naglakat amo ang mga kaliwat ni Kohat nga nagadala sang balaan nga mga kagamitan sang Tolda nga Simbahan. Kinahanglan naplastar na ang Tolda antes sila mag-abot sa sunod nga lugar nga ila kampuhan. ");
INSERT INTO hil_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ang sunod nga grupo nga naglakat dala ang ila bandera amo ang grupo nga ginapangunahan sang tribo ni Efraim. Ang pangulo sang tribo ni Efraim amo si Elishama nga anak ni Amihud. ");
INSERT INTO hil_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Ang pangulo sang tribo ni Manase amo si Gamaliel nga anak ni Pedazur, ");
INSERT INTO hil_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","kag ang pangulo sang tribo ni Benjamin amo si Abidan nga anak ni Gideoni. ");
INSERT INTO hil_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ang katapusan nga grupo nga naglakat dala ang ila bandera amo ang grupo nga ginapangunahan sang tribo ni Dan. Sila ang mga guwardya sa likod sang tanan nga grupo. Ang pangulo sang tribo ni Dan amo si Ahiezer nga anak ni Amishadai. ");
INSERT INTO hil_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ang pangulo sang tribo ni Asher amo si Pagiel nga anak ni Ocran, ");
INSERT INTO hil_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","kag ang pangulo sang tribo ni Naftali amo si Ahira nga anak ni Enan. ");
INSERT INTO hil_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Amo ato ang pagpasunod sa mga tribo sang Israel nga naglakat sing grupo-grupo. ");
INSERT INTO hil_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Karon, nagsiling si Moises kay Hobab nga iya bayaw nga anak ni Reuel nga Midianhon, “Malakat na kami sa lugar nga ginsiling sang Ginoo nga ihatag niya sa amon. Gani upod ka sa amon kag indi ka namon pagpabay-an, kay nagpromisa ang Ginoo nga pakamaayuhon niya ang Israel.” ");
INSERT INTO hil_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Pero nagsabat si Hobab, “Indi ko. Mabalik ako sa akon lugar kag sa akon mga kasimanwa.” ");
INSERT INTO hil_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Nagsiling si Moises, “Kon mahimo indi kami pagbayai. Ikaw ang nakahibalo kon diin ang maayo nga lugar sa kamingawan nga amon kampuhan. Ikaw ang maggiya sa amon. ");
INSERT INTO hil_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kon maupod ka sa amon partihan ka namon sang tanan nga pagpakamaayo nga ihatag sang Ginoo sa amon.” ");
INSERT INTO hil_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Gani naghalin sila sa bukid sang Ginoo kag naglakat sing tatlo ka adlaw. Nagauna permi sa ila ang Kahon sang Kasugtanan sang Ginoo sa pagpangita sang lugar nga ila mapahuwayan. ");
INSERT INTO hil_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Sa adlaw, ang panganod sang Ginoo ara sa ila ibabaw kon maglakat sila. ");
INSERT INTO hil_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Kada tion nga dal-on na ang Kahon nagasiling si Moises, “Sige lakat na, Ginoo, laptaha ang imo mga kaaway. Kabay pa nga magpalalagyo sila.” ");
INSERT INTO hil_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Kag kon magpundo na gani ang Kahon, nagasiling si Moises, “Balik na diri, Ginoo, sa katawhan sang Israel nga madamo gid.” ");
INSERT INTO hil_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Nagreklamo ang mga Israelinhon tungod sa ila kabudlayan. Pagkabati sini sang Ginoo, nangakig siya kag nagpadala siya sang kalayo nga nagsunog sang border sang kampo. ");
INSERT INTO hil_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Tungod sini, nagpangayo sang bulig ang mga Israelinhon kay Moises, kag nagpangamuyo si Moises sa Ginoo. Kag napatay ang kalayo. ");
INSERT INTO hil_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Gani ang amo nga lugar gin-ngalanan nga Tabera, kay nagpadala ang Ginoo sang kalayo sa ila. ");
INSERT INTO hil_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Karon, ang grupo sang mga indi Israelinhon nga nag-upod sa mga Israelinhon nagapangita sang mga pagkaon nga gusto nila kaunon, gani pati ang mga Israelinhon nagreklamo nga nagasiling, “Kuntani makakaon kita sang karne. ");
INSERT INTO hil_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Sang didto kita sa Egypt, makakaon kita sang isda nga libre kag sang mga pipino, mga melon, mga sibuyas, kag mga ahos. ");
INSERT INTO hil_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Pero diri wala kita gana magkaon; puro lang manna ang aton ginakaon.” ");
INSERT INTO hil_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Inang manna daw sa mga liso nga magagmay kag maputi. ");
INSERT INTO hil_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Ginapamulot ini sang mga Israelinhon sa duta kada aga, kag ginagaling nila ukon ginabayo sa lusong. Pagkatapos ginaluto nila sa kolon kag ginahimo nga manipis nga tinapay. Ang sabor sini pareho sa tinapay nga ginluto sa mantika nga halin sa olibo. ");
INSERT INTO hil_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Nabatian ni Moises ang reklamo sang kada pamilya sa puwertahan sang ila mga tolda. Puwerte gid ang kaakig sang Ginoo sa ila, kag si Moises nalainan man sa ila ginhimo. ");
INSERT INTO hil_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Nagpamangkot siya sa Ginoo, “Ngaa bala nga ginhatagan mo ako nga imo alagad sang dako nga problema? Ano bala ang ginhimo ko nga wala ka malipay, nga ginhatag mo sa akon ang problema sang sini nga mga tawo? ");
INSERT INTO hil_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Mga anak ko bala sila? Amay bala nila ako? Ngaa ginahambalan mo ako nga atipanon ko sila pareho sa isa ka yaya nga nagakugos sang isa ka lapsag, kag dal-on sila sa duta nga ginpromisa mo sa ila mga katigulangan? ");
INSERT INTO hil_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Sa diin bala ako makuha sang karne para sa sini nga katawhan? Kay nagasagi sila reklamo sa akon nga hatagan ko sila sang karne nga ila makaon. ");
INSERT INTO hil_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Indi ko masarangan nga atipanon sila tanan kon ako lang. Tama ini kabudlay para sa akon. ");
INSERT INTO hil_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Kon amo man lang sini ang pagtratar mo sa akon, patya na lang ako subong. Kon nalipay ka sa akon, indi ako pagpabay-i nga mag-antos.” ");
INSERT INTO hil_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Gani nagsiling ang Ginoo kay Moises, “Patipuna ang 70 sa mga manugdumala sang Israel nga kilala mo gid nga mga pangulo sang katawhan, kag pakadtua sila sa Tolda nga Ginapakigkitaan kag patinduga sila didto upod sa imo. ");
INSERT INTO hil_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Manaog ako kag magapakighambal sa imo didto, kag ihatag ko ang iban mo nga awtoridad sa ila para makabulig sila sa imo sa pagdumala sa mga tawo, agod indi lang ikaw isa ang magpas-an sang sini nga mga responsibilidad. ");
INSERT INTO hil_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Dayon silinga ang mga tawo nga magpakatinlo sila, kay sa buwas may makaon sila nga karne. Isiling ini sa ila: ‘Nabatian ko ang inyo reklamo nga gusto ninyo magkaon sang karne. Kag nagasiling kamo nga mas maayo pa ang inyo kahimtangan sa Egypt. Gani sa buwas hatagan ko kamo sang karne para makakaon kamo. ");
INSERT INTO hil_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Indi lang isa ka adlaw, ukon duha, ukon lima, ukon napulo, ukon beinte ka adlaw ang inyo pagkaon sini, ");
INSERT INTO hil_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","kundi isa ka bulan, hasta nga masum-oran kamo kag indi na kamo magkaon sini. Kay ginsikway ninyo ako nga nagaupod sa inyo, kag nagreklamo kamo sa akon nga kuntani wala na lang kamo naghalin sa Egypt.’ ” ");
INSERT INTO hil_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Pero nagsiling si Moises, “600,000 tanan ang mga tawo nga kaupod ko, kag karon nagasiling ka nga hatagan mo sila sang karne nga ila kan-on sa sulod sang isa ka bulan? ");
INSERT INTO hil_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Bisan ihawon pa namon ang tanan nga karnero kag baka ukon dakpon ang tanan nga isda sa dagat indi ini makaigo sa ila.” ");
INSERT INTO hil_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Nagsiling ang Ginoo kay Moises, “May limitasyon bala ang akon gahom? Makita mo karon kon matabo ang ginsiling ko ukon indi.” ");
INSERT INTO hil_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Gani naglakat si Moises kag ginsilingan niya ang mga tawo sang ginsiling sang Ginoo. Gintipon niya ang 70 sa mga manugdumala kag ginpatindog sa palibot sang Tolda. ");
INSERT INTO hil_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Dayon nagpanaog ang Ginoo paagi sa panganod kag nagpakighambal kay Moises. Kag ginhatag sang Ginoo sa 70 ka manugdumala ang iban nga awtoridad ni Moises. Kag sang mabaton nila ini naghalambalanon sila, pero wala na ato matabo liwat. ");
INSERT INTO hil_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ang duha ka tawo nga si Eldad kag si Medad nga nalista upod sa 70 ka manugdumala wala nagkadto sa Tolda kundi nagpabilin sila sa kampo. Pero nabaton man nila ang awtoridad kag naghalambalanon man sila didto sa kampo. ");
INSERT INTO hil_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","May isa ka bataon nga lalaki nga nagdalagan pakadto kay Moises kag nagsugid nga nagahalambalanon si Eldad kag si Medad didto sa kampo. ");
INSERT INTO hil_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Si Josue nga anak ni Nun, nga nangin kabulig ni Moises halin sang bataon pa siya, nagsiling kay Moises, “Sir, pauntata sila.” ");
INSERT INTO hil_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Pero nagsabat si Moises, “Nabalaka ka bala kon mangin ano ang resulta sini sa akon pagkapangulo? Kon sa akon lang, gusto ko nga ang tanan nga katawhan sang Ginoo hatagan niya sang awtoridad para magahalambalanon sila pareho sang mga propeta.” ");
INSERT INTO hil_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Dayon nagbalik si Moises kag ang mga manugdumala sang Israel sa kampo. ");
INSERT INTO hil_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Karon, nagpadala ang Ginoo sang hangin nga nagdala sang mga pitaw halin sa dagat. Naglinupad-lupad sila sa palibot sang kampo, nga mga 3 feet ang ila antad sa duta kag pila ka kilometro ang ila kalaparon. ");
INSERT INTO hil_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Gani sa sinang bilog nga adlaw nagpangdakop ang mga tawo sang mga pitaw hasta sa bilog nga gab-i, kag pagkasunod pa gid nga adlaw. Wala sing may nakakuha sing manubo sa 30 ka sako, kag ginbulad nila ini sa palibot sang kampo. ");
INSERT INTO hil_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Pero samtang ginausang pa nila ang karne, kag wala pa nila matulon, nangakig gid ang Ginoo sa ila, kag ginpadal-an niya sila sang grabe nga kahalitan. ");
INSERT INTO hil_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Gani gintawag ang amo nga lugar nga Kibrot Hataava tungod kay didto ginlubong ang mga tawo nga dalok-dalok sa karne. ");
INSERT INTO hil_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Halin didto, naglakat ang mga Israelinhon sa Hazerot kag didto nagkampo. ");
INSERT INTO hil_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Karon, ginpakalain ni Miriam kag ni Aaron si Moises tungod kay nagpangasawa siya sang taga-Ethiopia. ");
INSERT INTO hil_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Nagsiling sila, “Paagi lang bala kay Moises nagapakighambal ang Ginoo? Nagapakighambal man siya paagi sa amon.” Pero nabatian ini sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Si Moises mapainubuson gid labaw sa tanan nga tawo sa kalibutan.) ");
INSERT INTO hil_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Gani naghambal gilayon ang Ginoo kay Moises, Aaron, kag Miriam, “Guwa kamo nga tatlo kag magkadto sa Tolda nga Ginapakigkitaan.” Gani nagguwa sila nga tatlo kag nagkadto sa Tolda. ");
INSERT INTO hil_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Dayon nagpanaog ang Ginoo paagi sa panganod nga daw haligi kag nagtindog sa puwertahan sang Tolda nga Ginapakigkitaan kag gintawag si Aaron kag si Miriam. Pagpalapit sang duha, ");
INSERT INTO hil_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","nagsiling ang Ginoo, “Pamati kamo! Kon may propeta ako nga ara sa inyo, nagapakighambal ako sa iya paagi sa palanan-awon kag damgo. ");
INSERT INTO hil_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Pero indi pareho sina kon magpakighambal ako sa akon alagad nga si Moises, nga masaligan nga pangulo sang akon katawhan. ");
INSERT INTO hil_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Kon magpakighambal ako sa iya, daw pareho lang nga nagaatubangay kami kay ang akon ginahambal sa iya maathag gid kaayo. Daw pareho lang nga makita niya ako. Gani ngaa wala gid kamo nahadlok maghambal sing malain kontra sa akon alagad nga si Moises?” ");
INSERT INTO hil_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Naakig gid ang Ginoo sa ila, kag naghalin siya. ");
INSERT INTO hil_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Sang naghalin na ang panganod sa ibabaw sang Tolda, gintubuan dayon si Miriam sang delikado nga balatian sa panit, kag nagputi gid ang iya panit. Pagkakita ni Aaron sa iya, ");
INSERT INTO hil_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","nagsiling si Aaron kay Moises, “Nagapangabay ako sa imo nga indi kami pagsiluti tungod sa binuang nga sala nga amon nahimo. ");
INSERT INTO hil_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Indi pag-itugot nga mangin pareho si Miriam sa isa ka bata nga natawo nga patay, nga ang katunga sang iya lawas naupod na.” ");
INSERT INTO hil_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Gani nagpakitluoy si Moises sa Ginoo, “O Dios ko, nagapangabay ako sa imo nga ayuhon mo si Miriam.” ");
INSERT INTO hil_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Nagsabat ang Ginoo kay Moises, “Indi bala nga kon duplaan siya sang iya amay sa guya bilang pagpakalain sa iya antuson niya ang kahuy-anan sa sulod sang pito ka adlaw? Gani paguwaa siya sa kampo sa sulod sang pito ka adlaw; pagkatapos sang pito ka adlaw, puwede na siya makabalik.” ");
INSERT INTO hil_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Gani ginpaguwa si Miriam sa kampo sa sulod sang pito ka adlaw. Ang mga tawo wala nagpadayon sa pagpanglakaton hasta nga nakabalik si Miriam sa kampo. ");
INSERT INTO hil_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Pagkatapos sadto, naghalin sila sa Hazerot kag nagkampo sa kamingawan sang Paran. ");
INSERT INTO hil_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Magpadala ka sang mga tawo sa pagpang-espiya sa Canaan—ang duta nga ihatag ko sa inyo nga mga Israelinhon. Ang mga tawo nga imo ipadala mga pangulo sang kada tribo sang Israel.” ");
INSERT INTO hil_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Gintuman ni Moises ang ginsugo sa iya sang Ginoo. Halin didto sa kamingawan sang Paran ginpadala niya sa Canaan ang mga pangulo sang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","15","Amo ini ang ila mga tribo kag ang ila mga ngalan: Tribo Pangulo Reuben Shamua nga anak ni Zacur Simeon Shafat nga anak ni Hori Juda Caleb nga anak ni Jefune Isacar Igal nga anak ni Jose Efraim Hoseas nga anak ni Nun Benjamin Palti nga anak ni Rafu Zebulun Gadiel nga anak ni Sodi Manase nga anak ni Jose Gadi nga anak ni Susi Dan Amiel nga anak ni Gemali Asher Shetur nga anak ni Micael Naftali Nabi nga anak ni Vofsi Gad Geuel nga anak ni Maki ");
INSERT INTO hil_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Sila ang mga tawo nga ginpadala ni Moises sa pagpang-espiya sa Canaan. (Gin-ilisan ni Moises ang ngalan ni Hoseas nga anak ni Nun nga Josue.) ");
INSERT INTO hil_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Antes sila ginpalakat ni Moises sa pagpang-espiya sa Canaan, nagsiling siya sa ila, “Maglakat kamo pa-north kag magkadto sa Negev, kag magderetso sa kabukiran. ");
INSERT INTO hil_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Tan-awa ninyo kon ano ang hitsura sang duta, kag kon bala ang mga tawo didto makusog ukon maluya, kag kon madamo sila ukon diutay lang. ");
INSERT INTO hil_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Tan-awa ninyo kon ano nga klase sang duta ang ila ginapuy-an, kon bala maayo ukon indi. Tan-awa ninyo ang ila mga banwa kon bala napalibutan sang pader ukon wala. ");
INSERT INTO hil_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Tan-awa man ninyo kon bala mapatubason ang duta ukon indi, kag kon may mga kahoy ukon wala. Kag tinguhai gid ninyo nga makadala sang mga prutas sa inyo pagbalik.” (Panahon gid sadto nga tigluluto sang ubas.) ");
INSERT INTO hil_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Gani naglakat sila kag gintan-aw nila ang duta halin sa kamingawan sang Zin hasta sa Rehob malapit sa Lebo Hamat. ");
INSERT INTO hil_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Nag-umpisa sila sa Negev hasta nga nakaabot sila sa Hebron, nga sa diin nagaestar sila ni Ahiman, Sheshai, kag Talmai, nga mga kaliwat ni Anak. (Ining Hebron gintukod pito ka tuig antes gintukod ang Zoan sa Egypt.) ");
INSERT INTO hil_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Pag-abot nila sa Eshcol nga ililigan sang tubig, nagtapas sila sang isa ka pungpong sang ubas. Ginbutang nila ini sa tukon kag gintuwangan sang duha ka tawo. Nagdala man sila sang mga prutas nga pomegranata kag higos. ");
INSERT INTO hil_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ato nga ililigan sang tubig gintawag nga Eshcol tungod sa pungpong sang ubas nga gintapas sang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Pagkatapos sang 40 ka adlaw nga pagpang-espiya sa duta, nagbalik sila ");
INSERT INTO hil_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","kay Moises, kay Aaron, kag sa bilog nga komunidad sang Israel sa Kadesh, didto sa kamingawan sang Paran. Ginsugid nila sa bilog nga komunidad ang ila nakita, kag ginpakita nila ang ila dala nga mga prutas. ");
INSERT INTO hil_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Nagsiling sila kay Moises, “Nagkadto kami sa lugar nga ginpakadtuan mo sa amon, kag maayo ini kag mapatubason nga duta. Ari pa gani ang mga prutas. ");
INSERT INTO hil_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Pero gamhanan ang mga tawo nga nagaestar didto, kag dalagko gid ang ila mga banwa kag napalibutan sang mga pader. Nakita pa gani namon didto ang mga kaliwat ni Anak. ");
INSERT INTO hil_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ang mga Amaleknon nagaestar sa Negev; ang mga Hithanon, mga Jebusnon, kag mga Amornon nagaestar sa mga kabukiran; kag ang mga Canaanhon nagaestar malapit sa dagat kag sa higad sang Suba sang Jordan.” ");
INSERT INTO hil_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ginpakalma ni Caleb ang mga tawo sa atubangan ni Moises, kag nagsiling siya, “Malakat kita subong dayon kag agawon ta ang duta, kay sigurado gid nga maagaw ta ini.” ");
INSERT INTO hil_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Pero nagsiling ang mga tawo nga nag-upod kay Caleb sa pagpang-espiya, “Indi ta masarangan ang pagsalakay sa ila, kay mas makusog sila sang sa aton.” ");
INSERT INTO hil_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Kag ginpalapnag nila sa mga Israelinhon ang indi maayo nga balita parte sa duta nga ila gintan-aw. Amo ini ang ila ginsiling, “Ang duta nga amon gintan-aw nagahalit sa iya mga pumuluyo, kag wala labot sina, ang mga tawo nga nakita namon didto puwerte kataas. ");
INSERT INTO hil_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","May nakita gani kami nga mga higante, nga mga kaliwat ni Anak. Daw mga tibakla lang ang amon panan-aw sa amon kaugalingon kon ikomparar sa ila, kag amo man sina ang ila panan-aw sa amon.” ");
INSERT INTO hil_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Sadto mismo nga gab-i naghinibi sing tudo ang bilog nga komunidad. ");
INSERT INTO hil_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Nagreklamo sila kay Moises kag kay Aaron. Siling nila, “Maayo pa nga nagkalamatay na lang kita sa Egypt ukon diri sa kamingawan. ");
INSERT INTO hil_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Ngaa bala nga dal-on pa kita sang Ginoo sa sina nga duta? Para lang bala magkalamatay kita sa inaway kag magkalabihag ang aton mga asawa kag mga kabataan? Maayo pa siguro mabalik na lang kita sa Egypt.” ");
INSERT INTO hil_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Kag naghambalanay sila sa isa kag isa, “Mapili kita sang pangulo kag magbalik sa Egypt!” ");
INSERT INTO hil_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Dayon nagluhod si Moises kag si Aaron sa atubangan sang bilog nga komunidad sang Israel nga nagtilipon didto. ");
INSERT INTO hil_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Gin-gisi ni Josue nga anak ni Nun kag ni Caleb nga anak ni Jefune ang ila mga bayo sa kasubo. Ini sila nga duha nag-upod sa pagpang-espiya sa duta. ");
INSERT INTO hil_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Nagsiling sila sa bilog nga komunidad, “Maayo gid katama ang duta nga amon ginkadtuan. ");
INSERT INTO hil_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kon nalipay ang Ginoo sa aton, tuytuyan niya kita pakadto sa sina nga duta—ang maayo kag mapatubason nga duta, kag ihatag niya ini sa aton. ");
INSERT INTO hil_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Indi lang kamo magrebelde sa Ginoo. Kag indi kamo magkahadlok sa mga tawo didto kay mapierdi gid naton sila. Wala sing may magbulig sa ila, pero ang Ginoo amo ang magabulig sa aton. Gani indi kamo magkahadlok sa ila.” ");
INSERT INTO hil_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Batuhon kuntani sila sang bilog nga komunidad, pero gulpi lang nga nagpakita sa ila ang gamhanan nga presensya sang Ginoo sa Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Nagsiling ang Ginoo kay Moises, “Hasta san-o pa bala ang pagsikway sining mga tawo sa akon? Hasta san-o pa bala sila nga indi magtuo sa akon sa pihak sang tanan nga milagro nga ginpanghimo ko sa ila? ");
INSERT INTO hil_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Padal-an ko ining mga Israelinhon sang kahalitan kag laglagon ko sila, pero ikaw ya himuon ko nga isa ka nasyon nga mas gamhanan kag mas mabakod sang sa ila.” ");
INSERT INTO hil_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Nagsiling si Moises sa Ginoo, “Ano na lang ang isiling sang mga Egyptohanon kon mabalitaan nila ini? Indi bala nga nahibaluan nila nga ginkuha mo ang mga Israelinhon sa ila paagi sa imo gahom? ");
INSERT INTO hil_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Kon laglagon mo ang imo katawhan, isugid ini sang mga Egyptohanon sa mga pumuluyo sang Canaan. Ini nga mga Canaanhon nakabati na nga ikaw, Ginoo, nagaupod sa mga Israelinhon kag nagpakita sa ila paagi sa panganod nga nagatuytoy sa ila. Ginapangunahan mo sila kon adlaw paagi sa panganod nga daw haligi, kag kon gab-i paagi sa kalayo nga daw haligi man. ");
INSERT INTO hil_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Karon, kon pamatyon mo ining katawhan sa isa lang ka tion, ang mga nasyon nga nakabati parte sa imo pagkabantog magasiling, ");
INSERT INTO hil_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Indi masarangan sang Ginoo nga dal-on ang mga Israelinhon sa duta nga iya ginpromisa sa ila, gani ginpamatay na lang niya sila sa kamingawan.’ ");
INSERT INTO hil_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Gani karon, O Ginoo, kabay pa nga ipakita mo ang imo gahom suno sa imo ginasiling nga ");
INSERT INTO hil_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","mahigugmaon ka kag indi dali mangakig, kag mapinatawaron sa mga sala kag paglapas sang tawo. Pero ginasilutan mo ang mga nakasala hasta sa ila ikatatlo kag ikaapat nga henerasyon. ");
INSERT INTO hil_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Suno sa imo dako nga gugma, patawara ang sala sang sini nga mga tawo, pareho sang pagpatawad mo sa ila halin sang pagguwa nila sa Egypt.” ");
INSERT INTO hil_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Nagsabat ang Ginoo, “Patawaron ko sila suno sa imo ginpangayo. ");
INSERT INTO hil_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Pero nagasumpa ako, ang buhi nga Ginoo, nga samtang napun-an ang bilog nga kalibutan sang akon gamhanan nga presensya, ");
INSERT INTO hil_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","wala sing bisan isa sa ila nga makasulod sa duta nga ginpromisa ko sa ila mga katigulangan. Kay bisan nakita nila ang akon gamhanan nga presensya kag ang mga milagro nga ginpanghimo ko sa Egypt kag sa kamingawan, permi gihapon nila ako ginatestingan kag wala sila nagatuman sa akon. Gani ang mga nagasikway sa akon indi gid makasulod sa sina nga duta. ");
INSERT INTO hil_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Pero si Caleb nga akon alagad pasudlon ko sa duta nga iya gintan-aw tungod kay lain ang iya batasan sang sa iban kag nagasunod siya sa akon sing tinagipusuon. Ang iya mga kaliwat magaestar man sa sina nga duta. ");
INSERT INTO hil_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Karon indi anay kamo magderetso tungod kay may mga Canaanhon kag mga Amaleknon nga nagaestar sa tunga sang mga bukid, kundi magbalik kamo buwas sa kamingawan, pakadto sa dalan nga padulong sa Mapula nga Dagat.” ");
INSERT INTO hil_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Nagsiling ang Ginoo kay Moises kag kay Aaron, ");
INSERT INTO hil_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Hasta san-o pa bala ang pagreklamo sining malain nga komunidad sa akon? Nabatian ko ang mga reklamo sining mga reklamador nga mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Gani ihambal ini sa ila: ‘Nagasumpa ako, ang buhi nga Ginoo, nga himuon ko sa inyo ang ginsiling ninyo. ");
INSERT INTO hil_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Magakalamatay kamo diri sa kamingawan. Tungod nga nagreklamo kamo sa akon, wala sing bisan isa sa inyo nga nagaedad sing 20 ka tuig paibabaw ");
INSERT INTO hil_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","nga makasulod sa duta nga akon ginsumpa nga ihatag kuntani sa inyo nga inyo estaran, luwas lang kay Caleb nga anak ni Jefune kag kay Josue nga anak ni Nun. ");
INSERT INTO hil_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Kon parte sa inyo mga kabataan nga siling ninyo pagabihagon, dal-on ko sila sa duta nga inyo ginsikway kag mangin ila ini. ");
INSERT INTO hil_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Pero kamo ya magakalamatay diri sa kamingawan. ");
INSERT INTO hil_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ang inyo mga kabataan mangin pareho sa mga manugbantay sang karnero nga magalibot-libot diri sa kamingawan sa sulod sang 40 ka tuig. Sa sini nga paagi, magaantos sila tungod sang inyo pagluib sa akon hasta nga mapatay kamo tanan. ");
INSERT INTO hil_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Subong nga ang mga tawo nga nagpang-espiya sa duta nagtiner didto sing 40 ka adlaw, magaantos man kamo sing 40 ka tuig tungod sang inyo sala, para mahibaluan ninyo kon paano ako mangakig sa mga nagakontra sa akon. ");
INSERT INTO hil_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ako, ang Ginoo, ang nagasiling sini kag sigurado gid nga himuon ko ini nga mga butang sa sining malain nga komunidad nga nag-isa sa pagkontra sa akon. Mapatay sila tanan diri sa kamingawan.’ ” ");
INSERT INTO hil_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Ang mga tawo nga ginsugo ni Moises sa pagpang-espiya, nga nagpanugid sang malain nga balita parte sa duta kag nangin kabangdanan sang pagreklamo sang mga Israelinhon, nagkalamatay sa balatian sa presensya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Sa dose sa ila nga nagpang-espiya, si Josue nga anak ni Nun kag si Caleb nga anak ni Jefune lang ang wala mapatay. ");
INSERT INTO hil_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Sang ginsugid ni Moises ang ginsiling sang Ginoo sa tanan nga Israelinhon, nagpangasubo gid sila. ");
INSERT INTO hil_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Kag sang sunod nga adlaw, aga pa gid sila nagbangon para magtaklad sa kabukiran sang Canaan. Nagsiling sila, “Nareyalisar namon nga nakasala kami, kag karon handa na kami sa pagkadto sa lugar nga ginpromisa sang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Pero nagsiling si Moises, “Ngaa nga ginalapas ninyo ang sugo sang Ginoonga magbalik kamo anay sa kamingawan? Indi gid kamo magmadinalag-on! ");
INSERT INTO hil_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Indi kamo maglakat, kay ang Ginoo wala nagaupod sa inyo, kag mapierdi lang kamo sa inyo mga kaaway. ");
INSERT INTO hil_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Sa tion nga magpakig-away sa inyo ang mga Canaanhon kag ang mga Amaleknon, magakalamatay kamo; indi mag-upod sa inyo ang Ginoo tungod kay ginsikway ninyo siya.” ");
INSERT INTO hil_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Pero naglakat gid sila sa kabukiran sang Canaan bisan wala nag-upod sa ila si Moises kag ang Kahon sang Kasugtanan sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Dayon ginsalakay sila sang mga Amaleknon kag sang mga Canaanhon nga nagaestar didto sa kabukiran, kag napierdi sila, kag ginlagas pa sila hasta sa Horma. ");
INSERT INTO hil_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Ginsugo sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","nga ihambal ini sa mga Israelinhon: “Kon mag-abot na kamo sa duta nga ihatag ko sa inyo nga inyo estaran, ");
INSERT INTO hil_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","maghalad kamo sa akon sang mga halad nga halin sa inyo mga kasapatan. Maghalad kamo sang mga halad nga ginasunog, mga halad sa pagtuman sang isa ka panaad, mga halad nga kinabubut-on, ukon mga halad sa tion sang natalana nga mga piesta. Ang kahamot sang sini nga mga halad nga paagi sa kalayo makapalipay sa akon. ");
INSERT INTO hil_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","5","Ang maghalad sang bataon nga karnero bilang halad nga ginasunog para sa akon maghalad man sang halad nga regalo. Ini nga halad nga regalo dapat duha ka kilo nga harina nga maayo nga klase kag ginmikslahan sang isa ka litro nga mantika. Kag updan pa gid ini sang halad nga ilimnon nga isa ka litro nga bino. ");
INSERT INTO hil_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Kon gulang nga karnero ang ihalad, updan ini sang halad nga regalo nga apat ka kilo nga harina nga maayo nga klase kag ginmikslahan sang isa kag tunga ka litro nga mantika. ");
INSERT INTO hil_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Kag updan pa gid ini sang halad nga ilimnon nga isa kag tunga ka litro nga bino. Ang kahamot sini nga halad makapalipay sa akon. ");
INSERT INTO hil_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“Ang maghalad sang bataon nga baka bilang halad nga ginasunog ukon halad sa pagtuman sang isa ka panaad, ukon halad nga para sa maayo nga relasyon, ");
INSERT INTO hil_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","kinahanglan maghalad man sang halad nga regalo nga anom ka kilo nga harina nga maayo nga klase kag ginmikslahan sang duha ka litro nga mantika. ");
INSERT INTO hil_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Kag updan pa gid ini sang halad nga ilimnon nga duha ka litro nga bino. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa akon. ");
INSERT INTO hil_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Amo ina ang inyo himuon kon maghalad kamo sang isa ka turo nga baka ukon gulang nga karnero nga lalaki ukon bataon nga karnero ukon kanding. ");
INSERT INTO hil_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Himua ninyo ina sa kada sapat nga inyo ihalad. ");
INSERT INTO hil_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“Ang tanan nga tumandok nga mga Israelinhon nga maghalad sang mga halad nga paagi sa kalayo bilang mahamot nga halad nga makapalipay sa akon dapat magsunod sa sina nga mga pagsulundan. ");
INSERT INTO hil_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Kon ang mga pangayaw nga magaestar upod sa inyo, permanente man ukon indi, gusto maghalad sang halad nga paagi sa kalayo bilang mahamot nga halad nga makapalipay sa akon, dapat magsunod man sila sa sina nga mga pagsulundan. ");
INSERT INTO hil_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Kamo nga mga Israelinhon kag ang mga pangayaw nga nagaestar upod sa inyo pareho lang sa akon atubangan kag pareho lang nga kasuguan ang tumanon ninyo. Ini nga pagsulundan dapat tumanon ninyo hasta sa palaabuton nga mga henerasyon. ");
INSERT INTO hil_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Huo, pareho lang nga mga sugo kag mga pagsulundan ang tumanon ninyo kag sang mga pangayaw nga nagaestar upod sa inyo.” ");
INSERT INTO hil_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Ginsugo pa gid sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","nga ihambal ini sa mga Israelinhon: “Kon mag-abot na kamo sa duta nga ihatag ko sa inyo, ");
INSERT INTO hil_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","makakaon kamo sang mga produkto sini. Pero dapat magpain kamo sang iban sini para ihalad sa akon. ");
INSERT INTO hil_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Maghalad kamo sang tinapay halin sa harina nga una ninyo nga gin-galing, pareho sang inyo ginahimo sa una nga patubas sang inyo trigo halin sa linasan. ");
INSERT INTO hil_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Ini nga halad halin sa harina nga una ninyo nga gin-galing ihalad ninyo sa akon hasta san-o. ");
INSERT INTO hil_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“Pero halimbawa nalapas ninyo nga indi hungod ang isa sa sini nga mga sugo nga ginhatag ko kay Moises. ");
INSERT INTO hil_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Ini nga mga sugo nga ginhatag ko sa inyo paagi kay Moises dapat tumanon ninyo halin sang adlaw nga ginhatag ko ini hasta sa palaabuton. ");
INSERT INTO hil_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Kon indi hungod ang paglapas ninyo sini, kag wala kahibalo ang komunidad nga nakalapas kamo, maghalad ang bilog nga komunidad sang isa ka bataon nga baka bilang halad nga ginasunog. Halad ini nga ang iya kahamot makapalipay sa akon. Iupod man ninyo ang mga ginakinahanglan nga halad nga regalo kag halad nga ilimnon kag isa ka lalaki nga kanding bilang halad sa pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Ihalad ini sang pari para matubos ang bilog nga komunidad sa ila sala. Patawaron ko sila kay indi man ato hungod, kag nagdala man sila sa akon sang halad nga paagi sa kalayo kag sang halad sa pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Huo, patawaron ko ang bilog nga komunidad sang Israel, pati ang mga pangayaw nga nagaestar upod sa ila, kay ang tanan nadalahig sa amo nga sala nga indi hungod. ");
INSERT INTO hil_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Pero kon isa lang ka tawo ang nakasala nga indi hungod, magdala siya sang isa ka babayi nga kanding nga isa ka tuig bilang halad sa pagpakatinlo. ");
INSERT INTO hil_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Ihalad ini sang pari sa akon presensya para matubos siya sa iya sala nga indi hungod, kag dayon patawaron ko siya. ");
INSERT INTO hil_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Isa lang ka pagsulundan para sa tanan nga nakasala nga indi hungod, tumandok man siya nga Israelinhon ukon pangayaw nga nagaestar upod sa inyo. ");
INSERT INTO hil_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Pero ang bisan sin-o nga nagapakasala sing hungod, tumandok man siya ukon pangayaw, nagainsulto sa akon. Kag ina nga tawo kinahanglan indi na pagkabigon nga sakop ninyo. ");
INSERT INTO hil_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Tungod kay ginsikway niya ang akon pulong kag ginlapas ang akon sugo. Indi gid ninyo siya pagkabigon nga sakop ninyo. Magapanabat siya sa iya nga sala.” ");
INSERT INTO hil_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Samtang didto sa kamingawan ang mga Israelinhon, may nakita sila nga tawo nga nagapangahoy sang Adlaw nga Inugpahuway. ");
INSERT INTO hil_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Gindala siya sang mga tawo nga nakakita sa iya kay Moises kag kay Aaron kag sa bilog nga komunidad. ");
INSERT INTO hil_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ginpriso nila siya, kay wala sila nakasiguro kon ano ang dapat nga himuon sa iya. ");
INSERT INTO hil_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Dayon nagsiling ang Ginoo kay Moises, “Kinahanglan nga patyon ang amo nga tawo; batuhon siya sang bilog nga komunidad sa guwa sang kampo.” ");
INSERT INTO hil_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Gani gindala siya sang bilog nga komunidad sa guwa sang kampo kag ginbato hasta nga napatay, suno sa ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ginsugo pa gid sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","nga ihambal ini sa mga Israelinhon: “Maghimo kamo sang mga gaway-gaway sa punta sang inyo mga bayo kag butangan ninyo ini sang higot nga asol. Kinahanglan nga sundon ninyo ini hasta san-o. ");
INSERT INTO hil_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ang ini nga mga gaway-gaway magapadumdom sa inyo sang tanan ko nga mga sugo para tumanon ninyo ini kag indi ang inyo lang gusto nga himuon. ");
INSERT INTO hil_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Paagi sa sini nga mga gaway-gaway dumdumon ninyo ang pagtuman sang tanan ko nga sugo, kag mangin akon kamo. ");
INSERT INTO hil_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ako ang Ginoo nga inyo Dios nga nagpaguwa sa inyo sa Egypt para mangin inyo Dios. Huo, ako ang Ginoo nga inyo Dios.” ");
INSERT INTO hil_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Karon, nagrebelde kay Moises si Kora nga anak ni Izhar, nga kaliwat ni Kohat nga anak ni Levi. Upod niya sa pagrebelde si Datan kag si Abiram nga mga anak ni Eliab kag si On nga anak ni Pelet. Mga kaliwat sila ni Reuben. May kaupod pa sila nga 250 ka Israelinhon nga mga lalaki nga mga kilala kag ginpili nga mga pangulo halin sa komunidad sang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Nagkadto sila sing tingob kay Moises kag kay Aaron kag nagsiling, “Sobra na ining inyo ginahimo sa amon! Ngaa bala nga ginapalabaw gid ninyo ang inyo kaugalingon sa komunidad sang Ginoo nga kon sa bagay kami tanan ginpili man sang Ginoo nga mag-alagad sa iya kag ginaupdan man niya?” ");
INSERT INTO hil_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Pagkabati sini ni Moises, nagluhod siya sa pagpangamuyo sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","6","Dayon nagsiling siya kay Kora kag sa tanan niya nga mga sumulunod, “Buwas sa aga ipahayag sang Ginoo kon sin-o ang matuod nga ginpili nga mag-alagad sa iya bilang mga pari, kay papalapiton niya sa iya presensya ang iya ginpili. Gani amo ini ang inyo himuon buwas: magkuha kamo sang mga suludlan sang insenso ");
INSERT INTO hil_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","kag butangan ninyo sang baga kag insenso, kag dal-on sa presensya sang Ginoo. Dayon makita ta kon sin-o gid ang ginpili sang Ginoo nga mag-alagad sa iya. Kamo nga mga Levita, amo ang sobra na ang inyo ginahimo!” ");
INSERT INTO hil_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Nagsiling pa gid si Moises kay Kora, “Pamatii ninyo ini, kamo nga mga Levita. ");
INSERT INTO hil_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Indi pa bala tuman para sa inyo nga sa bilog nga komunidad sang Israel kamo ang ginpili sang Dios sang Israel nga makapalapit sa iya presensya sa pag-alagad sa iya Tolda, kag sa pag-alagad para sa komunidad? ");
INSERT INTO hil_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ginpili niya kamo sa pagpalapit sa iya presensya, kag karon gusto pa ninyo nga mangin mga pari? ");
INSERT INTO hil_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Sin-o si Aaron para reklamuhan ninyo? Ang Ginoo ang ginakontra mo kag sang imo mga sumulunod.” ");
INSERT INTO hil_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Dayon ginpatawag ni Moises si Datan kag si Abiram, nga mga anak ni Eliab. Pero nagsiling sila, “Indi kami magkadto! ");
INSERT INTO hil_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Indi pa bala tuman nga ginkuha mo kami sa Egypt nga ang duta maayo kag mapatubason para patyon lang diri sa kamingawan? Kag karon gusto mo pa gid nga maghari sa amon. ");
INSERT INTO hil_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Kag isa pa gid, wala mo kami pagdal-a sa duta nga maayo kag mapatubason ukon paghatagan sang mga uma ukon mga talamnan sang ubas nga amon mapanag-iyahan. Karon, gusto mo pa gid bala kami nga tuntuhon? Indi kami magkadto sa imo!” ");
INSERT INTO hil_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Naakig gid si Moises kag nagsiling siya sa Ginoo, “Indi pagbatuna ang ila mga halad. Wala ako nakasala sa kay bisan sin-o sa ila; wala ako sing may ginkuha sa ila bisan isa ka donkey.” ");
INSERT INTO hil_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Nagsiling dayon si Moises kay Kora, “Buwas, ikaw kag ang imo mga sumulunod magkadto sa presensya sang Ginoosa Tolda nga Ginapakigkitaan, kag si Aaron makadto man didto. ");
INSERT INTO hil_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ang kada isa sa imo 250 ka sumulunod padal-a sang suludlan sang insenso, kag butangan nila ini sang insenso kag ihalad sa Ginoo. Kamo ni Aaron magdala man sang suludlan sang insenso.” ");
INSERT INTO hil_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Gani ang kada isa nagkuha sang iya suludlan sang insenso kag ginbutangan sang baga kag insenso, kag nagtindog sila upod kay Moises kag kay Aaron sa puwertahan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Ang bilog nga komunidad nga gin-ganyat ni Kora nga magkontra kay Moises kag kay Aaron nagtipon man didto sa puwertahan sang Tolda nga Ginapakigkitaan. Dayon ginpakita sang Ginoo ang iya gamhanan nga presensya sa bilog nga komunidad. ");
INSERT INTO hil_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Nagsiling ang Ginoo kay Moises kag kay Aaron, ");
INSERT INTO hil_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Palayo kamo sa sini nga komunidad kay patyon ko sila gilayon.” ");
INSERT INTO hil_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Pero nagluhod si Moises kag si Aaron kag nagsiling, “O Dios nga ginahalinan sang kabuhi sang tanan nga tawo mangakig ka bala sa bilog nga komunidad tungod sa isa lang ka tawo nga nakasala?” ");
INSERT INTO hil_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Silinga ang komunidad nga magpalayo sila sa mga tolda nila ni Kora, Datan, kag ni Abiram.” ");
INSERT INTO hil_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Ginkadtuan ni Moises si Datan kag si Abiram, kag nagsunod sa iya ang mga manugdumala sang Israel. ");
INSERT INTO hil_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Dayon ginpaandaman niya ang komunidad, “Magpalayo kamo sa mga tolda sining malain nga mga tawo! Indi kamo magtandog sang bisan ano nila nga pagkabutang, kay kon himuon ninyo ina laglagon kamo tungod sang tanan nila nga sala.” ");
INSERT INTO hil_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Gani nagpalayo ang mga tawo sa mga tolda nila ni Kora, Datan, kag Abiram. Karon, nagguwa si Datan kag si Abiram kag nagtindog sa puwertahan sang ila mga tolda upod sang ila mga asawa kag mga kabataan. ");
INSERT INTO hil_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Nagsiling si Moises sa mga tawo, “Sa sini nga paagi mahibaluan ninyo nga ang Ginoo amo ang nagpadala sa akon sa paghimo sini nga mga butang kag indi sa akon lang kagustuhan: ");
INSERT INTO hil_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Kon mapatay ini nga mga tawo sa natural nga kamatayon, ti wala ako pag-ipadala sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Pero kon maghimo ang Ginoo sing makatilingala nga butang, kag magpihak ang duta kag maglamon sa ila nga buhi upod sang tanan nila nga pagkabutang, kag magkadto sila sa idalom didto sa lugar sang mga patay, mahibaluan ninyo nga ini nga mga tawo nagsikway sa Ginoo.” ");
INSERT INTO hil_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Pagkatapos hambal ni Moises, napihak ang duta nga ginatindugan nila ni Datan kag ni Abiram, ");
INSERT INTO hil_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","kag ginlamon sila sang duta pati ang ila mga pamilya, kag pati ang tanan nga tinawo ni Kora kag ang tanan nila nga pagkabutang. ");
INSERT INTO hil_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ginlamon sila tanan nga buhi pati ang tanan nila nga pagkabutang. Dayon nagkipot ang duta kag nadula sila sa komunidad. ");
INSERT INTO hil_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Ang tanan nga Israelinhon nga didto sa ila palibot nagpalalagyo sang mabatian nila ang ila pagsininggit, kay nagahunahuna sila nga basi lamunon man sila sang duta. ");
INSERT INTO hil_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Dayon nagpadala ang Ginoo sang kalayo kag ginlamon sini ang 250 ka sumulunod ni Kora nga nagahalad sang insenso. ");
INSERT INTO hil_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Silinga si Eleazar nga pari, nga anak ni Aaron, nga kuhaon niya ang mga suludlan sang insenso sa mga bangkay nga nagkalasunog, kay balaan ini nga mga suludlan. Silinga man siya nga laptahon niya sa malayo ang mga baga ");
INSERT INTO hil_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","sang sini nga mga suludlan nga halin sa mga tawo nga nagkalamatay tungod sa ila mga sala. Dayon ipamartilyo ang mga suludlan hasta nga magtapan kag ihaklap sa halaran kay ginhalad ini sa Ginoo kag nangin balaan ini. Ining haklap sa halaran mangin isa ka paandam para sa mga Israelinhon.” ");
INSERT INTO hil_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","40","Gani suno sa ginsugo sang Ginoo paagi kay Moises, ginpanguha ni Eleazar nga pari ang saway nga mga suludlan sang insenso nga ginpangdala sadtong mga nagkalasunog, kag ginpamartilyo niya para ihaklap sa halaran. Isa ini ka paandam para sa mga Israelinhon nga wala sing bisan sin-o nga makapalapit sa halaran sa pagsunog sang insenso sa Ginoo luwas lang sa mga kaliwat ni Aaron, para indi matabo sa iya ang natabo kay Kora kag sa iya mga sumulunod. ");
INSERT INTO hil_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Pero pagkasunod nga adlaw, nagreklamo naman ang bilog nga komunidad sang Israel kay Moises kag kay Aaron. Nagsiling sila, “Ginpamatay ninyo ang katawhan sang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Samtang nagareklamo sila sing tingob kay Moises kag kay Aaron, nagbalikid sila sa Tolda nga Ginapakigkitaan kag nakita nila nga gulpi lang nga ginlikupan sang panganod ang Tolda kag ginpakita sang Ginoo ang iya gamhanan nga presensya. ");
INSERT INTO hil_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Dayon nagkadto si Moises kag si Aaron sa atubangan sang Tolda ");
INSERT INTO hil_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","kag nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Palayo kamo sa sina nga komunidad kay laglagon ko sila gilayon.” Nagluhod dayon sila nga duha. ");
INSERT INTO hil_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Dayon nagsiling si Moises kay Aaron, “Kuhaa ang imo suludlan sang insenso kag butangi ini sang baga halin sa halaran. Dayon butangi ini sang insenso kag magdali-dali ka kadto sa komunidad kag himua ang seremonya para matubos sila sa ila mga sala, kay akig na ang Ginoo kag nagsugod na ang kahalitan.” ");
INSERT INTO hil_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Gani gintuman ni Aaron ang ginsugo ni Moises, kag nagdalagan siya sa tunga sang komunidad. Nagsugod na ang kahalitan sa mga tawo, pero ginsunog ni Aaron ang insenso para matubos ang mga tawo sa ila mga sala. ");
INSERT INTO hil_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Nagtindog siya sa tunga sang mga tawo nga patay na kag sang mga buhi pa, kag nag-untat ang kahalitan. ");
INSERT INTO hil_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Pero 14,700 ang napatay wala labot sadtong napatay tungod kay Kora. ");
INSERT INTO hil_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Dayon nagbalik si Aaron kay Moises sa puwertahan sang Tolda nga Ginapakigkitaan, kay nag-untat na ang kahalitan. ");
INSERT INTO hil_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Silinga ang mga Israelinhon nga ang kada pangulo sang kada tribo maghatag sa imo sang isa ka baston, kag pabutangi ini sang ila tagsa ka ngalan. Dose tanan ka baston. ");
INSERT INTO hil_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Sa baston sang tribo ni Levi, isulat ang ngalan ni Aaron. Kay kinahanglan may isa ka baston sa kada pangulo sang tribo. ");
INSERT INTO hil_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ibutang ini tanan sa Tolda nga Ginapakigkitaan, sa atubangan sang Kahon sang Kasuguan nga sa diin nagapakigkita ako sa inyo ni Aaron. ");
INSERT INTO hil_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Kag magapanalingsing ang baston sang tawo nga pilion ko nga mag-alagad sa akon bilang pari, kag sa sini nga paagi mag-untat ang pagreklamo sang mga Israelinhon kontra sa inyo ni Aaron.” ");
INSERT INTO hil_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Gani ginsilingan ni Moises ang mga Israelinhon, kag ang kada pangulo sang tribo naghatag sa iya sang baston. Dose tanan ka baston, kag isimpon didto ang baston ni Aaron. ");
INSERT INTO hil_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ginbutang tanan ni Moises ang mga baston sa presensya sang Ginoo didto sa Tolda nga sa diin nabutang ang Kasuguan. ");
INSERT INTO hil_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Pagkasunod nga adlaw, nagsulod si Moises sa Tolda nga sa diin nabutang ang Kasuguan. Kag nakita niya didto nga ang baston ni Aaron, nga nagarepresentar sang tribo ni Levi, nagpanalingsing, nagpamukol, nagpamulak, kag nagpamunga pa sang luto nga mga almendro. ");
INSERT INTO hil_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Dayon ginpaguwa ni Moises ang tanan nga baston kag ginpakita sa tanan nga Israelinhon. Gintan-aw nila ini, kag ang kada pangulo sang tribo nagkuha sang iya baston. ");
INSERT INTO hil_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Nagsiling ang Ginoo kay Moises, “Ibalik ang baston ni Aaron sa atubangan sang Kahon sang Kasuguan para mangin paandam ini sa mga rebelde nga magakalamatay sila kon indi sila mag-untat sa pagreklamo kontra sa akon.” ");
INSERT INTO hil_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Gintuman ni Moises ang ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Nagsiling ang mga Israelinhon kay Moises, “Mapatay na kami sini tanan! ");
INSERT INTO hil_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Kay bisan magpalapit lang ang isa ka tawo sa Tolda sang Ginoo mapatay. Ti, mapatay na kami sini tanan!” ");
INSERT INTO hil_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Nagsiling ang Ginoo kay Aaron, “Ikaw kag ang imo mga anak nga lalaki kag ang imo mga paryente halin sa tribo ni Levi amo ang responsable sa sala nga inyo mahimo sa inyo pag-alagad sa balaan nga Tolda. Pero ikaw lang kag ang imo mga anak ang responsable sa sala nga inyo mahimo nga may kaangtanan sa inyo pagkapari. ");
INSERT INTO hil_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Kon mag-alagad ka kag ang imo mga anak sa Tolda nga sa diin nabutang ang Kasuguan, pabuliga ninyo ang inyo mga paryente halin sa tribo ni Levi. ");
INSERT INTO hil_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Magaobra sila sa idalom sang imo pagdumala, kag himuon nila ang tanan nila nga buluhaton sa Tolda, pero indi sila dapat magtandog sa balaan nga mga kagamitan sang Tolda ukon sa halaran, kay kon himuon nila ina magakalamatay sila pati kamo. ");
INSERT INTO hil_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Magbulig sila sa imo, kag responsibilidad nila ang pag-atipan sang Tolda nga Ginapakigkitaan kag ang paghimo sang tanan nga buluhaton sini. Dapat wala sing bisan sin-o nga magbulig sa inyo nga indi kaliwat ni Levi. ");
INSERT INTO hil_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Ikaw kag ang imo mga anak ang responsable sa pag-atipan sang Balaan nga Lugar kag sang halaran, para indi ako mangakig liwat sa mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ako mismo ang nagpili sang imo kapareho nga mga kaliwat ni Levi halin sa mga Israelinhon para mangin imo kabulig. Gindedikar sila sa akon sa pag-alagad sa Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Pero ikaw lang kag ang imo mga anak ang makaalagad bilang mga pari. Kamo lang ang makahimo sang mga buluhaton nga may kaangtanan sa halaran kag sa Labing Balaan nga Lugar. Regalo ko sa inyo ang inyo pagkapari. Ang bisan sin-o nga maghimo sini nga indi pari pagapatyon.” ");
INSERT INTO hil_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Dayon nagsiling ang Ginoo kay Aaron, “Ako mismo ang nagpili sa imo nga magdumala sa balaan nga mga halad nga ginahalad sang mga Israelinhon sa akon. Ginahatag ko ini sa imo kag sa imo mga anak bilang parte ninyo hasta san-o. ");
INSERT INTO hil_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","May ara kamo sang parte sa sining balaan nga mga halad nga wala ginasunog, nga ginahalad sang mga tawo sa akon bilang balaan nga mga halad. Lakip sa sini nga mga halad amo ang halad nga regalo, halad sa pagpakatinlo, kag halad nga bayad sa sala. Amo ini ang imo parte kag sang imo mga anak. ");
INSERT INTO hil_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Kauna ninyo ini sa balaan gid nga lugar. Kinahanglan nga mga lalaki lang ang magkaon sini kag kabiga ninyo ini nga balaan. ");
INSERT INTO hil_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Ang iban pa gid nga mga halad sang mga Israelinhon nga ginabayaw sa halaran para man sa inyo. Ginahatag ko ini sa imo kag sa imo mga kaliwat bilang inyo parte hasta san-o. Makakaon sini ang bisan sin-o sa imo pamilya nga ginakabig nga matinlo. ");
INSERT INTO hil_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Ginahatag ko man sa inyo ang maayo nga mga produkto nga ginahalad sang mga Israelinhon halin sa ila nahauna nga patubas: lana, duga sang ubas, kag uyas. ");
INSERT INTO hil_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Huo, mangin inyo ang tanan nga produkto nga ila ginahalad sa akon halin sa nahauna nga patubas sang ila duta. Makakaon sini ang bisan sin-o sa imo pamilya nga ginakabig nga matinlo. ");
INSERT INTO hil_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Ang tanan nga butang sa Israel nga ginhalad sa akon sing bug-os mangin inyo. ");
INSERT INTO hil_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Ang tanan nga kamagulangan nga lalaki, tawo man ukon sapat, nga ginahalad sa akon mangin inyo man. Pero kinahanglan nga ipagawad ninyo sa manughalad ang kamagulangan nga mga anak nga lalaki kag ang mga kamagulangan nga mga sapat nga ginakabig nga mahigko. ");
INSERT INTO hil_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ipagawad ninyo ini kon isa na ka bulan ang edad, kag kinahanglan nga ipagawad ninyo ini sa bili nga lima ka bilog nga pilak, suno sa kabug-aton sang pilak sa kilohan sang mga pari. ");
INSERT INTO hil_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Pero indi ninyo pag-ipagawad ang kamagulangan nga turo nga baka, karnero ukon kanding kay akon na ini. Ihawon ninyo ini kag iwisik ang dugo sa halaran kag sunuga ang mga tambok bilang halad nga paagi sa kalayo. Ang kahamot sini nga halad makapalipay sa akon. ");
INSERT INTO hil_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Inyo ang karne sini, subong nga ang dughan kag ang tuo nga paa sang halad nga ginabayaw inyo man. ");
INSERT INTO hil_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Huo, ginahatag ko sa inyo ining tanan nga balaan nga mga halad nga ginabayaw sang mga Israelinhon sa akon. Para ini sa imo kag sa imo mga kaliwat bilang inyo parte hasta san-o. Ining kasugtanan ko sa imo kag sa imo mga kaliwat indi maliwat hasta san-o.” ");
INSERT INTO hil_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Nagsiling pa gid ang Ginoo kay Aaron, “Kamo nga mga pari wala sing may mapanubli nga duta sa Israel, kay ako mismo ang maghatag sang inyo mga kinahanglanon. ");
INSERT INTO hil_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Kon parte sa mga Levita, bayaran ko sila sa ila nga serbisyo sa Tolda. Ihatag ko sa ila ang tanan nga ikanapulo nga ihatag sang mga Israelinhon bilang parte nila. ");
INSERT INTO hil_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Sugod subong, wala sing iban nga Israelinhon nga magpalapit sa Tolda nga Ginapakigkitaan luwas lang sa mga pari kag sa mga Levita, kay kon magpalapit sila, magapanabat sila sa ila nga sala kag mapatay. ");
INSERT INTO hil_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ang mga Levita amo ang responsable sa mga buluhaton sa Tolda nga Ginapakigkitaan, kag magapanabat sila sa ila mahimo nga sala kontra sini. Ini nga pagsulundan dapat tumanon hasta sa palaabuton nga mga henerasyon. Ang mga Levita wala sing may mapanubli nga duta sa Israel. ");
INSERT INTO hil_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Sa baylo, ihatag ko sa ila bilang parte nila ang mga ikanapulo nga ihatag sang mga Israelinhon bilang halad nila sa akon. Amo gani nga nagsiling ako nga ang mga Levita wala sing may mapanubli nga duta sa Israel.” ");
INSERT INTO hil_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Ginsugo sang Ginoo si Moises ");
INSERT INTO hil_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","nga ihambal niya ini sa mga Levita: “Kon mabaton ninyo halin sa mga Israelinhon ang ikanapulo nga ihatag ko sa inyo bilang parte ninyo, kinahanglan nga maghatag man kamo sang inyo ikanapulo halin sa amo nga ikanapulo bilang halad sa akon. ");
INSERT INTO hil_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Kabigon ko ini bilang halad ninyo halin sa mga patubas, nga daw sa naghalad kamo sang uyas halin sa linasan ukon bino halin sa pulugaan sang ubas. ");
INSERT INTO hil_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Sa sini nga paagi makahatag man kamo sang halad sa akon halin sa tanan nga ikanapulo nga inyo mabaton halin sa mga Israelinhon. Kag ang akon parte, nga amo ang ikanapulo sini, ihatag ninyo kay Aaron nga pari. ");
INSERT INTO hil_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Kinahanglan nga ang akon parte amo ang pinakamaayo nga parte sang tanan nga ihatag sa inyo. ");
INSERT INTO hil_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Kon mahalad na ninyo ini, kabigon ko ini bilang halad ninyo halin sa linasan ukon pulugaan sang ubas. ");
INSERT INTO hil_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Puwede ninyo kaunon sang inyo pamilya ang inyo parte bisan diin nga lugar, kay ina ang inyo suweldo sa pag-alagad sa Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Indi kamo makasala sa inyo pagkaon sini kon nahalad na ninyo ang pinakamaayo nga parte sa Ginoo. Gani siguraduhon ninyo nga indi ninyo madagtaan ang balaan nga mga halad sang mga Israelinhon paagi sa pagkaon sang inyo parte nga wala pa ninyo mahatag ang akon parte, para indi kamo mapatay.” ");
INSERT INTO hil_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Nagsiling ang Ginoo kay Moises kag kay Aaron, ");
INSERT INTO hil_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Ari pa ang isa ka pagsulundan nga gusto ko nga tumanon ninyo: Silinga ninyo ang mga Israelinhon nga dal-an nila kamo sang isa ka mapula nga baka nga wala sing deperensya kag wala pa magamit sa pag-arado. ");
INSERT INTO hil_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Ihatag ninyo ini kay Eleazar nga pari, kag dal-on ini sa guwa sang kampo kag ihawon sa iya atubangan. ");
INSERT INTO hil_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Dayon itum-oy ni Eleazar ang iya tudlo sa dugo sini kag iwisik sing makapito ka beses sa atubangan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Kag samtang nagatulok si Eleazar, sunugon ang bilog nga baka—ang panit, unod, dugo kag mga tinai. ");
INSERT INTO hil_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Dayon magkuha si Eleazar sang isa ka utod nga kahoy nga sedro, isa ka pungpong sang tanom nga isopo, kag pula nga higot, kag ihaboy ini tanan sa ginasunog nga baka. ");
INSERT INTO hil_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Pagkatapos sina kinahanglan nga labhan ni Eleazar ang iya bayo kag magpaligo. Kag dayon makasulod na siya sa kampo, pero kabigon pa siya nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ang tawo nga nagsunog sang baka kinahanglan nga labhan man niya ang iya bayo kag magpaligo, kag kabigon man siya nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Ang tawo nga ginakabig nga matinlo amo ang magkuha sang abo sang baka, kag ibutang niya ini sa isa ka lugar nga ginakabig nga matinlo sa guwa sang kampo. Taguon ini pero gamiton sang komunidad sang Israel nga inugmiksla sa tubig nga para sa pagpakatinlo. Ini nga seremonya ginahimo para makuha ang sala. ");
INSERT INTO hil_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ang tawo nga nagkuha sang abo sang baka kinahanglan man nga labhan niya ang iya bayo, kag kabigon man siya nga mahigko hasta magsirom. Ini nga pagsulundan dapat tumanon hasta san-o sang mga Israelinhon kag sang mga pangayaw nga nagaestar upod sa ila. ");
INSERT INTO hil_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Ang bisan sin-o nga magtandog sang bangkay kabigon nga mahigko sa sulod sang pito ka adlaw. ");
INSERT INTO hil_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Kinahanglan nga tinluan niya ang iya kaugalingon sang tubig nga ginagamit sa pagpakatinlo sa ikatatlo kag ikapito nga adlaw, dayon kabigon na siya nga matinlo. Pero kon indi siya magpakatinlo sa ikatatlo kag ikapito nga adlaw, indi siya pagkabigon nga matinlo. ");
INSERT INTO hil_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ang bisan sin-o nga makatandog sang bangkay kag wala nagpakatinlo daw pareho lang nga gindagtaan niya ang Tolda sang Ginoo. Kinahanglan ina nga tawo indi pagkabigon nga sakop ninyo. Kag tungod nga wala siya nawisiki sang tubig nga ginagamit sa pagpakatinlo, mahigko pa siya gihapon. ");
INSERT INTO hil_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Amo ini ang pagsulundan kon may napatay sa sulod sang tolda: Ang bisan sin-o nga magsulod sa tolda nga may napatay ukon ara na nga daan sa sulod sa tion sang pagkapatay, kabigon nga mahigko sa sulod sang pito ka adlaw. ");
INSERT INTO hil_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Kag kabigon man nga mahigko ang bisan ano nga mga suludlan sa tolda nga wala sing takop. ");
INSERT INTO hil_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Kabigon man nga mahigko sa sulod sang pito ka adlaw ang bisan sin-o nga ara sa guwa sang kampo nga nakatandog sang bangkay nga ginpatay ukon napatay lang sa natural nga kamatayon. Amo man sa nakatandog sang tul-an sang tawo ukon nakatandog sang lulubngan. ");
INSERT INTO hil_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Agod makuha ang pagkahigko, ibutang sa suludlan ang iban nga abo sang baka nga ginahalad para sa pagpakatinlo, kag dayon simpunan sang tubig. ");
INSERT INTO hil_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Dayon ang isa ka tawo nga ginakabig nga matinlo magkuha sang isa ka pungpong sang tanom nga isopo kag itum-oy niya ini sa sadto nga tubig kag iwisik dayon sa tolda nga namatyan kag sa tanan nga kagamitan sini, kag sa mga tawo nga nakasulod sa tolda. Wisikan man ang tawo nga nakatandog sang tul-an sang tawo, ukon sang bangkay sang tawo nga ginpatay ukon napatay lang sa natural nga kamatayon, ukon nakatandog sang lulubngan. ");
INSERT INTO hil_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Sa ikatatlo kag ikapito nga adlaw, wisikan sang tawo nga ginakabig nga matinlo ang tawo nga mahigko. Kag sa ikapito nga adlaw, ang tawo nga gintinluan kinahanglan labhan niya ang iya bayo kag magpaligo, kag pagkasirom kabigon na siya nga matinlo. ");
INSERT INTO hil_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Pero kon ang tawo nga mahigko indi magpakatinlo, indi siya pagkabigon nga sakop ninyo, kay daw pareho lang nga gindagtaan niya ang balaan nga Tolda sang Ginoo. Kag tungod nga wala siya nawisiki sang tubig nga para sa pagpakatinlo, mahigko siya gihapon. ");
INSERT INTO hil_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ini nga pagsulundan dapat tumanon nila hasta san-o. “Ang tawo nga nagawisik sang tubig nga para sa pagpakatinlo kinahanglan nga labhan man niya ang iya bayo, kag ang bisan sin-o nga magtandog sang tubig nga para sa pagpakatinlo kabigon nga mahigko hasta magsirom. ");
INSERT INTO hil_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ang bisan sin-o ukon bisan ano nga matandog sang mahigko nga tawo mangin mahigko man hasta magsirom.” ");
INSERT INTO hil_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Sa nahauna nga bulan, nag-abot ang bilog nga komunidad sang Israel sa kamingawan sang Zin, kag nagkampo sila sa Kadesh. Didto napatay si Miriam kag ginlubong. ");
INSERT INTO hil_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Karon, wala sing tubig didto, kag nagtipon naman ang mga tawo kontra kay Moises kag kay Aaron. ");
INSERT INTO hil_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Nagbais sila kay Moises kag nagsiling, “Maayo pa nga napatay na lang kami upod sang amon mga kasimanwa nga nagkalamatay sadto sa presensya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Ngaa bala nga gindala mo pa kami nga komunidad sang Ginoo diri sa kamingawan para magkalamatay man lang kami kag ang amon kasapatan? ");
INSERT INTO hil_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Ngaa bala nga ginpaguwa mo pa kami sa Egypt kag gindala diri sa wala sing pulos nga lugar? Wala diri sing uyas, higos, ubas ukon pomegranata. Kag wala pa sing tubig nga mainom!” ");
INSERT INTO hil_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Gani naghalin si Moises kag si Aaron sa komunidad, kag nagkadto sila sa puwertahan sang Tolda nga Ginapakigkitaan kag nagluhod sila sa pagpangamuyo. Dayon nagpakita sa ila ang gamhanan nga presensya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Kuhaa ang baston kag tipuna ninyo sang imo utod nga si Aaron ang bilog nga komunidad. Kag samtang nagatulok sila, sugua ang bato nga magtubod, kag magatubod ini. Sa sini nga paagi mahatagan ninyo sing tubig ang katawhan para mapainom ninyo sila kag ang ila kasapatan.” ");
INSERT INTO hil_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Gani ginkuha ni Moises ang baston sa presensya sang Ginoo, didto sa Kahon sang Kasugtanan, suno sa sugo sang Ginoo sa iya. ");
INSERT INTO hil_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Dayon gintipon nila ni Aaron ang bilog nga komunidad sa atubangan sang bato, kag nagsiling si Moises sa ila, “Pamati kamo nga mga rebelde, kinahanglan bala nga hatagan namon kamo sang tubig halin sa sini nga bato?” ");
INSERT INTO hil_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Dayon ginbayaw ni Moises ang iya baston kag ginhampak sing makaduha ka beses ang bato, kag nagpuswak ang tubig, kag nag-inom ang komunidad kag ang ila mga kasapatan. ");
INSERT INTO hil_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Pero nagsiling ang Ginoo kay Moises kag kay Aaron, “Tungod kay wala kamo magpati sa akon sa inyo pagpakita sang akon pagkabalaan sa atubangan sang mga Israelinhon, indi kamo ang magapangulo sa pagdala sini nga komunidad sa duta nga ihatag ko sa ila.” ");
INSERT INTO hil_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ini nga lugar gintawag nga tuburan sang Meriba kay ginbais sang mga Israelinhon ang Ginoo sa sini nga lugar, kag diri man ginpakita sang Ginoo sa ila ang iya pagkabalaan. ");
INSERT INTO hil_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Samtang didto pa ang mga Israelinhon sa Kadesh, nagpadala si Moises sang mga mensahero sa hari sang Edom. Amo ini ang iya mensahi, “Ini nga mensahi halin sa imo mga paryente, ang katawhan sang Israel: Nahibaluan mo ang tanan nga kabudlayan nga amon naagyan. ");
INSERT INTO hil_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Ang amon mga katigulangan nagkadto sa Egypt, kag malawig ang amon pag-estar didto. Gindaogdaog kami kag ang amon mga katigulangan sang mga Egyptohanon, ");
INSERT INTO hil_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","pero nagpangayo kami sang bulig sa Ginoo kag ginpamatian niya kami kag ginpadal-an sang anghel nga nagpaguwa sa amon sa Egypt. “Karon, ari kami diri sa Kadesh, ang banwa sa higad sang imo teritoryo. ");
INSERT INTO hil_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Kon mahimo tuguti kami sa pag-agi sa imo duta. Indi kami mag-agi sa mga uma ukon talamnan sang ubas ukon mag-inom sa mga bubon. Maagi lang kami sa imo mayor nga dalan kag indi kami mag-agi sa iban nga mga dalan hasta nga makaguwa kami sa imo teritoryo.” ");
INSERT INTO hil_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Pero amo ini ang sabat sang hari sang Edom: “Indi kamo mag-agi diri sa amon. Kon mag-agi kamo, salakayon namon kamo kag pamatyon.” ");
INSERT INTO hil_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Nagsabat ang mga Israelinhon, “Maagi lang kami sa mayor nga dalan, kag kon makainom man kami kag ang amon mga kasapatan sang inyo tubig, bayaran namon ini. Maagi lang gid kami sa inyo.” ");
INSERT INTO hil_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Nagsabat liwat ang hari sang Edom: “Basta indi kamo mag-agi diri.” Dayon gintipon sang hari sang Edom ang iya gamhanan kag mabakod nga mga soldado para magpakig-away sa mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Tungod kay indi magpaagi ang mga taga-Edom sa ila teritoryo, naglikaw na lang ang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Naghalin ang bilog nga komunidad sang Israel sa Kadesh kag nagkadto sa Bukid sang Hor. ");
INSERT INTO hil_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Didto sa Bukid sang Hor, malapit sa border sang Edom, nagsiling ang Ginoo kay Moises kag kay Aaron, ");
INSERT INTO hil_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Nag-abot na ang tion nga isimpon ka na Aaron sa imo mga paryente nga nagkalamatay na. Indi ka makasulod sa duta nga ihatag ko sa mga Israelinhon tungod kay nagsupak kamo nga duha ni Moises sa akon sugo didto sa tuburan sang Meriba. ");
INSERT INTO hil_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Karon, Moises, dal-a si Aaron kag ang iya anak nga si Eleazar sa Bukid sang Hor. ");
INSERT INTO hil_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Dayon ubahi si Aaron sang iya bayo nga pagkapari kag ipasuksok mo sa iya anak nga si Eleazar, kay mapatay na si Aaron didto sa bukid.” ");
INSERT INTO hil_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Gintuman ni Moises ang ginsugo sa iya sang Ginoo. Nagsaka sila sa Bukid sang Hor samtang nagatulok ang bilog nga komunidad. ");
INSERT INTO hil_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Dayon gin-uba ni Moises ang bayo ni Aaron kag ginpasuksok niya ini kay Eleazar. Kag napatay didto si Aaron sa ibabaw sang bukid. Dayon nagpanaog si Moises kag si Eleazar sa bukid. ");
INSERT INTO hil_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Kag sang mahibaluan sang bilog nga komunidad nga patay na si Aaron, nagpangasubo sila para sa iya sa sulod sang 30 ka adlaw. ");
INSERT INTO hil_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Karon, ang Canaanhon nga hari sang Arad nga nagaestar sa Negev nakabati nga nagapadulong ang mga Israelinhon, nga nagaagi sa dalan sang Atarim. Gani ginsalakay niya sila kag ginbihag ang iban sa ila. ");
INSERT INTO hil_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Dayon nagsumpa ang mga Israelinhon sa Ginoo, “Kon itugyan mo ini nga mga tawo sa amon mga kamot, laglagon namon sing bug-os ang ila mga banwa.” ");
INSERT INTO hil_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Ginpamatian sang Ginoo ang pangabay sang mga Israelinhon kag gintugyan niya sa ila ang mga Canaanhon. Ginlaglag sila sing bug-os sang mga Israelinhon pati ang ila mga banwa, gani gintawag ato nga lugar nga Horma. ");
INSERT INTO hil_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Halin sa Bukid sang Hor, naglakat ang mga Israelinhon nga nagaagi sa dalan nga pakadto sa Mapula nga Dagat para makalibot sila sa duta sang Edom. Pero natak-an ang mga tawo sa ila paglakat, ");
INSERT INTO hil_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","gani nagreklamo sila sa Dios kag kay Moises. Siling nila, “Ngaa bala ginpaguwa pa ninyo kami sa Egypt para magkalamatay man lang diri sa kamingawan? Wala diri sing pagkaon kag tubig! Kag indi na kami makaagwanta sining makasulum-od nga manna.” ");
INSERT INTO hil_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Gani, ginpadal-an sila sang Ginoo sang dalitan nga mga man-og kag ginpangkagat sila, kag madamo ang nagkalamatay sa ila. ");
INSERT INTO hil_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Nagkadto ang mga tawo kay Moises kag nagsiling, “Nakasala kami sang paghambal namon kontra sa Ginoo kag sa imo. Pangamuyua sa Ginoo nga kuhaon niya sa amon ining mga man-og.” Gani nagpangamuyo si Moises para sa mga tawo. ");
INSERT INTO hil_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Nagsiling ang Ginoo kay Moises, “Maghimo ka sang man-og nga saway kag ibutang ini sa punta sang isa ka tukon. Ang bisan sin-o nga ginkagat sang man-og magtulok lang sa sining man-og nga saway kag indi siya mapatay.” ");
INSERT INTO hil_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Gani naghimo si Moises sang man-og nga saway kag ginbutang sa punta sang isa ka tukon. Kag ang bisan sin-o nga ginkagat sang man-og nagtulok lang sa sining man-og nga saway kag wala siya napatay. ");
INSERT INTO hil_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Nagpadayon sa paglakat ang mga Israelinhon, kag nagkampo sila sa Obot. ");
INSERT INTO hil_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Halin sa Obot, naglakat sila kag nagkampo sa Iye Abarim, sa kamingawan nga ara sa east sang Moab. ");
INSERT INTO hil_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Halin didto naglakat sila kag nagkampo sa Zered nga ililigan sang tubig. ");
INSERT INTO hil_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Kag halin sa Zered naglakat naman sila kag nagkampo sa tabok sang Arnon nga ililigan sang tubig, nga ara sa kamingawan nga malapit sa teritoryo sang mga Amornon. Ang Arnon amo ang border sang duta sang mga Moabnon kag sang duta sang mga Amornon. ");
INSERT INTO hil_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Amo gani nga nasulat sa Libro sang Pagpakig-away sang Ginoo ang Waheb nga sakop sang Sufa, ang mga ililigan sang tubig lakip na ang Arnon, ");
INSERT INTO hil_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","kag ang kilid sang mga ililigan sang tubig nga nagalambot sa banwa sang Ar nga ara sa border sang Moab. ");
INSERT INTO hil_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Halin didto sa Arnon, nagkadto ang mga Israelinhon sa Beer, ang bubon nga sa diin nagsiling ang Ginoo kay Moises, “Tipuna ang mga tawo kay hatagan ko sila sang tubig.” ");
INSERT INTO hil_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Kag didto nagkanta ang mga Israelinhon sang sini nga ambahanon: “Padayon nga maghatag sang tubig ang ini nga bubon! Magkanta kita parte sa sini nga bubon ");
INSERT INTO hil_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","nga ginpakutkot sang mga pangulo kag mga dungganon nga mga tawo paagi sa ila awtoridad.” Halin sa kamingawan nagkadto sila sa Matana; ");
INSERT INTO hil_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","halin sa Matana nagkadto sila sa Nahaliel; halin sa Nahaliel nagkadto sila sa Bamot; ");
INSERT INTO hil_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","kag halin sa Bamot nagkadto sila sa pulopatag sang Moab, nga sa diin makita ang kamingawan sa ubos sang putokputokan sang Pisga. ");
INSERT INTO hil_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Karon, nagpadala sang mga mensahero ang Israel kay Sihon nga hari sang mga Amornon. Amo ini ang ila mensahi: ");
INSERT INTO hil_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Kon mahimo tuguti kami sa pag-agi sa inyo duta. Indi kami mag-agi sa mga uma ukon talamnan sang ubas ukon mag-inom sa mga bubon. Maagi lang kami sa inyo mayor nga dalan hasta nga makaguwa kami sa inyo teritoryo.” ");
INSERT INTO hil_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Pero wala nagsugot si Sihon nga mag-agi ang mga Israelinhon sa iya teritoryo. Sa baylo, gintipon niya ang iya bilog nga mga soldado kag nagkadto sila sa kamingawan sa pagsalakay sa mga Israelinhon. Pag-abot nila sa Jahaz, nagpakig-away sila kontra sa mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Pero ginpamatay sila sang mga Israelinhon kag gin-agaw ang ila duta halin sa Arnon pakadto sa Suba sang Jabok. Pero hasta lang ang mga Israelinhon sa border sang duta sang mga Ammonhon, tungod kay ang ila border napaderan sing mapag-on. ");
INSERT INTO hil_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Gani naagaw sang mga Israelinhon ang tanan nga banwa sang mga Amornon kag gin-estaran nila ini, pati ang Heshbon kag ang tanan nga baryo nga sakop sini. ");
INSERT INTO hil_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Ining Heshbon amo sadto ang kapital nga siyudad ni Sihon nga hari sang mga Amornon. Napierdi niya sadto ang isa ka hari sang Moab kag gin-agaw niya ang tanan nga duta sini hasta sa Arnon. ");
INSERT INTO hil_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","28","Amo ina kon ngaa ang mga manugbinalaybay nagasiling nga: “Dali kamo sa Heshbon, ang siyudad ni Sihon, kag patinduga ninyo ini liwat. Sadto anay ang mga soldado sang Heshbon nagsalakay nga daw sa nagadabadaba nga kalayo kag naglamon sa banwa sang Ar nga sakop sang Moab kag naglaglag sa mataas nga mga lugar sang Arnon. ");
INSERT INTO hil_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Kaluluoy kamo nga mga taga-Moab! Nalaglag kamo nga mga nagasimba sa dios nga si Kemosh. Kamo nga iya mga anak ginpabay-an niya nga mabihag ni Sihon nga hari sang mga Amornon. ");
INSERT INTO hil_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Pero karon nalaglag na namon ang mga Amornon. Nagkalaguba na ang siyudad sang Heshbon, pati ang Dibon, Nofa, kag Medeba.” ");
INSERT INTO hil_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Gani nag-estar ang mga Israelinhon sa duta sang mga Amornon. ");
INSERT INTO hil_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Pagkatapos, nagpadala si Moises sang mga espiya sa Jazer, kag gin-agaw man nila ini kag ang mga baryo nga sakop sini. Ginpahalin nila ang mga Amornon nga nagaestar didto. ");
INSERT INTO hil_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Dayon nagkadto sila sa Bashan, pero ginsalakay sila ni Haring Og sang Bashan kag sang iya bilog nga mga soldado didto sa Edrei. ");
INSERT INTO hil_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Nagsiling ang Ginoo kay Moises, “Indi ka magkahadlok sa iya, kay sigurado nga itugyan ko siya sa imo, pati ang iya bilog nga katawhan kag ang iya duta. Himua sa iya ang ginhimo mo kay Sihon nga hari sang mga Amornon nga naghari sa Heshbon.” ");
INSERT INTO hil_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Gani ginpatay sang mga Israelinhon si Og, pati ang iya kabataan kag ang tanan niya nga katawhan, kag wala gid sing may nabilin sa ila. Dayon ginpanag-iyahan sang mga Israelinhon ang duta nga sakop ni Og. ");
INSERT INTO hil_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Nagpadayon sa paglakat ang mga Israelinhon hasta nga nakaabot sila sa kapatagan sang Moab, kag nagkampo sila sa east sang Suba sang Jordan, sa atubangan sang Jerico. ");
INSERT INTO hil_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Karon, nahibaluan ni Haring Balak sang Moab, nga anak ni Zipor, ang tanan nga ginhimo sang mga Israelinhon sa mga Amornon. ");
INSERT INTO hil_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Hinadlukan gid siya kag ang mga Moabnon tungod sa kadamuon sang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Nagsiling ang mga Moabnon sa mga manugdumala sang Midian, “Ubuson gid kita sining madamo nga tawo, pareho sa baka nga nagasipot sang mga hilamon.” Gani si Balak nga anak ni Zipor, nga amo ang hari sang Moab sang sina nga panahon, ");
INSERT INTO hil_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","nagpadala sang mga mensahero sa pagpatawag kay Balaam nga anak ni Beor nga nagaestar sa Petor. Diri natawo si Balaam sa Petor, nga malapit sa Suba sang Euphrates. Amo ini ang mensahi ni Balak: “May mga tawo nga naghalin sa Egypt kag puwerte sila kadamo kag nagaestar malapit sa amon. ");
INSERT INTO hil_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Gani kadto diri kag pakamalauta ini nga mga tawo, kay mas gamhanan sila sang sa amon. Kag basi pa lang mapierdi ko sila kag matabog palayo sa akon duta. Kay nahibaluan ko nga ang bisan sin-o nga bendisyunan mo ginabendisyunan, kag ang pakamalauton mo ginapakamalaot.” ");
INSERT INTO hil_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Gani naglakat ang mga manugdumala sang Moab kag Midian nga dala ang bayad para kay Balaam. Ginsilingan nila siya sang ginsiling ni Balak. ");
INSERT INTO hil_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Kag nagsiling si Balaam sa ila, “Diri lang kamo tulog sa gab-i, kag isugid ko sa inyo buwas kon ano ang ihambal sang Ginoo sa akon.” Gani didto nagtulog ang mga pangulo sang Moab. ");
INSERT INTO hil_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Karon, nagpamangkot ang Dios kay Balaam, “Sin-o ining upod mo nga mga tawo?” ");
INSERT INTO hil_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Nagsabat si Balaam sa Dios, “Sila ang mga mensahero nga ginpadala ni Haring Balak sang Moab, nga anak ni Zipor. Amo ini ang iya mensahi: ");
INSERT INTO hil_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘May mga tawo nga naghalin sa Egypt kag puwerte sila kadamo. Gani kadto ka diri kag pakamalauta ini nga mga tawo para sa akon. Kay basi pa lang mapierdi ko sila kag matabog palayo.’ ” ");
INSERT INTO hil_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Pero nagsiling ang Dios kay Balaam, “Indi ka mag-upod sa ila. Kag indi pagpakamalauta ang mga tawo nga ginasiling nila, kay ginpakamaayo ko sila.” ");
INSERT INTO hil_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Pagbugtaw ni Balaam pagkaaga, ginsilingan niya ang mga pangulo ni Balak, “Pauli na lang kamo sa inyo nasyon kay indi magsugot ang Ginoo nga mag-upod ako sa inyo.” ");
INSERT INTO hil_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Gani nagbalik ang mga pangulo sang Moab kay Balak kag nagsiling, “Indi mag-upod si Balaam sa amon.” ");
INSERT INTO hil_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Gani nagpadala liwat si Balak sang mga pangulo nga mas madamo kag mas dungganon pa sang sa nahauna. ");
INSERT INTO hil_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Nagkadto sila kay Balaam kag nagsiling: “Amo ini ang ginpasiling ni Balak nga anak ni Zipor: ‘Indi pagtuguti nga may magsablag sa imo sa pagkadto diri. ");
INSERT INTO hil_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Bayaran ko ikaw sing maayo kag himuon ko ang bisan ano nga gusto mo. Sige na, kadto na diri kag pakamalauta ini nga mga tawo para sa akon.’ ” ");
INSERT INTO hil_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Pero nagsabat si Balaam sa ila, “Bisan ihatag pa ni Balak sa akon ang iya palasyo nga puno sang pilak kag bulawan, indi ko mahimo nga lapason ang sugo sang Ginoo nga akon Dios, bisan sa dako ukon sa gamay lang nga bagay. ");
INSERT INTO hil_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Pero diri lang anay kamo tulog sa gab-i pareho sang ginhimo sang iban ninyo nga kaupod, kay basi kon may iban pa nga ihambal ang Ginoo sa akon.” ");
INSERT INTO hil_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Sadto nga gab-i nagsiling ang Dios kay Balaam, “Total nagkadto gid man diri ini nga mga tawo sa pagtawag sa imo, mag-upod ka na lang sa ila, pero ang isiling ko lang sa imo amo ang himua.” ");
INSERT INTO hil_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Gani pagkaaga, ginpreparar ni Balaam ang iya donkey kag nag-upod sa mga pangulo sang Moab, ");
INSERT INTO hil_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","upod sang iya duha ka suluguon. Pero samtang nagapanglakaton si Balaam nga nagasakay sa donkey, nangakig gid ang Dios, gani ginbalabagan siya sang anghel sang Ginoo sa dalan. ");
INSERT INTO hil_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Pagkakita sang donkey nga nagatindog ang anghel sang Ginoo sa dalan nga nagauyat sang espada, naglipas sang dalan ang donkey kag nagpakadto sa uma. Gani ginhanot ini ni Balaam kag ginpabalik sa dalan. ");
INSERT INTO hil_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Dayon nagtindog ang anghel sang Ginoo sa makitid nga dalan sa gin-utlan sang duha ka pader sang mga talamnan sang ubas. ");
INSERT INTO hil_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Pagkakita sang donkey sa anghel sang Ginoo, nagpangalihid siya sa pader hasta nga naipit ang tiil ni Balaam. Gani ginhanot siya liwat ni Balaam. ");
INSERT INTO hil_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Dayon naglakat sa unhan ang anghel sang Ginoo kag nagtindog sa mas makitid pa nga dalan nga indi na gid makaliso sa wala ukon sa tuo. ");
INSERT INTO hil_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Pagkakita sang donkey sa anghel sang Ginoo nagluko na lang siya, kag nangakig gid si Balaam kag ginhanot niya ini sang iya baston. ");
INSERT INTO hil_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Dayon ginpahambal sang Ginoo ang donkey, kag nagsiling ini kay Balaam, “Ano bala ang nahimo ko sa imo nga ginhanot mo ako sing tatlo na ka beses?” ");
INSERT INTO hil_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Nagsabat si Balaam sa donkey, “Ginhimo mo ako nga daw sa buang-buang! Kon may espada lang ako, patyon ta gid ka subong.” ");
INSERT INTO hil_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Nagsiling ang donkey kay Balaam, “Indi bala nga ako ang imo donkey nga permi mo ginasakyan? Nakaagi bala nga nagbisyo ako sing pareho sini?” Nagsabat si Balaam, “Wala.” ");
INSERT INTO hil_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Dayon ginpakita sang Ginoo kay Balaam ang iya anghel nga nagatindog sa dalan nga nagauyat sang espada. Gani nagluhod si Balaam sa duta. ");
INSERT INTO hil_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Nagpamangkot sa iya ang anghel sang Ginoo, “Ngaa bala nga ginhanot mo ang imo donkey sing tatlo gid ka beses? Ari ako diri sa pagbalabag sa imo kay ang imo pagginawi indi husto sa akon panulok. ");
INSERT INTO hil_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Nakita ako sang imo donkey kag naglikaw siya sa akon sing tatlo ka beses. Kon wala siya naglikaw sa akon, ginpatay ko na kuntani ikaw, kag ang imo donkey ginpabay-an ko nga mabuhi.” ");
INSERT INTO hil_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Nagsiling si Balaam sa anghel sang Ginoo, “Nakasala ako! Wala gid ako nakahibalo nga nagatindog ka gali dira sa dalan sa pagbalabag sa akon. Karon, kon para sa imo malain ang akon ginahimo, mapuli na lang ako.” ");
INSERT INTO hil_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Nagsiling ang anghel sang Ginoo kay Balaam, “Upod ka sa sina nga mga tawo, pero ihambal lang ang isiling ko sa imo.” Gani nag-upod si Balaam sa mga pangulo ni Balak. ");
INSERT INTO hil_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Pagkahibalo ni Balak nga nagapadulong si Balaam, naglakat siya sa pagsugata sa iya didto sa isa ka banwa sang Moab malapit sa Arnon, sa border sang iya teritoryo. ");
INSERT INTO hil_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Nagsiling si Balak kay Balaam, “Indi bala nga dali-dali ko ikaw nga ginpatawag? Ngaa wala ka nagkadto gilayon? Nagahunahuna ka bala nga indi ko ikaw pagsuhulan?” ");
INSERT INTO hil_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Nagsabat si Balaam, “Ti, ari na ako. Pero wala ako sing iban nga ihambal kundi ang ipahambal lang sang Dios sa akon.” ");
INSERT INTO hil_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Dayon nag-upod si Balaam kay Balak sa Kiriat Huzot. ");
INSERT INTO hil_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Kag didto naghalad si Balak sang baka kag karnero. Ginhatag niya ang iban nga karne kay Balaam kag sa mga pangulo nga kaupod niya. ");
INSERT INTO hil_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Pagkaaga, gindala ni Balak si Balaam sa Bamot Baal, kag didto nakita niya sa ubos ang iban nga mga katawhan sang Israel. ");
INSERT INTO hil_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Nagsiling si Balaam kay Balak, “Pahimui ako diri sing pito ka halaran, kag preparahi ako sing pito ka turo nga baka kag pito ka gulang nga karnero nga lalaki.” ");
INSERT INTO hil_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Gintuman ni Balak ang ginsiling ni Balaam, kag duha sila ang naghalad sang turo nga baka kag sang lalaki nga karnero sa kada halaran. ");
INSERT INTO hil_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Dayon nagsiling si Balaam kay Balak, “Diri ka lang sa tupad sang imo halad nga ginasunog. Malakat ako anay, kay basi magpakigkita ang Ginoo sa akon. Sugiran ko lang ikaw kon ano ang iya isiling sa akon.” Gani nagtaklad siya sa mahawan nga bukid. ");
INSERT INTO hil_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Nagpakigkita ang Dios sa iya, kag nagsiling si Balaam, “Nagpahimo ako sang pito ka halaran, kag sa kada halaran naghalad ako sang isa ka baka kag isa ka karnero.” ");
INSERT INTO hil_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Ginhatagan sang Ginoo si Balaam sang mensahi kag nagsiling, “Balik ka kay Balak kag ihambal mo sa iya ining ginsiling ko.” ");
INSERT INTO hil_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Gani nagbalik si Balaam kay Balak, kag nakita niya siya nga nagatindog sa tupad sang iya halad, upod sa tanan nga pangulo sang Moab. ");
INSERT INTO hil_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Dayon nagsiling si Balaam: “O Haring Balak sang Moab, ginpatawag mo ako halin sa Aram, sa kabukiran sa east. Nagsiling ka sa akon, ‘Dali, kag pakamalauta ang mga kaliwat ni Jacob para sa akon. Sumpaa sila nga katawhan sang Israel.’ ");
INSERT INTO hil_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Paano ko pakamalauton ang mga tawo nga wala ginapakamalaot sang Dios? Paano ko sumpaon ang mga tawo nga wala ginasumpa sang Ginoo? ");
INSERT INTO hil_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Sang didto ako sa ibabaw sang mga bukid, nakita ko sila. Nagakabuhi sila nga silahanon lang, nga naseparar sa iban nga mga nasyon. ");
INSERT INTO hil_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Wala sing may makaisip sang ila kadamuon nga pareho sa yab-ok. Kabay pa nga ang akon kamatayon mangin pareho sa ila nga mga matarong.” ");
INSERT INTO hil_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Nagsiling si Balak kay Balaam, “Ano ining ginhimo mo sa akon? Ginpakuha ko ikaw sa pagpakamalaot sa akon mga kaaway, pero ang imo ginhimo ginbendisyunan mo sila!” ");
INSERT INTO hil_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Nagsabat si Balaam, “Kinahanglan nga ihambal ko ang ginapahambal sang Ginoo sa akon.” ");
INSERT INTO hil_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Dayon nagsiling si Balak sa iya, “Mag-upod ka sa akon sa isa pa ka lugar nga sa diin makita mo ang iban nga mga katawhan sang Israel, pero indi gid ang tanan. Kag didto pakamalauton mo sila.” ");
INSERT INTO hil_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Gani gindala ni Balak si Balaam sa isa ka uma sa Zofim, sa putokputokan sang Pisga, kag didto nagpatindog sila sang pito ka halaran kag naghalad sang isa ka baka kag isa ka karnero sa kada halaran. ");
INSERT INTO hil_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Nagsiling si Balaam kay Balak, “Diri ka lang sa tupad sang imo halad nga ginasunog samtang magpakigkita ako sa Ginoo dira sa unhan.” ");
INSERT INTO hil_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Nagpakigkita ang Ginoo kay Balaam kag ginhatagan niya siya sang mensahi. Kag dayon nagsiling siya, “Balik ka kay Balak kag ihambal mo sa iya ini nga mensahi.” ");
INSERT INTO hil_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Gani nagbalik si Balaam kay Balak, kag nakita niya siya nga nagatindog sa tupad sang iya halad, upod sa mga pangulo sang Moab. Nagpamangkot si Balak kay Balaam, “Ano ang ginsiling sang Ginoo sa imo?” ");
INSERT INTO hil_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Nagsiling si Balaam, “Balak nga anak ni Zipor, pamatii ako sing maayo. ");
INSERT INTO hil_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Ang Dios indi tawo nga magbutig ukon magbaylo ang iya hunahuna. Nagahambal bala siya nga wala niya ginahimo? Nagapromisa bala siya nga wala niya ginatuman? ");
INSERT INTO hil_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ginsugo niya ako nga magbendisyon, kag kon mabendisyunan na niya gani, indi ko na ini mabawi pa. ");
INSERT INTO hil_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Wala ako sing nakita nga katalagman ukon kabudlayan nga maabot sa Israel. Kaupod nila ang Ginoo nga ila Dios; ginakilala nila nga siya amo ang ila hari. ");
INSERT INTO hil_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Ginpaguwa sila sang Dios sa Egypt; para sa ila, pareho siya sa isa ka makusog nga talunon nga baka. ");
INSERT INTO hil_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Wala sing babaylan ukon manughiwit nga makahalit sa ila. Gani magasiling ang mga tawo parte sa Israel, ‘Daw ano ka makatilingala ang ginhimo sang Dios sa Israel.’ ");
INSERT INTO hil_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ini nga katawhan pareho sa leon nga handa sa pagsalakay kag wala nagapahuway hasta nga malamon niya ang iya biktima kag masuyop ang dugo sini.” ");
INSERT INTO hil_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Dayon nagsiling si Balak kay Balaam, “Kon indi mo gid man sila pagpakamalauton, indi sila pagbendisyuni!” ");
INSERT INTO hil_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Nagsabat si Balaam, “Indi bala nga ginsilingan ko na ikaw nga kinahanglan nga himuon ko kon ano ang isiling sang Ginoo sa akon?” ");
INSERT INTO hil_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Nagsiling liwat si Balak kay Balaam, “Dali, dal-on ko ikaw sa lain naman nga lugar. Basi didto magsugot na ang Dios nga pakamalauton mo ang Israel para sa akon.” ");
INSERT INTO hil_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Gani gindala ni Balak si Balaam sa putokputokan sang Peor, nga sa diin kitaon ang kamingawan sa ubos. ");
INSERT INTO hil_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Nagsiling si Balaam, “Pahimui ako diri sing pito ka halaran, kag magpreparar ka sing pito ka turo nga baka kag pito ka lalaki nga karnero para sa akon.” ");
INSERT INTO hil_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Gani ginhimo ni Balak ang ginsiling ni Balaam, kag naghalad siya sang isa ka baka kag isa ka karnero sa kada halaran. ");
INSERT INTO hil_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Karon, sang mareyalisar ni Balaam nga gusto sang Ginoo nga bendisyunan ang Israel, wala na siya nagpangbabaylan pareho sang iya ginahimo sang una. Sa baylo, nag-atubang siya sa kamingawan, ");
INSERT INTO hil_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","nga sa diin nakita niya ang mga Israelinhon nga nagakampo suno sa ila tagsa-tagsa ka tribo. Dayon gin-gamhan siya sang Espiritu sang Dios, ");
INSERT INTO hil_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","kag nagsiling siya, “Ako si Balaam nga anak ni Beor, kag may maathag ako nga pag-intiendi. ");
INSERT INTO hil_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Nabatian ko ang mensahi sang Dios, kag nakakita ako sang palanan-awon nga halin sa Makagagahom nga Dios. Nagpaubos ako sa iya, kag ginpahangop niya ako. Amo ini ang akon mensahi: ");
INSERT INTO hil_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Daw ano katahom sang mga tolda nga ginaestaran sang katawhan sang Israel nga mga kaliwat ni Jacob. ");
INSERT INTO hil_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Pareho ini sa mga nagaraya nga mga palma, ukon sa mga katamnan sa higad sang suba. Pareho man ini sa kahoy nga aloe nga gintanom sang Ginoo, ukon sang mga kahoy nga sedro sa higad sang tubig. ");
INSERT INTO hil_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Nagaawas ang mga tubig sa ila mga suludlan, kag nagatanom sila sang liso sa mga duta nga bugana sang tubig. Ang ila hari mangin gamhanan pa sang sa kay Agag nga hari sang Amaleknon, kag ang ila ginharian mangin bantog. ");
INSERT INTO hil_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Ginpaguwa sila sang Dios sa Egypt; para sa ila, pareho siya sa isa ka makusog nga talunon nga baka. Panaon kag laglagon nila ang ila mga kaaway; nga daw sa ginalamon nila, kag daw sa ginadugmok nila ang ila mga tul-an. ");
INSERT INTO hil_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Pareho sila sa mga leon nga kon makatulog na wala sing may mangahas sa pagpukaw sa ila. Pakamaayuhon ang mga nagapakamaayo sa ila kag pakamalauton ang mga nagapakamalaot sa ila.” ");
INSERT INTO hil_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Tungod sini, puwerte ang kaakig ni Balak kay Balaam. Ginhampak niya sang iya inumol ang iya nga palad kag nagsiling siya, “Ginpatawag ko ikaw sa pagpakamalaot sa akon mga kaaway, pero ginbendisyunan mo sila sing tatlo pa ka beses. ");
INSERT INTO hil_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Magpuli ka na lang gilayon! Nagpromisa ako nga bayaran ko ikaw sing maayo, pero indi magsugot ang Ginoo nga mabaton mo ang bayad.” ");
INSERT INTO hil_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Nagsabat si Balaam kay Balak, “Indi bala nga ginsilingan ko ang imo mga mensahero, ");
INSERT INTO hil_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","nga bisan ihatag mo pa sa akon ang imo palasyo nga puno sang pilak kag bulawan, indi ako makahimo sang akon kabubut-on, malain man ukon maayo. Kundi kon ano ang ginasiling sang Ginoo sa akon nga akon ihambal, amo lang ang akon ihambal. ");
INSERT INTO hil_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Sige, mapuli na ako sa akon mga kasimanwa. Pero paandaman ko anay ikaw kon ano ang himuon sining mga tawo sa imo mga tawo sa ulihi.” ");
INSERT INTO hil_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Dayon ginhambal ni Balaam ini nga mensahi: “Ako si Balaam nga anak ni Beor, kag may maathag ako nga pag-intiendi. ");
INSERT INTO hil_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Nabatian ko ang pulong sang Labing Mataas nga Dios kag ginhatagan niya ako sang pag-intiendi. Nakakita ako sang palanan-awon halin sa Makagagahom nga Dios. Nagpaubos ako sa iya kag ginpaintiendi niya ako. Amo ini ang akon mensahi: ");
INSERT INTO hil_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“May nakita ako sa akon palanan-awon nga wala pa natabo. Sa palaabuton nga mga inadlaw, may magahari sa Israel nga halin sa kaliwat ni Jacob. Laglagon niya ang mga Moabnon kag ang tanan nga kaliwat ni Set. ");
INSERT INTO hil_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Sakupon niya ang Edom nga iya kaaway, nga ginatawag man nga Seir, samtang ang Israel iya magabakod. ");
INSERT INTO hil_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Magadumala ang isa ka pangulo sa Israel kag laglagon niya ang mga nabilin pa nga buhi sa siyudad sang Moab.” ");
INSERT INTO hil_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Dayon nakita ni Balaam sa iya palanan-awon ang katawhan sang Amalek kag nagsiling siya, “Ang Amalek amo sadto ang nagapanguna sa mga nasyon, pero sa ulihi malaglag ini.” ");
INSERT INTO hil_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Dayon nakita naman ni Balaam sa iya palanan-awon ang mga Kenhanon kag nagsiling siya: “Mabakod ang inyo ginapuy-an, kay nahamtang ini sa bato nga bukid. ");
INSERT INTO hil_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Pero malaglag kamo kon bihagon kamo sang Assyria.” ");
INSERT INTO hil_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Kag nagsiling pa gid si Balaam sini nga mensahi: “Abaw, sin-o bala ang mabuhi kon himuon ini sang Dios? ");
INSERT INTO hil_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Magaabot ang mga barko halin sa Kitim kag sakupon nila ang mga katawhan sang Assyria kag sang Eber, pero ang Kitim malaglag man.” ");
INSERT INTO hil_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Dayon nagpuli si Balaam kag amo man si Balak. ");
INSERT INTO hil_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Samtang nagakampo ang mga Israelinhon sa Shitim, ang mga lalaki nag-umpisa sa pagpakighilawas sa mga babayi nga Moabnon. ");
INSERT INTO hil_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Ini nga mga babayi nagganyat sa ila sa paghalad sa mga dios-dios nila, kag nagkaon sila sang sini nga mga halad kag nagsimba sa sini nga mga dios-dios. ");
INSERT INTO hil_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Gani ang mga Israelinhon nagbuylog sa pagsimba kay Baal sang Peor. Kag puwerte gid ang kaakig sang Ginoo sa ila. ");
INSERT INTO hil_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Nagsiling ang Ginoo kay Moises, “Kuhaa ang tanan nga pangulo sang sini nga mga tawo, kag patya sila sa akon presensya samtang nagatan-aw ang mga tawo, para madula ang akon puwerte nga kaakig sa Israel.” ");
INSERT INTO hil_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Gani nagsiling si Moises sa mga manughukom sang Israel, “Kinahanglan nga patyon sang kada isa sa inyo ang inyo mga tawo nga nagsimba kay Baal sang Peor.” ");
INSERT INTO hil_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Karon, may isa ka Israelinhon nga nagdala sang isa ka Midianhon nga babayi sa iya pamilya. Nakita ini ni Moises kag sang bilog nga komunidad sang Israel samtang nagahinibi sila didto sa puwertahan sang Tolda nga Ginapakigkitaan. ");
INSERT INTO hil_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Pagkakita sini ni Finehas nga anak ni Eleazar kag apo ni Aaron nga pari, naghalin siya sa komunidad kag nagkuha sang bangkaw. ");
INSERT INTO hil_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Ginsunod niya ang tawo sa sulod sang tolda, kag gintuhog niya sila nga duha sang babayi. Dayon nag-untat ang kahalitan sa Israel, ");
INSERT INTO hil_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","pero 24,000 ang napatay tungod sa kahalitan. ");
INSERT INTO hil_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Ginkuha ni Finehas nga anak ni Eleazar kag apo ni Aaron nga pari ang kaakig ko sa mga Israelinhon, tungod kay akig gid siya sa sala pareho sa akon. Gani wala ko pag-ubusa pamatay ang mga Israelinhon, nga himuon ko kuntani sa ila tungod sa akon kaakig. ");
INSERT INTO hil_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Gani silinga siya nga mahimo ako sang kasugtanan sa iya, nga pakamaayuhon ko ang iya kahimtangan. ");
INSERT INTO hil_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Kag sa sini nga kasugtanan, siya kag ang iya mga kaliwat mangin mga pari hasta san-o, kay tungod sa akon ginpakita niya nga akig gid siya sa sala, kag gintubos niya ang mga Israelinhon sa ila sala.” ");
INSERT INTO hil_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ang Israelinhon nga ginpatay upod sang babayi nga Midianhon amo si Zimri nga anak ni Salu, nga pangulo sang isa ka pamilya sa mga kaliwat ni Simeon. ");
INSERT INTO hil_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Kag ang Midianhon nga babayi amo si Cozbi nga anak ni Zur. Si Zur isa ka pangulo sang isa ka pamilya nga Midianhon. ");
INSERT INTO hil_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Kabiga ninyo nga kaaway ang mga Midianhon, kag pamatya ninyo sila, ");
INSERT INTO hil_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","tungod kay ginkabig man nila kamo nga mga kaaway sang gindayaan nila kamo didto sa Peor, kag tungod man sa babayi nga si Cozbi nga anak sang isa ka pangulo nga Midianhon. Ini nga babayi ginpatay sadtong tion nga nag-abot ang kahalitan sa Peor.” ");
INSERT INTO hil_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Pagkatapos sang kahalitan, nagsiling ang Ginoo kay Moises kag kay Eleazar nga anak ni Aaron nga pari, ");
INSERT INTO hil_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“I-census ninyo ang bilog nga komunidad sang Israel suno sa ila pamilya—tanan nga nagaedad sing 20 ka tuig paibabaw nga makasarang sa pag-alagad bilang soldado sang Israel.” ");
INSERT INTO hil_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Gani nagpakighambal si Moises kag si Eleazar nga pari sa mga Israelinhon didto sa kapatagan sang Moab sa higad sang Suba sang Jordan malapit sa Jerico. ");
INSERT INTO hil_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Siling nila, “I-census ninyo ang mga tawo nga nagaedad sing 20 ka tuig paibabaw, suno sa ginsugo sang Ginoo kay Moises.” Amo ini ang mga Israelinhon nga nagguwa sa Egypt: ");
INSERT INTO hil_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ang mga kaliwat ni Reuben, nga kamagulangan nga anak ni Jacob, amo ang mga pamilya ni Hanoc, Palu, ");
INSERT INTO hil_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezron, kag Carmi. ");
INSERT INTO hil_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Sila amo ang mga pamilya nga naghalin kay Reuben; 43,730 sila tanan. ");
INSERT INTO hil_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Ang anak ni Palu amo si Eliab, ");
INSERT INTO hil_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","kag ang mga anak ni Eliab amo sila ni Nemuel, Datan kag Abiram. Ining si Datan kag si Abiram amo ang mga pangulo sang komunidad nga nag-upod kay Kora sa pagrebelde sa Ginoo paagi sa pagkontra kay Moises kag kay Aaron. ");
INSERT INTO hil_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Pero ginlamon sila sang duta upod kay Kora, kag ang 250 nila ka sumulunod nasunog sang kalayo. Kag ini nga hitabo nangin paandam sa mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Pero ang mga anak ni Kora wala nagkalamatay. ");
INSERT INTO hil_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ang mga kaliwat ni Simeon amo ang mga pamilya ni Nemuel, Jamin, Jakin, ");
INSERT INTO hil_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zera, kag Shaul. ");
INSERT INTO hil_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Sila amo ang mga pamilya nga naghalin kay Simeon; 22,200 sila tanan. ");
INSERT INTO hil_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Ang mga kaliwat ni Gad amo ang mga pamilya ni Zefon, Hagi, Shuni, ");
INSERT INTO hil_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni, Eri, ");
INSERT INTO hil_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod, kag Areli. ");
INSERT INTO hil_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Sila amo ang mga pamilya nga naghalin kay Gad; 40,500 sila tanan. ");
INSERT INTO hil_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","20","Si Juda may duha ka anak nga lalaki nga si Er kag Onan, nga napatay sa duta sang Canaan. Pero may mga kaliwat gihapon si Juda nga amo ang pamilya ni Shela, Perez, kag Zera. ");
INSERT INTO hil_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Ang mga kaliwat ni Perez amo ang pamilya ni Hezron kag ni Hamul. ");
INSERT INTO hil_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Sila amo ang mga pamilya nga naghalin kay Juda; 76,500 sila tanan. ");
INSERT INTO hil_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Ang mga kaliwat ni Isacar amo ang mga pamilya ni Tola, Pua, ");
INSERT INTO hil_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jashub, kag Shimron. ");
INSERT INTO hil_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Sila amo ang mga pamilya nga naghalin kay Isacar; 64,300 sila tanan. ");
INSERT INTO hil_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Ang mga kaliwat ni Zebulun amo ang mga pamilya ni Sered, Elon, kag Jaleel. ");
INSERT INTO hil_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Sila amo ang mga pamilya nga naghalin kay Zebulun; 60,500 sila tanan. ");
INSERT INTO hil_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ang mga kaliwat ni Jose naghalin sa iya duha ka anak nga si Manase kag si Efraim. ");
INSERT INTO hil_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ang mga kaliwat ni Manase amo ang mga pamilya ni Makir kag sang iya anak nga si Gilead. ");
INSERT INTO hil_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ang mga kaliwat ni Gilead amo ang mga pamilya ni Iezer, Helek, ");
INSERT INTO hil_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel, Shekem, ");
INSERT INTO hil_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shemida, kag Hefer. ");
INSERT INTO hil_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Ang anak ni Hefer nga si Zelofehad wala sing anak nga lalaki, pero may mga anak siya nga babayi nga ang ila mga ngalan amo sila ni Mala, Noa, Hogla, Milca, kag Tirza. ");
INSERT INTO hil_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Sila amo ang mga pamilya nga naghalin kay Manase; 52,700 sila tanan. ");
INSERT INTO hil_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ang mga kaliwat naman ni Efraim amo ang mga pamilya ni Shutela, Beker, Tahan, ");
INSERT INTO hil_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","kag sa anak ni Shutela nga si Eran. ");
INSERT INTO hil_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Sila amo ang mga pamilya nga naghalin kay Efraim; 32,500 sila tanan. Ini nga mga pamilya nga naghalin kay Manase kag Efraim amo ang mga kaliwat ni Jose. ");
INSERT INTO hil_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Ang mga kaliwat ni Benjamin amo ang mga pamilya ni Bela, Ashbel, Ahiram, ");
INSERT INTO hil_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shufam, kag Hufam. ");
INSERT INTO hil_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ang mga kaliwat ni Bela amo ang mga pamilya ni Ard kag Naaman. ");
INSERT INTO hil_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Sila amo ang mga pamilya nga naghalin kay Benjamin; 45,600 sila tanan. ");
INSERT INTO hil_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ang mga kaliwat ni Dan amo ang mga Shuhamnon. ");
INSERT INTO hil_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Ang tanan nga kaliwat ni Dan mga Shuhamnon; kag 64,400 sila tanan. ");
INSERT INTO hil_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ang mga kaliwat ni Asher amo ang mga pamilya ni Imna, Ishvi, kag Beria. ");
INSERT INTO hil_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ang mga kaliwat ni Beria amo ang mga pamilya ni Heber kag ni Malkiel. ");
INSERT INTO hil_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(May anak nga babayi si Asher nga si Sera.) ");
INSERT INTO hil_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Sila amo ang mga pamilya nga naghalin kay Asher; 53,400 sila tanan. ");
INSERT INTO hil_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Ang mga kaliwat ni Naftali amo ang mga pamilya ni Jazeel, Guni, ");
INSERT INTO hil_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezer, kag Shilem. ");
INSERT INTO hil_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Sila amo ang mga pamilya nga naghalin kay Naftali; 45,400 sila tanan. ");
INSERT INTO hil_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Gani ang bug-os nga kadamuon sang mga lalaki nga Israelinhon nga gin-census 601,730. ");
INSERT INTO hil_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Dayon nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Partihon mo sa ila ang duta bilang ila palanublion suno sa kadamuon sang kada tribo. ");
INSERT INTO hil_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Ang tribo nga madamo, partihi sing dako, kag ang tribo nga diutay partihi sing gamay. ");
INSERT INTO hil_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","56","Kinahanglan nga gabot-gabutan kon diin nga parte ang makuha sang madamo kag diutay nga tribo suno sa census.” ");
INSERT INTO hil_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ang mga kaliwat ni Levi amo ang mga pamilya ni Gershon, Kohat kag Merari. ");
INSERT INTO hil_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Kag sa ila naghalin ang mga pamilya ni Libni, Hebron, Mali, Mushi kag Kora. Si Kohat amo ang katigulangan ni Amram; ");
INSERT INTO hil_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","kag ang asawa ni Amram amo si Jokebed nga kaliwat man ni Levi. Natawo si Jokebed sa Egypt. Si Amram kag si Jokebed amo ang mga ginikanan ni Aaron, Moises, kag Miriam. ");
INSERT INTO hil_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Si Aaron amo ang amay nila ni Nadab, Abihu, Eleazar, kag Itamar. ");
INSERT INTO hil_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Pero napatay si Nadab kag si Abihu sang naggamit sila sang kalayo nga indi amo ang dapat nila gamiton sa ila paghalad sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ang kadamuon sang mga lalaki nga kaliwat ni Levi nga nagaedad sing isa ka bulan paibabaw 23,000. Wala sila ginlakip sa kabilugan nga kadamuon sang mga Israelinhon kay wala sila ginpartihan sa duta nga ginpanubli sang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Amo ato tanan ang mga Israelinhon nga gin-census ni Moises kag ni Eleazar nga pari didto sa kapatagan sang Moab sa higad sang Jordan malapit sa Jerico. ");
INSERT INTO hil_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Wala na sing may nabilin nga buhi sa mga nalakip sa nahauna nga census nga ginhimo ni Moises kag ni Aaron nga pari sa kamingawan sang Sinai. ");
INSERT INTO hil_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Kay nagsiling sadto ang Ginoo sa ila nga sigurado gid nga magkalamatay sila didto sa kamingawan, kag wala sing may makaluwas sa ila luwas lang gid kay Caleb nga anak ni Jefune kag kay Josue nga anak ni Nun. ");
INSERT INTO hil_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Si Zelofehad may mga anak nga babayi nga sila ni Mala, Noa, Hogla, Milca kag Tirza. Si Zelofehad nga ini anak ni Hefer kag apo ni Gilead. Si Gilead anak ni Makir kag apo ni Manase. Si Manase anak ni Jose. ");
INSERT INTO hil_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Karon, ini nga mga babayi nagkadto sa puwertahan sang Tolda nga Ginapakigkitaan kag nagtindog sa atubangan ni Moises, ni Eleazar, sang mga pangulo, kag sang bilog nga komunidad. Nagsiling ang mga babayi, ");
INSERT INTO hil_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Napatay ang amon amay didto sa kamingawan nga wala sing anak nga lalaki. Pero napatay siya indi tungod nga sumulunod siya ni Kora nga nagrebelde sa Ginoo, kundi tungod sa iya kaugalingon nga sala. ");
INSERT INTO hil_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Ti, dulaon na lang bala ang iya ngalan sa panimalay sang Israel tungod kay wala siya sing anak nga lalaki? Hatagi man kami sang duta pareho sang nabaton sang amon mga paryente.” ");
INSERT INTO hil_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Gani ginsugid ni Moises sa Ginoo ang ila ginapangayo, ");
INSERT INTO hil_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","kag nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Husto ang ginasiling sang mga anak nga babayi ni Zelofehad. Kinahanglan nga hatagan mo man sila sang duta kaupod sa mga paryente sang ila amay. Ihatag sa ila ang duta nga para kuntani sa ila amay. ");
INSERT INTO hil_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Kag silingon mo ang mga Israelinhon nga kon mapatay ang isa ka tawo nga wala sing anak nga lalaki, kinahanglan nga ihatag sa iya anak nga babayi ang iya duta. ");
INSERT INTO hil_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Kon wala siya sing anak nga babayi, ihatag sa iya mga utod nga lalaki. ");
INSERT INTO hil_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Kon wala pa gid siya sing utod nga lalaki, ihatag ang iya duta sa iya mga tiyo sa amay. ");
INSERT INTO hil_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Kon ang iya amay wala sing utod nga lalaki, ihatag ang iya duta sa pinakamalapit niya nga paryente, kag ang amo nga paryente ang magapanag-iya sini. Dapat tumanon ini sang mga Israelinhon bilang isa ka legal nga pagsulundan, suno sa ginsugo ko sa imo, Moises.” ");
INSERT INTO hil_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Dayon nagsiling ang Ginoo kay Moises, “Magsaka ka sa bukid sang Abarim kag tan-awa didto ang duta nga ginhatag ko sa mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Pagkatapos mo nga makita ini, mapatay ka pareho sa imo utod nga si Aaron. ");
INSERT INTO hil_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Kay sang nagrebelde ang komunidad sang Israel sa akon didto sa tuburan sang kamingawan sang Zin, ginlapas ninyo ni Aaron ang akon sugo nga ipakita ang akon pagkabalaan sa katawhan.” (Ini nga tuburan amo ang Meriba Kadesh, sa kamingawan sang Zin.) ");
INSERT INTO hil_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Nagsiling si Moises sa Ginoo, ");
INSERT INTO hil_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“O Ginoo, Dios nga ginahalinan sang kabuhi sang tanan nga tawo, kabay pa nga magpili ka sang isa ka tawo nga magpangulo sa sini nga komunidad, ");
INSERT INTO hil_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","sa pagpanguna sa ila sa inaway, para ang imo komunidad indi mangin pareho sa mga karnero nga wala sing manugbantay.” ");
INSERT INTO hil_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Gani nagsiling ang Ginoo kay Moises, “Ipatawag si Josue nga anak ni Nun, nga ginagamhan sang Espiritu, kag itungtong ang imo kamot sa iya ulo sa pag-ordinar sa iya bilang pangulo. ");
INSERT INTO hil_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Patinduga siya sa atubangan ni Eleazar nga pari kag sa bilog nga komunidad, kag ipahibalo mo sa ila nga ginpili mo siya nga magbulos sa imo. ");
INSERT INTO hil_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ihatag sa iya ang iban mo nga awtoridad para tumanon siya sang bilog nga komunidad sang Israel. ");
INSERT INTO hil_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Kay Eleazar niya mahibaluan ang akon desisyon paagi sa paggamit ni Eleazar sang Urim sa akon presensya. Sa sini nga paagi matuytuyan ni Eleazar si Josue kag ang bilog nga komunidad sang Israel sa ila nga himuon.” ");
INSERT INTO hil_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Ginhimo ni Moises ang ginsugo sa iya sang Ginoo. Ginpatawag niya si Josue kag ginpatindog sa atubangan ni Eleazar nga pari kag sang bilog nga komunidad. ");
INSERT INTO hil_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Kag suno sa ginsugo sa iya sang Ginoo, gintungtong niya ang iya mga kamot kay Josue kag ginpahibalo nga si Josue ang magabulos sa iya. ");
INSERT INTO hil_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Silinga ang mga Israelinhon nga kinahanglan maghalad sila sa akon sang mga halad nga paagi sa kalayo sa natalana nga tion. Ini nga mga halad amo ang akon pagkaon, kag ang kahamot sini makapalipay sa akon. Gani ihambal ini sa mga Israelinhon: ");
INSERT INTO hil_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Amo ini ang mga halad nga paagi sa kalayo nga inyo ihalad sa Ginoo: duha ka karnero nga isa ka tuig ang edad kag wala sing deperensya. Ihalad ninyo ini permi kada adlaw bilang halad nga ginasunog. ");
INSERT INTO hil_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ang isa ihalad sa aga kag ang isa sa hapon, ");
INSERT INTO hil_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","lakip ang halad nga regalo nga duha ka kilo nga harina nga maayo nga klase kag ginmikslahan sang isa ka litro nga mantika nga halin sa olibo nga ginbayo. ");
INSERT INTO hil_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Amo ini ang pang-adlaw-adlaw nga halad nga inyo sunugon, nga ginsugo sadto sang Ginoo sa inyo sa Bukid sang Sinai. Ang kahamot sini nga halad nga paagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Ang halad nga ilimnon nga ilakip sa kada karnero, mga isa ka litro nga bino, kag ibubo ini sa balaan nga lugar para sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Amo man ang inyo himuon sa ikaduha nga karnero nga ihalad ninyo sa hapon. Lakipan man ninyo ini sang halad nga regalo kag halad nga ilimnon. Halad ini nga paagi sa kalayo, kag ang kahamot sini makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Sa Adlaw nga Inugpahuway, maghalad kamo sang duha ka karnero nga isa ka tuig ang edad kag wala sing deperensya, lakip ang halad nga ilimnon kag ang halad nga regalo nga apat ka kilo nga harina nga maayo nga klase kag ginmikslahan sang mantika. ");
INSERT INTO hil_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Amo ini ang halad nga ginasunog kada Adlaw nga Inugpahuway, wala labot sa pang-adlaw-adlaw nga halad lakip ang iya sini nga halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Sa kada nahauna nga adlaw sang bulan maghalad kamo sa Ginoo sang halad nga ginasunog. Ang inyo ihalad duha ka bataon nga baka, isa ka gulang nga karnero nga lalaki, kag pito ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Ini tanan kinahanglan wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","13","Lakipan ninyo ini sang halad nga regalo nga maayo nga klase nga harina kag ginmikslahan sang mantika—anom ka kilo sa kada bataon nga baka, apat ka kilo sa gulang nga karnero, kag duha ka kilo sa kada bataon nga karnero. Mga halad ini nga ginasunog, kag ang kahamot sini nga mga halad nga paagi sa kalayo makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ang kada bataon nga baka lakipan sang halad nga ilimnon nga duha ka litro nga bino. Ang gulang nga karnero lakipan sang isa kag tunga ka litro nga bino. Kag ang kada bataon nga karnero lakipan sang isa ka litro nga bino. Amo ini ang binulan nga halad nga ginasunog nga inyo pagahimuon sa kada umpisa sang bulan sa bilog nga tuig. ");
INSERT INTO hil_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Maghalad pa gid kamo sa Ginoo sang isa ka kanding nga lalaki bilang halad sa pagpakatinlo. Himuon ninyo ini wala labot sang pang-adlaw-adlaw nga halad nga ginasunog kag sa iya sini nga halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Saulugon ninyo ang Piesta sang Paglabay sang Anghel sa ika-14 nga adlaw sang nahauna nga bulan. ");
INSERT INTO hil_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Pagkasunod nga adlaw magasugod ang pito ka adlaw nga piesta. Kag sa sulod sang pito ka adlaw indi kamo magkaon sang tinapay nga may inugpahabok. ");
INSERT INTO hil_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Sa nahauna nga adlaw sang sini nga piesta, indi kamo mag-obra kundi magtipon kamo sa pagsimba sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Maghalad kamo sa Ginoo sang halad nga paagi sa kalayo. Ini nga halad nga ginasunog duha ka bataon nga baka, isa ka gulang nga karnero nga lalaki, kag pito ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Ini tanan kinahanglan wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Lakipan ninyo ini sang halad nga regalo nga maayo nga klase nga harina kag ginmikslahan sang mantika—anom ka kilo sa kada bataon nga baka, apat ka kilo sa gulang nga karnero ");
INSERT INTO hil_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","kag duha ka kilo sa kada bataon nga karnero. ");
INSERT INTO hil_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Maghalad man kamo sang isa ka lalaki nga kanding bilang halad sa pagpakatinlo para mapatawad kamo sa inyo mga sala. ");
INSERT INTO hil_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Ihalad ninyo ini nga mga halad wala labot sang pang-adlaw-adlaw nga halad nga ginasunog kada aga. ");
INSERT INTO hil_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Sa amo nga paagi ihalad ninyo ini nga mga halad nga paagi sa kalayo bilang pagkaon sang Ginoo. Himuon ninyo ini kada adlaw sa sulod sang pito ka adlaw. Ang kahamot sini nga mga halad makapalipay sa Ginoo. Ihalad ninyo ini wala labot sang pang-adlaw-adlaw nga halad nga ginasunog kag sang iya sini halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Sa ikapito nga adlaw, indi kamo liwat mag-obra kundi magtipon kamo sa pagsimba sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Sa nahauna nga adlaw sang Piesta sang Pag-ani, sa tion nga maghalad kamo sa Ginoo sang bag-o nga ani nga uyas, indi kamo mag-obra kundi magtipon kamo sa pagsimba sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Maghalad kamo sang halad nga ginasunog: duha ka bataon nga baka, isa ka gulang nga karnero nga lalaki, kag pito ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Ang kahamot sini nga mga halad makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Lakipan ninyo ini sang halad nga regalo nga maayo nga klase nga harina kag ginmikslahan sang mantika—anom ka kilo sa kada bataon nga baka, apat ka kilo sa gulang nga karnero, ");
INSERT INTO hil_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","kag duha ka kilo sa kada bataon nga karnero. ");
INSERT INTO hil_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Maghalad man kamo sang isa ka kanding nga lalaki para matubos kamo sa inyo mga sala. ");
INSERT INTO hil_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Ihalad ninyo ini upod sang ila mga halad nga ilimnon, wala labot sang pang-adlaw-adlaw nga halad nga ginasunog kag sang iya sini nga halad nga regalo. Kinahanglan nga ang mga sapat wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Sa nahauna nga adlaw sang ikapito nga bulan, indi kamo mag-obra kundi magtipon kamo sa pagsimba sa Ginoo. Sa sina nga adlaw patunugon ninyo ang mga trumpeta. ");
INSERT INTO hil_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Dayon maghalad kamo sang halad nga ginasunog nga ang kahamot sini makapalipay sa Ginoo: isa ka bataon nga baka, isa ka gulang nga karnero nga lalaki, kag pito ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Ini tanan kinahanglan wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Lakipan ninyo ini sang halad nga regalo nga maayo nga klase nga harina kag ginmikslahan sang mantika—anom ka kilo sa kada bataon nga baka, apat ka kilo sa gulang nga karnero, ");
INSERT INTO hil_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","kag duha ka kilo sa kada bataon nga karnero. ");
INSERT INTO hil_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Maghalad man kamo sang isa ka lalaki nga kanding bilang halad sa pagpakatinlo para matubos kamo sa inyo mga sala. ");
INSERT INTO hil_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Ihalad ninyo ini wala labot sang binulan kag pang-adlaw-adlaw nga mga halad nga ginasunog nga may upod nga mga halad nga regalo kag mga halad nga ilimnon. Mga halad ini nga paagi sa kalayo, kag ang kahamot sini makapalipay sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Sa ikanapulo nga adlaw sa sining ikapito nga bulan, magtipon kamo sa pagsimba sa Ginoo. Kinahanglan nga magpuasa kamo kag indi gid mag-obra. ");
INSERT INTO hil_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Dayon maghalad kamo sang mga halad nga ginasunog nga ang kahamot sini makapalipay sa Ginoo: isa ka bataon nga baka, isa ka gulang nga karnero nga lalaki, kag pito ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Ini tanan kinahanglan wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Lakipan ninyo ini sang halad nga regalo nga maayo nga klase nga harina kag ginmikslahan sang mantika—anom ka kilo sa kada bataon nga baka, apat ka kilo sa gulang nga karnero, ");
INSERT INTO hil_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","kag duha ka kilo sa kada bataon nga karnero. ");
INSERT INTO hil_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Maghalad man kamo sang isa ka lalaki nga kanding bilang halad sa pagpakatinlo, wala labot sa isa pa ka halad sa pagpakatinlo para matubos kamo sa inyo mga sala kag sa pang-adlaw-adlaw nga halad nga ginasunog nga may upod nga halad nga regalo, kag sa ila sini mga halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Sa ika-15 nga adlaw sa amo gihapon nga bulan, indi kamo mag-obra kundi magtipon naman kamo sa pagsimba sa Ginoo. Maghiwat kamo sang piesta para sa Ginoo sa sulod sang pito ka adlaw. ");
INSERT INTO hil_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Maghalad kamo sang halad nga ginasunog. Halad ini nga paagi sa kalayo nga ang kahamot makapalipay sa Ginoo. Sa nahauna nga adlaw amo ini ang inyo ihalad: 13 ka bataon nga baka, duha ka gulang nga karnero nga lalaki, kag 14 ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Ini tanan kinahanglan wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Lakipan ninyo ini sang halad nga regalo nga maayo nga klase nga harina kag ginmikslahan sang mantika—anom ka kilo sa kada bataon nga baka, apat ka kilo sa kada gulang nga karnero, ");
INSERT INTO hil_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","kag duha ka kilo sa kada bataon nga karnero. ");
INSERT INTO hil_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Maghalad man kamo sang isa ka lalaki nga kanding bilang halad sa pagpakatinlo, wala labot sang pang-adlaw-adlaw nga halad nga ginasunog nga may upod nga halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“Sa ikaduha nga adlaw sang piesta, amo ini ang inyo ihalad: dose ka bataon nga baka, duha ka gulang nga karnero nga lalaki, kag 14 ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Ini tanan kinahanglan wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Ang kada isa sini lakipan ninyo sang husto nga kadamuon sang halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Maghalad man kamo sang isa ka kanding nga lalaki bilang halad sa pagpakatinlo, wala labot sa pang-adlaw-adlaw nga halad nga ginasunog nga may upod nga halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“Sa ikatatlo nga adlaw sang piesta, amo ini ang inyo ihalad: onse ka bataon nga baka, duha ka gulang nga karnero nga lalaki, kag 14 ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Ini tanan kinahanglan wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Ang kada isa sini lakipan ninyo sang husto nga kadamuon sang halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Maghalad man kamo sang isa ka kanding nga lalaki bilang halad sa pagpakatinlo, wala labot sa pang-adlaw-adlaw nga halad nga ginasunog kag sang iya sini nga halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“Sa ikaapat nga adlaw sang piesta, amo ini ang inyo ihalad: napulo ka bataon nga baka, duha ka gulang nga karnero nga lalaki, kag 14 ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Ini tanan kinahanglan wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Ang kada isa sini lakipan ninyo sang husto nga kadamuon sang halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Maghalad man kamo sang isa ka kanding nga lalaki bilang halad sa pagpakatinlo, wala labot sa pang-adlaw-adlaw nga halad nga ginasunog nga may upod nga halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“Sa ikalima nga adlaw sang piesta, amo ini ang inyo ihalad: siyam ka bataon nga baka, duha ka gulang nga karnero nga lalaki, kag 14 ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Ini tanan kinahanglan wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Ang kada isa sini lakipan ninyo sang husto nga kadamuon sang halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Maghalad man kamo sang isa ka kanding nga lalaki bilang halad sa pagpakatinlo, wala labot sang pang-adlaw-adlaw nga halad nga ginasunog nga may upod nga halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“Sa ikaanom nga adlaw sang piesta, amo ini ang inyo ihalad: walo ka bataon nga baka, duha ka gulang nga karnero nga lalaki, kag 14 ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Ini tanan kinahanglan wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Ang kada isa sini lakipan ninyo sang husto nga kadamuon sang halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Maghalad man kamo sang isa ka kanding nga lalaki bilang halad sa pagpakatinlo, wala labot sang pang-adlaw-adlaw nga halad nga ginasunog nga may upod nga halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“Sa ikapito nga adlaw sang piesta, amo ini ang inyo ihalad: pito ka bataon nga baka, duha ka gulang nga karnero nga lalaki, kag 14 ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Ini tanan kinahanglan wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Ang kada isa sini lakipan ninyo sang husto nga kadamuon sang halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Maghalad man kamo sang isa ka kanding nga lalaki bilang halad sa pagpakatinlo, wala labot sang pang-adlaw-adlaw nga halad nga ginasunog nga may upod nga halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“Sa ikawalo nga adlaw, indi kamo mag-obra kundi magtipon kamo sa pagsimba sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Maghalad kamo sang halad nga ginasunog. Halad ini nga paagi sa kalayo nga ang kahamot makapalipay sa Ginoo: isa ka bataon nga baka, isa ka gulang nga karnero nga lalaki kag pito ka bataon nga karnero nga lalaki nga isa ka tuig ang edad. Ini tanan kinahanglan wala sing deperensya. ");
INSERT INTO hil_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Ang kada isa sini lakipan ninyo sang husto nga kadamuon sang halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Maghalad man kamo sang isa ka kanding nga lalaki bilang halad sa pagpakatinlo, wala labot sang pang-adlaw-adlaw nga halad nga ginasunog nga may upod nga halad nga regalo kag halad nga ilimnon. ");
INSERT INTO hil_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“Wala labot sang inyo mga halad sa pagtuman sang inyo panaad kag mga halad nga kinabubut-on, maghalad man kamo sa Ginoo sa natalana nga mga piesta sang sini nga mga halad: mga halad nga ginasunog, mga halad nga regalo, mga halad nga ilimnon, kag mga halad nga para sa maayo nga relasyon.” ");
INSERT INTO hil_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Ginsiling ini tanan ni Moises sa mga Israelinhon suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Nagsiling si Moises sa mga pangulo sang mga tribo sang Israel, “Amo ini ang mga sugo sang Ginoo: ");
INSERT INTO hil_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Kon ang isa ka lalaki magpanaad ukon magsumpa sa Ginoo nga himuon niya ukon indi ang isa ka butang, kinahanglan nga tumanon gid niya ang tanan niya nga ginsiling. ");
INSERT INTO hil_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Kon ang isa ka bataon nga babayi nga nagaestar gihapon sa panimalay sang iya amay magpanaad ukon magsumpa sa Ginoo nga himuon niya ukon indi ang isa ka butang, ");
INSERT INTO hil_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","kag mahibaluan ini sang iya amay pero indi siya magpamalabag, kinahanglan tumanon niya ini. ");
INSERT INTO hil_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Pero kon magpamalabag ang iya amay pagkahibalo niya sini, indi kinahanglan nga tumanon niya. Patawaron siya sang Ginoo kay nagpamalabag ang iya amay. ");
INSERT INTO hil_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Halimbawa, ang isa ka bataon nga babayi magpanaad ukon magsumpa nga himuon niya ukon indi ang isa ka butang, kag sang ulihi magpamana siya. Bisan padasodaso man ukon indi ang iya pagpromisa, ");
INSERT INTO hil_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","kon mahibaluan ini sang iya bana pero ang iya bana indi magpamalabag, kinahanglan nga tumanon niya ini. ");
INSERT INTO hil_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Pero kon magpamalabag ang iya bana pagkahibalo niya sini, indi kinahanglan nga tumanon niya, bisan padasodaso man ini ukon indi, kag patawaron siya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Kon ang isa ka babayi nga balo ukon babayi nga ginbulagan sang iya bana magpanaad ukon magsumpa nga himuon niya ukon indi ang isa ka butang, kinahanglan nga tumanon gid niya ini. ");
INSERT INTO hil_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Kon ang isa ka babayi nga may bana magpanaad ukon magsumpa nga himuon niya ukon indi ang isa ka butang, ");
INSERT INTO hil_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","kag mahibaluan ini sang iya bana pero maghipos lang siya kag indi magpamalabag, kinahanglan nga tumanon niya ini. ");
INSERT INTO hil_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Pero kon magpamalabag ang iya bana pagkahibalo niya sini, indi kinahanglan nga tumanon niya. Patawaron siya sang Ginoo kay nagpamalabag ang iya bana. ");
INSERT INTO hil_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Gani ang iya bana may kinamatarong sa pagtugot ukon pagbaliwala sang bisan ano nga iya ginsaad ukon ginsumpa. ");
INSERT INTO hil_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Pero kon wala magpamalabag ang iya bana sa sina mismo nga adlaw nga nahibaluan niya ini, nagatugot ang iya bana nga tumanon niya ini. ");
INSERT INTO hil_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Pero kon ginpaligad pa sang iya bana ang pila ka adlaw antes magpamalabag, ang iya bana ang silutan sa iya sala.” ");
INSERT INTO hil_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Amo ini ang mga pagsulundan nga ginhatag sang Ginoo kay Moises parte sa bana kag sa iya asawa, kag parte sa amay kag sa iya bataon nga anak nga babayi nga nagaestar pa sa iya panimalay. ");
INSERT INTO hil_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Balusi ang mga Midianhon tungod sang ila ginhimo sa mga Israelinhon. Pagkatapos mo nga mahimo ina, mapatay ka na.” ");
INSERT INTO hil_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Gani nagsiling si Moises sa mga tawo, “Magpreparar ang iban sa inyo sa pagpakig-away sa mga Midianhon kay gusto sang Ginoo nga balusan ta ang mga Midianhon. ");
INSERT INTO hil_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Ang kada tribo magpadala sang 1,000 ka tawo sa inaway.” ");
INSERT INTO hil_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Gani 12,000 ka tawo nga naghalin sa dose ka tribo sang Israel ang nagpreparar para sa inaway. ");
INSERT INTO hil_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Ginpadala sila ni Moises sa inaway, 1,000 halin sa kada tribo, nga ginapanguluhan ni Finehas nga anak ni Eleazar nga pari. Nagdala si Finehas sang mga kagamitan halin sa balaan nga Tolda kag mga trumpeta para sa pagpaandam. ");
INSERT INTO hil_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Nagpakig-away sila sa mga Midianhon, suno sa ginsugo sang Ginoo kay Moises kag ginpamatay nila ang tanan nga lalaki. ");
INSERT INTO hil_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Lakip sa ginpamatay nila amo ang lima ka hari sang Midian nga sila ni Evi, Rekem, Zur, Hur, kag Reba. Ginpatay man nila si Balaam nga anak ni Beor paagi sa espada. ");
INSERT INTO hil_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Ginbihag nila ang mga Midianhon nga mga babayi kag mga bata, kag ginpanguha nila ang ila mga kasapatan kag mga pagkabutang. ");
INSERT INTO hil_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Ginpangsunog nila ang tanan nga banwa pati ang tanan nga kampo sang mga Midianhon. ");
INSERT INTO hil_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ginpangdala nila ang tanan nga ila naagaw, pati mga tawo kag mga sapat, ");
INSERT INTO hil_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","kay Moises, kay Eleazar nga pari, kag sa komunidad sang Israel didto sa ila kampo sa kapatagan sang Moab, sa higad sang Jordan malapit sa Jerico. ");
INSERT INTO hil_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Ginsugata sila ni Moises, ni Eleazar nga pari, kag sang mga pangulo sang komunidad sang Israel sa guwa sang kampo. ");
INSERT INTO hil_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Naakig si Moises sa mga opisyal sang mga soldado nga naghalin sa inaway. ");
INSERT INTO hil_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Nagsiling si Moises sa ila, “Ngaa wala ninyo pagpamatya ang mga babayi? ");
INSERT INTO hil_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Sila ang mga nagsunod sa laygay ni Balaam sa pagganyat sa mga Israelinhon sa pagsikway sa Ginoo didto sa Peor, kag tungod sini nag-abot ang kahalitan sa komunidad sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Gani pamatya ninyo ang tanan nga bata nga lalaki, kag ang tanan nga babayi nga nakaagi hulid sa lalaki. ");
INSERT INTO hil_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Pero ibilin ninyo para sa inyo ang mga babayi nga wala pa nakaagi hulid sa lalaki. ");
INSERT INTO hil_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Ang tanan sa inyo nga nakapatay ukon nakatandog sang patay kinahanglan nga magpabilin sa guwa sang kampo sa sulod sang pito ka adlaw. Sa ikatatlo kag sa ikapito nga adlaw, kinahanglan nga magpakatinlo kamo kag ang inyo mga bihag. ");
INSERT INTO hil_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Tinlui ninyo ang tanan ninyo nga bayo, pati ang tanan ninyo nga kagamitan nga hinimo halin sa panit ukon sa balahibo sang kanding ukon sa kahoy.” ");
INSERT INTO hil_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Dayon nagsiling si Eleazar nga pari sa mga soldado nga nagkadto sa inaway, “Amo ini ang mga pagsulundan sang kasuguan nga ginhatag sang Ginoo kay Moises: ");
INSERT INTO hil_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","Ang bisan ano nga butang nga indi masunog pareho sang bulawan, pilak, saway, salsalon, lata, ukon tingga kinahanglan nga inyo ibutang sa kalayo, para mangin matinlo ini. Pagkatapos hugasan ini sang tubig nga ginagamit sa pagpakatinlo. Ang bisan ano nga indi masunog hugasan lang sang sini nga tubig. ");
INSERT INTO hil_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Sa ikapito nga adlaw, kinahanglan nga labhan ninyo ang inyo mga bayo, kag dayon kabigon na kamo nga matinlo, kag makasulod na kamo sa kampo.” ");
INSERT INTO hil_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Nagsiling ang Ginoo kay Moises, ");
INSERT INTO hil_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Isipa ninyo ni Eleazar nga pari kag sang mga pangulo sang mga pamilya sang komunidad ang tanan nga tawo kag sapat nga nabihag. ");
INSERT INTO hil_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Tungaon ninyo ini sa mga soldado nga nagpakig-away kag sa komunidad. ");
INSERT INTO hil_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Halin sa parte sang mga soldado, magpain ka para sa Ginoo sang isa sa kada 500 nga mga bihag, tawo man ukon baka, donkey, karnero, ukon kanding. ");
INSERT INTO hil_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Ihatag mo ini kay Eleazar nga pari bilang parte sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Halin sa parte sang mga Israelinhon, magpain ka sang isa sa kada 50 ka bihag, tawo man ukon baka, donkey, karnero, kanding ukon iban nga mga sapat. Ihatag ini sa mga Levita nga amo ang responsable sa pag-atipan sang Tolda sang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Gani ginhimo ni Moises kag ni Eleazar nga pari ang ginsugo sang Ginoo kay Moises. ");
INSERT INTO hil_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","35","Amo ini ang nakuha sang mga soldado sa inaway: 675,000 ka karnero, 72,000 ka baka, 61,000 ka donkey, kag 32,000 ka babayi nga wala nakaagi hulid sa lalaki. ");
INSERT INTO hil_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","40","Amo ini ang katunga nga parte sang mga soldado nga nagpakig-away: 337,500 ka karnero, nga ang 675 sini ginhatag para sa Ginoo, 36,000 ka baka, nga ang 72 sini ginhatag para sa Ginoo, 30,500 ka donkey, nga ang 61 sini ginhatag para sa Ginoo, kag 16,000 ka babayi, nga ang 32 sini ginhatag para sa Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Ginhatag ni Moises kay Eleazar nga pari ang parte sang Ginoo suno sa ginsugo sa iya sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","46","Amo ini ang parte sang mga Israelinhon nga ginhatag sa ila ni Moises, nga katunga sang parte sang mga soldado nga nagpakig-away: 337,500 ka karnero, 36,000 ka baka, 30,500 ka donkey, kag 16,000 ka babayi. ");
INSERT INTO hil_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Halin sa sining parte sang mga Israelinhon, nagpain si Moises sang isa sa kada 50 ka tawo ukon sapat suno sa ginsugo sang Ginoo sa iya. Kag ginhatag niya ini sa mga Levita nga amo ang responsable sa pag-atipan sang Tolda sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Dayon nagkadto kay Moises ang mga opisyal sang mga soldado ");
INSERT INTO hil_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","kag nagsiling sa iya, “Sir, gin-isip namon ang mga soldado nga sakop namon kag wala gid sing bisan isa nga kulang. ");
INSERT INTO hil_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Gani ginahalad namon sa Ginoo ang bulawan nga mga butang nga amon nakuha sa inaway—mga pulseras sa butkon kag sa kamot, mga singsing, mga aritos, kag mga kulintas, para makalikaw kami sa silot sang Ginoo.” ");
INSERT INTO hil_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Ginbaton ni Moises kag ni Eleazar ining tanan nga bulawan nga mga alahas. ");
INSERT INTO hil_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Ang kabug-aton sang sini nga mga bulawan nga gindala sang mga opisyal sang mga soldado, nga ginhalad ni Moises kag ni Eleazar sa Ginoo, mga 200 ka kilo. ");
INSERT INTO hil_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Halin ini sa mga nakuha sang tagsa ka soldado sa inaway. ");
INSERT INTO hil_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Pagkabaton ni Moises kag ni Eleazar sang mga bulawan halin sa mga opisyal, gindala nila ini sa Tolda nga Ginapakigkitaan para dumdumon sang Ginoo ang mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Ang mga tribo ni Reuben kag ni Gad may madamo gid nga mga kasapatan. Gani pagkakita nila nga ang duta sang Jazer kag Gilead maayo nga lugar para sa mga kasapatan, ");
INSERT INTO hil_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","nagkadto sila kay Moises, Eleazar, kag sa mga pangulo sang komunidad sang Israel kag nagsiling, ");
INSERT INTO hil_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Ang Atarot, Dibon, Jazer, Nimra, Heshbon, Eleale, Sebam, Nebo, kag Beon— ");
INSERT INTO hil_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ang mga lugar nga ginlaglag sang Ginoo paagi sa mga Israelinhon—maayo nga lugar para sa mga kasapatan, kag kami madamo sang kasapatan. ");
INSERT INTO hil_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Gani kon nalipay ka sa amon, sir, ihatag ini nga mga duta sa amon bilang amon parte. Indi kami pagpaestara sa tabok sang Suba sang Jordan.” ");
INSERT INTO hil_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Nagsiling si Moises sa mga tribo ni Gad kag ni Reuben, “Ano ang buot ninyo silingon, mapabilin lang kamo diri samtang ang inyo kapareho nga mga Israelinhon magkadto sa inaway? ");
INSERT INTO hil_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Ginapalas-ay lang ninyo ang mga Israelinhon sa pagkadto sa duta nga ginhatag sang Ginoo sa ila. ");
INSERT INTO hil_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Amo man ini ang ginhimo sadto sang inyo mga katigulangan sang ginpadala ko sila halin sa Kadesh Barnea sa pagtan-aw sang sini nga duta. ");
INSERT INTO hil_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Sang nakaabot sila sa Eshcol nga ililigan sang tubig kag nakita nila ang duta, ginpalas-ay nila ang mga Israelinhon sa pagkadto sa duta nga ginhatag sang Ginoo sa ila. ");
INSERT INTO hil_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Puwerte gid ang kaakig sang Ginoo sadto nga adlaw kag nagsumpa siya: ");
INSERT INTO hil_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Tungod kay wala sila nagsunod sa akon sing tinagipusuon, wala sing bisan isa sa ila nga nagaedad sing 20 ka tuig paibabaw nga naghalin sa Egypt nga makakita sang duta nga ginpromisa ko kay Abraham, Isaac kag Jacob ");
INSERT INTO hil_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","luwas lang kay Caleb nga anak ni Jefune nga Keniznon kag kay Josue nga anak ni Nun, kay nagsunod sila sa akon sing tinagipusuon.’ ");
INSERT INTO hil_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Puwerte ang kaakig sang Ginoo sa mga Israelinhon. Gani ginpatalang-talang niya sila sa kamingawan sa sulod sang 40 ka tuig, hasta nga nagkalamatay atong bilog nga henerasyon nga naghimo sang malain sa iya panulok. ");
INSERT INTO hil_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Kag karon, kamo nga mga kaliwat sang mga makasasala amo naman ang nagbulos sa inyo mga katigulangan kag ginadugangan pa gid ninyo ang kaakig sang Ginoo sa mga Israelinhon. ");
INSERT INTO hil_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Kon indi kamo magsunod sa Ginoo pabay-an niya liwat ini nga katawhan diri sa kamingawan, kag kamo ang mangin kabangdanan sang ila kalaglagan.” ");
INSERT INTO hil_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Pero nagpalapit pa sila kay Moises kag nagsiling, “Mahimo lang kami diri sang mga toril para sa amon mga kasapatan, kag mga banwa para sa amon mga kababayihan kag kabataan. ");
INSERT INTO hil_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Pero handa kami sa pagpanguna sa amon kapareho nga mga Israelinhon sa pagpakig-away hasta nga madala namon sila sa ila mga lugar. Samtang nagapakig-away kami, diri lang ang amon mga kababayihan kag kabataan mag-estar sa napaderan nga mga banwa para hilway sila sa mga pumuluyo sang sini nga duta. ");
INSERT INTO hil_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Indi kami magpuli hasta nga ang tanan nga Israelinhon makabaton sang duta nga ila palanublion. ");
INSERT INTO hil_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Pero indi namon gusto nga makabaton sang duta upod sa ila sa tabok sang Jordan. Kay ang duta diri sa east sang Jordan amo ang amon palanublion.” ");
INSERT INTO hil_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Nagsiling si Moises sa ila, “Kon desidido gid man kamo sa atubangan sang Ginoo nga mag-upod sa inaway, ");
INSERT INTO hil_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","kag magtabok ang tanan ninyo nga soldado sa Jordan hasta nga matabog sang Ginoo ang iya mga kaaway, ");
INSERT INTO hil_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","kag mapanag-iyahan ang duta, ti, puwede na kamo makabalik diri kay natuman na ninyo ang inyo obligasyon sa Ginoo kag sa kapareho ninyo nga Israelinhon. Kag ini nga duta mangin inyo na sa atubangan sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Pero kon indi ninyo ini paghimuon, makasala kamo sa Ginoo, kag sigurado gid nga bayaran ninyo ang inyo sala. ");
INSERT INTO hil_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Sige, magtukod kamo sang mga banwa para sa inyo nga kababayihan kag mga kabataan, kag maghimo sang mga toril para sa inyo mga kasapatan, pero dapat tumanon ninyo ang inyo ginpromisa.” ");
INSERT INTO hil_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Nagsabat ang mga tribo ni Gad kag ni Reuben kay Moises, “Sir, tumanon namon ang imo mga sugo. ");
INSERT INTO hil_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Magapabilin diri sa mga banwa sang Gilead ang amon mga asawa, mga kabataan, kag mga kasapatan. ");
INSERT INTO hil_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Pero kami ya nga makasarang sa pagpakig-away magatabok sa Jordan sa pagpakig-away suno sa sugo mo sa amon.” ");
INSERT INTO hil_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Gani nagmando si Moises kay Eleazar nga pari, kay Josue nga anak ni Nun, kag sa mga pangulo sang mga tribo sang Israel. ");
INSERT INTO hil_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Siling niya, “Kon desidido gid man sa atubangan sang Ginoo ang mga tribo ni Gad kag ni Reuben nga magtabok sa Jordan sa pagpakig-away, kag kon maagaw na ninyo ang amo nga duta, ihatag ninyo sa ila ang duta sang Gilead para ila panag-iyahan. ");
INSERT INTO hil_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Pero kon indi gani sila magtabok upod sa inyo, ti dapat magbaton sila sang duta upod sa inyo didto sa duta sang Canaan.” ");
INSERT INTO hil_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Nagsiling ang mga tribo ni Gad kag ni Reuben, “Sir, tumanon namon ang ginsiling sang Ginoo. ");
INSERT INTO hil_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Desidido kami sa atubangan sang Ginoo nga magtabok sa Jordan pakadto sa Canaan sa pagpakig-away, pero ang amon palanublion nga duta amo ining diri sa east sang Jordan.” ");
INSERT INTO hil_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Gani ginhatag ni Moises sa mga tribo ni Gad, ni Reuben, kag sa katunga sang tribo ni Manase nga anak ni Jose ang ginharian ni Sihon nga hari sang mga Amornon kag ang ginharian ni Og nga hari sang Bashan—ang bilog gid nga duta pati ang mga banwa kag mga teritoryo sa palibot sini. ");
INSERT INTO hil_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gintukod liwat sang tribo ni Gad ang Dibon, Atarot, Aroer, ");
INSERT INTO hil_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrot Shofa