﻿USE sofia;
DROP TABLE IF EXISTS sofia.hegNTpo_vpl;
CREATE TABLE hegNTpo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hegNTpo_vpl WRITE;
INSERT INTO hegNTpo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Hmunan hesa ku Ama Lamtua Allah koet apan-dapa kua nol apan-kloma kia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Dedeng na, apan-kloma ki daid lo bii, nol totoang sa-saa lias muik in toma lo. In muki ki ui. Nol mitang-mames tunga-kabut papmesa. Ama Lamtua Koo niuꞌ ka lako-pait se ui la dapa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Hidi kon Ama Lamtua Allah tek noan, “Musti muik langa.” Tek hidi ela kon langa ka muki. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ngat langa na ela kon, Un dalen na kolo. Undeng asa man Un in koet ta, banan baktebes. Hidim Un sole-bating langa ka deng mitang nga, le mesa-mesam nol un oras. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Un noken langa ka noan ‘lelo’, nol mitang nga noan ‘duman’. Leol mesa la na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Hidim Ama Lamtua Allah tek pait noan, “Musti muik maan blo le soel bakisan ui la. Undeng na le muik ui ne dapa kua nol dale kia.” Tek hidi ela kon, ui na bating dua meman. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Hidim Un ngali maan blo in se dapa kua ka noan ‘apan’. Leol dua la na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Hidim Ama Lamtua Allah tek pait noan, “Ui in ne dale kia ka musti nakbua se mana mesa, le halin nam muik tuu.” Tek hidi ela kon tuu ka daid meman. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kon tuu ka, Un ngali ngala ‘dael tuu’; nol ui in nakbua ka, Un ngali ngala ‘tasi’. Net nas totoang kon, Un dalen kolo, lole asa man Un in dake ka meman banan baktebes. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Hidi kon Ama Lamtua Allah tek pait noan, “Tuu ka musti puting sa-saa in nupu. Sa-saa in nupung nas musti puting isin, muik beas, nol klehen kunis. Mesa-mesam puting un isin na muid un tuladang nga.” Tek hidi ela kon sa-saa man in nupung nas dadi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Se tuu kia, kai in nupung nas puting oen isin nas mesa-mesa, muid oen tuladang nga. Ngat net nas totoang kon, Un dalen na kolo, undeng asa man Un in koet tas meman banan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Leol tilu la na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Hidi kon Ama Lamtua Allah tek pait noan, “Se dapa kua, musti muik sa-saa in langa bili-ngala le halin laang apan-kloma kia. Musti muik in puting bel langa se oras lelo, ela kon, musti muik in puting bel langa se oras duman. Oen nas totoang daid tada le halin nam haup in kaih oras, lelon, bulan, nol taun nas.” Tek hidi ela kon, totoang sa-saa langang nas dadis meman. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Hidi kon Un koet sa-saa dua man puting nal langa tene. In tene dui ka, bel langa se oras lelo, mo in ana dui ka, bel langa se oras duman. Un kon koet duun-duun nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Un koet sa-saa nas se apan-dapa kua, le halin nam oen bel langa maa se apan-kloma kia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ta lelo la bel langa se oras lelo, nol bulan-duun nas bel langa se oras duman. Nini ela, oen sis bakisan langa ka deng mitang nga. Net totoang nas kon, Un dalen na kolo, undeng asa man Un koet son nas meman banan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Leol aat ta na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Hidi kon Ama Lamtua Allah tek pait noan, “Musti muik hmukit nol ikan bili-ngala, le nuil se ui dale. Nol musti muik kee bili-ngala man honga-hong se apan-kloma kia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Hidim Un koet totoang ikan nol hmukit tene man in nuil se ui dalen nas. Un kon koet totoang kee-tilu in hong se apan-dapa kua ngas. Ngat net nas totoang kon, Un dalen kolo, undeng asa man Un in koet son nas meman banan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Hidim Un aa le bel hangun se totoang in nuling nas noan, “Ikan-ikan nas totoang musti taplaeng mamo le tao inu ui la. Nol kee-tilu kas kon musti mamo taplaeng.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Leol lima la na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Hidim Ama Lamtua Allah tek pait noan, “Musti muik hmukit bili-ngala nuil se tuu kia. Nas hmukit in moang, hmukit huin nol hmukit in lool deng dale-dapa, memesam nonool un hnika-tuladang.” Tek ela hidi kon, totoang hmukit nas dadis. Ngat nas totoang kon, Un dalen na kolo, undeng asa man Un in koet son nas meman banan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Hidi nam Ama Lamtua Allah tek pait noan, “Maa le kit koet atuli li muid Kit hnika-tuladang ngia. Le halin oen man ator ikan-ikan in ne tasi kua ngas, totoang kee-tilu in ne apan-dapa kua ngas, totoang hmukit in moang ngas, nol totoang hmukit didang man in nuil se apan-kloma kia ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kon Un koet atuli li muid Un hnika-tuladang nga. Un koet one, bihata nol biklobe. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Hidim Un aa le beles hangun noan, “Mi musti hua-koet mamo-mamo, le inu apan-kloma kia, halin mi man mana-koet apan-kloma kia. Auk kon bel mi hak le mana-koet ikan-ikan, kee-tilu, nol totoang hmukit in se tuu dapa ki ngias. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Hii babanan ne! Auk bel mi kakaat bili-ngala se apan-kloma kia. Nas in mula-hai man muik isin, tamlom beas, tamlom in muik klehen kunis sas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Auk kon bel totoang in mula-hai bili-ngala, le halin daid kakaat taung hmukit tas. Muik in kaa le bel hmukit in moang ngas, hmukit huin nas, hmukit in lolo ngas, nol kee-tilu kas kon.” Aa hidi ela kon, totoang in kaa bili-ngala ngas muik meman. ");
INSERT INTO hegNTpo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ngat nas totoang kon, Un dalen na kolo, undeng asa man Un in koet son nas meman banan isi baktebes. Leol eneng nga na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Nini ela, Ama Lamtua Allah koet nal apan-dapa kua, nol apan-kloma kia, nonool un isin nas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Un koet hidis totoang, kon ola ka tom nol leol itu la, Un tene. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nini ela, leol itu la daid leol in tene dui, deng lelo-leol tenga las. Un ator ela meman, le eta Un koet hidis totoang son nam, Un tene se leol itu la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_4a","002_2_4a","GEN","2","4a","4a","Ama Lamtua Allah in koet apan-dapa kua nol apan-kloma kia ka, un dehet ta ela. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_4b","002_2_4b","GEN","2","4b","4b","Dedeng AMA LAMTUA Allah halas-sam mana le koet apan-dapa ku nol apan-kloma kia ka, ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","muik kai ina in nuli lo, undeng Un niung ulan lo bii. Dedeng na suma muik salbuta man puti deng dale kia, le tao ngoe apan-kloma kia. Nol muik atuli in daek klapa lo bii. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Hidi kon AMA LAMTUA Allah kat nal dale bubuit, le daken daid atuli. Hidim Un huu tamang hngasa laok se atuling na deng ilu ka, kon un nuli meman. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Hidi nam, AMA LAMTUA Allah daek klapa mesa se dale Eden, se halin leol saken. Hidim Un bel atuling na le daad se klaap na dale. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Se klaap na, Un mul kai ina banan mamo-mamo son, man atuli li bisa kaa oen isin man fala banan nas. Un kon mul kai ina dua man hnika ngas bakisan se klaap na hlala ka. Eta atuli li kaa kai ina mesan na isin na lam, un haup in nuli napiut. Mo eta atuli li kaa deng kai isin mesan na lam, un taan nal ol man banan nol ol man daat ta. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Muik palun mesa man baa puti deng klaap na. Palun na baa fanga aat. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Un fanga mesa la, ngala Pison. Fanga na baa keo papmes dale Hawila, man muik lil-mea mamo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Se na muik lil-mea isin, muik kai ina man uin na bui bingis, nol muik baut kaloeꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Palun na fanga dua la, ngala Gihon. Fanga na baa keo papmes dale Kus. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Un fanga tilu la, ngala Tigris. Fanga ni daid toon, deng dale Asyur halin leol-saken. Un fanga aat ta, ngala Efrat. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ama Lamtua Allah bel atuling na daad se Eden le doha-tinang klaap na babanan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Hidim Un hid atuling na noan, “Ku boel kaa kai isin saa tuun deng totoang kai ina in se klaap ni dalen nias. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Mo muik kai ina mesa, man ku boel kaa isin na lo. Na kai ina in tek puting ol man banan nol ol man daat ta. Eta ku kaan nam taon elola ko ku mate.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Hidi nam AMA LAMTUA Allah aa pait noan, “Eta atuling ni sii nuli sii-siing ngam banan lo. Tiata Auk le daek belen tapa mesa, man tatai nol una.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Dedeng na, AMA LAMTUA Allah dauk dale, le daek hmukit ti beas bakun, nol tilu-kee kas. Hidim Un kil nol hmukit tas nol tilu-kee nas laok bel atuling na, le halin nam un ngali oen ngalan nas. Kon nam atuling na ngali hmukit tas nol tilu-kee nas, mesa-mesam nol un ngala. Mo un esa haup tapa, man tom nol una lo bii. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Hidi kon AMA LAMTUA Allah tao atuling na le un niin nala. Nikit un niin nala kon, Ama Lamtua kat un seen blapas sas mesa, hidim kulis tema papa la pait. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Deng seen na, Un daken daid bihata mesa. Hidim Un tapa bihatang na lako bel atuling nga. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Net bihatang na kon, atuling nga tek noan, “Eli le! Ni halas-sam tom nol au! Un seen na banansila el auk seen ni kon. Nol un sisin na kon banansila el auk sising ngia. Undeng un daid deng biklobe lia, tiata auk ngali un ngala ka noan ‘bihata’.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Undeng na, biklobe li musti nang un ina-aman nas, le lako nuil koo-dalen mes nol un sapa-bihatan na, ta oen duas butu-kil apa daid mes son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Dedeng na, oen duas lulit, mo oen duas nataka taan in mae ki lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Totoang hmukit man AMA LAMTUA Allah in koet son se apan-kloma kia ngas, ula la man taan in nole-lilung dui. Oe mesan na, ula la keket bihatang nga noan, “Baktebes Ama Lamtua Allah kaing noan, ‘Mi boel kaa totoang kai isin in se klaap ni dalen nias lo, ta lo?’” ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Bihatang nga situn noan “Loo! Kaim boel kaas totoang! Mo muik kai ina mes sii man ne klaap ni hlala kia, man Ama Lamtua Allah kaing kaim le boel kaan lo. Un tek noan kaim boel kaan lo, nol boel sepo tom un isin na deken, ta lo kam kaim matem.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mo ula la siut noan, “Hoe, na tom lo! Mi matem lo! ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ama Lamtua Allah kaing ela, undeng Un taan meman son, le eta mi kaa kai na isin na lam, mi kon daid in tana el Un kon. Le taan ol man banan, nol ol man daat ta.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Hidim bihatang nga ngat tam, kai ina na banan isi, nol un isin na hnika el noan fala banan isi. Kon un nangan noan, “Eta auk kaa kai isin nia lam, taon elola ko auk daid in tana.” Tiata un nui kai isin na le kaan. Hidim un kil bel un sapa ka, tiata un sapa ka kon kaa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Kaa hidi kon nahkitu lam, oen taan noan, oen duas lulit. Tiata oen noot kai klehen le buba kele oen duas apan nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Lelo-hat kon, oen ming AMA LAMTUA Allah lako-pait se klaap na dalen. Tukun nam oen lakos hunis se kai ina mes peke, le halin nam AMA LAMTUA net oen deken. ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mo AMA LAMTUA Allah haman biklobeng nga noan, “Hoe! Adam, ku ne ola ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Biklobeng nga siut noan, “Auk ming Ama Lamtua fala ka. Mo auk mae, ta le auk lulit tam. Tiata auk lail huning.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Hidi kon Ama Lamtua tek noan, “Asii man tek noan ku lulit ta? Taon elola ko ku kaa kai isin man auk in kaing son na, ta lo?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Un siut noan, “Bihatang man Ama Lamtua in tapa bel au ka, man bel auk kai isin na le kaa!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Hidi kon AMA LAMTUA Allah ketan bihatang nga noan, “Amo tasao le ku tao ela lia?” Kon bihatang nga siut noan, “Le ula la man nole au lam! Tiata auk kaa kai isin na son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Hidi na kon, AMA LAMTUA Allah bahang ula la noan, “Undeng ku in tao nia, ta Auk hukung ku. Deng totoang hmukit tias, suma ku sii man tom in bahang. Deng leol neot nia didiin ku mate, ku suma lool nini ku taim ma tuun, nol ku in kaa ka dale. ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Auk tao ku nol bihatang ni le mi komali nol apa tutungus. Nol mi duam in hua-koet tas kon ela. Mam ku in hua-koet tas sau atuli li se oen iin baih ngungun nas. Mo mam un in hua-koet tas mes, tutu dudus ku bom ma.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Hidi nam Ama Lamtua Allah tek bihatang nga noan, “Mam Auk taplaeng ku in susa ka se oras ku in behe ka, nol taplaeng ili se oras ku in hua ka. Mo ela kon, ku kom isi nol ku sapa-biklobem ma tutungus. Nol un man ator ku.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Hidim Ama Lamtua Allah tek biklobeng nga noan, “Ku muid Auk in leka ka lo, mo muid ku sapam ma in koma ka, le kaa kai isin man Auk in kaing son na. Tiata ku kon tom in hukung. Nol dale ki kon tom in hukung. Deng neot nia lako pes ku mate, ku musti daek hiti-late le bali dale kia, halas-sam ku haup in kaa. Nol daek ela, halas-sam ku haup in nuli. ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ku soko-hai sa-saa tuun kon, dale ki suma puting bel ku duli nol kles tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Hidim ku musti daek hiti-late, halas-sam dale ki puting bel ku in kaa. Ku musti dake le lating baa ela, lako lius ku in mate ka. Auk daek nal ku deng dale kia, tiata eta ku mate kam, ku pait lako daid dale.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Hidi na kon, Adam ngali un sapa ka ngala ‘Hawa’ (man lin na tatai nol dais Ibranin man muik nahin noan ‘bel in nuli’), ta un na mo in deng totoang atuil lia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Hidim AMA LAMTUA Allah daek kai-baut nini hmukit bulang le beles duas halin pake. ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","AMA LAMTUA Allah tek noan, “Halas ni, atuil nias taan ol banan nol ol man daat ta son, banansila el Kita. Tiata tamlom oen kon kaa kai isin, deng kai ina man kil in nuli napiut ta la.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Hidim Un nulut puting oen deng klaap in se Eden na, le oen lakos se maan didang, le nuil nol in bali dale, halin oen nulis deng dale na in hapu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Nulut hidis kon, Ama Lamtua Allah tadu Un ima-ii in muik dilaꞌ deng sorga ngas, le laok doh klaap na halin leol-saken na. Oen kil suli in lalen lako-pait, man kaloe banansila el ai ka. Ama Lamtua tadu oen le hep tele lalan in taam laok bus el klapa la ka, undeng eta atuli nui kai isin man kil in nuli hidi nutus taan lo ka lam, Un kom lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Oe mesan na, Adam niin nakbuan nol un sapa, Hawa. Kon bihatang nga behe. Hidi kon un hua ana biklobe mesa. Un tek noan, “Auk hua nal tana-ana biklobeng mes son, undeng AMA LAMTUA man tulung au.” Hidim un ngali tana-ana na ngala, Kaen (nahin na noan ‘kat puting’). ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Hidi nam Hawa hua tana-ana biklobeng mes pait. Kon un ngali ngala, Habel. Dedeng oen duas tenes maas sa, Habel lolo-poa hmukit mo Kain daek klapa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Oe mesan na, Kain kil nol un klapa la in hapu ngas tenga, le bel AMA LAMTUA. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel kon kil un lae-blai heteng ngas ana hmunan nas. Un keo lae-blai nas, hidim un kil sisin man banan dui ngas le bel Ama Lamtua. Ngat net ela kon, AMA LAMTUA dalen kolo nol Habel in bele ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Mo Un kom Kain in bele ngas lo. Ta Kain koon-mali isi, didiin un sila ka mitang-tilu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Kon AMA LAMTUA aa nol Kain noan, “Hoe Kain! Tasao le ku komali isi ela lia? Taon elol le ku silam ma mitang-tilu ela lia? ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Eta ku daek banan nam, taon elola ko Auk sium ku nol babanan. Mo doha-doha! Eta ku daek dadaat tam, mam in daat na hai bali ku, banansila el luis in daek blaoh le holon tetema ka. Tiata eta ku kom le daek dadaat tam, banan dui ka ku hutun soleng meman tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Oe mesan na, Kain nusi Habel noan, “Adi! Maa le kit duat laok klapa lua.” Nikit oen lakos lius se uas kon, nahkitu lam Kain diuk tele un palin Habel. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Hidi kon AMA LAMTUA ketan Kain noan, “Hoe Kain! Ku palim ma ne ola ka?” Kain siut noan, “Eh, un ne ola kam, auk tanan lo! Bali le auk niam kil un iin na le!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kon Ama Lamtua tekan noan, “Tasao le ku daek dadaat isi ela lia? Ku bali noan ku buni nal ku palim ma dala ka se dale dale, le Auk netan loo ke? Auk net hidi totoang son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Halas ni bahang saek tom ku son. Ta dedeng ku keo tele ku palim ma ka, dale ka nus nuli un dala ka. Tiata halas ni dale ka, bel ku in nuli pait lo son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Eta ku daek klapa lam, dale ka puting bel ku isin saa pait lo ka. Ninin deng halas nia, ku tupu-talas lako-pait, banansila el atuil kasiang man nuting in nuli se apan-kloma kia ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Mo Kain labang nol AMA LAMTUA noan, “Idah! Ama Lamtua! Taon elol le Ama Lamtua bahang auk ngele isi eli lia? Auk lep nalan pait lo son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Undeng Ama Lamtua nulut auk deng maan ni son, tiata mam auk katang deng Ama Lamtua. Auk tupu-talas le lako-pait ela tukun. Hidim asii tukun man tutnaal nol au lam, taon elola ko oen keo tele au.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mo AMA LAMTUA siut bali noan, “Ela lo! Asii man keo tele ku lam, mam Auk in belen hukung nga ngele dui lalis itu.” Hidim AMA LAMTUA tao taad se Kain, halin nam atuli li tana, le keo tele un deken. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Hidi na kon, Kain lako nang maan na, le lako katang deng AMA LAMTUA. Un lako lius se mana mesa, se klaap Eden na halin leol-saken na. Maan na ngala Nod, man nahin na noan, ‘Tupu-talas’. Kon un daad se maan na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Hidi nam Kain sapa, kon un sapa ka behe. Ti un hua ana biklobe mesa, oen ngali ngala Henok. Kon Kain bangun ingu mesa. Hidim un ngali iung na ngala Henok, muid un ana ka ngala ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hidim Henok ana ka ngala Irad. Irad ana ka, Mehuyael. Mehuyael ana ka, Metusael. Nol Metusael ana ka, Lamek. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek saap nol bihata at dua. Mes ngala Ada, nol mesan na pait ngala Sila. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada ana ka ngala Yabal. Un in hua-koet tas daid atuil in lolo-poa hmukit. Oen nuil seda-seda se mana mamo, nol oen daad se hleep dales tukun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Un palin na, ngala Yubal. Yubal in hua-koet tas daid atuil in kuti taan sasanu, gitar, juk nol huu taan klingu nol oleꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamek sapa Sila, hua Tubal Kain. Un in hua-koet tas daid tukang bisi, tiata oen daek sa-saa bili-ngala deng bisi nol tungdadi nol bis-kunis. Tubal Kain palin bihata la, ngala Naama. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Oe mesan na, Lamek naka-naka apa ka se un sapan nas duas silan noan, “Mi duam hii ke! Apin tana-biklobeng mes keng nol au, mo auk tuk tele una. ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Atuil in keo tele Kain nas, haup in hukung lalis itu. Mo eta muik in le hatu-pukun nol au kam, oen haup hukung oe buk itu beas itu.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam sapa Hawa hua ana biklobe mes pait. Kon oen ngali tana-ana na, ngala Set (man nahin na noan, ‘tunang bele’). Undeng Hawa tek noan, “Ama Lamtua tunang bel auk tana-ana ni son, le seda Habel man Kain in keo tele son na.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Nesa-nesang kon Set haup ana biklobe mesa, ngala Enos. Lius dedeng na, halas-sam atuli las mulai todan-lahing se AMA LAMTUA Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Dedeng Lamtua Allah koet atuli lia ka, Un koet oen muid Un hnika-tuladang nga. Un koet one, bihata nol biklobe. Un noken oen noan ‘atuli’, hidim Un bel hangun se one. Atuling hmunan na, ngala Adam. Adam in hua-koet tas, ngalan nas elia: ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Dedeng Adam umur taun ngatus buk tiul kon, un haup ana biklobe mesa, man hnika-tuladang nga banansila el un kon. Kon un ngali tana-ana na, ngala Set. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Hidi nam, Adam nuli taplaeng pait taun 800, un kon haup taplaeng aan biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Dedeng un umur taun 930 halas-sam, un mate. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Dedeng Set umur taun 105, kon un haup ana biklobe mesa, ngala Enos. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Hidim Set nuli taplaeng pait taun 807, nol un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Dedeng un umur taun 912, halas-sam un mate. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Dedeng Enos umur taun buk sipa, kon un haup ana biklobe mesa, ngala Kenan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Hidim, Enos nuli taplaeng pait taun 815. Un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Dedeng un umur taun 905, halas-sam un mate. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Dedeng Kenan umur taun buk itu, kon un haup ana biklobe mesa, ngala Mahalalel. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Hidi nam, Kenan nuli taplaeng pait taun 840. Un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Un umur taun 910, halas-sam un mate. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Dedeng Mahalalel umur taun buk eneng beas lima, kon un haup ana biklobe mesa, ngala Yared. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Hidi nam, Mahalalel nuli taplaeng taun 830. Un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Dedeng un umur taun 895, halas-sam un mate. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Dedeng Yared umur taun 162, un haup ana biklobe mesa, ngala Henok. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Hidi nam, Yared nuli taplaeng pait taun 800, nol un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Dedeng un umur taun 962, halas-sam un mate. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Dedeng Henok umur taon buk eneng beas lima, kon un haup ana biklobe mesa, ngala Metusalak. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Hidi nam, Henok nuil koo-dalen mes nol Ama Lamtua Allah didiin taun 300 pait. Kon un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Un nuil koo-dalen mes napiut nol Ama Lamtua Allah. Dedeng un umur taun 365, kon un ilang le ase tuun ela, undeng Ama Lamtua Allah nikit sakeng un lako dapa kua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Dedeng Metusalak umur taun 187, kon un haup ana biklobe mesa, ngala Lamek. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Hidi nam, Metusalak nuli taplaeng pait taun 782. Un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Dedeng un umur taun 969, halas-sam un mate. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Dedeng Lamek umur taun 182, kon un haup ana biklobe mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek ngali tana-ana na, ngala Noh (man lin na tuladang el dais Ibranin mesa, nahin na noan, ‘halmui-halmau’), undeng un tek noan, “Mam tana-ana ni halmui-halmau kit le dalen kolo, deng kit in daek hiti-late se dale, man Ama Lamtua Allah in kutuk son nia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Hidi nam, Lamek nuli taplaeng pait taun 595. Un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Dedeng un umur taun 777, halas-sam un mate. ");
INSERT INTO hegNTpo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Dedeng Noh umur taun 500, kon un haup ana biklobe at tilu, ngalans Sem, Yafet nol Ham. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Dedeng na, atuli li mamo taplaeng. Hidim oen nuil his-hoeng lako pes ola-ola, se papmes apan-kloma kia. Oen kon hua nal ana-aan bihata mamo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ama Lamtua anan biklobe las ngat atuli li anan bihata las leko-leko sii. Kon oen laok saap nol tana-bihaat man oen in koma ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kon AMA LAMTUA tek noan, “Auk kaeng son nol atuli li in nuil le taan tula-peke lo nia. Auk Koo man bel oen le nulis sa, tade le beles in nuli napiut lo son. Oen musti mates. Tiata mam oen suma nulis pes taun ngatus buk dua siis.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Deng oras na, nol oras in mudi-muid apang nas, muik atuil man apa ka tene nol lapa isi se apan-kloma kia. Dedeng Ama Lamtua anan biklobe las saap nol atuli li anan bihata las sa, oen hua atuli-atuil in muun-tes. Nas tulu-tulu in hote-dati man ngalan nas lail se dehet hmunan hesa kua ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Dedeng na, AMA LAMTUA net atuli-atuil in se apan-kloma kia ngas in daek dadaat lai-lisin na son. Oen dalen nas suma taan in nangan daat si-sii. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Kon Ama Lamtua sabail apa, undeng Un koet nal oen son, le daad se apan-kloma kia. Ni man tao Ama Lamtua dalen iil isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Undeng na le Un aa noan, “Nini ela lam, Auk tao didaan atuli lia, man Auk koet nalas son se apan-kloma kia. Kee-tilu kas nol hmukit tenga las kon Auk tao dudus totoang. Ta Auk sabail apa ngi nol in koet one son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mo suma Noh sii, man tao AMA LAMTUA dalen koloꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noh dehet ta elia: Un anan biklobe las at tilu, ngalans Sem, Yafet nol Ham. Noh nam nuil lolo, un daek dadaat net lo. Dedeng na, suma un sii man banan. Un nuli dani nol Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Mo Ama Lamtua Allah ngat totoang atuil tenga las sam, daat totoang. Se ola-ol tuun kon, atuli li lalan in nuli ka daat lai-lisin son. Ama Lamtua Allah ngat atuil in se apan-kloma ki ngias sam, suma muik in daat sii. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kon Ama Lamtua Allah tek Noh noan, “Se ola-ola lam, Auk suma ngat net atuli li in daat ta tuun. Tiata Auk nutus son noan, Auk le tao didaa apan-kloma ki totoang nol un isin nas beas bakun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Tiata elia Noh! Nol ni kon, ku daek kapal tene mesa nini kai telas. Se kapal la dale, ku daek kamar-kamar. Hidim muang kapal la likun na, nini ter. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ku daek kapal na blatas sa, meter 133, blehan na meter buk dua beas dua, nol un lapa ka meter hngul tilu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tapa tihi laok se kapal la dapa. Mo bel tihi la, puti lail-liis steng meter deng tembok ka. Ku bating kapal la, daid hnoden tilu. Hidim tao hnita mes se kapal la blapas sa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nangan babanan ne! Mam Auk niung ui in baa tene deng dapa kua, le tao tele totoang in nuil se apan-kloma kia ngas, le didiin muik in lisi lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mo Auk le but in hida nol ku. Eta mam ku taam lako kapal la lam, leo-leo nol ku sapam ma, ku anam mas, nol ku nalem mas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ku musti laok kat hmukit apa mesa-mesa, deng hmukit tas totoang, le nol tamang lakos se kapal la dalen, halin nam oen nulis leo-leo nol ku. Kat hmukit in moang, kee-tilu, nol hmukit in lolo ngas, le halin mam oen nulis totoang kon. ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ku musti kil tamang in kaa bili-ngala laok se kapal la dale, le halin taung mi in kaa, nol taung hmukit tas kon.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Hidi kon Noh daek muid Ama Lamtua Allah in leka ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Hidi na kon, AMA LAMTUA aa nol Noh noan, “Noh! Auk ngat laok papmes se ola-ol son, mo suma ku sii man dalem ma lolo. Undeng na, ku nol ku sapa-anam mas taam lakom se kapal la dalen tia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Deng totoang hmukit man boel mi in kaang ngas, nol taom pake taung in kil le todan Au ngas, kil nolas tapa itu-itu lakos se kapal la dalen. Deng totoang kee-tilu bili-ngalang ngas kon, kil tapa itu-itu. Mo deng hmukit didang ngas sam, kil tapa mesa-mesa tuun. Nini ela lam, hmukit tas nol tilu-kee nas daid bini, le halin nam oen muik tutungus. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Nangan babanan ne! Ta naha lelo itu lam, Auk niung ulan tene, man teen tahan lo, lako pes dedeng buk aat lelo buk aat. Nini ela lam, Auk hukung tele totoang sa-saa in nuil se tuu dapa, man Auk in daek hidi son nas.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Hidi kon Noh daek muid AMA LAMTUA in leka ngas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Dedeng ulan tene ka in baa ka, Noh umur taun 600. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Hidim Noh nol un sapa ka, nol un anan nas, nol un nalen nas taam lakos kapal la dalen, le halin nam oen haup slamat deng ui tene ka in baa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Tao muid AMA LAMTUA in leka ka, Noh kil tamang hmukit bili-ngala nol kee-tilu, mesa-mesam nonool un tapa, deng totoang hmukit man atuli li boel kaan, tamlom atuli li boel in kaan lo ngas laok se kapal la dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Hidi nal lelo iut kon, ui la holbohon maa, le tung apan-kloma ki papmesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Tom nol dedeng na, Noh umur taun 600, bulan dua, lelo hngul itu kon, ulan tene ka maa! Dedeng na banansila el hnita apan nu holsai, le ui la holbohon niu maa. Nol ui mata ngas kon, lua putis. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Kon ulan na in nahu ka, tene taan lo lelo-duman, didiin lelo buk aat. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mo lelon na kon, Noh nol un sapa ka, nol un anan at tilu las Sem, Yafet nol Ham, nol un nalen nas totoang taam lakos kapal la dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Oen tamas leo-leo nol hmukit tas, nas hmukit in moang, hmukit huin, hmukit in lolo, tilu-kee nol totoang hmukit in muik dila ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","In nuli ngas totoang mesa-mesam nol oen tapan, oen taam lakos kapal la dalen, leo-leo nol Noh, banansila el Ama Lamtua Allah in lek una ka. Nikit oen tamas totoang son kon, AMA LAMTUA hkaen tele kapal la hnitan na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","19","Ulan tene na nauh napiut didiin lelo buk aat, kon ui saek lapa napiut didiin kapal la boe. Hidim ui la saek napiut didiin bua nal totoang leten lapa ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ui na saek napiut tene taan lo, didiin lihu ka meter iut deng leten in lapa dui ngas tula. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Nini ela, totoang sa-saa in nuil se tuu dapa ngias mates hidi. Atuli, hmukit in moang, hmukit huin, hmukit in lolo, nol tilu-kee kas mates hidi. Suma Noh nol totoang in se kapal la dalen nas siis man nulis. ");
INSERT INTO hegNTpo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ui na miti tahan lo, lako lius lelo ngatus buk lima. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Mo Ama Lamtua Allah nadidingun Noh nol totoang hmukit in se kapal la daleng ngas lo. Kon Un bel angin le huu ui tene na halin miti. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Un tung totoang ui mata in se dale-dapang ngias, nol Un tao ulan na le teen in nahu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Kon ui la niu buit-buit. Hidi lelo ngatus buk lim kon, ui la lihu isi lo son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tom nol bulan itu la, kuhit nal lelo hngul itu kon, kapal la sel se leten lapa mes dapa, ngala Ararat. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ui la niu napiut lako pes leol mesa, bulan hngulu la lam, leten nas tula ngas ngat tanas nol langa son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Kaliut nal lelo buk aat kon, Noh sai jendela kapal las mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Kon un sao kakalo mesa. Kakaol na hong lako-pait didiin ui tene na miti baktetebes. Mo un hong pait lako kapal la lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kon Noh sao tiul-tuan mes lolen, le halin taan noan ui la niu baktebes son tam lo bii ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mo undeng ui la bua papmes apan-kloma ki nabale, tiata tilu na haup maan in dada lo. Kon un hong pait lako kapal la. Ti Noh doong un ima ka le daek tamang tiul-tuan na pait lako kapal la dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noh natang lelo iut pait, halas-sam un sao tiul-tuan na pait. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Lelo-maun kon, tilu ka pait maa se Noh, un kil nol kai saitun klehen mesa, man halas-sam un lukut hidi. Kon nam Noh taan haup noan, ui la niu baktebes son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Un natang lelo iut pait kon, un sao tiul-tuan na pait lako. Mo pait na lam, tiul-tuan na pait lo son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Dedeng Noh umur taun 601, tom nol leol mesa bulan mesa, ui la miti baktetebes son. Kon Noh sai kapal la jendela las, hidim un ngat pukiu lam dale ka tuu son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Lius bulan dua la, leol buk dua beas itu ka lam, dale ka tuu baktetebes son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Hidi kon Ama Lamtua Allah tek Noh noan, ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Noh! Mi bisa nium totoang deng kapal ni tia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Sao puting totoang hmukit in moang, hmukit huin, hmukit in lolo, nol tilu-kee kas tia! Nang le oen totoang taplaeng mamo le halin tao inu apan-kloma kia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Hidi kon Noh nol un sapa ka, un anan nas, nol un nalen nas totoang, putis deng kapal la. Hmukit tas totoang kon putis, mesa-mesam nonool un tapans, le piut lakos. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Hidi kon Noh babail batu, le daid maan in todan taung AMA LAMTUA. Deng hmukit man boel pake le daid hmukit in todan nas, Noh kat nal mesa-mesa. Hidim un keos le tunus se mija na dapa, le daid in todan bel AMA LAMTUA. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Nikit AMA LAMTUA hodo net in tunu-dadung nas in bui bingis sa kon, Un dalen kolo isi. Un nangan noan, “Kilan deng dedeng nia, Auk tao didaan apan-kloma ki undeng atuli li in daat ta lo ka. Oen nangan dadaat deng anan bii ku kon no, Auk tao didaan totoang in nuli ngias banansila el Auk tao son ni lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Se dedeng apan-kloma ki muik nabale lam, oras sas laok napiut, el in biasa ka. Nas: oras in soko-hai, nol oras in nui-nole, oras blingin nol oras otot, oras ehe nol oras ulan, lelo nol duman.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ama Lamtua Allah bel hangun se Noh nol un anan nas, hidim tekas noan, “Mi behe-hua mamo-mamo, le tao inu pait apan-kloma kia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mam totoang hmukit huin, kee-tilu nol ikan-ikan nas lii mia. Ta mi man musti ator one. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Mi boel kaa totoang hmukit nas sisin nas, banansila el mi kon boel kaa sa-saa in mula-hai ngas isin nas. Totoang nias, Auk bel mias. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Suma siis man muik dala nabale ngas sam, mi boel kaas deken. Undeng hmukit ti hngasa ka muik ne un dala ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Auk daek atuli li muid Auk tuladang ngia. Undeng na le, mi boel keo atuil deken. Eta muik atuli, tamlom hmukit man keo tele atuli lam, musti keo tele oen kon. Hukung ni maa deng Au. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mi musti hua-koet mamo-mamo, le tao inu apan-kloma ki pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ama Lamtua Allah tupang napiut Un in aa ka noan, ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Nol nia, Auk butu-kil Auk in hida ki nol mia, lako lius mi in hua-koet tas kon. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","In hida ni kon, tom nol totoang in nuli ngias, banansila el hmukit in moang, hmukit huin nol tilu-kee kas. Nas totoang hmukit man in puit leo-leo nol mi deng kapal la dale ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Auk in hida ki elia: Auk niung ui tene, le tao tele totoang in nuli ngias lo, nol tao didaan apan-kloma ki pait lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Auk balang Auk depan na se apan nu dapa, halin daid tada, le tek nuting Auk in hida man hidi nutus taan lo nol mia, nol totoang in nuil se apan-kloma ngias sa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","17","Eta muik nopen se apan nua, hidim depan na puti, lam un tek nuting Auk in hida man noan: mam ui tene in baa ka tao didaan sa-saa in nuli ngias pait lo ka. Nini ela lam, Auk in hida man hidi nutus taan lo ka, butu-kil nol mia, nol totoang in nuli ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noh anan man puit deng kapal la ngas, Sem, Yafet nol Ham (Ham na mo, aam deng Kanaꞌan). ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Totoang atuil in ne apan-kloma ki ngias in hua-koet tas putis deng Noh anan at tiul nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noh nam, atuil in daek klapa. Un man daek klaap anggor muna hesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Oe mesan na, un niun anggor didiin mahu ngele isi. Kon un kolong soleng un kai-baut in pake ngas, hidim nini luli-lulit se un hlepe la dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Nikit Ham ngat net un ama ka in lulit ta kon, un lail puti lako le tek un kaka Sem nol Yafet. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kon nam oen duas kat seman mesa, hidim helas le loen se oen duas adun nas. Hidi nam oen duas hoen niin klupun, le taam lakos hleep na dalen, le bua oen aman na. Nini ela lam, oen duas net oen aman na in lulit ta lo. Hidi halas-sam oen duas putis. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nikit Noh in mahu ka ilang kon, un taan haup ana hmudin na in tao ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Kon un tek noan, “Hoe Ham, aam deng Kanaꞌan! Auk bahang ku! Mam ku daid ata taung ku kakam mas! ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Naka AMA LAMTUA! Nang le Un bel hangun banan se Sem! Mo nang le Kanaꞌan daid ata taung Sem! ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nang le mam Ama Lamtua Allah tao bluang taplaeng Yafet dale ka; Nol un in hua-koet tas nuil daem nol Sem in hua-koet tas. Mo nang le Kanaꞌan daid ata taung Yafet kon.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Hidi deng ui tene ka in sake ka, Noh nuli nabael pait taun 350. ");
INSERT INTO hegNTpo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Dedeng un umur taun 950, halas-sam un mate. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Hidi deng ui tene ka kon nam, Noh anan nas: Sem, Yafet nol Ham haup in hua-koet. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","5","Yafet in hua ngas, Gomer, Magog, Madai, Yawan, Tubal, Mesek nol Tiras. Mesa-mesam nonool un dasi-dehet esa, ngala esa, nol oen dale esa. Gomer in hua-koet tas, Askenas, Rifat nol Togarma. Yawan in hua-koet tas, Elisa, Tarsis, atuli-atuil Kitim mas, nol atuil Dodanim man in daad lo-lool tasi suut ta ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham in hua-koet tas, Kus, Misraim, Put nol Kanaꞌan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus in hua-koet tas, Seba, Hawila, Sabta, Raema nol Sabteka. Raema in hua-koet tas, Syeba nol Dedan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus ana biklobe la, mo Nimrod. Un nam mo meo in hote-dati man muun isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Un in muun isi ka maa deng AMA LAMTUA. Un kon daid atuil in lono-poa hmukit man muun isi. Undeng na le taom atulis aa noan, “Nang le ku daid atuil in lono-poa hmukit man muun isi banansila el Nimrod, man haup un in muun-tes sa deng AMA LAMTUA.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Hmunan nu un dale ka mulai deng Babel, Erek Akad, nol Kalne. Nias totoang muik ne Sinear. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Deng na, un kuasa taplaeng Asyur. Hidi kon un bangun-pii kota Niniwe, Rehobot-Ir, Kala, ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","nol Resen, man in ne Niniwe nol Kala hlala ka ka. Totoang kota nias, kota-kota tene. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim in hua-koet tas, atuli-atuil Ludim, Anamim, Lehabim, Naftuhim, ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Kasluhim nol Kaftorim. Atuil Kasluhim mas, atuil Filistin nas upu kia-kaons. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaꞌan ana hmunan na, mo Sidon. Kanaꞌan kon daid upu kia-kaons deng atuli-atuil Het, ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusi, Amori, Girgasi, ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwi, Arki, Sini, ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwadi, Semari nol Hamati las. Kanaꞌan in hitu-hoen nas his-hoeng lakos kata-katang, ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","didiin oen dale kas toon na, mulai deng Sidon lako Gerar, napiut lako pes se Gasa. Deng na napiut lako Sodom, Gomora, Adma, nol Seboim, le pes se Lasa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Oen totoang nam mo, Ham in hua-koet. Mesa-mesam nonool oen dasi-dehet esan, oen ngalan esan, nol oen dale esan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafet kaka Sem daid atuil Eber ras upu kia-kaons. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem in hua-koet tas, mo Elam, Asyur, Arpaksad, Lud nol Aram. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram in hua-koet tas, mo atuli-atuil Us, Hul, Geter nol Mas sas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad ana ka Sela. Sela ana ka Eber. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber haup ana biklobe at dua. Hmunan na un ngali ngala Pelek, (man nahin na noan, bakisa-bakisan), undeng dedeng na, atuli li bakisan nol apa se apan-kloma kia. Un palin na, ngala Yoktan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan in hua-koet tas, mo Almodad, Selef, Hasar-Mawet, Yera, ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila nol Yobab. Oen totoang niam, Yoktan in hua-koet sii. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Oen maan in dada ka, kilan deng Mesa napiut lako lius se Sefar, man nas leten-leten ne suu halin leol-saken. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Oen totoang nam, Sem in hua-koet. Mesa-mesam nonool un dasi-dehet, ngala, nol dale esan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nas totoang Noh in hua-koet, mesa-mesam nonool un ngala esa. Nikit ui in baa tene ka kuhit kon nam, oen nias man holhising le inu apan-kloma kia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Hmunan hesa kua, totoang atuil in se apan-kloma ki ngias, dehet nol apa nini dasi mes sii. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Neot mesan na, teng deng one la lakos seda bus el halin leol-saken, kon oen lius se dale titun mesa se Sinear, ti oen daad se las. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Oen totoang koo mesa le tek apa noan, “Kaka-pali me! Maa le kit bangun-pii kota tene mesa. Kit musti kutang dale, hidim kit tunun, le halin daid baut didi. Kit tode-toed baut nas nini ter. Hidim bangun-pii menara mesa, man tula ka lako pes se apan nua, le halin nam kit haup in naka. Nang le kit daid bangsa tene mesa, man bakisa-bakisan pait lo ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kon AMA LAMTUA niu le ngat soba-naan kota na, nol menara man oen in bangun son na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Hidim Un tek noan, “Atuil nias totoang bangsa mesa. Oen kon pake dasi-dehet mesa. Asa man oen in dake nia, halas-sam poh hmunan na na. Ola bingin dua, eta oen totoang butu-kil apa daid mes banansila el halas nia lam, mam oen daek nal asa tukun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Banan dui ka Kit niu lako, le tao oen dasi-dehet ta daid dasi mamo, halin oen aa kam taan apa mes nol mes lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kon nam, Ama Lamtua niu maa le tao didaan oen dasi-dehet ta. Nini ela lam, Un tao atuli las le holhising lako papmes se apan-kloma kia. Kon oen bangun napiut kota na pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Undeng na le oen ngali kota na ngala Babel, (man banansila el dasi mesa, man nahin na noan, ‘nangan tanan lo’), lole AMA LAMTUA tao sisaek oen dasi-dehet ta, nol tao oen le holhising lakos se ola-ola, se papmes apan-kloma kia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Nias Sem in hua-koet tas. Dedeng ui tene ka miti kuhit nal taun dua, tom nol Sem umur taun ngatus, un haup ana biklobe mesa, ngala Arpaksad. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Hidi nam, un nuli nabael taun 500. Kon un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Dedeng Arpaksad umur taun buk tilu beas lima, kon un haup ana biklobe mesa, ngala Sela. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Hidi nam, Arpaksad nuli nabael taun 403, kon un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Dedeng Sela umur taun buk tilu, kon un haup ana biklobe mesa, ngala Eber. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Hidi nam Sela nuli nabael taun 403, kon un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Dedeng Eber umur taun buk tilu beas aat kon, un haup ana biklobe mesa, ngala Pelek. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Hidi nam Eber nuli nabael pait taun 430, nol un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Dedeng Pelek umur taun buk tiul kon, un haup ana biklobe mesa, ngala Rehu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Hidi nam Pelek nuli nabael taun 209, nol un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Dedeng Rehu umur taun buk tilu beas dua kon, un haup ana biklobe mesa, ngala Seruk. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Hidi nam, Rehu nuli nabael pait taun 207, kon un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Dedeng Seruk umur taun buk tilu, kon un haup ana biklobe mesa, ngala Nahor. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Hidi nam Seruk nuli nabael pait taun 200, kon un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Dedeng Nahor umur taun buk dua beas sipa, kon un haup ana biklobe mesa, ngala Tera. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Hidi nam Nahor nuli nabael pait taun 119, kon un haup taplaeng ana biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Dedeng Tera umur taun buk iut lisi, kon un haup ana biklobe at tilu; Abram, Nahor nol Haran. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Nias Tera in hua-koet tas. Tera anan nas, Abram, Nahor nol Haran. Haran haup ana biklobe mesa, ngala Lot. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Dedeng Haran mate kam, un ama Tera nuli nabale. Un mate se iung in hua una ka, ngala Ur ne atuil Kasdim mas dale ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram saap nol Sarai. Nahor saap nol Haran ana bihata la, ngala Milka. Haran kon haup ana biklobe, ngala Yiska. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Mo Sarai hua aan lo, undeng un maan in hua ka tema. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Oe mesan na, Tera nol un ana Abram, un nalen Sarai nol un upu Lot, putis lakos nang soleng iung Ur. Dedeng na, oen le lakos dale Kanaꞌan. Mo lakos lius se dale Haran kon, oen daad se las tukun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Se na, Tera mate se dedeng un umur taun 205. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Dedeng na, AMA LAMTUA aa meman son nol Abram noan, “Abram! Ku puti nang soleng ku ingu lia, ku nenan nas, nol ku amam ma uma la. Ku lako se mana mesa, man mam Auk tulu bel kun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mam Auk bel ku hangun. Le ku in hua-koet tas mamo taplaeng, nol daid bangsa in tene dui, didiin atuli li taan ku ngalam ma. Hidim ku kon daid hangun bel atuil didang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mam Auk bel hangun se atuli-atuil man in bel ku hangun nas. Mo Auk bahang atuil man in bahang ku ngas. Hii babanan ne! Mam totoang bangsa in se apan-kloma ki ngias haup hangun, undeng ku.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Dedeng na, Abram umur taun buk itu beas lima. Un kil un sapa Sarai, nol un palin na ana Lot, nol un hmuki-pusakan nas totoang, nol totoang atuli-atuil in dake, man un hapus se kota Haran nas. Kon Abram nol un nenan nas bokas nang soleng Haran, le lakos se dale man AMA LAMTUA in tek un son na. Oen laok napiut le lius se mana mesa, ngala Kanaꞌan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Lius se uas kon, Abram laok pukiu dale na. Un lako lius dadani nol ingu mesa, ngala Sikem. Hidim oen daad tahang dadani kai ina tene mesa, se More. Dedeng na, atuil Kanaꞌan nas daad nabael se las. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Se na, AMA LAMTUA tulu-balang apa ka bel Abram. Un tekan noan, “Mam Auk bel dale ni bel ku in hua-koet tas.” Hidi kon Abram daek mana mesa, toden nini batu, le taon daid maan in tunu-dadung bel AMA LAMTUA, man tulu-balang apa ka son se maan na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Hidi deng maan nam, Abram lakos seda se leten, ne suu loten, hidim daad tahang se iung Betel nol iung Ai hlala ka. Se na, un bangun mija in tunu-dadung mes pait taung in todan-lahing AMA LAMTUA. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Hidi nam, un daad seda-seda mana, lako lius se dale Negeb, ne Kanaꞌan halin loet-ahen. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Oe mesan na, lubu muun isi se dale Kanaꞌan. Undeng na le Abram nol un nenan nas laok katang dui pait, el halin loet-ahen, le lakos lius se dale Mesir. Oen daad tahang se las. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Oras oen le taam lakos se dale Mesir ra, Abram tek un sapa ka noan, “Sarai. Ku niam leok isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ta eta atuil Mesir ras ngat net ku in leok isi eli kia lam, taon elola ko oen keo tele au, undeng auk niam ku sapam. Nini ela lam, oen kat nal ku. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tiata banan dui ka, ku tekas noan auk niam mo ku kakam. Nini ela lam, oen keo tele auk lo, molam oen babanan nol au, undeng ku.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Oras Abram lakos lius se Mesir kon, atuli las ngat net bihatang na lekon ana lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Lahing Mesir ra pegawin nas ngat net bihatang na kon, oen naka-naka un in leko ka, se lahing nga sila. Kon oen nol bihatang nga lako se lahing nga uma. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Tiata lahing nga tao Abram nol babanan, undeng Sarai. Hidim lahing nga bel Abram hmukit el; lae-blai, laen, aus-sapi, keledai, nol unta mosa-mosa tuun ela. Un kon belen ata biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mo undeng un kat atuli sapa lako se un uma la son, tiata AMA LAMTUA hukung lahing nga nol un uma isin nas nini ili bili-ngala. ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Hidi kon lahing nga haman Abram le tekan noan, “Abram, ku tao saa in tao nia la? Amo tasao le ku tek tuun lo noan, bihatang ni ku sapam mia? ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Mo ku tek le, un niam ku palim! Naha-bubuit tam auk katan le taon daid auk sapang! Ku sapam mi nian! Nol nia, kil nolan lako. Mi duam bok lakom deng auk silang ngi tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Hidi nam, lahing nga lek un pegawi las le nulut puting Abram nol un sapa ka, nol un sa-saa las totoang deng dale na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Hidi na kon, Abram nang Mesir, le pait lako se dale Negeb. Un lako nol un sapa ka, nol un hmuki-pusakan nas totoang. Un palin na ana Lot kon, lako mudi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram na mo muik isi. Un hmukit in moang ngas, lil-mea, nol lil-muti kas mamo isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Deng Negeb un laok seda-seda mana, le pait lako se iung Betel nol iung Ai hlala ka. Hmunan nu, un daad net se la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Nol un kon bangun mija in tunu-dadung se na son. Tiata un todan-lahing AMA LAMTUA se na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot man leo-leo nol Abram ma kon, muik hmukit in moang mamo, nol un atulin in dake ngas kon mamo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Mo maan na bluang isi lo taung Abram nol Lot, le oen nulis leo-leo nol oen hmukin nas totoang. Hidim Abram nol Lot atuil in lolo-poang ngas, kaen apa undeng bluan se maan na dabun in nalo oen hmukit tas. (Dedeng na, atuil Kanaꞌan nas nol atuil Feris sas kon daad nabael se las). ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Hidi kon Abram tek un ana ka noan, “Hoe Lot! Kit nia mo ama-ana, mo tamlom kit banan nol apa mes nol mes lo, undeng kit atulin in dake ngias in keng apa tutungus sia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tiata in banan dui ka, kit duat bakisan apa tuun tia. Maan ni bluang. Tiata eta ku huil dale su loten nua lam, auk haup suu blain nia. Mo eta ku huil dale suu kanan nia lam, auk kat se kliu nia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ti Lot ngat-ngat pukiu. Kon un ngat net hnono palun Yordan man liis-laas nol ui, lako pes se iung Soar. Maan na dale ka boa-mina leko, banansila el AMA LAMTUA klapa la, nol hnika ka el dale Mesir. (Dedeng na, AMA LAMTUA tao didaan kota Sodom nol Gomora lo bii. Tiata dale na banan nabale.) ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ta Lot huil nal totoang dale hnono palun Yordan na. Kon oen duas bakisan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Mo Abram daad napiut se dale Kanaꞌan. Hidim Lot lako daad se ingu-iung man in dadani nol kota Sodom, se hnono Yordan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Mo atuli-atuil Sodom mas, daat isi. Oen dai hii-ming AMA LAMTUA lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Dedeng Lot nol Abram bakisan apa son kon, AMA LAMTUA tek Abram noan, “Abram! Olan hikus ku matam ma le ngat pukiu mana-maan ku in dili ka. Ngat babanan sila-klupu, nol kliu-kanan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Totoang dale man ku in ngat nas, mam Auk bel kus nol ku in hua-koet tas, le daid mi pusakan napiut lako lius didiin. ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mam Auk bel ku in hua-koet tas le daid mamo banansila el hlaen in ne tasi suut tua ngas. Didiin atuli li kaih nal ku in hua-koet tas mamon na lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Nol nia, ku laok pukiu dale na blatas sa, nol un blehan na. Ta totoang nas, mam Auk bel kus.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Hidi na kon, Abram lakos le daad seda pait se mana mes dadani nol kai-kai ina tene kas se Mamre, dadani nol iung Hebron. Kon un toed batu, le daid man in tunu-dadung halin todan-lahing AMA LAMTUA se na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Dedeng na, lahi at aat nakbua. Nas: Amrafel, laih dale Sinear. Ariok, laih dale Elasar. Kedarlaomer, laih dale Elam. Nol Tideal, laih dale Goyim. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Dedeng na kon, muik lahi at lim didang kon nakbua. Laih nas: Bera, laih dale Sodom. Birsa, laih dale Gomora. Sinab, laih dale Adema. Semeber, laih dale Seboim. Nol Bela, laih dale Soar. Hidi nam laih at aat tas keng nol laih at lim didang ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Laih at lim nas nakbua nol oen soldadu las se hnono Sidim, (man halas ni, oen noken noan Tasi Hmate). ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","In keng na, un peke ka elia: Hmunan nua, laih lim nas todan se laih Kedarlaomer lius taun hngul dua. Mo taun hngul tilu ka kon, oen hangus labang una. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Oras le taam laok el taun hngul aat ta ka, laih Kedarlaomer nol un tapans laih tilu las maas nol oen soldadu las. Oen hote-dati le tao tehen ingu-dale tenga. Nas: atuil Refaim se dale Asterot-Karnaim, atuil Susim se dale Ham, atuil Emim se dale Sawe-Kiryataim, ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","nol atuil Hori man in se leten Seir lako lius epe hlaen El Paran suut ta ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Hidim bali pait lakos se En Mispat (man halas ni ngala Kades). Hidi nam, oen tao dudus atuil Amalek kas ingu la, nol tao tehen atuil Amori man in daad se dale Haseson-Tamar ras. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Hidim laih lima las mana-mana oen soldadun nas se hnono Sidim, le lakos hote-dait labang Laih at aat tas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Se hnono na, muik tubu ter mamo. Dedeng oen hote-dait apa ka, laih Sodom nol laih Gomora, nol oen soldadu las haung lalis. Teng deng one la naih taam lakos tubu ter ras dalen. Nol tenga las lail lakos se leten. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Tiata laih at aat in nala ngas, laok nuhu-dau nal kai-batu, nol kakaat deng Sodom nol Gomora. Hidi nam oen pait. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Se dedeng na, Abram ana Lot daad se Sodom. Kon nam, laih at aat tas daek Lot, le nuhu-dau nal un sa-saa las, nol un atulin nas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mo muik atuli mes man kuis. Kon un lali lako tek Abram, atuling Ibrani nga, man daad dadani nol kai ina tene-tene kas ne Mamre. Dedeng na, muik atuil Amori mes ngala Mamre. Un pali-kakan nas Eskol nol Aner. Oen nam dil iin mes nol Abram. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Dedeng Abram ming noan, atuli las daek nal un palin na ana ka, kon un haman nakbua un atuil in dake, man taan in hote-dati ngas. Oen totoang atuli at 318. Hidi kon oen laok nulut muid laih at aat tas, lakos pes se iung Dan, man katang ne halin suu blai-ahen nua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Se na, Abram bating un atulin nas, le daid buan ila lo. Duman na kon, oen lakos hote-dati nol atuil nas. Hidim Abram nol un atulin nas nulut napiut oen lakos lius se iung Hoba, se kota Damsik halin suu blain na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kon nam, Abram haup pait Lot nol un atulin nas, nol oen sa-saa las totoang, nol atuli-atuil tenga las kon. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Oras Abram pait deng in hote-dait le tao tehen laih at aat ta ngas, laih Sodom maa sodo-sium Abram se hnono Sawe (man atuli taom noken noan, Hnono Lahi). ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Dedeng na, Melkisedek daid laih kota Salem. Nol un kon daid tulu agama deng Ama Lamtua Allah in Lapa Dui Hihidi ka. Un maa, le kil bel Abram ruti nol anggor uin. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Hidi kon un aa le bel hangun se Abram noan, “Nang le Ama Lamtua Allah in Lapa Dui Hihidi, man koet apan-dapa ku nol apan-kloma kia ka, bel ku hangun. Naka-halit Ama Lamtua Allah, man hulung ku son, le ku nal deng ku musu las.” Hidi na kon, Abram bating bel Melkisedek op mes deng op hngulu, deng totoang sa-saa man un in nuhu-dau nal pait son nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Hidi na lam, laih Sodom todan Abram, le tekan noan, “Ama Abram. Sa-saa man ama in nuhu-dau nalas son deng auk musu la ngas, nang le ama palas totoang. Mo auk suma nodan pait auk atulin nas.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram siut noan, “Ama Lahi. Auk sumpa se Ama Lamtua Allah man Lapa Dui Hihidi ka sila-mata, man koet apan-dapa ku nol apan-kloma kia, ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","noan, auk kat sa-saa mes lo kon, deng ku sa-saa las. Bung ana teben mes kon, auk boel katan lo. Nini ela lam, ku aa nal lo noan, ‘Abram haup hmuki, undeng au.’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Auk parlu saa lo. Suma ol man auk atulin nas katan son nam, nangan tuun noan hidi. Nol nang le auk tapang at tilu lias; Aner, Eskol, nol Mamre, kat nal oen nena las.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Hidi nam, AMA LAMTUA tulu-balang apa ka bel Abram, le tekan noan, “Abram! Ku lii deken. Ta Auk man tiud bel ku deng ku musu las. Nol mam Auk bel ku in hapu tene.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Mo Abram siut noan, “Eee, Ama Lamtua Allah. Ama Lamtua bel auk mamo nas ela kon no, muik nahin saa lo. Ta auk muik aan le halin pesang bel auk in hua-koet tas lo. Tiata kom le haup pusaak mamo taung in tao saa ka? Bole-bole lam, auk ata in dake Eliasar deng Damsik man haup totoang.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Mo AMA LAMTUA siut noan, “Ela lo! Ta ku anam ma esa man haup pusaka las, mo ata na lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kon Un kil puting Abram, hidim tekan noan, “Olan ku ngat laok bus el apan nua, le tinang duun nas. Ku kaih nalas se? Mam ku in hua-koet tas mamon na el duun nas kon!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ti Abram sium AMA LAMTUA in teka ka. Kon AMA LAMTUA noken un noan atuil in dalen lolo, undeng Abram parsai se Una. ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Hidi nam, AMA LAMTUA tupang Un in aa ka pait noan, “Auk niam, Lamtua Allah. Auk man kil puting ku son deng iung Ur, ne dale atuil Kasdim mas. Nol Auk kon man bel ku dale ni le daid ku dale pusaka.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Mo Abram ketan noan, “Taon elola na la LAMTUA? Taon elola le halin auk taan noan, mam dale ni daid auk pusaka ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kon Un siut noan, “Elia! Maa le kit tao oras mesa, le butu-kil asa man Auk in teka apin na. Nol nia, ku laok kat hmukit le bel Au: aus-saip ina mesa, laen ina mesa, nol lae-blai moko mesa. Oen totoang musti umur taun tilu. Hidim ku kil taplaeng nol tiul-tuan mesa, nol hmuktai mesa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Kon Abram laok kat hmukit nas totoang. Hidim un keos le baang bating aus-sapi la, laen na, nol lae-blai la, daid bila dua-dua. Hidi nam un tao nakbua sisi las op dua se dale ka, un nenes halin-halin, le daid lalan dua. Mo un keteng bating tilu-kee kas lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Kon nam tilu-kee in kaa sa-saa hmate ngas maas le noan kaa sisi las. Mo Abram nulut soleng one. ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Nikit lelo la dene tukun nam, Abram niin nala. Un natloa noan, mitang-mames sa bua nal una, tiata un lii isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Hidi kon Ama Lamtua Allah tek un noan, “Abram! Mam ku nunuil le didiin ku blalan isi, halas-sam ku mate nol leko-leko, le oen puan ku nol babanan. Mo ku in hua-koet tas lakos daid atuil in laok-maa se atuil didang ingu-dale. Mam bangsa deng ingu-dale na tao oen le daid ata, hidim tudan-kidas le tao sus oen muun isi, didiin taun ngatus aat. Mo mam Auk hukung bangsa na. Hidim Auk kil puting ku in hua-koet tas deng dale na, nol oen kil hmuki-pusaka mamo-mamo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Mam Auk ator le, ku in hua-koet tas lako lius bata lima la, man pait maas se lias. Halas ni, atuil Amori las daad ne dale ni dapas. Atuil nias daat, molam muun isi lo bii. Eta mam ku upu kia-kaon nas pait maas se ni son nam, Auk le pake one, le hukung sii-sakeng atuil Amori las. Ta se dedeng na lam, oen in daat ta lai-lisin son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Nikit duman son kon, suknahkitu lam, muik nus puit deng ai se hlikan mesa, nol obor mes kaloe le heo-heon deng siis lalan dua nas hlala ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Dedeng na kon, AMA LAMTUA butu-kil in hida nol Abram. Un tekan noan, “Auk hida, le mam Auk bel dale ni se ku in hua-koet tas, kilan deng palun Mesir, lako lius se palun Efrat, ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","nol dale atuli-atuil Keni, Kenas, Kadmon, ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Het, Feris, Refaim, ");
INSERT INTO hegNTpo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori, Kanaꞌan, Girgasi nol Yebus.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Dedeng na, Abram pait deng Mesir, le daad taun hngul son se Kanaꞌan. Un sapa Sarai haup aan lo bii. Lam Sarai muik ata bihata mesa, atuil Mesir, ngala Hagar. Oe mesan na, Sarai aa nol Abram noan, “Papa! AMA LAMTUA hepat auk maan in haup ana ki son. Tiata banan dui ka, paap laok niin nol auk ata kia, le halin nam un hua bel auk ana.” Kon Abram tao muid un sapa ka in teka ka. Hidim Sarai bel Hagar le daid Abram sapa hmudin. ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Hidi kon Abram niin nakbuan nol Hagar, kon nam un behe. Mo dedeng Hagar taan son noan un behe, kon un koaok, tiata un ngat Sarai maat halin lo kon. ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tiata Sarai tek Abram noan, “Auk man bel ku ata na, le daid ku sapam hmudin. Mo nikit bihatang na taan noan un behe son kon, un ngat kabaul au. Nias totoang in kula ki ku! Tiata nang le AMA LAMTUA man nutus kit duat dasi lia. Halas-sam ku tanan!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Kon nam Abram siut noan, “Elia! Ku niam bee hmunan. Mo un nam suma bee hmudin tuun. Tiata ku man muik hak le ator una. Ku le tao saa nol una lam, na ne ku!” Hidi kon Sarai siut-saet tuun nol Hagar, tiata un haung lali. ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Un lali lako se epe hlaen mesa. Kon AMA LAMTUA ima-ii mes deng sorga, maa tutnalan se dadani ui mata mesa, se lalan in laok bus el Sur ra. ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ima-ii na tekan noan, “Hoe Hagar, Sarai ata! Tasao le ku mo ni lia? Ku deng ol maa, nol ku le lako bus el ola ka?” Kon un siut noan, “Auk laling nang soleng auk bi-lahing nga.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Kon AMA LAMTUA ima-ii la hanet un noan, “Elia! Banan dui ka ku pait lako se ku bi-lahim mua. Un tao ku elol tuun kon no, ku sium tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ku lii deken. Ta mam Auk bel ku in hua-koet tas le mamo, didiin atuli li kaih nal oen mamon na lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Halas ni ku behe. Nesang lo ka kam, ku hua tana-ana biklobe mesa. Ku musti ngali un ngala Ismael, (ngaal na lin na banansila el dais Ibranin mesa, man muik nahin noan, ‘Ama Lamtua ming’), undeng Un ming ku in lilu ka son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mo eta tana-ana na tene maa kam, un nuli katang nol un pail-kakan nas. Undeng un banansila el ahloet huin, man dai ming le atuli pekot un lo ka. Asii tukun kon un labang. Nol atuli li totoang hobalin labang una.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ming hidi ela kon, Hagar nangan se un dalen na noan, “Auk net AMA LAMTUA, man doha-tinang au ka son.” Tukun nam un noken Ama Lamtua nini ngala noan, “Lamtua in paiduil au.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Undeng na le, atuli las ngali ui mata na Beer Lahai Roi, man nahin na noan, “ui mata deng Atuling man in nuli, man papa-paiduil au.” Maan ni ne iung Kades nol iung Beret hlala. Ui mata na muik nabael maa lius leol nia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hidi na kon, Hagar pait. Kon un hua ana biklobe mesa. Abram ngali ngala Ismael. ");
INSERT INTO hegNTpo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Oras Hagar hua Ismael la, Abram umur taun buk palu beas eneng son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Nikit Abram umur taun buk sipa beas sipa kon, AMA LAMTUA maa tulu-balang Un apa ka bel Abram. Un tekan noan, “Auk niam Lamtua Allah man in Kuasa Dudui ka. Ku musti muid napiut Auk in koma-koma ngas, nol nuil lolo-lolo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Auk le butu-kil in hida nol ku, nol tao ku in hua-koet tas le daid mamo lai-lisi.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Kon Abram hai buku ka le bubu sila ka lako pes dale. Ama Lamtua Allah tek napiut noan, ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Auk in hid ku ki elia: mam ku daid upu kia-kaons deng bangsa mamo isi. Undeng na, tiata ku ngalam ma Abram lo ka, (man nahin na noan, ‘aam man ngala ka lali’), molam Abraham (man nahin na noan, ‘upu kia-kaons deng bangsa mamo’). ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mam Auk bel ku in hua-koet tas le mamo taplaeng lai-lisin. Nol mam Auk kon bangun-pii bangsa mamo deng one, nol nikit lahi mamo deng in hua-koet nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Auk kil dididi Auk in hida ni napiut nol ku, nol ku in hua-koet tas. In hida ni hidi nutus taan lo, ta Auk niam mo, ku nol ku in hua-koet tas Lamtuan Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Dale Kanaꞌan ni totoang mam Auk bel kun, nol ku in hua-koet tas. Halas ni ku suma daad tahang tukun se nia. Mo ku in hua-koet tas man haup dale Kanaꞌan lako lius didiin son na. Nol mam Auk kon daid oen Lamtuan Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Mo ku nol ku in hua-koet tas, musti kil napiut in hida ni didi-didi. Biklobe las totoang musti sunat. ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Kilan deng leol nia, eta biklobe li umur lelo paul son nam, musti sunat. Ku nenan nas, ku atuil in dake ngas totoang, nol ata man ku sos nalas son deng nusa didang ngas kon, totoang musti sunat. Sunat ta man daid tada noan, kit duat in hid apa ka napin didi, ne mi apan nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Bikloeb ol man sunat lo kam, un taam baab ne Auk in hida ni lo, nol tama le daid Auk atulin lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Hidi nam, Ama Lamtua Allah tek napiut pait noan, “Deng leol nia, ku boel noken ku sapam ma Sarai lo ka, molam noken tuun noan Sara. ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mam Auk bel hangun mamo-mamo se Sara, le hua bel ku tana-ana biklobe mesa. Baktetebes ela! Mam Sara daid upu kia-kaons deng bangsa mamo. Nol mam Auk nikit lahi mamo deng un in hua-koet tas.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham hai buku ka le bubu sila ka lako pes se dale nabale. Mo se un dalen na lam un mali. Un nangan noan, “Bikloeb blalan isi son man umur taun ngatus el au lia ki, taon elol le haup aan pait tia? Nol Sara blalan isi son kon, umur taun buk sipa, lam taon elol le un hua nabale lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Kon un tek Ama Lamtua noan, “Lamtua, nang le Ismael man haup auk pusakan nias tuun tia kon, sa-saa lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mo Ama Lamtua Allah siut noan, “Loo! Mam ku sapam Sara hua ana biklobe mesa. Ku ngali un ngala ka Isak. Auk in hida ki nahi lako se una, nol un in hua-koet tas lako lius didiin hidi nutus taan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Auk kon ming asa man ku in nodan taung Ismael la son. Tiata Auk kon belen hangun, nol Auk bel taplaeng un in hua-koet tas le daid mamo. Mam muik kaka-ama hngul dua putis deng un in hua-koet tas. Nol mam un in hua-koet tas daid bangsa tene mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ela kon no, Auk in hida ki butu-kil didi nol ku anam Isak ka sii. Suklisu nataka le oras nia, lam Sara hua una.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Aa hidi ela kon, Ama Lamtua Allah nang Abraham se maan na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Kilan deng leol neot na kon, Abraham muid Ama Lamtua Allah in leka ka meman. Kon un sunat. Hidim un sunat Ismael, nol totoang bikloeb in se un uma dalen na ngas. Un kon sunat ata biklobe las totoang. Dedeng na, Abraham umur taun buk sipa beas sipa son, nol Ismael umur taun hngul tilu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Oe mesa na, se dedeng Abraham daad dadani nol kai ina tene-tene in se Mamre ngas. AMA LAMTUA maa tulu-balang apa ka bel un se la. Un dehet ta elia: Leol na otot isi, tiata Abraham daad nuting angin se un hlepe la hnitan na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Kon Abraham nikit sila ka lam, un ngat net atuli at tiul dil se kakatang buit. Tiata un lail laba-laba laok sod one. Un hai buku ka, ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","hidim tekas noan, “Ama-ama me! Eta bole lam amas tuil nanapat se auk hlepe li le. Niun ui mosa tuun kon banan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Amas teen in kae se kai fuun nia. Tahang le tana-anang ngas kat ui halin maa boe bel amas iin nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Le auk laok mana bel amas in kaa, halin haup in tes bubuit, maa liam amas laok napiut. Ta auk daleng kolo isi, in haup dola le tutan-lau amas.” Hidi kon oen siut noan, “Na banan. Nodan mamo. Kaim tuli.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Hidi kon Abraham lail lako un hlepe la, le tek Sara noan, “Hlapat! Kat tarigu in banan dui ngas sak mesa, le daek ruti.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Hidim un lail lako se un aus-sapi luas, le huil nal aus ana aap banan mesa. Hidi kon tadu un ata ka le keo aus na, le hos un sisin na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Hidim Abraham lako kat susu, keju, nol siis man halas-sam in hos hidi na, le kil bel atuil balu in maang nas. Oras oen kaa la, Abraham dil se kai fuun na le tutan-lau one. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Kon oen ketan un noan, “Abraham! Ku sapam Sara ne ola ka?” Un siut noan, “Ne hlepe lu dale.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kon at mes deng atuil at tiul nas tek noan, “Nataka le taun in maa kua lam, Auk pait maang. Dedeng na lam, ku sapam Sara hua ana biklobe mes son.” Oras oen in aa ela ka, Sara ming deng hnita klupu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Dedeng na, Abraham nol Sara meman blalan isi son, nol Sara kon haup bulan lo son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ming oen in aa ela ka kon, Sara mail se un dalen na. Nol un nangan noan, “Inah! Auk blalan son, nol auk sapang nga kon blalan isi son elia lam, taon elola le kaim tao el atuil in saap babalu ka, halin nuting aan pait tia?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","AMA LAMTUA keket Abraham noan, “Tasao le Sara mali lia? Un nangan noan Auk in aa ni daid lo, undeng un blalan son na te? ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Auk niam AMA LAMTUA! Muik tahan saa mes lo kon man Auk daek nalan lo ka lo! Nangan babanan ne! Mam eta Auk pait maang se iang taun in maa kua lam, Sara hua nal tana-ana biklobeng mes son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ming ela kon, Sara lii. Hidim un kaen noan, “Auk mail loo.” Mo Ama Lamtua siut noan, “Apin meman ku mail baktebes.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Hidi kon atuil at tiul nas, bok lakos el kota Sodom. Kon Abraham nolas laok saos se lalan hlala. Se na lam, oen ngat haup kota Sodom. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Kon AMA LAMTUA nangan se Un dalen na noan, “Banan dui ka Auk tek nuting Abraham noan, Auk le tao didaan kota Sodom. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ta Abraham in hua-koet tas mamo taplaeng, le daid bangsa tene man muun isi. Nol mam un kon daid hangun bel totoang bangsa in se apan-kloma kia ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Auk huil nal un son, le tui un anan nas, nol atuil didang ngas kon, le muid napiut AMA LAMTUA lalan na, nuil lolo-lolo, nol nole taan lo. Eta oen tao ela lam, Auk in hida nol Abraham ma, Auk taon le dadi.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kon AMA LAMTUA tek Abraham noan, “Elia! Auk ming atuli mamo son, bisat isi nol atuil deng kota Sodom nol Gomora. Oen in daat ta lai-lisin son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Tiata Auk niu laok tinang esang, le totoang man Auk in ming son nas, ela baktebes tam lo ka. Etan lo kam, Auk musti tana.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","AMA LAMTUA aa mamaus nol Abraham mam, atuil at dua las laok napiut bus el kota Sodom. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham lako dadani nol Ama Lamtua hidim hanet noan, “Elola? Ama le tao didaan atuil banan nas leo-leo nol atuil daat tas se? ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Eta muik atuil banan at buk lim se kota na dalen nam, Ama le tao didaan oen totoang nabale le? Tamlom Ama tao didaan kota na lo, undeng one la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ama, ela deken! Ta tamlom atuil banan nas kon mates, undeng Ama in le tao didaan atuil daat tas sa la. Ama man daid Atuil in nutus se apan-dapa kua nol apan-kloma kia. Nol Ama esa kon taan son noan in ela ka tom lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","AMA LAMTUA siut noan, “Eta Auk haup atuil banan at buk lim se kota Sodom mam, Auk hukung kota na lo, undeng one.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Kon Abraham tek pait noan, “Ama! Nodan ampong, eta bole lam auk aa bubuit pait. Auk niam suma atuil ngengo man taan saa lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Eta noan atuil banan lius at buk lim lo, le suma at buk aat beas lima siis sam, elola? Dabun at lim siis kon, Ama le tao didaan kota na nabale le?” Ama Lamtua siut noan, “Eta Auk haup atuil banan at buk aat beas lima se kota na lam, Auk tao didaan kota na lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Hidim Abraham hanet pait noan, “Eta suma at buk aat siis sam, elola la Ama?” Kon Un siut noan, “Eta Auk haup at buk aat tam, Auk hukung oen lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham hanet napiut pait noan, “Ama komali deken, mo eta noan atuil banan suma at buk tiul siis sam, elola la?” Ama Lamtua siut noan, “Eta Auk haup at buk tilu lam, Auk hukung oen lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Hidim Abraham niung pait noan, “Ama komali deken, eta auk ketan bubuit pait. Eta haup atuli at buk dua siis sam, elola la?” Un siut pait noan, “Eta noan Auk haup at buk dua siis sam, Auk tao didaan kota na lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kon in puis sa, Abraham ketan noan, “Ama, Auk keket bubuit oe mes pait, mo komali nol auk deken. Elola etan noan haup atuil banan at hngul siis sa?” Kon Un siut noan, “Eta Auk haup atuil banan at hngul se na lam, Auk tao didaan kota na lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Aa nol apa hidi ela kon, AMA LAMTUA laok napiut, mo Abraham pait. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Oras na Ama Lamtua dehet nabael nol Abraham, mo Un ima-ii at duas las lakos napiut kota Sodom. Oen lius se uas sam, lelo la le dene son. Dedeng na, Lot daad nabael se kota la hnita tene ka. Ngat net atuil at dua nas kon, un laok sod one. Hidim un hai buku ka, le suda se oen duas silan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Un tekas noan, “Amam me! Maa le tuil tahang se auk uma li le. Nang le amas boe iin, hidim ninim se nia. Tahang le ola oskaong bii le lam, amas laok napiut.” Mo oen siut noan, “Nodan mamo. Mo boel kukaum nol kaim deken! Nang le kaim ninim se kota li dale epe ki tuun.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mo Lot hanet oen tutungus didiin oen tade le lakos tahang se un uma. Kon Lot hopong ruti, nol mana mija la, le oen kaa-niun leo-leo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Kaa hidi le atuil balu in maang nas laok ninis lo bii kam, bikloeb Sodom mas tuan-ana totoang maas dil pukiu Lot uma la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Oen kidu-ahan mumuun le tek Lot noan, “Hoe Lot! Bikloeb dua apin nas ne olas sa? Puting bel kamis maa, ta kaim le niin nolas!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kon Lot puti, hidim hep hnita ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Un tekas noan, “Kaka-pali me! Mi tao dadaat nol auk atulin nias ela deken. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Olan mi hii napat le! Auk anang bihata at dua. Oen haat-ana nabale. Nang le auk bel mi oen duas. Mi le tao saa nol one lam, ne mia. Mo sadi mi boel tao saa nol auk atulin nias deken, ta muid kit hadat tia lam, auk musti doh oen nol babanan.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mo atuil Sodom mas kidu-ahan le tek noan, “Ku boel maa kutang se ni deken! Ta ku nia mo atuil in laok-maa se maan ni tukun. Ku atuil likun, tiata ku muik hak le ator kaim lo. Banan dui ka ku modat deng ni tia. Eta lo kam kaim tao ku muun dui deng atuil at dua nas.” Hidim oen hutun soleng Lot, kon oen leo-leo laok tuil hnita ka, le noan tao dudus hnita na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mo atuil at dua nas doong iman nas le pel tamang Lot lako uma dalen, hidim oen hkaen tele hnita ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Hidi nam oen duas tao tedo atuil Sodom mas matan nas, didiin oen mame-mames le nuting hnita ka, mo hapun lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Hidi kon atuil at dua nas aa nol Lot noan, “Lot! AMA LAMTUA taan atuli-atuil in se kota ni ngias in daat ta son. Tiata Un lok kaim maam, le tao dudus-didaa totoang kota nia. Tiata ku muik pail-kakans didang nabael pait ne kota nia tam lo ka? Eta muik aan biklobe, tam aan bihata, tam ana-manhiu, tamlom sii tuun kon, laok pel puting oen deng kota ni tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kon Lot laok tutnaal tana muda dua man le daid un manhiun nas, hidim tekas noan, “Hii babanan ne! Nol nia mi putim laba-laba deng kota ni tia, ta AMA LAMTUA le tao didaan kota nia!” Mo oen bali le Lot suma aa hanit tukun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ola oskaong bii kon, Ama Lamtua ima-ii at dua nas dising Lot, le halin Lot putis laba-laba tia. Oen tek noan, “Lot! Hangu tia! Pel ku sapam ma, nol mi anam bihata las duas, le lalim nol ni tia. Nang soleng kota ni tia. Eta lo kam mi matem mosa-mosa, nol daid ahum leo-leo nol kota nia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mo Lot pailius nabale. Molota AMA LAMTUA le bel slamat una. Undeng na le atuil at dua nas kil Lot, un sapa ka, nol un anan bihata las duas se iman nas, le pel puting deng kota na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kon at mes deng atuil at dua nas lek noan, “Lail mumuun le nuting in nuli tia! Boel lis laok bus el klupu lu deken! Boel tenem se hnonon nas deken! Lail napiut lakom el leten nuas, le halin nam mi matem deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Mo Lot situn noan, “Idaa Ama! Ela deken! ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Amas meman baktebes tulung le bel slamat kaim son. Mo leten nuas katang isi! Tamlom mo kaim lius se uang bii, mo in daat tas nulut haup kaim se lalan hlala son na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ama, ngat le. Muik iung ana mes katang deng ni lo. Iung na ana blutu tuun nol muik nahin saa lo. Etan ama tade kam, nang le kaim lail lakom uam tuun.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Kon un siut noan, “Elam, laok tia! Ta mam auk tao didaan iung na lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Tiata nol nia, mi lail laba-laba lakom uam tia! Ta auk tao sa-saa lo, eta mi lakom lius se luam lo bii.” Kilan deng dedeng na, atuli las ngali iung na Soar, man nahin na noan ‘blutu’. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lelo le sake kam, Lot lakos lius se Soar son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Nahkiut tuun nam, AMA LAMTUA boho ai nol blirang le kaloe niu deng apan nu laok kaa nuli kota Sodom nol Gomora. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","AMA LAMTUA tao dudus-didaa hidi totoang kota na nol ingu-iung in se dale na ngas, nol totoang in nuil se na ngas: atuli, hmukit nol in mula-hai ngas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Oras oen lalis sa, Lot sapa ka lis lako bus el klupu. Tiata nahkitu lam, un dadi hdin sila. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ola oskaong bii kon, Abraham lako pait se maan lahin un dil le hanet AMA LAMTUA ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Hidim un ngat niu lako bus el Sodom nol Gomora, nol hnono nas totoang. Un ngat tam se ola-ol tuun, nus sa buan-buan saek lako bus el apan-dapa. Undeng ai la kaa nuli totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ama Lamtua Allah tulung Lot le puti deng maan in tom hukung na, se oras Un in tao dudus-didaa kota-kota na ngas. Undeng Un nangan Un in hida man Un butu-kilan nol Abraham son na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Dedeng na, Lot lii in daad napiut se iung Soar. Undeng na le un nol anan bihaat at duas las, lakos seda se leten. Hidim oen daad se liang bolo mes dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Oe mesan na, un ana bihaat hmunan na aa nol un palin na noan, “Adi! Se maan nia lam, muik biklobe mes lo kon man maa saap nol kita. Nol nesang lo ka kam, kit aman ni blalan keko lako, nol ela lam un haup aan pait lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tiata banan dui ka kit ninung ama le mahu. Hidim kit niin nolan, le halin nam kit tupang napiut ama in hua-koet tas.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Kon duman na, oen ninung ama ka anggor didiin mahu. Hidim ana bihaat hmunan na laok niin nol un ama ka. Mo blalan na mahu isi, tiata un taan un in niin nol ana bihata la ka lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ola ka kon, kaka la tek un palin na noan, “Adi! Sian auk niin nol ama son. Duman ni ku lolen. Kit ninung mahu un pait, hidim ku taam laok niin nol una. Nini ela lam, kit duat leo-leo haup nal ana, le tupang kit aman si in hua-koet ta.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Duman na kon, oen ninung oen aman na le mahu pait. Hidim ana hmudin na taam lako niin nol un ama ka lolen. Mo blalan na mahu isi son, tiata un taan dadale lo noan un niin nol un ana bihata la son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Tiata ela kon, oen duas behes, undeng niin nol oen amans in hua ka esa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Hidi kon ana hmunan na hua ana biklobe mesa. Un ngali ngala Moab (Moab lin na tatai el dais Ibranin mesa, man nahin na noan ‘maa deng ama’). Un man daid atuil Moab pas upu kia-kaons maa pes leol neot nia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ana hmudin na kon hua nal ana biklobe mesa. Un ngali ngala Ben Ami (man nahin na noan, ‘aan deng auk nen esa ngas’). Un nam daid atuil Amon nas upu kia-kaons. ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Hidi nam, Abraham lako seda se Mamre, ne dale Negeb halin loet-ahen na le daad se iung Kades nol iung Syur hlala ka. Mo nesang lo kon, un lako seda pait se iung Gerar. ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Kon un tek atuli-atuil se na ngas noan, Sara na mo un palin. Undeng na le Abimelek, lahing Gerar ra lok un atulin nas, le laok taam nodan Sara, hidim nolan lako se lahing nga um lahi la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Duman mesan na kon, Ama Lamtua Allah tulu Un apa ka bel lahing nga se in natloa dalen. Un tek noan, “Ku le mate son nia! Lole ku kat atuli sapa kam.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Mo Abimelek siut noan, “Ama Lamtua! Auk huud tahan bihatang na lo bii. Nol auk kon kula lo. Abraham esa man teka noan bihatang na un palin. Nol bihatang na kon hao muid ela. Undeng na le auk tadu atuli laok kat un nol auk daleng ngi in niu. Tiata Ama Lamtua bel kula auk deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kon Ama Lamtua siut noan, “Meman Auk taan noan ku dalem ma niu. Nol Auk man tahang, le halin ku huud bihatang na deken le. Nini ela lam, ku tao kula saol Auk lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Nol nia, ku tunang pait bihatang na lako un sapa ku tia. Ta un sapa ka na mo, Auk mee-baha. Tiata ku laok nodan una, le kohe-kanas bel ku, halin nam ku mate deken. Mo eta noan ku bel pait bihatang na lo kam, nangan ni bana-banan! Ta mam ku, nol ku atulim mas matem totoang.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ola oskaong bii kon, lahing nga haman un atulin in dakeng ngas totoang, le nahdehes un in natloa ka. Kon oen totoang lii. ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Hidi kon lahing nga haman Abraham le ketan noan, “Auk tao kula ku saa la, le ku tao nahu au, nol auk hutun nias eli lia? Ku boel tao dais in banan lo eli deken. ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ku nangan elol le didiin ku tao eli lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Kon Abraham siut noan, “Ama lahi! Auk bali noan mi totoang niam atuil in taan Ama Lamtua Allah lo. Tiata taon elola ko bet muik atuli in le keo tele au, halin kat nal auk sapang ngia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Meman auk in teka na baktetebes ela, noan un nam mo auk paling. Ta kaim duam niam aman mesa, mo inan bakisan. Undeng na le kaim kat apa le daid sapa-ana. ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Tiata dedeng Ama Lamtua Allah tadu kaim lakom heon-heon na, auk tek auk sapang nga noan, ‘Eta kit laok se ola-ola, le atuli ketan kit duat in nuil nol apa ki elola, nol eta ku namnau au lam, siut tuun noan kit duat niam bata-blane.’” ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","16","Kon nam lahing Abimelek bel pait Sara. Hidim un tek Sara noan, “Nol nia auk baen bel ku kakam ma duit muti lihu mesa, le daid tada noan, auk daek kula-sala saol ku lo. Nol nang le halin atuli las totoang taan ela!” Hidim lahing nga tek Abraham noan, “Abraham! Auk nusa ki holsai bating ku. Ku le laok daad se ola tukun kon, bole.” Hidi nam un bel Abraham aus-sapi, laen nol lae-blai. Un kon belen ata biklobe nol ata bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Se dedeng Abimelek nuhu-dau nal Abraham sapa ka ka, AMA LAMTUA tung kele maan in hua ana deng totoang bihaat in daad se Abimelek dale in prenta ka. Mo nikit lahing nga bel pait Sara lako se un sapa ka kon, Abraham kohe-kanas se Ama Lamtua le sai pait bihata-bihata las maan in hua ana ka. Kon oen haup in hua pait. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","7","Hidi na kon, AMA LAMTUA niung hangun bel Sara, muid Un in hida ka. Abraham blalan son, mo Sara kon behe. Dedeng un mana le hua ana ka ka, Abraham umur taon ngatus. Ti tom nol oras sa kon, Sara hua ana biklobe mesa. Ta Abraham ngali ngala, Isak (man nahin na noan ‘un mali’). Hidim Sara kon tek noan, “Ama Lamtua Allah bel auk le mali, undeng halas-sam auk daleng kolo. Atuli las nangan noan taon elola ko auk haup aan se leol blalan eli lo ka. Molota, auk sapa-biklobeng ngi blalan isi son, mo auk hua nal belen nabale. Tiata asii tuun ming dehet nia lam, oen mail leo-leo nol auk kon.” Dedeng Isak umur lelo palu la, Abraham sunat una, muid Ama Lamtua Allah in leka ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kon nam Isak tene keko lako. Dedeng le soel una ka, Abraham tao fesat tene. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Oe mesan na, Sara net Abraham sapa hmudin Hagar, ana Ismael, taan in kusu-kus Isak sii. Ngat net ela kon, Sara tek un sapa ka noan, “Papa! Nulut ata in deng Mesir na nol un ana ka! Ta auk kom tana-ana deng ata na in haup baab hmuki-pusaka lo. Suma auk anang Isak sii, man musti haup totoang.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ming Sara in tek ela ka kon, Abraham nangan nam banan lo, undeng Ismael na mo un ana kon. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mo Ama Lamtua Allah tek Abraham noan, “Abraham! Ku boel nangan ku sapam hmudin na nol ana ka deken. Muid Sara in koma ka tukun, undeng mam ku haup in hitu-hoen man Auk in hid son na deng Isak. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mo Auk kon bel hangun se ku sapam hmudin na ana ka, undeng un nam kon ku anam esa. Mam un in hua-koet tas kon daid bangsa mesa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ola oskaong mitang bii kon, Abraham mana bel Hagar ngae in kaa se lalan, nol tai bel un ana ka ui botor mes se un adu ka. Hidim un sao bihatang na nol ana Ismael le oen duas bok lakos deng maan na. Kon nam oen duas laok papmes epe in dani nol Beer Syeba ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Nikit oen duas ui in ninu ka hidi son kon, Hagar nang un ana ka se kai ana mes fuun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Un nangan se un dalen na noan, “Auk tahang nal in tinang tana-ana ni in le mate ki lo son.” Kon un hoen apa ka le lako daad kakatang, nataka le katang deng un ana ka meter buk lima. Hidim un lilu mumuun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ama Lamtua Allah kon ming Ismael fala in lilu ka. Kon Un ima-ii deng sorga haman tek Hagar noan, “Hagar! Tasao le ku dalem ma iil isi ela lia? Lii deken, ta Ama Lamtua ming tana-ana na in lilu ka son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Haung tia, le laok ngat una. Tao teken un dalen na, ta mam Auk le bel un in hua-koet tas daid bangsa in muun isi mesa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Hidi kon Ama Lamtua Allah tao Hagar mata ka le langa, tiata un ngat net ui in kali mes se la. Kon nam un laok nisi ui se botor ra, le nolan laok ninung un ana ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Hidi nam Ismael nol un ina ka, daad se epe hlaen Paran. Un tene maa kon, un daid atuil in hmeon tana isi. Hidi na kon, un ina ka tapa, le saap nol tana-bihatang Mesir mesa. Totoang nias dadi, undeng Ama Lamtua Allah leo-leo nol Ismael. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Dedeng na, lahing Abimelek nol un meo mes ngala Fikol, lakos tutnaal Abraham. Lahing na aa noan, “Abraham! Kaim taan son noan Ama Lamtua Allah leo-leo nol ku. Undeng na le ku daek saa tukun kon totoang nas dadis. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Tiata nol nia, auk nodan le ku nikit sumpa se Ama Lamtua Allah sila noan, mam ku nole-lilung au nol auk ana-upung ngias lo. Undeng auk daek banan saol ku son, tiata ku kon musti daek banan saol au, nol auk nusa kia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Kon Abraham siut noan, “Hao! Auk sumpa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mo hidi na kon, Abraham lapur lahing nga noan, “Ama lahi atulin nas nuu lai-niin auk ui mata in kali mesa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ming ela kon lahing nga siut noan, “Saah! Auk halas-sam ming dais nia. Tasao le ama tek deng hmunan nu lo kia? Taan le asii in dake nia lam, auk tanan lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","28","Kon nam Abraham nol Abimelek but apa in hida. Abraham daek aus-sapi nol lae-blai le bel lahing nga. Hidim un huil puting taplaeng lae-blai heteng itu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Kon lahing nga ketan un noan, “Tasao le ku tao ela lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Kon Abraham tekan noan, “Ama lahi sium lae-blai heteng iut nias, le daid tada noan, ama lahi hao noan auk man kali ui mata nia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Undeng oen duas nikit in hida se na son, tiata oen ngali maan na Beer Syeba. Un nahin na noan, ‘Ui in hida’. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Oen nikit in sumpa hidi kon lahing Abimelek nol un meo la pait lakos oen nusa ka, nusa Filistin. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Hidi nam, Abraham mul kai tamareska mes se Beer Syeba. Kilan deng dedeng na, kai ina na daid taad bel Abraham, le se maan na un todan-lahing AMA LAMTUA man in Nuli Hidi Nutus Taan lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Hidi kon Abraham daad tahang nesang se atuil Filistin nas dale ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nesang isi lo kon, Ama Lamtua sukat naan Abraham, le un hii-ming se Ama Lamtua tam lo ka. Ama Lamtua haman un noan, “Abraham!” Kon un siut noan, “Iya Lamtua.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ama Lamtua Allah lokan noan, “Hii babanan ne! Ku kat ku anam siing man ku in namnau isi ka. Kil nolan lako se dale Moria, le taon daid in tunu-dadung bel Au. Lius se uam le lam Auk tulu bel ku mana la, se leten mes dapa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kon ola ka oskaong bii, Abraham dait kai in suni, hidim un but kai las le sakeng se un keledai mes dapa. Hidim un nol Isak nol un ata kas at dua bok lakos el maan Ama Lamtua in tek un son na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Oen lako-laok kon, bingin dua ka lam, Abraham ngat net mana la deng katang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Kon un tek ata kas duas noan, “Mi duam dadam tahang se ni nol keledai lia le! Auk nol auk anang ngi le saek lakong se dapa nua, le todan-lahing se Ama Lamtua. Hidim nam kaim pait mam se ni pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Kon Abraham kat kai in suni nas le todan sakeng laok se Isak adu ka. Mo un esa man kil tudi nol ai se kai mesa. Dedeng oen duas in saek lakos leo-leo ka, ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isak haman un ama ka noan, “Papa!” Abraham situn noan, “Tasao ka Isak?” Kon nam Isak keket noan, “Papa. Kit le tuun in tunu-dadung son nia. Muik kai nol ai son. Mo lae-blai ana man kit pake le daid in todan-lahing ngi ne ola ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Kon Abraham situn noan, “Mam Ama Lamtua Allah esa man bel Un lae-blai ana ka, le daid in tunu-dadung.” Kon oen duas saek lakos napiut. ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Oen duas lakos lius se maan man Ama Lamtua in tek son na, kon Abraham toed batu, le daid mija in tunu-dadung. Hidim un tos kai las se batu la dapa. Hidim un but ana ka, le nene batlengan se kai in suning nas dapa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Un kat tudi ka, le noan keo un ana ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Mo suknahkitu lam, AMA LAMTUA ima-ii la haman un deng apan nu le tekan noan, “Hoe Abraham! Tahang le!” Kon un siut noan, “Elola la Ama Lamtua!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kon faal na tek noan, “Ku keo tana-ana na deken! Tao saa un deken. Halas-sam Auk tana, noan ku daek muid Ama Lamtua in koma ka baktetebes. Undeng ku mana hidi son, le noan bel Ama Lamtua ku anam beas mes na, le daid in tunu-dadung halin todan-lahing se Una.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Hidi nam, Abraham ngat net lae-blai moko mesa, un sulu ka naling se kai ana mes hlango. Abraham laok kat lae-blai na meman le tunun, daid in todan-lahing bel Ama Lamtua Allah, seda un ana ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Tiata Abraham ngali maan na ngala, ‘mam Ama Lamtua mana bel asa man kit in parlu ngas.’ Undeng na le, maa pes leol neot ni kon, atuli las aa noan, “Se AMA LAMTUA leten na, Un pesang bel asa man kit in parlu ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Hidi kon Ama Lamtua ima-ii la haman pait deng apan nu le tek noan, ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“AMA LAMTUA esa tek noan, ‘Auk sumpa nini Auk ngalang ngi esa elia: Ku but hidi bel Auk ku anam siing nga son, le daid in todan-lahing. Undeng na le ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Auk bel hangun banan mamo-mamo se ku, nol ku in hua-koet tas. Mam oen taplaeng mamo didiin atuli kaih nalas lo. Oen mamon na banansila el duun in ne apan nua ngas, nol hlaen in ne tasi suut tua ngas. Mam ku upu kia-kaon nias, tao tehen atuil in keng nol one ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Deng ku in hua-koet tias, mam bangsa-bangsa in se apan-kloma ki ngias totoang, haup hangun, undeng ku muid Auk in leka ka son.’” ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Hidi nam, Abraham nol un ana Isak nius pait lakos se un ata kas duas, le oen leo-leo pait lakos Beer Syeba. Kon Abraham daad se ua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Oe mesan na, Abraham ming haup noan un palin Nahor sapa Milka hua aan son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ana hmunan na, ngala Us. Un palin na, ngala Bus. Hidi nam Kemuel (un nam mo upu kia-kaon deng atuil Aram mas). ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Hidim muik Kesed, Haso, Pildas, Yidlaf nol Betuel. ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel na mo Ribka ama ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Mo Nahor kon haup taplaeng ana deng un bee hmudin in ngaal Reuma ka. Un hua Teba, Gaham, Tahas nol Maaka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Sara mate kam un umur ra taun ngatus buk dua beas itu. Dedeng un le mate ka, Abraham daad se iung Kiryat-Arba (Hebron), se dale Kanaꞌan. Abraham lilu muun isi nol melang, le kamusang un sapa ka in mate ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Hidim Abraham lako tutnaal nol atuli-atuil Het tas. Kon un tekas noan, ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ama me. Auk niam suma daad tahang tukun ne mi hlala kia. Auk muik dale le puan auk sapang ngi lo. Tiata etan mi tade kam, hee bel auk mi dale ana tep mesa, le halin nam auk puan auk sapang ngi se na.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Kon oen siut noan, ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Elia ama! Bablaan ni kaim ngat ama son, banansila el atuil blalan mesa, man kaim todan baktetebes. Tiata ama huil tuun, le dale ol man banan dui, man tom nol ama in koma ka. Kaim sium nol banan tukun muik in hutun soleng lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Kon Abraham hangu dili le suda, le todan dale lamtua deng atuil Het tas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Hidim un tek noan, “Eta mi sium auk in nodan apin na lam, auk nodan le mi tulung aa nol Efron, ama Sobar ana biklobe la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Nodan le eta bole lam, un hee bel auk un liang nga, ngala Makpela, man ne un klapa la suut ta ka. Un nodan osa bakun tukun kon, auk baen. Auk le baen nutus un osa ka se mi totoang silans, le halin dale na daid auk nena esa. Auk le taon daid kaim maan in puan nitu.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Dedeng na, Efron esa daad se na leo-leo nol atuil Het tas, tiata un kon ming Abraham in teka na. Kon nam un hangu dil le siut Abraham se totoang blalan in daad se na ngas silans, noan, ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Ela deken ama. Eli tukun. Auk bel klaap na nol un liang Makpela la bel ama. Ama puan ama sapa ka laok se na. Auk sao dale na bel ama se auk atulin nias silans. Nang le oen totoang daid saksi!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Kon nam Abraham suda pait se atuil Het tas silans. ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Hidim un aa nol Efron noan, “Ela kon banan, mo mi totoang hii napat se auk le. Auk le sos nutus dale na, le halin nam auk puan auk atulin nias se na.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Kon Efron situn noan, “Dale na osa ka suma duit muti ngatus aat sii! Tasao le kit duat niung-sakeng apa nol duit ana bubuit na lia? Ama laok puan ama sapa ka se la tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Kon nam, Abraham tade nol dale na osa ka muid Efron in teka ka. Tiata se atuil Het tas silans, man daid saksi se na, Abraham kaih duit muti bila ngatus aat, le hidim un baen Efron. ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","19","Tiata nini ela lam, Abraham haup Efron dale ka, le daid un nena. Dale Makpela na, dani nol Mamre (ne Hebron). Un sos nutus dale na nonool klapa la, nol liang nga, nol kai-kai inang ngas totoang. Blalan-blalan atuil Het tas totoang daid saksi, noan dale na nol isin nas totoang daid Abraham nena son. Hidi na kon, Abraham laok puan Sara se liang nga, ne dale Kanaꞌan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Nol ela lam, klaap na, nol un liang man hmunan nu daid atuil Het tas dale ka, halas ni daid Abraham nen esa lolen son. Un pake le daid maan in puan nitu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham umur ra blatas didiin un blalan isi. Nol AMA LAMTUA kon doh un babanan, hidim belen nuil nol liis-lasa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Abraham muik atuil in parsai mesa, man dake-mana un hmukin nas totoang. Oe mesan na, Abraham haman una, le tekan noan, “Hii babanan ne! Auk nodan ku le sumpa in mate nini AMA LAMTUA ngala ka, na Lamtua Allah man koet apan-dapa ku nol apan-kloma kia ka, noan, ku boel kat tana-bihaat deng atuil Kanaꞌan nias, le neleng daid auk anang Isak sapa deken. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Mo ku musti lako se auk dale in dadi kua, se auk pail-kakang nguas. Ku nuting tana-bihata mes se nua, le kil nolan maa bel auk anang ngia, le halin nam daid un sapa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Kon atuling man Abraham in parsai na keket noan, “Banan ama! Mo eta tana-bihatang na dai maa muid se ia lo kam, taon elola la? Eta ela lam, auk musti kil nol ama ana ki laok saap se ua tukun tia tam?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham siut noan, “Ku nangan babanan! Taon elola kon, ku boel kil nol auk anang ngi laok se ua lo! ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Nangan, ta AMA LAMTUA in kil kuasa se apan-dapa kua ka, nol puting auk son deng auk ingu-dale ka, hidim kil nol auk maang pes se dale nia. Un kon butu-kil in hida nol auk son noan, ‘Mam Auk bel dale ni totoang se ku in hua-koet tas.’ Tiata ku lii-tiud deken. Ku laok tukun. Ta mam Ama Lamtua lok Un ima-ii deng sorga le maa sai lalan bel ku, halin ku tutnaal tana-bihatang, man le daid auk anang ngi sapa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mo etan tana-bihatang na dai muid ku le maa se ia lo kam, ku puti deng in sumpa nia. Taon elol kon, ku boel kil nol auk anang ngi laok se lu deken.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kon ata in parsai na nikit in sumpa nol Abraham noan, mam un daek muid totoang Abraham in koma ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kon nam ata na huil nal unta hngulu. Hidim un sakeng sa-saa leko-banan si-sii laok se unta nas dapas. Halas-sam un bok lako Nahor kota la, kota Mesopotamia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Tiata un lako lius se kota na kon, un nol un unta las teen in kae ka se kota la suut ta, dani nol ui in kali mesa. Dedeng na, lelo la hat son, tom nol tana-bihata las in laok naus ui se ui in kali na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kon nam, Abraham ata in parsai na kohe-kanas noan, “LAMTUA man auk tuang Abraham Lamtuan Allah. Tulung sai lalan bel au, le halin nam auk lalan ni haup in banan. Tulu bel auk tuang nga Ama Lamtua dalen banan na, nol nangan un in hid nol auk son na. Tiata nang le halin nam auk tutnaal bihatang in le saap nol Isak ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ama Lamtua, auk dil ne ui in kali ki suut tia. Tana-bihaat in deng kota ni ngias maas naus ui se nia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Tiata auk in nodan ni elia: Eta auk aa nol tana-bihata mes noan, ‘Baat-ana! Tulung niung ku bliuꞌ ui la le bel auk niun buit le.’ Eta un siut noan, ‘Maa ninu ama! Nol nang le hidim auk ninung bel ama unta lias kon.’ Eta ela lam, na daid tada noan, tana-bihatang na man Ama Lamtua hulin son, le daid Isak sapa! Nol taad in ela ka, man auk tanan noan, Ama Lamtua tulu Ku in banan na son, bel auk tuang Abraham.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Un kohe-kanas hidi bii kam, tana-bihatang mes maa. Un ngala Ribka. Un na mo Abraham palin Nahor nol un sapa Milka upun. Ribka ama ka, ngala Betuel. Ribka na mo leok isi, nol un kon haat-ana nabale. Maa lius kon un niu laok napiut el ui in kali ka dalen, le nisi un bliuꞌ ui la, hidim saek pait maa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Un sake maa lius se dapa ka kon, Abraham ata ka lail lako el una, le nodan noan, “Baat-ana. Tulung bel auk niun bubuit le.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Kon tana-bihatang na siut noan, “Maa ninu baki.” Hidim un niung un bliuꞌ ui la laba-laba, le bel Abraham ata ka ninu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Niun hidi kon tana-bihatang na tek noan, “Nang le hidi kam auk naus ui le bel baki unta las niun didiin silis.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Hidim un laok doan ui lisin na se hmukit tas maan in ninu ka. Hidi nam un lail niu-saek le naus ui deng ui in kali ka, le ninung unta las totoang didiin silis. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Abraham ata ka dil ete tuun, le ngat nakekeon tana-bihatang na in dake ka. Un nanga-nangan noan, “Tana-bihatang man Ama Lamtua in huli ki nia te?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Unta las totoang niun didiin silis. Kon nam, ata na kat ante mea in pake se ilun na, le tain bel tana-bihatang nga, nol un kat lit mea apa mesa, le naen laok se un iman nas duas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Hidim un ketan noan, “Baat-ana, ku amam ma ngala asii la? Eta tade kam auk nodan le nining tahang se baat-ana ama ka uma.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Kon tana-bihatang na siut noan, “Auk amang nga ngala Betuel. Auk upung biklobe la ngala Nahor, nol auk upung bihata la, Milka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Se kaim uma lua lam, muik maan in nini nola, le bel bakis totoang. Nol bluan kon mamo, le nalo baki hmukit tias.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Hidi kon ata na suda le todan-lahing se AMA LAMTUA. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Un aa noan, “Naka Ama Lamtua! Ta un sai lalan bel auk son, le didiin auk esang tutnaal nol auk tuang Abraham, kaak-palin nas nenan se ni son. Nini ela, Ama Lamtua tulu Un dalen banan na bel auk tuang Abraham son, nol daek un in hid auk ka le daid son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Hidi nam tana-bihatang na lail pait laba-laba, le nahdeh bel un uma isin nas totoang, deng asa man in daid son na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ribka blanen na, ngala Laban. Nikit un net mea kas nol ming Ribka in dehet ta kon, Laban lail puti laba-laba, le lako tutnaal nol ata man dil nabael nol un unta las dani se ui in kali na ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Kon nam Laban aa noan, “Baki! AMA LAMTUA pela-noen baki nol boa-blingin maa lius se ia son. Tiata dil se likun ni deken! Maa le laok se kaim uma lua. Kaim muik maan son. In kaa taung baki unta las kon mamo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Hidi kon Abraham ata ka laok muid Laban, le taam lako se Betuel uma. Hidim Laban nol un nenan nas niung hulung sa-saa man ata na in sakeng se unta las dapa ngas. Hidi nam, oen nol unta nas laok nalos bluan. Oen kon kil ui le halin ata na nol un atulin nas boe iin. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Oras oen mana in kaa se mija la ka, ata na tek noan, “Kaim le kaa son nia, mo bel auk dola le auk tek napat dehet mes le.” Kon Laban siut noan, “Baki dehet tuun lako.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kon un tekas noan, “Auk nia mo mi upun Abraham ata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","AMA LAMTUA bel hangun mamo isi son, bel auk tuang nga, didiin un muik isi. Ama Lamtua belen lil-mea, lil-muti, ata biklobe nol bihata, nol hmukit mamo-mamo, banansila el: aus-sapi, unta, keledai, laen nol lae-blai. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Oras auk tuang ngas duas blalan son kon, maam Sara hua bel tuang Abraham tana-ana biklobe mesa. Mam un man sium tuang Abraham pusaka las totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tiata tuang Abraham lok auk le sumpa noan, ‘Ku boel kat tana-bihaat deng Kanaꞌan, le neleng bel auk anang Isak halin sapan deken. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Mo ku musti kat tana-bihaat deng auk nenan nas esan, le belen daid un sapa.’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Kon auk ketan auk tuang nga noan, ‘Eta tana-bihatang nga dai muid auk lo kam, taon elola la?’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Un siut noan, ‘AMA LAMTUA man auk muid Un in koma ka tutungus sa, man mam lok Un ima-ii deng sorga, le maa sai lalan bel ku, halin ku haup tana-bihata mes deng auk nenan esang ngas, le daid auk anang ngi sapa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Mo eta auk nenan nas dai le sao bel tana-bihatang na maa se ni lo kam, ku puti deng in sumpa nia.’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Tiata apin auk maang lius se ui in kali kua ka, auk kohe-kanas se auk daleng ngi noan, ‘LAMTUA, man auk tuang Abraham Lamtuan Allah. Tulung sai lalan le halin auk lalan ni haup nahin banan. Nang le auk tutnaal bihatang in le saap nol Isak ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ama Lamtua, auk dil ne ui in kali ki suut tia. Tana-bihaat in deng kota dalen nuas maas naus ui mo nia. Tiata auk nodan elia: Eta auk aa nol tana-bihata mes noan, “Baat-ana, tulung niung ku bliuꞌ ui la le bel auk niun bubuit tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Eta un siut noan, “Maa ninu ama! Nang le hidim auk ninung bel ama unta lias kon.” Eta ela lam, na daid tada noan, tana-bihatang na man Ama Lamtua hulin son, le daid auk tuang muda, sapa ka!’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Auk kohe-kanas hidi biim, baat-ana Ribka maa lius son, kil nol un bliuꞌ ui la, le naus ui deng ui in kali ka. Nikit un naus ui le saek pait maa bus el dapa ka kon, auk nodan noan, ‘Baat-ana, bel auk niun buit le!’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Kon un niung un bliuꞌ ui la laba-laba, le tek noan, ‘Baki! Maa ninu! Nol nang le hidi kam auk ninung bel baki unta las kon.’ Kon nam auk ninu, nol auk unta las kon haup in ninu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Hidi na kon, auk ketan noan, ‘Baat-ana ama ka, ngala sii la?’ Kon un siut le tek noan, ‘Auk amang nga, ngala Betuel. Auk upung biklobe la, ngala Nahor nol auk upung bihata la, ngala Milka.’ Hidi kon, auk pake belen ante se un ilu ka, nol nae belen lit mea apa mes se un iman nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Hidi nam, auk suda le todan-lahing se Ama Lamtua noan, ‘Naka Ama Lamtua! Ta Un sai lalan bel auk son, didiin auk tutnaal esang nol auk tuang Abraham nenan nas se ni son. Nol auk kon tutnaal tana-bihatang man le daid auk tuang muda Isak sapa-bihatan na, esang son.’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tiata elia, eta amas tade le tulu amas in namnau ka bel auk tuang Abraham mam, tek auk nol langa-langa tuun. Mo etan lo kam, tek langa-langa kon lako. Le halin nam auk tana, noan auk musti tao elola.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ata na dehet hidi kon, Laban nol Betuel siut noan, “Eta AMA LAMTUA ator ela son nam, kaim aa elol pait ta. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Baat-ana Ribka mo nia, tiata kil nolan lako tia. Nang le un daid upung Abraham nalen, muding asa man AMA LAMTUA in ator hidi son na.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ming ela kon, Abraham ata ka suda bon na lako huud se dale, le nodan mamo-mamo se AMA LAMTUA. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Hidim un kat puting sa-saa lil-mea, lil-muti, nol kai-baut in pake leko-leko sii, le bel Ribka. Un kon bel Ribka kakan nas nol ina ka, sa-saa in osa-osa sii. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Hidi na kon Abraham ata ka, nol un atulin nas daad le kaa-niun el fesat mesa. Kaa hidi kon, oen ninis se las. Ola oskaong le oen hangus kon, ata na tek um lamtua ka noan, “Auk nodan le eta bole lam, kaim pait lakom auk tuang ngu tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mo Ribka kaka ka nol ina ka tek noan, “Mi le bok lakom laba-laba le tao saa la? Tahang le Ribka daad nol kaim buit pait lelo hngulu ta saa ela. Hidi na lam, mi kil nolan lako tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Mo ata na siut noan, “Eee, tahang auk deken! Ta AMA LAMTUA tulung auk son, didiin auk tutnaal auk tuang muda ka sapa ka son. Tiata mamas sao kaim tuun tia, le halin kaim pait lakom le lapur kaim tuang ngu napat le.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kon oen siut noan, “Elia! Maa le kit ketan se Ribka esa tuun. Le un in koma ka elola la?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kon oen haman Ribka le ketan noan, “Ribka! Ni hii ne ku in koma. Ku tade le muid nol atuil nias meman, tamlom elola la?” Un siut noan, “Auk tade le lakong meman.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Kon nam, oen sao Ribka nol ata bihaat man in doha-tinang un deng lolo un ana bii kua ka, le lakos nol Abraham ata ka, nol un atulin nas. Oen aa le bel Ribka hangun noan, “Ribka! Kaim nodan le Ama Lamtua bel ku hua mamo-mamo, le halin ku in hitu-hoen nas daid atuli lihu-lihu. Nol kaim kon nodan le ku in hua-koet tas tao tehen musu-mus in labang nol one ngas!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Hidi na kon, Ribka nol un ata bihata la mana nakbuan oen kai-batu las, hidim oen saek unta, le bok lakos meman muid Abraham ata ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isak daad se dale Negeb. Dedeng na, un halas-sam pait deng ui in kali Beer Lahai Roi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Leol-hat mesan na, un puti deng hlepe la, le lako-laok nuting angin. Kon un botas le ngat tam, un net unta las laok maas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Nikit Ribka ngat net Isak kon, un niu lalaba tuun deng un unta la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Hidim un ketan Abraham ata ka noan, “Baki! Biklobeng in laok maa mo nua ku asii la?” Ata na situn noan, “Na auk tuang muda ka na!” Kon Ribka kat un hlimut ta le bua kele sila ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Hidi nam, ata na lapur totoang bel Isak. ");
INSERT INTO hegNTpo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Kon nam Isak nol tamang Ribka lako se un ina ka hlepe la, le oen duas sapa. Isak namnau Ribka ana lo, tiata un dalen iil isi lo son, nol un ina ka in mate ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham saap pait nol bihatang mesa, ngala Ketura. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura hua bel un anan dehe, ngalans: Simran, Yoksan, Medan, Midian, Isbak nol Sua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan anan nas, Seba nol Dedan. Dedan in hitu-hoen nas mo atuil Asyur, atuil Letus, nol atuil Leum mas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian anan nas mo Efa, Efer, Henok, Abida nol Eldaa. Oen totoang nam Ketura in hua-koet. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Dedeng Abraham nuli nabale la, un bating bel Hagar nol Ketura anan nas mesa-mesam nol un nena. Hidim un lok oen le lakos daad se Kanaꞌan halin leol-saken na, le halin nam oen katang deng un ana Isak. Mo un hmuki-nalan nas totoang, un saos bel Isak. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham mate se dedeng un umur taun 175. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Kon nam un anan Isak nol Ismael puan un se liang Makpela, man dadani nol Mamre. Hmunan nua, Abraham sos klaap na deng atuil Het tas, se Sohar ana Efron. Hmunan nu oen kon puan Sara se liang na dale. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham mate hidi kon, Ama Lamtua Allah niung hangun bel Isak, tiata un nuli nol liis-lasa. Dedeng na, Isak daad dani nol ui in kali Beer Lahai Roi la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ismael dehet ta elia: Un na mo Abraham sapa hmudin Hagar ra ana. Hagar na mo, Sara ata in deng Mesir ra. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","16","Ismael anan nas biklobe at hngul dua. Oen ngalan nas mudi-muid apa deng aan hmunan lako pes aan hmudin, elia: Nebayot, Kedar, Adbeel, Mibsam, Misma, Duma, Masa, Hadad, Tema, Yetur, Nafis nol Kedma. Aan nas daid upu kia-kaons deng bangsa hngul dua, mesa-mesam nonool un nusa. Oen ngali nusang nas ngalan nas, mesa-mesam muid oen upu kia-kaon nas ngalan nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael mate kam, un umur taun 137. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Mo un in hua-koet tas mus nol apa, mes nol mesa. Hidim oen daad holhising, ninin deng Hawila lako pes Syur, man toon nol Mesir napiut lako pes se Asyur ra. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham ana Isak, dehet ta elia: ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Dedeng Isak saap nol Ribka la, Isak umur taun buk aat. Ribka ama ka Betuel. Nol un blanen na ngala Laban. Oen nam atuil Aram, deng Padan Aram. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ribka haup aan lo. Undeng na le Isak kohe-kanas se AMA LAMTUA, halin sai bel Ribka maan in hua ka. AMA LAMTUA ming un in kohe-kanas sa kon Ribka behe. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Molota, un in behe na aan hduan. Mo tana-anang dua nas taan in sapan apa tutungus se oen inan na tain dalen. Kon Ribka ketan se un dalen na noan, “Tasao le tana-anang dua nias elia lia?” Hidim un ketan AMA LAMTUA. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Kon AMA LAMTUA siut noan, “Tana-ana at dua in mo ku taim ma dalen na, mam daid bangsa dua, man mus nol apa tutungus. Mam aan hmudin na tes dui deng aan hmunan na. Nol kaka la daek le bel pali la.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Oras un lelon na maa lius son kon, Ribka hua aan hduan, aan biklobe sii. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ana hmunan na kluit ta mea, nol un apa ka bulu papmesa. Tiata oen ngali un ngala, Esau. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Hidi halas-sam, un palin na puti. Mo un kil un kaka ka iin baih ngungun na. Undeng na le oen ngali un ngala, Yakob (man nahin na tatai nol dais Ibranin man noan ‘iin baih ngungun’). Oras in hua oen duas sa, Isak umur taun buk eneng son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Dedeng tana-anang dua nas in tenes maas sa, Esau daid atuil in lono-poa taan hmukit. Un kom in se alas dalen tuun. Mo Yakob na mo ete tukun, nol un in koma ka le daad se uma tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak kom in kaa siis hmukit huin. Tiata un namnau Esau dui. Mo Ribka namnau Yakob dui. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Oe mesan na, oras Yakob hos uin bula, lam Esau halas-sam pait deng in lono hmukit. Un kae nol lubu isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Kon un tek Yakob noan, “Pail ana! Ku bel auk uin mea in mo ku mulu la ka buit, le auk nisi auk taing ngi le! Ta auk lubung isi son.” (Tiata oen haman un noan Edom, man nahin na tatai nol dais Ibranin man noan ‘mea’.) ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Kon Yakob siut noan, “Banan kaka. Mo bel auk kaka hak hmunan na napat le!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Kon Esau siut noan, “Hosek nol hak hmunan na! Ku palan tuun tia. Ta auk luub mateng son nian. Ku sul uin na lalaba tia, le kil nolan maa, halin auk kaa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Mo Yakob tek pait noan, “Tahang le kaka! Kaka musti sumpa muna noan, kaka sao bel auk hak hmunan na son.” Kon Esau nikit in sumpa ela. ");
INSERT INTO hegNTpo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Hidi kon Yakob sul belen uin bul mea na nol ruti. Esau kaa-niun hidi kon, un haung boka pait. Nini ela, Esau bel un hak hmunan na nol mosaꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Oe mesan na, muik oras lubu tuan se dale na, banansila el oras lubu se dedeng Abraham in nuli nabale ka. Tiata Isak laok nodan mana se Abimelek, atuil Filistin nas lahin na, le un boel daad se Gerar. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Un nodan ela, undeng AMA LAMTUA tulu-balang apa ka bel un son, le tekan noan, “Isak! Ku boel lako Mesir deken. Ta mam Auk tulu bel ku maan didang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","4","Eta ku daad tahang tuun se maan na lam, mam Auk leo-leo nol ku, nol bel ku hangun bili-ngala. Mam Auk bel ku in hua-koet tas le taplaeng mamo, banansila el duun in ne apan-dapa kua ngas. Nol Auk bel ku, nol ku in hua-koet tas nusa nia, nol un ingu-mana las totoang. Deng ku in hua-koet tas, mam totoang bangsa in se apan-kloma ki ngias haup hangun. Nini ela lam, Auk in hid nol ku amam Abraham ma, Auk taon dadi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Auk daek nias totoang, undeng ku amam ma muid Auk in koma ka, Auk in leka ka, nol Auk in tadu ka son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Tiata Isak daad tahang se Gerar. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ribka na mo leok isi. Tiata atuli-atuil in se na ngas net un kon, oen ketan apa deng una. Mo Isak siut noan, “Ribka na mo auk paling.” Un lii, tamlom mo un hao noan un sapa kam, atuli las keo tele una le oen kat lai-niin Ribka la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak daad nesang se lua kon, oe mesan na lahing nga sai un jendela la lam, un ngat net Isak nol Ribka neko-lik apa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kon un lok atuli haman Isak le un kaing, tekan noan, “Isak! Auk tanan son, noan bihatang na ku sapam! Mo tasao le ku tek noan, un na mo ku palim mia?” Kon Isak siut noan, “Elia ama! Eta auk tek noan un na mo auk sapang ngam, auk lii! Ta tamlom mo mam atuli las keo tele au la.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kon nam lahing nga siut noan, “Eta muik atuli se ni niin nol ku sapam ma lam, taon elola ko ku bel kula kami! Tasao le ku tao ela nol kami lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Hidi nam, Abimelek kaing un hutun nas nol muun noan, “Mi totoang nangan babanan! Asii barain le tao saa nol atuling nia, tamlom mo un sapa kia lam, mam auk hukung tele.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Dedeng na, Isak soko-hai se nusa na. Kon un haup pait isin lalis ngatus, undeng AMA LAMTUA belen hangun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Un in muki ka taplaeng keko lako, didiin un muik talalun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Un aus-sapi, laen nol lae-blai las taplaeng mamo. Un atulin nas kon mamo. Tiata atuil Filistin nas idus una. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Hmunan nua, Isak ama Abraham kali ui mamo. Mo halas ni, atuil Filistin nas laok bua tele ui in kaling nas nini dale. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Kon lahing Abimelek aa nol Isak noan, “Isak! Banan dui ka ku bok lako nang soleng dale ni tia. Ta ku in kuasa ka dui deng kaim son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kon nam, Isak nol un nenan nas hoen deng maan na, le pait lakos daad se hnono Gerar. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ti un ata kas kali pait ui in kali man atuil Filistin nas in bua son nas. Hidim un ngali ui in kaling nas muid ngala-ngalan man un ama ka in ngali son nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isak ata kas kali ui se hnono Gerar kon, oen kali tom ui mata in bobon puti mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Mo atuli-atuil in lolo-poa hmukit Gerar ras kaen apa nol Isak atuil in lolo-poa ngas, undeng ui na. Oen tek noan, “Ui ni kaim nena!” Undeng na le Isak ngali ui in kali na, ngala Esek, man nahin na noan, ‘kaen apa’. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kon Isak atulin nas kali ui mes pait. Mo oen kaen apa pait undeng ui in kali na. Tiata Isak ngali ui in kali na ngala Sitna, man nahin na noan, ‘labang apa’. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Hidi nam, un nang maan na, kon un ata kas kali tapnaeng ui mes pait. Pait niam oen kaen apa lo son. Tiata Isak ngali ui in kali na Rehobot, man nahin na noan, ‘maan in bluang-bleha’. Nol un tek noan, “Halas ni Ama Lamtua bel kit daad se dale in bluang-bleha nia. Se nia, halas-sam kit taplaeng mamo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Deng na, kon Isak noan le bok pait lakos daad se Beer Syeba. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Duman na kon, AMA LAMTUA tulu-balang Apa ka bel una, le tekan noan, “Isak! Auk niam mo ku amam Abraham Lamtuan Allah. Tiata ku lii deken, ta Auk doh ku. Mam Auk bel hangun se ku. Nol ku in hua-koet tas mamo taplaeng. Auk daek elia, undeng Auk in hid hidi son nol ku amam ma ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Hidi kon Isak babail batu, le daid maan in tunu-dadung taung in todan-lahing se na. Kon un nodan mamo se AMA LAMTUA se maan na. Un daad se la, kon un atulin nas kali ui pait, se na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Dedeng na, laih Abimelek maa deng Gerar. Un maa leo-leo nol un tapa Ahusat, nol Fikol, un meo in hote-dati ka, maas le tutnaal Isak. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Kon Isak ketan noan, “Ama lahi! Hmunan nu mi nulut puting kaim son, tiata mi le maa tao saa pait nia?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Kon oen siut noan, “Elia! Kaim taan son noan, Ama Lamtua doha-tinang ku. Undeng na le, kaim nangan-nangan nam, banan dui ka kit duat tao in sumpa mes elia. Ku sumpa noan, ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","mi tao dadaat saol kaim lo, ela kon kaim tao dadaat saol mi lo. Meman kaim dalen nias banan nol mia. Undeng na le, lelon na mi putim nol boa-blingin deng kaim dale ka. Kaim tanan baktetebes son, le AMA LAMTUA man bel mi hangun.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Hidi na kon Isak tao fesat bel one, kon oen kaa-niun leo-leo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ola oskaong nga kon oen nikit sumpa. Hidim Isak sao one, le pait nol dalen in titu-tema. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Leol na, Isak atulin in dake ngas maas lapur Isak deng ui man oen in kali ka, noan, “Ama! Kaim haup ui la son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kon nam, Isak ngali ui in kali na Syeba, man nahin na noan ‘sumpa’. Tiata oen ngali kota na ngala Beer Syeba, maa pes leol neot nia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Dedeng Esau umur taun buk aat, kon un saap nol tana-bihata at dua deng ngaal Het. Mesan na Beeri ana ka, ngala Yudit. Nol mesan na pait, Elon ana ka, ngala Basmat. ");
INSERT INTO hegNTpo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Bihaat at dua nas tao Isak nol Ribka dalen iil isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Dedeng Isak blalan son kon, un mata ka net babanan isi lo. Un haman un ana hmunan man un in namnau isi ka noan, “Esau! Ku maa se ni le!” Esau siut noan, “Tasao ka papa?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak tekan noan, “Elia! Auk niam blalan son. Auk tanan lo, le bling auk mateng nga. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tiata laok kat ku lelat-suli kas, le laok lono bel auk hmukit huin mes le. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Hidim ku hosan fala babanan muid auk in koma ka, le kil bel aun maa. Le halin auk kaa hidi kam, auk bel hangun se ku meman. Eta auk bel hidi ku hangun son nam, auk mateng kon banan.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Kon nam Esau puti le lako lono hmukit huin. Mo Ribka kon ming Isak in teka ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Hidi kon Ribka lako tek Yakob noan, “Hoe Yakob! Ku hii babanan ne! Apin auk ming ama tek Esau elia: ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ku laok lono nal hmukit huin mesa, le hidim hosan fala babanan bel au. Le eta auk kaa hidi kam, auk bel ku hangun se AMA LAMTUA sila.’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Tiata ku hii babanan! Le muid auk in lok ku nia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Nol nia, ku laok se kit laen nol lae-blai luas okat tua, le huil nal laen heteng dua man apan nas banan. Hidim keo, le kat un sisin na maa bel aun. Le auk hosan muid ku amam ma in koma ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Eta auk hos hidi son nam, ku kilan laok bel ku amam ma le un kaa. Hidi nam un bel ku hangun muna le, halas-sam un mate. Nini ela lam, ku man haup hangun na. Mo ku kakam ma lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Mo Yakob tek un ina ka noan, “Mama! Mo in daat ti elia, kaka Esau nam mo apa ka bulu-bulu, mo auk apang ngi doson tuun! ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tamlom mo paap kapas tom auk apang ngia, ti un taan noan auk nole una. Kon un kolen-bahang au la!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Kon un ina ka situn noan, “Yakob! Ku lii deken. Sao bel aun tuun, nang le auk man mana! Eta ku amam ma kolen-bahang ku lam, nang le auk man lepan! Nol nia, ku laok kat laen nas tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Hidi kon, Yakob lako huil nal laen nas, hidim un keos le kil bel un ina ka. Kon Ribka hosas muid Isak in koma ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Hidim Ribka lako kat Esau kaod in leok dui ka, le bel Yakob pake. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Un kon kabut Yakob ima ka nol leo ka nini laen na bulu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Hidi nam un bel Yakob in kaa fala banan na, nol ruti man un in daek hidi son na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Kon nam, Yakob kil nol in kaa na laok bel un ama ka. Un tekan noan, “Papa! Auk maang son nian!” Kon Isak siut noan, “Hoe, ku niam asii la?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakob siut noan, “Auk niam paap ana hmunan na, Esau! Auk daek hidi son muid asa man paap in loka apin na. Hangu le kaa tia. Auk hos hidi siis deng hmukit huin man auk in daek nal son se alas sua ka. Kaa, le hidim paap bel auk hangun tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kon Isak tek noan, “Ku niam ana lo ko! Taon elol le ku nal hmukit huin hlapat isi eli lia!” Kon Yakob siut noan, “Auk hapun, undeng AMA LAMTUA man paap in todan na tulung au.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kon nam Isak haman Yakob noan, “Ku maa dadani, le auk kapas naan ku le! Ku nia mo baktebes Esau tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Kon Yakob lako dadani un ama ka, kon blalan na kapa-kapas una. Hidi nam Isak tek noan, “Fala ki el Yakob fala ka. Mo ima ki el Esau.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Mo Isak taan Yakob lo, undeng un ima ka bulu-bulu el Esau kon. Mo oras un le bel Yakob hangun na, ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","un ketan oe mes pait noan, “Ku niam baktetebes Esau le?” Kon Yakob siut noan, “Baktebes papa!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Tiata Isak tekan noan, “Elam doong bel auk sisi la maa, le halin auk kaa. Hidi lem auk bel ku hangun.” Kon nam Yakob pekot belen sisi la, nol belen ui anggor le un ninu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Hidi na kon, un ama ka tekan noan, “Auk anang nge! Maa dadani se nia, le lik au.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Nikit Yakob lako dadani le lik una, kon Isak hodo net Esau kitu-kado las buin na. Kon un aa le bel hangun se Yakob noan, “Auk anang ngi buin nia, banansila el epe bluan man AMA LAMTUA belen hangun son na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Nang le Ama Lamtua niung taang deng apan nua, le tao ku klapa las daid banan! Nang le Un bel ku ale mamo lai-lisi, nol anggor isin na inu-inu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Mam bangsa-bangsa las daid ata deng ku. Nol ngala-ngaal deng bangsa-bangsa lias suda le todan se ku. Nang le ku duka-aa ku kaak-palim mas totoang. Nol oen hai bukun nas se ku silam ma. Asii man kolen-bahang ku lam, oen kon haup in kolen-bahang. Nol asii man bel ku hangun nam, oen kon haup hangun.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isak bel hangun hidi se Yakob, le un puti nang un ama ka, halas-sam un kaka Esau pait maa, kil nol hmukit huin man un in lono nalan se alas sua ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Hidim un laok hosan, le kil bel un ama ka. Un tekan noan, “Papa! Hangu le kaa tia. Auk hos hidi siis man auk in lono nala ki son nian. Kaa hidi kam paap bel auk hangun tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isak herang, kon un ketan noan, “Hee! Mo ku niam asii pait ta?” Esau siut noan, “Auk niam Esau! Paap ana hmunan na.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Kon Isak pepeten, mo hidim un ketan Esau noan, “Eta ela lam, apin asii man kil bel auk siis na le auk kaa son nia? Auk belen hangun son. Auk pel pait nal hangun na lo son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ming ama ka tek ela kon, Esau dalen ili, le lobo-lau nol aa mumuun noan, “Idaah papa! Bel hangun se auk kon le papa!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Mo Isak tekan noan, “Ku palim ma maa nole nal auk son, le sium nal ku hangun na.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Kon Esau tek noan, “Un nole auk oe dua son nia. Laih hmunan na, un nole nal auk hak hmunan na. Neot nia lam, un nole nal auk hangun na lolen. Dadin un ngala ‘Yakob’ pa. Mo paap muik hangun didang pait le bel au, tam lo ka papa?” (Ngaal Yakob pa nahin na noan ‘kil se iin baih ngungun’. Mo un nahin didang nga ‘atuil in nole daat’.) ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Kon Isak siut noan, “Auk nikit hidi un son le daid atuil ku in todan. Nol un pail-kakan nas totoang kon daid un ata. Auk belen ale liis-lasa nol anggor isin mamo-mamo. Tiata auk anang nge! Hangun asa pait man auk bel ku lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ming ela kon, Esau nuik un ama ka tutungus noan, “Paap hangun na suma mes sii ke? Taon elola ko paap nuting nal bel auk hangun didang nabale. Hangun ana mes tuun kon banan!” Hidim un lilu nol mumuun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isak situn noan, “Mam ku in nuli ka katang deng klaap man dale ka boa-mina, ta muik taang naih deng apan nu le tao ngoe ku dale ka lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Mam ku lelat-suli kas man bel ku in nuli. Mo taon elola kon, ku daid ata deng ku palim ma. Suma eta ku labang nal una, halas-sam ku haup in kuis deng un ima ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau koon-mali isi nol Yakob, undeng un palin na nuu nal un hangun na son. Mo Esau nangan noan, “Nesang lo ka kam, paap mate. Tiata natang le in melang ngas hidi kam, auk keo tele una!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","43","Nikit Ribka ming haup Esau in le keo tele Yakob pa kon, un haman Yakob le tekan noan, “Ku hii babanan! Ku kakam ma le seda un dalen in ili ka, nini in keo tele ku. Tiata ku lali lalaba nol ni tia, le lako se ku bakim Laban nua, se dale Haran. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Lako daad nesang buit se lua, didiin ku kakam ma komali nol ku lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Eta un nadidingun soleng asa man ku in tao saol una ka son nam, mam auk tadu atuli le tia haman pait ku. Ta eta auk anang ngias duas ilang leo-leo se lelo mesa lam, auk tade lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Hidi kon, Ribka aa nol Isak noan, “Auk nonos nol Esau sapan atuil Het tias son! Eta Yakob kon saap nol bihaat atuil Het tam, banan dui ka auk mateng tuun tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kon nam Isak haman Yakob le belen hangun, hidim tui-tekan noan, “Hii babanan ne! Ku saap nol tana-bihaat Kanaꞌan deken. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mo ku lako se Padan Aram, se ku upum Betuel uma. Ku laok saap nol baki Laban ana bihata las mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Nang le Ama Lamtua Allah man Kuasa Dudui ka, bel hangun se ku, le halin ku ana-upum mas taplaeng mamo, nol ku in hua-koet tas, daid bangsa mamo man in muun-tes isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Nang le Ama Lamtua in hid nol upung Abraham ma nahi se ku, nol ku in hua-koet tas. Nang le ku haup dale, man Ama Lamtua Allah in hid hidi, le bel upung Abraham son na.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Tekan hidi ela kon, Isak sao Yakob lako Padan Aram, se un bakin Laban nol upu Betuel uma. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Dedeng Yakob sium hidi un ama ka nol ina ka in leka ka kon, un bok lako Padan Aram. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esau ming haup noan, Isak bel hangun se Yakob son, hidim kaing le boel saap nol tana-bihaat Kanaꞌan lo. Un kon ming haup noan, Isak lokan le laok saap nol oen bakin na ana bihata mesa, se Padan Aram. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Un kon tana noan, un ama ka kom un sapans atuil Kanaꞌan nas lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tiata Esau lako se ama tuan Ismael lua, hidim un saap pait Ismael ana ka, ngala Mahalat. Mahalat na mo, Nebayot palin bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Hidi kon Yakob nang soleng Beer Syeba, le lako el Haran. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Oras lelo la dene kam, un lako lius se mana mesa, kon un nini se la. Un mana le nini kon, un kat batu mesa, le taon daid hlunin. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Duman na, un natloa noan un ngat net elan mes dil se dale kia, nol un tula ka lako pes se apan nua. Hidim Ama Lamtua Allah ima-ii in deng sorga nguas niu-saek se elan na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Se in natloa na dalen, Yakob net AMA LAMTUA dil se un halin na, hidim tek noan, “Auk niam AMA LAMTUA, man ku upum Abraham nol ku amam Isak Lamtuan Allah. Mam Auk bel dale ni se ku nol ku in hua-koet tas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Mam ku in hua-koet tas mamon na el ahu ka. Nol mam oen holhising lakos papmes se maan ola-ol tuun. Deng ku in hua-koet tias sam, mam totoang bangsa in se apan-kloma ki ngias haup hangun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nangan babanan! Ku laok elol tuun kon, Auk leo-leo nol ku, le doha-tinang ku. Mam Auk kil pait nol ku maa se dale nia. Auk nang soleng ku sii siing-siing lo. Nol Auk in hid nol ku nias, totoang Auk taos le dadi.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakob nahkitu deng un in nini ka kon, un tek noan, “Halas-sam auk tana le AMA LAMTUA kon muik ne nia!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Nol un lii, kon un nangan noan, “Idaah! Maan ni tao auk bulung dili. Taon elola ko, Ama Lamtua Allah uma la muik ne maan nia! Maan ni, Un hnita in laok bus el sorga ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ola oskaong bii kon Yakob hangu, le un kat baut in tian nini un bon na ka, hidim un pii halin daid tada. Hidim un doan mina se baut na dapa, le todan-lahing Ama Lamtua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Un ngali maan na, ngala Betel, un nahin na noan ‘Ama Lamtua Uma la’. (Hmunan nu maan na ngala Lus). ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Hidi na kon, Yakob nikit sumpa noan, “Eta Ama Lamtua Allah leo-leo nol au, le doha-tinang auk se auk lalan in lako nia, hidim bel auk in kaa nol kai-baut in pake, ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","didiin auk pait nol boa-blingin nam, mam AMA LAMTUA daid auk Lamtuan Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Baut man auk in pii nia, daid maan in todan-lahing Ama Lamtua Allah. Nol totoang man Ama Lamtua in bel au ngas, op hngulu lam, auk bel pait op mesa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Hidi na kon, Yakob laok napiut bus el leol-saken. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Oe mesan na kon, un ngat net ui in kali mes dadani nol ingu mesa. Dadani se na lam, muik laen nol lae-blai bua tilu, man le haup in ninu se na. Mo muik baut tene mes tung kele ui in kali na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","In biasa ka lam, eta laen nol lae-blai las nakbua son, halas-sam atuling in lolo-poa ka pekot batu la, le naus ui, halin ninung hmukit tas. Niun hidi kam, un tung ui la pait. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Kon Yakob lako ketan atuil in lolo-poa ngas noan, “Mi deng ola?” Oen siut noan, “Kaim deng iung Haran.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Kon Yakob ketan pait noan, “Mi taan auk baki Laban tam lo ka? Un na mo upung Nahor ana.” Kon oen siut noan, “Kaim tanan.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kon nam Yakob ketan napiut noan, “Un bana-banan te?” Oen siut noan, “Blalan na babanan tuun. Olan ngat. Un ana bihaat in ngaal Rahel la poa oen laen nol lae-blai las, le maa ninung se ni kon nuan. Ku natang tukun.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Hidim Yakob tek pait noan, “Lelo li blatas nabale. Tiata banan dui ka, hmukit ol man nakbua se ni son nam, mi beles niun tia. Hidim mi sika-poa nolas lakos se epe kua, le halin oen kaa bluan pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Mo oen kaen noan, “Inah, boel ela lo! Kaim musti natang atuil in lolo-poa ngas maas totoang nol oen hmukit tas nakbua se nia, halas-sam kaim pekot nodat batu lia, le ninung hmukit tias.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakob aa nabael nol atuil nas sam, Rahel maa lius son nol un ama ka laen nol lae-blai las. Taom un man sika-poa hmukit nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Nikit Yakob ngat net Rahel nol un hmukit tas kon, un laok pekot bian baut in tung kele ui in kali ka. Hidim un ninung bel un bakin na hmukit tas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Hidi nam un laok neko-lik Rahel le lilu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Hidim un dehet Rahel noan, “Pali! Auk niam, ku amam ma bata Ribka ana.” Kon Rahel lail pait lako le tek un ama ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Nikit Laban ming Rahel in dehet ela deng Yakob, noan, un nam Ribka ana, kon Laban lail lako sod Yakob. Tutnalan kon, Laban nekon le likin, hidim un nol Yakob lako oen uma. Ti Yakob dehet totoang bel Laban. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_14a","002_29_14a","GEN","29","14a","14a","Kon Laban siut noan, “Baktebes, meman kit duat niam balu lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_14b","002_29_14b","GEN","29","14b","14b","Dedeng Yakob daad nol un bakin Laban lius bulan mes son kon, ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban aa nolan noan, “Elia Yakob! Ku daek bel auk mosa tuun nam auk tao lo, undeng kit duat balu lo. Tiata ku nodan le baen ku bakun na?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban na mo muik ana bihata at dua. Kaka la ngala Lea. Mo pali la ngala Rahel. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea na mo mata ka mamaun. Mo Rahel lam sila ka leok isi, hidim un apa ka natao. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakob kom Rahel isi. Tiata un siut Laban noan, “Auk daek bel baki taun itu, sadi baki tade le auk saap nol Rahel.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Hidi kon Laban siut noan, “Auk tade! Undeng ku nia mo auk atulin, ta banan dui ku saap nol Rahel, lo kam atuil didang sapan nam banan lo. Tiata ku daad se lia tuun, le daek bel au.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kon nam, Yakob daek taun itu, le bole lam haup Rahel. Mo un kom Rahel isi, tiata taun iut nas un nataka kam suma el lelo il siis. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kuhit nal taun iut nas kon, Yakob koka Laban noan, “Baki! Auk daek bel baki taun iut son. Tiata bel auk le saap nol Rahel tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kon Laban tao fesat in sapa, le haep totoang atuil in se nusa na daleng ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","27","Duman na, Laban bel Rahel lo, molam un bel Lea le tama lako se Yakob hleep in nini ka. Tiata Yakob niin nolan. Ola ka halas-sam Yakob tana noan, un in niin nola ka Lea. Kon nam Yakob lako tek Laban noan, “Tasao le baki nole auk eli lia? Auk daek hiti-late taun iut son, le haup Rahel! Mo taon elola le baki seda nini Lea lia?” Kon Laban situn noan, “Ku komali ela deken! Muid kaim hadat in se ni kia lam, pali la boel saap muna deng kaka la lo. Tiata banan dui ka eli tuun! Ku natang le fesat in sapa ni dedeng itu las kuhit le, halas-sam ku haup Rahel. Sadi ku daek bel auk taun iut pait.” Hidi kon Laban bel un ata bihata mes ngala Silpa, le daid ata taung Lea. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakob tade. Tiata fesat lelo iut nas kuhit kon, Laban bel Rahel le oen duas Yakob sapa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Hidim Laban bel un ata bihata mes pait, ngala Bilha, le daid Rahel ata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Hidi kon Yakob niin nol Rahel. Un namnau Rahel muun dui deng Lea. Kon un daek taplaeng pait taun iut bel un bakin na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mo AMA LAMTUA tana noan, Yakob namnau Rahel dui deng Lea. Tiata Ama Lamtua bel Lea le hua. Mo Rahel lam haup aan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Kon nam Lea behe, ti un hua tana-ana biklobe mesa. Un ngali tana-ana na Ruben (man nahin na noan, ‘olan ngat ta muik ana’), undeng un tek noan, “AMA LAMTUA meman ngat net auk in susa ki son. Undeng na le halas ni auk sapang ngi kon tade le tinang au.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Hidi na kon, Lea behe pait. Un haup ana biklobe mesa, ti un ngali tana-ana na ngala Simeon, (man nahin na nataka le ‘atuli ming son’), undeng un tek noan, “AMA LAMTUA ming son noan, auk sapang ngi tao hii auk lo. Tiata Un bel taplaeng auk tana-ana mes pait.”. ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Hidi nam Lea behe pait, kon un hua ana biklobe mes pait. Un ngali tana-ana na Lewi, undeng un tek noan, “Nini tana-ana nia lam, auk dasi la hidi son. Taon elola ko, auk sapang ngi napin nol au, undeng auk hua belen aan biklobe at tiul son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Hidi na kon Lea behe pait, kon un haup tana-ana biklobe mes pait. Un ngali tana-ana naYahuda (man nahin na noan, ‘naka’), undeng un tek noan, “Pait nia lam, auk naka AMA LAMTUA!” Hidi na kon, Lea hua pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Mo Rahel haup aan lo bii. Undeng na le un idus-neoꞌ nol un kaka ka. Kon un aa nol un sapa ka noan, “Papa! Bel auk aan le! Eta lo kam auk mateng tuun tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Kon nam Yakob baet Rahel noan, “Hoe! Ku bali noan auk niam Ama Lamtua, le bel nal ku ana le!?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Kon Rahel tek noan, “Elia! Banan dui ka paap kat auk ata Bilha lia, le niin nolan, halin un hua bel auk ana.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Hidi nam un bel Bilha lako un sapa ka. Kon Yakob niin nolan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ti Bilha behe, le hua ana biklobe mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Kon Rahel aa noan, “Ama Lamtua Allah ming auk in kohe-kanas sa son. Tiata Un bel auk aan biklobe mes son. Ama Lamtua Allah nutus auk dasi li nol lolo son.” Kon un ngali tana-ana na ngala Dan, (man nahin na noan ‘nutus dasi’). ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Hidi nam, Bilha behe pait, kon un hua ana biklobe mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ti Rahel tek noan, “Auk sukat nol auk kakang ngi son, hidim auk man nala.” Tiata un ngali tana-ana na, ngala Naftali (man nahin na noan ‘sukat apa’). ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Nikit Lea taan noan un haup aan pait lo son, kon un bel un ata Silpa la laok se un sapa ka, le niin nolan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Kon nam Silpa hua ana biklobe mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ti Lea aa noan, “Auk ulat ti banan son.” Kon un ngali tana-ana na ngala Gad, (man nahin na noan ‘ulat banan’). ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Hidi na kon, Silpa hua ana biklobe mes pait. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ti Lea aa pait noan, “Haah! Halas-sam auk daleng ngi kolo. Ngat ta mam totoang bihata li tek apa noan, auk haup ulat dui hihidi.” Undeng na le, un ngali tana-ana na ngala Aser (man nahin na noan ‘dael kolo’). ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Oe mesan na, tom nol oras in nul ale kon, Ruben lako se alas sua. Un haup kai ina mesa, man atuli las nangan noan eta bihata pake kam haup ana. Kon un katan le kil bel ina Lea. Ngat net ela kon, Rahel nodan Lea noan, “Tua! Bel auk kai man Ruben in kila ka bubuit le.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Mo Lea situn noan, “Wee! Ku nia mo lai-lisin son! Ku nuhu-dau nal auk sapang nga son. Nam ku le nuhu-dau kai na pait deng auk anang ngi lia! Ku mae taan lo ke?” Mo Rahel siut noan, “Elia kaka! Eta auk haup kai na lam, duman ni ku niin nol Yakob.” Kon Lea tade. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Lelo-maun na, Yakob pait deng klapa. Kon Lea laok tutnaal nol una le tekan noan, “Papa! Ku musti niin nol auk duman nia! Ta auk baen hidi ku son, nini auk anang nga kai la.” Kon nam duman na Yakob niin nol Lea. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ama Lamtua Allah ming Lea in kohe-kanas sa. Tiata un behe, kon un hua ana biklobe mes pait, un ana at lim son na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Kon Lea ngali tana-ana na, Isaskar, (man nahin na noan, ‘baen in kae’), undeng un tek noan, “Ama Lamtua Allah baen auk in kae ka son, lole auk bel Silpa le niin nol auk sapang nga lam.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Hidi na kon Lea behe pait. Kon nam un hua ana bikloeb nomer eneng nga. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Un tek noan, “Ama Lamtua Allah bel auk sa-saa in banan mes son. Tiata halas nia, auk sapang ngi taon elola ko todan au. Undeng auk hua belen aan biklobe at eneng son.” Tiata un ngali tana-ana na Sebulon (man nahin na noan ‘bel todan’). ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Hidi na kon, Lea hua ana bihata mesa, ta un ngali ngala Dina. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kon nam Ama Lamtua Allah nangan net Rahel; Un ming Rahel in kohe-kanas sa. Tiata Un sai Rahel maan in hua ana ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Hidi nam Rahel behe, kon un hua ana biklobe mesa. Un tek noan, “Ama Lamtua Allah kose soleng auk in mae ka son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Kon un ngali tana-ana na, ngala Yusuf, (mana nahin na noan, ‘nang le un bel taplaeng’), undeng un tek noan, “Auk nodan le Ama Lamtua Allah bel tapnaeng auk aan biklobe mes pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Dedeng Rahel hua hidi Yusuf kon, Yakob aa nol Laban noan, “Papa! Eta bole lam, auk pait lakong auk ingu lu le. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Nang le auk lakong leo-leo nol auk sapa-anang ngias. Paap taan son le auk daek hiti-late bel papa, tiata auk baen nutus oen son. Undeng na le halas ni, oen nam mo auk nenans.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Kon nam un bakin na siut noan, “Manhiu! Ku hii napat le. Auk net tada noan, Ama Lamtua bel auk hangun undeng ku. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Tiata ku nodan mamon na elol tuun kon, auk baen! Sadi ku daad se lia, le daek napiut bel au.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Kon Yakob siut noan, “Paap net esa auk in daek hiti-late ka son. Tiata paap hmukit tas mamo taplaeng keko lako. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Dedeng auk maang bii ka, paap hmukin nas mamo isi eli lo. Mo halas nia lam, paap muik son. Ama Lamtua bel paap hangun, undeng auk in dake ka. Molam halas nia lam, lius un oras sa son, le auk daek taung auk sapa-anang ngias lolen.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Hidi kon Laban ketan noan, “Tiata auk musti baen ku elola la?” Yakob siut noan, “Paap bel auk saa deken tia. Mam auk doha-tinang napiut paap hmukit tias, sadi auk boel tao elia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Bel auk dola, le leol neot ni kon, auk laok huil nal laen nol lae-blai se paap hmukit tas. Man muik topon-topon nol hkaban lo ngas, paap nena. Mo in topon-topon nol hkaban nas, auk palas. Nol auk kon kat totoang lae-blai man bulu mitang ngas. Le halin nam nas totoang man baen nini auk in kae ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Se leol hmudin niam, paap taan haup noan, auk in dake ni nahlololo tam lo ka. Paap maa le presa-ngat auk hmukit tas bling tuun. Eta net laen man muik topon lo, tamlom hkoto-hkaban lo, tamlom lae-blai muti kam, paap taan son noan, auk man naok paap hmukit tas.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Hidi kon Laban tade noan, “Banan! Ela tuun lako.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mo leol na kon Laban soel bakisan hmukit topon-topon, nol hkaban-hkaban nas nol lae-blai mitang ngas. Un loka-tadu un anan nas le tao nakbua hmukit nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Hidim kil nol hmukit nas lakos se mana mesa, man katang nga laok iin nam, lelo tilu deng Yakob mana la. Kon nam, Yakob doha-tinang un bakin na laen nol lae-blai lisin nas nabale. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Hidi nam, Yakob dait kai bango deng kai ina tilu man bakisan apa, le koa bulang ngas hnuis-hnuis. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Un paing kai hnuis-hnuis nas se hmukit tas maan in ninu ka. Lam hmukit tas taom kom in laeb apa se maan in ninu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Tiata dedeng hmukit tas laeb apa se kai hnuis nas sam, mam oen anan nas kon bulu nas topon-topon nol hkoot-hkaban tukun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Kon nam oras Laban hmukit tas le laeb apa kam, Yakob beles le dil saol laok el hmukit man muik bulu hkoot-hkaban nas. Le halin mam oen anan nas bulu ngas kon hkoot-hkaban tukun. Nini ela lam, un hmukit tas siis taplaeng mamo keko lako. Hidi nam un soel bakisan deng Laban nena las. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Nol oras hmukit in tes sas laeb apa kam, Yakob paing kai hnuis-hnuis sas se oen silan nas, se oen maan in ninu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Mo eta un net hmukit in bloen nas le laeb apa kam, un paing kai las lo. Tiata Laban haup totoang hmukit man bloen nas. Mo Yakob haup totoang hmukit in tes sas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Nini ela lam, Yakob muik isi. Un laen, lae-blai, unta, keledai nol ata kas mamo isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Oe mesan na, Yakob ming Laban anan nas dehet nol apa noan, “Yakob muik isi son, undeng un kat nuli kit aman si hmuki-nalan nas son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakob kon tinang un bakin Laban sila ka lam, nus-hnining tukun, nol babanan el hmunan-hmunan nu lo son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Hidi na kon AMA LAMTUA aa nol Yakob noan, “Halas ni un oras sa maa lius son. Tiata ku musti pait lako ku ina-amam muas tia. Mam Auk laok leo-leo nol ku.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Hidi na kon, Yakob tadu laok haman Rahel duas Lea, le maa tutnaal nol un se hmukit tas mana la, se epe kua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Hidim un tekas noan, “Hahalas ni auk tinang mi amans sa lam, un sila ka niu isi lo nol au. Un kon babanan nol auk pait banansila el hmunan nu lo son. Mo Ama Lamtua Allah man auk amang nga in todan-lahing nga, leo-leo nol au. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mi duam tana noan, bablaan ni auk daek hiti-late bel mi amans sa! ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Mo ela kon no, un nole auk oe-oe. Un nole in baen au ka, lalis hngul son. Mo ela kon, Ama Lamtua Allah doha-tinang auk tutungus. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Dedeng mi amans sa tek noan, ‘Hmukit bulu hkotong ngas ku sebas,’ kon hmukit nas hua ana lam, bulu ngas totoang hkoto. Oe mesan na pait tam, un aa noan, ‘Hmukit in hkaba-hkaban nas ku man sebas,’ kon hmukit nas hua maa lam hkaban totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ama Lamtua Allah tao ela, le halin Un kat mi amans sa hmukit tas le bel aus. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Oe mesan na, dedeng hmukit tas laeb apa kam, auk netan se in natloa dalen noan, totoang hmukit moko in labe nas, muik in hnuis, muik in hkoto-hkoto nol tenga las pait hkaba-hkaban. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Hidim Ama Lamtua ima-ii deng sorga haman auk se in natloa na dalen, le tek noan, ‘Hoe, Yakob!’ Kon auk siut noan, ‘Elola la Lamtua?’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kon Un tek noan, ‘Ngat le! Totoang hmukit ta-hngulu in labe ngas suma muik hkoto, hnuis-hnuis nol hkaba-hkaban sii. Auk mana nas totoang son, undeng Auk net Laban in daek dadaat saol ku ka son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Auk niam Lamtua Allah, man tulu-balang Auk apang ngi bel ku son se Betel la. Se nua ka, ku pii batu mesa, hidim ku doan mina laok se dapa, le todan-lahing Au. Hidim ku butu-kil in hida nol Auk se na. Tiata halas ni ku musti nang dale nia, le pait lako ku ina-amam muas ingu-dale ku tia.’” ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Kon nam Rahel nol Lea siut noan, “Papa! Kaim muid tuun! Ta kaim muik pusaka mes lo kon son, deng kaim aman Laban. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Bablaan ni, blalan na tao kaim banansila el atuil balu ka. Un hee soleng kaim son. Hidim un kaa nuli kaim osa-hnaun nas son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Totoang hmuik man Ama Lamtua Allah katan deng paap Laban nas, halas ni daid kit nenans, nol kit ana-anan nias pusaka. Tiata eta Ama Lamtua tek elol son nam, kaim muid tuun!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Hidi na kon, Yakob mana nakbuan un kai-batu las totoang. Hidim un sakeng un sapa-anan nas laok se unta dapas, nol totoang sa-saa man un hapus deng Padan Aram mas, hidim sika-poa un hmukit tas totoang, le oen pait lakos dale Kanaꞌan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Dedeng na lam, Laban lako dit un lae-blai las bulu ngas. Kon Rahel naok lai-niin un ama ka baut angin in hui-langus sas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakob bok lakos ete-ete tuun, nol tek nuting un bakin na lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Un nikit kil lai-niin totoang un hmukin nas, hidim oen laok laba-laba kaliut deng palun tene Efrat ta, le oen sao lakos bus el leten Gilead. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Hidi lelo tilu, kon Laban ming haup dehet noan, Yakob haung lalis son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ti Laban haman nakbua un atulin nas, le laok nulut muid un manhiu ka. Oen nulut mudis didiin lelo itu, halas-sam hapus se leten-leten in se Gilead tas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Duman na kon, Ama Lamtua tulu-balang apa ka bel Laban se in natloa dalen. Un tekan noan, “Laban! Eta ku aa nol Yakob pam, doh ku baham ma babanan.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Duman na, Yakob buba hleep son se leten nas. Kon Laban buba oen hlepe las katang lo deng one la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Hidi na lam, Laban maa tutnaal nol Yakob. Kon un tek noan, “Hoe Yakob! Tasao le ku nol lail-niin auk anang bihata lias ete-ete, banansila el atuil man ku in daek nal se in hote-dati dalen nia? ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Amo tasao le ku lali ete-ete, nol muik tahan in seon au lo kia! Eta ku tek auk babanan nam, taon elola ko auk tao fesat le nol mi lakom nini kong-tembur nol sasanu, hidi halas-sam sao mi lakom. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ku in kula mes pait, ku bel auk dola le lik auk ana-upung ngas halas-sam saos lakos lo. Ku in tao elia ki, ngengo isi! ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nol kahan isi eta auk tao le tao nakbusu ku! Mo sian Ama Lamtua Allah man ku amam ma in todan-lahing nga, kaing auk noan, eta auk aa nol ku lam auk musti doh auk bahang ngi babanan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Meman auk tana noan, ku boka undeng ku kom naseke son le pait. Mo tasao le ku naok lai-niin auk baut angin in hui-langus sas kon nia?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Hidi kon Yakob siut noan, “Baki komali nol auk deken! Auk bokang ete-ete, undeng auk lii ta tamlom baki tahang nal tana-anang ngias sam, elola la?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mo Yakob taan lo noan un sapa Rahel man naok lai-niin baut angin in hui-langus sas. Tiata un tek noan, “Baki! Deng baut angin nas sam, baki nuting tuun lako! Le etan hapus se asii lam, hukung tele una! Poe-pet nuting lako! Eta haup baki pusaak tenga las sam kat pait. Nang le halin nam totoang atuil nias daid saksi.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kon nam Laban lako poe-pet oen hlepe las mesa-mesa. Laih hmunan na Yakob hlepe la. Hidi nam un lako Lea hlepe la. Hidi nam ata dua las hlepe las. Mo un net baut angin nas lo. Tiata un tama lako se Rahel hlepe la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Mo Rahel buni baut angin nas son, se maan in dada deng unta las kloma ka. Hidi halas-sam un sake daad se dapa. Laban poe-pet papmes Rahel hlepe la, mo haup saa lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahel aa nol ama ka noan, “Papa komali deken. Auk haung dil nal lo, ta auk net bulan.” Kon Laban nuti-nuting pait, mo un haup tahan baut angin nas lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Kon nam Yakob koon-mali isi, ta un baet Laban le tekan noan, “Hoe! Auk daek daat saa saol baki son na? Didiin baki penan muid auk banansila el atuil daat ta lia! ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Baki poe-pet auk sa-saa las totoang son. Hidim baki haup asa la? Olan taon se kit totoang silan, le halin nam kit leo-leo neta! Nang le halin nam atuil nias nutus, le sa-saa nas asii nena ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Taun buk dua son, auk daid ata bel baki. Dedeng auk doha-tinang baki hmukit tas sa, muik tahan mes in natmulung lo. Auk kaa net mes lo kon! ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Eta muik hmukit huin tao tele baki hmukit tas mesa, man auk salan lo kon, auk tek nuting baki lo, mo auk seda tukun. Nol eta atuli naok baki hmukit tas sam, baki tadu auk le seda, molota na auk in kula lo, mo auk pal in bel seda. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Lelo lam, lelo la hui noebabain au. Mo eta duman nam, auk pepeten undeng blingin. Auk melang le niin nalang lo, undeng in doh baki hmukit tas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Meman auk daek taun buk dua ka, baktebes ela! Auk daek taun hngul aat le haup baki anan bihata las. Hidi nam, auk daek taplaeng pait taun eneng, le halas-sam auk haup auk hmukit tas. Daek ngele el ata ka nesang nga ela, mo baki taan in tadu auk baen seda didiin lalis hngulu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Banan le, muik Ama Lamtua Allah man auk upung Abraham nol auk amang Isak in todan-lahing nga. Un doha-tinang au, mo lo kam taon elola ko baki nulut pait auk nol imang mosa son. Mo Ama Lamtua Allah hut mata ka nol auk in susa ni lo, nol Un kon ngat auk in dake ki totoang. Undeng na, sian Un maa kaing baki.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ming hidi Yakob in aa ela ka kon Laban, siut noan, “Elia! Bihaat at dua nias auk anang. Tana-anang man oen in huang nas totoang auk upung. Hmukit nias totoang kon, auk nena. Totoang man ku in net mo nia ngias, meman auk nena. Mo auk le tao elola la? Auk hepa-hail nal oen lo son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Tiata banan dui ka, kit duat but apa nini in hida. Le kit musti nuling muid in hida na.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kon nam Yakob kat baut tene mesa, le pii se na halin daid tada. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Hidim Yakob lok un atulin nas, le laok kat nakbuan batu le panan. Hidi nam oen totoang daad le kaa, dadani nol baut in panang nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Kon Laban ngali baut in pana nas, Yegar Sahaduta. Mo Yakob ngali ngala Galeed. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Hidim Laban tek noan, “Baut unus nia, daid saksi taung kit duat.” Tiata maan na ngala Galeed. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laban kon ngali maan na Mispa, (man nahin na noan ‘maan in doha man lapa’), undeng un aa noan, “Mam AMA LAMTUA esa man doha-tinang kit duat, le kit katang apa kon no, kit kaliut in hida ni deken. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Eta ku tao dadaat nol auk anang ngias, le saap nol bihaat didang ngam, taon elola ko auk taan lo. Mo nangan! Ta Ama Lamtua Allah man daid saksi taung ku nol au. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Olan ngat baut in dili nia, nol baut unus in paan deng dapang nias. Ngat tiam baut nias kon daid toon. Ku boel kaliut baut nias, le tao dadaat saol auk lo. Nol auk kon boel kaliut baut nias le tao dadaat saol ku lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kit but in hida nia, nini kit upu kia-kaon nas Lamtuan, Allah. Na ku upum Abraham nol auk upung Nahor Lamtua Allah na. Mam Un esa man daid tulu in nutus kit duat dasi lia.” Ming ela kon Yakob nikit sumpa, nini Ama Lamtua Allah ngala, man un ama Isak in todan-lahing nga. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Hidi kam, Yakob keo hmukit, le kil nolan lako leten na dapa, halin daid in todan-lahing bel Ama Lamtua. Hidi nam, un haman atuli las totoang le maa kaa leo-leo, nol oen melang se na didiin sain. ");
INSERT INTO hegNTpo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ola ka oskaong bii kon, Laban lako neko-lik un ana-upun nas totoang. Hidim un aa le beles hangun, hidi nam un pait lako un nusa kua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Hidi nam Yakob lakos napiut. Kon Ama Lamtua ima-ii las deng sorga maas tutnaal nol una. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Nikit un ngat netas kon, un aa noan, “Ni Ama Lamtua atulin in hote-dati ngas maan in tene mo!” Undeng na le, un ngali maan na Mahanaim, (nahin na noan ‘maan in tene dua’). ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Hidi na kon, Yakob tadu un ima-ii las at ila lo lakos muna el dale Edom (na nusa Seir), le tek un kaka Esau noan, Yakob le maa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Un tekas noan, “Mi laok tek auk kakang Esau elia: ‘Deng hmunan nu auk in bok lakong nga, maa lius halas nia, auk daad se baki Laban uma. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Halas nia lam, tuang ata ki muik aus-sapi, keledai, laen, lae-blai, nol ata bihata nol biklobe. Auk tunang atuil nias muna, le tek nuting tuang deng auk in maa kia. Auk nodan le tuang sium kaim nol im dua.’” Kon atuil nas lakos. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Dedeng oen pait maas se Yakob pa ka, oen lapur noan, “Kaim laok tutnaal paap kaka Esau son. Halas ni un nol biklobe at ngatus aat, maa bus eli le tutnaal nol papa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ming ela kon, Yakob dalen na hutlulu, nol un lii isi. Hidi nam un bating un atulin nas nol un hmukit tas totoang, le daid op dua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Un nangan noan, “Eta Esau maa le keng nol op mesan na lam, op mesan na lali nuting in nuli.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Hidi nam Yakob kohe-kanas noan, “Eee, Ama Lamtua Allah! Lamtua man auk upung Abraham nol auk amang Isak in todan-lahing. Ming auk le! Lelon na, Ama Lamtua man tadu auk le pait maang se auk nenan nias, se dale nia. Ama Lamtua man hid noan mam Lamtua tao titu bel aus totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Auk tatai in sium Lamtua in namnau ka, nol Lamtua in hii-ming auk tutungus sa lo. Hmunan nu dedeng auk kaliut palun Yordan nia ka, auk suma kil hnikan tuun. Mo halas nia lam, auk pait maang kil atuli nol hmukit opa dua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Auk lii, ta tamlom auk kakang Esau maa tuku-keng, le keo tele kaim totoang nga. Tiata auk nodan le Ama Lamtua bel boa-blingin au, nol auk sapa-anang ngias totoang deng kaka Esau. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Undeng Ku man hid noan, Ku bel auk hangun mamo-mamo, nol bel auk in hua-koet tias le taplaeng mamo, banansila el hlaen in ne tasi suut tua, man atuli li kaih nalan lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Hidi kon Yakob nini se maan na. Ola ka kon, un huil hmukit le bel un kaka ka nol mosa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Un huil nal laen ina ngatus dua, laen moko buk dua, lae-blai ina ngatus dua, lae-blai moko buk dua, ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","unta ina buk tilu nonool anan in nus nabale, aus-saip ina buk aat, aus-saip moko hngulu, keledai ina buk dua, nol keledai moko hngulu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Hidim un bating hmukit nas buan-buan muding oen ngalan nas mesa-mesa. Kon nam un bel bua mesa-mesam nol un atuil in lolo-poa. Un tek oen noan, “Mi laok muna. Maa liam auk muid mi deng klupu lia. Mo mi musti doha, le halin buan nas mesa-mesam katang nol apa buit deng buan tenga las.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Hidi nam, Yakob lok atuling in lolo-poa taung buan hmunan na ka noan, “Eta auk kakang Esau tutnaal ku, le un ketan noan, ‘Ku le lako elola la? Ku niam asii ata ka? Hmukit nias asii nena ka?’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Lam mi musti siut noan, ‘Hmukit nias tuang ata Yakob pa nena. Un tunang bel un kaka, tuang Esau. Mo un esa muid ne klupu lua.’” ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Un lok totoang atuil in sika-poa taung buan tenga las ela kon, noan, “Eta mi tutnaal kaka Esau son nam, mi belen hmukit nias tuun, hidim mi tekan noan auk muding ne klupu lua.” Yakob nangan noan, eta un bel Esau hmukit nas totoang ngam, mam Esau dalen na banan nol una. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tiata un tunang hmukit nas muna. Mo duman na, un dada nabael se la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Duman na, Yakob hangu, hidim un ator le halin un sapan nas duas, un sapan nas ata kas duas, nol un anan nas hngul esas, kaliut lakos se palun Yabok halin nua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Nikit oen totoang lakos lius halin kon, un tunang un pusaka las totoang lakos se suut halin kon. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Mo Yakob sii dada se palun na halin na. Kon nam muik biklobe mes maa, ti oen duas late apa didiin peke langa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Nikit biklobeng na nataka kam un le tehen, kon un tingan Yakob klesa ka, tiata un seen bukun na kuis deng un mana ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Kon nam biklobeng na tekan noan, “Sao auk tia, ta nesang lo ka kam lelo sake.” Mo Yakob siut noan, “Ku aa le bel auk hangun le, halas-sam auk sao ku.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Kon biklobeng na ketan noan, “Ku ngalam sii la?” Un siut noan, “Yakob.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Kon nam biklobeng na tek noan, “Ku ngalam ma Yakob pait lo ka. Mo nol nia, atuli li haman ku lam Israel, undeng ku keng le labang atuli li nol Ama Lamtua Allah didiin ku nala.” (Israel nahin na ‘in keng nol Lamtua Allah’.) ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kon Yakob ketan noan, “Ku ngalam asii la?” Mo biklobeng nga tek noan, “Ku ketan auk ngalang ngi le tao saa la?” Hidi nam un aa le bel Yakob hangun se na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kon Yakob aa noan, “Auk net Ama Lamtua Allah sil nol sil son, mo auk nuling nabale.” Tiata un ngali maan na ngala Peniel, man nahin na noan, ‘Ama Lamtua sila ka’. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakob lako le nang maan na lam, lelo la sake son. Mo un lako lam sen-hai, lole un klesa bukun na daad kula kam. ");
INSERT INTO hegNTpo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Undeng na le, maa lius leol neot nia, atuil Israel las kaa hmukit klesa lo, undeng Ama Lamtua diuk kuis oen upuns Yakob klesa bukun na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Leol neot ta, Yakob ngat net Esau maa nol un atulin ngatus aat tas. Kon nam, Yakob bating un anan nas lakos se oen inan nas mesa-mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Un tadu un sapan nas ata kas duas, nol oen anan nas laok se suu hmunan. Hidim Lea nol un anan nas, halas-sam Rahel nol un ana Yusuf laok deng hmudin hesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Mo Yakob laok se hmunan deng oen totoang. Nikit oen le lakos dadani nol un kaka ka kon, un hai buku ka le suda lako pes se dale ka, oe itu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Mo Esau ngat net un palin na kon, un lail laok tutnalan, hidim un nekon le likin. Kon oen duas lilu nol apa muun isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau net bihaat nas nol oen anan nas kon, un ketan noan, “Nias totoang asiis nias sa?” Kon Yakob siut noan, “Oen totoang niam atuil man Ama Lamtua Allah in bel au ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Hidi na kon, un sapan nas ata kas duas nol oen anan nas, lakos le todan Esau. ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Hidi nam Lea nol un anan nas lolen. Hidi halas-sam in puis sa, Yusuf nol un ina Rahel. ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Kon Esau ketan noan, “Hmukit buan il man apin ku in tunang ngas, nahin na elola la?” Kon Yakob siut noan, “Elia kaka! Auk bel kaka nas totoang nol mosa, le halin nam kaka sium auk nol dael kolo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Mo Esau siut noan, “Adi Yakob! Auk hmuki-nalan kon mamo. Tiata ku bel auk saa deken tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakob siut noan, “Ela deken kaka! Kaka musti simus le halin daid tada noan, kaka sium auk nol iman duas son. Ta apin auk net kaka sila in hngoas sa, hnika el auk net Ama Lamtua Allah in hngoas sa kon. ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tiata auk nodan nol in todan, le halin kaka sium auk in bele, man muik nahin long nas. Ta Ama Lamtua Allah banan isi nol auk son, tiata Un bel totoang asa man auk in koma ngas.” Yakob hanet napiut Esau, didiin Esau sium in beleng nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Hidi na kon Esau aa noan, “Eta ela lam mi mana, le kit lakong tia! Nang le auk nol mia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Mo Yakob siut noan, “Nang tia kaka! Kaka tinang esa tuun. Tana-anang ngias blutu nabale, ta oen laok nal hlapat lo. Nol hmukit man halas-sam hua hidi kon mamo. Eta kit dising oen le laok nol hlapat tam, se lelo mes dalen sii kon, hmukit nias mates toang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Tiata banan dui ka, kakas laok muna tukun tia. Tiam kaim totoang laok mau-mau deng hmudin nia. Maa liam auk tuil meo kaka se Seir.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Kon nam Esau aa pait noan, “Eta ela lam, auk nang auk ima-ii lias deeh le nol ku, halin oen tulu bel mi lalan.” Mo Yakob tekan noan, “Kaka, kukaum deken! Sadi auk taan son noan kaka sium au.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ming ela kon, Esau lako nang one, le pait lakos Seir. ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Mo deng na, Yakob lakos se Sukot. Se na, un bangun uma nol daek okat taung un hmukit tas totoang. Tiata maan na, oen ngali noan Sukot (man nahin na ‘um in daad tahang’) ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Kon nam Yakob deng Padan Aram lakos lius se dale Kanaꞌan nol boa-blingin. Hidim oen koet hlepe, le daad dadani nol iung Sikem man ne Kanaꞌan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Dale man Yakob in koet hlepe na, un sos nutus son deng Hemor, Sikem ama ka. Un baen nini duit muti ngatus. ");
INSERT INTO hegNTpo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Se la, un babail batu le daid maan in tunu-dadung bel Ama Lamtua. Hidim un ngali maan na, El-Elohe-Israel, man nahin na noan, ‘Ama Lamtua Allah nam mo, Israel Lamtuan’. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Oe mesan na, Yakob duas Lea ana bihaat in ngaal Dina ka, laok meo tana-bihaat in se dale na ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Laih in se dale na ka ngala Hemor, deng ngaal Hewi. Un ana biklobe la, ngala Sikem. Oe mesan na, un net Dina kon, un kil lail-ninin hidim tao didaan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sikem dalen nahi nol Dina, le kom Dina naseke. Tiata un aa kumis-mina nol Dina le halin nam, Dina koman kon. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Hidim Sikem tek un ama ka noan, “Papa! Tulung laok taam nodan bel auk Dina, le halin nam auk sapan.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakob ming haup noan atuli tao didaan un ana bihata la son, mo un ete tuun, nol tao saa lo. Dedeng na, un anan biklobe las doh hmukit se epe kua. Tiata un natang le oen pait maas totoang le. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Kon nam, Sikem ama Hemor, maa se Yakob le noan hili-leken Dina. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Oen duas dehet nol apa mamasu lam, Yakob anan nas pait deng epe kua. Nikit oen ming haup noan, Sikem tao didaan oen palin bihata la son kon, oen dalen ili nol komali isi. Hidim oen tek noan, “Dais in ela ka, boel daid se Israel lo. Tiata kit boel sium atuil in tao dadaat ela ka lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kon Hemor hanet Yakob le tekas noan, “Yakob! Auk anang Sikem kom nol ku anam bihata la isi. Tiata auk nodan le ku tade, halin nam auk anang ngi saap nolan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Etan bole lam, kit anan nias saap bali apa. Mi anan biklobe las saap nol kaim anan bihata lias. Nol kaim anan biklobe lias saap nol mi anan bihata las. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Nol nang le halin mi daad kutang nol kaim se nia. Mi huil le kom daad se maan ol tuun kon, bisa. Hidim biuk-bael le haup in muki se nia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Hidi nam Sikem aa nol Dina ama ka, nol Dina kakan nas noan, “Mi nodan saa tukun kon auk mudi. Mi nodan duit in sii ma-mae, tamlom un duit lila la osa bakun tuun kon, auk baen. Sadi mi tade le auk saap nol mi palin bihata lia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Mo Yakob anan nas taan son noan Sikem tao didaan oen palin Dina son. Tiata oen siut in nole-lilung saol Sikem, nol un ama Hemor. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Oen siut noan, “Kaim palin nia, un boel saap nol atuil in sunat bii lo! Na tao nahmaeng kami! ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mo un lalan in puti ka elia: Mi biklobe las totoang tuan-ana musti sunat banansila el kami. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Etan mi tao ela, halas-sam kit boel in saap bali apa. Nol kaim kon daad leo-leo nol mi se nia, le halin kit daid bangsa mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mo eta mi dai muid kaim in koma ki lo, le sunat lo kam, kaim kat pait kaim palin nia, hidim kaim bok lakong deng maan nia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hemor nol Sikem sium oen in teka ka nol banan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Mo Sikem tahang nal lo son, undeng un kom naseke Dina isi. Totoang atuil in se dale na ngas todan Sikem. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Tiata Hemor nol Sikem lakos se maan in nehan dasi ka, se ingu la hnita tuan na, hidim oen huli-bali nol totoang atuil in se dale na ngas. Oen tek noan, ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Pail-kakang totoang! Atuil Israel lias kom in nuil daem nol kita. Tiata nang le oen daad leo-leo nol kit se dale nia. Dale ni in bluang-bleha ka nol taung kit totoang. Kit kon boel saap apa nol oen anan bihata las. Oen kon boel saap nol kit anan bihata lias. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Oen suma nodan kit dais ana mesa. Na ka elia, kit biklobe lias totoang musti sunat banansila el one la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Eta kit nuil nakbuan apa son nam, mam oen hmukit tas nol oen hmukin nas totoang kon daid kit pusaka, ta lo? Tiata banan dui ka, kit sium oen in koma ka. Maa, le kit sunat leo-leo! Tade tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Kon nam totoang atuil in nakbua se la ngas tade, le muid Hemor nol Sikem in teka ka. Ta totoang bikloeb in se dale na ngas sunat leo-leo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Nal lelo tilu, totoang bikloeb in sunat tas papa las iil nabale lam, Dina kaka Simeon nol Lewi kil nol oen suli kas, hidim oen tamas lakos ingu la dalen ete-ete. Kon oen keo tele bikloeb nas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hemor nol Sikem kon tom in keo. Hidi nam oen kil nol oen batan Dina puti deng Sikem uma la, le oen pait. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Mo Yakob anan tenga las taam lakos iung na, le nuhu-dau nal iung na hmukin nas. Oen koon-mali, undeng atuli tao didaan oen palin bihata la se iung na son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Atuli las sa-saa in se oen uma dale nas kon, oen nuhu-dau nalas totoang, hidim oen sika-poa atuli las hmukit tas deng epe ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Oen kil nol bihata las totoang, nol tana-anang ngas, nol oen nuhu-dau nal ingu la hmukin man osa-osa ngas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Dedeng Yakob taan haup in dadi na kon, un tek Simeon duas Lewi noan, “Mi daek saa in ngengo nia la? Mi tao sus auk tukun! Mam totoang atuil Kanaꞌan nas, atuil Peris sas, nol totoang atuil in se dale ni ngias, kom kit lo isi. Oen atulin nas mamo. Mo kit atulin suma bubuit tuun. Etan oen hok apa le maa keng nol kita lam, kit dudus meman son na!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Mo oen siut nol in komali noan, “Papa! Paap bali kaim nang le oen tao kaim palin bihata li daid bihaat hmama ke?!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Hidi nam, Ama Lamtua Allah aa nol Yakob noan, “Auk niam, Lamtua Allah man tulu-balang apa ka bel ku son, se dedeng ku in lali deng ku kakam Esau la ka. Nol nia, ku lako daad seda se Betel tia. Lius se lua kam, ku bangun bel Auk maan in tunu-dadung. Hidim daad se la.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Hidim Yakob aa nol un uma isin nas totoang noan, “Maa le kit totoang bok lakong Betel lolen. Ta auk le bangun maan in todan se ua. Hmunan nu oras auk se susa daleng nga, Ama Lamtua Allah tulung auk se maan na. Tiata nol nia, mi kat soleng mi baut angin in hui-langus sas totoang tia. Tao niuꞌ mi apan nas nol pake seda kai-batu, ta kit le todan-lahing se Ama Lamtua Allah.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kon nam, oen sao oen baut angin in hui-langus sas, nol oen ante las totoang. Hidim Yakob puan sa-saa nas totoang se kai ina tene mes leon, dadani nol iung Sikem. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Dedeng Yakob nol un hutun nas bokas deng iung Sikem ma, Ama Lamtua Allah tao atuli-atuil in se ingu-iung man pukiu one ngas le lii, didiin oen lii in daek dadaat saol Yakob nol un nenan nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakob nol un hutun nas totoang lakos lius se Betel nol boa-blingin (maan na hmunan nu ngala, Lus) ne dale Kanaꞌan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Se na, Yakob bangun-pii maan in todan-lahing deng batu. Hidim un ngali maan na, ngala El Betel (man nahin na noan ‘Betel Lamtua Allahn’), undeng hmunan nu Ama Lamtua Allah tulu-balang Un Apa ka bel Yakob se na, se dedeng un in lali deng un kaka ka ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Dani nol iung Betel la, muik kai ina tene mesa, man atuli las ngali Alon Bakut, man nahin na noan ‘kai ina in kamusang’. Un ngali maan na ela, undeng dedeng Debora mate ka, oen puan un se kai ina na leon na. Debora na mo, Ribka ina in sole ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Dedeng Yakob pait maa deng Padan Aram mam, Ama Lamtua Allah tulu-balang Apa ka pait, nol bel hangun se una. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ama Lamtua tekan noan, “Nol ni kon, ku ngalam ma Yakob lo ka. Mo Auk bel ku ngaal balu, noan Israel. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Auk niam Lamtua Allah in Kuasa Dudui. Tiata ku hua-koet, le haup upu kia-kaons mamo-mamo tia! Mam bangsa-bangsa lias puit maas deng ku in hua-koet tas, nol mam ku hua lahi-lahi las. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Dale man Auk in bel ku upum Abraham nol ku amam Isak son na, halas ni Auk bel kun, nol ku in hua-koet tas.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Ama Lamtua Allah tek hidi ela kon, Yakob bangun-pii batu mes se na, le halin daid taad taung in nangan-nangan Ama Lamtua in hida ka. Hidim un doan ui anggor nol mina se baut na dapa, le todan-lahing se Ama Lamtua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Maan na, un ngali ngala Betel. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Hidi na kon, Yakob lakos nang Betel. Oras oen katang buit deng Efrata (man halas ni ngala Betlehem), kon nam, Rahel oras in hua ka maa lisu. Mo un in hua ka susa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Oras un nasang mumuun nam im-blingin na tekan noan, “Mama Rahel! Tao ku dalem ma teteken, ta maam haup aan bikloeb pait!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Nikit Rahel hngasa ka mana le nutus kon, un ngali tana-ana na, Ben-Oni man nahin na noan, ‘aan deng auk in susa ka’. Hidi na kon un mate. Mo Yakob ngali tana-ana naBenyamin, (man nahin na noan ‘aan ima kanan’). ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Tukun nam oen puan Rahel se lalan suut man laok bus el Efrata ka, (na Betlehem). ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Kon Yakob babail un niut utu ka se na. Maa lius leol neot ni kon, Rahel niut utu ka muik nabale. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Hidi na kon Yakob daad seda-seda maan tutungus. Oe mesan na, un buba hleep se menara Eder halin na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Yakob tao ata Bilha la daid un sapa son, mo dedeng oen se las sa, Yakob taan haup noan, Ruben niin nol Bilha. Yakob anan biklobe las at hngul dua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea anan nas ngalan nas elia: Ruben (Yakob ana hmunan na), Simeon, Lewi, Yahuda, Isaskar nol Sebulon. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel anan nas: Yusuf nol Benyamin. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahel ata Bilha, anan nas: Dan nol Naftali. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Hidim Lea ata Silpa anan nas: Gad nol Aser. Hua tana-anang nas se Padan Aram. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Hidi nam, Yakob lako meo un ama Isak se Mamre, dani nol iung Kiriat Arba (halas ni ngala Hebron). Hmunan nua, un upu Abraham kon daad se la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isak nuli lako lius umur taun ngatus buk palu, halas-sam un mate. Kon nam, un ana Esau nol Yakob puan una. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esau ngaal didang nga Edom. Un in hua-koet tas ngalan nas elia: ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau saap nol bihaat Kanaꞌan at dua. Mesan na atuil Het, na Elon ana bihata la, ngala Ada. Mesan na pait, atuil Hewi ngala Oholibama. Un ama ka ngala Anah, nol un upu ka ngala Sibeon. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esau kon saap nol Ismael ana bihata la, ngala Basmat. Basmat blanen hmunan na ngala Nebayot. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esau sapa hmunan Ada la hua Elifas. Basmat hua Rehuel. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Hidim Oholibama hua Yeus, Yalam nol Kora. Esau anan nas totoang huas se dale Kanaꞌan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Oe mesan na, Esau lako daad seda se dale mes didang pait, katang deng Yakob. Un kil nol sapa-anan nas, un atulin in dake ngas, un hmukit tas, nol un hmuki-nalan nas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esau bakisan nol Yakob, undeng oen hmukit tas, nol hmukin nas mamo isi. Tiata oen nuli ka tep isi son se dale na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kon Esau (man atuli noken noan Edom) lako daad seda se leten-leten deng dale Seir. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esau in hua-koet tas, man oen noken noan ‘atuil Edom’. Oen daad se dale leten nas, se Seir. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Esau sapa Ada ana bikloeb in ngaal Elifas sa haup ana biklobe at lima, oen ngalan nas elia: Teman, Omar, Sefo, Gatam nol Kenas. Elifas bee hmudin na, ngala Timna. Un hua ana biklobe mesa, ngala Amalek. Esau sapa Basmat hua ana biklobe mesa, ngala Rehuel. Rehuel haup ana biklobe at aat. Oen ngalan nas elia: Nahat, Sera, Syama nol Misa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau sapa Oholibama, na mo Anah ana, un nam kon Sibeon upu. Un hua ana biklobe at tilu. Oen ngalans Yeus, Yalam nol Kora. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Esau ana-upun nas his-hoeng daid ngala mamo. Mesa-mesam nonool un kaka-ama. Esau ana hmunan Elifas sa anan nas, daid kaka-aam deng ngaal Teman, ngaal Omar, ngaal Sefo, ngaal Kenas, ngaal Kora, ngaal Gatam, nol deng ngaal Amalek. Oen totoang nam Esau nol un sapa Ada in hua-koet. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau ana Rehuel anan nas, daid kaka-aam deng ngaal Nahat, ngaal Sera, ngaal Syama, nol deng ngaal Misa. Oen totoang nam, Esau nol un sapa Basmat in hua-koet. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau nol un sapa Oholibama anan nas daid kaka-aam deng ngaal Yeus, ngaal Yalam, nol deng ngaal Kora. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ngala-ngaal nas totoang, Esau in hua-koet. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Se leten Seir ra, muik atuil Hori mesa, ngala Seir. Un anan nas kon his-hoeng le daid ngala mamo. Mesa-mesam nol un kaka-ama. Un ana nas daid kaka-aam deng ngaal Lotan, ngaal Sobal, ngaal Sibeon, ngaal Anah, ngaal Dison, ngaal Eser, nol deng ngaal Disan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan anan nas, Hori nol Heman. (Lotan bata ka, Timna). ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal anan nas, Alwan, Manahat, Ebal, Sefo, nol Onam. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon anan nas, Aya nol Anah. Anah man laok net ui mata in otot ta se epe hlaen mesa, se dedeng un in lolo-poa un ama ka keledai las sa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Anah ana bihata la Oholibama. Nol un ana biklobe la, Dison. Dison anan nas, Hemdan, Esban, Yitran, nol Keran. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser anan nas, Bilhan, Saꞌawan nol Akan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan anan nas, Us nol Aran. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Tiata, kaka-aam deng ngaal atuil Hori las, Lotan, Sobal, Sibeon, Anah, Dison, Eser nol Disan. Oen totoang daad se dale Seir. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Dedeng dale Israel muik laih lo bii kam, se dale Edom muik un lahin son. Oen ngalan nas mudi-muid apa elia: ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Oen nikit Beor ana ka, ngala Bela, le daid laih se kota Dinhaba. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Nikit Bela mate kon, Yobab sake daid lahi, le seda una. Un ama ka ngala Sera, deng iung Bosra. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Nikit Yobab mate kon, Husam sake daid lahi, le seda una. Husam na mo deng dale atuil Teman nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Nikit Husam mate kon, Hadad sake daid lahi, le seda una. Un ama ka ngala Bedad deng iung Awit. (Un man tao tehen atuil Midian nas se dedeng oen hote-dait labang apa se Moab pa). ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Nikit Hadad mate kon, Samla sake daid lahi, le seda una. Samla na mo, deng iung Masreka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Nikit Samla mate kon, Saul sake daid lahi, le seda una. Saul na mo, deng iung Rehobot ne palun suut. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Nikit Saul mate kon, Baal-Hanan sake daid lahi, le seda una. Un ama ka ngala Akbor. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Nol nikit Baal-Hanan mate kon, Hadar sake daid lahi, le seda una. Hadar na mo, deng iung Pau. Un sapa ka ngala Mehetabel. Mehetabel ama ka, ngala Matret. Nol un upu ka, ngala Mesahab. ");
INSERT INTO hegNTpo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Tiata kaka-aam in puit deng Esau ngas ngalan nas elia: kaka-aam Timna, Alwa, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibsar, Magdiel nol Iram. Oen mesa-mesam ngali oen dale kas, muid oen ngalan nas. Dehet deng Esau in hua-koet tas ela, oen nam atuil Edom mas upu kia-kaons. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2a","Yakob dehet ta elia. Lelon na Yakob lako daad pait se dale Kanaꞌan. Na un ama Isak maan in dada se hmunan nua ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_2b","002_37_2b","GEN","37","2b","2b","Dedeng na nikit Yakob ana mes in deng un sapa Rahel, man ngala Yusuf fa, umur taun hngul itu kon, taom un nol un kakan nas leo-leo lakos doh oen laen nas nol lae-blai las. Un kakan nas, Yakob anan in deng sapa Bilha nol Silpa. Mo Yusuf niam man taom kil dais lako-pait deng un kakan nas bel oen ama na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Dedeng hua Yusuf fam, Yakob blalan son. Tiata un namnau Yusuf dui deng un anan tenga las. Oe mesan na, Yakob soo kaod blatas leok isi mes bel Yusuf. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Nikit un kakan nas ngat tam, oen aman na namnau Yusuf dui kon, oen kom Yusuf lo isi, didiin oen aa nolan babanan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Duman mesan na, Yusuf natloa. Hidim un tek un in natloa ka bel un kakan nas noan, “Hoe mi hii le! Auk natloa noan, kit totoang but kit ael-gandum mias se klapa dalen. Kon auk ale li dil lolo tuun. Mo mi ale las dil pukiun le todan se auk nenang nga.” Ming ela kon, un kakan nas seke taplaeng nol una. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Hidi kon oen kaing Yusuf noan, “Hoe! Ku bali noan ku le daid tuang le leka-tadu kami le?” Oen seke isi nol una, undeng un tekas un in natloa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Hidi nam Yusuf natloa pait. Kon un tek un kakan nas noan, “Hoe auk natloa pait. Auk ngat net lelo, bulan nol duun hngul esa. Totoang nas todan-lahing se au.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yusuf laok nahdeh un in natloa na bel un ama ka, nol un kakan nas kon, un ama ka kaing un mumuun noan, “In natloa na hnika ka elol na! Ku nangan noan auk nol ku inam mia, nol ku kaka-palim mas tia le lik ku iim ma le? Ku in koma kia!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tiata Yusuf kakan nas idus isi nol una. Mo un ama ka nangan nakekeon in natloa na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Oe mesan na, Yusuf kakan nas lolo-poa oen aman na laen nas, nol lae-blai las lakos lius dadani se iung Sikem. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Nesang lo kon, un ama ka tekan noan, “Usu! Ku kakam mas doh laen nol lae-blai dadani ne Sikem. Tiata ku mana-mana le laok ngat nanas le.” Kon Yusuf siut noan, “Banan papa!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Kon un ama ka tek noan, “Ku laok le ngat ku kakam mas, nol auk laen nas nol lae-blai las le. Oen elola liam, ku pait maa le tek au.” Hidi kon Yusuf lako nang soleng epe Hebron, le napiut lako lius se Sikem. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Lius se nua kon, un nuting oen pukiu epe ka. Kon un tutnaal atuling mesa. Atuling na ketan noan, “Ku nuting asii la?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusuf situn noan, “Baki, auk nuting auk kakang ngias. Oen poa laen nol lae-blai le nuting bluan dadani ne nia. Baki net one le?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Kon atuling na tek noan, “Oen ne ias lo son. Mo oen tek noan oen le lakos dadani nol iung Dotan.” Kon nam Yusuf laok muid un kakan nas, didiin un laok hapus se iung Dotan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Mo Yusuf bii kakatang ngam, oen ngat net un son. Kon oen aa nol apa, le keo tele una. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Oen tek apa noan, “Mi ngat nanan le. Tuang in natloa daat ta maa son nuan! ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ta maa le kit keo tele un tia. Hidim kit pasang soleng un lako se bolo ui hmate nu dalen. Maa liam kit tek paap noan hmukit huin nas kaa nuli un son! Halas-sam kit ngat un in natloa ngas le elola la?!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ming nal ela kon, un kaka Ruben nuting lalan le halin Yusuf mate deken. Kon un kaing palin nas noan, “Hoe! Kit keo tele un deken tia! ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Banan dui ka kit hutun tamang un lako se bolo ui hmate ni dalen tukun. Se maan nia lam ete tuun, tiata muik atuli in tana lo. Sadi taon le un dala deken.” Un tek ela, undeng un le sao Yusuf halin tadu le pait lako. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Nikit Yusuf lako lius se un kakan nas kon, oen kil una hidim oen bihit nal un kaod lekong nga. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Hidi nam, oen pel-lakang una, le hutun tamang lako se bolo ui hmate ka dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Hidi deng na lam, oen lakos daad le kaa. Oen kaa mamasu lam, suknahkitum oen ngat net atuli bua mes maa. Atuil buan nas unta las sakeng sa-saa in sepo-dakang, banansila el kai uin bui bingis, bumbu-bumbu, nol kai in taih ili bili-ngala. Taan lo molota buan in maang nas atuil Ismael, man maas deng iung Gilead, le lakos bus el maan katang, ne dale Mesir. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kon nam Yahuda tek un pail-kakan nas noan, “Hoe, kit keo tele una lam ambak ki saa la? Taon elola kon, kit buni nal in un mate ki lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tiata banan dui ka, kit laok hee soleng un bel atuil Ismael nuas. Kit tao un elol kon no, un niam kit palin in hua nabale. Ta kit tao un le iil deken!” Kon oen totoang tade muid un in teka na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Nikit atuil in sepo-dakang nas maa lakos deng na kon, Yusuf kakan nas pel sakeng un deng bolo ui hmate ka. Hidim oen laok hee un bel atuil Ismael las, nol osa ka duit muti buk dua. Hidi kon atuil Ismael las kil nol Yusuf lako Mesir. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Dedeng oen hee Yusuf fa, Ruben taan lo. Ta un pait lako se bolo ui hmate ka lam, un nahkiut isi, undeng Yusuf ne bolo ka dalen lo son. Kon un pius sait un kaod in se un apa ka ngas, undeng un dalen na iil isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Un pait lako se un palin nas, le tekas noan, “Idaah! Tana-ana ka ne bolo ku lo son! Auk taon elol lolen no?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kon nam, oen lolat tele laen mesa, hidim oen kat Yusuf kaod lekong nga, le dopon tamang lako se laen na dala ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Hidi nam oen kat kaod daal na, le kilan laok bel oen aman na, le tekan noan, “Papa! Kaim naim nal kaod nia. Olan paap tinang nanan le. Tamlom mo kaod ni paling Usu nena ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ngat net kaod na kon, Yakob tanan meman. Kon nam un siut noan, “Idaah! Ni meman baktebes auk anang nga kado la. Taan le hmukit huin nas pius tele un son se ola nia ka! Ida loo! Auk anang nga mate son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Hidi nam, Yakob pius sait un kado la, hidim pake seda karong kuning, undeng un dalen iil isi. Kon un lilu le kamusang un ana ka tutungus nesang isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Un anan biklobe nol anan bihata las totoang maas le mau-hanet una, mo bolen lo. Un tek noan, “Deken! Auk sus didiin mateng, ta auk nadidingun nal tana-ana mes ni lo.” Kon Yakob dalen na iil tutungus, undeng un nangan un ana Yusuf man in maet son na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Dedeng Yakob dalen na iil nabael ela lam, atuil in sepo-dakang ngas lakos lius se Mesir son. Hidim oen laok hee Yusuf pait bel atuling tene mesa. Un ngala ka Potifar. Un na mo lahing Mesir ra komendan in doha ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Hidi na kon, Yahuda lako nang soleng un pali-kakan nas, le lako daad nol un tapa Hira se iung Adulam. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Se na, muik blalan mesa, atuil Kanaꞌan, ngala Sua. Yahuda kom nol Sua ana bihata mesa, kon oen duas sapa. Hidi nam un hua aan biklobe at tiul mudi-muid apa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ana hmunan na, oen ngali ngala Er. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kon nam ana nomer dua la oen ngali ngala Onan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Hidim ana nomer tilu la, oen ngali ngala Sela. Dedeng hua Sela ka, oen lakos daad seda son se iung didang, ngala Kesib. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Dedeng ana hmunan in ngaal Er ra tene maa kon, Yahuda laok taam nodan belen tana-bihata mesa, ngala Tamar. Hidi kon oen duas sapa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mo Er na mo daat isi. Tiata Ama Lamtua hukung una, le belen mate. Undeng na le Er mate nol muik aan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kon nam Yahuda tadu un ana nomer dua la noan, “Onan! Ku kakam ma mate son, mo muik ana lo. Tiata tao muid atuil blalan nas in nuil-nola kam, ku musti seda ku kakam ma, le saap nol un sapa ka. Le halin nam ku hua-koet aan bel ku kakam ma.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan taan hadat na son. Mo un dai hua bel un kaka Er lo. Tiata eta un niin nol Tamar ram, un soleng un bini la, le halin Tamar behe lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onan in daek ela ka, tao Ama Lamtua koon-mali isi. Undeng na le, Ama Lamtua hukung tele un kon. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Nikit Yahuda net un anan nas duas in saap nol Tamar le mates sa kon, un lii. Un nangan noan, tamlom mo eta un ana hmudin Sela saap nol Tamar lolen nam, mam un mate kon na. Tiata un laok tek un nalen Tamar noan, “Auk anang. Banan dui ka, ku pait lako ku ina-amam muas tuun tia. Nang le eta auk anang Sela tene maa son, halas-sam ku pait maa le duam sapa.” Kon nam un nalen Tamar pait lako. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kaliut nal nesang buit kon, Yahuda sapa ka mate. Tiata un dalen iil nesang didiin leol in susang ngas hidis. Hidi kon un haman un tapa Hira, le oen duas lakos se iung Timna. Se na, atuli las mamo dit lae-blai las bulu ngas le hee. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kon atuli tek Tamar noan, “Ku bakim ma lako ne Timna, le nodan atuil halin laok dit belen lae-blai bulu kuas kon.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Dedeng na, Yahuda ana hmudin Sela tene son. Mo Tamar taan son noan, un bakin na dai belen saap nol Sela lo. Kon nam Tamar nuting lalan le tokan un hak ka. Ta un kolong pesang un kai-baut bebalu kas, le pake seda kai-baut leko. Un pake hlendang le buba un bon na nol sila ka. Hidim un lako daad se iung Enaim hnita tene ka, se lalan in taam laok bus el Timna ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Nikit Yahuda maa lako deng hnita tene na kon, un ngat net Tamar. Mo un bali le na bihaat hmama, lole Tamar naleko apa ka nini kai-baut leko, hidim un buba kele sila ka pait tam. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yahuda taan dadale lo noan bihatang na un nalen na. Tiata un lako dadani bihatang na, le ketan noan, “Hoe! Eta auk nol ku lam, ku nodan bakun na.” Mo Tamar situn noan, “Tia ka! Na ne ku in koma ka tukun.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yahuda nukin noan, “Eta auk bel ku laen mesa lam, elola la?” Kon Tamar siut noan, “Banan! Sadi ku bel auk sa-saa mes le auk kil tahang. Didiin ku tunang bel auk laen na.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Kon Yahuda ketan pait noan, “Auk bel ku asa le ku kil tahang nga?” Tamar siut noan, “Ku pesang hmarat in loen nol talin mo ku leom ma ka. Nol pesang ku hnikan na kon.” Ming ela kon, Yahuda kat sa-saa nas le belen. Hidi kon oen duas laok ninis nol apa. Hidi nam, Tamar pait le kolong un kai-baut leko las nol un hlendang nga, le pake pait un kai-baut bebalu kas. Taan lo molota, Tamar behe son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Nesang lo kon nam, Yahuda nodan un tapa Hira noan, “Ku kil laen ni bel bihatang hmama in ne Enaim mua, le sium pait auk sa-saa man un in kila ngas.” Kon Hira boka lako ua, lako lius se lua kam, un nuting lako-pait mo tutnaal bihatang na lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Kon un ketan atuli-atuil in se la ngas noan, “Hoe! Mi net bihaat hmama man tao lam daad se hnita tene ni kia, tam lo ka? Un ne ola ke?” Mo oen siut noan, “Se ia lam muik bihaat hmama lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tiata Hira pait lako Yahuda lua. Un tekan noan, “Auk tutnaal bihatang na lo. Auk nuti-nuting una, mo atuil in ne ua nguas tek noan, se dale nua lam, muik bihaat hmama lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Kon Yahuda siut noan, “Elam nang sa-saa nas le un pakes tuun tia! Sadi atuli tao nahmaeng kit deken! Ta auk le baen son, mo kit tutnalan lo kam.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kaliut nal bulan tiul kon, atuli laok tek Yahuda noan, “Ku nalem Tamar ra tao apa ka daid bihaat hmama son. Halas ni un behe.” Ming ela kon, Yahuda koon-mali isi. Hidim un lok atuling na noan, “Laok pel nol bihatang na maa, le loe un kukuli.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Kon nam oen laok pel nol Tamar. Mo un kat puting hmarat ta nol hnikan na. Hidim un lok atuli las laok tek un bakin na noan, “Ama tulung tinang naan sa-saa nias le. Hmarat nol hnikan ni lamtua ka, man tao auk le beheng nia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Tinang sa-saa nas kon, Yahuda tadas tanas meman, noan un nena. Hidi kon un tek noan, “Baktebes! Bihatang na kula lo. Auk man kula kia. Un man toma noan, auk musti belen le saap nol auk anang Sela lia. Mo auk man dai tao lo, le sao un lako tuun ela!” Hidi kon, Yahuda nakbua pait nol Tamar lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar oras in hua ka maa lius kon, un hua aan hduan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Dedeng un hua ka, ana mesan na puting un ima ka. Kon blalan im-blingin na butun nini bung mea se un ima ka. Hidim tek noan, “Ni aan hmunan na.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mo tana-ana na pel pait un ima ka. Hidi nam un tapa ka man puti muna lolen. Kon im-blingin na tek tana-ana na noan, “Hah! Meman ku nia mo kuat to! Lole ku dising le puti muna kam!” Ti oen ngali tana-ana na ngala Peres (man nahin na noan, ‘dising le puti’). ");
INSERT INTO hegNTpo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Hidi halas-sam un palin in but bung mea ka puti. Kon oen ngali un ngala Sera (man nahin na noan, ‘mea kaloe’). ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","2","Dedeng atuil Ismael las kil nol Yusuf lako Mesir, le hee bel atuling tene in ngaal Potifar ra, un tade le sos Yusuf. Un na mo tulu deng totoang soldadu man in doh se lahing Mesir ra um lahi la ka. Hidi kon Potifar sos Yusuf deng atuil in sepo-dakang ngas, le taon daid ata se un uma la. Se la, AMA LAMTUA tulung Yusuf didiin totoang sa-saa un in dake-mana ngas dadis nol babanan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Un tuang Potifar net Yusuf in dake ka banan isi ela kon, un taan parsis noan AMA LAMTUA tulung Yusuf. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Tiata tuang nga kom Yusuf isi, nol parsai una. Kon nam un nikit Yusuf le daid bon se un uma la. Un kon bel Yusuf le mana-koet un uma la, nol un hmuki-pusakan nas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ninin deng Yusuf in daek se la ka, Ama Lamtua kon bel hangun mamo-mamo se un tuang, atuling Mesir ra. Un uma isin nas, un pusaka las, un klapa las, nol un in dake ngas totoang daid banan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Nikit Potifar tinang ngam Yusuf in dake ngas totoang banan kon, un nanga-nangan saa pait lo, un in tana ka suma kaa-niun tukun. Dedeng na, Yusuf uih-leok isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Un daad se la nesang isi lo bii, mo Potifar sapa ka dalen nahi nolan son. Kon un hanet Yusuf le oen duas niin nol apa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mo Yusuf dai tao lo, le tekan noan, “Ela deken mama! Ta auk tuang Potifar bel auk kuasa le mana-koet osa-lalan nas totoang son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Se um nia, muik atuli mes lo kon man kil kuasa muun dui deng au. Ta tuang parsai auk son le mana-koet nias totoang. Mo suma maam sii, man lo. Taon elola le auk tao dadaat ela la! In tao ela ka kon, labang nol Ama Lamtua Allah in koma ka!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Mo ela kon no, neot mesan na Potifar sapa ka hanet Yusuf tutungus. Mo Yusuf tao hii un lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Kon nam oe mesan na pait, Yusuf taam lako uma dalen le tinang un in dake ngas. Leol na, muik atuil didang se uma la lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kon un tuang nga sapa ka maa le hep Yusuf kado la, hidim pelan le tekan noan, “Maa tia! Ta kit duat siing son nian. Maa le kit duat laok niin nol apa tia.” Mo Yusuf dai tao lo. Hidim un hukun, didiin un kado la kuis. Kon un lail puti. Mo bihatang nga kil napiut un kado la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Nikit Potifar sapa ka ngat tam Yusuf lail puti, nol nang un kado la kon, ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","un haman atuil in dake ngas le tekas noan, “Hoe! Mi maa ngat le. Apin biklobeng Ibraning na tama se auk kamar ra. Un le tao dadaat saol au, mo auk ahan mumuun. Nian un nang soleng un kado la, le lail puti. Auk sapang ngi, un kil nol atuling hadat lo ni le tao nahmamaeng kit tukun!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Kon Potifar sapa ka kil kaod na didiin Potifar pait uma. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Un sapa ka pait maa kon, un nahdehen noan, “Papa! Atuling Ibraning man paap in kil nolan maa se nia ki, apin un tama se auk kamar ra son, le noan tao didaan au. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mo auk ahan mumuun le haman atuli las. Ta un haung lali ilang nang soleng un kado la nia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ming un sapa ka dehet ela kon, Potifar koon-mali isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Kon un tadu atuli las laok daek Yusuf. Hidim oen tamang Yusuf lako se lahing nga bui ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mo AMA LAMTUA nadidingun Yusuf lo, le tulung napiut una, didiin tulu deng bui ka kon, kom Yusuf isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Hidim un bel Yusuf kuasa le doha-tinang atuil bui kas totoang, nol parsain le mana-koet os in se na ngas totoang kon. ");
INSERT INTO hegNTpo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Tiata tulu deng bui ka bon iil nol in mana-koet sa-saa in se bui daleng ngas pait lo. AMA LAMTUA tulung napiut Yusuf, didiin totoang in dake se bui na daleng ngas, daid banan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Se bui na, muik tulu at dua man mana-koet net se lahing Mesir ra um lahi la. Mesan na, mana-koet lahing nga in ninu ka. Mo mesan na pait, mana-koet lahing nga ruti la. Oen duas tao sala saol lahing nga. Undeng na le, lahing nga koon-mali, didiin un tamang oen duas lakos bui dalen. Tiata oen duas buan se kamar mes nol Yusuf. ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Hidim tulu deng bui ka lok Yusuf le mana atuil dua nas. Oen se bui dalen didiin taun ila lo, nesang buit. ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Duman mesan na kon, tulu at dua nas natloa. Mesa-mesam nol un in natloa. In natloang nas kon nahin bakisa-bakisan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ola ka kon Yusuf maa, ti un tinang ngam oen duas silan nas saek lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Kon un ketan oen noan, “Tasao le leol neot ni mi silan nas saek lo ela lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Kon oen siut noan, “Sian kaim natloa. Mo kaim taan un nahin na lo.” Hidim Yusuf tek noan, “Muik tahan atuli mes lo kon man taan in natloa ngas nahin na, suma Ama Lamtua Allah sii. Olan mi dehet napat le. Maa liam auk nuting un nahin na deng Ama Lamtua.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kon nam atuling man mana bel lahing nga in ninu ka nahdeh noan, “Elia! Se auk in natloa ka dalen, auk ngat net anggor ina mesa, ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","muik bango tilu. Anggor ina na klehen, bungaꞌ, nol isin salat-salat didiin latu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Hidim auk tinang ngam, auk kil lahing nga klas in ninu ka. Kon auk kat anggor ra isin na, le lee un uin na laok se lahing nga klas sa dalen. Hidi nam auk tunang bel lahing nga le ninu.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ming ela kon Yusuf tek noan, “Papa. In natloa na nahin na elia: bango tiul nas un nahin na noan lelo tilu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nate lelo tilu lam lahing nga maa puting paap deng bui ni dalen. Hidim un nikit paap pait, le mana-koet in ninu banansila el hmunan nua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Eta paap ulat banan ela son nam, nadidingun auk deken ne? Eta paap namnau au lam, tulung tek lahing nga le un puting auk kon deng maan ni le? ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Eta muid un in toma ka lam, oen kat auk nol in dising deng auk atulin Ibrani las ingu. Se ni kon, auk tao dadaat saa lo. Taan lo molota oen tamang auk son ne bui ni dalen, banansila el auk niam atuil daat.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ming nal in natloa na nahin na in banan ela ka kon, atuling man in mana-koet ruti ka nahdeh Yusuf noan, “Pali! Auk kon natloa elia: auk tilung fai hnoed tilu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Se fai dapa dui la nisi lahing nga kukis sas bili-ngala. Mo tilu-kee kas maas le kaa nuli kukis in se auk bong ngi dapang nas.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ming ela kon Yusuf siut noan, “Paap in natloa ka nahin na elia: Fai tiul nas un nahin na kon lelo tilu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Se leol tiul nias dalen, mam lahing nga tadu atuli maa dait nutus paap bon na. Hidim oen tai paap apa ka se sanga dapa. Kon tilu-kee kas maas le kaa nuli paap boa ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Nal lelo tilu, tom nol lahing nga leol in hua ka, kon un tao fesat tene bel un atulin in dake ngas totoang. Un leka, le laok puting tulu at dua nas deng bui ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Hidim un nikit pait atuling in mana-koet lahing nga in ninu ka, le kil pait un os hmunan na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mo atuling in mana-koet lahing nga ruti la ka, oen tai tele, banansila el Yusuf in teka ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Mo atuling man mana-koet in ninu ka, nangan net Yusuf pait lo. Un nadidingun soleng Yusuf son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Hidi taun dua kon, lahing Mesir ra haup in natloa. Un natloa noan un dil se palun Nil la suut ta. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Nahkitu lam, un ngat net aus-sapi iut apan nas banan isi. Oen bulang ngas kaloe. Oen putis deng palun na, le kaa bluan se na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Hidi nam, muik aus-sapi iut didang pait, putis deng palun na. Oen apan nas daat le seen sii. Oen dil dadani nol aus-saip in apa banan nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Hidi kon aus-saip aap daat tas hol nuli aus-saip aap banan nas. Kon nam lahing nga nahkitu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nesang isi lo kon, un niin nala, ti un natloa pait. Un ngat net ael bulin iut isin putis deng ina mesa, man obon ana lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Hidim un ngat net pait ael bulin iut aha sii bloen son, undeng oen tom angin otot. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kon ael bulin iut man aha sii ngas, hol nuli ael bulin in muik isin nas. Hidi kon, lahing nga nahkitu le hangu. Halas-sam un tana noan, un natloa pait. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Oskaong nga kon, lahing nga nangan nam banan lo. Kon un lok atuli las laok taap totoang blipa, nol atuli in tana se dale Mesir ras. Hidim un nahdeh beles un in natloa ka, mo muik tahan in taan natloa na nahin na lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ela halas-sam, atuling in mana-koet lahing nga in ninu ka, nangan net Yusuf. Kon atuling na laok tek lahing nga noan, “Ama lahi! Auk musti hao noan auk kula son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Hmunan nua, dedeng paap komali nol au, nol auk tapang nga le tamang kaim se bui dalen na, ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","duman mesan na kon, kaim duam natloa. Mesa-mesam nol un in natloa, nol un nahin nas kon bakisa-bakisan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Se bui ku dalen, muik atuling muda mesa, atuil Ibrani. Tulu deng bui ka nikit un le daid tulu in mana-koet se bui kua. Kaim nahdeh kaim in natloa ngas bel una. Kon un tek kaim in natloang nas nahin na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Tiata ama lahi nikit ulang auk pait. Mo auk tapang nga tom in hukung tele. Totoang nas dadi, banansila el atuling Ibraning nga in teka ka!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ming ela kon, lahing nga tadu atuli laba-laba laok taap Yusuf se bui kua. Kon nam Yusuf laok mana apa ka niu-niu, le seda un kai-batu las, hidim bok lako taal lahing nga. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Un lako lius kon, lahing nga tekan noan, “Pail ana, auk natloa! Mo muik tahan atuli mes lo kon, man taan in natloa na nahin na. Mo muik atuli tek auk noan, ku bisa tek puting bel aun.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Kon Yusuf siut noan, “Ama lahi, auk kon taan saa lo. Suma Ama Lamtua Allah sii, man taan le tek puting in natloa na nahin na. Taon elola ko, Un le tek dais banan bel ama lahi.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Hidi kon lahing nga dehet noan, “Se auk in natloa ka, auk dil se palun Nil suut ta. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Kon muik aus-sapi itu, apan nas banan ana lo, nol oen bulang ngas kaloe. Oen putis deng palun na, le lakos kaa bluan se palun na suut ta. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Hidi kon muik aus-sapi iut didang pait maas. Mo aus-saip nas apan nas daat le seen sii. Se dale Mesir ria, auk net aus-saip in apan daat ela lo bii! ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Mo auk herang isi! Undeng nahkiut tuun nam, aus-saip iut aap daat tas hol nuli aus-saip iut in apa banan nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Oen hol nuli aus-saip aap banan nas, mo oen apan nas daat keko lako. Hidi kon auk nahkitung. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Hidi nam, auk niin nalang pait, kon auk natloa pait. Auk ngat net ale buil itu, isin nas inu-inu puti deng ina mes man nuli ka obon isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Hidim auk ngat net pait ale buil itu, beas ase, aha sii nol bloen tuun, lole tom angin otot tam. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kon nam ael aha iut nas hol nuli ael man beas inu ngas. Hidi na kon, auk nahkitung. Auk nahdeh in natloa ni se atuil in tana ngas son. Mo muik tahan at mes lo kon, man tek puting nal bel auk in natloa na nahin na.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kon Yusuf tek noan, “Ama lahi. In natloa dua nas nahin mes sii. Ama Lamtua Allah tek ama lahi meman son, deng asa man Un le dake ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","In natloa na nahin na elia: aus-saip iut man apan banan isi ngas, nol ael buil iut man isin inu ngas nahin na noan, muik oras liis-lasa taun itu. Oen nahin na mes sii. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Hidim aus-saip man apan daat le seen sii ngas, nol ael buil iut man aha sii ngas, nahin na noan, oras lubu taun itu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Tiata Ama Lamtua Allah tek meman, asa man Un le daken na. Na banansila el asa man apin auk in teka ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Mam kit haup oras in liis-lasa taun itu, se totoang ingu-iung in se dale Mesir rias. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Hidi nam, kit haup oras lubu lako pes taun itu. Mam oras lubu na muun isi. Didiin muik in kaa lo tetetas se dale nia. Totoang atuli li lubus isi, didiin oen nangan net oras in liis-lasa ka pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Tiata, ama lahi in natloa oe dua na, nahin na noan, Ama Lamtua Allah dake-mana meman ela son. Nesang lo ka kam, asa man Un in mana son na, dadi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Undeng na, le auk muik in nangan elia: banan dui ka ama lahi nuting atuil in tana mesa, man mana-koet taan nol babanan. Hidim nikit un le doha-tinang dale Mesir nol babanan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Nol banan dui ka, se oras in liis-laas taun itu ka, ama lahi nikit atuling mes didang pait, le oen dulu nakbua in hapu ngas mamamo. In hapung mamo nas, oen bating op lima, le pesang op mesan na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Oen musti daek muid ama lahi in prenta ka, le oen dulu ale-ael deng papmes ingu-iung in se Mesir rias. Hidim oen musti pesang ale-ael nas se mana-maan in pesang ngas, le dohas babanan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Le halin nam taun iut lubu kas maas lisu lam, kit muik in kaa nabale. Eta taon ela lam, muik tahan atuli in mate, undeng hmatu in nala lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ming Yusuf in aa ela ka kon, lahing nga nol un atulin tene in se um lahi la ngas tade muid Yusuf in teka na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Hidi kon lahing nga tek noan, “Ama Lamtua Allah Koo Niuꞌ ka leo-leo nol Yusuf. Tiata bet kit haup atuil didang pait man banan dui deng un lo ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Hidim lahing nga aa nol Yusuf noan, “Ama Lamtua Allah tek totoang nias bel ku son. Halas-sam kaim tana noan, ku niam atuil in tana. Nol ku in nuting lalan na banan dui deng atuli li totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tiata nol nia, auk nikit ku le daid auk imang kanan. Le halin nam auk hutun nias totoang hii muid se ku in leka ka. Suma auk siing man lapa dui deng ku.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Hidi na kon, lahing nga kolong puting un paa hmarat ta, le nae tamang lako se Yusuf hnanga ka. Hidim un tek noan, “Nini nia, auk nikit ku le daid auk imang kanan se papmes dale Mesir ria.” Hidim un pake bel Yusuf kaod blatas duda mesa, nol lotong belen ranteng mea mes laok se un leo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Hidi nam, un bel un kereta ahloet nomer dua la, le Yusuf saken. Muik atuli in lail muna se hmunan deng kereta la, le haman tek noan, “Hoe! Sai lalan na! Le todan! Ta muik atuil tene mes le maa lako deng nia.” Nini in tao ela ka, lahing nga nikit Yusuf son le daid un ima kanan se dale Mesir. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Lahing nga tek Yusuf noan, “Elia! Ku tanan meman son noan, auk niam mo lahi. Mo auk tek totoang auk atulin in se dale Mesir rias son noan, eta ku bel dola lo kam, oen boel tao saa lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Hidi nam, lahing nga ngali Yusuf ngala ka, Safnat Panea, muid atuil Mesir ras ngalan. Un kon tapa bel Yusuf sapa-bihata mesa, ngala Asnat. Yusuf bakin na, ngala Potifera. Un nam tulu agama se kota On. Nini ela lam, Yusuf daid atuil tene se dale Mesir. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Dedeng oen nikit Yusuf fa, un umur taun buk tilu. Kon nam un laok papmes le tinang totoang mana-maan in se dale Mesir ras. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Se taun iut in liis-lasa ngas, klapa-klapa las puting isin mamo lai-lisi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Hidi kon Yusuf tadu ima-ii las le laok tao nakbuan isin in lai-lising nas le pesang. Ale-ael lai-lisi man oen hapus se kota ola lam, oen pesang se um in dulu deng kota na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Didiin ael man oen in dulu nakbua ngas mamo isi. Banansila el hlaen in ne tasi suut tua, didiin muik atuli in sukat nalas pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Oras lubu ka maa lius lo bii kam, Yusuf sapa Asnat hua ana biklobe at dua son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Kon Yusuf tek noan, “Ama Lamtua Allah tao auk le auk nadidingun in susa-daat, se dedeng auk in puting deng auk amang nga uma la ka son.” Undeng na le, un ngali un ana hmunan na Manase, (man nahin na noan ‘nadidingun’). ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Dedeng un haup ana nomer dua la kon, un aa pait noan, “Auk haup in susa-daat se maan ni son. Mo Ama Lamtua Allah bel auk hangun, le auk haup tana-ana ni son.” Kon un ngali tana-ana na, Efraim. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Hidi na kon, oras in liis-lasa taun itu las hidis. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Kon oras lubu taun itu la maa lius lolen, tom nol asa man hmunan nu Yusuf in tek hidi son na. Se nusa-nusa didang nguas kon, atuli las lubus son. Mo se totoang mana-maan in se dale Mesir ras muik in kaa nabale. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Nesang lo kon, atuil Mesir ras tom lubu. Kon oen lakos nodan in kaa se lahing nga. Kon lahing nga tadu oen lakos se Yusuf, le muid un in prenta ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Mo oras lubu na muun keko sake, didiin se totoang mana-maan in se Mesir ras kon tom lubu. Kon nam Yusuf sai maan in pesang ale ngas totoang, le hee ael bel atuil Mesir ras. ");
INSERT INTO hegNTpo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Hidi nam muik atuli deng ola-ol tuun, maas le sos in kaa deng Yusuf, se Mesir. Undeng oras lubu na muun isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Dedeng na, ama Yakob ming atuli tek noan, ale muik ne Mesir, kon un aa nol un anan nas noan, “Ana me! Tasao le mi daad langan tuun eli lia! ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Auk ming son noan, ne Mesir muik in kaa. Tiata banan dui ka, mi laok sos in kaa se lua, le halin nam kit mateng un hmatu deken.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Kon nam, Yusuf kakan nas hngulus mana-mana le laok sos in kaa se Mesir. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mo Yakob dai bel Yusuf palin hmudin Benyamin, le laok baab lo. Lole un nangan noan, “Tamlom mo tana-ana na laok kon un tutnaal in daat pait ta.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Undeng atuli li se ola-ol ming son noan, muik in kaa ne Mesir, tiata muik atuli mamo laok sos in kaa se nua. Oras lubu ka kon lako lius se dale Kanaꞌan. Ta Yakob anan nas kon lakos muid le sos in kaa se lua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Dedeng na, Yusuf daid lahi nga ima kanan se Mesir son. Eta atuli deng ola-ol maa le sos ale lam, Yusuf man hee beles. Undeng na le, dedeng un kakan nas maas lius kon, oen laok hai bukun nas didiin oen silan nas lakos huud se dale, le todan una. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Nikit un tutnaal oen kon, un tanas meman. Mo Yusuf tao apa ka banansila el atuil Mesir ra, tiata oen taan un lo. Hidim un ketan oen nol in komali noan, “Mi niam deng ola?” Oen siut noan, “Kaim deng Kanaꞌan. Kaim maa nodan le sos in kaa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Kon Yusuf nangan net un in natloa hmunan nua ka. Tiata un tao liing oen noan, “Auk parsai lo! Taon elola ko mi totoang niam mata-mata. Mi maam le nuting dale Mesir sa-saa man atuil didang boel tanan lo kas, hidim hobalin le keng nol kami, ta lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Mo oen siut noan, “Lo tuang! Kaim niam suma tuang atulin in loka-loka tuun. Baktetebes kaim suma maa le sos in kaa tukun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kaim totoang niam aman mesa. Kaim niam atuil mata-maat lo, tuang! Kaim atuil banan.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Mo Yusuf aa nol in komali muun dui pait, noan, “Hee! Nole deken! Boel nole auk deken! Meman mi niam mata-mata. Taon elola ko, mi maa le nuting halin taan sa-saa man atuil didang tanan lo, deng dale nia!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Hidim oen kaen noan, “Loo tuang! Kaim niam suma tuang atulin in loka-loka tukun! Kaim maam deng dale Kanaꞌan. Kaim pali-kaka, at hngul dua. Kaim totoang amans mesa. Kaim palin hmudin na dada nol kaim aman na. Nol kaim palin mes pait ase son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Hidim Yusuf hobalin siut noan, “Loo! Apin auk in teka ka toma. Meman mi niam mata-mata. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Eta lo kam! Mi bel auk taad napat le, halin auk taan mi in teka apin na meman baktetebes ela, tam lo ka. Auk sumpa! Eta mi palin hmudin na maa se ia lo kam, mi boel laok lail dadai dale ni lo! ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tiata mi huil nal at mesa, le laok taap mi palin hmudin na, le maa se nia. Tenga lias auk tahang se ias. Auk le ngat naan mi in aa na baktebes tam lo ka. Etan lo kam, meman mi niam baktebes mata-mata.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Hidi nam Yusuf tadu, le tahang oen se bui dalen lelo tilu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Leol tilu la kon, Yusuf laok aa nol oen se bui dalen noan, “Auk niam atuil man in lii Ama Lamtua. Nol taom auk daek muid Un in koma ka tutungus. Le halin nam mi nulim, banan dui ka auk sao mia. Mo muik in leka mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Eta mi aa nahlololo lam, mi musti tulu bel auk tada mesa. Un lalan na elia: auk tahang at mes se bui ki dalen. Tenga lias pait le kil in kaa bel mi nenan nuas. Ta oen natang mi in pait le kil in kaa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Hidim mi kil nol mi palin na maa, le daid tada noan, mi atuil in aa kam nahlololo. Le halin nam, auk hukung tele mi deken.” Ming ela kon, oen tade mudi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Hidim oen aa nol apa noan, “Halas ni kit haup in balas deng kit in kula-sala hmunan nua ka lolen son nia, man kit daken son nol kit palin na. Kit net un in sus isi ka son, didiin un nodan tulung, mo kit hosek nolan lo. Undeng na, le halas ni kit haup susa-daat elia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Hidim Ruben tek nuting oen noan, “Hoe pali me! Hmunan nu auk kaing mi son, le boel tao saa tana ka lo, ta lo? Mo mi ming tahan auk in teka ka lo. Tiata halas ni kit lepa-haal Yusuf in mate ka son nia mo!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Oen aa nol apa ela, mo oen taan lo noan Yusuf kon taan oen dasi la. Undeng dedeng Yusuf aa nol one ka, un aa nini dais Mesir, hidim atuli bali beles pait lako se dais Ibranin. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ming oen aa nol apa ela kon, Yusuf hangu nang soleng one, le un sii lako lilu siing-siing se maan didang. Un lilu hidi kon, un pait lako se one la. Hidim un tadu atuli le but Simeon se un kaka-palin nas silan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Hidi nam, Yusuf lok un ima-ii las, le nisi ael se un kakan nas karong ngas. Hidim nisi tamang pait oen duit tas mesa-mesa, se oen karong ngas bahan nas. Un kon tadu le beles in kaa se lalan. Kon ima-ii las daek muid Yusuf in leka ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Hidi na kon, Yusuf kakan nas sakeng ael karong ngas laok se oen keledai las dapa, le pait. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Se lalan hlala kon, oen teen in kae. Kon at mes deng one la loat un karong nga talin na, le noan nalo un keledai la. Mo un ngat tam un duit in sos ale ka se karong nga dale. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Un nahkiut isi! Hidim un haman un pail-kakan nas le tekas noan, “Idaah! Mi maa ngat ni le! Ta kit daat son nia! Oen bel pait auk duit ti ne auk karong ngia.” Net ela kon, oen lii isi. Hidim oen tek apa noan, “Ama Lamtua Allah tao saa pait nol kit son nia?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Hidi nam oen laok napiut. Lius se Kanaꞌan kon, oen nahdeh oen aman na deng totoang asa man in daid nol oen son na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Oen tekan noan, “Papa! Lahing Mesir ra ima kanan na, banan lo isi. Un in aa ka tuun kon daat isi. Un tudu kaim daile, kaim laok mata-maat un dale kua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Mo kaim siut noan, ‘Ela lo! Kaim aa nahlololo. Kaim niam mata-maat lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Kaim atuil babanan. Kaim naim kaka-pali at hngul dua. Kaim amans mesa. Suma mes ase son, nol hmudin hesa ka, dada nol paap ne Kanaꞌan.’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Hidim un kon tek noan, ‘Auk le ngat soba-naan mia, le mi nole tam lo ka! At mes deng mia li musti dada se ia. Tenga las pait, le kil ael bel mi nenan nuas, le halin nam oen mates undeng hmatu deken. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Mi musti kil nol mi palin na maa le, halas-sam auk tana noan, mi niam mata-maat lo, mo meman baktebes mi atuil lolo. Eta ela lam, auk sao bel mi kaak-palin man auk in tahang ngia. Nol auk bel dola, le mi laok se ol tuun, se dale nia.’” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Nahdeh hidi kon, oen bok oen karong ngas nol isin nas. Nahkitu lam, oen mesa-mesam net oen duit tas muik nabael se oen karong ngas dalen. Net ela kon, Yakob nol un anan nas lii isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Hidi nam, Yakob aa nolas noan, “Mi niam tao ilang auk anang ngias tukun. Yusuf ase son. Hidim Simeon kon ela. Halas ni mi kon le kil nol Benyamin lako lolen? Mi le tao sus auk baktetebes!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Kon Ruben aa nol un ama ka noan, “Papa! Sao Benyamin bel au. Ta auk man lepa-halan nia. Auk hida, le auk nolan pait maa bel papa. Mo etan lo kam, nang le paap keo tele auk anang bikloeb at dua las.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Mo Yakob aa pait noan, “Boel ela deken! Mi boel kil nol Benyamin laok lo. Ta un kaka Yusuf mate son. Halas ni liis un sii son. Eta un kon tom in daat se lalan hlala kam, mi tao sus taplaeng au, le auk bong ngi iil didiin auk mateng, le tamang bolo dalen.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Dedeng na, lubu se Kanaꞌan muun sasaek tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yakob nol un nenan nas kaa nuli ael man lelon na un anan nas in kil maa deng Mesir ra son. Kon nam un tek oen noan, “Ana me! Banan dui ka mi pait lakom Mesir, le sos kit ael pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Mo Yahuda siut noan, “Papa! Lelon na, lahing Mesir ra ima kanan na hid muun nol kaim son noan, kaim boel laok tulu silan se un lo, eta kaim nol paap ana hmudin Benyamin lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tiata paap musti sao adi Benyamin, le lako leo-leo nol kami. Halas-sam kaim tade, le laok sos in kaa bel papa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mo eta paap sao adi Benyamin le laok baab lo kam, kaim kon laok lo. Ta atuling Mesir ra tek ela son nam.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kon Yakob kaing oen noan, “Hoe! Tasao le mi tek atuling na noan mi palin muik at mes pait tia? Mi nuti-nuting le tao sus taplaeng auk tukun!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Kon oen hanet un noan, “Papa! Atuling na ketan tutungus, le nuting halin taan kaim pail-kakan nias totoang ngam. Un ketan noan, ‘Elola, mi aman na nuli nabale le? Mi muik palin bikloeb didang pait tam lo ka?’ Lam kaim le tek elol pait ta! Tiata kaim aa nahlolool tukun son na. Le asii taan noan un tadu kaim le kil nol kaim palin ni laok se nua la?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","9","Kon Yahuda aa taplaeng pait noan, “Papa! Sao adi Benyamin le nol kaim lako. Auk hida, le eta daid saa nol una lam, nang le auk man lepa-halan nia. Eta auk nol pait un maa kukuli se papa li lo kam, nang le paap sakeng bel auk kula-sala ka, didiin auk mateng. Tiata paap sao un bel kaim tuun tia, ta kaim le laok son nia. Banan dui ka kaim laok nol lalaba tia, le halin muik in mate undeng hmatu deken. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Eta kaim natang nesang eli lo kam, bet kaim lakong le pait maang lalis dua son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Hidi kon oen aman sa tek noan, “Eta ela lam, mi tao eli tukun. Laok kat kit dale ka in puting isin banan dui ngas. Banansila el: uin pani, bumbu-bumbu, kai bui bingis uin, mina in taih ili, kenari, nol bula-bul didang ngas. Hidim kil bel lahing nga ima kanan na, le tekan noan, sa-saa nias kaim kilas bel ama tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mi kon kil pait duit mamon oe dua, undeng mi musti bel pait duit man lelon mi hapun se mi karong ngas sa. Bet atuil nas man nisi kula na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mi kon kil nol mi palin nia, mo hlapat le pait te! ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Auk nodan-nodan le Ama Lamtua Allah man Kuasa Muun Dudui ka, tao lahing Mesir ra ima kanan na, le un namnau mia. Halin nam un tade le bel pait Benyamin nol Simeon, le mi pait maam leo-leo. Mo eta noan auk anang ngias musti ilang ngam, nang le auk man lepa-haal in susa-daat ni napiut tuun tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Hidi nam, oen lakos mana nakbua sa-saa in kil beleng nas nol duit tas, le bok lakos Mesir. Oen kon kil nol Benyamin. Lako lius se luas kon, oen lakos ngada se Yusuf fua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Nikit Yusuf ngat net Benyamin nol un kakan nas kon, un lok tulu in mana-koet ta noan, “Hoe! Nol atuil nias lakos auk uma lua! Hidi kam ku laok keo aus-sapi mesa, le hosan fala babanan. Ta hidim auk kaa leol-ditun ni leo-leo nol one.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kon nam tulu in mana-koet ta daek muid Yusuf in loka ka, le nolas lakos Yusuf uma. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Oras oen lakos bus el Yusuf uma lua ka, un kakan nas lii naseke. Lius se lalan hlala kam, oen aa nol apa noan, “Hoe! Tasao le un tadu nol kit maa se ni lia? Tamlom mo un le tao sus kita, undeng duit man oen in nisi pait se kit karong ngas sa la. Oen hlak le nol kit maang se nia, le hidim nahkitu lam oen daek kita, le tao kit daid ata taung una. Hidi halas-sam oen nuhu-dau nal kit keledai lias totoang.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Undeng na le, nikit oen lakos dadani nol Yusuf uma la kon, oen aa nol tulu in mana-koet ta noan, ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Kaim nodan ampong, ta lelon na kaim maa sos net in kaa se lia son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Dedeng kaim pait lakom kaim ingu lua ka, kaim tenem se lalan le ninim tahang. Kon kaim loat karong ngas le noan nalo kaim hmukit tias sam, taan lo molota kaim haup pait kaim duit tas mesa-mesa, se kaim ael karong ngas dalen. Kaim tanan lo, le asii man nisi tamang pait lakos se na lia! Mo kaim kil pait duit tas totoang son ne nia. Tiata kaim nodan le komali deken ne. Kaim kon kil duit didang pait ne nia, le sos in kaa pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kon nam tulu in mana-koet ta siut noan, “Mi ete-ete tuun! Boel lii deken! Ta bet mi Lamtuan na man bel mi hangun se mi karong ngas dalen na. Lelon na auk sium mi duit tas totoang son. Mi muik hningin lo!” Un kon sao puting Simeon bel one. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Kon oen totoang taam lakos se Yusuf uma. Hidim tulu in mana-koet ta kat beles ui le boe oen iin nas niu-niu. Un kon nalo bel oen keledai las. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Hidim un tekas noan, “Hidim mi kaa leol-diut leo-leo nol tuang.” Oras oen nata-natang Yusuf in maa ka, oen mana meman oen sa-saa in kil bele ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusuf maa lius kon, oen totoang hai bukun se un sila ka. Hidim oen doong belen sa-saa man oen in kil bele ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Kon Yusuf ketan oen noan, “Elola, mi totoang bana-banan ne? Elol nol mi aman man in blalan son na, un kon bana-banan tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Oen siut noan, “Tuang ata in blalan son, man kaim aman in hua ka, bana-banan tuun.” Kon oen bubu le todan ulang un pait. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Hidi na kon, Yusuf ngat papmesas, ti un ngat net un palin Benyamin. Oen duas nam ina-aman mesa. Kon un tek noan “Eee! Mi palin man hmunan nu mi in dehet son na, nia ke?” Hidim un aa nol Benyamin noan, “Pail ana! Auk nodan-nodan le Ama Lamtua Allah bel hangun mamamo se ku.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusuf namnau Benyamin naseke, ta nikit un ngat net Benyamin kon, un tahang nal un dalen lo son. Kon un lalaba haung boka nang soleng one, le taam lako se un kamar ra. Hidim un lilu le nang-hkidun se kamar na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Lilu hidi kon, un lako laul sila ka. Un tao teken un dalen na, le puit lako tutnaal nolas pait. Hidim un lok un ima-ii las le laok mana mija las. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Oen todo bel Yusuf in kaa se mija mes kisa. Un kaka-palin nas kaa se mija mes didang. Un ima-ii atuil Mesir ras kon kaa se oen mija esa. Undeng atuil Mesir ras nikis in daad le kaa leo-leo nol atuil Ibrani las. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Tulu in mana-koet ta mana hidi son, le Yusuf kaka-palin nas daad saol nol Yusuf. Un tapa oen le mesa-mesam daad muid oen umur ras, deng aan hmunan hesa ka, lako pes pail hmudin na. Oen ngat net maan in dada ngas manas ela kon, oen herang isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Hidim Yusuf lok un ima-ii las, le oen kat bel un pali-kakan nas in kaa deng un mija la. Oen totoang in simu ka, mamon na tatai. Mo oen tao bel Benyamin nenang nga mamo dui oe lima, deng un kakan nas nena las. Hidi nam oen totoang kaa-niun didiin silis. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Oen kaa hidi kon, Yusuf hulu-hulu nol un tulu in mana-koet ta noan, “Hoe! Ku laok nisi bel atuil nias ale, se oen karong ngas mesa-mesa didiin inu-inu. Hidim ku nisi tamang pait oen duit tas laok se oen karong ngas mesa-mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Hidi nam ku kat auk klas lil-muti ka, le taon laok se tana hmudin na karong nga.” Kon atuling na lako daek muid Yusuf in loka-tadu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ola oskaong mitang bii kon, Yusuf sao oen le pait lakos kil in kaa nol oen keledai las. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Oen lakos katang isi nol kota la lo bii, kam Yusuf tek un tulu in mana-koet ta noan, “Ku laba-laba laok nulut muid atuil nas. Eta ku haup oen son nam, ku ketan elia: ‘Tasao le mi dalen nas idus naseke nol blalan na, le mi bel seda un in banan nol mia ka, nini in daek dadaat eli kia? ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Taon elola le mi dalen nias boel naseke, le naok lail-nini tuang klas lil-muti ka lia? Mi tanan lo ke? Na tuang klas in ninu tukun lo! Un kon pake klas na le taung in tinang atuli ulat. Klas na muik un kuat-tes! Mi in tao ni, meman daat isi son!’” ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Hidi kon tulu in mana-koet ta laok nulut muid one didiin hapus. Kon un tek one muid Yusuf apin in tek una ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Mo oen kaen noan, “Ama in nangan na elol nia? Kaim sumpa. Kaim niam tao dadaat ela lo! ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ama esa tanan son ta lo? Duit in se kaim karong ngas dalen lelon na ka, kaim kil pait son, ta lo? Tiata, taon elola le kaim naok lai-niin sa-saa lil-mea, tamlom lil-muti deng tuang uma la lia? Ela lo tetetas! ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ama nuting esa tukun! Haup klas lil-muti na se asii karong ngam, hukung tele un nol nia! Nol nang le kaim tenga lias, daid ata taung ama tuang nga tuun tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Kon nam tulu in mana-koet ta tek noan, “Lo! Eli tukun. Eta haup klas na se asii lam, un daid auk tuang nga ata. Tenga las boel lakos napiut.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kon oen laba-laba niung oen karong ngas. Hidim oen loat karong bahang ngas meman. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Hidi kon, tulu in mana-koet ta, presa-tinang oen karong ngas totoang, kilan deng kaak hmunan na karong nga, maa lako lius se pail hmudin na nenang nga. Kon nam un haup klas lil-muti ka se Benyamin karong nga. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ngat net ela kon, Benyamin kakan nas dalen dudus. Hidi nam oen nikit sakeng oen karong ngas laok se oen keledai las dapa, le hobalin pait lakos kota la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Oen lakos lius se Yusuf uma la lam, un bii nabael se la. Kon oen hai bukun nas se un sila ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ti Yusuf baet oen le tekas noan, “Hoe! Tasao le mi tao saol auk eli lia! Mi tana tam lo ka, eta atuil tene el au lia lam, nuting taan atuli li sa-saa in buni-napang ngas!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Kon nam Yahuda siut noan, “Ida loo! Ama Lamtua Allah kolong lulit kaim in kula-sala ngias son. Kaim le aa elol pait, tamlom kaen puting apan nias elol pait ta? Eta noan tuang tahang kaim palin hmudin nia lam, banan dui ka tahang kaim totoang. Kat kaim totoang le daid tuang ata tuun tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Mo Yusuf siut noan, “Loo! Haup klas na se asii lam, un man daid auk ata! Auk tahang mi tenga lias lo. Ta mi pait lakom mi aman nu tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Hidi nam, Yahuda lako dadani nol Yusuf, le tekan noan, “Tuang! Auk tana le tuang in kuasa ka banansila el lahi nga. Undeng na le, komali nol auk deken le. Ta auk nodan dola le aa nol tuang bubuit. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Dedeng na, tuang ketan kaim son noan, ‘Mi aman na nol mi palin muik nabale, tam lo ka?’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kon nam kaim tek noan, ‘Kaim aman na nuli nabale. Nol kaim kon muik palin hmudin mesa. Dedeng hua una lam, kaim aman na blalan son. Lam kaim palin hmudin na kaka in hua at mesa, mo un ase son. Oen duas inan na mate son. Tiata halas ni liis pail hmudin na sii son. Undeng na le kaim aman na namnau un isi.’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tukun nam tuang lok kaim le kil nol kaim palin na maa se nia, le halin tuang netan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Kon kaim siut noan, kaim palin hmudin na boel in lail dadai kaim aman nua lo. Eta un lail dadai kaim aman nua lam, un mate son na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kon tuang siut noan, ‘Eta mi kil nol mi palin na lo kam, mi boel maa se auk silang ngi pait lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Hidi na kon kaim pait. Lius se kaim aman nu kon, kaim nahdeh un deng totoang man tuang in teka ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Nesang-nesang kon nam, kaim in kaa ngas hidis. Kon un lok kaim maa se Mesir, le sos in kaa pait. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Mo kaim situn noan, ‘Papa! Kaim bisa laok se ua pait lo. Ta lahing nga ima kanan na tek kaim son noan, eta kaim kil nol kaim palin hmudin ni lo kam, kaim boel laok se un sila ku lo. Tiata un musti lako leo-leo nol kami, halas-sam kaim lako.’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Hidim kaim aman nu tek pait noan, ‘Mi tanan son ta lo? Auk sapang Rahel la anan suma at dua siis. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ana hmunan na ase son. Taon elola ko hmukit huin kaa nuli un son. Tiata maa lius leol neot nia, auk net un pait lo son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Eta mi kat tana hmudin ni pait deng au, le un haup in daat kon nam, mi tao sus taplaeng auk se oras blalan ni son na, lole bet auk mateng meman.’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Tiata tuang! Eta auk pait lakong se kaim aman nua, mo nol pait kaim palin hmudin ni lo kam, taon elola ko kaim aman na mate son na. Lole un namnau ana ki muun isi, un dalen na napin nol adi Benyamin. Nol un kon blalan isi son, tiata eta kaim tao sus taplaeng una lam, taon elola ko un mate son na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Taplaeng pait, auk hid nol un son noan, auk man temang tana nia. Auk kon hidan son, le eta auk nol pait kaim palin ni lo kam, nang le auk man lep in kula-sala ni didiin auk mateng. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Tiata auk nodan elia tuang: Nang le auk dadang se iang seda una, le auk man daid tuang ata. Le halin nam un pait nol un kakan nias. ");
INSERT INTO hegNTpo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Eta tana ni pait lo kam, auk kon pait lo. Ta auk tahang nal in ngat auk amang ngu in susa didiin mate ka lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ming ela kon, Yusuf dalen na nahi, didiin un tahang nal se un atulin in dake ngas silan lo son. Tiata un tadu oen le putis, halin nam un sii nol un kaka-palin nas. Nini ela lam, un tek puting nal apa ka noan, un na mo asii la. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Tukun nam atuil in dakeng nas totoang putis, kon Yusuf lilu mumuun. Didiin atuil Mesir in se kamar ra likun na ngas kon ming haup un in lilu ka. Nol atuli-atuil in se lahing nga uma la ka kon, ming haup un in lilu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Hidi kon, Yusuf aa langa-langa nol un pali-kakan nas noan, “Kaka-paling me! Auk niam Yusuf, mi pail-kakan na! Paap meman nuli baktebes nabale, ta lo?” Ming ela kon, un kaak-palin nas lii isi, didiin oen aa nal saa pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusuf laeh oen le tekas noan, “Kaka-pali me! Mi maam dadani se ni le.” Kon oen lakos dadani nol Yusuf. Un tek oen pait noan, “Auk niam Yusuf, man lelon na mi hee soleng bel atuil Mesir ras. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Meman mi hee soleng auk son. Mo mi lii deken, nol sua sala apa bakun na. Ta Ama Lamtua Allah esa man kil nol auk maang muna se nia. Nol ela, Un pake auk le bel boa-blingin atuli hut mamo. Le halin nam oen mates undeng hmatu deken. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Oras lubu ki halas-sam laok taun dua. Ta nate taun lim pait bii nabale. Se dedeng na lam, atuli li bali dale lo, soko-hai lo, nol haup in nui-nole lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Nini lalan man kit in taan lo nia, Ama Lamtua Allah kil nol auk maang muna deng mia. Le halin nam mi nol mi ana-upun nas haup boa-blingin. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Tiata in toma ka, mi man in tao le auk maang se ni lo, molam Ama Lamtua Allah in tao. Un man tao auk le daid lahi nga ima kanan, se Mesir nia. Kon auk daid tulu in mana-koet se lahi nga um lahi la. Se ia lam, muik atuil didang pait man lapa dui deng auk lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Tiata mi pait lakom nol lalaba tia, le tek auk in aang nias bel papa, noan: ‘Paap ana Yusuf fa, nuli nabale! Un daid atuil tene son ne dale Mesir. Un kon nodan paap le lalaba lako Mesir. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Mam paap boel daad se dale Gosen, man dadani nol una. Maan na banan, hidim bluang. Tiata paap haup maan le moang paap lae-blai las, laen nas, nol aus-sapi las totoang se lua. Hidim un kon nodan, le paap lako nol ana-upu nias totoang, uma isin nias, nol pusakan nas totoang, le daad se luas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Eta paap se Gosen nam, un bisa papa-paiduil paap se lua. Ta oras lubu ki nate taun lim pait bii. Tiata mam un ator, le paap nol paap nenan nias, nol hmukit tas totoang muik tahan in dabun saa lo.’” ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yusuf tekas hidi ela kon, un aa pait noan, “Halas-sam mi net nol matan esan son, ta lo? Adi Benyamin, auk niam baktebes Yusuf. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tiata lako lam tek kit papa noan, auk in kil kuasa ne Mesir ri tene isi. Nol dehet totoang asa man mi in net son nas bel papa. Hidi na lam, mi kil nol paap lalaba maa se lia tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Hidim un neok un palin Benyamin, le oen duas lilu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Un kon neok un kakan nas totoang, le un likis mesa-mesa. Hidi na, halas-sam oen dehet nol una. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Dedeng lahing nga nol un atulin in dake ngas ming haup noan, atuil in maang nas, Yusuf kaka-palin nas, kon oen totoang dalen kolo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Hidim lahing nga tek Yusuf noan, “Yusuf! Tek ku pali-kakam mas, le oen sakeng ael laok se oen keledai las, le kil nolas lakos Kanaꞌan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Hidim tadu oen le kil nol ku amam ma nol un nenan nas totoang, le oen maas daad seda se lias tia. Mam auk bel oen dale in banan dui se Mesir, le oen bisa nulis se las, nol oen kaa dale na in hapu ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Tek oen kon, le kil kereta deeh meman deng ias, halin taung in sakeng tana-anang blutu kas, nol ku amam ma. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Nangan pusaak man oen kil nal maa se ni lo ngas deken, ta totoang man in banan dui se Mesir rias mam oen palas.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ming ela kon, Yusuf bel oen kereta dehe, nol in kaa se lalan muid lahing nga in prenta ka. Nol un pali-kakan nas mana-koet oen sa-saa las, le pait lakos muding lahing nga in leka ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yusuf kon bel oen at mesam kaod balu apa mesa. Mo un bel Benyamin duit muti ngatus tilu, nol kaod balu apa lima. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Un kon tunang bel un ama ka sa-saa man in banan dui se Mesir, le sakeng se keledai ta-hngulu hngulu. Hidim un bel taplaeng ale, ruti, nol in kaa bili-ngala se keledai heteng hngul kisa pait, le daid in kaa taung oen in pait maas se Mesir. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Hidi nam, un sao oen le pait nol in hida noan, “Mi boel kaen apa se lalan deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Hidi kon oen pait lakos oen aman sa, se dale Kanaꞌan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Lakos lius se luas kon, oen tekan noan, “Papa! Paap ana Yusuf nuli nabale. Un daid atuil tene, le kil bandu ne Mesir!” Yakob ming haup ela kon, un langan tukun, nol parsai oen in dehet na lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mo nikit oen tek hidi belen Yusuf in hida ngas, nol net kereta man Yusuf in tunang, le halin taung in sakeng nol un lako Mesir ra, halas-sam un parsai. ");
INSERT INTO hegNTpo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Kon un tek noan, “Idaah! Auk anang nga nuli nabale lia! Eta ela halas-sam auk daleng ngi kolo! Auk musti laok net un le, halas-sam auk mateng nol babanan.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Hidi na kon, Yakob tadu un ima-ii las le tao nakbuan oen kai-batu las, kon oen bok lakos nang dale Kanaꞌan. Lakos lius se iung Barsebas kon, un keo hmukit le tao in todan-lahing bel Ama Lamtua Allah, man deng lolo hmunan nu, un ama Isak in todan-lahing nga. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Duman mesan na kon un natloa. Se in natloa na dalen, un ming Ama Lamtua Allah haman un noan, “Hoe Yakob! Ku haung le hii napat se Auk le!” Kon un siut noan, “Iya Lamtua, elola?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kon Ama Lamtua tekan noan, “Auk niam Ama Lamtua Allah, man ku amam ma todan-lahing son deng lolo hmunan nua ka. Ku lii in laok Mesir deken. Ta mam Auk tao ku in hua-koet tas le daid bangsa tene mes se lua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nol mam ku in lako Mesir ra Auk leo-leo nol ku. Ela kon, mam Auk nol ku in hua-koet tas pait maas Kanaꞌan. Oras ku in mate ka, ku anam Yusuf haup ku hngasam ma.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Hidi na kon, Yakob nol un anan nas bokas deng iung Barsebas. Hidim oen sakeng una, nol un sapa-anan nas se kereta man lahing Mesir ra in bele ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Oen kon kil totoang oen hmuki-pusakan nas, nol totoang hmukit man daid oen nenan se dale Kanaꞌan nas. Hidim Yakob nol un anan biklobe las, un anan bihata las, nol un upu kia-kaon nas totoang bok lakos Mesir. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakob nenan man in muid le lakos se dale Mesir ras ngalan nas elia: Aan hmunan na, Ruben. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Un anan nas: Henok, Palu, Hesron nol Karmi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon nol un anan nas: Yemuel, Yamin, Ohad, Yakin nol Sohar. Nol Saul, un ana in daid deng un sapa-bihatan Kanaꞌan na ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi nol un anan nas: Gerson, Kehat nol Merari. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahuda nol un anan nas: Sela, Peres nol Sera. Yahuda ana didang, Er nol Onan mates son se Kanaꞌan. Un kon kil nol Peres anan nas: Hesron nol Hamul. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaskar nol un anan nas: Tola, Pua, Ayub nol Simron. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon nol un anan nas: Sered, Elon nol Yahleel. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Oen totoang nam Yakob nol un sapa Lea anan in hua ngas, dedeng oen daad se Mesopotamias sa. Muik pait oen anan bihaat siing man ngaal Dina ka. Tiata Yakob nol Lea in hua ngas totoang atuli at buk tilu beas tilu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Hidi nam muik un anan deeh pait deng un sapa didang ngas, el: Gad nol un anan nas: Sifion, Hagi, Suni, Esbon, Eri, Arodi nol Areli. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser nol un anan nas: Yimna, Yiswa, Yiswi, Beria nol oen batan mes ngala Sera. Nol Beria anan nas kon: Heber nol Malkiel. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Oen totoang nas atuli at hngul eneng. Nas Yakob nol un sapa Silpa upu-anan nas. Silpa na mo ata, man Laban in belen se un ana bihaat Lea, Yakob sapa hmunan na ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Hidi nam muik pait deng Yakob sapa Rahel. Un hua ana at dua: Yusuf nol Benyamin. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Dedeng na, Yusuf saap nol Asnat son se Mesir. Yusuf bakin na, tulu agama mes deng kota On. Un ngala Potifera. Yusuf duas Asnat anan nas: Efraim nol Manase. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin kon muid le lako Mesir leo-leo nol un anan nas: Bela, Beker, Asibel, Gera, Naaman, Ehi, Ros, Mupim, Hupim nol Ared. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Tiata Yakob nol un sapa Rahel in hua-koet tas, atuli at hngul aat. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Hidi nam, Yakob muik sapa mes pait, ngala Bilha. Oen duas anan nas: Dan nol Naftali. Dan ana ka, ngala Husim. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali nol un anan nas: Yasel, Guni, Yeser nol Silem. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yakob nol sapa Bilha in hua-koet tas, atuli at itu. Bilha na mo ata, man Rahel hapun deng un ama Laban na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Tiata Yakob in hua-koet man lakos se Mesir ras, atuli at buk eneng beas eneng. Kaih nol un ana-manhiun nas lo bii na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Taplaeng nol Yusuf anan in hua se Mesir ras, at dua. Tiata Yakob nol un nenan man daad se dale Mesir ras totoang, atuli at buk itu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Oras oen lakos dadani son nol Mesir kon, Yakob tadu un ana Yahuda lako muna, le haman Yusuf maa tutnaal nol un se Gosen. Dedeng oen lakos lius son se Gosen kon, ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusuf saek lako un kereta la, le laok tutnaal nol un ama ka se na. Oen tutnaal apa kon, Yusuf neok un ama ka le oen duas lilu nol apa nesang isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Hidi kon Yakob tek Yusuf noan, “Auk anang Yusuf! Halas-sam auk net ku esa son. Nol auk taan son noan, ku nuli nabale. Tiata auk mateng nol ni tia kon, banan.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Hidi kon Yusuf tek un pail-kakan nas totoang noan, “Kaka-paling totoang! Auk musti laok tek lahing nga noan, auk nenan nas maas son deng Kanaꞌan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Auk kon tekan noan, mi niam, atuil in moang lae-blai nol aus-sapi. Undeng na le, mi kon kil nol mi hmukit tas, nol hmuki-pusakan nas deng Kanaꞌan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Eta lahing nga haman mia, le ketan mi noan taom mi daek asa, ");
INSERT INTO hegNTpo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","lam mi siut un noan, mi totoang niam atuil in moang hmukit deng mi anan bii kua, banansila el mi upu kia-kaon nas kon. Nini ela lam, mam un tadu mi le daad se dale Gosen.” Yusuf tekas ela, undeng atuil Mesir ras nikis, eta oen daad nakbua nol atuil in lolo-poa hmukit tas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Hidi kon, Yusuf nol un kaka-palin nas at lima, lakos ngada se lahing nga. Yusuf tek lahing nga noan, “Ama lahi! Auk amang nga nol auk kaka-paling ngas, maas son deng Kanaꞌan. Oen maas nol oen laen, lae-blai las, aus-sapi las, nol oen kai-batu las totoang. Halas ni oen totoang ne dale Gosen son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kon lahing nga keket noan, “Lelo-lelo lam mi daek asa la?” Kon oen siut lahing nga noan, “Kaim niam atuil in lolo-poa hmukit, banansila el kaim upu-aman nas kon, ama lahi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Halas ni, se dale Kanaꞌan oras tuu muun isi, tiata muik in kaa nol bluan pait lo son. Ta kaim maam se dale nia, le daad tahang. Kaim kon kil nol kaim hmukit tas. Undeng na, kaim nodan ama lahi le tade kam, kaim daad se dale Gosen, le doha-tinang kaim hmukit tas se luas.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kon nam lahing nga tek un in koma ka bel Yusuf noan, “Halas ni ku amam ma, nol ku pail-kakam mas ne nias son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Tiata oen tao dale ni banansila el oen nena esa lako. Se auk in tana kam, dale Gosen na, dale man in banan dui se nusa nia. Tiata banan dui ka, oen daad se las tuun tia. Nol eta deng one la muik in doha-tinang taan hmukit tam, nang le oen kon doha-tinang bel auk nena lias se luas kon.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Hidi nam, Yusuf kil nol un ama ka laok tulu se lahing nga kon. Lius se luas kon, Yakob kohe-kanas le nodan Ama Lamtua Allah bel hangun se lahing nga. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kon lahing nga keket Yakob noan, “Ama umur taun bakun son na?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob situn noan, “Auk nuling taun ngatus buk tiul son, mo auk daad tetesa se mana mes lo. Auk upu-amang ngas kon ela. Eta sukat nol one lam, auk umur ri meman daen dui. Mo inu nol in susa-daat mamo dui.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Hidi kon Yakob seon lahing nga. Mo un lako lo bii kam, un nodan Ama Lamtua pait le bel hangun se lahing nga. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Hidi nam Yusuf daek muid lahing nga in teka ka, le tulu bel oen maan se dale Gosen. Maan na banan isi. (Mam oen ngali maan na ngala ‘Rameses’.) Kon nam Yusuf ama ka, nol un kaka-palin nas daad napiut se las. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Hidim Yusuf kon mana in kaa bel un ama ka, un kaka-palin nas, nol oen sapa-anan nas totoang, deng in tene dui ngas lako pes ana blutu kas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Dedeng na, lubu ka muun isi, didiin se ola-ol kon muik in kaa pait lo son. Deng Mesir lako pes Kanaꞌan, atuli las totoang bloen son. Oen daek nal saa pait lo son, undeng oen lubus naseke. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Hidim totoang atuli-atuil in deng mana-maan in se Mesir, nol mana-maan in se Kanaꞌan nas maas, le sos in kaa deng Yusuf. Kon un tao nakbuan duit tas totoang, le laok pesang se lahing nga uma. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Dedeng na, atuil Mesir nol atuil Kanaꞌan nas duit tas hidis son. Tiata oen sos nal in kaa pait lo son. Kon nam oen maas ngada Yusuf le nodan noan, “Ama! Bel kaim in kaa le, le halin nam kaim matem undeng lubu deken. Ta kaim duit tas hidis son.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Kon Yusuf siut noan, “Eta noan baktetebes mi duit ase son nam, tao eli tukun: bel mi hmukit tas, le auk bel sedas nini in kaa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Undeng taun na Yusuf tekas ela, tiata oen bel oen hmukit tas, le Yusuf beles in kaa. Oen hmukit tas banansila el: ahlote, lae-blai, laen, aus-sapi, nol keledai. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Taun in pait maa ka, oen pait maas se Yusuf le tek noan, “Ama! Kaim aa nahlolool tukun. Kaim duit tas nol kaim hmukit tas, paap silin nalas totoang son. Halas ni kaim muik saa lo son. Liis kaim apan nias, nol kaim dale kias tuun son. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nang kaim le kaim matem deken. Eta kaim matem mam, asii man daek dale nias sa? Banan dui ka, ama kat kaim le daid ata se papa. Nol paap kat kaim dale kias, le taos daid paap nena. Hidim paap bel kaim bini, le kaim soko-hai bel papa. Hidim kaim in kae ka, nol kaim dale kas, paap bel sedas nini in kaa. Sadi kaim matem deken.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Undeng oras lubu ka muun keko lako, tiata totoang atuil Mesir ras hee soleng oen dale kas. Kon Yusuf sos nal totoang dale in se Mesir ras, le daid lahing nga pusaka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Nini ela, tiata Mesir hutu-ata nas totoang daid ata deng lahing nga. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mo deng nas totoang, Yusuf sos tulu agama las dale kas lo, undeng lahing nga bel oen in kaa tutungus. Tiata oen hee oen dale kas lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Dedeng na Yusuf aa nol hutu las noan, “Halas ni mi daid lahing nga ata son. Mi dale kas totoang kon, auk sos bel lahing nga son. Tiata mi kat bini-biin nias, le laok soko-hais se dale nas tia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Eta lius in nui-nole kam, in hapung nas mi bating op lima. Op mesan na kilan bel lahing nga. Lisin op aat tas, mi pake daid bini, nol taung mia, nol mi nenan nas in kaa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kon oen siut noan, “Ama! Ku bel slamat kaim son, tiata kaim nodan mamo. Kaim tade le daid ama lahi ata.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Hidi nam, Yusuf pake atorang na le daid hadat se dale Mesir. Tiata deng totoang ael man hutu las in nui-nole ngas, oen bating op lima. Op mesan na oen belen se lahing nga. Op aat tas oen pake esas. Suma tulu agama las dale kas siis, man lahing nga sosas lo. Hadat na, oen pake napiut. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Kilan deng dedeng na, kon atuil Israel las daad napiut se Mesir, se dale Gosen. Oen daid atuil in muki, nol oen in hua-koet tas kon mamo taplaeng. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Se Mesir, Yakob nuli taplaeng taun hngul itu pait, didiin un umur taun ngatus buk aat beas itu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Un oras-lelon in mate ka dadani son kon, un haman Yusuf le tekan noan, “Ana Yusuf! Auk nataka kam nesang lom Ama Lamtua Allah le haman pait au. Tiata auk nodan, le eta ku namnau au lam, ku sumpa, le ku puan auk se dale Mesir lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ku musti nol pait auk aap-sising ngia, lako kit upu kia-kaon nuas maan in puan na. Le ku puan auk se na. Paap in koma ka ela.” Kon Yusuf siut noan “Banan papa! Eta paap koma ka ela son nam, auk muid tukun.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Kon Yakob aa noan, “Elam nol nia, ku sumpa, le tek noan ku daek muid paap in koma ka.” Tukun nam, Yusuf sumpa muid Yakob in aa ka. Kon Yakob hai buku ka le suda se hadang nga dapa, halas-sam un kohe-kanas nodan mamo se Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Nesang lo kon, atuli maa tek Yusuf noan, un papa heda muun isi son! Tiata un kil nol un anan nas duas, Manase nol Efraim, le laok ngat oen upuns Yakob. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Nikit Yakob ming noan Yusuf maas son kon, un dising apa ka le hangu daad se hadang nga. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Un tek Yusuf noan, “Ana Yusuf! Ama Lamtua Allah man muik kuasa muun isi ka, tulu-balang Un apa ka son, bel auk se iung Lus, se dale Kanaꞌan. Se na, Un hid au. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Un tek noan, ‘Mam auk bel ku ana-upum mas mamo taplaeng, le ku in hua-koet tas daid bangsa tene. Mam Auk kon bel dale ni se ku in hua-koet tas, le daid oen pusaka didiin apan-kloma ki hidi.’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Tiata, ku anam Efraim nol Manase, oen hak ka elia: auk maang se Mesir ram, oen duas muik son. Ela kon no, auk nangan oen duas son banansila el auk anang in hua esa, el Ruben nol Simeon. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mo eta mam ku haup aan pait tam, na ku anam esa lolen. Auk tao oen el auk anang esa lo ka. Tiata, nang le mam oen sium oen pusaka las deng oen kakan Efraim nol Manase tukun. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Auk tao elia, undeng auk nangan ku inam Rahel. Dedeng kaim pait deng Mesopotamiam, le lakom dale Kanaꞌan kon, ku inam ma mate undeng in hua ana se lalan, dani nol iung Efrata, ne dale Kanaꞌan. Dedeng na, auk daleng nga iil isi! Kon auk puan un se lalan suut in laok bus el iung Efrata ka.” (Iung na halas ni, oen ngali ngala Betlehem.) ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Yakob aa hidi le un nikit sila ka lam, un net Yusuf anan nas se na. Kon un ketan Yusuf noan, “Hoe! Ni asii anan nias sa?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Kon Yusuf siut noan, “Oen niam tana-ana man Ama Lamtua Allah in bel au, se Mesir.” Kon nam Yakob tekan noan, “Eta elam, ku nolas maa dadani nol au, halin auk kohe-kanas nodan Ama Lamtua Allah le beles hangun.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yakob blalan son, nol un mata ka ngat tam nus tukun. Tiata un ngat net nol babanan isi lo. Kon Yusuf nol un anan nas lakos dadani nol Yakob, le un neko-lik one. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Hidi na kon, un aa nol Yusuf noan, “Bablaan nia, auk nangan noan bet auk tutnaal ku pait lo ka. Mo halas nia lam, Ama Lamtua Allah dake ka muun dui pait, le didiin auk kon haup ku anam mias.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Hidi nam, Yusuf pel bian un anan nas deng Yakob, hidim un hai buku ka le sila ka lako tom se dale ka, se un ama ka sila ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Hidi halas-sam Yusuf hangu. Hidim un bel un anan nas le dil dadani nol un ama ka. Un tapa ana hmunan Manase, se Yakob halin kanan na, nol ana hmudin Efraim, se un halin kliu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mo nikit Yakob le nene ima ka laok se oen duas bon nas, halin nodan hangun beles sa, un seda ima kanan na le nene laok se palin Efraim bon na, mo un nene ima kliu ka laok se kaka Manase bon na dapa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Hidim un kohe-kanas le nodan Ama Lamtua Allah bel Yusuf hangun, noan, “Ku upum Isak ama ka, Abraham, nol ku upum Isak esa, oen duas muid napiut Ama Lamtua Allah in koma ka. Ama Lamtua Allah kon papa-paiduil auk son, deng auk muda bii ku, maa lius leol neot nia. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Un kon puting auk son deng totoang in daat beas bakun. Tiata auk kon nodan, le Un bel hangun se tana-anang nias nol oen in hua-koet tas. Nol eta oen kohe-kanas se Ama Lamtua Allah lam, oen nadidingun oen kian Abraham, upun Isak, nol auk ngalang ngi deken. Nang le oen in hua-koet tas mamo taplaeng, le daid bangsa tene se apan-kloma kia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Mo nikit Yusuf ngat un ama ka nene ima kanan na laok se pali la bon na kon, un kil un ama ka ima ka, le seda lako se kaka la bon na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Un tek un ama ka noan, “Papa e! Tao ela deken. Ta un na mo Efraim, aan hmunan na lo. Paap musti sakeng paap ima kanan na laok se Manase bon na dapa. Ta na aan hmunan na hak.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mo un ama Yakob dai tao lo. Le tek noan, “Ana! Meman auk tanan. Ta mam Manase daid muun-tes, nol un in hua-koet tas taplaeng mamo, le daid bangsa tene. Mo mam un palin Efraim, muun-tes dui pait. Un in hua-koet tas, daid mamo isi, didiin oen daid bangsa tene mamo, man muun-tes.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Hidi kon, un tek tana at dua nas noan, “Manase nol Efraim! Mam eta atuil Israel las nodan hangun bel atuil didang ngam, oen kon aa nuting mi duam ngalan nas. Mam oen nodan noan, ‘Sadi bole lam Ama Lamtua Allah bel hangun se ku, banansila el Un in bel hangun se Efraim nol Manase ka.’” Nini ela lam, Yakob kon aa Efraim ngala ka muna, deng un kaka Manase ngala ka. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Hidi nam Yakob tek Yusuf noan, “Ana! Nesang lo ka kam auk mateng. Mo mam Ama Lamtua Allah tulung mia, le nol pait mi lakom se mi upu kia-kaon nas dale kua. ");
INSERT INTO hegNTpo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Halas ni auk in bel ku ki tene dui deng asa man auk in bel se ku kaka-palim mas sa. Ta auk bel taplaeng ku leten in ne dale Kanaꞌan, man hmunan nu auk katan son deng atuil Amori las, se dedeng auk in keng nolas sa.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Hidi na kon, Yakob tadu haman un anan nas totoang. Oen maas totoang son kon, un tekas noan, “Auk anang me! Mi maa dil nakbua dadani nol auk se ni le. Auk le tek mi mesa-mesam, lalan in nuli se leol hmudin na.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Hidi kon Yakob tek un anan nas meman elia, “Yakob anan me! Mi maa le dil pukiu au. Hii, ta mi aman Israel le aa. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben! Ku nia mo auk anang in blalan dui ka! Ku kon daid auk hnikan na, nol auk imang kanan son. Atuli-atuli lias todan se ku dui. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mo ku dalem ma teken isi lo, taan le ku in koma ka man ola lia. Ku dalem ma banansila el len in ne tasi kua ka, man suktomas sam maa elia mo suktomas sam lako elua. Suknahkiut tuun, mo ku laok niin nol auk sapang Bilha, le tao hmomos ku amam ma maan in nini ka. Undeng na le, ku ngaal kaka la nahi meman! ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon nol Lewi! Mi duam sila mesa! Mi duam hlapat isi in nikit suli, le tao sus atuli. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mi in koma ka, suma dait nutus aus-sapi las iin ulat tas, didiin oen bosor isi le keo-keo se mana. Nol undeng mi in daat ta, le mi duu siin halas-sam keo atuli. Tiata auk hosek lo nol mi in dehet tas. Auk kon dai muid le kutang nol mi dasi las lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Tiata halas ni, auk bahang mi oen-lalin daat na, lole mi lai-lisin son! Nol mi in komali ka, muik tahan in nangan namnau bubuit lo kon. Mam mi lepa-haal esan mi in daat na. Mam Ama Lamtua Allah hising soleng mi in hua-koet tas, le oen lakos daad holhising se ola-ola, se dale Israel. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahuda! Ku ngalam ma nahin na noan, ‘naka’. Mam ku kaka-palim mas naka ku, nol suda le todan ku. Ku kon tudan-kida ku musu las, didiin oen nikit nal bon nas lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ku niam banansila el singa muda man in muun, man nuting taan in kaa esa. Ku kon tuladang el singa ta-hngulu man lui apa ka, le laok nini; muik tahan in brain tia sepo ku lo. Ku kon tuladang el singa ina man doh un ana ka; muik tahan atuli in brain laok kusun lo. Atuli las lii-tiud ku, nol muik in brain le tao lobo-lau nol ku lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Mam ku niam, kil bandu. Ku in hua-koet tas kon kil bandu mudi-muid apa, didiin mam muik At Mes kil hak lapa dui deng totoang. Un daad le kil bandu, hidim bangsa-bangsa las totoang todan Una, nol hii-ming se Una. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Mam ku nuli nol dael kolo tutungus! Ku kom saa tukun kon, muki! Nol ku kom le tao saa tuun kon, dadi! Hidim ku hmukit tas, nol ku klapa las isin nas taplaeng mamo, le liis-lasa didiin sole-soleng tuun ela. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ku in kaa-ninu ngas fala banan sii, didiin hidi nutus taan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon! Ku dale pusaka la bluang dui, nol dani tasi, lako lius kota Sidon. Kapal-kapal las deng ola-ol maas le soleng oen nahu las nol babanan se ku onan na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Isaskar! Ku nia mo tuladang el keledai in tes sa, mo ku bom baut isi. Eta ku nini se lalan hlala son nam, asii man dising le bangun ku, halin laok napiut ta? Ase! Na mo eta ku ngat net iung man in leok isi mes se suu halin nua, lam tadu ku lo kon ku nikit ku sa-saa las, le bok lako ua son na. Ku ela son na! ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan! Ku ngalam ma nahin na noan, ‘atuil in nutus dasi’. Hidim mam ku nol ku in hua-koet tas, man nutus bel ku bangsa las dasi las nol in ngele halin lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ku nia mo banansila el ul in muik lasong nga, man nini natang se lalan suut ta. Eta atuli saek ahloet le kaliut deng na lam, suknahkitum ul na sau ahlote la iin na, ta atuling in sake ka nahi batlenga. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ee AMA LAMTUA! Auk nodan le Ku bel boa-blingin kaim totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad! Ku ngalam ma lin na naha-bubuit tam tatai nol ‘hote-dait labang’. Mam atuil in nako ngas maas keng nol ku, mo ku hobalin keng nolas le tao tehen one. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser! Mam ku klapa las isin nas banan dui, le ku daek kukis leko-leko man fala banan, ta lahi-lahi las maas sos kukis se ku. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali! Ku niam banansila el lus ina huin, man muik tahan atuli in pekot ku lo. Ku kon hua nal ku anam mas uih-leko ana lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusuf! Ku tuladang el kai ina in lohang man nuli dani nol ui mata ka. Un bango ngas lohang sake lako se tembok lapa-lapa ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Muik atuli in idus le soleng oen dalen in iil isi ka bel ku, banansila el musu las hmeon ku. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mo Ama Lamtua Allah man auk in todan na, tulung ku. Tiata Un tao ku imam ma le tes-kain, le didiin deng kakatang kon no, ku hmeon bali nal one. Ku nal one, undeng Ama Lamtua man tulung ku, meman Un in kuasa ka muun isi baktebes! Undeng na le, auk nahlae se Una. Ta Un man doh au. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Mam Un kon doh ku. Nol Un bel hangun se ku, hangun deng apan-dapa kua, nol hangun deng apan-kloma kia, nol hangun in hua ana mamo-mamo nol boa-blingin. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Leten nas ilang lo. Nol auk hangun in bel ku nia, mamo dui deng leten-leten nas totoang! Nang le totoang hangun nias holbohon tia se ku la, undeng ku man dui hidi deng ku kaka-palim mas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin! Ku in brani ka, banansila el ngot huin in lubu ka. Ohkaong bii kon, un nulut le daek hmukit taung un in kaa son. Eta duman nam, un laok bating in kaa lisin nas bel un anan nas. Ku in hua-koet tas kon muun banansila ela!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ela son na, Yakob tek meman bel un ana-anan nas lalan in nuli, se leol hmudin na, mesa-mesam nonool un in hua-koet tas. Oen totoang nas, man puting Israel ngalan hngul dua kas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Hidi kon, Yakob nodan un anan nas le oen hida, noan, “Nesang lo ka kam auk mateng. Eta auk mateng son nam mi musti nol laok puan auk se upung Abraham niut utu kua. Niut utu na ne liang, dani nol iung Makpela nol Mamre, ne dale Kanaꞌan. Hmunan nua, upung Abraham sos nal liang na nol klaap na, le taon daid un maan in puan nitu son. Un sos nutus son deng Efron, atuil deng ngaal Het. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Se na, oen puan kit upun Abraham nol upun Sara. Hidim oen kon puan auk amang Isak, nol auk inang Ribka ne maan na. Tiata mi kon musti laok puan auk se uang, se auk sapang Lea halin na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Mi boel nadidingun deken, le puan auk se liang, man upung Abraham in sos nalan son na le!” ");
INSERT INTO hegNTpo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakob aa hidi ela kon, un nini pait lako se hadang nga, tuun nam un mate. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Kon nam Yusuf neok un ama ka, le lilu kamusang nol mumuun. Hidim un lik un ama ka oe-oe. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Hidi nam Yusuf leka-tadu atuil in mana-koet nitung ngas, le nuh mina se Yakob aap-sisin na, halin Yakob aap-sisin na alet tutungus. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kon nam, atuil nas mana-koet nitung na, le tahang lako lius lelo buk aat, muid oen in nuil-nola ka. Totoang atuil Mesir ras kon lilu nol Yakob in mate ka. Oen melang Yakob lako pes lelo buk itu, banansila el oen atulin tene mes mate. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Hidi nal leol buk itu las kon, Yusuf tek un pegawi las noan, “Hii ke! Auk nodan le mi kil auk in teka nia, le laok tek lahing nga noan: ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Oras auk amang nga le mate ka, un nodan auk le hida, noan auk musti laok puan un aap-sisin na se dale Kanaꞌan. Tiata auk nodan ama lahi le bel auk dola, halin auk laok puan auk amang ngia. Hidi halas-sam, auk pait maang.’” ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ming ela kon, lahing nga siut noan, “Eta ku hid ku amam ma ela son nam, laok puan se lua tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kon nam Yusuf lako puan un ama ka. Atuli hut mamo kon lakos leo-leo nol una. Nas lahing nga atulin in dake ngas totoang, nol totoang atuil tene in se dale Mesir ras. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusuf kaka-palin nas, nol oen atulin in dake ngas totoang kon, lakos muid le puan Yakob. In dada se Gosen na, suma oen sapan nas nol anan blutu mea kas, nol oen hmukit tas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Muik soldadu mamo kon lakos mudi. Tenga las nol kereta, mo tenga las pait saek ahlote. Undeng in laok mudi ngas mamo isi, tiata hut in laok muid le puan nitung nga kas lolet ta blatas isi. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kon nam oen totoang laok kaliut palun Yordan, le lius se mana mes ngala Atad. Taom atuli las maas le diuk ael se na. Se maan na, Yusuf nol un pail-kakan nas lilu le kamusang oen aman na. Kon oen melang duman iut pait se maan na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Nikit atuil Kanaꞌan in se la ngas net oen sus isi ela kon, oen tek apa noan, “Hoe! Mi ngat le! Atuil Mesir ras in melang nitu ka tao dalen iil isi! Oen lilu lako lius tuladang ela lam.” Tiata oen ngali maan na ngala Abel-Misraim, man nahin na noan, ‘Atuil Mesir ras in dalen ili ka.’ ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Hidim Yakob anan nas tao muid el oen in hid hidi son na. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Le oen nikit Yakob nitun na, le laok puan se liang, man dani nol iung Makpela, nol Mamre. Abraham sos hidi maan na son se Efron, atuling Het ta, le taon daid oen maan in puan nitu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusuf puan hidi oen ama na kon, un nol un pali-kakan nas pait lakos Mesir, leo-leo nol totoang atuil in muid le laok puan Yakob pas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Lius se Mesir kon, Yusuf kakan nas mulai lii. Undeng oen aman na ase son, kon oen aa nol apa noan, “Hoe mi nangan le! Eta noan Yusuf pesang dael nabael nol kita, le un balas kit in daek dadaat saol una ka lam, elola la?” ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tukun nam oen koon-mesa, le tunang dais bel Yusuf noan: “Tuang! Kaim nangan nabael oras kit aman na in nuli nabale ka, un tadu kaim ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","le tek tuang noan, ‘Usu, ku musti nadidingun ku kakam mas in daek kula ngas. Undeng hmunan nu oen daek dadaat saol ku son.’ Kaim kon nangan kit aman na in todan-lahing Ama Lamtua Allah deng lolo hmunan nua ka. Kaim kon daid Lamtua na, ata. Tiata nol nia, kaim maam le nodan ampong deng tuang, undeng kaim totoang in tao kula saol tuang son na.” Ming ela kon, Yusuf lilu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Hidi kon, un kakan nas maas esan, le hai bukun nas se un sila ka, nol tek noan, “Nang le tuang tao kaim daid tuang ata tuun tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Mo Yusuf tek oen noan, “Auk kakang me! Mi lii pait bakun tia. Suma Ama Lamtua Allah sii, man muik hak in bel hukung atuli. Mo auk lo. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Hmunan nua, meman mi koon-mes le daek dadaat saol au. Mo Ama Lamtua Allah seda mi in nangan dadaat na son, le taon daid banan. Tiata Un nikit auk le daid atuil tene, halin nam atuil hut mamo ki, haup in nuli. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tiata nol nia, auk tek mi le halin mi boel lii bakun tia. Ta auk hida, le mam auk ngat mia, nol mi anan nas totoang.” Nini Yusuf in aa ela ka, un tao banan un kakan nas dalen nas. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Hidi na kon, Yusuf daad napiut se Mesir leo-leo nol un kaka-palin nas totoang. Un nuli didiin taun ngatus hngulu. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Un net haup Efraim ana-upun nas. Nol un esa kon papa-paiduil Manase upun nas, oen nam Makir anan. ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusuf tek un kakan nas noan, “Kakas totoang! Auk nataka kam auk lelon in mate ki maa dadani son. Mo auk parsai, le Ama Lamtua Allah papa-paiduil mia. Mam Un man nol puting mi deng dale nia. Mam Un kon nol puting mi pait lakom se dale, man Un sumpa hidi son, le belen laok se upung Abraham, upung Isak nol kit aman Yakob.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Hidi nam, Yusuf nodan un nenan nas le nikit sumpa, noan, “Mi musti hid nol au. Eta lius oras Ama Lamtua Allah in nol pait mi lakom se kit dale kua ka, mi kon musti kil nol auk seen nias.” ");
INSERT INTO hegNTpo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Hidi nam, Yusuf mate se dale Mesir, nol umur taun ngatus hngulu. Kon oen nuh mina se un aap-sisin na. Le tamang lako se un nano la dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","2","Buk ni dul deng Yesus Kristus, Atuling man Ama Lamtua Allah hidan meman son deng lolo hmunan nu le tunang maa ka. Un na mo, laih Daud nol upung Abraham in hua-koet. Kilan deng upung Abraham lako lius laih Daud tam, bataꞌ hngul aat. Lamtua Yesus upu kia-kaon nas elia: Abraham hua Isak, Isak hua Yakob, Yakob hua Yahuda nol kaka-palin nas, ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda hua Peres nol Sera (oen inan na, ngala Tamar), Peres hua Hesron, Hesron hua Ram, ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram hua Aminadab, Aminadab hua Nahason, Nahason hua Salmun, ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmun hua Boas (Boas ina ka, ngala Rahab), Boas hua Obet (Obet ina ka, ngala Rut) Obet hua Isai, ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","11","Isai hua Daud, Ninin deng laih Daud lako pes bangsa Israel las tom in soleng lakos se Babilon na ka, bataꞌ hngul aat pait, elia: Daud hua Salomo (Salomo ina ka, hmunan nu Uria sapa) Salomo hua Rehabeam, Rehabeam hua Abia, Abia hua Asaf, Asaf hua Yosafat, Yosafat hua Yoram, Yoram hua Usia, Usia hua Yotam, Yotam hua Ahas, Ahas hua Heskia, Heskia hua Manase, Manase hua Amos, Amos hua Yosias, Yosias hua Yekonya nol un palin nas se dedeng oen tom in soleng lakos se Babel la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Dedeng oen tom in soleng lakos se Babel maa pes Yesus sa, muik bataꞌ hngul aat pait, elia: Yekonya hua Selatiel, Selatiel hua Serubabel, Serubabel hua Abihut, Abihut hua Elyakim, Elyakim hua Asor, Asor hua Sadok, Sadok hua Akim, Akim hua Eliut, Eliut hua Eliasar, Eliasar hua Matan, Matan hua Yakob, hidim Yakob hua Yusuf. Yusuf saap nol Maria. Maria man hua Yesus Kristus. ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tiata kilan deng Abraham lako pes Daud tam, bataꞌ hngul aat; hidim kilan deng Daud lako pes oen tom in soleng lakos se Babilon na, bataꞌ hngul aat; nol kilan deng Babilon lako pes in hua Kristus sa lam, bataꞌ hngul aat kon. ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Dehet deng Maria in hua Yesus sa elia: Dedeng na, Maria nol Yusuf neleng apa son. Oen duas niin nakbuan nol apa banansila el atuil in saap son na lo bii, mo nahkitu lam Maria behe son nini Ama Lamtua Allah Koo Niu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nikit Yusuf taan haup noan Maria behe son kon, un le tao nutus oen duas in kom apa ka. Mo Yusuf na mo dalen na niu, tiata un dai tao nahmaeng Maria se atuil hut mamo sila lo. Molam un le tao nutus oen duas in kom apa na ete-ete. ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Duman mesan na, Yusuf nini le nangan lako-pait kon, un natloa. Se in natloa na dalen, un ngat net Ama Lamtua Allah ima-ii deng sorga maa tek un elia, “Hoe Yusuf! Ku niam laih Daud in hua-koet. Ku lii-tiud in saap nol Maria deken. Ta aan in ne un tain na dalen na ka, Ama Lamtua Koo Niu ka in tao. ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mam Maria hua tana-ana biklobe mesa. Hidim ku musti ngali Un ngala ka, Yesus, ta mam Un man bel boa-blingin Ama Lamtua Allah atulin nas deng oen in kula-sala ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dais ni mam daid ela, undeng Ama Lamtua Allah tek meman son deng lolo hmunan nua. Un pake mee-baah Yesaya la, le dul noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mi hii ke! Mam muik tana-bihatang mesa, haat-ana nabale, taan lo molota, un behe son. Kon un hua Tana-ana biklobeng mesa. Oen ngali Un ngala ka, Imanuel.” (Se dais Ibranin nam, ‘Imanuel’ nahin na noan: Ama Lamtua Allah leo-leo nol kita.) ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusuf natloa hidi ela kon, un nahkitu. Hidim un daek muid Ama Lamtua Allah in teka ka. Un sium Maria le daid un sapa, ");
INSERT INTO hegNTpo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","mo un niin nakbua nolan banansila el atuil in saap son na lo, didiin Maria hua hidi Tana-ana ka. Maria hua hidi Tana-ana na kon, Yusuf ngali ngala, Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Dedeng in hua Yesus se iung Betlehem, se propinsi Yudea ka, lahing Herodes kil bandu se la. Dedeng na, muik atuli at ila lo deng maan katang, se halin leol-sake lua, maas se kota Yerusalem. Oen nam mo atuil in tadas taan duun. ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Oen maas lius se Yerusalem kon, oen ketan lako-pait noan, “Atuil Yahudi las Lahin in hua babalu ka, ne ola ke? Kaim ngat net duun mes son se halin leol-saken, man bel tada noan, hua Un son. Undeng na le, kaim maa todan-lahing Una.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nikit lahing Herodes sa ming oen in aa ela ka kon, un dalen na banan lo. Ta totoang atuil in se Yerusalem mas kon nangan nam susa, undeng oen lii. ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hidi kon, lahing Herodes sa haman nakbua tene-tene agama Yahudi las nol guru-guru agama las totoang, le keket oen noan, “Olan mi tek napat auk le! Kristus, man Ama Lamtua Allah in hid meman son na, mam huan se ola ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kon oen situn noan, “Se Betlehem, propinsi Yudea, ama lahi. Ta Ama Lamtua Allah mee-baah in ngaal Mika ka, dul meman son lolo hmunan nu elia: ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Hoe! Mi atuil Betlehem man in ne propinsi Yudea me. Mi boel nangan noan, mi ingu la, suma iung ana mesa, man muik nahin lo ka deken. Ta mam muik atuil tene at mes daid deng iung na. Mam Un daid atuil in lolo-poa taung Auk atulin Israel las.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ming hidi ela kon, lahing Herodes sa haman atuil in tadas taan duun nas ete-ete. Hidim un keket oen le, oen in net duun na puti se apan nu ka blingan na. Tiata oen tek una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Hidi kon un tadu oen lakos Betlehem nol hidas noan, “Mi laok nuting Tana-ana na papmes se ua, le eta mi tutnalan son nam, pait maam le tek au, ta auk kon le laok todan-lahing Una.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ming hidi lahing nga in teka ka kon, oen lakos. Kon nam, oen ngat net pait duun man hmunan nu oen netan se halin leol-saken na. Duun na puti se oen silan, hidim un muna tuun lako tene, titu se Tana-ana ka mana la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Net duun na ela kon, oen dalen kolo isi. ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kon oen taam lakos se maan na. Se na, oen net Tana-ana ka nol Un ina, Maria. Ta oen hai bukun nas le todan-lahing se Una. Hidim oen bok oen sa-saa in kila man osa isi nas, le bel Tana-ana ka. Oen belen lil-mea, kemenyan, nol kai bui bingis uin. ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nesang lo kon, oen haup in natloa deng Ama Lamtua Allah, noan, “Mi pait lakom deng lahing Herodes su deen tia.” Undeng na le, oen pait lakos oen negara la, muid lalan didang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nikit atuil in tadas taan duun nas pait kon, Ama Lamtua ima-ii at mes deng sorga maa tek Yusuf nini in natloa noan, “Hoe Yusuf! Haung lalaba tia! Le lail nol Tana-ana ka, nol ina ka lakom dale Mesir. Daad napiut se luam, didiin blinga-bling Auk tek mi le, halas-sam mi pait, ta lahing Herodes sa nuting Tana-ana ka le keo tele!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusuf natloa hidi kon, un nahkitu. Hidim un kil nol Tana-ana ka, nol ina ka duman-duman lakos dale Mesir. ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Oen daad se luas didiin Herodes mate. Nini ela lam, Ama Lamtua Allah in teka ka dadi, banansila el mee-baah Hosea in tek meman son deng hmunan nu noan, “Auk haman pait Auk Anang nga, le puti deng dale Mesir.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Dedeng lahing Herodes sa taan haup noan, atuil in tadas taan duun nas naklilu una, kon un koon-mali isi. Un lek un tentara las noan, “Laok iung Betlehem nol ingu-iung man in dadani deng na ngas. Keo tele totoang tana-ana bikloeb blutu, man umur taun dua niu bus el dale ngas.” Herodes lek ela, undeng un nangan net atuil in tadas taan duun nas in dehet ta. Un kahin deng oras duun na in puti se apan nu laih hmunan na ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Totoang dais nias dadis, muid asa man Ama Lamtua Allah mee-baah Yeremia la, dulas meman son noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Muik atuli lilu mumuun se kota Rama. Rahel lilu muun isi, undeng un anan nas mates hidi son. Un dai bel atuli mau-hanet un lo, undeng un anan nas ase son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nesang lo kon, lahing Herodes sa mate. Dedeng na Yusuf nol saap-anan biis se dale Mesir. Kon Ama Lamtua Allah ima-ii mes deng sorga, maa tulu-balang apa ka bel Yusuf, se in natloa dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ima-ii na tekan noan, “Hoe Yusuf! Hangu tia! Nol Tana-ana na duas ina ka pait lakom Israel tia. Ta atuling in le keo tele Tana-ana na ka, mate son.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ming ela kon Yusuf hangu. Hidim un nolas pait lakos dale Israel. ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mo nikit un ming haup noan laih Herodes ana Arkalaus daid laih lolen son ne propinsi Yudea kon, un lii in pait lako Yudea. Hidim Ama Lamtua Allah lekan se in natloa oe mes pait noan, “Yusuf, lako daad se Yudea deken.” Undeng na le, un lako daad se propinsi Galilea, ");
INSERT INTO hegNTpo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","se ingu mesa, ngala Nasaret. Nini ela lam, Ama Lamtua Allah in teka ka dadi, muid asa man Un mee-baha la in dul meman son noan, “Mam oen noken Una lam, Atuling Nasaret ta.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Dedeng Yesus tene maa son kon, Yuhanis in Sarain Atuli ka mulai tui atuli las se epe in ete tuun mesa, ne propinsi Yudea. ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Un tekas noan, “Kaka-pail in namnau me! Mi totoang musti haoꞌ nol nang soleng mi in kula-sala ngas, le pait muid Ama Lamtua Allah tia. Ta halas ni totoang atuli li boel in taam le daid Ama Lamtua Allah atulin son.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Hmunan nu Ama Lamtua Allah mee-baha mesa, ngala Yesaya dul meman son deng Yuhanis elia, “Mam muik atuli mes haman-haman se maan atuli in aseꞌ le tek noan, ‘Totoang atuli li mana-mana le daek babanan lalan na, halin sium Ama Lamtua Allah in maa kia! Tao titu lalan na taung Una!’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yuhanis in nuli ka banansila el Ama Lamtua mee-baah hmuna-hmunan nuas kon. Un kai-baut in pake ngas dakes nini unta bulu. Un bota la, daken nini hmukit bulang. Un in kaa ka, klamat nol uin pani. ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Dedeng na, atuli hut mamo maas le tutnaal nol Yuhanis. Oen maas deng Yerusalem, nol propinsi Yudea isin nas totoang. Tenga las maas deng ingu-iung man in dadani nol palun Yordan. ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Oen sai dalen nas nol haoꞌ oen in kula-sala ngas totoang, kon Yuhanis sarain oen se palun Yordan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Dedeng na, atuli-atuil deng partei agama Farisi, nol partei agama Saduki, maas nodan Yuhanis le sarain oen kon. Mo nikit Yuhanis netas kon, un nahkaa oen noan, “Hoeh! Mi banansila el ul man nole-lilung daat ta! Mam Ama Lamtua Allah hukung mia, undeng mi in daek dadaat tas. Mi bali noan mi lail putim nal deng Un hukung nga le? Loo! ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tiata in banan dui ka, mi pait bus Ama Lamtua Allah, nol nang soleng mi in kula-sala ngas totoang. Hidim daek sa-saa banan nas, tuladang el kai ina man puting isin banan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Hii ke! Bali noan mi banan son, undeng mi niam upung Abraham in hua-koet deken. Ta Ama Lamtua Allah tao nal baut nias le daid upung Abraham in hua-koet. ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Doha-doha! Ta muik Atuli mes kil taa, le mana-mana in nuk totoang kai ina man in isin banan lo ngas. Nuk hidis sam, Un piul tamang lakos ai dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Auk le sarain mi totoang nini ui, halin daid tada noan, mi bali kudi le nang soleng mi in kula-sala ngas totoang son. Mo mam muik Atuli mes le maa, Un nam uhu dui deng au. Suma daid un atulin in loka-loka tuun kon no, auk tatai lo. Mam Un tao inu mi dalen nas nini Ama Lamtua Koo Niu ka. Un kon tao mi le daid niu, banansila el atuli in pake ai le loe nuli hlukat ta. ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nol Un kil dihang son, le tahing soleng ael hku ka deng beas sa. Hidim Un nisi tamang ael beas na lako tongleo dalen. Mo hku ngas, Un doan tamang lakos ai man kaloe hidi nutus taan lo ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Oras na Yesus niu maa deng Galilea le lako el palun Yordan na. Un maa nodan Yuhanis le sarain Una, ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","mo Yuhanis dai tao lo. Un kaen elia, “Taon elol le auk man musti sarain Tuang ngia? Ni nahluan lo ke? In toma ka lam, tuang man musti sarain au, ta na ka man auk parlun!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mo Yesus situn noan, “Sa-saa lo. Se dedeng nia lam, nang le kaka man sarain Au. Nini ela lam, kit daek muid Ama Lamtua Allah in koma ka.” Ming ela kon Yuhanis siut noan, “Muid se Tuang tuun.” Hidi kon un sarain Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sarain hidi kon Yesus puti deng palun na dalen. Mo nahkitu lam, apan nu holsai. Hidi kam Un ngat net Ama Lamtua Allah Koo Niu ka niu maa se Una, tuladang el korkifi ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kon nam oen ming haup Ama Lamtua Allah fala ka deng apan nu tek noan, “Un nia mo, Auk Anang in namnau ka. Un tao Auk daleng ngi kolo tutungus.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hidi na kon, Ama Lamtua Allah Koo Niu ka kil nol Yesus lako se maan in ete tuun mesa, le halin uikjale kas laih tuan na sob Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Se maan na, Un telang lelo buk aat dedeng buk aat. Kon nam Un lubu isiꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nikit Un lubu ela kon, uikjale kas laih tuan na maa sob Una, noan, “Ku niam baktetebes Ama Lamtua Allah Ana ke? Etan baktebes sam, tadu baut nias le daid in kaa tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mo Yesus situn noan, “Dulan son ne Ama Lamtua Allah Buk Niu ka noan: ‘Atuli li nuli deng kakaat sii lo. Molam oen musti hii-ming se Ama Lamtua Allah in Teka-teka ngas kon, nol daek muid Un in koma ka.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kon nam uikjale na kil nol Yesus lako se kota Yerusalem, Ama Lamtua kota niu ka. Hidim un nol sakeng Yesus lako se Um in Kohe-kanas Tene ka dapa, se maan in lapa dudui ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Uikjale ka tekan elia, “Eta baktetebes Ku niam Ama Lamtua Allah Ana kam, olan Ku pul niu lako dale ku tia. Ta muik dulan ne Ama Lamtua Allah Buk Niu ka noan, ‘Mam Ama Lamtua Allah lek Un ima-ii in deng sorga nguas, le doh Ku.’ Ne Ama Lamtua Allah Buk Niu ka kon muik in dula noan, ‘Mam oen tod iman nas le tahang Ku, le halin Ku apam ma iil deken, nol Ku iim ma tom se baut deken.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mo Yesus situn elia, “Muik in dula ne Ama Lamtua Allah Buk Niu ka noan, ‘Ama Lamtua Allah na mo, Tuang deng atuli li totoang, Tiata ku boel sob Un deken’”. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kon uikjale na kil nol Yesus lako se leten in lapa dui mes dapa lolen. Hidim un tulu bel Yesus totoang nusa in ne apan-kloma kia ngas, nol oen in leko-banan nas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tulu hidi nas totoang kon, uikjale ka tekan noan, “Sadi Ku hai bukum ma le todan se au, lam mam auk bel Ku nas totoang.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mo Yesus baet un noan, “Hoe uikjale! Ku lako nodat deng maan ni tia! Ta Ama Lamtua Allah Buk Niu ka tek noan, ‘Ku musti todan-lahing se Ama Lamtua Allah, nol ku musti daek taung Un sii.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ming ela kon uikjale na haung boka lako nang soleng Yesus. Mo nahkitu lam, Ama Lamtua Allah ima-ii mes deng sorga maa le lii-lau Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Dedeng na lahing Herodes sa tamang Yuhanis in Sarain Atuli ka se bui dalen. Nikit Yesus ming haup ela kon, Un pait lako Galilea. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Un lako se Un ingu la, iung Nasaret, hidim Un lako napiut le daad se Kapernaum. Iung na ne tubu Galilea suut ta, ne Sebulon nol Naftali dale ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nini ela, Un tao muid Ama Lamtua Allah mee-baah Yesaya la in dul meman son noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Dale Sebulon nol Dale Naftali, man dani nol tubu Galilea, ne palun Yordan halin leol-denen. Atuil Yahudi lo kas daad ne as. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Oen nulis ne mitang dalen, mo halas ni oen net Langa ka son. Lole Langa ka kaloe son, bel totoang atuil man taan Ama Lamtua Allah lo bii ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ninin deng oras na kon, Yesus tui atuli li noan, “Mi musti bali kudi le nang soleng mi in kula-sala ngas, le nuil niu tia! Ta halas ni asii tukun, bisa tama daid Ama Lamtua Allah atulin son.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Neot mesan na, Yesus laok muid tubu Galilea suut ta. Kon Un tutnaal atuli at dua pali-kaka. Mesan na ngala Simun, mo atuli las taom haman noan Petrus. Nol un palin na, ngala Anderias. Oen saal ikan se tubu ka, undeng oen duas na mo atuil tasi. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kon Yesus haman oen noan, “Maa, le muid Au! Taom mi nuting ikan, mo Auk le tui mi halin daid atuil in nuting hmangi.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ming ela kon, oen duas nang soleng oen sala la, le lakos muid Yesus meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hidi nam Yesus laok napiut bubuit pait, kon Un ngat net Sabadeus anan nas. Kaka la ngala Yakobus nol palin na ngala Yuhanis. Oen duas leo-leo nol oen aman na tao babanan pukat ta se oen lui la dale. Kon Yesus haman oen duas le muid Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ming ela kon, oen nang soleng oen aman na nol lui la, le lakos muid Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Hidi nam, Yesus nolas laok papmes propinsi Galilea, le Un tui se atuil Yahudi las um in kohe-kanas sas. Un tui deng Ama Lamtua Allah Dehet Dais Banan na, nol tek puting lalan elol le halin nam atuli li bisa daek muid Ama Lamtua Allah in prenta ngas. Un kon tao banan atuli las deng oen ili koed-ngasing ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nesang lo kon, dehet deng Yesus in tao ela ka, holhising lako papmes propinsi Siria. Kon nam, atuli las kil nol oen atulin in iil bili-ngala ngas maas bel Yesus. Oen kon kil nol oen atulin in tom uikjale, nuin laen nol hlukut-kait tas. Ti Yesus tao banan oen totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dedeng na, atuli hut mamo muid Una. Oen maas deng propinsi Galilea, nol deng dale Dekapolis, man oen noken kon noan, Kota Hngulu. Tenga las pait, maas deng kota Yerusalem, propinsi Yudea, nol deng palun Yordan halin na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nikit Yesus net atuil hut mamo nas in maas muid Un ela ka kon, Un saek lako se leten ana mes dapa, le daad se la. Un ima-ii man in huil nal son nas, maas dadani le hii se Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Hidi kon Un mulai tui oen noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ulat bating atuil kasiang ngas, undeng Ama Lamtua Allah esa, man daid Laih banan taung one. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ulat bating atuil in dalen ili ngas, undeng mam Ama Lamtua Allah esa, man halmui-halmau one. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ulat bating atuil man in dalen deng dadale ngas, undeng mam oen sium totoang hangun, man Ama Lamtua Allah in hid son nas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ulat bating atuil in kom isi le haup Ama Lamtua lalan lolo ka ngas, undeng mam Ama Lamtua beles asa man oen in komang nas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ulat bating atuil in dalen lila ngas, undeng mam Ama Lamtua Allah kon tulu Un dalen lila la bel one. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ulat bating atuil man dalen niu ngas, undeng mam oen siis man net Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ulat bating atuil man mole-daem atuli ngas, undeng Ama Lamtua Allah tek noan, ‘Oen nam mo, Auk anang.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ulat bating atuil in haup susa, undeng muid Ama Lamtua Allah ngas, ta Ama Lamtua nam, oen Lahin. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mi kon ulat, etan atuil didang tao susa-daat saol mia, undeng mi in muid Au ka. Eta oen aa mi dadaat, nol dehet nole-lilung le tao didaan mi ngaal banan na lam, mi kon ulat. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Elol kon no, mi musti dalen kolo tutungus, undeng mam Ama Lamtua Allah bel seda mi in hapu mamo isi se sorga. Mo nangan ne! Suma mi siim man haup susa-daat ela lo, ta hmunan nu atuli las tao Ama Lamtua Allah mee-baha las dadaat ela kon.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Etan kit le tao mingis in kaa mesa lam, kit musti buli sil le. Mi niam kon daid sil se apan-kloma kia. Tiata atuli-atuil in ne apan-kloma ki ngias, nuting mia. Mo eta sila la milu lo son nam, taon elola le un daid milu pait ta? Suma kat soleng lako se lalan, le atuli li kida deng dapa tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mi in nuli ka kon musti banansila el hadut ta, le halin nam atuli mamo ngat net nol babanan. Nol un langa ka kon banansila el kota mes ne leten dapa, man atuli li totoang ngat netan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Atuli hoet hadut, hidim tamang lako mul-dale dalen lo. Mo oen todo hadut ta se maan lalapa, le halin laang totoang uma la dalen na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mi in nuli ka kon musti langa ela, le halin atuil tenga las net mi in nuil babanan na. Eta oen net mi in nuil ela ka lam, mam oen naka Ama Lamtua Allah noan, ‘Wuii! Mi Aman in ne sorga ku, muun isi ko!’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mi nangan noan, Auk maang se apan-kloma ki le kose soleng Ama Lamtua Allah atorang, man Un beles son se upung Musa ka deken. Nol nataka noan, Auk tiu-hii lo nol Ama Lamtua Allah mee-baha las in tek meman son deng hmunan nua ka deken. Ta Auk in maa nia, le tao nas totoang daid muid asa man oen in dehet meman son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Undeng na le, hii babanan ne! Eta totoang daid muid Ama Lamtua Allah atorang ngas lo bii kam, apan-dapa ku nol apan-kloma ki bisa dudus lo. Titik-koma mes deng atorang nas kon, kose soleng nalas lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Atuli kaliut Ama Lamtua atorang nga, undeng un nangan noan, ‘Eh, atorang ni kahan tuun, muik nahin lo!’ Hidim un tui atuil tenga las ela kon nam, mam Ama Lamtua Allah in ne sorga ku, tao un daid atuil ana dui. Mo atuil man daek muid Ama Lamtua Allah atorang ngas totoang, hidim un tui atuil tenga las ela kon na, mam Ama Lamtua Allah tao un daid atuil in muik nahin. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Parsai se Au! Eta mi nuil lolo dui deng guru agama las nol atuil Farisi las lo kam, mi tamam nal le daid Ama Lamtua Allah atulin lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mi taan upung Musa atorang man un tek kit upu kia-kaon nas meman son noan, ‘Keo atuil deken, ta asii keo atuli lam, taon elol kon un tom in hukung.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Molam Auk le tek elia: komali nol apa deken, ta eta asii komali nol un pail-kakan nas sam, un tom in hukung. Atuil in ngau un palin tamlom un kaka ka, hidim tekan noan, ‘Ku ngengo hinin!’ kam atuling na musti laok taal se blalan-blalan agama las. Nol atuil in ngau un kaka, tamlom un palin na le tekan noan, ‘Ku nuin!’ nam, mam un tom in hukung se ai naraka lua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tiata eta ku kil in bele, le bel Ama Lamtua Allah, mo ku nangan net noan, ku pail-kakam mes koon-mali nol ku nabale lam, ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tamang sa-saa in beleng nas deken le. Ku musti laok babanan nol ku pail-kakam ma muna le, hidi halas-sam laok tamang in beleng nas bel Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Eta atuli le tao dais nol ku lam, banan dui ka ku lalaba laok daem nol un muna. Eta lo kam, mam atuling na kil nol ku lako ngada se atuil in nutus dasi ngas. Hidim atuil in nutus dasi ngas tunang ku lako se polisi las, kon oen tamang ku lako bui dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Auk in aa ni tom baktebes! Etan ela son nam, ku daad napiut se bui ka dalen, didiin ku baen nuli ku hningin nas totoang.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mi taan upung Musa atorang man noan, ‘Nong deken’ na son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mo Auk le tek elia: atuil man ngat net bihata mesa, hidim un kom isi le niin nolan el un sapa ka lam, biklobeng na laok kula nol bihatang na ne un dalen na son. Ela kon nol bihata lia. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Eta ku tao kula nini ku matam kanan na lam, sukin soleng tuun tia. Ta ku tama sorga nol matam beas mes sii kam banan dui deng, oen soleng ku lako ai naraka lua, nol ku matam beas sas duas tetema. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nol etan ku tao kula nini ku imam kanan na lam, liuh soleng tuun. Ta ku tama sorga nol iman halin sii kam banan dui deng, oen soleng tamang ku lako ai naraka lua, nol ku imam mas duas tetema.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mi taan upung Musa atorang nga son, man noan, ‘Atuil in dai soleng un sapa-bihatan na ka, un musti bel surat in dai se bihatang na.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mo muid Au lam, elia: bikloeb man dai soleng un sapa-bihatan na, molota un sapa-bihatan na laok kula net lo, mo hidi na kon, bihatang na saap nol atuil didang lolen nam, na banansila el un sapa-bikloben hmunan na, man tao un le nonga. Nol eta biklobe mes saap bihata mes man dai neta, lam, oen duas kon nong apa son na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mi taan upung Musa atorang in bel kit upu kia-kaon nas son, man noan, ‘Eta ku nikit in hida nini Ama Lamtua Allah ngala ka lam, ku butu-kil nol in hida na son.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mo Auk le tek elia: eta ku nikit in hida kam, nini sumpa deken. Sumpa nini sorga ngala deken, undeng sorga na mo Ama Lamtua Allah maan in dada ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Sumpa nini apan-kloma ki ngala deken, undeng apan-kloma ki niam mo, Ama Lamtua Allah maan in tian iin na. Nol sumpa nini Yerusalem ngala ka deken, undeng Yerusalem na mo Lahing Tene ka kota. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Sumpa nini mi bon nas deken. Ta mi muik kuasa le prenta klanga mes halin daid mitang tamlom muti lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tiata eta mi nikit in hida noan, iya lam, tek tuun noan ‘Iya’. Mo eta lo kam, tek tuun noan ‘Loo’. Ta eta mi tek dui deng na nini in sumpa bili-ngala kam, na maa deng uikjale kas son na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mi taan upung Musa atorang nga son, man noan, ‘Eta muik atuli in tao didaan ku matam ma kam, tao didaan un mata ka kon. Nol eta muik atuli in tao nahu ku siim ma kam, tao nahu un siin na kon.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mo Auk le tek elia: balas in daat ta nini daat deken. Eta atuli papas ku pipim halin na lam, nang le un papas ku pipim halin na kon. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Eta muik atuli in tao dais nol ku, le noan kat ku kado la lam, bel taplaeng ku kaod metes sa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Eta muik tentara mes dising ku le lep belen sa-saa las katang nga kilu mesa lam, lep napiut belen didiin kilu dua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Eta muik atuli nodan ku sa-saa lam, belen tuun lako. Nol eta muik atuli le nodan tahang ku sa-saa mesa kam, belen lako.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mi ming atuli tek noan, ‘Namnau ku nenam in namnau ku ngas, mo namnau ku musu las deken.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mo Auk le tek elia: ku musti namnau atuil in kom ku lo ngas. Nol nodan le Ama Lamtua bel hangun se atuil in tao susa-daat saol ku ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Eta ku tao ela lam, ku tulu bel noan, ku niam mo Ama in ne sorga ku ana. Undeng Un tao lelo la le langa taung atuil banan nas, nol Un tao lelo la le langa taung atuil daat tas kon. Un kon niung ulan bel atuil in lako-daek muid Un prenta la ngas, leo-leo nol atuil in labang Un prenta la ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tiata eta ku suma namnau atuil man in namnau ku ngas siis sam, ku bali noan Ama Lamtua Allah musti balas ku nini hangun ne? Loo! Ta atuil daat tas kon namnau oen tapan man namnau one ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tiata eta ku suma aa boa-blingin, se ku tapam mas tuun nam, in dui ki asa la? Ta atuil in parsai Ama Lamtua Allah lo ngas kon tao ela. ");
INSERT INTO hegNTpo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tiata nangan ne! Ku Amam in ne sorga ku namnau atuli li totoang. Ta ku kon musti daek muid ela!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesus tui napiut noan, “Nangan ne! Muid atorang agama la le halin atuli naka-naka mi deken. Ta eta mi tao ela lam, mam mi Aman in ne sorga ku bel mi saa mes lo kon. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Eta mi le tulung atuil kasiang ngas sam, laok dehet mi in dake na se ola-ol deken. Ta eta mi tao ela lam, mi banansila el atuil in nuting ngala tuun, man aa kam kisa mo dake lam kisa. Atuil in ela ngas taom kom in laok se um in kohe-kanas sas, le halin atuli naka oen noan, ‘Wuii! Atuling ni muun isi ko!’ Auk in aa ni baktetebes! Haup in naka ela na, oen sium nuli oen in hapu ngas son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tiata eta mi le tulung atuil kasiang ngas sam, tek atuil deken ne! ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nini ela lam, atuil apan-kloma ki taan lo. Mo mi Aman in ne sorga ku taan asa man mi in daek nol ete-ete na. Ta mam Un balas bel mi hangun mamo-mamo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Eta mi kohe-kanas sam, tao apan banansila el atuil in aa kam kisa, mo dake lam kisa ngas deken. Oen kom in laok se lalan man muik atuli hut mamo, nol dil se um in kohe-kanas sa dalen, le halin atuli hut mamo netas nol naka-naka oen noan, ‘Wuii, oen niam mo atuil niu!’ Mo hii ke! Haup in naka ela na, oen sium nuli oen in hapu ngas son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mo mi boel tao ela deken. Eta mi kohe-kanas sam, taam lakom kamar ra dalem, le hep hnita ka. Hidim kohe-kanas ete-ete se mi Aman in ne sorga kua. Atuil tenga net lo kon no, mi Aman na neta. Tiata mam Un balas bel mi hangun mamamo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Eta mi kohe-kanas sam, aa likut lako pait deken. Ta atuil in taan Ama Lamtua Allah lo ngas kon, kohe-kanas sam ela. Oen nangan noan, Ama Lamtua Allah kom in ming oen in kohe-kanas man blatas ela ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tao muid el one la deken ne! Ta mi nodan sa-saa deng mi Aman in ne sorga ku lo bii kon no, Un taan parsis asa man mi in parlu ngas son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tiata eta kohe-kanas sam, not muid nia: ‘Ama man in ne sorga! Ama ngala ka niu dui hihidi. Nang le halin atuli li totoang nikit sakeng Ama ngala in loe-liliman na lapa-lapa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nang le Ama daid Laih taung atuli li totoang! Nang le totoang atuli li daek muid Ama in prenta se apan-kloma kia ka, banansila el Ama ima-ii las in daek muid Ama prenta la se sorga ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ama tulung le bel kaim lelon-lelon nam in kaa nola. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kaim nodan Ama le kose soleng kaim in kula-sala ngas, banansila el kaim kon nadidingun atuil in tao kula saol kami ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ama, doh kaim le halin kaim tao kula-sala deken. Nol sas-sao kaim deng uikjale ka in kuasa ka. Ta Ama na mo Laih man in kuaas dui hihidi nol muun isi. Ama man kil bandu didiin hidi nutus taan lo. Kaim in kohe-kanas sa ela tuun Ama. Amin.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mo hii ke! Eta mi nadidingun atuli in tao kula-sala saol mia ngas sam, mam mi Aman in ne sorga ku kon kose soleng mi in kula-sala ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mo eta mi nadidingun oen in tao kula saol mia ngas lo kam, mam mi Aman in ne sorga ku kon nadidingun mi in kula-sala ngas lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Eta mi kohe-kanas nol telang ngam, tao mi silan nas bloen tuun tuladang el atuil man aa kam kisa, mo dake lam kisa ngas deken. Ta oen tao ela le halin atuli li nakas noan, ‘Hao! Oen nam mo atuil niu!’ Mo hii ke! Haup in naka ela na, oen sium nuli oen in hapu ngas son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mo eta mi telang ngam, laul mi silan nas niu-niu nol koon mi klangan nas babanan! ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Le halin eta atuli net mia lam, oen taan noan mi telang deken. Mo mi Aman nu man tana. Mam Un bel seda mi hangun mamo-mamo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Daek mumuun le dulu hmuki-nala mamamo se apan-kloma ki deken. Ta mam naen nol enas tao didaan hmuki-nal nas. Nol atuil in nakong ngas kon, maa sukun le kat lail-ninis. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mo in banan dui ka, mi daek mumuun le dulu hmuki-nala mamamo se sorga. Ta se ua lam, naen nol enas tao didaan nalas lo. Nol atuil in nakong ngas kon maa sukun le kat lai-niin nalas lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ta mi pesang mi hmuki-nalan nas ne ola sam, taon elola ko mi dalen nas kon napin didi ne as.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Atuli li matan na banansila el hadut, man tao langa un dalen na ka. Eta un mata ka langa kam, un muid lalan in nuil banan na, banansila el atuil in laok ne langa dalen na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mo etan un mata ka langa lo kam, un laok muid lalan banan na lo, banansila el atuil in laok kapas-kapas tuun ne mitang dalen na. Tiata eta langa in ne mi dalen na ngas langa lo son nam, mi kon nulim ne mitang dalen.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Atuli li daek nal baktetebes bel tuang dua lo, undeng mam un kom tuang mesan na dui deng tuang mesan na. Ela kon un muid tuang mesan na, mo un dai toe muid tuang mesan na lo. Undeng na le, ku bisa tek lo noan, ‘Lamtua nam mo auk Tuang,’ eta ku tao duit ti le daid ku tuang son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tiata Auk le tek elia: kukaum nol in nangan noan, auk in nuli ki elola, tam auk le kaa-niun asa, nol pake asa ka deken! Mi bali noan in nuli ki nia mo taung in kaa tukun ne? Nol kit apan ni suma taung in pake kado tuun ne? Ela loo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Olan ngat tilu-kee man in hong ne apan nua ngas. Oen kukaum nol in soko-hai le nui-noel halin laok dulu se um in dulu kakaat lo. Mo mi Aman in ne sorga ku papa-piaar oen tutungus. Taon elola ko Un papa-piaar mia ka muun dui deng tilu-kee kas. Tiata nangan babanan le. Ta Un sukat mia lam, lapa dui deng tilu-kee kas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Etan atuli dil saol hdidan le kukaum nol un apa ka lam, un tao nal apa ka le blatas taplaeng nge? Loo! ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Eta ela lo kam, tasao le mi nangan kukaum isi nol in pake kai-batu kia? Olan laok ngat bunga bakung in ne epe kua ngas. Oen sun bung lo, nol tiun seman lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mo hii babanan ne! Laih Soleman kai-baut in leok dudui ngas kon, leok lius bunga bakung ngas in leko ka lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ta Ama Lamtua Allah naleko bunga man suma nuli leol nia, mo ola kam mate le atuli soleng lako ai dalen na. Eta ela lam, taon elola ko Un in naleko mia ka, dui deng bunga nas. Tiata tasao le mi parsai baktetebes se Un lo kia? ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nangan kukaum isi deken noan, ‘Kaim le kaa saa? Mo niun asa? Nol pake asa la?’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ta atuil in parsai Ama Lamtua Allah lo ngas, daek hiti-late le halin haup nas totoang. Molam mia lam, siin-tiud deken, ta mi Aman in ne sorga ku taan totoang asa man mi in parlu ngas son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mo mi musti lako-daek Un osa la, nol muid Un in prenta ngas muna le, halas-sam Un bel taplaeng asa man mi in parlu ngas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tiata kukaum nol in nangan asa man mi in parlu se leol ola bingin dua ngas deken. Ta leol ola ka, nonool un nena. Nangan se leol neot ti sii, ta lo kam ngele isi.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mi tudu atuil deken, le halin Ama Lamtua kon tudu mi deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mi sukat atuil elola lam, mam Ama Lamtua Allah in sukat mia ka kon ela. Hidim mi sukat atuil tenga ka in kula-sala ngas elola lam, mam Ama Lamtua Allah kon sukat mia ka ela. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ta atuli li in kula ka ana mes tuun kon no, ku nangan nakekeon, molota ku in kula ka tene, mo ku bali noan ku muik in kula lo. Na banansila el ku net auh ana mes se ku tapam ma mata ka dale. Molota kai hbatan tene mes kele ku matam ma, mo ku tanan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Taon elol le ku aa noan, ‘Olet! Maa le auk maid puting bel ku auh in mo ku matam ma ka le.’ Molota ku esa net saa lo, undeng kai hbatan tene mes kele ku matam ma. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hoe! Meman ku niam atuil in sila-klupu baktetebes! Kat soleng kai hbatan tene na deng ku matam ma esa muna le, halas-sam ku neta, le maid soleng nal auh ana na deng ku tapam ma mata ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tui Ama Lamtua dais niu ka bel atuil in dai sium lo ngas deken. Undeng oen nam mo, banansila el ngot in sau daat, man mam sau bali mia. Oen kon ngengon na, banansila el bahi ka. Eta atuli lotong belen ranteng in osa laok se un apa ka lam, un taan dadale lo! Ta un in tana ka suma kida deng dapa tuun.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Eta mi kohe-kanas, le nodan tutungus se Ama Lamtua lam; mam Un bel mia. Eta nuting tutungus sam; mam Un tulu bel mi lalan. Eta mi biu tutungus sam; mam Un sai bel mi hnita ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ta totoang atuil in nodan napiut se Ama Lamtua ngas, mam simu. In nuting tutungus sas, mam hapu. In biu tutungus sas, mam Un sai beles hnita. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mi nangan soba-nanan le! Eta tana-ana mes nodan ruti lam, taon elola ko un ama ka belen baut lo, ta loo? ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nol eta tana-ana ka nodan ikan nam, un ama ka belen ul lo! ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mi Aman in ne sorga ku, meman banan baktetebes. Tiata eta atuil daat banansila el mia lia ki kon, kom in bel mi anan nas sa-saa banan nam, salolen le mi Aman in ne sorga kua la! Taon elol kon, eta mi nodan nam, Un bel mi asa man in banan nas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Eta ku kom le atuil didang daek banan saol ku lam, ku musti daek banan saol one. Undeng ni peke deng upung Musa nol Ama Lamtua Allah mee-baah tenga las in tui meman son deng lolo hmunan nua ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Eta atuli li le tama sorga kam, un musti laok muid hnita manget ta. Ta muik lalan dola nol hnita bluang, man atuli hut mamo kom in laok muid na. Mo doha loo! Ta lalan in ela ka, man kil nol atuli li lako naraka lua, le oen bakisan deng Ama Lamtua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Atuil in le tama sorga ka, musti laok muid lalan in susa, nol taam muid hnita manget ta. Ta suma atuli bubuit sii man laok deng na kon no, lalan manget na, man kil nol atuli li lako se Ama Lamtua.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Doha-tiud nol atuil in nole-lilung daat, man nikit bali apan nas noan, oen nam mo Ama Lamtua mee-baha. Ta oen hlak le tao apan nas banan, tuladang el lae-blai ka. Molota oen in daat ta banansila el ngot huin, man maa le kaa lae-blai las sa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Taon elola le mi taan nal atuil in hlak daat ela ngas sa? Ngat deng oen in dake-mana ngas tuun. Tuladang el, atuli li ngat kai isin mesa lam, taan un ina ka meman. Kai isin banan na nam, puti deng kai ina daat lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ta kai ina banan nam, puting isin banan. Mo kai ina daat tam, puting isin daat. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Muik tahan kai ina banan, man puting isin daat lo. Nol kai ina daat tam, puting nal isin banan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kai ina man puting isin banan lo ka, taon elola ko, atuli maa dait soleng, le pasang tamang lako ai dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ela kon nol, mee-baah in nole-lilung ngas. Mi taan oen deng oen in tao-tao ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Mam muik atuli in haman Auk noan, ‘Tuang!’ Mo oen suma aa deng sulan likun nas tuun. Mam Ama Lamtua Allah in ne sorga ku, hutun soleng one. Ta suma atuil man muid baktetebes Un in koma ngas siis, man Un simus le daid Un atulin. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mam lius leol kiamat tia lam, muik atuli hut mamo hao noan, Auk niam mo oen Tuang. Oen hanet Auk noan, ‘Tuang nge! Kaim laok bani-bating Tuang in tui ngas son. Kaim kon nulut uikjale kas nini Tuang ngala ka. Nol kaim kon tao taad herang bili-ngala nini Tuang in kuasa ka.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Oen taan in hanet Auk ela sii kon no, mam Auk tekas noan, ‘Mi niam asii? Auk taan mi lo, ta mi nuil muid Ama Lamtua in koma ngas lo. Tiata lakom bian deng ni tia!’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Atuil in maa le hii se Au, hidim daek muid Auk in teka ngas sa, un nam banansila el atuil in tana, man bangun-pii un uma la se netes baut dapa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nesang lo kon ulan nauh ina tene, didiin ui tene baa. Angin tuan kon huu tom uma la. Mo um na lea lo, undeng bangun-pii ne netes baut in kuat dapa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Atuil in maa le hii se Au, mo daek muid Auk in teka ngas lo ka, un nam banansila el atuil ngengo, man bangun-pii un uma la se hlaen dapa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nenesang kon, ulan tene nauh didiin ui tene baa. Angin tuan kon huu tom um na. Kon nam, um na lea didiin dudu-dudus.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus dehet hidi ela kon, atuli las totoang herang nol Un in tui ela ka, ");
INSERT INTO hegNTpo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","undeng Un taan baktetebes in tui ngas isin nas. Un lalan in tui ka muun isi, tatai nol oen guru agama las in tui ngas lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus niu deng leten na kon, atuli hut mamo maas leo-leo le lakos muid Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nahkitu lam, atuling in iil baih-bluku mes maa saol Yesus. Hidim un hai buku ka le nodan tulung se Yesus noan, “Tuang nge! Tulung auk le! Etan Tuang tade kam, tao ilang bel auk ili lia, le atuli nikis auk bakun na, halin auk kon bisa taam laok kohe-kanas pait se um in kohe-kanas sua.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ming ela kon Yesus doong ima ka, le kapas atuling in iil baih-bluku na, hidim aa noan, “Auk tade! Ku banan tia!” Kon suknahkitu lam, atuling na ili la ilang meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Hidi nam Yesus tekan noan, “Nangan ne! Ku banan son, mo boel tek atuil deken le. Ku musti daek muid upung Musa atorang nga muna. Tiata ku lako se tulu agama lua, le un tinang ku apam ma, halin un tana noan ku ili la ilang baktetebes son, tam lo bii ka. Hidim ku musti bel sa-saa in todan-lahing, le daid taad in nodan mamo, halin totoang atuli li taan noan, ku banan baktetebes son.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hidi na kon Yesus taam lako kota Kapernaum. Se na, muik komendan tentara Roma mesa, maa le nodan tulung noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Tuang nge! Auk atulin in dake mes heda ngele isi ne uma lua. Un haung nal deng maan in nini ku lo, undeng un boel lo isi.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus situn noan, “Banan! Maa le lam Auk tia tao banan una.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mo komendan na tek noan, “Tuang! Tuang kae-kae le laok deken tia, ta auk tatai in sium Tuang se auk uma lua lo. Sadi Tuang aa tuun deng nia, tiam auk anang in dake ku, banan meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Auk taan dais nia, undeng auk tuang ngas muik kuasa le prenta au. Nol auk kon muik kuasa le prenta auk tentara las. Eta auk prenta auk ima-ii las noan, ‘Laok se nua!’ Lam taon elola ko oen lakos. Eta auk tekas noan, ‘Maa se nia!’ Lam taon elola ko oen maas. Nol eta auk tadu auk atulin in dake ngas noan, ‘Daek nia!’ Lam taon elola ko oen daek ela. Tiata sadi Tuang aa tuun kon no, taon elola ko auk anang in dake ku, banan meman.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ming ela kon Yesus herang. Un aa nol atuil hut mamo man in muid Una ngas noan, “Herang nge! Nesang ngi eli son, mo Auk tutnaal atuil Yahudi mes lo kon, man parsai ka muun el atuling Romang nia! ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Hii ke! Ta mam muik atuil likun el atuling Romang nia, man maas deng leo-sake nol deng leo-dene, le daad kaa fesat leo-leo nol upung Abraham, upung Isak, nol upung Yakob se Ama Lamtua Allah um in ne sorga kua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ama Lamtua Allah huil atuil Yahudi las le daid Un atulin son kon no, muik mamo nabale, man dai muid Un lo. Mam Un hutun soleng oen lakos se maan in mitang-mames sa. Se na, oen lilu mumuun nol susa-daat isi.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aa hidi ela kon, Yesus tek komendan na noan, “Ku pait tia. Ta ku anam in dake ka banan son, muid ku in parsai ka.” Tom nol oras na lam, komendan tentara Romang na ana in dake ka banan meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Hidim oe mesan na, Yesus lako se Petrus uma. Un ngat tam, Petrus been na nini se hadang dapa, lole un hed otot. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesus kil un ima ka kon, blalan bihatang na in hed otot ta, banan meman. Hidi kon un hangu, le lako tutan-lau Yesus nol Un nenan nas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lelo la senet kon, atuli las kil nol oen atulin in tom uikjale kas maas. Kon Yesus prenta uikjale kas noan, “Hoeh uikjale! Putim nodat deng nia.” Kon nam uikjale kas putis meman. Un kon tao banan atuil in ili ngas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Un tao nias totoang, le daid muid asa man hmunan nu Ama Lamtua Allah mee-baah Yesaya la in dul meman son noan, “Un tao banan kit ili las. Nol Un lepa-haal bel kit in susa-daat tas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Hidi na kon, Yesus ngat tam atuli hut mamo maas le dil pukiu Una. Ta Un lok Un ima-ii las noan, “Maa le kit luan laa lakong tubu halin nua.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kon muik guru agama mes maa aa nolan noan, “Ama Guru! Ama laok elol tuun kon, auk muid napiut Ama!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mo Yesus situn noan, “Banan kon! Mo nangan elia. Totoang atuli li nol hmukit tias, muik oen maan in dili-dada esa. Ngot huin pait lako un bolo. Kee-tilu pait lako un hno. Mo Au, Atuling Baktetebes sia, muik uma esa le pait lakong se lang lo. Maan in tian bon kon, muik lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Hidim atuli mes didang pait, man mudi-muid Una, maa nodan noan, “Tuang! Auk le muid Tuang, mo natang le auk pait laok urus auk ina-amang nguas muna le. Eta auk amang nga mate son, halas-sam auk muid Tuang.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mo Yesus tekan elia, “Nang le atuil in dai muid Ama Lamtua lo ngas puan atuil in mate ngas. Ta eta ku le muid Au lam, ku musti muid nol baktetebes!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Hidi na kon Yesus sake lako lui la dapa, leo-leo nol Un ima-ii las. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Oras oen luan laa, le sao bus el tubu ku halin nua ka, Yesus niin nala. Nesang lo kon, angin tuan na huu maa. Len na hiip tamang ui se lui la dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Net ela kon ima-ii las buk-bangun Una, le tekan noan, “Tuang! Tuang! Haung le tulung kaim le! Ta kit le mel mateng son nian!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kon Yesus situs noan, “Hoe, tasao le mi lii isi kia!? Mi parsai Auk lo ke?” Hidim Un hangu dili, le kaing angin na, nol len na noan, “Tenem tia!” Kon nam, len na nol angin na, ete meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ti Yesus ima-ii las herang. Oen tek apa noan, “Huih, Un niam asii le? Taon elol le Un kaing angin ni nol len nia lam, daid muid Un in koma ka lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nesang lo kon, oen lakos lius se tubu ka halin na, se atuil Gadara las dale ka. Se na, muik atuli at dua man tom uikjale. Oen daad se liang baut deng atuil in mate ngas. Oen duas nam daat isi, didiin muik atuli mes lo kon, man brain laok deng maan na. Oen ngat net Yesus maa kon, ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","oen ahan noan, “Hoe! Ama Lamtua Allah Ana! Tasao le Ku maa poe-pet kami lia? Oras in hukung kami ka maa lius lo bii, mo Ku le maa tao bosor kaim son nia ke!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Dadani se na, muik bahi mamo mukan-mukan dale, le nuting in kaa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kon uikjale nas nodan Yesus noan, “Eta Ku le nulut kami lam, tadu kaim taam lakom se baih nuas!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kon Yesus prentas noan, “Laok tia!” Hidi kon uikjale kas lail putis nang soleng atuil at dua nas, hidim taam lakos se bahi las. Kon nam, baih nas lail dadahut nius deng leten na suut ta, le pul taam lakos tubu ka dalen. Tiata oen mel mates totoang se na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Net ela kon, atuil in doh bahi la ngas, lalis pait lakos ingu lua, le nahdeh atuli las deng asa man oen in neta ngas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ming oen in dehet ela ka kon, atuli hut mamo puit lakos se maan na. Oen tutnaal Yesus, kon oen hanet Un le halin lako bian deng oen mana la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Hidi na kon Yesus nol Un nenan nas sakes pait lakos lui dapas, le luan laa lakos tubu ka halin nua, lius se Un ingu-mana la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Se na, muik atuli deeh dohang nol oen tapan in hlukut-kait mes le nolan lako bel Yesus. Net ela kon, Yesus tana noan, oen parsai le Un tao banan nal oen tapan na. Kon nam, Un aa nol atuling hlukut-kait ta noan, “Pail ana! Tao kuat ku dalem ma! Ta Auk kose soleng ku in kula-sala ngas son.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mo se na kon, muik guru agama Yahudi at ila lo, ming Yesus in aa ka. Kon nam, oen holon nam seke tetas. Hidim oen tek apa noan, “Atuling ni brain naseke in aa ela kia! Suma Ama Lamtua Allah sii, man bisa bel ampong atuli li in kula-sala ngas. Mo atuling ni in aa ki, Un tao apa ka banansila el, Un niam mo Ama Lamtua Allah. Un bilu-aa Ama Lamtua nia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mo Yesus taan oen dalen nas. Tiata Un tekas noan, “Tasao le mi nangan noan, Auk aa le bilu-aa kia? ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Eta Auk tek atuling hlukut-kait ta noan, ‘Ku haup ampong deng ku in kula-sala ngas son’ nam, mi taan le daid ela tam lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Molam eta Auk tekan noan, ‘Hangu, le pait tia.’ Le mi net noan daid muid ela, halas-sam mi tana noan, Auk niam mo Atuling Baktetebes sa. Auk muik kuasa le bel ampong atuli li in kula-sala ngas.” Hidim Yesus tadu atuling in hlukut-kait ta noan, “Hangu tia! Nikit maan in dohang ku ka, le lako tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kon nam, atuling hlukut-kait ta hangu, le pait lako uma. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Net ela kon, atuli las totoang herang. Hidim oen nikit sakeng Ama Lamtua Allah ngala ka lapa-lapa noan, “Ama Lamtua Allah na mo muun isi! Un bel atuli li in kuasa tene elia lam.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Hidi deng nam, Yesus laok napiut, kon nam Un ngat net atuil in sium bea ngas at mes daek se maan in baen bea ka. Un ngala Matius. Yesus tekan noan, “Maa le muid Au!” Ming ela kon, Matius haung lako muid Yesus meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hidim un haep Yesus, nol Un nenan nas laok kaa se un uma. Un kon haep un tapan in sium bea ngas, nol atuli teng pait, le maa kaa leo-leo nol one. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mo muik atuli at ila lo deng partei Farisi, maas le ahan Yesus ima-ii las noan, “Tasao le mi gurun na, daad kaa leo-leo nol atuil in tom lo, banansila el atuil in sium bea ngas, nol oen tapan atuil daat tas sia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mo Yesus tekas noan, “Meman atuil in ili kam, nuting dokter. Mo atuil in muik iil lo ngas sam, nuting lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Banan dui ka, mi pait le pres babanan Ama Lamtua Allah in Teka-teka, man hmunan nu Un tadu mee-baah Hosea le dulas, noan, ‘Auk in koma ka elia, Auk atulin nas namnau apa mes nol mesa, hidim tulu dael kasiang nol apa. Eta oen tao ela lo kam, hmukit man oen pakes le todan-lahing Au ngas, muik nahin lo.’ Ta Ama Lamtua Allah man tek ela. Auk maang le nuting atuil in nataka apa ka le banan son nas lo, molam Auk maang le nuting atuil banan lo kas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Hidi na, Yuhanis in Sarain Atuli ka ima-ii las maas tutnaal nol Yesus. Oen ketan noan, “Kaim in muid Yuhanis sias, taom telang. Atuil Farisi las kon telang. Mo tasao le Paap ima-ii las taan in kaa-ninu tutungus sia? Oen taan in telang ngi, tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mo Yesus situs nini kleta noan, “Elia: eta muik fesat in sapa kam, haep pas telang lo, mo oen kaa le didiin silis. Eta biklobeng in sapa ka muik nabael se la kam, taon elola ko oen totoang kaa leo-leo. Mo eta oe mes le, atuil didang maa daek lai-niin una, le un tapan nas haup in susa, halas-sam oen telang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Atuli li kat kitu balu tep mesa, le tapan laok se kaod blaan man sait son na lo. Ta eta baes kado la lam, kitu balu in tapan na naskumu. Eta ela lam, kaod blaan na sait tapnaeng. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ela kon, atuli li sail tua balu laok se sapat in pohen son lo. Ta lo kam sapat ta hoen, le tua ka baa puti. Tiata tua balu kam, salin laok se sapat balu, le halin nam banan.” Nol ela, Yesus tui oen noan Un in tui ka, balu. Tiata kutang nakbuan nol in tui blaan nas deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus nahdeh nol Yuhanis ima-ii las mamasu lam, muik tulu deng um in kohe-kanas sas at mes maa tutnaal nol Una. Atuling na hai buku ka se Yesus sila ka, le nodan noan, “Papa! Tulung auk tia! Ta auk anang bihata la mate hahalas. Paap tulung laok nene imam ma se una, le halin un haup in nuli pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ming ela kon, Yesus nol Un ima-ii las laok muid atuling na meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Se lalan hlala kam, muik bihata mesa, laok muid Yesus dadani deng klupu ka. Un in net bulan na tene taan lo, taun hngul dua son. Un nangan se un dalen na noan, “Sadi auk kapas tom Yesus kado la tuun kon, taon elola ko auk banan.” Tiata un laok kapas Yesus kado la mumu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus nataka tanan, kon Un bali le ngat bihatang na. Hidim Un tek noan, “Baat-ana! Tao teken ku dalem ma. Ta undeng ku parsai se Auk baktetebes, tiata ku banan son.” Nol na kon, bihatang na banan meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hidi na kon, Yesus nol Un nenan nas napiut lakos se tulu deng um in kohe-kanas sa uma. Lius se uas le Un taam lako uma dalen nam, Un net atuil in kuti sasanu dael ili ngas, nol atuli mamo lilu muun isi. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Mo Yesus tekas noan, “Teen in lilu ka, le mi pait tia! Ta tana-bihatang ni mate lo. Un suma nini tuun.” Mo oen mail le liun sulan nol Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hidi na kon, atuil nas putis totoang. Kon Yesus taam lako tana-ana ka kamar ra, le kilan se ima ka. Kon nam, tana-bihatang na nuli pait deng un in mate ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Net ela kon, atuli las dehet apa deng asa man Yesus in tao son na, papmes oen ingu-mana la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Hidi na kon Yesus lako napiut. Se lalan hlala kam, muik atuil tedo at dua muid Una. Oen haman mumuun le tek noan, “Laih Daud in hua-koet te! Kasiang kaim tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesus tama lako uma mes dalen, kon atuil tedo at dua nas muid Una. Ta Un keket oen noan, “Mi parsai baktetebes noan, Auk muik kuasa halin tao mi duam le neta le?” Kon oen duas siut noan, “Ee Papa ketan deen tia, ta kaim parsai Paap baktetebes.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ming ela kon, Yesus kapas oen duas matan nas, hidim tek noan, “Eta ela lam, daid muid mi in parsai ka!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yesus aa hidi ela kon, oen duas ngat net meman. Mo Yesus hidas mumuun noan, “Nangan ne! Boel tek atuli mes lo kon, deng asa man in daid son nia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mo oen tahang nal apan nas lo. Kon oen duas laok pukiu maan na, le dehet deng Yesus in tao son na se ola-ola. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nikit oen duas puit lakos kon, atuli kil nol atuil didang mes pait bel Yesus. Atuling na aa nal lo, undeng uikjale taman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Net ela kon Yesus tadu uikjale ka puti deng atuling na. Nikit uikjale ka puti deng atuling na tukun nam, atuling na aa nal meman. Tiata atuil hut mamo in se la ngas herang-herang. Oen aa noan, “Wuih! Kit atuil Yahudi li net in elia ki lo bii!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mo atuil Farisi las kom lo. Ta oen aa noan, “Hoe! Uikjale kas laih tuan na bel Un kuasa, dadin nam Un nulut puting nal uikjale ela la.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Hidi kon, Yesus laok papmes kota mamo nol ingu mamo, le tui se uma-um in kohe-kanas sas. Un tui atuli las deng Ama Lamtua Allah Dehet Dais Banan na, halin atuli li tama nal le daid Un atulin. Un kon tao banan atuli las deng oen ili koed-ngasing ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Net atuil hut mamo nas kon, Yesus dalen nahi nolas, undeng oen taan le tao elola ka lo. Ta oen totoang nas, banansila el lae-blai man muik atuil in lolo-poa lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kon Yesus aa nol Un ima-ii las noan, “Atuil hut mamo nias banansila el klapa la isin na. Isin mamo son, mo atuil in dake dabun nabale, le nui-noel isin nas halin laok pesang se um in dulu kakaat tua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Undeng na, mi musti nodan klaap Lamtua ka, le halin Un bel atuil in dake, le oen laok tao nakbuan isin nas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Hidi kon Yesus haman Un ima-ii las le maas nakbua. Kon Un beles kuasa le nulut uikjale, nol tao banan atuli las deng oen ili koed-ngasing ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ima-ii at hngul dua man Un in nutus sas ngalan nas elia: Hmunan na ngala Simun (man oen haman noan, ‘Petrus’), hidim un palin na, ngala Anderias, hidi nam, Yakobus, nol un palin na, ngala Yuhanis (oen duas na mo, Sabadeus anan). ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipus, Bartolomeos, Tomas, nol Matius (atuling in sium bea ka). Hidim Yakobus (Alpius ana ka), nol Tadius. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Hidi nam Simun (man muid partei pulitik Selot), nol Yudas Iskariot (man mam hee soleng Yesus). ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Hidi nam Yesus nutus Un ima-ii las hngul duas, nol beles prenta noan, “Auk nutus mi lakom se kit atulin Yahudi las, undeng muik atuli mamo deng one la muid Ama Lamtua lalan na nol baktetebes lo. Oen banansila el lae-blai man in liu ka. Undeng na, tiata mi laok se atuil Yahudi lo kas deken, tuladang el atuil Samaria las. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Molam laok le tek kit atulin Israel las noan, ‘Oras sa maa lius son, le atuli li totoang bisa tama daid Ama Lamtua Allah atulin.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nol laok tao banan atuil man in haup ili ngas, tao atuil in mate ngas le nulis pait, tao banan atuil in iil baih-bluku ngas, nol nulut puting uikjale kas. Ama Lamtua bel mi in hapu mamamo son, mo Un nodan pait mes lo kon. Tiata mi musti laok bel atuli las mamamo deng mi in hapu ngas, mo boel nodan pait sa-saa deng oen deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Lako lam kil sa-saa deken ne. Kil duit deken, ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","kil in kaa se lalan deken, kai-baut in silu deken, nahan tamlom mo hnikan deken. Ta atuli li musti bel asa man atuil in dake ngas in parlu ngas, le halin oen nulis. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Eta mi tamam se kota mesa, tamlom ingu mesa lam, nuting atuil in tade le sium mia ngas. Hidim daad se na didiin, mi bok lakom deng maan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Eta mi taam lakom se atuli mes uma kam aa noan, ‘Boa-blingin! Ama Lamtua bel mi hangun.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Eta atuil in se um na ngas sium mi nol babanan nam, mi nodan le Ama Lamtua beles hangun. Mo eta oen sium mi lo kam, Ama Lamtua kon beles hangun lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Eta atuli dai hii-ming se mi lo kam, putim deng iung na, tamlom kota na, hidim sii soleng auh in se mi iin na ngas, le daid tada noan, oen dai hii-ming se mi lo, tiata oen lepa-haal oen in kula-sala ngas esan. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mam eta Ama Lamtua Allah nahu hukung bel atuil in se apan-kloma ki ngias sam, taon elola ko, Un nahu hukung ngele bel atuil Sodom nol Gomora las, man hmunan nu in daat isi ka. Mo nangan ne! Ta mam Un nahu hukung ngele dui pait, bel atuil man in dai sium mi lo ngas!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nangan ne! Ta Auk in nutus mia ni, banansila el Auk nutus lae-blai lako se ngot huin in daat isi ngas hlala. Undeng na le mi musti pake kutan, banansila el ula in nuting taan lalan na, nol mi dalen nas musti niu, banansila el korkifi ka in nuli nol babanan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mo doha-doha lo! Ta mam atuli tao mi le bosor isi, tuladang el ngot huin in sau tele lae-blai ka. Mam oen pel nol mi lakom se maan in nehan dais agama kua. Nol mam oen diku-puang mi se uma-um in kohe-kanas sas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mam oen pel nol mi lakom ngada se gubernur ra nol lahing nga, undeng mi in muid Au ka. Mo mi musti pake dola na, le tek oen deng Auk Dehet Dais Banan na. Nini ela lam, atuil man taan Ama Lamtua lo ngas kon, ming haup dehet deng Au. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mo eta oen pel nol mi lakom ela lam, mi lii deken noan, ‘Lakom auk aa noan saa? Tamlom auk siut elola la?’ Nangan le lii ela deken, ta lius un oras sa lam, mi Aman in ne sorga ku tek bel mi in aa elola ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Oras na lam, asa man mi in aa ngas maas deng mi lo, ta Un Koo Niu ka man tui mi le aa elola. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Mam mi tinang esan tuun, tiam se uma mes dalen, eta muik atuli in parsai se Au kam, un kaka-palin nas esan man nuting lalan le keo tele una. Hidim etan ana mes man parsai se Au lam, mam un ama ka esa man keo una. Eta ina-aman nas parsai se Au lam, mam oen anan nas esan man keo tele one. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ngat te, ta mam totoang atuli li kom mi lo isi, undeng mi in muid Au ka. Mo atuil in tahang napiut didiin hidi ka, mam Ama Lamtua Allah belen boa-blingin. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Eta atuli tao mi dadaat se kota mesa lam, lail lakom se kota didang. Auk in tek mia ni toma, mam mi laok papmes totoang kota in se Israel lias lo bii, mo Au, Atuling Baktetebes ni, pait maang son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Auk niam mo mi Gurun nol mi Tuang. Taom atuli todan guru mes dui deng un ima-ii las. Nol oen todan tuang mes dui deng un anan in dake ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Eta ima-ii las tui, le oen in tana ka tatai nol oen gurun na son nam, oen nataka kam nola. Nol eta atuil in dake ngas tui, le oen in tana ka tatai nol oen tuang nga son nam, oen kon nataka kam nola. Tiata nangan ne! Eta atuli noken Au, man daid um lamtua kia, noan, ‘Ku niam Balsebul, uikjale kas laih tuan na!’ Lam salolen nol mia, man daid um isin nas sa, taon elola ko mi ngalan nas daat dui pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Tiata mi lii nol atuil in labang mia ngas deken. Ta asa man atuli li in dakes buni-buni ka, mam atuli li totoang ngat netas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Asa man Auk in tui mi siing-siing nga, mam mi musti laok tek totoang atuli lia. Nol asa man Auk tek mian ete-ete ka, mam mi musti laok papmes totoang ingu-mana las le tek atuli las. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Lii atuli li deken, ta oen suma tao tele nal atuli li aap-sisin na tukun, mo oen tao tele nal atuli li hmangin lo. Tiata mi musti lii se Ama Lamtua Allah, ta suma Un sii man muik kuasa le piul tamang atuli li aap-sisin na nonool hmangin na, lako tasi ai man kaloe hidi nutus taan lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tao tes mi dalen nas. Atuli hee kee ael se pasar, nol osa bubuit tuun. Mo muik tahan mes lo kon man nahi le mate, eta mi Aman in ne sorga ku, tade lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mi Aman in ne sorga ku kon ngat mia ka, lako pes sa-saa anang blutu kas. Mi klangan in ne mi bon nas kon, Un taan hidis. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tiata mi lii deken! Undeng Ama Lamtua Allah in sukat mia ka, osa dui deng kee ale las totoang.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Hidim Yesus aa pait elia, “Atuil in lii lo, le hao Auk se atuil hut mamo in ne apan-kloma ki ngias silan na, mam Auk kon hao un se Auk Amang in ne sorga ku sila, noan, ‘Un nam, Auk atulin.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mo atuil in kaen Auk se atuil hut mamo silan noan, un taan Auk lo ka, mam Auk kon tek Auk Amang in ne sorga ku noan, ‘Auk taan atuling ni lo.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mi bali noan, Auk maang nol kil in dame se apan-kloma ki deken. Ta Auk maang le tao atuli li labang apa mes nol mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Auk maang se apan-kloma kia, muid asa man Ama Lamtua mee-baha las in tek meman son noan, ‘Mam aan biklobe labang nol un ama ka, aan bihata labang nol un ina ka, nol nalen labang un been na, ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ta uma la isin na esa, man labang apa mes nol mesa.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Tiata atuil in tade baktetebes le muid Au ka, musti namnau Auk dui deng totoang; dui deng un ina-aman nas, nol dui deng un anan nas. Ta lo kam, atuling na tatai in daid Auk atulin lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Undeng atuil in tade le muid Au, mo dai lepa-haal in susa-daat lo ka, tatai in daid Auk atulin lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ta atuil man tade le mate undeng in muid Au ka, mam un haup in nuli napiut nol Ama Lamtua. Mo atuil in suma kom le nuil taung un apa ka sii ka, mam un haup in nuli napiut nol Ama Lamtua lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Atuil man sium mi nol babanan nas, kon sium Au. Nol atuil man sium Au ngas kon, sium Ama Lamtua Allah man in nutus Au ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Eta atuli sium Ama Lamtua Allah mee-baha mesa, undeng mee-baah na aa deng Ama Lamtua, lam mam Ama Lamtua balas una ka, banansila el Ama Lamtua in balas mee-baah na ka kon. Nol atuil in sium atuling dael lolo mesa, undeng atuling na muid Ama Lamtua in koma ka baktetebes sa, mam Ama Lamtua balas una ka banansila el Un in balas atuling dael lolo na ka kon. ");
INSERT INTO hegNTpo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Atuil in sium atuil ana ngas undeng oen in muid Au ka, taon elola ko Ama Lamtua balas una. Atuli li suma beles ui muti klas mes sii kon no, Ama Lamtua Allah nadidingun lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nikit Yesus tek hidi Un ima-ii at hngul dua kas kon, Un laok papmes ingu-iung in ne dale na ngas, le tui atuli las nol tekas deng Ama Lamtua Allah Dehet Dais Banan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Dedeng na lam, Yuhanis ne bui dale son. Nikit un ming totoang asa man Yesus in tao son nas kon, un lok un ima-ii las laok ketan Yesus noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Ama Lamtua Allah hid meman son deng hmunan nu noan, Un le tunang Kristus maa halin bel boa-blingin kit atuil Yahudi lia. Paap niam, Kristus se? Tamlom kaim musti natang atuil didang pait ta?” Tiata oen lakos ketan Yesus ela. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ming ela kon, Yesus siut noan, “Mi ming nol net esan son. Tiata mi pait le laok tek kaka Yuhanis noan, totoang daid muid asa man Ama Lamtua Allah mee-baah Yesaya la in dul meman son noan: ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Atuil tedo kas, haup in neta. Atuil hlukut-kait tas, laok nala. Atuil in iil baih-bluku ngas, banan. Atuil kiu kas, ming nala. Atuil in mate ngas, nulis pait. Atuil kasiang ngas, ming haup Dehet Dais Banan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tiata elia: laok tek kaka Yuhanis noan, mam un ulat eta un parsai napiut se Au. Undeng mam Ama Lamtua Allah bel hangun se atuil man in parsai se Au nol hutluul lo ngas!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yuhanis ima-ii las pait kon nam, Yesus aa nol atuil hut mamo kas deng Yuhanis noan, “Dedeng mi laok nuting Yuhanis se maan in ete tuun nua ka, mi nangan noan laok tutnaal atuil tuladang elola la? Taon elola ko mi laok se nua ka, le tutnaal atuil in bloen-blahen, man tuladang el uun in late lako-pait muid angin na lo! ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nol taon elola kon, mi laok le tutnaal atuil in pake kai-baut osa-osa lo, undeng atuil tuladang ela ka suma nuli ne sonaf dalen tuun! ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tiata mi nangan noan mi laok tutnaal atuil tuladang elola la? Mi nangan noan, laok nuting Ama Lamtua Allah mee-baha ke? Lam toma! Un nam mee-baah in muun dudui. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ta Ama Lamtua Allah Buk Niu ka dul meman son deng Yuhanis noan, ‘Hii ke! Auk nutus Auk atulin nia, le laok sai lalan bel Ku.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Hii babanan ne! Se apan-kloma ki muik atuli mes lo kon, man uhu dui deng Yuhanis. Mo deng atuil man in hao noan, Ama Lamtua Allah nam Lahi ka, un atuil in ana dui kon no, un uhu dui deng Yuhanis. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kilan deng Yuhanis in nikit un osa la ka, maa lius leol neot nia, muik atuli mamo son, man tamas daid Ama Lamtua Allah nenan. Mo muik atuli teng pait, man nangan kula noan, oen musti hote-dait le dising atuli li tama daid Ama Lamtua Allah atulin. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Maa lius Yuhanis in Sarain Atuli ka in maa ka, taom kit atuil Yahudi li nuil muid upung Musa nol Ama Lamtua Allah mee-baha las atorang ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ta parsai se Au, Yuhanis nam mo upung Elia, man Ama Lamtua Allah mee-baha las tek meman son, deng un in pait maa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tiata atuil in kom le nangan tana ngas, musti hii babanan! ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Auk bel kleta, le halin mi taan atuil hahalas ni tuladang elola ka. Ta oen nam banansila el tana-anang in dada-daad ne pasar ra ngas. Oen taan in kidu-ahan nol oen tapan nas noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Hoe! Kaim huu suling leo-leo, mo mi tidan nol dalen kolo lo. Hidim kaim tao dain dael ili, mo mi lilu lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mi niam banansila el tana-anang man in kaen daat tas. Dedeng Yuhanis maa ka, un kom in telang, nol niun anggor lo. Mo atuli las noken un noan, ‘Un tom uikjale!’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mo halas ni, Au, Atuling Baktetebes nia, maang son. Auk telang lo, nol Auk niun anggor. Ta atuli las noken Auk noan, ‘Un nam atuil in kom naseke! Mauh daat isi! Un laok nakbuan nol atuil in sium bea ngas! Buan nol atuil in tom lo ngas! Taan apa ka loo!’ Mo mi taad Auk in aa nia le! Ama Lamtua in tana ka, ngat tanan se Un atulin nas in nuli ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hidi na kon, Lamtua Yesus mulai kaing atuil man in daad se ingu dehe ngas. Un tao taad herang mamo dui se la son, mo oen dai nang soleng oen in kula-sala ngas, le muid Ama Lamtua lalan in nuil toma ka lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yesus kaing oen noan, “Mi atuil Korasin nol atuil Betsaida! Doha le! Mam mi nahim tom in daat! Auk tao taad herang bili-ngala son se mi sila-matan, mo mi dai parsai Ama Lamtua Allah lo. Molota mi niam atuil Yahudi, man hao noan taan Ama Lamtua. Mo etan tada-taad herang man Auk in tao se mi ingu la ngas, daid muna se kota Tirus nol kota Sidon nam, taon elola ko nesang ngi eli son ta, atuli-atuil in ne ua ngas, pesang son deng oen in kula-sala ngas, le muid Ama Lamtua. Nol taon elola ko, oen kon pake kai-baut dael ili, hidim tao auh se oen bon nas, le daid tada noan, oen maingasar nol oen in kula-sala ngas. Molota atuil Tirus nol atuil Sidon nas nam mo, atuil Yahudi lo, mo oen hao le taan Ama Lamtua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Baktebes! Mam mi ngat esan! Eta Ama Lamtua nutus totoang atuli li dasi las sam, atuil Tirus sas nol atuil Sidon nas hukung nga, kahan dui deng mi hukung ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Atuil Kapernaum me! Doha loo! Mi nangan noan, mam Ama Lamtua nikit sakeng mi lakom sorgam deken. Ta ela loo! Mam Ama Lamtua pasang tamang mi lakom se naraka lua! Eta noan tada-taad herang man Auk in tao se mi ingu la ngas, daid muna se kota Sodom mam, taon elola ko Ama Lamtua Allah tao didaan kota na lo. Ta eta atuil Sodom mas net taad herang nias sam, taon elola ko oen nang soleng oen in daat tas son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Baktebes! Mam mi ngat esan tuun! Eta Ama Lamtua nutus totoang atuli li dasi las sam, atuil Sodom mas hukung nga, kahan dui deng mi hukung ngas!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Aa hidi ela kon, Yesus kohe-kanas noan, “Papa! Paap man daid Tuang Tene ne apan-dapa kua nol apan-kloma kia. Auk nodan mamo-mamo, undeng Paap buni dais nias nahin na, deng atuil in koaok daat tas nol atuil in nataka apa ka noan, oen nam atuil in tana ngas. Molam Paap sai dais nas totoang bel atuil ana ngas, nol atuil in tao apa ka deng dadale ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Baktebes Papa! Ta na man tao Paap dalen kolo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kohe-kanas hidi ela kon, Yesus tek atuil in se la ngas noan, “Mi hii babanan ne! Auk Amang in ne sorga ku, bel Auk totoang in kuasa ngas son. In taan Auk babanan na, suma Auk Amang ngu sii. Nol in taan Auk Amang ngu babanan na, suma Un Ana ka sii, na Au. Nol Auk huil atuli tenga, le tekas halin nam oen kon taan nal Auk Amang ngu nol babanan. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mi totoang man kaem deng in daek mumuun nas, maa le muid Au! Mi totoang man lepa-haal dais ngele ngas, maam se Au lia! ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Eta mi sium Auk in tui-tikang ngias, le laok leo-leo nol Au lam, kit niam tuladang el aus-sapi dua, man pel kai in bali dale mes leo-leo. Ta Auk daleng ngi niam, banan, nol Auk daleng ngi deng dadale. Eta mi muid Au lam, mi dadim kuat-tes pait. ");
INSERT INTO hegNTpo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Undeng Auk in tui-tikang ngas, sus lo. Nol Auk in prenta ngas, ngele lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Oe mesan na, tom nol atuil Yahudi las leol teen in dake, Yesus nol Un ima-ii las laok deng atuli las klapa dalen. Un ima-ii las lubus, tiata oen ket gandum isin le lako mo kaa la-lalan. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Se na, muik atuli at ila lo deng partei agama Farisi, man kil dididi oen hadat Yahudi la. Net Yesus ima-ii las tao ela kon, oen kaing Yesus noan, “Ku ima-ii las ket gandum isin tom nol leol teen in dake! Tao ela deken! Ta in ela ka kaliut kit atorang nga son.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Mo Yesus situs noan, “Elola! Mi nangan net upung Daud dehet ta lo ke? Upung Daud nol un ima-ii las tain seen, undeng oen lubus isi. Kon, oen taam lakos Ama Lamtua Allah Hleep in Kohe-kanas sa, le kat ruti man tulu agama las in bel Ama Lamtua son nas, le kaa. Molota suma tulu agama las siis, man bisa kaa ruti nas, mo atuil didang ngam bisa lo. Dedeng na, upung Daud nol un ima-ii las kaa, mo muik atuli in bel kula one lo. Mi hnika noan, les taan Ama Lamtua Allah in Dula Niu ka lo! ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ta ne in Dula Niu ka kon dul noan, tulu agama in lii-lau se um in kohe-kanas sas, daek se leol teen in dake. Mo na kula lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Hii ke! Hmunan nu um in kohe-kanas sa atuli nangan dui, mo halas ni muik in muun dui pait. Na mo Au, Atuling Baktetebes sia. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ne Ama Lamtua Allah in Dula Niu ka dalen, Ama Lamtua Allah tek noan, ‘Auk in koma ka elia: Auk atulin nas musti tulu in namnau apa, mes nol mesa. Eta oen tao ela lo kam, oen hmukit in todan-lahing man oen in kil bel Au ngas, muik nahin saa lo.’ Tiata, eta mi nangan taan Ama Lamtua in teka ka baktetebes sam, taon elola ko mi bel kula Auk ima-ii lias lo. Undeng oen tao kula saa lo! ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ta Auk niam, Atuling Baktetebes sa. Auk man muik hak le nutus noan, atuli li boel daek asa, tom se leol teen in dake.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Hidi deng na kon, Yesus lako nang maan na, le lako se oen um in kohe-kanas sa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Se na, muik biklobe mesa, man ima halin na mate. Atuil Farisi las nuting-nuting lalan le bel kula Yesus, eta Un tao banan atuling na tom nol leol teen in dake ka. Kon oen keket Un noan, “Muid kit atorang agama lia lam, boel tao banan atuil tom nol leol teen in dake tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kon Yesus situs noan, “Eta atuli mes lae-blai nahi tama lako bolo dalen, tom nol leol teen in dake kam, taon elola ko lae-blai na lamtua ka laok tao puting deng bolo ka, ta loo? ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Lam Ama Lamtua namnau atuli li dui deng atuling na in namnau un lae-blai la ka. Tiata atuli boel daek dais banan tom nol leol teen in dake.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hidim Un aa nol atuling in ima halin mate ka noan, “Kaka! Doong ku imam ma maa!” Ti atuling na doong un ima halin in mate ka, tukun nam un ima ka banan meman, banansila el un ima halin na kon. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Net ela kon, atuil Farisi las komali isi. Hidim oen haung bokas deng um in kohe-kanas sa, le lakos koo-dalen mes nol apa noan, “Kit musti nuting lalan, le keo tele Una!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mo Yesus taan oen in nangan dadaat ta, tiata Un lako maan didang. Atuli hut mamo muid Una, kon Un tao banan totoang atuil in ili ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mo Un kaing oen noan, “Mi tek atuil didang noan, Auk niam mo asii ka deken.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Un in tao ela ka, muid asa man Ama Lamtua Allah in tek, Un mee-baah Yesaya la meman son noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Olan ngat le! Un niam, Auk Atulin in loka-loka man Auk huil nalan son na. Auk namnau Una, nol Auk daleng kolo tutungus nol Una. Mam Auk belen Auk Koo Niu kia, le Un laok tui atuli li totoang se bangsa-bangsa lias deng Auk lalan in nuil lolo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Un nam, kom in teh kalas lo. Un kon nikit-nikit apa ka lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Un dalen na banan. Un tao sus atuil lo. Kai in mana le tehen na kon, Un lukut tehen napiut lo. Nol hadut in le mate ka kon, Un huu tele lo. Un tui atuli li tutungus, didiin totoang bangsa li tana, le nuil muid Ama Lamtua lalan in nuil lolo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mam totoang bangsa-bangsa lias parsai se Una, undeng oen taan noan, Un nam mo asii ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Oe mesan na, atuli las kil bel Yesus atuling mesa, man tom uikjale, didiin un tedo nol aa nal lo. Kon Yesus nulut puting uikjale ka le tao banan una. Tiata atuling na ngat neta, nol aa nal meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Net ela kon, atuli las totoang herang-herang, hidim oen tek apa noan, “Bet Un niam laih Daud in hua-koet, man Ama Lamtua mee-baha las dulan meman son, deng lolo hmunan nua ka. Un niam, taon elola ko Atuling man kit in natang-natang nga!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mo nikit atuil Farisi las ming ela kon, oen sium lo. Tiata oen tek noan, “Hoe! Atuling ni nulut puting nal uikjale, undeng uikjale kas tuang Balsebul, man belen kuasa na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mo Yesus taan atuil Farisi las in aa ka. Ta Un tek oen noan, “Mi in aa na, tom nol kit in nangan ni lo! Eta se nusa mes dalen, un hutun nas keng bali apa kam, taon elol le nusa na tahang nal napiut ta! Ela kon nol eta atuli se kota mes dalen, tamlom uma mes dalen, keng apa mes nol mesa lam, taon elola ko oen bakisan apa le sisakes ta lo! ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tiata eta uikjale kas taan in mus nol apa si-sii, hidim nulut bali apa kam, nesang lom oen tuang nga kil nal prenta pait lo! ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nangan ne! Mi atulin nas kon nulut puting nal uikjale. Lam oen pake kuaas deng uikjale kia le? Loo! Tiata mi boel aa dadahut noan, Auk pake uikjale kas in kuasa le nulut bali uikjale deken. Mam mi atulin nas esan man nutus noan, asa man mi in tudu Au na, kula. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mo eta baktetebes Auk nulut uikjale ki nini kuasa deng Ama Lamtua Koo la lam, na tulu bel noan, Ama Lamtua nam meman Lahi, man muik ne mi sila-matan son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Eta atuli le maa nuhu-dau sa-saa se atuil in kuat mes uma kam, un musti but atuling na muna le. Hidi halas-sam un nuhu-dau nal atuling na sa-saa las. Auk kon musti tao ela nol uikjale kas laih tuan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nangan babanan! Ta atuil in mes nol Auk lo ngas, musu nol Au. Nol atuil man hulung Auk in dake ngas lo ka, un nam tao didaan tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tiata hii babanan Auk in teka nia le! Ama Lamtua Allah tade son le kose soleng atuli li in kula-sala ngas. Nol eta atuli aa dadaat tom atuil didang ngam, Ama Lamtua Allah tade nabael le bel ampong una. Mo eta muik atuli in brain aa dadaat Ama Lamtua Allah Koo Niu ka kam, Ama Lamtua Allah kose soleng un in kula-sala na pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Eta atuli aa dadaat labang Au, Atuling Baktetebes sia lam, Ama Lamtua tade le bel ampong una. Mo eta atuli aa dadaat le labang Ama Lamtua Koo Niu ka lam, didiin leol kiamat ti kon, Ama Lamtua Allah kose soleng un in kula-sala na lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Hidim Yesus aa napiut nol atuil Farisi las noan, “Nangan babanan! Kai ina banan nam, puting isin banan. Mo kai ina in banan lo ka, puting isin banan lo. Ta deng kai ina ka isin na, atuli li taan noan kai na, banan tam lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mo mi niam banansila el ul man in nole-lilung daat ta! Mi muik tatahan in aa dais banan lo. Undeng asa man muik ne atuli li dalen na ka, man mam puti deng un baha ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Atuil banan nam, taon elola ko aa dais banan, undeng ne un dalen na muik dasi-dasi banan sii. Mo atuil daat tam, taon elola ko un aa dasi-dais daat, undeng ne un dalen na muik dasi-dais daat sii. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Parsai se Au! Ta eta leol kiamat ti maa lisu lam, Ama Lamtua Allah pres totoang atuli li dasi las. Dedeng na atuli li mesa-mesam musti situ-taal un dasin man in muik ambak lo ngas, esan. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tiata doha loo! Ta mam Ama Lamtua Allah sukat mi in aa ngas, le nutus noan mi tom in hukung tam lo ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ming Yesus in aa ela ka kon, muik guru agama dehe, nol atuil Farisi deeh, nodan Un elia, “Paap Guru, kaim kom le net Paap in tao taad herang, halin kaim tana noan, Paap in kuasa ka baktetebes maa deng Ama Lamtua Allah.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mo Yesus baet oen noan, “Hoeh! Mi atuil hahalas ni man dai hii-ming se Ama Lamtua lo ngas! Mi suma taan in daek dadaat sii! Mi nodan taad herang kon no, Auk tao bel mi lo. Undeng hmunan nu Ama Lamtua bel taad herang son nini mee-baah Yunus. Na nol son! ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yunus lelo tilu nol duman tiul se ikan tene mes tain dale! Ela kon nol Au, Atuling Baktetebes sia. Mam Auk niu lakong se atuil hmate kas mana lua, dedeng tilu, lelo tilu. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mam eta Ama Lamtua daid Atuil in nutus dasi se leol kiamat tia lam, atuil Niniwe las dil le daid saksi, hidim klaa nol mi noan, ‘Mi totoang niam ngengom isi!’ Hmunan nu atuil Niniwe las hii-ming Yunus, Ama Lamtua mee-baha la tuun, mo oen nang soleng oen in kula-sala ngas meman. Mo mia lam loo. Molota halas ni muik Atuling mes man uhu dui deng Yunus, muik ne mi hlala ka son, na Auk niang. Mo mi dai muid Auk lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mam se leol kiamat tia lam, ina laih deng Seba, man deng loet-ahen nu kon, dil le daid saksi. Un tulu ima ka le klaa nol mi totoang man nuil hahalas nia ngas noan, ‘Mi totoang niam ngengom isi!’ Hmunan nu lahing bihatang na maa deng maan katang, le net nol mata beas esa deng laih Soleman in tana ka. Molota halas ni muik Atuli mes ne mi hlala ki son, man muun dui deng laih Soleman, na Auk niang! Mo mi dai tiu-hii Auk bubuit lo kon.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Eta uikjale ka tom in nulut puting, deng atuli mesa lam, uikjale na lako maan in ete tuun mes le teen in kae se la. Mo un haup maan in tom nol un dalen na lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kon un nangan noan, ‘Eeh! Haup maan lo elia lam, banan dui ka auk pait lakong daad se atuling hmunan nua ka.’ Hidim un pait, kon un tinang ngam mana la niu tuun, nol mana-koet babanan son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tiata, uikjale na laok haman tapnaeng un tapan at itu, man daat dui deng una. Hidim oen totoang lakos daad se atuling na, le leo-leo tao bosor una. Kon nam atuling na in nuli ka, daat dui pait keko lako. In ela ka kon, tom nol atuil in nuil hahalas nia ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Dedeng na, Yesus dehet mamaus nol atuil hut mamo kas sam, Un ina ka nol Un palin nas maas le noan tutnaal nol Una. Oen dil tuun se likun na, le tadu atuli laok haman Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kon atuli maa tekan noan, “Papa! Ku inam ma nol Ku palim mas ne likun nua. Oen le tutnaal Papa.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesus siut noan, “Auk inang baktetebes sa asii la? Nol Auk pail-kakang baktetebes sas mo asiis sa?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hidim Un tulu laok se atuli-atuil in muid Una ngas, le tekas elia, “Ngat, ta oen niam man Auk inang nga nol Auk pail-kakang ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ta asii man daek muid Auk Amang in ne sorga ku in koma ngas sam, oen nam, Auk nenan baktetebes sas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Leol neot na Yesus puti deng um na, le lako daad se tubu Galilea la suut ta. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kon atuli hut mamo maas dil pukiu Una. Ta Un saek lako daad se lui mes dapa, man nahun se na, le tui atuli las. Atuil in se tuu ka ngas totoang hii se Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kon Un tui oen nini kleta mamo-mamo. Un nahdehes noan, “Atuil in daek klapa mesa, lako se un klapa la, le hising bini. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Oras un hising bini las sa, teng nahis se lalan. Kon kee kas maa noto nuli biin nas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mo muik bini teng nahis tom se dale batu. Biin nas nupu hlapat, undeng dale ka nihis. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mo lelo sake tuun nam, nupung nas bloen le tuus. Lole oen klaput tas taam muun se dale ka lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Muik bini teng pait, man naih tamas se blua-duli dales. Kon blua-duli nas kadis tele nupung nas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mo biin tenga las pait tam, nahis tom se dale boa. Biin nas nupu le daid tenes didiin isin. Muik in haup pait isin, lalis buk tilu, teng haup pait isin lalis buk eneng, nol tenga las haup pait lako pes lalis ngatus. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Asii muik hngila kam, hii babanan no!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Hidi kon Yesus ima-ii las maas le keket Un noan, “Tasao le Paap tui atuil hut mamo nas nini kleta kia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kon Yesus siut noan, “Undeng mi le nangan taan baktetebes deng Ama Lamtua Allah prenta la, tiata Auk tek kleta na nahin na meman. Mo eta atuil didang ngam, Auk tuis nini kleta tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ta atuil in kom isi le nangan taan deng Ama Lamtua in koma ngas baktetebes sa, mam Ama Lamtua taon le un nangan taan dui pait. Mo atuil in dai toe muid Ama Lamtua in koma ngas lo ka, mam Ama Lamtua tao un le ngengo tapnaeng. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Auk tui oen nini kleta tuun, undeng: ‘Oen netan son, mo dai tanan lo. Oen ming son, mo dai muid lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Oen nam banansila el Ama Lamtua Allah mee-baah Yesaya la in dul son noan, ‘Mam mi ming, mo mi dai nangan tanan lo. Mam mi neta, mo mi dai taan asa man in daid son na lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Undeng atuil nias dalen nas didi, oen kon tao oen hngilan nas le kiu, nol tao matan nas le tedos. Tiata nang le halin nam, oen hngilan nas kiu, nol oen matan nas tedos tuun lako. Le halin Auk tao banan oen deken tia, undeng oen dai muid Auk lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mo mi niam ulat! Lole mi net esan nini mi matan son, nol ming esan nini mi hgilan son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Auk in tek mia ni tom baktetebes! Hmunan nu Ama Lamtua mee-baha las, nol atuli-atuil man dalen lolo ngas, kom isi le net asa man mi in net son nia, mo oen netan lo. Oen kon kom isi le ming asa man mi in ming son nia, mo oen ming hapun lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Dehet hidi ela kon, Yesus tek oen noan, “Tiata mi hii deng kleta apin na nahin ni lolen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Biin in nahi se lalan na ka, mo atuil man ming in Teka-teka deng Ama Lamtua Allah in kil prenta ka, mo nangan tanas baktetebes lo. Kon nam uikjale ka tuang nga maa nuhu-dau lai-niin in Teka-teka nas, deng atuling na dalen na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Biin man nahi se dale batu ka, mo atuil man hii-ming Ama Lamtua in Teka-teka ngas, hidim un simus nol dalen kolo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mo in Teka-teka nas muik klaput lo. Undeng na le, tahang nesang se atuling na dalen na lo. Eta atuil didang tao sus una, undeng un in sium in Teka-teka nas sam, un sao soleng in Teka-teka nas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nol biin man nahi se blua-duli hlala ka, banansila el atuil man ming in Teka-tekang ngas son. Mo un kukaum isi nol in lako-dake bili-ngala le halin haup in nuli bana-banan tuun. Kon un in kukamu nas totoang, dising soleng in Teka-teka nas deng un dalen na, didiin muik nahin pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mo biin in nahi tom se dale boa ka, banansila el atuil in tidi hngila ka, le sium in Teka-tekang ngas nol muid Ama Lamtua in koma ka. Hidi kam un daek dasi-dais banan si-sii, tuladang el biin man haup isin na. Muik in haup pait isin lalis buk tilu, muik in lalis buk eneng, nol tenga las haup pait isin lako pes lalis ngatus.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus bel kleta mes pait elia, “Ama Lamtua Allah in kil prenta ka, banansila el atuli mes hising biin banan se un klapa la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Oras duman le totoang atuli li niin nala, kon nam atuil daat maa hising blua lii se klapa la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nikit klapa la puting isin kon, atuil in dake ngas net bluan nas nulis leo-leo nol gandum mas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kon oen laok tek klaap lamtua ka noan, ‘Tuang! Leol neot na kaim hai biin banan se tuang klapa la, ta lo? Lam tasao le halas ni bluan mamo isi son nia le?’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Klaap lamtua ka siut noan, ‘Nas atuil daat tas in dake na.’ Kon un atulin in dake ngas bel in nangan noan, ‘Tuang, kaim laok top nuli bluan nuas se?’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mo un situs noan, ‘Deken! Ta eta mi top bluan nas sam, kit in soko-hai biin banan nas kon hobodos hidi. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nang le oen nulis leo-leo, lakos lius oras in nui-nole ka. Lius oras na, halas-sam auk tek mi elia, “Mi tao nakbuan blua lii las, le hidim butus hbutu-hbutu le loe soleng. Mo tao nakbuan isin banan nas, le tamang lakos se um in pesang kakaat ta.” ’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Hidi nam Yesus dehet napiut noan, “Auk tapnaeng kleta mes pait, le halin mi taan noan, taon elola le Ama Lamtua Allah daid Laih bel atuli mamo kia. Un atulin nas hmunan nu bubuit tukun, mo nesang le keko lako lam, oen mamo tapnaeng nol kuat tapnaeng, banansila el kai beas ana blutu, man atuli hai se un klapa la ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Beas na, ana blutu dui kon no, eta un nuil maa son nam, un daid kai ina man in tene dui se klapa la, didiin kee kas hong maas koet hno se bango ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus bel kleta didang pait elia, “Hmunan nu atuil in muid Ama Lamtua Allah ngas bubuit tukun, mo nesang le lako lam, oen mamo tapnaeng daid buan tene mesa, banansila el bibit ruti, man bihata mes katan le kutang nol tarigu sak mesa. Kon nam bibit ruti na tao tarigu la le hus daid tene.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus tui atuli mamo nini dehet mamo ela, mo Un suma dehet nini kleta tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Un tui ela muid asa man Ama Lamtua Allah mee-baha la in dul meman son noan, “Mam Auk tui nini kleta. Mam Auk tek puting dasi-dais man atuli li ming netas lo bii, ninin deng Ama Lamtua in koet apan-kloma kia ka, maa lius leol nia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Hidi na kon, Yesus lako nang soleng atuil hut mamo kas le pait uma. Kon Un ima-ii las maas le nodan Un noan, “Papa! Tulung tek puting bel kaim kleta deng blua alas sa nahin na le!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kon Yesus situs noan, “Atuling man hising biin banan na ka, Au, Atuling Baktetebes sia. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nol klapa la na mo, apan-kloma kia. Biin banan nas mo atuli-atuil man tamas son, le daid Ama Lamtua Allah nenan. Nol blua lii las nam, atuli-atuil in daid uikjale kas tuang nga nenan. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Hidim atuling daat man maa hising bluan na sa, mo uikjale kas laih tuan na. Nol oras in nui-nole ka, leol kiamat ta na. Atuil in nui-nole ngas nam, Ama Lamtua Allah ima-ii in deng sorga nguas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mam lius leol kiamat tiam, oen tao nakbua bluan nas le loe nulis. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ta mam Au, Atuling Baktetebes sia, tadu Auk ima-ii in deng sorga nguas maa, le halin oen tao nakbuan totoang atuil man muid Ama Lamtua prenta la lo ngas. Nol tao nakbua totoang atuil man neleng atuil didang, le boel muid Ama Lamtua prenta las lo ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mam oen pasang tamang atuil daat nas totoang, lakos se ai naraka dalen, banansila el bluan man tom in loe ka. Se na, halas-sam oen haup in susa-daat isi, nol lilu mumuun teen taan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mo asii man nuil lolo, nol daek muid Ama Lamtua Allah in koma ngas sam, mam oen daad napiut nol oen Ama Lahi, man in ne sonaf sorga kua. Se ua lam, oen langa kaloe banansila el lelo ka. Atuil in kom le ming se Au, halin nangan tana ngas, tidi hngilan le hii babanan!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesus taplaeng kleta mes pait noan, “In kom le nangan taan baktetebes deng Ama Lamtua halin daid Un atulin ni niam, osa isi, tuladang el atuil man kom le haup sa-saa in osa isi mesa, man atuli buni se dale dalen. Atuling na maa kali dale ka, kon un haup sa-saa in osa isi na, tiata un dalen kolo isi. Un puan pait sa-saa na se dale ka, le pait uma lalaba tuun. Hidim un lako hee nuli un hmuki-nalan nas totoang, le lako sos dale na, halin un haup sa-saa in osa isi na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesus nahdeh napiut noan, “In kom le nangan taan baktetebes deng Ama Lamtua halin daid Un atulin na kon, banansila el atuil in sepo-dakang, man kom isi, le haup baut mutiara in osa isi mesa. Tiata un nuting-nuting baut mutiara le sosa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nikit un net baut mutiara mes man leok isi, kon un lalaba tuun pait uma, le lako hee nuli un hmuki-nalan nas totoang. Hidim un lako sos baut mutiara na, le halin nam un hapun meman.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesus nahdeh taplaeng pait noan, “Ama Lamtua Allah in kil bandu ka, banansila el atuli laok sao pukat mes se tasi kua. Kon pukat ta nal ikan bili-ngala. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nikit pukat ta inu nol ikan kon nam, atuil tasi kas laok pel sakeng pukat ta lako onan na. Hidim oen daad le loat ikan nas deng pukat ta. Ikan banan nas, oen nisi tamang lakos se hlika la. Mo ikan ol man banan lo kam, oen pasang soleng. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ela kon nol leol kiamat tia. Mam Ama Lamtua Allah ima-ii las maas deng sorgas, le tao bakisan atuil daat tas deng atuil man dalen lolo ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Mam oen pasang tamang totoang atuil daat tas lakos ai naraka dales. Se na, halas-sam oen haup in susa-daat isi, nol lilu mumuun, didiin hidi nutus taan lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dehet hidi ela kon, Yesus keket oen elia, “Mi nangan taan totoang asa man Auk in dehet apin na son ne?” Oen siut noan, “Nangan tanan son Tuang!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kon nam Yesus siut balis noan, “Banan! Ta guru agama man in tui baktetebes deng Ama Lamtua in Teka-teka, man dulas meman son deng hmunan nua ka, hidim kil dididi asa man Auk in tui hahalas nia ngas, banansila el um lamtua man kom in sai un maan in pesang hmuki-nalan nas, le tulu-balang un hmuki-nalan blaan nas, leo-leo nol un hmuki-nalan balu kas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus tui hidi atuil hut mamo kas nini kleta kon, Un lako nang soleng maan na, ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","le pait lako Un ingu-mana la. Se na, Un tama lako um in kohe-kanas sa le tui atuli las se na. Totoang atuil man hii se Una ngas, herang isi. Oen tek apa noan, “Wuih! Atuling ni in tana ki ana lo mo! Un hkolan se ol nia le? Taon elola le Un tao nal taad herang nas sia? ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Molota Un niam suma tukang kai mes, ana. Kit taan Un ina Maria; nol Un palin nas, Yakobus, Yusuf, Yudas nol Simun. ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kit kon taan Un palin bihata las, ta le kit daad buan ne ingu mesa lam! Tiata Un haup Un in tana ka deng ola ke? Nol Un haup kuasa in muun isi na, deng asii le?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Undeng na le, oen nangan nam seke, didiin oen dai hii-ming pait se Un lo. Mo Yesus tekas noan, “Meman toma! Ama Lamtua Allah mee-baha mes se maan didang ngam, atuli kom in todan una. Mo se un ingu-mana la, nol un um isin nas esan nam, oen kom in todan una lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Oen dai parsai se Yesus lo, tiata Un tao taad herang mamo se Un ingu-mana la lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dedeng na, laih Herodes kil bandu se propinsi Galilea. Un kon ming dehet kose-kose deng Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Un tek un atulin in dake ngas noan, “Yesus niam, taon elola ko Yuhanis in Sarain Atuli, man hmunan nu auk tadu le dait un bon na ka. Halas ni un nuli pait son nia! Undeng na le, un muik kuasa in tao taad herang na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Laih Herodes aa ela, lole hmunan nu un tao dais nol Yuhanis, didiin un daek Yuhanis le tamang lako se bui. Un dehet ta elia: laih Herodes saap nol un palin Filipus sapa ka, ngala Herodias. Molota Filipus nol Herodias dai apa lo bii. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tiata Yuhanis kaing un oe-oe noan, “Ama lahi, boel kat ku palim ma sapa ka deken. Ta na kaliut nol kit hadat Yahudi li son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mo Herodes dai toe muid un lo, un saap nol Herodias tuun ela. Muid in toma ka lam, Herodes kom isi le keo tele Yuhanis in Sarain Atuli ka. Mo un tiud nol atuil hut mamo kas, undeng oen parsai noan, Yuhanis nam mo Ama Lamtua Allah mee-baha. Tiata un tadu un atulin nas le laok daek tamang Yuhanis se bui dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mo nesang lo kon, Herodes tao fesat leol in hua una. Dedeng na, ina bi-laih Herodias ana bihata la, lako tidan saol atuil in haep pas. Un in tidan na leko ana lo, didiin tao Herodes dalen kolo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tiata tidan hidi kon, Herodes haman tana-bihatang na, le tekan noan, “Ku kom le nodan saa deng au lam, teka! Tiam auk bel kun. Auk kil dididi auk in hida nia. Auk sumpa nini Ama Lamtua Allah ngala ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ming lahing nga in aa ela ka kon, Herodias pake dola na le tui ana ka halin nodan Yuhanis bon na. Tiata un laok nodan laih Herodes elia, “Papa! Auk nodan Yuhanis in Sarain Atuli ka bon na, taon se dulang dalen, le kil bel aun maa se nia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ming tana-bihatang na nodan ela kon, Herodes maingasar. Mo un pel pait nal un in sumpa ka lo son, lole totoang atuil in haep pas ming son nam. Tiata un tao muid tana-bihatang na in koma ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Hidim un tadu atuli le laok dait nutus Yuhanis bon na se bui dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Oen dait nal Yuhanis bon na kon, oen taon se dulang, le laok bel tana-bihatang nga. Un sium nal dulang na kon, un totan laok bel ina ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Dedeng Yuhanis ima-ii las ming noan, oen dait nal Yuhanis bon na son kon, oen lakos kat un nitun na, le laok puan. Hidim oen lakos tek Yesus, deng asa man in daid nol Yuhanis son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Dedeng Yesus ming dehet deng Yuhanis in maet son na kon, Un nol Un ima-ii las lakos deng maan na. Hidim oen saek lui le noan lakos se maan in ete tuun mesa, halin teen in kae. Mo atuil hut mamo kas ngat net Yesus nol Un ima-ii las lui la, muid tubu suut ta tuun. Tiata oen putis deng ingu-ingu las, le laok laba-laba tuun, muid lalan dael tuu. Kon nam, oen lakos lius muna Yesus nol Un ima-ii las, se maan Yesus in noan le lako ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nikit Yesus niu deng lui la kon, Un ngat tam, atuli hut mamo daad natang Un son. Tiata Un dalen nahi nolas. Kon Un tao banan oen atulin in ili ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lelo-maun kon, Un ima-ii las maa tekan noan, “Papa! Banan dui ka Paap tadu atuil nias totoang, le laok sos in kaa se ingu-iung man dadani mo nua ngas. Ta lelo-maun son nian! Muik in kaa dudus lo kon ne nia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mo Yesus situs noan, “Deken! Mi man beles in kaa.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mo oen siut noan, “Aau Papa! Kaim muik sa-saa le nalo atuil hut mamo nias lo. Kaim taon elola la? Ta kaim suma muik ruti bua lima, nol ikan dua siis!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mo Yesus tekas noan, “Hao, banan son na. Nolas maa se nia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kon nam, Yesus tadu atuli las totoang le daad nakbua se bluan na dapas. Hidim Un kat ruti bua lim nas, nol ikan dua nas, le ngada lako el apan-dapa, nol nodan mamo se Ama Lamtua Allah. Hidi nam, Un bilas-bilas ruti las nol ikan nas, le tunang bel Un ima-ii las halin oen laok bating bel atuli las totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kon oen totoang kaa didiin silis. Kaa hidi kon, ima-ii las laok kat nakbuan in kaa lisi nas, didiin inu fuli hngul dua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Totoang atuil in kaa ngas, nataka le biklobe lihu lima. Kaih tapnaeng bihata las nol tana-anang ngas lo bii na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Oen totoang kaa hidi kon, Yesus tadu Un ima-ii las le saek lui lakos muna se tubu halin nua. Mo Un dada nabael se la, le tadu atuil hut mamo kas pait. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nikit oen totoang pait kon, Yesus sake lako se leten mes dapa, le kohe-kanas se la. Duman son, mo Un sii nabael se la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Oras na lam, Un ima-ii las lui la lako katang se tubu hlala son. Mo oen tuku-bes bosor isi, undeng lui la lail saol angin, nol len tene kas kon pokas-pakis lui la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nukneha sain kon, Yesus laok muid one. Mo Un laok deng ui dapa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ngat net ela kon, ima-ii las nahkiut isi. Oen aa nol in lii noan, “Hoe! Nu baos tam saa nua!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mo Yesus tekas noan, “Lii deken! Ta ni Au, Yesus!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ming ela kon Petrus siut noan, “Eta ku nam baktetebes Tuang ngam, tadu auk laok deng ui dapang le tiang se Ku la.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kon Yesus situn noan, “Hao! Maa se nia!” Ti Petrus niu deng lui la, le lako bus el Yesus deng ui dapa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mo nikit Petrus nataka kam angin muun kon, un lii isi. Tiata un mele, ta un haman noan, “Idaa Tuang! Tulung auk le!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nol na kon, Yesus doong Un ima ka lalaba le kil Petrus. Un tekan noan, “Petrus! Tasao le ku dalem ma hduan nia? Ku parsai Auk baktetebes lo kia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hidi nam oen duas saek lakos lui dapas, kon nam angin na ete meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Net ela kon, Un ima-ii las naka-naka Un noan, “Wuih! Paap niam meman baktetebes Ama Lamtua Allah Ana!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Oen lakos lius se tubu halin nu kon, oen nius se iung Genesaret onan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Oen in niu lakos sa, atuil hut mamo kas ngat taan oen meman. Ta oen haman tek apa noan, “Hoe! Yesus maa son nian!” Oen lail lakos tek papmes ingu-iung in se na ngas, kon nam atuli las kil nol totoang atuil in ili ngas maas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Oen nodan le eta bole lam, oen sepo tom Un kado la. Undeng oen nangan noan, “Sadi atuil ili las sepo tom Yesus kado la tuun kon, taon elola ko oen banan meman.” Tiata totoang atuil in ili man sepo tom Un kado la ngas, banan meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Oe mesan na, muik atuil Farisi bua mes nol guru agama teng deng Yerusalem, maas tutnaal nol Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Atuil Farisi las kil didi oen hadat Yahudi la. Dedeng oen ming noan, Yesus ima-ii las kaa lam, haun iman muid hadat ta in koma lo kon, oen kom lo isi. Ta oen maas le bel kula Yesus noan, “Tasao le ku ima-ii las kaa lam, haun iman nas muna lo kia? Na labang nol kit upu kia-kaon nas hadat ta son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mo Yesus situs noan, “Mi tao apan nas banansila el atuil banan na, molota mi daat isi! Lole mi taan isi in labang Ama Lamtua Allah prenta la, le muid mi upu kia-kaon nas hadat ta. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ta Ama Lamtua Allah prenta son noan, ‘Todan mi ina-aman nas.’ Nol tapnaeng pait noan, ‘Eta atuli mes lote un ina ka, tamlom ama ka lam, musti hukung tele.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Mo mi tui didang pait. Mi tek noan, ‘Atuli mes ina-aman tuka-dabun isi elol kon no, boel pake sa-saa man un in hid son, le bel Ama Lamtua ngas halin tulung oen deken, undeng un hid hidi son le bel Ama Lamtua.’ Mo nini in tui ela ka, mi soleng Ama Lamtua Allah prenta la son na, le seda nini mi atorang nga lolen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Undeng na le, apin Auk tek mi son noan, mi tao apan nas banansila el atuil banan na, molota mi daat isi! Na tom nol asa man Ama Lamtua mee-baah Yesaya la in dul meman son deng mi lolo hmunan nua ka! Ta Ama Lamtua pake un le dul noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Muik atuli naka Au, suma nini oen bahan nas tuun, mo nini oen dalen nas lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Oen tao ela kon no, parsum tuun. Oen dai muid Auk lo, ta oen suma muid atuli li atorang ngas tukun.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hidi kon, Yesus haman atuil didang in se la ngas le tuis noan, “Tidi hngilan babanan, le halin mi nangan tana! ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Asa man tama lako atuli li bahan na, tao hmomos oen lo. Mo asa man puti maa deng atuli li bahan na, man tao hmomos one.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kon nam Yesus ima-ii las maas le tekan noan, “Paap tana tam! Atuil Farisi las koon-mali isi nol Paap in aa apin na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mo Yesus situs noan, “Mam Auk Amang in ne sorga ku, kat soleng atuil man tui muid Un in koma ka lo ngas. Na banansila el atuli top soleng sa-saa in mula, man un koman lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tiata toe muid atuil Farisi las deken! Ta oen nam banansila el atuil tedo, man pela-noen atuil tedo. Mam oen leo-leo nahis tamas bolo dalen.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kon nam Petrus aa noan, “Papa tulung tek kaim kleta apin na nahin na le!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus siut noan, “Mi kon tanan lo bii ke? ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Un nahin na elia: asa man kit kaan na, taam lako kit bahan, hidim napiut lako kit tain dale, halas-sam puti pait lako maan in soleng ngua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mo asa man puti deng kit bahan nia, man tao hmomos atuli lia, didiin Ama Lamtua Allah kon nikis una, nol dai sium un lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ta muik dais daat mamo, man puti deng atuli li dalen! Banansila el: nangan dadaat, keo atuli, laok kula nol atuli-bihaat man un sapa lo, nako, saksi in nole-lilung daat, nol bilu-aa le tao didaan atuli ngala. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dasi-dais in ela ngas, man tao hmomos atuli lia. Etan atuli li suma kaa, mo haun ima ka muid hadat ta lo kam, na tao hmomos un lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Hidi na kon, Yesus boka deng maan na, le lako se dale Tirus nol Sidon. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Muik blalan bihata mes huan se ingu-dale na, un atuil Yahudi lo. Mo nikit un ming noan, Yesus maa son kon, un laok nodan nol baktetebes elia, “Laih Daud in hua-koet te! Kasiang auk tia! Ta auk anang bihata lu tom uikjale. Un bosor ana lo son.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mo Yesus ete tuun, siut saa lo. Kon Un ima-ii las maa tekan noan, “Papa, blalan bihatang ni taan in koor-taen sii. Banan dui ka Paap tadu un lako deng maan ni tuun tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kon Yesus siut noan, “Ama Lamtua Allah tadu Auk maang le tulung kit atuil Yahudi lia, undeng oen laok kula son el lae-blai in liu ka. Mo Un tadu Auk maang le laok tulung atuil didang lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mo blalan bihatang nga maa dadani Yesus pait. Un hai buku ka le nodan tulung noan, “Tuang nge! Tulung auk tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kon Yesus soleng dais noan, “Kat tana-ana ngas ngae la le soleng bel ngot tas sam, banan lo.” Nahin na noan, Yesus musti hulung Un atulin Yahudi las muna le, halas-sam hulung atuil Yahudi lo kas lolen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mo blalan bihatang nga situn noan, “Baktebes Papa! Mo ngot tas natang ne mija kloma ka. Oen kon kaa asa man in nahi deng tana-ana ngas pingas sa ngas.” Un nahin na noan, oras tana-anang ngas kaa lam, ngot tas kon haup in kaa. Tiata Yesus hulung Un atulin nas kon no, Un musti tinang atuil didang ngas kon. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ming ela kon, Yesus tek noan, “Maam parsai Auk baktetebes mo! Tiata maam pait tia, ta asa man maam in nodan na, daid son!” Hidi kon bihatang na pait. Lius uma kon un tinang ngam, meman un ana ka banan son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Hidi na kon, Yesus nol Un ima-ii las nang maan na, le oen laok lo-lool tubu Galilea suut ta. Oen saek lakos leten mes dapa, kon nam Yesus daad le tui oen se na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nesang lo kon, atuli mamo maas se Una la. Oen kil nol atuil paang sea, atuil tedo, atuil hlukut-hkait, atuil in aa nal lo, nol atuil in iil didang ngas kon. Oen nol atuil in iling nas, laok nenes dadani se Yesus iin na. Kon nam, Un tao banan one. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Net ela kon, atuil hut mamo nas herang. Oen aa nol apa noan, “Idaah! Ni muun isi! Atuil paang sea kas, laok nal nol babanan. Atuil tedo kas, ngat neta. Atuil hlukut-hkait tas, laok nala. Nol atuil in aa nal lo ngas kon, aa nal son! Ni taon elola ko deng Ama Lamtua Allah. Un na mo Lamtua, man kit upu kia-kaon nas in todan-lahing son lo-lolo hmunan nua ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Hidi nal lelo il kon, Yesus haman Un ima-ii las le tekas noan, “Auk namnau atuil hut mamo nias son. Teng maas deng lalan katang, hidim oen kon maas nakbua se ni lelo tiul son, didiin oen muik in kaa lo son. Banan dui ka oen pait nol tain blo deken. Eta lo kam, tam hmatu nalas le oen matan duman se lalan hlala ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mo Yesus ima-ii las siut noan, “Papa! Maan ni katang deng ingu luas. Taon elola ko, kit nalo nal atuil hut mamo nias lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mo Yesus ketan oen noan, “Mi ruti liis bakun na?” Oen siut noan, “Liis itu! Kaim kon muik ikan bubuit!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kon Yesus tadu atuli las totoang le daad se dale ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Hidim Un kat ruti bua iut nas, nol ikan nas le nodan mamo se Ama Lamtua Allah. Un bilas-bilas ruti nas nol ikan nas, le beles se Un ima-ii las, halin oen laok bating bel atuli las totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kon oen totoang kaa didiin silis. Hidim oen tao nakbuan in kaa lisin nas sam, inu popos itu. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Totoang atuil in kaa ngas, nataka le biklobe lihu aat. Kaih tapnaeng bihata las nol tana-anang ngas lo bii na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Hidi nam, Yesus tadu atuil hut mamo nas, le pait umas. Kon Un nol Un ima-ii las saek lui le lakos dale Magadan. ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Oe mesan na, atuil Farisi deeh nol atuil Saduki at ila lo, maas tutnaal Yesus. Oen maa keket-ketan nol Una, le noan kiu nahu Una. Undeng na, le oen nodan Yesus noan, “Tulu bel kaim taad herang le halin kaim tana noan, Ku haup kuasa son deng Ama Lamtua Allah.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mo Yesus situs noan, “Eta lelo dene mo apan na mea kam, mi taan son noan, ‘Ola kam ulan lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nol eta lelo la sake le muik nopen mitang-tilu kam, mi taan noan, ‘Leol neot ni le ulan.’ Eta mi tadas taan oras ela lam, tasao le mi tadas taan tada-taad in daid hahalas ni ngias lo kia? ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Meman mi atuil udin ni, suma taan in tao dadaat sii! Mi dai toe muid Ama Lamtua lo! Tiata mi nodan taad herang kon no, Auk tao bel mi lo. Undeng hmunan nu Ama Lamtua bel taad herang nini Un mee-baah Yunus son. Tiata na nol son!” Aa hidi ela kon, Yesus lako nang one. ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Neot mesan na, Yesus nol Un ima-ii las lius se tubu hlala halas-sam, Un ima-ii las nangan net noan, oen nadidingun in kil ruti taung in kaa se lalan. ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ming oen aa ela kon, Un tekas noan, “Mi musti doha-doh nol atuil Farisi las nol atuil Saduki las bibit ruti la.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ming ela kon, Un ima-ii las nangan tanan lo. Mo oen tek apa noan, “Blalan na aa saa na le? Bet Un aa ela, lole kit kil ruti lo kam?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mo Yesus taan oen in nangan na. Tiata Un tekas noan, “Hoeh! Meman mi lai-lisin son! Tasao le mi aa deng ruti lia! Mi parsai Auk isi lo ke? ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mi nangan taan Auk in kuasa ki lo bii nababael tuun nia? Ta dedeng Auk bilas-bilas ruti bua lima las, le nalo atuli lihu lima ka, mi kat nakbua lisin nas fuli bakun ne? ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Hidim elol pait nol ruti bua iut man, Auk in bating bel atuli lihu aat ta la? Mi tao nakbuan lisin nas popos bakun ne? ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Taon elola le mi nangan taan Auk in aa apin na lo kia? Auk aa deng ruti lo. Ta Auk le hid mi meman, halin mi musti doha-doh nol atuil Farisi las nol atuil Saduki las in tui ka. Ta oen in tui ka, bisa liun-leo nal atuli hut mamo lako papmes ne ola-ola, banansila el bibit ruti la in tao nal tarigu la le daid hokon tene ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesus aa ela, halas-sam oen nangan taan noan, Un aa deng ruti lo. Molam Un aa deng atuil Farisi las nol atuil Saduki las, in tui kula ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Hidi na kon, Yesus nol Un ima-ii las lakos bus el ingu-iung man in dadani nol kota Kaisarea Filipi. Se lalan hlala kam, Un ketan oen noan, “Muid atuli las in dehet tam, oen tek noan, Au, Atuling Baktetebes si niam mo, asii la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Oen siut noan, “Tenga ka tek noan, Paap niam, Yuhanis in Sarain Atuli ka, man nuli pait son nia. Tenga las tek noan, Paap niam, upung Elia. Tenga las pait tam tek noan, upung Yeremia. Etan lo kam, Ama Lamtua Allah mee-baah didang deng hmunan nua ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesus ketan oen pait noan, “Eta muid mia lam, Auk niam asii la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kon nam, Simun Petrus siut noan, “Paap niam Kristus, Atuling man Ama Lamtua Allah hid lolo hmunan nu le tunang maa ka! Nol Paap niam, Ama Lamtua in nuli hidi nutus taan lo ka, Ana!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kon Yesus tekan noan, “Simun, Yunus ana! Ku niam ulat! Ta atuli li man tek ku dais na lo. Molam Auk Amang in ne sorga ku, man tek ku dais na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Hii ke! Nol nia, Auk ngali ku ngalam ma ‘Petrus’. Ta ngaal na nahin na noan, batu. Undeng ku in parsai ka didi na el batu ka son, tiata mam ku daid baut netes taung Auk atulin in parsai ngas. Le halin oen tom in diku-puang didiin mates kon no, oen tahang napiut. ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mam Auk bel ku hak, le doha-tinang Auk atulin nas, banansila el ku kil kunci sorga la. Ta asa man ku kaing se apan-kloma kia, lam Ama Lamtua Allah kon kaing ne sorga son. Nol asa man ku belen dola se apan-kloma kia, Ama Lamtua kon belen dola ne sorga son.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aa hidi ela kon, Yesus kaing oen le tek atuil deken noan Un nam, Kristus. ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kilan deng oras na, kon Yesus tek Un ima-ii las noan, “Auk musti lakong kota Yerusalem. Mo mam lius se uang ngam, Auk haup in susa-daat mamo isi, deng blalan hadat tas, tulu agama Yahudi las tene-tenen nas, nol guru-guru agama las totoang. Mam oen keo tele Au, mo bingin dua ka lam, Auk nuling pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yesus tek ela kon, Petrus pel bian Un deng na le kaing noan, “Papa, aa ela deken! Taon elola ko Ama Lamtua Allah nang ela tuun lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mo Petrus in aa na, muid Ama Lamtua in koma ka lo. Tiata Yesus kaing un noan, “Hoeh! Bian nodat deng nia! Na uikjale kas tuang nga in aa! Ku boel tukan-palan Auk deken! Ku suma nangan muid atuli li in koma tukun, molam muid Ama Lamtua in koma ka lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hidi kon, Yesus tui Un ima-ii las noan, “Atuil in le muid Au ka, un musti tahang le muid tutungus lelo-lelon! Un musti nadidingun soleng un in koma-koma ngas, le muid se Ama Lamtua in koma ka tuun. Atuli las le keo un kon no, un musti muid napiut, banansila el atuli in haal un kai sangsuli la le laok mate ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ta atuil ol man tade le mate undeng in muid Au, mam un haup in nuli napiut nol Ama Lamtua. Mo atuil man suma nuil taung un apa ka sii ka, mam un haup in nuli napiut nol Ama Lamtua lo! ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hii ke! Eta ku haup apan-kloma ki isin nas totoang, mo Ama Lamtua Allah hutun soleng ku lam, ku in ulat ti saa la? Ku lep lai-niin apan-kloma ki isin nas totoang kon no, nas seda nal ku hmangim ma lo! ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Auk tek mi dais nias totoang, undeng Auk niam, Atuling Baktetebes sa. Mam Auk niu pait maang nini Auk Amang ngu in loe-liliman na, leo-leo nol Un ima-ii las deng sorga. Se dedeng na lam, Auk balas atuli li totoang muid asa man oen in dake ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nangan babanan ne! Deng mi nias totoang, mam muik atuli at ila lo man mates lo, didiin oen ngat net Au, Atuling Baktetebes sia, daid Lahi, le kil prenta.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Hidi nal lelo eneng kon, Yesus haman Petrus, Yakobus nol un palin Yuhanis, le oen leo-leo lakos sakes se leten tene mes dapas, halin oen siis se las. ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Lius se leten na dapas kon, oen ngat tam Yesus tuladang nga kisa son. Un sila ka kaloe, banansila el lelo ka, nol Un kai-batu las daid muti kaloeꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Suknahkitu lam, oen ngat net Un nahdeh nol upung Elia nol upung Musa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kon Petrus nangan hapun lo, didiin un aa dadahut noan, “Papa! Se nia lam, kaim nataka kam banan isi! Tiata banan dui ka, kaim koet hlepe tilu. Mes bel Papa, mes bel upung Musa, nol mesan na pait bel upung Elia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petrus aa mamaus ela lam, suknahkitum nopen niu maa bua one. Kon oen tilus herang-herang, oen kon ming fala mes puti deng nopen na tek noan, “Hii ke! Yesus nia mo, Auk anang in namnau ka. Un tao Auk daleng ngi kolo tutungus. Hii-ming babanan se Una le!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ming ela kon, ima-ii las lii isi, didiin oen leas hokobang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mo Yesus maa huud oen le tekas noan, “Hoe! Hangu. Lii deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tiata oen botas bon nas, mo oen net atuil didang se na lo, suma Yesus sii. ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Hidi na kon, oen nius deng leten na. Kon Yesus kaing oen noan, “Asa man mi in neta apin na, tek atuil deken le! Ta Au, Atuling Baktetebes sia, musti mateng muna le. Hidim eta Auk nuling pait son, halas-sam mi bisa tek atuli.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kon oen ketan Un noan, “Paap niam meman Kristus, mo upung Elia ne ola ka? Ta guru agama las tui noan, upung Elia musti maa muna le, halas-sam Kristus maa. Mo muid Papa lam, elola la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus situs noan, “Meman toma. Upung Elia musti maa muna, le halin sai lalan bel Kristus. ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Molam hii babanan ne! Upung Elia maa son, mo atuli li tanan lo. Oen tao sus una, muid oen in koma ka. Ela kon, mam oen tao sus Au, Atuling Baktetebes sia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ming hidi ela halas-sam oen tana noan, upung Elia man Yesus in teka na, mo Yuhanis in Sarain Atuli ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesus nol Un ima-ii las pait kon, oen tutnaal atuli hut mamo, natang one. Kon muik blalan biklobeng mes maa hai buku ka, le nodan tulung se Yesus noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Tuang! Namnau auk anang ngu tia! Ta un iil nuin laen, tiata un bosor isi. Eta ili la maa kam, un naih taam lako ui dalen, lo son nam ai dalen. Tulung kaim tia Tuang! ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Auk nolan lako se Tuang ima-ii las son, mo oen tao banan nalan lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ming ela kon, Yesus baet Un ima-ii las noan, “Hoeh! Mi niam lai-lisin son! Auk tui mi tutungus son, mo mi nangan taan babanan lo bii nabale. Nol mi kon parsai Auk baktetebes lo! Auk musti keeh nol mi didiin bling pait ta? Kil nol tana-ana na maa se nia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ta oen kil belen tana-ana ka, kon nam Un nulut puting uikjale ka deng tana-ana na. Tiata nol na kon, un banan meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hidi deng na, le Yesus nol Un ima-ii las siis kon, oen ketan Un noan, “Papa! Tasao le kaim nulut puting nal uikjale na lo kia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus situs noan, “Mi nulut puting nal uikjale na lo, lole mi parsai baktetebes lo kam. Nangan ne! Eta mi parsai baktetebes se Au, suma ana bubuit banansila el kai beas ana blutu mes tuun kon, mi prenta nal leten mes noan, ‘Hoe leten! Lako seda se nua!’ Lam taon elola ko un lako seda se nua. Ta mi tao nal asa tuun, sadi mi parsai baktetebes se Ama Lamtua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Molam hii babanan! Uikjale kas meman daat isi. Ta mi musti kohe-kanas nol telang, le nodan tulung se Ama Lamtua, lo kam mi nulut puting nal uikjale tuladang ela lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Oe mesan na, Yesus nol Un ima-ii las nakbua se propinsi Galilea. Kon Un tekas noan, “Nesang lo ka kam, oen le hee Auk lakong se atuil didang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Hidim oen keo tele Au, Atuling Baktetebes nia. Meman Auk mateng, mo bingin dua ka lam, Auk nuling pait.” Ming Un in aa ela ka kon, Un ima-ii las dalen iil isi. ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Dedeng Yesus nol Un ima-ii las lakos se kota Kapernaum kon, atuil in sium bea ngas maa ketan Petrus noan, “Mi gurun na baen Um in Kohe-kanas Tene ka bea la, tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kon Petrus siut noan, “Aeh, baen!” Mo Petrus pait maa lius uma, le un tek Yesus lo bii kam, Yesus aa muna son noan, “Simun, olan ku nangan ne. Lahi-laih in ne apan-kloma ki ngias, sium bea deng asii la? Deng oen anan nas esan, tamlom deng atuil didang nga?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus siut noan, “Deng atuil didang!” Kon Yesus aa napiut noan, “Eta ela lam, lahing nga ana ka baen baab lo, ta lo? ");
INSERT INTO hegNTpo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ela kon nol Um in Kohe-kanas Tene ka bea la. Mo kit tao atuil in sium bea ngas le komali deken tia. Tiata banan dui ka, ku laok ngain ikan se tubu kua. Ku ngain nal ikan hmunan na lam, ngaing un baha ka. Tiam ku haup duit lil-muti mes se la. Hidim pake duit na le laok baen kit duat bea la. Ta duit na nol taung kit duat son na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Dedeng na, Yesus ima-ii las maas le keket Un noan, “Papa! Asii man tene dui deng Ama Lamtua Allah atulin nas totoang nga?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kon Yesus haman tana-ana blutu mesa, le maa dil se oen hlala ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Hidim Un tek noan, “Hii babanan! Atuil man in le tama daid Ama Lamtua atulin na, un musti seda un in nangan na, le daid banansila el tana-ana blutu, man nahlae napiut se un ina-ama ka, nol nikit-nikit taan apa ka lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Undeng atuil in tao apa ka deng dadale, tuladang el tana-ana blutu nia ka, se Ama Lamtua sila-mata kam, un tene dui. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Eta asii sium atuil ana tuladang el tana-ana nia, undeng un in parsai se Au ka, lam un sium Auk kon son na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Hidim Yesus tekas pait noan, “Eta muik atuli liun-leo tana-ana blutu mesa, le un muid lalan in kula ka, didiin un parsai Auk pait lo kam, doha loo! Ta Ama Lamtua hukung nga ngele dui, tiata in banan dui ka, but baut tene mes se un leo ka, le nolan laok sao se tasi hlala kua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Apan-kloma ki meman maan in haup daat, undeng muik dasi mamo, man tao atuli li le daek kula-sala. Mo man haup daat dudui ka, atuling in tao atuil didang le didiin oen daek kula-sala ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Eta ku tao kula nini ku imam ma, tamlom ku iim ma lam, liuh soleng tuun tia! Ta ku tama lako sorga nol ku imam halin na sii, tamlom iim halin na sii kam, banan dui deng, oen soleng tamang ku, nol ku ima-iim mas tetema, lako ai naraka lua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Eta ku tao kula nini ku matam ma lam, sukin soleng tuun! Ta ku tama lako sorga nol matam halin na sii kam, banan dui deng, oen soleng tamang ku lako ai naraka dalen, nonool ku matam mas duas tetema.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesus tek pait noan, “Doha loo! Tamlom mi ngat kabaul tana-ana blutu in elia ngas sa. Ta Ama Lamtua ima-ii deng sorga doh one. Nol ima-ii nas dadani nol Ama Lamtua Allah, ta oen bisa lapur Un deng asa man in daid nol tana-anang ngas, bling tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","13","Mi nangan babanan, ta Auk le bel mi kleta elia: atuli mes muik lae-blai ngatus. Neot mesan na, lae-blai las mes sisa lako muid lalan didang didiin nes. Muid mia lam, atuling in lolo-poa ka musti tao elola la? Taon elola ko un nang soleng lae-blai buk sipa beas sipa kas se leten na dapa, le lako nuting lae-blai man in nes na. Eta un haup pait son nam, un dalen kolo nol in net lae-blai mes man in ilang na, dui deng lae-blai buk sipa beas sipa man in ilang lo ngas. Au, Atuling Baktetebes nia, kon maang le bel slamat atuil man in liu son deng lalan lolo ka ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ta suma tana-ana blutu mes man liu kon no, Auk Amang in ne sorga ku dalen kolo lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus tek pait noan, “Eta ku pail-kakam in parsai ngas mes tao kula ku lam, ku musti laok tutnaal nol una. Le eta mi duam siim le, halas-sam ku tekan deng un in kula ka. Etan un hii ku in aa ka lam, mi duam banan apa pait son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mo etan un dai ming ku lo kam, laok taap ku tapam mas, at mesa ta dua, le leo-leo nol ku. Hidim mi laok tutnaal atuling na, le aa nolan pait. Ta ne Ama Lamtua Allah in Dula Niu ka, dul noan, ‘Se dasi mes dalen nam, musti muik saksi at dua ta tilu, man aa ka hnika mes sii, halas-sam bisa sium oen in aa ngas.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mo etan un dai hii se mi lo nabale lam, laok tek jemaat tas. Nol eta un dai sium jemaat tas in aa ka lo kon nam, ngat un banansila el atuil in taan Ama Lamtua lo ka. Eta lo kam, ngat un el atuil daat ta, banansila el atuil in sium bea ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nangan babanan Auk in aa nia le! Asa man mi kaing se apan-kloma kia, Ama Lamtua kaing son ne sorga. Nol asa man mi belen dola se apan-kloma kia, Ama Lamtua kon belen dola ne sorga son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nol Auk tek oe mes pait elia, eta muik atuli at dua deng mia li, kohe-kanas nol dalen mesa lam, mam Auk Amang in ne sorga ku beles asa man oen in nodan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ta eta muik atuli at dua-tiul nakbua le kohe-kanas, undeng oen parsai se Au lam, Auk kon leo-leo nolas se oen hlala ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Hidi na kon, Petrus maa ketan Yesus noan, “Tuang, auk le keket bubuit. Eta auk pail-kakang in parsai mes tao kula auk oe-oe kam, auk musti bel ampong un oe ila la? Oe itu le?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kon Yesus situn noan, “Loo! Ku musti bel ampong un lalis iut kail buk itu, didiin ku kaih nalan pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mi musti tao muid ela, undeng Ama Lamtua Allah nam banansila el lahi mesa, man kaih un atulin in dake ngas hningin nas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Se dedeng un in kahi ka, un tadu un atulin mes le laok haman atuil in dake ngas mesa, man hningin duit se un mamo naseke. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mo atuling in dake na, baen nal un hningin nas lo. Tiata lahing na prenta noan, ‘Laok hee atuling nia, nol un sapa-anan nas le halin oen daid ata. Hidim hee nuli un hmuki-nalan nas totoang, le baen un hningin nias.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ming ela kon, atuling in hningin na lea hai buku ka se lahing nga sila ka, le nodan noan, ‘Idaah Papa! Paap lahi tulung bel auk oras bubuit pait! Tiam auk bel pait auk hningin nas totoang.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ming ela kon, lahing nga dalen nahi nol una. Tiata un kose soleng un atulin in dake na hningin nas totoang. Hidim sao una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mo nikit atuling in dake na puti kon, un tutnaal un tapa mes man hningin duit bubuit se una. Kon un daek un tapa ka, le kes se leo ka, hidim tekan mumuun noan, ‘Hoe! Baen ku hningin nas nol ni tia!’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ming ela kon, un tapa ka lea hai buku ka, le nodan noan, ‘Eee olet! Tulung bel auk dola bubuit pait! Tiam auk bel pait ku auk hningin nas.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mo atuling in dake na siut noan, ‘Bisa lo! Taon elola ko ku musti baen nol ni tia!’ Hidim un tamang un tapa ka lako bui dalen, didiin un baen nuli un hningin nas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nikit atuil in dake tenga las net asa man in daid son na, kon oen dalen ili ana lo. Ta oen lakos tek lahing nga. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ming ela kon, lahing nga haman atuling in dake man taan apa lo na. Le ahan noan, ‘Hoe atuil daat! Undeng ku nodan le bel ampong ku, tiata auk kose soleng ku hningin nas totoang son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mo tasao le ku bel ampong ku tapam ma banansila el auk in bel ampong ku son na lo kia?’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Lahing na koon-mali isi, tiata un prenta le tamang atuling na lako bui dalen. Hidim nang le atuil in doh bui ka ngas, diku-puang una, didiin un baen nuli un hningin nas totoang.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesus hep un dehet ta, le tek noan, “Auk Amang in ne sorga ku kon, kaih ela. Mam Un hukung mia, eta mi nadidingun soleng mi pail-kakan man parsai ngas in tao kula-sala saol mia ka lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus tui-tek hidi nas totoang kon, Un nang Galilea le lako propinsi Yudea, ne palun Yordan halin nua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Atuil hut mamo kas muid Una, kon nam Un tao banan atuil in ili ngas se luas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Muik atuil Farisi at ila lo, kon maas aa le noan kiu nahu Una. Oen keket Un noan, “Muid kit atorang agama lia lam, eta biklobe li saap son kon, un bisa dai sapa ka nini lalan saa tuun, tam elola la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mo Un situs noan, “Mi niam atuil in taan deng agama la isi. Mo tasao le mi taan Ama Lamtua Allah Buk Niu ka isin na lo kia? Ta dulan ne Dehet Hmunan Hesa ka noan, ‘Ama Lamtua Allah koet atuli li, biklobe nol bihata.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nol muik in dula kon noan, ‘Undeng na, tiata biklobe li musti nang un ina-aman nas, le lako nuli koo-dalen mes nol un sapa ka, lole oen duas daid mes son.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Undeng na, eta Ama Lamtua Allah esa man tapas duas le daid mes son nam, atuli li boel tao bakisan deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ming Yesus tek ela kon, atuil Farisi las keket pait noan, “Eta ela lam, tasao le upung Musa tek noan, biklobe li boel dai un sapa ka, sadi un belen surat in dai muna le lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kon Yesus siut pait noan, “Upung Musa nang mi upu kia-kaon nas le dai oen sapa-bihatan nas, undeng oen bon baut banansila el mi kon! Mo dedeng Ama Lamtua Allah in koet apan-kloma kia ka, Un in koma ka ela lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tiata Auk tek mia le! Eta sapa-bihatan na nong muna kam, biklobe li bisa dai una. Mo eta sapa-bihata li nong lo, mo un sapa-bikloben na dai soleng una, hidim lako saap pait nol bihaat didang ngam, un nong son na!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ming Un in aa ela ka kon, Un ima-ii las tek noan, “Eta ela lam, banan dui ka saap deken tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kon Yesus siut noan, “Totoang atuli li sium nal asa man mi in aa na lo. Suma atuil man in haup kuat-tes deng Ama Lamtua le tahang nala ngas siis. ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ta muik atuli deeh saap lo, undeng huas maa lu oen ela son. Tenga las saap lo, undeng atuil didang in tao. Nol tenga las pait, huil le saap lo, undeng oen suma le lako-daek Ama Lamtua Allah osa la tukun. Asii nangan taan Auk in tuing nias sam, nang le un tao muid ela.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Dedeng na, atuli las kok nol oen anan nas laok bel Yesus, halin nam Un nene ima ka se one, le beles hangun. Mo Un ima-ii las kaing atuli las. ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kon Yesus ahan Un ima-ii las noan, “Nang le tana-anang ngas maas se Au lia! Kaing oen deken! Ta atuil in banansila el tana-ana man in nahlae tutungus se oen ina-aman nas, nol nikit-nikit taan apan lo ngas, man daid Ama Lamtua Allah atulin.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hidim Un nene ima ka laok se tana-anang ngas, le nodan Ama Lamtua Allah beles hangun. Hidi na kon, Un bok lako deng maan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Hidim oe mesan na, muik atuli maa ketan Yesus noan, “Paap Guru! Auk musti tao dais banan elol le halin auk taan baktetebes noan, auk haup in tamang sorga nga? Ta auk le nuling leo-leo nol Ama Lamtua Allah tutungus.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kon Yesus situn noan, “Tasao le ku keket Auk dais man in banan ela lia? Suma Ama Lamtua Allah sii man banan. Etan ku le nuil nol Una lam, ku musti nuil muid Un prenta las.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Atuling na ketan pait noan, “Prenta man ola la?” Kon Yesus situn noan, “Keo tele atuil deken; laok kula nol atuli-bihaat deken; naok deken; daid saksi in nole-lilung deken; ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","todan ku ina-amam mas; nol namnau ku pail-kakam mas banansila el ku in namnau ku apam ma esa ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Atuling na siut noan, “Prenta nas totoang, auk daek mudis son. Asa man dabun pait ta?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ming ela kon Yesus tek noan, “Elam, eta ku le muid Ama Lamtua in koma ngas totoang ngam, pait le laok hee nuli ku hmuki-nalan nas totoang. Hidim laok bating un duit ta, bel atuil kasiang ngas. Halas-sam ku pait maa le muid Au. Ta mam Ama Lamtua Allah bel seda ku hmuki-nala mamo-mamo se sorga.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ming ela kon, atuling na pait nol dalen ili, undeng un muik isi. ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hidi kon Yesus aa nol Un ima-ii las noan, “Parsai Auk in aa nia, ta atuil in muki ki sus isi in tama sorga. ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Un in susa ka, banansila el hmukit unta tene mesa, man tama lako un okat ta muid laung bolo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ming ela kon, Un ima-ii las herang-herang. Kon oen siut noan, “Eta ela lam, asii man haup in tama sorga ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Un ngat oen babanan hidim Un tekas noan, “Eta muid atuli lia lam, meman bisa lo. Molam muid Ama Lamtua Allah lam, totoang nas bisa dadi!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kon Petrus ketan noan, “Papa! Kaim nang soleng kaim hmuki-nalan nas totoang son, le muid Papa. Mo kaim haup asa la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Un siut noan, “Parsai se Au! Mam eta Ama Lamtua Allah koet totoang le daid balu son nam, Au, Atuling Baktetebes nia, daad se del in loe-liliman na dapa. Lius dedeng na lam, mi in muid Au ngias kon, daad se del in prenta hngul dua dapas, le daid atuil in nutus dasi, bel ngaal Israel las hngul duas! ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Atuil in laok nang soleng un uma la, pail-kakan nas, ina-aman nas, ana-anan nas, nol un klapa la, le muid Au ka, mam un sium seda pait didiin lalis ngatus. Hidim eta apan-kloma ki kiamat tam, un kon haup in nuli napiut nol Ama Lamtua didiin hidi nutus lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tiata nangan ne! Muid Ama Lamtua Allah in nangan na lam, atuil man in tao apa ka el atuil tene ka, un nam atuil ana dui. Molam atuil man in tao apa ka deng dadale ka, un nam atuil man in tene dui.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Hidi nam Yesus tui noan, “Ama Lamtua Allah in kil prenta ka, banansila el kleta nia: muik klaap anggor lamtua mes puti oskaong bii, diuk eneng, le laok nuting atuli halin maa daek se un klaap anggor ra. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Un haup atuil in dake kon, oen kom leo-leo le eta daek lelo mesa lam, un baen duit lil-muti mesa, muid in biasa ka. Hidi nam, un tadus le laok daek se un klapa la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Diuk sipa oskaong kon, un puti pait lako pasar rua. Se nua, un net atuli at ila lo daad le tao saa lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kon un tek oen noan, ‘Hoe, mi tade le daek se auk klapa lua le? Lam auk baen mi muid in toma ka.’ Ming ela kon, oen tade, hidim oen lakos dake. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Diuk hngul dua lelo ditu nol diuk tilu lelo-hat tam, klaap lamtua ka puti deng uma la, le lako nuting atuil in dake pait. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lelo-maun, nataka le diuk lima son, mo klaap lamtua ka puti lako nuting pait. Un ngat lako-pait tam, muik atuli in dili-dil tuun nabale, kon un keket oen noan, ‘Tasao le mi dili-dil tuun deng oskaong ngu didiin lelo-maun, nol daek saa lo kia?’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Atuil nas siut noan, ‘Papa! Muik atuli in bel kaim os le dake lo kam.’ Kon nam klaap lamtua ka tekas noan, ‘Eta ela lam, mi laok daek se auk klapa lua!’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Diuk eneng lelo-maun son kon, klaap lamtua ka haman un atulin in doha-tinang atuil in dake ngas, le tekan noan, ‘Haman atuil in dake ngas, le baen oen duit in dake ngas mesa-mesa. Mulai deng atuling in tama daek mudi ka, lako lius atuling in tama daek muna ka.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kon nam, atuling na haman atuil in dake ngas, mulai deng in tama daek diuk lima lelo-maun na. Un baen oen mesa-mesam duit lil-muti mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hidim un haman atuil in dake tenga las lolen, didiin lako lius atuil in daek mulai deng diuk eneng oskaong ngas. Atuil in daek deng oskaong ngas nangan noan, taon elola ko oen sium mamo dui deng atuil in tama daek diuk lima lelo-maun na. Molota oen kon sium duit lil-muti mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Sium ela kon, oen kaen nol klaap lamtua ka noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Idaah! Eta elia lam bisa lo tuang! In maa daek hmudin hesa kas, suma daek jam mes sii. Mo kaim in tamam daek deng oskaong bii ngias, daek hiti-late didiin lating baa! Mo taon elol le tuang baen kaim mamon na tatai nol one lia?’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kon klaap lamtua ka siut at mes deng one la noan, ‘Kaka! Auk panaek ku lo. Undeng kaka esa tade le daek lelo mesa lam, baen ku duit lil-muti mesa, ta lo? Tiata auk baen muid asa man kit in kom leo-leo son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Banan dui ka, kaka sium duit in baen ni le pait tia. Eta auk kom le baen atuil in tama daek mudi hesa ka, mamon na tatai nol auk in baen kaka kia lam, na auk hak. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ta auk muik hak le pake auk duit tas muding auk in koma. Lam taon elol le kaka komali nol auk in daek banan saol atuil didang nga lia?’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ela kon, se dedeng Ama Lamtua Allah daid Laih taung atuli lia ka, Un balas Un atulin nas muid Un in koma. Tiata atuil in maa mudi ka, mam un sium mamon na el atuil in maa muna ka. Nol atuil in maa muna ka, mam sium mamon na el atuling in maa mudi hesa ka kon.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Hidi na kon, Yesus nol Un ima-ii las lakos bus el Yerusalem. Lius se lalan hlala kam, Un haman Un ima-ii las, le oen siis buan, kon Un tekas pait noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Hii babanan ne! Kit le lakong bus el Yerusalem son nia. Mo lius se uang ngam, oen hee Au, Atuling Baktetebes sia, bel tene-tene deng tulu agama Yahudi las, nol guru-guru agama las. Hidim oen nutus le hukung tele Au. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kon oen sao Auk lakong se atuil didang, man taan Ama Lamtua Allah lo ngas. Hidim oen aa le tao nahmamaeng Au. Nol oen kon diku-puang Au, didiin Auk apang ngi dudus papmesa. Hidi halas-sam, oen pauk tele Auk se kai sangsuli lu dapang. Meman Auk mateng baktebes. Mo bingin dua ka lam, Auk nuling pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hidi nam, Sabadeus sapa ka maa se Yesus, leo-leo nol un anan nas duas, Yakobus nol Yuhanis. Un hai buku ka le todan Yesus nol hanet Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kon Yesus keket un noan, “Maam le nodan asa la?” Blalan bihatang na situn noan, “Elia Papa! Eta Paap daad le kil prenta son nam, Auk nodan le Paap nikit auk anang ngias duas, le oen kon kil prenta leo-leo nol Papa. Auk nodan le Paap bel mesan na daad se Paap halin kanan na, mo mesan na pait se Paap halin kliu ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ming un in nodan ela ka kon, Yesus tek Yakobus nol Yuhanis noan, “Mi duam taan asa man mi in nodan ni lo. Ta mam Auk haup susa-daat mamo. Tiata elola? Mi nangan noan mi lepa-haal nal in susa-daat nas leo-leo nol Au le?” Oen duas siut nol lalaba tuun noan, “Bisa isi Papa!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kon Yesus situs pait noan, “Meman mam mi kon lepa-haal in susa-daat na banansila el Au. Mo asii man daad se Auk halin kanan na, tamlom halin kliu ka lam, Auk man in nutus lo. In muik hak le nutus ela ka, Ama Lamtua Allah. Ta Un nutus meman son, le asii tuun man daad se maan nas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nikit ima-ii at hngulu las ming oen duas in nodan ela ka kon, oen koon-mali. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mo Yesus haman oen totoang le tekas noan, “Elia! Mi taan son ta lo? Atuil tene man in kil prenta ngas, taom tudan-kida oen hutun nas, didiin oen tao nal sa-saa lo. Nol tulu-tulu deng bangsa man in taan Ama Lamtua Allah lo ngas, prenta nol lai-lisin, didiin oen hutun nas botas nal bon lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mo mi boel tao ela deken! Asii deng mia la le daid atuil tene kam, un musti daid banansila el atuil in loka-loka ka, le lii-lau atuil didang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nol asii man le daid tulu kam, un musti tao apa ka banansila el ata ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hii ke! Auk kon ela. Au, Atuling Baktetebes nia, maang le lii-lau atuli lia. Auk maang le atuli li lii-lau Auk lo. Molam Auk maang le bel Auk in nuli ki tetema, halin sui puting atuli li deng oen in kula-sala ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hidi na lam, Yesus nol Un ima-ii las laok napiut. Dedeng oen putis deng kota Yeriko ka, muik atuli hut mamo muid one. ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mo muik atuil tedo at dua daad se lalan suut ta. Nikit oen duas ming noan, in maa laok deng na ka, Yesus atuling Nasaret ta, kon oen duas haman mumuun noan, “Tuang! Daud in hua-koet te! Kaim natang-natang Tuang blaan son! Kasiang kaim buit tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ming oen duas haman ela kon, atuli las kaing noan, “Hoe! Mi duam lobo deken!” Mo oen duas haman mumuun dui pait noan, “Tuang! Daud in hua-koet! Kasiang kaim tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kon Yesus laok napiut lo, mo Un dil le ketan duas noan, “Mi duam kom le Auk tao asa bel mia la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Oen duas siut noan, “Tuang nge! Tulung le halin nam kaim duam haup in neta tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ming oen duas in aa ela ka kon, Yesus dalen nahi nolas. Tiata Un kapas oen duas matan nas, kon nam oen duas ngat net meman. Hidi na kon, oen lakos muid Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hidi nam Yesus nol Un ima-ii las napiut, lakos lius se ingu mes ngala Betfage, ne leten Saitun peke ka. Iung na dadani nol kota Yerusalem son. Ti oen tenes tahang se las. Kon Un tadu Un ima-ii las at dua, le lakos muna. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Un tadu oen duas noan, “Mi duam lakom se iung nua. Eta mi taam lakom se ingu la lam, mi net keledai ina mes nol ana ka butun se na. Mi laok loat oen talin nas, le pel nolas maa bel Au. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mo eta atuli keket mi noan, ‘Tasao le mi pel lai-niin atuli keledai kia?’ Lam mi siut noan, ‘Tuang le pake. Hidi le lam Un tunang pait maa.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Totoang nias musti dadi, muid asa man Ama Lamtua Allah mee-baha la in dul meman son noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Hoe mi atuil Yerusalem me! Ngat laok bus elu le! Ta mi Lahin na maa nuan! Un maa nol in tao dalen deng dadale. Un saek keledai ana le maa.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kon nam ima-ii las duas lakos, le daek muid asa man Yesus in tadu oen le dake ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Oen pel nol keledai ina ka nol ana ka laok bel Yesus. Hidim oen lekat hlimut se dapa, halin Un saek keledai la, le oen taam lakos bus el kota la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Oras oen le taam lakos bus el kota la ka, atuli hut mamo kat oen hlimut tas, nol oen seman hlendang ngas, le lekat laok se lalan na. Muik atuli teng pait lakos dait kai klehen, le hehan laok se lalan na. Nini ela lam, oen tulu bel noan, oen sodo-sium Un banansila el atuil tene ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Muik atuli teng pait lakos muna Yesus se hmunan, nol tenga las pait muid deng klupu. Le oen leo-leo nakaa kleba-kleba noan, “Hosana! Kaim naka-naka Ama Lamtua Allah! Undeng Daud in hua-koet ta maa lius son! Hosana! Kaim naka-naka Ama Lamtua Allah! Undeng Ama Lamtua nutus Atuling ni le maa son. Hosana! Kaim naka-naka Ama Lamtua Allah! Man daad le kil bandu meman son, ne apan man lapa dudui kua!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Dedeng Yesus tama lako kota Yerusalem nol in lupu-nakaa ela la, kota la isin na putis totoang, le keket apa noan, “Inaa! Asii in maa nia le?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Atuil hut mamo kas siut noan, “Un niam, Ama Lamtua Allah mee-baha. Un ngala Yesus, atuil Nasaret deng propinsi Galilea.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kon Yesus nol Un ima-ii las taam lakos napiut se Ama Lamtua Allah Um in Kohe-kanas Tene ka. Se Um in Kohe-kanas sa kintal la, atuli las taon daid maan in sosa-hee son, le hee tiul-tuan. Taom atuli las pake tiul-tuan taung in tunu-dadung le kohe-kanas. Net ela kon, Yesus laok nulut puting one. Un late soleng mija-mija man oen pakes le silin duit tas, nol late bali bangku-bangku man oen pakes le hee tiul-tuan nas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Hidim Un tek atuli las noan, “Ama Lamtua mee-baha la dul son noan, ‘Auk bangun-pii Um nia, le halin totoang atuli li maa kohe-kanas se nia.’ Ama Lamtua in koma ka ela, mo Um ni mi taon daid atuil in nakong ngas maan in nakbua son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesus bii nabael se Ama Lamtua Allah Um in Kohe-kanas sa lam, atuil tedo kas nol atuil hlukut-hkait tas maas se Una. Kon Un tao banan oen totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Se na kon, muik tulu agama Yahudi las tene-tenen nas, nol guru-guru agama las. Nikit oen net Yesus in tao taad herang ela ka kon, oen koon-mali. Dudui pait ta, nikit oen ming tana-anang in se Um in Kohe-kanas sas, nakaa mumuun noan, “Hosana! Kaim naka-naka Ama Lamtua Allah! Undeng laih Daud in hua-koet ta maa son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kon oen tek Yesus noan, “Hoeh! Ku ming tana-anang nas in nakaa ka tam? Na tom lo tetetas!” Mo Yesus siut oen noan, “Hao, Auk ming. Mo tasao ka? Mi les net se Buk Niu ka deng tana-ana ngas in naka Ama Lamtua Allah ka lo bii ke? Ta muik dulan ne na noan, ‘Ama Lamtua Allah tui tana-ana mea, nol tana-ana blutu kas meman son, le oen naka-naka Una.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hidi deng nam, Yesus nol Un ima-ii las putis deng kota na, le lakos ninis se iung Betanias. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ola ka oskaong bii, kon Yesus nol ima-ii las pait le taam lakos kota Yerusalem. Mo se lalan hlala kam, Un lubu. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Un ngat net kai ina mes se lalan suut ta, man taom atuli las kaa un isin na. Tiata Un lako dadani kai ina na, halin tinang nanan le muik isin tam lo ka. Mo Un lako lius se kai ina na lam, Un net isin mes lo kon, undeng kai ina na halas-sam klehen. Kon Un tek kai ina na noan, “Undeng ku puting isin bel Auk lo, tiata ku isin pait lo ka!” Un aa hidi ela kon, kai ina na tuu meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Un ima-ii las net ela kon, oen nahkitu. Oen keket noan, “Tasao le nahkiut tuun nam, kai ina ni tuu meman nia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kon Yesus siut noan, “Hii babanan ne! Eta mi parsai baktetebes se Ama Lamtua, nol dalen hduan bubuit lo kon nam, mi tao nal banansila el Auk in tao son nia. Mi kon tao nal muun dui deng na. Tuladang el: mi bisa tadu leten mes lako se tasi kua, lam taon elola ko Ama Lamtua Allah pekot leten na lako tasi ku meman, sadi mi parsai baktetebes se Una! ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ta totoang asa man mi in nodan se Ama Lamtua Allah ngas, mam mi simus, sadi mi parsai baktetebes se Una.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Hidi na kon, Yesus nol ima-ii las laok napiut. Lius se Yerusalem kon, oen taam lakos pait se Um in Kohe-kanas Tene ka kintal la. Dedeng Yesus tui atuli las deng Ama Lamtua Allah lalan in nuli ka mamasu lam, tulu agama Yahudi las tene-tenen nas, nol blalan-blalan hadat tas maas le keket-ketan nol Yesus noan, “Asii tadu Ku maa tao lobo-lau se ni lahin nia? Asii man bel ku hak ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mo Un taan noan, oen nuting lalan le kiu nahu Una. Tiata Un situs noan, “Auk kon le keket mia. Mi siut Auk muna le, halas-sam Auk siut mia. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Auk le keket elia: mi totoang taan Yuhanis In Sarain Atuli ka, ta lo? Elam, asii man belen hak le sarain atuli lia? Ama Lamtua Allah, tamlom atuli lia?” Kon nam oen nangan lako-pait le huli-bali noan, “Idah! Kit tom hkate son nia mo! Eta kit siut noan, ‘Ama Lamtua Allah man belen hak kam’, Un siut bali kit noan, ‘Eta ela lam, tasao le mi parsai Yuhanis lo kia?’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mo kit kon bisa tek lo noan, ‘Atuli li man belen hak’, ta lo kam atuli las totoang haung keng nol kita. Undeng oen parsai noan, Yuhanis na mo, mee-baah deng Ama Lamtua Allah.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tiata oen siut Yesus noan, “Kaim tanan lo.” Kon Yesus siut balis noan, “Eta ela lam, Auk kon tek mi lo noan asii man bel Auk hak kia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus aa napiut nol tene-tene agama nas noan, “Mi nangan nam elol nol kleta nia la. Blalan biklobeng mes nol un anan biklobe at dua. Un lok ana hmunan na noan, ‘Ana, leol ni ku laok daek se klapa lu le.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mo tana na siut noan, ‘Eh, auk laok lo.’ Mo nesang lo kon un sabail apa ka, tiata un lako. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kon nam blalan biklobeng na tadu ana hmudin na lolen, noan, ‘Ana, leol ni ku laok daek se klapa lu le.’ Kon tana na siut noan, ‘Hao papa. Hidi lem auk lako.’ Molota un laok lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Dehet hidi ela kon, Yesus keket oen noan, “Auk le keket elia: deng tana-anang dua nas, ol man tao muid oen aman na in prenta ka la?” Kon oen siut noan, “Ana hmunan na!” Ta Yesus tekas noan, “Hao. Mo hii babanan, ta Auk in teka ni toma. Mi noken atuil in sium bea ngas nol bihaat hmama kas noan, atuil daat, mo mam oen tamas lakos daid Ama Lamtua Allah atulin muna deng mia. Undeng mi suma hao Ama Lamtua tuun, mo daek muid Un in koma ka lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Hmunan nu, Yuhanis in Sarain Atuli ka tui mi son, noan, taon elol le halin mi haup in nuil lolo ka. Mo mi dai parsai un lo. Molota nikit atuil daat tas ming Yuhanis in teka ka tukun nam, oen nang soleng oen in kula-sala ngas, le daek muid un in tui ka. Mi kon taan nas totoang son. Mo mi dai tenem deng mi in kula-sala ngas, le muid se Ama Lamtua Allah in koma ka lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Hidi nam, Yesus dehet kleta mes pait noan, “Dale lamtua mes lako dait hlean balu, le taung in hai anggor. Hidim un paah pukiun. Nol un daek bak le taung in lee anggor isin na. Un kon koet mana mes lalapa, le taung in doha. Hidi kon un bel atuil didang le seb klaap na, halin nam mam oen bating apa klapa la in hapu ngas. Mo un boka lako nusa likun nuas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Lius oras in nui-noel anggor isin kon, klaap lamtua ka tadu un ima-ii las laok nodan un nena las, se atuil in seb klapa la ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mo oen toe muid ima-ii nas lo. Oen diuk-papas ima-ii tenga las, teng tom in keo tele, nol tenga las pait tom in pasang nini batu. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kon nam klaap lamtua ka lok un ima-ii hut mamo dui pait deng buan hmunan nas. Mo atuil in seb klapa la ngas, diku-puang oen totoang el ima-ii hmunan nas kon. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nesang lo kon, klaap lamtua ka tadu un ana in hua ka esa. Lole un nangan noan, ‘Eta auk tadu auk anang ngi esa kam, taon elola ko oen sium un nol babanan, hidim hii-ming se una.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mo nikit atuil in seb klapa la ngas net tana na laok maa kon, oen tek apa noan, ‘Hoe, mi ngat le! Ta blalan na tadu un ana ka esa maa son nuan. Mam un man haup blalan na pusaka las totoang. Tiata maa le kit keo tele un tia, le halin nam kit man haup klaap nia.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kon oen daek tana na, hidim pel puting lako klapa likun na, le keo tele.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesus nahdeh hidi ela kon, Un keket oen noan, “Auk le keket elia: eta klaap lamtua ka pait tam, un tao elol nol atuil in seb klapa la ngas sa?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kon atuil Yahudi las tene-tenen nas siut noan, “Taon elola ko un keo tele totoang atuil daat nas. Hidim un bel atuil didang le seb klapa la lolen, man mam bating klapa la in hapu ngas tom nol oras sa.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hidim Yesus aa nolas noan, “Bet mi les net asa man dulan son ne Ama Lamtua Allah Buk Niu ka ka lo, man noan, ‘Muik batu mesa, man tukang batu las kat soleng son, mo halas ni baut na daid baut netes, le taung in tian nini uma! Ama Lamtua Allah esa man huil baut na le todo se na. Undeng na le kit ngat net un in leko-banan isi ka!’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Hidim Yesus tupang napiut Un in aa ka noan, “Tiata mi nangan babanan ne. Hmunan nu Ama Lamtua huil kit atuil Yahudi li le daid Un atulin son. Mo undeng mi dai muid Auk lo, tiata mam Ama Lamtua huil atuil didang lolen. Ta atuil man nuil muid Ama Lamtua in koma ngas siis, man tamas nal le daid Un atulin. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Auk tek mi nahlolool tuun. Auk niam, baut netes sa. Atuil man nahi tom baut na ka, mam dudu-dudus. Nol eta baut na nahi tom atuli lam, atuling na kon dudu-dudus.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nikit tulu agama Yahudi las tene-tenen nas, nol atuil Farisi las ming Yesus in dehet ela ka kon, oen tana noan, Un in aa na hai bus one. Oen hnika mes el atuil in seb klapa la ngas, tamlom tukang baut man kat soleng baut netes sa ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tiata oen koon-mali isi. Hidim oen nuting lalan le daek Una. Mo oen siin-tiud nol atuil hut mamo man parsai noan, Yesus nam Ama Lamtua Allah mee-baha ngas. Ta oen tao saa Un lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Hidim Yesus aa nol oen pait nini kleta noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ama Lamtua Allah in kil bandu ka, banansila el lahi mesa, man tao fesat in sapa bel un ana biklobe la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mana hidi fesat ta kon, un tadu un ata kas le laok tek atuil in haup haep pas noan, ‘Maa tia, ta fesat tu mulai son.’ Mo atuil nas dai laok muid fesat ta lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kon nam, ata kas pait le laok tek lahing nga. Ming ela kon lahing nga tadu un ata tenga las noan, ‘Mi laok tek atuil nas le maa tia, ta mana hidi fesat ti son. Auk keo aus-sapi, nol hosa-nakin hidi in kaa faal banan sii son. Ta tadus maa le kaa se fesat tia, ta totoang mana hidis son.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ata kas laok tek atuli las ela. Mo atuil in haup haep pas tao hii lo. Tenga las lakos klapas, tenga las pait lakos oen maan in dake ngas, ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","mo tenga las daek lahing nga ata kas, le diku-puang didiin mates. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ming ela kon, lahing nga koon-mali isi. Tiata un lok un tentara las, le laok keo tele atuil man in keo un ata kas son nas. Hidim tentara las loe nuli kota na, didiin tatai nol dale ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hidi kon lahing nga haman un ata tenga las le tekas noan, ‘Fesat in sapa ni mana hidi son, mo atuil man auk in haep son nas, tatai nol in maa muid fesat nia lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tiata nol nia, mi puit lakom se lala-lalan nas, le haep asii tuun man mi tutnalan.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kon ata kas lakos se lala-lalan man in muik atuli hut mamo kas. Oen net atuli mamo se lalan na, ta oen kil nolas laok muid fesat in sapa ka. Muik atuil banan nol atuil daat kon, man maas le tao inu maan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Hidi na kon lahing nga taam lako se fesat ta dalen, le ngat pukiu un atulin in haep pas. Kon un ngat net atuil in haep mes pake kai-baut fesat lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ta lahing nga ketan noan, ‘Hoe kaak-pali! Tasao le ku taam maa se nia, mo pake kai-baut fesat lo kia?’ Mo atuling na langan tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kon nam lahing nga prenta un ima-ii las noan, ‘But atuling ni iin nas nol iman nas, le nikit soleng lako likun nua. Nang le un lilu nol susa-daat se maan mitang ngua.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ela kon, Ama Lamtua Allah haman atuli hut mamo, molam Un suma huil nal atuli bubuit sii, le daid Un atulin.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ming Yesus aa hidi ela kon, atuil Farisi las koo mes le kiu nahu Yesus, hidim klaa nol Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tiata oen tadu oen ima-ii las, leo-leo nol atuil deng Herodes partei la, le laok keket-ketan nol Yesus. Kon atuil nas naka-naka Un noan, “Paap Guru! Kaim tana noan Paap dalen na lolo. Paap nole-lilung taan lo, nol huil sila lo. Paap tui Ama Lamtua Allah in Teka-teka ngas nol in toma. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tiata kaim le keket dasi mesa. Muid kit atuil Yahudi li atorang agama la lam, kit musti baen bea bel pamarenta Roma la laih tuan na, tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mo Yesus tanas son noan oen kiu Una, le halin Un aa labang pamarenta Roma la. Kon Un siut noan, “Meman mi niam atuil in sila-klup tuun! Tasao le mi kiu nahu Auk nini dais na lia? ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Olan balang bel Auk duit lil-muti mesa, man taom atuli las pake taung in baen bea!” Kon oen tulu belen duit lil-muti mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ta Un keket oen noan, “Hdulat ni asii la? Nol asii ngala nia la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Oen siut noan, “Na Kaiser, pamarenta Roma la laih tuan na.” Kon Yesus tekas noan, “Eta ela lam, mi laok bel pamarenta la, asa man daid pamarenta nena. Nol bel Ama Lamtua Allah, asa man daid Ama Lamtua Allah nena.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ming Un siut ela kon, oen herang-herang, lole Un in teka na tom isi. Tiata oen haung lakos deng maan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Se na kon, muik atuli at ila lo deng partei Saduki. Atuil deng partei Saduki las tui noan, atuli li mate kam, nuli pait lo. Leol neot na, oen kon nuting lalan le kiu nahu Yesus. Undeng na le, oen maas keket-ketan nol Yesus noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Paap Guru! Upung Musa dul pesang bel kit hadat ni son, noan: eta biklobe mes mate nang soleng un sapa ka, mo muik aan lo kam, biklobeng na palin na musti saap nol bebalung na, le halin nam hua-koet bel un kaka in maet son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Meman hmunan nu upung Musa tui ela. Mo kaim le keket elia: muik biklobe at iut pali-kaka. Aan hmunan na sapa, hidi kon mate, mo muik ana lo. Kon un palin in muid una ka, saap seda bebalung na lolen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nal nesang lom, un kon mate mo muik aan lo. Ela kon palin nomer tilu la. Un kon saap bebalu na, mo un mate nol hua pesang aan lo. Ela tutungus lako lius palin hmudin na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Un mate nol bebalung na kon mate, mo hua aan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Lam kaim le ketan elia: bihatang na saap nol bikloeb at iut nas son. Ta eta apan-kloma ki kiamat, le Ama Lamtua tao atuil in mate ngas nulis pait tam, bihatang na daid asii sapa ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kon Yesus siut noan, “Eta mi ketan ela lam, mi kula bosor son! Undeng mi taan Ama Lamtua Allah in Dula ka isin na lo. Nol mi kon taan Un in kuasa man muun isi ka lo! ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","In toma ka elia! Mam eta Ama Lamtua Allah tao atuil in mate ngas nulis pait tam, oen saap apa pait lo ka, banansila el Un ima-ii in ne sorga nguas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Auk kon le aa deng atuil in mate ngas haup in nuli pait, tam lo ka. Se upung Musa in dula ka, muik dehet deng kai ana mes ai kaan, mo hnining lo. Deng dehet na lam, kit taan haup noan, atuil in mateng ngas bisa haup in nuli pait. Ta se in dula na, Ama Lamtua Allah tek upung Musa noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Auk niam, Lamtua Allah deng ku upum Abraham, Isak, nol Yakob. Oen todan-lahing Auk napiut, maa lius hahalas nia.’ Lam kit tana noan dedeng Ama Lamtua in aa ela ka, blalan nas mates blaan tene son. Mo Ama Lamtua Allah tek noan, Un daid oen Lamtuan maa lius halas ni nabale. Undeng na le kit tana noan, oen mates blaan son kon no, oen hmangin nas nulis nabale. Tiata atuli li mate kon no, mam un nuli pait. Ta suma atuil in nuli sii man todan-lahing Ama Lamtua Allah, mo atuil in mate lo, ta lo?!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ming Yesus tui ela kon, atuil Saduki las siut nal saa pait lo. Mo atuil hut mamo kas herang-herang, hidim oen tek apa noan, “Wuih, Atuling ni in tui ki muun isi!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nikit atuil Farisi las ming noan, Yesus nal atuil Saduki las son kon, oen leo-leo nakbua le laok keket-ketan nol Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Oen atulin in taan agama isi mes soba-naan le kiu nahu Yesus. Un tek noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Paap Guru! Auk le ketan elia: kit hadat ti atorang ngas, nol agama la in prenta ngas mamon ana lo. Deng totoang prenta man upung Musa in bele ngas, ol man muun dudui la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kon Yesus siut noan, “Prenta man muun dudui ne Ama Lamtua Allah in Dula Niu ka ka, elia: ‘Ama Lamtua Allah na mo, mi Lamtuan. Tiata mi musti neka-namnau Una, dui deng totoang. Undeng na, mi musti nangan net Un tutungus, nangan taan Una, nol daek mumuun le muid Un in koma ka.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Prenta na, man muun dudui nol uhu dui! ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nol muik prenta nomer dua, man tek noan: ‘Ku musti namnau atuil didang, banansila el ku in neka-namnau ku apam ma esa ka.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Peke deng totoang upung Musa atorang ngas, nol Ama Lamtua Allah mee-baha las in tui ngas, mo prenta dua nias. Etan atuli li muid nal prenta tene dua nias muna lo kam, oen muid nal prenta didang ngas lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Oras na atuil Farisi las nakbua nabael se na, kon Yesus keket bali oen noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Deng lolo hmunan nu Ama Lamtua Allah hid son le tunang Kristus maa, halin bel boa-blingin Un atulin nas. Lam muid mi in nangan nam, Kristus na mo, asii in hua-koet ta?” Kon oen siut noan, “Un na mo, laih Daud in hua-koet.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus keket tapnaeng pait noan, “Eta ela lam, tasao le Ama Lamtua Allah Koo Niu ka, tek laih Daud halin haman Kristus sam, ‘Tuang’ ngia? Ta laih Daud dul son elia, ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ama Lamtua Allah tek auk Tuang nga noan, “Maa, le daad se maan in todan-lahing dui kia, se Auk halin kanan nia. Ta mam Auk tao ku musu las, didiin oen suda le todan se Ku sii.” ’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Deng in dula na lam kit tana noan, laih Daud esa man haman Kristus noan, ‘Tuang’. Tiata eta atuli li tek noan, Kristus nam suma laih Daud in hua-koet tuun nam, nol lo bii! Undeng Un kon nam laih Daud Tuang!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ming Yesus in aa ela ka kon, atuil Farisi las langan tuun, muik tahan atuli mes lo kon, man siut nal Yesus. Tiata kilan deng leol neot na kon, oen lii in keket-ketan Una, nol brain le kiu nahu soba-naan Un pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hidi kon Yesus tui Un ima-ii las, leo-leo nol atuil hut mamo man in muid one ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Un tekas noan, “Guru agama las nol atuil Farisi las kil hak le tui upung Musa atorang ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Undeng na, mi musti hii se one, nol muid oen in tui ngas. Mo muid oen in dake ngas deken, undeng oen daek muid asa man oen in tui esan son nas lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nol oen kon tulung atuli li le tao muid atorang nas lo, molam oen dising atuli li le daek muid oen atorang agama ngele kas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Totoang man oen in dake ngas, oen daek le halin nam atuli li naka-naka one. Tuladang el: taom oen but buk ana mes man dul Ama Lamtua Allah in Teka-teka dehe, se oen bon nas, nol iman nas. Mo oen tao oen nena las tene dui pait, le halin atuli las naka-naka oen noan, ‘Wui, oen nam atuil niu koo!’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Eta oen taam lakos um in kohe-kanas sa, tamlom laok muid fesat tam, oen nuting maan in dada, man banan dui ngas, le halin atuli hut mamo ngat net one. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Eta oen laok pasar ram, oen kon kom in nuting le atuli todan one. Oen nuting le halin atuli aa nol oen noan, ‘Boa-blingin, ama guru.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mo mi tao muid oen in dake na deken! Atuli boel haman mi noan, ‘ama guru’ deken, undeng mi Gurun na suma mes sii. Nol mi totoang niam kaka-pali. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nikit-nikit atuil se apan-kloma ki deken noan, ‘ama’, undeng mi Aman na suma mes sii ne sorga. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Atuli li kon boel haman mi noan, ‘tuang’ deken, undeng mi Tuang nga suma mes sii, na Auk niang, man Ama Lamtua Allah hid son lolo hmunan nu le tunang maa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Undeng na le Auk tek mi noan, boel nikit-nikit apan banansila el atuil man nuting in todan nas deken. Asii deng mia la kom le daid atuil tene kam, un musti daid banansila el ata ka, le halin lii-lau atuil didang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ta atuil in nikit-nikit apa ka, mam Ama Lamtua tao nahu una. Mo atuil in tao apa ka deng dadale ka, mam Ama Lamtua nikit sakeng.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Hidi na kon, Yesus aa napiut noan, “Hoe, guru-guru agama nol atuil Farisi me! Meman mi niam atuil in hlak daat! Mam mi haup in susa-daat, undeng mi dai parsai Au, Atuling man Ama Lamtua Allah hid son le tunang maa ka lo. In daat dudui pait ta, mi palan kele atuil in le maa parsai se Au ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Hoe, guru-guru agama nol atuil Farisi me! Meman mi niam atuil in sila-klup tuun! Mam mi haup in susa-daat, undeng mi taan in nole-lilung bebalu kas si-sii, hidim nuhu-dau oen uma las. Mo se atuil hut mamo silan nam, mi buba kele mi in daat tas, nol dil kohe-kanas nesang-nesang, le halin atuli tek noan mi dalen nas niu. Mo mam Ama Lamtua Allah in hukung mia ka ngele dui. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Hoe, guru-guru agama nol atuil Farisi me! Meman mi niam atuil in sila-klup tuun! Mam mi haup in susa-daat, undeng mi luan laa lakom se ola-ola, nol niu saek leten, le suma nuting atuli mesa, halin tama muid mi partei agama la. Mo eta un tama son nam, mi tao un in nuli ka daat dui pait, didiin un in haup hukung se naraka lua ka, ngele dui mi oe dua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Hoeh! Mi nam tedom, mo tasao le mi tulu lalan bel atuil didang ngas nabale lia? Mam mi haup in susa-daat, undeng mi tui dadahut noan, ‘Eta atuli nikit in hida, le sumpa nini Um in Kohe-kanas Tene ka lam, atuling na butu-kil nol un in hida na lo. Mo eta un nikit in hida, le sumpa nini lil-mea man in ne Um in Kohe-kanas Tene ka lam, un butu-kil nol un in hida na.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mi niam atuil ngengo, man taan saa lo! Mi bali noan, Ama Lamtua nangan lil-mea kas muun dui deng, Un Um in Kohe-kanas Tene ka le? Loo! Ta Um na, man tao lil-mea nas le daid niu! ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mi kon tui dadahut noan, ‘Eta atuli nikit in hida, le sumpa nini mija in tunu-dadung man ne Um in Kohe-kanas Tene ka ka lam, atuling na butu-kil nol un in hida na lo. Mo eta un nikit in hida le sumpa nini hmukit in tunu-dadung, man in ne mija la dapa ka, halas-sam un butu-kil nol in hida na.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mi kutan nas tema baktetebes. Taon elola ko mija in tunu-dadung nga, muun dui deng, hmukit in tunu-dadung nga. Ta undeng mija na, le atuli li haup in tunu-dadung bel Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tiata eta atuli li sumpa le aa mija la ngala ka lam, banan dui ka, aa mija la leo-leo nol totoang sa-saa in ne mija la dapa ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nol eta atuli sumpa le aa Um in Kohe-kanas Tene ka ngala ka lam, banan dui ka, aa Um in Kohe-kanas Tene ka, leo-leo nol Ama Lamtua Allah ngala ka, ta Un man daad ne a. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nol eta atuli sumpa le aa sorga ngala ka lam, na banansila el un aa Ama Lamtua Allah del in prenta ka, leo-leo nol Un ngala ka, undeng Un man daad ne del na dapa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Hoe, guru-guru agama nol atuil Farisi me! Mi niam meman atuil in sila-klup tuun! Mam mi haup in susa-daat, undeng mi taan isi in kaih le bel Ama Lamtua op mes deng op hngulu. Mi kaih papmes sa-saa las, didiin mi bumbu-bumbu in ne klapa lua ngas kon, mi kaih teles. Tuladang el mi in kaih hkulu, adas kumis, nol jintan nas babanan na. Molota mi nadidingun soleng Ama Lamtua Allah atorang man in muun dui ngas son! Undeng mi in nuli ka lolo lo. Mi namnau atuil kasiang ngas lo. Nol mi kon nuil muid Ama Lamtua Allah in koma ka tutungus lo. Banan dui ka, mi tao muid nas totoang muna, hidi halas-sam mi laok kaih bumbu in le bel Ama Lamtua ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mi taan dadale lo, mo tasao le mi tulu lalan bel atuil didang nabale lia? Mi daek muid atorang man in muun lo ngas, mo Ama Lamtua atorang man in muun dui ngas sam, mi daek mudis lo. Banansila el mi nahis soleng hlales ana blutu mes deng mi ui in ninu ka. Molota, hmukit tene mes el aus-tutu ka, mo mi holon tetema! ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Hoe, guru-guru agama nol atuil Farisi me! Mi niam meman atuil in sila-klup tuun! Mam mi haup in susa-daat, undeng mi baes mi ping-mako kas didiin kaloe, mo na suma deng likun tuun. Molota un dalen na hmomos isi, banansila el mi in kom naseke le nuhu-dau atuil didang sa-saa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hoeh! Atuil Farisi tedo me! Baes mi ping-mako kas dalen nas muna le! Nini ela lam, un likun na kon daid niu! ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Hoe, guru-guru agama nol atuil Farisi me! Mi niam meman atuil in sila-klup tuun! Mam mi haup in susa-daat, undeng mi tuladang el niut utu in cet muti ka. Atuli ngat deng likun na lam, leok isi. Mo un dalen na inu nol atuil hmate seen, nol bui hoso. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mi kon hnika mesa! Mi tao apan nas banansila el atuil niu ka. Deng likun nam, atuli ngat mia lam, el atuil man dalen lolo ka. Molota mi dalen nas inu nol dasi-dais daat sii. Ta mi aa kam kisa, mo dake lam kisa, nol nadidingun soleng Ama Lamtua Allah in prenta ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Hoe, guru-guru agama nol atuil Farisi me! Mi niam meman atuil in sila-klup tuun! Mam mi haup in susa-daat! Mi daek bel Ama Lamtua Allah mee-baha las utu nas tene-tene, nol lohas atuil banan nas utu ngas leko-leko. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mo mi tek noan, ‘Eta oras na kaim nuling leo-leo nol kaim upu kia-kaon nas sam, taon elola ko kaim keo baab Ama Lamtua Allah mee-baha las lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nini ela lam, mi esan tek puting mi dais in buni ngas noan, mi niam atuil daat, banansila el mi upu kia-kaon nas kon. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tiata mi daek dadaat napiut lako, le tao inu mi upu kia-kaon nas in daek kula-sala ngas! ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mi niam daat baktetebes tuladang el ul in muik lasong nga. Mi bali noan mam Ama Lamtua Allah hukung mi lo ke? Nangan ela deken! Ta mam Un pasang tamang mi lakom ai naraka lu dalem! ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Hii ke! Mam Auk tunang bel mi Auk atulin in nutus sas, le oen tui mia, nol tulu bel mi Ama Lamtua lalan in nuil toma ka. Mo mam mi keo tenga, nol pauk tele teng se kai faang-kalen dapas. Tenga las mi diku-puang se uma-um in kohe-kanas sas dalen. Nol teng pait mi nulut soleng, didiin oen lalis deng kota mesa, lakos kota didang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hmunan hesa ku mi upu kia-kaon na keo Habel. Molota, un nam atuil in dalen lolo. Mi upu kia-kaon nas taan in keo tele atuil in nuil lolo ngas tutungus, kilan deng Habel lako pes Sakarias, Barakia ana ka. Oen keo un se Um in Kohe-kanas Tene ka kintal la, dadani nol mija in tunu-dadung nga. Undeng mi tao muid mi upu kia-kaon nas in daat ela ka, tiata mi musti lepa-haal atuil man dalen in lolong nas, dalan nas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Meman baktebes! Mam mi atuil udin nias tom in hukung, undeng dasi-dais daat, man mi upu kia-kaon nas in daek son se hmunan nua ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Hoe, atuil Yerusalem me! Mi keo tele Ama Lamtua Allah mee-baha las tutungus, nol pasang tele atuil in nutus, man noan, maa le tulung mia ngas. Auk hanet mi oe-oe son le maa bus Au, banansila el manu ina man le kabut un anan nas se un dila ka dalen na. Mo mi dai tao lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Undeng na, tiata Ama Lamtua tiu-hii mi uma la pait lo son. Ola bingin dua kam, um na dadi blo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Hii babanan ne! Ta mam mi net Auk pait lo kang, didiin lius oras mi in hao noan, ‘Kit nodan le halin Ama Lamtua Allah bel Atuling ni hangun, undeng Ama Lamtua man nutus Un son.’ Mi hao ela, halas-sam mi ngat net Auk pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Hidi nam, Yesus lako nang soleng Um in Kohe-kanas Tene ka. Dedeng Un in puit lako ka, Un ima-ii las maas le tulu Um in Kohe-kanas sa in leko ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mo Un tekas noan, “Um ni meman leko! Mo mi hii ke! Ta nesang lo kam, oen tao lean batu-baut nias totoang.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hidim Yesus lako daad se leten Saitun nua. Kon Un ima-ii las siis lakos le aa nolan noan, “Papa! Olan tek ulang apin Paap in aa deng, Um in Kohe-kanas sa in lea ka le. Nataka le Paap in pait maa ki blinga la? Nol un tada-tada las elola la? Hidim elol kon nol leol kiamat tia la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kon Yesus siut noan, “Mi musti doha-doha! Le halin mi tom in nole-lilung deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ta mam muik atuli mamo-mamo, maa teh kalas le tek noan, ‘Auk niam Kristus, Atuling man Ama Lamtua Allah hidan meman son, lolo hmunan nua ka.’ Oen tao ela, didiin oen nole nal atuli hut mamo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Eta mi net atuli hote-dait apa, tamlom mi ming dehet noan, muik in hote-dait apa ne ola-ola lam, lii deken. Ta dais tuladang ela ngas, musti dadis. Mo leol kiamat ta maa lius lo bii. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mam ngala mes hote-dait nol ngaal didang. Negara mes hote-dait nol negara didang. Muik lul-beko se ola-ola. Nol oras lubu kon muun isi! ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mo totoang nas, halas-sam tada-taad hmunan, man tulu bel noan, leol kiamat ta maa dadani son. Na banansila el bihaat man halas-sam tain ili, undeng un oras in hua ka maa dadani son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tiata mi musti doh babanan! Ta mam oen diku-puang mia, nol keo tele mia. Hidim atuil deng bangsa-bangsa lias totoang kom mi lo isi, undeng mi in muid Au ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lius oras na lam, atuli hut mamo bali kudi le dai parsai se Auk pait lo. Oen kom apa lo, nol hee bali apa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mam atuil in nole-lilung daat tas tek noan, oen nam Ama Lamtua mee-baha. Nol muik atuli mamo parsai one. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mam atuli li in daat ta, nesang le lako lam mamo keko lako, didiin atuli li namnau apa pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mo atuil man in tahang napiut didiin mate ka, taon elola ko Ama Lamtua Allah bel boa-blingin una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ta atuli li musti bani-bating Ama Lamtua Allah Dehet Dasin Banan na, lako papmes apan-kloma ki suut-suut tas, le halin totoang atuli li taan haup Ama Lamtua lalan in nuli banan na muna le. Halas-sam leol kiamat ta maa.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesus aa napiut noan, “Ama Lamtua Allah mee-baah Danial dul deng atuli mes daat isi. Mam Un maa tama lako dil se maan in luli, deng Ama Lamtua Allah Um in Kohe-kanas Tene ka. Nini ela lam, un tao hmomos maan na le atuli nikis. Tiata Ama Lamtua Allah bali kudi le nang soleng maan na. Eta mi net ela son nam, doha-doha lo! (Asii man les in dula nia lam, un musti nangan tanan babanan). ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ta na daid tada noan, lelo-leol in susa ngas muik ne sila-mata lu son. Eta net ela son nam, atuil in ne propinsi Yudea ngas lalim lakom leten nuas tia. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Eta asii man puti deng uma la son nam, pait laok kat kai-baut bakun tia. Molam lail mumuun le halin nam tom in daat ta deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Atuil in se klapa ngas, pait laok kat seman otot bakun tia. Lail napiut tuun! ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","In bosor dui ka, bihaat in behe ngas, nol ina-in man nusu tana-ana blutu mea mamasu ngas. Undeng oen lail nal hlapat lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tiata, banan dui ka mi kohe-kanas le nodan, halin in daat na nahi tom se oras ulan, tamlom nahi tom se leol teen in dake deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ta leol na sus isi! Kilan deng Ama Lamtua Allah in koet apan-kloma kia ka, maa lius halas nia, atuli li net in susa-daat tuladang ela lo bii. Nol mam atuli kon net in susa-daat tuladang ela pait lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mo mi ulat baktetebes, lole Ama Lamtua Allah tao dadaen leol nas. Eta lo kam, muik tahan atuli mes lo kon man nuli. Molam undeng Ama Lamtua Allah namnau atuil man Un in huil nal son nas, tiata Un tao lelo-leol in susa ngas dadaen tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mam lius oras na lam, mi ming atuli tek noan, ‘Ngat le! Kristus muik mo nia!’ Nol tenga las pait tek noan, ‘Kristus ne nua!’ Mo mi parsai deken ne! ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta mam muik atuli puit le teh kalas noan, ‘Auk niam Kristus!’ Nol tenga las pait tek noan, ‘Auk niam Ama Lamtua Allah mee-baha.’ Mam oen tao taad herang bili-ngala pake uikjale kas in kuasa, le nole-lilung atuli. Oen soba-naan le halin Ama Lamtua atulin nas kon tom in nole-lilung! ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tiata mi musti doha-tiud apan babanan ne! Ta lelo-leol in susa ngas maas lius bii, mo Auk tek nuting mi meman son! ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Eta atuli tek mi noan, ‘Kristus muik ne epe nua!’ Lam mi laok se nu deken. Nol eta muik in tek noan, ‘Kristus mo um ni dale nian!’ Lam mi parsai nol oen in nole-lilung na deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ta Auk niam, Atuling Baktetebes sa. Eta mam Auk pait maang se apan-kloma kia lam, atuli li totoang net Au, banansila el atuli net bisain in kaloe, deng halin leol-saken lako pes leol-denen na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Eta Auk pait maang ngam, mi taan noan Auk in ne olang. Banansila el atuli tana noan, eta kee in kaa sa-saa hmate ngas nakbua se ola lam, taon elola ko muik sa-saa hmate ne na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Hidim Yesus tupang pait, le tek Un ima-ii las noan, “Eta lelo-leol in susa ngas hidis son nam, ‘Mam lelo la daid mitang, bulan na kon langa pait lo. Duun-duun nas nahis deng apan nua, nol oen in muun-tes sa ilang le nahis dadahut deng mana ngas.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Hidi nam atuli li totoang ngat net taad se apan nu noan, Atuling Baktetebes sa le pait maa. Net ela kon, totoang bangsa in ne apan-kloma ki ngias lii isi didiin oen lilu. Ta eta Auk niu maang nol nopen, halas-sam oen net Auk in kuasa ka, nol Auk in loe-liliman na totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hidim Auk pake kliung in lin tene, le prenta Ama Lamtua Allah ima-ii in ne sorga nguas, halin laok tao nakbuan totoang atuil man Auk in huil nal son nas, deng apan-kloma ki suut-suut tas, deng leol-saken lako pes leol-denen; deng blai-ahen lako pes loet-ahen.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Auk kat kleta el kai ina mesa. Eta un klehen na kunis son nam, na daid tada noan, oras ehe ka maa dadani son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ela kon, eta mi net lelo-leol in susa ngas maas son, banansila el Auk in teka apin na lam, nas daid tada noan, Auk in maa ka dadani isi son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tiata hii babanan ne! Deng totoang atuil in nuil hahalas nia ngas, mam muik deeh mates lo bii, mo lelo-leol susa las maas lius son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Apan-dapa ku nol apan-kloma ki ilang kon no, Auk in teka-teka nias tahang napiut didiin son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Auk in pait maa kia, muik atuli in tana lo. Ama Lamtua Allah ima-ii in ne sorga nguas kon, tanan lo. Auk esang kon, tanan lo. Suma Auk Amang ngu sii man tanan. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ta Auk niam, Atuling Baktetebes sa. Mam eta Auk pait maang ngam, oras na banansila el hmunan nu Noh in nuli nabale ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ui tene in baa ka maa biim, atuli las kaa-niun babanan, nol saap apa banansila el in biasa ka. Oen tao ela napiut didiin, Noh taam lako kapal tene ka dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mo nikit ui la baa maa le kokon lail-niin one, halas-sam oen matan nas holsai, le taan asa man in daid son na. Ela kon nol Auk in maa kia. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dedeng na, eta atuli at dua daek mamaus se klapa mesa, suknahkitu lam, Ama Lamtua Allah nikit lail-niin at mesa na, mo nang mesa na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nol eta bihata at dua hai ael mamasu lam, Ama Lamtua Allah nikit lail-niin at mesa na, mo nang mesa na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Undeng na, tiata mi musti doh duman-lelo, ta mi taan lo noan blinga lam mi Tuang nga pait maa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nangan babanan ne! Eta um lamtua ka taan noan, duman ni atuil in nako ngas le maas sam, taon elola kon, un doh tutungus le halin atuil in nako ngas taam nal se un uma la lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Undeng na, mi musti doha-doha. Ta Auk in pait maa ki nahkekekan tukun!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Hidim Yesus aa tapnaeng noan, “Mi musti daid banansila el atuil in loka-loka, man muid napiut un tuang nga in koma ka. Ta eta un tuang nga le lako maan katang ngam, un nikit atuil in loka-loka tuladang ela, le mana-koet uma isin nas in kaa-ninu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Eta tuang nga pait, le net un atulin in loka-loka ka daek babanan nam, un dalen kolo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nol taon elola ko, mam tuang na bel un atulin in loka-loka na kuasa, le mana-koet tuang nga hmuki-nalan nas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mo etan atuling in loka-loka na hadat lo kam, taon elol kon un nangan se un dalen na noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Banan son! Tuang lako son nia ta, asii taan le bling un pait maa ka!’ Nangan ela kon, un diku-puang ata tenga las. Hidim daad le kaa-niun babanan tuun, leo-leo nol un tapan in mauh daat tas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Taan dadale lo, mo nahkitu lam un tuang nga pait maa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kon un tuang nga diku-puang un muun isi, hidim pasang soleng un lako likun nua, le halin un leo-leo nol atuil in sila-klup tuun nas. Se maan na lam, oen totoang lilu mumuun, undeng oen haup susa-daat isi.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Hidi kon, Yesus tupang Un dehet ta pait noan, “Mi musti mana-mana le sodo-sium Auk in pait maa kia, banansila el kleta nia: Duman mesan na, haat-ana at hngulu, putis kil oen hadut tas, le laok sodo-sium biklobeng in sapa ka se oen tapan nas mes uma. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mo deng at hngul nas, at lima las ngengon, mo at lima las tana. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Lim in ngengo ngas nadidingun in kil tapnaeng min dale. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mo lim in tana ngas kil meman son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Lius se oen tapan na uma lam, biklobeng in sapa ka maa lo bii nababael tuun. Nesang-nesang kon, tana-bihaat nas matan tede, ta oen niin nalas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mo bingin-tai kon, oen ming atuli haman tek noan, ‘Hoe! Biklobeng in sapa ka maa son nuan! Maa le kit laok sodo-sium un tia!’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ming ela kon, tana-bihaat nas hangus leo-leo. Hidim oen lakos mana oen hadut tas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mo tana-bihaat ngengo kas, aa nol oen tapan nas noan, ‘Tulung bating bel kaim mina buit le, ta kaim hadut tias le mates son nian.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mo tana-bihaat in tana ngas siut noan, ‘Idaah! Komali deken, ta bisa lo. Kaim mina kias nol taung in bating kit totoang lo! Banan dui ka, mi laok sos mina esan se kius suas tuun.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kon oen lakos sos mina, mo oras oen puit lakos sa, biklobeng in sapa ka maa lisu. Ta tana-bihaat in tana ngas, taam lakos fesat ta dalen, leo-leo nol biklobeng in sapa ka nol haep pas totoang. Nikit oen tamas totoang son kon, atuli hkaen tele hnita ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tana-bihaat ngengo kas pait maas lius kon, oen haman deng likun na, le nodan noan, ‘Tuang! Tulung sai bel kaim hnita ki le!’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mo um lamtua ka siut noan, ‘Eeh, auk tao lo. Ta auk taan mi lo kam!’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tiata mi kon musti mana-mana, le doha-doh tutungus, ta mi tanan lo noan, Auk pait maang tom nol leol ila, tamlom diuk ila ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Hidi kon, Yesus nahdeh kleta mes pait noan, “Eta Auk lakong nang mi son nam, mi musti daek babanan taung Au, banansila el kleta nia. Tuang mes le lako maan katang. Nikit un mana hidi le noan lako kon, un haman un atulin in loka-loka ngas le prentas noan, ‘Mi pake duit nias le daid peke. Eta auk pait maa ngam, mi musti maa tek au, le mi haup pait bunga bakun son na.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kon un bel atuil in dake hmunan na, duit kadung lima, halin nam un sepo-dakang le haup bunga. Ela kon un bel atuil in dake nomer dua nga, duit kadung dua, nol atuil in dake nomer tilung nga, duit kadung mesa, muding mesa-mesam in bole. Hidi nam, un boka lako maan katang. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sium hidi duit nas kon, atuling in dake hmunan na puti lako le sepo-dakang. Nesang lo kon, un haup pait bunga kadung lima. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ela kon nol atuling in dake nomer dua la. Un haup pait bunga kadung dua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mo atuling in dake nomer tilung man sium duit kadung mesa ka, lako kali bolo se dale ka, le buni un tuang nga duit tas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nesang ana lo, halas-sam oen tuang nga pait maa. Kon un haman nakbua oen tilus, le keket duit man un in bel oen son, le taung in sepo-dakang ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Atuling in loka-loka hmunan na tama, hidim un bel duit kadung hngulu. Un tek noan, ‘Tuang! Tuang duit tas nian. Lelon na tuang bel auk duit kadung lima. Mo auk haup tapnaeng bunga kadung lim pait.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ming ela kon, tuang nga dalen kolo. Un tekan noan, ‘Banan! Ku niam atuil in loka-loka man in banan. Ta auk se iang lo kon no, ku daek nol in makoe son, hidim muid napiut auk in prenta ngas. Undeng ku daek nal os ana nia, ta mam auk nikit ku le kil os man in tene dui pait tas. Mam auk tao fesat, le kit kaa leo-leo nol dael kolo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Hidi kon, atuling in loka-loka nomer dua la tama lolen, un bel tuang nga duit kadung aat. Un tek noan, ‘Tuang! Hmunan nu tuang bel auk duit kadung dua. Mo auk haup tapnaeng bunga kadung dua pait son.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kon nam, tuang nga dalen kolo. Un tekan noan, ‘Banan! Ku niam kon atuil in loka-loka man in banan. Ta auk se iang lo kon no, ku daek nol in makoe son, hidim ku daek muid auk in prenta ngas tutungus. Undeng ku daek nal dais ana ni son, tiata mam auk nikit ku le kil dais man in tene dui pait tas. Mam auk tao fesat, le kit totoang kaa leo-leo nol dael kolo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Hidi nam, atuling in loka-loka nomer tilu la maa lolen. Kon un tek noan, ‘Tuang! Auk tana le tuang niam atuil in dalen didi. Ta tuang kat asa man atuil didang in dake, nol nui-noel asa man atuil didang in mula-hai. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Undeng na le, auk lii, tamlom duit nias ilang le tuang hukung au la. Tiata auk laok buni duit nias babanan. Nian tuang! Kat pait tia, ta duit kadung mes man tuang in bel auk son na, tetema nabale!’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ming ela kon, tuang nga baet un noan, ‘Ku niam atuil loka-loka man daat, nol ku osam daat isi! Eta ku taan son noan, auk kat asa man atuil didang in dake, nol nui-noel asa man atuil didang in mula-hai kam, ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","tasao le ku laok pesang auk duit tas se bang tuun lo kia? Le halin eta auk pait maa ngam, auk haup un bunga ka, bubuit tuun kon banan!’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Hidi na kon, tuang nga tadu un atulin in loka-loka tenga las noan, ‘Kat duit tas deng una, le beles laok se atuling in haup tapnaeng bunga kadung lima ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ta atuil man mana-koet babanan asa man un in kil son nas, mam un haup taplaeng mamo dui pait. Mo atuil in dai mana-koet asa man un in kil son nas lo ka, mam oen kat lai-niin totoang nas deng una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Daek atuling in loka-loka man muik ambak lo nia. Pela-lakang le nikit soleng lako likun nua. Nang le un lilu-ahan nol susa-daat se maan mitang ngua!’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Hidi kon Yesus dehet napiut noan, “Au, Atuling Baktetebes nia, mam niu maang pait, nini Auk Amang ngu in kuasa man loe-liliman na, leo-leo nol Un ima-ii las deng sorga. Hidim Auk daad se Auk del in prenta man muun dudui ka, le pres totoang atuli li dasi las, muding asa man oen in lako-daek son nas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mam totoang atuil in nuil net se apan-kloma ki ngias, maa situ-taal se Au. Hidim Auk soel bakisan one, banansila el atuil in lolo-poa soel bakisan lae-blai las deng lae-tutu las, le dadi bua dua ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Atuli-atuil man lako-daek muid Ama Lamtua Allah in koma ngas, Auk taos se Auk halin kanan na. Mo atuil in lako-daek muid Ama Lamtua Allah in koma ka lo ngas, Auk taos se Auk halin kliu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Oras na lam, Auk kil prenta son banansila el Lahi ka. Mam Auk tek atuli-atuil in se Auk halin kanan na ngas noan, ‘Mi man sium hangun deng Auk Amang ngu son nas, maa, le tamam se Un uma lia, se maan Un in mana taung mi son lolo hmunan nua ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Auk tek mi ela, undeng hmunan nu, eta Auk lubung ngam, mi man bel Auk in kaa. Auk meeng tuu kam, mi bel Auk in ninu. Auk maang tuladang el atuil balu ka lam, mi man sium Auk le daad tahang se mi uma. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Auk muik kai-baut lo kam, mi man bel Auk kai-baut le pake. Auk hedang ngam, mi man maa meo Au. Auk se bui daleng ngam, mi man maa tulung Au.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ming ela kon, atuil dael lolo in se Auk halin kanan na ngas, siut noan, ‘Lamtua, lam na elol na la? Lamtua tek noan lubu, ta kaim bel Ku in kaa. Lamtua meen tuu kam, kaim bel Ku ui in ninu. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lamtua maa banansila el atuil balu ka lam, kaim sium tamang se kaim uma. Lamtua muik kai-baut in pake lo kam, kaim belen. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Lamtua heda kam, kaim laok meon. Lamtua se bui dalen nam, kaim laok tulung. Kaim tao dasi-dais in ela ngas, blingan na?’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Lam mam Auk siut oen noan, ‘Auk in tek mia ni tom baktetebes! Ta se oras mi tao dasi-dais in ela ngas, bel Auk atulin in ana dudui ngas kon no, na mi tao taung Auk son na!’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Hidim Auk tek atuli-atuil in se Auk halin kliu ka ngas noan, ‘Hoe atuil daat me! Ama Lamtua Allah bahang mi son. Lakom nodat deng nia! Mam Auk tadu atuli le laok pasang tamang mi se ai naraka man in kaloe hidi nutus taan lo kua. Ta Ama Lamtua Allah mana pesang maan in susa-daat na son, bel uikjale kas nol oen laih tuan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Auk nulut soleng mia, undeng dedeng Auk lubung ngam, mi bel Auk in kaa lo. Auk meeng tuu kam, mi bel Auk in ninu lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Auk maang banansila el atuil balu ka, mo mi dai sium tahang Auk se mi uma las lo. Auk muik kai-baut in pake lo, mo mi bel Auk lo. Auk hedang, mo mi maa meo Auk lo. Auk se bui ku daleng, mo mi maa le tulung Auk lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ming ela kon, atuil daat tas siut noan, ‘Lamtua, na elol son na la? Lamtua tek noan lubu, mo kaim bel in kaa lo. Lamtua meen tuu, mo kaim bel in ninu lo. Lamtua maa banansila el atuil balu ka, mo kaim sium tahang se kaim uma las lo. Lamtua muik kai-baut in pake lo, mo kaim bel lo. Lamtua heda, mo kaim laok meo lo. Lamtua se bui ku dale, mo kaim laok tulung lo. Tiata kaim tao saol Lamtua ela blingan son na?’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mam Auk situs noan, ‘Auk in tek mia ni tom baktetebes! Ta dedeng mi dai tulung atuil anang dudui las lo ka, na banansila el mi dai tulung Auk lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hidi nam atuil daat nas haup in susa-daat napiut didiin hidi nutus taan lo. Molam atuil man dalen na lolo ngas, haup in nuli napiut nol Ama Lamtua didiin son na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nikit Yesus tui hidi dais nas totoang bel oen kon, Un tek Un ima-ii las noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mi taan son tam bii ka, naha lelo dua pait tam, kit leol tene Fesat Paska la. Lius oras na lam, muik atuli le hee soleng Au, Atuling Baktetebes nia. Hidim oen pauk tele Auk se kai sangsuli lu dapang.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Leol na, tulu agama Yahudi las tene-tenen nas, nol blala-blalan hadat tas nakbua se Kayafas uma. Kayafas na mo, tuang tene deng tulu agama Yahudi las. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Oen nuting lalan le daek Yesus nol ete-ete, halin keo tele Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mo oen tek apa noan, “Natang le! Kit daek Un nol ni deken le, ta lelo-leol tene kas maas dadani son. Ta tamlom atuil hut mamo man in kom Una ngas, haung tuku-keng nol kita la.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Se iung Betania, muik atuli mes ngala Simun. Hmunan nu, atuli nikis una, undeng un tom iil baih-bluku. Mo halas ni, un banan son. Oras lelo-leol tene kas maas lius lo bii kam, Yesus nol Un ima-ii las lakos kaa se Simun uma. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Oen kaa mamasu lam, bihatang mes maa tutnaal Yesus. Un kil botor mes daken deng baut in osa. Botor na isin na kon, mina bui bingis man osa isi. Bihatang na maa lius kon, un diuk tehen botor ra leo ka. Hidim un doan mina ka le baa buit-buit laok se Yesus bon na, le daid tada noan, bihatang na todan Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mo nikit Yesus ima-ii las net bihatang na in tao ela ka kon, oen koon-mali le aa nol apa noan, “Sah! Bihaat saa ni le, un soleng parsum mina bui bingis osa isi na, ela lia? ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Banan dui ka un hee mina na tuun! Le halin laok bating duit ta bel atuil kasiang ngas!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mo Yesus taan oen in nangan na, kon Un tek noan, “Mi tao sus bihatang ni deken tia! Nang le un tao ela! Auk daleng kolo, undeng un doan mina bui bingis ni se Auk apang ngi son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ta atuil kasiang ngas nol mi tutungus se mi hlala ka. Mo nesang lo ka kam, Auk leo-leo nol mi lo kam. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nini bihatang ni in doan mina nia ki, un tao Auk apang ngi le bui bingis, banansila el un hising rampe meman taung Auk nitun ni son na. Ta Auk in nuli ki nesang lo son. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nangan babanan ne! Mam Ama Lamtua Allah Dehet Dais Banan na, holhising papmes se apan-kloma kia lam, taon elola ko oen nahdeh deng bihatang ni in banan na kon! Le halin atuli li totoang nangan net una.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Muik at mes deng Yesus ima-ii at hngul dua kas, ngala Yudas Iskariot. Un puti lako nuting tuang-tuang agama Yahudi las le sao Yesus bel one. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Lako lius se tuang-tuang agama Yahudi las kon, un keket oen noan, “Papas totoang! Eta auk hulung mi le daek Yesus sam, mi bel auk saa la?” Kon oen situn noan, “Eta ku le hee Un bel kamin nam, kaim baen ku.” Hidim oen kaih duit lil-muti bil buk tilu, le bel Yudas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kon nam Yudas puti lako le nuting lalan halin sao Yesus bel one. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Taun-taun nam, atuil Yahudi las muik lelo-leol tene man nesang nga lelo itu. Oen noken leol nas noan, ‘Fesat Ruti in Kaa se Lalan’. Fesat ta mana le mulai kon, Yesus ima-ii las maa keket Un noan, “Papa! Duman ni kit musti sai kit leol tene kias, nini in keo lae-blai le tao fesat Paska. Tiata Paap kom le kaim laok mana fesat se ola la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kon Un siut noan, “Mi taam lakom kota lua, tiam mi tutnaal blalan biklobeng mesa. Lam mi tekan elia, ‘Ama! Paap Guru nataka kam, Un oras in mate ka maa dani son. Ta Un nodan mana mes se ama uma lia, le Un pake taung in tao fesat Paska nol Un ima-ii las.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ming ela kon, Un ima-ii las lakos, le daek muid asa man Un in teka ka. Hidim oen mana in kaa, taung fesat Paska se na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Duman son kon, Yesus nol Un ima-ii at hngul duas kas, daad le kaa fesat Paska leo-leo se na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Oen kaa mamaus lam, Un tekas elia, “Mi hii napat le! Muik at mes deng mia li, man mam hee soleng Auk lakong bel atuil didang.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ming ela kon, oen dalen nas banan lo. Kon oen mesa-mesam keket Yesus noan, “Atuling man Paap in aa na, auk lo ta lo?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kon Un siut noan, “Atuling man dopon un ruti la lako mako ni dalen leo-leo nol Au ka, man hee soleng Au. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nangan ne! Au, Atuling Baktetebes nia, musti mateng banansila el asa man oen in dul meman son, ne Ama Lamtua Allah Buk Niu ka ka. Mo doha loo! Atuling in hee Au ka, mam lepa-haal un in susa-daat ta esa! Tiata in banan dui ka, un ina ka huan deken tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hidi nam, Yudas kon keket noan, “Atuling man Paap in aa na, auk lo, ta lo?” Kon Yesus situn noan, “Meman ku esa man tek ela son, mo asii pait ta?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Oen kaa mamasu lam, Yesus kat ruti bua mes le nodan mamo se Ama Lamtua Allah. Hidim Un bilas-bilas ruti na, le tunang bel Un ima-ii las nol tekas noan, “Ruti ni, Auk apang nga. Kata, le kaa tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Hidi nam, Un kat klas mes anggor inu, le nodan mamo se Ama Lamtua Allah. Hidim Un tunang laok bel Un ima-ii las nol tekas noan, “Mi totoang kata, le ninu. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ta anggor ni, Auk dalang nga. Mam Auk mateng le dalang ngi holbohon, halin bel boa-blingin atuli hut mamo deng oen in kula-sala ngas. Daal ni daid tada le tek nuting noan, asa man Ama Lamtua Allah in hid son na, meman halas ni dadi son. Tiata kata, le niun tia! ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mo hii babanan! Ninin deng duman nia, Auk niun anggor pait lo kang. Didiin mam Auk nol Auk Amang in ne sorga ku daad le kil bandu leo-leo son le, halas-sam Auk niun nol mi pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hidi kon, oen tao dani mes le naka-nahalit Ama Lamtua Allah. Nol duman na kon, oen putis lakos leten Saitun nua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Oras oen in lakos bus el leten nua ka, Yesus tek Un ima-ii las meman noan, “Duman nia, mi totoang lalim nang soleng Au. Undeng dulan meman son ne Ama Lamtua Allah Buk Niu ka noan, ‘Mam Ama Lamtua Allah tao tele atuling in lolo-poa ka, ta un lae-blai las lalis holhising.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Meman Auk mateng. Mo mam Auk nuling pait, ta Auk laok natang mi se propinsi Galilea.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mo Petrus kaen noan, “Papa! Atuil tengas totoang lalis nang soleng Paap kon no, auk nang Paap lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kon Yesus siut noan, “Ela le Petrus? Hii ke! Duman ni manu tukluin lo bii kam, ku kaen oe tiul son noan, ku taan Auk lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mo Petrus kaen muun dui pait noan, “Loo Papa! Eta Paap mate kam, auk kon mateng leo-leo nol Papa. Taon elola kon, auk lail nang soleng Paap lo!” Petrus tapan tenga las kon tek ela. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hidi kon Yesus nol Un ima-ii las lakos napiut, ti oen lius se leten Saitun na, se klapa mes ngala Getsemani. Se na, Yesus tek Un ima-ii las noan, “Mi daad natang se nia le, ta Auk le lakong kohe-kanas se nua.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mo Un haman Petrus, Yakobus nol Yuhanis, le oen tilus leo-leo nol Una. Kilan deng oras na kon, Yesus nataka kam, Un dalen na sus isi, nol hutlulu. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Oen halas-sam laok bubuit, mo Un tekas noan, “Auk daleng ngi sus isi! Auk nataka kam el noan, Auk le mateng tetetas. Mi daad le melang natang Auk se nia le.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kon Un keko lako katang dui bubuit, hidim Un hai buku ka le kohe-kanas noan, “Papa boa-ili! Eta Paap tade kam, Auk lepa-haal in susa-daat ni deken tia. Mo muid Auk in koma ki deken; nang le muid se Paap in koma ka tuun.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kohe-kanas hidi kon, Un pait lako Un ima-ii at tilu las. Mo oen niin nalas. Kon Un buk-bangun one, hidim tek Petrus noan, “Hoe! Petrus! Tasao le mi ninim mia? Auk in lakong se nua ka, nanapat tuun, mo mi melang nal bubuit lo kon nia! ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kose mi matan nas le langa. Hidim haung le doh nol Au! Ta mi dalen nas meman kom le daek banan, mo mi apan nas bloen. Tiata banan dui ka, mi kohe-kanas le halin eta mi tom in liun-leo kam, mi tahang nala.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Hidim Un pait lako le kohe-kanas noan, “Papa! Eta Auk man musti lepa-haal in susa-daat nia lam, nang le muid Paap in koma ka tuun.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kohe-kanas hidi ela kon, Un pait lako se Un ima-ii at tilu las. Mo oen niin nalas pait son, undeng oen matan nas tede isi. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kon Un nang one, le lako kohe-kanas oe mes pait. Un nodan Ama ka pait, le nang Un lepa-haal in susa-daat na deken, molam muid Un Ama ka in koma ka tukun. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kohe-kanas hidi ela kon, Un pait le buk-bangun Un ima-ii las, hidim tekas noan, “Mi ninim nababael tuun nia? Hangum tia! Ta atuling in le hee soleng Au, Atuling Baktetebes nia ki, maa dani son nuan. Un nol atuil nuas maas le daek Au, halin sao Auk lakong se atuil daat tas iman. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Hoe! Hangum tia! Bela mi matan nas le ngat soba-naan laok elu le! Ta atuling in le hee Au ka, maa son nuan.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesus aa mamaus ela lam, Yudas nol atuli hut mamo maas lisu. Oen maas kil suli nol kai teben, le daek Una. Oen tao ela muid in prenta deng tulu agama Yahudi las tene-tenen nas, nol blalan-blalan hadat tas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas tek oen meman son noan, “Mi tinang babanan ne! Atuling ol man Auk likin nam, mi daek Una! Ta Un nam atuling man mi in nuting nga!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Oen lakos lius se Yesus sa kon, Yudas lat napiut lako dil se Yesus sila ka le aa noan, “Boa-blingin Paap Guru!” Hidim un neok Yesus le likin. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kon nam Yesus ketan elia, “Hoe Yudas! Ku in maa ki, le tao dais nia le?” Hidim atuil hut mamo kas keko lakos le daek Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Taan lo molota Yesus atulin nas at mes luis un hela ka, le dait nutus atuling mes hngila klehen. (Atuling in papa na, tuang tene agama Yahudi la ata.) ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Net ela kon, Yesus kaing un noan, “Bubut ku hela ka pait lako hbubut ta, ta atuil in keng nini hela ka, mam mate nini hela kon. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ku taan lo ke? Auk bisa nodan Auk Amang ngua, le tunang Un ima-ii lihu-lihu deng sorga, halin maa tulung Au. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mo nang tuun tia! Nang le atuil nias daek Au. Ta totoang man in dul son deng Au, ne Ama Lamtua Allah Buk Niu ka ka, musti dadi.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hidi nam Yesus aa nol atuil hut mamo in maa daek Una ngas noan, “Hoeh! Mi bali noan Auk niam atuil daat te? Tasao le mi maa daek Auk nini suli nol kai teben nia? Molota, lelo-lelon nam Auk tui mi se Ama Lamtua Allah Um in Kohe-kanas Tene ka, mo muik tahan atuli mes in tao saa Au lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mo nang tuun tia! Maa, le daek Auk tia! Ta nias totoang dulas meman son deng lolo hmunan nu ne Ama Lamtua Allah Buk Niu ka.” Net ela kon, Yesus ima-ii las lii isi. Kon oen haung lalis nang soleng Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hidi na kon, atuil in daek Yesus sas kil nol Un lako se tulu agama Yahudi las tuang tene Kayafas uma, undeng atuil tene-tene kas nakbua se las son. Nas tene-tene agama Yahudi las, guru-guru agama las, nol blalan-blalan hadat tas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Dedeng oen kil nol Yesus lako ka, Petrus muid nol in huni-huni deng klupu, didiin lako lius se tuang tene ka uma. Petrus kom le taan asa man in dadi ka, tiata un kon tama lako kintal la dalen, le daad leo-leo nol atuil in se la ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Se um na dalen, tulu agama las tene-tenen nas nol totoang atuil man taom daad le nehan dais agama ngas huli-bali. Oen totoang nuting lalan le halin nutus in hukung tele bel Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Oen pake saksi in nole daat mamo le tek deng asa man Yesus in tao son nas, mo oen in tekang nas muik mes lo kon man tatai le pake taung in hukung tele Una. Tukun nam oen pake saksi at dua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Saksi at dua nas tek noan, “Kaim ming Atuling ni aa net noan, ‘Mam Auk tao lean Um in Kohe-kanas Tene ka. Mo se lelo tiul dalen nam, Auk bangun-pii pait.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kon nam tuang tene agama Yahudi la hangu dil se totoang atuil in daad se la ngas silan. Un keket Yesus noan, “Ku ming atuil hut mamo nas in aa le tek sakeng bel Ku ka son. Mo tasao le Ku ete tuun nia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesus siut saa lo. Kon tuang tene ka keket pait noan, “Auk le keket elia! Mo Ku musti siut baktetebes, banansila el Ku siut Ama Lamtua Allah in nuli man ne sorga kua. Muik atuli tek noan, Ku niam Kristus, Ama Lamtua Allah Ana, man Un hid meman son deng hmunan nua ka. Baktebes ela le?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kon Yesus siut noan, “Meman ama in aa ka toma. Mo nangan ne! Ta mam mi totoang ngat net Au, Atuling Baktetebes nia. Mam Auk daad se sorgang, se Ama Lamtua Allah, man muik kuasa muun dudui ka halin kanan na, le kil prenta leo-leo nol Una. Hidim, mam Auk niu pait maang se nopen daleng.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ming Un aa ela kon, tuang tene ka koon-mali isi, didiin un pius sait un kaod blatas sa. Hidim un aa mumuun le tek totoang atuil in daad se la ngas noan, “Kit nuting saksi bakun tia! Mi ming Un in aa ka nol mi hngilan esan son. Un in aa na, Un nikit apa ka son banansila el Ama Lamtua Allah Ana. Ni in bilu-aa son! Mi totoang taan son noan, muid kit atorang agama lia lam, eta muik atuli in tao apa ka el Ama Lamtua Allah kam, atuling na musti mate! ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Tiata mi le nutus elola la?” Kon oen totoang haman tek noan, “Atuling ni meman kula baktetebes! Tiata Un musti tom in hukung tele!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hidi nam muik atuli at ila lo, puut kapen se Yesus. Oen kon diuk kuti-kuti Una, nol atuil tenga las papas Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Hidim oen aa nahmaeng Un noan, “Hoe! Ku niam Kristus ta lo? Olan Ku nataka, le asii man papas Ku lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Dedeng na, Petrus daad nabael se kintal la. Kon ata bihata mes maa aa nol un noan, “Apin ku kon leo-leo nol Yesus, atuling Nasaret ta, ta lo?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mo un kaen se atuil hut mamo kas silan noan, “Loo! Tasao le ku keket auk ela lia! Auk taan Un lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hidi kon, Petrus puti le lako dil se hnita in taam maa ka. Kon bihata mes didang pait, net un dil se na. Tiata un tek atuil in se la ngas noan, “Hoe, apin auk net atuling ni leo-leo nol Yesus, atuling Nasaret ta.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kon Petrus kaen noan, “Tamlom mo ku nuin na! Auk sumpa, auk taan Atuling na lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nal nesang lom, atuil didang in se la ngas tekan pait noan, “Hoe! Ku kaen noan, ku leo-leo nol atuling na lo deken! Ta kaim tanan deng ku dasim in aa ka, undeng ku aa kam tuladang el atuil Galilea ka!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mo un mulai lote, nol labang le kaen noan, “Auk sumpa pake Ama Lamtua Allah ngala ka! Auk taan Atuling na lo!” Un aa hidi ela kon, manu tukluni. ");
INSERT INTO hegNTpo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ming manu ka in tukluni ka kon, Petrus nangan net apin Yesus in tek un noan, “Manu tukluin bii kam, ku kaen lalis tiul son noan, ku taan Auk lo.” Nangan net ela kon, un lail puti lako likun na, le lilu mumuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Oskaong mitang bii kon, totoang atuil in nehan dais agama ngas, koo mes le tao tele Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Undeng na, tiata oen but Un le kil nolan lako ngada se gubernur Pilatus. Lole oen in koma ka le gubernur ra man hukung tele Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nikit Yudas taan noan, tene-tene kas nutus son le hukung tele Yesus, kon un sabail apa ka, undeng un man hee soleng Yesus. Tiata un pait lako se tene-tene deng tulu agama Yahudi las, nol blalan-blalan hadat tas, le bel pait oen duit lil-muti bil buk tilu las. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Un tekas noan, “Auk kula son, undeng auk sao Atuling man muik salan saa lo ka, bel mi son.” Mo oen siut un noan, “Eeh! Kaim hosek nol ku lo son! Ku esa man lepa-haal in kula na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kon nam Yudas pasang soleng duit nas lakos se Um in Kohe-kanas Tene ka dalen. Hidim un puti lako le tai tele apa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tukun nam tulu agama Yahudi las tene-tenen nas, laok naim nakbuan duit man Yudas in pasang soleng son nas. Oen aa nol apa noan, “Kit tamang duit nias pait lakos se kaban duit ta deken tia, ta duit nias duit luli. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tiata, in banan dui ka, kit laok sos dale teb mes deng atuling in daek mulu kua. Halin eta atuil in laok-maa mate, le muik atuli in tadas una lo kam, kit puan laok se dale na tuun.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kon nam oen pake duit nas le laok sos dale na. Tiata maa lius leol neot nia, atuli noken dale na lam, ‘Dale Dala.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nini ela lam, oen muid asa man Ama Lamtua mee-baah Yeremia la, in tek meman son noan, “Oen pake duit lil-muti buk tiul nas le sos dale. Oen pake duit nas, undeng duit nas atuli mes osa, muid asa man atuil Israel las in nutus meman son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Dale na oen sosan deng atuling in diuk mulu ka. Auk dul ni muid Ama Lamtua Allah in prenta au ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nikit atuil nas kil nol Yesus lako lius se gubernur ra kon, un keket Yesus noan, “Elola? Ku niam baktetebes atuil Yahudi las Lahin ne?” Un siut noan, “Baktebes! Paap in aa na, toma.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mo dedeng tulu agama Yahudi las tene-tenen nas, nol blalan-blalan hadat tas klaa nolan dasi mamo ka, Un siut saa lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kon gubernur ra keket Un pait noan, “Ku ming oen in aa apin na lo ke? Oen bel kula Ku mamo isi son, mo tasao le Ku siut lo kia?!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mo Un siut bubuit lo kon, ta gubernur ra herang isi. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Taun-taun nam, eta atuil Yahudi las tao fesat Paska lam, taom atuil hut mamo kas huil atuil bui mesa, le gubernur ra sao puting. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Dedeng na, muik atuil bui mes ngala Barabas. Atuli las totoang taan son noan, un nam mo asii, undeng un nam daat isi. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Leol na kon, atuli hut mamo lakos se gubernur Pilatus, le nodan un sao atuil bui mesa, banansila el in biasa ka. Kon Pilatus keket oen noan, “Banan! Mo auk sao se asii la? In mo nia ki Barabas, nol Yesus, man atuli las noken noan Kristus. Auk sao se ola la? Mi huil tuun.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Gubernur ra aa ela, undeng un taan son noan tulu agama Yahudi las tene-tenen nas idus Yesus isi, tiata oen kil nol Yesus maa bel una.) ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Gubernur ra pres dais na mamasu lam, un sapa ka hid maa tekan noan, “Papa ku! Doha-doha, ta Yesus nam Atuil man muik Un kula-salan lo. Undeng Una, tiata sian auk natloa banan lo. Maa pes halas ni kon, auk nataka kam banan lo tetetas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mo tulu agama Yahudi las tene-tenen nas, nol blalan-blalan hadat tas hode-lokot atuil hut mamo kas, le halin oen nodan gubernur ra le sao se Barabas, mo hukung tele Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kon gubernur ra keket oen pait noan, “Deng atuil at dua nias, auk sao se ola la?” Oen siut kleba-kleba noan, “Barabas! Sao se Barabas tuun!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mo un keket oen pait noan, “Eta ela lam, auk tao elol nol Yesus, man atuli noken noan Kristus sia la?” Kon oen siut kleba-kleba pait noan, “Pauk tele Un se kai sangsuli lua!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ti gubernur ra keket pait noan, “Un in kula ki asa la? Auk pres Un son, mo auk haup Un in kula-salan saa lo!” Mo oen totoang siut kleba-kleba muun dui pait noan, “Tao tele Una! Pauk tele Un se kai sangsuli lu dapa tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nesang lo kon, un tana noan un tao nal saa pait lo son, lole atuil hut mamo kas le hangus tuku-keng lolen son. Tiata un kat ui le haun ima ka se oen silan, hidim tekas noan, “Auk lepa-haal Atuling ni in mate ki lo! Mi totoang man musti lepa-halan!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kon atuil hut mamo kas siut kleba-kleba noan, “Hao, nang lako! Nang le kaim nol kaim ana-upun nias man lepa-haal Un dala ka!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ming ela kon, Pilatus tek noan, “Elam daid muid mi in koma ka.” Hidim un sao Barabas muid oen in koma ka. Mo un prenta atuil in doha ngas, le laok lapat Yesus didiin apa ka papa si-sii. Lapat hidi kon, tentara las kil nol Yesus le nolan laok pauk tele se kai sangsuli lua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hidi na kon, tentara las pel nol Yesus lako se oen benteng nga kintal tene ka. Se na, oen haman oen tapan in batalion mes nol one ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hidim oen kaod bel Yesus kaod blatas mea kaloen mesa, banansila el taom lahi las in pake ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Oen kon kat klais hlango, le naneng daid hlotong. Hidim oen tudan hlotong duli na laok se Yesus bon na, le tao banansila el noan, oen nikit laih balu, le lotong belen hlotong lahi ka. Oen kon tapa belen kai mes laok se Un ima kanan na, banansila el hnikan in kil prenta ka. Hidim oen hai bukun nas saol Una, le hlak in todan Una noan, “Kaim todan atuil Yahudi las Lahin.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nol oen kon puut kapen se Una, hidim kat hnikan na deng Un ima ka, le diku-diuk Un bon na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Oen bilu-aa kuti-kuti Un hidi kon, oen kolong soleng kaod blatas na, le pake seda belen Un kai-batu las pait. Hidi nam oen kil puting Un deng kota Yerusalem, le nolan laok pakun se kai sangsuli lu didiin mate. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dedeng oen pel nol Yesus lako ka, se lalan hlala kam, oen tutnaal atuling mes deng kota Kirene, man halas-sam le taam lako bus el kota la. Un ngala Simun. Kon oen dising un le haal seda Yesus kai sangsuli la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Didiin oen lakos lius se mana mesa, ngala Golgota. (Se dais Aram mam, un nahin na noan, “Maan bon seen.”) ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Se na, oen le ninung Yesus nini anggor man kutang son nol kai mali, le halin Un tahang nal ili. Yesus niun soba-nanan bubuit, mo hidi nam Un hutun soleng. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hidi kon oen pauk Un se kai sangsuli la. Nol tentara las pel lot le asii man haup Un kai-batu las sa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hidim oen daad doh Un se la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Oen kon dul se kai bleha mes noan, “NI YESUS, ATUIL YAHUDI LAS LAHIN” Hidim oen pauk kai bleha na se kai la, titu se Yesus bon na dapa, le tulu bel noan, tasao le oen hukung tele Una lia. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Se na kon, oen pauk tele atuil in nuhu-dau daat at dua. Mesan na se Un halin kanan na, mo mesan na pait se Un halin kliu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Totoang atuil in lako-pait deng na ngas, ngat net Una. Kon oen liun sulan le bilu-aa Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Oen kidu le haman tekan noan, “Hoe! Ku tek noan, Ku tao lean nal Ama Lamtua Allah Um in Kohe-kanas Tene ka, hidim lelo tiul siis sam, Ku bangun-pii pait, ta lo? Eta baktebes Ku niam Ama Lamtua Allah Ana kam, olan Ku loat Ku apam ma, le niu deng kai na tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tulu agama Yahudi las tene-tenen nas, nol guru-guru agama las, nol blalan-blalan hadat tas kon, bilu-aa Un noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Un bel slamat atuil didang son, mo Un apa ka esa kam, Un bel slamat nalan lo. Un tek le Un niam Laih taung atuil Israel las, ta lo?! Eta ela lam, banan dui ka Un niu deng kai na tia. Ta kit net ela, halas-sam kit parsai Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Eta baktetebes Un nam Ama Lamtua Allah Ana kam, nang le ‘Un nahlae se Ama Lamtua Allah. Ta eta Ama Lamtua kom Una lam, taon elola ko Ama Lamtua man bel slamat Una.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Atuil in nuhu-dau daat at dua las kon, bilu-aa Un ela. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hidi kon, mitang-mames kabut maan na, deng lelo ditu lako pes diuk tilu lelo-maun. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Diuk tilu lelo-maun tukun nam, Yesus haman mumuun nini dais Aram noan, “Eli! Eli! Lama sabaktani?” (Un nahin na noan, “Ee Allah! Auk Lamtuan! Tasao le Paap bali kudi nang Auk eli lia?”) ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Muik atuli at ila lo dadani se na, oen ming Un fala ka. Kon oen tek apa noan, “Hoe! Mi hii le. Un haman upung Elia, Ama Lamtua mee-baah hmunan nua ka!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hidi kon atuli mes lail lako kat kitu duda mes le butun laok se kai lolo mes tula, hidim dopon tamang kitu na laok se anggor ngilu ka, le totong bel Yesus halin Un bolos. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mo atuil tenga las pait tam aa noan, “Tahang, le kit ngat soba-nanan, upung Elia maa bel slamat Una tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus haman nol fala mumuun oe mes pait, hidi na kon Un mate. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Se Um in Kohe-kanas Tene ka, muik kitu tene mes loen le kele Ama Lamtua Allah Kamar in Niu Dudui ka. Tom nol Yesus hngasa ka in nutus sa, kitu tene na sait bating dua deng dapa lako pes dale. Hidim lul-beko muun didiin baut tene kas hoen bating dua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Niut utu ngas kon hobokas. Nol Ama Lamtua Allah bel Un atulin in maet son nas mamo le nulis pait. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nikit Yesus nuli pait kon, oen putis deng oen utun nas, le taam lakos Yerusalem. Atuli hut mamo ngat net one. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Se Golgota, muik komendan mesa, nol un ima-ii las doh Yesus se kai sangsuli la. Nikit oen net lul-beko ka, nol totoang man in daid son nas kon, oen lii isi. Hidim oen aa nol apa noan, “Idaah! Atuling ni meman baktetebes Ama Lamtua Allah Ana!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Se na kon, muik bihata hut mamo, man ngat net Un in mate ka deng kakatang. Oen muid Un son deng Galilea, lole oen man tutan-lau Un lo-lolo hmunan nua. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Deng bihaat nas muik teng ngalan, Maria deng iung Magdala, Maria mes pait (na Yakobus nol Yusuf ina ka), nol Sabadeus sapa ka, (na Yakobus duas Yuhanis inan na). ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Se na muik atuil in muki mesa, deng iung Arimatea, ngala Yusuf. Un muid Yesus in tui ka blaan son. Yesus in mate ka, tom nol leol lima. Ola ka lam, tom nol atuil Yahudi las leol in kohe-kanas. Tiata leol lima ka, nikit lelo-maun tukun nam, Yusuf nuting lalan le laok niung Yesus nitun na meman, deng kai sangsuli la dapa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Un lako se gubernur Pilatus sa, le nodan Yesus nitun na. Kon nam gubernur ra prenta le oen sao Yesus nitun na bel una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tukun nam Yusuf lako Golgota, le niung Yesus nitun na deng kai sangsuli la. Hidim un kabut Yesus nitun na babanan nini kitu balu man osa ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Dedeng na, atuli halas-sam paat hidi bolo nitu mes se leten batu mesa, le mana meman taung Yusuf, nol un nenan nas in mate. Kon Yusuf nol un tapan nas kok tamang Yesus nitun na, le laok nene se bolo na dale. Hidim oen lulin baut bleha tene mesa, le hep kele bolo ka hnita na babanan. Hidi nam Yusuf nol un tapan nas pait. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Dedeng na, Maria deng iung Magdala nol Maria tenga las kon muid le lakos lius se maan na. Oen daad saol bolo ka le tadas babanan mana la. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ola ka, tom nol atuil Yahudi las leol teen in dake. Kon tulu agama Yahudi las tene-tenen nas, nol atuil Farisi las, lakos ngada se gubernur ra. ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Oen tekan noan, “Ama gubernur, kaim nangan net dedeng atuling in nole-lilung daat na, nuli nabale la, Un aa noan, ‘Meman Auk mateng, mo hidi lelo tilu lam, Auk nuling pait.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Undeng na, ama tulung tadu tentara las, le laok doh niut utu ka babanan, didiin lelo tilu. Nini ela lam, Un ima-ii las maa naok nal Un nitun na lo, le nole atuli las noan Un nuli pait son lo. Ta eta oen nole ela lam, na daat dui pait deng oen in nole hmunan nua, se dedeng oen in aa noan Un nam, Kristus sa.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ming ela kon gubernur ra siut noan, “Banan! Mo mi muik atuil in doha esam me? Lam banan dui ka pake se oen tuun, le halin laok doh mana la babanan.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kon oen kil nol oen atulin in doha ngas lakos se maan na. Lius se uas kon, oen tao taad pukiu niut utu ka hnitan na. Hidim oen tadu atuil nas le doh napiut mana la, halin atuil didang maa kat Yesus nitun na deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Leol minggu la oskaong mitang bii kon, Maria deng iung Magdala, nol Maria tenga las lakos ngat niut utu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nahkitu lam, lul-beko muun isi. Hidim Ama Lamtua Allah ima-ii mes deng sorga niu maa, le lako lulin bian baut tene in hep kele bolo ka ka. Hidi nam un daad se baut na dapa. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ima-ii na sila ka kaloe, banansila el bisain na, nol un kai-batu las muti niu-hilin. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ta atuil in doha ngas lii isi, didiin oen pepeten, nol mana nal apan nas lo, banansila el atuil hmate ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kon ima-ii in deng sorga na tek bihata las noan, “Mi lii deken! Auk tana le mi maa nuting Yesus, Atuling man oen in pauk tele son, se kai sangsuli lu dapa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mo Un ne ia lo son. Ta Un nuli pait son, banansila el Un in hid meman son na. Taam maa, le tinang maan oen in nene Un nitun nia ki esan. Mana la blo son! ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tiata mi lalaba pait nol ni tia! Le laok tek Un ima-ii las noan, Yesus nuli pait son. Un lako muna son ne Galilea. Oen musti laok tutnaal Un se ua, banansila el asa man hmunan nu Un in hid oen meman son na. Pait tia, le laok tekas asa man auk in aa nia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kon bihaat nas lail putis deng bolo ka. Oen lii, mo oen kon dalen kolo. Oen pait lalaba tuun, le laok tek dais nas totoang bel Yesus ima-ii las. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mo lius se lalan hlala kam, nahkitum Yesus maa tutnaal nol one. Un aa nolas noan, “Boa-blingin!” Net ela kon, oen maas dadani le neok Un iin na, nol todan-lahing Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kon Un tekas noan, “Lii deken ne! Laok tek Auk ima-ii las, le oen laok natang Auk se Galilea.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Blalan bihaat nas biis nabael se lalan hlala kam, atuil in doha ngas kon pait lakos kota lua. Oen lakos lapur se tulu agama Yahudi las tene-tenen nas, deng totoang asa man in daid son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kon tene-tene agama las nol blalan-blalan hadat tas nuting lalan daat, le baen atuil in doha ngas halin oen nahdeh heheon deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tene-tene nas tekas noan, “Hoe elia, eta atuli keket mia lam, mi musti siut noan, bingin-tai le mi niin nalam mam, taan lo molota, Yesus ima-ii las maa naok lai-niin Un nitu na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nol eta ama gubernur ming haup dais ni son nam, mi lii deken, ta kaim pal in siut una.” ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kon atuil in doha ngas kat duit nas. Oen tao muid tene-tene nas in koma ka. Tiata maa lius halas nia, atuil Yahudi las parsai nabael nol dehet in nole-lilung na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ming hidi blalan bihaat nas in teka ka kon, Yesus ima-ii at hngul hesa kas lakos Galileas, le tutnaal Yesus se leten mesa, muid asa man Un in hid son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nikit oen tutnaal Un se lua kon, oen todan-lahing Una. Mo ela kon no, muik teng deng one la dalen hduan le parsai isi lo nabale. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kon Un maa dadani oen le aa nolas noan, “Ama Lamtua Allah bel Auk kuasa, le prenta totoang in ne sorga nguas, nol totoang in ne apan-kloma ki ngias. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tiata, mi lakom se ola-ol tuun kon, mi musti tek totoang bangsa-bangsa in ne apan-kloma ki ngias deng Auk Dehet Dais Banan na. Mi musti tui oen babanan le halin oen daid Auk ima-iin. Nol mi kon musti sarain one, le halin daid tada noan, oen butu-kil nol Ama, Un Ana ka, nol Un Koo Niu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Hidim tui one, le daek muid totoang prenta man Auk in tek mi son nas. Nangan ne! Auk leo-leo nol mi napiut, didiin apan-kloma ki kiamat.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ni dehet banan deng Ama Lamtua Allah Ana ka. Un ngala, Yesus Kristus, man Ama Lamtua Allah tulu meman son deng lolo hmunan nua. Un dehet ta elia: ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yesus daek Un osa la lo bii kam, Ama Lamtua Allah nutus atuli mesa, ngala Yuhanis. Yuhanis musti lako le sai lalan bel Yesus in maa ka. Hmunan nua, Ama Lamtua Allah pake Un mee-baha mesa, ngala Yesaya, le dul meman son elia: “Hii ke! Auk tadu Auk atulin mesa, le lako sai lalan bel Ku. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mam atuling na lako se epe man in muik atuil loꞌ, le haman tek mumuun noan: ‘Totoang atuli li mana-mana le daek babanan lalan na, halin sium Ama Lamtua in maa kia! Daek titu lalan na, le sodo-sium Una.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Taom atuli las noken Yuhanis noan, Atuil In Sarain Atuli. Un daad se epe man in muik atuil loꞌ. Un kitu-kado las dakes deng hmukit unta bulu. Un bota la daken nini hmukit bulang. Un in kaa ka, klamat nol uin pani. Yuhanis in nuli ka, banansila el upung Elia hmunan nua. Dedeng na, atuli hut mamo deng kota Yerusalem nol propinsi Yudea dalen na totoang, puit maas le tutnaal Yuhanis se un mana la. Oen maas le ngat Yuhanis, nol hii un in tui-tikang ngas. Un tekas noan, “Mi musti haoꞌ nol nang soleng mi in kula-sala ngas totoang, le halin nam Ama Lamtua Allah kose soleng mi in kula-sala ngas. Hidim mi musti sarani, le halin daid tada, noan, mi babanan nol Ama Lamtua Allah son.” Hidi na tuun nam, oen haoꞌ oen in kula-sala ngas, tiata un sarain oen totoang se palun Yordan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Un tekas pait noan, “Mam atuling mes le maa, Un uhu dui deng au. Suma daid Un atulin in loka-loka tuun kon no, auk tatai nolan loꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Auk suma sarain mi nini ui tukun, mo mam Un in dake ka muun dui deng au, undeng Un le tao inu mi dalen nas nini Ama Lamtua Koo Niu ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Dedeng na, Yesus maa deng iung Nasaret ne propinsi Galilea, le tutnaal Yuhanis. Kon Yuhanis sarain Un se palun Yordan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nikit Yesus puti deng ui la tukun nam, Un ngat net apan nu holsai. Hidim Ama Lamtua Allah Koo la niu maa se Una, banansila el korkifi ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kon nam oen ming Ama Lamtua Allah fala ka deng apan nu tek noan, “Ku niam, Auk Anang in namnau ka. Ku tao Auk daleng ngi kolo tutungus.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hidi deng na kon, Ama Lamtua Koo la pel nol Yesus lako se epe mesa, man muik atuil lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Hmukit huin muik mamo ne maan na. Un daad se maan na dedeng buk aat, lelo buk aat. Se na uikjale kas laih tuan na, maa sob Yesus le halin muid se una, mo nalan loꞌ. Hidi kon, Ama Lamtua Allah ima-ii las deng sorga maa lii-lau Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Se dedeng oen tamang Yuhanis in Sarain Atuli ka lako se bui dalen na, Yesus lako se propinsi Galilea, le nahdeh deng Ama Lamtua Allah Dehet Dais Banan na se la. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Un tek noan, “Hii ke! Halas ni Ama Lamtua Allah oras sa maa lius son! Totoang atuli li halas ni tana noan, Ama Lamtua Allah man kil prenta. Tiata mi musti tenem tia, deng mi in nole-lilung daat ta, le bali muid se Ama Lamtua. Hidim parsai se Un Dehet Dais Banan na!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Neot mesan na, Yesus laok muid tubu Galilea la suut ta. Kon Un ngat net atuli mesa, ngala Simun, nol un palin na, ngala Anderias. Oen duas saal ikan. Oen in dake lelon-lelon na ela. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus haman oen noan, “Maa, le muid Au! Lelon-lelon nam mi nuting ikan, mo deng leol neot nia, Auk le tao mi daid atuil in nuting atuli.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ming ela kon, oen duas nang soleng oen sala la, le lakos muid Yesus meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Hidi nam, Yesus lako bubuit pait, kon Un ngat net Sabadeus anan nas. Kaka la ngala Yakobus, nol pali la, ngala Yuhanis. Oen duas mana babanan pukat ta se lui la dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus haman oen duas noan, “Maa, le muid Au!” Tukun nam oen duas nang soleng oen aman na, nol oen atulin in dake ngas se lui dapas. Le lakos muid Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Hidi kon, Yesus nol atuil at aat man in muid Una ngas, lakos lius se kota Kapernaum. Se atuil Yahudi las leol in kohe-kanas sa, Yesus taam lako se um in kohe-kanas sa, le tui atuli las se na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Totoang atuli las ngaa-bahan nol in hii-ming Un in dehet ta, lole Un taan baktetebes in tui-tikang ngas isin na. Bakisan deng guru-guru agama Yahudi las. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Dedeng na, muik atuli mes tom uikjale. Un kon tama muid se um in kohe-kanas sa, hidim uikjale ka tao atuling na le ahan mumuun noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Hoeh! Yesus atuil Nasaret! Ku le tao saa kami la! Ku le maa tao didaan kami le? Kaim taan Ku! Ku niam mo, Atuling man hmunan nu Ama Lamtua Allah in hid son, le belen maa ka. Ku niam, Ama Lamtua Atulin Niuꞌ, man muik kula-sala lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mo Yesus baet un noan, “Eteꞌ! Lobo deken! Puti deng atuling na tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kon uikjale ka tao atuli nga apa ka pepeten mumuun. Hidim un puti deng atuling na nol ahan la-lalan. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tiata, totoang atuil in se um in kohe-kanas sa hera-herang. Hidim oen totoang tek apa noan, “Awii! Asa nia le? Un prenta uikjale kas le putis, kon oen muid Un in koma ka. Ni in tui baluꞌ te? Atuling ni in aa ki uhu isi mo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hidi deng na la, atuli las dehet apa baha laok baha, didiin lako papmes totoang ingu-iung in se propinsi Galilea ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nikit oen putis deng um in kohe-kanas sa kon, Yesus lako se Simun nol Anderias uma. Yakobus nol Yuhanis kon lakos leo-leo nol one. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simun been na hed otot, un nini tuun se hadang dapa. Tiata nikit Yesus nol Un ima-ii las taam lakos uma la dalen kon nam, atuli maa tek noan, “Blalan bihatang hed otot.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kon Yesus laok ngat blalan bihata nga, hidim kilan se ima ka le, hulung hangu dili. Kon nam un in hed otot ta ilang meman. Hidi nam blalan bihatang na puti lako tutan-lau one. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lelo lako dadaen, kon atuli las kil atuil ili koed-ngasing ngas, nol atuil in tom uikjale kas laok bel Yesus, le nodan Un tao banan one. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Didiin atuli se kota mes isin maas nakbua se uma la hnitan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Atuli las in ili ka bili-ngalaꞌ, mo Yesus taih banan oen totoang. Nol Un nulut soleng uikjale mamo koseꞌ. Mo undeng uikjale kas taan Una, tiata Un beles aa saa lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ola ka oskaong bii, hbabut nabale, mo Yesus hangu, le puti lako deng um na. Un lako se maan in ete mesa, le kohe-kanas se Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simun nol un tapan nas hangus kon oen net Yesus lo, tiata oen nuting Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nikit oen laok tutnalan kon, oen tekan noan, “Papa! Atuli mamo maa nuting Papa.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mo Un situs noan, “Ela kon banan. Mo in banan dui ka, kit laok ingu-iung man in dadani mo ni ngias lolen. Ta Auk le tek oen deng Dehet Dais Banan ni kon. Undeng Auk osa la ela.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Hidi na kon Un laok papmes propinsi Galilea, le nahdeh deng Ama Lamtua Allah Dehet Dais Banan na, se uma-um in kohe-kanas sas. Nol Un kon nulut puting uikjale kas deng atuli las. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Dedeng na, muik atuli mes iil baih-bluku maa tutnaal Yesus. Un hai buku ka le nodan Yesus noan, “Ee Papa! Tulung auk le! Ta auk tana noan, Paap bisa tao ilang nal auk ili lia, le halin nam atuli nikis auk bakun tia. Sadi Paap tade.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus namnau atuling na, tiata Un doong ima ka le kapas atuling na, le tekan noan, “Auk tade! Tiata ku banan tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nol na kon, atuling na ili la ilang, le un banan meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Hidi nam Yesus tadu atuling na le pait, nol Un hidan ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","noan, “Nangan babanan ne! Ku banan son, mo boel tek atuil deken le! Ku musti daek muid upung Musa prenta la munaꞌ. Tiata, ku lako se tulu agama lu munaꞌ, le un tinang ku apam ma, halin un net noan ku ili la ilang baktetebes son, tam bii ka. Hidim ku musti bel nasar le nodan mamo, halin nam totoang atuli li tana noan, ku banan baktetebes son.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mo atuling na puti kon, un lako nahdeh pukiu se ola-ola. Kon nam, atuli hut mamo kom le tutnaal nol Yesus, didiin Un taam laok nal bus el kota la dalen na lo. Tiata, Un daad se mana-maan in muik atuil lo ngas, se kota likun na. Mo atuli li baa maa tutungus deng ola-ola, le tutnaal nol Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kuhit nal lelo ila lo kon, Yesus lako pait el kota Kapernaum. Kon atuli las tek apa noan, Un pait maa ne uma son. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tiata atuli hut mamo maas deng ola-ola. Oen maas nakbua didiin uma dalen na tepa. Se hnita mata ka kon inu nol atuli. Kon nam Yesus tek oen deng Ama Lamtua Allah in koma ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yesus nahdeh mamasu lam, atuli at aat dohang nol atuling hlukut-kait mes bel Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mo atuli mamo naseke, tiata oen kil nal atuling na lako lius se Yesus sila ka loꞌ. Kon nam oen sakes lakos uma dapas, le sukun uma muhung nga. Nikit uma muhung nga hoboka tuun nam, oen niung atuling na nol un nehe ka lako titu se Yesus sila ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesus ngat net oen in tao ela ka kon, Un tana noan oen parsai baktetebes se Una. Tiata Un tek atuling hlukut-kait ta noan, “Ana! Auk bel ampong ku in kula-sala ngas son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mo muik guru agama Yahudi at ila lo, daad baab se na. Nikit oen ming Yesus aa ela kon, oen dalen nas banan loꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Hidim oen tek apa noan, “Atuling ni brain in aa ela kia! Suma Ama Lamtua Allah sii, man bel ampong nal atuli li in kula-sala ngas. Mo atuling ni in aa ka, un tao apa ka banansila el Ama Lamtua Allah! Na Un bilu-aa Ama Lamtua son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mo Yesus taan oen in nangan ela ka, tiata Un tek noan, “Mi nangan ela deken! ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Ta Auk niam mo Atuling Baktetebes sa. Auk muik kuasa le bel ampong atuli li in kula-sala ngas. Eta Auk tek atuling hlukut-kait ni noan, ‘Ku haup ampong deng ku in kula-sala ngas son,’ mi taan le daid ela tam lo ka. Mo eta Auk tekan noan, ‘Hangu tia! Kat ku nehe ka, le pait tia,’ le mi net esan noan daid ela, halas-sam mi tana noan, Auk muik hak le bel ampong atuli li in kula-sala ngas.” Hidi na kon, Yesus tek atuling hlukut-kait ta noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Hii ke! Ku banan son! Tiata, hangu, kat ku nehe ka, le pait tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ming ela kon, atuling na hangu meman, le un kat un nehe ka, hidim pait. Totoang atuil in se na ngas net na nol matan esan. Kon oen totoang hera-herang le aa noan, “Aauu! Halas-sam kaim net in elia nia. Ama Lamtua Allah meman muun isi.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Hidi na kon, Yesus lako pait se tubu Galilea suut ta. Kon atuli hut mamo maas tutnaal Una. Ta Un tekas deng Ama Lamtua Allah in koma ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Se na, muik atuli mes ngala Lewi, Alfius ana. Un daek se maan in baen bea bel pamarenta Roma la ka. Yesus maa lako deng na kon, Un ngat net Lewi. Ta Un tekan noan, “Maa, le muid Au!” Ming Yesus aa ela kon, Lewi hangu le muid Un meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hidi na kon, Yesus nol Un ima-ii las daad le kaa se Lewi uma, leo-leo nol Lewi tapan in sium bea ngas. Muik atuil didang pait, man atuil Yahudi las noken oen le atuil banan loꞌ, kon daad le kaa leo-leo nol oen se na. Deng atuil in daad le kaa leo-leo nas, muik atuli mamo man kom in hii-ming se Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dedeng na, muik guru agama deng partei Farisi at ila lo, ngat net Yesus daad le kaa leo-leo nol atuil in sium bea, nol atuil in banan long nas. Kon oen keket Un ima-ii las noan, “Tasao le mi guru na daad kaa nol atuil in sium bea, nol atuil daat tas sia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mo Yesus ming haup oen in keket ela ka, kon Un situs noan, “Atuil in ili kam, nuting dokter, mo atuil in banan son nas nuting dokter lo. Ta Auk maang taung atuil in banan lo ngas. Mo atuil man nataka apa ka noan, banan son nas lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Oe mesan na, atuil deng partei agama Farisi las telang. Oen net Yuhanis in Sarain Atuli ka ima-ii las kon, telang. Mo oen ngat tam, Yesus ima-ii las telang el oen loꞌ. Kon nam oen maas tutnaal nol Yesus le keket noan, “Papa! Kaim telang. Yuhanis ima-ii las kon telang. Mo tasao le Paap anan nias telang lo kia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kon Yesus situs noan, “Meman mi tanan son noan, eta muik fesat in sapa kam, atuil in haep pas telang loꞌ, molam oen kaa didiin silis. Eta noan sapa-bikloben na bii se la kam, taon elola ko oen kaa leo-leo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mo mam oe mesa, le atuil didang maa daek lai-niin sapa-bikloben na muna le, halas-sam un tapan nas nangan nam susa, tiata oen telang.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hidi nam Yesus nahdeh taplaeng kleta mesa, noan, “Atuli li tapan kitu balu le soon laok se kaod blaan lo. Ta lo kam eta basen nam, kitu balu ka naskumuꞌ le tao sait taplaeng kaod blaan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ela kon, atuli sail tua balu laok se sapat pohen lo. Ta lo kam sapat ta hoen, le tua ka honong hidi. Tiata, tua balu kam musti salin laok se sapat balu.” Yesus in tui oen ela ka, muik nahin noan, Un in tui-tikang balu ka, boel kutang nol atuil Farisi las in tui blaan na deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Oe mesan na, tom nol atuil Yahudi las leol in kohe-kanas, Yesus nol Un ima-ii las laok deng klapa dales. Kon Un ima-ii las nul ael-gandum le kaa. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ti atuil Farisi las ngat net one, kon oen tek Yesus noan, “Tasao le Ku ima-ii las kaliut kit atoran agama la lia? Oen nul ael-gandum tom nol leol teen in dake! Mi boel tao ela deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Un situs noan, “Mi nangan net upung Daud dehet ta lo ke? Dedeng na, ama Abiatar daid tuang deng tulu agama Yahudi las. Upung Daud nol un anan in muid una ngas tain seen didiin oen lubus isiꞌ. Kon oen taam lakos se Ama Lamtua Allah Hleep in Kohe-Kanas sa, le kat ruti man tulu agama las in bel Ama Lamtua son na le kaa. Molota, suma tulu agama las siis, man boel kaa ruti na. Mo atuil didang ngam, boel loꞌ. Neot na, upung Daud nol un anan in muid una ngas kaa, mo muik atuli in bel kula one loꞌ.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Hidim Yesus tek tapnaeng pait noan, “Mi boel nadidingun deken, Ama Lamtua Allah koet leol teen in dake le daid hangun, halin tulung kit atuli lia. Mo Un tao atuli li le suma muid atorang deng leol teen in dake na tuun loꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tiata Auk niam mo, Atuling Baktetebes sa. Auk man muik hak le tek noan, atuli li bole tam boel in daek sa-saa lo, tom nol leol teen in dake.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Hidi na kon, Yesus pait lako se um in kohe-kanas sa. Un net atuling mes ima halin mateꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mo se na kon, muik atuli deeh nuting lalan le bel kula Yesus. Tiata oen mudung-mudung Una, le Un tao banan atuling na se leol teen in dake na, tam lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kon Yesus haman atuling man ima halin in mate na, le tekan noan, “Maa lako dil se mata lia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kon Un keket atuli las totoang noan, “Eta muid kit atoran agama lia lam, asa man kit boel daken tom nol leol teen in dake ka? Kit daek banan, tamlom daek dadaat ta? Kit tao banan atuli, tamlom keo tele atuli?” Mo oen totoang ete tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kon nam Yesus dalen iil nasekeꞌ, lole oen paiduil isi nol oen atorang nga, mo oen nang atuling man ima halin in mate ka. Un koon-mali le ngat nakekeon one. Hidim Un tek atuling nga noan, “Doong ku imam ma!” Tiata atuling na doong un ima ka, kon suknahkitu lam un ima ka banan meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Net ela kon, atuil Farisi las putis deng um in kohe-kanas sa, hidim lakos koo-dalen mes nol atuil deng Herodes partei la, le nuting lalan halin keo tele Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Oe mesan na, Yesus nol Un ima-ii las lakos se tubu Galilea suut ta. Mo undeng atuli mamo ming asa man Un in daek son nas, tiata oen totoang maas deng ingu-iung in se propinsi Galilea, propinsi Yudea, nol propinsi Idumea, le muid Una. Muik atuli mamo kon maas deng kota Yerusalem, kota Sidon, nol kota Tirus. Atuli deeh kon maas deng palun Yordan halin leol-saken. Oen totoang nuting le tutnaal nol Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Undeng atuli mamo isi, tiata Yesus tadu Un ima-ii las le nuting belen lui mesa. Un le dehet deng lui la dapa, le halin nam oen totoang ming hapu, nol muik in kele Una loꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Hmunan nu, Un tao banan atuil ili koed-ngasing mamo. Undeng na le se dedeng na, atuil in ili ngas totoang maas dil dising apa, le noan kapas Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nikit atuil in tom uikjale ngas ngat net Un kon, oen leas lakos se dale ka, se Yesus silaꞌ. Hidim oen aa mumuun noan, “Ku niam meman Ama Lamtua Allah Ana!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mo Un kaing oen mumuun, le tekas noan, “Mi boel tek atuil deken noan, Auk niam mo asii!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Hidi kon, Yesus sake lako leten mes dapa. Un haman nal atuli at ila lo, man tom nol Un dalen na. Kon oen maas saol Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ta Un tulu nal atuli at hngul dua. Un tek oen noan, “Auk huil mia, halin nam muid napiut se Au, le daid Auk atulin in nutus. Auk kon le tadu mi laok tek Ama Lamtua Allah in hida ka, se atuli li totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nol Auk le bel mi kuasa, halin mi nulut nal uikjale kas deng atuli lia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Atuil at hngul dua nas ngalan nas elia: Simun (man Yesus ngali noan Petrus), Yakobus, Yuhanis, (Yakobus nol un palin Yuhanis, oen duas niam ama Sabadeus anan. Yesus ngali oen duas nini ngaal ‘Boanerges’, man nahin na noan ‘aan lelat ulan’.) Anderias, Filipus, Bartolomeos, Matius, Tomas, Yakobus, (Alpius ana ka), Tadius, Simun (man muid partei pulutik Selot), nol Yudas Iskariot (un man hee soleng Lamtua Yesus). ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hidi na kon Yesus nol Un ima-ii las nius deng leten na, le taam lakos uma dales. Mo muik atuli hut mamo isi maas nuting Una, tiata oen muik dola in kaa loꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ngat net ela kon, atuli las tek apa noan, “Olan ngat Yesus le. Un nadidingun in mana apa ka son.” Undeng Un nenan nas ming atuli las in aa ela ka, tiata oen maas le noan taap lai-niin Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Dedeng na, guru agama las deng Yerusalem maas le tek atuil in se na ngas noan, “Hoe! Mi toe muid Yesus deken. Ta Un nulut nal uikjale ela, undeng Un haup kuasa deng uikjale kas laih tuan na, man oen noken noan, Balsebul.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus ming ela kon, Un haman oen totoang le tekas noan, “Tom nol kit in nangan ni lo! Taon elol le uikjale kas laih tuan na nulut bali un apa ka esa kia! ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Eta se sonaf mes dalen, un hutun nas keng apa kam, taon elol le sonaf na tahang nal napiut ta! ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nol eta se um isin mes dalen, atuli las taan in keng apa si-sii kam, taon elol le um-elan na titu-tema nabale la! ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ela kon nol uikjale kas, eta oen mus apa mes nol mesa lam, taon elola ko oen sisakes! Eta ela son nam, oen dudus-didaan! ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Eta atuli le maa nuhu-dau sa-saa se atuil kuat mes uma kam, un musti but tele atuling kuat na muna le. Hidi halas-sam, un nuhu-dau nal atuling na sa-saa las. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tiata Auk tek mi meman: Ama Lamtua Allah tade son, le kose soleng atuli li in kula-sala ngas. Nol eta atuli li bilu-aa atuil didang ngam, Ama Lamtua Allah kose soleng nal un in kula-sala na nabale. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mo eta muik atuli brain in bilu-aa Ama Lamtua Koo la kam, didiin apan-kloma ki kiamat kon, Ama Lamtua Allah kose soleng un in kula-sala na pait lo ka!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus aa ela, undeng oen noken Un noan, “Atuling na tom uikjale son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hidi kon, Yesus ina ka nol Un palin nas lakos bus el um na, le noan tutnaal nol Yesus. Lakos lius se uas kon, oen dil se likun na tuun, le tadu atuli laok haman Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Se oras na lam, Yesus daad le dehet nol atuli hut mamo. Kon atuli maa tekan noan, “Papa! Paap ina ka, nol Paap palin nas dil ne likun nua. Oen le tutnaal nol Papa.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mo Yesus siut noan, “Auk inang nga nol Auk kaak-palin baktetebes sas, mo asiis sa?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hidim Un ngat lako el atuil in daad pukiu Una ngas, le tekas noan, “Mi totoang nias, man Auk inang nol Auk kaak-paling baktetebes sas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ta atuil in muid Ama Lamtua Allah in koma ngas sa, man Auk nenan baktetebes sas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Oe mesan na, Yesus lako pait se tubu Galilea la. Kon nam atuli hut mamo isi maas dil nakbua. Tiata Un saek lako daad se lui mes dapa man nahun se na, le tui one. Atuil in se tuu ka ngas totoang ming Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tukun nam Un tui oen mamo-mamo nini kleta, noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mi hii babanan ne! Muik atuling mes lako hising biin se un klapa la. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Oras un in hising bini las sa, tenga las nahis se lalan. Ta kee kas maa noto nuli biin nas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mo biin tenga las nahis tom se dale batu. Biin nas nupus hlapat. Mo undeng dale ka nihis, ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","tiata lelo la sake kon, nupung nas bloen le daid tuu-tangas, lole oen klaput tas taam dalen lo kam. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Muik bini teng pait naih taam lakos se blua-duli dales. Kon blua-duli nas kadis nupung nas, tiata oen muik isin loꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mo biin tenga las pait tam, nahis tom se dale boa. Biin nas nupu le nulis daid ina tene, hidim isin. Muik in haup pait isin, lalis buk tilu, teng haup pait isin lalis buk eneng, nol tenga las haup pait lako pes lalis ngatus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Asii man muik hngila kam, hii babanan!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Neot mesan na Yesus sii kon, Un ima-ii at hngul dua kas, nol atuil didang man ming Un dehet ta son nas, maas tutnaal nol Una. Oen nodan Un le tek beles kleta ka nahin na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kon Yesus situs noan, “Undeng mi le taan baktetebes deng Ama Lamtua Allah prenta la, tiata Auk tek mi meman deng kleta ka nahin na. Mo eta atuil didang ngam, Auk tuis nini kleta tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ta atuil didang ngas banansila el asa man Ama Lamtua Allah mee-baha la in dul meman son noan, ‘Oen net son, mo dai nangan tanan lo. Oen ming son, mo dai muid lo. Nang le oen parsai se Ama Lamtua deken tia, le halin Ama Lamtua bel ampong oen bakun na.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Hidi na kon, Yesus tek oen deng kleta bini la nahin na elia, “Eta mi taan kleta na nahin na lo bii kam, taon elola le mi taan kleta tenga las nahin nas sa? ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tiata, un nahin na elia: atuil in hising bini ka, banansila el atuil in nahdeh deng Ama Lamtua Allah in Teka-teka ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Biin man nahis se lalan na le kee kaa nulis sa, banansila el atuil man in ming Ama Lamtua Allah in Teka-teka ngas, mo nesang lo kon, uikjale kas laih tuan na maa kat lail-niin in Teka-tekang nas deng un dalen na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Biin man nahi tom se dale batu ka, banansila el atuil man in ming nol sium in Teka-teka ngas son nol dael kolo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mo in Teka-tekang nas muik klaput loꞌ, undeng na le nuli nesang se un dalen na lo. Ta eta atuil didang tao sus una, undeng un in sium in Teka-teka ngas sa, lam un sao soleng in Teka-tekang nas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nol biin man nahi se blua-duli hlala ka, banansila el atuil in ming in Teka-teka ngas son. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mo un kukaum naseke nol osa bili-ngala, le halin nuil muid un in koma ka tukun. Kon nam osa-os nas dising soleng in Teka-tekang nas deng un dalen na, tiata muik isin lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mo biin man in nahi tom se dale boa ka, banansila el atuil man in hii-ming nol sium in Teka-teka ngas, le daek muid Ama Lamtua in koma ka. Hidim un daek sa-saa banan nas, banansila el biin man in isin na. Muik deeh isin mamo dui lalis buk tilu, muik deeh lalis buk eneng, nol muik deeh pait isin lako pes lalis ngatus.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus nahdeh deng lui dapa napiut. Un bel tapnaeng kleta mes pait noan, “Elola! Mi net atuli hoet hadut, hidim tungan se fai dalen tamlom todo se hadang kloma ke? Net lo bii, ta loo! Ta eta taon ela lam, un langa ka puti lo. Tiata atuli li musti todo hadut se maan lalapa, le halin un langa ka puti. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ta sa-saa man in buni hahalas nia ngas, mam ngat netas. Nol asa man halas ni atuli li tanas lo bii ka, mam oen tanas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tiata asii man muik hngila kam, hii babanan! ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nangan babanan! Eta mi sukat atuil didang in dake ka elola lam, mam atuli kon sukat mi ela. Nol Ama Lamtua Allah kon sukat bali mia ka ela. Mo Un in sukat ta ngele dui pait. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tiata, eta atuli li nuting Ama Lamtua Allah in koma ka nol baktetebes sam, un taan taplaeng. Mo eta un hosek nol Ama Lamtua Allah in koma ka lo kam, un ngengo keko lako.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus aa tapnaeng pait noan, “Ama Lamtua Allah hutun nas in mamo taplaeng nga, banansila el biin man atuli hising se klapa la ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Atuling na pait, le nini-hangu, hidim nangan net biin na pait lo. Molam biin na nupu, le nuli daid tene. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ta biin na nuli esa se dale ka, le bango, hidim bunga, didiin isin. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Eta noan biin na ka ale lam, mam ale latu son, halas-sam klaap lamtua ka maa le nul tukun. Totoang nias, in dake ka Ama Lamtua Allah.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Hidi kon, Yesus nahdeh napiut noan, “Auk taplaeng kleta mes pait, elia: mi bisa sukat Ama Lamtua Allah atulin nas. Laih hmunan na oen bubuit tuun mo nesang le lako lam, oen mamo taplaeng. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Na banansila el kai beas man ana blutu dui ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mo eta kit haiꞌ beas na son nam, un nuli daid kai ina tene. Kon kee kas hong maas nuting fuu, le koet hno se na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus tui oen ela, muid oen in nangan tana ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Taom Un nini kleta, le tui atuli las. Mo eta Un nol Un ima-ii las sam, Un tek puting kleta na nahin na totoang beles. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lelo-maun son, mo Yesus nabael se lui dapa. Kon Un tek Un ima-ii las noan, “Maa le kit luan laa lakong tubu halin nua.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kon nam oen saek lui leo-leo nol Yesus. Le oen luan laa lakos nang atuil hut mamo kas se na. Mo muik atuli teng muid oen nini lui didang. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Oras na, Yesus tian bon na se hlunin mesa, le niin nala se lui ulin na. Nesang lo kon angin tuan na maa. Len diuk tamang ui se Yesus nol Un ima-ii las lui la, didiin nate bubuit tam ui inu. Tiata, Un ima-ii las lii isi. Kon oen maas buk-bangun Yesus, noan, “Papa! Hangu tia! Ta kit le mel mateng son nian ne! Mo Paap tao hii lo ke!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ming ela kon, Yesus hangu le kaing angin na noan, “Ete tia!” Hidim Un prenta tubu ka noan, “Tene tia!” Kon angin na eteꞌ, nol tubu ka kon doson meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Hidi nam Yesus kaing Un ima-ii las noan, “Tasao le mi totoang lii ela lia? Mi parsai Auk lo ke?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Oen totoang lii nol herang, hidim tek apa noan, “Un niam asii le? Le didiin angin nol len kon, ming Una lia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Hidi kon, Yesus nol ima-ii las lakos lius se tubu Galilea suut halin na, se mana mes ngala Gerasa. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Se na, muik biklobe mes tom uikjale didiin nuin. Un daad se niut utu nguas. Lelo-duman nam, un lako-pait nol lu-lulit pukiu boboko in se na ngas, le ahan tutungus. Nol un diuk papa apa ka nini batu. Mo un kuat isiꞌ. Muik atuli in but nal una loꞌ, butun nini ranteng bis kon bolen loꞌ. Atulis but un ima-iin nas oe-oe son nini ranteng bisi, mo un tao nutus ranteng na, nol tao didaan bis in se un iin na ngas. Un kuat nasekeꞌ, didiin muik atuli mes lo kon man tahang nal una. Nikit Yesus nol Un ima-ii las nius deng lui la, le kida iin se tuu ka kon, atuling nuin na ngat net oen deng kakatang. Tukun nam, un puti deng niut utu ngas, le lail lako hai buku ka se Yesus sila ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ngat atuling na tao ela kon, Yesus tek noan, “Hoe! Uikjale me! Puti deng atuling na tia!” Mo atuling na ahan mumuun le tek noan, “Hoe! Ku le tao saa au la! Auk tana, Ku niam Yesus, Ama Lamtua Allah man kuasa dudui ka Ana. Auk nodan le Ku tao saa auk deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kon Yesus keket un noan, “Ku ngalam sii la?” Atuling na siut noan, “Auk ngalang Legion, ta kaim niam mamo nasekeꞌ, banansila el batalion mamo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hidim uikjale kas pake atuling na, le nodan Yesus halin boel tadu oen putis deng maan na deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Katang deng maan na lo kam, muik atuli teng doh bahi okat mesa. Baih nas totoang nataka le lihu dua. Oen nuting in kaa se leten suut ta. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kon nam uikjale kas nodan Yesus noan, “Tadu kaim laok tamang se baih nuas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ming ela kon, Yesus tade. Kon uikjale nas lail putis deng atuling na, le taam lakos se baih nas. Tiata baih lihu dua nas, lail nius dadahut muid hdoan na suut ta, le taam lakos tubu ka dales, tukun nam oen mel mates totoang se na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ngat net ela kon, atuil in doh bahi la ngas lii isiꞌ. Hidim oen lail lakos tek papmes atuil man in se ingu-iung na ngas. Kon atuli hut mamo puit maas le ngat asa man in daid son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Oen maas tutnaal nol Yesus, kon oen ngat tam atuling in tom uikjale ka daad se na. Un in nangan na banan son, nol un kon pake kai-baut son. Ngat net ela kon, atuli las totoang daid lii, lole oen tana noan, asii man nulut puting nal uikjale mamo nas deng atuling na son nam, taon elola ko atuling na meman muun isi. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hidim oen totoang lakos tek papmes se ola-ol noan, oen net nol matan esan, le atuling in tom uikjale ka banan son, nol bahi las mel mates hidi. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kon atuil in se iung na ngas, maas nodan Yesus le lako bian deng oen ingu-mana la. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nikit Yesus mana le sake lako lui dapa kon, atuling man apin tom uikjale ka nodan le lako muid Yesus kon. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mo Yesus tade loꞌ. Un tekan noan, “Banan dui ka, ku pait lako le tek ku kaak-palin nas totoang, asa man Ama Lamtua Allah in tao bel ku son na. Nol tekas noan, Ama Lamtua Allah namnau ku isi.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hidi kon, atuling na pait, le lako papmes mana mesa, man muik kota hngulu. Oen noken maan na noan, ‘Dekapolis’. Un dehet atuli las deng asa man Yesus in tao bel un son na. Totoang atuil in ming un in dehet ta ngas, herang isi, le tek noan, “Meman ana lo baktetebes!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Hidi kon, Yesus nol ima-ii las lakos pait se tubu ka halin na. Nikit oen nius deng lui la, kon atuli hut mamo isi maas dil nakbua dadani nol Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Se na, muik atuling mes ngala Yairus. Un nam mo, tulu deng um in kohe-kanas se kota na. Nikit un net Yesus kon, un hai buku ka se Yesus sila ka, ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","le nodan noan, “Papa! Auk anang bihata halas-sam taun hngul dua, mo un heda ngele isi. Paap tulung maa taih banan un le.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kon Yesus muid Yairus le lakos el un uma. Mo oras oen lakos sa, atuli hut mamo isi laok disi-dising apa le muid Yesus deng klupu. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Se atuil hut mamo nas hlala, muik bihata mes net bulan teen taan loꞌ, lo-lolo taun hngul dua son. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Un pake nuli un duit tas, nol un hmukin nas, le baen atuil in tahi ngas. Mo muik in taih banan nal una loꞌ. Un ili la taan in poe keko sake. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Bihatang na ming mamo son deng Yesus. Tiata, un dising tama deng atuil hut mamo nas hlala, le lako dadani nol Yesus deng klupu ka. Un nangan se un dalen na noan, “Sadi auk huud tom Un kado la tuun kon, taon elola ko, auk banan!” Tiata, nikit un huud tom Yesus kado la kon, un in iil daal loos sa tene meman. Nol un nataka kam, un banan baktetebes. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tom nol oras na lam, Yesus nataka kam, muik uhu puit deng Un apa ka. Kon Un bali lis le ngat atuil hut mamo kas. Hidim Un ketan noan, “Asii deng mia la huud Auk kado la lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Un ima-ii las siut noan, “Paap ngat esa tuun. Ta le atuil hut mamo unus tene nias dising apa, mes nol mes elia lam. Taon elol le Paap ketan noan ‘Asii man huud Auk kado la lia?’” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mo Yesus ngat pukiu le nuting asii man apin huud tom Una lia. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ming Yesus in keket ela ka kon, bihata nga lii isiꞌ. Hidim un hai buku ka se Yesus sila ka, le hao noan, “Papa! Auk man huud Paap kado la.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kon Yesus situn noan, “Undeng maam parsai baktetebes se Au, tiata maam banan son. Maam pait nol dael kolo tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus aa mamaus ela lam, atuli mes maa deng Yairus uma, le tek noan, “Kasiang, tana-bihata nga mate son. Tiata tao sus Paap Guru deken tia. Un laok deken tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mo Yesus tao hii atuling na in aa ka loꞌ. Un tek Yairus noan, “Ku lii deken! Parsai se Ama Lamtua tuun.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kon Yesus lako nang soleng Un ima-ii tenga las. Mo Un nol Petrus, Yakobus, nol Yakobus palin Yuhanis, lakos napiut. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nikit oen lakos lius se Yairus um kon, oen ngat tam atuli mamo lob-lau, nol hii kam oen lilu muun isi. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus taam napiut lako uma dalen. Hidim Un keket oen noan, “Tasao le mi lob-lau nol lilu muun isi kia? Tana-bihatang ni mate loꞌ. Un suma nini tukun.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Oen ming Yesus in aa ela ka kon, oen totoang mail le tao nahmaeng Una. Mo Un tadu atuli las totoang putis. Hidim Un haman nal tana-bihatang nga ina ka nol ama ka, nol Un ima-ii las tilus, le oen taam lakos tana-bihatang na kamar ra. ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kon Yesus kil un se ima ka, hidim Un pake dais Aram le tekan noan, “Talita kum!” (Nahin na noan, “Baat-ana, hangu tia!”) ");
INSERT INTO hegNTpo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Nahkitu lam, tana-bihatang na hangu le lako. Kon Yesus tadu un ina ka noan, “Bel tana ni in kaa tia!” Totoang atuil in net asa man daid son na, ngaa-bahan. Mo Yesus kaing oen mumuun noan, “Mi boel tek atuil deken, noan Auk bel un le nuli pait son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Hidi kon, Yesus nol Un ima-ii las totoang, pait lakos Yesus ingu la, iung Nasaret. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tom nol atuil Yahudi las leol in kohe-kanas, kon Yesus taam lako se um in kohe-kanas sa, le tui atuli. Leol na, atuil in laok kohe-kanas mamo. Dedeng oen ming Yesus in tui ngas sa, oen hera-herang le tek noan, “Atuling ni in tana ki ana loꞌ! Un kon muik kuasa! Tasao le Un tao nal ela lia? ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Molota, Un niam tukang kai tukun. Kit taan Un ina ka, Maria; nol Un palin nas: Yakobus, Yoses, Yudas, nol Simun. Un kon muik palin bihata dehe. Kit taan apa, lole kit totoang niam daad ingu mesa lam!” Tiata oen idus, didiin oen dai hii-ming se Un pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kon Yesus tekas noan, “Meman baktebes! Atuli li kom in todan Ama Lamtua Allah mee-baah man in maa deng iung didang ngas dui, mo in deng ingu mes nol one ngas sam, oen todan isi loꞌ.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Mo atuil nas dalen nas didi isi nol oen dai parsai se Yesus loꞌ. Tiata Un herang, nol Un pake Un kuasa la le tao taad herang mamo se maan na loꞌ. Un suma taih banan atuil in heda ngas at ila lo siis. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Hidi kon, Yesus lako papmes ingu-iung in dadani se na ngas, le tui atuli las deng Ama Lamtua Allah in koma ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Un haman Un ima-ii las hngul duas, le nutus oen laok at dua-dua, halin laok nahdeh atuli las deng Ama Lamtua Allah Dehet Dais Banan na. Un kon beles kuasa le halin oen nulut nal uikjale. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Un tadu oen noan, “Mi boel kil sa-saa mamo se lalan deken. Kil in kaa nol duit nol tas deken tia. Suma kil hnikan nol kado mesa, nol pake nahan. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Eta muik atuli in sium mi se oen uma lam, mi musti daad se na didiin mi bok lakom deng maan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mo eta noan mi lakom lius se mana mesa, hidim atuil in se na ngas sium mi loꞌ, nol dai hii-ming se mi lo kam, haung bokam deng maan na. Hidim sii soleng auh in se mi iin na ngas, nol tekas noan, ‘Mi dai hii-ming lo, ta eta mam Ama Lamtua hukung mia lam, mi lepa-haal esan!’” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hidi na kon, oen lakos nahdeh deng Dehet Dais Banan na. Oen tek atuli las le musti tenes deng oen in kula-sala ngas, halin nuil muid Ama Lamtua Allah in koma-koma ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Oen kon nulut soleng uikjale kas. Hidim oen tao mina se atuil in heda ngas bon, le kohe-kanas bel one. Kon nam oen banan meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Dedeng na, atuli li se ola-ol tuun, taan Yesus son. Lahing Herodes sa kon ming haup dehet deng Yesus in kuasa ka son. Muik atuli deeh tek noan, “Yuhanis in Sarain Atuli man oen keo tele son na, nuli pait son ne Yesus apa ka! Undeng na, le Un tao nal taad herang nas totoang.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mo atuil tenga las tek noan, “Lo! Ni upung Elia man nuli pait son ne Un apa ka. Eta lom, Ama Lamtua Allah mee-baah didang deng lolo hmunan nua ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mo nikit laih Herodes ming oen in dehet deng Yesus ela ka kon, un situs noan, “Taon elola ko, Yuhanis in Sarain Atuli, man lelon auk tadu le dait nutus un bon na ka, nuli pait son nia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Hmunan laih Herodes tadu ela, undeng un muik dais nol Yuhanis. Un dehet ta elia: laih Herodes saap bali un palin Filipus sapa ka, ngala Herodias. Molota, Filipus nol Herodias dai apa lo bii. Undeng na le Yuhanis kaing laih Herodes oe-oe noan, “Ama lahi, boel nuu ama palin na sapa ka deken. Ta na kaliut kit hadat Yahudi la son!” Mo ela kon no, lahing Herodes sa saap nol bihatang na. Hidim un tadu atuli laok daek Yuhanis le tamang lako se bui dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Undeng Yuhanis kaing tutungus ela son, tiata bihatang na pesang dael nolan, hidim un le keo tele Yuhanis. Mo haup dola lo bii kam, Herodes tahang Yuhanis son se bui dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hidim un tadu tentara las le doh Yuhanis babanan. Meman Herodes tiud Yuhanis. Un tana noan, Ama Lamtua Allah man nutus Yuhanis. Nol Yuhanis nam atuil banan. Herodes kon kom in ming Yuhanis nahdehe. Mo opa-opan nam, un dalen na banan nol in ming Yuhanis in nahdehe ka lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hidi na kon, oe mesan na, ina Herodias haup dola le balas un dalen in ili ka. Dedeng na, oen tao laih Herodes leol in hua ka. Oen haep atuil tene kas le maa kaa se fesat na. Haep in maa ngas, atuil pamarenta, tulu deng tentara las, nol blalan-blalan hadat Galilea las. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Se fesat ta hlala kon, ina Herodias ana bihata la tama lako tidan. Un in tidan na leok isiꞌ, didiin tao Herodes nol un haep pas totoang dalen kolo. Kon Herodes haman un le keket noan, “Ku kom le nodan saa deng au lam, tek tuun lako! Tiam auk bel kun. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ku nodan auk maan in duka-aa ki apa halin kon, auk bel kun. Auk sumpa nini Ama Lamtua Allah ngala ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kon nam tana-bihatang na lako keket un ina ka noan, “Mama! Maam nataka kam, auk nodan saa man banan dui deng papa la?” Kon un ina ka situn noan, “Ku laok nodan nal Yuhanis bon na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hidi na kon, tana-bihatang na hlalapat lako se Herodes le tekan noan, “Papa! Auk nodan le kil bel auk Yuhanis bon na, taon se dulang dalen. Nol ni tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nikit Herodes ming ela kon, un dalen iil isi. Mo un pel pait nal un in sumpa ka lo son, lole haep pas totoang ming son nam. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hidi kon, un lok tulu deng tentara las at mesa, le laok dait nutus Yuhanis bon na se bui dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kon oen dait nal Yuhanis bon na, hidim taon se dulang dalen, le nolan laok bel tana-bihata nga. Tana-bihatang na sium nal dulang na kon, un totan nolan laok bel un ina ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nikit Yuhanis ima-ii las ming noan, oen dait lai-niin Yuhanis bon na son kon, oen laok kat un nitun na, le laok puan babanan. Dehet deng Yuhanis in mate ka, ela. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Oe mesan na, Yesus ima-ii man Un nutus son nas totoang pait, le lakos nakbua nol Una. Oen tek totoang asa man oen in daek son nas, nol asa man oen in tui son bel atuli la ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mo oras na, atuli mamo isi lako-pait le nuting Yesus. Didiin Un nol Un ima-ii las, kaa nal bahan lo. Kon nam Yesus tek Un ima-ii las noan, “Maa le kit laok nuting mana mesa, man muik atuil lo, le kit teen in kae buit se na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tiata oen totoang sakes lui dapas, le lakos nuting maan in muik atuil loꞌ, katang deng ingu la. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mo atuli mamo ngat net Yesus nol Un ima-ii las bes oen lui la muid tubu suut ta. Kon nam oen putis deng ingu-ingu las, le laok muid lalan tuu tuun, tiata oen lakos lius muna Yesus nol Un ima-ii las. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nikit Yesus niu deng lui la kon, Un ngat tam atuli mamo natang Una. Tiata Un dalen kasiang nol one, lole oen banansila el lae-blai man muik atuil in lolo-poa lo ka. Hidi kon Un tui oen deng Ama Lamtua Allah in koma ka, ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","deng lelo ditu lako pes lelo-maun. Kon Un ima-ii las tekan noan, “Papa! Banan dui ka Paap tadu atuil nias totoang, le laok sos in kaa se ingu-iung man in dadani deng ia ngas. Ta le duman son nian, nol muik in kaa ne ni lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mo Yesus situs noan, “Deken! Mi man beles in kaa.” Mo oen keket bali pait noan, “Inah! Eta kaim pal in bel atuil hut mamo nias in kaa kam, kaim musti puting duit mamo isi! Banansila el tukang mes gaji taun mes dalen! Taon elol le kaim haup duit mamo nas sa!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kon Yesus situs noan, “Mi laok keket muna, le asii kil in kaa ka.” Tiata oen lakos keket, hidim oen pait maas le tek noan, “Muik ruti bua lim nol ikan dua siis.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kon nam Yesus tadu atuli las totoang le daad nakbua se bluan na dapas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ti oen lakos daad nakbua. Oen daad nakbua atuli at ngatus-ngatus, nol tenga las at buklima-buklima. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hidi nam, Yesus kat ruti bua lim nas nol ikan dua nas. Un ngada lako el apan nua, le nodan mamo se Ama Lamtua Allah. Hidim Un bilas-bilas ruti las, le bel Un ima-ii las, halin oen laok bating bel atuil hut mamo nas. Un beles ikan dua nas le laok bating bel atuli las kon. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Oen totoang kaa didiin silis. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kaa hidi kam, Un ima-ii las kat nakbuan in kaa lisin nas, inu fuli hngul dua. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nataka le atuli at lihu lima. Nas halas-sam kaih biklobe las siis na. Mo kaih bihata las nol tana-ana ngas lo bii. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hidi kon, Yesus tadu Un ima-ii las saek lui, le lakos muna se iung Betsaida, ne tubu ka halin. Mo Un dada nabael se na, le tadu atuil hut mamo kas pait. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nikit oen totoang pait tukun nam, Un saek lako leten mesa, le kohe-kanas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Duman son mo Yesus sii nabael se la. Un ngat tam Un ima-ii las lui la, lako lius ne tubu hlala son. Mo oen tuku-bes bosor isi, lole lui la lail saol angin nam. Nukneha sain halas-sam, Yesus lako muid one. Mo Un laok tuun deng ui dapa. Un laok sipan lui la kon, oen ngat net Una. Oen nahkiut isiꞌ. Tiata oen keket apa noan, “Hoe! Asa nua, baos te?” Mo Yesus tekas noan, “Hoe! Mi lii deken! Ta ni Au.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yesus sake lako lui dapa kon, angin na ete meman. Un ima-ii las totoang herang. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Oen halas-sam net Yesus in pake Un kuasa la le nalo atuli lihu lim lisi ka. Mo oen taan batur Un in kuasa ka lo bii, undeng oen dalen nas didi nabale. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Oras Yesus nol Un ima-ii las lakos lius se tubu halin na ka, oen nauh oen lui la se kota Genesaret onan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nikit oen nius deng lui la dapas kon, atuli mamo ngat net one. Hidim atuil mamo nas haman tek noan, “Hoe! Yesus maa son nuan!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Kon oen totoang lail putis lakos tek papmes atuli las, tiata atuli las dohang nol atuil in ili ngas maas. Eta oen ming noan, Yesus ne mana mesa lam, oen leo-leo dohang nol atuil in ili ngas, le laok nenes se las. Oen nangan noan, “Sadi atuil ili koed-ngasing nas, huud tom Un kai-batu las mumu ka tuun kon, oen banan.” Tiata nikit oen huud tom Yesus kaod mumu ka kon, oen banan meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Muik atuil Farisi bua mesa, nol guru agama deeh maas deng Yerusalem le tutnaal Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Atuil Farisi nas kil didi oen hadat Yahudi la. Naleta el, eta oen le kaa lam, musti haun iman muid oen hadat ta in koma ka. Ela kon, eta pait deng pasar ram, oen musti dius muna le. Lako pes oen sa-saa dapur ras, el mulu, pingas, klas, ceret, musti bases muding hadat ta in koma ka muna le, halas-sam oen boel pakes le kaa-niun nini. Eta muik atuil Yahudi teng muid hadat na lo kam, atuil Farisi las koon-mali. Undeng na le, oen koon nas mali, nikit oen net Yesus ima-ii las kaa, mo haun iman nas muid hadat ta lo. Hidi kon, oen maas le bel kula Yesus noan, “Tasao le ku anam mias haun iman lo kia? Oen kaliut kit upu kia-kaon nas hadat ta son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Mo Yesus situs noan, “Mi niam meman atuil man aa kam kisa, mo dake lam kisa! Lolo hmunan nu upung Yesaya dul meman son deng Ama Lamtua Allah in teka ka, noan, ‘Muik atuli in naka Au, suma baha ka sii, mo dalen na lo. Oen tao ela kon parsum tukun. Oen hosek nol Auk in koma ka lo, mo oen suma muid atuli in koma tuun.’ Mi banansila ela kon. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Mi nang soleng Ama Lamtua Allah in koma ka, le daek muid hadat deng atuli li tukun. Meman mi taan isi in tao ela! ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Hmunan nua, upung Musa tek son noan, Ama Lamtua Allah prenta le, ‘Todan mi ina-aman nas.’ Hidim un tek taplaeng pait noan, ‘Eta noan atuli mes lote un ama ka, tamlom ina ka lam, musti hukung tele.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Ama Lamtua Allah tui ela. Mo mi tui kisa, mi tek noan, ‘Eta atuli mes hid son le bel Ama Lamtua Allah sa-saa mesa lam, un ina-aman nas tuka-dabun isi elol kon no, un boel pake sa-saa in bele na, le hulung oen deken, undeng un hid hidi son le bel Ama Lamtua Allah.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Undeng na, le apin Auk tek mi son noan, mi soleng Ama Lamtua Allah in koma ka, le seda nini atorang balu. Nol muik atorang mamo son, man mi sedas ela.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hidi kon, Yesus haman atuil didang in se la ngas, le tekas noan, “Tidi mi hngilan nas le hii babanan, halin mi tana. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Asa man tama lako el tain dalen, tao hmomos atuli li lo. Mo asa man puti deng atuli li bahan na, man tao hmomos una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Asii man muik hngila kam, hii babanan!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hidim Yesus nol Un ima-ii las, lakos nang soleng atuli las, le taam lakos se uma mesa. Kon Un ima-ii las keket deng kleta na nahin na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yesus situs noan, “Mi kon tanan lo ke? Un nahin na elia: Asa man atuli li kaan, na banan. Mo asa man in puit deng atuli lia ka, man banan lo. Asa man kit kaan na, tama lako kit tain, hidim puti pait. (Yesus in teka na nahin na elia; atuli boel kaa saa tuun. Muik in kaing lo). ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Asa man puti deng atuli li dalen na ka, man tao hmomos una, didiin Ama Lamtua Allah kon nikis una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ta muik dais daat mamo putis deng atuli li dalen nia! Tuladang el: nangan dadaat, laok kula nol bihata tam biklobe molota oen saap lo bii, nako, keo atuli, ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kom naseke, nonga, daek dadaat, nole-lilung, tahang nal apa lo, idus, kilaꞌ, dehet le tao nahu atuli, koaok, hadat lo, nol bon batu. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Totoang in daat ela ngas, man putis deng atuli li dalen. Na man tao didaan una. Ama Lamtua Allah kon nikis una.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Hidi kon, Yesus nol atuil in muid Una ngas bokas deng maan na, le lakos se kota mesa, ngala Tirus. Nikit oen lakos lius se las kon, oen taam lakos se uma mesa, undeng Yesus kom atuli in taan noan, Un maa ne maan na lo. Mo Un huni nal lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Se maan na, muik bihata mesa man atuil Yahudi lo. Hua un se dale Fenisia, ne propinsi Siria. Nikit un ming Yesus in maa ka kon, un lako nodan Yesus le nulut puting uikjale ka deng un ana bihata la. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mo Yesus soleng dais noan, “Tana-ana ngas musti kaa muna le, halas-sam soleng lisin na bel ngot tas.” Na nahin in buni. Mo un nahin esa ka noan, Yesus musti hulung Un atulin Yahudi las muna le, halas-sam hulung atuil Yahudi lo kas lolen. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mo blalan bihatang na siut noan, “Baktebes Papa! Mo ngot tas ne mija kloma ka. Tiata oen kon kaa in naih deng tana-ana ngas pingas sa ngas.” Nahin na noan, oras tana-ana ngas kaa lam, ngot tas kon haup in kaa. Tiata Yesus hulung Un atulin nas, mo Un kon musti ngat atuil didang. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ming ela kon, Yesus tek noan, “Ela! Maam siut toman son na! Tiata maam pait tia, ta uikjale ka puti deng maam ana ka son.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tukun nam bihatang na pait. Lako lius se uma kam, un ana ka niin nala. Nol uikjale ka puti baktebes son. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Hidi na kon, Yesus nol atuil in muid Una ngas nang soleng kota Tirus, le laok muid tasi suut tuun deng kota Sidon. Deng na, oen lakos napiut se tubu Galileas. Hidim oen lakos se mana mesa man muik kota hngulu, maan na oen noken ‘Dekapolis’. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Se maan na, muik atuli mes ngengo nol kiu. Un tapan nas kil nolan lako bel Yesus. Oen nodan le Yesus nene Un ima ka laok se atuling na bon na, le tao banan una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kon Yesus nang soleng atuil hut mamo kas, le lako sii nol atuling na. Yesus tao tamang hnanga ka se atuling na hngila kas duas. Hidim Un tao kapen se hnanga ka, le kapas atuling na meen na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesus ngada lako el apan nua, le pel hngasa ka bablatas, hidim Un prenta noan, “Efata!”, (nahin na noan, “Hosai tia!”) ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yesus prenta ela tuun nam, atuling na hngila ka hosai le ming nala. Nol un meen in kalkait ta kon, alet meman, le aa nala. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hidi kon, oen duas pait lakos se atuil hut mamo kas. Yesus kaing oen noan, “Hii babanan! Mi boel tek atuli las deng Auk in tao banan atuling ni son na deken.” Yesus kaing mumuun ela kon no, oen totoang lakos nahdeh se ola-ola. ");
INSERT INTO hegNTpo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Atuli-atuil in ming dehet na ngas, herang isi. Hidim oen tek noan, “Muun isi! Atuling ni tao totoang sa-saa lias daid banan. Atuil kiu kas ming nala, nol atuil ngengo kas kon aa nala.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Oe mesan na pait, muik atuli mamo maas nakbua le hii-ming se Yesus. Oen muid Un lelo tiul son, tiata oen muik in kaa lo son. Kon Yesus haman Un ima-ii las, le tekas noan, “Auk namnau atuil hut mamo nias son. Tenga las maas deng maan katang. Oen maas nakbua lelo tiul son. Tiata oen muik in kaa lo son. Banan dui ka, oen pait nol tain blo deken. Ta lo kam, eta hmatu nalas sam, oen leas se lalan nua.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yesus ima-ii las siut noan, “Papa. Maan ni katang deng ingu las son. Tiata kit bel nal atuil hut mamo nias in kaa lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mo Yesus keket oen noan, “Mi muik ruti ila la?” Oen situn noan, “Papa, kaim pesang ruti suma bua iut siis.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hidi kon Yesus tadu atuli las totoang le daad se dale ka. Kon Un kat ruti bua iut nas, le nodan mamo se Ama Lamtua Allah. Hidim Un bilas-bilas ruti nas, le beles laok se Un ima-ii las. Kon oen laok bating bel atuli las totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Oen kon muik ikan dehe. Tiata Yesus nodan mamo se Ama Lamtua Allah taung ikan nas. Hidim Un tadu Un ima-ii las, le laok bating ikan nas bel atuli las pait. ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Oen totoang atuli lihu aat. Oen kaa didiin silis. Kaa hidi kon, Yesus ima-ii las laok kat nakbua in kaa lisin nas, inu popos itu. Hidi na lam, Yesus tadu atuli las totoang pait. ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Oen pait hidi totoang son kon, Yesus nol Un ima-ii las, saek lakos lui dapas, le lakos se mana mesa, ngala Dalmanuta. ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nikit Yesus nol Un ima-ii las lakos lius se Dalmanutas kon, muik atuli at ila lo deng partei agama Farisi, maas tutnaal nol Una. Oen keket-ketan nol Una, le noan tao nahu Una. Oen nodan Un noan, “Papa! Tulu bel kaim taad herang, le halin daid tada noan, meman Ku haup kuasa deng Ama Lamtua Allah.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kon Yesus pel hngasa ka le tekas noan, “Eta Auk ming mi in aa ela kam, Auk maingasar! Tasao le mi nodan taad herang ela lia? Mi talalun! Taad herang meman muki, mo Auk kom in tulu bel mia lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hidi nam, Yesus nang soleng one, le lako sake pait se lui dapa, leo-leo nol Un ima-ii las. Kon oen pait bus el tubu halin nua. ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesus nol Un ima-ii las lakos lius se tubu hlala halas-sam, Un ima-ii las nangan net noan, oen nadidingun in kil ruti taung in kaa se lalan. Oen suma kil ruti bua mes sii. ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kon Yesus tekas noan, “Mi musti doha-doha! Boel tom lahing Herodes sa nol atuil Farisi las in tui dadaat ta deken. Oen in tui ka, banansila el bibit ruti man atuli li kutang nol tarigu le tao hus ruti ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ming Un aa ela kon, Un ima-ii las nangan tanan lo. Tiata oen aa nol apa noan, “Blalan na aa saa na le? Bet Un aa ela, lole kit kil ruti lo kam.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mo Yesus taan oen in nangan na. Tiata Un tekas noan, “Tasao le mi suma taan in aa deng ruti sii kia! Mi daek haup Auk in teka ki lo ke? Meman mi ngengom baktetebes! ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mi ngat net nol mi matan nas esan son, mo taan un nahin na loo kia! Hnika ka noan mi net lo! Mi ming nol mi hngilan nas esan son, mo mi nangan tanan lo nabale. Hnika ka le mi ming lo! Mi nadidingun ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ruti bua lim man, Auk bilas-bilas le nalo atuli lihu lima ka le? Leol neot na, mi kat nakbuan ruti lisin nas fuli bakun ne?” Oen situn noan, “Fuli hngul dua, Papa.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesus keket oen pait noan, “Mi nangan net neot na, Auk bilas-bilas ruti bua iut le nalo atuli lihu aat ta nabale tam? Mi kat nakbuan ruti lisin nas popos ila le?” Oen situn noan, “Popos itu Papa!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kon Yesus tekas noan, “Meman baktebes! Mi net nol matan esan son, mo tasao le mi taan Auk in kuasa ki deng ol maa ka lo nabale lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hidi deng maan na, Yesus nol ima-ii las lakos lius se iung Betsaidas. Lius se luas kon, atuli las pel nol atuling tedo mes laok bel Yesus. Oen nodan le Yesus huud atuling tedo na, halin un banan. ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tiata Yesus pel atuling tedo na se ima ka, le nolan lako se ingu la likun na. Un puut kapen laok se atuling na mata ka, hidim kapas atuling na mata ka, le keket noan, “Elola? Ku ngat net son ne?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Atuling na nikit sila ka, le ngat kliu-kanan, hidim siut noan, “Hao! Auk ngat net atuli las lako. Mo ngat tam hbabut nabale banansila el kai ina ngas man lako!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tiata Yesus tapa Un ima ka pait lako se atuling na mata ka. Kon atuling na ngat soba-naan pait tam, un mata ka banan baktetebes son. Un ngat net nol langa son. ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kon Yesus tadu atuling na le pait, hidim hidan noan, “Ku pait tia, mo muid lalan didang! Pait lako Betsaida deken tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Hidi na kon, Yesus nol atuil in muid Una ngas laok papmes ingu-iung in se Kaisarea Filipi ngas. Se lalan hlala kam, Yesus keket oen noan, “Eta muding atuli las in nahdehe kam, oen tek noan Auk niam mo asii la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Oen situn noan, “Tenga las tek noan, ‘Yuhanis in Sarain Atuli ka.’ Nol tengas tek noan, ‘Upung Elia’, Ama Lamtua Allah mee-baah lolo hmunan nua ka. Mo tenga las pait tam, tek noan, Paap niam, at mes deng Ama Lamtua Allah mee-baah hmuna-hmunan nuas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kon Yesus keket pait noan, “Mo muid mia lam, Auk niam mo asii la?” Petrus situn noan, “Paap niam mo Kristus! Man Ama Lamtua Allah tulu meman son, deng lolo hmunan nua ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mo Yesus kaing oen noan, “Mi boel tek atuil deken ne!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hidi deng na kon, Yesus tek Un ima-ii las noan, “Auk niam, Atuling Baktetebes sa. Nesang lo kam, Auk haup in susa-daat mamo, undeng blalan hadat tas, nol tulu agama las tene-tenen nas, nol guru agama las totoang hutun soleng Au. Mam oen keo tele Au. Mo bingin dua ka lam, Auk nuling pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus tek langa-langa ela, kon Petrus pel nodat Un deng atuil hut mamo kas le kaing noan, “Papa boel aa ela deken! Auk nang oen le iman saek Paap lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mo Petrus in aa ela ka, muid Ama Lamtua in koma ka lo. Kon Yesus bali lis le ngat Un ima-ii tenga las. Hidim Un kaing Petrus mumuun noan, “Hoe! Ku in aa na, uikjale kas laih tuan na in aa! Laok norat tobo-dolan nia! Ku suma nangan atuli li in koma tuun, mo nangan Ama Lamtua Allah in koma ka lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hidi kon, Yesus haman atuil tenga las le maa nakbuan nol Un ima-ii las. Hidim Un tui oen noan, “Asii man kom le muid Au lam, un musti tahang, le muid Auk lelo-lelon! Un musti nadidingun soleng un in koma-koma ngas, le muid se Ama Lamtua Allah in koma ka sii. Atuli le keo un kon no, un musti muid napiut tuun, banansila el atuli haal un kai sangsuli la, le laok mate. ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ta atuil in suma nuli taung un apa ka sii, mam un in nuli ka ilang tuun ela! Mo atuil man tade le mate, undeng un in muid Au, tamlom undeng un in bani-bating Ama Lamtua lalan in nuli ka ka, mam un haup in nuli napiut nol Ama Lamtua. ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Hii ke! Eta ku haup apan-kloma ki isin ni totoang, mo Ama Lamtua Allah hutun soleng ku lam, ku in ontong ngi saa la? ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ku kat lai-niin apan-kloma ki isin ni totoang kon, bisa seda nal ku hmangim ma lo! ");
INSERT INTO hegNTpo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nangan ne! Halas ni atuil apan-kloma ki in daat ta bili-ngala. Oen toe muid Ama Lamtua lo. Tiata eta asii mae in muid Au, tamlom mae in kil Auk in tui ngas sam, mam Auk kon mae in hao un se Ama Lamtua Allah sila-mata ka. Ta Au, Atuling Baktetebes sia, mam Auk pait maang deng sorgang. Nol Ama Lamtua ima-ii in deng sorga ngas kon maas leo-leo nol Au. Kaim niu maang deng sorgang nini Auk Amang nga in kuasa man loe-liliman na, halas-sam atuli li taan noan, Auk niam mo asii. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mi nadidingun Auk in teka ni deken. Muik atuli deeh deng mi nias totoang, mates lo didiin ngat net Ama Lamtua Allah in kil prenta nini kuasa tene ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Hidi nal lelo eneng kon, Yesus nodan Petrus, Yakobus, nol Yuhanis, le oen leo-leo nol Un saek lakos se leten lapa tene mes dapas, man muik atuil lo. Nikit oen saek lakos lius se dapas kon, oen ngat tam Yesus daid kisa son. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nol Un kai-batu las daid muti kaloeꞌ. Se apan-kloma ki muik sa-saa man muti dui deng Un kai-batu las lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nahkitu lam, oen ngat net Yesus nahdeh nol upung Elia nol upung Musa. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Oen tilus lii naseke, didiin Petrus nangan hapun lo tiata un aa dadahut in aa. Un tek Yesus noan, “Papa! Kaim nataka kam, se niam leok isi! Tiata banan dui ka, kaim koet hlepe tilu. Mes bel Papa, mes bel upung Musa, nol mes pait bel upung Elia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kon nopen na niu maa kabut nal oen tilus. Hidim oen ming fala puit deng nopen na, tek noan, “Hii ke! Yesus niam, Auk anang in namnau ka. Mi musti hii babanan se Una!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nikit Petrus nol at dua las ming faal na kon, oen ngat pukiu, mo nahkitu lam, oen ngat net atuil didang lo son. Suma Yesus sii. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hidi na kon, Yesus nol Un ima-ii at tiul nas, nius deng leten na. Yesus hidas noan, “Asa man mi in neta apin na, boel nahdeh atuil deken. Ta Auk niam, Atuling Baktetebes sa, Auk musti mateng muna. Le Auk nuling pait son, halas-sam mi nahdeh atuli.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Oen kil babanan Yesus in hida na, le tek atuil lo. Mo oen tilus keket apa noan, “Un aa noan, Un le ‘nuli pait deng Un in mate ka’, na nahin na elola le?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kon oen keket Un noan, “Guru agama las tek noan, ‘Upung Elia musti maa muna le, halas-sam Kristus maa.’ Mo muid Papa lam, elola?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus situs noan, “Meman baktebes. Upung Elia musti maa muna le sai lalan bel Kristus, Atuling man Ama Lamtua Allah tulu meman son, lolo hmunan nua ka. Mo elola? Ne Ama Lamtua Allah Buk Niu ka, oen dul son deng Atuling Baktetebes sa, mo mi tanan lo bii ke? Ta oen dul meman son noan, eta Un maa son nam, atuli tao sus Una, didiin oen keo tele Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mo mi musti tidi hngilan nas le hii babanan! Upung Elia meman maa son. Mo atuli tao sus una, muid oen in koma ka. Na kon tom nol asa man kit upun nas in dul meman son, lolo hmunan nua ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Oras Yesus nol Un ima-ii at tilu las, maas tutnaal pait nol Un ima-ii tenga las sa, oen ngat net atuli mamo maas nakbua. Atuil hut mamo nas maas le ngat Yesus ima-ii tenga las in kaen nol guru agama las sa. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nikit atuil hut mamo kas ngat net Yesus, kon oen nahkitu, lole oen bali le Un bii ne leten nu dapa nabale. Hidim oen lail lakos el Una la. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kon Yesus keket oen noan, “Mi kaen apa nol asa la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kon nam atuli mes tekan noan, “Papa! Auk kil nol auk anang biklobe li mo nia, le Paap tao banan una. Un ngengo, aa taan lo, lole un tom uikjale. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Eta uikjale na tama son nam, un late apa ka lako se dale ka. Hidim un baha ka bulat, nol un duu siin na. Hidi nam un apa ka kalkait banansila el kai ka. Auk nodan Paap ima-ii las son, le nulut soleng uikjale nia, mo oen nulut bolen lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ming ela kon, Yesus naskaa oen noan, “Hoe! Mi lail-lisin son! Auk tui mi oe-oe son, mo mi taan lo bii nababael tuun. Nol mi kon parsai baktetebes se Auk lo! Auk musti tahang nol mi didiin bling pait ta! Kil nol tana-ana na maa se nia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kon oen kok nol tana-ana na lako bel Yesus. Mo nikit uikjale ka ngat net Yesus kon, un late tana-ana na didiin lulin-lulin se dale ka, nol baha ka bulat. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kon Yesus keket tana-ana na ama ka noan, “Ku anam mi in daid elia ki, lolo blingan son na?” Un siut noan, “Lolo ana blutu bii kua. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Uikjale na le tao tele un bablaan son. Un tao nahu auk anang ngi oe-oe lako se ai dalen, nol tao mele un se ui dalen. Tiata Paap tulung kaim le! Eta bole lam, Paap namnau kami, le tao banan auk anang ngi tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus situn noan, “Tasao le ku tek noan, ‘eta bole’ lia? Meman Auk daek nal nas totoang, sadi atuli li musti parsai muna le!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kon nam blalan na siut nol in le lilu tetetas noan, “Papa! Meman Auk parsai son! Mo tulung le halin Auk in parsai ki didi dui pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dedeng na, Yesus ngat tam atuli mamo maas nakbua se maan na son. Kon Un prenta uikjale ka noan, “Hoe! Uikjale daat! Puti deng tana-ana ni tia, le halin un ming, nol aa tana. Ku boel taam pait lako se un lo ka!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ming Yesus in tek ela ka kon, uikjale ka ahan mumuun. Un tao tana na le lea hukun-hukun se dale ka, halas-sam un puti nang soleng tana na. Kon nam tana na banansila el mate son. Didiin atuil in se na ngas, tek apa noan, “Inaa! Un mate son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mo Yesus kil tana na se ima ka, le tiun bangun. Kon un hangu dil meman. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hidi kon Yesus nol Un ima-ii las nang soleng maan na, le lakos tamas se uma mesa. Lius se las kon oen keket Yesus noan, “Papa! Tasao le apin kaim nulut soleng nal uikjale na lo kia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesus situs noan, “Hii babanan ne! Uikjale kas meman daat isi. Tiata, eta mi kohe-kanas le nodan in hulung se Ama Lamtua lo kam, mi nulut soleng nal uikjale tuladang ela ka lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Hidi na kon, Yesus nol Un ima-ii las, nang soleng maan na, le taam lakos el propinsi Galilea. Dedeng na, Yesus kom atuli in taan noan, Un maa ne maan na lo, ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","undeng Un suma le tui Un ima-ii las siis. Un tek oen noan, “Nesang lo ka kam, oen hee soleng Auk lakong se atuil daat tas. Hidim oen keo tele Au, Atuling Baktetebes sia. Meman Auk mateng, mo bingin dua ka lam, Auk nuling pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yesus tek ela, mo Un ima-ii las, nangan taan Un in teka na lo. Mo oen kon brain in ketan Yesus lo, noan Un in aa na nahin na elola. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hidi na kon, Yesus nol Un ima-ii las lakos lius se kota Kapernaum. Dedeng oen taam lakos uma dales sa, Yesus keket oen noan, “Apin mi kaen apa saa se lalan nua lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mo muik at mes in brain siut Una lo, lole apin se lalan nua ka oen kaen apa noan, asii man tene dui deng oen totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kon nam Yesus daad le tui oen noan, “Asii man kom le daid atuil tene kam, un in nuli ka musti daid baktetebes el atuil ana ka, le lii-lau totoang atuli lia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hidim Yesus kok nal tana-ana mes se na, le lako dil se oen hlala ka. Un tekas noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Asii man muid Au, le lii-lau atuil ana ngas, banansila el lii-lau tana-ana blutu nia ka, nahin na noan, atuling na kon lii-lau Au. Nol un kon lii-lau Auk Amang ngua, man nutus Auk maang se apan-kloma kia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Hidi nam, at mes deng Yesus ima-ii las, man ngaal Yuhanis sa tek noan, “Papa! Oe mesan na, kaim net atuling mes pake Paap ngala ka, le nulut uikjale. Mo kaim kaing una, lole un nam kit atulin lo kam.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mo Yesus siut noan, “Hoe! Mi kaing un deken. Ta asii man pake Auk ngalang ngia, le tao taad herang ngam, taon elola ko un aa didaan Auk ngalang ngi lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Eta un labang nol kit lo kam, nahin na noan un nam kit atulin. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nangan babanan ne! Eta muik atuli mes taan noan, mi muid Kristus, tiata un tulung mia lam, taon elola ko Ama Lamtua Allah nadidingun atuling na in susa-kae ka lo. Un suma bel mi ui in ninu klas mes sii kon no, Ama Lamtua Allah nadidingun un lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Hidi nam Yesus tek oen pait noan, “Eta muik atuli tao tana-ana mes le un lako-daek muid in kula-sala ka, didiin tana-ana na parsai se Auk lo kam, doha lo! In banan dui taung atuling na ka, eta kat baut tene mesa, le butun laok se un leo ka, hidim laok sao se tasi hlala kua. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Eta ku tao kula-sala nini ku imam halin na lam, dait soleng tuun! Ta ku taam lako sorga nol ku imam halin na sii kam, banan dui deng, oen soleng tamang ku lako ai naraka dalen nol ku imam mas duas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Naraka la, meman maan in susa-daat. Ai in ne na ka mate taan lo. Nol ulas in ne a ngas kon, teen tahan in tao didaan sa-saa ka lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Eta ku tao kula-sala nini ku iim halin na lam, dait soleng tuun! Ta ku taam lako sorga nol ku iim halin na sii kam, banan dui deng, oen soleng tamang ku lako ai naraka dalen nol ku iim mas duas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Naraka la, meman maan in susa-daat. Ai in ne na ka mate taan lo. Nol ulas in ne a ngas kon, teen tahan in tao didaan sa-saa ka lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Eta ku tao kula-sala nini ku matam halin na lam, sukin soleng tuun! Ta ku taam lako sorga nol ku matam halin na sii kam, banan dui deng, oen soleng tamang ku lako ai naraka dalen nol ku matam mas duas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Naraka la, meman maan in susa-daat. Ai in ne na ka mate taan lo. Nol ulas in ne a ngas kon, teen tahan in tao didaan sa-saa ka lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Auk in tui-tikang ni meman ngele. Ta asii man kom le muid Au lam, un musti tahang le muid tutungus, banansila el atuli lain sisi, hidim laen sila, le hodat laok se ai halin nam sisi la tahang nesang. ");
INSERT INTO hegNTpo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sila li niam, banan. Kit pake le tao mingis in kaa. Mo eta sil na milu lo son nam, un ambak ki saa la? Muik ambak lo son. Mi kon musti daid tuladang el sila ka, le nuil neka-namnau apa nol atuli li totoang. Tiata, mi teen in kaen apa noan, asii man tene dui, tam asii man ana dui ka tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Hidi kon, Yesus nol Un ima-ii las lakos se propinsi Yudea, nol mana-maan didang in se palun Yordan halin leol-saken na ngas. Se ola-ol tuun kon atuli mamo maas nakbua nol Yesus. Tiata el in biasa ka, Un tui one. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Muik atuil Farisi deeh maas le noan tao nahu Yesus. Oen keket noan, “Muid kit atoran agama lia lam, eta biklobe mes saap son nam, un boel in dai tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus situs noan, “Nangan napat le! Atoran in sapa man upung Musa in bel kita ka elola la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Oen situn noan, “Upung Musa atorang nga tek noan, biklobe li bisa dai, sadi bel surat in dai se un sapa-bihatan na muna le.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus situs noan, “Hoe! Hii ke! Undeng mi bon batu, tiata upung Musa dul ela! ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mo nadidingun dehet laih hmunan hesa ku Ama Lamtua Allah in koet apan-dapa kua, nol apan-kloma kia ka deken! Muik in dula noan, ‘Ama Lamtua Allah koet atuli li, biklobe nol bihata. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Undeng na, le biklobe li nang un ina ka nol un ama ka, le lako nuli koo-dalen mes nol un sapa-bihatan na, ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","lole oen duas daid mes son.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Eta Ama Lamtua Allah esa taos le daid mes son nam, atuli li boel sis bating duas deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hidi nam, Yesus nol ima-ii las siis taam lakos se uma mesa. Se na, oen ketan Yesus in tui apin na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus situs noan, “Asii man dai soleng un sapa-bihatan na, hidim saap pait tam, na nong son na! ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bihata li kon ela! Eta un dai soleng un sapa-bikloben na, hidim un saap pait tam, na kon nong son na!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Oe mesan na, atuli las kil nol oen anan nas laok bel Yesus, le nodan Un halin beles hangun. Mo Yesus ima-ii las kaing atuli las. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nikit Yesus ngat net Un ima-ii las in tao ela ka kon, Un ngau one, noan, “Nang tana-ana ngas le maas el Au lia! Kaing oen deken! Ta atuil in banansila el tana-ana nia ngas sa, Ama Lamtua Allah nenan. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mi nangan babanan! Atuil in kom le maa saol Ama Lamtua Allah ka, oen musti kom isi le net Una, banansila el tana-ana ngas in nangan isi le tutnaal nol oen ina-aman nas sa. Etan ela lo kam, oen haup in daid Ama Lamtua Allah atulin lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hidi na kon, Yesus neok tana-ana ngas, le nene ima ka laok se oen mesa-mesa, hidim beles hangun. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dedeng Yesus nol atuil in muid Una ngas mana le lakos deng maan na kon, muik atuil in muki mes lail maa tutnaal nol Yesus. Un hai buku ka se Yesus sila ka, hidim un keket noan, “Ama Guru man in todan dui! Auk le keket bubuit. Elia Ama, auk tao elol le halin nam auk taan baktetebes noan, auk tamang sorgang le nuling leo-leo nol Ama Lamtua Allah tutungus sa?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus situn noan, “Amo tasao le ku noken Auk noan, Ama Guru ‘man in todan dui’ kia? Muik atuil in todan dui mes lo kon, suma Ama Lamtua Allah sii. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ku taan Ama Lamtua Allah atorang deng lolo hmunan nua ka son, man tek noan, ‘Keo atuil deken; Nong deken; Naok deken; Daid saksi in nole-lilung deken; Liun-leo nal atuil le kat lai-niin oen sa-saa las deken; Nol todan ku ina ma nol ku ama ma.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Atuling na situn noan, “Baktebes Ama Guru! Lolo muda bii kua, Auk daek muid atorang nas totoang son.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus kasiang atuling na. Kon Un tekan noan, “Toma! Mo muik dasi mes nabale. Ku pait lako tia, le hee nuli ku hmuki-nalan nas totoang. Hidim un duit ta, ku laok bating bel atuil in tuka-dabun nas. Hidi na halas-sam maa le muid Au. Ta mam Ama Lamtua Allah bel seda ku hmuki-nal didang se sorga.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nikit atuling na ming Yesus in tek ela ka kon, un dalen na daat meman. Hidim un pait nol dalen susa ana lo, undeng un muik isi. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kon Yesus ngat pukiu, hidim tek Un ima-ii las noan, “Hii ke! Meman atuil in muki ngas sus isi in taam sorga!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ming Un aa ela kon, ima-ii las nangan hapun lo. Mo Yesus aa taplaeng pait noan, “Hii babanan! Kom le daid Ama Lamtua Allah atulin nam, susan ana lo! Boel nangan noan kahan tuun deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ta atuil in muki ngas taam lakos sorga le daid Ama Lamtua Allah atulin nam, susan na banansila el hmukit unta tene mes taam lako un okat ta muid laung bolo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesus in teka na, tao oen totoang nangan hapun lo taplaeng. Kon oen keket apa noan, “Eta meman baktebes ela lam, asii man haup in nuli man hidi nutus taan lo ka le?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus ngat oen mesa-mesa, hidim tek noan, “Eta taung atuli lia lam, meman bisan lo. Mo nadidingun deken: ta taung Ama Lamtua Allah lam, totoang nas bisa dadi!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kon nam Petrus nikit in aa noan, “Papa. Kaim nang soleng kaim sa-saa las totoang son le muid Papa. Mo mam kaim haup saa la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesus tek noan, “Auk tek mi elia: atuil man in muid Au, nol nang soleng un ina-aman nas, un kaka-palin nas, un anan nas, un klapa la, un osa la, nol un uma isin nas totoang, le laok nahdeh Ama Lamtua Allah Dehet Dais Banan na se ola-ol tuun na, mam un sium pait oe ngatus. Totoang sa-saa man un in nang soleng son nas, mam un simus pait nol lai-lisi. Ela kon no, mam un haup in diku-puang, undeng un in muid Au ka. Mo etan apan-kloma ki kiamat tam, un nuli leo-leo nol Ama Lamtua Allah tutungus. Un in haup pait ta, ela! ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nangan ne! Asii man nikit-nikit apa ka le daid atuil tene, kam muid Ama Lamtua Allah in nangan na lam, mam un daid atuil ana dui. Mo asii man tao apa ka el atuil ana ka, muid Ama Lamtua Allah in nangan na lam, mam un daid atuil tene dui.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Dedeng na Yesus nol atuil in muid Una ngas lakos bus el Yerusalem. Yesus laok muna se hmunan, hidim Un ima-ii las, halas-sam atuil tenga las laok muid deng klupu. Oen nangan net hmunan nu Un in tek noan, atuli le keo tele Un se Yerusalem ma, tiata Un ima-ii las dalen nas hutlulu, nol atuil in muid one ngas kon lii. Taan ela kon, Yesus haman nal Un ima-ii las siis, le tekas pait deng asa man atuli le tao saol Un se Yerusalem ma. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Un tekas noan, “Mi hii ke! Auk niam, Atuling Baktetebes sa. Kit le lakong el Yerusalem son niang, mo lius se ua ngam, oen hee Auk lakong bel tulu agama las tene-tenen nas nol guru-guru agama las. Hidim oen nutus, le hukung tele Au. Tiata oen sao Auk lakong se atuil man in taan Ama Lamtua Allah lo ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Hidim oen aa le tao nahmaeng Au. Oen puut kapen nol Au. Nol oen kon diku-puang Auk apang ngi dudu-dudus. Hidi halas-sam oen pauk tele Au. Meman Auk mateng baktebes. Mo bingin dua ka lam, Auk nuling pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Hidi kon, Yakobus nol Yuhanis, Sabadeus anan nas maas se Yesus. Oen nodan Un noan, “Paap Guru! Kaim le parlu.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus keket oen noan, “Mi duam le parlu saa la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Oen siut noan, “Elia Papa! Eta Paap daad le kil bandu son nam, kaim nodan le Paap bel kaim duam maan in dada. Mes se Paap halin kanan na, mo mes pait se Paap halin kliu ka, le halin kaim kon kil bandu.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus situs noan, “Mi duam nangan taan asa man mi in nodan ni lo. Mam Auk haup in susa-daat mamo. Tiata elola? Mi bali le mi kon lepa-haal nal in susa-daat na leo-leo nol Auk didiin matem me?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Oen duas situn noan, “Kaim bolen Papa!” Yesus situs pait noan, “Meman mam mi kon haup in susa-daat banansila el Au. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mo mam asii man daad se Auk halin kanan ni nol kliu kia lam, Auk man in nutus lo. Ta in muik hak le nutus ela ka, Ama Lamtua Allah. Un man nutus meman son, le asii man daad se maan nas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nikit ima-ii tenga las, ming Yakobus duas Yuhanis in laok nodan ela ka kon, oen koon-mali isi. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tiata Yesus haman oen totoang le tekas noan, “Elia! Mi tanan son ta lo? Atuil tene man in kil bandu ngas taom tudan-kida oen hutu-atan nas, didiin oen tao nal saa lo. Nol tulu-tulu deng ngala-ngaal man in taan Ama Lamtua Allah lo ngas, oen bel prenta lai-lisin, didiin oen hutu-atan nas nikit nal bon lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mo mi tao ela deken! Eta asii deng mia la kom le daid atuil tene kam, un musti daid banansila el ata ka, le lii-lau atuil tenga las. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nol asii man kom le daid tulu kam, un musti tao apa ka banansila el ata ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ta Au, Atuling Baktetebes sia, maang le atuli li lii-lau Auk lo, molam Auk maang le lii-lau atuil hut mamo kas. Auk maang le bel Auk in nuli ki tetema, halin sui nal atuli mamo deng oen in kula-sala ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kon nam Yesus nol Un ima-ii las, nol atuli hut mamo lakos lius se kota Yerikos. Oras oen in lakos sa, muik atuling tedo mes daad le nodan-nodan se lalan suut ta. Un ngala Bartimeos, ama Timeos ana. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nikit un ming noan, in maa laok deng na ka, Yesus atuling Nasaret ta, kon un haman mumuun noan, “Yesus! Laih Daud in hua-koet te! Auk natang Paap blaan son! Bel ampong auk tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ming un haman ela kon, atuli las kaing un noan, “Hoe! Lobo deken!” Mo un haman mumuun dui pait noan, “Yesus! Laih Daud in hua-koet! Bel ampong auk tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tiata Yesus tene. Kon Un tek noan, “Kil nol un maa se nia!” Kon oen laok tek atuling tedo ka noan, “Ku lobo bakun na! Ta Paap Guru haman ku son nuan. Maa tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ming ela kon, Bartimeos pasang soleng un seman na, hidim un lalaba tuun hangu dili, ta oen pel nolan lako se Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus keket un noan, “Ku kom saa le?” Atuling tedo ka situn noan, “Papa! Auk nodan le auk ngat neta.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus tekan pait noan, “Undeng ku parsai noan Auk tao banan nal ku, tiata nol ni kon, ku banan tia! Lako tia!” Kon Bartimeos mata ka banan meman. Hidi nam, un kon lako muid Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nikit oen lakos dadani kota Yerusalem, lius se ingu dua ngalan, Betfage nol Betania, ne leten Saitun na, kon Yesus nol Un ima-ii las tenes bubuit. Hidim Un tadu Un ima-ii las at dua le lakos muna. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Un hidas noan, “Mi duam laok muna se iung nua. Eta mi taam lakom mam, mi net keledai ana mes butun. Atuli saek netan lo bii. Mi laok loat un tali la, le pel nolan maa se nia. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mo etan muik atuli keket mi noan, ‘Tasao le mi loat keledai na lia?’ Lam mi siut noan, ‘Kaim Lamtuan nu le pake una. Eta Un pake hidi son nam, Un tunang pait meman.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hidi kon atuil dua nas lakos, kon oen ngat net keledai ana na butun se uma mes hnitan, se lalan suut ta. Ta oen loat le kil nolan lako bel Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mo atuil in dil se na ngas keket noan, “Hoe! Tasao le mi loat atuli keledai kia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kon oen duas siut noan, “Kaim Lamtuan nu le pake. Eta pake hidi son nam, kaim pel nolan pait maa meman.” Kon atuli las nang oen le pel lai-niin keledai ana na lako. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Oen pel nolan lako bel Yesus. Hidim oen lekat oen seman nas laok se keledai blepo ka, le Yesus saken. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dedeng oen le taam lakos el kota la ka, muik atuli mamo kat oen seman nas, nol oen hlendang ngas, le lekat se lalan na. Atuil tenga las lakos dait kai klehen muda, le hehan laok se lalan hlala ka. Nini ela lam oen tulu bel noan, oen sodo-sium Lamtua Yesus nol in todan, banansila el taom oen in sodo-sium atuil tene ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hidim muik atuli teng pait lakos muna Yesus se hmunan, nol tenga las pait muid deng klupu. Oen nakaa mumuun le tek noan, “Hosana! Kit naka-nahalit Ama Lamtua Allah! Hangun banan bating atuil man in maa nini Ama Lamtua ngala ka! ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hosana! Kit naka-nahalit Ama Lamtua Allah! Undeng Ama Lamtua le bangun pait Laih Daud in prenta ka! Hosana! Kit naka-nahalit Ama Lamtua Allah! Undeng Ama Lamtua kil bandu meman son, ne apan-dapa man lapa dudui kua!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Lakos lius se kota dalen kon, Yesus nol Un ima-ii las taam lakos se Ama Lamtua Allah Um in Kohe-Kanas Tene ka kintal la. Kon Yesus ngat pukiu kintal la babanan. Mo undeng muik oras lo son, tiata oen pait lakos iung Betanias. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ola ka ohkaong bii kon, oen putis deng Betanias le taam lakos pait bus el kota Yerusalem. Mo se lalan hlala kam, Yesus lubu. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kam Un ngat net kai ina mes se lalan suut ta. Atuli taom kaa un isin na. Tiata Yesus lako dadani le ngat naan kai na muik isin tam lo ka. Mo Un lako lius kai ina na lam, Un ngat net kai isin mes lo kon. Ta le meman kai ina na oras in isin lo bii, un halas-sam klehen tukun. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kon Yesus tek kai ina na noan, “Undeng ku muik isin taung Auk lo, tiata deng leol neot nia, ku boel isin bel atuil didang pait lo ka!” Un ima-ii las ming Un in bahang kai ina na ela ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hidi na lam oen laok napiut lakos luis se Yerusalem, kon Yesus taam lako pait se Ama Lamtua Allah Um in Kohe-Kanas Tene ka. Se Um na kintal la, atuli las taon daid maan in sosa-hee son, le hee tiul-tuan, man taom atuli pake taung in tunu-dadung se oras in kohe-kanas. Net ela kon, Yesus laok nulut puting one. Un late soleng mija-mija man oen pakes le silin nini duit tas. Nol late bali bangku-bangku man oen pakes le hee kee se na ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Un kon kaing atuli las totoang, le boel kil sa-saa in hee maa laok deng kintal la pait lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hidim Un tui oen noan, “Mi taan asa man Ama Lamtua mee-baha la in dul son noan, ‘Auk bangun-pii Auk Uma lia, le halin atuli-atuil deng nusa ngias totoang maa le kohe-kanas se nia.’ Mo mi tao Um ni daid atuil in nako ngas maan in nakbua lolen son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Dedeng tulu agama Yahudi las tene-tenen nas, nol guru-guru agama las ming Yesus in tao ela ka, kon oen kom Un lo isi. Tiata oen mulai nuting lalan le keo tele Una. Mo oen siin-tidu, lole atuil hut mamo kas kom isi nol Yesus in tui-tikang nga. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lelo la le dene kon, Yesus nol Un ima-ii las putis deng kota Yerusalem, le pait lakos ninis se iung Betanias. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Ola oskaong bii kon, oen pait lakos bus el Yerusalem. Oen maa lakos deng kai man lahin Yesus in bahang nga. Kon Un ima-ii las herang, undeng kai ina na tuu-tanga son lako pes un klaput tas. Ti Petrus nangan net Yesus in aa lahin na. Tiata un tek noan, “Papa! Ngat le! Kai man lahin Paap in bahang nga, mate son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus situs noan, “Meman toma! Tiata sadi mi parsai baktetebes se Ama Lamtua Allah! ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ta eta mi parsai ela lam, mi tadu nal leten mes le hoboka lako se tasi kua, sadi mi parsai tailuang tuun lo! Mo mi musti parsai baktetebes se Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nadidingun lo koo! Sadi mi parsai baktetebes noan Ama Lamtua Allah bel nal asa man mi in nodan na lam, Un tao bel mi ela! ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mo eta muik atuli in kohe-kanas, molota un dalen na banan isi lo nol atuil didang ngam, un musti babanan nol atuling na muna le. Ela halas-sam, mi Aman in ne sorga ku kom le kose soleng mi in kula-sala ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Eta deng mia li muik in pesang dale, nol dai bel ampong atuil didang lo kam, mi Aman in ne sorga ku kon nadidingun mi in kula-sala ngas lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Hidi kon, oen lakos napiut. Lakos lius se Yerusalem kon, oen taam lakos pait se Ama Lamtua Allah Um in Kohe-Kanas Tene ka. Oras oen taam lakos se kintal la ka, tulu agama Yahudi las tene-tenen nas, guru-guru agama las, nol blalan-blalan hadat Yahudi las maas, ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","le keket Yesus noan, “Lahin sii man tadu ku maa tao lobo-lau se ni lia? Nol sii man bel ku hak ka!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mo Yesus taan son noan oen nuting lalan le tao nahu Una. Tiata Un situs noan, “Auk kon le keket mia. Mi siut Auk muna le, halas-sam Auk siut mia. ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Auk in keket ti elia: mi totoang taan Yuhanis in Sarain Atuli ka ta lo? Asii man tadu un laok sarain atuli lia? Ama Lamtua Allah tam, atuli lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kon oen huli-bali lako-pait, ti oen nangan noan, “Inah! Kit toman son nia! Eta kit siut noan, ‘Ama Lamtua Allah man tadu’, kam Un siut noan, ‘Eta ela lam, tasao le mi parsai Yuhanis lo kia?’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mo kit kon bisa siut lo noan, ‘Atuli li man tadu.’ Ta lo kam atulis totoang hangus keng nol kita. Lole oen parsai noan Yuhanis nam mo, Ama Lamtua Allah mee-baha.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tiata oen siut Un tuun noan, “Kaim tanan lo!” Kon Yesus siut balis noan, “Eta ela lam, Auk kon tek mi lo noan, asii man tadu Au lia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Hidi na kon, Yesus tek tapnaeng tulu agama Yahudi las tene-tenen nas, guru-guru agama las, nol blalan-blalan hadat agama Yahudi las pait. Mo Un pake kleta noan, “Muik atuli mes lako dait klapa, le mul kai anggor se klaap na. Hidim un paah pukiun, nol un daek bak le taung in lita anggor isin na uin na. Un kon daek hlopong in doha mesa. Hidim un seb klaap na bel atuil didang, le maa liam oen bating apa klaap na in hapu ka. Mo un boka lako nusa didang. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lius oras in nui anggor isin kon, klapa lamtua ka tadu un atuil in loka ngas at mes lako se atuil in daek klapa la ngas, le nodan un nenang nga. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mo nikit un lako lius kon, atuil in dake ngas daek una, le diku-papas una. Hidi nam oen tadu un pait nol kil saa lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kon klaap lamtua ka tadu un atuil in loka ngas at mes pait. Mo atuil in dake ngas diuk un bon na didiin papa sii. Hidim oen tao nahmaeng una, nol nulut soleng una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tiata klaap lamtua ka tadu un atulin in loka mes didang pait. Mo oen keo tele atuling na. Oen tao ela kon no, klaap lamtua ka taan in tunang un atulin in loka ngas tutungus le lako. Mo atuil in dake ngas, diuk-papas tenga las, nol keo tenga. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ti suma liis atuli mes sii son. Na klaap lamtua ka ana bikloeb siing man un neka-namnaun isi ka. Undeng muik lalan didang pait lo son, tiata un tadu se un ana ka lolen. Lole Un nangan noan, ‘Eta auk tadu auk anang ngi esa kam, taon elola kon oen simun nol babanan, hidim hii-ming se una.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tiata un tadu un ana ka lako se ua. Mo nikit atuil in dake ngas ngat net un ana ka maa kon, oen tek apa noan, ‘Hoe! Mi ngat le! Blalan na tadu un ana ka esa maa son nuan! Eta blalan na mate kam, un man sium blalan na pusaka las totoang. Tiata maa le kit keo tele una, le halin kit man haup un pusaka lias!’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kon oen leo-leo daek un le keo tele. Hidim oen pasang soleng un nitun na lako se klapa la likun na. Kleta ka lako pes ela.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Hidi nam Yesus keket atuil tene kas noan, “Muid mi in nangan na lam, nataka le klaap lamtua ka tao saa nol atuil in dake ngas sa? Muid Auk in nangan nia lam, taon elola ko un maa keo tele atuil in dake ngas totoang. Le hidim un seb klaap anggor na bel atuil didang. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kit totoang les net deng Ama Lamtua Allah Buk Niu ka son noan, ‘Muik batu mes man tukang ngas nikit soleng son. Mo halas nia lam, baut na daid baut in tian. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ama Lamtua Allah esa man huil baut na le todo. Tiata kit ngat una lam leko ana lo!’” ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Atuil tene nas tanan meman son noan, Yesus in naleta na hai bus one. Undeng oen banansila el atuil in daek klaap anggor ra ngas. Tiata oen nuting lalan le daek Una. Mo oen lii-tiud nol atuil hut mamo man kom isi le hii Yesus in tui-tikang ngas. Tiata oen lakos nang soleng Un tuun ela. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hidi na kon, atuil Yahudi las tenen nas, tadu atuil Farisi dehe, nol atuil deng Herodes partei la, le laok keket-ketan nol Yesus, halin kiu nahu Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tiata oen lakos le keket-ketan nol Yesus noan, “Ama Guru! Kaim totoang tana noan Ama dalen na lolo, nol nole-lilung taan lo. Ama ngat atuli li dalen nia, nol huil sila lo. Ama kon tek Ama Lamtua Allah in koma ka langa-langa. Tiata, kaim le keket dasi mesa. Muid kit atoran agama Yahudi lia lam, nataka le kit musti baen bea bel pamarenta Roma la laih tuan na, tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mo Yesus taan son noan oen le kiu nahu Una, le halin Un aa labang nol pamarenta Roma la. Tiata Yesus situs mumuun noan, “Tasao le mi tao nahu Auk nini dais na lia! Olan bel Auk duit muti mesa!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kon nam oen tunang bel Un duit muti mesa. Yesus kat duit na le tinang. Hidim Un keket oen noan, “Hdulat ni asii sila ka? Nol ni sii ngala ka?” Oen situn noan, “Na pamarenta Roma la laih tuan na!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kon Yesus tekas noan, “Etan ela lam, mi laok bel pamarenta la asa man pamarenta nena. Mo bel Ama Lamtua Allah asa man Ama Lamtua Allah nena.” Ming Un siut ela kon, oen totoang hera-herang, lole Un in situ na tom isi. Tiata oen kiu nahu nal Un lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Muik partei agama didang mes pait, man atuli noken noan partei Saduki. Oen tui noan, atuil in mate ngas nulis pait lo ka. Oe mesan na, atuil Saduki at ila lo kon maas le noan tao nahu Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Oen tek Yesus noan, “Paap Guru! Upung Musa dul pesang bel kit hadat ni noan: eta muik biklobe mes mate nang soleng un sapa ka, mo muik ana lo kam, biklobeng na palin na musti saap nol bebalu na, le halin nam hua bel un kaka in maet son na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Meman upung Musa tui ela. Mo kaim le keket bubuit elia: muik biklobe itu, oen kaka-pali. Bikloeb hmunan na saap bihatang mes muna, hidi kon un mate, mo muik ana lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kon un palin in muid una ka, saap nol bebalu na lolen. Nesang lo kon, un kon mate mo haup ana lo. Ela kon nol palin nomer tilu la; un saap nol bebalu na. Mo un mate kon nol muik ana lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ela tutungus didiin lako lius palin hmudin esa ka, un kon mate mo muik ana lo. Hidi halas-sam bebalu na mate. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ta kaim le keket elia: bihatang na saap nol bikloeb iut nas son! Mo eta apan-kloma ki kiamat le Ama Lamtua Allah tao atuil in mate ngas nulis pait tam, deng atuil at iut nas ol man daid bihatang na sapa ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kon Yesus situs noan, “Eta mi keket ela lam, nahin na noan mi nangan taan babanan Ama Lamtua Allah in Dula Niu ka, isin na lo. Mi kon nangan taan Ama Lamtua Allah in kuasa ka lo. Tiata mi kula baktetebes son! ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Hii ke! Se sorga lam muik in sapa lo. Totoang atuil in mate man Ama Lamtua Allah in bel nuli pait tas, muik in sapa lo. Ela kon nol Ama Lamtua Allah ima-ii in deng sorga ngas, oen kon saap lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Auk kon le tek mi deng atuil in mate ngas nulis pait, tam lo ka. Upung Musa man dul deng kai ina ana mes man ai kaan, mo hnining lo ka. Mi nangan net dehet na tam lo ka? Dedeng ai la kaa loe se kai na ka, Ama Lamtua Allah tek Musa noan, ‘Auk niam ku upu kia-kaon nas Lamtuan. Na upung Abraham, upung Isak, nol upung Yakob. Oen todan-lahing Auk tutungus maa pes halas nia.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kit tanan son noan, blalan nas mates blaan son. Mo undeng Ama Lamtua Allah tek son noan, ‘Un daid oen Lamtuan maa pes halas nia’, tiata kit taan noan, oen nulis. Lole suma atuil in nuli ngas siis man todan-lahing se Ama Lamtua Allah, mo atuil in maet son nas lo, ta lo? Ta atuli li mate kon no, oen haup in nuli pait. Tiata eta mi kil napiut in tui-tikang man noan, atuil in mate ngas nulis pait lo kam, meman mi kula talalun son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Dedeng na, muik guru agama mes daad le hii Yesus in dehet nol atuil deng partei Saduki ngas. Guru agama na nangan noan, Yesus siut oen in keket ta nol babanan son. Hidi kon un ketan Yesus noan, “Papa! Auk le keket elia: kit hadat ti atorang nga, nol agama li in prenta ngas mamo naseke. Tiata deng totoang prenta man in maa deng upung Musa ngas, ol man muun dui la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus situn noan, “Prenta man in muun dui ne Ama Lamtua Buk Niu ka ka, lin na elia: ‘Totoang atuil in se Israel me! Hii-ming babanan ne! Ama Lamtua Allah nam mo, meman kit Lamtuan, nol Un nam mo kit Tuang! Muik didang pait lo, suma Un sii! ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tiata mi musti namnau Una, dui hihidi deng totoang. Mi musti nangan net Un tutungus, taan Una, nol daek mumuun le muid Un in koma ka.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nol prenta mesan na pait, elia: ‘Ku musti namnau atuil didang, banansila el ku in namnau ku apam ma esa ka.’ Prenta dua nias man muun dui. Muik prenta didang pait man muun dui deng prenta dua nias lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kon guru agama na keket Yesus pait noan, “Meman asa man Paap in teka ka, toma. Ama Lamtua Allah nam kit Lamtuan, nol muik Lamtua didang pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kit musti namnau Un dui hihidi deng totoang. Hidim kit musti nangan net Un tutungus, taan Una, nol daek mumuun le muid Un in koma ka. Nol kit kon musti namnau atuil didang, banansila el kit namnau kit apan ni esa ka. Eta kit tao ela lam, Ama Lamtua Allah dalen kolo dui deng, in suma tao muid atorang agama lias tuun na. Nol in tao ela ka kon, banan dui deng eta kit suma tuun hmukit in tunu-dadung bel Una, tamlom bel Un sa-saa didang nga.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ming un siut ela kon, Yesus nangan noan guru agamang na nangan taan nol babanan son. Tiata Yesus tekan noan, “Ku dani in daid Ama Lamtua Allah atulin son.” Hidi deng na la, muik atuil didang man in barain le keket-ketan nol Yesus pait lo son, undeng muik in nal Una lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hidi na kon, Yesus tui atuli las nabael se Ama Lamtua Um in Kohe-kanas Tene ka. Kon Un keket oen noan, “Muid mi in nangan nam, elola? Guru agama las tui noan, Ama Lamtua Allah tulu Kristus meman son deng lolo hmunan nua. Nol muding one lam, Un nam suma daid deng laih Daud in hua-koet tuun. Mo na tom lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Lole hmunan nu, Ama Lamtua Allah Koo Niu ka pake laih Daud son le dul noan, ‘Ama Lamtua Allah tek auk Lamtuan na noan, “Maa le daad se maan in todan dui kia, se Auk halin kanan nia. Mam Auk tao Ku musu las, didiin oen suda muid se Ku.” ’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","Deng na, kit tana noan, laih Daud esa noken Kristus sam ‘Lamtua’. Nahin na noan, eta atuli tek le Kristus nam suma laih Daud in hua-koet tuun nam, na tom lo! Undeng Un nam kon, laih Daud Lamtuan.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Nikit Yesus aa ela kon, atuil hut mamo kas kom isi le hii-ming se Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kon Un tek oen pait noan, “Mi musti doha-doh nol guru agama las. Oen kom in pake kaod blatas pel-koos, le lako-pait tutnaal atuli hut mamo, halin atuli las ngat net one lam tek noan, ‘Oee! Oen nam atuil tene mo!’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Eta oen taam lakos se um in kohe-kanas sas, tamlom oen laok muid fesat tam, oen nuting maan in dada man banan dui ngas, le halin atuli hut mamo ngat net one. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mo doha-doha lo! Ta oen nole-lilung bebalu kas tutungus, le naok nal oen uma las. Mo se atuil hut mamo sila kam, oen buni oen in daat na, nini in dil le nodan nesang-nesang. Oen kom le atuli noken oen noan, atuil dael niu. Mo mam Ama Lamtua Allah hukung oen ngele dui.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Hidi na kon, Yesus lako daad saol kaban derma in se Ama Lamtua Allah Um in Kohe-kanas Tene ka ka. Un ngat atuli las maas tamang duit kolete laok se kaban na. Un net atuil in muki ngas kon maas tamang duit mamo-mamo se na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mo muik bihaat bebalu kasiang mes kon maa muid le kohe-kanas. Un tamang duit seng dua se kaban na. Duit na osa ka ana dui. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kon Yesus laeh Un ima-ii las, le tekas noan, “Mi ngat babanan bebalung kasiang nia. Un tamang duit seng dua siis, mo un in bele ka mamo dui deng atuli las totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta atuil las tamang duit kolete deng oen duit lisin nas. Mo bebalu kasiang nia lam, un bel nuli un duit tas totoang son, bel Ama Lamtua Allah.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Hidi na kon, Yesus nol Un ima-ii las lakos nang soleng Um in Kohe-kanas Tene ka. Se oras oen in puit lakos sa, ima-ii las at mes tulu Um in Kohe-kanas sa, le tek noan, “Papa! Olan Paap ngat ti le! Um ni leko ana lo! Oen toed baut tene kias leko-leko!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mo Yesus situn noan, “Um ni meman leko ana lo! Mo nesang lo kam, oen tao lean nuli baut nias totoang.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Hidi kon, Yesus nol atuil in muid Una ngas lakos se leten Saitun nua, le oen daad se maan in saol nol Um in Kohe-kanas Tene ka. Kon nam Un ima-ii las at aat maas, le oen siis nahdeh nol Una. Atuil at aat nas, Petrus, Yakobus, Yuhanis, nol Anderias. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Oen keket Un noan, “Papa! Olan tek ulang Paap in aa apin na le. Bling halas-sam dedeng na maa lisu la? Nol un tada-tada las elola la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kon Yesus situs noan, “Sadi mi doh babanan le tom in nole-lilung deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ta mam muik atuli mamo maas teh kalas, le tek noan, ‘Auk niam Kristus, Atuling man Ama Lamtua Allah tulu meman son deng lolo hmunan nua ka’. Hidim oen kon nole-lilung atuli mamo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Eta mi net atuli hote-dait apa, tamlom mi ming dehet noan, muik in hote-dait apa ne ola-ola lam, lii deken. Ta in banansila ela ngas musti daid muna, mo leol kiamat ta maa lius lo bii. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mam ngala mes hote-dait nol ngaal tenga las. Nusa mes kon hote-dait nol nusang tenga las. Muik lul-beko se ola-ola. Oras lubu ka kon muun isi! Nias totoang daid tada-taad banansila el bihata in tain iil le hua ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Tiata, mi musti doh babanan ne! Ta mam oen maa daek mi le pel nol mi lakom se maan in nehan dais agama ngas. Nol oen diku-puang mi se uma-um in kohe-kanas sas dalen. Hidim oen kon but mi le kil nol mi lakom se atuil in kil prenta ngas, undeng mi in muid Au kia. Mo mi pake dola na, le halin nahdeh oen deng Au. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ta Ama Lamtua atulin nas musti laok tek Auk Dehet Dais Banan nia, bel totoang ngaal in ne apan-kloma ki ngias muna le, halas-sam leol kiamat ta maa. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nangan noo! Eta oen but mi le kil nol mi lakom se maan in nehan dasi ngas sam, mi nangan le lii deken noan, ‘Hidim auk aa elola? Tamlom, auk siut elola?’ Ta eta un oras sa maa lius son nam, mi aa muid asa man Ama Lamtua Allah Koo Niu ka, in tek mia ka tukun. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Eta se um-elan mes dalen atuli mes parsai se Au lam, mam un kaak-palin nas esan nuting lalan le keo una. Nol eta ana mes parsai se Au lam, un ama ka esa man keo una. Ela kon, eta ina-ama deeh parsai se Au lam, mam oen anan nas esan man keo one. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tiata mam atuli las kom mi lo isi, undeng mi in parsai se Au ka. Mo eta asii tahang nal deng nas totoang ngam, taon elol kon Ama Lamtua Allah bel boa-blingin una.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesus aa napiut noan, “Mam atuling in daat isi mes le maa. Un boel dil se maan in luli deng Ama Lamtua Allah Um in Kohe-kanas Tene ka lo, mo un lako dil se la, didiin tao hmomos maan na. Tiata Ama Lamtua Allah bali kudi nang soleng maan na. Eta mi ngat net ela son nam, doha-doha loo! (Asii man les nia lam, un kon musti doha-doha!) Ni daid tada noan, lelo-leol in susa ngas maas dadani son. Etan net ela son nam, atuil in ne propinsi Yudea ngas haung lalim lakom leten nuas tia. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Musti lail laba-laba, le halin tom in susa-daat tas deken. Eta muik in puti deng uma la son nam, boel pait laok kat sa-saa bakun tia. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ela kon nol atuil in ne klapa la ngas, boel pait laok kat seman otot bakun na. Molam lail napiut tia! ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","In bosor dui ka, bihaat in behe ngas, nol ina-in man nusu tana-ana blutu mea ngas. Undeng oen lail nal hlapat lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tiata banan dui ka, mi kohe-kanas le nodan halin leol in susa-daat nas, nahis tom oras oe-haat deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ta leol nas sus isi! Kilan deng Ama Lamtua Allah in koet apan-kloma kia, maa lius halas nia, atuli ngat net in susa tuladang ela lo bii. Nol mam atuli kon ngat net in susa tuladang ela pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Eta Ama Lamtua tao dadaen lelo-leol in susa ngas lo kam, mam muik atuli mes lo kon man tahang nal le nuli. Mo undeng Ama Lamtua Allah namnau Un atulin man Un huil nal son nas, tiata Un tao lelo-leol in susa ngas dadaen tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Eta leol nas maas lius son nam, mi ming atuli las aa noan, ‘Hoe, Kristus muik ne nia!’ Mo atuil tenga las tek noan, ‘Kristus muik ne nua!’ Mo mi boel hii oen deken! ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ta mam muik atuli in puit le teh kalas noan, ‘Auk niam Kristus!’ Atuil tenga las pait tek noan, ‘Auk niam, Ama Lamtua Allah mee-baha.’ Mam oen tao taad herang bili-ngala nini uikjale kas in kuasa ka, le nole-lilung atuli lia. Oen kon soba-naan le nole Ama Lamtua Allah atulin nas! ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mo mi musti doh babanan ne! Ta leol in susa ngas maa lius lo bii, mo Auk tek nuting mi meman son!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Hidi kon Yesus aa napiut le tek Un ima-ii las noan, “Eta lelo-leol in susa ngas hidis son nam, ‘Mam lelo la daid mitang, bulan na kon langa lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Duun nas nahis deng apan-dapa kua, nol kuasa in ne apan-dapa ku nguas daid dahut-dahut sii.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Hidi na halas-sam, atuli las totoang ngat net Au, Atuling Baktetebes sia. Mam Auk maang deng apan-dapa kua. Nol totoang atuli li ngat net Auk in kuasa ka, nol Auk in loe-liliman na! ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hidim Auk tadu Ama Lamtua Allah ima-ii in ne sorga nguas, le laok tao nakbuan totoang atuil man Auk in huil nal son, deng papmes apan-kloma ki ngias. Deng leol-saken lako pes leol-denen; deng blai-ahen lako pes loet-ahen.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesus nahdeh napiut noan, “Auk kat kleta deng kai ina mesa. Eta un klehen na kunis son nam, na daid tada noan, oras ehe ka maa dadani son. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ela kon, eta mi ngat net lelo-leol in susa ngas maas son nam, na banansila el asa man apin Auk in tek mi son na, na daid tada noan, Auk in maa ka dadani son. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mi hii babanan ne! Mam deng totoang atuil in nuil hahalas nia ngas, muik deeh mates lo bii, mo lelo-leol in susa ngas maas lius son. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Apan-dapa ku nol apan-kloma ki ilang kon no, Auk in teka ni tahang napiut hidi nutus taan lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesus aa taplaeng noan, “Muik atuli mes lo kon man taan lelon tam oras Auk in pait maa ka. Ama Lamtua Allah ima-ii in ne sorga nguas kon, tanan lo. Auk esang kon, tanan lo. Suma Auk Amang ngu sii, man tanan. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tiata mi musti doha-doh babanan, undeng mi taan lo, le bling un oras sa maa lisu. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nesang lo ka kam Auk lakong nang mia, mo mam Auk pait maang pait. Banansila el um lamtua mes nang soleng un uma la, le bok lako nusa katang. Un tadu un atulin in loka-loka ngas le mana-koet un uma la babanan. Nol un bating bel oen mesa-mesam nol oen osa. Un hid atuil in doh hnita ka ngas le doh babanan, didiin un pait maa. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mi kon musti doh duman-lelo, undeng mi taan um lamtua ka in pait blinga ka lo. Taan le un pait lelo-maun tam, bingin-tai tam, lelo tam, oras lelo sake ko, mi tanan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tamlom mo un maa nahkiut tuun, ti un haup mi ninim nakeo-dadale lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tiata, asa man Auk in tek mi nia, Auk tek atuil tenga las totoang ela kon, noan, ‘Mi musti doh babanan le sodo-sium Auk in pait maa kia!’” Lamtua Yesus in dehet nol Un ima-ii las se leten Saitun na ka, lako pes ela. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Mo oras na kon, tulu agama Yahudi las tene-tenen nas nol guru agama las nuting lalan nabael le daek Lamtua Yesus nol ete-ete. Undeng oen le keo tele Una. Mo oen tek apa noan, “Tahang le! Kit daek Un nol ni deken le, ta lelo-leol tene kas maas dani son. Lo kam, tam atuil hut mamo kas haung keng nol kita la.” Oen aa ela, lole nate lelo dua lam, atuil Yahudi las lelo-leol tene man oen noken noan, ‘Leol Paska’ nol ‘Fesat Ruti in Pake Bibit Lo’ ka maa lisu. Se lelo-leol tene nas oen nangan net hmunan nu oras oen upu kia-kaon nas in putis deng dale Mesir ra. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Se iung Betania, muik atuling mes ngala Simun. Hmunan nu atuli las nikis una, undeng un muik iil baih-bluku. Mo halas ni un banan son. Oras lelo-leol tene kas maas lius lo bii kam, Yesus nol Un ima-ii las lakos kaa se Simun uma. Oen kaa mamasu lam, muik bihatang mes maa tutnaal nol Yesus. Un kil botor mes daken deng batu. Botor na isin na mina bui bingis man osa isiꞌ. Bihatang na diuk tehen botor ra leo ka. Hidim un doan mina ka halin noh buit-buit se Yesus bon na, le daid tada noan un todan Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mo muik atuil didang at ila lo kon kaa leo-leo se na. Nikit oen ngat net bihatang na in tao ela ka kon, oen kom lo le tek noan, “Inah! Bihaat saa ni le un soleng parsum mina bui bingis man osa isi ni lia! ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Banan dui ka un hee mina na, le laok bating duit mamo nas bel atuil kasiang ngas! Ta mina bui bingis na osa ka banansila el atuli mes gaji taun mesa.” Hidi nam oen kaing bihatang na mumuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mo Yesus situs noan, “Mi boel tao sus bihatang ni deken! Nang le un tao ela! Ta Auk daleng kolo undeng un doan mina bui bingis ni se Auk apang ngia. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Atuil kasiang ngas leo-leo nol mi tutungus. Tiata mi bisa tulung oen bling tukun. Mo eta Au lam, nesang lo ka kam, Auk leo-leo nol mi lo son. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Auk in nuli ki nesang lo son. Nol bihatang ni in doan mina apin na ka, banansila el un hising rampe meman son se Auk nitung ngia. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nangan babanan! Ta mam Ama Lamtua Allah Dehet Dais Banan na holhising se ola-ola tuun papmes apan-kloma kia lam, oen kon dehet deng bihatang ni in banan na, le halin atuli li totoang nangan net una.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Hidi kon, at mes deng Yesus ima-ii las hngul duas, lako nuting tulu agama Yahudi las tene-tenen nas. Un ngala Yudas Iskariot. Un le hee soleng Yesus bel one. Un lako lius se one la kon un dehet beles un in nangan na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nikit tene-tene nas ming Yudas tek ela kon, oen dalen kolo isiꞌ. Oen hidan noan, “Eta ku kom le hee Yesus bel kami lam, taon elola ko kaim baen ku.” Hidi kon Yudas puti, le un nuting lalan halin sao Yesus lako bel one. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hidi nam, Yesus ima-ii las maas keket Un noan, “Papa! Leol neot ti, kit leol tene Paska la. Tiata, Paap kom le kaim laok ator maan taung fesat Paska se ola la?” Lole neot na, leol partaam deng atuil Yahudi las leol tene kas. Taom se leol na lam, oen hopong ruti in kutang bibit lo, nol keo lae-blai ana. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kon nam Yesus tadu Un ima-ii las at dua noan, “Mi lakom muna se kota lua. Lius se ua mam, mi tutnaal biklobe mes haal ui se tunis ana mesa. Mi laok mudin. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Eta un tama lako se um ola lam, mi laok muid un se na. Hidim tek um lamtua ka noan, ‘Ama! Kaim Paap Guru nodan mana mesa, le pake taung in tao fesat Paska leo-leo nol Un ima-ii las.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hidim atuling na tulu bel mi maan tene mesa, se un uma la hnoden dapa ka. Un mana hidi maan na son, lisi ka suma mi duam laok mana-koet in kaa se na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kon nam, oen duas lakos se kota la. Se na, oen tutnaal totoang asa man Yesus in tek oen son nas. Oen duas mana-koet in kaa-ninu le halin nam Yesus nol oen kaa fesat Paska se na. Hidi halas-sam oen laok tek Yesus nol ima-ii tenga las. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lelo la mana le dene kon, Yesus nol Un ima-ii at hngul dua kas lakos se um na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hidim oen daad le kaa leo-leo. Oen kaa mamasu lam, Yesus tekas noan, “Mi hii napat le! Mam muik atuli at mes deng mia li hee soleng Auk lakong bel atuil in kom Auk lo ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ming ela kon, oen dalen nas banan isi lo. Oen mesa-mesam keket Yesus noan, “Atuling man Paap in teka na, auk lo, ta lo?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus situs noan, “Atuling man dopon un ruti la tama lako se mako ni leo-leo nol Au ka, man mam hee soleng Au. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nangan ne! Au, Atuling Baktetebes sia, musti mateng banansila el oen in dul meman son ne Ama Lamtua Allah Buk Niu ka ka. Mo doha! Atuling man in le hee Au ka, mam un haup in susa-daat! Banan dui ka, un ina ka huan deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Oen kaa mamasu lam Yesus kat ruti bua mesa, le nodan mamo se Ama Lamtua Allah. Hidim Un bilas-bilas ruti na, le tunang bel Un ima-ii las. Un tekas noan, “Ruti ni Auk apang nga. Kata, le kaa tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Hidi nam, Un nikit klas man in nisi anggor uin na, le nodan mamo se Ama Lamtua Allah. Hidim Un tunang klas na bel Un ima-ii las, le oen ninu. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Un tekas noan, “Anggor ni, Auk dalang nga. Mam daal ni holbohon, le bel boa-blingin atuli hut mamo. Daal ni daid tada noan, asa man Ama Lamtua Allah in hid meman son na, halas ni dadi. Tiata kata, le niun tia. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Hii babanan ne! Kilan deng duman nia, Auk niun anggor uin pait lo ka. Didiin Auk daad le kil bandu leo-leo nol Auk Amang ngu se sorga, halas-sam Auk niun pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hidi na kon, oen tao dani mesa le naka-nahalit Ama Lamtua Allah. Hidim oen putis duman-duman le lakos leten Saitun nua. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Dedeng oen in lakos sa, Yesus tekas meman noan, “Duman ni mi totoang lalim nang soleng Au, banansila el in dul meman son ne Ama Lamtua Allah Buk Niu ka noan, ‘Mam Ama Lamtua Allah tao tele atuling in lolo-poa ka, hidim un lae-blai las lalis holhising.’ ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Meman Auk mateng, mo eta mam Auk nuling pait tam, Auk lakong muna mi se propinsi Galilea.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ela kon no, Petrus kaen noan, “Papa! Atuil tengas totoang lalis nang soleng Paap kon no, auk laling lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus situn noan, “Petrus! Nangan ne! Duman ni manu tukluin oe dua lo bii kon, mo ku kaen Auk oe tiul son noan, ku taan Auk lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mo Petrus situn nol mumuun noan, “Lo Papa! Eta Paap mate kam, auk kon mateng leo-leo nol Papa. Mo auk lail nang soleng Paap lo, nol kaen Paap lo!” Petrus tapan tenga las kon mesa-mesam kaen ela. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hidi na kon, Yesus nol Un ima-ii las lakos napiut le lius se klapa mesa, ne leten Saitun na. Klaap na ngala, ‘Getsemani’. Kon Un tek oen noan, “Mi daad natang se nia le. Ta Auk le lakong kohe-kanas se nua.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kon Yesus haman nal Petrus, Yakobus, nol Yuhanis, le lakos leo-leo nol Una. Kilan deng oras na kon, Yesus nataka kam ngele isi nol Un dalen na susa. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Un tek oen noan, “Auk daleng ngi sus isi! Auk nataka kam, banansila el Auk le mateng tetetas. Mi daad le doh se nia le.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Kon Un keko lako katang dui bubuit, le hai buku ka laok se dale ka, hidim kohe-kanas noan, “Papa boa-ili! Eta Paap tade kam, Auk lepa-haal in susa-daat ni didiin mateng eli deken tia. Auk tanan meman son noan, Paap daek nal asa tukun. Tiata eta bole lam, Paap kat soleng in susa ni katang deng Auk tia. Mo muid Auk in koma ka deken; muid se Paap in koma ka tukun.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hidi na lam, Un pait lako Un ima-ii at tilu las, mo oen niin nalas. Un buk-bangun one, le tek Petrus noan, “Hoe Petrus! Ku nini ke? Auk lakong se na ka suma nanapat tuun, mo mi doh nal bubuit lo kon nia! ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Maid mi matan nas, le langa. Hidim hangu, le doh nol Au! Mi dalen nas meman kom in daek banan, mo mi aap-sisin nas bloen. Tiata, banan dui ka mi kohe-kanas, le halin eta tom in sukat-soba kam, mi nahim deken.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hidi nam, Yesus lako kohe-kanas oe mes pait. Un nodan pait se Ama Lamtua, le halin nang Un lepa-haal in susa-daat na deken. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Hidim Un pait lako se Un ima-ii at tilu las. Mo oen ninis pait son, lole oen matan nas ngele isiꞌ. Tiata Un buk-bangun oen pait, hidim kaing one, mo oen siut nal Un lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hidi na pait tam, Yesus nang soleng oen le lako kohe-kanas lalis tilu la. Hidim Un pait le buk-bangun one. Un tekas noan, “Mi ninim pait nabale le? Nol tia! Hangu! Ta atuling in le hee Au, Atuling Baktetebes nia ki, maa dani son. Oen le daek Au, le bel Auk lakong se atuil daat tas iman. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Hoe hangum tia! Bela mi matan nas le ngat laok elu le! Atuling in le hee soleng Au ka, maa son nuan. Maa le kit laok tutnaal nol one!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus aa mamaus nol Un ima-ii at tilu las ela lam, nahkitum, Yudas maa nol atuli hut mamo. Oen maas kil suli nol kai teben, le daek Yesus. Oen tao ela, muid in prenta deng tulu agama Yahudi las tene-tenen nas, guru-guru agama las, nol blalan-blalan hadat tas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas tekas meman son noan, “Mi tinang babanan! Asii man auk likin nam, mi daek Un tia! Ta atuling man mi in nuting nga na!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tiata, nikit Yudas nol atuil hut mamo nas maas lius se na kon, un laok saol Yesus, le tekan noan, “Paap Guru!” Hidim un neok Yesus le likin. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tukun nam atuil hut mamo kas keko lakos, le daek Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mo Yesus atulin nas at mes luis un hela ka le dait nutus atuling mes hngila klehen. Atuling in papa na, tulu agama Yahudi las tuang tene ka, ata. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesus aa nol atuil mamo man in maa daek Una ngas noan, “Elola? Mi bali le Auk niam atuil daat te? Le mi maa daek Auk nini in kil suli nol kai teben nia? ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Lelo-lelon nam Auk tui mi se Ama Lamtua Allah Um in Kohe-kanas Tene ka, mo muik atuli mes man in maa daek Au lo. Maa daek Auk tia! Ta ni dulan meman son lolo hmunan nua, ne Ama Lamtua Allah Buk Niu ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yesus ima-ii las lii isi. Tiata oen haung lalis nang soleng Un sii. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Neot na kon muik atuling muda mes muid Yesus deng klupu la. Un loes apa ka nini kitu teben mesa. Atuli las kon le daek una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Mo oen kil haup un kitu teben na tuun. Tiata un lali pait nol lu-lulit, undeng un lii naseke. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hidi na kon, oen kil nol Yesus lako se agama Yahudi la tulu tene ka uma. Se um na, atuli-atuil tene kas nakbua son. Nas tulu agama Yahudi las tene-tenen nas, guru-guru agama las, nol blalan-blalan hadat tas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Oras oen daek nol Yesus lako ka, Petrus laok huni-huni le muid deng klupu la, didiin lakos lius se tulu agama Yahudi las tuang tene ka uma. Un kon tama lako se kintal la, le daad mala ai leo-leo nol atuil in doh se na ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Se um na dalen, tulu agama las tene-tenen nas dehet nol atuli-atuil man in daad le nehan dais agama ngas. Oen totoang nuting lalan le bel kula Yesus, undeng oen kom le hukung tele Una. Mo oen net lalan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tiata oen tulu nal saksi mamo, le halin tao nahu Yesus. Mo saksi nas in aa ka, tom apa lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hidim muik saksi teng pait hangus dil le aa in nole-lilung noan, ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kaim ming atuling ni aa noan, ‘Mam Auk tao lean Um in Kohe-kanas Tene, man atuli li bangun-pii nini ima ka. Mo hidi lelo tilum Auk bangun-pii ulang Um na pait, mo pake atuli li ima lo.’” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mo oen in aa ka, tom nol apa lo nabale. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hidim tulu agama Yahudi las tuang tene ka, hangu dil se totoang atuil man in daad le nehan dais agama ngas silan. Kon un keket Yesus noan, “Atuil mamo nias klaa nol Ku son. Mo tasao le Ku ete tuun nia?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesus aa bubuit lo kon. Tiata tulu agama Yahudi las tuang tene ka, keket ulang Un pait noan, “Olan Ku aa buit le! Ku niam baktetebes Kristus, Ama Lamtua Allah Ana, man Un hid meman son deng lolo hmunan nua ka le?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus situn noan, “Meman baktebes! Un mo, Auk niang. Mam mi totoang ngat net Au, Atuling Baktetebes nia, daad se sorga se Ama Lamtua Allah halin kanan na. Un in kuasa ka man muun dui hihidi! Mam Auk nol Un leo-leo kil bandu. Hidi nam, Auk niu maang deng sorgang, se nopen dalen.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ming Yesus in aa ela ka kon, tulu agama Yahudi las tuang tene ka koon-mali isiꞌ, didiin un pius sait un kaod blatas sa. Hidim un haman mumuun le tek totoang atuil in daad nehan dais agama ngas noan, “Kit nuting saksi deken tia! ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mi ming nol hngilan esan son, un esa man tek ela, ta lo? Un nikit apa ka esa le daid Ama Lamtua Allah Ana. Ni in bilu-aa son! Muid atorang agama la lam, eta muik atuli in nikit un apa ka esa, le tatai nol Ama Lamtua lam, atuling na musti mate! Tiata mi kom le nutus elola la?” Kon oen totoang nutus noan, “Meman atuling ni kula baktetebes! Tiata musti hukung tele Una!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hidim atuli at ila lo, keko lakos dadani le puut kapen se Yesus. Oen but kele Un mata ka, le diuk-papas Una. Hidim oen keket Un noan, “Eta Ku niam mo Ama Lamtua mee-baha kam olan Ku nataka, le asii man papas Ku lia?” Hidim oen prenta atuil man in doh Um in Kohe-kanas Tene ka ngas, le laok pel puting Yesus. Oen kil nol Un lako ka la, oen diuk-papas Un la-lalan. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Dedeng na Petrus daad nabael se kintal la. Kon nam tulu agama Yahudi las tuang tene ka, ata bihata mes maa, kon un ngat net Petrus mala ai. Un tadas Petrus sila ka babanan, hidim un tekan noan, “Apin ku kon leo-leo nol Yesus, atuling Nasaret ta, ta lo?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mo Petrus situn noan, “Lo! Amo tasao le ku keket ela lia! Auk taan atuling na loꞌ.” Aa hidi ela kon, Petrus puti le lako dil se hnita in taam maa ka. Tom nol oras na kon, manu ka tukluni. ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hidi na kon, ata na ngat net Petrus pait. Ti un tek atuli-atuil in se na ngas noan, “Un niam, at mes deng atuil nas!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kon Petrus kaen noan, “Ku nuin ne! Auk taan atuling na loꞌ!” Nesang lo kon, atuli mes didang pait se maan na, tek ulang Petrus noan, “Hoe! Ku le nole noan, ku leo-leo nol atuil nas lo deken! Ta mi totoang atuil Galilea, ta lo?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mo Petrus kaen noan, “Hoe! Auk sumpa! Auk taan atuling na loꞌ!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Un tek hidi ela kon, manu ka tukluin pait. Tukun nam Petrus nangan net Yesus in teka apin man noan, “Manu ka tukluin oe dua bii kam, ku kaen Auk oe tiul son.” Petrus nangan net ela kon, Un dalen iil isi tiata lilu nol mumuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Oskaong bii kon, totoang atuil in se maan in nehan dasi ka, koo-dalen mesa, le keo tele Yesus. Hidi kon oen but Un le nolan lako ngada gubernur Pilatus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Oen lakos lius se gubernur ra kon un ketan Yesus noan, “Elola? Ku niam baktetebes atuil Yahudi las Lahin ne?” Yesus situn noan, “Baktebes! Ama Gubernur tek toman na.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Hidi kon, tulu agama las tene-tenen nas aa nol gubernur ra noan, “Atuling ni in tao kula ki bubuit lo son!” Hidim oen tek Un in kula-sala ngas, mesa-mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kon nam, gubernur ra keket Yesus pait noan, “Ku ming oen in teka ka tam lo ka? Oen bel kula Ku mamo son. Olan Ku siut oen buit le!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mo Yesus siut saa lo, didiin gubernur ra herang isi. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Taun-taun nam, eta atuil Yahudi las tao fesat Paska lam, atuil hut mamo kas huil atuil bui mesa, le gubernur ra sao una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Dedeng na, muik atuil bui mesa, ngala Barabas. Hmunan nu, oen daek una nol un tapan nas, undeng un labang nol pamarenta Roma la, hidim un kon keo atuli. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tiata fesat Paska la maa dadani son kon, atuil hut mamo kas lakos se gubernur Pilatus, le haman tek mumuun noan, “Ama gubernur! Leol Paska li maa son! Eta bole lam, Ama gubernur tulung sao atuil bui mesa, el taun-taun man in hidi son nuas!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kon gubernur ra situs noan, “Eta ela lam, auk sao se asii la? Eta Auk sao mi atuil Yahudi li Lahin nia lam, mi tade ke?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gubernur ra tek ela, molota un tanan son noan tulu agama Yahudi las tene-tenen nas kil nol Yesus lako bel una, lole oen idus Yesus isi, nol oen kon kom Un lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mo blalan-blalan agama las hode-lokot atuil hut mamo kas, le oen totoang nodan gubernur ra noan, “Kaim kom Un lo! Sao se Barabas tuun!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tiata gubernur ra keket oen pait noan, “Eta ela lam, auk musti tao saa nol Yesus, man oen noken noan, ‘atuil Yahudi las Lahin’ nia la?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kon oen totoang leo-leo nakaa mumuun noan, “Keo tele Un tuun tia! Pauk Un se kai sangsuli lua!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mo ela kon no, gubernur ra keket pait noan, “Lam Un in salan ni asa la? Auk pres Un son, mo Auk haup Un in kula-salan mes lo kon!” Mo oen totoang nakaa muun dui pait noan, “Keo tele Una! Pauk Un se kai sangsuli lu tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Undeng gubernur ra kom le tao atuil hut mamo kas dalen kolo, tiata un sao Barabas muid oen in koma ka. Hidim un tadu atuil in doha ngas, le laok lapat Yesus nini ui-latu. Lapat hidi kon, tentara las kil nol Yesus, le nolan laok pauk tele se kai sangsuli lu dapa. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hidi na kon, tentara las pel nol Yesus lako se oen benteng nga. Se na, oen haman oen tapan nas batalion mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Hidim oen lotong bel Yesus kaod blatas mea-mamaten mesa, tuladang el taom lahi las kaod in pake ngas. Oen kon kat kai hlango in muik duli ka, le naneng daid hlotong. Hidim oen tudan hlotong duli na laok se Yesus bon na, le tao kuti-kuti banansila el in nikit laih balu, nini in lotong belen hlotong lahi ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Oen totoang todan kuti-kuti Una. Oen tekan noan, “Ni Laih atuil Yahudi!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hidim oen hlak le todan Yesus, nol puut kapen oe-oe se Un sila ka. Nol oen kon diuk Un bon na oe-oe nini kai. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Oen diuk hidi Un kon, oen kolong soleng Un kaod blatas sa, le pake belen Un kai-batu las pait. Hidi nam, oen kil puting Un deng kota Yerusalem, le laok pauk holtiu Un se kai sangsuli la didiin mate. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Oras oen puit lakos deng Yerusalem ma, se lalan hlala kam oen tutnaal atuli at mes maa deng kota Kirene. Un ngala Simun. Un nam mo, Aleksander duas Rufus aman. Un halas-sam le taam lako bus el Yerusalem, mo tentara las daek nal una, le dising un haal Yesus kai sangsuli la. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Oen kil nol Yesus lako lius se mana mesa, ngala Golgota. (Nahin na noan, ‘maan bon seen’.) ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Se na, oen le ninung Yesus nini anggor ngilu man kutang son nol kai, le halin nam Un tahang nal ili. Mo Yesus dai niun loꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Oen pauk batleng Yesus se kai sangsuli la, hidim oen pii kai na, oras na nataka le diuk sipa oskaong. Hidim tentara las pel lot le nuting asii man haup Yesus kai-batu las. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Oen kon dul se kai bleha mesa, le pakun laok se dapa, titu nol Yesus bon na, noan, “Ni atuil Yahudi las Lahin” Oen nini lalan na le hukung Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Se na, oen kon pauk tele atuil in naok daat at dua. Mes se Yesus halin kanan na; mo mesan na pait se Yesus halin kliu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nini ela lam, oen daek muid asa man in dul meman son, ne Ama Lamtua Allah Buk Niu ka noan, “Oen tao Un banansila el atuil daat ta.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Totoang atuil man in laok muid lalan na ngas, ngat net Yesus holtai se kai sangsuli la. Kon oen lale-lale leon nas, le aa tao nahmaeng Yesus noan, “Hoe! Ku tek noan, Ku tao lean nal Ama Lamtua Allah Um in Kohe-kanas Tene ka, hidim bangun-pii ulang pait lelo tiul siis ta lo? ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Eta baktebes sam, olan Ku niu deng kai sangsuli la, le sao Ku apam ma esa tia! Ta ela halas-sam kaim parsai noan, meman Ku niam, Ama Lamtua Allah Ana.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tulu agama Yahudi las tene-tenen nas nol blalan-blalan agama las kon bilu-aa Yesus noan, “Un bel slamat nal atuil didang, mo Un apa ka esa kam, Un bel slamat nalan lo! ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Un noken Un apa ka esa noan, ‘Kristus’, Atuling man Ama Lamtua Allah tulu meman son deng lolo hmunan nua ka. Atuil tenga las tek noan, Un niam atuil Israel las Lahin. Eta baktetebes ela lam, Un musti niu muna deng kai sangsuli la, le kit netan, halas-sam kit parsai se Una.” Atuil at dua man holtai leo-leo nol Yesus se kai sangsuli dapa ngas kon, bilu-aa Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hidi na kon, mitang-tilu kabut maan na deng lelo ditu, lako pes diuk tilu lelo-maun. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Diuk tilu lelo-maun kon nam, Yesus haman mumuun nini dais Aram noan, “Eloi! Eloi! Lama sabaktani?” (Un nahin na noan, “Auk Lamtuan! Auk Lamtuan! Tasao le Ama bali kudi nang soleng Au lia?”) ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Atuli at ila lo dadani se na, ming Yesus fala ka. Kon nam oen aa noan, “Hoe! Mi hii le! Un haman upung Elia, Ama Lamtua mee-baah hmunan nua ka!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kon atuli at mes lail lako kat kitu duda le dopon tamang laok se anggor ngilu ka. Hidim un hai kitu duda na laok se hnikan tula mesa, le tapa laok se Yesus sula ka, halin Un bolos. Nol atuli las aa noan, “Natang le kit ngat soba-nanan! Asii tana mo upung Elia maa tao niung Un deng kai sangsuli dapa ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesus haman mumuun oe mes pait, hidi kon Un mate. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Se Um in Kohe-kanas Tene ka, muik kitu tene mes holtai kele Ama Lamtua Allah Kamar in Niu Dui ka. Tom nol Yesus hngasa ka in nutus sa, kitu tene na sait bating dua deng dapa lako pes daleꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Neot na se Golgota, muik komendan mes dil le doh se la. Nikit un net Yesus in mate ka kon, un nahkitu, hidim un tek noan, “Inah! Atuling ni meman baktetebes Ama Lamtua Allah Ana!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Nol muik bihata at ila lo, kon net Yesus in mate ka deng kakatang. Oen man hmunan nu lii-lau Yesus nol atuil man in muid Una ngas se Galilea. Bihaat nas ngalan nas elia: Salome, Maria deng iung Magdala, nol Maria mes pait (na Yakobus duas Yoses inan na), nol muik bihata-bihata teng pait, man maas leo-leo nol Yesus se Yerusalem. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Hidi na, muik atuli mes nuting lalan le niung Yesus nitun na deng kai sangsuli dapa. Atuling na ngala Yusuf. Un nam deng kota Arimatea. Nol un kon at mes deng blalan in nehan dais agama Yahudi ngas. Un hadat banan. Un kon natang-natang Ama Lamtua Allah bandu la in maa ka. Yesus in mate ka tom nol leol lima. Mo ola ka, tom nol atuil Yahudi las leol in kohe-kanas. Undeng na, le leol lima ka, Yusuf le laok niung Yesus nitun na. Tiata un tao teken un dalen na, le laok nodan Yesus nitun na se gubernur Pilatus. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nikit gubernur ra ming Yusuf nodan ela kon, un herang. Hidim un tek noan, “Inah! Atuling na in mate ka hlapat ta le! Auk bali le bisa daid ela lo!” Kon un tadu atuli le laok haman komendan na, hidim un keket noan, “Elola la? Yesus mate baktebes son ne?” ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Komendan na situn noan, “Baktebes papa, Un mate son lolo apin.” Gubernur ra ming ela kon, un tade le Yusuf laok niung Yesus nitun na. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kon nam, Yusuf lako sos kitu blatas man osa ngas. Hidim un lako Golgota. Un lako lius kon, un niung Yesus nitun na deng kai sangsuli la dapa. Hidim Un kabut Yesus nitun na babanan nini kitu balu man osa na. Dedeng na, oen halas-sam paat hidi bolo nitu mes babalu se leten mesa. Tiata oen kok tamang Yesus nitun na lako se bolo na. Hidim oen lulin nol baut bleha tene mesa, le hepan babanan laok se bolo ka hnitan na. Hidi halas-sam, Yusuf nol un tapan nas pait. ");
INSERT INTO hegNTpo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Dedeng na, Maria deng iung Magdala nol Maria didang (Yoses ina ka), lakos muid se na kon. Oen duas ngat le tadas babanan bolo man oen in nene Yesus nitun na ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Hidi Yesus in mate ka, ola ka leol eneng, na atuil Yahudi las leol in kohe-kanas sa. Neot na lelo dene son, mo Maria deng iung Magdala, Maria didang (na Yakobus ina ka), nol Salome, lakos sos mina bui bingis, undeng ola ka, oen le laok hising Yesus nitun na muid atuil Yahudi las hadat ta. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tiata leol minggu la oskaong mitang bii, lelo halas-sam tong, mo oen tilus lakos se niut utu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Se lalan hlala kam, oen keket apa noan, “Hoe! Hidi kam, asii man hulung kit le pekot bian baut tene in ne niut utu ku hnitan nua la? Etan kit tilut sii ngam bolen loꞌ, lole baut na tene isi kam!” Mo oen lakos lius se las kon, oen ngat tam baut tene na hopaling son. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ta oen taam lakos bolo ka dalen. Mo oen nahkiut isiꞌ, undeng oen ngat net atuil muda mes daad se oen halin kanan na, pake kai-baut muti kaloe. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Atuling muda na tekas noan, “Mi lii deken! Auk tana, le mi maa nuting Yesus, Atuling Nasaret, man oen pauk tele son se kai sangsuli lua ka. Un ne ia lo son, undeng Un nuli pait son! Maa, le mi ngat esan, se maan oen in nene Yesus nitun na ka. Un ase son. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tiata mi pait lalaba tia! Le laok tek Petrus nol un tapan nas noan, Yesus nuli pait son. Un lako muna son ne Galilea. Mam oen tutnaal nol Yesus se ua, banansila el asa man hmunan nu Un tek oen meman son na. Tiata mi pait tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nikit bihata las ngat mana la le Yesus ase baktebes kon, oen lii isi. Hidim oen lail putis le laba-laba tuun pait. Oen tek asii loꞌ se oen lalan in pait ta, undeng oen lii isi. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Leol minggu oskaong nga, Yesus tulu-balang apa ka muna bel Maria in deng iung Magdala ka, man hmunan nu Yesus nulut puting uikjale iut deng un apa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Un net hidi Yesus kon, un lako tek totoang atuil man hmunan nu muid Yesus sas. Dedeng na oen nakbua nabael nol dael ili. Oen kon matan uin kodo nol in nangan Yesus in mate ka. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maria lako lius se one la kon un tekas noan, “Tasao le mi dalen sus nabale lia? Sus bakun tia, ta Yesus nuli pait son! Apin auk tutnaal Una, hahalas!” Mo oen totoang situn noan, “Hoe! Ku nole ela deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hidi nam, Yesus atulin in muid Una ngas at dua lakos el ingu mesa. Se lalan hlala kon, Yesus tulu-balang apa ka bel one, nini tuladang kisa. Mo nesang lo kon, oen duas tadas taan Una. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tiata oen duas pait lakos lius oen tapan nas kon, oen tek noan, “Hoeh! Mi hii napat le! Apin kaim tutnaal Yesus se lalan nua!” Mo oen tapan nas totoang situs duas noan, “Hoe! Mi aa nole ela deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hidi na kon, Yesus tutnaal nol Un ima-ii hngul esa kas, se oras oen in daad le kaa ka. Un kaing oen noan, “Hoe! Mi in bon batu kia! Atuli tek mi son noan, oen net Auk son nini oen matan beas esan, mo mi dai parsai lo kia! Mi tek le, oen totoang nole! Ta Auk esang maang lolen son nian. Meman Auk mateng, mo halas ni, Auk nuling pait son! Mi ngat esan tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tiata, mi musti laok papmes apan-kloma ki le tek atuli las totoang deng Auk Dehet Dais Banan ni tia. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Asii man parsai Au, nol haup in sarani kam, mam Ama Lamtua Allah bel boa-blingin una, le halin un haup in daad napiut nol Ama Lamtua Allah se sorga. Mo asii man parsai lo kam, mam un haup in hukung, nol Ama Lamtua Allah hutun soleng una, le daad napiut se likun. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nol atuil in parsai Au ngas, mam oen tao taad herang bili-ngala, le halin atuli las totoang tana, noan, oen in kuasa ka, meman maa deng Ama Lamtua. Tuladang el, mam oen nulut nal uikjale kas nini Auk ngala ngia. Nol mam Ama Lamtua Allah tao oen le aa nini dais didang man oen tanan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Hidim, eta oen kil tom ul in muik lasong tam, oen niun tom laos kon no, oen tom in daat loꞌ. Mo eta oen nene iman nas se atuil in ili ngas bon, le nodan beles sam, atuil nas banan meman.” ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Aa hidi nol Un ima-ii las ela kon, Ama Lamtua Allah nikit sakeng Yesus lako sorga. Se na Yesus daad se Ama Lamtua Allah halin kanan na, le Oen duas kil bandu leo-leo. ");
INSERT INTO hegNTpo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Hidi kon, Un ima-ii las, daek muid Un in leka ka. Oen lakos se ola-ol le tek atuli las totoang deng Dehet Dais Banan na. Nol Ama Lamtua Allah beles kuasa, le oen tao nal taad herang bili-ngala, banansila el asa man Yesus in tek oen son na. Atuli mamo parsai se Yesus, undeng oen taan son noan, Dehet Dais Banan na, meman tom baktetebes. Nikit bihaat at tilu las lakos lius Petrus nol atuil in leo-leo nol una ngas kon, oen tekas totoang asa man oen in ming son deng atuling muda ka in teka se niut utu kua ka. Hidim, Lamtua Yesus esa man prenta Un ima-ii las, le laok tek Un Dehet Dais Banan na se ola-ola, se papmes apan-kloma kia. Dehet Dais Banan nia, man tulu lalan le halin Ama Lamtua Allah bel boa-blingin atuli li deng oen in kula-sala ngas, halin oen nulis tutungus nol Una. Dehet Dais Banan nia, meman tom baktetebes. Tiata un tahang napiut didiin hidi nutus taan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Ama Teofilus man auk in todan. Boa-blingin. Atuli mamo dul soba-naan dehet deng dasi-dais man in daid son se kaim hlala kia ngas. Dehet oen in dulang nas muid apa lo, mo kaim taan haup dehet nas deng Lamtua Yesus nenan nas, nol atuil didang man net nol matan esan nas. Totoang oen in dehet tas le, lam muid baktetebes Ama Lamtua Allah in hid meman son lo-lolo hmunan nua ka. Tiata auk tinang dais nas totoang nol babanan, kilan deng dehet ta peke ka. Hidim auk nutus le dulas totoang nol babanan, muid un lalan. Nini ela lam, ama taan asa man in daid son na nol baktetebes. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nol ama kon parsai noan, asa man atuli las in dehet son na, dehet in nole-lilung lo. Totoang nas, baktetebes ela! ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dehet ni un peke ka elia: dedeng laih Herodes kil bandu se propinsi Yudea ka, muik atuling mes ngala Sakarias. Un na mo, at mes deng tulu agama Yahudi las. Nol un kon at mes deng tulu agama man in se upung Abia buan na ngas. Sakarias sapa ka, ngala Elisabet. Elisabet nam kon upu-aan deng tulu agama las, lole un nam mo upung Musa kaka Harun in hua-koet. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Oen duas nuil lolo-lolo muid Ama Lamtua Allah prenta las nol atorang ngas totoang. Atuli kon todan one. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Oen duas kon blalan son, mo muik aan lo, lole Elisabet maan in hua ana ka tema son. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Oe mesan na, Sakarias nol un buan Abia las haup oras in dake se Um in Kohe-kanas Tene ka, se kota Yerusalem. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Muid oen in nuil-nola ka lam, tulu agama las pel lot, le taan noan asii man taam laok se Um in Kohe-kanas Tene ka Kamar in Niu Dudui ka. Se na lam, atuling na musti tuun kai bui bingis se Ama Lamtua Allah sila-mata. Dedeng na, lot ta nahi tom Sakarias. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kon nam un taam lako. Oras un tuun kai bui bingis se kamar ra dalen na ka, atuil hut mamo kas kohe-kanas se kintal la. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nahkitu lam, Ama Lamtua Allah ima-ii mes deng sorga maa dil se maan in tuun kai bui bingis sa halin kanan na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ngat net ela kon, Sakarias lii isi, didiin un taan le tao elola ka lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mo ima-ii in deng sorga ka tekan noan, “Sakarias! Lii deken ne! Ta Ama Lamtua Allah ming ku in kohe-kanas sa son. Ta mam ku sapam ma hua bel ku tana-ana biklobe mesa. Ku musti ngali un ngala ka, Yuhanis. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mam atuli hut mamo kon dalen kolo leo-leo nol mia, undeng mi haup aan son. Mam tana-ana ni tao ku dalem kolo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ama Lamtua Koo Niu ka leo-leo nol una, kilan deng un ina ka in beeh una ka. Un musti luil totoang in ninu man tao le mahu ngas. Oras un tene maa ka, Ama Lamtua Allah pake un daid atuil tene. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mam un hanet atuil Israel mamo le bali muid oen Tuang nga, na Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Un oen-lalin na nol un in kuasa ka parsis el upung Elia, man Ama Lamtua mee-baha deng hmunan nua ka. Un maa muna deng kit Tuang nga. Un tao atuil blalan nas le namnau oen anan nas pait. Nol atuil in bali kudi Ama Lamtua ngas, un bali oen in nuli ka kon, le halin oen bali muid Ama Lamtua in koma ka. Nini ela lam, un tao atuli las le oen dalen nas sium Lamtua in maa kia.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mo Sakarias ketan bali ima-ii na noan, “Elol na la?! Auk nol auk sapang ngi blalan son nian nam, taon elol le auk taan noan nias totoang bisa dadis sa?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kon nam ima-ii na siut noan, “Auk niam Gabriel, Ama Lamtua Allah atulin in loka-tadu ka. Un esa man lok auk le maa tek dais banan ni bel ku. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mo ku dai parsai auk in teka ki lo. Tiata, taad deng ku in nodan na elia! Ku meem ma nuduꞌ, le ku aa nal lo deng leol neot nia, didiin oras mi in haup tana-ana ka ka. Mam ku ngat esa tuun! Ta asa man auk in teka ni lius oras sa lam dadi.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Atuil hut mamo man kohe-kanas se likun na ngas nangan hapun lo, lole Sakarias puti taan lo tuun nam. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mo oras un puit maa ka, un aa nal lo son. Hidim un bel taad nini ima ka, tukun nam oen tana noan, Ama Lamtua tulu belen dais in muun isi mes se Kamar in Niu Dudui ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Oen oras in dake ka hidi kon, Sakarias pait lako uma. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Nesang lo kon Elisabet behe. Kon un huni se uma dalen tukun, didiin bulan lima. Un aa noan, “Naka Ama Lamtua! Undeng Un tulu Un dalen banan na bel auk son. Eta auk haup in hua-koet son nam, atuli las tao nahmaeng auk pait lo ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Dedeng Elisabet in behe ka laok bulan eneng kon, Ama Lamtua Allah lok Un ima-ii mes deng sorga, le lako se ingu mes ne propinsi Galilea, ngala Nasaret. Ima-ii na ngala Gabriel. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Se Nasaret muik tana-bihatang mes ngala Maria. Maria na mo biklobeng mes ngala Yusuf neleng son. Yusuf na mo laih Daud in hua-koet. Tiata ima-ii Gabriel laok tutnaal Maria. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Un tulu apa ka bel tana-bihatang na, le tekan noan, “Boa-blingin baat-ana! Ama Lamtua Allah huil nal ku son, le tao dais banan mes bel ku. Ama Lamtua Allah kon leo-leo nol ku, Maria.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ming ela kon, Maria nangan taan asa man ima-ii na in teka ka lo. Un nangan taan le in teka na nahin na saa ka lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kon nam ima-ii na tek napiut noan, “Maria! Lii deken! Ta Ama Lamtua Allah kom le tulu bel ku Un dalen banan na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nesang lo ka kam, ku behe, hidim ku hua tana-ana biklobeng mesa. Ku musti ngali Un ngala ka, Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mam Un daid Atuil tene. Nol Un nam Aan deng Ama Lamtua Allah man Lapa Dui Hihidi ka, man Ama Lamtua noken noan, ‘Un na mo, Auk Anang esa.’ Mam Ama Lamtua Allah nikit Un le kil bandu, banansila el Un upu kia-kaon laih Daud. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Un man kil bandu napiut taung atuil Israel las. Ta Un in prenta ka hidi nutus taan lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mo Maria ketan ima-ii Gabriel la noan, “Auk niin nakbuan net nol biklobe mes lo bii kon! Lam taon elol le auk beheng nga?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kon ima-ii na situn noan, “Elia! Mam Ama Lamtua Allah Koo Niu ka maa se ku. Nol Ama Lamtua Allah in Lapa Dudui ka nini Un kuasa la, le buba-kabut ku. Nini ela lam, tana-ana man ku in hua na, niu baktetebes, lole mam Ama Lamtua Allah noken noan, Un nam Auk Anang esa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Herang deken! Ta ku nenan mes ngala Elisabet kon behe son. Un blalan son ta atuli tek noan un hua lo ka. Mo halas ni un behe laok bulan eneng son. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ta taung Ama Lamtua Allah lam, totoang bisa dadi!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Hidim Maria siut noan, “Banan. Auk niam Ama Lamtua Allah atulin in loka. Nang le totoang daid muid ku in teka ka. Auk tade le muid Ama Lamtua in koma ka.” Hidi kon ima-ii in deng sorga na lako nang una. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Kaliut nal lelo ila lo, kon Maria lalaba bok deng Nasaret le lako Sakarias ingu la, man ne leten deng propinsi Yudea. Lius se ua tukun nam, un taam lako se Sakarias uma, le boa-blingin nol Elisabet. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nikit Elisabet ming Maria in biu le aa noan boa-blingin na kon, tana-ana in se un tain dalen na ka sapan. Ti Ama Lamtua Koo Niu ka maa tama se Elisabet. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tiata un aa mumuun le tek noan, “Maria! Mam atuli las nikit sakeng ku ngalam ma lapa dui deng totoang bihaat in ne apan-kloma ki ngias! Mam atuli las kon nikit sakeng tana-ana in ne ku taim ma dalen na ka! ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Auk kon haup in naka, undeng auk Lamtuan na ina ka maa tutnaal nol au. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Apin ku taam maa biu, le aa boa-blingin nol au ka, auk anang in ne auk taing ngi dalen nia ki, sapan, undeng dalen kolo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ama Lamtua Allah tulu Un dalen banan na bel ku son, undeng ku parsai noan, Un daek muid Un in hida ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria aa noan, “Deng auk daleng ngi esa-esa kia, auk nikit sakeng Ama Lamtua ngala ka lapa-lapa! ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Auk daleng ngi kolo isi, undeng Ama Lamtua Allah bel boa-blingin au! ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Un tinang auk babanan son, molota auk niam Un atulin in loka-loka man muik nahin lo. Ninin deng oras nia, mam totoang atuli li nangan noan auk niam, bihaat man ulat banan dudui, ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","undeng Ama Lamtua tao bel auk dasi-dais in herang. Un nam Kuasa Dui Hihidi nol Niu Dui. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ama Lamtua Allah tulu dael kasiang tutungus bel totoang atuil in todan-lahing se Una ngas, deng in hua-koet mesa, lako in hua-koet tenga las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Un nini Un in kuasa ka, le tao didaa atuil in bon batu ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Un tao nahu atuli-atuil in kil kuasa ngas, undeng oen in koaok daat ta. Mo Un nikit sakeng atuil in tao apa ka deng dadale ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Un nalo atuil in lubung ngas didiin silis, mo Un nulut soleng atuil in muki ngas le lakos nol iman mosa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Un tulung Un atulin Israel las, nol tulu Un in namnau one ka tutungus. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Hmunan nua, Un butu-kil in hida nol kit upu kia-kaon nas, upung Abraham nol un in hua-koet tas totoang. Halas ni in hida na butu-kil napiut.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria daad nol Elisabet bulan tilu, hidi halas-sam un pait lako uma, ne Nasaret. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Oras sa maa lius kon, Elisabet hua tana-ana biklobeng mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Dehet na holhising lako se un nenan nas nol iung na isin na totoang, noan, Ama Lamtua Allah tulu Un dalen banan na, le bel Elisabet tana-ana mes son. Kon oen totoang dalen kolo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nikit tana-ana na umur lelo paul kon, oen sunat un muid atuil Yahudi las atorang nga. Hidim oen le ngali tana-ana na, Sakarias muid un ama ka ngala ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mo un ina Elisabet dai tao lo, le tek noan, “Ela deken! Un ngala ka, musti Yuhanis!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mo oen situn noan, “Tasao le huil ngaal Yuhanis sia? Muik tahan atuli mes lo kon deng mi nenan nias, man muik ngalan ela!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Hidim oen aa nol Sakarias nini in tulu, le ketan noan un kom le ngali tana-ana na ngala asii la. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kon Sakarias tulu le nodan baut in dula. Ta oen kat belen, ti un dul noan, “Un ngala Yuhanis!” Kon nam atuli las totoang hera-herang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nahkiut tuun nam, Sakarias meen in nuduꞌ na banan meman. Hidim un nikit in naka bel Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ta totoang atuil in daad dadani se na ngas lii nol herang. Kon nam dehet na holhising deng baha laok baha, didiin totoang atuil in se leten-leten deng propinsi Yudea ngas kon ming hapu. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Atuil in ming dehet na ngas nangan-nangan noan, “Langa son, le Ama Lamtua in kuasa ka leo-leo nol tana-ana na. Ta eta un tene maa kam, un daid atuil tuladang elola le?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nikit Sakarias aa nal pait tukun nam, Ama Lamtua Koo Niu ka maa tama se una. Tiata un tek noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Naka Ama Lamtua Allah, atuil Israel las, Lamtuan na! Ta Un maa son, le sui Un atulin nas, halin nam oen banansila el ata ka pait lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ama Lamtua nikit Atuli mesa, man in kuasa ka muun isi, le mam bel boa-blingin kita. Un nam deng laih Daud in hua-koet. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ama Lamtua hid nias meman son deng hmunan hesa kua, nini Un mee-baah in muid Un tutungus sas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Halas ni Un le sao kit deng kit musu las, nol atuli-atuil man pesang dael nol kita ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Un tulu Un dalen banan na bel kit upu kia-kaon nas, undeng Un nangan nakekeon Un in hid one ka, man Un butun nol upung Abraham. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Un sao kit son deng kit musu las, le halin kit todan-lahing se Una, nol in lii-tidu lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Un sao kit son, le halin nam kit in nuli ki niu, nol lolo tutungus se Un sila-mata ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yuhanis! Ku niam, auk anang. Mam atuli li taan noan, ku niam mo, Ama Lamtua Allah man Lapa Dui Hihidi ka mee-baha. Mam ku laok tek atuli las, le oen sodo-sium Tuang in maa kia. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nol ku laok tulu lalan bel Ama Lamtua atulin nas, le halin oen taan noan oen haup boa-blingin, undeng Ama Lamtua kose soleng oen in kula-sala ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Ama Lamtua dalen na duda nol namnau kita, tiata Un bel kit dola balu, banansila el leol balu, man kil langa balu. Kit laok ne mitang dalen, nol lii in mate, undeng kit daem nol Ama Lamtua lo bii, mo mam Un bel kit langa le pel nol kit lakong se lalan in dame ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hidi kon lelon laok lelon nam, Yuhanis tene keko lako. Ama Lamtua Koo Niu ka kon tao tes una. Un tene maa kon, un lako daad se maan in muik atuil lo, didiin un nikit un osa la bel atuil Israel las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Dedeng Kirenius daid gubernur se Siria, lahing tuan Agustus sa puting prenta mes elia, “Totoang atuil man hutu-atan deng pamarenta Roma la in kuasa ngas, musti pait oen ingu-mana las le muid in sensus!” Pamarenta Roma la in kaih un hutu-atan nas laih hmunan na ka, na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tiata atuli las totoang pait oen ingu-mana, le muid sensus. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Lam dedeng na, Yusuf daad se iung Nasaret ne propinsi Galilea. Un neleng Maria, man behe son. Yusuf na mo laih Daud in hua-koet, tiata un musti pait lako laih Daud kota la, Betlehem, ne propinsi Yudea le muid sensus. Undeng na le oen duas bok lakos se kota Betlehem. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Oen lakos lius se luas nesang lo kam, Maria oras in hua ka maa lisu. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mo se na, oen haup kamar se um in hani ngas lo. Tiata oen tamas lakos se okat mesa. Kon nam Maria hua Ana hmunan na, Aan biklobe. Hidim oen duas losen nini kitu, le nene laok se hmukit tas poo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Duman na, atuil in lolo-poa hmukit at ila lo, melang le doh oen laen nol lae-blai las se epe mesa, se kota la likun na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nahkiut tuun nam, oen ngat net Ama Lamtua Allah ima-ii mes deng sorga. Hidim Ama Lamtua langa ka kaloe pukiu one, kon oen lii isi. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mo ima-ii na tekas noan, “Mi lii deken, le hii babanan ne! Ta auk maa le tek mi deng dais banan mesa. Totoang atuil in ming haup dais ni ngias, taon elola ko dalen kolo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dais banan ni isin na elia: Leol ni bihatang mes hua Kristus son, ne Betlehem, laih Daud kota la! Kristus na mo, Atuling man Ama Lamtua Allah in hid meman son, deng lolo hmunan nua ka. Ama Lamtua tunang Un maa le bel boa-blingin atuli li deng oen in kula-sala ngas! Una, man mam atuli li haman noan, ‘Lamtua!’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mam mi in taan Una ka elia: mi tutnaal tana-ana blutu mea mesa, man losen nini kitu. Un nini ne hmukit tas poo ka dalen.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Un tek hidi ela kon, nahkitu lam Ama Lamtua Allah ima-ii deng sorga mamo isi maas le nakbuan nol una. Hidim oen naka Ama Lamtua nini in tao dani noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kaim nikit sakeng Ama Lamtua Allah ngala ka lapa-lapa! Un man daad le kil bandu se apan man lapa dui hihidi kua. Ama Lamtua Allah le tao daem atuli-atuil in se dale-dapang nias, man tao Un dalen kolo ngas!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hidi nam, Ama Lamtua ima-ii las pait lakos sorgas. Kon atuil in lolo-poa ngas tek apa noan, “Hoe! Maa le kit laok Betlehem, le tinang tana-ana mea na le! Ta Ama Lamtua tek kit dehet na son nan.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kon nam oen lalaba tuun lakos bus el Betlehem. Lius se luas kon oen tutnaal Maria nol Yusuf. Oen kon ngat net Tana-ana blutu mea na, nini se hmukit tas poo ka dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nikit oen ngat net Tana-ana na kon, oen dehet noan, “Apin Ama Lamtua Allah ima-ii deng sorga tek kaim son deng Tana-ana nia!” Hidi nam oen dehet beles totoang asa man oen in tutnala ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ming atuil in lolo-poa ngas in dehet ela ka kon, oen totoang herang-herang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mo Maria pesang totoang in dading nas se un dalen na. Nol un nangan ete-ete le nuting nahin na elola. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Hidi kon atuil in lolo-poa ngas pait lakos oen laen nol lae-blai las. Oen nikit sakeng Ama Lamtua Allah ngala ka lapa-lapa. Oen nodan mamo se Una, undeng oen in ming nol in neta ka, tom nol asa man Ama Lamtua ima-ii la in teka ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hua hidi Tana-ana na lelo palu lam, oen sunat muid upung Musa atorang nga. Kon Un ina-aman nas ngali, ‘Yesus’. Ngaal na ka, ngaal man ima-ii in deng sorga ka in tek oen son, se oras Un ina ka in beeh Un lo bii ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Muik atorang mes deng upung Musa, man tek noan, bihaat man hua hidi nal lelo buk aat ta, musti laok tao muid hadat in hiti-lingin, le tao niu apan se Um in Kohe-kanas Tene ka. Nini ela lam, oen boel in taam se Um in Kohe-kanas sa pait, el in biasa ka. Tiata Yusuf nol Maria lakos kota Yerusalem, le tao muid hadat na. Kon oen kil nol Yesus, man ana blutu mea nabale, lako se Um in Kohe-kanas Tene ka dalen, le sao Un daid Ama Lamtua nena. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Oen tao muid Ama Lamtua atorang man tek noan, “Bihaat in hua aan hmunan na, eta aan biklobe lam un musti sao tana-ana na le daid Ama Lamtua nena.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Eta sao tana-ana na bel Ama Lamtua muid Un atorang nga lam, un ina-aman nas musti bel tiul-tuan ina-lakin, tamlom hmuktai ana dua, le daid in tunu-dadung. Tiata Yusuf nol Maria daek muid atorang na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Dedeng na, muik blalan mes ngala Simeon, daad se kota Yerusalem. Un nam mo, atuil in dalen lolo nol kom isi le net Ama Lamtua. Ama Lamtua Koo Niu ka tek un son noan, mam un net Kristus le, halas-sam un mate. Kristus na, man mam bel boa-blingin atuil Israel las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Leol na, Ama Lamtua Koo Niu ka pel nol Simeon lako Um in Kohe-kanas Tene ka, tom nol Yesus ina-aman nas in kil nol Un lako se la, le sao daid Ama Lamtua nena ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ngat net Tana-ana na kon, ama Simeon simun le kokon, hidim un naka Ama Lamtua Allah, le tek noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Naka Ama Lamtua! Ta Ama Lamtua daek muid asa man Un in hid au ka son. Tiata Ama Lamtua bisa sao auk tia, le halin nam auk mateng nol babanan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ta auk net Atuling man Ama Lamtua tunang maa, le bel boa-blingin kaim deng kaim in kula-sala ngias sa son! ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ama Lamtua pake Tana-ana nia, le bel boa-blingin bangsa-bangsa lias totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mam Un banansila el langa in kaloeꞌ, man kil in todan bel Ama Lamtua bangsan Israel las. Un kon banansila el langa, man tulu Ama Lamtua lalan na bel totoang bangsa didang ngas sa.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ming ela kon, Yusuf nol Maria herang isi nol asa man ama Simeon in aa deng oen Anan na ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Hidi nam, Simeon aa le bel oen hangun. Un kon tek Maria noan, “Yesus mama! Mam atuli hut mamo se Israel hutun soleng maam Ana kia. Mo oen in tao saol Una ka, mam tom bali one. Maam Ana ki kon, tao atuli hut mamo dalen kolo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nini ela lam, mam Ama Lamtua tek tulu-balang totoang atuli li dalen in banan-daat ta. Mo ku, Maria, mam haup in susa-daat ngele, banansila el suli in hai tama lako se ku hupum ma ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Se Um in Kohe-kanas Tene ka kon muik blalan bihatang mesa, ngala Hanaa. Un umur buk palu beas aat son. Un ama ka, ngala Fanuel deng ngaal Aser. Un saap hidi taun iut kon, un sapa-bikloben na mate nang una. Upung Hanaa nam mo, Ama Lamtua Allah mee-baha. Un in daek lelo-duman na, kohe-kanas nol telang se Um in Kohe-kanas Tene ka, le todan-lahing Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Dedeng Simeon in aa nol Yusuf duas Maria ka, blalan bihatang na maa dadani le hii one, kon un naka-naka Ama Lamtua Allah. Hidi nam, un aa deng Yesus apa ka, bel totoang atuil in nata-natang Lahing man Ama Lamtua hid son, le tunang maa halin sao puting bangsa Israel las sa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Daek muid upung Musa atorang ngas totoang hidi se kota Yerusalem kon, Yusuf nol Maria pait lakos propinsi Galilea, se oen ingu la, iung Nasaret. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kon oen Anan Yesus tene maa, Un apa ka kuat-tes, hidim Un taan taplaeng, nol Un kon nangan taan dasi mamo. Ama Lamtua Allah kon tulu dalen banan na bel Una. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Taun-taun nam, Yusuf nol Maria lakos kota Yerusalem, le muid fesat Paska se las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Oe mesan na, dedeng Yesus umur taun hngul dua kon, oen leo-leo lakos se Yerusalem le muid fesat Paska el in biasa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Lelo-leol Paska las mana le hidis kon, Yusuf nol Maria pait lakos el Nasaret, leo-leo nol atuil hut mamo man in pait lakos Galilea ngas. Mo oen taan lo, molota Yesus dada bii ne Yerusalem. Oen bali le Un laok leo-leo nol Un tapan nas. Mo didiin lelo-maun kon, oen net Un lo. Tiata oen lako-pait le nuting Un se oen nenan nas nol oen tapan nas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Undeng tutnalan lo, tiata oen pait lakos Yerusalem le nuting Un se lua. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Lakos lius se uas kon, oen nuti-nuting Un didiin lelo tilu, halas-sam tutnalan se Um in Kohe-kanas Tene ka dalen. Un daad le keket-ketan nol guru-guru agama Yahudi las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Totoang atuil in ming Yesus sas hera-herang, undeng Un nangan taan isi baktetebes, isin deng Ama Lamtua Allah in Dula ngas. Un kon siut nal oen in ketan Una ngas nol banan. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Net ela kon, Un ina-aman nas nahkitu nol herang. Hidim Un ina ka tek noan, “Yesus! Tasao le Ku tao sus kaim eli lia? Auk nol Ku amam mi net lalan lo nol kaim nangan Ku isi, hidim kaim lako-pait pukiu le nuting Ku!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mo Yesus siut noan, “Tasao le maam nol paap susa-kae in nuting Au kia? Mi taan esan tuun! Auk muik in dake ne Auk Amang ngi Uma.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mo oen nangan taan Un in aa na nahin na isi lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hidi nam oen tilus pait lakos Nasaret. Yesus muid Un mama nol papa in prenta ngas. Kon Un mama pesang dais nas totoang se un dalen na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus tene le maa, Un koon na tuan nol kil taan apa ka keko lako. Ama Lamtua Allah nol atuli li kon namnau Una. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Dedeng na Tiberius daid kaiser le kil bandu se Roma taun hngul lima son. Pontius Pilatus daid gubernur se propinsi Yudea. Herodes daid gubernur se propinsi Galilea. Herodes kaka Filipus, daid gubernur se propinsi Iturea nol propinsi Trakonitis. Nol Lisanias daid gubernur se propinsi Abilene. Hanas nol Kayafas kon daid tuang tene deng tulu agama Yahudi las se kota Yerusalem. Lam oras na, Yuhanis, Sakarias ana ka, daad se maan in ete tuun katang nol ingu las. Se na, Ama Lamtua Allah bel Un in hida ngas se Yuhanis. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ming hidi kon, Yuhanis lako se totoang ingu-iung man in dadani nol palun Yordan nas, le tek atuli las noan, “Mi musti hao, le nang soleng mi in kula-sala ngas totoang, halin nam Ama Lamtua Allah kose soleng mi in kula-sala ngas. Hidim mi musti sarani, le halin daid tada noan, mi babanan nol Ama Lamtua son.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hmunan nu, Ama Lamtua mee-baah Yesaya ka dul son deng Yuhanis noan, “Muik atuli mes ne maan in muik atuil lo haman tek mumuun noan, ‘Totoang atuli li mana-mana le daek babanan lalan na, halin sium Ama Lamtua in maa kia! Tao titu lalan na le sodo-sium Una. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Boa titu dale hnubun nas. Tutu leten nas le tatai. Tao titu lalan hilu las. Lalan buk-bakin nas taos le doson. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nang le totoang atuil in deng bangsa-bangsa li ngias, taan haup noan, Ama Lamtua le bel boa-blingin atuli li deng oen in kula-sala ngas.’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Atuli hut mamo maa deng ola-ol le nodan Yuhanis sarain one. Mo un baet oen noan, “Hoe! Atuil in nole-lilung daat me! Mi niam tuladang el ul in muik lasong nga! Mi bali le mi putim nal deng Ama Lamtua hukung nga nini lalan in hlak le pesang deng mi in kula-sala ngas se! Loo! Ta nesang lo ka kam, Ama Lamtua nahu hukung bel totoang atuil man pesang baktetebes lo ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mi nangan noan, ‘Auk haup in hukung lo, undeng auk niam upung Abraham in hua-koet’ deken! Ta hapun deng ol le ela la? In ela na tulung nal mi lo, undeng na tao mi le daid atuil niu lo. Ama Lamtua daek nal batu-baut nias le daid upung Abraham in hua-koet. Auk tek mia le! Tulu mi in nuli ka noan, mi bali kudi nang soleng mi in kula-sala ngas son, le muid se Ama Lamtua. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mi musti daek dais banan nas. Eta lo kam, Ama Lamtua hukung in naih tom mia ka, ngele, banansila el atuli dait soleng kai ina ka deng klaput ta nini taa. Ela son na! Kai ina in muik isin banan lo ka, muik ambak lo! Tiata in banan dui ka, dait soleng hidim pasang tamang lako ai dalen.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Hidi kon atuil hut mamo kas ketan Yuhanis noan, “Tiata kaim musti tao elola la?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kon un situs noan, “Eta ku muik kado dua lam, bel mes se atuil in muik kaod lo ngas. Eta ku muik in kaa kam, bating bel atuil man muik in kaa lo ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Hidim atuil in sium bea ngas maas le nodan Yuhanis sarain one. Oen ketan un noan, “Ama guru! Kaim musti tao elola la?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Un situs noan, “Mi kom in nole-lilung daat. Mo kilan deng leol neot nia, mi musti daek lolo-lolo tia. Eta sium bea lam mamo dui deng pamarenta la atorang nga deken. Nang le hutu las baen bea muid atorang nga.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Muik tentara at ila lo kon se na. Oen ketan Yuhanis elia, “Etan kami lam, elola la? Kaim musti tao elola la?” Kon un situs noan, “Boel nuhu-dau atuli las duit tas muid mi in koma ka deken. Nol tukut-klaa atuil dadahut deken. Molam mi musti dalen kolo, nol gaji man mi in sium nol niu na.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ming un aa ela kon, atuli las totoang kisi apa le hulu-hulu noan, “Idaah! Tamlom mo Yuhanis nia mo Kristus man hmunan nu Ama Lamtua hid son le tunang maa ka le?!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mo Yuhanis kaing oen noan, “Hii babanan! Mam muik Atuling mes le maa, Un uhu dui deng au. Suma daid Un atulin in loka-loka tuun kon no, auk tatai lo. Auk suma sarain mi nini ui tuun, mo mam Un in dake ka uhu dui deng au. Ta mam Un tao inu mi dalen nas nini Ama Lamtua Koo Niu ka. Nol Un tao niu mia, banansila el atuli in nini ai le loe soleng hlukat ta. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Un hukung atuil in tao kula ngas, banansila el atuil in daek klapa ngas nini angin, le huu soleng ael aha ka deng ael beas sa ka. Hidi nam un pesang ael niu ka lako se tongleo dalen, mo loe soleng ael aha kas. Ela kon nol atuil man in tao kula-sala ngas. Mam Kristus hukung one, nini in pasang tamang oen lakos ai man in maet taan lo ka dalen.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nini ela, Yuhanis tek nuting atuli las dasi mamo-mamo, nol tekas deng Ama Lamtua Dehet Dais Banan na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Dedeng na, Yuhanis kon aa langa-langa deng Herodes in tao kula ngas. Un dehet ta elia: Herodes na mo, gubernur se propinsi Galilea. Un in tao kula ka mamo isi son. Tuladang el un nuu nal un palin na sapa-bihatan na, ngala Herodias. Molota un palin na nuli nabale, hidim dai nol Herodias lo bii. Herodes lalan in nuli man tom lo na, man tao Yuhanis le kaing un langa-langa, dadin nam Herodes koon-mali isi nol una la. Tiata Herodes tadu un atulin nas daek Yuhanis le pasang tamang lako bui dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hmunan nua, oras oen daek Yuhanis lo bii ka, un sarain atuli hut mamo. Nol un kon sarain Yesus. Hidi kon Yesus kohe-kanas, ti apan na holsai. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kon nam Ama Lamtua Allah Koo Niu ka niu maa se Una. Koo Niu na tuladang el korkifi ka. Hidim muik fala mes deng apan nu tek noan, “Ku niam, Auk Anang in namnau ka. Ku tao Auk daleng ngi kolo tutungus.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Dedeng Yesus nikit in tek atuli las deng Ama Lamtua lalan in nuli ka ka, nataka le Un umur taun buk tilu. Atuli las tana ka noan, Yesus na mo Yusuf ana. Yusuf upu kia-kaon nas, elia: Yusuf ama ka ngala, Eli. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ama ka ngala, Matat. Matat ama ka ngala, Lewi. Lewi ama ka ngala, Melki. Melki ama ka ngala, Yanai. Yanai ama ka ngala, Yusuf. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf ama ka ngala, Matatias. Matatias ama ka ngala, Amos. Amos ama ka ngala, Nahum. Nahum ama ka ngala, Hesli. Hesli ama ka ngala, Nagai. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ama ka ngala, Maat. Maat ama ka ngala, Matatias. Matatias ama ka ngala, Semein. Semein ama ka ngala, Yosek. Yosek ama ka ngala, Yoda. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda ama ka ngala, Yohanan. Yohanan ama ka ngala, Resa. Resa ama ka ngala, Serubabel. Serubabel ama ka ngala, Selatiel. Selatiel ama ka ngala, Neri. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ama ka ngala, Melki. Melki ama ka ngala, Adi. Adi ama ka ngala, Kosam. Kosam ama ka ngala, Elmadam. Elmadam ama ka ngala, Er. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ama ka ngala, Yosua. Yosua ama ka ngala, Elieser. Elieser ama ka ngala, Yorim. Yorim ama ka ngala, Matat. Matat ama ka ngala, Lewi. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi ama ka ngala, Simeon. Simeon ama ka ngala, Yahuda. Yahuda ama ka ngala, Yusuf. Yusuf ama ka ngala, Yonam. Yonam ama ka ngala, Elyakim. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim ama ka ngala, Melea. Melea ama ka ngala, Mena. Mena ama ka ngala, Matata. Matata ama ka ngala, Natan. Natan ama ka ngala, Daud. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud ama ka ngala, Isai. Isai ama ka ngala, Obet. Obet ama ka ngala, Boas. Boas ama ka ngala, Salmun. Salmun ama ka ngala, Nahason. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason ama ka ngala, Aminadab. Aminadab ama ka ngala, Admin. Admin ama ka ngala, Ami. Ami ama ka ngala, Hesron. Hesron ama ka ngala, Peres. Peres ama ka ngala, Yahuda. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda ama ka ngala, Yakob. Yakob ama ka ngala, Isak. Isak ama ka ngala, Abraham. Abraham ama ka ngala, Tera. Tera ama ka ngala, Nahor. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ama ka ngala, Seruk. Seruk ama ka ngala, Rehu. Rehu ama ka ngala, Pelek. Pelek ama ka ngala, Eber. Eber ama ka ngala, Sela. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela ama ka ngala, Kenan. Kenan ama ka ngala, Arpaksad. Arpaksad ama ka ngala, Sem. Sem ama ka ngala, Noh. Noh ama ka ngala, Lamek. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ama ka ngala, Metusalak. Metusalak ama ka ngala, Henok. Henok ama ka ngala, Yared. Yared ama ka ngala, Mahalalel. Mahalalel ama ka ngala, Kenan. ");
INSERT INTO hegNTpo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ama ka ngala, Enos. Enos ama ka ngala, Set. Set ama ka ngala, Adam. Adam nam mo, Ama Lamtua Allah ana in koet ta. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nikit Yuhanis sarain hidi Yesus kon, Yesus lako nang palun Yordan. Ama Lamtua Koo Niu ka leo-leo nol Una. Hidim Koo Niu ka kil nol Un lako se maan in ete tuun mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesus daad se la didiin lelo buk aat. Mo leol buk aat nas Un kaa sa-saa mes lo kon, tiata Un lubu isi. Kon uikjale kas laih tuan na maa neleng soba-naan Una. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Un aa nol Yesus noan, “Eta meman Ku niam Lamtua Allah Ana kam, Ku muik kuasa. Tiata tadu baut nias le daid ruti, halin nam Ku kaa tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mo Yesus situn noan, “Ku taan loo ke?! Ta dulan son ne Ama Lamtua Allah Buk Niu ka dalen noan, ‘Atuli li nuli suma undeng in kaa sii lo!’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hidi nam uikjale kas laih tuan na kil nol Un lako se maan in lapa mesa. Kon un tulu belen totoang pamarenta in se apan-kloma ki ngias nol oen hmuki-nalan nas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Hidim un hanet Yesus noan, “Totoang pamarenta li nol oen in kuasa ngas, auk nena! Ela kon nol oen in muun-tes sas! Tiata auk muik hak le bel asii tukun, muid auk in koma kia. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Auk kom le bel Ku nias totoang. Suma Ku musti tao dasi mes muna le, halas-sam auk bel Kus. Kahan tuun! Ku suma todan-lahing se au! Na sii!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mo Yesus siut bali noan, “Hapun se ola na la? Ta ne Ama Lamtua Allah Buk Niu ka dul elia, ‘Ku musti todan-lahing se Ama Lamtua Allah sii. Nol ku musti lii-lau Una.’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Hidi na lam, uikjale kas laih tuan na kil nol Yesus lako se kota Yerusalem. Lius se las kon, un kil sakeng nol Yesus lako se Um in Kohe-kanas Tene ka maan in lapa dui ka. Hidim un tekan noan, “Eta meman Ku niam Ama Lamtua Allah Ana baktetebes sam, pul niu lako dale ku tia! ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ta muik dulan son ne Ama Lamtua Buk Niu ka noan, ‘Mam Ama Lamtua Allah tadu Un ima-ii las deng sorga, le doh Ku. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mam oen maas le tod Ku, halin nam Ku iim ma, binung tom baut ana mes lo kon.’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mo Yesus situn noan, “Boel liun Auk ela deken. Ta muik dulan ne Ama Lamtua Allah Buk Niu ka noan, ‘Sob Ama Lamtua Allah deken!’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Uikjale kas laih tuan na soba-naan Yesus nini lalan bili-ngala, mo nal Un lo. Kon nam un lako nang soleng Yesus, le natang oras banan pait. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Hidi na kon, Yesus pait lako propinsi Galilea, lole Ama Lamtua Koo Niu ka bel Un kuasa. Nesang lo kon, atuil in se dale Galilea ngas mulai ming hapu, nol taan deng Un ngala ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Un tui atuli las, se atuil Yahudi las um in kohe-kanas sas se ola-ola. Kon atuli las naka Un noan, “Yesus nam muun isi!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Oe mesan na, Yesus maa se iung Nasaret, na Un ingu-mana la. Tom nol atuil Yahudi las leol in Kohe-kanas sa, man oen noken noan ‘Sabat’, kon Un taam lako oen um in kohe-kanas sa banansila el in biasa ka. Hidim Un hangu dil le noan les deng Ama Lamtua Allah in Dula Niu ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kon oen doong belen upung Yesaya in dula ka. Ta Un bokan le nuting bango, hidim les elia, ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ama Lamtua Allah Koo la in kuasa ka muik ne Au. Undeng na le, Un tulu Au, le tek Ama Lamtua Dehet-dasin Banan na bel atuil kasiang ngas. Un nutus Auk son, le tekas noan, in ne bui daleng ngas, mam putis; atuil tedo kas, mam ngat net pait; man tom in tudan-kida ngas, mam haup in sas-sao. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ta halas ni Ama Lamtua oras sa maa lius son, le bel boa-blingin Un atulin nas.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Les hidi in dula na kon, Yesus lulun pait le tunang lako bel tulu in kil ibadat ta, hidim Un lako dada. Totoang atuil man se um in kohe-kanas sa dalen nas, ngat nakekeon Un tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kon Un tek oen noan, “Asa man mi in ming son deng Ama Lamtua Allah in Dula Niu apin na ka, halas ni daid son!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kon totoang atuil in se la ngas herang nol Yesus in aa ka, ta oen naka-naka Un noan, “Wuih! Asa man apin Un in aa ka, banan na le! Molota Un niam, Yusuf Ana ta lo? Taon elola le Un muun isi ela lia le?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kon Yesus situs elia, “Taon elola ko mi totoang tana le muik in teka noan, ‘Hoe dokter! Tao banan ku apam ma esa muna le!’ Mi le pake dais na le diuk bali Auk noan, ‘Tasao le Ku tao bel kaim taad herang lo, banansila el Ku in tao son se kota Kapernaum ma le?’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","In toma ka elia: atuli li dai sium Ama Lamtua mee-baha la, se un ingu-mana la esa lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Kat kleta deng Ama Lamtua mee-baah, upung Elia. Oe mesan na, ulan nauh lo taun tiul tailuang. Dedeng na, muik bebalu mamo se Israel. Mo Ama Lamtua nutus upung Elia le laok tulung oen se Israel lo. Ama Lamtua suma tunang un lako se blalan bihaat bebalu mesa, se iung Sarfat dani nol kota Sidon. Molota blalan bihatang na, atuil Yahudi lo. Mo un parsai Ama Lamtua Allah in kuasa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kat kleta didang pait deng Ama Lamtua mee-baah, Elisa. Dedeng na, muik atuil Yahudi mamo tom iil baih-bluku se Israel. Mo Ama Lamtua tao banan oen lo. Ama Lamtua suma lok Elisa le tao banan atuling in iil baih-bluku mesa, ngala Naaman. Molota un nam atuil Siria, mo atuil Yahudi lo. Molam un parsai Ama Lamtua Allah in kuasa ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nikit oen ming Yesus in aa ela ka kon, oen totoang komali isi nol Una. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tiata oen leo-leo hangus dil le nulut soleng Un deng um in kohe-kanas sa. Hidim oen pel nol Un lako se ingu la suut ta, le noan hutun nahu Un lako se hdoan in se na ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mo Un puit lako deng atuil hut mamo nas hlala, le nang soleng oen se las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hidi na kon, Yesus niu lako kota Kapernaum se tubu Galilea suut ta. Se lelo-leol in kohe-kanas sas sam, Un tui atuli las se um in kohe-kanas sa dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Atuli las herang-herang nol Un in dehet ta, lole Un taan baktetebes in tui ka isin nas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Oe mesa na, Yesus tui nabael se um in kohe-kanas sa lam, muik atuli mes uikjale taman, tiata un ahan mumuun le tek noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hoe! Yesus atuil Nasaret! Ku le tao saa kami la! Ku maa le tao didaan kami le? Kaim taan Ku. Ku niam, Atuil Niu, man hmunan nu Ama Lamtua Allah hid son le tunang maa ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mo Yesus naskaa un le tek noan, “Kuim ku baham ma! Puti deng atuling na tia!” Nahkitu lam, uikjale na late atuling na lako se dale ka, se atuil nas hlala. Late hidi kon, uikjale na puti deng atuling na, mo tao iil un lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Atuli las totoang ngaa-bahan undeng oen herang isi. Hidim oen tek noan, “Atuling ni in aa ka muik kuasa isi! Didiin uikjale kas kon muid Un in prenta ka, le putis deng atuli lia!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kilan deng na kon dehet deng Yesus, holhising lako papmes se ola-ola, se dale na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nikit oen putis deng um in kohe-kanas sa kon, Yesus lako se atuli mes uma. Atuling na ngala, Simun. Simun been na hed metes-otot, tiata un apa ka otot isi. Ta oen nodan Yesus noan, “Papa! Tulung tao banan bel kaim blalan ni le!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kon Yesus lako dil se maan in nini ka suut ta, hidim nulut puting in metes-otot na deng blalan bihatang na. Nol na kon, un in heda ka ilang meman. Kon nam un hangu meman le lako mana in kaa bel one. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lelo-hat ta, oras lelo la mana le dene kon, atuli las kil nol totoang atuil ili las laok bel Yesus. Oen ili las bili-ngala. Kon Un nene ima ka laok se atuil ili las, le tao banan oen totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Se atuil in iling nas kon muik at ila lo, tom uikjale. Mo Yesus prenta uikjale kas le putis deng atuil nas. Tiata oen lail putis nol ahan mumuun le tek noan, “Ku niam, Ama Lamtua Allah Ana!” Ta uikjale kas taan noan, Un na mo Kristus, man Ama Lamtua Allah in hid meman son deng lolo hmunan nua, le tunang maa ka. Undeng na le, Yesus kaing oen le boel aa dasi mes lo kon, deng Un apa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ola ka nukneha sain kon, Yesus hangu le lako se maan atuli in ase, se kota la likun na. Atuil hut mamo kas nuting Un lakos se ola-ola. Tutnalan kon, oen nodan Un noan, “Paap daad nol kaim tuun tia! Laok maan didang deken tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mo Un siut oen noan, “Auk musti laok ingu-iung tenga luas kon, le tek beles Dehet Dais Banan deng Ama Lamtua Allah prenta la. Ta Ama Lamtua nutus Auk son le daek os na.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kon Un laok deng ingu mesa laok iung tenga las, le tui se uma-um in kohe-kanas se propinsi Yudea. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Oe mesan na, Yesus tui atuli las se tubu Galilea suut ta. Atuli hut mamo maas le hii Ama Lamtua in Teka-teka ngas. Oen dil dising apa didiin bua pukiu Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Dadani se na, atuil tasi deeh tao niu oen pukat ta se tuu ka. Kon Yesus ngat net lui blo dua se na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Lui nas mesan na, Simun nena. Kon Yesus lako sake se Simun lui la, hidim nodan le hutun belen lui na lako el ui lihu ku bubuit. Un daad se lui na dapa le tui atuil hut mamo kas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tui hidi kon, Un aa nol Simun noan, “Simun! Keko laok bubuit el lihu kua, le nahu ku pukat ta se na. Ta mam mi haup ikan mamo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mo Simun siut noan, “Tuang kon no! Kaim daek hiti-late duman mes tetema son, mo haup ikan mes lo kon! Mo undeng Tuang tadu ela ta, kaim muid tuun! Auk niung soba-naan pukat tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hidi nam Oen niung pukat ta. Nikit oen le noan pel sakeng pukat ta lam, taan lo molota muik ikan mamo isi inu pukat na son, didiin pukat ta le sait. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kon Simun haman un tapan deng lui didang ngas le maa hulung one. Hidim oen dauk tamang ikan nas lakos se lui dua nas, didiin lui dua nas le meles tetetas undeng ikan inu. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Simun tapan atuil tasi kas, nol Yakobus duas Yuhanis, ama Sabadeus anan nas, se na kon. Oen herang isi nol oen in nal ikan mamo isi ela ka. Nikit Simun Petrus net in daid son na kon, un hai buku ka se Yesus sila ka, le tek noan, “Auk tao kula-sala mamo isi son. Tiata banan dui ka Tuang dani-dani nol auk pait bakun tia.” Mo Yesus situn noan, “Simun! Nangan muun isi nol dais na deken, ta Auk le pake mia. Taom mi nuting ikan. Mo nol nia, Auk tui mi le laok nuting atuli, halin muid se Au.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nol na kon, oen pel nol oen lui las le laok pesang se tuu ka. Hidim oen nang soleng totoang nas, le lakos muid Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Se ingu mesa, Yesus tutnaal atuli mes man apa ka totoang inu nol iil baih-bluku. Nikit un ngat net Yesus kon, un lako hai buku ka nol bubu sila ka lako huud se dale ka. Hidim un tekan noan, “Papa boa-ili! Tulung auk le! Ta auk tana le Paap tao ilang nal auk ili lia, halin nam atuli las nikis auk bakun tia. Sadi Paap tade.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kon Yesus doong ima ka le kapas una. Hidim aa noan, “Auk tade! Tiata ku banan tia!” Aa hidi ela kon, atuling na in iil baih-bluku ka ilang meman. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kon Yesus hid un meman noan, “Nangan babanan! Ku banan son mo boel tek asii deken ne! Ku musti muid upung Musa in prenta ka muna. Tiata lako se tulu agama lu le un tinang ku apam ma, halin un taan noan ku ili la ilang baktetebes son tam lo bii ka. Hidim ku musti bel nasar le daid taad in nodan mamo, halin atuli las totoang tana noan ku banan baktetebes son.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yesus kaing ela kon no, dehet deng Un in kuasa ka holhising deng baha laok baha, lako pes se ola-ola. Tiata atuli las taan in baa maa tutungus le hii Un in tui ngas. Hidim Un tao banan atuli mamo deng oen ili koed-ngasing ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mo Yesus kom in hoen apa ka deng atuil hut mamo kas, le lako kohe-kanas se maan atuli in ase. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Oe mesan na, Yesus tui atuil se uma mesa. Dedeng na muik atuil deng partei agama Farisi nol guru agama at ila lo, maas muid kon le hii Yesus. Oen maas deng ingu-iung in se propinsi Galilea, propinsi Yudea, nol kota Yerusalem. Ama Lamtua Allah bel Yesus kuasa le tao banan atuil ili las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Dedeng na, atuli at ila lo dohang atuil lukut-hkait mes se maan in dohang dapa. Oen nuting lalan mumuun le nol atuling lukut-hkait na laok bel Yesus, halin nam Un tao banan. Mo atuli las tep isi son se um na, didiin oen dising le taam kon bolen lo. Tiata oen kil sakeng atuling hlukut-kait ta lako uma dapa. Hidim oen sukun tihi la, le lolo niung atuling lukut-hkait ta se maan in dohang nga dapa. Oen niung un se atuil hut mamo kas hlala titu se Yesus sila ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ngat net ela kon Yesus tana noan, oen parsai le Un tao banan nal oen tapan sa. Kon Un aa nol atuling lukut-hkait ta noan, “Ana! Auk kose soleng ku in kula-sala ngas son.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ming Yesus tek ela kon, atuil Farisi las nol guru-guru agama las keket apa noan, “Hoe! Suma Ama Lamtua Allah sii, man muik hak le kose soleng atuli li in kula-sala ngas. Lam Un nia mo asii le, didiin un tao apa ka banansila el Ama Lamtua Allah lia! Ni in bilu-aa talalun son!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mo Yesus taan oen dalen nas. Kon Un aa noan, “Tasao le mi nangan noan Auk in teka na bilu-aa kia? ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Auk niam Atuling Baktetebes sa. Nol Auk muik hak le bel boa-blingin atuli li deng oen in kula-sala ngas. Eta Auk suma tek atuling hlukut-kait ni noan, ‘Auk bel ampong ku deng ku in kula-sala ngas son,’ lam mi net Auk in muik kuasa ne apan-kloma ki ki lo. Mo eta Auk tekan noan, ‘Hangu tia! Kat ku maan in dohang nga le pait tia,’ le eta un hangu nol na kon, halas-sam mi net Auk in kuasa ka. Undeng na le, Auk tade tao banan atuling hlukut-kait nia, halin nam mi tana noan Auk muik hak, le bel ampong atuli li deng oen in kula-sala ngas.” Hidi nam Un bali le aa nol atuling hlukut-kait ta noan, “Haung dil tia! Nikit maan in dohang ku ka, le pait lako tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nahkiut tuun nam, atuling na hangu dil se atuil hut mamo kas silan, le nikit maan in dohang una ka. Hidim un pait lako nol in naka Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ngat net ela kon, atuli las totoang herang isi. Hidim oen nikit sakeng Ama Lamtua Allah ngala ka lapa-lapa noan, “Ama Lamtua nam ana lo koo, muun isi! Leol neot ni kit net dais man in muun isi dadi, nini kit matan beas esan!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nesang lo kon, Yesus puti deng um na, kon Un ngat net atuil in sium bea ngas at mes daad se um in sium bea ka. Atuling na ngala Lewi. Kon Yesus nusi un noan, “Maa le muid Au!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ming ela kon, Lewi hangu meman le muid Yesus, nol lako nang soleng totoang in se na ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Hidi nam, Lewi tao fesat tene mesa, le haep Yesus maa se un uma la. Un kon haep un tapan in sium bea ngas, nol haep atuil didang kon le maa muid fesat na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mo muik atuli deeh deng partei agama Farisi, nol guru agama las hmumemen le ahan Yesus ima-ii las noan, “Tasao le mi daad kaa nol atuil in tom lo ngas, banansila el atuil in sium bea nol atuil banan lo kas sia? Atuil banan ni niam boel buan nol atuil in ela ngas deken.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mo Yesus tekas elia, “Atuil in ili ngas meman parlu dokter. Mo atuil in banan son nas sam parlu lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Auk maang taung atuil in nataka apa ka tom son nas lo. Molam Auk maang taung atuil in tom lo ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Hidim atuil deng partei agama Farisi nol guru agama nas hmumemen le ahan Yesus kon noan, “Elia Papa! Yuhanis in Sarain Atuli ka ima-ii las telang, nol oen kon kohe-kanas tutungus. Atuil Farisi las ima-ii las kon ela. Mo taon elol le Paap ima-ii las taan in kaa-ninu tutungus sia? Oen taan in telang ngia tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mo Yesus situs nini kleta elia, “Meman mi tanan son le eta muik fesat in sapa kam, haep pas telang lo, molam oen totoang kaa didiin silis. Eta sapa-bikloben na bii nabael se la kam, taon elola ko oen totoang kaa leo-leo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mo mam oe mes le atuil didang daek lai-niin biklobeng in sapa ka le un tapan nas nangan nam susa, halas-sam oen telang.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hidi kon Yesus bel kleta mes pait elia, “Atuli li niam kat kitu balu tep mesa, le tapan laok se kaod blaan man in sait son na lo. Ta lo kam eta baes kaod na lam, kitu balu in tapan na naskumu, nol kaod blaan na kon sait taplaeng. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Ela kon, atuli sail tua balu laok se sapat pohen lo. Ta lo kam sapat ta hoen, kon tua ka baa soleng hidi. Tiata eta tua balu kam musti doan laok se sapat balu dalen. Nini ela lam Yesus tui oen noan, Un in tui balu kas kutang nol atuil Farisi las in tui blaan nas deken. ");
INSERT INTO hegNTpo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Atuil in niun net anggor uin blaan son na, kom in niun anggor uin balu lo, ta un tana noan, ‘Anggor uin in pesang blaan son na, man banan dui!’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Oe mesan na, tom nol atuil Yahudi las leol teen in dake kon, Yesus nol Un ima-ii las laok deng atuli las klapa dalen. Un ima-ii las nul ael-gandum isin in se oen silan na ngas hidim kisis le kaa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Se na, muik atuli at ila lo deng partei agama Farisi man kil dididi oen hadat Yahudi la. Oen net Yesus ima-ii las tao ela kon, oen kaing Un noan, “Tasao le Ku ima-ii las kaliut kit atorang agama la lia? Oen daek osa tom nol leol teen in dake! Ngat le! Oen ket ael-gandum nan. Tao ela deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Mo Yesus siut noan, “Elola la? Mi nangan net upung Daud dehet ta lo ke? Upung Daud nol un ima-ii las tain nas seen undeng oen lubus isi. Kon oen taam lakos Ama Lamtua Allah Hleep in Kohe-kanas sa, le kat ruti man tulu agama las in bel Ama Lamtua son nas, hidim oen kaas. Molota suma tulu agama las siis man boel in kaa ruti nas. Atuil didang ngam boel lo. Upung Daud kaa, mo muik atuli in bel kula one lo. Mi hnika el noan les taan Ama Lamtua Allah Buk Niu ka lo! ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tidi mi hngilan nas le hii babanan ne! Auk niam, Atuling Baktetebes sa. Auk muik hak le nutus noan, atuli li boel tao saa tom nol leol teen in dake.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Oe mesan na, tom nol leol teen in dake mes pait kon, Yesus lako tui se um in kohe-kanas mesa. Se na, muik biklobeng mes ima halin mate. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Se na kon, muik guru agama at ila lo nol atuli deeh deng partei agama Farisi, man nuting lalan le noan tao nahu Yesus. Kon oen nata-natang le tamlom mo Un tao banan atuling man ima halin na in mate ka, tom nol leol teen in dake ka. Ta nini ela lam, oen tudu nal Un se atuil hut mamo silan. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mo Yesus taan parsis oen in nangan na. Tiata Un haman atuling man ima halin in mate ka, le tekan noan, “Kaka! Maa dil se hlala ni le!” Kon un lako dil se hlala ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hidim Yesus ketan atuli las elia, “Olan Auk ketan mi napat le. Muid kit atorang agama lia lam, asa man boel kit daken tom nol leol teen in dake ka la? Kit daek sa-saa banan tamlom daat ta? Kit bel slamat atuli, tamlom tao didaan un in nuli ka la?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesus ngat pukiu one, hidim Un aa nol atuling man ima halin in mate ka noan, “Doong ku imam ma maa!” Kon un doong ima ka, ti un ima ka banan nol na kon. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Net ela kon, Yesus musu las komali isi. Hidim oen mulai nangan daat le nuting lalan elia, “Kit musti nuting lalan didang pait, le halin kiu nahu Una.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nesang lo kon, Yesus lako se leten mes le kohe-kanas. Un kohe-kanas se la duman mes tetema. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ola oskaong bii kon, Un haman nakbua totoang atuil in muid Una ngas, le huil nal atuli at hngul dua, halin daid Un atulin in nutus. Atuil man Un in huli ngas ngalan nas elia: ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simun (man Yesus haman noan ‘Petrus’), Anderias (Simun palin na), Yakobus, Yuhanis (Yakobus palin na), Filipus, Bartolomeos, ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius, Tomas, Yakobus (Alpius ana ka), Simun (man muid partei Selot), ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas (Yakobus ana ka), nol Yudas Iskariot (man mam hee soleng Yesus). ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nikit Yesus nol Un ima-ii las nius deng leten na kon, oen dil se dale titun mesa. Se na, muik atuli hut mamo maas nakbua. Oen maas deng propinsi Yudea, deng kota Yerusalem, deng Tirus nol Sidon, kota dua nas ne tasi suut. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Oen maas le noan hii se Yesus, nol muik in le nodan Un halin tao banan atuil in heda ngas. Kon Un tao banan one. Un kon tao banan atuil in tom uikjale kas, nol nulut puting uikjale deng atuli las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Totoang atuil nas kom le huud Una, ta eta oen huud toman nam, muik kuasa puit deng Una, le tao banan one. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Hidim Yesus bali saol Un ima-ii las, le tuis noan, “Ulat bating atuil kasiang ngas! Undeng Ama Lamtua Allah esa man daid mi Lahin banan na! ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ulat bating atuil in lubu ngas! Undeng mam Ama Lamtua man tao mi le silim. Ulat bating atuil in lilu nol dalen susa ngas! Undeng mam mi mail nol dalen kolo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Ulat bating atuil in tom susa undeng in muid Au, Atuling Baktetebes nia ngas! Undeng mam Ama Lamtua bel seda mi in tom susa na se sorga. Atuli las pesang dael nol mia, tamlom tao didaan mi ngaal banan na, tamlom tudan-kida mia, tamlom nulut soleng mi banansila el atuil daat ta kon no, mi ulat, undeng mam se sorga lam, Ama Lamtua nangan net mia. Tiata eta atuli tao sus mi ela son nam, tao teken mi dalen nas, nol mi kon musti dalen kolo tutungus! Herang deken, undeng atuil in tao sus mia hahalas nia ngas, oen upu kia-kaon nas esan kon tao sus Ama Lamtua Allah mee-baah hmuna-hmunan nua ngas. Tiata, eta mi haup in susa tuladang ela lam, tao mi dalen nas kolo tutungus, undeng mam Ama Lamtua balas bel mi mamo-mamo se sorga! ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mo atuil in muki ngas! Mi nahim tom in daat, undeng mi in nuil dalen kolo ka, suma pes se ni sii tuun! ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Atuil in sili ngas! Mi nahim tom in daat, undeng oras lubu in muun isi ka saek tom mia. Atuil in mail dadahut halas nia ngas! Mi nahim tom in daat, undeng in susa-daat ta maa tao mi le lilu hultotoen. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Atuil man kom naseke le haup todan nas! Mi nahim tom in daat, undeng hmunan nu mi upu kia-kaon nas kon, naka-naka mee-baah in dehet nole-lilung daat tas!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kon Yesus tupang napiut noan, “Tidi mi hngilan nas le hii babanan! Mi musti namnau mi musu las. Nol tao dais banan taung atuil in kom mi lo ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kohe-kanas le nodan Ama Lamtua Allah, halin tao dais banan bel atuil man in kolen-bahang mi ngas. Nol nodan Un le tao dais banan taung atuil in tao mi dadaat tas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Eta muik atuli in papas ku pipim halin na kam, nang le un papas taplaeng ku pipim halin na kon. Eta muik in nuhu-dau ku kaod metes sa kam, bel taplaeng ku kado la. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Eta muik atuli in nodan ku sa-saa mesa kam, belen tuun lako. Nol eta muik in kat lai-niin ku sa-saa mesa kam, nang le un palan tuun tia. Laok sium pait bakun na! ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ku musti tao saol atuil didang, banansila el ku in kom le oen tao saol ku ka kon. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ku kom in tulu namnau bel ku atulin esa nas. Na banan kon. Mo ela lam in muun ni saa? Ta atuil daat tas namnau oen atulin esan nas ela kon! ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Eta ku suma daek banan saol atuil in daek banan saol ku ngas sam, in muun ni ki ola la? Ta atuil daat tas taan in daek banan saol apa ela ka kon. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Eta ku suma bel duit se atuil in naut duit se ku, mo mam baen nal pait ta sam, in muun dui ki saa la? Ta atuil daat tas kon bel duit se atuil in naut duit tas, sadi ola bingin dua kam oen sium pait nol tetema. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mo in banan dui ka elia: namnau ku musu las! Nol tao dais banan saol one. Asa man oen parlun nam, beles tuun lako. Nangan noan oen bel pait nalan tam lo ka deken. Nini ela lam, mam Ama Lamtua Allah balas ku. Nol ku daid Ama Lamtua Allah Man Lapa Dudui ka ana. Undeng ku in nuli ka el ku Amam in kom le daek dais banan saol atuil daat ta ngas. Un kon daek dais banan saol atuil man nodan mamo taan lo ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tiata ku musti tulu dael in namnau saol atuli lia, banansila el ku Amam in ne sorga ku tulu in namnau bel ku ka kon.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesus tui napiut noan, “Sukat atuil deken, le halin nam atuli sukat bali ku deken. Kritik atuil deken, ta lo kam mam atuli kritik bali ku. Nadidingun atuli li in kula-sala ngas, le halin nam oen kon nadidingun ku in kula-sala ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Eta ku bel atuli li asa man oen in parlu ngas sam, mam ku haup pait. Mam Ama Lamtua mana le halin ku sium pait nol inu-inu. Na tuladang el atuli doan bula mamamo laok se blek in hnukat ta, hidim heko-heko nol tudan niung le nisi pait didiin inu lai-lisi. Ku in simu ka kon tuladang ela. Eta ku bel bubuit tam, ku kon sium pait bubuit. Mo eta ku in bele ka mamo kam, ku in sium pait ta kon mamo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus kon tui nini kleta le tek noan, “Atuil in tedo ka, taon elola ko tulu lalan bel atuil tedo tenga ka lo. Ta lo kam oen duas leo-leo naih taam lakos bolo dalen! ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nol tana-ana hkola li niam mo taon elola ko taan dui deng un gurun na lo! Mo eta un muid babanan un gurun na in tui ka lam, un daid nal tuladang el un gurun na kon. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Taom ku tadas bana-banan atuli li in kula ana blutu mesa ka. Mo ku in kula tetene na, ku nangan noan muik lo. Na hnika el ku net hmomos ana mes se atuli mes mata dalen. Molota kai hbatan tene mes keba ku matam ma, mo ku tanan lo! ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Taon elola le ku brain aa noan, ‘Pail-kaka! Maa le auk maid puting hmomos in mo ku matam beas sa ka le.’ Molota ku esa net saa lo, lole muik kai hbatan tene mes keba ku matam ma lam! Hoe! Meman ku niam atuil in sila-klup tuun! Tulung nikit soleng kai hbatan tene in mo ku matam ma ka le, halas-sam ku neta, le maid soleng nal hmomos ana in se ku tapam ma mata ka ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesus tui tapnaeng kleta mes pait noan, “Taon elola ko kai ina banan nam, puting isin daat lo. Nol kai ina daat tam, puting isin banan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Atuli li tadas taan kai ina ol man banan tam lo ka, deng un isin na. Totoang atuli li tana noan, taon elola ko atuli li nui kaut isin tamlom anggor isin deng kai ina in muik duli lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ela kon nol atuil in dalen niu ka, lako-daek dasi-dais banan nas. Mo atuil in dalen hmomos sa, lako-daek dasi-dais daat tas. Ta kit taan atuli li dalen baktetebes sa deng un dasin in aa ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Hidim Yesus tupang napiut noan, “Mi taan in haman Auk tutungus noan, ‘Tuang’. Mo tasao le mi dai muid Auk in aa ka lo kia? ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Atuil in maa le hii se Au, hidim daek muid Auk in aa ngas sa, un banansila el ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","atuil in le bangun-pii um in kuat. Un kali bolo netes sa bana-banan mulai deng dale boa, didiin haup baut telas. Hidim un daek netes sa se baut na dapa, halas-sam un bangun-pii uma la. Eta ui baa maa kam, um na heheon lo, undeng un netes sa dil didi son. ");
INSERT INTO hegNTpo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mo atuil in hii nol dalen tailuang tuun, hidim dai muid Auk in teka ka lo ka, un banansila el atuil in kom le bangun-pii uma la nol sadi tuun. Un daek netes lo, le suma bangun-pii um na se dale boa in se palun suut ta ka. Ti oras ui tene ka baa maa kon, kokon lail-niin um na didiin dudu-dudus!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tui hidi ela kon, Yesus pait lako kota Kapernaum. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Se na muik komendan tentara Romang mesa. Un muik aan in dake mesa man un parsain. Atuling in dake na nahi ili, nate bubuit tam mate. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tiata dedeng Komendan na ming haup dehet deng Yesus kon, un lok blalan Yahudi at ila lo, le laok nodan Yesus maa tao banan un ana in dake ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Oen hanet Yesus le bole lam Un muid one, le laok tao banan atuling na. Oen hanet Un noan, “Papa! Atuling Romang ni, atuil banan! Un haup in tulung deng Papa lam toma. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ta un bangun-pii um in kohe-kanas mes taung kita, undeng un namnau kit atuil Yahudi lia.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kon Yesus tade le lako muid one. Oen lakos lius uma la lo bii kam, komendan na tadu un tapa ka, le maa tek Yesus noan, “Tuang kae-kae le maa deen tia, ta auk tatai in sium Tuang se auk uma lia lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Nol auk kon tatai in maa ngada Tuang lo. Langa son noan Tuang muik kuasa. Tiata sadi Tuang aa tuun deng ia kon, taon elola ko auk anang in dake ki banan meman. Auk taan dais nia, undeng auk tuang ngas kon muik kuasa le prenta au. Nol auk kon muik kuasa le prenta auk tentara las. Eta auk prenta auk ima-ii la noan, ‘Laok se nua!’ Taon elola ko un lako. Eta auk tadu noan, ‘Maa se nia!’ Lam taon elola ko un maa. Nol eta auk tadu auk atulin in dake ngas noan, ‘Daek nia!’ Lam taon elola ko oen daek ela. Tiata, sadi Tuang aa tuun kon taon elola ko auk anang in dake ki, banan meman.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ming ela kon Yesus herang. Hidim Un bali saol atuil hut mamo in muid Una ngas le tekas noan, “Herang nge! Blaan ni eli son, mo Auk tutnaal atuil Yahudi mes lo kon, man parsai ka muun el atuling Romang nia!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tiata Yesus suma lako pes se la tuun. Hidim, komendan na tapan nas pait. Lius se komendan na uma la lam, oen net tana in dake ka banan son. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ola ka kon, Yesus nol ima-ii las bok lakos ingu mesa, ngala Nain. Muik atuli mamo man lakos leo-leo nol one. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Oras oen lakos dadani nol iung na hnaket in taam lako ka lam, muik atuli bua mes le puit lakos puan atuil in mate mesa. In mate na, bebalu mes ana biklobe man beas mes sii. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nikit Yesus net bihatang bebalu na kon, Un namnaun. Tiata Un aa nol blalan bihatang na noan, “Mama! Lilu bakun na tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hidi nam Yesus lako dadani le huud atuling hmate ka maan in dohang nga. Tiata atuil in dohang ngas dil tenes. Kon Yesus aa nol atuling in mate ka noan, “Pail ana! Hangu tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tukun nam tana ka nuli pait, le un hangu dada. Hidim un aa nol atuil in dil pukiu una ngas. Kon Yesus tek blalan bihatang nga noan, “Mama! Sium maam ana kia.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Totoang atuil in se la ngas, lii isi! Mo hidi nam oen naka-naka Ama Lamtua Allah noan, “Ama Lamtua Allah nutus Un mee-baha mes man muun isi bel kit son!” Tenga ka pait tek noan, “Ama Lamtua Allah maa ne kit hlala kia, le tulu bel kit Un dalen banan na son!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kon dehet na holhising lako papmes ola-ola se propinsi Yudea, lako lius se ingu-iung tenga las kon. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","20","Yuhanis in Sarain Atuli ka ima-ii las ming haup totoang asa man Yesus in dake ka son. Ta oen lakos dehet bel Yuhanis se bui ku dalen. Kon un tadu at dua lakos se Yesus le ketan noan, “Paap niam baktetebes Kristus man kaim in nata-natang nga le? Tamlom kaim musti natang atuil didang pait ta?” Tiata nikit oen tutnaal Yesus kon oen ketan ela. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Dedeng Yuhanis atulin in nutus sas biis se la sam, Yesus tao banan atuli hut mamo deng oen ili koed-ngasing ngas. Nol nulut puting uikjale deng atuil in tom uikjale ngas. Un kon tao banan atuil tedo kas le oen ngat net pait. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hidim Yesus tek Yuhanis ima-ii las noan, “Mi pait lakom le tek kaka Yuhanis deng totoang asa man mi in ming son, nol net esan son nas, banansila el Ama Lamtua Allah mee-baah Yesaya la in dul noan, ‘Atuil tedo kas, haup in neta pait. Atuil in hlukut-kait tas, laok nala. Atuil in iil baih-bluku ngas, daid banan. Atuil kiu kas, ming pait. Atuil in mate ngas, nulis pait. Atuil kasiang ngas, ming haup Dehet Banan na.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pait lakom le tek kaka Yuhanis noan, ‘Atuil in mae lo le sium Au ngas, taon elola ko mam oen ulat baktetebes.’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nikit Yuhanis ima-ii las pait kon nam, Yesus tek atuil hut mamo kas deng Yuhanis noan, “Dedeng mi laok nuting Yuhanis se maan in ete tuun nua ka, mi nangan noan laok tutnaal atuil tuladang elola la? Taon elola ko mi lakom se nua ka, le tutnaal atuil bloen-blahen tuladang el uun man alet lako-pait muid angin na lo! ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tamlom mi lakom le net atuil in pake kai-baut osa-osa lo, ta atuil tuladang ela ka suma daad ne sonaf dalen tuun! ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tiata mi le noan laok ngat asii se nua la? Mi nangan noan laok nuting Ama Lamtua mee-baha la le? Toma! Mo un na mo mee-baah in muun dui hihidi. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ta Buk Niu ka dul meman son deng Yuhanis elia, ‘Hii ke! Auk nutus Auk atulin nia, le laok bati lalan bel Ku.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Se apan-kloma kia, muik atuli mes lo kon, man muun dui deng Yuhanis. Mo se Ama Lamtua hutun nas sam, atuling in ana dui ka kon, muun dui deng Yuhanis.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Atuil man ming Yesus in dehet ta ngas, taan son noan, Ama Lamtua lalan na, lalan in nuil toma ka. Atuil in tokan bea ngas kon ela. Undeng hmunan nu Yuhanis sarain one nol tui oen son. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mo atuil deng partei agama Farisi nol atuil in taan hukung agama Yahudi ngas, dai muid Ama Lamtua Allah in koma ka lo. Tiata oen dai nodan Yuhanis le sarain oen lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kon Yesus keket oen noan, “Auk sukat atuil hahalas ni ngias nol asa la? Atuil nias atuil tuladang elola la? ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Oen nam tuladang el tana-anang in dada-daad tuun ne pasar ra ngas. Oen taan in kidu-ahan si-sii nol aa in tom lo ngas noan, ‘Kaim huu suling leo-leo son, mo mi tidan le dalen kolo lo. Hidim kaim tao dain in melang, mo mi lilu lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ta Yuhanis in Sarain Atuli ka niun anggor lo, nol un kom in telang, mo mi aa in tom lo bus una noan, ‘Un tom uikjale!’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mo halas ni Au, Atuling Baktetebes sia, niun anggor nol kaa ruti el in biasa ka. Kon mi noken Auk noan, ‘Un nam atuil man kom in kaa naseke! In mauh daat! Lako nakbua nol atuil in tokan bea ngas! Iin mes nol atuil in tom lo ngas! Un taan apa ka lo tetetas!’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mo mi taad Auk in aa nia le! Atuil in nangan taan baktetebes sas daek muid Ama Lamtua in koma ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Se kota na, muik atuil Farisi mesa ngala Simun. Oe mesan na, un haep Yesus le laok kaa fesat se un uma. Sium nal in haep na kon, Yesus nol Un ima-ii las lakos se Simun uma, hidim daad le kaa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Oras na, muik bihaat hmama mesa man ming haup noan, Yesus le maa kaa se na. Kon un taam maa kil nol mina bui bingis, man osa isi ngas se botor mesa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Un maa dadani Yesus deng klupu ka. Hidim un lako hai buku ka se Yesus iin na. Kon un lilu mumuun didiin un mata uin na nahi tom se Yesus iin nas. Ta un madis nini un klanga ka, hidim lik kuti-kuti Yesus iin nas. Hidi nam un doan mina bui bingis na laok se Yesus iin nas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simun taan bihatang na in dili-dada ka. Undeng na le, un nangan se un dalen na noan, “Ni daid taad son noan, Yesus niam Ama Lamtua Allah mee-baha lo! Eta noan baktetebes Ama Lamtua Allah man tunang Un maa kam, taon elola ko Yesus taan son noan, bihatang in kapas Una nia, bihaat hmama. Ama Lamtua Allah mee-baha la tuladang el Un lo, ta atuil niu kam boel dadani nol atuil hmomos lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mo Yesus taan asa man Simun in nangan na. Kon Un tek noan, “Kaka Simun, Auk le tek kaka dasi mesa.” Kon Simun situn noan, “Hao! Paap Guru aa tuun lako.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kon Yesus soleng dais nol una noan, “Muik atuli mesa, man taom bel atuli li duit le natu. Oe mesan na, un bel duit se atuil in natu at dua. Mesan na, un belen naut duit muti ngatus lima; mo mesan na pait suma buk lim sii. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mo lius in bel pait duit nas sam, oen duas bel pait nalas lo. Kon atuling in bel duit le natu na, namnau oen duas. Tiata un beles duas le baen oen hningin nas pait lo. Eta muid kaka Simun in nangan na lam, deng atuil at dua in naut duit nas, ol man namnau atuling in bel duit le natu ka dui la?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simun belen pes lo mo siut noan, “Taon elola ko in muik hningin mamo dui ka!” Yesus siut noan, “Toma kaka!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kon Un bali saol bihatang na, le tek Simun noan, “Olan kaka Simun ngat maa se bihatang nia. Oras Auk taam maang se kaka uma lia ka, kaka pesang ui le taung in boe Auk iing ngia muid kit hadat ta lo. Mo bihatang ni tao ngoe Auk iing ngi nini un mata uin na, hidim madin niu-niu nini un klanga ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nol apin Auk taam maang kaka uma lia ka, kaka Simun sodo-sium Auk le lik Auk muid kit hadat ta lo. Mo ninin deng Auk taam maang um ni dalen nia, bihatang ni teen tahan in lik Auk iing ngias lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Oras Auk in taam maa ka, kaka Simun kon nadidingun hadat in doan mina se atuling in maa ka bon na. Mo bihatang ni doan mina bui bingis man osa isi se Auk iing ngias son. ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kaka Simun hii babanan le! Bihatang ni in kula-sala ka meman mamo. Mo Ama Lamtua kose soleng totoang son, undeng un tulu un in namnau ka, nol un in nodan mamo ka, bel Auk son. Mo atuil in nataka apa ka le muik kula-salan mamo lo ka, un kon nataka kam haup in ampong mamo lo. Undeng na le un namnau taan lo, nol nangan in nodan mamo se Ama Lamtua lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Hidi kon Yesus aa nol bihatang na noan, “Auk kose soleng ku in kula-sala ngas son!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Atuli-atuil in daad le kaa leo-leo ngas, hulu-hulu apa noan, “Hoe! Un nangan noan Un nia mo asii la?! Le Un brain in bel ampong atuli li deng oen in kula-sala ngas sia! Molota suma Ama Lamtua Allah sii, man muik hak le kose soleng atuli li in kula-sala ngas!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mo Yesus tek bihatang na noan, “Undeng ku parsai Auk son, tiata Ama Lamtua bel boa-blingin ku son. Pait tia nol titu-tema!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nesang isi lo kon, Yesus nol Un ima-ii at hngul dua kas laok papmes kota-kota, nol ingu-iung in se la ngas. Un laok tek atuli las deng Ama Lamtua Allah in prenta ka. Na daid dehet banan taung one. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Se buan na dalen, muik bihata at ila lo kon lakos baba. Bihaat nias tenga ka hmunan nu tom ili bili-ngala, nol muik teng tom uikjale. Mo Yesus tao banan oen totoang son. Banansila el Maria deng iung Magdala. Hmunan nu, Yesus nulut puting uikjale iut deng un apa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Susana nol maam Yohana kon lakos baba. Maam Yohana nia mo, ama Kusa sapa. Ama Kusa na mo, tulu in daek se laih Herodes um lahi la. Nol muik bihaat didang mamo pait, man laok leo-leo nol Yesus nol Un ima-ii las. Bihaat nias pake oen duit esan, le baen bel Yesus nol Un ima-ii las, se lalan oen in lako ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Oe mesan na, atuli las puit maas deng ingu mamo le nuting Yesus. Nikit atuil hut mamo nas maas nakbua kon, Un nahdeh beles kleta mes elia: ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Muik atuil in daek klapa mes lako hising biin se un klapa la. Biin tenga las nahis se lalan. Oras atuli las lako-pait se na ka, oen kida-kida deng biin nas dapas. Hidim kee kas maa noto nulis. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Biin tenga las nahis tom se dale batu. Biin nas nupu hlapat mo oen bloen, lole ui dabun. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Biin tenga las pait nahis tom se maan duli. Ta nikit oen nupus kon, duli nas kadis teles. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mo biin tenga las pait tam, nahis tom se dale boa-mina. Oen nupus le nulis tene didiin muik isin. Biin nas isin le haup pait lalis ngatus.” Dehet hidi ela kon, Yesus hep Un kleta ka nol aa mumuun noan, “Mi in muik hngilan nas hii, le nangan ni babanan!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Hidi kon, Yesus ima-ii las ketan kleta na nahin na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Un situs noan, “Undeng mi muid Ama Lamtua Allah in koma ka baktetebes son, tiata Auk sai bel mi langa-langa, le halin nam mi taan Ama Lamtua lalan in prenta Un atulin nas elola ka. Mo atuil tenga las dai muid Ama Lamtua in koma ka lo. Tiata Auk tui oen nini kleta tuun. Ta Ama Lamtua mee-baha las dul meman son deng atuil nias elia, ‘Oen netan son, mo dai tanan lo. Oen ming son, mo dai muid lo.’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kon Yesus tek kleta na nahin na elia, “Bini la na mo, Ama Lamtua Allah in Teka-teka ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Biin in nahi se lalan na ka, mo atuil man ming Ama Lamtua in Teka-teka ngas, mo hidi kon uikjale kas laih tuan na maa nuhu-dau lai-niin Ama Lamtua in Teka-teka ka deng un dalen na. Nini ela lam, oen parsai Ama Lamtua lo, nol haup boa-blingin lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Biin man nahi se dale batu ka, mo atuil in hii Ama Lamtua in Teka-teka ka nol dael kolo. Mo oen klaput tas taam lihu lo. Oen mulai parsai, mo eta susa la saek tomas sam, oen nahis hlapat. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Biin man nahi se duli hlala ka, mo atuil in ming nol sium Ama Lamtua in Teka-teka ka. Mo nesang lo kon, oen nadidingun soleng in Teka-tekang nas, undeng oen kukaum dui nol in mana oen osa las, nol oen hmuki-nalan bili-ngalang ngas, hidim oen kom in nuil dael kolo tutungus. Tiata oen in parsai ka muik isin saa lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mo biin man nahi tom se dale boa-mina ka, mo atuil man dalen na lolo nol banan na. Nikit oen ming Ama Lamtua Allah in Teka-teka ka kon, oen pesang babanan se oen dalen nas. Nini ela lam, oen parsai napiut, nol daek nal dais banan mamo, banansila el biin man puting isin banan mamo ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Hidim Yesus aa pait noan, “Taon elola ko atuli li hoet hadut, hidim tunga-kobang nini mul-dale lo. Nol muik atuli in hoet hidi hadut tam, todo laok se hadang kloma lo! Ta eta taon ela lam, atuli ngat net un langa ka lo. Hadut man muik nahin na, mo in todo se maan lalapa, le halin nam un kaloen na laang atuil in taam maa bus el uma dale ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Totoang sa-saa man in buni hahalas nia ngas, taon elola ko mam putis nol langa. Nol totoang dais man halas ni atuli li tanan lo, taon elola ko mam atuli li taan hapun. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tiata mi musti nangan dais nias babanan. Atuil man parlu le taan baktetebes deng Ama Lamtua in koma ngas sa, taan taplaeng. Mo atuil man dai toe muid Ama Lamtua in koma ngas lo ka, ngengo keko lako.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Oe mesan na, Yesus kukaum nol atuil hut mamo kas sam, Un ina ka nol Un palin nas maas le noan tutnaal nol Una. Mo oen laok dadani nal el Una la lo, undeng atuli mamo isi. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kon muik atuli laok tek Yesus noan, “Papa! Paap ina ka nol palin nas maas dil ne likun nua. Oen le tutnaal nol Papa.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kon Un siut noan, “Hao! Mo elia: Auk inang nol pail-kakang baktetebes sas, mo atuil man in hii-ming Ama Lamtua Allah in Teka-teka ngas, hidim daek mudis sa.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Oe mesan na, Yesus nusi Un ima-ii las noan, “Maa le kit saek lui lakong tubu ku halin nua.” Kon oen saek lui mesa le lakos. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Oras oen in luan laa lakos sa, Yesus nini. Nesang lo kon, angin tuan na maa. Len na kon sail tama lui dalen. Oen le meles tetetas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Net ela kon Yesus ima-ii las buk-bangun Una, le tekan noan, “Tuang! Tuang nge! Haung tulung le! Ta kit le mel mateng son nian ne!” Kon nam Yesus hangu. Hidim Un kaing angin na nol len na noan, “Tenem tia!” Tukun nam len na nol angin na ete meman. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Hidi na kon, Un ngau Un ima-ii las noan, “Tasao le mi parsai Auk lo bii nabael tuun nia?” Oen lii nol herang. Hidim oen keket apa noan, “Idaa! Yesus nia mo asii le? Taon elol le Un prenta nal angin na nol len na le oen muid Un in koma ka lia le?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nesang lo kon, oen lakos lius se dale Gerasa, se tubu Galilea halin na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Se na, muik atuli mes tom uikjale blaan son. Un muik um lo, un suma daad se niut utu ngas tukun. Lelo-lelon nam un lako-pait nol luli-lulit tuun. Lole uikjale kas taan in prenta una tutungus. Atuli las but un oe-oe son nini ranteng nol laeng bisi, mo un tao nutus soleng. Hidim uikjale kas dising un le lail lako se maan in muik atuil lo. Nikit Yesus nol Un ima-ii las nius deng lui la kon, atuling nuin na laok maa saol Una. Atuling na ahan, hidim late apa se Yesus sila ka. Kon Yesus prenta noan, “Hoe, uikjale! Puti deng atuling na tia!” Kon atuling nuin na ahan noan, “Hoe! Poe-pet auk deken! Ta auk tana noan Ku nia mo Yesus, Ama Lamtua Allah in lapa dudui ka Ana! Tao sus auk deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesus keket un noan, “Ku ngalam sii la?” Kon uikjale na siut noan, “Legion, ta kaim niam mamo isi, tuladang el tentara lihu-lihu.” Un tek ela, lole uikjale mamo taam ne un apa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Uikjale nas taan in nodan Yesus si-sii le halin tadu oen lakos Bolo Susa-daat ta deken, man daid maan in dulu kuasa deng in daat tas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mo dadani se na, muik bahi mamo mukan-mukan le nuting in kaa se leten na peke ka. Kon uikjale nas nodan Yesus noan, “Tadu kaim le taam lakom se baih nuas tuun!” Kon Yesus tade. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hidi kon uikjale nas putis nang soleng biklobeng na, le lakos tamas se baih nas. Baih nas totoang daid nuin, kon oen lail dadahut nius deng leten na le pul muid hopiin na taam lakos tubu ka dalen. Tiata oen mel mates totoang se las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Net ela kon, atuil in doh bahi la ngas lail lakos papmes ingu-iung in se la ngas, le dehet deng nas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ming oen in dehet ela ka kon, atuil hut mamo kas puit lakos se maan na. Oen le net esan deng asa man in daid son na. Lius se las kon, oen ngat net atuling in tom uikjale ka daad ete-ete tuun son, dadani se Yesus iin na. Un pake kai-baut son nol un in nuin na kon ase son. Net ela kon, oen totoang lii. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Hidim atuil man apin net dais na in dadi ngas, tek atuil in maa babalung nas deng taon elola le atuling nuin na banan son na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kon totoang atuil Gerasa man in daad se dale na ngas, nodan Yesus le lako nang soleng one, undeng oen totoang lii isi. Kon Yesus nol Un ima-ii las sakes lui dapas, le noan pait lakos tubu Galilea halin nua. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mo atuling apin man tom uikjale ka, nodan tutungus se Yesus noan, “Papa! Nang le auk kon muid Papa!” Mo Yesus situn noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Eli tuun tia! Banan dui ka ku pait lako ku nenan nuas, le dehet bel oen deng Ama Lamtua Allah in banan na, man Un tao bel ku son na.” Hidi kon, atuling na laok pukiu kota na, le dehet atulis totoang deng Yesus in tao banan una ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Hidi na kon Yesus nol Un ima-ii las luan laa pait lakos tubu Galilea halin nua. Oras oen nius deng lui la lam, atuli hut mamo maas natang oen son. Oen maas nakbua le sodo-sium Una. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Se na kon, muik atuli mes ngala Yairus. Un nam mo tulu deng um in kohe-kanas se kota na. Un ana ka suma beas mes sii; aan bihata, umur taun hngul dua, mo un heda ngele, naha-bubuit tam mate. Nikit Yairus ngat net Yesus laok maa kon, un lail lako hai buku ka se Yesus sila ka. Un nodan Yesus le bole lam Yesus laok un uma lua, le tulung un ana bihata la. Tiata Yesus tade tukun nam oen lakos Yairus uma lu meman. Mo atuil hut mamo kas nodat lo, le lakos muid kon. Tiata oen laok nol in dising-dising apa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Muik bihata mes kon man laok muid one. Un in net bulan na baa buit-buit tene taan lo, taun hngul dua son. Un pake nuli un duit tas nol hmuki las le baen dokter ras son. Mo muik tahan in taih banan una lo. Un ili la taan in poe si-sii. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kon un maa dadani Yesus deng klupu ka. Hidim un depen nal Yesus kado la mumu ka. Nikit un depen toman kon, un in iil daal loos sa tene meman. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nahkitu lam Yesus laok napiut lo mo Un dili le ketan noan, “Asii man depen tom Au lia?” Mo muik tahan at mes in hao lo. Kon Petrus tek noan, “Tuang kon no! Atuil mamo nias laok dising apa elia lam! Oen taan in hutun deng klupu lua sii.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mo Yesus tekan noan, “Loo! Apin Auk nataka kam muik kuasa puit deng Auk apang ngia. Tiata Auk tana noan muik atuli mes depen tom Au.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nikit bihatang na taan noan un buni nal lo son kon, un lii isi. Un pepeten le hai buku ka se Yesus sila ka. Hidim un dehet puting totoang asa man un in tao son na, se atuil hut mamo kas silan. Hidim un tek noan, nikit un depen tom Yesus kon, un banan meman. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Hidi kon Yesus aa nolan noan, “Bata! Ku banan, undeng ku parsai se Au. Tiata pait nol dael kolo tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus aa mamaus nol bihatang na lam, Yairus atulin in dake mes lail maa tek Yairus noan, “Idah Papa! Paap ana ka nol kit lo son! Un mate son, tiata tao paisiin Paap Guru deken tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mo Yesus ming haup atuling na in teka ka kon, Un tek Yairus noan, “Kaka! Lii deken! Parsai se Ama Lamtua Allah tuun. Ta Un man bel slamat kaka ana ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Oen lakos lius se Yairus uma lua lam, atuli inu um na son. Oen lilu muun isi. Kon Yesus kaing oen noan, “Mi teen in lilu ka tia! Tana-bihatang ni mate lo. Un suma nini tuun!” Mo atuli las mail le liun sulan nol Una, lole oen net nol matan deng tana-bihatang na hngasa ka in nutus sa. Hidi kon Yesus nodan tana-bihatang na ina ka nol ama ka, Petrus, Yuhanis nol Yakobus le leo-leo nol Un taam lakos uma dalen. Atuil tenga las Un tadus le natang se likun na tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Oen tamas kon, Yesus kil tana-bihatang na se ima ka, le tekan noan, “Baat-ana! Hangu tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Suknahkitu lam, tana-bihatang na nuli pait, le hangu daad meman. Ta Yesus tadu un ina ka noan, “Belen ngae le un kaa tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tana-bihatang na ina-aman nas herang isi. Mo Yesus hid pesang one, le dehet heheon dais na laok se atuli las deken. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Oe mesan na, Yesus haman nakbua Un ima-ii at hngul dua kas, hidim Un bel oen kuasa le nulut nal uikjale, nol tao banan nal atuli las deng oen ili koed-ngasing ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Un nutus one, le laok tek atuli las deng Ama Lamtua Allah in kil prenta ka. Un kon nutus oen le tao banan atuil ili las se ola-ola. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mo Un tek oen noan, “Nangan babanan! Mi boel kil sa-saa se lalan deken. Laok nol kaod in se mi apan na ngas tuun. Kil hnikan deken, tas deken, in kaa se lalan deken, nol duit deken. Kaod in silu kon kil deken! ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Eta mi tamam se ingu mes le muik atuli tade in sium mia kam, laok daad nolas se oen uma. Boel huil um deken. Daad se lam, didiin mi bok lakom deng iung na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Eta mi taam lakom se ingu mesa, mo atuli-atuil in se la ngas sium mi lo, nol dai hii-ming se mi lo kam, haung bokam le nang one. Eta mi putim deng na lam, tao muid hadat ta, le sii soleng auh in se mi iin na ngas. Tek oen noan, ‘Mi dai ming lo, ta nang le mi lepa-haal mi in situ-tala ka esan!’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Hidi na kon ima-ii nas laok deng ingu mes laok ingu mesa. Oen tek atuli las deng Ama Lamtua Allah Dehet Banan na. Hidim oen kon tao banan atuil in ili ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Dedeng na, lahing Herodes Antipas kon ming haup dehet bili-ngala deng Yesus. Kon un nangan hapun lo, undeng muik atuli at ila lo tek noan, “Yesus na mo, Yuhanis in Sarain Atuli ka, un nuli pait son na.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Muik teng pait tek noan, “Un na mo, upung Elia man nuli pait son na.” Tenga las pait tam tek noan, “Un nam mo at mes deng Ama Lamtua mee-baah hmuna-hmunan nua ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mo Herodes nangan noan, “Dedeng na, auk tadu le dait nutus Yuhanis leo ka son. Mo un nuli pait son nia tam saa ke? Hidim at mes ni pait, asii nia le?” Kon un nuting lalan le tutnaal Yesus sil nol sila. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Oe mesan na kon, ima-ii man Yesus in nutus sas pait le nakbuan pait nol Una. Oen tek Un deng totoang asa man oen in daek nal son nas. Hidim Yesus nol Un ima-ii las ete-ete le lakos se mana mesa, dani nol iung Betsaida, halin oen teen in kae se las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mo atuil hut mamo kas ming haup noan, Yesus le lako bus el ola ka, ta oen laok muid Una. Kon Yesus sium oen nol babanan, hidim Un tao banan atuil in ili ngas totoang, nol Un dehet bel oen deng Ama Lamtua Allah in kil prenta ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lelo-hat son kon, Yesus ima-ii at hngul dua kas laok tek Un elia, “Banan dui ka, Paap tadu atuil nias le lakos se ingu-iung in dadani deng maan ni ngias, halin nuting oen in kaa esan. Nol nang le oen laok nuting maan taung oen in nini. Ta maan ni atuli ase elia lam, taon elol le oen haup in kaa kia?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Mo Yesus situs noan, “Elia! Nang le mi man bel oen in kaa!” Mo oen kaen noan, “Auu! Paap le! Hapun se ola la? Atuil nias lihu lim lisi! Na suma biklobe las siis, kaih bihata las nol tana-ana ngas lo bii! Hidim kaim ruti bua lim siis. Nol ikan kon teb dua siis. Eta Paap koma ka le kaim man nalo atuil unus tene nias sam, taon elol le kaim sos nal in kaa mamamo bel one la?!” Kon Yesus tadu oen noan, “Tek atuil nias le daad buan-buan, buan mesa lam at buk lima.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kon nam oen daek muid ela. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nikit atuli las totoang daad son kon, Yesus kat ruti bua lim nas nol ikan dua nas. Un ngada lako el apan nua le kohe-kanas nodan mamo. Hidim Un bilas-bilas ruti nol ikan nas, le doong bel Un ima-ii las halin laok bating bel atuli las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Oen totoang kaa didiin silis. Hidi nam ima-ii las kat nakbuan in kaa lisin nas sam, inu fuli hngul dua. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Oe mesan na, Yesus sii kohe-kanas se mana mesa. Kon Un ima-ii las lakos nakbua nol Una. Kohe-kanas hidi kon, Un ketan oen noan, “Mi ming-ming ngam atuli las tek le Auk nia mo asii la?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Oen siut noan, “Muik in tek noan Paap nia mo, Yuhanis in Sarain Atuil ka. Tenga las pait tek noan, bet Paap niam, upung Elia. Eta lo kam, at mes deng Ama Lamtua Allah mee-baah hmuna-hmunan nuas man nuli pait son nia.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kon Yesus keket oen pait noan, “Eta muid mia lam, Auk nia mo asii la?” Kon Petrus siut noan, “Paap nia mo Kristus, na Atuling man Ama Lamtua Allah tulu meman son deng lolo hmunan nua ka!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kon nam Yesus kaing one, le boel tek asii deen kon, noan Un na mo Kristus. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Hidi kon Yesus aa taplaeng pait noan, “Auk niam Atuling Baktetebes sa. Auk musti lepa-haal in susa-daat bili-ngala. Mam blalan-blalan hadat atuil Yahudi las, tulu agama las tene-tenen nas, nol guru-guru agama las dai sium noan, Auk nia mo Kristus lo. Hidim mam oen keo tele Au. Meman Auk mateng mo bingin dua ka lam, Auk nuling pait!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hidi nam Un tek atuil hut mamo kas noan, “Asii man kom le muid Au lam, un musti tahang le muid napiut lelo-lelon. Un musti sao soleng un in koma-koma ngas esan. Eta atuli tao un dadaat didiin keo tele kon, un musti muid napiut, tuladang el atuli haal un kai sangsuli la, le lako maan in mate kua. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ta atuil in tade le mate undeng muid Au, taon elola kon mam un haup in nuli napiut nol Ama Lamtua Allah. Mo atuil man suma kom le nuli taung un apa ka sii ka, mam bakisan katang deng Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Eta atuli li haup apan-kloma ki isin nias totoang, mo Ama Lamtua Allah hutun soleng una lam, un ontong ngi saa la? ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Auk nia mo Atuling Baktetebes sa. Tiata atuil in mae le muid Au, nol mae kil Auk in tui ngias sa, mam Auk kon mae in hao un se Ama Lamtua Allah sila, se oras Auk in pait maang deng sorga nga. Ta mam Auk niung maang nol Auk Amang ngu kuasa in muun isi ka, leo-leo nol Un ima-ii las deng sorga. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Auk tek mi baktetebes. At il deng mi in mo nia ngias, mam net nol matan esan deng Ama Lamtua in kil prenta ka, hidi halas-sam oen mates.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Hidi nal lelo paul kon, Yesus haman nal Petrus, Yuhanis nol Yakobus le oen leo-leo saek lakos se leten mes dapas halin kohe-kanas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesus kohe-kanas mamaus kon, Un hnika-tuladang nga daid kisaꞌ nol Un kai-batu las kon daid muti kaloeꞌ. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nahkiut tuun nam, atuli at dua puit maas. At dua nas, upung Musa nol upung Elia. Oen dehet nol Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Oen kon hnika-tuladang ngas muun isi. Oen tilus aa deng mam Yesus in maet se Yerusalem ma. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Oras na, Petrus nol un tapan at dua las matan tede isi, didiin oen niin nalas. Oen tilus nahkitus kon, oen ngat net Yesus dil nol atuli at dua. Oen kon ngat tam Yesus apa ka kaloe le langa isi. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ti upung Musa nol upung Elia mana le lakos kon, Petrus nangan taan le tao elola ka lo. Tiata un aa dadahut tuun noan, “Tuang! Se nia lam kaim nataka kam leok isi! Tiata banan dui ka kaim koet hlepe tiul se nia. Mes bel Tuang, mes bel upung Musa, nol mesan na pait bel upung Elia.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mo un aa mamaus ela lam, nopen mes niu maa kabut one. Kon nam Petrus nol un tapan nas lii isi. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hidim oen ming haup fala mes deng nopen na dalen tek noan, “Ni Auk Anang man Auk in huil meman son na! Un aa kam, hii babanan se Una!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aa ela hidi kon, Petrus nol un tapan nas ngat net Yesus sii son. Hidi nam, oen tilus ete tuun le dehet bel asii-asii lo, deng asa man oen in net son na. Nesa-nesang halas-sam oen bok bahan nas le dehet bel atuil didang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ola ka, Yesus nol Petrus nol un tapan nas nius deng leten na lam, atuli hut mamo maas tutnaal Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Muik atuli mes haman tek Un noan, “Paap Guru! Tulung maa ngat bel auk anang bikloeb siing ngi le! ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ta uikjale taan in kil una si-sii, le tao un ahan nahkekeka nol peko-peko un didiin kapen bulat puit deng un baha ka. Uikjale na kon diku-puang una, nol kus un tutungus. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Auk nodan tulung Paap anan nias son le nulut puting uikjale na, mo oen nulut puting nalan lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ming ela kon Yesus baet oen totoang le tekas noan, “Hoe! Mi parsai noan Ama Lamtua tao banan nal atuil lo ke? Mi niam meman atuil man in nuil muid lalan lolo ka lo ngas! Auk musti tahang le leo-leo nol mi didiin bling pait halas-sam mi parsai se Au la? Auk musti keeh nol mi didiin bling pait ta?” Hidim Un bali le aa nol blalan biklobeng na noan, “Kil nol ku anam ma maa se ni tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nikit oen kil nol tana na laok bel Yesus kon, uikjale ka late laok se dale ka, nol peko un apa ka, ta un hukun muun isi. Mo Yesus prenta uikjale na le puit nodat tana na, kon tana na banan meman. Hidi kon Yesus sao lako bel un ama ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Totoang atuil in net Ama Lamtua in kuasa man muun isi na, herang-herang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Oras atuli las dehet apa nabael deng tada-taad herang man Yesus in tao ngas sam, Un tek Un ima-ii las noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mi taad Auk in aa ni babanan! Nesang lo ka kam, atuli le hee soleng Au, Atuling Baktetebes nia. Hidim oen sao Auk lakong bel atuil didang.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mo Un ima-ii las nangan hapun lo tetetas. Oen nangan taan Un in aa na nahin na lo. Oen kon lii in ketan un nahin na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Oe mesan na, Yesus ima-ii las kaen apa deng asii man daid atuil hmunan na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mo Yesus taan oen in kaen apa na. Kon Un haman tana-ana blutu mesa, hidim tadu le dil se Un halin na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Hidim Un tek atuli las noan, “Hii babanan ne! Atuil in tade le lii-lau atuil ana el tana-ana nia ki, nahin na noan, atuling na kon lii-lau Au. Nol un kon lii-lau Auk Amang in ne sorga kua, man nutus Auk maang se apan-kloma kia. Muik atuli mamo man kom in ngat kabaul one. Tuladang el atuil kasiang, atuil in susa, atuil banan lo, atuil in nahi tom daat, nol atuil ana ngas. Atuil man kom le lii-lau atuil tuladang ela ngas, man Ama Lamtua Allah noken noan, un nam atuil in muun dui.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Hidim Yuhanis tek Yesus noan, “Papa! Oe mesan na, kaim net atuli mes nulut puting uikjale le busun nini Paap ngala ka. Tiata kaim kaing una le busun-busun nini Paap ngala ka deken, undeng un na mo, kit atulin lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mo Yesus situn noan, “Ela deken! Ta atuil man labang nol kit lo ka, nahin na noan, un nam mo kit tapans.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus taan noan Un lelon in saek lako sorga ka dadani son. Kon Un nutus le bok lako kota Yerusalem. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Un nutus atuil le lakos muna deng one, halin nam mana in kaa-ninu. Kon atuil in nutus nas taam lakos ingu mesa, se propinsi Samaria, le nuting maan in teen tahang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mo atuil Samaria las dai sium Yesus nol Un ima-ii las lo, undeng Un le lako todan-lahing Ama Lamtua Allah se kota Yerusalem. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nikit Yakobus nol Yuhanis ming haup atuil Samaria las in dai sium oen lo ka kon, oen hanet Yesus noan, “Tuang! Elola, tam kit nodan Ama Lamtua Allah le niung ai maa deng apan nua, halin loe nuli oen tuun tia la?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mo Yesus bali saol oen duas le kaing oen noan, “Boel nangan ela deken.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Hidim oen lakos napiut bus el iung didang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Oras oen in laok mamasu ka, muik atuli mes aa nol Yesus noan, “Papa! Paap laok elol tuun kon, auk le muid napiut Papa!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mo Yesus situn noan, “Banan kon! Mo nangan le ta: Totoang atuli li nol hmukit ti muik oen mana esa. Ngot huin pait lako un bolo. Tilu-kee pait lako un hno. Mo Au, Atuling Baktetebes nia, muik Un uma esa le pait lako se na lo. Maan in tian bon kon ase.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Oe mesan na, Yesus haman atuil didang mes pait noan, “Maa le muid Au halin daid Auk atulin.” Atuling na siut noan, “Hao! Mo elia Tuang. Tahang le auk pait laok doha-tinang blalan nuas muna. Le eta auk papa mate son, halas-sam auk mudi.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mo Yesus tekan noan, “Elia! Nang le atuil man kom le muid Auk lo ngas, mana-koet oen atulin in mate ngas. Mo mi man parsai se Ama Lamtua nol kom le muid Au ngas, mi osa la laok tek atuli li deng Ama Lamtua Allah in kil prenta ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Muik atuli mes pait tek noan, “Banan kon, Tuang! Auk tade le muid Tuang tutungus. Mo bel auk dola le auk laok liki mo seon auk nenan nuas muna le, halas-sam auk pait maa le muid Tuang.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mo Yesus tekan noan, “Elia! Eta atuli li bali dale, hidim kukaum nol in daek os didang, didiin nadidingun soleng in hai kam, un klapa la daid lo. Ela kon nol atuil in nutus le muid Au, mo nangan un in nuli hmunan nu tutungus sa. Atuil tuladang ela ka, muik ambak in daek se Ama Lamtua Allah sonaf fa lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hidi nam, Yesus huil nal ima-ii didang pait at buk itu beas dua. Hidim Un bating oen at dua-dua, le oen lakos muna se mana-maan Un in le lako ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Un nutus oen noan, “Muik atuli mamo man banansila el ael in latu son na. Liis klapa lamtua ka tadu atuil in dake ngas le maa nul tuun. Tiata mi musti kohe-kanas le nodan Ama Lamtua Allah, tunang taplaeng Un atulin in dake ngas, halin tao nakbua atuli-atuil in le muid Au ngas. Undeng atuil in le muid Au ngas, mamo. Mo atuil in dake ngas suma bubuit sii. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mi bok lakom nol ni tia! Auk nutus mi le lakom se atuil hut mamo kas. Mo nangan ta, mi tuladang el lae-blai ana man dalen banan, lako se ngot huin man daat isi ngas hlala. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mi boel kil duit tam, tas in nisi kai-batu tam, kil nahan dui deng apa mes se lalan deken. Boel soleng oras le aa nol atuil didang se lalan deken. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","8","Eta mi taam lakom se ingu mesa lam, mi boel daad seda-seda se um didang deken. Eta atuli sium mi babanan se uma mesa lam, daad se um na tuun didiin mi haung bokam deng iung na. Eta mi taam lakom se uma mesa lam, mi musti nodan le Ama Lamtua Allah bel hangun se um na isin nas. Eta um lamtua ka sium mi nol babanan nam, taon elola ko Ama Lamtua tulu Un dalen banan na bel uma isin nas. Mo eta oen sium mi lo kam, nang le Ama Lamtua tulu Un dalen banan na bel mi siim tuun. Eta mi tamam se uma mesa, tam ingu mesa, le oen bel mi in kaa-ninu saa tuun kon, sium nol dael kolo. Ta toma eta oen bel mi ela, le seda mi lating nga. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tao banan oen atulin in heda ngas. Nol tekas noan, ‘Ama Lamtua Allah prenta la maa dadani son!’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mo muik ingu dehe man un atulin nas dai sium mi lo. Etan oen tao ela nol mia lam, laok dil se iung na lalan na, le tekas noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Hii babanan! Kaim maam son le kil Ama Lamtua in Teka-teka ngas bel mia, mo mi tiu-hii bubuit lo kon. Tiata kaim sii soleng kota ni ahu las deng kaim iin nias, le daid tada noan, mam mi lepa-haal in naih tom mi ngas esan! Mo nangan bana-banan! Ta Ama Lamtua Allah in prenta ka maa dadani isi son!’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yesus tekas pait noan, “Mi taan kota Sodom in daat isi ka son, ta loo? Auk tek mia le! Mam se leol Kiamat tia lam, hukung man Ama Lamtua in nahu bel atuli-atuil in hutun soleng mia ngas, ngele dui hihidi deng atuil Sodom mas.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesus aa taplaeng pait noan, “Mi in ne iung Korasin nol iung Betsaida ngas, doha lo! Ta in daat ta nahi tom mia! Auk tao taad herang bili-ngala se mi sila-matan son, mo mi dai parsai se Ama Lamtua Allah lo. Molota, mi niam atuil Yahudi man hao le taan Una. Mo eta noan tada-taad herang man Auk in tao se mi ingu la ngas, daid se kota Tirus nol kota Sidon nam, taon elola ko nesang ngi eli son ta, atuli-atuil in se lua ngas pesang son, nol nang soleng oen in kula-kula ngas, le bali muid se Ama Lamtua. Nol taon elola ko oen pake kai-baut susa, hidim tao auh laok se oen bon nas, halin daid tada noan, oen sabail apan deng oen in kula-sala ngas. Molota atuil Tirus nol Sidon nias, atuil Yahudi lo, mo oen hao le taan Ama Lamtua. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Baktebes! Mi ngat esan tuun! Mam eta Ama Lamtua nutus totoang atuli li dasi las sam, atuli-atuil in se Tirus nol Sidon nas hukung nga kahan dui deng, mi hukung nga. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mi atuil in se kota Kapernaum mas doha lo! Nangan noan mam Ama Lamtua nikit sakeng mi lakom sorgam deken. Ta ela lo! Mam Ama Lamtua pasang tamang mi lakom se naraka lu dalem! ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nangan bana-banan! Ta atuil in hii-ming mia ngas, oen kon hii-ming se Au. Nol atuil man dai hii-ming se mi lo ngas, oen kon hii-ming se Auk lo. Taplaeng pait, atuil man dai hii-ming se Auk lo ngas, oen dai hii-ming lo se Ama Lamtua Allah, man nutus Auk son le maang se apan-kloma kia ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Dedeng atuil in nutus at buk itu beas dua kas pait maas sa, oen dalen kolo isi. Hidim oen tek Yesus elia, “Idaah! Muun isi! Dedeng kaim pake Tuang ngala ka le nulut puting uikjale kas sa, uikjale kas ming kami, le lail putis deng atuli las meman. Ana lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kon Yesus situs noan, “Baktebes! Oras mi in tao ela ka, Auk ngat net Ama Lamtua Allah pasang soleng uikjale kas nol oen tuang nga deng apan nua, banansila el bisain dait kliu-kanan se apan nua! ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nangan ne! Uikjale kas laih tuan na, kit musu. Nol un kon muik in kuasa! Mo Auk bel mi kuasa son le tao tehen un in kuasa ka. Nol eta noan mi kida tom ul in muik lasong, tamlom hkulang kon mi sa-saa lo. Muik tahan in tao daat saol mia lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mi dalen kolo, undeng uikjale kas ming mia. Banan kon, mo na dais ana tuun! Banan dui ka mi dalen kolo, undeng Ama Lamtua dul mi ngalan nas son, le daid Un nenan in taam sorga.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Dedeng na, Ama Lamtua Koo Niu ka tao Yesus dalen kolo. Hidim Un naka Ama Lamtua noan, “Papa! Paap man daid Tuang Tene se apan-dapa kua nol apan-kloma kia. Auk nodan mamo-mamo, undeng Paap hep kele dais nias deng atuil man in tao apa ka noan tana, nol atuil in nikit-nikit apan na ngas. Mo Paap sai dais nias totoang bel tana-ana ngas, nol atuil in tao dalen deng dadale ngas. Baktebes Papa! Ta na man tao Paap dalen kolo!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Hidim Yesus tek atuil hut mamo kas noan, “Hii ke! Auk Amang in ne sorga ku bel Auk kuasa las totoang son. Man in taan baktetebes noan, Auk nia mo asii ka, suma Paap sii. Nol in taan baktetebes noan Paap na mo asii ka, suma Paap Ana ka sii, na Au. Nol Auk kon huil atuil didang le tek one, halin oen kon taan Papa.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Hidim Yesus bali saol Un ima-ii las le tek oen siis noan, “Mi ulat baktetebes, undeng mi net Ama Lamtua in kuasa ka esan son. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Lahi-lahi, nol Ama Lamtua mee-baah hmuna-hmunan nuas, kom isi le net asa man mi in net son nias, mo oen netas lo. Oen kon kom isi le ming asa man mi in ming son nias, mo oen ming hapus lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Oe mesan na, atuil in taan hukung Yahudi mes le noan kiu nahu Yesus. Ta un hangu dil le ketan noan, “Paap Guru! Tulung tek auk le! Auk musti tao elola, le halin auk haup in nuli napiut leo-leo nol Ama Lamtua se sorgang nga?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus situn noan, “Upung Musa in dul deng dais nia ki elola, nol ku in nangan tanan na elola la?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Atuling na situn noan, “Un dul elia: ‘Ku musti namnau Ama Lamtua Allah, ku Tuang nga, dui deng totoang. Undeng na, ku musti nangan net Un tutungus, daek mumuun le muid Un in koma ka, nol nangan taan se Una.’ Muik in dula kon noan, ‘Ku musti namnau ku pali-kakam mas, el ku in namnau ku apam ma esa ka.’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus situn noan, “Toma! Eta ku tao muid ela lam, ku nuli napiut nol Ama Lamtua.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mo atuling na tao apa ka banansila el atuil in parsai isi ka. Hidim un keket Yesus noan, “Lam auk kaak-paling ngias mo asiis sa?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kon Yesus siut noan, “Auk le bel kleta mesa. Ta mam ku tek Au, le ol man baktetebes ‘pail-kaka’ la. Un dehet ta elia: Muik atuil Yahudi mes bok deng kota Yerusalem, niu lako kota Yeriko. Mo nahkiut tuun nam, atuil in nako ngas maas diku-puang una. Oen diku-puang una, hidim nuhu-dau nal un duit tas, nol un kai-batu las totoang. Hidi nam oen pasang soleng un lako se lalan suut ta, le bok lakos nang soleng una. Atuling na naha-bubuit tam mate. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nesang lo kon, tulu agama Yahudi las mes niu maa lako deng lalan na. Mo nikit un ngat net atuling na nini batlenga nol apa ka papa si-sii se lalan suut ta, kon un tene le tulung atuling na lo. Mo un sisa lako lalan halin, le laok napiut. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nesang lom, muik atuli mes didang pait maa lako deng na. Un nam deng ngaal Lewi, man taom daek hulung se Ama Lamtua Allah Um in Kohe-kanas Tene ka. Nikit un ngat atuling na se lalan suut ta kon, un laok tinang dadani tuun, mo tulung atuling papa na lo. Hidim un sisa lako lalan halin, le laok napiut. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","Ti nesang lo kon, atuli mes deng dale Samaria maa lako deng na nol un keledai la. Atuil Yahudi las taom ngat maat halin tuun nol atuil Samaria las. Mo nikit atuling Samaria nga ngat net atuling man tom in nuhu-dau na kon, un dalen kasiang nolan. Ta un lako dadani le tulung atuling na. Un doan anggor le boe atuling na papa las, hidim un mutis nini mina nol nius babanan nini kitu, le nikit sakeng lako se un keledai la dapa. Hidi kon un kil nol atuling na lako lius se kota la. Tukun nam un nolan lako tahang se um in hani mesa, hidim un mana atuling na bana-banan. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ola ka kon, atuling Samaria nga laok bel dopat duit muti dua se um in hani ka lamtua ka, hidim un tekan noan, ‘Pake duit nias le urus bana-banan atuling papa na, didiin un banan. Eta nol lo kam, pake tahang ama duit. Ta eta auk pait maang ngam, auk bel seda ama duit tas totoang.’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus in kleta ka pes ela. Hidim Un ketan atuling in taan hukung nga noan, “Muid ku lam, ol man baktetebes ‘pail-kaak’ taung atuling man tom in nuhu-dau ka la?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kon nam atuling na siut noan, “Taon elola ko atuling in dalen kasiang nol una ka.” Yesus tekan noan, “Toma kaka! Lako tia, le daek muid ela.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","40","Hidi na kon, Yesus nol Un ima-ii las laok napiut lakos bus el Yerusalem. Oen tuil se ingu mesa. Se la muik kaka-pali at dua, ngalans Marta nol Maria. Marta nodan le Yesus nol ima-ii las tuil se un uma. Kon nam oen daad tahang se las. Oras Yesus daad le tui atuli las sa, Marta sii man kukaum in mana kaa-ninu se dapur ra. Mo un palin Maria daad dadani se Yesus iin na, le hii Un in teka ngas. Nesang lo kon Marta taam maa le muhmemen se Yesus sila ka, hidim un tek noan, “Papa! Elol nia la! Auk kukamu ana lo nol mana-koet in kaa-ninu, mo auk paling ngi daad babanan tuun mo nia lam. Tulung le! Tadu un le hulung auk buit se dapur ru le!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mo Lamtua Yesus siut noan, “Marta, Marta. Ku kukamu nol lii-tiud isi le nangan bili-ngala. ");
INSERT INTO hegNTpo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Banan, mo muik dasi mes man banan dui. Daad le hii Auk in Teka-teka ngias sa, Maria huil tom banan dui nga son na. Atuli nuhu-dau nal in Teka-teka nas deng un lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Oe mesan na, Yesus lako kohe-kanas. Kohe-kanas hidi kon, Un ima-ii las at mes maa le nodan Un noan, “Papa! Yuhanis in Sarani Atuli ka tui un anan nas son, le oen kohe-kanas tana. Kaim nodan le Paap tui kaim in kohe-kanas kon!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kon Yesus tek noan, “Banan kon! Kohe-kanas sam not muid nia: Papa! Paap ngala ka niu dui hihidi. Nang le totoang atuli li nikit sakeng Paap ngala man muun dudui ka lapa-lapa! Nang le Paap daid Laih taung totoang atuli lia! ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Paap tulung bel kaim hnaad in kaa nola, se lelo-lelon. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kaim nodan Paap le nadidingun soleng kaim in kula-sala ngas, banansila el kaim kon nadidingun atuli li in tao kula saol kami ngas. Paap doh kaim le halin nam kaim daek dadaat deken.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Hidim Yesus tui taplaeng oen pait deng dais in kohe-kanas. Un nini kleta elia, “Eta noan duman bingin-tai kon, ku tapam mes deng lalan katang maa, le nini tahang se ku uma. Mo ku muik sa-saa in bel un le kaa lo. Kon ku lako se ku tapam mes didang pait uma, le nodan-nodan deng likun na noan, ‘Kaka ku! Bel tahang auk ruti bua tiul le! Ta muik atuli in maa ne auk uma lua, mo auk muik sa-saa in bel un le kaa lo! Kaka tulung le! Bua tiul siis! Tiam mam auk bel sedas!’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bet ku tapam ma siut bali ku noan, ‘Kaka kon ne! Atuli niin nala son mo ku maa naisiin pait! Hnita kias kon hkaen teles son nian! Tana-anang ngias kon niin nalas son. Komali deken ne! Oe mes lolen kaka!’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mo ela kon no, nangan babanan. Atuling na hangu le bel ku lo, undeng ku nia mo un tapa, mo eta ku taan in nodan-nodan si-sii kam, taon elola ko un hangu le bel ku. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ela kon nol in kohe-kanas. Nodan tutungus se Ama Lamtua; tiam Un bele. Nuting tutungus; tiam Un tulu bel lalan. Haman tutungus; tiam Un sai hnita ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ta totoang atuil man in nodan tutungus se Ama Lamtua Allah ngas, mam simu. In nuting tutungus sas taon elola ko, mam hapu. In haman tutungus sas, mam Un sai hnita ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Olan mi nangan soba-nanan! Hapun se ola le muik ama mes, eta un ana ka nodan ikan nam un belen ula la! ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tamlom eta un ana ka nodan manu tilun nam, un belen hkulang nga! Muik lo, ta loo? ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Atuli li dalen ni niam meman daat. Mo mi Aman in ne sorga ku, Un dalen na banan baktetebes. Tiata eta atuil daat tuladang el mia li ki kon, kom in bel sa-saa banan se mi anan nas sam, salolen le Ama ka! Un suma bel mi asa man mi in parlu ngas siis lo, mo dui deng na. Un bel Un Koo Niu ka se atuil in nodan Una ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Oe mesan na, Yesus nulut puting uikjale deng atuling ngengo mesa, kon nam atuling na aa nal meman. Ta atuil in se la ngas herang-herang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mo muik in tek noan, “Meman Un nulut nal uikjale, lole Un haup kuaas deng Balsebul, uikjale kas laih tuan na lam.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Atuil tenga las sam le soba-naan Yesus. Kon oen nodan Un le tao taad herang mes pait, halin tulu bel noan, Un in kuasa ka meman deng Ama Lamtua. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mo Yesus taan oen in nangan dadaat na. Tiata Un aa noan, “Etan se negara mes dalen, le un hutun nas mus nol apa kam, taon elola ko negara na dudu-dudus. Ela kon se uma mes dalen, etan uma la isin nas nuil nol in kaen apa tutungus sam, taon elola ko um-elan na daid daat! ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tiata eta uikjale kas taan in mus nol apa si-sii le nulut bali apa kam, taon elola ko oen tuang nga in kil prenta ka nesang lo! Ta eta mi tek noan, Auk nini uikjale kas in kuasa, le nulut bali uikjale kas sam, tom nol kit in nangan lo! ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nangan ne! Mi atulin nas kon nulut taan uikjale. Lam oen pake kuasa deng uikjale kia le? Lo ta loo! Tiata mi aa dadahut deken noan, Auk pake uikjale kas in kuasa le nulut bali uikjale. Mam mi atulin nas esan man nutus noan, asa man mi in aa na, kula. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mo eta baktetebes Auk nulut uikjale kas nini kuasa deng Ama Lamtua Allah lam, na tulu bel noan Ama Lamtua in prenta ka muik ne mi sila-matan son. Mo mi hnika el noan tanan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Eta atuil kuat mes le pake lelat-suli kliu-kanan, halin doh un uma la babanan nam, taon elola ko un sa-saa las bana-banan tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mo mam muik in kuat dui deng una, maa tao tehen una, nol nuhu-dau nal atuling na lelat-suli kas. Hidim un dauk lai-niin atuling na hmuki-nalan nas, le kilas laok bating bel un ima-ii las. Bablaan ni, atuling in kuat hmunan na, parsai un lelat-suli kas. Mo halas ni un nahlae lelat-suli nas pait lo son. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nangan bana-banan! Asii man buan nol Auk lo kam, un na mo Auk musu. Nol asii man hulung Auk in dake ki lo kam, un nam tao didaan tukun.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus aa taplaeng pait noan, “Eta kit nulut uikjale le puti deng atuli mesa lam, un lako maan in ete tuun le nuting maan in tene se la. Undeng un haup maan in tom nol un dalen na lo, kon un nangan noan, ‘Eeh! Haup maan lo elia lam, banan dui ka auk pait lakong daad se atuling hmunan nua ka.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hidim un pait, kon un ngat net maan na niu, nol mana bana-banan son. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tiata uikjale na lako haman un tapan nas at itu, man daat dui deng una. Hidim oen totoang lakos daad se atuling na, ta atuling na in nuli ka daat dui pait deng hmunan nua.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Oras Yesus dehet nabael nol atuil hut mamo kas sam, bihata mes se na aa mumuun noan, “Ku inam ma ulat isi, undeng un man hua Ku, nol nusu Ku!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesus situn noan, “Baktebes Mama! Mo in ulat dudui pait ta, mo atuil man tidi hngila ka le hii Ama Lamtua Allah in Teka-teka ngas, hidim daek mudis sa!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yesus aa mamasu lam, atuil hut mamo kas maas dil nakbua pukiu Una. Kon Un aa le tek noan, “Atuil hahalas ni ngias, suma taan in daek daat si-sii. Oen nodan tutungus le Auk tao taad herang bel one, halin oen taan noan, Auk niam baktetebes Ama Lamtua atulin. Molota hmunan nu Ama Lamtua beles taad herang son, nini Un mee-baah Yunus. Na nol son! ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Hmunan nua, Yunus tek atuil Niniwe las noan, oen musti pesang deng oen in kula-sala ngas tia. Asa man in daid nol Yunus sa, daid taad bel atuil in se kota Niniwe ngas noan, Ama Lamtua Allah man nutus una. Ela kon nol Au, Atuling Baktetebes sia. Auk maang le tek mi halin mi pesang deng mi in kula-sala ngas tia. Nol mam asa man in daid se Au kia, daid taad bel atuil hahalas ni ngias noan, meman Ama Lamtua Allah man nutus Au. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mam se leol kiamat tia lam, eta Ama Lamtua dil le daid Atuil in Nutus Dasi kam, ina lahi in deng loet-ahen nu nuli pait, nol dil le daid saksi. Un tulu hnanga ka le klaa nol mi totoang man in nuil hahalas ni ngias noan, ‘Mi totoang niam ngengom!’ Hmunan nu lahing bihatang na maa deng maan katang le tinang nol mata esa lahing Soleman in tana ka. Molota halas ni muik Atuli mes ne mi hlala ka, taan dui laih Soleman. Mo mi dai tiu-hii Un bubuit lo kon! ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nol un sii tuun lo! Mam atuil deng Niniwe kon hangus dil le tulu hnangan nol mi man nuil hahalas ni ngias noan, ‘Mi niam ngengom totoang!’ Oen aa ela, undeng dedeng Yunus laok tek Ama Lamtua in koma ka bel one la, oen pesang meman. Molota halas ni Atuling in muun dui deng Yunus mes muik ne mi hlala kia, mo mi dai pesang lo tetetas!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus tupang Un in dehet ta pait noan, “Atuli hoet hadut hidim todo se maan lalapa, le halin un laang kamar ra bel totoang atuil in taam laok se la ngas. Muik atuli hoet hadut hidim tungan nini fai, le buni tele lo! Ta na muik ambak saa lo! ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mi matan nas kon banansila el hadut ta. Un tao langa mi dalen nas. Eta matan langa lo kam, atuli li ngat totoang sa-saa lias nini dalen daat. Mo etan matan langa kam, atuli li ngat totoang nol dael banan. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nuklek le halin langa in ne mi dalen na ngas, daid langa bosor banansila el lelo la langa ka. Langa in se mi dalen na ngas, boel banansila el bulan na langa man suma tulu hlen tuun na deken. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Eta mi dalen nas langa, didiin hapit ana mes kon muik mitang lo kam, taon elola ko mi in nuli ka totoang kon langa, banansila el hadut tene mes laang bel mi in nuli ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus aa hidi kon, muik atuli mes deng partei agama Farisi, haep Un le laok kaa se un uma. Lakos lius se luas kon, Yesus taam lako napiut uma dalen le daad se mija in kaa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Um lamtua ka daid herang nol in ngat Yesus daad le kaa, mo haun ima ka muna muid atuil Farisi las atorang nga lo ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kon Yesus tek un noan, “Mi atuil Farisi las ana lo! Mi kil dididi mi atorang agama la! Mi nangan le tao niu mi pingas-klas sas likun nas didiin loe, mo mi nangan le tao niu mi dalen hmomos man daat nol kom naseke ngas lo! ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ngengom me! Nadidingun deken. Ama Lamtua Allah man koet likun na, nol Un kon man koet dalen na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mo in banan dui ka, mi bel atuil kasiang ngas deng asa man mi mukin, le halin nam mi daid niu se Ama Lamtua sila. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Atuil Farisi me! Mam mi kon nahim tom in daat! Deng in bel Ama Lamtua op mes deng hngulu kam, mi kaih totoang tuan-ana. Didiin bumbu ana mes deng mi klapa la kon, mi kaih tele! Mo mi tiu-hii dais man muun dui ngas lo. Deng in namnau Ama Lamtua Allah, nol dais lolo kas sam, mi nadidingun soleng ela tuun! Meman kit musti bel Ama Lamtua nenang nga, mo nadidingun dais in muun dui tenga las deken. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mam mi haup in daat! Ta taom mi kom le nuting maan in banan dui se um in kohe-kanas sas dalen, nol kom le nuting in todan se mana-maan in muik atuli hut mamo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mam mi nahim tom in daat! Ta mi banansila el niut utu man in tatai nol dale ka son na. Atuli lako-pait deng na, mo oen taan lo noan muik niut utu se na. Undeng dale in bua niut utu na ka doson nol niu son, mo un dalen na hoso. Molota muid kit hadat tia lam, atuil in kida niut utu ka, tao hmomos un apa ka son na, tiata un taam um in kohe-kanas sa lam, tom lo. Mi atuil Farisi lias banansila el niut utu na! Se likun nam mi hnika el niu isi. Molota mi dalen nas inu nol dais hoso.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Muik atuil in taan hukung Yahudi mes se la, siut tading Yesus in aa ka noan, “Paap Guru! Paap dais in aa apin na, diuk tom kaim kon!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kon nam Yesus situn noan, “Toma! Mi atuil in taan hukung Yahudi ngas, nang le mi kon haup in daat! Mi tulung atuil le tao kahan un in nuli ka lo, mo mi tao sus taplaeng one, nini mi atorang agama ngele kas. Hidim mi sakeng bel atuli li le lep mi atorang bili-ngalang nas. Mo mi esan lep hulung in ngelen na, nini hnaang mes lo kon! ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mi haup in daat! Ta mi kukaum nol in babail batu-baut tada, bel Ama Lamtua mee-baah hmunan-hmunan nuas, le todan one. Molota mi upu kia-kaon nas esan man keo tele mee-baah nas! ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mi kon iin mes nol mi upu kia-kaon nas. Oen hutun soleng Ama Lamtua mee-baha las nol keo tele one. Hidim mi babail niut klaten bel mee-baah nas, le daid tada noan, mi kon tade muid mi upu kia-kaon nas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Undeng na, Ama Lamtua Allah man taan totoang sa-saa lias sa, tek net son noan, ‘Mam Auk nutus Auk mee-baha las nol atuil in nutus tenga, le lakos se atuli Israel las. Kon atuil nas diku-puang tenga las, nol keo tele tenga.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Atuil in nuil hahalas nia ngas, musti lepa-haal in situ-tala, deng atuli-atuil man in keo tele Ama Lamtua mee-baha las son nas. Na kahin deng Ama Lamtua in koet apan-kloma kia. Kilan deng Habel in mate ka, lako pes puis sa Sakarias. Sakarias tom in keo se Ama Lamtua Allah Um in Kohe-kanas Tene ka Kamar Niu ka, nol maan in tunu-dadung nga hlala. Mam mi man lepa-haal oen hukung nga! ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mi atuil in taan hukung Yahudi ngas! Mam mi nahim tom daat! Ta mi man kil hkaen le sai hnita, halin nam atuli li taan haup Ama Lamtua Allah in koma ka nol babanan. Mo mi esan taam laok se na lo. In daat dui pait ta, mi keba kele atuli, le halin oen taam laok nal se na lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesus aa hidi kon, guru-guru agama nas nol atuil Farisi las komali isi nol Una. Kilan deng leol neot na, oen taan in ketan bili-ngala le kiu nahu Una. Oen kon nuting lalan tutungus le tao dais nol Una. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dedeng na, muik atuli at lihu ila lo maas le hii-ming se Yesus. Oen laok dising apa didiin bua nal Una. Kon Un aa muna nol Un ima-ii las noan, “Doh mi apan nas le muid atuil Farisi las in hlak daat ta deken. Ta taom oen aa kam kisa, mo dake lam kisa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Oen hlak le banan, mo mam oen in hlak na puti le atuli ngat tanan. Ta totoang man in buni hahalas nia ngas, mam ngat netas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Asa man mi aa nol buni-buni hahalas nia ngas, mam atuli ming hapus nol langa-langa. Asa man mi hulu-hulu se kamar dalen, mam atuli aa mumuun se atuil hut mamo sila.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesus aa tapnaeng pait noan, “Auk anang me! Lii deken eta atuli le keo mia. Ta oen keo nal mi apan nas tuun, mo tao nal saa lo nol mi hmangin nas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Auk le tek mi noan, mi musti lii se asii. Mi musti lii se Ama Lamtua Allah sii. Ta Un man keo nal mia, hidim pasang tamang mi lakom naraka dalem. Tiata Una, man mi musti liin baktetebes. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Olan mi nangan soba-nanan le, kee ale la osa ka bakun na? Osa lo dui, ta lo? Kee lima lam, duit seng dua ta lo? Mo ela kon no, Ama Lamtua Allah nadidingun tahan mes lo kon. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ela kon Ama Lamtua paiduil nol mia. Un taan parsis klanga bakun ne mi bon nas. Tiata mi lii deken, ta Ama Lamtua in sukat mia ka osa dui deng kee ael nas totoang.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Hidim Yesus aa pait nol Un ima-ii las noan, “Tidi mi hngilan nas babanan! Eta muik atuli brain hao Auk se atuil hut mamo in ne apan-kloma ki ngias silan nam, mam Auk kon hao un se Ama Lamtua Allah ima-ii in ne sorga nguas silan noan, un na mo Auk atulin. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mo eta atuil in aa se atuli las silan noan, un taan Auk lo, kam mam Auk kon aa se Ama Lamtua Allah ima-ii in ne sorga nguas silan noan, Auk taan un lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Auk niam, Atuling Baktetebes sa. Eta muik atuli in aa le tao didaan Auk ngaal banan nia kam, Ama Lamtua Allah tade le nadidingun un in kula-sala na nabale. Mo eta un aa le tao didaan Ama Lamtua Koo Niu ka ngaal banan na lam, Ama Lamtua Allah nadidingun soleng un in kula-sala na lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Eta mam atuli li pel nol mi lakom se maan in nehan dais agama ngas, tamlom se atuil in kil prenta ngas, undeng mi in parsai se Au ka lam, lii in mam siut puting nal mi apan nas elola ka deken. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ta se oras na lam, Ama Lamtua Allah Koo Niu ka tui mi in teka-teka man tom nol in siut one.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hidi na kon, at mes deng atuil hut mamo kas keket Yesus noan, “Paap Guru! Tulung tadu auk kakang nga le bating kaim aman sa hmuki-pusakan nas tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mo Yesus siut un noan, “Hoe! Asii man nikit Auk le nutus mi duam dasi la lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hidim Yesus aa nol atuil hut mamo nas noan, “Mi musti doha-doha, le boel kom naseke deken! Ta muik hmuki mamo kon temang nal in nuil titu-tema lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Hidi kon Un dehet nini kleta mes pait noan, “Muik atuil in muki mesa, un klapa la muik isin mamo isi, ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","didiin un maan in dulu ngas inu lai-lisi, tiata un taan le taos elol pait ta lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kon nam un nutus noan, ‘Auk taos eli tuun! Auk sukun maan in duluꞌ blaan nia, le daek seda tene dui pait, hidim pesang auk klapa li isin nas nol auk hmukin tenga las laok se na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Eta hidi ela son nam, auk aa nol auk apang ngi esa noan, “Maan in dulu ka inu son! In kaa nol son, le kaa didiin taun-taun. Tiata kaa-niun faal bana-banan tuun, le daad peko iin nol dael kolo tia!’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mo Ama Lamtua Allah tek un noan, ‘Hoe! Ku ngengo! Eta duman ni kon ku mate, kam asii man haup ku maan in dulu ka isin nas totoang ngia?’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tiata elia! Boel tuun, eta atuli li kom le dulu hmuki mamo-mamo se apan-kloma ki taung un apa ka esa, mo se Ama Lamtua Allah in nangan na lam, un atuil kasiang, undeng un babanan nol Ama Lamtua lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Hidim Yesus tui taplaeng Un ima-ii las pait noan, “Mi siin-tiud isi nol mi in nuli lelo-lelon na deken, noan le kaa saa tamlom le pake saa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ta kit in nuli ki dui deng asa man kit in kaa, nol asa man kit in pake ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ngat soba-naan kakaol mitang ngas! Oen soko-hai lo, nul lo, nol muik maan in dulu kakaat lo, mo Ama Lamtua Allah papa-piaar one. Eta ela lam, taon elola ko Un kon papa-piaar mia. Undeng Un sukat mia lam dui deng kee nas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Eta atuli dil saol hdidan, hidim kukaum nol un apa ka tuun nam, nataka le un tao blatas tapnaeng un in nuli ka le? Lo ta loo! ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tiata kukaum nol dais anang ela ngas sam kil isin sa-saa lo, kam, tasao le mi kukaum nabael nol dasi-dais tene kas sia? Un ambak ki saa la? ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Laok ngat soba-naan bunga in ne alas sua ngas. Oen daek klaap lo, nol tiun seman lo. Mo laih Soleman kai-baut in osa dui ngas kon, leok dui bunga in ne alas sua ngas lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ta Ama Lamtua Allah papa-piaar bluan ana man muik nahin saa lo, man suma nuli leol neot nia, mo ola kam mate, le atuli kat soleng tamang lako ai dalen na. Eta ela lam, Un kon papa-piaar nal mia, man osa dui deng bluan nas. Tiata tasao le mi nahlae baktetebes se Un tuun lo kia? ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ela kon mi lii-tiud nol in kaa-ninu deken. Ta mam Ama Lamtua man mana-koet. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Atuil in nahlae se Ama Lamtua lo ngas, daek hiti-late le mana-koet nas totoang. Mo mi ela deken, ta mi Aman in ne sorga ku taan totoang asa man mi in parlu ngas son. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ta mi lako-daek Ama Lamtua Allah osa las muna le, halas-sam Un kon mana dais nias bel mia.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Hidim Yesus tupang pait noan, “Mi tuladang el lae-blai buan ana mesa, man muik in muun-tes lo. Mo lii deken! Ta mi Aman in ne sorga ku na mo, Laih Tene. Asa man Un nena, kam, Un dalen kolo in bel Un anan man Un in namnau ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tiata laok hee soleng mi hmuki las, hidim duit ta laok bating bel atuil kasiang ngas. Nini ela lam, mi pesang hmuki-nal se sorga, se maan titu-tema kua. Atuil in nako ngas naok lai-niin nalan lo. Naen muti kon kaa didaan nalan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nangan babanan! Mi hmukin nas ne ola sam, mi dalen nas ne as kon.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yesus aa pait noan, “Lelo-duman nam mi musti mana le lii-lau Ama Lamtua tutungus. Tuladang el ata in melang, le natang um lamtua ka in pait deng fesat in sapa ka. Eta tuang nga bitin hnita ka lam, un hlapat sai. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Eta tuang nga maa haup un ata kas natang ela lam, taon elola ko oen ontong. Ta mam tuang nga esa, man tulu beles un dalen banan na. Hidim un pake kai-baut ata, le tutan-lau ata kas nol in kaa fala bana-banan sii. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ata nas meman ontong baktebes, undeng oen lii-lau tuang nga nol babanan. Tuang nga maa diuk ila tuun, bingin-tai tam, nukneha sain kon no, oen natang tutungus. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nangan babanan! Eta muik um lamtua mes taan parsis noan, diuk ila kam atuil in nako ngas maas sam, taon elola ko un bel dola le atuil in nakong nas sukun un uma la lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tiata mi musti mana tutungus, ta muik at mes lo kon man taan noan, blinga lam Atuling Baktetebes sa pait maa.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Hidim Petrus keket Yesus noan, “Paap Guru! Paap kleta apin na tom kaim siim, tamlom tom totoang atuli lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Kon Yesus siut noan, “Kleta na tom se totoang atuil man dake ka, banansila el tulu in mana tana nol makoe le daek taung un Tuang nga. Ta mam un tuang nga nikit un le bating in kaa bel ima-ii tenga las. Eta un makoe le daek muid un osa la ela lam, un tuang nga maa oras ol tuun kon no, un daek in toma ka tutungus. Hidim un haup ontong, undeng mam un tuang nga nikit una, le mana-koet un hmuki-nalan nas totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mo banan lo, eta tulu deng ata kas nangan noan, ‘Eh! Taon elola ko blalan na nesang, halas-sam pait maa.’ Kon un diku-puang ata tenga las, bihata tamlom biklobe. Hidim un daad le kaa-niun nol dael kolo didiin mahu. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mo oe mesan na, se oras tulu deng ata kas taan dadale lo kam, nahkitum un tuang nga maa. Kon tuang nga diku-puang una, hidim nulut soleng le haup un nenang nga se likun nua, leo-leo nol atuil man in dai muid napiut tuang nga in koma ka lo ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ta ata man taan parsis un tuang nga in koma ka, mo dai tade le muid lo, tamlom daek mudin lo ka, tom hukung ngele. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mo ata in daek kula undeng un taan un tuang nga in koma ka lo ka, tom hukung ngele lo. Ta atuil in sium mamo son na, un musti bel mamo kon. Nol asii daek os tene kam, un in lepa-hala ka kon tene.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesus tupang Un in aa ka pait noan, “Auk maang le tao bakisan Auk atulin nas deng atuil didang in se apan-kloma ki ngias. Na banansila el atuli in nini ai le loe soleng hmomos sa. Auk in koma ka, le ai na kaloe son se ola-ola. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mo Auk musti lepa-haal susa-daat muun muna le. Mam Auk haup in susa-daat muun isi, didiin Auk osa la hidi. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mi nangan noan Auk kil in mole-dame maang se apan-kloma kia le? Loo! Auk maang le tao atuli li keng apa nol kaen apa. Nol taos le oen bakisan apa, undeng Auk in tui ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kilan deng halas nia, pali-kaak kon dil nol apa lo. Se uma mes isin, tiul labang dua, hidim dua labang tilu. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ama labang ana; ana labang Ama. Ina labang ana; ana labang ina. Been labang nalen; nalen labang been.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hidim Yesus aa nol atuil hut mamo kas noan, “Eta mi net nopen babakun puit se leol-denen nua lam, mi tek noan, ‘Ni daid tada noan, ulan na le nahu.’ Meman baktebes ela. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Etan aing lote la huu, lam mi tek noan, ‘Ni tada noan leol ni otot muun.’ Meman baktetebes ela. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hoe! Mi niam atuil in sila-klup tuun, mi aa kam kisa, mo dake lam kisa! Mi taan isi in tek deng dale-dapa ni nol un ulan-lelon nas in koma-koma ngas. Mo tasao le mi tade taan Ama Lamtua in koma-koma se oras ni lo kia?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","58","Yesus aa taplaeng noan, “Eta mi tao dais nol apa kam, tasao le mi nutus nal esan muid in toma ka lo kia! Banan dui ka eta mi dasi la lako lius se atuil in nutus dasi nguas lo bii kam, mi aa nol apa babanan tia! Etan lo kam oen nutus le tamang mi lakom bui dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ta eta ela son nam, taon elola ko mi putim nal le baen nuli mi hningin, man atuil in nutus dasi ngas in nutus son na lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Dedeng na, muik atuli tek Yesus noan, gubernur Pilatus keo atuil Yahudi at ila lo deng Galilea, se dedeng oen in maa se Yerusalem le kil in todan se um in Kohe-kanas Tene ka ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ming ela kon Yesus keket noan, “Muid mia lam, atuil man tom in keong nas, in kula-sala ka tene dui deng totoang atuil Galilea tenga las se? Le didiin oen haup in hukung tele ela lia? ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Loo! Mo eta mi nang soleng mi in nuil dadaat ta, le bali muid Ama Lamtua in koma ka lo kam, mi kon tom in dudus-didaa banansila el one. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Hidim elol pait nol atuil at hngul palu man mates, tom in tading deng menara in se Siloam, man lea se lelon na ka la? Oen in kula ka tene dui deng totoang atuil in se Yerusalem mas se? ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Loo! Mo eta mi tenem deng in nuil dadaat ta, le bali muid Ama Lamtua lalan lolo ka lo kam, mam mi tom in dudus el oen kon.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Hidi na kon Yesus bel kleta mes noan, “Atuling mes muik kai ina in puting nal isin se un klapa la. Un taan in maa le ngat kai ina na isin son, tam lo bii ka. Mo kai ina na isin lo bii. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kon nam un tadu un atulin in daek klapa la ka noan, ‘Taun tiul son nia, auk maang oe-oe le nuti-nuting kai ina ni isin nia, mo auk haup saa lo. Tiata dait soleng tuun, ta kai ina ni suma tepat maan tuun.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Atuling in daek klapa la ka siut noan, ‘Papa komali deken, nang nanan taun mes pait. Le halin nam auk dait dale ki pukiun, hidim buli pupuk le tao un nuli ka obon. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Eta taun in maa ku le kai ina ni isin nam, banan. Mo etan lo kam, dait soleng tuun lako.’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Oe mesan na, tom nol atuil Yahudi las leol in kohe-kanas sam, Yesus lako tui se um in kohe-kanas sa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Se na muik bihatang mesa, man blepo ka hkait taun hngul palu son, undeng uikjale kas in tao. Un dil nal nol lolo lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus ngat net bihatang na kon, Un haman le tekan noan, “Mama! Ku banan deng ku ili la tia.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Hidim Yesus nene ima ka laok se bihatang na. Kon nahkitu lam, un blepo in hkait ta lolo meman. Nol un nodan mamo le naka-naka Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mo tulu deng um in kohe-kanas na komali, undeng Yesus tao banan atuil tom nol leol in kohe-kanas. Kon un tek atuil mamo kas noan, “Minggu mesa lam daek lelo eneng. Tiata banan dui ka atuil ili las maa se lelo-leol in dakeng nas tuun, le nuting atuli taih banan one. Maa se leol in kohe-kanas deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mo Yesus situn noan, “Hoe! Atuil in sila-klup tuun. Se leol in kohe-kanas sam, mi kon dake, ta lo?! Ta mi laok sao mi aus-sapi las nol keledai las le ninung, ta lo?! ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Bihatang ni, upung Abraham in hua-koet, banansila el kit kon. Uikjale kas laih tuan na but un taun hngul palu son. Eta Auk sao un tom nol leol in kohe-kanas sam, kula ke?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ming ela kon, Yesus musu las mae. Mo atuil hut mamo kas dalen kolo nol Un in daek banan nas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kon Yesus tupang Un in aa ka pait noan, “Nataka le Auk sukat Ama Lamtua atulin nas banansila el asa la? ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Laih hmunan na oen bubuit tuun, mo nesang le lako lam oen mamo taplaeng. Oen nam banansila el sa-saa beas man ana blutu tuun. Atuli hai se klapa la. Tiata un nuli le daid ina tene. Kon kee kas maas le koet hno se un bango ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hidim Yesus dehet pait noan, “Nataka le Auk sukat Ama Lamtua atulin nas nol asa pait ta? ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Oen banansila el bibit ruti man bihata las katan le kutang nol tarigu sak dua, halin daek ruti mamo. Kon tarigu nas hus didiin daid tene, undeng bibit ruti ana bubuit na. Ama Lamtua atulin nas in mamo taplaeng nga kon ela.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hidi na kon, Yesus nol Un nenan nas lakos kota Yerusalem. Se lalan oen in lako ka, Un tuli-tuil se kota-kota las nol ingu-ingu las le tui atuli. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Lius se mana mes kon, muik atuli mes keket Un noan, “Paap Guru! Nataka le suma atuli bubuit sii man haup boa-blingin te?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Un siut noan, “Hnita in taam laok sorga ku ana blutu. Tiata nuklek mumuun le halin mi taam lakom nal deng na. Ta muik atuli mamo man soba-naan le tama, mo bolen lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Eta um lamtua ka hkaen hnita ka son nam, mi dil se likun le bitin hnita ka tutungus, nol haman le nodan tulung noan, ‘Tuang! Sai hnita ki le!’ Mo un siut noan, ‘Auk taan mi lo!’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hidim mi tek noan, ‘Taon elol le tuang taan kaim lo kia? Kaim man taom daad le kaa-niun leo-leo nol tuang. Tuang kon taom tui kaim se kaim lalan tuan nas.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kon un siut noan, ‘Apin auk tek mi son noan, auk taan mi lo! Mi niam atuil man kom in daek dadaat. Lakom bian deng ni tia!’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Hidim eta Ama Lamtua Allah nutus totoang atuli li dasi lias sam, mi lilu mumuun nol duu siin. Ta mi ngat net upung Abraham, upung Isak, upung Yakob nol Ama Lamtua Allah mee-baha las totoang, tamas daad ne sorgas son. Mo mi tom in nulut soleng lakom se likun na tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mam atuli li maa deng apan-kloma ki mumu-mumu ngas, deng leol-saken lako leol-dene; deng blai-ahen lako loet-ahen, le daad kaa leo-leo se Ama Lamtua Allah sonaf fa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Taad dais ni babanan: eta mam Ama Lamtua nutus totoang atuli li dasi las sam, muik atuli man hmunan nu atuil tenga ka bali le, un nam mo atuil ana tukun, molota un haup in todan isi. Nol muik atuli man hmunan nu tek noan, un nam mo atuil tene, molota Ama Lamtua ngat una lam el atuil ana ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Dedeng na, muik atuil Farisi at ila lo maas tutnaal Yesus, le hidim tekan noan, “Banan dui ka Paap Guru lako bian kakatang se maan didang, ta laih Herodes le keo Papa.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Kon Yesus situs noan, “Eh! Blalan na banansila el maat-mitang man tuklikut daat ta! Mi laok tekan noan, ‘Auk nulut uikjale, nol tao banan atuil ili las se leol nia nol ola. Bingin dua halas-sam, Auk in dake ki hidi.’ Taon elola kon, Auk le daek bubuit pait se lalan Auk in laok bus el Yerusalem mia. Ta se hmunan nua, atuil Yerusalem mas man taom keo tele Ama Lamtua mee-baha las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Idaah, atuil Yerusalem me! Mi man keo tele Ama Lamtua Allah mee-baha las tutungus, nol pasang tele atuil in nutus man maa le tulu lalan bel mia ngas. Auk le tao nakbuan mia nol doh mi oe-oe son, le kele-keba mi deng in daat tas, banansila el manu ina man le kabut un anan nas, se un dila ka dalen na. Mo mi dai tao lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Halas nia, Ama Lamtua tiu-hii nol mi um in kohe-kanas sa lo son. Ta ola bingin dua kam un blo. Mam mi ngat net Auk pait lo ka didiin mi hao noan, ‘Ama Lamtua Allah bel hangun se atuling man in maa nini Ama Lamtua ngala ka ka, undeng Ama Lamtua nutus Un son!’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Oe mesan na, tom nol leol in kohe-kanas sam, tulu deng partei agama Farisi las at mesa, haep Yesus le laok kaa se un uma. Un daad kaa, mo muik atuli mudung Una, le Un tao saa tom nol leol in kohe-kanas sa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dedeng na, muik atuli mes iil hale, un kon daad leo-leo se na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kon nam Yesus keket atuil Farisi las nol atuil in taan hukung Yahudi, man daad kaa leo-leo se la ngas noan, “Muid upung Musa atorang nga lam, boel tao banan atuil se leol in kohe-kanas tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mo muik tahan atuli in bok baha lo. Kon Yesus huud atuling ili la, ti un banan meman. Hidim Yesus tadu un le pait. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Hidi na lam, Yesus ketan oen pait noan, “Eta muik tana-ana mes nahi tama lako ui in kali dalen, tom leol in kohe-kanas sam, mi laok pel puting una, tam lo ka? Eta in nahi ka aus-sapi lam, mi nang tam lom, pel puting nga? Taon elola ko mi pel puting. Na nahin na noan, mi daek son na, ta lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ming Yesus aa ela kon, muik atuli mes lo kon man siut Una. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Dedeng na, Yesus ngat-ngat atuil in maa kaa fesat se um na ngas. Muik atuli mamo nuting maan se mata lua, le lakos daad se las. Net ela kon, Un aa noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Doha-doha lo! Eta atuli haep mi le laok se fesat in sapa kam, nuting maan in dada se atuil tene kas mana la deken. Ta tamlom fesat lamtua ka haep atuil man in tene dui pait ta. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Eta ela lam, mam fesat lamtua ka maa tek ku noan, ‘Komali deken ne! Paap tulung lako daad se klupu lua, ta auk tao del ni son le taung atuling tene nia.’ Kon ku hangu deng del na nol in mae, le lako daad se klupu kua. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tiata eta ku haup in haep pam, laok daad se del in se klupu dui ngas tuun. Ta eta mam fesat lamtua ka ngat net ku lam, un maa tek ku noan, ‘Ee Papa! Maa le daad se mata li tuun.’ Eta ela lam, ku haup in todan se haep pas totoang silan. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ta atuil in nikit-nikit apan na ngas, mam Ama Lamtua tao nahu. Mo atuil in tao apa ka el atuil ana ka ngas, mam Ama Lamtua nikit sakeng.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hidi nam, Yesus aa nol um lamtua ka noan, “Oe pait le eta paap tao fesat tam, haep paap nenan nas nol atuil in muki ngas siis deken! Ta taon elola ko mam oen haep bali papa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Molam eta paap le tao fesat tam, haep atuil kasiang ngas, atuil in iin daat tas, atuil tedo kas, nol atuil hlukut-kait tas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ta taon elola ko mam oen haep bali nal paap lo. Ela kon no, eta paap haep one lam, mam Ama Lamtua Allah man balas ku. Mam eta Un bel atuil in parsai man maet son nas le nulis pait tam, Un nadidingun ku in banan na lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ming ela kon, deng atuil in daad mija mes nol Yesus sas at mes nikit in aa noan, “In ulat dudui ka, atuil in daad le kaa leo-leo se Ama Lamtua Allah sonaf fa ngas!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mo Yesus siut un noan, “Auk le dehet elia: atuli mes tao fesat tene. Hidim un haep atuli mamo-mamo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mana hidi fesat ta kon, un tadu un ata ka le laok taap atuli-atuil in haup haep pas noan, ‘Laok tia, ta fesat tu le mulai la.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mo oen totoang tao dehet bili-ngala le hep apan nas, halin oen daid in laok se fesat na lo. Mes tek noan, ‘Hah! Auk halas-sam sos klapa mesa, ta auk musti laok ngat napat le. Komali deken ne! Ta auk bisa in lako lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Muik didang pait man siut noan, ‘Halas-sam auk sos nal aus-saip taung in lita konat, apa lima. Ta auk le laok soba-nanas nian, komali deen ne!’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Teng pait tek noan, ‘Auk halas-sam sapa, ta bisa in lako lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Hidi na kon, ata ka pait le lapur un tuang nga. Ming ela kon, tuang nga koon-mali isi. Hidim un tadu ata ka pait noan, ‘Eta ela lam, ku puit lako laba-laba! Ku laok se kota ni lalan tuan nas, onget-onget tas le haep atuil kasiang ngas, atuil ii daat tas, atuil tedo kas, nol atuil hlukut-kait tas le nolas maa se fesat tia.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ming ela kon, ata na lako haep atuil nas. Hidim un pait le lapur noan, ‘Papa! Oen maas totoang son, mo maan blo mamo nabale.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kon tuang nga tek noan, ‘Eta ela lam, ku pait lako se ingu-iung in ne kota li likun nua ngas, nol klapa-klapa las. Hanet asii tukun, le nolas maa, sadi tao inu mana lias. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Hii ke! Atuil in hutun soleng auk haep pa son nas, oen tamis nal fesat ni in fala banan na bubuit lo kon!’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Hidi na kon, Yesus nol Un ima-ii las lakos napiut bus el Yerusalem. Atuli hut mamo lakos muid Una. Kon Un bali saol oen le tekas noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Atuil in kom le muid Auk baktetebes sas, musti namnau Auk dui deng totoang: dui deng un ina-aman nas, dui deng un sapa-anan nas, dui deng un pail-kakan nas, nol dui deng un apa ka esa. Etan lo kam, atuling na tom in daid Auk ima-ii lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ta atuil man dai lep susa-daat lo, undeng in muid Au ka, bisa daid Auk atulin lo. Ta atuil man kom le daid Auk atulin na, atuli le keo tele kon no, un lep napiut un in susa-daat ta. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tiata eta le muid Au lam, nangan babanan le. Naleta el atuil in le bangun-pii um hnoden na. Un musti kaih totoang osa ka lako pes duda-duda muna le. Ta tamlom duit dabun na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Etan kahin babanan lo kam, bet un halas-sam daek netes sa, mo duit hidi son. Hidim atuli las mail le tao nahmaeng una, ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","noan, ‘Mi ngat soba-naan atuling na le! Un halas-sam daek netes sa, sa-saa lo bii, mo duit hidi son.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kleta didang, deng in hote-dati. Laih in le hote-dati ka musti daad le kahin muna nol un atulin nas le. Eta un tentara las suma atuli lihu hngul siis sam, nataka le un labang nal musu lihu buk dua, tam lo ka? ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Un kahin babanan son, mo eta mam un tehen se in hote-dati kam, banan dui ka un nutus atuil le laok aa daem nol musu las, oras musu las katang nabale ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ela kon atuil in le muid Au ngas. Un musti kahin lako-pait noan, un tade le nang soleng un nena las totoang son, tam lo bii ka? Etan lo bii kam, atuling na tatai in daid Auk atulin lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Yesus tupang Un in aa ka nini kleta didang noan, “Sila la nam banan. Kit pake le tao mingis in kaa. Mo eta sila la milu lo son nam, un ambak ka elola la? Pake sil na le tao mingis nal in kaa lo son. Le taon daid pupuk kon banan lo. Kit kat soleng tuun. Tiata mi kon musti daid banansila el sila ka, le nuil namnau atuli li totoang. Asii muik hngila kam, hii babanan ne!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Dedeng na, atuil in sium bea ngas nol atuil in tom lo tenga las, maa tutungus se Yesus le hii Un in aa ka. Mo atuil Yahudi las noken oen noan, atuil banan lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Net ela kon, atuil Farisi nol guru agama Yahudi las kom lo, le ahan noan, “Idah! Atuling ni nakbuan nol atuil in tom lo ngas sam. In daat dui pait ta, Un daad kaa leo-leo nolas.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mo ming ela kon, Yesus nahdeh beles kleta nia, noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Eta noan at mes deng mia la muik lae-blai ngatus. Kon mes nes. Lam atuling na tao elola la? Taon elola ko un nang lae-blai buk sipa beas sipa kas se maan babanan mesa, hidim un laok nuting laen mes man nes na didiin hapun. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Un haup lae-blai na son nam, un haal pait nol dael kolo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Lius se uma kam, un haman un tapan nas le tekas noan, ‘Hoe! Mi maa le lena-len nol auk le! Ta auk haup pait auk lae-blai in ilang nga son.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Se sorga kon ela. Eta muik atuil kula mes pesang deng un in kula-sala ngas, le pait lako Ama Lamtua lam, sorga isin nas totoang dalen kolo. Ta atuling mes na in pait lako Ama Lamtua ka, man tao oen dalen kolo dui deng at buk sipa beas sipa man nuil lolo-lolo, nol laok kula lalan lo ngas.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Hidim Yesus dehet kleta mes didang pait noan, “Blalan bihatang mes muik duit lil-muti hngulu. Nahkitu lam mes ilang. Lam nataka le un tao elola la? Taon elola ko un lako hoet hadut, le laang nuting se ola-ola, nol kokon un uma la lako huud onget-onget tas, le nuting duit na babanan. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Un net duit na kon, un lako haman atuil um halin nas, hidim tekas noan, ‘Mi maa le dael kolo leo-leo nol auk le! Ta auk haup pait auk duit muti man in ilang nga son!’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Se sorga kon ela. Eta atuil kula mes pesang le pait muid Ama Lamtua lam, totoang ima-ii in ne sorga nguas dalen kolo isi.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus tupang Un dehet ta nini kleta mes didang pait, noan, “Muik ama mes nol un anan biklobe at dua. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Oe mesan na, ana hmudin na tek ama ka noan, ‘Papa! Bating bel auk hmuki-pusaka las tia!’ Kon un ama ka bating un hmukin nas bel oen duas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nesang lo kon, ana hmudin na hee soleng un nena las. Hidim kabut un kai-batu las, le bok lako dale katang. Lako lius se lua kon, un nuil muid un in koma ka tuun, le paa nuli un duit tas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Paa nuli un duit tas totoang hidi kam, nusa na tom lubu muun isi, didiin un kon nuli nol muik saa lo tetetas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kon nam un lako nuting in dake. Ti muik atuli mes se dale na sium una, le tadu un daek in nalo bahi. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Undeng tana na tahang nal in lubu ka pait lo, kon un kom isi le kaa bahi las in kaa ngas. Ta lole muik atuli in bel un in le kaa lo kam. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nesa-nesang kon un nangan lako-pait noan, ‘Se auk amang ngu uma lua lam, atuil in dake ngas totoang haup in kaa didiin silis. Molota auk se iang mateng tetetas undeng hmatu in nala. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Banan dui ka auk pait lakong auk amang ngu tuun. Hidim tek un noan, “Papa! Auk tao kula tene isi saol Ama Lamtua nol papa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ta auk tom in daid paap ana pait lo son. Nang le paap sium auk daid ata se paap uma li tuun kon banan!” ’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Un nangan haup ela kon, un haung pait lako ama ka uma. Bii kakatang ngam, blalan na ngat netan son, hidim dalen na nahi nol namnaun. Un niu deng uma la le lail lako sod un ana man in pait maa son na. Hidim blalan na nekon le likin. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kon tana na aa nol ama ka noan, ‘Papa! Auk tao kula tene isi son saol Ama Lamtua nol papa. Auk tom in daid paap ana lo son.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mo un ama ka lok atuil in dake ngas noan, ‘Hoe! Lalaba laok kat kaod blatas in leok dui ka le maa pake belen. Nae belen paa laok se un hnanga ka, nol lotong belen nahan laok se un iin nas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Laok pel aus-saip in nalo ka le keo, ta kit le tao fesat halin kit len leo-leo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Undeng auk anang ngi tuladang el un mate son, mo halas ni un nuli pait son. Un ilang, mo halas ni auk haup pait son.’ Aa hidi ela kon, oen tao fesat le len leo-leo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Dedeng na, ana hmunan na se uma lo, un daek se klapaꞌ. Nikit un pait kon, bii kakatang ngam, un ming atuli diuk kong nol tidan lako-pait. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tiata un haman ata kas at mes le ketan noan, ‘Hoe! Tao in kuti-lii saa nia la?’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ata na siut noan, ‘Tuang palin na maa son. Tiata paap tadu keo aus-saip le tao fesat tene, ta un ana ka pait nol boa-blingin son.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ming ela kon ana hmunan na komali. Un dai taam laok uma dael lo. Kon un ama ka laok hanet le noan nol tamang lako uma dale. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mo un ahan noan, ‘Papa! Olan nangan le! Bablaan ni auk daek bosor le hiti-late banansila el ata ka bel papa. Auk kaliut tahan paap in koma ka lo. Mo ela kon no, paap bel tahan auk laen ana mes le tao fesat in kuti-lii leo-leo nol auk tapang ngias lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mo paap ana in paa duit daat ni, lako len-langan nol bihata le tao nuli paap duit tas. Halas-sam un pait maa, kon paap keo aus-saip in apa banan dui ka, le tao fesat tene bel una.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mo un ama ka siut noan, ‘Auk anang in namnau ke! Hii babanan! Bablaan ni ku daad leo-leo nol papa. Totoang paap nena las, ku nena kon. ");
INSERT INTO hegNTpo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mo kit musti tao fesat le kuit-lii nol dael kolo tia, undeng ku palim mia. Hmunan nu, tuladang el un mate son, mo halas nia lam un nuli pait son. Un ilang, mo halas ni haup pait son.’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Hidim Yesus nahdeh taplaeng kleta mes pait bel Un ima-ii las noan, “Atuil in muki mes nikit atuli mes le daid tulu in mana-koet. Mo nenesang kon nam, tuang nga ming haup dehet noan, tulu in mana-koet na panaek una, le paa nuli un hmukin nas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tiata un haman tulu in mana-koet na, le tekan noan, ‘Ku tasao nia ka? Auk ming le ku kuti nol auk hmuki las. Nol nia, ku laok dul sa-saa ku in dake ngas, le auk presas le. Ta hidi na lam, auk le puting ku.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ming ela kon, tulu in mana-koet na nangan lako-pait noan, ‘Auk bosor son nia mo! Auk le tao elol son nia? Bali dale ko auk tes lo. Daid atuil in nodan-nodan kon, auk mae. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Eta daek se ni pait lo son nam, auk musti nuting lalan le halin nam atuil didang tade le tulung sium au.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Undeng na, un haman totoang atuil man in hningin nol un tuang nga kas. Un keket atuling nomer mesa la noan, ‘Hoe! Ku hningin bakun se auk tuang ngia la?’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Atuling na siut noan, ‘Auk hningin mina saitun litir lihu aat.’ Kon tulu in mana-koet na tekan noan, ‘Baktebes. Ku surat hningin ni nian. Nol nia pius sait tia, hidim daad le dul lalaba surat hningin balu, noan, ku hningin litir lihu dua sii.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Hidim un lako keket atuling nomer dua la noan, ‘Ku hningin na bakun na?’ Un siut noan, ‘Auk hningin ale karong lihu mesa.’ Tulu in mana-koet na tekan noan, ‘Pius soleng ku surat hningin blaan na, le dul seda noan karong ngatus paul siis.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Un tao ela, didiin un tuang nga taan haup un in nuting lalan na. Mo tuang na musti hao noan, tulu in mana-koet na, meman nuting taan lalan isi. Auk tek kleta nia, le halin mi tana noan, se hutu-ata hahalas ni hlala, atuil in parsai lo ngas nuting taan lalan dui deng atuil in parsai ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Tiata olan mi nangan soba-nanan tuun. Nang le atuil apan-kloma kias tao dahu-dahut nini oen hmukin nas, mo in banan dui ka, mi nini mi hmukin in ne apan-kloma ki ngias le tulung atuli. Nini ela lam, mi haup tapan mamo. Hmuik nas hidis kon no, mam Ama Lamtua pesang bel mi maan se sorga. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Eta atuli aa nahlolool nol dasi-dais anang ngas sam, taon elola ko un kon aa nahlolool nol dasi-dais tene kas. Mo eta atuli nole nol dasi-dais anang ngas sam, taon elola ko un kon nole nol dasi-dais tene kas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Eta atuli parsai mi le mana-koet hmuki-nala nol dasi-dais anang in se apan-kloma ki ngias lo kam, taon elola le Ama Lamtua parsai mi nol dasi-dais tene kas sia? ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Eta mi mana-koet nal atuil didang hmuki lo kam, asii man brain le bel un hmukin se mia lia? ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ata mesa lam tutan-lau tuang dua lo. Lo kam mam un kom mesan na, mo kom mesan na lo. Tamlom un muid napiut mesan na, mo hosek nol mesan na lo. Mi kon ela, ta atuli li bisa namnau Ama Lamtua Allah leo-leo nol duit lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Dedeng na, muik atuil Farisi at ila lo man muid le hii Yesus in dehet apin na. Kon oen bilu-aa Una, undeng oen kom duit naseke. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mo Yesus siut noan, “Hoe! Mi tao niu apan nas se atuli li sila, mo elol kon Ama Lamtua Allah taan mi dalen in hmomos sa. Muik dasi mamo man atuli nikit lapa-lapa, molota Ama Lamtua Allah ngat dais nas sam hmomos, nol Un nikis one. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Lius se Yuhanis in Sarain Atuli ka in maa ka, kit atuil Yahudi li nuil muid upung Musa nol Ama Lamtua mee-baha las atorang nga. Mo halas ni Ama Lamtua Dehet Dais Banan na holhising lako pes ne ola-ola. Atuli hut mamo nuklek mumuun le halin nuil muid Ama Lamtua in koma-koma ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Apan-dapa ku nol apan-kloma ki ilang kon no, Ama Lamtua Allah atorang nga ilang ana mes lo kon. Titik-koma mes kon ilang lo! ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Atuil in dai soleng un sapa ka, le hidim saap pait nol bihaat didang nga, un nong son na. Ela kon nol atuil in saap nol bihatang in dai soleng nga, nong kon son na.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus dehet pait noan, “Atuil in muki mes kom in pake kai-baut leko-leko man dakes nini kitu duda. Lelo-duman nam un kaa-niun faal banan si-sii, nol nuil leko-leok muid un in koma ka tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Se na kon, muik atuli mes man kasiang isi. Un ngala Lasarus. Un apa ka inu nol paap hoso si-sii. Lelo-lelo lam un tapan nas kil nol un lako se atuling in muki na hnita mata ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Un kom isi le haup in kaa deng atuling in muki na in kaa lisin nas, mo un haup tahan saa lo. Suma ngot tas maas le belo un papa las nana ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hidi kon, Lasarus mate. Kon Ama Lamtua Allah ima-ii deng sorga maa kat una, le belen daad se upung Abraham halin na. Nesang lo kon atuling in muki na kon mate, hidim atuli las puan una. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mo un tama sorga lo. Un tama lako naraka, leo-leo nol atuil mamo in mate ngas. Se na, un tom in tudan-kida nol susa-daat tutungus. Oe mesan na, un botas sila ka lam, un ngat net Lasarus daad bana-banan se upung Abraham halin na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kon un haman mumuun le tek elia, ‘Upung Abraham me! Kasiang nol auk buit le! Tadu Lasarus le dopon hnanga tula ka laok se ui dalen, le maa tao ngoe auk meeng tula ki tuun kon, banan. Ta auk susa-daat isi ne ai naraka lia!’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mo Abraham siut noan, ‘Auk anang nge! Nangan babanan le. Lelon ku nuli nabael se apan-kloma kua ka, ku haup totoang in banan nas. Mo Lasarus sam, haup in susa-daat tuun. Tiata halas ni Ama Lamtua belen dael kolo se nia, mo ku haup seda in susa-daat. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dudui pait ta, ku nol kaim hlala kia, Ama Lamtua sole-bating kit nini nahin in bluang tene mesa. Tiata atuil in deng ia ngias, tia nal ela lo, nol atuil in ne a ngas, maa nal el ia lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kon atuling in muki ka nodan noan, ‘Eta ela lam, upung Abraham tulung tadu Lasarus laok auk papa uma lu le. ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ta auk muik paling biklobe at lim biis ne uas. Tadu Lasarus laok tekas le halin oen pait muid Ama Lamtua tia. Le halin eta oen mates sam, oen tamas se maan in susa-daat ni deken.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mo Abraham siut noan, ‘Ama Lamtua Allah bel oen upung Musa, nol mee-baha las in dula ngas son. Ku palim mas bisa les oe-oe, le halin oen nangan taan Ama Lamtua in koma ka.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mo atuling in muki na kaen noan, ‘Na nol lo bii, upung Abraham. Oen toe muid Ama Lamtua in Teka-teka ngas lo! Musti muik atuil in mate mes puti deng un bolo ka, le laok tekas, halas-sam oen ming nol tade le pesang.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mo Abraham siut noan, ‘Eta oen dai ming upung Musa nol Ama Lamtua mee-baha las in teka-teka ngas lo kam, atuil in mate puti deng utu ka, le laok aa nolas kon, oen dai ming lo.’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus tek Un ima-ii las pait noan, “Oe mamo son atuli li nahi tom kula, undeng atuil didang in tao-tao. Mo atuil in daek ela ngas, man haup in daat muun dui. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Eta muik atuli tao le didiin tana-ana blutu mes parsai se Auk lo kam, mam Ama Lamtua Allah belen hukung ngele. In kahan dui ka, but baut tene mes se un leo ka, hidim soleng tamang lako tasi dalen. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tiata doh mi apan nas babanan, le halin mi kon tao nahu atuil deken! Mo etan at mes deng ku pail-kakam mas tao kula kam, kaing una. Eta un pesang, hidim maa le nodan ampong ngam, nadidingun soleng un in kula na tia. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Eta ku pail-kakam mas tao kula ku lalis iut se lelon mes dalen, hidim un pesang, kon un maa nodan ampong se ku la lalis itu lam, ku musti nadidingun un in kula saol ku lalis itu na.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Neot mesan na, Yesus ima-ii las maas saol Yesus le nodan noan, “Paap Guru! Kaim in parsai ki kuat lo. Tulung tao tes kaim in parsai ki le.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kon Yesus situs noan, “Eta mi muik in parsai se Ama Lamtua Allah in kuasa ka ana buit tuun, banansila el boto beas sa kon no, mi prenta nal kai ina tene ni noan, ‘Hobodos le lako seda se tasi kua!’ Lam taon elola ko, kai ina na muid mi in prenta ka meman.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Hidim Yesus kat kleta pait noan, “Muik ata mes bali dale se un klapa la, tamlom doh un lae-blai las se epe. Daek hidi kon, ata ka pait lako uma. Taon elola ko un tuang nga tekan noan, ‘Maa le kit duat daad kaa leo-leo tia’ lo! ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Molam un tuang nga lokan noan, ‘Laok mana bel auk mija lu muna le, hidi halas-sam ku laok kaa-niun se klupu kua.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Eta ata ka daek muid un tuang nga in koma ka son nam, mi bali noan tuang nga nodan mamo se una le? Loo tetas! ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mi kon ela. Eta mi daek hidi totoang man Ama Lamtua in prenta ngas sam, mi musti aa noan, ‘Kaim niam suma atuil in loka-loka tuun. Kaim nuting in naka-naka lo. Kaim suma lako-daek osa la tuun.’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus nol anan nas bok lakos bus el Yerusalem, kon oen lakos lius se propinsi Galilea nol propinsi Samaria toon na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nikit oen le taam lakos ingu mes se na kon, muik atuil iil baih-bluku at hngul maas tutnaal nol Yesus. Oen dil deng kakatang, ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","le haman leo-leo noan, “Yesus! Lamtua! Namnau kaim tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesus ngat net oen kon, Un tadu noan, “Mi laok tulu mi apan nas se tulu agama luas muna le, halin oen tinang noan, mi in iil baih-bluku ka ilang son, tam lo bii.” Ming ela kon, oen lakos. Mo se lalan hlala kam, suknahkitum oen totoang banan meman. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tiata oen laok napiut nol dael kolo. Mo muik at mes pait lako se Yesus. Un haman tek noan, “Naka Ama Lamtua! Ta auk banan son!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hidim un hai buku ka le nodan mamo se Yesus. (Molota un na mo, atuil Yahudi lo, un atuil Samaria. Atuil Samaria las taom tao dais tutungus nol atuil Yahudi las.) ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kon Yesus keket atuil in muid Una ngas noan, “Elola? Apin Auk tao banan at hngulu ta lo? Sipa las ne olas sa? ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tasao le atuling in laok-maa ni sii, man pait maa le nodan mamo se Ama Lamtua Allah, nol nikit in naka bel Una lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Hidim Yesus tek atuling na noan, “Ku banan son undeng ku parsai baktetebes se Au. Tiata hangu, le pait nol boa-blingin tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Neot mesan na, atuil Farisi at ila lo maas keket Yesus noan, “Paap Guru! Olan ku tek napat le! Bling halas-sam Ama Lamtua Allah nikit Un prenta la la?” Kon Yesus siut noan, “Elia! Mi nangan noan, Ama Lamtua nikit Un prenta la, nini tada bili-ngala se apan-kloma kia, man atuli li ngat net nol mata beas esa deken. Ta atuli haup taad le tek noan, ‘Olan ngat se nia! Ta Ama Lamtua Allah nikit Un prenta la ne nia tamlom ne nua!’ Ela loo! Ta Un nikit Un prenta la ne mi hlala ka, ne atuli las dalen.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hidim Yesus tek Un ima-ii las noan, “Nesang lo ka kam Au, Atuling Baktetebes nia, leo-leo nol mi lo kam. Mam se lelo-leol in susa ngas sam, mi nangan nol kom isi le net Auk pait. Mo Auk maang lo bii. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Hidim eta atuli maa tek noan, ‘Kristus muik ne nia!’ tamlom ‘Kristus muik ne nua!’ Lam mi kukaum le nuting lako-pait deken. Ta oen in aa na nole-lilung. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Eta Atuling Baktetebes sa pait maa kam, un tadan na langa isi, banansila el bisain man kaloe, le tao apan nu langa deng mumu laok mumu. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mo Un kon musti lepa-haal in susa-daat bili-ngala muna le. Nol atuil hahalas nia, dai ming se Un lo nol oen kon hutun soleng Una. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mo eta Un le pait maa kam, atuli las nuil dadaat el in biasa ka, banansila el dedeng upung Noh nuli nabale ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Dedeng na, atuli las kaa-ninu, tao fesat in sapa, didiin lako lius leol Noh in tama lako un kapal la dalen na. Mo oen dai ming Noh in teka ngas lo. Kon nahkitu lam, ui tene ka baa maa ta tao dudus oen totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na kon hnika mes nol atuli-atuil in nuil se Lot tempon na ngas. Oen kon dai ming se Lot lo. Dedeng na, oen kaa-ninu, biuk-bale, daek klapa, bangun-pii uma, nol nuil dadaat el in biasa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mo oskaong nga, oras Lot lali nang soleng kota Sodom kon, suknahkitu lam, ai nol blirang naih deng apan nu, le kaa nuli oen totoang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tiata mi doha-doha le! Ta tamlom oras Atuling Baktetebes sa le pait maa kam, atuli las in nuli ka el in biasa ka. Mo suknahkiut tuun nam, Un maa lisu la. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Leol na, atuil in daad se uma la teras sa ngas, taam lako uma dalen le mana nakbuan sa-saa las bakun na. Atuil in daek se klapa la ngas, pait lako le kat kai-baut se uma deken tia. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nangan asa man in daid nol Lot sapa ka se hmunan nua ka. Un mate, undeng un nangan un sa-saa in ne un uma la ngas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Atuil in dai muid Auk lo, undeng namnau un apa ka ka, mam un in nuli ka parsum tuun. Mo atuil in muid Auk didiin sao un in nuli ka, undeng in namnau Au kam, mam un haup boa-blingin le nuli napiut nol Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Auk tek mi meman! Oras Atuling Baktetebes sa pait maa kam, eta muik atuli at dua ninis se maan in nini mes dapa kam, nahkitum Ama Lamtua nikit sakeng mesa, mo nang mesan na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Eta muik bihata at dua hai ael leo-leo lam, mam Ama Lamtua nikit sakeng at mesa, mo nang mesa na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Eta muik atuli at dua daek klaap leo-leo lam, Ama Lamtua nikit sakeng mesa na, mo nang mesa na.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ming ela kon, Yesus ima-ii las keket Un noan, “Paap Guru! Mam totoang nas dadis se ola sa?” Kon Yesus soleng dais noan, “Elia! Eta mi ngat net kee in kaa sisi ngas hong nakbua se ola sam, mi taan son noan na daid tada, taon elola ko oen kaa hmate ne maan na.” Nol nahin in buni-napang noan, eta Kristus pait maa kam, un tada-tada las langa isi, eta atuli les tanas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Oe mesan na, Yesus tui Un ima-ii las nini kleta, le oen kohe-kanas tutungus, nol oen in makoe ka ilang deken. Oen musti parsai napiut se Ama Lamtua. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Un dehet ta elia: “Se kota mesa, muik atuil in nutus dasi mes man muid Ama Lamtua Allah lo. Un kon ngat atuil lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Se na kon, muik bebalu mesa, man maa tutungus se atuling in nutus dasi na le nodan noan, ‘Paap hakim! Nutus auk dasi li nol in toma le.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Laih hmunan na, atuling in nutus dasi na tiu-hii bebalung na lo. Mo nesa-nesang kon, un nonos nol in hii una. Kon un daad le nangan noan, ‘Meman auk niam tiu-hii Ama Lamtua Allah lo, dudui pait atuli lia. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mo bebalung ni tao auk bong iil son. Undeng na, banan dui ka auk nutus un dasi la nol lolo-lolo tia. Eta lo kam, bet un taan in maa tao bosor au sii.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mi nangan soba-naan atuling in nutus dasi daat na in aa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Eta nenesang kon, un tulung bebalung na lam, taon elola ko Ama Lamtua Allah tade le tulung Un atulin, man kohe-kanas lelo-duman le nodan tulung se Una ngas. Mo Ama Lamtua natang nesang lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ta Un nehan oen dasi las nol hlapat. Elam, Auk le ketan elia: Eta Au, Atuling Baktetebes nia, maang pait son nam, nataka le Auk tutnaal atuil in parsai se dale-dapa nia, tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus dehet kleta mes pait, deng atuil in nikit apa ka lalapa, nol kom in ngat kabaul atuil didang nga. Un dehet noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Blalan biklobe at dua lakos kohe-kanas se Um in Kohe-kanas Tene ka. Mesan na atuil deng partei agama Farisi; mo mesan na pait atuil in sium bea. Atuil Yahudi las noken atuil Farisi las le, oen atuil niu. Mo oen noken atuil in sium bea ngas noan atuil daat. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Lius se um in kohe-kanas sa kon, atuling Farisi nga sii dil le kohe-kanas noan, ‘Nodan mamo Ama Lamtua, ta auk niam atuil banan. Auk daat el atuil tenga las lo. Auk daid atuil in nako lo. Auk kom naseke lo. Auk laok kula nol bihaat lo. Nodan mamo Ama Lamtua, ta auk kon daat el atuling in sium bea ni lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Auk makoe in telang minggu mesa lam oe dua. Nol auk bel op mes tutungus deng totoang op hngul man auk in hapu ngas.’ Atuling Farising nga kohe-kanas ela. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mo atuling in sium bea ka dil kakatang se klupu lua. Un nikit nal sila ka le ngat laok el apan-daap lo. Un suma suda le kohe-kanas nol dalen in ili, noan, ‘Eee, Ama Lamtua Allah! Kasiang au, atuil in kula-sala nia! Bel ampong au!’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Dedeng atuil at dua nas pait umas sa, nataka le ol man babanan nol Ama Lamtua Allah la? Atuling Farisi man koaok daat ta, tam atuling in sium bea ka la? Taon elola ko Un sium nol banan atuling in sium bea, man tao dalen na deng dadale ka. Mo un toe muid atuling Farising nga lo. Ta Ama Lamtua Allah tao nahu atuil in koaok daat ta, mo nikit sakeng atuil in tao apa ka deng dadale ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Oe mesan na, atuli las kok nol oen anan blutu kas laok bel Yesus, halin Un nene ima ka laok se oen bon nas, le aa beles hangun. Net ela kon, Yesus ima-ii las kaing atuli las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Mo Yesus sium tana-anang in maa bus el Una ngas. Hidim Un kaing Un ima-ii las noan, “Nang le tana-anang blutu nas maas se Au lia. Mi boel tukan oen deken. Nangan babanan! Ta atuil man le daid Ama Lamtua Allah atulin na, un musti nahlae se Ama Lamtua Allah, banansila el tana-ana man nahlae se un ina-aman nas sa.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Oe mesan na, tulu agama Yahudi las tenen nas at mes maa keket Yesus noan, “Paap Guru man in todan dudui! Auk musti taon elol le halin auk taan baktetebes noan, auk haup in tamang sorgang, le nuling napiut nol Ama Lamtua Allah la?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kon Yesus siut noan, “Tasao le ku noken Auk noan ‘in todan dudui’ kia? Suma at mes sii man kit todan dudui, na Ama Lamtua Allah. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ku taan Ama Lamtua Allah atorang lo-lolo hmunan nua ka son ta lo, man noan: Nong deken; keo atuil deken; naok deken; daid saksi in nole-lilung deken; nol todan ku inam ma nol ku amam ma.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Atuling na siut noan, “Baktebes Papa! Auk muid atorang nas son lo-lolo auk anang bii kua.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ming ela kon, Yesus tek noan, “Banan! Mo ku dabun dasi mes nabale. Na ka, nol nia, ku pait lako le hee nuli ku hmuki las totoang. Hidim laok bating duit nas bel atuil kasiang ngas. Hidi nam, ku pait maa le muid Au. Ta mam Ama Lamtua Allah bel seda ku hmuki se sorga.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ming ela kon, atuling na dalen iil isi, lole un muik isi kam. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ngat un pait lako nol dalen in iil isi ela ka kon, Yesus tek Un ima-ii las noan, “Atuil in muki ngas, meman sus naseke in taam sorga. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kit naleta nol dais didang elia, hmukit unta tene mes tama lako nal un okat ta deng laung bolo lo. Ela kon nol atuil man nahlae un hmukin nas siis, mo nahlae se Ama Lamtua lo ka, taon elola ko un tama nal sorga lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Atuli-atuil man ming Yesus in dehet ela ngas, keket Un noan, “Eta meman sus taung atuil in muki ngas ela lam, atuil tuladang elola, man haup nal boa-blingin nia?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus siut noan, “Taung atuli lia lam, dais mamo nas daid lo. Mo taung Ama Lamtua Allah lam, totoang nas dadi.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kon Petrus tupang noan, “Papa! Kaim nang soleng kaim hmukin nas totoang son, le muid Papa. Mo mam kaim haup saa la?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus siut noan, “Petrus! Hii babanan! Atuil man in nang soleng un uma la, sapa ka, un pali-kakan nas, un in-aman tamlom un anan nas, undeng un lako-daek Ama Lamtua Allah osa la, ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","lam taon elola ko un sium mamo dui pait se apan-kloma kia. Hidim eta apan-kloma ki kiamat son nam, un kon haup in nuli napiut nol Ama Lamtua Allah.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus nol Un ima-ii las hngul duas siis kon, Un aa nolas noan, “Mi totoang taan son noan, halas ni kit le lakong bus el kota Yerusalem. Lius se ua ngam, totoang dais man Ama Lamtua mee-baha las in dul son hmunan nua, deng Atuling Baktetebes sa ngas, daid muid asa man oen in dul son nas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mam oen sao Auk lakong bel atuil in laok-maa man parsai se Ama Lamtua Allah lo ngas. Kon oen bilu-aa Au, tao nahmaeng Auk bili-ngala, puut kapen se Au, ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","diku-puang Au, hidim keo tele Au. Mo bingin dua ka lam, Auk nuling pait.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ming Yesus in aa ela ka kon, Un ima-ii las nangan hapun lo, undeng oen daek taan in teka-teka na nahin na lo bii. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nikit Yesus nol Un ima-ii las le taam lakos kota Yerikos kon, oen nahtom atuling tedo mesa, man daad le nodan-nodan se lalan suut ta. ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Oras un ming atuli mamo laok deng na kon, un ketan noan, “Hoe! Asa nia la?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kon atuli las tekan noan, “Yesus, atuling Nasaret ta maa lako deng nia.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ming ela kon, atuling tedo na haman mumuun noan, “Yesus! Laih Daud in hua-koet te! Namnau auk buit le!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Atuil in laok muna deng Yesus sas kaing una le ete. Mo un haman mumuun dui pait noan, “Hooe, laih Daud in hua-koet te! Namnau auk tia!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nikit Yesus ming haup in haman ela ka kon, Un laok napiut lo, mo Un dili. Hidim Un tadu atuli laok pel atuling tedo ka. Maa lius se Yesus sila ka kon, Un keket noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ku kom le Auk tao saa bel ku la?” Un siut noan, “Papa! Auk nodan le auk ngat neta.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus situn noan, “Banan! Undeng ku parsai noan Auk tao banan nal ku, tiata nol nia ku ngat neta.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nahkitu lam, atuling in mata tedo na banan meman. Kon un laok muid Yesus le naka-naka Ama Lamtua Allah. Totoang atuil in net ela ngas kon, naka-naka Ama Lamtua. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Hidi nam Yesus nol Un ima-ii las tamas muid kota Yeriko, le lakos napiut. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Se na, muik tulu in sium bea bel pamarenta Roma las mesa. Un ngala Sakeos, nol un na mo atuil in muki. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nikit un ming noan, Yesus le maa lako deng na kon, un kom isi le net Yesus. Mo un ngat net hapun nol babanan lo, undeng atuli hut mamo isi bua nal Yesus, nol Sakeos na mo atuil daen. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tiata un lail lalaba muna, hidim sake lako se kai ina mes dapa, se lalan suut man Yesus in le maa lako deng na ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ti Yesus lako lius se kai na leon na kon, Un ngada lako el dapa. Hidim Un haman Sakeos noan, “Sakeos! Niu maa lalaba tia! Ta leol neot ni, Auk le tuil tahang se ku uma.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakeos herang-herang. Hidim un niu lalaba tuun le nol Yesus lako se un uma. Un dalen kolo isi. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mo muik atuli mamo komali noan, “Wuih, Sakeos na mo atuil banan lo! Totoang atulis tanan son! Mo taon elol le Yesus tama lako tahang se un uma la lia?!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lakos lius se Sakeos uma la kon, un dil se Yesus sila ka, le tek noan, “Paap Guru! Deng leol neot nia, auk bating totoang auk hmukin nias op dua, le bel op mesan na lako se atuil kasiang ngas. Eta auk sium net bea lai-lisin nam, auk bel pait oen lalis aat.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus situn noan, “Banan. Leol neot nia, Ama Lamtua Allah bel boa-blingin ku, nol ku nenan nas totoang son, undeng ku parsai Ama Lamtua banansila el upung Abraham. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ta Ama Lamtua Allah nutus Auk daid Atuil Baktetebes se apan-kloma kia. Auk maang le nuting atuil in laok kula son, deng Ama Lamtua lalan na ngas, le beles boa-blingin.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Dedeng na, muik atuli mamo muid le hii Yesus in dehet ta. Nikit oen lakos dadani son nol kota Yerusalem kon, oen nangan noan, Un le daek Ama Lamtua Allah in prenta el lahi ka se na. Tiata Yesus nahdeh beles kleta mes pait, ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","noan, “Muik atuil tene mesa, le lako el nusa likun nuas, le oen nikit un daid lahi. Hidi na, halas-sam un pait maa le daid laih se un nusa ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Dedeng un mana hidi le noan lako ka, un haman un ata kas at hngulu, hidim beles at mesa lam duit lil-mea mesa. Un lekas noan, ‘Mi pake duit ni le daid peke. Eta auk pait maang ngam, mi mesa-mesam maa teka, le mi haup pait bunga bakun na.’ Hidi na kon un boka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mo un hutun nas koman lo. Tiata oen tunang atuil muna le laok se ua, halin tek noan, ‘Eta atuling ni man kil prenta bel kami lam, kaim tade lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mo ela kon no, oen nikit un daid lahi. Hidi kon un pait. Pait maa lius uma kam, un haman ata at hngul nas, hidim keket oen noan, ‘Mi haup bunga bakun son deng duit lil-mea man auk in bel mia ngas sa?’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ata hmunan na tek noan, ‘Ama lahi! Auk haup ontong oe hngul deng peke man auk in simu ka!’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kon lahing nga tek un noan, ‘Banan! Ku niam, ata banan. Undeng auk parsai ku nol dais anang nias, tiata nol nia, auk nikit ku le prenta kota hngulu.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Hidim ata nomer dua la tek noan, ‘Ama lahi! Auk haup bunga duit lil-mea lima, deng peke man auk in hapu ka.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kon lahi nga naka una, le tek noan, ‘Banan! Eta ela lam, auk nikit ku le prenta kota lima.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mo ata nomer tilu la kil pait un duit lil-mea ka. Hidim un tek noan, ‘Tuang duit ti nian! Auk kabut, hidim buni babanan le halin ilang deken. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Auk tao ela, undeng auk lii. Auk tana le tuang taom dising atuil didang le muid tuang in koma ka. Ta tuang kom in kat asa man tuang nena lo, nol nui asa man tuang in mula-hai lo.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ming ela kon, lahing nga baet un noan, ‘Ku niam hadat lo! Ku in aa ka, hukung bali ku apam ma esa son. Ku tanan son noan, auk niam atuil in kat asa man auk nena lo, nol nui asa man auk in mula-hai lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Eta ela lam, tasao le ku laok pesang duit ni se bang tuun lo kia? Le halin eta auk pait maang ngam, auk haup un bunga ka. Bubuit tuun kon banan.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Hidim lahing nga tadu atuil didang in se la ngas noan, ‘Kat un duit ta, le belen laok se ata in haup bunga hngulu ka.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mo oen siut noan, ‘Tuang! Atuling na in hapu ka, nol son. Mo tasao le kat atuling in nena bubuit tia, le bel taplaeng lako una lia?’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mo lahing na siut noan, ‘Nangan babanan! Ta atuil in mana taan asa man atuli li in parsai le bel un son na, mam un haup taplaeng. Mo atuil man osa daat in mana-koet ta, mam oen kat nuli un nena las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tiata nol nia, mi laok daek auk musu man in kom auk le daid laih lo ngas. Nolas maas se nia, le keo oen totoang se auk silang ngia. Laok tia!’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus dehet hidi kon, oen lakos napiut bus el Yerusalem. Yesus laok muna se hmunan. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Oras oen lakos dadani nol ingu dua, ngalan Betfage nol Betania, man ne leten Saitun, kon Un tadu ima-ii las at dua, le lakos muna. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Un tadu oen noan, “Mi duam lakom se iung in mo mata lua ka. Mam mi net keledai ana mes butun se na. Atuli saek netan lo bii. Mi loat un talin na, le pel nolan maa se nia. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mo etan atuli keket mi noan, ‘Tasao le mi loat keledai na talin na lia?’ Lam mi tekas noan, ‘Kaim Tuang nga le pake.’” ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hidim oen duas lakos, kon net keledai ana na, banansila el Yesus in teka ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nikit oen loat keledai ana na talin na kon, lamtua ka keket oen noan, “Tasao le mi loat sao hmukit ni lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Oen siut noan, “Kaim Tuang ngu le pake.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kon keledai la lamtua ka tade, ta oen duas pel nol keledai ana na lako bel Yesus. Hidim oen lekat oen seman nas laok se keledai ana na blepo ka, le sakeng Yesus se dapa. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Atuil hut mamo kas kon kat oen seman nas nol hlendang ngas, le lekat laok se lalan na, halin sodo-sium Yesus banansila el in sodo-sium atuil tene ka. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oras Un niu lako deng leten Saitun na ka, atuil hut mamo kas leo-leo nol Un ima-ii las, kidu le naka-naka Ama Lamtua Allah, undeng tada-taad herang man oen in net son nas. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Oen leo-leo naka-naka noan, “Un niam, Lahing man Ama Lamtua Allah in nutus maa ka! Ama Lamtua Allah bel hangun se Una! Halas nia, atuli li haup in mole-daem nol Ama Lamtua se sorga son. Naka Ama Lamtua man daad le kil prenta ne apan-dapa man lapa dudui kua.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mo atuil Farisi las kon muik se atuil hut mamo kas hlala. Oen tek Yesus noan, “Paap Guru! Kaing one, le oen kidu-ahan muun isi ela deken, ta ni lai-lisin son!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mo Yesus siut noan, “Hoe! Auk tek mi meman ne! Eta atuil nias ete kam, batu-batu lias man naka Ama Lamtua!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Oras oen lakos dadani le tamas Yerusalem, Yesus ngat net kota la, kon Un lilu, ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","le tek noan, “Idaa, atuil Yerusalem me! Auk in koma ki le leol neot ni mi sium in mole-dame man Auk in kila kia. Mo undeng mi tiu-hii Ama Lamtua lo, tiata halas ni mi hapun lo son. In dame na katang deng mi son. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mam mi musu las boa dale pukiu kota la tembok ka, hidim oen tamas keng nol mia. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Oen tao lean mi kota la lako tatai nol dale ka, hidim keo mi totoang leo-leo nol mi anan nas. Oen nang batu mes le dil lo kon, undeng Ama Lamtua maa le bel boa-blingin mi son, mo mi dai taan Un lo!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Hidi kon Yesus tama lako se Um in Kohe-kanas Tene ka. Se um na kintal la, atuli las taon daid pasar le hee hmukit in tunu-dadung. Net ela kon, Yesus laok nulut puting oen deng na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Un siut oen nol mumuun noan, “Ama Lamtua mee-baha las dul meman son elia, ‘Auk bangun-pii Um nia, le totoang atuli li maa kohe-kanas nal se nia.’ Mo mi taon daid atuil in nuhu-dau ngas maan in nakbua son.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hidi nam, lelo-lelo lam Yesus lako se Um in Kohe-kanas Tene ka, le tui atuli las se na. Mo tulu-tulu agama las tenen nas, guru-guru agama las, nol blalan-blalan hadat Yahudi las nuting lalan le keo Una. ");
INSERT INTO hegNTpo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mo oen net lalan lo, undeng atuil hut mamo kas dalen kolo isi nol hii Yesus in dehet ta. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Neot mesan na, Yesus lako se Um in Kohe-kanas Tene ka, le tui Ama Lamtua Dehet Banan na se kintal la. Kon tulu agama las tene-tenen nas, guru-guru agama las, nol blalan-blalan hadat tas maas le keket-ketan nol Una. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Oen ketan noan, “Asii man bel hak, le lahin Ku maa tao lobo-lau se ni lia? Olan Ku tek napat le!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kon Yesus siut noan, “Auk kon le keket dasi mesa, hidi halas-sam Auk siut mia. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Elia: Mi taan Yuhanis in Sarain Atuli ka, ta lo? Asii man belen kuasa le un sarain atuli lia? Ama Lamtua Allah, tam atuli lia?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kon oen hulin lako-pait le aa nol apa noan, “Idaah! Kit toman son nia mo. Eta kit tek noan, ‘Ama Lamtua Allah man tadu’, kam Un siut noan, ‘Eta ela lam, tasao le mi parsai Yuhanis lo kia?’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mo kit kon bisa tek lo noan, ‘atuli li man tadu’ ta lo kam atuil nias kat baut le pasang tele kita. Ta oen parsai noan Yuhanis na mo, Ama Lamtua Allah mee-baha.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hidi nam oen siut Yesus noan, “Kaim tanan lo.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kon Yesus situs noan, “Eta ela lam, Auk kon tek mi lo noan, asii man tadu Au.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hidi kon, Yesus dehet atuil hut mamo kas, kleta mes pait noan, “Atuli mes hai anggor se un klapa la. Hidim un seban lako bel atuil in daek klapa ngas, le maa liam oen bating apa klaap na in hapu ka. Mo un lako daad nesang se nusa didang. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Lius oras in nui anggor isin kon, klaap lamtua ka tadu un ata mes le laok sium un nena las, deng atuil in dake ngas. Mo atuil in dakeng nas diku-puang ata na, hidim oen nulut pait un nol kil saa lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hidi na kon, klaap lamtua ka tadu un ata kas at mes pait lako. Mo atuil in dake ngas diku-puang una, nol tao nahmaeng una. Hidim oen nulut pait nol kil saa lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kon klaap lamtua ka tadu un ata nomer tilu la lolen le lako, mo oen diku-puang didiin un apa ka papa, hidim oen soleng puting un lako klapa la likun na. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Klaap lamtua ka daad le nanga-nangan noan, ‘Auk taon elol pait te? Banan dui ka, auk tadu se auk anang in hua kia. Ta taon elola ko oen todan una, nol sium un babanan.’ Tiata un tadu un ana in namnau isi ka lako se ua. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mo nikit atuil in dake ngas ngat net un kon, oen tek apa noan, ‘Hoe! Mi ngat le! Ta blalan na tadu un ana ka esa, le maa lolen son nuan. Un man mam haup blalan na pusaka las totoang! Tiata maa le kit keo tele un tia! Le halin nam kit man pal klapa lia.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tana ka lako lius kon, oen pel-lakang puting deng klaap na, hidim keo tele una. Lam Auk le ketan elia: Mi nangan nam mam klaap lamtua ka tao saa atuil in dake ngas sa? ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Muid Au lam, taon elola ko un maa le keo tele oen totoang, hidim un seb klaap na bel atuil didang le daken lolen.” Nikit atuli las ming Yesus in dehet ela ka kon, oen siut noan, “Eta bole lam, Ama Lamtua Allah hukung kaim ela deken!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesus ngat nakekeon one, hidim keket noan, “Eta daid in hukung ela lo kam, tasao le Ama Lamtua mee-baha las dul meman son noan: ‘Muik batu mesa, man tukang ngas kat soleng son, mo halas ni baut na daid baut in tian nini hdin ina kia?’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Atuil in tunun se baut na ngas dudus, undeng oen tom hukung. Nol eta baut na nahi tom asii lam, atuling na kon dudus hidi undeng un tom hukung.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nikit guru agama las nol tulu agama las tene-tenen nas ming dehet na kon, oen tana noan, Yesus in aa nini kleta na hai bus one. Oen hnika mes el atuil in daek klapa la ngas. Tiata oen komali isi. Kon oen nuting lalan le daek Una. Mo oen tiud nol atuil hut mamo, man kom isi nol Yesus in tui ka ngas. Tiata oen lakos nang soleng Un tuun ela. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hidi na kon, Yesus musu las mudu-mudung Una. Oen nuting atuil man tao taan apa ka el atuil in parsai baktebes sa, le kiu nahu Yesus. Oen harap le Yesus aa labang nol pamarenta Roma la, halin oen laok lapur gubernur ra, le un tadu atuli laok daek Yesus. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kon oen tadu atuling man in tao apa ka el atuil in parsai ka, le laok keket-ketan nol Yesus noan, “Paap Guru! Kaim taan noan Paap dalen na nam lolo. Paap nole-lilung net lo, nol huil sila lo. Paap tui Ama Lamtua Allah in Teka-teka ngas nol in toma. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mo kaim le keket dasi mesa: muid kit atorang agama Yahudi lia lam, nataka le kit baen bea bel pamarenta Roma la laih tuan na, tam lo ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mo Yesus taan oen in nangan daat le kiu nahu Una ka. Tiata Un siut noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Olan tulu bel Auk duit lil-muti mes le.” Kon oen tulu belen duit na. Ti Un keket noan, “Hdulat ni asii la? Nol asii ngala nia la?” Oen siut noan, “Na lahing tene, Kaiser ra.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kon Yesus tek noan, “Etan ela lam, bel pamarenta la asa man pamarenta la nena. Nol bel Ama Lamtua Allah, asa man Ama Lamtua Allah nena.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ming ela kon, oen hera-herang, undeng oen kiu nal Un se atuil hut mamo kas silan lo. Tiata oen ete tuun. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hidi nam, muik atuli at ila lo deng partei agama Saduki, maas le noan kiu nahu Yesus. Atuil Saduki las tui noan, atuil in mate ngas nulis pait se leol kiamat ti lo. Oen maas le keket-ketan nol Yesus noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Paap Guru! Upung Musa dul pesang bel kit atorang son noan: eta bikloeb ol man mate, mo muik aan lo kam, un palin na musti saap nol bebalung na lolen, le halin nam hua bel un kaka in maet son na, ana. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Meman hmunan nu upung Musa tui ela. Mo kaim le keket elia: muik biklobe at iut pali-kaka. Hmunan na sapa, mo mate nol muik ana lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kon un palin in muid una ka saap nol bebalung na. Nesang lo kon, un mate mo muik aan lo kon. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ela kon nol palin nomer tilu la. Un kon saap nol bebalung na, mo un mate nol muik aan lo. Ela tutungus didiin pail hmudin hesa ka kon mate. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hidi nam bebalung na mate. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lam kaim in keket ti elia: Bihatang na saap nol biklobe at iut nas son. Tiata eta mam apan-kloma ki kiamat, hidim Ama Lamtua Allah bel atuil in mate ngas le nulis pait tam, bihatang na daid asii sapa ka?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Kon Yesus siut noan, “Atuli li saap apa se apan-kloma ki sii. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Mo eta se sorga lam, muik in saap apa lo. Nol se ua lam, oen mates pait lo ka. Oen banansila el Ama Lamtua Allah ima-ii in ne sorga nguas. Ta oras Ama Lamtua Allah bel atuil in mate ngas le nulis pait ta, Un huil nal oen le daid Un anan. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ne upung Musa in dula ka dalen, muik dehet deng kai ina ana mes man ai kaan, mo hnining lo. Se in dula na, Ama Lamtua Allah tek upung Musa noan, ‘Auk niam, ku upum mas Lamtua Allahn. Nas upung Abraham, upung Isak, nol upung Yakob. Oen totoang todan-lahing Auk tutungus maa lius leol nia.’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Molota blalan nas mates son lo-lolo hmunan nua. Mo undeng Ama Lamtua Allah tek son noan, Un na mo oen Lamtuan nabale, tiata kit taan noan oen nulis. Deng dehet na lam kit tana noan, atuli li mate son kon no, mam oen haup in nuli pait. Ta suma atuil in nuli sii man todan-lahing se Ama Lamtua Allah, mo atuil in mate lo, ta lo?!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ming Yesus siut ela kon, muik guru agama deeh aa noan, “Paap Guru in situ ka, toman isi.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Deng oras na kon, muik tahan atuli at mes lo kon, man brain pait le keket Yesus, lole muik tahan in haup le kiu nahu Una lo. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hidi nam, Yesus tui atuli las nabael se Um in Kohe-kanas Tene ka. Kon Un ketan bali oen noan, “Muid mi in nangan na lam, elola? Guru agama las tui noan, Kristus na mo, Atuling man Ama Lamtua Allah in tulu meman son deng hmunan hesa kua ka. Muid one lam, Un suma laih Daud in hua-koet tuun. Mo na nol lo bii. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Undeng hmunan nu laih Daud esa man dul ne buk in Naka-Nahalit ta dalen noan, ‘Ama Lamtua Allah tek auk Tuang nga son noan, “Maa, le daad se maan in todan dudui kia, se Auk halin kanan nia. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ta mam Auk tao Ku musu las, didiin oen suda se Ku.” ’ ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Deng in dula na lam, kit tana noan, laih Daud esa haman Kristus sam, ‘Tuang’. Nahin na elia: eta atuli noan Kristus nam suma laih Daud in hua-koet tuun nam, nol lo bii! Undeng Un na mo kon daid laih Daud Tuang!” ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Dedeng atuli las totoang tidi hngilan le hii se Yesus sam, Un aa nol ima-ii las noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mi musti doha-doh nol guru agama las. Ta oen kom in lako-pait nol pake kaod blatas in pel-koos, le lakos tutnaal atuil hut mamo kas, halin nam atuli las netas noan, ‘Hoe! Oen na mo atuil tene ko.’ Guru agama nias taom kom in nuting maan in todan dudui, se um in kohe-kanas sas, se fesat, nol se maan in muik atuli mamo nakbua. ");
INSERT INTO hegNTpo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mo doha-doha, ta oen taan in nole-lilung bebalu kas le nuhu-dau nal oen uma las. Mo se atuil hut mamo sila kam, oen buba kele oen in daat tas nini in dil kohe-kanas nesa-nesang. Oen in koma ka le atuli aa noan, oen nam atuil in parsai. Mo Ama Lamtua taan oen in kula ka, tiata mam Un beles hukung ngele dui.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Dedeng Yesus tui atuli las se Um in Kohe-kanas Tene ka ka, Un ngat net atuil in muki ngas maas tamang kolete se kaban derma la. ");
INSERT INTO hegNTpo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Un kon net bebalu kasiang mes maa kohe-kanas baab se na kon. Un tamang duit seng dua se kaban na. Duit na osa ka ana dui. ");
INSERT INTO hegNTpo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kon nam Yesus aa nol Un ima-ii las noan, “Hii babanan ne! Bebalu kasiang ni suma tamang duit seng dua siis, mo un in bele na, mamo dui deng totoang atuli las. ");
INSERT INTO hegNTpo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Atuil tenga las tamang kolete deng oen duit lisin nas. Mo bebalu nia lam, un bel toang un duit tas son na. Molota, duit na taung un in nuli ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Dedeng na, Yesus ima-ii las aa le naka-naka Um in Kohe-kanas Tene ka noan, “Papa! Ngat soba-naan Um ni in leko ni le! Oen daek un nini batu-baut leko man tene dui, nol todes ti-titu. Hidim muik atuli in bel sa-saa osa, le lohas nini Ama Lamtua Uma lia!” Mo Yesus situs noan, ");
INSERT INTO hegNTpo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Um ni meman leko. Mo nesang lo ka kam, atuli las tao lean baut nias totoang, didiin tatai nol dale ka.” ");
INSERT INTO hegNTpo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hidi nam Yesus ima-ii las keket noan, “Paap Guru! Asa man Paap in aa apin na, nataka le bling dadi la? Eta un oras sa dadani son nam, un tada-tada las elola la?” ");
INSERT INTO hegNTpo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kon Yesus siut noan, “Sadi mi doh babanan le tom in nole deken. Ta mam muik atuli mamo maas teh kalas, le tek noan, ‘Auk niam, Kristus.’ Tenga las pait tek noan, ‘Leol kiamat ta maa dadani son!’ Mo mi parsai deken! ");
INSERT INTO hegN